/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef	_SYS_KICONV_GB18030_UTF8_H
#define	_SYS_KICONV_GB18030_UTF8_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/* Maximum mapping number from GB18030 2 bytes character to UTF-8. */
#define	KICONV_GBK_UTF8_MAX		(23941)

/* Maximum mapping number from GB18030 4 bytes character to UTF-8. */
#define	KICONV_GBK4_UTF8_MAX		(39421)

static kiconv_table_array_t kiconv_gbk_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0x8140,	{ 0xE4, 0xB8, 0x82 },
	0x8141,	{ 0xE4, 0xB8, 0x84 },
	0x8142,	{ 0xE4, 0xB8, 0x85 },
	0x8143,	{ 0xE4, 0xB8, 0x86 },
	0x8144,	{ 0xE4, 0xB8, 0x8F },
	0x8145,	{ 0xE4, 0xB8, 0x92 },
	0x8146,	{ 0xE4, 0xB8, 0x97 },
	0x8147,	{ 0xE4, 0xB8, 0x9F },
	0x8148,	{ 0xE4, 0xB8, 0xA0 },
	0x8149,	{ 0xE4, 0xB8, 0xA1 },
	0x814A,	{ 0xE4, 0xB8, 0xA3 },
	0x814B,	{ 0xE4, 0xB8, 0xA6 },
	0x814C,	{ 0xE4, 0xB8, 0xA9 },
	0x814D,	{ 0xE4, 0xB8, 0xAE },
	0x814E,	{ 0xE4, 0xB8, 0xAF },
	0x814F,	{ 0xE4, 0xB8, 0xB1 },
	0x8150,	{ 0xE4, 0xB8, 0xB3 },
	0x8151,	{ 0xE4, 0xB8, 0xB5 },
	0x8152,	{ 0xE4, 0xB8, 0xB7 },
	0x8153,	{ 0xE4, 0xB8, 0xBC },
	0x8154,	{ 0xE4, 0xB9, 0x80 },
	0x8155,	{ 0xE4, 0xB9, 0x81 },
	0x8156,	{ 0xE4, 0xB9, 0x82 },
	0x8157,	{ 0xE4, 0xB9, 0x84 },
	0x8158,	{ 0xE4, 0xB9, 0x86 },
	0x8159,	{ 0xE4, 0xB9, 0x8A },
	0x815A,	{ 0xE4, 0xB9, 0x91 },
	0x815B,	{ 0xE4, 0xB9, 0x95 },
	0x815C,	{ 0xE4, 0xB9, 0x97 },
	0x815D,	{ 0xE4, 0xB9, 0x9A },
	0x815E,	{ 0xE4, 0xB9, 0x9B },
	0x815F,	{ 0xE4, 0xB9, 0xA2 },
	0x8160,	{ 0xE4, 0xB9, 0xA3 },
	0x8161,	{ 0xE4, 0xB9, 0xA4 },
	0x8162,	{ 0xE4, 0xB9, 0xA5 },
	0x8163,	{ 0xE4, 0xB9, 0xA7 },
	0x8164,	{ 0xE4, 0xB9, 0xA8 },
	0x8165,	{ 0xE4, 0xB9, 0xAA },
	0x8166,	{ 0xE4, 0xB9, 0xAB },
	0x8167,	{ 0xE4, 0xB9, 0xAC },
	0x8168,	{ 0xE4, 0xB9, 0xAD },
	0x8169,	{ 0xE4, 0xB9, 0xAE },
	0x816A,	{ 0xE4, 0xB9, 0xAF },
	0x816B,	{ 0xE4, 0xB9, 0xB2 },
	0x816C,	{ 0xE4, 0xB9, 0xB4 },
	0x816D,	{ 0xE4, 0xB9, 0xB5 },
	0x816E,	{ 0xE4, 0xB9, 0xB6 },
	0x816F,	{ 0xE4, 0xB9, 0xB7 },
	0x8170,	{ 0xE4, 0xB9, 0xB8 },
	0x8171,	{ 0xE4, 0xB9, 0xB9 },
	0x8172,	{ 0xE4, 0xB9, 0xBA },
	0x8173,	{ 0xE4, 0xB9, 0xBB },
	0x8174,	{ 0xE4, 0xB9, 0xBC },
	0x8175,	{ 0xE4, 0xB9, 0xBD },
	0x8176,	{ 0xE4, 0xB9, 0xBF },
	0x8177,	{ 0xE4, 0xBA, 0x80 },
	0x8178,	{ 0xE4, 0xBA, 0x81 },
	0x8179,	{ 0xE4, 0xBA, 0x82 },
	0x817A,	{ 0xE4, 0xBA, 0x83 },
	0x817B,	{ 0xE4, 0xBA, 0x84 },
	0x817C,	{ 0xE4, 0xBA, 0x85 },
	0x817D,	{ 0xE4, 0xBA, 0x87 },
	0x817E,	{ 0xE4, 0xBA, 0x8A },
	0x8180,	{ 0xE4, 0xBA, 0x90 },
	0x8181,	{ 0xE4, 0xBA, 0x96 },
	0x8182,	{ 0xE4, 0xBA, 0x97 },
	0x8183,	{ 0xE4, 0xBA, 0x99 },
	0x8184,	{ 0xE4, 0xBA, 0x9C },
	0x8185,	{ 0xE4, 0xBA, 0x9D },
	0x8186,	{ 0xE4, 0xBA, 0x9E },
	0x8187,	{ 0xE4, 0xBA, 0xA3 },
	0x8188,	{ 0xE4, 0xBA, 0xAA },
	0x8189,	{ 0xE4, 0xBA, 0xAF },
	0x818A,	{ 0xE4, 0xBA, 0xB0 },
	0x818B,	{ 0xE4, 0xBA, 0xB1 },
	0x818C,	{ 0xE4, 0xBA, 0xB4 },
	0x818D,	{ 0xE4, 0xBA, 0xB6 },
	0x818E,	{ 0xE4, 0xBA, 0xB7 },
	0x818F,	{ 0xE4, 0xBA, 0xB8 },
	0x8190,	{ 0xE4, 0xBA, 0xB9 },
	0x8191,	{ 0xE4, 0xBA, 0xBC },
	0x8192,	{ 0xE4, 0xBA, 0xBD },
	0x8193,	{ 0xE4, 0xBA, 0xBE },
	0x8194,	{ 0xE4, 0xBB, 0x88 },
	0x8195,	{ 0xE4, 0xBB, 0x8C },
	0x8196,	{ 0xE4, 0xBB, 0x8F },
	0x8197,	{ 0xE4, 0xBB, 0x90 },
	0x8198,	{ 0xE4, 0xBB, 0x92 },
	0x8199,	{ 0xE4, 0xBB, 0x9A },
	0x819A,	{ 0xE4, 0xBB, 0x9B },
	0x819B,	{ 0xE4, 0xBB, 0x9C },
	0x819C,	{ 0xE4, 0xBB, 0xA0 },
	0x819D,	{ 0xE4, 0xBB, 0xA2 },
	0x819E,	{ 0xE4, 0xBB, 0xA6 },
	0x819F,	{ 0xE4, 0xBB, 0xA7 },
	0x81A0,	{ 0xE4, 0xBB, 0xA9 },
	0x81A1,	{ 0xE4, 0xBB, 0xAD },
	0x81A2,	{ 0xE4, 0xBB, 0xAE },
	0x81A3,	{ 0xE4, 0xBB, 0xAF },
	0x81A4,	{ 0xE4, 0xBB, 0xB1 },
	0x81A5,	{ 0xE4, 0xBB, 0xB4 },
	0x81A6,	{ 0xE4, 0xBB, 0xB8 },
	0x81A7,	{ 0xE4, 0xBB, 0xB9 },
	0x81A8,	{ 0xE4, 0xBB, 0xBA },
	0x81A9,	{ 0xE4, 0xBB, 0xBC },
	0x81AA,	{ 0xE4, 0xBB, 0xBE },
	0x81AB,	{ 0xE4, 0xBC, 0x80 },
	0x81AC,	{ 0xE4, 0xBC, 0x82 },
	0x81AD,	{ 0xE4, 0xBC, 0x83 },
	0x81AE,	{ 0xE4, 0xBC, 0x84 },
	0x81AF,	{ 0xE4, 0xBC, 0x85 },
	0x81B0,	{ 0xE4, 0xBC, 0x86 },
	0x81B1,	{ 0xE4, 0xBC, 0x87 },
	0x81B2,	{ 0xE4, 0xBC, 0x88 },
	0x81B3,	{ 0xE4, 0xBC, 0x8B },
	0x81B4,	{ 0xE4, 0xBC, 0x8C },
	0x81B5,	{ 0xE4, 0xBC, 0x92 },
	0x81B6,	{ 0xE4, 0xBC, 0x93 },
	0x81B7,	{ 0xE4, 0xBC, 0x94 },
	0x81B8,	{ 0xE4, 0xBC, 0x95 },
	0x81B9,	{ 0xE4, 0xBC, 0x96 },
	0x81BA,	{ 0xE4, 0xBC, 0x9C },
	0x81BB,	{ 0xE4, 0xBC, 0x9D },
	0x81BC,	{ 0xE4, 0xBC, 0xA1 },
	0x81BD,	{ 0xE4, 0xBC, 0xA3 },
	0x81BE,	{ 0xE4, 0xBC, 0xA8 },
	0x81BF,	{ 0xE4, 0xBC, 0xA9 },
	0x81C0,	{ 0xE4, 0xBC, 0xAC },
	0x81C1,	{ 0xE4, 0xBC, 0xAD },
	0x81C2,	{ 0xE4, 0xBC, 0xAE },
	0x81C3,	{ 0xE4, 0xBC, 0xB1 },
	0x81C4,	{ 0xE4, 0xBC, 0xB3 },
	0x81C5,	{ 0xE4, 0xBC, 0xB5 },
	0x81C6,	{ 0xE4, 0xBC, 0xB7 },
	0x81C7,	{ 0xE4, 0xBC, 0xB9 },
	0x81C8,	{ 0xE4, 0xBC, 0xBB },
	0x81C9,	{ 0xE4, 0xBC, 0xBE },
	0x81CA,	{ 0xE4, 0xBC, 0xBF },
	0x81CB,	{ 0xE4, 0xBD, 0x80 },
	0x81CC,	{ 0xE4, 0xBD, 0x81 },
	0x81CD,	{ 0xE4, 0xBD, 0x82 },
	0x81CE,	{ 0xE4, 0xBD, 0x84 },
	0x81CF,	{ 0xE4, 0xBD, 0x85 },
	0x81D0,	{ 0xE4, 0xBD, 0x87 },
	0x81D1,	{ 0xE4, 0xBD, 0x88 },
	0x81D2,	{ 0xE4, 0xBD, 0x89 },
	0x81D3,	{ 0xE4, 0xBD, 0x8A },
	0x81D4,	{ 0xE4, 0xBD, 0x8B },
	0x81D5,	{ 0xE4, 0xBD, 0x8C },
	0x81D6,	{ 0xE4, 0xBD, 0x92 },
	0x81D7,	{ 0xE4, 0xBD, 0x94 },
	0x81D8,	{ 0xE4, 0xBD, 0x96 },
	0x81D9,	{ 0xE4, 0xBD, 0xA1 },
	0x81DA,	{ 0xE4, 0xBD, 0xA2 },
	0x81DB,	{ 0xE4, 0xBD, 0xA6 },
	0x81DC,	{ 0xE4, 0xBD, 0xA8 },
	0x81DD,	{ 0xE4, 0xBD, 0xAA },
	0x81DE,	{ 0xE4, 0xBD, 0xAB },
	0x81DF,	{ 0xE4, 0xBD, 0xAD },
	0x81E0,	{ 0xE4, 0xBD, 0xAE },
	0x81E1,	{ 0xE4, 0xBD, 0xB1 },
	0x81E2,	{ 0xE4, 0xBD, 0xB2 },
	0x81E3,	{ 0xE4, 0xBD, 0xB5 },
	0x81E4,	{ 0xE4, 0xBD, 0xB7 },
	0x81E5,	{ 0xE4, 0xBD, 0xB8 },
	0x81E6,	{ 0xE4, 0xBD, 0xB9 },
	0x81E7,	{ 0xE4, 0xBD, 0xBA },
	0x81E8,	{ 0xE4, 0xBD, 0xBD },
	0x81E9,	{ 0xE4, 0xBE, 0x80 },
	0x81EA,	{ 0xE4, 0xBE, 0x81 },
	0x81EB,	{ 0xE4, 0xBE, 0x82 },
	0x81EC,	{ 0xE4, 0xBE, 0x85 },
	0x81ED,	{ 0xE4, 0xBE, 0x86 },
	0x81EE,	{ 0xE4, 0xBE, 0x87 },
	0x81EF,	{ 0xE4, 0xBE, 0x8A },
	0x81F0,	{ 0xE4, 0xBE, 0x8C },
	0x81F1,	{ 0xE4, 0xBE, 0x8E },
	0x81F2,	{ 0xE4, 0xBE, 0x90 },
	0x81F3,	{ 0xE4, 0xBE, 0x92 },
	0x81F4,	{ 0xE4, 0xBE, 0x93 },
	0x81F5,	{ 0xE4, 0xBE, 0x95 },
	0x81F6,	{ 0xE4, 0xBE, 0x96 },
	0x81F7,	{ 0xE4, 0xBE, 0x98 },
	0x81F8,	{ 0xE4, 0xBE, 0x99 },
	0x81F9,	{ 0xE4, 0xBE, 0x9A },
	0x81FA,	{ 0xE4, 0xBE, 0x9C },
	0x81FB,	{ 0xE4, 0xBE, 0x9E },
	0x81FC,	{ 0xE4, 0xBE, 0x9F },
	0x81FD,	{ 0xE4, 0xBE, 0xA1 },
	0x81FE,	{ 0xE4, 0xBE, 0xA2 },
	0x8240,	{ 0xE4, 0xBE, 0xA4 },
	0x8241,	{ 0xE4, 0xBE, 0xAB },
	0x8242,	{ 0xE4, 0xBE, 0xAD },
	0x8243,	{ 0xE4, 0xBE, 0xB0 },
	0x8244,	{ 0xE4, 0xBE, 0xB1 },
	0x8245,	{ 0xE4, 0xBE, 0xB2 },
	0x8246,	{ 0xE4, 0xBE, 0xB3 },
	0x8247,	{ 0xE4, 0xBE, 0xB4 },
	0x8248,	{ 0xE4, 0xBE, 0xB6 },
	0x8249,	{ 0xE4, 0xBE, 0xB7 },
	0x824A,	{ 0xE4, 0xBE, 0xB8 },
	0x824B,	{ 0xE4, 0xBE, 0xB9 },
	0x824C,	{ 0xE4, 0xBE, 0xBA },
	0x824D,	{ 0xE4, 0xBE, 0xBB },
	0x824E,	{ 0xE4, 0xBE, 0xBC },
	0x824F,	{ 0xE4, 0xBE, 0xBD },
	0x8250,	{ 0xE4, 0xBE, 0xBE },
	0x8251,	{ 0xE4, 0xBF, 0x80 },
	0x8252,	{ 0xE4, 0xBF, 0x81 },
	0x8253,	{ 0xE4, 0xBF, 0x82 },
	0x8254,	{ 0xE4, 0xBF, 0x86 },
	0x8255,	{ 0xE4, 0xBF, 0x87 },
	0x8256,	{ 0xE4, 0xBF, 0x88 },
	0x8257,	{ 0xE4, 0xBF, 0x89 },
	0x8258,	{ 0xE4, 0xBF, 0x8B },
	0x8259,	{ 0xE4, 0xBF, 0x8C },
	0x825A,	{ 0xE4, 0xBF, 0x8D },
	0x825B,	{ 0xE4, 0xBF, 0x92 },
	0x825C,	{ 0xE4, 0xBF, 0x93 },
	0x825D,	{ 0xE4, 0xBF, 0x94 },
	0x825E,	{ 0xE4, 0xBF, 0x95 },
	0x825F,	{ 0xE4, 0xBF, 0x96 },
	0x8260,	{ 0xE4, 0xBF, 0x99 },
	0x8261,	{ 0xE4, 0xBF, 0x9B },
	0x8262,	{ 0xE4, 0xBF, 0xA0 },
	0x8263,	{ 0xE4, 0xBF, 0xA2 },
	0x8264,	{ 0xE4, 0xBF, 0xA4 },
	0x8265,	{ 0xE4, 0xBF, 0xA5 },
	0x8266,	{ 0xE4, 0xBF, 0xA7 },
	0x8267,	{ 0xE4, 0xBF, 0xAB },
	0x8268,	{ 0xE4, 0xBF, 0xAC },
	0x8269,	{ 0xE4, 0xBF, 0xB0 },
	0x826A,	{ 0xE4, 0xBF, 0xB2 },
	0x826B,	{ 0xE4, 0xBF, 0xB4 },
	0x826C,	{ 0xE4, 0xBF, 0xB5 },
	0x826D,	{ 0xE4, 0xBF, 0xB6 },
	0x826E,	{ 0xE4, 0xBF, 0xB7 },
	0x826F,	{ 0xE4, 0xBF, 0xB9 },
	0x8270,	{ 0xE4, 0xBF, 0xBB },
	0x8271,	{ 0xE4, 0xBF, 0xBC },
	0x8272,	{ 0xE4, 0xBF, 0xBD },
	0x8273,	{ 0xE4, 0xBF, 0xBF },
	0x8274,	{ 0xE5, 0x80, 0x80 },
	0x8275,	{ 0xE5, 0x80, 0x81 },
	0x8276,	{ 0xE5, 0x80, 0x82 },
	0x8277,	{ 0xE5, 0x80, 0x83 },
	0x8278,	{ 0xE5, 0x80, 0x84 },
	0x8279,	{ 0xE5, 0x80, 0x85 },
	0x827A,	{ 0xE5, 0x80, 0x86 },
	0x827B,	{ 0xE5, 0x80, 0x87 },
	0x827C,	{ 0xE5, 0x80, 0x88 },
	0x827D,	{ 0xE5, 0x80, 0x89 },
	0x827E,	{ 0xE5, 0x80, 0x8A },
	0x8280,	{ 0xE5, 0x80, 0x8B },
	0x8281,	{ 0xE5, 0x80, 0x8E },
	0x8282,	{ 0xE5, 0x80, 0x90 },
	0x8283,	{ 0xE5, 0x80, 0x91 },
	0x8284,	{ 0xE5, 0x80, 0x93 },
	0x8285,	{ 0xE5, 0x80, 0x95 },
	0x8286,	{ 0xE5, 0x80, 0x96 },
	0x8287,	{ 0xE5, 0x80, 0x97 },
	0x8288,	{ 0xE5, 0x80, 0x9B },
	0x8289,	{ 0xE5, 0x80, 0x9D },
	0x828A,	{ 0xE5, 0x80, 0x9E },
	0x828B,	{ 0xE5, 0x80, 0xA0 },
	0x828C,	{ 0xE5, 0x80, 0xA2 },
	0x828D,	{ 0xE5, 0x80, 0xA3 },
	0x828E,	{ 0xE5, 0x80, 0xA4 },
	0x828F,	{ 0xE5, 0x80, 0xA7 },
	0x8290,	{ 0xE5, 0x80, 0xAB },
	0x8291,	{ 0xE5, 0x80, 0xAF },
	0x8292,	{ 0xE5, 0x80, 0xB0 },
	0x8293,	{ 0xE5, 0x80, 0xB1 },
	0x8294,	{ 0xE5, 0x80, 0xB2 },
	0x8295,	{ 0xE5, 0x80, 0xB3 },
	0x8296,	{ 0xE5, 0x80, 0xB4 },
	0x8297,	{ 0xE5, 0x80, 0xB5 },
	0x8298,	{ 0xE5, 0x80, 0xB6 },
	0x8299,	{ 0xE5, 0x80, 0xB7 },
	0x829A,	{ 0xE5, 0x80, 0xB8 },
	0x829B,	{ 0xE5, 0x80, 0xB9 },
	0x829C,	{ 0xE5, 0x80, 0xBB },
	0x829D,	{ 0xE5, 0x80, 0xBD },
	0x829E,	{ 0xE5, 0x80, 0xBF },
	0x829F,	{ 0xE5, 0x81, 0x80 },
	0x82A0,	{ 0xE5, 0x81, 0x81 },
	0x82A1,	{ 0xE5, 0x81, 0x82 },
	0x82A2,	{ 0xE5, 0x81, 0x84 },
	0x82A3,	{ 0xE5, 0x81, 0x85 },
	0x82A4,	{ 0xE5, 0x81, 0x86 },
	0x82A5,	{ 0xE5, 0x81, 0x89 },
	0x82A6,	{ 0xE5, 0x81, 0x8A },
	0x82A7,	{ 0xE5, 0x81, 0x8B },
	0x82A8,	{ 0xE5, 0x81, 0x8D },
	0x82A9,	{ 0xE5, 0x81, 0x90 },
	0x82AA,	{ 0xE5, 0x81, 0x91 },
	0x82AB,	{ 0xE5, 0x81, 0x92 },
	0x82AC,	{ 0xE5, 0x81, 0x93 },
	0x82AD,	{ 0xE5, 0x81, 0x94 },
	0x82AE,	{ 0xE5, 0x81, 0x96 },
	0x82AF,	{ 0xE5, 0x81, 0x97 },
	0x82B0,	{ 0xE5, 0x81, 0x98 },
	0x82B1,	{ 0xE5, 0x81, 0x99 },
	0x82B2,	{ 0xE5, 0x81, 0x9B },
	0x82B3,	{ 0xE5, 0x81, 0x9D },
	0x82B4,	{ 0xE5, 0x81, 0x9E },
	0x82B5,	{ 0xE5, 0x81, 0x9F },
	0x82B6,	{ 0xE5, 0x81, 0xA0 },
	0x82B7,	{ 0xE5, 0x81, 0xA1 },
	0x82B8,	{ 0xE5, 0x81, 0xA2 },
	0x82B9,	{ 0xE5, 0x81, 0xA3 },
	0x82BA,	{ 0xE5, 0x81, 0xA4 },
	0x82BB,	{ 0xE5, 0x81, 0xA6 },
	0x82BC,	{ 0xE5, 0x81, 0xA7 },
	0x82BD,	{ 0xE5, 0x81, 0xA8 },
	0x82BE,	{ 0xE5, 0x81, 0xA9 },
	0x82BF,	{ 0xE5, 0x81, 0xAA },
	0x82C0,	{ 0xE5, 0x81, 0xAB },
	0x82C1,	{ 0xE5, 0x81, 0xAD },
	0x82C2,	{ 0xE5, 0x81, 0xAE },
	0x82C3,	{ 0xE5, 0x81, 0xAF },
	0x82C4,	{ 0xE5, 0x81, 0xB0 },
	0x82C5,	{ 0xE5, 0x81, 0xB1 },
	0x82C6,	{ 0xE5, 0x81, 0xB2 },
	0x82C7,	{ 0xE5, 0x81, 0xB3 },
	0x82C8,	{ 0xE5, 0x81, 0xB4 },
	0x82C9,	{ 0xE5, 0x81, 0xB5 },
	0x82CA,	{ 0xE5, 0x81, 0xB8 },
	0x82CB,	{ 0xE5, 0x81, 0xB9 },
	0x82CC,	{ 0xE5, 0x81, 0xBA },
	0x82CD,	{ 0xE5, 0x81, 0xBC },
	0x82CE,	{ 0xE5, 0x81, 0xBD },
	0x82CF,	{ 0xE5, 0x82, 0x81 },
	0x82D0,	{ 0xE5, 0x82, 0x82 },
	0x82D1,	{ 0xE5, 0x82, 0x83 },
	0x82D2,	{ 0xE5, 0x82, 0x84 },
	0x82D3,	{ 0xE5, 0x82, 0x86 },
	0x82D4,	{ 0xE5, 0x82, 0x87 },
	0x82D5,	{ 0xE5, 0x82, 0x89 },
	0x82D6,	{ 0xE5, 0x82, 0x8A },
	0x82D7,	{ 0xE5, 0x82, 0x8B },
	0x82D8,	{ 0xE5, 0x82, 0x8C },
	0x82D9,	{ 0xE5, 0x82, 0x8E },
	0x82DA,	{ 0xE5, 0x82, 0x8F },
	0x82DB,	{ 0xE5, 0x82, 0x90 },
	0x82DC,	{ 0xE5, 0x82, 0x91 },
	0x82DD,	{ 0xE5, 0x82, 0x92 },
	0x82DE,	{ 0xE5, 0x82, 0x93 },
	0x82DF,	{ 0xE5, 0x82, 0x94 },
	0x82E0,	{ 0xE5, 0x82, 0x95 },
	0x82E1,	{ 0xE5, 0x82, 0x96 },
	0x82E2,	{ 0xE5, 0x82, 0x97 },
	0x82E3,	{ 0xE5, 0x82, 0x98 },
	0x82E4,	{ 0xE5, 0x82, 0x99 },
	0x82E5,	{ 0xE5, 0x82, 0x9A },
	0x82E6,	{ 0xE5, 0x82, 0x9B },
	0x82E7,	{ 0xE5, 0x82, 0x9C },
	0x82E8,	{ 0xE5, 0x82, 0x9D },
	0x82E9,	{ 0xE5, 0x82, 0x9E },
	0x82EA,	{ 0xE5, 0x82, 0x9F },
	0x82EB,	{ 0xE5, 0x82, 0xA0 },
	0x82EC,	{ 0xE5, 0x82, 0xA1 },
	0x82ED,	{ 0xE5, 0x82, 0xA2 },
	0x82EE,	{ 0xE5, 0x82, 0xA4 },
	0x82EF,	{ 0xE5, 0x82, 0xA6 },
	0x82F0,	{ 0xE5, 0x82, 0xAA },
	0x82F1,	{ 0xE5, 0x82, 0xAB },
	0x82F2,	{ 0xE5, 0x82, 0xAD },
	0x82F3,	{ 0xE5, 0x82, 0xAE },
	0x82F4,	{ 0xE5, 0x82, 0xAF },
	0x82F5,	{ 0xE5, 0x82, 0xB0 },
	0x82F6,	{ 0xE5, 0x82, 0xB1 },
	0x82F7,	{ 0xE5, 0x82, 0xB3 },
	0x82F8,	{ 0xE5, 0x82, 0xB4 },
	0x82F9,	{ 0xE5, 0x82, 0xB5 },
	0x82FA,	{ 0xE5, 0x82, 0xB6 },
	0x82FB,	{ 0xE5, 0x82, 0xB7 },
	0x82FC,	{ 0xE5, 0x82, 0xB8 },
	0x82FD,	{ 0xE5, 0x82, 0xB9 },
	0x82FE,	{ 0xE5, 0x82, 0xBC },
	0x8340,	{ 0xE5, 0x82, 0xBD },
	0x8341,	{ 0xE5, 0x82, 0xBE },
	0x8342,	{ 0xE5, 0x82, 0xBF },
	0x8343,	{ 0xE5, 0x83, 0x80 },
	0x8344,	{ 0xE5, 0x83, 0x81 },
	0x8345,	{ 0xE5, 0x83, 0x82 },
	0x8346,	{ 0xE5, 0x83, 0x83 },
	0x8347,	{ 0xE5, 0x83, 0x84 },
	0x8348,	{ 0xE5, 0x83, 0x85 },
	0x8349,	{ 0xE5, 0x83, 0x86 },
	0x834A,	{ 0xE5, 0x83, 0x87 },
	0x834B,	{ 0xE5, 0x83, 0x88 },
	0x834C,	{ 0xE5, 0x83, 0x89 },
	0x834D,	{ 0xE5, 0x83, 0x8A },
	0x834E,	{ 0xE5, 0x83, 0x8B },
	0x834F,	{ 0xE5, 0x83, 0x8C },
	0x8350,	{ 0xE5, 0x83, 0x8D },
	0x8351,	{ 0xE5, 0x83, 0x8E },
	0x8352,	{ 0xE5, 0x83, 0x90 },
	0x8353,	{ 0xE5, 0x83, 0x91 },
	0x8354,	{ 0xE5, 0x83, 0x92 },
	0x8355,	{ 0xE5, 0x83, 0x93 },
	0x8356,	{ 0xE5, 0x83, 0x94 },
	0x8357,	{ 0xE5, 0x83, 0x95 },
	0x8358,	{ 0xE5, 0x83, 0x97 },
	0x8359,	{ 0xE5, 0x83, 0x98 },
	0x835A,	{ 0xE5, 0x83, 0x99 },
	0x835B,	{ 0xE5, 0x83, 0x9B },
	0x835C,	{ 0xE5, 0x83, 0x9C },
	0x835D,	{ 0xE5, 0x83, 0x9D },
	0x835E,	{ 0xE5, 0x83, 0x9E },
	0x835F,	{ 0xE5, 0x83, 0x9F },
	0x8360,	{ 0xE5, 0x83, 0xA0 },
	0x8361,	{ 0xE5, 0x83, 0xA1 },
	0x8362,	{ 0xE5, 0x83, 0xA2 },
	0x8363,	{ 0xE5, 0x83, 0xA3 },
	0x8364,	{ 0xE5, 0x83, 0xA4 },
	0x8365,	{ 0xE5, 0x83, 0xA5 },
	0x8366,	{ 0xE5, 0x83, 0xA8 },
	0x8367,	{ 0xE5, 0x83, 0xA9 },
	0x8368,	{ 0xE5, 0x83, 0xAA },
	0x8369,	{ 0xE5, 0x83, 0xAB },
	0x836A,	{ 0xE5, 0x83, 0xAF },
	0x836B,	{ 0xE5, 0x83, 0xB0 },
	0x836C,	{ 0xE5, 0x83, 0xB1 },
	0x836D,	{ 0xE5, 0x83, 0xB2 },
	0x836E,	{ 0xE5, 0x83, 0xB4 },
	0x836F,	{ 0xE5, 0x83, 0xB6 },
	0x8370,	{ 0xE5, 0x83, 0xB7 },
	0x8371,	{ 0xE5, 0x83, 0xB8 },
	0x8372,	{ 0xE5, 0x83, 0xB9 },
	0x8373,	{ 0xE5, 0x83, 0xBA },
	0x8374,	{ 0xE5, 0x83, 0xBC },
	0x8375,	{ 0xE5, 0x83, 0xBD },
	0x8376,	{ 0xE5, 0x83, 0xBE },
	0x8377,	{ 0xE5, 0x83, 0xBF },
	0x8378,	{ 0xE5, 0x84, 0x80 },
	0x8379,	{ 0xE5, 0x84, 0x81 },
	0x837A,	{ 0xE5, 0x84, 0x82 },
	0x837B,	{ 0xE5, 0x84, 0x83 },
	0x837C,	{ 0xE5, 0x84, 0x84 },
	0x837D,	{ 0xE5, 0x84, 0x85 },
	0x837E,	{ 0xE5, 0x84, 0x88 },
	0x8380,	{ 0xE5, 0x84, 0x89 },
	0x8381,	{ 0xE5, 0x84, 0x8A },
	0x8382,	{ 0xE5, 0x84, 0x8C },
	0x8383,	{ 0xE5, 0x84, 0x8D },
	0x8384,	{ 0xE5, 0x84, 0x8E },
	0x8385,	{ 0xE5, 0x84, 0x8F },
	0x8386,	{ 0xE5, 0x84, 0x90 },
	0x8387,	{ 0xE5, 0x84, 0x91 },
	0x8388,	{ 0xE5, 0x84, 0x93 },
	0x8389,	{ 0xE5, 0x84, 0x94 },
	0x838A,	{ 0xE5, 0x84, 0x95 },
	0x838B,	{ 0xE5, 0x84, 0x96 },
	0x838C,	{ 0xE5, 0x84, 0x97 },
	0x838D,	{ 0xE5, 0x84, 0x98 },
	0x838E,	{ 0xE5, 0x84, 0x99 },
	0x838F,	{ 0xE5, 0x84, 0x9A },
	0x8390,	{ 0xE5, 0x84, 0x9B },
	0x8391,	{ 0xE5, 0x84, 0x9C },
	0x8392,	{ 0xE5, 0x84, 0x9D },
	0x8393,	{ 0xE5, 0x84, 0x9E },
	0x8394,	{ 0xE5, 0x84, 0x9F },
	0x8395,	{ 0xE5, 0x84, 0xA0 },
	0x8396,	{ 0xE5, 0x84, 0xA2 },
	0x8397,	{ 0xE5, 0x84, 0xA3 },
	0x8398,	{ 0xE5, 0x84, 0xA4 },
	0x8399,	{ 0xE5, 0x84, 0xA5 },
	0x839A,	{ 0xE5, 0x84, 0xA6 },
	0x839B,	{ 0xE5, 0x84, 0xA7 },
	0x839C,	{ 0xE5, 0x84, 0xA8 },
	0x839D,	{ 0xE5, 0x84, 0xA9 },
	0x839E,	{ 0xE5, 0x84, 0xAA },
	0x839F,	{ 0xE5, 0x84, 0xAB },
	0x83A0,	{ 0xE5, 0x84, 0xAC },
	0x83A1,	{ 0xE5, 0x84, 0xAD },
	0x83A2,	{ 0xE5, 0x84, 0xAE },
	0x83A3,	{ 0xE5, 0x84, 0xAF },
	0x83A4,	{ 0xE5, 0x84, 0xB0 },
	0x83A5,	{ 0xE5, 0x84, 0xB1 },
	0x83A6,	{ 0xE5, 0x84, 0xB2 },
	0x83A7,	{ 0xE5, 0x84, 0xB3 },
	0x83A8,	{ 0xE5, 0x84, 0xB4 },
	0x83A9,	{ 0xE5, 0x84, 0xB5 },
	0x83AA,	{ 0xE5, 0x84, 0xB6 },
	0x83AB,	{ 0xE5, 0x84, 0xB7 },
	0x83AC,	{ 0xE5, 0x84, 0xB8 },
	0x83AD,	{ 0xE5, 0x84, 0xB9 },
	0x83AE,	{ 0xE5, 0x84, 0xBA },
	0x83AF,	{ 0xE5, 0x84, 0xBB },
	0x83B0,	{ 0xE5, 0x84, 0xBC },
	0x83B1,	{ 0xE5, 0x84, 0xBD },
	0x83B2,	{ 0xE5, 0x84, 0xBE },
	0x83B3,	{ 0xE5, 0x85, 0x82 },
	0x83B4,	{ 0xE5, 0x85, 0x87 },
	0x83B5,	{ 0xE5, 0x85, 0x8A },
	0x83B6,	{ 0xE5, 0x85, 0x8C },
	0x83B7,	{ 0xE5, 0x85, 0x8E },
	0x83B8,	{ 0xE5, 0x85, 0x8F },
	0x83B9,	{ 0xE5, 0x85, 0x90 },
	0x83BA,	{ 0xE5, 0x85, 0x92 },
	0x83BB,	{ 0xE5, 0x85, 0x93 },
	0x83BC,	{ 0xE5, 0x85, 0x97 },
	0x83BD,	{ 0xE5, 0x85, 0x98 },
	0x83BE,	{ 0xE5, 0x85, 0x99 },
	0x83BF,	{ 0xE5, 0x85, 0x9B },
	0x83C0,	{ 0xE5, 0x85, 0x9D },
	0x83C1,	{ 0xE5, 0x85, 0x9E },
	0x83C2,	{ 0xE5, 0x85, 0x9F },
	0x83C3,	{ 0xE5, 0x85, 0xA0 },
	0x83C4,	{ 0xE5, 0x85, 0xA1 },
	0x83C5,	{ 0xE5, 0x85, 0xA3 },
	0x83C6,	{ 0xE5, 0x85, 0xA4 },
	0x83C7,	{ 0xE5, 0x85, 0xA6 },
	0x83C8,	{ 0xE5, 0x85, 0xA7 },
	0x83C9,	{ 0xE5, 0x85, 0xA9 },
	0x83CA,	{ 0xE5, 0x85, 0xAA },
	0x83CB,	{ 0xE5, 0x85, 0xAF },
	0x83CC,	{ 0xE5, 0x85, 0xB2 },
	0x83CD,	{ 0xE5, 0x85, 0xBA },
	0x83CE,	{ 0xE5, 0x85, 0xBE },
	0x83CF,	{ 0xE5, 0x85, 0xBF },
	0x83D0,	{ 0xE5, 0x86, 0x83 },
	0x83D1,	{ 0xE5, 0x86, 0x84 },
	0x83D2,	{ 0xE5, 0x86, 0x86 },
	0x83D3,	{ 0xE5, 0x86, 0x87 },
	0x83D4,	{ 0xE5, 0x86, 0x8A },
	0x83D5,	{ 0xE5, 0x86, 0x8B },
	0x83D6,	{ 0xE5, 0x86, 0x8E },
	0x83D7,	{ 0xE5, 0x86, 0x8F },
	0x83D8,	{ 0xE5, 0x86, 0x90 },
	0x83D9,	{ 0xE5, 0x86, 0x91 },
	0x83DA,	{ 0xE5, 0x86, 0x93 },
	0x83DB,	{ 0xE5, 0x86, 0x94 },
	0x83DC,	{ 0xE5, 0x86, 0x98 },
	0x83DD,	{ 0xE5, 0x86, 0x9A },
	0x83DE,	{ 0xE5, 0x86, 0x9D },
	0x83DF,	{ 0xE5, 0x86, 0x9E },
	0x83E0,	{ 0xE5, 0x86, 0x9F },
	0x83E1,	{ 0xE5, 0x86, 0xA1 },
	0x83E2,	{ 0xE5, 0x86, 0xA3 },
	0x83E3,	{ 0xE5, 0x86, 0xA6 },
	0x83E4,	{ 0xE5, 0x86, 0xA7 },
	0x83E5,	{ 0xE5, 0x86, 0xA8 },
	0x83E6,	{ 0xE5, 0x86, 0xA9 },
	0x83E7,	{ 0xE5, 0x86, 0xAA },
	0x83E8,	{ 0xE5, 0x86, 0xAD },
	0x83E9,	{ 0xE5, 0x86, 0xAE },
	0x83EA,	{ 0xE5, 0x86, 0xB4 },
	0x83EB,	{ 0xE5, 0x86, 0xB8 },
	0x83EC,	{ 0xE5, 0x86, 0xB9 },
	0x83ED,	{ 0xE5, 0x86, 0xBA },
	0x83EE,	{ 0xE5, 0x86, 0xBE },
	0x83EF,	{ 0xE5, 0x86, 0xBF },
	0x83F0,	{ 0xE5, 0x87, 0x81 },
	0x83F1,	{ 0xE5, 0x87, 0x82 },
	0x83F2,	{ 0xE5, 0x87, 0x83 },
	0x83F3,	{ 0xE5, 0x87, 0x85 },
	0x83F4,	{ 0xE5, 0x87, 0x88 },
	0x83F5,	{ 0xE5, 0x87, 0x8A },
	0x83F6,	{ 0xE5, 0x87, 0x8D },
	0x83F7,	{ 0xE5, 0x87, 0x8E },
	0x83F8,	{ 0xE5, 0x87, 0x90 },
	0x83F9,	{ 0xE5, 0x87, 0x92 },
	0x83FA,	{ 0xE5, 0x87, 0x93 },
	0x83FB,	{ 0xE5, 0x87, 0x94 },
	0x83FC,	{ 0xE5, 0x87, 0x95 },
	0x83FD,	{ 0xE5, 0x87, 0x96 },
	0x83FE,	{ 0xE5, 0x87, 0x97 },
	0x8440,	{ 0xE5, 0x87, 0x98 },
	0x8441,	{ 0xE5, 0x87, 0x99 },
	0x8442,	{ 0xE5, 0x87, 0x9A },
	0x8443,	{ 0xE5, 0x87, 0x9C },
	0x8444,	{ 0xE5, 0x87, 0x9E },
	0x8445,	{ 0xE5, 0x87, 0x9F },
	0x8446,	{ 0xE5, 0x87, 0xA2 },
	0x8447,	{ 0xE5, 0x87, 0xA3 },
	0x8448,	{ 0xE5, 0x87, 0xA5 },
	0x8449,	{ 0xE5, 0x87, 0xA6 },
	0x844A,	{ 0xE5, 0x87, 0xA7 },
	0x844B,	{ 0xE5, 0x87, 0xA8 },
	0x844C,	{ 0xE5, 0x87, 0xA9 },
	0x844D,	{ 0xE5, 0x87, 0xAA },
	0x844E,	{ 0xE5, 0x87, 0xAC },
	0x844F,	{ 0xE5, 0x87, 0xAE },
	0x8450,	{ 0xE5, 0x87, 0xB1 },
	0x8451,	{ 0xE5, 0x87, 0xB2 },
	0x8452,	{ 0xE5, 0x87, 0xB4 },
	0x8453,	{ 0xE5, 0x87, 0xB7 },
	0x8454,	{ 0xE5, 0x87, 0xBE },
	0x8455,	{ 0xE5, 0x88, 0x84 },
	0x8456,	{ 0xE5, 0x88, 0x85 },
	0x8457,	{ 0xE5, 0x88, 0x89 },
	0x8458,	{ 0xE5, 0x88, 0x8B },
	0x8459,	{ 0xE5, 0x88, 0x8C },
	0x845A,	{ 0xE5, 0x88, 0x8F },
	0x845B,	{ 0xE5, 0x88, 0x90 },
	0x845C,	{ 0xE5, 0x88, 0x93 },
	0x845D,	{ 0xE5, 0x88, 0x94 },
	0x845E,	{ 0xE5, 0x88, 0x95 },
	0x845F,	{ 0xE5, 0x88, 0x9C },
	0x8460,	{ 0xE5, 0x88, 0x9E },
	0x8461,	{ 0xE5, 0x88, 0x9F },
	0x8462,	{ 0xE5, 0x88, 0xA1 },
	0x8463,	{ 0xE5, 0x88, 0xA2 },
	0x8464,	{ 0xE5, 0x88, 0xA3 },
	0x8465,	{ 0xE5, 0x88, 0xA5 },
	0x8466,	{ 0xE5, 0x88, 0xA6 },
	0x8467,	{ 0xE5, 0x88, 0xA7 },
	0x8468,	{ 0xE5, 0x88, 0xAA },
	0x8469,	{ 0xE5, 0x88, 0xAC },
	0x846A,	{ 0xE5, 0x88, 0xAF },
	0x846B,	{ 0xE5, 0x88, 0xB1 },
	0x846C,	{ 0xE5, 0x88, 0xB2 },
	0x846D,	{ 0xE5, 0x88, 0xB4 },
	0x846E,	{ 0xE5, 0x88, 0xB5 },
	0x846F,	{ 0xE5, 0x88, 0xBC },
	0x8470,	{ 0xE5, 0x88, 0xBE },
	0x8471,	{ 0xE5, 0x89, 0x84 },
	0x8472,	{ 0xE5, 0x89, 0x85 },
	0x8473,	{ 0xE5, 0x89, 0x86 },
	0x8474,	{ 0xE5, 0x89, 0x87 },
	0x8475,	{ 0xE5, 0x89, 0x88 },
	0x8476,	{ 0xE5, 0x89, 0x89 },
	0x8477,	{ 0xE5, 0x89, 0x8B },
	0x8478,	{ 0xE5, 0x89, 0x8E },
	0x8479,	{ 0xE5, 0x89, 0x8F },
	0x847A,	{ 0xE5, 0x89, 0x92 },
	0x847B,	{ 0xE5, 0x89, 0x93 },
	0x847C,	{ 0xE5, 0x89, 0x95 },
	0x847D,	{ 0xE5, 0x89, 0x97 },
	0x847E,	{ 0xE5, 0x89, 0x98 },
	0x8480,	{ 0xE5, 0x89, 0x99 },
	0x8481,	{ 0xE5, 0x89, 0x9A },
	0x8482,	{ 0xE5, 0x89, 0x9B },
	0x8483,	{ 0xE5, 0x89, 0x9D },
	0x8484,	{ 0xE5, 0x89, 0x9F },
	0x8485,	{ 0xE5, 0x89, 0xA0 },
	0x8486,	{ 0xE5, 0x89, 0xA2 },
	0x8487,	{ 0xE5, 0x89, 0xA3 },
	0x8488,	{ 0xE5, 0x89, 0xA4 },
	0x8489,	{ 0xE5, 0x89, 0xA6 },
	0x848A,	{ 0xE5, 0x89, 0xA8 },
	0x848B,	{ 0xE5, 0x89, 0xAB },
	0x848C,	{ 0xE5, 0x89, 0xAC },
	0x848D,	{ 0xE5, 0x89, 0xAD },
	0x848E,	{ 0xE5, 0x89, 0xAE },
	0x848F,	{ 0xE5, 0x89, 0xB0 },
	0x8490,	{ 0xE5, 0x89, 0xB1 },
	0x8491,	{ 0xE5, 0x89, 0xB3 },
	0x8492,	{ 0xE5, 0x89, 0xB4 },
	0x8493,	{ 0xE5, 0x89, 0xB5 },
	0x8494,	{ 0xE5, 0x89, 0xB6 },
	0x8495,	{ 0xE5, 0x89, 0xB7 },
	0x8496,	{ 0xE5, 0x89, 0xB8 },
	0x8497,	{ 0xE5, 0x89, 0xB9 },
	0x8498,	{ 0xE5, 0x89, 0xBA },
	0x8499,	{ 0xE5, 0x89, 0xBB },
	0x849A,	{ 0xE5, 0x89, 0xBC },
	0x849B,	{ 0xE5, 0x89, 0xBE },
	0x849C,	{ 0xE5, 0x8A, 0x80 },
	0x849D,	{ 0xE5, 0x8A, 0x83 },
	0x849E,	{ 0xE5, 0x8A, 0x84 },
	0x849F,	{ 0xE5, 0x8A, 0x85 },
	0x84A0,	{ 0xE5, 0x8A, 0x86 },
	0x84A1,	{ 0xE5, 0x8A, 0x87 },
	0x84A2,	{ 0xE5, 0x8A, 0x89 },
	0x84A3,	{ 0xE5, 0x8A, 0x8A },
	0x84A4,	{ 0xE5, 0x8A, 0x8B },
	0x84A5,	{ 0xE5, 0x8A, 0x8C },
	0x84A6,	{ 0xE5, 0x8A, 0x8D },
	0x84A7,	{ 0xE5, 0x8A, 0x8E },
	0x84A8,	{ 0xE5, 0x8A, 0x8F },
	0x84A9,	{ 0xE5, 0x8A, 0x91 },
	0x84AA,	{ 0xE5, 0x8A, 0x92 },
	0x84AB,	{ 0xE5, 0x8A, 0x94 },
	0x84AC,	{ 0xE5, 0x8A, 0x95 },
	0x84AD,	{ 0xE5, 0x8A, 0x96 },
	0x84AE,	{ 0xE5, 0x8A, 0x97 },
	0x84AF,	{ 0xE5, 0x8A, 0x98 },
	0x84B0,	{ 0xE5, 0x8A, 0x99 },
	0x84B1,	{ 0xE5, 0x8A, 0x9A },
	0x84B2,	{ 0xE5, 0x8A, 0x9C },
	0x84B3,	{ 0xE5, 0x8A, 0xA4 },
	0x84B4,	{ 0xE5, 0x8A, 0xA5 },
	0x84B5,	{ 0xE5, 0x8A, 0xA6 },
	0x84B6,	{ 0xE5, 0x8A, 0xA7 },
	0x84B7,	{ 0xE5, 0x8A, 0xAE },
	0x84B8,	{ 0xE5, 0x8A, 0xAF },
	0x84B9,	{ 0xE5, 0x8A, 0xB0 },
	0x84BA,	{ 0xE5, 0x8A, 0xB4 },
	0x84BB,	{ 0xE5, 0x8A, 0xB5 },
	0x84BC,	{ 0xE5, 0x8A, 0xB6 },
	0x84BD,	{ 0xE5, 0x8A, 0xB7 },
	0x84BE,	{ 0xE5, 0x8A, 0xB8 },
	0x84BF,	{ 0xE5, 0x8A, 0xB9 },
	0x84C0,	{ 0xE5, 0x8A, 0xBA },
	0x84C1,	{ 0xE5, 0x8A, 0xBB },
	0x84C2,	{ 0xE5, 0x8A, 0xBC },
	0x84C3,	{ 0xE5, 0x8A, 0xBD },
	0x84C4,	{ 0xE5, 0x8B, 0x80 },
	0x84C5,	{ 0xE5, 0x8B, 0x81 },
	0x84C6,	{ 0xE5, 0x8B, 0x82 },
	0x84C7,	{ 0xE5, 0x8B, 0x84 },
	0x84C8,	{ 0xE5, 0x8B, 0x85 },
	0x84C9,	{ 0xE5, 0x8B, 0x86 },
	0x84CA,	{ 0xE5, 0x8B, 0x88 },
	0x84CB,	{ 0xE5, 0x8B, 0x8A },
	0x84CC,	{ 0xE5, 0x8B, 0x8C },
	0x84CD,	{ 0xE5, 0x8B, 0x8D },
	0x84CE,	{ 0xE5, 0x8B, 0x8E },
	0x84CF,	{ 0xE5, 0x8B, 0x8F },
	0x84D0,	{ 0xE5, 0x8B, 0x91 },
	0x84D1,	{ 0xE5, 0x8B, 0x93 },
	0x84D2,	{ 0xE5, 0x8B, 0x94 },
	0x84D3,	{ 0xE5, 0x8B, 0x95 },
	0x84D4,	{ 0xE5, 0x8B, 0x97 },
	0x84D5,	{ 0xE5, 0x8B, 0x99 },
	0x84D6,	{ 0xE5, 0x8B, 0x9A },
	0x84D7,	{ 0xE5, 0x8B, 0x9B },
	0x84D8,	{ 0xE5, 0x8B, 0x9C },
	0x84D9,	{ 0xE5, 0x8B, 0x9D },
	0x84DA,	{ 0xE5, 0x8B, 0x9E },
	0x84DB,	{ 0xE5, 0x8B, 0xA0 },
	0x84DC,	{ 0xE5, 0x8B, 0xA1 },
	0x84DD,	{ 0xE5, 0x8B, 0xA2 },
	0x84DE,	{ 0xE5, 0x8B, 0xA3 },
	0x84DF,	{ 0xE5, 0x8B, 0xA5 },
	0x84E0,	{ 0xE5, 0x8B, 0xA6 },
	0x84E1,	{ 0xE5, 0x8B, 0xA7 },
	0x84E2,	{ 0xE5, 0x8B, 0xA8 },
	0x84E3,	{ 0xE5, 0x8B, 0xA9 },
	0x84E4,	{ 0xE5, 0x8B, 0xAA },
	0x84E5,	{ 0xE5, 0x8B, 0xAB },
	0x84E6,	{ 0xE5, 0x8B, 0xAC },
	0x84E7,	{ 0xE5, 0x8B, 0xAD },
	0x84E8,	{ 0xE5, 0x8B, 0xAE },
	0x84E9,	{ 0xE5, 0x8B, 0xAF },
	0x84EA,	{ 0xE5, 0x8B, 0xB1 },
	0x84EB,	{ 0xE5, 0x8B, 0xB2 },
	0x84EC,	{ 0xE5, 0x8B, 0xB3 },
	0x84ED,	{ 0xE5, 0x8B, 0xB4 },
	0x84EE,	{ 0xE5, 0x8B, 0xB5 },
	0x84EF,	{ 0xE5, 0x8B, 0xB6 },
	0x84F0,	{ 0xE5, 0x8B, 0xB7 },
	0x84F1,	{ 0xE5, 0x8B, 0xB8 },
	0x84F2,	{ 0xE5, 0x8B, 0xBB },
	0x84F3,	{ 0xE5, 0x8B, 0xBC },
	0x84F4,	{ 0xE5, 0x8B, 0xBD },
	0x84F5,	{ 0xE5, 0x8C, 0x81 },
	0x84F6,	{ 0xE5, 0x8C, 0x82 },
	0x84F7,	{ 0xE5, 0x8C, 0x83 },
	0x84F8,	{ 0xE5, 0x8C, 0x84 },
	0x84F9,	{ 0xE5, 0x8C, 0x87 },
	0x84FA,	{ 0xE5, 0x8C, 0x89 },
	0x84FB,	{ 0xE5, 0x8C, 0x8A },
	0x84FC,	{ 0xE5, 0x8C, 0x8B },
	0x84FD,	{ 0xE5, 0x8C, 0x8C },
	0x84FE,	{ 0xE5, 0x8C, 0x8E },
	0x8540,	{ 0xE5, 0x8C, 0x91 },
	0x8541,	{ 0xE5, 0x8C, 0x92 },
	0x8542,	{ 0xE5, 0x8C, 0x93 },
	0x8543,	{ 0xE5, 0x8C, 0x94 },
	0x8544,	{ 0xE5, 0x8C, 0x98 },
	0x8545,	{ 0xE5, 0x8C, 0x9B },
	0x8546,	{ 0xE5, 0x8C, 0x9C },
	0x8547,	{ 0xE5, 0x8C, 0x9E },
	0x8548,	{ 0xE5, 0x8C, 0x9F },
	0x8549,	{ 0xE5, 0x8C, 0xA2 },
	0x854A,	{ 0xE5, 0x8C, 0xA4 },
	0x854B,	{ 0xE5, 0x8C, 0xA5 },
	0x854C,	{ 0xE5, 0x8C, 0xA7 },
	0x854D,	{ 0xE5, 0x8C, 0xA8 },
	0x854E,	{ 0xE5, 0x8C, 0xA9 },
	0x854F,	{ 0xE5, 0x8C, 0xAB },
	0x8550,	{ 0xE5, 0x8C, 0xAC },
	0x8551,	{ 0xE5, 0x8C, 0xAD },
	0x8552,	{ 0xE5, 0x8C, 0xAF },
	0x8553,	{ 0xE5, 0x8C, 0xB0 },
	0x8554,	{ 0xE5, 0x8C, 0xB1 },
	0x8555,	{ 0xE5, 0x8C, 0xB2 },
	0x8556,	{ 0xE5, 0x8C, 0xB3 },
	0x8557,	{ 0xE5, 0x8C, 0xB4 },
	0x8558,	{ 0xE5, 0x8C, 0xB5 },
	0x8559,	{ 0xE5, 0x8C, 0xB6 },
	0x855A,	{ 0xE5, 0x8C, 0xB7 },
	0x855B,	{ 0xE5, 0x8C, 0xB8 },
	0x855C,	{ 0xE5, 0x8C, 0xBC },
	0x855D,	{ 0xE5, 0x8C, 0xBD },
	0x855E,	{ 0xE5, 0x8D, 0x80 },
	0x855F,	{ 0xE5, 0x8D, 0x82 },
	0x8560,	{ 0xE5, 0x8D, 0x84 },
	0x8561,	{ 0xE5, 0x8D, 0x86 },
	0x8562,	{ 0xE5, 0x8D, 0x8B },
	0x8563,	{ 0xE5, 0x8D, 0x8C },
	0x8564,	{ 0xE5, 0x8D, 0x8D },
	0x8565,	{ 0xE5, 0x8D, 0x90 },
	0x8566,	{ 0xE5, 0x8D, 0x94 },
	0x8567,	{ 0xE5, 0x8D, 0x98 },
	0x8568,	{ 0xE5, 0x8D, 0x99 },
	0x8569,	{ 0xE5, 0x8D, 0x9B },
	0x856A,	{ 0xE5, 0x8D, 0x9D },
	0x856B,	{ 0xE5, 0x8D, 0xA5 },
	0x856C,	{ 0xE5, 0x8D, 0xA8 },
	0x856D,	{ 0xE5, 0x8D, 0xAA },
	0x856E,	{ 0xE5, 0x8D, 0xAC },
	0x856F,	{ 0xE5, 0x8D, 0xAD },
	0x8570,	{ 0xE5, 0x8D, 0xB2 },
	0x8571,	{ 0xE5, 0x8D, 0xB6 },
	0x8572,	{ 0xE5, 0x8D, 0xB9 },
	0x8573,	{ 0xE5, 0x8D, 0xBB },
	0x8574,	{ 0xE5, 0x8D, 0xBC },
	0x8575,	{ 0xE5, 0x8D, 0xBD },
	0x8576,	{ 0xE5, 0x8D, 0xBE },
	0x8577,	{ 0xE5, 0x8E, 0x80 },
	0x8578,	{ 0xE5, 0x8E, 0x81 },
	0x8579,	{ 0xE5, 0x8E, 0x83 },
	0x857A,	{ 0xE5, 0x8E, 0x87 },
	0x857B,	{ 0xE5, 0x8E, 0x88 },
	0x857C,	{ 0xE5, 0x8E, 0x8A },
	0x857D,	{ 0xE5, 0x8E, 0x8E },
	0x857E,	{ 0xE5, 0x8E, 0x8F },
	0x8580,	{ 0xE5, 0x8E, 0x90 },
	0x8581,	{ 0xE5, 0x8E, 0x91 },
	0x8582,	{ 0xE5, 0x8E, 0x92 },
	0x8583,	{ 0xE5, 0x8E, 0x93 },
	0x8584,	{ 0xE5, 0x8E, 0x94 },
	0x8585,	{ 0xE5, 0x8E, 0x96 },
	0x8586,	{ 0xE5, 0x8E, 0x97 },
	0x8587,	{ 0xE5, 0x8E, 0x99 },
	0x8588,	{ 0xE5, 0x8E, 0x9B },
	0x8589,	{ 0xE5, 0x8E, 0x9C },
	0x858A,	{ 0xE5, 0x8E, 0x9E },
	0x858B,	{ 0xE5, 0x8E, 0xA0 },
	0x858C,	{ 0xE5, 0x8E, 0xA1 },
	0x858D,	{ 0xE5, 0x8E, 0xA4 },
	0x858E,	{ 0xE5, 0x8E, 0xA7 },
	0x858F,	{ 0xE5, 0x8E, 0xAA },
	0x8590,	{ 0xE5, 0x8E, 0xAB },
	0x8591,	{ 0xE5, 0x8E, 0xAC },
	0x8592,	{ 0xE5, 0x8E, 0xAD },
	0x8593,	{ 0xE5, 0x8E, 0xAF },
	0x8594,	{ 0xE5, 0x8E, 0xB0 },
	0x8595,	{ 0xE5, 0x8E, 0xB1 },
	0x8596,	{ 0xE5, 0x8E, 0xB2 },
	0x8597,	{ 0xE5, 0x8E, 0xB3 },
	0x8598,	{ 0xE5, 0x8E, 0xB4 },
	0x8599,	{ 0xE5, 0x8E, 0xB5 },
	0x859A,	{ 0xE5, 0x8E, 0xB7 },
	0x859B,	{ 0xE5, 0x8E, 0xB8 },
	0x859C,	{ 0xE5, 0x8E, 0xB9 },
	0x859D,	{ 0xE5, 0x8E, 0xBA },
	0x859E,	{ 0xE5, 0x8E, 0xBC },
	0x859F,	{ 0xE5, 0x8E, 0xBD },
	0x85A0,	{ 0xE5, 0x8E, 0xBE },
	0x85A1,	{ 0xE5, 0x8F, 0x80 },
	0x85A2,	{ 0xE5, 0x8F, 0x83 },
	0x85A3,	{ 0xE5, 0x8F, 0x84 },
	0x85A4,	{ 0xE5, 0x8F, 0x85 },
	0x85A5,	{ 0xE5, 0x8F, 0x86 },
	0x85A6,	{ 0xE5, 0x8F, 0x87 },
	0x85A7,	{ 0xE5, 0x8F, 0x8E },
	0x85A8,	{ 0xE5, 0x8F, 0x8F },
	0x85A9,	{ 0xE5, 0x8F, 0x90 },
	0x85AA,	{ 0xE5, 0x8F, 0x92 },
	0x85AB,	{ 0xE5, 0x8F, 0x93 },
	0x85AC,	{ 0xE5, 0x8F, 0x95 },
	0x85AD,	{ 0xE5, 0x8F, 0x9A },
	0x85AE,	{ 0xE5, 0x8F, 0x9C },
	0x85AF,	{ 0xE5, 0x8F, 0x9D },
	0x85B0,	{ 0xE5, 0x8F, 0x9E },
	0x85B1,	{ 0xE5, 0x8F, 0xA1 },
	0x85B2,	{ 0xE5, 0x8F, 0xA2 },
	0x85B3,	{ 0xE5, 0x8F, 0xA7 },
	0x85B4,	{ 0xE5, 0x8F, 0xB4 },
	0x85B5,	{ 0xE5, 0x8F, 0xBA },
	0x85B6,	{ 0xE5, 0x8F, 0xBE },
	0x85B7,	{ 0xE5, 0x8F, 0xBF },
	0x85B8,	{ 0xE5, 0x90, 0x80 },
	0x85B9,	{ 0xE5, 0x90, 0x82 },
	0x85BA,	{ 0xE5, 0x90, 0x85 },
	0x85BB,	{ 0xE5, 0x90, 0x87 },
	0x85BC,	{ 0xE5, 0x90, 0x8B },
	0x85BD,	{ 0xE5, 0x90, 0x94 },
	0x85BE,	{ 0xE5, 0x90, 0x98 },
	0x85BF,	{ 0xE5, 0x90, 0x99 },
	0x85C0,	{ 0xE5, 0x90, 0x9A },
	0x85C1,	{ 0xE5, 0x90, 0x9C },
	0x85C2,	{ 0xE5, 0x90, 0xA2 },
	0x85C3,	{ 0xE5, 0x90, 0xA4 },
	0x85C4,	{ 0xE5, 0x90, 0xA5 },
	0x85C5,	{ 0xE5, 0x90, 0xAA },
	0x85C6,	{ 0xE5, 0x90, 0xB0 },
	0x85C7,	{ 0xE5, 0x90, 0xB3 },
	0x85C8,	{ 0xE5, 0x90, 0xB6 },
	0x85C9,	{ 0xE5, 0x90, 0xB7 },
	0x85CA,	{ 0xE5, 0x90, 0xBA },
	0x85CB,	{ 0xE5, 0x90, 0xBD },
	0x85CC,	{ 0xE5, 0x90, 0xBF },
	0x85CD,	{ 0xE5, 0x91, 0x81 },
	0x85CE,	{ 0xE5, 0x91, 0x82 },
	0x85CF,	{ 0xE5, 0x91, 0x84 },
	0x85D0,	{ 0xE5, 0x91, 0x85 },
	0x85D1,	{ 0xE5, 0x91, 0x87 },
	0x85D2,	{ 0xE5, 0x91, 0x89 },
	0x85D3,	{ 0xE5, 0x91, 0x8C },
	0x85D4,	{ 0xE5, 0x91, 0x8D },
	0x85D5,	{ 0xE5, 0x91, 0x8E },
	0x85D6,	{ 0xE5, 0x91, 0x8F },
	0x85D7,	{ 0xE5, 0x91, 0x91 },
	0x85D8,	{ 0xE5, 0x91, 0x9A },
	0x85D9,	{ 0xE5, 0x91, 0x9D },
	0x85DA,	{ 0xE5, 0x91, 0x9E },
	0x85DB,	{ 0xE5, 0x91, 0x9F },
	0x85DC,	{ 0xE5, 0x91, 0xA0 },
	0x85DD,	{ 0xE5, 0x91, 0xA1 },
	0x85DE,	{ 0xE5, 0x91, 0xA3 },
	0x85DF,	{ 0xE5, 0x91, 0xA5 },
	0x85E0,	{ 0xE5, 0x91, 0xA7 },
	0x85E1,	{ 0xE5, 0x91, 0xA9 },
	0x85E2,	{ 0xE5, 0x91, 0xAA },
	0x85E3,	{ 0xE5, 0x91, 0xAB },
	0x85E4,	{ 0xE5, 0x91, 0xAC },
	0x85E5,	{ 0xE5, 0x91, 0xAD },
	0x85E6,	{ 0xE5, 0x91, 0xAE },
	0x85E7,	{ 0xE5, 0x91, 0xAF },
	0x85E8,	{ 0xE5, 0x91, 0xB0 },
	0x85E9,	{ 0xE5, 0x91, 0xB4 },
	0x85EA,	{ 0xE5, 0x91, 0xB9 },
	0x85EB,	{ 0xE5, 0x91, 0xBA },
	0x85EC,	{ 0xE5, 0x91, 0xBE },
	0x85ED,	{ 0xE5, 0x91, 0xBF },
	0x85EE,	{ 0xE5, 0x92, 0x81 },
	0x85EF,	{ 0xE5, 0x92, 0x83 },
	0x85F0,	{ 0xE5, 0x92, 0x85 },
	0x85F1,	{ 0xE5, 0x92, 0x87 },
	0x85F2,	{ 0xE5, 0x92, 0x88 },
	0x85F3,	{ 0xE5, 0x92, 0x89 },
	0x85F4,	{ 0xE5, 0x92, 0x8A },
	0x85F5,	{ 0xE5, 0x92, 0x8D },
	0x85F6,	{ 0xE5, 0x92, 0x91 },
	0x85F7,	{ 0xE5, 0x92, 0x93 },
	0x85F8,	{ 0xE5, 0x92, 0x97 },
	0x85F9,	{ 0xE5, 0x92, 0x98 },
	0x85FA,	{ 0xE5, 0x92, 0x9C },
	0x85FB,	{ 0xE5, 0x92, 0x9E },
	0x85FC,	{ 0xE5, 0x92, 0x9F },
	0x85FD,	{ 0xE5, 0x92, 0xA0 },
	0x85FE,	{ 0xE5, 0x92, 0xA1 },
	0x8640,	{ 0xE5, 0x92, 0xA2 },
	0x8641,	{ 0xE5, 0x92, 0xA5 },
	0x8642,	{ 0xE5, 0x92, 0xAE },
	0x8643,	{ 0xE5, 0x92, 0xB0 },
	0x8644,	{ 0xE5, 0x92, 0xB2 },
	0x8645,	{ 0xE5, 0x92, 0xB5 },
	0x8646,	{ 0xE5, 0x92, 0xB6 },
	0x8647,	{ 0xE5, 0x92, 0xB7 },
	0x8648,	{ 0xE5, 0x92, 0xB9 },
	0x8649,	{ 0xE5, 0x92, 0xBA },
	0x864A,	{ 0xE5, 0x92, 0xBC },
	0x864B,	{ 0xE5, 0x92, 0xBE },
	0x864C,	{ 0xE5, 0x93, 0x83 },
	0x864D,	{ 0xE5, 0x93, 0x85 },
	0x864E,	{ 0xE5, 0x93, 0x8A },
	0x864F,	{ 0xE5, 0x93, 0x8B },
	0x8650,	{ 0xE5, 0x93, 0x96 },
	0x8651,	{ 0xE5, 0x93, 0x98 },
	0x8652,	{ 0xE5, 0x93, 0x9B },
	0x8653,	{ 0xE5, 0x93, 0xA0 },
	0x8654,	{ 0xE5, 0x93, 0xA1 },
	0x8655,	{ 0xE5, 0x93, 0xA2 },
	0x8656,	{ 0xE5, 0x93, 0xA3 },
	0x8657,	{ 0xE5, 0x93, 0xA4 },
	0x8658,	{ 0xE5, 0x93, 0xAB },
	0x8659,	{ 0xE5, 0x93, 0xAC },
	0x865A,	{ 0xE5, 0x93, 0xAF },
	0x865B,	{ 0xE5, 0x93, 0xB0 },
	0x865C,	{ 0xE5, 0x93, 0xB1 },
	0x865D,	{ 0xE5, 0x93, 0xB4 },
	0x865E,	{ 0xE5, 0x93, 0xB5 },
	0x865F,	{ 0xE5, 0x93, 0xB6 },
	0x8660,	{ 0xE5, 0x93, 0xB7 },
	0x8661,	{ 0xE5, 0x93, 0xB8 },
	0x8662,	{ 0xE5, 0x93, 0xB9 },
	0x8663,	{ 0xE5, 0x93, 0xBB },
	0x8664,	{ 0xE5, 0x93, 0xBE },
	0x8665,	{ 0xE5, 0x94, 0x80 },
	0x8666,	{ 0xE5, 0x94, 0x82 },
	0x8667,	{ 0xE5, 0x94, 0x83 },
	0x8668,	{ 0xE5, 0x94, 0x84 },
	0x8669,	{ 0xE5, 0x94, 0x85 },
	0x866A,	{ 0xE5, 0x94, 0x88 },
	0x866B,	{ 0xE5, 0x94, 0x8A },
	0x866C,	{ 0xE5, 0x94, 0x8B },
	0x866D,	{ 0xE5, 0x94, 0x8C },
	0x866E,	{ 0xE5, 0x94, 0x8D },
	0x866F,	{ 0xE5, 0x94, 0x8E },
	0x8670,	{ 0xE5, 0x94, 0x92 },
	0x8671,	{ 0xE5, 0x94, 0x93 },
	0x8672,	{ 0xE5, 0x94, 0x95 },
	0x8673,	{ 0xE5, 0x94, 0x96 },
	0x8674,	{ 0xE5, 0x94, 0x97 },
	0x8675,	{ 0xE5, 0x94, 0x98 },
	0x8676,	{ 0xE5, 0x94, 0x99 },
	0x8677,	{ 0xE5, 0x94, 0x9A },
	0x8678,	{ 0xE5, 0x94, 0x9C },
	0x8679,	{ 0xE5, 0x94, 0x9D },
	0x867A,	{ 0xE5, 0x94, 0x9E },
	0x867B,	{ 0xE5, 0x94, 0x9F },
	0x867C,	{ 0xE5, 0x94, 0xA1 },
	0x867D,	{ 0xE5, 0x94, 0xA5 },
	0x867E,	{ 0xE5, 0x94, 0xA6 },
	0x8680,	{ 0xE5, 0x94, 0xA8 },
	0x8681,	{ 0xE5, 0x94, 0xA9 },
	0x8682,	{ 0xE5, 0x94, 0xAB },
	0x8683,	{ 0xE5, 0x94, 0xAD },
	0x8684,	{ 0xE5, 0x94, 0xB2 },
	0x8685,	{ 0xE5, 0x94, 0xB4 },
	0x8686,	{ 0xE5, 0x94, 0xB5 },
	0x8687,	{ 0xE5, 0x94, 0xB6 },
	0x8688,	{ 0xE5, 0x94, 0xB8 },
	0x8689,	{ 0xE5, 0x94, 0xB9 },
	0x868A,	{ 0xE5, 0x94, 0xBA },
	0x868B,	{ 0xE5, 0x94, 0xBB },
	0x868C,	{ 0xE5, 0x94, 0xBD },
	0x868D,	{ 0xE5, 0x95, 0x80 },
	0x868E,	{ 0xE5, 0x95, 0x82 },
	0x868F,	{ 0xE5, 0x95, 0x85 },
	0x8690,	{ 0xE5, 0x95, 0x87 },
	0x8691,	{ 0xE5, 0x95, 0x88 },
	0x8692,	{ 0xE5, 0x95, 0x8B },
	0x8693,	{ 0xE5, 0x95, 0x8C },
	0x8694,	{ 0xE5, 0x95, 0x8D },
	0x8695,	{ 0xE5, 0x95, 0x8E },
	0x8696,	{ 0xE5, 0x95, 0x8F },
	0x8697,	{ 0xE5, 0x95, 0x91 },
	0x8698,	{ 0xE5, 0x95, 0x92 },
	0x8699,	{ 0xE5, 0x95, 0x93 },
	0x869A,	{ 0xE5, 0x95, 0x94 },
	0x869B,	{ 0xE5, 0x95, 0x97 },
	0x869C,	{ 0xE5, 0x95, 0x98 },
	0x869D,	{ 0xE5, 0x95, 0x99 },
	0x869E,	{ 0xE5, 0x95, 0x9A },
	0x869F,	{ 0xE5, 0x95, 0x9B },
	0x86A0,	{ 0xE5, 0x95, 0x9D },
	0x86A1,	{ 0xE5, 0x95, 0x9E },
	0x86A2,	{ 0xE5, 0x95, 0x9F },
	0x86A3,	{ 0xE5, 0x95, 0xA0 },
	0x86A4,	{ 0xE5, 0x95, 0xA2 },
	0x86A5,	{ 0xE5, 0x95, 0xA3 },
	0x86A6,	{ 0xE5, 0x95, 0xA8 },
	0x86A7,	{ 0xE5, 0x95, 0xA9 },
	0x86A8,	{ 0xE5, 0x95, 0xAB },
	0x86A9,	{ 0xE5, 0x95, 0xAF },
	0x86AA,	{ 0xE5, 0x95, 0xB0 },
	0x86AB,	{ 0xE5, 0x95, 0xB1 },
	0x86AC,	{ 0xE5, 0x95, 0xB2 },
	0x86AD,	{ 0xE5, 0x95, 0xB3 },
	0x86AE,	{ 0xE5, 0x95, 0xB4 },
	0x86AF,	{ 0xE5, 0x95, 0xB9 },
	0x86B0,	{ 0xE5, 0x95, 0xBA },
	0x86B1,	{ 0xE5, 0x95, 0xBD },
	0x86B2,	{ 0xE5, 0x95, 0xBF },
	0x86B3,	{ 0xE5, 0x96, 0x85 },
	0x86B4,	{ 0xE5, 0x96, 0x86 },
	0x86B5,	{ 0xE5, 0x96, 0x8C },
	0x86B6,	{ 0xE5, 0x96, 0x8D },
	0x86B7,	{ 0xE5, 0x96, 0x8E },
	0x86B8,	{ 0xE5, 0x96, 0x90 },
	0x86B9,	{ 0xE5, 0x96, 0x92 },
	0x86BA,	{ 0xE5, 0x96, 0x93 },
	0x86BB,	{ 0xE5, 0x96, 0x95 },
	0x86BC,	{ 0xE5, 0x96, 0x96 },
	0x86BD,	{ 0xE5, 0x96, 0x97 },
	0x86BE,	{ 0xE5, 0x96, 0x9A },
	0x86BF,	{ 0xE5, 0x96, 0x9B },
	0x86C0,	{ 0xE5, 0x96, 0x9E },
	0x86C1,	{ 0xE5, 0x96, 0xA0 },
	0x86C2,	{ 0xE5, 0x96, 0xA1 },
	0x86C3,	{ 0xE5, 0x96, 0xA2 },
	0x86C4,	{ 0xE5, 0x96, 0xA3 },
	0x86C5,	{ 0xE5, 0x96, 0xA4 },
	0x86C6,	{ 0xE5, 0x96, 0xA5 },
	0x86C7,	{ 0xE5, 0x96, 0xA6 },
	0x86C8,	{ 0xE5, 0x96, 0xA8 },
	0x86C9,	{ 0xE5, 0x96, 0xA9 },
	0x86CA,	{ 0xE5, 0x96, 0xAA },
	0x86CB,	{ 0xE5, 0x96, 0xAB },
	0x86CC,	{ 0xE5, 0x96, 0xAC },
	0x86CD,	{ 0xE5, 0x96, 0xAD },
	0x86CE,	{ 0xE5, 0x96, 0xAE },
	0x86CF,	{ 0xE5, 0x96, 0xAF },
	0x86D0,	{ 0xE5, 0x96, 0xB0 },
	0x86D1,	{ 0xE5, 0x96, 0xB2 },
	0x86D2,	{ 0xE5, 0x96, 0xB4 },
	0x86D3,	{ 0xE5, 0x96, 0xB6 },
	0x86D4,	{ 0xE5, 0x96, 0xB8 },
	0x86D5,	{ 0xE5, 0x96, 0xBA },
	0x86D6,	{ 0xE5, 0x96, 0xBC },
	0x86D7,	{ 0xE5, 0x96, 0xBF },
	0x86D8,	{ 0xE5, 0x97, 0x80 },
	0x86D9,	{ 0xE5, 0x97, 0x81 },
	0x86DA,	{ 0xE5, 0x97, 0x82 },
	0x86DB,	{ 0xE5, 0x97, 0x83 },
	0x86DC,	{ 0xE5, 0x97, 0x86 },
	0x86DD,	{ 0xE5, 0x97, 0x87 },
	0x86DE,	{ 0xE5, 0x97, 0x88 },
	0x86DF,	{ 0xE5, 0x97, 0x8A },
	0x86E0,	{ 0xE5, 0x97, 0x8B },
	0x86E1,	{ 0xE5, 0x97, 0x8E },
	0x86E2,	{ 0xE5, 0x97, 0x8F },
	0x86E3,	{ 0xE5, 0x97, 0x90 },
	0x86E4,	{ 0xE5, 0x97, 0x95 },
	0x86E5,	{ 0xE5, 0x97, 0x97 },
	0x86E6,	{ 0xE5, 0x97, 0x98 },
	0x86E7,	{ 0xE5, 0x97, 0x99 },
	0x86E8,	{ 0xE5, 0x97, 0x9A },
	0x86E9,	{ 0xE5, 0x97, 0x9B },
	0x86EA,	{ 0xE5, 0x97, 0x9E },
	0x86EB,	{ 0xE5, 0x97, 0xA0 },
	0x86EC,	{ 0xE5, 0x97, 0xA2 },
	0x86ED,	{ 0xE5, 0x97, 0xA7 },
	0x86EE,	{ 0xE5, 0x97, 0xA9 },
	0x86EF,	{ 0xE5, 0x97, 0xAD },
	0x86F0,	{ 0xE5, 0x97, 0xAE },
	0x86F1,	{ 0xE5, 0x97, 0xB0 },
	0x86F2,	{ 0xE5, 0x97, 0xB1 },
	0x86F3,	{ 0xE5, 0x97, 0xB4 },
	0x86F4,	{ 0xE5, 0x97, 0xB6 },
	0x86F5,	{ 0xE5, 0x97, 0xB8 },
	0x86F6,	{ 0xE5, 0x97, 0xB9 },
	0x86F7,	{ 0xE5, 0x97, 0xBA },
	0x86F8,	{ 0xE5, 0x97, 0xBB },
	0x86F9,	{ 0xE5, 0x97, 0xBC },
	0x86FA,	{ 0xE5, 0x97, 0xBF },
	0x86FB,	{ 0xE5, 0x98, 0x82 },
	0x86FC,	{ 0xE5, 0x98, 0x83 },
	0x86FD,	{ 0xE5, 0x98, 0x84 },
	0x86FE,	{ 0xE5, 0x98, 0x85 },
	0x8740,	{ 0xE5, 0x98, 0x86 },
	0x8741,	{ 0xE5, 0x98, 0x87 },
	0x8742,	{ 0xE5, 0x98, 0x8A },
	0x8743,	{ 0xE5, 0x98, 0x8B },
	0x8744,	{ 0xE5, 0x98, 0x8D },
	0x8745,	{ 0xE5, 0x98, 0x90 },
	0x8746,	{ 0xE5, 0x98, 0x91 },
	0x8747,	{ 0xE5, 0x98, 0x92 },
	0x8748,	{ 0xE5, 0x98, 0x93 },
	0x8749,	{ 0xE5, 0x98, 0x94 },
	0x874A,	{ 0xE5, 0x98, 0x95 },
	0x874B,	{ 0xE5, 0x98, 0x96 },
	0x874C,	{ 0xE5, 0x98, 0x97 },
	0x874D,	{ 0xE5, 0x98, 0x99 },
	0x874E,	{ 0xE5, 0x98, 0x9A },
	0x874F,	{ 0xE5, 0x98, 0x9C },
	0x8750,	{ 0xE5, 0x98, 0x9D },
	0x8751,	{ 0xE5, 0x98, 0xA0 },
	0x8752,	{ 0xE5, 0x98, 0xA1 },
	0x8753,	{ 0xE5, 0x98, 0xA2 },
	0x8754,	{ 0xE5, 0x98, 0xA5 },
	0x8755,	{ 0xE5, 0x98, 0xA6 },
	0x8756,	{ 0xE5, 0x98, 0xA8 },
	0x8757,	{ 0xE5, 0x98, 0xA9 },
	0x8758,	{ 0xE5, 0x98, 0xAA },
	0x8759,	{ 0xE5, 0x98, 0xAB },
	0x875A,	{ 0xE5, 0x98, 0xAE },
	0x875B,	{ 0xE5, 0x98, 0xAF },
	0x875C,	{ 0xE5, 0x98, 0xB0 },
	0x875D,	{ 0xE5, 0x98, 0xB3 },
	0x875E,	{ 0xE5, 0x98, 0xB5 },
	0x875F,	{ 0xE5, 0x98, 0xB7 },
	0x8760,	{ 0xE5, 0x98, 0xB8 },
	0x8761,	{ 0xE5, 0x98, 0xBA },
	0x8762,	{ 0xE5, 0x98, 0xBC },
	0x8763,	{ 0xE5, 0x98, 0xBD },
	0x8764,	{ 0xE5, 0x98, 0xBE },
	0x8765,	{ 0xE5, 0x99, 0x80 },
	0x8766,	{ 0xE5, 0x99, 0x81 },
	0x8767,	{ 0xE5, 0x99, 0x82 },
	0x8768,	{ 0xE5, 0x99, 0x83 },
	0x8769,	{ 0xE5, 0x99, 0x84 },
	0x876A,	{ 0xE5, 0x99, 0x85 },
	0x876B,	{ 0xE5, 0x99, 0x86 },
	0x876C,	{ 0xE5, 0x99, 0x87 },
	0x876D,	{ 0xE5, 0x99, 0x88 },
	0x876E,	{ 0xE5, 0x99, 0x89 },
	0x876F,	{ 0xE5, 0x99, 0x8A },
	0x8770,	{ 0xE5, 0x99, 0x8B },
	0x8771,	{ 0xE5, 0x99, 0x8F },
	0x8772,	{ 0xE5, 0x99, 0x90 },
	0x8773,	{ 0xE5, 0x99, 0x91 },
	0x8774,	{ 0xE5, 0x99, 0x92 },
	0x8775,	{ 0xE5, 0x99, 0x93 },
	0x8776,	{ 0xE5, 0x99, 0x95 },
	0x8777,	{ 0xE5, 0x99, 0x96 },
	0x8778,	{ 0xE5, 0x99, 0x9A },
	0x8779,	{ 0xE5, 0x99, 0x9B },
	0x877A,	{ 0xE5, 0x99, 0x9D },
	0x877B,	{ 0xE5, 0x99, 0x9E },
	0x877C,	{ 0xE5, 0x99, 0x9F },
	0x877D,	{ 0xE5, 0x99, 0xA0 },
	0x877E,	{ 0xE5, 0x99, 0xA1 },
	0x8780,	{ 0xE5, 0x99, 0xA3 },
	0x8781,	{ 0xE5, 0x99, 0xA5 },
	0x8782,	{ 0xE5, 0x99, 0xA6 },
	0x8783,	{ 0xE5, 0x99, 0xA7 },
	0x8784,	{ 0xE5, 0x99, 0xAD },
	0x8785,	{ 0xE5, 0x99, 0xAE },
	0x8786,	{ 0xE5, 0x99, 0xAF },
	0x8787,	{ 0xE5, 0x99, 0xB0 },
	0x8788,	{ 0xE5, 0x99, 0xB2 },
	0x8789,	{ 0xE5, 0x99, 0xB3 },
	0x878A,	{ 0xE5, 0x99, 0xB4 },
	0x878B,	{ 0xE5, 0x99, 0xB5 },
	0x878C,	{ 0xE5, 0x99, 0xB7 },
	0x878D,	{ 0xE5, 0x99, 0xB8 },
	0x878E,	{ 0xE5, 0x99, 0xB9 },
	0x878F,	{ 0xE5, 0x99, 0xBA },
	0x8790,	{ 0xE5, 0x99, 0xBD },
	0x8791,	{ 0xE5, 0x99, 0xBE },
	0x8792,	{ 0xE5, 0x99, 0xBF },
	0x8793,	{ 0xE5, 0x9A, 0x80 },
	0x8794,	{ 0xE5, 0x9A, 0x81 },
	0x8795,	{ 0xE5, 0x9A, 0x82 },
	0x8796,	{ 0xE5, 0x9A, 0x83 },
	0x8797,	{ 0xE5, 0x9A, 0x84 },
	0x8798,	{ 0xE5, 0x9A, 0x87 },
	0x8799,	{ 0xE5, 0x9A, 0x88 },
	0x879A,	{ 0xE5, 0x9A, 0x89 },
	0x879B,	{ 0xE5, 0x9A, 0x8A },
	0x879C,	{ 0xE5, 0x9A, 0x8B },
	0x879D,	{ 0xE5, 0x9A, 0x8C },
	0x879E,	{ 0xE5, 0x9A, 0x8D },
	0x879F,	{ 0xE5, 0x9A, 0x90 },
	0x87A0,	{ 0xE5, 0x9A, 0x91 },
	0x87A1,	{ 0xE5, 0x9A, 0x92 },
	0x87A2,	{ 0xE5, 0x9A, 0x94 },
	0x87A3,	{ 0xE5, 0x9A, 0x95 },
	0x87A4,	{ 0xE5, 0x9A, 0x96 },
	0x87A5,	{ 0xE5, 0x9A, 0x97 },
	0x87A6,	{ 0xE5, 0x9A, 0x98 },
	0x87A7,	{ 0xE5, 0x9A, 0x99 },
	0x87A8,	{ 0xE5, 0x9A, 0x9A },
	0x87A9,	{ 0xE5, 0x9A, 0x9B },
	0x87AA,	{ 0xE5, 0x9A, 0x9C },
	0x87AB,	{ 0xE5, 0x9A, 0x9D },
	0x87AC,	{ 0xE5, 0x9A, 0x9E },
	0x87AD,	{ 0xE5, 0x9A, 0x9F },
	0x87AE,	{ 0xE5, 0x9A, 0xA0 },
	0x87AF,	{ 0xE5, 0x9A, 0xA1 },
	0x87B0,	{ 0xE5, 0x9A, 0xA2 },
	0x87B1,	{ 0xE5, 0x9A, 0xA4 },
	0x87B2,	{ 0xE5, 0x9A, 0xA5 },
	0x87B3,	{ 0xE5, 0x9A, 0xA6 },
	0x87B4,	{ 0xE5, 0x9A, 0xA7 },
	0x87B5,	{ 0xE5, 0x9A, 0xA8 },
	0x87B6,	{ 0xE5, 0x9A, 0xA9 },
	0x87B7,	{ 0xE5, 0x9A, 0xAA },
	0x87B8,	{ 0xE5, 0x9A, 0xAB },
	0x87B9,	{ 0xE5, 0x9A, 0xAC },
	0x87BA,	{ 0xE5, 0x9A, 0xAD },
	0x87BB,	{ 0xE5, 0x9A, 0xAE },
	0x87BC,	{ 0xE5, 0x9A, 0xB0 },
	0x87BD,	{ 0xE5, 0x9A, 0xB1 },
	0x87BE,	{ 0xE5, 0x9A, 0xB2 },
	0x87BF,	{ 0xE5, 0x9A, 0xB3 },
	0x87C0,	{ 0xE5, 0x9A, 0xB4 },
	0x87C1,	{ 0xE5, 0x9A, 0xB5 },
	0x87C2,	{ 0xE5, 0x9A, 0xB6 },
	0x87C3,	{ 0xE5, 0x9A, 0xB8 },
	0x87C4,	{ 0xE5, 0x9A, 0xB9 },
	0x87C5,	{ 0xE5, 0x9A, 0xBA },
	0x87C6,	{ 0xE5, 0x9A, 0xBB },
	0x87C7,	{ 0xE5, 0x9A, 0xBD },
	0x87C8,	{ 0xE5, 0x9A, 0xBE },
	0x87C9,	{ 0xE5, 0x9A, 0xBF },
	0x87CA,	{ 0xE5, 0x9B, 0x80 },
	0x87CB,	{ 0xE5, 0x9B, 0x81 },
	0x87CC,	{ 0xE5, 0x9B, 0x82 },
	0x87CD,	{ 0xE5, 0x9B, 0x83 },
	0x87CE,	{ 0xE5, 0x9B, 0x84 },
	0x87CF,	{ 0xE5, 0x9B, 0x85 },
	0x87D0,	{ 0xE5, 0x9B, 0x86 },
	0x87D1,	{ 0xE5, 0x9B, 0x87 },
	0x87D2,	{ 0xE5, 0x9B, 0x88 },
	0x87D3,	{ 0xE5, 0x9B, 0x89 },
	0x87D4,	{ 0xE5, 0x9B, 0x8B },
	0x87D5,	{ 0xE5, 0x9B, 0x8C },
	0x87D6,	{ 0xE5, 0x9B, 0x8D },
	0x87D7,	{ 0xE5, 0x9B, 0x8E },
	0x87D8,	{ 0xE5, 0x9B, 0x8F },
	0x87D9,	{ 0xE5, 0x9B, 0x90 },
	0x87DA,	{ 0xE5, 0x9B, 0x91 },
	0x87DB,	{ 0xE5, 0x9B, 0x92 },
	0x87DC,	{ 0xE5, 0x9B, 0x93 },
	0x87DD,	{ 0xE5, 0x9B, 0x95 },
	0x87DE,	{ 0xE5, 0x9B, 0x96 },
	0x87DF,	{ 0xE5, 0x9B, 0x98 },
	0x87E0,	{ 0xE5, 0x9B, 0x99 },
	0x87E1,	{ 0xE5, 0x9B, 0x9C },
	0x87E2,	{ 0xE5, 0x9B, 0xA3 },
	0x87E3,	{ 0xE5, 0x9B, 0xA5 },
	0x87E4,	{ 0xE5, 0x9B, 0xA6 },
	0x87E5,	{ 0xE5, 0x9B, 0xA7 },
	0x87E6,	{ 0xE5, 0x9B, 0xA8 },
	0x87E7,	{ 0xE5, 0x9B, 0xA9 },
	0x87E8,	{ 0xE5, 0x9B, 0xAA },
	0x87E9,	{ 0xE5, 0x9B, 0xAC },
	0x87EA,	{ 0xE5, 0x9B, 0xAE },
	0x87EB,	{ 0xE5, 0x9B, 0xAF },
	0x87EC,	{ 0xE5, 0x9B, 0xB2 },
	0x87ED,	{ 0xE5, 0x9B, 0xB3 },
	0x87EE,	{ 0xE5, 0x9B, 0xB6 },
	0x87EF,	{ 0xE5, 0x9B, 0xB7 },
	0x87F0,	{ 0xE5, 0x9B, 0xB8 },
	0x87F1,	{ 0xE5, 0x9B, 0xBB },
	0x87F2,	{ 0xE5, 0x9B, 0xBC },
	0x87F3,	{ 0xE5, 0x9C, 0x80 },
	0x87F4,	{ 0xE5, 0x9C, 0x81 },
	0x87F5,	{ 0xE5, 0x9C, 0x82 },
	0x87F6,	{ 0xE5, 0x9C, 0x85 },
	0x87F7,	{ 0xE5, 0x9C, 0x87 },
	0x87F8,	{ 0xE5, 0x9C, 0x8B },
	0x87F9,	{ 0xE5, 0x9C, 0x8C },
	0x87FA,	{ 0xE5, 0x9C, 0x8D },
	0x87FB,	{ 0xE5, 0x9C, 0x8E },
	0x87FC,	{ 0xE5, 0x9C, 0x8F },
	0x87FD,	{ 0xE5, 0x9C, 0x90 },
	0x87FE,	{ 0xE5, 0x9C, 0x91 },
	0x8840,	{ 0xE5, 0x9C, 0x92 },
	0x8841,	{ 0xE5, 0x9C, 0x93 },
	0x8842,	{ 0xE5, 0x9C, 0x94 },
	0x8843,	{ 0xE5, 0x9C, 0x95 },
	0x8844,	{ 0xE5, 0x9C, 0x96 },
	0x8845,	{ 0xE5, 0x9C, 0x97 },
	0x8846,	{ 0xE5, 0x9C, 0x98 },
	0x8847,	{ 0xE5, 0x9C, 0x99 },
	0x8848,	{ 0xE5, 0x9C, 0x9A },
	0x8849,	{ 0xE5, 0x9C, 0x9B },
	0x884A,	{ 0xE5, 0x9C, 0x9D },
	0x884B,	{ 0xE5, 0x9C, 0x9E },
	0x884C,	{ 0xE5, 0x9C, 0xA0 },
	0x884D,	{ 0xE5, 0x9C, 0xA1 },
	0x884E,	{ 0xE5, 0x9C, 0xA2 },
	0x884F,	{ 0xE5, 0x9C, 0xA4 },
	0x8850,	{ 0xE5, 0x9C, 0xA5 },
	0x8851,	{ 0xE5, 0x9C, 0xA6 },
	0x8852,	{ 0xE5, 0x9C, 0xA7 },
	0x8853,	{ 0xE5, 0x9C, 0xAB },
	0x8854,	{ 0xE5, 0x9C, 0xB1 },
	0x8855,	{ 0xE5, 0x9C, 0xB2 },
	0x8856,	{ 0xE5, 0x9C, 0xB4 },
	0x8857,	{ 0xE5, 0x9C, 0xB5 },
	0x8858,	{ 0xE5, 0x9C, 0xB6 },
	0x8859,	{ 0xE5, 0x9C, 0xB7 },
	0x885A,	{ 0xE5, 0x9C, 0xB8 },
	0x885B,	{ 0xE5, 0x9C, 0xBC },
	0x885C,	{ 0xE5, 0x9C, 0xBD },
	0x885D,	{ 0xE5, 0x9C, 0xBF },
	0x885E,	{ 0xE5, 0x9D, 0x81 },
	0x885F,	{ 0xE5, 0x9D, 0x83 },
	0x8860,	{ 0xE5, 0x9D, 0x84 },
	0x8861,	{ 0xE5, 0x9D, 0x85 },
	0x8862,	{ 0xE5, 0x9D, 0x86 },
	0x8863,	{ 0xE5, 0x9D, 0x88 },
	0x8864,	{ 0xE5, 0x9D, 0x89 },
	0x8865,	{ 0xE5, 0x9D, 0x8B },
	0x8866,	{ 0xE5, 0x9D, 0x92 },
	0x8867,	{ 0xE5, 0x9D, 0x93 },
	0x8868,	{ 0xE5, 0x9D, 0x94 },
	0x8869,	{ 0xE5, 0x9D, 0x95 },
	0x886A,	{ 0xE5, 0x9D, 0x96 },
	0x886B,	{ 0xE5, 0x9D, 0x98 },
	0x886C,	{ 0xE5, 0x9D, 0x99 },
	0x886D,	{ 0xE5, 0x9D, 0xA2 },
	0x886E,	{ 0xE5, 0x9D, 0xA3 },
	0x886F,	{ 0xE5, 0x9D, 0xA5 },
	0x8870,	{ 0xE5, 0x9D, 0xA7 },
	0x8871,	{ 0xE5, 0x9D, 0xAC },
	0x8872,	{ 0xE5, 0x9D, 0xAE },
	0x8873,	{ 0xE5, 0x9D, 0xB0 },
	0x8874,	{ 0xE5, 0x9D, 0xB1 },
	0x8875,	{ 0xE5, 0x9D, 0xB2 },
	0x8876,	{ 0xE5, 0x9D, 0xB4 },
	0x8877,	{ 0xE5, 0x9D, 0xB5 },
	0x8878,	{ 0xE5, 0x9D, 0xB8 },
	0x8879,	{ 0xE5, 0x9D, 0xB9 },
	0x887A,	{ 0xE5, 0x9D, 0xBA },
	0x887B,	{ 0xE5, 0x9D, 0xBD },
	0x887C,	{ 0xE5, 0x9D, 0xBE },
	0x887D,	{ 0xE5, 0x9D, 0xBF },
	0x887E,	{ 0xE5, 0x9E, 0x80 },
	0x8880,	{ 0xE5, 0x9E, 0x81 },
	0x8881,	{ 0xE5, 0x9E, 0x87 },
	0x8882,	{ 0xE5, 0x9E, 0x88 },
	0x8883,	{ 0xE5, 0x9E, 0x89 },
	0x8884,	{ 0xE5, 0x9E, 0x8A },
	0x8885,	{ 0xE5, 0x9E, 0x8D },
	0x8886,	{ 0xE5, 0x9E, 0x8E },
	0x8887,	{ 0xE5, 0x9E, 0x8F },
	0x8888,	{ 0xE5, 0x9E, 0x90 },
	0x8889,	{ 0xE5, 0x9E, 0x91 },
	0x888A,	{ 0xE5, 0x9E, 0x94 },
	0x888B,	{ 0xE5, 0x9E, 0x95 },
	0x888C,	{ 0xE5, 0x9E, 0x96 },
	0x888D,	{ 0xE5, 0x9E, 0x97 },
	0x888E,	{ 0xE5, 0x9E, 0x98 },
	0x888F,	{ 0xE5, 0x9E, 0x99 },
	0x8890,	{ 0xE5, 0x9E, 0x9A },
	0x8891,	{ 0xE5, 0x9E, 0x9C },
	0x8892,	{ 0xE5, 0x9E, 0x9D },
	0x8893,	{ 0xE5, 0x9E, 0x9E },
	0x8894,	{ 0xE5, 0x9E, 0x9F },
	0x8895,	{ 0xE5, 0x9E, 0xA5 },
	0x8896,	{ 0xE5, 0x9E, 0xA8 },
	0x8897,	{ 0xE5, 0x9E, 0xAA },
	0x8898,	{ 0xE5, 0x9E, 0xAC },
	0x8899,	{ 0xE5, 0x9E, 0xAF },
	0x889A,	{ 0xE5, 0x9E, 0xB0 },
	0x889B,	{ 0xE5, 0x9E, 0xB1 },
	0x889C,	{ 0xE5, 0x9E, 0xB3 },
	0x889D,	{ 0xE5, 0x9E, 0xB5 },
	0x889E,	{ 0xE5, 0x9E, 0xB6 },
	0x889F,	{ 0xE5, 0x9E, 0xB7 },
	0x88A0,	{ 0xE5, 0x9E, 0xB9 },
	0x88A1,	{ 0xE5, 0x9E, 0xBA },
	0x88A2,	{ 0xE5, 0x9E, 0xBB },
	0x88A3,	{ 0xE5, 0x9E, 0xBC },
	0x88A4,	{ 0xE5, 0x9E, 0xBD },
	0x88A5,	{ 0xE5, 0x9E, 0xBE },
	0x88A6,	{ 0xE5, 0x9E, 0xBF },
	0x88A7,	{ 0xE5, 0x9F, 0x80 },
	0x88A8,	{ 0xE5, 0x9F, 0x81 },
	0x88A9,	{ 0xE5, 0x9F, 0x84 },
	0x88AA,	{ 0xE5, 0x9F, 0x85 },
	0x88AB,	{ 0xE5, 0x9F, 0x86 },
	0x88AC,	{ 0xE5, 0x9F, 0x87 },
	0x88AD,	{ 0xE5, 0x9F, 0x88 },
	0x88AE,	{ 0xE5, 0x9F, 0x89 },
	0x88AF,	{ 0xE5, 0x9F, 0x8A },
	0x88B0,	{ 0xE5, 0x9F, 0x8C },
	0x88B1,	{ 0xE5, 0x9F, 0x8D },
	0x88B2,	{ 0xE5, 0x9F, 0x90 },
	0x88B3,	{ 0xE5, 0x9F, 0x91 },
	0x88B4,	{ 0xE5, 0x9F, 0x93 },
	0x88B5,	{ 0xE5, 0x9F, 0x96 },
	0x88B6,	{ 0xE5, 0x9F, 0x97 },
	0x88B7,	{ 0xE5, 0x9F, 0x9B },
	0x88B8,	{ 0xE5, 0x9F, 0x9C },
	0x88B9,	{ 0xE5, 0x9F, 0x9E },
	0x88BA,	{ 0xE5, 0x9F, 0xA1 },
	0x88BB,	{ 0xE5, 0x9F, 0xA2 },
	0x88BC,	{ 0xE5, 0x9F, 0xA3 },
	0x88BD,	{ 0xE5, 0x9F, 0xA5 },
	0x88BE,	{ 0xE5, 0x9F, 0xA6 },
	0x88BF,	{ 0xE5, 0x9F, 0xA7 },
	0x88C0,	{ 0xE5, 0x9F, 0xA8 },
	0x88C1,	{ 0xE5, 0x9F, 0xA9 },
	0x88C2,	{ 0xE5, 0x9F, 0xAA },
	0x88C3,	{ 0xE5, 0x9F, 0xAB },
	0x88C4,	{ 0xE5, 0x9F, 0xAC },
	0x88C5,	{ 0xE5, 0x9F, 0xAE },
	0x88C6,	{ 0xE5, 0x9F, 0xB0 },
	0x88C7,	{ 0xE5, 0x9F, 0xB1 },
	0x88C8,	{ 0xE5, 0x9F, 0xB2 },
	0x88C9,	{ 0xE5, 0x9F, 0xB3 },
	0x88CA,	{ 0xE5, 0x9F, 0xB5 },
	0x88CB,	{ 0xE5, 0x9F, 0xB6 },
	0x88CC,	{ 0xE5, 0x9F, 0xB7 },
	0x88CD,	{ 0xE5, 0x9F, 0xBB },
	0x88CE,	{ 0xE5, 0x9F, 0xBC },
	0x88CF,	{ 0xE5, 0x9F, 0xBE },
	0x88D0,	{ 0xE5, 0x9F, 0xBF },
	0x88D1,	{ 0xE5, 0xA0, 0x81 },
	0x88D2,	{ 0xE5, 0xA0, 0x83 },
	0x88D3,	{ 0xE5, 0xA0, 0x84 },
	0x88D4,	{ 0xE5, 0xA0, 0x85 },
	0x88D5,	{ 0xE5, 0xA0, 0x88 },
	0x88D6,	{ 0xE5, 0xA0, 0x89 },
	0x88D7,	{ 0xE5, 0xA0, 0x8A },
	0x88D8,	{ 0xE5, 0xA0, 0x8C },
	0x88D9,	{ 0xE5, 0xA0, 0x8E },
	0x88DA,	{ 0xE5, 0xA0, 0x8F },
	0x88DB,	{ 0xE5, 0xA0, 0x90 },
	0x88DC,	{ 0xE5, 0xA0, 0x92 },
	0x88DD,	{ 0xE5, 0xA0, 0x93 },
	0x88DE,	{ 0xE5, 0xA0, 0x94 },
	0x88DF,	{ 0xE5, 0xA0, 0x96 },
	0x88E0,	{ 0xE5, 0xA0, 0x97 },
	0x88E1,	{ 0xE5, 0xA0, 0x98 },
	0x88E2,	{ 0xE5, 0xA0, 0x9A },
	0x88E3,	{ 0xE5, 0xA0, 0x9B },
	0x88E4,	{ 0xE5, 0xA0, 0x9C },
	0x88E5,	{ 0xE5, 0xA0, 0x9D },
	0x88E6,	{ 0xE5, 0xA0, 0x9F },
	0x88E7,	{ 0xE5, 0xA0, 0xA2 },
	0x88E8,	{ 0xE5, 0xA0, 0xA3 },
	0x88E9,	{ 0xE5, 0xA0, 0xA5 },
	0x88EA,	{ 0xE5, 0xA0, 0xA6 },
	0x88EB,	{ 0xE5, 0xA0, 0xA7 },
	0x88EC,	{ 0xE5, 0xA0, 0xA8 },
	0x88ED,	{ 0xE5, 0xA0, 0xA9 },
	0x88EE,	{ 0xE5, 0xA0, 0xAB },
	0x88EF,	{ 0xE5, 0xA0, 0xAC },
	0x88F0,	{ 0xE5, 0xA0, 0xAD },
	0x88F1,	{ 0xE5, 0xA0, 0xAE },
	0x88F2,	{ 0xE5, 0xA0, 0xAF },
	0x88F3,	{ 0xE5, 0xA0, 0xB1 },
	0x88F4,	{ 0xE5, 0xA0, 0xB2 },
	0x88F5,	{ 0xE5, 0xA0, 0xB3 },
	0x88F6,	{ 0xE5, 0xA0, 0xB4 },
	0x88F7,	{ 0xE5, 0xA0, 0xB6 },
	0x88F8,	{ 0xE5, 0xA0, 0xB7 },
	0x88F9,	{ 0xE5, 0xA0, 0xB8 },
	0x88FA,	{ 0xE5, 0xA0, 0xB9 },
	0x88FB,	{ 0xE5, 0xA0, 0xBA },
	0x88FC,	{ 0xE5, 0xA0, 0xBB },
	0x88FD,	{ 0xE5, 0xA0, 0xBC },
	0x88FE,	{ 0xE5, 0xA0, 0xBD },
	0x8940,	{ 0xE5, 0xA0, 0xBE },
	0x8941,	{ 0xE5, 0xA0, 0xBF },
	0x8942,	{ 0xE5, 0xA1, 0x80 },
	0x8943,	{ 0xE5, 0xA1, 0x81 },
	0x8944,	{ 0xE5, 0xA1, 0x82 },
	0x8945,	{ 0xE5, 0xA1, 0x83 },
	0x8946,	{ 0xE5, 0xA1, 0x85 },
	0x8947,	{ 0xE5, 0xA1, 0x86 },
	0x8948,	{ 0xE5, 0xA1, 0x87 },
	0x8949,	{ 0xE5, 0xA1, 0x88 },
	0x894A,	{ 0xE5, 0xA1, 0x89 },
	0x894B,	{ 0xE5, 0xA1, 0x8A },
	0x894C,	{ 0xE5, 0xA1, 0x8B },
	0x894D,	{ 0xE5, 0xA1, 0x8E },
	0x894E,	{ 0xE5, 0xA1, 0x8F },
	0x894F,	{ 0xE5, 0xA1, 0x90 },
	0x8950,	{ 0xE5, 0xA1, 0x92 },
	0x8951,	{ 0xE5, 0xA1, 0x93 },
	0x8952,	{ 0xE5, 0xA1, 0x95 },
	0x8953,	{ 0xE5, 0xA1, 0x96 },
	0x8954,	{ 0xE5, 0xA1, 0x97 },
	0x8955,	{ 0xE5, 0xA1, 0x99 },
	0x8956,	{ 0xE5, 0xA1, 0x9A },
	0x8957,	{ 0xE5, 0xA1, 0x9B },
	0x8958,	{ 0xE5, 0xA1, 0x9C },
	0x8959,	{ 0xE5, 0xA1, 0x9D },
	0x895A,	{ 0xE5, 0xA1, 0x9F },
	0x895B,	{ 0xE5, 0xA1, 0xA0 },
	0x895C,	{ 0xE5, 0xA1, 0xA1 },
	0x895D,	{ 0xE5, 0xA1, 0xA2 },
	0x895E,	{ 0xE5, 0xA1, 0xA3 },
	0x895F,	{ 0xE5, 0xA1, 0xA4 },
	0x8960,	{ 0xE5, 0xA1, 0xA6 },
	0x8961,	{ 0xE5, 0xA1, 0xA7 },
	0x8962,	{ 0xE5, 0xA1, 0xA8 },
	0x8963,	{ 0xE5, 0xA1, 0xA9 },
	0x8964,	{ 0xE5, 0xA1, 0xAA },
	0x8965,	{ 0xE5, 0xA1, 0xAD },
	0x8966,	{ 0xE5, 0xA1, 0xAE },
	0x8967,	{ 0xE5, 0xA1, 0xAF },
	0x8968,	{ 0xE5, 0xA1, 0xB0 },
	0x8969,	{ 0xE5, 0xA1, 0xB1 },
	0x896A,	{ 0xE5, 0xA1, 0xB2 },
	0x896B,	{ 0xE5, 0xA1, 0xB3 },
	0x896C,	{ 0xE5, 0xA1, 0xB4 },
	0x896D,	{ 0xE5, 0xA1, 0xB5 },
	0x896E,	{ 0xE5, 0xA1, 0xB6 },
	0x896F,	{ 0xE5, 0xA1, 0xB7 },
	0x8970,	{ 0xE5, 0xA1, 0xB8 },
	0x8971,	{ 0xE5, 0xA1, 0xB9 },
	0x8972,	{ 0xE5, 0xA1, 0xBA },
	0x8973,	{ 0xE5, 0xA1, 0xBB },
	0x8974,	{ 0xE5, 0xA1, 0xBC },
	0x8975,	{ 0xE5, 0xA1, 0xBD },
	0x8976,	{ 0xE5, 0xA1, 0xBF },
	0x8977,	{ 0xE5, 0xA2, 0x82 },
	0x8978,	{ 0xE5, 0xA2, 0x84 },
	0x8979,	{ 0xE5, 0xA2, 0x86 },
	0x897A,	{ 0xE5, 0xA2, 0x87 },
	0x897B,	{ 0xE5, 0xA2, 0x88 },
	0x897C,	{ 0xE5, 0xA2, 0x8A },
	0x897D,	{ 0xE5, 0xA2, 0x8B },
	0x897E,	{ 0xE5, 0xA2, 0x8C },
	0x8980,	{ 0xE5, 0xA2, 0x8D },
	0x8981,	{ 0xE5, 0xA2, 0x8E },
	0x8982,	{ 0xE5, 0xA2, 0x8F },
	0x8983,	{ 0xE5, 0xA2, 0x90 },
	0x8984,	{ 0xE5, 0xA2, 0x91 },
	0x8985,	{ 0xE5, 0xA2, 0x94 },
	0x8986,	{ 0xE5, 0xA2, 0x95 },
	0x8987,	{ 0xE5, 0xA2, 0x96 },
	0x8988,	{ 0xE5, 0xA2, 0x97 },
	0x8989,	{ 0xE5, 0xA2, 0x98 },
	0x898A,	{ 0xE5, 0xA2, 0x9B },
	0x898B,	{ 0xE5, 0xA2, 0x9C },
	0x898C,	{ 0xE5, 0xA2, 0x9D },
	0x898D,	{ 0xE5, 0xA2, 0xA0 },
	0x898E,	{ 0xE5, 0xA2, 0xA1 },
	0x898F,	{ 0xE5, 0xA2, 0xA2 },
	0x8990,	{ 0xE5, 0xA2, 0xA3 },
	0x8991,	{ 0xE5, 0xA2, 0xA4 },
	0x8992,	{ 0xE5, 0xA2, 0xA5 },
	0x8993,	{ 0xE5, 0xA2, 0xA6 },
	0x8994,	{ 0xE5, 0xA2, 0xA7 },
	0x8995,	{ 0xE5, 0xA2, 0xAA },
	0x8996,	{ 0xE5, 0xA2, 0xAB },
	0x8997,	{ 0xE5, 0xA2, 0xAC },
	0x8998,	{ 0xE5, 0xA2, 0xAD },
	0x8999,	{ 0xE5, 0xA2, 0xAE },
	0x899A,	{ 0xE5, 0xA2, 0xAF },
	0x899B,	{ 0xE5, 0xA2, 0xB0 },
	0x899C,	{ 0xE5, 0xA2, 0xB1 },
	0x899D,	{ 0xE5, 0xA2, 0xB2 },
	0x899E,	{ 0xE5, 0xA2, 0xB3 },
	0x899F,	{ 0xE5, 0xA2, 0xB4 },
	0x89A0,	{ 0xE5, 0xA2, 0xB5 },
	0x89A1,	{ 0xE5, 0xA2, 0xB6 },
	0x89A2,	{ 0xE5, 0xA2, 0xB7 },
	0x89A3,	{ 0xE5, 0xA2, 0xB8 },
	0x89A4,	{ 0xE5, 0xA2, 0xB9 },
	0x89A5,	{ 0xE5, 0xA2, 0xBA },
	0x89A6,	{ 0xE5, 0xA2, 0xBB },
	0x89A7,	{ 0xE5, 0xA2, 0xBD },
	0x89A8,	{ 0xE5, 0xA2, 0xBE },
	0x89A9,	{ 0xE5, 0xA2, 0xBF },
	0x89AA,	{ 0xE5, 0xA3, 0x80 },
	0x89AB,	{ 0xE5, 0xA3, 0x82 },
	0x89AC,	{ 0xE5, 0xA3, 0x83 },
	0x89AD,	{ 0xE5, 0xA3, 0x84 },
	0x89AE,	{ 0xE5, 0xA3, 0x86 },
	0x89AF,	{ 0xE5, 0xA3, 0x87 },
	0x89B0,	{ 0xE5, 0xA3, 0x88 },
	0x89B1,	{ 0xE5, 0xA3, 0x89 },
	0x89B2,	{ 0xE5, 0xA3, 0x8A },
	0x89B3,	{ 0xE5, 0xA3, 0x8B },
	0x89B4,	{ 0xE5, 0xA3, 0x8C },
	0x89B5,	{ 0xE5, 0xA3, 0x8D },
	0x89B6,	{ 0xE5, 0xA3, 0x8E },
	0x89B7,	{ 0xE5, 0xA3, 0x8F },
	0x89B8,	{ 0xE5, 0xA3, 0x90 },
	0x89B9,	{ 0xE5, 0xA3, 0x92 },
	0x89BA,	{ 0xE5, 0xA3, 0x93 },
	0x89BB,	{ 0xE5, 0xA3, 0x94 },
	0x89BC,	{ 0xE5, 0xA3, 0x96 },
	0x89BD,	{ 0xE5, 0xA3, 0x97 },
	0x89BE,	{ 0xE5, 0xA3, 0x98 },
	0x89BF,	{ 0xE5, 0xA3, 0x99 },
	0x89C0,	{ 0xE5, 0xA3, 0x9A },
	0x89C1,	{ 0xE5, 0xA3, 0x9B },
	0x89C2,	{ 0xE5, 0xA3, 0x9C },
	0x89C3,	{ 0xE5, 0xA3, 0x9D },
	0x89C4,	{ 0xE5, 0xA3, 0x9E },
	0x89C5,	{ 0xE5, 0xA3, 0x9F },
	0x89C6,	{ 0xE5, 0xA3, 0xA0 },
	0x89C7,	{ 0xE5, 0xA3, 0xA1 },
	0x89C8,	{ 0xE5, 0xA3, 0xA2 },
	0x89C9,	{ 0xE5, 0xA3, 0xA3 },
	0x89CA,	{ 0xE5, 0xA3, 0xA5 },
	0x89CB,	{ 0xE5, 0xA3, 0xA6 },
	0x89CC,	{ 0xE5, 0xA3, 0xA7 },
	0x89CD,	{ 0xE5, 0xA3, 0xA8 },
	0x89CE,	{ 0xE5, 0xA3, 0xA9 },
	0x89CF,	{ 0xE5, 0xA3, 0xAA },
	0x89D0,	{ 0xE5, 0xA3, 0xAD },
	0x89D1,	{ 0xE5, 0xA3, 0xAF },
	0x89D2,	{ 0xE5, 0xA3, 0xB1 },
	0x89D3,	{ 0xE5, 0xA3, 0xB2 },
	0x89D4,	{ 0xE5, 0xA3, 0xB4 },
	0x89D5,	{ 0xE5, 0xA3, 0xB5 },
	0x89D6,	{ 0xE5, 0xA3, 0xB7 },
	0x89D7,	{ 0xE5, 0xA3, 0xB8 },
	0x89D8,	{ 0xE5, 0xA3, 0xBA },
	0x89D9,	{ 0xE5, 0xA3, 0xBB },
	0x89DA,	{ 0xE5, 0xA3, 0xBC },
	0x89DB,	{ 0xE5, 0xA3, 0xBD },
	0x89DC,	{ 0xE5, 0xA3, 0xBE },
	0x89DD,	{ 0xE5, 0xA3, 0xBF },
	0x89DE,	{ 0xE5, 0xA4, 0x80 },
	0x89DF,	{ 0xE5, 0xA4, 0x81 },
	0x89E0,	{ 0xE5, 0xA4, 0x83 },
	0x89E1,	{ 0xE5, 0xA4, 0x85 },
	0x89E2,	{ 0xE5, 0xA4, 0x86 },
	0x89E3,	{ 0xE5, 0xA4, 0x88 },
	0x89E4,	{ 0xE5, 0xA4, 0x89 },
	0x89E5,	{ 0xE5, 0xA4, 0x8A },
	0x89E6,	{ 0xE5, 0xA4, 0x8B },
	0x89E7,	{ 0xE5, 0xA4, 0x8C },
	0x89E8,	{ 0xE5, 0xA4, 0x8E },
	0x89E9,	{ 0xE5, 0xA4, 0x90 },
	0x89EA,	{ 0xE5, 0xA4, 0x91 },
	0x89EB,	{ 0xE5, 0xA4, 0x92 },
	0x89EC,	{ 0xE5, 0xA4, 0x93 },
	0x89ED,	{ 0xE5, 0xA4, 0x97 },
	0x89EE,	{ 0xE5, 0xA4, 0x98 },
	0x89EF,	{ 0xE5, 0xA4, 0x9B },
	0x89F0,	{ 0xE5, 0xA4, 0x9D },
	0x89F1,	{ 0xE5, 0xA4, 0x9E },
	0x89F2,	{ 0xE5, 0xA4, 0xA0 },
	0x89F3,	{ 0xE5, 0xA4, 0xA1 },
	0x89F4,	{ 0xE5, 0xA4, 0xA2 },
	0x89F5,	{ 0xE5, 0xA4, 0xA3 },
	0x89F6,	{ 0xE5, 0xA4, 0xA6 },
	0x89F7,	{ 0xE5, 0xA4, 0xA8 },
	0x89F8,	{ 0xE5, 0xA4, 0xAC },
	0x89F9,	{ 0xE5, 0xA4, 0xB0 },
	0x89FA,	{ 0xE5, 0xA4, 0xB2 },
	0x89FB,	{ 0xE5, 0xA4, 0xB3 },
	0x89FC,	{ 0xE5, 0xA4, 0xB5 },
	0x89FD,	{ 0xE5, 0xA4, 0xB6 },
	0x89FE,	{ 0xE5, 0xA4, 0xBB },
	0x8A40,	{ 0xE5, 0xA4, 0xBD },
	0x8A41,	{ 0xE5, 0xA4, 0xBE },
	0x8A42,	{ 0xE5, 0xA4, 0xBF },
	0x8A43,	{ 0xE5, 0xA5, 0x80 },
	0x8A44,	{ 0xE5, 0xA5, 0x83 },
	0x8A45,	{ 0xE5, 0xA5, 0x85 },
	0x8A46,	{ 0xE5, 0xA5, 0x86 },
	0x8A47,	{ 0xE5, 0xA5, 0x8A },
	0x8A48,	{ 0xE5, 0xA5, 0x8C },
	0x8A49,	{ 0xE5, 0xA5, 0x8D },
	0x8A4A,	{ 0xE5, 0xA5, 0x90 },
	0x8A4B,	{ 0xE5, 0xA5, 0x92 },
	0x8A4C,	{ 0xE5, 0xA5, 0x93 },
	0x8A4D,	{ 0xE5, 0xA5, 0x99 },
	0x8A4E,	{ 0xE5, 0xA5, 0x9B },
	0x8A4F,	{ 0xE5, 0xA5, 0x9C },
	0x8A50,	{ 0xE5, 0xA5, 0x9D },
	0x8A51,	{ 0xE5, 0xA5, 0x9E },
	0x8A52,	{ 0xE5, 0xA5, 0x9F },
	0x8A53,	{ 0xE5, 0xA5, 0xA1 },
	0x8A54,	{ 0xE5, 0xA5, 0xA3 },
	0x8A55,	{ 0xE5, 0xA5, 0xA4 },
	0x8A56,	{ 0xE5, 0xA5, 0xA6 },
	0x8A57,	{ 0xE5, 0xA5, 0xA7 },
	0x8A58,	{ 0xE5, 0xA5, 0xA8 },
	0x8A59,	{ 0xE5, 0xA5, 0xA9 },
	0x8A5A,	{ 0xE5, 0xA5, 0xAA },
	0x8A5B,	{ 0xE5, 0xA5, 0xAB },
	0x8A5C,	{ 0xE5, 0xA5, 0xAC },
	0x8A5D,	{ 0xE5, 0xA5, 0xAD },
	0x8A5E,	{ 0xE5, 0xA5, 0xAE },
	0x8A5F,	{ 0xE5, 0xA5, 0xAF },
	0x8A60,	{ 0xE5, 0xA5, 0xB0 },
	0x8A61,	{ 0xE5, 0xA5, 0xB1 },
	0x8A62,	{ 0xE5, 0xA5, 0xB2 },
	0x8A63,	{ 0xE5, 0xA5, 0xB5 },
	0x8A64,	{ 0xE5, 0xA5, 0xB7 },
	0x8A65,	{ 0xE5, 0xA5, 0xBA },
	0x8A66,	{ 0xE5, 0xA5, 0xBB },
	0x8A67,	{ 0xE5, 0xA5, 0xBC },
	0x8A68,	{ 0xE5, 0xA5, 0xBE },
	0x8A69,	{ 0xE5, 0xA5, 0xBF },
	0x8A6A,	{ 0xE5, 0xA6, 0x80 },
	0x8A6B,	{ 0xE5, 0xA6, 0x85 },
	0x8A6C,	{ 0xE5, 0xA6, 0x89 },
	0x8A6D,	{ 0xE5, 0xA6, 0x8B },
	0x8A6E,	{ 0xE5, 0xA6, 0x8C },
	0x8A6F,	{ 0xE5, 0xA6, 0x8E },
	0x8A70,	{ 0xE5, 0xA6, 0x8F },
	0x8A71,	{ 0xE5, 0xA6, 0x90 },
	0x8A72,	{ 0xE5, 0xA6, 0x91 },
	0x8A73,	{ 0xE5, 0xA6, 0x94 },
	0x8A74,	{ 0xE5, 0xA6, 0x95 },
	0x8A75,	{ 0xE5, 0xA6, 0x98 },
	0x8A76,	{ 0xE5, 0xA6, 0x9A },
	0x8A77,	{ 0xE5, 0xA6, 0x9B },
	0x8A78,	{ 0xE5, 0xA6, 0x9C },
	0x8A79,	{ 0xE5, 0xA6, 0x9D },
	0x8A7A,	{ 0xE5, 0xA6, 0x9F },
	0x8A7B,	{ 0xE5, 0xA6, 0xA0 },
	0x8A7C,	{ 0xE5, 0xA6, 0xA1 },
	0x8A7D,	{ 0xE5, 0xA6, 0xA2 },
	0x8A7E,	{ 0xE5, 0xA6, 0xA6 },
	0x8A80,	{ 0xE5, 0xA6, 0xA7 },
	0x8A81,	{ 0xE5, 0xA6, 0xAC },
	0x8A82,	{ 0xE5, 0xA6, 0xAD },
	0x8A83,	{ 0xE5, 0xA6, 0xB0 },
	0x8A84,	{ 0xE5, 0xA6, 0xB1 },
	0x8A85,	{ 0xE5, 0xA6, 0xB3 },
	0x8A86,	{ 0xE5, 0xA6, 0xB4 },
	0x8A87,	{ 0xE5, 0xA6, 0xB5 },
	0x8A88,	{ 0xE5, 0xA6, 0xB6 },
	0x8A89,	{ 0xE5, 0xA6, 0xB7 },
	0x8A8A,	{ 0xE5, 0xA6, 0xB8 },
	0x8A8B,	{ 0xE5, 0xA6, 0xBA },
	0x8A8C,	{ 0xE5, 0xA6, 0xBC },
	0x8A8D,	{ 0xE5, 0xA6, 0xBD },
	0x8A8E,	{ 0xE5, 0xA6, 0xBF },
	0x8A8F,	{ 0xE5, 0xA7, 0x80 },
	0x8A90,	{ 0xE5, 0xA7, 0x81 },
	0x8A91,	{ 0xE5, 0xA7, 0x82 },
	0x8A92,	{ 0xE5, 0xA7, 0x83 },
	0x8A93,	{ 0xE5, 0xA7, 0x84 },
	0x8A94,	{ 0xE5, 0xA7, 0x85 },
	0x8A95,	{ 0xE5, 0xA7, 0x87 },
	0x8A96,	{ 0xE5, 0xA7, 0x88 },
	0x8A97,	{ 0xE5, 0xA7, 0x89 },
	0x8A98,	{ 0xE5, 0xA7, 0x8C },
	0x8A99,	{ 0xE5, 0xA7, 0x8D },
	0x8A9A,	{ 0xE5, 0xA7, 0x8E },
	0x8A9B,	{ 0xE5, 0xA7, 0x8F },
	0x8A9C,	{ 0xE5, 0xA7, 0x95 },
	0x8A9D,	{ 0xE5, 0xA7, 0x96 },
	0x8A9E,	{ 0xE5, 0xA7, 0x99 },
	0x8A9F,	{ 0xE5, 0xA7, 0x9B },
	0x8AA0,	{ 0xE5, 0xA7, 0x9E },
	0x8AA1,	{ 0xE5, 0xA7, 0x9F },
	0x8AA2,	{ 0xE5, 0xA7, 0xA0 },
	0x8AA3,	{ 0xE5, 0xA7, 0xA1 },
	0x8AA4,	{ 0xE5, 0xA7, 0xA2 },
	0x8AA5,	{ 0xE5, 0xA7, 0xA4 },
	0x8AA6,	{ 0xE5, 0xA7, 0xA6 },
	0x8AA7,	{ 0xE5, 0xA7, 0xA7 },
	0x8AA8,	{ 0xE5, 0xA7, 0xA9 },
	0x8AA9,	{ 0xE5, 0xA7, 0xAA },
	0x8AAA,	{ 0xE5, 0xA7, 0xAB },
	0x8AAB,	{ 0xE5, 0xA7, 0xAD },
	0x8AAC,	{ 0xE5, 0xA7, 0xAE },
	0x8AAD,	{ 0xE5, 0xA7, 0xAF },
	0x8AAE,	{ 0xE5, 0xA7, 0xB0 },
	0x8AAF,	{ 0xE5, 0xA7, 0xB1 },
	0x8AB0,	{ 0xE5, 0xA7, 0xB2 },
	0x8AB1,	{ 0xE5, 0xA7, 0xB3 },
	0x8AB2,	{ 0xE5, 0xA7, 0xB4 },
	0x8AB3,	{ 0xE5, 0xA7, 0xB5 },
	0x8AB4,	{ 0xE5, 0xA7, 0xB6 },
	0x8AB5,	{ 0xE5, 0xA7, 0xB7 },
	0x8AB6,	{ 0xE5, 0xA7, 0xB8 },
	0x8AB7,	{ 0xE5, 0xA7, 0xBA },
	0x8AB8,	{ 0xE5, 0xA7, 0xBC },
	0x8AB9,	{ 0xE5, 0xA7, 0xBD },
	0x8ABA,	{ 0xE5, 0xA7, 0xBE },
	0x8ABB,	{ 0xE5, 0xA8, 0x80 },
	0x8ABC,	{ 0xE5, 0xA8, 0x82 },
	0x8ABD,	{ 0xE5, 0xA8, 0x8A },
	0x8ABE,	{ 0xE5, 0xA8, 0x8B },
	0x8ABF,	{ 0xE5, 0xA8, 0x8D },
	0x8AC0,	{ 0xE5, 0xA8, 0x8E },
	0x8AC1,	{ 0xE5, 0xA8, 0x8F },
	0x8AC2,	{ 0xE5, 0xA8, 0x90 },
	0x8AC3,	{ 0xE5, 0xA8, 0x92 },
	0x8AC4,	{ 0xE5, 0xA8, 0x94 },
	0x8AC5,	{ 0xE5, 0xA8, 0x95 },
	0x8AC6,	{ 0xE5, 0xA8, 0x96 },
	0x8AC7,	{ 0xE5, 0xA8, 0x97 },
	0x8AC8,	{ 0xE5, 0xA8, 0x99 },
	0x8AC9,	{ 0xE5, 0xA8, 0x9A },
	0x8ACA,	{ 0xE5, 0xA8, 0x9B },
	0x8ACB,	{ 0xE5, 0xA8, 0x9D },
	0x8ACC,	{ 0xE5, 0xA8, 0x9E },
	0x8ACD,	{ 0xE5, 0xA8, 0xA1 },
	0x8ACE,	{ 0xE5, 0xA8, 0xA2 },
	0x8ACF,	{ 0xE5, 0xA8, 0xA4 },
	0x8AD0,	{ 0xE5, 0xA8, 0xA6 },
	0x8AD1,	{ 0xE5, 0xA8, 0xA7 },
	0x8AD2,	{ 0xE5, 0xA8, 0xA8 },
	0x8AD3,	{ 0xE5, 0xA8, 0xAA },
	0x8AD4,	{ 0xE5, 0xA8, 0xAB },
	0x8AD5,	{ 0xE5, 0xA8, 0xAC },
	0x8AD6,	{ 0xE5, 0xA8, 0xAD },
	0x8AD7,	{ 0xE5, 0xA8, 0xAE },
	0x8AD8,	{ 0xE5, 0xA8, 0xAF },
	0x8AD9,	{ 0xE5, 0xA8, 0xB0 },
	0x8ADA,	{ 0xE5, 0xA8, 0xB3 },
	0x8ADB,	{ 0xE5, 0xA8, 0xB5 },
	0x8ADC,	{ 0xE5, 0xA8, 0xB7 },
	0x8ADD,	{ 0xE5, 0xA8, 0xB8 },
	0x8ADE,	{ 0xE5, 0xA8, 0xB9 },
	0x8ADF,	{ 0xE5, 0xA8, 0xBA },
	0x8AE0,	{ 0xE5, 0xA8, 0xBB },
	0x8AE1,	{ 0xE5, 0xA8, 0xBD },
	0x8AE2,	{ 0xE5, 0xA8, 0xBE },
	0x8AE3,	{ 0xE5, 0xA8, 0xBF },
	0x8AE4,	{ 0xE5, 0xA9, 0x81 },
	0x8AE5,	{ 0xE5, 0xA9, 0x82 },
	0x8AE6,	{ 0xE5, 0xA9, 0x83 },
	0x8AE7,	{ 0xE5, 0xA9, 0x84 },
	0x8AE8,	{ 0xE5, 0xA9, 0x85 },
	0x8AE9,	{ 0xE5, 0xA9, 0x87 },
	0x8AEA,	{ 0xE5, 0xA9, 0x88 },
	0x8AEB,	{ 0xE5, 0xA9, 0x8B },
	0x8AEC,	{ 0xE5, 0xA9, 0x8C },
	0x8AED,	{ 0xE5, 0xA9, 0x8D },
	0x8AEE,	{ 0xE5, 0xA9, 0x8E },
	0x8AEF,	{ 0xE5, 0xA9, 0x8F },
	0x8AF0,	{ 0xE5, 0xA9, 0x90 },
	0x8AF1,	{ 0xE5, 0xA9, 0x91 },
	0x8AF2,	{ 0xE5, 0xA9, 0x92 },
	0x8AF3,	{ 0xE5, 0xA9, 0x93 },
	0x8AF4,	{ 0xE5, 0xA9, 0x94 },
	0x8AF5,	{ 0xE5, 0xA9, 0x96 },
	0x8AF6,	{ 0xE5, 0xA9, 0x97 },
	0x8AF7,	{ 0xE5, 0xA9, 0x98 },
	0x8AF8,	{ 0xE5, 0xA9, 0x99 },
	0x8AF9,	{ 0xE5, 0xA9, 0x9B },
	0x8AFA,	{ 0xE5, 0xA9, 0x9C },
	0x8AFB,	{ 0xE5, 0xA9, 0x9D },
	0x8AFC,	{ 0xE5, 0xA9, 0x9E },
	0x8AFD,	{ 0xE5, 0xA9, 0x9F },
	0x8AFE,	{ 0xE5, 0xA9, 0xA0 },
	0x8B40,	{ 0xE5, 0xA9, 0xA1 },
	0x8B41,	{ 0xE5, 0xA9, 0xA3 },
	0x8B42,	{ 0xE5, 0xA9, 0xA4 },
	0x8B43,	{ 0xE5, 0xA9, 0xA5 },
	0x8B44,	{ 0xE5, 0xA9, 0xA6 },
	0x8B45,	{ 0xE5, 0xA9, 0xA8 },
	0x8B46,	{ 0xE5, 0xA9, 0xA9 },
	0x8B47,	{ 0xE5, 0xA9, 0xAB },
	0x8B48,	{ 0xE5, 0xA9, 0xAC },
	0x8B49,	{ 0xE5, 0xA9, 0xAD },
	0x8B4A,	{ 0xE5, 0xA9, 0xAE },
	0x8B4B,	{ 0xE5, 0xA9, 0xAF },
	0x8B4C,	{ 0xE5, 0xA9, 0xB0 },
	0x8B4D,	{ 0xE5, 0xA9, 0xB1 },
	0x8B4E,	{ 0xE5, 0xA9, 0xB2 },
	0x8B4F,	{ 0xE5, 0xA9, 0xB3 },
	0x8B50,	{ 0xE5, 0xA9, 0xB8 },
	0x8B51,	{ 0xE5, 0xA9, 0xB9 },
	0x8B52,	{ 0xE5, 0xA9, 0xBB },
	0x8B53,	{ 0xE5, 0xA9, 0xBC },
	0x8B54,	{ 0xE5, 0xA9, 0xBD },
	0x8B55,	{ 0xE5, 0xA9, 0xBE },
	0x8B56,	{ 0xE5, 0xAA, 0x80 },
	0x8B57,	{ 0xE5, 0xAA, 0x81 },
	0x8B58,	{ 0xE5, 0xAA, 0x82 },
	0x8B59,	{ 0xE5, 0xAA, 0x83 },
	0x8B5A,	{ 0xE5, 0xAA, 0x84 },
	0x8B5B,	{ 0xE5, 0xAA, 0x85 },
	0x8B5C,	{ 0xE5, 0xAA, 0x86 },
	0x8B5D,	{ 0xE5, 0xAA, 0x87 },
	0x8B5E,	{ 0xE5, 0xAA, 0x88 },
	0x8B5F,	{ 0xE5, 0xAA, 0x89 },
	0x8B60,	{ 0xE5, 0xAA, 0x8A },
	0x8B61,	{ 0xE5, 0xAA, 0x8B },
	0x8B62,	{ 0xE5, 0xAA, 0x8C },
	0x8B63,	{ 0xE5, 0xAA, 0x8D },
	0x8B64,	{ 0xE5, 0xAA, 0x8E },
	0x8B65,	{ 0xE5, 0xAA, 0x8F },
	0x8B66,	{ 0xE5, 0xAA, 0x90 },
	0x8B67,	{ 0xE5, 0xAA, 0x91 },
	0x8B68,	{ 0xE5, 0xAA, 0x93 },
	0x8B69,	{ 0xE5, 0xAA, 0x94 },
	0x8B6A,	{ 0xE5, 0xAA, 0x95 },
	0x8B6B,	{ 0xE5, 0xAA, 0x96 },
	0x8B6C,	{ 0xE5, 0xAA, 0x97 },
	0x8B6D,	{ 0xE5, 0xAA, 0x98 },
	0x8B6E,	{ 0xE5, 0xAA, 0x99 },
	0x8B6F,	{ 0xE5, 0xAA, 0x9C },
	0x8B70,	{ 0xE5, 0xAA, 0x9D },
	0x8B71,	{ 0xE5, 0xAA, 0x9E },
	0x8B72,	{ 0xE5, 0xAA, 0x9F },
	0x8B73,	{ 0xE5, 0xAA, 0xA0 },
	0x8B74,	{ 0xE5, 0xAA, 0xA1 },
	0x8B75,	{ 0xE5, 0xAA, 0xA2 },
	0x8B76,	{ 0xE5, 0xAA, 0xA3 },
	0x8B77,	{ 0xE5, 0xAA, 0xA4 },
	0x8B78,	{ 0xE5, 0xAA, 0xA5 },
	0x8B79,	{ 0xE5, 0xAA, 0xA6 },
	0x8B7A,	{ 0xE5, 0xAA, 0xA7 },
	0x8B7B,	{ 0xE5, 0xAA, 0xA8 },
	0x8B7C,	{ 0xE5, 0xAA, 0xA9 },
	0x8B7D,	{ 0xE5, 0xAA, 0xAB },
	0x8B7E,	{ 0xE5, 0xAA, 0xAC },
	0x8B80,	{ 0xE5, 0xAA, 0xAD },
	0x8B81,	{ 0xE5, 0xAA, 0xAE },
	0x8B82,	{ 0xE5, 0xAA, 0xAF },
	0x8B83,	{ 0xE5, 0xAA, 0xB0 },
	0x8B84,	{ 0xE5, 0xAA, 0xB1 },
	0x8B85,	{ 0xE5, 0xAA, 0xB4 },
	0x8B86,	{ 0xE5, 0xAA, 0xB6 },
	0x8B87,	{ 0xE5, 0xAA, 0xB7 },
	0x8B88,	{ 0xE5, 0xAA, 0xB9 },
	0x8B89,	{ 0xE5, 0xAA, 0xBA },
	0x8B8A,	{ 0xE5, 0xAA, 0xBB },
	0x8B8B,	{ 0xE5, 0xAA, 0xBC },
	0x8B8C,	{ 0xE5, 0xAA, 0xBD },
	0x8B8D,	{ 0xE5, 0xAA, 0xBF },
	0x8B8E,	{ 0xE5, 0xAB, 0x80 },
	0x8B8F,	{ 0xE5, 0xAB, 0x83 },
	0x8B90,	{ 0xE5, 0xAB, 0x84 },
	0x8B91,	{ 0xE5, 0xAB, 0x85 },
	0x8B92,	{ 0xE5, 0xAB, 0x86 },
	0x8B93,	{ 0xE5, 0xAB, 0x87 },
	0x8B94,	{ 0xE5, 0xAB, 0x88 },
	0x8B95,	{ 0xE5, 0xAB, 0x8A },
	0x8B96,	{ 0xE5, 0xAB, 0x8B },
	0x8B97,	{ 0xE5, 0xAB, 0x8D },
	0x8B98,	{ 0xE5, 0xAB, 0x8E },
	0x8B99,	{ 0xE5, 0xAB, 0x8F },
	0x8B9A,	{ 0xE5, 0xAB, 0x90 },
	0x8B9B,	{ 0xE5, 0xAB, 0x91 },
	0x8B9C,	{ 0xE5, 0xAB, 0x93 },
	0x8B9D,	{ 0xE5, 0xAB, 0x95 },
	0x8B9E,	{ 0xE5, 0xAB, 0x97 },
	0x8B9F,	{ 0xE5, 0xAB, 0x99 },
	0x8BA0,	{ 0xE5, 0xAB, 0x9A },
	0x8BA1,	{ 0xE5, 0xAB, 0x9B },
	0x8BA2,	{ 0xE5, 0xAB, 0x9D },
	0x8BA3,	{ 0xE5, 0xAB, 0x9E },
	0x8BA4,	{ 0xE5, 0xAB, 0x9F },
	0x8BA5,	{ 0xE5, 0xAB, 0xA2 },
	0x8BA6,	{ 0xE5, 0xAB, 0xA4 },
	0x8BA7,	{ 0xE5, 0xAB, 0xA5 },
	0x8BA8,	{ 0xE5, 0xAB, 0xA7 },
	0x8BA9,	{ 0xE5, 0xAB, 0xA8 },
	0x8BAA,	{ 0xE5, 0xAB, 0xAA },
	0x8BAB,	{ 0xE5, 0xAB, 0xAC },
	0x8BAC,	{ 0xE5, 0xAB, 0xAD },
	0x8BAD,	{ 0xE5, 0xAB, 0xAE },
	0x8BAE,	{ 0xE5, 0xAB, 0xAF },
	0x8BAF,	{ 0xE5, 0xAB, 0xB0 },
	0x8BB0,	{ 0xE5, 0xAB, 0xB2 },
	0x8BB1,	{ 0xE5, 0xAB, 0xB3 },
	0x8BB2,	{ 0xE5, 0xAB, 0xB4 },
	0x8BB3,	{ 0xE5, 0xAB, 0xB5 },
	0x8BB4,	{ 0xE5, 0xAB, 0xB6 },
	0x8BB5,	{ 0xE5, 0xAB, 0xB7 },
	0x8BB6,	{ 0xE5, 0xAB, 0xB8 },
	0x8BB7,	{ 0xE5, 0xAB, 0xB9 },
	0x8BB8,	{ 0xE5, 0xAB, 0xBA },
	0x8BB9,	{ 0xE5, 0xAB, 0xBB },
	0x8BBA,	{ 0xE5, 0xAB, 0xBC },
	0x8BBB,	{ 0xE5, 0xAB, 0xBD },
	0x8BBC,	{ 0xE5, 0xAB, 0xBE },
	0x8BBD,	{ 0xE5, 0xAB, 0xBF },
	0x8BBE,	{ 0xE5, 0xAC, 0x80 },
	0x8BBF,	{ 0xE5, 0xAC, 0x81 },
	0x8BC0,	{ 0xE5, 0xAC, 0x82 },
	0x8BC1,	{ 0xE5, 0xAC, 0x83 },
	0x8BC2,	{ 0xE5, 0xAC, 0x84 },
	0x8BC3,	{ 0xE5, 0xAC, 0x85 },
	0x8BC4,	{ 0xE5, 0xAC, 0x86 },
	0x8BC5,	{ 0xE5, 0xAC, 0x87 },
	0x8BC6,	{ 0xE5, 0xAC, 0x88 },
	0x8BC7,	{ 0xE5, 0xAC, 0x8A },
	0x8BC8,	{ 0xE5, 0xAC, 0x8B },
	0x8BC9,	{ 0xE5, 0xAC, 0x8C },
	0x8BCA,	{ 0xE5, 0xAC, 0x8D },
	0x8BCB,	{ 0xE5, 0xAC, 0x8E },
	0x8BCC,	{ 0xE5, 0xAC, 0x8F },
	0x8BCD,	{ 0xE5, 0xAC, 0x90 },
	0x8BCE,	{ 0xE5, 0xAC, 0x91 },
	0x8BCF,	{ 0xE5, 0xAC, 0x92 },
	0x8BD0,	{ 0xE5, 0xAC, 0x93 },
	0x8BD1,	{ 0xE5, 0xAC, 0x94 },
	0x8BD2,	{ 0xE5, 0xAC, 0x95 },
	0x8BD3,	{ 0xE5, 0xAC, 0x98 },
	0x8BD4,	{ 0xE5, 0xAC, 0x99 },
	0x8BD5,	{ 0xE5, 0xAC, 0x9A },
	0x8BD6,	{ 0xE5, 0xAC, 0x9B },
	0x8BD7,	{ 0xE5, 0xAC, 0x9C },
	0x8BD8,	{ 0xE5, 0xAC, 0x9D },
	0x8BD9,	{ 0xE5, 0xAC, 0x9E },
	0x8BDA,	{ 0xE5, 0xAC, 0x9F },
	0x8BDB,	{ 0xE5, 0xAC, 0xA0 },
	0x8BDC,	{ 0xE5, 0xAC, 0xA1 },
	0x8BDD,	{ 0xE5, 0xAC, 0xA2 },
	0x8BDE,	{ 0xE5, 0xAC, 0xA3 },
	0x8BDF,	{ 0xE5, 0xAC, 0xA4 },
	0x8BE0,	{ 0xE5, 0xAC, 0xA5 },
	0x8BE1,	{ 0xE5, 0xAC, 0xA6 },
	0x8BE2,	{ 0xE5, 0xAC, 0xA7 },
	0x8BE3,	{ 0xE5, 0xAC, 0xA8 },
	0x8BE4,	{ 0xE5, 0xAC, 0xA9 },
	0x8BE5,	{ 0xE5, 0xAC, 0xAA },
	0x8BE6,	{ 0xE5, 0xAC, 0xAB },
	0x8BE7,	{ 0xE5, 0xAC, 0xAC },
	0x8BE8,	{ 0xE5, 0xAC, 0xAD },
	0x8BE9,	{ 0xE5, 0xAC, 0xAE },
	0x8BEA,	{ 0xE5, 0xAC, 0xAF },
	0x8BEB,	{ 0xE5, 0xAC, 0xB0 },
	0x8BEC,	{ 0xE5, 0xAC, 0xB1 },
	0x8BED,	{ 0xE5, 0xAC, 0xB3 },
	0x8BEE,	{ 0xE5, 0xAC, 0xB5 },
	0x8BEF,	{ 0xE5, 0xAC, 0xB6 },
	0x8BF0,	{ 0xE5, 0xAC, 0xB8 },
	0x8BF1,	{ 0xE5, 0xAC, 0xB9 },
	0x8BF2,	{ 0xE5, 0xAC, 0xBA },
	0x8BF3,	{ 0xE5, 0xAC, 0xBB },
	0x8BF4,	{ 0xE5, 0xAC, 0xBC },
	0x8BF5,	{ 0xE5, 0xAC, 0xBD },
	0x8BF6,	{ 0xE5, 0xAC, 0xBE },
	0x8BF7,	{ 0xE5, 0xAC, 0xBF },
	0x8BF8,	{ 0xE5, 0xAD, 0x81 },
	0x8BF9,	{ 0xE5, 0xAD, 0x82 },
	0x8BFA,	{ 0xE5, 0xAD, 0x83 },
	0x8BFB,	{ 0xE5, 0xAD, 0x84 },
	0x8BFC,	{ 0xE5, 0xAD, 0x85 },
	0x8BFD,	{ 0xE5, 0xAD, 0x86 },
	0x8BFE,	{ 0xE5, 0xAD, 0x87 },
	0x8C40,	{ 0xE5, 0xAD, 0x88 },
	0x8C41,	{ 0xE5, 0xAD, 0x89 },
	0x8C42,	{ 0xE5, 0xAD, 0x8A },
	0x8C43,	{ 0xE5, 0xAD, 0x8B },
	0x8C44,	{ 0xE5, 0xAD, 0x8C },
	0x8C45,	{ 0xE5, 0xAD, 0x8D },
	0x8C46,	{ 0xE5, 0xAD, 0x8E },
	0x8C47,	{ 0xE5, 0xAD, 0x8F },
	0x8C48,	{ 0xE5, 0xAD, 0x92 },
	0x8C49,	{ 0xE5, 0xAD, 0x96 },
	0x8C4A,	{ 0xE5, 0xAD, 0x9E },
	0x8C4B,	{ 0xE5, 0xAD, 0xA0 },
	0x8C4C,	{ 0xE5, 0xAD, 0xA1 },
	0x8C4D,	{ 0xE5, 0xAD, 0xA7 },
	0x8C4E,	{ 0xE5, 0xAD, 0xA8 },
	0x8C4F,	{ 0xE5, 0xAD, 0xAB },
	0x8C50,	{ 0xE5, 0xAD, 0xAD },
	0x8C51,	{ 0xE5, 0xAD, 0xAE },
	0x8C52,	{ 0xE5, 0xAD, 0xAF },
	0x8C53,	{ 0xE5, 0xAD, 0xB2 },
	0x8C54,	{ 0xE5, 0xAD, 0xB4 },
	0x8C55,	{ 0xE5, 0xAD, 0xB6 },
	0x8C56,	{ 0xE5, 0xAD, 0xB7 },
	0x8C57,	{ 0xE5, 0xAD, 0xB8 },
	0x8C58,	{ 0xE5, 0xAD, 0xB9 },
	0x8C59,	{ 0xE5, 0xAD, 0xBB },
	0x8C5A,	{ 0xE5, 0xAD, 0xBC },
	0x8C5B,	{ 0xE5, 0xAD, 0xBE },
	0x8C5C,	{ 0xE5, 0xAD, 0xBF },
	0x8C5D,	{ 0xE5, 0xAE, 0x82 },
	0x8C5E,	{ 0xE5, 0xAE, 0x86 },
	0x8C5F,	{ 0xE5, 0xAE, 0x8A },
	0x8C60,	{ 0xE5, 0xAE, 0x8D },
	0x8C61,	{ 0xE5, 0xAE, 0x8E },
	0x8C62,	{ 0xE5, 0xAE, 0x90 },
	0x8C63,	{ 0xE5, 0xAE, 0x91 },
	0x8C64,	{ 0xE5, 0xAE, 0x92 },
	0x8C65,	{ 0xE5, 0xAE, 0x94 },
	0x8C66,	{ 0xE5, 0xAE, 0x96 },
	0x8C67,	{ 0xE5, 0xAE, 0x9F },
	0x8C68,	{ 0xE5, 0xAE, 0xA7 },
	0x8C69,	{ 0xE5, 0xAE, 0xA8 },
	0x8C6A,	{ 0xE5, 0xAE, 0xA9 },
	0x8C6B,	{ 0xE5, 0xAE, 0xAC },
	0x8C6C,	{ 0xE5, 0xAE, 0xAD },
	0x8C6D,	{ 0xE5, 0xAE, 0xAE },
	0x8C6E,	{ 0xE5, 0xAE, 0xAF },
	0x8C6F,	{ 0xE5, 0xAE, 0xB1 },
	0x8C70,	{ 0xE5, 0xAE, 0xB2 },
	0x8C71,	{ 0xE5, 0xAE, 0xB7 },
	0x8C72,	{ 0xE5, 0xAE, 0xBA },
	0x8C73,	{ 0xE5, 0xAE, 0xBB },
	0x8C74,	{ 0xE5, 0xAE, 0xBC },
	0x8C75,	{ 0xE5, 0xAF, 0x80 },
	0x8C76,	{ 0xE5, 0xAF, 0x81 },
	0x8C77,	{ 0xE5, 0xAF, 0x83 },
	0x8C78,	{ 0xE5, 0xAF, 0x88 },
	0x8C79,	{ 0xE5, 0xAF, 0x89 },
	0x8C7A,	{ 0xE5, 0xAF, 0x8A },
	0x8C7B,	{ 0xE5, 0xAF, 0x8B },
	0x8C7C,	{ 0xE5, 0xAF, 0x8D },
	0x8C7D,	{ 0xE5, 0xAF, 0x8E },
	0x8C7E,	{ 0xE5, 0xAF, 0x8F },
	0x8C80,	{ 0xE5, 0xAF, 0x91 },
	0x8C81,	{ 0xE5, 0xAF, 0x94 },
	0x8C82,	{ 0xE5, 0xAF, 0x95 },
	0x8C83,	{ 0xE5, 0xAF, 0x96 },
	0x8C84,	{ 0xE5, 0xAF, 0x97 },
	0x8C85,	{ 0xE5, 0xAF, 0x98 },
	0x8C86,	{ 0xE5, 0xAF, 0x99 },
	0x8C87,	{ 0xE5, 0xAF, 0x9A },
	0x8C88,	{ 0xE5, 0xAF, 0x9B },
	0x8C89,	{ 0xE5, 0xAF, 0x9C },
	0x8C8A,	{ 0xE5, 0xAF, 0xA0 },
	0x8C8B,	{ 0xE5, 0xAF, 0xA2 },
	0x8C8C,	{ 0xE5, 0xAF, 0xA3 },
	0x8C8D,	{ 0xE5, 0xAF, 0xA6 },
	0x8C8E,	{ 0xE5, 0xAF, 0xA7 },
	0x8C8F,	{ 0xE5, 0xAF, 0xA9 },
	0x8C90,	{ 0xE5, 0xAF, 0xAA },
	0x8C91,	{ 0xE5, 0xAF, 0xAB },
	0x8C92,	{ 0xE5, 0xAF, 0xAC },
	0x8C93,	{ 0xE5, 0xAF, 0xAD },
	0x8C94,	{ 0xE5, 0xAF, 0xAF },
	0x8C95,	{ 0xE5, 0xAF, 0xB1 },
	0x8C96,	{ 0xE5, 0xAF, 0xB2 },
	0x8C97,	{ 0xE5, 0xAF, 0xB3 },
	0x8C98,	{ 0xE5, 0xAF, 0xB4 },
	0x8C99,	{ 0xE5, 0xAF, 0xB5 },
	0x8C9A,	{ 0xE5, 0xAF, 0xB6 },
	0x8C9B,	{ 0xE5, 0xAF, 0xB7 },
	0x8C9C,	{ 0xE5, 0xAF, 0xBD },
	0x8C9D,	{ 0xE5, 0xAF, 0xBE },
	0x8C9E,	{ 0xE5, 0xB0, 0x80 },
	0x8C9F,	{ 0xE5, 0xB0, 0x82 },
	0x8CA0,	{ 0xE5, 0xB0, 0x83 },
	0x8CA1,	{ 0xE5, 0xB0, 0x85 },
	0x8CA2,	{ 0xE5, 0xB0, 0x87 },
	0x8CA3,	{ 0xE5, 0xB0, 0x88 },
	0x8CA4,	{ 0xE5, 0xB0, 0x8B },
	0x8CA5,	{ 0xE5, 0xB0, 0x8C },
	0x8CA6,	{ 0xE5, 0xB0, 0x8D },
	0x8CA7,	{ 0xE5, 0xB0, 0x8E },
	0x8CA8,	{ 0xE5, 0xB0, 0x90 },
	0x8CA9,	{ 0xE5, 0xB0, 0x92 },
	0x8CAA,	{ 0xE5, 0xB0, 0x93 },
	0x8CAB,	{ 0xE5, 0xB0, 0x97 },
	0x8CAC,	{ 0xE5, 0xB0, 0x99 },
	0x8CAD,	{ 0xE5, 0xB0, 0x9B },
	0x8CAE,	{ 0xE5, 0xB0, 0x9E },
	0x8CAF,	{ 0xE5, 0xB0, 0x9F },
	0x8CB0,	{ 0xE5, 0xB0, 0xA0 },
	0x8CB1,	{ 0xE5, 0xB0, 0xA1 },
	0x8CB2,	{ 0xE5, 0xB0, 0xA3 },
	0x8CB3,	{ 0xE5, 0xB0, 0xA6 },
	0x8CB4,	{ 0xE5, 0xB0, 0xA8 },
	0x8CB5,	{ 0xE5, 0xB0, 0xA9 },
	0x8CB6,	{ 0xE5, 0xB0, 0xAA },
	0x8CB7,	{ 0xE5, 0xB0, 0xAB },
	0x8CB8,	{ 0xE5, 0xB0, 0xAD },
	0x8CB9,	{ 0xE5, 0xB0, 0xAE },
	0x8CBA,	{ 0xE5, 0xB0, 0xAF },
	0x8CBB,	{ 0xE5, 0xB0, 0xB0 },
	0x8CBC,	{ 0xE5, 0xB0, 0xB2 },
	0x8CBD,	{ 0xE5, 0xB0, 0xB3 },
	0x8CBE,	{ 0xE5, 0xB0, 0xB5 },
	0x8CBF,	{ 0xE5, 0xB0, 0xB6 },
	0x8CC0,	{ 0xE5, 0xB0, 0xB7 },
	0x8CC1,	{ 0xE5, 0xB1, 0x83 },
	0x8CC2,	{ 0xE5, 0xB1, 0x84 },
	0x8CC3,	{ 0xE5, 0xB1, 0x86 },
	0x8CC4,	{ 0xE5, 0xB1, 0x87 },
	0x8CC5,	{ 0xE5, 0xB1, 0x8C },
	0x8CC6,	{ 0xE5, 0xB1, 0x8D },
	0x8CC7,	{ 0xE5, 0xB1, 0x92 },
	0x8CC8,	{ 0xE5, 0xB1, 0x93 },
	0x8CC9,	{ 0xE5, 0xB1, 0x94 },
	0x8CCA,	{ 0xE5, 0xB1, 0x96 },
	0x8CCB,	{ 0xE5, 0xB1, 0x97 },
	0x8CCC,	{ 0xE5, 0xB1, 0x98 },
	0x8CCD,	{ 0xE5, 0xB1, 0x9A },
	0x8CCE,	{ 0xE5, 0xB1, 0x9B },
	0x8CCF,	{ 0xE5, 0xB1, 0x9C },
	0x8CD0,	{ 0xE5, 0xB1, 0x9D },
	0x8CD1,	{ 0xE5, 0xB1, 0x9F },
	0x8CD2,	{ 0xE5, 0xB1, 0xA2 },
	0x8CD3,	{ 0xE5, 0xB1, 0xA4 },
	0x8CD4,	{ 0xE5, 0xB1, 0xA7 },
	0x8CD5,	{ 0xE5, 0xB1, 0xA8 },
	0x8CD6,	{ 0xE5, 0xB1, 0xA9 },
	0x8CD7,	{ 0xE5, 0xB1, 0xAA },
	0x8CD8,	{ 0xE5, 0xB1, 0xAB },
	0x8CD9,	{ 0xE5, 0xB1, 0xAC },
	0x8CDA,	{ 0xE5, 0xB1, 0xAD },
	0x8CDB,	{ 0xE5, 0xB1, 0xB0 },
	0x8CDC,	{ 0xE5, 0xB1, 0xB2 },
	0x8CDD,	{ 0xE5, 0xB1, 0xB3 },
	0x8CDE,	{ 0xE5, 0xB1, 0xB4 },
	0x8CDF,	{ 0xE5, 0xB1, 0xB5 },
	0x8CE0,	{ 0xE5, 0xB1, 0xB6 },
	0x8CE1,	{ 0xE5, 0xB1, 0xB7 },
	0x8CE2,	{ 0xE5, 0xB1, 0xB8 },
	0x8CE3,	{ 0xE5, 0xB1, 0xBB },
	0x8CE4,	{ 0xE5, 0xB1, 0xBC },
	0x8CE5,	{ 0xE5, 0xB1, 0xBD },
	0x8CE6,	{ 0xE5, 0xB1, 0xBE },
	0x8CE7,	{ 0xE5, 0xB2, 0x80 },
	0x8CE8,	{ 0xE5, 0xB2, 0x83 },
	0x8CE9,	{ 0xE5, 0xB2, 0x84 },
	0x8CEA,	{ 0xE5, 0xB2, 0x85 },
	0x8CEB,	{ 0xE5, 0xB2, 0x86 },
	0x8CEC,	{ 0xE5, 0xB2, 0x87 },
	0x8CED,	{ 0xE5, 0xB2, 0x89 },
	0x8CEE,	{ 0xE5, 0xB2, 0x8A },
	0x8CEF,	{ 0xE5, 0xB2, 0x8B },
	0x8CF0,	{ 0xE5, 0xB2, 0x8E },
	0x8CF1,	{ 0xE5, 0xB2, 0x8F },
	0x8CF2,	{ 0xE5, 0xB2, 0x92 },
	0x8CF3,	{ 0xE5, 0xB2, 0x93 },
	0x8CF4,	{ 0xE5, 0xB2, 0x95 },
	0x8CF5,	{ 0xE5, 0xB2, 0x9D },
	0x8CF6,	{ 0xE5, 0xB2, 0x9E },
	0x8CF7,	{ 0xE5, 0xB2, 0x9F },
	0x8CF8,	{ 0xE5, 0xB2, 0xA0 },
	0x8CF9,	{ 0xE5, 0xB2, 0xA1 },
	0x8CFA,	{ 0xE5, 0xB2, 0xA4 },
	0x8CFB,	{ 0xE5, 0xB2, 0xA5 },
	0x8CFC,	{ 0xE5, 0xB2, 0xA6 },
	0x8CFD,	{ 0xE5, 0xB2, 0xA7 },
	0x8CFE,	{ 0xE5, 0xB2, 0xA8 },
	0x8D40,	{ 0xE5, 0xB2, 0xAA },
	0x8D41,	{ 0xE5, 0xB2, 0xAE },
	0x8D42,	{ 0xE5, 0xB2, 0xAF },
	0x8D43,	{ 0xE5, 0xB2, 0xB0 },
	0x8D44,	{ 0xE5, 0xB2, 0xB2 },
	0x8D45,	{ 0xE5, 0xB2, 0xB4 },
	0x8D46,	{ 0xE5, 0xB2, 0xB6 },
	0x8D47,	{ 0xE5, 0xB2, 0xB9 },
	0x8D48,	{ 0xE5, 0xB2, 0xBA },
	0x8D49,	{ 0xE5, 0xB2, 0xBB },
	0x8D4A,	{ 0xE5, 0xB2, 0xBC },
	0x8D4B,	{ 0xE5, 0xB2, 0xBE },
	0x8D4C,	{ 0xE5, 0xB3, 0x80 },
	0x8D4D,	{ 0xE5, 0xB3, 0x82 },
	0x8D4E,	{ 0xE5, 0xB3, 0x83 },
	0x8D4F,	{ 0xE5, 0xB3, 0x85 },
	0x8D50,	{ 0xE5, 0xB3, 0x86 },
	0x8D51,	{ 0xE5, 0xB3, 0x87 },
	0x8D52,	{ 0xE5, 0xB3, 0x88 },
	0x8D53,	{ 0xE5, 0xB3, 0x89 },
	0x8D54,	{ 0xE5, 0xB3, 0x8A },
	0x8D55,	{ 0xE5, 0xB3, 0x8C },
	0x8D56,	{ 0xE5, 0xB3, 0x8D },
	0x8D57,	{ 0xE5, 0xB3, 0x8E },
	0x8D58,	{ 0xE5, 0xB3, 0x8F },
	0x8D59,	{ 0xE5, 0xB3, 0x90 },
	0x8D5A,	{ 0xE5, 0xB3, 0x91 },
	0x8D5B,	{ 0xE5, 0xB3, 0x93 },
	0x8D5C,	{ 0xE5, 0xB3, 0x94 },
	0x8D5D,	{ 0xE5, 0xB3, 0x95 },
	0x8D5E,	{ 0xE5, 0xB3, 0x96 },
	0x8D5F,	{ 0xE5, 0xB3, 0x97 },
	0x8D60,	{ 0xE5, 0xB3, 0x98 },
	0x8D61,	{ 0xE5, 0xB3, 0x9A },
	0x8D62,	{ 0xE5, 0xB3, 0x9B },
	0x8D63,	{ 0xE5, 0xB3, 0x9C },
	0x8D64,	{ 0xE5, 0xB3, 0x9D },
	0x8D65,	{ 0xE5, 0xB3, 0x9E },
	0x8D66,	{ 0xE5, 0xB3, 0x9F },
	0x8D67,	{ 0xE5, 0xB3, 0xA0 },
	0x8D68,	{ 0xE5, 0xB3, 0xA2 },
	0x8D69,	{ 0xE5, 0xB3, 0xA3 },
	0x8D6A,	{ 0xE5, 0xB3, 0xA7 },
	0x8D6B,	{ 0xE5, 0xB3, 0xA9 },
	0x8D6C,	{ 0xE5, 0xB3, 0xAB },
	0x8D6D,	{ 0xE5, 0xB3, 0xAC },
	0x8D6E,	{ 0xE5, 0xB3, 0xAE },
	0x8D6F,	{ 0xE5, 0xB3, 0xAF },
	0x8D70,	{ 0xE5, 0xB3, 0xB1 },
	0x8D71,	{ 0xE5, 0xB3, 0xB2 },
	0x8D72,	{ 0xE5, 0xB3, 0xB3 },
	0x8D73,	{ 0xE5, 0xB3, 0xB4 },
	0x8D74,	{ 0xE5, 0xB3, 0xB5 },
	0x8D75,	{ 0xE5, 0xB3, 0xB6 },
	0x8D76,	{ 0xE5, 0xB3, 0xB7 },
	0x8D77,	{ 0xE5, 0xB3, 0xB8 },
	0x8D78,	{ 0xE5, 0xB3, 0xB9 },
	0x8D79,	{ 0xE5, 0xB3, 0xBA },
	0x8D7A,	{ 0xE5, 0xB3, 0xBC },
	0x8D7B,	{ 0xE5, 0xB3, 0xBD },
	0x8D7C,	{ 0xE5, 0xB3, 0xBE },
	0x8D7D,	{ 0xE5, 0xB3, 0xBF },
	0x8D7E,	{ 0xE5, 0xB4, 0x80 },
	0x8D80,	{ 0xE5, 0xB4, 0x81 },
	0x8D81,	{ 0xE5, 0xB4, 0x84 },
	0x8D82,	{ 0xE5, 0xB4, 0x85 },
	0x8D83,	{ 0xE5, 0xB4, 0x88 },
	0x8D84,	{ 0xE5, 0xB4, 0x89 },
	0x8D85,	{ 0xE5, 0xB4, 0x8A },
	0x8D86,	{ 0xE5, 0xB4, 0x8B },
	0x8D87,	{ 0xE5, 0xB4, 0x8C },
	0x8D88,	{ 0xE5, 0xB4, 0x8D },
	0x8D89,	{ 0xE5, 0xB4, 0x8F },
	0x8D8A,	{ 0xE5, 0xB4, 0x90 },
	0x8D8B,	{ 0xE5, 0xB4, 0x91 },
	0x8D8C,	{ 0xE5, 0xB4, 0x92 },
	0x8D8D,	{ 0xE5, 0xB4, 0x93 },
	0x8D8E,	{ 0xE5, 0xB4, 0x95 },
	0x8D8F,	{ 0xE5, 0xB4, 0x97 },
	0x8D90,	{ 0xE5, 0xB4, 0x98 },
	0x8D91,	{ 0xE5, 0xB4, 0x99 },
	0x8D92,	{ 0xE5, 0xB4, 0x9A },
	0x8D93,	{ 0xE5, 0xB4, 0x9C },
	0x8D94,	{ 0xE5, 0xB4, 0x9D },
	0x8D95,	{ 0xE5, 0xB4, 0x9F },
	0x8D96,	{ 0xE5, 0xB4, 0xA0 },
	0x8D97,	{ 0xE5, 0xB4, 0xA1 },
	0x8D98,	{ 0xE5, 0xB4, 0xA2 },
	0x8D99,	{ 0xE5, 0xB4, 0xA3 },
	0x8D9A,	{ 0xE5, 0xB4, 0xA5 },
	0x8D9B,	{ 0xE5, 0xB4, 0xA8 },
	0x8D9C,	{ 0xE5, 0xB4, 0xAA },
	0x8D9D,	{ 0xE5, 0xB4, 0xAB },
	0x8D9E,	{ 0xE5, 0xB4, 0xAC },
	0x8D9F,	{ 0xE5, 0xB4, 0xAF },
	0x8DA0,	{ 0xE5, 0xB4, 0xB0 },
	0x8DA1,	{ 0xE5, 0xB4, 0xB1 },
	0x8DA2,	{ 0xE5, 0xB4, 0xB2 },
	0x8DA3,	{ 0xE5, 0xB4, 0xB3 },
	0x8DA4,	{ 0xE5, 0xB4, 0xB5 },
	0x8DA5,	{ 0xE5, 0xB4, 0xB6 },
	0x8DA6,	{ 0xE5, 0xB4, 0xB7 },
	0x8DA7,	{ 0xE5, 0xB4, 0xB8 },
	0x8DA8,	{ 0xE5, 0xB4, 0xB9 },
	0x8DA9,	{ 0xE5, 0xB4, 0xBA },
	0x8DAA,	{ 0xE5, 0xB4, 0xBB },
	0x8DAB,	{ 0xE5, 0xB4, 0xBC },
	0x8DAC,	{ 0xE5, 0xB4, 0xBF },
	0x8DAD,	{ 0xE5, 0xB5, 0x80 },
	0x8DAE,	{ 0xE5, 0xB5, 0x81 },
	0x8DAF,	{ 0xE5, 0xB5, 0x82 },
	0x8DB0,	{ 0xE5, 0xB5, 0x83 },
	0x8DB1,	{ 0xE5, 0xB5, 0x84 },
	0x8DB2,	{ 0xE5, 0xB5, 0x85 },
	0x8DB3,	{ 0xE5, 0xB5, 0x86 },
	0x8DB4,	{ 0xE5, 0xB5, 0x88 },
	0x8DB5,	{ 0xE5, 0xB5, 0x89 },
	0x8DB6,	{ 0xE5, 0xB5, 0x8D },
	0x8DB7,	{ 0xE5, 0xB5, 0x8E },
	0x8DB8,	{ 0xE5, 0xB5, 0x8F },
	0x8DB9,	{ 0xE5, 0xB5, 0x90 },
	0x8DBA,	{ 0xE5, 0xB5, 0x91 },
	0x8DBB,	{ 0xE5, 0xB5, 0x92 },
	0x8DBC,	{ 0xE5, 0xB5, 0x93 },
	0x8DBD,	{ 0xE5, 0xB5, 0x94 },
	0x8DBE,	{ 0xE5, 0xB5, 0x95 },
	0x8DBF,	{ 0xE5, 0xB5, 0x96 },
	0x8DC0,	{ 0xE5, 0xB5, 0x97 },
	0x8DC1,	{ 0xE5, 0xB5, 0x99 },
	0x8DC2,	{ 0xE5, 0xB5, 0x9A },
	0x8DC3,	{ 0xE5, 0xB5, 0x9C },
	0x8DC4,	{ 0xE5, 0xB5, 0x9E },
	0x8DC5,	{ 0xE5, 0xB5, 0x9F },
	0x8DC6,	{ 0xE5, 0xB5, 0xA0 },
	0x8DC7,	{ 0xE5, 0xB5, 0xA1 },
	0x8DC8,	{ 0xE5, 0xB5, 0xA2 },
	0x8DC9,	{ 0xE5, 0xB5, 0xA3 },
	0x8DCA,	{ 0xE5, 0xB5, 0xA4 },
	0x8DCB,	{ 0xE5, 0xB5, 0xA5 },
	0x8DCC,	{ 0xE5, 0xB5, 0xA6 },
	0x8DCD,	{ 0xE5, 0xB5, 0xA7 },
	0x8DCE,	{ 0xE5, 0xB5, 0xA8 },
	0x8DCF,	{ 0xE5, 0xB5, 0xAA },
	0x8DD0,	{ 0xE5, 0xB5, 0xAD },
	0x8DD1,	{ 0xE5, 0xB5, 0xAE },
	0x8DD2,	{ 0xE5, 0xB5, 0xB0 },
	0x8DD3,	{ 0xE5, 0xB5, 0xB1 },
	0x8DD4,	{ 0xE5, 0xB5, 0xB2 },
	0x8DD5,	{ 0xE5, 0xB5, 0xB3 },
	0x8DD6,	{ 0xE5, 0xB5, 0xB5 },
	0x8DD7,	{ 0xE5, 0xB5, 0xB6 },
	0x8DD8,	{ 0xE5, 0xB5, 0xB7 },
	0x8DD9,	{ 0xE5, 0xB5, 0xB8 },
	0x8DDA,	{ 0xE5, 0xB5, 0xB9 },
	0x8DDB,	{ 0xE5, 0xB5, 0xBA },
	0x8DDC,	{ 0xE5, 0xB5, 0xBB },
	0x8DDD,	{ 0xE5, 0xB5, 0xBC },
	0x8DDE,	{ 0xE5, 0xB5, 0xBD },
	0x8DDF,	{ 0xE5, 0xB5, 0xBE },
	0x8DE0,	{ 0xE5, 0xB5, 0xBF },
	0x8DE1,	{ 0xE5, 0xB6, 0x80 },
	0x8DE2,	{ 0xE5, 0xB6, 0x81 },
	0x8DE3,	{ 0xE5, 0xB6, 0x83 },
	0x8DE4,	{ 0xE5, 0xB6, 0x84 },
	0x8DE5,	{ 0xE5, 0xB6, 0x85 },
	0x8DE6,	{ 0xE5, 0xB6, 0x86 },
	0x8DE7,	{ 0xE5, 0xB6, 0x87 },
	0x8DE8,	{ 0xE5, 0xB6, 0x88 },
	0x8DE9,	{ 0xE5, 0xB6, 0x89 },
	0x8DEA,	{ 0xE5, 0xB6, 0x8A },
	0x8DEB,	{ 0xE5, 0xB6, 0x8B },
	0x8DEC,	{ 0xE5, 0xB6, 0x8C },
	0x8DED,	{ 0xE5, 0xB6, 0x8D },
	0x8DEE,	{ 0xE5, 0xB6, 0x8E },
	0x8DEF,	{ 0xE5, 0xB6, 0x8F },
	0x8DF0,	{ 0xE5, 0xB6, 0x90 },
	0x8DF1,	{ 0xE5, 0xB6, 0x91 },
	0x8DF2,	{ 0xE5, 0xB6, 0x92 },
	0x8DF3,	{ 0xE5, 0xB6, 0x93 },
	0x8DF4,	{ 0xE5, 0xB6, 0x94 },
	0x8DF5,	{ 0xE5, 0xB6, 0x95 },
	0x8DF6,	{ 0xE5, 0xB6, 0x96 },
	0x8DF7,	{ 0xE5, 0xB6, 0x97 },
	0x8DF8,	{ 0xE5, 0xB6, 0x98 },
	0x8DF9,	{ 0xE5, 0xB6, 0x9A },
	0x8DFA,	{ 0xE5, 0xB6, 0x9B },
	0x8DFB,	{ 0xE5, 0xB6, 0x9C },
	0x8DFC,	{ 0xE5, 0xB6, 0x9E },
	0x8DFD,	{ 0xE5, 0xB6, 0x9F },
	0x8DFE,	{ 0xE5, 0xB6, 0xA0 },
	0x8E40,	{ 0xE5, 0xB6, 0xA1 },
	0x8E41,	{ 0xE5, 0xB6, 0xA2 },
	0x8E42,	{ 0xE5, 0xB6, 0xA3 },
	0x8E43,	{ 0xE5, 0xB6, 0xA4 },
	0x8E44,	{ 0xE5, 0xB6, 0xA5 },
	0x8E45,	{ 0xE5, 0xB6, 0xA6 },
	0x8E46,	{ 0xE5, 0xB6, 0xA7 },
	0x8E47,	{ 0xE5, 0xB6, 0xA8 },
	0x8E48,	{ 0xE5, 0xB6, 0xA9 },
	0x8E49,	{ 0xE5, 0xB6, 0xAA },
	0x8E4A,	{ 0xE5, 0xB6, 0xAB },
	0x8E4B,	{ 0xE5, 0xB6, 0xAC },
	0x8E4C,	{ 0xE5, 0xB6, 0xAD },
	0x8E4D,	{ 0xE5, 0xB6, 0xAE },
	0x8E4E,	{ 0xE5, 0xB6, 0xAF },
	0x8E4F,	{ 0xE5, 0xB6, 0xB0 },
	0x8E50,	{ 0xE5, 0xB6, 0xB1 },
	0x8E51,	{ 0xE5, 0xB6, 0xB2 },
	0x8E52,	{ 0xE5, 0xB6, 0xB3 },
	0x8E53,	{ 0xE5, 0xB6, 0xB4 },
	0x8E54,	{ 0xE5, 0xB6, 0xB5 },
	0x8E55,	{ 0xE5, 0xB6, 0xB6 },
	0x8E56,	{ 0xE5, 0xB6, 0xB8 },
	0x8E57,	{ 0xE5, 0xB6, 0xB9 },
	0x8E58,	{ 0xE5, 0xB6, 0xBA },
	0x8E59,	{ 0xE5, 0xB6, 0xBB },
	0x8E5A,	{ 0xE5, 0xB6, 0xBC },
	0x8E5B,	{ 0xE5, 0xB6, 0xBD },
	0x8E5C,	{ 0xE5, 0xB6, 0xBE },
	0x8E5D,	{ 0xE5, 0xB6, 0xBF },
	0x8E5E,	{ 0xE5, 0xB7, 0x80 },
	0x8E5F,	{ 0xE5, 0xB7, 0x81 },
	0x8E60,	{ 0xE5, 0xB7, 0x82 },
	0x8E61,	{ 0xE5, 0xB7, 0x83 },
	0x8E62,	{ 0xE5, 0xB7, 0x84 },
	0x8E63,	{ 0xE5, 0xB7, 0x86 },
	0x8E64,	{ 0xE5, 0xB7, 0x87 },
	0x8E65,	{ 0xE5, 0xB7, 0x88 },
	0x8E66,	{ 0xE5, 0xB7, 0x89 },
	0x8E67,	{ 0xE5, 0xB7, 0x8A },
	0x8E68,	{ 0xE5, 0xB7, 0x8B },
	0x8E69,	{ 0xE5, 0xB7, 0x8C },
	0x8E6A,	{ 0xE5, 0xB7, 0x8E },
	0x8E6B,	{ 0xE5, 0xB7, 0x8F },
	0x8E6C,	{ 0xE5, 0xB7, 0x90 },
	0x8E6D,	{ 0xE5, 0xB7, 0x91 },
	0x8E6E,	{ 0xE5, 0xB7, 0x92 },
	0x8E6F,	{ 0xE5, 0xB7, 0x93 },
	0x8E70,	{ 0xE5, 0xB7, 0x94 },
	0x8E71,	{ 0xE5, 0xB7, 0x95 },
	0x8E72,	{ 0xE5, 0xB7, 0x96 },
	0x8E73,	{ 0xE5, 0xB7, 0x97 },
	0x8E74,	{ 0xE5, 0xB7, 0x98 },
	0x8E75,	{ 0xE5, 0xB7, 0x99 },
	0x8E76,	{ 0xE5, 0xB7, 0x9A },
	0x8E77,	{ 0xE5, 0xB7, 0x9C },
	0x8E78,	{ 0xE5, 0xB7, 0x9F },
	0x8E79,	{ 0xE5, 0xB7, 0xA0 },
	0x8E7A,	{ 0xE5, 0xB7, 0xA3 },
	0x8E7B,	{ 0xE5, 0xB7, 0xA4 },
	0x8E7C,	{ 0xE5, 0xB7, 0xAA },
	0x8E7D,	{ 0xE5, 0xB7, 0xAC },
	0x8E7E,	{ 0xE5, 0xB7, 0xAD },
	0x8E80,	{ 0xE5, 0xB7, 0xB0 },
	0x8E81,	{ 0xE5, 0xB7, 0xB5 },
	0x8E82,	{ 0xE5, 0xB7, 0xB6 },
	0x8E83,	{ 0xE5, 0xB7, 0xB8 },
	0x8E84,	{ 0xE5, 0xB7, 0xB9 },
	0x8E85,	{ 0xE5, 0xB7, 0xBA },
	0x8E86,	{ 0xE5, 0xB7, 0xBB },
	0x8E87,	{ 0xE5, 0xB7, 0xBC },
	0x8E88,	{ 0xE5, 0xB7, 0xBF },
	0x8E89,	{ 0xE5, 0xB8, 0x80 },
	0x8E8A,	{ 0xE5, 0xB8, 0x84 },
	0x8E8B,	{ 0xE5, 0xB8, 0x87 },
	0x8E8C,	{ 0xE5, 0xB8, 0x89 },
	0x8E8D,	{ 0xE5, 0xB8, 0x8A },
	0x8E8E,	{ 0xE5, 0xB8, 0x8B },
	0x8E8F,	{ 0xE5, 0xB8, 0x8D },
	0x8E90,	{ 0xE5, 0xB8, 0x8E },
	0x8E91,	{ 0xE5, 0xB8, 0x92 },
	0x8E92,	{ 0xE5, 0xB8, 0x93 },
	0x8E93,	{ 0xE5, 0xB8, 0x97 },
	0x8E94,	{ 0xE5, 0xB8, 0x9E },
	0x8E95,	{ 0xE5, 0xB8, 0x9F },
	0x8E96,	{ 0xE5, 0xB8, 0xA0 },
	0x8E97,	{ 0xE5, 0xB8, 0xA1 },
	0x8E98,	{ 0xE5, 0xB8, 0xA2 },
	0x8E99,	{ 0xE5, 0xB8, 0xA3 },
	0x8E9A,	{ 0xE5, 0xB8, 0xA4 },
	0x8E9B,	{ 0xE5, 0xB8, 0xA5 },
	0x8E9C,	{ 0xE5, 0xB8, 0xA8 },
	0x8E9D,	{ 0xE5, 0xB8, 0xA9 },
	0x8E9E,	{ 0xE5, 0xB8, 0xAA },
	0x8E9F,	{ 0xE5, 0xB8, 0xAB },
	0x8EA0,	{ 0xE5, 0xB8, 0xAC },
	0x8EA1,	{ 0xE5, 0xB8, 0xAF },
	0x8EA2,	{ 0xE5, 0xB8, 0xB0 },
	0x8EA3,	{ 0xE5, 0xB8, 0xB2 },
	0x8EA4,	{ 0xE5, 0xB8, 0xB3 },
	0x8EA5,	{ 0xE5, 0xB8, 0xB4 },
	0x8EA6,	{ 0xE5, 0xB8, 0xB5 },
	0x8EA7,	{ 0xE5, 0xB8, 0xB6 },
	0x8EA8,	{ 0xE5, 0xB8, 0xB9 },
	0x8EA9,	{ 0xE5, 0xB8, 0xBA },
	0x8EAA,	{ 0xE5, 0xB8, 0xBE },
	0x8EAB,	{ 0xE5, 0xB8, 0xBF },
	0x8EAC,	{ 0xE5, 0xB9, 0x80 },
	0x8EAD,	{ 0xE5, 0xB9, 0x81 },
	0x8EAE,	{ 0xE5, 0xB9, 0x83 },
	0x8EAF,	{ 0xE5, 0xB9, 0x86 },
	0x8EB0,	{ 0xE5, 0xB9, 0x87 },
	0x8EB1,	{ 0xE5, 0xB9, 0x88 },
	0x8EB2,	{ 0xE5, 0xB9, 0x89 },
	0x8EB3,	{ 0xE5, 0xB9, 0x8A },
	0x8EB4,	{ 0xE5, 0xB9, 0x8B },
	0x8EB5,	{ 0xE5, 0xB9, 0x8D },
	0x8EB6,	{ 0xE5, 0xB9, 0x8E },
	0x8EB7,	{ 0xE5, 0xB9, 0x8F },
	0x8EB8,	{ 0xE5, 0xB9, 0x90 },
	0x8EB9,	{ 0xE5, 0xB9, 0x91 },
	0x8EBA,	{ 0xE5, 0xB9, 0x92 },
	0x8EBB,	{ 0xE5, 0xB9, 0x93 },
	0x8EBC,	{ 0xE5, 0xB9, 0x96 },
	0x8EBD,	{ 0xE5, 0xB9, 0x97 },
	0x8EBE,	{ 0xE5, 0xB9, 0x98 },
	0x8EBF,	{ 0xE5, 0xB9, 0x99 },
	0x8EC0,	{ 0xE5, 0xB9, 0x9A },
	0x8EC1,	{ 0xE5, 0xB9, 0x9C },
	0x8EC2,	{ 0xE5, 0xB9, 0x9D },
	0x8EC3,	{ 0xE5, 0xB9, 0x9F },
	0x8EC4,	{ 0xE5, 0xB9, 0xA0 },
	0x8EC5,	{ 0xE5, 0xB9, 0xA3 },
	0x8EC6,	{ 0xE5, 0xB9, 0xA4 },
	0x8EC7,	{ 0xE5, 0xB9, 0xA5 },
	0x8EC8,	{ 0xE5, 0xB9, 0xA6 },
	0x8EC9,	{ 0xE5, 0xB9, 0xA7 },
	0x8ECA,	{ 0xE5, 0xB9, 0xA8 },
	0x8ECB,	{ 0xE5, 0xB9, 0xA9 },
	0x8ECC,	{ 0xE5, 0xB9, 0xAA },
	0x8ECD,	{ 0xE5, 0xB9, 0xAB },
	0x8ECE,	{ 0xE5, 0xB9, 0xAC },
	0x8ECF,	{ 0xE5, 0xB9, 0xAD },
	0x8ED0,	{ 0xE5, 0xB9, 0xAE },
	0x8ED1,	{ 0xE5, 0xB9, 0xAF },
	0x8ED2,	{ 0xE5, 0xB9, 0xB0 },
	0x8ED3,	{ 0xE5, 0xB9, 0xB1 },
	0x8ED4,	{ 0xE5, 0xB9, 0xB5 },
	0x8ED5,	{ 0xE5, 0xB9, 0xB7 },
	0x8ED6,	{ 0xE5, 0xB9, 0xB9 },
	0x8ED7,	{ 0xE5, 0xB9, 0xBE },
	0x8ED8,	{ 0xE5, 0xBA, 0x81 },
	0x8ED9,	{ 0xE5, 0xBA, 0x82 },
	0x8EDA,	{ 0xE5, 0xBA, 0x83 },
	0x8EDB,	{ 0xE5, 0xBA, 0x85 },
	0x8EDC,	{ 0xE5, 0xBA, 0x88 },
	0x8EDD,	{ 0xE5, 0xBA, 0x89 },
	0x8EDE,	{ 0xE5, 0xBA, 0x8C },
	0x8EDF,	{ 0xE5, 0xBA, 0x8D },
	0x8EE0,	{ 0xE5, 0xBA, 0x8E },
	0x8EE1,	{ 0xE5, 0xBA, 0x92 },
	0x8EE2,	{ 0xE5, 0xBA, 0x98 },
	0x8EE3,	{ 0xE5, 0xBA, 0x9B },
	0x8EE4,	{ 0xE5, 0xBA, 0x9D },
	0x8EE5,	{ 0xE5, 0xBA, 0xA1 },
	0x8EE6,	{ 0xE5, 0xBA, 0xA2 },
	0x8EE7,	{ 0xE5, 0xBA, 0xA3 },
	0x8EE8,	{ 0xE5, 0xBA, 0xA4 },
	0x8EE9,	{ 0xE5, 0xBA, 0xA8 },
	0x8EEA,	{ 0xE5, 0xBA, 0xA9 },
	0x8EEB,	{ 0xE5, 0xBA, 0xAA },
	0x8EEC,	{ 0xE5, 0xBA, 0xAB },
	0x8EED,	{ 0xE5, 0xBA, 0xAC },
	0x8EEE,	{ 0xE5, 0xBA, 0xAE },
	0x8EEF,	{ 0xE5, 0xBA, 0xAF },
	0x8EF0,	{ 0xE5, 0xBA, 0xB0 },
	0x8EF1,	{ 0xE5, 0xBA, 0xB1 },
	0x8EF2,	{ 0xE5, 0xBA, 0xB2 },
	0x8EF3,	{ 0xE5, 0xBA, 0xB4 },
	0x8EF4,	{ 0xE5, 0xBA, 0xBA },
	0x8EF5,	{ 0xE5, 0xBA, 0xBB },
	0x8EF6,	{ 0xE5, 0xBA, 0xBC },
	0x8EF7,	{ 0xE5, 0xBA, 0xBD },
	0x8EF8,	{ 0xE5, 0xBA, 0xBF },
	0x8EF9,	{ 0xE5, 0xBB, 0x80 },
	0x8EFA,	{ 0xE5, 0xBB, 0x81 },
	0x8EFB,	{ 0xE5, 0xBB, 0x82 },
	0x8EFC,	{ 0xE5, 0xBB, 0x83 },
	0x8EFD,	{ 0xE5, 0xBB, 0x84 },
	0x8EFE,	{ 0xE5, 0xBB, 0x85 },
	0x8F40,	{ 0xE5, 0xBB, 0x86 },
	0x8F41,	{ 0xE5, 0xBB, 0x87 },
	0x8F42,	{ 0xE5, 0xBB, 0x88 },
	0x8F43,	{ 0xE5, 0xBB, 0x8B },
	0x8F44,	{ 0xE5, 0xBB, 0x8C },
	0x8F45,	{ 0xE5, 0xBB, 0x8D },
	0x8F46,	{ 0xE5, 0xBB, 0x8E },
	0x8F47,	{ 0xE5, 0xBB, 0x8F },
	0x8F48,	{ 0xE5, 0xBB, 0x90 },
	0x8F49,	{ 0xE5, 0xBB, 0x94 },
	0x8F4A,	{ 0xE5, 0xBB, 0x95 },
	0x8F4B,	{ 0xE5, 0xBB, 0x97 },
	0x8F4C,	{ 0xE5, 0xBB, 0x98 },
	0x8F4D,	{ 0xE5, 0xBB, 0x99 },
	0x8F4E,	{ 0xE5, 0xBB, 0x9A },
	0x8F4F,	{ 0xE5, 0xBB, 0x9C },
	0x8F50,	{ 0xE5, 0xBB, 0x9D },
	0x8F51,	{ 0xE5, 0xBB, 0x9E },
	0x8F52,	{ 0xE5, 0xBB, 0x9F },
	0x8F53,	{ 0xE5, 0xBB, 0xA0 },
	0x8F54,	{ 0xE5, 0xBB, 0xA1 },
	0x8F55,	{ 0xE5, 0xBB, 0xA2 },
	0x8F56,	{ 0xE5, 0xBB, 0xA3 },
	0x8F57,	{ 0xE5, 0xBB, 0xA4 },
	0x8F58,	{ 0xE5, 0xBB, 0xA5 },
	0x8F59,	{ 0xE5, 0xBB, 0xA6 },
	0x8F5A,	{ 0xE5, 0xBB, 0xA7 },
	0x8F5B,	{ 0xE5, 0xBB, 0xA9 },
	0x8F5C,	{ 0xE5, 0xBB, 0xAB },
	0x8F5D,	{ 0xE5, 0xBB, 0xAC },
	0x8F5E,	{ 0xE5, 0xBB, 0xAD },
	0x8F5F,	{ 0xE5, 0xBB, 0xAE },
	0x8F60,	{ 0xE5, 0xBB, 0xAF },
	0x8F61,	{ 0xE5, 0xBB, 0xB0 },
	0x8F62,	{ 0xE5, 0xBB, 0xB1 },
	0x8F63,	{ 0xE5, 0xBB, 0xB2 },
	0x8F64,	{ 0xE5, 0xBB, 0xB3 },
	0x8F65,	{ 0xE5, 0xBB, 0xB5 },
	0x8F66,	{ 0xE5, 0xBB, 0xB8 },
	0x8F67,	{ 0xE5, 0xBB, 0xB9 },
	0x8F68,	{ 0xE5, 0xBB, 0xBB },
	0x8F69,	{ 0xE5, 0xBB, 0xBC },
	0x8F6A,	{ 0xE5, 0xBB, 0xBD },
	0x8F6B,	{ 0xE5, 0xBC, 0x85 },
	0x8F6C,	{ 0xE5, 0xBC, 0x86 },
	0x8F6D,	{ 0xE5, 0xBC, 0x87 },
	0x8F6E,	{ 0xE5, 0xBC, 0x89 },
	0x8F6F,	{ 0xE5, 0xBC, 0x8C },
	0x8F70,	{ 0xE5, 0xBC, 0x8D },
	0x8F71,	{ 0xE5, 0xBC, 0x8E },
	0x8F72,	{ 0xE5, 0xBC, 0x90 },
	0x8F73,	{ 0xE5, 0xBC, 0x92 },
	0x8F74,	{ 0xE5, 0xBC, 0x94 },
	0x8F75,	{ 0xE5, 0xBC, 0x96 },
	0x8F76,	{ 0xE5, 0xBC, 0x99 },
	0x8F77,	{ 0xE5, 0xBC, 0x9A },
	0x8F78,	{ 0xE5, 0xBC, 0x9C },
	0x8F79,	{ 0xE5, 0xBC, 0x9D },
	0x8F7A,	{ 0xE5, 0xBC, 0x9E },
	0x8F7B,	{ 0xE5, 0xBC, 0xA1 },
	0x8F7C,	{ 0xE5, 0xBC, 0xA2 },
	0x8F7D,	{ 0xE5, 0xBC, 0xA3 },
	0x8F7E,	{ 0xE5, 0xBC, 0xA4 },
	0x8F80,	{ 0xE5, 0xBC, 0xA8 },
	0x8F81,	{ 0xE5, 0xBC, 0xAB },
	0x8F82,	{ 0xE5, 0xBC, 0xAC },
	0x8F83,	{ 0xE5, 0xBC, 0xAE },
	0x8F84,	{ 0xE5, 0xBC, 0xB0 },
	0x8F85,	{ 0xE5, 0xBC, 0xB2 },
	0x8F86,	{ 0xE5, 0xBC, 0xB3 },
	0x8F87,	{ 0xE5, 0xBC, 0xB4 },
	0x8F88,	{ 0xE5, 0xBC, 0xB5 },
	0x8F89,	{ 0xE5, 0xBC, 0xB6 },
	0x8F8A,	{ 0xE5, 0xBC, 0xB7 },
	0x8F8B,	{ 0xE5, 0xBC, 0xB8 },
	0x8F8C,	{ 0xE5, 0xBC, 0xBB },
	0x8F8D,	{ 0xE5, 0xBC, 0xBD },
	0x8F8E,	{ 0xE5, 0xBC, 0xBE },
	0x8F8F,	{ 0xE5, 0xBC, 0xBF },
	0x8F90,	{ 0xE5, 0xBD, 0x81 },
	0x8F91,	{ 0xE5, 0xBD, 0x82 },
	0x8F92,	{ 0xE5, 0xBD, 0x83 },
	0x8F93,	{ 0xE5, 0xBD, 0x84 },
	0x8F94,	{ 0xE5, 0xBD, 0x85 },
	0x8F95,	{ 0xE5, 0xBD, 0x86 },
	0x8F96,	{ 0xE5, 0xBD, 0x87 },
	0x8F97,	{ 0xE5, 0xBD, 0x88 },
	0x8F98,	{ 0xE5, 0xBD, 0x89 },
	0x8F99,	{ 0xE5, 0xBD, 0x8A },
	0x8F9A,	{ 0xE5, 0xBD, 0x8B },
	0x8F9B,	{ 0xE5, 0xBD, 0x8C },
	0x8F9C,	{ 0xE5, 0xBD, 0x8D },
	0x8F9D,	{ 0xE5, 0xBD, 0x8E },
	0x8F9E,	{ 0xE5, 0xBD, 0x8F },
	0x8F9F,	{ 0xE5, 0xBD, 0x91 },
	0x8FA0,	{ 0xE5, 0xBD, 0x94 },
	0x8FA1,	{ 0xE5, 0xBD, 0x99 },
	0x8FA2,	{ 0xE5, 0xBD, 0x9A },
	0x8FA3,	{ 0xE5, 0xBD, 0x9B },
	0x8FA4,	{ 0xE5, 0xBD, 0x9C },
	0x8FA5,	{ 0xE5, 0xBD, 0x9E },
	0x8FA6,	{ 0xE5, 0xBD, 0x9F },
	0x8FA7,	{ 0xE5, 0xBD, 0xA0 },
	0x8FA8,	{ 0xE5, 0xBD, 0xA3 },
	0x8FA9,	{ 0xE5, 0xBD, 0xA5 },
	0x8FAA,	{ 0xE5, 0xBD, 0xA7 },
	0x8FAB,	{ 0xE5, 0xBD, 0xA8 },
	0x8FAC,	{ 0xE5, 0xBD, 0xAB },
	0x8FAD,	{ 0xE5, 0xBD, 0xAE },
	0x8FAE,	{ 0xE5, 0xBD, 0xAF },
	0x8FAF,	{ 0xE5, 0xBD, 0xB2 },
	0x8FB0,	{ 0xE5, 0xBD, 0xB4 },
	0x8FB1,	{ 0xE5, 0xBD, 0xB5 },
	0x8FB2,	{ 0xE5, 0xBD, 0xB6 },
	0x8FB3,	{ 0xE5, 0xBD, 0xB8 },
	0x8FB4,	{ 0xE5, 0xBD, 0xBA },
	0x8FB5,	{ 0xE5, 0xBD, 0xBD },
	0x8FB6,	{ 0xE5, 0xBD, 0xBE },
	0x8FB7,	{ 0xE5, 0xBD, 0xBF },
	0x8FB8,	{ 0xE5, 0xBE, 0x83 },
	0x8FB9,	{ 0xE5, 0xBE, 0x86 },
	0x8FBA,	{ 0xE5, 0xBE, 0x8D },
	0x8FBB,	{ 0xE5, 0xBE, 0x8E },
	0x8FBC,	{ 0xE5, 0xBE, 0x8F },
	0x8FBD,	{ 0xE5, 0xBE, 0x91 },
	0x8FBE,	{ 0xE5, 0xBE, 0x93 },
	0x8FBF,	{ 0xE5, 0xBE, 0x94 },
	0x8FC0,	{ 0xE5, 0xBE, 0x96 },
	0x8FC1,	{ 0xE5, 0xBE, 0x9A },
	0x8FC2,	{ 0xE5, 0xBE, 0x9B },
	0x8FC3,	{ 0xE5, 0xBE, 0x9D },
	0x8FC4,	{ 0xE5, 0xBE, 0x9E },
	0x8FC5,	{ 0xE5, 0xBE, 0x9F },
	0x8FC6,	{ 0xE5, 0xBE, 0xA0 },
	0x8FC7,	{ 0xE5, 0xBE, 0xA2 },
	0x8FC8,	{ 0xE5, 0xBE, 0xA3 },
	0x8FC9,	{ 0xE5, 0xBE, 0xA4 },
	0x8FCA,	{ 0xE5, 0xBE, 0xA5 },
	0x8FCB,	{ 0xE5, 0xBE, 0xA6 },
	0x8FCC,	{ 0xE5, 0xBE, 0xA7 },
	0x8FCD,	{ 0xE5, 0xBE, 0xA9 },
	0x8FCE,	{ 0xE5, 0xBE, 0xAB },
	0x8FCF,	{ 0xE5, 0xBE, 0xAC },
	0x8FD0,	{ 0xE5, 0xBE, 0xAF },
	0x8FD1,	{ 0xE5, 0xBE, 0xB0 },
	0x8FD2,	{ 0xE5, 0xBE, 0xB1 },
	0x8FD3,	{ 0xE5, 0xBE, 0xB2 },
	0x8FD4,	{ 0xE5, 0xBE, 0xB3 },
	0x8FD5,	{ 0xE5, 0xBE, 0xB4 },
	0x8FD6,	{ 0xE5, 0xBE, 0xB6 },
	0x8FD7,	{ 0xE5, 0xBE, 0xB8 },
	0x8FD8,	{ 0xE5, 0xBE, 0xB9 },
	0x8FD9,	{ 0xE5, 0xBE, 0xBA },
	0x8FDA,	{ 0xE5, 0xBE, 0xBB },
	0x8FDB,	{ 0xE5, 0xBE, 0xBE },
	0x8FDC,	{ 0xE5, 0xBE, 0xBF },
	0x8FDD,	{ 0xE5, 0xBF, 0x80 },
	0x8FDE,	{ 0xE5, 0xBF, 0x81 },
	0x8FDF,	{ 0xE5, 0xBF, 0x82 },
	0x8FE0,	{ 0xE5, 0xBF, 0x87 },
	0x8FE1,	{ 0xE5, 0xBF, 0x88 },
	0x8FE2,	{ 0xE5, 0xBF, 0x8A },
	0x8FE3,	{ 0xE5, 0xBF, 0x8B },
	0x8FE4,	{ 0xE5, 0xBF, 0x8E },
	0x8FE5,	{ 0xE5, 0xBF, 0x93 },
	0x8FE6,	{ 0xE5, 0xBF, 0x94 },
	0x8FE7,	{ 0xE5, 0xBF, 0x95 },
	0x8FE8,	{ 0xE5, 0xBF, 0x9A },
	0x8FE9,	{ 0xE5, 0xBF, 0x9B },
	0x8FEA,	{ 0xE5, 0xBF, 0x9C },
	0x8FEB,	{ 0xE5, 0xBF, 0x9E },
	0x8FEC,	{ 0xE5, 0xBF, 0x9F },
	0x8FED,	{ 0xE5, 0xBF, 0xA2 },
	0x8FEE,	{ 0xE5, 0xBF, 0xA3 },
	0x8FEF,	{ 0xE5, 0xBF, 0xA5 },
	0x8FF0,	{ 0xE5, 0xBF, 0xA6 },
	0x8FF1,	{ 0xE5, 0xBF, 0xA8 },
	0x8FF2,	{ 0xE5, 0xBF, 0xA9 },
	0x8FF3,	{ 0xE5, 0xBF, 0xAC },
	0x8FF4,	{ 0xE5, 0xBF, 0xAF },
	0x8FF5,	{ 0xE5, 0xBF, 0xB0 },
	0x8FF6,	{ 0xE5, 0xBF, 0xB2 },
	0x8FF7,	{ 0xE5, 0xBF, 0xB3 },
	0x8FF8,	{ 0xE5, 0xBF, 0xB4 },
	0x8FF9,	{ 0xE5, 0xBF, 0xB6 },
	0x8FFA,	{ 0xE5, 0xBF, 0xB7 },
	0x8FFB,	{ 0xE5, 0xBF, 0xB9 },
	0x8FFC,	{ 0xE5, 0xBF, 0xBA },
	0x8FFD,	{ 0xE5, 0xBF, 0xBC },
	0x8FFE,	{ 0xE6, 0x80, 0x87 },
	0x9040,	{ 0xE6, 0x80, 0x88 },
	0x9041,	{ 0xE6, 0x80, 0x89 },
	0x9042,	{ 0xE6, 0x80, 0x8B },
	0x9043,	{ 0xE6, 0x80, 0x8C },
	0x9044,	{ 0xE6, 0x80, 0x90 },
	0x9045,	{ 0xE6, 0x80, 0x91 },
	0x9046,	{ 0xE6, 0x80, 0x93 },
	0x9047,	{ 0xE6, 0x80, 0x97 },
	0x9048,	{ 0xE6, 0x80, 0x98 },
	0x9049,	{ 0xE6, 0x80, 0x9A },
	0x904A,	{ 0xE6, 0x80, 0x9E },
	0x904B,	{ 0xE6, 0x80, 0x9F },
	0x904C,	{ 0xE6, 0x80, 0xA2 },
	0x904D,	{ 0xE6, 0x80, 0xA3 },
	0x904E,	{ 0xE6, 0x80, 0xA4 },
	0x904F,	{ 0xE6, 0x80, 0xAC },
	0x9050,	{ 0xE6, 0x80, 0xAD },
	0x9051,	{ 0xE6, 0x80, 0xAE },
	0x9052,	{ 0xE6, 0x80, 0xB0 },
	0x9053,	{ 0xE6, 0x80, 0xB1 },
	0x9054,	{ 0xE6, 0x80, 0xB2 },
	0x9055,	{ 0xE6, 0x80, 0xB3 },
	0x9056,	{ 0xE6, 0x80, 0xB4 },
	0x9057,	{ 0xE6, 0x80, 0xB6 },
	0x9058,	{ 0xE6, 0x80, 0xB7 },
	0x9059,	{ 0xE6, 0x80, 0xB8 },
	0x905A,	{ 0xE6, 0x80, 0xB9 },
	0x905B,	{ 0xE6, 0x80, 0xBA },
	0x905C,	{ 0xE6, 0x80, 0xBD },
	0x905D,	{ 0xE6, 0x80, 0xBE },
	0x905E,	{ 0xE6, 0x81, 0x80 },
	0x905F,	{ 0xE6, 0x81, 0x84 },
	0x9060,	{ 0xE6, 0x81, 0x85 },
	0x9061,	{ 0xE6, 0x81, 0x86 },
	0x9062,	{ 0xE6, 0x81, 0x87 },
	0x9063,	{ 0xE6, 0x81, 0x88 },
	0x9064,	{ 0xE6, 0x81, 0x89 },
	0x9065,	{ 0xE6, 0x81, 0x8A },
	0x9066,	{ 0xE6, 0x81, 0x8C },
	0x9067,	{ 0xE6, 0x81, 0x8E },
	0x9068,	{ 0xE6, 0x81, 0x8F },
	0x9069,	{ 0xE6, 0x81, 0x91 },
	0x906A,	{ 0xE6, 0x81, 0x93 },
	0x906B,	{ 0xE6, 0x81, 0x94 },
	0x906C,	{ 0xE6, 0x81, 0x96 },
	0x906D,	{ 0xE6, 0x81, 0x97 },
	0x906E,	{ 0xE6, 0x81, 0x98 },
	0x906F,	{ 0xE6, 0x81, 0x9B },
	0x9070,	{ 0xE6, 0x81, 0x9C },
	0x9071,	{ 0xE6, 0x81, 0x9E },
	0x9072,	{ 0xE6, 0x81, 0x9F },
	0x9073,	{ 0xE6, 0x81, 0xA0 },
	0x9074,	{ 0xE6, 0x81, 0xA1 },
	0x9075,	{ 0xE6, 0x81, 0xA5 },
	0x9076,	{ 0xE6, 0x81, 0xA6 },
	0x9077,	{ 0xE6, 0x81, 0xAE },
	0x9078,	{ 0xE6, 0x81, 0xB1 },
	0x9079,	{ 0xE6, 0x81, 0xB2 },
	0x907A,	{ 0xE6, 0x81, 0xB4 },
	0x907B,	{ 0xE6, 0x81, 0xB5 },
	0x907C,	{ 0xE6, 0x81, 0xB7 },
	0x907D,	{ 0xE6, 0x81, 0xBE },
	0x907E,	{ 0xE6, 0x82, 0x80 },
	0x9080,	{ 0xE6, 0x82, 0x81 },
	0x9081,	{ 0xE6, 0x82, 0x82 },
	0x9082,	{ 0xE6, 0x82, 0x85 },
	0x9083,	{ 0xE6, 0x82, 0x86 },
	0x9084,	{ 0xE6, 0x82, 0x87 },
	0x9085,	{ 0xE6, 0x82, 0x88 },
	0x9086,	{ 0xE6, 0x82, 0x8A },
	0x9087,	{ 0xE6, 0x82, 0x8B },
	0x9088,	{ 0xE6, 0x82, 0x8E },
	0x9089,	{ 0xE6, 0x82, 0x8F },
	0x908A,	{ 0xE6, 0x82, 0x90 },
	0x908B,	{ 0xE6, 0x82, 0x91 },
	0x908C,	{ 0xE6, 0x82, 0x93 },
	0x908D,	{ 0xE6, 0x82, 0x95 },
	0x908E,	{ 0xE6, 0x82, 0x97 },
	0x908F,	{ 0xE6, 0x82, 0x98 },
	0x9090,	{ 0xE6, 0x82, 0x99 },
	0x9091,	{ 0xE6, 0x82, 0x9C },
	0x9092,	{ 0xE6, 0x82, 0x9E },
	0x9093,	{ 0xE6, 0x82, 0xA1 },
	0x9094,	{ 0xE6, 0x82, 0xA2 },
	0x9095,	{ 0xE6, 0x82, 0xA4 },
	0x9096,	{ 0xE6, 0x82, 0xA5 },
	0x9097,	{ 0xE6, 0x82, 0xA7 },
	0x9098,	{ 0xE6, 0x82, 0xA9 },
	0x9099,	{ 0xE6, 0x82, 0xAA },
	0x909A,	{ 0xE6, 0x82, 0xAE },
	0x909B,	{ 0xE6, 0x82, 0xB0 },
	0x909C,	{ 0xE6, 0x82, 0xB3 },
	0x909D,	{ 0xE6, 0x82, 0xB5 },
	0x909E,	{ 0xE6, 0x82, 0xB6 },
	0x909F,	{ 0xE6, 0x82, 0xB7 },
	0x90A0,	{ 0xE6, 0x82, 0xB9 },
	0x90A1,	{ 0xE6, 0x82, 0xBA },
	0x90A2,	{ 0xE6, 0x82, 0xBD },
	0x90A3,	{ 0xE6, 0x82, 0xBE },
	0x90A4,	{ 0xE6, 0x82, 0xBF },
	0x90A5,	{ 0xE6, 0x83, 0x80 },
	0x90A6,	{ 0xE6, 0x83, 0x81 },
	0x90A7,	{ 0xE6, 0x83, 0x82 },
	0x90A8,	{ 0xE6, 0x83, 0x83 },
	0x90A9,	{ 0xE6, 0x83, 0x84 },
	0x90AA,	{ 0xE6, 0x83, 0x87 },
	0x90AB,	{ 0xE6, 0x83, 0x88 },
	0x90AC,	{ 0xE6, 0x83, 0x89 },
	0x90AD,	{ 0xE6, 0x83, 0x8C },
	0x90AE,	{ 0xE6, 0x83, 0x8D },
	0x90AF,	{ 0xE6, 0x83, 0x8E },
	0x90B0,	{ 0xE6, 0x83, 0x8F },
	0x90B1,	{ 0xE6, 0x83, 0x90 },
	0x90B2,	{ 0xE6, 0x83, 0x92 },
	0x90B3,	{ 0xE6, 0x83, 0x93 },
	0x90B4,	{ 0xE6, 0x83, 0x94 },
	0x90B5,	{ 0xE6, 0x83, 0x96 },
	0x90B6,	{ 0xE6, 0x83, 0x97 },
	0x90B7,	{ 0xE6, 0x83, 0x99 },
	0x90B8,	{ 0xE6, 0x83, 0x9B },
	0x90B9,	{ 0xE6, 0x83, 0x9E },
	0x90BA,	{ 0xE6, 0x83, 0xA1 },
	0x90BB,	{ 0xE6, 0x83, 0xA2 },
	0x90BC,	{ 0xE6, 0x83, 0xA3 },
	0x90BD,	{ 0xE6, 0x83, 0xA4 },
	0x90BE,	{ 0xE6, 0x83, 0xA5 },
	0x90BF,	{ 0xE6, 0x83, 0xAA },
	0x90C0,	{ 0xE6, 0x83, 0xB1 },
	0x90C1,	{ 0xE6, 0x83, 0xB2 },
	0x90C2,	{ 0xE6, 0x83, 0xB5 },
	0x90C3,	{ 0xE6, 0x83, 0xB7 },
	0x90C4,	{ 0xE6, 0x83, 0xB8 },
	0x90C5,	{ 0xE6, 0x83, 0xBB },
	0x90C6,	{ 0xE6, 0x83, 0xBC },
	0x90C7,	{ 0xE6, 0x83, 0xBD },
	0x90C8,	{ 0xE6, 0x83, 0xBE },
	0x90C9,	{ 0xE6, 0x83, 0xBF },
	0x90CA,	{ 0xE6, 0x84, 0x82 },
	0x90CB,	{ 0xE6, 0x84, 0x83 },
	0x90CC,	{ 0xE6, 0x84, 0x84 },
	0x90CD,	{ 0xE6, 0x84, 0x85 },
	0x90CE,	{ 0xE6, 0x84, 0x87 },
	0x90CF,	{ 0xE6, 0x84, 0x8A },
	0x90D0,	{ 0xE6, 0x84, 0x8B },
	0x90D1,	{ 0xE6, 0x84, 0x8C },
	0x90D2,	{ 0xE6, 0x84, 0x90 },
	0x90D3,	{ 0xE6, 0x84, 0x91 },
	0x90D4,	{ 0xE6, 0x84, 0x92 },
	0x90D5,	{ 0xE6, 0x84, 0x93 },
	0x90D6,	{ 0xE6, 0x84, 0x94 },
	0x90D7,	{ 0xE6, 0x84, 0x96 },
	0x90D8,	{ 0xE6, 0x84, 0x97 },
	0x90D9,	{ 0xE6, 0x84, 0x98 },
	0x90DA,	{ 0xE6, 0x84, 0x99 },
	0x90DB,	{ 0xE6, 0x84, 0x9B },
	0x90DC,	{ 0xE6, 0x84, 0x9C },
	0x90DD,	{ 0xE6, 0x84, 0x9D },
	0x90DE,	{ 0xE6, 0x84, 0x9E },
	0x90DF,	{ 0xE6, 0x84, 0xA1 },
	0x90E0,	{ 0xE6, 0x84, 0xA2 },
	0x90E1,	{ 0xE6, 0x84, 0xA5 },
	0x90E2,	{ 0xE6, 0x84, 0xA8 },
	0x90E3,	{ 0xE6, 0x84, 0xA9 },
	0x90E4,	{ 0xE6, 0x84, 0xAA },
	0x90E5,	{ 0xE6, 0x84, 0xAC },
	0x90E6,	{ 0xE6, 0x84, 0xAD },
	0x90E7,	{ 0xE6, 0x84, 0xAE },
	0x90E8,	{ 0xE6, 0x84, 0xAF },
	0x90E9,	{ 0xE6, 0x84, 0xB0 },
	0x90EA,	{ 0xE6, 0x84, 0xB1 },
	0x90EB,	{ 0xE6, 0x84, 0xB2 },
	0x90EC,	{ 0xE6, 0x84, 0xB3 },
	0x90ED,	{ 0xE6, 0x84, 0xB4 },
	0x90EE,	{ 0xE6, 0x84, 0xB5 },
	0x90EF,	{ 0xE6, 0x84, 0xB6 },
	0x90F0,	{ 0xE6, 0x84, 0xB7 },
	0x90F1,	{ 0xE6, 0x84, 0xB8 },
	0x90F2,	{ 0xE6, 0x84, 0xB9 },
	0x90F3,	{ 0xE6, 0x84, 0xBA },
	0x90F4,	{ 0xE6, 0x84, 0xBB },
	0x90F5,	{ 0xE6, 0x84, 0xBC },
	0x90F6,	{ 0xE6, 0x84, 0xBD },
	0x90F7,	{ 0xE6, 0x84, 0xBE },
	0x90F8,	{ 0xE6, 0x85, 0x80 },
	0x90F9,	{ 0xE6, 0x85, 0x81 },
	0x90FA,	{ 0xE6, 0x85, 0x82 },
	0x90FB,	{ 0xE6, 0x85, 0x83 },
	0x90FC,	{ 0xE6, 0x85, 0x84 },
	0x90FD,	{ 0xE6, 0x85, 0x85 },
	0x90FE,	{ 0xE6, 0x85, 0x86 },
	0x9140,	{ 0xE6, 0x85, 0x87 },
	0x9141,	{ 0xE6, 0x85, 0x89 },
	0x9142,	{ 0xE6, 0x85, 0x8B },
	0x9143,	{ 0xE6, 0x85, 0x8D },
	0x9144,	{ 0xE6, 0x85, 0x8F },
	0x9145,	{ 0xE6, 0x85, 0x90 },
	0x9146,	{ 0xE6, 0x85, 0x92 },
	0x9147,	{ 0xE6, 0x85, 0x93 },
	0x9148,	{ 0xE6, 0x85, 0x94 },
	0x9149,	{ 0xE6, 0x85, 0x96 },
	0x914A,	{ 0xE6, 0x85, 0x97 },
	0x914B,	{ 0xE6, 0x85, 0x98 },
	0x914C,	{ 0xE6, 0x85, 0x99 },
	0x914D,	{ 0xE6, 0x85, 0x9A },
	0x914E,	{ 0xE6, 0x85, 0x9B },
	0x914F,	{ 0xE6, 0x85, 0x9C },
	0x9150,	{ 0xE6, 0x85, 0x9E },
	0x9151,	{ 0xE6, 0x85, 0x9F },
	0x9152,	{ 0xE6, 0x85, 0xA0 },
	0x9153,	{ 0xE6, 0x85, 0xA1 },
	0x9154,	{ 0xE6, 0x85, 0xA3 },
	0x9155,	{ 0xE6, 0x85, 0xA4 },
	0x9156,	{ 0xE6, 0x85, 0xA5 },
	0x9157,	{ 0xE6, 0x85, 0xA6 },
	0x9158,	{ 0xE6, 0x85, 0xA9 },
	0x9159,	{ 0xE6, 0x85, 0xAA },
	0x915A,	{ 0xE6, 0x85, 0xAB },
	0x915B,	{ 0xE6, 0x85, 0xAC },
	0x915C,	{ 0xE6, 0x85, 0xAD },
	0x915D,	{ 0xE6, 0x85, 0xAE },
	0x915E,	{ 0xE6, 0x85, 0xAF },
	0x915F,	{ 0xE6, 0x85, 0xB1 },
	0x9160,	{ 0xE6, 0x85, 0xB2 },
	0x9161,	{ 0xE6, 0x85, 0xB3 },
	0x9162,	{ 0xE6, 0x85, 0xB4 },
	0x9163,	{ 0xE6, 0x85, 0xB6 },
	0x9164,	{ 0xE6, 0x85, 0xB8 },
	0x9165,	{ 0xE6, 0x85, 0xB9 },
	0x9166,	{ 0xE6, 0x85, 0xBA },
	0x9167,	{ 0xE6, 0x85, 0xBB },
	0x9168,	{ 0xE6, 0x85, 0xBC },
	0x9169,	{ 0xE6, 0x85, 0xBD },
	0x916A,	{ 0xE6, 0x85, 0xBE },
	0x916B,	{ 0xE6, 0x85, 0xBF },
	0x916C,	{ 0xE6, 0x86, 0x80 },
	0x916D,	{ 0xE6, 0x86, 0x81 },
	0x916E,	{ 0xE6, 0x86, 0x82 },
	0x916F,	{ 0xE6, 0x86, 0x83 },
	0x9170,	{ 0xE6, 0x86, 0x84 },
	0x9171,	{ 0xE6, 0x86, 0x85 },
	0x9172,	{ 0xE6, 0x86, 0x86 },
	0x9173,	{ 0xE6, 0x86, 0x87 },
	0x9174,	{ 0xE6, 0x86, 0x88 },
	0x9175,	{ 0xE6, 0x86, 0x89 },
	0x9176,	{ 0xE6, 0x86, 0x8A },
	0x9177,	{ 0xE6, 0x86, 0x8C },
	0x9178,	{ 0xE6, 0x86, 0x8D },
	0x9179,	{ 0xE6, 0x86, 0x8F },
	0x917A,	{ 0xE6, 0x86, 0x90 },
	0x917B,	{ 0xE6, 0x86, 0x91 },
	0x917C,	{ 0xE6, 0x86, 0x92 },
	0x917D,	{ 0xE6, 0x86, 0x93 },
	0x917E,	{ 0xE6, 0x86, 0x95 },
	0x9180,	{ 0xE6, 0x86, 0x96 },
	0x9181,	{ 0xE6, 0x86, 0x97 },
	0x9182,	{ 0xE6, 0x86, 0x98 },
	0x9183,	{ 0xE6, 0x86, 0x99 },
	0x9184,	{ 0xE6, 0x86, 0x9A },
	0x9185,	{ 0xE6, 0x86, 0x9B },
	0x9186,	{ 0xE6, 0x86, 0x9C },
	0x9187,	{ 0xE6, 0x86, 0x9E },
	0x9188,	{ 0xE6, 0x86, 0x9F },
	0x9189,	{ 0xE6, 0x86, 0xA0 },
	0x918A,	{ 0xE6, 0x86, 0xA1 },
	0x918B,	{ 0xE6, 0x86, 0xA2 },
	0x918C,	{ 0xE6, 0x86, 0xA3 },
	0x918D,	{ 0xE6, 0x86, 0xA4 },
	0x918E,	{ 0xE6, 0x86, 0xA5 },
	0x918F,	{ 0xE6, 0x86, 0xA6 },
	0x9190,	{ 0xE6, 0x86, 0xAA },
	0x9191,	{ 0xE6, 0x86, 0xAB },
	0x9192,	{ 0xE6, 0x86, 0xAD },
	0x9193,	{ 0xE6, 0x86, 0xAE },
	0x9194,	{ 0xE6, 0x86, 0xAF },
	0x9195,	{ 0xE6, 0x86, 0xB0 },
	0x9196,	{ 0xE6, 0x86, 0xB1 },
	0x9197,	{ 0xE6, 0x86, 0xB2 },
	0x9198,	{ 0xE6, 0x86, 0xB3 },
	0x9199,	{ 0xE6, 0x86, 0xB4 },
	0x919A,	{ 0xE6, 0x86, 0xB5 },
	0x919B,	{ 0xE6, 0x86, 0xB6 },
	0x919C,	{ 0xE6, 0x86, 0xB8 },
	0x919D,	{ 0xE6, 0x86, 0xB9 },
	0x919E,	{ 0xE6, 0x86, 0xBA },
	0x919F,	{ 0xE6, 0x86, 0xBB },
	0x91A0,	{ 0xE6, 0x86, 0xBC },
	0x91A1,	{ 0xE6, 0x86, 0xBD },
	0x91A2,	{ 0xE6, 0x86, 0xBF },
	0x91A3,	{ 0xE6, 0x87, 0x80 },
	0x91A4,	{ 0xE6, 0x87, 0x81 },
	0x91A5,	{ 0xE6, 0x87, 0x83 },
	0x91A6,	{ 0xE6, 0x87, 0x84 },
	0x91A7,	{ 0xE6, 0x87, 0x85 },
	0x91A8,	{ 0xE6, 0x87, 0x86 },
	0x91A9,	{ 0xE6, 0x87, 0x87 },
	0x91AA,	{ 0xE6, 0x87, 0x89 },
	0x91AB,	{ 0xE6, 0x87, 0x8C },
	0x91AC,	{ 0xE6, 0x87, 0x8D },
	0x91AD,	{ 0xE6, 0x87, 0x8E },
	0x91AE,	{ 0xE6, 0x87, 0x8F },
	0x91AF,	{ 0xE6, 0x87, 0x90 },
	0x91B0,	{ 0xE6, 0x87, 0x93 },
	0x91B1,	{ 0xE6, 0x87, 0x95 },
	0x91B2,	{ 0xE6, 0x87, 0x96 },
	0x91B3,	{ 0xE6, 0x87, 0x97 },
	0x91B4,	{ 0xE6, 0x87, 0x98 },
	0x91B5,	{ 0xE6, 0x87, 0x99 },
	0x91B6,	{ 0xE6, 0x87, 0x9A },
	0x91B7,	{ 0xE6, 0x87, 0x9B },
	0x91B8,	{ 0xE6, 0x87, 0x9C },
	0x91B9,	{ 0xE6, 0x87, 0x9D },
	0x91BA,	{ 0xE6, 0x87, 0x9E },
	0x91BB,	{ 0xE6, 0x87, 0x9F },
	0x91BC,	{ 0xE6, 0x87, 0xA0 },
	0x91BD,	{ 0xE6, 0x87, 0xA1 },
	0x91BE,	{ 0xE6, 0x87, 0xA2 },
	0x91BF,	{ 0xE6, 0x87, 0xA3 },
	0x91C0,	{ 0xE6, 0x87, 0xA4 },
	0x91C1,	{ 0xE6, 0x87, 0xA5 },
	0x91C2,	{ 0xE6, 0x87, 0xA7 },
	0x91C3,	{ 0xE6, 0x87, 0xA8 },
	0x91C4,	{ 0xE6, 0x87, 0xA9 },
	0x91C5,	{ 0xE6, 0x87, 0xAA },
	0x91C6,	{ 0xE6, 0x87, 0xAB },
	0x91C7,	{ 0xE6, 0x87, 0xAC },
	0x91C8,	{ 0xE6, 0x87, 0xAD },
	0x91C9,	{ 0xE6, 0x87, 0xAE },
	0x91CA,	{ 0xE6, 0x87, 0xAF },
	0x91CB,	{ 0xE6, 0x87, 0xB0 },
	0x91CC,	{ 0xE6, 0x87, 0xB1 },
	0x91CD,	{ 0xE6, 0x87, 0xB2 },
	0x91CE,	{ 0xE6, 0x87, 0xB3 },
	0x91CF,	{ 0xE6, 0x87, 0xB4 },
	0x91D0,	{ 0xE6, 0x87, 0xB6 },
	0x91D1,	{ 0xE6, 0x87, 0xB7 },
	0x91D2,	{ 0xE6, 0x87, 0xB8 },
	0x91D3,	{ 0xE6, 0x87, 0xB9 },
	0x91D4,	{ 0xE6, 0x87, 0xBA },
	0x91D5,	{ 0xE6, 0x87, 0xBB },
	0x91D6,	{ 0xE6, 0x87, 0xBC },
	0x91D7,	{ 0xE6, 0x87, 0xBD },
	0x91D8,	{ 0xE6, 0x87, 0xBE },
	0x91D9,	{ 0xE6, 0x88, 0x80 },
	0x91DA,	{ 0xE6, 0x88, 0x81 },
	0x91DB,	{ 0xE6, 0x88, 0x82 },
	0x91DC,	{ 0xE6, 0x88, 0x83 },
	0x91DD,	{ 0xE6, 0x88, 0x84 },
	0x91DE,	{ 0xE6, 0x88, 0x85 },
	0x91DF,	{ 0xE6, 0x88, 0x87 },
	0x91E0,	{ 0xE6, 0x88, 0x89 },
	0x91E1,	{ 0xE6, 0x88, 0x93 },
	0x91E2,	{ 0xE6, 0x88, 0x94 },
	0x91E3,	{ 0xE6, 0x88, 0x99 },
	0x91E4,	{ 0xE6, 0x88, 0x9C },
	0x91E5,	{ 0xE6, 0x88, 0x9D },
	0x91E6,	{ 0xE6, 0x88, 0x9E },
	0x91E7,	{ 0xE6, 0x88, 0xA0 },
	0x91E8,	{ 0xE6, 0x88, 0xA3 },
	0x91E9,	{ 0xE6, 0x88, 0xA6 },
	0x91EA,	{ 0xE6, 0x88, 0xA7 },
	0x91EB,	{ 0xE6, 0x88, 0xA8 },
	0x91EC,	{ 0xE6, 0x88, 0xA9 },
	0x91ED,	{ 0xE6, 0x88, 0xAB },
	0x91EE,	{ 0xE6, 0x88, 0xAD },
	0x91EF,	{ 0xE6, 0x88, 0xAF },
	0x91F0,	{ 0xE6, 0x88, 0xB0 },
	0x91F1,	{ 0xE6, 0x88, 0xB1 },
	0x91F2,	{ 0xE6, 0x88, 0xB2 },
	0x91F3,	{ 0xE6, 0x88, 0xB5 },
	0x91F4,	{ 0xE6, 0x88, 0xB6 },
	0x91F5,	{ 0xE6, 0x88, 0xB8 },
	0x91F6,	{ 0xE6, 0x88, 0xB9 },
	0x91F7,	{ 0xE6, 0x88, 0xBA },
	0x91F8,	{ 0xE6, 0x88, 0xBB },
	0x91F9,	{ 0xE6, 0x88, 0xBC },
	0x91FA,	{ 0xE6, 0x89, 0x82 },
	0x91FB,	{ 0xE6, 0x89, 0x84 },
	0x91FC,	{ 0xE6, 0x89, 0x85 },
	0x91FD,	{ 0xE6, 0x89, 0x86 },
	0x91FE,	{ 0xE6, 0x89, 0x8A },
	0x9240,	{ 0xE6, 0x89, 0x8F },
	0x9241,	{ 0xE6, 0x89, 0x90 },
	0x9242,	{ 0xE6, 0x89, 0x95 },
	0x9243,	{ 0xE6, 0x89, 0x96 },
	0x9244,	{ 0xE6, 0x89, 0x97 },
	0x9245,	{ 0xE6, 0x89, 0x99 },
	0x9246,	{ 0xE6, 0x89, 0x9A },
	0x9247,	{ 0xE6, 0x89, 0x9C },
	0x9248,	{ 0xE6, 0x89, 0x9D },
	0x9249,	{ 0xE6, 0x89, 0x9E },
	0x924A,	{ 0xE6, 0x89, 0x9F },
	0x924B,	{ 0xE6, 0x89, 0xA0 },
	0x924C,	{ 0xE6, 0x89, 0xA1 },
	0x924D,	{ 0xE6, 0x89, 0xA2 },
	0x924E,	{ 0xE6, 0x89, 0xA4 },
	0x924F,	{ 0xE6, 0x89, 0xA5 },
	0x9250,	{ 0xE6, 0x89, 0xA8 },
	0x9251,	{ 0xE6, 0x89, 0xB1 },
	0x9252,	{ 0xE6, 0x89, 0xB2 },
	0x9253,	{ 0xE6, 0x89, 0xB4 },
	0x9254,	{ 0xE6, 0x89, 0xB5 },
	0x9255,	{ 0xE6, 0x89, 0xB7 },
	0x9256,	{ 0xE6, 0x89, 0xB8 },
	0x9257,	{ 0xE6, 0x89, 0xBA },
	0x9258,	{ 0xE6, 0x89, 0xBB },
	0x9259,	{ 0xE6, 0x89, 0xBD },
	0x925A,	{ 0xE6, 0x8A, 0x81 },
	0x925B,	{ 0xE6, 0x8A, 0x82 },
	0x925C,	{ 0xE6, 0x8A, 0x83 },
	0x925D,	{ 0xE6, 0x8A, 0x85 },
	0x925E,	{ 0xE6, 0x8A, 0x86 },
	0x925F,	{ 0xE6, 0x8A, 0x87 },
	0x9260,	{ 0xE6, 0x8A, 0x88 },
	0x9261,	{ 0xE6, 0x8A, 0x8B },
	0x9262,	{ 0xE6, 0x8A, 0x8C },
	0x9263,	{ 0xE6, 0x8A, 0x8D },
	0x9264,	{ 0xE6, 0x8A, 0x8E },
	0x9265,	{ 0xE6, 0x8A, 0x8F },
	0x9266,	{ 0xE6, 0x8A, 0x90 },
	0x9267,	{ 0xE6, 0x8A, 0x94 },
	0x9268,	{ 0xE6, 0x8A, 0x99 },
	0x9269,	{ 0xE6, 0x8A, 0x9C },
	0x926A,	{ 0xE6, 0x8A, 0x9D },
	0x926B,	{ 0xE6, 0x8A, 0x9E },
	0x926C,	{ 0xE6, 0x8A, 0xA3 },
	0x926D,	{ 0xE6, 0x8A, 0xA6 },
	0x926E,	{ 0xE6, 0x8A, 0xA7 },
	0x926F,	{ 0xE6, 0x8A, 0xA9 },
	0x9270,	{ 0xE6, 0x8A, 0xAA },
	0x9271,	{ 0xE6, 0x8A, 0xAD },
	0x9272,	{ 0xE6, 0x8A, 0xAE },
	0x9273,	{ 0xE6, 0x8A, 0xAF },
	0x9274,	{ 0xE6, 0x8A, 0xB0 },
	0x9275,	{ 0xE6, 0x8A, 0xB2 },
	0x9276,	{ 0xE6, 0x8A, 0xB3 },
	0x9277,	{ 0xE6, 0x8A, 0xB4 },
	0x9278,	{ 0xE6, 0x8A, 0xB6 },
	0x9279,	{ 0xE6, 0x8A, 0xB7 },
	0x927A,	{ 0xE6, 0x8A, 0xB8 },
	0x927B,	{ 0xE6, 0x8A, 0xBA },
	0x927C,	{ 0xE6, 0x8A, 0xBE },
	0x927D,	{ 0xE6, 0x8B, 0x80 },
	0x927E,	{ 0xE6, 0x8B, 0x81 },
	0x9280,	{ 0xE6, 0x8B, 0x83 },
	0x9281,	{ 0xE6, 0x8B, 0x8B },
	0x9282,	{ 0xE6, 0x8B, 0x8F },
	0x9283,	{ 0xE6, 0x8B, 0x91 },
	0x9284,	{ 0xE6, 0x8B, 0x95 },
	0x9285,	{ 0xE6, 0x8B, 0x9D },
	0x9286,	{ 0xE6, 0x8B, 0x9E },
	0x9287,	{ 0xE6, 0x8B, 0xA0 },
	0x9288,	{ 0xE6, 0x8B, 0xA1 },
	0x9289,	{ 0xE6, 0x8B, 0xA4 },
	0x928A,	{ 0xE6, 0x8B, 0xAA },
	0x928B,	{ 0xE6, 0x8B, 0xAB },
	0x928C,	{ 0xE6, 0x8B, 0xB0 },
	0x928D,	{ 0xE6, 0x8B, 0xB2 },
	0x928E,	{ 0xE6, 0x8B, 0xB5 },
	0x928F,	{ 0xE6, 0x8B, 0xB8 },
	0x9290,	{ 0xE6, 0x8B, 0xB9 },
	0x9291,	{ 0xE6, 0x8B, 0xBA },
	0x9292,	{ 0xE6, 0x8B, 0xBB },
	0x9293,	{ 0xE6, 0x8C, 0x80 },
	0x9294,	{ 0xE6, 0x8C, 0x83 },
	0x9295,	{ 0xE6, 0x8C, 0x84 },
	0x9296,	{ 0xE6, 0x8C, 0x85 },
	0x9297,	{ 0xE6, 0x8C, 0x86 },
	0x9298,	{ 0xE6, 0x8C, 0x8A },
	0x9299,	{ 0xE6, 0x8C, 0x8B },
	0x929A,	{ 0xE6, 0x8C, 0x8C },
	0x929B,	{ 0xE6, 0x8C, 0x8D },
	0x929C,	{ 0xE6, 0x8C, 0x8F },
	0x929D,	{ 0xE6, 0x8C, 0x90 },
	0x929E,	{ 0xE6, 0x8C, 0x92 },
	0x929F,	{ 0xE6, 0x8C, 0x93 },
	0x92A0,	{ 0xE6, 0x8C, 0x94 },
	0x92A1,	{ 0xE6, 0x8C, 0x95 },
	0x92A2,	{ 0xE6, 0x8C, 0x97 },
	0x92A3,	{ 0xE6, 0x8C, 0x98 },
	0x92A4,	{ 0xE6, 0x8C, 0x99 },
	0x92A5,	{ 0xE6, 0x8C, 0x9C },
	0x92A6,	{ 0xE6, 0x8C, 0xA6 },
	0x92A7,	{ 0xE6, 0x8C, 0xA7 },
	0x92A8,	{ 0xE6, 0x8C, 0xA9 },
	0x92A9,	{ 0xE6, 0x8C, 0xAC },
	0x92AA,	{ 0xE6, 0x8C, 0xAD },
	0x92AB,	{ 0xE6, 0x8C, 0xAE },
	0x92AC,	{ 0xE6, 0x8C, 0xB0 },
	0x92AD,	{ 0xE6, 0x8C, 0xB1 },
	0x92AE,	{ 0xE6, 0x8C, 0xB3 },
	0x92AF,	{ 0xE6, 0x8C, 0xB4 },
	0x92B0,	{ 0xE6, 0x8C, 0xB5 },
	0x92B1,	{ 0xE6, 0x8C, 0xB6 },
	0x92B2,	{ 0xE6, 0x8C, 0xB7 },
	0x92B3,	{ 0xE6, 0x8C, 0xB8 },
	0x92B4,	{ 0xE6, 0x8C, 0xBB },
	0x92B5,	{ 0xE6, 0x8C, 0xBC },
	0x92B6,	{ 0xE6, 0x8C, 0xBE },
	0x92B7,	{ 0xE6, 0x8C, 0xBF },
	0x92B8,	{ 0xE6, 0x8D, 0x80 },
	0x92B9,	{ 0xE6, 0x8D, 0x81 },
	0x92BA,	{ 0xE6, 0x8D, 0x84 },
	0x92BB,	{ 0xE6, 0x8D, 0x87 },
	0x92BC,	{ 0xE6, 0x8D, 0x88 },
	0x92BD,	{ 0xE6, 0x8D, 0x8A },
	0x92BE,	{ 0xE6, 0x8D, 0x91 },
	0x92BF,	{ 0xE6, 0x8D, 0x92 },
	0x92C0,	{ 0xE6, 0x8D, 0x93 },
	0x92C1,	{ 0xE6, 0x8D, 0x94 },
	0x92C2,	{ 0xE6, 0x8D, 0x96 },
	0x92C3,	{ 0xE6, 0x8D, 0x97 },
	0x92C4,	{ 0xE6, 0x8D, 0x98 },
	0x92C5,	{ 0xE6, 0x8D, 0x99 },
	0x92C6,	{ 0xE6, 0x8D, 0x9A },
	0x92C7,	{ 0xE6, 0x8D, 0x9B },
	0x92C8,	{ 0xE6, 0x8D, 0x9C },
	0x92C9,	{ 0xE6, 0x8D, 0x9D },
	0x92CA,	{ 0xE6, 0x8D, 0xA0 },
	0x92CB,	{ 0xE6, 0x8D, 0xA4 },
	0x92CC,	{ 0xE6, 0x8D, 0xA5 },
	0x92CD,	{ 0xE6, 0x8D, 0xA6 },
	0x92CE,	{ 0xE6, 0x8D, 0xA8 },
	0x92CF,	{ 0xE6, 0x8D, 0xAA },
	0x92D0,	{ 0xE6, 0x8D, 0xAB },
	0x92D1,	{ 0xE6, 0x8D, 0xAC },
	0x92D2,	{ 0xE6, 0x8D, 0xAF },
	0x92D3,	{ 0xE6, 0x8D, 0xB0 },
	0x92D4,	{ 0xE6, 0x8D, 0xB2 },
	0x92D5,	{ 0xE6, 0x8D, 0xB3 },
	0x92D6,	{ 0xE6, 0x8D, 0xB4 },
	0x92D7,	{ 0xE6, 0x8D, 0xB5 },
	0x92D8,	{ 0xE6, 0x8D, 0xB8 },
	0x92D9,	{ 0xE6, 0x8D, 0xB9 },
	0x92DA,	{ 0xE6, 0x8D, 0xBC },
	0x92DB,	{ 0xE6, 0x8D, 0xBD },
	0x92DC,	{ 0xE6, 0x8D, 0xBE },
	0x92DD,	{ 0xE6, 0x8D, 0xBF },
	0x92DE,	{ 0xE6, 0x8E, 0x81 },
	0x92DF,	{ 0xE6, 0x8E, 0x83 },
	0x92E0,	{ 0xE6, 0x8E, 0x84 },
	0x92E1,	{ 0xE6, 0x8E, 0x85 },
	0x92E2,	{ 0xE6, 0x8E, 0x86 },
	0x92E3,	{ 0xE6, 0x8E, 0x8B },
	0x92E4,	{ 0xE6, 0x8E, 0x8D },
	0x92E5,	{ 0xE6, 0x8E, 0x91 },
	0x92E6,	{ 0xE6, 0x8E, 0x93 },
	0x92E7,	{ 0xE6, 0x8E, 0x94 },
	0x92E8,	{ 0xE6, 0x8E, 0x95 },
	0x92E9,	{ 0xE6, 0x8E, 0x97 },
	0x92EA,	{ 0xE6, 0x8E, 0x99 },
	0x92EB,	{ 0xE6, 0x8E, 0x9A },
	0x92EC,	{ 0xE6, 0x8E, 0x9B },
	0x92ED,	{ 0xE6, 0x8E, 0x9C },
	0x92EE,	{ 0xE6, 0x8E, 0x9D },
	0x92EF,	{ 0xE6, 0x8E, 0x9E },
	0x92F0,	{ 0xE6, 0x8E, 0x9F },
	0x92F1,	{ 0xE6, 0x8E, 0xA1 },
	0x92F2,	{ 0xE6, 0x8E, 0xA4 },
	0x92F3,	{ 0xE6, 0x8E, 0xA6 },
	0x92F4,	{ 0xE6, 0x8E, 0xAB },
	0x92F5,	{ 0xE6, 0x8E, 0xAF },
	0x92F6,	{ 0xE6, 0x8E, 0xB1 },
	0x92F7,	{ 0xE6, 0x8E, 0xB2 },
	0x92F8,	{ 0xE6, 0x8E, 0xB5 },
	0x92F9,	{ 0xE6, 0x8E, 0xB6 },
	0x92FA,	{ 0xE6, 0x8E, 0xB9 },
	0x92FB,	{ 0xE6, 0x8E, 0xBB },
	0x92FC,	{ 0xE6, 0x8E, 0xBD },
	0x92FD,	{ 0xE6, 0x8E, 0xBF },
	0x92FE,	{ 0xE6, 0x8F, 0x80 },
	0x9340,	{ 0xE6, 0x8F, 0x81 },
	0x9341,	{ 0xE6, 0x8F, 0x82 },
	0x9342,	{ 0xE6, 0x8F, 0x83 },
	0x9343,	{ 0xE6, 0x8F, 0x85 },
	0x9344,	{ 0xE6, 0x8F, 0x87 },
	0x9345,	{ 0xE6, 0x8F, 0x88 },
	0x9346,	{ 0xE6, 0x8F, 0x8A },
	0x9347,	{ 0xE6, 0x8F, 0x8B },
	0x9348,	{ 0xE6, 0x8F, 0x8C },
	0x9349,	{ 0xE6, 0x8F, 0x91 },
	0x934A,	{ 0xE6, 0x8F, 0x93 },
	0x934B,	{ 0xE6, 0x8F, 0x94 },
	0x934C,	{ 0xE6, 0x8F, 0x95 },
	0x934D,	{ 0xE6, 0x8F, 0x97 },
	0x934E,	{ 0xE6, 0x8F, 0x98 },
	0x934F,	{ 0xE6, 0x8F, 0x99 },
	0x9350,	{ 0xE6, 0x8F, 0x9A },
	0x9351,	{ 0xE6, 0x8F, 0x9B },
	0x9352,	{ 0xE6, 0x8F, 0x9C },
	0x9353,	{ 0xE6, 0x8F, 0x9D },
	0x9354,	{ 0xE6, 0x8F, 0x9F },
	0x9355,	{ 0xE6, 0x8F, 0xA2 },
	0x9356,	{ 0xE6, 0x8F, 0xA4 },
	0x9357,	{ 0xE6, 0x8F, 0xA5 },
	0x9358,	{ 0xE6, 0x8F, 0xA6 },
	0x9359,	{ 0xE6, 0x8F, 0xA7 },
	0x935A,	{ 0xE6, 0x8F, 0xA8 },
	0x935B,	{ 0xE6, 0x8F, 0xAB },
	0x935C,	{ 0xE6, 0x8F, 0xAC },
	0x935D,	{ 0xE6, 0x8F, 0xAE },
	0x935E,	{ 0xE6, 0x8F, 0xAF },
	0x935F,	{ 0xE6, 0x8F, 0xB0 },
	0x9360,	{ 0xE6, 0x8F, 0xB1 },
	0x9361,	{ 0xE6, 0x8F, 0xB3 },
	0x9362,	{ 0xE6, 0x8F, 0xB5 },
	0x9363,	{ 0xE6, 0x8F, 0xB7 },
	0x9364,	{ 0xE6, 0x8F, 0xB9 },
	0x9365,	{ 0xE6, 0x8F, 0xBA },
	0x9366,	{ 0xE6, 0x8F, 0xBB },
	0x9367,	{ 0xE6, 0x8F, 0xBC },
	0x9368,	{ 0xE6, 0x8F, 0xBE },
	0x9369,	{ 0xE6, 0x90, 0x83 },
	0x936A,	{ 0xE6, 0x90, 0x84 },
	0x936B,	{ 0xE6, 0x90, 0x86 },
	0x936C,	{ 0xE6, 0x90, 0x87 },
	0x936D,	{ 0xE6, 0x90, 0x88 },
	0x936E,	{ 0xE6, 0x90, 0x89 },
	0x936F,	{ 0xE6, 0x90, 0x8A },
	0x9370,	{ 0xE6, 0x90, 0x8D },
	0x9371,	{ 0xE6, 0x90, 0x8E },
	0x9372,	{ 0xE6, 0x90, 0x91 },
	0x9373,	{ 0xE6, 0x90, 0x92 },
	0x9374,	{ 0xE6, 0x90, 0x95 },
	0x9375,	{ 0xE6, 0x90, 0x96 },
	0x9376,	{ 0xE6, 0x90, 0x97 },
	0x9377,	{ 0xE6, 0x90, 0x98 },
	0x9378,	{ 0xE6, 0x90, 0x99 },
	0x9379,	{ 0xE6, 0x90, 0x9A },
	0x937A,	{ 0xE6, 0x90, 0x9D },
	0x937B,	{ 0xE6, 0x90, 0x9F },
	0x937C,	{ 0xE6, 0x90, 0xA2 },
	0x937D,	{ 0xE6, 0x90, 0xA3 },
	0x937E,	{ 0xE6, 0x90, 0xA4 },
	0x9380,	{ 0xE6, 0x90, 0xA5 },
	0x9381,	{ 0xE6, 0x90, 0xA7 },
	0x9382,	{ 0xE6, 0x90, 0xA8 },
	0x9383,	{ 0xE6, 0x90, 0xA9 },
	0x9384,	{ 0xE6, 0x90, 0xAB },
	0x9385,	{ 0xE6, 0x90, 0xAE },
	0x9386,	{ 0xE6, 0x90, 0xAF },
	0x9387,	{ 0xE6, 0x90, 0xB0 },
	0x9388,	{ 0xE6, 0x90, 0xB1 },
	0x9389,	{ 0xE6, 0x90, 0xB2 },
	0x938A,	{ 0xE6, 0x90, 0xB3 },
	0x938B,	{ 0xE6, 0x90, 0xB5 },
	0x938C,	{ 0xE6, 0x90, 0xB6 },
	0x938D,	{ 0xE6, 0x90, 0xB7 },
	0x938E,	{ 0xE6, 0x90, 0xB8 },
	0x938F,	{ 0xE6, 0x90, 0xB9 },
	0x9390,	{ 0xE6, 0x90, 0xBB },
	0x9391,	{ 0xE6, 0x90, 0xBC },
	0x9392,	{ 0xE6, 0x90, 0xBE },
	0x9393,	{ 0xE6, 0x91, 0x80 },
	0x9394,	{ 0xE6, 0x91, 0x82 },
	0x9395,	{ 0xE6, 0x91, 0x83 },
	0x9396,	{ 0xE6, 0x91, 0x89 },
	0x9397,	{ 0xE6, 0x91, 0x8B },
	0x9398,	{ 0xE6, 0x91, 0x8C },
	0x9399,	{ 0xE6, 0x91, 0x8D },
	0x939A,	{ 0xE6, 0x91, 0x8E },
	0x939B,	{ 0xE6, 0x91, 0x8F },
	0x939C,	{ 0xE6, 0x91, 0x90 },
	0x939D,	{ 0xE6, 0x91, 0x91 },
	0x939E,	{ 0xE6, 0x91, 0x93 },
	0x939F,	{ 0xE6, 0x91, 0x95 },
	0x93A0,	{ 0xE6, 0x91, 0x96 },
	0x93A1,	{ 0xE6, 0x91, 0x97 },
	0x93A2,	{ 0xE6, 0x91, 0x99 },
	0x93A3,	{ 0xE6, 0x91, 0x9A },
	0x93A4,	{ 0xE6, 0x91, 0x9B },
	0x93A5,	{ 0xE6, 0x91, 0x9C },
	0x93A6,	{ 0xE6, 0x91, 0x9D },
	0x93A7,	{ 0xE6, 0x91, 0x9F },
	0x93A8,	{ 0xE6, 0x91, 0xA0 },
	0x93A9,	{ 0xE6, 0x91, 0xA1 },
	0x93AA,	{ 0xE6, 0x91, 0xA2 },
	0x93AB,	{ 0xE6, 0x91, 0xA3 },
	0x93AC,	{ 0xE6, 0x91, 0xA4 },
	0x93AD,	{ 0xE6, 0x91, 0xA5 },
	0x93AE,	{ 0xE6, 0x91, 0xA6 },
	0x93AF,	{ 0xE6, 0x91, 0xA8 },
	0x93B0,	{ 0xE6, 0x91, 0xAA },
	0x93B1,	{ 0xE6, 0x91, 0xAB },
	0x93B2,	{ 0xE6, 0x91, 0xAC },
	0x93B3,	{ 0xE6, 0x91, 0xAE },
	0x93B4,	{ 0xE6, 0x91, 0xAF },
	0x93B5,	{ 0xE6, 0x91, 0xB0 },
	0x93B6,	{ 0xE6, 0x91, 0xB1 },
	0x93B7,	{ 0xE6, 0x91, 0xB2 },
	0x93B8,	{ 0xE6, 0x91, 0xB3 },
	0x93B9,	{ 0xE6, 0x91, 0xB4 },
	0x93BA,	{ 0xE6, 0x91, 0xB5 },
	0x93BB,	{ 0xE6, 0x91, 0xB6 },
	0x93BC,	{ 0xE6, 0x91, 0xB7 },
	0x93BD,	{ 0xE6, 0x91, 0xBB },
	0x93BE,	{ 0xE6, 0x91, 0xBC },
	0x93BF,	{ 0xE6, 0x91, 0xBD },
	0x93C0,	{ 0xE6, 0x91, 0xBE },
	0x93C1,	{ 0xE6, 0x91, 0xBF },
	0x93C2,	{ 0xE6, 0x92, 0x80 },
	0x93C3,	{ 0xE6, 0x92, 0x81 },
	0x93C4,	{ 0xE6, 0x92, 0x83 },
	0x93C5,	{ 0xE6, 0x92, 0x86 },
	0x93C6,	{ 0xE6, 0x92, 0x88 },
	0x93C7,	{ 0xE6, 0x92, 0x89 },
	0x93C8,	{ 0xE6, 0x92, 0x8A },
	0x93C9,	{ 0xE6, 0x92, 0x8B },
	0x93CA,	{ 0xE6, 0x92, 0x8C },
	0x93CB,	{ 0xE6, 0x92, 0x8D },
	0x93CC,	{ 0xE6, 0x92, 0x8E },
	0x93CD,	{ 0xE6, 0x92, 0x8F },
	0x93CE,	{ 0xE6, 0x92, 0x90 },
	0x93CF,	{ 0xE6, 0x92, 0x93 },
	0x93D0,	{ 0xE6, 0x92, 0x94 },
	0x93D1,	{ 0xE6, 0x92, 0x97 },
	0x93D2,	{ 0xE6, 0x92, 0x98 },
	0x93D3,	{ 0xE6, 0x92, 0x9A },
	0x93D4,	{ 0xE6, 0x92, 0x9B },
	0x93D5,	{ 0xE6, 0x92, 0x9C },
	0x93D6,	{ 0xE6, 0x92, 0x9D },
	0x93D7,	{ 0xE6, 0x92, 0x9F },
	0x93D8,	{ 0xE6, 0x92, 0xA0 },
	0x93D9,	{ 0xE6, 0x92, 0xA1 },
	0x93DA,	{ 0xE6, 0x92, 0xA2 },
	0x93DB,	{ 0xE6, 0x92, 0xA3 },
	0x93DC,	{ 0xE6, 0x92, 0xA5 },
	0x93DD,	{ 0xE6, 0x92, 0xA6 },
	0x93DE,	{ 0xE6, 0x92, 0xA7 },
	0x93DF,	{ 0xE6, 0x92, 0xA8 },
	0x93E0,	{ 0xE6, 0x92, 0xAA },
	0x93E1,	{ 0xE6, 0x92, 0xAB },
	0x93E2,	{ 0xE6, 0x92, 0xAF },
	0x93E3,	{ 0xE6, 0x92, 0xB1 },
	0x93E4,	{ 0xE6, 0x92, 0xB2 },
	0x93E5,	{ 0xE6, 0x92, 0xB3 },
	0x93E6,	{ 0xE6, 0x92, 0xB4 },
	0x93E7,	{ 0xE6, 0x92, 0xB6 },
	0x93E8,	{ 0xE6, 0x92, 0xB9 },
	0x93E9,	{ 0xE6, 0x92, 0xBB },
	0x93EA,	{ 0xE6, 0x92, 0xBD },
	0x93EB,	{ 0xE6, 0x92, 0xBE },
	0x93EC,	{ 0xE6, 0x92, 0xBF },
	0x93ED,	{ 0xE6, 0x93, 0x81 },
	0x93EE,	{ 0xE6, 0x93, 0x83 },
	0x93EF,	{ 0xE6, 0x93, 0x84 },
	0x93F0,	{ 0xE6, 0x93, 0x86 },
	0x93F1,	{ 0xE6, 0x93, 0x87 },
	0x93F2,	{ 0xE6, 0x93, 0x88 },
	0x93F3,	{ 0xE6, 0x93, 0x89 },
	0x93F4,	{ 0xE6, 0x93, 0x8A },
	0x93F5,	{ 0xE6, 0x93, 0x8B },
	0x93F6,	{ 0xE6, 0x93, 0x8C },
	0x93F7,	{ 0xE6, 0x93, 0x8F },
	0x93F8,	{ 0xE6, 0x93, 0x91 },
	0x93F9,	{ 0xE6, 0x93, 0x93 },
	0x93FA,	{ 0xE6, 0x93, 0x94 },
	0x93FB,	{ 0xE6, 0x93, 0x95 },
	0x93FC,	{ 0xE6, 0x93, 0x96 },
	0x93FD,	{ 0xE6, 0x93, 0x99 },
	0x93FE,	{ 0xE6, 0x93, 0x9A },
	0x9440,	{ 0xE6, 0x93, 0x9B },
	0x9441,	{ 0xE6, 0x93, 0x9C },
	0x9442,	{ 0xE6, 0x93, 0x9D },
	0x9443,	{ 0xE6, 0x93, 0x9F },
	0x9444,	{ 0xE6, 0x93, 0xA0 },
	0x9445,	{ 0xE6, 0x93, 0xA1 },
	0x9446,	{ 0xE6, 0x93, 0xA3 },
	0x9447,	{ 0xE6, 0x93, 0xA5 },
	0x9448,	{ 0xE6, 0x93, 0xA7 },
	0x9449,	{ 0xE6, 0x93, 0xA8 },
	0x944A,	{ 0xE6, 0x93, 0xA9 },
	0x944B,	{ 0xE6, 0x93, 0xAA },
	0x944C,	{ 0xE6, 0x93, 0xAB },
	0x944D,	{ 0xE6, 0x93, 0xAC },
	0x944E,	{ 0xE6, 0x93, 0xAD },
	0x944F,	{ 0xE6, 0x93, 0xAE },
	0x9450,	{ 0xE6, 0x93, 0xAF },
	0x9451,	{ 0xE6, 0x93, 0xB0 },
	0x9452,	{ 0xE6, 0x93, 0xB1 },
	0x9453,	{ 0xE6, 0x93, 0xB2 },
	0x9454,	{ 0xE6, 0x93, 0xB3 },
	0x9455,	{ 0xE6, 0x93, 0xB4 },
	0x9456,	{ 0xE6, 0x93, 0xB5 },
	0x9457,	{ 0xE6, 0x93, 0xB6 },
	0x9458,	{ 0xE6, 0x93, 0xB7 },
	0x9459,	{ 0xE6, 0x93, 0xB8 },
	0x945A,	{ 0xE6, 0x93, 0xB9 },
	0x945B,	{ 0xE6, 0x93, 0xBA },
	0x945C,	{ 0xE6, 0x93, 0xBB },
	0x945D,	{ 0xE6, 0x93, 0xBC },
	0x945E,	{ 0xE6, 0x93, 0xBD },
	0x945F,	{ 0xE6, 0x93, 0xBE },
	0x9460,	{ 0xE6, 0x93, 0xBF },
	0x9461,	{ 0xE6, 0x94, 0x81 },
	0x9462,	{ 0xE6, 0x94, 0x82 },
	0x9463,	{ 0xE6, 0x94, 0x83 },
	0x9464,	{ 0xE6, 0x94, 0x84 },
	0x9465,	{ 0xE6, 0x94, 0x85 },
	0x9466,	{ 0xE6, 0x94, 0x86 },
	0x9467,	{ 0xE6, 0x94, 0x87 },
	0x9468,	{ 0xE6, 0x94, 0x88 },
	0x9469,	{ 0xE6, 0x94, 0x8A },
	0x946A,	{ 0xE6, 0x94, 0x8B },
	0x946B,	{ 0xE6, 0x94, 0x8C },
	0x946C,	{ 0xE6, 0x94, 0x8D },
	0x946D,	{ 0xE6, 0x94, 0x8E },
	0x946E,	{ 0xE6, 0x94, 0x8F },
	0x946F,	{ 0xE6, 0x94, 0x90 },
	0x9470,	{ 0xE6, 0x94, 0x91 },
	0x9471,	{ 0xE6, 0x94, 0x93 },
	0x9472,	{ 0xE6, 0x94, 0x94 },
	0x9473,	{ 0xE6, 0x94, 0x95 },
	0x9474,	{ 0xE6, 0x94, 0x96 },
	0x9475,	{ 0xE6, 0x94, 0x97 },
	0x9476,	{ 0xE6, 0x94, 0x99 },
	0x9477,	{ 0xE6, 0x94, 0x9A },
	0x9478,	{ 0xE6, 0x94, 0x9B },
	0x9479,	{ 0xE6, 0x94, 0x9C },
	0x947A,	{ 0xE6, 0x94, 0x9D },
	0x947B,	{ 0xE6, 0x94, 0x9E },
	0x947C,	{ 0xE6, 0x94, 0x9F },
	0x947D,	{ 0xE6, 0x94, 0xA0 },
	0x947E,	{ 0xE6, 0x94, 0xA1 },
	0x9480,	{ 0xE6, 0x94, 0xA2 },
	0x9481,	{ 0xE6, 0x94, 0xA3 },
	0x9482,	{ 0xE6, 0x94, 0xA4 },
	0x9483,	{ 0xE6, 0x94, 0xA6 },
	0x9484,	{ 0xE6, 0x94, 0xA7 },
	0x9485,	{ 0xE6, 0x94, 0xA8 },
	0x9486,	{ 0xE6, 0x94, 0xA9 },
	0x9487,	{ 0xE6, 0x94, 0xAA },
	0x9488,	{ 0xE6, 0x94, 0xAC },
	0x9489,	{ 0xE6, 0x94, 0xAD },
	0x948A,	{ 0xE6, 0x94, 0xB0 },
	0x948B,	{ 0xE6, 0x94, 0xB1 },
	0x948C,	{ 0xE6, 0x94, 0xB2 },
	0x948D,	{ 0xE6, 0x94, 0xB3 },
	0x948E,	{ 0xE6, 0x94, 0xB7 },
	0x948F,	{ 0xE6, 0x94, 0xBA },
	0x9490,	{ 0xE6, 0x94, 0xBC },
	0x9491,	{ 0xE6, 0x94, 0xBD },
	0x9492,	{ 0xE6, 0x95, 0x80 },
	0x9493,	{ 0xE6, 0x95, 0x81 },
	0x9494,	{ 0xE6, 0x95, 0x82 },
	0x9495,	{ 0xE6, 0x95, 0x83 },
	0x9496,	{ 0xE6, 0x95, 0x84 },
	0x9497,	{ 0xE6, 0x95, 0x86 },
	0x9498,	{ 0xE6, 0x95, 0x87 },
	0x9499,	{ 0xE6, 0x95, 0x8A },
	0x949A,	{ 0xE6, 0x95, 0x8B },
	0x949B,	{ 0xE6, 0x95, 0x8D },
	0x949C,	{ 0xE6, 0x95, 0x8E },
	0x949D,	{ 0xE6, 0x95, 0x90 },
	0x949E,	{ 0xE6, 0x95, 0x92 },
	0x949F,	{ 0xE6, 0x95, 0x93 },
	0x94A0,	{ 0xE6, 0x95, 0x94 },
	0x94A1,	{ 0xE6, 0x95, 0x97 },
	0x94A2,	{ 0xE6, 0x95, 0x98 },
	0x94A3,	{ 0xE6, 0x95, 0x9A },
	0x94A4,	{ 0xE6, 0x95, 0x9C },
	0x94A5,	{ 0xE6, 0x95, 0x9F },
	0x94A6,	{ 0xE6, 0x95, 0xA0 },
	0x94A7,	{ 0xE6, 0x95, 0xA1 },
	0x94A8,	{ 0xE6, 0x95, 0xA4 },
	0x94A9,	{ 0xE6, 0x95, 0xA5 },
	0x94AA,	{ 0xE6, 0x95, 0xA7 },
	0x94AB,	{ 0xE6, 0x95, 0xA8 },
	0x94AC,	{ 0xE6, 0x95, 0xA9 },
	0x94AD,	{ 0xE6, 0x95, 0xAA },
	0x94AE,	{ 0xE6, 0x95, 0xAD },
	0x94AF,	{ 0xE6, 0x95, 0xAE },
	0x94B0,	{ 0xE6, 0x95, 0xAF },
	0x94B1,	{ 0xE6, 0x95, 0xB1 },
	0x94B2,	{ 0xE6, 0x95, 0xB3 },
	0x94B3,	{ 0xE6, 0x95, 0xB5 },
	0x94B4,	{ 0xE6, 0x95, 0xB6 },
	0x94B5,	{ 0xE6, 0x95, 0xB8 },
	0x94B6,	{ 0xE6, 0x95, 0xB9 },
	0x94B7,	{ 0xE6, 0x95, 0xBA },
	0x94B8,	{ 0xE6, 0x95, 0xBB },
	0x94B9,	{ 0xE6, 0x95, 0xBC },
	0x94BA,	{ 0xE6, 0x95, 0xBD },
	0x94BB,	{ 0xE6, 0x95, 0xBE },
	0x94BC,	{ 0xE6, 0x95, 0xBF },
	0x94BD,	{ 0xE6, 0x96, 0x80 },
	0x94BE,	{ 0xE6, 0x96, 0x81 },
	0x94BF,	{ 0xE6, 0x96, 0x82 },
	0x94C0,	{ 0xE6, 0x96, 0x83 },
	0x94C1,	{ 0xE6, 0x96, 0x84 },
	0x94C2,	{ 0xE6, 0x96, 0x85 },
	0x94C3,	{ 0xE6, 0x96, 0x86 },
	0x94C4,	{ 0xE6, 0x96, 0x88 },
	0x94C5,	{ 0xE6, 0x96, 0x89 },
	0x94C6,	{ 0xE6, 0x96, 0x8A },
	0x94C7,	{ 0xE6, 0x96, 0x8D },
	0x94C8,	{ 0xE6, 0x96, 0x8E },
	0x94C9,	{ 0xE6, 0x96, 0x8F },
	0x94CA,	{ 0xE6, 0x96, 0x92 },
	0x94CB,	{ 0xE6, 0x96, 0x94 },
	0x94CC,	{ 0xE6, 0x96, 0x95 },
	0x94CD,	{ 0xE6, 0x96, 0x96 },
	0x94CE,	{ 0xE6, 0x96, 0x98 },
	0x94CF,	{ 0xE6, 0x96, 0x9A },
	0x94D0,	{ 0xE6, 0x96, 0x9D },
	0x94D1,	{ 0xE6, 0x96, 0x9E },
	0x94D2,	{ 0xE6, 0x96, 0xA0 },
	0x94D3,	{ 0xE6, 0x96, 0xA2 },
	0x94D4,	{ 0xE6, 0x96, 0xA3 },
	0x94D5,	{ 0xE6, 0x96, 0xA6 },
	0x94D6,	{ 0xE6, 0x96, 0xA8 },
	0x94D7,	{ 0xE6, 0x96, 0xAA },
	0x94D8,	{ 0xE6, 0x96, 0xAC },
	0x94D9,	{ 0xE6, 0x96, 0xAE },
	0x94DA,	{ 0xE6, 0x96, 0xB1 },
	0x94DB,	{ 0xE6, 0x96, 0xB2 },
	0x94DC,	{ 0xE6, 0x96, 0xB3 },
	0x94DD,	{ 0xE6, 0x96, 0xB4 },
	0x94DE,	{ 0xE6, 0x96, 0xB5 },
	0x94DF,	{ 0xE6, 0x96, 0xB6 },
	0x94E0,	{ 0xE6, 0x96, 0xB7 },
	0x94E1,	{ 0xE6, 0x96, 0xB8 },
	0x94E2,	{ 0xE6, 0x96, 0xBA },
	0x94E3,	{ 0xE6, 0x96, 0xBB },
	0x94E4,	{ 0xE6, 0x96, 0xBE },
	0x94E5,	{ 0xE6, 0x96, 0xBF },
	0x94E6,	{ 0xE6, 0x97, 0x80 },
	0x94E7,	{ 0xE6, 0x97, 0x82 },
	0x94E8,	{ 0xE6, 0x97, 0x87 },
	0x94E9,	{ 0xE6, 0x97, 0x88 },
	0x94EA,	{ 0xE6, 0x97, 0x89 },
	0x94EB,	{ 0xE6, 0x97, 0x8A },
	0x94EC,	{ 0xE6, 0x97, 0x8D },
	0x94ED,	{ 0xE6, 0x97, 0x90 },
	0x94EE,	{ 0xE6, 0x97, 0x91 },
	0x94EF,	{ 0xE6, 0x97, 0x93 },
	0x94F0,	{ 0xE6, 0x97, 0x94 },
	0x94F1,	{ 0xE6, 0x97, 0x95 },
	0x94F2,	{ 0xE6, 0x97, 0x98 },
	0x94F3,	{ 0xE6, 0x97, 0x99 },
	0x94F4,	{ 0xE6, 0x97, 0x9A },
	0x94F5,	{ 0xE6, 0x97, 0x9B },
	0x94F6,	{ 0xE6, 0x97, 0x9C },
	0x94F7,	{ 0xE6, 0x97, 0x9D },
	0x94F8,	{ 0xE6, 0x97, 0x9E },
	0x94F9,	{ 0xE6, 0x97, 0x9F },
	0x94FA,	{ 0xE6, 0x97, 0xA1 },
	0x94FB,	{ 0xE6, 0x97, 0xA3 },
	0x94FC,	{ 0xE6, 0x97, 0xA4 },
	0x94FD,	{ 0xE6, 0x97, 0xAA },
	0x94FE,	{ 0xE6, 0x97, 0xAB },
	0x9540,	{ 0xE6, 0x97, 0xB2 },
	0x9541,	{ 0xE6, 0x97, 0xB3 },
	0x9542,	{ 0xE6, 0x97, 0xB4 },
	0x9543,	{ 0xE6, 0x97, 0xB5 },
	0x9544,	{ 0xE6, 0x97, 0xB8 },
	0x9545,	{ 0xE6, 0x97, 0xB9 },
	0x9546,	{ 0xE6, 0x97, 0xBB },
	0x9547,	{ 0xE6, 0x97, 0xBC },
	0x9548,	{ 0xE6, 0x97, 0xBD },
	0x9549,	{ 0xE6, 0x97, 0xBE },
	0x954A,	{ 0xE6, 0x97, 0xBF },
	0x954B,	{ 0xE6, 0x98, 0x81 },
	0x954C,	{ 0xE6, 0x98, 0x84 },
	0x954D,	{ 0xE6, 0x98, 0x85 },
	0x954E,	{ 0xE6, 0x98, 0x87 },
	0x954F,	{ 0xE6, 0x98, 0x88 },
	0x9550,	{ 0xE6, 0x98, 0x89 },
	0x9551,	{ 0xE6, 0x98, 0x8B },
	0x9552,	{ 0xE6, 0x98, 0x8D },
	0x9553,	{ 0xE6, 0x98, 0x90 },
	0x9554,	{ 0xE6, 0x98, 0x91 },
	0x9555,	{ 0xE6, 0x98, 0x92 },
	0x9556,	{ 0xE6, 0x98, 0x96 },
	0x9557,	{ 0xE6, 0x98, 0x97 },
	0x9558,	{ 0xE6, 0x98, 0x98 },
	0x9559,	{ 0xE6, 0x98, 0x9A },
	0x955A,	{ 0xE6, 0x98, 0x9B },
	0x955B,	{ 0xE6, 0x98, 0x9C },
	0x955C,	{ 0xE6, 0x98, 0x9E },
	0x955D,	{ 0xE6, 0x98, 0xA1 },
	0x955E,	{ 0xE6, 0x98, 0xA2 },
	0x955F,	{ 0xE6, 0x98, 0xA3 },
	0x9560,	{ 0xE6, 0x98, 0xA4 },
	0x9561,	{ 0xE6, 0x98, 0xA6 },
	0x9562,	{ 0xE6, 0x98, 0xA9 },
	0x9563,	{ 0xE6, 0x98, 0xAA },
	0x9564,	{ 0xE6, 0x98, 0xAB },
	0x9565,	{ 0xE6, 0x98, 0xAC },
	0x9566,	{ 0xE6, 0x98, 0xAE },
	0x9567,	{ 0xE6, 0x98, 0xB0 },
	0x9568,	{ 0xE6, 0x98, 0xB2 },
	0x9569,	{ 0xE6, 0x98, 0xB3 },
	0x956A,	{ 0xE6, 0x98, 0xB7 },
	0x956B,	{ 0xE6, 0x98, 0xB8 },
	0x956C,	{ 0xE6, 0x98, 0xB9 },
	0x956D,	{ 0xE6, 0x98, 0xBA },
	0x956E,	{ 0xE6, 0x98, 0xBB },
	0x956F,	{ 0xE6, 0x98, 0xBD },
	0x9570,	{ 0xE6, 0x98, 0xBF },
	0x9571,	{ 0xE6, 0x99, 0x80 },
	0x9572,	{ 0xE6, 0x99, 0x82 },
	0x9573,	{ 0xE6, 0x99, 0x84 },
	0x9574,	{ 0xE6, 0x99, 0x85 },
	0x9575,	{ 0xE6, 0x99, 0x86 },
	0x9576,	{ 0xE6, 0x99, 0x87 },
	0x9577,	{ 0xE6, 0x99, 0x88 },
	0x9578,	{ 0xE6, 0x99, 0x89 },
	0x9579,	{ 0xE6, 0x99, 0x8A },
	0x957A,	{ 0xE6, 0x99, 0x8D },
	0x957B,	{ 0xE6, 0x99, 0x8E },
	0x957C,	{ 0xE6, 0x99, 0x90 },
	0x957D,	{ 0xE6, 0x99, 0x91 },
	0x957E,	{ 0xE6, 0x99, 0x98 },
	0x9580,	{ 0xE6, 0x99, 0x99 },
	0x9581,	{ 0xE6, 0x99, 0x9B },
	0x9582,	{ 0xE6, 0x99, 0x9C },
	0x9583,	{ 0xE6, 0x99, 0x9D },
	0x9584,	{ 0xE6, 0x99, 0x9E },
	0x9585,	{ 0xE6, 0x99, 0xA0 },
	0x9586,	{ 0xE6, 0x99, 0xA2 },
	0x9587,	{ 0xE6, 0x99, 0xA3 },
	0x9588,	{ 0xE6, 0x99, 0xA5 },
	0x9589,	{ 0xE6, 0x99, 0xA7 },
	0x958A,	{ 0xE6, 0x99, 0xA9 },
	0x958B,	{ 0xE6, 0x99, 0xAA },
	0x958C,	{ 0xE6, 0x99, 0xAB },
	0x958D,	{ 0xE6, 0x99, 0xAC },
	0x958E,	{ 0xE6, 0x99, 0xAD },
	0x958F,	{ 0xE6, 0x99, 0xB1 },
	0x9590,	{ 0xE6, 0x99, 0xB2 },
	0x9591,	{ 0xE6, 0x99, 0xB3 },
	0x9592,	{ 0xE6, 0x99, 0xB5 },
	0x9593,	{ 0xE6, 0x99, 0xB8 },
	0x9594,	{ 0xE6, 0x99, 0xB9 },
	0x9595,	{ 0xE6, 0x99, 0xBB },
	0x9596,	{ 0xE6, 0x99, 0xBC },
	0x9597,	{ 0xE6, 0x99, 0xBD },
	0x9598,	{ 0xE6, 0x99, 0xBF },
	0x9599,	{ 0xE6, 0x9A, 0x80 },
	0x959A,	{ 0xE6, 0x9A, 0x81 },
	0x959B,	{ 0xE6, 0x9A, 0x83 },
	0x959C,	{ 0xE6, 0x9A, 0x85 },
	0x959D,	{ 0xE6, 0x9A, 0x86 },
	0x959E,	{ 0xE6, 0x9A, 0x88 },
	0x959F,	{ 0xE6, 0x9A, 0x89 },
	0x95A0,	{ 0xE6, 0x9A, 0x8A },
	0x95A1,	{ 0xE6, 0x9A, 0x8B },
	0x95A2,	{ 0xE6, 0x9A, 0x8D },
	0x95A3,	{ 0xE6, 0x9A, 0x8E },
	0x95A4,	{ 0xE6, 0x9A, 0x8F },
	0x95A5,	{ 0xE6, 0x9A, 0x90 },
	0x95A6,	{ 0xE6, 0x9A, 0x92 },
	0x95A7,	{ 0xE6, 0x9A, 0x93 },
	0x95A8,	{ 0xE6, 0x9A, 0x94 },
	0x95A9,	{ 0xE6, 0x9A, 0x95 },
	0x95AA,	{ 0xE6, 0x9A, 0x98 },
	0x95AB,	{ 0xE6, 0x9A, 0x99 },
	0x95AC,	{ 0xE6, 0x9A, 0x9A },
	0x95AD,	{ 0xE6, 0x9A, 0x9B },
	0x95AE,	{ 0xE6, 0x9A, 0x9C },
	0x95AF,	{ 0xE6, 0x9A, 0x9E },
	0x95B0,	{ 0xE6, 0x9A, 0x9F },
	0x95B1,	{ 0xE6, 0x9A, 0xA0 },
	0x95B2,	{ 0xE6, 0x9A, 0xA1 },
	0x95B3,	{ 0xE6, 0x9A, 0xA2 },
	0x95B4,	{ 0xE6, 0x9A, 0xA3 },
	0x95B5,	{ 0xE6, 0x9A, 0xA4 },
	0x95B6,	{ 0xE6, 0x9A, 0xA5 },
	0x95B7,	{ 0xE6, 0x9A, 0xA6 },
	0x95B8,	{ 0xE6, 0x9A, 0xA9 },
	0x95B9,	{ 0xE6, 0x9A, 0xAA },
	0x95BA,	{ 0xE6, 0x9A, 0xAB },
	0x95BB,	{ 0xE6, 0x9A, 0xAC },
	0x95BC,	{ 0xE6, 0x9A, 0xAD },
	0x95BD,	{ 0xE6, 0x9A, 0xAF },
	0x95BE,	{ 0xE6, 0x9A, 0xB0 },
	0x95BF,	{ 0xE6, 0x9A, 0xB1 },
	0x95C0,	{ 0xE6, 0x9A, 0xB2 },
	0x95C1,	{ 0xE6, 0x9A, 0xB3 },
	0x95C2,	{ 0xE6, 0x9A, 0xB5 },
	0x95C3,	{ 0xE6, 0x9A, 0xB6 },
	0x95C4,	{ 0xE6, 0x9A, 0xB7 },
	0x95C5,	{ 0xE6, 0x9A, 0xB8 },
	0x95C6,	{ 0xE6, 0x9A, 0xBA },
	0x95C7,	{ 0xE6, 0x9A, 0xBB },
	0x95C8,	{ 0xE6, 0x9A, 0xBC },
	0x95C9,	{ 0xE6, 0x9A, 0xBD },
	0x95CA,	{ 0xE6, 0x9A, 0xBF },
	0x95CB,	{ 0xE6, 0x9B, 0x80 },
	0x95CC,	{ 0xE6, 0x9B, 0x81 },
	0x95CD,	{ 0xE6, 0x9B, 0x82 },
	0x95CE,	{ 0xE6, 0x9B, 0x83 },
	0x95CF,	{ 0xE6, 0x9B, 0x84 },
	0x95D0,	{ 0xE6, 0x9B, 0x85 },
	0x95D1,	{ 0xE6, 0x9B, 0x86 },
	0x95D2,	{ 0xE6, 0x9B, 0x87 },
	0x95D3,	{ 0xE6, 0x9B, 0x88 },
	0x95D4,	{ 0xE6, 0x9B, 0x89 },
	0x95D5,	{ 0xE6, 0x9B, 0x8A },
	0x95D6,	{ 0xE6, 0x9B, 0x8B },
	0x95D7,	{ 0xE6, 0x9B, 0x8C },
	0x95D8,	{ 0xE6, 0x9B, 0x8D },
	0x95D9,	{ 0xE6, 0x9B, 0x8E },
	0x95DA,	{ 0xE6, 0x9B, 0x8F },
	0x95DB,	{ 0xE6, 0x9B, 0x90 },
	0x95DC,	{ 0xE6, 0x9B, 0x91 },
	0x95DD,	{ 0xE6, 0x9B, 0x92 },
	0x95DE,	{ 0xE6, 0x9B, 0x93 },
	0x95DF,	{ 0xE6, 0x9B, 0x94 },
	0x95E0,	{ 0xE6, 0x9B, 0x95 },
	0x95E1,	{ 0xE6, 0x9B, 0x96 },
	0x95E2,	{ 0xE6, 0x9B, 0x97 },
	0x95E3,	{ 0xE6, 0x9B, 0x98 },
	0x95E4,	{ 0xE6, 0x9B, 0x9A },
	0x95E5,	{ 0xE6, 0x9B, 0x9E },
	0x95E6,	{ 0xE6, 0x9B, 0x9F },
	0x95E7,	{ 0xE6, 0x9B, 0xA0 },
	0x95E8,	{ 0xE6, 0x9B, 0xA1 },
	0x95E9,	{ 0xE6, 0x9B, 0xA2 },
	0x95EA,	{ 0xE6, 0x9B, 0xA3 },
	0x95EB,	{ 0xE6, 0x9B, 0xA4 },
	0x95EC,	{ 0xE6, 0x9B, 0xA5 },
	0x95ED,	{ 0xE6, 0x9B, 0xA7 },
	0x95EE,	{ 0xE6, 0x9B, 0xA8 },
	0x95EF,	{ 0xE6, 0x9B, 0xAA },
	0x95F0,	{ 0xE6, 0x9B, 0xAB },
	0x95F1,	{ 0xE6, 0x9B, 0xAC },
	0x95F2,	{ 0xE6, 0x9B, 0xAD },
	0x95F3,	{ 0xE6, 0x9B, 0xAE },
	0x95F4,	{ 0xE6, 0x9B, 0xAF },
	0x95F5,	{ 0xE6, 0x9B, 0xB1 },
	0x95F6,	{ 0xE6, 0x9B, 0xB5 },
	0x95F7,	{ 0xE6, 0x9B, 0xB6 },
	0x95F8,	{ 0xE6, 0x9B, 0xB8 },
	0x95F9,	{ 0xE6, 0x9B, 0xBA },
	0x95FA,	{ 0xE6, 0x9B, 0xBB },
	0x95FB,	{ 0xE6, 0x9B, 0xBD },
	0x95FC,	{ 0xE6, 0x9C, 0x81 },
	0x95FD,	{ 0xE6, 0x9C, 0x82 },
	0x95FE,	{ 0xE6, 0x9C, 0x83 },
	0x9640,	{ 0xE6, 0x9C, 0x84 },
	0x9641,	{ 0xE6, 0x9C, 0x85 },
	0x9642,	{ 0xE6, 0x9C, 0x86 },
	0x9643,	{ 0xE6, 0x9C, 0x87 },
	0x9644,	{ 0xE6, 0x9C, 0x8C },
	0x9645,	{ 0xE6, 0x9C, 0x8E },
	0x9646,	{ 0xE6, 0x9C, 0x8F },
	0x9647,	{ 0xE6, 0x9C, 0x91 },
	0x9648,	{ 0xE6, 0x9C, 0x92 },
	0x9649,	{ 0xE6, 0x9C, 0x93 },
	0x964A,	{ 0xE6, 0x9C, 0x96 },
	0x964B,	{ 0xE6, 0x9C, 0x98 },
	0x964C,	{ 0xE6, 0x9C, 0x99 },
	0x964D,	{ 0xE6, 0x9C, 0x9A },
	0x964E,	{ 0xE6, 0x9C, 0x9C },
	0x964F,	{ 0xE6, 0x9C, 0x9E },
	0x9650,	{ 0xE6, 0x9C, 0xA0 },
	0x9651,	{ 0xE6, 0x9C, 0xA1 },
	0x9652,	{ 0xE6, 0x9C, 0xA2 },
	0x9653,	{ 0xE6, 0x9C, 0xA3 },
	0x9654,	{ 0xE6, 0x9C, 0xA4 },
	0x9655,	{ 0xE6, 0x9C, 0xA5 },
	0x9656,	{ 0xE6, 0x9C, 0xA7 },
	0x9657,	{ 0xE6, 0x9C, 0xA9 },
	0x9658,	{ 0xE6, 0x9C, 0xAE },
	0x9659,	{ 0xE6, 0x9C, 0xB0 },
	0x965A,	{ 0xE6, 0x9C, 0xB2 },
	0x965B,	{ 0xE6, 0x9C, 0xB3 },
	0x965C,	{ 0xE6, 0x9C, 0xB6 },
	0x965D,	{ 0xE6, 0x9C, 0xB7 },
	0x965E,	{ 0xE6, 0x9C, 0xB8 },
	0x965F,	{ 0xE6, 0x9C, 0xB9 },
	0x9660,	{ 0xE6, 0x9C, 0xBB },
	0x9661,	{ 0xE6, 0x9C, 0xBC },
	0x9662,	{ 0xE6, 0x9C, 0xBE },
	0x9663,	{ 0xE6, 0x9C, 0xBF },
	0x9664,	{ 0xE6, 0x9D, 0x81 },
	0x9665,	{ 0xE6, 0x9D, 0x84 },
	0x9666,	{ 0xE6, 0x9D, 0x85 },
	0x9667,	{ 0xE6, 0x9D, 0x87 },
	0x9668,	{ 0xE6, 0x9D, 0x8A },
	0x9669,	{ 0xE6, 0x9D, 0x8B },
	0x966A,	{ 0xE6, 0x9D, 0x8D },
	0x966B,	{ 0xE6, 0x9D, 0x92 },
	0x966C,	{ 0xE6, 0x9D, 0x94 },
	0x966D,	{ 0xE6, 0x9D, 0x95 },
	0x966E,	{ 0xE6, 0x9D, 0x97 },
	0x966F,	{ 0xE6, 0x9D, 0x98 },
	0x9670,	{ 0xE6, 0x9D, 0x99 },
	0x9671,	{ 0xE6, 0x9D, 0x9A },
	0x9672,	{ 0xE6, 0x9D, 0x9B },
	0x9673,	{ 0xE6, 0x9D, 0x9D },
	0x9674,	{ 0xE6, 0x9D, 0xA2 },
	0x9675,	{ 0xE6, 0x9D, 0xA3 },
	0x9676,	{ 0xE6, 0x9D, 0xA4 },
	0x9677,	{ 0xE6, 0x9D, 0xA6 },
	0x9678,	{ 0xE6, 0x9D, 0xA7 },
	0x9679,	{ 0xE6, 0x9D, 0xAB },
	0x967A,	{ 0xE6, 0x9D, 0xAC },
	0x967B,	{ 0xE6, 0x9D, 0xAE },
	0x967C,	{ 0xE6, 0x9D, 0xB1 },
	0x967D,	{ 0xE6, 0x9D, 0xB4 },
	0x967E,	{ 0xE6, 0x9D, 0xB6 },
	0x9680,	{ 0xE6, 0x9D, 0xB8 },
	0x9681,	{ 0xE6, 0x9D, 0xB9 },
	0x9682,	{ 0xE6, 0x9D, 0xBA },
	0x9683,	{ 0xE6, 0x9D, 0xBB },
	0x9684,	{ 0xE6, 0x9D, 0xBD },
	0x9685,	{ 0xE6, 0x9E, 0x80 },
	0x9686,	{ 0xE6, 0x9E, 0x82 },
	0x9687,	{ 0xE6, 0x9E, 0x83 },
	0x9688,	{ 0xE6, 0x9E, 0x85 },
	0x9689,	{ 0xE6, 0x9E, 0x86 },
	0x968A,	{ 0xE6, 0x9E, 0x88 },
	0x968B,	{ 0xE6, 0x9E, 0x8A },
	0x968C,	{ 0xE6, 0x9E, 0x8C },
	0x968D,	{ 0xE6, 0x9E, 0x8D },
	0x968E,	{ 0xE6, 0x9E, 0x8E },
	0x968F,	{ 0xE6, 0x9E, 0x8F },
	0x9690,	{ 0xE6, 0x9E, 0x91 },
	0x9691,	{ 0xE6, 0x9E, 0x92 },
	0x9692,	{ 0xE6, 0x9E, 0x93 },
	0x9693,	{ 0xE6, 0x9E, 0x94 },
	0x9694,	{ 0xE6, 0x9E, 0x96 },
	0x9695,	{ 0xE6, 0x9E, 0x99 },
	0x9696,	{ 0xE6, 0x9E, 0x9B },
	0x9697,	{ 0xE6, 0x9E, 0x9F },
	0x9698,	{ 0xE6, 0x9E, 0xA0 },
	0x9699,	{ 0xE6, 0x9E, 0xA1 },
	0x969A,	{ 0xE6, 0x9E, 0xA4 },
	0x969B,	{ 0xE6, 0x9E, 0xA6 },
	0x969C,	{ 0xE6, 0x9E, 0xA9 },
	0x969D,	{ 0xE6, 0x9E, 0xAC },
	0x969E,	{ 0xE6, 0x9E, 0xAE },
	0x969F,	{ 0xE6, 0x9E, 0xB1 },
	0x96A0,	{ 0xE6, 0x9E, 0xB2 },
	0x96A1,	{ 0xE6, 0x9E, 0xB4 },
	0x96A2,	{ 0xE6, 0x9E, 0xB9 },
	0x96A3,	{ 0xE6, 0x9E, 0xBA },
	0x96A4,	{ 0xE6, 0x9E, 0xBB },
	0x96A5,	{ 0xE6, 0x9E, 0xBC },
	0x96A6,	{ 0xE6, 0x9E, 0xBD },
	0x96A7,	{ 0xE6, 0x9E, 0xBE },
	0x96A8,	{ 0xE6, 0x9E, 0xBF },
	0x96A9,	{ 0xE6, 0x9F, 0x80 },
	0x96AA,	{ 0xE6, 0x9F, 0x82 },
	0x96AB,	{ 0xE6, 0x9F, 0x85 },
	0x96AC,	{ 0xE6, 0x9F, 0x86 },
	0x96AD,	{ 0xE6, 0x9F, 0x87 },
	0x96AE,	{ 0xE6, 0x9F, 0x88 },
	0x96AF,	{ 0xE6, 0x9F, 0x89 },
	0x96B0,	{ 0xE6, 0x9F, 0x8A },
	0x96B1,	{ 0xE6, 0x9F, 0x8B },
	0x96B2,	{ 0xE6, 0x9F, 0x8C },
	0x96B3,	{ 0xE6, 0x9F, 0x8D },
	0x96B4,	{ 0xE6, 0x9F, 0x8E },
	0x96B5,	{ 0xE6, 0x9F, 0x95 },
	0x96B6,	{ 0xE6, 0x9F, 0x96 },
	0x96B7,	{ 0xE6, 0x9F, 0x97 },
	0x96B8,	{ 0xE6, 0x9F, 0x9B },
	0x96B9,	{ 0xE6, 0x9F, 0x9F },
	0x96BA,	{ 0xE6, 0x9F, 0xA1 },
	0x96BB,	{ 0xE6, 0x9F, 0xA3 },
	0x96BC,	{ 0xE6, 0x9F, 0xA4 },
	0x96BD,	{ 0xE6, 0x9F, 0xA6 },
	0x96BE,	{ 0xE6, 0x9F, 0xA7 },
	0x96BF,	{ 0xE6, 0x9F, 0xA8 },
	0x96C0,	{ 0xE6, 0x9F, 0xAA },
	0x96C1,	{ 0xE6, 0x9F, 0xAB },
	0x96C2,	{ 0xE6, 0x9F, 0xAD },
	0x96C3,	{ 0xE6, 0x9F, 0xAE },
	0x96C4,	{ 0xE6, 0x9F, 0xB2 },
	0x96C5,	{ 0xE6, 0x9F, 0xB5 },
	0x96C6,	{ 0xE6, 0x9F, 0xB6 },
	0x96C7,	{ 0xE6, 0x9F, 0xB7 },
	0x96C8,	{ 0xE6, 0x9F, 0xB8 },
	0x96C9,	{ 0xE6, 0x9F, 0xB9 },
	0x96CA,	{ 0xE6, 0x9F, 0xBA },
	0x96CB,	{ 0xE6, 0x9F, 0xBB },
	0x96CC,	{ 0xE6, 0x9F, 0xBC },
	0x96CD,	{ 0xE6, 0x9F, 0xBE },
	0x96CE,	{ 0xE6, 0xA0, 0x81 },
	0x96CF,	{ 0xE6, 0xA0, 0x82 },
	0x96D0,	{ 0xE6, 0xA0, 0x83 },
	0x96D1,	{ 0xE6, 0xA0, 0x84 },
	0x96D2,	{ 0xE6, 0xA0, 0x86 },
	0x96D3,	{ 0xE6, 0xA0, 0x8D },
	0x96D4,	{ 0xE6, 0xA0, 0x90 },
	0x96D5,	{ 0xE6, 0xA0, 0x92 },
	0x96D6,	{ 0xE6, 0xA0, 0x94 },
	0x96D7,	{ 0xE6, 0xA0, 0x95 },
	0x96D8,	{ 0xE6, 0xA0, 0x98 },
	0x96D9,	{ 0xE6, 0xA0, 0x99 },
	0x96DA,	{ 0xE6, 0xA0, 0x9A },
	0x96DB,	{ 0xE6, 0xA0, 0x9B },
	0x96DC,	{ 0xE6, 0xA0, 0x9C },
	0x96DD,	{ 0xE6, 0xA0, 0x9E },
	0x96DE,	{ 0xE6, 0xA0, 0x9F },
	0x96DF,	{ 0xE6, 0xA0, 0xA0 },
	0x96E0,	{ 0xE6, 0xA0, 0xA2 },
	0x96E1,	{ 0xE6, 0xA0, 0xA3 },
	0x96E2,	{ 0xE6, 0xA0, 0xA4 },
	0x96E3,	{ 0xE6, 0xA0, 0xA5 },
	0x96E4,	{ 0xE6, 0xA0, 0xA6 },
	0x96E5,	{ 0xE6, 0xA0, 0xA7 },
	0x96E6,	{ 0xE6, 0xA0, 0xA8 },
	0x96E7,	{ 0xE6, 0xA0, 0xAB },
	0x96E8,	{ 0xE6, 0xA0, 0xAC },
	0x96E9,	{ 0xE6, 0xA0, 0xAD },
	0x96EA,	{ 0xE6, 0xA0, 0xAE },
	0x96EB,	{ 0xE6, 0xA0, 0xAF },
	0x96EC,	{ 0xE6, 0xA0, 0xB0 },
	0x96ED,	{ 0xE6, 0xA0, 0xB1 },
	0x96EE,	{ 0xE6, 0xA0, 0xB4 },
	0x96EF,	{ 0xE6, 0xA0, 0xB5 },
	0x96F0,	{ 0xE6, 0xA0, 0xB6 },
	0x96F1,	{ 0xE6, 0xA0, 0xBA },
	0x96F2,	{ 0xE6, 0xA0, 0xBB },
	0x96F3,	{ 0xE6, 0xA0, 0xBF },
	0x96F4,	{ 0xE6, 0xA1, 0x87 },
	0x96F5,	{ 0xE6, 0xA1, 0x8B },
	0x96F6,	{ 0xE6, 0xA1, 0x8D },
	0x96F7,	{ 0xE6, 0xA1, 0x8F },
	0x96F8,	{ 0xE6, 0xA1, 0x92 },
	0x96F9,	{ 0xE6, 0xA1, 0x96 },
	0x96FA,	{ 0xE6, 0xA1, 0x97 },
	0x96FB,	{ 0xE6, 0xA1, 0x98 },
	0x96FC,	{ 0xE6, 0xA1, 0x99 },
	0x96FD,	{ 0xE6, 0xA1, 0x9A },
	0x96FE,	{ 0xE6, 0xA1, 0x9B },
	0x9740,	{ 0xE6, 0xA1, 0x9C },
	0x9741,	{ 0xE6, 0xA1, 0x9D },
	0x9742,	{ 0xE6, 0xA1, 0x9E },
	0x9743,	{ 0xE6, 0xA1, 0x9F },
	0x9744,	{ 0xE6, 0xA1, 0xAA },
	0x9745,	{ 0xE6, 0xA1, 0xAC },
	0x9746,	{ 0xE6, 0xA1, 0xAD },
	0x9747,	{ 0xE6, 0xA1, 0xAE },
	0x9748,	{ 0xE6, 0xA1, 0xAF },
	0x9749,	{ 0xE6, 0xA1, 0xB0 },
	0x974A,	{ 0xE6, 0xA1, 0xB1 },
	0x974B,	{ 0xE6, 0xA1, 0xB2 },
	0x974C,	{ 0xE6, 0xA1, 0xB3 },
	0x974D,	{ 0xE6, 0xA1, 0xB5 },
	0x974E,	{ 0xE6, 0xA1, 0xB8 },
	0x974F,	{ 0xE6, 0xA1, 0xB9 },
	0x9750,	{ 0xE6, 0xA1, 0xBA },
	0x9751,	{ 0xE6, 0xA1, 0xBB },
	0x9752,	{ 0xE6, 0xA1, 0xBC },
	0x9753,	{ 0xE6, 0xA1, 0xBD },
	0x9754,	{ 0xE6, 0xA1, 0xBE },
	0x9755,	{ 0xE6, 0xA1, 0xBF },
	0x9756,	{ 0xE6, 0xA2, 0x80 },
	0x9757,	{ 0xE6, 0xA2, 0x82 },
	0x9758,	{ 0xE6, 0xA2, 0x84 },
	0x9759,	{ 0xE6, 0xA2, 0x87 },
	0x975A,	{ 0xE6, 0xA2, 0x88 },
	0x975B,	{ 0xE6, 0xA2, 0x89 },
	0x975C,	{ 0xE6, 0xA2, 0x8A },
	0x975D,	{ 0xE6, 0xA2, 0x8B },
	0x975E,	{ 0xE6, 0xA2, 0x8C },
	0x975F,	{ 0xE6, 0xA2, 0x8D },
	0x9760,	{ 0xE6, 0xA2, 0x8E },
	0x9761,	{ 0xE6, 0xA2, 0x90 },
	0x9762,	{ 0xE6, 0xA2, 0x91 },
	0x9763,	{ 0xE6, 0xA2, 0x92 },
	0x9764,	{ 0xE6, 0xA2, 0x94 },
	0x9765,	{ 0xE6, 0xA2, 0x95 },
	0x9766,	{ 0xE6, 0xA2, 0x96 },
	0x9767,	{ 0xE6, 0xA2, 0x98 },
	0x9768,	{ 0xE6, 0xA2, 0x99 },
	0x9769,	{ 0xE6, 0xA2, 0x9A },
	0x976A,	{ 0xE6, 0xA2, 0x9B },
	0x976B,	{ 0xE6, 0xA2, 0x9C },
	0x976C,	{ 0xE6, 0xA2, 0x9D },
	0x976D,	{ 0xE6, 0xA2, 0x9E },
	0x976E,	{ 0xE6, 0xA2, 0x9F },
	0x976F,	{ 0xE6, 0xA2, 0xA0 },
	0x9770,	{ 0xE6, 0xA2, 0xA1 },
	0x9771,	{ 0xE6, 0xA2, 0xA3 },
	0x9772,	{ 0xE6, 0xA2, 0xA4 },
	0x9773,	{ 0xE6, 0xA2, 0xA5 },
	0x9774,	{ 0xE6, 0xA2, 0xA9 },
	0x9775,	{ 0xE6, 0xA2, 0xAA },
	0x9776,	{ 0xE6, 0xA2, 0xAB },
	0x9777,	{ 0xE6, 0xA2, 0xAC },
	0x9778,	{ 0xE6, 0xA2, 0xAE },
	0x9779,	{ 0xE6, 0xA2, 0xB1 },
	0x977A,	{ 0xE6, 0xA2, 0xB2 },
	0x977B,	{ 0xE6, 0xA2, 0xB4 },
	0x977C,	{ 0xE6, 0xA2, 0xB6 },
	0x977D,	{ 0xE6, 0xA2, 0xB7 },
	0x977E,	{ 0xE6, 0xA2, 0xB8 },
	0x9780,	{ 0xE6, 0xA2, 0xB9 },
	0x9781,	{ 0xE6, 0xA2, 0xBA },
	0x9782,	{ 0xE6, 0xA2, 0xBB },
	0x9783,	{ 0xE6, 0xA2, 0xBC },
	0x9784,	{ 0xE6, 0xA2, 0xBD },
	0x9785,	{ 0xE6, 0xA2, 0xBE },
	0x9786,	{ 0xE6, 0xA2, 0xBF },
	0x9787,	{ 0xE6, 0xA3, 0x81 },
	0x9788,	{ 0xE6, 0xA3, 0x83 },
	0x9789,	{ 0xE6, 0xA3, 0x84 },
	0x978A,	{ 0xE6, 0xA3, 0x85 },
	0x978B,	{ 0xE6, 0xA3, 0x86 },
	0x978C,	{ 0xE6, 0xA3, 0x87 },
	0x978D,	{ 0xE6, 0xA3, 0x88 },
	0x978E,	{ 0xE6, 0xA3, 0x8A },
	0x978F,	{ 0xE6, 0xA3, 0x8C },
	0x9790,	{ 0xE6, 0xA3, 0x8E },
	0x9791,	{ 0xE6, 0xA3, 0x8F },
	0x9792,	{ 0xE6, 0xA3, 0x90 },
	0x9793,	{ 0xE6, 0xA3, 0x91 },
	0x9794,	{ 0xE6, 0xA3, 0x93 },
	0x9795,	{ 0xE6, 0xA3, 0x94 },
	0x9796,	{ 0xE6, 0xA3, 0x96 },
	0x9797,	{ 0xE6, 0xA3, 0x97 },
	0x9798,	{ 0xE6, 0xA3, 0x99 },
	0x9799,	{ 0xE6, 0xA3, 0x9B },
	0x979A,	{ 0xE6, 0xA3, 0x9C },
	0x979B,	{ 0xE6, 0xA3, 0x9D },
	0x979C,	{ 0xE6, 0xA3, 0x9E },
	0x979D,	{ 0xE6, 0xA3, 0x9F },
	0x979E,	{ 0xE6, 0xA3, 0xA1 },
	0x979F,	{ 0xE6, 0xA3, 0xA2 },
	0x97A0,	{ 0xE6, 0xA3, 0xA4 },
	0x97A1,	{ 0xE6, 0xA3, 0xA5 },
	0x97A2,	{ 0xE6, 0xA3, 0xA6 },
	0x97A3,	{ 0xE6, 0xA3, 0xA7 },
	0x97A4,	{ 0xE6, 0xA3, 0xA8 },
	0x97A5,	{ 0xE6, 0xA3, 0xA9 },
	0x97A6,	{ 0xE6, 0xA3, 0xAA },
	0x97A7,	{ 0xE6, 0xA3, 0xAB },
	0x97A8,	{ 0xE6, 0xA3, 0xAC },
	0x97A9,	{ 0xE6, 0xA3, 0xAD },
	0x97AA,	{ 0xE6, 0xA3, 0xAF },
	0x97AB,	{ 0xE6, 0xA3, 0xB2 },
	0x97AC,	{ 0xE6, 0xA3, 0xB3 },
	0x97AD,	{ 0xE6, 0xA3, 0xB4 },
	0x97AE,	{ 0xE6, 0xA3, 0xB6 },
	0x97AF,	{ 0xE6, 0xA3, 0xB7 },
	0x97B0,	{ 0xE6, 0xA3, 0xB8 },
	0x97B1,	{ 0xE6, 0xA3, 0xBB },
	0x97B2,	{ 0xE6, 0xA3, 0xBD },
	0x97B3,	{ 0xE6, 0xA3, 0xBE },
	0x97B4,	{ 0xE6, 0xA3, 0xBF },
	0x97B5,	{ 0xE6, 0xA4, 0x80 },
	0x97B6,	{ 0xE6, 0xA4, 0x82 },
	0x97B7,	{ 0xE6, 0xA4, 0x83 },
	0x97B8,	{ 0xE6, 0xA4, 0x84 },
	0x97B9,	{ 0xE6, 0xA4, 0x86 },
	0x97BA,	{ 0xE6, 0xA4, 0x87 },
	0x97BB,	{ 0xE6, 0xA4, 0x88 },
	0x97BC,	{ 0xE6, 0xA4, 0x89 },
	0x97BD,	{ 0xE6, 0xA4, 0x8A },
	0x97BE,	{ 0xE6, 0xA4, 0x8C },
	0x97BF,	{ 0xE6, 0xA4, 0x8F },
	0x97C0,	{ 0xE6, 0xA4, 0x91 },
	0x97C1,	{ 0xE6, 0xA4, 0x93 },
	0x97C2,	{ 0xE6, 0xA4, 0x94 },
	0x97C3,	{ 0xE6, 0xA4, 0x95 },
	0x97C4,	{ 0xE6, 0xA4, 0x96 },
	0x97C5,	{ 0xE6, 0xA4, 0x97 },
	0x97C6,	{ 0xE6, 0xA4, 0x98 },
	0x97C7,	{ 0xE6, 0xA4, 0x99 },
	0x97C8,	{ 0xE6, 0xA4, 0x9A },
	0x97C9,	{ 0xE6, 0xA4, 0x9B },
	0x97CA,	{ 0xE6, 0xA4, 0x9C },
	0x97CB,	{ 0xE6, 0xA4, 0x9D },
	0x97CC,	{ 0xE6, 0xA4, 0x9E },
	0x97CD,	{ 0xE6, 0xA4, 0xA1 },
	0x97CE,	{ 0xE6, 0xA4, 0xA2 },
	0x97CF,	{ 0xE6, 0xA4, 0xA3 },
	0x97D0,	{ 0xE6, 0xA4, 0xA5 },
	0x97D1,	{ 0xE6, 0xA4, 0xA6 },
	0x97D2,	{ 0xE6, 0xA4, 0xA7 },
	0x97D3,	{ 0xE6, 0xA4, 0xA8 },
	0x97D4,	{ 0xE6, 0xA4, 0xA9 },
	0x97D5,	{ 0xE6, 0xA4, 0xAA },
	0x97D6,	{ 0xE6, 0xA4, 0xAB },
	0x97D7,	{ 0xE6, 0xA4, 0xAC },
	0x97D8,	{ 0xE6, 0xA4, 0xAE },
	0x97D9,	{ 0xE6, 0xA4, 0xAF },
	0x97DA,	{ 0xE6, 0xA4, 0xB1 },
	0x97DB,	{ 0xE6, 0xA4, 0xB2 },
	0x97DC,	{ 0xE6, 0xA4, 0xB3 },
	0x97DD,	{ 0xE6, 0xA4, 0xB5 },
	0x97DE,	{ 0xE6, 0xA4, 0xB6 },
	0x97DF,	{ 0xE6, 0xA4, 0xB7 },
	0x97E0,	{ 0xE6, 0xA4, 0xB8 },
	0x97E1,	{ 0xE6, 0xA4, 0xBA },
	0x97E2,	{ 0xE6, 0xA4, 0xBB },
	0x97E3,	{ 0xE6, 0xA4, 0xBC },
	0x97E4,	{ 0xE6, 0xA4, 0xBE },
	0x97E5,	{ 0xE6, 0xA5, 0x80 },
	0x97E6,	{ 0xE6, 0xA5, 0x81 },
	0x97E7,	{ 0xE6, 0xA5, 0x83 },
	0x97E8,	{ 0xE6, 0xA5, 0x84 },
	0x97E9,	{ 0xE6, 0xA5, 0x85 },
	0x97EA,	{ 0xE6, 0xA5, 0x86 },
	0x97EB,	{ 0xE6, 0xA5, 0x87 },
	0x97EC,	{ 0xE6, 0xA5, 0x88 },
	0x97ED,	{ 0xE6, 0xA5, 0x89 },
	0x97EE,	{ 0xE6, 0xA5, 0x8A },
	0x97EF,	{ 0xE6, 0xA5, 0x8B },
	0x97F0,	{ 0xE6, 0xA5, 0x8C },
	0x97F1,	{ 0xE6, 0xA5, 0x8D },
	0x97F2,	{ 0xE6, 0xA5, 0x8E },
	0x97F3,	{ 0xE6, 0xA5, 0x8F },
	0x97F4,	{ 0xE6, 0xA5, 0x90 },
	0x97F5,	{ 0xE6, 0xA5, 0x91 },
	0x97F6,	{ 0xE6, 0xA5, 0x92 },
	0x97F7,	{ 0xE6, 0xA5, 0x93 },
	0x97F8,	{ 0xE6, 0xA5, 0x95 },
	0x97F9,	{ 0xE6, 0xA5, 0x96 },
	0x97FA,	{ 0xE6, 0xA5, 0x98 },
	0x97FB,	{ 0xE6, 0xA5, 0x99 },
	0x97FC,	{ 0xE6, 0xA5, 0x9B },
	0x97FD,	{ 0xE6, 0xA5, 0x9C },
	0x97FE,	{ 0xE6, 0xA5, 0x9F },
	0x9840,	{ 0xE6, 0xA5, 0xA1 },
	0x9841,	{ 0xE6, 0xA5, 0xA2 },
	0x9842,	{ 0xE6, 0xA5, 0xA4 },
	0x9843,	{ 0xE6, 0xA5, 0xA5 },
	0x9844,	{ 0xE6, 0xA5, 0xA7 },
	0x9845,	{ 0xE6, 0xA5, 0xA8 },
	0x9846,	{ 0xE6, 0xA5, 0xA9 },
	0x9847,	{ 0xE6, 0xA5, 0xAA },
	0x9848,	{ 0xE6, 0xA5, 0xAC },
	0x9849,	{ 0xE6, 0xA5, 0xAD },
	0x984A,	{ 0xE6, 0xA5, 0xAF },
	0x984B,	{ 0xE6, 0xA5, 0xB0 },
	0x984C,	{ 0xE6, 0xA5, 0xB2 },
	0x984D,	{ 0xE6, 0xA5, 0xB3 },
	0x984E,	{ 0xE6, 0xA5, 0xB4 },
	0x984F,	{ 0xE6, 0xA5, 0xB5 },
	0x9850,	{ 0xE6, 0xA5, 0xB6 },
	0x9851,	{ 0xE6, 0xA5, 0xBA },
	0x9852,	{ 0xE6, 0xA5, 0xBB },
	0x9853,	{ 0xE6, 0xA5, 0xBD },
	0x9854,	{ 0xE6, 0xA5, 0xBE },
	0x9855,	{ 0xE6, 0xA5, 0xBF },
	0x9856,	{ 0xE6, 0xA6, 0x81 },
	0x9857,	{ 0xE6, 0xA6, 0x83 },
	0x9858,	{ 0xE6, 0xA6, 0x85 },
	0x9859,	{ 0xE6, 0xA6, 0x8A },
	0x985A,	{ 0xE6, 0xA6, 0x8B },
	0x985B,	{ 0xE6, 0xA6, 0x8C },
	0x985C,	{ 0xE6, 0xA6, 0x8E },
	0x985D,	{ 0xE6, 0xA6, 0x8F },
	0x985E,	{ 0xE6, 0xA6, 0x90 },
	0x985F,	{ 0xE6, 0xA6, 0x91 },
	0x9860,	{ 0xE6, 0xA6, 0x92 },
	0x9861,	{ 0xE6, 0xA6, 0x93 },
	0x9862,	{ 0xE6, 0xA6, 0x96 },
	0x9863,	{ 0xE6, 0xA6, 0x97 },
	0x9864,	{ 0xE6, 0xA6, 0x99 },
	0x9865,	{ 0xE6, 0xA6, 0x9A },
	0x9866,	{ 0xE6, 0xA6, 0x9D },
	0x9867,	{ 0xE6, 0xA6, 0x9E },
	0x9868,	{ 0xE6, 0xA6, 0x9F },
	0x9869,	{ 0xE6, 0xA6, 0xA0 },
	0x986A,	{ 0xE6, 0xA6, 0xA1 },
	0x986B,	{ 0xE6, 0xA6, 0xA2 },
	0x986C,	{ 0xE6, 0xA6, 0xA3 },
	0x986D,	{ 0xE6, 0xA6, 0xA4 },
	0x986E,	{ 0xE6, 0xA6, 0xA5 },
	0x986F,	{ 0xE6, 0xA6, 0xA6 },
	0x9870,	{ 0xE6, 0xA6, 0xA9 },
	0x9871,	{ 0xE6, 0xA6, 0xAA },
	0x9872,	{ 0xE6, 0xA6, 0xAC },
	0x9873,	{ 0xE6, 0xA6, 0xAE },
	0x9874,	{ 0xE6, 0xA6, 0xAF },
	0x9875,	{ 0xE6, 0xA6, 0xB0 },
	0x9876,	{ 0xE6, 0xA6, 0xB2 },
	0x9877,	{ 0xE6, 0xA6, 0xB3 },
	0x9878,	{ 0xE6, 0xA6, 0xB5 },
	0x9879,	{ 0xE6, 0xA6, 0xB6 },
	0x987A,	{ 0xE6, 0xA6, 0xB8 },
	0x987B,	{ 0xE6, 0xA6, 0xB9 },
	0x987C,	{ 0xE6, 0xA6, 0xBA },
	0x987D,	{ 0xE6, 0xA6, 0xBC },
	0x987E,	{ 0xE6, 0xA6, 0xBD },
	0x9880,	{ 0xE6, 0xA6, 0xBE },
	0x9881,	{ 0xE6, 0xA6, 0xBF },
	0x9882,	{ 0xE6, 0xA7, 0x80 },
	0x9883,	{ 0xE6, 0xA7, 0x82 },
	0x9884,	{ 0xE6, 0xA7, 0x83 },
	0x9885,	{ 0xE6, 0xA7, 0x84 },
	0x9886,	{ 0xE6, 0xA7, 0x85 },
	0x9887,	{ 0xE6, 0xA7, 0x86 },
	0x9888,	{ 0xE6, 0xA7, 0x87 },
	0x9889,	{ 0xE6, 0xA7, 0x88 },
	0x988A,	{ 0xE6, 0xA7, 0x89 },
	0x988B,	{ 0xE6, 0xA7, 0x8B },
	0x988C,	{ 0xE6, 0xA7, 0x8D },
	0x988D,	{ 0xE6, 0xA7, 0x8F },
	0x988E,	{ 0xE6, 0xA7, 0x91 },
	0x988F,	{ 0xE6, 0xA7, 0x92 },
	0x9890,	{ 0xE6, 0xA7, 0x93 },
	0x9891,	{ 0xE6, 0xA7, 0x95 },
	0x9892,	{ 0xE6, 0xA7, 0x96 },
	0x9893,	{ 0xE6, 0xA7, 0x97 },
	0x9894,	{ 0xE6, 0xA7, 0x98 },
	0x9895,	{ 0xE6, 0xA7, 0x99 },
	0x9896,	{ 0xE6, 0xA7, 0x9A },
	0x9897,	{ 0xE6, 0xA7, 0x9C },
	0x9898,	{ 0xE6, 0xA7, 0x9D },
	0x9899,	{ 0xE6, 0xA7, 0x9E },
	0x989A,	{ 0xE6, 0xA7, 0xA1 },
	0x989B,	{ 0xE6, 0xA7, 0xA2 },
	0x989C,	{ 0xE6, 0xA7, 0xA3 },
	0x989D,	{ 0xE6, 0xA7, 0xA4 },
	0x989E,	{ 0xE6, 0xA7, 0xA5 },
	0x989F,	{ 0xE6, 0xA7, 0xA6 },
	0x98A0,	{ 0xE6, 0xA7, 0xA7 },
	0x98A1,	{ 0xE6, 0xA7, 0xA8 },
	0x98A2,	{ 0xE6, 0xA7, 0xA9 },
	0x98A3,	{ 0xE6, 0xA7, 0xAA },
	0x98A4,	{ 0xE6, 0xA7, 0xAB },
	0x98A5,	{ 0xE6, 0xA7, 0xAC },
	0x98A6,	{ 0xE6, 0xA7, 0xAE },
	0x98A7,	{ 0xE6, 0xA7, 0xAF },
	0x98A8,	{ 0xE6, 0xA7, 0xB0 },
	0x98A9,	{ 0xE6, 0xA7, 0xB1 },
	0x98AA,	{ 0xE6, 0xA7, 0xB3 },
	0x98AB,	{ 0xE6, 0xA7, 0xB4 },
	0x98AC,	{ 0xE6, 0xA7, 0xB5 },
	0x98AD,	{ 0xE6, 0xA7, 0xB6 },
	0x98AE,	{ 0xE6, 0xA7, 0xB7 },
	0x98AF,	{ 0xE6, 0xA7, 0xB8 },
	0x98B0,	{ 0xE6, 0xA7, 0xB9 },
	0x98B1,	{ 0xE6, 0xA7, 0xBA },
	0x98B2,	{ 0xE6, 0xA7, 0xBB },
	0x98B3,	{ 0xE6, 0xA7, 0xBC },
	0x98B4,	{ 0xE6, 0xA7, 0xBE },
	0x98B5,	{ 0xE6, 0xA8, 0x80 },
	0x98B6,	{ 0xE6, 0xA8, 0x81 },
	0x98B7,	{ 0xE6, 0xA8, 0x82 },
	0x98B8,	{ 0xE6, 0xA8, 0x83 },
	0x98B9,	{ 0xE6, 0xA8, 0x84 },
	0x98BA,	{ 0xE6, 0xA8, 0x85 },
	0x98BB,	{ 0xE6, 0xA8, 0x86 },
	0x98BC,	{ 0xE6, 0xA8, 0x87 },
	0x98BD,	{ 0xE6, 0xA8, 0x88 },
	0x98BE,	{ 0xE6, 0xA8, 0x89 },
	0x98BF,	{ 0xE6, 0xA8, 0x8B },
	0x98C0,	{ 0xE6, 0xA8, 0x8C },
	0x98C1,	{ 0xE6, 0xA8, 0x8D },
	0x98C2,	{ 0xE6, 0xA8, 0x8E },
	0x98C3,	{ 0xE6, 0xA8, 0x8F },
	0x98C4,	{ 0xE6, 0xA8, 0x90 },
	0x98C5,	{ 0xE6, 0xA8, 0x91 },
	0x98C6,	{ 0xE6, 0xA8, 0x92 },
	0x98C7,	{ 0xE6, 0xA8, 0x93 },
	0x98C8,	{ 0xE6, 0xA8, 0x94 },
	0x98C9,	{ 0xE6, 0xA8, 0x95 },
	0x98CA,	{ 0xE6, 0xA8, 0x96 },
	0x98CB,	{ 0xE6, 0xA8, 0x99 },
	0x98CC,	{ 0xE6, 0xA8, 0x9A },
	0x98CD,	{ 0xE6, 0xA8, 0x9B },
	0x98CE,	{ 0xE6, 0xA8, 0x9C },
	0x98CF,	{ 0xE6, 0xA8, 0x9D },
	0x98D0,	{ 0xE6, 0xA8, 0x9E },
	0x98D1,	{ 0xE6, 0xA8, 0xA0 },
	0x98D2,	{ 0xE6, 0xA8, 0xA2 },
	0x98D3,	{ 0xE6, 0xA8, 0xA3 },
	0x98D4,	{ 0xE6, 0xA8, 0xA4 },
	0x98D5,	{ 0xE6, 0xA8, 0xA5 },
	0x98D6,	{ 0xE6, 0xA8, 0xA6 },
	0x98D7,	{ 0xE6, 0xA8, 0xA7 },
	0x98D8,	{ 0xE6, 0xA8, 0xA9 },
	0x98D9,	{ 0xE6, 0xA8, 0xAB },
	0x98DA,	{ 0xE6, 0xA8, 0xAC },
	0x98DB,	{ 0xE6, 0xA8, 0xAD },
	0x98DC,	{ 0xE6, 0xA8, 0xAE },
	0x98DD,	{ 0xE6, 0xA8, 0xB0 },
	0x98DE,	{ 0xE6, 0xA8, 0xB2 },
	0x98DF,	{ 0xE6, 0xA8, 0xB3 },
	0x98E0,	{ 0xE6, 0xA8, 0xB4 },
	0x98E1,	{ 0xE6, 0xA8, 0xB6 },
	0x98E2,	{ 0xE6, 0xA8, 0xB7 },
	0x98E3,	{ 0xE6, 0xA8, 0xB8 },
	0x98E4,	{ 0xE6, 0xA8, 0xB9 },
	0x98E5,	{ 0xE6, 0xA8, 0xBA },
	0x98E6,	{ 0xE6, 0xA8, 0xBB },
	0x98E7,	{ 0xE6, 0xA8, 0xBC },
	0x98E8,	{ 0xE6, 0xA8, 0xBF },
	0x98E9,	{ 0xE6, 0xA9, 0x80 },
	0x98EA,	{ 0xE6, 0xA9, 0x81 },
	0x98EB,	{ 0xE6, 0xA9, 0x82 },
	0x98EC,	{ 0xE6, 0xA9, 0x83 },
	0x98ED,	{ 0xE6, 0xA9, 0x85 },
	0x98EE,	{ 0xE6, 0xA9, 0x86 },
	0x98EF,	{ 0xE6, 0xA9, 0x88 },
	0x98F0,	{ 0xE6, 0xA9, 0x89 },
	0x98F1,	{ 0xE6, 0xA9, 0x8A },
	0x98F2,	{ 0xE6, 0xA9, 0x8B },
	0x98F3,	{ 0xE6, 0xA9, 0x8C },
	0x98F4,	{ 0xE6, 0xA9, 0x8D },
	0x98F5,	{ 0xE6, 0xA9, 0x8E },
	0x98F6,	{ 0xE6, 0xA9, 0x8F },
	0x98F7,	{ 0xE6, 0xA9, 0x91 },
	0x98F8,	{ 0xE6, 0xA9, 0x92 },
	0x98F9,	{ 0xE6, 0xA9, 0x93 },
	0x98FA,	{ 0xE6, 0xA9, 0x94 },
	0x98FB,	{ 0xE6, 0xA9, 0x95 },
	0x98FC,	{ 0xE6, 0xA9, 0x96 },
	0x98FD,	{ 0xE6, 0xA9, 0x97 },
	0x98FE,	{ 0xE6, 0xA9, 0x9A },
	0x9940,	{ 0xE6, 0xA9, 0x9C },
	0x9941,	{ 0xE6, 0xA9, 0x9D },
	0x9942,	{ 0xE6, 0xA9, 0x9E },
	0x9943,	{ 0xE6, 0xA9, 0x9F },
	0x9944,	{ 0xE6, 0xA9, 0xA0 },
	0x9945,	{ 0xE6, 0xA9, 0xA2 },
	0x9946,	{ 0xE6, 0xA9, 0xA3 },
	0x9947,	{ 0xE6, 0xA9, 0xA4 },
	0x9948,	{ 0xE6, 0xA9, 0xA6 },
	0x9949,	{ 0xE6, 0xA9, 0xA7 },
	0x994A,	{ 0xE6, 0xA9, 0xA8 },
	0x994B,	{ 0xE6, 0xA9, 0xA9 },
	0x994C,	{ 0xE6, 0xA9, 0xAA },
	0x994D,	{ 0xE6, 0xA9, 0xAB },
	0x994E,	{ 0xE6, 0xA9, 0xAC },
	0x994F,	{ 0xE6, 0xA9, 0xAD },
	0x9950,	{ 0xE6, 0xA9, 0xAE },
	0x9951,	{ 0xE6, 0xA9, 0xAF },
	0x9952,	{ 0xE6, 0xA9, 0xB0 },
	0x9953,	{ 0xE6, 0xA9, 0xB2 },
	0x9954,	{ 0xE6, 0xA9, 0xB3 },
	0x9955,	{ 0xE6, 0xA9, 0xB4 },
	0x9956,	{ 0xE6, 0xA9, 0xB5 },
	0x9957,	{ 0xE6, 0xA9, 0xB6 },
	0x9958,	{ 0xE6, 0xA9, 0xB7 },
	0x9959,	{ 0xE6, 0xA9, 0xB8 },
	0x995A,	{ 0xE6, 0xA9, 0xBA },
	0x995B,	{ 0xE6, 0xA9, 0xBB },
	0x995C,	{ 0xE6, 0xA9, 0xBD },
	0x995D,	{ 0xE6, 0xA9, 0xBE },
	0x995E,	{ 0xE6, 0xA9, 0xBF },
	0x995F,	{ 0xE6, 0xAA, 0x81 },
	0x9960,	{ 0xE6, 0xAA, 0x82 },
	0x9961,	{ 0xE6, 0xAA, 0x83 },
	0x9962,	{ 0xE6, 0xAA, 0x85 },
	0x9963,	{ 0xE6, 0xAA, 0x86 },
	0x9964,	{ 0xE6, 0xAA, 0x87 },
	0x9965,	{ 0xE6, 0xAA, 0x88 },
	0x9966,	{ 0xE6, 0xAA, 0x89 },
	0x9967,	{ 0xE6, 0xAA, 0x8A },
	0x9968,	{ 0xE6, 0xAA, 0x8B },
	0x9969,	{ 0xE6, 0xAA, 0x8C },
	0x996A,	{ 0xE6, 0xAA, 0x8D },
	0x996B,	{ 0xE6, 0xAA, 0x8F },
	0x996C,	{ 0xE6, 0xAA, 0x92 },
	0x996D,	{ 0xE6, 0xAA, 0x93 },
	0x996E,	{ 0xE6, 0xAA, 0x94 },
	0x996F,	{ 0xE6, 0xAA, 0x95 },
	0x9970,	{ 0xE6, 0xAA, 0x96 },
	0x9971,	{ 0xE6, 0xAA, 0x98 },
	0x9972,	{ 0xE6, 0xAA, 0x99 },
	0x9973,	{ 0xE6, 0xAA, 0x9A },
	0x9974,	{ 0xE6, 0xAA, 0x9B },
	0x9975,	{ 0xE6, 0xAA, 0x9C },
	0x9976,	{ 0xE6, 0xAA, 0x9D },
	0x9977,	{ 0xE6, 0xAA, 0x9E },
	0x9978,	{ 0xE6, 0xAA, 0x9F },
	0x9979,	{ 0xE6, 0xAA, 0xA1 },
	0x997A,	{ 0xE6, 0xAA, 0xA2 },
	0x997B,	{ 0xE6, 0xAA, 0xA3 },
	0x997C,	{ 0xE6, 0xAA, 0xA4 },
	0x997D,	{ 0xE6, 0xAA, 0xA5 },
	0x997E,	{ 0xE6, 0xAA, 0xA6 },
	0x9980,	{ 0xE6, 0xAA, 0xA7 },
	0x9981,	{ 0xE6, 0xAA, 0xA8 },
	0x9982,	{ 0xE6, 0xAA, 0xAA },
	0x9983,	{ 0xE6, 0xAA, 0xAD },
	0x9984,	{ 0xE6, 0xAA, 0xAE },
	0x9985,	{ 0xE6, 0xAA, 0xAF },
	0x9986,	{ 0xE6, 0xAA, 0xB0 },
	0x9987,	{ 0xE6, 0xAA, 0xB1 },
	0x9988,	{ 0xE6, 0xAA, 0xB2 },
	0x9989,	{ 0xE6, 0xAA, 0xB3 },
	0x998A,	{ 0xE6, 0xAA, 0xB4 },
	0x998B,	{ 0xE6, 0xAA, 0xB5 },
	0x998C,	{ 0xE6, 0xAA, 0xB6 },
	0x998D,	{ 0xE6, 0xAA, 0xB7 },
	0x998E,	{ 0xE6, 0xAA, 0xB8 },
	0x998F,	{ 0xE6, 0xAA, 0xB9 },
	0x9990,	{ 0xE6, 0xAA, 0xBA },
	0x9991,	{ 0xE6, 0xAA, 0xBB },
	0x9992,	{ 0xE6, 0xAA, 0xBC },
	0x9993,	{ 0xE6, 0xAA, 0xBD },
	0x9994,	{ 0xE6, 0xAA, 0xBE },
	0x9995,	{ 0xE6, 0xAA, 0xBF },
	0x9996,	{ 0xE6, 0xAB, 0x80 },
	0x9997,	{ 0xE6, 0xAB, 0x81 },
	0x9998,	{ 0xE6, 0xAB, 0x82 },
	0x9999,	{ 0xE6, 0xAB, 0x83 },
	0x999A,	{ 0xE6, 0xAB, 0x84 },
	0x999B,	{ 0xE6, 0xAB, 0x85 },
	0x999C,	{ 0xE6, 0xAB, 0x86 },
	0x999D,	{ 0xE6, 0xAB, 0x87 },
	0x999E,	{ 0xE6, 0xAB, 0x88 },
	0x999F,	{ 0xE6, 0xAB, 0x89 },
	0x99A0,	{ 0xE6, 0xAB, 0x8A },
	0x99A1,	{ 0xE6, 0xAB, 0x8B },
	0x99A2,	{ 0xE6, 0xAB, 0x8C },
	0x99A3,	{ 0xE6, 0xAB, 0x8D },
	0x99A4,	{ 0xE6, 0xAB, 0x8E },
	0x99A5,	{ 0xE6, 0xAB, 0x8F },
	0x99A6,	{ 0xE6, 0xAB, 0x90 },
	0x99A7,	{ 0xE6, 0xAB, 0x91 },
	0x99A8,	{ 0xE6, 0xAB, 0x92 },
	0x99A9,	{ 0xE6, 0xAB, 0x93 },
	0x99AA,	{ 0xE6, 0xAB, 0x94 },
	0x99AB,	{ 0xE6, 0xAB, 0x95 },
	0x99AC,	{ 0xE6, 0xAB, 0x96 },
	0x99AD,	{ 0xE6, 0xAB, 0x97 },
	0x99AE,	{ 0xE6, 0xAB, 0x98 },
	0x99AF,	{ 0xE6, 0xAB, 0x99 },
	0x99B0,	{ 0xE6, 0xAB, 0x9A },
	0x99B1,	{ 0xE6, 0xAB, 0x9B },
	0x99B2,	{ 0xE6, 0xAB, 0x9C },
	0x99B3,	{ 0xE6, 0xAB, 0x9D },
	0x99B4,	{ 0xE6, 0xAB, 0x9E },
	0x99B5,	{ 0xE6, 0xAB, 0x9F },
	0x99B6,	{ 0xE6, 0xAB, 0xA0 },
	0x99B7,	{ 0xE6, 0xAB, 0xA1 },
	0x99B8,	{ 0xE6, 0xAB, 0xA2 },
	0x99B9,	{ 0xE6, 0xAB, 0xA3 },
	0x99BA,	{ 0xE6, 0xAB, 0xA4 },
	0x99BB,	{ 0xE6, 0xAB, 0xA5 },
	0x99BC,	{ 0xE6, 0xAB, 0xA6 },
	0x99BD,	{ 0xE6, 0xAB, 0xA7 },
	0x99BE,	{ 0xE6, 0xAB, 0xA8 },
	0x99BF,	{ 0xE6, 0xAB, 0xA9 },
	0x99C0,	{ 0xE6, 0xAB, 0xAA },
	0x99C1,	{ 0xE6, 0xAB, 0xAB },
	0x99C2,	{ 0xE6, 0xAB, 0xAC },
	0x99C3,	{ 0xE6, 0xAB, 0xAD },
	0x99C4,	{ 0xE6, 0xAB, 0xAE },
	0x99C5,	{ 0xE6, 0xAB, 0xAF },
	0x99C6,	{ 0xE6, 0xAB, 0xB0 },
	0x99C7,	{ 0xE6, 0xAB, 0xB1 },
	0x99C8,	{ 0xE6, 0xAB, 0xB2 },
	0x99C9,	{ 0xE6, 0xAB, 0xB3 },
	0x99CA,	{ 0xE6, 0xAB, 0xB4 },
	0x99CB,	{ 0xE6, 0xAB, 0xB5 },
	0x99CC,	{ 0xE6, 0xAB, 0xB6 },
	0x99CD,	{ 0xE6, 0xAB, 0xB7 },
	0x99CE,	{ 0xE6, 0xAB, 0xB8 },
	0x99CF,	{ 0xE6, 0xAB, 0xB9 },
	0x99D0,	{ 0xE6, 0xAB, 0xBA },
	0x99D1,	{ 0xE6, 0xAB, 0xBB },
	0x99D2,	{ 0xE6, 0xAB, 0xBC },
	0x99D3,	{ 0xE6, 0xAB, 0xBD },
	0x99D4,	{ 0xE6, 0xAB, 0xBE },
	0x99D5,	{ 0xE6, 0xAB, 0xBF },
	0x99D6,	{ 0xE6, 0xAC, 0x80 },
	0x99D7,	{ 0xE6, 0xAC, 0x81 },
	0x99D8,	{ 0xE6, 0xAC, 0x82 },
	0x99D9,	{ 0xE6, 0xAC, 0x83 },
	0x99DA,	{ 0xE6, 0xAC, 0x84 },
	0x99DB,	{ 0xE6, 0xAC, 0x85 },
	0x99DC,	{ 0xE6, 0xAC, 0x86 },
	0x99DD,	{ 0xE6, 0xAC, 0x87 },
	0x99DE,	{ 0xE6, 0xAC, 0x88 },
	0x99DF,	{ 0xE6, 0xAC, 0x89 },
	0x99E0,	{ 0xE6, 0xAC, 0x8A },
	0x99E1,	{ 0xE6, 0xAC, 0x8B },
	0x99E2,	{ 0xE6, 0xAC, 0x8C },
	0x99E3,	{ 0xE6, 0xAC, 0x8D },
	0x99E4,	{ 0xE6, 0xAC, 0x8E },
	0x99E5,	{ 0xE6, 0xAC, 0x8F },
	0x99E6,	{ 0xE6, 0xAC, 0x90 },
	0x99E7,	{ 0xE6, 0xAC, 0x91 },
	0x99E8,	{ 0xE6, 0xAC, 0x92 },
	0x99E9,	{ 0xE6, 0xAC, 0x93 },
	0x99EA,	{ 0xE6, 0xAC, 0x94 },
	0x99EB,	{ 0xE6, 0xAC, 0x95 },
	0x99EC,	{ 0xE6, 0xAC, 0x96 },
	0x99ED,	{ 0xE6, 0xAC, 0x97 },
	0x99EE,	{ 0xE6, 0xAC, 0x98 },
	0x99EF,	{ 0xE6, 0xAC, 0x99 },
	0x99F0,	{ 0xE6, 0xAC, 0x9A },
	0x99F1,	{ 0xE6, 0xAC, 0x9B },
	0x99F2,	{ 0xE6, 0xAC, 0x9C },
	0x99F3,	{ 0xE6, 0xAC, 0x9D },
	0x99F4,	{ 0xE6, 0xAC, 0x9E },
	0x99F5,	{ 0xE6, 0xAC, 0x9F },
	0x99F6,	{ 0xE6, 0xAC, 0xA5 },
	0x99F7,	{ 0xE6, 0xAC, 0xA6 },
	0x99F8,	{ 0xE6, 0xAC, 0xA8 },
	0x99F9,	{ 0xE6, 0xAC, 0xA9 },
	0x99FA,	{ 0xE6, 0xAC, 0xAA },
	0x99FB,	{ 0xE6, 0xAC, 0xAB },
	0x99FC,	{ 0xE6, 0xAC, 0xAC },
	0x99FD,	{ 0xE6, 0xAC, 0xAD },
	0x99FE,	{ 0xE6, 0xAC, 0xAE },
	0x9A40,	{ 0xE6, 0xAC, 0xAF },
	0x9A41,	{ 0xE6, 0xAC, 0xB0 },
	0x9A42,	{ 0xE6, 0xAC, 0xB1 },
	0x9A43,	{ 0xE6, 0xAC, 0xB3 },
	0x9A44,	{ 0xE6, 0xAC, 0xB4 },
	0x9A45,	{ 0xE6, 0xAC, 0xB5 },
	0x9A46,	{ 0xE6, 0xAC, 0xB6 },
	0x9A47,	{ 0xE6, 0xAC, 0xB8 },
	0x9A48,	{ 0xE6, 0xAC, 0xBB },
	0x9A49,	{ 0xE6, 0xAC, 0xBC },
	0x9A4A,	{ 0xE6, 0xAC, 0xBD },
	0x9A4B,	{ 0xE6, 0xAC, 0xBF },
	0x9A4C,	{ 0xE6, 0xAD, 0x80 },
	0x9A4D,	{ 0xE6, 0xAD, 0x81 },
	0x9A4E,	{ 0xE6, 0xAD, 0x82 },
	0x9A4F,	{ 0xE6, 0xAD, 0x84 },
	0x9A50,	{ 0xE6, 0xAD, 0x85 },
	0x9A51,	{ 0xE6, 0xAD, 0x88 },
	0x9A52,	{ 0xE6, 0xAD, 0x8A },
	0x9A53,	{ 0xE6, 0xAD, 0x8B },
	0x9A54,	{ 0xE6, 0xAD, 0x8D },
	0x9A55,	{ 0xE6, 0xAD, 0x8E },
	0x9A56,	{ 0xE6, 0xAD, 0x8F },
	0x9A57,	{ 0xE6, 0xAD, 0x90 },
	0x9A58,	{ 0xE6, 0xAD, 0x91 },
	0x9A59,	{ 0xE6, 0xAD, 0x92 },
	0x9A5A,	{ 0xE6, 0xAD, 0x93 },
	0x9A5B,	{ 0xE6, 0xAD, 0x94 },
	0x9A5C,	{ 0xE6, 0xAD, 0x95 },
	0x9A5D,	{ 0xE6, 0xAD, 0x96 },
	0x9A5E,	{ 0xE6, 0xAD, 0x97 },
	0x9A5F,	{ 0xE6, 0xAD, 0x98 },
	0x9A60,	{ 0xE6, 0xAD, 0x9A },
	0x9A61,	{ 0xE6, 0xAD, 0x9B },
	0x9A62,	{ 0xE6, 0xAD, 0x9C },
	0x9A63,	{ 0xE6, 0xAD, 0x9D },
	0x9A64,	{ 0xE6, 0xAD, 0x9E },
	0x9A65,	{ 0xE6, 0xAD, 0x9F },
	0x9A66,	{ 0xE6, 0xAD, 0xA0 },
	0x9A67,	{ 0xE6, 0xAD, 0xA1 },
	0x9A68,	{ 0xE6, 0xAD, 0xA8 },
	0x9A69,	{ 0xE6, 0xAD, 0xA9 },
	0x9A6A,	{ 0xE6, 0xAD, 0xAB },
	0x9A6B,	{ 0xE6, 0xAD, 0xAC },
	0x9A6C,	{ 0xE6, 0xAD, 0xAD },
	0x9A6D,	{ 0xE6, 0xAD, 0xAE },
	0x9A6E,	{ 0xE6, 0xAD, 0xAF },
	0x9A6F,	{ 0xE6, 0xAD, 0xB0 },
	0x9A70,	{ 0xE6, 0xAD, 0xB1 },
	0x9A71,	{ 0xE6, 0xAD, 0xB2 },
	0x9A72,	{ 0xE6, 0xAD, 0xB3 },
	0x9A73,	{ 0xE6, 0xAD, 0xB4 },
	0x9A74,	{ 0xE6, 0xAD, 0xB5 },
	0x9A75,	{ 0xE6, 0xAD, 0xB6 },
	0x9A76,	{ 0xE6, 0xAD, 0xB7 },
	0x9A77,	{ 0xE6, 0xAD, 0xB8 },
	0x9A78,	{ 0xE6, 0xAD, 0xBA },
	0x9A79,	{ 0xE6, 0xAD, 0xBD },
	0x9A7A,	{ 0xE6, 0xAD, 0xBE },
	0x9A7B,	{ 0xE6, 0xAD, 0xBF },
	0x9A7C,	{ 0xE6, 0xAE, 0x80 },
	0x9A7D,	{ 0xE6, 0xAE, 0x85 },
	0x9A7E,	{ 0xE6, 0xAE, 0x88 },
	0x9A80,	{ 0xE6, 0xAE, 0x8C },
	0x9A81,	{ 0xE6, 0xAE, 0x8E },
	0x9A82,	{ 0xE6, 0xAE, 0x8F },
	0x9A83,	{ 0xE6, 0xAE, 0x90 },
	0x9A84,	{ 0xE6, 0xAE, 0x91 },
	0x9A85,	{ 0xE6, 0xAE, 0x94 },
	0x9A86,	{ 0xE6, 0xAE, 0x95 },
	0x9A87,	{ 0xE6, 0xAE, 0x97 },
	0x9A88,	{ 0xE6, 0xAE, 0x98 },
	0x9A89,	{ 0xE6, 0xAE, 0x99 },
	0x9A8A,	{ 0xE6, 0xAE, 0x9C },
	0x9A8B,	{ 0xE6, 0xAE, 0x9D },
	0x9A8C,	{ 0xE6, 0xAE, 0x9E },
	0x9A8D,	{ 0xE6, 0xAE, 0x9F },
	0x9A8E,	{ 0xE6, 0xAE, 0xA0 },
	0x9A8F,	{ 0xE6, 0xAE, 0xA2 },
	0x9A90,	{ 0xE6, 0xAE, 0xA3 },
	0x9A91,	{ 0xE6, 0xAE, 0xA4 },
	0x9A92,	{ 0xE6, 0xAE, 0xA5 },
	0x9A93,	{ 0xE6, 0xAE, 0xA6 },
	0x9A94,	{ 0xE6, 0xAE, 0xA7 },
	0x9A95,	{ 0xE6, 0xAE, 0xA8 },
	0x9A96,	{ 0xE6, 0xAE, 0xA9 },
	0x9A97,	{ 0xE6, 0xAE, 0xAB },
	0x9A98,	{ 0xE6, 0xAE, 0xAC },
	0x9A99,	{ 0xE6, 0xAE, 0xAD },
	0x9A9A,	{ 0xE6, 0xAE, 0xAE },
	0x9A9B,	{ 0xE6, 0xAE, 0xAF },
	0x9A9C,	{ 0xE6, 0xAE, 0xB0 },
	0x9A9D,	{ 0xE6, 0xAE, 0xB1 },
	0x9A9E,	{ 0xE6, 0xAE, 0xB2 },
	0x9A9F,	{ 0xE6, 0xAE, 0xB6 },
	0x9AA0,	{ 0xE6, 0xAE, 0xB8 },
	0x9AA1,	{ 0xE6, 0xAE, 0xB9 },
	0x9AA2,	{ 0xE6, 0xAE, 0xBA },
	0x9AA3,	{ 0xE6, 0xAE, 0xBB },
	0x9AA4,	{ 0xE6, 0xAE, 0xBC },
	0x9AA5,	{ 0xE6, 0xAE, 0xBD },
	0x9AA6,	{ 0xE6, 0xAE, 0xBE },
	0x9AA7,	{ 0xE6, 0xAF, 0x80 },
	0x9AA8,	{ 0xE6, 0xAF, 0x83 },
	0x9AA9,	{ 0xE6, 0xAF, 0x84 },
	0x9AAA,	{ 0xE6, 0xAF, 0x86 },
	0x9AAB,	{ 0xE6, 0xAF, 0x87 },
	0x9AAC,	{ 0xE6, 0xAF, 0x88 },
	0x9AAD,	{ 0xE6, 0xAF, 0x89 },
	0x9AAE,	{ 0xE6, 0xAF, 0x8A },
	0x9AAF,	{ 0xE6, 0xAF, 0x8C },
	0x9AB0,	{ 0xE6, 0xAF, 0x8E },
	0x9AB1,	{ 0xE6, 0xAF, 0x90 },
	0x9AB2,	{ 0xE6, 0xAF, 0x91 },
	0x9AB3,	{ 0xE6, 0xAF, 0x98 },
	0x9AB4,	{ 0xE6, 0xAF, 0x9A },
	0x9AB5,	{ 0xE6, 0xAF, 0x9C },
	0x9AB6,	{ 0xE6, 0xAF, 0x9D },
	0x9AB7,	{ 0xE6, 0xAF, 0x9E },
	0x9AB8,	{ 0xE6, 0xAF, 0x9F },
	0x9AB9,	{ 0xE6, 0xAF, 0xA0 },
	0x9ABA,	{ 0xE6, 0xAF, 0xA2 },
	0x9ABB,	{ 0xE6, 0xAF, 0xA3 },
	0x9ABC,	{ 0xE6, 0xAF, 0xA4 },
	0x9ABD,	{ 0xE6, 0xAF, 0xA5 },
	0x9ABE,	{ 0xE6, 0xAF, 0xA6 },
	0x9ABF,	{ 0xE6, 0xAF, 0xA7 },
	0x9AC0,	{ 0xE6, 0xAF, 0xA8 },
	0x9AC1,	{ 0xE6, 0xAF, 0xA9 },
	0x9AC2,	{ 0xE6, 0xAF, 0xAC },
	0x9AC3,	{ 0xE6, 0xAF, 0xAD },
	0x9AC4,	{ 0xE6, 0xAF, 0xAE },
	0x9AC5,	{ 0xE6, 0xAF, 0xB0 },
	0x9AC6,	{ 0xE6, 0xAF, 0xB1 },
	0x9AC7,	{ 0xE6, 0xAF, 0xB2 },
	0x9AC8,	{ 0xE6, 0xAF, 0xB4 },
	0x9AC9,	{ 0xE6, 0xAF, 0xB6 },
	0x9ACA,	{ 0xE6, 0xAF, 0xB7 },
	0x9ACB,	{ 0xE6, 0xAF, 0xB8 },
	0x9ACC,	{ 0xE6, 0xAF, 0xBA },
	0x9ACD,	{ 0xE6, 0xAF, 0xBB },
	0x9ACE,	{ 0xE6, 0xAF, 0xBC },
	0x9ACF,	{ 0xE6, 0xAF, 0xBE },
	0x9AD0,	{ 0xE6, 0xAF, 0xBF },
	0x9AD1,	{ 0xE6, 0xB0, 0x80 },
	0x9AD2,	{ 0xE6, 0xB0, 0x81 },
	0x9AD3,	{ 0xE6, 0xB0, 0x82 },
	0x9AD4,	{ 0xE6, 0xB0, 0x83 },
	0x9AD5,	{ 0xE6, 0xB0, 0x84 },
	0x9AD6,	{ 0xE6, 0xB0, 0x88 },
	0x9AD7,	{ 0xE6, 0xB0, 0x89 },
	0x9AD8,	{ 0xE6, 0xB0, 0x8A },
	0x9AD9,	{ 0xE6, 0xB0, 0x8B },
	0x9ADA,	{ 0xE6, 0xB0, 0x8C },
	0x9ADB,	{ 0xE6, 0xB0, 0x8E },
	0x9ADC,	{ 0xE6, 0xB0, 0x92 },
	0x9ADD,	{ 0xE6, 0xB0, 0x97 },
	0x9ADE,	{ 0xE6, 0xB0, 0x9C },
	0x9ADF,	{ 0xE6, 0xB0, 0x9D },
	0x9AE0,	{ 0xE6, 0xB0, 0x9E },
	0x9AE1,	{ 0xE6, 0xB0, 0xA0 },
	0x9AE2,	{ 0xE6, 0xB0, 0xA3 },
	0x9AE3,	{ 0xE6, 0xB0, 0xA5 },
	0x9AE4,	{ 0xE6, 0xB0, 0xAB },
	0x9AE5,	{ 0xE6, 0xB0, 0xAC },
	0x9AE6,	{ 0xE6, 0xB0, 0xAD },
	0x9AE7,	{ 0xE6, 0xB0, 0xB1 },
	0x9AE8,	{ 0xE6, 0xB0, 0xB3 },
	0x9AE9,	{ 0xE6, 0xB0, 0xB6 },
	0x9AEA,	{ 0xE6, 0xB0, 0xB7 },
	0x9AEB,	{ 0xE6, 0xB0, 0xB9 },
	0x9AEC,	{ 0xE6, 0xB0, 0xBA },
	0x9AED,	{ 0xE6, 0xB0, 0xBB },
	0x9AEE,	{ 0xE6, 0xB0, 0xBC },
	0x9AEF,	{ 0xE6, 0xB0, 0xBE },
	0x9AF0,	{ 0xE6, 0xB0, 0xBF },
	0x9AF1,	{ 0xE6, 0xB1, 0x83 },
	0x9AF2,	{ 0xE6, 0xB1, 0x84 },
	0x9AF3,	{ 0xE6, 0xB1, 0x85 },
	0x9AF4,	{ 0xE6, 0xB1, 0x88 },
	0x9AF5,	{ 0xE6, 0xB1, 0x8B },
	0x9AF6,	{ 0xE6, 0xB1, 0x8C },
	0x9AF7,	{ 0xE6, 0xB1, 0x8D },
	0x9AF8,	{ 0xE6, 0xB1, 0x8E },
	0x9AF9,	{ 0xE6, 0xB1, 0x8F },
	0x9AFA,	{ 0xE6, 0xB1, 0x91 },
	0x9AFB,	{ 0xE6, 0xB1, 0x92 },
	0x9AFC,	{ 0xE6, 0xB1, 0x93 },
	0x9AFD,	{ 0xE6, 0xB1, 0x96 },
	0x9AFE,	{ 0xE6, 0xB1, 0x98 },
	0x9B40,	{ 0xE6, 0xB1, 0x99 },
	0x9B41,	{ 0xE6, 0xB1, 0x9A },
	0x9B42,	{ 0xE6, 0xB1, 0xA2 },
	0x9B43,	{ 0xE6, 0xB1, 0xA3 },
	0x9B44,	{ 0xE6, 0xB1, 0xA5 },
	0x9B45,	{ 0xE6, 0xB1, 0xA6 },
	0x9B46,	{ 0xE6, 0xB1, 0xA7 },
	0x9B47,	{ 0xE6, 0xB1, 0xAB },
	0x9B48,	{ 0xE6, 0xB1, 0xAC },
	0x9B49,	{ 0xE6, 0xB1, 0xAD },
	0x9B4A,	{ 0xE6, 0xB1, 0xAE },
	0x9B4B,	{ 0xE6, 0xB1, 0xAF },
	0x9B4C,	{ 0xE6, 0xB1, 0xB1 },
	0x9B4D,	{ 0xE6, 0xB1, 0xB3 },
	0x9B4E,	{ 0xE6, 0xB1, 0xB5 },
	0x9B4F,	{ 0xE6, 0xB1, 0xB7 },
	0x9B50,	{ 0xE6, 0xB1, 0xB8 },
	0x9B51,	{ 0xE6, 0xB1, 0xBA },
	0x9B52,	{ 0xE6, 0xB1, 0xBB },
	0x9B53,	{ 0xE6, 0xB1, 0xBC },
	0x9B54,	{ 0xE6, 0xB1, 0xBF },
	0x9B55,	{ 0xE6, 0xB2, 0x80 },
	0x9B56,	{ 0xE6, 0xB2, 0x84 },
	0x9B57,	{ 0xE6, 0xB2, 0x87 },
	0x9B58,	{ 0xE6, 0xB2, 0x8A },
	0x9B59,	{ 0xE6, 0xB2, 0x8B },
	0x9B5A,	{ 0xE6, 0xB2, 0x8D },
	0x9B5B,	{ 0xE6, 0xB2, 0x8E },
	0x9B5C,	{ 0xE6, 0xB2, 0x91 },
	0x9B5D,	{ 0xE6, 0xB2, 0x92 },
	0x9B5E,	{ 0xE6, 0xB2, 0x95 },
	0x9B5F,	{ 0xE6, 0xB2, 0x96 },
	0x9B60,	{ 0xE6, 0xB2, 0x97 },
	0x9B61,	{ 0xE6, 0xB2, 0x98 },
	0x9B62,	{ 0xE6, 0xB2, 0x9A },
	0x9B63,	{ 0xE6, 0xB2, 0x9C },
	0x9B64,	{ 0xE6, 0xB2, 0x9D },
	0x9B65,	{ 0xE6, 0xB2, 0x9E },
	0x9B66,	{ 0xE6, 0xB2, 0xA0 },
	0x9B67,	{ 0xE6, 0xB2, 0xA2 },
	0x9B68,	{ 0xE6, 0xB2, 0xA8 },
	0x9B69,	{ 0xE6, 0xB2, 0xAC },
	0x9B6A,	{ 0xE6, 0xB2, 0xAF },
	0x9B6B,	{ 0xE6, 0xB2, 0xB0 },
	0x9B6C,	{ 0xE6, 0xB2, 0xB4 },
	0x9B6D,	{ 0xE6, 0xB2, 0xB5 },
	0x9B6E,	{ 0xE6, 0xB2, 0xB6 },
	0x9B6F,	{ 0xE6, 0xB2, 0xB7 },
	0x9B70,	{ 0xE6, 0xB2, 0xBA },
	0x9B71,	{ 0xE6, 0xB3, 0x80 },
	0x9B72,	{ 0xE6, 0xB3, 0x81 },
	0x9B73,	{ 0xE6, 0xB3, 0x82 },
	0x9B74,	{ 0xE6, 0xB3, 0x83 },
	0x9B75,	{ 0xE6, 0xB3, 0x86 },
	0x9B76,	{ 0xE6, 0xB3, 0x87 },
	0x9B77,	{ 0xE6, 0xB3, 0x88 },
	0x9B78,	{ 0xE6, 0xB3, 0x8B },
	0x9B79,	{ 0xE6, 0xB3, 0x8D },
	0x9B7A,	{ 0xE6, 0xB3, 0x8E },
	0x9B7B,	{ 0xE6, 0xB3, 0x8F },
	0x9B7C,	{ 0xE6, 0xB3, 0x91 },
	0x9B7D,	{ 0xE6, 0xB3, 0x92 },
	0x9B7E,	{ 0xE6, 0xB3, 0x98 },
	0x9B80,	{ 0xE6, 0xB3, 0x99 },
	0x9B81,	{ 0xE6, 0xB3, 0x9A },
	0x9B82,	{ 0xE6, 0xB3, 0x9C },
	0x9B83,	{ 0xE6, 0xB3, 0x9D },
	0x9B84,	{ 0xE6, 0xB3, 0x9F },
	0x9B85,	{ 0xE6, 0xB3, 0xA4 },
	0x9B86,	{ 0xE6, 0xB3, 0xA6 },
	0x9B87,	{ 0xE6, 0xB3, 0xA7 },
	0x9B88,	{ 0xE6, 0xB3, 0xA9 },
	0x9B89,	{ 0xE6, 0xB3, 0xAC },
	0x9B8A,	{ 0xE6, 0xB3, 0xAD },
	0x9B8B,	{ 0xE6, 0xB3, 0xB2 },
	0x9B8C,	{ 0xE6, 0xB3, 0xB4 },
	0x9B8D,	{ 0xE6, 0xB3, 0xB9 },
	0x9B8E,	{ 0xE6, 0xB3, 0xBF },
	0x9B8F,	{ 0xE6, 0xB4, 0x80 },
	0x9B90,	{ 0xE6, 0xB4, 0x82 },
	0x9B91,	{ 0xE6, 0xB4, 0x83 },
	0x9B92,	{ 0xE6, 0xB4, 0x85 },
	0x9B93,	{ 0xE6, 0xB4, 0x86 },
	0x9B94,	{ 0xE6, 0xB4, 0x88 },
	0x9B95,	{ 0xE6, 0xB4, 0x89 },
	0x9B96,	{ 0xE6, 0xB4, 0x8A },
	0x9B97,	{ 0xE6, 0xB4, 0x8D },
	0x9B98,	{ 0xE6, 0xB4, 0x8F },
	0x9B99,	{ 0xE6, 0xB4, 0x90 },
	0x9B9A,	{ 0xE6, 0xB4, 0x91 },
	0x9B9B,	{ 0xE6, 0xB4, 0x93 },
	0x9B9C,	{ 0xE6, 0xB4, 0x94 },
	0x9B9D,	{ 0xE6, 0xB4, 0x95 },
	0x9B9E,	{ 0xE6, 0xB4, 0x96 },
	0x9B9F,	{ 0xE6, 0xB4, 0x98 },
	0x9BA0,	{ 0xE6, 0xB4, 0x9C },
	0x9BA1,	{ 0xE6, 0xB4, 0x9D },
	0x9BA2,	{ 0xE6, 0xB4, 0x9F },
	0x9BA3,	{ 0xE6, 0xB4, 0xA0 },
	0x9BA4,	{ 0xE6, 0xB4, 0xA1 },
	0x9BA5,	{ 0xE6, 0xB4, 0xA2 },
	0x9BA6,	{ 0xE6, 0xB4, 0xA3 },
	0x9BA7,	{ 0xE6, 0xB4, 0xA4 },
	0x9BA8,	{ 0xE6, 0xB4, 0xA6 },
	0x9BA9,	{ 0xE6, 0xB4, 0xA8 },
	0x9BAA,	{ 0xE6, 0xB4, 0xA9 },
	0x9BAB,	{ 0xE6, 0xB4, 0xAC },
	0x9BAC,	{ 0xE6, 0xB4, 0xAD },
	0x9BAD,	{ 0xE6, 0xB4, 0xAF },
	0x9BAE,	{ 0xE6, 0xB4, 0xB0 },
	0x9BAF,	{ 0xE6, 0xB4, 0xB4 },
	0x9BB0,	{ 0xE6, 0xB4, 0xB6 },
	0x9BB1,	{ 0xE6, 0xB4, 0xB7 },
	0x9BB2,	{ 0xE6, 0xB4, 0xB8 },
	0x9BB3,	{ 0xE6, 0xB4, 0xBA },
	0x9BB4,	{ 0xE6, 0xB4, 0xBF },
	0x9BB5,	{ 0xE6, 0xB5, 0x80 },
	0x9BB6,	{ 0xE6, 0xB5, 0x82 },
	0x9BB7,	{ 0xE6, 0xB5, 0x84 },
	0x9BB8,	{ 0xE6, 0xB5, 0x89 },
	0x9BB9,	{ 0xE6, 0xB5, 0x8C },
	0x9BBA,	{ 0xE6, 0xB5, 0x90 },
	0x9BBB,	{ 0xE6, 0xB5, 0x95 },
	0x9BBC,	{ 0xE6, 0xB5, 0x96 },
	0x9BBD,	{ 0xE6, 0xB5, 0x97 },
	0x9BBE,	{ 0xE6, 0xB5, 0x98 },
	0x9BBF,	{ 0xE6, 0xB5, 0x9B },
	0x9BC0,	{ 0xE6, 0xB5, 0x9D },
	0x9BC1,	{ 0xE6, 0xB5, 0x9F },
	0x9BC2,	{ 0xE6, 0xB5, 0xA1 },
	0x9BC3,	{ 0xE6, 0xB5, 0xA2 },
	0x9BC4,	{ 0xE6, 0xB5, 0xA4 },
	0x9BC5,	{ 0xE6, 0xB5, 0xA5 },
	0x9BC6,	{ 0xE6, 0xB5, 0xA7 },
	0x9BC7,	{ 0xE6, 0xB5, 0xA8 },
	0x9BC8,	{ 0xE6, 0xB5, 0xAB },
	0x9BC9,	{ 0xE6, 0xB5, 0xAC },
	0x9BCA,	{ 0xE6, 0xB5, 0xAD },
	0x9BCB,	{ 0xE6, 0xB5, 0xB0 },
	0x9BCC,	{ 0xE6, 0xB5, 0xB1 },
	0x9BCD,	{ 0xE6, 0xB5, 0xB2 },
	0x9BCE,	{ 0xE6, 0xB5, 0xB3 },
	0x9BCF,	{ 0xE6, 0xB5, 0xB5 },
	0x9BD0,	{ 0xE6, 0xB5, 0xB6 },
	0x9BD1,	{ 0xE6, 0xB5, 0xB9 },
	0x9BD2,	{ 0xE6, 0xB5, 0xBA },
	0x9BD3,	{ 0xE6, 0xB5, 0xBB },
	0x9BD4,	{ 0xE6, 0xB5, 0xBD },
	0x9BD5,	{ 0xE6, 0xB5, 0xBE },
	0x9BD6,	{ 0xE6, 0xB5, 0xBF },
	0x9BD7,	{ 0xE6, 0xB6, 0x80 },
	0x9BD8,	{ 0xE6, 0xB6, 0x81 },
	0x9BD9,	{ 0xE6, 0xB6, 0x83 },
	0x9BDA,	{ 0xE6, 0xB6, 0x84 },
	0x9BDB,	{ 0xE6, 0xB6, 0x86 },
	0x9BDC,	{ 0xE6, 0xB6, 0x87 },
	0x9BDD,	{ 0xE6, 0xB6, 0x8A },
	0x9BDE,	{ 0xE6, 0xB6, 0x8B },
	0x9BDF,	{ 0xE6, 0xB6, 0x8D },
	0x9BE0,	{ 0xE6, 0xB6, 0x8F },
	0x9BE1,	{ 0xE6, 0xB6, 0x90 },
	0x9BE2,	{ 0xE6, 0xB6, 0x92 },
	0x9BE3,	{ 0xE6, 0xB6, 0x96 },
	0x9BE4,	{ 0xE6, 0xB6, 0x97 },
	0x9BE5,	{ 0xE6, 0xB6, 0x98 },
	0x9BE6,	{ 0xE6, 0xB6, 0x99 },
	0x9BE7,	{ 0xE6, 0xB6, 0x9A },
	0x9BE8,	{ 0xE6, 0xB6, 0x9C },
	0x9BE9,	{ 0xE6, 0xB6, 0xA2 },
	0x9BEA,	{ 0xE6, 0xB6, 0xA5 },
	0x9BEB,	{ 0xE6, 0xB6, 0xAC },
	0x9BEC,	{ 0xE6, 0xB6, 0xAD },
	0x9BED,	{ 0xE6, 0xB6, 0xB0 },
	0x9BEE,	{ 0xE6, 0xB6, 0xB1 },
	0x9BEF,	{ 0xE6, 0xB6, 0xB3 },
	0x9BF0,	{ 0xE6, 0xB6, 0xB4 },
	0x9BF1,	{ 0xE6, 0xB6, 0xB6 },
	0x9BF2,	{ 0xE6, 0xB6, 0xB7 },
	0x9BF3,	{ 0xE6, 0xB6, 0xB9 },
	0x9BF4,	{ 0xE6, 0xB6, 0xBA },
	0x9BF5,	{ 0xE6, 0xB6, 0xBB },
	0x9BF6,	{ 0xE6, 0xB6, 0xBC },
	0x9BF7,	{ 0xE6, 0xB6, 0xBD },
	0x9BF8,	{ 0xE6, 0xB6, 0xBE },
	0x9BF9,	{ 0xE6, 0xB7, 0x81 },
	0x9BFA,	{ 0xE6, 0xB7, 0x82 },
	0x9BFB,	{ 0xE6, 0xB7, 0x83 },
	0x9BFC,	{ 0xE6, 0xB7, 0x88 },
	0x9BFD,	{ 0xE6, 0xB7, 0x89 },
	0x9BFE,	{ 0xE6, 0xB7, 0x8A },
	0x9C40,	{ 0xE6, 0xB7, 0x8D },
	0x9C41,	{ 0xE6, 0xB7, 0x8E },
	0x9C42,	{ 0xE6, 0xB7, 0x8F },
	0x9C43,	{ 0xE6, 0xB7, 0x90 },
	0x9C44,	{ 0xE6, 0xB7, 0x92 },
	0x9C45,	{ 0xE6, 0xB7, 0x93 },
	0x9C46,	{ 0xE6, 0xB7, 0x94 },
	0x9C47,	{ 0xE6, 0xB7, 0x95 },
	0x9C48,	{ 0xE6, 0xB7, 0x97 },
	0x9C49,	{ 0xE6, 0xB7, 0x9A },
	0x9C4A,	{ 0xE6, 0xB7, 0x9B },
	0x9C4B,	{ 0xE6, 0xB7, 0x9C },
	0x9C4C,	{ 0xE6, 0xB7, 0x9F },
	0x9C4D,	{ 0xE6, 0xB7, 0xA2 },
	0x9C4E,	{ 0xE6, 0xB7, 0xA3 },
	0x9C4F,	{ 0xE6, 0xB7, 0xA5 },
	0x9C50,	{ 0xE6, 0xB7, 0xA7 },
	0x9C51,	{ 0xE6, 0xB7, 0xA8 },
	0x9C52,	{ 0xE6, 0xB7, 0xA9 },
	0x9C53,	{ 0xE6, 0xB7, 0xAA },
	0x9C54,	{ 0xE6, 0xB7, 0xAD },
	0x9C55,	{ 0xE6, 0xB7, 0xAF },
	0x9C56,	{ 0xE6, 0xB7, 0xB0 },
	0x9C57,	{ 0xE6, 0xB7, 0xB2 },
	0x9C58,	{ 0xE6, 0xB7, 0xB4 },
	0x9C59,	{ 0xE6, 0xB7, 0xB5 },
	0x9C5A,	{ 0xE6, 0xB7, 0xB6 },
	0x9C5B,	{ 0xE6, 0xB7, 0xB8 },
	0x9C5C,	{ 0xE6, 0xB7, 0xBA },
	0x9C5D,	{ 0xE6, 0xB7, 0xBD },
	0x9C5E,	{ 0xE6, 0xB7, 0xBE },
	0x9C5F,	{ 0xE6, 0xB7, 0xBF },
	0x9C60,	{ 0xE6, 0xB8, 0x80 },
	0x9C61,	{ 0xE6, 0xB8, 0x81 },
	0x9C62,	{ 0xE6, 0xB8, 0x82 },
	0x9C63,	{ 0xE6, 0xB8, 0x83 },
	0x9C64,	{ 0xE6, 0xB8, 0x84 },
	0x9C65,	{ 0xE6, 0xB8, 0x86 },
	0x9C66,	{ 0xE6, 0xB8, 0x87 },
	0x9C67,	{ 0xE6, 0xB8, 0x88 },
	0x9C68,	{ 0xE6, 0xB8, 0x89 },
	0x9C69,	{ 0xE6, 0xB8, 0x8B },
	0x9C6A,	{ 0xE6, 0xB8, 0x8F },
	0x9C6B,	{ 0xE6, 0xB8, 0x92 },
	0x9C6C,	{ 0xE6, 0xB8, 0x93 },
	0x9C6D,	{ 0xE6, 0xB8, 0x95 },
	0x9C6E,	{ 0xE6, 0xB8, 0x98 },
	0x9C6F,	{ 0xE6, 0xB8, 0x99 },
	0x9C70,	{ 0xE6, 0xB8, 0x9B },
	0x9C71,	{ 0xE6, 0xB8, 0x9C },
	0x9C72,	{ 0xE6, 0xB8, 0x9E },
	0x9C73,	{ 0xE6, 0xB8, 0x9F },
	0x9C74,	{ 0xE6, 0xB8, 0xA2 },
	0x9C75,	{ 0xE6, 0xB8, 0xA6 },
	0x9C76,	{ 0xE6, 0xB8, 0xA7 },
	0x9C77,	{ 0xE6, 0xB8, 0xA8 },
	0x9C78,	{ 0xE6, 0xB8, 0xAA },
	0x9C79,	{ 0xE6, 0xB8, 0xAC },
	0x9C7A,	{ 0xE6, 0xB8, 0xAE },
	0x9C7B,	{ 0xE6, 0xB8, 0xB0 },
	0x9C7C,	{ 0xE6, 0xB8, 0xB1 },
	0x9C7D,	{ 0xE6, 0xB8, 0xB3 },
	0x9C7E,	{ 0xE6, 0xB8, 0xB5 },
	0x9C80,	{ 0xE6, 0xB8, 0xB6 },
	0x9C81,	{ 0xE6, 0xB8, 0xB7 },
	0x9C82,	{ 0xE6, 0xB8, 0xB9 },
	0x9C83,	{ 0xE6, 0xB8, 0xBB },
	0x9C84,	{ 0xE6, 0xB8, 0xBC },
	0x9C85,	{ 0xE6, 0xB8, 0xBD },
	0x9C86,	{ 0xE6, 0xB8, 0xBE },
	0x9C87,	{ 0xE6, 0xB8, 0xBF },
	0x9C88,	{ 0xE6, 0xB9, 0x80 },
	0x9C89,	{ 0xE6, 0xB9, 0x81 },
	0x9C8A,	{ 0xE6, 0xB9, 0x82 },
	0x9C8B,	{ 0xE6, 0xB9, 0x85 },
	0x9C8C,	{ 0xE6, 0xB9, 0x86 },
	0x9C8D,	{ 0xE6, 0xB9, 0x87 },
	0x9C8E,	{ 0xE6, 0xB9, 0x88 },
	0x9C8F,	{ 0xE6, 0xB9, 0x89 },
	0x9C90,	{ 0xE6, 0xB9, 0x8A },
	0x9C91,	{ 0xE6, 0xB9, 0x8B },
	0x9C92,	{ 0xE6, 0xB9, 0x8C },
	0x9C93,	{ 0xE6, 0xB9, 0x8F },
	0x9C94,	{ 0xE6, 0xB9, 0x90 },
	0x9C95,	{ 0xE6, 0xB9, 0x91 },
	0x9C96,	{ 0xE6, 0xB9, 0x92 },
	0x9C97,	{ 0xE6, 0xB9, 0x95 },
	0x9C98,	{ 0xE6, 0xB9, 0x97 },
	0x9C99,	{ 0xE6, 0xB9, 0x99 },
	0x9C9A,	{ 0xE6, 0xB9, 0x9A },
	0x9C9B,	{ 0xE6, 0xB9, 0x9C },
	0x9C9C,	{ 0xE6, 0xB9, 0x9D },
	0x9C9D,	{ 0xE6, 0xB9, 0x9E },
	0x9C9E,	{ 0xE6, 0xB9, 0xA0 },
	0x9C9F,	{ 0xE6, 0xB9, 0xA1 },
	0x9CA0,	{ 0xE6, 0xB9, 0xA2 },
	0x9CA1,	{ 0xE6, 0xB9, 0xA3 },
	0x9CA2,	{ 0xE6, 0xB9, 0xA4 },
	0x9CA3,	{ 0xE6, 0xB9, 0xA5 },
	0x9CA4,	{ 0xE6, 0xB9, 0xA6 },
	0x9CA5,	{ 0xE6, 0xB9, 0xA7 },
	0x9CA6,	{ 0xE6, 0xB9, 0xA8 },
	0x9CA7,	{ 0xE6, 0xB9, 0xA9 },
	0x9CA8,	{ 0xE6, 0xB9, 0xAA },
	0x9CA9,	{ 0xE6, 0xB9, 0xAC },
	0x9CAA,	{ 0xE6, 0xB9, 0xAD },
	0x9CAB,	{ 0xE6, 0xB9, 0xAF },
	0x9CAC,	{ 0xE6, 0xB9, 0xB0 },
	0x9CAD,	{ 0xE6, 0xB9, 0xB1 },
	0x9CAE,	{ 0xE6, 0xB9, 0xB2 },
	0x9CAF,	{ 0xE6, 0xB9, 0xB3 },
	0x9CB0,	{ 0xE6, 0xB9, 0xB4 },
	0x9CB1,	{ 0xE6, 0xB9, 0xB5 },
	0x9CB2,	{ 0xE6, 0xB9, 0xB6 },
	0x9CB3,	{ 0xE6, 0xB9, 0xB7 },
	0x9CB4,	{ 0xE6, 0xB9, 0xB8 },
	0x9CB5,	{ 0xE6, 0xB9, 0xB9 },
	0x9CB6,	{ 0xE6, 0xB9, 0xBA },
	0x9CB7,	{ 0xE6, 0xB9, 0xBB },
	0x9CB8,	{ 0xE6, 0xB9, 0xBC },
	0x9CB9,	{ 0xE6, 0xB9, 0xBD },
	0x9CBA,	{ 0xE6, 0xBA, 0x80 },
	0x9CBB,	{ 0xE6, 0xBA, 0x81 },
	0x9CBC,	{ 0xE6, 0xBA, 0x82 },
	0x9CBD,	{ 0xE6, 0xBA, 0x84 },
	0x9CBE,	{ 0xE6, 0xBA, 0x87 },
	0x9CBF,	{ 0xE6, 0xBA, 0x88 },
	0x9CC0,	{ 0xE6, 0xBA, 0x8A },
	0x9CC1,	{ 0xE6, 0xBA, 0x8B },
	0x9CC2,	{ 0xE6, 0xBA, 0x8C },
	0x9CC3,	{ 0xE6, 0xBA, 0x8D },
	0x9CC4,	{ 0xE6, 0xBA, 0x8E },
	0x9CC5,	{ 0xE6, 0xBA, 0x91 },
	0x9CC6,	{ 0xE6, 0xBA, 0x92 },
	0x9CC7,	{ 0xE6, 0xBA, 0x93 },
	0x9CC8,	{ 0xE6, 0xBA, 0x94 },
	0x9CC9,	{ 0xE6, 0xBA, 0x95 },
	0x9CCA,	{ 0xE6, 0xBA, 0x96 },
	0x9CCB,	{ 0xE6, 0xBA, 0x97 },
	0x9CCC,	{ 0xE6, 0xBA, 0x99 },
	0x9CCD,	{ 0xE6, 0xBA, 0x9A },
	0x9CCE,	{ 0xE6, 0xBA, 0x9B },
	0x9CCF,	{ 0xE6, 0xBA, 0x9D },
	0x9CD0,	{ 0xE6, 0xBA, 0x9E },
	0x9CD1,	{ 0xE6, 0xBA, 0xA0 },
	0x9CD2,	{ 0xE6, 0xBA, 0xA1 },
	0x9CD3,	{ 0xE6, 0xBA, 0xA3 },
	0x9CD4,	{ 0xE6, 0xBA, 0xA4 },
	0x9CD5,	{ 0xE6, 0xBA, 0xA6 },
	0x9CD6,	{ 0xE6, 0xBA, 0xA8 },
	0x9CD7,	{ 0xE6, 0xBA, 0xA9 },
	0x9CD8,	{ 0xE6, 0xBA, 0xAB },
	0x9CD9,	{ 0xE6, 0xBA, 0xAC },
	0x9CDA,	{ 0xE6, 0xBA, 0xAD },
	0x9CDB,	{ 0xE6, 0xBA, 0xAE },
	0x9CDC,	{ 0xE6, 0xBA, 0xB0 },
	0x9CDD,	{ 0xE6, 0xBA, 0xB3 },
	0x9CDE,	{ 0xE6, 0xBA, 0xB5 },
	0x9CDF,	{ 0xE6, 0xBA, 0xB8 },
	0x9CE0,	{ 0xE6, 0xBA, 0xB9 },
	0x9CE1,	{ 0xE6, 0xBA, 0xBC },
	0x9CE2,	{ 0xE6, 0xBA, 0xBE },
	0x9CE3,	{ 0xE6, 0xBA, 0xBF },
	0x9CE4,	{ 0xE6, 0xBB, 0x80 },
	0x9CE5,	{ 0xE6, 0xBB, 0x83 },
	0x9CE6,	{ 0xE6, 0xBB, 0x84 },
	0x9CE7,	{ 0xE6, 0xBB, 0x85 },
	0x9CE8,	{ 0xE6, 0xBB, 0x86 },
	0x9CE9,	{ 0xE6, 0xBB, 0x88 },
	0x9CEA,	{ 0xE6, 0xBB, 0x89 },
	0x9CEB,	{ 0xE6, 0xBB, 0x8A },
	0x9CEC,	{ 0xE6, 0xBB, 0x8C },
	0x9CED,	{ 0xE6, 0xBB, 0x8D },
	0x9CEE,	{ 0xE6, 0xBB, 0x8E },
	0x9CEF,	{ 0xE6, 0xBB, 0x90 },
	0x9CF0,	{ 0xE6, 0xBB, 0x92 },
	0x9CF1,	{ 0xE6, 0xBB, 0x96 },
	0x9CF2,	{ 0xE6, 0xBB, 0x98 },
	0x9CF3,	{ 0xE6, 0xBB, 0x99 },
	0x9CF4,	{ 0xE6, 0xBB, 0x9B },
	0x9CF5,	{ 0xE6, 0xBB, 0x9C },
	0x9CF6,	{ 0xE6, 0xBB, 0x9D },
	0x9CF7,	{ 0xE6, 0xBB, 0xA3 },
	0x9CF8,	{ 0xE6, 0xBB, 0xA7 },
	0x9CF9,	{ 0xE6, 0xBB, 0xAA },
	0x9CFA,	{ 0xE6, 0xBB, 0xAB },
	0x9CFB,	{ 0xE6, 0xBB, 0xAC },
	0x9CFC,	{ 0xE6, 0xBB, 0xAD },
	0x9CFD,	{ 0xE6, 0xBB, 0xAE },
	0x9CFE,	{ 0xE6, 0xBB, 0xAF },
	0x9D40,	{ 0xE6, 0xBB, 0xB0 },
	0x9D41,	{ 0xE6, 0xBB, 0xB1 },
	0x9D42,	{ 0xE6, 0xBB, 0xB2 },
	0x9D43,	{ 0xE6, 0xBB, 0xB3 },
	0x9D44,	{ 0xE6, 0xBB, 0xB5 },
	0x9D45,	{ 0xE6, 0xBB, 0xB6 },
	0x9D46,	{ 0xE6, 0xBB, 0xB7 },
	0x9D47,	{ 0xE6, 0xBB, 0xB8 },
	0x9D48,	{ 0xE6, 0xBB, 0xBA },
	0x9D49,	{ 0xE6, 0xBB, 0xBB },
	0x9D4A,	{ 0xE6, 0xBB, 0xBC },
	0x9D4B,	{ 0xE6, 0xBB, 0xBD },
	0x9D4C,	{ 0xE6, 0xBB, 0xBE },
	0x9D4D,	{ 0xE6, 0xBB, 0xBF },
	0x9D4E,	{ 0xE6, 0xBC, 0x80 },
	0x9D4F,	{ 0xE6, 0xBC, 0x81 },
	0x9D50,	{ 0xE6, 0xBC, 0x83 },
	0x9D51,	{ 0xE6, 0xBC, 0x84 },
	0x9D52,	{ 0xE6, 0xBC, 0x85 },
	0x9D53,	{ 0xE6, 0xBC, 0x87 },
	0x9D54,	{ 0xE6, 0xBC, 0x88 },
	0x9D55,	{ 0xE6, 0xBC, 0x8A },
	0x9D56,	{ 0xE6, 0xBC, 0x8B },
	0x9D57,	{ 0xE6, 0xBC, 0x8C },
	0x9D58,	{ 0xE6, 0xBC, 0x8D },
	0x9D59,	{ 0xE6, 0xBC, 0x8E },
	0x9D5A,	{ 0xE6, 0xBC, 0x90 },
	0x9D5B,	{ 0xE6, 0xBC, 0x91 },
	0x9D5C,	{ 0xE6, 0xBC, 0x92 },
	0x9D5D,	{ 0xE6, 0xBC, 0x96 },
	0x9D5E,	{ 0xE6, 0xBC, 0x97 },
	0x9D5F,	{ 0xE6, 0xBC, 0x98 },
	0x9D60,	{ 0xE6, 0xBC, 0x99 },
	0x9D61,	{ 0xE6, 0xBC, 0x9A },
	0x9D62,	{ 0xE6, 0xBC, 0x9B },
	0x9D63,	{ 0xE6, 0xBC, 0x9C },
	0x9D64,	{ 0xE6, 0xBC, 0x9D },
	0x9D65,	{ 0xE6, 0xBC, 0x9E },
	0x9D66,	{ 0xE6, 0xBC, 0x9F },
	0x9D67,	{ 0xE6, 0xBC, 0xA1 },
	0x9D68,	{ 0xE6, 0xBC, 0xA2 },
	0x9D69,	{ 0xE6, 0xBC, 0xA3 },
	0x9D6A,	{ 0xE6, 0xBC, 0xA5 },
	0x9D6B,	{ 0xE6, 0xBC, 0xA6 },
	0x9D6C,	{ 0xE6, 0xBC, 0xA7 },
	0x9D6D,	{ 0xE6, 0xBC, 0xA8 },
	0x9D6E,	{ 0xE6, 0xBC, 0xAC },
	0x9D6F,	{ 0xE6, 0xBC, 0xAE },
	0x9D70,	{ 0xE6, 0xBC, 0xB0 },
	0x9D71,	{ 0xE6, 0xBC, 0xB2 },
	0x9D72,	{ 0xE6, 0xBC, 0xB4 },
	0x9D73,	{ 0xE6, 0xBC, 0xB5 },
	0x9D74,	{ 0xE6, 0xBC, 0xB7 },
	0x9D75,	{ 0xE6, 0xBC, 0xB8 },
	0x9D76,	{ 0xE6, 0xBC, 0xB9 },
	0x9D77,	{ 0xE6, 0xBC, 0xBA },
	0x9D78,	{ 0xE6, 0xBC, 0xBB },
	0x9D79,	{ 0xE6, 0xBC, 0xBC },
	0x9D7A,	{ 0xE6, 0xBC, 0xBD },
	0x9D7B,	{ 0xE6, 0xBC, 0xBF },
	0x9D7C,	{ 0xE6, 0xBD, 0x80 },
	0x9D7D,	{ 0xE6, 0xBD, 0x81 },
	0x9D7E,	{ 0xE6, 0xBD, 0x82 },
	0x9D80,	{ 0xE6, 0xBD, 0x83 },
	0x9D81,	{ 0xE6, 0xBD, 0x84 },
	0x9D82,	{ 0xE6, 0xBD, 0x85 },
	0x9D83,	{ 0xE6, 0xBD, 0x88 },
	0x9D84,	{ 0xE6, 0xBD, 0x89 },
	0x9D85,	{ 0xE6, 0xBD, 0x8A },
	0x9D86,	{ 0xE6, 0xBD, 0x8C },
	0x9D87,	{ 0xE6, 0xBD, 0x8E },
	0x9D88,	{ 0xE6, 0xBD, 0x8F },
	0x9D89,	{ 0xE6, 0xBD, 0x90 },
	0x9D8A,	{ 0xE6, 0xBD, 0x91 },
	0x9D8B,	{ 0xE6, 0xBD, 0x92 },
	0x9D8C,	{ 0xE6, 0xBD, 0x93 },
	0x9D8D,	{ 0xE6, 0xBD, 0x94 },
	0x9D8E,	{ 0xE6, 0xBD, 0x95 },
	0x9D8F,	{ 0xE6, 0xBD, 0x96 },
	0x9D90,	{ 0xE6, 0xBD, 0x97 },
	0x9D91,	{ 0xE6, 0xBD, 0x99 },
	0x9D92,	{ 0xE6, 0xBD, 0x9A },
	0x9D93,	{ 0xE6, 0xBD, 0x9B },
	0x9D94,	{ 0xE6, 0xBD, 0x9D },
	0x9D95,	{ 0xE6, 0xBD, 0x9F },
	0x9D96,	{ 0xE6, 0xBD, 0xA0 },
	0x9D97,	{ 0xE6, 0xBD, 0xA1 },
	0x9D98,	{ 0xE6, 0xBD, 0xA3 },
	0x9D99,	{ 0xE6, 0xBD, 0xA4 },
	0x9D9A,	{ 0xE6, 0xBD, 0xA5 },
	0x9D9B,	{ 0xE6, 0xBD, 0xA7 },
	0x9D9C,	{ 0xE6, 0xBD, 0xA8 },
	0x9D9D,	{ 0xE6, 0xBD, 0xA9 },
	0x9D9E,	{ 0xE6, 0xBD, 0xAA },
	0x9D9F,	{ 0xE6, 0xBD, 0xAB },
	0x9DA0,	{ 0xE6, 0xBD, 0xAC },
	0x9DA1,	{ 0xE6, 0xBD, 0xAF },
	0x9DA2,	{ 0xE6, 0xBD, 0xB0 },
	0x9DA3,	{ 0xE6, 0xBD, 0xB1 },
	0x9DA4,	{ 0xE6, 0xBD, 0xB3 },
	0x9DA5,	{ 0xE6, 0xBD, 0xB5 },
	0x9DA6,	{ 0xE6, 0xBD, 0xB6 },
	0x9DA7,	{ 0xE6, 0xBD, 0xB7 },
	0x9DA8,	{ 0xE6, 0xBD, 0xB9 },
	0x9DA9,	{ 0xE6, 0xBD, 0xBB },
	0x9DAA,	{ 0xE6, 0xBD, 0xBD },
	0x9DAB,	{ 0xE6, 0xBD, 0xBE },
	0x9DAC,	{ 0xE6, 0xBD, 0xBF },
	0x9DAD,	{ 0xE6, 0xBE, 0x80 },
	0x9DAE,	{ 0xE6, 0xBE, 0x81 },
	0x9DAF,	{ 0xE6, 0xBE, 0x82 },
	0x9DB0,	{ 0xE6, 0xBE, 0x83 },
	0x9DB1,	{ 0xE6, 0xBE, 0x85 },
	0x9DB2,	{ 0xE6, 0xBE, 0x86 },
	0x9DB3,	{ 0xE6, 0xBE, 0x87 },
	0x9DB4,	{ 0xE6, 0xBE, 0x8A },
	0x9DB5,	{ 0xE6, 0xBE, 0x8B },
	0x9DB6,	{ 0xE6, 0xBE, 0x8F },
	0x9DB7,	{ 0xE6, 0xBE, 0x90 },
	0x9DB8,	{ 0xE6, 0xBE, 0x91 },
	0x9DB9,	{ 0xE6, 0xBE, 0x92 },
	0x9DBA,	{ 0xE6, 0xBE, 0x93 },
	0x9DBB,	{ 0xE6, 0xBE, 0x94 },
	0x9DBC,	{ 0xE6, 0xBE, 0x95 },
	0x9DBD,	{ 0xE6, 0xBE, 0x96 },
	0x9DBE,	{ 0xE6, 0xBE, 0x97 },
	0x9DBF,	{ 0xE6, 0xBE, 0x98 },
	0x9DC0,	{ 0xE6, 0xBE, 0x99 },
	0x9DC1,	{ 0xE6, 0xBE, 0x9A },
	0x9DC2,	{ 0xE6, 0xBE, 0x9B },
	0x9DC3,	{ 0xE6, 0xBE, 0x9D },
	0x9DC4,	{ 0xE6, 0xBE, 0x9E },
	0x9DC5,	{ 0xE6, 0xBE, 0x9F },
	0x9DC6,	{ 0xE6, 0xBE, 0xA0 },
	0x9DC7,	{ 0xE6, 0xBE, 0xA2 },
	0x9DC8,	{ 0xE6, 0xBE, 0xA3 },
	0x9DC9,	{ 0xE6, 0xBE, 0xA4 },
	0x9DCA,	{ 0xE6, 0xBE, 0xA5 },
	0x9DCB,	{ 0xE6, 0xBE, 0xA6 },
	0x9DCC,	{ 0xE6, 0xBE, 0xA8 },
	0x9DCD,	{ 0xE6, 0xBE, 0xA9 },
	0x9DCE,	{ 0xE6, 0xBE, 0xAA },
	0x9DCF,	{ 0xE6, 0xBE, 0xAB },
	0x9DD0,	{ 0xE6, 0xBE, 0xAC },
	0x9DD1,	{ 0xE6, 0xBE, 0xAD },
	0x9DD2,	{ 0xE6, 0xBE, 0xAE },
	0x9DD3,	{ 0xE6, 0xBE, 0xAF },
	0x9DD4,	{ 0xE6, 0xBE, 0xB0 },
	0x9DD5,	{ 0xE6, 0xBE, 0xB1 },
	0x9DD6,	{ 0xE6, 0xBE, 0xB2 },
	0x9DD7,	{ 0xE6, 0xBE, 0xB4 },
	0x9DD8,	{ 0xE6, 0xBE, 0xB5 },
	0x9DD9,	{ 0xE6, 0xBE, 0xB7 },
	0x9DDA,	{ 0xE6, 0xBE, 0xB8 },
	0x9DDB,	{ 0xE6, 0xBE, 0xBA },
	0x9DDC,	{ 0xE6, 0xBE, 0xBB },
	0x9DDD,	{ 0xE6, 0xBE, 0xBC },
	0x9DDE,	{ 0xE6, 0xBE, 0xBD },
	0x9DDF,	{ 0xE6, 0xBE, 0xBE },
	0x9DE0,	{ 0xE6, 0xBE, 0xBF },
	0x9DE1,	{ 0xE6, 0xBF, 0x81 },
	0x9DE2,	{ 0xE6, 0xBF, 0x83 },
	0x9DE3,	{ 0xE6, 0xBF, 0x84 },
	0x9DE4,	{ 0xE6, 0xBF, 0x85 },
	0x9DE5,	{ 0xE6, 0xBF, 0x86 },
	0x9DE6,	{ 0xE6, 0xBF, 0x87 },
	0x9DE7,	{ 0xE6, 0xBF, 0x88 },
	0x9DE8,	{ 0xE6, 0xBF, 0x8A },
	0x9DE9,	{ 0xE6, 0xBF, 0x8B },
	0x9DEA,	{ 0xE6, 0xBF, 0x8C },
	0x9DEB,	{ 0xE6, 0xBF, 0x8D },
	0x9DEC,	{ 0xE6, 0xBF, 0x8E },
	0x9DED,	{ 0xE6, 0xBF, 0x8F },
	0x9DEE,	{ 0xE6, 0xBF, 0x90 },
	0x9DEF,	{ 0xE6, 0xBF, 0x93 },
	0x9DF0,	{ 0xE6, 0xBF, 0x94 },
	0x9DF1,	{ 0xE6, 0xBF, 0x95 },
	0x9DF2,	{ 0xE6, 0xBF, 0x96 },
	0x9DF3,	{ 0xE6, 0xBF, 0x97 },
	0x9DF4,	{ 0xE6, 0xBF, 0x98 },
	0x9DF5,	{ 0xE6, 0xBF, 0x99 },
	0x9DF6,	{ 0xE6, 0xBF, 0x9A },
	0x9DF7,	{ 0xE6, 0xBF, 0x9B },
	0x9DF8,	{ 0xE6, 0xBF, 0x9C },
	0x9DF9,	{ 0xE6, 0xBF, 0x9D },
	0x9DFA,	{ 0xE6, 0xBF, 0x9F },
	0x9DFB,	{ 0xE6, 0xBF, 0xA2 },
	0x9DFC,	{ 0xE6, 0xBF, 0xA3 },
	0x9DFD,	{ 0xE6, 0xBF, 0xA4 },
	0x9DFE,	{ 0xE6, 0xBF, 0xA5 },
	0x9E40,	{ 0xE6, 0xBF, 0xA6 },
	0x9E41,	{ 0xE6, 0xBF, 0xA7 },
	0x9E42,	{ 0xE6, 0xBF, 0xA8 },
	0x9E43,	{ 0xE6, 0xBF, 0xA9 },
	0x9E44,	{ 0xE6, 0xBF, 0xAA },
	0x9E45,	{ 0xE6, 0xBF, 0xAB },
	0x9E46,	{ 0xE6, 0xBF, 0xAC },
	0x9E47,	{ 0xE6, 0xBF, 0xAD },
	0x9E48,	{ 0xE6, 0xBF, 0xB0 },
	0x9E49,	{ 0xE6, 0xBF, 0xB1 },
	0x9E4A,	{ 0xE6, 0xBF, 0xB2 },
	0x9E4B,	{ 0xE6, 0xBF, 0xB3 },
	0x9E4C,	{ 0xE6, 0xBF, 0xB4 },
	0x9E4D,	{ 0xE6, 0xBF, 0xB5 },
	0x9E4E,	{ 0xE6, 0xBF, 0xB6 },
	0x9E4F,	{ 0xE6, 0xBF, 0xB7 },
	0x9E50,	{ 0xE6, 0xBF, 0xB8 },
	0x9E51,	{ 0xE6, 0xBF, 0xB9 },
	0x9E52,	{ 0xE6, 0xBF, 0xBA },
	0x9E53,	{ 0xE6, 0xBF, 0xBB },
	0x9E54,	{ 0xE6, 0xBF, 0xBC },
	0x9E55,	{ 0xE6, 0xBF, 0xBD },
	0x9E56,	{ 0xE6, 0xBF, 0xBE },
	0x9E57,	{ 0xE6, 0xBF, 0xBF },
	0x9E58,	{ 0xE7, 0x80, 0x80 },
	0x9E59,	{ 0xE7, 0x80, 0x81 },
	0x9E5A,	{ 0xE7, 0x80, 0x82 },
	0x9E5B,	{ 0xE7, 0x80, 0x83 },
	0x9E5C,	{ 0xE7, 0x80, 0x84 },
	0x9E5D,	{ 0xE7, 0x80, 0x85 },
	0x9E5E,	{ 0xE7, 0x80, 0x86 },
	0x9E5F,	{ 0xE7, 0x80, 0x87 },
	0x9E60,	{ 0xE7, 0x80, 0x88 },
	0x9E61,	{ 0xE7, 0x80, 0x89 },
	0x9E62,	{ 0xE7, 0x80, 0x8A },
	0x9E63,	{ 0xE7, 0x80, 0x8B },
	0x9E64,	{ 0xE7, 0x80, 0x8C },
	0x9E65,	{ 0xE7, 0x80, 0x8D },
	0x9E66,	{ 0xE7, 0x80, 0x8E },
	0x9E67,	{ 0xE7, 0x80, 0x8F },
	0x9E68,	{ 0xE7, 0x80, 0x90 },
	0x9E69,	{ 0xE7, 0x80, 0x92 },
	0x9E6A,	{ 0xE7, 0x80, 0x93 },
	0x9E6B,	{ 0xE7, 0x80, 0x94 },
	0x9E6C,	{ 0xE7, 0x80, 0x95 },
	0x9E6D,	{ 0xE7, 0x80, 0x96 },
	0x9E6E,	{ 0xE7, 0x80, 0x97 },
	0x9E6F,	{ 0xE7, 0x80, 0x98 },
	0x9E70,	{ 0xE7, 0x80, 0x99 },
	0x9E71,	{ 0xE7, 0x80, 0x9C },
	0x9E72,	{ 0xE7, 0x80, 0x9D },
	0x9E73,	{ 0xE7, 0x80, 0x9E },
	0x9E74,	{ 0xE7, 0x80, 0x9F },
	0x9E75,	{ 0xE7, 0x80, 0xA0 },
	0x9E76,	{ 0xE7, 0x80, 0xA1 },
	0x9E77,	{ 0xE7, 0x80, 0xA2 },
	0x9E78,	{ 0xE7, 0x80, 0xA4 },
	0x9E79,	{ 0xE7, 0x80, 0xA5 },
	0x9E7A,	{ 0xE7, 0x80, 0xA6 },
	0x9E7B,	{ 0xE7, 0x80, 0xA7 },
	0x9E7C,	{ 0xE7, 0x80, 0xA8 },
	0x9E7D,	{ 0xE7, 0x80, 0xA9 },
	0x9E7E,	{ 0xE7, 0x80, 0xAA },
	0x9E80,	{ 0xE7, 0x80, 0xAB },
	0x9E81,	{ 0xE7, 0x80, 0xAC },
	0x9E82,	{ 0xE7, 0x80, 0xAD },
	0x9E83,	{ 0xE7, 0x80, 0xAE },
	0x9E84,	{ 0xE7, 0x80, 0xAF },
	0x9E85,	{ 0xE7, 0x80, 0xB0 },
	0x9E86,	{ 0xE7, 0x80, 0xB1 },
	0x9E87,	{ 0xE7, 0x80, 0xB2 },
	0x9E88,	{ 0xE7, 0x80, 0xB3 },
	0x9E89,	{ 0xE7, 0x80, 0xB4 },
	0x9E8A,	{ 0xE7, 0x80, 0xB6 },
	0x9E8B,	{ 0xE7, 0x80, 0xB7 },
	0x9E8C,	{ 0xE7, 0x80, 0xB8 },
	0x9E8D,	{ 0xE7, 0x80, 0xBA },
	0x9E8E,	{ 0xE7, 0x80, 0xBB },
	0x9E8F,	{ 0xE7, 0x80, 0xBC },
	0x9E90,	{ 0xE7, 0x80, 0xBD },
	0x9E91,	{ 0xE7, 0x80, 0xBE },
	0x9E92,	{ 0xE7, 0x80, 0xBF },
	0x9E93,	{ 0xE7, 0x81, 0x80 },
	0x9E94,	{ 0xE7, 0x81, 0x81 },
	0x9E95,	{ 0xE7, 0x81, 0x82 },
	0x9E96,	{ 0xE7, 0x81, 0x83 },
	0x9E97,	{ 0xE7, 0x81, 0x84 },
	0x9E98,	{ 0xE7, 0x81, 0x85 },
	0x9E99,	{ 0xE7, 0x81, 0x86 },
	0x9E9A,	{ 0xE7, 0x81, 0x87 },
	0x9E9B,	{ 0xE7, 0x81, 0x88 },
	0x9E9C,	{ 0xE7, 0x81, 0x89 },
	0x9E9D,	{ 0xE7, 0x81, 0x8A },
	0x9E9E,	{ 0xE7, 0x81, 0x8B },
	0x9E9F,	{ 0xE7, 0x81, 0x8D },
	0x9EA0,	{ 0xE7, 0x81, 0x8E },
	0x9EA1,	{ 0xE7, 0x81, 0x90 },
	0x9EA2,	{ 0xE7, 0x81, 0x91 },
	0x9EA3,	{ 0xE7, 0x81, 0x92 },
	0x9EA4,	{ 0xE7, 0x81, 0x93 },
	0x9EA5,	{ 0xE7, 0x81, 0x94 },
	0x9EA6,	{ 0xE7, 0x81, 0x95 },
	0x9EA7,	{ 0xE7, 0x81, 0x96 },
	0x9EA8,	{ 0xE7, 0x81, 0x97 },
	0x9EA9,	{ 0xE7, 0x81, 0x98 },
	0x9EAA,	{ 0xE7, 0x81, 0x99 },
	0x9EAB,	{ 0xE7, 0x81, 0x9A },
	0x9EAC,	{ 0xE7, 0x81, 0x9B },
	0x9EAD,	{ 0xE7, 0x81, 0x9C },
	0x9EAE,	{ 0xE7, 0x81, 0x9D },
	0x9EAF,	{ 0xE7, 0x81, 0x9F },
	0x9EB0,	{ 0xE7, 0x81, 0xA0 },
	0x9EB1,	{ 0xE7, 0x81, 0xA1 },
	0x9EB2,	{ 0xE7, 0x81, 0xA2 },
	0x9EB3,	{ 0xE7, 0x81, 0xA3 },
	0x9EB4,	{ 0xE7, 0x81, 0xA4 },
	0x9EB5,	{ 0xE7, 0x81, 0xA5 },
	0x9EB6,	{ 0xE7, 0x81, 0xA6 },
	0x9EB7,	{ 0xE7, 0x81, 0xA7 },
	0x9EB8,	{ 0xE7, 0x81, 0xA8 },
	0x9EB9,	{ 0xE7, 0x81, 0xA9 },
	0x9EBA,	{ 0xE7, 0x81, 0xAA },
	0x9EBB,	{ 0xE7, 0x81, 0xAE },
	0x9EBC,	{ 0xE7, 0x81, 0xB1 },
	0x9EBD,	{ 0xE7, 0x81, 0xB2 },
	0x9EBE,	{ 0xE7, 0x81, 0xB3 },
	0x9EBF,	{ 0xE7, 0x81, 0xB4 },
	0x9EC0,	{ 0xE7, 0x81, 0xB7 },
	0x9EC1,	{ 0xE7, 0x81, 0xB9 },
	0x9EC2,	{ 0xE7, 0x81, 0xBA },
	0x9EC3,	{ 0xE7, 0x81, 0xBB },
	0x9EC4,	{ 0xE7, 0x81, 0xBD },
	0x9EC5,	{ 0xE7, 0x82, 0x81 },
	0x9EC6,	{ 0xE7, 0x82, 0x82 },
	0x9EC7,	{ 0xE7, 0x82, 0x83 },
	0x9EC8,	{ 0xE7, 0x82, 0x84 },
	0x9EC9,	{ 0xE7, 0x82, 0x86 },
	0x9ECA,	{ 0xE7, 0x82, 0x87 },
	0x9ECB,	{ 0xE7, 0x82, 0x88 },
	0x9ECC,	{ 0xE7, 0x82, 0x8B },
	0x9ECD,	{ 0xE7, 0x82, 0x8C },
	0x9ECE,	{ 0xE7, 0x82, 0x8D },
	0x9ECF,	{ 0xE7, 0x82, 0x8F },
	0x9ED0,	{ 0xE7, 0x82, 0x90 },
	0x9ED1,	{ 0xE7, 0x82, 0x91 },
	0x9ED2,	{ 0xE7, 0x82, 0x93 },
	0x9ED3,	{ 0xE7, 0x82, 0x97 },
	0x9ED4,	{ 0xE7, 0x82, 0x98 },
	0x9ED5,	{ 0xE7, 0x82, 0x9A },
	0x9ED6,	{ 0xE7, 0x82, 0x9B },
	0x9ED7,	{ 0xE7, 0x82, 0x9E },
	0x9ED8,	{ 0xE7, 0x82, 0x9F },
	0x9ED9,	{ 0xE7, 0x82, 0xA0 },
	0x9EDA,	{ 0xE7, 0x82, 0xA1 },
	0x9EDB,	{ 0xE7, 0x82, 0xA2 },
	0x9EDC,	{ 0xE7, 0x82, 0xA3 },
	0x9EDD,	{ 0xE7, 0x82, 0xA4 },
	0x9EDE,	{ 0xE7, 0x82, 0xA5 },
	0x9EDF,	{ 0xE7, 0x82, 0xA6 },
	0x9EE0,	{ 0xE7, 0x82, 0xA7 },
	0x9EE1,	{ 0xE7, 0x82, 0xA8 },
	0x9EE2,	{ 0xE7, 0x82, 0xA9 },
	0x9EE3,	{ 0xE7, 0x82, 0xAA },
	0x9EE4,	{ 0xE7, 0x82, 0xB0 },
	0x9EE5,	{ 0xE7, 0x82, 0xB2 },
	0x9EE6,	{ 0xE7, 0x82, 0xB4 },
	0x9EE7,	{ 0xE7, 0x82, 0xB5 },
	0x9EE8,	{ 0xE7, 0x82, 0xB6 },
	0x9EE9,	{ 0xE7, 0x82, 0xBA },
	0x9EEA,	{ 0xE7, 0x82, 0xBE },
	0x9EEB,	{ 0xE7, 0x82, 0xBF },
	0x9EEC,	{ 0xE7, 0x83, 0x84 },
	0x9EED,	{ 0xE7, 0x83, 0x85 },
	0x9EEE,	{ 0xE7, 0x83, 0x86 },
	0x9EEF,	{ 0xE7, 0x83, 0x87 },
	0x9EF0,	{ 0xE7, 0x83, 0x89 },
	0x9EF1,	{ 0xE7, 0x83, 0x8B },
	0x9EF2,	{ 0xE7, 0x83, 0x8C },
	0x9EF3,	{ 0xE7, 0x83, 0x8D },
	0x9EF4,	{ 0xE7, 0x83, 0x8E },
	0x9EF5,	{ 0xE7, 0x83, 0x8F },
	0x9EF6,	{ 0xE7, 0x83, 0x90 },
	0x9EF7,	{ 0xE7, 0x83, 0x91 },
	0x9EF8,	{ 0xE7, 0x83, 0x92 },
	0x9EF9,	{ 0xE7, 0x83, 0x93 },
	0x9EFA,	{ 0xE7, 0x83, 0x94 },
	0x9EFB,	{ 0xE7, 0x83, 0x95 },
	0x9EFC,	{ 0xE7, 0x83, 0x96 },
	0x9EFD,	{ 0xE7, 0x83, 0x97 },
	0x9EFE,	{ 0xE7, 0x83, 0x9A },
	0x9F40,	{ 0xE7, 0x83, 0x9C },
	0x9F41,	{ 0xE7, 0x83, 0x9D },
	0x9F42,	{ 0xE7, 0x83, 0x9E },
	0x9F43,	{ 0xE7, 0x83, 0xA0 },
	0x9F44,	{ 0xE7, 0x83, 0xA1 },
	0x9F45,	{ 0xE7, 0x83, 0xA2 },
	0x9F46,	{ 0xE7, 0x83, 0xA3 },
	0x9F47,	{ 0xE7, 0x83, 0xA5 },
	0x9F48,	{ 0xE7, 0x83, 0xAA },
	0x9F49,	{ 0xE7, 0x83, 0xAE },
	0x9F4A,	{ 0xE7, 0x83, 0xB0 },
	0x9F4B,	{ 0xE7, 0x83, 0xB1 },
	0x9F4C,	{ 0xE7, 0x83, 0xB2 },
	0x9F4D,	{ 0xE7, 0x83, 0xB3 },
	0x9F4E,	{ 0xE7, 0x83, 0xB4 },
	0x9F4F,	{ 0xE7, 0x83, 0xB5 },
	0x9F50,	{ 0xE7, 0x83, 0xB6 },
	0x9F51,	{ 0xE7, 0x83, 0xB8 },
	0x9F52,	{ 0xE7, 0x83, 0xBA },
	0x9F53,	{ 0xE7, 0x83, 0xBB },
	0x9F54,	{ 0xE7, 0x83, 0xBC },
	0x9F55,	{ 0xE7, 0x83, 0xBE },
	0x9F56,	{ 0xE7, 0x83, 0xBF },
	0x9F57,	{ 0xE7, 0x84, 0x80 },
	0x9F58,	{ 0xE7, 0x84, 0x81 },
	0x9F59,	{ 0xE7, 0x84, 0x82 },
	0x9F5A,	{ 0xE7, 0x84, 0x83 },
	0x9F5B,	{ 0xE7, 0x84, 0x84 },
	0x9F5C,	{ 0xE7, 0x84, 0x85 },
	0x9F5D,	{ 0xE7, 0x84, 0x86 },
	0x9F5E,	{ 0xE7, 0x84, 0x87 },
	0x9F5F,	{ 0xE7, 0x84, 0x88 },
	0x9F60,	{ 0xE7, 0x84, 0x8B },
	0x9F61,	{ 0xE7, 0x84, 0x8C },
	0x9F62,	{ 0xE7, 0x84, 0x8D },
	0x9F63,	{ 0xE7, 0x84, 0x8E },
	0x9F64,	{ 0xE7, 0x84, 0x8F },
	0x9F65,	{ 0xE7, 0x84, 0x91 },
	0x9F66,	{ 0xE7, 0x84, 0x92 },
	0x9F67,	{ 0xE7, 0x84, 0x94 },
	0x9F68,	{ 0xE7, 0x84, 0x97 },
	0x9F69,	{ 0xE7, 0x84, 0x9B },
	0x9F6A,	{ 0xE7, 0x84, 0x9C },
	0x9F6B,	{ 0xE7, 0x84, 0x9D },
	0x9F6C,	{ 0xE7, 0x84, 0x9E },
	0x9F6D,	{ 0xE7, 0x84, 0x9F },
	0x9F6E,	{ 0xE7, 0x84, 0xA0 },
	0x9F6F,	{ 0xE7, 0x84, 0xA1 },
	0x9F70,	{ 0xE7, 0x84, 0xA2 },
	0x9F71,	{ 0xE7, 0x84, 0xA3 },
	0x9F72,	{ 0xE7, 0x84, 0xA4 },
	0x9F73,	{ 0xE7, 0x84, 0xA5 },
	0x9F74,	{ 0xE7, 0x84, 0xA7 },
	0x9F75,	{ 0xE7, 0x84, 0xA8 },
	0x9F76,	{ 0xE7, 0x84, 0xA9 },
	0x9F77,	{ 0xE7, 0x84, 0xAA },
	0x9F78,	{ 0xE7, 0x84, 0xAB },
	0x9F79,	{ 0xE7, 0x84, 0xAC },
	0x9F7A,	{ 0xE7, 0x84, 0xAD },
	0x9F7B,	{ 0xE7, 0x84, 0xAE },
	0x9F7C,	{ 0xE7, 0x84, 0xB2 },
	0x9F7D,	{ 0xE7, 0x84, 0xB3 },
	0x9F7E,	{ 0xE7, 0x84, 0xB4 },
	0x9F80,	{ 0xE7, 0x84, 0xB5 },
	0x9F81,	{ 0xE7, 0x84, 0xB7 },
	0x9F82,	{ 0xE7, 0x84, 0xB8 },
	0x9F83,	{ 0xE7, 0x84, 0xB9 },
	0x9F84,	{ 0xE7, 0x84, 0xBA },
	0x9F85,	{ 0xE7, 0x84, 0xBB },
	0x9F86,	{ 0xE7, 0x84, 0xBC },
	0x9F87,	{ 0xE7, 0x84, 0xBD },
	0x9F88,	{ 0xE7, 0x84, 0xBE },
	0x9F89,	{ 0xE7, 0x84, 0xBF },
	0x9F8A,	{ 0xE7, 0x85, 0x80 },
	0x9F8B,	{ 0xE7, 0x85, 0x81 },
	0x9F8C,	{ 0xE7, 0x85, 0x82 },
	0x9F8D,	{ 0xE7, 0x85, 0x83 },
	0x9F8E,	{ 0xE7, 0x85, 0x84 },
	0x9F8F,	{ 0xE7, 0x85, 0x86 },
	0x9F90,	{ 0xE7, 0x85, 0x87 },
	0x9F91,	{ 0xE7, 0x85, 0x88 },
	0x9F92,	{ 0xE7, 0x85, 0x89 },
	0x9F93,	{ 0xE7, 0x85, 0x8B },
	0x9F94,	{ 0xE7, 0x85, 0x8D },
	0x9F95,	{ 0xE7, 0x85, 0x8F },
	0x9F96,	{ 0xE7, 0x85, 0x90 },
	0x9F97,	{ 0xE7, 0x85, 0x91 },
	0x9F98,	{ 0xE7, 0x85, 0x92 },
	0x9F99,	{ 0xE7, 0x85, 0x93 },
	0x9F9A,	{ 0xE7, 0x85, 0x94 },
	0x9F9B,	{ 0xE7, 0x85, 0x95 },
	0x9F9C,	{ 0xE7, 0x85, 0x96 },
	0x9F9D,	{ 0xE7, 0x85, 0x97 },
	0x9F9E,	{ 0xE7, 0x85, 0x98 },
	0x9F9F,	{ 0xE7, 0x85, 0x99 },
	0x9FA0,	{ 0xE7, 0x85, 0x9A },
	0x9FA1,	{ 0xE7, 0x85, 0x9B },
	0x9FA2,	{ 0xE7, 0x85, 0x9D },
	0x9FA3,	{ 0xE7, 0x85, 0x9F },
	0x9FA4,	{ 0xE7, 0x85, 0xA0 },
	0x9FA5,	{ 0xE7, 0x85, 0xA1 },
	0x9FA6,	{ 0xE7, 0x85, 0xA2 },
	0x9FA7,	{ 0xE7, 0x85, 0xA3 },
	0x9FA8,	{ 0xE7, 0x85, 0xA5 },
	0x9FA9,	{ 0xE7, 0x85, 0xA9 },
	0x9FAA,	{ 0xE7, 0x85, 0xAA },
	0x9FAB,	{ 0xE7, 0x85, 0xAB },
	0x9FAC,	{ 0xE7, 0x85, 0xAC },
	0x9FAD,	{ 0xE7, 0x85, 0xAD },
	0x9FAE,	{ 0xE7, 0x85, 0xAF },
	0x9FAF,	{ 0xE7, 0x85, 0xB0 },
	0x9FB0,	{ 0xE7, 0x85, 0xB1 },
	0x9FB1,	{ 0xE7, 0x85, 0xB4 },
	0x9FB2,	{ 0xE7, 0x85, 0xB5 },
	0x9FB3,	{ 0xE7, 0x85, 0xB6 },
	0x9FB4,	{ 0xE7, 0x85, 0xB7 },
	0x9FB5,	{ 0xE7, 0x85, 0xB9 },
	0x9FB6,	{ 0xE7, 0x85, 0xBB },
	0x9FB7,	{ 0xE7, 0x85, 0xBC },
	0x9FB8,	{ 0xE7, 0x85, 0xBE },
	0x9FB9,	{ 0xE7, 0x85, 0xBF },
	0x9FBA,	{ 0xE7, 0x86, 0x80 },
	0x9FBB,	{ 0xE7, 0x86, 0x81 },
	0x9FBC,	{ 0xE7, 0x86, 0x82 },
	0x9FBD,	{ 0xE7, 0x86, 0x83 },
	0x9FBE,	{ 0xE7, 0x86, 0x85 },
	0x9FBF,	{ 0xE7, 0x86, 0x86 },
	0x9FC0,	{ 0xE7, 0x86, 0x87 },
	0x9FC1,	{ 0xE7, 0x86, 0x88 },
	0x9FC2,	{ 0xE7, 0x86, 0x89 },
	0x9FC3,	{ 0xE7, 0x86, 0x8B },
	0x9FC4,	{ 0xE7, 0x86, 0x8C },
	0x9FC5,	{ 0xE7, 0x86, 0x8D },
	0x9FC6,	{ 0xE7, 0x86, 0x8E },
	0x9FC7,	{ 0xE7, 0x86, 0x90 },
	0x9FC8,	{ 0xE7, 0x86, 0x91 },
	0x9FC9,	{ 0xE7, 0x86, 0x92 },
	0x9FCA,	{ 0xE7, 0x86, 0x93 },
	0x9FCB,	{ 0xE7, 0x86, 0x95 },
	0x9FCC,	{ 0xE7, 0x86, 0x96 },
	0x9FCD,	{ 0xE7, 0x86, 0x97 },
	0x9FCE,	{ 0xE7, 0x86, 0x9A },
	0x9FCF,	{ 0xE7, 0x86, 0x9B },
	0x9FD0,	{ 0xE7, 0x86, 0x9C },
	0x9FD1,	{ 0xE7, 0x86, 0x9D },
	0x9FD2,	{ 0xE7, 0x86, 0x9E },
	0x9FD3,	{ 0xE7, 0x86, 0xA1 },
	0x9FD4,	{ 0xE7, 0x86, 0xA2 },
	0x9FD5,	{ 0xE7, 0x86, 0xA3 },
	0x9FD6,	{ 0xE7, 0x86, 0xA4 },
	0x9FD7,	{ 0xE7, 0x86, 0xA5 },
	0x9FD8,	{ 0xE7, 0x86, 0xA6 },
	0x9FD9,	{ 0xE7, 0x86, 0xA7 },
	0x9FDA,	{ 0xE7, 0x86, 0xA9 },
	0x9FDB,	{ 0xE7, 0x86, 0xAA },
	0x9FDC,	{ 0xE7, 0x86, 0xAB },
	0x9FDD,	{ 0xE7, 0x86, 0xAD },
	0x9FDE,	{ 0xE7, 0x86, 0xAE },
	0x9FDF,	{ 0xE7, 0x86, 0xAF },
	0x9FE0,	{ 0xE7, 0x86, 0xB0 },
	0x9FE1,	{ 0xE7, 0x86, 0xB1 },
	0x9FE2,	{ 0xE7, 0x86, 0xB2 },
	0x9FE3,	{ 0xE7, 0x86, 0xB4 },
	0x9FE4,	{ 0xE7, 0x86, 0xB6 },
	0x9FE5,	{ 0xE7, 0x86, 0xB7 },
	0x9FE6,	{ 0xE7, 0x86, 0xB8 },
	0x9FE7,	{ 0xE7, 0x86, 0xBA },
	0x9FE8,	{ 0xE7, 0x86, 0xBB },
	0x9FE9,	{ 0xE7, 0x86, 0xBC },
	0x9FEA,	{ 0xE7, 0x86, 0xBD },
	0x9FEB,	{ 0xE7, 0x86, 0xBE },
	0x9FEC,	{ 0xE7, 0x86, 0xBF },
	0x9FED,	{ 0xE7, 0x87, 0x80 },
	0x9FEE,	{ 0xE7, 0x87, 0x81 },
	0x9FEF,	{ 0xE7, 0x87, 0x82 },
	0x9FF0,	{ 0xE7, 0x87, 0x84 },
	0x9FF1,	{ 0xE7, 0x87, 0x85 },
	0x9FF2,	{ 0xE7, 0x87, 0x86 },
	0x9FF3,	{ 0xE7, 0x87, 0x87 },
	0x9FF4,	{ 0xE7, 0x87, 0x88 },
	0x9FF5,	{ 0xE7, 0x87, 0x89 },
	0x9FF6,	{ 0xE7, 0x87, 0x8A },
	0x9FF7,	{ 0xE7, 0x87, 0x8B },
	0x9FF8,	{ 0xE7, 0x87, 0x8C },
	0x9FF9,	{ 0xE7, 0x87, 0x8D },
	0x9FFA,	{ 0xE7, 0x87, 0x8F },
	0x9FFB,	{ 0xE7, 0x87, 0x90 },
	0x9FFC,	{ 0xE7, 0x87, 0x91 },
	0x9FFD,	{ 0xE7, 0x87, 0x92 },
	0x9FFE,	{ 0xE7, 0x87, 0x93 },
	0xA040,	{ 0xE7, 0x87, 0x96 },
	0xA041,	{ 0xE7, 0x87, 0x97 },
	0xA042,	{ 0xE7, 0x87, 0x98 },
	0xA043,	{ 0xE7, 0x87, 0x99 },
	0xA044,	{ 0xE7, 0x87, 0x9A },
	0xA045,	{ 0xE7, 0x87, 0x9B },
	0xA046,	{ 0xE7, 0x87, 0x9C },
	0xA047,	{ 0xE7, 0x87, 0x9D },
	0xA048,	{ 0xE7, 0x87, 0x9E },
	0xA049,	{ 0xE7, 0x87, 0x9F },
	0xA04A,	{ 0xE7, 0x87, 0xA1 },
	0xA04B,	{ 0xE7, 0x87, 0xA2 },
	0xA04C,	{ 0xE7, 0x87, 0xA3 },
	0xA04D,	{ 0xE7, 0x87, 0xA4 },
	0xA04E,	{ 0xE7, 0x87, 0xA6 },
	0xA04F,	{ 0xE7, 0x87, 0xA8 },
	0xA050,	{ 0xE7, 0x87, 0xA9 },
	0xA051,	{ 0xE7, 0x87, 0xAA },
	0xA052,	{ 0xE7, 0x87, 0xAB },
	0xA053,	{ 0xE7, 0x87, 0xAC },
	0xA054,	{ 0xE7, 0x87, 0xAD },
	0xA055,	{ 0xE7, 0x87, 0xAF },
	0xA056,	{ 0xE7, 0x87, 0xB0 },
	0xA057,	{ 0xE7, 0x87, 0xB1 },
	0xA058,	{ 0xE7, 0x87, 0xB2 },
	0xA059,	{ 0xE7, 0x87, 0xB3 },
	0xA05A,	{ 0xE7, 0x87, 0xB4 },
	0xA05B,	{ 0xE7, 0x87, 0xB5 },
	0xA05C,	{ 0xE7, 0x87, 0xB6 },
	0xA05D,	{ 0xE7, 0x87, 0xB7 },
	0xA05E,	{ 0xE7, 0x87, 0xB8 },
	0xA05F,	{ 0xE7, 0x87, 0xBA },
	0xA060,	{ 0xE7, 0x87, 0xBB },
	0xA061,	{ 0xE7, 0x87, 0xBC },
	0xA062,	{ 0xE7, 0x87, 0xBD },
	0xA063,	{ 0xE7, 0x87, 0xBE },
	0xA064,	{ 0xE7, 0x87, 0xBF },
	0xA065,	{ 0xE7, 0x88, 0x80 },
	0xA066,	{ 0xE7, 0x88, 0x81 },
	0xA067,	{ 0xE7, 0x88, 0x82 },
	0xA068,	{ 0xE7, 0x88, 0x83 },
	0xA069,	{ 0xE7, 0x88, 0x84 },
	0xA06A,	{ 0xE7, 0x88, 0x85 },
	0xA06B,	{ 0xE7, 0x88, 0x87 },
	0xA06C,	{ 0xE7, 0x88, 0x88 },
	0xA06D,	{ 0xE7, 0x88, 0x89 },
	0xA06E,	{ 0xE7, 0x88, 0x8A },
	0xA06F,	{ 0xE7, 0x88, 0x8B },
	0xA070,	{ 0xE7, 0x88, 0x8C },
	0xA071,	{ 0xE7, 0x88, 0x8D },
	0xA072,	{ 0xE7, 0x88, 0x8E },
	0xA073,	{ 0xE7, 0x88, 0x8F },
	0xA074,	{ 0xE7, 0x88, 0x90 },
	0xA075,	{ 0xE7, 0x88, 0x91 },
	0xA076,	{ 0xE7, 0x88, 0x92 },
	0xA077,	{ 0xE7, 0x88, 0x93 },
	0xA078,	{ 0xE7, 0x88, 0x94 },
	0xA079,	{ 0xE7, 0x88, 0x95 },
	0xA07A,	{ 0xE7, 0x88, 0x96 },
	0xA07B,	{ 0xE7, 0x88, 0x97 },
	0xA07C,	{ 0xE7, 0x88, 0x98 },
	0xA07D,	{ 0xE7, 0x88, 0x99 },
	0xA07E,	{ 0xE7, 0x88, 0x9A },
	0xA080,	{ 0xE7, 0x88, 0x9B },
	0xA081,	{ 0xE7, 0x88, 0x9C },
	0xA082,	{ 0xE7, 0x88, 0x9E },
	0xA083,	{ 0xE7, 0x88, 0x9F },
	0xA084,	{ 0xE7, 0x88, 0xA0 },
	0xA085,	{ 0xE7, 0x88, 0xA1 },
	0xA086,	{ 0xE7, 0x88, 0xA2 },
	0xA087,	{ 0xE7, 0x88, 0xA3 },
	0xA088,	{ 0xE7, 0x88, 0xA4 },
	0xA089,	{ 0xE7, 0x88, 0xA5 },
	0xA08A,	{ 0xE7, 0x88, 0xA6 },
	0xA08B,	{ 0xE7, 0x88, 0xA7 },
	0xA08C,	{ 0xE7, 0x88, 0xA9 },
	0xA08D,	{ 0xE7, 0x88, 0xAB },
	0xA08E,	{ 0xE7, 0x88, 0xAD },
	0xA08F,	{ 0xE7, 0x88, 0xAE },
	0xA090,	{ 0xE7, 0x88, 0xAF },
	0xA091,	{ 0xE7, 0x88, 0xB2 },
	0xA092,	{ 0xE7, 0x88, 0xB3 },
	0xA093,	{ 0xE7, 0x88, 0xB4 },
	0xA094,	{ 0xE7, 0x88, 0xBA },
	0xA095,	{ 0xE7, 0x88, 0xBC },
	0xA096,	{ 0xE7, 0x88, 0xBE },
	0xA097,	{ 0xE7, 0x89, 0x80 },
	0xA098,	{ 0xE7, 0x89, 0x81 },
	0xA099,	{ 0xE7, 0x89, 0x82 },
	0xA09A,	{ 0xE7, 0x89, 0x83 },
	0xA09B,	{ 0xE7, 0x89, 0x84 },
	0xA09C,	{ 0xE7, 0x89, 0x85 },
	0xA09D,	{ 0xE7, 0x89, 0x86 },
	0xA09E,	{ 0xE7, 0x89, 0x89 },
	0xA09F,	{ 0xE7, 0x89, 0x8A },
	0xA0A0,	{ 0xE7, 0x89, 0x8B },
	0xA0A1,	{ 0xE7, 0x89, 0x8E },
	0xA0A2,	{ 0xE7, 0x89, 0x8F },
	0xA0A3,	{ 0xE7, 0x89, 0x90 },
	0xA0A4,	{ 0xE7, 0x89, 0x91 },
	0xA0A5,	{ 0xE7, 0x89, 0x93 },
	0xA0A6,	{ 0xE7, 0x89, 0x94 },
	0xA0A7,	{ 0xE7, 0x89, 0x95 },
	0xA0A8,	{ 0xE7, 0x89, 0x97 },
	0xA0A9,	{ 0xE7, 0x89, 0x98 },
	0xA0AA,	{ 0xE7, 0x89, 0x9A },
	0xA0AB,	{ 0xE7, 0x89, 0x9C },
	0xA0AC,	{ 0xE7, 0x89, 0x9E },
	0xA0AD,	{ 0xE7, 0x89, 0xA0 },
	0xA0AE,	{ 0xE7, 0x89, 0xA3 },
	0xA0AF,	{ 0xE7, 0x89, 0xA4 },
	0xA0B0,	{ 0xE7, 0x89, 0xA5 },
	0xA0B1,	{ 0xE7, 0x89, 0xA8 },
	0xA0B2,	{ 0xE7, 0x89, 0xAA },
	0xA0B3,	{ 0xE7, 0x89, 0xAB },
	0xA0B4,	{ 0xE7, 0x89, 0xAC },
	0xA0B5,	{ 0xE7, 0x89, 0xAD },
	0xA0B6,	{ 0xE7, 0x89, 0xB0 },
	0xA0B7,	{ 0xE7, 0x89, 0xB1 },
	0xA0B8,	{ 0xE7, 0x89, 0xB3 },
	0xA0B9,	{ 0xE7, 0x89, 0xB4 },
	0xA0BA,	{ 0xE7, 0x89, 0xB6 },
	0xA0BB,	{ 0xE7, 0x89, 0xB7 },
	0xA0BC,	{ 0xE7, 0x89, 0xB8 },
	0xA0BD,	{ 0xE7, 0x89, 0xBB },
	0xA0BE,	{ 0xE7, 0x89, 0xBC },
	0xA0BF,	{ 0xE7, 0x89, 0xBD },
	0xA0C0,	{ 0xE7, 0x8A, 0x82 },
	0xA0C1,	{ 0xE7, 0x8A, 0x83 },
	0xA0C2,	{ 0xE7, 0x8A, 0x85 },
	0xA0C3,	{ 0xE7, 0x8A, 0x86 },
	0xA0C4,	{ 0xE7, 0x8A, 0x87 },
	0xA0C5,	{ 0xE7, 0x8A, 0x88 },
	0xA0C6,	{ 0xE7, 0x8A, 0x89 },
	0xA0C7,	{ 0xE7, 0x8A, 0x8C },
	0xA0C8,	{ 0xE7, 0x8A, 0x8E },
	0xA0C9,	{ 0xE7, 0x8A, 0x90 },
	0xA0CA,	{ 0xE7, 0x8A, 0x91 },
	0xA0CB,	{ 0xE7, 0x8A, 0x93 },
	0xA0CC,	{ 0xE7, 0x8A, 0x94 },
	0xA0CD,	{ 0xE7, 0x8A, 0x95 },
	0xA0CE,	{ 0xE7, 0x8A, 0x96 },
	0xA0CF,	{ 0xE7, 0x8A, 0x97 },
	0xA0D0,	{ 0xE7, 0x8A, 0x98 },
	0xA0D1,	{ 0xE7, 0x8A, 0x99 },
	0xA0D2,	{ 0xE7, 0x8A, 0x9A },
	0xA0D3,	{ 0xE7, 0x8A, 0x9B },
	0xA0D4,	{ 0xE7, 0x8A, 0x9C },
	0xA0D5,	{ 0xE7, 0x8A, 0x9D },
	0xA0D6,	{ 0xE7, 0x8A, 0x9E },
	0xA0D7,	{ 0xE7, 0x8A, 0xA0 },
	0xA0D8,	{ 0xE7, 0x8A, 0xA1 },
	0xA0D9,	{ 0xE7, 0x8A, 0xA2 },
	0xA0DA,	{ 0xE7, 0x8A, 0xA3 },
	0xA0DB,	{ 0xE7, 0x8A, 0xA4 },
	0xA0DC,	{ 0xE7, 0x8A, 0xA5 },
	0xA0DD,	{ 0xE7, 0x8A, 0xA6 },
	0xA0DE,	{ 0xE7, 0x8A, 0xA7 },
	0xA0DF,	{ 0xE7, 0x8A, 0xA8 },
	0xA0E0,	{ 0xE7, 0x8A, 0xA9 },
	0xA0E1,	{ 0xE7, 0x8A, 0xAA },
	0xA0E2,	{ 0xE7, 0x8A, 0xAB },
	0xA0E3,	{ 0xE7, 0x8A, 0xAE },
	0xA0E4,	{ 0xE7, 0x8A, 0xB1 },
	0xA0E5,	{ 0xE7, 0x8A, 0xB2 },
	0xA0E6,	{ 0xE7, 0x8A, 0xB3 },
	0xA0E7,	{ 0xE7, 0x8A, 0xB5 },
	0xA0E8,	{ 0xE7, 0x8A, 0xBA },
	0xA0E9,	{ 0xE7, 0x8A, 0xBB },
	0xA0EA,	{ 0xE7, 0x8A, 0xBC },
	0xA0EB,	{ 0xE7, 0x8A, 0xBD },
	0xA0EC,	{ 0xE7, 0x8A, 0xBE },
	0xA0ED,	{ 0xE7, 0x8A, 0xBF },
	0xA0EE,	{ 0xE7, 0x8B, 0x80 },
	0xA0EF,	{ 0xE7, 0x8B, 0x85 },
	0xA0F0,	{ 0xE7, 0x8B, 0x86 },
	0xA0F1,	{ 0xE7, 0x8B, 0x87 },
	0xA0F2,	{ 0xE7, 0x8B, 0x89 },
	0xA0F3,	{ 0xE7, 0x8B, 0x8A },
	0xA0F4,	{ 0xE7, 0x8B, 0x8B },
	0xA0F5,	{ 0xE7, 0x8B, 0x8C },
	0xA0F6,	{ 0xE7, 0x8B, 0x8F },
	0xA0F7,	{ 0xE7, 0x8B, 0x91 },
	0xA0F8,	{ 0xE7, 0x8B, 0x93 },
	0xA0F9,	{ 0xE7, 0x8B, 0x94 },
	0xA0FA,	{ 0xE7, 0x8B, 0x95 },
	0xA0FB,	{ 0xE7, 0x8B, 0x96 },
	0xA0FC,	{ 0xE7, 0x8B, 0x98 },
	0xA0FD,	{ 0xE7, 0x8B, 0x9A },
	0xA0FE,	{ 0xE7, 0x8B, 0x9B },
	0xA140,	{ 0xEE, 0x93, 0x86 },
	0xA141,	{ 0xEE, 0x93, 0x87 },
	0xA142,	{ 0xEE, 0x93, 0x88 },
	0xA143,	{ 0xEE, 0x93, 0x89 },
	0xA144,	{ 0xEE, 0x93, 0x8A },
	0xA145,	{ 0xEE, 0x93, 0x8B },
	0xA146,	{ 0xEE, 0x93, 0x8C },
	0xA147,	{ 0xEE, 0x93, 0x8D },
	0xA148,	{ 0xEE, 0x93, 0x8E },
	0xA149,	{ 0xEE, 0x93, 0x8F },
	0xA14A,	{ 0xEE, 0x93, 0x90 },
	0xA14B,	{ 0xEE, 0x93, 0x91 },
	0xA14C,	{ 0xEE, 0x93, 0x92 },
	0xA14D,	{ 0xEE, 0x93, 0x93 },
	0xA14E,	{ 0xEE, 0x93, 0x94 },
	0xA14F,	{ 0xEE, 0x93, 0x95 },
	0xA150,	{ 0xEE, 0x93, 0x96 },
	0xA151,	{ 0xEE, 0x93, 0x97 },
	0xA152,	{ 0xEE, 0x93, 0x98 },
	0xA153,	{ 0xEE, 0x93, 0x99 },
	0xA154,	{ 0xEE, 0x93, 0x9A },
	0xA155,	{ 0xEE, 0x93, 0x9B },
	0xA156,	{ 0xEE, 0x93, 0x9C },
	0xA157,	{ 0xEE, 0x93, 0x9D },
	0xA158,	{ 0xEE, 0x93, 0x9E },
	0xA159,	{ 0xEE, 0x93, 0x9F },
	0xA15A,	{ 0xEE, 0x93, 0xA0 },
	0xA15B,	{ 0xEE, 0x93, 0xA1 },
	0xA15C,	{ 0xEE, 0x93, 0xA2 },
	0xA15D,	{ 0xEE, 0x93, 0xA3 },
	0xA15E,	{ 0xEE, 0x93, 0xA4 },
	0xA15F,	{ 0xEE, 0x93, 0xA5 },
	0xA160,	{ 0xEE, 0x93, 0xA6 },
	0xA161,	{ 0xEE, 0x93, 0xA7 },
	0xA162,	{ 0xEE, 0x93, 0xA8 },
	0xA163,	{ 0xEE, 0x93, 0xA9 },
	0xA164,	{ 0xEE, 0x93, 0xAA },
	0xA165,	{ 0xEE, 0x93, 0xAB },
	0xA166,	{ 0xEE, 0x93, 0xAC },
	0xA167,	{ 0xEE, 0x93, 0xAD },
	0xA168,	{ 0xEE, 0x93, 0xAE },
	0xA169,	{ 0xEE, 0x93, 0xAF },
	0xA16A,	{ 0xEE, 0x93, 0xB0 },
	0xA16B,	{ 0xEE, 0x93, 0xB1 },
	0xA16C,	{ 0xEE, 0x93, 0xB2 },
	0xA16D,	{ 0xEE, 0x93, 0xB3 },
	0xA16E,	{ 0xEE, 0x93, 0xB4 },
	0xA16F,	{ 0xEE, 0x93, 0xB5 },
	0xA170,	{ 0xEE, 0x93, 0xB6 },
	0xA171,	{ 0xEE, 0x93, 0xB7 },
	0xA172,	{ 0xEE, 0x93, 0xB8 },
	0xA173,	{ 0xEE, 0x93, 0xB9 },
	0xA174,	{ 0xEE, 0x93, 0xBA },
	0xA175,	{ 0xEE, 0x93, 0xBB },
	0xA176,	{ 0xEE, 0x93, 0xBC },
	0xA177,	{ 0xEE, 0x93, 0xBD },
	0xA178,	{ 0xEE, 0x93, 0xBE },
	0xA179,	{ 0xEE, 0x93, 0xBF },
	0xA17A,	{ 0xEE, 0x94, 0x80 },
	0xA17B,	{ 0xEE, 0x94, 0x81 },
	0xA17C,	{ 0xEE, 0x94, 0x82 },
	0xA17D,	{ 0xEE, 0x94, 0x83 },
	0xA17E,	{ 0xEE, 0x94, 0x84 },
	0xA180,	{ 0xEE, 0x94, 0x85 },
	0xA181,	{ 0xEE, 0x94, 0x86 },
	0xA182,	{ 0xEE, 0x94, 0x87 },
	0xA183,	{ 0xEE, 0x94, 0x88 },
	0xA184,	{ 0xEE, 0x94, 0x89 },
	0xA185,	{ 0xEE, 0x94, 0x8A },
	0xA186,	{ 0xEE, 0x94, 0x8B },
	0xA187,	{ 0xEE, 0x94, 0x8C },
	0xA188,	{ 0xEE, 0x94, 0x8D },
	0xA189,	{ 0xEE, 0x94, 0x8E },
	0xA18A,	{ 0xEE, 0x94, 0x8F },
	0xA18B,	{ 0xEE, 0x94, 0x90 },
	0xA18C,	{ 0xEE, 0x94, 0x91 },
	0xA18D,	{ 0xEE, 0x94, 0x92 },
	0xA18E,	{ 0xEE, 0x94, 0x93 },
	0xA18F,	{ 0xEE, 0x94, 0x94 },
	0xA190,	{ 0xEE, 0x94, 0x95 },
	0xA191,	{ 0xEE, 0x94, 0x96 },
	0xA192,	{ 0xEE, 0x94, 0x97 },
	0xA193,	{ 0xEE, 0x94, 0x98 },
	0xA194,	{ 0xEE, 0x94, 0x99 },
	0xA195,	{ 0xEE, 0x94, 0x9A },
	0xA196,	{ 0xEE, 0x94, 0x9B },
	0xA197,	{ 0xEE, 0x94, 0x9C },
	0xA198,	{ 0xEE, 0x94, 0x9D },
	0xA199,	{ 0xEE, 0x94, 0x9E },
	0xA19A,	{ 0xEE, 0x94, 0x9F },
	0xA19B,	{ 0xEE, 0x94, 0xA0 },
	0xA19C,	{ 0xEE, 0x94, 0xA1 },
	0xA19D,	{ 0xEE, 0x94, 0xA2 },
	0xA19E,	{ 0xEE, 0x94, 0xA3 },
	0xA19F,	{ 0xEE, 0x94, 0xA4 },
	0xA1A0,	{ 0xEE, 0x94, 0xA5 },
	0xA1A1,	{ 0xE3, 0x80, 0x80 },
	0xA1A2,	{ 0xE3, 0x80, 0x81 },
	0xA1A3,	{ 0xE3, 0x80, 0x82 },
	0xA1A4,	{ 0xC2, 0xB7 },
	0xA1A5,	{ 0xCB, 0x89 },
	0xA1A6,	{ 0xCB, 0x87 },
	0xA1A7,	{ 0xC2, 0xA8 },
	0xA1A8,	{ 0xE3, 0x80, 0x83 },
	0xA1A9,	{ 0xE3, 0x80, 0x85 },
	0xA1AA,	{ 0xE2, 0x80, 0x94 },
	0xA1AB,	{ 0xEF, 0xBD, 0x9E },
	0xA1AC,	{ 0xE2, 0x80, 0x96 },
	0xA1AD,	{ 0xE2, 0x80, 0xA6 },
	0xA1AE,	{ 0xE2, 0x80, 0x98 },
	0xA1AF,	{ 0xE2, 0x80, 0x99 },
	0xA1B0,	{ 0xE2, 0x80, 0x9C },
	0xA1B1,	{ 0xE2, 0x80, 0x9D },
	0xA1B2,	{ 0xE3, 0x80, 0x94 },
	0xA1B3,	{ 0xE3, 0x80, 0x95 },
	0xA1B4,	{ 0xE3, 0x80, 0x88 },
	0xA1B5,	{ 0xE3, 0x80, 0x89 },
	0xA1B6,	{ 0xE3, 0x80, 0x8A },
	0xA1B7,	{ 0xE3, 0x80, 0x8B },
	0xA1B8,	{ 0xE3, 0x80, 0x8C },
	0xA1B9,	{ 0xE3, 0x80, 0x8D },
	0xA1BA,	{ 0xE3, 0x80, 0x8E },
	0xA1BB,	{ 0xE3, 0x80, 0x8F },
	0xA1BC,	{ 0xE3, 0x80, 0x96 },
	0xA1BD,	{ 0xE3, 0x80, 0x97 },
	0xA1BE,	{ 0xE3, 0x80, 0x90 },
	0xA1BF,	{ 0xE3, 0x80, 0x91 },
	0xA1C0,	{ 0xC2, 0xB1 },
	0xA1C1,	{ 0xC3, 0x97 },
	0xA1C2,	{ 0xC3, 0xB7 },
	0xA1C3,	{ 0xE2, 0x88, 0xB6 },
	0xA1C4,	{ 0xE2, 0x88, 0xA7 },
	0xA1C5,	{ 0xE2, 0x88, 0xA8 },
	0xA1C6,	{ 0xE2, 0x88, 0x91 },
	0xA1C7,	{ 0xE2, 0x88, 0x8F },
	0xA1C8,	{ 0xE2, 0x88, 0xAA },
	0xA1C9,	{ 0xE2, 0x88, 0xA9 },
	0xA1CA,	{ 0xE2, 0x88, 0x88 },
	0xA1CB,	{ 0xE2, 0x88, 0xB7 },
	0xA1CC,	{ 0xE2, 0x88, 0x9A },
	0xA1CD,	{ 0xE2, 0x8A, 0xA5 },
	0xA1CE,	{ 0xE2, 0x88, 0xA5 },
	0xA1CF,	{ 0xE2, 0x88, 0xA0 },
	0xA1D0,	{ 0xE2, 0x8C, 0x92 },
	0xA1D1,	{ 0xE2, 0x8A, 0x99 },
	0xA1D2,	{ 0xE2, 0x88, 0xAB },
	0xA1D3,	{ 0xE2, 0x88, 0xAE },
	0xA1D4,	{ 0xE2, 0x89, 0xA1 },
	0xA1D5,	{ 0xE2, 0x89, 0x8C },
	0xA1D6,	{ 0xE2, 0x89, 0x88 },
	0xA1D7,	{ 0xE2, 0x88, 0xBD },
	0xA1D8,	{ 0xE2, 0x88, 0x9D },
	0xA1D9,	{ 0xE2, 0x89, 0xA0 },
	0xA1DA,	{ 0xE2, 0x89, 0xAE },
	0xA1DB,	{ 0xE2, 0x89, 0xAF },
	0xA1DC,	{ 0xE2, 0x89, 0xA4 },
	0xA1DD,	{ 0xE2, 0x89, 0xA5 },
	0xA1DE,	{ 0xE2, 0x88, 0x9E },
	0xA1DF,	{ 0xE2, 0x88, 0xB5 },
	0xA1E0,	{ 0xE2, 0x88, 0xB4 },
	0xA1E1,	{ 0xE2, 0x99, 0x82 },
	0xA1E2,	{ 0xE2, 0x99, 0x80 },
	0xA1E3,	{ 0xC2, 0xB0 },
	0xA1E4,	{ 0xE2, 0x80, 0xB2 },
	0xA1E5,	{ 0xE2, 0x80, 0xB3 },
	0xA1E6,	{ 0xE2, 0x84, 0x83 },
	0xA1E7,	{ 0xEF, 0xBC, 0x84 },
	0xA1E8,	{ 0xC2, 0xA4 },
	0xA1E9,	{ 0xEF, 0xBF, 0xA0 },
	0xA1EA,	{ 0xEF, 0xBF, 0xA1 },
	0xA1EB,	{ 0xE2, 0x80, 0xB0 },
	0xA1EC,	{ 0xC2, 0xA7 },
	0xA1ED,	{ 0xE2, 0x84, 0x96 },
	0xA1EE,	{ 0xE2, 0x98, 0x86 },
	0xA1EF,	{ 0xE2, 0x98, 0x85 },
	0xA1F0,	{ 0xE2, 0x97, 0x8B },
	0xA1F1,	{ 0xE2, 0x97, 0x8F },
	0xA1F2,	{ 0xE2, 0x97, 0x8E },
	0xA1F3,	{ 0xE2, 0x97, 0x87 },
	0xA1F4,	{ 0xE2, 0x97, 0x86 },
	0xA1F5,	{ 0xE2, 0x96, 0xA1 },
	0xA1F6,	{ 0xE2, 0x96, 0xA0 },
	0xA1F7,	{ 0xE2, 0x96, 0xB3 },
	0xA1F8,	{ 0xE2, 0x96, 0xB2 },
	0xA1F9,	{ 0xE2, 0x80, 0xBB },
	0xA1FA,	{ 0xE2, 0x86, 0x92 },
	0xA1FB,	{ 0xE2, 0x86, 0x90 },
	0xA1FC,	{ 0xE2, 0x86, 0x91 },
	0xA1FD,	{ 0xE2, 0x86, 0x93 },
	0xA1FE,	{ 0xE3, 0x80, 0x93 },
	0xA240,	{ 0xEE, 0x94, 0xA6 },
	0xA241,	{ 0xEE, 0x94, 0xA7 },
	0xA242,	{ 0xEE, 0x94, 0xA8 },
	0xA243,	{ 0xEE, 0x94, 0xA9 },
	0xA244,	{ 0xEE, 0x94, 0xAA },
	0xA245,	{ 0xEE, 0x94, 0xAB },
	0xA246,	{ 0xEE, 0x94, 0xAC },
	0xA247,	{ 0xEE, 0x94, 0xAD },
	0xA248,	{ 0xEE, 0x94, 0xAE },
	0xA249,	{ 0xEE, 0x94, 0xAF },
	0xA24A,	{ 0xEE, 0x94, 0xB0 },
	0xA24B,	{ 0xEE, 0x94, 0xB1 },
	0xA24C,	{ 0xEE, 0x94, 0xB2 },
	0xA24D,	{ 0xEE, 0x94, 0xB3 },
	0xA24E,	{ 0xEE, 0x94, 0xB4 },
	0xA24F,	{ 0xEE, 0x94, 0xB5 },
	0xA250,	{ 0xEE, 0x94, 0xB6 },
	0xA251,	{ 0xEE, 0x94, 0xB7 },
	0xA252,	{ 0xEE, 0x94, 0xB8 },
	0xA253,	{ 0xEE, 0x94, 0xB9 },
	0xA254,	{ 0xEE, 0x94, 0xBA },
	0xA255,	{ 0xEE, 0x94, 0xBB },
	0xA256,	{ 0xEE, 0x94, 0xBC },
	0xA257,	{ 0xEE, 0x94, 0xBD },
	0xA258,	{ 0xEE, 0x94, 0xBE },
	0xA259,	{ 0xEE, 0x94, 0xBF },
	0xA25A,	{ 0xEE, 0x95, 0x80 },
	0xA25B,	{ 0xEE, 0x95, 0x81 },
	0xA25C,	{ 0xEE, 0x95, 0x82 },
	0xA25D,	{ 0xEE, 0x95, 0x83 },
	0xA25E,	{ 0xEE, 0x95, 0x84 },
	0xA25F,	{ 0xEE, 0x95, 0x85 },
	0xA260,	{ 0xEE, 0x95, 0x86 },
	0xA261,	{ 0xEE, 0x95, 0x87 },
	0xA262,	{ 0xEE, 0x95, 0x88 },
	0xA263,	{ 0xEE, 0x95, 0x89 },
	0xA264,	{ 0xEE, 0x95, 0x8A },
	0xA265,	{ 0xEE, 0x95, 0x8B },
	0xA266,	{ 0xEE, 0x95, 0x8C },
	0xA267,	{ 0xEE, 0x95, 0x8D },
	0xA268,	{ 0xEE, 0x95, 0x8E },
	0xA269,	{ 0xEE, 0x95, 0x8F },
	0xA26A,	{ 0xEE, 0x95, 0x90 },
	0xA26B,	{ 0xEE, 0x95, 0x91 },
	0xA26C,	{ 0xEE, 0x95, 0x92 },
	0xA26D,	{ 0xEE, 0x95, 0x93 },
	0xA26E,	{ 0xEE, 0x95, 0x94 },
	0xA26F,	{ 0xEE, 0x95, 0x95 },
	0xA270,	{ 0xEE, 0x95, 0x96 },
	0xA271,	{ 0xEE, 0x95, 0x97 },
	0xA272,	{ 0xEE, 0x95, 0x98 },
	0xA273,	{ 0xEE, 0x95, 0x99 },
	0xA274,	{ 0xEE, 0x95, 0x9A },
	0xA275,	{ 0xEE, 0x95, 0x9B },
	0xA276,	{ 0xEE, 0x95, 0x9C },
	0xA277,	{ 0xEE, 0x95, 0x9D },
	0xA278,	{ 0xEE, 0x95, 0x9E },
	0xA279,	{ 0xEE, 0x95, 0x9F },
	0xA27A,	{ 0xEE, 0x95, 0xA0 },
	0xA27B,	{ 0xEE, 0x95, 0xA1 },
	0xA27C,	{ 0xEE, 0x95, 0xA2 },
	0xA27D,	{ 0xEE, 0x95, 0xA3 },
	0xA27E,	{ 0xEE, 0x95, 0xA4 },
	0xA280,	{ 0xEE, 0x95, 0xA5 },
	0xA281,	{ 0xEE, 0x95, 0xA6 },
	0xA282,	{ 0xEE, 0x95, 0xA7 },
	0xA283,	{ 0xEE, 0x95, 0xA8 },
	0xA284,	{ 0xEE, 0x95, 0xA9 },
	0xA285,	{ 0xEE, 0x95, 0xAA },
	0xA286,	{ 0xEE, 0x95, 0xAB },
	0xA287,	{ 0xEE, 0x95, 0xAC },
	0xA288,	{ 0xEE, 0x95, 0xAD },
	0xA289,	{ 0xEE, 0x95, 0xAE },
	0xA28A,	{ 0xEE, 0x95, 0xAF },
	0xA28B,	{ 0xEE, 0x95, 0xB0 },
	0xA28C,	{ 0xEE, 0x95, 0xB1 },
	0xA28D,	{ 0xEE, 0x95, 0xB2 },
	0xA28E,	{ 0xEE, 0x95, 0xB3 },
	0xA28F,	{ 0xEE, 0x95, 0xB4 },
	0xA290,	{ 0xEE, 0x95, 0xB5 },
	0xA291,	{ 0xEE, 0x95, 0xB6 },
	0xA292,	{ 0xEE, 0x95, 0xB7 },
	0xA293,	{ 0xEE, 0x95, 0xB8 },
	0xA294,	{ 0xEE, 0x95, 0xB9 },
	0xA295,	{ 0xEE, 0x95, 0xBA },
	0xA296,	{ 0xEE, 0x95, 0xBB },
	0xA297,	{ 0xEE, 0x95, 0xBC },
	0xA298,	{ 0xEE, 0x95, 0xBD },
	0xA299,	{ 0xEE, 0x95, 0xBE },
	0xA29A,	{ 0xEE, 0x95, 0xBF },
	0xA29B,	{ 0xEE, 0x96, 0x80 },
	0xA29C,	{ 0xEE, 0x96, 0x81 },
	0xA29D,	{ 0xEE, 0x96, 0x82 },
	0xA29E,	{ 0xEE, 0x96, 0x83 },
	0xA29F,	{ 0xEE, 0x96, 0x84 },
	0xA2A0,	{ 0xEE, 0x96, 0x85 },
	0xA2A1,	{ 0xE2, 0x85, 0xB0 },
	0xA2A2,	{ 0xE2, 0x85, 0xB1 },
	0xA2A3,	{ 0xE2, 0x85, 0xB2 },
	0xA2A4,	{ 0xE2, 0x85, 0xB3 },
	0xA2A5,	{ 0xE2, 0x85, 0xB4 },
	0xA2A6,	{ 0xE2, 0x85, 0xB5 },
	0xA2A7,	{ 0xE2, 0x85, 0xB6 },
	0xA2A8,	{ 0xE2, 0x85, 0xB7 },
	0xA2A9,	{ 0xE2, 0x85, 0xB8 },
	0xA2AA,	{ 0xE2, 0x85, 0xB9 },
	0xA2AB,	{ 0xEE, 0x9D, 0xA6 },
	0xA2AC,	{ 0xEE, 0x9D, 0xA7 },
	0xA2AD,	{ 0xEE, 0x9D, 0xA8 },
	0xA2AE,	{ 0xEE, 0x9D, 0xA9 },
	0xA2AF,	{ 0xEE, 0x9D, 0xAA },
	0xA2B0,	{ 0xEE, 0x9D, 0xAB },
	0xA2B1,	{ 0xE2, 0x92, 0x88 },
	0xA2B2,	{ 0xE2, 0x92, 0x89 },
	0xA2B3,	{ 0xE2, 0x92, 0x8A },
	0xA2B4,	{ 0xE2, 0x92, 0x8B },
	0xA2B5,	{ 0xE2, 0x92, 0x8C },
	0xA2B6,	{ 0xE2, 0x92, 0x8D },
	0xA2B7,	{ 0xE2, 0x92, 0x8E },
	0xA2B8,	{ 0xE2, 0x92, 0x8F },
	0xA2B9,	{ 0xE2, 0x92, 0x90 },
	0xA2BA,	{ 0xE2, 0x92, 0x91 },
	0xA2BB,	{ 0xE2, 0x92, 0x92 },
	0xA2BC,	{ 0xE2, 0x92, 0x93 },
	0xA2BD,	{ 0xE2, 0x92, 0x94 },
	0xA2BE,	{ 0xE2, 0x92, 0x95 },
	0xA2BF,	{ 0xE2, 0x92, 0x96 },
	0xA2C0,	{ 0xE2, 0x92, 0x97 },
	0xA2C1,	{ 0xE2, 0x92, 0x98 },
	0xA2C2,	{ 0xE2, 0x92, 0x99 },
	0xA2C3,	{ 0xE2, 0x92, 0x9A },
	0xA2C4,	{ 0xE2, 0x92, 0x9B },
	0xA2C5,	{ 0xE2, 0x91, 0xB4 },
	0xA2C6,	{ 0xE2, 0x91, 0xB5 },
	0xA2C7,	{ 0xE2, 0x91, 0xB6 },
	0xA2C8,	{ 0xE2, 0x91, 0xB7 },
	0xA2C9,	{ 0xE2, 0x91, 0xB8 },
	0xA2CA,	{ 0xE2, 0x91, 0xB9 },
	0xA2CB,	{ 0xE2, 0x91, 0xBA },
	0xA2CC,	{ 0xE2, 0x91, 0xBB },
	0xA2CD,	{ 0xE2, 0x91, 0xBC },
	0xA2CE,	{ 0xE2, 0x91, 0xBD },
	0xA2CF,	{ 0xE2, 0x91, 0xBE },
	0xA2D0,	{ 0xE2, 0x91, 0xBF },
	0xA2D1,	{ 0xE2, 0x92, 0x80 },
	0xA2D2,	{ 0xE2, 0x92, 0x81 },
	0xA2D3,	{ 0xE2, 0x92, 0x82 },
	0xA2D4,	{ 0xE2, 0x92, 0x83 },
	0xA2D5,	{ 0xE2, 0x92, 0x84 },
	0xA2D6,	{ 0xE2, 0x92, 0x85 },
	0xA2D7,	{ 0xE2, 0x92, 0x86 },
	0xA2D8,	{ 0xE2, 0x92, 0x87 },
	0xA2D9,	{ 0xE2, 0x91, 0xA0 },
	0xA2DA,	{ 0xE2, 0x91, 0xA1 },
	0xA2DB,	{ 0xE2, 0x91, 0xA2 },
	0xA2DC,	{ 0xE2, 0x91, 0xA3 },
	0xA2DD,	{ 0xE2, 0x91, 0xA4 },
	0xA2DE,	{ 0xE2, 0x91, 0xA5 },
	0xA2DF,	{ 0xE2, 0x91, 0xA6 },
	0xA2E0,	{ 0xE2, 0x91, 0xA7 },
	0xA2E1,	{ 0xE2, 0x91, 0xA8 },
	0xA2E2,	{ 0xE2, 0x91, 0xA9 },
	0xA2E3,	{ 0xE2, 0x82, 0xAC },
	0xA2E4,	{ 0xEE, 0x9D, 0xAD },
	0xA2E5,	{ 0xE3, 0x88, 0xA0 },
	0xA2E6,	{ 0xE3, 0x88, 0xA1 },
	0xA2E7,	{ 0xE3, 0x88, 0xA2 },
	0xA2E8,	{ 0xE3, 0x88, 0xA3 },
	0xA2E9,	{ 0xE3, 0x88, 0xA4 },
	0xA2EA,	{ 0xE3, 0x88, 0xA5 },
	0xA2EB,	{ 0xE3, 0x88, 0xA6 },
	0xA2EC,	{ 0xE3, 0x88, 0xA7 },
	0xA2ED,	{ 0xE3, 0x88, 0xA8 },
	0xA2EE,	{ 0xE3, 0x88, 0xA9 },
	0xA2EF,	{ 0xEE, 0x9D, 0xAE },
	0xA2F0,	{ 0xEE, 0x9D, 0xAF },
	0xA2F1,	{ 0xE2, 0x85, 0xA0 },
	0xA2F2,	{ 0xE2, 0x85, 0xA1 },
	0xA2F3,	{ 0xE2, 0x85, 0xA2 },
	0xA2F4,	{ 0xE2, 0x85, 0xA3 },
	0xA2F5,	{ 0xE2, 0x85, 0xA4 },
	0xA2F6,	{ 0xE2, 0x85, 0xA5 },
	0xA2F7,	{ 0xE2, 0x85, 0xA6 },
	0xA2F8,	{ 0xE2, 0x85, 0xA7 },
	0xA2F9,	{ 0xE2, 0x85, 0xA8 },
	0xA2FA,	{ 0xE2, 0x85, 0xA9 },
	0xA2FB,	{ 0xE2, 0x85, 0xAA },
	0xA2FC,	{ 0xE2, 0x85, 0xAB },
	0xA2FD,	{ 0xEE, 0x9D, 0xB0 },
	0xA2FE,	{ 0xEE, 0x9D, 0xB1 },
	0xA340,	{ 0xEE, 0x96, 0x86 },
	0xA341,	{ 0xEE, 0x96, 0x87 },
	0xA342,	{ 0xEE, 0x96, 0x88 },
	0xA343,	{ 0xEE, 0x96, 0x89 },
	0xA344,	{ 0xEE, 0x96, 0x8A },
	0xA345,	{ 0xEE, 0x96, 0x8B },
	0xA346,	{ 0xEE, 0x96, 0x8C },
	0xA347,	{ 0xEE, 0x96, 0x8D },
	0xA348,	{ 0xEE, 0x96, 0x8E },
	0xA349,	{ 0xEE, 0x96, 0x8F },
	0xA34A,	{ 0xEE, 0x96, 0x90 },
	0xA34B,	{ 0xEE, 0x96, 0x91 },
	0xA34C,	{ 0xEE, 0x96, 0x92 },
	0xA34D,	{ 0xEE, 0x96, 0x93 },
	0xA34E,	{ 0xEE, 0x96, 0x94 },
	0xA34F,	{ 0xEE, 0x96, 0x95 },
	0xA350,	{ 0xEE, 0x96, 0x96 },
	0xA351,	{ 0xEE, 0x96, 0x97 },
	0xA352,	{ 0xEE, 0x96, 0x98 },
	0xA353,	{ 0xEE, 0x96, 0x99 },
	0xA354,	{ 0xEE, 0x96, 0x9A },
	0xA355,	{ 0xEE, 0x96, 0x9B },
	0xA356,	{ 0xEE, 0x96, 0x9C },
	0xA357,	{ 0xEE, 0x96, 0x9D },
	0xA358,	{ 0xEE, 0x96, 0x9E },
	0xA359,	{ 0xEE, 0x96, 0x9F },
	0xA35A,	{ 0xEE, 0x96, 0xA0 },
	0xA35B,	{ 0xEE, 0x96, 0xA1 },
	0xA35C,	{ 0xEE, 0x96, 0xA2 },
	0xA35D,	{ 0xEE, 0x96, 0xA3 },
	0xA35E,	{ 0xEE, 0x96, 0xA4 },
	0xA35F,	{ 0xEE, 0x96, 0xA5 },
	0xA360,	{ 0xEE, 0x96, 0xA6 },
	0xA361,	{ 0xEE, 0x96, 0xA7 },
	0xA362,	{ 0xEE, 0x96, 0xA8 },
	0xA363,	{ 0xEE, 0x96, 0xA9 },
	0xA364,	{ 0xEE, 0x96, 0xAA },
	0xA365,	{ 0xEE, 0x96, 0xAB },
	0xA366,	{ 0xEE, 0x96, 0xAC },
	0xA367,	{ 0xEE, 0x96, 0xAD },
	0xA368,	{ 0xEE, 0x96, 0xAE },
	0xA369,	{ 0xEE, 0x96, 0xAF },
	0xA36A,	{ 0xEE, 0x96, 0xB0 },
	0xA36B,	{ 0xEE, 0x96, 0xB1 },
	0xA36C,	{ 0xEE, 0x96, 0xB2 },
	0xA36D,	{ 0xEE, 0x96, 0xB3 },
	0xA36E,	{ 0xEE, 0x96, 0xB4 },
	0xA36F,	{ 0xEE, 0x96, 0xB5 },
	0xA370,	{ 0xEE, 0x96, 0xB6 },
	0xA371,	{ 0xEE, 0x96, 0xB7 },
	0xA372,	{ 0xEE, 0x96, 0xB8 },
	0xA373,	{ 0xEE, 0x96, 0xB9 },
	0xA374,	{ 0xEE, 0x96, 0xBA },
	0xA375,	{ 0xEE, 0x96, 0xBB },
	0xA376,	{ 0xEE, 0x96, 0xBC },
	0xA377,	{ 0xEE, 0x96, 0xBD },
	0xA378,	{ 0xEE, 0x96, 0xBE },
	0xA379,	{ 0xEE, 0x96, 0xBF },
	0xA37A,	{ 0xEE, 0x97, 0x80 },
	0xA37B,	{ 0xEE, 0x97, 0x81 },
	0xA37C,	{ 0xEE, 0x97, 0x82 },
	0xA37D,	{ 0xEE, 0x97, 0x83 },
	0xA37E,	{ 0xEE, 0x97, 0x84 },
	0xA380,	{ 0xEE, 0x97, 0x85 },
	0xA381,	{ 0xEE, 0x97, 0x86 },
	0xA382,	{ 0xEE, 0x97, 0x87 },
	0xA383,	{ 0xEE, 0x97, 0x88 },
	0xA384,	{ 0xEE, 0x97, 0x89 },
	0xA385,	{ 0xEE, 0x97, 0x8A },
	0xA386,	{ 0xEE, 0x97, 0x8B },
	0xA387,	{ 0xEE, 0x97, 0x8C },
	0xA388,	{ 0xEE, 0x97, 0x8D },
	0xA389,	{ 0xEE, 0x97, 0x8E },
	0xA38A,	{ 0xEE, 0x97, 0x8F },
	0xA38B,	{ 0xEE, 0x97, 0x90 },
	0xA38C,	{ 0xEE, 0x97, 0x91 },
	0xA38D,	{ 0xEE, 0x97, 0x92 },
	0xA38E,	{ 0xEE, 0x97, 0x93 },
	0xA38F,	{ 0xEE, 0x97, 0x94 },
	0xA390,	{ 0xEE, 0x97, 0x95 },
	0xA391,	{ 0xEE, 0x97, 0x96 },
	0xA392,	{ 0xEE, 0x97, 0x97 },
	0xA393,	{ 0xEE, 0x97, 0x98 },
	0xA394,	{ 0xEE, 0x97, 0x99 },
	0xA395,	{ 0xEE, 0x97, 0x9A },
	0xA396,	{ 0xEE, 0x97, 0x9B },
	0xA397,	{ 0xEE, 0x97, 0x9C },
	0xA398,	{ 0xEE, 0x97, 0x9D },
	0xA399,	{ 0xEE, 0x97, 0x9E },
	0xA39A,	{ 0xEE, 0x97, 0x9F },
	0xA39B,	{ 0xEE, 0x97, 0xA0 },
	0xA39C,	{ 0xEE, 0x97, 0xA1 },
	0xA39D,	{ 0xEE, 0x97, 0xA2 },
	0xA39E,	{ 0xEE, 0x97, 0xA3 },
	0xA39F,	{ 0xEE, 0x97, 0xA4 },
	0xA3A0,	{ 0xEE, 0x97, 0xA5 },
	0xA3A1,	{ 0xEF, 0xBC, 0x81 },
	0xA3A2,	{ 0xEF, 0xBC, 0x82 },
	0xA3A3,	{ 0xEF, 0xBC, 0x83 },
	0xA3A4,	{ 0xEF, 0xBF, 0xA5 },
	0xA3A5,	{ 0xEF, 0xBC, 0x85 },
	0xA3A6,	{ 0xEF, 0xBC, 0x86 },
	0xA3A7,	{ 0xEF, 0xBC, 0x87 },
	0xA3A8,	{ 0xEF, 0xBC, 0x88 },
	0xA3A9,	{ 0xEF, 0xBC, 0x89 },
	0xA3AA,	{ 0xEF, 0xBC, 0x8A },
	0xA3AB,	{ 0xEF, 0xBC, 0x8B },
	0xA3AC,	{ 0xEF, 0xBC, 0x8C },
	0xA3AD,	{ 0xEF, 0xBC, 0x8D },
	0xA3AE,	{ 0xEF, 0xBC, 0x8E },
	0xA3AF,	{ 0xEF, 0xBC, 0x8F },
	0xA3B0,	{ 0xEF, 0xBC, 0x90 },
	0xA3B1,	{ 0xEF, 0xBC, 0x91 },
	0xA3B2,	{ 0xEF, 0xBC, 0x92 },
	0xA3B3,	{ 0xEF, 0xBC, 0x93 },
	0xA3B4,	{ 0xEF, 0xBC, 0x94 },
	0xA3B5,	{ 0xEF, 0xBC, 0x95 },
	0xA3B6,	{ 0xEF, 0xBC, 0x96 },
	0xA3B7,	{ 0xEF, 0xBC, 0x97 },
	0xA3B8,	{ 0xEF, 0xBC, 0x98 },
	0xA3B9,	{ 0xEF, 0xBC, 0x99 },
	0xA3BA,	{ 0xEF, 0xBC, 0x9A },
	0xA3BB,	{ 0xEF, 0xBC, 0x9B },
	0xA3BC,	{ 0xEF, 0xBC, 0x9C },
	0xA3BD,	{ 0xEF, 0xBC, 0x9D },
	0xA3BE,	{ 0xEF, 0xBC, 0x9E },
	0xA3BF,	{ 0xEF, 0xBC, 0x9F },
	0xA3C0,	{ 0xEF, 0xBC, 0xA0 },
	0xA3C1,	{ 0xEF, 0xBC, 0xA1 },
	0xA3C2,	{ 0xEF, 0xBC, 0xA2 },
	0xA3C3,	{ 0xEF, 0xBC, 0xA3 },
	0xA3C4,	{ 0xEF, 0xBC, 0xA4 },
	0xA3C5,	{ 0xEF, 0xBC, 0xA5 },
	0xA3C6,	{ 0xEF, 0xBC, 0xA6 },
	0xA3C7,	{ 0xEF, 0xBC, 0xA7 },
	0xA3C8,	{ 0xEF, 0xBC, 0xA8 },
	0xA3C9,	{ 0xEF, 0xBC, 0xA9 },
	0xA3CA,	{ 0xEF, 0xBC, 0xAA },
	0xA3CB,	{ 0xEF, 0xBC, 0xAB },
	0xA3CC,	{ 0xEF, 0xBC, 0xAC },
	0xA3CD,	{ 0xEF, 0xBC, 0xAD },
	0xA3CE,	{ 0xEF, 0xBC, 0xAE },
	0xA3CF,	{ 0xEF, 0xBC, 0xAF },
	0xA3D0,	{ 0xEF, 0xBC, 0xB0 },
	0xA3D1,	{ 0xEF, 0xBC, 0xB1 },
	0xA3D2,	{ 0xEF, 0xBC, 0xB2 },
	0xA3D3,	{ 0xEF, 0xBC, 0xB3 },
	0xA3D4,	{ 0xEF, 0xBC, 0xB4 },
	0xA3D5,	{ 0xEF, 0xBC, 0xB5 },
	0xA3D6,	{ 0xEF, 0xBC, 0xB6 },
	0xA3D7,	{ 0xEF, 0xBC, 0xB7 },
	0xA3D8,	{ 0xEF, 0xBC, 0xB8 },
	0xA3D9,	{ 0xEF, 0xBC, 0xB9 },
	0xA3DA,	{ 0xEF, 0xBC, 0xBA },
	0xA3DB,	{ 0xEF, 0xBC, 0xBB },
	0xA3DC,	{ 0xEF, 0xBC, 0xBC },
	0xA3DD,	{ 0xEF, 0xBC, 0xBD },
	0xA3DE,	{ 0xEF, 0xBC, 0xBE },
	0xA3DF,	{ 0xEF, 0xBC, 0xBF },
	0xA3E0,	{ 0xEF, 0xBD, 0x80 },
	0xA3E1,	{ 0xEF, 0xBD, 0x81 },
	0xA3E2,	{ 0xEF, 0xBD, 0x82 },
	0xA3E3,	{ 0xEF, 0xBD, 0x83 },
	0xA3E4,	{ 0xEF, 0xBD, 0x84 },
	0xA3E5,	{ 0xEF, 0xBD, 0x85 },
	0xA3E6,	{ 0xEF, 0xBD, 0x86 },
	0xA3E7,	{ 0xEF, 0xBD, 0x87 },
	0xA3E8,	{ 0xEF, 0xBD, 0x88 },
	0xA3E9,	{ 0xEF, 0xBD, 0x89 },
	0xA3EA,	{ 0xEF, 0xBD, 0x8A },
	0xA3EB,	{ 0xEF, 0xBD, 0x8B },
	0xA3EC,	{ 0xEF, 0xBD, 0x8C },
	0xA3ED,	{ 0xEF, 0xBD, 0x8D },
	0xA3EE,	{ 0xEF, 0xBD, 0x8E },
	0xA3EF,	{ 0xEF, 0xBD, 0x8F },
	0xA3F0,	{ 0xEF, 0xBD, 0x90 },
	0xA3F1,	{ 0xEF, 0xBD, 0x91 },
	0xA3F2,	{ 0xEF, 0xBD, 0x92 },
	0xA3F3,	{ 0xEF, 0xBD, 0x93 },
	0xA3F4,	{ 0xEF, 0xBD, 0x94 },
	0xA3F5,	{ 0xEF, 0xBD, 0x95 },
	0xA3F6,	{ 0xEF, 0xBD, 0x96 },
	0xA3F7,	{ 0xEF, 0xBD, 0x97 },
	0xA3F8,	{ 0xEF, 0xBD, 0x98 },
	0xA3F9,	{ 0xEF, 0xBD, 0x99 },
	0xA3FA,	{ 0xEF, 0xBD, 0x9A },
	0xA3FB,	{ 0xEF, 0xBD, 0x9B },
	0xA3FC,	{ 0xEF, 0xBD, 0x9C },
	0xA3FD,	{ 0xEF, 0xBD, 0x9D },
	0xA3FE,	{ 0xEF, 0xBF, 0xA3 },
	0xA440,	{ 0xEE, 0x97, 0xA6 },
	0xA441,	{ 0xEE, 0x97, 0xA7 },
	0xA442,	{ 0xEE, 0x97, 0xA8 },
	0xA443,	{ 0xEE, 0x97, 0xA9 },
	0xA444,	{ 0xEE, 0x97, 0xAA },
	0xA445,	{ 0xEE, 0x97, 0xAB },
	0xA446,	{ 0xEE, 0x97, 0xAC },
	0xA447,	{ 0xEE, 0x97, 0xAD },
	0xA448,	{ 0xEE, 0x97, 0xAE },
	0xA449,	{ 0xEE, 0x97, 0xAF },
	0xA44A,	{ 0xEE, 0x97, 0xB0 },
	0xA44B,	{ 0xEE, 0x97, 0xB1 },
	0xA44C,	{ 0xEE, 0x97, 0xB2 },
	0xA44D,	{ 0xEE, 0x97, 0xB3 },
	0xA44E,	{ 0xEE, 0x97, 0xB4 },
	0xA44F,	{ 0xEE, 0x97, 0xB5 },
	0xA450,	{ 0xEE, 0x97, 0xB6 },
	0xA451,	{ 0xEE, 0x97, 0xB7 },
	0xA452,	{ 0xEE, 0x97, 0xB8 },
	0xA453,	{ 0xEE, 0x97, 0xB9 },
	0xA454,	{ 0xEE, 0x97, 0xBA },
	0xA455,	{ 0xEE, 0x97, 0xBB },
	0xA456,	{ 0xEE, 0x97, 0xBC },
	0xA457,	{ 0xEE, 0x97, 0xBD },
	0xA458,	{ 0xEE, 0x97, 0xBE },
	0xA459,	{ 0xEE, 0x97, 0xBF },
	0xA45A,	{ 0xEE, 0x98, 0x80 },
	0xA45B,	{ 0xEE, 0x98, 0x81 },
	0xA45C,	{ 0xEE, 0x98, 0x82 },
	0xA45D,	{ 0xEE, 0x98, 0x83 },
	0xA45E,	{ 0xEE, 0x98, 0x84 },
	0xA45F,	{ 0xEE, 0x98, 0x85 },
	0xA460,	{ 0xEE, 0x98, 0x86 },
	0xA461,	{ 0xEE, 0x98, 0x87 },
	0xA462,	{ 0xEE, 0x98, 0x88 },
	0xA463,	{ 0xEE, 0x98, 0x89 },
	0xA464,	{ 0xEE, 0x98, 0x8A },
	0xA465,	{ 0xEE, 0x98, 0x8B },
	0xA466,	{ 0xEE, 0x98, 0x8C },
	0xA467,	{ 0xEE, 0x98, 0x8D },
	0xA468,	{ 0xEE, 0x98, 0x8E },
	0xA469,	{ 0xEE, 0x98, 0x8F },
	0xA46A,	{ 0xEE, 0x98, 0x90 },
	0xA46B,	{ 0xEE, 0x98, 0x91 },
	0xA46C,	{ 0xEE, 0x98, 0x92 },
	0xA46D,	{ 0xEE, 0x98, 0x93 },
	0xA46E,	{ 0xEE, 0x98, 0x94 },
	0xA46F,	{ 0xEE, 0x98, 0x95 },
	0xA470,	{ 0xEE, 0x98, 0x96 },
	0xA471,	{ 0xEE, 0x98, 0x97 },
	0xA472,	{ 0xEE, 0x98, 0x98 },
	0xA473,	{ 0xEE, 0x98, 0x99 },
	0xA474,	{ 0xEE, 0x98, 0x9A },
	0xA475,	{ 0xEE, 0x98, 0x9B },
	0xA476,	{ 0xEE, 0x98, 0x9C },
	0xA477,	{ 0xEE, 0x98, 0x9D },
	0xA478,	{ 0xEE, 0x98, 0x9E },
	0xA479,	{ 0xEE, 0x98, 0x9F },
	0xA47A,	{ 0xEE, 0x98, 0xA0 },
	0xA47B,	{ 0xEE, 0x98, 0xA1 },
	0xA47C,	{ 0xEE, 0x98, 0xA2 },
	0xA47D,	{ 0xEE, 0x98, 0xA3 },
	0xA47E,	{ 0xEE, 0x98, 0xA4 },
	0xA480,	{ 0xEE, 0x98, 0xA5 },
	0xA481,	{ 0xEE, 0x98, 0xA6 },
	0xA482,	{ 0xEE, 0x98, 0xA7 },
	0xA483,	{ 0xEE, 0x98, 0xA8 },
	0xA484,	{ 0xEE, 0x98, 0xA9 },
	0xA485,	{ 0xEE, 0x98, 0xAA },
	0xA486,	{ 0xEE, 0x98, 0xAB },
	0xA487,	{ 0xEE, 0x98, 0xAC },
	0xA488,	{ 0xEE, 0x98, 0xAD },
	0xA489,	{ 0xEE, 0x98, 0xAE },
	0xA48A,	{ 0xEE, 0x98, 0xAF },
	0xA48B,	{ 0xEE, 0x98, 0xB0 },
	0xA48C,	{ 0xEE, 0x98, 0xB1 },
	0xA48D,	{ 0xEE, 0x98, 0xB2 },
	0xA48E,	{ 0xEE, 0x98, 0xB3 },
	0xA48F,	{ 0xEE, 0x98, 0xB4 },
	0xA490,	{ 0xEE, 0x98, 0xB5 },
	0xA491,	{ 0xEE, 0x98, 0xB6 },
	0xA492,	{ 0xEE, 0x98, 0xB7 },
	0xA493,	{ 0xEE, 0x98, 0xB8 },
	0xA494,	{ 0xEE, 0x98, 0xB9 },
	0xA495,	{ 0xEE, 0x98, 0xBA },
	0xA496,	{ 0xEE, 0x98, 0xBB },
	0xA497,	{ 0xEE, 0x98, 0xBC },
	0xA498,	{ 0xEE, 0x98, 0xBD },
	0xA499,	{ 0xEE, 0x98, 0xBE },
	0xA49A,	{ 0xEE, 0x98, 0xBF },
	0xA49B,	{ 0xEE, 0x99, 0x80 },
	0xA49C,	{ 0xEE, 0x99, 0x81 },
	0xA49D,	{ 0xEE, 0x99, 0x82 },
	0xA49E,	{ 0xEE, 0x99, 0x83 },
	0xA49F,	{ 0xEE, 0x99, 0x84 },
	0xA4A0,	{ 0xEE, 0x99, 0x85 },
	0xA4A1,	{ 0xE3, 0x81, 0x81 },
	0xA4A2,	{ 0xE3, 0x81, 0x82 },
	0xA4A3,	{ 0xE3, 0x81, 0x83 },
	0xA4A4,	{ 0xE3, 0x81, 0x84 },
	0xA4A5,	{ 0xE3, 0x81, 0x85 },
	0xA4A6,	{ 0xE3, 0x81, 0x86 },
	0xA4A7,	{ 0xE3, 0x81, 0x87 },
	0xA4A8,	{ 0xE3, 0x81, 0x88 },
	0xA4A9,	{ 0xE3, 0x81, 0x89 },
	0xA4AA,	{ 0xE3, 0x81, 0x8A },
	0xA4AB,	{ 0xE3, 0x81, 0x8B },
	0xA4AC,	{ 0xE3, 0x81, 0x8C },
	0xA4AD,	{ 0xE3, 0x81, 0x8D },
	0xA4AE,	{ 0xE3, 0x81, 0x8E },
	0xA4AF,	{ 0xE3, 0x81, 0x8F },
	0xA4B0,	{ 0xE3, 0x81, 0x90 },
	0xA4B1,	{ 0xE3, 0x81, 0x91 },
	0xA4B2,	{ 0xE3, 0x81, 0x92 },
	0xA4B3,	{ 0xE3, 0x81, 0x93 },
	0xA4B4,	{ 0xE3, 0x81, 0x94 },
	0xA4B5,	{ 0xE3, 0x81, 0x95 },
	0xA4B6,	{ 0xE3, 0x81, 0x96 },
	0xA4B7,	{ 0xE3, 0x81, 0x97 },
	0xA4B8,	{ 0xE3, 0x81, 0x98 },
	0xA4B9,	{ 0xE3, 0x81, 0x99 },
	0xA4BA,	{ 0xE3, 0x81, 0x9A },
	0xA4BB,	{ 0xE3, 0x81, 0x9B },
	0xA4BC,	{ 0xE3, 0x81, 0x9C },
	0xA4BD,	{ 0xE3, 0x81, 0x9D },
	0xA4BE,	{ 0xE3, 0x81, 0x9E },
	0xA4BF,	{ 0xE3, 0x81, 0x9F },
	0xA4C0,	{ 0xE3, 0x81, 0xA0 },
	0xA4C1,	{ 0xE3, 0x81, 0xA1 },
	0xA4C2,	{ 0xE3, 0x81, 0xA2 },
	0xA4C3,	{ 0xE3, 0x81, 0xA3 },
	0xA4C4,	{ 0xE3, 0x81, 0xA4 },
	0xA4C5,	{ 0xE3, 0x81, 0xA5 },
	0xA4C6,	{ 0xE3, 0x81, 0xA6 },
	0xA4C7,	{ 0xE3, 0x81, 0xA7 },
	0xA4C8,	{ 0xE3, 0x81, 0xA8 },
	0xA4C9,	{ 0xE3, 0x81, 0xA9 },
	0xA4CA,	{ 0xE3, 0x81, 0xAA },
	0xA4CB,	{ 0xE3, 0x81, 0xAB },
	0xA4CC,	{ 0xE3, 0x81, 0xAC },
	0xA4CD,	{ 0xE3, 0x81, 0xAD },
	0xA4CE,	{ 0xE3, 0x81, 0xAE },
	0xA4CF,	{ 0xE3, 0x81, 0xAF },
	0xA4D0,	{ 0xE3, 0x81, 0xB0 },
	0xA4D1,	{ 0xE3, 0x81, 0xB1 },
	0xA4D2,	{ 0xE3, 0x81, 0xB2 },
	0xA4D3,	{ 0xE3, 0x81, 0xB3 },
	0xA4D4,	{ 0xE3, 0x81, 0xB4 },
	0xA4D5,	{ 0xE3, 0x81, 0xB5 },
	0xA4D6,	{ 0xE3, 0x81, 0xB6 },
	0xA4D7,	{ 0xE3, 0x81, 0xB7 },
	0xA4D8,	{ 0xE3, 0x81, 0xB8 },
	0xA4D9,	{ 0xE3, 0x81, 0xB9 },
	0xA4DA,	{ 0xE3, 0x81, 0xBA },
	0xA4DB,	{ 0xE3, 0x81, 0xBB },
	0xA4DC,	{ 0xE3, 0x81, 0xBC },
	0xA4DD,	{ 0xE3, 0x81, 0xBD },
	0xA4DE,	{ 0xE3, 0x81, 0xBE },
	0xA4DF,	{ 0xE3, 0x81, 0xBF },
	0xA4E0,	{ 0xE3, 0x82, 0x80 },
	0xA4E1,	{ 0xE3, 0x82, 0x81 },
	0xA4E2,	{ 0xE3, 0x82, 0x82 },
	0xA4E3,	{ 0xE3, 0x82, 0x83 },
	0xA4E4,	{ 0xE3, 0x82, 0x84 },
	0xA4E5,	{ 0xE3, 0x82, 0x85 },
	0xA4E6,	{ 0xE3, 0x82, 0x86 },
	0xA4E7,	{ 0xE3, 0x82, 0x87 },
	0xA4E8,	{ 0xE3, 0x82, 0x88 },
	0xA4E9,	{ 0xE3, 0x82, 0x89 },
	0xA4EA,	{ 0xE3, 0x82, 0x8A },
	0xA4EB,	{ 0xE3, 0x82, 0x8B },
	0xA4EC,	{ 0xE3, 0x82, 0x8C },
	0xA4ED,	{ 0xE3, 0x82, 0x8D },
	0xA4EE,	{ 0xE3, 0x82, 0x8E },
	0xA4EF,	{ 0xE3, 0x82, 0x8F },
	0xA4F0,	{ 0xE3, 0x82, 0x90 },
	0xA4F1,	{ 0xE3, 0x82, 0x91 },
	0xA4F2,	{ 0xE3, 0x82, 0x92 },
	0xA4F3,	{ 0xE3, 0x82, 0x93 },
	0xA4F4,	{ 0xEE, 0x9D, 0xB2 },
	0xA4F5,	{ 0xEE, 0x9D, 0xB3 },
	0xA4F6,	{ 0xEE, 0x9D, 0xB4 },
	0xA4F7,	{ 0xEE, 0x9D, 0xB5 },
	0xA4F8,	{ 0xEE, 0x9D, 0xB6 },
	0xA4F9,	{ 0xEE, 0x9D, 0xB7 },
	0xA4FA,	{ 0xEE, 0x9D, 0xB8 },
	0xA4FB,	{ 0xEE, 0x9D, 0xB9 },
	0xA4FC,	{ 0xEE, 0x9D, 0xBA },
	0xA4FD,	{ 0xEE, 0x9D, 0xBB },
	0xA4FE,	{ 0xEE, 0x9D, 0xBC },
	0xA540,	{ 0xEE, 0x99, 0x86 },
	0xA541,	{ 0xEE, 0x99, 0x87 },
	0xA542,	{ 0xEE, 0x99, 0x88 },
	0xA543,	{ 0xEE, 0x99, 0x89 },
	0xA544,	{ 0xEE, 0x99, 0x8A },
	0xA545,	{ 0xEE, 0x99, 0x8B },
	0xA546,	{ 0xEE, 0x99, 0x8C },
	0xA547,	{ 0xEE, 0x99, 0x8D },
	0xA548,	{ 0xEE, 0x99, 0x8E },
	0xA549,	{ 0xEE, 0x99, 0x8F },
	0xA54A,	{ 0xEE, 0x99, 0x90 },
	0xA54B,	{ 0xEE, 0x99, 0x91 },
	0xA54C,	{ 0xEE, 0x99, 0x92 },
	0xA54D,	{ 0xEE, 0x99, 0x93 },
	0xA54E,	{ 0xEE, 0x99, 0x94 },
	0xA54F,	{ 0xEE, 0x99, 0x95 },
	0xA550,	{ 0xEE, 0x99, 0x96 },
	0xA551,	{ 0xEE, 0x99, 0x97 },
	0xA552,	{ 0xEE, 0x99, 0x98 },
	0xA553,	{ 0xEE, 0x99, 0x99 },
	0xA554,	{ 0xEE, 0x99, 0x9A },
	0xA555,	{ 0xEE, 0x99, 0x9B },
	0xA556,	{ 0xEE, 0x99, 0x9C },
	0xA557,	{ 0xEE, 0x99, 0x9D },
	0xA558,	{ 0xEE, 0x99, 0x9E },
	0xA559,	{ 0xEE, 0x99, 0x9F },
	0xA55A,	{ 0xEE, 0x99, 0xA0 },
	0xA55B,	{ 0xEE, 0x99, 0xA1 },
	0xA55C,	{ 0xEE, 0x99, 0xA2 },
	0xA55D,	{ 0xEE, 0x99, 0xA3 },
	0xA55E,	{ 0xEE, 0x99, 0xA4 },
	0xA55F,	{ 0xEE, 0x99, 0xA5 },
	0xA560,	{ 0xEE, 0x99, 0xA6 },
	0xA561,	{ 0xEE, 0x99, 0xA7 },
	0xA562,	{ 0xEE, 0x99, 0xA8 },
	0xA563,	{ 0xEE, 0x99, 0xA9 },
	0xA564,	{ 0xEE, 0x99, 0xAA },
	0xA565,	{ 0xEE, 0x99, 0xAB },
	0xA566,	{ 0xEE, 0x99, 0xAC },
	0xA567,	{ 0xEE, 0x99, 0xAD },
	0xA568,	{ 0xEE, 0x99, 0xAE },
	0xA569,	{ 0xEE, 0x99, 0xAF },
	0xA56A,	{ 0xEE, 0x99, 0xB0 },
	0xA56B,	{ 0xEE, 0x99, 0xB1 },
	0xA56C,	{ 0xEE, 0x99, 0xB2 },
	0xA56D,	{ 0xEE, 0x99, 0xB3 },
	0xA56E,	{ 0xEE, 0x99, 0xB4 },
	0xA56F,	{ 0xEE, 0x99, 0xB5 },
	0xA570,	{ 0xEE, 0x99, 0xB6 },
	0xA571,	{ 0xEE, 0x99, 0xB7 },
	0xA572,	{ 0xEE, 0x99, 0xB8 },
	0xA573,	{ 0xEE, 0x99, 0xB9 },
	0xA574,	{ 0xEE, 0x99, 0xBA },
	0xA575,	{ 0xEE, 0x99, 0xBB },
	0xA576,	{ 0xEE, 0x99, 0xBC },
	0xA577,	{ 0xEE, 0x99, 0xBD },
	0xA578,	{ 0xEE, 0x99, 0xBE },
	0xA579,	{ 0xEE, 0x99, 0xBF },
	0xA57A,	{ 0xEE, 0x9A, 0x80 },
	0xA57B,	{ 0xEE, 0x9A, 0x81 },
	0xA57C,	{ 0xEE, 0x9A, 0x82 },
	0xA57D,	{ 0xEE, 0x9A, 0x83 },
	0xA57E,	{ 0xEE, 0x9A, 0x84 },
	0xA580,	{ 0xEE, 0x9A, 0x85 },
	0xA581,	{ 0xEE, 0x9A, 0x86 },
	0xA582,	{ 0xEE, 0x9A, 0x87 },
	0xA583,	{ 0xEE, 0x9A, 0x88 },
	0xA584,	{ 0xEE, 0x9A, 0x89 },
	0xA585,	{ 0xEE, 0x9A, 0x8A },
	0xA586,	{ 0xEE, 0x9A, 0x8B },
	0xA587,	{ 0xEE, 0x9A, 0x8C },
	0xA588,	{ 0xEE, 0x9A, 0x8D },
	0xA589,	{ 0xEE, 0x9A, 0x8E },
	0xA58A,	{ 0xEE, 0x9A, 0x8F },
	0xA58B,	{ 0xEE, 0x9A, 0x90 },
	0xA58C,	{ 0xEE, 0x9A, 0x91 },
	0xA58D,	{ 0xEE, 0x9A, 0x92 },
	0xA58E,	{ 0xEE, 0x9A, 0x93 },
	0xA58F,	{ 0xEE, 0x9A, 0x94 },
	0xA590,	{ 0xEE, 0x9A, 0x95 },
	0xA591,	{ 0xEE, 0x9A, 0x96 },
	0xA592,	{ 0xEE, 0x9A, 0x97 },
	0xA593,	{ 0xEE, 0x9A, 0x98 },
	0xA594,	{ 0xEE, 0x9A, 0x99 },
	0xA595,	{ 0xEE, 0x9A, 0x9A },
	0xA596,	{ 0xEE, 0x9A, 0x9B },
	0xA597,	{ 0xEE, 0x9A, 0x9C },
	0xA598,	{ 0xEE, 0x9A, 0x9D },
	0xA599,	{ 0xEE, 0x9A, 0x9E },
	0xA59A,	{ 0xEE, 0x9A, 0x9F },
	0xA59B,	{ 0xEE, 0x9A, 0xA0 },
	0xA59C,	{ 0xEE, 0x9A, 0xA1 },
	0xA59D,	{ 0xEE, 0x9A, 0xA2 },
	0xA59E,	{ 0xEE, 0x9A, 0xA3 },
	0xA59F,	{ 0xEE, 0x9A, 0xA4 },
	0xA5A0,	{ 0xEE, 0x9A, 0xA5 },
	0xA5A1,	{ 0xE3, 0x82, 0xA1 },
	0xA5A2,	{ 0xE3, 0x82, 0xA2 },
	0xA5A3,	{ 0xE3, 0x82, 0xA3 },
	0xA5A4,	{ 0xE3, 0x82, 0xA4 },
	0xA5A5,	{ 0xE3, 0x82, 0xA5 },
	0xA5A6,	{ 0xE3, 0x82, 0xA6 },
	0xA5A7,	{ 0xE3, 0x82, 0xA7 },
	0xA5A8,	{ 0xE3, 0x82, 0xA8 },
	0xA5A9,	{ 0xE3, 0x82, 0xA9 },
	0xA5AA,	{ 0xE3, 0x82, 0xAA },
	0xA5AB,	{ 0xE3, 0x82, 0xAB },
	0xA5AC,	{ 0xE3, 0x82, 0xAC },
	0xA5AD,	{ 0xE3, 0x82, 0xAD },
	0xA5AE,	{ 0xE3, 0x82, 0xAE },
	0xA5AF,	{ 0xE3, 0x82, 0xAF },
	0xA5B0,	{ 0xE3, 0x82, 0xB0 },
	0xA5B1,	{ 0xE3, 0x82, 0xB1 },
	0xA5B2,	{ 0xE3, 0x82, 0xB2 },
	0xA5B3,	{ 0xE3, 0x82, 0xB3 },
	0xA5B4,	{ 0xE3, 0x82, 0xB4 },
	0xA5B5,	{ 0xE3, 0x82, 0xB5 },
	0xA5B6,	{ 0xE3, 0x82, 0xB6 },
	0xA5B7,	{ 0xE3, 0x82, 0xB7 },
	0xA5B8,	{ 0xE3, 0x82, 0xB8 },
	0xA5B9,	{ 0xE3, 0x82, 0xB9 },
	0xA5BA,	{ 0xE3, 0x82, 0xBA },
	0xA5BB,	{ 0xE3, 0x82, 0xBB },
	0xA5BC,	{ 0xE3, 0x82, 0xBC },
	0xA5BD,	{ 0xE3, 0x82, 0xBD },
	0xA5BE,	{ 0xE3, 0x82, 0xBE },
	0xA5BF,	{ 0xE3, 0x82, 0xBF },
	0xA5C0,	{ 0xE3, 0x83, 0x80 },
	0xA5C1,	{ 0xE3, 0x83, 0x81 },
	0xA5C2,	{ 0xE3, 0x83, 0x82 },
	0xA5C3,	{ 0xE3, 0x83, 0x83 },
	0xA5C4,	{ 0xE3, 0x83, 0x84 },
	0xA5C5,	{ 0xE3, 0x83, 0x85 },
	0xA5C6,	{ 0xE3, 0x83, 0x86 },
	0xA5C7,	{ 0xE3, 0x83, 0x87 },
	0xA5C8,	{ 0xE3, 0x83, 0x88 },
	0xA5C9,	{ 0xE3, 0x83, 0x89 },
	0xA5CA,	{ 0xE3, 0x83, 0x8A },
	0xA5CB,	{ 0xE3, 0x83, 0x8B },
	0xA5CC,	{ 0xE3, 0x83, 0x8C },
	0xA5CD,	{ 0xE3, 0x83, 0x8D },
	0xA5CE,	{ 0xE3, 0x83, 0x8E },
	0xA5CF,	{ 0xE3, 0x83, 0x8F },
	0xA5D0,	{ 0xE3, 0x83, 0x90 },
	0xA5D1,	{ 0xE3, 0x83, 0x91 },
	0xA5D2,	{ 0xE3, 0x83, 0x92 },
	0xA5D3,	{ 0xE3, 0x83, 0x93 },
	0xA5D4,	{ 0xE3, 0x83, 0x94 },
	0xA5D5,	{ 0xE3, 0x83, 0x95 },
	0xA5D6,	{ 0xE3, 0x83, 0x96 },
	0xA5D7,	{ 0xE3, 0x83, 0x97 },
	0xA5D8,	{ 0xE3, 0x83, 0x98 },
	0xA5D9,	{ 0xE3, 0x83, 0x99 },
	0xA5DA,	{ 0xE3, 0x83, 0x9A },
	0xA5DB,	{ 0xE3, 0x83, 0x9B },
	0xA5DC,	{ 0xE3, 0x83, 0x9C },
	0xA5DD,	{ 0xE3, 0x83, 0x9D },
	0xA5DE,	{ 0xE3, 0x83, 0x9E },
	0xA5DF,	{ 0xE3, 0x83, 0x9F },
	0xA5E0,	{ 0xE3, 0x83, 0xA0 },
	0xA5E1,	{ 0xE3, 0x83, 0xA1 },
	0xA5E2,	{ 0xE3, 0x83, 0xA2 },
	0xA5E3,	{ 0xE3, 0x83, 0xA3 },
	0xA5E4,	{ 0xE3, 0x83, 0xA4 },
	0xA5E5,	{ 0xE3, 0x83, 0xA5 },
	0xA5E6,	{ 0xE3, 0x83, 0xA6 },
	0xA5E7,	{ 0xE3, 0x83, 0xA7 },
	0xA5E8,	{ 0xE3, 0x83, 0xA8 },
	0xA5E9,	{ 0xE3, 0x83, 0xA9 },
	0xA5EA,	{ 0xE3, 0x83, 0xAA },
	0xA5EB,	{ 0xE3, 0x83, 0xAB },
	0xA5EC,	{ 0xE3, 0x83, 0xAC },
	0xA5ED,	{ 0xE3, 0x83, 0xAD },
	0xA5EE,	{ 0xE3, 0x83, 0xAE },
	0xA5EF,	{ 0xE3, 0x83, 0xAF },
	0xA5F0,	{ 0xE3, 0x83, 0xB0 },
	0xA5F1,	{ 0xE3, 0x83, 0xB1 },
	0xA5F2,	{ 0xE3, 0x83, 0xB2 },
	0xA5F3,	{ 0xE3, 0x83, 0xB3 },
	0xA5F4,	{ 0xE3, 0x83, 0xB4 },
	0xA5F5,	{ 0xE3, 0x83, 0xB5 },
	0xA5F6,	{ 0xE3, 0x83, 0xB6 },
	0xA5F7,	{ 0xEE, 0x9D, 0xBD },
	0xA5F8,	{ 0xEE, 0x9D, 0xBE },
	0xA5F9,	{ 0xEE, 0x9D, 0xBF },
	0xA5FA,	{ 0xEE, 0x9E, 0x80 },
	0xA5FB,	{ 0xEE, 0x9E, 0x81 },
	0xA5FC,	{ 0xEE, 0x9E, 0x82 },
	0xA5FD,	{ 0xEE, 0x9E, 0x83 },
	0xA5FE,	{ 0xEE, 0x9E, 0x84 },
	0xA640,	{ 0xEE, 0x9A, 0xA6 },
	0xA641,	{ 0xEE, 0x9A, 0xA7 },
	0xA642,	{ 0xEE, 0x9A, 0xA8 },
	0xA643,	{ 0xEE, 0x9A, 0xA9 },
	0xA644,	{ 0xEE, 0x9A, 0xAA },
	0xA645,	{ 0xEE, 0x9A, 0xAB },
	0xA646,	{ 0xEE, 0x9A, 0xAC },
	0xA647,	{ 0xEE, 0x9A, 0xAD },
	0xA648,	{ 0xEE, 0x9A, 0xAE },
	0xA649,	{ 0xEE, 0x9A, 0xAF },
	0xA64A,	{ 0xEE, 0x9A, 0xB0 },
	0xA64B,	{ 0xEE, 0x9A, 0xB1 },
	0xA64C,	{ 0xEE, 0x9A, 0xB2 },
	0xA64D,	{ 0xEE, 0x9A, 0xB3 },
	0xA64E,	{ 0xEE, 0x9A, 0xB4 },
	0xA64F,	{ 0xEE, 0x9A, 0xB5 },
	0xA650,	{ 0xEE, 0x9A, 0xB6 },
	0xA651,	{ 0xEE, 0x9A, 0xB7 },
	0xA652,	{ 0xEE, 0x9A, 0xB8 },
	0xA653,	{ 0xEE, 0x9A, 0xB9 },
	0xA654,	{ 0xEE, 0x9A, 0xBA },
	0xA655,	{ 0xEE, 0x9A, 0xBB },
	0xA656,	{ 0xEE, 0x9A, 0xBC },
	0xA657,	{ 0xEE, 0x9A, 0xBD },
	0xA658,	{ 0xEE, 0x9A, 0xBE },
	0xA659,	{ 0xEE, 0x9A, 0xBF },
	0xA65A,	{ 0xEE, 0x9B, 0x80 },
	0xA65B,	{ 0xEE, 0x9B, 0x81 },
	0xA65C,	{ 0xEE, 0x9B, 0x82 },
	0xA65D,	{ 0xEE, 0x9B, 0x83 },
	0xA65E,	{ 0xEE, 0x9B, 0x84 },
	0xA65F,	{ 0xEE, 0x9B, 0x85 },
	0xA660,	{ 0xEE, 0x9B, 0x86 },
	0xA661,	{ 0xEE, 0x9B, 0x87 },
	0xA662,	{ 0xEE, 0x9B, 0x88 },
	0xA663,	{ 0xEE, 0x9B, 0x89 },
	0xA664,	{ 0xEE, 0x9B, 0x8A },
	0xA665,	{ 0xEE, 0x9B, 0x8B },
	0xA666,	{ 0xEE, 0x9B, 0x8C },
	0xA667,	{ 0xEE, 0x9B, 0x8D },
	0xA668,	{ 0xEE, 0x9B, 0x8E },
	0xA669,	{ 0xEE, 0x9B, 0x8F },
	0xA66A,	{ 0xEE, 0x9B, 0x90 },
	0xA66B,	{ 0xEE, 0x9B, 0x91 },
	0xA66C,	{ 0xEE, 0x9B, 0x92 },
	0xA66D,	{ 0xEE, 0x9B, 0x93 },
	0xA66E,	{ 0xEE, 0x9B, 0x94 },
	0xA66F,	{ 0xEE, 0x9B, 0x95 },
	0xA670,	{ 0xEE, 0x9B, 0x96 },
	0xA671,	{ 0xEE, 0x9B, 0x97 },
	0xA672,	{ 0xEE, 0x9B, 0x98 },
	0xA673,	{ 0xEE, 0x9B, 0x99 },
	0xA674,	{ 0xEE, 0x9B, 0x9A },
	0xA675,	{ 0xEE, 0x9B, 0x9B },
	0xA676,	{ 0xEE, 0x9B, 0x9C },
	0xA677,	{ 0xEE, 0x9B, 0x9D },
	0xA678,	{ 0xEE, 0x9B, 0x9E },
	0xA679,	{ 0xEE, 0x9B, 0x9F },
	0xA67A,	{ 0xEE, 0x9B, 0xA0 },
	0xA67B,	{ 0xEE, 0x9B, 0xA1 },
	0xA67C,	{ 0xEE, 0x9B, 0xA2 },
	0xA67D,	{ 0xEE, 0x9B, 0xA3 },
	0xA67E,	{ 0xEE, 0x9B, 0xA4 },
	0xA680,	{ 0xEE, 0x9B, 0xA5 },
	0xA681,	{ 0xEE, 0x9B, 0xA6 },
	0xA682,	{ 0xEE, 0x9B, 0xA7 },
	0xA683,	{ 0xEE, 0x9B, 0xA8 },
	0xA684,	{ 0xEE, 0x9B, 0xA9 },
	0xA685,	{ 0xEE, 0x9B, 0xAA },
	0xA686,	{ 0xEE, 0x9B, 0xAB },
	0xA687,	{ 0xEE, 0x9B, 0xAC },
	0xA688,	{ 0xEE, 0x9B, 0xAD },
	0xA689,	{ 0xEE, 0x9B, 0xAE },
	0xA68A,	{ 0xEE, 0x9B, 0xAF },
	0xA68B,	{ 0xEE, 0x9B, 0xB0 },
	0xA68C,	{ 0xEE, 0x9B, 0xB1 },
	0xA68D,	{ 0xEE, 0x9B, 0xB2 },
	0xA68E,	{ 0xEE, 0x9B, 0xB3 },
	0xA68F,	{ 0xEE, 0x9B, 0xB4 },
	0xA690,	{ 0xEE, 0x9B, 0xB5 },
	0xA691,	{ 0xEE, 0x9B, 0xB6 },
	0xA692,	{ 0xEE, 0x9B, 0xB7 },
	0xA693,	{ 0xEE, 0x9B, 0xB8 },
	0xA694,	{ 0xEE, 0x9B, 0xB9 },
	0xA695,	{ 0xEE, 0x9B, 0xBA },
	0xA696,	{ 0xEE, 0x9B, 0xBB },
	0xA697,	{ 0xEE, 0x9B, 0xBC },
	0xA698,	{ 0xEE, 0x9B, 0xBD },
	0xA699,	{ 0xEE, 0x9B, 0xBE },
	0xA69A,	{ 0xEE, 0x9B, 0xBF },
	0xA69B,	{ 0xEE, 0x9C, 0x80 },
	0xA69C,	{ 0xEE, 0x9C, 0x81 },
	0xA69D,	{ 0xEE, 0x9C, 0x82 },
	0xA69E,	{ 0xEE, 0x9C, 0x83 },
	0xA69F,	{ 0xEE, 0x9C, 0x84 },
	0xA6A0,	{ 0xEE, 0x9C, 0x85 },
	0xA6A1,	{ 0xCE, 0x91 },
	0xA6A2,	{ 0xCE, 0x92 },
	0xA6A3,	{ 0xCE, 0x93 },
	0xA6A4,	{ 0xCE, 0x94 },
	0xA6A5,	{ 0xCE, 0x95 },
	0xA6A6,	{ 0xCE, 0x96 },
	0xA6A7,	{ 0xCE, 0x97 },
	0xA6A8,	{ 0xCE, 0x98 },
	0xA6A9,	{ 0xCE, 0x99 },
	0xA6AA,	{ 0xCE, 0x9A },
	0xA6AB,	{ 0xCE, 0x9B },
	0xA6AC,	{ 0xCE, 0x9C },
	0xA6AD,	{ 0xCE, 0x9D },
	0xA6AE,	{ 0xCE, 0x9E },
	0xA6AF,	{ 0xCE, 0x9F },
	0xA6B0,	{ 0xCE, 0xA0 },
	0xA6B1,	{ 0xCE, 0xA1 },
	0xA6B2,	{ 0xCE, 0xA3 },
	0xA6B3,	{ 0xCE, 0xA4 },
	0xA6B4,	{ 0xCE, 0xA5 },
	0xA6B5,	{ 0xCE, 0xA6 },
	0xA6B6,	{ 0xCE, 0xA7 },
	0xA6B7,	{ 0xCE, 0xA8 },
	0xA6B8,	{ 0xCE, 0xA9 },
	0xA6B9,	{ 0xEE, 0x9E, 0x85 },
	0xA6BA,	{ 0xEE, 0x9E, 0x86 },
	0xA6BB,	{ 0xEE, 0x9E, 0x87 },
	0xA6BC,	{ 0xEE, 0x9E, 0x88 },
	0xA6BD,	{ 0xEE, 0x9E, 0x89 },
	0xA6BE,	{ 0xEE, 0x9E, 0x8A },
	0xA6BF,	{ 0xEE, 0x9E, 0x8B },
	0xA6C0,	{ 0xEE, 0x9E, 0x8C },
	0xA6C1,	{ 0xCE, 0xB1 },
	0xA6C2,	{ 0xCE, 0xB2 },
	0xA6C3,	{ 0xCE, 0xB3 },
	0xA6C4,	{ 0xCE, 0xB4 },
	0xA6C5,	{ 0xCE, 0xB5 },
	0xA6C6,	{ 0xCE, 0xB6 },
	0xA6C7,	{ 0xCE, 0xB7 },
	0xA6C8,	{ 0xCE, 0xB8 },
	0xA6C9,	{ 0xCE, 0xB9 },
	0xA6CA,	{ 0xCE, 0xBA },
	0xA6CB,	{ 0xCE, 0xBB },
	0xA6CC,	{ 0xCE, 0xBC },
	0xA6CD,	{ 0xCE, 0xBD },
	0xA6CE,	{ 0xCE, 0xBE },
	0xA6CF,	{ 0xCE, 0xBF },
	0xA6D0,	{ 0xCF, 0x80 },
	0xA6D1,	{ 0xCF, 0x81 },
	0xA6D2,	{ 0xCF, 0x83 },
	0xA6D3,	{ 0xCF, 0x84 },
	0xA6D4,	{ 0xCF, 0x85 },
	0xA6D5,	{ 0xCF, 0x86 },
	0xA6D6,	{ 0xCF, 0x87 },
	0xA6D7,	{ 0xCF, 0x88 },
	0xA6D8,	{ 0xCF, 0x89 },
	0xA6D9,	{ 0xEE, 0x9E, 0x8D },
	0xA6DA,	{ 0xEE, 0x9E, 0x8E },
	0xA6DB,	{ 0xEE, 0x9E, 0x8F },
	0xA6DC,	{ 0xEE, 0x9E, 0x90 },
	0xA6DD,	{ 0xEE, 0x9E, 0x91 },
	0xA6DE,	{ 0xEE, 0x9E, 0x92 },
	0xA6DF,	{ 0xEE, 0x9E, 0x93 },
	0xA6E0,	{ 0xEF, 0xB8, 0xB5 },
	0xA6E1,	{ 0xEF, 0xB8, 0xB6 },
	0xA6E2,	{ 0xEF, 0xB8, 0xB9 },
	0xA6E3,	{ 0xEF, 0xB8, 0xBA },
	0xA6E4,	{ 0xEF, 0xB8, 0xBF },
	0xA6E5,	{ 0xEF, 0xB9, 0x80 },
	0xA6E6,	{ 0xEF, 0xB8, 0xBD },
	0xA6E7,	{ 0xEF, 0xB8, 0xBE },
	0xA6E8,	{ 0xEF, 0xB9, 0x81 },
	0xA6E9,	{ 0xEF, 0xB9, 0x82 },
	0xA6EA,	{ 0xEF, 0xB9, 0x83 },
	0xA6EB,	{ 0xEF, 0xB9, 0x84 },
	0xA6EC,	{ 0xEE, 0x9E, 0x94 },
	0xA6ED,	{ 0xEE, 0x9E, 0x95 },
	0xA6EE,	{ 0xEF, 0xB8, 0xBB },
	0xA6EF,	{ 0xEF, 0xB8, 0xBC },
	0xA6F0,	{ 0xEF, 0xB8, 0xB7 },
	0xA6F1,	{ 0xEF, 0xB8, 0xB8 },
	0xA6F2,	{ 0xEF, 0xB8, 0xB1 },
	0xA6F3,	{ 0xEE, 0x9E, 0x96 },
	0xA6F4,	{ 0xEF, 0xB8, 0xB3 },
	0xA6F5,	{ 0xEF, 0xB8, 0xB4 },
	0xA6F6,	{ 0xEE, 0x9E, 0x97 },
	0xA6F7,	{ 0xEE, 0x9E, 0x98 },
	0xA6F8,	{ 0xEE, 0x9E, 0x99 },
	0xA6F9,	{ 0xEE, 0x9E, 0x9A },
	0xA6FA,	{ 0xEE, 0x9E, 0x9B },
	0xA6FB,	{ 0xEE, 0x9E, 0x9C },
	0xA6FC,	{ 0xEE, 0x9E, 0x9D },
	0xA6FD,	{ 0xEE, 0x9E, 0x9E },
	0xA6FE,	{ 0xEE, 0x9E, 0x9F },
	0xA740,	{ 0xEE, 0x9C, 0x86 },
	0xA741,	{ 0xEE, 0x9C, 0x87 },
	0xA742,	{ 0xEE, 0x9C, 0x88 },
	0xA743,	{ 0xEE, 0x9C, 0x89 },
	0xA744,	{ 0xEE, 0x9C, 0x8A },
	0xA745,	{ 0xEE, 0x9C, 0x8B },
	0xA746,	{ 0xEE, 0x9C, 0x8C },
	0xA747,	{ 0xEE, 0x9C, 0x8D },
	0xA748,	{ 0xEE, 0x9C, 0x8E },
	0xA749,	{ 0xEE, 0x9C, 0x8F },
	0xA74A,	{ 0xEE, 0x9C, 0x90 },
	0xA74B,	{ 0xEE, 0x9C, 0x91 },
	0xA74C,	{ 0xEE, 0x9C, 0x92 },
	0xA74D,	{ 0xEE, 0x9C, 0x93 },
	0xA74E,	{ 0xEE, 0x9C, 0x94 },
	0xA74F,	{ 0xEE, 0x9C, 0x95 },
	0xA750,	{ 0xEE, 0x9C, 0x96 },
	0xA751,	{ 0xEE, 0x9C, 0x97 },
	0xA752,	{ 0xEE, 0x9C, 0x98 },
	0xA753,	{ 0xEE, 0x9C, 0x99 },
	0xA754,	{ 0xEE, 0x9C, 0x9A },
	0xA755,	{ 0xEE, 0x9C, 0x9B },
	0xA756,	{ 0xEE, 0x9C, 0x9C },
	0xA757,	{ 0xEE, 0x9C, 0x9D },
	0xA758,	{ 0xEE, 0x9C, 0x9E },
	0xA759,	{ 0xEE, 0x9C, 0x9F },
	0xA75A,	{ 0xEE, 0x9C, 0xA0 },
	0xA75B,	{ 0xEE, 0x9C, 0xA1 },
	0xA75C,	{ 0xEE, 0x9C, 0xA2 },
	0xA75D,	{ 0xEE, 0x9C, 0xA3 },
	0xA75E,	{ 0xEE, 0x9C, 0xA4 },
	0xA75F,	{ 0xEE, 0x9C, 0xA5 },
	0xA760,	{ 0xEE, 0x9C, 0xA6 },
	0xA761,	{ 0xEE, 0x9C, 0xA7 },
	0xA762,	{ 0xEE, 0x9C, 0xA8 },
	0xA763,	{ 0xEE, 0x9C, 0xA9 },
	0xA764,	{ 0xEE, 0x9C, 0xAA },
	0xA765,	{ 0xEE, 0x9C, 0xAB },
	0xA766,	{ 0xEE, 0x9C, 0xAC },
	0xA767,	{ 0xEE, 0x9C, 0xAD },
	0xA768,	{ 0xEE, 0x9C, 0xAE },
	0xA769,	{ 0xEE, 0x9C, 0xAF },
	0xA76A,	{ 0xEE, 0x9C, 0xB0 },
	0xA76B,	{ 0xEE, 0x9C, 0xB1 },
	0xA76C,	{ 0xEE, 0x9C, 0xB2 },
	0xA76D,	{ 0xEE, 0x9C, 0xB3 },
	0xA76E,	{ 0xEE, 0x9C, 0xB4 },
	0xA76F,	{ 0xEE, 0x9C, 0xB5 },
	0xA770,	{ 0xEE, 0x9C, 0xB6 },
	0xA771,	{ 0xEE, 0x9C, 0xB7 },
	0xA772,	{ 0xEE, 0x9C, 0xB8 },
	0xA773,	{ 0xEE, 0x9C, 0xB9 },
	0xA774,	{ 0xEE, 0x9C, 0xBA },
	0xA775,	{ 0xEE, 0x9C, 0xBB },
	0xA776,	{ 0xEE, 0x9C, 0xBC },
	0xA777,	{ 0xEE, 0x9C, 0xBD },
	0xA778,	{ 0xEE, 0x9C, 0xBE },
	0xA779,	{ 0xEE, 0x9C, 0xBF },
	0xA77A,	{ 0xEE, 0x9D, 0x80 },
	0xA77B,	{ 0xEE, 0x9D, 0x81 },
	0xA77C,	{ 0xEE, 0x9D, 0x82 },
	0xA77D,	{ 0xEE, 0x9D, 0x83 },
	0xA77E,	{ 0xEE, 0x9D, 0x84 },
	0xA780,	{ 0xEE, 0x9D, 0x85 },
	0xA781,	{ 0xEE, 0x9D, 0x86 },
	0xA782,	{ 0xEE, 0x9D, 0x87 },
	0xA783,	{ 0xEE, 0x9D, 0x88 },
	0xA784,	{ 0xEE, 0x9D, 0x89 },
	0xA785,	{ 0xEE, 0x9D, 0x8A },
	0xA786,	{ 0xEE, 0x9D, 0x8B },
	0xA787,	{ 0xEE, 0x9D, 0x8C },
	0xA788,	{ 0xEE, 0x9D, 0x8D },
	0xA789,	{ 0xEE, 0x9D, 0x8E },
	0xA78A,	{ 0xEE, 0x9D, 0x8F },
	0xA78B,	{ 0xEE, 0x9D, 0x90 },
	0xA78C,	{ 0xEE, 0x9D, 0x91 },
	0xA78D,	{ 0xEE, 0x9D, 0x92 },
	0xA78E,	{ 0xEE, 0x9D, 0x93 },
	0xA78F,	{ 0xEE, 0x9D, 0x94 },
	0xA790,	{ 0xEE, 0x9D, 0x95 },
	0xA791,	{ 0xEE, 0x9D, 0x96 },
	0xA792,	{ 0xEE, 0x9D, 0x97 },
	0xA793,	{ 0xEE, 0x9D, 0x98 },
	0xA794,	{ 0xEE, 0x9D, 0x99 },
	0xA795,	{ 0xEE, 0x9D, 0x9A },
	0xA796,	{ 0xEE, 0x9D, 0x9B },
	0xA797,	{ 0xEE, 0x9D, 0x9C },
	0xA798,	{ 0xEE, 0x9D, 0x9D },
	0xA799,	{ 0xEE, 0x9D, 0x9E },
	0xA79A,	{ 0xEE, 0x9D, 0x9F },
	0xA79B,	{ 0xEE, 0x9D, 0xA0 },
	0xA79C,	{ 0xEE, 0x9D, 0xA1 },
	0xA79D,	{ 0xEE, 0x9D, 0xA2 },
	0xA79E,	{ 0xEE, 0x9D, 0xA3 },
	0xA79F,	{ 0xEE, 0x9D, 0xA4 },
	0xA7A0,	{ 0xEE, 0x9D, 0xA5 },
	0xA7A1,	{ 0xD0, 0x90 },
	0xA7A2,	{ 0xD0, 0x91 },
	0xA7A3,	{ 0xD0, 0x92 },
	0xA7A4,	{ 0xD0, 0x93 },
	0xA7A5,	{ 0xD0, 0x94 },
	0xA7A6,	{ 0xD0, 0x95 },
	0xA7A7,	{ 0xD0, 0x81 },
	0xA7A8,	{ 0xD0, 0x96 },
	0xA7A9,	{ 0xD0, 0x97 },
	0xA7AA,	{ 0xD0, 0x98 },
	0xA7AB,	{ 0xD0, 0x99 },
	0xA7AC,	{ 0xD0, 0x9A },
	0xA7AD,	{ 0xD0, 0x9B },
	0xA7AE,	{ 0xD0, 0x9C },
	0xA7AF,	{ 0xD0, 0x9D },
	0xA7B0,	{ 0xD0, 0x9E },
	0xA7B1,	{ 0xD0, 0x9F },
	0xA7B2,	{ 0xD0, 0xA0 },
	0xA7B3,	{ 0xD0, 0xA1 },
	0xA7B4,	{ 0xD0, 0xA2 },
	0xA7B5,	{ 0xD0, 0xA3 },
	0xA7B6,	{ 0xD0, 0xA4 },
	0xA7B7,	{ 0xD0, 0xA5 },
	0xA7B8,	{ 0xD0, 0xA6 },
	0xA7B9,	{ 0xD0, 0xA7 },
	0xA7BA,	{ 0xD0, 0xA8 },
	0xA7BB,	{ 0xD0, 0xA9 },
	0xA7BC,	{ 0xD0, 0xAA },
	0xA7BD,	{ 0xD0, 0xAB },
	0xA7BE,	{ 0xD0, 0xAC },
	0xA7BF,	{ 0xD0, 0xAD },
	0xA7C0,	{ 0xD0, 0xAE },
	0xA7C1,	{ 0xD0, 0xAF },
	0xA7C2,	{ 0xEE, 0x9E, 0xA0 },
	0xA7C3,	{ 0xEE, 0x9E, 0xA1 },
	0xA7C4,	{ 0xEE, 0x9E, 0xA2 },
	0xA7C5,	{ 0xEE, 0x9E, 0xA3 },
	0xA7C6,	{ 0xEE, 0x9E, 0xA4 },
	0xA7C7,	{ 0xEE, 0x9E, 0xA5 },
	0xA7C8,	{ 0xEE, 0x9E, 0xA6 },
	0xA7C9,	{ 0xEE, 0x9E, 0xA7 },
	0xA7CA,	{ 0xEE, 0x9E, 0xA8 },
	0xA7CB,	{ 0xEE, 0x9E, 0xA9 },
	0xA7CC,	{ 0xEE, 0x9E, 0xAA },
	0xA7CD,	{ 0xEE, 0x9E, 0xAB },
	0xA7CE,	{ 0xEE, 0x9E, 0xAC },
	0xA7CF,	{ 0xEE, 0x9E, 0xAD },
	0xA7D0,	{ 0xEE, 0x9E, 0xAE },
	0xA7D1,	{ 0xD0, 0xB0 },
	0xA7D2,	{ 0xD0, 0xB1 },
	0xA7D3,	{ 0xD0, 0xB2 },
	0xA7D4,	{ 0xD0, 0xB3 },
	0xA7D5,	{ 0xD0, 0xB4 },
	0xA7D6,	{ 0xD0, 0xB5 },
	0xA7D7,	{ 0xD1, 0x91 },
	0xA7D8,	{ 0xD0, 0xB6 },
	0xA7D9,	{ 0xD0, 0xB7 },
	0xA7DA,	{ 0xD0, 0xB8 },
	0xA7DB,	{ 0xD0, 0xB9 },
	0xA7DC,	{ 0xD0, 0xBA },
	0xA7DD,	{ 0xD0, 0xBB },
	0xA7DE,	{ 0xD0, 0xBC },
	0xA7DF,	{ 0xD0, 0xBD },
	0xA7E0,	{ 0xD0, 0xBE },
	0xA7E1,	{ 0xD0, 0xBF },
	0xA7E2,	{ 0xD1, 0x80 },
	0xA7E3,	{ 0xD1, 0x81 },
	0xA7E4,	{ 0xD1, 0x82 },
	0xA7E5,	{ 0xD1, 0x83 },
	0xA7E6,	{ 0xD1, 0x84 },
	0xA7E7,	{ 0xD1, 0x85 },
	0xA7E8,	{ 0xD1, 0x86 },
	0xA7E9,	{ 0xD1, 0x87 },
	0xA7EA,	{ 0xD1, 0x88 },
	0xA7EB,	{ 0xD1, 0x89 },
	0xA7EC,	{ 0xD1, 0x8A },
	0xA7ED,	{ 0xD1, 0x8B },
	0xA7EE,	{ 0xD1, 0x8C },
	0xA7EF,	{ 0xD1, 0x8D },
	0xA7F0,	{ 0xD1, 0x8E },
	0xA7F1,	{ 0xD1, 0x8F },
	0xA7F2,	{ 0xEE, 0x9E, 0xAF },
	0xA7F3,	{ 0xEE, 0x9E, 0xB0 },
	0xA7F4,	{ 0xEE, 0x9E, 0xB1 },
	0xA7F5,	{ 0xEE, 0x9E, 0xB2 },
	0xA7F6,	{ 0xEE, 0x9E, 0xB3 },
	0xA7F7,	{ 0xEE, 0x9E, 0xB4 },
	0xA7F8,	{ 0xEE, 0x9E, 0xB5 },
	0xA7F9,	{ 0xEE, 0x9E, 0xB6 },
	0xA7FA,	{ 0xEE, 0x9E, 0xB7 },
	0xA7FB,	{ 0xEE, 0x9E, 0xB8 },
	0xA7FC,	{ 0xEE, 0x9E, 0xB9 },
	0xA7FD,	{ 0xEE, 0x9E, 0xBA },
	0xA7FE,	{ 0xEE, 0x9E, 0xBB },
	0xA840,	{ 0xCB, 0x8A },
	0xA841,	{ 0xCB, 0x8B },
	0xA842,	{ 0xCB, 0x99 },
	0xA843,	{ 0xE2, 0x80, 0x93 },
	0xA844,	{ 0xE2, 0x80, 0x95 },
	0xA845,	{ 0xE2, 0x80, 0xA5 },
	0xA846,	{ 0xE2, 0x80, 0xB5 },
	0xA847,	{ 0xE2, 0x84, 0x85 },
	0xA848,	{ 0xE2, 0x84, 0x89 },
	0xA849,	{ 0xE2, 0x86, 0x96 },
	0xA84A,	{ 0xE2, 0x86, 0x97 },
	0xA84B,	{ 0xE2, 0x86, 0x98 },
	0xA84C,	{ 0xE2, 0x86, 0x99 },
	0xA84D,	{ 0xE2, 0x88, 0x95 },
	0xA84E,	{ 0xE2, 0x88, 0x9F },
	0xA84F,	{ 0xE2, 0x88, 0xA3 },
	0xA850,	{ 0xE2, 0x89, 0x92 },
	0xA851,	{ 0xE2, 0x89, 0xA6 },
	0xA852,	{ 0xE2, 0x89, 0xA7 },
	0xA853,	{ 0xE2, 0x8A, 0xBF },
	0xA854,	{ 0xE2, 0x95, 0x90 },
	0xA855,	{ 0xE2, 0x95, 0x91 },
	0xA856,	{ 0xE2, 0x95, 0x92 },
	0xA857,	{ 0xE2, 0x95, 0x93 },
	0xA858,	{ 0xE2, 0x95, 0x94 },
	0xA859,	{ 0xE2, 0x95, 0x95 },
	0xA85A,	{ 0xE2, 0x95, 0x96 },
	0xA85B,	{ 0xE2, 0x95, 0x97 },
	0xA85C,	{ 0xE2, 0x95, 0x98 },
	0xA85D,	{ 0xE2, 0x95, 0x99 },
	0xA85E,	{ 0xE2, 0x95, 0x9A },
	0xA85F,	{ 0xE2, 0x95, 0x9B },
	0xA860,	{ 0xE2, 0x95, 0x9C },
	0xA861,	{ 0xE2, 0x95, 0x9D },
	0xA862,	{ 0xE2, 0x95, 0x9E },
	0xA863,	{ 0xE2, 0x95, 0x9F },
	0xA864,	{ 0xE2, 0x95, 0xA0 },
	0xA865,	{ 0xE2, 0x95, 0xA1 },
	0xA866,	{ 0xE2, 0x95, 0xA2 },
	0xA867,	{ 0xE2, 0x95, 0xA3 },
	0xA868,	{ 0xE2, 0x95, 0xA4 },
	0xA869,	{ 0xE2, 0x95, 0xA5 },
	0xA86A,	{ 0xE2, 0x95, 0xA6 },
	0xA86B,	{ 0xE2, 0x95, 0xA7 },
	0xA86C,	{ 0xE2, 0x95, 0xA8 },
	0xA86D,	{ 0xE2, 0x95, 0xA9 },
	0xA86E,	{ 0xE2, 0x95, 0xAA },
	0xA86F,	{ 0xE2, 0x95, 0xAB },
	0xA870,	{ 0xE2, 0x95, 0xAC },
	0xA871,	{ 0xE2, 0x95, 0xAD },
	0xA872,	{ 0xE2, 0x95, 0xAE },
	0xA873,	{ 0xE2, 0x95, 0xAF },
	0xA874,	{ 0xE2, 0x95, 0xB0 },
	0xA875,	{ 0xE2, 0x95, 0xB1 },
	0xA876,	{ 0xE2, 0x95, 0xB2 },
	0xA877,	{ 0xE2, 0x95, 0xB3 },
	0xA878,	{ 0xE2, 0x96, 0x81 },
	0xA879,	{ 0xE2, 0x96, 0x82 },
	0xA87A,	{ 0xE2, 0x96, 0x83 },
	0xA87B,	{ 0xE2, 0x96, 0x84 },
	0xA87C,	{ 0xE2, 0x96, 0x85 },
	0xA87D,	{ 0xE2, 0x96, 0x86 },
	0xA87E,	{ 0xE2, 0x96, 0x87 },
	0xA880,	{ 0xE2, 0x96, 0x88 },
	0xA881,	{ 0xE2, 0x96, 0x89 },
	0xA882,	{ 0xE2, 0x96, 0x8A },
	0xA883,	{ 0xE2, 0x96, 0x8B },
	0xA884,	{ 0xE2, 0x96, 0x8C },
	0xA885,	{ 0xE2, 0x96, 0x8D },
	0xA886,	{ 0xE2, 0x96, 0x8E },
	0xA887,	{ 0xE2, 0x96, 0x8F },
	0xA888,	{ 0xE2, 0x96, 0x93 },
	0xA889,	{ 0xE2, 0x96, 0x94 },
	0xA88A,	{ 0xE2, 0x96, 0x95 },
	0xA88B,	{ 0xE2, 0x96, 0xBC },
	0xA88C,	{ 0xE2, 0x96, 0xBD },
	0xA88D,	{ 0xE2, 0x97, 0xA2 },
	0xA88E,	{ 0xE2, 0x97, 0xA3 },
	0xA88F,	{ 0xE2, 0x97, 0xA4 },
	0xA890,	{ 0xE2, 0x97, 0xA5 },
	0xA891,	{ 0xE2, 0x98, 0x89 },
	0xA892,	{ 0xE2, 0x8A, 0x95 },
	0xA893,	{ 0xE3, 0x80, 0x92 },
	0xA894,	{ 0xE3, 0x80, 0x9D },
	0xA895,	{ 0xE3, 0x80, 0x9E },
	0xA896,	{ 0xEE, 0x9E, 0xBC },
	0xA897,	{ 0xEE, 0x9E, 0xBD },
	0xA898,	{ 0xEE, 0x9E, 0xBE },
	0xA899,	{ 0xEE, 0x9E, 0xBF },
	0xA89A,	{ 0xEE, 0x9F, 0x80 },
	0xA89B,	{ 0xEE, 0x9F, 0x81 },
	0xA89C,	{ 0xEE, 0x9F, 0x82 },
	0xA89D,	{ 0xEE, 0x9F, 0x83 },
	0xA89E,	{ 0xEE, 0x9F, 0x84 },
	0xA89F,	{ 0xEE, 0x9F, 0x85 },
	0xA8A0,	{ 0xEE, 0x9F, 0x86 },
	0xA8A1,	{ 0xC4, 0x81 },
	0xA8A2,	{ 0xC3, 0xA1 },
	0xA8A3,	{ 0xC7, 0x8E },
	0xA8A4,	{ 0xC3, 0xA0 },
	0xA8A5,	{ 0xC4, 0x93 },
	0xA8A6,	{ 0xC3, 0xA9 },
	0xA8A7,	{ 0xC4, 0x9B },
	0xA8A8,	{ 0xC3, 0xA8 },
	0xA8A9,	{ 0xC4, 0xAB },
	0xA8AA,	{ 0xC3, 0xAD },
	0xA8AB,	{ 0xC7, 0x90 },
	0xA8AC,	{ 0xC3, 0xAC },
	0xA8AD,	{ 0xC5, 0x8D },
	0xA8AE,	{ 0xC3, 0xB3 },
	0xA8AF,	{ 0xC7, 0x92 },
	0xA8B0,	{ 0xC3, 0xB2 },
	0xA8B1,	{ 0xC5, 0xAB },
	0xA8B2,	{ 0xC3, 0xBA },
	0xA8B3,	{ 0xC7, 0x94 },
	0xA8B4,	{ 0xC3, 0xB9 },
	0xA8B5,	{ 0xC7, 0x96 },
	0xA8B6,	{ 0xC7, 0x98 },
	0xA8B7,	{ 0xC7, 0x9A },
	0xA8B8,	{ 0xC7, 0x9C },
	0xA8B9,	{ 0xC3, 0xBC },
	0xA8BA,	{ 0xC3, 0xAA },
	0xA8BB,	{ 0xC9, 0x91 },
	0xA8BC,	{ 0xEE, 0x9F, 0x87 },
	0xA8BD,	{ 0xC5, 0x84 },
	0xA8BE,	{ 0xC5, 0x88 },
	0xA8BF,	{ 0xC7, 0xB9 },
	0xA8C0,	{ 0xC9, 0xA1 },
	0xA8C1,	{ 0xEE, 0x9F, 0x89 },
	0xA8C2,	{ 0xEE, 0x9F, 0x8A },
	0xA8C3,	{ 0xEE, 0x9F, 0x8B },
	0xA8C4,	{ 0xEE, 0x9F, 0x8C },
	0xA8C5,	{ 0xE3, 0x84, 0x85 },
	0xA8C6,	{ 0xE3, 0x84, 0x86 },
	0xA8C7,	{ 0xE3, 0x84, 0x87 },
	0xA8C8,	{ 0xE3, 0x84, 0x88 },
	0xA8C9,	{ 0xE3, 0x84, 0x89 },
	0xA8CA,	{ 0xE3, 0x84, 0x8A },
	0xA8CB,	{ 0xE3, 0x84, 0x8B },
	0xA8CC,	{ 0xE3, 0x84, 0x8C },
	0xA8CD,	{ 0xE3, 0x84, 0x8D },
	0xA8CE,	{ 0xE3, 0x84, 0x8E },
	0xA8CF,	{ 0xE3, 0x84, 0x8F },
	0xA8D0,	{ 0xE3, 0x84, 0x90 },
	0xA8D1,	{ 0xE3, 0x84, 0x91 },
	0xA8D2,	{ 0xE3, 0x84, 0x92 },
	0xA8D3,	{ 0xE3, 0x84, 0x93 },
	0xA8D4,	{ 0xE3, 0x84, 0x94 },
	0xA8D5,	{ 0xE3, 0x84, 0x95 },
	0xA8D6,	{ 0xE3, 0x84, 0x96 },
	0xA8D7,	{ 0xE3, 0x84, 0x97 },
	0xA8D8,	{ 0xE3, 0x84, 0x98 },
	0xA8D9,	{ 0xE3, 0x84, 0x99 },
	0xA8DA,	{ 0xE3, 0x84, 0x9A },
	0xA8DB,	{ 0xE3, 0x84, 0x9B },
	0xA8DC,	{ 0xE3, 0x84, 0x9C },
	0xA8DD,	{ 0xE3, 0x84, 0x9D },
	0xA8DE,	{ 0xE3, 0x84, 0x9E },
	0xA8DF,	{ 0xE3, 0x84, 0x9F },
	0xA8E0,	{ 0xE3, 0x84, 0xA0 },
	0xA8E1,	{ 0xE3, 0x84, 0xA1 },
	0xA8E2,	{ 0xE3, 0x84, 0xA2 },
	0xA8E3,	{ 0xE3, 0x84, 0xA3 },
	0xA8E4,	{ 0xE3, 0x84, 0xA4 },
	0xA8E5,	{ 0xE3, 0x84, 0xA5 },
	0xA8E6,	{ 0xE3, 0x84, 0xA6 },
	0xA8E7,	{ 0xE3, 0x84, 0xA7 },
	0xA8E8,	{ 0xE3, 0x84, 0xA8 },
	0xA8E9,	{ 0xE3, 0x84, 0xA9 },
	0xA8EA,	{ 0xEE, 0x9F, 0x8D },
	0xA8EB,	{ 0xEE, 0x9F, 0x8E },
	0xA8EC,	{ 0xEE, 0x9F, 0x8F },
	0xA8ED,	{ 0xEE, 0x9F, 0x90 },
	0xA8EE,	{ 0xEE, 0x9F, 0x91 },
	0xA8EF,	{ 0xEE, 0x9F, 0x92 },
	0xA8F0,	{ 0xEE, 0x9F, 0x93 },
	0xA8F1,	{ 0xEE, 0x9F, 0x94 },
	0xA8F2,	{ 0xEE, 0x9F, 0x95 },
	0xA8F3,	{ 0xEE, 0x9F, 0x96 },
	0xA8F4,	{ 0xEE, 0x9F, 0x97 },
	0xA8F5,	{ 0xEE, 0x9F, 0x98 },
	0xA8F6,	{ 0xEE, 0x9F, 0x99 },
	0xA8F7,	{ 0xEE, 0x9F, 0x9A },
	0xA8F8,	{ 0xEE, 0x9F, 0x9B },
	0xA8F9,	{ 0xEE, 0x9F, 0x9C },
	0xA8FA,	{ 0xEE, 0x9F, 0x9D },
	0xA8FB,	{ 0xEE, 0x9F, 0x9E },
	0xA8FC,	{ 0xEE, 0x9F, 0x9F },
	0xA8FD,	{ 0xEE, 0x9F, 0xA0 },
	0xA8FE,	{ 0xEE, 0x9F, 0xA1 },
	0xA940,	{ 0xE3, 0x80, 0xA1 },
	0xA941,	{ 0xE3, 0x80, 0xA2 },
	0xA942,	{ 0xE3, 0x80, 0xA3 },
	0xA943,	{ 0xE3, 0x80, 0xA4 },
	0xA944,	{ 0xE3, 0x80, 0xA5 },
	0xA945,	{ 0xE3, 0x80, 0xA6 },
	0xA946,	{ 0xE3, 0x80, 0xA7 },
	0xA947,	{ 0xE3, 0x80, 0xA8 },
	0xA948,	{ 0xE3, 0x80, 0xA9 },
	0xA949,	{ 0xE3, 0x8A, 0xA3 },
	0xA94A,	{ 0xE3, 0x8E, 0x8E },
	0xA94B,	{ 0xE3, 0x8E, 0x8F },
	0xA94C,	{ 0xE3, 0x8E, 0x9C },
	0xA94D,	{ 0xE3, 0x8E, 0x9D },
	0xA94E,	{ 0xE3, 0x8E, 0x9E },
	0xA94F,	{ 0xE3, 0x8E, 0xA1 },
	0xA950,	{ 0xE3, 0x8F, 0x84 },
	0xA951,	{ 0xE3, 0x8F, 0x8E },
	0xA952,	{ 0xE3, 0x8F, 0x91 },
	0xA953,	{ 0xE3, 0x8F, 0x92 },
	0xA954,	{ 0xE3, 0x8F, 0x95 },
	0xA955,	{ 0xEF, 0xB8, 0xB0 },
	0xA956,	{ 0xEF, 0xBF, 0xA2 },
	0xA957,	{ 0xEF, 0xBF, 0xA4 },
	0xA958,	{ 0xEE, 0x9F, 0xA2 },
	0xA959,	{ 0xE2, 0x84, 0xA1 },
	0xA95A,	{ 0xE3, 0x88, 0xB1 },
	0xA95B,	{ 0xEE, 0x9F, 0xA3 },
	0xA95C,	{ 0xE2, 0x80, 0x90 },
	0xA95D,	{ 0xEE, 0x9F, 0xA4 },
	0xA95E,	{ 0xEE, 0x9F, 0xA5 },
	0xA95F,	{ 0xEE, 0x9F, 0xA6 },
	0xA960,	{ 0xE3, 0x83, 0xBC },
	0xA961,	{ 0xE3, 0x82, 0x9B },
	0xA962,	{ 0xE3, 0x82, 0x9C },
	0xA963,	{ 0xE3, 0x83, 0xBD },
	0xA964,	{ 0xE3, 0x83, 0xBE },
	0xA965,	{ 0xE3, 0x80, 0x86 },
	0xA966,	{ 0xE3, 0x82, 0x9D },
	0xA967,	{ 0xE3, 0x82, 0x9E },
	0xA968,	{ 0xEF, 0xB9, 0x89 },
	0xA969,	{ 0xEF, 0xB9, 0x8A },
	0xA96A,	{ 0xEF, 0xB9, 0x8B },
	0xA96B,	{ 0xEF, 0xB9, 0x8C },
	0xA96C,	{ 0xEF, 0xB9, 0x8D },
	0xA96D,	{ 0xEF, 0xB9, 0x8E },
	0xA96E,	{ 0xEF, 0xB9, 0x8F },
	0xA96F,	{ 0xEF, 0xB9, 0x90 },
	0xA970,	{ 0xEF, 0xB9, 0x91 },
	0xA971,	{ 0xEF, 0xB9, 0x92 },
	0xA972,	{ 0xEF, 0xB9, 0x94 },
	0xA973,	{ 0xEF, 0xB9, 0x95 },
	0xA974,	{ 0xEF, 0xB9, 0x96 },
	0xA975,	{ 0xEF, 0xB9, 0x97 },
	0xA976,	{ 0xEF, 0xB9, 0x99 },
	0xA977,	{ 0xEF, 0xB9, 0x9A },
	0xA978,	{ 0xEF, 0xB9, 0x9B },
	0xA979,	{ 0xEF, 0xB9, 0x9C },
	0xA97A,	{ 0xEF, 0xB9, 0x9D },
	0xA97B,	{ 0xEF, 0xB9, 0x9E },
	0xA97C,	{ 0xEF, 0xB9, 0x9F },
	0xA97D,	{ 0xEF, 0xB9, 0xA0 },
	0xA97E,	{ 0xEF, 0xB9, 0xA1 },
	0xA980,	{ 0xEF, 0xB9, 0xA2 },
	0xA981,	{ 0xEF, 0xB9, 0xA3 },
	0xA982,	{ 0xEF, 0xB9, 0xA4 },
	0xA983,	{ 0xEF, 0xB9, 0xA5 },
	0xA984,	{ 0xEF, 0xB9, 0xA6 },
	0xA985,	{ 0xEF, 0xB9, 0xA8 },
	0xA986,	{ 0xEF, 0xB9, 0xA9 },
	0xA987,	{ 0xEF, 0xB9, 0xAA },
	0xA988,	{ 0xEF, 0xB9, 0xAB },
	0xA989,	{ 0xE3, 0x80, 0xBE },
	0xA98A,	{ 0xE2, 0xBF, 0xB0 },
	0xA98B,	{ 0xE2, 0xBF, 0xB1 },
	0xA98C,	{ 0xE2, 0xBF, 0xB2 },
	0xA98D,	{ 0xE2, 0xBF, 0xB3 },
	0xA98E,	{ 0xE2, 0xBF, 0xB4 },
	0xA98F,	{ 0xE2, 0xBF, 0xB5 },
	0xA990,	{ 0xE2, 0xBF, 0xB6 },
	0xA991,	{ 0xE2, 0xBF, 0xB7 },
	0xA992,	{ 0xE2, 0xBF, 0xB8 },
	0xA993,	{ 0xE2, 0xBF, 0xB9 },
	0xA994,	{ 0xE2, 0xBF, 0xBA },
	0xA995,	{ 0xE2, 0xBF, 0xBB },
	0xA996,	{ 0xE3, 0x80, 0x87 },
	0xA997,	{ 0xEE, 0x9F, 0xB4 },
	0xA998,	{ 0xEE, 0x9F, 0xB5 },
	0xA999,	{ 0xEE, 0x9F, 0xB6 },
	0xA99A,	{ 0xEE, 0x9F, 0xB7 },
	0xA99B,	{ 0xEE, 0x9F, 0xB8 },
	0xA99C,	{ 0xEE, 0x9F, 0xB9 },
	0xA99D,	{ 0xEE, 0x9F, 0xBA },
	0xA99E,	{ 0xEE, 0x9F, 0xBB },
	0xA99F,	{ 0xEE, 0x9F, 0xBC },
	0xA9A0,	{ 0xEE, 0x9F, 0xBD },
	0xA9A1,	{ 0xEE, 0x9F, 0xBE },
	0xA9A2,	{ 0xEE, 0x9F, 0xBF },
	0xA9A3,	{ 0xEE, 0xA0, 0x80 },
	0xA9A4,	{ 0xE2, 0x94, 0x80 },
	0xA9A5,	{ 0xE2, 0x94, 0x81 },
	0xA9A6,	{ 0xE2, 0x94, 0x82 },
	0xA9A7,	{ 0xE2, 0x94, 0x83 },
	0xA9A8,	{ 0xE2, 0x94, 0x84 },
	0xA9A9,	{ 0xE2, 0x94, 0x85 },
	0xA9AA,	{ 0xE2, 0x94, 0x86 },
	0xA9AB,	{ 0xE2, 0x94, 0x87 },
	0xA9AC,	{ 0xE2, 0x94, 0x88 },
	0xA9AD,	{ 0xE2, 0x94, 0x89 },
	0xA9AE,	{ 0xE2, 0x94, 0x8A },
	0xA9AF,	{ 0xE2, 0x94, 0x8B },
	0xA9B0,	{ 0xE2, 0x94, 0x8C },
	0xA9B1,	{ 0xE2, 0x94, 0x8D },
	0xA9B2,	{ 0xE2, 0x94, 0x8E },
	0xA9B3,	{ 0xE2, 0x94, 0x8F },
	0xA9B4,	{ 0xE2, 0x94, 0x90 },
	0xA9B5,	{ 0xE2, 0x94, 0x91 },
	0xA9B6,	{ 0xE2, 0x94, 0x92 },
	0xA9B7,	{ 0xE2, 0x94, 0x93 },
	0xA9B8,	{ 0xE2, 0x94, 0x94 },
	0xA9B9,	{ 0xE2, 0x94, 0x95 },
	0xA9BA,	{ 0xE2, 0x94, 0x96 },
	0xA9BB,	{ 0xE2, 0x94, 0x97 },
	0xA9BC,	{ 0xE2, 0x94, 0x98 },
	0xA9BD,	{ 0xE2, 0x94, 0x99 },
	0xA9BE,	{ 0xE2, 0x94, 0x9A },
	0xA9BF,	{ 0xE2, 0x94, 0x9B },
	0xA9C0,	{ 0xE2, 0x94, 0x9C },
	0xA9C1,	{ 0xE2, 0x94, 0x9D },
	0xA9C2,	{ 0xE2, 0x94, 0x9E },
	0xA9C3,	{ 0xE2, 0x94, 0x9F },
	0xA9C4,	{ 0xE2, 0x94, 0xA0 },
	0xA9C5,	{ 0xE2, 0x94, 0xA1 },
	0xA9C6,	{ 0xE2, 0x94, 0xA2 },
	0xA9C7,	{ 0xE2, 0x94, 0xA3 },
	0xA9C8,	{ 0xE2, 0x94, 0xA4 },
	0xA9C9,	{ 0xE2, 0x94, 0xA5 },
	0xA9CA,	{ 0xE2, 0x94, 0xA6 },
	0xA9CB,	{ 0xE2, 0x94, 0xA7 },
	0xA9CC,	{ 0xE2, 0x94, 0xA8 },
	0xA9CD,	{ 0xE2, 0x94, 0xA9 },
	0xA9CE,	{ 0xE2, 0x94, 0xAA },
	0xA9CF,	{ 0xE2, 0x94, 0xAB },
	0xA9D0,	{ 0xE2, 0x94, 0xAC },
	0xA9D1,	{ 0xE2, 0x94, 0xAD },
	0xA9D2,	{ 0xE2, 0x94, 0xAE },
	0xA9D3,	{ 0xE2, 0x94, 0xAF },
	0xA9D4,	{ 0xE2, 0x94, 0xB0 },
	0xA9D5,	{ 0xE2, 0x94, 0xB1 },
	0xA9D6,	{ 0xE2, 0x94, 0xB2 },
	0xA9D7,	{ 0xE2, 0x94, 0xB3 },
	0xA9D8,	{ 0xE2, 0x94, 0xB4 },
	0xA9D9,	{ 0xE2, 0x94, 0xB5 },
	0xA9DA,	{ 0xE2, 0x94, 0xB6 },
	0xA9DB,	{ 0xE2, 0x94, 0xB7 },
	0xA9DC,	{ 0xE2, 0x94, 0xB8 },
	0xA9DD,	{ 0xE2, 0x94, 0xB9 },
	0xA9DE,	{ 0xE2, 0x94, 0xBA },
	0xA9DF,	{ 0xE2, 0x94, 0xBB },
	0xA9E0,	{ 0xE2, 0x94, 0xBC },
	0xA9E1,	{ 0xE2, 0x94, 0xBD },
	0xA9E2,	{ 0xE2, 0x94, 0xBE },
	0xA9E3,	{ 0xE2, 0x94, 0xBF },
	0xA9E4,	{ 0xE2, 0x95, 0x80 },
	0xA9E5,	{ 0xE2, 0x95, 0x81 },
	0xA9E6,	{ 0xE2, 0x95, 0x82 },
	0xA9E7,	{ 0xE2, 0x95, 0x83 },
	0xA9E8,	{ 0xE2, 0x95, 0x84 },
	0xA9E9,	{ 0xE2, 0x95, 0x85 },
	0xA9EA,	{ 0xE2, 0x95, 0x86 },
	0xA9EB,	{ 0xE2, 0x95, 0x87 },
	0xA9EC,	{ 0xE2, 0x95, 0x88 },
	0xA9ED,	{ 0xE2, 0x95, 0x89 },
	0xA9EE,	{ 0xE2, 0x95, 0x8A },
	0xA9EF,	{ 0xE2, 0x95, 0x8B },
	0xA9F0,	{ 0xEE, 0xA0, 0x81 },
	0xA9F1,	{ 0xEE, 0xA0, 0x82 },
	0xA9F2,	{ 0xEE, 0xA0, 0x83 },
	0xA9F3,	{ 0xEE, 0xA0, 0x84 },
	0xA9F4,	{ 0xEE, 0xA0, 0x85 },
	0xA9F5,	{ 0xEE, 0xA0, 0x86 },
	0xA9F6,	{ 0xEE, 0xA0, 0x87 },
	0xA9F7,	{ 0xEE, 0xA0, 0x88 },
	0xA9F8,	{ 0xEE, 0xA0, 0x89 },
	0xA9F9,	{ 0xEE, 0xA0, 0x8A },
	0xA9FA,	{ 0xEE, 0xA0, 0x8B },
	0xA9FB,	{ 0xEE, 0xA0, 0x8C },
	0xA9FC,	{ 0xEE, 0xA0, 0x8D },
	0xA9FD,	{ 0xEE, 0xA0, 0x8E },
	0xA9FE,	{ 0xEE, 0xA0, 0x8F },
	0xAA40,	{ 0xE7, 0x8B, 0x9C },
	0xAA41,	{ 0xE7, 0x8B, 0x9D },
	0xAA42,	{ 0xE7, 0x8B, 0x9F },
	0xAA43,	{ 0xE7, 0x8B, 0xA2 },
	0xAA44,	{ 0xE7, 0x8B, 0xA3 },
	0xAA45,	{ 0xE7, 0x8B, 0xA4 },
	0xAA46,	{ 0xE7, 0x8B, 0xA5 },
	0xAA47,	{ 0xE7, 0x8B, 0xA6 },
	0xAA48,	{ 0xE7, 0x8B, 0xA7 },
	0xAA49,	{ 0xE7, 0x8B, 0xAA },
	0xAA4A,	{ 0xE7, 0x8B, 0xAB },
	0xAA4B,	{ 0xE7, 0x8B, 0xB5 },
	0xAA4C,	{ 0xE7, 0x8B, 0xB6 },
	0xAA4D,	{ 0xE7, 0x8B, 0xB9 },
	0xAA4E,	{ 0xE7, 0x8B, 0xBD },
	0xAA4F,	{ 0xE7, 0x8B, 0xBE },
	0xAA50,	{ 0xE7, 0x8B, 0xBF },
	0xAA51,	{ 0xE7, 0x8C, 0x80 },
	0xAA52,	{ 0xE7, 0x8C, 0x82 },
	0xAA53,	{ 0xE7, 0x8C, 0x84 },
	0xAA54,	{ 0xE7, 0x8C, 0x85 },
	0xAA55,	{ 0xE7, 0x8C, 0x86 },
	0xAA56,	{ 0xE7, 0x8C, 0x87 },
	0xAA57,	{ 0xE7, 0x8C, 0x88 },
	0xAA58,	{ 0xE7, 0x8C, 0x89 },
	0xAA59,	{ 0xE7, 0x8C, 0x8B },
	0xAA5A,	{ 0xE7, 0x8C, 0x8C },
	0xAA5B,	{ 0xE7, 0x8C, 0x8D },
	0xAA5C,	{ 0xE7, 0x8C, 0x8F },
	0xAA5D,	{ 0xE7, 0x8C, 0x90 },
	0xAA5E,	{ 0xE7, 0x8C, 0x91 },
	0xAA5F,	{ 0xE7, 0x8C, 0x92 },
	0xAA60,	{ 0xE7, 0x8C, 0x94 },
	0xAA61,	{ 0xE7, 0x8C, 0x98 },
	0xAA62,	{ 0xE7, 0x8C, 0x99 },
	0xAA63,	{ 0xE7, 0x8C, 0x9A },
	0xAA64,	{ 0xE7, 0x8C, 0x9F },
	0xAA65,	{ 0xE7, 0x8C, 0xA0 },
	0xAA66,	{ 0xE7, 0x8C, 0xA3 },
	0xAA67,	{ 0xE7, 0x8C, 0xA4 },
	0xAA68,	{ 0xE7, 0x8C, 0xA6 },
	0xAA69,	{ 0xE7, 0x8C, 0xA7 },
	0xAA6A,	{ 0xE7, 0x8C, 0xA8 },
	0xAA6B,	{ 0xE7, 0x8C, 0xAD },
	0xAA6C,	{ 0xE7, 0x8C, 0xAF },
	0xAA6D,	{ 0xE7, 0x8C, 0xB0 },
	0xAA6E,	{ 0xE7, 0x8C, 0xB2 },
	0xAA6F,	{ 0xE7, 0x8C, 0xB3 },
	0xAA70,	{ 0xE7, 0x8C, 0xB5 },
	0xAA71,	{ 0xE7, 0x8C, 0xB6 },
	0xAA72,	{ 0xE7, 0x8C, 0xBA },
	0xAA73,	{ 0xE7, 0x8C, 0xBB },
	0xAA74,	{ 0xE7, 0x8C, 0xBC },
	0xAA75,	{ 0xE7, 0x8C, 0xBD },
	0xAA76,	{ 0xE7, 0x8D, 0x80 },
	0xAA77,	{ 0xE7, 0x8D, 0x81 },
	0xAA78,	{ 0xE7, 0x8D, 0x82 },
	0xAA79,	{ 0xE7, 0x8D, 0x83 },
	0xAA7A,	{ 0xE7, 0x8D, 0x84 },
	0xAA7B,	{ 0xE7, 0x8D, 0x85 },
	0xAA7C,	{ 0xE7, 0x8D, 0x86 },
	0xAA7D,	{ 0xE7, 0x8D, 0x87 },
	0xAA7E,	{ 0xE7, 0x8D, 0x88 },
	0xAA80,	{ 0xE7, 0x8D, 0x89 },
	0xAA81,	{ 0xE7, 0x8D, 0x8A },
	0xAA82,	{ 0xE7, 0x8D, 0x8B },
	0xAA83,	{ 0xE7, 0x8D, 0x8C },
	0xAA84,	{ 0xE7, 0x8D, 0x8E },
	0xAA85,	{ 0xE7, 0x8D, 0x8F },
	0xAA86,	{ 0xE7, 0x8D, 0x91 },
	0xAA87,	{ 0xE7, 0x8D, 0x93 },
	0xAA88,	{ 0xE7, 0x8D, 0x94 },
	0xAA89,	{ 0xE7, 0x8D, 0x95 },
	0xAA8A,	{ 0xE7, 0x8D, 0x96 },
	0xAA8B,	{ 0xE7, 0x8D, 0x98 },
	0xAA8C,	{ 0xE7, 0x8D, 0x99 },
	0xAA8D,	{ 0xE7, 0x8D, 0x9A },
	0xAA8E,	{ 0xE7, 0x8D, 0x9B },
	0xAA8F,	{ 0xE7, 0x8D, 0x9C },
	0xAA90,	{ 0xE7, 0x8D, 0x9D },
	0xAA91,	{ 0xE7, 0x8D, 0x9E },
	0xAA92,	{ 0xE7, 0x8D, 0x9F },
	0xAA93,	{ 0xE7, 0x8D, 0xA1 },
	0xAA94,	{ 0xE7, 0x8D, 0xA2 },
	0xAA95,	{ 0xE7, 0x8D, 0xA3 },
	0xAA96,	{ 0xE7, 0x8D, 0xA4 },
	0xAA97,	{ 0xE7, 0x8D, 0xA5 },
	0xAA98,	{ 0xE7, 0x8D, 0xA6 },
	0xAA99,	{ 0xE7, 0x8D, 0xA7 },
	0xAA9A,	{ 0xE7, 0x8D, 0xA8 },
	0xAA9B,	{ 0xE7, 0x8D, 0xA9 },
	0xAA9C,	{ 0xE7, 0x8D, 0xAA },
	0xAA9D,	{ 0xE7, 0x8D, 0xAB },
	0xAA9E,	{ 0xE7, 0x8D, 0xAE },
	0xAA9F,	{ 0xE7, 0x8D, 0xB0 },
	0xAAA0,	{ 0xE7, 0x8D, 0xB1 },
	0xAAA1,	{ 0xEE, 0x80, 0x80 },
	0xAAA2,	{ 0xEE, 0x80, 0x81 },
	0xAAA3,	{ 0xEE, 0x80, 0x82 },
	0xAAA4,	{ 0xEE, 0x80, 0x83 },
	0xAAA5,	{ 0xEE, 0x80, 0x84 },
	0xAAA6,	{ 0xEE, 0x80, 0x85 },
	0xAAA7,	{ 0xEE, 0x80, 0x86 },
	0xAAA8,	{ 0xEE, 0x80, 0x87 },
	0xAAA9,	{ 0xEE, 0x80, 0x88 },
	0xAAAA,	{ 0xEE, 0x80, 0x89 },
	0xAAAB,	{ 0xEE, 0x80, 0x8A },
	0xAAAC,	{ 0xEE, 0x80, 0x8B },
	0xAAAD,	{ 0xEE, 0x80, 0x8C },
	0xAAAE,	{ 0xEE, 0x80, 0x8D },
	0xAAAF,	{ 0xEE, 0x80, 0x8E },
	0xAAB0,	{ 0xEE, 0x80, 0x8F },
	0xAAB1,	{ 0xEE, 0x80, 0x90 },
	0xAAB2,	{ 0xEE, 0x80, 0x91 },
	0xAAB3,	{ 0xEE, 0x80, 0x92 },
	0xAAB4,	{ 0xEE, 0x80, 0x93 },
	0xAAB5,	{ 0xEE, 0x80, 0x94 },
	0xAAB6,	{ 0xEE, 0x80, 0x95 },
	0xAAB7,	{ 0xEE, 0x80, 0x96 },
	0xAAB8,	{ 0xEE, 0x80, 0x97 },
	0xAAB9,	{ 0xEE, 0x80, 0x98 },
	0xAABA,	{ 0xEE, 0x80, 0x99 },
	0xAABB,	{ 0xEE, 0x80, 0x9A },
	0xAABC,	{ 0xEE, 0x80, 0x9B },
	0xAABD,	{ 0xEE, 0x80, 0x9C },
	0xAABE,	{ 0xEE, 0x80, 0x9D },
	0xAABF,	{ 0xEE, 0x80, 0x9E },
	0xAAC0,	{ 0xEE, 0x80, 0x9F },
	0xAAC1,	{ 0xEE, 0x80, 0xA0 },
	0xAAC2,	{ 0xEE, 0x80, 0xA1 },
	0xAAC3,	{ 0xEE, 0x80, 0xA2 },
	0xAAC4,	{ 0xEE, 0x80, 0xA3 },
	0xAAC5,	{ 0xEE, 0x80, 0xA4 },
	0xAAC6,	{ 0xEE, 0x80, 0xA5 },
	0xAAC7,	{ 0xEE, 0x80, 0xA6 },
	0xAAC8,	{ 0xEE, 0x80, 0xA7 },
	0xAAC9,	{ 0xEE, 0x80, 0xA8 },
	0xAACA,	{ 0xEE, 0x80, 0xA9 },
	0xAACB,	{ 0xEE, 0x80, 0xAA },
	0xAACC,	{ 0xEE, 0x80, 0xAB },
	0xAACD,	{ 0xEE, 0x80, 0xAC },
	0xAACE,	{ 0xEE, 0x80, 0xAD },
	0xAACF,	{ 0xEE, 0x80, 0xAE },
	0xAAD0,	{ 0xEE, 0x80, 0xAF },
	0xAAD1,	{ 0xEE, 0x80, 0xB0 },
	0xAAD2,	{ 0xEE, 0x80, 0xB1 },
	0xAAD3,	{ 0xEE, 0x80, 0xB2 },
	0xAAD4,	{ 0xEE, 0x80, 0xB3 },
	0xAAD5,	{ 0xEE, 0x80, 0xB4 },
	0xAAD6,	{ 0xEE, 0x80, 0xB5 },
	0xAAD7,	{ 0xEE, 0x80, 0xB6 },
	0xAAD8,	{ 0xEE, 0x80, 0xB7 },
	0xAAD9,	{ 0xEE, 0x80, 0xB8 },
	0xAADA,	{ 0xEE, 0x80, 0xB9 },
	0xAADB,	{ 0xEE, 0x80, 0xBA },
	0xAADC,	{ 0xEE, 0x80, 0xBB },
	0xAADD,	{ 0xEE, 0x80, 0xBC },
	0xAADE,	{ 0xEE, 0x80, 0xBD },
	0xAADF,	{ 0xEE, 0x80, 0xBE },
	0xAAE0,	{ 0xEE, 0x80, 0xBF },
	0xAAE1,	{ 0xEE, 0x81, 0x80 },
	0xAAE2,	{ 0xEE, 0x81, 0x81 },
	0xAAE3,	{ 0xEE, 0x81, 0x82 },
	0xAAE4,	{ 0xEE, 0x81, 0x83 },
	0xAAE5,	{ 0xEE, 0x81, 0x84 },
	0xAAE6,	{ 0xEE, 0x81, 0x85 },
	0xAAE7,	{ 0xEE, 0x81, 0x86 },
	0xAAE8,	{ 0xEE, 0x81, 0x87 },
	0xAAE9,	{ 0xEE, 0x81, 0x88 },
	0xAAEA,	{ 0xEE, 0x81, 0x89 },
	0xAAEB,	{ 0xEE, 0x81, 0x8A },
	0xAAEC,	{ 0xEE, 0x81, 0x8B },
	0xAAED,	{ 0xEE, 0x81, 0x8C },
	0xAAEE,	{ 0xEE, 0x81, 0x8D },
	0xAAEF,	{ 0xEE, 0x81, 0x8E },
	0xAAF0,	{ 0xEE, 0x81, 0x8F },
	0xAAF1,	{ 0xEE, 0x81, 0x90 },
	0xAAF2,	{ 0xEE, 0x81, 0x91 },
	0xAAF3,	{ 0xEE, 0x81, 0x92 },
	0xAAF4,	{ 0xEE, 0x81, 0x93 },
	0xAAF5,	{ 0xEE, 0x81, 0x94 },
	0xAAF6,	{ 0xEE, 0x81, 0x95 },
	0xAAF7,	{ 0xEE, 0x81, 0x96 },
	0xAAF8,	{ 0xEE, 0x81, 0x97 },
	0xAAF9,	{ 0xEE, 0x81, 0x98 },
	0xAAFA,	{ 0xEE, 0x81, 0x99 },
	0xAAFB,	{ 0xEE, 0x81, 0x9A },
	0xAAFC,	{ 0xEE, 0x81, 0x9B },
	0xAAFD,	{ 0xEE, 0x81, 0x9C },
	0xAAFE,	{ 0xEE, 0x81, 0x9D },
	0xAB40,	{ 0xE7, 0x8D, 0xB2 },
	0xAB41,	{ 0xE7, 0x8D, 0xB3 },
	0xAB42,	{ 0xE7, 0x8D, 0xB4 },
	0xAB43,	{ 0xE7, 0x8D, 0xB5 },
	0xAB44,	{ 0xE7, 0x8D, 0xB6 },
	0xAB45,	{ 0xE7, 0x8D, 0xB7 },
	0xAB46,	{ 0xE7, 0x8D, 0xB8 },
	0xAB47,	{ 0xE7, 0x8D, 0xB9 },
	0xAB48,	{ 0xE7, 0x8D, 0xBA },
	0xAB49,	{ 0xE7, 0x8D, 0xBB },
	0xAB4A,	{ 0xE7, 0x8D, 0xBC },
	0xAB4B,	{ 0xE7, 0x8D, 0xBD },
	0xAB4C,	{ 0xE7, 0x8D, 0xBF },
	0xAB4D,	{ 0xE7, 0x8E, 0x80 },
	0xAB4E,	{ 0xE7, 0x8E, 0x81 },
	0xAB4F,	{ 0xE7, 0x8E, 0x82 },
	0xAB50,	{ 0xE7, 0x8E, 0x83 },
	0xAB51,	{ 0xE7, 0x8E, 0x85 },
	0xAB52,	{ 0xE7, 0x8E, 0x86 },
	0xAB53,	{ 0xE7, 0x8E, 0x88 },
	0xAB54,	{ 0xE7, 0x8E, 0x8A },
	0xAB55,	{ 0xE7, 0x8E, 0x8C },
	0xAB56,	{ 0xE7, 0x8E, 0x8D },
	0xAB57,	{ 0xE7, 0x8E, 0x8F },
	0xAB58,	{ 0xE7, 0x8E, 0x90 },
	0xAB59,	{ 0xE7, 0x8E, 0x92 },
	0xAB5A,	{ 0xE7, 0x8E, 0x93 },
	0xAB5B,	{ 0xE7, 0x8E, 0x94 },
	0xAB5C,	{ 0xE7, 0x8E, 0x95 },
	0xAB5D,	{ 0xE7, 0x8E, 0x97 },
	0xAB5E,	{ 0xE7, 0x8E, 0x98 },
	0xAB5F,	{ 0xE7, 0x8E, 0x99 },
	0xAB60,	{ 0xE7, 0x8E, 0x9A },
	0xAB61,	{ 0xE7, 0x8E, 0x9C },
	0xAB62,	{ 0xE7, 0x8E, 0x9D },
	0xAB63,	{ 0xE7, 0x8E, 0x9E },
	0xAB64,	{ 0xE7, 0x8E, 0xA0 },
	0xAB65,	{ 0xE7, 0x8E, 0xA1 },
	0xAB66,	{ 0xE7, 0x8E, 0xA3 },
	0xAB67,	{ 0xE7, 0x8E, 0xA4 },
	0xAB68,	{ 0xE7, 0x8E, 0xA5 },
	0xAB69,	{ 0xE7, 0x8E, 0xA6 },
	0xAB6A,	{ 0xE7, 0x8E, 0xA7 },
	0xAB6B,	{ 0xE7, 0x8E, 0xA8 },
	0xAB6C,	{ 0xE7, 0x8E, 0xAA },
	0xAB6D,	{ 0xE7, 0x8E, 0xAC },
	0xAB6E,	{ 0xE7, 0x8E, 0xAD },
	0xAB6F,	{ 0xE7, 0x8E, 0xB1 },
	0xAB70,	{ 0xE7, 0x8E, 0xB4 },
	0xAB71,	{ 0xE7, 0x8E, 0xB5 },
	0xAB72,	{ 0xE7, 0x8E, 0xB6 },
	0xAB73,	{ 0xE7, 0x8E, 0xB8 },
	0xAB74,	{ 0xE7, 0x8E, 0xB9 },
	0xAB75,	{ 0xE7, 0x8E, 0xBC },
	0xAB76,	{ 0xE7, 0x8E, 0xBD },
	0xAB77,	{ 0xE7, 0x8E, 0xBE },
	0xAB78,	{ 0xE7, 0x8E, 0xBF },
	0xAB79,	{ 0xE7, 0x8F, 0x81 },
	0xAB7A,	{ 0xE7, 0x8F, 0x83 },
	0xAB7B,	{ 0xE7, 0x8F, 0x84 },
	0xAB7C,	{ 0xE7, 0x8F, 0x85 },
	0xAB7D,	{ 0xE7, 0x8F, 0x86 },
	0xAB7E,	{ 0xE7, 0x8F, 0x87 },
	0xAB80,	{ 0xE7, 0x8F, 0x8B },
	0xAB81,	{ 0xE7, 0x8F, 0x8C },
	0xAB82,	{ 0xE7, 0x8F, 0x8E },
	0xAB83,	{ 0xE7, 0x8F, 0x92 },
	0xAB84,	{ 0xE7, 0x8F, 0x93 },
	0xAB85,	{ 0xE7, 0x8F, 0x94 },
	0xAB86,	{ 0xE7, 0x8F, 0x95 },
	0xAB87,	{ 0xE7, 0x8F, 0x96 },
	0xAB88,	{ 0xE7, 0x8F, 0x97 },
	0xAB89,	{ 0xE7, 0x8F, 0x98 },
	0xAB8A,	{ 0xE7, 0x8F, 0x9A },
	0xAB8B,	{ 0xE7, 0x8F, 0x9B },
	0xAB8C,	{ 0xE7, 0x8F, 0x9C },
	0xAB8D,	{ 0xE7, 0x8F, 0x9D },
	0xAB8E,	{ 0xE7, 0x8F, 0x9F },
	0xAB8F,	{ 0xE7, 0x8F, 0xA1 },
	0xAB90,	{ 0xE7, 0x8F, 0xA2 },
	0xAB91,	{ 0xE7, 0x8F, 0xA3 },
	0xAB92,	{ 0xE7, 0x8F, 0xA4 },
	0xAB93,	{ 0xE7, 0x8F, 0xA6 },
	0xAB94,	{ 0xE7, 0x8F, 0xA8 },
	0xAB95,	{ 0xE7, 0x8F, 0xAA },
	0xAB96,	{ 0xE7, 0x8F, 0xAB },
	0xAB97,	{ 0xE7, 0x8F, 0xAC },
	0xAB98,	{ 0xE7, 0x8F, 0xAE },
	0xAB99,	{ 0xE7, 0x8F, 0xAF },
	0xAB9A,	{ 0xE7, 0x8F, 0xB0 },
	0xAB9B,	{ 0xE7, 0x8F, 0xB1 },
	0xAB9C,	{ 0xE7, 0x8F, 0xB3 },
	0xAB9D,	{ 0xE7, 0x8F, 0xB4 },
	0xAB9E,	{ 0xE7, 0x8F, 0xB5 },
	0xAB9F,	{ 0xE7, 0x8F, 0xB6 },
	0xABA0,	{ 0xE7, 0x8F, 0xB7 },
	0xABA1,	{ 0xEE, 0x81, 0x9E },
	0xABA2,	{ 0xEE, 0x81, 0x9F },
	0xABA3,	{ 0xEE, 0x81, 0xA0 },
	0xABA4,	{ 0xEE, 0x81, 0xA1 },
	0xABA5,	{ 0xEE, 0x81, 0xA2 },
	0xABA6,	{ 0xEE, 0x81, 0xA3 },
	0xABA7,	{ 0xEE, 0x81, 0xA4 },
	0xABA8,	{ 0xEE, 0x81, 0xA5 },
	0xABA9,	{ 0xEE, 0x81, 0xA6 },
	0xABAA,	{ 0xEE, 0x81, 0xA7 },
	0xABAB,	{ 0xEE, 0x81, 0xA8 },
	0xABAC,	{ 0xEE, 0x81, 0xA9 },
	0xABAD,	{ 0xEE, 0x81, 0xAA },
	0xABAE,	{ 0xEE, 0x81, 0xAB },
	0xABAF,	{ 0xEE, 0x81, 0xAC },
	0xABB0,	{ 0xEE, 0x81, 0xAD },
	0xABB1,	{ 0xEE, 0x81, 0xAE },
	0xABB2,	{ 0xEE, 0x81, 0xAF },
	0xABB3,	{ 0xEE, 0x81, 0xB0 },
	0xABB4,	{ 0xEE, 0x81, 0xB1 },
	0xABB5,	{ 0xEE, 0x81, 0xB2 },
	0xABB6,	{ 0xEE, 0x81, 0xB3 },
	0xABB7,	{ 0xEE, 0x81, 0xB4 },
	0xABB8,	{ 0xEE, 0x81, 0xB5 },
	0xABB9,	{ 0xEE, 0x81, 0xB6 },
	0xABBA,	{ 0xEE, 0x81, 0xB7 },
	0xABBB,	{ 0xEE, 0x81, 0xB8 },
	0xABBC,	{ 0xEE, 0x81, 0xB9 },
	0xABBD,	{ 0xEE, 0x81, 0xBA },
	0xABBE,	{ 0xEE, 0x81, 0xBB },
	0xABBF,	{ 0xEE, 0x81, 0xBC },
	0xABC0,	{ 0xEE, 0x81, 0xBD },
	0xABC1,	{ 0xEE, 0x81, 0xBE },
	0xABC2,	{ 0xEE, 0x81, 0xBF },
	0xABC3,	{ 0xEE, 0x82, 0x80 },
	0xABC4,	{ 0xEE, 0x82, 0x81 },
	0xABC5,	{ 0xEE, 0x82, 0x82 },
	0xABC6,	{ 0xEE, 0x82, 0x83 },
	0xABC7,	{ 0xEE, 0x82, 0x84 },
	0xABC8,	{ 0xEE, 0x82, 0x85 },
	0xABC9,	{ 0xEE, 0x82, 0x86 },
	0xABCA,	{ 0xEE, 0x82, 0x87 },
	0xABCB,	{ 0xEE, 0x82, 0x88 },
	0xABCC,	{ 0xEE, 0x82, 0x89 },
	0xABCD,	{ 0xEE, 0x82, 0x8A },
	0xABCE,	{ 0xEE, 0x82, 0x8B },
	0xABCF,	{ 0xEE, 0x82, 0x8C },
	0xABD0,	{ 0xEE, 0x82, 0x8D },
	0xABD1,	{ 0xEE, 0x82, 0x8E },
	0xABD2,	{ 0xEE, 0x82, 0x8F },
	0xABD3,	{ 0xEE, 0x82, 0x90 },
	0xABD4,	{ 0xEE, 0x82, 0x91 },
	0xABD5,	{ 0xEE, 0x82, 0x92 },
	0xABD6,	{ 0xEE, 0x82, 0x93 },
	0xABD7,	{ 0xEE, 0x82, 0x94 },
	0xABD8,	{ 0xEE, 0x82, 0x95 },
	0xABD9,	{ 0xEE, 0x82, 0x96 },
	0xABDA,	{ 0xEE, 0x82, 0x97 },
	0xABDB,	{ 0xEE, 0x82, 0x98 },
	0xABDC,	{ 0xEE, 0x82, 0x99 },
	0xABDD,	{ 0xEE, 0x82, 0x9A },
	0xABDE,	{ 0xEE, 0x82, 0x9B },
	0xABDF,	{ 0xEE, 0x82, 0x9C },
	0xABE0,	{ 0xEE, 0x82, 0x9D },
	0xABE1,	{ 0xEE, 0x82, 0x9E },
	0xABE2,	{ 0xEE, 0x82, 0x9F },
	0xABE3,	{ 0xEE, 0x82, 0xA0 },
	0xABE4,	{ 0xEE, 0x82, 0xA1 },
	0xABE5,	{ 0xEE, 0x82, 0xA2 },
	0xABE6,	{ 0xEE, 0x82, 0xA3 },
	0xABE7,	{ 0xEE, 0x82, 0xA4 },
	0xABE8,	{ 0xEE, 0x82, 0xA5 },
	0xABE9,	{ 0xEE, 0x82, 0xA6 },
	0xABEA,	{ 0xEE, 0x82, 0xA7 },
	0xABEB,	{ 0xEE, 0x82, 0xA8 },
	0xABEC,	{ 0xEE, 0x82, 0xA9 },
	0xABED,	{ 0xEE, 0x82, 0xAA },
	0xABEE,	{ 0xEE, 0x82, 0xAB },
	0xABEF,	{ 0xEE, 0x82, 0xAC },
	0xABF0,	{ 0xEE, 0x82, 0xAD },
	0xABF1,	{ 0xEE, 0x82, 0xAE },
	0xABF2,	{ 0xEE, 0x82, 0xAF },
	0xABF3,	{ 0xEE, 0x82, 0xB0 },
	0xABF4,	{ 0xEE, 0x82, 0xB1 },
	0xABF5,	{ 0xEE, 0x82, 0xB2 },
	0xABF6,	{ 0xEE, 0x82, 0xB3 },
	0xABF7,	{ 0xEE, 0x82, 0xB4 },
	0xABF8,	{ 0xEE, 0x82, 0xB5 },
	0xABF9,	{ 0xEE, 0x82, 0xB6 },
	0xABFA,	{ 0xEE, 0x82, 0xB7 },
	0xABFB,	{ 0xEE, 0x82, 0xB8 },
	0xABFC,	{ 0xEE, 0x82, 0xB9 },
	0xABFD,	{ 0xEE, 0x82, 0xBA },
	0xABFE,	{ 0xEE, 0x82, 0xBB },
	0xAC40,	{ 0xE7, 0x8F, 0xB8 },
	0xAC41,	{ 0xE7, 0x8F, 0xB9 },
	0xAC42,	{ 0xE7, 0x8F, 0xBA },
	0xAC43,	{ 0xE7, 0x8F, 0xBB },
	0xAC44,	{ 0xE7, 0x8F, 0xBC },
	0xAC45,	{ 0xE7, 0x8F, 0xBD },
	0xAC46,	{ 0xE7, 0x8F, 0xBE },
	0xAC47,	{ 0xE7, 0x8F, 0xBF },
	0xAC48,	{ 0xE7, 0x90, 0x80 },
	0xAC49,	{ 0xE7, 0x90, 0x81 },
	0xAC4A,	{ 0xE7, 0x90, 0x82 },
	0xAC4B,	{ 0xE7, 0x90, 0x84 },
	0xAC4C,	{ 0xE7, 0x90, 0x87 },
	0xAC4D,	{ 0xE7, 0x90, 0x88 },
	0xAC4E,	{ 0xE7, 0x90, 0x8B },
	0xAC4F,	{ 0xE7, 0x90, 0x8C },
	0xAC50,	{ 0xE7, 0x90, 0x8D },
	0xAC51,	{ 0xE7, 0x90, 0x8E },
	0xAC52,	{ 0xE7, 0x90, 0x91 },
	0xAC53,	{ 0xE7, 0x90, 0x92 },
	0xAC54,	{ 0xE7, 0x90, 0x93 },
	0xAC55,	{ 0xE7, 0x90, 0x94 },
	0xAC56,	{ 0xE7, 0x90, 0x95 },
	0xAC57,	{ 0xE7, 0x90, 0x96 },
	0xAC58,	{ 0xE7, 0x90, 0x97 },
	0xAC59,	{ 0xE7, 0x90, 0x98 },
	0xAC5A,	{ 0xE7, 0x90, 0x99 },
	0xAC5B,	{ 0xE7, 0x90, 0x9C },
	0xAC5C,	{ 0xE7, 0x90, 0x9D },
	0xAC5D,	{ 0xE7, 0x90, 0x9E },
	0xAC5E,	{ 0xE7, 0x90, 0x9F },
	0xAC5F,	{ 0xE7, 0x90, 0xA0 },
	0xAC60,	{ 0xE7, 0x90, 0xA1 },
	0xAC61,	{ 0xE7, 0x90, 0xA3 },
	0xAC62,	{ 0xE7, 0x90, 0xA4 },
	0xAC63,	{ 0xE7, 0x90, 0xA7 },
	0xAC64,	{ 0xE7, 0x90, 0xA9 },
	0xAC65,	{ 0xE7, 0x90, 0xAB },
	0xAC66,	{ 0xE7, 0x90, 0xAD },
	0xAC67,	{ 0xE7, 0x90, 0xAF },
	0xAC68,	{ 0xE7, 0x90, 0xB1 },
	0xAC69,	{ 0xE7, 0x90, 0xB2 },
	0xAC6A,	{ 0xE7, 0x90, 0xB7 },
	0xAC6B,	{ 0xE7, 0x90, 0xB8 },
	0xAC6C,	{ 0xE7, 0x90, 0xB9 },
	0xAC6D,	{ 0xE7, 0x90, 0xBA },
	0xAC6E,	{ 0xE7, 0x90, 0xBB },
	0xAC6F,	{ 0xE7, 0x90, 0xBD },
	0xAC70,	{ 0xE7, 0x90, 0xBE },
	0xAC71,	{ 0xE7, 0x90, 0xBF },
	0xAC72,	{ 0xE7, 0x91, 0x80 },
	0xAC73,	{ 0xE7, 0x91, 0x82 },
	0xAC74,	{ 0xE7, 0x91, 0x83 },
	0xAC75,	{ 0xE7, 0x91, 0x84 },
	0xAC76,	{ 0xE7, 0x91, 0x85 },
	0xAC77,	{ 0xE7, 0x91, 0x86 },
	0xAC78,	{ 0xE7, 0x91, 0x87 },
	0xAC79,	{ 0xE7, 0x91, 0x88 },
	0xAC7A,	{ 0xE7, 0x91, 0x89 },
	0xAC7B,	{ 0xE7, 0x91, 0x8A },
	0xAC7C,	{ 0xE7, 0x91, 0x8B },
	0xAC7D,	{ 0xE7, 0x91, 0x8C },
	0xAC7E,	{ 0xE7, 0x91, 0x8D },
	0xAC80,	{ 0xE7, 0x91, 0x8E },
	0xAC81,	{ 0xE7, 0x91, 0x8F },
	0xAC82,	{ 0xE7, 0x91, 0x90 },
	0xAC83,	{ 0xE7, 0x91, 0x91 },
	0xAC84,	{ 0xE7, 0x91, 0x92 },
	0xAC85,	{ 0xE7, 0x91, 0x93 },
	0xAC86,	{ 0xE7, 0x91, 0x94 },
	0xAC87,	{ 0xE7, 0x91, 0x96 },
	0xAC88,	{ 0xE7, 0x91, 0x98 },
	0xAC89,	{ 0xE7, 0x91, 0x9D },
	0xAC8A,	{ 0xE7, 0x91, 0xA0 },
	0xAC8B,	{ 0xE7, 0x91, 0xA1 },
	0xAC8C,	{ 0xE7, 0x91, 0xA2 },
	0xAC8D,	{ 0xE7, 0x91, 0xA3 },
	0xAC8E,	{ 0xE7, 0x91, 0xA4 },
	0xAC8F,	{ 0xE7, 0x91, 0xA5 },
	0xAC90,	{ 0xE7, 0x91, 0xA6 },
	0xAC91,	{ 0xE7, 0x91, 0xA7 },
	0xAC92,	{ 0xE7, 0x91, 0xA8 },
	0xAC93,	{ 0xE7, 0x91, 0xA9 },
	0xAC94,	{ 0xE7, 0x91, 0xAA },
	0xAC95,	{ 0xE7, 0x91, 0xAB },
	0xAC96,	{ 0xE7, 0x91, 0xAC },
	0xAC97,	{ 0xE7, 0x91, 0xAE },
	0xAC98,	{ 0xE7, 0x91, 0xAF },
	0xAC99,	{ 0xE7, 0x91, 0xB1 },
	0xAC9A,	{ 0xE7, 0x91, 0xB2 },
	0xAC9B,	{ 0xE7, 0x91, 0xB3 },
	0xAC9C,	{ 0xE7, 0x91, 0xB4 },
	0xAC9D,	{ 0xE7, 0x91, 0xB5 },
	0xAC9E,	{ 0xE7, 0x91, 0xB8 },
	0xAC9F,	{ 0xE7, 0x91, 0xB9 },
	0xACA0,	{ 0xE7, 0x91, 0xBA },
	0xACA1,	{ 0xEE, 0x82, 0xBC },
	0xACA2,	{ 0xEE, 0x82, 0xBD },
	0xACA3,	{ 0xEE, 0x82, 0xBE },
	0xACA4,	{ 0xEE, 0x82, 0xBF },
	0xACA5,	{ 0xEE, 0x83, 0x80 },
	0xACA6,	{ 0xEE, 0x83, 0x81 },
	0xACA7,	{ 0xEE, 0x83, 0x82 },
	0xACA8,	{ 0xEE, 0x83, 0x83 },
	0xACA9,	{ 0xEE, 0x83, 0x84 },
	0xACAA,	{ 0xEE, 0x83, 0x85 },
	0xACAB,	{ 0xEE, 0x83, 0x86 },
	0xACAC,	{ 0xEE, 0x83, 0x87 },
	0xACAD,	{ 0xEE, 0x83, 0x88 },
	0xACAE,	{ 0xEE, 0x83, 0x89 },
	0xACAF,	{ 0xEE, 0x83, 0x8A },
	0xACB0,	{ 0xEE, 0x83, 0x8B },
	0xACB1,	{ 0xEE, 0x83, 0x8C },
	0xACB2,	{ 0xEE, 0x83, 0x8D },
	0xACB3,	{ 0xEE, 0x83, 0x8E },
	0xACB4,	{ 0xEE, 0x83, 0x8F },
	0xACB5,	{ 0xEE, 0x83, 0x90 },
	0xACB6,	{ 0xEE, 0x83, 0x91 },
	0xACB7,	{ 0xEE, 0x83, 0x92 },
	0xACB8,	{ 0xEE, 0x83, 0x93 },
	0xACB9,	{ 0xEE, 0x83, 0x94 },
	0xACBA,	{ 0xEE, 0x83, 0x95 },
	0xACBB,	{ 0xEE, 0x83, 0x96 },
	0xACBC,	{ 0xEE, 0x83, 0x97 },
	0xACBD,	{ 0xEE, 0x83, 0x98 },
	0xACBE,	{ 0xEE, 0x83, 0x99 },
	0xACBF,	{ 0xEE, 0x83, 0x9A },
	0xACC0,	{ 0xEE, 0x83, 0x9B },
	0xACC1,	{ 0xEE, 0x83, 0x9C },
	0xACC2,	{ 0xEE, 0x83, 0x9D },
	0xACC3,	{ 0xEE, 0x83, 0x9E },
	0xACC4,	{ 0xEE, 0x83, 0x9F },
	0xACC5,	{ 0xEE, 0x83, 0xA0 },
	0xACC6,	{ 0xEE, 0x83, 0xA1 },
	0xACC7,	{ 0xEE, 0x83, 0xA2 },
	0xACC8,	{ 0xEE, 0x83, 0xA3 },
	0xACC9,	{ 0xEE, 0x83, 0xA4 },
	0xACCA,	{ 0xEE, 0x83, 0xA5 },
	0xACCB,	{ 0xEE, 0x83, 0xA6 },
	0xACCC,	{ 0xEE, 0x83, 0xA7 },
	0xACCD,	{ 0xEE, 0x83, 0xA8 },
	0xACCE,	{ 0xEE, 0x83, 0xA9 },
	0xACCF,	{ 0xEE, 0x83, 0xAA },
	0xACD0,	{ 0xEE, 0x83, 0xAB },
	0xACD1,	{ 0xEE, 0x83, 0xAC },
	0xACD2,	{ 0xEE, 0x83, 0xAD },
	0xACD3,	{ 0xEE, 0x83, 0xAE },
	0xACD4,	{ 0xEE, 0x83, 0xAF },
	0xACD5,	{ 0xEE, 0x83, 0xB0 },
	0xACD6,	{ 0xEE, 0x83, 0xB1 },
	0xACD7,	{ 0xEE, 0x83, 0xB2 },
	0xACD8,	{ 0xEE, 0x83, 0xB3 },
	0xACD9,	{ 0xEE, 0x83, 0xB4 },
	0xACDA,	{ 0xEE, 0x83, 0xB5 },
	0xACDB,	{ 0xEE, 0x83, 0xB6 },
	0xACDC,	{ 0xEE, 0x83, 0xB7 },
	0xACDD,	{ 0xEE, 0x83, 0xB8 },
	0xACDE,	{ 0xEE, 0x83, 0xB9 },
	0xACDF,	{ 0xEE, 0x83, 0xBA },
	0xACE0,	{ 0xEE, 0x83, 0xBB },
	0xACE1,	{ 0xEE, 0x83, 0xBC },
	0xACE2,	{ 0xEE, 0x83, 0xBD },
	0xACE3,	{ 0xEE, 0x83, 0xBE },
	0xACE4,	{ 0xEE, 0x83, 0xBF },
	0xACE5,	{ 0xEE, 0x84, 0x80 },
	0xACE6,	{ 0xEE, 0x84, 0x81 },
	0xACE7,	{ 0xEE, 0x84, 0x82 },
	0xACE8,	{ 0xEE, 0x84, 0x83 },
	0xACE9,	{ 0xEE, 0x84, 0x84 },
	0xACEA,	{ 0xEE, 0x84, 0x85 },
	0xACEB,	{ 0xEE, 0x84, 0x86 },
	0xACEC,	{ 0xEE, 0x84, 0x87 },
	0xACED,	{ 0xEE, 0x84, 0x88 },
	0xACEE,	{ 0xEE, 0x84, 0x89 },
	0xACEF,	{ 0xEE, 0x84, 0x8A },
	0xACF0,	{ 0xEE, 0x84, 0x8B },
	0xACF1,	{ 0xEE, 0x84, 0x8C },
	0xACF2,	{ 0xEE, 0x84, 0x8D },
	0xACF3,	{ 0xEE, 0x84, 0x8E },
	0xACF4,	{ 0xEE, 0x84, 0x8F },
	0xACF5,	{ 0xEE, 0x84, 0x90 },
	0xACF6,	{ 0xEE, 0x84, 0x91 },
	0xACF7,	{ 0xEE, 0x84, 0x92 },
	0xACF8,	{ 0xEE, 0x84, 0x93 },
	0xACF9,	{ 0xEE, 0x84, 0x94 },
	0xACFA,	{ 0xEE, 0x84, 0x95 },
	0xACFB,	{ 0xEE, 0x84, 0x96 },
	0xACFC,	{ 0xEE, 0x84, 0x97 },
	0xACFD,	{ 0xEE, 0x84, 0x98 },
	0xACFE,	{ 0xEE, 0x84, 0x99 },
	0xAD40,	{ 0xE7, 0x91, 0xBB },
	0xAD41,	{ 0xE7, 0x91, 0xBC },
	0xAD42,	{ 0xE7, 0x91, 0xBD },
	0xAD43,	{ 0xE7, 0x91, 0xBF },
	0xAD44,	{ 0xE7, 0x92, 0x82 },
	0xAD45,	{ 0xE7, 0x92, 0x84 },
	0xAD46,	{ 0xE7, 0x92, 0x85 },
	0xAD47,	{ 0xE7, 0x92, 0x86 },
	0xAD48,	{ 0xE7, 0x92, 0x88 },
	0xAD49,	{ 0xE7, 0x92, 0x89 },
	0xAD4A,	{ 0xE7, 0x92, 0x8A },
	0xAD4B,	{ 0xE7, 0x92, 0x8C },
	0xAD4C,	{ 0xE7, 0x92, 0x8D },
	0xAD4D,	{ 0xE7, 0x92, 0x8F },
	0xAD4E,	{ 0xE7, 0x92, 0x91 },
	0xAD4F,	{ 0xE7, 0x92, 0x92 },
	0xAD50,	{ 0xE7, 0x92, 0x93 },
	0xAD51,	{ 0xE7, 0x92, 0x94 },
	0xAD52,	{ 0xE7, 0x92, 0x95 },
	0xAD53,	{ 0xE7, 0x92, 0x96 },
	0xAD54,	{ 0xE7, 0x92, 0x97 },
	0xAD55,	{ 0xE7, 0x92, 0x98 },
	0xAD56,	{ 0xE7, 0x92, 0x99 },
	0xAD57,	{ 0xE7, 0x92, 0x9A },
	0xAD58,	{ 0xE7, 0x92, 0x9B },
	0xAD59,	{ 0xE7, 0x92, 0x9D },
	0xAD5A,	{ 0xE7, 0x92, 0x9F },
	0xAD5B,	{ 0xE7, 0x92, 0xA0 },
	0xAD5C,	{ 0xE7, 0x92, 0xA1 },
	0xAD5D,	{ 0xE7, 0x92, 0xA2 },
	0xAD5E,	{ 0xE7, 0x92, 0xA3 },
	0xAD5F,	{ 0xE7, 0x92, 0xA4 },
	0xAD60,	{ 0xE7, 0x92, 0xA5 },
	0xAD61,	{ 0xE7, 0x92, 0xA6 },
	0xAD62,	{ 0xE7, 0x92, 0xAA },
	0xAD63,	{ 0xE7, 0x92, 0xAB },
	0xAD64,	{ 0xE7, 0x92, 0xAC },
	0xAD65,	{ 0xE7, 0x92, 0xAD },
	0xAD66,	{ 0xE7, 0x92, 0xAE },
	0xAD67,	{ 0xE7, 0x92, 0xAF },
	0xAD68,	{ 0xE7, 0x92, 0xB0 },
	0xAD69,	{ 0xE7, 0x92, 0xB1 },
	0xAD6A,	{ 0xE7, 0x92, 0xB2 },
	0xAD6B,	{ 0xE7, 0x92, 0xB3 },
	0xAD6C,	{ 0xE7, 0x92, 0xB4 },
	0xAD6D,	{ 0xE7, 0x92, 0xB5 },
	0xAD6E,	{ 0xE7, 0x92, 0xB6 },
	0xAD6F,	{ 0xE7, 0x92, 0xB7 },
	0xAD70,	{ 0xE7, 0x92, 0xB8 },
	0xAD71,	{ 0xE7, 0x92, 0xB9 },
	0xAD72,	{ 0xE7, 0x92, 0xBB },
	0xAD73,	{ 0xE7, 0x92, 0xBC },
	0xAD74,	{ 0xE7, 0x92, 0xBD },
	0xAD75,	{ 0xE7, 0x92, 0xBE },
	0xAD76,	{ 0xE7, 0x92, 0xBF },
	0xAD77,	{ 0xE7, 0x93, 0x80 },
	0xAD78,	{ 0xE7, 0x93, 0x81 },
	0xAD79,	{ 0xE7, 0x93, 0x82 },
	0xAD7A,	{ 0xE7, 0x93, 0x83 },
	0xAD7B,	{ 0xE7, 0x93, 0x84 },
	0xAD7C,	{ 0xE7, 0x93, 0x85 },
	0xAD7D,	{ 0xE7, 0x93, 0x86 },
	0xAD7E,	{ 0xE7, 0x93, 0x87 },
	0xAD80,	{ 0xE7, 0x93, 0x88 },
	0xAD81,	{ 0xE7, 0x93, 0x89 },
	0xAD82,	{ 0xE7, 0x93, 0x8A },
	0xAD83,	{ 0xE7, 0x93, 0x8B },
	0xAD84,	{ 0xE7, 0x93, 0x8C },
	0xAD85,	{ 0xE7, 0x93, 0x8D },
	0xAD86,	{ 0xE7, 0x93, 0x8E },
	0xAD87,	{ 0xE7, 0x93, 0x8F },
	0xAD88,	{ 0xE7, 0x93, 0x90 },
	0xAD89,	{ 0xE7, 0x93, 0x91 },
	0xAD8A,	{ 0xE7, 0x93, 0x93 },
	0xAD8B,	{ 0xE7, 0x93, 0x94 },
	0xAD8C,	{ 0xE7, 0x93, 0x95 },
	0xAD8D,	{ 0xE7, 0x93, 0x96 },
	0xAD8E,	{ 0xE7, 0x93, 0x97 },
	0xAD8F,	{ 0xE7, 0x93, 0x98 },
	0xAD90,	{ 0xE7, 0x93, 0x99 },
	0xAD91,	{ 0xE7, 0x93, 0x9A },
	0xAD92,	{ 0xE7, 0x93, 0x9B },
	0xAD93,	{ 0xE7, 0x93, 0x9D },
	0xAD94,	{ 0xE7, 0x93, 0x9F },
	0xAD95,	{ 0xE7, 0x93, 0xA1 },
	0xAD96,	{ 0xE7, 0x93, 0xA5 },
	0xAD97,	{ 0xE7, 0x93, 0xA7 },
	0xAD98,	{ 0xE7, 0x93, 0xA8 },
	0xAD99,	{ 0xE7, 0x93, 0xA9 },
	0xAD9A,	{ 0xE7, 0x93, 0xAA },
	0xAD9B,	{ 0xE7, 0x93, 0xAB },
	0xAD9C,	{ 0xE7, 0x93, 0xAC },
	0xAD9D,	{ 0xE7, 0x93, 0xAD },
	0xAD9E,	{ 0xE7, 0x93, 0xB0 },
	0xAD9F,	{ 0xE7, 0x93, 0xB1 },
	0xADA0,	{ 0xE7, 0x93, 0xB2 },
	0xADA1,	{ 0xEE, 0x84, 0x9A },
	0xADA2,	{ 0xEE, 0x84, 0x9B },
	0xADA3,	{ 0xEE, 0x84, 0x9C },
	0xADA4,	{ 0xEE, 0x84, 0x9D },
	0xADA5,	{ 0xEE, 0x84, 0x9E },
	0xADA6,	{ 0xEE, 0x84, 0x9F },
	0xADA7,	{ 0xEE, 0x84, 0xA0 },
	0xADA8,	{ 0xEE, 0x84, 0xA1 },
	0xADA9,	{ 0xEE, 0x84, 0xA2 },
	0xADAA,	{ 0xEE, 0x84, 0xA3 },
	0xADAB,	{ 0xEE, 0x84, 0xA4 },
	0xADAC,	{ 0xEE, 0x84, 0xA5 },
	0xADAD,	{ 0xEE, 0x84, 0xA6 },
	0xADAE,	{ 0xEE, 0x84, 0xA7 },
	0xADAF,	{ 0xEE, 0x84, 0xA8 },
	0xADB0,	{ 0xEE, 0x84, 0xA9 },
	0xADB1,	{ 0xEE, 0x84, 0xAA },
	0xADB2,	{ 0xEE, 0x84, 0xAB },
	0xADB3,	{ 0xEE, 0x84, 0xAC },
	0xADB4,	{ 0xEE, 0x84, 0xAD },
	0xADB5,	{ 0xEE, 0x84, 0xAE },
	0xADB6,	{ 0xEE, 0x84, 0xAF },
	0xADB7,	{ 0xEE, 0x84, 0xB0 },
	0xADB8,	{ 0xEE, 0x84, 0xB1 },
	0xADB9,	{ 0xEE, 0x84, 0xB2 },
	0xADBA,	{ 0xEE, 0x84, 0xB3 },
	0xADBB,	{ 0xEE, 0x84, 0xB4 },
	0xADBC,	{ 0xEE, 0x84, 0xB5 },
	0xADBD,	{ 0xEE, 0x84, 0xB6 },
	0xADBE,	{ 0xEE, 0x84, 0xB7 },
	0xADBF,	{ 0xEE, 0x84, 0xB8 },
	0xADC0,	{ 0xEE, 0x84, 0xB9 },
	0xADC1,	{ 0xEE, 0x84, 0xBA },
	0xADC2,	{ 0xEE, 0x84, 0xBB },
	0xADC3,	{ 0xEE, 0x84, 0xBC },
	0xADC4,	{ 0xEE, 0x84, 0xBD },
	0xADC5,	{ 0xEE, 0x84, 0xBE },
	0xADC6,	{ 0xEE, 0x84, 0xBF },
	0xADC7,	{ 0xEE, 0x85, 0x80 },
	0xADC8,	{ 0xEE, 0x85, 0x81 },
	0xADC9,	{ 0xEE, 0x85, 0x82 },
	0xADCA,	{ 0xEE, 0x85, 0x83 },
	0xADCB,	{ 0xEE, 0x85, 0x84 },
	0xADCC,	{ 0xEE, 0x85, 0x85 },
	0xADCD,	{ 0xEE, 0x85, 0x86 },
	0xADCE,	{ 0xEE, 0x85, 0x87 },
	0xADCF,	{ 0xEE, 0x85, 0x88 },
	0xADD0,	{ 0xEE, 0x85, 0x89 },
	0xADD1,	{ 0xEE, 0x85, 0x8A },
	0xADD2,	{ 0xEE, 0x85, 0x8B },
	0xADD3,	{ 0xEE, 0x85, 0x8C },
	0xADD4,	{ 0xEE, 0x85, 0x8D },
	0xADD5,	{ 0xEE, 0x85, 0x8E },
	0xADD6,	{ 0xEE, 0x85, 0x8F },
	0xADD7,	{ 0xEE, 0x85, 0x90 },
	0xADD8,	{ 0xEE, 0x85, 0x91 },
	0xADD9,	{ 0xEE, 0x85, 0x92 },
	0xADDA,	{ 0xEE, 0x85, 0x93 },
	0xADDB,	{ 0xEE, 0x85, 0x94 },
	0xADDC,	{ 0xEE, 0x85, 0x95 },
	0xADDD,	{ 0xEE, 0x85, 0x96 },
	0xADDE,	{ 0xEE, 0x85, 0x97 },
	0xADDF,	{ 0xEE, 0x85, 0x98 },
	0xADE0,	{ 0xEE, 0x85, 0x99 },
	0xADE1,	{ 0xEE, 0x85, 0x9A },
	0xADE2,	{ 0xEE, 0x85, 0x9B },
	0xADE3,	{ 0xEE, 0x85, 0x9C },
	0xADE4,	{ 0xEE, 0x85, 0x9D },
	0xADE5,	{ 0xEE, 0x85, 0x9E },
	0xADE6,	{ 0xEE, 0x85, 0x9F },
	0xADE7,	{ 0xEE, 0x85, 0xA0 },
	0xADE8,	{ 0xEE, 0x85, 0xA1 },
	0xADE9,	{ 0xEE, 0x85, 0xA2 },
	0xADEA,	{ 0xEE, 0x85, 0xA3 },
	0xADEB,	{ 0xEE, 0x85, 0xA4 },
	0xADEC,	{ 0xEE, 0x85, 0xA5 },
	0xADED,	{ 0xEE, 0x85, 0xA6 },
	0xADEE,	{ 0xEE, 0x85, 0xA7 },
	0xADEF,	{ 0xEE, 0x85, 0xA8 },
	0xADF0,	{ 0xEE, 0x85, 0xA9 },
	0xADF1,	{ 0xEE, 0x85, 0xAA },
	0xADF2,	{ 0xEE, 0x85, 0xAB },
	0xADF3,	{ 0xEE, 0x85, 0xAC },
	0xADF4,	{ 0xEE, 0x85, 0xAD },
	0xADF5,	{ 0xEE, 0x85, 0xAE },
	0xADF6,	{ 0xEE, 0x85, 0xAF },
	0xADF7,	{ 0xEE, 0x85, 0xB0 },
	0xADF8,	{ 0xEE, 0x85, 0xB1 },
	0xADF9,	{ 0xEE, 0x85, 0xB2 },
	0xADFA,	{ 0xEE, 0x85, 0xB3 },
	0xADFB,	{ 0xEE, 0x85, 0xB4 },
	0xADFC,	{ 0xEE, 0x85, 0xB5 },
	0xADFD,	{ 0xEE, 0x85, 0xB6 },
	0xADFE,	{ 0xEE, 0x85, 0xB7 },
	0xAE40,	{ 0xE7, 0x93, 0xB3 },
	0xAE41,	{ 0xE7, 0x93, 0xB5 },
	0xAE42,	{ 0xE7, 0x93, 0xB8 },
	0xAE43,	{ 0xE7, 0x93, 0xB9 },
	0xAE44,	{ 0xE7, 0x93, 0xBA },
	0xAE45,	{ 0xE7, 0x93, 0xBB },
	0xAE46,	{ 0xE7, 0x93, 0xBC },
	0xAE47,	{ 0xE7, 0x93, 0xBD },
	0xAE48,	{ 0xE7, 0x93, 0xBE },
	0xAE49,	{ 0xE7, 0x94, 0x80 },
	0xAE4A,	{ 0xE7, 0x94, 0x81 },
	0xAE4B,	{ 0xE7, 0x94, 0x82 },
	0xAE4C,	{ 0xE7, 0x94, 0x83 },
	0xAE4D,	{ 0xE7, 0x94, 0x85 },
	0xAE4E,	{ 0xE7, 0x94, 0x86 },
	0xAE4F,	{ 0xE7, 0x94, 0x87 },
	0xAE50,	{ 0xE7, 0x94, 0x88 },
	0xAE51,	{ 0xE7, 0x94, 0x89 },
	0xAE52,	{ 0xE7, 0x94, 0x8A },
	0xAE53,	{ 0xE7, 0x94, 0x8B },
	0xAE54,	{ 0xE7, 0x94, 0x8C },
	0xAE55,	{ 0xE7, 0x94, 0x8E },
	0xAE56,	{ 0xE7, 0x94, 0x90 },
	0xAE57,	{ 0xE7, 0x94, 0x92 },
	0xAE58,	{ 0xE7, 0x94, 0x94 },
	0xAE59,	{ 0xE7, 0x94, 0x95 },
	0xAE5A,	{ 0xE7, 0x94, 0x96 },
	0xAE5B,	{ 0xE7, 0x94, 0x97 },
	0xAE5C,	{ 0xE7, 0x94, 0x9B },
	0xAE5D,	{ 0xE7, 0x94, 0x9D },
	0xAE5E,	{ 0xE7, 0x94, 0x9E },
	0xAE5F,	{ 0xE7, 0x94, 0xA0 },
	0xAE60,	{ 0xE7, 0x94, 0xA1 },
	0xAE61,	{ 0xE7, 0x94, 0xA2 },
	0xAE62,	{ 0xE7, 0x94, 0xA3 },
	0xAE63,	{ 0xE7, 0x94, 0xA4 },
	0xAE64,	{ 0xE7, 0x94, 0xA6 },
	0xAE65,	{ 0xE7, 0x94, 0xA7 },
	0xAE66,	{ 0xE7, 0x94, 0xAA },
	0xAE67,	{ 0xE7, 0x94, 0xAE },
	0xAE68,	{ 0xE7, 0x94, 0xB4 },
	0xAE69,	{ 0xE7, 0x94, 0xB6 },
	0xAE6A,	{ 0xE7, 0x94, 0xB9 },
	0xAE6B,	{ 0xE7, 0x94, 0xBC },
	0xAE6C,	{ 0xE7, 0x94, 0xBD },
	0xAE6D,	{ 0xE7, 0x94, 0xBF },
	0xAE6E,	{ 0xE7, 0x95, 0x81 },
	0xAE6F,	{ 0xE7, 0x95, 0x82 },
	0xAE70,	{ 0xE7, 0x95, 0x83 },
	0xAE71,	{ 0xE7, 0x95, 0x84 },
	0xAE72,	{ 0xE7, 0x95, 0x86 },
	0xAE73,	{ 0xE7, 0x95, 0x87 },
	0xAE74,	{ 0xE7, 0x95, 0x89 },
	0xAE75,	{ 0xE7, 0x95, 0x8A },
	0xAE76,	{ 0xE7, 0x95, 0x8D },
	0xAE77,	{ 0xE7, 0x95, 0x90 },
	0xAE78,	{ 0xE7, 0x95, 0x91 },
	0xAE79,	{ 0xE7, 0x95, 0x92 },
	0xAE7A,	{ 0xE7, 0x95, 0x93 },
	0xAE7B,	{ 0xE7, 0x95, 0x95 },
	0xAE7C,	{ 0xE7, 0x95, 0x96 },
	0xAE7D,	{ 0xE7, 0x95, 0x97 },
	0xAE7E,	{ 0xE7, 0x95, 0x98 },
	0xAE80,	{ 0xE7, 0x95, 0x9D },
	0xAE81,	{ 0xE7, 0x95, 0x9E },
	0xAE82,	{ 0xE7, 0x95, 0x9F },
	0xAE83,	{ 0xE7, 0x95, 0xA0 },
	0xAE84,	{ 0xE7, 0x95, 0xA1 },
	0xAE85,	{ 0xE7, 0x95, 0xA2 },
	0xAE86,	{ 0xE7, 0x95, 0xA3 },
	0xAE87,	{ 0xE7, 0x95, 0xA4 },
	0xAE88,	{ 0xE7, 0x95, 0xA7 },
	0xAE89,	{ 0xE7, 0x95, 0xA8 },
	0xAE8A,	{ 0xE7, 0x95, 0xA9 },
	0xAE8B,	{ 0xE7, 0x95, 0xAB },
	0xAE8C,	{ 0xE7, 0x95, 0xAC },
	0xAE8D,	{ 0xE7, 0x95, 0xAD },
	0xAE8E,	{ 0xE7, 0x95, 0xAE },
	0xAE8F,	{ 0xE7, 0x95, 0xAF },
	0xAE90,	{ 0xE7, 0x95, 0xB0 },
	0xAE91,	{ 0xE7, 0x95, 0xB1 },
	0xAE92,	{ 0xE7, 0x95, 0xB3 },
	0xAE93,	{ 0xE7, 0x95, 0xB5 },
	0xAE94,	{ 0xE7, 0x95, 0xB6 },
	0xAE95,	{ 0xE7, 0x95, 0xB7 },
	0xAE96,	{ 0xE7, 0x95, 0xBA },
	0xAE97,	{ 0xE7, 0x95, 0xBB },
	0xAE98,	{ 0xE7, 0x95, 0xBC },
	0xAE99,	{ 0xE7, 0x95, 0xBD },
	0xAE9A,	{ 0xE7, 0x95, 0xBE },
	0xAE9B,	{ 0xE7, 0x96, 0x80 },
	0xAE9C,	{ 0xE7, 0x96, 0x81 },
	0xAE9D,	{ 0xE7, 0x96, 0x82 },
	0xAE9E,	{ 0xE7, 0x96, 0x84 },
	0xAE9F,	{ 0xE7, 0x96, 0x85 },
	0xAEA0,	{ 0xE7, 0x96, 0x87 },
	0xAEA1,	{ 0xEE, 0x85, 0xB8 },
	0xAEA2,	{ 0xEE, 0x85, 0xB9 },
	0xAEA3,	{ 0xEE, 0x85, 0xBA },
	0xAEA4,	{ 0xEE, 0x85, 0xBB },
	0xAEA5,	{ 0xEE, 0x85, 0xBC },
	0xAEA6,	{ 0xEE, 0x85, 0xBD },
	0xAEA7,	{ 0xEE, 0x85, 0xBE },
	0xAEA8,	{ 0xEE, 0x85, 0xBF },
	0xAEA9,	{ 0xEE, 0x86, 0x80 },
	0xAEAA,	{ 0xEE, 0x86, 0x81 },
	0xAEAB,	{ 0xEE, 0x86, 0x82 },
	0xAEAC,	{ 0xEE, 0x86, 0x83 },
	0xAEAD,	{ 0xEE, 0x86, 0x84 },
	0xAEAE,	{ 0xEE, 0x86, 0x85 },
	0xAEAF,	{ 0xEE, 0x86, 0x86 },
	0xAEB0,	{ 0xEE, 0x86, 0x87 },
	0xAEB1,	{ 0xEE, 0x86, 0x88 },
	0xAEB2,	{ 0xEE, 0x86, 0x89 },
	0xAEB3,	{ 0xEE, 0x86, 0x8A },
	0xAEB4,	{ 0xEE, 0x86, 0x8B },
	0xAEB5,	{ 0xEE, 0x86, 0x8C },
	0xAEB6,	{ 0xEE, 0x86, 0x8D },
	0xAEB7,	{ 0xEE, 0x86, 0x8E },
	0xAEB8,	{ 0xEE, 0x86, 0x8F },
	0xAEB9,	{ 0xEE, 0x86, 0x90 },
	0xAEBA,	{ 0xEE, 0x86, 0x91 },
	0xAEBB,	{ 0xEE, 0x86, 0x92 },
	0xAEBC,	{ 0xEE, 0x86, 0x93 },
	0xAEBD,	{ 0xEE, 0x86, 0x94 },
	0xAEBE,	{ 0xEE, 0x86, 0x95 },
	0xAEBF,	{ 0xEE, 0x86, 0x96 },
	0xAEC0,	{ 0xEE, 0x86, 0x97 },
	0xAEC1,	{ 0xEE, 0x86, 0x98 },
	0xAEC2,	{ 0xEE, 0x86, 0x99 },
	0xAEC3,	{ 0xEE, 0x86, 0x9A },
	0xAEC4,	{ 0xEE, 0x86, 0x9B },
	0xAEC5,	{ 0xEE, 0x86, 0x9C },
	0xAEC6,	{ 0xEE, 0x86, 0x9D },
	0xAEC7,	{ 0xEE, 0x86, 0x9E },
	0xAEC8,	{ 0xEE, 0x86, 0x9F },
	0xAEC9,	{ 0xEE, 0x86, 0xA0 },
	0xAECA,	{ 0xEE, 0x86, 0xA1 },
	0xAECB,	{ 0xEE, 0x86, 0xA2 },
	0xAECC,	{ 0xEE, 0x86, 0xA3 },
	0xAECD,	{ 0xEE, 0x86, 0xA4 },
	0xAECE,	{ 0xEE, 0x86, 0xA5 },
	0xAECF,	{ 0xEE, 0x86, 0xA6 },
	0xAED0,	{ 0xEE, 0x86, 0xA7 },
	0xAED1,	{ 0xEE, 0x86, 0xA8 },
	0xAED2,	{ 0xEE, 0x86, 0xA9 },
	0xAED3,	{ 0xEE, 0x86, 0xAA },
	0xAED4,	{ 0xEE, 0x86, 0xAB },
	0xAED5,	{ 0xEE, 0x86, 0xAC },
	0xAED6,	{ 0xEE, 0x86, 0xAD },
	0xAED7,	{ 0xEE, 0x86, 0xAE },
	0xAED8,	{ 0xEE, 0x86, 0xAF },
	0xAED9,	{ 0xEE, 0x86, 0xB0 },
	0xAEDA,	{ 0xEE, 0x86, 0xB1 },
	0xAEDB,	{ 0xEE, 0x86, 0xB2 },
	0xAEDC,	{ 0xEE, 0x86, 0xB3 },
	0xAEDD,	{ 0xEE, 0x86, 0xB4 },
	0xAEDE,	{ 0xEE, 0x86, 0xB5 },
	0xAEDF,	{ 0xEE, 0x86, 0xB6 },
	0xAEE0,	{ 0xEE, 0x86, 0xB7 },
	0xAEE1,	{ 0xEE, 0x86, 0xB8 },
	0xAEE2,	{ 0xEE, 0x86, 0xB9 },
	0xAEE3,	{ 0xEE, 0x86, 0xBA },
	0xAEE4,	{ 0xEE, 0x86, 0xBB },
	0xAEE5,	{ 0xEE, 0x86, 0xBC },
	0xAEE6,	{ 0xEE, 0x86, 0xBD },
	0xAEE7,	{ 0xEE, 0x86, 0xBE },
	0xAEE8,	{ 0xEE, 0x86, 0xBF },
	0xAEE9,	{ 0xEE, 0x87, 0x80 },
	0xAEEA,	{ 0xEE, 0x87, 0x81 },
	0xAEEB,	{ 0xEE, 0x87, 0x82 },
	0xAEEC,	{ 0xEE, 0x87, 0x83 },
	0xAEED,	{ 0xEE, 0x87, 0x84 },
	0xAEEE,	{ 0xEE, 0x87, 0x85 },
	0xAEEF,	{ 0xEE, 0x87, 0x86 },
	0xAEF0,	{ 0xEE, 0x87, 0x87 },
	0xAEF1,	{ 0xEE, 0x87, 0x88 },
	0xAEF2,	{ 0xEE, 0x87, 0x89 },
	0xAEF3,	{ 0xEE, 0x87, 0x8A },
	0xAEF4,	{ 0xEE, 0x87, 0x8B },
	0xAEF5,	{ 0xEE, 0x87, 0x8C },
	0xAEF6,	{ 0xEE, 0x87, 0x8D },
	0xAEF7,	{ 0xEE, 0x87, 0x8E },
	0xAEF8,	{ 0xEE, 0x87, 0x8F },
	0xAEF9,	{ 0xEE, 0x87, 0x90 },
	0xAEFA,	{ 0xEE, 0x87, 0x91 },
	0xAEFB,	{ 0xEE, 0x87, 0x92 },
	0xAEFC,	{ 0xEE, 0x87, 0x93 },
	0xAEFD,	{ 0xEE, 0x87, 0x94 },
	0xAEFE,	{ 0xEE, 0x87, 0x95 },
	0xAF40,	{ 0xE7, 0x96, 0x88 },
	0xAF41,	{ 0xE7, 0x96, 0x89 },
	0xAF42,	{ 0xE7, 0x96, 0x8A },
	0xAF43,	{ 0xE7, 0x96, 0x8C },
	0xAF44,	{ 0xE7, 0x96, 0x8D },
	0xAF45,	{ 0xE7, 0x96, 0x8E },
	0xAF46,	{ 0xE7, 0x96, 0x90 },
	0xAF47,	{ 0xE7, 0x96, 0x93 },
	0xAF48,	{ 0xE7, 0x96, 0x95 },
	0xAF49,	{ 0xE7, 0x96, 0x98 },
	0xAF4A,	{ 0xE7, 0x96, 0x9B },
	0xAF4B,	{ 0xE7, 0x96, 0x9C },
	0xAF4C,	{ 0xE7, 0x96, 0x9E },
	0xAF4D,	{ 0xE7, 0x96, 0xA2 },
	0xAF4E,	{ 0xE7, 0x96, 0xA6 },
	0xAF4F,	{ 0xE7, 0x96, 0xA7 },
	0xAF50,	{ 0xE7, 0x96, 0xA8 },
	0xAF51,	{ 0xE7, 0x96, 0xA9 },
	0xAF52,	{ 0xE7, 0x96, 0xAA },
	0xAF53,	{ 0xE7, 0x96, 0xAD },
	0xAF54,	{ 0xE7, 0x96, 0xB6 },
	0xAF55,	{ 0xE7, 0x96, 0xB7 },
	0xAF56,	{ 0xE7, 0x96, 0xBA },
	0xAF57,	{ 0xE7, 0x96, 0xBB },
	0xAF58,	{ 0xE7, 0x96, 0xBF },
	0xAF59,	{ 0xE7, 0x97, 0x80 },
	0xAF5A,	{ 0xE7, 0x97, 0x81 },
	0xAF5B,	{ 0xE7, 0x97, 0x86 },
	0xAF5C,	{ 0xE7, 0x97, 0x8B },
	0xAF5D,	{ 0xE7, 0x97, 0x8C },
	0xAF5E,	{ 0xE7, 0x97, 0x8E },
	0xAF5F,	{ 0xE7, 0x97, 0x8F },
	0xAF60,	{ 0xE7, 0x97, 0x90 },
	0xAF61,	{ 0xE7, 0x97, 0x91 },
	0xAF62,	{ 0xE7, 0x97, 0x93 },
	0xAF63,	{ 0xE7, 0x97, 0x97 },
	0xAF64,	{ 0xE7, 0x97, 0x99 },
	0xAF65,	{ 0xE7, 0x97, 0x9A },
	0xAF66,	{ 0xE7, 0x97, 0x9C },
	0xAF67,	{ 0xE7, 0x97, 0x9D },
	0xAF68,	{ 0xE7, 0x97, 0x9F },
	0xAF69,	{ 0xE7, 0x97, 0xA0 },
	0xAF6A,	{ 0xE7, 0x97, 0xA1 },
	0xAF6B,	{ 0xE7, 0x97, 0xA5 },
	0xAF6C,	{ 0xE7, 0x97, 0xA9 },
	0xAF6D,	{ 0xE7, 0x97, 0xAC },
	0xAF6E,	{ 0xE7, 0x97, 0xAD },
	0xAF6F,	{ 0xE7, 0x97, 0xAE },
	0xAF70,	{ 0xE7, 0x97, 0xAF },
	0xAF71,	{ 0xE7, 0x97, 0xB2 },
	0xAF72,	{ 0xE7, 0x97, 0xB3 },
	0xAF73,	{ 0xE7, 0x97, 0xB5 },
	0xAF74,	{ 0xE7, 0x97, 0xB6 },
	0xAF75,	{ 0xE7, 0x97, 0xB7 },
	0xAF76,	{ 0xE7, 0x97, 0xB8 },
	0xAF77,	{ 0xE7, 0x97, 0xBA },
	0xAF78,	{ 0xE7, 0x97, 0xBB },
	0xAF79,	{ 0xE7, 0x97, 0xBD },
	0xAF7A,	{ 0xE7, 0x97, 0xBE },
	0xAF7B,	{ 0xE7, 0x98, 0x82 },
	0xAF7C,	{ 0xE7, 0x98, 0x84 },
	0xAF7D,	{ 0xE7, 0x98, 0x86 },
	0xAF7E,	{ 0xE7, 0x98, 0x87 },
	0xAF80,	{ 0xE7, 0x98, 0x88 },
	0xAF81,	{ 0xE7, 0x98, 0x89 },
	0xAF82,	{ 0xE7, 0x98, 0x8B },
	0xAF83,	{ 0xE7, 0x98, 0x8D },
	0xAF84,	{ 0xE7, 0x98, 0x8E },
	0xAF85,	{ 0xE7, 0x98, 0x8F },
	0xAF86,	{ 0xE7, 0x98, 0x91 },
	0xAF87,	{ 0xE7, 0x98, 0x92 },
	0xAF88,	{ 0xE7, 0x98, 0x93 },
	0xAF89,	{ 0xE7, 0x98, 0x94 },
	0xAF8A,	{ 0xE7, 0x98, 0x96 },
	0xAF8B,	{ 0xE7, 0x98, 0x9A },
	0xAF8C,	{ 0xE7, 0x98, 0x9C },
	0xAF8D,	{ 0xE7, 0x98, 0x9D },
	0xAF8E,	{ 0xE7, 0x98, 0x9E },
	0xAF8F,	{ 0xE7, 0x98, 0xA1 },
	0xAF90,	{ 0xE7, 0x98, 0xA3 },
	0xAF91,	{ 0xE7, 0x98, 0xA7 },
	0xAF92,	{ 0xE7, 0x98, 0xA8 },
	0xAF93,	{ 0xE7, 0x98, 0xAC },
	0xAF94,	{ 0xE7, 0x98, 0xAE },
	0xAF95,	{ 0xE7, 0x98, 0xAF },
	0xAF96,	{ 0xE7, 0x98, 0xB1 },
	0xAF97,	{ 0xE7, 0x98, 0xB2 },
	0xAF98,	{ 0xE7, 0x98, 0xB6 },
	0xAF99,	{ 0xE7, 0x98, 0xB7 },
	0xAF9A,	{ 0xE7, 0x98, 0xB9 },
	0xAF9B,	{ 0xE7, 0x98, 0xBA },
	0xAF9C,	{ 0xE7, 0x98, 0xBB },
	0xAF9D,	{ 0xE7, 0x98, 0xBD },
	0xAF9E,	{ 0xE7, 0x99, 0x81 },
	0xAF9F,	{ 0xE7, 0x99, 0x82 },
	0xAFA0,	{ 0xE7, 0x99, 0x84 },
	0xAFA1,	{ 0xEE, 0x87, 0x96 },
	0xAFA2,	{ 0xEE, 0x87, 0x97 },
	0xAFA3,	{ 0xEE, 0x87, 0x98 },
	0xAFA4,	{ 0xEE, 0x87, 0x99 },
	0xAFA5,	{ 0xEE, 0x87, 0x9A },
	0xAFA6,	{ 0xEE, 0x87, 0x9B },
	0xAFA7,	{ 0xEE, 0x87, 0x9C },
	0xAFA8,	{ 0xEE, 0x87, 0x9D },
	0xAFA9,	{ 0xEE, 0x87, 0x9E },
	0xAFAA,	{ 0xEE, 0x87, 0x9F },
	0xAFAB,	{ 0xEE, 0x87, 0xA0 },
	0xAFAC,	{ 0xEE, 0x87, 0xA1 },
	0xAFAD,	{ 0xEE, 0x87, 0xA2 },
	0xAFAE,	{ 0xEE, 0x87, 0xA3 },
	0xAFAF,	{ 0xEE, 0x87, 0xA4 },
	0xAFB0,	{ 0xEE, 0x87, 0xA5 },
	0xAFB1,	{ 0xEE, 0x87, 0xA6 },
	0xAFB2,	{ 0xEE, 0x87, 0xA7 },
	0xAFB3,	{ 0xEE, 0x87, 0xA8 },
	0xAFB4,	{ 0xEE, 0x87, 0xA9 },
	0xAFB5,	{ 0xEE, 0x87, 0xAA },
	0xAFB6,	{ 0xEE, 0x87, 0xAB },
	0xAFB7,	{ 0xEE, 0x87, 0xAC },
	0xAFB8,	{ 0xEE, 0x87, 0xAD },
	0xAFB9,	{ 0xEE, 0x87, 0xAE },
	0xAFBA,	{ 0xEE, 0x87, 0xAF },
	0xAFBB,	{ 0xEE, 0x87, 0xB0 },
	0xAFBC,	{ 0xEE, 0x87, 0xB1 },
	0xAFBD,	{ 0xEE, 0x87, 0xB2 },
	0xAFBE,	{ 0xEE, 0x87, 0xB3 },
	0xAFBF,	{ 0xEE, 0x87, 0xB4 },
	0xAFC0,	{ 0xEE, 0x87, 0xB5 },
	0xAFC1,	{ 0xEE, 0x87, 0xB6 },
	0xAFC2,	{ 0xEE, 0x87, 0xB7 },
	0xAFC3,	{ 0xEE, 0x87, 0xB8 },
	0xAFC4,	{ 0xEE, 0x87, 0xB9 },
	0xAFC5,	{ 0xEE, 0x87, 0xBA },
	0xAFC6,	{ 0xEE, 0x87, 0xBB },
	0xAFC7,	{ 0xEE, 0x87, 0xBC },
	0xAFC8,	{ 0xEE, 0x87, 0xBD },
	0xAFC9,	{ 0xEE, 0x87, 0xBE },
	0xAFCA,	{ 0xEE, 0x87, 0xBF },
	0xAFCB,	{ 0xEE, 0x88, 0x80 },
	0xAFCC,	{ 0xEE, 0x88, 0x81 },
	0xAFCD,	{ 0xEE, 0x88, 0x82 },
	0xAFCE,	{ 0xEE, 0x88, 0x83 },
	0xAFCF,	{ 0xEE, 0x88, 0x84 },
	0xAFD0,	{ 0xEE, 0x88, 0x85 },
	0xAFD1,	{ 0xEE, 0x88, 0x86 },
	0xAFD2,	{ 0xEE, 0x88, 0x87 },
	0xAFD3,	{ 0xEE, 0x88, 0x88 },
	0xAFD4,	{ 0xEE, 0x88, 0x89 },
	0xAFD5,	{ 0xEE, 0x88, 0x8A },
	0xAFD6,	{ 0xEE, 0x88, 0x8B },
	0xAFD7,	{ 0xEE, 0x88, 0x8C },
	0xAFD8,	{ 0xEE, 0x88, 0x8D },
	0xAFD9,	{ 0xEE, 0x88, 0x8E },
	0xAFDA,	{ 0xEE, 0x88, 0x8F },
	0xAFDB,	{ 0xEE, 0x88, 0x90 },
	0xAFDC,	{ 0xEE, 0x88, 0x91 },
	0xAFDD,	{ 0xEE, 0x88, 0x92 },
	0xAFDE,	{ 0xEE, 0x88, 0x93 },
	0xAFDF,	{ 0xEE, 0x88, 0x94 },
	0xAFE0,	{ 0xEE, 0x88, 0x95 },
	0xAFE1,	{ 0xEE, 0x88, 0x96 },
	0xAFE2,	{ 0xEE, 0x88, 0x97 },
	0xAFE3,	{ 0xEE, 0x88, 0x98 },
	0xAFE4,	{ 0xEE, 0x88, 0x99 },
	0xAFE5,	{ 0xEE, 0x88, 0x9A },
	0xAFE6,	{ 0xEE, 0x88, 0x9B },
	0xAFE7,	{ 0xEE, 0x88, 0x9C },
	0xAFE8,	{ 0xEE, 0x88, 0x9D },
	0xAFE9,	{ 0xEE, 0x88, 0x9E },
	0xAFEA,	{ 0xEE, 0x88, 0x9F },
	0xAFEB,	{ 0xEE, 0x88, 0xA0 },
	0xAFEC,	{ 0xEE, 0x88, 0xA1 },
	0xAFED,	{ 0xEE, 0x88, 0xA2 },
	0xAFEE,	{ 0xEE, 0x88, 0xA3 },
	0xAFEF,	{ 0xEE, 0x88, 0xA4 },
	0xAFF0,	{ 0xEE, 0x88, 0xA5 },
	0xAFF1,	{ 0xEE, 0x88, 0xA6 },
	0xAFF2,	{ 0xEE, 0x88, 0xA7 },
	0xAFF3,	{ 0xEE, 0x88, 0xA8 },
	0xAFF4,	{ 0xEE, 0x88, 0xA9 },
	0xAFF5,	{ 0xEE, 0x88, 0xAA },
	0xAFF6,	{ 0xEE, 0x88, 0xAB },
	0xAFF7,	{ 0xEE, 0x88, 0xAC },
	0xAFF8,	{ 0xEE, 0x88, 0xAD },
	0xAFF9,	{ 0xEE, 0x88, 0xAE },
	0xAFFA,	{ 0xEE, 0x88, 0xAF },
	0xAFFB,	{ 0xEE, 0x88, 0xB0 },
	0xAFFC,	{ 0xEE, 0x88, 0xB1 },
	0xAFFD,	{ 0xEE, 0x88, 0xB2 },
	0xAFFE,	{ 0xEE, 0x88, 0xB3 },
	0xB040,	{ 0xE7, 0x99, 0x85 },
	0xB041,	{ 0xE7, 0x99, 0x86 },
	0xB042,	{ 0xE7, 0x99, 0x87 },
	0xB043,	{ 0xE7, 0x99, 0x88 },
	0xB044,	{ 0xE7, 0x99, 0x89 },
	0xB045,	{ 0xE7, 0x99, 0x8A },
	0xB046,	{ 0xE7, 0x99, 0x8B },
	0xB047,	{ 0xE7, 0x99, 0x8E },
	0xB048,	{ 0xE7, 0x99, 0x8F },
	0xB049,	{ 0xE7, 0x99, 0x90 },
	0xB04A,	{ 0xE7, 0x99, 0x91 },
	0xB04B,	{ 0xE7, 0x99, 0x92 },
	0xB04C,	{ 0xE7, 0x99, 0x93 },
	0xB04D,	{ 0xE7, 0x99, 0x95 },
	0xB04E,	{ 0xE7, 0x99, 0x97 },
	0xB04F,	{ 0xE7, 0x99, 0x98 },
	0xB050,	{ 0xE7, 0x99, 0x99 },
	0xB051,	{ 0xE7, 0x99, 0x9A },
	0xB052,	{ 0xE7, 0x99, 0x9B },
	0xB053,	{ 0xE7, 0x99, 0x9D },
	0xB054,	{ 0xE7, 0x99, 0x9F },
	0xB055,	{ 0xE7, 0x99, 0xA0 },
	0xB056,	{ 0xE7, 0x99, 0xA1 },
	0xB057,	{ 0xE7, 0x99, 0xA2 },
	0xB058,	{ 0xE7, 0x99, 0xA4 },
	0xB059,	{ 0xE7, 0x99, 0xA5 },
	0xB05A,	{ 0xE7, 0x99, 0xA6 },
	0xB05B,	{ 0xE7, 0x99, 0xA7 },
	0xB05C,	{ 0xE7, 0x99, 0xA8 },
	0xB05D,	{ 0xE7, 0x99, 0xA9 },
	0xB05E,	{ 0xE7, 0x99, 0xAA },
	0xB05F,	{ 0xE7, 0x99, 0xAC },
	0xB060,	{ 0xE7, 0x99, 0xAD },
	0xB061,	{ 0xE7, 0x99, 0xAE },
	0xB062,	{ 0xE7, 0x99, 0xB0 },
	0xB063,	{ 0xE7, 0x99, 0xB1 },
	0xB064,	{ 0xE7, 0x99, 0xB2 },
	0xB065,	{ 0xE7, 0x99, 0xB3 },
	0xB066,	{ 0xE7, 0x99, 0xB4 },
	0xB067,	{ 0xE7, 0x99, 0xB5 },
	0xB068,	{ 0xE7, 0x99, 0xB6 },
	0xB069,	{ 0xE7, 0x99, 0xB7 },
	0xB06A,	{ 0xE7, 0x99, 0xB9 },
	0xB06B,	{ 0xE7, 0x99, 0xBA },
	0xB06C,	{ 0xE7, 0x99, 0xBC },
	0xB06D,	{ 0xE7, 0x99, 0xBF },
	0xB06E,	{ 0xE7, 0x9A, 0x80 },
	0xB06F,	{ 0xE7, 0x9A, 0x81 },
	0xB070,	{ 0xE7, 0x9A, 0x83 },
	0xB071,	{ 0xE7, 0x9A, 0x85 },
	0xB072,	{ 0xE7, 0x9A, 0x89 },
	0xB073,	{ 0xE7, 0x9A, 0x8A },
	0xB074,	{ 0xE7, 0x9A, 0x8C },
	0xB075,	{ 0xE7, 0x9A, 0x8D },
	0xB076,	{ 0xE7, 0x9A, 0x8F },
	0xB077,	{ 0xE7, 0x9A, 0x90 },
	0xB078,	{ 0xE7, 0x9A, 0x92 },
	0xB079,	{ 0xE7, 0x9A, 0x94 },
	0xB07A,	{ 0xE7, 0x9A, 0x95 },
	0xB07B,	{ 0xE7, 0x9A, 0x97 },
	0xB07C,	{ 0xE7, 0x9A, 0x98 },
	0xB07D,	{ 0xE7, 0x9A, 0x9A },
	0xB07E,	{ 0xE7, 0x9A, 0x9B },
	0xB080,	{ 0xE7, 0x9A, 0x9C },
	0xB081,	{ 0xE7, 0x9A, 0x9D },
	0xB082,	{ 0xE7, 0x9A, 0x9E },
	0xB083,	{ 0xE7, 0x9A, 0x9F },
	0xB084,	{ 0xE7, 0x9A, 0xA0 },
	0xB085,	{ 0xE7, 0x9A, 0xA1 },
	0xB086,	{ 0xE7, 0x9A, 0xA2 },
	0xB087,	{ 0xE7, 0x9A, 0xA3 },
	0xB088,	{ 0xE7, 0x9A, 0xA5 },
	0xB089,	{ 0xE7, 0x9A, 0xA6 },
	0xB08A,	{ 0xE7, 0x9A, 0xA7 },
	0xB08B,	{ 0xE7, 0x9A, 0xA8 },
	0xB08C,	{ 0xE7, 0x9A, 0xA9 },
	0xB08D,	{ 0xE7, 0x9A, 0xAA },
	0xB08E,	{ 0xE7, 0x9A, 0xAB },
	0xB08F,	{ 0xE7, 0x9A, 0xAC },
	0xB090,	{ 0xE7, 0x9A, 0xAD },
	0xB091,	{ 0xE7, 0x9A, 0xAF },
	0xB092,	{ 0xE7, 0x9A, 0xB0 },
	0xB093,	{ 0xE7, 0x9A, 0xB3 },
	0xB094,	{ 0xE7, 0x9A, 0xB5 },
	0xB095,	{ 0xE7, 0x9A, 0xB6 },
	0xB096,	{ 0xE7, 0x9A, 0xB7 },
	0xB097,	{ 0xE7, 0x9A, 0xB8 },
	0xB098,	{ 0xE7, 0x9A, 0xB9 },
	0xB099,	{ 0xE7, 0x9A, 0xBA },
	0xB09A,	{ 0xE7, 0x9A, 0xBB },
	0xB09B,	{ 0xE7, 0x9A, 0xBC },
	0xB09C,	{ 0xE7, 0x9A, 0xBD },
	0xB09D,	{ 0xE7, 0x9A, 0xBE },
	0xB09E,	{ 0xE7, 0x9B, 0x80 },
	0xB09F,	{ 0xE7, 0x9B, 0x81 },
	0xB0A0,	{ 0xE7, 0x9B, 0x83 },
	0xB0A1,	{ 0xE5, 0x95, 0x8A },
	0xB0A2,	{ 0xE9, 0x98, 0xBF },
	0xB0A3,	{ 0xE5, 0x9F, 0x83 },
	0xB0A4,	{ 0xE6, 0x8C, 0xA8 },
	0xB0A5,	{ 0xE5, 0x93, 0x8E },
	0xB0A6,	{ 0xE5, 0x94, 0x89 },
	0xB0A7,	{ 0xE5, 0x93, 0x80 },
	0xB0A8,	{ 0xE7, 0x9A, 0x91 },
	0xB0A9,	{ 0xE7, 0x99, 0x8C },
	0xB0AA,	{ 0xE8, 0x94, 0xBC },
	0xB0AB,	{ 0xE7, 0x9F, 0xAE },
	0xB0AC,	{ 0xE8, 0x89, 0xBE },
	0xB0AD,	{ 0xE7, 0xA2, 0x8D },
	0xB0AE,	{ 0xE7, 0x88, 0xB1 },
	0xB0AF,	{ 0xE9, 0x9A, 0x98 },
	0xB0B0,	{ 0xE9, 0x9E, 0x8D },
	0xB0B1,	{ 0xE6, 0xB0, 0xA8 },
	0xB0B2,	{ 0xE5, 0xAE, 0x89 },
	0xB0B3,	{ 0xE4, 0xBF, 0xBA },
	0xB0B4,	{ 0xE6, 0x8C, 0x89 },
	0xB0B5,	{ 0xE6, 0x9A, 0x97 },
	0xB0B6,	{ 0xE5, 0xB2, 0xB8 },
	0xB0B7,	{ 0xE8, 0x83, 0xBA },
	0xB0B8,	{ 0xE6, 0xA1, 0x88 },
	0xB0B9,	{ 0xE8, 0x82, 0xAE },
	0xB0BA,	{ 0xE6, 0x98, 0x82 },
	0xB0BB,	{ 0xE7, 0x9B, 0x8E },
	0xB0BC,	{ 0xE5, 0x87, 0xB9 },
	0xB0BD,	{ 0xE6, 0x95, 0x96 },
	0xB0BE,	{ 0xE7, 0x86, 0xAC },
	0xB0BF,	{ 0xE7, 0xBF, 0xB1 },
	0xB0C0,	{ 0xE8, 0xA2, 0x84 },
	0xB0C1,	{ 0xE5, 0x82, 0xB2 },
	0xB0C2,	{ 0xE5, 0xA5, 0xA5 },
	0xB0C3,	{ 0xE6, 0x87, 0x8A },
	0xB0C4,	{ 0xE6, 0xBE, 0xB3 },
	0xB0C5,	{ 0xE8, 0x8A, 0xAD },
	0xB0C6,	{ 0xE6, 0x8D, 0x8C },
	0xB0C7,	{ 0xE6, 0x89, 0x92 },
	0xB0C8,	{ 0xE5, 0x8F, 0xAD },
	0xB0C9,	{ 0xE5, 0x90, 0xA7 },
	0xB0CA,	{ 0xE7, 0xAC, 0x86 },
	0xB0CB,	{ 0xE5, 0x85, 0xAB },
	0xB0CC,	{ 0xE7, 0x96, 0xA4 },
	0xB0CD,	{ 0xE5, 0xB7, 0xB4 },
	0xB0CE,	{ 0xE6, 0x8B, 0x94 },
	0xB0CF,	{ 0xE8, 0xB7, 0x8B },
	0xB0D0,	{ 0xE9, 0x9D, 0xB6 },
	0xB0D1,	{ 0xE6, 0x8A, 0x8A },
	0xB0D2,	{ 0xE8, 0x80, 0x99 },
	0xB0D3,	{ 0xE5, 0x9D, 0x9D },
	0xB0D4,	{ 0xE9, 0x9C, 0xB8 },
	0xB0D5,	{ 0xE7, 0xBD, 0xA2 },
	0xB0D6,	{ 0xE7, 0x88, 0xB8 },
	0xB0D7,	{ 0xE7, 0x99, 0xBD },
	0xB0D8,	{ 0xE6, 0x9F, 0x8F },
	0xB0D9,	{ 0xE7, 0x99, 0xBE },
	0xB0DA,	{ 0xE6, 0x91, 0x86 },
	0xB0DB,	{ 0xE4, 0xBD, 0xB0 },
	0xB0DC,	{ 0xE8, 0xB4, 0xA5 },
	0xB0DD,	{ 0xE6, 0x8B, 0x9C },
	0xB0DE,	{ 0xE7, 0xA8, 0x97 },
	0xB0DF,	{ 0xE6, 0x96, 0x91 },
	0xB0E0,	{ 0xE7, 0x8F, 0xAD },
	0xB0E1,	{ 0xE6, 0x90, 0xAC },
	0xB0E2,	{ 0xE6, 0x89, 0xB3 },
	0xB0E3,	{ 0xE8, 0x88, 0xAC },
	0xB0E4,	{ 0xE9, 0xA2, 0x81 },
	0xB0E5,	{ 0xE6, 0x9D, 0xBF },
	0xB0E6,	{ 0xE7, 0x89, 0x88 },
	0xB0E7,	{ 0xE6, 0x89, 0xAE },
	0xB0E8,	{ 0xE6, 0x8B, 0x8C },
	0xB0E9,	{ 0xE4, 0xBC, 0xB4 },
	0xB0EA,	{ 0xE7, 0x93, 0xA3 },
	0xB0EB,	{ 0xE5, 0x8D, 0x8A },
	0xB0EC,	{ 0xE5, 0x8A, 0x9E },
	0xB0ED,	{ 0xE7, 0xBB, 0x8A },
	0xB0EE,	{ 0xE9, 0x82, 0xA6 },
	0xB0EF,	{ 0xE5, 0xB8, 0xAE },
	0xB0F0,	{ 0xE6, 0xA2, 0x86 },
	0xB0F1,	{ 0xE6, 0xA6, 0x9C },
	0xB0F2,	{ 0xE8, 0x86, 0x80 },
	0xB0F3,	{ 0xE7, 0xBB, 0x91 },
	0xB0F4,	{ 0xE6, 0xA3, 0x92 },
	0xB0F5,	{ 0xE7, 0xA3, 0x85 },
	0xB0F6,	{ 0xE8, 0x9A, 0x8C },
	0xB0F7,	{ 0xE9, 0x95, 0x91 },
	0xB0F8,	{ 0xE5, 0x82, 0x8D },
	0xB0F9,	{ 0xE8, 0xB0, 0xA4 },
	0xB0FA,	{ 0xE8, 0x8B, 0x9E },
	0xB0FB,	{ 0xE8, 0x83, 0x9E },
	0xB0FC,	{ 0xE5, 0x8C, 0x85 },
	0xB0FD,	{ 0xE8, 0xA4, 0x92 },
	0xB0FE,	{ 0xE5, 0x89, 0xA5 },
	0xB140,	{ 0xE7, 0x9B, 0x84 },
	0xB141,	{ 0xE7, 0x9B, 0x87 },
	0xB142,	{ 0xE7, 0x9B, 0x89 },
	0xB143,	{ 0xE7, 0x9B, 0x8B },
	0xB144,	{ 0xE7, 0x9B, 0x8C },
	0xB145,	{ 0xE7, 0x9B, 0x93 },
	0xB146,	{ 0xE7, 0x9B, 0x95 },
	0xB147,	{ 0xE7, 0x9B, 0x99 },
	0xB148,	{ 0xE7, 0x9B, 0x9A },
	0xB149,	{ 0xE7, 0x9B, 0x9C },
	0xB14A,	{ 0xE7, 0x9B, 0x9D },
	0xB14B,	{ 0xE7, 0x9B, 0x9E },
	0xB14C,	{ 0xE7, 0x9B, 0xA0 },
	0xB14D,	{ 0xE7, 0x9B, 0xA1 },
	0xB14E,	{ 0xE7, 0x9B, 0xA2 },
	0xB14F,	{ 0xE7, 0x9B, 0xA3 },
	0xB150,	{ 0xE7, 0x9B, 0xA4 },
	0xB151,	{ 0xE7, 0x9B, 0xA6 },
	0xB152,	{ 0xE7, 0x9B, 0xA7 },
	0xB153,	{ 0xE7, 0x9B, 0xA8 },
	0xB154,	{ 0xE7, 0x9B, 0xA9 },
	0xB155,	{ 0xE7, 0x9B, 0xAA },
	0xB156,	{ 0xE7, 0x9B, 0xAB },
	0xB157,	{ 0xE7, 0x9B, 0xAC },
	0xB158,	{ 0xE7, 0x9B, 0xAD },
	0xB159,	{ 0xE7, 0x9B, 0xB0 },
	0xB15A,	{ 0xE7, 0x9B, 0xB3 },
	0xB15B,	{ 0xE7, 0x9B, 0xB5 },
	0xB15C,	{ 0xE7, 0x9B, 0xB6 },
	0xB15D,	{ 0xE7, 0x9B, 0xB7 },
	0xB15E,	{ 0xE7, 0x9B, 0xBA },
	0xB15F,	{ 0xE7, 0x9B, 0xBB },
	0xB160,	{ 0xE7, 0x9B, 0xBD },
	0xB161,	{ 0xE7, 0x9B, 0xBF },
	0xB162,	{ 0xE7, 0x9C, 0x80 },
	0xB163,	{ 0xE7, 0x9C, 0x82 },
	0xB164,	{ 0xE7, 0x9C, 0x83 },
	0xB165,	{ 0xE7, 0x9C, 0x85 },
	0xB166,	{ 0xE7, 0x9C, 0x86 },
	0xB167,	{ 0xE7, 0x9C, 0x8A },
	0xB168,	{ 0xE7, 0x9C, 0x8C },
	0xB169,	{ 0xE7, 0x9C, 0x8E },
	0xB16A,	{ 0xE7, 0x9C, 0x8F },
	0xB16B,	{ 0xE7, 0x9C, 0x90 },
	0xB16C,	{ 0xE7, 0x9C, 0x91 },
	0xB16D,	{ 0xE7, 0x9C, 0x92 },
	0xB16E,	{ 0xE7, 0x9C, 0x93 },
	0xB16F,	{ 0xE7, 0x9C, 0x94 },
	0xB170,	{ 0xE7, 0x9C, 0x95 },
	0xB171,	{ 0xE7, 0x9C, 0x96 },
	0xB172,	{ 0xE7, 0x9C, 0x97 },
	0xB173,	{ 0xE7, 0x9C, 0x98 },
	0xB174,	{ 0xE7, 0x9C, 0x9B },
	0xB175,	{ 0xE7, 0x9C, 0x9C },
	0xB176,	{ 0xE7, 0x9C, 0x9D },
	0xB177,	{ 0xE7, 0x9C, 0x9E },
	0xB178,	{ 0xE7, 0x9C, 0xA1 },
	0xB179,	{ 0xE7, 0x9C, 0xA3 },
	0xB17A,	{ 0xE7, 0x9C, 0xA4 },
	0xB17B,	{ 0xE7, 0x9C, 0xA5 },
	0xB17C,	{ 0xE7, 0x9C, 0xA7 },
	0xB17D,	{ 0xE7, 0x9C, 0xAA },
	0xB17E,	{ 0xE7, 0x9C, 0xAB },
	0xB180,	{ 0xE7, 0x9C, 0xAC },
	0xB181,	{ 0xE7, 0x9C, 0xAE },
	0xB182,	{ 0xE7, 0x9C, 0xB0 },
	0xB183,	{ 0xE7, 0x9C, 0xB1 },
	0xB184,	{ 0xE7, 0x9C, 0xB2 },
	0xB185,	{ 0xE7, 0x9C, 0xB3 },
	0xB186,	{ 0xE7, 0x9C, 0xB4 },
	0xB187,	{ 0xE7, 0x9C, 0xB9 },
	0xB188,	{ 0xE7, 0x9C, 0xBB },
	0xB189,	{ 0xE7, 0x9C, 0xBD },
	0xB18A,	{ 0xE7, 0x9C, 0xBE },
	0xB18B,	{ 0xE7, 0x9C, 0xBF },
	0xB18C,	{ 0xE7, 0x9D, 0x82 },
	0xB18D,	{ 0xE7, 0x9D, 0x84 },
	0xB18E,	{ 0xE7, 0x9D, 0x85 },
	0xB18F,	{ 0xE7, 0x9D, 0x86 },
	0xB190,	{ 0xE7, 0x9D, 0x88 },
	0xB191,	{ 0xE7, 0x9D, 0x89 },
	0xB192,	{ 0xE7, 0x9D, 0x8A },
	0xB193,	{ 0xE7, 0x9D, 0x8B },
	0xB194,	{ 0xE7, 0x9D, 0x8C },
	0xB195,	{ 0xE7, 0x9D, 0x8D },
	0xB196,	{ 0xE7, 0x9D, 0x8E },
	0xB197,	{ 0xE7, 0x9D, 0x8F },
	0xB198,	{ 0xE7, 0x9D, 0x92 },
	0xB199,	{ 0xE7, 0x9D, 0x93 },
	0xB19A,	{ 0xE7, 0x9D, 0x94 },
	0xB19B,	{ 0xE7, 0x9D, 0x95 },
	0xB19C,	{ 0xE7, 0x9D, 0x96 },
	0xB19D,	{ 0xE7, 0x9D, 0x97 },
	0xB19E,	{ 0xE7, 0x9D, 0x98 },
	0xB19F,	{ 0xE7, 0x9D, 0x99 },
	0xB1A0,	{ 0xE7, 0x9D, 0x9C },
	0xB1A1,	{ 0xE8, 0x96, 0x84 },
	0xB1A2,	{ 0xE9, 0x9B, 0xB9 },
	0xB1A3,	{ 0xE4, 0xBF, 0x9D },
	0xB1A4,	{ 0xE5, 0xA0, 0xA1 },
	0xB1A5,	{ 0xE9, 0xA5, 0xB1 },
	0xB1A6,	{ 0xE5, 0xAE, 0x9D },
	0xB1A7,	{ 0xE6, 0x8A, 0xB1 },
	0xB1A8,	{ 0xE6, 0x8A, 0xA5 },
	0xB1A9,	{ 0xE6, 0x9A, 0xB4 },
	0xB1AA,	{ 0xE8, 0xB1, 0xB9 },
	0xB1AB,	{ 0xE9, 0xB2, 0x8D },
	0xB1AC,	{ 0xE7, 0x88, 0x86 },
	0xB1AD,	{ 0xE6, 0x9D, 0xAF },
	0xB1AE,	{ 0xE7, 0xA2, 0x91 },
	0xB1AF,	{ 0xE6, 0x82, 0xB2 },
	0xB1B0,	{ 0xE5, 0x8D, 0x91 },
	0xB1B1,	{ 0xE5, 0x8C, 0x97 },
	0xB1B2,	{ 0xE8, 0xBE, 0x88 },
	0xB1B3,	{ 0xE8, 0x83, 0x8C },
	0xB1B4,	{ 0xE8, 0xB4, 0x9D },
	0xB1B5,	{ 0xE9, 0x92, 0xA1 },
	0xB1B6,	{ 0xE5, 0x80, 0x8D },
	0xB1B7,	{ 0xE7, 0x8B, 0x88 },
	0xB1B8,	{ 0xE5, 0xA4, 0x87 },
	0xB1B9,	{ 0xE6, 0x83, 0xAB },
	0xB1BA,	{ 0xE7, 0x84, 0x99 },
	0xB1BB,	{ 0xE8, 0xA2, 0xAB },
	0xB1BC,	{ 0xE5, 0xA5, 0x94 },
	0xB1BD,	{ 0xE8, 0x8B, 0xAF },
	0xB1BE,	{ 0xE6, 0x9C, 0xAC },
	0xB1BF,	{ 0xE7, 0xAC, 0xA8 },
	0xB1C0,	{ 0xE5, 0xB4, 0xA9 },
	0xB1C1,	{ 0xE7, 0xBB, 0xB7 },
	0xB1C2,	{ 0xE7, 0x94, 0xAD },
	0xB1C3,	{ 0xE6, 0xB3, 0xB5 },
	0xB1C4,	{ 0xE8, 0xB9, 0xA6 },
	0xB1C5,	{ 0xE8, 0xBF, 0xB8 },
	0xB1C6,	{ 0xE9, 0x80, 0xBC },
	0xB1C7,	{ 0xE9, 0xBC, 0xBB },
	0xB1C8,	{ 0xE6, 0xAF, 0x94 },
	0xB1C9,	{ 0xE9, 0x84, 0x99 },
	0xB1CA,	{ 0xE7, 0xAC, 0x94 },
	0xB1CB,	{ 0xE5, 0xBD, 0xBC },
	0xB1CC,	{ 0xE7, 0xA2, 0xA7 },
	0xB1CD,	{ 0xE8, 0x93, 0x96 },
	0xB1CE,	{ 0xE8, 0x94, 0xBD },
	0xB1CF,	{ 0xE6, 0xAF, 0x95 },
	0xB1D0,	{ 0xE6, 0xAF, 0x99 },
	0xB1D1,	{ 0xE6, 0xAF, 0x96 },
	0xB1D2,	{ 0xE5, 0xB8, 0x81 },
	0xB1D3,	{ 0xE5, 0xBA, 0x87 },
	0xB1D4,	{ 0xE7, 0x97, 0xB9 },
	0xB1D5,	{ 0xE9, 0x97, 0xAD },
	0xB1D6,	{ 0xE6, 0x95, 0x9D },
	0xB1D7,	{ 0xE5, 0xBC, 0x8A },
	0xB1D8,	{ 0xE5, 0xBF, 0x85 },
	0xB1D9,	{ 0xE8, 0xBE, 0x9F },
	0xB1DA,	{ 0xE5, 0xA3, 0x81 },
	0xB1DB,	{ 0xE8, 0x87, 0x82 },
	0xB1DC,	{ 0xE9, 0x81, 0xBF },
	0xB1DD,	{ 0xE9, 0x99, 0x9B },
	0xB1DE,	{ 0xE9, 0x9E, 0xAD },
	0xB1DF,	{ 0xE8, 0xBE, 0xB9 },
	0xB1E0,	{ 0xE7, 0xBC, 0x96 },
	0xB1E1,	{ 0xE8, 0xB4, 0xAC },
	0xB1E2,	{ 0xE6, 0x89, 0x81 },
	0xB1E3,	{ 0xE4, 0xBE, 0xBF },
	0xB1E4,	{ 0xE5, 0x8F, 0x98 },
	0xB1E5,	{ 0xE5, 0x8D, 0x9E },
	0xB1E6,	{ 0xE8, 0xBE, 0xA8 },
	0xB1E7,	{ 0xE8, 0xBE, 0xA9 },
	0xB1E8,	{ 0xE8, 0xBE, 0xAB },
	0xB1E9,	{ 0xE9, 0x81, 0x8D },
	0xB1EA,	{ 0xE6, 0xA0, 0x87 },
	0xB1EB,	{ 0xE5, 0xBD, 0xAA },
	0xB1EC,	{ 0xE8, 0x86, 0x98 },
	0xB1ED,	{ 0xE8, 0xA1, 0xA8 },
	0xB1EE,	{ 0xE9, 0xB3, 0x96 },
	0xB1EF,	{ 0xE6, 0x86, 0x8B },
	0xB1F0,	{ 0xE5, 0x88, 0xAB },
	0xB1F1,	{ 0xE7, 0x98, 0xAA },
	0xB1F2,	{ 0xE5, 0xBD, 0xAC },
	0xB1F3,	{ 0xE6, 0x96, 0x8C },
	0xB1F4,	{ 0xE6, 0xBF, 0x92 },
	0xB1F5,	{ 0xE6, 0xBB, 0xA8 },
	0xB1F6,	{ 0xE5, 0xAE, 0xBE },
	0xB1F7,	{ 0xE6, 0x91, 0x88 },
	0xB1F8,	{ 0xE5, 0x85, 0xB5 },
	0xB1F9,	{ 0xE5, 0x86, 0xB0 },
	0xB1FA,	{ 0xE6, 0x9F, 0x84 },
	0xB1FB,	{ 0xE4, 0xB8, 0x99 },
	0xB1FC,	{ 0xE7, 0xA7, 0x89 },
	0xB1FD,	{ 0xE9, 0xA5, 0xBC },
	0xB1FE,	{ 0xE7, 0x82, 0xB3 },
	0xB240,	{ 0xE7, 0x9D, 0x9D },
	0xB241,	{ 0xE7, 0x9D, 0x9E },
	0xB242,	{ 0xE7, 0x9D, 0x9F },
	0xB243,	{ 0xE7, 0x9D, 0xA0 },
	0xB244,	{ 0xE7, 0x9D, 0xA4 },
	0xB245,	{ 0xE7, 0x9D, 0xA7 },
	0xB246,	{ 0xE7, 0x9D, 0xA9 },
	0xB247,	{ 0xE7, 0x9D, 0xAA },
	0xB248,	{ 0xE7, 0x9D, 0xAD },
	0xB249,	{ 0xE7, 0x9D, 0xAE },
	0xB24A,	{ 0xE7, 0x9D, 0xAF },
	0xB24B,	{ 0xE7, 0x9D, 0xB0 },
	0xB24C,	{ 0xE7, 0x9D, 0xB1 },
	0xB24D,	{ 0xE7, 0x9D, 0xB2 },
	0xB24E,	{ 0xE7, 0x9D, 0xB3 },
	0xB24F,	{ 0xE7, 0x9D, 0xB4 },
	0xB250,	{ 0xE7, 0x9D, 0xB5 },
	0xB251,	{ 0xE7, 0x9D, 0xB6 },
	0xB252,	{ 0xE7, 0x9D, 0xB7 },
	0xB253,	{ 0xE7, 0x9D, 0xB8 },
	0xB254,	{ 0xE7, 0x9D, 0xBA },
	0xB255,	{ 0xE7, 0x9D, 0xBB },
	0xB256,	{ 0xE7, 0x9D, 0xBC },
	0xB257,	{ 0xE7, 0x9E, 0x81 },
	0xB258,	{ 0xE7, 0x9E, 0x82 },
	0xB259,	{ 0xE7, 0x9E, 0x83 },
	0xB25A,	{ 0xE7, 0x9E, 0x86 },
	0xB25B,	{ 0xE7, 0x9E, 0x87 },
	0xB25C,	{ 0xE7, 0x9E, 0x88 },
	0xB25D,	{ 0xE7, 0x9E, 0x89 },
	0xB25E,	{ 0xE7, 0x9E, 0x8A },
	0xB25F,	{ 0xE7, 0x9E, 0x8B },
	0xB260,	{ 0xE7, 0x9E, 0x8F },
	0xB261,	{ 0xE7, 0x9E, 0x90 },
	0xB262,	{ 0xE7, 0x9E, 0x93 },
	0xB263,	{ 0xE7, 0x9E, 0x94 },
	0xB264,	{ 0xE7, 0x9E, 0x95 },
	0xB265,	{ 0xE7, 0x9E, 0x96 },
	0xB266,	{ 0xE7, 0x9E, 0x97 },
	0xB267,	{ 0xE7, 0x9E, 0x98 },
	0xB268,	{ 0xE7, 0x9E, 0x99 },
	0xB269,	{ 0xE7, 0x9E, 0x9A },
	0xB26A,	{ 0xE7, 0x9E, 0x9B },
	0xB26B,	{ 0xE7, 0x9E, 0x9C },
	0xB26C,	{ 0xE7, 0x9E, 0x9D },
	0xB26D,	{ 0xE7, 0x9E, 0x9E },
	0xB26E,	{ 0xE7, 0x9E, 0xA1 },
	0xB26F,	{ 0xE7, 0x9E, 0xA3 },
	0xB270,	{ 0xE7, 0x9E, 0xA4 },
	0xB271,	{ 0xE7, 0x9E, 0xA6 },
	0xB272,	{ 0xE7, 0x9E, 0xA8 },
	0xB273,	{ 0xE7, 0x9E, 0xAB },
	0xB274,	{ 0xE7, 0x9E, 0xAD },
	0xB275,	{ 0xE7, 0x9E, 0xAE },
	0xB276,	{ 0xE7, 0x9E, 0xAF },
	0xB277,	{ 0xE7, 0x9E, 0xB1 },
	0xB278,	{ 0xE7, 0x9E, 0xB2 },
	0xB279,	{ 0xE7, 0x9E, 0xB4 },
	0xB27A,	{ 0xE7, 0x9E, 0xB6 },
	0xB27B,	{ 0xE7, 0x9E, 0xB7 },
	0xB27C,	{ 0xE7, 0x9E, 0xB8 },
	0xB27D,	{ 0xE7, 0x9E, 0xB9 },
	0xB27E,	{ 0xE7, 0x9E, 0xBA },
	0xB280,	{ 0xE7, 0x9E, 0xBC },
	0xB281,	{ 0xE7, 0x9E, 0xBE },
	0xB282,	{ 0xE7, 0x9F, 0x80 },
	0xB283,	{ 0xE7, 0x9F, 0x81 },
	0xB284,	{ 0xE7, 0x9F, 0x82 },
	0xB285,	{ 0xE7, 0x9F, 0x83 },
	0xB286,	{ 0xE7, 0x9F, 0x84 },
	0xB287,	{ 0xE7, 0x9F, 0x85 },
	0xB288,	{ 0xE7, 0x9F, 0x86 },
	0xB289,	{ 0xE7, 0x9F, 0x87 },
	0xB28A,	{ 0xE7, 0x9F, 0x88 },
	0xB28B,	{ 0xE7, 0x9F, 0x89 },
	0xB28C,	{ 0xE7, 0x9F, 0x8A },
	0xB28D,	{ 0xE7, 0x9F, 0x8B },
	0xB28E,	{ 0xE7, 0x9F, 0x8C },
	0xB28F,	{ 0xE7, 0x9F, 0x8E },
	0xB290,	{ 0xE7, 0x9F, 0x8F },
	0xB291,	{ 0xE7, 0x9F, 0x90 },
	0xB292,	{ 0xE7, 0x9F, 0x91 },
	0xB293,	{ 0xE7, 0x9F, 0x92 },
	0xB294,	{ 0xE7, 0x9F, 0x93 },
	0xB295,	{ 0xE7, 0x9F, 0x94 },
	0xB296,	{ 0xE7, 0x9F, 0x95 },
	0xB297,	{ 0xE7, 0x9F, 0x96 },
	0xB298,	{ 0xE7, 0x9F, 0x98 },
	0xB299,	{ 0xE7, 0x9F, 0x99 },
	0xB29A,	{ 0xE7, 0x9F, 0x9A },
	0xB29B,	{ 0xE7, 0x9F, 0x9D },
	0xB29C,	{ 0xE7, 0x9F, 0x9E },
	0xB29D,	{ 0xE7, 0x9F, 0x9F },
	0xB29E,	{ 0xE7, 0x9F, 0xA0 },
	0xB29F,	{ 0xE7, 0x9F, 0xA1 },
	0xB2A0,	{ 0xE7, 0x9F, 0xA4 },
	0xB2A1,	{ 0xE7, 0x97, 0x85 },
	0xB2A2,	{ 0xE5, 0xB9, 0xB6 },
	0xB2A3,	{ 0xE7, 0x8E, 0xBB },
	0xB2A4,	{ 0xE8, 0x8F, 0xA0 },
	0xB2A5,	{ 0xE6, 0x92, 0xAD },
	0xB2A6,	{ 0xE6, 0x8B, 0xA8 },
	0xB2A7,	{ 0xE9, 0x92, 0xB5 },
	0xB2A8,	{ 0xE6, 0xB3, 0xA2 },
	0xB2A9,	{ 0xE5, 0x8D, 0x9A },
	0xB2AA,	{ 0xE5, 0x8B, 0x83 },
	0xB2AB,	{ 0xE6, 0x90, 0x8F },
	0xB2AC,	{ 0xE9, 0x93, 0x82 },
	0xB2AD,	{ 0xE7, 0xAE, 0x94 },
	0xB2AE,	{ 0xE4, 0xBC, 0xAF },
	0xB2AF,	{ 0xE5, 0xB8, 0x9B },
	0xB2B0,	{ 0xE8, 0x88, 0xB6 },
	0xB2B1,	{ 0xE8, 0x84, 0x96 },
	0xB2B2,	{ 0xE8, 0x86, 0x8A },
	0xB2B3,	{ 0xE6, 0xB8, 0xA4 },
	0xB2B4,	{ 0xE6, 0xB3, 0x8A },
	0xB2B5,	{ 0xE9, 0xA9, 0xB3 },
	0xB2B6,	{ 0xE6, 0x8D, 0x95 },
	0xB2B7,	{ 0xE5, 0x8D, 0x9C },
	0xB2B8,	{ 0xE5, 0x93, 0xBA },
	0xB2B9,	{ 0xE8, 0xA1, 0xA5 },
	0xB2BA,	{ 0xE5, 0x9F, 0xA0 },
	0xB2BB,	{ 0xE4, 0xB8, 0x8D },
	0xB2BC,	{ 0xE5, 0xB8, 0x83 },
	0xB2BD,	{ 0xE6, 0xAD, 0xA5 },
	0xB2BE,	{ 0xE7, 0xB0, 0xBF },
	0xB2BF,	{ 0xE9, 0x83, 0xA8 },
	0xB2C0,	{ 0xE6, 0x80, 0x96 },
	0xB2C1,	{ 0xE6, 0x93, 0xA6 },
	0xB2C2,	{ 0xE7, 0x8C, 0x9C },
	0xB2C3,	{ 0xE8, 0xA3, 0x81 },
	0xB2C4,	{ 0xE6, 0x9D, 0x90 },
	0xB2C5,	{ 0xE6, 0x89, 0x8D },
	0xB2C6,	{ 0xE8, 0xB4, 0xA2 },
	0xB2C7,	{ 0xE7, 0x9D, 0xAC },
	0xB2C8,	{ 0xE8, 0xB8, 0xA9 },
	0xB2C9,	{ 0xE9, 0x87, 0x87 },
	0xB2CA,	{ 0xE5, 0xBD, 0xA9 },
	0xB2CB,	{ 0xE8, 0x8F, 0x9C },
	0xB2CC,	{ 0xE8, 0x94, 0xA1 },
	0xB2CD,	{ 0xE9, 0xA4, 0x90 },
	0xB2CE,	{ 0xE5, 0x8F, 0x82 },
	0xB2CF,	{ 0xE8, 0x9A, 0x95 },
	0xB2D0,	{ 0xE6, 0xAE, 0x8B },
	0xB2D1,	{ 0xE6, 0x83, 0xAD },
	0xB2D2,	{ 0xE6, 0x83, 0xA8 },
	0xB2D3,	{ 0xE7, 0x81, 0xBF },
	0xB2D4,	{ 0xE8, 0x8B, 0x8D },
	0xB2D5,	{ 0xE8, 0x88, 0xB1 },
	0xB2D6,	{ 0xE4, 0xBB, 0x93 },
	0xB2D7,	{ 0xE6, 0xB2, 0xA7 },
	0xB2D8,	{ 0xE8, 0x97, 0x8F },
	0xB2D9,	{ 0xE6, 0x93, 0x8D },
	0xB2DA,	{ 0xE7, 0xB3, 0x99 },
	0xB2DB,	{ 0xE6, 0xA7, 0xBD },
	0xB2DC,	{ 0xE6, 0x9B, 0xB9 },
	0xB2DD,	{ 0xE8, 0x8D, 0x89 },
	0xB2DE,	{ 0xE5, 0x8E, 0x95 },
	0xB2DF,	{ 0xE7, 0xAD, 0x96 },
	0xB2E0,	{ 0xE4, 0xBE, 0xA7 },
	0xB2E1,	{ 0xE5, 0x86, 0x8C },
	0xB2E2,	{ 0xE6, 0xB5, 0x8B },
	0xB2E3,	{ 0xE5, 0xB1, 0x82 },
	0xB2E4,	{ 0xE8, 0xB9, 0xAD },
	0xB2E5,	{ 0xE6, 0x8F, 0x92 },
	0xB2E6,	{ 0xE5, 0x8F, 0x89 },
	0xB2E7,	{ 0xE8, 0x8C, 0xAC },
	0xB2E8,	{ 0xE8, 0x8C, 0xB6 },
	0xB2E9,	{ 0xE6, 0x9F, 0xA5 },
	0xB2EA,	{ 0xE7, 0xA2, 0xB4 },
	0xB2EB,	{ 0xE6, 0x90, 0xBD },
	0xB2EC,	{ 0xE5, 0xAF, 0x9F },
	0xB2ED,	{ 0xE5, 0xB2, 0x94 },
	0xB2EE,	{ 0xE5, 0xB7, 0xAE },
	0xB2EF,	{ 0xE8, 0xAF, 0xA7 },
	0xB2F0,	{ 0xE6, 0x8B, 0x86 },
	0xB2F1,	{ 0xE6, 0x9F, 0xB4 },
	0xB2F2,	{ 0xE8, 0xB1, 0xBA },
	0xB2F3,	{ 0xE6, 0x90, 0x80 },
	0xB2F4,	{ 0xE6, 0x8E, 0xBA },
	0xB2F5,	{ 0xE8, 0x9D, 0x89 },
	0xB2F6,	{ 0xE9, 0xA6, 0x8B },
	0xB2F7,	{ 0xE8, 0xB0, 0x97 },
	0xB2F8,	{ 0xE7, 0xBC, 0xA0 },
	0xB2F9,	{ 0xE9, 0x93, 0xB2 },
	0xB2FA,	{ 0xE4, 0xBA, 0xA7 },
	0xB2FB,	{ 0xE9, 0x98, 0x90 },
	0xB2FC,	{ 0xE9, 0xA2, 0xA4 },
	0xB2FD,	{ 0xE6, 0x98, 0x8C },
	0xB2FE,	{ 0xE7, 0x8C, 0x96 },
	0xB340,	{ 0xE7, 0x9F, 0xA6 },
	0xB341,	{ 0xE7, 0x9F, 0xA8 },
	0xB342,	{ 0xE7, 0x9F, 0xAA },
	0xB343,	{ 0xE7, 0x9F, 0xAF },
	0xB344,	{ 0xE7, 0x9F, 0xB0 },
	0xB345,	{ 0xE7, 0x9F, 0xB1 },
	0xB346,	{ 0xE7, 0x9F, 0xB2 },
	0xB347,	{ 0xE7, 0x9F, 0xB4 },
	0xB348,	{ 0xE7, 0x9F, 0xB5 },
	0xB349,	{ 0xE7, 0x9F, 0xB7 },
	0xB34A,	{ 0xE7, 0x9F, 0xB9 },
	0xB34B,	{ 0xE7, 0x9F, 0xBA },
	0xB34C,	{ 0xE7, 0x9F, 0xBB },
	0xB34D,	{ 0xE7, 0x9F, 0xBC },
	0xB34E,	{ 0xE7, 0xA0, 0x83 },
	0xB34F,	{ 0xE7, 0xA0, 0x84 },
	0xB350,	{ 0xE7, 0xA0, 0x85 },
	0xB351,	{ 0xE7, 0xA0, 0x86 },
	0xB352,	{ 0xE7, 0xA0, 0x87 },
	0xB353,	{ 0xE7, 0xA0, 0x88 },
	0xB354,	{ 0xE7, 0xA0, 0x8A },
	0xB355,	{ 0xE7, 0xA0, 0x8B },
	0xB356,	{ 0xE7, 0xA0, 0x8E },
	0xB357,	{ 0xE7, 0xA0, 0x8F },
	0xB358,	{ 0xE7, 0xA0, 0x90 },
	0xB359,	{ 0xE7, 0xA0, 0x93 },
	0xB35A,	{ 0xE7, 0xA0, 0x95 },
	0xB35B,	{ 0xE7, 0xA0, 0x99 },
	0xB35C,	{ 0xE7, 0xA0, 0x9B },
	0xB35D,	{ 0xE7, 0xA0, 0x9E },
	0xB35E,	{ 0xE7, 0xA0, 0xA0 },
	0xB35F,	{ 0xE7, 0xA0, 0xA1 },
	0xB360,	{ 0xE7, 0xA0, 0xA2 },
	0xB361,	{ 0xE7, 0xA0, 0xA4 },
	0xB362,	{ 0xE7, 0xA0, 0xA8 },
	0xB363,	{ 0xE7, 0xA0, 0xAA },
	0xB364,	{ 0xE7, 0xA0, 0xAB },
	0xB365,	{ 0xE7, 0xA0, 0xAE },
	0xB366,	{ 0xE7, 0xA0, 0xAF },
	0xB367,	{ 0xE7, 0xA0, 0xB1 },
	0xB368,	{ 0xE7, 0xA0, 0xB2 },
	0xB369,	{ 0xE7, 0xA0, 0xB3 },
	0xB36A,	{ 0xE7, 0xA0, 0xB5 },
	0xB36B,	{ 0xE7, 0xA0, 0xB6 },
	0xB36C,	{ 0xE7, 0xA0, 0xBD },
	0xB36D,	{ 0xE7, 0xA0, 0xBF },
	0xB36E,	{ 0xE7, 0xA1, 0x81 },
	0xB36F,	{ 0xE7, 0xA1, 0x82 },
	0xB370,	{ 0xE7, 0xA1, 0x83 },
	0xB371,	{ 0xE7, 0xA1, 0x84 },
	0xB372,	{ 0xE7, 0xA1, 0x86 },
	0xB373,	{ 0xE7, 0xA1, 0x88 },
	0xB374,	{ 0xE7, 0xA1, 0x89 },
	0xB375,	{ 0xE7, 0xA1, 0x8A },
	0xB376,	{ 0xE7, 0xA1, 0x8B },
	0xB377,	{ 0xE7, 0xA1, 0x8D },
	0xB378,	{ 0xE7, 0xA1, 0x8F },
	0xB379,	{ 0xE7, 0xA1, 0x91 },
	0xB37A,	{ 0xE7, 0xA1, 0x93 },
	0xB37B,	{ 0xE7, 0xA1, 0x94 },
	0xB37C,	{ 0xE7, 0xA1, 0x98 },
	0xB37D,	{ 0xE7, 0xA1, 0x99 },
	0xB37E,	{ 0xE7, 0xA1, 0x9A },
	0xB380,	{ 0xE7, 0xA1, 0x9B },
	0xB381,	{ 0xE7, 0xA1, 0x9C },
	0xB382,	{ 0xE7, 0xA1, 0x9E },
	0xB383,	{ 0xE7, 0xA1, 0x9F },
	0xB384,	{ 0xE7, 0xA1, 0xA0 },
	0xB385,	{ 0xE7, 0xA1, 0xA1 },
	0xB386,	{ 0xE7, 0xA1, 0xA2 },
	0xB387,	{ 0xE7, 0xA1, 0xA3 },
	0xB388,	{ 0xE7, 0xA1, 0xA4 },
	0xB389,	{ 0xE7, 0xA1, 0xA5 },
	0xB38A,	{ 0xE7, 0xA1, 0xA6 },
	0xB38B,	{ 0xE7, 0xA1, 0xA7 },
	0xB38C,	{ 0xE7, 0xA1, 0xA8 },
	0xB38D,	{ 0xE7, 0xA1, 0xA9 },
	0xB38E,	{ 0xE7, 0xA1, 0xAF },
	0xB38F,	{ 0xE7, 0xA1, 0xB0 },
	0xB390,	{ 0xE7, 0xA1, 0xB1 },
	0xB391,	{ 0xE7, 0xA1, 0xB2 },
	0xB392,	{ 0xE7, 0xA1, 0xB3 },
	0xB393,	{ 0xE7, 0xA1, 0xB4 },
	0xB394,	{ 0xE7, 0xA1, 0xB5 },
	0xB395,	{ 0xE7, 0xA1, 0xB6 },
	0xB396,	{ 0xE7, 0xA1, 0xB8 },
	0xB397,	{ 0xE7, 0xA1, 0xB9 },
	0xB398,	{ 0xE7, 0xA1, 0xBA },
	0xB399,	{ 0xE7, 0xA1, 0xBB },
	0xB39A,	{ 0xE7, 0xA1, 0xBD },
	0xB39B,	{ 0xE7, 0xA1, 0xBE },
	0xB39C,	{ 0xE7, 0xA1, 0xBF },
	0xB39D,	{ 0xE7, 0xA2, 0x80 },
	0xB39E,	{ 0xE7, 0xA2, 0x81 },
	0xB39F,	{ 0xE7, 0xA2, 0x82 },
	0xB3A0,	{ 0xE7, 0xA2, 0x83 },
	0xB3A1,	{ 0xE5, 0x9C, 0xBA },
	0xB3A2,	{ 0xE5, 0xB0, 0x9D },
	0xB3A3,	{ 0xE5, 0xB8, 0xB8 },
	0xB3A4,	{ 0xE9, 0x95, 0xBF },
	0xB3A5,	{ 0xE5, 0x81, 0xBF },
	0xB3A6,	{ 0xE8, 0x82, 0xA0 },
	0xB3A7,	{ 0xE5, 0x8E, 0x82 },
	0xB3A8,	{ 0xE6, 0x95, 0x9E },
	0xB3A9,	{ 0xE7, 0x95, 0x85 },
	0xB3AA,	{ 0xE5, 0x94, 0xB1 },
	0xB3AB,	{ 0xE5, 0x80, 0xA1 },
	0xB3AC,	{ 0xE8, 0xB6, 0x85 },
	0xB3AD,	{ 0xE6, 0x8A, 0x84 },
	0xB3AE,	{ 0xE9, 0x92, 0x9E },
	0xB3AF,	{ 0xE6, 0x9C, 0x9D },
	0xB3B0,	{ 0xE5, 0x98, 0xB2 },
	0xB3B1,	{ 0xE6, 0xBD, 0xAE },
	0xB3B2,	{ 0xE5, 0xB7, 0xA2 },
	0xB3B3,	{ 0xE5, 0x90, 0xB5 },
	0xB3B4,	{ 0xE7, 0x82, 0x92 },
	0xB3B5,	{ 0xE8, 0xBD, 0xA6 },
	0xB3B6,	{ 0xE6, 0x89, 0xAF },
	0xB3B7,	{ 0xE6, 0x92, 0xA4 },
	0xB3B8,	{ 0xE6, 0x8E, 0xA3 },
	0xB3B9,	{ 0xE5, 0xBD, 0xBB },
	0xB3BA,	{ 0xE6, 0xBE, 0x88 },
	0xB3BB,	{ 0xE9, 0x83, 0xB4 },
	0xB3BC,	{ 0xE8, 0x87, 0xA3 },
	0xB3BD,	{ 0xE8, 0xBE, 0xB0 },
	0xB3BE,	{ 0xE5, 0xB0, 0x98 },
	0xB3BF,	{ 0xE6, 0x99, 0xA8 },
	0xB3C0,	{ 0xE5, 0xBF, 0xB1 },
	0xB3C1,	{ 0xE6, 0xB2, 0x89 },
	0xB3C2,	{ 0xE9, 0x99, 0x88 },
	0xB3C3,	{ 0xE8, 0xB6, 0x81 },
	0xB3C4,	{ 0xE8, 0xA1, 0xAC },
	0xB3C5,	{ 0xE6, 0x92, 0x91 },
	0xB3C6,	{ 0xE7, 0xA7, 0xB0 },
	0xB3C7,	{ 0xE5, 0x9F, 0x8E },
	0xB3C8,	{ 0xE6, 0xA9, 0x99 },
	0xB3C9,	{ 0xE6, 0x88, 0x90 },
	0xB3CA,	{ 0xE5, 0x91, 0x88 },
	0xB3CB,	{ 0xE4, 0xB9, 0x98 },
	0xB3CC,	{ 0xE7, 0xA8, 0x8B },
	0xB3CD,	{ 0xE6, 0x83, 0xA9 },
	0xB3CE,	{ 0xE6, 0xBE, 0x84 },
	0xB3CF,	{ 0xE8, 0xAF, 0x9A },
	0xB3D0,	{ 0xE6, 0x89, 0xBF },
	0xB3D1,	{ 0xE9, 0x80, 0x9E },
	0xB3D2,	{ 0xE9, 0xAA, 0x8B },
	0xB3D3,	{ 0xE7, 0xA7, 0xA4 },
	0xB3D4,	{ 0xE5, 0x90, 0x83 },
	0xB3D5,	{ 0xE7, 0x97, 0xB4 },
	0xB3D6,	{ 0xE6, 0x8C, 0x81 },
	0xB3D7,	{ 0xE5, 0x8C, 0x99 },
	0xB3D8,	{ 0xE6, 0xB1, 0xA0 },
	0xB3D9,	{ 0xE8, 0xBF, 0x9F },
	0xB3DA,	{ 0xE5, 0xBC, 0x9B },
	0xB3DB,	{ 0xE9, 0xA9, 0xB0 },
	0xB3DC,	{ 0xE8, 0x80, 0xBB },
	0xB3DD,	{ 0xE9, 0xBD, 0xBF },
	0xB3DE,	{ 0xE4, 0xBE, 0x88 },
	0xB3DF,	{ 0xE5, 0xB0, 0xBA },
	0xB3E0,	{ 0xE8, 0xB5, 0xA4 },
	0xB3E1,	{ 0xE7, 0xBF, 0x85 },
	0xB3E2,	{ 0xE6, 0x96, 0xA5 },
	0xB3E3,	{ 0xE7, 0x82, 0xBD },
	0xB3E4,	{ 0xE5, 0x85, 0x85 },
	0xB3E5,	{ 0xE5, 0x86, 0xB2 },
	0xB3E6,	{ 0xE8, 0x99, 0xAB },
	0xB3E7,	{ 0xE5, 0xB4, 0x87 },
	0xB3E8,	{ 0xE5, 0xAE, 0xA0 },
	0xB3E9,	{ 0xE6, 0x8A, 0xBD },
	0xB3EA,	{ 0xE9, 0x85, 0xAC },
	0xB3EB,	{ 0xE7, 0x95, 0xB4 },
	0xB3EC,	{ 0xE8, 0xB8, 0x8C },
	0xB3ED,	{ 0xE7, 0xA8, 0xA0 },
	0xB3EE,	{ 0xE6, 0x84, 0x81 },
	0xB3EF,	{ 0xE7, 0xAD, 0xB9 },
	0xB3F0,	{ 0xE4, 0xBB, 0x87 },
	0xB3F1,	{ 0xE7, 0xBB, 0xB8 },
	0xB3F2,	{ 0xE7, 0x9E, 0x85 },
	0xB3F3,	{ 0xE4, 0xB8, 0x91 },
	0xB3F4,	{ 0xE8, 0x87, 0xAD },
	0xB3F5,	{ 0xE5, 0x88, 0x9D },
	0xB3F6,	{ 0xE5, 0x87, 0xBA },
	0xB3F7,	{ 0xE6, 0xA9, 0xB1 },
	0xB3F8,	{ 0xE5, 0x8E, 0xA8 },
	0xB3F9,	{ 0xE8, 0xBA, 0x87 },
	0xB3FA,	{ 0xE9, 0x94, 0x84 },
	0xB3FB,	{ 0xE9, 0x9B, 0x8F },
	0xB3FC,	{ 0xE6, 0xBB, 0x81 },
	0xB3FD,	{ 0xE9, 0x99, 0xA4 },
	0xB3FE,	{ 0xE6, 0xA5, 0x9A },
	0xB440,	{ 0xE7, 0xA2, 0x84 },
	0xB441,	{ 0xE7, 0xA2, 0x85 },
	0xB442,	{ 0xE7, 0xA2, 0x86 },
	0xB443,	{ 0xE7, 0xA2, 0x88 },
	0xB444,	{ 0xE7, 0xA2, 0x8A },
	0xB445,	{ 0xE7, 0xA2, 0x8B },
	0xB446,	{ 0xE7, 0xA2, 0x8F },
	0xB447,	{ 0xE7, 0xA2, 0x90 },
	0xB448,	{ 0xE7, 0xA2, 0x92 },
	0xB449,	{ 0xE7, 0xA2, 0x94 },
	0xB44A,	{ 0xE7, 0xA2, 0x95 },
	0xB44B,	{ 0xE7, 0xA2, 0x96 },
	0xB44C,	{ 0xE7, 0xA2, 0x99 },
	0xB44D,	{ 0xE7, 0xA2, 0x9D },
	0xB44E,	{ 0xE7, 0xA2, 0x9E },
	0xB44F,	{ 0xE7, 0xA2, 0xA0 },
	0xB450,	{ 0xE7, 0xA2, 0xA2 },
	0xB451,	{ 0xE7, 0xA2, 0xA4 },
	0xB452,	{ 0xE7, 0xA2, 0xA6 },
	0xB453,	{ 0xE7, 0xA2, 0xA8 },
	0xB454,	{ 0xE7, 0xA2, 0xA9 },
	0xB455,	{ 0xE7, 0xA2, 0xAA },
	0xB456,	{ 0xE7, 0xA2, 0xAB },
	0xB457,	{ 0xE7, 0xA2, 0xAC },
	0xB458,	{ 0xE7, 0xA2, 0xAD },
	0xB459,	{ 0xE7, 0xA2, 0xAE },
	0xB45A,	{ 0xE7, 0xA2, 0xAF },
	0xB45B,	{ 0xE7, 0xA2, 0xB5 },
	0xB45C,	{ 0xE7, 0xA2, 0xB6 },
	0xB45D,	{ 0xE7, 0xA2, 0xB7 },
	0xB45E,	{ 0xE7, 0xA2, 0xB8 },
	0xB45F,	{ 0xE7, 0xA2, 0xBA },
	0xB460,	{ 0xE7, 0xA2, 0xBB },
	0xB461,	{ 0xE7, 0xA2, 0xBC },
	0xB462,	{ 0xE7, 0xA2, 0xBD },
	0xB463,	{ 0xE7, 0xA2, 0xBF },
	0xB464,	{ 0xE7, 0xA3, 0x80 },
	0xB465,	{ 0xE7, 0xA3, 0x82 },
	0xB466,	{ 0xE7, 0xA3, 0x83 },
	0xB467,	{ 0xE7, 0xA3, 0x84 },
	0xB468,	{ 0xE7, 0xA3, 0x86 },
	0xB469,	{ 0xE7, 0xA3, 0x87 },
	0xB46A,	{ 0xE7, 0xA3, 0x88 },
	0xB46B,	{ 0xE7, 0xA3, 0x8C },
	0xB46C,	{ 0xE7, 0xA3, 0x8D },
	0xB46D,	{ 0xE7, 0xA3, 0x8E },
	0xB46E,	{ 0xE7, 0xA3, 0x8F },
	0xB46F,	{ 0xE7, 0xA3, 0x91 },
	0xB470,	{ 0xE7, 0xA3, 0x92 },
	0xB471,	{ 0xE7, 0xA3, 0x93 },
	0xB472,	{ 0xE7, 0xA3, 0x96 },
	0xB473,	{ 0xE7, 0xA3, 0x97 },
	0xB474,	{ 0xE7, 0xA3, 0x98 },
	0xB475,	{ 0xE7, 0xA3, 0x9A },
	0xB476,	{ 0xE7, 0xA3, 0x9B },
	0xB477,	{ 0xE7, 0xA3, 0x9C },
	0xB478,	{ 0xE7, 0xA3, 0x9D },
	0xB479,	{ 0xE7, 0xA3, 0x9E },
	0xB47A,	{ 0xE7, 0xA3, 0x9F },
	0xB47B,	{ 0xE7, 0xA3, 0xA0 },
	0xB47C,	{ 0xE7, 0xA3, 0xA1 },
	0xB47D,	{ 0xE7, 0xA3, 0xA2 },
	0xB47E,	{ 0xE7, 0xA3, 0xA3 },
	0xB480,	{ 0xE7, 0xA3, 0xA4 },
	0xB481,	{ 0xE7, 0xA3, 0xA5 },
	0xB482,	{ 0xE7, 0xA3, 0xA6 },
	0xB483,	{ 0xE7, 0xA3, 0xA7 },
	0xB484,	{ 0xE7, 0xA3, 0xA9 },
	0xB485,	{ 0xE7, 0xA3, 0xAA },
	0xB486,	{ 0xE7, 0xA3, 0xAB },
	0xB487,	{ 0xE7, 0xA3, 0xAD },
	0xB488,	{ 0xE7, 0xA3, 0xAE },
	0xB489,	{ 0xE7, 0xA3, 0xAF },
	0xB48A,	{ 0xE7, 0xA3, 0xB0 },
	0xB48B,	{ 0xE7, 0xA3, 0xB1 },
	0xB48C,	{ 0xE7, 0xA3, 0xB3 },
	0xB48D,	{ 0xE7, 0xA3, 0xB5 },
	0xB48E,	{ 0xE7, 0xA3, 0xB6 },
	0xB48F,	{ 0xE7, 0xA3, 0xB8 },
	0xB490,	{ 0xE7, 0xA3, 0xB9 },
	0xB491,	{ 0xE7, 0xA3, 0xBB },
	0xB492,	{ 0xE7, 0xA3, 0xBC },
	0xB493,	{ 0xE7, 0xA3, 0xBD },
	0xB494,	{ 0xE7, 0xA3, 0xBE },
	0xB495,	{ 0xE7, 0xA3, 0xBF },
	0xB496,	{ 0xE7, 0xA4, 0x80 },
	0xB497,	{ 0xE7, 0xA4, 0x82 },
	0xB498,	{ 0xE7, 0xA4, 0x83 },
	0xB499,	{ 0xE7, 0xA4, 0x84 },
	0xB49A,	{ 0xE7, 0xA4, 0x86 },
	0xB49B,	{ 0xE7, 0xA4, 0x87 },
	0xB49C,	{ 0xE7, 0xA4, 0x88 },
	0xB49D,	{ 0xE7, 0xA4, 0x89 },
	0xB49E,	{ 0xE7, 0xA4, 0x8A },
	0xB49F,	{ 0xE7, 0xA4, 0x8B },
	0xB4A0,	{ 0xE7, 0xA4, 0x8C },
	0xB4A1,	{ 0xE7, 0xA1, 0x80 },
	0xB4A2,	{ 0xE5, 0x82, 0xA8 },
	0xB4A3,	{ 0xE7, 0x9F, 0x97 },
	0xB4A4,	{ 0xE6, 0x90, 0x90 },
	0xB4A5,	{ 0xE8, 0xA7, 0xA6 },
	0xB4A6,	{ 0xE5, 0xA4, 0x84 },
	0xB4A7,	{ 0xE6, 0x8F, 0xA3 },
	0xB4A8,	{ 0xE5, 0xB7, 0x9D },
	0xB4A9,	{ 0xE7, 0xA9, 0xBF },
	0xB4AA,	{ 0xE6, 0xA4, 0xBD },
	0xB4AB,	{ 0xE4, 0xBC, 0xA0 },
	0xB4AC,	{ 0xE8, 0x88, 0xB9 },
	0xB4AD,	{ 0xE5, 0x96, 0x98 },
	0xB4AE,	{ 0xE4, 0xB8, 0xB2 },
	0xB4AF,	{ 0xE7, 0x96, 0xAE },
	0xB4B0,	{ 0xE7, 0xAA, 0x97 },
	0xB4B1,	{ 0xE5, 0xB9, 0xA2 },
	0xB4B2,	{ 0xE5, 0xBA, 0x8A },
	0xB4B3,	{ 0xE9, 0x97, 0xAF },
	0xB4B4,	{ 0xE5, 0x88, 0x9B },
	0xB4B5,	{ 0xE5, 0x90, 0xB9 },
	0xB4B6,	{ 0xE7, 0x82, 0x8A },
	0xB4B7,	{ 0xE6, 0x8D, 0xB6 },
	0xB4B8,	{ 0xE9, 0x94, 0xA4 },
	0xB4B9,	{ 0xE5, 0x9E, 0x82 },
	0xB4BA,	{ 0xE6, 0x98, 0xA5 },
	0xB4BB,	{ 0xE6, 0xA4, 0xBF },
	0xB4BC,	{ 0xE9, 0x86, 0x87 },
	0xB4BD,	{ 0xE5, 0x94, 0x87 },
	0xB4BE,	{ 0xE6, 0xB7, 0xB3 },
	0xB4BF,	{ 0xE7, 0xBA, 0xAF },
	0xB4C0,	{ 0xE8, 0xA0, 0xA2 },
	0xB4C1,	{ 0xE6, 0x88, 0xB3 },
	0xB4C2,	{ 0xE7, 0xBB, 0xB0 },
	0xB4C3,	{ 0xE7, 0x96, 0xB5 },
	0xB4C4,	{ 0xE8, 0x8C, 0xA8 },
	0xB4C5,	{ 0xE7, 0xA3, 0x81 },
	0xB4C6,	{ 0xE9, 0x9B, 0x8C },
	0xB4C7,	{ 0xE8, 0xBE, 0x9E },
	0xB4C8,	{ 0xE6, 0x85, 0x88 },
	0xB4C9,	{ 0xE7, 0x93, 0xB7 },
	0xB4CA,	{ 0xE8, 0xAF, 0x8D },
	0xB4CB,	{ 0xE6, 0xAD, 0xA4 },
	0xB4CC,	{ 0xE5, 0x88, 0xBA },
	0xB4CD,	{ 0xE8, 0xB5, 0x90 },
	0xB4CE,	{ 0xE6, 0xAC, 0xA1 },
	0xB4CF,	{ 0xE8, 0x81, 0xAA },
	0xB4D0,	{ 0xE8, 0x91, 0xB1 },
	0xB4D1,	{ 0xE5, 0x9B, 0xB1 },
	0xB4D2,	{ 0xE5, 0x8C, 0x86 },
	0xB4D3,	{ 0xE4, 0xBB, 0x8E },
	0xB4D4,	{ 0xE4, 0xB8, 0x9B },
	0xB4D5,	{ 0xE5, 0x87, 0x91 },
	0xB4D6,	{ 0xE7, 0xB2, 0x97 },
	0xB4D7,	{ 0xE9, 0x86, 0x8B },
	0xB4D8,	{ 0xE7, 0xB0, 0x87 },
	0xB4D9,	{ 0xE4, 0xBF, 0x83 },
	0xB4DA,	{ 0xE8, 0xB9, 0xBF },
	0xB4DB,	{ 0xE7, 0xAF, 0xA1 },
	0xB4DC,	{ 0xE7, 0xAA, 0x9C },
	0xB4DD,	{ 0xE6, 0x91, 0xA7 },
	0xB4DE,	{ 0xE5, 0xB4, 0x94 },
	0xB4DF,	{ 0xE5, 0x82, 0xAC },
	0xB4E0,	{ 0xE8, 0x84, 0x86 },
	0xB4E1,	{ 0xE7, 0x98, 0x81 },
	0xB4E2,	{ 0xE7, 0xB2, 0xB9 },
	0xB4E3,	{ 0xE6, 0xB7, 0xAC },
	0xB4E4,	{ 0xE7, 0xBF, 0xA0 },
	0xB4E5,	{ 0xE6, 0x9D, 0x91 },
	0xB4E6,	{ 0xE5, 0xAD, 0x98 },
	0xB4E7,	{ 0xE5, 0xAF, 0xB8 },
	0xB4E8,	{ 0xE7, 0xA3, 0x8B },
	0xB4E9,	{ 0xE6, 0x92, 0xAE },
	0xB4EA,	{ 0xE6, 0x90, 0x93 },
	0xB4EB,	{ 0xE6, 0x8E, 0xAA },
	0xB4EC,	{ 0xE6, 0x8C, 0xAB },
	0xB4ED,	{ 0xE9, 0x94, 0x99 },
	0xB4EE,	{ 0xE6, 0x90, 0xAD },
	0xB4EF,	{ 0xE8, 0xBE, 0xBE },
	0xB4F0,	{ 0xE7, 0xAD, 0x94 },
	0xB4F1,	{ 0xE7, 0x98, 0xA9 },
	0xB4F2,	{ 0xE6, 0x89, 0x93 },
	0xB4F3,	{ 0xE5, 0xA4, 0xA7 },
	0xB4F4,	{ 0xE5, 0x91, 0x86 },
	0xB4F5,	{ 0xE6, 0xAD, 0xB9 },
	0xB4F6,	{ 0xE5, 0x82, 0xA3 },
	0xB4F7,	{ 0xE6, 0x88, 0xB4 },
	0xB4F8,	{ 0xE5, 0xB8, 0xA6 },
	0xB4F9,	{ 0xE6, 0xAE, 0x86 },
	0xB4FA,	{ 0xE4, 0xBB, 0xA3 },
	0xB4FB,	{ 0xE8, 0xB4, 0xB7 },
	0xB4FC,	{ 0xE8, 0xA2, 0x8B },
	0xB4FD,	{ 0xE5, 0xBE, 0x85 },
	0xB4FE,	{ 0xE9, 0x80, 0xAE },
	0xB540,	{ 0xE7, 0xA4, 0x8D },
	0xB541,	{ 0xE7, 0xA4, 0x8E },
	0xB542,	{ 0xE7, 0xA4, 0x8F },
	0xB543,	{ 0xE7, 0xA4, 0x90 },
	0xB544,	{ 0xE7, 0xA4, 0x91 },
	0xB545,	{ 0xE7, 0xA4, 0x92 },
	0xB546,	{ 0xE7, 0xA4, 0x94 },
	0xB547,	{ 0xE7, 0xA4, 0x95 },
	0xB548,	{ 0xE7, 0xA4, 0x96 },
	0xB549,	{ 0xE7, 0xA4, 0x97 },
	0xB54A,	{ 0xE7, 0xA4, 0x98 },
	0xB54B,	{ 0xE7, 0xA4, 0x99 },
	0xB54C,	{ 0xE7, 0xA4, 0x9A },
	0xB54D,	{ 0xE7, 0xA4, 0x9B },
	0xB54E,	{ 0xE7, 0xA4, 0x9C },
	0xB54F,	{ 0xE7, 0xA4, 0x9D },
	0xB550,	{ 0xE7, 0xA4, 0x9F },
	0xB551,	{ 0xE7, 0xA4, 0xA0 },
	0xB552,	{ 0xE7, 0xA4, 0xA1 },
	0xB553,	{ 0xE7, 0xA4, 0xA2 },
	0xB554,	{ 0xE7, 0xA4, 0xA3 },
	0xB555,	{ 0xE7, 0xA4, 0xA5 },
	0xB556,	{ 0xE7, 0xA4, 0xA6 },
	0xB557,	{ 0xE7, 0xA4, 0xA7 },
	0xB558,	{ 0xE7, 0xA4, 0xA8 },
	0xB559,	{ 0xE7, 0xA4, 0xA9 },
	0xB55A,	{ 0xE7, 0xA4, 0xAA },
	0xB55B,	{ 0xE7, 0xA4, 0xAB },
	0xB55C,	{ 0xE7, 0xA4, 0xAC },
	0xB55D,	{ 0xE7, 0xA4, 0xAD },
	0xB55E,	{ 0xE7, 0xA4, 0xAE },
	0xB55F,	{ 0xE7, 0xA4, 0xAF },
	0xB560,	{ 0xE7, 0xA4, 0xB0 },
	0xB561,	{ 0xE7, 0xA4, 0xB1 },
	0xB562,	{ 0xE7, 0xA4, 0xB2 },
	0xB563,	{ 0xE7, 0xA4, 0xB3 },
	0xB564,	{ 0xE7, 0xA4, 0xB5 },
	0xB565,	{ 0xE7, 0xA4, 0xB6 },
	0xB566,	{ 0xE7, 0xA4, 0xB7 },
	0xB567,	{ 0xE7, 0xA4, 0xB8 },
	0xB568,	{ 0xE7, 0xA4, 0xB9 },
	0xB569,	{ 0xE7, 0xA4, 0xBD },
	0xB56A,	{ 0xE7, 0xA4, 0xBF },
	0xB56B,	{ 0xE7, 0xA5, 0x82 },
	0xB56C,	{ 0xE7, 0xA5, 0x83 },
	0xB56D,	{ 0xE7, 0xA5, 0x84 },
	0xB56E,	{ 0xE7, 0xA5, 0x85 },
	0xB56F,	{ 0xE7, 0xA5, 0x87 },
	0xB570,	{ 0xE7, 0xA5, 0x8A },
	0xB571,	{ 0xE7, 0xA5, 0x8B },
	0xB572,	{ 0xE7, 0xA5, 0x8C },
	0xB573,	{ 0xE7, 0xA5, 0x8D },
	0xB574,	{ 0xE7, 0xA5, 0x8E },
	0xB575,	{ 0xE7, 0xA5, 0x8F },
	0xB576,	{ 0xE7, 0xA5, 0x90 },
	0xB577,	{ 0xE7, 0xA5, 0x91 },
	0xB578,	{ 0xE7, 0xA5, 0x92 },
	0xB579,	{ 0xE7, 0xA5, 0x94 },
	0xB57A,	{ 0xE7, 0xA5, 0x95 },
	0xB57B,	{ 0xE7, 0xA5, 0x98 },
	0xB57C,	{ 0xE7, 0xA5, 0x99 },
	0xB57D,	{ 0xE7, 0xA5, 0xA1 },
	0xB57E,	{ 0xE7, 0xA5, 0xA3 },
	0xB580,	{ 0xE7, 0xA5, 0xA4 },
	0xB581,	{ 0xE7, 0xA5, 0xA6 },
	0xB582,	{ 0xE7, 0xA5, 0xA9 },
	0xB583,	{ 0xE7, 0xA5, 0xAA },
	0xB584,	{ 0xE7, 0xA5, 0xAB },
	0xB585,	{ 0xE7, 0xA5, 0xAC },
	0xB586,	{ 0xE7, 0xA5, 0xAE },
	0xB587,	{ 0xE7, 0xA5, 0xB0 },
	0xB588,	{ 0xE7, 0xA5, 0xB1 },
	0xB589,	{ 0xE7, 0xA5, 0xB2 },
	0xB58A,	{ 0xE7, 0xA5, 0xB3 },
	0xB58B,	{ 0xE7, 0xA5, 0xB4 },
	0xB58C,	{ 0xE7, 0xA5, 0xB5 },
	0xB58D,	{ 0xE7, 0xA5, 0xB6 },
	0xB58E,	{ 0xE7, 0xA5, 0xB9 },
	0xB58F,	{ 0xE7, 0xA5, 0xBB },
	0xB590,	{ 0xE7, 0xA5, 0xBC },
	0xB591,	{ 0xE7, 0xA5, 0xBD },
	0xB592,	{ 0xE7, 0xA5, 0xBE },
	0xB593,	{ 0xE7, 0xA5, 0xBF },
	0xB594,	{ 0xE7, 0xA6, 0x82 },
	0xB595,	{ 0xE7, 0xA6, 0x83 },
	0xB596,	{ 0xE7, 0xA6, 0x86 },
	0xB597,	{ 0xE7, 0xA6, 0x87 },
	0xB598,	{ 0xE7, 0xA6, 0x88 },
	0xB599,	{ 0xE7, 0xA6, 0x89 },
	0xB59A,	{ 0xE7, 0xA6, 0x8B },
	0xB59B,	{ 0xE7, 0xA6, 0x8C },
	0xB59C,	{ 0xE7, 0xA6, 0x8D },
	0xB59D,	{ 0xE7, 0xA6, 0x8E },
	0xB59E,	{ 0xE7, 0xA6, 0x90 },
	0xB59F,	{ 0xE7, 0xA6, 0x91 },
	0xB5A0,	{ 0xE7, 0xA6, 0x92 },
	0xB5A1,	{ 0xE6, 0x80, 0xA0 },
	0xB5A2,	{ 0xE8, 0x80, 0xBD },
	0xB5A3,	{ 0xE6, 0x8B, 0x85 },
	0xB5A4,	{ 0xE4, 0xB8, 0xB9 },
	0xB5A5,	{ 0xE5, 0x8D, 0x95 },
	0xB5A6,	{ 0xE9, 0x83, 0xB8 },
	0xB5A7,	{ 0xE6, 0x8E, 0xB8 },
	0xB5A8,	{ 0xE8, 0x83, 0x86 },
	0xB5A9,	{ 0xE6, 0x97, 0xA6 },
	0xB5AA,	{ 0xE6, 0xB0, 0xAE },
	0xB5AB,	{ 0xE4, 0xBD, 0x86 },
	0xB5AC,	{ 0xE6, 0x83, 0xAE },
	0xB5AD,	{ 0xE6, 0xB7, 0xA1 },
	0xB5AE,	{ 0xE8, 0xAF, 0x9E },
	0xB5AF,	{ 0xE5, 0xBC, 0xB9 },
	0xB5B0,	{ 0xE8, 0x9B, 0x8B },
	0xB5B1,	{ 0xE5, 0xBD, 0x93 },
	0xB5B2,	{ 0xE6, 0x8C, 0xA1 },
	0xB5B3,	{ 0xE5, 0x85, 0x9A },
	0xB5B4,	{ 0xE8, 0x8D, 0xA1 },
	0xB5B5,	{ 0xE6, 0xA1, 0xA3 },
	0xB5B6,	{ 0xE5, 0x88, 0x80 },
	0xB5B7,	{ 0xE6, 0x8D, 0xA3 },
	0xB5B8,	{ 0xE8, 0xB9, 0x88 },
	0xB5B9,	{ 0xE5, 0x80, 0x92 },
	0xB5BA,	{ 0xE5, 0xB2, 0x9B },
	0xB5BB,	{ 0xE7, 0xA5, 0xB7 },
	0xB5BC,	{ 0xE5, 0xAF, 0xBC },
	0xB5BD,	{ 0xE5, 0x88, 0xB0 },
	0xB5BE,	{ 0xE7, 0xA8, 0xBB },
	0xB5BF,	{ 0xE6, 0x82, 0xBC },
	0xB5C0,	{ 0xE9, 0x81, 0x93 },
	0xB5C1,	{ 0xE7, 0x9B, 0x97 },
	0xB5C2,	{ 0xE5, 0xBE, 0xB7 },
	0xB5C3,	{ 0xE5, 0xBE, 0x97 },
	0xB5C4,	{ 0xE7, 0x9A, 0x84 },
	0xB5C5,	{ 0xE8, 0xB9, 0xAC },
	0xB5C6,	{ 0xE7, 0x81, 0xAF },
	0xB5C7,	{ 0xE7, 0x99, 0xBB },
	0xB5C8,	{ 0xE7, 0xAD, 0x89 },
	0xB5C9,	{ 0xE7, 0x9E, 0xAA },
	0xB5CA,	{ 0xE5, 0x87, 0xB3 },
	0xB5CB,	{ 0xE9, 0x82, 0x93 },
	0xB5CC,	{ 0xE5, 0xA0, 0xA4 },
	0xB5CD,	{ 0xE4, 0xBD, 0x8E },
	0xB5CE,	{ 0xE6, 0xBB, 0xB4 },
	0xB5CF,	{ 0xE8, 0xBF, 0xAA },
	0xB5D0,	{ 0xE6, 0x95, 0x8C },
	0xB5D1,	{ 0xE7, 0xAC, 0x9B },
	0xB5D2,	{ 0xE7, 0x8B, 0x84 },
	0xB5D3,	{ 0xE6, 0xB6, 0xA4 },
	0xB5D4,	{ 0xE7, 0xBF, 0x9F },
	0xB5D5,	{ 0xE5, 0xAB, 0xA1 },
	0xB5D6,	{ 0xE6, 0x8A, 0xB5 },
	0xB5D7,	{ 0xE5, 0xBA, 0x95 },
	0xB5D8,	{ 0xE5, 0x9C, 0xB0 },
	0xB5D9,	{ 0xE8, 0x92, 0x82 },
	0xB5DA,	{ 0xE7, 0xAC, 0xAC },
	0xB5DB,	{ 0xE5, 0xB8, 0x9D },
	0xB5DC,	{ 0xE5, 0xBC, 0x9F },
	0xB5DD,	{ 0xE9, 0x80, 0x92 },
	0xB5DE,	{ 0xE7, 0xBC, 0x94 },
	0xB5DF,	{ 0xE9, 0xA2, 0xA0 },
	0xB5E0,	{ 0xE6, 0x8E, 0x82 },
	0xB5E1,	{ 0xE6, 0xBB, 0x87 },
	0xB5E2,	{ 0xE7, 0xA2, 0x98 },
	0xB5E3,	{ 0xE7, 0x82, 0xB9 },
	0xB5E4,	{ 0xE5, 0x85, 0xB8 },
	0xB5E5,	{ 0xE9, 0x9D, 0x9B },
	0xB5E6,	{ 0xE5, 0x9E, 0xAB },
	0xB5E7,	{ 0xE7, 0x94, 0xB5 },
	0xB5E8,	{ 0xE4, 0xBD, 0x83 },
	0xB5E9,	{ 0xE7, 0x94, 0xB8 },
	0xB5EA,	{ 0xE5, 0xBA, 0x97 },
	0xB5EB,	{ 0xE6, 0x83, 0xA6 },
	0xB5EC,	{ 0xE5, 0xA5, 0xA0 },
	0xB5ED,	{ 0xE6, 0xB7, 0x80 },
	0xB5EE,	{ 0xE6, 0xAE, 0xBF },
	0xB5EF,	{ 0xE7, 0xA2, 0x89 },
	0xB5F0,	{ 0xE5, 0x8F, 0xBC },
	0xB5F1,	{ 0xE9, 0x9B, 0x95 },
	0xB5F2,	{ 0xE5, 0x87, 0x8B },
	0xB5F3,	{ 0xE5, 0x88, 0x81 },
	0xB5F4,	{ 0xE6, 0x8E, 0x89 },
	0xB5F5,	{ 0xE5, 0x90, 0x8A },
	0xB5F6,	{ 0xE9, 0x92, 0x93 },
	0xB5F7,	{ 0xE8, 0xB0, 0x83 },
	0xB5F8,	{ 0xE8, 0xB7, 0x8C },
	0xB5F9,	{ 0xE7, 0x88, 0xB9 },
	0xB5FA,	{ 0xE7, 0xA2, 0x9F },
	0xB5FB,	{ 0xE8, 0x9D, 0xB6 },
	0xB5FC,	{ 0xE8, 0xBF, 0xAD },
	0xB5FD,	{ 0xE8, 0xB0, 0x8D },
	0xB5FE,	{ 0xE5, 0x8F, 0xA0 },
	0xB640,	{ 0xE7, 0xA6, 0x93 },
	0xB641,	{ 0xE7, 0xA6, 0x94 },
	0xB642,	{ 0xE7, 0xA6, 0x95 },
	0xB643,	{ 0xE7, 0xA6, 0x96 },
	0xB644,	{ 0xE7, 0xA6, 0x97 },
	0xB645,	{ 0xE7, 0xA6, 0x98 },
	0xB646,	{ 0xE7, 0xA6, 0x99 },
	0xB647,	{ 0xE7, 0xA6, 0x9B },
	0xB648,	{ 0xE7, 0xA6, 0x9C },
	0xB649,	{ 0xE7, 0xA6, 0x9D },
	0xB64A,	{ 0xE7, 0xA6, 0x9E },
	0xB64B,	{ 0xE7, 0xA6, 0x9F },
	0xB64C,	{ 0xE7, 0xA6, 0xA0 },
	0xB64D,	{ 0xE7, 0xA6, 0xA1 },
	0xB64E,	{ 0xE7, 0xA6, 0xA2 },
	0xB64F,	{ 0xE7, 0xA6, 0xA3 },
	0xB650,	{ 0xE7, 0xA6, 0xA4 },
	0xB651,	{ 0xE7, 0xA6, 0xA5 },
	0xB652,	{ 0xE7, 0xA6, 0xA6 },
	0xB653,	{ 0xE7, 0xA6, 0xA8 },
	0xB654,	{ 0xE7, 0xA6, 0xA9 },
	0xB655,	{ 0xE7, 0xA6, 0xAA },
	0xB656,	{ 0xE7, 0xA6, 0xAB },
	0xB657,	{ 0xE7, 0xA6, 0xAC },
	0xB658,	{ 0xE7, 0xA6, 0xAD },
	0xB659,	{ 0xE7, 0xA6, 0xAE },
	0xB65A,	{ 0xE7, 0xA6, 0xAF },
	0xB65B,	{ 0xE7, 0xA6, 0xB0 },
	0xB65C,	{ 0xE7, 0xA6, 0xB1 },
	0xB65D,	{ 0xE7, 0xA6, 0xB2 },
	0xB65E,	{ 0xE7, 0xA6, 0xB4 },
	0xB65F,	{ 0xE7, 0xA6, 0xB5 },
	0xB660,	{ 0xE7, 0xA6, 0xB6 },
	0xB661,	{ 0xE7, 0xA6, 0xB7 },
	0xB662,	{ 0xE7, 0xA6, 0xB8 },
	0xB663,	{ 0xE7, 0xA6, 0xBC },
	0xB664,	{ 0xE7, 0xA6, 0xBF },
	0xB665,	{ 0xE7, 0xA7, 0x82 },
	0xB666,	{ 0xE7, 0xA7, 0x84 },
	0xB667,	{ 0xE7, 0xA7, 0x85 },
	0xB668,	{ 0xE7, 0xA7, 0x87 },
	0xB669,	{ 0xE7, 0xA7, 0x88 },
	0xB66A,	{ 0xE7, 0xA7, 0x8A },
	0xB66B,	{ 0xE7, 0xA7, 0x8C },
	0xB66C,	{ 0xE7, 0xA7, 0x8E },
	0xB66D,	{ 0xE7, 0xA7, 0x8F },
	0xB66E,	{ 0xE7, 0xA7, 0x90 },
	0xB66F,	{ 0xE7, 0xA7, 0x93 },
	0xB670,	{ 0xE7, 0xA7, 0x94 },
	0xB671,	{ 0xE7, 0xA7, 0x96 },
	0xB672,	{ 0xE7, 0xA7, 0x97 },
	0xB673,	{ 0xE7, 0xA7, 0x99 },
	0xB674,	{ 0xE7, 0xA7, 0x9A },
	0xB675,	{ 0xE7, 0xA7, 0x9B },
	0xB676,	{ 0xE7, 0xA7, 0x9C },
	0xB677,	{ 0xE7, 0xA7, 0x9D },
	0xB678,	{ 0xE7, 0xA7, 0x9E },
	0xB679,	{ 0xE7, 0xA7, 0xA0 },
	0xB67A,	{ 0xE7, 0xA7, 0xA1 },
	0xB67B,	{ 0xE7, 0xA7, 0xA2 },
	0xB67C,	{ 0xE7, 0xA7, 0xA5 },
	0xB67D,	{ 0xE7, 0xA7, 0xA8 },
	0xB67E,	{ 0xE7, 0xA7, 0xAA },
	0xB680,	{ 0xE7, 0xA7, 0xAC },
	0xB681,	{ 0xE7, 0xA7, 0xAE },
	0xB682,	{ 0xE7, 0xA7, 0xB1 },
	0xB683,	{ 0xE7, 0xA7, 0xB2 },
	0xB684,	{ 0xE7, 0xA7, 0xB3 },
	0xB685,	{ 0xE7, 0xA7, 0xB4 },
	0xB686,	{ 0xE7, 0xA7, 0xB5 },
	0xB687,	{ 0xE7, 0xA7, 0xB6 },
	0xB688,	{ 0xE7, 0xA7, 0xB7 },
	0xB689,	{ 0xE7, 0xA7, 0xB9 },
	0xB68A,	{ 0xE7, 0xA7, 0xBA },
	0xB68B,	{ 0xE7, 0xA7, 0xBC },
	0xB68C,	{ 0xE7, 0xA7, 0xBE },
	0xB68D,	{ 0xE7, 0xA7, 0xBF },
	0xB68E,	{ 0xE7, 0xA8, 0x81 },
	0xB68F,	{ 0xE7, 0xA8, 0x84 },
	0xB690,	{ 0xE7, 0xA8, 0x85 },
	0xB691,	{ 0xE7, 0xA8, 0x87 },
	0xB692,	{ 0xE7, 0xA8, 0x88 },
	0xB693,	{ 0xE7, 0xA8, 0x89 },
	0xB694,	{ 0xE7, 0xA8, 0x8A },
	0xB695,	{ 0xE7, 0xA8, 0x8C },
	0xB696,	{ 0xE7, 0xA8, 0x8F },
	0xB697,	{ 0xE7, 0xA8, 0x90 },
	0xB698,	{ 0xE7, 0xA8, 0x91 },
	0xB699,	{ 0xE7, 0xA8, 0x92 },
	0xB69A,	{ 0xE7, 0xA8, 0x93 },
	0xB69B,	{ 0xE7, 0xA8, 0x95 },
	0xB69C,	{ 0xE7, 0xA8, 0x96 },
	0xB69D,	{ 0xE7, 0xA8, 0x98 },
	0xB69E,	{ 0xE7, 0xA8, 0x99 },
	0xB69F,	{ 0xE7, 0xA8, 0x9B },
	0xB6A0,	{ 0xE7, 0xA8, 0x9C },
	0xB6A1,	{ 0xE4, 0xB8, 0x81 },
	0xB6A2,	{ 0xE7, 0x9B, 0xAF },
	0xB6A3,	{ 0xE5, 0x8F, 0xAE },
	0xB6A4,	{ 0xE9, 0x92, 0x89 },
	0xB6A5,	{ 0xE9, 0xA1, 0xB6 },
	0xB6A6,	{ 0xE9, 0xBC, 0x8E },
	0xB6A7,	{ 0xE9, 0x94, 0xAD },
	0xB6A8,	{ 0xE5, 0xAE, 0x9A },
	0xB6A9,	{ 0xE8, 0xAE, 0xA2 },
	0xB6AA,	{ 0xE4, 0xB8, 0xA2 },
	0xB6AB,	{ 0xE4, 0xB8, 0x9C },
	0xB6AC,	{ 0xE5, 0x86, 0xAC },
	0xB6AD,	{ 0xE8, 0x91, 0xA3 },
	0xB6AE,	{ 0xE6, 0x87, 0x82 },
	0xB6AF,	{ 0xE5, 0x8A, 0xA8 },
	0xB6B0,	{ 0xE6, 0xA0, 0x8B },
	0xB6B1,	{ 0xE4, 0xBE, 0x97 },
	0xB6B2,	{ 0xE6, 0x81, 0xAB },
	0xB6B3,	{ 0xE5, 0x86, 0xBB },
	0xB6B4,	{ 0xE6, 0xB4, 0x9E },
	0xB6B5,	{ 0xE5, 0x85, 0x9C },
	0xB6B6,	{ 0xE6, 0x8A, 0x96 },
	0xB6B7,	{ 0xE6, 0x96, 0x97 },
	0xB6B8,	{ 0xE9, 0x99, 0xA1 },
	0xB6B9,	{ 0xE8, 0xB1, 0x86 },
	0xB6BA,	{ 0xE9, 0x80, 0x97 },
	0xB6BB,	{ 0xE7, 0x97, 0x98 },
	0xB6BC,	{ 0xE9, 0x83, 0xBD },
	0xB6BD,	{ 0xE7, 0x9D, 0xA3 },
	0xB6BE,	{ 0xE6, 0xAF, 0x92 },
	0xB6BF,	{ 0xE7, 0x8A, 0x8A },
	0xB6C0,	{ 0xE7, 0x8B, 0xAC },
	0xB6C1,	{ 0xE8, 0xAF, 0xBB },
	0xB6C2,	{ 0xE5, 0xA0, 0xB5 },
	0xB6C3,	{ 0xE7, 0x9D, 0xB9 },
	0xB6C4,	{ 0xE8, 0xB5, 0x8C },
	0xB6C5,	{ 0xE6, 0x9D, 0x9C },
	0xB6C6,	{ 0xE9, 0x95, 0x80 },
	0xB6C7,	{ 0xE8, 0x82, 0x9A },
	0xB6C8,	{ 0xE5, 0xBA, 0xA6 },
	0xB6C9,	{ 0xE6, 0xB8, 0xA1 },
	0xB6CA,	{ 0xE5, 0xA6, 0x92 },
	0xB6CB,	{ 0xE7, 0xAB, 0xAF },
	0xB6CC,	{ 0xE7, 0x9F, 0xAD },
	0xB6CD,	{ 0xE9, 0x94, 0xBB },
	0xB6CE,	{ 0xE6, 0xAE, 0xB5 },
	0xB6CF,	{ 0xE6, 0x96, 0xAD },
	0xB6D0,	{ 0xE7, 0xBC, 0x8E },
	0xB6D1,	{ 0xE5, 0xA0, 0x86 },
	0xB6D2,	{ 0xE5, 0x85, 0x91 },
	0xB6D3,	{ 0xE9, 0x98, 0x9F },
	0xB6D4,	{ 0xE5, 0xAF, 0xB9 },
	0xB6D5,	{ 0xE5, 0xA2, 0xA9 },
	0xB6D6,	{ 0xE5, 0x90, 0xA8 },
	0xB6D7,	{ 0xE8, 0xB9, 0xB2 },
	0xB6D8,	{ 0xE6, 0x95, 0xA6 },
	0xB6D9,	{ 0xE9, 0xA1, 0xBF },
	0xB6DA,	{ 0xE5, 0x9B, 0xA4 },
	0xB6DB,	{ 0xE9, 0x92, 0x9D },
	0xB6DC,	{ 0xE7, 0x9B, 0xBE },
	0xB6DD,	{ 0xE9, 0x81, 0x81 },
	0xB6DE,	{ 0xE6, 0x8E, 0x87 },
	0xB6DF,	{ 0xE5, 0x93, 0x86 },
	0xB6E0,	{ 0xE5, 0xA4, 0x9A },
	0xB6E1,	{ 0xE5, 0xA4, 0xBA },
	0xB6E2,	{ 0xE5, 0x9E, 0x9B },
	0xB6E3,	{ 0xE8, 0xBA, 0xB2 },
	0xB6E4,	{ 0xE6, 0x9C, 0xB5 },
	0xB6E5,	{ 0xE8, 0xB7, 0xBA },
	0xB6E6,	{ 0xE8, 0x88, 0xB5 },
	0xB6E7,	{ 0xE5, 0x89, 0x81 },
	0xB6E8,	{ 0xE6, 0x83, 0xB0 },
	0xB6E9,	{ 0xE5, 0xA0, 0x95 },
	0xB6EA,	{ 0xE8, 0x9B, 0xBE },
	0xB6EB,	{ 0xE5, 0xB3, 0xA8 },
	0xB6EC,	{ 0xE9, 0xB9, 0x85 },
	0xB6ED,	{ 0xE4, 0xBF, 0x84 },
	0xB6EE,	{ 0xE9, 0xA2, 0x9D },
	0xB6EF,	{ 0xE8, 0xAE, 0xB9 },
	0xB6F0,	{ 0xE5, 0xA8, 0xA5 },
	0xB6F1,	{ 0xE6, 0x81, 0xB6 },
	0xB6F2,	{ 0xE5, 0x8E, 0x84 },
	0xB6F3,	{ 0xE6, 0x89, 0xBC },
	0xB6F4,	{ 0xE9, 0x81, 0x8F },
	0xB6F5,	{ 0xE9, 0x84, 0x82 },
	0xB6F6,	{ 0xE9, 0xA5, 0xBF },
	0xB6F7,	{ 0xE6, 0x81, 0xA9 },
	0xB6F8,	{ 0xE8, 0x80, 0x8C },
	0xB6F9,	{ 0xE5, 0x84, 0xBF },
	0xB6FA,	{ 0xE8, 0x80, 0xB3 },
	0xB6FB,	{ 0xE5, 0xB0, 0x94 },
	0xB6FC,	{ 0xE9, 0xA5, 0xB5 },
	0xB6FD,	{ 0xE6, 0xB4, 0xB1 },
	0xB6FE,	{ 0xE4, 0xBA, 0x8C },
	0xB740,	{ 0xE7, 0xA8, 0x9D },
	0xB741,	{ 0xE7, 0xA8, 0x9F },
	0xB742,	{ 0xE7, 0xA8, 0xA1 },
	0xB743,	{ 0xE7, 0xA8, 0xA2 },
	0xB744,	{ 0xE7, 0xA8, 0xA4 },
	0xB745,	{ 0xE7, 0xA8, 0xA5 },
	0xB746,	{ 0xE7, 0xA8, 0xA6 },
	0xB747,	{ 0xE7, 0xA8, 0xA7 },
	0xB748,	{ 0xE7, 0xA8, 0xA8 },
	0xB749,	{ 0xE7, 0xA8, 0xA9 },
	0xB74A,	{ 0xE7, 0xA8, 0xAA },
	0xB74B,	{ 0xE7, 0xA8, 0xAB },
	0xB74C,	{ 0xE7, 0xA8, 0xAC },
	0xB74D,	{ 0xE7, 0xA8, 0xAD },
	0xB74E,	{ 0xE7, 0xA8, 0xAE },
	0xB74F,	{ 0xE7, 0xA8, 0xAF },
	0xB750,	{ 0xE7, 0xA8, 0xB0 },
	0xB751,	{ 0xE7, 0xA8, 0xB1 },
	0xB752,	{ 0xE7, 0xA8, 0xB2 },
	0xB753,	{ 0xE7, 0xA8, 0xB4 },
	0xB754,	{ 0xE7, 0xA8, 0xB5 },
	0xB755,	{ 0xE7, 0xA8, 0xB6 },
	0xB756,	{ 0xE7, 0xA8, 0xB8 },
	0xB757,	{ 0xE7, 0xA8, 0xBA },
	0xB758,	{ 0xE7, 0xA8, 0xBE },
	0xB759,	{ 0xE7, 0xA9, 0x80 },
	0xB75A,	{ 0xE7, 0xA9, 0x81 },
	0xB75B,	{ 0xE7, 0xA9, 0x82 },
	0xB75C,	{ 0xE7, 0xA9, 0x83 },
	0xB75D,	{ 0xE7, 0xA9, 0x84 },
	0xB75E,	{ 0xE7, 0xA9, 0x85 },
	0xB75F,	{ 0xE7, 0xA9, 0x87 },
	0xB760,	{ 0xE7, 0xA9, 0x88 },
	0xB761,	{ 0xE7, 0xA9, 0x89 },
	0xB762,	{ 0xE7, 0xA9, 0x8A },
	0xB763,	{ 0xE7, 0xA9, 0x8B },
	0xB764,	{ 0xE7, 0xA9, 0x8C },
	0xB765,	{ 0xE7, 0xA9, 0x8D },
	0xB766,	{ 0xE7, 0xA9, 0x8E },
	0xB767,	{ 0xE7, 0xA9, 0x8F },
	0xB768,	{ 0xE7, 0xA9, 0x90 },
	0xB769,	{ 0xE7, 0xA9, 0x92 },
	0xB76A,	{ 0xE7, 0xA9, 0x93 },
	0xB76B,	{ 0xE7, 0xA9, 0x94 },
	0xB76C,	{ 0xE7, 0xA9, 0x95 },
	0xB76D,	{ 0xE7, 0xA9, 0x96 },
	0xB76E,	{ 0xE7, 0xA9, 0x98 },
	0xB76F,	{ 0xE7, 0xA9, 0x99 },
	0xB770,	{ 0xE7, 0xA9, 0x9A },
	0xB771,	{ 0xE7, 0xA9, 0x9B },
	0xB772,	{ 0xE7, 0xA9, 0x9C },
	0xB773,	{ 0xE7, 0xA9, 0x9D },
	0xB774,	{ 0xE7, 0xA9, 0x9E },
	0xB775,	{ 0xE7, 0xA9, 0x9F },
	0xB776,	{ 0xE7, 0xA9, 0xA0 },
	0xB777,	{ 0xE7, 0xA9, 0xA1 },
	0xB778,	{ 0xE7, 0xA9, 0xA2 },
	0xB779,	{ 0xE7, 0xA9, 0xA3 },
	0xB77A,	{ 0xE7, 0xA9, 0xA4 },
	0xB77B,	{ 0xE7, 0xA9, 0xA5 },
	0xB77C,	{ 0xE7, 0xA9, 0xA6 },
	0xB77D,	{ 0xE7, 0xA9, 0xA7 },
	0xB77E,	{ 0xE7, 0xA9, 0xA8 },
	0xB780,	{ 0xE7, 0xA9, 0xA9 },
	0xB781,	{ 0xE7, 0xA9, 0xAA },
	0xB782,	{ 0xE7, 0xA9, 0xAB },
	0xB783,	{ 0xE7, 0xA9, 0xAC },
	0xB784,	{ 0xE7, 0xA9, 0xAD },
	0xB785,	{ 0xE7, 0xA9, 0xAE },
	0xB786,	{ 0xE7, 0xA9, 0xAF },
	0xB787,	{ 0xE7, 0xA9, 0xB1 },
	0xB788,	{ 0xE7, 0xA9, 0xB2 },
	0xB789,	{ 0xE7, 0xA9, 0xB3 },
	0xB78A,	{ 0xE7, 0xA9, 0xB5 },
	0xB78B,	{ 0xE7, 0xA9, 0xBB },
	0xB78C,	{ 0xE7, 0xA9, 0xBC },
	0xB78D,	{ 0xE7, 0xA9, 0xBD },
	0xB78E,	{ 0xE7, 0xA9, 0xBE },
	0xB78F,	{ 0xE7, 0xAA, 0x82 },
	0xB790,	{ 0xE7, 0xAA, 0x85 },
	0xB791,	{ 0xE7, 0xAA, 0x87 },
	0xB792,	{ 0xE7, 0xAA, 0x89 },
	0xB793,	{ 0xE7, 0xAA, 0x8A },
	0xB794,	{ 0xE7, 0xAA, 0x8B },
	0xB795,	{ 0xE7, 0xAA, 0x8C },
	0xB796,	{ 0xE7, 0xAA, 0x8E },
	0xB797,	{ 0xE7, 0xAA, 0x8F },
	0xB798,	{ 0xE7, 0xAA, 0x90 },
	0xB799,	{ 0xE7, 0xAA, 0x93 },
	0xB79A,	{ 0xE7, 0xAA, 0x94 },
	0xB79B,	{ 0xE7, 0xAA, 0x99 },
	0xB79C,	{ 0xE7, 0xAA, 0x9A },
	0xB79D,	{ 0xE7, 0xAA, 0x9B },
	0xB79E,	{ 0xE7, 0xAA, 0x9E },
	0xB79F,	{ 0xE7, 0xAA, 0xA1 },
	0xB7A0,	{ 0xE7, 0xAA, 0xA2 },
	0xB7A1,	{ 0xE8, 0xB4, 0xB0 },
	0xB7A2,	{ 0xE5, 0x8F, 0x91 },
	0xB7A3,	{ 0xE7, 0xBD, 0x9A },
	0xB7A4,	{ 0xE7, 0xAD, 0x8F },
	0xB7A5,	{ 0xE4, 0xBC, 0x90 },
	0xB7A6,	{ 0xE4, 0xB9, 0x8F },
	0xB7A7,	{ 0xE9, 0x98, 0x80 },
	0xB7A8,	{ 0xE6, 0xB3, 0x95 },
	0xB7A9,	{ 0xE7, 0x8F, 0x90 },
	0xB7AA,	{ 0xE8, 0x97, 0xA9 },
	0xB7AB,	{ 0xE5, 0xB8, 0x86 },
	0xB7AC,	{ 0xE7, 0x95, 0xAA },
	0xB7AD,	{ 0xE7, 0xBF, 0xBB },
	0xB7AE,	{ 0xE6, 0xA8, 0x8A },
	0xB7AF,	{ 0xE7, 0x9F, 0xBE },
	0xB7B0,	{ 0xE9, 0x92, 0x92 },
	0xB7B1,	{ 0xE7, 0xB9, 0x81 },
	0xB7B2,	{ 0xE5, 0x87, 0xA1 },
	0xB7B3,	{ 0xE7, 0x83, 0xA6 },
	0xB7B4,	{ 0xE5, 0x8F, 0x8D },
	0xB7B5,	{ 0xE8, 0xBF, 0x94 },
	0xB7B6,	{ 0xE8, 0x8C, 0x83 },
	0xB7B7,	{ 0xE8, 0xB4, 0xA9 },
	0xB7B8,	{ 0xE7, 0x8A, 0xAF },
	0xB7B9,	{ 0xE9, 0xA5, 0xAD },
	0xB7BA,	{ 0xE6, 0xB3, 0x9B },
	0xB7BB,	{ 0xE5, 0x9D, 0x8A },
	0xB7BC,	{ 0xE8, 0x8A, 0xB3 },
	0xB7BD,	{ 0xE6, 0x96, 0xB9 },
	0xB7BE,	{ 0xE8, 0x82, 0xAA },
	0xB7BF,	{ 0xE6, 0x88, 0xBF },
	0xB7C0,	{ 0xE9, 0x98, 0xB2 },
	0xB7C1,	{ 0xE5, 0xA6, 0xA8 },
	0xB7C2,	{ 0xE4, 0xBB, 0xBF },
	0xB7C3,	{ 0xE8, 0xAE, 0xBF },
	0xB7C4,	{ 0xE7, 0xBA, 0xBA },
	0xB7C5,	{ 0xE6, 0x94, 0xBE },
	0xB7C6,	{ 0xE8, 0x8F, 0xB2 },
	0xB7C7,	{ 0xE9, 0x9D, 0x9E },
	0xB7C8,	{ 0xE5, 0x95, 0xA1 },
	0xB7C9,	{ 0xE9, 0xA3, 0x9E },
	0xB7CA,	{ 0xE8, 0x82, 0xA5 },
	0xB7CB,	{ 0xE5, 0x8C, 0xAA },
	0xB7CC,	{ 0xE8, 0xAF, 0xBD },
	0xB7CD,	{ 0xE5, 0x90, 0xA0 },
	0xB7CE,	{ 0xE8, 0x82, 0xBA },
	0xB7CF,	{ 0xE5, 0xBA, 0x9F },
	0xB7D0,	{ 0xE6, 0xB2, 0xB8 },
	0xB7D1,	{ 0xE8, 0xB4, 0xB9 },
	0xB7D2,	{ 0xE8, 0x8A, 0xAC },
	0xB7D3,	{ 0xE9, 0x85, 0x9A },
	0xB7D4,	{ 0xE5, 0x90, 0xA9 },
	0xB7D5,	{ 0xE6, 0xB0, 0x9B },
	0xB7D6,	{ 0xE5, 0x88, 0x86 },
	0xB7D7,	{ 0xE7, 0xBA, 0xB7 },
	0xB7D8,	{ 0xE5, 0x9D, 0x9F },
	0xB7D9,	{ 0xE7, 0x84, 0x9A },
	0xB7DA,	{ 0xE6, 0xB1, 0xBE },
	0xB7DB,	{ 0xE7, 0xB2, 0x89 },
	0xB7DC,	{ 0xE5, 0xA5, 0x8B },
	0xB7DD,	{ 0xE4, 0xBB, 0xBD },
	0xB7DE,	{ 0xE5, 0xBF, 0xBF },
	0xB7DF,	{ 0xE6, 0x84, 0xA4 },
	0xB7E0,	{ 0xE7, 0xB2, 0xAA },
	0xB7E1,	{ 0xE4, 0xB8, 0xB0 },
	0xB7E2,	{ 0xE5, 0xB0, 0x81 },
	0xB7E3,	{ 0xE6, 0x9E, 0xAB },
	0xB7E4,	{ 0xE8, 0x9C, 0x82 },
	0xB7E5,	{ 0xE5, 0xB3, 0xB0 },
	0xB7E6,	{ 0xE9, 0x94, 0x8B },
	0xB7E7,	{ 0xE9, 0xA3, 0x8E },
	0xB7E8,	{ 0xE7, 0x96, 0xAF },
	0xB7E9,	{ 0xE7, 0x83, 0xBD },
	0xB7EA,	{ 0xE9, 0x80, 0xA2 },
	0xB7EB,	{ 0xE5, 0x86, 0xAF },
	0xB7EC,	{ 0xE7, 0xBC, 0x9D },
	0xB7ED,	{ 0xE8, 0xAE, 0xBD },
	0xB7EE,	{ 0xE5, 0xA5, 0x89 },
	0xB7EF,	{ 0xE5, 0x87, 0xA4 },
	0xB7F0,	{ 0xE4, 0xBD, 0x9B },
	0xB7F1,	{ 0xE5, 0x90, 0xA6 },
	0xB7F2,	{ 0xE5, 0xA4, 0xAB },
	0xB7F3,	{ 0xE6, 0x95, 0xB7 },
	0xB7F4,	{ 0xE8, 0x82, 0xA4 },
	0xB7F5,	{ 0xE5, 0xAD, 0xB5 },
	0xB7F6,	{ 0xE6, 0x89, 0xB6 },
	0xB7F7,	{ 0xE6, 0x8B, 0x82 },
	0xB7F8,	{ 0xE8, 0xBE, 0x90 },
	0xB7F9,	{ 0xE5, 0xB9, 0x85 },
	0xB7FA,	{ 0xE6, 0xB0, 0x9F },
	0xB7FB,	{ 0xE7, 0xAC, 0xA6 },
	0xB7FC,	{ 0xE4, 0xBC, 0x8F },
	0xB7FD,	{ 0xE4, 0xBF, 0x98 },
	0xB7FE,	{ 0xE6, 0x9C, 0x8D },
	0xB840,	{ 0xE7, 0xAA, 0xA3 },
	0xB841,	{ 0xE7, 0xAA, 0xA4 },
	0xB842,	{ 0xE7, 0xAA, 0xA7 },
	0xB843,	{ 0xE7, 0xAA, 0xA9 },
	0xB844,	{ 0xE7, 0xAA, 0xAA },
	0xB845,	{ 0xE7, 0xAA, 0xAB },
	0xB846,	{ 0xE7, 0xAA, 0xAE },
	0xB847,	{ 0xE7, 0xAA, 0xAF },
	0xB848,	{ 0xE7, 0xAA, 0xB0 },
	0xB849,	{ 0xE7, 0xAA, 0xB1 },
	0xB84A,	{ 0xE7, 0xAA, 0xB2 },
	0xB84B,	{ 0xE7, 0xAA, 0xB4 },
	0xB84C,	{ 0xE7, 0xAA, 0xB5 },
	0xB84D,	{ 0xE7, 0xAA, 0xB6 },
	0xB84E,	{ 0xE7, 0xAA, 0xB7 },
	0xB84F,	{ 0xE7, 0xAA, 0xB8 },
	0xB850,	{ 0xE7, 0xAA, 0xB9 },
	0xB851,	{ 0xE7, 0xAA, 0xBA },
	0xB852,	{ 0xE7, 0xAA, 0xBB },
	0xB853,	{ 0xE7, 0xAA, 0xBC },
	0xB854,	{ 0xE7, 0xAA, 0xBD },
	0xB855,	{ 0xE7, 0xAA, 0xBE },
	0xB856,	{ 0xE7, 0xAB, 0x80 },
	0xB857,	{ 0xE7, 0xAB, 0x81 },
	0xB858,	{ 0xE7, 0xAB, 0x82 },
	0xB859,	{ 0xE7, 0xAB, 0x83 },
	0xB85A,	{ 0xE7, 0xAB, 0x84 },
	0xB85B,	{ 0xE7, 0xAB, 0x85 },
	0xB85C,	{ 0xE7, 0xAB, 0x86 },
	0xB85D,	{ 0xE7, 0xAB, 0x87 },
	0xB85E,	{ 0xE7, 0xAB, 0x88 },
	0xB85F,	{ 0xE7, 0xAB, 0x89 },
	0xB860,	{ 0xE7, 0xAB, 0x8A },
	0xB861,	{ 0xE7, 0xAB, 0x8C },
	0xB862,	{ 0xE7, 0xAB, 0x8D },
	0xB863,	{ 0xE7, 0xAB, 0x8E },
	0xB864,	{ 0xE7, 0xAB, 0x8F },
	0xB865,	{ 0xE7, 0xAB, 0x90 },
	0xB866,	{ 0xE7, 0xAB, 0x91 },
	0xB867,	{ 0xE7, 0xAB, 0x92 },
	0xB868,	{ 0xE7, 0xAB, 0x93 },
	0xB869,	{ 0xE7, 0xAB, 0x94 },
	0xB86A,	{ 0xE7, 0xAB, 0x95 },
	0xB86B,	{ 0xE7, 0xAB, 0x97 },
	0xB86C,	{ 0xE7, 0xAB, 0x98 },
	0xB86D,	{ 0xE7, 0xAB, 0x9A },
	0xB86E,	{ 0xE7, 0xAB, 0x9B },
	0xB86F,	{ 0xE7, 0xAB, 0x9C },
	0xB870,	{ 0xE7, 0xAB, 0x9D },
	0xB871,	{ 0xE7, 0xAB, 0xA1 },
	0xB872,	{ 0xE7, 0xAB, 0xA2 },
	0xB873,	{ 0xE7, 0xAB, 0xA4 },
	0xB874,	{ 0xE7, 0xAB, 0xA7 },
	0xB875,	{ 0xE7, 0xAB, 0xA8 },
	0xB876,	{ 0xE7, 0xAB, 0xA9 },
	0xB877,	{ 0xE7, 0xAB, 0xAA },
	0xB878,	{ 0xE7, 0xAB, 0xAB },
	0xB879,	{ 0xE7, 0xAB, 0xAC },
	0xB87A,	{ 0xE7, 0xAB, 0xAE },
	0xB87B,	{ 0xE7, 0xAB, 0xB0 },
	0xB87C,	{ 0xE7, 0xAB, 0xB1 },
	0xB87D,	{ 0xE7, 0xAB, 0xB2 },
	0xB87E,	{ 0xE7, 0xAB, 0xB3 },
	0xB880,	{ 0xE7, 0xAB, 0xB4 },
	0xB881,	{ 0xE7, 0xAB, 0xB5 },
	0xB882,	{ 0xE7, 0xAB, 0xB6 },
	0xB883,	{ 0xE7, 0xAB, 0xB7 },
	0xB884,	{ 0xE7, 0xAB, 0xB8 },
	0xB885,	{ 0xE7, 0xAB, 0xBB },
	0xB886,	{ 0xE7, 0xAB, 0xBC },
	0xB887,	{ 0xE7, 0xAB, 0xBE },
	0xB888,	{ 0xE7, 0xAC, 0x80 },
	0xB889,	{ 0xE7, 0xAC, 0x81 },
	0xB88A,	{ 0xE7, 0xAC, 0x82 },
	0xB88B,	{ 0xE7, 0xAC, 0x85 },
	0xB88C,	{ 0xE7, 0xAC, 0x87 },
	0xB88D,	{ 0xE7, 0xAC, 0x89 },
	0xB88E,	{ 0xE7, 0xAC, 0x8C },
	0xB88F,	{ 0xE7, 0xAC, 0x8D },
	0xB890,	{ 0xE7, 0xAC, 0x8E },
	0xB891,	{ 0xE7, 0xAC, 0x90 },
	0xB892,	{ 0xE7, 0xAC, 0x92 },
	0xB893,	{ 0xE7, 0xAC, 0x93 },
	0xB894,	{ 0xE7, 0xAC, 0x96 },
	0xB895,	{ 0xE7, 0xAC, 0x97 },
	0xB896,	{ 0xE7, 0xAC, 0x98 },
	0xB897,	{ 0xE7, 0xAC, 0x9A },
	0xB898,	{ 0xE7, 0xAC, 0x9C },
	0xB899,	{ 0xE7, 0xAC, 0x9D },
	0xB89A,	{ 0xE7, 0xAC, 0x9F },
	0xB89B,	{ 0xE7, 0xAC, 0xA1 },
	0xB89C,	{ 0xE7, 0xAC, 0xA2 },
	0xB89D,	{ 0xE7, 0xAC, 0xA3 },
	0xB89E,	{ 0xE7, 0xAC, 0xA7 },
	0xB89F,	{ 0xE7, 0xAC, 0xA9 },
	0xB8A0,	{ 0xE7, 0xAC, 0xAD },
	0xB8A1,	{ 0xE6, 0xB5, 0xAE },
	0xB8A2,	{ 0xE6, 0xB6, 0xAA },
	0xB8A3,	{ 0xE7, 0xA6, 0x8F },
	0xB8A4,	{ 0xE8, 0xA2, 0xB1 },
	0xB8A5,	{ 0xE5, 0xBC, 0x97 },
	0xB8A6,	{ 0xE7, 0x94, 0xAB },
	0xB8A7,	{ 0xE6, 0x8A, 0x9A },
	0xB8A8,	{ 0xE8, 0xBE, 0x85 },
	0xB8A9,	{ 0xE4, 0xBF, 0xAF },
	0xB8AA,	{ 0xE9, 0x87, 0x9C },
	0xB8AB,	{ 0xE6, 0x96, 0xA7 },
	0xB8AC,	{ 0xE8, 0x84, 0xAF },
	0xB8AD,	{ 0xE8, 0x85, 0x91 },
	0xB8AE,	{ 0xE5, 0xBA, 0x9C },
	0xB8AF,	{ 0xE8, 0x85, 0x90 },
	0xB8B0,	{ 0xE8, 0xB5, 0xB4 },
	0xB8B1,	{ 0xE5, 0x89, 0xAF },
	0xB8B2,	{ 0xE8, 0xA6, 0x86 },
	0xB8B3,	{ 0xE8, 0xB5, 0x8B },
	0xB8B4,	{ 0xE5, 0xA4, 0x8D },
	0xB8B5,	{ 0xE5, 0x82, 0x85 },
	0xB8B6,	{ 0xE4, 0xBB, 0x98 },
	0xB8B7,	{ 0xE9, 0x98, 0x9C },
	0xB8B8,	{ 0xE7, 0x88, 0xB6 },
	0xB8B9,	{ 0xE8, 0x85, 0xB9 },
	0xB8BA,	{ 0xE8, 0xB4, 0x9F },
	0xB8BB,	{ 0xE5, 0xAF, 0x8C },
	0xB8BC,	{ 0xE8, 0xAE, 0xA3 },
	0xB8BD,	{ 0xE9, 0x99, 0x84 },
	0xB8BE,	{ 0xE5, 0xA6, 0x87 },
	0xB8BF,	{ 0xE7, 0xBC, 0x9A },
	0xB8C0,	{ 0xE5, 0x92, 0x90 },
	0xB8C1,	{ 0xE5, 0x99, 0xB6 },
	0xB8C2,	{ 0xE5, 0x98, 0x8E },
	0xB8C3,	{ 0xE8, 0xAF, 0xA5 },
	0xB8C4,	{ 0xE6, 0x94, 0xB9 },
	0xB8C5,	{ 0xE6, 0xA6, 0x82 },
	0xB8C6,	{ 0xE9, 0x92, 0x99 },
	0xB8C7,	{ 0xE7, 0x9B, 0x96 },
	0xB8C8,	{ 0xE6, 0xBA, 0x89 },
	0xB8C9,	{ 0xE5, 0xB9, 0xB2 },
	0xB8CA,	{ 0xE7, 0x94, 0x98 },
	0xB8CB,	{ 0xE6, 0x9D, 0x86 },
	0xB8CC,	{ 0xE6, 0x9F, 0x91 },
	0xB8CD,	{ 0xE7, 0xAB, 0xBF },
	0xB8CE,	{ 0xE8, 0x82, 0x9D },
	0xB8CF,	{ 0xE8, 0xB5, 0xB6 },
	0xB8D0,	{ 0xE6, 0x84, 0x9F },
	0xB8D1,	{ 0xE7, 0xA7, 0x86 },
	0xB8D2,	{ 0xE6, 0x95, 0xA2 },
	0xB8D3,	{ 0xE8, 0xB5, 0xA3 },
	0xB8D4,	{ 0xE5, 0x86, 0x88 },
	0xB8D5,	{ 0xE5, 0x88, 0x9A },
	0xB8D6,	{ 0xE9, 0x92, 0xA2 },
	0xB8D7,	{ 0xE7, 0xBC, 0xB8 },
	0xB8D8,	{ 0xE8, 0x82, 0x9B },
	0xB8D9,	{ 0xE7, 0xBA, 0xB2 },
	0xB8DA,	{ 0xE5, 0xB2, 0x97 },
	0xB8DB,	{ 0xE6, 0xB8, 0xAF },
	0xB8DC,	{ 0xE6, 0x9D, 0xA0 },
	0xB8DD,	{ 0xE7, 0xAF, 0x99 },
	0xB8DE,	{ 0xE7, 0x9A, 0x8B },
	0xB8DF,	{ 0xE9, 0xAB, 0x98 },
	0xB8E0,	{ 0xE8, 0x86, 0x8F },
	0xB8E1,	{ 0xE7, 0xBE, 0x94 },
	0xB8E2,	{ 0xE7, 0xB3, 0x95 },
	0xB8E3,	{ 0xE6, 0x90, 0x9E },
	0xB8E4,	{ 0xE9, 0x95, 0x90 },
	0xB8E5,	{ 0xE7, 0xA8, 0xBF },
	0xB8E6,	{ 0xE5, 0x91, 0x8A },
	0xB8E7,	{ 0xE5, 0x93, 0xA5 },
	0xB8E8,	{ 0xE6, 0xAD, 0x8C },
	0xB8E9,	{ 0xE6, 0x90, 0x81 },
	0xB8EA,	{ 0xE6, 0x88, 0x88 },
	0xB8EB,	{ 0xE9, 0xB8, 0xBD },
	0xB8EC,	{ 0xE8, 0x83, 0xB3 },
	0xB8ED,	{ 0xE7, 0x96, 0x99 },
	0xB8EE,	{ 0xE5, 0x89, 0xB2 },
	0xB8EF,	{ 0xE9, 0x9D, 0xA9 },
	0xB8F0,	{ 0xE8, 0x91, 0x9B },
	0xB8F1,	{ 0xE6, 0xA0, 0xBC },
	0xB8F2,	{ 0xE8, 0x9B, 0xA4 },
	0xB8F3,	{ 0xE9, 0x98, 0x81 },
	0xB8F4,	{ 0xE9, 0x9A, 0x94 },
	0xB8F5,	{ 0xE9, 0x93, 0xAC },
	0xB8F6,	{ 0xE4, 0xB8, 0xAA },
	0xB8F7,	{ 0xE5, 0x90, 0x84 },
	0xB8F8,	{ 0xE7, 0xBB, 0x99 },
	0xB8F9,	{ 0xE6, 0xA0, 0xB9 },
	0xB8FA,	{ 0xE8, 0xB7, 0x9F },
	0xB8FB,	{ 0xE8, 0x80, 0x95 },
	0xB8FC,	{ 0xE6, 0x9B, 0xB4 },
	0xB8FD,	{ 0xE5, 0xBA, 0x9A },
	0xB8FE,	{ 0xE7, 0xBE, 0xB9 },
	0xB940,	{ 0xE7, 0xAC, 0xAF },
	0xB941,	{ 0xE7, 0xAC, 0xB0 },
	0xB942,	{ 0xE7, 0xAC, 0xB2 },
	0xB943,	{ 0xE7, 0xAC, 0xB4 },
	0xB944,	{ 0xE7, 0xAC, 0xB5 },
	0xB945,	{ 0xE7, 0xAC, 0xB6 },
	0xB946,	{ 0xE7, 0xAC, 0xB7 },
	0xB947,	{ 0xE7, 0xAC, 0xB9 },
	0xB948,	{ 0xE7, 0xAC, 0xBB },
	0xB949,	{ 0xE7, 0xAC, 0xBD },
	0xB94A,	{ 0xE7, 0xAC, 0xBF },
	0xB94B,	{ 0xE7, 0xAD, 0x80 },
	0xB94C,	{ 0xE7, 0xAD, 0x81 },
	0xB94D,	{ 0xE7, 0xAD, 0x82 },
	0xB94E,	{ 0xE7, 0xAD, 0x83 },
	0xB94F,	{ 0xE7, 0xAD, 0x84 },
	0xB950,	{ 0xE7, 0xAD, 0x86 },
	0xB951,	{ 0xE7, 0xAD, 0x88 },
	0xB952,	{ 0xE7, 0xAD, 0x8A },
	0xB953,	{ 0xE7, 0xAD, 0x8D },
	0xB954,	{ 0xE7, 0xAD, 0x8E },
	0xB955,	{ 0xE7, 0xAD, 0x93 },
	0xB956,	{ 0xE7, 0xAD, 0x95 },
	0xB957,	{ 0xE7, 0xAD, 0x97 },
	0xB958,	{ 0xE7, 0xAD, 0x99 },
	0xB959,	{ 0xE7, 0xAD, 0x9C },
	0xB95A,	{ 0xE7, 0xAD, 0x9E },
	0xB95B,	{ 0xE7, 0xAD, 0x9F },
	0xB95C,	{ 0xE7, 0xAD, 0xA1 },
	0xB95D,	{ 0xE7, 0xAD, 0xA3 },
	0xB95E,	{ 0xE7, 0xAD, 0xA4 },
	0xB95F,	{ 0xE7, 0xAD, 0xA5 },
	0xB960,	{ 0xE7, 0xAD, 0xA6 },
	0xB961,	{ 0xE7, 0xAD, 0xA7 },
	0xB962,	{ 0xE7, 0xAD, 0xA8 },
	0xB963,	{ 0xE7, 0xAD, 0xA9 },
	0xB964,	{ 0xE7, 0xAD, 0xAA },
	0xB965,	{ 0xE7, 0xAD, 0xAB },
	0xB966,	{ 0xE7, 0xAD, 0xAC },
	0xB967,	{ 0xE7, 0xAD, 0xAD },
	0xB968,	{ 0xE7, 0xAD, 0xAF },
	0xB969,	{ 0xE7, 0xAD, 0xB0 },
	0xB96A,	{ 0xE7, 0xAD, 0xB3 },
	0xB96B,	{ 0xE7, 0xAD, 0xB4 },
	0xB96C,	{ 0xE7, 0xAD, 0xB6 },
	0xB96D,	{ 0xE7, 0xAD, 0xB8 },
	0xB96E,	{ 0xE7, 0xAD, 0xBA },
	0xB96F,	{ 0xE7, 0xAD, 0xBC },
	0xB970,	{ 0xE7, 0xAD, 0xBD },
	0xB971,	{ 0xE7, 0xAD, 0xBF },
	0xB972,	{ 0xE7, 0xAE, 0x81 },
	0xB973,	{ 0xE7, 0xAE, 0x82 },
	0xB974,	{ 0xE7, 0xAE, 0x83 },
	0xB975,	{ 0xE7, 0xAE, 0x84 },
	0xB976,	{ 0xE7, 0xAE, 0x86 },
	0xB977,	{ 0xE7, 0xAE, 0x87 },
	0xB978,	{ 0xE7, 0xAE, 0x88 },
	0xB979,	{ 0xE7, 0xAE, 0x89 },
	0xB97A,	{ 0xE7, 0xAE, 0x8A },
	0xB97B,	{ 0xE7, 0xAE, 0x8B },
	0xB97C,	{ 0xE7, 0xAE, 0x8C },
	0xB97D,	{ 0xE7, 0xAE, 0x8E },
	0xB97E,	{ 0xE7, 0xAE, 0x8F },
	0xB980,	{ 0xE7, 0xAE, 0x91 },
	0xB981,	{ 0xE7, 0xAE, 0x92 },
	0xB982,	{ 0xE7, 0xAE, 0x93 },
	0xB983,	{ 0xE7, 0xAE, 0x96 },
	0xB984,	{ 0xE7, 0xAE, 0x98 },
	0xB985,	{ 0xE7, 0xAE, 0x99 },
	0xB986,	{ 0xE7, 0xAE, 0x9A },
	0xB987,	{ 0xE7, 0xAE, 0x9B },
	0xB988,	{ 0xE7, 0xAE, 0x9E },
	0xB989,	{ 0xE7, 0xAE, 0x9F },
	0xB98A,	{ 0xE7, 0xAE, 0xA0 },
	0xB98B,	{ 0xE7, 0xAE, 0xA3 },
	0xB98C,	{ 0xE7, 0xAE, 0xA4 },
	0xB98D,	{ 0xE7, 0xAE, 0xA5 },
	0xB98E,	{ 0xE7, 0xAE, 0xAE },
	0xB98F,	{ 0xE7, 0xAE, 0xAF },
	0xB990,	{ 0xE7, 0xAE, 0xB0 },
	0xB991,	{ 0xE7, 0xAE, 0xB2 },
	0xB992,	{ 0xE7, 0xAE, 0xB3 },
	0xB993,	{ 0xE7, 0xAE, 0xB5 },
	0xB994,	{ 0xE7, 0xAE, 0xB6 },
	0xB995,	{ 0xE7, 0xAE, 0xB7 },
	0xB996,	{ 0xE7, 0xAE, 0xB9 },
	0xB997,	{ 0xE7, 0xAE, 0xBA },
	0xB998,	{ 0xE7, 0xAE, 0xBB },
	0xB999,	{ 0xE7, 0xAE, 0xBC },
	0xB99A,	{ 0xE7, 0xAE, 0xBD },
	0xB99B,	{ 0xE7, 0xAE, 0xBE },
	0xB99C,	{ 0xE7, 0xAE, 0xBF },
	0xB99D,	{ 0xE7, 0xAF, 0x80 },
	0xB99E,	{ 0xE7, 0xAF, 0x82 },
	0xB99F,	{ 0xE7, 0xAF, 0x83 },
	0xB9A0,	{ 0xE7, 0xAF, 0x84 },
	0xB9A1,	{ 0xE5, 0x9F, 0x82 },
	0xB9A2,	{ 0xE8, 0x80, 0xBF },
	0xB9A3,	{ 0xE6, 0xA2, 0x97 },
	0xB9A4,	{ 0xE5, 0xB7, 0xA5 },
	0xB9A5,	{ 0xE6, 0x94, 0xBB },
	0xB9A6,	{ 0xE5, 0x8A, 0x9F },
	0xB9A7,	{ 0xE6, 0x81, 0xAD },
	0xB9A8,	{ 0xE9, 0xBE, 0x9A },
	0xB9A9,	{ 0xE4, 0xBE, 0x9B },
	0xB9AA,	{ 0xE8, 0xBA, 0xAC },
	0xB9AB,	{ 0xE5, 0x85, 0xAC },
	0xB9AC,	{ 0xE5, 0xAE, 0xAB },
	0xB9AD,	{ 0xE5, 0xBC, 0x93 },
	0xB9AE,	{ 0xE5, 0xB7, 0xA9 },
	0xB9AF,	{ 0xE6, 0xB1, 0x9E },
	0xB9B0,	{ 0xE6, 0x8B, 0xB1 },
	0xB9B1,	{ 0xE8, 0xB4, 0xA1 },
	0xB9B2,	{ 0xE5, 0x85, 0xB1 },
	0xB9B3,	{ 0xE9, 0x92, 0xA9 },
	0xB9B4,	{ 0xE5, 0x8B, 0xBE },
	0xB9B5,	{ 0xE6, 0xB2, 0x9F },
	0xB9B6,	{ 0xE8, 0x8B, 0x9F },
	0xB9B7,	{ 0xE7, 0x8B, 0x97 },
	0xB9B8,	{ 0xE5, 0x9E, 0xA2 },
	0xB9B9,	{ 0xE6, 0x9E, 0x84 },
	0xB9BA,	{ 0xE8, 0xB4, 0xAD },
	0xB9BB,	{ 0xE5, 0xA4, 0x9F },
	0xB9BC,	{ 0xE8, 0xBE, 0x9C },
	0xB9BD,	{ 0xE8, 0x8F, 0x87 },
	0xB9BE,	{ 0xE5, 0x92, 0x95 },
	0xB9BF,	{ 0xE7, 0xAE, 0x8D },
	0xB9C0,	{ 0xE4, 0xBC, 0xB0 },
	0xB9C1,	{ 0xE6, 0xB2, 0xBD },
	0xB9C2,	{ 0xE5, 0xAD, 0xA4 },
	0xB9C3,	{ 0xE5, 0xA7, 0x91 },
	0xB9C4,	{ 0xE9, 0xBC, 0x93 },
	0xB9C5,	{ 0xE5, 0x8F, 0xA4 },
	0xB9C6,	{ 0xE8, 0x9B, 0x8A },
	0xB9C7,	{ 0xE9, 0xAA, 0xA8 },
	0xB9C8,	{ 0xE8, 0xB0, 0xB7 },
	0xB9C9,	{ 0xE8, 0x82, 0xA1 },
	0xB9CA,	{ 0xE6, 0x95, 0x85 },
	0xB9CB,	{ 0xE9, 0xA1, 0xBE },
	0xB9CC,	{ 0xE5, 0x9B, 0xBA },
	0xB9CD,	{ 0xE9, 0x9B, 0x87 },
	0xB9CE,	{ 0xE5, 0x88, 0xAE },
	0xB9CF,	{ 0xE7, 0x93, 0x9C },
	0xB9D0,	{ 0xE5, 0x89, 0x90 },
	0xB9D1,	{ 0xE5, 0xAF, 0xA1 },
	0xB9D2,	{ 0xE6, 0x8C, 0x82 },
	0xB9D3,	{ 0xE8, 0xA4, 0x82 },
	0xB9D4,	{ 0xE4, 0xB9, 0x96 },
	0xB9D5,	{ 0xE6, 0x8B, 0x90 },
	0xB9D6,	{ 0xE6, 0x80, 0xAA },
	0xB9D7,	{ 0xE6, 0xA3, 0xBA },
	0xB9D8,	{ 0xE5, 0x85, 0xB3 },
	0xB9D9,	{ 0xE5, 0xAE, 0x98 },
	0xB9DA,	{ 0xE5, 0x86, 0xA0 },
	0xB9DB,	{ 0xE8, 0xA7, 0x82 },
	0xB9DC,	{ 0xE7, 0xAE, 0xA1 },
	0xB9DD,	{ 0xE9, 0xA6, 0x86 },
	0xB9DE,	{ 0xE7, 0xBD, 0x90 },
	0xB9DF,	{ 0xE6, 0x83, 0xAF },
	0xB9E0,	{ 0xE7, 0x81, 0x8C },
	0xB9E1,	{ 0xE8, 0xB4, 0xAF },
	0xB9E2,	{ 0xE5, 0x85, 0x89 },
	0xB9E3,	{ 0xE5, 0xB9, 0xBF },
	0xB9E4,	{ 0xE9, 0x80, 0x9B },
	0xB9E5,	{ 0xE7, 0x91, 0xB0 },
	0xB9E6,	{ 0xE8, 0xA7, 0x84 },
	0xB9E7,	{ 0xE5, 0x9C, 0xAD },
	0xB9E8,	{ 0xE7, 0xA1, 0x85 },
	0xB9E9,	{ 0xE5, 0xBD, 0x92 },
	0xB9EA,	{ 0xE9, 0xBE, 0x9F },
	0xB9EB,	{ 0xE9, 0x97, 0xBA },
	0xB9EC,	{ 0xE8, 0xBD, 0xA8 },
	0xB9ED,	{ 0xE9, 0xAC, 0xBC },
	0xB9EE,	{ 0xE8, 0xAF, 0xA1 },
	0xB9EF,	{ 0xE7, 0x99, 0xB8 },
	0xB9F0,	{ 0xE6, 0xA1, 0x82 },
	0xB9F1,	{ 0xE6, 0x9F, 0x9C },
	0xB9F2,	{ 0xE8, 0xB7, 0xAA },
	0xB9F3,	{ 0xE8, 0xB4, 0xB5 },
	0xB9F4,	{ 0xE5, 0x88, 0xBD },
	0xB9F5,	{ 0xE8, 0xBE, 0x8A },
	0xB9F6,	{ 0xE6, 0xBB, 0x9A },
	0xB9F7,	{ 0xE6, 0xA3, 0x8D },
	0xB9F8,	{ 0xE9, 0x94, 0x85 },
	0xB9F9,	{ 0xE9, 0x83, 0xAD },
	0xB9FA,	{ 0xE5, 0x9B, 0xBD },
	0xB9FB,	{ 0xE6, 0x9E, 0x9C },
	0xB9FC,	{ 0xE8, 0xA3, 0xB9 },
	0xB9FD,	{ 0xE8, 0xBF, 0x87 },
	0xB9FE,	{ 0xE5, 0x93, 0x88 },
	0xBA40,	{ 0xE7, 0xAF, 0x85 },
	0xBA41,	{ 0xE7, 0xAF, 0x88 },
	0xBA42,	{ 0xE7, 0xAF, 0x89 },
	0xBA43,	{ 0xE7, 0xAF, 0x8A },
	0xBA44,	{ 0xE7, 0xAF, 0x8B },
	0xBA45,	{ 0xE7, 0xAF, 0x8D },
	0xBA46,	{ 0xE7, 0xAF, 0x8E },
	0xBA47,	{ 0xE7, 0xAF, 0x8F },
	0xBA48,	{ 0xE7, 0xAF, 0x90 },
	0xBA49,	{ 0xE7, 0xAF, 0x92 },
	0xBA4A,	{ 0xE7, 0xAF, 0x94 },
	0xBA4B,	{ 0xE7, 0xAF, 0x95 },
	0xBA4C,	{ 0xE7, 0xAF, 0x96 },
	0xBA4D,	{ 0xE7, 0xAF, 0x97 },
	0xBA4E,	{ 0xE7, 0xAF, 0x98 },
	0xBA4F,	{ 0xE7, 0xAF, 0x9B },
	0xBA50,	{ 0xE7, 0xAF, 0x9C },
	0xBA51,	{ 0xE7, 0xAF, 0x9E },
	0xBA52,	{ 0xE7, 0xAF, 0x9F },
	0xBA53,	{ 0xE7, 0xAF, 0xA0 },
	0xBA54,	{ 0xE7, 0xAF, 0xA2 },
	0xBA55,	{ 0xE7, 0xAF, 0xA3 },
	0xBA56,	{ 0xE7, 0xAF, 0xA4 },
	0xBA57,	{ 0xE7, 0xAF, 0xA7 },
	0xBA58,	{ 0xE7, 0xAF, 0xA8 },
	0xBA59,	{ 0xE7, 0xAF, 0xA9 },
	0xBA5A,	{ 0xE7, 0xAF, 0xAB },
	0xBA5B,	{ 0xE7, 0xAF, 0xAC },
	0xBA5C,	{ 0xE7, 0xAF, 0xAD },
	0xBA5D,	{ 0xE7, 0xAF, 0xAF },
	0xBA5E,	{ 0xE7, 0xAF, 0xB0 },
	0xBA5F,	{ 0xE7, 0xAF, 0xB2 },
	0xBA60,	{ 0xE7, 0xAF, 0xB3 },
	0xBA61,	{ 0xE7, 0xAF, 0xB4 },
	0xBA62,	{ 0xE7, 0xAF, 0xB5 },
	0xBA63,	{ 0xE7, 0xAF, 0xB6 },
	0xBA64,	{ 0xE7, 0xAF, 0xB8 },
	0xBA65,	{ 0xE7, 0xAF, 0xB9 },
	0xBA66,	{ 0xE7, 0xAF, 0xBA },
	0xBA67,	{ 0xE7, 0xAF, 0xBB },
	0xBA68,	{ 0xE7, 0xAF, 0xBD },
	0xBA69,	{ 0xE7, 0xAF, 0xBF },
	0xBA6A,	{ 0xE7, 0xB0, 0x80 },
	0xBA6B,	{ 0xE7, 0xB0, 0x81 },
	0xBA6C,	{ 0xE7, 0xB0, 0x82 },
	0xBA6D,	{ 0xE7, 0xB0, 0x83 },
	0xBA6E,	{ 0xE7, 0xB0, 0x84 },
	0xBA6F,	{ 0xE7, 0xB0, 0x85 },
	0xBA70,	{ 0xE7, 0xB0, 0x86 },
	0xBA71,	{ 0xE7, 0xB0, 0x88 },
	0xBA72,	{ 0xE7, 0xB0, 0x89 },
	0xBA73,	{ 0xE7, 0xB0, 0x8A },
	0xBA74,	{ 0xE7, 0xB0, 0x8D },
	0xBA75,	{ 0xE7, 0xB0, 0x8E },
	0xBA76,	{ 0xE7, 0xB0, 0x90 },
	0xBA77,	{ 0xE7, 0xB0, 0x91 },
	0xBA78,	{ 0xE7, 0xB0, 0x92 },
	0xBA79,	{ 0xE7, 0xB0, 0x93 },
	0xBA7A,	{ 0xE7, 0xB0, 0x94 },
	0xBA7B,	{ 0xE7, 0xB0, 0x95 },
	0xBA7C,	{ 0xE7, 0xB0, 0x97 },
	0xBA7D,	{ 0xE7, 0xB0, 0x98 },
	0xBA7E,	{ 0xE7, 0xB0, 0x99 },
	0xBA80,	{ 0xE7, 0xB0, 0x9A },
	0xBA81,	{ 0xE7, 0xB0, 0x9B },
	0xBA82,	{ 0xE7, 0xB0, 0x9C },
	0xBA83,	{ 0xE7, 0xB0, 0x9D },
	0xBA84,	{ 0xE7, 0xB0, 0x9E },
	0xBA85,	{ 0xE7, 0xB0, 0xA0 },
	0xBA86,	{ 0xE7, 0xB0, 0xA1 },
	0xBA87,	{ 0xE7, 0xB0, 0xA2 },
	0xBA88,	{ 0xE7, 0xB0, 0xA3 },
	0xBA89,	{ 0xE7, 0xB0, 0xA4 },
	0xBA8A,	{ 0xE7, 0xB0, 0xA5 },
	0xBA8B,	{ 0xE7, 0xB0, 0xA8 },
	0xBA8C,	{ 0xE7, 0xB0, 0xA9 },
	0xBA8D,	{ 0xE7, 0xB0, 0xAB },
	0xBA8E,	{ 0xE7, 0xB0, 0xAC },
	0xBA8F,	{ 0xE7, 0xB0, 0xAD },
	0xBA90,	{ 0xE7, 0xB0, 0xAE },
	0xBA91,	{ 0xE7, 0xB0, 0xAF },
	0xBA92,	{ 0xE7, 0xB0, 0xB0 },
	0xBA93,	{ 0xE7, 0xB0, 0xB1 },
	0xBA94,	{ 0xE7, 0xB0, 0xB2 },
	0xBA95,	{ 0xE7, 0xB0, 0xB3 },
	0xBA96,	{ 0xE7, 0xB0, 0xB4 },
	0xBA97,	{ 0xE7, 0xB0, 0xB5 },
	0xBA98,	{ 0xE7, 0xB0, 0xB6 },
	0xBA99,	{ 0xE7, 0xB0, 0xB7 },
	0xBA9A,	{ 0xE7, 0xB0, 0xB9 },
	0xBA9B,	{ 0xE7, 0xB0, 0xBA },
	0xBA9C,	{ 0xE7, 0xB0, 0xBB },
	0xBA9D,	{ 0xE7, 0xB0, 0xBC },
	0xBA9E,	{ 0xE7, 0xB0, 0xBD },
	0xBA9F,	{ 0xE7, 0xB0, 0xBE },
	0xBAA0,	{ 0xE7, 0xB1, 0x82 },
	0xBAA1,	{ 0xE9, 0xAA, 0xB8 },
	0xBAA2,	{ 0xE5, 0xAD, 0xA9 },
	0xBAA3,	{ 0xE6, 0xB5, 0xB7 },
	0xBAA4,	{ 0xE6, 0xB0, 0xA6 },
	0xBAA5,	{ 0xE4, 0xBA, 0xA5 },
	0xBAA6,	{ 0xE5, 0xAE, 0xB3 },
	0xBAA7,	{ 0xE9, 0xAA, 0x87 },
	0xBAA8,	{ 0xE9, 0x85, 0xA3 },
	0xBAA9,	{ 0xE6, 0x86, 0xA8 },
	0xBAAA,	{ 0xE9, 0x82, 0xAF },
	0xBAAB,	{ 0xE9, 0x9F, 0xA9 },
	0xBAAC,	{ 0xE5, 0x90, 0xAB },
	0xBAAD,	{ 0xE6, 0xB6, 0xB5 },
	0xBAAE,	{ 0xE5, 0xAF, 0x92 },
	0xBAAF,	{ 0xE5, 0x87, 0xBD },
	0xBAB0,	{ 0xE5, 0x96, 0x8A },
	0xBAB1,	{ 0xE7, 0xBD, 0x95 },
	0xBAB2,	{ 0xE7, 0xBF, 0xB0 },
	0xBAB3,	{ 0xE6, 0x92, 0xBC },
	0xBAB4,	{ 0xE6, 0x8D, 0x8D },
	0xBAB5,	{ 0xE6, 0x97, 0xB1 },
	0xBAB6,	{ 0xE6, 0x86, 0xBE },
	0xBAB7,	{ 0xE6, 0x82, 0x8D },
	0xBAB8,	{ 0xE7, 0x84, 0x8A },
	0xBAB9,	{ 0xE6, 0xB1, 0x97 },
	0xBABA,	{ 0xE6, 0xB1, 0x89 },
	0xBABB,	{ 0xE5, 0xA4, 0xAF },
	0xBABC,	{ 0xE6, 0x9D, 0xAD },
	0xBABD,	{ 0xE8, 0x88, 0xAA },
	0xBABE,	{ 0xE5, 0xA3, 0x95 },
	0xBABF,	{ 0xE5, 0x9A, 0x8E },
	0xBAC0,	{ 0xE8, 0xB1, 0xAA },
	0xBAC1,	{ 0xE6, 0xAF, 0xAB },
	0xBAC2,	{ 0xE9, 0x83, 0x9D },
	0xBAC3,	{ 0xE5, 0xA5, 0xBD },
	0xBAC4,	{ 0xE8, 0x80, 0x97 },
	0xBAC5,	{ 0xE5, 0x8F, 0xB7 },
	0xBAC6,	{ 0xE6, 0xB5, 0xA9 },
	0xBAC7,	{ 0xE5, 0x91, 0xB5 },
	0xBAC8,	{ 0xE5, 0x96, 0x9D },
	0xBAC9,	{ 0xE8, 0x8D, 0xB7 },
	0xBACA,	{ 0xE8, 0x8F, 0x8F },
	0xBACB,	{ 0xE6, 0xA0, 0xB8 },
	0xBACC,	{ 0xE7, 0xA6, 0xBE },
	0xBACD,	{ 0xE5, 0x92, 0x8C },
	0xBACE,	{ 0xE4, 0xBD, 0x95 },
	0xBACF,	{ 0xE5, 0x90, 0x88 },
	0xBAD0,	{ 0xE7, 0x9B, 0x92 },
	0xBAD1,	{ 0xE8, 0xB2, 0x89 },
	0xBAD2,	{ 0xE9, 0x98, 0x82 },
	0xBAD3,	{ 0xE6, 0xB2, 0xB3 },
	0xBAD4,	{ 0xE6, 0xB6, 0xB8 },
	0xBAD5,	{ 0xE8, 0xB5, 0xAB },
	0xBAD6,	{ 0xE8, 0xA4, 0x90 },
	0xBAD7,	{ 0xE9, 0xB9, 0xA4 },
	0xBAD8,	{ 0xE8, 0xB4, 0xBA },
	0xBAD9,	{ 0xE5, 0x98, 0xBF },
	0xBADA,	{ 0xE9, 0xBB, 0x91 },
	0xBADB,	{ 0xE7, 0x97, 0x95 },
	0xBADC,	{ 0xE5, 0xBE, 0x88 },
	0xBADD,	{ 0xE7, 0x8B, 0xA0 },
	0xBADE,	{ 0xE6, 0x81, 0xA8 },
	0xBADF,	{ 0xE5, 0x93, 0xBC },
	0xBAE0,	{ 0xE4, 0xBA, 0xA8 },
	0xBAE1,	{ 0xE6, 0xA8, 0xAA },
	0xBAE2,	{ 0xE8, 0xA1, 0xA1 },
	0xBAE3,	{ 0xE6, 0x81, 0x92 },
	0xBAE4,	{ 0xE8, 0xBD, 0xB0 },
	0xBAE5,	{ 0xE5, 0x93, 0x84 },
	0xBAE6,	{ 0xE7, 0x83, 0x98 },
	0xBAE7,	{ 0xE8, 0x99, 0xB9 },
	0xBAE8,	{ 0xE9, 0xB8, 0xBF },
	0xBAE9,	{ 0xE6, 0xB4, 0xAA },
	0xBAEA,	{ 0xE5, 0xAE, 0x8F },
	0xBAEB,	{ 0xE5, 0xBC, 0x98 },
	0xBAEC,	{ 0xE7, 0xBA, 0xA2 },
	0xBAED,	{ 0xE5, 0x96, 0x89 },
	0xBAEE,	{ 0xE4, 0xBE, 0xAF },
	0xBAEF,	{ 0xE7, 0x8C, 0xB4 },
	0xBAF0,	{ 0xE5, 0x90, 0xBC },
	0xBAF1,	{ 0xE5, 0x8E, 0x9A },
	0xBAF2,	{ 0xE5, 0x80, 0x99 },
	0xBAF3,	{ 0xE5, 0x90, 0x8E },
	0xBAF4,	{ 0xE5, 0x91, 0xBC },
	0xBAF5,	{ 0xE4, 0xB9, 0x8E },
	0xBAF6,	{ 0xE5, 0xBF, 0xBD },
	0xBAF7,	{ 0xE7, 0x91, 0x9A },
	0xBAF8,	{ 0xE5, 0xA3, 0xB6 },
	0xBAF9,	{ 0xE8, 0x91, 0xAB },
	0xBAFA,	{ 0xE8, 0x83, 0xA1 },
	0xBAFB,	{ 0xE8, 0x9D, 0xB4 },
	0xBAFC,	{ 0xE7, 0x8B, 0x90 },
	0xBAFD,	{ 0xE7, 0xB3, 0x8A },
	0xBAFE,	{ 0xE6, 0xB9, 0x96 },
	0xBB40,	{ 0xE7, 0xB1, 0x83 },
	0xBB41,	{ 0xE7, 0xB1, 0x84 },
	0xBB42,	{ 0xE7, 0xB1, 0x85 },
	0xBB43,	{ 0xE7, 0xB1, 0x86 },
	0xBB44,	{ 0xE7, 0xB1, 0x87 },
	0xBB45,	{ 0xE7, 0xB1, 0x88 },
	0xBB46,	{ 0xE7, 0xB1, 0x89 },
	0xBB47,	{ 0xE7, 0xB1, 0x8A },
	0xBB48,	{ 0xE7, 0xB1, 0x8B },
	0xBB49,	{ 0xE7, 0xB1, 0x8C },
	0xBB4A,	{ 0xE7, 0xB1, 0x8E },
	0xBB4B,	{ 0xE7, 0xB1, 0x8F },
	0xBB4C,	{ 0xE7, 0xB1, 0x90 },
	0xBB4D,	{ 0xE7, 0xB1, 0x91 },
	0xBB4E,	{ 0xE7, 0xB1, 0x92 },
	0xBB4F,	{ 0xE7, 0xB1, 0x93 },
	0xBB50,	{ 0xE7, 0xB1, 0x94 },
	0xBB51,	{ 0xE7, 0xB1, 0x95 },
	0xBB52,	{ 0xE7, 0xB1, 0x96 },
	0xBB53,	{ 0xE7, 0xB1, 0x97 },
	0xBB54,	{ 0xE7, 0xB1, 0x98 },
	0xBB55,	{ 0xE7, 0xB1, 0x99 },
	0xBB56,	{ 0xE7, 0xB1, 0x9A },
	0xBB57,	{ 0xE7, 0xB1, 0x9B },
	0xBB58,	{ 0xE7, 0xB1, 0x9C },
	0xBB59,	{ 0xE7, 0xB1, 0x9D },
	0xBB5A,	{ 0xE7, 0xB1, 0x9E },
	0xBB5B,	{ 0xE7, 0xB1, 0x9F },
	0xBB5C,	{ 0xE7, 0xB1, 0xA0 },
	0xBB5D,	{ 0xE7, 0xB1, 0xA1 },
	0xBB5E,	{ 0xE7, 0xB1, 0xA2 },
	0xBB5F,	{ 0xE7, 0xB1, 0xA3 },
	0xBB60,	{ 0xE7, 0xB1, 0xA4 },
	0xBB61,	{ 0xE7, 0xB1, 0xA5 },
	0xBB62,	{ 0xE7, 0xB1, 0xA6 },
	0xBB63,	{ 0xE7, 0xB1, 0xA7 },
	0xBB64,	{ 0xE7, 0xB1, 0xA8 },
	0xBB65,	{ 0xE7, 0xB1, 0xA9 },
	0xBB66,	{ 0xE7, 0xB1, 0xAA },
	0xBB67,	{ 0xE7, 0xB1, 0xAB },
	0xBB68,	{ 0xE7, 0xB1, 0xAC },
	0xBB69,	{ 0xE7, 0xB1, 0xAD },
	0xBB6A,	{ 0xE7, 0xB1, 0xAE },
	0xBB6B,	{ 0xE7, 0xB1, 0xAF },
	0xBB6C,	{ 0xE7, 0xB1, 0xB0 },
	0xBB6D,	{ 0xE7, 0xB1, 0xB1 },
	0xBB6E,	{ 0xE7, 0xB1, 0xB2 },
	0xBB6F,	{ 0xE7, 0xB1, 0xB5 },
	0xBB70,	{ 0xE7, 0xB1, 0xB6 },
	0xBB71,	{ 0xE7, 0xB1, 0xB7 },
	0xBB72,	{ 0xE7, 0xB1, 0xB8 },
	0xBB73,	{ 0xE7, 0xB1, 0xB9 },
	0xBB74,	{ 0xE7, 0xB1, 0xBA },
	0xBB75,	{ 0xE7, 0xB1, 0xBE },
	0xBB76,	{ 0xE7, 0xB1, 0xBF },
	0xBB77,	{ 0xE7, 0xB2, 0x80 },
	0xBB78,	{ 0xE7, 0xB2, 0x81 },
	0xBB79,	{ 0xE7, 0xB2, 0x82 },
	0xBB7A,	{ 0xE7, 0xB2, 0x83 },
	0xBB7B,	{ 0xE7, 0xB2, 0x84 },
	0xBB7C,	{ 0xE7, 0xB2, 0x85 },
	0xBB7D,	{ 0xE7, 0xB2, 0x86 },
	0xBB7E,	{ 0xE7, 0xB2, 0x87 },
	0xBB80,	{ 0xE7, 0xB2, 0x88 },
	0xBB81,	{ 0xE7, 0xB2, 0x8A },
	0xBB82,	{ 0xE7, 0xB2, 0x8B },
	0xBB83,	{ 0xE7, 0xB2, 0x8C },
	0xBB84,	{ 0xE7, 0xB2, 0x8D },
	0xBB85,	{ 0xE7, 0xB2, 0x8E },
	0xBB86,	{ 0xE7, 0xB2, 0x8F },
	0xBB87,	{ 0xE7, 0xB2, 0x90 },
	0xBB88,	{ 0xE7, 0xB2, 0x93 },
	0xBB89,	{ 0xE7, 0xB2, 0x94 },
	0xBB8A,	{ 0xE7, 0xB2, 0x96 },
	0xBB8B,	{ 0xE7, 0xB2, 0x99 },
	0xBB8C,	{ 0xE7, 0xB2, 0x9A },
	0xBB8D,	{ 0xE7, 0xB2, 0x9B },
	0xBB8E,	{ 0xE7, 0xB2, 0xA0 },
	0xBB8F,	{ 0xE7, 0xB2, 0xA1 },
	0xBB90,	{ 0xE7, 0xB2, 0xA3 },
	0xBB91,	{ 0xE7, 0xB2, 0xA6 },
	0xBB92,	{ 0xE7, 0xB2, 0xA7 },
	0xBB93,	{ 0xE7, 0xB2, 0xA8 },
	0xBB94,	{ 0xE7, 0xB2, 0xA9 },
	0xBB95,	{ 0xE7, 0xB2, 0xAB },
	0xBB96,	{ 0xE7, 0xB2, 0xAC },
	0xBB97,	{ 0xE7, 0xB2, 0xAD },
	0xBB98,	{ 0xE7, 0xB2, 0xAF },
	0xBB99,	{ 0xE7, 0xB2, 0xB0 },
	0xBB9A,	{ 0xE7, 0xB2, 0xB4 },
	0xBB9B,	{ 0xE7, 0xB2, 0xB5 },
	0xBB9C,	{ 0xE7, 0xB2, 0xB6 },
	0xBB9D,	{ 0xE7, 0xB2, 0xB7 },
	0xBB9E,	{ 0xE7, 0xB2, 0xB8 },
	0xBB9F,	{ 0xE7, 0xB2, 0xBA },
	0xBBA0,	{ 0xE7, 0xB2, 0xBB },
	0xBBA1,	{ 0xE5, 0xBC, 0xA7 },
	0xBBA2,	{ 0xE8, 0x99, 0x8E },
	0xBBA3,	{ 0xE5, 0x94, 0xAC },
	0xBBA4,	{ 0xE6, 0x8A, 0xA4 },
	0xBBA5,	{ 0xE4, 0xBA, 0x92 },
	0xBBA6,	{ 0xE6, 0xB2, 0xAA },
	0xBBA7,	{ 0xE6, 0x88, 0xB7 },
	0xBBA8,	{ 0xE8, 0x8A, 0xB1 },
	0xBBA9,	{ 0xE5, 0x93, 0x97 },
	0xBBAA,	{ 0xE5, 0x8D, 0x8E },
	0xBBAB,	{ 0xE7, 0x8C, 0xBE },
	0xBBAC,	{ 0xE6, 0xBB, 0x91 },
	0xBBAD,	{ 0xE7, 0x94, 0xBB },
	0xBBAE,	{ 0xE5, 0x88, 0x92 },
	0xBBAF,	{ 0xE5, 0x8C, 0x96 },
	0xBBB0,	{ 0xE8, 0xAF, 0x9D },
	0xBBB1,	{ 0xE6, 0xA7, 0x90 },
	0xBBB2,	{ 0xE5, 0xBE, 0x8A },
	0xBBB3,	{ 0xE6, 0x80, 0x80 },
	0xBBB4,	{ 0xE6, 0xB7, 0xAE },
	0xBBB5,	{ 0xE5, 0x9D, 0x8F },
	0xBBB6,	{ 0xE6, 0xAC, 0xA2 },
	0xBBB7,	{ 0xE7, 0x8E, 0xAF },
	0xBBB8,	{ 0xE6, 0xA1, 0x93 },
	0xBBB9,	{ 0xE8, 0xBF, 0x98 },
	0xBBBA,	{ 0xE7, 0xBC, 0x93 },
	0xBBBB,	{ 0xE6, 0x8D, 0xA2 },
	0xBBBC,	{ 0xE6, 0x82, 0xA3 },
	0xBBBD,	{ 0xE5, 0x94, 0xA4 },
	0xBBBE,	{ 0xE7, 0x97, 0xAA },
	0xBBBF,	{ 0xE8, 0xB1, 0xA2 },
	0xBBC0,	{ 0xE7, 0x84, 0x95 },
	0xBBC1,	{ 0xE6, 0xB6, 0xA3 },
	0xBBC2,	{ 0xE5, 0xAE, 0xA6 },
	0xBBC3,	{ 0xE5, 0xB9, 0xBB },
	0xBBC4,	{ 0xE8, 0x8D, 0x92 },
	0xBBC5,	{ 0xE6, 0x85, 0x8C },
	0xBBC6,	{ 0xE9, 0xBB, 0x84 },
	0xBBC7,	{ 0xE7, 0xA3, 0xBA },
	0xBBC8,	{ 0xE8, 0x9D, 0x97 },
	0xBBC9,	{ 0xE7, 0xB0, 0xA7 },
	0xBBCA,	{ 0xE7, 0x9A, 0x87 },
	0xBBCB,	{ 0xE5, 0x87, 0xB0 },
	0xBBCC,	{ 0xE6, 0x83, 0xB6 },
	0xBBCD,	{ 0xE7, 0x85, 0x8C },
	0xBBCE,	{ 0xE6, 0x99, 0x83 },
	0xBBCF,	{ 0xE5, 0xB9, 0x8C },
	0xBBD0,	{ 0xE6, 0x81, 0x8D },
	0xBBD1,	{ 0xE8, 0xB0, 0x8E },
	0xBBD2,	{ 0xE7, 0x81, 0xB0 },
	0xBBD3,	{ 0xE6, 0x8C, 0xA5 },
	0xBBD4,	{ 0xE8, 0xBE, 0x89 },
	0xBBD5,	{ 0xE5, 0xBE, 0xBD },
	0xBBD6,	{ 0xE6, 0x81, 0xA2 },
	0xBBD7,	{ 0xE8, 0x9B, 0x94 },
	0xBBD8,	{ 0xE5, 0x9B, 0x9E },
	0xBBD9,	{ 0xE6, 0xAF, 0x81 },
	0xBBDA,	{ 0xE6, 0x82, 0x94 },
	0xBBDB,	{ 0xE6, 0x85, 0xA7 },
	0xBBDC,	{ 0xE5, 0x8D, 0x89 },
	0xBBDD,	{ 0xE6, 0x83, 0xA0 },
	0xBBDE,	{ 0xE6, 0x99, 0xA6 },
	0xBBDF,	{ 0xE8, 0xB4, 0xBF },
	0xBBE0,	{ 0xE7, 0xA7, 0xBD },
	0xBBE1,	{ 0xE4, 0xBC, 0x9A },
	0xBBE2,	{ 0xE7, 0x83, 0xA9 },
	0xBBE3,	{ 0xE6, 0xB1, 0x87 },
	0xBBE4,	{ 0xE8, 0xAE, 0xB3 },
	0xBBE5,	{ 0xE8, 0xAF, 0xB2 },
	0xBBE6,	{ 0xE7, 0xBB, 0x98 },
	0xBBE7,	{ 0xE8, 0x8D, 0xA4 },
	0xBBE8,	{ 0xE6, 0x98, 0x8F },
	0xBBE9,	{ 0xE5, 0xA9, 0x9A },
	0xBBEA,	{ 0xE9, 0xAD, 0x82 },
	0xBBEB,	{ 0xE6, 0xB5, 0x91 },
	0xBBEC,	{ 0xE6, 0xB7, 0xB7 },
	0xBBED,	{ 0xE8, 0xB1, 0x81 },
	0xBBEE,	{ 0xE6, 0xB4, 0xBB },
	0xBBEF,	{ 0xE4, 0xBC, 0x99 },
	0xBBF0,	{ 0xE7, 0x81, 0xAB },
	0xBBF1,	{ 0xE8, 0x8E, 0xB7 },
	0xBBF2,	{ 0xE6, 0x88, 0x96 },
	0xBBF3,	{ 0xE6, 0x83, 0x91 },
	0xBBF4,	{ 0xE9, 0x9C, 0x8D },
	0xBBF5,	{ 0xE8, 0xB4, 0xA7 },
	0xBBF6,	{ 0xE7, 0xA5, 0xB8 },
	0xBBF7,	{ 0xE5, 0x87, 0xBB },
	0xBBF8,	{ 0xE5, 0x9C, 0xBE },
	0xBBF9,	{ 0xE5, 0x9F, 0xBA },
	0xBBFA,	{ 0xE6, 0x9C, 0xBA },
	0xBBFB,	{ 0xE7, 0x95, 0xB8 },
	0xBBFC,	{ 0xE7, 0xA8, 0xBD },
	0xBBFD,	{ 0xE7, 0xA7, 0xAF },
	0xBBFE,	{ 0xE7, 0xAE, 0x95 },
	0xBC40,	{ 0xE7, 0xB2, 0xBF },
	0xBC41,	{ 0xE7, 0xB3, 0x80 },
	0xBC42,	{ 0xE7, 0xB3, 0x82 },
	0xBC43,	{ 0xE7, 0xB3, 0x83 },
	0xBC44,	{ 0xE7, 0xB3, 0x84 },
	0xBC45,	{ 0xE7, 0xB3, 0x86 },
	0xBC46,	{ 0xE7, 0xB3, 0x89 },
	0xBC47,	{ 0xE7, 0xB3, 0x8B },
	0xBC48,	{ 0xE7, 0xB3, 0x8E },
	0xBC49,	{ 0xE7, 0xB3, 0x8F },
	0xBC4A,	{ 0xE7, 0xB3, 0x90 },
	0xBC4B,	{ 0xE7, 0xB3, 0x91 },
	0xBC4C,	{ 0xE7, 0xB3, 0x92 },
	0xBC4D,	{ 0xE7, 0xB3, 0x93 },
	0xBC4E,	{ 0xE7, 0xB3, 0x94 },
	0xBC4F,	{ 0xE7, 0xB3, 0x98 },
	0xBC50,	{ 0xE7, 0xB3, 0x9A },
	0xBC51,	{ 0xE7, 0xB3, 0x9B },
	0xBC52,	{ 0xE7, 0xB3, 0x9D },
	0xBC53,	{ 0xE7, 0xB3, 0x9E },
	0xBC54,	{ 0xE7, 0xB3, 0xA1 },
	0xBC55,	{ 0xE7, 0xB3, 0xA2 },
	0xBC56,	{ 0xE7, 0xB3, 0xA3 },
	0xBC57,	{ 0xE7, 0xB3, 0xA4 },
	0xBC58,	{ 0xE7, 0xB3, 0xA5 },
	0xBC59,	{ 0xE7, 0xB3, 0xA6 },
	0xBC5A,	{ 0xE7, 0xB3, 0xA7 },
	0xBC5B,	{ 0xE7, 0xB3, 0xA9 },
	0xBC5C,	{ 0xE7, 0xB3, 0xAA },
	0xBC5D,	{ 0xE7, 0xB3, 0xAB },
	0xBC5E,	{ 0xE7, 0xB3, 0xAC },
	0xBC5F,	{ 0xE7, 0xB3, 0xAD },
	0xBC60,	{ 0xE7, 0xB3, 0xAE },
	0xBC61,	{ 0xE7, 0xB3, 0xB0 },
	0xBC62,	{ 0xE7, 0xB3, 0xB1 },
	0xBC63,	{ 0xE7, 0xB3, 0xB2 },
	0xBC64,	{ 0xE7, 0xB3, 0xB3 },
	0xBC65,	{ 0xE7, 0xB3, 0xB4 },
	0xBC66,	{ 0xE7, 0xB3, 0xB5 },
	0xBC67,	{ 0xE7, 0xB3, 0xB6 },
	0xBC68,	{ 0xE7, 0xB3, 0xB7 },
	0xBC69,	{ 0xE7, 0xB3, 0xB9 },
	0xBC6A,	{ 0xE7, 0xB3, 0xBA },
	0xBC6B,	{ 0xE7, 0xB3, 0xBC },
	0xBC6C,	{ 0xE7, 0xB3, 0xBD },
	0xBC6D,	{ 0xE7, 0xB3, 0xBE },
	0xBC6E,	{ 0xE7, 0xB3, 0xBF },
	0xBC6F,	{ 0xE7, 0xB4, 0x80 },
	0xBC70,	{ 0xE7, 0xB4, 0x81 },
	0xBC71,	{ 0xE7, 0xB4, 0x82 },
	0xBC72,	{ 0xE7, 0xB4, 0x83 },
	0xBC73,	{ 0xE7, 0xB4, 0x84 },
	0xBC74,	{ 0xE7, 0xB4, 0x85 },
	0xBC75,	{ 0xE7, 0xB4, 0x86 },
	0xBC76,	{ 0xE7, 0xB4, 0x87 },
	0xBC77,	{ 0xE7, 0xB4, 0x88 },
	0xBC78,	{ 0xE7, 0xB4, 0x89 },
	0xBC79,	{ 0xE7, 0xB4, 0x8B },
	0xBC7A,	{ 0xE7, 0xB4, 0x8C },
	0xBC7B,	{ 0xE7, 0xB4, 0x8D },
	0xBC7C,	{ 0xE7, 0xB4, 0x8E },
	0xBC7D,	{ 0xE7, 0xB4, 0x8F },
	0xBC7E,	{ 0xE7, 0xB4, 0x90 },
	0xBC80,	{ 0xE7, 0xB4, 0x91 },
	0xBC81,	{ 0xE7, 0xB4, 0x92 },
	0xBC82,	{ 0xE7, 0xB4, 0x93 },
	0xBC83,	{ 0xE7, 0xB4, 0x94 },
	0xBC84,	{ 0xE7, 0xB4, 0x95 },
	0xBC85,	{ 0xE7, 0xB4, 0x96 },
	0xBC86,	{ 0xE7, 0xB4, 0x97 },
	0xBC87,	{ 0xE7, 0xB4, 0x98 },
	0xBC88,	{ 0xE7, 0xB4, 0x99 },
	0xBC89,	{ 0xE7, 0xB4, 0x9A },
	0xBC8A,	{ 0xE7, 0xB4, 0x9B },
	0xBC8B,	{ 0xE7, 0xB4, 0x9C },
	0xBC8C,	{ 0xE7, 0xB4, 0x9D },
	0xBC8D,	{ 0xE7, 0xB4, 0x9E },
	0xBC8E,	{ 0xE7, 0xB4, 0x9F },
	0xBC8F,	{ 0xE7, 0xB4, 0xA1 },
	0xBC90,	{ 0xE7, 0xB4, 0xA3 },
	0xBC91,	{ 0xE7, 0xB4, 0xA4 },
	0xBC92,	{ 0xE7, 0xB4, 0xA5 },
	0xBC93,	{ 0xE7, 0xB4, 0xA6 },
	0xBC94,	{ 0xE7, 0xB4, 0xA8 },
	0xBC95,	{ 0xE7, 0xB4, 0xA9 },
	0xBC96,	{ 0xE7, 0xB4, 0xAA },
	0xBC97,	{ 0xE7, 0xB4, 0xAC },
	0xBC98,	{ 0xE7, 0xB4, 0xAD },
	0xBC99,	{ 0xE7, 0xB4, 0xAE },
	0xBC9A,	{ 0xE7, 0xB4, 0xB0 },
	0xBC9B,	{ 0xE7, 0xB4, 0xB1 },
	0xBC9C,	{ 0xE7, 0xB4, 0xB2 },
	0xBC9D,	{ 0xE7, 0xB4, 0xB3 },
	0xBC9E,	{ 0xE7, 0xB4, 0xB4 },
	0xBC9F,	{ 0xE7, 0xB4, 0xB5 },
	0xBCA0,	{ 0xE7, 0xB4, 0xB6 },
	0xBCA1,	{ 0xE8, 0x82, 0x8C },
	0xBCA2,	{ 0xE9, 0xA5, 0xA5 },
	0xBCA3,	{ 0xE8, 0xBF, 0xB9 },
	0xBCA4,	{ 0xE6, 0xBF, 0x80 },
	0xBCA5,	{ 0xE8, 0xAE, 0xA5 },
	0xBCA6,	{ 0xE9, 0xB8, 0xA1 },
	0xBCA7,	{ 0xE5, 0xA7, 0xAC },
	0xBCA8,	{ 0xE7, 0xBB, 0xA9 },
	0xBCA9,	{ 0xE7, 0xBC, 0x89 },
	0xBCAA,	{ 0xE5, 0x90, 0x89 },
	0xBCAB,	{ 0xE6, 0x9E, 0x81 },
	0xBCAC,	{ 0xE6, 0xA3, 0x98 },
	0xBCAD,	{ 0xE8, 0xBE, 0x91 },
	0xBCAE,	{ 0xE7, 0xB1, 0x8D },
	0xBCAF,	{ 0xE9, 0x9B, 0x86 },
	0xBCB0,	{ 0xE5, 0x8F, 0x8A },
	0xBCB1,	{ 0xE6, 0x80, 0xA5 },
	0xBCB2,	{ 0xE7, 0x96, 0xBE },
	0xBCB3,	{ 0xE6, 0xB1, 0xB2 },
	0xBCB4,	{ 0xE5, 0x8D, 0xB3 },
	0xBCB5,	{ 0xE5, 0xAB, 0x89 },
	0xBCB6,	{ 0xE7, 0xBA, 0xA7 },
	0xBCB7,	{ 0xE6, 0x8C, 0xA4 },
	0xBCB8,	{ 0xE5, 0x87, 0xA0 },
	0xBCB9,	{ 0xE8, 0x84, 0x8A },
	0xBCBA,	{ 0xE5, 0xB7, 0xB1 },
	0xBCBB,	{ 0xE8, 0x93, 0x9F },
	0xBCBC,	{ 0xE6, 0x8A, 0x80 },
	0xBCBD,	{ 0xE5, 0x86, 0x80 },
	0xBCBE,	{ 0xE5, 0xAD, 0xA3 },
	0xBCBF,	{ 0xE4, 0xBC, 0x8E },
	0xBCC0,	{ 0xE7, 0xA5, 0xAD },
	0xBCC1,	{ 0xE5, 0x89, 0x82 },
	0xBCC2,	{ 0xE6, 0x82, 0xB8 },
	0xBCC3,	{ 0xE6, 0xB5, 0x8E },
	0xBCC4,	{ 0xE5, 0xAF, 0x84 },
	0xBCC5,	{ 0xE5, 0xAF, 0x82 },
	0xBCC6,	{ 0xE8, 0xAE, 0xA1 },
	0xBCC7,	{ 0xE8, 0xAE, 0xB0 },
	0xBCC8,	{ 0xE6, 0x97, 0xA2 },
	0xBCC9,	{ 0xE5, 0xBF, 0x8C },
	0xBCCA,	{ 0xE9, 0x99, 0x85 },
	0xBCCB,	{ 0xE5, 0xA6, 0x93 },
	0xBCCC,	{ 0xE7, 0xBB, 0xA7 },
	0xBCCD,	{ 0xE7, 0xBA, 0xAA },
	0xBCCE,	{ 0xE5, 0x98, 0x89 },
	0xBCCF,	{ 0xE6, 0x9E, 0xB7 },
	0xBCD0,	{ 0xE5, 0xA4, 0xB9 },
	0xBCD1,	{ 0xE4, 0xBD, 0xB3 },
	0xBCD2,	{ 0xE5, 0xAE, 0xB6 },
	0xBCD3,	{ 0xE5, 0x8A, 0xA0 },
	0xBCD4,	{ 0xE8, 0x8D, 0x9A },
	0xBCD5,	{ 0xE9, 0xA2, 0x8A },
	0xBCD6,	{ 0xE8, 0xB4, 0xBE },
	0xBCD7,	{ 0xE7, 0x94, 0xB2 },
	0xBCD8,	{ 0xE9, 0x92, 0xBE },
	0xBCD9,	{ 0xE5, 0x81, 0x87 },
	0xBCDA,	{ 0xE7, 0xA8, 0xBC },
	0xBCDB,	{ 0xE4, 0xBB, 0xB7 },
	0xBCDC,	{ 0xE6, 0x9E, 0xB6 },
	0xBCDD,	{ 0xE9, 0xA9, 0xBE },
	0xBCDE,	{ 0xE5, 0xAB, 0x81 },
	0xBCDF,	{ 0xE6, 0xAD, 0xBC },
	0xBCE0,	{ 0xE7, 0x9B, 0x91 },
	0xBCE1,	{ 0xE5, 0x9D, 0x9A },
	0xBCE2,	{ 0xE5, 0xB0, 0x96 },
	0xBCE3,	{ 0xE7, 0xAC, 0xBA },
	0xBCE4,	{ 0xE9, 0x97, 0xB4 },
	0xBCE5,	{ 0xE7, 0x85, 0x8E },
	0xBCE6,	{ 0xE5, 0x85, 0xBC },
	0xBCE7,	{ 0xE8, 0x82, 0xA9 },
	0xBCE8,	{ 0xE8, 0x89, 0xB0 },
	0xBCE9,	{ 0xE5, 0xA5, 0xB8 },
	0xBCEA,	{ 0xE7, 0xBC, 0x84 },
	0xBCEB,	{ 0xE8, 0x8C, 0xA7 },
	0xBCEC,	{ 0xE6, 0xA3, 0x80 },
	0xBCED,	{ 0xE6, 0x9F, 0xAC },
	0xBCEE,	{ 0xE7, 0xA2, 0xB1 },
	0xBCEF,	{ 0xE7, 0xA1, 0xB7 },
	0xBCF0,	{ 0xE6, 0x8B, 0xA3 },
	0xBCF1,	{ 0xE6, 0x8D, 0xA1 },
	0xBCF2,	{ 0xE7, 0xAE, 0x80 },
	0xBCF3,	{ 0xE4, 0xBF, 0xAD },
	0xBCF4,	{ 0xE5, 0x89, 0xAA },
	0xBCF5,	{ 0xE5, 0x87, 0x8F },
	0xBCF6,	{ 0xE8, 0x8D, 0x90 },
	0xBCF7,	{ 0xE6, 0xA7, 0x9B },
	0xBCF8,	{ 0xE9, 0x89, 0xB4 },
	0xBCF9,	{ 0xE8, 0xB7, 0xB5 },
	0xBCFA,	{ 0xE8, 0xB4, 0xB1 },
	0xBCFB,	{ 0xE8, 0xA7, 0x81 },
	0xBCFC,	{ 0xE9, 0x94, 0xAE },
	0xBCFD,	{ 0xE7, 0xAE, 0xAD },
	0xBCFE,	{ 0xE4, 0xBB, 0xB6 },
	0xBD40,	{ 0xE7, 0xB4, 0xB7 },
	0xBD41,	{ 0xE7, 0xB4, 0xB8 },
	0xBD42,	{ 0xE7, 0xB4, 0xB9 },
	0xBD43,	{ 0xE7, 0xB4, 0xBA },
	0xBD44,	{ 0xE7, 0xB4, 0xBB },
	0xBD45,	{ 0xE7, 0xB4, 0xBC },
	0xBD46,	{ 0xE7, 0xB4, 0xBD },
	0xBD47,	{ 0xE7, 0xB4, 0xBE },
	0xBD48,	{ 0xE7, 0xB4, 0xBF },
	0xBD49,	{ 0xE7, 0xB5, 0x80 },
	0xBD4A,	{ 0xE7, 0xB5, 0x81 },
	0xBD4B,	{ 0xE7, 0xB5, 0x82 },
	0xBD4C,	{ 0xE7, 0xB5, 0x83 },
	0xBD4D,	{ 0xE7, 0xB5, 0x84 },
	0xBD4E,	{ 0xE7, 0xB5, 0x85 },
	0xBD4F,	{ 0xE7, 0xB5, 0x86 },
	0xBD50,	{ 0xE7, 0xB5, 0x87 },
	0xBD51,	{ 0xE7, 0xB5, 0x88 },
	0xBD52,	{ 0xE7, 0xB5, 0x89 },
	0xBD53,	{ 0xE7, 0xB5, 0x8A },
	0xBD54,	{ 0xE7, 0xB5, 0x8B },
	0xBD55,	{ 0xE7, 0xB5, 0x8C },
	0xBD56,	{ 0xE7, 0xB5, 0x8D },
	0xBD57,	{ 0xE7, 0xB5, 0x8E },
	0xBD58,	{ 0xE7, 0xB5, 0x8F },
	0xBD59,	{ 0xE7, 0xB5, 0x90 },
	0xBD5A,	{ 0xE7, 0xB5, 0x91 },
	0xBD5B,	{ 0xE7, 0xB5, 0x92 },
	0xBD5C,	{ 0xE7, 0xB5, 0x93 },
	0xBD5D,	{ 0xE7, 0xB5, 0x94 },
	0xBD5E,	{ 0xE7, 0xB5, 0x95 },
	0xBD5F,	{ 0xE7, 0xB5, 0x96 },
	0xBD60,	{ 0xE7, 0xB5, 0x97 },
	0xBD61,	{ 0xE7, 0xB5, 0x98 },
	0xBD62,	{ 0xE7, 0xB5, 0x99 },
	0xBD63,	{ 0xE7, 0xB5, 0x9A },
	0xBD64,	{ 0xE7, 0xB5, 0x9B },
	0xBD65,	{ 0xE7, 0xB5, 0x9C },
	0xBD66,	{ 0xE7, 0xB5, 0x9D },
	0xBD67,	{ 0xE7, 0xB5, 0x9E },
	0xBD68,	{ 0xE7, 0xB5, 0x9F },
	0xBD69,	{ 0xE7, 0xB5, 0xA0 },
	0xBD6A,	{ 0xE7, 0xB5, 0xA1 },
	0xBD6B,	{ 0xE7, 0xB5, 0xA2 },
	0xBD6C,	{ 0xE7, 0xB5, 0xA3 },
	0xBD6D,	{ 0xE7, 0xB5, 0xA4 },
	0xBD6E,	{ 0xE7, 0xB5, 0xA5 },
	0xBD6F,	{ 0xE7, 0xB5, 0xA6 },
	0xBD70,	{ 0xE7, 0xB5, 0xA7 },
	0xBD71,	{ 0xE7, 0xB5, 0xA8 },
	0xBD72,	{ 0xE7, 0xB5, 0xA9 },
	0xBD73,	{ 0xE7, 0xB5, 0xAA },
	0xBD74,	{ 0xE7, 0xB5, 0xAB },
	0xBD75,	{ 0xE7, 0xB5, 0xAC },
	0xBD76,	{ 0xE7, 0xB5, 0xAD },
	0xBD77,	{ 0xE7, 0xB5, 0xAF },
	0xBD78,	{ 0xE7, 0xB5, 0xB0 },
	0xBD79,	{ 0xE7, 0xB5, 0xB1 },
	0xBD7A,	{ 0xE7, 0xB5, 0xB2 },
	0xBD7B,	{ 0xE7, 0xB5, 0xB3 },
	0xBD7C,	{ 0xE7, 0xB5, 0xB4 },
	0xBD7D,	{ 0xE7, 0xB5, 0xB5 },
	0xBD7E,	{ 0xE7, 0xB5, 0xB6 },
	0xBD80,	{ 0xE7, 0xB5, 0xB8 },
	0xBD81,	{ 0xE7, 0xB5, 0xB9 },
	0xBD82,	{ 0xE7, 0xB5, 0xBA },
	0xBD83,	{ 0xE7, 0xB5, 0xBB },
	0xBD84,	{ 0xE7, 0xB5, 0xBC },
	0xBD85,	{ 0xE7, 0xB5, 0xBD },
	0xBD86,	{ 0xE7, 0xB5, 0xBE },
	0xBD87,	{ 0xE7, 0xB5, 0xBF },
	0xBD88,	{ 0xE7, 0xB6, 0x80 },
	0xBD89,	{ 0xE7, 0xB6, 0x81 },
	0xBD8A,	{ 0xE7, 0xB6, 0x82 },
	0xBD8B,	{ 0xE7, 0xB6, 0x83 },
	0xBD8C,	{ 0xE7, 0xB6, 0x84 },
	0xBD8D,	{ 0xE7, 0xB6, 0x85 },
	0xBD8E,	{ 0xE7, 0xB6, 0x86 },
	0xBD8F,	{ 0xE7, 0xB6, 0x87 },
	0xBD90,	{ 0xE7, 0xB6, 0x88 },
	0xBD91,	{ 0xE7, 0xB6, 0x89 },
	0xBD92,	{ 0xE7, 0xB6, 0x8A },
	0xBD93,	{ 0xE7, 0xB6, 0x8B },
	0xBD94,	{ 0xE7, 0xB6, 0x8C },
	0xBD95,	{ 0xE7, 0xB6, 0x8D },
	0xBD96,	{ 0xE7, 0xB6, 0x8E },
	0xBD97,	{ 0xE7, 0xB6, 0x8F },
	0xBD98,	{ 0xE7, 0xB6, 0x90 },
	0xBD99,	{ 0xE7, 0xB6, 0x91 },
	0xBD9A,	{ 0xE7, 0xB6, 0x92 },
	0xBD9B,	{ 0xE7, 0xB6, 0x93 },
	0xBD9C,	{ 0xE7, 0xB6, 0x94 },
	0xBD9D,	{ 0xE7, 0xB6, 0x95 },
	0xBD9E,	{ 0xE7, 0xB6, 0x96 },
	0xBD9F,	{ 0xE7, 0xB6, 0x97 },
	0xBDA0,	{ 0xE7, 0xB6, 0x98 },
	0xBDA1,	{ 0xE5, 0x81, 0xA5 },
	0xBDA2,	{ 0xE8, 0x88, 0xB0 },
	0xBDA3,	{ 0xE5, 0x89, 0x91 },
	0xBDA4,	{ 0xE9, 0xA5, 0xAF },
	0xBDA5,	{ 0xE6, 0xB8, 0x90 },
	0xBDA6,	{ 0xE6, 0xBA, 0x85 },
	0xBDA7,	{ 0xE6, 0xB6, 0xA7 },
	0xBDA8,	{ 0xE5, 0xBB, 0xBA },
	0xBDA9,	{ 0xE5, 0x83, 0xB5 },
	0xBDAA,	{ 0xE5, 0xA7, 0x9C },
	0xBDAB,	{ 0xE5, 0xB0, 0x86 },
	0xBDAC,	{ 0xE6, 0xB5, 0x86 },
	0xBDAD,	{ 0xE6, 0xB1, 0x9F },
	0xBDAE,	{ 0xE7, 0x96, 0x86 },
	0xBDAF,	{ 0xE8, 0x92, 0x8B },
	0xBDB0,	{ 0xE6, 0xA1, 0xA8 },
	0xBDB1,	{ 0xE5, 0xA5, 0x96 },
	0xBDB2,	{ 0xE8, 0xAE, 0xB2 },
	0xBDB3,	{ 0xE5, 0x8C, 0xA0 },
	0xBDB4,	{ 0xE9, 0x85, 0xB1 },
	0xBDB5,	{ 0xE9, 0x99, 0x8D },
	0xBDB6,	{ 0xE8, 0x95, 0x89 },
	0xBDB7,	{ 0xE6, 0xA4, 0x92 },
	0xBDB8,	{ 0xE7, 0xA4, 0x81 },
	0xBDB9,	{ 0xE7, 0x84, 0xA6 },
	0xBDBA,	{ 0xE8, 0x83, 0xB6 },
	0xBDBB,	{ 0xE4, 0xBA, 0xA4 },
	0xBDBC,	{ 0xE9, 0x83, 0x8A },
	0xBDBD,	{ 0xE6, 0xB5, 0x87 },
	0xBDBE,	{ 0xE9, 0xAA, 0x84 },
	0xBDBF,	{ 0xE5, 0xA8, 0x87 },
	0xBDC0,	{ 0xE5, 0x9A, 0xBC },
	0xBDC1,	{ 0xE6, 0x90, 0x85 },
	0xBDC2,	{ 0xE9, 0x93, 0xB0 },
	0xBDC3,	{ 0xE7, 0x9F, 0xAB },
	0xBDC4,	{ 0xE4, 0xBE, 0xA5 },
	0xBDC5,	{ 0xE8, 0x84, 0x9A },
	0xBDC6,	{ 0xE7, 0x8B, 0xA1 },
	0xBDC7,	{ 0xE8, 0xA7, 0x92 },
	0xBDC8,	{ 0xE9, 0xA5, 0xBA },
	0xBDC9,	{ 0xE7, 0xBC, 0xB4 },
	0xBDCA,	{ 0xE7, 0xBB, 0x9E },
	0xBDCB,	{ 0xE5, 0x89, 0xBF },
	0xBDCC,	{ 0xE6, 0x95, 0x99 },
	0xBDCD,	{ 0xE9, 0x85, 0xB5 },
	0xBDCE,	{ 0xE8, 0xBD, 0xBF },
	0xBDCF,	{ 0xE8, 0xBE, 0x83 },
	0xBDD0,	{ 0xE5, 0x8F, 0xAB },
	0xBDD1,	{ 0xE7, 0xAA, 0x96 },
	0xBDD2,	{ 0xE6, 0x8F, 0xAD },
	0xBDD3,	{ 0xE6, 0x8E, 0xA5 },
	0xBDD4,	{ 0xE7, 0x9A, 0x86 },
	0xBDD5,	{ 0xE7, 0xA7, 0xB8 },
	0xBDD6,	{ 0xE8, 0xA1, 0x97 },
	0xBDD7,	{ 0xE9, 0x98, 0xB6 },
	0xBDD8,	{ 0xE6, 0x88, 0xAA },
	0xBDD9,	{ 0xE5, 0x8A, 0xAB },
	0xBDDA,	{ 0xE8, 0x8A, 0x82 },
	0xBDDB,	{ 0xE6, 0xA1, 0x94 },
	0xBDDC,	{ 0xE6, 0x9D, 0xB0 },
	0xBDDD,	{ 0xE6, 0x8D, 0xB7 },
	0xBDDE,	{ 0xE7, 0x9D, 0xAB },
	0xBDDF,	{ 0xE7, 0xAB, 0xAD },
	0xBDE0,	{ 0xE6, 0xB4, 0x81 },
	0xBDE1,	{ 0xE7, 0xBB, 0x93 },
	0xBDE2,	{ 0xE8, 0xA7, 0xA3 },
	0xBDE3,	{ 0xE5, 0xA7, 0x90 },
	0xBDE4,	{ 0xE6, 0x88, 0x92 },
	0xBDE5,	{ 0xE8, 0x97, 0x89 },
	0xBDE6,	{ 0xE8, 0x8A, 0xA5 },
	0xBDE7,	{ 0xE7, 0x95, 0x8C },
	0xBDE8,	{ 0xE5, 0x80, 0x9F },
	0xBDE9,	{ 0xE4, 0xBB, 0x8B },
	0xBDEA,	{ 0xE7, 0x96, 0xA5 },
	0xBDEB,	{ 0xE8, 0xAF, 0xAB },
	0xBDEC,	{ 0xE5, 0xB1, 0x8A },
	0xBDED,	{ 0xE5, 0xB7, 0xBE },
	0xBDEE,	{ 0xE7, 0xAD, 0x8B },
	0xBDEF,	{ 0xE6, 0x96, 0xA4 },
	0xBDF0,	{ 0xE9, 0x87, 0x91 },
	0xBDF1,	{ 0xE4, 0xBB, 0x8A },
	0xBDF2,	{ 0xE6, 0xB4, 0xA5 },
	0xBDF3,	{ 0xE8, 0xA5, 0x9F },
	0xBDF4,	{ 0xE7, 0xB4, 0xA7 },
	0xBDF5,	{ 0xE9, 0x94, 0xA6 },
	0xBDF6,	{ 0xE4, 0xBB, 0x85 },
	0xBDF7,	{ 0xE8, 0xB0, 0xA8 },
	0xBDF8,	{ 0xE8, 0xBF, 0x9B },
	0xBDF9,	{ 0xE9, 0x9D, 0xB3 },
	0xBDFA,	{ 0xE6, 0x99, 0x8B },
	0xBDFB,	{ 0xE7, 0xA6, 0x81 },
	0xBDFC,	{ 0xE8, 0xBF, 0x91 },
	0xBDFD,	{ 0xE7, 0x83, 0xAC },
	0xBDFE,	{ 0xE6, 0xB5, 0xB8 },
	0xBE40,	{ 0xE7, 0xB6, 0x99 },
	0xBE41,	{ 0xE7, 0xB6, 0x9A },
	0xBE42,	{ 0xE7, 0xB6, 0x9B },
	0xBE43,	{ 0xE7, 0xB6, 0x9C },
	0xBE44,	{ 0xE7, 0xB6, 0x9D },
	0xBE45,	{ 0xE7, 0xB6, 0x9E },
	0xBE46,	{ 0xE7, 0xB6, 0x9F },
	0xBE47,	{ 0xE7, 0xB6, 0xA0 },
	0xBE48,	{ 0xE7, 0xB6, 0xA1 },
	0xBE49,	{ 0xE7, 0xB6, 0xA2 },
	0xBE4A,	{ 0xE7, 0xB6, 0xA3 },
	0xBE4B,	{ 0xE7, 0xB6, 0xA4 },
	0xBE4C,	{ 0xE7, 0xB6, 0xA5 },
	0xBE4D,	{ 0xE7, 0xB6, 0xA7 },
	0xBE4E,	{ 0xE7, 0xB6, 0xA8 },
	0xBE4F,	{ 0xE7, 0xB6, 0xA9 },
	0xBE50,	{ 0xE7, 0xB6, 0xAA },
	0xBE51,	{ 0xE7, 0xB6, 0xAB },
	0xBE52,	{ 0xE7, 0xB6, 0xAC },
	0xBE53,	{ 0xE7, 0xB6, 0xAD },
	0xBE54,	{ 0xE7, 0xB6, 0xAF },
	0xBE55,	{ 0xE7, 0xB6, 0xB0 },
	0xBE56,	{ 0xE7, 0xB6, 0xB1 },
	0xBE57,	{ 0xE7, 0xB6, 0xB2 },
	0xBE58,	{ 0xE7, 0xB6, 0xB3 },
	0xBE59,	{ 0xE7, 0xB6, 0xB4 },
	0xBE5A,	{ 0xE7, 0xB6, 0xB5 },
	0xBE5B,	{ 0xE7, 0xB6, 0xB6 },
	0xBE5C,	{ 0xE7, 0xB6, 0xB7 },
	0xBE5D,	{ 0xE7, 0xB6, 0xB8 },
	0xBE5E,	{ 0xE7, 0xB6, 0xB9 },
	0xBE5F,	{ 0xE7, 0xB6, 0xBA },
	0xBE60,	{ 0xE7, 0xB6, 0xBB },
	0xBE61,	{ 0xE7, 0xB6, 0xBC },
	0xBE62,	{ 0xE7, 0xB6, 0xBD },
	0xBE63,	{ 0xE7, 0xB6, 0xBE },
	0xBE64,	{ 0xE7, 0xB6, 0xBF },
	0xBE65,	{ 0xE7, 0xB7, 0x80 },
	0xBE66,	{ 0xE7, 0xB7, 0x81 },
	0xBE67,	{ 0xE7, 0xB7, 0x82 },
	0xBE68,	{ 0xE7, 0xB7, 0x83 },
	0xBE69,	{ 0xE7, 0xB7, 0x84 },
	0xBE6A,	{ 0xE7, 0xB7, 0x85 },
	0xBE6B,	{ 0xE7, 0xB7, 0x86 },
	0xBE6C,	{ 0xE7, 0xB7, 0x87 },
	0xBE6D,	{ 0xE7, 0xB7, 0x88 },
	0xBE6E,	{ 0xE7, 0xB7, 0x89 },
	0xBE6F,	{ 0xE7, 0xB7, 0x8A },
	0xBE70,	{ 0xE7, 0xB7, 0x8B },
	0xBE71,	{ 0xE7, 0xB7, 0x8C },
	0xBE72,	{ 0xE7, 0xB7, 0x8D },
	0xBE73,	{ 0xE7, 0xB7, 0x8E },
	0xBE74,	{ 0xE7, 0xB7, 0x8F },
	0xBE75,	{ 0xE7, 0xB7, 0x90 },
	0xBE76,	{ 0xE7, 0xB7, 0x91 },
	0xBE77,	{ 0xE7, 0xB7, 0x92 },
	0xBE78,	{ 0xE7, 0xB7, 0x93 },
	0xBE79,	{ 0xE7, 0xB7, 0x94 },
	0xBE7A,	{ 0xE7, 0xB7, 0x95 },
	0xBE7B,	{ 0xE7, 0xB7, 0x96 },
	0xBE7C,	{ 0xE7, 0xB7, 0x97 },
	0xBE7D,	{ 0xE7, 0xB7, 0x98 },
	0xBE7E,	{ 0xE7, 0xB7, 0x99 },
	0xBE80,	{ 0xE7, 0xB7, 0x9A },
	0xBE81,	{ 0xE7, 0xB7, 0x9B },
	0xBE82,	{ 0xE7, 0xB7, 0x9C },
	0xBE83,	{ 0xE7, 0xB7, 0x9D },
	0xBE84,	{ 0xE7, 0xB7, 0x9E },
	0xBE85,	{ 0xE7, 0xB7, 0x9F },
	0xBE86,	{ 0xE7, 0xB7, 0xA0 },
	0xBE87,	{ 0xE7, 0xB7, 0xA1 },
	0xBE88,	{ 0xE7, 0xB7, 0xA2 },
	0xBE89,	{ 0xE7, 0xB7, 0xA3 },
	0xBE8A,	{ 0xE7, 0xB7, 0xA4 },
	0xBE8B,	{ 0xE7, 0xB7, 0xA5 },
	0xBE8C,	{ 0xE7, 0xB7, 0xA6 },
	0xBE8D,	{ 0xE7, 0xB7, 0xA7 },
	0xBE8E,	{ 0xE7, 0xB7, 0xA8 },
	0xBE8F,	{ 0xE7, 0xB7, 0xA9 },
	0xBE90,	{ 0xE7, 0xB7, 0xAA },
	0xBE91,	{ 0xE7, 0xB7, 0xAB },
	0xBE92,	{ 0xE7, 0xB7, 0xAC },
	0xBE93,	{ 0xE7, 0xB7, 0xAD },
	0xBE94,	{ 0xE7, 0xB7, 0xAE },
	0xBE95,	{ 0xE7, 0xB7, 0xAF },
	0xBE96,	{ 0xE7, 0xB7, 0xB0 },
	0xBE97,	{ 0xE7, 0xB7, 0xB1 },
	0xBE98,	{ 0xE7, 0xB7, 0xB2 },
	0xBE99,	{ 0xE7, 0xB7, 0xB3 },
	0xBE9A,	{ 0xE7, 0xB7, 0xB4 },
	0xBE9B,	{ 0xE7, 0xB7, 0xB5 },
	0xBE9C,	{ 0xE7, 0xB7, 0xB6 },
	0xBE9D,	{ 0xE7, 0xB7, 0xB7 },
	0xBE9E,	{ 0xE7, 0xB7, 0xB8 },
	0xBE9F,	{ 0xE7, 0xB7, 0xB9 },
	0xBEA0,	{ 0xE7, 0xB7, 0xBA },
	0xBEA1,	{ 0xE5, 0xB0, 0xBD },
	0xBEA2,	{ 0xE5, 0x8A, 0xB2 },
	0xBEA3,	{ 0xE8, 0x8D, 0x86 },
	0xBEA4,	{ 0xE5, 0x85, 0xA2 },
	0xBEA5,	{ 0xE8, 0x8C, 0x8E },
	0xBEA6,	{ 0xE7, 0x9D, 0x9B },
	0xBEA7,	{ 0xE6, 0x99, 0xB6 },
	0xBEA8,	{ 0xE9, 0xB2, 0xB8 },
	0xBEA9,	{ 0xE4, 0xBA, 0xAC },
	0xBEAA,	{ 0xE6, 0x83, 0x8A },
	0xBEAB,	{ 0xE7, 0xB2, 0xBE },
	0xBEAC,	{ 0xE7, 0xB2, 0xB3 },
	0xBEAD,	{ 0xE7, 0xBB, 0x8F },
	0xBEAE,	{ 0xE4, 0xBA, 0x95 },
	0xBEAF,	{ 0xE8, 0xAD, 0xA6 },
	0xBEB0,	{ 0xE6, 0x99, 0xAF },
	0xBEB1,	{ 0xE9, 0xA2, 0x88 },
	0xBEB2,	{ 0xE9, 0x9D, 0x99 },
	0xBEB3,	{ 0xE5, 0xA2, 0x83 },
	0xBEB4,	{ 0xE6, 0x95, 0xAC },
	0xBEB5,	{ 0xE9, 0x95, 0x9C },
	0xBEB6,	{ 0xE5, 0xBE, 0x84 },
	0xBEB7,	{ 0xE7, 0x97, 0x89 },
	0xBEB8,	{ 0xE9, 0x9D, 0x96 },
	0xBEB9,	{ 0xE7, 0xAB, 0x9F },
	0xBEBA,	{ 0xE7, 0xAB, 0x9E },
	0xBEBB,	{ 0xE5, 0x87, 0x80 },
	0xBEBC,	{ 0xE7, 0x82, 0xAF },
	0xBEBD,	{ 0xE7, 0xAA, 0x98 },
	0xBEBE,	{ 0xE6, 0x8F, 0xAA },
	0xBEBF,	{ 0xE7, 0xA9, 0xB6 },
	0xBEC0,	{ 0xE7, 0xBA, 0xA0 },
	0xBEC1,	{ 0xE7, 0x8E, 0x96 },
	0xBEC2,	{ 0xE9, 0x9F, 0xAD },
	0xBEC3,	{ 0xE4, 0xB9, 0x85 },
	0xBEC4,	{ 0xE7, 0x81, 0xB8 },
	0xBEC5,	{ 0xE4, 0xB9, 0x9D },
	0xBEC6,	{ 0xE9, 0x85, 0x92 },
	0xBEC7,	{ 0xE5, 0x8E, 0xA9 },
	0xBEC8,	{ 0xE6, 0x95, 0x91 },
	0xBEC9,	{ 0xE6, 0x97, 0xA7 },
	0xBECA,	{ 0xE8, 0x87, 0xBC },
	0xBECB,	{ 0xE8, 0x88, 0x85 },
	0xBECC,	{ 0xE5, 0x92, 0x8E },
	0xBECD,	{ 0xE5, 0xB0, 0xB1 },
	0xBECE,	{ 0xE7, 0x96, 0x9A },
	0xBECF,	{ 0xE9, 0x9E, 0xA0 },
	0xBED0,	{ 0xE6, 0x8B, 0x98 },
	0xBED1,	{ 0xE7, 0x8B, 0x99 },
	0xBED2,	{ 0xE7, 0x96, 0xBD },
	0xBED3,	{ 0xE5, 0xB1, 0x85 },
	0xBED4,	{ 0xE9, 0xA9, 0xB9 },
	0xBED5,	{ 0xE8, 0x8F, 0x8A },
	0xBED6,	{ 0xE5, 0xB1, 0x80 },
	0xBED7,	{ 0xE5, 0x92, 0x80 },
	0xBED8,	{ 0xE7, 0x9F, 0xA9 },
	0xBED9,	{ 0xE4, 0xB8, 0xBE },
	0xBEDA,	{ 0xE6, 0xB2, 0xAE },
	0xBEDB,	{ 0xE8, 0x81, 0x9A },
	0xBEDC,	{ 0xE6, 0x8B, 0x92 },
	0xBEDD,	{ 0xE6, 0x8D, 0xAE },
	0xBEDE,	{ 0xE5, 0xB7, 0xA8 },
	0xBEDF,	{ 0xE5, 0x85, 0xB7 },
	0xBEE0,	{ 0xE8, 0xB7, 0x9D },
	0xBEE1,	{ 0xE8, 0xB8, 0x9E },
	0xBEE2,	{ 0xE9, 0x94, 0xAF },
	0xBEE3,	{ 0xE4, 0xBF, 0xB1 },
	0xBEE4,	{ 0xE5, 0x8F, 0xA5 },
	0xBEE5,	{ 0xE6, 0x83, 0xA7 },
	0xBEE6,	{ 0xE7, 0x82, 0xAC },
	0xBEE7,	{ 0xE5, 0x89, 0xA7 },
	0xBEE8,	{ 0xE6, 0x8D, 0x90 },
	0xBEE9,	{ 0xE9, 0xB9, 0x83 },
	0xBEEA,	{ 0xE5, 0xA8, 0x9F },
	0xBEEB,	{ 0xE5, 0x80, 0xA6 },
	0xBEEC,	{ 0xE7, 0x9C, 0xB7 },
	0xBEED,	{ 0xE5, 0x8D, 0xB7 },
	0xBEEE,	{ 0xE7, 0xBB, 0xA2 },
	0xBEEF,	{ 0xE6, 0x92, 0x85 },
	0xBEF0,	{ 0xE6, 0x94, 0xAB },
	0xBEF1,	{ 0xE6, 0x8A, 0x89 },
	0xBEF2,	{ 0xE6, 0x8E, 0x98 },
	0xBEF3,	{ 0xE5, 0x80, 0x94 },
	0xBEF4,	{ 0xE7, 0x88, 0xB5 },
	0xBEF5,	{ 0xE8, 0xA7, 0x89 },
	0xBEF6,	{ 0xE5, 0x86, 0xB3 },
	0xBEF7,	{ 0xE8, 0xAF, 0x80 },
	0xBEF8,	{ 0xE7, 0xBB, 0x9D },
	0xBEF9,	{ 0xE5, 0x9D, 0x87 },
	0xBEFA,	{ 0xE8, 0x8F, 0x8C },
	0xBEFB,	{ 0xE9, 0x92, 0xA7 },
	0xBEFC,	{ 0xE5, 0x86, 0x9B },
	0xBEFD,	{ 0xE5, 0x90, 0x9B },
	0xBEFE,	{ 0xE5, 0xB3, 0xBB },
	0xBF40,	{ 0xE7, 0xB7, 0xBB },
	0xBF41,	{ 0xE7, 0xB7, 0xBC },
	0xBF42,	{ 0xE7, 0xB7, 0xBD },
	0xBF43,	{ 0xE7, 0xB7, 0xBE },
	0xBF44,	{ 0xE7, 0xB7, 0xBF },
	0xBF45,	{ 0xE7, 0xB8, 0x80 },
	0xBF46,	{ 0xE7, 0xB8, 0x81 },
	0xBF47,	{ 0xE7, 0xB8, 0x82 },
	0xBF48,	{ 0xE7, 0xB8, 0x83 },
	0xBF49,	{ 0xE7, 0xB8, 0x84 },
	0xBF4A,	{ 0xE7, 0xB8, 0x85 },
	0xBF4B,	{ 0xE7, 0xB8, 0x86 },
	0xBF4C,	{ 0xE7, 0xB8, 0x87 },
	0xBF4D,	{ 0xE7, 0xB8, 0x88 },
	0xBF4E,	{ 0xE7, 0xB8, 0x89 },
	0xBF4F,	{ 0xE7, 0xB8, 0x8A },
	0xBF50,	{ 0xE7, 0xB8, 0x8B },
	0xBF51,	{ 0xE7, 0xB8, 0x8C },
	0xBF52,	{ 0xE7, 0xB8, 0x8D },
	0xBF53,	{ 0xE7, 0xB8, 0x8E },
	0xBF54,	{ 0xE7, 0xB8, 0x8F },
	0xBF55,	{ 0xE7, 0xB8, 0x90 },
	0xBF56,	{ 0xE7, 0xB8, 0x91 },
	0xBF57,	{ 0xE7, 0xB8, 0x92 },
	0xBF58,	{ 0xE7, 0xB8, 0x93 },
	0xBF59,	{ 0xE7, 0xB8, 0x94 },
	0xBF5A,	{ 0xE7, 0xB8, 0x95 },
	0xBF5B,	{ 0xE7, 0xB8, 0x96 },
	0xBF5C,	{ 0xE7, 0xB8, 0x97 },
	0xBF5D,	{ 0xE7, 0xB8, 0x98 },
	0xBF5E,	{ 0xE7, 0xB8, 0x99 },
	0xBF5F,	{ 0xE7, 0xB8, 0x9A },
	0xBF60,	{ 0xE7, 0xB8, 0x9B },
	0xBF61,	{ 0xE7, 0xB8, 0x9C },
	0xBF62,	{ 0xE7, 0xB8, 0x9D },
	0xBF63,	{ 0xE7, 0xB8, 0x9E },
	0xBF64,	{ 0xE7, 0xB8, 0x9F },
	0xBF65,	{ 0xE7, 0xB8, 0xA0 },
	0xBF66,	{ 0xE7, 0xB8, 0xA1 },
	0xBF67,	{ 0xE7, 0xB8, 0xA2 },
	0xBF68,	{ 0xE7, 0xB8, 0xA3 },
	0xBF69,	{ 0xE7, 0xB8, 0xA4 },
	0xBF6A,	{ 0xE7, 0xB8, 0xA5 },
	0xBF6B,	{ 0xE7, 0xB8, 0xA6 },
	0xBF6C,	{ 0xE7, 0xB8, 0xA7 },
	0xBF6D,	{ 0xE7, 0xB8, 0xA8 },
	0xBF6E,	{ 0xE7, 0xB8, 0xA9 },
	0xBF6F,	{ 0xE7, 0xB8, 0xAA },
	0xBF70,	{ 0xE7, 0xB8, 0xAB },
	0xBF71,	{ 0xE7, 0xB8, 0xAC },
	0xBF72,	{ 0xE7, 0xB8, 0xAD },
	0xBF73,	{ 0xE7, 0xB8, 0xAE },
	0xBF74,	{ 0xE7, 0xB8, 0xAF },
	0xBF75,	{ 0xE7, 0xB8, 0xB0 },
	0xBF76,	{ 0xE7, 0xB8, 0xB1 },
	0xBF77,	{ 0xE7, 0xB8, 0xB2 },
	0xBF78,	{ 0xE7, 0xB8, 0xB3 },
	0xBF79,	{ 0xE7, 0xB8, 0xB4 },
	0xBF7A,	{ 0xE7, 0xB8, 0xB5 },
	0xBF7B,	{ 0xE7, 0xB8, 0xB6 },
	0xBF7C,	{ 0xE7, 0xB8, 0xB7 },
	0xBF7D,	{ 0xE7, 0xB8, 0xB8 },
	0xBF7E,	{ 0xE7, 0xB8, 0xB9 },
	0xBF80,	{ 0xE7, 0xB8, 0xBA },
	0xBF81,	{ 0xE7, 0xB8, 0xBC },
	0xBF82,	{ 0xE7, 0xB8, 0xBD },
	0xBF83,	{ 0xE7, 0xB8, 0xBE },
	0xBF84,	{ 0xE7, 0xB8, 0xBF },
	0xBF85,	{ 0xE7, 0xB9, 0x80 },
	0xBF86,	{ 0xE7, 0xB9, 0x82 },
	0xBF87,	{ 0xE7, 0xB9, 0x83 },
	0xBF88,	{ 0xE7, 0xB9, 0x84 },
	0xBF89,	{ 0xE7, 0xB9, 0x85 },
	0xBF8A,	{ 0xE7, 0xB9, 0x86 },
	0xBF8B,	{ 0xE7, 0xB9, 0x88 },
	0xBF8C,	{ 0xE7, 0xB9, 0x89 },
	0xBF8D,	{ 0xE7, 0xB9, 0x8A },
	0xBF8E,	{ 0xE7, 0xB9, 0x8B },
	0xBF8F,	{ 0xE7, 0xB9, 0x8C },
	0xBF90,	{ 0xE7, 0xB9, 0x8D },
	0xBF91,	{ 0xE7, 0xB9, 0x8E },
	0xBF92,	{ 0xE7, 0xB9, 0x8F },
	0xBF93,	{ 0xE7, 0xB9, 0x90 },
	0xBF94,	{ 0xE7, 0xB9, 0x91 },
	0xBF95,	{ 0xE7, 0xB9, 0x92 },
	0xBF96,	{ 0xE7, 0xB9, 0x93 },
	0xBF97,	{ 0xE7, 0xB9, 0x94 },
	0xBF98,	{ 0xE7, 0xB9, 0x95 },
	0xBF99,	{ 0xE7, 0xB9, 0x96 },
	0xBF9A,	{ 0xE7, 0xB9, 0x97 },
	0xBF9B,	{ 0xE7, 0xB9, 0x98 },
	0xBF9C,	{ 0xE7, 0xB9, 0x99 },
	0xBF9D,	{ 0xE7, 0xB9, 0x9A },
	0xBF9E,	{ 0xE7, 0xB9, 0x9B },
	0xBF9F,	{ 0xE7, 0xB9, 0x9C },
	0xBFA0,	{ 0xE7, 0xB9, 0x9D },
	0xBFA1,	{ 0xE4, 0xBF, 0x8A },
	0xBFA2,	{ 0xE7, 0xAB, 0xA3 },
	0xBFA3,	{ 0xE6, 0xB5, 0x9A },
	0xBFA4,	{ 0xE9, 0x83, 0xA1 },
	0xBFA5,	{ 0xE9, 0xAA, 0x8F },
	0xBFA6,	{ 0xE5, 0x96, 0x80 },
	0xBFA7,	{ 0xE5, 0x92, 0x96 },
	0xBFA8,	{ 0xE5, 0x8D, 0xA1 },
	0xBFA9,	{ 0xE5, 0x92, 0xAF },
	0xBFAA,	{ 0xE5, 0xBC, 0x80 },
	0xBFAB,	{ 0xE6, 0x8F, 0xA9 },
	0xBFAC,	{ 0xE6, 0xA5, 0xB7 },
	0xBFAD,	{ 0xE5, 0x87, 0xAF },
	0xBFAE,	{ 0xE6, 0x85, 0xA8 },
	0xBFAF,	{ 0xE5, 0x88, 0x8A },
	0xBFB0,	{ 0xE5, 0xA0, 0xAA },
	0xBFB1,	{ 0xE5, 0x8B, 0x98 },
	0xBFB2,	{ 0xE5, 0x9D, 0x8E },
	0xBFB3,	{ 0xE7, 0xA0, 0x8D },
	0xBFB4,	{ 0xE7, 0x9C, 0x8B },
	0xBFB5,	{ 0xE5, 0xBA, 0xB7 },
	0xBFB6,	{ 0xE6, 0x85, 0xB7 },
	0xBFB7,	{ 0xE7, 0xB3, 0xA0 },
	0xBFB8,	{ 0xE6, 0x89, 0x9B },
	0xBFB9,	{ 0xE6, 0x8A, 0x97 },
	0xBFBA,	{ 0xE4, 0xBA, 0xA2 },
	0xBFBB,	{ 0xE7, 0x82, 0x95 },
	0xBFBC,	{ 0xE8, 0x80, 0x83 },
	0xBFBD,	{ 0xE6, 0x8B, 0xB7 },
	0xBFBE,	{ 0xE7, 0x83, 0xA4 },
	0xBFBF,	{ 0xE9, 0x9D, 0xA0 },
	0xBFC0,	{ 0xE5, 0x9D, 0xB7 },
	0xBFC1,	{ 0xE8, 0x8B, 0x9B },
	0xBFC2,	{ 0xE6, 0x9F, 0xAF },
	0xBFC3,	{ 0xE6, 0xA3, 0xB5 },
	0xBFC4,	{ 0xE7, 0xA3, 0x95 },
	0xBFC5,	{ 0xE9, 0xA2, 0x97 },
	0xBFC6,	{ 0xE7, 0xA7, 0x91 },
	0xBFC7,	{ 0xE5, 0xA3, 0xB3 },
	0xBFC8,	{ 0xE5, 0x92, 0xB3 },
	0xBFC9,	{ 0xE5, 0x8F, 0xAF },
	0xBFCA,	{ 0xE6, 0xB8, 0xB4 },
	0xBFCB,	{ 0xE5, 0x85, 0x8B },
	0xBFCC,	{ 0xE5, 0x88, 0xBB },
	0xBFCD,	{ 0xE5, 0xAE, 0xA2 },
	0xBFCE,	{ 0xE8, 0xAF, 0xBE },
	0xBFCF,	{ 0xE8, 0x82, 0xAF },
	0xBFD0,	{ 0xE5, 0x95, 0x83 },
	0xBFD1,	{ 0xE5, 0x9E, 0xA6 },
	0xBFD2,	{ 0xE6, 0x81, 0xB3 },
	0xBFD3,	{ 0xE5, 0x9D, 0x91 },
	0xBFD4,	{ 0xE5, 0x90, 0xAD },
	0xBFD5,	{ 0xE7, 0xA9, 0xBA },
	0xBFD6,	{ 0xE6, 0x81, 0x90 },
	0xBFD7,	{ 0xE5, 0xAD, 0x94 },
	0xBFD8,	{ 0xE6, 0x8E, 0xA7 },
	0xBFD9,	{ 0xE6, 0x8A, 0xA0 },
	0xBFDA,	{ 0xE5, 0x8F, 0xA3 },
	0xBFDB,	{ 0xE6, 0x89, 0xA3 },
	0xBFDC,	{ 0xE5, 0xAF, 0x87 },
	0xBFDD,	{ 0xE6, 0x9E, 0xAF },
	0xBFDE,	{ 0xE5, 0x93, 0xAD },
	0xBFDF,	{ 0xE7, 0xAA, 0x9F },
	0xBFE0,	{ 0xE8, 0x8B, 0xA6 },
	0xBFE1,	{ 0xE9, 0x85, 0xB7 },
	0xBFE2,	{ 0xE5, 0xBA, 0x93 },
	0xBFE3,	{ 0xE8, 0xA3, 0xA4 },
	0xBFE4,	{ 0xE5, 0xA4, 0xB8 },
	0xBFE5,	{ 0xE5, 0x9E, 0xAE },
	0xBFE6,	{ 0xE6, 0x8C, 0x8E },
	0xBFE7,	{ 0xE8, 0xB7, 0xA8 },
	0xBFE8,	{ 0xE8, 0x83, 0xAF },
	0xBFE9,	{ 0xE5, 0x9D, 0x97 },
	0xBFEA,	{ 0xE7, 0xAD, 0xB7 },
	0xBFEB,	{ 0xE4, 0xBE, 0xA9 },
	0xBFEC,	{ 0xE5, 0xBF, 0xAB },
	0xBFED,	{ 0xE5, 0xAE, 0xBD },
	0xBFEE,	{ 0xE6, 0xAC, 0xBE },
	0xBFEF,	{ 0xE5, 0x8C, 0xA1 },
	0xBFF0,	{ 0xE7, 0xAD, 0x90 },
	0xBFF1,	{ 0xE7, 0x8B, 0x82 },
	0xBFF2,	{ 0xE6, 0xA1, 0x86 },
	0xBFF3,	{ 0xE7, 0x9F, 0xBF },
	0xBFF4,	{ 0xE7, 0x9C, 0xB6 },
	0xBFF5,	{ 0xE6, 0x97, 0xB7 },
	0xBFF6,	{ 0xE5, 0x86, 0xB5 },
	0xBFF7,	{ 0xE4, 0xBA, 0x8F },
	0xBFF8,	{ 0xE7, 0x9B, 0x94 },
	0xBFF9,	{ 0xE5, 0xB2, 0xBF },
	0xBFFA,	{ 0xE7, 0xAA, 0xA5 },
	0xBFFB,	{ 0xE8, 0x91, 0xB5 },
	0xBFFC,	{ 0xE5, 0xA5, 0x8E },
	0xBFFD,	{ 0xE9, 0xAD, 0x81 },
	0xBFFE,	{ 0xE5, 0x82, 0x80 },
	0xC040,	{ 0xE7, 0xB9, 0x9E },
	0xC041,	{ 0xE7, 0xB9, 0x9F },
	0xC042,	{ 0xE7, 0xB9, 0xA0 },
	0xC043,	{ 0xE7, 0xB9, 0xA1 },
	0xC044,	{ 0xE7, 0xB9, 0xA2 },
	0xC045,	{ 0xE7, 0xB9, 0xA3 },
	0xC046,	{ 0xE7, 0xB9, 0xA4 },
	0xC047,	{ 0xE7, 0xB9, 0xA5 },
	0xC048,	{ 0xE7, 0xB9, 0xA6 },
	0xC049,	{ 0xE7, 0xB9, 0xA7 },
	0xC04A,	{ 0xE7, 0xB9, 0xA8 },
	0xC04B,	{ 0xE7, 0xB9, 0xA9 },
	0xC04C,	{ 0xE7, 0xB9, 0xAA },
	0xC04D,	{ 0xE7, 0xB9, 0xAB },
	0xC04E,	{ 0xE7, 0xB9, 0xAC },
	0xC04F,	{ 0xE7, 0xB9, 0xAD },
	0xC050,	{ 0xE7, 0xB9, 0xAE },
	0xC051,	{ 0xE7, 0xB9, 0xAF },
	0xC052,	{ 0xE7, 0xB9, 0xB0 },
	0xC053,	{ 0xE7, 0xB9, 0xB1 },
	0xC054,	{ 0xE7, 0xB9, 0xB2 },
	0xC055,	{ 0xE7, 0xB9, 0xB3 },
	0xC056,	{ 0xE7, 0xB9, 0xB4 },
	0xC057,	{ 0xE7, 0xB9, 0xB5 },
	0xC058,	{ 0xE7, 0xB9, 0xB6 },
	0xC059,	{ 0xE7, 0xB9, 0xB7 },
	0xC05A,	{ 0xE7, 0xB9, 0xB8 },
	0xC05B,	{ 0xE7, 0xB9, 0xB9 },
	0xC05C,	{ 0xE7, 0xB9, 0xBA },
	0xC05D,	{ 0xE7, 0xB9, 0xBB },
	0xC05E,	{ 0xE7, 0xB9, 0xBC },
	0xC05F,	{ 0xE7, 0xB9, 0xBD },
	0xC060,	{ 0xE7, 0xB9, 0xBE },
	0xC061,	{ 0xE7, 0xB9, 0xBF },
	0xC062,	{ 0xE7, 0xBA, 0x80 },
	0xC063,	{ 0xE7, 0xBA, 0x81 },
	0xC064,	{ 0xE7, 0xBA, 0x83 },
	0xC065,	{ 0xE7, 0xBA, 0x84 },
	0xC066,	{ 0xE7, 0xBA, 0x85 },
	0xC067,	{ 0xE7, 0xBA, 0x86 },
	0xC068,	{ 0xE7, 0xBA, 0x87 },
	0xC069,	{ 0xE7, 0xBA, 0x88 },
	0xC06A,	{ 0xE7, 0xBA, 0x89 },
	0xC06B,	{ 0xE7, 0xBA, 0x8A },
	0xC06C,	{ 0xE7, 0xBA, 0x8B },
	0xC06D,	{ 0xE7, 0xBA, 0x8C },
	0xC06E,	{ 0xE7, 0xBA, 0x8D },
	0xC06F,	{ 0xE7, 0xBA, 0x8E },
	0xC070,	{ 0xE7, 0xBA, 0x8F },
	0xC071,	{ 0xE7, 0xBA, 0x90 },
	0xC072,	{ 0xE7, 0xBA, 0x91 },
	0xC073,	{ 0xE7, 0xBA, 0x92 },
	0xC074,	{ 0xE7, 0xBA, 0x93 },
	0xC075,	{ 0xE7, 0xBA, 0x94 },
	0xC076,	{ 0xE7, 0xBA, 0x95 },
	0xC077,	{ 0xE7, 0xBA, 0x96 },
	0xC078,	{ 0xE7, 0xBA, 0x97 },
	0xC079,	{ 0xE7, 0xBA, 0x98 },
	0xC07A,	{ 0xE7, 0xBA, 0x99 },
	0xC07B,	{ 0xE7, 0xBA, 0x9A },
	0xC07C,	{ 0xE7, 0xBA, 0x9C },
	0xC07D,	{ 0xE7, 0xBA, 0x9D },
	0xC07E,	{ 0xE7, 0xBA, 0x9E },
	0xC080,	{ 0xE7, 0xBA, 0xAE },
	0xC081,	{ 0xE7, 0xBA, 0xB4 },
	0xC082,	{ 0xE7, 0xBA, 0xBB },
	0xC083,	{ 0xE7, 0xBA, 0xBC },
	0xC084,	{ 0xE7, 0xBB, 0x96 },
	0xC085,	{ 0xE7, 0xBB, 0xA4 },
	0xC086,	{ 0xE7, 0xBB, 0xAC },
	0xC087,	{ 0xE7, 0xBB, 0xB9 },
	0xC088,	{ 0xE7, 0xBC, 0x8A },
	0xC089,	{ 0xE7, 0xBC, 0x90 },
	0xC08A,	{ 0xE7, 0xBC, 0x9E },
	0xC08B,	{ 0xE7, 0xBC, 0xB7 },
	0xC08C,	{ 0xE7, 0xBC, 0xB9 },
	0xC08D,	{ 0xE7, 0xBC, 0xBB },
	0xC08E,	{ 0xE7, 0xBC, 0xBC },
	0xC08F,	{ 0xE7, 0xBC, 0xBD },
	0xC090,	{ 0xE7, 0xBC, 0xBE },
	0xC091,	{ 0xE7, 0xBC, 0xBF },
	0xC092,	{ 0xE7, 0xBD, 0x80 },
	0xC093,	{ 0xE7, 0xBD, 0x81 },
	0xC094,	{ 0xE7, 0xBD, 0x83 },
	0xC095,	{ 0xE7, 0xBD, 0x86 },
	0xC096,	{ 0xE7, 0xBD, 0x87 },
	0xC097,	{ 0xE7, 0xBD, 0x88 },
	0xC098,	{ 0xE7, 0xBD, 0x89 },
	0xC099,	{ 0xE7, 0xBD, 0x8A },
	0xC09A,	{ 0xE7, 0xBD, 0x8B },
	0xC09B,	{ 0xE7, 0xBD, 0x8C },
	0xC09C,	{ 0xE7, 0xBD, 0x8D },
	0xC09D,	{ 0xE7, 0xBD, 0x8E },
	0xC09E,	{ 0xE7, 0xBD, 0x8F },
	0xC09F,	{ 0xE7, 0xBD, 0x92 },
	0xC0A0,	{ 0xE7, 0xBD, 0x93 },
	0xC0A1,	{ 0xE9, 0xA6, 0x88 },
	0xC0A2,	{ 0xE6, 0x84, 0xA7 },
	0xC0A3,	{ 0xE6, 0xBA, 0x83 },
	0xC0A4,	{ 0xE5, 0x9D, 0xA4 },
	0xC0A5,	{ 0xE6, 0x98, 0x86 },
	0xC0A6,	{ 0xE6, 0x8D, 0x86 },
	0xC0A7,	{ 0xE5, 0x9B, 0xB0 },
	0xC0A8,	{ 0xE6, 0x8B, 0xAC },
	0xC0A9,	{ 0xE6, 0x89, 0xA9 },
	0xC0AA,	{ 0xE5, 0xBB, 0x93 },
	0xC0AB,	{ 0xE9, 0x98, 0x94 },
	0xC0AC,	{ 0xE5, 0x9E, 0x83 },
	0xC0AD,	{ 0xE6, 0x8B, 0x89 },
	0xC0AE,	{ 0xE5, 0x96, 0x87 },
	0xC0AF,	{ 0xE8, 0x9C, 0xA1 },
	0xC0B0,	{ 0xE8, 0x85, 0x8A },
	0xC0B1,	{ 0xE8, 0xBE, 0xA3 },
	0xC0B2,	{ 0xE5, 0x95, 0xA6 },
	0xC0B3,	{ 0xE8, 0x8E, 0xB1 },
	0xC0B4,	{ 0xE6, 0x9D, 0xA5 },
	0xC0B5,	{ 0xE8, 0xB5, 0x96 },
	0xC0B6,	{ 0xE8, 0x93, 0x9D },
	0xC0B7,	{ 0xE5, 0xA9, 0xAA },
	0xC0B8,	{ 0xE6, 0xA0, 0x8F },
	0xC0B9,	{ 0xE6, 0x8B, 0xA6 },
	0xC0BA,	{ 0xE7, 0xAF, 0xAE },
	0xC0BB,	{ 0xE9, 0x98, 0x91 },
	0xC0BC,	{ 0xE5, 0x85, 0xB0 },
	0xC0BD,	{ 0xE6, 0xBE, 0x9C },
	0xC0BE,	{ 0xE8, 0xB0, 0xB0 },
	0xC0BF,	{ 0xE6, 0x8F, 0xBD },
	0xC0C0,	{ 0xE8, 0xA7, 0x88 },
	0xC0C1,	{ 0xE6, 0x87, 0x92 },
	0xC0C2,	{ 0xE7, 0xBC, 0x86 },
	0xC0C3,	{ 0xE7, 0x83, 0x82 },
	0xC0C4,	{ 0xE6, 0xBB, 0xA5 },
	0xC0C5,	{ 0xE7, 0x90, 0x85 },
	0xC0C6,	{ 0xE6, 0xA6, 0x94 },
	0xC0C7,	{ 0xE7, 0x8B, 0xBC },
	0xC0C8,	{ 0xE5, 0xBB, 0x8A },
	0xC0C9,	{ 0xE9, 0x83, 0x8E },
	0xC0CA,	{ 0xE6, 0x9C, 0x97 },
	0xC0CB,	{ 0xE6, 0xB5, 0xAA },
	0xC0CC,	{ 0xE6, 0x8D, 0x9E },
	0xC0CD,	{ 0xE5, 0x8A, 0xB3 },
	0xC0CE,	{ 0xE7, 0x89, 0xA2 },
	0xC0CF,	{ 0xE8, 0x80, 0x81 },
	0xC0D0,	{ 0xE4, 0xBD, 0xAC },
	0xC0D1,	{ 0xE5, 0xA7, 0xA5 },
	0xC0D2,	{ 0xE9, 0x85, 0xAA },
	0xC0D3,	{ 0xE7, 0x83, 0x99 },
	0xC0D4,	{ 0xE6, 0xB6, 0x9D },
	0xC0D5,	{ 0xE5, 0x8B, 0x92 },
	0xC0D6,	{ 0xE4, 0xB9, 0x90 },
	0xC0D7,	{ 0xE9, 0x9B, 0xB7 },
	0xC0D8,	{ 0xE9, 0x95, 0xAD },
	0xC0D9,	{ 0xE8, 0x95, 0xBE },
	0xC0DA,	{ 0xE7, 0xA3, 0x8A },
	0xC0DB,	{ 0xE7, 0xB4, 0xAF },
	0xC0DC,	{ 0xE5, 0x84, 0xA1 },
	0xC0DD,	{ 0xE5, 0x9E, 0x92 },
	0xC0DE,	{ 0xE6, 0x93, 0x82 },
	0xC0DF,	{ 0xE8, 0x82, 0x8B },
	0xC0E0,	{ 0xE7, 0xB1, 0xBB },
	0xC0E1,	{ 0xE6, 0xB3, 0xAA },
	0xC0E2,	{ 0xE6, 0xA3, 0xB1 },
	0xC0E3,	{ 0xE6, 0xA5, 0x9E },
	0xC0E4,	{ 0xE5, 0x86, 0xB7 },
	0xC0E5,	{ 0xE5, 0x8E, 0x98 },
	0xC0E6,	{ 0xE6, 0xA2, 0xA8 },
	0xC0E7,	{ 0xE7, 0x8A, 0x81 },
	0xC0E8,	{ 0xE9, 0xBB, 0x8E },
	0xC0E9,	{ 0xE7, 0xAF, 0xB1 },
	0xC0EA,	{ 0xE7, 0x8B, 0xB8 },
	0xC0EB,	{ 0xE7, 0xA6, 0xBB },
	0xC0EC,	{ 0xE6, 0xBC, 0x93 },
	0xC0ED,	{ 0xE7, 0x90, 0x86 },
	0xC0EE,	{ 0xE6, 0x9D, 0x8E },
	0xC0EF,	{ 0xE9, 0x87, 0x8C },
	0xC0F0,	{ 0xE9, 0xB2, 0xA4 },
	0xC0F1,	{ 0xE7, 0xA4, 0xBC },
	0xC0F2,	{ 0xE8, 0x8E, 0x89 },
	0xC0F3,	{ 0xE8, 0x8D, 0x94 },
	0xC0F4,	{ 0xE5, 0x90, 0x8F },
	0xC0F5,	{ 0xE6, 0xA0, 0x97 },
	0xC0F6,	{ 0xE4, 0xB8, 0xBD },
	0xC0F7,	{ 0xE5, 0x8E, 0x89 },
	0xC0F8,	{ 0xE5, 0x8A, 0xB1 },
	0xC0F9,	{ 0xE7, 0xA0, 0xBE },
	0xC0FA,	{ 0xE5, 0x8E, 0x86 },
	0xC0FB,	{ 0xE5, 0x88, 0xA9 },
	0xC0FC,	{ 0xE5, 0x82, 0x88 },
	0xC0FD,	{ 0xE4, 0xBE, 0x8B },
	0xC0FE,	{ 0xE4, 0xBF, 0x90 },
	0xC140,	{ 0xE7, 0xBD, 0x96 },
	0xC141,	{ 0xE7, 0xBD, 0x99 },
	0xC142,	{ 0xE7, 0xBD, 0x9B },
	0xC143,	{ 0xE7, 0xBD, 0x9C },
	0xC144,	{ 0xE7, 0xBD, 0x9D },
	0xC145,	{ 0xE7, 0xBD, 0x9E },
	0xC146,	{ 0xE7, 0xBD, 0xA0 },
	0xC147,	{ 0xE7, 0xBD, 0xA3 },
	0xC148,	{ 0xE7, 0xBD, 0xA4 },
	0xC149,	{ 0xE7, 0xBD, 0xA5 },
	0xC14A,	{ 0xE7, 0xBD, 0xA6 },
	0xC14B,	{ 0xE7, 0xBD, 0xA7 },
	0xC14C,	{ 0xE7, 0xBD, 0xAB },
	0xC14D,	{ 0xE7, 0xBD, 0xAC },
	0xC14E,	{ 0xE7, 0xBD, 0xAD },
	0xC14F,	{ 0xE7, 0xBD, 0xAF },
	0xC150,	{ 0xE7, 0xBD, 0xB0 },
	0xC151,	{ 0xE7, 0xBD, 0xB3 },
	0xC152,	{ 0xE7, 0xBD, 0xB5 },
	0xC153,	{ 0xE7, 0xBD, 0xB6 },
	0xC154,	{ 0xE7, 0xBD, 0xB7 },
	0xC155,	{ 0xE7, 0xBD, 0xB8 },
	0xC156,	{ 0xE7, 0xBD, 0xBA },
	0xC157,	{ 0xE7, 0xBD, 0xBB },
	0xC158,	{ 0xE7, 0xBD, 0xBC },
	0xC159,	{ 0xE7, 0xBD, 0xBD },
	0xC15A,	{ 0xE7, 0xBD, 0xBF },
	0xC15B,	{ 0xE7, 0xBE, 0x80 },
	0xC15C,	{ 0xE7, 0xBE, 0x82 },
	0xC15D,	{ 0xE7, 0xBE, 0x83 },
	0xC15E,	{ 0xE7, 0xBE, 0x84 },
	0xC15F,	{ 0xE7, 0xBE, 0x85 },
	0xC160,	{ 0xE7, 0xBE, 0x86 },
	0xC161,	{ 0xE7, 0xBE, 0x87 },
	0xC162,	{ 0xE7, 0xBE, 0x88 },
	0xC163,	{ 0xE7, 0xBE, 0x89 },
	0xC164,	{ 0xE7, 0xBE, 0x8B },
	0xC165,	{ 0xE7, 0xBE, 0x8D },
	0xC166,	{ 0xE7, 0xBE, 0x8F },
	0xC167,	{ 0xE7, 0xBE, 0x90 },
	0xC168,	{ 0xE7, 0xBE, 0x91 },
	0xC169,	{ 0xE7, 0xBE, 0x92 },
	0xC16A,	{ 0xE7, 0xBE, 0x93 },
	0xC16B,	{ 0xE7, 0xBE, 0x95 },
	0xC16C,	{ 0xE7, 0xBE, 0x96 },
	0xC16D,	{ 0xE7, 0xBE, 0x97 },
	0xC16E,	{ 0xE7, 0xBE, 0x98 },
	0xC16F,	{ 0xE7, 0xBE, 0x99 },
	0xC170,	{ 0xE7, 0xBE, 0x9B },
	0xC171,	{ 0xE7, 0xBE, 0x9C },
	0xC172,	{ 0xE7, 0xBE, 0xA0 },
	0xC173,	{ 0xE7, 0xBE, 0xA2 },
	0xC174,	{ 0xE7, 0xBE, 0xA3 },
	0xC175,	{ 0xE7, 0xBE, 0xA5 },
	0xC176,	{ 0xE7, 0xBE, 0xA6 },
	0xC177,	{ 0xE7, 0xBE, 0xA8 },
	0xC178,	{ 0xE7, 0xBE, 0xA9 },
	0xC179,	{ 0xE7, 0xBE, 0xAA },
	0xC17A,	{ 0xE7, 0xBE, 0xAB },
	0xC17B,	{ 0xE7, 0xBE, 0xAC },
	0xC17C,	{ 0xE7, 0xBE, 0xAD },
	0xC17D,	{ 0xE7, 0xBE, 0xAE },
	0xC17E,	{ 0xE7, 0xBE, 0xB1 },
	0xC180,	{ 0xE7, 0xBE, 0xB3 },
	0xC181,	{ 0xE7, 0xBE, 0xB4 },
	0xC182,	{ 0xE7, 0xBE, 0xB5 },
	0xC183,	{ 0xE7, 0xBE, 0xB6 },
	0xC184,	{ 0xE7, 0xBE, 0xB7 },
	0xC185,	{ 0xE7, 0xBE, 0xBA },
	0xC186,	{ 0xE7, 0xBE, 0xBB },
	0xC187,	{ 0xE7, 0xBE, 0xBE },
	0xC188,	{ 0xE7, 0xBF, 0x80 },
	0xC189,	{ 0xE7, 0xBF, 0x82 },
	0xC18A,	{ 0xE7, 0xBF, 0x83 },
	0xC18B,	{ 0xE7, 0xBF, 0x84 },
	0xC18C,	{ 0xE7, 0xBF, 0x86 },
	0xC18D,	{ 0xE7, 0xBF, 0x87 },
	0xC18E,	{ 0xE7, 0xBF, 0x88 },
	0xC18F,	{ 0xE7, 0xBF, 0x89 },
	0xC190,	{ 0xE7, 0xBF, 0x8B },
	0xC191,	{ 0xE7, 0xBF, 0x8D },
	0xC192,	{ 0xE7, 0xBF, 0x8F },
	0xC193,	{ 0xE7, 0xBF, 0x90 },
	0xC194,	{ 0xE7, 0xBF, 0x91 },
	0xC195,	{ 0xE7, 0xBF, 0x92 },
	0xC196,	{ 0xE7, 0xBF, 0x93 },
	0xC197,	{ 0xE7, 0xBF, 0x96 },
	0xC198,	{ 0xE7, 0xBF, 0x97 },
	0xC199,	{ 0xE7, 0xBF, 0x99 },
	0xC19A,	{ 0xE7, 0xBF, 0x9A },
	0xC19B,	{ 0xE7, 0xBF, 0x9B },
	0xC19C,	{ 0xE7, 0xBF, 0x9C },
	0xC19D,	{ 0xE7, 0xBF, 0x9D },
	0xC19E,	{ 0xE7, 0xBF, 0x9E },
	0xC19F,	{ 0xE7, 0xBF, 0xA2 },
	0xC1A0,	{ 0xE7, 0xBF, 0xA3 },
	0xC1A1,	{ 0xE7, 0x97, 0xA2 },
	0xC1A2,	{ 0xE7, 0xAB, 0x8B },
	0xC1A3,	{ 0xE7, 0xB2, 0x92 },
	0xC1A4,	{ 0xE6, 0xB2, 0xA5 },
	0xC1A5,	{ 0xE9, 0x9A, 0xB6 },
	0xC1A6,	{ 0xE5, 0x8A, 0x9B },
	0xC1A7,	{ 0xE7, 0x92, 0x83 },
	0xC1A8,	{ 0xE5, 0x93, 0xA9 },
	0xC1A9,	{ 0xE4, 0xBF, 0xA9 },
	0xC1AA,	{ 0xE8, 0x81, 0x94 },
	0xC1AB,	{ 0xE8, 0x8E, 0xB2 },
	0xC1AC,	{ 0xE8, 0xBF, 0x9E },
	0xC1AD,	{ 0xE9, 0x95, 0xB0 },
	0xC1AE,	{ 0xE5, 0xBB, 0x89 },
	0xC1AF,	{ 0xE6, 0x80, 0x9C },
	0xC1B0,	{ 0xE6, 0xB6, 0x9F },
	0xC1B1,	{ 0xE5, 0xB8, 0x98 },
	0xC1B2,	{ 0xE6, 0x95, 0x9B },
	0xC1B3,	{ 0xE8, 0x84, 0xB8 },
	0xC1B4,	{ 0xE9, 0x93, 0xBE },
	0xC1B5,	{ 0xE6, 0x81, 0x8B },
	0xC1B6,	{ 0xE7, 0x82, 0xBC },
	0xC1B7,	{ 0xE7, 0xBB, 0x83 },
	0xC1B8,	{ 0xE7, 0xB2, 0xAE },
	0xC1B9,	{ 0xE5, 0x87, 0x89 },
	0xC1BA,	{ 0xE6, 0xA2, 0x81 },
	0xC1BB,	{ 0xE7, 0xB2, 0xB1 },
	0xC1BC,	{ 0xE8, 0x89, 0xAF },
	0xC1BD,	{ 0xE4, 0xB8, 0xA4 },
	0xC1BE,	{ 0xE8, 0xBE, 0x86 },
	0xC1BF,	{ 0xE9, 0x87, 0x8F },
	0xC1C0,	{ 0xE6, 0x99, 0xBE },
	0xC1C1,	{ 0xE4, 0xBA, 0xAE },
	0xC1C2,	{ 0xE8, 0xB0, 0x85 },
	0xC1C3,	{ 0xE6, 0x92, 0xA9 },
	0xC1C4,	{ 0xE8, 0x81, 0x8A },
	0xC1C5,	{ 0xE5, 0x83, 0x9A },
	0xC1C6,	{ 0xE7, 0x96, 0x97 },
	0xC1C7,	{ 0xE7, 0x87, 0x8E },
	0xC1C8,	{ 0xE5, 0xAF, 0xA5 },
	0xC1C9,	{ 0xE8, 0xBE, 0xBD },
	0xC1CA,	{ 0xE6, 0xBD, 0xA6 },
	0xC1CB,	{ 0xE4, 0xBA, 0x86 },
	0xC1CC,	{ 0xE6, 0x92, 0x82 },
	0xC1CD,	{ 0xE9, 0x95, 0xA3 },
	0xC1CE,	{ 0xE5, 0xBB, 0x96 },
	0xC1CF,	{ 0xE6, 0x96, 0x99 },
	0xC1D0,	{ 0xE5, 0x88, 0x97 },
	0xC1D1,	{ 0xE8, 0xA3, 0x82 },
	0xC1D2,	{ 0xE7, 0x83, 0x88 },
	0xC1D3,	{ 0xE5, 0x8A, 0xA3 },
	0xC1D4,	{ 0xE7, 0x8C, 0x8E },
	0xC1D5,	{ 0xE7, 0x90, 0xB3 },
	0xC1D6,	{ 0xE6, 0x9E, 0x97 },
	0xC1D7,	{ 0xE7, 0xA3, 0xB7 },
	0xC1D8,	{ 0xE9, 0x9C, 0x96 },
	0xC1D9,	{ 0xE4, 0xB8, 0xB4 },
	0xC1DA,	{ 0xE9, 0x82, 0xBB },
	0xC1DB,	{ 0xE9, 0xB3, 0x9E },
	0xC1DC,	{ 0xE6, 0xB7, 0x8B },
	0xC1DD,	{ 0xE5, 0x87, 0x9B },
	0xC1DE,	{ 0xE8, 0xB5, 0x81 },
	0xC1DF,	{ 0xE5, 0x90, 0x9D },
	0xC1E0,	{ 0xE6, 0x8B, 0x8E },
	0xC1E1,	{ 0xE7, 0x8E, 0xB2 },
	0xC1E2,	{ 0xE8, 0x8F, 0xB1 },
	0xC1E3,	{ 0xE9, 0x9B, 0xB6 },
	0xC1E4,	{ 0xE9, 0xBE, 0x84 },
	0xC1E5,	{ 0xE9, 0x93, 0x83 },
	0xC1E6,	{ 0xE4, 0xBC, 0xB6 },
	0xC1E7,	{ 0xE7, 0xBE, 0x9A },
	0xC1E8,	{ 0xE5, 0x87, 0x8C },
	0xC1E9,	{ 0xE7, 0x81, 0xB5 },
	0xC1EA,	{ 0xE9, 0x99, 0xB5 },
	0xC1EB,	{ 0xE5, 0xB2, 0xAD },
	0xC1EC,	{ 0xE9, 0xA2, 0x86 },
	0xC1ED,	{ 0xE5, 0x8F, 0xA6 },
	0xC1EE,	{ 0xE4, 0xBB, 0xA4 },
	0xC1EF,	{ 0xE6, 0xBA, 0x9C },
	0xC1F0,	{ 0xE7, 0x90, 0x89 },
	0xC1F1,	{ 0xE6, 0xA6, 0xB4 },
	0xC1F2,	{ 0xE7, 0xA1, 0xAB },
	0xC1F3,	{ 0xE9, 0xA6, 0x8F },
	0xC1F4,	{ 0xE7, 0x95, 0x99 },
	0xC1F5,	{ 0xE5, 0x88, 0x98 },
	0xC1F6,	{ 0xE7, 0x98, 0xA4 },
	0xC1F7,	{ 0xE6, 0xB5, 0x81 },
	0xC1F8,	{ 0xE6, 0x9F, 0xB3 },
	0xC1F9,	{ 0xE5, 0x85, 0xAD },
	0xC1FA,	{ 0xE9, 0xBE, 0x99 },
	0xC1FB,	{ 0xE8, 0x81, 0x8B },
	0xC1FC,	{ 0xE5, 0x92, 0x99 },
	0xC1FD,	{ 0xE7, 0xAC, 0xBC },
	0xC1FE,	{ 0xE7, 0xAA, 0xBF },
	0xC240,	{ 0xE7, 0xBF, 0xA4 },
	0xC241,	{ 0xE7, 0xBF, 0xA7 },
	0xC242,	{ 0xE7, 0xBF, 0xA8 },
	0xC243,	{ 0xE7, 0xBF, 0xAA },
	0xC244,	{ 0xE7, 0xBF, 0xAB },
	0xC245,	{ 0xE7, 0xBF, 0xAC },
	0xC246,	{ 0xE7, 0xBF, 0xAD },
	0xC247,	{ 0xE7, 0xBF, 0xAF },
	0xC248,	{ 0xE7, 0xBF, 0xB2 },
	0xC249,	{ 0xE7, 0xBF, 0xB4 },
	0xC24A,	{ 0xE7, 0xBF, 0xB5 },
	0xC24B,	{ 0xE7, 0xBF, 0xB6 },
	0xC24C,	{ 0xE7, 0xBF, 0xB7 },
	0xC24D,	{ 0xE7, 0xBF, 0xB8 },
	0xC24E,	{ 0xE7, 0xBF, 0xB9 },
	0xC24F,	{ 0xE7, 0xBF, 0xBA },
	0xC250,	{ 0xE7, 0xBF, 0xBD },
	0xC251,	{ 0xE7, 0xBF, 0xBE },
	0xC252,	{ 0xE7, 0xBF, 0xBF },
	0xC253,	{ 0xE8, 0x80, 0x82 },
	0xC254,	{ 0xE8, 0x80, 0x87 },
	0xC255,	{ 0xE8, 0x80, 0x88 },
	0xC256,	{ 0xE8, 0x80, 0x89 },
	0xC257,	{ 0xE8, 0x80, 0x8A },
	0xC258,	{ 0xE8, 0x80, 0x8E },
	0xC259,	{ 0xE8, 0x80, 0x8F },
	0xC25A,	{ 0xE8, 0x80, 0x91 },
	0xC25B,	{ 0xE8, 0x80, 0x93 },
	0xC25C,	{ 0xE8, 0x80, 0x9A },
	0xC25D,	{ 0xE8, 0x80, 0x9B },
	0xC25E,	{ 0xE8, 0x80, 0x9D },
	0xC25F,	{ 0xE8, 0x80, 0x9E },
	0xC260,	{ 0xE8, 0x80, 0x9F },
	0xC261,	{ 0xE8, 0x80, 0xA1 },
	0xC262,	{ 0xE8, 0x80, 0xA3 },
	0xC263,	{ 0xE8, 0x80, 0xA4 },
	0xC264,	{ 0xE8, 0x80, 0xAB },
	0xC265,	{ 0xE8, 0x80, 0xAC },
	0xC266,	{ 0xE8, 0x80, 0xAD },
	0xC267,	{ 0xE8, 0x80, 0xAE },
	0xC268,	{ 0xE8, 0x80, 0xAF },
	0xC269,	{ 0xE8, 0x80, 0xB0 },
	0xC26A,	{ 0xE8, 0x80, 0xB2 },
	0xC26B,	{ 0xE8, 0x80, 0xB4 },
	0xC26C,	{ 0xE8, 0x80, 0xB9 },
	0xC26D,	{ 0xE8, 0x80, 0xBA },
	0xC26E,	{ 0xE8, 0x80, 0xBC },
	0xC26F,	{ 0xE8, 0x80, 0xBE },
	0xC270,	{ 0xE8, 0x81, 0x80 },
	0xC271,	{ 0xE8, 0x81, 0x81 },
	0xC272,	{ 0xE8, 0x81, 0x84 },
	0xC273,	{ 0xE8, 0x81, 0x85 },
	0xC274,	{ 0xE8, 0x81, 0x87 },
	0xC275,	{ 0xE8, 0x81, 0x88 },
	0xC276,	{ 0xE8, 0x81, 0x89 },
	0xC277,	{ 0xE8, 0x81, 0x8E },
	0xC278,	{ 0xE8, 0x81, 0x8F },
	0xC279,	{ 0xE8, 0x81, 0x90 },
	0xC27A,	{ 0xE8, 0x81, 0x91 },
	0xC27B,	{ 0xE8, 0x81, 0x93 },
	0xC27C,	{ 0xE8, 0x81, 0x95 },
	0xC27D,	{ 0xE8, 0x81, 0x96 },
	0xC27E,	{ 0xE8, 0x81, 0x97 },
	0xC280,	{ 0xE8, 0x81, 0x99 },
	0xC281,	{ 0xE8, 0x81, 0x9B },
	0xC282,	{ 0xE8, 0x81, 0x9C },
	0xC283,	{ 0xE8, 0x81, 0x9D },
	0xC284,	{ 0xE8, 0x81, 0x9E },
	0xC285,	{ 0xE8, 0x81, 0x9F },
	0xC286,	{ 0xE8, 0x81, 0xA0 },
	0xC287,	{ 0xE8, 0x81, 0xA1 },
	0xC288,	{ 0xE8, 0x81, 0xA2 },
	0xC289,	{ 0xE8, 0x81, 0xA3 },
	0xC28A,	{ 0xE8, 0x81, 0xA4 },
	0xC28B,	{ 0xE8, 0x81, 0xA5 },
	0xC28C,	{ 0xE8, 0x81, 0xA6 },
	0xC28D,	{ 0xE8, 0x81, 0xA7 },
	0xC28E,	{ 0xE8, 0x81, 0xA8 },
	0xC28F,	{ 0xE8, 0x81, 0xAB },
	0xC290,	{ 0xE8, 0x81, 0xAC },
	0xC291,	{ 0xE8, 0x81, 0xAD },
	0xC292,	{ 0xE8, 0x81, 0xAE },
	0xC293,	{ 0xE8, 0x81, 0xAF },
	0xC294,	{ 0xE8, 0x81, 0xB0 },
	0xC295,	{ 0xE8, 0x81, 0xB2 },
	0xC296,	{ 0xE8, 0x81, 0xB3 },
	0xC297,	{ 0xE8, 0x81, 0xB4 },
	0xC298,	{ 0xE8, 0x81, 0xB5 },
	0xC299,	{ 0xE8, 0x81, 0xB6 },
	0xC29A,	{ 0xE8, 0x81, 0xB7 },
	0xC29B,	{ 0xE8, 0x81, 0xB8 },
	0xC29C,	{ 0xE8, 0x81, 0xB9 },
	0xC29D,	{ 0xE8, 0x81, 0xBA },
	0xC29E,	{ 0xE8, 0x81, 0xBB },
	0xC29F,	{ 0xE8, 0x81, 0xBC },
	0xC2A0,	{ 0xE8, 0x81, 0xBD },
	0xC2A1,	{ 0xE9, 0x9A, 0x86 },
	0xC2A2,	{ 0xE5, 0x9E, 0x84 },
	0xC2A3,	{ 0xE6, 0x8B, 0xA2 },
	0xC2A4,	{ 0xE9, 0x99, 0x87 },
	0xC2A5,	{ 0xE6, 0xA5, 0xBC },
	0xC2A6,	{ 0xE5, 0xA8, 0x84 },
	0xC2A7,	{ 0xE6, 0x90, 0x82 },
	0xC2A8,	{ 0xE7, 0xAF, 0x93 },
	0xC2A9,	{ 0xE6, 0xBC, 0x8F },
	0xC2AA,	{ 0xE9, 0x99, 0x8B },
	0xC2AB,	{ 0xE8, 0x8A, 0xA6 },
	0xC2AC,	{ 0xE5, 0x8D, 0xA2 },
	0xC2AD,	{ 0xE9, 0xA2, 0x85 },
	0xC2AE,	{ 0xE5, 0xBA, 0x90 },
	0xC2AF,	{ 0xE7, 0x82, 0x89 },
	0xC2B0,	{ 0xE6, 0x8E, 0xB3 },
	0xC2B1,	{ 0xE5, 0x8D, 0xA4 },
	0xC2B2,	{ 0xE8, 0x99, 0x8F },
	0xC2B3,	{ 0xE9, 0xB2, 0x81 },
	0xC2B4,	{ 0xE9, 0xBA, 0x93 },
	0xC2B5,	{ 0xE7, 0xA2, 0x8C },
	0xC2B6,	{ 0xE9, 0x9C, 0xB2 },
	0xC2B7,	{ 0xE8, 0xB7, 0xAF },
	0xC2B8,	{ 0xE8, 0xB5, 0x82 },
	0xC2B9,	{ 0xE9, 0xB9, 0xBF },
	0xC2BA,	{ 0xE6, 0xBD, 0x9E },
	0xC2BB,	{ 0xE7, 0xA6, 0x84 },
	0xC2BC,	{ 0xE5, 0xBD, 0x95 },
	0xC2BD,	{ 0xE9, 0x99, 0x86 },
	0xC2BE,	{ 0xE6, 0x88, 0xAE },
	0xC2BF,	{ 0xE9, 0xA9, 0xB4 },
	0xC2C0,	{ 0xE5, 0x90, 0x95 },
	0xC2C1,	{ 0xE9, 0x93, 0x9D },
	0xC2C2,	{ 0xE4, 0xBE, 0xA3 },
	0xC2C3,	{ 0xE6, 0x97, 0x85 },
	0xC2C4,	{ 0xE5, 0xB1, 0xA5 },
	0xC2C5,	{ 0xE5, 0xB1, 0xA1 },
	0xC2C6,	{ 0xE7, 0xBC, 0x95 },
	0xC2C7,	{ 0xE8, 0x99, 0x91 },
	0xC2C8,	{ 0xE6, 0xB0, 0xAF },
	0xC2C9,	{ 0xE5, 0xBE, 0x8B },
	0xC2CA,	{ 0xE7, 0x8E, 0x87 },
	0xC2CB,	{ 0xE6, 0xBB, 0xA4 },
	0xC2CC,	{ 0xE7, 0xBB, 0xBF },
	0xC2CD,	{ 0xE5, 0xB3, 0xA6 },
	0xC2CE,	{ 0xE6, 0x8C, 0x9B },
	0xC2CF,	{ 0xE5, 0xAD, 0xAA },
	0xC2D0,	{ 0xE6, 0xBB, 0xA6 },
	0xC2D1,	{ 0xE5, 0x8D, 0xB5 },
	0xC2D2,	{ 0xE4, 0xB9, 0xB1 },
	0xC2D3,	{ 0xE6, 0x8E, 0xA0 },
	0xC2D4,	{ 0xE7, 0x95, 0xA5 },
	0xC2D5,	{ 0xE6, 0x8A, 0xA1 },
	0xC2D6,	{ 0xE8, 0xBD, 0xAE },
	0xC2D7,	{ 0xE4, 0xBC, 0xA6 },
	0xC2D8,	{ 0xE4, 0xBB, 0x91 },
	0xC2D9,	{ 0xE6, 0xB2, 0xA6 },
	0xC2DA,	{ 0xE7, 0xBA, 0xB6 },
	0xC2DB,	{ 0xE8, 0xAE, 0xBA },
	0xC2DC,	{ 0xE8, 0x90, 0x9D },
	0xC2DD,	{ 0xE8, 0x9E, 0xBA },
	0xC2DE,	{ 0xE7, 0xBD, 0x97 },
	0xC2DF,	{ 0xE9, 0x80, 0xBB },
	0xC2E0,	{ 0xE9, 0x94, 0xA3 },
	0xC2E1,	{ 0xE7, 0xAE, 0xA9 },
	0xC2E2,	{ 0xE9, 0xAA, 0xA1 },
	0xC2E3,	{ 0xE8, 0xA3, 0xB8 },
	0xC2E4,	{ 0xE8, 0x90, 0xBD },
	0xC2E5,	{ 0xE6, 0xB4, 0x9B },
	0xC2E6,	{ 0xE9, 0xAA, 0x86 },
	0xC2E7,	{ 0xE7, 0xBB, 0x9C },
	0xC2E8,	{ 0xE5, 0xA6, 0x88 },
	0xC2E9,	{ 0xE9, 0xBA, 0xBB },
	0xC2EA,	{ 0xE7, 0x8E, 0x9B },
	0xC2EB,	{ 0xE7, 0xA0, 0x81 },
	0xC2EC,	{ 0xE8, 0x9A, 0x82 },
	0xC2ED,	{ 0xE9, 0xA9, 0xAC },
	0xC2EE,	{ 0xE9, 0xAA, 0x82 },
	0xC2EF,	{ 0xE5, 0x98, 0x9B },
	0xC2F0,	{ 0xE5, 0x90, 0x97 },
	0xC2F1,	{ 0xE5, 0x9F, 0x8B },
	0xC2F2,	{ 0xE4, 0xB9, 0xB0 },
	0xC2F3,	{ 0xE9, 0xBA, 0xA6 },
	0xC2F4,	{ 0xE5, 0x8D, 0x96 },
	0xC2F5,	{ 0xE8, 0xBF, 0x88 },
	0xC2F6,	{ 0xE8, 0x84, 0x89 },
	0xC2F7,	{ 0xE7, 0x9E, 0x92 },
	0xC2F8,	{ 0xE9, 0xA6, 0x92 },
	0xC2F9,	{ 0xE8, 0x9B, 0xAE },
	0xC2FA,	{ 0xE6, 0xBB, 0xA1 },
	0xC2FB,	{ 0xE8, 0x94, 0x93 },
	0xC2FC,	{ 0xE6, 0x9B, 0xBC },
	0xC2FD,	{ 0xE6, 0x85, 0xA2 },
	0xC2FE,	{ 0xE6, 0xBC, 0xAB },
	0xC340,	{ 0xE8, 0x81, 0xBE },
	0xC341,	{ 0xE8, 0x82, 0x81 },
	0xC342,	{ 0xE8, 0x82, 0x82 },
	0xC343,	{ 0xE8, 0x82, 0x85 },
	0xC344,	{ 0xE8, 0x82, 0x88 },
	0xC345,	{ 0xE8, 0x82, 0x8A },
	0xC346,	{ 0xE8, 0x82, 0x8D },
	0xC347,	{ 0xE8, 0x82, 0x8E },
	0xC348,	{ 0xE8, 0x82, 0x8F },
	0xC349,	{ 0xE8, 0x82, 0x90 },
	0xC34A,	{ 0xE8, 0x82, 0x91 },
	0xC34B,	{ 0xE8, 0x82, 0x92 },
	0xC34C,	{ 0xE8, 0x82, 0x94 },
	0xC34D,	{ 0xE8, 0x82, 0x95 },
	0xC34E,	{ 0xE8, 0x82, 0x97 },
	0xC34F,	{ 0xE8, 0x82, 0x99 },
	0xC350,	{ 0xE8, 0x82, 0x9E },
	0xC351,	{ 0xE8, 0x82, 0xA3 },
	0xC352,	{ 0xE8, 0x82, 0xA6 },
	0xC353,	{ 0xE8, 0x82, 0xA7 },
	0xC354,	{ 0xE8, 0x82, 0xA8 },
	0xC355,	{ 0xE8, 0x82, 0xAC },
	0xC356,	{ 0xE8, 0x82, 0xB0 },
	0xC357,	{ 0xE8, 0x82, 0xB3 },
	0xC358,	{ 0xE8, 0x82, 0xB5 },
	0xC359,	{ 0xE8, 0x82, 0xB6 },
	0xC35A,	{ 0xE8, 0x82, 0xB8 },
	0xC35B,	{ 0xE8, 0x82, 0xB9 },
	0xC35C,	{ 0xE8, 0x82, 0xBB },
	0xC35D,	{ 0xE8, 0x83, 0x85 },
	0xC35E,	{ 0xE8, 0x83, 0x87 },
	0xC35F,	{ 0xE8, 0x83, 0x88 },
	0xC360,	{ 0xE8, 0x83, 0x89 },
	0xC361,	{ 0xE8, 0x83, 0x8A },
	0xC362,	{ 0xE8, 0x83, 0x8B },
	0xC363,	{ 0xE8, 0x83, 0x8F },
	0xC364,	{ 0xE8, 0x83, 0x90 },
	0xC365,	{ 0xE8, 0x83, 0x91 },
	0xC366,	{ 0xE8, 0x83, 0x92 },
	0xC367,	{ 0xE8, 0x83, 0x93 },
	0xC368,	{ 0xE8, 0x83, 0x94 },
	0xC369,	{ 0xE8, 0x83, 0x95 },
	0xC36A,	{ 0xE8, 0x83, 0x98 },
	0xC36B,	{ 0xE8, 0x83, 0x9F },
	0xC36C,	{ 0xE8, 0x83, 0xA0 },
	0xC36D,	{ 0xE8, 0x83, 0xA2 },
	0xC36E,	{ 0xE8, 0x83, 0xA3 },
	0xC36F,	{ 0xE8, 0x83, 0xA6 },
	0xC370,	{ 0xE8, 0x83, 0xAE },
	0xC371,	{ 0xE8, 0x83, 0xB5 },
	0xC372,	{ 0xE8, 0x83, 0xB7 },
	0xC373,	{ 0xE8, 0x83, 0xB9 },
	0xC374,	{ 0xE8, 0x83, 0xBB },
	0xC375,	{ 0xE8, 0x83, 0xBE },
	0xC376,	{ 0xE8, 0x83, 0xBF },
	0xC377,	{ 0xE8, 0x84, 0x80 },
	0xC378,	{ 0xE8, 0x84, 0x81 },
	0xC379,	{ 0xE8, 0x84, 0x83 },
	0xC37A,	{ 0xE8, 0x84, 0x84 },
	0xC37B,	{ 0xE8, 0x84, 0x85 },
	0xC37C,	{ 0xE8, 0x84, 0x87 },
	0xC37D,	{ 0xE8, 0x84, 0x88 },
	0xC37E,	{ 0xE8, 0x84, 0x8B },
	0xC380,	{ 0xE8, 0x84, 0x8C },
	0xC381,	{ 0xE8, 0x84, 0x95 },
	0xC382,	{ 0xE8, 0x84, 0x97 },
	0xC383,	{ 0xE8, 0x84, 0x99 },
	0xC384,	{ 0xE8, 0x84, 0x9B },
	0xC385,	{ 0xE8, 0x84, 0x9C },
	0xC386,	{ 0xE8, 0x84, 0x9D },
	0xC387,	{ 0xE8, 0x84, 0x9F },
	0xC388,	{ 0xE8, 0x84, 0xA0 },
	0xC389,	{ 0xE8, 0x84, 0xA1 },
	0xC38A,	{ 0xE8, 0x84, 0xA2 },
	0xC38B,	{ 0xE8, 0x84, 0xA3 },
	0xC38C,	{ 0xE8, 0x84, 0xA4 },
	0xC38D,	{ 0xE8, 0x84, 0xA5 },
	0xC38E,	{ 0xE8, 0x84, 0xA6 },
	0xC38F,	{ 0xE8, 0x84, 0xA7 },
	0xC390,	{ 0xE8, 0x84, 0xA8 },
	0xC391,	{ 0xE8, 0x84, 0xA9 },
	0xC392,	{ 0xE8, 0x84, 0xAA },
	0xC393,	{ 0xE8, 0x84, 0xAB },
	0xC394,	{ 0xE8, 0x84, 0xAD },
	0xC395,	{ 0xE8, 0x84, 0xAE },
	0xC396,	{ 0xE8, 0x84, 0xB0 },
	0xC397,	{ 0xE8, 0x84, 0xB3 },
	0xC398,	{ 0xE8, 0x84, 0xB4 },
	0xC399,	{ 0xE8, 0x84, 0xB5 },
	0xC39A,	{ 0xE8, 0x84, 0xB7 },
	0xC39B,	{ 0xE8, 0x84, 0xB9 },
	0xC39C,	{ 0xE8, 0x84, 0xBA },
	0xC39D,	{ 0xE8, 0x84, 0xBB },
	0xC39E,	{ 0xE8, 0x84, 0xBC },
	0xC39F,	{ 0xE8, 0x84, 0xBD },
	0xC3A0,	{ 0xE8, 0x84, 0xBF },
	0xC3A1,	{ 0xE8, 0xB0, 0xA9 },
	0xC3A2,	{ 0xE8, 0x8A, 0x92 },
	0xC3A3,	{ 0xE8, 0x8C, 0xAB },
	0xC3A4,	{ 0xE7, 0x9B, 0xB2 },
	0xC3A5,	{ 0xE6, 0xB0, 0x93 },
	0xC3A6,	{ 0xE5, 0xBF, 0x99 },
	0xC3A7,	{ 0xE8, 0x8E, 0xBD },
	0xC3A8,	{ 0xE7, 0x8C, 0xAB },
	0xC3A9,	{ 0xE8, 0x8C, 0x85 },
	0xC3AA,	{ 0xE9, 0x94, 0x9A },
	0xC3AB,	{ 0xE6, 0xAF, 0x9B },
	0xC3AC,	{ 0xE7, 0x9F, 0x9B },
	0xC3AD,	{ 0xE9, 0x93, 0x86 },
	0xC3AE,	{ 0xE5, 0x8D, 0xAF },
	0xC3AF,	{ 0xE8, 0x8C, 0x82 },
	0xC3B0,	{ 0xE5, 0x86, 0x92 },
	0xC3B1,	{ 0xE5, 0xB8, 0xBD },
	0xC3B2,	{ 0xE8, 0xB2, 0x8C },
	0xC3B3,	{ 0xE8, 0xB4, 0xB8 },
	0xC3B4,	{ 0xE4, 0xB9, 0x88 },
	0xC3B5,	{ 0xE7, 0x8E, 0xAB },
	0xC3B6,	{ 0xE6, 0x9E, 0x9A },
	0xC3B7,	{ 0xE6, 0xA2, 0x85 },
	0xC3B8,	{ 0xE9, 0x85, 0xB6 },
	0xC3B9,	{ 0xE9, 0x9C, 0x89 },
	0xC3BA,	{ 0xE7, 0x85, 0xA4 },
	0xC3BB,	{ 0xE6, 0xB2, 0xA1 },
	0xC3BC,	{ 0xE7, 0x9C, 0x89 },
	0xC3BD,	{ 0xE5, 0xAA, 0x92 },
	0xC3BE,	{ 0xE9, 0x95, 0x81 },
	0xC3BF,	{ 0xE6, 0xAF, 0x8F },
	0xC3C0,	{ 0xE7, 0xBE, 0x8E },
	0xC3C1,	{ 0xE6, 0x98, 0xA7 },
	0xC3C2,	{ 0xE5, 0xAF, 0x90 },
	0xC3C3,	{ 0xE5, 0xA6, 0xB9 },
	0xC3C4,	{ 0xE5, 0xAA, 0x9A },
	0xC3C5,	{ 0xE9, 0x97, 0xA8 },
	0xC3C6,	{ 0xE9, 0x97, 0xB7 },
	0xC3C7,	{ 0xE4, 0xBB, 0xAC },
	0xC3C8,	{ 0xE8, 0x90, 0x8C },
	0xC3C9,	{ 0xE8, 0x92, 0x99 },
	0xC3CA,	{ 0xE6, 0xAA, 0xAC },
	0xC3CB,	{ 0xE7, 0x9B, 0x9F },
	0xC3CC,	{ 0xE9, 0x94, 0xB0 },
	0xC3CD,	{ 0xE7, 0x8C, 0x9B },
	0xC3CE,	{ 0xE6, 0xA2, 0xA6 },
	0xC3CF,	{ 0xE5, 0xAD, 0x9F },
	0xC3D0,	{ 0xE7, 0x9C, 0xAF },
	0xC3D1,	{ 0xE9, 0x86, 0x9A },
	0xC3D2,	{ 0xE9, 0x9D, 0xA1 },
	0xC3D3,	{ 0xE7, 0xB3, 0x9C },
	0xC3D4,	{ 0xE8, 0xBF, 0xB7 },
	0xC3D5,	{ 0xE8, 0xB0, 0x9C },
	0xC3D6,	{ 0xE5, 0xBC, 0xA5 },
	0xC3D7,	{ 0xE7, 0xB1, 0xB3 },
	0xC3D8,	{ 0xE7, 0xA7, 0x98 },
	0xC3D9,	{ 0xE8, 0xA7, 0x85 },
	0xC3DA,	{ 0xE6, 0xB3, 0x8C },
	0xC3DB,	{ 0xE8, 0x9C, 0x9C },
	0xC3DC,	{ 0xE5, 0xAF, 0x86 },
	0xC3DD,	{ 0xE5, 0xB9, 0x82 },
	0xC3DE,	{ 0xE6, 0xA3, 0x89 },
	0xC3DF,	{ 0xE7, 0x9C, 0xA0 },
	0xC3E0,	{ 0xE7, 0xBB, 0xB5 },
	0xC3E1,	{ 0xE5, 0x86, 0x95 },
	0xC3E2,	{ 0xE5, 0x85, 0x8D },
	0xC3E3,	{ 0xE5, 0x8B, 0x89 },
	0xC3E4,	{ 0xE5, 0xA8, 0xA9 },
	0xC3E5,	{ 0xE7, 0xBC, 0x85 },
	0xC3E6,	{ 0xE9, 0x9D, 0xA2 },
	0xC3E7,	{ 0xE8, 0x8B, 0x97 },
	0xC3E8,	{ 0xE6, 0x8F, 0x8F },
	0xC3E9,	{ 0xE7, 0x9E, 0x84 },
	0xC3EA,	{ 0xE8, 0x97, 0x90 },
	0xC3EB,	{ 0xE7, 0xA7, 0x92 },
	0xC3EC,	{ 0xE6, 0xB8, 0xBA },
	0xC3ED,	{ 0xE5, 0xBA, 0x99 },
	0xC3EE,	{ 0xE5, 0xA6, 0x99 },
	0xC3EF,	{ 0xE8, 0x94, 0x91 },
	0xC3F0,	{ 0xE7, 0x81, 0xAD },
	0xC3F1,	{ 0xE6, 0xB0, 0x91 },
	0xC3F2,	{ 0xE6, 0x8A, 0xBF },
	0xC3F3,	{ 0xE7, 0x9A, 0xBF },
	0xC3F4,	{ 0xE6, 0x95, 0x8F },
	0xC3F5,	{ 0xE6, 0x82, 0xAF },
	0xC3F6,	{ 0xE9, 0x97, 0xBD },
	0xC3F7,	{ 0xE6, 0x98, 0x8E },
	0xC3F8,	{ 0xE8, 0x9E, 0x9F },
	0xC3F9,	{ 0xE9, 0xB8, 0xA3 },
	0xC3FA,	{ 0xE9, 0x93, 0xAD },
	0xC3FB,	{ 0xE5, 0x90, 0x8D },
	0xC3FC,	{ 0xE5, 0x91, 0xBD },
	0xC3FD,	{ 0xE8, 0xB0, 0xAC },
	0xC3FE,	{ 0xE6, 0x91, 0xB8 },
	0xC440,	{ 0xE8, 0x85, 0x80 },
	0xC441,	{ 0xE8, 0x85, 0x81 },
	0xC442,	{ 0xE8, 0x85, 0x82 },
	0xC443,	{ 0xE8, 0x85, 0x83 },
	0xC444,	{ 0xE8, 0x85, 0x84 },
	0xC445,	{ 0xE8, 0x85, 0x85 },
	0xC446,	{ 0xE8, 0x85, 0x87 },
	0xC447,	{ 0xE8, 0x85, 0x89 },
	0xC448,	{ 0xE8, 0x85, 0x8D },
	0xC449,	{ 0xE8, 0x85, 0x8E },
	0xC44A,	{ 0xE8, 0x85, 0x8F },
	0xC44B,	{ 0xE8, 0x85, 0x92 },
	0xC44C,	{ 0xE8, 0x85, 0x96 },
	0xC44D,	{ 0xE8, 0x85, 0x97 },
	0xC44E,	{ 0xE8, 0x85, 0x98 },
	0xC44F,	{ 0xE8, 0x85, 0x9B },
	0xC450,	{ 0xE8, 0x85, 0x9C },
	0xC451,	{ 0xE8, 0x85, 0x9D },
	0xC452,	{ 0xE8, 0x85, 0x9E },
	0xC453,	{ 0xE8, 0x85, 0x9F },
	0xC454,	{ 0xE8, 0x85, 0xA1 },
	0xC455,	{ 0xE8, 0x85, 0xA2 },
	0xC456,	{ 0xE8, 0x85, 0xA3 },
	0xC457,	{ 0xE8, 0x85, 0xA4 },
	0xC458,	{ 0xE8, 0x85, 0xA6 },
	0xC459,	{ 0xE8, 0x85, 0xA8 },
	0xC45A,	{ 0xE8, 0x85, 0xAA },
	0xC45B,	{ 0xE8, 0x85, 0xAB },
	0xC45C,	{ 0xE8, 0x85, 0xAC },
	0xC45D,	{ 0xE8, 0x85, 0xAF },
	0xC45E,	{ 0xE8, 0x85, 0xB2 },
	0xC45F,	{ 0xE8, 0x85, 0xB3 },
	0xC460,	{ 0xE8, 0x85, 0xB5 },
	0xC461,	{ 0xE8, 0x85, 0xB6 },
	0xC462,	{ 0xE8, 0x85, 0xB7 },
	0xC463,	{ 0xE8, 0x85, 0xB8 },
	0xC464,	{ 0xE8, 0x86, 0x81 },
	0xC465,	{ 0xE8, 0x86, 0x83 },
	0xC466,	{ 0xE8, 0x86, 0x84 },
	0xC467,	{ 0xE8, 0x86, 0x85 },
	0xC468,	{ 0xE8, 0x86, 0x86 },
	0xC469,	{ 0xE8, 0x86, 0x87 },
	0xC46A,	{ 0xE8, 0x86, 0x89 },
	0xC46B,	{ 0xE8, 0x86, 0x8B },
	0xC46C,	{ 0xE8, 0x86, 0x8C },
	0xC46D,	{ 0xE8, 0x86, 0x8D },
	0xC46E,	{ 0xE8, 0x86, 0x8E },
	0xC46F,	{ 0xE8, 0x86, 0x90 },
	0xC470,	{ 0xE8, 0x86, 0x92 },
	0xC471,	{ 0xE8, 0x86, 0x93 },
	0xC472,	{ 0xE8, 0x86, 0x94 },
	0xC473,	{ 0xE8, 0x86, 0x95 },
	0xC474,	{ 0xE8, 0x86, 0x96 },
	0xC475,	{ 0xE8, 0x86, 0x97 },
	0xC476,	{ 0xE8, 0x86, 0x99 },
	0xC477,	{ 0xE8, 0x86, 0x9A },
	0xC478,	{ 0xE8, 0x86, 0x9E },
	0xC479,	{ 0xE8, 0x86, 0x9F },
	0xC47A,	{ 0xE8, 0x86, 0xA0 },
	0xC47B,	{ 0xE8, 0x86, 0xA1 },
	0xC47C,	{ 0xE8, 0x86, 0xA2 },
	0xC47D,	{ 0xE8, 0x86, 0xA4 },
	0xC47E,	{ 0xE8, 0x86, 0xA5 },
	0xC480,	{ 0xE8, 0x86, 0xA7 },
	0xC481,	{ 0xE8, 0x86, 0xA9 },
	0xC482,	{ 0xE8, 0x86, 0xAB },
	0xC483,	{ 0xE8, 0x86, 0xAC },
	0xC484,	{ 0xE8, 0x86, 0xAD },
	0xC485,	{ 0xE8, 0x86, 0xAE },
	0xC486,	{ 0xE8, 0x86, 0xAF },
	0xC487,	{ 0xE8, 0x86, 0xB0 },
	0xC488,	{ 0xE8, 0x86, 0xB1 },
	0xC489,	{ 0xE8, 0x86, 0xB2 },
	0xC48A,	{ 0xE8, 0x86, 0xB4 },
	0xC48B,	{ 0xE8, 0x86, 0xB5 },
	0xC48C,	{ 0xE8, 0x86, 0xB6 },
	0xC48D,	{ 0xE8, 0x86, 0xB7 },
	0xC48E,	{ 0xE8, 0x86, 0xB8 },
	0xC48F,	{ 0xE8, 0x86, 0xB9 },
	0xC490,	{ 0xE8, 0x86, 0xBC },
	0xC491,	{ 0xE8, 0x86, 0xBD },
	0xC492,	{ 0xE8, 0x86, 0xBE },
	0xC493,	{ 0xE8, 0x86, 0xBF },
	0xC494,	{ 0xE8, 0x87, 0x84 },
	0xC495,	{ 0xE8, 0x87, 0x85 },
	0xC496,	{ 0xE8, 0x87, 0x87 },
	0xC497,	{ 0xE8, 0x87, 0x88 },
	0xC498,	{ 0xE8, 0x87, 0x89 },
	0xC499,	{ 0xE8, 0x87, 0x8B },
	0xC49A,	{ 0xE8, 0x87, 0x8D },
	0xC49B,	{ 0xE8, 0x87, 0x8E },
	0xC49C,	{ 0xE8, 0x87, 0x8F },
	0xC49D,	{ 0xE8, 0x87, 0x90 },
	0xC49E,	{ 0xE8, 0x87, 0x91 },
	0xC49F,	{ 0xE8, 0x87, 0x92 },
	0xC4A0,	{ 0xE8, 0x87, 0x93 },
	0xC4A1,	{ 0xE6, 0x91, 0xB9 },
	0xC4A2,	{ 0xE8, 0x98, 0x91 },
	0xC4A3,	{ 0xE6, 0xA8, 0xA1 },
	0xC4A4,	{ 0xE8, 0x86, 0x9C },
	0xC4A5,	{ 0xE7, 0xA3, 0xA8 },
	0xC4A6,	{ 0xE6, 0x91, 0xA9 },
	0xC4A7,	{ 0xE9, 0xAD, 0x94 },
	0xC4A8,	{ 0xE6, 0x8A, 0xB9 },
	0xC4A9,	{ 0xE6, 0x9C, 0xAB },
	0xC4AA,	{ 0xE8, 0x8E, 0xAB },
	0xC4AB,	{ 0xE5, 0xA2, 0xA8 },
	0xC4AC,	{ 0xE9, 0xBB, 0x98 },
	0xC4AD,	{ 0xE6, 0xB2, 0xAB },
	0xC4AE,	{ 0xE6, 0xBC, 0xA0 },
	0xC4AF,	{ 0xE5, 0xAF, 0x9E },
	0xC4B0,	{ 0xE9, 0x99, 0x8C },
	0xC4B1,	{ 0xE8, 0xB0, 0x8B },
	0xC4B2,	{ 0xE7, 0x89, 0x9F },
	0xC4B3,	{ 0xE6, 0x9F, 0x90 },
	0xC4B4,	{ 0xE6, 0x8B, 0x87 },
	0xC4B5,	{ 0xE7, 0x89, 0xA1 },
	0xC4B6,	{ 0xE4, 0xBA, 0xA9 },
	0xC4B7,	{ 0xE5, 0xA7, 0x86 },
	0xC4B8,	{ 0xE6, 0xAF, 0x8D },
	0xC4B9,	{ 0xE5, 0xA2, 0x93 },
	0xC4BA,	{ 0xE6, 0x9A, 0xAE },
	0xC4BB,	{ 0xE5, 0xB9, 0x95 },
	0xC4BC,	{ 0xE5, 0x8B, 0x9F },
	0xC4BD,	{ 0xE6, 0x85, 0x95 },
	0xC4BE,	{ 0xE6, 0x9C, 0xA8 },
	0xC4BF,	{ 0xE7, 0x9B, 0xAE },
	0xC4C0,	{ 0xE7, 0x9D, 0xA6 },
	0xC4C1,	{ 0xE7, 0x89, 0xA7 },
	0xC4C2,	{ 0xE7, 0xA9, 0x86 },
	0xC4C3,	{ 0xE6, 0x8B, 0xBF },
	0xC4C4,	{ 0xE5, 0x93, 0xAA },
	0xC4C5,	{ 0xE5, 0x91, 0x90 },
	0xC4C6,	{ 0xE9, 0x92, 0xA0 },
	0xC4C7,	{ 0xE9, 0x82, 0xA3 },
	0xC4C8,	{ 0xE5, 0xA8, 0x9C },
	0xC4C9,	{ 0xE7, 0xBA, 0xB3 },
	0xC4CA,	{ 0xE6, 0xB0, 0x96 },
	0xC4CB,	{ 0xE4, 0xB9, 0x83 },
	0xC4CC,	{ 0xE5, 0xA5, 0xB6 },
	0xC4CD,	{ 0xE8, 0x80, 0x90 },
	0xC4CE,	{ 0xE5, 0xA5, 0x88 },
	0xC4CF,	{ 0xE5, 0x8D, 0x97 },
	0xC4D0,	{ 0xE7, 0x94, 0xB7 },
	0xC4D1,	{ 0xE9, 0x9A, 0xBE },
	0xC4D2,	{ 0xE5, 0x9B, 0x8A },
	0xC4D3,	{ 0xE6, 0x8C, 0xA0 },
	0xC4D4,	{ 0xE8, 0x84, 0x91 },
	0xC4D5,	{ 0xE6, 0x81, 0xBC },
	0xC4D6,	{ 0xE9, 0x97, 0xB9 },
	0xC4D7,	{ 0xE6, 0xB7, 0x96 },
	0xC4D8,	{ 0xE5, 0x91, 0xA2 },
	0xC4D9,	{ 0xE9, 0xA6, 0x81 },
	0xC4DA,	{ 0xE5, 0x86, 0x85 },
	0xC4DB,	{ 0xE5, 0xAB, 0xA9 },
	0xC4DC,	{ 0xE8, 0x83, 0xBD },
	0xC4DD,	{ 0xE5, 0xA6, 0xAE },
	0xC4DE,	{ 0xE9, 0x9C, 0x93 },
	0xC4DF,	{ 0xE5, 0x80, 0xAA },
	0xC4E0,	{ 0xE6, 0xB3, 0xA5 },
	0xC4E1,	{ 0xE5, 0xB0, 0xBC },
	0xC4E2,	{ 0xE6, 0x8B, 0x9F },
	0xC4E3,	{ 0xE4, 0xBD, 0xA0 },
	0xC4E4,	{ 0xE5, 0x8C, 0xBF },
	0xC4E5,	{ 0xE8, 0x85, 0xBB },
	0xC4E6,	{ 0xE9, 0x80, 0x86 },
	0xC4E7,	{ 0xE6, 0xBA, 0xBA },
	0xC4E8,	{ 0xE8, 0x94, 0xAB },
	0xC4E9,	{ 0xE6, 0x8B, 0x88 },
	0xC4EA,	{ 0xE5, 0xB9, 0xB4 },
	0xC4EB,	{ 0xE7, 0xA2, 0xBE },
	0xC4EC,	{ 0xE6, 0x92, 0xB5 },
	0xC4ED,	{ 0xE6, 0x8D, 0xBB },
	0xC4EE,	{ 0xE5, 0xBF, 0xB5 },
	0xC4EF,	{ 0xE5, 0xA8, 0x98 },
	0xC4F0,	{ 0xE9, 0x85, 0xBF },
	0xC4F1,	{ 0xE9, 0xB8, 0x9F },
	0xC4F2,	{ 0xE5, 0xB0, 0xBF },
	0xC4F3,	{ 0xE6, 0x8D, 0x8F },
	0xC4F4,	{ 0xE8, 0x81, 0x82 },
	0xC4F5,	{ 0xE5, 0xAD, 0xBD },
	0xC4F6,	{ 0xE5, 0x95, 0xAE },
	0xC4F7,	{ 0xE9, 0x95, 0x8A },
	0xC4F8,	{ 0xE9, 0x95, 0x8D },
	0xC4F9,	{ 0xE6, 0xB6, 0x85 },
	0xC4FA,	{ 0xE6, 0x82, 0xA8 },
	0xC4FB,	{ 0xE6, 0x9F, 0xA0 },
	0xC4FC,	{ 0xE7, 0x8B, 0x9E },
	0xC4FD,	{ 0xE5, 0x87, 0x9D },
	0xC4FE,	{ 0xE5, 0xAE, 0x81 },
	0xC540,	{ 0xE8, 0x87, 0x94 },
	0xC541,	{ 0xE8, 0x87, 0x95 },
	0xC542,	{ 0xE8, 0x87, 0x96 },
	0xC543,	{ 0xE8, 0x87, 0x97 },
	0xC544,	{ 0xE8, 0x87, 0x98 },
	0xC545,	{ 0xE8, 0x87, 0x99 },
	0xC546,	{ 0xE8, 0x87, 0x9A },
	0xC547,	{ 0xE8, 0x87, 0x9B },
	0xC548,	{ 0xE8, 0x87, 0x9C },
	0xC549,	{ 0xE8, 0x87, 0x9D },
	0xC54A,	{ 0xE8, 0x87, 0x9E },
	0xC54B,	{ 0xE8, 0x87, 0x9F },
	0xC54C,	{ 0xE8, 0x87, 0xA0 },
	0xC54D,	{ 0xE8, 0x87, 0xA1 },
	0xC54E,	{ 0xE8, 0x87, 0xA2 },
	0xC54F,	{ 0xE8, 0x87, 0xA4 },
	0xC550,	{ 0xE8, 0x87, 0xA5 },
	0xC551,	{ 0xE8, 0x87, 0xA6 },
	0xC552,	{ 0xE8, 0x87, 0xA8 },
	0xC553,	{ 0xE8, 0x87, 0xA9 },
	0xC554,	{ 0xE8, 0x87, 0xAB },
	0xC555,	{ 0xE8, 0x87, 0xAE },
	0xC556,	{ 0xE8, 0x87, 0xAF },
	0xC557,	{ 0xE8, 0x87, 0xB0 },
	0xC558,	{ 0xE8, 0x87, 0xB1 },
	0xC559,	{ 0xE8, 0x87, 0xB2 },
	0xC55A,	{ 0xE8, 0x87, 0xB5 },
	0xC55B,	{ 0xE8, 0x87, 0xB6 },
	0xC55C,	{ 0xE8, 0x87, 0xB7 },
	0xC55D,	{ 0xE8, 0x87, 0xB8 },
	0xC55E,	{ 0xE8, 0x87, 0xB9 },
	0xC55F,	{ 0xE8, 0x87, 0xBA },
	0xC560,	{ 0xE8, 0x87, 0xBD },
	0xC561,	{ 0xE8, 0x87, 0xBF },
	0xC562,	{ 0xE8, 0x88, 0x83 },
	0xC563,	{ 0xE8, 0x88, 0x87 },
	0xC564,	{ 0xE8, 0x88, 0x88 },
	0xC565,	{ 0xE8, 0x88, 0x89 },
	0xC566,	{ 0xE8, 0x88, 0x8A },
	0xC567,	{ 0xE8, 0x88, 0x8B },
	0xC568,	{ 0xE8, 0x88, 0x8E },
	0xC569,	{ 0xE8, 0x88, 0x8F },
	0xC56A,	{ 0xE8, 0x88, 0x91 },
	0xC56B,	{ 0xE8, 0x88, 0x93 },
	0xC56C,	{ 0xE8, 0x88, 0x95 },
	0xC56D,	{ 0xE8, 0x88, 0x96 },
	0xC56E,	{ 0xE8, 0x88, 0x97 },
	0xC56F,	{ 0xE8, 0x88, 0x98 },
	0xC570,	{ 0xE8, 0x88, 0x99 },
	0xC571,	{ 0xE8, 0x88, 0x9A },
	0xC572,	{ 0xE8, 0x88, 0x9D },
	0xC573,	{ 0xE8, 0x88, 0xA0 },
	0xC574,	{ 0xE8, 0x88, 0xA4 },
	0xC575,	{ 0xE8, 0x88, 0xA5 },
	0xC576,	{ 0xE8, 0x88, 0xA6 },
	0xC577,	{ 0xE8, 0x88, 0xA7 },
	0xC578,	{ 0xE8, 0x88, 0xA9 },
	0xC579,	{ 0xE8, 0x88, 0xAE },
	0xC57A,	{ 0xE8, 0x88, 0xB2 },
	0xC57B,	{ 0xE8, 0x88, 0xBA },
	0xC57C,	{ 0xE8, 0x88, 0xBC },
	0xC57D,	{ 0xE8, 0x88, 0xBD },
	0xC57E,	{ 0xE8, 0x88, 0xBF },
	0xC580,	{ 0xE8, 0x89, 0x80 },
	0xC581,	{ 0xE8, 0x89, 0x81 },
	0xC582,	{ 0xE8, 0x89, 0x82 },
	0xC583,	{ 0xE8, 0x89, 0x83 },
	0xC584,	{ 0xE8, 0x89, 0x85 },
	0xC585,	{ 0xE8, 0x89, 0x86 },
	0xC586,	{ 0xE8, 0x89, 0x88 },
	0xC587,	{ 0xE8, 0x89, 0x8A },
	0xC588,	{ 0xE8, 0x89, 0x8C },
	0xC589,	{ 0xE8, 0x89, 0x8D },
	0xC58A,	{ 0xE8, 0x89, 0x8E },
	0xC58B,	{ 0xE8, 0x89, 0x90 },
	0xC58C,	{ 0xE8, 0x89, 0x91 },
	0xC58D,	{ 0xE8, 0x89, 0x92 },
	0xC58E,	{ 0xE8, 0x89, 0x93 },
	0xC58F,	{ 0xE8, 0x89, 0x94 },
	0xC590,	{ 0xE8, 0x89, 0x95 },
	0xC591,	{ 0xE8, 0x89, 0x96 },
	0xC592,	{ 0xE8, 0x89, 0x97 },
	0xC593,	{ 0xE8, 0x89, 0x99 },
	0xC594,	{ 0xE8, 0x89, 0x9B },
	0xC595,	{ 0xE8, 0x89, 0x9C },
	0xC596,	{ 0xE8, 0x89, 0x9D },
	0xC597,	{ 0xE8, 0x89, 0x9E },
	0xC598,	{ 0xE8, 0x89, 0xA0 },
	0xC599,	{ 0xE8, 0x89, 0xA1 },
	0xC59A,	{ 0xE8, 0x89, 0xA2 },
	0xC59B,	{ 0xE8, 0x89, 0xA3 },
	0xC59C,	{ 0xE8, 0x89, 0xA4 },
	0xC59D,	{ 0xE8, 0x89, 0xA5 },
	0xC59E,	{ 0xE8, 0x89, 0xA6 },
	0xC59F,	{ 0xE8, 0x89, 0xA7 },
	0xC5A0,	{ 0xE8, 0x89, 0xA9 },
	0xC5A1,	{ 0xE6, 0x8B, 0xA7 },
	0xC5A2,	{ 0xE6, 0xB3, 0x9E },
	0xC5A3,	{ 0xE7, 0x89, 0x9B },
	0xC5A4,	{ 0xE6, 0x89, 0xAD },
	0xC5A5,	{ 0xE9, 0x92, 0xAE },
	0xC5A6,	{ 0xE7, 0xBA, 0xBD },
	0xC5A7,	{ 0xE8, 0x84, 0x93 },
	0xC5A8,	{ 0xE6, 0xB5, 0x93 },
	0xC5A9,	{ 0xE5, 0x86, 0x9C },
	0xC5AA,	{ 0xE5, 0xBC, 0x84 },
	0xC5AB,	{ 0xE5, 0xA5, 0xB4 },
	0xC5AC,	{ 0xE5, 0x8A, 0xAA },
	0xC5AD,	{ 0xE6, 0x80, 0x92 },
	0xC5AE,	{ 0xE5, 0xA5, 0xB3 },
	0xC5AF,	{ 0xE6, 0x9A, 0x96 },
	0xC5B0,	{ 0xE8, 0x99, 0x90 },
	0xC5B1,	{ 0xE7, 0x96, 0x9F },
	0xC5B2,	{ 0xE6, 0x8C, 0xAA },
	0xC5B3,	{ 0xE6, 0x87, 0xA6 },
	0xC5B4,	{ 0xE7, 0xB3, 0xAF },
	0xC5B5,	{ 0xE8, 0xAF, 0xBA },
	0xC5B6,	{ 0xE5, 0x93, 0xA6 },
	0xC5B7,	{ 0xE6, 0xAC, 0xA7 },
	0xC5B8,	{ 0xE9, 0xB8, 0xA5 },
	0xC5B9,	{ 0xE6, 0xAE, 0xB4 },
	0xC5BA,	{ 0xE8, 0x97, 0x95 },
	0xC5BB,	{ 0xE5, 0x91, 0x95 },
	0xC5BC,	{ 0xE5, 0x81, 0xB6 },
	0xC5BD,	{ 0xE6, 0xB2, 0xA4 },
	0xC5BE,	{ 0xE5, 0x95, 0xAA },
	0xC5BF,	{ 0xE8, 0xB6, 0xB4 },
	0xC5C0,	{ 0xE7, 0x88, 0xAC },
	0xC5C1,	{ 0xE5, 0xB8, 0x95 },
	0xC5C2,	{ 0xE6, 0x80, 0x95 },
	0xC5C3,	{ 0xE7, 0x90, 0xB6 },
	0xC5C4,	{ 0xE6, 0x8B, 0x8D },
	0xC5C5,	{ 0xE6, 0x8E, 0x92 },
	0xC5C6,	{ 0xE7, 0x89, 0x8C },
	0xC5C7,	{ 0xE5, 0xBE, 0x98 },
	0xC5C8,	{ 0xE6, 0xB9, 0x83 },
	0xC5C9,	{ 0xE6, 0xB4, 0xBE },
	0xC5CA,	{ 0xE6, 0x94, 0x80 },
	0xC5CB,	{ 0xE6, 0xBD, 0x98 },
	0xC5CC,	{ 0xE7, 0x9B, 0x98 },
	0xC5CD,	{ 0xE7, 0xA3, 0x90 },
	0xC5CE,	{ 0xE7, 0x9B, 0xBC },
	0xC5CF,	{ 0xE7, 0x95, 0x94 },
	0xC5D0,	{ 0xE5, 0x88, 0xA4 },
	0xC5D1,	{ 0xE5, 0x8F, 0x9B },
	0xC5D2,	{ 0xE4, 0xB9, 0x93 },
	0xC5D3,	{ 0xE5, 0xBA, 0x9E },
	0xC5D4,	{ 0xE6, 0x97, 0x81 },
	0xC5D5,	{ 0xE8, 0x80, 0xAA },
	0xC5D6,	{ 0xE8, 0x83, 0x96 },
	0xC5D7,	{ 0xE6, 0x8A, 0x9B },
	0xC5D8,	{ 0xE5, 0x92, 0x86 },
	0xC5D9,	{ 0xE5, 0x88, 0xA8 },
	0xC5DA,	{ 0xE7, 0x82, 0xAE },
	0xC5DB,	{ 0xE8, 0xA2, 0x8D },
	0xC5DC,	{ 0xE8, 0xB7, 0x91 },
	0xC5DD,	{ 0xE6, 0xB3, 0xA1 },
	0xC5DE,	{ 0xE5, 0x91, 0xB8 },
	0xC5DF,	{ 0xE8, 0x83, 0x9A },
	0xC5E0,	{ 0xE5, 0x9F, 0xB9 },
	0xC5E1,	{ 0xE8, 0xA3, 0xB4 },
	0xC5E2,	{ 0xE8, 0xB5, 0x94 },
	0xC5E3,	{ 0xE9, 0x99, 0xAA },
	0xC5E4,	{ 0xE9, 0x85, 0x8D },
	0xC5E5,	{ 0xE4, 0xBD, 0xA9 },
	0xC5E6,	{ 0xE6, 0xB2, 0x9B },
	0xC5E7,	{ 0xE5, 0x96, 0xB7 },
	0xC5E8,	{ 0xE7, 0x9B, 0x86 },
	0xC5E9,	{ 0xE7, 0xA0, 0xB0 },
	0xC5EA,	{ 0xE6, 0x8A, 0xA8 },
	0xC5EB,	{ 0xE7, 0x83, 0xB9 },
	0xC5EC,	{ 0xE6, 0xBE, 0x8E },
	0xC5ED,	{ 0xE5, 0xBD, 0xAD },
	0xC5EE,	{ 0xE8, 0x93, 0xAC },
	0xC5EF,	{ 0xE6, 0xA3, 0x9A },
	0xC5F0,	{ 0xE7, 0xA1, 0xBC },
	0xC5F1,	{ 0xE7, 0xAF, 0xB7 },
	0xC5F2,	{ 0xE8, 0x86, 0xA8 },
	0xC5F3,	{ 0xE6, 0x9C, 0x8B },
	0xC5F4,	{ 0xE9, 0xB9, 0x8F },
	0xC5F5,	{ 0xE6, 0x8D, 0xA7 },
	0xC5F6,	{ 0xE7, 0xA2, 0xB0 },
	0xC5F7,	{ 0xE5, 0x9D, 0xAF },
	0xC5F8,	{ 0xE7, 0xA0, 0x92 },
	0xC5F9,	{ 0xE9, 0x9C, 0xB9 },
	0xC5FA,	{ 0xE6, 0x89, 0xB9 },
	0xC5FB,	{ 0xE6, 0x8A, 0xAB },
	0xC5FC,	{ 0xE5, 0x8A, 0x88 },
	0xC5FD,	{ 0xE7, 0x90, 0xB5 },
	0xC5FE,	{ 0xE6, 0xAF, 0x97 },
	0xC640,	{ 0xE8, 0x89, 0xAA },
	0xC641,	{ 0xE8, 0x89, 0xAB },
	0xC642,	{ 0xE8, 0x89, 0xAC },
	0xC643,	{ 0xE8, 0x89, 0xAD },
	0xC644,	{ 0xE8, 0x89, 0xB1 },
	0xC645,	{ 0xE8, 0x89, 0xB5 },
	0xC646,	{ 0xE8, 0x89, 0xB6 },
	0xC647,	{ 0xE8, 0x89, 0xB7 },
	0xC648,	{ 0xE8, 0x89, 0xB8 },
	0xC649,	{ 0xE8, 0x89, 0xBB },
	0xC64A,	{ 0xE8, 0x89, 0xBC },
	0xC64B,	{ 0xE8, 0x8A, 0x80 },
	0xC64C,	{ 0xE8, 0x8A, 0x81 },
	0xC64D,	{ 0xE8, 0x8A, 0x83 },
	0xC64E,	{ 0xE8, 0x8A, 0x85 },
	0xC64F,	{ 0xE8, 0x8A, 0x86 },
	0xC650,	{ 0xE8, 0x8A, 0x87 },
	0xC651,	{ 0xE8, 0x8A, 0x89 },
	0xC652,	{ 0xE8, 0x8A, 0x8C },
	0xC653,	{ 0xE8, 0x8A, 0x90 },
	0xC654,	{ 0xE8, 0x8A, 0x93 },
	0xC655,	{ 0xE8, 0x8A, 0x94 },
	0xC656,	{ 0xE8, 0x8A, 0x95 },
	0xC657,	{ 0xE8, 0x8A, 0x96 },
	0xC658,	{ 0xE8, 0x8A, 0x9A },
	0xC659,	{ 0xE8, 0x8A, 0x9B },
	0xC65A,	{ 0xE8, 0x8A, 0x9E },
	0xC65B,	{ 0xE8, 0x8A, 0xA0 },
	0xC65C,	{ 0xE8, 0x8A, 0xA2 },
	0xC65D,	{ 0xE8, 0x8A, 0xA3 },
	0xC65E,	{ 0xE8, 0x8A, 0xA7 },
	0xC65F,	{ 0xE8, 0x8A, 0xB2 },
	0xC660,	{ 0xE8, 0x8A, 0xB5 },
	0xC661,	{ 0xE8, 0x8A, 0xB6 },
	0xC662,	{ 0xE8, 0x8A, 0xBA },
	0xC663,	{ 0xE8, 0x8A, 0xBB },
	0xC664,	{ 0xE8, 0x8A, 0xBC },
	0xC665,	{ 0xE8, 0x8A, 0xBF },
	0xC666,	{ 0xE8, 0x8B, 0x80 },
	0xC667,	{ 0xE8, 0x8B, 0x82 },
	0xC668,	{ 0xE8, 0x8B, 0x83 },
	0xC669,	{ 0xE8, 0x8B, 0x85 },
	0xC66A,	{ 0xE8, 0x8B, 0x86 },
	0xC66B,	{ 0xE8, 0x8B, 0x89 },
	0xC66C,	{ 0xE8, 0x8B, 0x90 },
	0xC66D,	{ 0xE8, 0x8B, 0x96 },
	0xC66E,	{ 0xE8, 0x8B, 0x99 },
	0xC66F,	{ 0xE8, 0x8B, 0x9A },
	0xC670,	{ 0xE8, 0x8B, 0x9D },
	0xC671,	{ 0xE8, 0x8B, 0xA2 },
	0xC672,	{ 0xE8, 0x8B, 0xA7 },
	0xC673,	{ 0xE8, 0x8B, 0xA8 },
	0xC674,	{ 0xE8, 0x8B, 0xA9 },
	0xC675,	{ 0xE8, 0x8B, 0xAA },
	0xC676,	{ 0xE8, 0x8B, 0xAC },
	0xC677,	{ 0xE8, 0x8B, 0xAD },
	0xC678,	{ 0xE8, 0x8B, 0xAE },
	0xC679,	{ 0xE8, 0x8B, 0xB0 },
	0xC67A,	{ 0xE8, 0x8B, 0xB2 },
	0xC67B,	{ 0xE8, 0x8B, 0xB3 },
	0xC67C,	{ 0xE8, 0x8B, 0xB5 },
	0xC67D,	{ 0xE8, 0x8B, 0xB6 },
	0xC67E,	{ 0xE8, 0x8B, 0xB8 },
	0xC680,	{ 0xE8, 0x8B, 0xBA },
	0xC681,	{ 0xE8, 0x8B, 0xBC },
	0xC682,	{ 0xE8, 0x8B, 0xBD },
	0xC683,	{ 0xE8, 0x8B, 0xBE },
	0xC684,	{ 0xE8, 0x8B, 0xBF },
	0xC685,	{ 0xE8, 0x8C, 0x80 },
	0xC686,	{ 0xE8, 0x8C, 0x8A },
	0xC687,	{ 0xE8, 0x8C, 0x8B },
	0xC688,	{ 0xE8, 0x8C, 0x8D },
	0xC689,	{ 0xE8, 0x8C, 0x90 },
	0xC68A,	{ 0xE8, 0x8C, 0x92 },
	0xC68B,	{ 0xE8, 0x8C, 0x93 },
	0xC68C,	{ 0xE8, 0x8C, 0x96 },
	0xC68D,	{ 0xE8, 0x8C, 0x98 },
	0xC68E,	{ 0xE8, 0x8C, 0x99 },
	0xC68F,	{ 0xE8, 0x8C, 0x9D },
	0xC690,	{ 0xE8, 0x8C, 0x9E },
	0xC691,	{ 0xE8, 0x8C, 0x9F },
	0xC692,	{ 0xE8, 0x8C, 0xA0 },
	0xC693,	{ 0xE8, 0x8C, 0xA1 },
	0xC694,	{ 0xE8, 0x8C, 0xA2 },
	0xC695,	{ 0xE8, 0x8C, 0xA3 },
	0xC696,	{ 0xE8, 0x8C, 0xA4 },
	0xC697,	{ 0xE8, 0x8C, 0xA5 },
	0xC698,	{ 0xE8, 0x8C, 0xA6 },
	0xC699,	{ 0xE8, 0x8C, 0xA9 },
	0xC69A,	{ 0xE8, 0x8C, 0xAA },
	0xC69B,	{ 0xE8, 0x8C, 0xAE },
	0xC69C,	{ 0xE8, 0x8C, 0xB0 },
	0xC69D,	{ 0xE8, 0x8C, 0xB2 },
	0xC69E,	{ 0xE8, 0x8C, 0xB7 },
	0xC69F,	{ 0xE8, 0x8C, 0xBB },
	0xC6A0,	{ 0xE8, 0x8C, 0xBD },
	0xC6A1,	{ 0xE5, 0x95, 0xA4 },
	0xC6A2,	{ 0xE8, 0x84, 0xBE },
	0xC6A3,	{ 0xE7, 0x96, 0xB2 },
	0xC6A4,	{ 0xE7, 0x9A, 0xAE },
	0xC6A5,	{ 0xE5, 0x8C, 0xB9 },
	0xC6A6,	{ 0xE7, 0x97, 0x9E },
	0xC6A7,	{ 0xE5, 0x83, 0xBB },
	0xC6A8,	{ 0xE5, 0xB1, 0x81 },
	0xC6A9,	{ 0xE8, 0xAD, 0xAC },
	0xC6AA,	{ 0xE7, 0xAF, 0x87 },
	0xC6AB,	{ 0xE5, 0x81, 0x8F },
	0xC6AC,	{ 0xE7, 0x89, 0x87 },
	0xC6AD,	{ 0xE9, 0xAA, 0x97 },
	0xC6AE,	{ 0xE9, 0xA3, 0x98 },
	0xC6AF,	{ 0xE6, 0xBC, 0x82 },
	0xC6B0,	{ 0xE7, 0x93, 0xA2 },
	0xC6B1,	{ 0xE7, 0xA5, 0xA8 },
	0xC6B2,	{ 0xE6, 0x92, 0x87 },
	0xC6B3,	{ 0xE7, 0x9E, 0xA5 },
	0xC6B4,	{ 0xE6, 0x8B, 0xBC },
	0xC6B5,	{ 0xE9, 0xA2, 0x91 },
	0xC6B6,	{ 0xE8, 0xB4, 0xAB },
	0xC6B7,	{ 0xE5, 0x93, 0x81 },
	0xC6B8,	{ 0xE8, 0x81, 0x98 },
	0xC6B9,	{ 0xE4, 0xB9, 0x92 },
	0xC6BA,	{ 0xE5, 0x9D, 0xAA },
	0xC6BB,	{ 0xE8, 0x8B, 0xB9 },
	0xC6BC,	{ 0xE8, 0x90, 0x8D },
	0xC6BD,	{ 0xE5, 0xB9, 0xB3 },
	0xC6BE,	{ 0xE5, 0x87, 0xAD },
	0xC6BF,	{ 0xE7, 0x93, 0xB6 },
	0xC6C0,	{ 0xE8, 0xAF, 0x84 },
	0xC6C1,	{ 0xE5, 0xB1, 0x8F },
	0xC6C2,	{ 0xE5, 0x9D, 0xA1 },
	0xC6C3,	{ 0xE6, 0xB3, 0xBC },
	0xC6C4,	{ 0xE9, 0xA2, 0x87 },
	0xC6C5,	{ 0xE5, 0xA9, 0x86 },
	0xC6C6,	{ 0xE7, 0xA0, 0xB4 },
	0xC6C7,	{ 0xE9, 0xAD, 0x84 },
	0xC6C8,	{ 0xE8, 0xBF, 0xAB },
	0xC6C9,	{ 0xE7, 0xB2, 0x95 },
	0xC6CA,	{ 0xE5, 0x89, 0x96 },
	0xC6CB,	{ 0xE6, 0x89, 0x91 },
	0xC6CC,	{ 0xE9, 0x93, 0xBA },
	0xC6CD,	{ 0xE4, 0xBB, 0x86 },
	0xC6CE,	{ 0xE8, 0x8E, 0x86 },
	0xC6CF,	{ 0xE8, 0x91, 0xA1 },
	0xC6D0,	{ 0xE8, 0x8F, 0xA9 },
	0xC6D1,	{ 0xE8, 0x92, 0xB2 },
	0xC6D2,	{ 0xE5, 0x9F, 0x94 },
	0xC6D3,	{ 0xE6, 0x9C, 0xB4 },
	0xC6D4,	{ 0xE5, 0x9C, 0x83 },
	0xC6D5,	{ 0xE6, 0x99, 0xAE },
	0xC6D6,	{ 0xE6, 0xB5, 0xA6 },
	0xC6D7,	{ 0xE8, 0xB0, 0xB1 },
	0xC6D8,	{ 0xE6, 0x9B, 0x9D },
	0xC6D9,	{ 0xE7, 0x80, 0x91 },
	0xC6DA,	{ 0xE6, 0x9C, 0x9F },
	0xC6DB,	{ 0xE6, 0xAC, 0xBA },
	0xC6DC,	{ 0xE6, 0xA0, 0x96 },
	0xC6DD,	{ 0xE6, 0x88, 0x9A },
	0xC6DE,	{ 0xE5, 0xA6, 0xBB },
	0xC6DF,	{ 0xE4, 0xB8, 0x83 },
	0xC6E0,	{ 0xE5, 0x87, 0x84 },
	0xC6E1,	{ 0xE6, 0xBC, 0x86 },
	0xC6E2,	{ 0xE6, 0x9F, 0x92 },
	0xC6E3,	{ 0xE6, 0xB2, 0x8F },
	0xC6E4,	{ 0xE5, 0x85, 0xB6 },
	0xC6E5,	{ 0xE6, 0xA3, 0x8B },
	0xC6E6,	{ 0xE5, 0xA5, 0x87 },
	0xC6E7,	{ 0xE6, 0xAD, 0xA7 },
	0xC6E8,	{ 0xE7, 0x95, 0xA6 },
	0xC6E9,	{ 0xE5, 0xB4, 0x8E },
	0xC6EA,	{ 0xE8, 0x84, 0x90 },
	0xC6EB,	{ 0xE9, 0xBD, 0x90 },
	0xC6EC,	{ 0xE6, 0x97, 0x97 },
	0xC6ED,	{ 0xE7, 0xA5, 0x88 },
	0xC6EE,	{ 0xE7, 0xA5, 0x81 },
	0xC6EF,	{ 0xE9, 0xAA, 0x91 },
	0xC6F0,	{ 0xE8, 0xB5, 0xB7 },
	0xC6F1,	{ 0xE5, 0xB2, 0x82 },
	0xC6F2,	{ 0xE4, 0xB9, 0x9E },
	0xC6F3,	{ 0xE4, 0xBC, 0x81 },
	0xC6F4,	{ 0xE5, 0x90, 0xAF },
	0xC6F5,	{ 0xE5, 0xA5, 0x91 },
	0xC6F6,	{ 0xE7, 0xA0, 0x8C },
	0xC6F7,	{ 0xE5, 0x99, 0xA8 },
	0xC6F8,	{ 0xE6, 0xB0, 0x94 },
	0xC6F9,	{ 0xE8, 0xBF, 0x84 },
	0xC6FA,	{ 0xE5, 0xBC, 0x83 },
	0xC6FB,	{ 0xE6, 0xB1, 0xBD },
	0xC6FC,	{ 0xE6, 0xB3, 0xA3 },
	0xC6FD,	{ 0xE8, 0xAE, 0xAB },
	0xC6FE,	{ 0xE6, 0x8E, 0x90 },
	0xC740,	{ 0xE8, 0x8C, 0xBE },
	0xC741,	{ 0xE8, 0x8C, 0xBF },
	0xC742,	{ 0xE8, 0x8D, 0x81 },
	0xC743,	{ 0xE8, 0x8D, 0x82 },
	0xC744,	{ 0xE8, 0x8D, 0x84 },
	0xC745,	{ 0xE8, 0x8D, 0x85 },
	0xC746,	{ 0xE8, 0x8D, 0x88 },
	0xC747,	{ 0xE8, 0x8D, 0x8A },
	0xC748,	{ 0xE8, 0x8D, 0x8B },
	0xC749,	{ 0xE8, 0x8D, 0x8C },
	0xC74A,	{ 0xE8, 0x8D, 0x8D },
	0xC74B,	{ 0xE8, 0x8D, 0x8E },
	0xC74C,	{ 0xE8, 0x8D, 0x93 },
	0xC74D,	{ 0xE8, 0x8D, 0x95 },
	0xC74E,	{ 0xE8, 0x8D, 0x96 },
	0xC74F,	{ 0xE8, 0x8D, 0x97 },
	0xC750,	{ 0xE8, 0x8D, 0x98 },
	0xC751,	{ 0xE8, 0x8D, 0x99 },
	0xC752,	{ 0xE8, 0x8D, 0x9D },
	0xC753,	{ 0xE8, 0x8D, 0xA2 },
	0xC754,	{ 0xE8, 0x8D, 0xB0 },
	0xC755,	{ 0xE8, 0x8D, 0xB1 },
	0xC756,	{ 0xE8, 0x8D, 0xB2 },
	0xC757,	{ 0xE8, 0x8D, 0xB3 },
	0xC758,	{ 0xE8, 0x8D, 0xB4 },
	0xC759,	{ 0xE8, 0x8D, 0xB5 },
	0xC75A,	{ 0xE8, 0x8D, 0xB6 },
	0xC75B,	{ 0xE8, 0x8D, 0xB9 },
	0xC75C,	{ 0xE8, 0x8D, 0xBA },
	0xC75D,	{ 0xE8, 0x8D, 0xBE },
	0xC75E,	{ 0xE8, 0x8D, 0xBF },
	0xC75F,	{ 0xE8, 0x8E, 0x80 },
	0xC760,	{ 0xE8, 0x8E, 0x81 },
	0xC761,	{ 0xE8, 0x8E, 0x82 },
	0xC762,	{ 0xE8, 0x8E, 0x83 },
	0xC763,	{ 0xE8, 0x8E, 0x84 },
	0xC764,	{ 0xE8, 0x8E, 0x87 },
	0xC765,	{ 0xE8, 0x8E, 0x88 },
	0xC766,	{ 0xE8, 0x8E, 0x8A },
	0xC767,	{ 0xE8, 0x8E, 0x8B },
	0xC768,	{ 0xE8, 0x8E, 0x8C },
	0xC769,	{ 0xE8, 0x8E, 0x8D },
	0xC76A,	{ 0xE8, 0x8E, 0x8F },
	0xC76B,	{ 0xE8, 0x8E, 0x90 },
	0xC76C,	{ 0xE8, 0x8E, 0x91 },
	0xC76D,	{ 0xE8, 0x8E, 0x94 },
	0xC76E,	{ 0xE8, 0x8E, 0x95 },
	0xC76F,	{ 0xE8, 0x8E, 0x96 },
	0xC770,	{ 0xE8, 0x8E, 0x97 },
	0xC771,	{ 0xE8, 0x8E, 0x99 },
	0xC772,	{ 0xE8, 0x8E, 0x9A },
	0xC773,	{ 0xE8, 0x8E, 0x9D },
	0xC774,	{ 0xE8, 0x8E, 0x9F },
	0xC775,	{ 0xE8, 0x8E, 0xA1 },
	0xC776,	{ 0xE8, 0x8E, 0xA2 },
	0xC777,	{ 0xE8, 0x8E, 0xA3 },
	0xC778,	{ 0xE8, 0x8E, 0xA4 },
	0xC779,	{ 0xE8, 0x8E, 0xA5 },
	0xC77A,	{ 0xE8, 0x8E, 0xA6 },
	0xC77B,	{ 0xE8, 0x8E, 0xA7 },
	0xC77C,	{ 0xE8, 0x8E, 0xAC },
	0xC77D,	{ 0xE8, 0x8E, 0xAD },
	0xC77E,	{ 0xE8, 0x8E, 0xAE },
	0xC780,	{ 0xE8, 0x8E, 0xAF },
	0xC781,	{ 0xE8, 0x8E, 0xB5 },
	0xC782,	{ 0xE8, 0x8E, 0xBB },
	0xC783,	{ 0xE8, 0x8E, 0xBE },
	0xC784,	{ 0xE8, 0x8E, 0xBF },
	0xC785,	{ 0xE8, 0x8F, 0x82 },
	0xC786,	{ 0xE8, 0x8F, 0x83 },
	0xC787,	{ 0xE8, 0x8F, 0x84 },
	0xC788,	{ 0xE8, 0x8F, 0x86 },
	0xC789,	{ 0xE8, 0x8F, 0x88 },
	0xC78A,	{ 0xE8, 0x8F, 0x89 },
	0xC78B,	{ 0xE8, 0x8F, 0x8B },
	0xC78C,	{ 0xE8, 0x8F, 0x8D },
	0xC78D,	{ 0xE8, 0x8F, 0x8E },
	0xC78E,	{ 0xE8, 0x8F, 0x90 },
	0xC78F,	{ 0xE8, 0x8F, 0x91 },
	0xC790,	{ 0xE8, 0x8F, 0x92 },
	0xC791,	{ 0xE8, 0x8F, 0x93 },
	0xC792,	{ 0xE8, 0x8F, 0x95 },
	0xC793,	{ 0xE8, 0x8F, 0x97 },
	0xC794,	{ 0xE8, 0x8F, 0x99 },
	0xC795,	{ 0xE8, 0x8F, 0x9A },
	0xC796,	{ 0xE8, 0x8F, 0x9B },
	0xC797,	{ 0xE8, 0x8F, 0x9E },
	0xC798,	{ 0xE8, 0x8F, 0xA2 },
	0xC799,	{ 0xE8, 0x8F, 0xA3 },
	0xC79A,	{ 0xE8, 0x8F, 0xA4 },
	0xC79B,	{ 0xE8, 0x8F, 0xA6 },
	0xC79C,	{ 0xE8, 0x8F, 0xA7 },
	0xC79D,	{ 0xE8, 0x8F, 0xA8 },
	0xC79E,	{ 0xE8, 0x8F, 0xAB },
	0xC79F,	{ 0xE8, 0x8F, 0xAC },
	0xC7A0,	{ 0xE8, 0x8F, 0xAD },
	0xC7A1,	{ 0xE6, 0x81, 0xB0 },
	0xC7A2,	{ 0xE6, 0xB4, 0xBD },
	0xC7A3,	{ 0xE7, 0x89, 0xB5 },
	0xC7A4,	{ 0xE6, 0x89, 0xA6 },
	0xC7A5,	{ 0xE9, 0x92, 0x8E },
	0xC7A6,	{ 0xE9, 0x93, 0x85 },
	0xC7A7,	{ 0xE5, 0x8D, 0x83 },
	0xC7A8,	{ 0xE8, 0xBF, 0x81 },
	0xC7A9,	{ 0xE7, 0xAD, 0xBE },
	0xC7AA,	{ 0xE4, 0xBB, 0x9F },
	0xC7AB,	{ 0xE8, 0xB0, 0xA6 },
	0xC7AC,	{ 0xE4, 0xB9, 0xBE },
	0xC7AD,	{ 0xE9, 0xBB, 0x94 },
	0xC7AE,	{ 0xE9, 0x92, 0xB1 },
	0xC7AF,	{ 0xE9, 0x92, 0xB3 },
	0xC7B0,	{ 0xE5, 0x89, 0x8D },
	0xC7B1,	{ 0xE6, 0xBD, 0x9C },
	0xC7B2,	{ 0xE9, 0x81, 0xA3 },
	0xC7B3,	{ 0xE6, 0xB5, 0x85 },
	0xC7B4,	{ 0xE8, 0xB0, 0xB4 },
	0xC7B5,	{ 0xE5, 0xA0, 0x91 },
	0xC7B6,	{ 0xE5, 0xB5, 0x8C },
	0xC7B7,	{ 0xE6, 0xAC, 0xA0 },
	0xC7B8,	{ 0xE6, 0xAD, 0x89 },
	0xC7B9,	{ 0xE6, 0x9E, 0xAA },
	0xC7BA,	{ 0xE5, 0x91, 0x9B },
	0xC7BB,	{ 0xE8, 0x85, 0x94 },
	0xC7BC,	{ 0xE7, 0xBE, 0x8C },
	0xC7BD,	{ 0xE5, 0xA2, 0x99 },
	0xC7BE,	{ 0xE8, 0x94, 0xB7 },
	0xC7BF,	{ 0xE5, 0xBC, 0xBA },
	0xC7C0,	{ 0xE6, 0x8A, 0xA2 },
	0xC7C1,	{ 0xE6, 0xA9, 0x87 },
	0xC7C2,	{ 0xE9, 0x94, 0xB9 },
	0xC7C3,	{ 0xE6, 0x95, 0xB2 },
	0xC7C4,	{ 0xE6, 0x82, 0x84 },
	0xC7C5,	{ 0xE6, 0xA1, 0xA5 },
	0xC7C6,	{ 0xE7, 0x9E, 0xA7 },
	0xC7C7,	{ 0xE4, 0xB9, 0x94 },
	0xC7C8,	{ 0xE4, 0xBE, 0xA8 },
	0xC7C9,	{ 0xE5, 0xB7, 0xA7 },
	0xC7CA,	{ 0xE9, 0x9E, 0x98 },
	0xC7CB,	{ 0xE6, 0x92, 0xAC },
	0xC7CC,	{ 0xE7, 0xBF, 0x98 },
	0xC7CD,	{ 0xE5, 0xB3, 0xAD },
	0xC7CE,	{ 0xE4, 0xBF, 0x8F },
	0xC7CF,	{ 0xE7, 0xAA, 0x8D },
	0xC7D0,	{ 0xE5, 0x88, 0x87 },
	0xC7D1,	{ 0xE8, 0x8C, 0x84 },
	0xC7D2,	{ 0xE4, 0xB8, 0x94 },
	0xC7D3,	{ 0xE6, 0x80, 0xAF },
	0xC7D4,	{ 0xE7, 0xAA, 0x83 },
	0xC7D5,	{ 0xE9, 0x92, 0xA6 },
	0xC7D6,	{ 0xE4, 0xBE, 0xB5 },
	0xC7D7,	{ 0xE4, 0xBA, 0xB2 },
	0xC7D8,	{ 0xE7, 0xA7, 0xA6 },
	0xC7D9,	{ 0xE7, 0x90, 0xB4 },
	0xC7DA,	{ 0xE5, 0x8B, 0xA4 },
	0xC7DB,	{ 0xE8, 0x8A, 0xB9 },
	0xC7DC,	{ 0xE6, 0x93, 0x92 },
	0xC7DD,	{ 0xE7, 0xA6, 0xBD },
	0xC7DE,	{ 0xE5, 0xAF, 0x9D },
	0xC7DF,	{ 0xE6, 0xB2, 0x81 },
	0xC7E0,	{ 0xE9, 0x9D, 0x92 },
	0xC7E1,	{ 0xE8, 0xBD, 0xBB },
	0xC7E2,	{ 0xE6, 0xB0, 0xA2 },
	0xC7E3,	{ 0xE5, 0x80, 0xBE },
	0xC7E4,	{ 0xE5, 0x8D, 0xBF },
	0xC7E5,	{ 0xE6, 0xB8, 0x85 },
	0xC7E6,	{ 0xE6, 0x93, 0x8E },
	0xC7E7,	{ 0xE6, 0x99, 0xB4 },
	0xC7E8,	{ 0xE6, 0xB0, 0xB0 },
	0xC7E9,	{ 0xE6, 0x83, 0x85 },
	0xC7EA,	{ 0xE9, 0xA1, 0xB7 },
	0xC7EB,	{ 0xE8, 0xAF, 0xB7 },
	0xC7EC,	{ 0xE5, 0xBA, 0x86 },
	0xC7ED,	{ 0xE7, 0x90, 0xBC },
	0xC7EE,	{ 0xE7, 0xA9, 0xB7 },
	0xC7EF,	{ 0xE7, 0xA7, 0x8B },
	0xC7F0,	{ 0xE4, 0xB8, 0x98 },
	0xC7F1,	{ 0xE9, 0x82, 0xB1 },
	0xC7F2,	{ 0xE7, 0x90, 0x83 },
	0xC7F3,	{ 0xE6, 0xB1, 0x82 },
	0xC7F4,	{ 0xE5, 0x9B, 0x9A },
	0xC7F5,	{ 0xE9, 0x85, 0x8B },
	0xC7F6,	{ 0xE6, 0xB3, 0x85 },
	0xC7F7,	{ 0xE8, 0xB6, 0x8B },
	0xC7F8,	{ 0xE5, 0x8C, 0xBA },
	0xC7F9,	{ 0xE8, 0x9B, 0x86 },
	0xC7FA,	{ 0xE6, 0x9B, 0xB2 },
	0xC7FB,	{ 0xE8, 0xBA, 0xAF },
	0xC7FC,	{ 0xE5, 0xB1, 0x88 },
	0xC7FD,	{ 0xE9, 0xA9, 0xB1 },
	0xC7FE,	{ 0xE6, 0xB8, 0xA0 },
	0xC840,	{ 0xE8, 0x8F, 0xAE },
	0xC841,	{ 0xE8, 0x8F, 0xAF },
	0xC842,	{ 0xE8, 0x8F, 0xB3 },
	0xC843,	{ 0xE8, 0x8F, 0xB4 },
	0xC844,	{ 0xE8, 0x8F, 0xB5 },
	0xC845,	{ 0xE8, 0x8F, 0xB6 },
	0xC846,	{ 0xE8, 0x8F, 0xB7 },
	0xC847,	{ 0xE8, 0x8F, 0xBA },
	0xC848,	{ 0xE8, 0x8F, 0xBB },
	0xC849,	{ 0xE8, 0x8F, 0xBC },
	0xC84A,	{ 0xE8, 0x8F, 0xBE },
	0xC84B,	{ 0xE8, 0x8F, 0xBF },
	0xC84C,	{ 0xE8, 0x90, 0x80 },
	0xC84D,	{ 0xE8, 0x90, 0x82 },
	0xC84E,	{ 0xE8, 0x90, 0x85 },
	0xC84F,	{ 0xE8, 0x90, 0x87 },
	0xC850,	{ 0xE8, 0x90, 0x88 },
	0xC851,	{ 0xE8, 0x90, 0x89 },
	0xC852,	{ 0xE8, 0x90, 0x8A },
	0xC853,	{ 0xE8, 0x90, 0x90 },
	0xC854,	{ 0xE8, 0x90, 0x92 },
	0xC855,	{ 0xE8, 0x90, 0x93 },
	0xC856,	{ 0xE8, 0x90, 0x94 },
	0xC857,	{ 0xE8, 0x90, 0x95 },
	0xC858,	{ 0xE8, 0x90, 0x96 },
	0xC859,	{ 0xE8, 0x90, 0x97 },
	0xC85A,	{ 0xE8, 0x90, 0x99 },
	0xC85B,	{ 0xE8, 0x90, 0x9A },
	0xC85C,	{ 0xE8, 0x90, 0x9B },
	0xC85D,	{ 0xE8, 0x90, 0x9E },
	0xC85E,	{ 0xE8, 0x90, 0x9F },
	0xC85F,	{ 0xE8, 0x90, 0xA0 },
	0xC860,	{ 0xE8, 0x90, 0xA1 },
	0xC861,	{ 0xE8, 0x90, 0xA2 },
	0xC862,	{ 0xE8, 0x90, 0xA3 },
	0xC863,	{ 0xE8, 0x90, 0xA9 },
	0xC864,	{ 0xE8, 0x90, 0xAA },
	0xC865,	{ 0xE8, 0x90, 0xAB },
	0xC866,	{ 0xE8, 0x90, 0xAC },
	0xC867,	{ 0xE8, 0x90, 0xAD },
	0xC868,	{ 0xE8, 0x90, 0xAE },
	0xC869,	{ 0xE8, 0x90, 0xAF },
	0xC86A,	{ 0xE8, 0x90, 0xB0 },
	0xC86B,	{ 0xE8, 0x90, 0xB2 },
	0xC86C,	{ 0xE8, 0x90, 0xB3 },
	0xC86D,	{ 0xE8, 0x90, 0xB4 },
	0xC86E,	{ 0xE8, 0x90, 0xB5 },
	0xC86F,	{ 0xE8, 0x90, 0xB6 },
	0xC870,	{ 0xE8, 0x90, 0xB7 },
	0xC871,	{ 0xE8, 0x90, 0xB9 },
	0xC872,	{ 0xE8, 0x90, 0xBA },
	0xC873,	{ 0xE8, 0x90, 0xBB },
	0xC874,	{ 0xE8, 0x90, 0xBE },
	0xC875,	{ 0xE8, 0x90, 0xBF },
	0xC876,	{ 0xE8, 0x91, 0x80 },
	0xC877,	{ 0xE8, 0x91, 0x81 },
	0xC878,	{ 0xE8, 0x91, 0x82 },
	0xC879,	{ 0xE8, 0x91, 0x83 },
	0xC87A,	{ 0xE8, 0x91, 0x84 },
	0xC87B,	{ 0xE8, 0x91, 0x85 },
	0xC87C,	{ 0xE8, 0x91, 0x87 },
	0xC87D,	{ 0xE8, 0x91, 0x88 },
	0xC87E,	{ 0xE8, 0x91, 0x89 },
	0xC880,	{ 0xE8, 0x91, 0x8A },
	0xC881,	{ 0xE8, 0x91, 0x8B },
	0xC882,	{ 0xE8, 0x91, 0x8C },
	0xC883,	{ 0xE8, 0x91, 0x8D },
	0xC884,	{ 0xE8, 0x91, 0x8E },
	0xC885,	{ 0xE8, 0x91, 0x8F },
	0xC886,	{ 0xE8, 0x91, 0x90 },
	0xC887,	{ 0xE8, 0x91, 0x92 },
	0xC888,	{ 0xE8, 0x91, 0x93 },
	0xC889,	{ 0xE8, 0x91, 0x94 },
	0xC88A,	{ 0xE8, 0x91, 0x95 },
	0xC88B,	{ 0xE8, 0x91, 0x96 },
	0xC88C,	{ 0xE8, 0x91, 0x98 },
	0xC88D,	{ 0xE8, 0x91, 0x9D },
	0xC88E,	{ 0xE8, 0x91, 0x9E },
	0xC88F,	{ 0xE8, 0x91, 0x9F },
	0xC890,	{ 0xE8, 0x91, 0xA0 },
	0xC891,	{ 0xE8, 0x91, 0xA2 },
	0xC892,	{ 0xE8, 0x91, 0xA4 },
	0xC893,	{ 0xE8, 0x91, 0xA5 },
	0xC894,	{ 0xE8, 0x91, 0xA6 },
	0xC895,	{ 0xE8, 0x91, 0xA7 },
	0xC896,	{ 0xE8, 0x91, 0xA8 },
	0xC897,	{ 0xE8, 0x91, 0xAA },
	0xC898,	{ 0xE8, 0x91, 0xAE },
	0xC899,	{ 0xE8, 0x91, 0xAF },
	0xC89A,	{ 0xE8, 0x91, 0xB0 },
	0xC89B,	{ 0xE8, 0x91, 0xB2 },
	0xC89C,	{ 0xE8, 0x91, 0xB4 },
	0xC89D,	{ 0xE8, 0x91, 0xB7 },
	0xC89E,	{ 0xE8, 0x91, 0xB9 },
	0xC89F,	{ 0xE8, 0x91, 0xBB },
	0xC8A0,	{ 0xE8, 0x91, 0xBC },
	0xC8A1,	{ 0xE5, 0x8F, 0x96 },
	0xC8A2,	{ 0xE5, 0xA8, 0xB6 },
	0xC8A3,	{ 0xE9, 0xBE, 0x8B },
	0xC8A4,	{ 0xE8, 0xB6, 0xA3 },
	0xC8A5,	{ 0xE5, 0x8E, 0xBB },
	0xC8A6,	{ 0xE5, 0x9C, 0x88 },
	0xC8A7,	{ 0xE9, 0xA2, 0xA7 },
	0xC8A8,	{ 0xE6, 0x9D, 0x83 },
	0xC8A9,	{ 0xE9, 0x86, 0x9B },
	0xC8AA,	{ 0xE6, 0xB3, 0x89 },
	0xC8AB,	{ 0xE5, 0x85, 0xA8 },
	0xC8AC,	{ 0xE7, 0x97, 0x8A },
	0xC8AD,	{ 0xE6, 0x8B, 0xB3 },
	0xC8AE,	{ 0xE7, 0x8A, 0xAC },
	0xC8AF,	{ 0xE5, 0x88, 0xB8 },
	0xC8B0,	{ 0xE5, 0x8A, 0x9D },
	0xC8B1,	{ 0xE7, 0xBC, 0xBA },
	0xC8B2,	{ 0xE7, 0x82, 0x94 },
	0xC8B3,	{ 0xE7, 0x98, 0xB8 },
	0xC8B4,	{ 0xE5, 0x8D, 0xB4 },
	0xC8B5,	{ 0xE9, 0xB9, 0x8A },
	0xC8B6,	{ 0xE6, 0xA6, 0xB7 },
	0xC8B7,	{ 0xE7, 0xA1, 0xAE },
	0xC8B8,	{ 0xE9, 0x9B, 0x80 },
	0xC8B9,	{ 0xE8, 0xA3, 0x99 },
	0xC8BA,	{ 0xE7, 0xBE, 0xA4 },
	0xC8BB,	{ 0xE7, 0x84, 0xB6 },
	0xC8BC,	{ 0xE7, 0x87, 0x83 },
	0xC8BD,	{ 0xE5, 0x86, 0x89 },
	0xC8BE,	{ 0xE6, 0x9F, 0x93 },
	0xC8BF,	{ 0xE7, 0x93, 0xA4 },
	0xC8C0,	{ 0xE5, 0xA3, 0xA4 },
	0xC8C1,	{ 0xE6, 0x94, 0x98 },
	0xC8C2,	{ 0xE5, 0x9A, 0xB7 },
	0xC8C3,	{ 0xE8, 0xAE, 0xA9 },
	0xC8C4,	{ 0xE9, 0xA5, 0xB6 },
	0xC8C5,	{ 0xE6, 0x89, 0xB0 },
	0xC8C6,	{ 0xE7, 0xBB, 0x95 },
	0xC8C7,	{ 0xE6, 0x83, 0xB9 },
	0xC8C8,	{ 0xE7, 0x83, 0xAD },
	0xC8C9,	{ 0xE5, 0xA3, 0xAC },
	0xC8CA,	{ 0xE4, 0xBB, 0x81 },
	0xC8CB,	{ 0xE4, 0xBA, 0xBA },
	0xC8CC,	{ 0xE5, 0xBF, 0x8D },
	0xC8CD,	{ 0xE9, 0x9F, 0xA7 },
	0xC8CE,	{ 0xE4, 0xBB, 0xBB },
	0xC8CF,	{ 0xE8, 0xAE, 0xA4 },
	0xC8D0,	{ 0xE5, 0x88, 0x83 },
	0xC8D1,	{ 0xE5, 0xA6, 0x8A },
	0xC8D2,	{ 0xE7, 0xBA, 0xAB },
	0xC8D3,	{ 0xE6, 0x89, 0x94 },
	0xC8D4,	{ 0xE4, 0xBB, 0x8D },
	0xC8D5,	{ 0xE6, 0x97, 0xA5 },
	0xC8D6,	{ 0xE6, 0x88, 0x8E },
	0xC8D7,	{ 0xE8, 0x8C, 0xB8 },
	0xC8D8,	{ 0xE8, 0x93, 0x89 },
	0xC8D9,	{ 0xE8, 0x8D, 0xA3 },
	0xC8DA,	{ 0xE8, 0x9E, 0x8D },
	0xC8DB,	{ 0xE7, 0x86, 0x94 },
	0xC8DC,	{ 0xE6, 0xBA, 0xB6 },
	0xC8DD,	{ 0xE5, 0xAE, 0xB9 },
	0xC8DE,	{ 0xE7, 0xBB, 0x92 },
	0xC8DF,	{ 0xE5, 0x86, 0x97 },
	0xC8E0,	{ 0xE6, 0x8F, 0x89 },
	0xC8E1,	{ 0xE6, 0x9F, 0x94 },
	0xC8E2,	{ 0xE8, 0x82, 0x89 },
	0xC8E3,	{ 0xE8, 0x8C, 0xB9 },
	0xC8E4,	{ 0xE8, 0xA0, 0x95 },
	0xC8E5,	{ 0xE5, 0x84, 0x92 },
	0xC8E6,	{ 0xE5, 0xAD, 0xBA },
	0xC8E7,	{ 0xE5, 0xA6, 0x82 },
	0xC8E8,	{ 0xE8, 0xBE, 0xB1 },
	0xC8E9,	{ 0xE4, 0xB9, 0xB3 },
	0xC8EA,	{ 0xE6, 0xB1, 0x9D },
	0xC8EB,	{ 0xE5, 0x85, 0xA5 },
	0xC8EC,	{ 0xE8, 0xA4, 0xA5 },
	0xC8ED,	{ 0xE8, 0xBD, 0xAF },
	0xC8EE,	{ 0xE9, 0x98, 0xAE },
	0xC8EF,	{ 0xE8, 0x95, 0x8A },
	0xC8F0,	{ 0xE7, 0x91, 0x9E },
	0xC8F1,	{ 0xE9, 0x94, 0x90 },
	0xC8F2,	{ 0xE9, 0x97, 0xB0 },
	0xC8F3,	{ 0xE6, 0xB6, 0xA6 },
	0xC8F4,	{ 0xE8, 0x8B, 0xA5 },
	0xC8F5,	{ 0xE5, 0xBC, 0xB1 },
	0xC8F6,	{ 0xE6, 0x92, 0x92 },
	0xC8F7,	{ 0xE6, 0xB4, 0x92 },
	0xC8F8,	{ 0xE8, 0x90, 0xA8 },
	0xC8F9,	{ 0xE8, 0x85, 0xAE },
	0xC8FA,	{ 0xE9, 0xB3, 0x83 },
	0xC8FB,	{ 0xE5, 0xA1, 0x9E },
	0xC8FC,	{ 0xE8, 0xB5, 0x9B },
	0xC8FD,	{ 0xE4, 0xB8, 0x89 },
	0xC8FE,	{ 0xE5, 0x8F, 0x81 },
	0xC940,	{ 0xE8, 0x91, 0xBD },
	0xC941,	{ 0xE8, 0x91, 0xBE },
	0xC942,	{ 0xE8, 0x91, 0xBF },
	0xC943,	{ 0xE8, 0x92, 0x80 },
	0xC944,	{ 0xE8, 0x92, 0x81 },
	0xC945,	{ 0xE8, 0x92, 0x83 },
	0xC946,	{ 0xE8, 0x92, 0x84 },
	0xC947,	{ 0xE8, 0x92, 0x85 },
	0xC948,	{ 0xE8, 0x92, 0x86 },
	0xC949,	{ 0xE8, 0x92, 0x8A },
	0xC94A,	{ 0xE8, 0x92, 0x8D },
	0xC94B,	{ 0xE8, 0x92, 0x8F },
	0xC94C,	{ 0xE8, 0x92, 0x90 },
	0xC94D,	{ 0xE8, 0x92, 0x91 },
	0xC94E,	{ 0xE8, 0x92, 0x92 },
	0xC94F,	{ 0xE8, 0x92, 0x93 },
	0xC950,	{ 0xE8, 0x92, 0x94 },
	0xC951,	{ 0xE8, 0x92, 0x95 },
	0xC952,	{ 0xE8, 0x92, 0x96 },
	0xC953,	{ 0xE8, 0x92, 0x98 },
	0xC954,	{ 0xE8, 0x92, 0x9A },
	0xC955,	{ 0xE8, 0x92, 0x9B },
	0xC956,	{ 0xE8, 0x92, 0x9D },
	0xC957,	{ 0xE8, 0x92, 0x9E },
	0xC958,	{ 0xE8, 0x92, 0x9F },
	0xC959,	{ 0xE8, 0x92, 0xA0 },
	0xC95A,	{ 0xE8, 0x92, 0xA2 },
	0xC95B,	{ 0xE8, 0x92, 0xA3 },
	0xC95C,	{ 0xE8, 0x92, 0xA4 },
	0xC95D,	{ 0xE8, 0x92, 0xA5 },
	0xC95E,	{ 0xE8, 0x92, 0xA6 },
	0xC95F,	{ 0xE8, 0x92, 0xA7 },
	0xC960,	{ 0xE8, 0x92, 0xA8 },
	0xC961,	{ 0xE8, 0x92, 0xA9 },
	0xC962,	{ 0xE8, 0x92, 0xAA },
	0xC963,	{ 0xE8, 0x92, 0xAB },
	0xC964,	{ 0xE8, 0x92, 0xAC },
	0xC965,	{ 0xE8, 0x92, 0xAD },
	0xC966,	{ 0xE8, 0x92, 0xAE },
	0xC967,	{ 0xE8, 0x92, 0xB0 },
	0xC968,	{ 0xE8, 0x92, 0xB1 },
	0xC969,	{ 0xE8, 0x92, 0xB3 },
	0xC96A,	{ 0xE8, 0x92, 0xB5 },
	0xC96B,	{ 0xE8, 0x92, 0xB6 },
	0xC96C,	{ 0xE8, 0x92, 0xB7 },
	0xC96D,	{ 0xE8, 0x92, 0xBB },
	0xC96E,	{ 0xE8, 0x92, 0xBC },
	0xC96F,	{ 0xE8, 0x92, 0xBE },
	0xC970,	{ 0xE8, 0x93, 0x80 },
	0xC971,	{ 0xE8, 0x93, 0x82 },
	0xC972,	{ 0xE8, 0x93, 0x83 },
	0xC973,	{ 0xE8, 0x93, 0x85 },
	0xC974,	{ 0xE8, 0x93, 0x86 },
	0xC975,	{ 0xE8, 0x93, 0x87 },
	0xC976,	{ 0xE8, 0x93, 0x88 },
	0xC977,	{ 0xE8, 0x93, 0x8B },
	0xC978,	{ 0xE8, 0x93, 0x8C },
	0xC979,	{ 0xE8, 0x93, 0x8E },
	0xC97A,	{ 0xE8, 0x93, 0x8F },
	0xC97B,	{ 0xE8, 0x93, 0x92 },
	0xC97C,	{ 0xE8, 0x93, 0x94 },
	0xC97D,	{ 0xE8, 0x93, 0x95 },
	0xC97E,	{ 0xE8, 0x93, 0x97 },
	0xC980,	{ 0xE8, 0x93, 0x98 },
	0xC981,	{ 0xE8, 0x93, 0x99 },
	0xC982,	{ 0xE8, 0x93, 0x9A },
	0xC983,	{ 0xE8, 0x93, 0x9B },
	0xC984,	{ 0xE8, 0x93, 0x9C },
	0xC985,	{ 0xE8, 0x93, 0x9E },
	0xC986,	{ 0xE8, 0x93, 0xA1 },
	0xC987,	{ 0xE8, 0x93, 0xA2 },
	0xC988,	{ 0xE8, 0x93, 0xA4 },
	0xC989,	{ 0xE8, 0x93, 0xA7 },
	0xC98A,	{ 0xE8, 0x93, 0xA8 },
	0xC98B,	{ 0xE8, 0x93, 0xA9 },
	0xC98C,	{ 0xE8, 0x93, 0xAA },
	0xC98D,	{ 0xE8, 0x93, 0xAB },
	0xC98E,	{ 0xE8, 0x93, 0xAD },
	0xC98F,	{ 0xE8, 0x93, 0xAE },
	0xC990,	{ 0xE8, 0x93, 0xAF },
	0xC991,	{ 0xE8, 0x93, 0xB1 },
	0xC992,	{ 0xE8, 0x93, 0xB2 },
	0xC993,	{ 0xE8, 0x93, 0xB3 },
	0xC994,	{ 0xE8, 0x93, 0xB4 },
	0xC995,	{ 0xE8, 0x93, 0xB5 },
	0xC996,	{ 0xE8, 0x93, 0xB6 },
	0xC997,	{ 0xE8, 0x93, 0xB7 },
	0xC998,	{ 0xE8, 0x93, 0xB8 },
	0xC999,	{ 0xE8, 0x93, 0xB9 },
	0xC99A,	{ 0xE8, 0x93, 0xBA },
	0xC99B,	{ 0xE8, 0x93, 0xBB },
	0xC99C,	{ 0xE8, 0x93, 0xBD },
	0xC99D,	{ 0xE8, 0x93, 0xBE },
	0xC99E,	{ 0xE8, 0x94, 0x80 },
	0xC99F,	{ 0xE8, 0x94, 0x81 },
	0xC9A0,	{ 0xE8, 0x94, 0x82 },
	0xC9A1,	{ 0xE4, 0xBC, 0x9E },
	0xC9A2,	{ 0xE6, 0x95, 0xA3 },
	0xC9A3,	{ 0xE6, 0xA1, 0x91 },
	0xC9A4,	{ 0xE5, 0x97, 0x93 },
	0xC9A5,	{ 0xE4, 0xB8, 0xA7 },
	0xC9A6,	{ 0xE6, 0x90, 0x94 },
	0xC9A7,	{ 0xE9, 0xAA, 0x9A },
	0xC9A8,	{ 0xE6, 0x89, 0xAB },
	0xC9A9,	{ 0xE5, 0xAB, 0x82 },
	0xC9AA,	{ 0xE7, 0x91, 0x9F },
	0xC9AB,	{ 0xE8, 0x89, 0xB2 },
	0xC9AC,	{ 0xE6, 0xB6, 0xA9 },
	0xC9AD,	{ 0xE6, 0xA3, 0xAE },
	0xC9AE,	{ 0xE5, 0x83, 0xA7 },
	0xC9AF,	{ 0xE8, 0x8E, 0x8E },
	0xC9B0,	{ 0xE7, 0xA0, 0x82 },
	0xC9B1,	{ 0xE6, 0x9D, 0x80 },
	0xC9B2,	{ 0xE5, 0x88, 0xB9 },
	0xC9B3,	{ 0xE6, 0xB2, 0x99 },
	0xC9B4,	{ 0xE7, 0xBA, 0xB1 },
	0xC9B5,	{ 0xE5, 0x82, 0xBB },
	0xC9B6,	{ 0xE5, 0x95, 0xA5 },
	0xC9B7,	{ 0xE7, 0x85, 0x9E },
	0xC9B8,	{ 0xE7, 0xAD, 0x9B },
	0xC9B9,	{ 0xE6, 0x99, 0x92 },
	0xC9BA,	{ 0xE7, 0x8F, 0x8A },
	0xC9BB,	{ 0xE8, 0x8B, 0xAB },
	0xC9BC,	{ 0xE6, 0x9D, 0x89 },
	0xC9BD,	{ 0xE5, 0xB1, 0xB1 },
	0xC9BE,	{ 0xE5, 0x88, 0xA0 },
	0xC9BF,	{ 0xE7, 0x85, 0xBD },
	0xC9C0,	{ 0xE8, 0xA1, 0xAB },
	0xC9C1,	{ 0xE9, 0x97, 0xAA },
	0xC9C2,	{ 0xE9, 0x99, 0x95 },
	0xC9C3,	{ 0xE6, 0x93, 0x85 },
	0xC9C4,	{ 0xE8, 0xB5, 0xA1 },
	0xC9C5,	{ 0xE8, 0x86, 0xB3 },
	0xC9C6,	{ 0xE5, 0x96, 0x84 },
	0xC9C7,	{ 0xE6, 0xB1, 0x95 },
	0xC9C8,	{ 0xE6, 0x89, 0x87 },
	0xC9C9,	{ 0xE7, 0xBC, 0xAE },
	0xC9CA,	{ 0xE5, 0xA2, 0x92 },
	0xC9CB,	{ 0xE4, 0xBC, 0xA4 },
	0xC9CC,	{ 0xE5, 0x95, 0x86 },
	0xC9CD,	{ 0xE8, 0xB5, 0x8F },
	0xC9CE,	{ 0xE6, 0x99, 0x8C },
	0xC9CF,	{ 0xE4, 0xB8, 0x8A },
	0xC9D0,	{ 0xE5, 0xB0, 0x9A },
	0xC9D1,	{ 0xE8, 0xA3, 0xB3 },
	0xC9D2,	{ 0xE6, 0xA2, 0xA2 },
	0xC9D3,	{ 0xE6, 0x8D, 0x8E },
	0xC9D4,	{ 0xE7, 0xA8, 0x8D },
	0xC9D5,	{ 0xE7, 0x83, 0xA7 },
	0xC9D6,	{ 0xE8, 0x8A, 0x8D },
	0xC9D7,	{ 0xE5, 0x8B, 0xBA },
	0xC9D8,	{ 0xE9, 0x9F, 0xB6 },
	0xC9D9,	{ 0xE5, 0xB0, 0x91 },
	0xC9DA,	{ 0xE5, 0x93, 0xA8 },
	0xC9DB,	{ 0xE9, 0x82, 0xB5 },
	0xC9DC,	{ 0xE7, 0xBB, 0x8D },
	0xC9DD,	{ 0xE5, 0xA5, 0xA2 },
	0xC9DE,	{ 0xE8, 0xB5, 0x8A },
	0xC9DF,	{ 0xE8, 0x9B, 0x87 },
	0xC9E0,	{ 0xE8, 0x88, 0x8C },
	0xC9E1,	{ 0xE8, 0x88, 0x8D },
	0xC9E2,	{ 0xE8, 0xB5, 0xA6 },
	0xC9E3,	{ 0xE6, 0x91, 0x84 },
	0xC9E4,	{ 0xE5, 0xB0, 0x84 },
	0xC9E5,	{ 0xE6, 0x85, 0x91 },
	0xC9E6,	{ 0xE6, 0xB6, 0x89 },
	0xC9E7,	{ 0xE7, 0xA4, 0xBE },
	0xC9E8,	{ 0xE8, 0xAE, 0xBE },
	0xC9E9,	{ 0xE7, 0xA0, 0xB7 },
	0xC9EA,	{ 0xE7, 0x94, 0xB3 },
	0xC9EB,	{ 0xE5, 0x91, 0xBB },
	0xC9EC,	{ 0xE4, 0xBC, 0xB8 },
	0xC9ED,	{ 0xE8, 0xBA, 0xAB },
	0xC9EE,	{ 0xE6, 0xB7, 0xB1 },
	0xC9EF,	{ 0xE5, 0xA8, 0xA0 },
	0xC9F0,	{ 0xE7, 0xBB, 0x85 },
	0xC9F1,	{ 0xE7, 0xA5, 0x9E },
	0xC9F2,	{ 0xE6, 0xB2, 0x88 },
	0xC9F3,	{ 0xE5, 0xAE, 0xA1 },
	0xC9F4,	{ 0xE5, 0xA9, 0xB6 },
	0xC9F5,	{ 0xE7, 0x94, 0x9A },
	0xC9F6,	{ 0xE8, 0x82, 0xBE },
	0xC9F7,	{ 0xE6, 0x85, 0x8E },
	0xC9F8,	{ 0xE6, 0xB8, 0x97 },
	0xC9F9,	{ 0xE5, 0xA3, 0xB0 },
	0xC9FA,	{ 0xE7, 0x94, 0x9F },
	0xC9FB,	{ 0xE7, 0x94, 0xA5 },
	0xC9FC,	{ 0xE7, 0x89, 0xB2 },
	0xC9FD,	{ 0xE5, 0x8D, 0x87 },
	0xC9FE,	{ 0xE7, 0xBB, 0xB3 },
	0xCA40,	{ 0xE8, 0x94, 0x83 },
	0xCA41,	{ 0xE8, 0x94, 0x84 },
	0xCA42,	{ 0xE8, 0x94, 0x85 },
	0xCA43,	{ 0xE8, 0x94, 0x86 },
	0xCA44,	{ 0xE8, 0x94, 0x87 },
	0xCA45,	{ 0xE8, 0x94, 0x88 },
	0xCA46,	{ 0xE8, 0x94, 0x89 },
	0xCA47,	{ 0xE8, 0x94, 0x8A },
	0xCA48,	{ 0xE8, 0x94, 0x8B },
	0xCA49,	{ 0xE8, 0x94, 0x8D },
	0xCA4A,	{ 0xE8, 0x94, 0x8E },
	0xCA4B,	{ 0xE8, 0x94, 0x8F },
	0xCA4C,	{ 0xE8, 0x94, 0x90 },
	0xCA4D,	{ 0xE8, 0x94, 0x92 },
	0xCA4E,	{ 0xE8, 0x94, 0x94 },
	0xCA4F,	{ 0xE8, 0x94, 0x95 },
	0xCA50,	{ 0xE8, 0x94, 0x96 },
	0xCA51,	{ 0xE8, 0x94, 0x98 },
	0xCA52,	{ 0xE8, 0x94, 0x99 },
	0xCA53,	{ 0xE8, 0x94, 0x9B },
	0xCA54,	{ 0xE8, 0x94, 0x9C },
	0xCA55,	{ 0xE8, 0x94, 0x9D },
	0xCA56,	{ 0xE8, 0x94, 0x9E },
	0xCA57,	{ 0xE8, 0x94, 0xA0 },
	0xCA58,	{ 0xE8, 0x94, 0xA2 },
	0xCA59,	{ 0xE8, 0x94, 0xA3 },
	0xCA5A,	{ 0xE8, 0x94, 0xA4 },
	0xCA5B,	{ 0xE8, 0x94, 0xA5 },
	0xCA5C,	{ 0xE8, 0x94, 0xA6 },
	0xCA5D,	{ 0xE8, 0x94, 0xA7 },
	0xCA5E,	{ 0xE8, 0x94, 0xA8 },
	0xCA5F,	{ 0xE8, 0x94, 0xA9 },
	0xCA60,	{ 0xE8, 0x94, 0xAA },
	0xCA61,	{ 0xE8, 0x94, 0xAD },
	0xCA62,	{ 0xE8, 0x94, 0xAE },
	0xCA63,	{ 0xE8, 0x94, 0xAF },
	0xCA64,	{ 0xE8, 0x94, 0xB0 },
	0xCA65,	{ 0xE8, 0x94, 0xB1 },
	0xCA66,	{ 0xE8, 0x94, 0xB2 },
	0xCA67,	{ 0xE8, 0x94, 0xB3 },
	0xCA68,	{ 0xE8, 0x94, 0xB4 },
	0xCA69,	{ 0xE8, 0x94, 0xB5 },
	0xCA6A,	{ 0xE8, 0x94, 0xB6 },
	0xCA6B,	{ 0xE8, 0x94, 0xBE },
	0xCA6C,	{ 0xE8, 0x94, 0xBF },
	0xCA6D,	{ 0xE8, 0x95, 0x80 },
	0xCA6E,	{ 0xE8, 0x95, 0x81 },
	0xCA6F,	{ 0xE8, 0x95, 0x82 },
	0xCA70,	{ 0xE8, 0x95, 0x84 },
	0xCA71,	{ 0xE8, 0x95, 0x85 },
	0xCA72,	{ 0xE8, 0x95, 0x86 },
	0xCA73,	{ 0xE8, 0x95, 0x87 },
	0xCA74,	{ 0xE8, 0x95, 0x8B },
	0xCA75,	{ 0xE8, 0x95, 0x8C },
	0xCA76,	{ 0xE8, 0x95, 0x8D },
	0xCA77,	{ 0xE8, 0x95, 0x8E },
	0xCA78,	{ 0xE8, 0x95, 0x8F },
	0xCA79,	{ 0xE8, 0x95, 0x90 },
	0xCA7A,	{ 0xE8, 0x95, 0x91 },
	0xCA7B,	{ 0xE8, 0x95, 0x92 },
	0xCA7C,	{ 0xE8, 0x95, 0x93 },
	0xCA7D,	{ 0xE8, 0x95, 0x94 },
	0xCA7E,	{ 0xE8, 0x95, 0x95 },
	0xCA80,	{ 0xE8, 0x95, 0x97 },
	0xCA81,	{ 0xE8, 0x95, 0x98 },
	0xCA82,	{ 0xE8, 0x95, 0x9A },
	0xCA83,	{ 0xE8, 0x95, 0x9B },
	0xCA84,	{ 0xE8, 0x95, 0x9C },
	0xCA85,	{ 0xE8, 0x95, 0x9D },
	0xCA86,	{ 0xE8, 0x95, 0x9F },
	0xCA87,	{ 0xE8, 0x95, 0xA0 },
	0xCA88,	{ 0xE8, 0x95, 0xA1 },
	0xCA89,	{ 0xE8, 0x95, 0xA2 },
	0xCA8A,	{ 0xE8, 0x95, 0xA3 },
	0xCA8B,	{ 0xE8, 0x95, 0xA5 },
	0xCA8C,	{ 0xE8, 0x95, 0xA6 },
	0xCA8D,	{ 0xE8, 0x95, 0xA7 },
	0xCA8E,	{ 0xE8, 0x95, 0xA9 },
	0xCA8F,	{ 0xE8, 0x95, 0xAA },
	0xCA90,	{ 0xE8, 0x95, 0xAB },
	0xCA91,	{ 0xE8, 0x95, 0xAC },
	0xCA92,	{ 0xE8, 0x95, 0xAD },
	0xCA93,	{ 0xE8, 0x95, 0xAE },
	0xCA94,	{ 0xE8, 0x95, 0xAF },
	0xCA95,	{ 0xE8, 0x95, 0xB0 },
	0xCA96,	{ 0xE8, 0x95, 0xB1 },
	0xCA97,	{ 0xE8, 0x95, 0xB3 },
	0xCA98,	{ 0xE8, 0x95, 0xB5 },
	0xCA99,	{ 0xE8, 0x95, 0xB6 },
	0xCA9A,	{ 0xE8, 0x95, 0xB7 },
	0xCA9B,	{ 0xE8, 0x95, 0xB8 },
	0xCA9C,	{ 0xE8, 0x95, 0xBC },
	0xCA9D,	{ 0xE8, 0x95, 0xBD },
	0xCA9E,	{ 0xE8, 0x95, 0xBF },
	0xCA9F,	{ 0xE8, 0x96, 0x80 },
	0xCAA0,	{ 0xE8, 0x96, 0x81 },
	0xCAA1,	{ 0xE7, 0x9C, 0x81 },
	0xCAA2,	{ 0xE7, 0x9B, 0x9B },
	0xCAA3,	{ 0xE5, 0x89, 0xA9 },
	0xCAA4,	{ 0xE8, 0x83, 0x9C },
	0xCAA5,	{ 0xE5, 0x9C, 0xA3 },
	0xCAA6,	{ 0xE5, 0xB8, 0x88 },
	0xCAA7,	{ 0xE5, 0xA4, 0xB1 },
	0xCAA8,	{ 0xE7, 0x8B, 0xAE },
	0xCAA9,	{ 0xE6, 0x96, 0xBD },
	0xCAAA,	{ 0xE6, 0xB9, 0xBF },
	0xCAAB,	{ 0xE8, 0xAF, 0x97 },
	0xCAAC,	{ 0xE5, 0xB0, 0xB8 },
	0xCAAD,	{ 0xE8, 0x99, 0xB1 },
	0xCAAE,	{ 0xE5, 0x8D, 0x81 },
	0xCAAF,	{ 0xE7, 0x9F, 0xB3 },
	0xCAB0,	{ 0xE6, 0x8B, 0xBE },
	0xCAB1,	{ 0xE6, 0x97, 0xB6 },
	0xCAB2,	{ 0xE4, 0xBB, 0x80 },
	0xCAB3,	{ 0xE9, 0xA3, 0x9F },
	0xCAB4,	{ 0xE8, 0x9A, 0x80 },
	0xCAB5,	{ 0xE5, 0xAE, 0x9E },
	0xCAB6,	{ 0xE8, 0xAF, 0x86 },
	0xCAB7,	{ 0xE5, 0x8F, 0xB2 },
	0xCAB8,	{ 0xE7, 0x9F, 0xA2 },
	0xCAB9,	{ 0xE4, 0xBD, 0xBF },
	0xCABA,	{ 0xE5, 0xB1, 0x8E },
	0xCABB,	{ 0xE9, 0xA9, 0xB6 },
	0xCABC,	{ 0xE5, 0xA7, 0x8B },
	0xCABD,	{ 0xE5, 0xBC, 0x8F },
	0xCABE,	{ 0xE7, 0xA4, 0xBA },
	0xCABF,	{ 0xE5, 0xA3, 0xAB },
	0xCAC0,	{ 0xE4, 0xB8, 0x96 },
	0xCAC1,	{ 0xE6, 0x9F, 0xBF },
	0xCAC2,	{ 0xE4, 0xBA, 0x8B },
	0xCAC3,	{ 0xE6, 0x8B, 0xAD },
	0xCAC4,	{ 0xE8, 0xAA, 0x93 },
	0xCAC5,	{ 0xE9, 0x80, 0x9D },
	0xCAC6,	{ 0xE5, 0x8A, 0xBF },
	0xCAC7,	{ 0xE6, 0x98, 0xAF },
	0xCAC8,	{ 0xE5, 0x97, 0x9C },
	0xCAC9,	{ 0xE5, 0x99, 0xAC },
	0xCACA,	{ 0xE9, 0x80, 0x82 },
	0xCACB,	{ 0xE4, 0xBB, 0x95 },
	0xCACC,	{ 0xE4, 0xBE, 0x8D },
	0xCACD,	{ 0xE9, 0x87, 0x8A },
	0xCACE,	{ 0xE9, 0xA5, 0xB0 },
	0xCACF,	{ 0xE6, 0xB0, 0x8F },
	0xCAD0,	{ 0xE5, 0xB8, 0x82 },
	0xCAD1,	{ 0xE6, 0x81, 0x83 },
	0xCAD2,	{ 0xE5, 0xAE, 0xA4 },
	0xCAD3,	{ 0xE8, 0xA7, 0x86 },
	0xCAD4,	{ 0xE8, 0xAF, 0x95 },
	0xCAD5,	{ 0xE6, 0x94, 0xB6 },
	0xCAD6,	{ 0xE6, 0x89, 0x8B },
	0xCAD7,	{ 0xE9, 0xA6, 0x96 },
	0xCAD8,	{ 0xE5, 0xAE, 0x88 },
	0xCAD9,	{ 0xE5, 0xAF, 0xBF },
	0xCADA,	{ 0xE6, 0x8E, 0x88 },
	0xCADB,	{ 0xE5, 0x94, 0xAE },
	0xCADC,	{ 0xE5, 0x8F, 0x97 },
	0xCADD,	{ 0xE7, 0x98, 0xA6 },
	0xCADE,	{ 0xE5, 0x85, 0xBD },
	0xCADF,	{ 0xE8, 0x94, 0xAC },
	0xCAE0,	{ 0xE6, 0x9E, 0xA2 },
	0xCAE1,	{ 0xE6, 0xA2, 0xB3 },
	0xCAE2,	{ 0xE6, 0xAE, 0x8A },
	0xCAE3,	{ 0xE6, 0x8A, 0x92 },
	0xCAE4,	{ 0xE8, 0xBE, 0x93 },
	0xCAE5,	{ 0xE5, 0x8F, 0x94 },
	0xCAE6,	{ 0xE8, 0x88, 0x92 },
	0xCAE7,	{ 0xE6, 0xB7, 0x91 },
	0xCAE8,	{ 0xE7, 0x96, 0x8F },
	0xCAE9,	{ 0xE4, 0xB9, 0xA6 },
	0xCAEA,	{ 0xE8, 0xB5, 0x8E },
	0xCAEB,	{ 0xE5, 0xAD, 0xB0 },
	0xCAEC,	{ 0xE7, 0x86, 0x9F },
	0xCAED,	{ 0xE8, 0x96, 0xAF },
	0xCAEE,	{ 0xE6, 0x9A, 0x91 },
	0xCAEF,	{ 0xE6, 0x9B, 0x99 },
	0xCAF0,	{ 0xE7, 0xBD, 0xB2 },
	0xCAF1,	{ 0xE8, 0x9C, 0x80 },
	0xCAF2,	{ 0xE9, 0xBB, 0x8D },
	0xCAF3,	{ 0xE9, 0xBC, 0xA0 },
	0xCAF4,	{ 0xE5, 0xB1, 0x9E },
	0xCAF5,	{ 0xE6, 0x9C, 0xAF },
	0xCAF6,	{ 0xE8, 0xBF, 0xB0 },
	0xCAF7,	{ 0xE6, 0xA0, 0x91 },
	0xCAF8,	{ 0xE6, 0x9D, 0x9F },
	0xCAF9,	{ 0xE6, 0x88, 0x8D },
	0xCAFA,	{ 0xE7, 0xAB, 0x96 },
	0xCAFB,	{ 0xE5, 0xA2, 0x85 },
	0xCAFC,	{ 0xE5, 0xBA, 0xB6 },
	0xCAFD,	{ 0xE6, 0x95, 0xB0 },
	0xCAFE,	{ 0xE6, 0xBC, 0xB1 },
	0xCB40,	{ 0xE8, 0x96, 0x82 },
	0xCB41,	{ 0xE8, 0x96, 0x83 },
	0xCB42,	{ 0xE8, 0x96, 0x86 },
	0xCB43,	{ 0xE8, 0x96, 0x88 },
	0xCB44,	{ 0xE8, 0x96, 0x89 },
	0xCB45,	{ 0xE8, 0x96, 0x8A },
	0xCB46,	{ 0xE8, 0x96, 0x8B },
	0xCB47,	{ 0xE8, 0x96, 0x8C },
	0xCB48,	{ 0xE8, 0x96, 0x8D },
	0xCB49,	{ 0xE8, 0x96, 0x8E },
	0xCB4A,	{ 0xE8, 0x96, 0x90 },
	0xCB4B,	{ 0xE8, 0x96, 0x91 },
	0xCB4C,	{ 0xE8, 0x96, 0x92 },
	0xCB4D,	{ 0xE8, 0x96, 0x93 },
	0xCB4E,	{ 0xE8, 0x96, 0x94 },
	0xCB4F,	{ 0xE8, 0x96, 0x95 },
	0xCB50,	{ 0xE8, 0x96, 0x96 },
	0xCB51,	{ 0xE8, 0x96, 0x97 },
	0xCB52,	{ 0xE8, 0x96, 0x98 },
	0xCB53,	{ 0xE8, 0x96, 0x99 },
	0xCB54,	{ 0xE8, 0x96, 0x9A },
	0xCB55,	{ 0xE8, 0x96, 0x9D },
	0xCB56,	{ 0xE8, 0x96, 0x9E },
	0xCB57,	{ 0xE8, 0x96, 0x9F },
	0xCB58,	{ 0xE8, 0x96, 0xA0 },
	0xCB59,	{ 0xE8, 0x96, 0xA1 },
	0xCB5A,	{ 0xE8, 0x96, 0xA2 },
	0xCB5B,	{ 0xE8, 0x96, 0xA3 },
	0xCB5C,	{ 0xE8, 0x96, 0xA5 },
	0xCB5D,	{ 0xE8, 0x96, 0xA6 },
	0xCB5E,	{ 0xE8, 0x96, 0xA7 },
	0xCB5F,	{ 0xE8, 0x96, 0xA9 },
	0xCB60,	{ 0xE8, 0x96, 0xAB },
	0xCB61,	{ 0xE8, 0x96, 0xAC },
	0xCB62,	{ 0xE8, 0x96, 0xAD },
	0xCB63,	{ 0xE8, 0x96, 0xB1 },
	0xCB64,	{ 0xE8, 0x96, 0xB2 },
	0xCB65,	{ 0xE8, 0x96, 0xB3 },
	0xCB66,	{ 0xE8, 0x96, 0xB4 },
	0xCB67,	{ 0xE8, 0x96, 0xB5 },
	0xCB68,	{ 0xE8, 0x96, 0xB6 },
	0xCB69,	{ 0xE8, 0x96, 0xB8 },
	0xCB6A,	{ 0xE8, 0x96, 0xBA },
	0xCB6B,	{ 0xE8, 0x96, 0xBB },
	0xCB6C,	{ 0xE8, 0x96, 0xBC },
	0xCB6D,	{ 0xE8, 0x96, 0xBD },
	0xCB6E,	{ 0xE8, 0x96, 0xBE },
	0xCB6F,	{ 0xE8, 0x96, 0xBF },
	0xCB70,	{ 0xE8, 0x97, 0x80 },
	0xCB71,	{ 0xE8, 0x97, 0x82 },
	0xCB72,	{ 0xE8, 0x97, 0x83 },
	0xCB73,	{ 0xE8, 0x97, 0x84 },
	0xCB74,	{ 0xE8, 0x97, 0x85 },
	0xCB75,	{ 0xE8, 0x97, 0x86 },
	0xCB76,	{ 0xE8, 0x97, 0x87 },
	0xCB77,	{ 0xE8, 0x97, 0x88 },
	0xCB78,	{ 0xE8, 0x97, 0x8A },
	0xCB79,	{ 0xE8, 0x97, 0x8B },
	0xCB7A,	{ 0xE8, 0x97, 0x8C },
	0xCB7B,	{ 0xE8, 0x97, 0x8D },
	0xCB7C,	{ 0xE8, 0x97, 0x8E },
	0xCB7D,	{ 0xE8, 0x97, 0x91 },
	0xCB7E,	{ 0xE8, 0x97, 0x92 },
	0xCB80,	{ 0xE8, 0x97, 0x94 },
	0xCB81,	{ 0xE8, 0x97, 0x96 },
	0xCB82,	{ 0xE8, 0x97, 0x97 },
	0xCB83,	{ 0xE8, 0x97, 0x98 },
	0xCB84,	{ 0xE8, 0x97, 0x99 },
	0xCB85,	{ 0xE8, 0x97, 0x9A },
	0xCB86,	{ 0xE8, 0x97, 0x9B },
	0xCB87,	{ 0xE8, 0x97, 0x9D },
	0xCB88,	{ 0xE8, 0x97, 0x9E },
	0xCB89,	{ 0xE8, 0x97, 0x9F },
	0xCB8A,	{ 0xE8, 0x97, 0xA0 },
	0xCB8B,	{ 0xE8, 0x97, 0xA1 },
	0xCB8C,	{ 0xE8, 0x97, 0xA2 },
	0xCB8D,	{ 0xE8, 0x97, 0xA3 },
	0xCB8E,	{ 0xE8, 0x97, 0xA5 },
	0xCB8F,	{ 0xE8, 0x97, 0xA6 },
	0xCB90,	{ 0xE8, 0x97, 0xA7 },
	0xCB91,	{ 0xE8, 0x97, 0xA8 },
	0xCB92,	{ 0xE8, 0x97, 0xAA },
	0xCB93,	{ 0xE8, 0x97, 0xAB },
	0xCB94,	{ 0xE8, 0x97, 0xAC },
	0xCB95,	{ 0xE8, 0x97, 0xAD },
	0xCB96,	{ 0xE8, 0x97, 0xAE },
	0xCB97,	{ 0xE8, 0x97, 0xAF },
	0xCB98,	{ 0xE8, 0x97, 0xB0 },
	0xCB99,	{ 0xE8, 0x97, 0xB1 },
	0xCB9A,	{ 0xE8, 0x97, 0xB2 },
	0xCB9B,	{ 0xE8, 0x97, 0xB3 },
	0xCB9C,	{ 0xE8, 0x97, 0xB4 },
	0xCB9D,	{ 0xE8, 0x97, 0xB5 },
	0xCB9E,	{ 0xE8, 0x97, 0xB6 },
	0xCB9F,	{ 0xE8, 0x97, 0xB7 },
	0xCBA0,	{ 0xE8, 0x97, 0xB8 },
	0xCBA1,	{ 0xE6, 0x81, 0x95 },
	0xCBA2,	{ 0xE5, 0x88, 0xB7 },
	0xCBA3,	{ 0xE8, 0x80, 0x8D },
	0xCBA4,	{ 0xE6, 0x91, 0x94 },
	0xCBA5,	{ 0xE8, 0xA1, 0xB0 },
	0xCBA6,	{ 0xE7, 0x94, 0xA9 },
	0xCBA7,	{ 0xE5, 0xB8, 0x85 },
	0xCBA8,	{ 0xE6, 0xA0, 0x93 },
	0xCBA9,	{ 0xE6, 0x8B, 0xB4 },
	0xCBAA,	{ 0xE9, 0x9C, 0x9C },
	0xCBAB,	{ 0xE5, 0x8F, 0x8C },
	0xCBAC,	{ 0xE7, 0x88, 0xBD },
	0xCBAD,	{ 0xE8, 0xB0, 0x81 },
	0xCBAE,	{ 0xE6, 0xB0, 0xB4 },
	0xCBAF,	{ 0xE7, 0x9D, 0xA1 },
	0xCBB0,	{ 0xE7, 0xA8, 0x8E },
	0xCBB1,	{ 0xE5, 0x90, 0xAE },
	0xCBB2,	{ 0xE7, 0x9E, 0xAC },
	0xCBB3,	{ 0xE9, 0xA1, 0xBA },
	0xCBB4,	{ 0xE8, 0x88, 0x9C },
	0xCBB5,	{ 0xE8, 0xAF, 0xB4 },
	0xCBB6,	{ 0xE7, 0xA1, 0x95 },
	0xCBB7,	{ 0xE6, 0x9C, 0x94 },
	0xCBB8,	{ 0xE7, 0x83, 0x81 },
	0xCBB9,	{ 0xE6, 0x96, 0xAF },
	0xCBBA,	{ 0xE6, 0x92, 0x95 },
	0xCBBB,	{ 0xE5, 0x98, 0xB6 },
	0xCBBC,	{ 0xE6, 0x80, 0x9D },
	0xCBBD,	{ 0xE7, 0xA7, 0x81 },
	0xCBBE,	{ 0xE5, 0x8F, 0xB8 },
	0xCBBF,	{ 0xE4, 0xB8, 0x9D },
	0xCBC0,	{ 0xE6, 0xAD, 0xBB },
	0xCBC1,	{ 0xE8, 0x82, 0x86 },
	0xCBC2,	{ 0xE5, 0xAF, 0xBA },
	0xCBC3,	{ 0xE5, 0x97, 0xA3 },
	0xCBC4,	{ 0xE5, 0x9B, 0x9B },
	0xCBC5,	{ 0xE4, 0xBC, 0xBA },
	0xCBC6,	{ 0xE4, 0xBC, 0xBC },
	0xCBC7,	{ 0xE9, 0xA5, 0xB2 },
	0xCBC8,	{ 0xE5, 0xB7, 0xB3 },
	0xCBC9,	{ 0xE6, 0x9D, 0xBE },
	0xCBCA,	{ 0xE8, 0x80, 0xB8 },
	0xCBCB,	{ 0xE6, 0x80, 0x82 },
	0xCBCC,	{ 0xE9, 0xA2, 0x82 },
	0xCBCD,	{ 0xE9, 0x80, 0x81 },
	0xCBCE,	{ 0xE5, 0xAE, 0x8B },
	0xCBCF,	{ 0xE8, 0xAE, 0xBC },
	0xCBD0,	{ 0xE8, 0xAF, 0xB5 },
	0xCBD1,	{ 0xE6, 0x90, 0x9C },
	0xCBD2,	{ 0xE8, 0x89, 0x98 },
	0xCBD3,	{ 0xE6, 0x93, 0x9E },
	0xCBD4,	{ 0xE5, 0x97, 0xBD },
	0xCBD5,	{ 0xE8, 0x8B, 0x8F },
	0xCBD6,	{ 0xE9, 0x85, 0xA5 },
	0xCBD7,	{ 0xE4, 0xBF, 0x97 },
	0xCBD8,	{ 0xE7, 0xB4, 0xA0 },
	0xCBD9,	{ 0xE9, 0x80, 0x9F },
	0xCBDA,	{ 0xE7, 0xB2, 0x9F },
	0xCBDB,	{ 0xE5, 0x83, 0xB3 },
	0xCBDC,	{ 0xE5, 0xA1, 0x91 },
	0xCBDD,	{ 0xE6, 0xBA, 0xAF },
	0xCBDE,	{ 0xE5, 0xAE, 0xBF },
	0xCBDF,	{ 0xE8, 0xAF, 0x89 },
	0xCBE0,	{ 0xE8, 0x82, 0x83 },
	0xCBE1,	{ 0xE9, 0x85, 0xB8 },
	0xCBE2,	{ 0xE8, 0x92, 0x9C },
	0xCBE3,	{ 0xE7, 0xAE, 0x97 },
	0xCBE4,	{ 0xE8, 0x99, 0xBD },
	0xCBE5,	{ 0xE9, 0x9A, 0x8B },
	0xCBE6,	{ 0xE9, 0x9A, 0x8F },
	0xCBE7,	{ 0xE7, 0xBB, 0xA5 },
	0xCBE8,	{ 0xE9, 0xAB, 0x93 },
	0xCBE9,	{ 0xE7, 0xA2, 0x8E },
	0xCBEA,	{ 0xE5, 0xB2, 0x81 },
	0xCBEB,	{ 0xE7, 0xA9, 0x97 },
	0xCBEC,	{ 0xE9, 0x81, 0x82 },
	0xCBED,	{ 0xE9, 0x9A, 0xA7 },
	0xCBEE,	{ 0xE7, 0xA5, 0x9F },
	0xCBEF,	{ 0xE5, 0xAD, 0x99 },
	0xCBF0,	{ 0xE6, 0x8D, 0x9F },
	0xCBF1,	{ 0xE7, 0xAC, 0x8B },
	0xCBF2,	{ 0xE8, 0x93, 0x91 },
	0xCBF3,	{ 0xE6, 0xA2, 0xAD },
	0xCBF4,	{ 0xE5, 0x94, 0x86 },
	0xCBF5,	{ 0xE7, 0xBC, 0xA9 },
	0xCBF6,	{ 0xE7, 0x90, 0x90 },
	0xCBF7,	{ 0xE7, 0xB4, 0xA2 },
	0xCBF8,	{ 0xE9, 0x94, 0x81 },
	0xCBF9,	{ 0xE6, 0x89, 0x80 },
	0xCBFA,	{ 0xE5, 0xA1, 0x8C },
	0xCBFB,	{ 0xE4, 0xBB, 0x96 },
	0xCBFC,	{ 0xE5, 0xAE, 0x83 },
	0xCBFD,	{ 0xE5, 0xA5, 0xB9 },
	0xCBFE,	{ 0xE5, 0xA1, 0x94 },
	0xCC40,	{ 0xE8, 0x97, 0xB9 },
	0xCC41,	{ 0xE8, 0x97, 0xBA },
	0xCC42,	{ 0xE8, 0x97, 0xBC },
	0xCC43,	{ 0xE8, 0x97, 0xBD },
	0xCC44,	{ 0xE8, 0x97, 0xBE },
	0xCC45,	{ 0xE8, 0x98, 0x80 },
	0xCC46,	{ 0xE8, 0x98, 0x81 },
	0xCC47,	{ 0xE8, 0x98, 0x82 },
	0xCC48,	{ 0xE8, 0x98, 0x83 },
	0xCC49,	{ 0xE8, 0x98, 0x84 },
	0xCC4A,	{ 0xE8, 0x98, 0x86 },
	0xCC4B,	{ 0xE8, 0x98, 0x87 },
	0xCC4C,	{ 0xE8, 0x98, 0x88 },
	0xCC4D,	{ 0xE8, 0x98, 0x89 },
	0xCC4E,	{ 0xE8, 0x98, 0x8A },
	0xCC4F,	{ 0xE8, 0x98, 0x8B },
	0xCC50,	{ 0xE8, 0x98, 0x8C },
	0xCC51,	{ 0xE8, 0x98, 0x8D },
	0xCC52,	{ 0xE8, 0x98, 0x8E },
	0xCC53,	{ 0xE8, 0x98, 0x8F },
	0xCC54,	{ 0xE8, 0x98, 0x90 },
	0xCC55,	{ 0xE8, 0x98, 0x92 },
	0xCC56,	{ 0xE8, 0x98, 0x93 },
	0xCC57,	{ 0xE8, 0x98, 0x94 },
	0xCC58,	{ 0xE8, 0x98, 0x95 },
	0xCC59,	{ 0xE8, 0x98, 0x97 },
	0xCC5A,	{ 0xE8, 0x98, 0x98 },
	0xCC5B,	{ 0xE8, 0x98, 0x99 },
	0xCC5C,	{ 0xE8, 0x98, 0x9A },
	0xCC5D,	{ 0xE8, 0x98, 0x9B },
	0xCC5E,	{ 0xE8, 0x98, 0x9C },
	0xCC5F,	{ 0xE8, 0x98, 0x9D },
	0xCC60,	{ 0xE8, 0x98, 0x9E },
	0xCC61,	{ 0xE8, 0x98, 0x9F },
	0xCC62,	{ 0xE8, 0x98, 0xA0 },
	0xCC63,	{ 0xE8, 0x98, 0xA1 },
	0xCC64,	{ 0xE8, 0x98, 0xA2 },
	0xCC65,	{ 0xE8, 0x98, 0xA3 },
	0xCC66,	{ 0xE8, 0x98, 0xA4 },
	0xCC67,	{ 0xE8, 0x98, 0xA5 },
	0xCC68,	{ 0xE8, 0x98, 0xA6 },
	0xCC69,	{ 0xE8, 0x98, 0xA8 },
	0xCC6A,	{ 0xE8, 0x98, 0xAA },
	0xCC6B,	{ 0xE8, 0x98, 0xAB },
	0xCC6C,	{ 0xE8, 0x98, 0xAC },
	0xCC6D,	{ 0xE8, 0x98, 0xAD },
	0xCC6E,	{ 0xE8, 0x98, 0xAE },
	0xCC6F,	{ 0xE8, 0x98, 0xAF },
	0xCC70,	{ 0xE8, 0x98, 0xB0 },
	0xCC71,	{ 0xE8, 0x98, 0xB1 },
	0xCC72,	{ 0xE8, 0x98, 0xB2 },
	0xCC73,	{ 0xE8, 0x98, 0xB3 },
	0xCC74,	{ 0xE8, 0x98, 0xB4 },
	0xCC75,	{ 0xE8, 0x98, 0xB5 },
	0xCC76,	{ 0xE8, 0x98, 0xB6 },
	0xCC77,	{ 0xE8, 0x98, 0xB7 },
	0xCC78,	{ 0xE8, 0x98, 0xB9 },
	0xCC79,	{ 0xE8, 0x98, 0xBA },
	0xCC7A,	{ 0xE8, 0x98, 0xBB },
	0xCC7B,	{ 0xE8, 0x98, 0xBD },
	0xCC7C,	{ 0xE8, 0x98, 0xBE },
	0xCC7D,	{ 0xE8, 0x98, 0xBF },
	0xCC7E,	{ 0xE8, 0x99, 0x80 },
	0xCC80,	{ 0xE8, 0x99, 0x81 },
	0xCC81,	{ 0xE8, 0x99, 0x82 },
	0xCC82,	{ 0xE8, 0x99, 0x83 },
	0xCC83,	{ 0xE8, 0x99, 0x84 },
	0xCC84,	{ 0xE8, 0x99, 0x85 },
	0xCC85,	{ 0xE8, 0x99, 0x86 },
	0xCC86,	{ 0xE8, 0x99, 0x87 },
	0xCC87,	{ 0xE8, 0x99, 0x88 },
	0xCC88,	{ 0xE8, 0x99, 0x89 },
	0xCC89,	{ 0xE8, 0x99, 0x8A },
	0xCC8A,	{ 0xE8, 0x99, 0x8B },
	0xCC8B,	{ 0xE8, 0x99, 0x8C },
	0xCC8C,	{ 0xE8, 0x99, 0x92 },
	0xCC8D,	{ 0xE8, 0x99, 0x93 },
	0xCC8E,	{ 0xE8, 0x99, 0x95 },
	0xCC8F,	{ 0xE8, 0x99, 0x96 },
	0xCC90,	{ 0xE8, 0x99, 0x97 },
	0xCC91,	{ 0xE8, 0x99, 0x98 },
	0xCC92,	{ 0xE8, 0x99, 0x99 },
	0xCC93,	{ 0xE8, 0x99, 0x9B },
	0xCC94,	{ 0xE8, 0x99, 0x9C },
	0xCC95,	{ 0xE8, 0x99, 0x9D },
	0xCC96,	{ 0xE8, 0x99, 0x9F },
	0xCC97,	{ 0xE8, 0x99, 0xA0 },
	0xCC98,	{ 0xE8, 0x99, 0xA1 },
	0xCC99,	{ 0xE8, 0x99, 0xA3 },
	0xCC9A,	{ 0xE8, 0x99, 0xA4 },
	0xCC9B,	{ 0xE8, 0x99, 0xA5 },
	0xCC9C,	{ 0xE8, 0x99, 0xA6 },
	0xCC9D,	{ 0xE8, 0x99, 0xA7 },
	0xCC9E,	{ 0xE8, 0x99, 0xA8 },
	0xCC9F,	{ 0xE8, 0x99, 0xA9 },
	0xCCA0,	{ 0xE8, 0x99, 0xAA },
	0xCCA1,	{ 0xE7, 0x8D, 0xAD },
	0xCCA2,	{ 0xE6, 0x8C, 0x9E },
	0xCCA3,	{ 0xE8, 0xB9, 0x8B },
	0xCCA4,	{ 0xE8, 0xB8, 0x8F },
	0xCCA5,	{ 0xE8, 0x83, 0x8E },
	0xCCA6,	{ 0xE8, 0x8B, 0x94 },
	0xCCA7,	{ 0xE6, 0x8A, 0xAC },
	0xCCA8,	{ 0xE5, 0x8F, 0xB0 },
	0xCCA9,	{ 0xE6, 0xB3, 0xB0 },
	0xCCAA,	{ 0xE9, 0x85, 0x9E },
	0xCCAB,	{ 0xE5, 0xA4, 0xAA },
	0xCCAC,	{ 0xE6, 0x80, 0x81 },
	0xCCAD,	{ 0xE6, 0xB1, 0xB0 },
	0xCCAE,	{ 0xE5, 0x9D, 0x8D },
	0xCCAF,	{ 0xE6, 0x91, 0x8A },
	0xCCB0,	{ 0xE8, 0xB4, 0xAA },
	0xCCB1,	{ 0xE7, 0x98, 0xAB },
	0xCCB2,	{ 0xE6, 0xBB, 0xA9 },
	0xCCB3,	{ 0xE5, 0x9D, 0x9B },
	0xCCB4,	{ 0xE6, 0xAA, 0x80 },
	0xCCB5,	{ 0xE7, 0x97, 0xB0 },
	0xCCB6,	{ 0xE6, 0xBD, 0xAD },
	0xCCB7,	{ 0xE8, 0xB0, 0xAD },
	0xCCB8,	{ 0xE8, 0xB0, 0x88 },
	0xCCB9,	{ 0xE5, 0x9D, 0xA6 },
	0xCCBA,	{ 0xE6, 0xAF, 0xAF },
	0xCCBB,	{ 0xE8, 0xA2, 0x92 },
	0xCCBC,	{ 0xE7, 0xA2, 0xB3 },
	0xCCBD,	{ 0xE6, 0x8E, 0xA2 },
	0xCCBE,	{ 0xE5, 0x8F, 0xB9 },
	0xCCBF,	{ 0xE7, 0x82, 0xAD },
	0xCCC0,	{ 0xE6, 0xB1, 0xA4 },
	0xCCC1,	{ 0xE5, 0xA1, 0x98 },
	0xCCC2,	{ 0xE6, 0x90, 0xAA },
	0xCCC3,	{ 0xE5, 0xA0, 0x82 },
	0xCCC4,	{ 0xE6, 0xA3, 0xA0 },
	0xCCC5,	{ 0xE8, 0x86, 0x9B },
	0xCCC6,	{ 0xE5, 0x94, 0x90 },
	0xCCC7,	{ 0xE7, 0xB3, 0x96 },
	0xCCC8,	{ 0xE5, 0x80, 0x98 },
	0xCCC9,	{ 0xE8, 0xBA, 0xBA },
	0xCCCA,	{ 0xE6, 0xB7, 0x8C },
	0xCCCB,	{ 0xE8, 0xB6, 0x9F },
	0xCCCC,	{ 0xE7, 0x83, 0xAB },
	0xCCCD,	{ 0xE6, 0x8E, 0x8F },
	0xCCCE,	{ 0xE6, 0xB6, 0x9B },
	0xCCCF,	{ 0xE6, 0xBB, 0x94 },
	0xCCD0,	{ 0xE7, 0xBB, 0xA6 },
	0xCCD1,	{ 0xE8, 0x90, 0x84 },
	0xCCD2,	{ 0xE6, 0xA1, 0x83 },
	0xCCD3,	{ 0xE9, 0x80, 0x83 },
	0xCCD4,	{ 0xE6, 0xB7, 0x98 },
	0xCCD5,	{ 0xE9, 0x99, 0xB6 },
	0xCCD6,	{ 0xE8, 0xAE, 0xA8 },
	0xCCD7,	{ 0xE5, 0xA5, 0x97 },
	0xCCD8,	{ 0xE7, 0x89, 0xB9 },
	0xCCD9,	{ 0xE8, 0x97, 0xA4 },
	0xCCDA,	{ 0xE8, 0x85, 0xBE },
	0xCCDB,	{ 0xE7, 0x96, 0xBC },
	0xCCDC,	{ 0xE8, 0xAA, 0x8A },
	0xCCDD,	{ 0xE6, 0xA2, 0xAF },
	0xCCDE,	{ 0xE5, 0x89, 0x94 },
	0xCCDF,	{ 0xE8, 0xB8, 0xA2 },
	0xCCE0,	{ 0xE9, 0x94, 0x91 },
	0xCCE1,	{ 0xE6, 0x8F, 0x90 },
	0xCCE2,	{ 0xE9, 0xA2, 0x98 },
	0xCCE3,	{ 0xE8, 0xB9, 0x84 },
	0xCCE4,	{ 0xE5, 0x95, 0xBC },
	0xCCE5,	{ 0xE4, 0xBD, 0x93 },
	0xCCE6,	{ 0xE6, 0x9B, 0xBF },
	0xCCE7,	{ 0xE5, 0x9A, 0x8F },
	0xCCE8,	{ 0xE6, 0x83, 0x95 },
	0xCCE9,	{ 0xE6, 0xB6, 0x95 },
	0xCCEA,	{ 0xE5, 0x89, 0x83 },
	0xCCEB,	{ 0xE5, 0xB1, 0x89 },
	0xCCEC,	{ 0xE5, 0xA4, 0xA9 },
	0xCCED,	{ 0xE6, 0xB7, 0xBB },
	0xCCEE,	{ 0xE5, 0xA1, 0xAB },
	0xCCEF,	{ 0xE7, 0x94, 0xB0 },
	0xCCF0,	{ 0xE7, 0x94, 0x9C },
	0xCCF1,	{ 0xE6, 0x81, 0xAC },
	0xCCF2,	{ 0xE8, 0x88, 0x94 },
	0xCCF3,	{ 0xE8, 0x85, 0x86 },
	0xCCF4,	{ 0xE6, 0x8C, 0x91 },
	0xCCF5,	{ 0xE6, 0x9D, 0xA1 },
	0xCCF6,	{ 0xE8, 0xBF, 0xA2 },
	0xCCF7,	{ 0xE7, 0x9C, 0xBA },
	0xCCF8,	{ 0xE8, 0xB7, 0xB3 },
	0xCCF9,	{ 0xE8, 0xB4, 0xB4 },
	0xCCFA,	{ 0xE9, 0x93, 0x81 },
	0xCCFB,	{ 0xE5, 0xB8, 0x96 },
	0xCCFC,	{ 0xE5, 0x8E, 0x85 },
	0xCCFD,	{ 0xE5, 0x90, 0xAC },
	0xCCFE,	{ 0xE7, 0x83, 0x83 },
	0xCD40,	{ 0xE8, 0x99, 0xAD },
	0xCD41,	{ 0xE8, 0x99, 0xAF },
	0xCD42,	{ 0xE8, 0x99, 0xB0 },
	0xCD43,	{ 0xE8, 0x99, 0xB2 },
	0xCD44,	{ 0xE8, 0x99, 0xB3 },
	0xCD45,	{ 0xE8, 0x99, 0xB4 },
	0xCD46,	{ 0xE8, 0x99, 0xB5 },
	0xCD47,	{ 0xE8, 0x99, 0xB6 },
	0xCD48,	{ 0xE8, 0x99, 0xB7 },
	0xCD49,	{ 0xE8, 0x99, 0xB8 },
	0xCD4A,	{ 0xE8, 0x9A, 0x83 },
	0xCD4B,	{ 0xE8, 0x9A, 0x84 },
	0xCD4C,	{ 0xE8, 0x9A, 0x85 },
	0xCD4D,	{ 0xE8, 0x9A, 0x86 },
	0xCD4E,	{ 0xE8, 0x9A, 0x87 },
	0xCD4F,	{ 0xE8, 0x9A, 0x88 },
	0xCD50,	{ 0xE8, 0x9A, 0x89 },
	0xCD51,	{ 0xE8, 0x9A, 0x8E },
	0xCD52,	{ 0xE8, 0x9A, 0x8F },
	0xCD53,	{ 0xE8, 0x9A, 0x90 },
	0xCD54,	{ 0xE8, 0x9A, 0x91 },
	0xCD55,	{ 0xE8, 0x9A, 0x92 },
	0xCD56,	{ 0xE8, 0x9A, 0x94 },
	0xCD57,	{ 0xE8, 0x9A, 0x96 },
	0xCD58,	{ 0xE8, 0x9A, 0x97 },
	0xCD59,	{ 0xE8, 0x9A, 0x98 },
	0xCD5A,	{ 0xE8, 0x9A, 0x99 },
	0xCD5B,	{ 0xE8, 0x9A, 0x9A },
	0xCD5C,	{ 0xE8, 0x9A, 0x9B },
	0xCD5D,	{ 0xE8, 0x9A, 0x9E },
	0xCD5E,	{ 0xE8, 0x9A, 0x9F },
	0xCD5F,	{ 0xE8, 0x9A, 0xA0 },
	0xCD60,	{ 0xE8, 0x9A, 0xA1 },
	0xCD61,	{ 0xE8, 0x9A, 0xA2 },
	0xCD62,	{ 0xE8, 0x9A, 0xA5 },
	0xCD63,	{ 0xE8, 0x9A, 0xA6 },
	0xCD64,	{ 0xE8, 0x9A, 0xAB },
	0xCD65,	{ 0xE8, 0x9A, 0xAD },
	0xCD66,	{ 0xE8, 0x9A, 0xAE },
	0xCD67,	{ 0xE8, 0x9A, 0xB2 },
	0xCD68,	{ 0xE8, 0x9A, 0xB3 },
	0xCD69,	{ 0xE8, 0x9A, 0xB7 },
	0xCD6A,	{ 0xE8, 0x9A, 0xB8 },
	0xCD6B,	{ 0xE8, 0x9A, 0xB9 },
	0xCD6C,	{ 0xE8, 0x9A, 0xBB },
	0xCD6D,	{ 0xE8, 0x9A, 0xBC },
	0xCD6E,	{ 0xE8, 0x9A, 0xBD },
	0xCD6F,	{ 0xE8, 0x9A, 0xBE },
	0xCD70,	{ 0xE8, 0x9A, 0xBF },
	0xCD71,	{ 0xE8, 0x9B, 0x81 },
	0xCD72,	{ 0xE8, 0x9B, 0x82 },
	0xCD73,	{ 0xE8, 0x9B, 0x83 },
	0xCD74,	{ 0xE8, 0x9B, 0x85 },
	0xCD75,	{ 0xE8, 0x9B, 0x88 },
	0xCD76,	{ 0xE8, 0x9B, 0x8C },
	0xCD77,	{ 0xE8, 0x9B, 0x8D },
	0xCD78,	{ 0xE8, 0x9B, 0x92 },
	0xCD79,	{ 0xE8, 0x9B, 0x93 },
	0xCD7A,	{ 0xE8, 0x9B, 0x95 },
	0xCD7B,	{ 0xE8, 0x9B, 0x96 },
	0xCD7C,	{ 0xE8, 0x9B, 0x97 },
	0xCD7D,	{ 0xE8, 0x9B, 0x9A },
	0xCD7E,	{ 0xE8, 0x9B, 0x9C },
	0xCD80,	{ 0xE8, 0x9B, 0x9D },
	0xCD81,	{ 0xE8, 0x9B, 0xA0 },
	0xCD82,	{ 0xE8, 0x9B, 0xA1 },
	0xCD83,	{ 0xE8, 0x9B, 0xA2 },
	0xCD84,	{ 0xE8, 0x9B, 0xA3 },
	0xCD85,	{ 0xE8, 0x9B, 0xA5 },
	0xCD86,	{ 0xE8, 0x9B, 0xA6 },
	0xCD87,	{ 0xE8, 0x9B, 0xA7 },
	0xCD88,	{ 0xE8, 0x9B, 0xA8 },
	0xCD89,	{ 0xE8, 0x9B, 0xAA },
	0xCD8A,	{ 0xE8, 0x9B, 0xAB },
	0xCD8B,	{ 0xE8, 0x9B, 0xAC },
	0xCD8C,	{ 0xE8, 0x9B, 0xAF },
	0xCD8D,	{ 0xE8, 0x9B, 0xB5 },
	0xCD8E,	{ 0xE8, 0x9B, 0xB6 },
	0xCD8F,	{ 0xE8, 0x9B, 0xB7 },
	0xCD90,	{ 0xE8, 0x9B, 0xBA },
	0xCD91,	{ 0xE8, 0x9B, 0xBB },
	0xCD92,	{ 0xE8, 0x9B, 0xBC },
	0xCD93,	{ 0xE8, 0x9B, 0xBD },
	0xCD94,	{ 0xE8, 0x9B, 0xBF },
	0xCD95,	{ 0xE8, 0x9C, 0x81 },
	0xCD96,	{ 0xE8, 0x9C, 0x84 },
	0xCD97,	{ 0xE8, 0x9C, 0x85 },
	0xCD98,	{ 0xE8, 0x9C, 0x86 },
	0xCD99,	{ 0xE8, 0x9C, 0x8B },
	0xCD9A,	{ 0xE8, 0x9C, 0x8C },
	0xCD9B,	{ 0xE8, 0x9C, 0x8E },
	0xCD9C,	{ 0xE8, 0x9C, 0x8F },
	0xCD9D,	{ 0xE8, 0x9C, 0x90 },
	0xCD9E,	{ 0xE8, 0x9C, 0x91 },
	0xCD9F,	{ 0xE8, 0x9C, 0x94 },
	0xCDA0,	{ 0xE8, 0x9C, 0x96 },
	0xCDA1,	{ 0xE6, 0xB1, 0x80 },
	0xCDA2,	{ 0xE5, 0xBB, 0xB7 },
	0xCDA3,	{ 0xE5, 0x81, 0x9C },
	0xCDA4,	{ 0xE4, 0xBA, 0xAD },
	0xCDA5,	{ 0xE5, 0xBA, 0xAD },
	0xCDA6,	{ 0xE6, 0x8C, 0xBA },
	0xCDA7,	{ 0xE8, 0x89, 0x87 },
	0xCDA8,	{ 0xE9, 0x80, 0x9A },
	0xCDA9,	{ 0xE6, 0xA1, 0x90 },
	0xCDAA,	{ 0xE9, 0x85, 0xAE },
	0xCDAB,	{ 0xE7, 0x9E, 0xB3 },
	0xCDAC,	{ 0xE5, 0x90, 0x8C },
	0xCDAD,	{ 0xE9, 0x93, 0x9C },
	0xCDAE,	{ 0xE5, 0xBD, 0xA4 },
	0xCDAF,	{ 0xE7, 0xAB, 0xA5 },
	0xCDB0,	{ 0xE6, 0xA1, 0xB6 },
	0xCDB1,	{ 0xE6, 0x8D, 0x85 },
	0xCDB2,	{ 0xE7, 0xAD, 0x92 },
	0xCDB3,	{ 0xE7, 0xBB, 0x9F },
	0xCDB4,	{ 0xE7, 0x97, 0x9B },
	0xCDB5,	{ 0xE5, 0x81, 0xB7 },
	0xCDB6,	{ 0xE6, 0x8A, 0x95 },
	0xCDB7,	{ 0xE5, 0xA4, 0xB4 },
	0xCDB8,	{ 0xE9, 0x80, 0x8F },
	0xCDB9,	{ 0xE5, 0x87, 0xB8 },
	0xCDBA,	{ 0xE7, 0xA7, 0x83 },
	0xCDBB,	{ 0xE7, 0xAA, 0x81 },
	0xCDBC,	{ 0xE5, 0x9B, 0xBE },
	0xCDBD,	{ 0xE5, 0xBE, 0x92 },
	0xCDBE,	{ 0xE9, 0x80, 0x94 },
	0xCDBF,	{ 0xE6, 0xB6, 0x82 },
	0xCDC0,	{ 0xE5, 0xB1, 0xA0 },
	0xCDC1,	{ 0xE5, 0x9C, 0x9F },
	0xCDC2,	{ 0xE5, 0x90, 0x90 },
	0xCDC3,	{ 0xE5, 0x85, 0x94 },
	0xCDC4,	{ 0xE6, 0xB9, 0x8D },
	0xCDC5,	{ 0xE5, 0x9B, 0xA2 },
	0xCDC6,	{ 0xE6, 0x8E, 0xA8 },
	0xCDC7,	{ 0xE9, 0xA2, 0x93 },
	0xCDC8,	{ 0xE8, 0x85, 0xBF },
	0xCDC9,	{ 0xE8, 0x9C, 0x95 },
	0xCDCA,	{ 0xE8, 0xA4, 0xAA },
	0xCDCB,	{ 0xE9, 0x80, 0x80 },
	0xCDCC,	{ 0xE5, 0x90, 0x9E },
	0xCDCD,	{ 0xE5, 0xB1, 0xAF },
	0xCDCE,	{ 0xE8, 0x87, 0x80 },
	0xCDCF,	{ 0xE6, 0x8B, 0x96 },
	0xCDD0,	{ 0xE6, 0x89, 0x98 },
	0xCDD1,	{ 0xE8, 0x84, 0xB1 },
	0xCDD2,	{ 0xE9, 0xB8, 0xB5 },
	0xCDD3,	{ 0xE9, 0x99, 0x80 },
	0xCDD4,	{ 0xE9, 0xA9, 0xAE },
	0xCDD5,	{ 0xE9, 0xA9, 0xBC },
	0xCDD6,	{ 0xE6, 0xA4, 0xAD },
	0xCDD7,	{ 0xE5, 0xA6, 0xA5 },
	0xCDD8,	{ 0xE6, 0x8B, 0x93 },
	0xCDD9,	{ 0xE5, 0x94, 0xBE },
	0xCDDA,	{ 0xE6, 0x8C, 0x96 },
	0xCDDB,	{ 0xE5, 0x93, 0x87 },
	0xCDDC,	{ 0xE8, 0x9B, 0x99 },
	0xCDDD,	{ 0xE6, 0xB4, 0xBC },
	0xCDDE,	{ 0xE5, 0xA8, 0x83 },
	0xCDDF,	{ 0xE7, 0x93, 0xA6 },
	0xCDE0,	{ 0xE8, 0xA2, 0x9C },
	0xCDE1,	{ 0xE6, 0xAD, 0xAA },
	0xCDE2,	{ 0xE5, 0xA4, 0x96 },
	0xCDE3,	{ 0xE8, 0xB1, 0x8C },
	0xCDE4,	{ 0xE5, 0xBC, 0xAF },
	0xCDE5,	{ 0xE6, 0xB9, 0xBE },
	0xCDE6,	{ 0xE7, 0x8E, 0xA9 },
	0xCDE7,	{ 0xE9, 0xA1, 0xBD },
	0xCDE8,	{ 0xE4, 0xB8, 0xB8 },
	0xCDE9,	{ 0xE7, 0x83, 0xB7 },
	0xCDEA,	{ 0xE5, 0xAE, 0x8C },
	0xCDEB,	{ 0xE7, 0xA2, 0x97 },
	0xCDEC,	{ 0xE6, 0x8C, 0xBD },
	0xCDED,	{ 0xE6, 0x99, 0x9A },
	0xCDEE,	{ 0xE7, 0x9A, 0x96 },
	0xCDEF,	{ 0xE6, 0x83, 0x8B },
	0xCDF0,	{ 0xE5, 0xAE, 0x9B },
	0xCDF1,	{ 0xE5, 0xA9, 0x89 },
	0xCDF2,	{ 0xE4, 0xB8, 0x87 },
	0xCDF3,	{ 0xE8, 0x85, 0x95 },
	0xCDF4,	{ 0xE6, 0xB1, 0xAA },
	0xCDF5,	{ 0xE7, 0x8E, 0x8B },
	0xCDF6,	{ 0xE4, 0xBA, 0xA1 },
	0xCDF7,	{ 0xE6, 0x9E, 0x89 },
	0xCDF8,	{ 0xE7, 0xBD, 0x91 },
	0xCDF9,	{ 0xE5, 0xBE, 0x80 },
	0xCDFA,	{ 0xE6, 0x97, 0xBA },
	0xCDFB,	{ 0xE6, 0x9C, 0x9B },
	0xCDFC,	{ 0xE5, 0xBF, 0x98 },
	0xCDFD,	{ 0xE5, 0xA6, 0x84 },
	0xCDFE,	{ 0xE5, 0xA8, 0x81 },
	0xCE40,	{ 0xE8, 0x9C, 0x99 },
	0xCE41,	{ 0xE8, 0x9C, 0x9B },
	0xCE42,	{ 0xE8, 0x9C, 0x9D },
	0xCE43,	{ 0xE8, 0x9C, 0x9F },
	0xCE44,	{ 0xE8, 0x9C, 0xA0 },
	0xCE45,	{ 0xE8, 0x9C, 0xA4 },
	0xCE46,	{ 0xE8, 0x9C, 0xA6 },
	0xCE47,	{ 0xE8, 0x9C, 0xA7 },
	0xCE48,	{ 0xE8, 0x9C, 0xA8 },
	0xCE49,	{ 0xE8, 0x9C, 0xAA },
	0xCE4A,	{ 0xE8, 0x9C, 0xAB },
	0xCE4B,	{ 0xE8, 0x9C, 0xAC },
	0xCE4C,	{ 0xE8, 0x9C, 0xAD },
	0xCE4D,	{ 0xE8, 0x9C, 0xAF },
	0xCE4E,	{ 0xE8, 0x9C, 0xB0 },
	0xCE4F,	{ 0xE8, 0x9C, 0xB2 },
	0xCE50,	{ 0xE8, 0x9C, 0xB3 },
	0xCE51,	{ 0xE8, 0x9C, 0xB5 },
	0xCE52,	{ 0xE8, 0x9C, 0xB6 },
	0xCE53,	{ 0xE8, 0x9C, 0xB8 },
	0xCE54,	{ 0xE8, 0x9C, 0xB9 },
	0xCE55,	{ 0xE8, 0x9C, 0xBA },
	0xCE56,	{ 0xE8, 0x9C, 0xBC },
	0xCE57,	{ 0xE8, 0x9C, 0xBD },
	0xCE58,	{ 0xE8, 0x9D, 0x80 },
	0xCE59,	{ 0xE8, 0x9D, 0x81 },
	0xCE5A,	{ 0xE8, 0x9D, 0x82 },
	0xCE5B,	{ 0xE8, 0x9D, 0x83 },
	0xCE5C,	{ 0xE8, 0x9D, 0x84 },
	0xCE5D,	{ 0xE8, 0x9D, 0x85 },
	0xCE5E,	{ 0xE8, 0x9D, 0x86 },
	0xCE5F,	{ 0xE8, 0x9D, 0x8A },
	0xCE60,	{ 0xE8, 0x9D, 0x8B },
	0xCE61,	{ 0xE8, 0x9D, 0x8D },
	0xCE62,	{ 0xE8, 0x9D, 0x8F },
	0xCE63,	{ 0xE8, 0x9D, 0x90 },
	0xCE64,	{ 0xE8, 0x9D, 0x91 },
	0xCE65,	{ 0xE8, 0x9D, 0x92 },
	0xCE66,	{ 0xE8, 0x9D, 0x94 },
	0xCE67,	{ 0xE8, 0x9D, 0x95 },
	0xCE68,	{ 0xE8, 0x9D, 0x96 },
	0xCE69,	{ 0xE8, 0x9D, 0x98 },
	0xCE6A,	{ 0xE8, 0x9D, 0x9A },
	0xCE6B,	{ 0xE8, 0x9D, 0x9B },
	0xCE6C,	{ 0xE8, 0x9D, 0x9C },
	0xCE6D,	{ 0xE8, 0x9D, 0x9D },
	0xCE6E,	{ 0xE8, 0x9D, 0x9E },
	0xCE6F,	{ 0xE8, 0x9D, 0x9F },
	0xCE70,	{ 0xE8, 0x9D, 0xA1 },
	0xCE71,	{ 0xE8, 0x9D, 0xA2 },
	0xCE72,	{ 0xE8, 0x9D, 0xA6 },
	0xCE73,	{ 0xE8, 0x9D, 0xA7 },
	0xCE74,	{ 0xE8, 0x9D, 0xA8 },
	0xCE75,	{ 0xE8, 0x9D, 0xA9 },
	0xCE76,	{ 0xE8, 0x9D, 0xAA },
	0xCE77,	{ 0xE8, 0x9D, 0xAB },
	0xCE78,	{ 0xE8, 0x9D, 0xAC },
	0xCE79,	{ 0xE8, 0x9D, 0xAD },
	0xCE7A,	{ 0xE8, 0x9D, 0xAF },
	0xCE7B,	{ 0xE8, 0x9D, 0xB1 },
	0xCE7C,	{ 0xE8, 0x9D, 0xB2 },
	0xCE7D,	{ 0xE8, 0x9D, 0xB3 },
	0xCE7E,	{ 0xE8, 0x9D, 0xB5 },
	0xCE80,	{ 0xE8, 0x9D, 0xB7 },
	0xCE81,	{ 0xE8, 0x9D, 0xB8 },
	0xCE82,	{ 0xE8, 0x9D, 0xB9 },
	0xCE83,	{ 0xE8, 0x9D, 0xBA },
	0xCE84,	{ 0xE8, 0x9D, 0xBF },
	0xCE85,	{ 0xE8, 0x9E, 0x80 },
	0xCE86,	{ 0xE8, 0x9E, 0x81 },
	0xCE87,	{ 0xE8, 0x9E, 0x84 },
	0xCE88,	{ 0xE8, 0x9E, 0x86 },
	0xCE89,	{ 0xE8, 0x9E, 0x87 },
	0xCE8A,	{ 0xE8, 0x9E, 0x89 },
	0xCE8B,	{ 0xE8, 0x9E, 0x8A },
	0xCE8C,	{ 0xE8, 0x9E, 0x8C },
	0xCE8D,	{ 0xE8, 0x9E, 0x8E },
	0xCE8E,	{ 0xE8, 0x9E, 0x8F },
	0xCE8F,	{ 0xE8, 0x9E, 0x90 },
	0xCE90,	{ 0xE8, 0x9E, 0x91 },
	0xCE91,	{ 0xE8, 0x9E, 0x92 },
	0xCE92,	{ 0xE8, 0x9E, 0x94 },
	0xCE93,	{ 0xE8, 0x9E, 0x95 },
	0xCE94,	{ 0xE8, 0x9E, 0x96 },
	0xCE95,	{ 0xE8, 0x9E, 0x98 },
	0xCE96,	{ 0xE8, 0x9E, 0x99 },
	0xCE97,	{ 0xE8, 0x9E, 0x9A },
	0xCE98,	{ 0xE8, 0x9E, 0x9B },
	0xCE99,	{ 0xE8, 0x9E, 0x9C },
	0xCE9A,	{ 0xE8, 0x9E, 0x9D },
	0xCE9B,	{ 0xE8, 0x9E, 0x9E },
	0xCE9C,	{ 0xE8, 0x9E, 0xA0 },
	0xCE9D,	{ 0xE8, 0x9E, 0xA1 },
	0xCE9E,	{ 0xE8, 0x9E, 0xA2 },
	0xCE9F,	{ 0xE8, 0x9E, 0xA3 },
	0xCEA0,	{ 0xE8, 0x9E, 0xA4 },
	0xCEA1,	{ 0xE5, 0xB7, 0x8D },
	0xCEA2,	{ 0xE5, 0xBE, 0xAE },
	0xCEA3,	{ 0xE5, 0x8D, 0xB1 },
	0xCEA4,	{ 0xE9, 0x9F, 0xA6 },
	0xCEA5,	{ 0xE8, 0xBF, 0x9D },
	0xCEA6,	{ 0xE6, 0xA1, 0x85 },
	0xCEA7,	{ 0xE5, 0x9B, 0xB4 },
	0xCEA8,	{ 0xE5, 0x94, 0xAF },
	0xCEA9,	{ 0xE6, 0x83, 0x9F },
	0xCEAA,	{ 0xE4, 0xB8, 0xBA },
	0xCEAB,	{ 0xE6, 0xBD, 0x8D },
	0xCEAC,	{ 0xE7, 0xBB, 0xB4 },
	0xCEAD,	{ 0xE8, 0x8B, 0x87 },
	0xCEAE,	{ 0xE8, 0x90, 0x8E },
	0xCEAF,	{ 0xE5, 0xA7, 0x94 },
	0xCEB0,	{ 0xE4, 0xBC, 0x9F },
	0xCEB1,	{ 0xE4, 0xBC, 0xAA },
	0xCEB2,	{ 0xE5, 0xB0, 0xBE },
	0xCEB3,	{ 0xE7, 0xBA, 0xAC },
	0xCEB4,	{ 0xE6, 0x9C, 0xAA },
	0xCEB5,	{ 0xE8, 0x94, 0x9A },
	0xCEB6,	{ 0xE5, 0x91, 0xB3 },
	0xCEB7,	{ 0xE7, 0x95, 0x8F },
	0xCEB8,	{ 0xE8, 0x83, 0x83 },
	0xCEB9,	{ 0xE5, 0x96, 0x82 },
	0xCEBA,	{ 0xE9, 0xAD, 0x8F },
	0xCEBB,	{ 0xE4, 0xBD, 0x8D },
	0xCEBC,	{ 0xE6, 0xB8, 0xAD },
	0xCEBD,	{ 0xE8, 0xB0, 0x93 },
	0xCEBE,	{ 0xE5, 0xB0, 0x89 },
	0xCEBF,	{ 0xE6, 0x85, 0xB0 },
	0xCEC0,	{ 0xE5, 0x8D, 0xAB },
	0xCEC1,	{ 0xE7, 0x98, 0x9F },
	0xCEC2,	{ 0xE6, 0xB8, 0xA9 },
	0xCEC3,	{ 0xE8, 0x9A, 0x8A },
	0xCEC4,	{ 0xE6, 0x96, 0x87 },
	0xCEC5,	{ 0xE9, 0x97, 0xBB },
	0xCEC6,	{ 0xE7, 0xBA, 0xB9 },
	0xCEC7,	{ 0xE5, 0x90, 0xBB },
	0xCEC8,	{ 0xE7, 0xA8, 0xB3 },
	0xCEC9,	{ 0xE7, 0xB4, 0x8A },
	0xCECA,	{ 0xE9, 0x97, 0xAE },
	0xCECB,	{ 0xE5, 0x97, 0xA1 },
	0xCECC,	{ 0xE7, 0xBF, 0x81 },
	0xCECD,	{ 0xE7, 0x93, 0xAE },
	0xCECE,	{ 0xE6, 0x8C, 0x9D },
	0xCECF,	{ 0xE8, 0x9C, 0x97 },
	0xCED0,	{ 0xE6, 0xB6, 0xA1 },
	0xCED1,	{ 0xE7, 0xAA, 0x9D },
	0xCED2,	{ 0xE6, 0x88, 0x91 },
	0xCED3,	{ 0xE6, 0x96, 0xA1 },
	0xCED4,	{ 0xE5, 0x8D, 0xA7 },
	0xCED5,	{ 0xE6, 0x8F, 0xA1 },
	0xCED6,	{ 0xE6, 0xB2, 0x83 },
	0xCED7,	{ 0xE5, 0xB7, 0xAB },
	0xCED8,	{ 0xE5, 0x91, 0x9C },
	0xCED9,	{ 0xE9, 0x92, 0xA8 },
	0xCEDA,	{ 0xE4, 0xB9, 0x8C },
	0xCEDB,	{ 0xE6, 0xB1, 0xA1 },
	0xCEDC,	{ 0xE8, 0xAF, 0xAC },
	0xCEDD,	{ 0xE5, 0xB1, 0x8B },
	0xCEDE,	{ 0xE6, 0x97, 0xA0 },
	0xCEDF,	{ 0xE8, 0x8A, 0x9C },
	0xCEE0,	{ 0xE6, 0xA2, 0xA7 },
	0xCEE1,	{ 0xE5, 0x90, 0xBE },
	0xCEE2,	{ 0xE5, 0x90, 0xB4 },
	0xCEE3,	{ 0xE6, 0xAF, 0x8B },
	0xCEE4,	{ 0xE6, 0xAD, 0xA6 },
	0xCEE5,	{ 0xE4, 0xBA, 0x94 },
	0xCEE6,	{ 0xE6, 0x8D, 0x82 },
	0xCEE7,	{ 0xE5, 0x8D, 0x88 },
	0xCEE8,	{ 0xE8, 0x88, 0x9E },
	0xCEE9,	{ 0xE4, 0xBC, 0x8D },
	0xCEEA,	{ 0xE4, 0xBE, 0xAE },
	0xCEEB,	{ 0xE5, 0x9D, 0x9E },
	0xCEEC,	{ 0xE6, 0x88, 0x8A },
	0xCEED,	{ 0xE9, 0x9B, 0xBE },
	0xCEEE,	{ 0xE6, 0x99, 0xA4 },
	0xCEEF,	{ 0xE7, 0x89, 0xA9 },
	0xCEF0,	{ 0xE5, 0x8B, 0xBF },
	0xCEF1,	{ 0xE5, 0x8A, 0xA1 },
	0xCEF2,	{ 0xE6, 0x82, 0x9F },
	0xCEF3,	{ 0xE8, 0xAF, 0xAF },
	0xCEF4,	{ 0xE6, 0x98, 0x94 },
	0xCEF5,	{ 0xE7, 0x86, 0x99 },
	0xCEF6,	{ 0xE6, 0x9E, 0x90 },
	0xCEF7,	{ 0xE8, 0xA5, 0xBF },
	0xCEF8,	{ 0xE7, 0xA1, 0x92 },
	0xCEF9,	{ 0xE7, 0x9F, 0xBD },
	0xCEFA,	{ 0xE6, 0x99, 0xB0 },
	0xCEFB,	{ 0xE5, 0x98, 0xBB },
	0xCEFC,	{ 0xE5, 0x90, 0xB8 },
	0xCEFD,	{ 0xE9, 0x94, 0xA1 },
	0xCEFE,	{ 0xE7, 0x89, 0xBA },
	0xCF40,	{ 0xE8, 0x9E, 0xA5 },
	0xCF41,	{ 0xE8, 0x9E, 0xA6 },
	0xCF42,	{ 0xE8, 0x9E, 0xA7 },
	0xCF43,	{ 0xE8, 0x9E, 0xA9 },
	0xCF44,	{ 0xE8, 0x9E, 0xAA },
	0xCF45,	{ 0xE8, 0x9E, 0xAE },
	0xCF46,	{ 0xE8, 0x9E, 0xB0 },
	0xCF47,	{ 0xE8, 0x9E, 0xB1 },
	0xCF48,	{ 0xE8, 0x9E, 0xB2 },
	0xCF49,	{ 0xE8, 0x9E, 0xB4 },
	0xCF4A,	{ 0xE8, 0x9E, 0xB6 },
	0xCF4B,	{ 0xE8, 0x9E, 0xB7 },
	0xCF4C,	{ 0xE8, 0x9E, 0xB8 },
	0xCF4D,	{ 0xE8, 0x9E, 0xB9 },
	0xCF4E,	{ 0xE8, 0x9E, 0xBB },
	0xCF4F,	{ 0xE8, 0x9E, 0xBC },
	0xCF50,	{ 0xE8, 0x9E, 0xBE },
	0xCF51,	{ 0xE8, 0x9E, 0xBF },
	0xCF52,	{ 0xE8, 0x9F, 0x81 },
	0xCF53,	{ 0xE8, 0x9F, 0x82 },
	0xCF54,	{ 0xE8, 0x9F, 0x83 },
	0xCF55,	{ 0xE8, 0x9F, 0x84 },
	0xCF56,	{ 0xE8, 0x9F, 0x85 },
	0xCF57,	{ 0xE8, 0x9F, 0x87 },
	0xCF58,	{ 0xE8, 0x9F, 0x88 },
	0xCF59,	{ 0xE8, 0x9F, 0x89 },
	0xCF5A,	{ 0xE8, 0x9F, 0x8C },
	0xCF5B,	{ 0xE8, 0x9F, 0x8D },
	0xCF5C,	{ 0xE8, 0x9F, 0x8E },
	0xCF5D,	{ 0xE8, 0x9F, 0x8F },
	0xCF5E,	{ 0xE8, 0x9F, 0x90 },
	0xCF5F,	{ 0xE8, 0x9F, 0x94 },
	0xCF60,	{ 0xE8, 0x9F, 0x95 },
	0xCF61,	{ 0xE8, 0x9F, 0x96 },
	0xCF62,	{ 0xE8, 0x9F, 0x97 },
	0xCF63,	{ 0xE8, 0x9F, 0x98 },
	0xCF64,	{ 0xE8, 0x9F, 0x99 },
	0xCF65,	{ 0xE8, 0x9F, 0x9A },
	0xCF66,	{ 0xE8, 0x9F, 0x9C },
	0xCF67,	{ 0xE8, 0x9F, 0x9D },
	0xCF68,	{ 0xE8, 0x9F, 0x9E },
	0xCF69,	{ 0xE8, 0x9F, 0x9F },
	0xCF6A,	{ 0xE8, 0x9F, 0xA1 },
	0xCF6B,	{ 0xE8, 0x9F, 0xA2 },
	0xCF6C,	{ 0xE8, 0x9F, 0xA3 },
	0xCF6D,	{ 0xE8, 0x9F, 0xA4 },
	0xCF6E,	{ 0xE8, 0x9F, 0xA6 },
	0xCF6F,	{ 0xE8, 0x9F, 0xA7 },
	0xCF70,	{ 0xE8, 0x9F, 0xA8 },
	0xCF71,	{ 0xE8, 0x9F, 0xA9 },
	0xCF72,	{ 0xE8, 0x9F, 0xAB },
	0xCF73,	{ 0xE8, 0x9F, 0xAC },
	0xCF74,	{ 0xE8, 0x9F, 0xAD },
	0xCF75,	{ 0xE8, 0x9F, 0xAF },
	0xCF76,	{ 0xE8, 0x9F, 0xB0 },
	0xCF77,	{ 0xE8, 0x9F, 0xB1 },
	0xCF78,	{ 0xE8, 0x9F, 0xB2 },
	0xCF79,	{ 0xE8, 0x9F, 0xB3 },
	0xCF7A,	{ 0xE8, 0x9F, 0xB4 },
	0xCF7B,	{ 0xE8, 0x9F, 0xB5 },
	0xCF7C,	{ 0xE8, 0x9F, 0xB6 },
	0xCF7D,	{ 0xE8, 0x9F, 0xB7 },
	0xCF7E,	{ 0xE8, 0x9F, 0xB8 },
	0xCF80,	{ 0xE8, 0x9F, 0xBA },
	0xCF81,	{ 0xE8, 0x9F, 0xBB },
	0xCF82,	{ 0xE8, 0x9F, 0xBC },
	0xCF83,	{ 0xE8, 0x9F, 0xBD },
	0xCF84,	{ 0xE8, 0x9F, 0xBF },
	0xCF85,	{ 0xE8, 0xA0, 0x80 },
	0xCF86,	{ 0xE8, 0xA0, 0x81 },
	0xCF87,	{ 0xE8, 0xA0, 0x82 },
	0xCF88,	{ 0xE8, 0xA0, 0x84 },
	0xCF89,	{ 0xE8, 0xA0, 0x85 },
	0xCF8A,	{ 0xE8, 0xA0, 0x86 },
	0xCF8B,	{ 0xE8, 0xA0, 0x87 },
	0xCF8C,	{ 0xE8, 0xA0, 0x88 },
	0xCF8D,	{ 0xE8, 0xA0, 0x89 },
	0xCF8E,	{ 0xE8, 0xA0, 0x8B },
	0xCF8F,	{ 0xE8, 0xA0, 0x8C },
	0xCF90,	{ 0xE8, 0xA0, 0x8D },
	0xCF91,	{ 0xE8, 0xA0, 0x8E },
	0xCF92,	{ 0xE8, 0xA0, 0x8F },
	0xCF93,	{ 0xE8, 0xA0, 0x90 },
	0xCF94,	{ 0xE8, 0xA0, 0x91 },
	0xCF95,	{ 0xE8, 0xA0, 0x92 },
	0xCF96,	{ 0xE8, 0xA0, 0x94 },
	0xCF97,	{ 0xE8, 0xA0, 0x97 },
	0xCF98,	{ 0xE8, 0xA0, 0x98 },
	0xCF99,	{ 0xE8, 0xA0, 0x99 },
	0xCF9A,	{ 0xE8, 0xA0, 0x9A },
	0xCF9B,	{ 0xE8, 0xA0, 0x9C },
	0xCF9C,	{ 0xE8, 0xA0, 0x9D },
	0xCF9D,	{ 0xE8, 0xA0, 0x9E },
	0xCF9E,	{ 0xE8, 0xA0, 0x9F },
	0xCF9F,	{ 0xE8, 0xA0, 0xA0 },
	0xCFA0,	{ 0xE8, 0xA0, 0xA3 },
	0xCFA1,	{ 0xE7, 0xA8, 0x80 },
	0xCFA2,	{ 0xE6, 0x81, 0xAF },
	0xCFA3,	{ 0xE5, 0xB8, 0x8C },
	0xCFA4,	{ 0xE6, 0x82, 0x89 },
	0xCFA5,	{ 0xE8, 0x86, 0x9D },
	0xCFA6,	{ 0xE5, 0xA4, 0x95 },
	0xCFA7,	{ 0xE6, 0x83, 0x9C },
	0xCFA8,	{ 0xE7, 0x86, 0x84 },
	0xCFA9,	{ 0xE7, 0x83, 0xAF },
	0xCFAA,	{ 0xE6, 0xBA, 0xAA },
	0xCFAB,	{ 0xE6, 0xB1, 0x90 },
	0xCFAC,	{ 0xE7, 0x8A, 0x80 },
	0xCFAD,	{ 0xE6, 0xAA, 0x84 },
	0xCFAE,	{ 0xE8, 0xA2, 0xAD },
	0xCFAF,	{ 0xE5, 0xB8, 0xAD },
	0xCFB0,	{ 0xE4, 0xB9, 0xA0 },
	0xCFB1,	{ 0xE5, 0xAA, 0xB3 },
	0xCFB2,	{ 0xE5, 0x96, 0x9C },
	0xCFB3,	{ 0xE9, 0x93, 0xA3 },
	0xCFB4,	{ 0xE6, 0xB4, 0x97 },
	0xCFB5,	{ 0xE7, 0xB3, 0xBB },
	0xCFB6,	{ 0xE9, 0x9A, 0x99 },
	0xCFB7,	{ 0xE6, 0x88, 0x8F },
	0xCFB8,	{ 0xE7, 0xBB, 0x86 },
	0xCFB9,	{ 0xE7, 0x9E, 0x8E },
	0xCFBA,	{ 0xE8, 0x99, 0xBE },
	0xCFBB,	{ 0xE5, 0x8C, 0xA3 },
	0xCFBC,	{ 0xE9, 0x9C, 0x9E },
	0xCFBD,	{ 0xE8, 0xBE, 0x96 },
	0xCFBE,	{ 0xE6, 0x9A, 0x87 },
	0xCFBF,	{ 0xE5, 0xB3, 0xA1 },
	0xCFC0,	{ 0xE4, 0xBE, 0xA0 },
	0xCFC1,	{ 0xE7, 0x8B, 0xAD },
	0xCFC2,	{ 0xE4, 0xB8, 0x8B },
	0xCFC3,	{ 0xE5, 0x8E, 0xA6 },
	0xCFC4,	{ 0xE5, 0xA4, 0x8F },
	0xCFC5,	{ 0xE5, 0x90, 0x93 },
	0xCFC6,	{ 0xE6, 0x8E, 0x80 },
	0xCFC7,	{ 0xE9, 0x94, 0xA8 },
	0xCFC8,	{ 0xE5, 0x85, 0x88 },
	0xCFC9,	{ 0xE4, 0xBB, 0x99 },
	0xCFCA,	{ 0xE9, 0xB2, 0x9C },
	0xCFCB,	{ 0xE7, 0xBA, 0xA4 },
	0xCFCC,	{ 0xE5, 0x92, 0xB8 },
	0xCFCD,	{ 0xE8, 0xB4, 0xA4 },
	0xCFCE,	{ 0xE8, 0xA1, 0x94 },
	0xCFCF,	{ 0xE8, 0x88, 0xB7 },
	0xCFD0,	{ 0xE9, 0x97, 0xB2 },
	0xCFD1,	{ 0xE6, 0xB6, 0x8E },
	0xCFD2,	{ 0xE5, 0xBC, 0xA6 },
	0xCFD3,	{ 0xE5, 0xAB, 0x8C },
	0xCFD4,	{ 0xE6, 0x98, 0xBE },
	0xCFD5,	{ 0xE9, 0x99, 0xA9 },
	0xCFD6,	{ 0xE7, 0x8E, 0xB0 },
	0xCFD7,	{ 0xE7, 0x8C, 0xAE },
	0xCFD8,	{ 0xE5, 0x8E, 0xBF },
	0xCFD9,	{ 0xE8, 0x85, 0xBA },
	0xCFDA,	{ 0xE9, 0xA6, 0x85 },
	0xCFDB,	{ 0xE7, 0xBE, 0xA1 },
	0xCFDC,	{ 0xE5, 0xAE, 0xAA },
	0xCFDD,	{ 0xE9, 0x99, 0xB7 },
	0xCFDE,	{ 0xE9, 0x99, 0x90 },
	0xCFDF,	{ 0xE7, 0xBA, 0xBF },
	0xCFE0,	{ 0xE7, 0x9B, 0xB8 },
	0xCFE1,	{ 0xE5, 0x8E, 0xA2 },
	0xCFE2,	{ 0xE9, 0x95, 0xB6 },
	0xCFE3,	{ 0xE9, 0xA6, 0x99 },
	0xCFE4,	{ 0xE7, 0xAE, 0xB1 },
	0xCFE5,	{ 0xE8, 0xA5, 0x84 },
	0xCFE6,	{ 0xE6, 0xB9, 0x98 },
	0xCFE7,	{ 0xE4, 0xB9, 0xA1 },
	0xCFE8,	{ 0xE7, 0xBF, 0x94 },
	0xCFE9,	{ 0xE7, 0xA5, 0xA5 },
	0xCFEA,	{ 0xE8, 0xAF, 0xA6 },
	0xCFEB,	{ 0xE6, 0x83, 0xB3 },
	0xCFEC,	{ 0xE5, 0x93, 0x8D },
	0xCFED,	{ 0xE4, 0xBA, 0xAB },
	0xCFEE,	{ 0xE9, 0xA1, 0xB9 },
	0xCFEF,	{ 0xE5, 0xB7, 0xB7 },
	0xCFF0,	{ 0xE6, 0xA9, 0xA1 },
	0xCFF1,	{ 0xE5, 0x83, 0x8F },
	0xCFF2,	{ 0xE5, 0x90, 0x91 },
	0xCFF3,	{ 0xE8, 0xB1, 0xA1 },
	0xCFF4,	{ 0xE8, 0x90, 0xA7 },
	0xCFF5,	{ 0xE7, 0xA1, 0x9D },
	0xCFF6,	{ 0xE9, 0x9C, 0x84 },
	0xCFF7,	{ 0xE5, 0x89, 0x8A },
	0xCFF8,	{ 0xE5, 0x93, 0xAE },
	0xCFF9,	{ 0xE5, 0x9A, 0xA3 },
	0xCFFA,	{ 0xE9, 0x94, 0x80 },
	0xCFFB,	{ 0xE6, 0xB6, 0x88 },
	0xCFFC,	{ 0xE5, 0xAE, 0xB5 },
	0xCFFD,	{ 0xE6, 0xB7, 0x86 },
	0xCFFE,	{ 0xE6, 0x99, 0x93 },
	0xD040,	{ 0xE8, 0xA0, 0xA4 },
	0xD041,	{ 0xE8, 0xA0, 0xA5 },
	0xD042,	{ 0xE8, 0xA0, 0xA6 },
	0xD043,	{ 0xE8, 0xA0, 0xA7 },
	0xD044,	{ 0xE8, 0xA0, 0xA8 },
	0xD045,	{ 0xE8, 0xA0, 0xA9 },
	0xD046,	{ 0xE8, 0xA0, 0xAA },
	0xD047,	{ 0xE8, 0xA0, 0xAB },
	0xD048,	{ 0xE8, 0xA0, 0xAC },
	0xD049,	{ 0xE8, 0xA0, 0xAD },
	0xD04A,	{ 0xE8, 0xA0, 0xAE },
	0xD04B,	{ 0xE8, 0xA0, 0xAF },
	0xD04C,	{ 0xE8, 0xA0, 0xB0 },
	0xD04D,	{ 0xE8, 0xA0, 0xB1 },
	0xD04E,	{ 0xE8, 0xA0, 0xB3 },
	0xD04F,	{ 0xE8, 0xA0, 0xB4 },
	0xD050,	{ 0xE8, 0xA0, 0xB5 },
	0xD051,	{ 0xE8, 0xA0, 0xB6 },
	0xD052,	{ 0xE8, 0xA0, 0xB7 },
	0xD053,	{ 0xE8, 0xA0, 0xB8 },
	0xD054,	{ 0xE8, 0xA0, 0xBA },
	0xD055,	{ 0xE8, 0xA0, 0xBB },
	0xD056,	{ 0xE8, 0xA0, 0xBD },
	0xD057,	{ 0xE8, 0xA0, 0xBE },
	0xD058,	{ 0xE8, 0xA0, 0xBF },
	0xD059,	{ 0xE8, 0xA1, 0x81 },
	0xD05A,	{ 0xE8, 0xA1, 0x82 },
	0xD05B,	{ 0xE8, 0xA1, 0x83 },
	0xD05C,	{ 0xE8, 0xA1, 0x86 },
	0xD05D,	{ 0xE8, 0xA1, 0x87 },
	0xD05E,	{ 0xE8, 0xA1, 0x88 },
	0xD05F,	{ 0xE8, 0xA1, 0x89 },
	0xD060,	{ 0xE8, 0xA1, 0x8A },
	0xD061,	{ 0xE8, 0xA1, 0x8B },
	0xD062,	{ 0xE8, 0xA1, 0x8E },
	0xD063,	{ 0xE8, 0xA1, 0x8F },
	0xD064,	{ 0xE8, 0xA1, 0x90 },
	0xD065,	{ 0xE8, 0xA1, 0x91 },
	0xD066,	{ 0xE8, 0xA1, 0x92 },
	0xD067,	{ 0xE8, 0xA1, 0x93 },
	0xD068,	{ 0xE8, 0xA1, 0x95 },
	0xD069,	{ 0xE8, 0xA1, 0x96 },
	0xD06A,	{ 0xE8, 0xA1, 0x98 },
	0xD06B,	{ 0xE8, 0xA1, 0x9A },
	0xD06C,	{ 0xE8, 0xA1, 0x9B },
	0xD06D,	{ 0xE8, 0xA1, 0x9C },
	0xD06E,	{ 0xE8, 0xA1, 0x9D },
	0xD06F,	{ 0xE8, 0xA1, 0x9E },
	0xD070,	{ 0xE8, 0xA1, 0x9F },
	0xD071,	{ 0xE8, 0xA1, 0xA0 },
	0xD072,	{ 0xE8, 0xA1, 0xA6 },
	0xD073,	{ 0xE8, 0xA1, 0xA7 },
	0xD074,	{ 0xE8, 0xA1, 0xAA },
	0xD075,	{ 0xE8, 0xA1, 0xAD },
	0xD076,	{ 0xE8, 0xA1, 0xAF },
	0xD077,	{ 0xE8, 0xA1, 0xB1 },
	0xD078,	{ 0xE8, 0xA1, 0xB3 },
	0xD079,	{ 0xE8, 0xA1, 0xB4 },
	0xD07A,	{ 0xE8, 0xA1, 0xB5 },
	0xD07B,	{ 0xE8, 0xA1, 0xB6 },
	0xD07C,	{ 0xE8, 0xA1, 0xB8 },
	0xD07D,	{ 0xE8, 0xA1, 0xB9 },
	0xD07E,	{ 0xE8, 0xA1, 0xBA },
	0xD080,	{ 0xE8, 0xA1, 0xBB },
	0xD081,	{ 0xE8, 0xA1, 0xBC },
	0xD082,	{ 0xE8, 0xA2, 0x80 },
	0xD083,	{ 0xE8, 0xA2, 0x83 },
	0xD084,	{ 0xE8, 0xA2, 0x86 },
	0xD085,	{ 0xE8, 0xA2, 0x87 },
	0xD086,	{ 0xE8, 0xA2, 0x89 },
	0xD087,	{ 0xE8, 0xA2, 0x8A },
	0xD088,	{ 0xE8, 0xA2, 0x8C },
	0xD089,	{ 0xE8, 0xA2, 0x8E },
	0xD08A,	{ 0xE8, 0xA2, 0x8F },
	0xD08B,	{ 0xE8, 0xA2, 0x90 },
	0xD08C,	{ 0xE8, 0xA2, 0x91 },
	0xD08D,	{ 0xE8, 0xA2, 0x93 },
	0xD08E,	{ 0xE8, 0xA2, 0x94 },
	0xD08F,	{ 0xE8, 0xA2, 0x95 },
	0xD090,	{ 0xE8, 0xA2, 0x97 },
	0xD091,	{ 0xE8, 0xA2, 0x98 },
	0xD092,	{ 0xE8, 0xA2, 0x99 },
	0xD093,	{ 0xE8, 0xA2, 0x9A },
	0xD094,	{ 0xE8, 0xA2, 0x9B },
	0xD095,	{ 0xE8, 0xA2, 0x9D },
	0xD096,	{ 0xE8, 0xA2, 0x9E },
	0xD097,	{ 0xE8, 0xA2, 0x9F },
	0xD098,	{ 0xE8, 0xA2, 0xA0 },
	0xD099,	{ 0xE8, 0xA2, 0xA1 },
	0xD09A,	{ 0xE8, 0xA2, 0xA3 },
	0xD09B,	{ 0xE8, 0xA2, 0xA5 },
	0xD09C,	{ 0xE8, 0xA2, 0xA6 },
	0xD09D,	{ 0xE8, 0xA2, 0xA7 },
	0xD09E,	{ 0xE8, 0xA2, 0xA8 },
	0xD09F,	{ 0xE8, 0xA2, 0xA9 },
	0xD0A0,	{ 0xE8, 0xA2, 0xAA },
	0xD0A1,	{ 0xE5, 0xB0, 0x8F },
	0xD0A2,	{ 0xE5, 0xAD, 0x9D },
	0xD0A3,	{ 0xE6, 0xA0, 0xA1 },
	0xD0A4,	{ 0xE8, 0x82, 0x96 },
	0xD0A5,	{ 0xE5, 0x95, 0xB8 },
	0xD0A6,	{ 0xE7, 0xAC, 0x91 },
	0xD0A7,	{ 0xE6, 0x95, 0x88 },
	0xD0A8,	{ 0xE6, 0xA5, 0x94 },
	0xD0A9,	{ 0xE4, 0xBA, 0x9B },
	0xD0AA,	{ 0xE6, 0xAD, 0x87 },
	0xD0AB,	{ 0xE8, 0x9D, 0x8E },
	0xD0AC,	{ 0xE9, 0x9E, 0x8B },
	0xD0AD,	{ 0xE5, 0x8D, 0x8F },
	0xD0AE,	{ 0xE6, 0x8C, 0x9F },
	0xD0AF,	{ 0xE6, 0x90, 0xBA },
	0xD0B0,	{ 0xE9, 0x82, 0xAA },
	0xD0B1,	{ 0xE6, 0x96, 0x9C },
	0xD0B2,	{ 0xE8, 0x83, 0x81 },
	0xD0B3,	{ 0xE8, 0xB0, 0x90 },
	0xD0B4,	{ 0xE5, 0x86, 0x99 },
	0xD0B5,	{ 0xE6, 0xA2, 0xB0 },
	0xD0B6,	{ 0xE5, 0x8D, 0xB8 },
	0xD0B7,	{ 0xE8, 0x9F, 0xB9 },
	0xD0B8,	{ 0xE6, 0x87, 0x88 },
	0xD0B9,	{ 0xE6, 0xB3, 0x84 },
	0xD0BA,	{ 0xE6, 0xB3, 0xBB },
	0xD0BB,	{ 0xE8, 0xB0, 0xA2 },
	0xD0BC,	{ 0xE5, 0xB1, 0x91 },
	0xD0BD,	{ 0xE8, 0x96, 0xAA },
	0xD0BE,	{ 0xE8, 0x8A, 0xAF },
	0xD0BF,	{ 0xE9, 0x94, 0x8C },
	0xD0C0,	{ 0xE6, 0xAC, 0xA3 },
	0xD0C1,	{ 0xE8, 0xBE, 0x9B },
	0xD0C2,	{ 0xE6, 0x96, 0xB0 },
	0xD0C3,	{ 0xE5, 0xBF, 0xBB },
	0xD0C4,	{ 0xE5, 0xBF, 0x83 },
	0xD0C5,	{ 0xE4, 0xBF, 0xA1 },
	0xD0C6,	{ 0xE8, 0xA1, 0x85 },
	0xD0C7,	{ 0xE6, 0x98, 0x9F },
	0xD0C8,	{ 0xE8, 0x85, 0xA5 },
	0xD0C9,	{ 0xE7, 0x8C, 0xA9 },
	0xD0CA,	{ 0xE6, 0x83, 0xBA },
	0xD0CB,	{ 0xE5, 0x85, 0xB4 },
	0xD0CC,	{ 0xE5, 0x88, 0x91 },
	0xD0CD,	{ 0xE5, 0x9E, 0x8B },
	0xD0CE,	{ 0xE5, 0xBD, 0xA2 },
	0xD0CF,	{ 0xE9, 0x82, 0xA2 },
	0xD0D0,	{ 0xE8, 0xA1, 0x8C },
	0xD0D1,	{ 0xE9, 0x86, 0x92 },
	0xD0D2,	{ 0xE5, 0xB9, 0xB8 },
	0xD0D3,	{ 0xE6, 0x9D, 0x8F },
	0xD0D4,	{ 0xE6, 0x80, 0xA7 },
	0xD0D5,	{ 0xE5, 0xA7, 0x93 },
	0xD0D6,	{ 0xE5, 0x85, 0x84 },
	0xD0D7,	{ 0xE5, 0x87, 0xB6 },
	0xD0D8,	{ 0xE8, 0x83, 0xB8 },
	0xD0D9,	{ 0xE5, 0x8C, 0x88 },
	0xD0DA,	{ 0xE6, 0xB1, 0xB9 },
	0xD0DB,	{ 0xE9, 0x9B, 0x84 },
	0xD0DC,	{ 0xE7, 0x86, 0x8A },
	0xD0DD,	{ 0xE4, 0xBC, 0x91 },
	0xD0DE,	{ 0xE4, 0xBF, 0xAE },
	0xD0DF,	{ 0xE7, 0xBE, 0x9E },
	0xD0E0,	{ 0xE6, 0x9C, 0xBD },
	0xD0E1,	{ 0xE5, 0x97, 0x85 },
	0xD0E2,	{ 0xE9, 0x94, 0x88 },
	0xD0E3,	{ 0xE7, 0xA7, 0x80 },
	0xD0E4,	{ 0xE8, 0xA2, 0x96 },
	0xD0E5,	{ 0xE7, 0xBB, 0xA3 },
	0xD0E6,	{ 0xE5, 0xA2, 0x9F },
	0xD0E7,	{ 0xE6, 0x88, 0x8C },
	0xD0E8,	{ 0xE9, 0x9C, 0x80 },
	0xD0E9,	{ 0xE8, 0x99, 0x9A },
	0xD0EA,	{ 0xE5, 0x98, 0x98 },
	0xD0EB,	{ 0xE9, 0xA1, 0xBB },
	0xD0EC,	{ 0xE5, 0xBE, 0x90 },
	0xD0ED,	{ 0xE8, 0xAE, 0xB8 },
	0xD0EE,	{ 0xE8, 0x93, 0x84 },
	0xD0EF,	{ 0xE9, 0x85, 0x97 },
	0xD0F0,	{ 0xE5, 0x8F, 0x99 },
	0xD0F1,	{ 0xE6, 0x97, 0xAD },
	0xD0F2,	{ 0xE5, 0xBA, 0x8F },
	0xD0F3,	{ 0xE7, 0x95, 0x9C },
	0xD0F4,	{ 0xE6, 0x81, 0xA4 },
	0xD0F5,	{ 0xE7, 0xB5, 0xAE },
	0xD0F6,	{ 0xE5, 0xA9, 0xBF },
	0xD0F7,	{ 0xE7, 0xBB, 0xAA },
	0xD0F8,	{ 0xE7, 0xBB, 0xAD },
	0xD0F9,	{ 0xE8, 0xBD, 0xA9 },
	0xD0FA,	{ 0xE5, 0x96, 0xA7 },
	0xD0FB,	{ 0xE5, 0xAE, 0xA3 },
	0xD0FC,	{ 0xE6, 0x82, 0xAC },
	0xD0FD,	{ 0xE6, 0x97, 0x8B },
	0xD0FE,	{ 0xE7, 0x8E, 0x84 },
	0xD140,	{ 0xE8, 0xA2, 0xAC },
	0xD141,	{ 0xE8, 0xA2, 0xAE },
	0xD142,	{ 0xE8, 0xA2, 0xAF },
	0xD143,	{ 0xE8, 0xA2, 0xB0 },
	0xD144,	{ 0xE8, 0xA2, 0xB2 },
	0xD145,	{ 0xE8, 0xA2, 0xB3 },
	0xD146,	{ 0xE8, 0xA2, 0xB4 },
	0xD147,	{ 0xE8, 0xA2, 0xB5 },
	0xD148,	{ 0xE8, 0xA2, 0xB6 },
	0xD149,	{ 0xE8, 0xA2, 0xB8 },
	0xD14A,	{ 0xE8, 0xA2, 0xB9 },
	0xD14B,	{ 0xE8, 0xA2, 0xBA },
	0xD14C,	{ 0xE8, 0xA2, 0xBB },
	0xD14D,	{ 0xE8, 0xA2, 0xBD },
	0xD14E,	{ 0xE8, 0xA2, 0xBE },
	0xD14F,	{ 0xE8, 0xA2, 0xBF },
	0xD150,	{ 0xE8, 0xA3, 0x80 },
	0xD151,	{ 0xE8, 0xA3, 0x83 },
	0xD152,	{ 0xE8, 0xA3, 0x84 },
	0xD153,	{ 0xE8, 0xA3, 0x87 },
	0xD154,	{ 0xE8, 0xA3, 0x88 },
	0xD155,	{ 0xE8, 0xA3, 0x8A },
	0xD156,	{ 0xE8, 0xA3, 0x8B },
	0xD157,	{ 0xE8, 0xA3, 0x8C },
	0xD158,	{ 0xE8, 0xA3, 0x8D },
	0xD159,	{ 0xE8, 0xA3, 0x8F },
	0xD15A,	{ 0xE8, 0xA3, 0x90 },
	0xD15B,	{ 0xE8, 0xA3, 0x91 },
	0xD15C,	{ 0xE8, 0xA3, 0x93 },
	0xD15D,	{ 0xE8, 0xA3, 0x96 },
	0xD15E,	{ 0xE8, 0xA3, 0x97 },
	0xD15F,	{ 0xE8, 0xA3, 0x9A },
	0xD160,	{ 0xE8, 0xA3, 0x9B },
	0xD161,	{ 0xE8, 0xA3, 0x9C },
	0xD162,	{ 0xE8, 0xA3, 0x9D },
	0xD163,	{ 0xE8, 0xA3, 0x9E },
	0xD164,	{ 0xE8, 0xA3, 0xA0 },
	0xD165,	{ 0xE8, 0xA3, 0xA1 },
	0xD166,	{ 0xE8, 0xA3, 0xA6 },
	0xD167,	{ 0xE8, 0xA3, 0xA7 },
	0xD168,	{ 0xE8, 0xA3, 0xA9 },
	0xD169,	{ 0xE8, 0xA3, 0xAA },
	0xD16A,	{ 0xE8, 0xA3, 0xAB },
	0xD16B,	{ 0xE8, 0xA3, 0xAC },
	0xD16C,	{ 0xE8, 0xA3, 0xAD },
	0xD16D,	{ 0xE8, 0xA3, 0xAE },
	0xD16E,	{ 0xE8, 0xA3, 0xAF },
	0xD16F,	{ 0xE8, 0xA3, 0xB2 },
	0xD170,	{ 0xE8, 0xA3, 0xB5 },
	0xD171,	{ 0xE8, 0xA3, 0xB6 },
	0xD172,	{ 0xE8, 0xA3, 0xB7 },
	0xD173,	{ 0xE8, 0xA3, 0xBA },
	0xD174,	{ 0xE8, 0xA3, 0xBB },
	0xD175,	{ 0xE8, 0xA3, 0xBD },
	0xD176,	{ 0xE8, 0xA3, 0xBF },
	0xD177,	{ 0xE8, 0xA4, 0x80 },
	0xD178,	{ 0xE8, 0xA4, 0x81 },
	0xD179,	{ 0xE8, 0xA4, 0x83 },
	0xD17A,	{ 0xE8, 0xA4, 0x84 },
	0xD17B,	{ 0xE8, 0xA4, 0x85 },
	0xD17C,	{ 0xE8, 0xA4, 0x86 },
	0xD17D,	{ 0xE8, 0xA4, 0x87 },
	0xD17E,	{ 0xE8, 0xA4, 0x88 },
	0xD180,	{ 0xE8, 0xA4, 0x89 },
	0xD181,	{ 0xE8, 0xA4, 0x8B },
	0xD182,	{ 0xE8, 0xA4, 0x8C },
	0xD183,	{ 0xE8, 0xA4, 0x8D },
	0xD184,	{ 0xE8, 0xA4, 0x8E },
	0xD185,	{ 0xE8, 0xA4, 0x8F },
	0xD186,	{ 0xE8, 0xA4, 0x91 },
	0xD187,	{ 0xE8, 0xA4, 0x94 },
	0xD188,	{ 0xE8, 0xA4, 0x95 },
	0xD189,	{ 0xE8, 0xA4, 0x96 },
	0xD18A,	{ 0xE8, 0xA4, 0x97 },
	0xD18B,	{ 0xE8, 0xA4, 0x98 },
	0xD18C,	{ 0xE8, 0xA4, 0x9C },
	0xD18D,	{ 0xE8, 0xA4, 0x9D },
	0xD18E,	{ 0xE8, 0xA4, 0x9E },
	0xD18F,	{ 0xE8, 0xA4, 0x9F },
	0xD190,	{ 0xE8, 0xA4, 0xA0 },
	0xD191,	{ 0xE8, 0xA4, 0xA2 },
	0xD192,	{ 0xE8, 0xA4, 0xA3 },
	0xD193,	{ 0xE8, 0xA4, 0xA4 },
	0xD194,	{ 0xE8, 0xA4, 0xA6 },
	0xD195,	{ 0xE8, 0xA4, 0xA7 },
	0xD196,	{ 0xE8, 0xA4, 0xA8 },
	0xD197,	{ 0xE8, 0xA4, 0xA9 },
	0xD198,	{ 0xE8, 0xA4, 0xAC },
	0xD199,	{ 0xE8, 0xA4, 0xAD },
	0xD19A,	{ 0xE8, 0xA4, 0xAE },
	0xD19B,	{ 0xE8, 0xA4, 0xAF },
	0xD19C,	{ 0xE8, 0xA4, 0xB1 },
	0xD19D,	{ 0xE8, 0xA4, 0xB2 },
	0xD19E,	{ 0xE8, 0xA4, 0xB3 },
	0xD19F,	{ 0xE8, 0xA4, 0xB5 },
	0xD1A0,	{ 0xE8, 0xA4, 0xB7 },
	0xD1A1,	{ 0xE9, 0x80, 0x89 },
	0xD1A2,	{ 0xE7, 0x99, 0xA3 },
	0xD1A3,	{ 0xE7, 0x9C, 0xA9 },
	0xD1A4,	{ 0xE7, 0xBB, 0x9A },
	0xD1A5,	{ 0xE9, 0x9D, 0xB4 },
	0xD1A6,	{ 0xE8, 0x96, 0x9B },
	0xD1A7,	{ 0xE5, 0xAD, 0xA6 },
	0xD1A8,	{ 0xE7, 0xA9, 0xB4 },
	0xD1A9,	{ 0xE9, 0x9B, 0xAA },
	0xD1AA,	{ 0xE8, 0xA1, 0x80 },
	0xD1AB,	{ 0xE5, 0x8B, 0x8B },
	0xD1AC,	{ 0xE7, 0x86, 0x8F },
	0xD1AD,	{ 0xE5, 0xBE, 0xAA },
	0xD1AE,	{ 0xE6, 0x97, 0xAC },
	0xD1AF,	{ 0xE8, 0xAF, 0xA2 },
	0xD1B0,	{ 0xE5, 0xAF, 0xBB },
	0xD1B1,	{ 0xE9, 0xA9, 0xAF },
	0xD1B2,	{ 0xE5, 0xB7, 0xA1 },
	0xD1B3,	{ 0xE6, 0xAE, 0x89 },
	0xD1B4,	{ 0xE6, 0xB1, 0x9B },
	0xD1B5,	{ 0xE8, 0xAE, 0xAD },
	0xD1B6,	{ 0xE8, 0xAE, 0xAF },
	0xD1B7,	{ 0xE9, 0x80, 0x8A },
	0xD1B8,	{ 0xE8, 0xBF, 0x85 },
	0xD1B9,	{ 0xE5, 0x8E, 0x8B },
	0xD1BA,	{ 0xE6, 0x8A, 0xBC },
	0xD1BB,	{ 0xE9, 0xB8, 0xA6 },
	0xD1BC,	{ 0xE9, 0xB8, 0xAD },
	0xD1BD,	{ 0xE5, 0x91, 0x80 },
	0xD1BE,	{ 0xE4, 0xB8, 0xAB },
	0xD1BF,	{ 0xE8, 0x8A, 0xBD },
	0xD1C0,	{ 0xE7, 0x89, 0x99 },
	0xD1C1,	{ 0xE8, 0x9A, 0x9C },
	0xD1C2,	{ 0xE5, 0xB4, 0x96 },
	0xD1C3,	{ 0xE8, 0xA1, 0x99 },
	0xD1C4,	{ 0xE6, 0xB6, 0xAF },
	0xD1C5,	{ 0xE9, 0x9B, 0x85 },
	0xD1C6,	{ 0xE5, 0x93, 0x91 },
	0xD1C7,	{ 0xE4, 0xBA, 0x9A },
	0xD1C8,	{ 0xE8, 0xAE, 0xB6 },
	0xD1C9,	{ 0xE7, 0x84, 0x89 },
	0xD1CA,	{ 0xE5, 0x92, 0xBD },
	0xD1CB,	{ 0xE9, 0x98, 0x89 },
	0xD1CC,	{ 0xE7, 0x83, 0x9F },
	0xD1CD,	{ 0xE6, 0xB7, 0xB9 },
	0xD1CE,	{ 0xE7, 0x9B, 0x90 },
	0xD1CF,	{ 0xE4, 0xB8, 0xA5 },
	0xD1D0,	{ 0xE7, 0xA0, 0x94 },
	0xD1D1,	{ 0xE8, 0x9C, 0x92 },
	0xD1D2,	{ 0xE5, 0xB2, 0xA9 },
	0xD1D3,	{ 0xE5, 0xBB, 0xB6 },
	0xD1D4,	{ 0xE8, 0xA8, 0x80 },
	0xD1D5,	{ 0xE9, 0xA2, 0x9C },
	0xD1D6,	{ 0xE9, 0x98, 0x8E },
	0xD1D7,	{ 0xE7, 0x82, 0x8E },
	0xD1D8,	{ 0xE6, 0xB2, 0xBF },
	0xD1D9,	{ 0xE5, 0xA5, 0x84 },
	0xD1DA,	{ 0xE6, 0x8E, 0xA9 },
	0xD1DB,	{ 0xE7, 0x9C, 0xBC },
	0xD1DC,	{ 0xE8, 0xA1, 0x8D },
	0xD1DD,	{ 0xE6, 0xBC, 0x94 },
	0xD1DE,	{ 0xE8, 0x89, 0xB3 },
	0xD1DF,	{ 0xE5, 0xA0, 0xB0 },
	0xD1E0,	{ 0xE7, 0x87, 0x95 },
	0xD1E1,	{ 0xE5, 0x8E, 0x8C },
	0xD1E2,	{ 0xE7, 0xA0, 0x9A },
	0xD1E3,	{ 0xE9, 0x9B, 0x81 },
	0xD1E4,	{ 0xE5, 0x94, 0x81 },
	0xD1E5,	{ 0xE5, 0xBD, 0xA6 },
	0xD1E6,	{ 0xE7, 0x84, 0xB0 },
	0xD1E7,	{ 0xE5, 0xAE, 0xB4 },
	0xD1E8,	{ 0xE8, 0xB0, 0x9A },
	0xD1E9,	{ 0xE9, 0xAA, 0x8C },
	0xD1EA,	{ 0xE6, 0xAE, 0x83 },
	0xD1EB,	{ 0xE5, 0xA4, 0xAE },
	0xD1EC,	{ 0xE9, 0xB8, 0xAF },
	0xD1ED,	{ 0xE7, 0xA7, 0xA7 },
	0xD1EE,	{ 0xE6, 0x9D, 0xA8 },
	0xD1EF,	{ 0xE6, 0x89, 0xAC },
	0xD1F0,	{ 0xE4, 0xBD, 0xAF },
	0xD1F1,	{ 0xE7, 0x96, 0xA1 },
	0xD1F2,	{ 0xE7, 0xBE, 0x8A },
	0xD1F3,	{ 0xE6, 0xB4, 0x8B },
	0xD1F4,	{ 0xE9, 0x98, 0xB3 },
	0xD1F5,	{ 0xE6, 0xB0, 0xA7 },
	0xD1F6,	{ 0xE4, 0xBB, 0xB0 },
	0xD1F7,	{ 0xE7, 0x97, 0x92 },
	0xD1F8,	{ 0xE5, 0x85, 0xBB },
	0xD1F9,	{ 0xE6, 0xA0, 0xB7 },
	0xD1FA,	{ 0xE6, 0xBC, 0xBE },
	0xD1FB,	{ 0xE9, 0x82, 0x80 },
	0xD1FC,	{ 0xE8, 0x85, 0xB0 },
	0xD1FD,	{ 0xE5, 0xA6, 0x96 },
	0xD1FE,	{ 0xE7, 0x91, 0xB6 },
	0xD240,	{ 0xE8, 0xA4, 0xB8 },
	0xD241,	{ 0xE8, 0xA4, 0xB9 },
	0xD242,	{ 0xE8, 0xA4, 0xBA },
	0xD243,	{ 0xE8, 0xA4, 0xBB },
	0xD244,	{ 0xE8, 0xA4, 0xBC },
	0xD245,	{ 0xE8, 0xA4, 0xBD },
	0xD246,	{ 0xE8, 0xA4, 0xBE },
	0xD247,	{ 0xE8, 0xA4, 0xBF },
	0xD248,	{ 0xE8, 0xA5, 0x80 },
	0xD249,	{ 0xE8, 0xA5, 0x82 },
	0xD24A,	{ 0xE8, 0xA5, 0x83 },
	0xD24B,	{ 0xE8, 0xA5, 0x85 },
	0xD24C,	{ 0xE8, 0xA5, 0x86 },
	0xD24D,	{ 0xE8, 0xA5, 0x87 },
	0xD24E,	{ 0xE8, 0xA5, 0x88 },
	0xD24F,	{ 0xE8, 0xA5, 0x89 },
	0xD250,	{ 0xE8, 0xA5, 0x8A },
	0xD251,	{ 0xE8, 0xA5, 0x8B },
	0xD252,	{ 0xE8, 0xA5, 0x8C },
	0xD253,	{ 0xE8, 0xA5, 0x8D },
	0xD254,	{ 0xE8, 0xA5, 0x8E },
	0xD255,	{ 0xE8, 0xA5, 0x8F },
	0xD256,	{ 0xE8, 0xA5, 0x90 },
	0xD257,	{ 0xE8, 0xA5, 0x91 },
	0xD258,	{ 0xE8, 0xA5, 0x92 },
	0xD259,	{ 0xE8, 0xA5, 0x93 },
	0xD25A,	{ 0xE8, 0xA5, 0x94 },
	0xD25B,	{ 0xE8, 0xA5, 0x95 },
	0xD25C,	{ 0xE8, 0xA5, 0x96 },
	0xD25D,	{ 0xE8, 0xA5, 0x97 },
	0xD25E,	{ 0xE8, 0xA5, 0x98 },
	0xD25F,	{ 0xE8, 0xA5, 0x99 },
	0xD260,	{ 0xE8, 0xA5, 0x9A },
	0xD261,	{ 0xE8, 0xA5, 0x9B },
	0xD262,	{ 0xE8, 0xA5, 0x9C },
	0xD263,	{ 0xE8, 0xA5, 0x9D },
	0xD264,	{ 0xE8, 0xA5, 0xA0 },
	0xD265,	{ 0xE8, 0xA5, 0xA1 },
	0xD266,	{ 0xE8, 0xA5, 0xA2 },
	0xD267,	{ 0xE8, 0xA5, 0xA3 },
	0xD268,	{ 0xE8, 0xA5, 0xA4 },
	0xD269,	{ 0xE8, 0xA5, 0xA5 },
	0xD26A,	{ 0xE8, 0xA5, 0xA7 },
	0xD26B,	{ 0xE8, 0xA5, 0xA8 },
	0xD26C,	{ 0xE8, 0xA5, 0xA9 },
	0xD26D,	{ 0xE8, 0xA5, 0xAA },
	0xD26E,	{ 0xE8, 0xA5, 0xAB },
	0xD26F,	{ 0xE8, 0xA5, 0xAC },
	0xD270,	{ 0xE8, 0xA5, 0xAD },
	0xD271,	{ 0xE8, 0xA5, 0xAE },
	0xD272,	{ 0xE8, 0xA5, 0xAF },
	0xD273,	{ 0xE8, 0xA5, 0xB0 },
	0xD274,	{ 0xE8, 0xA5, 0xB1 },
	0xD275,	{ 0xE8, 0xA5, 0xB2 },
	0xD276,	{ 0xE8, 0xA5, 0xB3 },
	0xD277,	{ 0xE8, 0xA5, 0xB4 },
	0xD278,	{ 0xE8, 0xA5, 0xB5 },
	0xD279,	{ 0xE8, 0xA5, 0xB6 },
	0xD27A,	{ 0xE8, 0xA5, 0xB7 },
	0xD27B,	{ 0xE8, 0xA5, 0xB8 },
	0xD27C,	{ 0xE8, 0xA5, 0xB9 },
	0xD27D,	{ 0xE8, 0xA5, 0xBA },
	0xD27E,	{ 0xE8, 0xA5, 0xBC },
	0xD280,	{ 0xE8, 0xA5, 0xBD },
	0xD281,	{ 0xE8, 0xA5, 0xBE },
	0xD282,	{ 0xE8, 0xA6, 0x80 },
	0xD283,	{ 0xE8, 0xA6, 0x82 },
	0xD284,	{ 0xE8, 0xA6, 0x84 },
	0xD285,	{ 0xE8, 0xA6, 0x85 },
	0xD286,	{ 0xE8, 0xA6, 0x87 },
	0xD287,	{ 0xE8, 0xA6, 0x88 },
	0xD288,	{ 0xE8, 0xA6, 0x89 },
	0xD289,	{ 0xE8, 0xA6, 0x8A },
	0xD28A,	{ 0xE8, 0xA6, 0x8B },
	0xD28B,	{ 0xE8, 0xA6, 0x8C },
	0xD28C,	{ 0xE8, 0xA6, 0x8D },
	0xD28D,	{ 0xE8, 0xA6, 0x8E },
	0xD28E,	{ 0xE8, 0xA6, 0x8F },
	0xD28F,	{ 0xE8, 0xA6, 0x90 },
	0xD290,	{ 0xE8, 0xA6, 0x91 },
	0xD291,	{ 0xE8, 0xA6, 0x92 },
	0xD292,	{ 0xE8, 0xA6, 0x93 },
	0xD293,	{ 0xE8, 0xA6, 0x94 },
	0xD294,	{ 0xE8, 0xA6, 0x95 },
	0xD295,	{ 0xE8, 0xA6, 0x96 },
	0xD296,	{ 0xE8, 0xA6, 0x97 },
	0xD297,	{ 0xE8, 0xA6, 0x98 },
	0xD298,	{ 0xE8, 0xA6, 0x99 },
	0xD299,	{ 0xE8, 0xA6, 0x9A },
	0xD29A,	{ 0xE8, 0xA6, 0x9B },
	0xD29B,	{ 0xE8, 0xA6, 0x9C },
	0xD29C,	{ 0xE8, 0xA6, 0x9D },
	0xD29D,	{ 0xE8, 0xA6, 0x9E },
	0xD29E,	{ 0xE8, 0xA6, 0x9F },
	0xD29F,	{ 0xE8, 0xA6, 0xA0 },
	0xD2A0,	{ 0xE8, 0xA6, 0xA1 },
	0xD2A1,	{ 0xE6, 0x91, 0x87 },
	0xD2A2,	{ 0xE5, 0xB0, 0xA7 },
	0xD2A3,	{ 0xE9, 0x81, 0xA5 },
	0xD2A4,	{ 0xE7, 0xAA, 0x91 },
	0xD2A5,	{ 0xE8, 0xB0, 0xA3 },
	0xD2A6,	{ 0xE5, 0xA7, 0x9A },
	0xD2A7,	{ 0xE5, 0x92, 0xAC },
	0xD2A8,	{ 0xE8, 0x88, 0x80 },
	0xD2A9,	{ 0xE8, 0x8D, 0xAF },
	0xD2AA,	{ 0xE8, 0xA6, 0x81 },
	0xD2AB,	{ 0xE8, 0x80, 0x80 },
	0xD2AC,	{ 0xE6, 0xA4, 0xB0 },
	0xD2AD,	{ 0xE5, 0x99, 0x8E },
	0xD2AE,	{ 0xE8, 0x80, 0xB6 },
	0xD2AF,	{ 0xE7, 0x88, 0xB7 },
	0xD2B0,	{ 0xE9, 0x87, 0x8E },
	0xD2B1,	{ 0xE5, 0x86, 0xB6 },
	0xD2B2,	{ 0xE4, 0xB9, 0x9F },
	0xD2B3,	{ 0xE9, 0xA1, 0xB5 },
	0xD2B4,	{ 0xE6, 0x8E, 0x96 },
	0xD2B5,	{ 0xE4, 0xB8, 0x9A },
	0xD2B6,	{ 0xE5, 0x8F, 0xB6 },
	0xD2B7,	{ 0xE6, 0x9B, 0xB3 },
	0xD2B8,	{ 0xE8, 0x85, 0x8B },
	0xD2B9,	{ 0xE5, 0xA4, 0x9C },
	0xD2BA,	{ 0xE6, 0xB6, 0xB2 },
	0xD2BB,	{ 0xE4, 0xB8, 0x80 },
	0xD2BC,	{ 0xE5, 0xA3, 0xB9 },
	0xD2BD,	{ 0xE5, 0x8C, 0xBB },
	0xD2BE,	{ 0xE6, 0x8F, 0x96 },
	0xD2BF,	{ 0xE9, 0x93, 0xB1 },
	0xD2C0,	{ 0xE4, 0xBE, 0x9D },
	0xD2C1,	{ 0xE4, 0xBC, 0x8A },
	0xD2C2,	{ 0xE8, 0xA1, 0xA3 },
	0xD2C3,	{ 0xE9, 0xA2, 0x90 },
	0xD2C4,	{ 0xE5, 0xA4, 0xB7 },
	0xD2C5,	{ 0xE9, 0x81, 0x97 },
	0xD2C6,	{ 0xE7, 0xA7, 0xBB },
	0xD2C7,	{ 0xE4, 0xBB, 0xAA },
	0xD2C8,	{ 0xE8, 0x83, 0xB0 },
	0xD2C9,	{ 0xE7, 0x96, 0x91 },
	0xD2CA,	{ 0xE6, 0xB2, 0x82 },
	0xD2CB,	{ 0xE5, 0xAE, 0x9C },
	0xD2CC,	{ 0xE5, 0xA7, 0xA8 },
	0xD2CD,	{ 0xE5, 0xBD, 0x9D },
	0xD2CE,	{ 0xE6, 0xA4, 0x85 },
	0xD2CF,	{ 0xE8, 0x9A, 0x81 },
	0xD2D0,	{ 0xE5, 0x80, 0x9A },
	0xD2D1,	{ 0xE5, 0xB7, 0xB2 },
	0xD2D2,	{ 0xE4, 0xB9, 0x99 },
	0xD2D3,	{ 0xE7, 0x9F, 0xA3 },
	0xD2D4,	{ 0xE4, 0xBB, 0xA5 },
	0xD2D5,	{ 0xE8, 0x89, 0xBA },
	0xD2D6,	{ 0xE6, 0x8A, 0x91 },
	0xD2D7,	{ 0xE6, 0x98, 0x93 },
	0xD2D8,	{ 0xE9, 0x82, 0x91 },
	0xD2D9,	{ 0xE5, 0xB1, 0xB9 },
	0xD2DA,	{ 0xE4, 0xBA, 0xBF },
	0xD2DB,	{ 0xE5, 0xBD, 0xB9 },
	0xD2DC,	{ 0xE8, 0x87, 0x86 },
	0xD2DD,	{ 0xE9, 0x80, 0xB8 },
	0xD2DE,	{ 0xE8, 0x82, 0x84 },
	0xD2DF,	{ 0xE7, 0x96, 0xAB },
	0xD2E0,	{ 0xE4, 0xBA, 0xA6 },
	0xD2E1,	{ 0xE8, 0xA3, 0x94 },
	0xD2E2,	{ 0xE6, 0x84, 0x8F },
	0xD2E3,	{ 0xE6, 0xAF, 0x85 },
	0xD2E4,	{ 0xE5, 0xBF, 0x86 },
	0xD2E5,	{ 0xE4, 0xB9, 0x89 },
	0xD2E6,	{ 0xE7, 0x9B, 0x8A },
	0xD2E7,	{ 0xE6, 0xBA, 0xA2 },
	0xD2E8,	{ 0xE8, 0xAF, 0xA3 },
	0xD2E9,	{ 0xE8, 0xAE, 0xAE },
	0xD2EA,	{ 0xE8, 0xB0, 0x8A },
	0xD2EB,	{ 0xE8, 0xAF, 0x91 },
	0xD2EC,	{ 0xE5, 0xBC, 0x82 },
	0xD2ED,	{ 0xE7, 0xBF, 0xBC },
	0xD2EE,	{ 0xE7, 0xBF, 0x8C },
	0xD2EF,	{ 0xE7, 0xBB, 0x8E },
	0xD2F0,	{ 0xE8, 0x8C, 0xB5 },
	0xD2F1,	{ 0xE8, 0x8D, 0xAB },
	0xD2F2,	{ 0xE5, 0x9B, 0xA0 },
	0xD2F3,	{ 0xE6, 0xAE, 0xB7 },
	0xD2F4,	{ 0xE9, 0x9F, 0xB3 },
	0xD2F5,	{ 0xE9, 0x98, 0xB4 },
	0xD2F6,	{ 0xE5, 0xA7, 0xBB },
	0xD2F7,	{ 0xE5, 0x90, 0x9F },
	0xD2F8,	{ 0xE9, 0x93, 0xB6 },
	0xD2F9,	{ 0xE6, 0xB7, 0xAB },
	0xD2FA,	{ 0xE5, 0xAF, 0x85 },
	0xD2FB,	{ 0xE9, 0xA5, 0xAE },
	0xD2FC,	{ 0xE5, 0xB0, 0xB9 },
	0xD2FD,	{ 0xE5, 0xBC, 0x95 },
	0xD2FE,	{ 0xE9, 0x9A, 0x90 },
	0xD340,	{ 0xE8, 0xA6, 0xA2 },
	0xD341,	{ 0xE8, 0xA6, 0xA3 },
	0xD342,	{ 0xE8, 0xA6, 0xA4 },
	0xD343,	{ 0xE8, 0xA6, 0xA5 },
	0xD344,	{ 0xE8, 0xA6, 0xA6 },
	0xD345,	{ 0xE8, 0xA6, 0xA7 },
	0xD346,	{ 0xE8, 0xA6, 0xA8 },
	0xD347,	{ 0xE8, 0xA6, 0xA9 },
	0xD348,	{ 0xE8, 0xA6, 0xAA },
	0xD349,	{ 0xE8, 0xA6, 0xAB },
	0xD34A,	{ 0xE8, 0xA6, 0xAC },
	0xD34B,	{ 0xE8, 0xA6, 0xAD },
	0xD34C,	{ 0xE8, 0xA6, 0xAE },
	0xD34D,	{ 0xE8, 0xA6, 0xAF },
	0xD34E,	{ 0xE8, 0xA6, 0xB0 },
	0xD34F,	{ 0xE8, 0xA6, 0xB1 },
	0xD350,	{ 0xE8, 0xA6, 0xB2 },
	0xD351,	{ 0xE8, 0xA6, 0xB3 },
	0xD352,	{ 0xE8, 0xA6, 0xB4 },
	0xD353,	{ 0xE8, 0xA6, 0xB5 },
	0xD354,	{ 0xE8, 0xA6, 0xB6 },
	0xD355,	{ 0xE8, 0xA6, 0xB7 },
	0xD356,	{ 0xE8, 0xA6, 0xB8 },
	0xD357,	{ 0xE8, 0xA6, 0xB9 },
	0xD358,	{ 0xE8, 0xA6, 0xBA },
	0xD359,	{ 0xE8, 0xA6, 0xBB },
	0xD35A,	{ 0xE8, 0xA6, 0xBC },
	0xD35B,	{ 0xE8, 0xA6, 0xBD },
	0xD35C,	{ 0xE8, 0xA6, 0xBE },
	0xD35D,	{ 0xE8, 0xA6, 0xBF },
	0xD35E,	{ 0xE8, 0xA7, 0x80 },
	0xD35F,	{ 0xE8, 0xA7, 0x83 },
	0xD360,	{ 0xE8, 0xA7, 0x8D },
	0xD361,	{ 0xE8, 0xA7, 0x93 },
	0xD362,	{ 0xE8, 0xA7, 0x94 },
	0xD363,	{ 0xE8, 0xA7, 0x95 },
	0xD364,	{ 0xE8, 0xA7, 0x97 },
	0xD365,	{ 0xE8, 0xA7, 0x98 },
	0xD366,	{ 0xE8, 0xA7, 0x99 },
	0xD367,	{ 0xE8, 0xA7, 0x9B },
	0xD368,	{ 0xE8, 0xA7, 0x9D },
	0xD369,	{ 0xE8, 0xA7, 0x9F },
	0xD36A,	{ 0xE8, 0xA7, 0xA0 },
	0xD36B,	{ 0xE8, 0xA7, 0xA1 },
	0xD36C,	{ 0xE8, 0xA7, 0xA2 },
	0xD36D,	{ 0xE8, 0xA7, 0xA4 },
	0xD36E,	{ 0xE8, 0xA7, 0xA7 },
	0xD36F,	{ 0xE8, 0xA7, 0xA8 },
	0xD370,	{ 0xE8, 0xA7, 0xA9 },
	0xD371,	{ 0xE8, 0xA7, 0xAA },
	0xD372,	{ 0xE8, 0xA7, 0xAC },
	0xD373,	{ 0xE8, 0xA7, 0xAD },
	0xD374,	{ 0xE8, 0xA7, 0xAE },
	0xD375,	{ 0xE8, 0xA7, 0xB0 },
	0xD376,	{ 0xE8, 0xA7, 0xB1 },
	0xD377,	{ 0xE8, 0xA7, 0xB2 },
	0xD378,	{ 0xE8, 0xA7, 0xB4 },
	0xD379,	{ 0xE8, 0xA7, 0xB5 },
	0xD37A,	{ 0xE8, 0xA7, 0xB6 },
	0xD37B,	{ 0xE8, 0xA7, 0xB7 },
	0xD37C,	{ 0xE8, 0xA7, 0xB8 },
	0xD37D,	{ 0xE8, 0xA7, 0xB9 },
	0xD37E,	{ 0xE8, 0xA7, 0xBA },
	0xD380,	{ 0xE8, 0xA7, 0xBB },
	0xD381,	{ 0xE8, 0xA7, 0xBC },
	0xD382,	{ 0xE8, 0xA7, 0xBD },
	0xD383,	{ 0xE8, 0xA7, 0xBE },
	0xD384,	{ 0xE8, 0xA7, 0xBF },
	0xD385,	{ 0xE8, 0xA8, 0x81 },
	0xD386,	{ 0xE8, 0xA8, 0x82 },
	0xD387,	{ 0xE8, 0xA8, 0x83 },
	0xD388,	{ 0xE8, 0xA8, 0x84 },
	0xD389,	{ 0xE8, 0xA8, 0x85 },
	0xD38A,	{ 0xE8, 0xA8, 0x86 },
	0xD38B,	{ 0xE8, 0xA8, 0x88 },
	0xD38C,	{ 0xE8, 0xA8, 0x89 },
	0xD38D,	{ 0xE8, 0xA8, 0x8A },
	0xD38E,	{ 0xE8, 0xA8, 0x8B },
	0xD38F,	{ 0xE8, 0xA8, 0x8C },
	0xD390,	{ 0xE8, 0xA8, 0x8D },
	0xD391,	{ 0xE8, 0xA8, 0x8E },
	0xD392,	{ 0xE8, 0xA8, 0x8F },
	0xD393,	{ 0xE8, 0xA8, 0x90 },
	0xD394,	{ 0xE8, 0xA8, 0x91 },
	0xD395,	{ 0xE8, 0xA8, 0x92 },
	0xD396,	{ 0xE8, 0xA8, 0x93 },
	0xD397,	{ 0xE8, 0xA8, 0x94 },
	0xD398,	{ 0xE8, 0xA8, 0x95 },
	0xD399,	{ 0xE8, 0xA8, 0x96 },
	0xD39A,	{ 0xE8, 0xA8, 0x97 },
	0xD39B,	{ 0xE8, 0xA8, 0x98 },
	0xD39C,	{ 0xE8, 0xA8, 0x99 },
	0xD39D,	{ 0xE8, 0xA8, 0x9A },
	0xD39E,	{ 0xE8, 0xA8, 0x9B },
	0xD39F,	{ 0xE8, 0xA8, 0x9C },
	0xD3A0,	{ 0xE8, 0xA8, 0x9D },
	0xD3A1,	{ 0xE5, 0x8D, 0xB0 },
	0xD3A2,	{ 0xE8, 0x8B, 0xB1 },
	0xD3A3,	{ 0xE6, 0xA8, 0xB1 },
	0xD3A4,	{ 0xE5, 0xA9, 0xB4 },
	0xD3A5,	{ 0xE9, 0xB9, 0xB0 },
	0xD3A6,	{ 0xE5, 0xBA, 0x94 },
	0xD3A7,	{ 0xE7, 0xBC, 0xA8 },
	0xD3A8,	{ 0xE8, 0x8E, 0xB9 },
	0xD3A9,	{ 0xE8, 0x90, 0xA4 },
	0xD3AA,	{ 0xE8, 0x90, 0xA5 },
	0xD3AB,	{ 0xE8, 0x8D, 0xA7 },
	0xD3AC,	{ 0xE8, 0x9D, 0x87 },
	0xD3AD,	{ 0xE8, 0xBF, 0x8E },
	0xD3AE,	{ 0xE8, 0xB5, 0xA2 },
	0xD3AF,	{ 0xE7, 0x9B, 0x88 },
	0xD3B0,	{ 0xE5, 0xBD, 0xB1 },
	0xD3B1,	{ 0xE9, 0xA2, 0x96 },
	0xD3B2,	{ 0xE7, 0xA1, 0xAC },
	0xD3B3,	{ 0xE6, 0x98, 0xA0 },
	0xD3B4,	{ 0xE5, 0x93, 0x9F },
	0xD3B5,	{ 0xE6, 0x8B, 0xA5 },
	0xD3B6,	{ 0xE4, 0xBD, 0xA3 },
	0xD3B7,	{ 0xE8, 0x87, 0x83 },
	0xD3B8,	{ 0xE7, 0x97, 0x88 },
	0xD3B9,	{ 0xE5, 0xBA, 0xB8 },
	0xD3BA,	{ 0xE9, 0x9B, 0x8D },
	0xD3BB,	{ 0xE8, 0xB8, 0x8A },
	0xD3BC,	{ 0xE8, 0x9B, 0xB9 },
	0xD3BD,	{ 0xE5, 0x92, 0x8F },
	0xD3BE,	{ 0xE6, 0xB3, 0xB3 },
	0xD3BF,	{ 0xE6, 0xB6, 0x8C },
	0xD3C0,	{ 0xE6, 0xB0, 0xB8 },
	0xD3C1,	{ 0xE6, 0x81, 0xBF },
	0xD3C2,	{ 0xE5, 0x8B, 0x87 },
	0xD3C3,	{ 0xE7, 0x94, 0xA8 },
	0xD3C4,	{ 0xE5, 0xB9, 0xBD },
	0xD3C5,	{ 0xE4, 0xBC, 0x98 },
	0xD3C6,	{ 0xE6, 0x82, 0xA0 },
	0xD3C7,	{ 0xE5, 0xBF, 0xA7 },
	0xD3C8,	{ 0xE5, 0xB0, 0xA4 },
	0xD3C9,	{ 0xE7, 0x94, 0xB1 },
	0xD3CA,	{ 0xE9, 0x82, 0xAE },
	0xD3CB,	{ 0xE9, 0x93, 0x80 },
	0xD3CC,	{ 0xE7, 0x8A, 0xB9 },
	0xD3CD,	{ 0xE6, 0xB2, 0xB9 },
	0xD3CE,	{ 0xE6, 0xB8, 0xB8 },
	0xD3CF,	{ 0xE9, 0x85, 0x89 },
	0xD3D0,	{ 0xE6, 0x9C, 0x89 },
	0xD3D1,	{ 0xE5, 0x8F, 0x8B },
	0xD3D2,	{ 0xE5, 0x8F, 0xB3 },
	0xD3D3,	{ 0xE4, 0xBD, 0x91 },
	0xD3D4,	{ 0xE9, 0x87, 0x89 },
	0xD3D5,	{ 0xE8, 0xAF, 0xB1 },
	0xD3D6,	{ 0xE5, 0x8F, 0x88 },
	0xD3D7,	{ 0xE5, 0xB9, 0xBC },
	0xD3D8,	{ 0xE8, 0xBF, 0x82 },
	0xD3D9,	{ 0xE6, 0xB7, 0xA4 },
	0xD3DA,	{ 0xE4, 0xBA, 0x8E },
	0xD3DB,	{ 0xE7, 0x9B, 0x82 },
	0xD3DC,	{ 0xE6, 0xA6, 0x86 },
	0xD3DD,	{ 0xE8, 0x99, 0x9E },
	0xD3DE,	{ 0xE6, 0x84, 0x9A },
	0xD3DF,	{ 0xE8, 0x88, 0x86 },
	0xD3E0,	{ 0xE4, 0xBD, 0x99 },
	0xD3E1,	{ 0xE4, 0xBF, 0x9E },
	0xD3E2,	{ 0xE9, 0x80, 0xBE },
	0xD3E3,	{ 0xE9, 0xB1, 0xBC },
	0xD3E4,	{ 0xE6, 0x84, 0x89 },
	0xD3E5,	{ 0xE6, 0xB8, 0x9D },
	0xD3E6,	{ 0xE6, 0xB8, 0x94 },
	0xD3E7,	{ 0xE9, 0x9A, 0x85 },
	0xD3E8,	{ 0xE4, 0xBA, 0x88 },
	0xD3E9,	{ 0xE5, 0xA8, 0xB1 },
	0xD3EA,	{ 0xE9, 0x9B, 0xA8 },
	0xD3EB,	{ 0xE4, 0xB8, 0x8E },
	0xD3EC,	{ 0xE5, 0xB1, 0xBF },
	0xD3ED,	{ 0xE7, 0xA6, 0xB9 },
	0xD3EE,	{ 0xE5, 0xAE, 0x87 },
	0xD3EF,	{ 0xE8, 0xAF, 0xAD },
	0xD3F0,	{ 0xE7, 0xBE, 0xBD },
	0xD3F1,	{ 0xE7, 0x8E, 0x89 },
	0xD3F2,	{ 0xE5, 0x9F, 0x9F },
	0xD3F3,	{ 0xE8, 0x8A, 0x8B },
	0xD3F4,	{ 0xE9, 0x83, 0x81 },
	0xD3F5,	{ 0xE5, 0x90, 0x81 },
	0xD3F6,	{ 0xE9, 0x81, 0x87 },
	0xD3F7,	{ 0xE5, 0x96, 0xBB },
	0xD3F8,	{ 0xE5, 0xB3, 0xAA },
	0xD3F9,	{ 0xE5, 0xBE, 0xA1 },
	0xD3FA,	{ 0xE6, 0x84, 0x88 },
	0xD3FB,	{ 0xE6, 0xAC, 0xB2 },
	0xD3FC,	{ 0xE7, 0x8B, 0xB1 },
	0xD3FD,	{ 0xE8, 0x82, 0xB2 },
	0xD3FE,	{ 0xE8, 0xAA, 0x89 },
	0xD440,	{ 0xE8, 0xA8, 0x9E },
	0xD441,	{ 0xE8, 0xA8, 0x9F },
	0xD442,	{ 0xE8, 0xA8, 0xA0 },
	0xD443,	{ 0xE8, 0xA8, 0xA1 },
	0xD444,	{ 0xE8, 0xA8, 0xA2 },
	0xD445,	{ 0xE8, 0xA8, 0xA3 },
	0xD446,	{ 0xE8, 0xA8, 0xA4 },
	0xD447,	{ 0xE8, 0xA8, 0xA5 },
	0xD448,	{ 0xE8, 0xA8, 0xA6 },
	0xD449,	{ 0xE8, 0xA8, 0xA7 },
	0xD44A,	{ 0xE8, 0xA8, 0xA8 },
	0xD44B,	{ 0xE8, 0xA8, 0xA9 },
	0xD44C,	{ 0xE8, 0xA8, 0xAA },
	0xD44D,	{ 0xE8, 0xA8, 0xAB },
	0xD44E,	{ 0xE8, 0xA8, 0xAC },
	0xD44F,	{ 0xE8, 0xA8, 0xAD },
	0xD450,	{ 0xE8, 0xA8, 0xAE },
	0xD451,	{ 0xE8, 0xA8, 0xAF },
	0xD452,	{ 0xE8, 0xA8, 0xB0 },
	0xD453,	{ 0xE8, 0xA8, 0xB1 },
	0xD454,	{ 0xE8, 0xA8, 0xB2 },
	0xD455,	{ 0xE8, 0xA8, 0xB3 },
	0xD456,	{ 0xE8, 0xA8, 0xB4 },
	0xD457,	{ 0xE8, 0xA8, 0xB5 },
	0xD458,	{ 0xE8, 0xA8, 0xB6 },
	0xD459,	{ 0xE8, 0xA8, 0xB7 },
	0xD45A,	{ 0xE8, 0xA8, 0xB8 },
	0xD45B,	{ 0xE8, 0xA8, 0xB9 },
	0xD45C,	{ 0xE8, 0xA8, 0xBA },
	0xD45D,	{ 0xE8, 0xA8, 0xBB },
	0xD45E,	{ 0xE8, 0xA8, 0xBC },
	0xD45F,	{ 0xE8, 0xA8, 0xBD },
	0xD460,	{ 0xE8, 0xA8, 0xBF },
	0xD461,	{ 0xE8, 0xA9, 0x80 },
	0xD462,	{ 0xE8, 0xA9, 0x81 },
	0xD463,	{ 0xE8, 0xA9, 0x82 },
	0xD464,	{ 0xE8, 0xA9, 0x83 },
	0xD465,	{ 0xE8, 0xA9, 0x84 },
	0xD466,	{ 0xE8, 0xA9, 0x85 },
	0xD467,	{ 0xE8, 0xA9, 0x86 },
	0xD468,	{ 0xE8, 0xA9, 0x87 },
	0xD469,	{ 0xE8, 0xA9, 0x89 },
	0xD46A,	{ 0xE8, 0xA9, 0x8A },
	0xD46B,	{ 0xE8, 0xA9, 0x8B },
	0xD46C,	{ 0xE8, 0xA9, 0x8C },
	0xD46D,	{ 0xE8, 0xA9, 0x8D },
	0xD46E,	{ 0xE8, 0xA9, 0x8E },
	0xD46F,	{ 0xE8, 0xA9, 0x8F },
	0xD470,	{ 0xE8, 0xA9, 0x90 },
	0xD471,	{ 0xE8, 0xA9, 0x91 },
	0xD472,	{ 0xE8, 0xA9, 0x92 },
	0xD473,	{ 0xE8, 0xA9, 0x93 },
	0xD474,	{ 0xE8, 0xA9, 0x94 },
	0xD475,	{ 0xE8, 0xA9, 0x95 },
	0xD476,	{ 0xE8, 0xA9, 0x96 },
	0xD477,	{ 0xE8, 0xA9, 0x97 },
	0xD478,	{ 0xE8, 0xA9, 0x98 },
	0xD479,	{ 0xE8, 0xA9, 0x99 },
	0xD47A,	{ 0xE8, 0xA9, 0x9A },
	0xD47B,	{ 0xE8, 0xA9, 0x9B },
	0xD47C,	{ 0xE8, 0xA9, 0x9C },
	0xD47D,	{ 0xE8, 0xA9, 0x9D },
	0xD47E,	{ 0xE8, 0xA9, 0x9E },
	0xD480,	{ 0xE8, 0xA9, 0x9F },
	0xD481,	{ 0xE8, 0xA9, 0xA0 },
	0xD482,	{ 0xE8, 0xA9, 0xA1 },
	0xD483,	{ 0xE8, 0xA9, 0xA2 },
	0xD484,	{ 0xE8, 0xA9, 0xA3 },
	0xD485,	{ 0xE8, 0xA9, 0xA4 },
	0xD486,	{ 0xE8, 0xA9, 0xA5 },
	0xD487,	{ 0xE8, 0xA9, 0xA6 },
	0xD488,	{ 0xE8, 0xA9, 0xA7 },
	0xD489,	{ 0xE8, 0xA9, 0xA8 },
	0xD48A,	{ 0xE8, 0xA9, 0xA9 },
	0xD48B,	{ 0xE8, 0xA9, 0xAA },
	0xD48C,	{ 0xE8, 0xA9, 0xAB },
	0xD48D,	{ 0xE8, 0xA9, 0xAC },
	0xD48E,	{ 0xE8, 0xA9, 0xAD },
	0xD48F,	{ 0xE8, 0xA9, 0xAE },
	0xD490,	{ 0xE8, 0xA9, 0xAF },
	0xD491,	{ 0xE8, 0xA9, 0xB0 },
	0xD492,	{ 0xE8, 0xA9, 0xB1 },
	0xD493,	{ 0xE8, 0xA9, 0xB2 },
	0xD494,	{ 0xE8, 0xA9, 0xB3 },
	0xD495,	{ 0xE8, 0xA9, 0xB4 },
	0xD496,	{ 0xE8, 0xA9, 0xB5 },
	0xD497,	{ 0xE8, 0xA9, 0xB6 },
	0xD498,	{ 0xE8, 0xA9, 0xB7 },
	0xD499,	{ 0xE8, 0xA9, 0xB8 },
	0xD49A,	{ 0xE8, 0xA9, 0xBA },
	0xD49B,	{ 0xE8, 0xA9, 0xBB },
	0xD49C,	{ 0xE8, 0xA9, 0xBC },
	0xD49D,	{ 0xE8, 0xA9, 0xBD },
	0xD49E,	{ 0xE8, 0xA9, 0xBE },
	0xD49F,	{ 0xE8, 0xA9, 0xBF },
	0xD4A0,	{ 0xE8, 0xAA, 0x80 },
	0xD4A1,	{ 0xE6, 0xB5, 0xB4 },
	0xD4A2,	{ 0xE5, 0xAF, 0x93 },
	0xD4A3,	{ 0xE8, 0xA3, 0x95 },
	0xD4A4,	{ 0xE9, 0xA2, 0x84 },
	0xD4A5,	{ 0xE8, 0xB1, 0xAB },
	0xD4A6,	{ 0xE9, 0xA9, 0xAD },
	0xD4A7,	{ 0xE9, 0xB8, 0xB3 },
	0xD4A8,	{ 0xE6, 0xB8, 0x8A },
	0xD4A9,	{ 0xE5, 0x86, 0xA4 },
	0xD4AA,	{ 0xE5, 0x85, 0x83 },
	0xD4AB,	{ 0xE5, 0x9E, 0xA3 },
	0xD4AC,	{ 0xE8, 0xA2, 0x81 },
	0xD4AD,	{ 0xE5, 0x8E, 0x9F },
	0xD4AE,	{ 0xE6, 0x8F, 0xB4 },
	0xD4AF,	{ 0xE8, 0xBE, 0x95 },
	0xD4B0,	{ 0xE5, 0x9B, 0xAD },
	0xD4B1,	{ 0xE5, 0x91, 0x98 },
	0xD4B2,	{ 0xE5, 0x9C, 0x86 },
	0xD4B3,	{ 0xE7, 0x8C, 0xBF },
	0xD4B4,	{ 0xE6, 0xBA, 0x90 },
	0xD4B5,	{ 0xE7, 0xBC, 0x98 },
	0xD4B6,	{ 0xE8, 0xBF, 0x9C },
	0xD4B7,	{ 0xE8, 0x8B, 0x91 },
	0xD4B8,	{ 0xE6, 0x84, 0xBF },
	0xD4B9,	{ 0xE6, 0x80, 0xA8 },
	0xD4BA,	{ 0xE9, 0x99, 0xA2 },
	0xD4BB,	{ 0xE6, 0x9B, 0xB0 },
	0xD4BC,	{ 0xE7, 0xBA, 0xA6 },
	0xD4BD,	{ 0xE8, 0xB6, 0x8A },
	0xD4BE,	{ 0xE8, 0xB7, 0x83 },
	0xD4BF,	{ 0xE9, 0x92, 0xA5 },
	0xD4C0,	{ 0xE5, 0xB2, 0xB3 },
	0xD4C1,	{ 0xE7, 0xB2, 0xA4 },
	0xD4C2,	{ 0xE6, 0x9C, 0x88 },
	0xD4C3,	{ 0xE6, 0x82, 0xA6 },
	0xD4C4,	{ 0xE9, 0x98, 0x85 },
	0xD4C5,	{ 0xE8, 0x80, 0x98 },
	0xD4C6,	{ 0xE4, 0xBA, 0x91 },
	0xD4C7,	{ 0xE9, 0x83, 0xA7 },
	0xD4C8,	{ 0xE5, 0x8C, 0x80 },
	0xD4C9,	{ 0xE9, 0x99, 0xA8 },
	0xD4CA,	{ 0xE5, 0x85, 0x81 },
	0xD4CB,	{ 0xE8, 0xBF, 0x90 },
	0xD4CC,	{ 0xE8, 0x95, 0xB4 },
	0xD4CD,	{ 0xE9, 0x85, 0x9D },
	0xD4CE,	{ 0xE6, 0x99, 0x95 },
	0xD4CF,	{ 0xE9, 0x9F, 0xB5 },
	0xD4D0,	{ 0xE5, 0xAD, 0x95 },
	0xD4D1,	{ 0xE5, 0x8C, 0x9D },
	0xD4D2,	{ 0xE7, 0xA0, 0xB8 },
	0xD4D3,	{ 0xE6, 0x9D, 0x82 },
	0xD4D4,	{ 0xE6, 0xA0, 0xBD },
	0xD4D5,	{ 0xE5, 0x93, 0x89 },
	0xD4D6,	{ 0xE7, 0x81, 0xBE },
	0xD4D7,	{ 0xE5, 0xAE, 0xB0 },
	0xD4D8,	{ 0xE8, 0xBD, 0xBD },
	0xD4D9,	{ 0xE5, 0x86, 0x8D },
	0xD4DA,	{ 0xE5, 0x9C, 0xA8 },
	0xD4DB,	{ 0xE5, 0x92, 0xB1 },
	0xD4DC,	{ 0xE6, 0x94, 0x92 },
	0xD4DD,	{ 0xE6, 0x9A, 0x82 },
	0xD4DE,	{ 0xE8, 0xB5, 0x9E },
	0xD4DF,	{ 0xE8, 0xB5, 0x83 },
	0xD4E0,	{ 0xE8, 0x84, 0x8F },
	0xD4E1,	{ 0xE8, 0x91, 0xAC },
	0xD4E2,	{ 0xE9, 0x81, 0xAD },
	0xD4E3,	{ 0xE7, 0xB3, 0x9F },
	0xD4E4,	{ 0xE5, 0x87, 0xBF },
	0xD4E5,	{ 0xE8, 0x97, 0xBB },
	0xD4E6,	{ 0xE6, 0x9E, 0xA3 },
	0xD4E7,	{ 0xE6, 0x97, 0xA9 },
	0xD4E8,	{ 0xE6, 0xBE, 0xA1 },
	0xD4E9,	{ 0xE8, 0x9A, 0xA4 },
	0xD4EA,	{ 0xE8, 0xBA, 0x81 },
	0xD4EB,	{ 0xE5, 0x99, 0xAA },
	0xD4EC,	{ 0xE9, 0x80, 0xA0 },
	0xD4ED,	{ 0xE7, 0x9A, 0x82 },
	0xD4EE,	{ 0xE7, 0x81, 0xB6 },
	0xD4EF,	{ 0xE7, 0x87, 0xA5 },
	0xD4F0,	{ 0xE8, 0xB4, 0xA3 },
	0xD4F1,	{ 0xE6, 0x8B, 0xA9 },
	0xD4F2,	{ 0xE5, 0x88, 0x99 },
	0xD4F3,	{ 0xE6, 0xB3, 0xBD },
	0xD4F4,	{ 0xE8, 0xB4, 0xBC },
	0xD4F5,	{ 0xE6, 0x80, 0x8E },
	0xD4F6,	{ 0xE5, 0xA2, 0x9E },
	0xD4F7,	{ 0xE6, 0x86, 0x8E },
	0xD4F8,	{ 0xE6, 0x9B, 0xBE },
	0xD4F9,	{ 0xE8, 0xB5, 0xA0 },
	0xD4FA,	{ 0xE6, 0x89, 0x8E },
	0xD4FB,	{ 0xE5, 0x96, 0xB3 },
	0xD4FC,	{ 0xE6, 0xB8, 0xA3 },
	0xD4FD,	{ 0xE6, 0x9C, 0xAD },
	0xD4FE,	{ 0xE8, 0xBD, 0xA7 },
	0xD540,	{ 0xE8, 0xAA, 0x81 },
	0xD541,	{ 0xE8, 0xAA, 0x82 },
	0xD542,	{ 0xE8, 0xAA, 0x83 },
	0xD543,	{ 0xE8, 0xAA, 0x84 },
	0xD544,	{ 0xE8, 0xAA, 0x85 },
	0xD545,	{ 0xE8, 0xAA, 0x86 },
	0xD546,	{ 0xE8, 0xAA, 0x87 },
	0xD547,	{ 0xE8, 0xAA, 0x88 },
	0xD548,	{ 0xE8, 0xAA, 0x8B },
	0xD549,	{ 0xE8, 0xAA, 0x8C },
	0xD54A,	{ 0xE8, 0xAA, 0x8D },
	0xD54B,	{ 0xE8, 0xAA, 0x8E },
	0xD54C,	{ 0xE8, 0xAA, 0x8F },
	0xD54D,	{ 0xE8, 0xAA, 0x90 },
	0xD54E,	{ 0xE8, 0xAA, 0x91 },
	0xD54F,	{ 0xE8, 0xAA, 0x92 },
	0xD550,	{ 0xE8, 0xAA, 0x94 },
	0xD551,	{ 0xE8, 0xAA, 0x95 },
	0xD552,	{ 0xE8, 0xAA, 0x96 },
	0xD553,	{ 0xE8, 0xAA, 0x97 },
	0xD554,	{ 0xE8, 0xAA, 0x98 },
	0xD555,	{ 0xE8, 0xAA, 0x99 },
	0xD556,	{ 0xE8, 0xAA, 0x9A },
	0xD557,	{ 0xE8, 0xAA, 0x9B },
	0xD558,	{ 0xE8, 0xAA, 0x9C },
	0xD559,	{ 0xE8, 0xAA, 0x9D },
	0xD55A,	{ 0xE8, 0xAA, 0x9E },
	0xD55B,	{ 0xE8, 0xAA, 0x9F },
	0xD55C,	{ 0xE8, 0xAA, 0xA0 },
	0xD55D,	{ 0xE8, 0xAA, 0xA1 },
	0xD55E,	{ 0xE8, 0xAA, 0xA2 },
	0xD55F,	{ 0xE8, 0xAA, 0xA3 },
	0xD560,	{ 0xE8, 0xAA, 0xA4 },
	0xD561,	{ 0xE8, 0xAA, 0xA5 },
	0xD562,	{ 0xE8, 0xAA, 0xA6 },
	0xD563,	{ 0xE8, 0xAA, 0xA7 },
	0xD564,	{ 0xE8, 0xAA, 0xA8 },
	0xD565,	{ 0xE8, 0xAA, 0xA9 },
	0xD566,	{ 0xE8, 0xAA, 0xAA },
	0xD567,	{ 0xE8, 0xAA, 0xAB },
	0xD568,	{ 0xE8, 0xAA, 0xAC },
	0xD569,	{ 0xE8, 0xAA, 0xAD },
	0xD56A,	{ 0xE8, 0xAA, 0xAE },
	0xD56B,	{ 0xE8, 0xAA, 0xAF },
	0xD56C,	{ 0xE8, 0xAA, 0xB0 },
	0xD56D,	{ 0xE8, 0xAA, 0xB1 },
	0xD56E,	{ 0xE8, 0xAA, 0xB2 },
	0xD56F,	{ 0xE8, 0xAA, 0xB3 },
	0xD570,	{ 0xE8, 0xAA, 0xB4 },
	0xD571,	{ 0xE8, 0xAA, 0xB5 },
	0xD572,	{ 0xE8, 0xAA, 0xB6 },
	0xD573,	{ 0xE8, 0xAA, 0xB7 },
	0xD574,	{ 0xE8, 0xAA, 0xB8 },
	0xD575,	{ 0xE8, 0xAA, 0xB9 },
	0xD576,	{ 0xE8, 0xAA, 0xBA },
	0xD577,	{ 0xE8, 0xAA, 0xBB },
	0xD578,	{ 0xE8, 0xAA, 0xBC },
	0xD579,	{ 0xE8, 0xAA, 0xBD },
	0xD57A,	{ 0xE8, 0xAA, 0xBE },
	0xD57B,	{ 0xE8, 0xAA, 0xBF },
	0xD57C,	{ 0xE8, 0xAB, 0x80 },
	0xD57D,	{ 0xE8, 0xAB, 0x81 },
	0xD57E,	{ 0xE8, 0xAB, 0x82 },
	0xD580,	{ 0xE8, 0xAB, 0x83 },
	0xD581,	{ 0xE8, 0xAB, 0x84 },
	0xD582,	{ 0xE8, 0xAB, 0x85 },
	0xD583,	{ 0xE8, 0xAB, 0x86 },
	0xD584,	{ 0xE8, 0xAB, 0x87 },
	0xD585,	{ 0xE8, 0xAB, 0x88 },
	0xD586,	{ 0xE8, 0xAB, 0x89 },
	0xD587,	{ 0xE8, 0xAB, 0x8A },
	0xD588,	{ 0xE8, 0xAB, 0x8B },
	0xD589,	{ 0xE8, 0xAB, 0x8C },
	0xD58A,	{ 0xE8, 0xAB, 0x8D },
	0xD58B,	{ 0xE8, 0xAB, 0x8E },
	0xD58C,	{ 0xE8, 0xAB, 0x8F },
	0xD58D,	{ 0xE8, 0xAB, 0x90 },
	0xD58E,	{ 0xE8, 0xAB, 0x91 },
	0xD58F,	{ 0xE8, 0xAB, 0x92 },
	0xD590,	{ 0xE8, 0xAB, 0x93 },
	0xD591,	{ 0xE8, 0xAB, 0x94 },
	0xD592,	{ 0xE8, 0xAB, 0x95 },
	0xD593,	{ 0xE8, 0xAB, 0x96 },
	0xD594,	{ 0xE8, 0xAB, 0x97 },
	0xD595,	{ 0xE8, 0xAB, 0x98 },
	0xD596,	{ 0xE8, 0xAB, 0x99 },
	0xD597,	{ 0xE8, 0xAB, 0x9A },
	0xD598,	{ 0xE8, 0xAB, 0x9B },
	0xD599,	{ 0xE8, 0xAB, 0x9C },
	0xD59A,	{ 0xE8, 0xAB, 0x9D },
	0xD59B,	{ 0xE8, 0xAB, 0x9E },
	0xD59C,	{ 0xE8, 0xAB, 0x9F },
	0xD59D,	{ 0xE8, 0xAB, 0xA0 },
	0xD59E,	{ 0xE8, 0xAB, 0xA1 },
	0xD59F,	{ 0xE8, 0xAB, 0xA2 },
	0xD5A0,	{ 0xE8, 0xAB, 0xA3 },
	0xD5A1,	{ 0xE9, 0x93, 0xA1 },
	0xD5A2,	{ 0xE9, 0x97, 0xB8 },
	0xD5A3,	{ 0xE7, 0x9C, 0xA8 },
	0xD5A4,	{ 0xE6, 0xA0, 0x85 },
	0xD5A5,	{ 0xE6, 0xA6, 0xA8 },
	0xD5A6,	{ 0xE5, 0x92, 0x8B },
	0xD5A7,	{ 0xE4, 0xB9, 0x8D },
	0xD5A8,	{ 0xE7, 0x82, 0xB8 },
	0xD5A9,	{ 0xE8, 0xAF, 0x88 },
	0xD5AA,	{ 0xE6, 0x91, 0x98 },
	0xD5AB,	{ 0xE6, 0x96, 0x8B },
	0xD5AC,	{ 0xE5, 0xAE, 0x85 },
	0xD5AD,	{ 0xE7, 0xAA, 0x84 },
	0xD5AE,	{ 0xE5, 0x80, 0xBA },
	0xD5AF,	{ 0xE5, 0xAF, 0xA8 },
	0xD5B0,	{ 0xE7, 0x9E, 0xBB },
	0xD5B1,	{ 0xE6, 0xAF, 0xA1 },
	0xD5B2,	{ 0xE8, 0xA9, 0xB9 },
	0xD5B3,	{ 0xE7, 0xB2, 0x98 },
	0xD5B4,	{ 0xE6, 0xB2, 0xBE },
	0xD5B5,	{ 0xE7, 0x9B, 0x8F },
	0xD5B6,	{ 0xE6, 0x96, 0xA9 },
	0xD5B7,	{ 0xE8, 0xBE, 0x97 },
	0xD5B8,	{ 0xE5, 0xB4, 0xAD },
	0xD5B9,	{ 0xE5, 0xB1, 0x95 },
	0xD5BA,	{ 0xE8, 0x98, 0xB8 },
	0xD5BB,	{ 0xE6, 0xA0, 0x88 },
	0xD5BC,	{ 0xE5, 0x8D, 0xA0 },
	0xD5BD,	{ 0xE6, 0x88, 0x98 },
	0xD5BE,	{ 0xE7, 0xAB, 0x99 },
	0xD5BF,	{ 0xE6, 0xB9, 0x9B },
	0xD5C0,	{ 0xE7, 0xBB, 0xBD },
	0xD5C1,	{ 0xE6, 0xA8, 0x9F },
	0xD5C2,	{ 0xE7, 0xAB, 0xA0 },
	0xD5C3,	{ 0xE5, 0xBD, 0xB0 },
	0xD5C4,	{ 0xE6, 0xBC, 0xB3 },
	0xD5C5,	{ 0xE5, 0xBC, 0xA0 },
	0xD5C6,	{ 0xE6, 0x8E, 0x8C },
	0xD5C7,	{ 0xE6, 0xB6, 0xA8 },
	0xD5C8,	{ 0xE6, 0x9D, 0x96 },
	0xD5C9,	{ 0xE4, 0xB8, 0x88 },
	0xD5CA,	{ 0xE5, 0xB8, 0x90 },
	0xD5CB,	{ 0xE8, 0xB4, 0xA6 },
	0xD5CC,	{ 0xE4, 0xBB, 0x97 },
	0xD5CD,	{ 0xE8, 0x83, 0x80 },
	0xD5CE,	{ 0xE7, 0x98, 0xB4 },
	0xD5CF,	{ 0xE9, 0x9A, 0x9C },
	0xD5D0,	{ 0xE6, 0x8B, 0x9B },
	0xD5D1,	{ 0xE6, 0x98, 0xAD },
	0xD5D2,	{ 0xE6, 0x89, 0xBE },
	0xD5D3,	{ 0xE6, 0xB2, 0xBC },
	0xD5D4,	{ 0xE8, 0xB5, 0xB5 },
	0xD5D5,	{ 0xE7, 0x85, 0xA7 },
	0xD5D6,	{ 0xE7, 0xBD, 0xA9 },
	0xD5D7,	{ 0xE5, 0x85, 0x86 },
	0xD5D8,	{ 0xE8, 0x82, 0x87 },
	0xD5D9,	{ 0xE5, 0x8F, 0xAC },
	0xD5DA,	{ 0xE9, 0x81, 0xAE },
	0xD5DB,	{ 0xE6, 0x8A, 0x98 },
	0xD5DC,	{ 0xE5, 0x93, 0xB2 },
	0xD5DD,	{ 0xE8, 0x9B, 0xB0 },
	0xD5DE,	{ 0xE8, 0xBE, 0x99 },
	0xD5DF,	{ 0xE8, 0x80, 0x85 },
	0xD5E0,	{ 0xE9, 0x94, 0x97 },
	0xD5E1,	{ 0xE8, 0x94, 0x97 },
	0xD5E2,	{ 0xE8, 0xBF, 0x99 },
	0xD5E3,	{ 0xE6, 0xB5, 0x99 },
	0xD5E4,	{ 0xE7, 0x8F, 0x8D },
	0xD5E5,	{ 0xE6, 0x96, 0x9F },
	0xD5E6,	{ 0xE7, 0x9C, 0x9F },
	0xD5E7,	{ 0xE7, 0x94, 0x84 },
	0xD5E8,	{ 0xE7, 0xA0, 0xA7 },
	0xD5E9,	{ 0xE8, 0x87, 0xBB },
	0xD5EA,	{ 0xE8, 0xB4, 0x9E },
	0xD5EB,	{ 0xE9, 0x92, 0x88 },
	0xD5EC,	{ 0xE4, 0xBE, 0xA6 },
	0xD5ED,	{ 0xE6, 0x9E, 0x95 },
	0xD5EE,	{ 0xE7, 0x96, 0xB9 },
	0xD5EF,	{ 0xE8, 0xAF, 0x8A },
	0xD5F0,	{ 0xE9, 0x9C, 0x87 },
	0xD5F1,	{ 0xE6, 0x8C, 0xAF },
	0xD5F2,	{ 0xE9, 0x95, 0x87 },
	0xD5F3,	{ 0xE9, 0x98, 0xB5 },
	0xD5F4,	{ 0xE8, 0x92, 0xB8 },
	0xD5F5,	{ 0xE6, 0x8C, 0xA3 },
	0xD5F6,	{ 0xE7, 0x9D, 0x81 },
	0xD5F7,	{ 0xE5, 0xBE, 0x81 },
	0xD5F8,	{ 0xE7, 0x8B, 0xB0 },
	0xD5F9,	{ 0xE4, 0xBA, 0x89 },
	0xD5FA,	{ 0xE6, 0x80, 0x94 },
	0xD5FB,	{ 0xE6, 0x95, 0xB4 },
	0xD5FC,	{ 0xE6, 0x8B, 0xAF },
	0xD5FD,	{ 0xE6, 0xAD, 0xA3 },
	0xD5FE,	{ 0xE6, 0x94, 0xBF },
	0xD640,	{ 0xE8, 0xAB, 0xA4 },
	0xD641,	{ 0xE8, 0xAB, 0xA5 },
	0xD642,	{ 0xE8, 0xAB, 0xA6 },
	0xD643,	{ 0xE8, 0xAB, 0xA7 },
	0xD644,	{ 0xE8, 0xAB, 0xA8 },
	0xD645,	{ 0xE8, 0xAB, 0xA9 },
	0xD646,	{ 0xE8, 0xAB, 0xAA },
	0xD647,	{ 0xE8, 0xAB, 0xAB },
	0xD648,	{ 0xE8, 0xAB, 0xAC },
	0xD649,	{ 0xE8, 0xAB, 0xAD },
	0xD64A,	{ 0xE8, 0xAB, 0xAE },
	0xD64B,	{ 0xE8, 0xAB, 0xAF },
	0xD64C,	{ 0xE8, 0xAB, 0xB0 },
	0xD64D,	{ 0xE8, 0xAB, 0xB1 },
	0xD64E,	{ 0xE8, 0xAB, 0xB2 },
	0xD64F,	{ 0xE8, 0xAB, 0xB3 },
	0xD650,	{ 0xE8, 0xAB, 0xB4 },
	0xD651,	{ 0xE8, 0xAB, 0xB5 },
	0xD652,	{ 0xE8, 0xAB, 0xB6 },
	0xD653,	{ 0xE8, 0xAB, 0xB7 },
	0xD654,	{ 0xE8, 0xAB, 0xB8 },
	0xD655,	{ 0xE8, 0xAB, 0xB9 },
	0xD656,	{ 0xE8, 0xAB, 0xBA },
	0xD657,	{ 0xE8, 0xAB, 0xBB },
	0xD658,	{ 0xE8, 0xAB, 0xBC },
	0xD659,	{ 0xE8, 0xAB, 0xBD },
	0xD65A,	{ 0xE8, 0xAB, 0xBE },
	0xD65B,	{ 0xE8, 0xAB, 0xBF },
	0xD65C,	{ 0xE8, 0xAC, 0x80 },
	0xD65D,	{ 0xE8, 0xAC, 0x81 },
	0xD65E,	{ 0xE8, 0xAC, 0x82 },
	0xD65F,	{ 0xE8, 0xAC, 0x83 },
	0xD660,	{ 0xE8, 0xAC, 0x84 },
	0xD661,	{ 0xE8, 0xAC, 0x85 },
	0xD662,	{ 0xE8, 0xAC, 0x86 },
	0xD663,	{ 0xE8, 0xAC, 0x88 },
	0xD664,	{ 0xE8, 0xAC, 0x89 },
	0xD665,	{ 0xE8, 0xAC, 0x8A },
	0xD666,	{ 0xE8, 0xAC, 0x8B },
	0xD667,	{ 0xE8, 0xAC, 0x8C },
	0xD668,	{ 0xE8, 0xAC, 0x8D },
	0xD669,	{ 0xE8, 0xAC, 0x8E },
	0xD66A,	{ 0xE8, 0xAC, 0x8F },
	0xD66B,	{ 0xE8, 0xAC, 0x90 },
	0xD66C,	{ 0xE8, 0xAC, 0x91 },
	0xD66D,	{ 0xE8, 0xAC, 0x92 },
	0xD66E,	{ 0xE8, 0xAC, 0x93 },
	0xD66F,	{ 0xE8, 0xAC, 0x94 },
	0xD670,	{ 0xE8, 0xAC, 0x95 },
	0xD671,	{ 0xE8, 0xAC, 0x96 },
	0xD672,	{ 0xE8, 0xAC, 0x97 },
	0xD673,	{ 0xE8, 0xAC, 0x98 },
	0xD674,	{ 0xE8, 0xAC, 0x99 },
	0xD675,	{ 0xE8, 0xAC, 0x9A },
	0xD676,	{ 0xE8, 0xAC, 0x9B },
	0xD677,	{ 0xE8, 0xAC, 0x9C },
	0xD678,	{ 0xE8, 0xAC, 0x9D },
	0xD679,	{ 0xE8, 0xAC, 0x9E },
	0xD67A,	{ 0xE8, 0xAC, 0x9F },
	0xD67B,	{ 0xE8, 0xAC, 0xA0 },
	0xD67C,	{ 0xE8, 0xAC, 0xA1 },
	0xD67D,	{ 0xE8, 0xAC, 0xA2 },
	0xD67E,	{ 0xE8, 0xAC, 0xA3 },
	0xD680,	{ 0xE8, 0xAC, 0xA4 },
	0xD681,	{ 0xE8, 0xAC, 0xA5 },
	0xD682,	{ 0xE8, 0xAC, 0xA7 },
	0xD683,	{ 0xE8, 0xAC, 0xA8 },
	0xD684,	{ 0xE8, 0xAC, 0xA9 },
	0xD685,	{ 0xE8, 0xAC, 0xAA },
	0xD686,	{ 0xE8, 0xAC, 0xAB },
	0xD687,	{ 0xE8, 0xAC, 0xAC },
	0xD688,	{ 0xE8, 0xAC, 0xAD },
	0xD689,	{ 0xE8, 0xAC, 0xAE },
	0xD68A,	{ 0xE8, 0xAC, 0xAF },
	0xD68B,	{ 0xE8, 0xAC, 0xB0 },
	0xD68C,	{ 0xE8, 0xAC, 0xB1 },
	0xD68D,	{ 0xE8, 0xAC, 0xB2 },
	0xD68E,	{ 0xE8, 0xAC, 0xB3 },
	0xD68F,	{ 0xE8, 0xAC, 0xB4 },
	0xD690,	{ 0xE8, 0xAC, 0xB5 },
	0xD691,	{ 0xE8, 0xAC, 0xB6 },
	0xD692,	{ 0xE8, 0xAC, 0xB7 },
	0xD693,	{ 0xE8, 0xAC, 0xB8 },
	0xD694,	{ 0xE8, 0xAC, 0xB9 },
	0xD695,	{ 0xE8, 0xAC, 0xBA },
	0xD696,	{ 0xE8, 0xAC, 0xBB },
	0xD697,	{ 0xE8, 0xAC, 0xBC },
	0xD698,	{ 0xE8, 0xAC, 0xBD },
	0xD699,	{ 0xE8, 0xAC, 0xBE },
	0xD69A,	{ 0xE8, 0xAC, 0xBF },
	0xD69B,	{ 0xE8, 0xAD, 0x80 },
	0xD69C,	{ 0xE8, 0xAD, 0x81 },
	0xD69D,	{ 0xE8, 0xAD, 0x82 },
	0xD69E,	{ 0xE8, 0xAD, 0x83 },
	0xD69F,	{ 0xE8, 0xAD, 0x84 },
	0xD6A0,	{ 0xE8, 0xAD, 0x85 },
	0xD6A1,	{ 0xE5, 0xB8, 0xA7 },
	0xD6A2,	{ 0xE7, 0x97, 0x87 },
	0xD6A3,	{ 0xE9, 0x83, 0x91 },
	0xD6A4,	{ 0xE8, 0xAF, 0x81 },
	0xD6A5,	{ 0xE8, 0x8A, 0x9D },
	0xD6A6,	{ 0xE6, 0x9E, 0x9D },
	0xD6A7,	{ 0xE6, 0x94, 0xAF },
	0xD6A8,	{ 0xE5, 0x90, 0xB1 },
	0xD6A9,	{ 0xE8, 0x9C, 0x98 },
	0xD6AA,	{ 0xE7, 0x9F, 0xA5 },
	0xD6AB,	{ 0xE8, 0x82, 0xA2 },
	0xD6AC,	{ 0xE8, 0x84, 0x82 },
	0xD6AD,	{ 0xE6, 0xB1, 0x81 },
	0xD6AE,	{ 0xE4, 0xB9, 0x8B },
	0xD6AF,	{ 0xE7, 0xBB, 0x87 },
	0xD6B0,	{ 0xE8, 0x81, 0x8C },
	0xD6B1,	{ 0xE7, 0x9B, 0xB4 },
	0xD6B2,	{ 0xE6, 0xA4, 0x8D },
	0xD6B3,	{ 0xE6, 0xAE, 0x96 },
	0xD6B4,	{ 0xE6, 0x89, 0xA7 },
	0xD6B5,	{ 0xE5, 0x80, 0xBC },
	0xD6B6,	{ 0xE4, 0xBE, 0x84 },
	0xD6B7,	{ 0xE5, 0x9D, 0x80 },
	0xD6B8,	{ 0xE6, 0x8C, 0x87 },
	0xD6B9,	{ 0xE6, 0xAD, 0xA2 },
	0xD6BA,	{ 0xE8, 0xB6, 0xBE },
	0xD6BB,	{ 0xE5, 0x8F, 0xAA },
	0xD6BC,	{ 0xE6, 0x97, 0xA8 },
	0xD6BD,	{ 0xE7, 0xBA, 0xB8 },
	0xD6BE,	{ 0xE5, 0xBF, 0x97 },
	0xD6BF,	{ 0xE6, 0x8C, 0x9A },
	0xD6C0,	{ 0xE6, 0x8E, 0xB7 },
	0xD6C1,	{ 0xE8, 0x87, 0xB3 },
	0xD6C2,	{ 0xE8, 0x87, 0xB4 },
	0xD6C3,	{ 0xE7, 0xBD, 0xAE },
	0xD6C4,	{ 0xE5, 0xB8, 0x9C },
	0xD6C5,	{ 0xE5, 0xB3, 0x99 },
	0xD6C6,	{ 0xE5, 0x88, 0xB6 },
	0xD6C7,	{ 0xE6, 0x99, 0xBA },
	0xD6C8,	{ 0xE7, 0xA7, 0xA9 },
	0xD6C9,	{ 0xE7, 0xA8, 0x9A },
	0xD6CA,	{ 0xE8, 0xB4, 0xA8 },
	0xD6CB,	{ 0xE7, 0x82, 0x99 },
	0xD6CC,	{ 0xE7, 0x97, 0x94 },
	0xD6CD,	{ 0xE6, 0xBB, 0x9E },
	0xD6CE,	{ 0xE6, 0xB2, 0xBB },
	0xD6CF,	{ 0xE7, 0xAA, 0x92 },
	0xD6D0,	{ 0xE4, 0xB8, 0xAD },
	0xD6D1,	{ 0xE7, 0x9B, 0x85 },
	0xD6D2,	{ 0xE5, 0xBF, 0xA0 },
	0xD6D3,	{ 0xE9, 0x92, 0x9F },
	0xD6D4,	{ 0xE8, 0xA1, 0xB7 },
	0xD6D5,	{ 0xE7, 0xBB, 0x88 },
	0xD6D6,	{ 0xE7, 0xA7, 0x8D },
	0xD6D7,	{ 0xE8, 0x82, 0xBF },
	0xD6D8,	{ 0xE9, 0x87, 0x8D },
	0xD6D9,	{ 0xE4, 0xBB, 0xB2 },
	0xD6DA,	{ 0xE4, 0xBC, 0x97 },
	0xD6DB,	{ 0xE8, 0x88, 0x9F },
	0xD6DC,	{ 0xE5, 0x91, 0xA8 },
	0xD6DD,	{ 0xE5, 0xB7, 0x9E },
	0xD6DE,	{ 0xE6, 0xB4, 0xB2 },
	0xD6DF,	{ 0xE8, 0xAF, 0x8C },
	0xD6E0,	{ 0xE7, 0xB2, 0xA5 },
	0xD6E1,	{ 0xE8, 0xBD, 0xB4 },
	0xD6E2,	{ 0xE8, 0x82, 0x98 },
	0xD6E3,	{ 0xE5, 0xB8, 0x9A },
	0xD6E4,	{ 0xE5, 0x92, 0x92 },
	0xD6E5,	{ 0xE7, 0x9A, 0xB1 },
	0xD6E6,	{ 0xE5, 0xAE, 0x99 },
	0xD6E7,	{ 0xE6, 0x98, 0xBC },
	0xD6E8,	{ 0xE9, 0xAA, 0xA4 },
	0xD6E9,	{ 0xE7, 0x8F, 0xA0 },
	0xD6EA,	{ 0xE6, 0xA0, 0xAA },
	0xD6EB,	{ 0xE8, 0x9B, 0x9B },
	0xD6EC,	{ 0xE6, 0x9C, 0xB1 },
	0xD6ED,	{ 0xE7, 0x8C, 0xAA },
	0xD6EE,	{ 0xE8, 0xAF, 0xB8 },
	0xD6EF,	{ 0xE8, 0xAF, 0x9B },
	0xD6F0,	{ 0xE9, 0x80, 0x90 },
	0xD6F1,	{ 0xE7, 0xAB, 0xB9 },
	0xD6F2,	{ 0xE7, 0x83, 0x9B },
	0xD6F3,	{ 0xE7, 0x85, 0xAE },
	0xD6F4,	{ 0xE6, 0x8B, 0x84 },
	0xD6F5,	{ 0xE7, 0x9E, 0xA9 },
	0xD6F6,	{ 0xE5, 0x98, 0xB1 },
	0xD6F7,	{ 0xE4, 0xB8, 0xBB },
	0xD6F8,	{ 0xE8, 0x91, 0x97 },
	0xD6F9,	{ 0xE6, 0x9F, 0xB1 },
	0xD6FA,	{ 0xE5, 0x8A, 0xA9 },
	0xD6FB,	{ 0xE8, 0x9B, 0x80 },
	0xD6FC,	{ 0xE8, 0xB4, 0xAE },
	0xD6FD,	{ 0xE9, 0x93, 0xB8 },
	0xD6FE,	{ 0xE7, 0xAD, 0x91 },
	0xD740,	{ 0xE8, 0xAD, 0x86 },
	0xD741,	{ 0xE8, 0xAD, 0x87 },
	0xD742,	{ 0xE8, 0xAD, 0x88 },
	0xD743,	{ 0xE8, 0xAD, 0x89 },
	0xD744,	{ 0xE8, 0xAD, 0x8A },
	0xD745,	{ 0xE8, 0xAD, 0x8B },
	0xD746,	{ 0xE8, 0xAD, 0x8C },
	0xD747,	{ 0xE8, 0xAD, 0x8D },
	0xD748,	{ 0xE8, 0xAD, 0x8E },
	0xD749,	{ 0xE8, 0xAD, 0x8F },
	0xD74A,	{ 0xE8, 0xAD, 0x90 },
	0xD74B,	{ 0xE8, 0xAD, 0x91 },
	0xD74C,	{ 0xE8, 0xAD, 0x92 },
	0xD74D,	{ 0xE8, 0xAD, 0x93 },
	0xD74E,	{ 0xE8, 0xAD, 0x94 },
	0xD74F,	{ 0xE8, 0xAD, 0x95 },
	0xD750,	{ 0xE8, 0xAD, 0x96 },
	0xD751,	{ 0xE8, 0xAD, 0x97 },
	0xD752,	{ 0xE8, 0xAD, 0x98 },
	0xD753,	{ 0xE8, 0xAD, 0x99 },
	0xD754,	{ 0xE8, 0xAD, 0x9A },
	0xD755,	{ 0xE8, 0xAD, 0x9B },
	0xD756,	{ 0xE8, 0xAD, 0x9C },
	0xD757,	{ 0xE8, 0xAD, 0x9D },
	0xD758,	{ 0xE8, 0xAD, 0x9E },
	0xD759,	{ 0xE8, 0xAD, 0x9F },
	0xD75A,	{ 0xE8, 0xAD, 0xA0 },
	0xD75B,	{ 0xE8, 0xAD, 0xA1 },
	0xD75C,	{ 0xE8, 0xAD, 0xA2 },
	0xD75D,	{ 0xE8, 0xAD, 0xA3 },
	0xD75E,	{ 0xE8, 0xAD, 0xA4 },
	0xD75F,	{ 0xE8, 0xAD, 0xA5 },
	0xD760,	{ 0xE8, 0xAD, 0xA7 },
	0xD761,	{ 0xE8, 0xAD, 0xA8 },
	0xD762,	{ 0xE8, 0xAD, 0xA9 },
	0xD763,	{ 0xE8, 0xAD, 0xAA },
	0xD764,	{ 0xE8, 0xAD, 0xAB },
	0xD765,	{ 0xE8, 0xAD, 0xAD },
	0xD766,	{ 0xE8, 0xAD, 0xAE },
	0xD767,	{ 0xE8, 0xAD, 0xAF },
	0xD768,	{ 0xE8, 0xAD, 0xB0 },
	0xD769,	{ 0xE8, 0xAD, 0xB1 },
	0xD76A,	{ 0xE8, 0xAD, 0xB2 },
	0xD76B,	{ 0xE8, 0xAD, 0xB3 },
	0xD76C,	{ 0xE8, 0xAD, 0xB4 },
	0xD76D,	{ 0xE8, 0xAD, 0xB5 },
	0xD76E,	{ 0xE8, 0xAD, 0xB6 },
	0xD76F,	{ 0xE8, 0xAD, 0xB7 },
	0xD770,	{ 0xE8, 0xAD, 0xB8 },
	0xD771,	{ 0xE8, 0xAD, 0xB9 },
	0xD772,	{ 0xE8, 0xAD, 0xBA },
	0xD773,	{ 0xE8, 0xAD, 0xBB },
	0xD774,	{ 0xE8, 0xAD, 0xBC },
	0xD775,	{ 0xE8, 0xAD, 0xBD },
	0xD776,	{ 0xE8, 0xAD, 0xBE },
	0xD777,	{ 0xE8, 0xAD, 0xBF },
	0xD778,	{ 0xE8, 0xAE, 0x80 },
	0xD779,	{ 0xE8, 0xAE, 0x81 },
	0xD77A,	{ 0xE8, 0xAE, 0x82 },
	0xD77B,	{ 0xE8, 0xAE, 0x83 },
	0xD77C,	{ 0xE8, 0xAE, 0x84 },
	0xD77D,	{ 0xE8, 0xAE, 0x85 },
	0xD77E,	{ 0xE8, 0xAE, 0x86 },
	0xD780,	{ 0xE8, 0xAE, 0x87 },
	0xD781,	{ 0xE8, 0xAE, 0x88 },
	0xD782,	{ 0xE8, 0xAE, 0x89 },
	0xD783,	{ 0xE8, 0xAE, 0x8A },
	0xD784,	{ 0xE8, 0xAE, 0x8B },
	0xD785,	{ 0xE8, 0xAE, 0x8C },
	0xD786,	{ 0xE8, 0xAE, 0x8D },
	0xD787,	{ 0xE8, 0xAE, 0x8E },
	0xD788,	{ 0xE8, 0xAE, 0x8F },
	0xD789,	{ 0xE8, 0xAE, 0x90 },
	0xD78A,	{ 0xE8, 0xAE, 0x91 },
	0xD78B,	{ 0xE8, 0xAE, 0x92 },
	0xD78C,	{ 0xE8, 0xAE, 0x93 },
	0xD78D,	{ 0xE8, 0xAE, 0x94 },
	0xD78E,	{ 0xE8, 0xAE, 0x95 },
	0xD78F,	{ 0xE8, 0xAE, 0x96 },
	0xD790,	{ 0xE8, 0xAE, 0x97 },
	0xD791,	{ 0xE8, 0xAE, 0x98 },
	0xD792,	{ 0xE8, 0xAE, 0x99 },
	0xD793,	{ 0xE8, 0xAE, 0x9A },
	0xD794,	{ 0xE8, 0xAE, 0x9B },
	0xD795,	{ 0xE8, 0xAE, 0x9C },
	0xD796,	{ 0xE8, 0xAE, 0x9D },
	0xD797,	{ 0xE8, 0xAE, 0x9E },
	0xD798,	{ 0xE8, 0xAE, 0x9F },
	0xD799,	{ 0xE8, 0xAE, 0xAC },
	0xD79A,	{ 0xE8, 0xAE, 0xB1 },
	0xD79B,	{ 0xE8, 0xAE, 0xBB },
	0xD79C,	{ 0xE8, 0xAF, 0x87 },
	0xD79D,	{ 0xE8, 0xAF, 0x90 },
	0xD79E,	{ 0xE8, 0xAF, 0xAA },
	0xD79F,	{ 0xE8, 0xB0, 0x89 },
	0xD7A0,	{ 0xE8, 0xB0, 0x9E },
	0xD7A1,	{ 0xE4, 0xBD, 0x8F },
	0xD7A2,	{ 0xE6, 0xB3, 0xA8 },
	0xD7A3,	{ 0xE7, 0xA5, 0x9D },
	0xD7A4,	{ 0xE9, 0xA9, 0xBB },
	0xD7A5,	{ 0xE6, 0x8A, 0x93 },
	0xD7A6,	{ 0xE7, 0x88, 0xAA },
	0xD7A7,	{ 0xE6, 0x8B, 0xBD },
	0xD7A8,	{ 0xE4, 0xB8, 0x93 },
	0xD7A9,	{ 0xE7, 0xA0, 0x96 },
	0xD7AA,	{ 0xE8, 0xBD, 0xAC },
	0xD7AB,	{ 0xE6, 0x92, 0xB0 },
	0xD7AC,	{ 0xE8, 0xB5, 0x9A },
	0xD7AD,	{ 0xE7, 0xAF, 0x86 },
	0xD7AE,	{ 0xE6, 0xA1, 0xA9 },
	0xD7AF,	{ 0xE5, 0xBA, 0x84 },
	0xD7B0,	{ 0xE8, 0xA3, 0x85 },
	0xD7B1,	{ 0xE5, 0xA6, 0x86 },
	0xD7B2,	{ 0xE6, 0x92, 0x9E },
	0xD7B3,	{ 0xE5, 0xA3, 0xAE },
	0xD7B4,	{ 0xE7, 0x8A, 0xB6 },
	0xD7B5,	{ 0xE6, 0xA4, 0x8E },
	0xD7B6,	{ 0xE9, 0x94, 0xA5 },
	0xD7B7,	{ 0xE8, 0xBF, 0xBD },
	0xD7B8,	{ 0xE8, 0xB5, 0x98 },
	0xD7B9,	{ 0xE5, 0x9D, 0xA0 },
	0xD7BA,	{ 0xE7, 0xBC, 0x80 },
	0xD7BB,	{ 0xE8, 0xB0, 0x86 },
	0xD7BC,	{ 0xE5, 0x87, 0x86 },
	0xD7BD,	{ 0xE6, 0x8D, 0x89 },
	0xD7BE,	{ 0xE6, 0x8B, 0x99 },
	0xD7BF,	{ 0xE5, 0x8D, 0x93 },
	0xD7C0,	{ 0xE6, 0xA1, 0x8C },
	0xD7C1,	{ 0xE7, 0x90, 0xA2 },
	0xD7C2,	{ 0xE8, 0x8C, 0x81 },
	0xD7C3,	{ 0xE9, 0x85, 0x8C },
	0xD7C4,	{ 0xE5, 0x95, 0x84 },
	0xD7C5,	{ 0xE7, 0x9D, 0x80 },
	0xD7C6,	{ 0xE7, 0x81, 0xBC },
	0xD7C7,	{ 0xE6, 0xB5, 0x8A },
	0xD7C8,	{ 0xE5, 0x85, 0xB9 },
	0xD7C9,	{ 0xE5, 0x92, 0xA8 },
	0xD7CA,	{ 0xE8, 0xB5, 0x84 },
	0xD7CB,	{ 0xE5, 0xA7, 0xBF },
	0xD7CC,	{ 0xE6, 0xBB, 0x8B },
	0xD7CD,	{ 0xE6, 0xB7, 0x84 },
	0xD7CE,	{ 0xE5, 0xAD, 0x9C },
	0xD7CF,	{ 0xE7, 0xB4, 0xAB },
	0xD7D0,	{ 0xE4, 0xBB, 0x94 },
	0xD7D1,	{ 0xE7, 0xB1, 0xBD },
	0xD7D2,	{ 0xE6, 0xBB, 0x93 },
	0xD7D3,	{ 0xE5, 0xAD, 0x90 },
	0xD7D4,	{ 0xE8, 0x87, 0xAA },
	0xD7D5,	{ 0xE6, 0xB8, 0x8D },
	0xD7D6,	{ 0xE5, 0xAD, 0x97 },
	0xD7D7,	{ 0xE9, 0xAC, 0x83 },
	0xD7D8,	{ 0xE6, 0xA3, 0x95 },
	0xD7D9,	{ 0xE8, 0xB8, 0xAA },
	0xD7DA,	{ 0xE5, 0xAE, 0x97 },
	0xD7DB,	{ 0xE7, 0xBB, 0xBC },
	0xD7DC,	{ 0xE6, 0x80, 0xBB },
	0xD7DD,	{ 0xE7, 0xBA, 0xB5 },
	0xD7DE,	{ 0xE9, 0x82, 0xB9 },
	0xD7DF,	{ 0xE8, 0xB5, 0xB0 },
	0xD7E0,	{ 0xE5, 0xA5, 0x8F },
	0xD7E1,	{ 0xE6, 0x8F, 0x8D },
	0xD7E2,	{ 0xE7, 0xA7, 0x9F },
	0xD7E3,	{ 0xE8, 0xB6, 0xB3 },
	0xD7E4,	{ 0xE5, 0x8D, 0x92 },
	0xD7E5,	{ 0xE6, 0x97, 0x8F },
	0xD7E6,	{ 0xE7, 0xA5, 0x96 },
	0xD7E7,	{ 0xE8, 0xAF, 0x85 },
	0xD7E8,	{ 0xE9, 0x98, 0xBB },
	0xD7E9,	{ 0xE7, 0xBB, 0x84 },
	0xD7EA,	{ 0xE9, 0x92, 0xBB },
	0xD7EB,	{ 0xE7, 0xBA, 0x82 },
	0xD7EC,	{ 0xE5, 0x98, 0xB4 },
	0xD7ED,	{ 0xE9, 0x86, 0x89 },
	0xD7EE,	{ 0xE6, 0x9C, 0x80 },
	0xD7EF,	{ 0xE7, 0xBD, 0xAA },
	0xD7F0,	{ 0xE5, 0xB0, 0x8A },
	0xD7F1,	{ 0xE9, 0x81, 0xB5 },
	0xD7F2,	{ 0xE6, 0x98, 0xA8 },
	0xD7F3,	{ 0xE5, 0xB7, 0xA6 },
	0xD7F4,	{ 0xE4, 0xBD, 0x90 },
	0xD7F5,	{ 0xE6, 0x9F, 0x9E },
	0xD7F6,	{ 0xE5, 0x81, 0x9A },
	0xD7F7,	{ 0xE4, 0xBD, 0x9C },
	0xD7F8,	{ 0xE5, 0x9D, 0x90 },
	0xD7F9,	{ 0xE5, 0xBA, 0xA7 },
	0xD7FA,	{ 0xEE, 0xA0, 0x90 },
	0xD7FB,	{ 0xEE, 0xA0, 0x91 },
	0xD7FC,	{ 0xEE, 0xA0, 0x92 },
	0xD7FD,	{ 0xEE, 0xA0, 0x93 },
	0xD7FE,	{ 0xEE, 0xA0, 0x94 },
	0xD840,	{ 0xE8, 0xB0, 0xB8 },
	0xD841,	{ 0xE8, 0xB0, 0xB9 },
	0xD842,	{ 0xE8, 0xB0, 0xBA },
	0xD843,	{ 0xE8, 0xB0, 0xBB },
	0xD844,	{ 0xE8, 0xB0, 0xBC },
	0xD845,	{ 0xE8, 0xB0, 0xBD },
	0xD846,	{ 0xE8, 0xB0, 0xBE },
	0xD847,	{ 0xE8, 0xB0, 0xBF },
	0xD848,	{ 0xE8, 0xB1, 0x80 },
	0xD849,	{ 0xE8, 0xB1, 0x82 },
	0xD84A,	{ 0xE8, 0xB1, 0x83 },
	0xD84B,	{ 0xE8, 0xB1, 0x84 },
	0xD84C,	{ 0xE8, 0xB1, 0x85 },
	0xD84D,	{ 0xE8, 0xB1, 0x88 },
	0xD84E,	{ 0xE8, 0xB1, 0x8A },
	0xD84F,	{ 0xE8, 0xB1, 0x8B },
	0xD850,	{ 0xE8, 0xB1, 0x8D },
	0xD851,	{ 0xE8, 0xB1, 0x8E },
	0xD852,	{ 0xE8, 0xB1, 0x8F },
	0xD853,	{ 0xE8, 0xB1, 0x90 },
	0xD854,	{ 0xE8, 0xB1, 0x91 },
	0xD855,	{ 0xE8, 0xB1, 0x92 },
	0xD856,	{ 0xE8, 0xB1, 0x93 },
	0xD857,	{ 0xE8, 0xB1, 0x94 },
	0xD858,	{ 0xE8, 0xB1, 0x96 },
	0xD859,	{ 0xE8, 0xB1, 0x97 },
	0xD85A,	{ 0xE8, 0xB1, 0x98 },
	0xD85B,	{ 0xE8, 0xB1, 0x99 },
	0xD85C,	{ 0xE8, 0xB1, 0x9B },
	0xD85D,	{ 0xE8, 0xB1, 0x9C },
	0xD85E,	{ 0xE8, 0xB1, 0x9D },
	0xD85F,	{ 0xE8, 0xB1, 0x9E },
	0xD860,	{ 0xE8, 0xB1, 0x9F },
	0xD861,	{ 0xE8, 0xB1, 0xA0 },
	0xD862,	{ 0xE8, 0xB1, 0xA3 },
	0xD863,	{ 0xE8, 0xB1, 0xA4 },
	0xD864,	{ 0xE8, 0xB1, 0xA5 },
	0xD865,	{ 0xE8, 0xB1, 0xA6 },
	0xD866,	{ 0xE8, 0xB1, 0xA7 },
	0xD867,	{ 0xE8, 0xB1, 0xA8 },
	0xD868,	{ 0xE8, 0xB1, 0xA9 },
	0xD869,	{ 0xE8, 0xB1, 0xAC },
	0xD86A,	{ 0xE8, 0xB1, 0xAD },
	0xD86B,	{ 0xE8, 0xB1, 0xAE },
	0xD86C,	{ 0xE8, 0xB1, 0xAF },
	0xD86D,	{ 0xE8, 0xB1, 0xB0 },
	0xD86E,	{ 0xE8, 0xB1, 0xB1 },
	0xD86F,	{ 0xE8, 0xB1, 0xB2 },
	0xD870,	{ 0xE8, 0xB1, 0xB4 },
	0xD871,	{ 0xE8, 0xB1, 0xB5 },
	0xD872,	{ 0xE8, 0xB1, 0xB6 },
	0xD873,	{ 0xE8, 0xB1, 0xB7 },
	0xD874,	{ 0xE8, 0xB1, 0xBB },
	0xD875,	{ 0xE8, 0xB1, 0xBC },
	0xD876,	{ 0xE8, 0xB1, 0xBD },
	0xD877,	{ 0xE8, 0xB1, 0xBE },
	0xD878,	{ 0xE8, 0xB1, 0xBF },
	0xD879,	{ 0xE8, 0xB2, 0x80 },
	0xD87A,	{ 0xE8, 0xB2, 0x81 },
	0xD87B,	{ 0xE8, 0xB2, 0x83 },
	0xD87C,	{ 0xE8, 0xB2, 0x84 },
	0xD87D,	{ 0xE8, 0xB2, 0x86 },
	0xD87E,	{ 0xE8, 0xB2, 0x87 },
	0xD880,	{ 0xE8, 0xB2, 0x88 },
	0xD881,	{ 0xE8, 0xB2, 0x8B },
	0xD882,	{ 0xE8, 0xB2, 0x8D },
	0xD883,	{ 0xE8, 0xB2, 0x8E },
	0xD884,	{ 0xE8, 0xB2, 0x8F },
	0xD885,	{ 0xE8, 0xB2, 0x90 },
	0xD886,	{ 0xE8, 0xB2, 0x91 },
	0xD887,	{ 0xE8, 0xB2, 0x92 },
	0xD888,	{ 0xE8, 0xB2, 0x93 },
	0xD889,	{ 0xE8, 0xB2, 0x95 },
	0xD88A,	{ 0xE8, 0xB2, 0x96 },
	0xD88B,	{ 0xE8, 0xB2, 0x97 },
	0xD88C,	{ 0xE8, 0xB2, 0x99 },
	0xD88D,	{ 0xE8, 0xB2, 0x9A },
	0xD88E,	{ 0xE8, 0xB2, 0x9B },
	0xD88F,	{ 0xE8, 0xB2, 0x9C },
	0xD890,	{ 0xE8, 0xB2, 0x9D },
	0xD891,	{ 0xE8, 0xB2, 0x9E },
	0xD892,	{ 0xE8, 0xB2, 0x9F },
	0xD893,	{ 0xE8, 0xB2, 0xA0 },
	0xD894,	{ 0xE8, 0xB2, 0xA1 },
	0xD895,	{ 0xE8, 0xB2, 0xA2 },
	0xD896,	{ 0xE8, 0xB2, 0xA3 },
	0xD897,	{ 0xE8, 0xB2, 0xA4 },
	0xD898,	{ 0xE8, 0xB2, 0xA5 },
	0xD899,	{ 0xE8, 0xB2, 0xA6 },
	0xD89A,	{ 0xE8, 0xB2, 0xA7 },
	0xD89B,	{ 0xE8, 0xB2, 0xA8 },
	0xD89C,	{ 0xE8, 0xB2, 0xA9 },
	0xD89D,	{ 0xE8, 0xB2, 0xAA },
	0xD89E,	{ 0xE8, 0xB2, 0xAB },
	0xD89F,	{ 0xE8, 0xB2, 0xAC },
	0xD8A0,	{ 0xE8, 0xB2, 0xAD },
	0xD8A1,	{ 0xE4, 0xBA, 0x8D },
	0xD8A2,	{ 0xE4, 0xB8, 0x8C },
	0xD8A3,	{ 0xE5, 0x85, 0x80 },
	0xD8A4,	{ 0xE4, 0xB8, 0x90 },
	0xD8A5,	{ 0xE5, 0xBB, 0xBF },
	0xD8A6,	{ 0xE5, 0x8D, 0x85 },
	0xD8A7,	{ 0xE4, 0xB8, 0x95 },
	0xD8A8,	{ 0xE4, 0xBA, 0x98 },
	0xD8A9,	{ 0xE4, 0xB8, 0x9E },
	0xD8AA,	{ 0xE9, 0xAC, 0xB2 },
	0xD8AB,	{ 0xE5, 0xAD, 0xAC },
	0xD8AC,	{ 0xE5, 0x99, 0xA9 },
	0xD8AD,	{ 0xE4, 0xB8, 0xA8 },
	0xD8AE,	{ 0xE7, 0xA6, 0xBA },
	0xD8AF,	{ 0xE4, 0xB8, 0xBF },
	0xD8B0,	{ 0xE5, 0x8C, 0x95 },
	0xD8B1,	{ 0xE4, 0xB9, 0x87 },
	0xD8B2,	{ 0xE5, 0xA4, 0xAD },
	0xD8B3,	{ 0xE7, 0x88, 0xBB },
	0xD8B4,	{ 0xE5, 0x8D, 0xAE },
	0xD8B5,	{ 0xE6, 0xB0, 0x90 },
	0xD8B6,	{ 0xE5, 0x9B, 0x9F },
	0xD8B7,	{ 0xE8, 0x83, 0xA4 },
	0xD8B8,	{ 0xE9, 0xA6, 0x97 },
	0xD8B9,	{ 0xE6, 0xAF, 0x93 },
	0xD8BA,	{ 0xE7, 0x9D, 0xBE },
	0xD8BB,	{ 0xE9, 0xBC, 0x97 },
	0xD8BC,	{ 0xE4, 0xB8, 0xB6 },
	0xD8BD,	{ 0xE4, 0xBA, 0x9F },
	0xD8BE,	{ 0xE9, 0xBC, 0x90 },
	0xD8BF,	{ 0xE4, 0xB9, 0x9C },
	0xD8C0,	{ 0xE4, 0xB9, 0xA9 },
	0xD8C1,	{ 0xE4, 0xBA, 0x93 },
	0xD8C2,	{ 0xE8, 0x8A, 0x88 },
	0xD8C3,	{ 0xE5, 0xAD, 0x9B },
	0xD8C4,	{ 0xE5, 0x95, 0xAC },
	0xD8C5,	{ 0xE5, 0x98, 0x8F },
	0xD8C6,	{ 0xE4, 0xBB, 0x84 },
	0xD8C7,	{ 0xE5, 0x8E, 0x8D },
	0xD8C8,	{ 0xE5, 0x8E, 0x9D },
	0xD8C9,	{ 0xE5, 0x8E, 0xA3 },
	0xD8CA,	{ 0xE5, 0x8E, 0xA5 },
	0xD8CB,	{ 0xE5, 0x8E, 0xAE },
	0xD8CC,	{ 0xE9, 0x9D, 0xA5 },
	0xD8CD,	{ 0xE8, 0xB5, 0x9D },
	0xD8CE,	{ 0xE5, 0x8C, 0x9A },
	0xD8CF,	{ 0xE5, 0x8F, 0xB5 },
	0xD8D0,	{ 0xE5, 0x8C, 0xA6 },
	0xD8D1,	{ 0xE5, 0x8C, 0xAE },
	0xD8D2,	{ 0xE5, 0x8C, 0xBE },
	0xD8D3,	{ 0xE8, 0xB5, 0x9C },
	0xD8D4,	{ 0xE5, 0x8D, 0xA6 },
	0xD8D5,	{ 0xE5, 0x8D, 0xA3 },
	0xD8D6,	{ 0xE5, 0x88, 0x82 },
	0xD8D7,	{ 0xE5, 0x88, 0x88 },
	0xD8D8,	{ 0xE5, 0x88, 0x8E },
	0xD8D9,	{ 0xE5, 0x88, 0xAD },
	0xD8DA,	{ 0xE5, 0x88, 0xB3 },
	0xD8DB,	{ 0xE5, 0x88, 0xBF },
	0xD8DC,	{ 0xE5, 0x89, 0x80 },
	0xD8DD,	{ 0xE5, 0x89, 0x8C },
	0xD8DE,	{ 0xE5, 0x89, 0x9E },
	0xD8DF,	{ 0xE5, 0x89, 0xA1 },
	0xD8E0,	{ 0xE5, 0x89, 0x9C },
	0xD8E1,	{ 0xE8, 0x92, 0xAF },
	0xD8E2,	{ 0xE5, 0x89, 0xBD },
	0xD8E3,	{ 0xE5, 0x8A, 0x82 },
	0xD8E4,	{ 0xE5, 0x8A, 0x81 },
	0xD8E5,	{ 0xE5, 0x8A, 0x90 },
	0xD8E6,	{ 0xE5, 0x8A, 0x93 },
	0xD8E7,	{ 0xE5, 0x86, 0x82 },
	0xD8E8,	{ 0xE7, 0xBD, 0x94 },
	0xD8E9,	{ 0xE4, 0xBA, 0xBB },
	0xD8EA,	{ 0xE4, 0xBB, 0x83 },
	0xD8EB,	{ 0xE4, 0xBB, 0x89 },
	0xD8EC,	{ 0xE4, 0xBB, 0x82 },
	0xD8ED,	{ 0xE4, 0xBB, 0xA8 },
	0xD8EE,	{ 0xE4, 0xBB, 0xA1 },
	0xD8EF,	{ 0xE4, 0xBB, 0xAB },
	0xD8F0,	{ 0xE4, 0xBB, 0x9E },
	0xD8F1,	{ 0xE4, 0xBC, 0x9B },
	0xD8F2,	{ 0xE4, 0xBB, 0xB3 },
	0xD8F3,	{ 0xE4, 0xBC, 0xA2 },
	0xD8F4,	{ 0xE4, 0xBD, 0xA4 },
	0xD8F5,	{ 0xE4, 0xBB, 0xB5 },
	0xD8F6,	{ 0xE4, 0xBC, 0xA5 },
	0xD8F7,	{ 0xE4, 0xBC, 0xA7 },
	0xD8F8,	{ 0xE4, 0xBC, 0x89 },
	0xD8F9,	{ 0xE4, 0xBC, 0xAB },
	0xD8FA,	{ 0xE4, 0xBD, 0x9E },
	0xD8FB,	{ 0xE4, 0xBD, 0xA7 },
	0xD8FC,	{ 0xE6, 0x94, 0xB8 },
	0xD8FD,	{ 0xE4, 0xBD, 0x9A },
	0xD8FE,	{ 0xE4, 0xBD, 0x9D },
	0xD940,	{ 0xE8, 0xB2, 0xAE },
	0xD941,	{ 0xE8, 0xB2, 0xAF },
	0xD942,	{ 0xE8, 0xB2, 0xB0 },
	0xD943,	{ 0xE8, 0xB2, 0xB1 },
	0xD944,	{ 0xE8, 0xB2, 0xB2 },
	0xD945,	{ 0xE8, 0xB2, 0xB3 },
	0xD946,	{ 0xE8, 0xB2, 0xB4 },
	0xD947,	{ 0xE8, 0xB2, 0xB5 },
	0xD948,	{ 0xE8, 0xB2, 0xB6 },
	0xD949,	{ 0xE8, 0xB2, 0xB7 },
	0xD94A,	{ 0xE8, 0xB2, 0xB8 },
	0xD94B,	{ 0xE8, 0xB2, 0xB9 },
	0xD94C,	{ 0xE8, 0xB2, 0xBA },
	0xD94D,	{ 0xE8, 0xB2, 0xBB },
	0xD94E,	{ 0xE8, 0xB2, 0xBC },
	0xD94F,	{ 0xE8, 0xB2, 0xBD },
	0xD950,	{ 0xE8, 0xB2, 0xBE },
	0xD951,	{ 0xE8, 0xB2, 0xBF },
	0xD952,	{ 0xE8, 0xB3, 0x80 },
	0xD953,	{ 0xE8, 0xB3, 0x81 },
	0xD954,	{ 0xE8, 0xB3, 0x82 },
	0xD955,	{ 0xE8, 0xB3, 0x83 },
	0xD956,	{ 0xE8, 0xB3, 0x84 },
	0xD957,	{ 0xE8, 0xB3, 0x85 },
	0xD958,	{ 0xE8, 0xB3, 0x86 },
	0xD959,	{ 0xE8, 0xB3, 0x87 },
	0xD95A,	{ 0xE8, 0xB3, 0x88 },
	0xD95B,	{ 0xE8, 0xB3, 0x89 },
	0xD95C,	{ 0xE8, 0xB3, 0x8A },
	0xD95D,	{ 0xE8, 0xB3, 0x8B },
	0xD95E,	{ 0xE8, 0xB3, 0x8C },
	0xD95F,	{ 0xE8, 0xB3, 0x8D },
	0xD960,	{ 0xE8, 0xB3, 0x8E },
	0xD961,	{ 0xE8, 0xB3, 0x8F },
	0xD962,	{ 0xE8, 0xB3, 0x90 },
	0xD963,	{ 0xE8, 0xB3, 0x91 },
	0xD964,	{ 0xE8, 0xB3, 0x92 },
	0xD965,	{ 0xE8, 0xB3, 0x93 },
	0xD966,	{ 0xE8, 0xB3, 0x94 },
	0xD967,	{ 0xE8, 0xB3, 0x95 },
	0xD968,	{ 0xE8, 0xB3, 0x96 },
	0xD969,	{ 0xE8, 0xB3, 0x97 },
	0xD96A,	{ 0xE8, 0xB3, 0x98 },
	0xD96B,	{ 0xE8, 0xB3, 0x99 },
	0xD96C,	{ 0xE8, 0xB3, 0x9A },
	0xD96D,	{ 0xE8, 0xB3, 0x9B },
	0xD96E,	{ 0xE8, 0xB3, 0x9C },
	0xD96F,	{ 0xE8, 0xB3, 0x9D },
	0xD970,	{ 0xE8, 0xB3, 0x9E },
	0xD971,	{ 0xE8, 0xB3, 0x9F },
	0xD972,	{ 0xE8, 0xB3, 0xA0 },
	0xD973,	{ 0xE8, 0xB3, 0xA1 },
	0xD974,	{ 0xE8, 0xB3, 0xA2 },
	0xD975,	{ 0xE8, 0xB3, 0xA3 },
	0xD976,	{ 0xE8, 0xB3, 0xA4 },
	0xD977,	{ 0xE8, 0xB3, 0xA5 },
	0xD978,	{ 0xE8, 0xB3, 0xA6 },
	0xD979,	{ 0xE8, 0xB3, 0xA7 },
	0xD97A,	{ 0xE8, 0xB3, 0xA8 },
	0xD97B,	{ 0xE8, 0xB3, 0xA9 },
	0xD97C,	{ 0xE8, 0xB3, 0xAA },
	0xD97D,	{ 0xE8, 0xB3, 0xAB },
	0xD97E,	{ 0xE8, 0xB3, 0xAC },
	0xD980,	{ 0xE8, 0xB3, 0xAD },
	0xD981,	{ 0xE8, 0xB3, 0xAE },
	0xD982,	{ 0xE8, 0xB3, 0xAF },
	0xD983,	{ 0xE8, 0xB3, 0xB0 },
	0xD984,	{ 0xE8, 0xB3, 0xB1 },
	0xD985,	{ 0xE8, 0xB3, 0xB2 },
	0xD986,	{ 0xE8, 0xB3, 0xB3 },
	0xD987,	{ 0xE8, 0xB3, 0xB4 },
	0xD988,	{ 0xE8, 0xB3, 0xB5 },
	0xD989,	{ 0xE8, 0xB3, 0xB6 },
	0xD98A,	{ 0xE8, 0xB3, 0xB7 },
	0xD98B,	{ 0xE8, 0xB3, 0xB8 },
	0xD98C,	{ 0xE8, 0xB3, 0xB9 },
	0xD98D,	{ 0xE8, 0xB3, 0xBA },
	0xD98E,	{ 0xE8, 0xB3, 0xBB },
	0xD98F,	{ 0xE8, 0xB3, 0xBC },
	0xD990,	{ 0xE8, 0xB3, 0xBD },
	0xD991,	{ 0xE8, 0xB3, 0xBE },
	0xD992,	{ 0xE8, 0xB3, 0xBF },
	0xD993,	{ 0xE8, 0xB4, 0x80 },
	0xD994,	{ 0xE8, 0xB4, 0x81 },
	0xD995,	{ 0xE8, 0xB4, 0x82 },
	0xD996,	{ 0xE8, 0xB4, 0x83 },
	0xD997,	{ 0xE8, 0xB4, 0x84 },
	0xD998,	{ 0xE8, 0xB4, 0x85 },
	0xD999,	{ 0xE8, 0xB4, 0x86 },
	0xD99A,	{ 0xE8, 0xB4, 0x87 },
	0xD99B,	{ 0xE8, 0xB4, 0x88 },
	0xD99C,	{ 0xE8, 0xB4, 0x89 },
	0xD99D,	{ 0xE8, 0xB4, 0x8A },
	0xD99E,	{ 0xE8, 0xB4, 0x8B },
	0xD99F,	{ 0xE8, 0xB4, 0x8C },
	0xD9A0,	{ 0xE8, 0xB4, 0x8D },
	0xD9A1,	{ 0xE4, 0xBD, 0x9F },
	0xD9A2,	{ 0xE4, 0xBD, 0x97 },
	0xD9A3,	{ 0xE4, 0xBC, 0xB2 },
	0xD9A4,	{ 0xE4, 0xBC, 0xBD },
	0xD9A5,	{ 0xE4, 0xBD, 0xB6 },
	0xD9A6,	{ 0xE4, 0xBD, 0xB4 },
	0xD9A7,	{ 0xE4, 0xBE, 0x91 },
	0xD9A8,	{ 0xE4, 0xBE, 0x89 },
	0xD9A9,	{ 0xE4, 0xBE, 0x83 },
	0xD9AA,	{ 0xE4, 0xBE, 0x8F },
	0xD9AB,	{ 0xE4, 0xBD, 0xBE },
	0xD9AC,	{ 0xE4, 0xBD, 0xBB },
	0xD9AD,	{ 0xE4, 0xBE, 0xAA },
	0xD9AE,	{ 0xE4, 0xBD, 0xBC },
	0xD9AF,	{ 0xE4, 0xBE, 0xAC },
	0xD9B0,	{ 0xE4, 0xBE, 0x94 },
	0xD9B1,	{ 0xE4, 0xBF, 0xA6 },
	0xD9B2,	{ 0xE4, 0xBF, 0xA8 },
	0xD9B3,	{ 0xE4, 0xBF, 0xAA },
	0xD9B4,	{ 0xE4, 0xBF, 0x85 },
	0xD9B5,	{ 0xE4, 0xBF, 0x9A },
	0xD9B6,	{ 0xE4, 0xBF, 0xA3 },
	0xD9B7,	{ 0xE4, 0xBF, 0x9C },
	0xD9B8,	{ 0xE4, 0xBF, 0x91 },
	0xD9B9,	{ 0xE4, 0xBF, 0x9F },
	0xD9BA,	{ 0xE4, 0xBF, 0xB8 },
	0xD9BB,	{ 0xE5, 0x80, 0xA9 },
	0xD9BC,	{ 0xE5, 0x81, 0x8C },
	0xD9BD,	{ 0xE4, 0xBF, 0xB3 },
	0xD9BE,	{ 0xE5, 0x80, 0xAC },
	0xD9BF,	{ 0xE5, 0x80, 0x8F },
	0xD9C0,	{ 0xE5, 0x80, 0xAE },
	0xD9C1,	{ 0xE5, 0x80, 0xAD },
	0xD9C2,	{ 0xE4, 0xBF, 0xBE },
	0xD9C3,	{ 0xE5, 0x80, 0x9C },
	0xD9C4,	{ 0xE5, 0x80, 0x8C },
	0xD9C5,	{ 0xE5, 0x80, 0xA5 },
	0xD9C6,	{ 0xE5, 0x80, 0xA8 },
	0xD9C7,	{ 0xE5, 0x81, 0xBE },
	0xD9C8,	{ 0xE5, 0x81, 0x83 },
	0xD9C9,	{ 0xE5, 0x81, 0x95 },
	0xD9CA,	{ 0xE5, 0x81, 0x88 },
	0xD9CB,	{ 0xE5, 0x81, 0x8E },
	0xD9CC,	{ 0xE5, 0x81, 0xAC },
	0xD9CD,	{ 0xE5, 0x81, 0xBB },
	0xD9CE,	{ 0xE5, 0x82, 0xA5 },
	0xD9CF,	{ 0xE5, 0x82, 0xA7 },
	0xD9D0,	{ 0xE5, 0x82, 0xA9 },
	0xD9D1,	{ 0xE5, 0x82, 0xBA },
	0xD9D2,	{ 0xE5, 0x83, 0x96 },
	0xD9D3,	{ 0xE5, 0x84, 0x86 },
	0xD9D4,	{ 0xE5, 0x83, 0xAD },
	0xD9D5,	{ 0xE5, 0x83, 0xAC },
	0xD9D6,	{ 0xE5, 0x83, 0xA6 },
	0xD9D7,	{ 0xE5, 0x83, 0xAE },
	0xD9D8,	{ 0xE5, 0x84, 0x87 },
	0xD9D9,	{ 0xE5, 0x84, 0x8B },
	0xD9DA,	{ 0xE4, 0xBB, 0x9D },
	0xD9DB,	{ 0xE6, 0xB0, 0xBD },
	0xD9DC,	{ 0xE4, 0xBD, 0x98 },
	0xD9DD,	{ 0xE4, 0xBD, 0xA5 },
	0xD9DE,	{ 0xE4, 0xBF, 0x8E },
	0xD9DF,	{ 0xE9, 0xBE, 0xA0 },
	0xD9E0,	{ 0xE6, 0xB1, 0x86 },
	0xD9E1,	{ 0xE7, 0xB1, 0xB4 },
	0xD9E2,	{ 0xE5, 0x85, 0xAE },
	0xD9E3,	{ 0xE5, 0xB7, 0xBD },
	0xD9E4,	{ 0xE9, 0xBB, 0x89 },
	0xD9E5,	{ 0xE9, 0xA6, 0x98 },
	0xD9E6,	{ 0xE5, 0x86, 0x81 },
	0xD9E7,	{ 0xE5, 0xA4, 0x94 },
	0xD9E8,	{ 0xE5, 0x8B, 0xB9 },
	0xD9E9,	{ 0xE5, 0x8C, 0x8D },
	0xD9EA,	{ 0xE8, 0xA8, 0x87 },
	0xD9EB,	{ 0xE5, 0x8C, 0x90 },
	0xD9EC,	{ 0xE5, 0x87, 0xAB },
	0xD9ED,	{ 0xE5, 0xA4, 0x99 },
	0xD9EE,	{ 0xE5, 0x85, 0x95 },
	0xD9EF,	{ 0xE4, 0xBA, 0xA0 },
	0xD9F0,	{ 0xE5, 0x85, 0x96 },
	0xD9F1,	{ 0xE4, 0xBA, 0xB3 },
	0xD9F2,	{ 0xE8, 0xA1, 0xAE },
	0xD9F3,	{ 0xE8, 0xA2, 0xA4 },
	0xD9F4,	{ 0xE4, 0xBA, 0xB5 },
	0xD9F5,	{ 0xE8, 0x84, 0x94 },
	0xD9F6,	{ 0xE8, 0xA3, 0x92 },
	0xD9F7,	{ 0xE7, 0xA6, 0x80 },
	0xD9F8,	{ 0xE5, 0xAC, 0xB4 },
	0xD9F9,	{ 0xE8, 0xA0, 0x83 },
	0xD9FA,	{ 0xE7, 0xBE, 0xB8 },
	0xD9FB,	{ 0xE5, 0x86, 0xAB },
	0xD9FC,	{ 0xE5, 0x86, 0xB1 },
	0xD9FD,	{ 0xE5, 0x86, 0xBD },
	0xD9FE,	{ 0xE5, 0x86, 0xBC },
	0xDA40,	{ 0xE8, 0xB4, 0x8E },
	0xDA41,	{ 0xE8, 0xB4, 0x8F },
	0xDA42,	{ 0xE8, 0xB4, 0x90 },
	0xDA43,	{ 0xE8, 0xB4, 0x91 },
	0xDA44,	{ 0xE8, 0xB4, 0x92 },
	0xDA45,	{ 0xE8, 0xB4, 0x93 },
	0xDA46,	{ 0xE8, 0xB4, 0x94 },
	0xDA47,	{ 0xE8, 0xB4, 0x95 },
	0xDA48,	{ 0xE8, 0xB4, 0x96 },
	0xDA49,	{ 0xE8, 0xB4, 0x97 },
	0xDA4A,	{ 0xE8, 0xB4, 0x98 },
	0xDA4B,	{ 0xE8, 0xB4, 0x99 },
	0xDA4C,	{ 0xE8, 0xB4, 0x9A },
	0xDA4D,	{ 0xE8, 0xB4, 0x9B },
	0xDA4E,	{ 0xE8, 0xB4, 0x9C },
	0xDA4F,	{ 0xE8, 0xB4, 0xA0 },
	0xDA50,	{ 0xE8, 0xB5, 0x91 },
	0xDA51,	{ 0xE8, 0xB5, 0x92 },
	0xDA52,	{ 0xE8, 0xB5, 0x97 },
	0xDA53,	{ 0xE8, 0xB5, 0x9F },
	0xDA54,	{ 0xE8, 0xB5, 0xA5 },
	0xDA55,	{ 0xE8, 0xB5, 0xA8 },
	0xDA56,	{ 0xE8, 0xB5, 0xA9 },
	0xDA57,	{ 0xE8, 0xB5, 0xAA },
	0xDA58,	{ 0xE8, 0xB5, 0xAC },
	0xDA59,	{ 0xE8, 0xB5, 0xAE },
	0xDA5A,	{ 0xE8, 0xB5, 0xAF },
	0xDA5B,	{ 0xE8, 0xB5, 0xB1 },
	0xDA5C,	{ 0xE8, 0xB5, 0xB2 },
	0xDA5D,	{ 0xE8, 0xB5, 0xB8 },
	0xDA5E,	{ 0xE8, 0xB5, 0xB9 },
	0xDA5F,	{ 0xE8, 0xB5, 0xBA },
	0xDA60,	{ 0xE8, 0xB5, 0xBB },
	0xDA61,	{ 0xE8, 0xB5, 0xBC },
	0xDA62,	{ 0xE8, 0xB5, 0xBD },
	0xDA63,	{ 0xE8, 0xB5, 0xBE },
	0xDA64,	{ 0xE8, 0xB5, 0xBF },
	0xDA65,	{ 0xE8, 0xB6, 0x80 },
	0xDA66,	{ 0xE8, 0xB6, 0x82 },
	0xDA67,	{ 0xE8, 0xB6, 0x83 },
	0xDA68,	{ 0xE8, 0xB6, 0x86 },
	0xDA69,	{ 0xE8, 0xB6, 0x87 },
	0xDA6A,	{ 0xE8, 0xB6, 0x88 },
	0xDA6B,	{ 0xE8, 0xB6, 0x89 },
	0xDA6C,	{ 0xE8, 0xB6, 0x8C },
	0xDA6D,	{ 0xE8, 0xB6, 0x8D },
	0xDA6E,	{ 0xE8, 0xB6, 0x8E },
	0xDA6F,	{ 0xE8, 0xB6, 0x8F },
	0xDA70,	{ 0xE8, 0xB6, 0x90 },
	0xDA71,	{ 0xE8, 0xB6, 0x92 },
	0xDA72,	{ 0xE8, 0xB6, 0x93 },
	0xDA73,	{ 0xE8, 0xB6, 0x95 },
	0xDA74,	{ 0xE8, 0xB6, 0x96 },
	0xDA75,	{ 0xE8, 0xB6, 0x97 },
	0xDA76,	{ 0xE8, 0xB6, 0x98 },
	0xDA77,	{ 0xE8, 0xB6, 0x99 },
	0xDA78,	{ 0xE8, 0xB6, 0x9A },
	0xDA79,	{ 0xE8, 0xB6, 0x9B },
	0xDA7A,	{ 0xE8, 0xB6, 0x9C },
	0xDA7B,	{ 0xE8, 0xB6, 0x9D },
	0xDA7C,	{ 0xE8, 0xB6, 0x9E },
	0xDA7D,	{ 0xE8, 0xB6, 0xA0 },
	0xDA7E,	{ 0xE8, 0xB6, 0xA1 },
	0xDA80,	{ 0xE8, 0xB6, 0xA2 },
	0xDA81,	{ 0xE8, 0xB6, 0xA4 },
	0xDA82,	{ 0xE8, 0xB6, 0xA5 },
	0xDA83,	{ 0xE8, 0xB6, 0xA6 },
	0xDA84,	{ 0xE8, 0xB6, 0xA7 },
	0xDA85,	{ 0xE8, 0xB6, 0xA8 },
	0xDA86,	{ 0xE8, 0xB6, 0xA9 },
	0xDA87,	{ 0xE8, 0xB6, 0xAA },
	0xDA88,	{ 0xE8, 0xB6, 0xAB },
	0xDA89,	{ 0xE8, 0xB6, 0xAC },
	0xDA8A,	{ 0xE8, 0xB6, 0xAD },
	0xDA8B,	{ 0xE8, 0xB6, 0xAE },
	0xDA8C,	{ 0xE8, 0xB6, 0xAF },
	0xDA8D,	{ 0xE8, 0xB6, 0xB0 },
	0xDA8E,	{ 0xE8, 0xB6, 0xB2 },
	0xDA8F,	{ 0xE8, 0xB6, 0xB6 },
	0xDA90,	{ 0xE8, 0xB6, 0xB7 },
	0xDA91,	{ 0xE8, 0xB6, 0xB9 },
	0xDA92,	{ 0xE8, 0xB6, 0xBB },
	0xDA93,	{ 0xE8, 0xB6, 0xBD },
	0xDA94,	{ 0xE8, 0xB7, 0x80 },
	0xDA95,	{ 0xE8, 0xB7, 0x81 },
	0xDA96,	{ 0xE8, 0xB7, 0x82 },
	0xDA97,	{ 0xE8, 0xB7, 0x85 },
	0xDA98,	{ 0xE8, 0xB7, 0x87 },
	0xDA99,	{ 0xE8, 0xB7, 0x88 },
	0xDA9A,	{ 0xE8, 0xB7, 0x89 },
	0xDA9B,	{ 0xE8, 0xB7, 0x8A },
	0xDA9C,	{ 0xE8, 0xB7, 0x8D },
	0xDA9D,	{ 0xE8, 0xB7, 0x90 },
	0xDA9E,	{ 0xE8, 0xB7, 0x92 },
	0xDA9F,	{ 0xE8, 0xB7, 0x93 },
	0xDAA0,	{ 0xE8, 0xB7, 0x94 },
	0xDAA1,	{ 0xE5, 0x87, 0x87 },
	0xDAA2,	{ 0xE5, 0x86, 0x96 },
	0xDAA3,	{ 0xE5, 0x86, 0xA2 },
	0xDAA4,	{ 0xE5, 0x86, 0xA5 },
	0xDAA5,	{ 0xE8, 0xAE, 0xA0 },
	0xDAA6,	{ 0xE8, 0xAE, 0xA6 },
	0xDAA7,	{ 0xE8, 0xAE, 0xA7 },
	0xDAA8,	{ 0xE8, 0xAE, 0xAA },
	0xDAA9,	{ 0xE8, 0xAE, 0xB4 },
	0xDAAA,	{ 0xE8, 0xAE, 0xB5 },
	0xDAAB,	{ 0xE8, 0xAE, 0xB7 },
	0xDAAC,	{ 0xE8, 0xAF, 0x82 },
	0xDAAD,	{ 0xE8, 0xAF, 0x83 },
	0xDAAE,	{ 0xE8, 0xAF, 0x8B },
	0xDAAF,	{ 0xE8, 0xAF, 0x8F },
	0xDAB0,	{ 0xE8, 0xAF, 0x8E },
	0xDAB1,	{ 0xE8, 0xAF, 0x92 },
	0xDAB2,	{ 0xE8, 0xAF, 0x93 },
	0xDAB3,	{ 0xE8, 0xAF, 0x94 },
	0xDAB4,	{ 0xE8, 0xAF, 0x96 },
	0xDAB5,	{ 0xE8, 0xAF, 0x98 },
	0xDAB6,	{ 0xE8, 0xAF, 0x99 },
	0xDAB7,	{ 0xE8, 0xAF, 0x9C },
	0xDAB8,	{ 0xE8, 0xAF, 0x9F },
	0xDAB9,	{ 0xE8, 0xAF, 0xA0 },
	0xDABA,	{ 0xE8, 0xAF, 0xA4 },
	0xDABB,	{ 0xE8, 0xAF, 0xA8 },
	0xDABC,	{ 0xE8, 0xAF, 0xA9 },
	0xDABD,	{ 0xE8, 0xAF, 0xAE },
	0xDABE,	{ 0xE8, 0xAF, 0xB0 },
	0xDABF,	{ 0xE8, 0xAF, 0xB3 },
	0xDAC0,	{ 0xE8, 0xAF, 0xB6 },
	0xDAC1,	{ 0xE8, 0xAF, 0xB9 },
	0xDAC2,	{ 0xE8, 0xAF, 0xBC },
	0xDAC3,	{ 0xE8, 0xAF, 0xBF },
	0xDAC4,	{ 0xE8, 0xB0, 0x80 },
	0xDAC5,	{ 0xE8, 0xB0, 0x82 },
	0xDAC6,	{ 0xE8, 0xB0, 0x84 },
	0xDAC7,	{ 0xE8, 0xB0, 0x87 },
	0xDAC8,	{ 0xE8, 0xB0, 0x8C },
	0xDAC9,	{ 0xE8, 0xB0, 0x8F },
	0xDACA,	{ 0xE8, 0xB0, 0x91 },
	0xDACB,	{ 0xE8, 0xB0, 0x92 },
	0xDACC,	{ 0xE8, 0xB0, 0x94 },
	0xDACD,	{ 0xE8, 0xB0, 0x95 },
	0xDACE,	{ 0xE8, 0xB0, 0x96 },
	0xDACF,	{ 0xE8, 0xB0, 0x99 },
	0xDAD0,	{ 0xE8, 0xB0, 0x9B },
	0xDAD1,	{ 0xE8, 0xB0, 0x98 },
	0xDAD2,	{ 0xE8, 0xB0, 0x9D },
	0xDAD3,	{ 0xE8, 0xB0, 0x9F },
	0xDAD4,	{ 0xE8, 0xB0, 0xA0 },
	0xDAD5,	{ 0xE8, 0xB0, 0xA1 },
	0xDAD6,	{ 0xE8, 0xB0, 0xA5 },
	0xDAD7,	{ 0xE8, 0xB0, 0xA7 },
	0xDAD8,	{ 0xE8, 0xB0, 0xAA },
	0xDAD9,	{ 0xE8, 0xB0, 0xAB },
	0xDADA,	{ 0xE8, 0xB0, 0xAE },
	0xDADB,	{ 0xE8, 0xB0, 0xAF },
	0xDADC,	{ 0xE8, 0xB0, 0xB2 },
	0xDADD,	{ 0xE8, 0xB0, 0xB3 },
	0xDADE,	{ 0xE8, 0xB0, 0xB5 },
	0xDADF,	{ 0xE8, 0xB0, 0xB6 },
	0xDAE0,	{ 0xE5, 0x8D, 0xA9 },
	0xDAE1,	{ 0xE5, 0x8D, 0xBA },
	0xDAE2,	{ 0xE9, 0x98, 0x9D },
	0xDAE3,	{ 0xE9, 0x98, 0xA2 },
	0xDAE4,	{ 0xE9, 0x98, 0xA1 },
	0xDAE5,	{ 0xE9, 0x98, 0xB1 },
	0xDAE6,	{ 0xE9, 0x98, 0xAA },
	0xDAE7,	{ 0xE9, 0x98, 0xBD },
	0xDAE8,	{ 0xE9, 0x98, 0xBC },
	0xDAE9,	{ 0xE9, 0x99, 0x82 },
	0xDAEA,	{ 0xE9, 0x99, 0x89 },
	0xDAEB,	{ 0xE9, 0x99, 0x94 },
	0xDAEC,	{ 0xE9, 0x99, 0x9F },
	0xDAED,	{ 0xE9, 0x99, 0xA7 },
	0xDAEE,	{ 0xE9, 0x99, 0xAC },
	0xDAEF,	{ 0xE9, 0x99, 0xB2 },
	0xDAF0,	{ 0xE9, 0x99, 0xB4 },
	0xDAF1,	{ 0xE9, 0x9A, 0x88 },
	0xDAF2,	{ 0xE9, 0x9A, 0x8D },
	0xDAF3,	{ 0xE9, 0x9A, 0x97 },
	0xDAF4,	{ 0xE9, 0x9A, 0xB0 },
	0xDAF5,	{ 0xE9, 0x82, 0x97 },
	0xDAF6,	{ 0xE9, 0x82, 0x9B },
	0xDAF7,	{ 0xE9, 0x82, 0x9D },
	0xDAF8,	{ 0xE9, 0x82, 0x99 },
	0xDAF9,	{ 0xE9, 0x82, 0xAC },
	0xDAFA,	{ 0xE9, 0x82, 0xA1 },
	0xDAFB,	{ 0xE9, 0x82, 0xB4 },
	0xDAFC,	{ 0xE9, 0x82, 0xB3 },
	0xDAFD,	{ 0xE9, 0x82, 0xB6 },
	0xDAFE,	{ 0xE9, 0x82, 0xBA },
	0xDB40,	{ 0xE8, 0xB7, 0x95 },
	0xDB41,	{ 0xE8, 0xB7, 0x98 },
	0xDB42,	{ 0xE8, 0xB7, 0x99 },
	0xDB43,	{ 0xE8, 0xB7, 0x9C },
	0xDB44,	{ 0xE8, 0xB7, 0xA0 },
	0xDB45,	{ 0xE8, 0xB7, 0xA1 },
	0xDB46,	{ 0xE8, 0xB7, 0xA2 },
	0xDB47,	{ 0xE8, 0xB7, 0xA5 },
	0xDB48,	{ 0xE8, 0xB7, 0xA6 },
	0xDB49,	{ 0xE8, 0xB7, 0xA7 },
	0xDB4A,	{ 0xE8, 0xB7, 0xA9 },
	0xDB4B,	{ 0xE8, 0xB7, 0xAD },
	0xDB4C,	{ 0xE8, 0xB7, 0xAE },
	0xDB4D,	{ 0xE8, 0xB7, 0xB0 },
	0xDB4E,	{ 0xE8, 0xB7, 0xB1 },
	0xDB4F,	{ 0xE8, 0xB7, 0xB2 },
	0xDB50,	{ 0xE8, 0xB7, 0xB4 },
	0xDB51,	{ 0xE8, 0xB7, 0xB6 },
	0xDB52,	{ 0xE8, 0xB7, 0xBC },
	0xDB53,	{ 0xE8, 0xB7, 0xBE },
	0xDB54,	{ 0xE8, 0xB7, 0xBF },
	0xDB55,	{ 0xE8, 0xB8, 0x80 },
	0xDB56,	{ 0xE8, 0xB8, 0x81 },
	0xDB57,	{ 0xE8, 0xB8, 0x82 },
	0xDB58,	{ 0xE8, 0xB8, 0x83 },
	0xDB59,	{ 0xE8, 0xB8, 0x84 },
	0xDB5A,	{ 0xE8, 0xB8, 0x86 },
	0xDB5B,	{ 0xE8, 0xB8, 0x87 },
	0xDB5C,	{ 0xE8, 0xB8, 0x88 },
	0xDB5D,	{ 0xE8, 0xB8, 0x8B },
	0xDB5E,	{ 0xE8, 0xB8, 0x8D },
	0xDB5F,	{ 0xE8, 0xB8, 0x8E },
	0xDB60,	{ 0xE8, 0xB8, 0x90 },
	0xDB61,	{ 0xE8, 0xB8, 0x91 },
	0xDB62,	{ 0xE8, 0xB8, 0x92 },
	0xDB63,	{ 0xE8, 0xB8, 0x93 },
	0xDB64,	{ 0xE8, 0xB8, 0x95 },
	0xDB65,	{ 0xE8, 0xB8, 0x96 },
	0xDB66,	{ 0xE8, 0xB8, 0x97 },
	0xDB67,	{ 0xE8, 0xB8, 0x98 },
	0xDB68,	{ 0xE8, 0xB8, 0x99 },
	0xDB69,	{ 0xE8, 0xB8, 0x9A },
	0xDB6A,	{ 0xE8, 0xB8, 0x9B },
	0xDB6B,	{ 0xE8, 0xB8, 0x9C },
	0xDB6C,	{ 0xE8, 0xB8, 0xA0 },
	0xDB6D,	{ 0xE8, 0xB8, 0xA1 },
	0xDB6E,	{ 0xE8, 0xB8, 0xA4 },
	0xDB6F,	{ 0xE8, 0xB8, 0xA5 },
	0xDB70,	{ 0xE8, 0xB8, 0xA6 },
	0xDB71,	{ 0xE8, 0xB8, 0xA7 },
	0xDB72,	{ 0xE8, 0xB8, 0xA8 },
	0xDB73,	{ 0xE8, 0xB8, 0xAB },
	0xDB74,	{ 0xE8, 0xB8, 0xAD },
	0xDB75,	{ 0xE8, 0xB8, 0xB0 },
	0xDB76,	{ 0xE8, 0xB8, 0xB2 },
	0xDB77,	{ 0xE8, 0xB8, 0xB3 },
	0xDB78,	{ 0xE8, 0xB8, 0xB4 },
	0xDB79,	{ 0xE8, 0xB8, 0xB6 },
	0xDB7A,	{ 0xE8, 0xB8, 0xB7 },
	0xDB7B,	{ 0xE8, 0xB8, 0xB8 },
	0xDB7C,	{ 0xE8, 0xB8, 0xBB },
	0xDB7D,	{ 0xE8, 0xB8, 0xBC },
	0xDB7E,	{ 0xE8, 0xB8, 0xBE },
	0xDB80,	{ 0xE8, 0xB8, 0xBF },
	0xDB81,	{ 0xE8, 0xB9, 0x83 },
	0xDB82,	{ 0xE8, 0xB9, 0x85 },
	0xDB83,	{ 0xE8, 0xB9, 0x86 },
	0xDB84,	{ 0xE8, 0xB9, 0x8C },
	0xDB85,	{ 0xE8, 0xB9, 0x8D },
	0xDB86,	{ 0xE8, 0xB9, 0x8E },
	0xDB87,	{ 0xE8, 0xB9, 0x8F },
	0xDB88,	{ 0xE8, 0xB9, 0x90 },
	0xDB89,	{ 0xE8, 0xB9, 0x93 },
	0xDB8A,	{ 0xE8, 0xB9, 0x94 },
	0xDB8B,	{ 0xE8, 0xB9, 0x95 },
	0xDB8C,	{ 0xE8, 0xB9, 0x96 },
	0xDB8D,	{ 0xE8, 0xB9, 0x97 },
	0xDB8E,	{ 0xE8, 0xB9, 0x98 },
	0xDB8F,	{ 0xE8, 0xB9, 0x9A },
	0xDB90,	{ 0xE8, 0xB9, 0x9B },
	0xDB91,	{ 0xE8, 0xB9, 0x9C },
	0xDB92,	{ 0xE8, 0xB9, 0x9D },
	0xDB93,	{ 0xE8, 0xB9, 0x9E },
	0xDB94,	{ 0xE8, 0xB9, 0x9F },
	0xDB95,	{ 0xE8, 0xB9, 0xA0 },
	0xDB96,	{ 0xE8, 0xB9, 0xA1 },
	0xDB97,	{ 0xE8, 0xB9, 0xA2 },
	0xDB98,	{ 0xE8, 0xB9, 0xA3 },
	0xDB99,	{ 0xE8, 0xB9, 0xA4 },
	0xDB9A,	{ 0xE8, 0xB9, 0xA5 },
	0xDB9B,	{ 0xE8, 0xB9, 0xA7 },
	0xDB9C,	{ 0xE8, 0xB9, 0xA8 },
	0xDB9D,	{ 0xE8, 0xB9, 0xAA },
	0xDB9E,	{ 0xE8, 0xB9, 0xAB },
	0xDB9F,	{ 0xE8, 0xB9, 0xAE },
	0xDBA0,	{ 0xE8, 0xB9, 0xB1 },
	0xDBA1,	{ 0xE9, 0x82, 0xB8 },
	0xDBA2,	{ 0xE9, 0x82, 0xB0 },
	0xDBA3,	{ 0xE9, 0x83, 0x8F },
	0xDBA4,	{ 0xE9, 0x83, 0x85 },
	0xDBA5,	{ 0xE9, 0x82, 0xBE },
	0xDBA6,	{ 0xE9, 0x83, 0x90 },
	0xDBA7,	{ 0xE9, 0x83, 0x84 },
	0xDBA8,	{ 0xE9, 0x83, 0x87 },
	0xDBA9,	{ 0xE9, 0x83, 0x93 },
	0xDBAA,	{ 0xE9, 0x83, 0xA6 },
	0xDBAB,	{ 0xE9, 0x83, 0xA2 },
	0xDBAC,	{ 0xE9, 0x83, 0x9C },
	0xDBAD,	{ 0xE9, 0x83, 0x97 },
	0xDBAE,	{ 0xE9, 0x83, 0x9B },
	0xDBAF,	{ 0xE9, 0x83, 0xAB },
	0xDBB0,	{ 0xE9, 0x83, 0xAF },
	0xDBB1,	{ 0xE9, 0x83, 0xBE },
	0xDBB2,	{ 0xE9, 0x84, 0x84 },
	0xDBB3,	{ 0xE9, 0x84, 0xA2 },
	0xDBB4,	{ 0xE9, 0x84, 0x9E },
	0xDBB5,	{ 0xE9, 0x84, 0xA3 },
	0xDBB6,	{ 0xE9, 0x84, 0xB1 },
	0xDBB7,	{ 0xE9, 0x84, 0xAF },
	0xDBB8,	{ 0xE9, 0x84, 0xB9 },
	0xDBB9,	{ 0xE9, 0x85, 0x83 },
	0xDBBA,	{ 0xE9, 0x85, 0x86 },
	0xDBBB,	{ 0xE5, 0x88, 0x8D },
	0xDBBC,	{ 0xE5, 0xA5, 0x82 },
	0xDBBD,	{ 0xE5, 0x8A, 0xA2 },
	0xDBBE,	{ 0xE5, 0x8A, 0xAC },
	0xDBBF,	{ 0xE5, 0x8A, 0xAD },
	0xDBC0,	{ 0xE5, 0x8A, 0xBE },
	0xDBC1,	{ 0xE5, 0x93, 0xBF },
	0xDBC2,	{ 0xE5, 0x8B, 0x90 },
	0xDBC3,	{ 0xE5, 0x8B, 0x96 },
	0xDBC4,	{ 0xE5, 0x8B, 0xB0 },
	0xDBC5,	{ 0xE5, 0x8F, 0x9F },
	0xDBC6,	{ 0xE7, 0x87, 0xAE },
	0xDBC7,	{ 0xE7, 0x9F, 0x8D },
	0xDBC8,	{ 0xE5, 0xBB, 0xB4 },
	0xDBC9,	{ 0xE5, 0x87, 0xB5 },
	0xDBCA,	{ 0xE5, 0x87, 0xBC },
	0xDBCB,	{ 0xE9, 0xAC, 0xAF },
	0xDBCC,	{ 0xE5, 0x8E, 0xB6 },
	0xDBCD,	{ 0xE5, 0xBC, 0x81 },
	0xDBCE,	{ 0xE7, 0x95, 0x9A },
	0xDBCF,	{ 0xE5, 0xB7, 0xAF },
	0xDBD0,	{ 0xE5, 0x9D, 0x8C },
	0xDBD1,	{ 0xE5, 0x9E, 0xA9 },
	0xDBD2,	{ 0xE5, 0x9E, 0xA1 },
	0xDBD3,	{ 0xE5, 0xA1, 0xBE },
	0xDBD4,	{ 0xE5, 0xA2, 0xBC },
	0xDBD5,	{ 0xE5, 0xA3, 0x85 },
	0xDBD6,	{ 0xE5, 0xA3, 0x91 },
	0xDBD7,	{ 0xE5, 0x9C, 0xA9 },
	0xDBD8,	{ 0xE5, 0x9C, 0xAC },
	0xDBD9,	{ 0xE5, 0x9C, 0xAA },
	0xDBDA,	{ 0xE5, 0x9C, 0xB3 },
	0xDBDB,	{ 0xE5, 0x9C, 0xB9 },
	0xDBDC,	{ 0xE5, 0x9C, 0xAE },
	0xDBDD,	{ 0xE5, 0x9C, 0xAF },
	0xDBDE,	{ 0xE5, 0x9D, 0x9C },
	0xDBDF,	{ 0xE5, 0x9C, 0xBB },
	0xDBE0,	{ 0xE5, 0x9D, 0x82 },
	0xDBE1,	{ 0xE5, 0x9D, 0xA9 },
	0xDBE2,	{ 0xE5, 0x9E, 0x85 },
	0xDBE3,	{ 0xE5, 0x9D, 0xAB },
	0xDBE4,	{ 0xE5, 0x9E, 0x86 },
	0xDBE5,	{ 0xE5, 0x9D, 0xBC },
	0xDBE6,	{ 0xE5, 0x9D, 0xBB },
	0xDBE7,	{ 0xE5, 0x9D, 0xA8 },
	0xDBE8,	{ 0xE5, 0x9D, 0xAD },
	0xDBE9,	{ 0xE5, 0x9D, 0xB6 },
	0xDBEA,	{ 0xE5, 0x9D, 0xB3 },
	0xDBEB,	{ 0xE5, 0x9E, 0xAD },
	0xDBEC,	{ 0xE5, 0x9E, 0xA4 },
	0xDBED,	{ 0xE5, 0x9E, 0x8C },
	0xDBEE,	{ 0xE5, 0x9E, 0xB2 },
	0xDBEF,	{ 0xE5, 0x9F, 0x8F },
	0xDBF0,	{ 0xE5, 0x9E, 0xA7 },
	0xDBF1,	{ 0xE5, 0x9E, 0xB4 },
	0xDBF2,	{ 0xE5, 0x9E, 0x93 },
	0xDBF3,	{ 0xE5, 0x9E, 0xA0 },
	0xDBF4,	{ 0xE5, 0x9F, 0x95 },
	0xDBF5,	{ 0xE5, 0x9F, 0x98 },
	0xDBF6,	{ 0xE5, 0x9F, 0x9A },
	0xDBF7,	{ 0xE5, 0x9F, 0x99 },
	0xDBF8,	{ 0xE5, 0x9F, 0x92 },
	0xDBF9,	{ 0xE5, 0x9E, 0xB8 },
	0xDBFA,	{ 0xE5, 0x9F, 0xB4 },
	0xDBFB,	{ 0xE5, 0x9F, 0xAF },
	0xDBFC,	{ 0xE5, 0x9F, 0xB8 },
	0xDBFD,	{ 0xE5, 0x9F, 0xA4 },
	0xDBFE,	{ 0xE5, 0x9F, 0x9D },
	0xDC40,	{ 0xE8, 0xB9, 0xB3 },
	0xDC41,	{ 0xE8, 0xB9, 0xB5 },
	0xDC42,	{ 0xE8, 0xB9, 0xB7 },
	0xDC43,	{ 0xE8, 0xB9, 0xB8 },
	0xDC44,	{ 0xE8, 0xB9, 0xB9 },
	0xDC45,	{ 0xE8, 0xB9, 0xBA },
	0xDC46,	{ 0xE8, 0xB9, 0xBB },
	0xDC47,	{ 0xE8, 0xB9, 0xBD },
	0xDC48,	{ 0xE8, 0xB9, 0xBE },
	0xDC49,	{ 0xE8, 0xBA, 0x80 },
	0xDC4A,	{ 0xE8, 0xBA, 0x82 },
	0xDC4B,	{ 0xE8, 0xBA, 0x83 },
	0xDC4C,	{ 0xE8, 0xBA, 0x84 },
	0xDC4D,	{ 0xE8, 0xBA, 0x86 },
	0xDC4E,	{ 0xE8, 0xBA, 0x88 },
	0xDC4F,	{ 0xE8, 0xBA, 0x89 },
	0xDC50,	{ 0xE8, 0xBA, 0x8A },
	0xDC51,	{ 0xE8, 0xBA, 0x8B },
	0xDC52,	{ 0xE8, 0xBA, 0x8C },
	0xDC53,	{ 0xE8, 0xBA, 0x8D },
	0xDC54,	{ 0xE8, 0xBA, 0x8E },
	0xDC55,	{ 0xE8, 0xBA, 0x91 },
	0xDC56,	{ 0xE8, 0xBA, 0x92 },
	0xDC57,	{ 0xE8, 0xBA, 0x93 },
	0xDC58,	{ 0xE8, 0xBA, 0x95 },
	0xDC59,	{ 0xE8, 0xBA, 0x96 },
	0xDC5A,	{ 0xE8, 0xBA, 0x97 },
	0xDC5B,	{ 0xE8, 0xBA, 0x98 },
	0xDC5C,	{ 0xE8, 0xBA, 0x99 },
	0xDC5D,	{ 0xE8, 0xBA, 0x9A },
	0xDC5E,	{ 0xE8, 0xBA, 0x9B },
	0xDC5F,	{ 0xE8, 0xBA, 0x9D },
	0xDC60,	{ 0xE8, 0xBA, 0x9F },
	0xDC61,	{ 0xE8, 0xBA, 0xA0 },
	0xDC62,	{ 0xE8, 0xBA, 0xA1 },
	0xDC63,	{ 0xE8, 0xBA, 0xA2 },
	0xDC64,	{ 0xE8, 0xBA, 0xA3 },
	0xDC65,	{ 0xE8, 0xBA, 0xA4 },
	0xDC66,	{ 0xE8, 0xBA, 0xA5 },
	0xDC67,	{ 0xE8, 0xBA, 0xA6 },
	0xDC68,	{ 0xE8, 0xBA, 0xA7 },
	0xDC69,	{ 0xE8, 0xBA, 0xA8 },
	0xDC6A,	{ 0xE8, 0xBA, 0xA9 },
	0xDC6B,	{ 0xE8, 0xBA, 0xAA },
	0xDC6C,	{ 0xE8, 0xBA, 0xAD },
	0xDC6D,	{ 0xE8, 0xBA, 0xAE },
	0xDC6E,	{ 0xE8, 0xBA, 0xB0 },
	0xDC6F,	{ 0xE8, 0xBA, 0xB1 },
	0xDC70,	{ 0xE8, 0xBA, 0xB3 },
	0xDC71,	{ 0xE8, 0xBA, 0xB4 },
	0xDC72,	{ 0xE8, 0xBA, 0xB5 },
	0xDC73,	{ 0xE8, 0xBA, 0xB6 },
	0xDC74,	{ 0xE8, 0xBA, 0xB7 },
	0xDC75,	{ 0xE8, 0xBA, 0xB8 },
	0xDC76,	{ 0xE8, 0xBA, 0xB9 },
	0xDC77,	{ 0xE8, 0xBA, 0xBB },
	0xDC78,	{ 0xE8, 0xBA, 0xBC },
	0xDC79,	{ 0xE8, 0xBA, 0xBD },
	0xDC7A,	{ 0xE8, 0xBA, 0xBE },
	0xDC7B,	{ 0xE8, 0xBA, 0xBF },
	0xDC7C,	{ 0xE8, 0xBB, 0x80 },
	0xDC7D,	{ 0xE8, 0xBB, 0x81 },
	0xDC7E,	{ 0xE8, 0xBB, 0x82 },
	0xDC80,	{ 0xE8, 0xBB, 0x83 },
	0xDC81,	{ 0xE8, 0xBB, 0x84 },
	0xDC82,	{ 0xE8, 0xBB, 0x85 },
	0xDC83,	{ 0xE8, 0xBB, 0x86 },
	0xDC84,	{ 0xE8, 0xBB, 0x87 },
	0xDC85,	{ 0xE8, 0xBB, 0x88 },
	0xDC86,	{ 0xE8, 0xBB, 0x89 },
	0xDC87,	{ 0xE8, 0xBB, 0x8A },
	0xDC88,	{ 0xE8, 0xBB, 0x8B },
	0xDC89,	{ 0xE8, 0xBB, 0x8C },
	0xDC8A,	{ 0xE8, 0xBB, 0x8D },
	0xDC8B,	{ 0xE8, 0xBB, 0x8F },
	0xDC8C,	{ 0xE8, 0xBB, 0x90 },
	0xDC8D,	{ 0xE8, 0xBB, 0x91 },
	0xDC8E,	{ 0xE8, 0xBB, 0x92 },
	0xDC8F,	{ 0xE8, 0xBB, 0x93 },
	0xDC90,	{ 0xE8, 0xBB, 0x94 },
	0xDC91,	{ 0xE8, 0xBB, 0x95 },
	0xDC92,	{ 0xE8, 0xBB, 0x96 },
	0xDC93,	{ 0xE8, 0xBB, 0x97 },
	0xDC94,	{ 0xE8, 0xBB, 0x98 },
	0xDC95,	{ 0xE8, 0xBB, 0x99 },
	0xDC96,	{ 0xE8, 0xBB, 0x9A },
	0xDC97,	{ 0xE8, 0xBB, 0x9B },
	0xDC98,	{ 0xE8, 0xBB, 0x9C },
	0xDC99,	{ 0xE8, 0xBB, 0x9D },
	0xDC9A,	{ 0xE8, 0xBB, 0x9E },
	0xDC9B,	{ 0xE8, 0xBB, 0x9F },
	0xDC9C,	{ 0xE8, 0xBB, 0xA0 },
	0xDC9D,	{ 0xE8, 0xBB, 0xA1 },
	0xDC9E,	{ 0xE8, 0xBB, 0xA2 },
	0xDC9F,	{ 0xE8, 0xBB, 0xA3 },
	0xDCA0,	{ 0xE8, 0xBB, 0xA4 },
	0xDCA1,	{ 0xE5, 0xA0, 0x8B },
	0xDCA2,	{ 0xE5, 0xA0, 0x8D },
	0xDCA3,	{ 0xE5, 0x9F, 0xBD },
	0xDCA4,	{ 0xE5, 0x9F, 0xAD },
	0xDCA5,	{ 0xE5, 0xA0, 0x80 },
	0xDCA6,	{ 0xE5, 0xA0, 0x9E },
	0xDCA7,	{ 0xE5, 0xA0, 0x99 },
	0xDCA8,	{ 0xE5, 0xA1, 0x84 },
	0xDCA9,	{ 0xE5, 0xA0, 0xA0 },
	0xDCAA,	{ 0xE5, 0xA1, 0xA5 },
	0xDCAB,	{ 0xE5, 0xA1, 0xAC },
	0xDCAC,	{ 0xE5, 0xA2, 0x81 },
	0xDCAD,	{ 0xE5, 0xA2, 0x89 },
	0xDCAE,	{ 0xE5, 0xA2, 0x9A },
	0xDCAF,	{ 0xE5, 0xA2, 0x80 },
	0xDCB0,	{ 0xE9, 0xA6, 0xA8 },
	0xDCB1,	{ 0xE9, 0xBC, 0x99 },
	0xDCB2,	{ 0xE6, 0x87, 0xBF },
	0xDCB3,	{ 0xE8, 0x89, 0xB9 },
	0xDCB4,	{ 0xE8, 0x89, 0xBD },
	0xDCB5,	{ 0xE8, 0x89, 0xBF },
	0xDCB6,	{ 0xE8, 0x8A, 0x8F },
	0xDCB7,	{ 0xE8, 0x8A, 0x8A },
	0xDCB8,	{ 0xE8, 0x8A, 0xA8 },
	0xDCB9,	{ 0xE8, 0x8A, 0x84 },
	0xDCBA,	{ 0xE8, 0x8A, 0x8E },
	0xDCBB,	{ 0xE8, 0x8A, 0x91 },
	0xDCBC,	{ 0xE8, 0x8A, 0x97 },
	0xDCBD,	{ 0xE8, 0x8A, 0x99 },
	0xDCBE,	{ 0xE8, 0x8A, 0xAB },
	0xDCBF,	{ 0xE8, 0x8A, 0xB8 },
	0xDCC0,	{ 0xE8, 0x8A, 0xBE },
	0xDCC1,	{ 0xE8, 0x8A, 0xB0 },
	0xDCC2,	{ 0xE8, 0x8B, 0x88 },
	0xDCC3,	{ 0xE8, 0x8B, 0x8A },
	0xDCC4,	{ 0xE8, 0x8B, 0xA3 },
	0xDCC5,	{ 0xE8, 0x8A, 0x98 },
	0xDCC6,	{ 0xE8, 0x8A, 0xB7 },
	0xDCC7,	{ 0xE8, 0x8A, 0xAE },
	0xDCC8,	{ 0xE8, 0x8B, 0x8B },
	0xDCC9,	{ 0xE8, 0x8B, 0x8C },
	0xDCCA,	{ 0xE8, 0x8B, 0x81 },
	0xDCCB,	{ 0xE8, 0x8A, 0xA9 },
	0xDCCC,	{ 0xE8, 0x8A, 0xB4 },
	0xDCCD,	{ 0xE8, 0x8A, 0xA1 },
	0xDCCE,	{ 0xE8, 0x8A, 0xAA },
	0xDCCF,	{ 0xE8, 0x8A, 0x9F },
	0xDCD0,	{ 0xE8, 0x8B, 0x84 },
	0xDCD1,	{ 0xE8, 0x8B, 0x8E },
	0xDCD2,	{ 0xE8, 0x8A, 0xA4 },
	0xDCD3,	{ 0xE8, 0x8B, 0xA1 },
	0xDCD4,	{ 0xE8, 0x8C, 0x89 },
	0xDCD5,	{ 0xE8, 0x8B, 0xB7 },
	0xDCD6,	{ 0xE8, 0x8B, 0xA4 },
	0xDCD7,	{ 0xE8, 0x8C, 0x8F },
	0xDCD8,	{ 0xE8, 0x8C, 0x87 },
	0xDCD9,	{ 0xE8, 0x8B, 0x9C },
	0xDCDA,	{ 0xE8, 0x8B, 0xB4 },
	0xDCDB,	{ 0xE8, 0x8B, 0x92 },
	0xDCDC,	{ 0xE8, 0x8B, 0x98 },
	0xDCDD,	{ 0xE8, 0x8C, 0x8C },
	0xDCDE,	{ 0xE8, 0x8B, 0xBB },
	0xDCDF,	{ 0xE8, 0x8B, 0x93 },
	0xDCE0,	{ 0xE8, 0x8C, 0x91 },
	0xDCE1,	{ 0xE8, 0x8C, 0x9A },
	0xDCE2,	{ 0xE8, 0x8C, 0x86 },
	0xDCE3,	{ 0xE8, 0x8C, 0x94 },
	0xDCE4,	{ 0xE8, 0x8C, 0x95 },
	0xDCE5,	{ 0xE8, 0x8B, 0xA0 },
	0xDCE6,	{ 0xE8, 0x8B, 0x95 },
	0xDCE7,	{ 0xE8, 0x8C, 0x9C },
	0xDCE8,	{ 0xE8, 0x8D, 0x91 },
	0xDCE9,	{ 0xE8, 0x8D, 0x9B },
	0xDCEA,	{ 0xE8, 0x8D, 0x9C },
	0xDCEB,	{ 0xE8, 0x8C, 0x88 },
	0xDCEC,	{ 0xE8, 0x8E, 0x92 },
	0xDCED,	{ 0xE8, 0x8C, 0xBC },
	0xDCEE,	{ 0xE8, 0x8C, 0xB4 },
	0xDCEF,	{ 0xE8, 0x8C, 0xB1 },
	0xDCF0,	{ 0xE8, 0x8E, 0x9B },
	0xDCF1,	{ 0xE8, 0x8D, 0x9E },
	0xDCF2,	{ 0xE8, 0x8C, 0xAF },
	0xDCF3,	{ 0xE8, 0x8D, 0x8F },
	0xDCF4,	{ 0xE8, 0x8D, 0x87 },
	0xDCF5,	{ 0xE8, 0x8D, 0x83 },
	0xDCF6,	{ 0xE8, 0x8D, 0x9F },
	0xDCF7,	{ 0xE8, 0x8D, 0x80 },
	0xDCF8,	{ 0xE8, 0x8C, 0x97 },
	0xDCF9,	{ 0xE8, 0x8D, 0xA0 },
	0xDCFA,	{ 0xE8, 0x8C, 0xAD },
	0xDCFB,	{ 0xE8, 0x8C, 0xBA },
	0xDCFC,	{ 0xE8, 0x8C, 0xB3 },
	0xDCFD,	{ 0xE8, 0x8D, 0xA6 },
	0xDCFE,	{ 0xE8, 0x8D, 0xA5 },
	0xDD40,	{ 0xE8, 0xBB, 0xA5 },
	0xDD41,	{ 0xE8, 0xBB, 0xA6 },
	0xDD42,	{ 0xE8, 0xBB, 0xA7 },
	0xDD43,	{ 0xE8, 0xBB, 0xA8 },
	0xDD44,	{ 0xE8, 0xBB, 0xA9 },
	0xDD45,	{ 0xE8, 0xBB, 0xAA },
	0xDD46,	{ 0xE8, 0xBB, 0xAB },
	0xDD47,	{ 0xE8, 0xBB, 0xAC },
	0xDD48,	{ 0xE8, 0xBB, 0xAD },
	0xDD49,	{ 0xE8, 0xBB, 0xAE },
	0xDD4A,	{ 0xE8, 0xBB, 0xAF },
	0xDD4B,	{ 0xE8, 0xBB, 0xB0 },
	0xDD4C,	{ 0xE8, 0xBB, 0xB1 },
	0xDD4D,	{ 0xE8, 0xBB, 0xB2 },
	0xDD4E,	{ 0xE8, 0xBB, 0xB3 },
	0xDD4F,	{ 0xE8, 0xBB, 0xB4 },
	0xDD50,	{ 0xE8, 0xBB, 0xB5 },
	0xDD51,	{ 0xE8, 0xBB, 0xB6 },
	0xDD52,	{ 0xE8, 0xBB, 0xB7 },
	0xDD53,	{ 0xE8, 0xBB, 0xB8 },
	0xDD54,	{ 0xE8, 0xBB, 0xB9 },
	0xDD55,	{ 0xE8, 0xBB, 0xBA },
	0xDD56,	{ 0xE8, 0xBB, 0xBB },
	0xDD57,	{ 0xE8, 0xBB, 0xBC },
	0xDD58,	{ 0xE8, 0xBB, 0xBD },
	0xDD59,	{ 0xE8, 0xBB, 0xBE },
	0xDD5A,	{ 0xE8, 0xBB, 0xBF },
	0xDD5B,	{ 0xE8, 0xBC, 0x80 },
	0xDD5C,	{ 0xE8, 0xBC, 0x81 },
	0xDD5D,	{ 0xE8, 0xBC, 0x82 },
	0xDD5E,	{ 0xE8, 0xBC, 0x83 },
	0xDD5F,	{ 0xE8, 0xBC, 0x84 },
	0xDD60,	{ 0xE8, 0xBC, 0x85 },
	0xDD61,	{ 0xE8, 0xBC, 0x86 },
	0xDD62,	{ 0xE8, 0xBC, 0x87 },
	0xDD63,	{ 0xE8, 0xBC, 0x88 },
	0xDD64,	{ 0xE8, 0xBC, 0x89 },
	0xDD65,	{ 0xE8, 0xBC, 0x8A },
	0xDD66,	{ 0xE8, 0xBC, 0x8B },
	0xDD67,	{ 0xE8, 0xBC, 0x8C },
	0xDD68,	{ 0xE8, 0xBC, 0x8D },
	0xDD69,	{ 0xE8, 0xBC, 0x8E },
	0xDD6A,	{ 0xE8, 0xBC, 0x8F },
	0xDD6B,	{ 0xE8, 0xBC, 0x90 },
	0xDD6C,	{ 0xE8, 0xBC, 0x91 },
	0xDD6D,	{ 0xE8, 0xBC, 0x92 },
	0xDD6E,	{ 0xE8, 0xBC, 0x93 },
	0xDD6F,	{ 0xE8, 0xBC, 0x94 },
	0xDD70,	{ 0xE8, 0xBC, 0x95 },
	0xDD71,	{ 0xE8, 0xBC, 0x96 },
	0xDD72,	{ 0xE8, 0xBC, 0x97 },
	0xDD73,	{ 0xE8, 0xBC, 0x98 },
	0xDD74,	{ 0xE8, 0xBC, 0x99 },
	0xDD75,	{ 0xE8, 0xBC, 0x9A },
	0xDD76,	{ 0xE8, 0xBC, 0x9B },
	0xDD77,	{ 0xE8, 0xBC, 0x9C },
	0xDD78,	{ 0xE8, 0xBC, 0x9D },
	0xDD79,	{ 0xE8, 0xBC, 0x9E },
	0xDD7A,	{ 0xE8, 0xBC, 0x9F },
	0xDD7B,	{ 0xE8, 0xBC, 0xA0 },
	0xDD7C,	{ 0xE8, 0xBC, 0xA1 },
	0xDD7D,	{ 0xE8, 0xBC, 0xA2 },
	0xDD7E,	{ 0xE8, 0xBC, 0xA3 },
	0xDD80,	{ 0xE8, 0xBC, 0xA4 },
	0xDD81,	{ 0xE8, 0xBC, 0xA5 },
	0xDD82,	{ 0xE8, 0xBC, 0xA6 },
	0xDD83,	{ 0xE8, 0xBC, 0xA7 },
	0xDD84,	{ 0xE8, 0xBC, 0xA8 },
	0xDD85,	{ 0xE8, 0xBC, 0xA9 },
	0xDD86,	{ 0xE8, 0xBC, 0xAA },
	0xDD87,	{ 0xE8, 0xBC, 0xAB },
	0xDD88,	{ 0xE8, 0xBC, 0xAC },
	0xDD89,	{ 0xE8, 0xBC, 0xAD },
	0xDD8A,	{ 0xE8, 0xBC, 0xAE },
	0xDD8B,	{ 0xE8, 0xBC, 0xAF },
	0xDD8C,	{ 0xE8, 0xBC, 0xB0 },
	0xDD8D,	{ 0xE8, 0xBC, 0xB1 },
	0xDD8E,	{ 0xE8, 0xBC, 0xB2 },
	0xDD8F,	{ 0xE8, 0xBC, 0xB3 },
	0xDD90,	{ 0xE8, 0xBC, 0xB4 },
	0xDD91,	{ 0xE8, 0xBC, 0xB5 },
	0xDD92,	{ 0xE8, 0xBC, 0xB6 },
	0xDD93,	{ 0xE8, 0xBC, 0xB7 },
	0xDD94,	{ 0xE8, 0xBC, 0xB8 },
	0xDD95,	{ 0xE8, 0xBC, 0xB9 },
	0xDD96,	{ 0xE8, 0xBC, 0xBA },
	0xDD97,	{ 0xE8, 0xBC, 0xBB },
	0xDD98,	{ 0xE8, 0xBC, 0xBC },
	0xDD99,	{ 0xE8, 0xBC, 0xBD },
	0xDD9A,	{ 0xE8, 0xBC, 0xBE },
	0xDD9B,	{ 0xE8, 0xBC, 0xBF },
	0xDD9C,	{ 0xE8, 0xBD, 0x80 },
	0xDD9D,	{ 0xE8, 0xBD, 0x81 },
	0xDD9E,	{ 0xE8, 0xBD, 0x82 },
	0xDD9F,	{ 0xE8, 0xBD, 0x83 },
	0xDDA0,	{ 0xE8, 0xBD, 0x84 },
	0xDDA1,	{ 0xE8, 0x8D, 0xA8 },
	0xDDA2,	{ 0xE8, 0x8C, 0x9B },
	0xDDA3,	{ 0xE8, 0x8D, 0xA9 },
	0xDDA4,	{ 0xE8, 0x8D, 0xAC },
	0xDDA5,	{ 0xE8, 0x8D, 0xAA },
	0xDDA6,	{ 0xE8, 0x8D, 0xAD },
	0xDDA7,	{ 0xE8, 0x8D, 0xAE },
	0xDDA8,	{ 0xE8, 0x8E, 0xB0 },
	0xDDA9,	{ 0xE8, 0x8D, 0xB8 },
	0xDDAA,	{ 0xE8, 0x8E, 0xB3 },
	0xDDAB,	{ 0xE8, 0x8E, 0xB4 },
	0xDDAC,	{ 0xE8, 0x8E, 0xA0 },
	0xDDAD,	{ 0xE8, 0x8E, 0xAA },
	0xDDAE,	{ 0xE8, 0x8E, 0x93 },
	0xDDAF,	{ 0xE8, 0x8E, 0x9C },
	0xDDB0,	{ 0xE8, 0x8E, 0x85 },
	0xDDB1,	{ 0xE8, 0x8D, 0xBC },
	0xDDB2,	{ 0xE8, 0x8E, 0xB6 },
	0xDDB3,	{ 0xE8, 0x8E, 0xA9 },
	0xDDB4,	{ 0xE8, 0x8D, 0xBD },
	0xDDB5,	{ 0xE8, 0x8E, 0xB8 },
	0xDDB6,	{ 0xE8, 0x8D, 0xBB },
	0xDDB7,	{ 0xE8, 0x8E, 0x98 },
	0xDDB8,	{ 0xE8, 0x8E, 0x9E },
	0xDDB9,	{ 0xE8, 0x8E, 0xA8 },
	0xDDBA,	{ 0xE8, 0x8E, 0xBA },
	0xDDBB,	{ 0xE8, 0x8E, 0xBC },
	0xDDBC,	{ 0xE8, 0x8F, 0x81 },
	0xDDBD,	{ 0xE8, 0x90, 0x81 },
	0xDDBE,	{ 0xE8, 0x8F, 0xA5 },
	0xDDBF,	{ 0xE8, 0x8F, 0x98 },
	0xDDC0,	{ 0xE5, 0xA0, 0x87 },
	0xDDC1,	{ 0xE8, 0x90, 0x98 },
	0xDDC2,	{ 0xE8, 0x90, 0x8B },
	0xDDC3,	{ 0xE8, 0x8F, 0x9D },
	0xDDC4,	{ 0xE8, 0x8F, 0xBD },
	0xDDC5,	{ 0xE8, 0x8F, 0x96 },
	0xDDC6,	{ 0xE8, 0x90, 0x9C },
	0xDDC7,	{ 0xE8, 0x90, 0xB8 },
	0xDDC8,	{ 0xE8, 0x90, 0x91 },
	0xDDC9,	{ 0xE8, 0x90, 0x86 },
	0xDDCA,	{ 0xE8, 0x8F, 0x94 },
	0xDDCB,	{ 0xE8, 0x8F, 0x9F },
	0xDDCC,	{ 0xE8, 0x90, 0x8F },
	0xDDCD,	{ 0xE8, 0x90, 0x83 },
	0xDDCE,	{ 0xE8, 0x8F, 0xB8 },
	0xDDCF,	{ 0xE8, 0x8F, 0xB9 },
	0xDDD0,	{ 0xE8, 0x8F, 0xAA },
	0xDDD1,	{ 0xE8, 0x8F, 0x85 },
	0xDDD2,	{ 0xE8, 0x8F, 0x80 },
	0xDDD3,	{ 0xE8, 0x90, 0xA6 },
	0xDDD4,	{ 0xE8, 0x8F, 0xB0 },
	0xDDD5,	{ 0xE8, 0x8F, 0xA1 },
	0xDDD6,	{ 0xE8, 0x91, 0x9C },
	0xDDD7,	{ 0xE8, 0x91, 0x91 },
	0xDDD8,	{ 0xE8, 0x91, 0x9A },
	0xDDD9,	{ 0xE8, 0x91, 0x99 },
	0xDDDA,	{ 0xE8, 0x91, 0xB3 },
	0xDDDB,	{ 0xE8, 0x92, 0x87 },
	0xDDDC,	{ 0xE8, 0x92, 0x88 },
	0xDDDD,	{ 0xE8, 0x91, 0xBA },
	0xDDDE,	{ 0xE8, 0x92, 0x89 },
	0xDDDF,	{ 0xE8, 0x91, 0xB8 },
	0xDDE0,	{ 0xE8, 0x90, 0xBC },
	0xDDE1,	{ 0xE8, 0x91, 0x86 },
	0xDDE2,	{ 0xE8, 0x91, 0xA9 },
	0xDDE3,	{ 0xE8, 0x91, 0xB6 },
	0xDDE4,	{ 0xE8, 0x92, 0x8C },
	0xDDE5,	{ 0xE8, 0x92, 0x8E },
	0xDDE6,	{ 0xE8, 0x90, 0xB1 },
	0xDDE7,	{ 0xE8, 0x91, 0xAD },
	0xDDE8,	{ 0xE8, 0x93, 0x81 },
	0xDDE9,	{ 0xE8, 0x93, 0x8D },
	0xDDEA,	{ 0xE8, 0x93, 0x90 },
	0xDDEB,	{ 0xE8, 0x93, 0xA6 },
	0xDDEC,	{ 0xE8, 0x92, 0xBD },
	0xDDED,	{ 0xE8, 0x93, 0x93 },
	0xDDEE,	{ 0xE8, 0x93, 0x8A },
	0xDDEF,	{ 0xE8, 0x92, 0xBF },
	0xDDF0,	{ 0xE8, 0x92, 0xBA },
	0xDDF1,	{ 0xE8, 0x93, 0xA0 },
	0xDDF2,	{ 0xE8, 0x92, 0xA1 },
	0xDDF3,	{ 0xE8, 0x92, 0xB9 },
	0xDDF4,	{ 0xE8, 0x92, 0xB4 },
	0xDDF5,	{ 0xE8, 0x92, 0x97 },
	0xDDF6,	{ 0xE8, 0x93, 0xA5 },
	0xDDF7,	{ 0xE8, 0x93, 0xA3 },
	0xDDF8,	{ 0xE8, 0x94, 0x8C },
	0xDDF9,	{ 0xE7, 0x94, 0x8D },
	0xDDFA,	{ 0xE8, 0x94, 0xB8 },
	0xDDFB,	{ 0xE8, 0x93, 0xB0 },
	0xDDFC,	{ 0xE8, 0x94, 0xB9 },
	0xDDFD,	{ 0xE8, 0x94, 0x9F },
	0xDDFE,	{ 0xE8, 0x94, 0xBA },
	0xDE40,	{ 0xE8, 0xBD, 0x85 },
	0xDE41,	{ 0xE8, 0xBD, 0x86 },
	0xDE42,	{ 0xE8, 0xBD, 0x87 },
	0xDE43,	{ 0xE8, 0xBD, 0x88 },
	0xDE44,	{ 0xE8, 0xBD, 0x89 },
	0xDE45,	{ 0xE8, 0xBD, 0x8A },
	0xDE46,	{ 0xE8, 0xBD, 0x8B },
	0xDE47,	{ 0xE8, 0xBD, 0x8C },
	0xDE48,	{ 0xE8, 0xBD, 0x8D },
	0xDE49,	{ 0xE8, 0xBD, 0x8E },
	0xDE4A,	{ 0xE8, 0xBD, 0x8F },
	0xDE4B,	{ 0xE8, 0xBD, 0x90 },
	0xDE4C,	{ 0xE8, 0xBD, 0x91 },
	0xDE4D,	{ 0xE8, 0xBD, 0x92 },
	0xDE4E,	{ 0xE8, 0xBD, 0x93 },
	0xDE4F,	{ 0xE8, 0xBD, 0x94 },
	0xDE50,	{ 0xE8, 0xBD, 0x95 },
	0xDE51,	{ 0xE8, 0xBD, 0x96 },
	0xDE52,	{ 0xE8, 0xBD, 0x97 },
	0xDE53,	{ 0xE8, 0xBD, 0x98 },
	0xDE54,	{ 0xE8, 0xBD, 0x99 },
	0xDE55,	{ 0xE8, 0xBD, 0x9A },
	0xDE56,	{ 0xE8, 0xBD, 0x9B },
	0xDE57,	{ 0xE8, 0xBD, 0x9C },
	0xDE58,	{ 0xE8, 0xBD, 0x9D },
	0xDE59,	{ 0xE8, 0xBD, 0x9E },
	0xDE5A,	{ 0xE8, 0xBD, 0x9F },
	0xDE5B,	{ 0xE8, 0xBD, 0xA0 },
	0xDE5C,	{ 0xE8, 0xBD, 0xA1 },
	0xDE5D,	{ 0xE8, 0xBD, 0xA2 },
	0xDE5E,	{ 0xE8, 0xBD, 0xA3 },
	0xDE5F,	{ 0xE8, 0xBD, 0xA4 },
	0xDE60,	{ 0xE8, 0xBD, 0xA5 },
	0xDE61,	{ 0xE8, 0xBD, 0xAA },
	0xDE62,	{ 0xE8, 0xBE, 0x80 },
	0xDE63,	{ 0xE8, 0xBE, 0x8C },
	0xDE64,	{ 0xE8, 0xBE, 0x92 },
	0xDE65,	{ 0xE8, 0xBE, 0x9D },
	0xDE66,	{ 0xE8, 0xBE, 0xA0 },
	0xDE67,	{ 0xE8, 0xBE, 0xA1 },
	0xDE68,	{ 0xE8, 0xBE, 0xA2 },
	0xDE69,	{ 0xE8, 0xBE, 0xA4 },
	0xDE6A,	{ 0xE8, 0xBE, 0xA5 },
	0xDE6B,	{ 0xE8, 0xBE, 0xA6 },
	0xDE6C,	{ 0xE8, 0xBE, 0xA7 },
	0xDE6D,	{ 0xE8, 0xBE, 0xAA },
	0xDE6E,	{ 0xE8, 0xBE, 0xAC },
	0xDE6F,	{ 0xE8, 0xBE, 0xAD },
	0xDE70,	{ 0xE8, 0xBE, 0xAE },
	0xDE71,	{ 0xE8, 0xBE, 0xAF },
	0xDE72,	{ 0xE8, 0xBE, 0xB2 },
	0xDE73,	{ 0xE8, 0xBE, 0xB3 },
	0xDE74,	{ 0xE8, 0xBE, 0xB4 },
	0xDE75,	{ 0xE8, 0xBE, 0xB5 },
	0xDE76,	{ 0xE8, 0xBE, 0xB7 },
	0xDE77,	{ 0xE8, 0xBE, 0xB8 },
	0xDE78,	{ 0xE8, 0xBE, 0xBA },
	0xDE79,	{ 0xE8, 0xBE, 0xBB },
	0xDE7A,	{ 0xE8, 0xBE, 0xBC },
	0xDE7B,	{ 0xE8, 0xBE, 0xBF },
	0xDE7C,	{ 0xE8, 0xBF, 0x80 },
	0xDE7D,	{ 0xE8, 0xBF, 0x83 },
	0xDE7E,	{ 0xE8, 0xBF, 0x86 },
	0xDE80,	{ 0xE8, 0xBF, 0x89 },
	0xDE81,	{ 0xE8, 0xBF, 0x8A },
	0xDE82,	{ 0xE8, 0xBF, 0x8B },
	0xDE83,	{ 0xE8, 0xBF, 0x8C },
	0xDE84,	{ 0xE8, 0xBF, 0x8D },
	0xDE85,	{ 0xE8, 0xBF, 0x8F },
	0xDE86,	{ 0xE8, 0xBF, 0x92 },
	0xDE87,	{ 0xE8, 0xBF, 0x96 },
	0xDE88,	{ 0xE8, 0xBF, 0x97 },
	0xDE89,	{ 0xE8, 0xBF, 0x9A },
	0xDE8A,	{ 0xE8, 0xBF, 0xA0 },
	0xDE8B,	{ 0xE8, 0xBF, 0xA1 },
	0xDE8C,	{ 0xE8, 0xBF, 0xA3 },
	0xDE8D,	{ 0xE8, 0xBF, 0xA7 },
	0xDE8E,	{ 0xE8, 0xBF, 0xAC },
	0xDE8F,	{ 0xE8, 0xBF, 0xAF },
	0xDE90,	{ 0xE8, 0xBF, 0xB1 },
	0xDE91,	{ 0xE8, 0xBF, 0xB2 },
	0xDE92,	{ 0xE8, 0xBF, 0xB4 },
	0xDE93,	{ 0xE8, 0xBF, 0xB5 },
	0xDE94,	{ 0xE8, 0xBF, 0xB6 },
	0xDE95,	{ 0xE8, 0xBF, 0xBA },
	0xDE96,	{ 0xE8, 0xBF, 0xBB },
	0xDE97,	{ 0xE8, 0xBF, 0xBC },
	0xDE98,	{ 0xE8, 0xBF, 0xBE },
	0xDE99,	{ 0xE8, 0xBF, 0xBF },
	0xDE9A,	{ 0xE9, 0x80, 0x87 },
	0xDE9B,	{ 0xE9, 0x80, 0x88 },
	0xDE9C,	{ 0xE9, 0x80, 0x8C },
	0xDE9D,	{ 0xE9, 0x80, 0x8E },
	0xDE9E,	{ 0xE9, 0x80, 0x93 },
	0xDE9F,	{ 0xE9, 0x80, 0x95 },
	0xDEA0,	{ 0xE9, 0x80, 0x98 },
	0xDEA1,	{ 0xE8, 0x95, 0x96 },
	0xDEA2,	{ 0xE8, 0x94, 0xBB },
	0xDEA3,	{ 0xE8, 0x93, 0xBF },
	0xDEA4,	{ 0xE8, 0x93, 0xBC },
	0xDEA5,	{ 0xE8, 0x95, 0x99 },
	0xDEA6,	{ 0xE8, 0x95, 0x88 },
	0xDEA7,	{ 0xE8, 0x95, 0xA8 },
	0xDEA8,	{ 0xE8, 0x95, 0xA4 },
	0xDEA9,	{ 0xE8, 0x95, 0x9E },
	0xDEAA,	{ 0xE8, 0x95, 0xBA },
	0xDEAB,	{ 0xE7, 0x9E, 0xA2 },
	0xDEAC,	{ 0xE8, 0x95, 0x83 },
	0xDEAD,	{ 0xE8, 0x95, 0xB2 },
	0xDEAE,	{ 0xE8, 0x95, 0xBB },
	0xDEAF,	{ 0xE8, 0x96, 0xA4 },
	0xDEB0,	{ 0xE8, 0x96, 0xA8 },
	0xDEB1,	{ 0xE8, 0x96, 0x87 },
	0xDEB2,	{ 0xE8, 0x96, 0x8F },
	0xDEB3,	{ 0xE8, 0x95, 0xB9 },
	0xDEB4,	{ 0xE8, 0x96, 0xAE },
	0xDEB5,	{ 0xE8, 0x96, 0x9C },
	0xDEB6,	{ 0xE8, 0x96, 0x85 },
	0xDEB7,	{ 0xE8, 0x96, 0xB9 },
	0xDEB8,	{ 0xE8, 0x96, 0xB7 },
	0xDEB9,	{ 0xE8, 0x96, 0xB0 },
	0xDEBA,	{ 0xE8, 0x97, 0x93 },
	0xDEBB,	{ 0xE8, 0x97, 0x81 },
	0xDEBC,	{ 0xE8, 0x97, 0x9C },
	0xDEBD,	{ 0xE8, 0x97, 0xBF },
	0xDEBE,	{ 0xE8, 0x98, 0xA7 },
	0xDEBF,	{ 0xE8, 0x98, 0x85 },
	0xDEC0,	{ 0xE8, 0x98, 0xA9 },
	0xDEC1,	{ 0xE8, 0x98, 0x96 },
	0xDEC2,	{ 0xE8, 0x98, 0xBC },
	0xDEC3,	{ 0xE5, 0xBB, 0xBE },
	0xDEC4,	{ 0xE5, 0xBC, 0x88 },
	0xDEC5,	{ 0xE5, 0xA4, 0xBC },
	0xDEC6,	{ 0xE5, 0xA5, 0x81 },
	0xDEC7,	{ 0xE8, 0x80, 0xB7 },
	0xDEC8,	{ 0xE5, 0xA5, 0x95 },
	0xDEC9,	{ 0xE5, 0xA5, 0x9A },
	0xDECA,	{ 0xE5, 0xA5, 0x98 },
	0xDECB,	{ 0xE5, 0x8C, 0x8F },
	0xDECC,	{ 0xE5, 0xB0, 0xA2 },
	0xDECD,	{ 0xE5, 0xB0, 0xA5 },
	0xDECE,	{ 0xE5, 0xB0, 0xAC },
	0xDECF,	{ 0xE5, 0xB0, 0xB4 },
	0xDED0,	{ 0xE6, 0x89, 0x8C },
	0xDED1,	{ 0xE6, 0x89, 0xAA },
	0xDED2,	{ 0xE6, 0x8A, 0x9F },
	0xDED3,	{ 0xE6, 0x8A, 0xBB },
	0xDED4,	{ 0xE6, 0x8B, 0x8A },
	0xDED5,	{ 0xE6, 0x8B, 0x9A },
	0xDED6,	{ 0xE6, 0x8B, 0x97 },
	0xDED7,	{ 0xE6, 0x8B, 0xAE },
	0xDED8,	{ 0xE6, 0x8C, 0xA2 },
	0xDED9,	{ 0xE6, 0x8B, 0xB6 },
	0xDEDA,	{ 0xE6, 0x8C, 0xB9 },
	0xDEDB,	{ 0xE6, 0x8D, 0x8B },
	0xDEDC,	{ 0xE6, 0x8D, 0x83 },
	0xDEDD,	{ 0xE6, 0x8E, 0xAD },
	0xDEDE,	{ 0xE6, 0x8F, 0xB6 },
	0xDEDF,	{ 0xE6, 0x8D, 0xB1 },
	0xDEE0,	{ 0xE6, 0x8D, 0xBA },
	0xDEE1,	{ 0xE6, 0x8E, 0x8E },
	0xDEE2,	{ 0xE6, 0x8E, 0xB4 },
	0xDEE3,	{ 0xE6, 0x8D, 0xAD },
	0xDEE4,	{ 0xE6, 0x8E, 0xAC },
	0xDEE5,	{ 0xE6, 0x8E, 0x8A },
	0xDEE6,	{ 0xE6, 0x8D, 0xA9 },
	0xDEE7,	{ 0xE6, 0x8E, 0xAE },
	0xDEE8,	{ 0xE6, 0x8E, 0xBC },
	0xDEE9,	{ 0xE6, 0x8F, 0xB2 },
	0xDEEA,	{ 0xE6, 0x8F, 0xB8 },
	0xDEEB,	{ 0xE6, 0x8F, 0xA0 },
	0xDEEC,	{ 0xE6, 0x8F, 0xBF },
	0xDEED,	{ 0xE6, 0x8F, 0x84 },
	0xDEEE,	{ 0xE6, 0x8F, 0x9E },
	0xDEEF,	{ 0xE6, 0x8F, 0x8E },
	0xDEF0,	{ 0xE6, 0x91, 0x92 },
	0xDEF1,	{ 0xE6, 0x8F, 0x86 },
	0xDEF2,	{ 0xE6, 0x8E, 0xBE },
	0xDEF3,	{ 0xE6, 0x91, 0x85 },
	0xDEF4,	{ 0xE6, 0x91, 0x81 },
	0xDEF5,	{ 0xE6, 0x90, 0x8B },
	0xDEF6,	{ 0xE6, 0x90, 0x9B },
	0xDEF7,	{ 0xE6, 0x90, 0xA0 },
	0xDEF8,	{ 0xE6, 0x90, 0x8C },
	0xDEF9,	{ 0xE6, 0x90, 0xA6 },
	0xDEFA,	{ 0xE6, 0x90, 0xA1 },
	0xDEFB,	{ 0xE6, 0x91, 0x9E },
	0xDEFC,	{ 0xE6, 0x92, 0x84 },
	0xDEFD,	{ 0xE6, 0x91, 0xAD },
	0xDEFE,	{ 0xE6, 0x92, 0x96 },
	0xDF40,	{ 0xE9, 0x80, 0x99 },
	0xDF41,	{ 0xE9, 0x80, 0x9C },
	0xDF42,	{ 0xE9, 0x80, 0xA3 },
	0xDF43,	{ 0xE9, 0x80, 0xA4 },
	0xDF44,	{ 0xE9, 0x80, 0xA5 },
	0xDF45,	{ 0xE9, 0x80, 0xA7 },
	0xDF46,	{ 0xE9, 0x80, 0xA8 },
	0xDF47,	{ 0xE9, 0x80, 0xA9 },
	0xDF48,	{ 0xE9, 0x80, 0xAA },
	0xDF49,	{ 0xE9, 0x80, 0xAB },
	0xDF4A,	{ 0xE9, 0x80, 0xAC },
	0xDF4B,	{ 0xE9, 0x80, 0xB0 },
	0xDF4C,	{ 0xE9, 0x80, 0xB1 },
	0xDF4D,	{ 0xE9, 0x80, 0xB2 },
	0xDF4E,	{ 0xE9, 0x80, 0xB3 },
	0xDF4F,	{ 0xE9, 0x80, 0xB4 },
	0xDF50,	{ 0xE9, 0x80, 0xB7 },
	0xDF51,	{ 0xE9, 0x80, 0xB9 },
	0xDF52,	{ 0xE9, 0x80, 0xBA },
	0xDF53,	{ 0xE9, 0x80, 0xBD },
	0xDF54,	{ 0xE9, 0x80, 0xBF },
	0xDF55,	{ 0xE9, 0x81, 0x80 },
	0xDF56,	{ 0xE9, 0x81, 0x83 },
	0xDF57,	{ 0xE9, 0x81, 0x85 },
	0xDF58,	{ 0xE9, 0x81, 0x86 },
	0xDF59,	{ 0xE9, 0x81, 0x88 },
	0xDF5A,	{ 0xE9, 0x81, 0x89 },
	0xDF5B,	{ 0xE9, 0x81, 0x8A },
	0xDF5C,	{ 0xE9, 0x81, 0x8B },
	0xDF5D,	{ 0xE9, 0x81, 0x8C },
	0xDF5E,	{ 0xE9, 0x81, 0x8E },
	0xDF5F,	{ 0xE9, 0x81, 0x94 },
	0xDF60,	{ 0xE9, 0x81, 0x95 },
	0xDF61,	{ 0xE9, 0x81, 0x96 },
	0xDF62,	{ 0xE9, 0x81, 0x99 },
	0xDF63,	{ 0xE9, 0x81, 0x9A },
	0xDF64,	{ 0xE9, 0x81, 0x9C },
	0xDF65,	{ 0xE9, 0x81, 0x9D },
	0xDF66,	{ 0xE9, 0x81, 0x9E },
	0xDF67,	{ 0xE9, 0x81, 0x9F },
	0xDF68,	{ 0xE9, 0x81, 0xA0 },
	0xDF69,	{ 0xE9, 0x81, 0xA1 },
	0xDF6A,	{ 0xE9, 0x81, 0xA4 },
	0xDF6B,	{ 0xE9, 0x81, 0xA6 },
	0xDF6C,	{ 0xE9, 0x81, 0xA7 },
	0xDF6D,	{ 0xE9, 0x81, 0xA9 },
	0xDF6E,	{ 0xE9, 0x81, 0xAA },
	0xDF6F,	{ 0xE9, 0x81, 0xAB },
	0xDF70,	{ 0xE9, 0x81, 0xAC },
	0xDF71,	{ 0xE9, 0x81, 0xAF },
	0xDF72,	{ 0xE9, 0x81, 0xB0 },
	0xDF73,	{ 0xE9, 0x81, 0xB1 },
	0xDF74,	{ 0xE9, 0x81, 0xB2 },
	0xDF75,	{ 0xE9, 0x81, 0xB3 },
	0xDF76,	{ 0xE9, 0x81, 0xB6 },
	0xDF77,	{ 0xE9, 0x81, 0xB7 },
	0xDF78,	{ 0xE9, 0x81, 0xB8 },
	0xDF79,	{ 0xE9, 0x81, 0xB9 },
	0xDF7A,	{ 0xE9, 0x81, 0xBA },
	0xDF7B,	{ 0xE9, 0x81, 0xBB },
	0xDF7C,	{ 0xE9, 0x81, 0xBC },
	0xDF7D,	{ 0xE9, 0x81, 0xBE },
	0xDF7E,	{ 0xE9, 0x82, 0x81 },
	0xDF80,	{ 0xE9, 0x82, 0x84 },
	0xDF81,	{ 0xE9, 0x82, 0x85 },
	0xDF82,	{ 0xE9, 0x82, 0x86 },
	0xDF83,	{ 0xE9, 0x82, 0x87 },
	0xDF84,	{ 0xE9, 0x82, 0x89 },
	0xDF85,	{ 0xE9, 0x82, 0x8A },
	0xDF86,	{ 0xE9, 0x82, 0x8C },
	0xDF87,	{ 0xE9, 0x82, 0x8D },
	0xDF88,	{ 0xE9, 0x82, 0x8E },
	0xDF89,	{ 0xE9, 0x82, 0x8F },
	0xDF8A,	{ 0xE9, 0x82, 0x90 },
	0xDF8B,	{ 0xE9, 0x82, 0x92 },
	0xDF8C,	{ 0xE9, 0x82, 0x94 },
	0xDF8D,	{ 0xE9, 0x82, 0x96 },
	0xDF8E,	{ 0xE9, 0x82, 0x98 },
	0xDF8F,	{ 0xE9, 0x82, 0x9A },
	0xDF90,	{ 0xE9, 0x82, 0x9C },
	0xDF91,	{ 0xE9, 0x82, 0x9E },
	0xDF92,	{ 0xE9, 0x82, 0x9F },
	0xDF93,	{ 0xE9, 0x82, 0xA0 },
	0xDF94,	{ 0xE9, 0x82, 0xA4 },
	0xDF95,	{ 0xE9, 0x82, 0xA5 },
	0xDF96,	{ 0xE9, 0x82, 0xA7 },
	0xDF97,	{ 0xE9, 0x82, 0xA8 },
	0xDF98,	{ 0xE9, 0x82, 0xA9 },
	0xDF99,	{ 0xE9, 0x82, 0xAB },
	0xDF9A,	{ 0xE9, 0x82, 0xAD },
	0xDF9B,	{ 0xE9, 0x82, 0xB2 },
	0xDF9C,	{ 0xE9, 0x82, 0xB7 },
	0xDF9D,	{ 0xE9, 0x82, 0xBC },
	0xDF9E,	{ 0xE9, 0x82, 0xBD },
	0xDF9F,	{ 0xE9, 0x82, 0xBF },
	0xDFA0,	{ 0xE9, 0x83, 0x80 },
	0xDFA1,	{ 0xE6, 0x91, 0xBA },
	0xDFA2,	{ 0xE6, 0x92, 0xB7 },
	0xDFA3,	{ 0xE6, 0x92, 0xB8 },
	0xDFA4,	{ 0xE6, 0x92, 0x99 },
	0xDFA5,	{ 0xE6, 0x92, 0xBA },
	0xDFA6,	{ 0xE6, 0x93, 0x80 },
	0xDFA7,	{ 0xE6, 0x93, 0x90 },
	0xDFA8,	{ 0xE6, 0x93, 0x97 },
	0xDFA9,	{ 0xE6, 0x93, 0xA4 },
	0xDFAA,	{ 0xE6, 0x93, 0xA2 },
	0xDFAB,	{ 0xE6, 0x94, 0x89 },
	0xDFAC,	{ 0xE6, 0x94, 0xA5 },
	0xDFAD,	{ 0xE6, 0x94, 0xAE },
	0xDFAE,	{ 0xE5, 0xBC, 0x8B },
	0xDFAF,	{ 0xE5, 0xBF, 0x92 },
	0xDFB0,	{ 0xE7, 0x94, 0x99 },
	0xDFB1,	{ 0xE5, 0xBC, 0x91 },
	0xDFB2,	{ 0xE5, 0x8D, 0x9F },
	0xDFB3,	{ 0xE5, 0x8F, 0xB1 },
	0xDFB4,	{ 0xE5, 0x8F, 0xBD },
	0xDFB5,	{ 0xE5, 0x8F, 0xA9 },
	0xDFB6,	{ 0xE5, 0x8F, 0xA8 },
	0xDFB7,	{ 0xE5, 0x8F, 0xBB },
	0xDFB8,	{ 0xE5, 0x90, 0x92 },
	0xDFB9,	{ 0xE5, 0x90, 0x96 },
	0xDFBA,	{ 0xE5, 0x90, 0x86 },
	0xDFBB,	{ 0xE5, 0x91, 0x8B },
	0xDFBC,	{ 0xE5, 0x91, 0x92 },
	0xDFBD,	{ 0xE5, 0x91, 0x93 },
	0xDFBE,	{ 0xE5, 0x91, 0x94 },
	0xDFBF,	{ 0xE5, 0x91, 0x96 },
	0xDFC0,	{ 0xE5, 0x91, 0x83 },
	0xDFC1,	{ 0xE5, 0x90, 0xA1 },
	0xDFC2,	{ 0xE5, 0x91, 0x97 },
	0xDFC3,	{ 0xE5, 0x91, 0x99 },
	0xDFC4,	{ 0xE5, 0x90, 0xA3 },
	0xDFC5,	{ 0xE5, 0x90, 0xB2 },
	0xDFC6,	{ 0xE5, 0x92, 0x82 },
	0xDFC7,	{ 0xE5, 0x92, 0x94 },
	0xDFC8,	{ 0xE5, 0x91, 0xB7 },
	0xDFC9,	{ 0xE5, 0x91, 0xB1 },
	0xDFCA,	{ 0xE5, 0x91, 0xA4 },
	0xDFCB,	{ 0xE5, 0x92, 0x9A },
	0xDFCC,	{ 0xE5, 0x92, 0x9B },
	0xDFCD,	{ 0xE5, 0x92, 0x84 },
	0xDFCE,	{ 0xE5, 0x91, 0xB6 },
	0xDFCF,	{ 0xE5, 0x91, 0xA6 },
	0xDFD0,	{ 0xE5, 0x92, 0x9D },
	0xDFD1,	{ 0xE5, 0x93, 0x90 },
	0xDFD2,	{ 0xE5, 0x92, 0xAD },
	0xDFD3,	{ 0xE5, 0x93, 0x82 },
	0xDFD4,	{ 0xE5, 0x92, 0xB4 },
	0xDFD5,	{ 0xE5, 0x93, 0x92 },
	0xDFD6,	{ 0xE5, 0x92, 0xA7 },
	0xDFD7,	{ 0xE5, 0x92, 0xA6 },
	0xDFD8,	{ 0xE5, 0x93, 0x93 },
	0xDFD9,	{ 0xE5, 0x93, 0x94 },
	0xDFDA,	{ 0xE5, 0x91, 0xB2 },
	0xDFDB,	{ 0xE5, 0x92, 0xA3 },
	0xDFDC,	{ 0xE5, 0x93, 0x95 },
	0xDFDD,	{ 0xE5, 0x92, 0xBB },
	0xDFDE,	{ 0xE5, 0x92, 0xBF },
	0xDFDF,	{ 0xE5, 0x93, 0x8C },
	0xDFE0,	{ 0xE5, 0x93, 0x99 },
	0xDFE1,	{ 0xE5, 0x93, 0x9A },
	0xDFE2,	{ 0xE5, 0x93, 0x9C },
	0xDFE3,	{ 0xE5, 0x92, 0xA9 },
	0xDFE4,	{ 0xE5, 0x92, 0xAA },
	0xDFE5,	{ 0xE5, 0x92, 0xA4 },
	0xDFE6,	{ 0xE5, 0x93, 0x9D },
	0xDFE7,	{ 0xE5, 0x93, 0x8F },
	0xDFE8,	{ 0xE5, 0x93, 0x9E },
	0xDFE9,	{ 0xE5, 0x94, 0x9B },
	0xDFEA,	{ 0xE5, 0x93, 0xA7 },
	0xDFEB,	{ 0xE5, 0x94, 0xA0 },
	0xDFEC,	{ 0xE5, 0x93, 0xBD },
	0xDFED,	{ 0xE5, 0x94, 0x94 },
	0xDFEE,	{ 0xE5, 0x93, 0xB3 },
	0xDFEF,	{ 0xE5, 0x94, 0xA2 },
	0xDFF0,	{ 0xE5, 0x94, 0xA3 },
	0xDFF1,	{ 0xE5, 0x94, 0x8F },
	0xDFF2,	{ 0xE5, 0x94, 0x91 },
	0xDFF3,	{ 0xE5, 0x94, 0xA7 },
	0xDFF4,	{ 0xE5, 0x94, 0xAA },
	0xDFF5,	{ 0xE5, 0x95, 0xA7 },
	0xDFF6,	{ 0xE5, 0x96, 0x8F },
	0xDFF7,	{ 0xE5, 0x96, 0xB5 },
	0xDFF8,	{ 0xE5, 0x95, 0x89 },
	0xDFF9,	{ 0xE5, 0x95, 0xAD },
	0xDFFA,	{ 0xE5, 0x95, 0x81 },
	0xDFFB,	{ 0xE5, 0x95, 0x95 },
	0xDFFC,	{ 0xE5, 0x94, 0xBF },
	0xDFFD,	{ 0xE5, 0x95, 0x90 },
	0xDFFE,	{ 0xE5, 0x94, 0xBC },
	0xE040,	{ 0xE9, 0x83, 0x82 },
	0xE041,	{ 0xE9, 0x83, 0x83 },
	0xE042,	{ 0xE9, 0x83, 0x86 },
	0xE043,	{ 0xE9, 0x83, 0x88 },
	0xE044,	{ 0xE9, 0x83, 0x89 },
	0xE045,	{ 0xE9, 0x83, 0x8B },
	0xE046,	{ 0xE9, 0x83, 0x8C },
	0xE047,	{ 0xE9, 0x83, 0x8D },
	0xE048,	{ 0xE9, 0x83, 0x92 },
	0xE049,	{ 0xE9, 0x83, 0x94 },
	0xE04A,	{ 0xE9, 0x83, 0x95 },
	0xE04B,	{ 0xE9, 0x83, 0x96 },
	0xE04C,	{ 0xE9, 0x83, 0x98 },
	0xE04D,	{ 0xE9, 0x83, 0x99 },
	0xE04E,	{ 0xE9, 0x83, 0x9A },
	0xE04F,	{ 0xE9, 0x83, 0x9E },
	0xE050,	{ 0xE9, 0x83, 0x9F },
	0xE051,	{ 0xE9, 0x83, 0xA0 },
	0xE052,	{ 0xE9, 0x83, 0xA3 },
	0xE053,	{ 0xE9, 0x83, 0xA4 },
	0xE054,	{ 0xE9, 0x83, 0xA5 },
	0xE055,	{ 0xE9, 0x83, 0xA9 },
	0xE056,	{ 0xE9, 0x83, 0xAA },
	0xE057,	{ 0xE9, 0x83, 0xAC },
	0xE058,	{ 0xE9, 0x83, 0xAE },
	0xE059,	{ 0xE9, 0x83, 0xB0 },
	0xE05A,	{ 0xE9, 0x83, 0xB1 },
	0xE05B,	{ 0xE9, 0x83, 0xB2 },
	0xE05C,	{ 0xE9, 0x83, 0xB3 },
	0xE05D,	{ 0xE9, 0x83, 0xB5 },
	0xE05E,	{ 0xE9, 0x83, 0xB6 },
	0xE05F,	{ 0xE9, 0x83, 0xB7 },
	0xE060,	{ 0xE9, 0x83, 0xB9 },
	0xE061,	{ 0xE9, 0x83, 0xBA },
	0xE062,	{ 0xE9, 0x83, 0xBB },
	0xE063,	{ 0xE9, 0x83, 0xBC },
	0xE064,	{ 0xE9, 0x83, 0xBF },
	0xE065,	{ 0xE9, 0x84, 0x80 },
	0xE066,	{ 0xE9, 0x84, 0x81 },
	0xE067,	{ 0xE9, 0x84, 0x83 },
	0xE068,	{ 0xE9, 0x84, 0x85 },
	0xE069,	{ 0xE9, 0x84, 0x86 },
	0xE06A,	{ 0xE9, 0x84, 0x87 },
	0xE06B,	{ 0xE9, 0x84, 0x88 },
	0xE06C,	{ 0xE9, 0x84, 0x89 },
	0xE06D,	{ 0xE9, 0x84, 0x8A },
	0xE06E,	{ 0xE9, 0x84, 0x8B },
	0xE06F,	{ 0xE9, 0x84, 0x8C },
	0xE070,	{ 0xE9, 0x84, 0x8D },
	0xE071,	{ 0xE9, 0x84, 0x8E },
	0xE072,	{ 0xE9, 0x84, 0x8F },
	0xE073,	{ 0xE9, 0x84, 0x90 },
	0xE074,	{ 0xE9, 0x84, 0x91 },
	0xE075,	{ 0xE9, 0x84, 0x92 },
	0xE076,	{ 0xE9, 0x84, 0x93 },
	0xE077,	{ 0xE9, 0x84, 0x94 },
	0xE078,	{ 0xE9, 0x84, 0x95 },
	0xE079,	{ 0xE9, 0x84, 0x96 },
	0xE07A,	{ 0xE9, 0x84, 0x97 },
	0xE07B,	{ 0xE9, 0x84, 0x98 },
	0xE07C,	{ 0xE9, 0x84, 0x9A },
	0xE07D,	{ 0xE9, 0x84, 0x9B },
	0xE07E,	{ 0xE9, 0x84, 0x9C },
	0xE080,	{ 0xE9, 0x84, 0x9D },
	0xE081,	{ 0xE9, 0x84, 0x9F },
	0xE082,	{ 0xE9, 0x84, 0xA0 },
	0xE083,	{ 0xE9, 0x84, 0xA1 },
	0xE084,	{ 0xE9, 0x84, 0xA4 },
	0xE085,	{ 0xE9, 0x84, 0xA5 },
	0xE086,	{ 0xE9, 0x84, 0xA6 },
	0xE087,	{ 0xE9, 0x84, 0xA7 },
	0xE088,	{ 0xE9, 0x84, 0xA8 },
	0xE089,	{ 0xE9, 0x84, 0xA9 },
	0xE08A,	{ 0xE9, 0x84, 0xAA },
	0xE08B,	{ 0xE9, 0x84, 0xAB },
	0xE08C,	{ 0xE9, 0x84, 0xAC },
	0xE08D,	{ 0xE9, 0x84, 0xAD },
	0xE08E,	{ 0xE9, 0x84, 0xAE },
	0xE08F,	{ 0xE9, 0x84, 0xB0 },
	0xE090,	{ 0xE9, 0x84, 0xB2 },
	0xE091,	{ 0xE9, 0x84, 0xB3 },
	0xE092,	{ 0xE9, 0x84, 0xB4 },
	0xE093,	{ 0xE9, 0x84, 0xB5 },
	0xE094,	{ 0xE9, 0x84, 0xB6 },
	0xE095,	{ 0xE9, 0x84, 0xB7 },
	0xE096,	{ 0xE9, 0x84, 0xB8 },
	0xE097,	{ 0xE9, 0x84, 0xBA },
	0xE098,	{ 0xE9, 0x84, 0xBB },
	0xE099,	{ 0xE9, 0x84, 0xBC },
	0xE09A,	{ 0xE9, 0x84, 0xBD },
	0xE09B,	{ 0xE9, 0x84, 0xBE },
	0xE09C,	{ 0xE9, 0x84, 0xBF },
	0xE09D,	{ 0xE9, 0x85, 0x80 },
	0xE09E,	{ 0xE9, 0x85, 0x81 },
	0xE09F,	{ 0xE9, 0x85, 0x82 },
	0xE0A0,	{ 0xE9, 0x85, 0x84 },
	0xE0A1,	{ 0xE5, 0x94, 0xB7 },
	0xE0A2,	{ 0xE5, 0x95, 0x96 },
	0xE0A3,	{ 0xE5, 0x95, 0xB5 },
	0xE0A4,	{ 0xE5, 0x95, 0xB6 },
	0xE0A5,	{ 0xE5, 0x95, 0xB7 },
	0xE0A6,	{ 0xE5, 0x94, 0xB3 },
	0xE0A7,	{ 0xE5, 0x94, 0xB0 },
	0xE0A8,	{ 0xE5, 0x95, 0x9C },
	0xE0A9,	{ 0xE5, 0x96, 0x8B },
	0xE0AA,	{ 0xE5, 0x97, 0x92 },
	0xE0AB,	{ 0xE5, 0x96, 0x83 },
	0xE0AC,	{ 0xE5, 0x96, 0xB1 },
	0xE0AD,	{ 0xE5, 0x96, 0xB9 },
	0xE0AE,	{ 0xE5, 0x96, 0x88 },
	0xE0AF,	{ 0xE5, 0x96, 0x81 },
	0xE0B0,	{ 0xE5, 0x96, 0x9F },
	0xE0B1,	{ 0xE5, 0x95, 0xBE },
	0xE0B2,	{ 0xE5, 0x97, 0x96 },
	0xE0B3,	{ 0xE5, 0x96, 0x91 },
	0xE0B4,	{ 0xE5, 0x95, 0xBB },
	0xE0B5,	{ 0xE5, 0x97, 0x9F },
	0xE0B6,	{ 0xE5, 0x96, 0xBD },
	0xE0B7,	{ 0xE5, 0x96, 0xBE },
	0xE0B8,	{ 0xE5, 0x96, 0x94 },
	0xE0B9,	{ 0xE5, 0x96, 0x99 },
	0xE0BA,	{ 0xE5, 0x97, 0xAA },
	0xE0BB,	{ 0xE5, 0x97, 0xB7 },
	0xE0BC,	{ 0xE5, 0x97, 0x89 },
	0xE0BD,	{ 0xE5, 0x98, 0x9F },
	0xE0BE,	{ 0xE5, 0x97, 0x91 },
	0xE0BF,	{ 0xE5, 0x97, 0xAB },
	0xE0C0,	{ 0xE5, 0x97, 0xAC },
	0xE0C1,	{ 0xE5, 0x97, 0x94 },
	0xE0C2,	{ 0xE5, 0x97, 0xA6 },
	0xE0C3,	{ 0xE5, 0x97, 0x9D },
	0xE0C4,	{ 0xE5, 0x97, 0x84 },
	0xE0C5,	{ 0xE5, 0x97, 0xAF },
	0xE0C6,	{ 0xE5, 0x97, 0xA5 },
	0xE0C7,	{ 0xE5, 0x97, 0xB2 },
	0xE0C8,	{ 0xE5, 0x97, 0xB3 },
	0xE0C9,	{ 0xE5, 0x97, 0x8C },
	0xE0CA,	{ 0xE5, 0x97, 0x8D },
	0xE0CB,	{ 0xE5, 0x97, 0xA8 },
	0xE0CC,	{ 0xE5, 0x97, 0xB5 },
	0xE0CD,	{ 0xE5, 0x97, 0xA4 },
	0xE0CE,	{ 0xE8, 0xBE, 0x94 },
	0xE0CF,	{ 0xE5, 0x98, 0x9E },
	0xE0D0,	{ 0xE5, 0x98, 0x88 },
	0xE0D1,	{ 0xE5, 0x98, 0x8C },
	0xE0D2,	{ 0xE5, 0x98, 0x81 },
	0xE0D3,	{ 0xE5, 0x98, 0xA4 },
	0xE0D4,	{ 0xE5, 0x98, 0xA3 },
	0xE0D5,	{ 0xE5, 0x97, 0xBE },
	0xE0D6,	{ 0xE5, 0x98, 0x80 },
	0xE0D7,	{ 0xE5, 0x98, 0xA7 },
	0xE0D8,	{ 0xE5, 0x98, 0xAD },
	0xE0D9,	{ 0xE5, 0x99, 0x98 },
	0xE0DA,	{ 0xE5, 0x98, 0xB9 },
	0xE0DB,	{ 0xE5, 0x99, 0x97 },
	0xE0DC,	{ 0xE5, 0x98, 0xAC },
	0xE0DD,	{ 0xE5, 0x99, 0x8D },
	0xE0DE,	{ 0xE5, 0x99, 0xA2 },
	0xE0DF,	{ 0xE5, 0x99, 0x99 },
	0xE0E0,	{ 0xE5, 0x99, 0x9C },
	0xE0E1,	{ 0xE5, 0x99, 0x8C },
	0xE0E2,	{ 0xE5, 0x99, 0x94 },
	0xE0E3,	{ 0xE5, 0x9A, 0x86 },
	0xE0E4,	{ 0xE5, 0x99, 0xA4 },
	0xE0E5,	{ 0xE5, 0x99, 0xB1 },
	0xE0E6,	{ 0xE5, 0x99, 0xAB },
	0xE0E7,	{ 0xE5, 0x99, 0xBB },
	0xE0E8,	{ 0xE5, 0x99, 0xBC },
	0xE0E9,	{ 0xE5, 0x9A, 0x85 },
	0xE0EA,	{ 0xE5, 0x9A, 0x93 },
	0xE0EB,	{ 0xE5, 0x9A, 0xAF },
	0xE0EC,	{ 0xE5, 0x9B, 0x94 },
	0xE0ED,	{ 0xE5, 0x9B, 0x97 },
	0xE0EE,	{ 0xE5, 0x9B, 0x9D },
	0xE0EF,	{ 0xE5, 0x9B, 0xA1 },
	0xE0F0,	{ 0xE5, 0x9B, 0xB5 },
	0xE0F1,	{ 0xE5, 0x9B, 0xAB },
	0xE0F2,	{ 0xE5, 0x9B, 0xB9 },
	0xE0F3,	{ 0xE5, 0x9B, 0xBF },
	0xE0F4,	{ 0xE5, 0x9C, 0x84 },
	0xE0F5,	{ 0xE5, 0x9C, 0x8A },
	0xE0F6,	{ 0xE5, 0x9C, 0x89 },
	0xE0F7,	{ 0xE5, 0x9C, 0x9C },
	0xE0F8,	{ 0xE5, 0xB8, 0x8F },
	0xE0F9,	{ 0xE5, 0xB8, 0x99 },
	0xE0FA,	{ 0xE5, 0xB8, 0x94 },
	0xE0FB,	{ 0xE5, 0xB8, 0x91 },
	0xE0FC,	{ 0xE5, 0xB8, 0xB1 },
	0xE0FD,	{ 0xE5, 0xB8, 0xBB },
	0xE0FE,	{ 0xE5, 0xB8, 0xBC },
	0xE140,	{ 0xE9, 0x85, 0x85 },
	0xE141,	{ 0xE9, 0x85, 0x87 },
	0xE142,	{ 0xE9, 0x85, 0x88 },
	0xE143,	{ 0xE9, 0x85, 0x91 },
	0xE144,	{ 0xE9, 0x85, 0x93 },
	0xE145,	{ 0xE9, 0x85, 0x94 },
	0xE146,	{ 0xE9, 0x85, 0x95 },
	0xE147,	{ 0xE9, 0x85, 0x96 },
	0xE148,	{ 0xE9, 0x85, 0x98 },
	0xE149,	{ 0xE9, 0x85, 0x99 },
	0xE14A,	{ 0xE9, 0x85, 0x9B },
	0xE14B,	{ 0xE9, 0x85, 0x9C },
	0xE14C,	{ 0xE9, 0x85, 0x9F },
	0xE14D,	{ 0xE9, 0x85, 0xA0 },
	0xE14E,	{ 0xE9, 0x85, 0xA6 },
	0xE14F,	{ 0xE9, 0x85, 0xA7 },
	0xE150,	{ 0xE9, 0x85, 0xA8 },
	0xE151,	{ 0xE9, 0x85, 0xAB },
	0xE152,	{ 0xE9, 0x85, 0xAD },
	0xE153,	{ 0xE9, 0x85, 0xB3 },
	0xE154,	{ 0xE9, 0x85, 0xBA },
	0xE155,	{ 0xE9, 0x85, 0xBB },
	0xE156,	{ 0xE9, 0x85, 0xBC },
	0xE157,	{ 0xE9, 0x86, 0x80 },
	0xE158,	{ 0xE9, 0x86, 0x81 },
	0xE159,	{ 0xE9, 0x86, 0x82 },
	0xE15A,	{ 0xE9, 0x86, 0x83 },
	0xE15B,	{ 0xE9, 0x86, 0x84 },
	0xE15C,	{ 0xE9, 0x86, 0x86 },
	0xE15D,	{ 0xE9, 0x86, 0x88 },
	0xE15E,	{ 0xE9, 0x86, 0x8A },
	0xE15F,	{ 0xE9, 0x86, 0x8E },
	0xE160,	{ 0xE9, 0x86, 0x8F },
	0xE161,	{ 0xE9, 0x86, 0x93 },
	0xE162,	{ 0xE9, 0x86, 0x94 },
	0xE163,	{ 0xE9, 0x86, 0x95 },
	0xE164,	{ 0xE9, 0x86, 0x96 },
	0xE165,	{ 0xE9, 0x86, 0x97 },
	0xE166,	{ 0xE9, 0x86, 0x98 },
	0xE167,	{ 0xE9, 0x86, 0x99 },
	0xE168,	{ 0xE9, 0x86, 0x9C },
	0xE169,	{ 0xE9, 0x86, 0x9D },
	0xE16A,	{ 0xE9, 0x86, 0x9E },
	0xE16B,	{ 0xE9, 0x86, 0x9F },
	0xE16C,	{ 0xE9, 0x86, 0xA0 },
	0xE16D,	{ 0xE9, 0x86, 0xA1 },
	0xE16E,	{ 0xE9, 0x86, 0xA4 },
	0xE16F,	{ 0xE9, 0x86, 0xA5 },
	0xE170,	{ 0xE9, 0x86, 0xA6 },
	0xE171,	{ 0xE9, 0x86, 0xA7 },
	0xE172,	{ 0xE9, 0x86, 0xA8 },
	0xE173,	{ 0xE9, 0x86, 0xA9 },
	0xE174,	{ 0xE9, 0x86, 0xAB },
	0xE175,	{ 0xE9, 0x86, 0xAC },
	0xE176,	{ 0xE9, 0x86, 0xB0 },
	0xE177,	{ 0xE9, 0x86, 0xB1 },
	0xE178,	{ 0xE9, 0x86, 0xB2 },
	0xE179,	{ 0xE9, 0x86, 0xB3 },
	0xE17A,	{ 0xE9, 0x86, 0xB6 },
	0xE17B,	{ 0xE9, 0x86, 0xB7 },
	0xE17C,	{ 0xE9, 0x86, 0xB8 },
	0xE17D,	{ 0xE9, 0x86, 0xB9 },
	0xE17E,	{ 0xE9, 0x86, 0xBB },
	0xE180,	{ 0xE9, 0x86, 0xBC },
	0xE181,	{ 0xE9, 0x86, 0xBD },
	0xE182,	{ 0xE9, 0x86, 0xBE },
	0xE183,	{ 0xE9, 0x86, 0xBF },
	0xE184,	{ 0xE9, 0x87, 0x80 },
	0xE185,	{ 0xE9, 0x87, 0x81 },
	0xE186,	{ 0xE9, 0x87, 0x82 },
	0xE187,	{ 0xE9, 0x87, 0x83 },
	0xE188,	{ 0xE9, 0x87, 0x84 },
	0xE189,	{ 0xE9, 0x87, 0x85 },
	0xE18A,	{ 0xE9, 0x87, 0x86 },
	0xE18B,	{ 0xE9, 0x87, 0x88 },
	0xE18C,	{ 0xE9, 0x87, 0x8B },
	0xE18D,	{ 0xE9, 0x87, 0x90 },
	0xE18E,	{ 0xE9, 0x87, 0x92 },
	0xE18F,	{ 0xE9, 0x87, 0x93 },
	0xE190,	{ 0xE9, 0x87, 0x94 },
	0xE191,	{ 0xE9, 0x87, 0x95 },
	0xE192,	{ 0xE9, 0x87, 0x96 },
	0xE193,	{ 0xE9, 0x87, 0x97 },
	0xE194,	{ 0xE9, 0x87, 0x98 },
	0xE195,	{ 0xE9, 0x87, 0x99 },
	0xE196,	{ 0xE9, 0x87, 0x9A },
	0xE197,	{ 0xE9, 0x87, 0x9B },
	0xE198,	{ 0xE9, 0x87, 0x9D },
	0xE199,	{ 0xE9, 0x87, 0x9E },
	0xE19A,	{ 0xE9, 0x87, 0x9F },
	0xE19B,	{ 0xE9, 0x87, 0xA0 },
	0xE19C,	{ 0xE9, 0x87, 0xA1 },
	0xE19D,	{ 0xE9, 0x87, 0xA2 },
	0xE19E,	{ 0xE9, 0x87, 0xA3 },
	0xE19F,	{ 0xE9, 0x87, 0xA4 },
	0xE1A0,	{ 0xE9, 0x87, 0xA5 },
	0xE1A1,	{ 0xE5, 0xB8, 0xB7 },
	0xE1A2,	{ 0xE5, 0xB9, 0x84 },
	0xE1A3,	{ 0xE5, 0xB9, 0x94 },
	0xE1A4,	{ 0xE5, 0xB9, 0x9B },
	0xE1A5,	{ 0xE5, 0xB9, 0x9E },
	0xE1A6,	{ 0xE5, 0xB9, 0xA1 },
	0xE1A7,	{ 0xE5, 0xB2, 0x8C },
	0xE1A8,	{ 0xE5, 0xB1, 0xBA },
	0xE1A9,	{ 0xE5, 0xB2, 0x8D },
	0xE1AA,	{ 0xE5, 0xB2, 0x90 },
	0xE1AB,	{ 0xE5, 0xB2, 0x96 },
	0xE1AC,	{ 0xE5, 0xB2, 0x88 },
	0xE1AD,	{ 0xE5, 0xB2, 0x98 },
	0xE1AE,	{ 0xE5, 0xB2, 0x99 },
	0xE1AF,	{ 0xE5, 0xB2, 0x91 },
	0xE1B0,	{ 0xE5, 0xB2, 0x9A },
	0xE1B1,	{ 0xE5, 0xB2, 0x9C },
	0xE1B2,	{ 0xE5, 0xB2, 0xB5 },
	0xE1B3,	{ 0xE5, 0xB2, 0xA2 },
	0xE1B4,	{ 0xE5, 0xB2, 0xBD },
	0xE1B5,	{ 0xE5, 0xB2, 0xAC },
	0xE1B6,	{ 0xE5, 0xB2, 0xAB },
	0xE1B7,	{ 0xE5, 0xB2, 0xB1 },
	0xE1B8,	{ 0xE5, 0xB2, 0xA3 },
	0xE1B9,	{ 0xE5, 0xB3, 0x81 },
	0xE1BA,	{ 0xE5, 0xB2, 0xB7 },
	0xE1BB,	{ 0xE5, 0xB3, 0x84 },
	0xE1BC,	{ 0xE5, 0xB3, 0x92 },
	0xE1BD,	{ 0xE5, 0xB3, 0xA4 },
	0xE1BE,	{ 0xE5, 0xB3, 0x8B },
	0xE1BF,	{ 0xE5, 0xB3, 0xA5 },
	0xE1C0,	{ 0xE5, 0xB4, 0x82 },
	0xE1C1,	{ 0xE5, 0xB4, 0x83 },
	0xE1C2,	{ 0xE5, 0xB4, 0xA7 },
	0xE1C3,	{ 0xE5, 0xB4, 0xA6 },
	0xE1C4,	{ 0xE5, 0xB4, 0xAE },
	0xE1C5,	{ 0xE5, 0xB4, 0xA4 },
	0xE1C6,	{ 0xE5, 0xB4, 0x9E },
	0xE1C7,	{ 0xE5, 0xB4, 0x86 },
	0xE1C8,	{ 0xE5, 0xB4, 0x9B },
	0xE1C9,	{ 0xE5, 0xB5, 0x98 },
	0xE1CA,	{ 0xE5, 0xB4, 0xBE },
	0xE1CB,	{ 0xE5, 0xB4, 0xB4 },
	0xE1CC,	{ 0xE5, 0xB4, 0xBD },
	0xE1CD,	{ 0xE5, 0xB5, 0xAC },
	0xE1CE,	{ 0xE5, 0xB5, 0x9B },
	0xE1CF,	{ 0xE5, 0xB5, 0xAF },
	0xE1D0,	{ 0xE5, 0xB5, 0x9D },
	0xE1D1,	{ 0xE5, 0xB5, 0xAB },
	0xE1D2,	{ 0xE5, 0xB5, 0x8B },
	0xE1D3,	{ 0xE5, 0xB5, 0x8A },
	0xE1D4,	{ 0xE5, 0xB5, 0xA9 },
	0xE1D5,	{ 0xE5, 0xB5, 0xB4 },
	0xE1D6,	{ 0xE5, 0xB6, 0x82 },
	0xE1D7,	{ 0xE5, 0xB6, 0x99 },
	0xE1D8,	{ 0xE5, 0xB6, 0x9D },
	0xE1D9,	{ 0xE8, 0xB1, 0xB3 },
	0xE1DA,	{ 0xE5, 0xB6, 0xB7 },
	0xE1DB,	{ 0xE5, 0xB7, 0x85 },
	0xE1DC,	{ 0xE5, 0xBD, 0xB3 },
	0xE1DD,	{ 0xE5, 0xBD, 0xB7 },
	0xE1DE,	{ 0xE5, 0xBE, 0x82 },
	0xE1DF,	{ 0xE5, 0xBE, 0x87 },
	0xE1E0,	{ 0xE5, 0xBE, 0x89 },
	0xE1E1,	{ 0xE5, 0xBE, 0x8C },
	0xE1E2,	{ 0xE5, 0xBE, 0x95 },
	0xE1E3,	{ 0xE5, 0xBE, 0x99 },
	0xE1E4,	{ 0xE5, 0xBE, 0x9C },
	0xE1E5,	{ 0xE5, 0xBE, 0xA8 },
	0xE1E6,	{ 0xE5, 0xBE, 0xAD },
	0xE1E7,	{ 0xE5, 0xBE, 0xB5 },
	0xE1E8,	{ 0xE5, 0xBE, 0xBC },
	0xE1E9,	{ 0xE8, 0xA1, 0xA2 },
	0xE1EA,	{ 0xE5, 0xBD, 0xA1 },
	0xE1EB,	{ 0xE7, 0x8A, 0xAD },
	0xE1EC,	{ 0xE7, 0x8A, 0xB0 },
	0xE1ED,	{ 0xE7, 0x8A, 0xB4 },
	0xE1EE,	{ 0xE7, 0x8A, 0xB7 },
	0xE1EF,	{ 0xE7, 0x8A, 0xB8 },
	0xE1F0,	{ 0xE7, 0x8B, 0x83 },
	0xE1F1,	{ 0xE7, 0x8B, 0x81 },
	0xE1F2,	{ 0xE7, 0x8B, 0x8E },
	0xE1F3,	{ 0xE7, 0x8B, 0x8D },
	0xE1F4,	{ 0xE7, 0x8B, 0x92 },
	0xE1F5,	{ 0xE7, 0x8B, 0xA8 },
	0xE1F6,	{ 0xE7, 0x8B, 0xAF },
	0xE1F7,	{ 0xE7, 0x8B, 0xA9 },
	0xE1F8,	{ 0xE7, 0x8B, 0xB2 },
	0xE1F9,	{ 0xE7, 0x8B, 0xB4 },
	0xE1FA,	{ 0xE7, 0x8B, 0xB7 },
	0xE1FB,	{ 0xE7, 0x8C, 0x81 },
	0xE1FC,	{ 0xE7, 0x8B, 0xB3 },
	0xE1FD,	{ 0xE7, 0x8C, 0x83 },
	0xE1FE,	{ 0xE7, 0x8B, 0xBA },
	0xE240,	{ 0xE9, 0x87, 0xA6 },
	0xE241,	{ 0xE9, 0x87, 0xA7 },
	0xE242,	{ 0xE9, 0x87, 0xA8 },
	0xE243,	{ 0xE9, 0x87, 0xA9 },
	0xE244,	{ 0xE9, 0x87, 0xAA },
	0xE245,	{ 0xE9, 0x87, 0xAB },
	0xE246,	{ 0xE9, 0x87, 0xAC },
	0xE247,	{ 0xE9, 0x87, 0xAD },
	0xE248,	{ 0xE9, 0x87, 0xAE },
	0xE249,	{ 0xE9, 0x87, 0xAF },
	0xE24A,	{ 0xE9, 0x87, 0xB0 },
	0xE24B,	{ 0xE9, 0x87, 0xB1 },
	0xE24C,	{ 0xE9, 0x87, 0xB2 },
	0xE24D,	{ 0xE9, 0x87, 0xB3 },
	0xE24E,	{ 0xE9, 0x87, 0xB4 },
	0xE24F,	{ 0xE9, 0x87, 0xB5 },
	0xE250,	{ 0xE9, 0x87, 0xB6 },
	0xE251,	{ 0xE9, 0x87, 0xB7 },
	0xE252,	{ 0xE9, 0x87, 0xB8 },
	0xE253,	{ 0xE9, 0x87, 0xB9 },
	0xE254,	{ 0xE9, 0x87, 0xBA },
	0xE255,	{ 0xE9, 0x87, 0xBB },
	0xE256,	{ 0xE9, 0x87, 0xBC },
	0xE257,	{ 0xE9, 0x87, 0xBD },
	0xE258,	{ 0xE9, 0x87, 0xBE },
	0xE259,	{ 0xE9, 0x87, 0xBF },
	0xE25A,	{ 0xE9, 0x88, 0x80 },
	0xE25B,	{ 0xE9, 0x88, 0x81 },
	0xE25C,	{ 0xE9, 0x88, 0x82 },
	0xE25D,	{ 0xE9, 0x88, 0x83 },
	0xE25E,	{ 0xE9, 0x88, 0x84 },
	0xE25F,	{ 0xE9, 0x88, 0x85 },
	0xE260,	{ 0xE9, 0x88, 0x86 },
	0xE261,	{ 0xE9, 0x88, 0x87 },
	0xE262,	{ 0xE9, 0x88, 0x88 },
	0xE263,	{ 0xE9, 0x88, 0x89 },
	0xE264,	{ 0xE9, 0x88, 0x8A },
	0xE265,	{ 0xE9, 0x88, 0x8B },
	0xE266,	{ 0xE9, 0x88, 0x8C },
	0xE267,	{ 0xE9, 0x88, 0x8D },
	0xE268,	{ 0xE9, 0x88, 0x8E },
	0xE269,	{ 0xE9, 0x88, 0x8F },
	0xE26A,	{ 0xE9, 0x88, 0x90 },
	0xE26B,	{ 0xE9, 0x88, 0x91 },
	0xE26C,	{ 0xE9, 0x88, 0x92 },
	0xE26D,	{ 0xE9, 0x88, 0x93 },
	0xE26E,	{ 0xE9, 0x88, 0x94 },
	0xE26F,	{ 0xE9, 0x88, 0x95 },
	0xE270,	{ 0xE9, 0x88, 0x96 },
	0xE271,	{ 0xE9, 0x88, 0x97 },
	0xE272,	{ 0xE9, 0x88, 0x98 },
	0xE273,	{ 0xE9, 0x88, 0x99 },
	0xE274,	{ 0xE9, 0x88, 0x9A },
	0xE275,	{ 0xE9, 0x88, 0x9B },
	0xE276,	{ 0xE9, 0x88, 0x9C },
	0xE277,	{ 0xE9, 0x88, 0x9D },
	0xE278,	{ 0xE9, 0x88, 0x9E },
	0xE279,	{ 0xE9, 0x88, 0x9F },
	0xE27A,	{ 0xE9, 0x88, 0xA0 },
	0xE27B,	{ 0xE9, 0x88, 0xA1 },
	0xE27C,	{ 0xE9, 0x88, 0xA2 },
	0xE27D,	{ 0xE9, 0x88, 0xA3 },
	0xE27E,	{ 0xE9, 0x88, 0xA4 },
	0xE280,	{ 0xE9, 0x88, 0xA5 },
	0xE281,	{ 0xE9, 0x88, 0xA6 },
	0xE282,	{ 0xE9, 0x88, 0xA7 },
	0xE283,	{ 0xE9, 0x88, 0xA8 },
	0xE284,	{ 0xE9, 0x88, 0xA9 },
	0xE285,	{ 0xE9, 0x88, 0xAA },
	0xE286,	{ 0xE9, 0x88, 0xAB },
	0xE287,	{ 0xE9, 0x88, 0xAC },
	0xE288,	{ 0xE9, 0x88, 0xAD },
	0xE289,	{ 0xE9, 0x88, 0xAE },
	0xE28A,	{ 0xE9, 0x88, 0xAF },
	0xE28B,	{ 0xE9, 0x88, 0xB0 },
	0xE28C,	{ 0xE9, 0x88, 0xB1 },
	0xE28D,	{ 0xE9, 0x88, 0xB2 },
	0xE28E,	{ 0xE9, 0x88, 0xB3 },
	0xE28F,	{ 0xE9, 0x88, 0xB4 },
	0xE290,	{ 0xE9, 0x88, 0xB5 },
	0xE291,	{ 0xE9, 0x88, 0xB6 },
	0xE292,	{ 0xE9, 0x88, 0xB7 },
	0xE293,	{ 0xE9, 0x88, 0xB8 },
	0xE294,	{ 0xE9, 0x88, 0xB9 },
	0xE295,	{ 0xE9, 0x88, 0xBA },
	0xE296,	{ 0xE9, 0x88, 0xBB },
	0xE297,	{ 0xE9, 0x88, 0xBC },
	0xE298,	{ 0xE9, 0x88, 0xBD },
	0xE299,	{ 0xE9, 0x88, 0xBE },
	0xE29A,	{ 0xE9, 0x88, 0xBF },
	0xE29B,	{ 0xE9, 0x89, 0x80 },
	0xE29C,	{ 0xE9, 0x89, 0x81 },
	0xE29D,	{ 0xE9, 0x89, 0x82 },
	0xE29E,	{ 0xE9, 0x89, 0x83 },
	0xE29F,	{ 0xE9, 0x89, 0x84 },
	0xE2A0,	{ 0xE9, 0x89, 0x85 },
	0xE2A1,	{ 0xE7, 0x8B, 0xBB },
	0xE2A2,	{ 0xE7, 0x8C, 0x97 },
	0xE2A3,	{ 0xE7, 0x8C, 0x93 },
	0xE2A4,	{ 0xE7, 0x8C, 0xA1 },
	0xE2A5,	{ 0xE7, 0x8C, 0x8A },
	0xE2A6,	{ 0xE7, 0x8C, 0x9E },
	0xE2A7,	{ 0xE7, 0x8C, 0x9D },
	0xE2A8,	{ 0xE7, 0x8C, 0x95 },
	0xE2A9,	{ 0xE7, 0x8C, 0xA2 },
	0xE2AA,	{ 0xE7, 0x8C, 0xB9 },
	0xE2AB,	{ 0xE7, 0x8C, 0xA5 },
	0xE2AC,	{ 0xE7, 0x8C, 0xAC },
	0xE2AD,	{ 0xE7, 0x8C, 0xB8 },
	0xE2AE,	{ 0xE7, 0x8C, 0xB1 },
	0xE2AF,	{ 0xE7, 0x8D, 0x90 },
	0xE2B0,	{ 0xE7, 0x8D, 0x8D },
	0xE2B1,	{ 0xE7, 0x8D, 0x97 },
	0xE2B2,	{ 0xE7, 0x8D, 0xA0 },
	0xE2B3,	{ 0xE7, 0x8D, 0xAC },
	0xE2B4,	{ 0xE7, 0x8D, 0xAF },
	0xE2B5,	{ 0xE7, 0x8D, 0xBE },
	0xE2B6,	{ 0xE8, 0x88, 0x9B },
	0xE2B7,	{ 0xE5, 0xA4, 0xA5 },
	0xE2B8,	{ 0xE9, 0xA3, 0xA7 },
	0xE2B9,	{ 0xE5, 0xA4, 0xA4 },
	0xE2BA,	{ 0xE5, 0xA4, 0x82 },
	0xE2BB,	{ 0xE9, 0xA5, 0xA3 },
	0xE2BC,	{ 0xE9, 0xA5, 0xA7 },
	0xE2BD,	{ 0xE9, 0xA5, 0xA8 },
	0xE2BE,	{ 0xE9, 0xA5, 0xA9 },
	0xE2BF,	{ 0xE9, 0xA5, 0xAA },
	0xE2C0,	{ 0xE9, 0xA5, 0xAB },
	0xE2C1,	{ 0xE9, 0xA5, 0xAC },
	0xE2C2,	{ 0xE9, 0xA5, 0xB4 },
	0xE2C3,	{ 0xE9, 0xA5, 0xB7 },
	0xE2C4,	{ 0xE9, 0xA5, 0xBD },
	0xE2C5,	{ 0xE9, 0xA6, 0x80 },
	0xE2C6,	{ 0xE9, 0xA6, 0x84 },
	0xE2C7,	{ 0xE9, 0xA6, 0x87 },
	0xE2C8,	{ 0xE9, 0xA6, 0x8A },
	0xE2C9,	{ 0xE9, 0xA6, 0x8D },
	0xE2CA,	{ 0xE9, 0xA6, 0x90 },
	0xE2CB,	{ 0xE9, 0xA6, 0x91 },
	0xE2CC,	{ 0xE9, 0xA6, 0x93 },
	0xE2CD,	{ 0xE9, 0xA6, 0x94 },
	0xE2CE,	{ 0xE9, 0xA6, 0x95 },
	0xE2CF,	{ 0xE5, 0xBA, 0x80 },
	0xE2D0,	{ 0xE5, 0xBA, 0x91 },
	0xE2D1,	{ 0xE5, 0xBA, 0x8B },
	0xE2D2,	{ 0xE5, 0xBA, 0x96 },
	0xE2D3,	{ 0xE5, 0xBA, 0xA5 },
	0xE2D4,	{ 0xE5, 0xBA, 0xA0 },
	0xE2D5,	{ 0xE5, 0xBA, 0xB9 },
	0xE2D6,	{ 0xE5, 0xBA, 0xB5 },
	0xE2D7,	{ 0xE5, 0xBA, 0xBE },
	0xE2D8,	{ 0xE5, 0xBA, 0xB3 },
	0xE2D9,	{ 0xE8, 0xB5, 0x93 },
	0xE2DA,	{ 0xE5, 0xBB, 0x92 },
	0xE2DB,	{ 0xE5, 0xBB, 0x91 },
	0xE2DC,	{ 0xE5, 0xBB, 0x9B },
	0xE2DD,	{ 0xE5, 0xBB, 0xA8 },
	0xE2DE,	{ 0xE5, 0xBB, 0xAA },
	0xE2DF,	{ 0xE8, 0x86, 0xBA },
	0xE2E0,	{ 0xE5, 0xBF, 0x84 },
	0xE2E1,	{ 0xE5, 0xBF, 0x89 },
	0xE2E2,	{ 0xE5, 0xBF, 0x96 },
	0xE2E3,	{ 0xE5, 0xBF, 0x8F },
	0xE2E4,	{ 0xE6, 0x80, 0x83 },
	0xE2E5,	{ 0xE5, 0xBF, 0xAE },
	0xE2E6,	{ 0xE6, 0x80, 0x84 },
	0xE2E7,	{ 0xE5, 0xBF, 0xA1 },
	0xE2E8,	{ 0xE5, 0xBF, 0xA4 },
	0xE2E9,	{ 0xE5, 0xBF, 0xBE },
	0xE2EA,	{ 0xE6, 0x80, 0x85 },
	0xE2EB,	{ 0xE6, 0x80, 0x86 },
	0xE2EC,	{ 0xE5, 0xBF, 0xAA },
	0xE2ED,	{ 0xE5, 0xBF, 0xAD },
	0xE2EE,	{ 0xE5, 0xBF, 0xB8 },
	0xE2EF,	{ 0xE6, 0x80, 0x99 },
	0xE2F0,	{ 0xE6, 0x80, 0xB5 },
	0xE2F1,	{ 0xE6, 0x80, 0xA6 },
	0xE2F2,	{ 0xE6, 0x80, 0x9B },
	0xE2F3,	{ 0xE6, 0x80, 0x8F },
	0xE2F4,	{ 0xE6, 0x80, 0x8D },
	0xE2F5,	{ 0xE6, 0x80, 0xA9 },
	0xE2F6,	{ 0xE6, 0x80, 0xAB },
	0xE2F7,	{ 0xE6, 0x80, 0x8A },
	0xE2F8,	{ 0xE6, 0x80, 0xBF },
	0xE2F9,	{ 0xE6, 0x80, 0xA1 },
	0xE2FA,	{ 0xE6, 0x81, 0xB8 },
	0xE2FB,	{ 0xE6, 0x81, 0xB9 },
	0xE2FC,	{ 0xE6, 0x81, 0xBB },
	0xE2FD,	{ 0xE6, 0x81, 0xBA },
	0xE2FE,	{ 0xE6, 0x81, 0x82 },
	0xE340,	{ 0xE9, 0x89, 0x86 },
	0xE341,	{ 0xE9, 0x89, 0x87 },
	0xE342,	{ 0xE9, 0x89, 0x88 },
	0xE343,	{ 0xE9, 0x89, 0x89 },
	0xE344,	{ 0xE9, 0x89, 0x8A },
	0xE345,	{ 0xE9, 0x89, 0x8B },
	0xE346,	{ 0xE9, 0x89, 0x8C },
	0xE347,	{ 0xE9, 0x89, 0x8D },
	0xE348,	{ 0xE9, 0x89, 0x8E },
	0xE349,	{ 0xE9, 0x89, 0x8F },
	0xE34A,	{ 0xE9, 0x89, 0x90 },
	0xE34B,	{ 0xE9, 0x89, 0x91 },
	0xE34C,	{ 0xE9, 0x89, 0x92 },
	0xE34D,	{ 0xE9, 0x89, 0x93 },
	0xE34E,	{ 0xE9, 0x89, 0x94 },
	0xE34F,	{ 0xE9, 0x89, 0x95 },
	0xE350,	{ 0xE9, 0x89, 0x96 },
	0xE351,	{ 0xE9, 0x89, 0x97 },
	0xE352,	{ 0xE9, 0x89, 0x98 },
	0xE353,	{ 0xE9, 0x89, 0x99 },
	0xE354,	{ 0xE9, 0x89, 0x9A },
	0xE355,	{ 0xE9, 0x89, 0x9B },
	0xE356,	{ 0xE9, 0x89, 0x9C },
	0xE357,	{ 0xE9, 0x89, 0x9D },
	0xE358,	{ 0xE9, 0x89, 0x9E },
	0xE359,	{ 0xE9, 0x89, 0x9F },
	0xE35A,	{ 0xE9, 0x89, 0xA0 },
	0xE35B,	{ 0xE9, 0x89, 0xA1 },
	0xE35C,	{ 0xE9, 0x89, 0xA2 },
	0xE35D,	{ 0xE9, 0x89, 0xA3 },
	0xE35E,	{ 0xE9, 0x89, 0xA4 },
	0xE35F,	{ 0xE9, 0x89, 0xA5 },
	0xE360,	{ 0xE9, 0x89, 0xA6 },
	0xE361,	{ 0xE9, 0x89, 0xA7 },
	0xE362,	{ 0xE9, 0x89, 0xA8 },
	0xE363,	{ 0xE9, 0x89, 0xA9 },
	0xE364,	{ 0xE9, 0x89, 0xAA },
	0xE365,	{ 0xE9, 0x89, 0xAB },
	0xE366,	{ 0xE9, 0x89, 0xAC },
	0xE367,	{ 0xE9, 0x89, 0xAD },
	0xE368,	{ 0xE9, 0x89, 0xAE },
	0xE369,	{ 0xE9, 0x89, 0xAF },
	0xE36A,	{ 0xE9, 0x89, 0xB0 },
	0xE36B,	{ 0xE9, 0x89, 0xB1 },
	0xE36C,	{ 0xE9, 0x89, 0xB2 },
	0xE36D,	{ 0xE9, 0x89, 0xB3 },
	0xE36E,	{ 0xE9, 0x89, 0xB5 },
	0xE36F,	{ 0xE9, 0x89, 0xB6 },
	0xE370,	{ 0xE9, 0x89, 0xB7 },
	0xE371,	{ 0xE9, 0x89, 0xB8 },
	0xE372,	{ 0xE9, 0x89, 0xB9 },
	0xE373,	{ 0xE9, 0x89, 0xBA },
	0xE374,	{ 0xE9, 0x89, 0xBB },
	0xE375,	{ 0xE9, 0x89, 0xBC },
	0xE376,	{ 0xE9, 0x89, 0xBD },
	0xE377,	{ 0xE9, 0x89, 0xBE },
	0xE378,	{ 0xE9, 0x89, 0xBF },
	0xE379,	{ 0xE9, 0x8A, 0x80 },
	0xE37A,	{ 0xE9, 0x8A, 0x81 },
	0xE37B,	{ 0xE9, 0x8A, 0x82 },
	0xE37C,	{ 0xE9, 0x8A, 0x83 },
	0xE37D,	{ 0xE9, 0x8A, 0x84 },
	0xE37E,	{ 0xE9, 0x8A, 0x85 },
	0xE380,	{ 0xE9, 0x8A, 0x86 },
	0xE381,	{ 0xE9, 0x8A, 0x87 },
	0xE382,	{ 0xE9, 0x8A, 0x88 },
	0xE383,	{ 0xE9, 0x8A, 0x89 },
	0xE384,	{ 0xE9, 0x8A, 0x8A },
	0xE385,	{ 0xE9, 0x8A, 0x8B },
	0xE386,	{ 0xE9, 0x8A, 0x8C },
	0xE387,	{ 0xE9, 0x8A, 0x8D },
	0xE388,	{ 0xE9, 0x8A, 0x8F },
	0xE389,	{ 0xE9, 0x8A, 0x90 },
	0xE38A,	{ 0xE9, 0x8A, 0x91 },
	0xE38B,	{ 0xE9, 0x8A, 0x92 },
	0xE38C,	{ 0xE9, 0x8A, 0x93 },
	0xE38D,	{ 0xE9, 0x8A, 0x94 },
	0xE38E,	{ 0xE9, 0x8A, 0x95 },
	0xE38F,	{ 0xE9, 0x8A, 0x96 },
	0xE390,	{ 0xE9, 0x8A, 0x97 },
	0xE391,	{ 0xE9, 0x8A, 0x98 },
	0xE392,	{ 0xE9, 0x8A, 0x99 },
	0xE393,	{ 0xE9, 0x8A, 0x9A },
	0xE394,	{ 0xE9, 0x8A, 0x9B },
	0xE395,	{ 0xE9, 0x8A, 0x9C },
	0xE396,	{ 0xE9, 0x8A, 0x9D },
	0xE397,	{ 0xE9, 0x8A, 0x9E },
	0xE398,	{ 0xE9, 0x8A, 0x9F },
	0xE399,	{ 0xE9, 0x8A, 0xA0 },
	0xE39A,	{ 0xE9, 0x8A, 0xA1 },
	0xE39B,	{ 0xE9, 0x8A, 0xA2 },
	0xE39C,	{ 0xE9, 0x8A, 0xA3 },
	0xE39D,	{ 0xE9, 0x8A, 0xA4 },
	0xE39E,	{ 0xE9, 0x8A, 0xA5 },
	0xE39F,	{ 0xE9, 0x8A, 0xA6 },
	0xE3A0,	{ 0xE9, 0x8A, 0xA7 },
	0xE3A1,	{ 0xE6, 0x81, 0xAA },
	0xE3A2,	{ 0xE6, 0x81, 0xBD },
	0xE3A3,	{ 0xE6, 0x82, 0x96 },
	0xE3A4,	{ 0xE6, 0x82, 0x9A },
	0xE3A5,	{ 0xE6, 0x82, 0xAD },
	0xE3A6,	{ 0xE6, 0x82, 0x9D },
	0xE3A7,	{ 0xE6, 0x82, 0x83 },
	0xE3A8,	{ 0xE6, 0x82, 0x92 },
	0xE3A9,	{ 0xE6, 0x82, 0x8C },
	0xE3AA,	{ 0xE6, 0x82, 0x9B },
	0xE3AB,	{ 0xE6, 0x83, 0xAC },
	0xE3AC,	{ 0xE6, 0x82, 0xBB },
	0xE3AD,	{ 0xE6, 0x82, 0xB1 },
	0xE3AE,	{ 0xE6, 0x83, 0x9D },
	0xE3AF,	{ 0xE6, 0x83, 0x98 },
	0xE3B0,	{ 0xE6, 0x83, 0x86 },
	0xE3B1,	{ 0xE6, 0x83, 0x9A },
	0xE3B2,	{ 0xE6, 0x82, 0xB4 },
	0xE3B3,	{ 0xE6, 0x84, 0xA0 },
	0xE3B4,	{ 0xE6, 0x84, 0xA6 },
	0xE3B5,	{ 0xE6, 0x84, 0x95 },
	0xE3B6,	{ 0xE6, 0x84, 0xA3 },
	0xE3B7,	{ 0xE6, 0x83, 0xB4 },
	0xE3B8,	{ 0xE6, 0x84, 0x80 },
	0xE3B9,	{ 0xE6, 0x84, 0x8E },
	0xE3BA,	{ 0xE6, 0x84, 0xAB },
	0xE3BB,	{ 0xE6, 0x85, 0x8A },
	0xE3BC,	{ 0xE6, 0x85, 0xB5 },
	0xE3BD,	{ 0xE6, 0x86, 0xAC },
	0xE3BE,	{ 0xE6, 0x86, 0x94 },
	0xE3BF,	{ 0xE6, 0x86, 0xA7 },
	0xE3C0,	{ 0xE6, 0x86, 0xB7 },
	0xE3C1,	{ 0xE6, 0x87, 0x94 },
	0xE3C2,	{ 0xE6, 0x87, 0xB5 },
	0xE3C3,	{ 0xE5, 0xBF, 0x9D },
	0xE3C4,	{ 0xE9, 0x9A, 0xB3 },
	0xE3C5,	{ 0xE9, 0x97, 0xA9 },
	0xE3C6,	{ 0xE9, 0x97, 0xAB },
	0xE3C7,	{ 0xE9, 0x97, 0xB1 },
	0xE3C8,	{ 0xE9, 0x97, 0xB3 },
	0xE3C9,	{ 0xE9, 0x97, 0xB5 },
	0xE3CA,	{ 0xE9, 0x97, 0xB6 },
	0xE3CB,	{ 0xE9, 0x97, 0xBC },
	0xE3CC,	{ 0xE9, 0x97, 0xBE },
	0xE3CD,	{ 0xE9, 0x98, 0x83 },
	0xE3CE,	{ 0xE9, 0x98, 0x84 },
	0xE3CF,	{ 0xE9, 0x98, 0x86 },
	0xE3D0,	{ 0xE9, 0x98, 0x88 },
	0xE3D1,	{ 0xE9, 0x98, 0x8A },
	0xE3D2,	{ 0xE9, 0x98, 0x8B },
	0xE3D3,	{ 0xE9, 0x98, 0x8C },
	0xE3D4,	{ 0xE9, 0x98, 0x8D },
	0xE3D5,	{ 0xE9, 0x98, 0x8F },
	0xE3D6,	{ 0xE9, 0x98, 0x92 },
	0xE3D7,	{ 0xE9, 0x98, 0x95 },
	0xE3D8,	{ 0xE9, 0x98, 0x96 },
	0xE3D9,	{ 0xE9, 0x98, 0x97 },
	0xE3DA,	{ 0xE9, 0x98, 0x99 },
	0xE3DB,	{ 0xE9, 0x98, 0x9A },
	0xE3DC,	{ 0xE4, 0xB8, 0xAC },
	0xE3DD,	{ 0xE7, 0x88, 0xBF },
	0xE3DE,	{ 0xE6, 0x88, 0x95 },
	0xE3DF,	{ 0xE6, 0xB0, 0xB5 },
	0xE3E0,	{ 0xE6, 0xB1, 0x94 },
	0xE3E1,	{ 0xE6, 0xB1, 0x9C },
	0xE3E2,	{ 0xE6, 0xB1, 0x8A },
	0xE3E3,	{ 0xE6, 0xB2, 0xA3 },
	0xE3E4,	{ 0xE6, 0xB2, 0x85 },
	0xE3E5,	{ 0xE6, 0xB2, 0x90 },
	0xE3E6,	{ 0xE6, 0xB2, 0x94 },
	0xE3E7,	{ 0xE6, 0xB2, 0x8C },
	0xE3E8,	{ 0xE6, 0xB1, 0xA8 },
	0xE3E9,	{ 0xE6, 0xB1, 0xA9 },
	0xE3EA,	{ 0xE6, 0xB1, 0xB4 },
	0xE3EB,	{ 0xE6, 0xB1, 0xB6 },
	0xE3EC,	{ 0xE6, 0xB2, 0x86 },
	0xE3ED,	{ 0xE6, 0xB2, 0xA9 },
	0xE3EE,	{ 0xE6, 0xB3, 0x90 },
	0xE3EF,	{ 0xE6, 0xB3, 0x94 },
	0xE3F0,	{ 0xE6, 0xB2, 0xAD },
	0xE3F1,	{ 0xE6, 0xB3, 0xB7 },
	0xE3F2,	{ 0xE6, 0xB3, 0xB8 },
	0xE3F3,	{ 0xE6, 0xB3, 0xB1 },
	0xE3F4,	{ 0xE6, 0xB3, 0x97 },
	0xE3F5,	{ 0xE6, 0xB2, 0xB2 },
	0xE3F6,	{ 0xE6, 0xB3, 0xA0 },
	0xE3F7,	{ 0xE6, 0xB3, 0x96 },
	0xE3F8,	{ 0xE6, 0xB3, 0xBA },
	0xE3F9,	{ 0xE6, 0xB3, 0xAB },
	0xE3FA,	{ 0xE6, 0xB3, 0xAE },
	0xE3FB,	{ 0xE6, 0xB2, 0xB1 },
	0xE3FC,	{ 0xE6, 0xB3, 0x93 },
	0xE3FD,	{ 0xE6, 0xB3, 0xAF },
	0xE3FE,	{ 0xE6, 0xB3, 0xBE },
	0xE440,	{ 0xE9, 0x8A, 0xA8 },
	0xE441,	{ 0xE9, 0x8A, 0xA9 },
	0xE442,	{ 0xE9, 0x8A, 0xAA },
	0xE443,	{ 0xE9, 0x8A, 0xAB },
	0xE444,	{ 0xE9, 0x8A, 0xAC },
	0xE445,	{ 0xE9, 0x8A, 0xAD },
	0xE446,	{ 0xE9, 0x8A, 0xAF },
	0xE447,	{ 0xE9, 0x8A, 0xB0 },
	0xE448,	{ 0xE9, 0x8A, 0xB1 },
	0xE449,	{ 0xE9, 0x8A, 0xB2 },
	0xE44A,	{ 0xE9, 0x8A, 0xB3 },
	0xE44B,	{ 0xE9, 0x8A, 0xB4 },
	0xE44C,	{ 0xE9, 0x8A, 0xB5 },
	0xE44D,	{ 0xE9, 0x8A, 0xB6 },
	0xE44E,	{ 0xE9, 0x8A, 0xB7 },
	0xE44F,	{ 0xE9, 0x8A, 0xB8 },
	0xE450,	{ 0xE9, 0x8A, 0xB9 },
	0xE451,	{ 0xE9, 0x8A, 0xBA },
	0xE452,	{ 0xE9, 0x8A, 0xBB },
	0xE453,	{ 0xE9, 0x8A, 0xBC },
	0xE454,	{ 0xE9, 0x8A, 0xBD },
	0xE455,	{ 0xE9, 0x8A, 0xBE },
	0xE456,	{ 0xE9, 0x8A, 0xBF },
	0xE457,	{ 0xE9, 0x8B, 0x80 },
	0xE458,	{ 0xE9, 0x8B, 0x81 },
	0xE459,	{ 0xE9, 0x8B, 0x82 },
	0xE45A,	{ 0xE9, 0x8B, 0x83 },
	0xE45B,	{ 0xE9, 0x8B, 0x84 },
	0xE45C,	{ 0xE9, 0x8B, 0x85 },
	0xE45D,	{ 0xE9, 0x8B, 0x86 },
	0xE45E,	{ 0xE9, 0x8B, 0x87 },
	0xE45F,	{ 0xE9, 0x8B, 0x89 },
	0xE460,	{ 0xE9, 0x8B, 0x8A },
	0xE461,	{ 0xE9, 0x8B, 0x8B },
	0xE462,	{ 0xE9, 0x8B, 0x8C },
	0xE463,	{ 0xE9, 0x8B, 0x8D },
	0xE464,	{ 0xE9, 0x8B, 0x8E },
	0xE465,	{ 0xE9, 0x8B, 0x8F },
	0xE466,	{ 0xE9, 0x8B, 0x90 },
	0xE467,	{ 0xE9, 0x8B, 0x91 },
	0xE468,	{ 0xE9, 0x8B, 0x92 },
	0xE469,	{ 0xE9, 0x8B, 0x93 },
	0xE46A,	{ 0xE9, 0x8B, 0x94 },
	0xE46B,	{ 0xE9, 0x8B, 0x95 },
	0xE46C,	{ 0xE9, 0x8B, 0x96 },
	0xE46D,	{ 0xE9, 0x8B, 0x97 },
	0xE46E,	{ 0xE9, 0x8B, 0x98 },
	0xE46F,	{ 0xE9, 0x8B, 0x99 },
	0xE470,	{ 0xE9, 0x8B, 0x9A },
	0xE471,	{ 0xE9, 0x8B, 0x9B },
	0xE472,	{ 0xE9, 0x8B, 0x9C },
	0xE473,	{ 0xE9, 0x8B, 0x9D },
	0xE474,	{ 0xE9, 0x8B, 0x9E },
	0xE475,	{ 0xE9, 0x8B, 0x9F },
	0xE476,	{ 0xE9, 0x8B, 0xA0 },
	0xE477,	{ 0xE9, 0x8B, 0xA1 },
	0xE478,	{ 0xE9, 0x8B, 0xA2 },
	0xE479,	{ 0xE9, 0x8B, 0xA3 },
	0xE47A,	{ 0xE9, 0x8B, 0xA4 },
	0xE47B,	{ 0xE9, 0x8B, 0xA5 },
	0xE47C,	{ 0xE9, 0x8B, 0xA6 },
	0xE47D,	{ 0xE9, 0x8B, 0xA7 },
	0xE47E,	{ 0xE9, 0x8B, 0xA8 },
	0xE480,	{ 0xE9, 0x8B, 0xA9 },
	0xE481,	{ 0xE9, 0x8B, 0xAA },
	0xE482,	{ 0xE9, 0x8B, 0xAB },
	0xE483,	{ 0xE9, 0x8B, 0xAC },
	0xE484,	{ 0xE9, 0x8B, 0xAD },
	0xE485,	{ 0xE9, 0x8B, 0xAE },
	0xE486,	{ 0xE9, 0x8B, 0xAF },
	0xE487,	{ 0xE9, 0x8B, 0xB0 },
	0xE488,	{ 0xE9, 0x8B, 0xB1 },
	0xE489,	{ 0xE9, 0x8B, 0xB2 },
	0xE48A,	{ 0xE9, 0x8B, 0xB3 },
	0xE48B,	{ 0xE9, 0x8B, 0xB4 },
	0xE48C,	{ 0xE9, 0x8B, 0xB5 },
	0xE48D,	{ 0xE9, 0x8B, 0xB6 },
	0xE48E,	{ 0xE9, 0x8B, 0xB7 },
	0xE48F,	{ 0xE9, 0x8B, 0xB8 },
	0xE490,	{ 0xE9, 0x8B, 0xB9 },
	0xE491,	{ 0xE9, 0x8B, 0xBA },
	0xE492,	{ 0xE9, 0x8B, 0xBB },
	0xE493,	{ 0xE9, 0x8B, 0xBC },
	0xE494,	{ 0xE9, 0x8B, 0xBD },
	0xE495,	{ 0xE9, 0x8B, 0xBE },
	0xE496,	{ 0xE9, 0x8B, 0xBF },
	0xE497,	{ 0xE9, 0x8C, 0x80 },
	0xE498,	{ 0xE9, 0x8C, 0x81 },
	0xE499,	{ 0xE9, 0x8C, 0x82 },
	0xE49A,	{ 0xE9, 0x8C, 0x83 },
	0xE49B,	{ 0xE9, 0x8C, 0x84 },
	0xE49C,	{ 0xE9, 0x8C, 0x85 },
	0xE49D,	{ 0xE9, 0x8C, 0x86 },
	0xE49E,	{ 0xE9, 0x8C, 0x87 },
	0xE49F,	{ 0xE9, 0x8C, 0x88 },
	0xE4A0,	{ 0xE9, 0x8C, 0x89 },
	0xE4A1,	{ 0xE6, 0xB4, 0xB9 },
	0xE4A2,	{ 0xE6, 0xB4, 0xA7 },
	0xE4A3,	{ 0xE6, 0xB4, 0x8C },
	0xE4A4,	{ 0xE6, 0xB5, 0x83 },
	0xE4A5,	{ 0xE6, 0xB5, 0x88 },
	0xE4A6,	{ 0xE6, 0xB4, 0x87 },
	0xE4A7,	{ 0xE6, 0xB4, 0x84 },
	0xE4A8,	{ 0xE6, 0xB4, 0x99 },
	0xE4A9,	{ 0xE6, 0xB4, 0x8E },
	0xE4AA,	{ 0xE6, 0xB4, 0xAB },
	0xE4AB,	{ 0xE6, 0xB5, 0x8D },
	0xE4AC,	{ 0xE6, 0xB4, 0xAE },
	0xE4AD,	{ 0xE6, 0xB4, 0xB5 },
	0xE4AE,	{ 0xE6, 0xB4, 0x9A },
	0xE4AF,	{ 0xE6, 0xB5, 0x8F },
	0xE4B0,	{ 0xE6, 0xB5, 0x92 },
	0xE4B1,	{ 0xE6, 0xB5, 0x94 },
	0xE4B2,	{ 0xE6, 0xB4, 0xB3 },
	0xE4B3,	{ 0xE6, 0xB6, 0x91 },
	0xE4B4,	{ 0xE6, 0xB5, 0xAF },
	0xE4B5,	{ 0xE6, 0xB6, 0x9E },
	0xE4B6,	{ 0xE6, 0xB6, 0xA0 },
	0xE4B7,	{ 0xE6, 0xB5, 0x9E },
	0xE4B8,	{ 0xE6, 0xB6, 0x93 },
	0xE4B9,	{ 0xE6, 0xB6, 0x94 },
	0xE4BA,	{ 0xE6, 0xB5, 0x9C },
	0xE4BB,	{ 0xE6, 0xB5, 0xA0 },
	0xE4BC,	{ 0xE6, 0xB5, 0xBC },
	0xE4BD,	{ 0xE6, 0xB5, 0xA3 },
	0xE4BE,	{ 0xE6, 0xB8, 0x9A },
	0xE4BF,	{ 0xE6, 0xB7, 0x87 },
	0xE4C0,	{ 0xE6, 0xB7, 0x85 },
	0xE4C1,	{ 0xE6, 0xB7, 0x9E },
	0xE4C2,	{ 0xE6, 0xB8, 0x8E },
	0xE4C3,	{ 0xE6, 0xB6, 0xBF },
	0xE4C4,	{ 0xE6, 0xB7, 0xA0 },
	0xE4C5,	{ 0xE6, 0xB8, 0x91 },
	0xE4C6,	{ 0xE6, 0xB7, 0xA6 },
	0xE4C7,	{ 0xE6, 0xB7, 0x9D },
	0xE4C8,	{ 0xE6, 0xB7, 0x99 },
	0xE4C9,	{ 0xE6, 0xB8, 0x96 },
	0xE4CA,	{ 0xE6, 0xB6, 0xAB },
	0xE4CB,	{ 0xE6, 0xB8, 0x8C },
	0xE4CC,	{ 0xE6, 0xB6, 0xAE },
	0xE4CD,	{ 0xE6, 0xB8, 0xAB },
	0xE4CE,	{ 0xE6, 0xB9, 0xAE },
	0xE4CF,	{ 0xE6, 0xB9, 0x8E },
	0xE4D0,	{ 0xE6, 0xB9, 0xAB },
	0xE4D1,	{ 0xE6, 0xBA, 0xB2 },
	0xE4D2,	{ 0xE6, 0xB9, 0x9F },
	0xE4D3,	{ 0xE6, 0xBA, 0x86 },
	0xE4D4,	{ 0xE6, 0xB9, 0x93 },
	0xE4D5,	{ 0xE6, 0xB9, 0x94 },
	0xE4D6,	{ 0xE6, 0xB8, 0xB2 },
	0xE4D7,	{ 0xE6, 0xB8, 0xA5 },
	0xE4D8,	{ 0xE6, 0xB9, 0x84 },
	0xE4D9,	{ 0xE6, 0xBB, 0x9F },
	0xE4DA,	{ 0xE6, 0xBA, 0xB1 },
	0xE4DB,	{ 0xE6, 0xBA, 0x98 },
	0xE4DC,	{ 0xE6, 0xBB, 0xA0 },
	0xE4DD,	{ 0xE6, 0xBC, 0xAD },
	0xE4DE,	{ 0xE6, 0xBB, 0xA2 },
	0xE4DF,	{ 0xE6, 0xBA, 0xA5 },
	0xE4E0,	{ 0xE6, 0xBA, 0xA7 },
	0xE4E1,	{ 0xE6, 0xBA, 0xBD },
	0xE4E2,	{ 0xE6, 0xBA, 0xBB },
	0xE4E3,	{ 0xE6, 0xBA, 0xB7 },
	0xE4E4,	{ 0xE6, 0xBB, 0x97 },
	0xE4E5,	{ 0xE6, 0xBA, 0xB4 },
	0xE4E6,	{ 0xE6, 0xBB, 0x8F },
	0xE4E7,	{ 0xE6, 0xBA, 0x8F },
	0xE4E8,	{ 0xE6, 0xBB, 0x82 },
	0xE4E9,	{ 0xE6, 0xBA, 0x9F },
	0xE4EA,	{ 0xE6, 0xBD, 0xA2 },
	0xE4EB,	{ 0xE6, 0xBD, 0x86 },
	0xE4EC,	{ 0xE6, 0xBD, 0x87 },
	0xE4ED,	{ 0xE6, 0xBC, 0xA4 },
	0xE4EE,	{ 0xE6, 0xBC, 0x95 },
	0xE4EF,	{ 0xE6, 0xBB, 0xB9 },
	0xE4F0,	{ 0xE6, 0xBC, 0xAF },
	0xE4F1,	{ 0xE6, 0xBC, 0xB6 },
	0xE4F2,	{ 0xE6, 0xBD, 0x8B },
	0xE4F3,	{ 0xE6, 0xBD, 0xB4 },
	0xE4F4,	{ 0xE6, 0xBC, 0xAA },
	0xE4F5,	{ 0xE6, 0xBC, 0x89 },
	0xE4F6,	{ 0xE6, 0xBC, 0xA9 },
	0xE4F7,	{ 0xE6, 0xBE, 0x89 },
	0xE4F8,	{ 0xE6, 0xBE, 0x8D },
	0xE4F9,	{ 0xE6, 0xBE, 0x8C },
	0xE4FA,	{ 0xE6, 0xBD, 0xB8 },
	0xE4FB,	{ 0xE6, 0xBD, 0xB2 },
	0xE4FC,	{ 0xE6, 0xBD, 0xBC },
	0xE4FD,	{ 0xE6, 0xBD, 0xBA },
	0xE4FE,	{ 0xE6, 0xBF, 0x91 },
	0xE540,	{ 0xE9, 0x8C, 0x8A },
	0xE541,	{ 0xE9, 0x8C, 0x8B },
	0xE542,	{ 0xE9, 0x8C, 0x8C },
	0xE543,	{ 0xE9, 0x8C, 0x8D },
	0xE544,	{ 0xE9, 0x8C, 0x8E },
	0xE545,	{ 0xE9, 0x8C, 0x8F },
	0xE546,	{ 0xE9, 0x8C, 0x90 },
	0xE547,	{ 0xE9, 0x8C, 0x91 },
	0xE548,	{ 0xE9, 0x8C, 0x92 },
	0xE549,	{ 0xE9, 0x8C, 0x93 },
	0xE54A,	{ 0xE9, 0x8C, 0x94 },
	0xE54B,	{ 0xE9, 0x8C, 0x95 },
	0xE54C,	{ 0xE9, 0x8C, 0x96 },
	0xE54D,	{ 0xE9, 0x8C, 0x97 },
	0xE54E,	{ 0xE9, 0x8C, 0x98 },
	0xE54F,	{ 0xE9, 0x8C, 0x99 },
	0xE550,	{ 0xE9, 0x8C, 0x9A },
	0xE551,	{ 0xE9, 0x8C, 0x9B },
	0xE552,	{ 0xE9, 0x8C, 0x9C },
	0xE553,	{ 0xE9, 0x8C, 0x9D },
	0xE554,	{ 0xE9, 0x8C, 0x9E },
	0xE555,	{ 0xE9, 0x8C, 0x9F },
	0xE556,	{ 0xE9, 0x8C, 0xA0 },
	0xE557,	{ 0xE9, 0x8C, 0xA1 },
	0xE558,	{ 0xE9, 0x8C, 0xA2 },
	0xE559,	{ 0xE9, 0x8C, 0xA3 },
	0xE55A,	{ 0xE9, 0x8C, 0xA4 },
	0xE55B,	{ 0xE9, 0x8C, 0xA5 },
	0xE55C,	{ 0xE9, 0x8C, 0xA6 },
	0xE55D,	{ 0xE9, 0x8C, 0xA7 },
	0xE55E,	{ 0xE9, 0x8C, 0xA8 },
	0xE55F,	{ 0xE9, 0x8C, 0xA9 },
	0xE560,	{ 0xE9, 0x8C, 0xAA },
	0xE561,	{ 0xE9, 0x8C, 0xAB },
	0xE562,	{ 0xE9, 0x8C, 0xAC },
	0xE563,	{ 0xE9, 0x8C, 0xAD },
	0xE564,	{ 0xE9, 0x8C, 0xAE },
	0xE565,	{ 0xE9, 0x8C, 0xAF },
	0xE566,	{ 0xE9, 0x8C, 0xB0 },
	0xE567,	{ 0xE9, 0x8C, 0xB1 },
	0xE568,	{ 0xE9, 0x8C, 0xB2 },
	0xE569,	{ 0xE9, 0x8C, 0xB3 },
	0xE56A,	{ 0xE9, 0x8C, 0xB4 },
	0xE56B,	{ 0xE9, 0x8C, 0xB5 },
	0xE56C,	{ 0xE9, 0x8C, 0xB6 },
	0xE56D,	{ 0xE9, 0x8C, 0xB7 },
	0xE56E,	{ 0xE9, 0x8C, 0xB8 },
	0xE56F,	{ 0xE9, 0x8C, 0xB9 },
	0xE570,	{ 0xE9, 0x8C, 0xBA },
	0xE571,	{ 0xE9, 0x8C, 0xBB },
	0xE572,	{ 0xE9, 0x8C, 0xBC },
	0xE573,	{ 0xE9, 0x8C, 0xBD },
	0xE574,	{ 0xE9, 0x8C, 0xBF },
	0xE575,	{ 0xE9, 0x8D, 0x80 },
	0xE576,	{ 0xE9, 0x8D, 0x81 },
	0xE577,	{ 0xE9, 0x8D, 0x82 },
	0xE578,	{ 0xE9, 0x8D, 0x83 },
	0xE579,	{ 0xE9, 0x8D, 0x84 },
	0xE57A,	{ 0xE9, 0x8D, 0x85 },
	0xE57B,	{ 0xE9, 0x8D, 0x86 },
	0xE57C,	{ 0xE9, 0x8D, 0x87 },
	0xE57D,	{ 0xE9, 0x8D, 0x88 },
	0xE57E,	{ 0xE9, 0x8D, 0x89 },
	0xE580,	{ 0xE9, 0x8D, 0x8A },
	0xE581,	{ 0xE9, 0x8D, 0x8B },
	0xE582,	{ 0xE9, 0x8D, 0x8C },
	0xE583,	{ 0xE9, 0x8D, 0x8D },
	0xE584,	{ 0xE9, 0x8D, 0x8E },
	0xE585,	{ 0xE9, 0x8D, 0x8F },
	0xE586,	{ 0xE9, 0x8D, 0x90 },
	0xE587,	{ 0xE9, 0x8D, 0x91 },
	0xE588,	{ 0xE9, 0x8D, 0x92 },
	0xE589,	{ 0xE9, 0x8D, 0x93 },
	0xE58A,	{ 0xE9, 0x8D, 0x94 },
	0xE58B,	{ 0xE9, 0x8D, 0x95 },
	0xE58C,	{ 0xE9, 0x8D, 0x96 },
	0xE58D,	{ 0xE9, 0x8D, 0x97 },
	0xE58E,	{ 0xE9, 0x8D, 0x98 },
	0xE58F,	{ 0xE9, 0x8D, 0x99 },
	0xE590,	{ 0xE9, 0x8D, 0x9A },
	0xE591,	{ 0xE9, 0x8D, 0x9B },
	0xE592,	{ 0xE9, 0x8D, 0x9C },
	0xE593,	{ 0xE9, 0x8D, 0x9D },
	0xE594,	{ 0xE9, 0x8D, 0x9E },
	0xE595,	{ 0xE9, 0x8D, 0x9F },
	0xE596,	{ 0xE9, 0x8D, 0xA0 },
	0xE597,	{ 0xE9, 0x8D, 0xA1 },
	0xE598,	{ 0xE9, 0x8D, 0xA2 },
	0xE599,	{ 0xE9, 0x8D, 0xA3 },
	0xE59A,	{ 0xE9, 0x8D, 0xA4 },
	0xE59B,	{ 0xE9, 0x8D, 0xA5 },
	0xE59C,	{ 0xE9, 0x8D, 0xA6 },
	0xE59D,	{ 0xE9, 0x8D, 0xA7 },
	0xE59E,	{ 0xE9, 0x8D, 0xA8 },
	0xE59F,	{ 0xE9, 0x8D, 0xA9 },
	0xE5A0,	{ 0xE9, 0x8D, 0xAB },
	0xE5A1,	{ 0xE6, 0xBF, 0x89 },
	0xE5A2,	{ 0xE6, 0xBE, 0xA7 },
	0xE5A3,	{ 0xE6, 0xBE, 0xB9 },
	0xE5A4,	{ 0xE6, 0xBE, 0xB6 },
	0xE5A5,	{ 0xE6, 0xBF, 0x82 },
	0xE5A6,	{ 0xE6, 0xBF, 0xA1 },
	0xE5A7,	{ 0xE6, 0xBF, 0xAE },
	0xE5A8,	{ 0xE6, 0xBF, 0x9E },
	0xE5A9,	{ 0xE6, 0xBF, 0xA0 },
	0xE5AA,	{ 0xE6, 0xBF, 0xAF },
	0xE5AB,	{ 0xE7, 0x80, 0x9A },
	0xE5AC,	{ 0xE7, 0x80, 0xA3 },
	0xE5AD,	{ 0xE7, 0x80, 0x9B },
	0xE5AE,	{ 0xE7, 0x80, 0xB9 },
	0xE5AF,	{ 0xE7, 0x80, 0xB5 },
	0xE5B0,	{ 0xE7, 0x81, 0x8F },
	0xE5B1,	{ 0xE7, 0x81, 0x9E },
	0xE5B2,	{ 0xE5, 0xAE, 0x80 },
	0xE5B3,	{ 0xE5, 0xAE, 0x84 },
	0xE5B4,	{ 0xE5, 0xAE, 0x95 },
	0xE5B5,	{ 0xE5, 0xAE, 0x93 },
	0xE5B6,	{ 0xE5, 0xAE, 0xA5 },
	0xE5B7,	{ 0xE5, 0xAE, 0xB8 },
	0xE5B8,	{ 0xE7, 0x94, 0xAF },
	0xE5B9,	{ 0xE9, 0xAA, 0x9E },
	0xE5BA,	{ 0xE6, 0x90, 0xB4 },
	0xE5BB,	{ 0xE5, 0xAF, 0xA4 },
	0xE5BC,	{ 0xE5, 0xAF, 0xAE },
	0xE5BD,	{ 0xE8, 0xA4, 0xB0 },
	0xE5BE,	{ 0xE5, 0xAF, 0xB0 },
	0xE5BF,	{ 0xE8, 0xB9, 0x87 },
	0xE5C0,	{ 0xE8, 0xAC, 0x87 },
	0xE5C1,	{ 0xE8, 0xBE, 0xB6 },
	0xE5C2,	{ 0xE8, 0xBF, 0x93 },
	0xE5C3,	{ 0xE8, 0xBF, 0x95 },
	0xE5C4,	{ 0xE8, 0xBF, 0xA5 },
	0xE5C5,	{ 0xE8, 0xBF, 0xAE },
	0xE5C6,	{ 0xE8, 0xBF, 0xA4 },
	0xE5C7,	{ 0xE8, 0xBF, 0xA9 },
	0xE5C8,	{ 0xE8, 0xBF, 0xA6 },
	0xE5C9,	{ 0xE8, 0xBF, 0xB3 },
	0xE5CA,	{ 0xE8, 0xBF, 0xA8 },
	0xE5CB,	{ 0xE9, 0x80, 0x85 },
	0xE5CC,	{ 0xE9, 0x80, 0x84 },
	0xE5CD,	{ 0xE9, 0x80, 0x8B },
	0xE5CE,	{ 0xE9, 0x80, 0xA6 },
	0xE5CF,	{ 0xE9, 0x80, 0x91 },
	0xE5D0,	{ 0xE9, 0x80, 0x8D },
	0xE5D1,	{ 0xE9, 0x80, 0x96 },
	0xE5D2,	{ 0xE9, 0x80, 0xA1 },
	0xE5D3,	{ 0xE9, 0x80, 0xB5 },
	0xE5D4,	{ 0xE9, 0x80, 0xB6 },
	0xE5D5,	{ 0xE9, 0x80, 0xAD },
	0xE5D6,	{ 0xE9, 0x80, 0xAF },
	0xE5D7,	{ 0xE9, 0x81, 0x84 },
	0xE5D8,	{ 0xE9, 0x81, 0x91 },
	0xE5D9,	{ 0xE9, 0x81, 0x92 },
	0xE5DA,	{ 0xE9, 0x81, 0x90 },
	0xE5DB,	{ 0xE9, 0x81, 0xA8 },
	0xE5DC,	{ 0xE9, 0x81, 0x98 },
	0xE5DD,	{ 0xE9, 0x81, 0xA2 },
	0xE5DE,	{ 0xE9, 0x81, 0x9B },
	0xE5DF,	{ 0xE6, 0x9A, 0xB9 },
	0xE5E0,	{ 0xE9, 0x81, 0xB4 },
	0xE5E1,	{ 0xE9, 0x81, 0xBD },
	0xE5E2,	{ 0xE9, 0x82, 0x82 },
	0xE5E3,	{ 0xE9, 0x82, 0x88 },
	0xE5E4,	{ 0xE9, 0x82, 0x83 },
	0xE5E5,	{ 0xE9, 0x82, 0x8B },
	0xE5E6,	{ 0xE5, 0xBD, 0x90 },
	0xE5E7,	{ 0xE5, 0xBD, 0x97 },
	0xE5E8,	{ 0xE5, 0xBD, 0x96 },
	0xE5E9,	{ 0xE5, 0xBD, 0x98 },
	0xE5EA,	{ 0xE5, 0xB0, 0xBB },
	0xE5EB,	{ 0xE5, 0x92, 0xAB },
	0xE5EC,	{ 0xE5, 0xB1, 0x90 },
	0xE5ED,	{ 0xE5, 0xB1, 0x99 },
	0xE5EE,	{ 0xE5, 0xAD, 0xB1 },
	0xE5EF,	{ 0xE5, 0xB1, 0xA3 },
	0xE5F0,	{ 0xE5, 0xB1, 0xA6 },
	0xE5F1,	{ 0xE7, 0xBE, 0xBC },
	0xE5F2,	{ 0xE5, 0xBC, 0xAA },
	0xE5F3,	{ 0xE5, 0xBC, 0xA9 },
	0xE5F4,	{ 0xE5, 0xBC, 0xAD },
	0xE5F5,	{ 0xE8, 0x89, 0xB4 },
	0xE5F6,	{ 0xE5, 0xBC, 0xBC },
	0xE5F7,	{ 0xE9, 0xAC, 0xBB },
	0xE5F8,	{ 0xE5, 0xB1, 0xAE },
	0xE5F9,	{ 0xE5, 0xA6, 0x81 },
	0xE5FA,	{ 0xE5, 0xA6, 0x83 },
	0xE5FB,	{ 0xE5, 0xA6, 0x8D },
	0xE5FC,	{ 0xE5, 0xA6, 0xA9 },
	0xE5FD,	{ 0xE5, 0xA6, 0xAA },
	0xE5FE,	{ 0xE5, 0xA6, 0xA3 },
	0xE640,	{ 0xE9, 0x8D, 0xAC },
	0xE641,	{ 0xE9, 0x8D, 0xAD },
	0xE642,	{ 0xE9, 0x8D, 0xAE },
	0xE643,	{ 0xE9, 0x8D, 0xAF },
	0xE644,	{ 0xE9, 0x8D, 0xB0 },
	0xE645,	{ 0xE9, 0x8D, 0xB1 },
	0xE646,	{ 0xE9, 0x8D, 0xB2 },
	0xE647,	{ 0xE9, 0x8D, 0xB3 },
	0xE648,	{ 0xE9, 0x8D, 0xB4 },
	0xE649,	{ 0xE9, 0x8D, 0xB5 },
	0xE64A,	{ 0xE9, 0x8D, 0xB6 },
	0xE64B,	{ 0xE9, 0x8D, 0xB7 },
	0xE64C,	{ 0xE9, 0x8D, 0xB8 },
	0xE64D,	{ 0xE9, 0x8D, 0xB9 },
	0xE64E,	{ 0xE9, 0x8D, 0xBA },
	0xE64F,	{ 0xE9, 0x8D, 0xBB },
	0xE650,	{ 0xE9, 0x8D, 0xBC },
	0xE651,	{ 0xE9, 0x8D, 0xBD },
	0xE652,	{ 0xE9, 0x8D, 0xBE },
	0xE653,	{ 0xE9, 0x8D, 0xBF },
	0xE654,	{ 0xE9, 0x8E, 0x80 },
	0xE655,	{ 0xE9, 0x8E, 0x81 },
	0xE656,	{ 0xE9, 0x8E, 0x82 },
	0xE657,	{ 0xE9, 0x8E, 0x83 },
	0xE658,	{ 0xE9, 0x8E, 0x84 },
	0xE659,	{ 0xE9, 0x8E, 0x85 },
	0xE65A,	{ 0xE9, 0x8E, 0x86 },
	0xE65B,	{ 0xE9, 0x8E, 0x87 },
	0xE65C,	{ 0xE9, 0x8E, 0x88 },
	0xE65D,	{ 0xE9, 0x8E, 0x89 },
	0xE65E,	{ 0xE9, 0x8E, 0x8A },
	0xE65F,	{ 0xE9, 0x8E, 0x8B },
	0xE660,	{ 0xE9, 0x8E, 0x8C },
	0xE661,	{ 0xE9, 0x8E, 0x8D },
	0xE662,	{ 0xE9, 0x8E, 0x8E },
	0xE663,	{ 0xE9, 0x8E, 0x90 },
	0xE664,	{ 0xE9, 0x8E, 0x91 },
	0xE665,	{ 0xE9, 0x8E, 0x92 },
	0xE666,	{ 0xE9, 0x8E, 0x93 },
	0xE667,	{ 0xE9, 0x8E, 0x94 },
	0xE668,	{ 0xE9, 0x8E, 0x95 },
	0xE669,	{ 0xE9, 0x8E, 0x96 },
	0xE66A,	{ 0xE9, 0x8E, 0x97 },
	0xE66B,	{ 0xE9, 0x8E, 0x98 },
	0xE66C,	{ 0xE9, 0x8E, 0x99 },
	0xE66D,	{ 0xE9, 0x8E, 0x9A },
	0xE66E,	{ 0xE9, 0x8E, 0x9B },
	0xE66F,	{ 0xE9, 0x8E, 0x9C },
	0xE670,	{ 0xE9, 0x8E, 0x9D },
	0xE671,	{ 0xE9, 0x8E, 0x9E },
	0xE672,	{ 0xE9, 0x8E, 0x9F },
	0xE673,	{ 0xE9, 0x8E, 0xA0 },
	0xE674,	{ 0xE9, 0x8E, 0xA1 },
	0xE675,	{ 0xE9, 0x8E, 0xA2 },
	0xE676,	{ 0xE9, 0x8E, 0xA3 },
	0xE677,	{ 0xE9, 0x8E, 0xA4 },
	0xE678,	{ 0xE9, 0x8E, 0xA5 },
	0xE679,	{ 0xE9, 0x8E, 0xA6 },
	0xE67A,	{ 0xE9, 0x8E, 0xA7 },
	0xE67B,	{ 0xE9, 0x8E, 0xA8 },
	0xE67C,	{ 0xE9, 0x8E, 0xA9 },
	0xE67D,	{ 0xE9, 0x8E, 0xAA },
	0xE67E,	{ 0xE9, 0x8E, 0xAB },
	0xE680,	{ 0xE9, 0x8E, 0xAC },
	0xE681,	{ 0xE9, 0x8E, 0xAD },
	0xE682,	{ 0xE9, 0x8E, 0xAE },
	0xE683,	{ 0xE9, 0x8E, 0xAF },
	0xE684,	{ 0xE9, 0x8E, 0xB0 },
	0xE685,	{ 0xE9, 0x8E, 0xB1 },
	0xE686,	{ 0xE9, 0x8E, 0xB2 },
	0xE687,	{ 0xE9, 0x8E, 0xB3 },
	0xE688,	{ 0xE9, 0x8E, 0xB4 },
	0xE689,	{ 0xE9, 0x8E, 0xB5 },
	0xE68A,	{ 0xE9, 0x8E, 0xB6 },
	0xE68B,	{ 0xE9, 0x8E, 0xB7 },
	0xE68C,	{ 0xE9, 0x8E, 0xB8 },
	0xE68D,	{ 0xE9, 0x8E, 0xB9 },
	0xE68E,	{ 0xE9, 0x8E, 0xBA },
	0xE68F,	{ 0xE9, 0x8E, 0xBB },
	0xE690,	{ 0xE9, 0x8E, 0xBC },
	0xE691,	{ 0xE9, 0x8E, 0xBD },
	0xE692,	{ 0xE9, 0x8E, 0xBE },
	0xE693,	{ 0xE9, 0x8E, 0xBF },
	0xE694,	{ 0xE9, 0x8F, 0x80 },
	0xE695,	{ 0xE9, 0x8F, 0x81 },
	0xE696,	{ 0xE9, 0x8F, 0x82 },
	0xE697,	{ 0xE9, 0x8F, 0x83 },
	0xE698,	{ 0xE9, 0x8F, 0x84 },
	0xE699,	{ 0xE9, 0x8F, 0x85 },
	0xE69A,	{ 0xE9, 0x8F, 0x86 },
	0xE69B,	{ 0xE9, 0x8F, 0x87 },
	0xE69C,	{ 0xE9, 0x8F, 0x88 },
	0xE69D,	{ 0xE9, 0x8F, 0x89 },
	0xE69E,	{ 0xE9, 0x8F, 0x8B },
	0xE69F,	{ 0xE9, 0x8F, 0x8C },
	0xE6A0,	{ 0xE9, 0x8F, 0x8D },
	0xE6A1,	{ 0xE5, 0xA6, 0x97 },
	0xE6A2,	{ 0xE5, 0xA7, 0x8A },
	0xE6A3,	{ 0xE5, 0xA6, 0xAB },
	0xE6A4,	{ 0xE5, 0xA6, 0x9E },
	0xE6A5,	{ 0xE5, 0xA6, 0xA4 },
	0xE6A6,	{ 0xE5, 0xA7, 0x92 },
	0xE6A7,	{ 0xE5, 0xA6, 0xB2 },
	0xE6A8,	{ 0xE5, 0xA6, 0xAF },
	0xE6A9,	{ 0xE5, 0xA7, 0x97 },
	0xE6AA,	{ 0xE5, 0xA6, 0xBE },
	0xE6AB,	{ 0xE5, 0xA8, 0x85 },
	0xE6AC,	{ 0xE5, 0xA8, 0x86 },
	0xE6AD,	{ 0xE5, 0xA7, 0x9D },
	0xE6AE,	{ 0xE5, 0xA8, 0x88 },
	0xE6AF,	{ 0xE5, 0xA7, 0xA3 },
	0xE6B0,	{ 0xE5, 0xA7, 0x98 },
	0xE6B1,	{ 0xE5, 0xA7, 0xB9 },
	0xE6B2,	{ 0xE5, 0xA8, 0x8C },
	0xE6B3,	{ 0xE5, 0xA8, 0x89 },
	0xE6B4,	{ 0xE5, 0xA8, 0xB2 },
	0xE6B5,	{ 0xE5, 0xA8, 0xB4 },
	0xE6B6,	{ 0xE5, 0xA8, 0x91 },
	0xE6B7,	{ 0xE5, 0xA8, 0xA3 },
	0xE6B8,	{ 0xE5, 0xA8, 0x93 },
	0xE6B9,	{ 0xE5, 0xA9, 0x80 },
	0xE6BA,	{ 0xE5, 0xA9, 0xA7 },
	0xE6BB,	{ 0xE5, 0xA9, 0x8A },
	0xE6BC,	{ 0xE5, 0xA9, 0x95 },
	0xE6BD,	{ 0xE5, 0xA8, 0xBC },
	0xE6BE,	{ 0xE5, 0xA9, 0xA2 },
	0xE6BF,	{ 0xE5, 0xA9, 0xB5 },
	0xE6C0,	{ 0xE8, 0x83, 0xAC },
	0xE6C1,	{ 0xE5, 0xAA, 0xAA },
	0xE6C2,	{ 0xE5, 0xAA, 0x9B },
	0xE6C3,	{ 0xE5, 0xA9, 0xB7 },
	0xE6C4,	{ 0xE5, 0xA9, 0xBA },
	0xE6C5,	{ 0xE5, 0xAA, 0xBE },
	0xE6C6,	{ 0xE5, 0xAB, 0xAB },
	0xE6C7,	{ 0xE5, 0xAA, 0xB2 },
	0xE6C8,	{ 0xE5, 0xAB, 0x92 },
	0xE6C9,	{ 0xE5, 0xAB, 0x94 },
	0xE6CA,	{ 0xE5, 0xAA, 0xB8 },
	0xE6CB,	{ 0xE5, 0xAB, 0xA0 },
	0xE6CC,	{ 0xE5, 0xAB, 0xA3 },
	0xE6CD,	{ 0xE5, 0xAB, 0xB1 },
	0xE6CE,	{ 0xE5, 0xAB, 0x96 },
	0xE6CF,	{ 0xE5, 0xAB, 0xA6 },
	0xE6D0,	{ 0xE5, 0xAB, 0x98 },
	0xE6D1,	{ 0xE5, 0xAB, 0x9C },
	0xE6D2,	{ 0xE5, 0xAC, 0x89 },
	0xE6D3,	{ 0xE5, 0xAC, 0x97 },
	0xE6D4,	{ 0xE5, 0xAC, 0x96 },
	0xE6D5,	{ 0xE5, 0xAC, 0xB2 },
	0xE6D6,	{ 0xE5, 0xAC, 0xB7 },
	0xE6D7,	{ 0xE5, 0xAD, 0x80 },
	0xE6D8,	{ 0xE5, 0xB0, 0x95 },
	0xE6D9,	{ 0xE5, 0xB0, 0x9C },
	0xE6DA,	{ 0xE5, 0xAD, 0x9A },
	0xE6DB,	{ 0xE5, 0xAD, 0xA5 },
	0xE6DC,	{ 0xE5, 0xAD, 0xB3 },
	0xE6DD,	{ 0xE5, 0xAD, 0x91 },
	0xE6DE,	{ 0xE5, 0xAD, 0x93 },
	0xE6DF,	{ 0xE5, 0xAD, 0xA2 },
	0xE6E0,	{ 0xE9, 0xA9, 0xB5 },
	0xE6E1,	{ 0xE9, 0xA9, 0xB7 },
	0xE6E2,	{ 0xE9, 0xA9, 0xB8 },
	0xE6E3,	{ 0xE9, 0xA9, 0xBA },
	0xE6E4,	{ 0xE9, 0xA9, 0xBF },
	0xE6E5,	{ 0xE9, 0xA9, 0xBD },
	0xE6E6,	{ 0xE9, 0xAA, 0x80 },
	0xE6E7,	{ 0xE9, 0xAA, 0x81 },
	0xE6E8,	{ 0xE9, 0xAA, 0x85 },
	0xE6E9,	{ 0xE9, 0xAA, 0x88 },
	0xE6EA,	{ 0xE9, 0xAA, 0x8A },
	0xE6EB,	{ 0xE9, 0xAA, 0x90 },
	0xE6EC,	{ 0xE9, 0xAA, 0x92 },
	0xE6ED,	{ 0xE9, 0xAA, 0x93 },
	0xE6EE,	{ 0xE9, 0xAA, 0x96 },
	0xE6EF,	{ 0xE9, 0xAA, 0x98 },
	0xE6F0,	{ 0xE9, 0xAA, 0x9B },
	0xE6F1,	{ 0xE9, 0xAA, 0x9C },
	0xE6F2,	{ 0xE9, 0xAA, 0x9D },
	0xE6F3,	{ 0xE9, 0xAA, 0x9F },
	0xE6F4,	{ 0xE9, 0xAA, 0xA0 },
	0xE6F5,	{ 0xE9, 0xAA, 0xA2 },
	0xE6F6,	{ 0xE9, 0xAA, 0xA3 },
	0xE6F7,	{ 0xE9, 0xAA, 0xA5 },
	0xE6F8,	{ 0xE9, 0xAA, 0xA7 },
	0xE6F9,	{ 0xE7, 0xBA, 0x9F },
	0xE6FA,	{ 0xE7, 0xBA, 0xA1 },
	0xE6FB,	{ 0xE7, 0xBA, 0xA3 },
	0xE6FC,	{ 0xE7, 0xBA, 0xA5 },
	0xE6FD,	{ 0xE7, 0xBA, 0xA8 },
	0xE6FE,	{ 0xE7, 0xBA, 0xA9 },
	0xE740,	{ 0xE9, 0x8F, 0x8E },
	0xE741,	{ 0xE9, 0x8F, 0x8F },
	0xE742,	{ 0xE9, 0x8F, 0x90 },
	0xE743,	{ 0xE9, 0x8F, 0x91 },
	0xE744,	{ 0xE9, 0x8F, 0x92 },
	0xE745,	{ 0xE9, 0x8F, 0x93 },
	0xE746,	{ 0xE9, 0x8F, 0x94 },
	0xE747,	{ 0xE9, 0x8F, 0x95 },
	0xE748,	{ 0xE9, 0x8F, 0x97 },
	0xE749,	{ 0xE9, 0x8F, 0x98 },
	0xE74A,	{ 0xE9, 0x8F, 0x99 },
	0xE74B,	{ 0xE9, 0x8F, 0x9A },
	0xE74C,	{ 0xE9, 0x8F, 0x9B },
	0xE74D,	{ 0xE9, 0x8F, 0x9C },
	0xE74E,	{ 0xE9, 0x8F, 0x9D },
	0xE74F,	{ 0xE9, 0x8F, 0x9E },
	0xE750,	{ 0xE9, 0x8F, 0x9F },
	0xE751,	{ 0xE9, 0x8F, 0xA0 },
	0xE752,	{ 0xE9, 0x8F, 0xA1 },
	0xE753,	{ 0xE9, 0x8F, 0xA2 },
	0xE754,	{ 0xE9, 0x8F, 0xA3 },
	0xE755,	{ 0xE9, 0x8F, 0xA4 },
	0xE756,	{ 0xE9, 0x8F, 0xA5 },
	0xE757,	{ 0xE9, 0x8F, 0xA6 },
	0xE758,	{ 0xE9, 0x8F, 0xA7 },
	0xE759,	{ 0xE9, 0x8F, 0xA8 },
	0xE75A,	{ 0xE9, 0x8F, 0xA9 },
	0xE75B,	{ 0xE9, 0x8F, 0xAA },
	0xE75C,	{ 0xE9, 0x8F, 0xAB },
	0xE75D,	{ 0xE9, 0x8F, 0xAC },
	0xE75E,	{ 0xE9, 0x8F, 0xAD },
	0xE75F,	{ 0xE9, 0x8F, 0xAE },
	0xE760,	{ 0xE9, 0x8F, 0xAF },
	0xE761,	{ 0xE9, 0x8F, 0xB0 },
	0xE762,	{ 0xE9, 0x8F, 0xB1 },
	0xE763,	{ 0xE9, 0x8F, 0xB2 },
	0xE764,	{ 0xE9, 0x8F, 0xB3 },
	0xE765,	{ 0xE9, 0x8F, 0xB4 },
	0xE766,	{ 0xE9, 0x8F, 0xB5 },
	0xE767,	{ 0xE9, 0x8F, 0xB6 },
	0xE768,	{ 0xE9, 0x8F, 0xB7 },
	0xE769,	{ 0xE9, 0x8F, 0xB8 },
	0xE76A,	{ 0xE9, 0x8F, 0xB9 },
	0xE76B,	{ 0xE9, 0x8F, 0xBA },
	0xE76C,	{ 0xE9, 0x8F, 0xBB },
	0xE76D,	{ 0xE9, 0x8F, 0xBC },
	0xE76E,	{ 0xE9, 0x8F, 0xBD },
	0xE76F,	{ 0xE9, 0x8F, 0xBE },
	0xE770,	{ 0xE9, 0x8F, 0xBF },
	0xE771,	{ 0xE9, 0x90, 0x80 },
	0xE772,	{ 0xE9, 0x90, 0x81 },
	0xE773,	{ 0xE9, 0x90, 0x82 },
	0xE774,	{ 0xE9, 0x90, 0x83 },
	0xE775,	{ 0xE9, 0x90, 0x84 },
	0xE776,	{ 0xE9, 0x90, 0x85 },
	0xE777,	{ 0xE9, 0x90, 0x86 },
	0xE778,	{ 0xE9, 0x90, 0x87 },
	0xE779,	{ 0xE9, 0x90, 0x88 },
	0xE77A,	{ 0xE9, 0x90, 0x89 },
	0xE77B,	{ 0xE9, 0x90, 0x8A },
	0xE77C,	{ 0xE9, 0x90, 0x8B },
	0xE77D,	{ 0xE9, 0x90, 0x8C },
	0xE77E,	{ 0xE9, 0x90, 0x8D },
	0xE780,	{ 0xE9, 0x90, 0x8E },
	0xE781,	{ 0xE9, 0x90, 0x8F },
	0xE782,	{ 0xE9, 0x90, 0x90 },
	0xE783,	{ 0xE9, 0x90, 0x91 },
	0xE784,	{ 0xE9, 0x90, 0x92 },
	0xE785,	{ 0xE9, 0x90, 0x93 },
	0xE786,	{ 0xE9, 0x90, 0x94 },
	0xE787,	{ 0xE9, 0x90, 0x95 },
	0xE788,	{ 0xE9, 0x90, 0x96 },
	0xE789,	{ 0xE9, 0x90, 0x97 },
	0xE78A,	{ 0xE9, 0x90, 0x98 },
	0xE78B,	{ 0xE9, 0x90, 0x99 },
	0xE78C,	{ 0xE9, 0x90, 0x9A },
	0xE78D,	{ 0xE9, 0x90, 0x9B },
	0xE78E,	{ 0xE9, 0x90, 0x9C },
	0xE78F,	{ 0xE9, 0x90, 0x9D },
	0xE790,	{ 0xE9, 0x90, 0x9E },
	0xE791,	{ 0xE9, 0x90, 0x9F },
	0xE792,	{ 0xE9, 0x90, 0xA0 },
	0xE793,	{ 0xE9, 0x90, 0xA1 },
	0xE794,	{ 0xE9, 0x90, 0xA2 },
	0xE795,	{ 0xE9, 0x90, 0xA3 },
	0xE796,	{ 0xE9, 0x90, 0xA4 },
	0xE797,	{ 0xE9, 0x90, 0xA5 },
	0xE798,	{ 0xE9, 0x90, 0xA6 },
	0xE799,	{ 0xE9, 0x90, 0xA7 },
	0xE79A,	{ 0xE9, 0x90, 0xA8 },
	0xE79B,	{ 0xE9, 0x90, 0xA9 },
	0xE79C,	{ 0xE9, 0x90, 0xAA },
	0xE79D,	{ 0xE9, 0x90, 0xAB },
	0xE79E,	{ 0xE9, 0x90, 0xAC },
	0xE79F,	{ 0xE9, 0x90, 0xAD },
	0xE7A0,	{ 0xE9, 0x90, 0xAE },
	0xE7A1,	{ 0xE7, 0xBA, 0xAD },
	0xE7A2,	{ 0xE7, 0xBA, 0xB0 },
	0xE7A3,	{ 0xE7, 0xBA, 0xBE },
	0xE7A4,	{ 0xE7, 0xBB, 0x80 },
	0xE7A5,	{ 0xE7, 0xBB, 0x81 },
	0xE7A6,	{ 0xE7, 0xBB, 0x82 },
	0xE7A7,	{ 0xE7, 0xBB, 0x89 },
	0xE7A8,	{ 0xE7, 0xBB, 0x8B },
	0xE7A9,	{ 0xE7, 0xBB, 0x8C },
	0xE7AA,	{ 0xE7, 0xBB, 0x90 },
	0xE7AB,	{ 0xE7, 0xBB, 0x94 },
	0xE7AC,	{ 0xE7, 0xBB, 0x97 },
	0xE7AD,	{ 0xE7, 0xBB, 0x9B },
	0xE7AE,	{ 0xE7, 0xBB, 0xA0 },
	0xE7AF,	{ 0xE7, 0xBB, 0xA1 },
	0xE7B0,	{ 0xE7, 0xBB, 0xA8 },
	0xE7B1,	{ 0xE7, 0xBB, 0xAB },
	0xE7B2,	{ 0xE7, 0xBB, 0xAE },
	0xE7B3,	{ 0xE7, 0xBB, 0xAF },
	0xE7B4,	{ 0xE7, 0xBB, 0xB1 },
	0xE7B5,	{ 0xE7, 0xBB, 0xB2 },
	0xE7B6,	{ 0xE7, 0xBC, 0x8D },
	0xE7B7,	{ 0xE7, 0xBB, 0xB6 },
	0xE7B8,	{ 0xE7, 0xBB, 0xBA },
	0xE7B9,	{ 0xE7, 0xBB, 0xBB },
	0xE7BA,	{ 0xE7, 0xBB, 0xBE },
	0xE7BB,	{ 0xE7, 0xBC, 0x81 },
	0xE7BC,	{ 0xE7, 0xBC, 0x82 },
	0xE7BD,	{ 0xE7, 0xBC, 0x83 },
	0xE7BE,	{ 0xE7, 0xBC, 0x87 },
	0xE7BF,	{ 0xE7, 0xBC, 0x88 },
	0xE7C0,	{ 0xE7, 0xBC, 0x8B },
	0xE7C1,	{ 0xE7, 0xBC, 0x8C },
	0xE7C2,	{ 0xE7, 0xBC, 0x8F },
	0xE7C3,	{ 0xE7, 0xBC, 0x91 },
	0xE7C4,	{ 0xE7, 0xBC, 0x92 },
	0xE7C5,	{ 0xE7, 0xBC, 0x97 },
	0xE7C6,	{ 0xE7, 0xBC, 0x99 },
	0xE7C7,	{ 0xE7, 0xBC, 0x9C },
	0xE7C8,	{ 0xE7, 0xBC, 0x9B },
	0xE7C9,	{ 0xE7, 0xBC, 0x9F },
	0xE7CA,	{ 0xE7, 0xBC, 0xA1 },
	0xE7CB,	{ 0xE7, 0xBC, 0xA2 },
	0xE7CC,	{ 0xE7, 0xBC, 0xA3 },
	0xE7CD,	{ 0xE7, 0xBC, 0xA4 },
	0xE7CE,	{ 0xE7, 0xBC, 0xA5 },
	0xE7CF,	{ 0xE7, 0xBC, 0xA6 },
	0xE7D0,	{ 0xE7, 0xBC, 0xA7 },
	0xE7D1,	{ 0xE7, 0xBC, 0xAA },
	0xE7D2,	{ 0xE7, 0xBC, 0xAB },
	0xE7D3,	{ 0xE7, 0xBC, 0xAC },
	0xE7D4,	{ 0xE7, 0xBC, 0xAD },
	0xE7D5,	{ 0xE7, 0xBC, 0xAF },
	0xE7D6,	{ 0xE7, 0xBC, 0xB0 },
	0xE7D7,	{ 0xE7, 0xBC, 0xB1 },
	0xE7D8,	{ 0xE7, 0xBC, 0xB2 },
	0xE7D9,	{ 0xE7, 0xBC, 0xB3 },
	0xE7DA,	{ 0xE7, 0xBC, 0xB5 },
	0xE7DB,	{ 0xE5, 0xB9, 0xBA },
	0xE7DC,	{ 0xE7, 0x95, 0xBF },
	0xE7DD,	{ 0xE5, 0xB7, 0x9B },
	0xE7DE,	{ 0xE7, 0x94, 0xBE },
	0xE7DF,	{ 0xE9, 0x82, 0x95 },
	0xE7E0,	{ 0xE7, 0x8E, 0x8E },
	0xE7E1,	{ 0xE7, 0x8E, 0x91 },
	0xE7E2,	{ 0xE7, 0x8E, 0xAE },
	0xE7E3,	{ 0xE7, 0x8E, 0xA2 },
	0xE7E4,	{ 0xE7, 0x8E, 0x9F },
	0xE7E5,	{ 0xE7, 0x8F, 0x8F },
	0xE7E6,	{ 0xE7, 0x8F, 0x82 },
	0xE7E7,	{ 0xE7, 0x8F, 0x91 },
	0xE7E8,	{ 0xE7, 0x8E, 0xB7 },
	0xE7E9,	{ 0xE7, 0x8E, 0xB3 },
	0xE7EA,	{ 0xE7, 0x8F, 0x80 },
	0xE7EB,	{ 0xE7, 0x8F, 0x89 },
	0xE7EC,	{ 0xE7, 0x8F, 0x88 },
	0xE7ED,	{ 0xE7, 0x8F, 0xA5 },
	0xE7EE,	{ 0xE7, 0x8F, 0x99 },
	0xE7EF,	{ 0xE9, 0xA1, 0xBC },
	0xE7F0,	{ 0xE7, 0x90, 0x8A },
	0xE7F1,	{ 0xE7, 0x8F, 0xA9 },
	0xE7F2,	{ 0xE7, 0x8F, 0xA7 },
	0xE7F3,	{ 0xE7, 0x8F, 0x9E },
	0xE7F4,	{ 0xE7, 0x8E, 0xBA },
	0xE7F5,	{ 0xE7, 0x8F, 0xB2 },
	0xE7F6,	{ 0xE7, 0x90, 0x8F },
	0xE7F7,	{ 0xE7, 0x90, 0xAA },
	0xE7F8,	{ 0xE7, 0x91, 0x9B },
	0xE7F9,	{ 0xE7, 0x90, 0xA6 },
	0xE7FA,	{ 0xE7, 0x90, 0xA5 },
	0xE7FB,	{ 0xE7, 0x90, 0xA8 },
	0xE7FC,	{ 0xE7, 0x90, 0xB0 },
	0xE7FD,	{ 0xE7, 0x90, 0xAE },
	0xE7FE,	{ 0xE7, 0x90, 0xAC },
	0xE840,	{ 0xE9, 0x90, 0xAF },
	0xE841,	{ 0xE9, 0x90, 0xB0 },
	0xE842,	{ 0xE9, 0x90, 0xB1 },
	0xE843,	{ 0xE9, 0x90, 0xB2 },
	0xE844,	{ 0xE9, 0x90, 0xB3 },
	0xE845,	{ 0xE9, 0x90, 0xB4 },
	0xE846,	{ 0xE9, 0x90, 0xB5 },
	0xE847,	{ 0xE9, 0x90, 0xB6 },
	0xE848,	{ 0xE9, 0x90, 0xB7 },
	0xE849,	{ 0xE9, 0x90, 0xB8 },
	0xE84A,	{ 0xE9, 0x90, 0xB9 },
	0xE84B,	{ 0xE9, 0x90, 0xBA },
	0xE84C,	{ 0xE9, 0x90, 0xBB },
	0xE84D,	{ 0xE9, 0x90, 0xBC },
	0xE84E,	{ 0xE9, 0x90, 0xBD },
	0xE84F,	{ 0xE9, 0x90, 0xBF },
	0xE850,	{ 0xE9, 0x91, 0x80 },
	0xE851,	{ 0xE9, 0x91, 0x81 },
	0xE852,	{ 0xE9, 0x91, 0x82 },
	0xE853,	{ 0xE9, 0x91, 0x83 },
	0xE854,	{ 0xE9, 0x91, 0x84 },
	0xE855,	{ 0xE9, 0x91, 0x85 },
	0xE856,	{ 0xE9, 0x91, 0x86 },
	0xE857,	{ 0xE9, 0x91, 0x87 },
	0xE858,	{ 0xE9, 0x91, 0x88 },
	0xE859,	{ 0xE9, 0x91, 0x89 },
	0xE85A,	{ 0xE9, 0x91, 0x8A },
	0xE85B,	{ 0xE9, 0x91, 0x8B },
	0xE85C,	{ 0xE9, 0x91, 0x8C },
	0xE85D,	{ 0xE9, 0x91, 0x8D },
	0xE85E,	{ 0xE9, 0x91, 0x8E },
	0xE85F,	{ 0xE9, 0x91, 0x8F },
	0xE860,	{ 0xE9, 0x91, 0x90 },
	0xE861,	{ 0xE9, 0x91, 0x91 },
	0xE862,	{ 0xE9, 0x91, 0x92 },
	0xE863,	{ 0xE9, 0x91, 0x93 },
	0xE864,	{ 0xE9, 0x91, 0x94 },
	0xE865,	{ 0xE9, 0x91, 0x95 },
	0xE866,	{ 0xE9, 0x91, 0x96 },
	0xE867,	{ 0xE9, 0x91, 0x97 },
	0xE868,	{ 0xE9, 0x91, 0x98 },
	0xE869,	{ 0xE9, 0x91, 0x99 },
	0xE86A,	{ 0xE9, 0x91, 0x9A },
	0xE86B,	{ 0xE9, 0x91, 0x9B },
	0xE86C,	{ 0xE9, 0x91, 0x9C },
	0xE86D,	{ 0xE9, 0x91, 0x9D },
	0xE86E,	{ 0xE9, 0x91, 0x9E },
	0xE86F,	{ 0xE9, 0x91, 0x9F },
	0xE870,	{ 0xE9, 0x91, 0xA0 },
	0xE871,	{ 0xE9, 0x91, 0xA1 },
	0xE872,	{ 0xE9, 0x91, 0xA2 },
	0xE873,	{ 0xE9, 0x91, 0xA3 },
	0xE874,	{ 0xE9, 0x91, 0xA4 },
	0xE875,	{ 0xE9, 0x91, 0xA5 },
	0xE876,	{ 0xE9, 0x91, 0xA6 },
	0xE877,	{ 0xE9, 0x91, 0xA7 },
	0xE878,	{ 0xE9, 0x91, 0xA8 },
	0xE879,	{ 0xE9, 0x91, 0xA9 },
	0xE87A,	{ 0xE9, 0x91, 0xAA },
	0xE87B,	{ 0xE9, 0x91, 0xAC },
	0xE87C,	{ 0xE9, 0x91, 0xAD },
	0xE87D,	{ 0xE9, 0x91, 0xAE },
	0xE87E,	{ 0xE9, 0x91, 0xAF },
	0xE880,	{ 0xE9, 0x91, 0xB0 },
	0xE881,	{ 0xE9, 0x91, 0xB1 },
	0xE882,	{ 0xE9, 0x91, 0xB2 },
	0xE883,	{ 0xE9, 0x91, 0xB3 },
	0xE884,	{ 0xE9, 0x91, 0xB4 },
	0xE885,	{ 0xE9, 0x91, 0xB5 },
	0xE886,	{ 0xE9, 0x91, 0xB6 },
	0xE887,	{ 0xE9, 0x91, 0xB7 },
	0xE888,	{ 0xE9, 0x91, 0xB8 },
	0xE889,	{ 0xE9, 0x91, 0xB9 },
	0xE88A,	{ 0xE9, 0x91, 0xBA },
	0xE88B,	{ 0xE9, 0x91, 0xBB },
	0xE88C,	{ 0xE9, 0x91, 0xBC },
	0xE88D,	{ 0xE9, 0x91, 0xBD },
	0xE88E,	{ 0xE9, 0x91, 0xBE },
	0xE88F,	{ 0xE9, 0x91, 0xBF },
	0xE890,	{ 0xE9, 0x92, 0x80 },
	0xE891,	{ 0xE9, 0x92, 0x81 },
	0xE892,	{ 0xE9, 0x92, 0x82 },
	0xE893,	{ 0xE9, 0x92, 0x83 },
	0xE894,	{ 0xE9, 0x92, 0x84 },
	0xE895,	{ 0xE9, 0x92, 0x91 },
	0xE896,	{ 0xE9, 0x92, 0x96 },
	0xE897,	{ 0xE9, 0x92, 0x98 },
	0xE898,	{ 0xE9, 0x93, 0x87 },
	0xE899,	{ 0xE9, 0x93, 0x8F },
	0xE89A,	{ 0xE9, 0x93, 0x93 },
	0xE89B,	{ 0xE9, 0x93, 0x94 },
	0xE89C,	{ 0xE9, 0x93, 0x9A },
	0xE89D,	{ 0xE9, 0x93, 0xA6 },
	0xE89E,	{ 0xE9, 0x93, 0xBB },
	0xE89F,	{ 0xE9, 0x94, 0x9C },
	0xE8A0,	{ 0xE9, 0x94, 0xA0 },
	0xE8A1,	{ 0xE7, 0x90, 0x9B },
	0xE8A2,	{ 0xE7, 0x90, 0x9A },
	0xE8A3,	{ 0xE7, 0x91, 0x81 },
	0xE8A4,	{ 0xE7, 0x91, 0x9C },
	0xE8A5,	{ 0xE7, 0x91, 0x97 },
	0xE8A6,	{ 0xE7, 0x91, 0x95 },
	0xE8A7,	{ 0xE7, 0x91, 0x99 },
	0xE8A8,	{ 0xE7, 0x91, 0xB7 },
	0xE8A9,	{ 0xE7, 0x91, 0xAD },
	0xE8AA,	{ 0xE7, 0x91, 0xBE },
	0xE8AB,	{ 0xE7, 0x92, 0x9C },
	0xE8AC,	{ 0xE7, 0x92, 0x8E },
	0xE8AD,	{ 0xE7, 0x92, 0x80 },
	0xE8AE,	{ 0xE7, 0x92, 0x81 },
	0xE8AF,	{ 0xE7, 0x92, 0x87 },
	0xE8B0,	{ 0xE7, 0x92, 0x8B },
	0xE8B1,	{ 0xE7, 0x92, 0x9E },
	0xE8B2,	{ 0xE7, 0x92, 0xA8 },
	0xE8B3,	{ 0xE7, 0x92, 0xA9 },
	0xE8B4,	{ 0xE7, 0x92, 0x90 },
	0xE8B5,	{ 0xE7, 0x92, 0xA7 },
	0xE8B6,	{ 0xE7, 0x93, 0x92 },
	0xE8B7,	{ 0xE7, 0x92, 0xBA },
	0xE8B8,	{ 0xE9, 0x9F, 0xAA },
	0xE8B9,	{ 0xE9, 0x9F, 0xAB },
	0xE8BA,	{ 0xE9, 0x9F, 0xAC },
	0xE8BB,	{ 0xE6, 0x9D, 0x8C },
	0xE8BC,	{ 0xE6, 0x9D, 0x93 },
	0xE8BD,	{ 0xE6, 0x9D, 0x9E },
	0xE8BE,	{ 0xE6, 0x9D, 0x88 },
	0xE8BF,	{ 0xE6, 0x9D, 0xA9 },
	0xE8C0,	{ 0xE6, 0x9E, 0xA5 },
	0xE8C1,	{ 0xE6, 0x9E, 0x87 },
	0xE8C2,	{ 0xE6, 0x9D, 0xAA },
	0xE8C3,	{ 0xE6, 0x9D, 0xB3 },
	0xE8C4,	{ 0xE6, 0x9E, 0x98 },
	0xE8C5,	{ 0xE6, 0x9E, 0xA7 },
	0xE8C6,	{ 0xE6, 0x9D, 0xB5 },
	0xE8C7,	{ 0xE6, 0x9E, 0xA8 },
	0xE8C8,	{ 0xE6, 0x9E, 0x9E },
	0xE8C9,	{ 0xE6, 0x9E, 0xAD },
	0xE8CA,	{ 0xE6, 0x9E, 0x8B },
	0xE8CB,	{ 0xE6, 0x9D, 0xB7 },
	0xE8CC,	{ 0xE6, 0x9D, 0xBC },
	0xE8CD,	{ 0xE6, 0x9F, 0xB0 },
	0xE8CE,	{ 0xE6, 0xA0, 0x89 },
	0xE8CF,	{ 0xE6, 0x9F, 0x98 },
	0xE8D0,	{ 0xE6, 0xA0, 0x8A },
	0xE8D1,	{ 0xE6, 0x9F, 0xA9 },
	0xE8D2,	{ 0xE6, 0x9E, 0xB0 },
	0xE8D3,	{ 0xE6, 0xA0, 0x8C },
	0xE8D4,	{ 0xE6, 0x9F, 0x99 },
	0xE8D5,	{ 0xE6, 0x9E, 0xB5 },
	0xE8D6,	{ 0xE6, 0x9F, 0x9A },
	0xE8D7,	{ 0xE6, 0x9E, 0xB3 },
	0xE8D8,	{ 0xE6, 0x9F, 0x9D },
	0xE8D9,	{ 0xE6, 0xA0, 0x80 },
	0xE8DA,	{ 0xE6, 0x9F, 0x83 },
	0xE8DB,	{ 0xE6, 0x9E, 0xB8 },
	0xE8DC,	{ 0xE6, 0x9F, 0xA2 },
	0xE8DD,	{ 0xE6, 0xA0, 0x8E },
	0xE8DE,	{ 0xE6, 0x9F, 0x81 },
	0xE8DF,	{ 0xE6, 0x9F, 0xBD },
	0xE8E0,	{ 0xE6, 0xA0, 0xB2 },
	0xE8E1,	{ 0xE6, 0xA0, 0xB3 },
	0xE8E2,	{ 0xE6, 0xA1, 0xA0 },
	0xE8E3,	{ 0xE6, 0xA1, 0xA1 },
	0xE8E4,	{ 0xE6, 0xA1, 0x8E },
	0xE8E5,	{ 0xE6, 0xA1, 0xA2 },
	0xE8E6,	{ 0xE6, 0xA1, 0x84 },
	0xE8E7,	{ 0xE6, 0xA1, 0xA4 },
	0xE8E8,	{ 0xE6, 0xA2, 0x83 },
	0xE8E9,	{ 0xE6, 0xA0, 0x9D },
	0xE8EA,	{ 0xE6, 0xA1, 0x95 },
	0xE8EB,	{ 0xE6, 0xA1, 0xA6 },
	0xE8EC,	{ 0xE6, 0xA1, 0x81 },
	0xE8ED,	{ 0xE6, 0xA1, 0xA7 },
	0xE8EE,	{ 0xE6, 0xA1, 0x80 },
	0xE8EF,	{ 0xE6, 0xA0, 0xBE },
	0xE8F0,	{ 0xE6, 0xA1, 0x8A },
	0xE8F1,	{ 0xE6, 0xA1, 0x89 },
	0xE8F2,	{ 0xE6, 0xA0, 0xA9 },
	0xE8F3,	{ 0xE6, 0xA2, 0xB5 },
	0xE8F4,	{ 0xE6, 0xA2, 0x8F },
	0xE8F5,	{ 0xE6, 0xA1, 0xB4 },
	0xE8F6,	{ 0xE6, 0xA1, 0xB7 },
	0xE8F7,	{ 0xE6, 0xA2, 0x93 },
	0xE8F8,	{ 0xE6, 0xA1, 0xAB },
	0xE8F9,	{ 0xE6, 0xA3, 0x82 },
	0xE8FA,	{ 0xE6, 0xA5, 0xAE },
	0xE8FB,	{ 0xE6, 0xA3, 0xBC },
	0xE8FC,	{ 0xE6, 0xA4, 0x9F },
	0xE8FD,	{ 0xE6, 0xA4, 0xA0 },
	0xE8FE,	{ 0xE6, 0xA3, 0xB9 },
	0xE940,	{ 0xE9, 0x94, 0xA7 },
	0xE941,	{ 0xE9, 0x94, 0xB3 },
	0xE942,	{ 0xE9, 0x94, 0xBD },
	0xE943,	{ 0xE9, 0x95, 0x83 },
	0xE944,	{ 0xE9, 0x95, 0x88 },
	0xE945,	{ 0xE9, 0x95, 0x8B },
	0xE946,	{ 0xE9, 0x95, 0x95 },
	0xE947,	{ 0xE9, 0x95, 0x9A },
	0xE948,	{ 0xE9, 0x95, 0xA0 },
	0xE949,	{ 0xE9, 0x95, 0xAE },
	0xE94A,	{ 0xE9, 0x95, 0xB4 },
	0xE94B,	{ 0xE9, 0x95, 0xB5 },
	0xE94C,	{ 0xE9, 0x95, 0xB7 },
	0xE94D,	{ 0xE9, 0x95, 0xB8 },
	0xE94E,	{ 0xE9, 0x95, 0xB9 },
	0xE94F,	{ 0xE9, 0x95, 0xBA },
	0xE950,	{ 0xE9, 0x95, 0xBB },
	0xE951,	{ 0xE9, 0x95, 0xBC },
	0xE952,	{ 0xE9, 0x95, 0xBD },
	0xE953,	{ 0xE9, 0x95, 0xBE },
	0xE954,	{ 0xE9, 0x96, 0x80 },
	0xE955,	{ 0xE9, 0x96, 0x81 },
	0xE956,	{ 0xE9, 0x96, 0x82 },
	0xE957,	{ 0xE9, 0x96, 0x83 },
	0xE958,	{ 0xE9, 0x96, 0x84 },
	0xE959,	{ 0xE9, 0x96, 0x85 },
	0xE95A,	{ 0xE9, 0x96, 0x86 },
	0xE95B,	{ 0xE9, 0x96, 0x87 },
	0xE95C,	{ 0xE9, 0x96, 0x88 },
	0xE95D,	{ 0xE9, 0x96, 0x89 },
	0xE95E,	{ 0xE9, 0x96, 0x8A },
	0xE95F,	{ 0xE9, 0x96, 0x8B },
	0xE960,	{ 0xE9, 0x96, 0x8C },
	0xE961,	{ 0xE9, 0x96, 0x8D },
	0xE962,	{ 0xE9, 0x96, 0x8E },
	0xE963,	{ 0xE9, 0x96, 0x8F },
	0xE964,	{ 0xE9, 0x96, 0x90 },
	0xE965,	{ 0xE9, 0x96, 0x91 },
	0xE966,	{ 0xE9, 0x96, 0x92 },
	0xE967,	{ 0xE9, 0x96, 0x93 },
	0xE968,	{ 0xE9, 0x96, 0x94 },
	0xE969,	{ 0xE9, 0x96, 0x95 },
	0xE96A,	{ 0xE9, 0x96, 0x96 },
	0xE96B,	{ 0xE9, 0x96, 0x97 },
	0xE96C,	{ 0xE9, 0x96, 0x98 },
	0xE96D,	{ 0xE9, 0x96, 0x99 },
	0xE96E,	{ 0xE9, 0x96, 0x9A },
	0xE96F,	{ 0xE9, 0x96, 0x9B },
	0xE970,	{ 0xE9, 0x96, 0x9C },
	0xE971,	{ 0xE9, 0x96, 0x9D },
	0xE972,	{ 0xE9, 0x96, 0x9E },
	0xE973,	{ 0xE9, 0x96, 0x9F },
	0xE974,	{ 0xE9, 0x96, 0xA0 },
	0xE975,	{ 0xE9, 0x96, 0xA1 },
	0xE976,	{ 0xE9, 0x96, 0xA2 },
	0xE977,	{ 0xE9, 0x96, 0xA3 },
	0xE978,	{ 0xE9, 0x96, 0xA4 },
	0xE979,	{ 0xE9, 0x96, 0xA5 },
	0xE97A,	{ 0xE9, 0x96, 0xA6 },
	0xE97B,	{ 0xE9, 0x96, 0xA7 },
	0xE97C,	{ 0xE9, 0x96, 0xA8 },
	0xE97D,	{ 0xE9, 0x96, 0xA9 },
	0xE97E,	{ 0xE9, 0x96, 0xAA },
	0xE980,	{ 0xE9, 0x96, 0xAB },
	0xE981,	{ 0xE9, 0x96, 0xAC },
	0xE982,	{ 0xE9, 0x96, 0xAD },
	0xE983,	{ 0xE9, 0x96, 0xAE },
	0xE984,	{ 0xE9, 0x96, 0xAF },
	0xE985,	{ 0xE9, 0x96, 0xB0 },
	0xE986,	{ 0xE9, 0x96, 0xB1 },
	0xE987,	{ 0xE9, 0x96, 0xB2 },
	0xE988,	{ 0xE9, 0x96, 0xB3 },
	0xE989,	{ 0xE9, 0x96, 0xB4 },
	0xE98A,	{ 0xE9, 0x96, 0xB5 },
	0xE98B,	{ 0xE9, 0x96, 0xB6 },
	0xE98C,	{ 0xE9, 0x96, 0xB7 },
	0xE98D,	{ 0xE9, 0x96, 0xB8 },
	0xE98E,	{ 0xE9, 0x96, 0xB9 },
	0xE98F,	{ 0xE9, 0x96, 0xBA },
	0xE990,	{ 0xE9, 0x96, 0xBB },
	0xE991,	{ 0xE9, 0x96, 0xBC },
	0xE992,	{ 0xE9, 0x96, 0xBD },
	0xE993,	{ 0xE9, 0x96, 0xBE },
	0xE994,	{ 0xE9, 0x96, 0xBF },
	0xE995,	{ 0xE9, 0x97, 0x80 },
	0xE996,	{ 0xE9, 0x97, 0x81 },
	0xE997,	{ 0xE9, 0x97, 0x82 },
	0xE998,	{ 0xE9, 0x97, 0x83 },
	0xE999,	{ 0xE9, 0x97, 0x84 },
	0xE99A,	{ 0xE9, 0x97, 0x85 },
	0xE99B,	{ 0xE9, 0x97, 0x86 },
	0xE99C,	{ 0xE9, 0x97, 0x87 },
	0xE99D,	{ 0xE9, 0x97, 0x88 },
	0xE99E,	{ 0xE9, 0x97, 0x89 },
	0xE99F,	{ 0xE9, 0x97, 0x8A },
	0xE9A0,	{ 0xE9, 0x97, 0x8B },
	0xE9A1,	{ 0xE6, 0xA4, 0xA4 },
	0xE9A2,	{ 0xE6, 0xA3, 0xB0 },
	0xE9A3,	{ 0xE6, 0xA4, 0x8B },
	0xE9A4,	{ 0xE6, 0xA4, 0x81 },
	0xE9A5,	{ 0xE6, 0xA5, 0x97 },
	0xE9A6,	{ 0xE6, 0xA3, 0xA3 },
	0xE9A7,	{ 0xE6, 0xA4, 0x90 },
	0xE9A8,	{ 0xE6, 0xA5, 0xB1 },
	0xE9A9,	{ 0xE6, 0xA4, 0xB9 },
	0xE9AA,	{ 0xE6, 0xA5, 0xA0 },
	0xE9AB,	{ 0xE6, 0xA5, 0x82 },
	0xE9AC,	{ 0xE6, 0xA5, 0x9D },
	0xE9AD,	{ 0xE6, 0xA6, 0x84 },
	0xE9AE,	{ 0xE6, 0xA5, 0xAB },
	0xE9AF,	{ 0xE6, 0xA6, 0x80 },
	0xE9B0,	{ 0xE6, 0xA6, 0x98 },
	0xE9B1,	{ 0xE6, 0xA5, 0xB8 },
	0xE9B2,	{ 0xE6, 0xA4, 0xB4 },
	0xE9B3,	{ 0xE6, 0xA7, 0x8C },
	0xE9B4,	{ 0xE6, 0xA6, 0x87 },
	0xE9B5,	{ 0xE6, 0xA6, 0x88 },
	0xE9B6,	{ 0xE6, 0xA7, 0x8E },
	0xE9B7,	{ 0xE6, 0xA6, 0x89 },
	0xE9B8,	{ 0xE6, 0xA5, 0xA6 },
	0xE9B9,	{ 0xE6, 0xA5, 0xA3 },
	0xE9BA,	{ 0xE6, 0xA5, 0xB9 },
	0xE9BB,	{ 0xE6, 0xA6, 0x9B },
	0xE9BC,	{ 0xE6, 0xA6, 0xA7 },
	0xE9BD,	{ 0xE6, 0xA6, 0xBB },
	0xE9BE,	{ 0xE6, 0xA6, 0xAB },
	0xE9BF,	{ 0xE6, 0xA6, 0xAD },
	0xE9C0,	{ 0xE6, 0xA7, 0x94 },
	0xE9C1,	{ 0xE6, 0xA6, 0xB1 },
	0xE9C2,	{ 0xE6, 0xA7, 0x81 },
	0xE9C3,	{ 0xE6, 0xA7, 0x8A },
	0xE9C4,	{ 0xE6, 0xA7, 0x9F },
	0xE9C5,	{ 0xE6, 0xA6, 0x95 },
	0xE9C6,	{ 0xE6, 0xA7, 0xA0 },
	0xE9C7,	{ 0xE6, 0xA6, 0x8D },
	0xE9C8,	{ 0xE6, 0xA7, 0xBF },
	0xE9C9,	{ 0xE6, 0xA8, 0xAF },
	0xE9CA,	{ 0xE6, 0xA7, 0xAD },
	0xE9CB,	{ 0xE6, 0xA8, 0x97 },
	0xE9CC,	{ 0xE6, 0xA8, 0x98 },
	0xE9CD,	{ 0xE6, 0xA9, 0xA5 },
	0xE9CE,	{ 0xE6, 0xA7, 0xB2 },
	0xE9CF,	{ 0xE6, 0xA9, 0x84 },
	0xE9D0,	{ 0xE6, 0xA8, 0xBE },
	0xE9D1,	{ 0xE6, 0xAA, 0xA0 },
	0xE9D2,	{ 0xE6, 0xA9, 0x90 },
	0xE9D3,	{ 0xE6, 0xA9, 0x9B },
	0xE9D4,	{ 0xE6, 0xA8, 0xB5 },
	0xE9D5,	{ 0xE6, 0xAA, 0x8E },
	0xE9D6,	{ 0xE6, 0xA9, 0xB9 },
	0xE9D7,	{ 0xE6, 0xA8, 0xBD },
	0xE9D8,	{ 0xE6, 0xA8, 0xA8 },
	0xE9D9,	{ 0xE6, 0xA9, 0x98 },
	0xE9DA,	{ 0xE6, 0xA9, 0xBC },
	0xE9DB,	{ 0xE6, 0xAA, 0x91 },
	0xE9DC,	{ 0xE6, 0xAA, 0x90 },
	0xE9DD,	{ 0xE6, 0xAA, 0xA9 },
	0xE9DE,	{ 0xE6, 0xAA, 0x97 },
	0xE9DF,	{ 0xE6, 0xAA, 0xAB },
	0xE9E0,	{ 0xE7, 0x8C, 0xB7 },
	0xE9E1,	{ 0xE7, 0x8D, 0x92 },
	0xE9E2,	{ 0xE6, 0xAE, 0x81 },
	0xE9E3,	{ 0xE6, 0xAE, 0x82 },
	0xE9E4,	{ 0xE6, 0xAE, 0x87 },
	0xE9E5,	{ 0xE6, 0xAE, 0x84 },
	0xE9E6,	{ 0xE6, 0xAE, 0x92 },
	0xE9E7,	{ 0xE6, 0xAE, 0x93 },
	0xE9E8,	{ 0xE6, 0xAE, 0x8D },
	0xE9E9,	{ 0xE6, 0xAE, 0x9A },
	0xE9EA,	{ 0xE6, 0xAE, 0x9B },
	0xE9EB,	{ 0xE6, 0xAE, 0xA1 },
	0xE9EC,	{ 0xE6, 0xAE, 0xAA },
	0xE9ED,	{ 0xE8, 0xBD, 0xAB },
	0xE9EE,	{ 0xE8, 0xBD, 0xAD },
	0xE9EF,	{ 0xE8, 0xBD, 0xB1 },
	0xE9F0,	{ 0xE8, 0xBD, 0xB2 },
	0xE9F1,	{ 0xE8, 0xBD, 0xB3 },
	0xE9F2,	{ 0xE8, 0xBD, 0xB5 },
	0xE9F3,	{ 0xE8, 0xBD, 0xB6 },
	0xE9F4,	{ 0xE8, 0xBD, 0xB8 },
	0xE9F5,	{ 0xE8, 0xBD, 0xB7 },
	0xE9F6,	{ 0xE8, 0xBD, 0xB9 },
	0xE9F7,	{ 0xE8, 0xBD, 0xBA },
	0xE9F8,	{ 0xE8, 0xBD, 0xBC },
	0xE9F9,	{ 0xE8, 0xBD, 0xBE },
	0xE9FA,	{ 0xE8, 0xBE, 0x81 },
	0xE9FB,	{ 0xE8, 0xBE, 0x82 },
	0xE9FC,	{ 0xE8, 0xBE, 0x84 },
	0xE9FD,	{ 0xE8, 0xBE, 0x87 },
	0xE9FE,	{ 0xE8, 0xBE, 0x8B },
	0xEA40,	{ 0xE9, 0x97, 0x8C },
	0xEA41,	{ 0xE9, 0x97, 0x8D },
	0xEA42,	{ 0xE9, 0x97, 0x8E },
	0xEA43,	{ 0xE9, 0x97, 0x8F },
	0xEA44,	{ 0xE9, 0x97, 0x90 },
	0xEA45,	{ 0xE9, 0x97, 0x91 },
	0xEA46,	{ 0xE9, 0x97, 0x92 },
	0xEA47,	{ 0xE9, 0x97, 0x93 },
	0xEA48,	{ 0xE9, 0x97, 0x94 },
	0xEA49,	{ 0xE9, 0x97, 0x95 },
	0xEA4A,	{ 0xE9, 0x97, 0x96 },
	0xEA4B,	{ 0xE9, 0x97, 0x97 },
	0xEA4C,	{ 0xE9, 0x97, 0x98 },
	0xEA4D,	{ 0xE9, 0x97, 0x99 },
	0xEA4E,	{ 0xE9, 0x97, 0x9A },
	0xEA4F,	{ 0xE9, 0x97, 0x9B },
	0xEA50,	{ 0xE9, 0x97, 0x9C },
	0xEA51,	{ 0xE9, 0x97, 0x9D },
	0xEA52,	{ 0xE9, 0x97, 0x9E },
	0xEA53,	{ 0xE9, 0x97, 0x9F },
	0xEA54,	{ 0xE9, 0x97, 0xA0 },
	0xEA55,	{ 0xE9, 0x97, 0xA1 },
	0xEA56,	{ 0xE9, 0x97, 0xA2 },
	0xEA57,	{ 0xE9, 0x97, 0xA3 },
	0xEA58,	{ 0xE9, 0x97, 0xA4 },
	0xEA59,	{ 0xE9, 0x97, 0xA5 },
	0xEA5A,	{ 0xE9, 0x97, 0xA6 },
	0xEA5B,	{ 0xE9, 0x97, 0xA7 },
	0xEA5C,	{ 0xE9, 0x97, 0xAC },
	0xEA5D,	{ 0xE9, 0x97, 0xBF },
	0xEA5E,	{ 0xE9, 0x98, 0x87 },
	0xEA5F,	{ 0xE9, 0x98, 0x93 },
	0xEA60,	{ 0xE9, 0x98, 0x98 },
	0xEA61,	{ 0xE9, 0x98, 0x9B },
	0xEA62,	{ 0xE9, 0x98, 0x9E },
	0xEA63,	{ 0xE9, 0x98, 0xA0 },
	0xEA64,	{ 0xE9, 0x98, 0xA3 },
	0xEA65,	{ 0xE9, 0x98, 0xA4 },
	0xEA66,	{ 0xE9, 0x98, 0xA5 },
	0xEA67,	{ 0xE9, 0x98, 0xA6 },
	0xEA68,	{ 0xE9, 0x98, 0xA7 },
	0xEA69,	{ 0xE9, 0x98, 0xA8 },
	0xEA6A,	{ 0xE9, 0x98, 0xA9 },
	0xEA6B,	{ 0xE9, 0x98, 0xAB },
	0xEA6C,	{ 0xE9, 0x98, 0xAC },
	0xEA6D,	{ 0xE9, 0x98, 0xAD },
	0xEA6E,	{ 0xE9, 0x98, 0xAF },
	0xEA6F,	{ 0xE9, 0x98, 0xB0 },
	0xEA70,	{ 0xE9, 0x98, 0xB7 },
	0xEA71,	{ 0xE9, 0x98, 0xB8 },
	0xEA72,	{ 0xE9, 0x98, 0xB9 },
	0xEA73,	{ 0xE9, 0x98, 0xBA },
	0xEA74,	{ 0xE9, 0x98, 0xBE },
	0xEA75,	{ 0xE9, 0x99, 0x81 },
	0xEA76,	{ 0xE9, 0x99, 0x83 },
	0xEA77,	{ 0xE9, 0x99, 0x8A },
	0xEA78,	{ 0xE9, 0x99, 0x8E },
	0xEA79,	{ 0xE9, 0x99, 0x8F },
	0xEA7A,	{ 0xE9, 0x99, 0x91 },
	0xEA7B,	{ 0xE9, 0x99, 0x92 },
	0xEA7C,	{ 0xE9, 0x99, 0x93 },
	0xEA7D,	{ 0xE9, 0x99, 0x96 },
	0xEA7E,	{ 0xE9, 0x99, 0x97 },
	0xEA80,	{ 0xE9, 0x99, 0x98 },
	0xEA81,	{ 0xE9, 0x99, 0x99 },
	0xEA82,	{ 0xE9, 0x99, 0x9A },
	0xEA83,	{ 0xE9, 0x99, 0x9C },
	0xEA84,	{ 0xE9, 0x99, 0x9D },
	0xEA85,	{ 0xE9, 0x99, 0x9E },
	0xEA86,	{ 0xE9, 0x99, 0xA0 },
	0xEA87,	{ 0xE9, 0x99, 0xA3 },
	0xEA88,	{ 0xE9, 0x99, 0xA5 },
	0xEA89,	{ 0xE9, 0x99, 0xA6 },
	0xEA8A,	{ 0xE9, 0x99, 0xAB },
	0xEA8B,	{ 0xE9, 0x99, 0xAD },
	0xEA8C,	{ 0xE9, 0x99, 0xAE },
	0xEA8D,	{ 0xE9, 0x99, 0xAF },
	0xEA8E,	{ 0xE9, 0x99, 0xB0 },
	0xEA8F,	{ 0xE9, 0x99, 0xB1 },
	0xEA90,	{ 0xE9, 0x99, 0xB3 },
	0xEA91,	{ 0xE9, 0x99, 0xB8 },
	0xEA92,	{ 0xE9, 0x99, 0xB9 },
	0xEA93,	{ 0xE9, 0x99, 0xBA },
	0xEA94,	{ 0xE9, 0x99, 0xBB },
	0xEA95,	{ 0xE9, 0x99, 0xBC },
	0xEA96,	{ 0xE9, 0x99, 0xBD },
	0xEA97,	{ 0xE9, 0x99, 0xBE },
	0xEA98,	{ 0xE9, 0x99, 0xBF },
	0xEA99,	{ 0xE9, 0x9A, 0x80 },
	0xEA9A,	{ 0xE9, 0x9A, 0x81 },
	0xEA9B,	{ 0xE9, 0x9A, 0x82 },
	0xEA9C,	{ 0xE9, 0x9A, 0x83 },
	0xEA9D,	{ 0xE9, 0x9A, 0x84 },
	0xEA9E,	{ 0xE9, 0x9A, 0x87 },
	0xEA9F,	{ 0xE9, 0x9A, 0x89 },
	0xEAA0,	{ 0xE9, 0x9A, 0x8A },
	0xEAA1,	{ 0xE8, 0xBE, 0x8D },
	0xEAA2,	{ 0xE8, 0xBE, 0x8E },
	0xEAA3,	{ 0xE8, 0xBE, 0x8F },
	0xEAA4,	{ 0xE8, 0xBE, 0x98 },
	0xEAA5,	{ 0xE8, 0xBE, 0x9A },
	0xEAA6,	{ 0xE8, 0xBB, 0x8E },
	0xEAA7,	{ 0xE6, 0x88, 0x8B },
	0xEAA8,	{ 0xE6, 0x88, 0x97 },
	0xEAA9,	{ 0xE6, 0x88, 0x9B },
	0xEAAA,	{ 0xE6, 0x88, 0x9F },
	0xEAAB,	{ 0xE6, 0x88, 0xA2 },
	0xEAAC,	{ 0xE6, 0x88, 0xA1 },
	0xEAAD,	{ 0xE6, 0x88, 0xA5 },
	0xEAAE,	{ 0xE6, 0x88, 0xA4 },
	0xEAAF,	{ 0xE6, 0x88, 0xAC },
	0xEAB0,	{ 0xE8, 0x87, 0xA7 },
	0xEAB1,	{ 0xE7, 0x93, 0xAF },
	0xEAB2,	{ 0xE7, 0x93, 0xB4 },
	0xEAB3,	{ 0xE7, 0x93, 0xBF },
	0xEAB4,	{ 0xE7, 0x94, 0x8F },
	0xEAB5,	{ 0xE7, 0x94, 0x91 },
	0xEAB6,	{ 0xE7, 0x94, 0x93 },
	0xEAB7,	{ 0xE6, 0x94, 0xB4 },
	0xEAB8,	{ 0xE6, 0x97, 0xAE },
	0xEAB9,	{ 0xE6, 0x97, 0xAF },
	0xEABA,	{ 0xE6, 0x97, 0xB0 },
	0xEABB,	{ 0xE6, 0x98, 0x8A },
	0xEABC,	{ 0xE6, 0x98, 0x99 },
	0xEABD,	{ 0xE6, 0x9D, 0xB2 },
	0xEABE,	{ 0xE6, 0x98, 0x83 },
	0xEABF,	{ 0xE6, 0x98, 0x95 },
	0xEAC0,	{ 0xE6, 0x98, 0x80 },
	0xEAC1,	{ 0xE7, 0x82, 0x85 },
	0xEAC2,	{ 0xE6, 0x9B, 0xB7 },
	0xEAC3,	{ 0xE6, 0x98, 0x9D },
	0xEAC4,	{ 0xE6, 0x98, 0xB4 },
	0xEAC5,	{ 0xE6, 0x98, 0xB1 },
	0xEAC6,	{ 0xE6, 0x98, 0xB6 },
	0xEAC7,	{ 0xE6, 0x98, 0xB5 },
	0xEAC8,	{ 0xE8, 0x80, 0x86 },
	0xEAC9,	{ 0xE6, 0x99, 0x9F },
	0xEACA,	{ 0xE6, 0x99, 0x94 },
	0xEACB,	{ 0xE6, 0x99, 0x81 },
	0xEACC,	{ 0xE6, 0x99, 0x8F },
	0xEACD,	{ 0xE6, 0x99, 0x96 },
	0xEACE,	{ 0xE6, 0x99, 0xA1 },
	0xEACF,	{ 0xE6, 0x99, 0x97 },
	0xEAD0,	{ 0xE6, 0x99, 0xB7 },
	0xEAD1,	{ 0xE6, 0x9A, 0x84 },
	0xEAD2,	{ 0xE6, 0x9A, 0x8C },
	0xEAD3,	{ 0xE6, 0x9A, 0xA7 },
	0xEAD4,	{ 0xE6, 0x9A, 0x9D },
	0xEAD5,	{ 0xE6, 0x9A, 0xBE },
	0xEAD6,	{ 0xE6, 0x9B, 0x9B },
	0xEAD7,	{ 0xE6, 0x9B, 0x9C },
	0xEAD8,	{ 0xE6, 0x9B, 0xA6 },
	0xEAD9,	{ 0xE6, 0x9B, 0xA9 },
	0xEADA,	{ 0xE8, 0xB4, 0xB2 },
	0xEADB,	{ 0xE8, 0xB4, 0xB3 },
	0xEADC,	{ 0xE8, 0xB4, 0xB6 },
	0xEADD,	{ 0xE8, 0xB4, 0xBB },
	0xEADE,	{ 0xE8, 0xB4, 0xBD },
	0xEADF,	{ 0xE8, 0xB5, 0x80 },
	0xEAE0,	{ 0xE8, 0xB5, 0x85 },
	0xEAE1,	{ 0xE8, 0xB5, 0x86 },
	0xEAE2,	{ 0xE8, 0xB5, 0x88 },
	0xEAE3,	{ 0xE8, 0xB5, 0x89 },
	0xEAE4,	{ 0xE8, 0xB5, 0x87 },
	0xEAE5,	{ 0xE8, 0xB5, 0x8D },
	0xEAE6,	{ 0xE8, 0xB5, 0x95 },
	0xEAE7,	{ 0xE8, 0xB5, 0x99 },
	0xEAE8,	{ 0xE8, 0xA7, 0x87 },
	0xEAE9,	{ 0xE8, 0xA7, 0x8A },
	0xEAEA,	{ 0xE8, 0xA7, 0x8B },
	0xEAEB,	{ 0xE8, 0xA7, 0x8C },
	0xEAEC,	{ 0xE8, 0xA7, 0x8E },
	0xEAED,	{ 0xE8, 0xA7, 0x8F },
	0xEAEE,	{ 0xE8, 0xA7, 0x90 },
	0xEAEF,	{ 0xE8, 0xA7, 0x91 },
	0xEAF0,	{ 0xE7, 0x89, 0xAE },
	0xEAF1,	{ 0xE7, 0x8A, 0x9F },
	0xEAF2,	{ 0xE7, 0x89, 0x9D },
	0xEAF3,	{ 0xE7, 0x89, 0xA6 },
	0xEAF4,	{ 0xE7, 0x89, 0xAF },
	0xEAF5,	{ 0xE7, 0x89, 0xBE },
	0xEAF6,	{ 0xE7, 0x89, 0xBF },
	0xEAF7,	{ 0xE7, 0x8A, 0x84 },
	0xEAF8,	{ 0xE7, 0x8A, 0x8B },
	0xEAF9,	{ 0xE7, 0x8A, 0x8D },
	0xEAFA,	{ 0xE7, 0x8A, 0x8F },
	0xEAFB,	{ 0xE7, 0x8A, 0x92 },
	0xEAFC,	{ 0xE6, 0x8C, 0x88 },
	0xEAFD,	{ 0xE6, 0x8C, 0xB2 },
	0xEAFE,	{ 0xE6, 0x8E, 0xB0 },
	0xEB40,	{ 0xE9, 0x9A, 0x8C },
	0xEB41,	{ 0xE9, 0x9A, 0x8E },
	0xEB42,	{ 0xE9, 0x9A, 0x91 },
	0xEB43,	{ 0xE9, 0x9A, 0x92 },
	0xEB44,	{ 0xE9, 0x9A, 0x93 },
	0xEB45,	{ 0xE9, 0x9A, 0x95 },
	0xEB46,	{ 0xE9, 0x9A, 0x96 },
	0xEB47,	{ 0xE9, 0x9A, 0x9A },
	0xEB48,	{ 0xE9, 0x9A, 0x9B },
	0xEB49,	{ 0xE9, 0x9A, 0x9D },
	0xEB4A,	{ 0xE9, 0x9A, 0x9E },
	0xEB4B,	{ 0xE9, 0x9A, 0x9F },
	0xEB4C,	{ 0xE9, 0x9A, 0xA0 },
	0xEB4D,	{ 0xE9, 0x9A, 0xA1 },
	0xEB4E,	{ 0xE9, 0x9A, 0xA2 },
	0xEB4F,	{ 0xE9, 0x9A, 0xA3 },
	0xEB50,	{ 0xE9, 0x9A, 0xA4 },
	0xEB51,	{ 0xE9, 0x9A, 0xA5 },
	0xEB52,	{ 0xE9, 0x9A, 0xA6 },
	0xEB53,	{ 0xE9, 0x9A, 0xA8 },
	0xEB54,	{ 0xE9, 0x9A, 0xA9 },
	0xEB55,	{ 0xE9, 0x9A, 0xAA },
	0xEB56,	{ 0xE9, 0x9A, 0xAB },
	0xEB57,	{ 0xE9, 0x9A, 0xAC },
	0xEB58,	{ 0xE9, 0x9A, 0xAD },
	0xEB59,	{ 0xE9, 0x9A, 0xAE },
	0xEB5A,	{ 0xE9, 0x9A, 0xAF },
	0xEB5B,	{ 0xE9, 0x9A, 0xB1 },
	0xEB5C,	{ 0xE9, 0x9A, 0xB2 },
	0xEB5D,	{ 0xE9, 0x9A, 0xB4 },
	0xEB5E,	{ 0xE9, 0x9A, 0xB5 },
	0xEB5F,	{ 0xE9, 0x9A, 0xB7 },
	0xEB60,	{ 0xE9, 0x9A, 0xB8 },
	0xEB61,	{ 0xE9, 0x9A, 0xBA },
	0xEB62,	{ 0xE9, 0x9A, 0xBB },
	0xEB63,	{ 0xE9, 0x9A, 0xBF },
	0xEB64,	{ 0xE9, 0x9B, 0x82 },
	0xEB65,	{ 0xE9, 0x9B, 0x83 },
	0xEB66,	{ 0xE9, 0x9B, 0x88 },
	0xEB67,	{ 0xE9, 0x9B, 0x8A },
	0xEB68,	{ 0xE9, 0x9B, 0x8B },
	0xEB69,	{ 0xE9, 0x9B, 0x90 },
	0xEB6A,	{ 0xE9, 0x9B, 0x91 },
	0xEB6B,	{ 0xE9, 0x9B, 0x93 },
	0xEB6C,	{ 0xE9, 0x9B, 0x94 },
	0xEB6D,	{ 0xE9, 0x9B, 0x96 },
	0xEB6E,	{ 0xE9, 0x9B, 0x97 },
	0xEB6F,	{ 0xE9, 0x9B, 0x98 },
	0xEB70,	{ 0xE9, 0x9B, 0x99 },
	0xEB71,	{ 0xE9, 0x9B, 0x9A },
	0xEB72,	{ 0xE9, 0x9B, 0x9B },
	0xEB73,	{ 0xE9, 0x9B, 0x9C },
	0xEB74,	{ 0xE9, 0x9B, 0x9D },
	0xEB75,	{ 0xE9, 0x9B, 0x9E },
	0xEB76,	{ 0xE9, 0x9B, 0x9F },
	0xEB77,	{ 0xE9, 0x9B, 0xA1 },
	0xEB78,	{ 0xE9, 0x9B, 0xA2 },
	0xEB79,	{ 0xE9, 0x9B, 0xA3 },
	0xEB7A,	{ 0xE9, 0x9B, 0xA4 },
	0xEB7B,	{ 0xE9, 0x9B, 0xA5 },
	0xEB7C,	{ 0xE9, 0x9B, 0xA6 },
	0xEB7D,	{ 0xE9, 0x9B, 0xA7 },
	0xEB7E,	{ 0xE9, 0x9B, 0xAB },
	0xEB80,	{ 0xE9, 0x9B, 0xAC },
	0xEB81,	{ 0xE9, 0x9B, 0xAD },
	0xEB82,	{ 0xE9, 0x9B, 0xAE },
	0xEB83,	{ 0xE9, 0x9B, 0xB0 },
	0xEB84,	{ 0xE9, 0x9B, 0xB1 },
	0xEB85,	{ 0xE9, 0x9B, 0xB2 },
	0xEB86,	{ 0xE9, 0x9B, 0xB4 },
	0xEB87,	{ 0xE9, 0x9B, 0xB5 },
	0xEB88,	{ 0xE9, 0x9B, 0xB8 },
	0xEB89,	{ 0xE9, 0x9B, 0xBA },
	0xEB8A,	{ 0xE9, 0x9B, 0xBB },
	0xEB8B,	{ 0xE9, 0x9B, 0xBC },
	0xEB8C,	{ 0xE9, 0x9B, 0xBD },
	0xEB8D,	{ 0xE9, 0x9B, 0xBF },
	0xEB8E,	{ 0xE9, 0x9C, 0x82 },
	0xEB8F,	{ 0xE9, 0x9C, 0x83 },
	0xEB90,	{ 0xE9, 0x9C, 0x85 },
	0xEB91,	{ 0xE9, 0x9C, 0x8A },
	0xEB92,	{ 0xE9, 0x9C, 0x8B },
	0xEB93,	{ 0xE9, 0x9C, 0x8C },
	0xEB94,	{ 0xE9, 0x9C, 0x90 },
	0xEB95,	{ 0xE9, 0x9C, 0x91 },
	0xEB96,	{ 0xE9, 0x9C, 0x92 },
	0xEB97,	{ 0xE9, 0x9C, 0x94 },
	0xEB98,	{ 0xE9, 0x9C, 0x95 },
	0xEB99,	{ 0xE9, 0x9C, 0x97 },
	0xEB9A,	{ 0xE9, 0x9C, 0x98 },
	0xEB9B,	{ 0xE9, 0x9C, 0x99 },
	0xEB9C,	{ 0xE9, 0x9C, 0x9A },
	0xEB9D,	{ 0xE9, 0x9C, 0x9B },
	0xEB9E,	{ 0xE9, 0x9C, 0x9D },
	0xEB9F,	{ 0xE9, 0x9C, 0x9F },
	0xEBA0,	{ 0xE9, 0x9C, 0xA0 },
	0xEBA1,	{ 0xE6, 0x90, 0xBF },
	0xEBA2,	{ 0xE6, 0x93, 0x98 },
	0xEBA3,	{ 0xE8, 0x80, 0x84 },
	0xEBA4,	{ 0xE6, 0xAF, 0xAA },
	0xEBA5,	{ 0xE6, 0xAF, 0xB3 },
	0xEBA6,	{ 0xE6, 0xAF, 0xBD },
	0xEBA7,	{ 0xE6, 0xAF, 0xB5 },
	0xEBA8,	{ 0xE6, 0xAF, 0xB9 },
	0xEBA9,	{ 0xE6, 0xB0, 0x85 },
	0xEBAA,	{ 0xE6, 0xB0, 0x87 },
	0xEBAB,	{ 0xE6, 0xB0, 0x86 },
	0xEBAC,	{ 0xE6, 0xB0, 0x8D },
	0xEBAD,	{ 0xE6, 0xB0, 0x95 },
	0xEBAE,	{ 0xE6, 0xB0, 0x98 },
	0xEBAF,	{ 0xE6, 0xB0, 0x99 },
	0xEBB0,	{ 0xE6, 0xB0, 0x9A },
	0xEBB1,	{ 0xE6, 0xB0, 0xA1 },
	0xEBB2,	{ 0xE6, 0xB0, 0xA9 },
	0xEBB3,	{ 0xE6, 0xB0, 0xA4 },
	0xEBB4,	{ 0xE6, 0xB0, 0xAA },
	0xEBB5,	{ 0xE6, 0xB0, 0xB2 },
	0xEBB6,	{ 0xE6, 0x94, 0xB5 },
	0xEBB7,	{ 0xE6, 0x95, 0x95 },
	0xEBB8,	{ 0xE6, 0x95, 0xAB },
	0xEBB9,	{ 0xE7, 0x89, 0x8D },
	0xEBBA,	{ 0xE7, 0x89, 0x92 },
	0xEBBB,	{ 0xE7, 0x89, 0x96 },
	0xEBBC,	{ 0xE7, 0x88, 0xB0 },
	0xEBBD,	{ 0xE8, 0x99, 0xA2 },
	0xEBBE,	{ 0xE5, 0x88, 0x96 },
	0xEBBF,	{ 0xE8, 0x82, 0x9F },
	0xEBC0,	{ 0xE8, 0x82, 0x9C },
	0xEBC1,	{ 0xE8, 0x82, 0x93 },
	0xEBC2,	{ 0xE8, 0x82, 0xBC },
	0xEBC3,	{ 0xE6, 0x9C, 0x8A },
	0xEBC4,	{ 0xE8, 0x82, 0xBD },
	0xEBC5,	{ 0xE8, 0x82, 0xB1 },
	0xEBC6,	{ 0xE8, 0x82, 0xAB },
	0xEBC7,	{ 0xE8, 0x82, 0xAD },
	0xEBC8,	{ 0xE8, 0x82, 0xB4 },
	0xEBC9,	{ 0xE8, 0x82, 0xB7 },
	0xEBCA,	{ 0xE8, 0x83, 0xA7 },
	0xEBCB,	{ 0xE8, 0x83, 0xA8 },
	0xEBCC,	{ 0xE8, 0x83, 0xA9 },
	0xEBCD,	{ 0xE8, 0x83, 0xAA },
	0xEBCE,	{ 0xE8, 0x83, 0x9B },
	0xEBCF,	{ 0xE8, 0x83, 0x82 },
	0xEBD0,	{ 0xE8, 0x83, 0x84 },
	0xEBD1,	{ 0xE8, 0x83, 0x99 },
	0xEBD2,	{ 0xE8, 0x83, 0x8D },
	0xEBD3,	{ 0xE8, 0x83, 0x97 },
	0xEBD4,	{ 0xE6, 0x9C, 0x90 },
	0xEBD5,	{ 0xE8, 0x83, 0x9D },
	0xEBD6,	{ 0xE8, 0x83, 0xAB },
	0xEBD7,	{ 0xE8, 0x83, 0xB1 },
	0xEBD8,	{ 0xE8, 0x83, 0xB4 },
	0xEBD9,	{ 0xE8, 0x83, 0xAD },
	0xEBDA,	{ 0xE8, 0x84, 0x8D },
	0xEBDB,	{ 0xE8, 0x84, 0x8E },
	0xEBDC,	{ 0xE8, 0x83, 0xB2 },
	0xEBDD,	{ 0xE8, 0x83, 0xBC },
	0xEBDE,	{ 0xE6, 0x9C, 0x95 },
	0xEBDF,	{ 0xE8, 0x84, 0x92 },
	0xEBE0,	{ 0xE8, 0xB1, 0x9A },
	0xEBE1,	{ 0xE8, 0x84, 0xB6 },
	0xEBE2,	{ 0xE8, 0x84, 0x9E },
	0xEBE3,	{ 0xE8, 0x84, 0xAC },
	0xEBE4,	{ 0xE8, 0x84, 0x98 },
	0xEBE5,	{ 0xE8, 0x84, 0xB2 },
	0xEBE6,	{ 0xE8, 0x85, 0x88 },
	0xEBE7,	{ 0xE8, 0x85, 0x8C },
	0xEBE8,	{ 0xE8, 0x85, 0x93 },
	0xEBE9,	{ 0xE8, 0x85, 0xB4 },
	0xEBEA,	{ 0xE8, 0x85, 0x99 },
	0xEBEB,	{ 0xE8, 0x85, 0x9A },
	0xEBEC,	{ 0xE8, 0x85, 0xB1 },
	0xEBED,	{ 0xE8, 0x85, 0xA0 },
	0xEBEE,	{ 0xE8, 0x85, 0xA9 },
	0xEBEF,	{ 0xE8, 0x85, 0xBC },
	0xEBF0,	{ 0xE8, 0x85, 0xBD },
	0xEBF1,	{ 0xE8, 0x85, 0xAD },
	0xEBF2,	{ 0xE8, 0x85, 0xA7 },
	0xEBF3,	{ 0xE5, 0xA1, 0x8D },
	0xEBF4,	{ 0xE5, 0xAA, 0xB5 },
	0xEBF5,	{ 0xE8, 0x86, 0x88 },
	0xEBF6,	{ 0xE8, 0x86, 0x82 },
	0xEBF7,	{ 0xE8, 0x86, 0x91 },
	0xEBF8,	{ 0xE6, 0xBB, 0x95 },
	0xEBF9,	{ 0xE8, 0x86, 0xA3 },
	0xEBFA,	{ 0xE8, 0x86, 0xAA },
	0xEBFB,	{ 0xE8, 0x87, 0x8C },
	0xEBFC,	{ 0xE6, 0x9C, 0xA6 },
	0xEBFD,	{ 0xE8, 0x87, 0x8A },
	0xEBFE,	{ 0xE8, 0x86, 0xBB },
	0xEC40,	{ 0xE9, 0x9C, 0xA1 },
	0xEC41,	{ 0xE9, 0x9C, 0xA2 },
	0xEC42,	{ 0xE9, 0x9C, 0xA3 },
	0xEC43,	{ 0xE9, 0x9C, 0xA4 },
	0xEC44,	{ 0xE9, 0x9C, 0xA5 },
	0xEC45,	{ 0xE9, 0x9C, 0xA6 },
	0xEC46,	{ 0xE9, 0x9C, 0xA7 },
	0xEC47,	{ 0xE9, 0x9C, 0xA8 },
	0xEC48,	{ 0xE9, 0x9C, 0xA9 },
	0xEC49,	{ 0xE9, 0x9C, 0xAB },
	0xEC4A,	{ 0xE9, 0x9C, 0xAC },
	0xEC4B,	{ 0xE9, 0x9C, 0xAE },
	0xEC4C,	{ 0xE9, 0x9C, 0xAF },
	0xEC4D,	{ 0xE9, 0x9C, 0xB1 },
	0xEC4E,	{ 0xE9, 0x9C, 0xB3 },
	0xEC4F,	{ 0xE9, 0x9C, 0xB4 },
	0xEC50,	{ 0xE9, 0x9C, 0xB5 },
	0xEC51,	{ 0xE9, 0x9C, 0xB6 },
	0xEC52,	{ 0xE9, 0x9C, 0xB7 },
	0xEC53,	{ 0xE9, 0x9C, 0xBA },
	0xEC54,	{ 0xE9, 0x9C, 0xBB },
	0xEC55,	{ 0xE9, 0x9C, 0xBC },
	0xEC56,	{ 0xE9, 0x9C, 0xBD },
	0xEC57,	{ 0xE9, 0x9C, 0xBF },
	0xEC58,	{ 0xE9, 0x9D, 0x80 },
	0xEC59,	{ 0xE9, 0x9D, 0x81 },
	0xEC5A,	{ 0xE9, 0x9D, 0x82 },
	0xEC5B,	{ 0xE9, 0x9D, 0x83 },
	0xEC5C,	{ 0xE9, 0x9D, 0x84 },
	0xEC5D,	{ 0xE9, 0x9D, 0x85 },
	0xEC5E,	{ 0xE9, 0x9D, 0x86 },
	0xEC5F,	{ 0xE9, 0x9D, 0x87 },
	0xEC60,	{ 0xE9, 0x9D, 0x88 },
	0xEC61,	{ 0xE9, 0x9D, 0x89 },
	0xEC62,	{ 0xE9, 0x9D, 0x8A },
	0xEC63,	{ 0xE9, 0x9D, 0x8B },
	0xEC64,	{ 0xE9, 0x9D, 0x8C },
	0xEC65,	{ 0xE9, 0x9D, 0x8D },
	0xEC66,	{ 0xE9, 0x9D, 0x8E },
	0xEC67,	{ 0xE9, 0x9D, 0x8F },
	0xEC68,	{ 0xE9, 0x9D, 0x90 },
	0xEC69,	{ 0xE9, 0x9D, 0x91 },
	0xEC6A,	{ 0xE9, 0x9D, 0x94 },
	0xEC6B,	{ 0xE9, 0x9D, 0x95 },
	0xEC6C,	{ 0xE9, 0x9D, 0x97 },
	0xEC6D,	{ 0xE9, 0x9D, 0x98 },
	0xEC6E,	{ 0xE9, 0x9D, 0x9A },
	0xEC6F,	{ 0xE9, 0x9D, 0x9C },
	0xEC70,	{ 0xE9, 0x9D, 0x9D },
	0xEC71,	{ 0xE9, 0x9D, 0x9F },
	0xEC72,	{ 0xE9, 0x9D, 0xA3 },
	0xEC73,	{ 0xE9, 0x9D, 0xA4 },
	0xEC74,	{ 0xE9, 0x9D, 0xA6 },
	0xEC75,	{ 0xE9, 0x9D, 0xA7 },
	0xEC76,	{ 0xE9, 0x9D, 0xA8 },
	0xEC77,	{ 0xE9, 0x9D, 0xAA },
	0xEC78,	{ 0xE9, 0x9D, 0xAB },
	0xEC79,	{ 0xE9, 0x9D, 0xAC },
	0xEC7A,	{ 0xE9, 0x9D, 0xAD },
	0xEC7B,	{ 0xE9, 0x9D, 0xAE },
	0xEC7C,	{ 0xE9, 0x9D, 0xAF },
	0xEC7D,	{ 0xE9, 0x9D, 0xB0 },
	0xEC7E,	{ 0xE9, 0x9D, 0xB1 },
	0xEC80,	{ 0xE9, 0x9D, 0xB2 },
	0xEC81,	{ 0xE9, 0x9D, 0xB5 },
	0xEC82,	{ 0xE9, 0x9D, 0xB7 },
	0xEC83,	{ 0xE9, 0x9D, 0xB8 },
	0xEC84,	{ 0xE9, 0x9D, 0xB9 },
	0xEC85,	{ 0xE9, 0x9D, 0xBA },
	0xEC86,	{ 0xE9, 0x9D, 0xBB },
	0xEC87,	{ 0xE9, 0x9D, 0xBD },
	0xEC88,	{ 0xE9, 0x9D, 0xBE },
	0xEC89,	{ 0xE9, 0x9D, 0xBF },
	0xEC8A,	{ 0xE9, 0x9E, 0x80 },
	0xEC8B,	{ 0xE9, 0x9E, 0x81 },
	0xEC8C,	{ 0xE9, 0x9E, 0x82 },
	0xEC8D,	{ 0xE9, 0x9E, 0x83 },
	0xEC8E,	{ 0xE9, 0x9E, 0x84 },
	0xEC8F,	{ 0xE9, 0x9E, 0x86 },
	0xEC90,	{ 0xE9, 0x9E, 0x87 },
	0xEC91,	{ 0xE9, 0x9E, 0x88 },
	0xEC92,	{ 0xE9, 0x9E, 0x89 },
	0xEC93,	{ 0xE9, 0x9E, 0x8A },
	0xEC94,	{ 0xE9, 0x9E, 0x8C },
	0xEC95,	{ 0xE9, 0x9E, 0x8E },
	0xEC96,	{ 0xE9, 0x9E, 0x8F },
	0xEC97,	{ 0xE9, 0x9E, 0x90 },
	0xEC98,	{ 0xE9, 0x9E, 0x93 },
	0xEC99,	{ 0xE9, 0x9E, 0x95 },
	0xEC9A,	{ 0xE9, 0x9E, 0x96 },
	0xEC9B,	{ 0xE9, 0x9E, 0x97 },
	0xEC9C,	{ 0xE9, 0x9E, 0x99 },
	0xEC9D,	{ 0xE9, 0x9E, 0x9A },
	0xEC9E,	{ 0xE9, 0x9E, 0x9B },
	0xEC9F,	{ 0xE9, 0x9E, 0x9C },
	0xECA0,	{ 0xE9, 0x9E, 0x9D },
	0xECA1,	{ 0xE8, 0x87, 0x81 },
	0xECA2,	{ 0xE8, 0x86, 0xA6 },
	0xECA3,	{ 0xE6, 0xAC, 0xA4 },
	0xECA4,	{ 0xE6, 0xAC, 0xB7 },
	0xECA5,	{ 0xE6, 0xAC, 0xB9 },
	0xECA6,	{ 0xE6, 0xAD, 0x83 },
	0xECA7,	{ 0xE6, 0xAD, 0x86 },
	0xECA8,	{ 0xE6, 0xAD, 0x99 },
	0xECA9,	{ 0xE9, 0xA3, 0x91 },
	0xECAA,	{ 0xE9, 0xA3, 0x92 },
	0xECAB,	{ 0xE9, 0xA3, 0x93 },
	0xECAC,	{ 0xE9, 0xA3, 0x95 },
	0xECAD,	{ 0xE9, 0xA3, 0x99 },
	0xECAE,	{ 0xE9, 0xA3, 0x9A },
	0xECAF,	{ 0xE6, 0xAE, 0xB3 },
	0xECB0,	{ 0xE5, 0xBD, 0x80 },
	0xECB1,	{ 0xE6, 0xAF, 0x82 },
	0xECB2,	{ 0xE8, 0xA7, 0xB3 },
	0xECB3,	{ 0xE6, 0x96, 0x90 },
	0xECB4,	{ 0xE9, 0xBD, 0x91 },
	0xECB5,	{ 0xE6, 0x96, 0x93 },
	0xECB6,	{ 0xE6, 0x96, 0xBC },
	0xECB7,	{ 0xE6, 0x97, 0x86 },
	0xECB8,	{ 0xE6, 0x97, 0x84 },
	0xECB9,	{ 0xE6, 0x97, 0x83 },
	0xECBA,	{ 0xE6, 0x97, 0x8C },
	0xECBB,	{ 0xE6, 0x97, 0x8E },
	0xECBC,	{ 0xE6, 0x97, 0x92 },
	0xECBD,	{ 0xE6, 0x97, 0x96 },
	0xECBE,	{ 0xE7, 0x82, 0x80 },
	0xECBF,	{ 0xE7, 0x82, 0x9C },
	0xECC0,	{ 0xE7, 0x82, 0x96 },
	0xECC1,	{ 0xE7, 0x82, 0x9D },
	0xECC2,	{ 0xE7, 0x82, 0xBB },
	0xECC3,	{ 0xE7, 0x83, 0x80 },
	0xECC4,	{ 0xE7, 0x82, 0xB7 },
	0xECC5,	{ 0xE7, 0x82, 0xAB },
	0xECC6,	{ 0xE7, 0x82, 0xB1 },
	0xECC7,	{ 0xE7, 0x83, 0xA8 },
	0xECC8,	{ 0xE7, 0x83, 0x8A },
	0xECC9,	{ 0xE7, 0x84, 0x90 },
	0xECCA,	{ 0xE7, 0x84, 0x93 },
	0xECCB,	{ 0xE7, 0x84, 0x96 },
	0xECCC,	{ 0xE7, 0x84, 0xAF },
	0xECCD,	{ 0xE7, 0x84, 0xB1 },
	0xECCE,	{ 0xE7, 0x85, 0xB3 },
	0xECCF,	{ 0xE7, 0x85, 0x9C },
	0xECD0,	{ 0xE7, 0x85, 0xA8 },
	0xECD1,	{ 0xE7, 0x85, 0x85 },
	0xECD2,	{ 0xE7, 0x85, 0xB2 },
	0xECD3,	{ 0xE7, 0x85, 0x8A },
	0xECD4,	{ 0xE7, 0x85, 0xB8 },
	0xECD5,	{ 0xE7, 0x85, 0xBA },
	0xECD6,	{ 0xE7, 0x86, 0x98 },
	0xECD7,	{ 0xE7, 0x86, 0xB3 },
	0xECD8,	{ 0xE7, 0x86, 0xB5 },
	0xECD9,	{ 0xE7, 0x86, 0xA8 },
	0xECDA,	{ 0xE7, 0x86, 0xA0 },
	0xECDB,	{ 0xE7, 0x87, 0xA0 },
	0xECDC,	{ 0xE7, 0x87, 0x94 },
	0xECDD,	{ 0xE7, 0x87, 0xA7 },
	0xECDE,	{ 0xE7, 0x87, 0xB9 },
	0xECDF,	{ 0xE7, 0x88, 0x9D },
	0xECE0,	{ 0xE7, 0x88, 0xA8 },
	0xECE1,	{ 0xE7, 0x81, 0xAC },
	0xECE2,	{ 0xE7, 0x84, 0x98 },
	0xECE3,	{ 0xE7, 0x85, 0xA6 },
	0xECE4,	{ 0xE7, 0x86, 0xB9 },
	0xECE5,	{ 0xE6, 0x88, 0xBE },
	0xECE6,	{ 0xE6, 0x88, 0xBD },
	0xECE7,	{ 0xE6, 0x89, 0x83 },
	0xECE8,	{ 0xE6, 0x89, 0x88 },
	0xECE9,	{ 0xE6, 0x89, 0x89 },
	0xECEA,	{ 0xE7, 0xA4, 0xBB },
	0xECEB,	{ 0xE7, 0xA5, 0x80 },
	0xECEC,	{ 0xE7, 0xA5, 0x86 },
	0xECED,	{ 0xE7, 0xA5, 0x89 },
	0xECEE,	{ 0xE7, 0xA5, 0x9B },
	0xECEF,	{ 0xE7, 0xA5, 0x9C },
	0xECF0,	{ 0xE7, 0xA5, 0x93 },
	0xECF1,	{ 0xE7, 0xA5, 0x9A },
	0xECF2,	{ 0xE7, 0xA5, 0xA2 },
	0xECF3,	{ 0xE7, 0xA5, 0x97 },
	0xECF4,	{ 0xE7, 0xA5, 0xA0 },
	0xECF5,	{ 0xE7, 0xA5, 0xAF },
	0xECF6,	{ 0xE7, 0xA5, 0xA7 },
	0xECF7,	{ 0xE7, 0xA5, 0xBA },
	0xECF8,	{ 0xE7, 0xA6, 0x85 },
	0xECF9,	{ 0xE7, 0xA6, 0x8A },
	0xECFA,	{ 0xE7, 0xA6, 0x9A },
	0xECFB,	{ 0xE7, 0xA6, 0xA7 },
	0xECFC,	{ 0xE7, 0xA6, 0xB3 },
	0xECFD,	{ 0xE5, 0xBF, 0x91 },
	0xECFE,	{ 0xE5, 0xBF, 0x90 },
	0xED40,	{ 0xE9, 0x9E, 0x9E },
	0xED41,	{ 0xE9, 0x9E, 0x9F },
	0xED42,	{ 0xE9, 0x9E, 0xA1 },
	0xED43,	{ 0xE9, 0x9E, 0xA2 },
	0xED44,	{ 0xE9, 0x9E, 0xA4 },
	0xED45,	{ 0xE9, 0x9E, 0xA5 },
	0xED46,	{ 0xE9, 0x9E, 0xA6 },
	0xED47,	{ 0xE9, 0x9E, 0xA7 },
	0xED48,	{ 0xE9, 0x9E, 0xA8 },
	0xED49,	{ 0xE9, 0x9E, 0xA9 },
	0xED4A,	{ 0xE9, 0x9E, 0xAA },
	0xED4B,	{ 0xE9, 0x9E, 0xAC },
	0xED4C,	{ 0xE9, 0x9E, 0xAE },
	0xED4D,	{ 0xE9, 0x9E, 0xB0 },
	0xED4E,	{ 0xE9, 0x9E, 0xB1 },
	0xED4F,	{ 0xE9, 0x9E, 0xB3 },
	0xED50,	{ 0xE9, 0x9E, 0xB5 },
	0xED51,	{ 0xE9, 0x9E, 0xB6 },
	0xED52,	{ 0xE9, 0x9E, 0xB7 },
	0xED53,	{ 0xE9, 0x9E, 0xB8 },
	0xED54,	{ 0xE9, 0x9E, 0xB9 },
	0xED55,	{ 0xE9, 0x9E, 0xBA },
	0xED56,	{ 0xE9, 0x9E, 0xBB },
	0xED57,	{ 0xE9, 0x9E, 0xBC },
	0xED58,	{ 0xE9, 0x9E, 0xBD },
	0xED59,	{ 0xE9, 0x9E, 0xBE },
	0xED5A,	{ 0xE9, 0x9E, 0xBF },
	0xED5B,	{ 0xE9, 0x9F, 0x80 },
	0xED5C,	{ 0xE9, 0x9F, 0x81 },
	0xED5D,	{ 0xE9, 0x9F, 0x82 },
	0xED5E,	{ 0xE9, 0x9F, 0x83 },
	0xED5F,	{ 0xE9, 0x9F, 0x84 },
	0xED60,	{ 0xE9, 0x9F, 0x85 },
	0xED61,	{ 0xE9, 0x9F, 0x86 },
	0xED62,	{ 0xE9, 0x9F, 0x87 },
	0xED63,	{ 0xE9, 0x9F, 0x88 },
	0xED64,	{ 0xE9, 0x9F, 0x89 },
	0xED65,	{ 0xE9, 0x9F, 0x8A },
	0xED66,	{ 0xE9, 0x9F, 0x8B },
	0xED67,	{ 0xE9, 0x9F, 0x8C },
	0xED68,	{ 0xE9, 0x9F, 0x8D },
	0xED69,	{ 0xE9, 0x9F, 0x8E },
	0xED6A,	{ 0xE9, 0x9F, 0x8F },
	0xED6B,	{ 0xE9, 0x9F, 0x90 },
	0xED6C,	{ 0xE9, 0x9F, 0x91 },
	0xED6D,	{ 0xE9, 0x9F, 0x92 },
	0xED6E,	{ 0xE9, 0x9F, 0x93 },
	0xED6F,	{ 0xE9, 0x9F, 0x94 },
	0xED70,	{ 0xE9, 0x9F, 0x95 },
	0xED71,	{ 0xE9, 0x9F, 0x96 },
	0xED72,	{ 0xE9, 0x9F, 0x97 },
	0xED73,	{ 0xE9, 0x9F, 0x98 },
	0xED74,	{ 0xE9, 0x9F, 0x99 },
	0xED75,	{ 0xE9, 0x9F, 0x9A },
	0xED76,	{ 0xE9, 0x9F, 0x9B },
	0xED77,	{ 0xE9, 0x9F, 0x9C },
	0xED78,	{ 0xE9, 0x9F, 0x9D },
	0xED79,	{ 0xE9, 0x9F, 0x9E },
	0xED7A,	{ 0xE9, 0x9F, 0x9F },
	0xED7B,	{ 0xE9, 0x9F, 0xA0 },
	0xED7C,	{ 0xE9, 0x9F, 0xA1 },
	0xED7D,	{ 0xE9, 0x9F, 0xA2 },
	0xED7E,	{ 0xE9, 0x9F, 0xA3 },
	0xED80,	{ 0xE9, 0x9F, 0xA4 },
	0xED81,	{ 0xE9, 0x9F, 0xA5 },
	0xED82,	{ 0xE9, 0x9F, 0xA8 },
	0xED83,	{ 0xE9, 0x9F, 0xAE },
	0xED84,	{ 0xE9, 0x9F, 0xAF },
	0xED85,	{ 0xE9, 0x9F, 0xB0 },
	0xED86,	{ 0xE9, 0x9F, 0xB1 },
	0xED87,	{ 0xE9, 0x9F, 0xB2 },
	0xED88,	{ 0xE9, 0x9F, 0xB4 },
	0xED89,	{ 0xE9, 0x9F, 0xB7 },
	0xED8A,	{ 0xE9, 0x9F, 0xB8 },
	0xED8B,	{ 0xE9, 0x9F, 0xB9 },
	0xED8C,	{ 0xE9, 0x9F, 0xBA },
	0xED8D,	{ 0xE9, 0x9F, 0xBB },
	0xED8E,	{ 0xE9, 0x9F, 0xBC },
	0xED8F,	{ 0xE9, 0x9F, 0xBD },
	0xED90,	{ 0xE9, 0x9F, 0xBE },
	0xED91,	{ 0xE9, 0x9F, 0xBF },
	0xED92,	{ 0xE9, 0xA0, 0x80 },
	0xED93,	{ 0xE9, 0xA0, 0x81 },
	0xED94,	{ 0xE9, 0xA0, 0x82 },
	0xED95,	{ 0xE9, 0xA0, 0x83 },
	0xED96,	{ 0xE9, 0xA0, 0x84 },
	0xED97,	{ 0xE9, 0xA0, 0x85 },
	0xED98,	{ 0xE9, 0xA0, 0x86 },
	0xED99,	{ 0xE9, 0xA0, 0x87 },
	0xED9A,	{ 0xE9, 0xA0, 0x88 },
	0xED9B,	{ 0xE9, 0xA0, 0x89 },
	0xED9C,	{ 0xE9, 0xA0, 0x8A },
	0xED9D,	{ 0xE9, 0xA0, 0x8B },
	0xED9E,	{ 0xE9, 0xA0, 0x8C },
	0xED9F,	{ 0xE9, 0xA0, 0x8D },
	0xEDA0,	{ 0xE9, 0xA0, 0x8E },
	0xEDA1,	{ 0xE6, 0x80, 0xBC },
	0xEDA2,	{ 0xE6, 0x81, 0x9D },
	0xEDA3,	{ 0xE6, 0x81, 0x9A },
	0xEDA4,	{ 0xE6, 0x81, 0xA7 },
	0xEDA5,	{ 0xE6, 0x81, 0x81 },
	0xEDA6,	{ 0xE6, 0x81, 0x99 },
	0xEDA7,	{ 0xE6, 0x81, 0xA3 },
	0xEDA8,	{ 0xE6, 0x82, 0xAB },
	0xEDA9,	{ 0xE6, 0x84, 0x86 },
	0xEDAA,	{ 0xE6, 0x84, 0x8D },
	0xEDAB,	{ 0xE6, 0x85, 0x9D },
	0xEDAC,	{ 0xE6, 0x86, 0xA9 },
	0xEDAD,	{ 0xE6, 0x86, 0x9D },
	0xEDAE,	{ 0xE6, 0x87, 0x8B },
	0xEDAF,	{ 0xE6, 0x87, 0x91 },
	0xEDB0,	{ 0xE6, 0x88, 0x86 },
	0xEDB1,	{ 0xE8, 0x82, 0x80 },
	0xEDB2,	{ 0xE8, 0x81, 0xBF },
	0xEDB3,	{ 0xE6, 0xB2, 0x93 },
	0xEDB4,	{ 0xE6, 0xB3, 0xB6 },
	0xEDB5,	{ 0xE6, 0xB7, 0xBC },
	0xEDB6,	{ 0xE7, 0x9F, 0xB6 },
	0xEDB7,	{ 0xE7, 0x9F, 0xB8 },
	0xEDB8,	{ 0xE7, 0xA0, 0x80 },
	0xEDB9,	{ 0xE7, 0xA0, 0x89 },
	0xEDBA,	{ 0xE7, 0xA0, 0x97 },
	0xEDBB,	{ 0xE7, 0xA0, 0x98 },
	0xEDBC,	{ 0xE7, 0xA0, 0x91 },
	0xEDBD,	{ 0xE6, 0x96, 0xAB },
	0xEDBE,	{ 0xE7, 0xA0, 0xAD },
	0xEDBF,	{ 0xE7, 0xA0, 0x9C },
	0xEDC0,	{ 0xE7, 0xA0, 0x9D },
	0xEDC1,	{ 0xE7, 0xA0, 0xB9 },
	0xEDC2,	{ 0xE7, 0xA0, 0xBA },
	0xEDC3,	{ 0xE7, 0xA0, 0xBB },
	0xEDC4,	{ 0xE7, 0xA0, 0x9F },
	0xEDC5,	{ 0xE7, 0xA0, 0xBC },
	0xEDC6,	{ 0xE7, 0xA0, 0xA5 },
	0xEDC7,	{ 0xE7, 0xA0, 0xAC },
	0xEDC8,	{ 0xE7, 0xA0, 0xA3 },
	0xEDC9,	{ 0xE7, 0xA0, 0xA9 },
	0xEDCA,	{ 0xE7, 0xA1, 0x8E },
	0xEDCB,	{ 0xE7, 0xA1, 0xAD },
	0xEDCC,	{ 0xE7, 0xA1, 0x96 },
	0xEDCD,	{ 0xE7, 0xA1, 0x97 },
	0xEDCE,	{ 0xE7, 0xA0, 0xA6 },
	0xEDCF,	{ 0xE7, 0xA1, 0x90 },
	0xEDD0,	{ 0xE7, 0xA1, 0x87 },
	0xEDD1,	{ 0xE7, 0xA1, 0x8C },
	0xEDD2,	{ 0xE7, 0xA1, 0xAA },
	0xEDD3,	{ 0xE7, 0xA2, 0x9B },
	0xEDD4,	{ 0xE7, 0xA2, 0x93 },
	0xEDD5,	{ 0xE7, 0xA2, 0x9A },
	0xEDD6,	{ 0xE7, 0xA2, 0x87 },
	0xEDD7,	{ 0xE7, 0xA2, 0x9C },
	0xEDD8,	{ 0xE7, 0xA2, 0xA1 },
	0xEDD9,	{ 0xE7, 0xA2, 0xA3 },
	0xEDDA,	{ 0xE7, 0xA2, 0xB2 },
	0xEDDB,	{ 0xE7, 0xA2, 0xB9 },
	0xEDDC,	{ 0xE7, 0xA2, 0xA5 },
	0xEDDD,	{ 0xE7, 0xA3, 0x94 },
	0xEDDE,	{ 0xE7, 0xA3, 0x99 },
	0xEDDF,	{ 0xE7, 0xA3, 0x89 },
	0xEDE0,	{ 0xE7, 0xA3, 0xAC },
	0xEDE1,	{ 0xE7, 0xA3, 0xB2 },
	0xEDE2,	{ 0xE7, 0xA4, 0x85 },
	0xEDE3,	{ 0xE7, 0xA3, 0xB4 },
	0xEDE4,	{ 0xE7, 0xA4, 0x93 },
	0xEDE5,	{ 0xE7, 0xA4, 0xA4 },
	0xEDE6,	{ 0xE7, 0xA4, 0x9E },
	0xEDE7,	{ 0xE7, 0xA4, 0xB4 },
	0xEDE8,	{ 0xE9, 0xBE, 0x9B },
	0xEDE9,	{ 0xE9, 0xBB, 0xB9 },
	0xEDEA,	{ 0xE9, 0xBB, 0xBB },
	0xEDEB,	{ 0xE9, 0xBB, 0xBC },
	0xEDEC,	{ 0xE7, 0x9B, 0xB1 },
	0xEDED,	{ 0xE7, 0x9C, 0x84 },
	0xEDEE,	{ 0xE7, 0x9C, 0x8D },
	0xEDEF,	{ 0xE7, 0x9B, 0xB9 },
	0xEDF0,	{ 0xE7, 0x9C, 0x87 },
	0xEDF1,	{ 0xE7, 0x9C, 0x88 },
	0xEDF2,	{ 0xE7, 0x9C, 0x9A },
	0xEDF3,	{ 0xE7, 0x9C, 0xA2 },
	0xEDF4,	{ 0xE7, 0x9C, 0x99 },
	0xEDF5,	{ 0xE7, 0x9C, 0xAD },
	0xEDF6,	{ 0xE7, 0x9C, 0xA6 },
	0xEDF7,	{ 0xE7, 0x9C, 0xB5 },
	0xEDF8,	{ 0xE7, 0x9C, 0xB8 },
	0xEDF9,	{ 0xE7, 0x9D, 0x90 },
	0xEDFA,	{ 0xE7, 0x9D, 0x91 },
	0xEDFB,	{ 0xE7, 0x9D, 0x87 },
	0xEDFC,	{ 0xE7, 0x9D, 0x83 },
	0xEDFD,	{ 0xE7, 0x9D, 0x9A },
	0xEDFE,	{ 0xE7, 0x9D, 0xA8 },
	0xEE40,	{ 0xE9, 0xA0, 0x8F },
	0xEE41,	{ 0xE9, 0xA0, 0x90 },
	0xEE42,	{ 0xE9, 0xA0, 0x91 },
	0xEE43,	{ 0xE9, 0xA0, 0x92 },
	0xEE44,	{ 0xE9, 0xA0, 0x93 },
	0xEE45,	{ 0xE9, 0xA0, 0x94 },
	0xEE46,	{ 0xE9, 0xA0, 0x95 },
	0xEE47,	{ 0xE9, 0xA0, 0x96 },
	0xEE48,	{ 0xE9, 0xA0, 0x97 },
	0xEE49,	{ 0xE9, 0xA0, 0x98 },
	0xEE4A,	{ 0xE9, 0xA0, 0x99 },
	0xEE4B,	{ 0xE9, 0xA0, 0x9A },
	0xEE4C,	{ 0xE9, 0xA0, 0x9B },
	0xEE4D,	{ 0xE9, 0xA0, 0x9C },
	0xEE4E,	{ 0xE9, 0xA0, 0x9D },
	0xEE4F,	{ 0xE9, 0xA0, 0x9E },
	0xEE50,	{ 0xE9, 0xA0, 0x9F },
	0xEE51,	{ 0xE9, 0xA0, 0xA0 },
	0xEE52,	{ 0xE9, 0xA0, 0xA1 },
	0xEE53,	{ 0xE9, 0xA0, 0xA2 },
	0xEE54,	{ 0xE9, 0xA0, 0xA3 },
	0xEE55,	{ 0xE9, 0xA0, 0xA4 },
	0xEE56,	{ 0xE9, 0xA0, 0xA5 },
	0xEE57,	{ 0xE9, 0xA0, 0xA6 },
	0xEE58,	{ 0xE9, 0xA0, 0xA7 },
	0xEE59,	{ 0xE9, 0xA0, 0xA8 },
	0xEE5A,	{ 0xE9, 0xA0, 0xA9 },
	0xEE5B,	{ 0xE9, 0xA0, 0xAA },
	0xEE5C,	{ 0xE9, 0xA0, 0xAB },
	0xEE5D,	{ 0xE9, 0xA0, 0xAC },
	0xEE5E,	{ 0xE9, 0xA0, 0xAD },
	0xEE5F,	{ 0xE9, 0xA0, 0xAE },
	0xEE60,	{ 0xE9, 0xA0, 0xAF },
	0xEE61,	{ 0xE9, 0xA0, 0xB0 },
	0xEE62,	{ 0xE9, 0xA0, 0xB1 },
	0xEE63,	{ 0xE9, 0xA0, 0xB2 },
	0xEE64,	{ 0xE9, 0xA0, 0xB3 },
	0xEE65,	{ 0xE9, 0xA0, 0xB4 },
	0xEE66,	{ 0xE9, 0xA0, 0xB5 },
	0xEE67,	{ 0xE9, 0xA0, 0xB6 },
	0xEE68,	{ 0xE9, 0xA0, 0xB7 },
	0xEE69,	{ 0xE9, 0xA0, 0xB8 },
	0xEE6A,	{ 0xE9, 0xA0, 0xB9 },
	0xEE6B,	{ 0xE9, 0xA0, 0xBA },
	0xEE6C,	{ 0xE9, 0xA0, 0xBB },
	0xEE6D,	{ 0xE9, 0xA0, 0xBC },
	0xEE6E,	{ 0xE9, 0xA0, 0xBD },
	0xEE6F,	{ 0xE9, 0xA0, 0xBE },
	0xEE70,	{ 0xE9, 0xA0, 0xBF },
	0xEE71,	{ 0xE9, 0xA1, 0x80 },
	0xEE72,	{ 0xE9, 0xA1, 0x81 },
	0xEE73,	{ 0xE9, 0xA1, 0x82 },
	0xEE74,	{ 0xE9, 0xA1, 0x83 },
	0xEE75,	{ 0xE9, 0xA1, 0x84 },
	0xEE76,	{ 0xE9, 0xA1, 0x85 },
	0xEE77,	{ 0xE9, 0xA1, 0x86 },
	0xEE78,	{ 0xE9, 0xA1, 0x87 },
	0xEE79,	{ 0xE9, 0xA1, 0x88 },
	0xEE7A,	{ 0xE9, 0xA1, 0x89 },
	0xEE7B,	{ 0xE9, 0xA1, 0x8A },
	0xEE7C,	{ 0xE9, 0xA1, 0x8B },
	0xEE7D,	{ 0xE9, 0xA1, 0x8C },
	0xEE7E,	{ 0xE9, 0xA1, 0x8D },
	0xEE80,	{ 0xE9, 0xA1, 0x8E },
	0xEE81,	{ 0xE9, 0xA1, 0x8F },
	0xEE82,	{ 0xE9, 0xA1, 0x90 },
	0xEE83,	{ 0xE9, 0xA1, 0x91 },
	0xEE84,	{ 0xE9, 0xA1, 0x92 },
	0xEE85,	{ 0xE9, 0xA1, 0x93 },
	0xEE86,	{ 0xE9, 0xA1, 0x94 },
	0xEE87,	{ 0xE9, 0xA1, 0x95 },
	0xEE88,	{ 0xE9, 0xA1, 0x96 },
	0xEE89,	{ 0xE9, 0xA1, 0x97 },
	0xEE8A,	{ 0xE9, 0xA1, 0x98 },
	0xEE8B,	{ 0xE9, 0xA1, 0x99 },
	0xEE8C,	{ 0xE9, 0xA1, 0x9A },
	0xEE8D,	{ 0xE9, 0xA1, 0x9B },
	0xEE8E,	{ 0xE9, 0xA1, 0x9C },
	0xEE8F,	{ 0xE9, 0xA1, 0x9D },
	0xEE90,	{ 0xE9, 0xA1, 0x9E },
	0xEE91,	{ 0xE9, 0xA1, 0x9F },
	0xEE92,	{ 0xE9, 0xA1, 0xA0 },
	0xEE93,	{ 0xE9, 0xA1, 0xA1 },
	0xEE94,	{ 0xE9, 0xA1, 0xA2 },
	0xEE95,	{ 0xE9, 0xA1, 0xA3 },
	0xEE96,	{ 0xE9, 0xA1, 0xA4 },
	0xEE97,	{ 0xE9, 0xA1, 0xA5 },
	0xEE98,	{ 0xE9, 0xA1, 0xA6 },
	0xEE99,	{ 0xE9, 0xA1, 0xA7 },
	0xEE9A,	{ 0xE9, 0xA1, 0xA8 },
	0xEE9B,	{ 0xE9, 0xA1, 0xA9 },
	0xEE9C,	{ 0xE9, 0xA1, 0xAA },
	0xEE9D,	{ 0xE9, 0xA1, 0xAB },
	0xEE9E,	{ 0xE9, 0xA1, 0xAC },
	0xEE9F,	{ 0xE9, 0xA1, 0xAD },
	0xEEA0,	{ 0xE9, 0xA1, 0xAE },
	0xEEA1,	{ 0xE7, 0x9D, 0xA2 },
	0xEEA2,	{ 0xE7, 0x9D, 0xA5 },
	0xEEA3,	{ 0xE7, 0x9D, 0xBF },
	0xEEA4,	{ 0xE7, 0x9E, 0x8D },
	0xEEA5,	{ 0xE7, 0x9D, 0xBD },
	0xEEA6,	{ 0xE7, 0x9E, 0x80 },
	0xEEA7,	{ 0xE7, 0x9E, 0x8C },
	0xEEA8,	{ 0xE7, 0x9E, 0x91 },
	0xEEA9,	{ 0xE7, 0x9E, 0x9F },
	0xEEAA,	{ 0xE7, 0x9E, 0xA0 },
	0xEEAB,	{ 0xE7, 0x9E, 0xB0 },
	0xEEAC,	{ 0xE7, 0x9E, 0xB5 },
	0xEEAD,	{ 0xE7, 0x9E, 0xBD },
	0xEEAE,	{ 0xE7, 0x94, 0xBA },
	0xEEAF,	{ 0xE7, 0x95, 0x80 },
	0xEEB0,	{ 0xE7, 0x95, 0x8E },
	0xEEB1,	{ 0xE7, 0x95, 0x8B },
	0xEEB2,	{ 0xE7, 0x95, 0x88 },
	0xEEB3,	{ 0xE7, 0x95, 0x9B },
	0xEEB4,	{ 0xE7, 0x95, 0xB2 },
	0xEEB5,	{ 0xE7, 0x95, 0xB9 },
	0xEEB6,	{ 0xE7, 0x96, 0x83 },
	0xEEB7,	{ 0xE7, 0xBD, 0x98 },
	0xEEB8,	{ 0xE7, 0xBD, 0xA1 },
	0xEEB9,	{ 0xE7, 0xBD, 0x9F },
	0xEEBA,	{ 0xE8, 0xA9, 0x88 },
	0xEEBB,	{ 0xE7, 0xBD, 0xA8 },
	0xEEBC,	{ 0xE7, 0xBD, 0xB4 },
	0xEEBD,	{ 0xE7, 0xBD, 0xB1 },
	0xEEBE,	{ 0xE7, 0xBD, 0xB9 },
	0xEEBF,	{ 0xE7, 0xBE, 0x81 },
	0xEEC0,	{ 0xE7, 0xBD, 0xBE },
	0xEEC1,	{ 0xE7, 0x9B, 0x8D },
	0xEEC2,	{ 0xE7, 0x9B, 0xA5 },
	0xEEC3,	{ 0xE8, 0xA0, 0xB2 },
	0xEEC4,	{ 0xE9, 0x92, 0x85 },
	0xEEC5,	{ 0xE9, 0x92, 0x86 },
	0xEEC6,	{ 0xE9, 0x92, 0x87 },
	0xEEC7,	{ 0xE9, 0x92, 0x8B },
	0xEEC8,	{ 0xE9, 0x92, 0x8A },
	0xEEC9,	{ 0xE9, 0x92, 0x8C },
	0xEECA,	{ 0xE9, 0x92, 0x8D },
	0xEECB,	{ 0xE9, 0x92, 0x8F },
	0xEECC,	{ 0xE9, 0x92, 0x90 },
	0xEECD,	{ 0xE9, 0x92, 0x94 },
	0xEECE,	{ 0xE9, 0x92, 0x97 },
	0xEECF,	{ 0xE9, 0x92, 0x95 },
	0xEED0,	{ 0xE9, 0x92, 0x9A },
	0xEED1,	{ 0xE9, 0x92, 0x9B },
	0xEED2,	{ 0xE9, 0x92, 0x9C },
	0xEED3,	{ 0xE9, 0x92, 0xA3 },
	0xEED4,	{ 0xE9, 0x92, 0xA4 },
	0xEED5,	{ 0xE9, 0x92, 0xAB },
	0xEED6,	{ 0xE9, 0x92, 0xAA },
	0xEED7,	{ 0xE9, 0x92, 0xAD },
	0xEED8,	{ 0xE9, 0x92, 0xAC },
	0xEED9,	{ 0xE9, 0x92, 0xAF },
	0xEEDA,	{ 0xE9, 0x92, 0xB0 },
	0xEEDB,	{ 0xE9, 0x92, 0xB2 },
	0xEEDC,	{ 0xE9, 0x92, 0xB4 },
	0xEEDD,	{ 0xE9, 0x92, 0xB6 },
	0xEEDE,	{ 0xE9, 0x92, 0xB7 },
	0xEEDF,	{ 0xE9, 0x92, 0xB8 },
	0xEEE0,	{ 0xE9, 0x92, 0xB9 },
	0xEEE1,	{ 0xE9, 0x92, 0xBA },
	0xEEE2,	{ 0xE9, 0x92, 0xBC },
	0xEEE3,	{ 0xE9, 0x92, 0xBD },
	0xEEE4,	{ 0xE9, 0x92, 0xBF },
	0xEEE5,	{ 0xE9, 0x93, 0x84 },
	0xEEE6,	{ 0xE9, 0x93, 0x88 },
	0xEEE7,	{ 0xE9, 0x93, 0x89 },
	0xEEE8,	{ 0xE9, 0x93, 0x8A },
	0xEEE9,	{ 0xE9, 0x93, 0x8B },
	0xEEEA,	{ 0xE9, 0x93, 0x8C },
	0xEEEB,	{ 0xE9, 0x93, 0x8D },
	0xEEEC,	{ 0xE9, 0x93, 0x8E },
	0xEEED,	{ 0xE9, 0x93, 0x90 },
	0xEEEE,	{ 0xE9, 0x93, 0x91 },
	0xEEEF,	{ 0xE9, 0x93, 0x92 },
	0xEEF0,	{ 0xE9, 0x93, 0x95 },
	0xEEF1,	{ 0xE9, 0x93, 0x96 },
	0xEEF2,	{ 0xE9, 0x93, 0x97 },
	0xEEF3,	{ 0xE9, 0x93, 0x99 },
	0xEEF4,	{ 0xE9, 0x93, 0x98 },
	0xEEF5,	{ 0xE9, 0x93, 0x9B },
	0xEEF6,	{ 0xE9, 0x93, 0x9E },
	0xEEF7,	{ 0xE9, 0x93, 0x9F },
	0xEEF8,	{ 0xE9, 0x93, 0xA0 },
	0xEEF9,	{ 0xE9, 0x93, 0xA2 },
	0xEEFA,	{ 0xE9, 0x93, 0xA4 },
	0xEEFB,	{ 0xE9, 0x93, 0xA5 },
	0xEEFC,	{ 0xE9, 0x93, 0xA7 },
	0xEEFD,	{ 0xE9, 0x93, 0xA8 },
	0xEEFE,	{ 0xE9, 0x93, 0xAA },
	0xEF40,	{ 0xE9, 0xA1, 0xAF },
	0xEF41,	{ 0xE9, 0xA1, 0xB0 },
	0xEF42,	{ 0xE9, 0xA1, 0xB1 },
	0xEF43,	{ 0xE9, 0xA1, 0xB2 },
	0xEF44,	{ 0xE9, 0xA1, 0xB3 },
	0xEF45,	{ 0xE9, 0xA1, 0xB4 },
	0xEF46,	{ 0xE9, 0xA2, 0x8B },
	0xEF47,	{ 0xE9, 0xA2, 0x8E },
	0xEF48,	{ 0xE9, 0xA2, 0x92 },
	0xEF49,	{ 0xE9, 0xA2, 0x95 },
	0xEF4A,	{ 0xE9, 0xA2, 0x99 },
	0xEF4B,	{ 0xE9, 0xA2, 0xA3 },
	0xEF4C,	{ 0xE9, 0xA2, 0xA8 },
	0xEF4D,	{ 0xE9, 0xA2, 0xA9 },
	0xEF4E,	{ 0xE9, 0xA2, 0xAA },
	0xEF4F,	{ 0xE9, 0xA2, 0xAB },
	0xEF50,	{ 0xE9, 0xA2, 0xAC },
	0xEF51,	{ 0xE9, 0xA2, 0xAD },
	0xEF52,	{ 0xE9, 0xA2, 0xAE },
	0xEF53,	{ 0xE9, 0xA2, 0xAF },
	0xEF54,	{ 0xE9, 0xA2, 0xB0 },
	0xEF55,	{ 0xE9, 0xA2, 0xB1 },
	0xEF56,	{ 0xE9, 0xA2, 0xB2 },
	0xEF57,	{ 0xE9, 0xA2, 0xB3 },
	0xEF58,	{ 0xE9, 0xA2, 0xB4 },
	0xEF59,	{ 0xE9, 0xA2, 0xB5 },
	0xEF5A,	{ 0xE9, 0xA2, 0xB6 },
	0xEF5B,	{ 0xE9, 0xA2, 0xB7 },
	0xEF5C,	{ 0xE9, 0xA2, 0xB8 },
	0xEF5D,	{ 0xE9, 0xA2, 0xB9 },
	0xEF5E,	{ 0xE9, 0xA2, 0xBA },
	0xEF5F,	{ 0xE9, 0xA2, 0xBB },
	0xEF60,	{ 0xE9, 0xA2, 0xBC },
	0xEF61,	{ 0xE9, 0xA2, 0xBD },
	0xEF62,	{ 0xE9, 0xA2, 0xBE },
	0xEF63,	{ 0xE9, 0xA2, 0xBF },
	0xEF64,	{ 0xE9, 0xA3, 0x80 },
	0xEF65,	{ 0xE9, 0xA3, 0x81 },
	0xEF66,	{ 0xE9, 0xA3, 0x82 },
	0xEF67,	{ 0xE9, 0xA3, 0x83 },
	0xEF68,	{ 0xE9, 0xA3, 0x84 },
	0xEF69,	{ 0xE9, 0xA3, 0x85 },
	0xEF6A,	{ 0xE9, 0xA3, 0x86 },
	0xEF6B,	{ 0xE9, 0xA3, 0x87 },
	0xEF6C,	{ 0xE9, 0xA3, 0x88 },
	0xEF6D,	{ 0xE9, 0xA3, 0x89 },
	0xEF6E,	{ 0xE9, 0xA3, 0x8A },
	0xEF6F,	{ 0xE9, 0xA3, 0x8B },
	0xEF70,	{ 0xE9, 0xA3, 0x8C },
	0xEF71,	{ 0xE9, 0xA3, 0x8D },
	0xEF72,	{ 0xE9, 0xA3, 0x8F },
	0xEF73,	{ 0xE9, 0xA3, 0x90 },
	0xEF74,	{ 0xE9, 0xA3, 0x94 },
	0xEF75,	{ 0xE9, 0xA3, 0x96 },
	0xEF76,	{ 0xE9, 0xA3, 0x97 },
	0xEF77,	{ 0xE9, 0xA3, 0x9B },
	0xEF78,	{ 0xE9, 0xA3, 0x9C },
	0xEF79,	{ 0xE9, 0xA3, 0x9D },
	0xEF7A,	{ 0xE9, 0xA3, 0xA0 },
	0xEF7B,	{ 0xE9, 0xA3, 0xA1 },
	0xEF7C,	{ 0xE9, 0xA3, 0xA2 },
	0xEF7D,	{ 0xE9, 0xA3, 0xA3 },
	0xEF7E,	{ 0xE9, 0xA3, 0xA4 },
	0xEF80,	{ 0xE9, 0xA3, 0xA5 },
	0xEF81,	{ 0xE9, 0xA3, 0xA6 },
	0xEF82,	{ 0xE9, 0xA3, 0xA9 },
	0xEF83,	{ 0xE9, 0xA3, 0xAA },
	0xEF84,	{ 0xE9, 0xA3, 0xAB },
	0xEF85,	{ 0xE9, 0xA3, 0xAC },
	0xEF86,	{ 0xE9, 0xA3, 0xAD },
	0xEF87,	{ 0xE9, 0xA3, 0xAE },
	0xEF88,	{ 0xE9, 0xA3, 0xAF },
	0xEF89,	{ 0xE9, 0xA3, 0xB0 },
	0xEF8A,	{ 0xE9, 0xA3, 0xB1 },
	0xEF8B,	{ 0xE9, 0xA3, 0xB2 },
	0xEF8C,	{ 0xE9, 0xA3, 0xB3 },
	0xEF8D,	{ 0xE9, 0xA3, 0xB4 },
	0xEF8E,	{ 0xE9, 0xA3, 0xB5 },
	0xEF8F,	{ 0xE9, 0xA3, 0xB6 },
	0xEF90,	{ 0xE9, 0xA3, 0xB7 },
	0xEF91,	{ 0xE9, 0xA3, 0xB8 },
	0xEF92,	{ 0xE9, 0xA3, 0xB9 },
	0xEF93,	{ 0xE9, 0xA3, 0xBA },
	0xEF94,	{ 0xE9, 0xA3, 0xBB },
	0xEF95,	{ 0xE9, 0xA3, 0xBC },
	0xEF96,	{ 0xE9, 0xA3, 0xBD },
	0xEF97,	{ 0xE9, 0xA3, 0xBE },
	0xEF98,	{ 0xE9, 0xA3, 0xBF },
	0xEF99,	{ 0xE9, 0xA4, 0x80 },
	0xEF9A,	{ 0xE9, 0xA4, 0x81 },
	0xEF9B,	{ 0xE9, 0xA4, 0x82 },
	0xEF9C,	{ 0xE9, 0xA4, 0x83 },
	0xEF9D,	{ 0xE9, 0xA4, 0x84 },
	0xEF9E,	{ 0xE9, 0xA4, 0x85 },
	0xEF9F,	{ 0xE9, 0xA4, 0x86 },
	0xEFA0,	{ 0xE9, 0xA4, 0x87 },
	0xEFA1,	{ 0xE9, 0x93, 0xA9 },
	0xEFA2,	{ 0xE9, 0x93, 0xAB },
	0xEFA3,	{ 0xE9, 0x93, 0xAE },
	0xEFA4,	{ 0xE9, 0x93, 0xAF },
	0xEFA5,	{ 0xE9, 0x93, 0xB3 },
	0xEFA6,	{ 0xE9, 0x93, 0xB4 },
	0xEFA7,	{ 0xE9, 0x93, 0xB5 },
	0xEFA8,	{ 0xE9, 0x93, 0xB7 },
	0xEFA9,	{ 0xE9, 0x93, 0xB9 },
	0xEFAA,	{ 0xE9, 0x93, 0xBC },
	0xEFAB,	{ 0xE9, 0x93, 0xBD },
	0xEFAC,	{ 0xE9, 0x93, 0xBF },
	0xEFAD,	{ 0xE9, 0x94, 0x83 },
	0xEFAE,	{ 0xE9, 0x94, 0x82 },
	0xEFAF,	{ 0xE9, 0x94, 0x86 },
	0xEFB0,	{ 0xE9, 0x94, 0x87 },
	0xEFB1,	{ 0xE9, 0x94, 0x89 },
	0xEFB2,	{ 0xE9, 0x94, 0x8A },
	0xEFB3,	{ 0xE9, 0x94, 0x8D },
	0xEFB4,	{ 0xE9, 0x94, 0x8E },
	0xEFB5,	{ 0xE9, 0x94, 0x8F },
	0xEFB6,	{ 0xE9, 0x94, 0x92 },
	0xEFB7,	{ 0xE9, 0x94, 0x93 },
	0xEFB8,	{ 0xE9, 0x94, 0x94 },
	0xEFB9,	{ 0xE9, 0x94, 0x95 },
	0xEFBA,	{ 0xE9, 0x94, 0x96 },
	0xEFBB,	{ 0xE9, 0x94, 0x98 },
	0xEFBC,	{ 0xE9, 0x94, 0x9B },
	0xEFBD,	{ 0xE9, 0x94, 0x9D },
	0xEFBE,	{ 0xE9, 0x94, 0x9E },
	0xEFBF,	{ 0xE9, 0x94, 0x9F },
	0xEFC0,	{ 0xE9, 0x94, 0xA2 },
	0xEFC1,	{ 0xE9, 0x94, 0xAA },
	0xEFC2,	{ 0xE9, 0x94, 0xAB },
	0xEFC3,	{ 0xE9, 0x94, 0xA9 },
	0xEFC4,	{ 0xE9, 0x94, 0xAC },
	0xEFC5,	{ 0xE9, 0x94, 0xB1 },
	0xEFC6,	{ 0xE9, 0x94, 0xB2 },
	0xEFC7,	{ 0xE9, 0x94, 0xB4 },
	0xEFC8,	{ 0xE9, 0x94, 0xB6 },
	0xEFC9,	{ 0xE9, 0x94, 0xB7 },
	0xEFCA,	{ 0xE9, 0x94, 0xB8 },
	0xEFCB,	{ 0xE9, 0x94, 0xBC },
	0xEFCC,	{ 0xE9, 0x94, 0xBE },
	0xEFCD,	{ 0xE9, 0x94, 0xBF },
	0xEFCE,	{ 0xE9, 0x95, 0x82 },
	0xEFCF,	{ 0xE9, 0x94, 0xB5 },
	0xEFD0,	{ 0xE9, 0x95, 0x84 },
	0xEFD1,	{ 0xE9, 0x95, 0x85 },
	0xEFD2,	{ 0xE9, 0x95, 0x86 },
	0xEFD3,	{ 0xE9, 0x95, 0x89 },
	0xEFD4,	{ 0xE9, 0x95, 0x8C },
	0xEFD5,	{ 0xE9, 0x95, 0x8E },
	0xEFD6,	{ 0xE9, 0x95, 0x8F },
	0xEFD7,	{ 0xE9, 0x95, 0x92 },
	0xEFD8,	{ 0xE9, 0x95, 0x93 },
	0xEFD9,	{ 0xE9, 0x95, 0x94 },
	0xEFDA,	{ 0xE9, 0x95, 0x96 },
	0xEFDB,	{ 0xE9, 0x95, 0x97 },
	0xEFDC,	{ 0xE9, 0x95, 0x98 },
	0xEFDD,	{ 0xE9, 0x95, 0x99 },
	0xEFDE,	{ 0xE9, 0x95, 0x9B },
	0xEFDF,	{ 0xE9, 0x95, 0x9E },
	0xEFE0,	{ 0xE9, 0x95, 0x9F },
	0xEFE1,	{ 0xE9, 0x95, 0x9D },
	0xEFE2,	{ 0xE9, 0x95, 0xA1 },
	0xEFE3,	{ 0xE9, 0x95, 0xA2 },
	0xEFE4,	{ 0xE9, 0x95, 0xA4 },
	0xEFE5,	{ 0xE9, 0x95, 0xA5 },
	0xEFE6,	{ 0xE9, 0x95, 0xA6 },
	0xEFE7,	{ 0xE9, 0x95, 0xA7 },
	0xEFE8,	{ 0xE9, 0x95, 0xA8 },
	0xEFE9,	{ 0xE9, 0x95, 0xA9 },
	0xEFEA,	{ 0xE9, 0x95, 0xAA },
	0xEFEB,	{ 0xE9, 0x95, 0xAB },
	0xEFEC,	{ 0xE9, 0x95, 0xAC },
	0xEFED,	{ 0xE9, 0x95, 0xAF },
	0xEFEE,	{ 0xE9, 0x95, 0xB1 },
	0xEFEF,	{ 0xE9, 0x95, 0xB2 },
	0xEFF0,	{ 0xE9, 0x95, 0xB3 },
	0xEFF1,	{ 0xE9, 0x94, 0xBA },
	0xEFF2,	{ 0xE7, 0x9F, 0xA7 },
	0xEFF3,	{ 0xE7, 0x9F, 0xAC },
	0xEFF4,	{ 0xE9, 0x9B, 0x89 },
	0xEFF5,	{ 0xE7, 0xA7, 0x95 },
	0xEFF6,	{ 0xE7, 0xA7, 0xAD },
	0xEFF7,	{ 0xE7, 0xA7, 0xA3 },
	0xEFF8,	{ 0xE7, 0xA7, 0xAB },
	0xEFF9,	{ 0xE7, 0xA8, 0x86 },
	0xEFFA,	{ 0xE5, 0xB5, 0x87 },
	0xEFFB,	{ 0xE7, 0xA8, 0x83 },
	0xEFFC,	{ 0xE7, 0xA8, 0x82 },
	0xEFFD,	{ 0xE7, 0xA8, 0x9E },
	0xEFFE,	{ 0xE7, 0xA8, 0x94 },
	0xF040,	{ 0xE9, 0xA4, 0x88 },
	0xF041,	{ 0xE9, 0xA4, 0x89 },
	0xF042,	{ 0xE9, 0xA4, 0x8A },
	0xF043,	{ 0xE9, 0xA4, 0x8B },
	0xF044,	{ 0xE9, 0xA4, 0x8C },
	0xF045,	{ 0xE9, 0xA4, 0x8E },
	0xF046,	{ 0xE9, 0xA4, 0x8F },
	0xF047,	{ 0xE9, 0xA4, 0x91 },
	0xF048,	{ 0xE9, 0xA4, 0x92 },
	0xF049,	{ 0xE9, 0xA4, 0x93 },
	0xF04A,	{ 0xE9, 0xA4, 0x94 },
	0xF04B,	{ 0xE9, 0xA4, 0x95 },
	0xF04C,	{ 0xE9, 0xA4, 0x96 },
	0xF04D,	{ 0xE9, 0xA4, 0x97 },
	0xF04E,	{ 0xE9, 0xA4, 0x98 },
	0xF04F,	{ 0xE9, 0xA4, 0x99 },
	0xF050,	{ 0xE9, 0xA4, 0x9A },
	0xF051,	{ 0xE9, 0xA4, 0x9B },
	0xF052,	{ 0xE9, 0xA4, 0x9C },
	0xF053,	{ 0xE9, 0xA4, 0x9D },
	0xF054,	{ 0xE9, 0xA4, 0x9E },
	0xF055,	{ 0xE9, 0xA4, 0x9F },
	0xF056,	{ 0xE9, 0xA4, 0xA0 },
	0xF057,	{ 0xE9, 0xA4, 0xA1 },
	0xF058,	{ 0xE9, 0xA4, 0xA2 },
	0xF059,	{ 0xE9, 0xA4, 0xA3 },
	0xF05A,	{ 0xE9, 0xA4, 0xA4 },
	0xF05B,	{ 0xE9, 0xA4, 0xA5 },
	0xF05C,	{ 0xE9, 0xA4, 0xA6 },
	0xF05D,	{ 0xE9, 0xA4, 0xA7 },
	0xF05E,	{ 0xE9, 0xA4, 0xA8 },
	0xF05F,	{ 0xE9, 0xA4, 0xA9 },
	0xF060,	{ 0xE9, 0xA4, 0xAA },
	0xF061,	{ 0xE9, 0xA4, 0xAB },
	0xF062,	{ 0xE9, 0xA4, 0xAC },
	0xF063,	{ 0xE9, 0xA4, 0xAD },
	0xF064,	{ 0xE9, 0xA4, 0xAF },
	0xF065,	{ 0xE9, 0xA4, 0xB0 },
	0xF066,	{ 0xE9, 0xA4, 0xB1 },
	0xF067,	{ 0xE9, 0xA4, 0xB2 },
	0xF068,	{ 0xE9, 0xA4, 0xB3 },
	0xF069,	{ 0xE9, 0xA4, 0xB4 },
	0xF06A,	{ 0xE9, 0xA4, 0xB5 },
	0xF06B,	{ 0xE9, 0xA4, 0xB6 },
	0xF06C,	{ 0xE9, 0xA4, 0xB7 },
	0xF06D,	{ 0xE9, 0xA4, 0xB8 },
	0xF06E,	{ 0xE9, 0xA4, 0xB9 },
	0xF06F,	{ 0xE9, 0xA4, 0xBA },
	0xF070,	{ 0xE9, 0xA4, 0xBB },
	0xF071,	{ 0xE9, 0xA4, 0xBC },
	0xF072,	{ 0xE9, 0xA4, 0xBD },
	0xF073,	{ 0xE9, 0xA4, 0xBE },
	0xF074,	{ 0xE9, 0xA4, 0xBF },
	0xF075,	{ 0xE9, 0xA5, 0x80 },
	0xF076,	{ 0xE9, 0xA5, 0x81 },
	0xF077,	{ 0xE9, 0xA5, 0x82 },
	0xF078,	{ 0xE9, 0xA5, 0x83 },
	0xF079,	{ 0xE9, 0xA5, 0x84 },
	0xF07A,	{ 0xE9, 0xA5, 0x85 },
	0xF07B,	{ 0xE9, 0xA5, 0x86 },
	0xF07C,	{ 0xE9, 0xA5, 0x87 },
	0xF07D,	{ 0xE9, 0xA5, 0x88 },
	0xF07E,	{ 0xE9, 0xA5, 0x89 },
	0xF080,	{ 0xE9, 0xA5, 0x8A },
	0xF081,	{ 0xE9, 0xA5, 0x8B },
	0xF082,	{ 0xE9, 0xA5, 0x8C },
	0xF083,	{ 0xE9, 0xA5, 0x8D },
	0xF084,	{ 0xE9, 0xA5, 0x8E },
	0xF085,	{ 0xE9, 0xA5, 0x8F },
	0xF086,	{ 0xE9, 0xA5, 0x90 },
	0xF087,	{ 0xE9, 0xA5, 0x91 },
	0xF088,	{ 0xE9, 0xA5, 0x92 },
	0xF089,	{ 0xE9, 0xA5, 0x93 },
	0xF08A,	{ 0xE9, 0xA5, 0x96 },
	0xF08B,	{ 0xE9, 0xA5, 0x97 },
	0xF08C,	{ 0xE9, 0xA5, 0x98 },
	0xF08D,	{ 0xE9, 0xA5, 0x99 },
	0xF08E,	{ 0xE9, 0xA5, 0x9A },
	0xF08F,	{ 0xE9, 0xA5, 0x9B },
	0xF090,	{ 0xE9, 0xA5, 0x9C },
	0xF091,	{ 0xE9, 0xA5, 0x9D },
	0xF092,	{ 0xE9, 0xA5, 0x9E },
	0xF093,	{ 0xE9, 0xA5, 0x9F },
	0xF094,	{ 0xE9, 0xA5, 0xA0 },
	0xF095,	{ 0xE9, 0xA5, 0xA1 },
	0xF096,	{ 0xE9, 0xA5, 0xA2 },
	0xF097,	{ 0xE9, 0xA5, 0xA4 },
	0xF098,	{ 0xE9, 0xA5, 0xA6 },
	0xF099,	{ 0xE9, 0xA5, 0xB3 },
	0xF09A,	{ 0xE9, 0xA5, 0xB8 },
	0xF09B,	{ 0xE9, 0xA5, 0xB9 },
	0xF09C,	{ 0xE9, 0xA5, 0xBB },
	0xF09D,	{ 0xE9, 0xA5, 0xBE },
	0xF09E,	{ 0xE9, 0xA6, 0x82 },
	0xF09F,	{ 0xE9, 0xA6, 0x83 },
	0xF0A0,	{ 0xE9, 0xA6, 0x89 },
	0xF0A1,	{ 0xE7, 0xA8, 0xB9 },
	0xF0A2,	{ 0xE7, 0xA8, 0xB7 },
	0xF0A3,	{ 0xE7, 0xA9, 0x91 },
	0xF0A4,	{ 0xE9, 0xBB, 0x8F },
	0xF0A5,	{ 0xE9, 0xA6, 0xA5 },
	0xF0A6,	{ 0xE7, 0xA9, 0xB0 },
	0xF0A7,	{ 0xE7, 0x9A, 0x88 },
	0xF0A8,	{ 0xE7, 0x9A, 0x8E },
	0xF0A9,	{ 0xE7, 0x9A, 0x93 },
	0xF0AA,	{ 0xE7, 0x9A, 0x99 },
	0xF0AB,	{ 0xE7, 0x9A, 0xA4 },
	0xF0AC,	{ 0xE7, 0x93, 0x9E },
	0xF0AD,	{ 0xE7, 0x93, 0xA0 },
	0xF0AE,	{ 0xE7, 0x94, 0xAC },
	0xF0AF,	{ 0xE9, 0xB8, 0xA0 },
	0xF0B0,	{ 0xE9, 0xB8, 0xA2 },
	0xF0B1,	{ 0xE9, 0xB8, 0xA8 },
	0xF0B2,	{ 0xE9, 0xB8, 0xA9 },
	0xF0B3,	{ 0xE9, 0xB8, 0xAA },
	0xF0B4,	{ 0xE9, 0xB8, 0xAB },
	0xF0B5,	{ 0xE9, 0xB8, 0xAC },
	0xF0B6,	{ 0xE9, 0xB8, 0xB2 },
	0xF0B7,	{ 0xE9, 0xB8, 0xB1 },
	0xF0B8,	{ 0xE9, 0xB8, 0xB6 },
	0xF0B9,	{ 0xE9, 0xB8, 0xB8 },
	0xF0BA,	{ 0xE9, 0xB8, 0xB7 },
	0xF0BB,	{ 0xE9, 0xB8, 0xB9 },
	0xF0BC,	{ 0xE9, 0xB8, 0xBA },
	0xF0BD,	{ 0xE9, 0xB8, 0xBE },
	0xF0BE,	{ 0xE9, 0xB9, 0x81 },
	0xF0BF,	{ 0xE9, 0xB9, 0x82 },
	0xF0C0,	{ 0xE9, 0xB9, 0x84 },
	0xF0C1,	{ 0xE9, 0xB9, 0x86 },
	0xF0C2,	{ 0xE9, 0xB9, 0x87 },
	0xF0C3,	{ 0xE9, 0xB9, 0x88 },
	0xF0C4,	{ 0xE9, 0xB9, 0x89 },
	0xF0C5,	{ 0xE9, 0xB9, 0x8B },
	0xF0C6,	{ 0xE9, 0xB9, 0x8C },
	0xF0C7,	{ 0xE9, 0xB9, 0x8E },
	0xF0C8,	{ 0xE9, 0xB9, 0x91 },
	0xF0C9,	{ 0xE9, 0xB9, 0x95 },
	0xF0CA,	{ 0xE9, 0xB9, 0x97 },
	0xF0CB,	{ 0xE9, 0xB9, 0x9A },
	0xF0CC,	{ 0xE9, 0xB9, 0x9B },
	0xF0CD,	{ 0xE9, 0xB9, 0x9C },
	0xF0CE,	{ 0xE9, 0xB9, 0x9E },
	0xF0CF,	{ 0xE9, 0xB9, 0xA3 },
	0xF0D0,	{ 0xE9, 0xB9, 0xA6 },
	0xF0D1,	{ 0xE9, 0xB9, 0xA7 },
	0xF0D2,	{ 0xE9, 0xB9, 0xA8 },
	0xF0D3,	{ 0xE9, 0xB9, 0xA9 },
	0xF0D4,	{ 0xE9, 0xB9, 0xAA },
	0xF0D5,	{ 0xE9, 0xB9, 0xAB },
	0xF0D6,	{ 0xE9, 0xB9, 0xAC },
	0xF0D7,	{ 0xE9, 0xB9, 0xB1 },
	0xF0D8,	{ 0xE9, 0xB9, 0xAD },
	0xF0D9,	{ 0xE9, 0xB9, 0xB3 },
	0xF0DA,	{ 0xE7, 0x96, 0x92 },
	0xF0DB,	{ 0xE7, 0x96, 0x94 },
	0xF0DC,	{ 0xE7, 0x96, 0x96 },
	0xF0DD,	{ 0xE7, 0x96, 0xA0 },
	0xF0DE,	{ 0xE7, 0x96, 0x9D },
	0xF0DF,	{ 0xE7, 0x96, 0xAC },
	0xF0E0,	{ 0xE7, 0x96, 0xA3 },
	0xF0E1,	{ 0xE7, 0x96, 0xB3 },
	0xF0E2,	{ 0xE7, 0x96, 0xB4 },
	0xF0E3,	{ 0xE7, 0x96, 0xB8 },
	0xF0E4,	{ 0xE7, 0x97, 0x84 },
	0xF0E5,	{ 0xE7, 0x96, 0xB1 },
	0xF0E6,	{ 0xE7, 0x96, 0xB0 },
	0xF0E7,	{ 0xE7, 0x97, 0x83 },
	0xF0E8,	{ 0xE7, 0x97, 0x82 },
	0xF0E9,	{ 0xE7, 0x97, 0x96 },
	0xF0EA,	{ 0xE7, 0x97, 0x8D },
	0xF0EB,	{ 0xE7, 0x97, 0xA3 },
	0xF0EC,	{ 0xE7, 0x97, 0xA8 },
	0xF0ED,	{ 0xE7, 0x97, 0xA6 },
	0xF0EE,	{ 0xE7, 0x97, 0xA4 },
	0xF0EF,	{ 0xE7, 0x97, 0xAB },
	0xF0F0,	{ 0xE7, 0x97, 0xA7 },
	0xF0F1,	{ 0xE7, 0x98, 0x83 },
	0xF0F2,	{ 0xE7, 0x97, 0xB1 },
	0xF0F3,	{ 0xE7, 0x97, 0xBC },
	0xF0F4,	{ 0xE7, 0x97, 0xBF },
	0xF0F5,	{ 0xE7, 0x98, 0x90 },
	0xF0F6,	{ 0xE7, 0x98, 0x80 },
	0xF0F7,	{ 0xE7, 0x98, 0x85 },
	0xF0F8,	{ 0xE7, 0x98, 0x8C },
	0xF0F9,	{ 0xE7, 0x98, 0x97 },
	0xF0FA,	{ 0xE7, 0x98, 0x8A },
	0xF0FB,	{ 0xE7, 0x98, 0xA5 },
	0xF0FC,	{ 0xE7, 0x98, 0x98 },
	0xF0FD,	{ 0xE7, 0x98, 0x95 },
	0xF0FE,	{ 0xE7, 0x98, 0x99 },
	0xF140,	{ 0xE9, 0xA6, 0x8C },
	0xF141,	{ 0xE9, 0xA6, 0x8E },
	0xF142,	{ 0xE9, 0xA6, 0x9A },
	0xF143,	{ 0xE9, 0xA6, 0x9B },
	0xF144,	{ 0xE9, 0xA6, 0x9C },
	0xF145,	{ 0xE9, 0xA6, 0x9D },
	0xF146,	{ 0xE9, 0xA6, 0x9E },
	0xF147,	{ 0xE9, 0xA6, 0x9F },
	0xF148,	{ 0xE9, 0xA6, 0xA0 },
	0xF149,	{ 0xE9, 0xA6, 0xA1 },
	0xF14A,	{ 0xE9, 0xA6, 0xA2 },
	0xF14B,	{ 0xE9, 0xA6, 0xA3 },
	0xF14C,	{ 0xE9, 0xA6, 0xA4 },
	0xF14D,	{ 0xE9, 0xA6, 0xA6 },
	0xF14E,	{ 0xE9, 0xA6, 0xA7 },
	0xF14F,	{ 0xE9, 0xA6, 0xA9 },
	0xF150,	{ 0xE9, 0xA6, 0xAA },
	0xF151,	{ 0xE9, 0xA6, 0xAB },
	0xF152,	{ 0xE9, 0xA6, 0xAC },
	0xF153,	{ 0xE9, 0xA6, 0xAD },
	0xF154,	{ 0xE9, 0xA6, 0xAE },
	0xF155,	{ 0xE9, 0xA6, 0xAF },
	0xF156,	{ 0xE9, 0xA6, 0xB0 },
	0xF157,	{ 0xE9, 0xA6, 0xB1 },
	0xF158,	{ 0xE9, 0xA6, 0xB2 },
	0xF159,	{ 0xE9, 0xA6, 0xB3 },
	0xF15A,	{ 0xE9, 0xA6, 0xB4 },
	0xF15B,	{ 0xE9, 0xA6, 0xB5 },
	0xF15C,	{ 0xE9, 0xA6, 0xB6 },
	0xF15D,	{ 0xE9, 0xA6, 0xB7 },
	0xF15E,	{ 0xE9, 0xA6, 0xB8 },
	0xF15F,	{ 0xE9, 0xA6, 0xB9 },
	0xF160,	{ 0xE9, 0xA6, 0xBA },
	0xF161,	{ 0xE9, 0xA6, 0xBB },
	0xF162,	{ 0xE9, 0xA6, 0xBC },
	0xF163,	{ 0xE9, 0xA6, 0xBD },
	0xF164,	{ 0xE9, 0xA6, 0xBE },
	0xF165,	{ 0xE9, 0xA6, 0xBF },
	0xF166,	{ 0xE9, 0xA7, 0x80 },
	0xF167,	{ 0xE9, 0xA7, 0x81 },
	0xF168,	{ 0xE9, 0xA7, 0x82 },
	0xF169,	{ 0xE9, 0xA7, 0x83 },
	0xF16A,	{ 0xE9, 0xA7, 0x84 },
	0xF16B,	{ 0xE9, 0xA7, 0x85 },
	0xF16C,	{ 0xE9, 0xA7, 0x86 },
	0xF16D,	{ 0xE9, 0xA7, 0x87 },
	0xF16E,	{ 0xE9, 0xA7, 0x88 },
	0xF16F,	{ 0xE9, 0xA7, 0x89 },
	0xF170,	{ 0xE9, 0xA7, 0x8A },
	0xF171,	{ 0xE9, 0xA7, 0x8B },
	0xF172,	{ 0xE9, 0xA7, 0x8C },
	0xF173,	{ 0xE9, 0xA7, 0x8D },
	0xF174,	{ 0xE9, 0xA7, 0x8E },
	0xF175,	{ 0xE9, 0xA7, 0x8F },
	0xF176,	{ 0xE9, 0xA7, 0x90 },
	0xF177,	{ 0xE9, 0xA7, 0x91 },
	0xF178,	{ 0xE9, 0xA7, 0x92 },
	0xF179,	{ 0xE9, 0xA7, 0x93 },
	0xF17A,	{ 0xE9, 0xA7, 0x94 },
	0xF17B,	{ 0xE9, 0xA7, 0x95 },
	0xF17C,	{ 0xE9, 0xA7, 0x96 },
	0xF17D,	{ 0xE9, 0xA7, 0x97 },
	0xF17E,	{ 0xE9, 0xA7, 0x98 },
	0xF180,	{ 0xE9, 0xA7, 0x99 },
	0xF181,	{ 0xE9, 0xA7, 0x9A },
	0xF182,	{ 0xE9, 0xA7, 0x9B },
	0xF183,	{ 0xE9, 0xA7, 0x9C },
	0xF184,	{ 0xE9, 0xA7, 0x9D },
	0xF185,	{ 0xE9, 0xA7, 0x9E },
	0xF186,	{ 0xE9, 0xA7, 0x9F },
	0xF187,	{ 0xE9, 0xA7, 0xA0 },
	0xF188,	{ 0xE9, 0xA7, 0xA1 },
	0xF189,	{ 0xE9, 0xA7, 0xA2 },
	0xF18A,	{ 0xE9, 0xA7, 0xA3 },
	0xF18B,	{ 0xE9, 0xA7, 0xA4 },
	0xF18C,	{ 0xE9, 0xA7, 0xA5 },
	0xF18D,	{ 0xE9, 0xA7, 0xA6 },
	0xF18E,	{ 0xE9, 0xA7, 0xA7 },
	0xF18F,	{ 0xE9, 0xA7, 0xA8 },
	0xF190,	{ 0xE9, 0xA7, 0xA9 },
	0xF191,	{ 0xE9, 0xA7, 0xAA },
	0xF192,	{ 0xE9, 0xA7, 0xAB },
	0xF193,	{ 0xE9, 0xA7, 0xAC },
	0xF194,	{ 0xE9, 0xA7, 0xAD },
	0xF195,	{ 0xE9, 0xA7, 0xAE },
	0xF196,	{ 0xE9, 0xA7, 0xAF },
	0xF197,	{ 0xE9, 0xA7, 0xB0 },
	0xF198,	{ 0xE9, 0xA7, 0xB1 },
	0xF199,	{ 0xE9, 0xA7, 0xB2 },
	0xF19A,	{ 0xE9, 0xA7, 0xB3 },
	0xF19B,	{ 0xE9, 0xA7, 0xB4 },
	0xF19C,	{ 0xE9, 0xA7, 0xB5 },
	0xF19D,	{ 0xE9, 0xA7, 0xB6 },
	0xF19E,	{ 0xE9, 0xA7, 0xB7 },
	0xF19F,	{ 0xE9, 0xA7, 0xB8 },
	0xF1A0,	{ 0xE9, 0xA7, 0xB9 },
	0xF1A1,	{ 0xE7, 0x98, 0x9B },
	0xF1A2,	{ 0xE7, 0x98, 0xBC },
	0xF1A3,	{ 0xE7, 0x98, 0xA2 },
	0xF1A4,	{ 0xE7, 0x98, 0xA0 },
	0xF1A5,	{ 0xE7, 0x99, 0x80 },
	0xF1A6,	{ 0xE7, 0x98, 0xAD },
	0xF1A7,	{ 0xE7, 0x98, 0xB0 },
	0xF1A8,	{ 0xE7, 0x98, 0xBF },
	0xF1A9,	{ 0xE7, 0x98, 0xB5 },
	0xF1AA,	{ 0xE7, 0x99, 0x83 },
	0xF1AB,	{ 0xE7, 0x98, 0xBE },
	0xF1AC,	{ 0xE7, 0x98, 0xB3 },
	0xF1AD,	{ 0xE7, 0x99, 0x8D },
	0xF1AE,	{ 0xE7, 0x99, 0x9E },
	0xF1AF,	{ 0xE7, 0x99, 0x94 },
	0xF1B0,	{ 0xE7, 0x99, 0x9C },
	0xF1B1,	{ 0xE7, 0x99, 0x96 },
	0xF1B2,	{ 0xE7, 0x99, 0xAB },
	0xF1B3,	{ 0xE7, 0x99, 0xAF },
	0xF1B4,	{ 0xE7, 0xBF, 0x8A },
	0xF1B5,	{ 0xE7, 0xAB, 0xA6 },
	0xF1B6,	{ 0xE7, 0xA9, 0xB8 },
	0xF1B7,	{ 0xE7, 0xA9, 0xB9 },
	0xF1B8,	{ 0xE7, 0xAA, 0x80 },
	0xF1B9,	{ 0xE7, 0xAA, 0x86 },
	0xF1BA,	{ 0xE7, 0xAA, 0x88 },
	0xF1BB,	{ 0xE7, 0xAA, 0x95 },
	0xF1BC,	{ 0xE7, 0xAA, 0xA6 },
	0xF1BD,	{ 0xE7, 0xAA, 0xA0 },
	0xF1BE,	{ 0xE7, 0xAA, 0xAC },
	0xF1BF,	{ 0xE7, 0xAA, 0xA8 },
	0xF1C0,	{ 0xE7, 0xAA, 0xAD },
	0xF1C1,	{ 0xE7, 0xAA, 0xB3 },
	0xF1C2,	{ 0xE8, 0xA1, 0xA4 },
	0xF1C3,	{ 0xE8, 0xA1, 0xA9 },
	0xF1C4,	{ 0xE8, 0xA1, 0xB2 },
	0xF1C5,	{ 0xE8, 0xA1, 0xBD },
	0xF1C6,	{ 0xE8, 0xA1, 0xBF },
	0xF1C7,	{ 0xE8, 0xA2, 0x82 },
	0xF1C8,	{ 0xE8, 0xA2, 0xA2 },
	0xF1C9,	{ 0xE8, 0xA3, 0x86 },
	0xF1CA,	{ 0xE8, 0xA2, 0xB7 },
	0xF1CB,	{ 0xE8, 0xA2, 0xBC },
	0xF1CC,	{ 0xE8, 0xA3, 0x89 },
	0xF1CD,	{ 0xE8, 0xA3, 0xA2 },
	0xF1CE,	{ 0xE8, 0xA3, 0x8E },
	0xF1CF,	{ 0xE8, 0xA3, 0xA3 },
	0xF1D0,	{ 0xE8, 0xA3, 0xA5 },
	0xF1D1,	{ 0xE8, 0xA3, 0xB1 },
	0xF1D2,	{ 0xE8, 0xA4, 0x9A },
	0xF1D3,	{ 0xE8, 0xA3, 0xBC },
	0xF1D4,	{ 0xE8, 0xA3, 0xA8 },
	0xF1D5,	{ 0xE8, 0xA3, 0xBE },
	0xF1D6,	{ 0xE8, 0xA3, 0xB0 },
	0xF1D7,	{ 0xE8, 0xA4, 0xA1 },
	0xF1D8,	{ 0xE8, 0xA4, 0x99 },
	0xF1D9,	{ 0xE8, 0xA4, 0x93 },
	0xF1DA,	{ 0xE8, 0xA4, 0x9B },
	0xF1DB,	{ 0xE8, 0xA4, 0x8A },
	0xF1DC,	{ 0xE8, 0xA4, 0xB4 },
	0xF1DD,	{ 0xE8, 0xA4, 0xAB },
	0xF1DE,	{ 0xE8, 0xA4, 0xB6 },
	0xF1DF,	{ 0xE8, 0xA5, 0x81 },
	0xF1E0,	{ 0xE8, 0xA5, 0xA6 },
	0xF1E1,	{ 0xE8, 0xA5, 0xBB },
	0xF1E2,	{ 0xE7, 0x96, 0x8B },
	0xF1E3,	{ 0xE8, 0x83, 0xA5 },
	0xF1E4,	{ 0xE7, 0x9A, 0xB2 },
	0xF1E5,	{ 0xE7, 0x9A, 0xB4 },
	0xF1E6,	{ 0xE7, 0x9F, 0x9C },
	0xF1E7,	{ 0xE8, 0x80, 0x92 },
	0xF1E8,	{ 0xE8, 0x80, 0x94 },
	0xF1E9,	{ 0xE8, 0x80, 0x96 },
	0xF1EA,	{ 0xE8, 0x80, 0x9C },
	0xF1EB,	{ 0xE8, 0x80, 0xA0 },
	0xF1EC,	{ 0xE8, 0x80, 0xA2 },
	0xF1ED,	{ 0xE8, 0x80, 0xA5 },
	0xF1EE,	{ 0xE8, 0x80, 0xA6 },
	0xF1EF,	{ 0xE8, 0x80, 0xA7 },
	0xF1F0,	{ 0xE8, 0x80, 0xA9 },
	0xF1F1,	{ 0xE8, 0x80, 0xA8 },
	0xF1F2,	{ 0xE8, 0x80, 0xB1 },
	0xF1F3,	{ 0xE8, 0x80, 0x8B },
	0xF1F4,	{ 0xE8, 0x80, 0xB5 },
	0xF1F5,	{ 0xE8, 0x81, 0x83 },
	0xF1F6,	{ 0xE8, 0x81, 0x86 },
	0xF1F7,	{ 0xE8, 0x81, 0x8D },
	0xF1F8,	{ 0xE8, 0x81, 0x92 },
	0xF1F9,	{ 0xE8, 0x81, 0xA9 },
	0xF1FA,	{ 0xE8, 0x81, 0xB1 },
	0xF1FB,	{ 0xE8, 0xA6, 0x83 },
	0xF1FC,	{ 0xE9, 0xA1, 0xB8 },
	0xF1FD,	{ 0xE9, 0xA2, 0x80 },
	0xF1FE,	{ 0xE9, 0xA2, 0x83 },
	0xF240,	{ 0xE9, 0xA7, 0xBA },
	0xF241,	{ 0xE9, 0xA7, 0xBB },
	0xF242,	{ 0xE9, 0xA7, 0xBC },
	0xF243,	{ 0xE9, 0xA7, 0xBD },
	0xF244,	{ 0xE9, 0xA7, 0xBE },
	0xF245,	{ 0xE9, 0xA7, 0xBF },
	0xF246,	{ 0xE9, 0xA8, 0x80 },
	0xF247,	{ 0xE9, 0xA8, 0x81 },
	0xF248,	{ 0xE9, 0xA8, 0x82 },
	0xF249,	{ 0xE9, 0xA8, 0x83 },
	0xF24A,	{ 0xE9, 0xA8, 0x84 },
	0xF24B,	{ 0xE9, 0xA8, 0x85 },
	0xF24C,	{ 0xE9, 0xA8, 0x86 },
	0xF24D,	{ 0xE9, 0xA8, 0x87 },
	0xF24E,	{ 0xE9, 0xA8, 0x88 },
	0xF24F,	{ 0xE9, 0xA8, 0x89 },
	0xF250,	{ 0xE9, 0xA8, 0x8A },
	0xF251,	{ 0xE9, 0xA8, 0x8B },
	0xF252,	{ 0xE9, 0xA8, 0x8C },
	0xF253,	{ 0xE9, 0xA8, 0x8D },
	0xF254,	{ 0xE9, 0xA8, 0x8E },
	0xF255,	{ 0xE9, 0xA8, 0x8F },
	0xF256,	{ 0xE9, 0xA8, 0x90 },
	0xF257,	{ 0xE9, 0xA8, 0x91 },
	0xF258,	{ 0xE9, 0xA8, 0x92 },
	0xF259,	{ 0xE9, 0xA8, 0x93 },
	0xF25A,	{ 0xE9, 0xA8, 0x94 },
	0xF25B,	{ 0xE9, 0xA8, 0x95 },
	0xF25C,	{ 0xE9, 0xA8, 0x96 },
	0xF25D,	{ 0xE9, 0xA8, 0x97 },
	0xF25E,	{ 0xE9, 0xA8, 0x98 },
	0xF25F,	{ 0xE9, 0xA8, 0x99 },
	0xF260,	{ 0xE9, 0xA8, 0x9A },
	0xF261,	{ 0xE9, 0xA8, 0x9B },
	0xF262,	{ 0xE9, 0xA8, 0x9C },
	0xF263,	{ 0xE9, 0xA8, 0x9D },
	0xF264,	{ 0xE9, 0xA8, 0x9E },
	0xF265,	{ 0xE9, 0xA8, 0x9F },
	0xF266,	{ 0xE9, 0xA8, 0xA0 },
	0xF267,	{ 0xE9, 0xA8, 0xA1 },
	0xF268,	{ 0xE9, 0xA8, 0xA2 },
	0xF269,	{ 0xE9, 0xA8, 0xA3 },
	0xF26A,	{ 0xE9, 0xA8, 0xA4 },
	0xF26B,	{ 0xE9, 0xA8, 0xA5 },
	0xF26C,	{ 0xE9, 0xA8, 0xA6 },
	0xF26D,	{ 0xE9, 0xA8, 0xA7 },
	0xF26E,	{ 0xE9, 0xA8, 0xA8 },
	0xF26F,	{ 0xE9, 0xA8, 0xA9 },
	0xF270,	{ 0xE9, 0xA8, 0xAA },
	0xF271,	{ 0xE9, 0xA8, 0xAB },
	0xF272,	{ 0xE9, 0xA8, 0xAC },
	0xF273,	{ 0xE9, 0xA8, 0xAD },
	0xF274,	{ 0xE9, 0xA8, 0xAE },
	0xF275,	{ 0xE9, 0xA8, 0xAF },
	0xF276,	{ 0xE9, 0xA8, 0xB0 },
	0xF277,	{ 0xE9, 0xA8, 0xB1 },
	0xF278,	{ 0xE9, 0xA8, 0xB2 },
	0xF279,	{ 0xE9, 0xA8, 0xB3 },
	0xF27A,	{ 0xE9, 0xA8, 0xB4 },
	0xF27B,	{ 0xE9, 0xA8, 0xB5 },
	0xF27C,	{ 0xE9, 0xA8, 0xB6 },
	0xF27D,	{ 0xE9, 0xA8, 0xB7 },
	0xF27E,	{ 0xE9, 0xA8, 0xB8 },
	0xF280,	{ 0xE9, 0xA8, 0xB9 },
	0xF281,	{ 0xE9, 0xA8, 0xBA },
	0xF282,	{ 0xE9, 0xA8, 0xBB },
	0xF283,	{ 0xE9, 0xA8, 0xBC },
	0xF284,	{ 0xE9, 0xA8, 0xBD },
	0xF285,	{ 0xE9, 0xA8, 0xBE },
	0xF286,	{ 0xE9, 0xA8, 0xBF },
	0xF287,	{ 0xE9, 0xA9, 0x80 },
	0xF288,	{ 0xE9, 0xA9, 0x81 },
	0xF289,	{ 0xE9, 0xA9, 0x82 },
	0xF28A,	{ 0xE9, 0xA9, 0x83 },
	0xF28B,	{ 0xE9, 0xA9, 0x84 },
	0xF28C,	{ 0xE9, 0xA9, 0x85 },
	0xF28D,	{ 0xE9, 0xA9, 0x86 },
	0xF28E,	{ 0xE9, 0xA9, 0x87 },
	0xF28F,	{ 0xE9, 0xA9, 0x88 },
	0xF290,	{ 0xE9, 0xA9, 0x89 },
	0xF291,	{ 0xE9, 0xA9, 0x8A },
	0xF292,	{ 0xE9, 0xA9, 0x8B },
	0xF293,	{ 0xE9, 0xA9, 0x8C },
	0xF294,	{ 0xE9, 0xA9, 0x8D },
	0xF295,	{ 0xE9, 0xA9, 0x8E },
	0xF296,	{ 0xE9, 0xA9, 0x8F },
	0xF297,	{ 0xE9, 0xA9, 0x90 },
	0xF298,	{ 0xE9, 0xA9, 0x91 },
	0xF299,	{ 0xE9, 0xA9, 0x92 },
	0xF29A,	{ 0xE9, 0xA9, 0x93 },
	0xF29B,	{ 0xE9, 0xA9, 0x94 },
	0xF29C,	{ 0xE9, 0xA9, 0x95 },
	0xF29D,	{ 0xE9, 0xA9, 0x96 },
	0xF29E,	{ 0xE9, 0xA9, 0x97 },
	0xF29F,	{ 0xE9, 0xA9, 0x98 },
	0xF2A0,	{ 0xE9, 0xA9, 0x99 },
	0xF2A1,	{ 0xE9, 0xA2, 0x89 },
	0xF2A2,	{ 0xE9, 0xA2, 0x8C },
	0xF2A3,	{ 0xE9, 0xA2, 0x8D },
	0xF2A4,	{ 0xE9, 0xA2, 0x8F },
	0xF2A5,	{ 0xE9, 0xA2, 0x94 },
	0xF2A6,	{ 0xE9, 0xA2, 0x9A },
	0xF2A7,	{ 0xE9, 0xA2, 0x9B },
	0xF2A8,	{ 0xE9, 0xA2, 0x9E },
	0xF2A9,	{ 0xE9, 0xA2, 0x9F },
	0xF2AA,	{ 0xE9, 0xA2, 0xA1 },
	0xF2AB,	{ 0xE9, 0xA2, 0xA2 },
	0xF2AC,	{ 0xE9, 0xA2, 0xA5 },
	0xF2AD,	{ 0xE9, 0xA2, 0xA6 },
	0xF2AE,	{ 0xE8, 0x99, 0x8D },
	0xF2AF,	{ 0xE8, 0x99, 0x94 },
	0xF2B0,	{ 0xE8, 0x99, 0xAC },
	0xF2B1,	{ 0xE8, 0x99, 0xAE },
	0xF2B2,	{ 0xE8, 0x99, 0xBF },
	0xF2B3,	{ 0xE8, 0x99, 0xBA },
	0xF2B4,	{ 0xE8, 0x99, 0xBC },
	0xF2B5,	{ 0xE8, 0x99, 0xBB },
	0xF2B6,	{ 0xE8, 0x9A, 0xA8 },
	0xF2B7,	{ 0xE8, 0x9A, 0x8D },
	0xF2B8,	{ 0xE8, 0x9A, 0x8B },
	0xF2B9,	{ 0xE8, 0x9A, 0xAC },
	0xF2BA,	{ 0xE8, 0x9A, 0x9D },
	0xF2BB,	{ 0xE8, 0x9A, 0xA7 },
	0xF2BC,	{ 0xE8, 0x9A, 0xA3 },
	0xF2BD,	{ 0xE8, 0x9A, 0xAA },
	0xF2BE,	{ 0xE8, 0x9A, 0x93 },
	0xF2BF,	{ 0xE8, 0x9A, 0xA9 },
	0xF2C0,	{ 0xE8, 0x9A, 0xB6 },
	0xF2C1,	{ 0xE8, 0x9B, 0x84 },
	0xF2C2,	{ 0xE8, 0x9A, 0xB5 },
	0xF2C3,	{ 0xE8, 0x9B, 0x8E },
	0xF2C4,	{ 0xE8, 0x9A, 0xB0 },
	0xF2C5,	{ 0xE8, 0x9A, 0xBA },
	0xF2C6,	{ 0xE8, 0x9A, 0xB1 },
	0xF2C7,	{ 0xE8, 0x9A, 0xAF },
	0xF2C8,	{ 0xE8, 0x9B, 0x89 },
	0xF2C9,	{ 0xE8, 0x9B, 0x8F },
	0xF2CA,	{ 0xE8, 0x9A, 0xB4 },
	0xF2CB,	{ 0xE8, 0x9B, 0xA9 },
	0xF2CC,	{ 0xE8, 0x9B, 0xB1 },
	0xF2CD,	{ 0xE8, 0x9B, 0xB2 },
	0xF2CE,	{ 0xE8, 0x9B, 0xAD },
	0xF2CF,	{ 0xE8, 0x9B, 0xB3 },
	0xF2D0,	{ 0xE8, 0x9B, 0x90 },
	0xF2D1,	{ 0xE8, 0x9C, 0x93 },
	0xF2D2,	{ 0xE8, 0x9B, 0x9E },
	0xF2D3,	{ 0xE8, 0x9B, 0xB4 },
	0xF2D4,	{ 0xE8, 0x9B, 0x9F },
	0xF2D5,	{ 0xE8, 0x9B, 0x98 },
	0xF2D6,	{ 0xE8, 0x9B, 0x91 },
	0xF2D7,	{ 0xE8, 0x9C, 0x83 },
	0xF2D8,	{ 0xE8, 0x9C, 0x87 },
	0xF2D9,	{ 0xE8, 0x9B, 0xB8 },
	0xF2DA,	{ 0xE8, 0x9C, 0x88 },
	0xF2DB,	{ 0xE8, 0x9C, 0x8A },
	0xF2DC,	{ 0xE8, 0x9C, 0x8D },
	0xF2DD,	{ 0xE8, 0x9C, 0x89 },
	0xF2DE,	{ 0xE8, 0x9C, 0xA3 },
	0xF2DF,	{ 0xE8, 0x9C, 0xBB },
	0xF2E0,	{ 0xE8, 0x9C, 0x9E },
	0xF2E1,	{ 0xE8, 0x9C, 0xA5 },
	0xF2E2,	{ 0xE8, 0x9C, 0xAE },
	0xF2E3,	{ 0xE8, 0x9C, 0x9A },
	0xF2E4,	{ 0xE8, 0x9C, 0xBE },
	0xF2E5,	{ 0xE8, 0x9D, 0x88 },
	0xF2E6,	{ 0xE8, 0x9C, 0xB4 },
	0xF2E7,	{ 0xE8, 0x9C, 0xB1 },
	0xF2E8,	{ 0xE8, 0x9C, 0xA9 },
	0xF2E9,	{ 0xE8, 0x9C, 0xB7 },
	0xF2EA,	{ 0xE8, 0x9C, 0xBF },
	0xF2EB,	{ 0xE8, 0x9E, 0x82 },
	0xF2EC,	{ 0xE8, 0x9C, 0xA2 },
	0xF2ED,	{ 0xE8, 0x9D, 0xBD },
	0xF2EE,	{ 0xE8, 0x9D, 0xBE },
	0xF2EF,	{ 0xE8, 0x9D, 0xBB },
	0xF2F0,	{ 0xE8, 0x9D, 0xA0 },
	0xF2F1,	{ 0xE8, 0x9D, 0xB0 },
	0xF2F2,	{ 0xE8, 0x9D, 0x8C },
	0xF2F3,	{ 0xE8, 0x9D, 0xAE },
	0xF2F4,	{ 0xE8, 0x9E, 0x8B },
	0xF2F5,	{ 0xE8, 0x9D, 0x93 },
	0xF2F6,	{ 0xE8, 0x9D, 0xA3 },
	0xF2F7,	{ 0xE8, 0x9D, 0xBC },
	0xF2F8,	{ 0xE8, 0x9D, 0xA4 },
	0xF2F9,	{ 0xE8, 0x9D, 0x99 },
	0xF2FA,	{ 0xE8, 0x9D, 0xA5 },
	0xF2FB,	{ 0xE8, 0x9E, 0x93 },
	0xF2FC,	{ 0xE8, 0x9E, 0xAF },
	0xF2FD,	{ 0xE8, 0x9E, 0xA8 },
	0xF2FE,	{ 0xE8, 0x9F, 0x92 },
	0xF340,	{ 0xE9, 0xA9, 0x9A },
	0xF341,	{ 0xE9, 0xA9, 0x9B },
	0xF342,	{ 0xE9, 0xA9, 0x9C },
	0xF343,	{ 0xE9, 0xA9, 0x9D },
	0xF344,	{ 0xE9, 0xA9, 0x9E },
	0xF345,	{ 0xE9, 0xA9, 0x9F },
	0xF346,	{ 0xE9, 0xA9, 0xA0 },
	0xF347,	{ 0xE9, 0xA9, 0xA1 },
	0xF348,	{ 0xE9, 0xA9, 0xA2 },
	0xF349,	{ 0xE9, 0xA9, 0xA3 },
	0xF34A,	{ 0xE9, 0xA9, 0xA4 },
	0xF34B,	{ 0xE9, 0xA9, 0xA5 },
	0xF34C,	{ 0xE9, 0xA9, 0xA6 },
	0xF34D,	{ 0xE9, 0xA9, 0xA7 },
	0xF34E,	{ 0xE9, 0xA9, 0xA8 },
	0xF34F,	{ 0xE9, 0xA9, 0xA9 },
	0xF350,	{ 0xE9, 0xA9, 0xAA },
	0xF351,	{ 0xE9, 0xA9, 0xAB },
	0xF352,	{ 0xE9, 0xA9, 0xB2 },
	0xF353,	{ 0xE9, 0xAA, 0x83 },
	0xF354,	{ 0xE9, 0xAA, 0x89 },
	0xF355,	{ 0xE9, 0xAA, 0x8D },
	0xF356,	{ 0xE9, 0xAA, 0x8E },
	0xF357,	{ 0xE9, 0xAA, 0x94 },
	0xF358,	{ 0xE9, 0xAA, 0x95 },
	0xF359,	{ 0xE9, 0xAA, 0x99 },
	0xF35A,	{ 0xE9, 0xAA, 0xA6 },
	0xF35B,	{ 0xE9, 0xAA, 0xA9 },
	0xF35C,	{ 0xE9, 0xAA, 0xAA },
	0xF35D,	{ 0xE9, 0xAA, 0xAB },
	0xF35E,	{ 0xE9, 0xAA, 0xAC },
	0xF35F,	{ 0xE9, 0xAA, 0xAD },
	0xF360,	{ 0xE9, 0xAA, 0xAE },
	0xF361,	{ 0xE9, 0xAA, 0xAF },
	0xF362,	{ 0xE9, 0xAA, 0xB2 },
	0xF363,	{ 0xE9, 0xAA, 0xB3 },
	0xF364,	{ 0xE9, 0xAA, 0xB4 },
	0xF365,	{ 0xE9, 0xAA, 0xB5 },
	0xF366,	{ 0xE9, 0xAA, 0xB9 },
	0xF367,	{ 0xE9, 0xAA, 0xBB },
	0xF368,	{ 0xE9, 0xAA, 0xBD },
	0xF369,	{ 0xE9, 0xAA, 0xBE },
	0xF36A,	{ 0xE9, 0xAA, 0xBF },
	0xF36B,	{ 0xE9, 0xAB, 0x83 },
	0xF36C,	{ 0xE9, 0xAB, 0x84 },
	0xF36D,	{ 0xE9, 0xAB, 0x86 },
	0xF36E,	{ 0xE9, 0xAB, 0x87 },
	0xF36F,	{ 0xE9, 0xAB, 0x88 },
	0xF370,	{ 0xE9, 0xAB, 0x89 },
	0xF371,	{ 0xE9, 0xAB, 0x8A },
	0xF372,	{ 0xE9, 0xAB, 0x8D },
	0xF373,	{ 0xE9, 0xAB, 0x8E },
	0xF374,	{ 0xE9, 0xAB, 0x8F },
	0xF375,	{ 0xE9, 0xAB, 0x90 },
	0xF376,	{ 0xE9, 0xAB, 0x92 },
	0xF377,	{ 0xE9, 0xAB, 0x94 },
	0xF378,	{ 0xE9, 0xAB, 0x95 },
	0xF379,	{ 0xE9, 0xAB, 0x96 },
	0xF37A,	{ 0xE9, 0xAB, 0x97 },
	0xF37B,	{ 0xE9, 0xAB, 0x99 },
	0xF37C,	{ 0xE9, 0xAB, 0x9A },
	0xF37D,	{ 0xE9, 0xAB, 0x9B },
	0xF37E,	{ 0xE9, 0xAB, 0x9C },
	0xF380,	{ 0xE9, 0xAB, 0x9D },
	0xF381,	{ 0xE9, 0xAB, 0x9E },
	0xF382,	{ 0xE9, 0xAB, 0xA0 },
	0xF383,	{ 0xE9, 0xAB, 0xA2 },
	0xF384,	{ 0xE9, 0xAB, 0xA3 },
	0xF385,	{ 0xE9, 0xAB, 0xA4 },
	0xF386,	{ 0xE9, 0xAB, 0xA5 },
	0xF387,	{ 0xE9, 0xAB, 0xA7 },
	0xF388,	{ 0xE9, 0xAB, 0xA8 },
	0xF389,	{ 0xE9, 0xAB, 0xA9 },
	0xF38A,	{ 0xE9, 0xAB, 0xAA },
	0xF38B,	{ 0xE9, 0xAB, 0xAC },
	0xF38C,	{ 0xE9, 0xAB, 0xAE },
	0xF38D,	{ 0xE9, 0xAB, 0xB0 },
	0xF38E,	{ 0xE9, 0xAB, 0xB1 },
	0xF38F,	{ 0xE9, 0xAB, 0xB2 },
	0xF390,	{ 0xE9, 0xAB, 0xB3 },
	0xF391,	{ 0xE9, 0xAB, 0xB4 },
	0xF392,	{ 0xE9, 0xAB, 0xB5 },
	0xF393,	{ 0xE9, 0xAB, 0xB6 },
	0xF394,	{ 0xE9, 0xAB, 0xB7 },
	0xF395,	{ 0xE9, 0xAB, 0xB8 },
	0xF396,	{ 0xE9, 0xAB, 0xBA },
	0xF397,	{ 0xE9, 0xAB, 0xBC },
	0xF398,	{ 0xE9, 0xAB, 0xBD },
	0xF399,	{ 0xE9, 0xAB, 0xBE },
	0xF39A,	{ 0xE9, 0xAB, 0xBF },
	0xF39B,	{ 0xE9, 0xAC, 0x80 },
	0xF39C,	{ 0xE9, 0xAC, 0x81 },
	0xF39D,	{ 0xE9, 0xAC, 0x82 },
	0xF39E,	{ 0xE9, 0xAC, 0x84 },
	0xF39F,	{ 0xE9, 0xAC, 0x85 },
	0xF3A0,	{ 0xE9, 0xAC, 0x86 },
	0xF3A1,	{ 0xE8, 0x9F, 0x86 },
	0xF3A2,	{ 0xE8, 0x9E, 0x88 },
	0xF3A3,	{ 0xE8, 0x9E, 0x85 },
	0xF3A4,	{ 0xE8, 0x9E, 0xAD },
	0xF3A5,	{ 0xE8, 0x9E, 0x97 },
	0xF3A6,	{ 0xE8, 0x9E, 0x83 },
	0xF3A7,	{ 0xE8, 0x9E, 0xAB },
	0xF3A8,	{ 0xE8, 0x9F, 0xA5 },
	0xF3A9,	{ 0xE8, 0x9E, 0xAC },
	0xF3AA,	{ 0xE8, 0x9E, 0xB5 },
	0xF3AB,	{ 0xE8, 0x9E, 0xB3 },
	0xF3AC,	{ 0xE8, 0x9F, 0x8B },
	0xF3AD,	{ 0xE8, 0x9F, 0x93 },
	0xF3AE,	{ 0xE8, 0x9E, 0xBD },
	0xF3AF,	{ 0xE8, 0x9F, 0x91 },
	0xF3B0,	{ 0xE8, 0x9F, 0x80 },
	0xF3B1,	{ 0xE8, 0x9F, 0x8A },
	0xF3B2,	{ 0xE8, 0x9F, 0x9B },
	0xF3B3,	{ 0xE8, 0x9F, 0xAA },
	0xF3B4,	{ 0xE8, 0x9F, 0xA0 },
	0xF3B5,	{ 0xE8, 0x9F, 0xAE },
	0xF3B6,	{ 0xE8, 0xA0, 0x96 },
	0xF3B7,	{ 0xE8, 0xA0, 0x93 },
	0xF3B8,	{ 0xE8, 0x9F, 0xBE },
	0xF3B9,	{ 0xE8, 0xA0, 0x8A },
	0xF3BA,	{ 0xE8, 0xA0, 0x9B },
	0xF3BB,	{ 0xE8, 0xA0, 0xA1 },
	0xF3BC,	{ 0xE8, 0xA0, 0xB9 },
	0xF3BD,	{ 0xE8, 0xA0, 0xBC },
	0xF3BE,	{ 0xE7, 0xBC, 0xB6 },
	0xF3BF,	{ 0xE7, 0xBD, 0x82 },
	0xF3C0,	{ 0xE7, 0xBD, 0x84 },
	0xF3C1,	{ 0xE7, 0xBD, 0x85 },
	0xF3C2,	{ 0xE8, 0x88, 0x90 },
	0xF3C3,	{ 0xE7, 0xAB, 0xBA },
	0xF3C4,	{ 0xE7, 0xAB, 0xBD },
	0xF3C5,	{ 0xE7, 0xAC, 0x88 },
	0xF3C6,	{ 0xE7, 0xAC, 0x83 },
	0xF3C7,	{ 0xE7, 0xAC, 0x84 },
	0xF3C8,	{ 0xE7, 0xAC, 0x95 },
	0xF3C9,	{ 0xE7, 0xAC, 0x8A },
	0xF3CA,	{ 0xE7, 0xAC, 0xAB },
	0xF3CB,	{ 0xE7, 0xAC, 0x8F },
	0xF3CC,	{ 0xE7, 0xAD, 0x87 },
	0xF3CD,	{ 0xE7, 0xAC, 0xB8 },
	0xF3CE,	{ 0xE7, 0xAC, 0xAA },
	0xF3CF,	{ 0xE7, 0xAC, 0x99 },
	0xF3D0,	{ 0xE7, 0xAC, 0xAE },
	0xF3D1,	{ 0xE7, 0xAC, 0xB1 },
	0xF3D2,	{ 0xE7, 0xAC, 0xA0 },
	0xF3D3,	{ 0xE7, 0xAC, 0xA5 },
	0xF3D4,	{ 0xE7, 0xAC, 0xA4 },
	0xF3D5,	{ 0xE7, 0xAC, 0xB3 },
	0xF3D6,	{ 0xE7, 0xAC, 0xBE },
	0xF3D7,	{ 0xE7, 0xAC, 0x9E },
	0xF3D8,	{ 0xE7, 0xAD, 0x98 },
	0xF3D9,	{ 0xE7, 0xAD, 0x9A },
	0xF3DA,	{ 0xE7, 0xAD, 0x85 },
	0xF3DB,	{ 0xE7, 0xAD, 0xB5 },
	0xF3DC,	{ 0xE7, 0xAD, 0x8C },
	0xF3DD,	{ 0xE7, 0xAD, 0x9D },
	0xF3DE,	{ 0xE7, 0xAD, 0xA0 },
	0xF3DF,	{ 0xE7, 0xAD, 0xAE },
	0xF3E0,	{ 0xE7, 0xAD, 0xBB },
	0xF3E1,	{ 0xE7, 0xAD, 0xA2 },
	0xF3E2,	{ 0xE7, 0xAD, 0xB2 },
	0xF3E3,	{ 0xE7, 0xAD, 0xB1 },
	0xF3E4,	{ 0xE7, 0xAE, 0x90 },
	0xF3E5,	{ 0xE7, 0xAE, 0xA6 },
	0xF3E6,	{ 0xE7, 0xAE, 0xA7 },
	0xF3E7,	{ 0xE7, 0xAE, 0xB8 },
	0xF3E8,	{ 0xE7, 0xAE, 0xAC },
	0xF3E9,	{ 0xE7, 0xAE, 0x9D },
	0xF3EA,	{ 0xE7, 0xAE, 0xA8 },
	0xF3EB,	{ 0xE7, 0xAE, 0x85 },
	0xF3EC,	{ 0xE7, 0xAE, 0xAA },
	0xF3ED,	{ 0xE7, 0xAE, 0x9C },
	0xF3EE,	{ 0xE7, 0xAE, 0xA2 },
	0xF3EF,	{ 0xE7, 0xAE, 0xAB },
	0xF3F0,	{ 0xE7, 0xAE, 0xB4 },
	0xF3F1,	{ 0xE7, 0xAF, 0x91 },
	0xF3F2,	{ 0xE7, 0xAF, 0x81 },
	0xF3F3,	{ 0xE7, 0xAF, 0x8C },
	0xF3F4,	{ 0xE7, 0xAF, 0x9D },
	0xF3F5,	{ 0xE7, 0xAF, 0x9A },
	0xF3F6,	{ 0xE7, 0xAF, 0xA5 },
	0xF3F7,	{ 0xE7, 0xAF, 0xA6 },
	0xF3F8,	{ 0xE7, 0xAF, 0xAA },
	0xF3F9,	{ 0xE7, 0xB0, 0x8C },
	0xF3FA,	{ 0xE7, 0xAF, 0xBE },
	0xF3FB,	{ 0xE7, 0xAF, 0xBC },
	0xF3FC,	{ 0xE7, 0xB0, 0x8F },
	0xF3FD,	{ 0xE7, 0xB0, 0x96 },
	0xF3FE,	{ 0xE7, 0xB0, 0x8B },
	0xF440,	{ 0xE9, 0xAC, 0x87 },
	0xF441,	{ 0xE9, 0xAC, 0x89 },
	0xF442,	{ 0xE9, 0xAC, 0x8A },
	0xF443,	{ 0xE9, 0xAC, 0x8B },
	0xF444,	{ 0xE9, 0xAC, 0x8C },
	0xF445,	{ 0xE9, 0xAC, 0x8D },
	0xF446,	{ 0xE9, 0xAC, 0x8E },
	0xF447,	{ 0xE9, 0xAC, 0x90 },
	0xF448,	{ 0xE9, 0xAC, 0x91 },
	0xF449,	{ 0xE9, 0xAC, 0x92 },
	0xF44A,	{ 0xE9, 0xAC, 0x94 },
	0xF44B,	{ 0xE9, 0xAC, 0x95 },
	0xF44C,	{ 0xE9, 0xAC, 0x96 },
	0xF44D,	{ 0xE9, 0xAC, 0x97 },
	0xF44E,	{ 0xE9, 0xAC, 0x98 },
	0xF44F,	{ 0xE9, 0xAC, 0x99 },
	0xF450,	{ 0xE9, 0xAC, 0x9A },
	0xF451,	{ 0xE9, 0xAC, 0x9B },
	0xF452,	{ 0xE9, 0xAC, 0x9C },
	0xF453,	{ 0xE9, 0xAC, 0x9D },
	0xF454,	{ 0xE9, 0xAC, 0x9E },
	0xF455,	{ 0xE9, 0xAC, 0xA0 },
	0xF456,	{ 0xE9, 0xAC, 0xA1 },
	0xF457,	{ 0xE9, 0xAC, 0xA2 },
	0xF458,	{ 0xE9, 0xAC, 0xA4 },
	0xF459,	{ 0xE9, 0xAC, 0xA5 },
	0xF45A,	{ 0xE9, 0xAC, 0xA6 },
	0xF45B,	{ 0xE9, 0xAC, 0xA7 },
	0xF45C,	{ 0xE9, 0xAC, 0xA8 },
	0xF45D,	{ 0xE9, 0xAC, 0xA9 },
	0xF45E,	{ 0xE9, 0xAC, 0xAA },
	0xF45F,	{ 0xE9, 0xAC, 0xAB },
	0xF460,	{ 0xE9, 0xAC, 0xAC },
	0xF461,	{ 0xE9, 0xAC, 0xAD },
	0xF462,	{ 0xE9, 0xAC, 0xAE },
	0xF463,	{ 0xE9, 0xAC, 0xB0 },
	0xF464,	{ 0xE9, 0xAC, 0xB1 },
	0xF465,	{ 0xE9, 0xAC, 0xB3 },
	0xF466,	{ 0xE9, 0xAC, 0xB4 },
	0xF467,	{ 0xE9, 0xAC, 0xB5 },
	0xF468,	{ 0xE9, 0xAC, 0xB6 },
	0xF469,	{ 0xE9, 0xAC, 0xB7 },
	0xF46A,	{ 0xE9, 0xAC, 0xB8 },
	0xF46B,	{ 0xE9, 0xAC, 0xB9 },
	0xF46C,	{ 0xE9, 0xAC, 0xBA },
	0xF46D,	{ 0xE9, 0xAC, 0xBD },
	0xF46E,	{ 0xE9, 0xAC, 0xBE },
	0xF46F,	{ 0xE9, 0xAC, 0xBF },
	0xF470,	{ 0xE9, 0xAD, 0x80 },
	0xF471,	{ 0xE9, 0xAD, 0x86 },
	0xF472,	{ 0xE9, 0xAD, 0x8A },
	0xF473,	{ 0xE9, 0xAD, 0x8B },
	0xF474,	{ 0xE9, 0xAD, 0x8C },
	0xF475,	{ 0xE9, 0xAD, 0x8E },
	0xF476,	{ 0xE9, 0xAD, 0x90 },
	0xF477,	{ 0xE9, 0xAD, 0x92 },
	0xF478,	{ 0xE9, 0xAD, 0x93 },
	0xF479,	{ 0xE9, 0xAD, 0x95 },
	0xF47A,	{ 0xE9, 0xAD, 0x96 },
	0xF47B,	{ 0xE9, 0xAD, 0x97 },
	0xF47C,	{ 0xE9, 0xAD, 0x98 },
	0xF47D,	{ 0xE9, 0xAD, 0x99 },
	0xF47E,	{ 0xE9, 0xAD, 0x9A },
	0xF480,	{ 0xE9, 0xAD, 0x9B },
	0xF481,	{ 0xE9, 0xAD, 0x9C },
	0xF482,	{ 0xE9, 0xAD, 0x9D },
	0xF483,	{ 0xE9, 0xAD, 0x9E },
	0xF484,	{ 0xE9, 0xAD, 0x9F },
	0xF485,	{ 0xE9, 0xAD, 0xA0 },
	0xF486,	{ 0xE9, 0xAD, 0xA1 },
	0xF487,	{ 0xE9, 0xAD, 0xA2 },
	0xF488,	{ 0xE9, 0xAD, 0xA3 },
	0xF489,	{ 0xE9, 0xAD, 0xA4 },
	0xF48A,	{ 0xE9, 0xAD, 0xA5 },
	0xF48B,	{ 0xE9, 0xAD, 0xA6 },
	0xF48C,	{ 0xE9, 0xAD, 0xA7 },
	0xF48D,	{ 0xE9, 0xAD, 0xA8 },
	0xF48E,	{ 0xE9, 0xAD, 0xA9 },
	0xF48F,	{ 0xE9, 0xAD, 0xAA },
	0xF490,	{ 0xE9, 0xAD, 0xAB },
	0xF491,	{ 0xE9, 0xAD, 0xAC },
	0xF492,	{ 0xE9, 0xAD, 0xAD },
	0xF493,	{ 0xE9, 0xAD, 0xAE },
	0xF494,	{ 0xE9, 0xAD, 0xAF },
	0xF495,	{ 0xE9, 0xAD, 0xB0 },
	0xF496,	{ 0xE9, 0xAD, 0xB1 },
	0xF497,	{ 0xE9, 0xAD, 0xB2 },
	0xF498,	{ 0xE9, 0xAD, 0xB3 },
	0xF499,	{ 0xE9, 0xAD, 0xB4 },
	0xF49A,	{ 0xE9, 0xAD, 0xB5 },
	0xF49B,	{ 0xE9, 0xAD, 0xB6 },
	0xF49C,	{ 0xE9, 0xAD, 0xB7 },
	0xF49D,	{ 0xE9, 0xAD, 0xB8 },
	0xF49E,	{ 0xE9, 0xAD, 0xB9 },
	0xF49F,	{ 0xE9, 0xAD, 0xBA },
	0xF4A0,	{ 0xE9, 0xAD, 0xBB },
	0xF4A1,	{ 0xE7, 0xB0, 0x9F },
	0xF4A2,	{ 0xE7, 0xB0, 0xAA },
	0xF4A3,	{ 0xE7, 0xB0, 0xA6 },
	0xF4A4,	{ 0xE7, 0xB0, 0xB8 },
	0xF4A5,	{ 0xE7, 0xB1, 0x81 },
	0xF4A6,	{ 0xE7, 0xB1, 0x80 },
	0xF4A7,	{ 0xE8, 0x87, 0xBE },
	0xF4A8,	{ 0xE8, 0x88, 0x81 },
	0xF4A9,	{ 0xE8, 0x88, 0x82 },
	0xF4AA,	{ 0xE8, 0x88, 0x84 },
	0xF4AB,	{ 0xE8, 0x87, 0xAC },
	0xF4AC,	{ 0xE8, 0xA1, 0x84 },
	0xF4AD,	{ 0xE8, 0x88, 0xA1 },
	0xF4AE,	{ 0xE8, 0x88, 0xA2 },
	0xF4AF,	{ 0xE8, 0x88, 0xA3 },
	0xF4B0,	{ 0xE8, 0x88, 0xAD },
	0xF4B1,	{ 0xE8, 0x88, 0xAF },
	0xF4B2,	{ 0xE8, 0x88, 0xA8 },
	0xF4B3,	{ 0xE8, 0x88, 0xAB },
	0xF4B4,	{ 0xE8, 0x88, 0xB8 },
	0xF4B5,	{ 0xE8, 0x88, 0xBB },
	0xF4B6,	{ 0xE8, 0x88, 0xB3 },
	0xF4B7,	{ 0xE8, 0x88, 0xB4 },
	0xF4B8,	{ 0xE8, 0x88, 0xBE },
	0xF4B9,	{ 0xE8, 0x89, 0x84 },
	0xF4BA,	{ 0xE8, 0x89, 0x89 },
	0xF4BB,	{ 0xE8, 0x89, 0x8B },
	0xF4BC,	{ 0xE8, 0x89, 0x8F },
	0xF4BD,	{ 0xE8, 0x89, 0x9A },
	0xF4BE,	{ 0xE8, 0x89, 0x9F },
	0xF4BF,	{ 0xE8, 0x89, 0xA8 },
	0xF4C0,	{ 0xE8, 0xA1, 0xBE },
	0xF4C1,	{ 0xE8, 0xA2, 0x85 },
	0xF4C2,	{ 0xE8, 0xA2, 0x88 },
	0xF4C3,	{ 0xE8, 0xA3, 0x98 },
	0xF4C4,	{ 0xE8, 0xA3, 0x9F },
	0xF4C5,	{ 0xE8, 0xA5, 0x9E },
	0xF4C6,	{ 0xE7, 0xBE, 0x9D },
	0xF4C7,	{ 0xE7, 0xBE, 0x9F },
	0xF4C8,	{ 0xE7, 0xBE, 0xA7 },
	0xF4C9,	{ 0xE7, 0xBE, 0xAF },
	0xF4CA,	{ 0xE7, 0xBE, 0xB0 },
	0xF4CB,	{ 0xE7, 0xBE, 0xB2 },
	0xF4CC,	{ 0xE7, 0xB1, 0xBC },
	0xF4CD,	{ 0xE6, 0x95, 0x89 },
	0xF4CE,	{ 0xE7, 0xB2, 0x91 },
	0xF4CF,	{ 0xE7, 0xB2, 0x9D },
	0xF4D0,	{ 0xE7, 0xB2, 0x9C },
	0xF4D1,	{ 0xE7, 0xB2, 0x9E },
	0xF4D2,	{ 0xE7, 0xB2, 0xA2 },
	0xF4D3,	{ 0xE7, 0xB2, 0xB2 },
	0xF4D4,	{ 0xE7, 0xB2, 0xBC },
	0xF4D5,	{ 0xE7, 0xB2, 0xBD },
	0xF4D6,	{ 0xE7, 0xB3, 0x81 },
	0xF4D7,	{ 0xE7, 0xB3, 0x87 },
	0xF4D8,	{ 0xE7, 0xB3, 0x8C },
	0xF4D9,	{ 0xE7, 0xB3, 0x8D },
	0xF4DA,	{ 0xE7, 0xB3, 0x88 },
	0xF4DB,	{ 0xE7, 0xB3, 0x85 },
	0xF4DC,	{ 0xE7, 0xB3, 0x97 },
	0xF4DD,	{ 0xE7, 0xB3, 0xA8 },
	0xF4DE,	{ 0xE8, 0x89, 0xAE },
	0xF4DF,	{ 0xE6, 0x9A, 0xA8 },
	0xF4E0,	{ 0xE7, 0xBE, 0xBF },
	0xF4E1,	{ 0xE7, 0xBF, 0x8E },
	0xF4E2,	{ 0xE7, 0xBF, 0x95 },
	0xF4E3,	{ 0xE7, 0xBF, 0xA5 },
	0xF4E4,	{ 0xE7, 0xBF, 0xA1 },
	0xF4E5,	{ 0xE7, 0xBF, 0xA6 },
	0xF4E6,	{ 0xE7, 0xBF, 0xA9 },
	0xF4E7,	{ 0xE7, 0xBF, 0xAE },
	0xF4E8,	{ 0xE7, 0xBF, 0xB3 },
	0xF4E9,	{ 0xE7, 0xB3, 0xB8 },
	0xF4EA,	{ 0xE7, 0xB5, 0xB7 },
	0xF4EB,	{ 0xE7, 0xB6, 0xA6 },
	0xF4EC,	{ 0xE7, 0xB6, 0xAE },
	0xF4ED,	{ 0xE7, 0xB9, 0x87 },
	0xF4EE,	{ 0xE7, 0xBA, 0x9B },
	0xF4EF,	{ 0xE9, 0xBA, 0xB8 },
	0xF4F0,	{ 0xE9, 0xBA, 0xB4 },
	0xF4F1,	{ 0xE8, 0xB5, 0xB3 },
	0xF4F2,	{ 0xE8, 0xB6, 0x84 },
	0xF4F3,	{ 0xE8, 0xB6, 0x94 },
	0xF4F4,	{ 0xE8, 0xB6, 0x91 },
	0xF4F5,	{ 0xE8, 0xB6, 0xB1 },
	0xF4F6,	{ 0xE8, 0xB5, 0xA7 },
	0xF4F7,	{ 0xE8, 0xB5, 0xAD },
	0xF4F8,	{ 0xE8, 0xB1, 0x87 },
	0xF4F9,	{ 0xE8, 0xB1, 0x89 },
	0xF4FA,	{ 0xE9, 0x85, 0x8A },
	0xF4FB,	{ 0xE9, 0x85, 0x90 },
	0xF4FC,	{ 0xE9, 0x85, 0x8E },
	0xF4FD,	{ 0xE9, 0x85, 0x8F },
	0xF4FE,	{ 0xE9, 0x85, 0xA4 },
	0xF540,	{ 0xE9, 0xAD, 0xBC },
	0xF541,	{ 0xE9, 0xAD, 0xBD },
	0xF542,	{ 0xE9, 0xAD, 0xBE },
	0xF543,	{ 0xE9, 0xAD, 0xBF },
	0xF544,	{ 0xE9, 0xAE, 0x80 },
	0xF545,	{ 0xE9, 0xAE, 0x81 },
	0xF546,	{ 0xE9, 0xAE, 0x82 },
	0xF547,	{ 0xE9, 0xAE, 0x83 },
	0xF548,	{ 0xE9, 0xAE, 0x84 },
	0xF549,	{ 0xE9, 0xAE, 0x85 },
	0xF54A,	{ 0xE9, 0xAE, 0x86 },
	0xF54B,	{ 0xE9, 0xAE, 0x87 },
	0xF54C,	{ 0xE9, 0xAE, 0x88 },
	0xF54D,	{ 0xE9, 0xAE, 0x89 },
	0xF54E,	{ 0xE9, 0xAE, 0x8A },
	0xF54F,	{ 0xE9, 0xAE, 0x8B },
	0xF550,	{ 0xE9, 0xAE, 0x8C },
	0xF551,	{ 0xE9, 0xAE, 0x8D },
	0xF552,	{ 0xE9, 0xAE, 0x8E },
	0xF553,	{ 0xE9, 0xAE, 0x8F },
	0xF554,	{ 0xE9, 0xAE, 0x90 },
	0xF555,	{ 0xE9, 0xAE, 0x91 },
	0xF556,	{ 0xE9, 0xAE, 0x92 },
	0xF557,	{ 0xE9, 0xAE, 0x93 },
	0xF558,	{ 0xE9, 0xAE, 0x94 },
	0xF559,	{ 0xE9, 0xAE, 0x95 },
	0xF55A,	{ 0xE9, 0xAE, 0x96 },
	0xF55B,	{ 0xE9, 0xAE, 0x97 },
	0xF55C,	{ 0xE9, 0xAE, 0x98 },
	0xF55D,	{ 0xE9, 0xAE, 0x99 },
	0xF55E,	{ 0xE9, 0xAE, 0x9A },
	0xF55F,	{ 0xE9, 0xAE, 0x9B },
	0xF560,	{ 0xE9, 0xAE, 0x9C },
	0xF561,	{ 0xE9, 0xAE, 0x9D },
	0xF562,	{ 0xE9, 0xAE, 0x9E },
	0xF563,	{ 0xE9, 0xAE, 0x9F },
	0xF564,	{ 0xE9, 0xAE, 0xA0 },
	0xF565,	{ 0xE9, 0xAE, 0xA1 },
	0xF566,	{ 0xE9, 0xAE, 0xA2 },
	0xF567,	{ 0xE9, 0xAE, 0xA3 },
	0xF568,	{ 0xE9, 0xAE, 0xA4 },
	0xF569,	{ 0xE9, 0xAE, 0xA5 },
	0xF56A,	{ 0xE9, 0xAE, 0xA6 },
	0xF56B,	{ 0xE9, 0xAE, 0xA7 },
	0xF56C,	{ 0xE9, 0xAE, 0xA8 },
	0xF56D,	{ 0xE9, 0xAE, 0xA9 },
	0xF56E,	{ 0xE9, 0xAE, 0xAA },
	0xF56F,	{ 0xE9, 0xAE, 0xAB },
	0xF570,	{ 0xE9, 0xAE, 0xAC },
	0xF571,	{ 0xE9, 0xAE, 0xAD },
	0xF572,	{ 0xE9, 0xAE, 0xAE },
	0xF573,	{ 0xE9, 0xAE, 0xAF },
	0xF574,	{ 0xE9, 0xAE, 0xB0 },
	0xF575,	{ 0xE9, 0xAE, 0xB1 },
	0xF576,	{ 0xE9, 0xAE, 0xB2 },
	0xF577,	{ 0xE9, 0xAE, 0xB3 },
	0xF578,	{ 0xE9, 0xAE, 0xB4 },
	0xF579,	{ 0xE9, 0xAE, 0xB5 },
	0xF57A,	{ 0xE9, 0xAE, 0xB6 },
	0xF57B,	{ 0xE9, 0xAE, 0xB7 },
	0xF57C,	{ 0xE9, 0xAE, 0xB8 },
	0xF57D,	{ 0xE9, 0xAE, 0xB9 },
	0xF57E,	{ 0xE9, 0xAE, 0xBA },
	0xF580,	{ 0xE9, 0xAE, 0xBB },
	0xF581,	{ 0xE9, 0xAE, 0xBC },
	0xF582,	{ 0xE9, 0xAE, 0xBD },
	0xF583,	{ 0xE9, 0xAE, 0xBE },
	0xF584,	{ 0xE9, 0xAE, 0xBF },
	0xF585,	{ 0xE9, 0xAF, 0x80 },
	0xF586,	{ 0xE9, 0xAF, 0x81 },
	0xF587,	{ 0xE9, 0xAF, 0x82 },
	0xF588,	{ 0xE9, 0xAF, 0x83 },
	0xF589,	{ 0xE9, 0xAF, 0x84 },
	0xF58A,	{ 0xE9, 0xAF, 0x85 },
	0xF58B,	{ 0xE9, 0xAF, 0x86 },
	0xF58C,	{ 0xE9, 0xAF, 0x87 },
	0xF58D,	{ 0xE9, 0xAF, 0x88 },
	0xF58E,	{ 0xE9, 0xAF, 0x89 },
	0xF58F,	{ 0xE9, 0xAF, 0x8A },
	0xF590,	{ 0xE9, 0xAF, 0x8B },
	0xF591,	{ 0xE9, 0xAF, 0x8C },
	0xF592,	{ 0xE9, 0xAF, 0x8D },
	0xF593,	{ 0xE9, 0xAF, 0x8E },
	0xF594,	{ 0xE9, 0xAF, 0x8F },
	0xF595,	{ 0xE9, 0xAF, 0x90 },
	0xF596,	{ 0xE9, 0xAF, 0x91 },
	0xF597,	{ 0xE9, 0xAF, 0x92 },
	0xF598,	{ 0xE9, 0xAF, 0x93 },
	0xF599,	{ 0xE9, 0xAF, 0x94 },
	0xF59A,	{ 0xE9, 0xAF, 0x95 },
	0xF59B,	{ 0xE9, 0xAF, 0x96 },
	0xF59C,	{ 0xE9, 0xAF, 0x97 },
	0xF59D,	{ 0xE9, 0xAF, 0x98 },
	0xF59E,	{ 0xE9, 0xAF, 0x99 },
	0xF59F,	{ 0xE9, 0xAF, 0x9A },
	0xF5A0,	{ 0xE9, 0xAF, 0x9B },
	0xF5A1,	{ 0xE9, 0x85, 0xA2 },
	0xF5A2,	{ 0xE9, 0x85, 0xA1 },
	0xF5A3,	{ 0xE9, 0x85, 0xB0 },
	0xF5A4,	{ 0xE9, 0x85, 0xA9 },
	0xF5A5,	{ 0xE9, 0x85, 0xAF },
	0xF5A6,	{ 0xE9, 0x85, 0xBD },
	0xF5A7,	{ 0xE9, 0x85, 0xBE },
	0xF5A8,	{ 0xE9, 0x85, 0xB2 },
	0xF5A9,	{ 0xE9, 0x85, 0xB4 },
	0xF5AA,	{ 0xE9, 0x85, 0xB9 },
	0xF5AB,	{ 0xE9, 0x86, 0x8C },
	0xF5AC,	{ 0xE9, 0x86, 0x85 },
	0xF5AD,	{ 0xE9, 0x86, 0x90 },
	0xF5AE,	{ 0xE9, 0x86, 0x8D },
	0xF5AF,	{ 0xE9, 0x86, 0x91 },
	0xF5B0,	{ 0xE9, 0x86, 0xA2 },
	0xF5B1,	{ 0xE9, 0x86, 0xA3 },
	0xF5B2,	{ 0xE9, 0x86, 0xAA },
	0xF5B3,	{ 0xE9, 0x86, 0xAD },
	0xF5B4,	{ 0xE9, 0x86, 0xAE },
	0xF5B5,	{ 0xE9, 0x86, 0xAF },
	0xF5B6,	{ 0xE9, 0x86, 0xB5 },
	0xF5B7,	{ 0xE9, 0x86, 0xB4 },
	0xF5B8,	{ 0xE9, 0x86, 0xBA },
	0xF5B9,	{ 0xE8, 0xB1, 0x95 },
	0xF5BA,	{ 0xE9, 0xB9, 0xBE },
	0xF5BB,	{ 0xE8, 0xB6, 0xB8 },
	0xF5BC,	{ 0xE8, 0xB7, 0xAB },
	0xF5BD,	{ 0xE8, 0xB8, 0x85 },
	0xF5BE,	{ 0xE8, 0xB9, 0x99 },
	0xF5BF,	{ 0xE8, 0xB9, 0xA9 },
	0xF5C0,	{ 0xE8, 0xB6, 0xB5 },
	0xF5C1,	{ 0xE8, 0xB6, 0xBF },
	0xF5C2,	{ 0xE8, 0xB6, 0xBC },
	0xF5C3,	{ 0xE8, 0xB6, 0xBA },
	0xF5C4,	{ 0xE8, 0xB7, 0x84 },
	0xF5C5,	{ 0xE8, 0xB7, 0x96 },
	0xF5C6,	{ 0xE8, 0xB7, 0x97 },
	0xF5C7,	{ 0xE8, 0xB7, 0x9A },
	0xF5C8,	{ 0xE8, 0xB7, 0x9E },
	0xF5C9,	{ 0xE8, 0xB7, 0x8E },
	0xF5CA,	{ 0xE8, 0xB7, 0x8F },
	0xF5CB,	{ 0xE8, 0xB7, 0x9B },
	0xF5CC,	{ 0xE8, 0xB7, 0x86 },
	0xF5CD,	{ 0xE8, 0xB7, 0xAC },
	0xF5CE,	{ 0xE8, 0xB7, 0xB7 },
	0xF5CF,	{ 0xE8, 0xB7, 0xB8 },
	0xF5D0,	{ 0xE8, 0xB7, 0xA3 },
	0xF5D1,	{ 0xE8, 0xB7, 0xB9 },
	0xF5D2,	{ 0xE8, 0xB7, 0xBB },
	0xF5D3,	{ 0xE8, 0xB7, 0xA4 },
	0xF5D4,	{ 0xE8, 0xB8, 0x89 },
	0xF5D5,	{ 0xE8, 0xB7, 0xBD },
	0xF5D6,	{ 0xE8, 0xB8, 0x94 },
	0xF5D7,	{ 0xE8, 0xB8, 0x9D },
	0xF5D8,	{ 0xE8, 0xB8, 0x9F },
	0xF5D9,	{ 0xE8, 0xB8, 0xAC },
	0xF5DA,	{ 0xE8, 0xB8, 0xAE },
	0xF5DB,	{ 0xE8, 0xB8, 0xA3 },
	0xF5DC,	{ 0xE8, 0xB8, 0xAF },
	0xF5DD,	{ 0xE8, 0xB8, 0xBA },
	0xF5DE,	{ 0xE8, 0xB9, 0x80 },
	0xF5DF,	{ 0xE8, 0xB8, 0xB9 },
	0xF5E0,	{ 0xE8, 0xB8, 0xB5 },
	0xF5E1,	{ 0xE8, 0xB8, 0xBD },
	0xF5E2,	{ 0xE8, 0xB8, 0xB1 },
	0xF5E3,	{ 0xE8, 0xB9, 0x89 },
	0xF5E4,	{ 0xE8, 0xB9, 0x81 },
	0xF5E5,	{ 0xE8, 0xB9, 0x82 },
	0xF5E6,	{ 0xE8, 0xB9, 0x91 },
	0xF5E7,	{ 0xE8, 0xB9, 0x92 },
	0xF5E8,	{ 0xE8, 0xB9, 0x8A },
	0xF5E9,	{ 0xE8, 0xB9, 0xB0 },
	0xF5EA,	{ 0xE8, 0xB9, 0xB6 },
	0xF5EB,	{ 0xE8, 0xB9, 0xBC },
	0xF5EC,	{ 0xE8, 0xB9, 0xAF },
	0xF5ED,	{ 0xE8, 0xB9, 0xB4 },
	0xF5EE,	{ 0xE8, 0xBA, 0x85 },
	0xF5EF,	{ 0xE8, 0xBA, 0x8F },
	0xF5F0,	{ 0xE8, 0xBA, 0x94 },
	0xF5F1,	{ 0xE8, 0xBA, 0x90 },
	0xF5F2,	{ 0xE8, 0xBA, 0x9C },
	0xF5F3,	{ 0xE8, 0xBA, 0x9E },
	0xF5F4,	{ 0xE8, 0xB1, 0xB8 },
	0xF5F5,	{ 0xE8, 0xB2, 0x82 },
	0xF5F6,	{ 0xE8, 0xB2, 0x8A },
	0xF5F7,	{ 0xE8, 0xB2, 0x85 },
	0xF5F8,	{ 0xE8, 0xB2, 0x98 },
	0xF5F9,	{ 0xE8, 0xB2, 0x94 },
	0xF5FA,	{ 0xE6, 0x96, 0x9B },
	0xF5FB,	{ 0xE8, 0xA7, 0x96 },
	0xF5FC,	{ 0xE8, 0xA7, 0x9E },
	0xF5FD,	{ 0xE8, 0xA7, 0x9A },
	0xF5FE,	{ 0xE8, 0xA7, 0x9C },
	0xF640,	{ 0xE9, 0xAF, 0x9C },
	0xF641,	{ 0xE9, 0xAF, 0x9D },
	0xF642,	{ 0xE9, 0xAF, 0x9E },
	0xF643,	{ 0xE9, 0xAF, 0x9F },
	0xF644,	{ 0xE9, 0xAF, 0xA0 },
	0xF645,	{ 0xE9, 0xAF, 0xA1 },
	0xF646,	{ 0xE9, 0xAF, 0xA2 },
	0xF647,	{ 0xE9, 0xAF, 0xA3 },
	0xF648,	{ 0xE9, 0xAF, 0xA4 },
	0xF649,	{ 0xE9, 0xAF, 0xA5 },
	0xF64A,	{ 0xE9, 0xAF, 0xA6 },
	0xF64B,	{ 0xE9, 0xAF, 0xA7 },
	0xF64C,	{ 0xE9, 0xAF, 0xA8 },
	0xF64D,	{ 0xE9, 0xAF, 0xA9 },
	0xF64E,	{ 0xE9, 0xAF, 0xAA },
	0xF64F,	{ 0xE9, 0xAF, 0xAB },
	0xF650,	{ 0xE9, 0xAF, 0xAC },
	0xF651,	{ 0xE9, 0xAF, 0xAD },
	0xF652,	{ 0xE9, 0xAF, 0xAE },
	0xF653,	{ 0xE9, 0xAF, 0xAF },
	0xF654,	{ 0xE9, 0xAF, 0xB0 },
	0xF655,	{ 0xE9, 0xAF, 0xB1 },
	0xF656,	{ 0xE9, 0xAF, 0xB2 },
	0xF657,	{ 0xE9, 0xAF, 0xB3 },
	0xF658,	{ 0xE9, 0xAF, 0xB4 },
	0xF659,	{ 0xE9, 0xAF, 0xB5 },
	0xF65A,	{ 0xE9, 0xAF, 0xB6 },
	0xF65B,	{ 0xE9, 0xAF, 0xB7 },
	0xF65C,	{ 0xE9, 0xAF, 0xB8 },
	0xF65D,	{ 0xE9, 0xAF, 0xB9 },
	0xF65E,	{ 0xE9, 0xAF, 0xBA },
	0xF65F,	{ 0xE9, 0xAF, 0xBB },
	0xF660,	{ 0xE9, 0xAF, 0xBC },
	0xF661,	{ 0xE9, 0xAF, 0xBD },
	0xF662,	{ 0xE9, 0xAF, 0xBE },
	0xF663,	{ 0xE9, 0xAF, 0xBF },
	0xF664,	{ 0xE9, 0xB0, 0x80 },
	0xF665,	{ 0xE9, 0xB0, 0x81 },
	0xF666,	{ 0xE9, 0xB0, 0x82 },
	0xF667,	{ 0xE9, 0xB0, 0x83 },
	0xF668,	{ 0xE9, 0xB0, 0x84 },
	0xF669,	{ 0xE9, 0xB0, 0x85 },
	0xF66A,	{ 0xE9, 0xB0, 0x86 },
	0xF66B,	{ 0xE9, 0xB0, 0x87 },
	0xF66C,	{ 0xE9, 0xB0, 0x88 },
	0xF66D,	{ 0xE9, 0xB0, 0x89 },
	0xF66E,	{ 0xE9, 0xB0, 0x8A },
	0xF66F,	{ 0xE9, 0xB0, 0x8B },
	0xF670,	{ 0xE9, 0xB0, 0x8C },
	0xF671,	{ 0xE9, 0xB0, 0x8D },
	0xF672,	{ 0xE9, 0xB0, 0x8E },
	0xF673,	{ 0xE9, 0xB0, 0x8F },
	0xF674,	{ 0xE9, 0xB0, 0x90 },
	0xF675,	{ 0xE9, 0xB0, 0x91 },
	0xF676,	{ 0xE9, 0xB0, 0x92 },
	0xF677,	{ 0xE9, 0xB0, 0x93 },
	0xF678,	{ 0xE9, 0xB0, 0x94 },
	0xF679,	{ 0xE9, 0xB0, 0x95 },
	0xF67A,	{ 0xE9, 0xB0, 0x96 },
	0xF67B,	{ 0xE9, 0xB0, 0x97 },
	0xF67C,	{ 0xE9, 0xB0, 0x98 },
	0xF67D,	{ 0xE9, 0xB0, 0x99 },
	0xF67E,	{ 0xE9, 0xB0, 0x9A },
	0xF680,	{ 0xE9, 0xB0, 0x9B },
	0xF681,	{ 0xE9, 0xB0, 0x9C },
	0xF682,	{ 0xE9, 0xB0, 0x9D },
	0xF683,	{ 0xE9, 0xB0, 0x9E },
	0xF684,	{ 0xE9, 0xB0, 0x9F },
	0xF685,	{ 0xE9, 0xB0, 0xA0 },
	0xF686,	{ 0xE9, 0xB0, 0xA1 },
	0xF687,	{ 0xE9, 0xB0, 0xA2 },
	0xF688,	{ 0xE9, 0xB0, 0xA3 },
	0xF689,	{ 0xE9, 0xB0, 0xA4 },
	0xF68A,	{ 0xE9, 0xB0, 0xA5 },
	0xF68B,	{ 0xE9, 0xB0, 0xA6 },
	0xF68C,	{ 0xE9, 0xB0, 0xA7 },
	0xF68D,	{ 0xE9, 0xB0, 0xA8 },
	0xF68E,	{ 0xE9, 0xB0, 0xA9 },
	0xF68F,	{ 0xE9, 0xB0, 0xAA },
	0xF690,	{ 0xE9, 0xB0, 0xAB },
	0xF691,	{ 0xE9, 0xB0, 0xAC },
	0xF692,	{ 0xE9, 0xB0, 0xAD },
	0xF693,	{ 0xE9, 0xB0, 0xAE },
	0xF694,	{ 0xE9, 0xB0, 0xAF },
	0xF695,	{ 0xE9, 0xB0, 0xB0 },
	0xF696,	{ 0xE9, 0xB0, 0xB1 },
	0xF697,	{ 0xE9, 0xB0, 0xB2 },
	0xF698,	{ 0xE9, 0xB0, 0xB3 },
	0xF699,	{ 0xE9, 0xB0, 0xB4 },
	0xF69A,	{ 0xE9, 0xB0, 0xB5 },
	0xF69B,	{ 0xE9, 0xB0, 0xB6 },
	0xF69C,	{ 0xE9, 0xB0, 0xB7 },
	0xF69D,	{ 0xE9, 0xB0, 0xB8 },
	0xF69E,	{ 0xE9, 0xB0, 0xB9 },
	0xF69F,	{ 0xE9, 0xB0, 0xBA },
	0xF6A0,	{ 0xE9, 0xB0, 0xBB },
	0xF6A1,	{ 0xE8, 0xA7, 0xA5 },
	0xF6A2,	{ 0xE8, 0xA7, 0xAB },
	0xF6A3,	{ 0xE8, 0xA7, 0xAF },
	0xF6A4,	{ 0xE8, 0xA8, 0xBE },
	0xF6A5,	{ 0xE8, 0xAC, 0xA6 },
	0xF6A6,	{ 0xE9, 0x9D, 0x93 },
	0xF6A7,	{ 0xE9, 0x9B, 0xA9 },
	0xF6A8,	{ 0xE9, 0x9B, 0xB3 },
	0xF6A9,	{ 0xE9, 0x9B, 0xAF },
	0xF6AA,	{ 0xE9, 0x9C, 0x86 },
	0xF6AB,	{ 0xE9, 0x9C, 0x81 },
	0xF6AC,	{ 0xE9, 0x9C, 0x88 },
	0xF6AD,	{ 0xE9, 0x9C, 0x8F },
	0xF6AE,	{ 0xE9, 0x9C, 0x8E },
	0xF6AF,	{ 0xE9, 0x9C, 0xAA },
	0xF6B0,	{ 0xE9, 0x9C, 0xAD },
	0xF6B1,	{ 0xE9, 0x9C, 0xB0 },
	0xF6B2,	{ 0xE9, 0x9C, 0xBE },
	0xF6B3,	{ 0xE9, 0xBE, 0x80 },
	0xF6B4,	{ 0xE9, 0xBE, 0x83 },
	0xF6B5,	{ 0xE9, 0xBE, 0x85 },
	0xF6B6,	{ 0xE9, 0xBE, 0x86 },
	0xF6B7,	{ 0xE9, 0xBE, 0x87 },
	0xF6B8,	{ 0xE9, 0xBE, 0x88 },
	0xF6B9,	{ 0xE9, 0xBE, 0x89 },
	0xF6BA,	{ 0xE9, 0xBE, 0x8A },
	0xF6BB,	{ 0xE9, 0xBE, 0x8C },
	0xF6BC,	{ 0xE9, 0xBB, 0xBE },
	0xF6BD,	{ 0xE9, 0xBC, 0x8B },
	0xF6BE,	{ 0xE9, 0xBC, 0x8D },
	0xF6BF,	{ 0xE9, 0x9A, 0xB9 },
	0xF6C0,	{ 0xE9, 0x9A, 0xBC },
	0xF6C1,	{ 0xE9, 0x9A, 0xBD },
	0xF6C2,	{ 0xE9, 0x9B, 0x8E },
	0xF6C3,	{ 0xE9, 0x9B, 0x92 },
	0xF6C4,	{ 0xE7, 0x9E, 0xBF },
	0xF6C5,	{ 0xE9, 0x9B, 0xA0 },
	0xF6C6,	{ 0xE9, 0x8A, 0x8E },
	0xF6C7,	{ 0xE9, 0x8A, 0xAE },
	0xF6C8,	{ 0xE9, 0x8B, 0x88 },
	0xF6C9,	{ 0xE9, 0x8C, 0xBE },
	0xF6CA,	{ 0xE9, 0x8D, 0xAA },
	0xF6CB,	{ 0xE9, 0x8F, 0x8A },
	0xF6CC,	{ 0xE9, 0x8E, 0x8F },
	0xF6CD,	{ 0xE9, 0x90, 0xBE },
	0xF6CE,	{ 0xE9, 0x91, 0xAB },
	0xF6CF,	{ 0xE9, 0xB1, 0xBF },
	0xF6D0,	{ 0xE9, 0xB2, 0x82 },
	0xF6D1,	{ 0xE9, 0xB2, 0x85 },
	0xF6D2,	{ 0xE9, 0xB2, 0x86 },
	0xF6D3,	{ 0xE9, 0xB2, 0x87 },
	0xF6D4,	{ 0xE9, 0xB2, 0x88 },
	0xF6D5,	{ 0xE7, 0xA8, 0xA3 },
	0xF6D6,	{ 0xE9, 0xB2, 0x8B },
	0xF6D7,	{ 0xE9, 0xB2, 0x8E },
	0xF6D8,	{ 0xE9, 0xB2, 0x90 },
	0xF6D9,	{ 0xE9, 0xB2, 0x91 },
	0xF6DA,	{ 0xE9, 0xB2, 0x92 },
	0xF6DB,	{ 0xE9, 0xB2, 0x94 },
	0xF6DC,	{ 0xE9, 0xB2, 0x95 },
	0xF6DD,	{ 0xE9, 0xB2, 0x9A },
	0xF6DE,	{ 0xE9, 0xB2, 0x9B },
	0xF6DF,	{ 0xE9, 0xB2, 0x9E },
	0xF6E0,	{ 0xE9, 0xB2, 0x9F },
	0xF6E1,	{ 0xE9, 0xB2, 0xA0 },
	0xF6E2,	{ 0xE9, 0xB2, 0xA1 },
	0xF6E3,	{ 0xE9, 0xB2, 0xA2 },
	0xF6E4,	{ 0xE9, 0xB2, 0xA3 },
	0xF6E5,	{ 0xE9, 0xB2, 0xA5 },
	0xF6E6,	{ 0xE9, 0xB2, 0xA6 },
	0xF6E7,	{ 0xE9, 0xB2, 0xA7 },
	0xF6E8,	{ 0xE9, 0xB2, 0xA8 },
	0xF6E9,	{ 0xE9, 0xB2, 0xA9 },
	0xF6EA,	{ 0xE9, 0xB2, 0xAB },
	0xF6EB,	{ 0xE9, 0xB2, 0xAD },
	0xF6EC,	{ 0xE9, 0xB2, 0xAE },
	0xF6ED,	{ 0xE9, 0xB2, 0xB0 },
	0xF6EE,	{ 0xE9, 0xB2, 0xB1 },
	0xF6EF,	{ 0xE9, 0xB2, 0xB2 },
	0xF6F0,	{ 0xE9, 0xB2, 0xB3 },
	0xF6F1,	{ 0xE9, 0xB2, 0xB4 },
	0xF6F2,	{ 0xE9, 0xB2, 0xB5 },
	0xF6F3,	{ 0xE9, 0xB2, 0xB6 },
	0xF6F4,	{ 0xE9, 0xB2, 0xB7 },
	0xF6F5,	{ 0xE9, 0xB2, 0xBA },
	0xF6F6,	{ 0xE9, 0xB2, 0xBB },
	0xF6F7,	{ 0xE9, 0xB2, 0xBC },
	0xF6F8,	{ 0xE9, 0xB2, 0xBD },
	0xF6F9,	{ 0xE9, 0xB3, 0x84 },
	0xF6FA,	{ 0xE9, 0xB3, 0x85 },
	0xF6FB,	{ 0xE9, 0xB3, 0x86 },
	0xF6FC,	{ 0xE9, 0xB3, 0x87 },
	0xF6FD,	{ 0xE9, 0xB3, 0x8A },
	0xF6FE,	{ 0xE9, 0xB3, 0x8B },
	0xF740,	{ 0xE9, 0xB0, 0xBC },
	0xF741,	{ 0xE9, 0xB0, 0xBD },
	0xF742,	{ 0xE9, 0xB0, 0xBE },
	0xF743,	{ 0xE9, 0xB0, 0xBF },
	0xF744,	{ 0xE9, 0xB1, 0x80 },
	0xF745,	{ 0xE9, 0xB1, 0x81 },
	0xF746,	{ 0xE9, 0xB1, 0x82 },
	0xF747,	{ 0xE9, 0xB1, 0x83 },
	0xF748,	{ 0xE9, 0xB1, 0x84 },
	0xF749,	{ 0xE9, 0xB1, 0x85 },
	0xF74A,	{ 0xE9, 0xB1, 0x86 },
	0xF74B,	{ 0xE9, 0xB1, 0x87 },
	0xF74C,	{ 0xE9, 0xB1, 0x88 },
	0xF74D,	{ 0xE9, 0xB1, 0x89 },
	0xF74E,	{ 0xE9, 0xB1, 0x8A },
	0xF74F,	{ 0xE9, 0xB1, 0x8B },
	0xF750,	{ 0xE9, 0xB1, 0x8C },
	0xF751,	{ 0xE9, 0xB1, 0x8D },
	0xF752,	{ 0xE9, 0xB1, 0x8E },
	0xF753,	{ 0xE9, 0xB1, 0x8F },
	0xF754,	{ 0xE9, 0xB1, 0x90 },
	0xF755,	{ 0xE9, 0xB1, 0x91 },
	0xF756,	{ 0xE9, 0xB1, 0x92 },
	0xF757,	{ 0xE9, 0xB1, 0x93 },
	0xF758,	{ 0xE9, 0xB1, 0x94 },
	0xF759,	{ 0xE9, 0xB1, 0x95 },
	0xF75A,	{ 0xE9, 0xB1, 0x96 },
	0xF75B,	{ 0xE9, 0xB1, 0x97 },
	0xF75C,	{ 0xE9, 0xB1, 0x98 },
	0xF75D,	{ 0xE9, 0xB1, 0x99 },
	0xF75E,	{ 0xE9, 0xB1, 0x9A },
	0xF75F,	{ 0xE9, 0xB1, 0x9B },
	0xF760,	{ 0xE9, 0xB1, 0x9C },
	0xF761,	{ 0xE9, 0xB1, 0x9D },
	0xF762,	{ 0xE9, 0xB1, 0x9E },
	0xF763,	{ 0xE9, 0xB1, 0x9F },
	0xF764,	{ 0xE9, 0xB1, 0xA0 },
	0xF765,	{ 0xE9, 0xB1, 0xA1 },
	0xF766,	{ 0xE9, 0xB1, 0xA2 },
	0xF767,	{ 0xE9, 0xB1, 0xA3 },
	0xF768,	{ 0xE9, 0xB1, 0xA4 },
	0xF769,	{ 0xE9, 0xB1, 0xA5 },
	0xF76A,	{ 0xE9, 0xB1, 0xA6 },
	0xF76B,	{ 0xE9, 0xB1, 0xA7 },
	0xF76C,	{ 0xE9, 0xB1, 0xA8 },
	0xF76D,	{ 0xE9, 0xB1, 0xA9 },
	0xF76E,	{ 0xE9, 0xB1, 0xAA },
	0xF76F,	{ 0xE9, 0xB1, 0xAB },
	0xF770,	{ 0xE9, 0xB1, 0xAC },
	0xF771,	{ 0xE9, 0xB1, 0xAD },
	0xF772,	{ 0xE9, 0xB1, 0xAE },
	0xF773,	{ 0xE9, 0xB1, 0xAF },
	0xF774,	{ 0xE9, 0xB1, 0xB0 },
	0xF775,	{ 0xE9, 0xB1, 0xB1 },
	0xF776,	{ 0xE9, 0xB1, 0xB2 },
	0xF777,	{ 0xE9, 0xB1, 0xB3 },
	0xF778,	{ 0xE9, 0xB1, 0xB4 },
	0xF779,	{ 0xE9, 0xB1, 0xB5 },
	0xF77A,	{ 0xE9, 0xB1, 0xB6 },
	0xF77B,	{ 0xE9, 0xB1, 0xB7 },
	0xF77C,	{ 0xE9, 0xB1, 0xB8 },
	0xF77D,	{ 0xE9, 0xB1, 0xB9 },
	0xF77E,	{ 0xE9, 0xB1, 0xBA },
	0xF780,	{ 0xE9, 0xB1, 0xBB },
	0xF781,	{ 0xE9, 0xB1, 0xBD },
	0xF782,	{ 0xE9, 0xB1, 0xBE },
	0xF783,	{ 0xE9, 0xB2, 0x80 },
	0xF784,	{ 0xE9, 0xB2, 0x83 },
	0xF785,	{ 0xE9, 0xB2, 0x84 },
	0xF786,	{ 0xE9, 0xB2, 0x89 },
	0xF787,	{ 0xE9, 0xB2, 0x8A },
	0xF788,	{ 0xE9, 0xB2, 0x8C },
	0xF789,	{ 0xE9, 0xB2, 0x8F },
	0xF78A,	{ 0xE9, 0xB2, 0x93 },
	0xF78B,	{ 0xE9, 0xB2, 0x96 },
	0xF78C,	{ 0xE9, 0xB2, 0x97 },
	0xF78D,	{ 0xE9, 0xB2, 0x98 },
	0xF78E,	{ 0xE9, 0xB2, 0x99 },
	0xF78F,	{ 0xE9, 0xB2, 0x9D },
	0xF790,	{ 0xE9, 0xB2, 0xAA },
	0xF791,	{ 0xE9, 0xB2, 0xAC },
	0xF792,	{ 0xE9, 0xB2, 0xAF },
	0xF793,	{ 0xE9, 0xB2, 0xB9 },
	0xF794,	{ 0xE9, 0xB2, 0xBE },
	0xF795,	{ 0xE9, 0xB2, 0xBF },
	0xF796,	{ 0xE9, 0xB3, 0x80 },
	0xF797,	{ 0xE9, 0xB3, 0x81 },
	0xF798,	{ 0xE9, 0xB3, 0x82 },
	0xF799,	{ 0xE9, 0xB3, 0x88 },
	0xF79A,	{ 0xE9, 0xB3, 0x89 },
	0xF79B,	{ 0xE9, 0xB3, 0x91 },
	0xF79C,	{ 0xE9, 0xB3, 0x92 },
	0xF79D,	{ 0xE9, 0xB3, 0x9A },
	0xF79E,	{ 0xE9, 0xB3, 0x9B },
	0xF79F,	{ 0xE9, 0xB3, 0xA0 },
	0xF7A0,	{ 0xE9, 0xB3, 0xA1 },
	0xF7A1,	{ 0xE9, 0xB3, 0x8C },
	0xF7A2,	{ 0xE9, 0xB3, 0x8D },
	0xF7A3,	{ 0xE9, 0xB3, 0x8E },
	0xF7A4,	{ 0xE9, 0xB3, 0x8F },
	0xF7A5,	{ 0xE9, 0xB3, 0x90 },
	0xF7A6,	{ 0xE9, 0xB3, 0x93 },
	0xF7A7,	{ 0xE9, 0xB3, 0x94 },
	0xF7A8,	{ 0xE9, 0xB3, 0x95 },
	0xF7A9,	{ 0xE9, 0xB3, 0x97 },
	0xF7AA,	{ 0xE9, 0xB3, 0x98 },
	0xF7AB,	{ 0xE9, 0xB3, 0x99 },
	0xF7AC,	{ 0xE9, 0xB3, 0x9C },
	0xF7AD,	{ 0xE9, 0xB3, 0x9D },
	0xF7AE,	{ 0xE9, 0xB3, 0x9F },
	0xF7AF,	{ 0xE9, 0xB3, 0xA2 },
	0xF7B0,	{ 0xE9, 0x9D, 0xBC },
	0xF7B1,	{ 0xE9, 0x9E, 0x85 },
	0xF7B2,	{ 0xE9, 0x9E, 0x91 },
	0xF7B3,	{ 0xE9, 0x9E, 0x92 },
	0xF7B4,	{ 0xE9, 0x9E, 0x94 },
	0xF7B5,	{ 0xE9, 0x9E, 0xAF },
	0xF7B6,	{ 0xE9, 0x9E, 0xAB },
	0xF7B7,	{ 0xE9, 0x9E, 0xA3 },
	0xF7B8,	{ 0xE9, 0x9E, 0xB2 },
	0xF7B9,	{ 0xE9, 0x9E, 0xB4 },
	0xF7BA,	{ 0xE9, 0xAA, 0xB1 },
	0xF7BB,	{ 0xE9, 0xAA, 0xB0 },
	0xF7BC,	{ 0xE9, 0xAA, 0xB7 },
	0xF7BD,	{ 0xE9, 0xB9, 0x98 },
	0xF7BE,	{ 0xE9, 0xAA, 0xB6 },
	0xF7BF,	{ 0xE9, 0xAA, 0xBA },
	0xF7C0,	{ 0xE9, 0xAA, 0xBC },
	0xF7C1,	{ 0xE9, 0xAB, 0x81 },
	0xF7C2,	{ 0xE9, 0xAB, 0x80 },
	0xF7C3,	{ 0xE9, 0xAB, 0x85 },
	0xF7C4,	{ 0xE9, 0xAB, 0x82 },
	0xF7C5,	{ 0xE9, 0xAB, 0x8B },
	0xF7C6,	{ 0xE9, 0xAB, 0x8C },
	0xF7C7,	{ 0xE9, 0xAB, 0x91 },
	0xF7C8,	{ 0xE9, 0xAD, 0x85 },
	0xF7C9,	{ 0xE9, 0xAD, 0x83 },
	0xF7CA,	{ 0xE9, 0xAD, 0x87 },
	0xF7CB,	{ 0xE9, 0xAD, 0x89 },
	0xF7CC,	{ 0xE9, 0xAD, 0x88 },
	0xF7CD,	{ 0xE9, 0xAD, 0x8D },
	0xF7CE,	{ 0xE9, 0xAD, 0x91 },
	0xF7CF,	{ 0xE9, 0xA3, 0xA8 },
	0xF7D0,	{ 0xE9, 0xA4, 0x8D },
	0xF7D1,	{ 0xE9, 0xA4, 0xAE },
	0xF7D2,	{ 0xE9, 0xA5, 0x95 },
	0xF7D3,	{ 0xE9, 0xA5, 0x94 },
	0xF7D4,	{ 0xE9, 0xAB, 0x9F },
	0xF7D5,	{ 0xE9, 0xAB, 0xA1 },
	0xF7D6,	{ 0xE9, 0xAB, 0xA6 },
	0xF7D7,	{ 0xE9, 0xAB, 0xAF },
	0xF7D8,	{ 0xE9, 0xAB, 0xAB },
	0xF7D9,	{ 0xE9, 0xAB, 0xBB },
	0xF7DA,	{ 0xE9, 0xAB, 0xAD },
	0xF7DB,	{ 0xE9, 0xAB, 0xB9 },
	0xF7DC,	{ 0xE9, 0xAC, 0x88 },
	0xF7DD,	{ 0xE9, 0xAC, 0x8F },
	0xF7DE,	{ 0xE9, 0xAC, 0x93 },
	0xF7DF,	{ 0xE9, 0xAC, 0x9F },
	0xF7E0,	{ 0xE9, 0xAC, 0xA3 },
	0xF7E1,	{ 0xE9, 0xBA, 0xBD },
	0xF7E2,	{ 0xE9, 0xBA, 0xBE },
	0xF7E3,	{ 0xE7, 0xB8, 0xBB },
	0xF7E4,	{ 0xE9, 0xBA, 0x82 },
	0xF7E5,	{ 0xE9, 0xBA, 0x87 },
	0xF7E6,	{ 0xE9, 0xBA, 0x88 },
	0xF7E7,	{ 0xE9, 0xBA, 0x8B },
	0xF7E8,	{ 0xE9, 0xBA, 0x92 },
	0xF7E9,	{ 0xE9, 0x8F, 0x96 },
	0xF7EA,	{ 0xE9, 0xBA, 0x9D },
	0xF7EB,	{ 0xE9, 0xBA, 0x9F },
	0xF7EC,	{ 0xE9, 0xBB, 0x9B },
	0xF7ED,	{ 0xE9, 0xBB, 0x9C },
	0xF7EE,	{ 0xE9, 0xBB, 0x9D },
	0xF7EF,	{ 0xE9, 0xBB, 0xA0 },
	0xF7F0,	{ 0xE9, 0xBB, 0x9F },
	0xF7F1,	{ 0xE9, 0xBB, 0xA2 },
	0xF7F2,	{ 0xE9, 0xBB, 0xA9 },
	0xF7F3,	{ 0xE9, 0xBB, 0xA7 },
	0xF7F4,	{ 0xE9, 0xBB, 0xA5 },
	0xF7F5,	{ 0xE9, 0xBB, 0xAA },
	0xF7F6,	{ 0xE9, 0xBB, 0xAF },
	0xF7F7,	{ 0xE9, 0xBC, 0xA2 },
	0xF7F8,	{ 0xE9, 0xBC, 0xAC },
	0xF7F9,	{ 0xE9, 0xBC, 0xAF },
	0xF7FA,	{ 0xE9, 0xBC, 0xB9 },
	0xF7FB,	{ 0xE9, 0xBC, 0xB7 },
	0xF7FC,	{ 0xE9, 0xBC, 0xBD },
	0xF7FD,	{ 0xE9, 0xBC, 0xBE },
	0xF7FE,	{ 0xE9, 0xBD, 0x84 },
	0xF840,	{ 0xE9, 0xB3, 0xA3 },
	0xF841,	{ 0xE9, 0xB3, 0xA4 },
	0xF842,	{ 0xE9, 0xB3, 0xA5 },
	0xF843,	{ 0xE9, 0xB3, 0xA6 },
	0xF844,	{ 0xE9, 0xB3, 0xA7 },
	0xF845,	{ 0xE9, 0xB3, 0xA8 },
	0xF846,	{ 0xE9, 0xB3, 0xA9 },
	0xF847,	{ 0xE9, 0xB3, 0xAA },
	0xF848,	{ 0xE9, 0xB3, 0xAB },
	0xF849,	{ 0xE9, 0xB3, 0xAC },
	0xF84A,	{ 0xE9, 0xB3, 0xAD },
	0xF84B,	{ 0xE9, 0xB3, 0xAE },
	0xF84C,	{ 0xE9, 0xB3, 0xAF },
	0xF84D,	{ 0xE9, 0xB3, 0xB0 },
	0xF84E,	{ 0xE9, 0xB3, 0xB1 },
	0xF84F,	{ 0xE9, 0xB3, 0xB2 },
	0xF850,	{ 0xE9, 0xB3, 0xB3 },
	0xF851,	{ 0xE9, 0xB3, 0xB4 },
	0xF852,	{ 0xE9, 0xB3, 0xB5 },
	0xF853,	{ 0xE9, 0xB3, 0xB6 },
	0xF854,	{ 0xE9, 0xB3, 0xB7 },
	0xF855,	{ 0xE9, 0xB3, 0xB8 },
	0xF856,	{ 0xE9, 0xB3, 0xB9 },
	0xF857,	{ 0xE9, 0xB3, 0xBA },
	0xF858,	{ 0xE9, 0xB3, 0xBB },
	0xF859,	{ 0xE9, 0xB3, 0xBC },
	0xF85A,	{ 0xE9, 0xB3, 0xBD },
	0xF85B,	{ 0xE9, 0xB3, 0xBE },
	0xF85C,	{ 0xE9, 0xB3, 0xBF },
	0xF85D,	{ 0xE9, 0xB4, 0x80 },
	0xF85E,	{ 0xE9, 0xB4, 0x81 },
	0xF85F,	{ 0xE9, 0xB4, 0x82 },
	0xF860,	{ 0xE9, 0xB4, 0x83 },
	0xF861,	{ 0xE9, 0xB4, 0x84 },
	0xF862,	{ 0xE9, 0xB4, 0x85 },
	0xF863,	{ 0xE9, 0xB4, 0x86 },
	0xF864,	{ 0xE9, 0xB4, 0x87 },
	0xF865,	{ 0xE9, 0xB4, 0x88 },
	0xF866,	{ 0xE9, 0xB4, 0x89 },
	0xF867,	{ 0xE9, 0xB4, 0x8A },
	0xF868,	{ 0xE9, 0xB4, 0x8B },
	0xF869,	{ 0xE9, 0xB4, 0x8C },
	0xF86A,	{ 0xE9, 0xB4, 0x8D },
	0xF86B,	{ 0xE9, 0xB4, 0x8E },
	0xF86C,	{ 0xE9, 0xB4, 0x8F },
	0xF86D,	{ 0xE9, 0xB4, 0x90 },
	0xF86E,	{ 0xE9, 0xB4, 0x91 },
	0xF86F,	{ 0xE9, 0xB4, 0x92 },
	0xF870,	{ 0xE9, 0xB4, 0x93 },
	0xF871,	{ 0xE9, 0xB4, 0x94 },
	0xF872,	{ 0xE9, 0xB4, 0x95 },
	0xF873,	{ 0xE9, 0xB4, 0x96 },
	0xF874,	{ 0xE9, 0xB4, 0x97 },
	0xF875,	{ 0xE9, 0xB4, 0x98 },
	0xF876,	{ 0xE9, 0xB4, 0x99 },
	0xF877,	{ 0xE9, 0xB4, 0x9A },
	0xF878,	{ 0xE9, 0xB4, 0x9B },
	0xF879,	{ 0xE9, 0xB4, 0x9C },
	0xF87A,	{ 0xE9, 0xB4, 0x9D },
	0xF87B,	{ 0xE9, 0xB4, 0x9E },
	0xF87C,	{ 0xE9, 0xB4, 0x9F },
	0xF87D,	{ 0xE9, 0xB4, 0xA0 },
	0xF87E,	{ 0xE9, 0xB4, 0xA1 },
	0xF880,	{ 0xE9, 0xB4, 0xA2 },
	0xF881,	{ 0xE9, 0xB4, 0xA3 },
	0xF882,	{ 0xE9, 0xB4, 0xA4 },
	0xF883,	{ 0xE9, 0xB4, 0xA5 },
	0xF884,	{ 0xE9, 0xB4, 0xA6 },
	0xF885,	{ 0xE9, 0xB4, 0xA7 },
	0xF886,	{ 0xE9, 0xB4, 0xA8 },
	0xF887,	{ 0xE9, 0xB4, 0xA9 },
	0xF888,	{ 0xE9, 0xB4, 0xAA },
	0xF889,	{ 0xE9, 0xB4, 0xAB },
	0xF88A,	{ 0xE9, 0xB4, 0xAC },
	0xF88B,	{ 0xE9, 0xB4, 0xAD },
	0xF88C,	{ 0xE9, 0xB4, 0xAE },
	0xF88D,	{ 0xE9, 0xB4, 0xAF },
	0xF88E,	{ 0xE9, 0xB4, 0xB0 },
	0xF88F,	{ 0xE9, 0xB4, 0xB1 },
	0xF890,	{ 0xE9, 0xB4, 0xB2 },
	0xF891,	{ 0xE9, 0xB4, 0xB3 },
	0xF892,	{ 0xE9, 0xB4, 0xB4 },
	0xF893,	{ 0xE9, 0xB4, 0xB5 },
	0xF894,	{ 0xE9, 0xB4, 0xB6 },
	0xF895,	{ 0xE9, 0xB4, 0xB7 },
	0xF896,	{ 0xE9, 0xB4, 0xB8 },
	0xF897,	{ 0xE9, 0xB4, 0xB9 },
	0xF898,	{ 0xE9, 0xB4, 0xBA },
	0xF899,	{ 0xE9, 0xB4, 0xBB },
	0xF89A,	{ 0xE9, 0xB4, 0xBC },
	0xF89B,	{ 0xE9, 0xB4, 0xBD },
	0xF89C,	{ 0xE9, 0xB4, 0xBE },
	0xF89D,	{ 0xE9, 0xB4, 0xBF },
	0xF89E,	{ 0xE9, 0xB5, 0x80 },
	0xF89F,	{ 0xE9, 0xB5, 0x81 },
	0xF8A0,	{ 0xE9, 0xB5, 0x82 },
	0xF8A1,	{ 0xEE, 0x88, 0xB4 },
	0xF8A2,	{ 0xEE, 0x88, 0xB5 },
	0xF8A3,	{ 0xEE, 0x88, 0xB6 },
	0xF8A4,	{ 0xEE, 0x88, 0xB7 },
	0xF8A5,	{ 0xEE, 0x88, 0xB8 },
	0xF8A6,	{ 0xEE, 0x88, 0xB9 },
	0xF8A7,	{ 0xEE, 0x88, 0xBA },
	0xF8A8,	{ 0xEE, 0x88, 0xBB },
	0xF8A9,	{ 0xEE, 0x88, 0xBC },
	0xF8AA,	{ 0xEE, 0x88, 0xBD },
	0xF8AB,	{ 0xEE, 0x88, 0xBE },
	0xF8AC,	{ 0xEE, 0x88, 0xBF },
	0xF8AD,	{ 0xEE, 0x89, 0x80 },
	0xF8AE,	{ 0xEE, 0x89, 0x81 },
	0xF8AF,	{ 0xEE, 0x89, 0x82 },
	0xF8B0,	{ 0xEE, 0x89, 0x83 },
	0xF8B1,	{ 0xEE, 0x89, 0x84 },
	0xF8B2,	{ 0xEE, 0x89, 0x85 },
	0xF8B3,	{ 0xEE, 0x89, 0x86 },
	0xF8B4,	{ 0xEE, 0x89, 0x87 },
	0xF8B5,	{ 0xEE, 0x89, 0x88 },
	0xF8B6,	{ 0xEE, 0x89, 0x89 },
	0xF8B7,	{ 0xEE, 0x89, 0x8A },
	0xF8B8,	{ 0xEE, 0x89, 0x8B },
	0xF8B9,	{ 0xEE, 0x89, 0x8C },
	0xF8BA,	{ 0xEE, 0x89, 0x8D },
	0xF8BB,	{ 0xEE, 0x89, 0x8E },
	0xF8BC,	{ 0xEE, 0x89, 0x8F },
	0xF8BD,	{ 0xEE, 0x89, 0x90 },
	0xF8BE,	{ 0xEE, 0x89, 0x91 },
	0xF8BF,	{ 0xEE, 0x89, 0x92 },
	0xF8C0,	{ 0xEE, 0x89, 0x93 },
	0xF8C1,	{ 0xEE, 0x89, 0x94 },
	0xF8C2,	{ 0xEE, 0x89, 0x95 },
	0xF8C3,	{ 0xEE, 0x89, 0x96 },
	0xF8C4,	{ 0xEE, 0x89, 0x97 },
	0xF8C5,	{ 0xEE, 0x89, 0x98 },
	0xF8C6,	{ 0xEE, 0x89, 0x99 },
	0xF8C7,	{ 0xEE, 0x89, 0x9A },
	0xF8C8,	{ 0xEE, 0x89, 0x9B },
	0xF8C9,	{ 0xEE, 0x89, 0x9C },
	0xF8CA,	{ 0xEE, 0x89, 0x9D },
	0xF8CB,	{ 0xEE, 0x89, 0x9E },
	0xF8CC,	{ 0xEE, 0x89, 0x9F },
	0xF8CD,	{ 0xEE, 0x89, 0xA0 },
	0xF8CE,	{ 0xEE, 0x89, 0xA1 },
	0xF8CF,	{ 0xEE, 0x89, 0xA2 },
	0xF8D0,	{ 0xEE, 0x89, 0xA3 },
	0xF8D1,	{ 0xEE, 0x89, 0xA4 },
	0xF8D2,	{ 0xEE, 0x89, 0xA5 },
	0xF8D3,	{ 0xEE, 0x89, 0xA6 },
	0xF8D4,	{ 0xEE, 0x89, 0xA7 },
	0xF8D5,	{ 0xEE, 0x89, 0xA8 },
	0xF8D6,	{ 0xEE, 0x89, 0xA9 },
	0xF8D7,	{ 0xEE, 0x89, 0xAA },
	0xF8D8,	{ 0xEE, 0x89, 0xAB },
	0xF8D9,	{ 0xEE, 0x89, 0xAC },
	0xF8DA,	{ 0xEE, 0x89, 0xAD },
	0xF8DB,	{ 0xEE, 0x89, 0xAE },
	0xF8DC,	{ 0xEE, 0x89, 0xAF },
	0xF8DD,	{ 0xEE, 0x89, 0xB0 },
	0xF8DE,	{ 0xEE, 0x89, 0xB1 },
	0xF8DF,	{ 0xEE, 0x89, 0xB2 },
	0xF8E0,	{ 0xEE, 0x89, 0xB3 },
	0xF8E1,	{ 0xEE, 0x89, 0xB4 },
	0xF8E2,	{ 0xEE, 0x89, 0xB5 },
	0xF8E3,	{ 0xEE, 0x89, 0xB6 },
	0xF8E4,	{ 0xEE, 0x89, 0xB7 },
	0xF8E5,	{ 0xEE, 0x89, 0xB8 },
	0xF8E6,	{ 0xEE, 0x89, 0xB9 },
	0xF8E7,	{ 0xEE, 0x89, 0xBA },
	0xF8E8,	{ 0xEE, 0x89, 0xBB },
	0xF8E9,	{ 0xEE, 0x89, 0xBC },
	0xF8EA,	{ 0xEE, 0x89, 0xBD },
	0xF8EB,	{ 0xEE, 0x89, 0xBE },
	0xF8EC,	{ 0xEE, 0x89, 0xBF },
	0xF8ED,	{ 0xEE, 0x8A, 0x80 },
	0xF8EE,	{ 0xEE, 0x8A, 0x81 },
	0xF8EF,	{ 0xEE, 0x8A, 0x82 },
	0xF8F0,	{ 0xEE, 0x8A, 0x83 },
	0xF8F1,	{ 0xEE, 0x8A, 0x84 },
	0xF8F2,	{ 0xEE, 0x8A, 0x85 },
	0xF8F3,	{ 0xEE, 0x8A, 0x86 },
	0xF8F4,	{ 0xEE, 0x8A, 0x87 },
	0xF8F5,	{ 0xEE, 0x8A, 0x88 },
	0xF8F6,	{ 0xEE, 0x8A, 0x89 },
	0xF8F7,	{ 0xEE, 0x8A, 0x8A },
	0xF8F8,	{ 0xEE, 0x8A, 0x8B },
	0xF8F9,	{ 0xEE, 0x8A, 0x8C },
	0xF8FA,	{ 0xEE, 0x8A, 0x8D },
	0xF8FB,	{ 0xEE, 0x8A, 0x8E },
	0xF8FC,	{ 0xEE, 0x8A, 0x8F },
	0xF8FD,	{ 0xEE, 0x8A, 0x90 },
	0xF8FE,	{ 0xEE, 0x8A, 0x91 },
	0xF940,	{ 0xE9, 0xB5, 0x83 },
	0xF941,	{ 0xE9, 0xB5, 0x84 },
	0xF942,	{ 0xE9, 0xB5, 0x85 },
	0xF943,	{ 0xE9, 0xB5, 0x86 },
	0xF944,	{ 0xE9, 0xB5, 0x87 },
	0xF945,	{ 0xE9, 0xB5, 0x88 },
	0xF946,	{ 0xE9, 0xB5, 0x89 },
	0xF947,	{ 0xE9, 0xB5, 0x8A },
	0xF948,	{ 0xE9, 0xB5, 0x8B },
	0xF949,	{ 0xE9, 0xB5, 0x8C },
	0xF94A,	{ 0xE9, 0xB5, 0x8D },
	0xF94B,	{ 0xE9, 0xB5, 0x8E },
	0xF94C,	{ 0xE9, 0xB5, 0x8F },
	0xF94D,	{ 0xE9, 0xB5, 0x90 },
	0xF94E,	{ 0xE9, 0xB5, 0x91 },
	0xF94F,	{ 0xE9, 0xB5, 0x92 },
	0xF950,	{ 0xE9, 0xB5, 0x93 },
	0xF951,	{ 0xE9, 0xB5, 0x94 },
	0xF952,	{ 0xE9, 0xB5, 0x95 },
	0xF953,	{ 0xE9, 0xB5, 0x96 },
	0xF954,	{ 0xE9, 0xB5, 0x97 },
	0xF955,	{ 0xE9, 0xB5, 0x98 },
	0xF956,	{ 0xE9, 0xB5, 0x99 },
	0xF957,	{ 0xE9, 0xB5, 0x9A },
	0xF958,	{ 0xE9, 0xB5, 0x9B },
	0xF959,	{ 0xE9, 0xB5, 0x9C },
	0xF95A,	{ 0xE9, 0xB5, 0x9D },
	0xF95B,	{ 0xE9, 0xB5, 0x9E },
	0xF95C,	{ 0xE9, 0xB5, 0x9F },
	0xF95D,	{ 0xE9, 0xB5, 0xA0 },
	0xF95E,	{ 0xE9, 0xB5, 0xA1 },
	0xF95F,	{ 0xE9, 0xB5, 0xA2 },
	0xF960,	{ 0xE9, 0xB5, 0xA3 },
	0xF961,	{ 0xE9, 0xB5, 0xA4 },
	0xF962,	{ 0xE9, 0xB5, 0xA5 },
	0xF963,	{ 0xE9, 0xB5, 0xA6 },
	0xF964,	{ 0xE9, 0xB5, 0xA7 },
	0xF965,	{ 0xE9, 0xB5, 0xA8 },
	0xF966,	{ 0xE9, 0xB5, 0xA9 },
	0xF967,	{ 0xE9, 0xB5, 0xAA },
	0xF968,	{ 0xE9, 0xB5, 0xAB },
	0xF969,	{ 0xE9, 0xB5, 0xAC },
	0xF96A,	{ 0xE9, 0xB5, 0xAD },
	0xF96B,	{ 0xE9, 0xB5, 0xAE },
	0xF96C,	{ 0xE9, 0xB5, 0xAF },
	0xF96D,	{ 0xE9, 0xB5, 0xB0 },
	0xF96E,	{ 0xE9, 0xB5, 0xB1 },
	0xF96F,	{ 0xE9, 0xB5, 0xB2 },
	0xF970,	{ 0xE9, 0xB5, 0xB3 },
	0xF971,	{ 0xE9, 0xB5, 0xB4 },
	0xF972,	{ 0xE9, 0xB5, 0xB5 },
	0xF973,	{ 0xE9, 0xB5, 0xB6 },
	0xF974,	{ 0xE9, 0xB5, 0xB7 },
	0xF975,	{ 0xE9, 0xB5, 0xB8 },
	0xF976,	{ 0xE9, 0xB5, 0xB9 },
	0xF977,	{ 0xE9, 0xB5, 0xBA },
	0xF978,	{ 0xE9, 0xB5, 0xBB },
	0xF979,	{ 0xE9, 0xB5, 0xBC },
	0xF97A,	{ 0xE9, 0xB5, 0xBD },
	0xF97B,	{ 0xE9, 0xB5, 0xBE },
	0xF97C,	{ 0xE9, 0xB5, 0xBF },
	0xF97D,	{ 0xE9, 0xB6, 0x80 },
	0xF97E,	{ 0xE9, 0xB6, 0x81 },
	0xF980,	{ 0xE9, 0xB6, 0x82 },
	0xF981,	{ 0xE9, 0xB6, 0x83 },
	0xF982,	{ 0xE9, 0xB6, 0x84 },
	0xF983,	{ 0xE9, 0xB6, 0x85 },
	0xF984,	{ 0xE9, 0xB6, 0x86 },
	0xF985,	{ 0xE9, 0xB6, 0x87 },
	0xF986,	{ 0xE9, 0xB6, 0x88 },
	0xF987,	{ 0xE9, 0xB6, 0x89 },
	0xF988,	{ 0xE9, 0xB6, 0x8A },
	0xF989,	{ 0xE9, 0xB6, 0x8B },
	0xF98A,	{ 0xE9, 0xB6, 0x8C },
	0xF98B,	{ 0xE9, 0xB6, 0x8D },
	0xF98C,	{ 0xE9, 0xB6, 0x8E },
	0xF98D,	{ 0xE9, 0xB6, 0x8F },
	0xF98E,	{ 0xE9, 0xB6, 0x90 },
	0xF98F,	{ 0xE9, 0xB6, 0x91 },
	0xF990,	{ 0xE9, 0xB6, 0x92 },
	0xF991,	{ 0xE9, 0xB6, 0x93 },
	0xF992,	{ 0xE9, 0xB6, 0x94 },
	0xF993,	{ 0xE9, 0xB6, 0x95 },
	0xF994,	{ 0xE9, 0xB6, 0x96 },
	0xF995,	{ 0xE9, 0xB6, 0x97 },
	0xF996,	{ 0xE9, 0xB6, 0x98 },
	0xF997,	{ 0xE9, 0xB6, 0x99 },
	0xF998,	{ 0xE9, 0xB6, 0x9A },
	0xF999,	{ 0xE9, 0xB6, 0x9B },
	0xF99A,	{ 0xE9, 0xB6, 0x9C },
	0xF99B,	{ 0xE9, 0xB6, 0x9D },
	0xF99C,	{ 0xE9, 0xB6, 0x9E },
	0xF99D,	{ 0xE9, 0xB6, 0x9F },
	0xF99E,	{ 0xE9, 0xB6, 0xA0 },
	0xF99F,	{ 0xE9, 0xB6, 0xA1 },
	0xF9A0,	{ 0xE9, 0xB6, 0xA2 },
	0xF9A1,	{ 0xEE, 0x8A, 0x92 },
	0xF9A2,	{ 0xEE, 0x8A, 0x93 },
	0xF9A3,	{ 0xEE, 0x8A, 0x94 },
	0xF9A4,	{ 0xEE, 0x8A, 0x95 },
	0xF9A5,	{ 0xEE, 0x8A, 0x96 },
	0xF9A6,	{ 0xEE, 0x8A, 0x97 },
	0xF9A7,	{ 0xEE, 0x8A, 0x98 },
	0xF9A8,	{ 0xEE, 0x8A, 0x99 },
	0xF9A9,	{ 0xEE, 0x8A, 0x9A },
	0xF9AA,	{ 0xEE, 0x8A, 0x9B },
	0xF9AB,	{ 0xEE, 0x8A, 0x9C },
	0xF9AC,	{ 0xEE, 0x8A, 0x9D },
	0xF9AD,	{ 0xEE, 0x8A, 0x9E },
	0xF9AE,	{ 0xEE, 0x8A, 0x9F },
	0xF9AF,	{ 0xEE, 0x8A, 0xA0 },
	0xF9B0,	{ 0xEE, 0x8A, 0xA1 },
	0xF9B1,	{ 0xEE, 0x8A, 0xA2 },
	0xF9B2,	{ 0xEE, 0x8A, 0xA3 },
	0xF9B3,	{ 0xEE, 0x8A, 0xA4 },
	0xF9B4,	{ 0xEE, 0x8A, 0xA5 },
	0xF9B5,	{ 0xEE, 0x8A, 0xA6 },
	0xF9B6,	{ 0xEE, 0x8A, 0xA7 },
	0xF9B7,	{ 0xEE, 0x8A, 0xA8 },
	0xF9B8,	{ 0xEE, 0x8A, 0xA9 },
	0xF9B9,	{ 0xEE, 0x8A, 0xAA },
	0xF9BA,	{ 0xEE, 0x8A, 0xAB },
	0xF9BB,	{ 0xEE, 0x8A, 0xAC },
	0xF9BC,	{ 0xEE, 0x8A, 0xAD },
	0xF9BD,	{ 0xEE, 0x8A, 0xAE },
	0xF9BE,	{ 0xEE, 0x8A, 0xAF },
	0xF9BF,	{ 0xEE, 0x8A, 0xB0 },
	0xF9C0,	{ 0xEE, 0x8A, 0xB1 },
	0xF9C1,	{ 0xEE, 0x8A, 0xB2 },
	0xF9C2,	{ 0xEE, 0x8A, 0xB3 },
	0xF9C3,	{ 0xEE, 0x8A, 0xB4 },
	0xF9C4,	{ 0xEE, 0x8A, 0xB5 },
	0xF9C5,	{ 0xEE, 0x8A, 0xB6 },
	0xF9C6,	{ 0xEE, 0x8A, 0xB7 },
	0xF9C7,	{ 0xEE, 0x8A, 0xB8 },
	0xF9C8,	{ 0xEE, 0x8A, 0xB9 },
	0xF9C9,	{ 0xEE, 0x8A, 0xBA },
	0xF9CA,	{ 0xEE, 0x8A, 0xBB },
	0xF9CB,	{ 0xEE, 0x8A, 0xBC },
	0xF9CC,	{ 0xEE, 0x8A, 0xBD },
	0xF9CD,	{ 0xEE, 0x8A, 0xBE },
	0xF9CE,	{ 0xEE, 0x8A, 0xBF },
	0xF9CF,	{ 0xEE, 0x8B, 0x80 },
	0xF9D0,	{ 0xEE, 0x8B, 0x81 },
	0xF9D1,	{ 0xEE, 0x8B, 0x82 },
	0xF9D2,	{ 0xEE, 0x8B, 0x83 },
	0xF9D3,	{ 0xEE, 0x8B, 0x84 },
	0xF9D4,	{ 0xEE, 0x8B, 0x85 },
	0xF9D5,	{ 0xEE, 0x8B, 0x86 },
	0xF9D6,	{ 0xEE, 0x8B, 0x87 },
	0xF9D7,	{ 0xEE, 0x8B, 0x88 },
	0xF9D8,	{ 0xEE, 0x8B, 0x89 },
	0xF9D9,	{ 0xEE, 0x8B, 0x8A },
	0xF9DA,	{ 0xEE, 0x8B, 0x8B },
	0xF9DB,	{ 0xEE, 0x8B, 0x8C },
	0xF9DC,	{ 0xEE, 0x8B, 0x8D },
	0xF9DD,	{ 0xEE, 0x8B, 0x8E },
	0xF9DE,	{ 0xEE, 0x8B, 0x8F },
	0xF9DF,	{ 0xEE, 0x8B, 0x90 },
	0xF9E0,	{ 0xEE, 0x8B, 0x91 },
	0xF9E1,	{ 0xEE, 0x8B, 0x92 },
	0xF9E2,	{ 0xEE, 0x8B, 0x93 },
	0xF9E3,	{ 0xEE, 0x8B, 0x94 },
	0xF9E4,	{ 0xEE, 0x8B, 0x95 },
	0xF9E5,	{ 0xEE, 0x8B, 0x96 },
	0xF9E6,	{ 0xEE, 0x8B, 0x97 },
	0xF9E7,	{ 0xEE, 0x8B, 0x98 },
	0xF9E8,	{ 0xEE, 0x8B, 0x99 },
	0xF9E9,	{ 0xEE, 0x8B, 0x9A },
	0xF9EA,	{ 0xEE, 0x8B, 0x9B },
	0xF9EB,	{ 0xEE, 0x8B, 0x9C },
	0xF9EC,	{ 0xEE, 0x8B, 0x9D },
	0xF9ED,	{ 0xEE, 0x8B, 0x9E },
	0xF9EE,	{ 0xEE, 0x8B, 0x9F },
	0xF9EF,	{ 0xEE, 0x8B, 0xA0 },
	0xF9F0,	{ 0xEE, 0x8B, 0xA1 },
	0xF9F1,	{ 0xEE, 0x8B, 0xA2 },
	0xF9F2,	{ 0xEE, 0x8B, 0xA3 },
	0xF9F3,	{ 0xEE, 0x8B, 0xA4 },
	0xF9F4,	{ 0xEE, 0x8B, 0xA5 },
	0xF9F5,	{ 0xEE, 0x8B, 0xA6 },
	0xF9F6,	{ 0xEE, 0x8B, 0xA7 },
	0xF9F7,	{ 0xEE, 0x8B, 0xA8 },
	0xF9F8,	{ 0xEE, 0x8B, 0xA9 },
	0xF9F9,	{ 0xEE, 0x8B, 0xAA },
	0xF9FA,	{ 0xEE, 0x8B, 0xAB },
	0xF9FB,	{ 0xEE, 0x8B, 0xAC },
	0xF9FC,	{ 0xEE, 0x8B, 0xAD },
	0xF9FD,	{ 0xEE, 0x8B, 0xAE },
	0xF9FE,	{ 0xEE, 0x8B, 0xAF },
	0xFA40,	{ 0xE9, 0xB6, 0xA3 },
	0xFA41,	{ 0xE9, 0xB6, 0xA4 },
	0xFA42,	{ 0xE9, 0xB6, 0xA5 },
	0xFA43,	{ 0xE9, 0xB6, 0xA6 },
	0xFA44,	{ 0xE9, 0xB6, 0xA7 },
	0xFA45,	{ 0xE9, 0xB6, 0xA8 },
	0xFA46,	{ 0xE9, 0xB6, 0xA9 },
	0xFA47,	{ 0xE9, 0xB6, 0xAA },
	0xFA48,	{ 0xE9, 0xB6, 0xAB },
	0xFA49,	{ 0xE9, 0xB6, 0xAC },
	0xFA4A,	{ 0xE9, 0xB6, 0xAD },
	0xFA4B,	{ 0xE9, 0xB6, 0xAE },
	0xFA4C,	{ 0xE9, 0xB6, 0xAF },
	0xFA4D,	{ 0xE9, 0xB6, 0xB0 },
	0xFA4E,	{ 0xE9, 0xB6, 0xB1 },
	0xFA4F,	{ 0xE9, 0xB6, 0xB2 },
	0xFA50,	{ 0xE9, 0xB6, 0xB3 },
	0xFA51,	{ 0xE9, 0xB6, 0xB4 },
	0xFA52,	{ 0xE9, 0xB6, 0xB5 },
	0xFA53,	{ 0xE9, 0xB6, 0xB6 },
	0xFA54,	{ 0xE9, 0xB6, 0xB7 },
	0xFA55,	{ 0xE9, 0xB6, 0xB8 },
	0xFA56,	{ 0xE9, 0xB6, 0xB9 },
	0xFA57,	{ 0xE9, 0xB6, 0xBA },
	0xFA58,	{ 0xE9, 0xB6, 0xBB },
	0xFA59,	{ 0xE9, 0xB6, 0xBC },
	0xFA5A,	{ 0xE9, 0xB6, 0xBD },
	0xFA5B,	{ 0xE9, 0xB6, 0xBE },
	0xFA5C,	{ 0xE9, 0xB6, 0xBF },
	0xFA5D,	{ 0xE9, 0xB7, 0x80 },
	0xFA5E,	{ 0xE9, 0xB7, 0x81 },
	0xFA5F,	{ 0xE9, 0xB7, 0x82 },
	0xFA60,	{ 0xE9, 0xB7, 0x83 },
	0xFA61,	{ 0xE9, 0xB7, 0x84 },
	0xFA62,	{ 0xE9, 0xB7, 0x85 },
	0xFA63,	{ 0xE9, 0xB7, 0x86 },
	0xFA64,	{ 0xE9, 0xB7, 0x87 },
	0xFA65,	{ 0xE9, 0xB7, 0x88 },
	0xFA66,	{ 0xE9, 0xB7, 0x89 },
	0xFA67,	{ 0xE9, 0xB7, 0x8A },
	0xFA68,	{ 0xE9, 0xB7, 0x8B },
	0xFA69,	{ 0xE9, 0xB7, 0x8C },
	0xFA6A,	{ 0xE9, 0xB7, 0x8D },
	0xFA6B,	{ 0xE9, 0xB7, 0x8E },
	0xFA6C,	{ 0xE9, 0xB7, 0x8F },
	0xFA6D,	{ 0xE9, 0xB7, 0x90 },
	0xFA6E,	{ 0xE9, 0xB7, 0x91 },
	0xFA6F,	{ 0xE9, 0xB7, 0x92 },
	0xFA70,	{ 0xE9, 0xB7, 0x93 },
	0xFA71,	{ 0xE9, 0xB7, 0x94 },
	0xFA72,	{ 0xE9, 0xB7, 0x95 },
	0xFA73,	{ 0xE9, 0xB7, 0x96 },
	0xFA74,	{ 0xE9, 0xB7, 0x97 },
	0xFA75,	{ 0xE9, 0xB7, 0x98 },
	0xFA76,	{ 0xE9, 0xB7, 0x99 },
	0xFA77,	{ 0xE9, 0xB7, 0x9A },
	0xFA78,	{ 0xE9, 0xB7, 0x9B },
	0xFA79,	{ 0xE9, 0xB7, 0x9C },
	0xFA7A,	{ 0xE9, 0xB7, 0x9D },
	0xFA7B,	{ 0xE9, 0xB7, 0x9E },
	0xFA7C,	{ 0xE9, 0xB7, 0x9F },
	0xFA7D,	{ 0xE9, 0xB7, 0xA0 },
	0xFA7E,	{ 0xE9, 0xB7, 0xA1 },
	0xFA80,	{ 0xE9, 0xB7, 0xA2 },
	0xFA81,	{ 0xE9, 0xB7, 0xA3 },
	0xFA82,	{ 0xE9, 0xB7, 0xA4 },
	0xFA83,	{ 0xE9, 0xB7, 0xA5 },
	0xFA84,	{ 0xE9, 0xB7, 0xA6 },
	0xFA85,	{ 0xE9, 0xB7, 0xA7 },
	0xFA86,	{ 0xE9, 0xB7, 0xA8 },
	0xFA87,	{ 0xE9, 0xB7, 0xA9 },
	0xFA88,	{ 0xE9, 0xB7, 0xAA },
	0xFA89,	{ 0xE9, 0xB7, 0xAB },
	0xFA8A,	{ 0xE9, 0xB7, 0xAC },
	0xFA8B,	{ 0xE9, 0xB7, 0xAD },
	0xFA8C,	{ 0xE9, 0xB7, 0xAE },
	0xFA8D,	{ 0xE9, 0xB7, 0xAF },
	0xFA8E,	{ 0xE9, 0xB7, 0xB0 },
	0xFA8F,	{ 0xE9, 0xB7, 0xB1 },
	0xFA90,	{ 0xE9, 0xB7, 0xB2 },
	0xFA91,	{ 0xE9, 0xB7, 0xB3 },
	0xFA92,	{ 0xE9, 0xB7, 0xB4 },
	0xFA93,	{ 0xE9, 0xB7, 0xB5 },
	0xFA94,	{ 0xE9, 0xB7, 0xB6 },
	0xFA95,	{ 0xE9, 0xB7, 0xB7 },
	0xFA96,	{ 0xE9, 0xB7, 0xB8 },
	0xFA97,	{ 0xE9, 0xB7, 0xB9 },
	0xFA98,	{ 0xE9, 0xB7, 0xBA },
	0xFA99,	{ 0xE9, 0xB7, 0xBB },
	0xFA9A,	{ 0xE9, 0xB7, 0xBC },
	0xFA9B,	{ 0xE9, 0xB7, 0xBD },
	0xFA9C,	{ 0xE9, 0xB7, 0xBE },
	0xFA9D,	{ 0xE9, 0xB7, 0xBF },
	0xFA9E,	{ 0xE9, 0xB8, 0x80 },
	0xFA9F,	{ 0xE9, 0xB8, 0x81 },
	0xFAA0,	{ 0xE9, 0xB8, 0x82 },
	0xFAA1,	{ 0xEE, 0x8B, 0xB0 },
	0xFAA2,	{ 0xEE, 0x8B, 0xB1 },
	0xFAA3,	{ 0xEE, 0x8B, 0xB2 },
	0xFAA4,	{ 0xEE, 0x8B, 0xB3 },
	0xFAA5,	{ 0xEE, 0x8B, 0xB4 },
	0xFAA6,	{ 0xEE, 0x8B, 0xB5 },
	0xFAA7,	{ 0xEE, 0x8B, 0xB6 },
	0xFAA8,	{ 0xEE, 0x8B, 0xB7 },
	0xFAA9,	{ 0xEE, 0x8B, 0xB8 },
	0xFAAA,	{ 0xEE, 0x8B, 0xB9 },
	0xFAAB,	{ 0xEE, 0x8B, 0xBA },
	0xFAAC,	{ 0xEE, 0x8B, 0xBB },
	0xFAAD,	{ 0xEE, 0x8B, 0xBC },
	0xFAAE,	{ 0xEE, 0x8B, 0xBD },
	0xFAAF,	{ 0xEE, 0x8B, 0xBE },
	0xFAB0,	{ 0xEE, 0x8B, 0xBF },
	0xFAB1,	{ 0xEE, 0x8C, 0x80 },
	0xFAB2,	{ 0xEE, 0x8C, 0x81 },
	0xFAB3,	{ 0xEE, 0x8C, 0x82 },
	0xFAB4,	{ 0xEE, 0x8C, 0x83 },
	0xFAB5,	{ 0xEE, 0x8C, 0x84 },
	0xFAB6,	{ 0xEE, 0x8C, 0x85 },
	0xFAB7,	{ 0xEE, 0x8C, 0x86 },
	0xFAB8,	{ 0xEE, 0x8C, 0x87 },
	0xFAB9,	{ 0xEE, 0x8C, 0x88 },
	0xFABA,	{ 0xEE, 0x8C, 0x89 },
	0xFABB,	{ 0xEE, 0x8C, 0x8A },
	0xFABC,	{ 0xEE, 0x8C, 0x8B },
	0xFABD,	{ 0xEE, 0x8C, 0x8C },
	0xFABE,	{ 0xEE, 0x8C, 0x8D },
	0xFABF,	{ 0xEE, 0x8C, 0x8E },
	0xFAC0,	{ 0xEE, 0x8C, 0x8F },
	0xFAC1,	{ 0xEE, 0x8C, 0x90 },
	0xFAC2,	{ 0xEE, 0x8C, 0x91 },
	0xFAC3,	{ 0xEE, 0x8C, 0x92 },
	0xFAC4,	{ 0xEE, 0x8C, 0x93 },
	0xFAC5,	{ 0xEE, 0x8C, 0x94 },
	0xFAC6,	{ 0xEE, 0x8C, 0x95 },
	0xFAC7,	{ 0xEE, 0x8C, 0x96 },
	0xFAC8,	{ 0xEE, 0x8C, 0x97 },
	0xFAC9,	{ 0xEE, 0x8C, 0x98 },
	0xFACA,	{ 0xEE, 0x8C, 0x99 },
	0xFACB,	{ 0xEE, 0x8C, 0x9A },
	0xFACC,	{ 0xEE, 0x8C, 0x9B },
	0xFACD,	{ 0xEE, 0x8C, 0x9C },
	0xFACE,	{ 0xEE, 0x8C, 0x9D },
	0xFACF,	{ 0xEE, 0x8C, 0x9E },
	0xFAD0,	{ 0xEE, 0x8C, 0x9F },
	0xFAD1,	{ 0xEE, 0x8C, 0xA0 },
	0xFAD2,	{ 0xEE, 0x8C, 0xA1 },
	0xFAD3,	{ 0xEE, 0x8C, 0xA2 },
	0xFAD4,	{ 0xEE, 0x8C, 0xA3 },
	0xFAD5,	{ 0xEE, 0x8C, 0xA4 },
	0xFAD6,	{ 0xEE, 0x8C, 0xA5 },
	0xFAD7,	{ 0xEE, 0x8C, 0xA6 },
	0xFAD8,	{ 0xEE, 0x8C, 0xA7 },
	0xFAD9,	{ 0xEE, 0x8C, 0xA8 },
	0xFADA,	{ 0xEE, 0x8C, 0xA9 },
	0xFADB,	{ 0xEE, 0x8C, 0xAA },
	0xFADC,	{ 0xEE, 0x8C, 0xAB },
	0xFADD,	{ 0xEE, 0x8C, 0xAC },
	0xFADE,	{ 0xEE, 0x8C, 0xAD },
	0xFADF,	{ 0xEE, 0x8C, 0xAE },
	0xFAE0,	{ 0xEE, 0x8C, 0xAF },
	0xFAE1,	{ 0xEE, 0x8C, 0xB0 },
	0xFAE2,	{ 0xEE, 0x8C, 0xB1 },
	0xFAE3,	{ 0xEE, 0x8C, 0xB2 },
	0xFAE4,	{ 0xEE, 0x8C, 0xB3 },
	0xFAE5,	{ 0xEE, 0x8C, 0xB4 },
	0xFAE6,	{ 0xEE, 0x8C, 0xB5 },
	0xFAE7,	{ 0xEE, 0x8C, 0xB6 },
	0xFAE8,	{ 0xEE, 0x8C, 0xB7 },
	0xFAE9,	{ 0xEE, 0x8C, 0xB8 },
	0xFAEA,	{ 0xEE, 0x8C, 0xB9 },
	0xFAEB,	{ 0xEE, 0x8C, 0xBA },
	0xFAEC,	{ 0xEE, 0x8C, 0xBB },
	0xFAED,	{ 0xEE, 0x8C, 0xBC },
	0xFAEE,	{ 0xEE, 0x8C, 0xBD },
	0xFAEF,	{ 0xEE, 0x8C, 0xBE },
	0xFAF0,	{ 0xEE, 0x8C, 0xBF },
	0xFAF1,	{ 0xEE, 0x8D, 0x80 },
	0xFAF2,	{ 0xEE, 0x8D, 0x81 },
	0xFAF3,	{ 0xEE, 0x8D, 0x82 },
	0xFAF4,	{ 0xEE, 0x8D, 0x83 },
	0xFAF5,	{ 0xEE, 0x8D, 0x84 },
	0xFAF6,	{ 0xEE, 0x8D, 0x85 },
	0xFAF7,	{ 0xEE, 0x8D, 0x86 },
	0xFAF8,	{ 0xEE, 0x8D, 0x87 },
	0xFAF9,	{ 0xEE, 0x8D, 0x88 },
	0xFAFA,	{ 0xEE, 0x8D, 0x89 },
	0xFAFB,	{ 0xEE, 0x8D, 0x8A },
	0xFAFC,	{ 0xEE, 0x8D, 0x8B },
	0xFAFD,	{ 0xEE, 0x8D, 0x8C },
	0xFAFE,	{ 0xEE, 0x8D, 0x8D },
	0xFB40,	{ 0xE9, 0xB8, 0x83 },
	0xFB41,	{ 0xE9, 0xB8, 0x84 },
	0xFB42,	{ 0xE9, 0xB8, 0x85 },
	0xFB43,	{ 0xE9, 0xB8, 0x86 },
	0xFB44,	{ 0xE9, 0xB8, 0x87 },
	0xFB45,	{ 0xE9, 0xB8, 0x88 },
	0xFB46,	{ 0xE9, 0xB8, 0x89 },
	0xFB47,	{ 0xE9, 0xB8, 0x8A },
	0xFB48,	{ 0xE9, 0xB8, 0x8B },
	0xFB49,	{ 0xE9, 0xB8, 0x8C },
	0xFB4A,	{ 0xE9, 0xB8, 0x8D },
	0xFB4B,	{ 0xE9, 0xB8, 0x8E },
	0xFB4C,	{ 0xE9, 0xB8, 0x8F },
	0xFB4D,	{ 0xE9, 0xB8, 0x90 },
	0xFB4E,	{ 0xE9, 0xB8, 0x91 },
	0xFB4F,	{ 0xE9, 0xB8, 0x92 },
	0xFB50,	{ 0xE9, 0xB8, 0x93 },
	0xFB51,	{ 0xE9, 0xB8, 0x94 },
	0xFB52,	{ 0xE9, 0xB8, 0x95 },
	0xFB53,	{ 0xE9, 0xB8, 0x96 },
	0xFB54,	{ 0xE9, 0xB8, 0x97 },
	0xFB55,	{ 0xE9, 0xB8, 0x98 },
	0xFB56,	{ 0xE9, 0xB8, 0x99 },
	0xFB57,	{ 0xE9, 0xB8, 0x9A },
	0xFB58,	{ 0xE9, 0xB8, 0x9B },
	0xFB59,	{ 0xE9, 0xB8, 0x9C },
	0xFB5A,	{ 0xE9, 0xB8, 0x9D },
	0xFB5B,	{ 0xE9, 0xB8, 0x9E },
	0xFB5C,	{ 0xE9, 0xB8, 0xA4 },
	0xFB5D,	{ 0xE9, 0xB8, 0xA7 },
	0xFB5E,	{ 0xE9, 0xB8, 0xAE },
	0xFB5F,	{ 0xE9, 0xB8, 0xB0 },
	0xFB60,	{ 0xE9, 0xB8, 0xB4 },
	0xFB61,	{ 0xE9, 0xB8, 0xBB },
	0xFB62,	{ 0xE9, 0xB8, 0xBC },
	0xFB63,	{ 0xE9, 0xB9, 0x80 },
	0xFB64,	{ 0xE9, 0xB9, 0x8D },
	0xFB65,	{ 0xE9, 0xB9, 0x90 },
	0xFB66,	{ 0xE9, 0xB9, 0x92 },
	0xFB67,	{ 0xE9, 0xB9, 0x93 },
	0xFB68,	{ 0xE9, 0xB9, 0x94 },
	0xFB69,	{ 0xE9, 0xB9, 0x96 },
	0xFB6A,	{ 0xE9, 0xB9, 0x99 },
	0xFB6B,	{ 0xE9, 0xB9, 0x9D },
	0xFB6C,	{ 0xE9, 0xB9, 0x9F },
	0xFB6D,	{ 0xE9, 0xB9, 0xA0 },
	0xFB6E,	{ 0xE9, 0xB9, 0xA1 },
	0xFB6F,	{ 0xE9, 0xB9, 0xA2 },
	0xFB70,	{ 0xE9, 0xB9, 0xA5 },
	0xFB71,	{ 0xE9, 0xB9, 0xAE },
	0xFB72,	{ 0xE9, 0xB9, 0xAF },
	0xFB73,	{ 0xE9, 0xB9, 0xB2 },
	0xFB74,	{ 0xE9, 0xB9, 0xB4 },
	0xFB75,	{ 0xE9, 0xB9, 0xB5 },
	0xFB76,	{ 0xE9, 0xB9, 0xB6 },
	0xFB77,	{ 0xE9, 0xB9, 0xB7 },
	0xFB78,	{ 0xE9, 0xB9, 0xB8 },
	0xFB79,	{ 0xE9, 0xB9, 0xB9 },
	0xFB7A,	{ 0xE9, 0xB9, 0xBA },
	0xFB7B,	{ 0xE9, 0xB9, 0xBB },
	0xFB7C,	{ 0xE9, 0xB9, 0xBC },
	0xFB7D,	{ 0xE9, 0xB9, 0xBD },
	0xFB7E,	{ 0xE9, 0xBA, 0x80 },
	0xFB80,	{ 0xE9, 0xBA, 0x81 },
	0xFB81,	{ 0xE9, 0xBA, 0x83 },
	0xFB82,	{ 0xE9, 0xBA, 0x84 },
	0xFB83,	{ 0xE9, 0xBA, 0x85 },
	0xFB84,	{ 0xE9, 0xBA, 0x86 },
	0xFB85,	{ 0xE9, 0xBA, 0x89 },
	0xFB86,	{ 0xE9, 0xBA, 0x8A },
	0xFB87,	{ 0xE9, 0xBA, 0x8C },
	0xFB88,	{ 0xE9, 0xBA, 0x8D },
	0xFB89,	{ 0xE9, 0xBA, 0x8E },
	0xFB8A,	{ 0xE9, 0xBA, 0x8F },
	0xFB8B,	{ 0xE9, 0xBA, 0x90 },
	0xFB8C,	{ 0xE9, 0xBA, 0x91 },
	0xFB8D,	{ 0xE9, 0xBA, 0x94 },
	0xFB8E,	{ 0xE9, 0xBA, 0x95 },
	0xFB8F,	{ 0xE9, 0xBA, 0x96 },
	0xFB90,	{ 0xE9, 0xBA, 0x97 },
	0xFB91,	{ 0xE9, 0xBA, 0x98 },
	0xFB92,	{ 0xE9, 0xBA, 0x99 },
	0xFB93,	{ 0xE9, 0xBA, 0x9A },
	0xFB94,	{ 0xE9, 0xBA, 0x9B },
	0xFB95,	{ 0xE9, 0xBA, 0x9C },
	0xFB96,	{ 0xE9, 0xBA, 0x9E },
	0xFB97,	{ 0xE9, 0xBA, 0xA0 },
	0xFB98,	{ 0xE9, 0xBA, 0xA1 },
	0xFB99,	{ 0xE9, 0xBA, 0xA2 },
	0xFB9A,	{ 0xE9, 0xBA, 0xA3 },
	0xFB9B,	{ 0xE9, 0xBA, 0xA4 },
	0xFB9C,	{ 0xE9, 0xBA, 0xA5 },
	0xFB9D,	{ 0xE9, 0xBA, 0xA7 },
	0xFB9E,	{ 0xE9, 0xBA, 0xA8 },
	0xFB9F,	{ 0xE9, 0xBA, 0xA9 },
	0xFBA0,	{ 0xE9, 0xBA, 0xAA },
	0xFBA1,	{ 0xEE, 0x8D, 0x8E },
	0xFBA2,	{ 0xEE, 0x8D, 0x8F },
	0xFBA3,	{ 0xEE, 0x8D, 0x90 },
	0xFBA4,	{ 0xEE, 0x8D, 0x91 },
	0xFBA5,	{ 0xEE, 0x8D, 0x92 },
	0xFBA6,	{ 0xEE, 0x8D, 0x93 },
	0xFBA7,	{ 0xEE, 0x8D, 0x94 },
	0xFBA8,	{ 0xEE, 0x8D, 0x95 },
	0xFBA9,	{ 0xEE, 0x8D, 0x96 },
	0xFBAA,	{ 0xEE, 0x8D, 0x97 },
	0xFBAB,	{ 0xEE, 0x8D, 0x98 },
	0xFBAC,	{ 0xEE, 0x8D, 0x99 },
	0xFBAD,	{ 0xEE, 0x8D, 0x9A },
	0xFBAE,	{ 0xEE, 0x8D, 0x9B },
	0xFBAF,	{ 0xEE, 0x8D, 0x9C },
	0xFBB0,	{ 0xEE, 0x8D, 0x9D },
	0xFBB1,	{ 0xEE, 0x8D, 0x9E },
	0xFBB2,	{ 0xEE, 0x8D, 0x9F },
	0xFBB3,	{ 0xEE, 0x8D, 0xA0 },
	0xFBB4,	{ 0xEE, 0x8D, 0xA1 },
	0xFBB5,	{ 0xEE, 0x8D, 0xA2 },
	0xFBB6,	{ 0xEE, 0x8D, 0xA3 },
	0xFBB7,	{ 0xEE, 0x8D, 0xA4 },
	0xFBB8,	{ 0xEE, 0x8D, 0xA5 },
	0xFBB9,	{ 0xEE, 0x8D, 0xA6 },
	0xFBBA,	{ 0xEE, 0x8D, 0xA7 },
	0xFBBB,	{ 0xEE, 0x8D, 0xA8 },
	0xFBBC,	{ 0xEE, 0x8D, 0xA9 },
	0xFBBD,	{ 0xEE, 0x8D, 0xAA },
	0xFBBE,	{ 0xEE, 0x8D, 0xAB },
	0xFBBF,	{ 0xEE, 0x8D, 0xAC },
	0xFBC0,	{ 0xEE, 0x8D, 0xAD },
	0xFBC1,	{ 0xEE, 0x8D, 0xAE },
	0xFBC2,	{ 0xEE, 0x8D, 0xAF },
	0xFBC3,	{ 0xEE, 0x8D, 0xB0 },
	0xFBC4,	{ 0xEE, 0x8D, 0xB1 },
	0xFBC5,	{ 0xEE, 0x8D, 0xB2 },
	0xFBC6,	{ 0xEE, 0x8D, 0xB3 },
	0xFBC7,	{ 0xEE, 0x8D, 0xB4 },
	0xFBC8,	{ 0xEE, 0x8D, 0xB5 },
	0xFBC9,	{ 0xEE, 0x8D, 0xB6 },
	0xFBCA,	{ 0xEE, 0x8D, 0xB7 },
	0xFBCB,	{ 0xEE, 0x8D, 0xB8 },
	0xFBCC,	{ 0xEE, 0x8D, 0xB9 },
	0xFBCD,	{ 0xEE, 0x8D, 0xBA },
	0xFBCE,	{ 0xEE, 0x8D, 0xBB },
	0xFBCF,	{ 0xEE, 0x8D, 0xBC },
	0xFBD0,	{ 0xEE, 0x8D, 0xBD },
	0xFBD1,	{ 0xEE, 0x8D, 0xBE },
	0xFBD2,	{ 0xEE, 0x8D, 0xBF },
	0xFBD3,	{ 0xEE, 0x8E, 0x80 },
	0xFBD4,	{ 0xEE, 0x8E, 0x81 },
	0xFBD5,	{ 0xEE, 0x8E, 0x82 },
	0xFBD6,	{ 0xEE, 0x8E, 0x83 },
	0xFBD7,	{ 0xEE, 0x8E, 0x84 },
	0xFBD8,	{ 0xEE, 0x8E, 0x85 },
	0xFBD9,	{ 0xEE, 0x8E, 0x86 },
	0xFBDA,	{ 0xEE, 0x8E, 0x87 },
	0xFBDB,	{ 0xEE, 0x8E, 0x88 },
	0xFBDC,	{ 0xEE, 0x8E, 0x89 },
	0xFBDD,	{ 0xEE, 0x8E, 0x8A },
	0xFBDE,	{ 0xEE, 0x8E, 0x8B },
	0xFBDF,	{ 0xEE, 0x8E, 0x8C },
	0xFBE0,	{ 0xEE, 0x8E, 0x8D },
	0xFBE1,	{ 0xEE, 0x8E, 0x8E },
	0xFBE2,	{ 0xEE, 0x8E, 0x8F },
	0xFBE3,	{ 0xEE, 0x8E, 0x90 },
	0xFBE4,	{ 0xEE, 0x8E, 0x91 },
	0xFBE5,	{ 0xEE, 0x8E, 0x92 },
	0xFBE6,	{ 0xEE, 0x8E, 0x93 },
	0xFBE7,	{ 0xEE, 0x8E, 0x94 },
	0xFBE8,	{ 0xEE, 0x8E, 0x95 },
	0xFBE9,	{ 0xEE, 0x8E, 0x96 },
	0xFBEA,	{ 0xEE, 0x8E, 0x97 },
	0xFBEB,	{ 0xEE, 0x8E, 0x98 },
	0xFBEC,	{ 0xEE, 0x8E, 0x99 },
	0xFBED,	{ 0xEE, 0x8E, 0x9A },
	0xFBEE,	{ 0xEE, 0x8E, 0x9B },
	0xFBEF,	{ 0xEE, 0x8E, 0x9C },
	0xFBF0,	{ 0xEE, 0x8E, 0x9D },
	0xFBF1,	{ 0xEE, 0x8E, 0x9E },
	0xFBF2,	{ 0xEE, 0x8E, 0x9F },
	0xFBF3,	{ 0xEE, 0x8E, 0xA0 },
	0xFBF4,	{ 0xEE, 0x8E, 0xA1 },
	0xFBF5,	{ 0xEE, 0x8E, 0xA2 },
	0xFBF6,	{ 0xEE, 0x8E, 0xA3 },
	0xFBF7,	{ 0xEE, 0x8E, 0xA4 },
	0xFBF8,	{ 0xEE, 0x8E, 0xA5 },
	0xFBF9,	{ 0xEE, 0x8E, 0xA6 },
	0xFBFA,	{ 0xEE, 0x8E, 0xA7 },
	0xFBFB,	{ 0xEE, 0x8E, 0xA8 },
	0xFBFC,	{ 0xEE, 0x8E, 0xA9 },
	0xFBFD,	{ 0xEE, 0x8E, 0xAA },
	0xFBFE,	{ 0xEE, 0x8E, 0xAB },
	0xFC40,	{ 0xE9, 0xBA, 0xAB },
	0xFC41,	{ 0xE9, 0xBA, 0xAC },
	0xFC42,	{ 0xE9, 0xBA, 0xAD },
	0xFC43,	{ 0xE9, 0xBA, 0xAE },
	0xFC44,	{ 0xE9, 0xBA, 0xAF },
	0xFC45,	{ 0xE9, 0xBA, 0xB0 },
	0xFC46,	{ 0xE9, 0xBA, 0xB1 },
	0xFC47,	{ 0xE9, 0xBA, 0xB2 },
	0xFC48,	{ 0xE9, 0xBA, 0xB3 },
	0xFC49,	{ 0xE9, 0xBA, 0xB5 },
	0xFC4A,	{ 0xE9, 0xBA, 0xB6 },
	0xFC4B,	{ 0xE9, 0xBA, 0xB7 },
	0xFC4C,	{ 0xE9, 0xBA, 0xB9 },
	0xFC4D,	{ 0xE9, 0xBA, 0xBA },
	0xFC4E,	{ 0xE9, 0xBA, 0xBC },
	0xFC4F,	{ 0xE9, 0xBA, 0xBF },
	0xFC50,	{ 0xE9, 0xBB, 0x80 },
	0xFC51,	{ 0xE9, 0xBB, 0x81 },
	0xFC52,	{ 0xE9, 0xBB, 0x82 },
	0xFC53,	{ 0xE9, 0xBB, 0x83 },
	0xFC54,	{ 0xE9, 0xBB, 0x85 },
	0xFC55,	{ 0xE9, 0xBB, 0x86 },
	0xFC56,	{ 0xE9, 0xBB, 0x87 },
	0xFC57,	{ 0xE9, 0xBB, 0x88 },
	0xFC58,	{ 0xE9, 0xBB, 0x8A },
	0xFC59,	{ 0xE9, 0xBB, 0x8B },
	0xFC5A,	{ 0xE9, 0xBB, 0x8C },
	0xFC5B,	{ 0xE9, 0xBB, 0x90 },
	0xFC5C,	{ 0xE9, 0xBB, 0x92 },
	0xFC5D,	{ 0xE9, 0xBB, 0x93 },
	0xFC5E,	{ 0xE9, 0xBB, 0x95 },
	0xFC5F,	{ 0xE9, 0xBB, 0x96 },
	0xFC60,	{ 0xE9, 0xBB, 0x97 },
	0xFC61,	{ 0xE9, 0xBB, 0x99 },
	0xFC62,	{ 0xE9, 0xBB, 0x9A },
	0xFC63,	{ 0xE9, 0xBB, 0x9E },
	0xFC64,	{ 0xE9, 0xBB, 0xA1 },
	0xFC65,	{ 0xE9, 0xBB, 0xA3 },
	0xFC66,	{ 0xE9, 0xBB, 0xA4 },
	0xFC67,	{ 0xE9, 0xBB, 0xA6 },
	0xFC68,	{ 0xE9, 0xBB, 0xA8 },
	0xFC69,	{ 0xE9, 0xBB, 0xAB },
	0xFC6A,	{ 0xE9, 0xBB, 0xAC },
	0xFC6B,	{ 0xE9, 0xBB, 0xAD },
	0xFC6C,	{ 0xE9, 0xBB, 0xAE },
	0xFC6D,	{ 0xE9, 0xBB, 0xB0 },
	0xFC6E,	{ 0xE9, 0xBB, 0xB1 },
	0xFC6F,	{ 0xE9, 0xBB, 0xB2 },
	0xFC70,	{ 0xE9, 0xBB, 0xB3 },
	0xFC71,	{ 0xE9, 0xBB, 0xB4 },
	0xFC72,	{ 0xE9, 0xBB, 0xB5 },
	0xFC73,	{ 0xE9, 0xBB, 0xB6 },
	0xFC74,	{ 0xE9, 0xBB, 0xB7 },
	0xFC75,	{ 0xE9, 0xBB, 0xB8 },
	0xFC76,	{ 0xE9, 0xBB, 0xBA },
	0xFC77,	{ 0xE9, 0xBB, 0xBD },
	0xFC78,	{ 0xE9, 0xBB, 0xBF },
	0xFC79,	{ 0xE9, 0xBC, 0x80 },
	0xFC7A,	{ 0xE9, 0xBC, 0x81 },
	0xFC7B,	{ 0xE9, 0xBC, 0x82 },
	0xFC7C,	{ 0xE9, 0xBC, 0x83 },
	0xFC7D,	{ 0xE9, 0xBC, 0x84 },
	0xFC7E,	{ 0xE9, 0xBC, 0x85 },
	0xFC80,	{ 0xE9, 0xBC, 0x86 },
	0xFC81,	{ 0xE9, 0xBC, 0x87 },
	0xFC82,	{ 0xE9, 0xBC, 0x88 },
	0xFC83,	{ 0xE9, 0xBC, 0x89 },
	0xFC84,	{ 0xE9, 0xBC, 0x8A },
	0xFC85,	{ 0xE9, 0xBC, 0x8C },
	0xFC86,	{ 0xE9, 0xBC, 0x8F },
	0xFC87,	{ 0xE9, 0xBC, 0x91 },
	0xFC88,	{ 0xE9, 0xBC, 0x92 },
	0xFC89,	{ 0xE9, 0xBC, 0x94 },
	0xFC8A,	{ 0xE9, 0xBC, 0x95 },
	0xFC8B,	{ 0xE9, 0xBC, 0x96 },
	0xFC8C,	{ 0xE9, 0xBC, 0x98 },
	0xFC8D,	{ 0xE9, 0xBC, 0x9A },
	0xFC8E,	{ 0xE9, 0xBC, 0x9B },
	0xFC8F,	{ 0xE9, 0xBC, 0x9C },
	0xFC90,	{ 0xE9, 0xBC, 0x9D },
	0xFC91,	{ 0xE9, 0xBC, 0x9E },
	0xFC92,	{ 0xE9, 0xBC, 0x9F },
	0xFC93,	{ 0xE9, 0xBC, 0xA1 },
	0xFC94,	{ 0xE9, 0xBC, 0xA3 },
	0xFC95,	{ 0xE9, 0xBC, 0xA4 },
	0xFC96,	{ 0xE9, 0xBC, 0xA5 },
	0xFC97,	{ 0xE9, 0xBC, 0xA6 },
	0xFC98,	{ 0xE9, 0xBC, 0xA7 },
	0xFC99,	{ 0xE9, 0xBC, 0xA8 },
	0xFC9A,	{ 0xE9, 0xBC, 0xA9 },
	0xFC9B,	{ 0xE9, 0xBC, 0xAA },
	0xFC9C,	{ 0xE9, 0xBC, 0xAB },
	0xFC9D,	{ 0xE9, 0xBC, 0xAD },
	0xFC9E,	{ 0xE9, 0xBC, 0xAE },
	0xFC9F,	{ 0xE9, 0xBC, 0xB0 },
	0xFCA0,	{ 0xE9, 0xBC, 0xB1 },
	0xFCA1,	{ 0xEE, 0x8E, 0xAC },
	0xFCA2,	{ 0xEE, 0x8E, 0xAD },
	0xFCA3,	{ 0xEE, 0x8E, 0xAE },
	0xFCA4,	{ 0xEE, 0x8E, 0xAF },
	0xFCA5,	{ 0xEE, 0x8E, 0xB0 },
	0xFCA6,	{ 0xEE, 0x8E, 0xB1 },
	0xFCA7,	{ 0xEE, 0x8E, 0xB2 },
	0xFCA8,	{ 0xEE, 0x8E, 0xB3 },
	0xFCA9,	{ 0xEE, 0x8E, 0xB4 },
	0xFCAA,	{ 0xEE, 0x8E, 0xB5 },
	0xFCAB,	{ 0xEE, 0x8E, 0xB6 },
	0xFCAC,	{ 0xEE, 0x8E, 0xB7 },
	0xFCAD,	{ 0xEE, 0x8E, 0xB8 },
	0xFCAE,	{ 0xEE, 0x8E, 0xB9 },
	0xFCAF,	{ 0xEE, 0x8E, 0xBA },
	0xFCB0,	{ 0xEE, 0x8E, 0xBB },
	0xFCB1,	{ 0xEE, 0x8E, 0xBC },
	0xFCB2,	{ 0xEE, 0x8E, 0xBD },
	0xFCB3,	{ 0xEE, 0x8E, 0xBE },
	0xFCB4,	{ 0xEE, 0x8E, 0xBF },
	0xFCB5,	{ 0xEE, 0x8F, 0x80 },
	0xFCB6,	{ 0xEE, 0x8F, 0x81 },
	0xFCB7,	{ 0xEE, 0x8F, 0x82 },
	0xFCB8,	{ 0xEE, 0x8F, 0x83 },
	0xFCB9,	{ 0xEE, 0x8F, 0x84 },
	0xFCBA,	{ 0xEE, 0x8F, 0x85 },
	0xFCBB,	{ 0xEE, 0x8F, 0x86 },
	0xFCBC,	{ 0xEE, 0x8F, 0x87 },
	0xFCBD,	{ 0xEE, 0x8F, 0x88 },
	0xFCBE,	{ 0xEE, 0x8F, 0x89 },
	0xFCBF,	{ 0xEE, 0x8F, 0x8A },
	0xFCC0,	{ 0xEE, 0x8F, 0x8B },
	0xFCC1,	{ 0xEE, 0x8F, 0x8C },
	0xFCC2,	{ 0xEE, 0x8F, 0x8D },
	0xFCC3,	{ 0xEE, 0x8F, 0x8E },
	0xFCC4,	{ 0xEE, 0x8F, 0x8F },
	0xFCC5,	{ 0xEE, 0x8F, 0x90 },
	0xFCC6,	{ 0xEE, 0x8F, 0x91 },
	0xFCC7,	{ 0xEE, 0x8F, 0x92 },
	0xFCC8,	{ 0xEE, 0x8F, 0x93 },
	0xFCC9,	{ 0xEE, 0x8F, 0x94 },
	0xFCCA,	{ 0xEE, 0x8F, 0x95 },
	0xFCCB,	{ 0xEE, 0x8F, 0x96 },
	0xFCCC,	{ 0xEE, 0x8F, 0x97 },
	0xFCCD,	{ 0xEE, 0x8F, 0x98 },
	0xFCCE,	{ 0xEE, 0x8F, 0x99 },
	0xFCCF,	{ 0xEE, 0x8F, 0x9A },
	0xFCD0,	{ 0xEE, 0x8F, 0x9B },
	0xFCD1,	{ 0xEE, 0x8F, 0x9C },
	0xFCD2,	{ 0xEE, 0x8F, 0x9D },
	0xFCD3,	{ 0xEE, 0x8F, 0x9E },
	0xFCD4,	{ 0xEE, 0x8F, 0x9F },
	0xFCD5,	{ 0xEE, 0x8F, 0xA0 },
	0xFCD6,	{ 0xEE, 0x8F, 0xA1 },
	0xFCD7,	{ 0xEE, 0x8F, 0xA2 },
	0xFCD8,	{ 0xEE, 0x8F, 0xA3 },
	0xFCD9,	{ 0xEE, 0x8F, 0xA4 },
	0xFCDA,	{ 0xEE, 0x8F, 0xA5 },
	0xFCDB,	{ 0xEE, 0x8F, 0xA6 },
	0xFCDC,	{ 0xEE, 0x8F, 0xA7 },
	0xFCDD,	{ 0xEE, 0x8F, 0xA8 },
	0xFCDE,	{ 0xEE, 0x8F, 0xA9 },
	0xFCDF,	{ 0xEE, 0x8F, 0xAA },
	0xFCE0,	{ 0xEE, 0x8F, 0xAB },
	0xFCE1,	{ 0xEE, 0x8F, 0xAC },
	0xFCE2,	{ 0xEE, 0x8F, 0xAD },
	0xFCE3,	{ 0xEE, 0x8F, 0xAE },
	0xFCE4,	{ 0xEE, 0x8F, 0xAF },
	0xFCE5,	{ 0xEE, 0x8F, 0xB0 },
	0xFCE6,	{ 0xEE, 0x8F, 0xB1 },
	0xFCE7,	{ 0xEE, 0x8F, 0xB2 },
	0xFCE8,	{ 0xEE, 0x8F, 0xB3 },
	0xFCE9,	{ 0xEE, 0x8F, 0xB4 },
	0xFCEA,	{ 0xEE, 0x8F, 0xB5 },
	0xFCEB,	{ 0xEE, 0x8F, 0xB6 },
	0xFCEC,	{ 0xEE, 0x8F, 0xB7 },
	0xFCED,	{ 0xEE, 0x8F, 0xB8 },
	0xFCEE,	{ 0xEE, 0x8F, 0xB9 },
	0xFCEF,	{ 0xEE, 0x8F, 0xBA },
	0xFCF0,	{ 0xEE, 0x8F, 0xBB },
	0xFCF1,	{ 0xEE, 0x8F, 0xBC },
	0xFCF2,	{ 0xEE, 0x8F, 0xBD },
	0xFCF3,	{ 0xEE, 0x8F, 0xBE },
	0xFCF4,	{ 0xEE, 0x8F, 0xBF },
	0xFCF5,	{ 0xEE, 0x90, 0x80 },
	0xFCF6,	{ 0xEE, 0x90, 0x81 },
	0xFCF7,	{ 0xEE, 0x90, 0x82 },
	0xFCF8,	{ 0xEE, 0x90, 0x83 },
	0xFCF9,	{ 0xEE, 0x90, 0x84 },
	0xFCFA,	{ 0xEE, 0x90, 0x85 },
	0xFCFB,	{ 0xEE, 0x90, 0x86 },
	0xFCFC,	{ 0xEE, 0x90, 0x87 },
	0xFCFD,	{ 0xEE, 0x90, 0x88 },
	0xFCFE,	{ 0xEE, 0x90, 0x89 },
	0xFD40,	{ 0xE9, 0xBC, 0xB2 },
	0xFD41,	{ 0xE9, 0xBC, 0xB3 },
	0xFD42,	{ 0xE9, 0xBC, 0xB4 },
	0xFD43,	{ 0xE9, 0xBC, 0xB5 },
	0xFD44,	{ 0xE9, 0xBC, 0xB6 },
	0xFD45,	{ 0xE9, 0xBC, 0xB8 },
	0xFD46,	{ 0xE9, 0xBC, 0xBA },
	0xFD47,	{ 0xE9, 0xBC, 0xBC },
	0xFD48,	{ 0xE9, 0xBC, 0xBF },
	0xFD49,	{ 0xE9, 0xBD, 0x80 },
	0xFD4A,	{ 0xE9, 0xBD, 0x81 },
	0xFD4B,	{ 0xE9, 0xBD, 0x82 },
	0xFD4C,	{ 0xE9, 0xBD, 0x83 },
	0xFD4D,	{ 0xE9, 0xBD, 0x85 },
	0xFD4E,	{ 0xE9, 0xBD, 0x86 },
	0xFD4F,	{ 0xE9, 0xBD, 0x87 },
	0xFD50,	{ 0xE9, 0xBD, 0x88 },
	0xFD51,	{ 0xE9, 0xBD, 0x89 },
	0xFD52,	{ 0xE9, 0xBD, 0x8A },
	0xFD53,	{ 0xE9, 0xBD, 0x8B },
	0xFD54,	{ 0xE9, 0xBD, 0x8C },
	0xFD55,	{ 0xE9, 0xBD, 0x8D },
	0xFD56,	{ 0xE9, 0xBD, 0x8E },
	0xFD57,	{ 0xE9, 0xBD, 0x8F },
	0xFD58,	{ 0xE9, 0xBD, 0x92 },
	0xFD59,	{ 0xE9, 0xBD, 0x93 },
	0xFD5A,	{ 0xE9, 0xBD, 0x94 },
	0xFD5B,	{ 0xE9, 0xBD, 0x95 },
	0xFD5C,	{ 0xE9, 0xBD, 0x96 },
	0xFD5D,	{ 0xE9, 0xBD, 0x97 },
	0xFD5E,	{ 0xE9, 0xBD, 0x98 },
	0xFD5F,	{ 0xE9, 0xBD, 0x99 },
	0xFD60,	{ 0xE9, 0xBD, 0x9A },
	0xFD61,	{ 0xE9, 0xBD, 0x9B },
	0xFD62,	{ 0xE9, 0xBD, 0x9C },
	0xFD63,	{ 0xE9, 0xBD, 0x9D },
	0xFD64,	{ 0xE9, 0xBD, 0x9E },
	0xFD65,	{ 0xE9, 0xBD, 0x9F },
	0xFD66,	{ 0xE9, 0xBD, 0xA0 },
	0xFD67,	{ 0xE9, 0xBD, 0xA1 },
	0xFD68,	{ 0xE9, 0xBD, 0xA2 },
	0xFD69,	{ 0xE9, 0xBD, 0xA3 },
	0xFD6A,	{ 0xE9, 0xBD, 0xA4 },
	0xFD6B,	{ 0xE9, 0xBD, 0xA5 },
	0xFD6C,	{ 0xE9, 0xBD, 0xA6 },
	0xFD6D,	{ 0xE9, 0xBD, 0xA7 },
	0xFD6E,	{ 0xE9, 0xBD, 0xA8 },
	0xFD6F,	{ 0xE9, 0xBD, 0xA9 },
	0xFD70,	{ 0xE9, 0xBD, 0xAA },
	0xFD71,	{ 0xE9, 0xBD, 0xAB },
	0xFD72,	{ 0xE9, 0xBD, 0xAC },
	0xFD73,	{ 0xE9, 0xBD, 0xAD },
	0xFD74,	{ 0xE9, 0xBD, 0xAE },
	0xFD75,	{ 0xE9, 0xBD, 0xAF },
	0xFD76,	{ 0xE9, 0xBD, 0xB0 },
	0xFD77,	{ 0xE9, 0xBD, 0xB1 },
	0xFD78,	{ 0xE9, 0xBD, 0xB2 },
	0xFD79,	{ 0xE9, 0xBD, 0xB3 },
	0xFD7A,	{ 0xE9, 0xBD, 0xB4 },
	0xFD7B,	{ 0xE9, 0xBD, 0xB5 },
	0xFD7C,	{ 0xE9, 0xBD, 0xB6 },
	0xFD7D,	{ 0xE9, 0xBD, 0xB7 },
	0xFD7E,	{ 0xE9, 0xBD, 0xB8 },
	0xFD80,	{ 0xE9, 0xBD, 0xB9 },
	0xFD81,	{ 0xE9, 0xBD, 0xBA },
	0xFD82,	{ 0xE9, 0xBD, 0xBB },
	0xFD83,	{ 0xE9, 0xBD, 0xBC },
	0xFD84,	{ 0xE9, 0xBD, 0xBD },
	0xFD85,	{ 0xE9, 0xBD, 0xBE },
	0xFD86,	{ 0xE9, 0xBE, 0x81 },
	0xFD87,	{ 0xE9, 0xBE, 0x82 },
	0xFD88,	{ 0xE9, 0xBE, 0x8D },
	0xFD89,	{ 0xE9, 0xBE, 0x8E },
	0xFD8A,	{ 0xE9, 0xBE, 0x8F },
	0xFD8B,	{ 0xE9, 0xBE, 0x90 },
	0xFD8C,	{ 0xE9, 0xBE, 0x91 },
	0xFD8D,	{ 0xE9, 0xBE, 0x92 },
	0xFD8E,	{ 0xE9, 0xBE, 0x93 },
	0xFD8F,	{ 0xE9, 0xBE, 0x94 },
	0xFD90,	{ 0xE9, 0xBE, 0x95 },
	0xFD91,	{ 0xE9, 0xBE, 0x96 },
	0xFD92,	{ 0xE9, 0xBE, 0x97 },
	0xFD93,	{ 0xE9, 0xBE, 0x98 },
	0xFD94,	{ 0xE9, 0xBE, 0x9C },
	0xFD95,	{ 0xE9, 0xBE, 0x9D },
	0xFD96,	{ 0xE9, 0xBE, 0x9E },
	0xFD97,	{ 0xE9, 0xBE, 0xA1 },
	0xFD98,	{ 0xE9, 0xBE, 0xA2 },
	0xFD99,	{ 0xE9, 0xBE, 0xA3 },
	0xFD9A,	{ 0xE9, 0xBE, 0xA4 },
	0xFD9B,	{ 0xE9, 0xBE, 0xA5 },
	0xFD9C,	{ 0xEF, 0xA4, 0xAC },
	0xFD9D,	{ 0xEF, 0xA5, 0xB9 },
	0xFD9E,	{ 0xEF, 0xA6, 0x95 },
	0xFD9F,	{ 0xEF, 0xA7, 0xA7 },
	0xFDA0,	{ 0xEF, 0xA7, 0xB1 },
	0xFDA1,	{ 0xEE, 0x90, 0x8A },
	0xFDA2,	{ 0xEE, 0x90, 0x8B },
	0xFDA3,	{ 0xEE, 0x90, 0x8C },
	0xFDA4,	{ 0xEE, 0x90, 0x8D },
	0xFDA5,	{ 0xEE, 0x90, 0x8E },
	0xFDA6,	{ 0xEE, 0x90, 0x8F },
	0xFDA7,	{ 0xEE, 0x90, 0x90 },
	0xFDA8,	{ 0xEE, 0x90, 0x91 },
	0xFDA9,	{ 0xEE, 0x90, 0x92 },
	0xFDAA,	{ 0xEE, 0x90, 0x93 },
	0xFDAB,	{ 0xEE, 0x90, 0x94 },
	0xFDAC,	{ 0xEE, 0x90, 0x95 },
	0xFDAD,	{ 0xEE, 0x90, 0x96 },
	0xFDAE,	{ 0xEE, 0x90, 0x97 },
	0xFDAF,	{ 0xEE, 0x90, 0x98 },
	0xFDB0,	{ 0xEE, 0x90, 0x99 },
	0xFDB1,	{ 0xEE, 0x90, 0x9A },
	0xFDB2,	{ 0xEE, 0x90, 0x9B },
	0xFDB3,	{ 0xEE, 0x90, 0x9C },
	0xFDB4,	{ 0xEE, 0x90, 0x9D },
	0xFDB5,	{ 0xEE, 0x90, 0x9E },
	0xFDB6,	{ 0xEE, 0x90, 0x9F },
	0xFDB7,	{ 0xEE, 0x90, 0xA0 },
	0xFDB8,	{ 0xEE, 0x90, 0xA1 },
	0xFDB9,	{ 0xEE, 0x90, 0xA2 },
	0xFDBA,	{ 0xEE, 0x90, 0xA3 },
	0xFDBB,	{ 0xEE, 0x90, 0xA4 },
	0xFDBC,	{ 0xEE, 0x90, 0xA5 },
	0xFDBD,	{ 0xEE, 0x90, 0xA6 },
	0xFDBE,	{ 0xEE, 0x90, 0xA7 },
	0xFDBF,	{ 0xEE, 0x90, 0xA8 },
	0xFDC0,	{ 0xEE, 0x90, 0xA9 },
	0xFDC1,	{ 0xEE, 0x90, 0xAA },
	0xFDC2,	{ 0xEE, 0x90, 0xAB },
	0xFDC3,	{ 0xEE, 0x90, 0xAC },
	0xFDC4,	{ 0xEE, 0x90, 0xAD },
	0xFDC5,	{ 0xEE, 0x90, 0xAE },
	0xFDC6,	{ 0xEE, 0x90, 0xAF },
	0xFDC7,	{ 0xEE, 0x90, 0xB0 },
	0xFDC8,	{ 0xEE, 0x90, 0xB1 },
	0xFDC9,	{ 0xEE, 0x90, 0xB2 },
	0xFDCA,	{ 0xEE, 0x90, 0xB3 },
	0xFDCB,	{ 0xEE, 0x90, 0xB4 },
	0xFDCC,	{ 0xEE, 0x90, 0xB5 },
	0xFDCD,	{ 0xEE, 0x90, 0xB6 },
	0xFDCE,	{ 0xEE, 0x90, 0xB7 },
	0xFDCF,	{ 0xEE, 0x90, 0xB8 },
	0xFDD0,	{ 0xEE, 0x90, 0xB9 },
	0xFDD1,	{ 0xEE, 0x90, 0xBA },
	0xFDD2,	{ 0xEE, 0x90, 0xBB },
	0xFDD3,	{ 0xEE, 0x90, 0xBC },
	0xFDD4,	{ 0xEE, 0x90, 0xBD },
	0xFDD5,	{ 0xEE, 0x90, 0xBE },
	0xFDD6,	{ 0xEE, 0x90, 0xBF },
	0xFDD7,	{ 0xEE, 0x91, 0x80 },
	0xFDD8,	{ 0xEE, 0x91, 0x81 },
	0xFDD9,	{ 0xEE, 0x91, 0x82 },
	0xFDDA,	{ 0xEE, 0x91, 0x83 },
	0xFDDB,	{ 0xEE, 0x91, 0x84 },
	0xFDDC,	{ 0xEE, 0x91, 0x85 },
	0xFDDD,	{ 0xEE, 0x91, 0x86 },
	0xFDDE,	{ 0xEE, 0x91, 0x87 },
	0xFDDF,	{ 0xEE, 0x91, 0x88 },
	0xFDE0,	{ 0xEE, 0x91, 0x89 },
	0xFDE1,	{ 0xEE, 0x91, 0x8A },
	0xFDE2,	{ 0xEE, 0x91, 0x8B },
	0xFDE3,	{ 0xEE, 0x91, 0x8C },
	0xFDE4,	{ 0xEE, 0x91, 0x8D },
	0xFDE5,	{ 0xEE, 0x91, 0x8E },
	0xFDE6,	{ 0xEE, 0x91, 0x8F },
	0xFDE7,	{ 0xEE, 0x91, 0x90 },
	0xFDE8,	{ 0xEE, 0x91, 0x91 },
	0xFDE9,	{ 0xEE, 0x91, 0x92 },
	0xFDEA,	{ 0xEE, 0x91, 0x93 },
	0xFDEB,	{ 0xEE, 0x91, 0x94 },
	0xFDEC,	{ 0xEE, 0x91, 0x95 },
	0xFDED,	{ 0xEE, 0x91, 0x96 },
	0xFDEE,	{ 0xEE, 0x91, 0x97 },
	0xFDEF,	{ 0xEE, 0x91, 0x98 },
	0xFDF0,	{ 0xEE, 0x91, 0x99 },
	0xFDF1,	{ 0xEE, 0x91, 0x9A },
	0xFDF2,	{ 0xEE, 0x91, 0x9B },
	0xFDF3,	{ 0xEE, 0x91, 0x9C },
	0xFDF4,	{ 0xEE, 0x91, 0x9D },
	0xFDF5,	{ 0xEE, 0x91, 0x9E },
	0xFDF6,	{ 0xEE, 0x91, 0x9F },
	0xFDF7,	{ 0xEE, 0x91, 0xA0 },
	0xFDF8,	{ 0xEE, 0x91, 0xA1 },
	0xFDF9,	{ 0xEE, 0x91, 0xA2 },
	0xFDFA,	{ 0xEE, 0x91, 0xA3 },
	0xFDFB,	{ 0xEE, 0x91, 0xA4 },
	0xFDFC,	{ 0xEE, 0x91, 0xA5 },
	0xFDFD,	{ 0xEE, 0x91, 0xA6 },
	0xFDFE,	{ 0xEE, 0x91, 0xA7 },
	0xFE40,	{ 0xEF, 0xA8, 0x8C },
	0xFE41,	{ 0xEF, 0xA8, 0x8D },
	0xFE42,	{ 0xEF, 0xA8, 0x8E },
	0xFE43,	{ 0xEF, 0xA8, 0x8F },
	0xFE44,	{ 0xEF, 0xA8, 0x91 },
	0xFE45,	{ 0xEF, 0xA8, 0x93 },
	0xFE46,	{ 0xEF, 0xA8, 0x94 },
	0xFE47,	{ 0xEF, 0xA8, 0x98 },
	0xFE48,	{ 0xEF, 0xA8, 0x9F },
	0xFE49,	{ 0xEF, 0xA8, 0xA0 },
	0xFE4A,	{ 0xEF, 0xA8, 0xA1 },
	0xFE4B,	{ 0xEF, 0xA8, 0xA3 },
	0xFE4C,	{ 0xEF, 0xA8, 0xA4 },
	0xFE4D,	{ 0xEF, 0xA8, 0xA7 },
	0xFE4E,	{ 0xEF, 0xA8, 0xA8 },
	0xFE4F,	{ 0xEF, 0xA8, 0xA9 },
	0xFE50,	{ 0xE2, 0xBA, 0x81 },
	0xFE51,	{ 0xEE, 0xA0, 0x96 },
	0xFE52,	{ 0xEE, 0xA0, 0x97 },
	0xFE53,	{ 0xEE, 0xA0, 0x98 },
	0xFE54,	{ 0xE2, 0xBA, 0x84 },
	0xFE55,	{ 0xE3, 0x91, 0xB3 },
	0xFE56,	{ 0xE3, 0x91, 0x87 },
	0xFE57,	{ 0xE2, 0xBA, 0x88 },
	0xFE58,	{ 0xE2, 0xBA, 0x8B },
	0xFE59,	{ 0xEE, 0xA0, 0x9E },
	0xFE5A,	{ 0xE3, 0x96, 0x9E },
	0xFE5B,	{ 0xE3, 0x98, 0x9A },
	0xFE5C,	{ 0xE3, 0x98, 0x8E },
	0xFE5D,	{ 0xE2, 0xBA, 0x8C },
	0xFE5E,	{ 0xE2, 0xBA, 0x97 },
	0xFE5F,	{ 0xE3, 0xA5, 0xAE },
	0xFE60,	{ 0xE3, 0xA4, 0x98 },
	0xFE61,	{ 0xEE, 0xA0, 0xA6 },
	0xFE62,	{ 0xE3, 0xA7, 0x8F },
	0xFE63,	{ 0xE3, 0xA7, 0x9F },
	0xFE64,	{ 0xE3, 0xA9, 0xB3 },
	0xFE65,	{ 0xE3, 0xA7, 0x90 },
	0xFE66,	{ 0xEE, 0xA0, 0xAB },
	0xFE67,	{ 0xEE, 0xA0, 0xAC },
	0xFE68,	{ 0xE3, 0xAD, 0x8E },
	0xFE69,	{ 0xE3, 0xB1, 0xAE },
	0xFE6A,	{ 0xE3, 0xB3, 0xA0 },
	0xFE6B,	{ 0xE2, 0xBA, 0xA7 },
	0xFE6C,	{ 0xEE, 0xA0, 0xB1 },
	0xFE6D,	{ 0xEE, 0xA0, 0xB2 },
	0xFE6E,	{ 0xE2, 0xBA, 0xAA },
	0xFE6F,	{ 0xE4, 0x81, 0x96 },
	0xFE70,	{ 0xE4, 0x85, 0x9F },
	0xFE71,	{ 0xE2, 0xBA, 0xAE },
	0xFE72,	{ 0xE4, 0x8C, 0xB7 },
	0xFE73,	{ 0xE2, 0xBA, 0xB3 },
	0xFE74,	{ 0xE2, 0xBA, 0xB6 },
	0xFE75,	{ 0xE2, 0xBA, 0xB7 },
	0xFE76,	{ 0xEE, 0xA0, 0xBB },
	0xFE77,	{ 0xE4, 0x8E, 0xB1 },
	0xFE78,	{ 0xE4, 0x8E, 0xAC },
	0xFE79,	{ 0xE2, 0xBA, 0xBB },
	0xFE7A,	{ 0xE4, 0x8F, 0x9D },
	0xFE7B,	{ 0xE4, 0x93, 0x96 },
	0xFE7C,	{ 0xE4, 0x99, 0xA1 },
	0xFE7D,	{ 0xE4, 0x99, 0x8C },
	0xFE7E,	{ 0xEE, 0xA1, 0x83 },
	0xFE80,	{ 0xE4, 0x9C, 0xA3 },
	0xFE81,	{ 0xE4, 0x9C, 0xA9 },
	0xFE82,	{ 0xE4, 0x9D, 0xBC },
	0xFE83,	{ 0xE4, 0x9E, 0x8D },
	0xFE84,	{ 0xE2, 0xBB, 0x8A },
	0xFE85,	{ 0xE4, 0xA5, 0x87 },
	0xFE86,	{ 0xE4, 0xA5, 0xBA },
	0xFE87,	{ 0xE4, 0xA5, 0xBD },
	0xFE88,	{ 0xE4, 0xA6, 0x82 },
	0xFE89,	{ 0xE4, 0xA6, 0x83 },
	0xFE8A,	{ 0xE4, 0xA6, 0x85 },
	0xFE8B,	{ 0xE4, 0xA6, 0x86 },
	0xFE8C,	{ 0xE4, 0xA6, 0x9F },
	0xFE8D,	{ 0xE4, 0xA6, 0x9B },
	0xFE8E,	{ 0xE4, 0xA6, 0xB7 },
	0xFE8F,	{ 0xE4, 0xA6, 0xB6 },
	0xFE90,	{ 0xEE, 0xA1, 0x94 },
	0xFE91,	{ 0xEE, 0xA1, 0x95 },
	0xFE92,	{ 0xE4, 0xB2, 0xA3 },
	0xFE93,	{ 0xE4, 0xB2, 0x9F },
	0xFE94,	{ 0xE4, 0xB2, 0xA0 },
	0xFE95,	{ 0xE4, 0xB2, 0xA1 },
	0xFE96,	{ 0xE4, 0xB1, 0xB7 },
	0xFE97,	{ 0xE4, 0xB2, 0xA2 },
	0xFE98,	{ 0xE4, 0xB4, 0x93 },
	0xFE99,	{ 0xE4, 0xB4, 0x94 },
	0xFE9A,	{ 0xE4, 0xB4, 0x95 },
	0xFE9B,	{ 0xE4, 0xB4, 0x96 },
	0xFE9C,	{ 0xE4, 0xB4, 0x97 },
	0xFE9D,	{ 0xE4, 0xB4, 0x98 },
	0xFE9E,	{ 0xE4, 0xB4, 0x99 },
	0xFE9F,	{ 0xE4, 0xB6, 0xAE },
	0xFEA0,	{ 0xEE, 0xA1, 0xA4 },
	0xFEA1,	{ 0xEE, 0x91, 0xA8 },
	0xFEA2,	{ 0xEE, 0x91, 0xA9 },
	0xFEA3,	{ 0xEE, 0x91, 0xAA },
	0xFEA4,	{ 0xEE, 0x91, 0xAB },
	0xFEA5,	{ 0xEE, 0x91, 0xAC },
	0xFEA6,	{ 0xEE, 0x91, 0xAD },
	0xFEA7,	{ 0xEE, 0x91, 0xAE },
	0xFEA8,	{ 0xEE, 0x91, 0xAF },
	0xFEA9,	{ 0xEE, 0x91, 0xB0 },
	0xFEAA,	{ 0xEE, 0x91, 0xB1 },
	0xFEAB,	{ 0xEE, 0x91, 0xB2 },
	0xFEAC,	{ 0xEE, 0x91, 0xB3 },
	0xFEAD,	{ 0xEE, 0x91, 0xB4 },
	0xFEAE,	{ 0xEE, 0x91, 0xB5 },
	0xFEAF,	{ 0xEE, 0x91, 0xB6 },
	0xFEB0,	{ 0xEE, 0x91, 0xB7 },
	0xFEB1,	{ 0xEE, 0x91, 0xB8 },
	0xFEB2,	{ 0xEE, 0x91, 0xB9 },
	0xFEB3,	{ 0xEE, 0x91, 0xBA },
	0xFEB4,	{ 0xEE, 0x91, 0xBB },
	0xFEB5,	{ 0xEE, 0x91, 0xBC },
	0xFEB6,	{ 0xEE, 0x91, 0xBD },
	0xFEB7,	{ 0xEE, 0x91, 0xBE },
	0xFEB8,	{ 0xEE, 0x91, 0xBF },
	0xFEB9,	{ 0xEE, 0x92, 0x80 },
	0xFEBA,	{ 0xEE, 0x92, 0x81 },
	0xFEBB,	{ 0xEE, 0x92, 0x82 },
	0xFEBC,	{ 0xEE, 0x92, 0x83 },
	0xFEBD,	{ 0xEE, 0x92, 0x84 },
	0xFEBE,	{ 0xEE, 0x92, 0x85 },
	0xFEBF,	{ 0xEE, 0x92, 0x86 },
	0xFEC0,	{ 0xEE, 0x92, 0x87 },
	0xFEC1,	{ 0xEE, 0x92, 0x88 },
	0xFEC2,	{ 0xEE, 0x92, 0x89 },
	0xFEC3,	{ 0xEE, 0x92, 0x8A },
	0xFEC4,	{ 0xEE, 0x92, 0x8B },
	0xFEC5,	{ 0xEE, 0x92, 0x8C },
	0xFEC6,	{ 0xEE, 0x92, 0x8D },
	0xFEC7,	{ 0xEE, 0x92, 0x8E },
	0xFEC8,	{ 0xEE, 0x92, 0x8F },
	0xFEC9,	{ 0xEE, 0x92, 0x90 },
	0xFECA,	{ 0xEE, 0x92, 0x91 },
	0xFECB,	{ 0xEE, 0x92, 0x92 },
	0xFECC,	{ 0xEE, 0x92, 0x93 },
	0xFECD,	{ 0xEE, 0x92, 0x94 },
	0xFECE,	{ 0xEE, 0x92, 0x95 },
	0xFECF,	{ 0xEE, 0x92, 0x96 },
	0xFED0,	{ 0xEE, 0x92, 0x97 },
	0xFED1,	{ 0xEE, 0x92, 0x98 },
	0xFED2,	{ 0xEE, 0x92, 0x99 },
	0xFED3,	{ 0xEE, 0x92, 0x9A },
	0xFED4,	{ 0xEE, 0x92, 0x9B },
	0xFED5,	{ 0xEE, 0x92, 0x9C },
	0xFED6,	{ 0xEE, 0x92, 0x9D },
	0xFED7,	{ 0xEE, 0x92, 0x9E },
	0xFED8,	{ 0xEE, 0x92, 0x9F },
	0xFED9,	{ 0xEE, 0x92, 0xA0 },
	0xFEDA,	{ 0xEE, 0x92, 0xA1 },
	0xFEDB,	{ 0xEE, 0x92, 0xA2 },
	0xFEDC,	{ 0xEE, 0x92, 0xA3 },
	0xFEDD,	{ 0xEE, 0x92, 0xA4 },
	0xFEDE,	{ 0xEE, 0x92, 0xA5 },
	0xFEDF,	{ 0xEE, 0x92, 0xA6 },
	0xFEE0,	{ 0xEE, 0x92, 0xA7 },
	0xFEE1,	{ 0xEE, 0x92, 0xA8 },
	0xFEE2,	{ 0xEE, 0x92, 0xA9 },
	0xFEE3,	{ 0xEE, 0x92, 0xAA },
	0xFEE4,	{ 0xEE, 0x92, 0xAB },
	0xFEE5,	{ 0xEE, 0x92, 0xAC },
	0xFEE6,	{ 0xEE, 0x92, 0xAD },
	0xFEE7,	{ 0xEE, 0x92, 0xAE },
	0xFEE8,	{ 0xEE, 0x92, 0xAF },
	0xFEE9,	{ 0xEE, 0x92, 0xB0 },
	0xFEEA,	{ 0xEE, 0x92, 0xB1 },
	0xFEEB,	{ 0xEE, 0x92, 0xB2 },
	0xFEEC,	{ 0xEE, 0x92, 0xB3 },
	0xFEED,	{ 0xEE, 0x92, 0xB4 },
	0xFEEE,	{ 0xEE, 0x92, 0xB5 },
	0xFEEF,	{ 0xEE, 0x92, 0xB6 },
	0xFEF0,	{ 0xEE, 0x92, 0xB7 },
	0xFEF1,	{ 0xEE, 0x92, 0xB8 },
	0xFEF2,	{ 0xEE, 0x92, 0xB9 },
	0xFEF3,	{ 0xEE, 0x92, 0xBA },
	0xFEF4,	{ 0xEE, 0x92, 0xBB },
	0xFEF5,	{ 0xEE, 0x92, 0xBC },
	0xFEF6,	{ 0xEE, 0x92, 0xBD },
	0xFEF7,	{ 0xEE, 0x92, 0xBE },
	0xFEF8,	{ 0xEE, 0x92, 0xBF },
	0xFEF9,	{ 0xEE, 0x93, 0x80 },
	0xFEFA,	{ 0xEE, 0x93, 0x81 },
	0xFEFB,	{ 0xEE, 0x93, 0x82 },
	0xFEFC,	{ 0xEE, 0x93, 0x83 },
	0xFEFD,	{ 0xEE, 0x93, 0x84 },
	0xFEFE,	{ 0xEE, 0x93, 0x85 }
};

static kiconv_table_array_t kiconv_gbk4_utf8[] = {
	0x00000000,	{ 0xEF, 0xBF, 0xBD },
	0x81308130,	{ 0xC2, 0x80 },
	0x81308131,	{ 0xC2, 0x81 },
	0x81308132,	{ 0xC2, 0x82 },
	0x81308133,	{ 0xC2, 0x83 },
	0x81308134,	{ 0xC2, 0x84 },
	0x81308135,	{ 0xC2, 0x85 },
	0x81308136,	{ 0xC2, 0x86 },
	0x81308137,	{ 0xC2, 0x87 },
	0x81308138,	{ 0xC2, 0x88 },
	0x81308139,	{ 0xC2, 0x89 },
	0x81308230,	{ 0xC2, 0x8A },
	0x81308231,	{ 0xC2, 0x8B },
	0x81308232,	{ 0xC2, 0x8C },
	0x81308233,	{ 0xC2, 0x8D },
	0x81308234,	{ 0xC2, 0x8E },
	0x81308235,	{ 0xC2, 0x8F },
	0x81308236,	{ 0xC2, 0x90 },
	0x81308237,	{ 0xC2, 0x91 },
	0x81308238,	{ 0xC2, 0x92 },
	0x81308239,	{ 0xC2, 0x93 },
	0x81308330,	{ 0xC2, 0x94 },
	0x81308331,	{ 0xC2, 0x95 },
	0x81308332,	{ 0xC2, 0x96 },
	0x81308333,	{ 0xC2, 0x97 },
	0x81308334,	{ 0xC2, 0x98 },
	0x81308335,	{ 0xC2, 0x99 },
	0x81308336,	{ 0xC2, 0x9A },
	0x81308337,	{ 0xC2, 0x9B },
	0x81308338,	{ 0xC2, 0x9C },
	0x81308339,	{ 0xC2, 0x9D },
	0x81308430,	{ 0xC2, 0x9E },
	0x81308431,	{ 0xC2, 0x9F },
	0x81308432,	{ 0xC2, 0xA0 },
	0x81308433,	{ 0xC2, 0xA1 },
	0x81308434,	{ 0xC2, 0xA2 },
	0x81308435,	{ 0xC2, 0xA3 },
	0x81308436,	{ 0xC2, 0xA5 },
	0x81308437,	{ 0xC2, 0xA6 },
	0x81308438,	{ 0xC2, 0xA9 },
	0x81308439,	{ 0xC2, 0xAA },
	0x81308530,	{ 0xC2, 0xAB },
	0x81308531,	{ 0xC2, 0xAC },
	0x81308532,	{ 0xC2, 0xAD },
	0x81308533,	{ 0xC2, 0xAE },
	0x81308534,	{ 0xC2, 0xAF },
	0x81308535,	{ 0xC2, 0xB2 },
	0x81308536,	{ 0xC2, 0xB3 },
	0x81308537,	{ 0xC2, 0xB4 },
	0x81308538,	{ 0xC2, 0xB5 },
	0x81308539,	{ 0xC2, 0xB6 },
	0x81308630,	{ 0xC2, 0xB8 },
	0x81308631,	{ 0xC2, 0xB9 },
	0x81308632,	{ 0xC2, 0xBA },
	0x81308633,	{ 0xC2, 0xBB },
	0x81308634,	{ 0xC2, 0xBC },
	0x81308635,	{ 0xC2, 0xBD },
	0x81308636,	{ 0xC2, 0xBE },
	0x81308637,	{ 0xC2, 0xBF },
	0x81308638,	{ 0xC3, 0x80 },
	0x81308639,	{ 0xC3, 0x81 },
	0x81308730,	{ 0xC3, 0x82 },
	0x81308731,	{ 0xC3, 0x83 },
	0x81308732,	{ 0xC3, 0x84 },
	0x81308733,	{ 0xC3, 0x85 },
	0x81308734,	{ 0xC3, 0x86 },
	0x81308735,	{ 0xC3, 0x87 },
	0x81308736,	{ 0xC3, 0x88 },
	0x81308737,	{ 0xC3, 0x89 },
	0x81308738,	{ 0xC3, 0x8A },
	0x81308739,	{ 0xC3, 0x8B },
	0x81308830,	{ 0xC3, 0x8C },
	0x81308831,	{ 0xC3, 0x8D },
	0x81308832,	{ 0xC3, 0x8E },
	0x81308833,	{ 0xC3, 0x8F },
	0x81308834,	{ 0xC3, 0x90 },
	0x81308835,	{ 0xC3, 0x91 },
	0x81308836,	{ 0xC3, 0x92 },
	0x81308837,	{ 0xC3, 0x93 },
	0x81308838,	{ 0xC3, 0x94 },
	0x81308839,	{ 0xC3, 0x95 },
	0x81308930,	{ 0xC3, 0x96 },
	0x81308931,	{ 0xC3, 0x98 },
	0x81308932,	{ 0xC3, 0x99 },
	0x81308933,	{ 0xC3, 0x9A },
	0x81308934,	{ 0xC3, 0x9B },
	0x81308935,	{ 0xC3, 0x9C },
	0x81308936,	{ 0xC3, 0x9D },
	0x81308937,	{ 0xC3, 0x9E },
	0x81308938,	{ 0xC3, 0x9F },
	0x81308939,	{ 0xC3, 0xA2 },
	0x81308A30,	{ 0xC3, 0xA3 },
	0x81308A31,	{ 0xC3, 0xA4 },
	0x81308A32,	{ 0xC3, 0xA5 },
	0x81308A33,	{ 0xC3, 0xA6 },
	0x81308A34,	{ 0xC3, 0xA7 },
	0x81308A35,	{ 0xC3, 0xAB },
	0x81308A36,	{ 0xC3, 0xAE },
	0x81308A37,	{ 0xC3, 0xAF },
	0x81308A38,	{ 0xC3, 0xB0 },
	0x81308A39,	{ 0xC3, 0xB1 },
	0x81308B30,	{ 0xC3, 0xB4 },
	0x81308B31,	{ 0xC3, 0xB5 },
	0x81308B32,	{ 0xC3, 0xB6 },
	0x81308B33,	{ 0xC3, 0xB8 },
	0x81308B34,	{ 0xC3, 0xBB },
	0x81308B35,	{ 0xC3, 0xBD },
	0x81308B36,	{ 0xC3, 0xBE },
	0x81308B37,	{ 0xC3, 0xBF },
	0x81308B38,	{ 0xC4, 0x80 },
	0x81308B39,	{ 0xC4, 0x82 },
	0x81308C30,	{ 0xC4, 0x83 },
	0x81308C31,	{ 0xC4, 0x84 },
	0x81308C32,	{ 0xC4, 0x85 },
	0x81308C33,	{ 0xC4, 0x86 },
	0x81308C34,	{ 0xC4, 0x87 },
	0x81308C35,	{ 0xC4, 0x88 },
	0x81308C36,	{ 0xC4, 0x89 },
	0x81308C37,	{ 0xC4, 0x8A },
	0x81308C38,	{ 0xC4, 0x8B },
	0x81308C39,	{ 0xC4, 0x8C },
	0x81308D30,	{ 0xC4, 0x8D },
	0x81308D31,	{ 0xC4, 0x8E },
	0x81308D32,	{ 0xC4, 0x8F },
	0x81308D33,	{ 0xC4, 0x90 },
	0x81308D34,	{ 0xC4, 0x91 },
	0x81308D35,	{ 0xC4, 0x92 },
	0x81308D36,	{ 0xC4, 0x94 },
	0x81308D37,	{ 0xC4, 0x95 },
	0x81308D38,	{ 0xC4, 0x96 },
	0x81308D39,	{ 0xC4, 0x97 },
	0x81308E30,	{ 0xC4, 0x98 },
	0x81308E31,	{ 0xC4, 0x99 },
	0x81308E32,	{ 0xC4, 0x9A },
	0x81308E33,	{ 0xC4, 0x9C },
	0x81308E34,	{ 0xC4, 0x9D },
	0x81308E35,	{ 0xC4, 0x9E },
	0x81308E36,	{ 0xC4, 0x9F },
	0x81308E37,	{ 0xC4, 0xA0 },
	0x81308E38,	{ 0xC4, 0xA1 },
	0x81308E39,	{ 0xC4, 0xA2 },
	0x81308F30,	{ 0xC4, 0xA3 },
	0x81308F31,	{ 0xC4, 0xA4 },
	0x81308F32,	{ 0xC4, 0xA5 },
	0x81308F33,	{ 0xC4, 0xA6 },
	0x81308F34,	{ 0xC4, 0xA7 },
	0x81308F35,	{ 0xC4, 0xA8 },
	0x81308F36,	{ 0xC4, 0xA9 },
	0x81308F37,	{ 0xC4, 0xAA },
	0x81308F38,	{ 0xC4, 0xAC },
	0x81308F39,	{ 0xC4, 0xAD },
	0x81309030,	{ 0xC4, 0xAE },
	0x81309031,	{ 0xC4, 0xAF },
	0x81309032,	{ 0xC4, 0xB0 },
	0x81309033,	{ 0xC4, 0xB1 },
	0x81309034,	{ 0xC4, 0xB2 },
	0x81309035,	{ 0xC4, 0xB3 },
	0x81309036,	{ 0xC4, 0xB4 },
	0x81309037,	{ 0xC4, 0xB5 },
	0x81309038,	{ 0xC4, 0xB6 },
	0x81309039,	{ 0xC4, 0xB7 },
	0x81309130,	{ 0xC4, 0xB8 },
	0x81309131,	{ 0xC4, 0xB9 },
	0x81309132,	{ 0xC4, 0xBA },
	0x81309133,	{ 0xC4, 0xBB },
	0x81309134,	{ 0xC4, 0xBC },
	0x81309135,	{ 0xC4, 0xBD },
	0x81309136,	{ 0xC4, 0xBE },
	0x81309137,	{ 0xC4, 0xBF },
	0x81309138,	{ 0xC5, 0x80 },
	0x81309139,	{ 0xC5, 0x81 },
	0x81309230,	{ 0xC5, 0x82 },
	0x81309231,	{ 0xC5, 0x83 },
	0x81309232,	{ 0xC5, 0x85 },
	0x81309233,	{ 0xC5, 0x86 },
	0x81309234,	{ 0xC5, 0x87 },
	0x81309235,	{ 0xC5, 0x89 },
	0x81309236,	{ 0xC5, 0x8A },
	0x81309237,	{ 0xC5, 0x8B },
	0x81309238,	{ 0xC5, 0x8C },
	0x81309239,	{ 0xC5, 0x8E },
	0x81309330,	{ 0xC5, 0x8F },
	0x81309331,	{ 0xC5, 0x90 },
	0x81309332,	{ 0xC5, 0x91 },
	0x81309333,	{ 0xC5, 0x92 },
	0x81309334,	{ 0xC5, 0x93 },
	0x81309335,	{ 0xC5, 0x94 },
	0x81309336,	{ 0xC5, 0x95 },
	0x81309337,	{ 0xC5, 0x96 },
	0x81309338,	{ 0xC5, 0x97 },
	0x81309339,	{ 0xC5, 0x98 },
	0x81309430,	{ 0xC5, 0x99 },
	0x81309431,	{ 0xC5, 0x9A },
	0x81309432,	{ 0xC5, 0x9B },
	0x81309433,	{ 0xC5, 0x9C },
	0x81309434,	{ 0xC5, 0x9D },
	0x81309435,	{ 0xC5, 0x9E },
	0x81309436,	{ 0xC5, 0x9F },
	0x81309437,	{ 0xC5, 0xA0 },
	0x81309438,	{ 0xC5, 0xA1 },
	0x81309439,	{ 0xC5, 0xA2 },
	0x81309530,	{ 0xC5, 0xA3 },
	0x81309531,	{ 0xC5, 0xA4 },
	0x81309532,	{ 0xC5, 0xA5 },
	0x81309533,	{ 0xC5, 0xA6 },
	0x81309534,	{ 0xC5, 0xA7 },
	0x81309535,	{ 0xC5, 0xA8 },
	0x81309536,	{ 0xC5, 0xA9 },
	0x81309537,	{ 0xC5, 0xAA },
	0x81309538,	{ 0xC5, 0xAC },
	0x81309539,	{ 0xC5, 0xAD },
	0x81309630,	{ 0xC5, 0xAE },
	0x81309631,	{ 0xC5, 0xAF },
	0x81309632,	{ 0xC5, 0xB0 },
	0x81309633,	{ 0xC5, 0xB1 },
	0x81309634,	{ 0xC5, 0xB2 },
	0x81309635,	{ 0xC5, 0xB3 },
	0x81309636,	{ 0xC5, 0xB4 },
	0x81309637,	{ 0xC5, 0xB5 },
	0x81309638,	{ 0xC5, 0xB6 },
	0x81309639,	{ 0xC5, 0xB7 },
	0x81309730,	{ 0xC5, 0xB8 },
	0x81309731,	{ 0xC5, 0xB9 },
	0x81309732,	{ 0xC5, 0xBA },
	0x81309733,	{ 0xC5, 0xBB },
	0x81309734,	{ 0xC5, 0xBC },
	0x81309735,	{ 0xC5, 0xBD },
	0x81309736,	{ 0xC5, 0xBE },
	0x81309737,	{ 0xC5, 0xBF },
	0x81309738,	{ 0xC6, 0x80 },
	0x81309739,	{ 0xC6, 0x81 },
	0x81309830,	{ 0xC6, 0x82 },
	0x81309831,	{ 0xC6, 0x83 },
	0x81309832,	{ 0xC6, 0x84 },
	0x81309833,	{ 0xC6, 0x85 },
	0x81309834,	{ 0xC6, 0x86 },
	0x81309835,	{ 0xC6, 0x87 },
	0x81309836,	{ 0xC6, 0x88 },
	0x81309837,	{ 0xC6, 0x89 },
	0x81309838,	{ 0xC6, 0x8A },
	0x81309839,	{ 0xC6, 0x8B },
	0x81309930,	{ 0xC6, 0x8C },
	0x81309931,	{ 0xC6, 0x8D },
	0x81309932,	{ 0xC6, 0x8E },
	0x81309933,	{ 0xC6, 0x8F },
	0x81309934,	{ 0xC6, 0x90 },
	0x81309935,	{ 0xC6, 0x91 },
	0x81309936,	{ 0xC6, 0x92 },
	0x81309937,	{ 0xC6, 0x93 },
	0x81309938,	{ 0xC6, 0x94 },
	0x81309939,	{ 0xC6, 0x95 },
	0x81309A30,	{ 0xC6, 0x96 },
	0x81309A31,	{ 0xC6, 0x97 },
	0x81309A32,	{ 0xC6, 0x98 },
	0x81309A33,	{ 0xC6, 0x99 },
	0x81309A34,	{ 0xC6, 0x9A },
	0x81309A35,	{ 0xC6, 0x9B },
	0x81309A36,	{ 0xC6, 0x9C },
	0x81309A37,	{ 0xC6, 0x9D },
	0x81309A38,	{ 0xC6, 0x9E },
	0x81309A39,	{ 0xC6, 0x9F },
	0x81309B30,	{ 0xC6, 0xA0 },
	0x81309B31,	{ 0xC6, 0xA1 },
	0x81309B32,	{ 0xC6, 0xA2 },
	0x81309B33,	{ 0xC6, 0xA3 },
	0x81309B34,	{ 0xC6, 0xA4 },
	0x81309B35,	{ 0xC6, 0xA5 },
	0x81309B36,	{ 0xC6, 0xA6 },
	0x81309B37,	{ 0xC6, 0xA7 },
	0x81309B38,	{ 0xC6, 0xA8 },
	0x81309B39,	{ 0xC6, 0xA9 },
	0x81309C30,	{ 0xC6, 0xAA },
	0x81309C31,	{ 0xC6, 0xAB },
	0x81309C32,	{ 0xC6, 0xAC },
	0x81309C33,	{ 0xC6, 0xAD },
	0x81309C34,	{ 0xC6, 0xAE },
	0x81309C35,	{ 0xC6, 0xAF },
	0x81309C36,	{ 0xC6, 0xB0 },
	0x81309C37,	{ 0xC6, 0xB1 },
	0x81309C38,	{ 0xC6, 0xB2 },
	0x81309C39,	{ 0xC6, 0xB3 },
	0x81309D30,	{ 0xC6, 0xB4 },
	0x81309D31,	{ 0xC6, 0xB5 },
	0x81309D32,	{ 0xC6, 0xB6 },
	0x81309D33,	{ 0xC6, 0xB7 },
	0x81309D34,	{ 0xC6, 0xB8 },
	0x81309D35,	{ 0xC6, 0xB9 },
	0x81309D36,	{ 0xC6, 0xBA },
	0x81309D37,	{ 0xC6, 0xBB },
	0x81309D38,	{ 0xC6, 0xBC },
	0x81309D39,	{ 0xC6, 0xBD },
	0x81309E30,	{ 0xC6, 0xBE },
	0x81309E31,	{ 0xC6, 0xBF },
	0x81309E32,	{ 0xC7, 0x80 },
	0x81309E33,	{ 0xC7, 0x81 },
	0x81309E34,	{ 0xC7, 0x82 },
	0x81309E35,	{ 0xC7, 0x83 },
	0x81309E36,	{ 0xC7, 0x84 },
	0x81309E37,	{ 0xC7, 0x85 },
	0x81309E38,	{ 0xC7, 0x86 },
	0x81309E39,	{ 0xC7, 0x87 },
	0x81309F30,	{ 0xC7, 0x88 },
	0x81309F31,	{ 0xC7, 0x89 },
	0x81309F32,	{ 0xC7, 0x8A },
	0x81309F33,	{ 0xC7, 0x8B },
	0x81309F34,	{ 0xC7, 0x8C },
	0x81309F35,	{ 0xC7, 0x8D },
	0x81309F36,	{ 0xC7, 0x8F },
	0x81309F37,	{ 0xC7, 0x91 },
	0x81309F38,	{ 0xC7, 0x93 },
	0x81309F39,	{ 0xC7, 0x95 },
	0x8130A030,	{ 0xC7, 0x97 },
	0x8130A031,	{ 0xC7, 0x99 },
	0x8130A032,	{ 0xC7, 0x9B },
	0x8130A033,	{ 0xC7, 0x9D },
	0x8130A034,	{ 0xC7, 0x9E },
	0x8130A035,	{ 0xC7, 0x9F },
	0x8130A036,	{ 0xC7, 0xA0 },
	0x8130A037,	{ 0xC7, 0xA1 },
	0x8130A038,	{ 0xC7, 0xA2 },
	0x8130A039,	{ 0xC7, 0xA3 },
	0x8130A130,	{ 0xC7, 0xA4 },
	0x8130A131,	{ 0xC7, 0xA5 },
	0x8130A132,	{ 0xC7, 0xA6 },
	0x8130A133,	{ 0xC7, 0xA7 },
	0x8130A134,	{ 0xC7, 0xA8 },
	0x8130A135,	{ 0xC7, 0xA9 },
	0x8130A136,	{ 0xC7, 0xAA },
	0x8130A137,	{ 0xC7, 0xAB },
	0x8130A138,	{ 0xC7, 0xAC },
	0x8130A139,	{ 0xC7, 0xAD },
	0x8130A230,	{ 0xC7, 0xAE },
	0x8130A231,	{ 0xC7, 0xAF },
	0x8130A232,	{ 0xC7, 0xB0 },
	0x8130A233,	{ 0xC7, 0xB1 },
	0x8130A234,	{ 0xC7, 0xB2 },
	0x8130A235,	{ 0xC7, 0xB3 },
	0x8130A236,	{ 0xC7, 0xB4 },
	0x8130A237,	{ 0xC7, 0xB5 },
	0x8130A238,	{ 0xC7, 0xB6 },
	0x8130A239,	{ 0xC7, 0xB7 },
	0x8130A330,	{ 0xC7, 0xB8 },
	0x8130A331,	{ 0xC7, 0xBA },
	0x8130A332,	{ 0xC7, 0xBB },
	0x8130A333,	{ 0xC7, 0xBC },
	0x8130A334,	{ 0xC7, 0xBD },
	0x8130A335,	{ 0xC7, 0xBE },
	0x8130A336,	{ 0xC7, 0xBF },
	0x8130A337,	{ 0xC8, 0x80 },
	0x8130A338,	{ 0xC8, 0x81 },
	0x8130A339,	{ 0xC8, 0x82 },
	0x8130A430,	{ 0xC8, 0x83 },
	0x8130A431,	{ 0xC8, 0x84 },
	0x8130A432,	{ 0xC8, 0x85 },
	0x8130A433,	{ 0xC8, 0x86 },
	0x8130A434,	{ 0xC8, 0x87 },
	0x8130A435,	{ 0xC8, 0x88 },
	0x8130A436,	{ 0xC8, 0x89 },
	0x8130A437,	{ 0xC8, 0x8A },
	0x8130A438,	{ 0xC8, 0x8B },
	0x8130A439,	{ 0xC8, 0x8C },
	0x8130A530,	{ 0xC8, 0x8D },
	0x8130A531,	{ 0xC8, 0x8E },
	0x8130A532,	{ 0xC8, 0x8F },
	0x8130A533,	{ 0xC8, 0x90 },
	0x8130A534,	{ 0xC8, 0x91 },
	0x8130A535,	{ 0xC8, 0x92 },
	0x8130A536,	{ 0xC8, 0x93 },
	0x8130A537,	{ 0xC8, 0x94 },
	0x8130A538,	{ 0xC8, 0x95 },
	0x8130A539,	{ 0xC8, 0x96 },
	0x8130A630,	{ 0xC8, 0x97 },
	0x8130A631,	{ 0xC8, 0x98 },
	0x8130A632,	{ 0xC8, 0x99 },
	0x8130A633,	{ 0xC8, 0x9A },
	0x8130A634,	{ 0xC8, 0x9B },
	0x8130A635,	{ 0xC8, 0x9C },
	0x8130A636,	{ 0xC8, 0x9D },
	0x8130A637,	{ 0xC8, 0x9E },
	0x8130A638,	{ 0xC8, 0x9F },
	0x8130A639,	{ 0xC8, 0xA0 },
	0x8130A730,	{ 0xC8, 0xA1 },
	0x8130A731,	{ 0xC8, 0xA2 },
	0x8130A732,	{ 0xC8, 0xA3 },
	0x8130A733,	{ 0xC8, 0xA4 },
	0x8130A734,	{ 0xC8, 0xA5 },
	0x8130A735,	{ 0xC8, 0xA6 },
	0x8130A736,	{ 0xC8, 0xA7 },
	0x8130A737,	{ 0xC8, 0xA8 },
	0x8130A738,	{ 0xC8, 0xA9 },
	0x8130A739,	{ 0xC8, 0xAA },
	0x8130A830,	{ 0xC8, 0xAB },
	0x8130A831,	{ 0xC8, 0xAC },
	0x8130A832,	{ 0xC8, 0xAD },
	0x8130A833,	{ 0xC8, 0xAE },
	0x8130A834,	{ 0xC8, 0xAF },
	0x8130A835,	{ 0xC8, 0xB0 },
	0x8130A836,	{ 0xC8, 0xB1 },
	0x8130A837,	{ 0xC8, 0xB2 },
	0x8130A838,	{ 0xC8, 0xB3 },
	0x8130A839,	{ 0xC8, 0xB4 },
	0x8130A930,	{ 0xC8, 0xB5 },
	0x8130A931,	{ 0xC8, 0xB6 },
	0x8130A932,	{ 0xC8, 0xB7 },
	0x8130A933,	{ 0xC8, 0xB8 },
	0x8130A934,	{ 0xC8, 0xB9 },
	0x8130A935,	{ 0xC8, 0xBA },
	0x8130A936,	{ 0xC8, 0xBB },
	0x8130A937,	{ 0xC8, 0xBC },
	0x8130A938,	{ 0xC8, 0xBD },
	0x8130A939,	{ 0xC8, 0xBE },
	0x8130AA30,	{ 0xC8, 0xBF },
	0x8130AA31,	{ 0xC9, 0x80 },
	0x8130AA32,	{ 0xC9, 0x81 },
	0x8130AA33,	{ 0xC9, 0x82 },
	0x8130AA34,	{ 0xC9, 0x83 },
	0x8130AA35,	{ 0xC9, 0x84 },
	0x8130AA36,	{ 0xC9, 0x85 },
	0x8130AA37,	{ 0xC9, 0x86 },
	0x8130AA38,	{ 0xC9, 0x87 },
	0x8130AA39,	{ 0xC9, 0x88 },
	0x8130AB30,	{ 0xC9, 0x89 },
	0x8130AB31,	{ 0xC9, 0x8A },
	0x8130AB32,	{ 0xC9, 0x8B },
	0x8130AB33,	{ 0xC9, 0x8C },
	0x8130AB34,	{ 0xC9, 0x8D },
	0x8130AB35,	{ 0xC9, 0x8E },
	0x8130AB36,	{ 0xC9, 0x8F },
	0x8130AB37,	{ 0xC9, 0x90 },
	0x8130AB38,	{ 0xC9, 0x92 },
	0x8130AB39,	{ 0xC9, 0x93 },
	0x8130AC30,	{ 0xC9, 0x94 },
	0x8130AC31,	{ 0xC9, 0x95 },
	0x8130AC32,	{ 0xC9, 0x96 },
	0x8130AC33,	{ 0xC9, 0x97 },
	0x8130AC34,	{ 0xC9, 0x98 },
	0x8130AC35,	{ 0xC9, 0x99 },
	0x8130AC36,	{ 0xC9, 0x9A },
	0x8130AC37,	{ 0xC9, 0x9B },
	0x8130AC38,	{ 0xC9, 0x9C },
	0x8130AC39,	{ 0xC9, 0x9D },
	0x8130AD30,	{ 0xC9, 0x9E },
	0x8130AD31,	{ 0xC9, 0x9F },
	0x8130AD32,	{ 0xC9, 0xA0 },
	0x8130AD33,	{ 0xC9, 0xA2 },
	0x8130AD34,	{ 0xC9, 0xA3 },
	0x8130AD35,	{ 0xC9, 0xA4 },
	0x8130AD36,	{ 0xC9, 0xA5 },
	0x8130AD37,	{ 0xC9, 0xA6 },
	0x8130AD38,	{ 0xC9, 0xA7 },
	0x8130AD39,	{ 0xC9, 0xA8 },
	0x8130AE30,	{ 0xC9, 0xA9 },
	0x8130AE31,	{ 0xC9, 0xAA },
	0x8130AE32,	{ 0xC9, 0xAB },
	0x8130AE33,	{ 0xC9, 0xAC },
	0x8130AE34,	{ 0xC9, 0xAD },
	0x8130AE35,	{ 0xC9, 0xAE },
	0x8130AE36,	{ 0xC9, 0xAF },
	0x8130AE37,	{ 0xC9, 0xB0 },
	0x8130AE38,	{ 0xC9, 0xB1 },
	0x8130AE39,	{ 0xC9, 0xB2 },
	0x8130AF30,	{ 0xC9, 0xB3 },
	0x8130AF31,	{ 0xC9, 0xB4 },
	0x8130AF32,	{ 0xC9, 0xB5 },
	0x8130AF33,	{ 0xC9, 0xB6 },
	0x8130AF34,	{ 0xC9, 0xB7 },
	0x8130AF35,	{ 0xC9, 0xB8 },
	0x8130AF36,	{ 0xC9, 0xB9 },
	0x8130AF37,	{ 0xC9, 0xBA },
	0x8130AF38,	{ 0xC9, 0xBB },
	0x8130AF39,	{ 0xC9, 0xBC },
	0x8130B030,	{ 0xC9, 0xBD },
	0x8130B031,	{ 0xC9, 0xBE },
	0x8130B032,	{ 0xC9, 0xBF },
	0x8130B033,	{ 0xCA, 0x80 },
	0x8130B034,	{ 0xCA, 0x81 },
	0x8130B035,	{ 0xCA, 0x82 },
	0x8130B036,	{ 0xCA, 0x83 },
	0x8130B037,	{ 0xCA, 0x84 },
	0x8130B038,	{ 0xCA, 0x85 },
	0x8130B039,	{ 0xCA, 0x86 },
	0x8130B130,	{ 0xCA, 0x87 },
	0x8130B131,	{ 0xCA, 0x88 },
	0x8130B132,	{ 0xCA, 0x89 },
	0x8130B133,	{ 0xCA, 0x8A },
	0x8130B134,	{ 0xCA, 0x8B },
	0x8130B135,	{ 0xCA, 0x8C },
	0x8130B136,	{ 0xCA, 0x8D },
	0x8130B137,	{ 0xCA, 0x8E },
	0x8130B138,	{ 0xCA, 0x8F },
	0x8130B139,	{ 0xCA, 0x90 },
	0x8130B230,	{ 0xCA, 0x91 },
	0x8130B231,	{ 0xCA, 0x92 },
	0x8130B232,	{ 0xCA, 0x93 },
	0x8130B233,	{ 0xCA, 0x94 },
	0x8130B234,	{ 0xCA, 0x95 },
	0x8130B235,	{ 0xCA, 0x96 },
	0x8130B236,	{ 0xCA, 0x97 },
	0x8130B237,	{ 0xCA, 0x98 },
	0x8130B238,	{ 0xCA, 0x99 },
	0x8130B239,	{ 0xCA, 0x9A },
	0x8130B330,	{ 0xCA, 0x9B },
	0x8130B331,	{ 0xCA, 0x9C },
	0x8130B332,	{ 0xCA, 0x9D },
	0x8130B333,	{ 0xCA, 0x9E },
	0x8130B334,	{ 0xCA, 0x9F },
	0x8130B335,	{ 0xCA, 0xA0 },
	0x8130B336,	{ 0xCA, 0xA1 },
	0x8130B337,	{ 0xCA, 0xA2 },
	0x8130B338,	{ 0xCA, 0xA3 },
	0x8130B339,	{ 0xCA, 0xA4 },
	0x8130B430,	{ 0xCA, 0xA5 },
	0x8130B431,	{ 0xCA, 0xA6 },
	0x8130B432,	{ 0xCA, 0xA7 },
	0x8130B433,	{ 0xCA, 0xA8 },
	0x8130B434,	{ 0xCA, 0xA9 },
	0x8130B435,	{ 0xCA, 0xAA },
	0x8130B436,	{ 0xCA, 0xAB },
	0x8130B437,	{ 0xCA, 0xAC },
	0x8130B438,	{ 0xCA, 0xAD },
	0x8130B439,	{ 0xCA, 0xAE },
	0x8130B530,	{ 0xCA, 0xAF },
	0x8130B531,	{ 0xCA, 0xB0 },
	0x8130B532,	{ 0xCA, 0xB1 },
	0x8130B533,	{ 0xCA, 0xB2 },
	0x8130B534,	{ 0xCA, 0xB3 },
	0x8130B535,	{ 0xCA, 0xB4 },
	0x8130B536,	{ 0xCA, 0xB5 },
	0x8130B537,	{ 0xCA, 0xB6 },
	0x8130B538,	{ 0xCA, 0xB7 },
	0x8130B539,	{ 0xCA, 0xB8 },
	0x8130B630,	{ 0xCA, 0xB9 },
	0x8130B631,	{ 0xCA, 0xBA },
	0x8130B632,	{ 0xCA, 0xBB },
	0x8130B633,	{ 0xCA, 0xBC },
	0x8130B634,	{ 0xCA, 0xBD },
	0x8130B635,	{ 0xCA, 0xBE },
	0x8130B636,	{ 0xCA, 0xBF },
	0x8130B637,	{ 0xCB, 0x80 },
	0x8130B638,	{ 0xCB, 0x81 },
	0x8130B639,	{ 0xCB, 0x82 },
	0x8130B730,	{ 0xCB, 0x83 },
	0x8130B731,	{ 0xCB, 0x84 },
	0x8130B732,	{ 0xCB, 0x85 },
	0x8130B733,	{ 0xCB, 0x86 },
	0x8130B734,	{ 0xCB, 0x88 },
	0x8130B735,	{ 0xCB, 0x8C },
	0x8130B736,	{ 0xCB, 0x8D },
	0x8130B737,	{ 0xCB, 0x8E },
	0x8130B738,	{ 0xCB, 0x8F },
	0x8130B739,	{ 0xCB, 0x90 },
	0x8130B830,	{ 0xCB, 0x91 },
	0x8130B831,	{ 0xCB, 0x92 },
	0x8130B832,	{ 0xCB, 0x93 },
	0x8130B833,	{ 0xCB, 0x94 },
	0x8130B834,	{ 0xCB, 0x95 },
	0x8130B835,	{ 0xCB, 0x96 },
	0x8130B836,	{ 0xCB, 0x97 },
	0x8130B837,	{ 0xCB, 0x98 },
	0x8130B838,	{ 0xCB, 0x9A },
	0x8130B839,	{ 0xCB, 0x9B },
	0x8130B930,	{ 0xCB, 0x9C },
	0x8130B931,	{ 0xCB, 0x9D },
	0x8130B932,	{ 0xCB, 0x9E },
	0x8130B933,	{ 0xCB, 0x9F },
	0x8130B934,	{ 0xCB, 0xA0 },
	0x8130B935,	{ 0xCB, 0xA1 },
	0x8130B936,	{ 0xCB, 0xA2 },
	0x8130B937,	{ 0xCB, 0xA3 },
	0x8130B938,	{ 0xCB, 0xA4 },
	0x8130B939,	{ 0xCB, 0xA5 },
	0x8130BA30,	{ 0xCB, 0xA6 },
	0x8130BA31,	{ 0xCB, 0xA7 },
	0x8130BA32,	{ 0xCB, 0xA8 },
	0x8130BA33,	{ 0xCB, 0xA9 },
	0x8130BA34,	{ 0xCB, 0xAA },
	0x8130BA35,	{ 0xCB, 0xAB },
	0x8130BA36,	{ 0xCB, 0xAC },
	0x8130BA37,	{ 0xCB, 0xAD },
	0x8130BA38,	{ 0xCB, 0xAE },
	0x8130BA39,	{ 0xCB, 0xAF },
	0x8130BB30,	{ 0xCB, 0xB0 },
	0x8130BB31,	{ 0xCB, 0xB1 },
	0x8130BB32,	{ 0xCB, 0xB2 },
	0x8130BB33,	{ 0xCB, 0xB3 },
	0x8130BB34,	{ 0xCB, 0xB4 },
	0x8130BB35,	{ 0xCB, 0xB5 },
	0x8130BB36,	{ 0xCB, 0xB6 },
	0x8130BB37,	{ 0xCB, 0xB7 },
	0x8130BB38,	{ 0xCB, 0xB8 },
	0x8130BB39,	{ 0xCB, 0xB9 },
	0x8130BC30,	{ 0xCB, 0xBA },
	0x8130BC31,	{ 0xCB, 0xBB },
	0x8130BC32,	{ 0xCB, 0xBC },
	0x8130BC33,	{ 0xCB, 0xBD },
	0x8130BC34,	{ 0xCB, 0xBE },
	0x8130BC35,	{ 0xCB, 0xBF },
	0x8130BC36,	{ 0xCC, 0x80 },
	0x8130BC37,	{ 0xCC, 0x81 },
	0x8130BC38,	{ 0xCC, 0x82 },
	0x8130BC39,	{ 0xCC, 0x83 },
	0x8130BD30,	{ 0xCC, 0x84 },
	0x8130BD31,	{ 0xCC, 0x85 },
	0x8130BD32,	{ 0xCC, 0x86 },
	0x8130BD33,	{ 0xCC, 0x87 },
	0x8130BD34,	{ 0xCC, 0x88 },
	0x8130BD35,	{ 0xCC, 0x89 },
	0x8130BD36,	{ 0xCC, 0x8A },
	0x8130BD37,	{ 0xCC, 0x8B },
	0x8130BD38,	{ 0xCC, 0x8C },
	0x8130BD39,	{ 0xCC, 0x8D },
	0x8130BE30,	{ 0xCC, 0x8E },
	0x8130BE31,	{ 0xCC, 0x8F },
	0x8130BE32,	{ 0xCC, 0x90 },
	0x8130BE33,	{ 0xCC, 0x91 },
	0x8130BE34,	{ 0xCC, 0x92 },
	0x8130BE35,	{ 0xCC, 0x93 },
	0x8130BE36,	{ 0xCC, 0x94 },
	0x8130BE37,	{ 0xCC, 0x95 },
	0x8130BE38,	{ 0xCC, 0x96 },
	0x8130BE39,	{ 0xCC, 0x97 },
	0x8130BF30,	{ 0xCC, 0x98 },
	0x8130BF31,	{ 0xCC, 0x99 },
	0x8130BF32,	{ 0xCC, 0x9A },
	0x8130BF33,	{ 0xCC, 0x9B },
	0x8130BF34,	{ 0xCC, 0x9C },
	0x8130BF35,	{ 0xCC, 0x9D },
	0x8130BF36,	{ 0xCC, 0x9E },
	0x8130BF37,	{ 0xCC, 0x9F },
	0x8130BF38,	{ 0xCC, 0xA0 },
	0x8130BF39,	{ 0xCC, 0xA1 },
	0x8130C030,	{ 0xCC, 0xA2 },
	0x8130C031,	{ 0xCC, 0xA3 },
	0x8130C032,	{ 0xCC, 0xA4 },
	0x8130C033,	{ 0xCC, 0xA5 },
	0x8130C034,	{ 0xCC, 0xA6 },
	0x8130C035,	{ 0xCC, 0xA7 },
	0x8130C036,	{ 0xCC, 0xA8 },
	0x8130C037,	{ 0xCC, 0xA9 },
	0x8130C038,	{ 0xCC, 0xAA },
	0x8130C039,	{ 0xCC, 0xAB },
	0x8130C130,	{ 0xCC, 0xAC },
	0x8130C131,	{ 0xCC, 0xAD },
	0x8130C132,	{ 0xCC, 0xAE },
	0x8130C133,	{ 0xCC, 0xAF },
	0x8130C134,	{ 0xCC, 0xB0 },
	0x8130C135,	{ 0xCC, 0xB1 },
	0x8130C136,	{ 0xCC, 0xB2 },
	0x8130C137,	{ 0xCC, 0xB3 },
	0x8130C138,	{ 0xCC, 0xB4 },
	0x8130C139,	{ 0xCC, 0xB5 },
	0x8130C230,	{ 0xCC, 0xB6 },
	0x8130C231,	{ 0xCC, 0xB7 },
	0x8130C232,	{ 0xCC, 0xB8 },
	0x8130C233,	{ 0xCC, 0xB9 },
	0x8130C234,	{ 0xCC, 0xBA },
	0x8130C235,	{ 0xCC, 0xBB },
	0x8130C236,	{ 0xCC, 0xBC },
	0x8130C237,	{ 0xCC, 0xBD },
	0x8130C238,	{ 0xCC, 0xBE },
	0x8130C239,	{ 0xCC, 0xBF },
	0x8130C330,	{ 0xCD, 0x80 },
	0x8130C331,	{ 0xCD, 0x81 },
	0x8130C332,	{ 0xCD, 0x82 },
	0x8130C333,	{ 0xCD, 0x83 },
	0x8130C334,	{ 0xCD, 0x84 },
	0x8130C335,	{ 0xCD, 0x85 },
	0x8130C336,	{ 0xCD, 0x86 },
	0x8130C337,	{ 0xCD, 0x87 },
	0x8130C338,	{ 0xCD, 0x88 },
	0x8130C339,	{ 0xCD, 0x89 },
	0x8130C430,	{ 0xCD, 0x8A },
	0x8130C431,	{ 0xCD, 0x8B },
	0x8130C432,	{ 0xCD, 0x8C },
	0x8130C433,	{ 0xCD, 0x8D },
	0x8130C434,	{ 0xCD, 0x8E },
	0x8130C435,	{ 0xCD, 0x8F },
	0x8130C436,	{ 0xCD, 0x90 },
	0x8130C437,	{ 0xCD, 0x91 },
	0x8130C438,	{ 0xCD, 0x92 },
	0x8130C439,	{ 0xCD, 0x93 },
	0x8130C530,	{ 0xCD, 0x94 },
	0x8130C531,	{ 0xCD, 0x95 },
	0x8130C532,	{ 0xCD, 0x96 },
	0x8130C533,	{ 0xCD, 0x97 },
	0x8130C534,	{ 0xCD, 0x98 },
	0x8130C535,	{ 0xCD, 0x99 },
	0x8130C536,	{ 0xCD, 0x9A },
	0x8130C537,	{ 0xCD, 0x9B },
	0x8130C538,	{ 0xCD, 0x9C },
	0x8130C539,	{ 0xCD, 0x9D },
	0x8130C630,	{ 0xCD, 0x9E },
	0x8130C631,	{ 0xCD, 0x9F },
	0x8130C632,	{ 0xCD, 0xA0 },
	0x8130C633,	{ 0xCD, 0xA1 },
	0x8130C634,	{ 0xCD, 0xA2 },
	0x8130C635,	{ 0xCD, 0xA3 },
	0x8130C636,	{ 0xCD, 0xA4 },
	0x8130C637,	{ 0xCD, 0xA5 },
	0x8130C638,	{ 0xCD, 0xA6 },
	0x8130C639,	{ 0xCD, 0xA7 },
	0x8130C730,	{ 0xCD, 0xA8 },
	0x8130C731,	{ 0xCD, 0xA9 },
	0x8130C732,	{ 0xCD, 0xAA },
	0x8130C733,	{ 0xCD, 0xAB },
	0x8130C734,	{ 0xCD, 0xAC },
	0x8130C735,	{ 0xCD, 0xAD },
	0x8130C736,	{ 0xCD, 0xAE },
	0x8130C737,	{ 0xCD, 0xAF },
	0x8130C738,	{ 0xCD, 0xB0 },
	0x8130C739,	{ 0xCD, 0xB1 },
	0x8130C830,	{ 0xCD, 0xB2 },
	0x8130C831,	{ 0xCD, 0xB3 },
	0x8130C832,	{ 0xCD, 0xB4 },
	0x8130C833,	{ 0xCD, 0xB5 },
	0x8130C834,	{ 0xCD, 0xB6 },
	0x8130C835,	{ 0xCD, 0xB7 },
	0x8130C836,	{ 0xCD, 0xB8 },
	0x8130C837,	{ 0xCD, 0xB9 },
	0x8130C838,	{ 0xCD, 0xBA },
	0x8130C839,	{ 0xCD, 0xBB },
	0x8130C930,	{ 0xCD, 0xBC },
	0x8130C931,	{ 0xCD, 0xBD },
	0x8130C932,	{ 0xCD, 0xBE },
	0x8130C933,	{ 0xCD, 0xBF },
	0x8130C934,	{ 0xCE, 0x80 },
	0x8130C935,	{ 0xCE, 0x81 },
	0x8130C936,	{ 0xCE, 0x82 },
	0x8130C937,	{ 0xCE, 0x83 },
	0x8130C938,	{ 0xCE, 0x84 },
	0x8130C939,	{ 0xCE, 0x85 },
	0x8130CA30,	{ 0xCE, 0x86 },
	0x8130CA31,	{ 0xCE, 0x87 },
	0x8130CA32,	{ 0xCE, 0x88 },
	0x8130CA33,	{ 0xCE, 0x89 },
	0x8130CA34,	{ 0xCE, 0x8A },
	0x8130CA35,	{ 0xCE, 0x8B },
	0x8130CA36,	{ 0xCE, 0x8C },
	0x8130CA37,	{ 0xCE, 0x8D },
	0x8130CA38,	{ 0xCE, 0x8E },
	0x8130CA39,	{ 0xCE, 0x8F },
	0x8130CB30,	{ 0xCE, 0x90 },
	0x8130CB31,	{ 0xCE, 0xA2 },
	0x8130CB32,	{ 0xCE, 0xAA },
	0x8130CB33,	{ 0xCE, 0xAB },
	0x8130CB34,	{ 0xCE, 0xAC },
	0x8130CB35,	{ 0xCE, 0xAD },
	0x8130CB36,	{ 0xCE, 0xAE },
	0x8130CB37,	{ 0xCE, 0xAF },
	0x8130CB38,	{ 0xCE, 0xB0 },
	0x8130CB39,	{ 0xCF, 0x82 },
	0x8130CC30,	{ 0xCF, 0x8A },
	0x8130CC31,	{ 0xCF, 0x8B },
	0x8130CC32,	{ 0xCF, 0x8C },
	0x8130CC33,	{ 0xCF, 0x8D },
	0x8130CC34,	{ 0xCF, 0x8E },
	0x8130CC35,	{ 0xCF, 0x8F },
	0x8130CC36,	{ 0xCF, 0x90 },
	0x8130CC37,	{ 0xCF, 0x91 },
	0x8130CC38,	{ 0xCF, 0x92 },
	0x8130CC39,	{ 0xCF, 0x93 },
	0x8130CD30,	{ 0xCF, 0x94 },
	0x8130CD31,	{ 0xCF, 0x95 },
	0x8130CD32,	{ 0xCF, 0x96 },
	0x8130CD33,	{ 0xCF, 0x97 },
	0x8130CD34,	{ 0xCF, 0x98 },
	0x8130CD35,	{ 0xCF, 0x99 },
	0x8130CD36,	{ 0xCF, 0x9A },
	0x8130CD37,	{ 0xCF, 0x9B },
	0x8130CD38,	{ 0xCF, 0x9C },
	0x8130CD39,	{ 0xCF, 0x9D },
	0x8130CE30,	{ 0xCF, 0x9E },
	0x8130CE31,	{ 0xCF, 0x9F },
	0x8130CE32,	{ 0xCF, 0xA0 },
	0x8130CE33,	{ 0xCF, 0xA1 },
	0x8130CE34,	{ 0xCF, 0xA2 },
	0x8130CE35,	{ 0xCF, 0xA3 },
	0x8130CE36,	{ 0xCF, 0xA4 },
	0x8130CE37,	{ 0xCF, 0xA5 },
	0x8130CE38,	{ 0xCF, 0xA6 },
	0x8130CE39,	{ 0xCF, 0xA7 },
	0x8130CF30,	{ 0xCF, 0xA8 },
	0x8130CF31,	{ 0xCF, 0xA9 },
	0x8130CF32,	{ 0xCF, 0xAA },
	0x8130CF33,	{ 0xCF, 0xAB },
	0x8130CF34,	{ 0xCF, 0xAC },
	0x8130CF35,	{ 0xCF, 0xAD },
	0x8130CF36,	{ 0xCF, 0xAE },
	0x8130CF37,	{ 0xCF, 0xAF },
	0x8130CF38,	{ 0xCF, 0xB0 },
	0x8130CF39,	{ 0xCF, 0xB1 },
	0x8130D030,	{ 0xCF, 0xB2 },
	0x8130D031,	{ 0xCF, 0xB3 },
	0x8130D032,	{ 0xCF, 0xB4 },
	0x8130D033,	{ 0xCF, 0xB5 },
	0x8130D034,	{ 0xCF, 0xB6 },
	0x8130D035,	{ 0xCF, 0xB7 },
	0x8130D036,	{ 0xCF, 0xB8 },
	0x8130D037,	{ 0xCF, 0xB9 },
	0x8130D038,	{ 0xCF, 0xBA },
	0x8130D039,	{ 0xCF, 0xBB },
	0x8130D130,	{ 0xCF, 0xBC },
	0x8130D131,	{ 0xCF, 0xBD },
	0x8130D132,	{ 0xCF, 0xBE },
	0x8130D133,	{ 0xCF, 0xBF },
	0x8130D134,	{ 0xD0, 0x80 },
	0x8130D135,	{ 0xD0, 0x82 },
	0x8130D136,	{ 0xD0, 0x83 },
	0x8130D137,	{ 0xD0, 0x84 },
	0x8130D138,	{ 0xD0, 0x85 },
	0x8130D139,	{ 0xD0, 0x86 },
	0x8130D230,	{ 0xD0, 0x87 },
	0x8130D231,	{ 0xD0, 0x88 },
	0x8130D232,	{ 0xD0, 0x89 },
	0x8130D233,	{ 0xD0, 0x8A },
	0x8130D234,	{ 0xD0, 0x8B },
	0x8130D235,	{ 0xD0, 0x8C },
	0x8130D236,	{ 0xD0, 0x8D },
	0x8130D237,	{ 0xD0, 0x8E },
	0x8130D238,	{ 0xD0, 0x8F },
	0x8130D239,	{ 0xD1, 0x90 },
	0x8130D330,	{ 0xD1, 0x92 },
	0x8130D331,	{ 0xD1, 0x93 },
	0x8130D332,	{ 0xD1, 0x94 },
	0x8130D333,	{ 0xD1, 0x95 },
	0x8130D334,	{ 0xD1, 0x96 },
	0x8130D335,	{ 0xD1, 0x97 },
	0x8130D336,	{ 0xD1, 0x98 },
	0x8130D337,	{ 0xD1, 0x99 },
	0x8130D338,	{ 0xD1, 0x9A },
	0x8130D339,	{ 0xD1, 0x9B },
	0x8130D430,	{ 0xD1, 0x9C },
	0x8130D431,	{ 0xD1, 0x9D },
	0x8130D432,	{ 0xD1, 0x9E },
	0x8130D433,	{ 0xD1, 0x9F },
	0x8130D434,	{ 0xD1, 0xA0 },
	0x8130D435,	{ 0xD1, 0xA1 },
	0x8130D436,	{ 0xD1, 0xA2 },
	0x8130D437,	{ 0xD1, 0xA3 },
	0x8130D438,	{ 0xD1, 0xA4 },
	0x8130D439,	{ 0xD1, 0xA5 },
	0x8130D530,	{ 0xD1, 0xA6 },
	0x8130D531,	{ 0xD1, 0xA7 },
	0x8130D532,	{ 0xD1, 0xA8 },
	0x8130D533,	{ 0xD1, 0xA9 },
	0x8130D534,	{ 0xD1, 0xAA },
	0x8130D535,	{ 0xD1, 0xAB },
	0x8130D536,	{ 0xD1, 0xAC },
	0x8130D537,	{ 0xD1, 0xAD },
	0x8130D538,	{ 0xD1, 0xAE },
	0x8130D539,	{ 0xD1, 0xAF },
	0x8130D630,	{ 0xD1, 0xB0 },
	0x8130D631,	{ 0xD1, 0xB1 },
	0x8130D632,	{ 0xD1, 0xB2 },
	0x8130D633,	{ 0xD1, 0xB3 },
	0x8130D634,	{ 0xD1, 0xB4 },
	0x8130D635,	{ 0xD1, 0xB5 },
	0x8130D636,	{ 0xD1, 0xB6 },
	0x8130D637,	{ 0xD1, 0xB7 },
	0x8130D638,	{ 0xD1, 0xB8 },
	0x8130D639,	{ 0xD1, 0xB9 },
	0x8130D730,	{ 0xD1, 0xBA },
	0x8130D731,	{ 0xD1, 0xBB },
	0x8130D732,	{ 0xD1, 0xBC },
	0x8130D733,	{ 0xD1, 0xBD },
	0x8130D734,	{ 0xD1, 0xBE },
	0x8130D735,	{ 0xD1, 0xBF },
	0x8130D736,	{ 0xD2, 0x80 },
	0x8130D737,	{ 0xD2, 0x81 },
	0x8130D738,	{ 0xD2, 0x82 },
	0x8130D739,	{ 0xD2, 0x83 },
	0x8130D830,	{ 0xD2, 0x84 },
	0x8130D831,	{ 0xD2, 0x85 },
	0x8130D832,	{ 0xD2, 0x86 },
	0x8130D833,	{ 0xD2, 0x87 },
	0x8130D834,	{ 0xD2, 0x88 },
	0x8130D835,	{ 0xD2, 0x89 },
	0x8130D836,	{ 0xD2, 0x8A },
	0x8130D837,	{ 0xD2, 0x8B },
	0x8130D838,	{ 0xD2, 0x8C },
	0x8130D839,	{ 0xD2, 0x8D },
	0x8130D930,	{ 0xD2, 0x8E },
	0x8130D931,	{ 0xD2, 0x8F },
	0x8130D932,	{ 0xD2, 0x90 },
	0x8130D933,	{ 0xD2, 0x91 },
	0x8130D934,	{ 0xD2, 0x92 },
	0x8130D935,	{ 0xD2, 0x93 },
	0x8130D936,	{ 0xD2, 0x94 },
	0x8130D937,	{ 0xD2, 0x95 },
	0x8130D938,	{ 0xD2, 0x96 },
	0x8130D939,	{ 0xD2, 0x97 },
	0x8130DA30,	{ 0xD2, 0x98 },
	0x8130DA31,	{ 0xD2, 0x99 },
	0x8130DA32,	{ 0xD2, 0x9A },
	0x8130DA33,	{ 0xD2, 0x9B },
	0x8130DA34,	{ 0xD2, 0x9C },
	0x8130DA35,	{ 0xD2, 0x9D },
	0x8130DA36,	{ 0xD2, 0x9E },
	0x8130DA37,	{ 0xD2, 0x9F },
	0x8130DA38,	{ 0xD2, 0xA0 },
	0x8130DA39,	{ 0xD2, 0xA1 },
	0x8130DB30,	{ 0xD2, 0xA2 },
	0x8130DB31,	{ 0xD2, 0xA3 },
	0x8130DB32,	{ 0xD2, 0xA4 },
	0x8130DB33,	{ 0xD2, 0xA5 },
	0x8130DB34,	{ 0xD2, 0xA6 },
	0x8130DB35,	{ 0xD2, 0xA7 },
	0x8130DB36,	{ 0xD2, 0xA8 },
	0x8130DB37,	{ 0xD2, 0xA9 },
	0x8130DB38,	{ 0xD2, 0xAA },
	0x8130DB39,	{ 0xD2, 0xAB },
	0x8130DC30,	{ 0xD2, 0xAC },
	0x8130DC31,	{ 0xD2, 0xAD },
	0x8130DC32,	{ 0xD2, 0xAE },
	0x8130DC33,	{ 0xD2, 0xAF },
	0x8130DC34,	{ 0xD2, 0xB0 },
	0x8130DC35,	{ 0xD2, 0xB1 },
	0x8130DC36,	{ 0xD2, 0xB2 },
	0x8130DC37,	{ 0xD2, 0xB3 },
	0x8130DC38,	{ 0xD2, 0xB4 },
	0x8130DC39,	{ 0xD2, 0xB5 },
	0x8130DD30,	{ 0xD2, 0xB6 },
	0x8130DD31,	{ 0xD2, 0xB7 },
	0x8130DD32,	{ 0xD2, 0xB8 },
	0x8130DD33,	{ 0xD2, 0xB9 },
	0x8130DD34,	{ 0xD2, 0xBA },
	0x8130DD35,	{ 0xD2, 0xBB },
	0x8130DD36,	{ 0xD2, 0xBC },
	0x8130DD37,	{ 0xD2, 0xBD },
	0x8130DD38,	{ 0xD2, 0xBE },
	0x8130DD39,	{ 0xD2, 0xBF },
	0x8130DE30,	{ 0xD3, 0x80 },
	0x8130DE31,	{ 0xD3, 0x81 },
	0x8130DE32,	{ 0xD3, 0x82 },
	0x8130DE33,	{ 0xD3, 0x83 },
	0x8130DE34,	{ 0xD3, 0x84 },
	0x8130DE35,	{ 0xD3, 0x85 },
	0x8130DE36,	{ 0xD3, 0x86 },
	0x8130DE37,	{ 0xD3, 0x87 },
	0x8130DE38,	{ 0xD3, 0x88 },
	0x8130DE39,	{ 0xD3, 0x89 },
	0x8130DF30,	{ 0xD3, 0x8A },
	0x8130DF31,	{ 0xD3, 0x8B },
	0x8130DF32,	{ 0xD3, 0x8C },
	0x8130DF33,	{ 0xD3, 0x8D },
	0x8130DF34,	{ 0xD3, 0x8E },
	0x8130DF35,	{ 0xD3, 0x8F },
	0x8130DF36,	{ 0xD3, 0x90 },
	0x8130DF37,	{ 0xD3, 0x91 },
	0x8130DF38,	{ 0xD3, 0x92 },
	0x8130DF39,	{ 0xD3, 0x93 },
	0x8130E030,	{ 0xD3, 0x94 },
	0x8130E031,	{ 0xD3, 0x95 },
	0x8130E032,	{ 0xD3, 0x96 },
	0x8130E033,	{ 0xD3, 0x97 },
	0x8130E034,	{ 0xD3, 0x98 },
	0x8130E035,	{ 0xD3, 0x99 },
	0x8130E036,	{ 0xD3, 0x9A },
	0x8130E037,	{ 0xD3, 0x9B },
	0x8130E038,	{ 0xD3, 0x9C },
	0x8130E039,	{ 0xD3, 0x9D },
	0x8130E130,	{ 0xD3, 0x9E },
	0x8130E131,	{ 0xD3, 0x9F },
	0x8130E132,	{ 0xD3, 0xA0 },
	0x8130E133,	{ 0xD3, 0xA1 },
	0x8130E134,	{ 0xD3, 0xA2 },
	0x8130E135,	{ 0xD3, 0xA3 },
	0x8130E136,	{ 0xD3, 0xA4 },
	0x8130E137,	{ 0xD3, 0xA5 },
	0x8130E138,	{ 0xD3, 0xA6 },
	0x8130E139,	{ 0xD3, 0xA7 },
	0x8130E230,	{ 0xD3, 0xA8 },
	0x8130E231,	{ 0xD3, 0xA9 },
	0x8130E232,	{ 0xD3, 0xAA },
	0x8130E233,	{ 0xD3, 0xAB },
	0x8130E234,	{ 0xD3, 0xAC },
	0x8130E235,	{ 0xD3, 0xAD },
	0x8130E236,	{ 0xD3, 0xAE },
	0x8130E237,	{ 0xD3, 0xAF },
	0x8130E238,	{ 0xD3, 0xB0 },
	0x8130E239,	{ 0xD3, 0xB1 },
	0x8130E330,	{ 0xD3, 0xB2 },
	0x8130E331,	{ 0xD3, 0xB3 },
	0x8130E332,	{ 0xD3, 0xB4 },
	0x8130E333,	{ 0xD3, 0xB5 },
	0x8130E334,	{ 0xD3, 0xB6 },
	0x8130E335,	{ 0xD3, 0xB7 },
	0x8130E336,	{ 0xD3, 0xB8 },
	0x8130E337,	{ 0xD3, 0xB9 },
	0x8130E338,	{ 0xD3, 0xBA },
	0x8130E339,	{ 0xD3, 0xBB },
	0x8130E430,	{ 0xD3, 0xBC },
	0x8130E431,	{ 0xD3, 0xBD },
	0x8130E432,	{ 0xD3, 0xBE },
	0x8130E433,	{ 0xD3, 0xBF },
	0x8130E434,	{ 0xD4, 0x80 },
	0x8130E435,	{ 0xD4, 0x81 },
	0x8130E436,	{ 0xD4, 0x82 },
	0x8130E437,	{ 0xD4, 0x83 },
	0x8130E438,	{ 0xD4, 0x84 },
	0x8130E439,	{ 0xD4, 0x85 },
	0x8130E530,	{ 0xD4, 0x86 },
	0x8130E531,	{ 0xD4, 0x87 },
	0x8130E532,	{ 0xD4, 0x88 },
	0x8130E533,	{ 0xD4, 0x89 },
	0x8130E534,	{ 0xD4, 0x8A },
	0x8130E535,	{ 0xD4, 0x8B },
	0x8130E536,	{ 0xD4, 0x8C },
	0x8130E537,	{ 0xD4, 0x8D },
	0x8130E538,	{ 0xD4, 0x8E },
	0x8130E539,	{ 0xD4, 0x8F },
	0x8130E630,	{ 0xD4, 0x90 },
	0x8130E631,	{ 0xD4, 0x91 },
	0x8130E632,	{ 0xD4, 0x92 },
	0x8130E633,	{ 0xD4, 0x93 },
	0x8130E634,	{ 0xD4, 0x94 },
	0x8130E635,	{ 0xD4, 0x95 },
	0x8130E636,	{ 0xD4, 0x96 },
	0x8130E637,	{ 0xD4, 0x97 },
	0x8130E638,	{ 0xD4, 0x98 },
	0x8130E639,	{ 0xD4, 0x99 },
	0x8130E730,	{ 0xD4, 0x9A },
	0x8130E731,	{ 0xD4, 0x9B },
	0x8130E732,	{ 0xD4, 0x9C },
	0x8130E733,	{ 0xD4, 0x9D },
	0x8130E734,	{ 0xD4, 0x9E },
	0x8130E735,	{ 0xD4, 0x9F },
	0x8130E736,	{ 0xD4, 0xA0 },
	0x8130E737,	{ 0xD4, 0xA1 },
	0x8130E738,	{ 0xD4, 0xA2 },
	0x8130E739,	{ 0xD4, 0xA3 },
	0x8130E830,	{ 0xD4, 0xA4 },
	0x8130E831,	{ 0xD4, 0xA5 },
	0x8130E832,	{ 0xD4, 0xA6 },
	0x8130E833,	{ 0xD4, 0xA7 },
	0x8130E834,	{ 0xD4, 0xA8 },
	0x8130E835,	{ 0xD4, 0xA9 },
	0x8130E836,	{ 0xD4, 0xAA },
	0x8130E837,	{ 0xD4, 0xAB },
	0x8130E838,	{ 0xD4, 0xAC },
	0x8130E839,	{ 0xD4, 0xAD },
	0x8130E930,	{ 0xD4, 0xAE },
	0x8130E931,	{ 0xD4, 0xAF },
	0x8130E932,	{ 0xD4, 0xB0 },
	0x8130E933,	{ 0xD4, 0xB1 },
	0x8130E934,	{ 0xD4, 0xB2 },
	0x8130E935,	{ 0xD4, 0xB3 },
	0x8130E936,	{ 0xD4, 0xB4 },
	0x8130E937,	{ 0xD4, 0xB5 },
	0x8130E938,	{ 0xD4, 0xB6 },
	0x8130E939,	{ 0xD4, 0xB7 },
	0x8130EA30,	{ 0xD4, 0xB8 },
	0x8130EA31,	{ 0xD4, 0xB9 },
	0x8130EA32,	{ 0xD4, 0xBA },
	0x8130EA33,	{ 0xD4, 0xBB },
	0x8130EA34,	{ 0xD4, 0xBC },
	0x8130EA35,	{ 0xD4, 0xBD },
	0x8130EA36,	{ 0xD4, 0xBE },
	0x8130EA37,	{ 0xD4, 0xBF },
	0x8130EA38,	{ 0xD5, 0x80 },
	0x8130EA39,	{ 0xD5, 0x81 },
	0x8130EB30,	{ 0xD5, 0x82 },
	0x8130EB31,	{ 0xD5, 0x83 },
	0x8130EB32,	{ 0xD5, 0x84 },
	0x8130EB33,	{ 0xD5, 0x85 },
	0x8130EB34,	{ 0xD5, 0x86 },
	0x8130EB35,	{ 0xD5, 0x87 },
	0x8130EB36,	{ 0xD5, 0x88 },
	0x8130EB37,	{ 0xD5, 0x89 },
	0x8130EB38,	{ 0xD5, 0x8A },
	0x8130EB39,	{ 0xD5, 0x8B },
	0x8130EC30,	{ 0xD5, 0x8C },
	0x8130EC31,	{ 0xD5, 0x8D },
	0x8130EC32,	{ 0xD5, 0x8E },
	0x8130EC33,	{ 0xD5, 0x8F },
	0x8130EC34,	{ 0xD5, 0x90 },
	0x8130EC35,	{ 0xD5, 0x91 },
	0x8130EC36,	{ 0xD5, 0x92 },
	0x8130EC37,	{ 0xD5, 0x93 },
	0x8130EC38,	{ 0xD5, 0x94 },
	0x8130EC39,	{ 0xD5, 0x95 },
	0x8130ED30,	{ 0xD5, 0x96 },
	0x8130ED31,	{ 0xD5, 0x97 },
	0x8130ED32,	{ 0xD5, 0x98 },
	0x8130ED33,	{ 0xD5, 0x99 },
	0x8130ED34,	{ 0xD5, 0x9A },
	0x8130ED35,	{ 0xD5, 0x9B },
	0x8130ED36,	{ 0xD5, 0x9C },
	0x8130ED37,	{ 0xD5, 0x9D },
	0x8130ED38,	{ 0xD5, 0x9E },
	0x8130ED39,	{ 0xD5, 0x9F },
	0x8130EE30,	{ 0xD5, 0xA0 },
	0x8130EE31,	{ 0xD5, 0xA1 },
	0x8130EE32,	{ 0xD5, 0xA2 },
	0x8130EE33,	{ 0xD5, 0xA3 },
	0x8130EE34,	{ 0xD5, 0xA4 },
	0x8130EE35,	{ 0xD5, 0xA5 },
	0x8130EE36,	{ 0xD5, 0xA6 },
	0x8130EE37,	{ 0xD5, 0xA7 },
	0x8130EE38,	{ 0xD5, 0xA8 },
	0x8130EE39,	{ 0xD5, 0xA9 },
	0x8130EF30,	{ 0xD5, 0xAA },
	0x8130EF31,	{ 0xD5, 0xAB },
	0x8130EF32,	{ 0xD5, 0xAC },
	0x8130EF33,	{ 0xD5, 0xAD },
	0x8130EF34,	{ 0xD5, 0xAE },
	0x8130EF35,	{ 0xD5, 0xAF },
	0x8130EF36,	{ 0xD5, 0xB0 },
	0x8130EF37,	{ 0xD5, 0xB1 },
	0x8130EF38,	{ 0xD5, 0xB2 },
	0x8130EF39,	{ 0xD5, 0xB3 },
	0x8130F030,	{ 0xD5, 0xB4 },
	0x8130F031,	{ 0xD5, 0xB5 },
	0x8130F032,	{ 0xD5, 0xB6 },
	0x8130F033,	{ 0xD5, 0xB7 },
	0x8130F034,	{ 0xD5, 0xB8 },
	0x8130F035,	{ 0xD5, 0xB9 },
	0x8130F036,	{ 0xD5, 0xBA },
	0x8130F037,	{ 0xD5, 0xBB },
	0x8130F038,	{ 0xD5, 0xBC },
	0x8130F039,	{ 0xD5, 0xBD },
	0x8130F130,	{ 0xD5, 0xBE },
	0x8130F131,	{ 0xD5, 0xBF },
	0x8130F132,	{ 0xD6, 0x80 },
	0x8130F133,	{ 0xD6, 0x81 },
	0x8130F134,	{ 0xD6, 0x82 },
	0x8130F135,	{ 0xD6, 0x83 },
	0x8130F136,	{ 0xD6, 0x84 },
	0x8130F137,	{ 0xD6, 0x85 },
	0x8130F138,	{ 0xD6, 0x86 },
	0x8130F139,	{ 0xD6, 0x87 },
	0x8130F230,	{ 0xD6, 0x88 },
	0x8130F231,	{ 0xD6, 0x89 },
	0x8130F232,	{ 0xD6, 0x8A },
	0x8130F233,	{ 0xD6, 0x8B },
	0x8130F234,	{ 0xD6, 0x8C },
	0x8130F235,	{ 0xD6, 0x8D },
	0x8130F236,	{ 0xD6, 0x8E },
	0x8130F237,	{ 0xD6, 0x8F },
	0x8130F238,	{ 0xD6, 0x90 },
	0x8130F239,	{ 0xD6, 0x91 },
	0x8130F330,	{ 0xD6, 0x92 },
	0x8130F331,	{ 0xD6, 0x93 },
	0x8130F332,	{ 0xD6, 0x94 },
	0x8130F333,	{ 0xD6, 0x95 },
	0x8130F334,	{ 0xD6, 0x96 },
	0x8130F335,	{ 0xD6, 0x97 },
	0x8130F336,	{ 0xD6, 0x98 },
	0x8130F337,	{ 0xD6, 0x99 },
	0x8130F338,	{ 0xD6, 0x9A },
	0x8130F339,	{ 0xD6, 0x9B },
	0x8130F430,	{ 0xD6, 0x9C },
	0x8130F431,	{ 0xD6, 0x9D },
	0x8130F432,	{ 0xD6, 0x9E },
	0x8130F433,	{ 0xD6, 0x9F },
	0x8130F434,	{ 0xD6, 0xA0 },
	0x8130F435,	{ 0xD6, 0xA1 },
	0x8130F436,	{ 0xD6, 0xA2 },
	0x8130F437,	{ 0xD6, 0xA3 },
	0x8130F438,	{ 0xD6, 0xA4 },
	0x8130F439,	{ 0xD6, 0xA5 },
	0x8130F530,	{ 0xD6, 0xA6 },
	0x8130F531,	{ 0xD6, 0xA7 },
	0x8130F532,	{ 0xD6, 0xA8 },
	0x8130F533,	{ 0xD6, 0xA9 },
	0x8130F534,	{ 0xD6, 0xAA },
	0x8130F535,	{ 0xD6, 0xAB },
	0x8130F536,	{ 0xD6, 0xAC },
	0x8130F537,	{ 0xD6, 0xAD },
	0x8130F538,	{ 0xD6, 0xAE },
	0x8130F539,	{ 0xD6, 0xAF },
	0x8130F630,	{ 0xD6, 0xB0 },
	0x8130F631,	{ 0xD6, 0xB1 },
	0x8130F632,	{ 0xD6, 0xB2 },
	0x8130F633,	{ 0xD6, 0xB3 },
	0x8130F634,	{ 0xD6, 0xB4 },
	0x8130F635,	{ 0xD6, 0xB5 },
	0x8130F636,	{ 0xD6, 0xB6 },
	0x8130F637,	{ 0xD6, 0xB7 },
	0x8130F638,	{ 0xD6, 0xB8 },
	0x8130F639,	{ 0xD6, 0xB9 },
	0x8130F730,	{ 0xD6, 0xBA },
	0x8130F731,	{ 0xD6, 0xBB },
	0x8130F732,	{ 0xD6, 0xBC },
	0x8130F733,	{ 0xD6, 0xBD },
	0x8130F734,	{ 0xD6, 0xBE },
	0x8130F735,	{ 0xD6, 0xBF },
	0x8130F736,	{ 0xD7, 0x80 },
	0x8130F737,	{ 0xD7, 0x81 },
	0x8130F738,	{ 0xD7, 0x82 },
	0x8130F739,	{ 0xD7, 0x83 },
	0x8130F830,	{ 0xD7, 0x84 },
	0x8130F831,	{ 0xD7, 0x85 },
	0x8130F832,	{ 0xD7, 0x86 },
	0x8130F833,	{ 0xD7, 0x87 },
	0x8130F834,	{ 0xD7, 0x88 },
	0x8130F835,	{ 0xD7, 0x89 },
	0x8130F836,	{ 0xD7, 0x8A },
	0x8130F837,	{ 0xD7, 0x8B },
	0x8130F838,	{ 0xD7, 0x8C },
	0x8130F839,	{ 0xD7, 0x8D },
	0x8130F930,	{ 0xD7, 0x8E },
	0x8130F931,	{ 0xD7, 0x8F },
	0x8130F932,	{ 0xD7, 0x90 },
	0x8130F933,	{ 0xD7, 0x91 },
	0x8130F934,	{ 0xD7, 0x92 },
	0x8130F935,	{ 0xD7, 0x93 },
	0x8130F936,	{ 0xD7, 0x94 },
	0x8130F937,	{ 0xD7, 0x95 },
	0x8130F938,	{ 0xD7, 0x96 },
	0x8130F939,	{ 0xD7, 0x97 },
	0x8130FA30,	{ 0xD7, 0x98 },
	0x8130FA31,	{ 0xD7, 0x99 },
	0x8130FA32,	{ 0xD7, 0x9A },
	0x8130FA33,	{ 0xD7, 0x9B },
	0x8130FA34,	{ 0xD7, 0x9C },
	0x8130FA35,	{ 0xD7, 0x9D },
	0x8130FA36,	{ 0xD7, 0x9E },
	0x8130FA37,	{ 0xD7, 0x9F },
	0x8130FA38,	{ 0xD7, 0xA0 },
	0x8130FA39,	{ 0xD7, 0xA1 },
	0x8130FB30,	{ 0xD7, 0xA2 },
	0x8130FB31,	{ 0xD7, 0xA3 },
	0x8130FB32,	{ 0xD7, 0xA4 },
	0x8130FB33,	{ 0xD7, 0xA5 },
	0x8130FB34,	{ 0xD7, 0xA6 },
	0x8130FB35,	{ 0xD7, 0xA7 },
	0x8130FB36,	{ 0xD7, 0xA8 },
	0x8130FB37,	{ 0xD7, 0xA9 },
	0x8130FB38,	{ 0xD7, 0xAA },
	0x8130FB39,	{ 0xD7, 0xAB },
	0x8130FC30,	{ 0xD7, 0xAC },
	0x8130FC31,	{ 0xD7, 0xAD },
	0x8130FC32,	{ 0xD7, 0xAE },
	0x8130FC33,	{ 0xD7, 0xAF },
	0x8130FC34,	{ 0xD7, 0xB0 },
	0x8130FC35,	{ 0xD7, 0xB1 },
	0x8130FC36,	{ 0xD7, 0xB2 },
	0x8130FC37,	{ 0xD7, 0xB3 },
	0x8130FC38,	{ 0xD7, 0xB4 },
	0x8130FC39,	{ 0xD7, 0xB5 },
	0x8130FD30,	{ 0xD7, 0xB6 },
	0x8130FD31,	{ 0xD7, 0xB7 },
	0x8130FD32,	{ 0xD7, 0xB8 },
	0x8130FD33,	{ 0xD7, 0xB9 },
	0x8130FD34,	{ 0xD7, 0xBA },
	0x8130FD35,	{ 0xD7, 0xBB },
	0x8130FD36,	{ 0xD7, 0xBC },
	0x8130FD37,	{ 0xD7, 0xBD },
	0x8130FD38,	{ 0xD7, 0xBE },
	0x8130FD39,	{ 0xD7, 0xBF },
	0x8130FE30,	{ 0xD8, 0x80 },
	0x8130FE31,	{ 0xD8, 0x81 },
	0x8130FE32,	{ 0xD8, 0x82 },
	0x8130FE33,	{ 0xD8, 0x83 },
	0x8130FE34,	{ 0xD8, 0x84 },
	0x8130FE35,	{ 0xD8, 0x85 },
	0x8130FE36,	{ 0xD8, 0x86 },
	0x8130FE37,	{ 0xD8, 0x87 },
	0x8130FE38,	{ 0xD8, 0x88 },
	0x8130FE39,	{ 0xD8, 0x89 },
	0x81318130,	{ 0xD8, 0x8A },
	0x81318131,	{ 0xD8, 0x8B },
	0x81318132,	{ 0xD8, 0x8C },
	0x81318133,	{ 0xD8, 0x8D },
	0x81318134,	{ 0xD8, 0x8E },
	0x81318135,	{ 0xD8, 0x8F },
	0x81318136,	{ 0xD8, 0x90 },
	0x81318137,	{ 0xD8, 0x91 },
	0x81318138,	{ 0xD8, 0x92 },
	0x81318139,	{ 0xD8, 0x93 },
	0x81318230,	{ 0xD8, 0x94 },
	0x81318231,	{ 0xD8, 0x95 },
	0x81318232,	{ 0xD8, 0x96 },
	0x81318233,	{ 0xD8, 0x97 },
	0x81318234,	{ 0xD8, 0x98 },
	0x81318235,	{ 0xD8, 0x99 },
	0x81318236,	{ 0xD8, 0x9A },
	0x81318237,	{ 0xD8, 0x9B },
	0x81318238,	{ 0xD8, 0x9C },
	0x81318239,	{ 0xD8, 0x9D },
	0x81318330,	{ 0xD8, 0x9E },
	0x81318331,	{ 0xD8, 0x9F },
	0x81318332,	{ 0xD8, 0xA0 },
	0x81318333,	{ 0xD8, 0xA1 },
	0x81318334,	{ 0xD8, 0xA2 },
	0x81318335,	{ 0xD8, 0xA3 },
	0x81318336,	{ 0xD8, 0xA4 },
	0x81318337,	{ 0xD8, 0xA5 },
	0x81318338,	{ 0xD8, 0xA6 },
	0x81318339,	{ 0xD8, 0xA7 },
	0x81318430,	{ 0xD8, 0xA8 },
	0x81318431,	{ 0xD8, 0xA9 },
	0x81318432,	{ 0xD8, 0xAA },
	0x81318433,	{ 0xD8, 0xAB },
	0x81318434,	{ 0xD8, 0xAC },
	0x81318435,	{ 0xD8, 0xAD },
	0x81318436,	{ 0xD8, 0xAE },
	0x81318437,	{ 0xD8, 0xAF },
	0x81318438,	{ 0xD8, 0xB0 },
	0x81318439,	{ 0xD8, 0xB1 },
	0x81318530,	{ 0xD8, 0xB2 },
	0x81318531,	{ 0xD8, 0xB3 },
	0x81318532,	{ 0xD8, 0xB4 },
	0x81318533,	{ 0xD8, 0xB5 },
	0x81318534,	{ 0xD8, 0xB6 },
	0x81318535,	{ 0xD8, 0xB7 },
	0x81318536,	{ 0xD8, 0xB8 },
	0x81318537,	{ 0xD8, 0xB9 },
	0x81318538,	{ 0xD8, 0xBA },
	0x81318539,	{ 0xD8, 0xBB },
	0x81318630,	{ 0xD8, 0xBC },
	0x81318631,	{ 0xD8, 0xBD },
	0x81318632,	{ 0xD8, 0xBE },
	0x81318633,	{ 0xD8, 0xBF },
	0x81318634,	{ 0xD9, 0x80 },
	0x81318635,	{ 0xD9, 0x81 },
	0x81318636,	{ 0xD9, 0x82 },
	0x81318637,	{ 0xD9, 0x83 },
	0x81318638,	{ 0xD9, 0x84 },
	0x81318639,	{ 0xD9, 0x85 },
	0x81318730,	{ 0xD9, 0x86 },
	0x81318731,	{ 0xD9, 0x87 },
	0x81318732,	{ 0xD9, 0x88 },
	0x81318733,	{ 0xD9, 0x89 },
	0x81318734,	{ 0xD9, 0x8A },
	0x81318735,	{ 0xD9, 0x8B },
	0x81318736,	{ 0xD9, 0x8C },
	0x81318737,	{ 0xD9, 0x8D },
	0x81318738,	{ 0xD9, 0x8E },
	0x81318739,	{ 0xD9, 0x8F },
	0x81318830,	{ 0xD9, 0x90 },
	0x81318831,	{ 0xD9, 0x91 },
	0x81318832,	{ 0xD9, 0x92 },
	0x81318833,	{ 0xD9, 0x93 },
	0x81318834,	{ 0xD9, 0x94 },
	0x81318835,	{ 0xD9, 0x95 },
	0x81318836,	{ 0xD9, 0x96 },
	0x81318837,	{ 0xD9, 0x97 },
	0x81318838,	{ 0xD9, 0x98 },
	0x81318839,	{ 0xD9, 0x99 },
	0x81318930,	{ 0xD9, 0x9A },
	0x81318931,	{ 0xD9, 0x9B },
	0x81318932,	{ 0xD9, 0x9C },
	0x81318933,	{ 0xD9, 0x9D },
	0x81318934,	{ 0xD9, 0x9E },
	0x81318935,	{ 0xD9, 0x9F },
	0x81318936,	{ 0xD9, 0xA0 },
	0x81318937,	{ 0xD9, 0xA1 },
	0x81318938,	{ 0xD9, 0xA2 },
	0x81318939,	{ 0xD9, 0xA3 },
	0x81318A30,	{ 0xD9, 0xA4 },
	0x81318A31,	{ 0xD9, 0xA5 },
	0x81318A32,	{ 0xD9, 0xA6 },
	0x81318A33,	{ 0xD9, 0xA7 },
	0x81318A34,	{ 0xD9, 0xA8 },
	0x81318A35,	{ 0xD9, 0xA9 },
	0x81318A36,	{ 0xD9, 0xAA },
	0x81318A37,	{ 0xD9, 0xAB },
	0x81318A38,	{ 0xD9, 0xAC },
	0x81318A39,	{ 0xD9, 0xAD },
	0x81318B30,	{ 0xD9, 0xAE },
	0x81318B31,	{ 0xD9, 0xAF },
	0x81318B32,	{ 0xD9, 0xB0 },
	0x81318B33,	{ 0xD9, 0xB1 },
	0x81318B34,	{ 0xD9, 0xB2 },
	0x81318B35,	{ 0xD9, 0xB3 },
	0x81318B36,	{ 0xD9, 0xB4 },
	0x81318B37,	{ 0xD9, 0xB5 },
	0x81318B38,	{ 0xD9, 0xB6 },
	0x81318B39,	{ 0xD9, 0xB7 },
	0x81318C30,	{ 0xD9, 0xB8 },
	0x81318C31,	{ 0xD9, 0xB9 },
	0x81318C32,	{ 0xD9, 0xBA },
	0x81318C33,	{ 0xD9, 0xBB },
	0x81318C34,	{ 0xD9, 0xBC },
	0x81318C35,	{ 0xD9, 0xBD },
	0x81318C36,	{ 0xD9, 0xBE },
	0x81318C37,	{ 0xD9, 0xBF },
	0x81318C38,	{ 0xDA, 0x80 },
	0x81318C39,	{ 0xDA, 0x81 },
	0x81318D30,	{ 0xDA, 0x82 },
	0x81318D31,	{ 0xDA, 0x83 },
	0x81318D32,	{ 0xDA, 0x84 },
	0x81318D33,	{ 0xDA, 0x85 },
	0x81318D34,	{ 0xDA, 0x86 },
	0x81318D35,	{ 0xDA, 0x87 },
	0x81318D36,	{ 0xDA, 0x88 },
	0x81318D37,	{ 0xDA, 0x89 },
	0x81318D38,	{ 0xDA, 0x8A },
	0x81318D39,	{ 0xDA, 0x8B },
	0x81318E30,	{ 0xDA, 0x8C },
	0x81318E31,	{ 0xDA, 0x8D },
	0x81318E32,	{ 0xDA, 0x8E },
	0x81318E33,	{ 0xDA, 0x8F },
	0x81318E34,	{ 0xDA, 0x90 },
	0x81318E35,	{ 0xDA, 0x91 },
	0x81318E36,	{ 0xDA, 0x92 },
	0x81318E37,	{ 0xDA, 0x93 },
	0x81318E38,	{ 0xDA, 0x94 },
	0x81318E39,	{ 0xDA, 0x95 },
	0x81318F30,	{ 0xDA, 0x96 },
	0x81318F31,	{ 0xDA, 0x97 },
	0x81318F32,	{ 0xDA, 0x98 },
	0x81318F33,	{ 0xDA, 0x99 },
	0x81318F34,	{ 0xDA, 0x9A },
	0x81318F35,	{ 0xDA, 0x9B },
	0x81318F36,	{ 0xDA, 0x9C },
	0x81318F37,	{ 0xDA, 0x9D },
	0x81318F38,	{ 0xDA, 0x9E },
	0x81318F39,	{ 0xDA, 0x9F },
	0x81319030,	{ 0xDA, 0xA0 },
	0x81319031,	{ 0xDA, 0xA1 },
	0x81319032,	{ 0xDA, 0xA2 },
	0x81319033,	{ 0xDA, 0xA3 },
	0x81319034,	{ 0xDA, 0xA4 },
	0x81319035,	{ 0xDA, 0xA5 },
	0x81319036,	{ 0xDA, 0xA6 },
	0x81319037,	{ 0xDA, 0xA7 },
	0x81319038,	{ 0xDA, 0xA8 },
	0x81319039,	{ 0xDA, 0xA9 },
	0x81319130,	{ 0xDA, 0xAA },
	0x81319131,	{ 0xDA, 0xAB },
	0x81319132,	{ 0xDA, 0xAC },
	0x81319133,	{ 0xDA, 0xAD },
	0x81319134,	{ 0xDA, 0xAE },
	0x81319135,	{ 0xDA, 0xAF },
	0x81319136,	{ 0xDA, 0xB0 },
	0x81319137,	{ 0xDA, 0xB1 },
	0x81319138,	{ 0xDA, 0xB2 },
	0x81319139,	{ 0xDA, 0xB3 },
	0x81319230,	{ 0xDA, 0xB4 },
	0x81319231,	{ 0xDA, 0xB5 },
	0x81319232,	{ 0xDA, 0xB6 },
	0x81319233,	{ 0xDA, 0xB7 },
	0x81319234,	{ 0xDA, 0xB8 },
	0x81319235,	{ 0xDA, 0xB9 },
	0x81319236,	{ 0xDA, 0xBA },
	0x81319237,	{ 0xDA, 0xBB },
	0x81319238,	{ 0xDA, 0xBC },
	0x81319239,	{ 0xDA, 0xBD },
	0x81319330,	{ 0xDA, 0xBE },
	0x81319331,	{ 0xDA, 0xBF },
	0x81319332,	{ 0xDB, 0x80 },
	0x81319333,	{ 0xDB, 0x81 },
	0x81319334,	{ 0xDB, 0x82 },
	0x81319335,	{ 0xDB, 0x83 },
	0x81319336,	{ 0xDB, 0x84 },
	0x81319337,	{ 0xDB, 0x85 },
	0x81319338,	{ 0xDB, 0x86 },
	0x81319339,	{ 0xDB, 0x87 },
	0x81319430,	{ 0xDB, 0x88 },
	0x81319431,	{ 0xDB, 0x89 },
	0x81319432,	{ 0xDB, 0x8A },
	0x81319433,	{ 0xDB, 0x8B },
	0x81319434,	{ 0xDB, 0x8C },
	0x81319435,	{ 0xDB, 0x8D },
	0x81319436,	{ 0xDB, 0x8E },
	0x81319437,	{ 0xDB, 0x8F },
	0x81319438,	{ 0xDB, 0x90 },
	0x81319439,	{ 0xDB, 0x91 },
	0x81319530,	{ 0xDB, 0x92 },
	0x81319531,	{ 0xDB, 0x93 },
	0x81319532,	{ 0xDB, 0x94 },
	0x81319533,	{ 0xDB, 0x95 },
	0x81319534,	{ 0xDB, 0x96 },
	0x81319535,	{ 0xDB, 0x97 },
	0x81319536,	{ 0xDB, 0x98 },
	0x81319537,	{ 0xDB, 0x99 },
	0x81319538,	{ 0xDB, 0x9A },
	0x81319539,	{ 0xDB, 0x9B },
	0x81319630,	{ 0xDB, 0x9C },
	0x81319631,	{ 0xDB, 0x9D },
	0x81319632,	{ 0xDB, 0x9E },
	0x81319633,	{ 0xDB, 0x9F },
	0x81319634,	{ 0xDB, 0xA0 },
	0x81319635,	{ 0xDB, 0xA1 },
	0x81319636,	{ 0xDB, 0xA2 },
	0x81319637,	{ 0xDB, 0xA3 },
	0x81319638,	{ 0xDB, 0xA4 },
	0x81319639,	{ 0xDB, 0xA5 },
	0x81319730,	{ 0xDB, 0xA6 },
	0x81319731,	{ 0xDB, 0xA7 },
	0x81319732,	{ 0xDB, 0xA8 },
	0x81319733,	{ 0xDB, 0xA9 },
	0x81319734,	{ 0xDB, 0xAA },
	0x81319735,	{ 0xDB, 0xAB },
	0x81319736,	{ 0xDB, 0xAC },
	0x81319737,	{ 0xDB, 0xAD },
	0x81319738,	{ 0xDB, 0xAE },
	0x81319739,	{ 0xDB, 0xAF },
	0x81319830,	{ 0xDB, 0xB0 },
	0x81319831,	{ 0xDB, 0xB1 },
	0x81319832,	{ 0xDB, 0xB2 },
	0x81319833,	{ 0xDB, 0xB3 },
	0x81319834,	{ 0xDB, 0xB4 },
	0x81319835,	{ 0xDB, 0xB5 },
	0x81319836,	{ 0xDB, 0xB6 },
	0x81319837,	{ 0xDB, 0xB7 },
	0x81319838,	{ 0xDB, 0xB8 },
	0x81319839,	{ 0xDB, 0xB9 },
	0x81319930,	{ 0xDB, 0xBA },
	0x81319931,	{ 0xDB, 0xBB },
	0x81319932,	{ 0xDB, 0xBC },
	0x81319933,	{ 0xDB, 0xBD },
	0x81319934,	{ 0xDB, 0xBE },
	0x81319935,	{ 0xDB, 0xBF },
	0x81319936,	{ 0xDC, 0x80 },
	0x81319937,	{ 0xDC, 0x81 },
	0x81319938,	{ 0xDC, 0x82 },
	0x81319939,	{ 0xDC, 0x83 },
	0x81319A30,	{ 0xDC, 0x84 },
	0x81319A31,	{ 0xDC, 0x85 },
	0x81319A32,	{ 0xDC, 0x86 },
	0x81319A33,	{ 0xDC, 0x87 },
	0x81319A34,	{ 0xDC, 0x88 },
	0x81319A35,	{ 0xDC, 0x89 },
	0x81319A36,	{ 0xDC, 0x8A },
	0x81319A37,	{ 0xDC, 0x8B },
	0x81319A38,	{ 0xDC, 0x8C },
	0x81319A39,	{ 0xDC, 0x8D },
	0x81319B30,	{ 0xDC, 0x8E },
	0x81319B31,	{ 0xDC, 0x8F },
	0x81319B32,	{ 0xDC, 0x90 },
	0x81319B33,	{ 0xDC, 0x91 },
	0x81319B34,	{ 0xDC, 0x92 },
	0x81319B35,	{ 0xDC, 0x93 },
	0x81319B36,	{ 0xDC, 0x94 },
	0x81319B37,	{ 0xDC, 0x95 },
	0x81319B38,	{ 0xDC, 0x96 },
	0x81319B39,	{ 0xDC, 0x97 },
	0x81319C30,	{ 0xDC, 0x98 },
	0x81319C31,	{ 0xDC, 0x99 },
	0x81319C32,	{ 0xDC, 0x9A },
	0x81319C33,	{ 0xDC, 0x9B },
	0x81319C34,	{ 0xDC, 0x9C },
	0x81319C35,	{ 0xDC, 0x9D },
	0x81319C36,	{ 0xDC, 0x9E },
	0x81319C37,	{ 0xDC, 0x9F },
	0x81319C38,	{ 0xDC, 0xA0 },
	0x81319C39,	{ 0xDC, 0xA1 },
	0x81319D30,	{ 0xDC, 0xA2 },
	0x81319D31,	{ 0xDC, 0xA3 },
	0x81319D32,	{ 0xDC, 0xA4 },
	0x81319D33,	{ 0xDC, 0xA5 },
	0x81319D34,	{ 0xDC, 0xA6 },
	0x81319D35,	{ 0xDC, 0xA7 },
	0x81319D36,	{ 0xDC, 0xA8 },
	0x81319D37,	{ 0xDC, 0xA9 },
	0x81319D38,	{ 0xDC, 0xAA },
	0x81319D39,	{ 0xDC, 0xAB },
	0x81319E30,	{ 0xDC, 0xAC },
	0x81319E31,	{ 0xDC, 0xAD },
	0x81319E32,	{ 0xDC, 0xAE },
	0x81319E33,	{ 0xDC, 0xAF },
	0x81319E34,	{ 0xDC, 0xB0 },
	0x81319E35,	{ 0xDC, 0xB1 },
	0x81319E36,	{ 0xDC, 0xB2 },
	0x81319E37,	{ 0xDC, 0xB3 },
	0x81319E38,	{ 0xDC, 0xB4 },
	0x81319E39,	{ 0xDC, 0xB5 },
	0x81319F30,	{ 0xDC, 0xB6 },
	0x81319F31,	{ 0xDC, 0xB7 },
	0x81319F32,	{ 0xDC, 0xB8 },
	0x81319F33,	{ 0xDC, 0xB9 },
	0x81319F34,	{ 0xDC, 0xBA },
	0x81319F35,	{ 0xDC, 0xBB },
	0x81319F36,	{ 0xDC, 0xBC },
	0x81319F37,	{ 0xDC, 0xBD },
	0x81319F38,	{ 0xDC, 0xBE },
	0x81319F39,	{ 0xDC, 0xBF },
	0x8131A030,	{ 0xDD, 0x80 },
	0x8131A031,	{ 0xDD, 0x81 },
	0x8131A032,	{ 0xDD, 0x82 },
	0x8131A033,	{ 0xDD, 0x83 },
	0x8131A034,	{ 0xDD, 0x84 },
	0x8131A035,	{ 0xDD, 0x85 },
	0x8131A036,	{ 0xDD, 0x86 },
	0x8131A037,	{ 0xDD, 0x87 },
	0x8131A038,	{ 0xDD, 0x88 },
	0x8131A039,	{ 0xDD, 0x89 },
	0x8131A130,	{ 0xDD, 0x8A },
	0x8131A131,	{ 0xDD, 0x8B },
	0x8131A132,	{ 0xDD, 0x8C },
	0x8131A133,	{ 0xDD, 0x8D },
	0x8131A134,	{ 0xDD, 0x8E },
	0x8131A135,	{ 0xDD, 0x8F },
	0x8131A136,	{ 0xDD, 0x90 },
	0x8131A137,	{ 0xDD, 0x91 },
	0x8131A138,	{ 0xDD, 0x92 },
	0x8131A139,	{ 0xDD, 0x93 },
	0x8131A230,	{ 0xDD, 0x94 },
	0x8131A231,	{ 0xDD, 0x95 },
	0x8131A232,	{ 0xDD, 0x96 },
	0x8131A233,	{ 0xDD, 0x97 },
	0x8131A234,	{ 0xDD, 0x98 },
	0x8131A235,	{ 0xDD, 0x99 },
	0x8131A236,	{ 0xDD, 0x9A },
	0x8131A237,	{ 0xDD, 0x9B },
	0x8131A238,	{ 0xDD, 0x9C },
	0x8131A239,	{ 0xDD, 0x9D },
	0x8131A330,	{ 0xDD, 0x9E },
	0x8131A331,	{ 0xDD, 0x9F },
	0x8131A332,	{ 0xDD, 0xA0 },
	0x8131A333,	{ 0xDD, 0xA1 },
	0x8131A334,	{ 0xDD, 0xA2 },
	0x8131A335,	{ 0xDD, 0xA3 },
	0x8131A336,	{ 0xDD, 0xA4 },
	0x8131A337,	{ 0xDD, 0xA5 },
	0x8131A338,	{ 0xDD, 0xA6 },
	0x8131A339,	{ 0xDD, 0xA7 },
	0x8131A430,	{ 0xDD, 0xA8 },
	0x8131A431,	{ 0xDD, 0xA9 },
	0x8131A432,	{ 0xDD, 0xAA },
	0x8131A433,	{ 0xDD, 0xAB },
	0x8131A434,	{ 0xDD, 0xAC },
	0x8131A435,	{ 0xDD, 0xAD },
	0x8131A436,	{ 0xDD, 0xAE },
	0x8131A437,	{ 0xDD, 0xAF },
	0x8131A438,	{ 0xDD, 0xB0 },
	0x8131A439,	{ 0xDD, 0xB1 },
	0x8131A530,	{ 0xDD, 0xB2 },
	0x8131A531,	{ 0xDD, 0xB3 },
	0x8131A532,	{ 0xDD, 0xB4 },
	0x8131A533,	{ 0xDD, 0xB5 },
	0x8131A534,	{ 0xDD, 0xB6 },
	0x8131A535,	{ 0xDD, 0xB7 },
	0x8131A536,	{ 0xDD, 0xB8 },
	0x8131A537,	{ 0xDD, 0xB9 },
	0x8131A538,	{ 0xDD, 0xBA },
	0x8131A539,	{ 0xDD, 0xBB },
	0x8131A630,	{ 0xDD, 0xBC },
	0x8131A631,	{ 0xDD, 0xBD },
	0x8131A632,	{ 0xDD, 0xBE },
	0x8131A633,	{ 0xDD, 0xBF },
	0x8131A634,	{ 0xDE, 0x80 },
	0x8131A635,	{ 0xDE, 0x81 },
	0x8131A636,	{ 0xDE, 0x82 },
	0x8131A637,	{ 0xDE, 0x83 },
	0x8131A638,	{ 0xDE, 0x84 },
	0x8131A639,	{ 0xDE, 0x85 },
	0x8131A730,	{ 0xDE, 0x86 },
	0x8131A731,	{ 0xDE, 0x87 },
	0x8131A732,	{ 0xDE, 0x88 },
	0x8131A733,	{ 0xDE, 0x89 },
	0x8131A734,	{ 0xDE, 0x8A },
	0x8131A735,	{ 0xDE, 0x8B },
	0x8131A736,	{ 0xDE, 0x8C },
	0x8131A737,	{ 0xDE, 0x8D },
	0x8131A738,	{ 0xDE, 0x8E },
	0x8131A739,	{ 0xDE, 0x8F },
	0x8131A830,	{ 0xDE, 0x90 },
	0x8131A831,	{ 0xDE, 0x91 },
	0x8131A832,	{ 0xDE, 0x92 },
	0x8131A833,	{ 0xDE, 0x93 },
	0x8131A834,	{ 0xDE, 0x94 },
	0x8131A835,	{ 0xDE, 0x95 },
	0x8131A836,	{ 0xDE, 0x96 },
	0x8131A837,	{ 0xDE, 0x97 },
	0x8131A838,	{ 0xDE, 0x98 },
	0x8131A839,	{ 0xDE, 0x99 },
	0x8131A930,	{ 0xDE, 0x9A },
	0x8131A931,	{ 0xDE, 0x9B },
	0x8131A932,	{ 0xDE, 0x9C },
	0x8131A933,	{ 0xDE, 0x9D },
	0x8131A934,	{ 0xDE, 0x9E },
	0x8131A935,	{ 0xDE, 0x9F },
	0x8131A936,	{ 0xDE, 0xA0 },
	0x8131A937,	{ 0xDE, 0xA1 },
	0x8131A938,	{ 0xDE, 0xA2 },
	0x8131A939,	{ 0xDE, 0xA3 },
	0x8131AA30,	{ 0xDE, 0xA4 },
	0x8131AA31,	{ 0xDE, 0xA5 },
	0x8131AA32,	{ 0xDE, 0xA6 },
	0x8131AA33,	{ 0xDE, 0xA7 },
	0x8131AA34,	{ 0xDE, 0xA8 },
	0x8131AA35,	{ 0xDE, 0xA9 },
	0x8131AA36,	{ 0xDE, 0xAA },
	0x8131AA37,	{ 0xDE, 0xAB },
	0x8131AA38,	{ 0xDE, 0xAC },
	0x8131AA39,	{ 0xDE, 0xAD },
	0x8131AB30,	{ 0xDE, 0xAE },
	0x8131AB31,	{ 0xDE, 0xAF },
	0x8131AB32,	{ 0xDE, 0xB0 },
	0x8131AB33,	{ 0xDE, 0xB1 },
	0x8131AB34,	{ 0xDE, 0xB2 },
	0x8131AB35,	{ 0xDE, 0xB3 },
	0x8131AB36,	{ 0xDE, 0xB4 },
	0x8131AB37,	{ 0xDE, 0xB5 },
	0x8131AB38,	{ 0xDE, 0xB6 },
	0x8131AB39,	{ 0xDE, 0xB7 },
	0x8131AC30,	{ 0xDE, 0xB8 },
	0x8131AC31,	{ 0xDE, 0xB9 },
	0x8131AC32,	{ 0xDE, 0xBA },
	0x8131AC33,	{ 0xDE, 0xBB },
	0x8131AC34,	{ 0xDE, 0xBC },
	0x8131AC35,	{ 0xDE, 0xBD },
	0x8131AC36,	{ 0xDE, 0xBE },
	0x8131AC37,	{ 0xDE, 0xBF },
	0x8131AC38,	{ 0xDF, 0x80 },
	0x8131AC39,	{ 0xDF, 0x81 },
	0x8131AD30,	{ 0xDF, 0x82 },
	0x8131AD31,	{ 0xDF, 0x83 },
	0x8131AD32,	{ 0xDF, 0x84 },
	0x8131AD33,	{ 0xDF, 0x85 },
	0x8131AD34,	{ 0xDF, 0x86 },
	0x8131AD35,	{ 0xDF, 0x87 },
	0x8131AD36,	{ 0xDF, 0x88 },
	0x8131AD37,	{ 0xDF, 0x89 },
	0x8131AD38,	{ 0xDF, 0x8A },
	0x8131AD39,	{ 0xDF, 0x8B },
	0x8131AE30,	{ 0xDF, 0x8C },
	0x8131AE31,	{ 0xDF, 0x8D },
	0x8131AE32,	{ 0xDF, 0x8E },
	0x8131AE33,	{ 0xDF, 0x8F },
	0x8131AE34,	{ 0xDF, 0x90 },
	0x8131AE35,	{ 0xDF, 0x91 },
	0x8131AE36,	{ 0xDF, 0x92 },
	0x8131AE37,	{ 0xDF, 0x93 },
	0x8131AE38,	{ 0xDF, 0x94 },
	0x8131AE39,	{ 0xDF, 0x95 },
	0x8131AF30,	{ 0xDF, 0x96 },
	0x8131AF31,	{ 0xDF, 0x97 },
	0x8131AF32,	{ 0xDF, 0x98 },
	0x8131AF33,	{ 0xDF, 0x99 },
	0x8131AF34,	{ 0xDF, 0x9A },
	0x8131AF35,	{ 0xDF, 0x9B },
	0x8131AF36,	{ 0xDF, 0x9C },
	0x8131AF37,	{ 0xDF, 0x9D },
	0x8131AF38,	{ 0xDF, 0x9E },
	0x8131AF39,	{ 0xDF, 0x9F },
	0x8131B030,	{ 0xDF, 0xA0 },
	0x8131B031,	{ 0xDF, 0xA1 },
	0x8131B032,	{ 0xDF, 0xA2 },
	0x8131B033,	{ 0xDF, 0xA3 },
	0x8131B034,	{ 0xDF, 0xA4 },
	0x8131B035,	{ 0xDF, 0xA5 },
	0x8131B036,	{ 0xDF, 0xA6 },
	0x8131B037,	{ 0xDF, 0xA7 },
	0x8131B038,	{ 0xDF, 0xA8 },
	0x8131B039,	{ 0xDF, 0xA9 },
	0x8131B130,	{ 0xDF, 0xAA },
	0x8131B131,	{ 0xDF, 0xAB },
	0x8131B132,	{ 0xDF, 0xAC },
	0x8131B133,	{ 0xDF, 0xAD },
	0x8131B134,	{ 0xDF, 0xAE },
	0x8131B135,	{ 0xDF, 0xAF },
	0x8131B136,	{ 0xDF, 0xB0 },
	0x8131B137,	{ 0xDF, 0xB1 },
	0x8131B138,	{ 0xDF, 0xB2 },
	0x8131B139,	{ 0xDF, 0xB3 },
	0x8131B230,	{ 0xDF, 0xB4 },
	0x8131B231,	{ 0xDF, 0xB5 },
	0x8131B232,	{ 0xDF, 0xB6 },
	0x8131B233,	{ 0xDF, 0xB7 },
	0x8131B234,	{ 0xDF, 0xB8 },
	0x8131B235,	{ 0xDF, 0xB9 },
	0x8131B236,	{ 0xDF, 0xBA },
	0x8131B237,	{ 0xDF, 0xBB },
	0x8131B238,	{ 0xDF, 0xBC },
	0x8131B239,	{ 0xDF, 0xBD },
	0x8131B330,	{ 0xDF, 0xBE },
	0x8131B331,	{ 0xDF, 0xBF },
	0x8131B332,	{ 0xE0, 0xA0, 0x80 },
	0x8131B333,	{ 0xE0, 0xA0, 0x81 },
	0x8131B334,	{ 0xE0, 0xA0, 0x82 },
	0x8131B335,	{ 0xE0, 0xA0, 0x83 },
	0x8131B336,	{ 0xE0, 0xA0, 0x84 },
	0x8131B337,	{ 0xE0, 0xA0, 0x85 },
	0x8131B338,	{ 0xE0, 0xA0, 0x86 },
	0x8131B339,	{ 0xE0, 0xA0, 0x87 },
	0x8131B430,	{ 0xE0, 0xA0, 0x88 },
	0x8131B431,	{ 0xE0, 0xA0, 0x89 },
	0x8131B432,	{ 0xE0, 0xA0, 0x8A },
	0x8131B433,	{ 0xE0, 0xA0, 0x8B },
	0x8131B434,	{ 0xE0, 0xA0, 0x8C },
	0x8131B435,	{ 0xE0, 0xA0, 0x8D },
	0x8131B436,	{ 0xE0, 0xA0, 0x8E },
	0x8131B437,	{ 0xE0, 0xA0, 0x8F },
	0x8131B438,	{ 0xE0, 0xA0, 0x90 },
	0x8131B439,	{ 0xE0, 0xA0, 0x91 },
	0x8131B530,	{ 0xE0, 0xA0, 0x92 },
	0x8131B531,	{ 0xE0, 0xA0, 0x93 },
	0x8131B532,	{ 0xE0, 0xA0, 0x94 },
	0x8131B533,	{ 0xE0, 0xA0, 0x95 },
	0x8131B534,	{ 0xE0, 0xA0, 0x96 },
	0x8131B535,	{ 0xE0, 0xA0, 0x97 },
	0x8131B536,	{ 0xE0, 0xA0, 0x98 },
	0x8131B537,	{ 0xE0, 0xA0, 0x99 },
	0x8131B538,	{ 0xE0, 0xA0, 0x9A },
	0x8131B539,	{ 0xE0, 0xA0, 0x9B },
	0x8131B630,	{ 0xE0, 0xA0, 0x9C },
	0x8131B631,	{ 0xE0, 0xA0, 0x9D },
	0x8131B632,	{ 0xE0, 0xA0, 0x9E },
	0x8131B633,	{ 0xE0, 0xA0, 0x9F },
	0x8131B634,	{ 0xE0, 0xA0, 0xA0 },
	0x8131B635,	{ 0xE0, 0xA0, 0xA1 },
	0x8131B636,	{ 0xE0, 0xA0, 0xA2 },
	0x8131B637,	{ 0xE0, 0xA0, 0xA3 },
	0x8131B638,	{ 0xE0, 0xA0, 0xA4 },
	0x8131B639,	{ 0xE0, 0xA0, 0xA5 },
	0x8131B730,	{ 0xE0, 0xA0, 0xA6 },
	0x8131B731,	{ 0xE0, 0xA0, 0xA7 },
	0x8131B732,	{ 0xE0, 0xA0, 0xA8 },
	0x8131B733,	{ 0xE0, 0xA0, 0xA9 },
	0x8131B734,	{ 0xE0, 0xA0, 0xAA },
	0x8131B735,	{ 0xE0, 0xA0, 0xAB },
	0x8131B736,	{ 0xE0, 0xA0, 0xAC },
	0x8131B737,	{ 0xE0, 0xA0, 0xAD },
	0x8131B738,	{ 0xE0, 0xA0, 0xAE },
	0x8131B739,	{ 0xE0, 0xA0, 0xAF },
	0x8131B830,	{ 0xE0, 0xA0, 0xB0 },
	0x8131B831,	{ 0xE0, 0xA0, 0xB1 },
	0x8131B832,	{ 0xE0, 0xA0, 0xB2 },
	0x8131B833,	{ 0xE0, 0xA0, 0xB3 },
	0x8131B834,	{ 0xE0, 0xA0, 0xB4 },
	0x8131B835,	{ 0xE0, 0xA0, 0xB5 },
	0x8131B836,	{ 0xE0, 0xA0, 0xB6 },
	0x8131B837,	{ 0xE0, 0xA0, 0xB7 },
	0x8131B838,	{ 0xE0, 0xA0, 0xB8 },
	0x8131B839,	{ 0xE0, 0xA0, 0xB9 },
	0x8131B930,	{ 0xE0, 0xA0, 0xBA },
	0x8131B931,	{ 0xE0, 0xA0, 0xBB },
	0x8131B932,	{ 0xE0, 0xA0, 0xBC },
	0x8131B933,	{ 0xE0, 0xA0, 0xBD },
	0x8131B934,	{ 0xE0, 0xA0, 0xBE },
	0x8131B935,	{ 0xE0, 0xA0, 0xBF },
	0x8131B936,	{ 0xE0, 0xA1, 0x80 },
	0x8131B937,	{ 0xE0, 0xA1, 0x81 },
	0x8131B938,	{ 0xE0, 0xA1, 0x82 },
	0x8131B939,	{ 0xE0, 0xA1, 0x83 },
	0x8131BA30,	{ 0xE0, 0xA1, 0x84 },
	0x8131BA31,	{ 0xE0, 0xA1, 0x85 },
	0x8131BA32,	{ 0xE0, 0xA1, 0x86 },
	0x8131BA33,	{ 0xE0, 0xA1, 0x87 },
	0x8131BA34,	{ 0xE0, 0xA1, 0x88 },
	0x8131BA35,	{ 0xE0, 0xA1, 0x89 },
	0x8131BA36,	{ 0xE0, 0xA1, 0x8A },
	0x8131BA37,	{ 0xE0, 0xA1, 0x8B },
	0x8131BA38,	{ 0xE0, 0xA1, 0x8C },
	0x8131BA39,	{ 0xE0, 0xA1, 0x8D },
	0x8131BB30,	{ 0xE0, 0xA1, 0x8E },
	0x8131BB31,	{ 0xE0, 0xA1, 0x8F },
	0x8131BB32,	{ 0xE0, 0xA1, 0x90 },
	0x8131BB33,	{ 0xE0, 0xA1, 0x91 },
	0x8131BB34,	{ 0xE0, 0xA1, 0x92 },
	0x8131BB35,	{ 0xE0, 0xA1, 0x93 },
	0x8131BB36,	{ 0xE0, 0xA1, 0x94 },
	0x8131BB37,	{ 0xE0, 0xA1, 0x95 },
	0x8131BB38,	{ 0xE0, 0xA1, 0x96 },
	0x8131BB39,	{ 0xE0, 0xA1, 0x97 },
	0x8131BC30,	{ 0xE0, 0xA1, 0x98 },
	0x8131BC31,	{ 0xE0, 0xA1, 0x99 },
	0x8131BC32,	{ 0xE0, 0xA1, 0x9A },
	0x8131BC33,	{ 0xE0, 0xA1, 0x9B },
	0x8131BC34,	{ 0xE0, 0xA1, 0x9C },
	0x8131BC35,	{ 0xE0, 0xA1, 0x9D },
	0x8131BC36,	{ 0xE0, 0xA1, 0x9E },
	0x8131BC37,	{ 0xE0, 0xA1, 0x9F },
	0x8131BC38,	{ 0xE0, 0xA1, 0xA0 },
	0x8131BC39,	{ 0xE0, 0xA1, 0xA1 },
	0x8131BD30,	{ 0xE0, 0xA1, 0xA2 },
	0x8131BD31,	{ 0xE0, 0xA1, 0xA3 },
	0x8131BD32,	{ 0xE0, 0xA1, 0xA4 },
	0x8131BD33,	{ 0xE0, 0xA1, 0xA5 },
	0x8131BD34,	{ 0xE0, 0xA1, 0xA6 },
	0x8131BD35,	{ 0xE0, 0xA1, 0xA7 },
	0x8131BD36,	{ 0xE0, 0xA1, 0xA8 },
	0x8131BD37,	{ 0xE0, 0xA1, 0xA9 },
	0x8131BD38,	{ 0xE0, 0xA1, 0xAA },
	0x8131BD39,	{ 0xE0, 0xA1, 0xAB },
	0x8131BE30,	{ 0xE0, 0xA1, 0xAC },
	0x8131BE31,	{ 0xE0, 0xA1, 0xAD },
	0x8131BE32,	{ 0xE0, 0xA1, 0xAE },
	0x8131BE33,	{ 0xE0, 0xA1, 0xAF },
	0x8131BE34,	{ 0xE0, 0xA1, 0xB0 },
	0x8131BE35,	{ 0xE0, 0xA1, 0xB1 },
	0x8131BE36,	{ 0xE0, 0xA1, 0xB2 },
	0x8131BE37,	{ 0xE0, 0xA1, 0xB3 },
	0x8131BE38,	{ 0xE0, 0xA1, 0xB4 },
	0x8131BE39,	{ 0xE0, 0xA1, 0xB5 },
	0x8131BF30,	{ 0xE0, 0xA1, 0xB6 },
	0x8131BF31,	{ 0xE0, 0xA1, 0xB7 },
	0x8131BF32,	{ 0xE0, 0xA1, 0xB8 },
	0x8131BF33,	{ 0xE0, 0xA1, 0xB9 },
	0x8131BF34,	{ 0xE0, 0xA1, 0xBA },
	0x8131BF35,	{ 0xE0, 0xA1, 0xBB },
	0x8131BF36,	{ 0xE0, 0xA1, 0xBC },
	0x8131BF37,	{ 0xE0, 0xA1, 0xBD },
	0x8131BF38,	{ 0xE0, 0xA1, 0xBE },
	0x8131BF39,	{ 0xE0, 0xA1, 0xBF },
	0x8131C030,	{ 0xE0, 0xA2, 0x80 },
	0x8131C031,	{ 0xE0, 0xA2, 0x81 },
	0x8131C032,	{ 0xE0, 0xA2, 0x82 },
	0x8131C033,	{ 0xE0, 0xA2, 0x83 },
	0x8131C034,	{ 0xE0, 0xA2, 0x84 },
	0x8131C035,	{ 0xE0, 0xA2, 0x85 },
	0x8131C036,	{ 0xE0, 0xA2, 0x86 },
	0x8131C037,	{ 0xE0, 0xA2, 0x87 },
	0x8131C038,	{ 0xE0, 0xA2, 0x88 },
	0x8131C039,	{ 0xE0, 0xA2, 0x89 },
	0x8131C130,	{ 0xE0, 0xA2, 0x8A },
	0x8131C131,	{ 0xE0, 0xA2, 0x8B },
	0x8131C132,	{ 0xE0, 0xA2, 0x8C },
	0x8131C133,	{ 0xE0, 0xA2, 0x8D },
	0x8131C134,	{ 0xE0, 0xA2, 0x8E },
	0x8131C135,	{ 0xE0, 0xA2, 0x8F },
	0x8131C136,	{ 0xE0, 0xA2, 0x90 },
	0x8131C137,	{ 0xE0, 0xA2, 0x91 },
	0x8131C138,	{ 0xE0, 0xA2, 0x92 },
	0x8131C139,	{ 0xE0, 0xA2, 0x93 },
	0x8131C230,	{ 0xE0, 0xA2, 0x94 },
	0x8131C231,	{ 0xE0, 0xA2, 0x95 },
	0x8131C232,	{ 0xE0, 0xA2, 0x96 },
	0x8131C233,	{ 0xE0, 0xA2, 0x97 },
	0x8131C234,	{ 0xE0, 0xA2, 0x98 },
	0x8131C235,	{ 0xE0, 0xA2, 0x99 },
	0x8131C236,	{ 0xE0, 0xA2, 0x9A },
	0x8131C237,	{ 0xE0, 0xA2, 0x9B },
	0x8131C238,	{ 0xE0, 0xA2, 0x9C },
	0x8131C239,	{ 0xE0, 0xA2, 0x9D },
	0x8131C330,	{ 0xE0, 0xA2, 0x9E },
	0x8131C331,	{ 0xE0, 0xA2, 0x9F },
	0x8131C332,	{ 0xE0, 0xA2, 0xA0 },
	0x8131C333,	{ 0xE0, 0xA2, 0xA1 },
	0x8131C334,	{ 0xE0, 0xA2, 0xA2 },
	0x8131C335,	{ 0xE0, 0xA2, 0xA3 },
	0x8131C336,	{ 0xE0, 0xA2, 0xA4 },
	0x8131C337,	{ 0xE0, 0xA2, 0xA5 },
	0x8131C338,	{ 0xE0, 0xA2, 0xA6 },
	0x8131C339,	{ 0xE0, 0xA2, 0xA7 },
	0x8131C430,	{ 0xE0, 0xA2, 0xA8 },
	0x8131C431,	{ 0xE0, 0xA2, 0xA9 },
	0x8131C432,	{ 0xE0, 0xA2, 0xAA },
	0x8131C433,	{ 0xE0, 0xA2, 0xAB },
	0x8131C434,	{ 0xE0, 0xA2, 0xAC },
	0x8131C435,	{ 0xE0, 0xA2, 0xAD },
	0x8131C436,	{ 0xE0, 0xA2, 0xAE },
	0x8131C437,	{ 0xE0, 0xA2, 0xAF },
	0x8131C438,	{ 0xE0, 0xA2, 0xB0 },
	0x8131C439,	{ 0xE0, 0xA2, 0xB1 },
	0x8131C530,	{ 0xE0, 0xA2, 0xB2 },
	0x8131C531,	{ 0xE0, 0xA2, 0xB3 },
	0x8131C532,	{ 0xE0, 0xA2, 0xB4 },
	0x8131C533,	{ 0xE0, 0xA2, 0xB5 },
	0x8131C534,	{ 0xE0, 0xA2, 0xB6 },
	0x8131C535,	{ 0xE0, 0xA2, 0xB7 },
	0x8131C536,	{ 0xE0, 0xA2, 0xB8 },
	0x8131C537,	{ 0xE0, 0xA2, 0xB9 },
	0x8131C538,	{ 0xE0, 0xA2, 0xBA },
	0x8131C539,	{ 0xE0, 0xA2, 0xBB },
	0x8131C630,	{ 0xE0, 0xA2, 0xBC },
	0x8131C631,	{ 0xE0, 0xA2, 0xBD },
	0x8131C632,	{ 0xE0, 0xA2, 0xBE },
	0x8131C633,	{ 0xE0, 0xA2, 0xBF },
	0x8131C634,	{ 0xE0, 0xA3, 0x80 },
	0x8131C635,	{ 0xE0, 0xA3, 0x81 },
	0x8131C636,	{ 0xE0, 0xA3, 0x82 },
	0x8131C637,	{ 0xE0, 0xA3, 0x83 },
	0x8131C638,	{ 0xE0, 0xA3, 0x84 },
	0x8131C639,	{ 0xE0, 0xA3, 0x85 },
	0x8131C730,	{ 0xE0, 0xA3, 0x86 },
	0x8131C731,	{ 0xE0, 0xA3, 0x87 },
	0x8131C732,	{ 0xE0, 0xA3, 0x88 },
	0x8131C733,	{ 0xE0, 0xA3, 0x89 },
	0x8131C734,	{ 0xE0, 0xA3, 0x8A },
	0x8131C735,	{ 0xE0, 0xA3, 0x8B },
	0x8131C736,	{ 0xE0, 0xA3, 0x8C },
	0x8131C737,	{ 0xE0, 0xA3, 0x8D },
	0x8131C738,	{ 0xE0, 0xA3, 0x8E },
	0x8131C739,	{ 0xE0, 0xA3, 0x8F },
	0x8131C830,	{ 0xE0, 0xA3, 0x90 },
	0x8131C831,	{ 0xE0, 0xA3, 0x91 },
	0x8131C832,	{ 0xE0, 0xA3, 0x92 },
	0x8131C833,	{ 0xE0, 0xA3, 0x93 },
	0x8131C834,	{ 0xE0, 0xA3, 0x94 },
	0x8131C835,	{ 0xE0, 0xA3, 0x95 },
	0x8131C836,	{ 0xE0, 0xA3, 0x96 },
	0x8131C837,	{ 0xE0, 0xA3, 0x97 },
	0x8131C838,	{ 0xE0, 0xA3, 0x98 },
	0x8131C839,	{ 0xE0, 0xA3, 0x99 },
	0x8131C930,	{ 0xE0, 0xA3, 0x9A },
	0x8131C931,	{ 0xE0, 0xA3, 0x9B },
	0x8131C932,	{ 0xE0, 0xA3, 0x9C },
	0x8131C933,	{ 0xE0, 0xA3, 0x9D },
	0x8131C934,	{ 0xE0, 0xA3, 0x9E },
	0x8131C935,	{ 0xE0, 0xA3, 0x9F },
	0x8131C936,	{ 0xE0, 0xA3, 0xA0 },
	0x8131C937,	{ 0xE0, 0xA3, 0xA1 },
	0x8131C938,	{ 0xE0, 0xA3, 0xA2 },
	0x8131C939,	{ 0xE0, 0xA3, 0xA3 },
	0x8131CA30,	{ 0xE0, 0xA3, 0xA4 },
	0x8131CA31,	{ 0xE0, 0xA3, 0xA5 },
	0x8131CA32,	{ 0xE0, 0xA3, 0xA6 },
	0x8131CA33,	{ 0xE0, 0xA3, 0xA7 },
	0x8131CA34,	{ 0xE0, 0xA3, 0xA8 },
	0x8131CA35,	{ 0xE0, 0xA3, 0xA9 },
	0x8131CA36,	{ 0xE0, 0xA3, 0xAA },
	0x8131CA37,	{ 0xE0, 0xA3, 0xAB },
	0x8131CA38,	{ 0xE0, 0xA3, 0xAC },
	0x8131CA39,	{ 0xE0, 0xA3, 0xAD },
	0x8131CB30,	{ 0xE0, 0xA3, 0xAE },
	0x8131CB31,	{ 0xE0, 0xA3, 0xAF },
	0x8131CB32,	{ 0xE0, 0xA3, 0xB0 },
	0x8131CB33,	{ 0xE0, 0xA3, 0xB1 },
	0x8131CB34,	{ 0xE0, 0xA3, 0xB2 },
	0x8131CB35,	{ 0xE0, 0xA3, 0xB3 },
	0x8131CB36,	{ 0xE0, 0xA3, 0xB4 },
	0x8131CB37,	{ 0xE0, 0xA3, 0xB5 },
	0x8131CB38,	{ 0xE0, 0xA3, 0xB6 },
	0x8131CB39,	{ 0xE0, 0xA3, 0xB7 },
	0x8131CC30,	{ 0xE0, 0xA3, 0xB8 },
	0x8131CC31,	{ 0xE0, 0xA3, 0xB9 },
	0x8131CC32,	{ 0xE0, 0xA3, 0xBA },
	0x8131CC33,	{ 0xE0, 0xA3, 0xBB },
	0x8131CC34,	{ 0xE0, 0xA3, 0xBC },
	0x8131CC35,	{ 0xE0, 0xA3, 0xBD },
	0x8131CC36,	{ 0xE0, 0xA3, 0xBE },
	0x8131CC37,	{ 0xE0, 0xA3, 0xBF },
	0x8131CC38,	{ 0xE0, 0xA4, 0x80 },
	0x8131CC39,	{ 0xE0, 0xA4, 0x81 },
	0x8131CD30,	{ 0xE0, 0xA4, 0x82 },
	0x8131CD31,	{ 0xE0, 0xA4, 0x83 },
	0x8131CD32,	{ 0xE0, 0xA4, 0x84 },
	0x8131CD33,	{ 0xE0, 0xA4, 0x85 },
	0x8131CD34,	{ 0xE0, 0xA4, 0x86 },
	0x8131CD35,	{ 0xE0, 0xA4, 0x87 },
	0x8131CD36,	{ 0xE0, 0xA4, 0x88 },
	0x8131CD37,	{ 0xE0, 0xA4, 0x89 },
	0x8131CD38,	{ 0xE0, 0xA4, 0x8A },
	0x8131CD39,	{ 0xE0, 0xA4, 0x8B },
	0x8131CE30,	{ 0xE0, 0xA4, 0x8C },
	0x8131CE31,	{ 0xE0, 0xA4, 0x8D },
	0x8131CE32,	{ 0xE0, 0xA4, 0x8E },
	0x8131CE33,	{ 0xE0, 0xA4, 0x8F },
	0x8131CE34,	{ 0xE0, 0xA4, 0x90 },
	0x8131CE35,	{ 0xE0, 0xA4, 0x91 },
	0x8131CE36,	{ 0xE0, 0xA4, 0x92 },
	0x8131CE37,	{ 0xE0, 0xA4, 0x93 },
	0x8131CE38,	{ 0xE0, 0xA4, 0x94 },
	0x8131CE39,	{ 0xE0, 0xA4, 0x95 },
	0x8131CF30,	{ 0xE0, 0xA4, 0x96 },
	0x8131CF31,	{ 0xE0, 0xA4, 0x97 },
	0x8131CF32,	{ 0xE0, 0xA4, 0x98 },
	0x8131CF33,	{ 0xE0, 0xA4, 0x99 },
	0x8131CF34,	{ 0xE0, 0xA4, 0x9A },
	0x8131CF35,	{ 0xE0, 0xA4, 0x9B },
	0x8131CF36,	{ 0xE0, 0xA4, 0x9C },
	0x8131CF37,	{ 0xE0, 0xA4, 0x9D },
	0x8131CF38,	{ 0xE0, 0xA4, 0x9E },
	0x8131CF39,	{ 0xE0, 0xA4, 0x9F },
	0x8131D030,	{ 0xE0, 0xA4, 0xA0 },
	0x8131D031,	{ 0xE0, 0xA4, 0xA1 },
	0x8131D032,	{ 0xE0, 0xA4, 0xA2 },
	0x8131D033,	{ 0xE0, 0xA4, 0xA3 },
	0x8131D034,	{ 0xE0, 0xA4, 0xA4 },
	0x8131D035,	{ 0xE0, 0xA4, 0xA5 },
	0x8131D036,	{ 0xE0, 0xA4, 0xA6 },
	0x8131D037,	{ 0xE0, 0xA4, 0xA7 },
	0x8131D038,	{ 0xE0, 0xA4, 0xA8 },
	0x8131D039,	{ 0xE0, 0xA4, 0xA9 },
	0x8131D130,	{ 0xE0, 0xA4, 0xAA },
	0x8131D131,	{ 0xE0, 0xA4, 0xAB },
	0x8131D132,	{ 0xE0, 0xA4, 0xAC },
	0x8131D133,	{ 0xE0, 0xA4, 0xAD },
	0x8131D134,	{ 0xE0, 0xA4, 0xAE },
	0x8131D135,	{ 0xE0, 0xA4, 0xAF },
	0x8131D136,	{ 0xE0, 0xA4, 0xB0 },
	0x8131D137,	{ 0xE0, 0xA4, 0xB1 },
	0x8131D138,	{ 0xE0, 0xA4, 0xB2 },
	0x8131D139,	{ 0xE0, 0xA4, 0xB3 },
	0x8131D230,	{ 0xE0, 0xA4, 0xB4 },
	0x8131D231,	{ 0xE0, 0xA4, 0xB5 },
	0x8131D232,	{ 0xE0, 0xA4, 0xB6 },
	0x8131D233,	{ 0xE0, 0xA4, 0xB7 },
	0x8131D234,	{ 0xE0, 0xA4, 0xB8 },
	0x8131D235,	{ 0xE0, 0xA4, 0xB9 },
	0x8131D236,	{ 0xE0, 0xA4, 0xBA },
	0x8131D237,	{ 0xE0, 0xA4, 0xBB },
	0x8131D238,	{ 0xE0, 0xA4, 0xBC },
	0x8131D239,	{ 0xE0, 0xA4, 0xBD },
	0x8131D330,	{ 0xE0, 0xA4, 0xBE },
	0x8131D331,	{ 0xE0, 0xA4, 0xBF },
	0x8131D332,	{ 0xE0, 0xA5, 0x80 },
	0x8131D333,	{ 0xE0, 0xA5, 0x81 },
	0x8131D334,	{ 0xE0, 0xA5, 0x82 },
	0x8131D335,	{ 0xE0, 0xA5, 0x83 },
	0x8131D336,	{ 0xE0, 0xA5, 0x84 },
	0x8131D337,	{ 0xE0, 0xA5, 0x85 },
	0x8131D338,	{ 0xE0, 0xA5, 0x86 },
	0x8131D339,	{ 0xE0, 0xA5, 0x87 },
	0x8131D430,	{ 0xE0, 0xA5, 0x88 },
	0x8131D431,	{ 0xE0, 0xA5, 0x89 },
	0x8131D432,	{ 0xE0, 0xA5, 0x8A },
	0x8131D433,	{ 0xE0, 0xA5, 0x8B },
	0x8131D434,	{ 0xE0, 0xA5, 0x8C },
	0x8131D435,	{ 0xE0, 0xA5, 0x8D },
	0x8131D436,	{ 0xE0, 0xA5, 0x8E },
	0x8131D437,	{ 0xE0, 0xA5, 0x8F },
	0x8131D438,	{ 0xE0, 0xA5, 0x90 },
	0x8131D439,	{ 0xE0, 0xA5, 0x91 },
	0x8131D530,	{ 0xE0, 0xA5, 0x92 },
	0x8131D531,	{ 0xE0, 0xA5, 0x93 },
	0x8131D532,	{ 0xE0, 0xA5, 0x94 },
	0x8131D533,	{ 0xE0, 0xA5, 0x95 },
	0x8131D534,	{ 0xE0, 0xA5, 0x96 },
	0x8131D535,	{ 0xE0, 0xA5, 0x97 },
	0x8131D536,	{ 0xE0, 0xA5, 0x98 },
	0x8131D537,	{ 0xE0, 0xA5, 0x99 },
	0x8131D538,	{ 0xE0, 0xA5, 0x9A },
	0x8131D539,	{ 0xE0, 0xA5, 0x9B },
	0x8131D630,	{ 0xE0, 0xA5, 0x9C },
	0x8131D631,	{ 0xE0, 0xA5, 0x9D },
	0x8131D632,	{ 0xE0, 0xA5, 0x9E },
	0x8131D633,	{ 0xE0, 0xA5, 0x9F },
	0x8131D634,	{ 0xE0, 0xA5, 0xA0 },
	0x8131D635,	{ 0xE0, 0xA5, 0xA1 },
	0x8131D636,	{ 0xE0, 0xA5, 0xA2 },
	0x8131D637,	{ 0xE0, 0xA5, 0xA3 },
	0x8131D638,	{ 0xE0, 0xA5, 0xA4 },
	0x8131D639,	{ 0xE0, 0xA5, 0xA5 },
	0x8131D730,	{ 0xE0, 0xA5, 0xA6 },
	0x8131D731,	{ 0xE0, 0xA5, 0xA7 },
	0x8131D732,	{ 0xE0, 0xA5, 0xA8 },
	0x8131D733,	{ 0xE0, 0xA5, 0xA9 },
	0x8131D734,	{ 0xE0, 0xA5, 0xAA },
	0x8131D735,	{ 0xE0, 0xA5, 0xAB },
	0x8131D736,	{ 0xE0, 0xA5, 0xAC },
	0x8131D737,	{ 0xE0, 0xA5, 0xAD },
	0x8131D738,	{ 0xE0, 0xA5, 0xAE },
	0x8131D739,	{ 0xE0, 0xA5, 0xAF },
	0x8131D830,	{ 0xE0, 0xA5, 0xB0 },
	0x8131D831,	{ 0xE0, 0xA5, 0xB1 },
	0x8131D832,	{ 0xE0, 0xA5, 0xB2 },
	0x8131D833,	{ 0xE0, 0xA5, 0xB3 },
	0x8131D834,	{ 0xE0, 0xA5, 0xB4 },
	0x8131D835,	{ 0xE0, 0xA5, 0xB5 },
	0x8131D836,	{ 0xE0, 0xA5, 0xB6 },
	0x8131D837,	{ 0xE0, 0xA5, 0xB7 },
	0x8131D838,	{ 0xE0, 0xA5, 0xB8 },
	0x8131D839,	{ 0xE0, 0xA5, 0xB9 },
	0x8131D930,	{ 0xE0, 0xA5, 0xBA },
	0x8131D931,	{ 0xE0, 0xA5, 0xBB },
	0x8131D932,	{ 0xE0, 0xA5, 0xBC },
	0x8131D933,	{ 0xE0, 0xA5, 0xBD },
	0x8131D934,	{ 0xE0, 0xA5, 0xBE },
	0x8131D935,	{ 0xE0, 0xA5, 0xBF },
	0x8131D936,	{ 0xE0, 0xA6, 0x80 },
	0x8131D937,	{ 0xE0, 0xA6, 0x81 },
	0x8131D938,	{ 0xE0, 0xA6, 0x82 },
	0x8131D939,	{ 0xE0, 0xA6, 0x83 },
	0x8131DA30,	{ 0xE0, 0xA6, 0x84 },
	0x8131DA31,	{ 0xE0, 0xA6, 0x85 },
	0x8131DA32,	{ 0xE0, 0xA6, 0x86 },
	0x8131DA33,	{ 0xE0, 0xA6, 0x87 },
	0x8131DA34,	{ 0xE0, 0xA6, 0x88 },
	0x8131DA35,	{ 0xE0, 0xA6, 0x89 },
	0x8131DA36,	{ 0xE0, 0xA6, 0x8A },
	0x8131DA37,	{ 0xE0, 0xA6, 0x8B },
	0x8131DA38,	{ 0xE0, 0xA6, 0x8C },
	0x8131DA39,	{ 0xE0, 0xA6, 0x8D },
	0x8131DB30,	{ 0xE0, 0xA6, 0x8E },
	0x8131DB31,	{ 0xE0, 0xA6, 0x8F },
	0x8131DB32,	{ 0xE0, 0xA6, 0x90 },
	0x8131DB33,	{ 0xE0, 0xA6, 0x91 },
	0x8131DB34,	{ 0xE0, 0xA6, 0x92 },
	0x8131DB35,	{ 0xE0, 0xA6, 0x93 },
	0x8131DB36,	{ 0xE0, 0xA6, 0x94 },
	0x8131DB37,	{ 0xE0, 0xA6, 0x95 },
	0x8131DB38,	{ 0xE0, 0xA6, 0x96 },
	0x8131DB39,	{ 0xE0, 0xA6, 0x97 },
	0x8131DC30,	{ 0xE0, 0xA6, 0x98 },
	0x8131DC31,	{ 0xE0, 0xA6, 0x99 },
	0x8131DC32,	{ 0xE0, 0xA6, 0x9A },
	0x8131DC33,	{ 0xE0, 0xA6, 0x9B },
	0x8131DC34,	{ 0xE0, 0xA6, 0x9C },
	0x8131DC35,	{ 0xE0, 0xA6, 0x9D },
	0x8131DC36,	{ 0xE0, 0xA6, 0x9E },
	0x8131DC37,	{ 0xE0, 0xA6, 0x9F },
	0x8131DC38,	{ 0xE0, 0xA6, 0xA0 },
	0x8131DC39,	{ 0xE0, 0xA6, 0xA1 },
	0x8131DD30,	{ 0xE0, 0xA6, 0xA2 },
	0x8131DD31,	{ 0xE0, 0xA6, 0xA3 },
	0x8131DD32,	{ 0xE0, 0xA6, 0xA4 },
	0x8131DD33,	{ 0xE0, 0xA6, 0xA5 },
	0x8131DD34,	{ 0xE0, 0xA6, 0xA6 },
	0x8131DD35,	{ 0xE0, 0xA6, 0xA7 },
	0x8131DD36,	{ 0xE0, 0xA6, 0xA8 },
	0x8131DD37,	{ 0xE0, 0xA6, 0xA9 },
	0x8131DD38,	{ 0xE0, 0xA6, 0xAA },
	0x8131DD39,	{ 0xE0, 0xA6, 0xAB },
	0x8131DE30,	{ 0xE0, 0xA6, 0xAC },
	0x8131DE31,	{ 0xE0, 0xA6, 0xAD },
	0x8131DE32,	{ 0xE0, 0xA6, 0xAE },
	0x8131DE33,	{ 0xE0, 0xA6, 0xAF },
	0x8131DE34,	{ 0xE0, 0xA6, 0xB0 },
	0x8131DE35,	{ 0xE0, 0xA6, 0xB1 },
	0x8131DE36,	{ 0xE0, 0xA6, 0xB2 },
	0x8131DE37,	{ 0xE0, 0xA6, 0xB3 },
	0x8131DE38,	{ 0xE0, 0xA6, 0xB4 },
	0x8131DE39,	{ 0xE0, 0xA6, 0xB5 },
	0x8131DF30,	{ 0xE0, 0xA6, 0xB6 },
	0x8131DF31,	{ 0xE0, 0xA6, 0xB7 },
	0x8131DF32,	{ 0xE0, 0xA6, 0xB8 },
	0x8131DF33,	{ 0xE0, 0xA6, 0xB9 },
	0x8131DF34,	{ 0xE0, 0xA6, 0xBA },
	0x8131DF35,	{ 0xE0, 0xA6, 0xBB },
	0x8131DF36,	{ 0xE0, 0xA6, 0xBC },
	0x8131DF37,	{ 0xE0, 0xA6, 0xBD },
	0x8131DF38,	{ 0xE0, 0xA6, 0xBE },
	0x8131DF39,	{ 0xE0, 0xA6, 0xBF },
	0x8131E030,	{ 0xE0, 0xA7, 0x80 },
	0x8131E031,	{ 0xE0, 0xA7, 0x81 },
	0x8131E032,	{ 0xE0, 0xA7, 0x82 },
	0x8131E033,	{ 0xE0, 0xA7, 0x83 },
	0x8131E034,	{ 0xE0, 0xA7, 0x84 },
	0x8131E035,	{ 0xE0, 0xA7, 0x85 },
	0x8131E036,	{ 0xE0, 0xA7, 0x86 },
	0x8131E037,	{ 0xE0, 0xA7, 0x87 },
	0x8131E038,	{ 0xE0, 0xA7, 0x88 },
	0x8131E039,	{ 0xE0, 0xA7, 0x89 },
	0x8131E130,	{ 0xE0, 0xA7, 0x8A },
	0x8131E131,	{ 0xE0, 0xA7, 0x8B },
	0x8131E132,	{ 0xE0, 0xA7, 0x8C },
	0x8131E133,	{ 0xE0, 0xA7, 0x8D },
	0x8131E134,	{ 0xE0, 0xA7, 0x8E },
	0x8131E135,	{ 0xE0, 0xA7, 0x8F },
	0x8131E136,	{ 0xE0, 0xA7, 0x90 },
	0x8131E137,	{ 0xE0, 0xA7, 0x91 },
	0x8131E138,	{ 0xE0, 0xA7, 0x92 },
	0x8131E139,	{ 0xE0, 0xA7, 0x93 },
	0x8131E230,	{ 0xE0, 0xA7, 0x94 },
	0x8131E231,	{ 0xE0, 0xA7, 0x95 },
	0x8131E232,	{ 0xE0, 0xA7, 0x96 },
	0x8131E233,	{ 0xE0, 0xA7, 0x97 },
	0x8131E234,	{ 0xE0, 0xA7, 0x98 },
	0x8131E235,	{ 0xE0, 0xA7, 0x99 },
	0x8131E236,	{ 0xE0, 0xA7, 0x9A },
	0x8131E237,	{ 0xE0, 0xA7, 0x9B },
	0x8131E238,	{ 0xE0, 0xA7, 0x9C },
	0x8131E239,	{ 0xE0, 0xA7, 0x9D },
	0x8131E330,	{ 0xE0, 0xA7, 0x9E },
	0x8131E331,	{ 0xE0, 0xA7, 0x9F },
	0x8131E332,	{ 0xE0, 0xA7, 0xA0 },
	0x8131E333,	{ 0xE0, 0xA7, 0xA1 },
	0x8131E334,	{ 0xE0, 0xA7, 0xA2 },
	0x8131E335,	{ 0xE0, 0xA7, 0xA3 },
	0x8131E336,	{ 0xE0, 0xA7, 0xA4 },
	0x8131E337,	{ 0xE0, 0xA7, 0xA5 },
	0x8131E338,	{ 0xE0, 0xA7, 0xA6 },
	0x8131E339,	{ 0xE0, 0xA7, 0xA7 },
	0x8131E430,	{ 0xE0, 0xA7, 0xA8 },
	0x8131E431,	{ 0xE0, 0xA7, 0xA9 },
	0x8131E432,	{ 0xE0, 0xA7, 0xAA },
	0x8131E433,	{ 0xE0, 0xA7, 0xAB },
	0x8131E434,	{ 0xE0, 0xA7, 0xAC },
	0x8131E435,	{ 0xE0, 0xA7, 0xAD },
	0x8131E436,	{ 0xE0, 0xA7, 0xAE },
	0x8131E437,	{ 0xE0, 0xA7, 0xAF },
	0x8131E438,	{ 0xE0, 0xA7, 0xB0 },
	0x8131E439,	{ 0xE0, 0xA7, 0xB1 },
	0x8131E530,	{ 0xE0, 0xA7, 0xB2 },
	0x8131E531,	{ 0xE0, 0xA7, 0xB3 },
	0x8131E532,	{ 0xE0, 0xA7, 0xB4 },
	0x8131E533,	{ 0xE0, 0xA7, 0xB5 },
	0x8131E534,	{ 0xE0, 0xA7, 0xB6 },
	0x8131E535,	{ 0xE0, 0xA7, 0xB7 },
	0x8131E536,	{ 0xE0, 0xA7, 0xB8 },
	0x8131E537,	{ 0xE0, 0xA7, 0xB9 },
	0x8131E538,	{ 0xE0, 0xA7, 0xBA },
	0x8131E539,	{ 0xE0, 0xA7, 0xBB },
	0x8131E630,	{ 0xE0, 0xA7, 0xBC },
	0x8131E631,	{ 0xE0, 0xA7, 0xBD },
	0x8131E632,	{ 0xE0, 0xA7, 0xBE },
	0x8131E633,	{ 0xE0, 0xA7, 0xBF },
	0x8131E634,	{ 0xE0, 0xA8, 0x80 },
	0x8131E635,	{ 0xE0, 0xA8, 0x81 },
	0x8131E636,	{ 0xE0, 0xA8, 0x82 },
	0x8131E637,	{ 0xE0, 0xA8, 0x83 },
	0x8131E638,	{ 0xE0, 0xA8, 0x84 },
	0x8131E639,	{ 0xE0, 0xA8, 0x85 },
	0x8131E730,	{ 0xE0, 0xA8, 0x86 },
	0x8131E731,	{ 0xE0, 0xA8, 0x87 },
	0x8131E732,	{ 0xE0, 0xA8, 0x88 },
	0x8131E733,	{ 0xE0, 0xA8, 0x89 },
	0x8131E734,	{ 0xE0, 0xA8, 0x8A },
	0x8131E735,	{ 0xE0, 0xA8, 0x8B },
	0x8131E736,	{ 0xE0, 0xA8, 0x8C },
	0x8131E737,	{ 0xE0, 0xA8, 0x8D },
	0x8131E738,	{ 0xE0, 0xA8, 0x8E },
	0x8131E739,	{ 0xE0, 0xA8, 0x8F },
	0x8131E830,	{ 0xE0, 0xA8, 0x90 },
	0x8131E831,	{ 0xE0, 0xA8, 0x91 },
	0x8131E832,	{ 0xE0, 0xA8, 0x92 },
	0x8131E833,	{ 0xE0, 0xA8, 0x93 },
	0x8131E834,	{ 0xE0, 0xA8, 0x94 },
	0x8131E835,	{ 0xE0, 0xA8, 0x95 },
	0x8131E836,	{ 0xE0, 0xA8, 0x96 },
	0x8131E837,	{ 0xE0, 0xA8, 0x97 },
	0x8131E838,	{ 0xE0, 0xA8, 0x98 },
	0x8131E839,	{ 0xE0, 0xA8, 0x99 },
	0x8131E930,	{ 0xE0, 0xA8, 0x9A },
	0x8131E931,	{ 0xE0, 0xA8, 0x9B },
	0x8131E932,	{ 0xE0, 0xA8, 0x9C },
	0x8131E933,	{ 0xE0, 0xA8, 0x9D },
	0x8131E934,	{ 0xE0, 0xA8, 0x9E },
	0x8131E935,	{ 0xE0, 0xA8, 0x9F },
	0x8131E936,	{ 0xE0, 0xA8, 0xA0 },
	0x8131E937,	{ 0xE0, 0xA8, 0xA1 },
	0x8131E938,	{ 0xE0, 0xA8, 0xA2 },
	0x8131E939,	{ 0xE0, 0xA8, 0xA3 },
	0x8131EA30,	{ 0xE0, 0xA8, 0xA4 },
	0x8131EA31,	{ 0xE0, 0xA8, 0xA5 },
	0x8131EA32,	{ 0xE0, 0xA8, 0xA6 },
	0x8131EA33,	{ 0xE0, 0xA8, 0xA7 },
	0x8131EA34,	{ 0xE0, 0xA8, 0xA8 },
	0x8131EA35,	{ 0xE0, 0xA8, 0xA9 },
	0x8131EA36,	{ 0xE0, 0xA8, 0xAA },
	0x8131EA37,	{ 0xE0, 0xA8, 0xAB },
	0x8131EA38,	{ 0xE0, 0xA8, 0xAC },
	0x8131EA39,	{ 0xE0, 0xA8, 0xAD },
	0x8131EB30,	{ 0xE0, 0xA8, 0xAE },
	0x8131EB31,	{ 0xE0, 0xA8, 0xAF },
	0x8131EB32,	{ 0xE0, 0xA8, 0xB0 },
	0x8131EB33,	{ 0xE0, 0xA8, 0xB1 },
	0x8131EB34,	{ 0xE0, 0xA8, 0xB2 },
	0x8131EB35,	{ 0xE0, 0xA8, 0xB3 },
	0x8131EB36,	{ 0xE0, 0xA8, 0xB4 },
	0x8131EB37,	{ 0xE0, 0xA8, 0xB5 },
	0x8131EB38,	{ 0xE0, 0xA8, 0xB6 },
	0x8131EB39,	{ 0xE0, 0xA8, 0xB7 },
	0x8131EC30,	{ 0xE0, 0xA8, 0xB8 },
	0x8131EC31,	{ 0xE0, 0xA8, 0xB9 },
	0x8131EC32,	{ 0xE0, 0xA8, 0xBA },
	0x8131EC33,	{ 0xE0, 0xA8, 0xBB },
	0x8131EC34,	{ 0xE0, 0xA8, 0xBC },
	0x8131EC35,	{ 0xE0, 0xA8, 0xBD },
	0x8131EC36,	{ 0xE0, 0xA8, 0xBE },
	0x8131EC37,	{ 0xE0, 0xA8, 0xBF },
	0x8131EC38,	{ 0xE0, 0xA9, 0x80 },
	0x8131EC39,	{ 0xE0, 0xA9, 0x81 },
	0x8131ED30,	{ 0xE0, 0xA9, 0x82 },
	0x8131ED31,	{ 0xE0, 0xA9, 0x83 },
	0x8131ED32,	{ 0xE0, 0xA9, 0x84 },
	0x8131ED33,	{ 0xE0, 0xA9, 0x85 },
	0x8131ED34,	{ 0xE0, 0xA9, 0x86 },
	0x8131ED35,	{ 0xE0, 0xA9, 0x87 },
	0x8131ED36,	{ 0xE0, 0xA9, 0x88 },
	0x8131ED37,	{ 0xE0, 0xA9, 0x89 },
	0x8131ED38,	{ 0xE0, 0xA9, 0x8A },
	0x8131ED39,	{ 0xE0, 0xA9, 0x8B },
	0x8131EE30,	{ 0xE0, 0xA9, 0x8C },
	0x8131EE31,	{ 0xE0, 0xA9, 0x8D },
	0x8131EE32,	{ 0xE0, 0xA9, 0x8E },
	0x8131EE33,	{ 0xE0, 0xA9, 0x8F },
	0x8131EE34,	{ 0xE0, 0xA9, 0x90 },
	0x8131EE35,	{ 0xE0, 0xA9, 0x91 },
	0x8131EE36,	{ 0xE0, 0xA9, 0x92 },
	0x8131EE37,	{ 0xE0, 0xA9, 0x93 },
	0x8131EE38,	{ 0xE0, 0xA9, 0x94 },
	0x8131EE39,	{ 0xE0, 0xA9, 0x95 },
	0x8131EF30,	{ 0xE0, 0xA9, 0x96 },
	0x8131EF31,	{ 0xE0, 0xA9, 0x97 },
	0x8131EF32,	{ 0xE0, 0xA9, 0x98 },
	0x8131EF33,	{ 0xE0, 0xA9, 0x99 },
	0x8131EF34,	{ 0xE0, 0xA9, 0x9A },
	0x8131EF35,	{ 0xE0, 0xA9, 0x9B },
	0x8131EF36,	{ 0xE0, 0xA9, 0x9C },
	0x8131EF37,	{ 0xE0, 0xA9, 0x9D },
	0x8131EF38,	{ 0xE0, 0xA9, 0x9E },
	0x8131EF39,	{ 0xE0, 0xA9, 0x9F },
	0x8131F030,	{ 0xE0, 0xA9, 0xA0 },
	0x8131F031,	{ 0xE0, 0xA9, 0xA1 },
	0x8131F032,	{ 0xE0, 0xA9, 0xA2 },
	0x8131F033,	{ 0xE0, 0xA9, 0xA3 },
	0x8131F034,	{ 0xE0, 0xA9, 0xA4 },
	0x8131F035,	{ 0xE0, 0xA9, 0xA5 },
	0x8131F036,	{ 0xE0, 0xA9, 0xA6 },
	0x8131F037,	{ 0xE0, 0xA9, 0xA7 },
	0x8131F038,	{ 0xE0, 0xA9, 0xA8 },
	0x8131F039,	{ 0xE0, 0xA9, 0xA9 },
	0x8131F130,	{ 0xE0, 0xA9, 0xAA },
	0x8131F131,	{ 0xE0, 0xA9, 0xAB },
	0x8131F132,	{ 0xE0, 0xA9, 0xAC },
	0x8131F133,	{ 0xE0, 0xA9, 0xAD },
	0x8131F134,	{ 0xE0, 0xA9, 0xAE },
	0x8131F135,	{ 0xE0, 0xA9, 0xAF },
	0x8131F136,	{ 0xE0, 0xA9, 0xB0 },
	0x8131F137,	{ 0xE0, 0xA9, 0xB1 },
	0x8131F138,	{ 0xE0, 0xA9, 0xB2 },
	0x8131F139,	{ 0xE0, 0xA9, 0xB3 },
	0x8131F230,	{ 0xE0, 0xA9, 0xB4 },
	0x8131F231,	{ 0xE0, 0xA9, 0xB5 },
	0x8131F232,	{ 0xE0, 0xA9, 0xB6 },
	0x8131F233,	{ 0xE0, 0xA9, 0xB7 },
	0x8131F234,	{ 0xE0, 0xA9, 0xB8 },
	0x8131F235,	{ 0xE0, 0xA9, 0xB9 },
	0x8131F236,	{ 0xE0, 0xA9, 0xBA },
	0x8131F237,	{ 0xE0, 0xA9, 0xBB },
	0x8131F238,	{ 0xE0, 0xA9, 0xBC },
	0x8131F239,	{ 0xE0, 0xA9, 0xBD },
	0x8131F330,	{ 0xE0, 0xA9, 0xBE },
	0x8131F331,	{ 0xE0, 0xA9, 0xBF },
	0x8131F332,	{ 0xE0, 0xAA, 0x80 },
	0x8131F333,	{ 0xE0, 0xAA, 0x81 },
	0x8131F334,	{ 0xE0, 0xAA, 0x82 },
	0x8131F335,	{ 0xE0, 0xAA, 0x83 },
	0x8131F336,	{ 0xE0, 0xAA, 0x84 },
	0x8131F337,	{ 0xE0, 0xAA, 0x85 },
	0x8131F338,	{ 0xE0, 0xAA, 0x86 },
	0x8131F339,	{ 0xE0, 0xAA, 0x87 },
	0x8131F430,	{ 0xE0, 0xAA, 0x88 },
	0x8131F431,	{ 0xE0, 0xAA, 0x89 },
	0x8131F432,	{ 0xE0, 0xAA, 0x8A },
	0x8131F433,	{ 0xE0, 0xAA, 0x8B },
	0x8131F434,	{ 0xE0, 0xAA, 0x8C },
	0x8131F435,	{ 0xE0, 0xAA, 0x8D },
	0x8131F436,	{ 0xE0, 0xAA, 0x8E },
	0x8131F437,	{ 0xE0, 0xAA, 0x8F },
	0x8131F438,	{ 0xE0, 0xAA, 0x90 },
	0x8131F439,	{ 0xE0, 0xAA, 0x91 },
	0x8131F530,	{ 0xE0, 0xAA, 0x92 },
	0x8131F531,	{ 0xE0, 0xAA, 0x93 },
	0x8131F532,	{ 0xE0, 0xAA, 0x94 },
	0x8131F533,	{ 0xE0, 0xAA, 0x95 },
	0x8131F534,	{ 0xE0, 0xAA, 0x96 },
	0x8131F535,	{ 0xE0, 0xAA, 0x97 },
	0x8131F536,	{ 0xE0, 0xAA, 0x98 },
	0x8131F537,	{ 0xE0, 0xAA, 0x99 },
	0x8131F538,	{ 0xE0, 0xAA, 0x9A },
	0x8131F539,	{ 0xE0, 0xAA, 0x9B },
	0x8131F630,	{ 0xE0, 0xAA, 0x9C },
	0x8131F631,	{ 0xE0, 0xAA, 0x9D },
	0x8131F632,	{ 0xE0, 0xAA, 0x9E },
	0x8131F633,	{ 0xE0, 0xAA, 0x9F },
	0x8131F634,	{ 0xE0, 0xAA, 0xA0 },
	0x8131F635,	{ 0xE0, 0xAA, 0xA1 },
	0x8131F636,	{ 0xE0, 0xAA, 0xA2 },
	0x8131F637,	{ 0xE0, 0xAA, 0xA3 },
	0x8131F638,	{ 0xE0, 0xAA, 0xA4 },
	0x8131F639,	{ 0xE0, 0xAA, 0xA5 },
	0x8131F730,	{ 0xE0, 0xAA, 0xA6 },
	0x8131F731,	{ 0xE0, 0xAA, 0xA7 },
	0x8131F732,	{ 0xE0, 0xAA, 0xA8 },
	0x8131F733,	{ 0xE0, 0xAA, 0xA9 },
	0x8131F734,	{ 0xE0, 0xAA, 0xAA },
	0x8131F735,	{ 0xE0, 0xAA, 0xAB },
	0x8131F736,	{ 0xE0, 0xAA, 0xAC },
	0x8131F737,	{ 0xE0, 0xAA, 0xAD },
	0x8131F738,	{ 0xE0, 0xAA, 0xAE },
	0x8131F739,	{ 0xE0, 0xAA, 0xAF },
	0x8131F830,	{ 0xE0, 0xAA, 0xB0 },
	0x8131F831,	{ 0xE0, 0xAA, 0xB1 },
	0x8131F832,	{ 0xE0, 0xAA, 0xB2 },
	0x8131F833,	{ 0xE0, 0xAA, 0xB3 },
	0x8131F834,	{ 0xE0, 0xAA, 0xB4 },
	0x8131F835,	{ 0xE0, 0xAA, 0xB5 },
	0x8131F836,	{ 0xE0, 0xAA, 0xB6 },
	0x8131F837,	{ 0xE0, 0xAA, 0xB7 },
	0x8131F838,	{ 0xE0, 0xAA, 0xB8 },
	0x8131F839,	{ 0xE0, 0xAA, 0xB9 },
	0x8131F930,	{ 0xE0, 0xAA, 0xBA },
	0x8131F931,	{ 0xE0, 0xAA, 0xBB },
	0x8131F932,	{ 0xE0, 0xAA, 0xBC },
	0x8131F933,	{ 0xE0, 0xAA, 0xBD },
	0x8131F934,	{ 0xE0, 0xAA, 0xBE },
	0x8131F935,	{ 0xE0, 0xAA, 0xBF },
	0x8131F936,	{ 0xE0, 0xAB, 0x80 },
	0x8131F937,	{ 0xE0, 0xAB, 0x81 },
	0x8131F938,	{ 0xE0, 0xAB, 0x82 },
	0x8131F939,	{ 0xE0, 0xAB, 0x83 },
	0x8131FA30,	{ 0xE0, 0xAB, 0x84 },
	0x8131FA31,	{ 0xE0, 0xAB, 0x85 },
	0x8131FA32,	{ 0xE0, 0xAB, 0x86 },
	0x8131FA33,	{ 0xE0, 0xAB, 0x87 },
	0x8131FA34,	{ 0xE0, 0xAB, 0x88 },
	0x8131FA35,	{ 0xE0, 0xAB, 0x89 },
	0x8131FA36,	{ 0xE0, 0xAB, 0x8A },
	0x8131FA37,	{ 0xE0, 0xAB, 0x8B },
	0x8131FA38,	{ 0xE0, 0xAB, 0x8C },
	0x8131FA39,	{ 0xE0, 0xAB, 0x8D },
	0x8131FB30,	{ 0xE0, 0xAB, 0x8E },
	0x8131FB31,	{ 0xE0, 0xAB, 0x8F },
	0x8131FB32,	{ 0xE0, 0xAB, 0x90 },
	0x8131FB33,	{ 0xE0, 0xAB, 0x91 },
	0x8131FB34,	{ 0xE0, 0xAB, 0x92 },
	0x8131FB35,	{ 0xE0, 0xAB, 0x93 },
	0x8131FB36,	{ 0xE0, 0xAB, 0x94 },
	0x8131FB37,	{ 0xE0, 0xAB, 0x95 },
	0x8131FB38,	{ 0xE0, 0xAB, 0x96 },
	0x8131FB39,	{ 0xE0, 0xAB, 0x97 },
	0x8131FC30,	{ 0xE0, 0xAB, 0x98 },
	0x8131FC31,	{ 0xE0, 0xAB, 0x99 },
	0x8131FC32,	{ 0xE0, 0xAB, 0x9A },
	0x8131FC33,	{ 0xE0, 0xAB, 0x9B },
	0x8131FC34,	{ 0xE0, 0xAB, 0x9C },
	0x8131FC35,	{ 0xE0, 0xAB, 0x9D },
	0x8131FC36,	{ 0xE0, 0xAB, 0x9E },
	0x8131FC37,	{ 0xE0, 0xAB, 0x9F },
	0x8131FC38,	{ 0xE0, 0xAB, 0xA0 },
	0x8131FC39,	{ 0xE0, 0xAB, 0xA1 },
	0x8131FD30,	{ 0xE0, 0xAB, 0xA2 },
	0x8131FD31,	{ 0xE0, 0xAB, 0xA3 },
	0x8131FD32,	{ 0xE0, 0xAB, 0xA4 },
	0x8131FD33,	{ 0xE0, 0xAB, 0xA5 },
	0x8131FD34,	{ 0xE0, 0xAB, 0xA6 },
	0x8131FD35,	{ 0xE0, 0xAB, 0xA7 },
	0x8131FD36,	{ 0xE0, 0xAB, 0xA8 },
	0x8131FD37,	{ 0xE0, 0xAB, 0xA9 },
	0x8131FD38,	{ 0xE0, 0xAB, 0xAA },
	0x8131FD39,	{ 0xE0, 0xAB, 0xAB },
	0x8131FE30,	{ 0xE0, 0xAB, 0xAC },
	0x8131FE31,	{ 0xE0, 0xAB, 0xAD },
	0x8131FE32,	{ 0xE0, 0xAB, 0xAE },
	0x8131FE33,	{ 0xE0, 0xAB, 0xAF },
	0x8131FE34,	{ 0xE0, 0xAB, 0xB0 },
	0x8131FE35,	{ 0xE0, 0xAB, 0xB1 },
	0x8131FE36,	{ 0xE0, 0xAB, 0xB2 },
	0x8131FE37,	{ 0xE0, 0xAB, 0xB3 },
	0x8131FE38,	{ 0xE0, 0xAB, 0xB4 },
	0x8131FE39,	{ 0xE0, 0xAB, 0xB5 },
	0x81328130,	{ 0xE0, 0xAB, 0xB6 },
	0x81328131,	{ 0xE0, 0xAB, 0xB7 },
	0x81328132,	{ 0xE0, 0xAB, 0xB8 },
	0x81328133,	{ 0xE0, 0xAB, 0xB9 },
	0x81328134,	{ 0xE0, 0xAB, 0xBA },
	0x81328135,	{ 0xE0, 0xAB, 0xBB },
	0x81328136,	{ 0xE0, 0xAB, 0xBC },
	0x81328137,	{ 0xE0, 0xAB, 0xBD },
	0x81328138,	{ 0xE0, 0xAB, 0xBE },
	0x81328139,	{ 0xE0, 0xAB, 0xBF },
	0x81328230,	{ 0xE0, 0xAC, 0x80 },
	0x81328231,	{ 0xE0, 0xAC, 0x81 },
	0x81328232,	{ 0xE0, 0xAC, 0x82 },
	0x81328233,	{ 0xE0, 0xAC, 0x83 },
	0x81328234,	{ 0xE0, 0xAC, 0x84 },
	0x81328235,	{ 0xE0, 0xAC, 0x85 },
	0x81328236,	{ 0xE0, 0xAC, 0x86 },
	0x81328237,	{ 0xE0, 0xAC, 0x87 },
	0x81328238,	{ 0xE0, 0xAC, 0x88 },
	0x81328239,	{ 0xE0, 0xAC, 0x89 },
	0x81328330,	{ 0xE0, 0xAC, 0x8A },
	0x81328331,	{ 0xE0, 0xAC, 0x8B },
	0x81328332,	{ 0xE0, 0xAC, 0x8C },
	0x81328333,	{ 0xE0, 0xAC, 0x8D },
	0x81328334,	{ 0xE0, 0xAC, 0x8E },
	0x81328335,	{ 0xE0, 0xAC, 0x8F },
	0x81328336,	{ 0xE0, 0xAC, 0x90 },
	0x81328337,	{ 0xE0, 0xAC, 0x91 },
	0x81328338,	{ 0xE0, 0xAC, 0x92 },
	0x81328339,	{ 0xE0, 0xAC, 0x93 },
	0x81328430,	{ 0xE0, 0xAC, 0x94 },
	0x81328431,	{ 0xE0, 0xAC, 0x95 },
	0x81328432,	{ 0xE0, 0xAC, 0x96 },
	0x81328433,	{ 0xE0, 0xAC, 0x97 },
	0x81328434,	{ 0xE0, 0xAC, 0x98 },
	0x81328435,	{ 0xE0, 0xAC, 0x99 },
	0x81328436,	{ 0xE0, 0xAC, 0x9A },
	0x81328437,	{ 0xE0, 0xAC, 0x9B },
	0x81328438,	{ 0xE0, 0xAC, 0x9C },
	0x81328439,	{ 0xE0, 0xAC, 0x9D },
	0x81328530,	{ 0xE0, 0xAC, 0x9E },
	0x81328531,	{ 0xE0, 0xAC, 0x9F },
	0x81328532,	{ 0xE0, 0xAC, 0xA0 },
	0x81328533,	{ 0xE0, 0xAC, 0xA1 },
	0x81328534,	{ 0xE0, 0xAC, 0xA2 },
	0x81328535,	{ 0xE0, 0xAC, 0xA3 },
	0x81328536,	{ 0xE0, 0xAC, 0xA4 },
	0x81328537,	{ 0xE0, 0xAC, 0xA5 },
	0x81328538,	{ 0xE0, 0xAC, 0xA6 },
	0x81328539,	{ 0xE0, 0xAC, 0xA7 },
	0x81328630,	{ 0xE0, 0xAC, 0xA8 },
	0x81328631,	{ 0xE0, 0xAC, 0xA9 },
	0x81328632,	{ 0xE0, 0xAC, 0xAA },
	0x81328633,	{ 0xE0, 0xAC, 0xAB },
	0x81328634,	{ 0xE0, 0xAC, 0xAC },
	0x81328635,	{ 0xE0, 0xAC, 0xAD },
	0x81328636,	{ 0xE0, 0xAC, 0xAE },
	0x81328637,	{ 0xE0, 0xAC, 0xAF },
	0x81328638,	{ 0xE0, 0xAC, 0xB0 },
	0x81328639,	{ 0xE0, 0xAC, 0xB1 },
	0x81328730,	{ 0xE0, 0xAC, 0xB2 },
	0x81328731,	{ 0xE0, 0xAC, 0xB3 },
	0x81328732,	{ 0xE0, 0xAC, 0xB4 },
	0x81328733,	{ 0xE0, 0xAC, 0xB5 },
	0x81328734,	{ 0xE0, 0xAC, 0xB6 },
	0x81328735,	{ 0xE0, 0xAC, 0xB7 },
	0x81328736,	{ 0xE0, 0xAC, 0xB8 },
	0x81328737,	{ 0xE0, 0xAC, 0xB9 },
	0x81328738,	{ 0xE0, 0xAC, 0xBA },
	0x81328739,	{ 0xE0, 0xAC, 0xBB },
	0x81328830,	{ 0xE0, 0xAC, 0xBC },
	0x81328831,	{ 0xE0, 0xAC, 0xBD },
	0x81328832,	{ 0xE0, 0xAC, 0xBE },
	0x81328833,	{ 0xE0, 0xAC, 0xBF },
	0x81328834,	{ 0xE0, 0xAD, 0x80 },
	0x81328835,	{ 0xE0, 0xAD, 0x81 },
	0x81328836,	{ 0xE0, 0xAD, 0x82 },
	0x81328837,	{ 0xE0, 0xAD, 0x83 },
	0x81328838,	{ 0xE0, 0xAD, 0x84 },
	0x81328839,	{ 0xE0, 0xAD, 0x85 },
	0x81328930,	{ 0xE0, 0xAD, 0x86 },
	0x81328931,	{ 0xE0, 0xAD, 0x87 },
	0x81328932,	{ 0xE0, 0xAD, 0x88 },
	0x81328933,	{ 0xE0, 0xAD, 0x89 },
	0x81328934,	{ 0xE0, 0xAD, 0x8A },
	0x81328935,	{ 0xE0, 0xAD, 0x8B },
	0x81328936,	{ 0xE0, 0xAD, 0x8C },
	0x81328937,	{ 0xE0, 0xAD, 0x8D },
	0x81328938,	{ 0xE0, 0xAD, 0x8E },
	0x81328939,	{ 0xE0, 0xAD, 0x8F },
	0x81328A30,	{ 0xE0, 0xAD, 0x90 },
	0x81328A31,	{ 0xE0, 0xAD, 0x91 },
	0x81328A32,	{ 0xE0, 0xAD, 0x92 },
	0x81328A33,	{ 0xE0, 0xAD, 0x93 },
	0x81328A34,	{ 0xE0, 0xAD, 0x94 },
	0x81328A35,	{ 0xE0, 0xAD, 0x95 },
	0x81328A36,	{ 0xE0, 0xAD, 0x96 },
	0x81328A37,	{ 0xE0, 0xAD, 0x97 },
	0x81328A38,	{ 0xE0, 0xAD, 0x98 },
	0x81328A39,	{ 0xE0, 0xAD, 0x99 },
	0x81328B30,	{ 0xE0, 0xAD, 0x9A },
	0x81328B31,	{ 0xE0, 0xAD, 0x9B },
	0x81328B32,	{ 0xE0, 0xAD, 0x9C },
	0x81328B33,	{ 0xE0, 0xAD, 0x9D },
	0x81328B34,	{ 0xE0, 0xAD, 0x9E },
	0x81328B35,	{ 0xE0, 0xAD, 0x9F },
	0x81328B36,	{ 0xE0, 0xAD, 0xA0 },
	0x81328B37,	{ 0xE0, 0xAD, 0xA1 },
	0x81328B38,	{ 0xE0, 0xAD, 0xA2 },
	0x81328B39,	{ 0xE0, 0xAD, 0xA3 },
	0x81328C30,	{ 0xE0, 0xAD, 0xA4 },
	0x81328C31,	{ 0xE0, 0xAD, 0xA5 },
	0x81328C32,	{ 0xE0, 0xAD, 0xA6 },
	0x81328C33,	{ 0xE0, 0xAD, 0xA7 },
	0x81328C34,	{ 0xE0, 0xAD, 0xA8 },
	0x81328C35,	{ 0xE0, 0xAD, 0xA9 },
	0x81328C36,	{ 0xE0, 0xAD, 0xAA },
	0x81328C37,	{ 0xE0, 0xAD, 0xAB },
	0x81328C38,	{ 0xE0, 0xAD, 0xAC },
	0x81328C39,	{ 0xE0, 0xAD, 0xAD },
	0x81328D30,	{ 0xE0, 0xAD, 0xAE },
	0x81328D31,	{ 0xE0, 0xAD, 0xAF },
	0x81328D32,	{ 0xE0, 0xAD, 0xB0 },
	0x81328D33,	{ 0xE0, 0xAD, 0xB1 },
	0x81328D34,	{ 0xE0, 0xAD, 0xB2 },
	0x81328D35,	{ 0xE0, 0xAD, 0xB3 },
	0x81328D36,	{ 0xE0, 0xAD, 0xB4 },
	0x81328D37,	{ 0xE0, 0xAD, 0xB5 },
	0x81328D38,	{ 0xE0, 0xAD, 0xB6 },
	0x81328D39,	{ 0xE0, 0xAD, 0xB7 },
	0x81328E30,	{ 0xE0, 0xAD, 0xB8 },
	0x81328E31,	{ 0xE0, 0xAD, 0xB9 },
	0x81328E32,	{ 0xE0, 0xAD, 0xBA },
	0x81328E33,	{ 0xE0, 0xAD, 0xBB },
	0x81328E34,	{ 0xE0, 0xAD, 0xBC },
	0x81328E35,	{ 0xE0, 0xAD, 0xBD },
	0x81328E36,	{ 0xE0, 0xAD, 0xBE },
	0x81328E37,	{ 0xE0, 0xAD, 0xBF },
	0x81328E38,	{ 0xE0, 0xAE, 0x80 },
	0x81328E39,	{ 0xE0, 0xAE, 0x81 },
	0x81328F30,	{ 0xE0, 0xAE, 0x82 },
	0x81328F31,	{ 0xE0, 0xAE, 0x83 },
	0x81328F32,	{ 0xE0, 0xAE, 0x84 },
	0x81328F33,	{ 0xE0, 0xAE, 0x85 },
	0x81328F34,	{ 0xE0, 0xAE, 0x86 },
	0x81328F35,	{ 0xE0, 0xAE, 0x87 },
	0x81328F36,	{ 0xE0, 0xAE, 0x88 },
	0x81328F37,	{ 0xE0, 0xAE, 0x89 },
	0x81328F38,	{ 0xE0, 0xAE, 0x8A },
	0x81328F39,	{ 0xE0, 0xAE, 0x8B },
	0x81329030,	{ 0xE0, 0xAE, 0x8C },
	0x81329031,	{ 0xE0, 0xAE, 0x8D },
	0x81329032,	{ 0xE0, 0xAE, 0x8E },
	0x81329033,	{ 0xE0, 0xAE, 0x8F },
	0x81329034,	{ 0xE0, 0xAE, 0x90 },
	0x81329035,	{ 0xE0, 0xAE, 0x91 },
	0x81329036,	{ 0xE0, 0xAE, 0x92 },
	0x81329037,	{ 0xE0, 0xAE, 0x93 },
	0x81329038,	{ 0xE0, 0xAE, 0x94 },
	0x81329039,	{ 0xE0, 0xAE, 0x95 },
	0x81329130,	{ 0xE0, 0xAE, 0x96 },
	0x81329131,	{ 0xE0, 0xAE, 0x97 },
	0x81329132,	{ 0xE0, 0xAE, 0x98 },
	0x81329133,	{ 0xE0, 0xAE, 0x99 },
	0x81329134,	{ 0xE0, 0xAE, 0x9A },
	0x81329135,	{ 0xE0, 0xAE, 0x9B },
	0x81329136,	{ 0xE0, 0xAE, 0x9C },
	0x81329137,	{ 0xE0, 0xAE, 0x9D },
	0x81329138,	{ 0xE0, 0xAE, 0x9E },
	0x81329139,	{ 0xE0, 0xAE, 0x9F },
	0x81329230,	{ 0xE0, 0xAE, 0xA0 },
	0x81329231,	{ 0xE0, 0xAE, 0xA1 },
	0x81329232,	{ 0xE0, 0xAE, 0xA2 },
	0x81329233,	{ 0xE0, 0xAE, 0xA3 },
	0x81329234,	{ 0xE0, 0xAE, 0xA4 },
	0x81329235,	{ 0xE0, 0xAE, 0xA5 },
	0x81329236,	{ 0xE0, 0xAE, 0xA6 },
	0x81329237,	{ 0xE0, 0xAE, 0xA7 },
	0x81329238,	{ 0xE0, 0xAE, 0xA8 },
	0x81329239,	{ 0xE0, 0xAE, 0xA9 },
	0x81329330,	{ 0xE0, 0xAE, 0xAA },
	0x81329331,	{ 0xE0, 0xAE, 0xAB },
	0x81329332,	{ 0xE0, 0xAE, 0xAC },
	0x81329333,	{ 0xE0, 0xAE, 0xAD },
	0x81329334,	{ 0xE0, 0xAE, 0xAE },
	0x81329335,	{ 0xE0, 0xAE, 0xAF },
	0x81329336,	{ 0xE0, 0xAE, 0xB0 },
	0x81329337,	{ 0xE0, 0xAE, 0xB1 },
	0x81329338,	{ 0xE0, 0xAE, 0xB2 },
	0x81329339,	{ 0xE0, 0xAE, 0xB3 },
	0x81329430,	{ 0xE0, 0xAE, 0xB4 },
	0x81329431,	{ 0xE0, 0xAE, 0xB5 },
	0x81329432,	{ 0xE0, 0xAE, 0xB6 },
	0x81329433,	{ 0xE0, 0xAE, 0xB7 },
	0x81329434,	{ 0xE0, 0xAE, 0xB8 },
	0x81329435,	{ 0xE0, 0xAE, 0xB9 },
	0x81329436,	{ 0xE0, 0xAE, 0xBA },
	0x81329437,	{ 0xE0, 0xAE, 0xBB },
	0x81329438,	{ 0xE0, 0xAE, 0xBC },
	0x81329439,	{ 0xE0, 0xAE, 0xBD },
	0x81329530,	{ 0xE0, 0xAE, 0xBE },
	0x81329531,	{ 0xE0, 0xAE, 0xBF },
	0x81329532,	{ 0xE0, 0xAF, 0x80 },
	0x81329533,	{ 0xE0, 0xAF, 0x81 },
	0x81329534,	{ 0xE0, 0xAF, 0x82 },
	0x81329535,	{ 0xE0, 0xAF, 0x83 },
	0x81329536,	{ 0xE0, 0xAF, 0x84 },
	0x81329537,	{ 0xE0, 0xAF, 0x85 },
	0x81329538,	{ 0xE0, 0xAF, 0x86 },
	0x81329539,	{ 0xE0, 0xAF, 0x87 },
	0x81329630,	{ 0xE0, 0xAF, 0x88 },
	0x81329631,	{ 0xE0, 0xAF, 0x89 },
	0x81329632,	{ 0xE0, 0xAF, 0x8A },
	0x81329633,	{ 0xE0, 0xAF, 0x8B },
	0x81329634,	{ 0xE0, 0xAF, 0x8C },
	0x81329635,	{ 0xE0, 0xAF, 0x8D },
	0x81329636,	{ 0xE0, 0xAF, 0x8E },
	0x81329637,	{ 0xE0, 0xAF, 0x8F },
	0x81329638,	{ 0xE0, 0xAF, 0x90 },
	0x81329639,	{ 0xE0, 0xAF, 0x91 },
	0x81329730,	{ 0xE0, 0xAF, 0x92 },
	0x81329731,	{ 0xE0, 0xAF, 0x93 },
	0x81329732,	{ 0xE0, 0xAF, 0x94 },
	0x81329733,	{ 0xE0, 0xAF, 0x95 },
	0x81329734,	{ 0xE0, 0xAF, 0x96 },
	0x81329735,	{ 0xE0, 0xAF, 0x97 },
	0x81329736,	{ 0xE0, 0xAF, 0x98 },
	0x81329737,	{ 0xE0, 0xAF, 0x99 },
	0x81329738,	{ 0xE0, 0xAF, 0x9A },
	0x81329739,	{ 0xE0, 0xAF, 0x9B },
	0x81329830,	{ 0xE0, 0xAF, 0x9C },
	0x81329831,	{ 0xE0, 0xAF, 0x9D },
	0x81329832,	{ 0xE0, 0xAF, 0x9E },
	0x81329833,	{ 0xE0, 0xAF, 0x9F },
	0x81329834,	{ 0xE0, 0xAF, 0xA0 },
	0x81329835,	{ 0xE0, 0xAF, 0xA1 },
	0x81329836,	{ 0xE0, 0xAF, 0xA2 },
	0x81329837,	{ 0xE0, 0xAF, 0xA3 },
	0x81329838,	{ 0xE0, 0xAF, 0xA4 },
	0x81329839,	{ 0xE0, 0xAF, 0xA5 },
	0x81329930,	{ 0xE0, 0xAF, 0xA6 },
	0x81329931,	{ 0xE0, 0xAF, 0xA7 },
	0x81329932,	{ 0xE0, 0xAF, 0xA8 },
	0x81329933,	{ 0xE0, 0xAF, 0xA9 },
	0x81329934,	{ 0xE0, 0xAF, 0xAA },
	0x81329935,	{ 0xE0, 0xAF, 0xAB },
	0x81329936,	{ 0xE0, 0xAF, 0xAC },
	0x81329937,	{ 0xE0, 0xAF, 0xAD },
	0x81329938,	{ 0xE0, 0xAF, 0xAE },
	0x81329939,	{ 0xE0, 0xAF, 0xAF },
	0x81329A30,	{ 0xE0, 0xAF, 0xB0 },
	0x81329A31,	{ 0xE0, 0xAF, 0xB1 },
	0x81329A32,	{ 0xE0, 0xAF, 0xB2 },
	0x81329A33,	{ 0xE0, 0xAF, 0xB3 },
	0x81329A34,	{ 0xE0, 0xAF, 0xB4 },
	0x81329A35,	{ 0xE0, 0xAF, 0xB5 },
	0x81329A36,	{ 0xE0, 0xAF, 0xB6 },
	0x81329A37,	{ 0xE0, 0xAF, 0xB7 },
	0x81329A38,	{ 0xE0, 0xAF, 0xB8 },
	0x81329A39,	{ 0xE0, 0xAF, 0xB9 },
	0x81329B30,	{ 0xE0, 0xAF, 0xBA },
	0x81329B31,	{ 0xE0, 0xAF, 0xBB },
	0x81329B32,	{ 0xE0, 0xAF, 0xBC },
	0x81329B33,	{ 0xE0, 0xAF, 0xBD },
	0x81329B34,	{ 0xE0, 0xAF, 0xBE },
	0x81329B35,	{ 0xE0, 0xAF, 0xBF },
	0x81329B36,	{ 0xE0, 0xB0, 0x80 },
	0x81329B37,	{ 0xE0, 0xB0, 0x81 },
	0x81329B38,	{ 0xE0, 0xB0, 0x82 },
	0x81329B39,	{ 0xE0, 0xB0, 0x83 },
	0x81329C30,	{ 0xE0, 0xB0, 0x84 },
	0x81329C31,	{ 0xE0, 0xB0, 0x85 },
	0x81329C32,	{ 0xE0, 0xB0, 0x86 },
	0x81329C33,	{ 0xE0, 0xB0, 0x87 },
	0x81329C34,	{ 0xE0, 0xB0, 0x88 },
	0x81329C35,	{ 0xE0, 0xB0, 0x89 },
	0x81329C36,	{ 0xE0, 0xB0, 0x8A },
	0x81329C37,	{ 0xE0, 0xB0, 0x8B },
	0x81329C38,	{ 0xE0, 0xB0, 0x8C },
	0x81329C39,	{ 0xE0, 0xB0, 0x8D },
	0x81329D30,	{ 0xE0, 0xB0, 0x8E },
	0x81329D31,	{ 0xE0, 0xB0, 0x8F },
	0x81329D32,	{ 0xE0, 0xB0, 0x90 },
	0x81329D33,	{ 0xE0, 0xB0, 0x91 },
	0x81329D34,	{ 0xE0, 0xB0, 0x92 },
	0x81329D35,	{ 0xE0, 0xB0, 0x93 },
	0x81329D36,	{ 0xE0, 0xB0, 0x94 },
	0x81329D37,	{ 0xE0, 0xB0, 0x95 },
	0x81329D38,	{ 0xE0, 0xB0, 0x96 },
	0x81329D39,	{ 0xE0, 0xB0, 0x97 },
	0x81329E30,	{ 0xE0, 0xB0, 0x98 },
	0x81329E31,	{ 0xE0, 0xB0, 0x99 },
	0x81329E32,	{ 0xE0, 0xB0, 0x9A },
	0x81329E33,	{ 0xE0, 0xB0, 0x9B },
	0x81329E34,	{ 0xE0, 0xB0, 0x9C },
	0x81329E35,	{ 0xE0, 0xB0, 0x9D },
	0x81329E36,	{ 0xE0, 0xB0, 0x9E },
	0x81329E37,	{ 0xE0, 0xB0, 0x9F },
	0x81329E38,	{ 0xE0, 0xB0, 0xA0 },
	0x81329E39,	{ 0xE0, 0xB0, 0xA1 },
	0x81329F30,	{ 0xE0, 0xB0, 0xA2 },
	0x81329F31,	{ 0xE0, 0xB0, 0xA3 },
	0x81329F32,	{ 0xE0, 0xB0, 0xA4 },
	0x81329F33,	{ 0xE0, 0xB0, 0xA5 },
	0x81329F34,	{ 0xE0, 0xB0, 0xA6 },
	0x81329F35,	{ 0xE0, 0xB0, 0xA7 },
	0x81329F36,	{ 0xE0, 0xB0, 0xA8 },
	0x81329F37,	{ 0xE0, 0xB0, 0xA9 },
	0x81329F38,	{ 0xE0, 0xB0, 0xAA },
	0x81329F39,	{ 0xE0, 0xB0, 0xAB },
	0x8132A030,	{ 0xE0, 0xB0, 0xAC },
	0x8132A031,	{ 0xE0, 0xB0, 0xAD },
	0x8132A032,	{ 0xE0, 0xB0, 0xAE },
	0x8132A033,	{ 0xE0, 0xB0, 0xAF },
	0x8132A034,	{ 0xE0, 0xB0, 0xB0 },
	0x8132A035,	{ 0xE0, 0xB0, 0xB1 },
	0x8132A036,	{ 0xE0, 0xB0, 0xB2 },
	0x8132A037,	{ 0xE0, 0xB0, 0xB3 },
	0x8132A038,	{ 0xE0, 0xB0, 0xB4 },
	0x8132A039,	{ 0xE0, 0xB0, 0xB5 },
	0x8132A130,	{ 0xE0, 0xB0, 0xB6 },
	0x8132A131,	{ 0xE0, 0xB0, 0xB7 },
	0x8132A132,	{ 0xE0, 0xB0, 0xB8 },
	0x8132A133,	{ 0xE0, 0xB0, 0xB9 },
	0x8132A134,	{ 0xE0, 0xB0, 0xBA },
	0x8132A135,	{ 0xE0, 0xB0, 0xBB },
	0x8132A136,	{ 0xE0, 0xB0, 0xBC },
	0x8132A137,	{ 0xE0, 0xB0, 0xBD },
	0x8132A138,	{ 0xE0, 0xB0, 0xBE },
	0x8132A139,	{ 0xE0, 0xB0, 0xBF },
	0x8132A230,	{ 0xE0, 0xB1, 0x80 },
	0x8132A231,	{ 0xE0, 0xB1, 0x81 },
	0x8132A232,	{ 0xE0, 0xB1, 0x82 },
	0x8132A233,	{ 0xE0, 0xB1, 0x83 },
	0x8132A234,	{ 0xE0, 0xB1, 0x84 },
	0x8132A235,	{ 0xE0, 0xB1, 0x85 },
	0x8132A236,	{ 0xE0, 0xB1, 0x86 },
	0x8132A237,	{ 0xE0, 0xB1, 0x87 },
	0x8132A238,	{ 0xE0, 0xB1, 0x88 },
	0x8132A239,	{ 0xE0, 0xB1, 0x89 },
	0x8132A330,	{ 0xE0, 0xB1, 0x8A },
	0x8132A331,	{ 0xE0, 0xB1, 0x8B },
	0x8132A332,	{ 0xE0, 0xB1, 0x8C },
	0x8132A333,	{ 0xE0, 0xB1, 0x8D },
	0x8132A334,	{ 0xE0, 0xB1, 0x8E },
	0x8132A335,	{ 0xE0, 0xB1, 0x8F },
	0x8132A336,	{ 0xE0, 0xB1, 0x90 },
	0x8132A337,	{ 0xE0, 0xB1, 0x91 },
	0x8132A338,	{ 0xE0, 0xB1, 0x92 },
	0x8132A339,	{ 0xE0, 0xB1, 0x93 },
	0x8132A430,	{ 0xE0, 0xB1, 0x94 },
	0x8132A431,	{ 0xE0, 0xB1, 0x95 },
	0x8132A432,	{ 0xE0, 0xB1, 0x96 },
	0x8132A433,	{ 0xE0, 0xB1, 0x97 },
	0x8132A434,	{ 0xE0, 0xB1, 0x98 },
	0x8132A435,	{ 0xE0, 0xB1, 0x99 },
	0x8132A436,	{ 0xE0, 0xB1, 0x9A },
	0x8132A437,	{ 0xE0, 0xB1, 0x9B },
	0x8132A438,	{ 0xE0, 0xB1, 0x9C },
	0x8132A439,	{ 0xE0, 0xB1, 0x9D },
	0x8132A530,	{ 0xE0, 0xB1, 0x9E },
	0x8132A531,	{ 0xE0, 0xB1, 0x9F },
	0x8132A532,	{ 0xE0, 0xB1, 0xA0 },
	0x8132A533,	{ 0xE0, 0xB1, 0xA1 },
	0x8132A534,	{ 0xE0, 0xB1, 0xA2 },
	0x8132A535,	{ 0xE0, 0xB1, 0xA3 },
	0x8132A536,	{ 0xE0, 0xB1, 0xA4 },
	0x8132A537,	{ 0xE0, 0xB1, 0xA5 },
	0x8132A538,	{ 0xE0, 0xB1, 0xA6 },
	0x8132A539,	{ 0xE0, 0xB1, 0xA7 },
	0x8132A630,	{ 0xE0, 0xB1, 0xA8 },
	0x8132A631,	{ 0xE0, 0xB1, 0xA9 },
	0x8132A632,	{ 0xE0, 0xB1, 0xAA },
	0x8132A633,	{ 0xE0, 0xB1, 0xAB },
	0x8132A634,	{ 0xE0, 0xB1, 0xAC },
	0x8132A635,	{ 0xE0, 0xB1, 0xAD },
	0x8132A636,	{ 0xE0, 0xB1, 0xAE },
	0x8132A637,	{ 0xE0, 0xB1, 0xAF },
	0x8132A638,	{ 0xE0, 0xB1, 0xB0 },
	0x8132A639,	{ 0xE0, 0xB1, 0xB1 },
	0x8132A730,	{ 0xE0, 0xB1, 0xB2 },
	0x8132A731,	{ 0xE0, 0xB1, 0xB3 },
	0x8132A732,	{ 0xE0, 0xB1, 0xB4 },
	0x8132A733,	{ 0xE0, 0xB1, 0xB5 },
	0x8132A734,	{ 0xE0, 0xB1, 0xB6 },
	0x8132A735,	{ 0xE0, 0xB1, 0xB7 },
	0x8132A736,	{ 0xE0, 0xB1, 0xB8 },
	0x8132A737,	{ 0xE0, 0xB1, 0xB9 },
	0x8132A738,	{ 0xE0, 0xB1, 0xBA },
	0x8132A739,	{ 0xE0, 0xB1, 0xBB },
	0x8132A830,	{ 0xE0, 0xB1, 0xBC },
	0x8132A831,	{ 0xE0, 0xB1, 0xBD },
	0x8132A832,	{ 0xE0, 0xB1, 0xBE },
	0x8132A833,	{ 0xE0, 0xB1, 0xBF },
	0x8132A834,	{ 0xE0, 0xB2, 0x80 },
	0x8132A835,	{ 0xE0, 0xB2, 0x81 },
	0x8132A836,	{ 0xE0, 0xB2, 0x82 },
	0x8132A837,	{ 0xE0, 0xB2, 0x83 },
	0x8132A838,	{ 0xE0, 0xB2, 0x84 },
	0x8132A839,	{ 0xE0, 0xB2, 0x85 },
	0x8132A930,	{ 0xE0, 0xB2, 0x86 },
	0x8132A931,	{ 0xE0, 0xB2, 0x87 },
	0x8132A932,	{ 0xE0, 0xB2, 0x88 },
	0x8132A933,	{ 0xE0, 0xB2, 0x89 },
	0x8132A934,	{ 0xE0, 0xB2, 0x8A },
	0x8132A935,	{ 0xE0, 0xB2, 0x8B },
	0x8132A936,	{ 0xE0, 0xB2, 0x8C },
	0x8132A937,	{ 0xE0, 0xB2, 0x8D },
	0x8132A938,	{ 0xE0, 0xB2, 0x8E },
	0x8132A939,	{ 0xE0, 0xB2, 0x8F },
	0x8132AA30,	{ 0xE0, 0xB2, 0x90 },
	0x8132AA31,	{ 0xE0, 0xB2, 0x91 },
	0x8132AA32,	{ 0xE0, 0xB2, 0x92 },
	0x8132AA33,	{ 0xE0, 0xB2, 0x93 },
	0x8132AA34,	{ 0xE0, 0xB2, 0x94 },
	0x8132AA35,	{ 0xE0, 0xB2, 0x95 },
	0x8132AA36,	{ 0xE0, 0xB2, 0x96 },
	0x8132AA37,	{ 0xE0, 0xB2, 0x97 },
	0x8132AA38,	{ 0xE0, 0xB2, 0x98 },
	0x8132AA39,	{ 0xE0, 0xB2, 0x99 },
	0x8132AB30,	{ 0xE0, 0xB2, 0x9A },
	0x8132AB31,	{ 0xE0, 0xB2, 0x9B },
	0x8132AB32,	{ 0xE0, 0xB2, 0x9C },
	0x8132AB33,	{ 0xE0, 0xB2, 0x9D },
	0x8132AB34,	{ 0xE0, 0xB2, 0x9E },
	0x8132AB35,	{ 0xE0, 0xB2, 0x9F },
	0x8132AB36,	{ 0xE0, 0xB2, 0xA0 },
	0x8132AB37,	{ 0xE0, 0xB2, 0xA1 },
	0x8132AB38,	{ 0xE0, 0xB2, 0xA2 },
	0x8132AB39,	{ 0xE0, 0xB2, 0xA3 },
	0x8132AC30,	{ 0xE0, 0xB2, 0xA4 },
	0x8132AC31,	{ 0xE0, 0xB2, 0xA5 },
	0x8132AC32,	{ 0xE0, 0xB2, 0xA6 },
	0x8132AC33,	{ 0xE0, 0xB2, 0xA7 },
	0x8132AC34,	{ 0xE0, 0xB2, 0xA8 },
	0x8132AC35,	{ 0xE0, 0xB2, 0xA9 },
	0x8132AC36,	{ 0xE0, 0xB2, 0xAA },
	0x8132AC37,	{ 0xE0, 0xB2, 0xAB },
	0x8132AC38,	{ 0xE0, 0xB2, 0xAC },
	0x8132AC39,	{ 0xE0, 0xB2, 0xAD },
	0x8132AD30,	{ 0xE0, 0xB2, 0xAE },
	0x8132AD31,	{ 0xE0, 0xB2, 0xAF },
	0x8132AD32,	{ 0xE0, 0xB2, 0xB0 },
	0x8132AD33,	{ 0xE0, 0xB2, 0xB1 },
	0x8132AD34,	{ 0xE0, 0xB2, 0xB2 },
	0x8132AD35,	{ 0xE0, 0xB2, 0xB3 },
	0x8132AD36,	{ 0xE0, 0xB2, 0xB4 },
	0x8132AD37,	{ 0xE0, 0xB2, 0xB5 },
	0x8132AD38,	{ 0xE0, 0xB2, 0xB6 },
	0x8132AD39,	{ 0xE0, 0xB2, 0xB7 },
	0x8132AE30,	{ 0xE0, 0xB2, 0xB8 },
	0x8132AE31,	{ 0xE0, 0xB2, 0xB9 },
	0x8132AE32,	{ 0xE0, 0xB2, 0xBA },
	0x8132AE33,	{ 0xE0, 0xB2, 0xBB },
	0x8132AE34,	{ 0xE0, 0xB2, 0xBC },
	0x8132AE35,	{ 0xE0, 0xB2, 0xBD },
	0x8132AE36,	{ 0xE0, 0xB2, 0xBE },
	0x8132AE37,	{ 0xE0, 0xB2, 0xBF },
	0x8132AE38,	{ 0xE0, 0xB3, 0x80 },
	0x8132AE39,	{ 0xE0, 0xB3, 0x81 },
	0x8132AF30,	{ 0xE0, 0xB3, 0x82 },
	0x8132AF31,	{ 0xE0, 0xB3, 0x83 },
	0x8132AF32,	{ 0xE0, 0xB3, 0x84 },
	0x8132AF33,	{ 0xE0, 0xB3, 0x85 },
	0x8132AF34,	{ 0xE0, 0xB3, 0x86 },
	0x8132AF35,	{ 0xE0, 0xB3, 0x87 },
	0x8132AF36,	{ 0xE0, 0xB3, 0x88 },
	0x8132AF37,	{ 0xE0, 0xB3, 0x89 },
	0x8132AF38,	{ 0xE0, 0xB3, 0x8A },
	0x8132AF39,	{ 0xE0, 0xB3, 0x8B },
	0x8132B030,	{ 0xE0, 0xB3, 0x8C },
	0x8132B031,	{ 0xE0, 0xB3, 0x8D },
	0x8132B032,	{ 0xE0, 0xB3, 0x8E },
	0x8132B033,	{ 0xE0, 0xB3, 0x8F },
	0x8132B034,	{ 0xE0, 0xB3, 0x90 },
	0x8132B035,	{ 0xE0, 0xB3, 0x91 },
	0x8132B036,	{ 0xE0, 0xB3, 0x92 },
	0x8132B037,	{ 0xE0, 0xB3, 0x93 },
	0x8132B038,	{ 0xE0, 0xB3, 0x94 },
	0x8132B039,	{ 0xE0, 0xB3, 0x95 },
	0x8132B130,	{ 0xE0, 0xB3, 0x96 },
	0x8132B131,	{ 0xE0, 0xB3, 0x97 },
	0x8132B132,	{ 0xE0, 0xB3, 0x98 },
	0x8132B133,	{ 0xE0, 0xB3, 0x99 },
	0x8132B134,	{ 0xE0, 0xB3, 0x9A },
	0x8132B135,	{ 0xE0, 0xB3, 0x9B },
	0x8132B136,	{ 0xE0, 0xB3, 0x9C },
	0x8132B137,	{ 0xE0, 0xB3, 0x9D },
	0x8132B138,	{ 0xE0, 0xB3, 0x9E },
	0x8132B139,	{ 0xE0, 0xB3, 0x9F },
	0x8132B230,	{ 0xE0, 0xB3, 0xA0 },
	0x8132B231,	{ 0xE0, 0xB3, 0xA1 },
	0x8132B232,	{ 0xE0, 0xB3, 0xA2 },
	0x8132B233,	{ 0xE0, 0xB3, 0xA3 },
	0x8132B234,	{ 0xE0, 0xB3, 0xA4 },
	0x8132B235,	{ 0xE0, 0xB3, 0xA5 },
	0x8132B236,	{ 0xE0, 0xB3, 0xA6 },
	0x8132B237,	{ 0xE0, 0xB3, 0xA7 },
	0x8132B238,	{ 0xE0, 0xB3, 0xA8 },
	0x8132B239,	{ 0xE0, 0xB3, 0xA9 },
	0x8132B330,	{ 0xE0, 0xB3, 0xAA },
	0x8132B331,	{ 0xE0, 0xB3, 0xAB },
	0x8132B332,	{ 0xE0, 0xB3, 0xAC },
	0x8132B333,	{ 0xE0, 0xB3, 0xAD },
	0x8132B334,	{ 0xE0, 0xB3, 0xAE },
	0x8132B335,	{ 0xE0, 0xB3, 0xAF },
	0x8132B336,	{ 0xE0, 0xB3, 0xB0 },
	0x8132B337,	{ 0xE0, 0xB3, 0xB1 },
	0x8132B338,	{ 0xE0, 0xB3, 0xB2 },
	0x8132B339,	{ 0xE0, 0xB3, 0xB3 },
	0x8132B430,	{ 0xE0, 0xB3, 0xB4 },
	0x8132B431,	{ 0xE0, 0xB3, 0xB5 },
	0x8132B432,	{ 0xE0, 0xB3, 0xB6 },
	0x8132B433,	{ 0xE0, 0xB3, 0xB7 },
	0x8132B434,	{ 0xE0, 0xB3, 0xB8 },
	0x8132B435,	{ 0xE0, 0xB3, 0xB9 },
	0x8132B436,	{ 0xE0, 0xB3, 0xBA },
	0x8132B437,	{ 0xE0, 0xB3, 0xBB },
	0x8132B438,	{ 0xE0, 0xB3, 0xBC },
	0x8132B439,	{ 0xE0, 0xB3, 0xBD },
	0x8132B530,	{ 0xE0, 0xB3, 0xBE },
	0x8132B531,	{ 0xE0, 0xB3, 0xBF },
	0x8132B532,	{ 0xE0, 0xB4, 0x80 },
	0x8132B533,	{ 0xE0, 0xB4, 0x81 },
	0x8132B534,	{ 0xE0, 0xB4, 0x82 },
	0x8132B535,	{ 0xE0, 0xB4, 0x83 },
	0x8132B536,	{ 0xE0, 0xB4, 0x84 },
	0x8132B537,	{ 0xE0, 0xB4, 0x85 },
	0x8132B538,	{ 0xE0, 0xB4, 0x86 },
	0x8132B539,	{ 0xE0, 0xB4, 0x87 },
	0x8132B630,	{ 0xE0, 0xB4, 0x88 },
	0x8132B631,	{ 0xE0, 0xB4, 0x89 },
	0x8132B632,	{ 0xE0, 0xB4, 0x8A },
	0x8132B633,	{ 0xE0, 0xB4, 0x8B },
	0x8132B634,	{ 0xE0, 0xB4, 0x8C },
	0x8132B635,	{ 0xE0, 0xB4, 0x8D },
	0x8132B636,	{ 0xE0, 0xB4, 0x8E },
	0x8132B637,	{ 0xE0, 0xB4, 0x8F },
	0x8132B638,	{ 0xE0, 0xB4, 0x90 },
	0x8132B639,	{ 0xE0, 0xB4, 0x91 },
	0x8132B730,	{ 0xE0, 0xB4, 0x92 },
	0x8132B731,	{ 0xE0, 0xB4, 0x93 },
	0x8132B732,	{ 0xE0, 0xB4, 0x94 },
	0x8132B733,	{ 0xE0, 0xB4, 0x95 },
	0x8132B734,	{ 0xE0, 0xB4, 0x96 },
	0x8132B735,	{ 0xE0, 0xB4, 0x97 },
	0x8132B736,	{ 0xE0, 0xB4, 0x98 },
	0x8132B737,	{ 0xE0, 0xB4, 0x99 },
	0x8132B738,	{ 0xE0, 0xB4, 0x9A },
	0x8132B739,	{ 0xE0, 0xB4, 0x9B },
	0x8132B830,	{ 0xE0, 0xB4, 0x9C },
	0x8132B831,	{ 0xE0, 0xB4, 0x9D },
	0x8132B832,	{ 0xE0, 0xB4, 0x9E },
	0x8132B833,	{ 0xE0, 0xB4, 0x9F },
	0x8132B834,	{ 0xE0, 0xB4, 0xA0 },
	0x8132B835,	{ 0xE0, 0xB4, 0xA1 },
	0x8132B836,	{ 0xE0, 0xB4, 0xA2 },
	0x8132B837,	{ 0xE0, 0xB4, 0xA3 },
	0x8132B838,	{ 0xE0, 0xB4, 0xA4 },
	0x8132B839,	{ 0xE0, 0xB4, 0xA5 },
	0x8132B930,	{ 0xE0, 0xB4, 0xA6 },
	0x8132B931,	{ 0xE0, 0xB4, 0xA7 },
	0x8132B932,	{ 0xE0, 0xB4, 0xA8 },
	0x8132B933,	{ 0xE0, 0xB4, 0xA9 },
	0x8132B934,	{ 0xE0, 0xB4, 0xAA },
	0x8132B935,	{ 0xE0, 0xB4, 0xAB },
	0x8132B936,	{ 0xE0, 0xB4, 0xAC },
	0x8132B937,	{ 0xE0, 0xB4, 0xAD },
	0x8132B938,	{ 0xE0, 0xB4, 0xAE },
	0x8132B939,	{ 0xE0, 0xB4, 0xAF },
	0x8132BA30,	{ 0xE0, 0xB4, 0xB0 },
	0x8132BA31,	{ 0xE0, 0xB4, 0xB1 },
	0x8132BA32,	{ 0xE0, 0xB4, 0xB2 },
	0x8132BA33,	{ 0xE0, 0xB4, 0xB3 },
	0x8132BA34,	{ 0xE0, 0xB4, 0xB4 },
	0x8132BA35,	{ 0xE0, 0xB4, 0xB5 },
	0x8132BA36,	{ 0xE0, 0xB4, 0xB6 },
	0x8132BA37,	{ 0xE0, 0xB4, 0xB7 },
	0x8132BA38,	{ 0xE0, 0xB4, 0xB8 },
	0x8132BA39,	{ 0xE0, 0xB4, 0xB9 },
	0x8132BB30,	{ 0xE0, 0xB4, 0xBA },
	0x8132BB31,	{ 0xE0, 0xB4, 0xBB },
	0x8132BB32,	{ 0xE0, 0xB4, 0xBC },
	0x8132BB33,	{ 0xE0, 0xB4, 0xBD },
	0x8132BB34,	{ 0xE0, 0xB4, 0xBE },
	0x8132BB35,	{ 0xE0, 0xB4, 0xBF },
	0x8132BB36,	{ 0xE0, 0xB5, 0x80 },
	0x8132BB37,	{ 0xE0, 0xB5, 0x81 },
	0x8132BB38,	{ 0xE0, 0xB5, 0x82 },
	0x8132BB39,	{ 0xE0, 0xB5, 0x83 },
	0x8132BC30,	{ 0xE0, 0xB5, 0x84 },
	0x8132BC31,	{ 0xE0, 0xB5, 0x85 },
	0x8132BC32,	{ 0xE0, 0xB5, 0x86 },
	0x8132BC33,	{ 0xE0, 0xB5, 0x87 },
	0x8132BC34,	{ 0xE0, 0xB5, 0x88 },
	0x8132BC35,	{ 0xE0, 0xB5, 0x89 },
	0x8132BC36,	{ 0xE0, 0xB5, 0x8A },
	0x8132BC37,	{ 0xE0, 0xB5, 0x8B },
	0x8132BC38,	{ 0xE0, 0xB5, 0x8C },
	0x8132BC39,	{ 0xE0, 0xB5, 0x8D },
	0x8132BD30,	{ 0xE0, 0xB5, 0x8E },
	0x8132BD31,	{ 0xE0, 0xB5, 0x8F },
	0x8132BD32,	{ 0xE0, 0xB5, 0x90 },
	0x8132BD33,	{ 0xE0, 0xB5, 0x91 },
	0x8132BD34,	{ 0xE0, 0xB5, 0x92 },
	0x8132BD35,	{ 0xE0, 0xB5, 0x93 },
	0x8132BD36,	{ 0xE0, 0xB5, 0x94 },
	0x8132BD37,	{ 0xE0, 0xB5, 0x95 },
	0x8132BD38,	{ 0xE0, 0xB5, 0x96 },
	0x8132BD39,	{ 0xE0, 0xB5, 0x97 },
	0x8132BE30,	{ 0xE0, 0xB5, 0x98 },
	0x8132BE31,	{ 0xE0, 0xB5, 0x99 },
	0x8132BE32,	{ 0xE0, 0xB5, 0x9A },
	0x8132BE33,	{ 0xE0, 0xB5, 0x9B },
	0x8132BE34,	{ 0xE0, 0xB5, 0x9C },
	0x8132BE35,	{ 0xE0, 0xB5, 0x9D },
	0x8132BE36,	{ 0xE0, 0xB5, 0x9E },
	0x8132BE37,	{ 0xE0, 0xB5, 0x9F },
	0x8132BE38,	{ 0xE0, 0xB5, 0xA0 },
	0x8132BE39,	{ 0xE0, 0xB5, 0xA1 },
	0x8132BF30,	{ 0xE0, 0xB5, 0xA2 },
	0x8132BF31,	{ 0xE0, 0xB5, 0xA3 },
	0x8132BF32,	{ 0xE0, 0xB5, 0xA4 },
	0x8132BF33,	{ 0xE0, 0xB5, 0xA5 },
	0x8132BF34,	{ 0xE0, 0xB5, 0xA6 },
	0x8132BF35,	{ 0xE0, 0xB5, 0xA7 },
	0x8132BF36,	{ 0xE0, 0xB5, 0xA8 },
	0x8132BF37,	{ 0xE0, 0xB5, 0xA9 },
	0x8132BF38,	{ 0xE0, 0xB5, 0xAA },
	0x8132BF39,	{ 0xE0, 0xB5, 0xAB },
	0x8132C030,	{ 0xE0, 0xB5, 0xAC },
	0x8132C031,	{ 0xE0, 0xB5, 0xAD },
	0x8132C032,	{ 0xE0, 0xB5, 0xAE },
	0x8132C033,	{ 0xE0, 0xB5, 0xAF },
	0x8132C034,	{ 0xE0, 0xB5, 0xB0 },
	0x8132C035,	{ 0xE0, 0xB5, 0xB1 },
	0x8132C036,	{ 0xE0, 0xB5, 0xB2 },
	0x8132C037,	{ 0xE0, 0xB5, 0xB3 },
	0x8132C038,	{ 0xE0, 0xB5, 0xB4 },
	0x8132C039,	{ 0xE0, 0xB5, 0xB5 },
	0x8132C130,	{ 0xE0, 0xB5, 0xB6 },
	0x8132C131,	{ 0xE0, 0xB5, 0xB7 },
	0x8132C132,	{ 0xE0, 0xB5, 0xB8 },
	0x8132C133,	{ 0xE0, 0xB5, 0xB9 },
	0x8132C134,	{ 0xE0, 0xB5, 0xBA },
	0x8132C135,	{ 0xE0, 0xB5, 0xBB },
	0x8132C136,	{ 0xE0, 0xB5, 0xBC },
	0x8132C137,	{ 0xE0, 0xB5, 0xBD },
	0x8132C138,	{ 0xE0, 0xB5, 0xBE },
	0x8132C139,	{ 0xE0, 0xB5, 0xBF },
	0x8132C230,	{ 0xE0, 0xB6, 0x80 },
	0x8132C231,	{ 0xE0, 0xB6, 0x81 },
	0x8132C232,	{ 0xE0, 0xB6, 0x82 },
	0x8132C233,	{ 0xE0, 0xB6, 0x83 },
	0x8132C234,	{ 0xE0, 0xB6, 0x84 },
	0x8132C235,	{ 0xE0, 0xB6, 0x85 },
	0x8132C236,	{ 0xE0, 0xB6, 0x86 },
	0x8132C237,	{ 0xE0, 0xB6, 0x87 },
	0x8132C238,	{ 0xE0, 0xB6, 0x88 },
	0x8132C239,	{ 0xE0, 0xB6, 0x89 },
	0x8132C330,	{ 0xE0, 0xB6, 0x8A },
	0x8132C331,	{ 0xE0, 0xB6, 0x8B },
	0x8132C332,	{ 0xE0, 0xB6, 0x8C },
	0x8132C333,	{ 0xE0, 0xB6, 0x8D },
	0x8132C334,	{ 0xE0, 0xB6, 0x8E },
	0x8132C335,	{ 0xE0, 0xB6, 0x8F },
	0x8132C336,	{ 0xE0, 0xB6, 0x90 },
	0x8132C337,	{ 0xE0, 0xB6, 0x91 },
	0x8132C338,	{ 0xE0, 0xB6, 0x92 },
	0x8132C339,	{ 0xE0, 0xB6, 0x93 },
	0x8132C430,	{ 0xE0, 0xB6, 0x94 },
	0x8132C431,	{ 0xE0, 0xB6, 0x95 },
	0x8132C432,	{ 0xE0, 0xB6, 0x96 },
	0x8132C433,	{ 0xE0, 0xB6, 0x97 },
	0x8132C434,	{ 0xE0, 0xB6, 0x98 },
	0x8132C435,	{ 0xE0, 0xB6, 0x99 },
	0x8132C436,	{ 0xE0, 0xB6, 0x9A },
	0x8132C437,	{ 0xE0, 0xB6, 0x9B },
	0x8132C438,	{ 0xE0, 0xB6, 0x9C },
	0x8132C439,	{ 0xE0, 0xB6, 0x9D },
	0x8132C530,	{ 0xE0, 0xB6, 0x9E },
	0x8132C531,	{ 0xE0, 0xB6, 0x9F },
	0x8132C532,	{ 0xE0, 0xB6, 0xA0 },
	0x8132C533,	{ 0xE0, 0xB6, 0xA1 },
	0x8132C534,	{ 0xE0, 0xB6, 0xA2 },
	0x8132C535,	{ 0xE0, 0xB6, 0xA3 },
	0x8132C536,	{ 0xE0, 0xB6, 0xA4 },
	0x8132C537,	{ 0xE0, 0xB6, 0xA5 },
	0x8132C538,	{ 0xE0, 0xB6, 0xA6 },
	0x8132C539,	{ 0xE0, 0xB6, 0xA7 },
	0x8132C630,	{ 0xE0, 0xB6, 0xA8 },
	0x8132C631,	{ 0xE0, 0xB6, 0xA9 },
	0x8132C632,	{ 0xE0, 0xB6, 0xAA },
	0x8132C633,	{ 0xE0, 0xB6, 0xAB },
	0x8132C634,	{ 0xE0, 0xB6, 0xAC },
	0x8132C635,	{ 0xE0, 0xB6, 0xAD },
	0x8132C636,	{ 0xE0, 0xB6, 0xAE },
	0x8132C637,	{ 0xE0, 0xB6, 0xAF },
	0x8132C638,	{ 0xE0, 0xB6, 0xB0 },
	0x8132C639,	{ 0xE0, 0xB6, 0xB1 },
	0x8132C730,	{ 0xE0, 0xB6, 0xB2 },
	0x8132C731,	{ 0xE0, 0xB6, 0xB3 },
	0x8132C732,	{ 0xE0, 0xB6, 0xB4 },
	0x8132C733,	{ 0xE0, 0xB6, 0xB5 },
	0x8132C734,	{ 0xE0, 0xB6, 0xB6 },
	0x8132C735,	{ 0xE0, 0xB6, 0xB7 },
	0x8132C736,	{ 0xE0, 0xB6, 0xB8 },
	0x8132C737,	{ 0xE0, 0xB6, 0xB9 },
	0x8132C738,	{ 0xE0, 0xB6, 0xBA },
	0x8132C739,	{ 0xE0, 0xB6, 0xBB },
	0x8132C830,	{ 0xE0, 0xB6, 0xBC },
	0x8132C831,	{ 0xE0, 0xB6, 0xBD },
	0x8132C832,	{ 0xE0, 0xB6, 0xBE },
	0x8132C833,	{ 0xE0, 0xB6, 0xBF },
	0x8132C834,	{ 0xE0, 0xB7, 0x80 },
	0x8132C835,	{ 0xE0, 0xB7, 0x81 },
	0x8132C836,	{ 0xE0, 0xB7, 0x82 },
	0x8132C837,	{ 0xE0, 0xB7, 0x83 },
	0x8132C838,	{ 0xE0, 0xB7, 0x84 },
	0x8132C839,	{ 0xE0, 0xB7, 0x85 },
	0x8132C930,	{ 0xE0, 0xB7, 0x86 },
	0x8132C931,	{ 0xE0, 0xB7, 0x87 },
	0x8132C932,	{ 0xE0, 0xB7, 0x88 },
	0x8132C933,	{ 0xE0, 0xB7, 0x89 },
	0x8132C934,	{ 0xE0, 0xB7, 0x8A },
	0x8132C935,	{ 0xE0, 0xB7, 0x8B },
	0x8132C936,	{ 0xE0, 0xB7, 0x8C },
	0x8132C937,	{ 0xE0, 0xB7, 0x8D },
	0x8132C938,	{ 0xE0, 0xB7, 0x8E },
	0x8132C939,	{ 0xE0, 0xB7, 0x8F },
	0x8132CA30,	{ 0xE0, 0xB7, 0x90 },
	0x8132CA31,	{ 0xE0, 0xB7, 0x91 },
	0x8132CA32,	{ 0xE0, 0xB7, 0x92 },
	0x8132CA33,	{ 0xE0, 0xB7, 0x93 },
	0x8132CA34,	{ 0xE0, 0xB7, 0x94 },
	0x8132CA35,	{ 0xE0, 0xB7, 0x95 },
	0x8132CA36,	{ 0xE0, 0xB7, 0x96 },
	0x8132CA37,	{ 0xE0, 0xB7, 0x97 },
	0x8132CA38,	{ 0xE0, 0xB7, 0x98 },
	0x8132CA39,	{ 0xE0, 0xB7, 0x99 },
	0x8132CB30,	{ 0xE0, 0xB7, 0x9A },
	0x8132CB31,	{ 0xE0, 0xB7, 0x9B },
	0x8132CB32,	{ 0xE0, 0xB7, 0x9C },
	0x8132CB33,	{ 0xE0, 0xB7, 0x9D },
	0x8132CB34,	{ 0xE0, 0xB7, 0x9E },
	0x8132CB35,	{ 0xE0, 0xB7, 0x9F },
	0x8132CB36,	{ 0xE0, 0xB7, 0xA0 },
	0x8132CB37,	{ 0xE0, 0xB7, 0xA1 },
	0x8132CB38,	{ 0xE0, 0xB7, 0xA2 },
	0x8132CB39,	{ 0xE0, 0xB7, 0xA3 },
	0x8132CC30,	{ 0xE0, 0xB7, 0xA4 },
	0x8132CC31,	{ 0xE0, 0xB7, 0xA5 },
	0x8132CC32,	{ 0xE0, 0xB7, 0xA6 },
	0x8132CC33,	{ 0xE0, 0xB7, 0xA7 },
	0x8132CC34,	{ 0xE0, 0xB7, 0xA8 },
	0x8132CC35,	{ 0xE0, 0xB7, 0xA9 },
	0x8132CC36,	{ 0xE0, 0xB7, 0xAA },
	0x8132CC37,	{ 0xE0, 0xB7, 0xAB },
	0x8132CC38,	{ 0xE0, 0xB7, 0xAC },
	0x8132CC39,	{ 0xE0, 0xB7, 0xAD },
	0x8132CD30,	{ 0xE0, 0xB7, 0xAE },
	0x8132CD31,	{ 0xE0, 0xB7, 0xAF },
	0x8132CD32,	{ 0xE0, 0xB7, 0xB0 },
	0x8132CD33,	{ 0xE0, 0xB7, 0xB1 },
	0x8132CD34,	{ 0xE0, 0xB7, 0xB2 },
	0x8132CD35,	{ 0xE0, 0xB7, 0xB3 },
	0x8132CD36,	{ 0xE0, 0xB7, 0xB4 },
	0x8132CD37,	{ 0xE0, 0xB7, 0xB5 },
	0x8132CD38,	{ 0xE0, 0xB7, 0xB6 },
	0x8132CD39,	{ 0xE0, 0xB7, 0xB7 },
	0x8132CE30,	{ 0xE0, 0xB7, 0xB8 },
	0x8132CE31,	{ 0xE0, 0xB7, 0xB9 },
	0x8132CE32,	{ 0xE0, 0xB7, 0xBA },
	0x8132CE33,	{ 0xE0, 0xB7, 0xBB },
	0x8132CE34,	{ 0xE0, 0xB7, 0xBC },
	0x8132CE35,	{ 0xE0, 0xB7, 0xBD },
	0x8132CE36,	{ 0xE0, 0xB7, 0xBE },
	0x8132CE37,	{ 0xE0, 0xB7, 0xBF },
	0x8132CE38,	{ 0xE0, 0xB8, 0x80 },
	0x8132CE39,	{ 0xE0, 0xB8, 0x81 },
	0x8132CF30,	{ 0xE0, 0xB8, 0x82 },
	0x8132CF31,	{ 0xE0, 0xB8, 0x83 },
	0x8132CF32,	{ 0xE0, 0xB8, 0x84 },
	0x8132CF33,	{ 0xE0, 0xB8, 0x85 },
	0x8132CF34,	{ 0xE0, 0xB8, 0x86 },
	0x8132CF35,	{ 0xE0, 0xB8, 0x87 },
	0x8132CF36,	{ 0xE0, 0xB8, 0x88 },
	0x8132CF37,	{ 0xE0, 0xB8, 0x89 },
	0x8132CF38,	{ 0xE0, 0xB8, 0x8A },
	0x8132CF39,	{ 0xE0, 0xB8, 0x8B },
	0x8132D030,	{ 0xE0, 0xB8, 0x8C },
	0x8132D031,	{ 0xE0, 0xB8, 0x8D },
	0x8132D032,	{ 0xE0, 0xB8, 0x8E },
	0x8132D033,	{ 0xE0, 0xB8, 0x8F },
	0x8132D034,	{ 0xE0, 0xB8, 0x90 },
	0x8132D035,	{ 0xE0, 0xB8, 0x91 },
	0x8132D036,	{ 0xE0, 0xB8, 0x92 },
	0x8132D037,	{ 0xE0, 0xB8, 0x93 },
	0x8132D038,	{ 0xE0, 0xB8, 0x94 },
	0x8132D039,	{ 0xE0, 0xB8, 0x95 },
	0x8132D130,	{ 0xE0, 0xB8, 0x96 },
	0x8132D131,	{ 0xE0, 0xB8, 0x97 },
	0x8132D132,	{ 0xE0, 0xB8, 0x98 },
	0x8132D133,	{ 0xE0, 0xB8, 0x99 },
	0x8132D134,	{ 0xE0, 0xB8, 0x9A },
	0x8132D135,	{ 0xE0, 0xB8, 0x9B },
	0x8132D136,	{ 0xE0, 0xB8, 0x9C },
	0x8132D137,	{ 0xE0, 0xB8, 0x9D },
	0x8132D138,	{ 0xE0, 0xB8, 0x9E },
	0x8132D139,	{ 0xE0, 0xB8, 0x9F },
	0x8132D230,	{ 0xE0, 0xB8, 0xA0 },
	0x8132D231,	{ 0xE0, 0xB8, 0xA1 },
	0x8132D232,	{ 0xE0, 0xB8, 0xA2 },
	0x8132D233,	{ 0xE0, 0xB8, 0xA3 },
	0x8132D234,	{ 0xE0, 0xB8, 0xA4 },
	0x8132D235,	{ 0xE0, 0xB8, 0xA5 },
	0x8132D236,	{ 0xE0, 0xB8, 0xA6 },
	0x8132D237,	{ 0xE0, 0xB8, 0xA7 },
	0x8132D238,	{ 0xE0, 0xB8, 0xA8 },
	0x8132D239,	{ 0xE0, 0xB8, 0xA9 },
	0x8132D330,	{ 0xE0, 0xB8, 0xAA },
	0x8132D331,	{ 0xE0, 0xB8, 0xAB },
	0x8132D332,	{ 0xE0, 0xB8, 0xAC },
	0x8132D333,	{ 0xE0, 0xB8, 0xAD },
	0x8132D334,	{ 0xE0, 0xB8, 0xAE },
	0x8132D335,	{ 0xE0, 0xB8, 0xAF },
	0x8132D336,	{ 0xE0, 0xB8, 0xB0 },
	0x8132D337,	{ 0xE0, 0xB8, 0xB1 },
	0x8132D338,	{ 0xE0, 0xB8, 0xB2 },
	0x8132D339,	{ 0xE0, 0xB8, 0xB3 },
	0x8132D430,	{ 0xE0, 0xB8, 0xB4 },
	0x8132D431,	{ 0xE0, 0xB8, 0xB5 },
	0x8132D432,	{ 0xE0, 0xB8, 0xB6 },
	0x8132D433,	{ 0xE0, 0xB8, 0xB7 },
	0x8132D434,	{ 0xE0, 0xB8, 0xB8 },
	0x8132D435,	{ 0xE0, 0xB8, 0xB9 },
	0x8132D436,	{ 0xE0, 0xB8, 0xBA },
	0x8132D437,	{ 0xE0, 0xB8, 0xBB },
	0x8132D438,	{ 0xE0, 0xB8, 0xBC },
	0x8132D439,	{ 0xE0, 0xB8, 0xBD },
	0x8132D530,	{ 0xE0, 0xB8, 0xBE },
	0x8132D531,	{ 0xE0, 0xB8, 0xBF },
	0x8132D532,	{ 0xE0, 0xB9, 0x80 },
	0x8132D533,	{ 0xE0, 0xB9, 0x81 },
	0x8132D534,	{ 0xE0, 0xB9, 0x82 },
	0x8132D535,	{ 0xE0, 0xB9, 0x83 },
	0x8132D536,	{ 0xE0, 0xB9, 0x84 },
	0x8132D537,	{ 0xE0, 0xB9, 0x85 },
	0x8132D538,	{ 0xE0, 0xB9, 0x86 },
	0x8132D539,	{ 0xE0, 0xB9, 0x87 },
	0x8132D630,	{ 0xE0, 0xB9, 0x88 },
	0x8132D631,	{ 0xE0, 0xB9, 0x89 },
	0x8132D632,	{ 0xE0, 0xB9, 0x8A },
	0x8132D633,	{ 0xE0, 0xB9, 0x8B },
	0x8132D634,	{ 0xE0, 0xB9, 0x8C },
	0x8132D635,	{ 0xE0, 0xB9, 0x8D },
	0x8132D636,	{ 0xE0, 0xB9, 0x8E },
	0x8132D637,	{ 0xE0, 0xB9, 0x8F },
	0x8132D638,	{ 0xE0, 0xB9, 0x90 },
	0x8132D639,	{ 0xE0, 0xB9, 0x91 },
	0x8132D730,	{ 0xE0, 0xB9, 0x92 },
	0x8132D731,	{ 0xE0, 0xB9, 0x93 },
	0x8132D732,	{ 0xE0, 0xB9, 0x94 },
	0x8132D733,	{ 0xE0, 0xB9, 0x95 },
	0x8132D734,	{ 0xE0, 0xB9, 0x96 },
	0x8132D735,	{ 0xE0, 0xB9, 0x97 },
	0x8132D736,	{ 0xE0, 0xB9, 0x98 },
	0x8132D737,	{ 0xE0, 0xB9, 0x99 },
	0x8132D738,	{ 0xE0, 0xB9, 0x9A },
	0x8132D739,	{ 0xE0, 0xB9, 0x9B },
	0x8132D830,	{ 0xE0, 0xB9, 0x9C },
	0x8132D831,	{ 0xE0, 0xB9, 0x9D },
	0x8132D832,	{ 0xE0, 0xB9, 0x9E },
	0x8132D833,	{ 0xE0, 0xB9, 0x9F },
	0x8132D834,	{ 0xE0, 0xB9, 0xA0 },
	0x8132D835,	{ 0xE0, 0xB9, 0xA1 },
	0x8132D836,	{ 0xE0, 0xB9, 0xA2 },
	0x8132D837,	{ 0xE0, 0xB9, 0xA3 },
	0x8132D838,	{ 0xE0, 0xB9, 0xA4 },
	0x8132D839,	{ 0xE0, 0xB9, 0xA5 },
	0x8132D930,	{ 0xE0, 0xB9, 0xA6 },
	0x8132D931,	{ 0xE0, 0xB9, 0xA7 },
	0x8132D932,	{ 0xE0, 0xB9, 0xA8 },
	0x8132D933,	{ 0xE0, 0xB9, 0xA9 },
	0x8132D934,	{ 0xE0, 0xB9, 0xAA },
	0x8132D935,	{ 0xE0, 0xB9, 0xAB },
	0x8132D936,	{ 0xE0, 0xB9, 0xAC },
	0x8132D937,	{ 0xE0, 0xB9, 0xAD },
	0x8132D938,	{ 0xE0, 0xB9, 0xAE },
	0x8132D939,	{ 0xE0, 0xB9, 0xAF },
	0x8132DA30,	{ 0xE0, 0xB9, 0xB0 },
	0x8132DA31,	{ 0xE0, 0xB9, 0xB1 },
	0x8132DA32,	{ 0xE0, 0xB9, 0xB2 },
	0x8132DA33,	{ 0xE0, 0xB9, 0xB3 },
	0x8132DA34,	{ 0xE0, 0xB9, 0xB4 },
	0x8132DA35,	{ 0xE0, 0xB9, 0xB5 },
	0x8132DA36,	{ 0xE0, 0xB9, 0xB6 },
	0x8132DA37,	{ 0xE0, 0xB9, 0xB7 },
	0x8132DA38,	{ 0xE0, 0xB9, 0xB8 },
	0x8132DA39,	{ 0xE0, 0xB9, 0xB9 },
	0x8132DB30,	{ 0xE0, 0xB9, 0xBA },
	0x8132DB31,	{ 0xE0, 0xB9, 0xBB },
	0x8132DB32,	{ 0xE0, 0xB9, 0xBC },
	0x8132DB33,	{ 0xE0, 0xB9, 0xBD },
	0x8132DB34,	{ 0xE0, 0xB9, 0xBE },
	0x8132DB35,	{ 0xE0, 0xB9, 0xBF },
	0x8132DB36,	{ 0xE0, 0xBA, 0x80 },
	0x8132DB37,	{ 0xE0, 0xBA, 0x81 },
	0x8132DB38,	{ 0xE0, 0xBA, 0x82 },
	0x8132DB39,	{ 0xE0, 0xBA, 0x83 },
	0x8132DC30,	{ 0xE0, 0xBA, 0x84 },
	0x8132DC31,	{ 0xE0, 0xBA, 0x85 },
	0x8132DC32,	{ 0xE0, 0xBA, 0x86 },
	0x8132DC33,	{ 0xE0, 0xBA, 0x87 },
	0x8132DC34,	{ 0xE0, 0xBA, 0x88 },
	0x8132DC35,	{ 0xE0, 0xBA, 0x89 },
	0x8132DC36,	{ 0xE0, 0xBA, 0x8A },
	0x8132DC37,	{ 0xE0, 0xBA, 0x8B },
	0x8132DC38,	{ 0xE0, 0xBA, 0x8C },
	0x8132DC39,	{ 0xE0, 0xBA, 0x8D },
	0x8132DD30,	{ 0xE0, 0xBA, 0x8E },
	0x8132DD31,	{ 0xE0, 0xBA, 0x8F },
	0x8132DD32,	{ 0xE0, 0xBA, 0x90 },
	0x8132DD33,	{ 0xE0, 0xBA, 0x91 },
	0x8132DD34,	{ 0xE0, 0xBA, 0x92 },
	0x8132DD35,	{ 0xE0, 0xBA, 0x93 },
	0x8132DD36,	{ 0xE0, 0xBA, 0x94 },
	0x8132DD37,	{ 0xE0, 0xBA, 0x95 },
	0x8132DD38,	{ 0xE0, 0xBA, 0x96 },
	0x8132DD39,	{ 0xE0, 0xBA, 0x97 },
	0x8132DE30,	{ 0xE0, 0xBA, 0x98 },
	0x8132DE31,	{ 0xE0, 0xBA, 0x99 },
	0x8132DE32,	{ 0xE0, 0xBA, 0x9A },
	0x8132DE33,	{ 0xE0, 0xBA, 0x9B },
	0x8132DE34,	{ 0xE0, 0xBA, 0x9C },
	0x8132DE35,	{ 0xE0, 0xBA, 0x9D },
	0x8132DE36,	{ 0xE0, 0xBA, 0x9E },
	0x8132DE37,	{ 0xE0, 0xBA, 0x9F },
	0x8132DE38,	{ 0xE0, 0xBA, 0xA0 },
	0x8132DE39,	{ 0xE0, 0xBA, 0xA1 },
	0x8132DF30,	{ 0xE0, 0xBA, 0xA2 },
	0x8132DF31,	{ 0xE0, 0xBA, 0xA3 },
	0x8132DF32,	{ 0xE0, 0xBA, 0xA4 },
	0x8132DF33,	{ 0xE0, 0xBA, 0xA5 },
	0x8132DF34,	{ 0xE0, 0xBA, 0xA6 },
	0x8132DF35,	{ 0xE0, 0xBA, 0xA7 },
	0x8132DF36,	{ 0xE0, 0xBA, 0xA8 },
	0x8132DF37,	{ 0xE0, 0xBA, 0xA9 },
	0x8132DF38,	{ 0xE0, 0xBA, 0xAA },
	0x8132DF39,	{ 0xE0, 0xBA, 0xAB },
	0x8132E030,	{ 0xE0, 0xBA, 0xAC },
	0x8132E031,	{ 0xE0, 0xBA, 0xAD },
	0x8132E032,	{ 0xE0, 0xBA, 0xAE },
	0x8132E033,	{ 0xE0, 0xBA, 0xAF },
	0x8132E034,	{ 0xE0, 0xBA, 0xB0 },
	0x8132E035,	{ 0xE0, 0xBA, 0xB1 },
	0x8132E036,	{ 0xE0, 0xBA, 0xB2 },
	0x8132E037,	{ 0xE0, 0xBA, 0xB3 },
	0x8132E038,	{ 0xE0, 0xBA, 0xB4 },
	0x8132E039,	{ 0xE0, 0xBA, 0xB5 },
	0x8132E130,	{ 0xE0, 0xBA, 0xB6 },
	0x8132E131,	{ 0xE0, 0xBA, 0xB7 },
	0x8132E132,	{ 0xE0, 0xBA, 0xB8 },
	0x8132E133,	{ 0xE0, 0xBA, 0xB9 },
	0x8132E134,	{ 0xE0, 0xBA, 0xBA },
	0x8132E135,	{ 0xE0, 0xBA, 0xBB },
	0x8132E136,	{ 0xE0, 0xBA, 0xBC },
	0x8132E137,	{ 0xE0, 0xBA, 0xBD },
	0x8132E138,	{ 0xE0, 0xBA, 0xBE },
	0x8132E139,	{ 0xE0, 0xBA, 0xBF },
	0x8132E230,	{ 0xE0, 0xBB, 0x80 },
	0x8132E231,	{ 0xE0, 0xBB, 0x81 },
	0x8132E232,	{ 0xE0, 0xBB, 0x82 },
	0x8132E233,	{ 0xE0, 0xBB, 0x83 },
	0x8132E234,	{ 0xE0, 0xBB, 0x84 },
	0x8132E235,	{ 0xE0, 0xBB, 0x85 },
	0x8132E236,	{ 0xE0, 0xBB, 0x86 },
	0x8132E237,	{ 0xE0, 0xBB, 0x87 },
	0x8132E238,	{ 0xE0, 0xBB, 0x88 },
	0x8132E239,	{ 0xE0, 0xBB, 0x89 },
	0x8132E330,	{ 0xE0, 0xBB, 0x8A },
	0x8132E331,	{ 0xE0, 0xBB, 0x8B },
	0x8132E332,	{ 0xE0, 0xBB, 0x8C },
	0x8132E333,	{ 0xE0, 0xBB, 0x8D },
	0x8132E334,	{ 0xE0, 0xBB, 0x8E },
	0x8132E335,	{ 0xE0, 0xBB, 0x8F },
	0x8132E336,	{ 0xE0, 0xBB, 0x90 },
	0x8132E337,	{ 0xE0, 0xBB, 0x91 },
	0x8132E338,	{ 0xE0, 0xBB, 0x92 },
	0x8132E339,	{ 0xE0, 0xBB, 0x93 },
	0x8132E430,	{ 0xE0, 0xBB, 0x94 },
	0x8132E431,	{ 0xE0, 0xBB, 0x95 },
	0x8132E432,	{ 0xE0, 0xBB, 0x96 },
	0x8132E433,	{ 0xE0, 0xBB, 0x97 },
	0x8132E434,	{ 0xE0, 0xBB, 0x98 },
	0x8132E435,	{ 0xE0, 0xBB, 0x99 },
	0x8132E436,	{ 0xE0, 0xBB, 0x9A },
	0x8132E437,	{ 0xE0, 0xBB, 0x9B },
	0x8132E438,	{ 0xE0, 0xBB, 0x9C },
	0x8132E439,	{ 0xE0, 0xBB, 0x9D },
	0x8132E530,	{ 0xE0, 0xBB, 0x9E },
	0x8132E531,	{ 0xE0, 0xBB, 0x9F },
	0x8132E532,	{ 0xE0, 0xBB, 0xA0 },
	0x8132E533,	{ 0xE0, 0xBB, 0xA1 },
	0x8132E534,	{ 0xE0, 0xBB, 0xA2 },
	0x8132E535,	{ 0xE0, 0xBB, 0xA3 },
	0x8132E536,	{ 0xE0, 0xBB, 0xA4 },
	0x8132E537,	{ 0xE0, 0xBB, 0xA5 },
	0x8132E538,	{ 0xE0, 0xBB, 0xA6 },
	0x8132E539,	{ 0xE0, 0xBB, 0xA7 },
	0x8132E630,	{ 0xE0, 0xBB, 0xA8 },
	0x8132E631,	{ 0xE0, 0xBB, 0xA9 },
	0x8132E632,	{ 0xE0, 0xBB, 0xAA },
	0x8132E633,	{ 0xE0, 0xBB, 0xAB },
	0x8132E634,	{ 0xE0, 0xBB, 0xAC },
	0x8132E635,	{ 0xE0, 0xBB, 0xAD },
	0x8132E636,	{ 0xE0, 0xBB, 0xAE },
	0x8132E637,	{ 0xE0, 0xBB, 0xAF },
	0x8132E638,	{ 0xE0, 0xBB, 0xB0 },
	0x8132E639,	{ 0xE0, 0xBB, 0xB1 },
	0x8132E730,	{ 0xE0, 0xBB, 0xB2 },
	0x8132E731,	{ 0xE0, 0xBB, 0xB3 },
	0x8132E732,	{ 0xE0, 0xBB, 0xB4 },
	0x8132E733,	{ 0xE0, 0xBB, 0xB5 },
	0x8132E734,	{ 0xE0, 0xBB, 0xB6 },
	0x8132E735,	{ 0xE0, 0xBB, 0xB7 },
	0x8132E736,	{ 0xE0, 0xBB, 0xB8 },
	0x8132E737,	{ 0xE0, 0xBB, 0xB9 },
	0x8132E738,	{ 0xE0, 0xBB, 0xBA },
	0x8132E739,	{ 0xE0, 0xBB, 0xBB },
	0x8132E830,	{ 0xE0, 0xBB, 0xBC },
	0x8132E831,	{ 0xE0, 0xBB, 0xBD },
	0x8132E832,	{ 0xE0, 0xBB, 0xBE },
	0x8132E833,	{ 0xE0, 0xBB, 0xBF },
	0x8132E834,	{ 0xE0, 0xBC, 0x80 },
	0x8132E835,	{ 0xE0, 0xBC, 0x81 },
	0x8132E836,	{ 0xE0, 0xBC, 0x82 },
	0x8132E837,	{ 0xE0, 0xBC, 0x83 },
	0x8132E838,	{ 0xE0, 0xBC, 0x84 },
	0x8132E839,	{ 0xE0, 0xBC, 0x85 },
	0x8132E930,	{ 0xE0, 0xBC, 0x86 },
	0x8132E931,	{ 0xE0, 0xBC, 0x87 },
	0x8132E932,	{ 0xE0, 0xBC, 0x88 },
	0x8132E933,	{ 0xE0, 0xBC, 0x89 },
	0x8132E934,	{ 0xE0, 0xBC, 0x8A },
	0x8132E935,	{ 0xE0, 0xBC, 0x8B },
	0x8132E936,	{ 0xE0, 0xBC, 0x8C },
	0x8132E937,	{ 0xE0, 0xBC, 0x8D },
	0x8132E938,	{ 0xE0, 0xBC, 0x8E },
	0x8132E939,	{ 0xE0, 0xBC, 0x8F },
	0x8132EA30,	{ 0xE0, 0xBC, 0x90 },
	0x8132EA31,	{ 0xE0, 0xBC, 0x91 },
	0x8132EA32,	{ 0xE0, 0xBC, 0x92 },
	0x8132EA33,	{ 0xE0, 0xBC, 0x93 },
	0x8132EA34,	{ 0xE0, 0xBC, 0x94 },
	0x8132EA35,	{ 0xE0, 0xBC, 0x95 },
	0x8132EA36,	{ 0xE0, 0xBC, 0x96 },
	0x8132EA37,	{ 0xE0, 0xBC, 0x97 },
	0x8132EA38,	{ 0xE0, 0xBC, 0x98 },
	0x8132EA39,	{ 0xE0, 0xBC, 0x99 },
	0x8132EB30,	{ 0xE0, 0xBC, 0x9A },
	0x8132EB31,	{ 0xE0, 0xBC, 0x9B },
	0x8132EB32,	{ 0xE0, 0xBC, 0x9C },
	0x8132EB33,	{ 0xE0, 0xBC, 0x9D },
	0x8132EB34,	{ 0xE0, 0xBC, 0x9E },
	0x8132EB35,	{ 0xE0, 0xBC, 0x9F },
	0x8132EB36,	{ 0xE0, 0xBC, 0xA0 },
	0x8132EB37,	{ 0xE0, 0xBC, 0xA1 },
	0x8132EB38,	{ 0xE0, 0xBC, 0xA2 },
	0x8132EB39,	{ 0xE0, 0xBC, 0xA3 },
	0x8132EC30,	{ 0xE0, 0xBC, 0xA4 },
	0x8132EC31,	{ 0xE0, 0xBC, 0xA5 },
	0x8132EC32,	{ 0xE0, 0xBC, 0xA6 },
	0x8132EC33,	{ 0xE0, 0xBC, 0xA7 },
	0x8132EC34,	{ 0xE0, 0xBC, 0xA8 },
	0x8132EC35,	{ 0xE0, 0xBC, 0xA9 },
	0x8132EC36,	{ 0xE0, 0xBC, 0xAA },
	0x8132EC37,	{ 0xE0, 0xBC, 0xAB },
	0x8132EC38,	{ 0xE0, 0xBC, 0xAC },
	0x8132EC39,	{ 0xE0, 0xBC, 0xAD },
	0x8132ED30,	{ 0xE0, 0xBC, 0xAE },
	0x8132ED31,	{ 0xE0, 0xBC, 0xAF },
	0x8132ED32,	{ 0xE0, 0xBC, 0xB0 },
	0x8132ED33,	{ 0xE0, 0xBC, 0xB1 },
	0x8132ED34,	{ 0xE0, 0xBC, 0xB2 },
	0x8132ED35,	{ 0xE0, 0xBC, 0xB3 },
	0x8132ED36,	{ 0xE0, 0xBC, 0xB4 },
	0x8132ED37,	{ 0xE0, 0xBC, 0xB5 },
	0x8132ED38,	{ 0xE0, 0xBC, 0xB6 },
	0x8132ED39,	{ 0xE0, 0xBC, 0xB7 },
	0x8132EE30,	{ 0xE0, 0xBC, 0xB8 },
	0x8132EE31,	{ 0xE0, 0xBC, 0xB9 },
	0x8132EE32,	{ 0xE0, 0xBC, 0xBA },
	0x8132EE33,	{ 0xE0, 0xBC, 0xBB },
	0x8132EE34,	{ 0xE0, 0xBC, 0xBC },
	0x8132EE35,	{ 0xE0, 0xBC, 0xBD },
	0x8132EE36,	{ 0xE0, 0xBC, 0xBE },
	0x8132EE37,	{ 0xE0, 0xBC, 0xBF },
	0x8132EE38,	{ 0xE0, 0xBD, 0x80 },
	0x8132EE39,	{ 0xE0, 0xBD, 0x81 },
	0x8132EF30,	{ 0xE0, 0xBD, 0x82 },
	0x8132EF31,	{ 0xE0, 0xBD, 0x83 },
	0x8132EF32,	{ 0xE0, 0xBD, 0x84 },
	0x8132EF33,	{ 0xE0, 0xBD, 0x85 },
	0x8132EF34,	{ 0xE0, 0xBD, 0x86 },
	0x8132EF35,	{ 0xE0, 0xBD, 0x87 },
	0x8132EF36,	{ 0xE0, 0xBD, 0x88 },
	0x8132EF37,	{ 0xE0, 0xBD, 0x89 },
	0x8132EF38,	{ 0xE0, 0xBD, 0x8A },
	0x8132EF39,	{ 0xE0, 0xBD, 0x8B },
	0x8132F030,	{ 0xE0, 0xBD, 0x8C },
	0x8132F031,	{ 0xE0, 0xBD, 0x8D },
	0x8132F032,	{ 0xE0, 0xBD, 0x8E },
	0x8132F033,	{ 0xE0, 0xBD, 0x8F },
	0x8132F034,	{ 0xE0, 0xBD, 0x90 },
	0x8132F035,	{ 0xE0, 0xBD, 0x91 },
	0x8132F036,	{ 0xE0, 0xBD, 0x92 },
	0x8132F037,	{ 0xE0, 0xBD, 0x93 },
	0x8132F038,	{ 0xE0, 0xBD, 0x94 },
	0x8132F039,	{ 0xE0, 0xBD, 0x95 },
	0x8132F130,	{ 0xE0, 0xBD, 0x96 },
	0x8132F131,	{ 0xE0, 0xBD, 0x97 },
	0x8132F132,	{ 0xE0, 0xBD, 0x98 },
	0x8132F133,	{ 0xE0, 0xBD, 0x99 },
	0x8132F134,	{ 0xE0, 0xBD, 0x9A },
	0x8132F135,	{ 0xE0, 0xBD, 0x9B },
	0x8132F136,	{ 0xE0, 0xBD, 0x9C },
	0x8132F137,	{ 0xE0, 0xBD, 0x9D },
	0x8132F138,	{ 0xE0, 0xBD, 0x9E },
	0x8132F139,	{ 0xE0, 0xBD, 0x9F },
	0x8132F230,	{ 0xE0, 0xBD, 0xA0 },
	0x8132F231,	{ 0xE0, 0xBD, 0xA1 },
	0x8132F232,	{ 0xE0, 0xBD, 0xA2 },
	0x8132F233,	{ 0xE0, 0xBD, 0xA3 },
	0x8132F234,	{ 0xE0, 0xBD, 0xA4 },
	0x8132F235,	{ 0xE0, 0xBD, 0xA5 },
	0x8132F236,	{ 0xE0, 0xBD, 0xA6 },
	0x8132F237,	{ 0xE0, 0xBD, 0xA7 },
	0x8132F238,	{ 0xE0, 0xBD, 0xA8 },
	0x8132F239,	{ 0xE0, 0xBD, 0xA9 },
	0x8132F330,	{ 0xE0, 0xBD, 0xAA },
	0x8132F331,	{ 0xE0, 0xBD, 0xAB },
	0x8132F332,	{ 0xE0, 0xBD, 0xAC },
	0x8132F333,	{ 0xE0, 0xBD, 0xAD },
	0x8132F334,	{ 0xE0, 0xBD, 0xAE },
	0x8132F335,	{ 0xE0, 0xBD, 0xAF },
	0x8132F336,	{ 0xE0, 0xBD, 0xB0 },
	0x8132F337,	{ 0xE0, 0xBD, 0xB1 },
	0x8132F338,	{ 0xE0, 0xBD, 0xB2 },
	0x8132F339,	{ 0xE0, 0xBD, 0xB3 },
	0x8132F430,	{ 0xE0, 0xBD, 0xB4 },
	0x8132F431,	{ 0xE0, 0xBD, 0xB5 },
	0x8132F432,	{ 0xE0, 0xBD, 0xB6 },
	0x8132F433,	{ 0xE0, 0xBD, 0xB7 },
	0x8132F434,	{ 0xE0, 0xBD, 0xB8 },
	0x8132F435,	{ 0xE0, 0xBD, 0xB9 },
	0x8132F436,	{ 0xE0, 0xBD, 0xBA },
	0x8132F437,	{ 0xE0, 0xBD, 0xBB },
	0x8132F438,	{ 0xE0, 0xBD, 0xBC },
	0x8132F439,	{ 0xE0, 0xBD, 0xBD },
	0x8132F530,	{ 0xE0, 0xBD, 0xBE },
	0x8132F531,	{ 0xE0, 0xBD, 0xBF },
	0x8132F532,	{ 0xE0, 0xBE, 0x80 },
	0x8132F533,	{ 0xE0, 0xBE, 0x81 },
	0x8132F534,	{ 0xE0, 0xBE, 0x82 },
	0x8132F535,	{ 0xE0, 0xBE, 0x83 },
	0x8132F536,	{ 0xE0, 0xBE, 0x84 },
	0x8132F537,	{ 0xE0, 0xBE, 0x85 },
	0x8132F538,	{ 0xE0, 0xBE, 0x86 },
	0x8132F539,	{ 0xE0, 0xBE, 0x87 },
	0x8132F630,	{ 0xE0, 0xBE, 0x88 },
	0x8132F631,	{ 0xE0, 0xBE, 0x89 },
	0x8132F632,	{ 0xE0, 0xBE, 0x8A },
	0x8132F633,	{ 0xE0, 0xBE, 0x8B },
	0x8132F634,	{ 0xE0, 0xBE, 0x8C },
	0x8132F635,	{ 0xE0, 0xBE, 0x8D },
	0x8132F636,	{ 0xE0, 0xBE, 0x8E },
	0x8132F637,	{ 0xE0, 0xBE, 0x8F },
	0x8132F638,	{ 0xE0, 0xBE, 0x90 },
	0x8132F639,	{ 0xE0, 0xBE, 0x91 },
	0x8132F730,	{ 0xE0, 0xBE, 0x92 },
	0x8132F731,	{ 0xE0, 0xBE, 0x93 },
	0x8132F732,	{ 0xE0, 0xBE, 0x94 },
	0x8132F733,	{ 0xE0, 0xBE, 0x95 },
	0x8132F734,	{ 0xE0, 0xBE, 0x96 },
	0x8132F735,	{ 0xE0, 0xBE, 0x97 },
	0x8132F736,	{ 0xE0, 0xBE, 0x98 },
	0x8132F737,	{ 0xE0, 0xBE, 0x99 },
	0x8132F738,	{ 0xE0, 0xBE, 0x9A },
	0x8132F739,	{ 0xE0, 0xBE, 0x9B },
	0x8132F830,	{ 0xE0, 0xBE, 0x9C },
	0x8132F831,	{ 0xE0, 0xBE, 0x9D },
	0x8132F832,	{ 0xE0, 0xBE, 0x9E },
	0x8132F833,	{ 0xE0, 0xBE, 0x9F },
	0x8132F834,	{ 0xE0, 0xBE, 0xA0 },
	0x8132F835,	{ 0xE0, 0xBE, 0xA1 },
	0x8132F836,	{ 0xE0, 0xBE, 0xA2 },
	0x8132F837,	{ 0xE0, 0xBE, 0xA3 },
	0x8132F838,	{ 0xE0, 0xBE, 0xA4 },
	0x8132F839,	{ 0xE0, 0xBE, 0xA5 },
	0x8132F930,	{ 0xE0, 0xBE, 0xA6 },
	0x8132F931,	{ 0xE0, 0xBE, 0xA7 },
	0x8132F932,	{ 0xE0, 0xBE, 0xA8 },
	0x8132F933,	{ 0xE0, 0xBE, 0xA9 },
	0x8132F934,	{ 0xE0, 0xBE, 0xAA },
	0x8132F935,	{ 0xE0, 0xBE, 0xAB },
	0x8132F936,	{ 0xE0, 0xBE, 0xAC },
	0x8132F937,	{ 0xE0, 0xBE, 0xAD },
	0x8132F938,	{ 0xE0, 0xBE, 0xAE },
	0x8132F939,	{ 0xE0, 0xBE, 0xAF },
	0x8132FA30,	{ 0xE0, 0xBE, 0xB0 },
	0x8132FA31,	{ 0xE0, 0xBE, 0xB1 },
	0x8132FA32,	{ 0xE0, 0xBE, 0xB2 },
	0x8132FA33,	{ 0xE0, 0xBE, 0xB3 },
	0x8132FA34,	{ 0xE0, 0xBE, 0xB4 },
	0x8132FA35,	{ 0xE0, 0xBE, 0xB5 },
	0x8132FA36,	{ 0xE0, 0xBE, 0xB6 },
	0x8132FA37,	{ 0xE0, 0xBE, 0xB7 },
	0x8132FA38,	{ 0xE0, 0xBE, 0xB8 },
	0x8132FA39,	{ 0xE0, 0xBE, 0xB9 },
	0x8132FB30,	{ 0xE0, 0xBE, 0xBA },
	0x8132FB31,	{ 0xE0, 0xBE, 0xBB },
	0x8132FB32,	{ 0xE0, 0xBE, 0xBC },
	0x8132FB33,	{ 0xE0, 0xBE, 0xBD },
	0x8132FB34,	{ 0xE0, 0xBE, 0xBE },
	0x8132FB35,	{ 0xE0, 0xBE, 0xBF },
	0x8132FB36,	{ 0xE0, 0xBF, 0x80 },
	0x8132FB37,	{ 0xE0, 0xBF, 0x81 },
	0x8132FB38,	{ 0xE0, 0xBF, 0x82 },
	0x8132FB39,	{ 0xE0, 0xBF, 0x83 },
	0x8132FC30,	{ 0xE0, 0xBF, 0x84 },
	0x8132FC31,	{ 0xE0, 0xBF, 0x85 },
	0x8132FC32,	{ 0xE0, 0xBF, 0x86 },
	0x8132FC33,	{ 0xE0, 0xBF, 0x87 },
	0x8132FC34,	{ 0xE0, 0xBF, 0x88 },
	0x8132FC35,	{ 0xE0, 0xBF, 0x89 },
	0x8132FC36,	{ 0xE0, 0xBF, 0x8A },
	0x8132FC37,	{ 0xE0, 0xBF, 0x8B },
	0x8132FC38,	{ 0xE0, 0xBF, 0x8C },
	0x8132FC39,	{ 0xE0, 0xBF, 0x8D },
	0x8132FD30,	{ 0xE0, 0xBF, 0x8E },
	0x8132FD31,	{ 0xE0, 0xBF, 0x8F },
	0x8132FD32,	{ 0xE0, 0xBF, 0x90 },
	0x8132FD33,	{ 0xE0, 0xBF, 0x91 },
	0x8132FD34,	{ 0xE0, 0xBF, 0x92 },
	0x8132FD35,	{ 0xE0, 0xBF, 0x93 },
	0x8132FD36,	{ 0xE0, 0xBF, 0x94 },
	0x8132FD37,	{ 0xE0, 0xBF, 0x95 },
	0x8132FD38,	{ 0xE0, 0xBF, 0x96 },
	0x8132FD39,	{ 0xE0, 0xBF, 0x97 },
	0x8132FE30,	{ 0xE0, 0xBF, 0x98 },
	0x8132FE31,	{ 0xE0, 0xBF, 0x99 },
	0x8132FE32,	{ 0xE0, 0xBF, 0x9A },
	0x8132FE33,	{ 0xE0, 0xBF, 0x9B },
	0x8132FE34,	{ 0xE0, 0xBF, 0x9C },
	0x8132FE35,	{ 0xE0, 0xBF, 0x9D },
	0x8132FE36,	{ 0xE0, 0xBF, 0x9E },
	0x8132FE37,	{ 0xE0, 0xBF, 0x9F },
	0x8132FE38,	{ 0xE0, 0xBF, 0xA0 },
	0x8132FE39,	{ 0xE0, 0xBF, 0xA1 },
	0x81338130,	{ 0xE0, 0xBF, 0xA2 },
	0x81338131,	{ 0xE0, 0xBF, 0xA3 },
	0x81338132,	{ 0xE0, 0xBF, 0xA4 },
	0x81338133,	{ 0xE0, 0xBF, 0xA5 },
	0x81338134,	{ 0xE0, 0xBF, 0xA6 },
	0x81338135,	{ 0xE0, 0xBF, 0xA7 },
	0x81338136,	{ 0xE0, 0xBF, 0xA8 },
	0x81338137,	{ 0xE0, 0xBF, 0xA9 },
	0x81338138,	{ 0xE0, 0xBF, 0xAA },
	0x81338139,	{ 0xE0, 0xBF, 0xAB },
	0x81338230,	{ 0xE0, 0xBF, 0xAC },
	0x81338231,	{ 0xE0, 0xBF, 0xAD },
	0x81338232,	{ 0xE0, 0xBF, 0xAE },
	0x81338233,	{ 0xE0, 0xBF, 0xAF },
	0x81338234,	{ 0xE0, 0xBF, 0xB0 },
	0x81338235,	{ 0xE0, 0xBF, 0xB1 },
	0x81338236,	{ 0xE0, 0xBF, 0xB2 },
	0x81338237,	{ 0xE0, 0xBF, 0xB3 },
	0x81338238,	{ 0xE0, 0xBF, 0xB4 },
	0x81338239,	{ 0xE0, 0xBF, 0xB5 },
	0x81338330,	{ 0xE0, 0xBF, 0xB6 },
	0x81338331,	{ 0xE0, 0xBF, 0xB7 },
	0x81338332,	{ 0xE0, 0xBF, 0xB8 },
	0x81338333,	{ 0xE0, 0xBF, 0xB9 },
	0x81338334,	{ 0xE0, 0xBF, 0xBA },
	0x81338335,	{ 0xE0, 0xBF, 0xBB },
	0x81338336,	{ 0xE0, 0xBF, 0xBC },
	0x81338337,	{ 0xE0, 0xBF, 0xBD },
	0x81338338,	{ 0xE0, 0xBF, 0xBE },
	0x81338339,	{ 0xE0, 0xBF, 0xBF },
	0x81338430,	{ 0xE1, 0x80, 0x80 },
	0x81338431,	{ 0xE1, 0x80, 0x81 },
	0x81338432,	{ 0xE1, 0x80, 0x82 },
	0x81338433,	{ 0xE1, 0x80, 0x83 },
	0x81338434,	{ 0xE1, 0x80, 0x84 },
	0x81338435,	{ 0xE1, 0x80, 0x85 },
	0x81338436,	{ 0xE1, 0x80, 0x86 },
	0x81338437,	{ 0xE1, 0x80, 0x87 },
	0x81338438,	{ 0xE1, 0x80, 0x88 },
	0x81338439,	{ 0xE1, 0x80, 0x89 },
	0x81338530,	{ 0xE1, 0x80, 0x8A },
	0x81338531,	{ 0xE1, 0x80, 0x8B },
	0x81338532,	{ 0xE1, 0x80, 0x8C },
	0x81338533,	{ 0xE1, 0x80, 0x8D },
	0x81338534,	{ 0xE1, 0x80, 0x8E },
	0x81338535,	{ 0xE1, 0x80, 0x8F },
	0x81338536,	{ 0xE1, 0x80, 0x90 },
	0x81338537,	{ 0xE1, 0x80, 0x91 },
	0x81338538,	{ 0xE1, 0x80, 0x92 },
	0x81338539,	{ 0xE1, 0x80, 0x93 },
	0x81338630,	{ 0xE1, 0x80, 0x94 },
	0x81338631,	{ 0xE1, 0x80, 0x95 },
	0x81338632,	{ 0xE1, 0x80, 0x96 },
	0x81338633,	{ 0xE1, 0x80, 0x97 },
	0x81338634,	{ 0xE1, 0x80, 0x98 },
	0x81338635,	{ 0xE1, 0x80, 0x99 },
	0x81338636,	{ 0xE1, 0x80, 0x9A },
	0x81338637,	{ 0xE1, 0x80, 0x9B },
	0x81338638,	{ 0xE1, 0x80, 0x9C },
	0x81338639,	{ 0xE1, 0x80, 0x9D },
	0x81338730,	{ 0xE1, 0x80, 0x9E },
	0x81338731,	{ 0xE1, 0x80, 0x9F },
	0x81338732,	{ 0xE1, 0x80, 0xA0 },
	0x81338733,	{ 0xE1, 0x80, 0xA1 },
	0x81338734,	{ 0xE1, 0x80, 0xA2 },
	0x81338735,	{ 0xE1, 0x80, 0xA3 },
	0x81338736,	{ 0xE1, 0x80, 0xA4 },
	0x81338737,	{ 0xE1, 0x80, 0xA5 },
	0x81338738,	{ 0xE1, 0x80, 0xA6 },
	0x81338739,	{ 0xE1, 0x80, 0xA7 },
	0x81338830,	{ 0xE1, 0x80, 0xA8 },
	0x81338831,	{ 0xE1, 0x80, 0xA9 },
	0x81338832,	{ 0xE1, 0x80, 0xAA },
	0x81338833,	{ 0xE1, 0x80, 0xAB },
	0x81338834,	{ 0xE1, 0x80, 0xAC },
	0x81338835,	{ 0xE1, 0x80, 0xAD },
	0x81338836,	{ 0xE1, 0x80, 0xAE },
	0x81338837,	{ 0xE1, 0x80, 0xAF },
	0x81338838,	{ 0xE1, 0x80, 0xB0 },
	0x81338839,	{ 0xE1, 0x80, 0xB1 },
	0x81338930,	{ 0xE1, 0x80, 0xB2 },
	0x81338931,	{ 0xE1, 0x80, 0xB3 },
	0x81338932,	{ 0xE1, 0x80, 0xB4 },
	0x81338933,	{ 0xE1, 0x80, 0xB5 },
	0x81338934,	{ 0xE1, 0x80, 0xB6 },
	0x81338935,	{ 0xE1, 0x80, 0xB7 },
	0x81338936,	{ 0xE1, 0x80, 0xB8 },
	0x81338937,	{ 0xE1, 0x80, 0xB9 },
	0x81338938,	{ 0xE1, 0x80, 0xBA },
	0x81338939,	{ 0xE1, 0x80, 0xBB },
	0x81338A30,	{ 0xE1, 0x80, 0xBC },
	0x81338A31,	{ 0xE1, 0x80, 0xBD },
	0x81338A32,	{ 0xE1, 0x80, 0xBE },
	0x81338A33,	{ 0xE1, 0x80, 0xBF },
	0x81338A34,	{ 0xE1, 0x81, 0x80 },
	0x81338A35,	{ 0xE1, 0x81, 0x81 },
	0x81338A36,	{ 0xE1, 0x81, 0x82 },
	0x81338A37,	{ 0xE1, 0x81, 0x83 },
	0x81338A38,	{ 0xE1, 0x81, 0x84 },
	0x81338A39,	{ 0xE1, 0x81, 0x85 },
	0x81338B30,	{ 0xE1, 0x81, 0x86 },
	0x81338B31,	{ 0xE1, 0x81, 0x87 },
	0x81338B32,	{ 0xE1, 0x81, 0x88 },
	0x81338B33,	{ 0xE1, 0x81, 0x89 },
	0x81338B34,	{ 0xE1, 0x81, 0x8A },
	0x81338B35,	{ 0xE1, 0x81, 0x8B },
	0x81338B36,	{ 0xE1, 0x81, 0x8C },
	0x81338B37,	{ 0xE1, 0x81, 0x8D },
	0x81338B38,	{ 0xE1, 0x81, 0x8E },
	0x81338B39,	{ 0xE1, 0x81, 0x8F },
	0x81338C30,	{ 0xE1, 0x81, 0x90 },
	0x81338C31,	{ 0xE1, 0x81, 0x91 },
	0x81338C32,	{ 0xE1, 0x81, 0x92 },
	0x81338C33,	{ 0xE1, 0x81, 0x93 },
	0x81338C34,	{ 0xE1, 0x81, 0x94 },
	0x81338C35,	{ 0xE1, 0x81, 0x95 },
	0x81338C36,	{ 0xE1, 0x81, 0x96 },
	0x81338C37,	{ 0xE1, 0x81, 0x97 },
	0x81338C38,	{ 0xE1, 0x81, 0x98 },
	0x81338C39,	{ 0xE1, 0x81, 0x99 },
	0x81338D30,	{ 0xE1, 0x81, 0x9A },
	0x81338D31,	{ 0xE1, 0x81, 0x9B },
	0x81338D32,	{ 0xE1, 0x81, 0x9C },
	0x81338D33,	{ 0xE1, 0x81, 0x9D },
	0x81338D34,	{ 0xE1, 0x81, 0x9E },
	0x81338D35,	{ 0xE1, 0x81, 0x9F },
	0x81338D36,	{ 0xE1, 0x81, 0xA0 },
	0x81338D37,	{ 0xE1, 0x81, 0xA1 },
	0x81338D38,	{ 0xE1, 0x81, 0xA2 },
	0x81338D39,	{ 0xE1, 0x81, 0xA3 },
	0x81338E30,	{ 0xE1, 0x81, 0xA4 },
	0x81338E31,	{ 0xE1, 0x81, 0xA5 },
	0x81338E32,	{ 0xE1, 0x81, 0xA6 },
	0x81338E33,	{ 0xE1, 0x81, 0xA7 },
	0x81338E34,	{ 0xE1, 0x81, 0xA8 },
	0x81338E35,	{ 0xE1, 0x81, 0xA9 },
	0x81338E36,	{ 0xE1, 0x81, 0xAA },
	0x81338E37,	{ 0xE1, 0x81, 0xAB },
	0x81338E38,	{ 0xE1, 0x81, 0xAC },
	0x81338E39,	{ 0xE1, 0x81, 0xAD },
	0x81338F30,	{ 0xE1, 0x81, 0xAE },
	0x81338F31,	{ 0xE1, 0x81, 0xAF },
	0x81338F32,	{ 0xE1, 0x81, 0xB0 },
	0x81338F33,	{ 0xE1, 0x81, 0xB1 },
	0x81338F34,	{ 0xE1, 0x81, 0xB2 },
	0x81338F35,	{ 0xE1, 0x81, 0xB3 },
	0x81338F36,	{ 0xE1, 0x81, 0xB4 },
	0x81338F37,	{ 0xE1, 0x81, 0xB5 },
	0x81338F38,	{ 0xE1, 0x81, 0xB6 },
	0x81338F39,	{ 0xE1, 0x81, 0xB7 },
	0x81339030,	{ 0xE1, 0x81, 0xB8 },
	0x81339031,	{ 0xE1, 0x81, 0xB9 },
	0x81339032,	{ 0xE1, 0x81, 0xBA },
	0x81339033,	{ 0xE1, 0x81, 0xBB },
	0x81339034,	{ 0xE1, 0x81, 0xBC },
	0x81339035,	{ 0xE1, 0x81, 0xBD },
	0x81339036,	{ 0xE1, 0x81, 0xBE },
	0x81339037,	{ 0xE1, 0x81, 0xBF },
	0x81339038,	{ 0xE1, 0x82, 0x80 },
	0x81339039,	{ 0xE1, 0x82, 0x81 },
	0x81339130,	{ 0xE1, 0x82, 0x82 },
	0x81339131,	{ 0xE1, 0x82, 0x83 },
	0x81339132,	{ 0xE1, 0x82, 0x84 },
	0x81339133,	{ 0xE1, 0x82, 0x85 },
	0x81339134,	{ 0xE1, 0x82, 0x86 },
	0x81339135,	{ 0xE1, 0x82, 0x87 },
	0x81339136,	{ 0xE1, 0x82, 0x88 },
	0x81339137,	{ 0xE1, 0x82, 0x89 },
	0x81339138,	{ 0xE1, 0x82, 0x8A },
	0x81339139,	{ 0xE1, 0x82, 0x8B },
	0x81339230,	{ 0xE1, 0x82, 0x8C },
	0x81339231,	{ 0xE1, 0x82, 0x8D },
	0x81339232,	{ 0xE1, 0x82, 0x8E },
	0x81339233,	{ 0xE1, 0x82, 0x8F },
	0x81339234,	{ 0xE1, 0x82, 0x90 },
	0x81339235,	{ 0xE1, 0x82, 0x91 },
	0x81339236,	{ 0xE1, 0x82, 0x92 },
	0x81339237,	{ 0xE1, 0x82, 0x93 },
	0x81339238,	{ 0xE1, 0x82, 0x94 },
	0x81339239,	{ 0xE1, 0x82, 0x95 },
	0x81339330,	{ 0xE1, 0x82, 0x96 },
	0x81339331,	{ 0xE1, 0x82, 0x97 },
	0x81339332,	{ 0xE1, 0x82, 0x98 },
	0x81339333,	{ 0xE1, 0x82, 0x99 },
	0x81339334,	{ 0xE1, 0x82, 0x9A },
	0x81339335,	{ 0xE1, 0x82, 0x9B },
	0x81339336,	{ 0xE1, 0x82, 0x9C },
	0x81339337,	{ 0xE1, 0x82, 0x9D },
	0x81339338,	{ 0xE1, 0x82, 0x9E },
	0x81339339,	{ 0xE1, 0x82, 0x9F },
	0x81339430,	{ 0xE1, 0x82, 0xA0 },
	0x81339431,	{ 0xE1, 0x82, 0xA1 },
	0x81339432,	{ 0xE1, 0x82, 0xA2 },
	0x81339433,	{ 0xE1, 0x82, 0xA3 },
	0x81339434,	{ 0xE1, 0x82, 0xA4 },
	0x81339435,	{ 0xE1, 0x82, 0xA5 },
	0x81339436,	{ 0xE1, 0x82, 0xA6 },
	0x81339437,	{ 0xE1, 0x82, 0xA7 },
	0x81339438,	{ 0xE1, 0x82, 0xA8 },
	0x81339439,	{ 0xE1, 0x82, 0xA9 },
	0x81339530,	{ 0xE1, 0x82, 0xAA },
	0x81339531,	{ 0xE1, 0x82, 0xAB },
	0x81339532,	{ 0xE1, 0x82, 0xAC },
	0x81339533,	{ 0xE1, 0x82, 0xAD },
	0x81339534,	{ 0xE1, 0x82, 0xAE },
	0x81339535,	{ 0xE1, 0x82, 0xAF },
	0x81339536,	{ 0xE1, 0x82, 0xB0 },
	0x81339537,	{ 0xE1, 0x82, 0xB1 },
	0x81339538,	{ 0xE1, 0x82, 0xB2 },
	0x81339539,	{ 0xE1, 0x82, 0xB3 },
	0x81339630,	{ 0xE1, 0x82, 0xB4 },
	0x81339631,	{ 0xE1, 0x82, 0xB5 },
	0x81339632,	{ 0xE1, 0x82, 0xB6 },
	0x81339633,	{ 0xE1, 0x82, 0xB7 },
	0x81339634,	{ 0xE1, 0x82, 0xB8 },
	0x81339635,	{ 0xE1, 0x82, 0xB9 },
	0x81339636,	{ 0xE1, 0x82, 0xBA },
	0x81339637,	{ 0xE1, 0x82, 0xBB },
	0x81339638,	{ 0xE1, 0x82, 0xBC },
	0x81339639,	{ 0xE1, 0x82, 0xBD },
	0x81339730,	{ 0xE1, 0x82, 0xBE },
	0x81339731,	{ 0xE1, 0x82, 0xBF },
	0x81339732,	{ 0xE1, 0x83, 0x80 },
	0x81339733,	{ 0xE1, 0x83, 0x81 },
	0x81339734,	{ 0xE1, 0x83, 0x82 },
	0x81339735,	{ 0xE1, 0x83, 0x83 },
	0x81339736,	{ 0xE1, 0x83, 0x84 },
	0x81339737,	{ 0xE1, 0x83, 0x85 },
	0x81339738,	{ 0xE1, 0x83, 0x86 },
	0x81339739,	{ 0xE1, 0x83, 0x87 },
	0x81339830,	{ 0xE1, 0x83, 0x88 },
	0x81339831,	{ 0xE1, 0x83, 0x89 },
	0x81339832,	{ 0xE1, 0x83, 0x8A },
	0x81339833,	{ 0xE1, 0x83, 0x8B },
	0x81339834,	{ 0xE1, 0x83, 0x8C },
	0x81339835,	{ 0xE1, 0x83, 0x8D },
	0x81339836,	{ 0xE1, 0x83, 0x8E },
	0x81339837,	{ 0xE1, 0x83, 0x8F },
	0x81339838,	{ 0xE1, 0x83, 0x90 },
	0x81339839,	{ 0xE1, 0x83, 0x91 },
	0x81339930,	{ 0xE1, 0x83, 0x92 },
	0x81339931,	{ 0xE1, 0x83, 0x93 },
	0x81339932,	{ 0xE1, 0x83, 0x94 },
	0x81339933,	{ 0xE1, 0x83, 0x95 },
	0x81339934,	{ 0xE1, 0x83, 0x96 },
	0x81339935,	{ 0xE1, 0x83, 0x97 },
	0x81339936,	{ 0xE1, 0x83, 0x98 },
	0x81339937,	{ 0xE1, 0x83, 0x99 },
	0x81339938,	{ 0xE1, 0x83, 0x9A },
	0x81339939,	{ 0xE1, 0x83, 0x9B },
	0x81339A30,	{ 0xE1, 0x83, 0x9C },
	0x81339A31,	{ 0xE1, 0x83, 0x9D },
	0x81339A32,	{ 0xE1, 0x83, 0x9E },
	0x81339A33,	{ 0xE1, 0x83, 0x9F },
	0x81339A34,	{ 0xE1, 0x83, 0xA0 },
	0x81339A35,	{ 0xE1, 0x83, 0xA1 },
	0x81339A36,	{ 0xE1, 0x83, 0xA2 },
	0x81339A37,	{ 0xE1, 0x83, 0xA3 },
	0x81339A38,	{ 0xE1, 0x83, 0xA4 },
	0x81339A39,	{ 0xE1, 0x83, 0xA5 },
	0x81339B30,	{ 0xE1, 0x83, 0xA6 },
	0x81339B31,	{ 0xE1, 0x83, 0xA7 },
	0x81339B32,	{ 0xE1, 0x83, 0xA8 },
	0x81339B33,	{ 0xE1, 0x83, 0xA9 },
	0x81339B34,	{ 0xE1, 0x83, 0xAA },
	0x81339B35,	{ 0xE1, 0x83, 0xAB },
	0x81339B36,	{ 0xE1, 0x83, 0xAC },
	0x81339B37,	{ 0xE1, 0x83, 0xAD },
	0x81339B38,	{ 0xE1, 0x83, 0xAE },
	0x81339B39,	{ 0xE1, 0x83, 0xAF },
	0x81339C30,	{ 0xE1, 0x83, 0xB0 },
	0x81339C31,	{ 0xE1, 0x83, 0xB1 },
	0x81339C32,	{ 0xE1, 0x83, 0xB2 },
	0x81339C33,	{ 0xE1, 0x83, 0xB3 },
	0x81339C34,	{ 0xE1, 0x83, 0xB4 },
	0x81339C35,	{ 0xE1, 0x83, 0xB5 },
	0x81339C36,	{ 0xE1, 0x83, 0xB6 },
	0x81339C37,	{ 0xE1, 0x83, 0xB7 },
	0x81339C38,	{ 0xE1, 0x83, 0xB8 },
	0x81339C39,	{ 0xE1, 0x83, 0xB9 },
	0x81339D30,	{ 0xE1, 0x83, 0xBA },
	0x81339D31,	{ 0xE1, 0x83, 0xBB },
	0x81339D32,	{ 0xE1, 0x83, 0xBC },
	0x81339D33,	{ 0xE1, 0x83, 0xBD },
	0x81339D34,	{ 0xE1, 0x83, 0xBE },
	0x81339D35,	{ 0xE1, 0x83, 0xBF },
	0x81339D36,	{ 0xE1, 0x84, 0x80 },
	0x81339D37,	{ 0xE1, 0x84, 0x81 },
	0x81339D38,	{ 0xE1, 0x84, 0x82 },
	0x81339D39,	{ 0xE1, 0x84, 0x83 },
	0x81339E30,	{ 0xE1, 0x84, 0x84 },
	0x81339E31,	{ 0xE1, 0x84, 0x85 },
	0x81339E32,	{ 0xE1, 0x84, 0x86 },
	0x81339E33,	{ 0xE1, 0x84, 0x87 },
	0x81339E34,	{ 0xE1, 0x84, 0x88 },
	0x81339E35,	{ 0xE1, 0x84, 0x89 },
	0x81339E36,	{ 0xE1, 0x84, 0x8A },
	0x81339E37,	{ 0xE1, 0x84, 0x8B },
	0x81339E38,	{ 0xE1, 0x84, 0x8C },
	0x81339E39,	{ 0xE1, 0x84, 0x8D },
	0x81339F30,	{ 0xE1, 0x84, 0x8E },
	0x81339F31,	{ 0xE1, 0x84, 0x8F },
	0x81339F32,	{ 0xE1, 0x84, 0x90 },
	0x81339F33,	{ 0xE1, 0x84, 0x91 },
	0x81339F34,	{ 0xE1, 0x84, 0x92 },
	0x81339F35,	{ 0xE1, 0x84, 0x93 },
	0x81339F36,	{ 0xE1, 0x84, 0x94 },
	0x81339F37,	{ 0xE1, 0x84, 0x95 },
	0x81339F38,	{ 0xE1, 0x84, 0x96 },
	0x81339F39,	{ 0xE1, 0x84, 0x97 },
	0x8133A030,	{ 0xE1, 0x84, 0x98 },
	0x8133A031,	{ 0xE1, 0x84, 0x99 },
	0x8133A032,	{ 0xE1, 0x84, 0x9A },
	0x8133A033,	{ 0xE1, 0x84, 0x9B },
	0x8133A034,	{ 0xE1, 0x84, 0x9C },
	0x8133A035,	{ 0xE1, 0x84, 0x9D },
	0x8133A036,	{ 0xE1, 0x84, 0x9E },
	0x8133A037,	{ 0xE1, 0x84, 0x9F },
	0x8133A038,	{ 0xE1, 0x84, 0xA0 },
	0x8133A039,	{ 0xE1, 0x84, 0xA1 },
	0x8133A130,	{ 0xE1, 0x84, 0xA2 },
	0x8133A131,	{ 0xE1, 0x84, 0xA3 },
	0x8133A132,	{ 0xE1, 0x84, 0xA4 },
	0x8133A133,	{ 0xE1, 0x84, 0xA5 },
	0x8133A134,	{ 0xE1, 0x84, 0xA6 },
	0x8133A135,	{ 0xE1, 0x84, 0xA7 },
	0x8133A136,	{ 0xE1, 0x84, 0xA8 },
	0x8133A137,	{ 0xE1, 0x84, 0xA9 },
	0x8133A138,	{ 0xE1, 0x84, 0xAA },
	0x8133A139,	{ 0xE1, 0x84, 0xAB },
	0x8133A230,	{ 0xE1, 0x84, 0xAC },
	0x8133A231,	{ 0xE1, 0x84, 0xAD },
	0x8133A232,	{ 0xE1, 0x84, 0xAE },
	0x8133A233,	{ 0xE1, 0x84, 0xAF },
	0x8133A234,	{ 0xE1, 0x84, 0xB0 },
	0x8133A235,	{ 0xE1, 0x84, 0xB1 },
	0x8133A236,	{ 0xE1, 0x84, 0xB2 },
	0x8133A237,	{ 0xE1, 0x84, 0xB3 },
	0x8133A238,	{ 0xE1, 0x84, 0xB4 },
	0x8133A239,	{ 0xE1, 0x84, 0xB5 },
	0x8133A330,	{ 0xE1, 0x84, 0xB6 },
	0x8133A331,	{ 0xE1, 0x84, 0xB7 },
	0x8133A332,	{ 0xE1, 0x84, 0xB8 },
	0x8133A333,	{ 0xE1, 0x84, 0xB9 },
	0x8133A334,	{ 0xE1, 0x84, 0xBA },
	0x8133A335,	{ 0xE1, 0x84, 0xBB },
	0x8133A336,	{ 0xE1, 0x84, 0xBC },
	0x8133A337,	{ 0xE1, 0x84, 0xBD },
	0x8133A338,	{ 0xE1, 0x84, 0xBE },
	0x8133A339,	{ 0xE1, 0x84, 0xBF },
	0x8133A430,	{ 0xE1, 0x85, 0x80 },
	0x8133A431,	{ 0xE1, 0x85, 0x81 },
	0x8133A432,	{ 0xE1, 0x85, 0x82 },
	0x8133A433,	{ 0xE1, 0x85, 0x83 },
	0x8133A434,	{ 0xE1, 0x85, 0x84 },
	0x8133A435,	{ 0xE1, 0x85, 0x85 },
	0x8133A436,	{ 0xE1, 0x85, 0x86 },
	0x8133A437,	{ 0xE1, 0x85, 0x87 },
	0x8133A438,	{ 0xE1, 0x85, 0x88 },
	0x8133A439,	{ 0xE1, 0x85, 0x89 },
	0x8133A530,	{ 0xE1, 0x85, 0x8A },
	0x8133A531,	{ 0xE1, 0x85, 0x8B },
	0x8133A532,	{ 0xE1, 0x85, 0x8C },
	0x8133A533,	{ 0xE1, 0x85, 0x8D },
	0x8133A534,	{ 0xE1, 0x85, 0x8E },
	0x8133A535,	{ 0xE1, 0x85, 0x8F },
	0x8133A536,	{ 0xE1, 0x85, 0x90 },
	0x8133A537,	{ 0xE1, 0x85, 0x91 },
	0x8133A538,	{ 0xE1, 0x85, 0x92 },
	0x8133A539,	{ 0xE1, 0x85, 0x93 },
	0x8133A630,	{ 0xE1, 0x85, 0x94 },
	0x8133A631,	{ 0xE1, 0x85, 0x95 },
	0x8133A632,	{ 0xE1, 0x85, 0x96 },
	0x8133A633,	{ 0xE1, 0x85, 0x97 },
	0x8133A634,	{ 0xE1, 0x85, 0x98 },
	0x8133A635,	{ 0xE1, 0x85, 0x99 },
	0x8133A636,	{ 0xE1, 0x85, 0x9A },
	0x8133A637,	{ 0xE1, 0x85, 0x9B },
	0x8133A638,	{ 0xE1, 0x85, 0x9C },
	0x8133A639,	{ 0xE1, 0x85, 0x9D },
	0x8133A730,	{ 0xE1, 0x85, 0x9E },
	0x8133A731,	{ 0xE1, 0x85, 0x9F },
	0x8133A732,	{ 0xE1, 0x85, 0xA0 },
	0x8133A733,	{ 0xE1, 0x85, 0xA1 },
	0x8133A734,	{ 0xE1, 0x85, 0xA2 },
	0x8133A735,	{ 0xE1, 0x85, 0xA3 },
	0x8133A736,	{ 0xE1, 0x85, 0xA4 },
	0x8133A737,	{ 0xE1, 0x85, 0xA5 },
	0x8133A738,	{ 0xE1, 0x85, 0xA6 },
	0x8133A739,	{ 0xE1, 0x85, 0xA7 },
	0x8133A830,	{ 0xE1, 0x85, 0xA8 },
	0x8133A831,	{ 0xE1, 0x85, 0xA9 },
	0x8133A832,	{ 0xE1, 0x85, 0xAA },
	0x8133A833,	{ 0xE1, 0x85, 0xAB },
	0x8133A834,	{ 0xE1, 0x85, 0xAC },
	0x8133A835,	{ 0xE1, 0x85, 0xAD },
	0x8133A836,	{ 0xE1, 0x85, 0xAE },
	0x8133A837,	{ 0xE1, 0x85, 0xAF },
	0x8133A838,	{ 0xE1, 0x85, 0xB0 },
	0x8133A839,	{ 0xE1, 0x85, 0xB1 },
	0x8133A930,	{ 0xE1, 0x85, 0xB2 },
	0x8133A931,	{ 0xE1, 0x85, 0xB3 },
	0x8133A932,	{ 0xE1, 0x85, 0xB4 },
	0x8133A933,	{ 0xE1, 0x85, 0xB5 },
	0x8133A934,	{ 0xE1, 0x85, 0xB6 },
	0x8133A935,	{ 0xE1, 0x85, 0xB7 },
	0x8133A936,	{ 0xE1, 0x85, 0xB8 },
	0x8133A937,	{ 0xE1, 0x85, 0xB9 },
	0x8133A938,	{ 0xE1, 0x85, 0xBA },
	0x8133A939,	{ 0xE1, 0x85, 0xBB },
	0x8133AA30,	{ 0xE1, 0x85, 0xBC },
	0x8133AA31,	{ 0xE1, 0x85, 0xBD },
	0x8133AA32,	{ 0xE1, 0x85, 0xBE },
	0x8133AA33,	{ 0xE1, 0x85, 0xBF },
	0x8133AA34,	{ 0xE1, 0x86, 0x80 },
	0x8133AA35,	{ 0xE1, 0x86, 0x81 },
	0x8133AA36,	{ 0xE1, 0x86, 0x82 },
	0x8133AA37,	{ 0xE1, 0x86, 0x83 },
	0x8133AA38,	{ 0xE1, 0x86, 0x84 },
	0x8133AA39,	{ 0xE1, 0x86, 0x85 },
	0x8133AB30,	{ 0xE1, 0x86, 0x86 },
	0x8133AB31,	{ 0xE1, 0x86, 0x87 },
	0x8133AB32,	{ 0xE1, 0x86, 0x88 },
	0x8133AB33,	{ 0xE1, 0x86, 0x89 },
	0x8133AB34,	{ 0xE1, 0x86, 0x8A },
	0x8133AB35,	{ 0xE1, 0x86, 0x8B },
	0x8133AB36,	{ 0xE1, 0x86, 0x8C },
	0x8133AB37,	{ 0xE1, 0x86, 0x8D },
	0x8133AB38,	{ 0xE1, 0x86, 0x8E },
	0x8133AB39,	{ 0xE1, 0x86, 0x8F },
	0x8133AC30,	{ 0xE1, 0x86, 0x90 },
	0x8133AC31,	{ 0xE1, 0x86, 0x91 },
	0x8133AC32,	{ 0xE1, 0x86, 0x92 },
	0x8133AC33,	{ 0xE1, 0x86, 0x93 },
	0x8133AC34,	{ 0xE1, 0x86, 0x94 },
	0x8133AC35,	{ 0xE1, 0x86, 0x95 },
	0x8133AC36,	{ 0xE1, 0x86, 0x96 },
	0x8133AC37,	{ 0xE1, 0x86, 0x97 },
	0x8133AC38,	{ 0xE1, 0x86, 0x98 },
	0x8133AC39,	{ 0xE1, 0x86, 0x99 },
	0x8133AD30,	{ 0xE1, 0x86, 0x9A },
	0x8133AD31,	{ 0xE1, 0x86, 0x9B },
	0x8133AD32,	{ 0xE1, 0x86, 0x9C },
	0x8133AD33,	{ 0xE1, 0x86, 0x9D },
	0x8133AD34,	{ 0xE1, 0x86, 0x9E },
	0x8133AD35,	{ 0xE1, 0x86, 0x9F },
	0x8133AD36,	{ 0xE1, 0x86, 0xA0 },
	0x8133AD37,	{ 0xE1, 0x86, 0xA1 },
	0x8133AD38,	{ 0xE1, 0x86, 0xA2 },
	0x8133AD39,	{ 0xE1, 0x86, 0xA3 },
	0x8133AE30,	{ 0xE1, 0x86, 0xA4 },
	0x8133AE31,	{ 0xE1, 0x86, 0xA5 },
	0x8133AE32,	{ 0xE1, 0x86, 0xA6 },
	0x8133AE33,	{ 0xE1, 0x86, 0xA7 },
	0x8133AE34,	{ 0xE1, 0x86, 0xA8 },
	0x8133AE35,	{ 0xE1, 0x86, 0xA9 },
	0x8133AE36,	{ 0xE1, 0x86, 0xAA },
	0x8133AE37,	{ 0xE1, 0x86, 0xAB },
	0x8133AE38,	{ 0xE1, 0x86, 0xAC },
	0x8133AE39,	{ 0xE1, 0x86, 0xAD },
	0x8133AF30,	{ 0xE1, 0x86, 0xAE },
	0x8133AF31,	{ 0xE1, 0x86, 0xAF },
	0x8133AF32,	{ 0xE1, 0x86, 0xB0 },
	0x8133AF33,	{ 0xE1, 0x86, 0xB1 },
	0x8133AF34,	{ 0xE1, 0x86, 0xB2 },
	0x8133AF35,	{ 0xE1, 0x86, 0xB3 },
	0x8133AF36,	{ 0xE1, 0x86, 0xB4 },
	0x8133AF37,	{ 0xE1, 0x86, 0xB5 },
	0x8133AF38,	{ 0xE1, 0x86, 0xB6 },
	0x8133AF39,	{ 0xE1, 0x86, 0xB7 },
	0x8133B030,	{ 0xE1, 0x86, 0xB8 },
	0x8133B031,	{ 0xE1, 0x86, 0xB9 },
	0x8133B032,	{ 0xE1, 0x86, 0xBA },
	0x8133B033,	{ 0xE1, 0x86, 0xBB },
	0x8133B034,	{ 0xE1, 0x86, 0xBC },
	0x8133B035,	{ 0xE1, 0x86, 0xBD },
	0x8133B036,	{ 0xE1, 0x86, 0xBE },
	0x8133B037,	{ 0xE1, 0x86, 0xBF },
	0x8133B038,	{ 0xE1, 0x87, 0x80 },
	0x8133B039,	{ 0xE1, 0x87, 0x81 },
	0x8133B130,	{ 0xE1, 0x87, 0x82 },
	0x8133B131,	{ 0xE1, 0x87, 0x83 },
	0x8133B132,	{ 0xE1, 0x87, 0x84 },
	0x8133B133,	{ 0xE1, 0x87, 0x85 },
	0x8133B134,	{ 0xE1, 0x87, 0x86 },
	0x8133B135,	{ 0xE1, 0x87, 0x87 },
	0x8133B136,	{ 0xE1, 0x87, 0x88 },
	0x8133B137,	{ 0xE1, 0x87, 0x89 },
	0x8133B138,	{ 0xE1, 0x87, 0x8A },
	0x8133B139,	{ 0xE1, 0x87, 0x8B },
	0x8133B230,	{ 0xE1, 0x87, 0x8C },
	0x8133B231,	{ 0xE1, 0x87, 0x8D },
	0x8133B232,	{ 0xE1, 0x87, 0x8E },
	0x8133B233,	{ 0xE1, 0x87, 0x8F },
	0x8133B234,	{ 0xE1, 0x87, 0x90 },
	0x8133B235,	{ 0xE1, 0x87, 0x91 },
	0x8133B236,	{ 0xE1, 0x87, 0x92 },
	0x8133B237,	{ 0xE1, 0x87, 0x93 },
	0x8133B238,	{ 0xE1, 0x87, 0x94 },
	0x8133B239,	{ 0xE1, 0x87, 0x95 },
	0x8133B330,	{ 0xE1, 0x87, 0x96 },
	0x8133B331,	{ 0xE1, 0x87, 0x97 },
	0x8133B332,	{ 0xE1, 0x87, 0x98 },
	0x8133B333,	{ 0xE1, 0x87, 0x99 },
	0x8133B334,	{ 0xE1, 0x87, 0x9A },
	0x8133B335,	{ 0xE1, 0x87, 0x9B },
	0x8133B336,	{ 0xE1, 0x87, 0x9C },
	0x8133B337,	{ 0xE1, 0x87, 0x9D },
	0x8133B338,	{ 0xE1, 0x87, 0x9E },
	0x8133B339,	{ 0xE1, 0x87, 0x9F },
	0x8133B430,	{ 0xE1, 0x87, 0xA0 },
	0x8133B431,	{ 0xE1, 0x87, 0xA1 },
	0x8133B432,	{ 0xE1, 0x87, 0xA2 },
	0x8133B433,	{ 0xE1, 0x87, 0xA3 },
	0x8133B434,	{ 0xE1, 0x87, 0xA4 },
	0x8133B435,	{ 0xE1, 0x87, 0xA5 },
	0x8133B436,	{ 0xE1, 0x87, 0xA6 },
	0x8133B437,	{ 0xE1, 0x87, 0xA7 },
	0x8133B438,	{ 0xE1, 0x87, 0xA8 },
	0x8133B439,	{ 0xE1, 0x87, 0xA9 },
	0x8133B530,	{ 0xE1, 0x87, 0xAA },
	0x8133B531,	{ 0xE1, 0x87, 0xAB },
	0x8133B532,	{ 0xE1, 0x87, 0xAC },
	0x8133B533,	{ 0xE1, 0x87, 0xAD },
	0x8133B534,	{ 0xE1, 0x87, 0xAE },
	0x8133B535,	{ 0xE1, 0x87, 0xAF },
	0x8133B536,	{ 0xE1, 0x87, 0xB0 },
	0x8133B537,	{ 0xE1, 0x87, 0xB1 },
	0x8133B538,	{ 0xE1, 0x87, 0xB2 },
	0x8133B539,	{ 0xE1, 0x87, 0xB3 },
	0x8133B630,	{ 0xE1, 0x87, 0xB4 },
	0x8133B631,	{ 0xE1, 0x87, 0xB5 },
	0x8133B632,	{ 0xE1, 0x87, 0xB6 },
	0x8133B633,	{ 0xE1, 0x87, 0xB7 },
	0x8133B634,	{ 0xE1, 0x87, 0xB8 },
	0x8133B635,	{ 0xE1, 0x87, 0xB9 },
	0x8133B636,	{ 0xE1, 0x87, 0xBA },
	0x8133B637,	{ 0xE1, 0x87, 0xBB },
	0x8133B638,	{ 0xE1, 0x87, 0xBC },
	0x8133B639,	{ 0xE1, 0x87, 0xBD },
	0x8133B730,	{ 0xE1, 0x87, 0xBE },
	0x8133B731,	{ 0xE1, 0x87, 0xBF },
	0x8133B732,	{ 0xE1, 0x88, 0x80 },
	0x8133B733,	{ 0xE1, 0x88, 0x81 },
	0x8133B734,	{ 0xE1, 0x88, 0x82 },
	0x8133B735,	{ 0xE1, 0x88, 0x83 },
	0x8133B736,	{ 0xE1, 0x88, 0x84 },
	0x8133B737,	{ 0xE1, 0x88, 0x85 },
	0x8133B738,	{ 0xE1, 0x88, 0x86 },
	0x8133B739,	{ 0xE1, 0x88, 0x87 },
	0x8133B830,	{ 0xE1, 0x88, 0x88 },
	0x8133B831,	{ 0xE1, 0x88, 0x89 },
	0x8133B832,	{ 0xE1, 0x88, 0x8A },
	0x8133B833,	{ 0xE1, 0x88, 0x8B },
	0x8133B834,	{ 0xE1, 0x88, 0x8C },
	0x8133B835,	{ 0xE1, 0x88, 0x8D },
	0x8133B836,	{ 0xE1, 0x88, 0x8E },
	0x8133B837,	{ 0xE1, 0x88, 0x8F },
	0x8133B838,	{ 0xE1, 0x88, 0x90 },
	0x8133B839,	{ 0xE1, 0x88, 0x91 },
	0x8133B930,	{ 0xE1, 0x88, 0x92 },
	0x8133B931,	{ 0xE1, 0x88, 0x93 },
	0x8133B932,	{ 0xE1, 0x88, 0x94 },
	0x8133B933,	{ 0xE1, 0x88, 0x95 },
	0x8133B934,	{ 0xE1, 0x88, 0x96 },
	0x8133B935,	{ 0xE1, 0x88, 0x97 },
	0x8133B936,	{ 0xE1, 0x88, 0x98 },
	0x8133B937,	{ 0xE1, 0x88, 0x99 },
	0x8133B938,	{ 0xE1, 0x88, 0x9A },
	0x8133B939,	{ 0xE1, 0x88, 0x9B },
	0x8133BA30,	{ 0xE1, 0x88, 0x9C },
	0x8133BA31,	{ 0xE1, 0x88, 0x9D },
	0x8133BA32,	{ 0xE1, 0x88, 0x9E },
	0x8133BA33,	{ 0xE1, 0x88, 0x9F },
	0x8133BA34,	{ 0xE1, 0x88, 0xA0 },
	0x8133BA35,	{ 0xE1, 0x88, 0xA1 },
	0x8133BA36,	{ 0xE1, 0x88, 0xA2 },
	0x8133BA37,	{ 0xE1, 0x88, 0xA3 },
	0x8133BA38,	{ 0xE1, 0x88, 0xA4 },
	0x8133BA39,	{ 0xE1, 0x88, 0xA5 },
	0x8133BB30,	{ 0xE1, 0x88, 0xA6 },
	0x8133BB31,	{ 0xE1, 0x88, 0xA7 },
	0x8133BB32,	{ 0xE1, 0x88, 0xA8 },
	0x8133BB33,	{ 0xE1, 0x88, 0xA9 },
	0x8133BB34,	{ 0xE1, 0x88, 0xAA },
	0x8133BB35,	{ 0xE1, 0x88, 0xAB },
	0x8133BB36,	{ 0xE1, 0x88, 0xAC },
	0x8133BB37,	{ 0xE1, 0x88, 0xAD },
	0x8133BB38,	{ 0xE1, 0x88, 0xAE },
	0x8133BB39,	{ 0xE1, 0x88, 0xAF },
	0x8133BC30,	{ 0xE1, 0x88, 0xB0 },
	0x8133BC31,	{ 0xE1, 0x88, 0xB1 },
	0x8133BC32,	{ 0xE1, 0x88, 0xB2 },
	0x8133BC33,	{ 0xE1, 0x88, 0xB3 },
	0x8133BC34,	{ 0xE1, 0x88, 0xB4 },
	0x8133BC35,	{ 0xE1, 0x88, 0xB5 },
	0x8133BC36,	{ 0xE1, 0x88, 0xB6 },
	0x8133BC37,	{ 0xE1, 0x88, 0xB7 },
	0x8133BC38,	{ 0xE1, 0x88, 0xB8 },
	0x8133BC39,	{ 0xE1, 0x88, 0xB9 },
	0x8133BD30,	{ 0xE1, 0x88, 0xBA },
	0x8133BD31,	{ 0xE1, 0x88, 0xBB },
	0x8133BD32,	{ 0xE1, 0x88, 0xBC },
	0x8133BD33,	{ 0xE1, 0x88, 0xBD },
	0x8133BD34,	{ 0xE1, 0x88, 0xBE },
	0x8133BD35,	{ 0xE1, 0x88, 0xBF },
	0x8133BD36,	{ 0xE1, 0x89, 0x80 },
	0x8133BD37,	{ 0xE1, 0x89, 0x81 },
	0x8133BD38,	{ 0xE1, 0x89, 0x82 },
	0x8133BD39,	{ 0xE1, 0x89, 0x83 },
	0x8133BE30,	{ 0xE1, 0x89, 0x84 },
	0x8133BE31,	{ 0xE1, 0x89, 0x85 },
	0x8133BE32,	{ 0xE1, 0x89, 0x86 },
	0x8133BE33,	{ 0xE1, 0x89, 0x87 },
	0x8133BE34,	{ 0xE1, 0x89, 0x88 },
	0x8133BE35,	{ 0xE1, 0x89, 0x89 },
	0x8133BE36,	{ 0xE1, 0x89, 0x8A },
	0x8133BE37,	{ 0xE1, 0x89, 0x8B },
	0x8133BE38,	{ 0xE1, 0x89, 0x8C },
	0x8133BE39,	{ 0xE1, 0x89, 0x8D },
	0x8133BF30,	{ 0xE1, 0x89, 0x8E },
	0x8133BF31,	{ 0xE1, 0x89, 0x8F },
	0x8133BF32,	{ 0xE1, 0x89, 0x90 },
	0x8133BF33,	{ 0xE1, 0x89, 0x91 },
	0x8133BF34,	{ 0xE1, 0x89, 0x92 },
	0x8133BF35,	{ 0xE1, 0x89, 0x93 },
	0x8133BF36,	{ 0xE1, 0x89, 0x94 },
	0x8133BF37,	{ 0xE1, 0x89, 0x95 },
	0x8133BF38,	{ 0xE1, 0x89, 0x96 },
	0x8133BF39,	{ 0xE1, 0x89, 0x97 },
	0x8133C030,	{ 0xE1, 0x89, 0x98 },
	0x8133C031,	{ 0xE1, 0x89, 0x99 },
	0x8133C032,	{ 0xE1, 0x89, 0x9A },
	0x8133C033,	{ 0xE1, 0x89, 0x9B },
	0x8133C034,	{ 0xE1, 0x89, 0x9C },
	0x8133C035,	{ 0xE1, 0x89, 0x9D },
	0x8133C036,	{ 0xE1, 0x89, 0x9E },
	0x8133C037,	{ 0xE1, 0x89, 0x9F },
	0x8133C038,	{ 0xE1, 0x89, 0xA0 },
	0x8133C039,	{ 0xE1, 0x89, 0xA1 },
	0x8133C130,	{ 0xE1, 0x89, 0xA2 },
	0x8133C131,	{ 0xE1, 0x89, 0xA3 },
	0x8133C132,	{ 0xE1, 0x89, 0xA4 },
	0x8133C133,	{ 0xE1, 0x89, 0xA5 },
	0x8133C134,	{ 0xE1, 0x89, 0xA6 },
	0x8133C135,	{ 0xE1, 0x89, 0xA7 },
	0x8133C136,	{ 0xE1, 0x89, 0xA8 },
	0x8133C137,	{ 0xE1, 0x89, 0xA9 },
	0x8133C138,	{ 0xE1, 0x89, 0xAA },
	0x8133C139,	{ 0xE1, 0x89, 0xAB },
	0x8133C230,	{ 0xE1, 0x89, 0xAC },
	0x8133C231,	{ 0xE1, 0x89, 0xAD },
	0x8133C232,	{ 0xE1, 0x89, 0xAE },
	0x8133C233,	{ 0xE1, 0x89, 0xAF },
	0x8133C234,	{ 0xE1, 0x89, 0xB0 },
	0x8133C235,	{ 0xE1, 0x89, 0xB1 },
	0x8133C236,	{ 0xE1, 0x89, 0xB2 },
	0x8133C237,	{ 0xE1, 0x89, 0xB3 },
	0x8133C238,	{ 0xE1, 0x89, 0xB4 },
	0x8133C239,	{ 0xE1, 0x89, 0xB5 },
	0x8133C330,	{ 0xE1, 0x89, 0xB6 },
	0x8133C331,	{ 0xE1, 0x89, 0xB7 },
	0x8133C332,	{ 0xE1, 0x89, 0xB8 },
	0x8133C333,	{ 0xE1, 0x89, 0xB9 },
	0x8133C334,	{ 0xE1, 0x89, 0xBA },
	0x8133C335,	{ 0xE1, 0x89, 0xBB },
	0x8133C336,	{ 0xE1, 0x89, 0xBC },
	0x8133C337,	{ 0xE1, 0x89, 0xBD },
	0x8133C338,	{ 0xE1, 0x89, 0xBE },
	0x8133C339,	{ 0xE1, 0x89, 0xBF },
	0x8133C430,	{ 0xE1, 0x8A, 0x80 },
	0x8133C431,	{ 0xE1, 0x8A, 0x81 },
	0x8133C432,	{ 0xE1, 0x8A, 0x82 },
	0x8133C433,	{ 0xE1, 0x8A, 0x83 },
	0x8133C434,	{ 0xE1, 0x8A, 0x84 },
	0x8133C435,	{ 0xE1, 0x8A, 0x85 },
	0x8133C436,	{ 0xE1, 0x8A, 0x86 },
	0x8133C437,	{ 0xE1, 0x8A, 0x87 },
	0x8133C438,	{ 0xE1, 0x8A, 0x88 },
	0x8133C439,	{ 0xE1, 0x8A, 0x89 },
	0x8133C530,	{ 0xE1, 0x8A, 0x8A },
	0x8133C531,	{ 0xE1, 0x8A, 0x8B },
	0x8133C532,	{ 0xE1, 0x8A, 0x8C },
	0x8133C533,	{ 0xE1, 0x8A, 0x8D },
	0x8133C534,	{ 0xE1, 0x8A, 0x8E },
	0x8133C535,	{ 0xE1, 0x8A, 0x8F },
	0x8133C536,	{ 0xE1, 0x8A, 0x90 },
	0x8133C537,	{ 0xE1, 0x8A, 0x91 },
	0x8133C538,	{ 0xE1, 0x8A, 0x92 },
	0x8133C539,	{ 0xE1, 0x8A, 0x93 },
	0x8133C630,	{ 0xE1, 0x8A, 0x94 },
	0x8133C631,	{ 0xE1, 0x8A, 0x95 },
	0x8133C632,	{ 0xE1, 0x8A, 0x96 },
	0x8133C633,	{ 0xE1, 0x8A, 0x97 },
	0x8133C634,	{ 0xE1, 0x8A, 0x98 },
	0x8133C635,	{ 0xE1, 0x8A, 0x99 },
	0x8133C636,	{ 0xE1, 0x8A, 0x9A },
	0x8133C637,	{ 0xE1, 0x8A, 0x9B },
	0x8133C638,	{ 0xE1, 0x8A, 0x9C },
	0x8133C639,	{ 0xE1, 0x8A, 0x9D },
	0x8133C730,	{ 0xE1, 0x8A, 0x9E },
	0x8133C731,	{ 0xE1, 0x8A, 0x9F },
	0x8133C732,	{ 0xE1, 0x8A, 0xA0 },
	0x8133C733,	{ 0xE1, 0x8A, 0xA1 },
	0x8133C734,	{ 0xE1, 0x8A, 0xA2 },
	0x8133C735,	{ 0xE1, 0x8A, 0xA3 },
	0x8133C736,	{ 0xE1, 0x8A, 0xA4 },
	0x8133C737,	{ 0xE1, 0x8A, 0xA5 },
	0x8133C738,	{ 0xE1, 0x8A, 0xA6 },
	0x8133C739,	{ 0xE1, 0x8A, 0xA7 },
	0x8133C830,	{ 0xE1, 0x8A, 0xA8 },
	0x8133C831,	{ 0xE1, 0x8A, 0xA9 },
	0x8133C832,	{ 0xE1, 0x8A, 0xAA },
	0x8133C833,	{ 0xE1, 0x8A, 0xAB },
	0x8133C834,	{ 0xE1, 0x8A, 0xAC },
	0x8133C835,	{ 0xE1, 0x8A, 0xAD },
	0x8133C836,	{ 0xE1, 0x8A, 0xAE },
	0x8133C837,	{ 0xE1, 0x8A, 0xAF },
	0x8133C838,	{ 0xE1, 0x8A, 0xB0 },
	0x8133C839,	{ 0xE1, 0x8A, 0xB1 },
	0x8133C930,	{ 0xE1, 0x8A, 0xB2 },
	0x8133C931,	{ 0xE1, 0x8A, 0xB3 },
	0x8133C932,	{ 0xE1, 0x8A, 0xB4 },
	0x8133C933,	{ 0xE1, 0x8A, 0xB5 },
	0x8133C934,	{ 0xE1, 0x8A, 0xB6 },
	0x8133C935,	{ 0xE1, 0x8A, 0xB7 },
	0x8133C936,	{ 0xE1, 0x8A, 0xB8 },
	0x8133C937,	{ 0xE1, 0x8A, 0xB9 },
	0x8133C938,	{ 0xE1, 0x8A, 0xBA },
	0x8133C939,	{ 0xE1, 0x8A, 0xBB },
	0x8133CA30,	{ 0xE1, 0x8A, 0xBC },
	0x8133CA31,	{ 0xE1, 0x8A, 0xBD },
	0x8133CA32,	{ 0xE1, 0x8A, 0xBE },
	0x8133CA33,	{ 0xE1, 0x8A, 0xBF },
	0x8133CA34,	{ 0xE1, 0x8B, 0x80 },
	0x8133CA35,	{ 0xE1, 0x8B, 0x81 },
	0x8133CA36,	{ 0xE1, 0x8B, 0x82 },
	0x8133CA37,	{ 0xE1, 0x8B, 0x83 },
	0x8133CA38,	{ 0xE1, 0x8B, 0x84 },
	0x8133CA39,	{ 0xE1, 0x8B, 0x85 },
	0x8133CB30,	{ 0xE1, 0x8B, 0x86 },
	0x8133CB31,	{ 0xE1, 0x8B, 0x87 },
	0x8133CB32,	{ 0xE1, 0x8B, 0x88 },
	0x8133CB33,	{ 0xE1, 0x8B, 0x89 },
	0x8133CB34,	{ 0xE1, 0x8B, 0x8A },
	0x8133CB35,	{ 0xE1, 0x8B, 0x8B },
	0x8133CB36,	{ 0xE1, 0x8B, 0x8C },
	0x8133CB37,	{ 0xE1, 0x8B, 0x8D },
	0x8133CB38,	{ 0xE1, 0x8B, 0x8E },
	0x8133CB39,	{ 0xE1, 0x8B, 0x8F },
	0x8133CC30,	{ 0xE1, 0x8B, 0x90 },
	0x8133CC31,	{ 0xE1, 0x8B, 0x91 },
	0x8133CC32,	{ 0xE1, 0x8B, 0x92 },
	0x8133CC33,	{ 0xE1, 0x8B, 0x93 },
	0x8133CC34,	{ 0xE1, 0x8B, 0x94 },
	0x8133CC35,	{ 0xE1, 0x8B, 0x95 },
	0x8133CC36,	{ 0xE1, 0x8B, 0x96 },
	0x8133CC37,	{ 0xE1, 0x8B, 0x97 },
	0x8133CC38,	{ 0xE1, 0x8B, 0x98 },
	0x8133CC39,	{ 0xE1, 0x8B, 0x99 },
	0x8133CD30,	{ 0xE1, 0x8B, 0x9A },
	0x8133CD31,	{ 0xE1, 0x8B, 0x9B },
	0x8133CD32,	{ 0xE1, 0x8B, 0x9C },
	0x8133CD33,	{ 0xE1, 0x8B, 0x9D },
	0x8133CD34,	{ 0xE1, 0x8B, 0x9E },
	0x8133CD35,	{ 0xE1, 0x8B, 0x9F },
	0x8133CD36,	{ 0xE1, 0x8B, 0xA0 },
	0x8133CD37,	{ 0xE1, 0x8B, 0xA1 },
	0x8133CD38,	{ 0xE1, 0x8B, 0xA2 },
	0x8133CD39,	{ 0xE1, 0x8B, 0xA3 },
	0x8133CE30,	{ 0xE1, 0x8B, 0xA4 },
	0x8133CE31,	{ 0xE1, 0x8B, 0xA5 },
	0x8133CE32,	{ 0xE1, 0x8B, 0xA6 },
	0x8133CE33,	{ 0xE1, 0x8B, 0xA7 },
	0x8133CE34,	{ 0xE1, 0x8B, 0xA8 },
	0x8133CE35,	{ 0xE1, 0x8B, 0xA9 },
	0x8133CE36,	{ 0xE1, 0x8B, 0xAA },
	0x8133CE37,	{ 0xE1, 0x8B, 0xAB },
	0x8133CE38,	{ 0xE1, 0x8B, 0xAC },
	0x8133CE39,	{ 0xE1, 0x8B, 0xAD },
	0x8133CF30,	{ 0xE1, 0x8B, 0xAE },
	0x8133CF31,	{ 0xE1, 0x8B, 0xAF },
	0x8133CF32,	{ 0xE1, 0x8B, 0xB0 },
	0x8133CF33,	{ 0xE1, 0x8B, 0xB1 },
	0x8133CF34,	{ 0xE1, 0x8B, 0xB2 },
	0x8133CF35,	{ 0xE1, 0x8B, 0xB3 },
	0x8133CF36,	{ 0xE1, 0x8B, 0xB4 },
	0x8133CF37,	{ 0xE1, 0x8B, 0xB5 },
	0x8133CF38,	{ 0xE1, 0x8B, 0xB6 },
	0x8133CF39,	{ 0xE1, 0x8B, 0xB7 },
	0x8133D030,	{ 0xE1, 0x8B, 0xB8 },
	0x8133D031,	{ 0xE1, 0x8B, 0xB9 },
	0x8133D032,	{ 0xE1, 0x8B, 0xBA },
	0x8133D033,	{ 0xE1, 0x8B, 0xBB },
	0x8133D034,	{ 0xE1, 0x8B, 0xBC },
	0x8133D035,	{ 0xE1, 0x8B, 0xBD },
	0x8133D036,	{ 0xE1, 0x8B, 0xBE },
	0x8133D037,	{ 0xE1, 0x8B, 0xBF },
	0x8133D038,	{ 0xE1, 0x8C, 0x80 },
	0x8133D039,	{ 0xE1, 0x8C, 0x81 },
	0x8133D130,	{ 0xE1, 0x8C, 0x82 },
	0x8133D131,	{ 0xE1, 0x8C, 0x83 },
	0x8133D132,	{ 0xE1, 0x8C, 0x84 },
	0x8133D133,	{ 0xE1, 0x8C, 0x85 },
	0x8133D134,	{ 0xE1, 0x8C, 0x86 },
	0x8133D135,	{ 0xE1, 0x8C, 0x87 },
	0x8133D136,	{ 0xE1, 0x8C, 0x88 },
	0x8133D137,	{ 0xE1, 0x8C, 0x89 },
	0x8133D138,	{ 0xE1, 0x8C, 0x8A },
	0x8133D139,	{ 0xE1, 0x8C, 0x8B },
	0x8133D230,	{ 0xE1, 0x8C, 0x8C },
	0x8133D231,	{ 0xE1, 0x8C, 0x8D },
	0x8133D232,	{ 0xE1, 0x8C, 0x8E },
	0x8133D233,	{ 0xE1, 0x8C, 0x8F },
	0x8133D234,	{ 0xE1, 0x8C, 0x90 },
	0x8133D235,	{ 0xE1, 0x8C, 0x91 },
	0x8133D236,	{ 0xE1, 0x8C, 0x92 },
	0x8133D237,	{ 0xE1, 0x8C, 0x93 },
	0x8133D238,	{ 0xE1, 0x8C, 0x94 },
	0x8133D239,	{ 0xE1, 0x8C, 0x95 },
	0x8133D330,	{ 0xE1, 0x8C, 0x96 },
	0x8133D331,	{ 0xE1, 0x8C, 0x97 },
	0x8133D332,	{ 0xE1, 0x8C, 0x98 },
	0x8133D333,	{ 0xE1, 0x8C, 0x99 },
	0x8133D334,	{ 0xE1, 0x8C, 0x9A },
	0x8133D335,	{ 0xE1, 0x8C, 0x9B },
	0x8133D336,	{ 0xE1, 0x8C, 0x9C },
	0x8133D337,	{ 0xE1, 0x8C, 0x9D },
	0x8133D338,	{ 0xE1, 0x8C, 0x9E },
	0x8133D339,	{ 0xE1, 0x8C, 0x9F },
	0x8133D430,	{ 0xE1, 0x8C, 0xA0 },
	0x8133D431,	{ 0xE1, 0x8C, 0xA1 },
	0x8133D432,	{ 0xE1, 0x8C, 0xA2 },
	0x8133D433,	{ 0xE1, 0x8C, 0xA3 },
	0x8133D434,	{ 0xE1, 0x8C, 0xA4 },
	0x8133D435,	{ 0xE1, 0x8C, 0xA5 },
	0x8133D436,	{ 0xE1, 0x8C, 0xA6 },
	0x8133D437,	{ 0xE1, 0x8C, 0xA7 },
	0x8133D438,	{ 0xE1, 0x8C, 0xA8 },
	0x8133D439,	{ 0xE1, 0x8C, 0xA9 },
	0x8133D530,	{ 0xE1, 0x8C, 0xAA },
	0x8133D531,	{ 0xE1, 0x8C, 0xAB },
	0x8133D532,	{ 0xE1, 0x8C, 0xAC },
	0x8133D533,	{ 0xE1, 0x8C, 0xAD },
	0x8133D534,	{ 0xE1, 0x8C, 0xAE },
	0x8133D535,	{ 0xE1, 0x8C, 0xAF },
	0x8133D536,	{ 0xE1, 0x8C, 0xB0 },
	0x8133D537,	{ 0xE1, 0x8C, 0xB1 },
	0x8133D538,	{ 0xE1, 0x8C, 0xB2 },
	0x8133D539,	{ 0xE1, 0x8C, 0xB3 },
	0x8133D630,	{ 0xE1, 0x8C, 0xB4 },
	0x8133D631,	{ 0xE1, 0x8C, 0xB5 },
	0x8133D632,	{ 0xE1, 0x8C, 0xB6 },
	0x8133D633,	{ 0xE1, 0x8C, 0xB7 },
	0x8133D634,	{ 0xE1, 0x8C, 0xB8 },
	0x8133D635,	{ 0xE1, 0x8C, 0xB9 },
	0x8133D636,	{ 0xE1, 0x8C, 0xBA },
	0x8133D637,	{ 0xE1, 0x8C, 0xBB },
	0x8133D638,	{ 0xE1, 0x8C, 0xBC },
	0x8133D639,	{ 0xE1, 0x8C, 0xBD },
	0x8133D730,	{ 0xE1, 0x8C, 0xBE },
	0x8133D731,	{ 0xE1, 0x8C, 0xBF },
	0x8133D732,	{ 0xE1, 0x8D, 0x80 },
	0x8133D733,	{ 0xE1, 0x8D, 0x81 },
	0x8133D734,	{ 0xE1, 0x8D, 0x82 },
	0x8133D735,	{ 0xE1, 0x8D, 0x83 },
	0x8133D736,	{ 0xE1, 0x8D, 0x84 },
	0x8133D737,	{ 0xE1, 0x8D, 0x85 },
	0x8133D738,	{ 0xE1, 0x8D, 0x86 },
	0x8133D739,	{ 0xE1, 0x8D, 0x87 },
	0x8133D830,	{ 0xE1, 0x8D, 0x88 },
	0x8133D831,	{ 0xE1, 0x8D, 0x89 },
	0x8133D832,	{ 0xE1, 0x8D, 0x8A },
	0x8133D833,	{ 0xE1, 0x8D, 0x8B },
	0x8133D834,	{ 0xE1, 0x8D, 0x8C },
	0x8133D835,	{ 0xE1, 0x8D, 0x8D },
	0x8133D836,	{ 0xE1, 0x8D, 0x8E },
	0x8133D837,	{ 0xE1, 0x8D, 0x8F },
	0x8133D838,	{ 0xE1, 0x8D, 0x90 },
	0x8133D839,	{ 0xE1, 0x8D, 0x91 },
	0x8133D930,	{ 0xE1, 0x8D, 0x92 },
	0x8133D931,	{ 0xE1, 0x8D, 0x93 },
	0x8133D932,	{ 0xE1, 0x8D, 0x94 },
	0x8133D933,	{ 0xE1, 0x8D, 0x95 },
	0x8133D934,	{ 0xE1, 0x8D, 0x96 },
	0x8133D935,	{ 0xE1, 0x8D, 0x97 },
	0x8133D936,	{ 0xE1, 0x8D, 0x98 },
	0x8133D937,	{ 0xE1, 0x8D, 0x99 },
	0x8133D938,	{ 0xE1, 0x8D, 0x9A },
	0x8133D939,	{ 0xE1, 0x8D, 0x9B },
	0x8133DA30,	{ 0xE1, 0x8D, 0x9C },
	0x8133DA31,	{ 0xE1, 0x8D, 0x9D },
	0x8133DA32,	{ 0xE1, 0x8D, 0x9E },
	0x8133DA33,	{ 0xE1, 0x8D, 0x9F },
	0x8133DA34,	{ 0xE1, 0x8D, 0xA0 },
	0x8133DA35,	{ 0xE1, 0x8D, 0xA1 },
	0x8133DA36,	{ 0xE1, 0x8D, 0xA2 },
	0x8133DA37,	{ 0xE1, 0x8D, 0xA3 },
	0x8133DA38,	{ 0xE1, 0x8D, 0xA4 },
	0x8133DA39,	{ 0xE1, 0x8D, 0xA5 },
	0x8133DB30,	{ 0xE1, 0x8D, 0xA6 },
	0x8133DB31,	{ 0xE1, 0x8D, 0xA7 },
	0x8133DB32,	{ 0xE1, 0x8D, 0xA8 },
	0x8133DB33,	{ 0xE1, 0x8D, 0xA9 },
	0x8133DB34,	{ 0xE1, 0x8D, 0xAA },
	0x8133DB35,	{ 0xE1, 0x8D, 0xAB },
	0x8133DB36,	{ 0xE1, 0x8D, 0xAC },
	0x8133DB37,	{ 0xE1, 0x8D, 0xAD },
	0x8133DB38,	{ 0xE1, 0x8D, 0xAE },
	0x8133DB39,	{ 0xE1, 0x8D, 0xAF },
	0x8133DC30,	{ 0xE1, 0x8D, 0xB0 },
	0x8133DC31,	{ 0xE1, 0x8D, 0xB1 },
	0x8133DC32,	{ 0xE1, 0x8D, 0xB2 },
	0x8133DC33,	{ 0xE1, 0x8D, 0xB3 },
	0x8133DC34,	{ 0xE1, 0x8D, 0xB4 },
	0x8133DC35,	{ 0xE1, 0x8D, 0xB5 },
	0x8133DC36,	{ 0xE1, 0x8D, 0xB6 },
	0x8133DC37,	{ 0xE1, 0x8D, 0xB7 },
	0x8133DC38,	{ 0xE1, 0x8D, 0xB8 },
	0x8133DC39,	{ 0xE1, 0x8D, 0xB9 },
	0x8133DD30,	{ 0xE1, 0x8D, 0xBA },
	0x8133DD31,	{ 0xE1, 0x8D, 0xBB },
	0x8133DD32,	{ 0xE1, 0x8D, 0xBC },
	0x8133DD33,	{ 0xE1, 0x8D, 0xBD },
	0x8133DD34,	{ 0xE1, 0x8D, 0xBE },
	0x8133DD35,	{ 0xE1, 0x8D, 0xBF },
	0x8133DD36,	{ 0xE1, 0x8E, 0x80 },
	0x8133DD37,	{ 0xE1, 0x8E, 0x81 },
	0x8133DD38,	{ 0xE1, 0x8E, 0x82 },
	0x8133DD39,	{ 0xE1, 0x8E, 0x83 },
	0x8133DE30,	{ 0xE1, 0x8E, 0x84 },
	0x8133DE31,	{ 0xE1, 0x8E, 0x85 },
	0x8133DE32,	{ 0xE1, 0x8E, 0x86 },
	0x8133DE33,	{ 0xE1, 0x8E, 0x87 },
	0x8133DE34,	{ 0xE1, 0x8E, 0x88 },
	0x8133DE35,	{ 0xE1, 0x8E, 0x89 },
	0x8133DE36,	{ 0xE1, 0x8E, 0x8A },
	0x8133DE37,	{ 0xE1, 0x8E, 0x8B },
	0x8133DE38,	{ 0xE1, 0x8E, 0x8C },
	0x8133DE39,	{ 0xE1, 0x8E, 0x8D },
	0x8133DF30,	{ 0xE1, 0x8E, 0x8E },
	0x8133DF31,	{ 0xE1, 0x8E, 0x8F },
	0x8133DF32,	{ 0xE1, 0x8E, 0x90 },
	0x8133DF33,	{ 0xE1, 0x8E, 0x91 },
	0x8133DF34,	{ 0xE1, 0x8E, 0x92 },
	0x8133DF35,	{ 0xE1, 0x8E, 0x93 },
	0x8133DF36,	{ 0xE1, 0x8E, 0x94 },
	0x8133DF37,	{ 0xE1, 0x8E, 0x95 },
	0x8133DF38,	{ 0xE1, 0x8E, 0x96 },
	0x8133DF39,	{ 0xE1, 0x8E, 0x97 },
	0x8133E030,	{ 0xE1, 0x8E, 0x98 },
	0x8133E031,	{ 0xE1, 0x8E, 0x99 },
	0x8133E032,	{ 0xE1, 0x8E, 0x9A },
	0x8133E033,	{ 0xE1, 0x8E, 0x9B },
	0x8133E034,	{ 0xE1, 0x8E, 0x9C },
	0x8133E035,	{ 0xE1, 0x8E, 0x9D },
	0x8133E036,	{ 0xE1, 0x8E, 0x9E },
	0x8133E037,	{ 0xE1, 0x8E, 0x9F },
	0x8133E038,	{ 0xE1, 0x8E, 0xA0 },
	0x8133E039,	{ 0xE1, 0x8E, 0xA1 },
	0x8133E130,	{ 0xE1, 0x8E, 0xA2 },
	0x8133E131,	{ 0xE1, 0x8E, 0xA3 },
	0x8133E132,	{ 0xE1, 0x8E, 0xA4 },
	0x8133E133,	{ 0xE1, 0x8E, 0xA5 },
	0x8133E134,	{ 0xE1, 0x8E, 0xA6 },
	0x8133E135,	{ 0xE1, 0x8E, 0xA7 },
	0x8133E136,	{ 0xE1, 0x8E, 0xA8 },
	0x8133E137,	{ 0xE1, 0x8E, 0xA9 },
	0x8133E138,	{ 0xE1, 0x8E, 0xAA },
	0x8133E139,	{ 0xE1, 0x8E, 0xAB },
	0x8133E230,	{ 0xE1, 0x8E, 0xAC },
	0x8133E231,	{ 0xE1, 0x8E, 0xAD },
	0x8133E232,	{ 0xE1, 0x8E, 0xAE },
	0x8133E233,	{ 0xE1, 0x8E, 0xAF },
	0x8133E234,	{ 0xE1, 0x8E, 0xB0 },
	0x8133E235,	{ 0xE1, 0x8E, 0xB1 },
	0x8133E236,	{ 0xE1, 0x8E, 0xB2 },
	0x8133E237,	{ 0xE1, 0x8E, 0xB3 },
	0x8133E238,	{ 0xE1, 0x8E, 0xB4 },
	0x8133E239,	{ 0xE1, 0x8E, 0xB5 },
	0x8133E330,	{ 0xE1, 0x8E, 0xB6 },
	0x8133E331,	{ 0xE1, 0x8E, 0xB7 },
	0x8133E332,	{ 0xE1, 0x8E, 0xB8 },
	0x8133E333,	{ 0xE1, 0x8E, 0xB9 },
	0x8133E334,	{ 0xE1, 0x8E, 0xBA },
	0x8133E335,	{ 0xE1, 0x8E, 0xBB },
	0x8133E336,	{ 0xE1, 0x8E, 0xBC },
	0x8133E337,	{ 0xE1, 0x8E, 0xBD },
	0x8133E338,	{ 0xE1, 0x8E, 0xBE },
	0x8133E339,	{ 0xE1, 0x8E, 0xBF },
	0x8133E430,	{ 0xE1, 0x8F, 0x80 },
	0x8133E431,	{ 0xE1, 0x8F, 0x81 },
	0x8133E432,	{ 0xE1, 0x8F, 0x82 },
	0x8133E433,	{ 0xE1, 0x8F, 0x83 },
	0x8133E434,	{ 0xE1, 0x8F, 0x84 },
	0x8133E435,	{ 0xE1, 0x8F, 0x85 },
	0x8133E436,	{ 0xE1, 0x8F, 0x86 },
	0x8133E437,	{ 0xE1, 0x8F, 0x87 },
	0x8133E438,	{ 0xE1, 0x8F, 0x88 },
	0x8133E439,	{ 0xE1, 0x8F, 0x89 },
	0x8133E530,	{ 0xE1, 0x8F, 0x8A },
	0x8133E531,	{ 0xE1, 0x8F, 0x8B },
	0x8133E532,	{ 0xE1, 0x8F, 0x8C },
	0x8133E533,	{ 0xE1, 0x8F, 0x8D },
	0x8133E534,	{ 0xE1, 0x8F, 0x8E },
	0x8133E535,	{ 0xE1, 0x8F, 0x8F },
	0x8133E536,	{ 0xE1, 0x8F, 0x90 },
	0x8133E537,	{ 0xE1, 0x8F, 0x91 },
	0x8133E538,	{ 0xE1, 0x8F, 0x92 },
	0x8133E539,	{ 0xE1, 0x8F, 0x93 },
	0x8133E630,	{ 0xE1, 0x8F, 0x94 },
	0x8133E631,	{ 0xE1, 0x8F, 0x95 },
	0x8133E632,	{ 0xE1, 0x8F, 0x96 },
	0x8133E633,	{ 0xE1, 0x8F, 0x97 },
	0x8133E634,	{ 0xE1, 0x8F, 0x98 },
	0x8133E635,	{ 0xE1, 0x8F, 0x99 },
	0x8133E636,	{ 0xE1, 0x8F, 0x9A },
	0x8133E637,	{ 0xE1, 0x8F, 0x9B },
	0x8133E638,	{ 0xE1, 0x8F, 0x9C },
	0x8133E639,	{ 0xE1, 0x8F, 0x9D },
	0x8133E730,	{ 0xE1, 0x8F, 0x9E },
	0x8133E731,	{ 0xE1, 0x8F, 0x9F },
	0x8133E732,	{ 0xE1, 0x8F, 0xA0 },
	0x8133E733,	{ 0xE1, 0x8F, 0xA1 },
	0x8133E734,	{ 0xE1, 0x8F, 0xA2 },
	0x8133E735,	{ 0xE1, 0x8F, 0xA3 },
	0x8133E736,	{ 0xE1, 0x8F, 0xA4 },
	0x8133E737,	{ 0xE1, 0x8F, 0xA5 },
	0x8133E738,	{ 0xE1, 0x8F, 0xA6 },
	0x8133E739,	{ 0xE1, 0x8F, 0xA7 },
	0x8133E830,	{ 0xE1, 0x8F, 0xA8 },
	0x8133E831,	{ 0xE1, 0x8F, 0xA9 },
	0x8133E832,	{ 0xE1, 0x8F, 0xAA },
	0x8133E833,	{ 0xE1, 0x8F, 0xAB },
	0x8133E834,	{ 0xE1, 0x8F, 0xAC },
	0x8133E835,	{ 0xE1, 0x8F, 0xAD },
	0x8133E836,	{ 0xE1, 0x8F, 0xAE },
	0x8133E837,	{ 0xE1, 0x8F, 0xAF },
	0x8133E838,	{ 0xE1, 0x8F, 0xB0 },
	0x8133E839,	{ 0xE1, 0x8F, 0xB1 },
	0x8133E930,	{ 0xE1, 0x8F, 0xB2 },
	0x8133E931,	{ 0xE1, 0x8F, 0xB3 },
	0x8133E932,	{ 0xE1, 0x8F, 0xB4 },
	0x8133E933,	{ 0xE1, 0x8F, 0xB5 },
	0x8133E934,	{ 0xE1, 0x8F, 0xB6 },
	0x8133E935,	{ 0xE1, 0x8F, 0xB7 },
	0x8133E936,	{ 0xE1, 0x8F, 0xB8 },
	0x8133E937,	{ 0xE1, 0x8F, 0xB9 },
	0x8133E938,	{ 0xE1, 0x8F, 0xBA },
	0x8133E939,	{ 0xE1, 0x8F, 0xBB },
	0x8133EA30,	{ 0xE1, 0x8F, 0xBC },
	0x8133EA31,	{ 0xE1, 0x8F, 0xBD },
	0x8133EA32,	{ 0xE1, 0x8F, 0xBE },
	0x8133EA33,	{ 0xE1, 0x8F, 0xBF },
	0x8133EA34,	{ 0xE1, 0x90, 0x80 },
	0x8133EA35,	{ 0xE1, 0x90, 0x81 },
	0x8133EA36,	{ 0xE1, 0x90, 0x82 },
	0x8133EA37,	{ 0xE1, 0x90, 0x83 },
	0x8133EA38,	{ 0xE1, 0x90, 0x84 },
	0x8133EA39,	{ 0xE1, 0x90, 0x85 },
	0x8133EB30,	{ 0xE1, 0x90, 0x86 },
	0x8133EB31,	{ 0xE1, 0x90, 0x87 },
	0x8133EB32,	{ 0xE1, 0x90, 0x88 },
	0x8133EB33,	{ 0xE1, 0x90, 0x89 },
	0x8133EB34,	{ 0xE1, 0x90, 0x8A },
	0x8133EB35,	{ 0xE1, 0x90, 0x8B },
	0x8133EB36,	{ 0xE1, 0x90, 0x8C },
	0x8133EB37,	{ 0xE1, 0x90, 0x8D },
	0x8133EB38,	{ 0xE1, 0x90, 0x8E },
	0x8133EB39,	{ 0xE1, 0x90, 0x8F },
	0x8133EC30,	{ 0xE1, 0x90, 0x90 },
	0x8133EC31,	{ 0xE1, 0x90, 0x91 },
	0x8133EC32,	{ 0xE1, 0x90, 0x92 },
	0x8133EC33,	{ 0xE1, 0x90, 0x93 },
	0x8133EC34,	{ 0xE1, 0x90, 0x94 },
	0x8133EC35,	{ 0xE1, 0x90, 0x95 },
	0x8133EC36,	{ 0xE1, 0x90, 0x96 },
	0x8133EC37,	{ 0xE1, 0x90, 0x97 },
	0x8133EC38,	{ 0xE1, 0x90, 0x98 },
	0x8133EC39,	{ 0xE1, 0x90, 0x99 },
	0x8133ED30,	{ 0xE1, 0x90, 0x9A },
	0x8133ED31,	{ 0xE1, 0x90, 0x9B },
	0x8133ED32,	{ 0xE1, 0x90, 0x9C },
	0x8133ED33,	{ 0xE1, 0x90, 0x9D },
	0x8133ED34,	{ 0xE1, 0x90, 0x9E },
	0x8133ED35,	{ 0xE1, 0x90, 0x9F },
	0x8133ED36,	{ 0xE1, 0x90, 0xA0 },
	0x8133ED37,	{ 0xE1, 0x90, 0xA1 },
	0x8133ED38,	{ 0xE1, 0x90, 0xA2 },
	0x8133ED39,	{ 0xE1, 0x90, 0xA3 },
	0x8133EE30,	{ 0xE1, 0x90, 0xA4 },
	0x8133EE31,	{ 0xE1, 0x90, 0xA5 },
	0x8133EE32,	{ 0xE1, 0x90, 0xA6 },
	0x8133EE33,	{ 0xE1, 0x90, 0xA7 },
	0x8133EE34,	{ 0xE1, 0x90, 0xA8 },
	0x8133EE35,	{ 0xE1, 0x90, 0xA9 },
	0x8133EE36,	{ 0xE1, 0x90, 0xAA },
	0x8133EE37,	{ 0xE1, 0x90, 0xAB },
	0x8133EE38,	{ 0xE1, 0x90, 0xAC },
	0x8133EE39,	{ 0xE1, 0x90, 0xAD },
	0x8133EF30,	{ 0xE1, 0x90, 0xAE },
	0x8133EF31,	{ 0xE1, 0x90, 0xAF },
	0x8133EF32,	{ 0xE1, 0x90, 0xB0 },
	0x8133EF33,	{ 0xE1, 0x90, 0xB1 },
	0x8133EF34,	{ 0xE1, 0x90, 0xB2 },
	0x8133EF35,	{ 0xE1, 0x90, 0xB3 },
	0x8133EF36,	{ 0xE1, 0x90, 0xB4 },
	0x8133EF37,	{ 0xE1, 0x90, 0xB5 },
	0x8133EF38,	{ 0xE1, 0x90, 0xB6 },
	0x8133EF39,	{ 0xE1, 0x90, 0xB7 },
	0x8133F030,	{ 0xE1, 0x90, 0xB8 },
	0x8133F031,	{ 0xE1, 0x90, 0xB9 },
	0x8133F032,	{ 0xE1, 0x90, 0xBA },
	0x8133F033,	{ 0xE1, 0x90, 0xBB },
	0x8133F034,	{ 0xE1, 0x90, 0xBC },
	0x8133F035,	{ 0xE1, 0x90, 0xBD },
	0x8133F036,	{ 0xE1, 0x90, 0xBE },
	0x8133F037,	{ 0xE1, 0x90, 0xBF },
	0x8133F038,	{ 0xE1, 0x91, 0x80 },
	0x8133F039,	{ 0xE1, 0x91, 0x81 },
	0x8133F130,	{ 0xE1, 0x91, 0x82 },
	0x8133F131,	{ 0xE1, 0x91, 0x83 },
	0x8133F132,	{ 0xE1, 0x91, 0x84 },
	0x8133F133,	{ 0xE1, 0x91, 0x85 },
	0x8133F134,	{ 0xE1, 0x91, 0x86 },
	0x8133F135,	{ 0xE1, 0x91, 0x87 },
	0x8133F136,	{ 0xE1, 0x91, 0x88 },
	0x8133F137,	{ 0xE1, 0x91, 0x89 },
	0x8133F138,	{ 0xE1, 0x91, 0x8A },
	0x8133F139,	{ 0xE1, 0x91, 0x8B },
	0x8133F230,	{ 0xE1, 0x91, 0x8C },
	0x8133F231,	{ 0xE1, 0x91, 0x8D },
	0x8133F232,	{ 0xE1, 0x91, 0x8E },
	0x8133F233,	{ 0xE1, 0x91, 0x8F },
	0x8133F234,	{ 0xE1, 0x91, 0x90 },
	0x8133F235,	{ 0xE1, 0x91, 0x91 },
	0x8133F236,	{ 0xE1, 0x91, 0x92 },
	0x8133F237,	{ 0xE1, 0x91, 0x93 },
	0x8133F238,	{ 0xE1, 0x91, 0x94 },
	0x8133F239,	{ 0xE1, 0x91, 0x95 },
	0x8133F330,	{ 0xE1, 0x91, 0x96 },
	0x8133F331,	{ 0xE1, 0x91, 0x97 },
	0x8133F332,	{ 0xE1, 0x91, 0x98 },
	0x8133F333,	{ 0xE1, 0x91, 0x99 },
	0x8133F334,	{ 0xE1, 0x91, 0x9A },
	0x8133F335,	{ 0xE1, 0x91, 0x9B },
	0x8133F336,	{ 0xE1, 0x91, 0x9C },
	0x8133F337,	{ 0xE1, 0x91, 0x9D },
	0x8133F338,	{ 0xE1, 0x91, 0x9E },
	0x8133F339,	{ 0xE1, 0x91, 0x9F },
	0x8133F430,	{ 0xE1, 0x91, 0xA0 },
	0x8133F431,	{ 0xE1, 0x91, 0xA1 },
	0x8133F432,	{ 0xE1, 0x91, 0xA2 },
	0x8133F433,	{ 0xE1, 0x91, 0xA3 },
	0x8133F434,	{ 0xE1, 0x91, 0xA4 },
	0x8133F435,	{ 0xE1, 0x91, 0xA5 },
	0x8133F436,	{ 0xE1, 0x91, 0xA6 },
	0x8133F437,	{ 0xE1, 0x91, 0xA7 },
	0x8133F438,	{ 0xE1, 0x91, 0xA8 },
	0x8133F439,	{ 0xE1, 0x91, 0xA9 },
	0x8133F530,	{ 0xE1, 0x91, 0xAA },
	0x8133F531,	{ 0xE1, 0x91, 0xAB },
	0x8133F532,	{ 0xE1, 0x91, 0xAC },
	0x8133F533,	{ 0xE1, 0x91, 0xAD },
	0x8133F534,	{ 0xE1, 0x91, 0xAE },
	0x8133F535,	{ 0xE1, 0x91, 0xAF },
	0x8133F536,	{ 0xE1, 0x91, 0xB0 },
	0x8133F537,	{ 0xE1, 0x91, 0xB1 },
	0x8133F538,	{ 0xE1, 0x91, 0xB2 },
	0x8133F539,	{ 0xE1, 0x91, 0xB3 },
	0x8133F630,	{ 0xE1, 0x91, 0xB4 },
	0x8133F631,	{ 0xE1, 0x91, 0xB5 },
	0x8133F632,	{ 0xE1, 0x91, 0xB6 },
	0x8133F633,	{ 0xE1, 0x91, 0xB7 },
	0x8133F634,	{ 0xE1, 0x91, 0xB8 },
	0x8133F635,	{ 0xE1, 0x91, 0xB9 },
	0x8133F636,	{ 0xE1, 0x91, 0xBA },
	0x8133F637,	{ 0xE1, 0x91, 0xBB },
	0x8133F638,	{ 0xE1, 0x91, 0xBC },
	0x8133F639,	{ 0xE1, 0x91, 0xBD },
	0x8133F730,	{ 0xE1, 0x91, 0xBE },
	0x8133F731,	{ 0xE1, 0x91, 0xBF },
	0x8133F732,	{ 0xE1, 0x92, 0x80 },
	0x8133F733,	{ 0xE1, 0x92, 0x81 },
	0x8133F734,	{ 0xE1, 0x92, 0x82 },
	0x8133F735,	{ 0xE1, 0x92, 0x83 },
	0x8133F736,	{ 0xE1, 0x92, 0x84 },
	0x8133F737,	{ 0xE1, 0x92, 0x85 },
	0x8133F738,	{ 0xE1, 0x92, 0x86 },
	0x8133F739,	{ 0xE1, 0x92, 0x87 },
	0x8133F830,	{ 0xE1, 0x92, 0x88 },
	0x8133F831,	{ 0xE1, 0x92, 0x89 },
	0x8133F832,	{ 0xE1, 0x92, 0x8A },
	0x8133F833,	{ 0xE1, 0x92, 0x8B },
	0x8133F834,	{ 0xE1, 0x92, 0x8C },
	0x8133F835,	{ 0xE1, 0x92, 0x8D },
	0x8133F836,	{ 0xE1, 0x92, 0x8E },
	0x8133F837,	{ 0xE1, 0x92, 0x8F },
	0x8133F838,	{ 0xE1, 0x92, 0x90 },
	0x8133F839,	{ 0xE1, 0x92, 0x91 },
	0x8133F930,	{ 0xE1, 0x92, 0x92 },
	0x8133F931,	{ 0xE1, 0x92, 0x93 },
	0x8133F932,	{ 0xE1, 0x92, 0x94 },
	0x8133F933,	{ 0xE1, 0x92, 0x95 },
	0x8133F934,	{ 0xE1, 0x92, 0x96 },
	0x8133F935,	{ 0xE1, 0x92, 0x97 },
	0x8133F936,	{ 0xE1, 0x92, 0x98 },
	0x8133F937,	{ 0xE1, 0x92, 0x99 },
	0x8133F938,	{ 0xE1, 0x92, 0x9A },
	0x8133F939,	{ 0xE1, 0x92, 0x9B },
	0x8133FA30,	{ 0xE1, 0x92, 0x9C },
	0x8133FA31,	{ 0xE1, 0x92, 0x9D },
	0x8133FA32,	{ 0xE1, 0x92, 0x9E },
	0x8133FA33,	{ 0xE1, 0x92, 0x9F },
	0x8133FA34,	{ 0xE1, 0x92, 0xA0 },
	0x8133FA35,	{ 0xE1, 0x92, 0xA1 },
	0x8133FA36,	{ 0xE1, 0x92, 0xA2 },
	0x8133FA37,	{ 0xE1, 0x92, 0xA3 },
	0x8133FA38,	{ 0xE1, 0x92, 0xA4 },
	0x8133FA39,	{ 0xE1, 0x92, 0xA5 },
	0x8133FB30,	{ 0xE1, 0x92, 0xA6 },
	0x8133FB31,	{ 0xE1, 0x92, 0xA7 },
	0x8133FB32,	{ 0xE1, 0x92, 0xA8 },
	0x8133FB33,	{ 0xE1, 0x92, 0xA9 },
	0x8133FB34,	{ 0xE1, 0x92, 0xAA },
	0x8133FB35,	{ 0xE1, 0x92, 0xAB },
	0x8133FB36,	{ 0xE1, 0x92, 0xAC },
	0x8133FB37,	{ 0xE1, 0x92, 0xAD },
	0x8133FB38,	{ 0xE1, 0x92, 0xAE },
	0x8133FB39,	{ 0xE1, 0x92, 0xAF },
	0x8133FC30,	{ 0xE1, 0x92, 0xB0 },
	0x8133FC31,	{ 0xE1, 0x92, 0xB1 },
	0x8133FC32,	{ 0xE1, 0x92, 0xB2 },
	0x8133FC33,	{ 0xE1, 0x92, 0xB3 },
	0x8133FC34,	{ 0xE1, 0x92, 0xB4 },
	0x8133FC35,	{ 0xE1, 0x92, 0xB5 },
	0x8133FC36,	{ 0xE1, 0x92, 0xB6 },
	0x8133FC37,	{ 0xE1, 0x92, 0xB7 },
	0x8133FC38,	{ 0xE1, 0x92, 0xB8 },
	0x8133FC39,	{ 0xE1, 0x92, 0xB9 },
	0x8133FD30,	{ 0xE1, 0x92, 0xBA },
	0x8133FD31,	{ 0xE1, 0x92, 0xBB },
	0x8133FD32,	{ 0xE1, 0x92, 0xBC },
	0x8133FD33,	{ 0xE1, 0x92, 0xBD },
	0x8133FD34,	{ 0xE1, 0x92, 0xBE },
	0x8133FD35,	{ 0xE1, 0x92, 0xBF },
	0x8133FD36,	{ 0xE1, 0x93, 0x80 },
	0x8133FD37,	{ 0xE1, 0x93, 0x81 },
	0x8133FD38,	{ 0xE1, 0x93, 0x82 },
	0x8133FD39,	{ 0xE1, 0x93, 0x83 },
	0x8133FE30,	{ 0xE1, 0x93, 0x84 },
	0x8133FE31,	{ 0xE1, 0x93, 0x85 },
	0x8133FE32,	{ 0xE1, 0x93, 0x86 },
	0x8133FE33,	{ 0xE1, 0x93, 0x87 },
	0x8133FE34,	{ 0xE1, 0x93, 0x88 },
	0x8133FE35,	{ 0xE1, 0x93, 0x89 },
	0x8133FE36,	{ 0xE1, 0x93, 0x8A },
	0x8133FE37,	{ 0xE1, 0x93, 0x8B },
	0x8133FE38,	{ 0xE1, 0x93, 0x8C },
	0x8133FE39,	{ 0xE1, 0x93, 0x8D },
	0x81348130,	{ 0xE1, 0x93, 0x8E },
	0x81348131,	{ 0xE1, 0x93, 0x8F },
	0x81348132,	{ 0xE1, 0x93, 0x90 },
	0x81348133,	{ 0xE1, 0x93, 0x91 },
	0x81348134,	{ 0xE1, 0x93, 0x92 },
	0x81348135,	{ 0xE1, 0x93, 0x93 },
	0x81348136,	{ 0xE1, 0x93, 0x94 },
	0x81348137,	{ 0xE1, 0x93, 0x95 },
	0x81348138,	{ 0xE1, 0x93, 0x96 },
	0x81348139,	{ 0xE1, 0x93, 0x97 },
	0x81348230,	{ 0xE1, 0x93, 0x98 },
	0x81348231,	{ 0xE1, 0x93, 0x99 },
	0x81348232,	{ 0xE1, 0x93, 0x9A },
	0x81348233,	{ 0xE1, 0x93, 0x9B },
	0x81348234,	{ 0xE1, 0x93, 0x9C },
	0x81348235,	{ 0xE1, 0x93, 0x9D },
	0x81348236,	{ 0xE1, 0x93, 0x9E },
	0x81348237,	{ 0xE1, 0x93, 0x9F },
	0x81348238,	{ 0xE1, 0x93, 0xA0 },
	0x81348239,	{ 0xE1, 0x93, 0xA1 },
	0x81348330,	{ 0xE1, 0x93, 0xA2 },
	0x81348331,	{ 0xE1, 0x93, 0xA3 },
	0x81348332,	{ 0xE1, 0x93, 0xA4 },
	0x81348333,	{ 0xE1, 0x93, 0xA5 },
	0x81348334,	{ 0xE1, 0x93, 0xA6 },
	0x81348335,	{ 0xE1, 0x93, 0xA7 },
	0x81348336,	{ 0xE1, 0x93, 0xA8 },
	0x81348337,	{ 0xE1, 0x93, 0xA9 },
	0x81348338,	{ 0xE1, 0x93, 0xAA },
	0x81348339,	{ 0xE1, 0x93, 0xAB },
	0x81348430,	{ 0xE1, 0x93, 0xAC },
	0x81348431,	{ 0xE1, 0x93, 0xAD },
	0x81348432,	{ 0xE1, 0x93, 0xAE },
	0x81348433,	{ 0xE1, 0x93, 0xAF },
	0x81348434,	{ 0xE1, 0x93, 0xB0 },
	0x81348435,	{ 0xE1, 0x93, 0xB1 },
	0x81348436,	{ 0xE1, 0x93, 0xB2 },
	0x81348437,	{ 0xE1, 0x93, 0xB3 },
	0x81348438,	{ 0xE1, 0x93, 0xB4 },
	0x81348439,	{ 0xE1, 0x93, 0xB5 },
	0x81348530,	{ 0xE1, 0x93, 0xB6 },
	0x81348531,	{ 0xE1, 0x93, 0xB7 },
	0x81348532,	{ 0xE1, 0x93, 0xB8 },
	0x81348533,	{ 0xE1, 0x93, 0xB9 },
	0x81348534,	{ 0xE1, 0x93, 0xBA },
	0x81348535,	{ 0xE1, 0x93, 0xBB },
	0x81348536,	{ 0xE1, 0x93, 0xBC },
	0x81348537,	{ 0xE1, 0x93, 0xBD },
	0x81348538,	{ 0xE1, 0x93, 0xBE },
	0x81348539,	{ 0xE1, 0x93, 0xBF },
	0x81348630,	{ 0xE1, 0x94, 0x80 },
	0x81348631,	{ 0xE1, 0x94, 0x81 },
	0x81348632,	{ 0xE1, 0x94, 0x82 },
	0x81348633,	{ 0xE1, 0x94, 0x83 },
	0x81348634,	{ 0xE1, 0x94, 0x84 },
	0x81348635,	{ 0xE1, 0x94, 0x85 },
	0x81348636,	{ 0xE1, 0x94, 0x86 },
	0x81348637,	{ 0xE1, 0x94, 0x87 },
	0x81348638,	{ 0xE1, 0x94, 0x88 },
	0x81348639,	{ 0xE1, 0x94, 0x89 },
	0x81348730,	{ 0xE1, 0x94, 0x8A },
	0x81348731,	{ 0xE1, 0x94, 0x8B },
	0x81348732,	{ 0xE1, 0x94, 0x8C },
	0x81348733,	{ 0xE1, 0x94, 0x8D },
	0x81348734,	{ 0xE1, 0x94, 0x8E },
	0x81348735,	{ 0xE1, 0x94, 0x8F },
	0x81348736,	{ 0xE1, 0x94, 0x90 },
	0x81348737,	{ 0xE1, 0x94, 0x91 },
	0x81348738,	{ 0xE1, 0x94, 0x92 },
	0x81348739,	{ 0xE1, 0x94, 0x93 },
	0x81348830,	{ 0xE1, 0x94, 0x94 },
	0x81348831,	{ 0xE1, 0x94, 0x95 },
	0x81348832,	{ 0xE1, 0x94, 0x96 },
	0x81348833,	{ 0xE1, 0x94, 0x97 },
	0x81348834,	{ 0xE1, 0x94, 0x98 },
	0x81348835,	{ 0xE1, 0x94, 0x99 },
	0x81348836,	{ 0xE1, 0x94, 0x9A },
	0x81348837,	{ 0xE1, 0x94, 0x9B },
	0x81348838,	{ 0xE1, 0x94, 0x9C },
	0x81348839,	{ 0xE1, 0x94, 0x9D },
	0x81348930,	{ 0xE1, 0x94, 0x9E },
	0x81348931,	{ 0xE1, 0x94, 0x9F },
	0x81348932,	{ 0xE1, 0x94, 0xA0 },
	0x81348933,	{ 0xE1, 0x94, 0xA1 },
	0x81348934,	{ 0xE1, 0x94, 0xA2 },
	0x81348935,	{ 0xE1, 0x94, 0xA3 },
	0x81348936,	{ 0xE1, 0x94, 0xA4 },
	0x81348937,	{ 0xE1, 0x94, 0xA5 },
	0x81348938,	{ 0xE1, 0x94, 0xA6 },
	0x81348939,	{ 0xE1, 0x94, 0xA7 },
	0x81348A30,	{ 0xE1, 0x94, 0xA8 },
	0x81348A31,	{ 0xE1, 0x94, 0xA9 },
	0x81348A32,	{ 0xE1, 0x94, 0xAA },
	0x81348A33,	{ 0xE1, 0x94, 0xAB },
	0x81348A34,	{ 0xE1, 0x94, 0xAC },
	0x81348A35,	{ 0xE1, 0x94, 0xAD },
	0x81348A36,	{ 0xE1, 0x94, 0xAE },
	0x81348A37,	{ 0xE1, 0x94, 0xAF },
	0x81348A38,	{ 0xE1, 0x94, 0xB0 },
	0x81348A39,	{ 0xE1, 0x94, 0xB1 },
	0x81348B30,	{ 0xE1, 0x94, 0xB2 },
	0x81348B31,	{ 0xE1, 0x94, 0xB3 },
	0x81348B32,	{ 0xE1, 0x94, 0xB4 },
	0x81348B33,	{ 0xE1, 0x94, 0xB5 },
	0x81348B34,	{ 0xE1, 0x94, 0xB6 },
	0x81348B35,	{ 0xE1, 0x94, 0xB7 },
	0x81348B36,	{ 0xE1, 0x94, 0xB8 },
	0x81348B37,	{ 0xE1, 0x94, 0xB9 },
	0x81348B38,	{ 0xE1, 0x94, 0xBA },
	0x81348B39,	{ 0xE1, 0x94, 0xBB },
	0x81348C30,	{ 0xE1, 0x94, 0xBC },
	0x81348C31,	{ 0xE1, 0x94, 0xBD },
	0x81348C32,	{ 0xE1, 0x94, 0xBE },
	0x81348C33,	{ 0xE1, 0x94, 0xBF },
	0x81348C34,	{ 0xE1, 0x95, 0x80 },
	0x81348C35,	{ 0xE1, 0x95, 0x81 },
	0x81348C36,	{ 0xE1, 0x95, 0x82 },
	0x81348C37,	{ 0xE1, 0x95, 0x83 },
	0x81348C38,	{ 0xE1, 0x95, 0x84 },
	0x81348C39,	{ 0xE1, 0x95, 0x85 },
	0x81348D30,	{ 0xE1, 0x95, 0x86 },
	0x81348D31,	{ 0xE1, 0x95, 0x87 },
	0x81348D32,	{ 0xE1, 0x95, 0x88 },
	0x81348D33,	{ 0xE1, 0x95, 0x89 },
	0x81348D34,	{ 0xE1, 0x95, 0x8A },
	0x81348D35,	{ 0xE1, 0x95, 0x8B },
	0x81348D36,	{ 0xE1, 0x95, 0x8C },
	0x81348D37,	{ 0xE1, 0x95, 0x8D },
	0x81348D38,	{ 0xE1, 0x95, 0x8E },
	0x81348D39,	{ 0xE1, 0x95, 0x8F },
	0x81348E30,	{ 0xE1, 0x95, 0x90 },
	0x81348E31,	{ 0xE1, 0x95, 0x91 },
	0x81348E32,	{ 0xE1, 0x95, 0x92 },
	0x81348E33,	{ 0xE1, 0x95, 0x93 },
	0x81348E34,	{ 0xE1, 0x95, 0x94 },
	0x81348E35,	{ 0xE1, 0x95, 0x95 },
	0x81348E36,	{ 0xE1, 0x95, 0x96 },
	0x81348E37,	{ 0xE1, 0x95, 0x97 },
	0x81348E38,	{ 0xE1, 0x95, 0x98 },
	0x81348E39,	{ 0xE1, 0x95, 0x99 },
	0x81348F30,	{ 0xE1, 0x95, 0x9A },
	0x81348F31,	{ 0xE1, 0x95, 0x9B },
	0x81348F32,	{ 0xE1, 0x95, 0x9C },
	0x81348F33,	{ 0xE1, 0x95, 0x9D },
	0x81348F34,	{ 0xE1, 0x95, 0x9E },
	0x81348F35,	{ 0xE1, 0x95, 0x9F },
	0x81348F36,	{ 0xE1, 0x95, 0xA0 },
	0x81348F37,	{ 0xE1, 0x95, 0xA1 },
	0x81348F38,	{ 0xE1, 0x95, 0xA2 },
	0x81348F39,	{ 0xE1, 0x95, 0xA3 },
	0x81349030,	{ 0xE1, 0x95, 0xA4 },
	0x81349031,	{ 0xE1, 0x95, 0xA5 },
	0x81349032,	{ 0xE1, 0x95, 0xA6 },
	0x81349033,	{ 0xE1, 0x95, 0xA7 },
	0x81349034,	{ 0xE1, 0x95, 0xA8 },
	0x81349035,	{ 0xE1, 0x95, 0xA9 },
	0x81349036,	{ 0xE1, 0x95, 0xAA },
	0x81349037,	{ 0xE1, 0x95, 0xAB },
	0x81349038,	{ 0xE1, 0x95, 0xAC },
	0x81349039,	{ 0xE1, 0x95, 0xAD },
	0x81349130,	{ 0xE1, 0x95, 0xAE },
	0x81349131,	{ 0xE1, 0x95, 0xAF },
	0x81349132,	{ 0xE1, 0x95, 0xB0 },
	0x81349133,	{ 0xE1, 0x95, 0xB1 },
	0x81349134,	{ 0xE1, 0x95, 0xB2 },
	0x81349135,	{ 0xE1, 0x95, 0xB3 },
	0x81349136,	{ 0xE1, 0x95, 0xB4 },
	0x81349137,	{ 0xE1, 0x95, 0xB5 },
	0x81349138,	{ 0xE1, 0x95, 0xB6 },
	0x81349139,	{ 0xE1, 0x95, 0xB7 },
	0x81349230,	{ 0xE1, 0x95, 0xB8 },
	0x81349231,	{ 0xE1, 0x95, 0xB9 },
	0x81349232,	{ 0xE1, 0x95, 0xBA },
	0x81349233,	{ 0xE1, 0x95, 0xBB },
	0x81349234,	{ 0xE1, 0x95, 0xBC },
	0x81349235,	{ 0xE1, 0x95, 0xBD },
	0x81349236,	{ 0xE1, 0x95, 0xBE },
	0x81349237,	{ 0xE1, 0x95, 0xBF },
	0x81349238,	{ 0xE1, 0x96, 0x80 },
	0x81349239,	{ 0xE1, 0x96, 0x81 },
	0x81349330,	{ 0xE1, 0x96, 0x82 },
	0x81349331,	{ 0xE1, 0x96, 0x83 },
	0x81349332,	{ 0xE1, 0x96, 0x84 },
	0x81349333,	{ 0xE1, 0x96, 0x85 },
	0x81349334,	{ 0xE1, 0x96, 0x86 },
	0x81349335,	{ 0xE1, 0x96, 0x87 },
	0x81349336,	{ 0xE1, 0x96, 0x88 },
	0x81349337,	{ 0xE1, 0x96, 0x89 },
	0x81349338,	{ 0xE1, 0x96, 0x8A },
	0x81349339,	{ 0xE1, 0x96, 0x8B },
	0x81349430,	{ 0xE1, 0x96, 0x8C },
	0x81349431,	{ 0xE1, 0x96, 0x8D },
	0x81349432,	{ 0xE1, 0x96, 0x8E },
	0x81349433,	{ 0xE1, 0x96, 0x8F },
	0x81349434,	{ 0xE1, 0x96, 0x90 },
	0x81349435,	{ 0xE1, 0x96, 0x91 },
	0x81349436,	{ 0xE1, 0x96, 0x92 },
	0x81349437,	{ 0xE1, 0x96, 0x93 },
	0x81349438,	{ 0xE1, 0x96, 0x94 },
	0x81349439,	{ 0xE1, 0x96, 0x95 },
	0x81349530,	{ 0xE1, 0x96, 0x96 },
	0x81349531,	{ 0xE1, 0x96, 0x97 },
	0x81349532,	{ 0xE1, 0x96, 0x98 },
	0x81349533,	{ 0xE1, 0x96, 0x99 },
	0x81349534,	{ 0xE1, 0x96, 0x9A },
	0x81349535,	{ 0xE1, 0x96, 0x9B },
	0x81349536,	{ 0xE1, 0x96, 0x9C },
	0x81349537,	{ 0xE1, 0x96, 0x9D },
	0x81349538,	{ 0xE1, 0x96, 0x9E },
	0x81349539,	{ 0xE1, 0x96, 0x9F },
	0x81349630,	{ 0xE1, 0x96, 0xA0 },
	0x81349631,	{ 0xE1, 0x96, 0xA1 },
	0x81349632,	{ 0xE1, 0x96, 0xA2 },
	0x81349633,	{ 0xE1, 0x96, 0xA3 },
	0x81349634,	{ 0xE1, 0x96, 0xA4 },
	0x81349635,	{ 0xE1, 0x96, 0xA5 },
	0x81349636,	{ 0xE1, 0x96, 0xA6 },
	0x81349637,	{ 0xE1, 0x96, 0xA7 },
	0x81349638,	{ 0xE1, 0x96, 0xA8 },
	0x81349639,	{ 0xE1, 0x96, 0xA9 },
	0x81349730,	{ 0xE1, 0x96, 0xAA },
	0x81349731,	{ 0xE1, 0x96, 0xAB },
	0x81349732,	{ 0xE1, 0x96, 0xAC },
	0x81349733,	{ 0xE1, 0x96, 0xAD },
	0x81349734,	{ 0xE1, 0x96, 0xAE },
	0x81349735,	{ 0xE1, 0x96, 0xAF },
	0x81349736,	{ 0xE1, 0x96, 0xB0 },
	0x81349737,	{ 0xE1, 0x96, 0xB1 },
	0x81349738,	{ 0xE1, 0x96, 0xB2 },
	0x81349739,	{ 0xE1, 0x96, 0xB3 },
	0x81349830,	{ 0xE1, 0x96, 0xB4 },
	0x81349831,	{ 0xE1, 0x96, 0xB5 },
	0x81349832,	{ 0xE1, 0x96, 0xB6 },
	0x81349833,	{ 0xE1, 0x96, 0xB7 },
	0x81349834,	{ 0xE1, 0x96, 0xB8 },
	0x81349835,	{ 0xE1, 0x96, 0xB9 },
	0x81349836,	{ 0xE1, 0x96, 0xBA },
	0x81349837,	{ 0xE1, 0x96, 0xBB },
	0x81349838,	{ 0xE1, 0x96, 0xBC },
	0x81349839,	{ 0xE1, 0x96, 0xBD },
	0x81349930,	{ 0xE1, 0x96, 0xBE },
	0x81349931,	{ 0xE1, 0x96, 0xBF },
	0x81349932,	{ 0xE1, 0x97, 0x80 },
	0x81349933,	{ 0xE1, 0x97, 0x81 },
	0x81349934,	{ 0xE1, 0x97, 0x82 },
	0x81349935,	{ 0xE1, 0x97, 0x83 },
	0x81349936,	{ 0xE1, 0x97, 0x84 },
	0x81349937,	{ 0xE1, 0x97, 0x85 },
	0x81349938,	{ 0xE1, 0x97, 0x86 },
	0x81349939,	{ 0xE1, 0x97, 0x87 },
	0x81349A30,	{ 0xE1, 0x97, 0x88 },
	0x81349A31,	{ 0xE1, 0x97, 0x89 },
	0x81349A32,	{ 0xE1, 0x97, 0x8A },
	0x81349A33,	{ 0xE1, 0x97, 0x8B },
	0x81349A34,	{ 0xE1, 0x97, 0x8C },
	0x81349A35,	{ 0xE1, 0x97, 0x8D },
	0x81349A36,	{ 0xE1, 0x97, 0x8E },
	0x81349A37,	{ 0xE1, 0x97, 0x8F },
	0x81349A38,	{ 0xE1, 0x97, 0x90 },
	0x81349A39,	{ 0xE1, 0x97, 0x91 },
	0x81349B30,	{ 0xE1, 0x97, 0x92 },
	0x81349B31,	{ 0xE1, 0x97, 0x93 },
	0x81349B32,	{ 0xE1, 0x97, 0x94 },
	0x81349B33,	{ 0xE1, 0x97, 0x95 },
	0x81349B34,	{ 0xE1, 0x97, 0x96 },
	0x81349B35,	{ 0xE1, 0x97, 0x97 },
	0x81349B36,	{ 0xE1, 0x97, 0x98 },
	0x81349B37,	{ 0xE1, 0x97, 0x99 },
	0x81349B38,	{ 0xE1, 0x97, 0x9A },
	0x81349B39,	{ 0xE1, 0x97, 0x9B },
	0x81349C30,	{ 0xE1, 0x97, 0x9C },
	0x81349C31,	{ 0xE1, 0x97, 0x9D },
	0x81349C32,	{ 0xE1, 0x97, 0x9E },
	0x81349C33,	{ 0xE1, 0x97, 0x9F },
	0x81349C34,	{ 0xE1, 0x97, 0xA0 },
	0x81349C35,	{ 0xE1, 0x97, 0xA1 },
	0x81349C36,	{ 0xE1, 0x97, 0xA2 },
	0x81349C37,	{ 0xE1, 0x97, 0xA3 },
	0x81349C38,	{ 0xE1, 0x97, 0xA4 },
	0x81349C39,	{ 0xE1, 0x97, 0xA5 },
	0x81349D30,	{ 0xE1, 0x97, 0xA6 },
	0x81349D31,	{ 0xE1, 0x97, 0xA7 },
	0x81349D32,	{ 0xE1, 0x97, 0xA8 },
	0x81349D33,	{ 0xE1, 0x97, 0xA9 },
	0x81349D34,	{ 0xE1, 0x97, 0xAA },
	0x81349D35,	{ 0xE1, 0x97, 0xAB },
	0x81349D36,	{ 0xE1, 0x97, 0xAC },
	0x81349D37,	{ 0xE1, 0x97, 0xAD },
	0x81349D38,	{ 0xE1, 0x97, 0xAE },
	0x81349D39,	{ 0xE1, 0x97, 0xAF },
	0x81349E30,	{ 0xE1, 0x97, 0xB0 },
	0x81349E31,	{ 0xE1, 0x97, 0xB1 },
	0x81349E32,	{ 0xE1, 0x97, 0xB2 },
	0x81349E33,	{ 0xE1, 0x97, 0xB3 },
	0x81349E34,	{ 0xE1, 0x97, 0xB4 },
	0x81349E35,	{ 0xE1, 0x97, 0xB5 },
	0x81349E36,	{ 0xE1, 0x97, 0xB6 },
	0x81349E37,	{ 0xE1, 0x97, 0xB7 },
	0x81349E38,	{ 0xE1, 0x97, 0xB8 },
	0x81349E39,	{ 0xE1, 0x97, 0xB9 },
	0x81349F30,	{ 0xE1, 0x97, 0xBA },
	0x81349F31,	{ 0xE1, 0x97, 0xBB },
	0x81349F32,	{ 0xE1, 0x97, 0xBC },
	0x81349F33,	{ 0xE1, 0x97, 0xBD },
	0x81349F34,	{ 0xE1, 0x97, 0xBE },
	0x81349F35,	{ 0xE1, 0x97, 0xBF },
	0x81349F36,	{ 0xE1, 0x98, 0x80 },
	0x81349F37,	{ 0xE1, 0x98, 0x81 },
	0x81349F38,	{ 0xE1, 0x98, 0x82 },
	0x81349F39,	{ 0xE1, 0x98, 0x83 },
	0x8134A030,	{ 0xE1, 0x98, 0x84 },
	0x8134A031,	{ 0xE1, 0x98, 0x85 },
	0x8134A032,	{ 0xE1, 0x98, 0x86 },
	0x8134A033,	{ 0xE1, 0x98, 0x87 },
	0x8134A034,	{ 0xE1, 0x98, 0x88 },
	0x8134A035,	{ 0xE1, 0x98, 0x89 },
	0x8134A036,	{ 0xE1, 0x98, 0x8A },
	0x8134A037,	{ 0xE1, 0x98, 0x8B },
	0x8134A038,	{ 0xE1, 0x98, 0x8C },
	0x8134A039,	{ 0xE1, 0x98, 0x8D },
	0x8134A130,	{ 0xE1, 0x98, 0x8E },
	0x8134A131,	{ 0xE1, 0x98, 0x8F },
	0x8134A132,	{ 0xE1, 0x98, 0x90 },
	0x8134A133,	{ 0xE1, 0x98, 0x91 },
	0x8134A134,	{ 0xE1, 0x98, 0x92 },
	0x8134A135,	{ 0xE1, 0x98, 0x93 },
	0x8134A136,	{ 0xE1, 0x98, 0x94 },
	0x8134A137,	{ 0xE1, 0x98, 0x95 },
	0x8134A138,	{ 0xE1, 0x98, 0x96 },
	0x8134A139,	{ 0xE1, 0x98, 0x97 },
	0x8134A230,	{ 0xE1, 0x98, 0x98 },
	0x8134A231,	{ 0xE1, 0x98, 0x99 },
	0x8134A232,	{ 0xE1, 0x98, 0x9A },
	0x8134A233,	{ 0xE1, 0x98, 0x9B },
	0x8134A234,	{ 0xE1, 0x98, 0x9C },
	0x8134A235,	{ 0xE1, 0x98, 0x9D },
	0x8134A236,	{ 0xE1, 0x98, 0x9E },
	0x8134A237,	{ 0xE1, 0x98, 0x9F },
	0x8134A238,	{ 0xE1, 0x98, 0xA0 },
	0x8134A239,	{ 0xE1, 0x98, 0xA1 },
	0x8134A330,	{ 0xE1, 0x98, 0xA2 },
	0x8134A331,	{ 0xE1, 0x98, 0xA3 },
	0x8134A332,	{ 0xE1, 0x98, 0xA4 },
	0x8134A333,	{ 0xE1, 0x98, 0xA5 },
	0x8134A334,	{ 0xE1, 0x98, 0xA6 },
	0x8134A335,	{ 0xE1, 0x98, 0xA7 },
	0x8134A336,	{ 0xE1, 0x98, 0xA8 },
	0x8134A337,	{ 0xE1, 0x98, 0xA9 },
	0x8134A338,	{ 0xE1, 0x98, 0xAA },
	0x8134A339,	{ 0xE1, 0x98, 0xAB },
	0x8134A430,	{ 0xE1, 0x98, 0xAC },
	0x8134A431,	{ 0xE1, 0x98, 0xAD },
	0x8134A432,	{ 0xE1, 0x98, 0xAE },
	0x8134A433,	{ 0xE1, 0x98, 0xAF },
	0x8134A434,	{ 0xE1, 0x98, 0xB0 },
	0x8134A435,	{ 0xE1, 0x98, 0xB1 },
	0x8134A436,	{ 0xE1, 0x98, 0xB2 },
	0x8134A437,	{ 0xE1, 0x98, 0xB3 },
	0x8134A438,	{ 0xE1, 0x98, 0xB4 },
	0x8134A439,	{ 0xE1, 0x98, 0xB5 },
	0x8134A530,	{ 0xE1, 0x98, 0xB6 },
	0x8134A531,	{ 0xE1, 0x98, 0xB7 },
	0x8134A532,	{ 0xE1, 0x98, 0xB8 },
	0x8134A533,	{ 0xE1, 0x98, 0xB9 },
	0x8134A534,	{ 0xE1, 0x98, 0xBA },
	0x8134A535,	{ 0xE1, 0x98, 0xBB },
	0x8134A536,	{ 0xE1, 0x98, 0xBC },
	0x8134A537,	{ 0xE1, 0x98, 0xBD },
	0x8134A538,	{ 0xE1, 0x98, 0xBE },
	0x8134A539,	{ 0xE1, 0x98, 0xBF },
	0x8134A630,	{ 0xE1, 0x99, 0x80 },
	0x8134A631,	{ 0xE1, 0x99, 0x81 },
	0x8134A632,	{ 0xE1, 0x99, 0x82 },
	0x8134A633,	{ 0xE1, 0x99, 0x83 },
	0x8134A634,	{ 0xE1, 0x99, 0x84 },
	0x8134A635,	{ 0xE1, 0x99, 0x85 },
	0x8134A636,	{ 0xE1, 0x99, 0x86 },
	0x8134A637,	{ 0xE1, 0x99, 0x87 },
	0x8134A638,	{ 0xE1, 0x99, 0x88 },
	0x8134A639,	{ 0xE1, 0x99, 0x89 },
	0x8134A730,	{ 0xE1, 0x99, 0x8A },
	0x8134A731,	{ 0xE1, 0x99, 0x8B },
	0x8134A732,	{ 0xE1, 0x99, 0x8C },
	0x8134A733,	{ 0xE1, 0x99, 0x8D },
	0x8134A734,	{ 0xE1, 0x99, 0x8E },
	0x8134A735,	{ 0xE1, 0x99, 0x8F },
	0x8134A736,	{ 0xE1, 0x99, 0x90 },
	0x8134A737,	{ 0xE1, 0x99, 0x91 },
	0x8134A738,	{ 0xE1, 0x99, 0x92 },
	0x8134A739,	{ 0xE1, 0x99, 0x93 },
	0x8134A830,	{ 0xE1, 0x99, 0x94 },
	0x8134A831,	{ 0xE1, 0x99, 0x95 },
	0x8134A832,	{ 0xE1, 0x99, 0x96 },
	0x8134A833,	{ 0xE1, 0x99, 0x97 },
	0x8134A834,	{ 0xE1, 0x99, 0x98 },
	0x8134A835,	{ 0xE1, 0x99, 0x99 },
	0x8134A836,	{ 0xE1, 0x99, 0x9A },
	0x8134A837,	{ 0xE1, 0x99, 0x9B },
	0x8134A838,	{ 0xE1, 0x99, 0x9C },
	0x8134A839,	{ 0xE1, 0x99, 0x9D },
	0x8134A930,	{ 0xE1, 0x99, 0x9E },
	0x8134A931,	{ 0xE1, 0x99, 0x9F },
	0x8134A932,	{ 0xE1, 0x99, 0xA0 },
	0x8134A933,	{ 0xE1, 0x99, 0xA1 },
	0x8134A934,	{ 0xE1, 0x99, 0xA2 },
	0x8134A935,	{ 0xE1, 0x99, 0xA3 },
	0x8134A936,	{ 0xE1, 0x99, 0xA4 },
	0x8134A937,	{ 0xE1, 0x99, 0xA5 },
	0x8134A938,	{ 0xE1, 0x99, 0xA6 },
	0x8134A939,	{ 0xE1, 0x99, 0xA7 },
	0x8134AA30,	{ 0xE1, 0x99, 0xA8 },
	0x8134AA31,	{ 0xE1, 0x99, 0xA9 },
	0x8134AA32,	{ 0xE1, 0x99, 0xAA },
	0x8134AA33,	{ 0xE1, 0x99, 0xAB },
	0x8134AA34,	{ 0xE1, 0x99, 0xAC },
	0x8134AA35,	{ 0xE1, 0x99, 0xAD },
	0x8134AA36,	{ 0xE1, 0x99, 0xAE },
	0x8134AA37,	{ 0xE1, 0x99, 0xAF },
	0x8134AA38,	{ 0xE1, 0x99, 0xB0 },
	0x8134AA39,	{ 0xE1, 0x99, 0xB1 },
	0x8134AB30,	{ 0xE1, 0x99, 0xB2 },
	0x8134AB31,	{ 0xE1, 0x99, 0xB3 },
	0x8134AB32,	{ 0xE1, 0x99, 0xB4 },
	0x8134AB33,	{ 0xE1, 0x99, 0xB5 },
	0x8134AB34,	{ 0xE1, 0x99, 0xB6 },
	0x8134AB35,	{ 0xE1, 0x99, 0xB7 },
	0x8134AB36,	{ 0xE1, 0x99, 0xB8 },
	0x8134AB37,	{ 0xE1, 0x99, 0xB9 },
	0x8134AB38,	{ 0xE1, 0x99, 0xBA },
	0x8134AB39,	{ 0xE1, 0x99, 0xBB },
	0x8134AC30,	{ 0xE1, 0x99, 0xBC },
	0x8134AC31,	{ 0xE1, 0x99, 0xBD },
	0x8134AC32,	{ 0xE1, 0x99, 0xBE },
	0x8134AC33,	{ 0xE1, 0x99, 0xBF },
	0x8134AC34,	{ 0xE1, 0x9A, 0x80 },
	0x8134AC35,	{ 0xE1, 0x9A, 0x81 },
	0x8134AC36,	{ 0xE1, 0x9A, 0x82 },
	0x8134AC37,	{ 0xE1, 0x9A, 0x83 },
	0x8134AC38,	{ 0xE1, 0x9A, 0x84 },
	0x8134AC39,	{ 0xE1, 0x9A, 0x85 },
	0x8134AD30,	{ 0xE1, 0x9A, 0x86 },
	0x8134AD31,	{ 0xE1, 0x9A, 0x87 },
	0x8134AD32,	{ 0xE1, 0x9A, 0x88 },
	0x8134AD33,	{ 0xE1, 0x9A, 0x89 },
	0x8134AD34,	{ 0xE1, 0x9A, 0x8A },
	0x8134AD35,	{ 0xE1, 0x9A, 0x8B },
	0x8134AD36,	{ 0xE1, 0x9A, 0x8C },
	0x8134AD37,	{ 0xE1, 0x9A, 0x8D },
	0x8134AD38,	{ 0xE1, 0x9A, 0x8E },
	0x8134AD39,	{ 0xE1, 0x9A, 0x8F },
	0x8134AE30,	{ 0xE1, 0x9A, 0x90 },
	0x8134AE31,	{ 0xE1, 0x9A, 0x91 },
	0x8134AE32,	{ 0xE1, 0x9A, 0x92 },
	0x8134AE33,	{ 0xE1, 0x9A, 0x93 },
	0x8134AE34,	{ 0xE1, 0x9A, 0x94 },
	0x8134AE35,	{ 0xE1, 0x9A, 0x95 },
	0x8134AE36,	{ 0xE1, 0x9A, 0x96 },
	0x8134AE37,	{ 0xE1, 0x9A, 0x97 },
	0x8134AE38,	{ 0xE1, 0x9A, 0x98 },
	0x8134AE39,	{ 0xE1, 0x9A, 0x99 },
	0x8134AF30,	{ 0xE1, 0x9A, 0x9A },
	0x8134AF31,	{ 0xE1, 0x9A, 0x9B },
	0x8134AF32,	{ 0xE1, 0x9A, 0x9C },
	0x8134AF33,	{ 0xE1, 0x9A, 0x9D },
	0x8134AF34,	{ 0xE1, 0x9A, 0x9E },
	0x8134AF35,	{ 0xE1, 0x9A, 0x9F },
	0x8134AF36,	{ 0xE1, 0x9A, 0xA0 },
	0x8134AF37,	{ 0xE1, 0x9A, 0xA1 },
	0x8134AF38,	{ 0xE1, 0x9A, 0xA2 },
	0x8134AF39,	{ 0xE1, 0x9A, 0xA3 },
	0x8134B030,	{ 0xE1, 0x9A, 0xA4 },
	0x8134B031,	{ 0xE1, 0x9A, 0xA5 },
	0x8134B032,	{ 0xE1, 0x9A, 0xA6 },
	0x8134B033,	{ 0xE1, 0x9A, 0xA7 },
	0x8134B034,	{ 0xE1, 0x9A, 0xA8 },
	0x8134B035,	{ 0xE1, 0x9A, 0xA9 },
	0x8134B036,	{ 0xE1, 0x9A, 0xAA },
	0x8134B037,	{ 0xE1, 0x9A, 0xAB },
	0x8134B038,	{ 0xE1, 0x9A, 0xAC },
	0x8134B039,	{ 0xE1, 0x9A, 0xAD },
	0x8134B130,	{ 0xE1, 0x9A, 0xAE },
	0x8134B131,	{ 0xE1, 0x9A, 0xAF },
	0x8134B132,	{ 0xE1, 0x9A, 0xB0 },
	0x8134B133,	{ 0xE1, 0x9A, 0xB1 },
	0x8134B134,	{ 0xE1, 0x9A, 0xB2 },
	0x8134B135,	{ 0xE1, 0x9A, 0xB3 },
	0x8134B136,	{ 0xE1, 0x9A, 0xB4 },
	0x8134B137,	{ 0xE1, 0x9A, 0xB5 },
	0x8134B138,	{ 0xE1, 0x9A, 0xB6 },
	0x8134B139,	{ 0xE1, 0x9A, 0xB7 },
	0x8134B230,	{ 0xE1, 0x9A, 0xB8 },
	0x8134B231,	{ 0xE1, 0x9A, 0xB9 },
	0x8134B232,	{ 0xE1, 0x9A, 0xBA },
	0x8134B233,	{ 0xE1, 0x9A, 0xBB },
	0x8134B234,	{ 0xE1, 0x9A, 0xBC },
	0x8134B235,	{ 0xE1, 0x9A, 0xBD },
	0x8134B236,	{ 0xE1, 0x9A, 0xBE },
	0x8134B237,	{ 0xE1, 0x9A, 0xBF },
	0x8134B238,	{ 0xE1, 0x9B, 0x80 },
	0x8134B239,	{ 0xE1, 0x9B, 0x81 },
	0x8134B330,	{ 0xE1, 0x9B, 0x82 },
	0x8134B331,	{ 0xE1, 0x9B, 0x83 },
	0x8134B332,	{ 0xE1, 0x9B, 0x84 },
	0x8134B333,	{ 0xE1, 0x9B, 0x85 },
	0x8134B334,	{ 0xE1, 0x9B, 0x86 },
	0x8134B335,	{ 0xE1, 0x9B, 0x87 },
	0x8134B336,	{ 0xE1, 0x9B, 0x88 },
	0x8134B337,	{ 0xE1, 0x9B, 0x89 },
	0x8134B338,	{ 0xE1, 0x9B, 0x8A },
	0x8134B339,	{ 0xE1, 0x9B, 0x8B },
	0x8134B430,	{ 0xE1, 0x9B, 0x8C },
	0x8134B431,	{ 0xE1, 0x9B, 0x8D },
	0x8134B432,	{ 0xE1, 0x9B, 0x8E },
	0x8134B433,	{ 0xE1, 0x9B, 0x8F },
	0x8134B434,	{ 0xE1, 0x9B, 0x90 },
	0x8134B435,	{ 0xE1, 0x9B, 0x91 },
	0x8134B436,	{ 0xE1, 0x9B, 0x92 },
	0x8134B437,	{ 0xE1, 0x9B, 0x93 },
	0x8134B438,	{ 0xE1, 0x9B, 0x94 },
	0x8134B439,	{ 0xE1, 0x9B, 0x95 },
	0x8134B530,	{ 0xE1, 0x9B, 0x96 },
	0x8134B531,	{ 0xE1, 0x9B, 0x97 },
	0x8134B532,	{ 0xE1, 0x9B, 0x98 },
	0x8134B533,	{ 0xE1, 0x9B, 0x99 },
	0x8134B534,	{ 0xE1, 0x9B, 0x9A },
	0x8134B535,	{ 0xE1, 0x9B, 0x9B },
	0x8134B536,	{ 0xE1, 0x9B, 0x9C },
	0x8134B537,	{ 0xE1, 0x9B, 0x9D },
	0x8134B538,	{ 0xE1, 0x9B, 0x9E },
	0x8134B539,	{ 0xE1, 0x9B, 0x9F },
	0x8134B630,	{ 0xE1, 0x9B, 0xA0 },
	0x8134B631,	{ 0xE1, 0x9B, 0xA1 },
	0x8134B632,	{ 0xE1, 0x9B, 0xA2 },
	0x8134B633,	{ 0xE1, 0x9B, 0xA3 },
	0x8134B634,	{ 0xE1, 0x9B, 0xA4 },
	0x8134B635,	{ 0xE1, 0x9B, 0xA5 },
	0x8134B636,	{ 0xE1, 0x9B, 0xA6 },
	0x8134B637,	{ 0xE1, 0x9B, 0xA7 },
	0x8134B638,	{ 0xE1, 0x9B, 0xA8 },
	0x8134B639,	{ 0xE1, 0x9B, 0xA9 },
	0x8134B730,	{ 0xE1, 0x9B, 0xAA },
	0x8134B731,	{ 0xE1, 0x9B, 0xAB },
	0x8134B732,	{ 0xE1, 0x9B, 0xAC },
	0x8134B733,	{ 0xE1, 0x9B, 0xAD },
	0x8134B734,	{ 0xE1, 0x9B, 0xAE },
	0x8134B735,	{ 0xE1, 0x9B, 0xAF },
	0x8134B736,	{ 0xE1, 0x9B, 0xB0 },
	0x8134B737,	{ 0xE1, 0x9B, 0xB1 },
	0x8134B738,	{ 0xE1, 0x9B, 0xB2 },
	0x8134B739,	{ 0xE1, 0x9B, 0xB3 },
	0x8134B830,	{ 0xE1, 0x9B, 0xB4 },
	0x8134B831,	{ 0xE1, 0x9B, 0xB5 },
	0x8134B832,	{ 0xE1, 0x9B, 0xB6 },
	0x8134B833,	{ 0xE1, 0x9B, 0xB7 },
	0x8134B834,	{ 0xE1, 0x9B, 0xB8 },
	0x8134B835,	{ 0xE1, 0x9B, 0xB9 },
	0x8134B836,	{ 0xE1, 0x9B, 0xBA },
	0x8134B837,	{ 0xE1, 0x9B, 0xBB },
	0x8134B838,	{ 0xE1, 0x9B, 0xBC },
	0x8134B839,	{ 0xE1, 0x9B, 0xBD },
	0x8134B930,	{ 0xE1, 0x9B, 0xBE },
	0x8134B931,	{ 0xE1, 0x9B, 0xBF },
	0x8134B932,	{ 0xE1, 0x9C, 0x80 },
	0x8134B933,	{ 0xE1, 0x9C, 0x81 },
	0x8134B934,	{ 0xE1, 0x9C, 0x82 },
	0x8134B935,	{ 0xE1, 0x9C, 0x83 },
	0x8134B936,	{ 0xE1, 0x9C, 0x84 },
	0x8134B937,	{ 0xE1, 0x9C, 0x85 },
	0x8134B938,	{ 0xE1, 0x9C, 0x86 },
	0x8134B939,	{ 0xE1, 0x9C, 0x87 },
	0x8134BA30,	{ 0xE1, 0x9C, 0x88 },
	0x8134BA31,	{ 0xE1, 0x9C, 0x89 },
	0x8134BA32,	{ 0xE1, 0x9C, 0x8A },
	0x8134BA33,	{ 0xE1, 0x9C, 0x8B },
	0x8134BA34,	{ 0xE1, 0x9C, 0x8C },
	0x8134BA35,	{ 0xE1, 0x9C, 0x8D },
	0x8134BA36,	{ 0xE1, 0x9C, 0x8E },
	0x8134BA37,	{ 0xE1, 0x9C, 0x8F },
	0x8134BA38,	{ 0xE1, 0x9C, 0x90 },
	0x8134BA39,	{ 0xE1, 0x9C, 0x91 },
	0x8134BB30,	{ 0xE1, 0x9C, 0x92 },
	0x8134BB31,	{ 0xE1, 0x9C, 0x93 },
	0x8134BB32,	{ 0xE1, 0x9C, 0x94 },
	0x8134BB33,	{ 0xE1, 0x9C, 0x95 },
	0x8134BB34,	{ 0xE1, 0x9C, 0x96 },
	0x8134BB35,	{ 0xE1, 0x9C, 0x97 },
	0x8134BB36,	{ 0xE1, 0x9C, 0x98 },
	0x8134BB37,	{ 0xE1, 0x9C, 0x99 },
	0x8134BB38,	{ 0xE1, 0x9C, 0x9A },
	0x8134BB39,	{ 0xE1, 0x9C, 0x9B },
	0x8134BC30,	{ 0xE1, 0x9C, 0x9C },
	0x8134BC31,	{ 0xE1, 0x9C, 0x9D },
	0x8134BC32,	{ 0xE1, 0x9C, 0x9E },
	0x8134BC33,	{ 0xE1, 0x9C, 0x9F },
	0x8134BC34,	{ 0xE1, 0x9C, 0xA0 },
	0x8134BC35,	{ 0xE1, 0x9C, 0xA1 },
	0x8134BC36,	{ 0xE1, 0x9C, 0xA2 },
	0x8134BC37,	{ 0xE1, 0x9C, 0xA3 },
	0x8134BC38,	{ 0xE1, 0x9C, 0xA4 },
	0x8134BC39,	{ 0xE1, 0x9C, 0xA5 },
	0x8134BD30,	{ 0xE1, 0x9C, 0xA6 },
	0x8134BD31,	{ 0xE1, 0x9C, 0xA7 },
	0x8134BD32,	{ 0xE1, 0x9C, 0xA8 },
	0x8134BD33,	{ 0xE1, 0x9C, 0xA9 },
	0x8134BD34,	{ 0xE1, 0x9C, 0xAA },
	0x8134BD35,	{ 0xE1, 0x9C, 0xAB },
	0x8134BD36,	{ 0xE1, 0x9C, 0xAC },
	0x8134BD37,	{ 0xE1, 0x9C, 0xAD },
	0x8134BD38,	{ 0xE1, 0x9C, 0xAE },
	0x8134BD39,	{ 0xE1, 0x9C, 0xAF },
	0x8134BE30,	{ 0xE1, 0x9C, 0xB0 },
	0x8134BE31,	{ 0xE1, 0x9C, 0xB1 },
	0x8134BE32,	{ 0xE1, 0x9C, 0xB2 },
	0x8134BE33,	{ 0xE1, 0x9C, 0xB3 },
	0x8134BE34,	{ 0xE1, 0x9C, 0xB4 },
	0x8134BE35,	{ 0xE1, 0x9C, 0xB5 },
	0x8134BE36,	{ 0xE1, 0x9C, 0xB6 },
	0x8134BE37,	{ 0xE1, 0x9C, 0xB7 },
	0x8134BE38,	{ 0xE1, 0x9C, 0xB8 },
	0x8134BE39,	{ 0xE1, 0x9C, 0xB9 },
	0x8134BF30,	{ 0xE1, 0x9C, 0xBA },
	0x8134BF31,	{ 0xE1, 0x9C, 0xBB },
	0x8134BF32,	{ 0xE1, 0x9C, 0xBC },
	0x8134BF33,	{ 0xE1, 0x9C, 0xBD },
	0x8134BF34,	{ 0xE1, 0x9C, 0xBE },
	0x8134BF35,	{ 0xE1, 0x9C, 0xBF },
	0x8134BF36,	{ 0xE1, 0x9D, 0x80 },
	0x8134BF37,	{ 0xE1, 0x9D, 0x81 },
	0x8134BF38,	{ 0xE1, 0x9D, 0x82 },
	0x8134BF39,	{ 0xE1, 0x9D, 0x83 },
	0x8134C030,	{ 0xE1, 0x9D, 0x84 },
	0x8134C031,	{ 0xE1, 0x9D, 0x85 },
	0x8134C032,	{ 0xE1, 0x9D, 0x86 },
	0x8134C033,	{ 0xE1, 0x9D, 0x87 },
	0x8134C034,	{ 0xE1, 0x9D, 0x88 },
	0x8134C035,	{ 0xE1, 0x9D, 0x89 },
	0x8134C036,	{ 0xE1, 0x9D, 0x8A },
	0x8134C037,	{ 0xE1, 0x9D, 0x8B },
	0x8134C038,	{ 0xE1, 0x9D, 0x8C },
	0x8134C039,	{ 0xE1, 0x9D, 0x8D },
	0x8134C130,	{ 0xE1, 0x9D, 0x8E },
	0x8134C131,	{ 0xE1, 0x9D, 0x8F },
	0x8134C132,	{ 0xE1, 0x9D, 0x90 },
	0x8134C133,	{ 0xE1, 0x9D, 0x91 },
	0x8134C134,	{ 0xE1, 0x9D, 0x92 },
	0x8134C135,	{ 0xE1, 0x9D, 0x93 },
	0x8134C136,	{ 0xE1, 0x9D, 0x94 },
	0x8134C137,	{ 0xE1, 0x9D, 0x95 },
	0x8134C138,	{ 0xE1, 0x9D, 0x96 },
	0x8134C139,	{ 0xE1, 0x9D, 0x97 },
	0x8134C230,	{ 0xE1, 0x9D, 0x98 },
	0x8134C231,	{ 0xE1, 0x9D, 0x99 },
	0x8134C232,	{ 0xE1, 0x9D, 0x9A },
	0x8134C233,	{ 0xE1, 0x9D, 0x9B },
	0x8134C234,	{ 0xE1, 0x9D, 0x9C },
	0x8134C235,	{ 0xE1, 0x9D, 0x9D },
	0x8134C236,	{ 0xE1, 0x9D, 0x9E },
	0x8134C237,	{ 0xE1, 0x9D, 0x9F },
	0x8134C238,	{ 0xE1, 0x9D, 0xA0 },
	0x8134C239,	{ 0xE1, 0x9D, 0xA1 },
	0x8134C330,	{ 0xE1, 0x9D, 0xA2 },
	0x8134C331,	{ 0xE1, 0x9D, 0xA3 },
	0x8134C332,	{ 0xE1, 0x9D, 0xA4 },
	0x8134C333,	{ 0xE1, 0x9D, 0xA5 },
	0x8134C334,	{ 0xE1, 0x9D, 0xA6 },
	0x8134C335,	{ 0xE1, 0x9D, 0xA7 },
	0x8134C336,	{ 0xE1, 0x9D, 0xA8 },
	0x8134C337,	{ 0xE1, 0x9D, 0xA9 },
	0x8134C338,	{ 0xE1, 0x9D, 0xAA },
	0x8134C339,	{ 0xE1, 0x9D, 0xAB },
	0x8134C430,	{ 0xE1, 0x9D, 0xAC },
	0x8134C431,	{ 0xE1, 0x9D, 0xAD },
	0x8134C432,	{ 0xE1, 0x9D, 0xAE },
	0x8134C433,	{ 0xE1, 0x9D, 0xAF },
	0x8134C434,	{ 0xE1, 0x9D, 0xB0 },
	0x8134C435,	{ 0xE1, 0x9D, 0xB1 },
	0x8134C436,	{ 0xE1, 0x9D, 0xB2 },
	0x8134C437,	{ 0xE1, 0x9D, 0xB3 },
	0x8134C438,	{ 0xE1, 0x9D, 0xB4 },
	0x8134C439,	{ 0xE1, 0x9D, 0xB5 },
	0x8134C530,	{ 0xE1, 0x9D, 0xB6 },
	0x8134C531,	{ 0xE1, 0x9D, 0xB7 },
	0x8134C532,	{ 0xE1, 0x9D, 0xB8 },
	0x8134C533,	{ 0xE1, 0x9D, 0xB9 },
	0x8134C534,	{ 0xE1, 0x9D, 0xBA },
	0x8134C535,	{ 0xE1, 0x9D, 0xBB },
	0x8134C536,	{ 0xE1, 0x9D, 0xBC },
	0x8134C537,	{ 0xE1, 0x9D, 0xBD },
	0x8134C538,	{ 0xE1, 0x9D, 0xBE },
	0x8134C539,	{ 0xE1, 0x9D, 0xBF },
	0x8134C630,	{ 0xE1, 0x9E, 0x80 },
	0x8134C631,	{ 0xE1, 0x9E, 0x81 },
	0x8134C632,	{ 0xE1, 0x9E, 0x82 },
	0x8134C633,	{ 0xE1, 0x9E, 0x83 },
	0x8134C634,	{ 0xE1, 0x9E, 0x84 },
	0x8134C635,	{ 0xE1, 0x9E, 0x85 },
	0x8134C636,	{ 0xE1, 0x9E, 0x86 },
	0x8134C637,	{ 0xE1, 0x9E, 0x87 },
	0x8134C638,	{ 0xE1, 0x9E, 0x88 },
	0x8134C639,	{ 0xE1, 0x9E, 0x89 },
	0x8134C730,	{ 0xE1, 0x9E, 0x8A },
	0x8134C731,	{ 0xE1, 0x9E, 0x8B },
	0x8134C732,	{ 0xE1, 0x9E, 0x8C },
	0x8134C733,	{ 0xE1, 0x9E, 0x8D },
	0x8134C734,	{ 0xE1, 0x9E, 0x8E },
	0x8134C735,	{ 0xE1, 0x9E, 0x8F },
	0x8134C736,	{ 0xE1, 0x9E, 0x90 },
	0x8134C737,	{ 0xE1, 0x9E, 0x91 },
	0x8134C738,	{ 0xE1, 0x9E, 0x92 },
	0x8134C739,	{ 0xE1, 0x9E, 0x93 },
	0x8134C830,	{ 0xE1, 0x9E, 0x94 },
	0x8134C831,	{ 0xE1, 0x9E, 0x95 },
	0x8134C832,	{ 0xE1, 0x9E, 0x96 },
	0x8134C833,	{ 0xE1, 0x9E, 0x97 },
	0x8134C834,	{ 0xE1, 0x9E, 0x98 },
	0x8134C835,	{ 0xE1, 0x9E, 0x99 },
	0x8134C836,	{ 0xE1, 0x9E, 0x9A },
	0x8134C837,	{ 0xE1, 0x9E, 0x9B },
	0x8134C838,	{ 0xE1, 0x9E, 0x9C },
	0x8134C839,	{ 0xE1, 0x9E, 0x9D },
	0x8134C930,	{ 0xE1, 0x9E, 0x9E },
	0x8134C931,	{ 0xE1, 0x9E, 0x9F },
	0x8134C932,	{ 0xE1, 0x9E, 0xA0 },
	0x8134C933,	{ 0xE1, 0x9E, 0xA1 },
	0x8134C934,	{ 0xE1, 0x9E, 0xA2 },
	0x8134C935,	{ 0xE1, 0x9E, 0xA3 },
	0x8134C936,	{ 0xE1, 0x9E, 0xA4 },
	0x8134C937,	{ 0xE1, 0x9E, 0xA5 },
	0x8134C938,	{ 0xE1, 0x9E, 0xA6 },
	0x8134C939,	{ 0xE1, 0x9E, 0xA7 },
	0x8134CA30,	{ 0xE1, 0x9E, 0xA8 },
	0x8134CA31,	{ 0xE1, 0x9E, 0xA9 },
	0x8134CA32,	{ 0xE1, 0x9E, 0xAA },
	0x8134CA33,	{ 0xE1, 0x9E, 0xAB },
	0x8134CA34,	{ 0xE1, 0x9E, 0xAC },
	0x8134CA35,	{ 0xE1, 0x9E, 0xAD },
	0x8134CA36,	{ 0xE1, 0x9E, 0xAE },
	0x8134CA37,	{ 0xE1, 0x9E, 0xAF },
	0x8134CA38,	{ 0xE1, 0x9E, 0xB0 },
	0x8134CA39,	{ 0xE1, 0x9E, 0xB1 },
	0x8134CB30,	{ 0xE1, 0x9E, 0xB2 },
	0x8134CB31,	{ 0xE1, 0x9E, 0xB3 },
	0x8134CB32,	{ 0xE1, 0x9E, 0xB4 },
	0x8134CB33,	{ 0xE1, 0x9E, 0xB5 },
	0x8134CB34,	{ 0xE1, 0x9E, 0xB6 },
	0x8134CB35,	{ 0xE1, 0x9E, 0xB7 },
	0x8134CB36,	{ 0xE1, 0x9E, 0xB8 },
	0x8134CB37,	{ 0xE1, 0x9E, 0xB9 },
	0x8134CB38,	{ 0xE1, 0x9E, 0xBA },
	0x8134CB39,	{ 0xE1, 0x9E, 0xBB },
	0x8134CC30,	{ 0xE1, 0x9E, 0xBC },
	0x8134CC31,	{ 0xE1, 0x9E, 0xBD },
	0x8134CC32,	{ 0xE1, 0x9E, 0xBE },
	0x8134CC33,	{ 0xE1, 0x9E, 0xBF },
	0x8134CC34,	{ 0xE1, 0x9F, 0x80 },
	0x8134CC35,	{ 0xE1, 0x9F, 0x81 },
	0x8134CC36,	{ 0xE1, 0x9F, 0x82 },
	0x8134CC37,	{ 0xE1, 0x9F, 0x83 },
	0x8134CC38,	{ 0xE1, 0x9F, 0x84 },
	0x8134CC39,	{ 0xE1, 0x9F, 0x85 },
	0x8134CD30,	{ 0xE1, 0x9F, 0x86 },
	0x8134CD31,	{ 0xE1, 0x9F, 0x87 },
	0x8134CD32,	{ 0xE1, 0x9F, 0x88 },
	0x8134CD33,	{ 0xE1, 0x9F, 0x89 },
	0x8134CD34,	{ 0xE1, 0x9F, 0x8A },
	0x8134CD35,	{ 0xE1, 0x9F, 0x8B },
	0x8134CD36,	{ 0xE1, 0x9F, 0x8C },
	0x8134CD37,	{ 0xE1, 0x9F, 0x8D },
	0x8134CD38,	{ 0xE1, 0x9F, 0x8E },
	0x8134CD39,	{ 0xE1, 0x9F, 0x8F },
	0x8134CE30,	{ 0xE1, 0x9F, 0x90 },
	0x8134CE31,	{ 0xE1, 0x9F, 0x91 },
	0x8134CE32,	{ 0xE1, 0x9F, 0x92 },
	0x8134CE33,	{ 0xE1, 0x9F, 0x93 },
	0x8134CE34,	{ 0xE1, 0x9F, 0x94 },
	0x8134CE35,	{ 0xE1, 0x9F, 0x95 },
	0x8134CE36,	{ 0xE1, 0x9F, 0x96 },
	0x8134CE37,	{ 0xE1, 0x9F, 0x97 },
	0x8134CE38,	{ 0xE1, 0x9F, 0x98 },
	0x8134CE39,	{ 0xE1, 0x9F, 0x99 },
	0x8134CF30,	{ 0xE1, 0x9F, 0x9A },
	0x8134CF31,	{ 0xE1, 0x9F, 0x9B },
	0x8134CF32,	{ 0xE1, 0x9F, 0x9C },
	0x8134CF33,	{ 0xE1, 0x9F, 0x9D },
	0x8134CF34,	{ 0xE1, 0x9F, 0x9E },
	0x8134CF35,	{ 0xE1, 0x9F, 0x9F },
	0x8134CF36,	{ 0xE1, 0x9F, 0xA0 },
	0x8134CF37,	{ 0xE1, 0x9F, 0xA1 },
	0x8134CF38,	{ 0xE1, 0x9F, 0xA2 },
	0x8134CF39,	{ 0xE1, 0x9F, 0xA3 },
	0x8134D030,	{ 0xE1, 0x9F, 0xA4 },
	0x8134D031,	{ 0xE1, 0x9F, 0xA5 },
	0x8134D032,	{ 0xE1, 0x9F, 0xA6 },
	0x8134D033,	{ 0xE1, 0x9F, 0xA7 },
	0x8134D034,	{ 0xE1, 0x9F, 0xA8 },
	0x8134D035,	{ 0xE1, 0x9F, 0xA9 },
	0x8134D036,	{ 0xE1, 0x9F, 0xAA },
	0x8134D037,	{ 0xE1, 0x9F, 0xAB },
	0x8134D038,	{ 0xE1, 0x9F, 0xAC },
	0x8134D039,	{ 0xE1, 0x9F, 0xAD },
	0x8134D130,	{ 0xE1, 0x9F, 0xAE },
	0x8134D131,	{ 0xE1, 0x9F, 0xAF },
	0x8134D132,	{ 0xE1, 0x9F, 0xB0 },
	0x8134D133,	{ 0xE1, 0x9F, 0xB1 },
	0x8134D134,	{ 0xE1, 0x9F, 0xB2 },
	0x8134D135,	{ 0xE1, 0x9F, 0xB3 },
	0x8134D136,	{ 0xE1, 0x9F, 0xB4 },
	0x8134D137,	{ 0xE1, 0x9F, 0xB5 },
	0x8134D138,	{ 0xE1, 0x9F, 0xB6 },
	0x8134D139,	{ 0xE1, 0x9F, 0xB7 },
	0x8134D230,	{ 0xE1, 0x9F, 0xB8 },
	0x8134D231,	{ 0xE1, 0x9F, 0xB9 },
	0x8134D232,	{ 0xE1, 0x9F, 0xBA },
	0x8134D233,	{ 0xE1, 0x9F, 0xBB },
	0x8134D234,	{ 0xE1, 0x9F, 0xBC },
	0x8134D235,	{ 0xE1, 0x9F, 0xBD },
	0x8134D236,	{ 0xE1, 0x9F, 0xBE },
	0x8134D237,	{ 0xE1, 0x9F, 0xBF },
	0x8134D238,	{ 0xE1, 0xA0, 0x80 },
	0x8134D239,	{ 0xE1, 0xA0, 0x81 },
	0x8134D330,	{ 0xE1, 0xA0, 0x82 },
	0x8134D331,	{ 0xE1, 0xA0, 0x83 },
	0x8134D332,	{ 0xE1, 0xA0, 0x84 },
	0x8134D333,	{ 0xE1, 0xA0, 0x85 },
	0x8134D334,	{ 0xE1, 0xA0, 0x86 },
	0x8134D335,	{ 0xE1, 0xA0, 0x87 },
	0x8134D336,	{ 0xE1, 0xA0, 0x88 },
	0x8134D337,	{ 0xE1, 0xA0, 0x89 },
	0x8134D338,	{ 0xE1, 0xA0, 0x8A },
	0x8134D339,	{ 0xE1, 0xA0, 0x8B },
	0x8134D430,	{ 0xE1, 0xA0, 0x8C },
	0x8134D431,	{ 0xE1, 0xA0, 0x8D },
	0x8134D432,	{ 0xE1, 0xA0, 0x8E },
	0x8134D433,	{ 0xE1, 0xA0, 0x8F },
	0x8134D434,	{ 0xE1, 0xA0, 0x90 },
	0x8134D435,	{ 0xE1, 0xA0, 0x91 },
	0x8134D436,	{ 0xE1, 0xA0, 0x92 },
	0x8134D437,	{ 0xE1, 0xA0, 0x93 },
	0x8134D438,	{ 0xE1, 0xA0, 0x94 },
	0x8134D439,	{ 0xE1, 0xA0, 0x95 },
	0x8134D530,	{ 0xE1, 0xA0, 0x96 },
	0x8134D531,	{ 0xE1, 0xA0, 0x97 },
	0x8134D532,	{ 0xE1, 0xA0, 0x98 },
	0x8134D533,	{ 0xE1, 0xA0, 0x99 },
	0x8134D534,	{ 0xE1, 0xA0, 0x9A },
	0x8134D535,	{ 0xE1, 0xA0, 0x9B },
	0x8134D536,	{ 0xE1, 0xA0, 0x9C },
	0x8134D537,	{ 0xE1, 0xA0, 0x9D },
	0x8134D538,	{ 0xE1, 0xA0, 0x9E },
	0x8134D539,	{ 0xE1, 0xA0, 0x9F },
	0x8134D630,	{ 0xE1, 0xA0, 0xA0 },
	0x8134D631,	{ 0xE1, 0xA0, 0xA1 },
	0x8134D632,	{ 0xE1, 0xA0, 0xA2 },
	0x8134D633,	{ 0xE1, 0xA0, 0xA3 },
	0x8134D634,	{ 0xE1, 0xA0, 0xA4 },
	0x8134D635,	{ 0xE1, 0xA0, 0xA5 },
	0x8134D636,	{ 0xE1, 0xA0, 0xA6 },
	0x8134D637,	{ 0xE1, 0xA0, 0xA7 },
	0x8134D638,	{ 0xE1, 0xA0, 0xA8 },
	0x8134D639,	{ 0xE1, 0xA0, 0xA9 },
	0x8134D730,	{ 0xE1, 0xA0, 0xAA },
	0x8134D731,	{ 0xE1, 0xA0, 0xAB },
	0x8134D732,	{ 0xE1, 0xA0, 0xAC },
	0x8134D733,	{ 0xE1, 0xA0, 0xAD },
	0x8134D734,	{ 0xE1, 0xA0, 0xAE },
	0x8134D735,	{ 0xE1, 0xA0, 0xAF },
	0x8134D736,	{ 0xE1, 0xA0, 0xB0 },
	0x8134D737,	{ 0xE1, 0xA0, 0xB1 },
	0x8134D738,	{ 0xE1, 0xA0, 0xB2 },
	0x8134D739,	{ 0xE1, 0xA0, 0xB3 },
	0x8134D830,	{ 0xE1, 0xA0, 0xB4 },
	0x8134D831,	{ 0xE1, 0xA0, 0xB5 },
	0x8134D832,	{ 0xE1, 0xA0, 0xB6 },
	0x8134D833,	{ 0xE1, 0xA0, 0xB7 },
	0x8134D834,	{ 0xE1, 0xA0, 0xB8 },
	0x8134D835,	{ 0xE1, 0xA0, 0xB9 },
	0x8134D836,	{ 0xE1, 0xA0, 0xBA },
	0x8134D837,	{ 0xE1, 0xA0, 0xBB },
	0x8134D838,	{ 0xE1, 0xA0, 0xBC },
	0x8134D839,	{ 0xE1, 0xA0, 0xBD },
	0x8134D930,	{ 0xE1, 0xA0, 0xBE },
	0x8134D931,	{ 0xE1, 0xA0, 0xBF },
	0x8134D932,	{ 0xE1, 0xA1, 0x80 },
	0x8134D933,	{ 0xE1, 0xA1, 0x81 },
	0x8134D934,	{ 0xE1, 0xA1, 0x82 },
	0x8134D935,	{ 0xE1, 0xA1, 0x83 },
	0x8134D936,	{ 0xE1, 0xA1, 0x84 },
	0x8134D937,	{ 0xE1, 0xA1, 0x85 },
	0x8134D938,	{ 0xE1, 0xA1, 0x86 },
	0x8134D939,	{ 0xE1, 0xA1, 0x87 },
	0x8134DA30,	{ 0xE1, 0xA1, 0x88 },
	0x8134DA31,	{ 0xE1, 0xA1, 0x89 },
	0x8134DA32,	{ 0xE1, 0xA1, 0x8A },
	0x8134DA33,	{ 0xE1, 0xA1, 0x8B },
	0x8134DA34,	{ 0xE1, 0xA1, 0x8C },
	0x8134DA35,	{ 0xE1, 0xA1, 0x8D },
	0x8134DA36,	{ 0xE1, 0xA1, 0x8E },
	0x8134DA37,	{ 0xE1, 0xA1, 0x8F },
	0x8134DA38,	{ 0xE1, 0xA1, 0x90 },
	0x8134DA39,	{ 0xE1, 0xA1, 0x91 },
	0x8134DB30,	{ 0xE1, 0xA1, 0x92 },
	0x8134DB31,	{ 0xE1, 0xA1, 0x93 },
	0x8134DB32,	{ 0xE1, 0xA1, 0x94 },
	0x8134DB33,	{ 0xE1, 0xA1, 0x95 },
	0x8134DB34,	{ 0xE1, 0xA1, 0x96 },
	0x8134DB35,	{ 0xE1, 0xA1, 0x97 },
	0x8134DB36,	{ 0xE1, 0xA1, 0x98 },
	0x8134DB37,	{ 0xE1, 0xA1, 0x99 },
	0x8134DB38,	{ 0xE1, 0xA1, 0x9A },
	0x8134DB39,	{ 0xE1, 0xA1, 0x9B },
	0x8134DC30,	{ 0xE1, 0xA1, 0x9C },
	0x8134DC31,	{ 0xE1, 0xA1, 0x9D },
	0x8134DC32,	{ 0xE1, 0xA1, 0x9E },
	0x8134DC33,	{ 0xE1, 0xA1, 0x9F },
	0x8134DC34,	{ 0xE1, 0xA1, 0xA0 },
	0x8134DC35,	{ 0xE1, 0xA1, 0xA1 },
	0x8134DC36,	{ 0xE1, 0xA1, 0xA2 },
	0x8134DC37,	{ 0xE1, 0xA1, 0xA3 },
	0x8134DC38,	{ 0xE1, 0xA1, 0xA4 },
	0x8134DC39,	{ 0xE1, 0xA1, 0xA5 },
	0x8134DD30,	{ 0xE1, 0xA1, 0xA6 },
	0x8134DD31,	{ 0xE1, 0xA1, 0xA7 },
	0x8134DD32,	{ 0xE1, 0xA1, 0xA8 },
	0x8134DD33,	{ 0xE1, 0xA1, 0xA9 },
	0x8134DD34,	{ 0xE1, 0xA1, 0xAA },
	0x8134DD35,	{ 0xE1, 0xA1, 0xAB },
	0x8134DD36,	{ 0xE1, 0xA1, 0xAC },
	0x8134DD37,	{ 0xE1, 0xA1, 0xAD },
	0x8134DD38,	{ 0xE1, 0xA1, 0xAE },
	0x8134DD39,	{ 0xE1, 0xA1, 0xAF },
	0x8134DE30,	{ 0xE1, 0xA1, 0xB0 },
	0x8134DE31,	{ 0xE1, 0xA1, 0xB1 },
	0x8134DE32,	{ 0xE1, 0xA1, 0xB2 },
	0x8134DE33,	{ 0xE1, 0xA1, 0xB3 },
	0x8134DE34,	{ 0xE1, 0xA1, 0xB4 },
	0x8134DE35,	{ 0xE1, 0xA1, 0xB5 },
	0x8134DE36,	{ 0xE1, 0xA1, 0xB6 },
	0x8134DE37,	{ 0xE1, 0xA1, 0xB7 },
	0x8134DE38,	{ 0xE1, 0xA1, 0xB8 },
	0x8134DE39,	{ 0xE1, 0xA1, 0xB9 },
	0x8134DF30,	{ 0xE1, 0xA1, 0xBA },
	0x8134DF31,	{ 0xE1, 0xA1, 0xBB },
	0x8134DF32,	{ 0xE1, 0xA1, 0xBC },
	0x8134DF33,	{ 0xE1, 0xA1, 0xBD },
	0x8134DF34,	{ 0xE1, 0xA1, 0xBE },
	0x8134DF35,	{ 0xE1, 0xA1, 0xBF },
	0x8134DF36,	{ 0xE1, 0xA2, 0x80 },
	0x8134DF37,	{ 0xE1, 0xA2, 0x81 },
	0x8134DF38,	{ 0xE1, 0xA2, 0x82 },
	0x8134DF39,	{ 0xE1, 0xA2, 0x83 },
	0x8134E030,	{ 0xE1, 0xA2, 0x84 },
	0x8134E031,	{ 0xE1, 0xA2, 0x85 },
	0x8134E032,	{ 0xE1, 0xA2, 0x86 },
	0x8134E033,	{ 0xE1, 0xA2, 0x87 },
	0x8134E034,	{ 0xE1, 0xA2, 0x88 },
	0x8134E035,	{ 0xE1, 0xA2, 0x89 },
	0x8134E036,	{ 0xE1, 0xA2, 0x8A },
	0x8134E037,	{ 0xE1, 0xA2, 0x8B },
	0x8134E038,	{ 0xE1, 0xA2, 0x8C },
	0x8134E039,	{ 0xE1, 0xA2, 0x8D },
	0x8134E130,	{ 0xE1, 0xA2, 0x8E },
	0x8134E131,	{ 0xE1, 0xA2, 0x8F },
	0x8134E132,	{ 0xE1, 0xA2, 0x90 },
	0x8134E133,	{ 0xE1, 0xA2, 0x91 },
	0x8134E134,	{ 0xE1, 0xA2, 0x92 },
	0x8134E135,	{ 0xE1, 0xA2, 0x93 },
	0x8134E136,	{ 0xE1, 0xA2, 0x94 },
	0x8134E137,	{ 0xE1, 0xA2, 0x95 },
	0x8134E138,	{ 0xE1, 0xA2, 0x96 },
	0x8134E139,	{ 0xE1, 0xA2, 0x97 },
	0x8134E230,	{ 0xE1, 0xA2, 0x98 },
	0x8134E231,	{ 0xE1, 0xA2, 0x99 },
	0x8134E232,	{ 0xE1, 0xA2, 0x9A },
	0x8134E233,	{ 0xE1, 0xA2, 0x9B },
	0x8134E234,	{ 0xE1, 0xA2, 0x9C },
	0x8134E235,	{ 0xE1, 0xA2, 0x9D },
	0x8134E236,	{ 0xE1, 0xA2, 0x9E },
	0x8134E237,	{ 0xE1, 0xA2, 0x9F },
	0x8134E238,	{ 0xE1, 0xA2, 0xA0 },
	0x8134E239,	{ 0xE1, 0xA2, 0xA1 },
	0x8134E330,	{ 0xE1, 0xA2, 0xA2 },
	0x8134E331,	{ 0xE1, 0xA2, 0xA3 },
	0x8134E332,	{ 0xE1, 0xA2, 0xA4 },
	0x8134E333,	{ 0xE1, 0xA2, 0xA5 },
	0x8134E334,	{ 0xE1, 0xA2, 0xA6 },
	0x8134E335,	{ 0xE1, 0xA2, 0xA7 },
	0x8134E336,	{ 0xE1, 0xA2, 0xA8 },
	0x8134E337,	{ 0xE1, 0xA2, 0xA9 },
	0x8134E338,	{ 0xE1, 0xA2, 0xAA },
	0x8134E339,	{ 0xE1, 0xA2, 0xAB },
	0x8134E430,	{ 0xE1, 0xA2, 0xAC },
	0x8134E431,	{ 0xE1, 0xA2, 0xAD },
	0x8134E432,	{ 0xE1, 0xA2, 0xAE },
	0x8134E433,	{ 0xE1, 0xA2, 0xAF },
	0x8134E434,	{ 0xE1, 0xA2, 0xB0 },
	0x8134E435,	{ 0xE1, 0xA2, 0xB1 },
	0x8134E436,	{ 0xE1, 0xA2, 0xB2 },
	0x8134E437,	{ 0xE1, 0xA2, 0xB3 },
	0x8134E438,	{ 0xE1, 0xA2, 0xB4 },
	0x8134E439,	{ 0xE1, 0xA2, 0xB5 },
	0x8134E530,	{ 0xE1, 0xA2, 0xB6 },
	0x8134E531,	{ 0xE1, 0xA2, 0xB7 },
	0x8134E532,	{ 0xE1, 0xA2, 0xB8 },
	0x8134E533,	{ 0xE1, 0xA2, 0xB9 },
	0x8134E534,	{ 0xE1, 0xA2, 0xBA },
	0x8134E535,	{ 0xE1, 0xA2, 0xBB },
	0x8134E536,	{ 0xE1, 0xA2, 0xBC },
	0x8134E537,	{ 0xE1, 0xA2, 0xBD },
	0x8134E538,	{ 0xE1, 0xA2, 0xBE },
	0x8134E539,	{ 0xE1, 0xA2, 0xBF },
	0x8134E630,	{ 0xE1, 0xA3, 0x80 },
	0x8134E631,	{ 0xE1, 0xA3, 0x81 },
	0x8134E632,	{ 0xE1, 0xA3, 0x82 },
	0x8134E633,	{ 0xE1, 0xA3, 0x83 },
	0x8134E634,	{ 0xE1, 0xA3, 0x84 },
	0x8134E635,	{ 0xE1, 0xA3, 0x85 },
	0x8134E636,	{ 0xE1, 0xA3, 0x86 },
	0x8134E637,	{ 0xE1, 0xA3, 0x87 },
	0x8134E638,	{ 0xE1, 0xA3, 0x88 },
	0x8134E639,	{ 0xE1, 0xA3, 0x89 },
	0x8134E730,	{ 0xE1, 0xA3, 0x8A },
	0x8134E731,	{ 0xE1, 0xA3, 0x8B },
	0x8134E732,	{ 0xE1, 0xA3, 0x8C },
	0x8134E733,	{ 0xE1, 0xA3, 0x8D },
	0x8134E734,	{ 0xE1, 0xA3, 0x8E },
	0x8134E735,	{ 0xE1, 0xA3, 0x8F },
	0x8134E736,	{ 0xE1, 0xA3, 0x90 },
	0x8134E737,	{ 0xE1, 0xA3, 0x91 },
	0x8134E738,	{ 0xE1, 0xA3, 0x92 },
	0x8134E739,	{ 0xE1, 0xA3, 0x93 },
	0x8134E830,	{ 0xE1, 0xA3, 0x94 },
	0x8134E831,	{ 0xE1, 0xA3, 0x95 },
	0x8134E832,	{ 0xE1, 0xA3, 0x96 },
	0x8134E833,	{ 0xE1, 0xA3, 0x97 },
	0x8134E834,	{ 0xE1, 0xA3, 0x98 },
	0x8134E835,	{ 0xE1, 0xA3, 0x99 },
	0x8134E836,	{ 0xE1, 0xA3, 0x9A },
	0x8134E837,	{ 0xE1, 0xA3, 0x9B },
	0x8134E838,	{ 0xE1, 0xA3, 0x9C },
	0x8134E839,	{ 0xE1, 0xA3, 0x9D },
	0x8134E930,	{ 0xE1, 0xA3, 0x9E },
	0x8134E931,	{ 0xE1, 0xA3, 0x9F },
	0x8134E932,	{ 0xE1, 0xA3, 0xA0 },
	0x8134E933,	{ 0xE1, 0xA3, 0xA1 },
	0x8134E934,	{ 0xE1, 0xA3, 0xA2 },
	0x8134E935,	{ 0xE1, 0xA3, 0xA3 },
	0x8134E936,	{ 0xE1, 0xA3, 0xA4 },
	0x8134E937,	{ 0xE1, 0xA3, 0xA5 },
	0x8134E938,	{ 0xE1, 0xA3, 0xA6 },
	0x8134E939,	{ 0xE1, 0xA3, 0xA7 },
	0x8134EA30,	{ 0xE1, 0xA3, 0xA8 },
	0x8134EA31,	{ 0xE1, 0xA3, 0xA9 },
	0x8134EA32,	{ 0xE1, 0xA3, 0xAA },
	0x8134EA33,	{ 0xE1, 0xA3, 0xAB },
	0x8134EA34,	{ 0xE1, 0xA3, 0xAC },
	0x8134EA35,	{ 0xE1, 0xA3, 0xAD },
	0x8134EA36,	{ 0xE1, 0xA3, 0xAE },
	0x8134EA37,	{ 0xE1, 0xA3, 0xAF },
	0x8134EA38,	{ 0xE1, 0xA3, 0xB0 },
	0x8134EA39,	{ 0xE1, 0xA3, 0xB1 },
	0x8134EB30,	{ 0xE1, 0xA3, 0xB2 },
	0x8134EB31,	{ 0xE1, 0xA3, 0xB3 },
	0x8134EB32,	{ 0xE1, 0xA3, 0xB4 },
	0x8134EB33,	{ 0xE1, 0xA3, 0xB5 },
	0x8134EB34,	{ 0xE1, 0xA3, 0xB6 },
	0x8134EB35,	{ 0xE1, 0xA3, 0xB7 },
	0x8134EB36,	{ 0xE1, 0xA3, 0xB8 },
	0x8134EB37,	{ 0xE1, 0xA3, 0xB9 },
	0x8134EB38,	{ 0xE1, 0xA3, 0xBA },
	0x8134EB39,	{ 0xE1, 0xA3, 0xBB },
	0x8134EC30,	{ 0xE1, 0xA3, 0xBC },
	0x8134EC31,	{ 0xE1, 0xA3, 0xBD },
	0x8134EC32,	{ 0xE1, 0xA3, 0xBE },
	0x8134EC33,	{ 0xE1, 0xA3, 0xBF },
	0x8134EC34,	{ 0xE1, 0xA4, 0x80 },
	0x8134EC35,	{ 0xE1, 0xA4, 0x81 },
	0x8134EC36,	{ 0xE1, 0xA4, 0x82 },
	0x8134EC37,	{ 0xE1, 0xA4, 0x83 },
	0x8134EC38,	{ 0xE1, 0xA4, 0x84 },
	0x8134EC39,	{ 0xE1, 0xA4, 0x85 },
	0x8134ED30,	{ 0xE1, 0xA4, 0x86 },
	0x8134ED31,	{ 0xE1, 0xA4, 0x87 },
	0x8134ED32,	{ 0xE1, 0xA4, 0x88 },
	0x8134ED33,	{ 0xE1, 0xA4, 0x89 },
	0x8134ED34,	{ 0xE1, 0xA4, 0x8A },
	0x8134ED35,	{ 0xE1, 0xA4, 0x8B },
	0x8134ED36,	{ 0xE1, 0xA4, 0x8C },
	0x8134ED37,	{ 0xE1, 0xA4, 0x8D },
	0x8134ED38,	{ 0xE1, 0xA4, 0x8E },
	0x8134ED39,	{ 0xE1, 0xA4, 0x8F },
	0x8134EE30,	{ 0xE1, 0xA4, 0x90 },
	0x8134EE31,	{ 0xE1, 0xA4, 0x91 },
	0x8134EE32,	{ 0xE1, 0xA4, 0x92 },
	0x8134EE33,	{ 0xE1, 0xA4, 0x93 },
	0x8134EE34,	{ 0xE1, 0xA4, 0x94 },
	0x8134EE35,	{ 0xE1, 0xA4, 0x95 },
	0x8134EE36,	{ 0xE1, 0xA4, 0x96 },
	0x8134EE37,	{ 0xE1, 0xA4, 0x97 },
	0x8134EE38,	{ 0xE1, 0xA4, 0x98 },
	0x8134EE39,	{ 0xE1, 0xA4, 0x99 },
	0x8134EF30,	{ 0xE1, 0xA4, 0x9A },
	0x8134EF31,	{ 0xE1, 0xA4, 0x9B },
	0x8134EF32,	{ 0xE1, 0xA4, 0x9C },
	0x8134EF33,	{ 0xE1, 0xA4, 0x9D },
	0x8134EF34,	{ 0xE1, 0xA4, 0x9E },
	0x8134EF35,	{ 0xE1, 0xA4, 0x9F },
	0x8134EF36,	{ 0xE1, 0xA4, 0xA0 },
	0x8134EF37,	{ 0xE1, 0xA4, 0xA1 },
	0x8134EF38,	{ 0xE1, 0xA4, 0xA2 },
	0x8134EF39,	{ 0xE1, 0xA4, 0xA3 },
	0x8134F030,	{ 0xE1, 0xA4, 0xA4 },
	0x8134F031,	{ 0xE1, 0xA4, 0xA5 },
	0x8134F032,	{ 0xE1, 0xA4, 0xA6 },
	0x8134F033,	{ 0xE1, 0xA4, 0xA7 },
	0x8134F034,	{ 0xE1, 0xA4, 0xA8 },
	0x8134F035,	{ 0xE1, 0xA4, 0xA9 },
	0x8134F036,	{ 0xE1, 0xA4, 0xAA },
	0x8134F037,	{ 0xE1, 0xA4, 0xAB },
	0x8134F038,	{ 0xE1, 0xA4, 0xAC },
	0x8134F039,	{ 0xE1, 0xA4, 0xAD },
	0x8134F130,	{ 0xE1, 0xA4, 0xAE },
	0x8134F131,	{ 0xE1, 0xA4, 0xAF },
	0x8134F132,	{ 0xE1, 0xA4, 0xB0 },
	0x8134F133,	{ 0xE1, 0xA4, 0xB1 },
	0x8134F134,	{ 0xE1, 0xA4, 0xB2 },
	0x8134F135,	{ 0xE1, 0xA4, 0xB3 },
	0x8134F136,	{ 0xE1, 0xA4, 0xB4 },
	0x8134F137,	{ 0xE1, 0xA4, 0xB5 },
	0x8134F138,	{ 0xE1, 0xA4, 0xB6 },
	0x8134F139,	{ 0xE1, 0xA4, 0xB7 },
	0x8134F230,	{ 0xE1, 0xA4, 0xB8 },
	0x8134F231,	{ 0xE1, 0xA4, 0xB9 },
	0x8134F232,	{ 0xE1, 0xA4, 0xBA },
	0x8134F233,	{ 0xE1, 0xA4, 0xBB },
	0x8134F234,	{ 0xE1, 0xA4, 0xBC },
	0x8134F235,	{ 0xE1, 0xA4, 0xBD },
	0x8134F236,	{ 0xE1, 0xA4, 0xBE },
	0x8134F237,	{ 0xE1, 0xA4, 0xBF },
	0x8134F238,	{ 0xE1, 0xA5, 0x80 },
	0x8134F239,	{ 0xE1, 0xA5, 0x81 },
	0x8134F330,	{ 0xE1, 0xA5, 0x82 },
	0x8134F331,	{ 0xE1, 0xA5, 0x83 },
	0x8134F332,	{ 0xE1, 0xA5, 0x84 },
	0x8134F333,	{ 0xE1, 0xA5, 0x85 },
	0x8134F334,	{ 0xE1, 0xA5, 0x86 },
	0x8134F335,	{ 0xE1, 0xA5, 0x87 },
	0x8134F336,	{ 0xE1, 0xA5, 0x88 },
	0x8134F337,	{ 0xE1, 0xA5, 0x89 },
	0x8134F338,	{ 0xE1, 0xA5, 0x8A },
	0x8134F339,	{ 0xE1, 0xA5, 0x8B },
	0x8134F430,	{ 0xE1, 0xA5, 0x8C },
	0x8134F431,	{ 0xE1, 0xA5, 0x8D },
	0x8134F432,	{ 0xE1, 0xA5, 0x8E },
	0x8134F433,	{ 0xE1, 0xA5, 0x8F },
	0x8134F434,	{ 0xE1, 0xA5, 0x90 },
	0x8134F435,	{ 0xE1, 0xA5, 0x91 },
	0x8134F436,	{ 0xE1, 0xA5, 0x92 },
	0x8134F437,	{ 0xE1, 0xA5, 0x93 },
	0x8134F438,	{ 0xE1, 0xA5, 0x94 },
	0x8134F439,	{ 0xE1, 0xA5, 0x95 },
	0x8134F530,	{ 0xE1, 0xA5, 0x96 },
	0x8134F531,	{ 0xE1, 0xA5, 0x97 },
	0x8134F532,	{ 0xE1, 0xA5, 0x98 },
	0x8134F533,	{ 0xE1, 0xA5, 0x99 },
	0x8134F534,	{ 0xE1, 0xA5, 0x9A },
	0x8134F535,	{ 0xE1, 0xA5, 0x9B },
	0x8134F536,	{ 0xE1, 0xA5, 0x9C },
	0x8134F537,	{ 0xE1, 0xA5, 0x9D },
	0x8134F538,	{ 0xE1, 0xA5, 0x9E },
	0x8134F539,	{ 0xE1, 0xA5, 0x9F },
	0x8134F630,	{ 0xE1, 0xA5, 0xA0 },
	0x8134F631,	{ 0xE1, 0xA5, 0xA1 },
	0x8134F632,	{ 0xE1, 0xA5, 0xA2 },
	0x8134F633,	{ 0xE1, 0xA5, 0xA3 },
	0x8134F634,	{ 0xE1, 0xA5, 0xA4 },
	0x8134F635,	{ 0xE1, 0xA5, 0xA5 },
	0x8134F636,	{ 0xE1, 0xA5, 0xA6 },
	0x8134F637,	{ 0xE1, 0xA5, 0xA7 },
	0x8134F638,	{ 0xE1, 0xA5, 0xA8 },
	0x8134F639,	{ 0xE1, 0xA5, 0xA9 },
	0x8134F730,	{ 0xE1, 0xA5, 0xAA },
	0x8134F731,	{ 0xE1, 0xA5, 0xAB },
	0x8134F732,	{ 0xE1, 0xA5, 0xAC },
	0x8134F733,	{ 0xE1, 0xA5, 0xAD },
	0x8134F734,	{ 0xE1, 0xA5, 0xAE },
	0x8134F735,	{ 0xE1, 0xA5, 0xAF },
	0x8134F736,	{ 0xE1, 0xA5, 0xB0 },
	0x8134F737,	{ 0xE1, 0xA5, 0xB1 },
	0x8134F738,	{ 0xE1, 0xA5, 0xB2 },
	0x8134F739,	{ 0xE1, 0xA5, 0xB3 },
	0x8134F830,	{ 0xE1, 0xA5, 0xB4 },
	0x8134F831,	{ 0xE1, 0xA5, 0xB5 },
	0x8134F832,	{ 0xE1, 0xA5, 0xB6 },
	0x8134F833,	{ 0xE1, 0xA5, 0xB7 },
	0x8134F834,	{ 0xE1, 0xA5, 0xB8 },
	0x8134F835,	{ 0xE1, 0xA5, 0xB9 },
	0x8134F836,	{ 0xE1, 0xA5, 0xBA },
	0x8134F837,	{ 0xE1, 0xA5, 0xBB },
	0x8134F838,	{ 0xE1, 0xA5, 0xBC },
	0x8134F839,	{ 0xE1, 0xA5, 0xBD },
	0x8134F930,	{ 0xE1, 0xA5, 0xBE },
	0x8134F931,	{ 0xE1, 0xA5, 0xBF },
	0x8134F932,	{ 0xE1, 0xA6, 0x80 },
	0x8134F933,	{ 0xE1, 0xA6, 0x81 },
	0x8134F934,	{ 0xE1, 0xA6, 0x82 },
	0x8134F935,	{ 0xE1, 0xA6, 0x83 },
	0x8134F936,	{ 0xE1, 0xA6, 0x84 },
	0x8134F937,	{ 0xE1, 0xA6, 0x85 },
	0x8134F938,	{ 0xE1, 0xA6, 0x86 },
	0x8134F939,	{ 0xE1, 0xA6, 0x87 },
	0x8134FA30,	{ 0xE1, 0xA6, 0x88 },
	0x8134FA31,	{ 0xE1, 0xA6, 0x89 },
	0x8134FA32,	{ 0xE1, 0xA6, 0x8A },
	0x8134FA33,	{ 0xE1, 0xA6, 0x8B },
	0x8134FA34,	{ 0xE1, 0xA6, 0x8C },
	0x8134FA35,	{ 0xE1, 0xA6, 0x8D },
	0x8134FA36,	{ 0xE1, 0xA6, 0x8E },
	0x8134FA37,	{ 0xE1, 0xA6, 0x8F },
	0x8134FA38,	{ 0xE1, 0xA6, 0x90 },
	0x8134FA39,	{ 0xE1, 0xA6, 0x91 },
	0x8134FB30,	{ 0xE1, 0xA6, 0x92 },
	0x8134FB31,	{ 0xE1, 0xA6, 0x93 },
	0x8134FB32,	{ 0xE1, 0xA6, 0x94 },
	0x8134FB33,	{ 0xE1, 0xA6, 0x95 },
	0x8134FB34,	{ 0xE1, 0xA6, 0x96 },
	0x8134FB35,	{ 0xE1, 0xA6, 0x97 },
	0x8134FB36,	{ 0xE1, 0xA6, 0x98 },
	0x8134FB37,	{ 0xE1, 0xA6, 0x99 },
	0x8134FB38,	{ 0xE1, 0xA6, 0x9A },
	0x8134FB39,	{ 0xE1, 0xA6, 0x9B },
	0x8134FC30,	{ 0xE1, 0xA6, 0x9C },
	0x8134FC31,	{ 0xE1, 0xA6, 0x9D },
	0x8134FC32,	{ 0xE1, 0xA6, 0x9E },
	0x8134FC33,	{ 0xE1, 0xA6, 0x9F },
	0x8134FC34,	{ 0xE1, 0xA6, 0xA0 },
	0x8134FC35,	{ 0xE1, 0xA6, 0xA1 },
	0x8134FC36,	{ 0xE1, 0xA6, 0xA2 },
	0x8134FC37,	{ 0xE1, 0xA6, 0xA3 },
	0x8134FC38,	{ 0xE1, 0xA6, 0xA4 },
	0x8134FC39,	{ 0xE1, 0xA6, 0xA5 },
	0x8134FD30,	{ 0xE1, 0xA6, 0xA6 },
	0x8134FD31,	{ 0xE1, 0xA6, 0xA7 },
	0x8134FD32,	{ 0xE1, 0xA6, 0xA8 },
	0x8134FD33,	{ 0xE1, 0xA6, 0xA9 },
	0x8134FD34,	{ 0xE1, 0xA6, 0xAA },
	0x8134FD35,	{ 0xE1, 0xA6, 0xAB },
	0x8134FD36,	{ 0xE1, 0xA6, 0xAC },
	0x8134FD37,	{ 0xE1, 0xA6, 0xAD },
	0x8134FD38,	{ 0xE1, 0xA6, 0xAE },
	0x8134FD39,	{ 0xE1, 0xA6, 0xAF },
	0x8134FE30,	{ 0xE1, 0xA6, 0xB0 },
	0x8134FE31,	{ 0xE1, 0xA6, 0xB1 },
	0x8134FE32,	{ 0xE1, 0xA6, 0xB2 },
	0x8134FE33,	{ 0xE1, 0xA6, 0xB3 },
	0x8134FE34,	{ 0xE1, 0xA6, 0xB4 },
	0x8134FE35,	{ 0xE1, 0xA6, 0xB5 },
	0x8134FE36,	{ 0xE1, 0xA6, 0xB6 },
	0x8134FE37,	{ 0xE1, 0xA6, 0xB7 },
	0x8134FE38,	{ 0xE1, 0xA6, 0xB8 },
	0x8134FE39,	{ 0xE1, 0xA6, 0xB9 },
	0x81358130,	{ 0xE1, 0xA6, 0xBA },
	0x81358131,	{ 0xE1, 0xA6, 0xBB },
	0x81358132,	{ 0xE1, 0xA6, 0xBC },
	0x81358133,	{ 0xE1, 0xA6, 0xBD },
	0x81358134,	{ 0xE1, 0xA6, 0xBE },
	0x81358135,	{ 0xE1, 0xA6, 0xBF },
	0x81358136,	{ 0xE1, 0xA7, 0x80 },
	0x81358137,	{ 0xE1, 0xA7, 0x81 },
	0x81358138,	{ 0xE1, 0xA7, 0x82 },
	0x81358139,	{ 0xE1, 0xA7, 0x83 },
	0x81358230,	{ 0xE1, 0xA7, 0x84 },
	0x81358231,	{ 0xE1, 0xA7, 0x85 },
	0x81358232,	{ 0xE1, 0xA7, 0x86 },
	0x81358233,	{ 0xE1, 0xA7, 0x87 },
	0x81358234,	{ 0xE1, 0xA7, 0x88 },
	0x81358235,	{ 0xE1, 0xA7, 0x89 },
	0x81358236,	{ 0xE1, 0xA7, 0x8A },
	0x81358237,	{ 0xE1, 0xA7, 0x8B },
	0x81358238,	{ 0xE1, 0xA7, 0x8C },
	0x81358239,	{ 0xE1, 0xA7, 0x8D },
	0x81358330,	{ 0xE1, 0xA7, 0x8E },
	0x81358331,	{ 0xE1, 0xA7, 0x8F },
	0x81358332,	{ 0xE1, 0xA7, 0x90 },
	0x81358333,	{ 0xE1, 0xA7, 0x91 },
	0x81358334,	{ 0xE1, 0xA7, 0x92 },
	0x81358335,	{ 0xE1, 0xA7, 0x93 },
	0x81358336,	{ 0xE1, 0xA7, 0x94 },
	0x81358337,	{ 0xE1, 0xA7, 0x95 },
	0x81358338,	{ 0xE1, 0xA7, 0x96 },
	0x81358339,	{ 0xE1, 0xA7, 0x97 },
	0x81358430,	{ 0xE1, 0xA7, 0x98 },
	0x81358431,	{ 0xE1, 0xA7, 0x99 },
	0x81358432,	{ 0xE1, 0xA7, 0x9A },
	0x81358433,	{ 0xE1, 0xA7, 0x9B },
	0x81358434,	{ 0xE1, 0xA7, 0x9C },
	0x81358435,	{ 0xE1, 0xA7, 0x9D },
	0x81358436,	{ 0xE1, 0xA7, 0x9E },
	0x81358437,	{ 0xE1, 0xA7, 0x9F },
	0x81358438,	{ 0xE1, 0xA7, 0xA0 },
	0x81358439,	{ 0xE1, 0xA7, 0xA1 },
	0x81358530,	{ 0xE1, 0xA7, 0xA2 },
	0x81358531,	{ 0xE1, 0xA7, 0xA3 },
	0x81358532,	{ 0xE1, 0xA7, 0xA4 },
	0x81358533,	{ 0xE1, 0xA7, 0xA5 },
	0x81358534,	{ 0xE1, 0xA7, 0xA6 },
	0x81358535,	{ 0xE1, 0xA7, 0xA7 },
	0x81358536,	{ 0xE1, 0xA7, 0xA8 },
	0x81358537,	{ 0xE1, 0xA7, 0xA9 },
	0x81358538,	{ 0xE1, 0xA7, 0xAA },
	0x81358539,	{ 0xE1, 0xA7, 0xAB },
	0x81358630,	{ 0xE1, 0xA7, 0xAC },
	0x81358631,	{ 0xE1, 0xA7, 0xAD },
	0x81358632,	{ 0xE1, 0xA7, 0xAE },
	0x81358633,	{ 0xE1, 0xA7, 0xAF },
	0x81358634,	{ 0xE1, 0xA7, 0xB0 },
	0x81358635,	{ 0xE1, 0xA7, 0xB1 },
	0x81358636,	{ 0xE1, 0xA7, 0xB2 },
	0x81358637,	{ 0xE1, 0xA7, 0xB3 },
	0x81358638,	{ 0xE1, 0xA7, 0xB4 },
	0x81358639,	{ 0xE1, 0xA7, 0xB5 },
	0x81358730,	{ 0xE1, 0xA7, 0xB6 },
	0x81358731,	{ 0xE1, 0xA7, 0xB7 },
	0x81358732,	{ 0xE1, 0xA7, 0xB8 },
	0x81358733,	{ 0xE1, 0xA7, 0xB9 },
	0x81358734,	{ 0xE1, 0xA7, 0xBA },
	0x81358735,	{ 0xE1, 0xA7, 0xBB },
	0x81358736,	{ 0xE1, 0xA7, 0xBC },
	0x81358737,	{ 0xE1, 0xA7, 0xBD },
	0x81358738,	{ 0xE1, 0xA7, 0xBE },
	0x81358739,	{ 0xE1, 0xA7, 0xBF },
	0x81358830,	{ 0xE1, 0xA8, 0x80 },
	0x81358831,	{ 0xE1, 0xA8, 0x81 },
	0x81358832,	{ 0xE1, 0xA8, 0x82 },
	0x81358833,	{ 0xE1, 0xA8, 0x83 },
	0x81358834,	{ 0xE1, 0xA8, 0x84 },
	0x81358835,	{ 0xE1, 0xA8, 0x85 },
	0x81358836,	{ 0xE1, 0xA8, 0x86 },
	0x81358837,	{ 0xE1, 0xA8, 0x87 },
	0x81358838,	{ 0xE1, 0xA8, 0x88 },
	0x81358839,	{ 0xE1, 0xA8, 0x89 },
	0x81358930,	{ 0xE1, 0xA8, 0x8A },
	0x81358931,	{ 0xE1, 0xA8, 0x8B },
	0x81358932,	{ 0xE1, 0xA8, 0x8C },
	0x81358933,	{ 0xE1, 0xA8, 0x8D },
	0x81358934,	{ 0xE1, 0xA8, 0x8E },
	0x81358935,	{ 0xE1, 0xA8, 0x8F },
	0x81358936,	{ 0xE1, 0xA8, 0x90 },
	0x81358937,	{ 0xE1, 0xA8, 0x91 },
	0x81358938,	{ 0xE1, 0xA8, 0x92 },
	0x81358939,	{ 0xE1, 0xA8, 0x93 },
	0x81358A30,	{ 0xE1, 0xA8, 0x94 },
	0x81358A31,	{ 0xE1, 0xA8, 0x95 },
	0x81358A32,	{ 0xE1, 0xA8, 0x96 },
	0x81358A33,	{ 0xE1, 0xA8, 0x97 },
	0x81358A34,	{ 0xE1, 0xA8, 0x98 },
	0x81358A35,	{ 0xE1, 0xA8, 0x99 },
	0x81358A36,	{ 0xE1, 0xA8, 0x9A },
	0x81358A37,	{ 0xE1, 0xA8, 0x9B },
	0x81358A38,	{ 0xE1, 0xA8, 0x9C },
	0x81358A39,	{ 0xE1, 0xA8, 0x9D },
	0x81358B30,	{ 0xE1, 0xA8, 0x9E },
	0x81358B31,	{ 0xE1, 0xA8, 0x9F },
	0x81358B32,	{ 0xE1, 0xA8, 0xA0 },
	0x81358B33,	{ 0xE1, 0xA8, 0xA1 },
	0x81358B34,	{ 0xE1, 0xA8, 0xA2 },
	0x81358B35,	{ 0xE1, 0xA8, 0xA3 },
	0x81358B36,	{ 0xE1, 0xA8, 0xA4 },
	0x81358B37,	{ 0xE1, 0xA8, 0xA5 },
	0x81358B38,	{ 0xE1, 0xA8, 0xA6 },
	0x81358B39,	{ 0xE1, 0xA8, 0xA7 },
	0x81358C30,	{ 0xE1, 0xA8, 0xA8 },
	0x81358C31,	{ 0xE1, 0xA8, 0xA9 },
	0x81358C32,	{ 0xE1, 0xA8, 0xAA },
	0x81358C33,	{ 0xE1, 0xA8, 0xAB },
	0x81358C34,	{ 0xE1, 0xA8, 0xAC },
	0x81358C35,	{ 0xE1, 0xA8, 0xAD },
	0x81358C36,	{ 0xE1, 0xA8, 0xAE },
	0x81358C37,	{ 0xE1, 0xA8, 0xAF },
	0x81358C38,	{ 0xE1, 0xA8, 0xB0 },
	0x81358C39,	{ 0xE1, 0xA8, 0xB1 },
	0x81358D30,	{ 0xE1, 0xA8, 0xB2 },
	0x81358D31,	{ 0xE1, 0xA8, 0xB3 },
	0x81358D32,	{ 0xE1, 0xA8, 0xB4 },
	0x81358D33,	{ 0xE1, 0xA8, 0xB5 },
	0x81358D34,	{ 0xE1, 0xA8, 0xB6 },
	0x81358D35,	{ 0xE1, 0xA8, 0xB7 },
	0x81358D36,	{ 0xE1, 0xA8, 0xB8 },
	0x81358D37,	{ 0xE1, 0xA8, 0xB9 },
	0x81358D38,	{ 0xE1, 0xA8, 0xBA },
	0x81358D39,	{ 0xE1, 0xA8, 0xBB },
	0x81358E30,	{ 0xE1, 0xA8, 0xBC },
	0x81358E31,	{ 0xE1, 0xA8, 0xBD },
	0x81358E32,	{ 0xE1, 0xA8, 0xBE },
	0x81358E33,	{ 0xE1, 0xA8, 0xBF },
	0x81358E34,	{ 0xE1, 0xA9, 0x80 },
	0x81358E35,	{ 0xE1, 0xA9, 0x81 },
	0x81358E36,	{ 0xE1, 0xA9, 0x82 },
	0x81358E37,	{ 0xE1, 0xA9, 0x83 },
	0x81358E38,	{ 0xE1, 0xA9, 0x84 },
	0x81358E39,	{ 0xE1, 0xA9, 0x85 },
	0x81358F30,	{ 0xE1, 0xA9, 0x86 },
	0x81358F31,	{ 0xE1, 0xA9, 0x87 },
	0x81358F32,	{ 0xE1, 0xA9, 0x88 },
	0x81358F33,	{ 0xE1, 0xA9, 0x89 },
	0x81358F34,	{ 0xE1, 0xA9, 0x8A },
	0x81358F35,	{ 0xE1, 0xA9, 0x8B },
	0x81358F36,	{ 0xE1, 0xA9, 0x8C },
	0x81358F37,	{ 0xE1, 0xA9, 0x8D },
	0x81358F38,	{ 0xE1, 0xA9, 0x8E },
	0x81358F39,	{ 0xE1, 0xA9, 0x8F },
	0x81359030,	{ 0xE1, 0xA9, 0x90 },
	0x81359031,	{ 0xE1, 0xA9, 0x91 },
	0x81359032,	{ 0xE1, 0xA9, 0x92 },
	0x81359033,	{ 0xE1, 0xA9, 0x93 },
	0x81359034,	{ 0xE1, 0xA9, 0x94 },
	0x81359035,	{ 0xE1, 0xA9, 0x95 },
	0x81359036,	{ 0xE1, 0xA9, 0x96 },
	0x81359037,	{ 0xE1, 0xA9, 0x97 },
	0x81359038,	{ 0xE1, 0xA9, 0x98 },
	0x81359039,	{ 0xE1, 0xA9, 0x99 },
	0x81359130,	{ 0xE1, 0xA9, 0x9A },
	0x81359131,	{ 0xE1, 0xA9, 0x9B },
	0x81359132,	{ 0xE1, 0xA9, 0x9C },
	0x81359133,	{ 0xE1, 0xA9, 0x9D },
	0x81359134,	{ 0xE1, 0xA9, 0x9E },
	0x81359135,	{ 0xE1, 0xA9, 0x9F },
	0x81359136,	{ 0xE1, 0xA9, 0xA0 },
	0x81359137,	{ 0xE1, 0xA9, 0xA1 },
	0x81359138,	{ 0xE1, 0xA9, 0xA2 },
	0x81359139,	{ 0xE1, 0xA9, 0xA3 },
	0x81359230,	{ 0xE1, 0xA9, 0xA4 },
	0x81359231,	{ 0xE1, 0xA9, 0xA5 },
	0x81359232,	{ 0xE1, 0xA9, 0xA6 },
	0x81359233,	{ 0xE1, 0xA9, 0xA7 },
	0x81359234,	{ 0xE1, 0xA9, 0xA8 },
	0x81359235,	{ 0xE1, 0xA9, 0xA9 },
	0x81359236,	{ 0xE1, 0xA9, 0xAA },
	0x81359237,	{ 0xE1, 0xA9, 0xAB },
	0x81359238,	{ 0xE1, 0xA9, 0xAC },
	0x81359239,	{ 0xE1, 0xA9, 0xAD },
	0x81359330,	{ 0xE1, 0xA9, 0xAE },
	0x81359331,	{ 0xE1, 0xA9, 0xAF },
	0x81359332,	{ 0xE1, 0xA9, 0xB0 },
	0x81359333,	{ 0xE1, 0xA9, 0xB1 },
	0x81359334,	{ 0xE1, 0xA9, 0xB2 },
	0x81359335,	{ 0xE1, 0xA9, 0xB3 },
	0x81359336,	{ 0xE1, 0xA9, 0xB4 },
	0x81359337,	{ 0xE1, 0xA9, 0xB5 },
	0x81359338,	{ 0xE1, 0xA9, 0xB6 },
	0x81359339,	{ 0xE1, 0xA9, 0xB7 },
	0x81359430,	{ 0xE1, 0xA9, 0xB8 },
	0x81359431,	{ 0xE1, 0xA9, 0xB9 },
	0x81359432,	{ 0xE1, 0xA9, 0xBA },
	0x81359433,	{ 0xE1, 0xA9, 0xBB },
	0x81359434,	{ 0xE1, 0xA9, 0xBC },
	0x81359435,	{ 0xE1, 0xA9, 0xBD },
	0x81359436,	{ 0xE1, 0xA9, 0xBE },
	0x81359437,	{ 0xE1, 0xA9, 0xBF },
	0x81359438,	{ 0xE1, 0xAA, 0x80 },
	0x81359439,	{ 0xE1, 0xAA, 0x81 },
	0x81359530,	{ 0xE1, 0xAA, 0x82 },
	0x81359531,	{ 0xE1, 0xAA, 0x83 },
	0x81359532,	{ 0xE1, 0xAA, 0x84 },
	0x81359533,	{ 0xE1, 0xAA, 0x85 },
	0x81359534,	{ 0xE1, 0xAA, 0x86 },
	0x81359535,	{ 0xE1, 0xAA, 0x87 },
	0x81359536,	{ 0xE1, 0xAA, 0x88 },
	0x81359537,	{ 0xE1, 0xAA, 0x89 },
	0x81359538,	{ 0xE1, 0xAA, 0x8A },
	0x81359539,	{ 0xE1, 0xAA, 0x8B },
	0x81359630,	{ 0xE1, 0xAA, 0x8C },
	0x81359631,	{ 0xE1, 0xAA, 0x8D },
	0x81359632,	{ 0xE1, 0xAA, 0x8E },
	0x81359633,	{ 0xE1, 0xAA, 0x8F },
	0x81359634,	{ 0xE1, 0xAA, 0x90 },
	0x81359635,	{ 0xE1, 0xAA, 0x91 },
	0x81359636,	{ 0xE1, 0xAA, 0x92 },
	0x81359637,	{ 0xE1, 0xAA, 0x93 },
	0x81359638,	{ 0xE1, 0xAA, 0x94 },
	0x81359639,	{ 0xE1, 0xAA, 0x95 },
	0x81359730,	{ 0xE1, 0xAA, 0x96 },
	0x81359731,	{ 0xE1, 0xAA, 0x97 },
	0x81359732,	{ 0xE1, 0xAA, 0x98 },
	0x81359733,	{ 0xE1, 0xAA, 0x99 },
	0x81359734,	{ 0xE1, 0xAA, 0x9A },
	0x81359735,	{ 0xE1, 0xAA, 0x9B },
	0x81359736,	{ 0xE1, 0xAA, 0x9C },
	0x81359737,	{ 0xE1, 0xAA, 0x9D },
	0x81359738,	{ 0xE1, 0xAA, 0x9E },
	0x81359739,	{ 0xE1, 0xAA, 0x9F },
	0x81359830,	{ 0xE1, 0xAA, 0xA0 },
	0x81359831,	{ 0xE1, 0xAA, 0xA1 },
	0x81359832,	{ 0xE1, 0xAA, 0xA2 },
	0x81359833,	{ 0xE1, 0xAA, 0xA3 },
	0x81359834,	{ 0xE1, 0xAA, 0xA4 },
	0x81359835,	{ 0xE1, 0xAA, 0xA5 },
	0x81359836,	{ 0xE1, 0xAA, 0xA6 },
	0x81359837,	{ 0xE1, 0xAA, 0xA7 },
	0x81359838,	{ 0xE1, 0xAA, 0xA8 },
	0x81359839,	{ 0xE1, 0xAA, 0xA9 },
	0x81359930,	{ 0xE1, 0xAA, 0xAA },
	0x81359931,	{ 0xE1, 0xAA, 0xAB },
	0x81359932,	{ 0xE1, 0xAA, 0xAC },
	0x81359933,	{ 0xE1, 0xAA, 0xAD },
	0x81359934,	{ 0xE1, 0xAA, 0xAE },
	0x81359935,	{ 0xE1, 0xAA, 0xAF },
	0x81359936,	{ 0xE1, 0xAA, 0xB0 },
	0x81359937,	{ 0xE1, 0xAA, 0xB1 },
	0x81359938,	{ 0xE1, 0xAA, 0xB2 },
	0x81359939,	{ 0xE1, 0xAA, 0xB3 },
	0x81359A30,	{ 0xE1, 0xAA, 0xB4 },
	0x81359A31,	{ 0xE1, 0xAA, 0xB5 },
	0x81359A32,	{ 0xE1, 0xAA, 0xB6 },
	0x81359A33,	{ 0xE1, 0xAA, 0xB7 },
	0x81359A34,	{ 0xE1, 0xAA, 0xB8 },
	0x81359A35,	{ 0xE1, 0xAA, 0xB9 },
	0x81359A36,	{ 0xE1, 0xAA, 0xBA },
	0x81359A37,	{ 0xE1, 0xAA, 0xBB },
	0x81359A38,	{ 0xE1, 0xAA, 0xBC },
	0x81359A39,	{ 0xE1, 0xAA, 0xBD },
	0x81359B30,	{ 0xE1, 0xAA, 0xBE },
	0x81359B31,	{ 0xE1, 0xAA, 0xBF },
	0x81359B32,	{ 0xE1, 0xAB, 0x80 },
	0x81359B33,	{ 0xE1, 0xAB, 0x81 },
	0x81359B34,	{ 0xE1, 0xAB, 0x82 },
	0x81359B35,	{ 0xE1, 0xAB, 0x83 },
	0x81359B36,	{ 0xE1, 0xAB, 0x84 },
	0x81359B37,	{ 0xE1, 0xAB, 0x85 },
	0x81359B38,	{ 0xE1, 0xAB, 0x86 },
	0x81359B39,	{ 0xE1, 0xAB, 0x87 },
	0x81359C30,	{ 0xE1, 0xAB, 0x88 },
	0x81359C31,	{ 0xE1, 0xAB, 0x89 },
	0x81359C32,	{ 0xE1, 0xAB, 0x8A },
	0x81359C33,	{ 0xE1, 0xAB, 0x8B },
	0x81359C34,	{ 0xE1, 0xAB, 0x8C },
	0x81359C35,	{ 0xE1, 0xAB, 0x8D },
	0x81359C36,	{ 0xE1, 0xAB, 0x8E },
	0x81359C37,	{ 0xE1, 0xAB, 0x8F },
	0x81359C38,	{ 0xE1, 0xAB, 0x90 },
	0x81359C39,	{ 0xE1, 0xAB, 0x91 },
	0x81359D30,	{ 0xE1, 0xAB, 0x92 },
	0x81359D31,	{ 0xE1, 0xAB, 0x93 },
	0x81359D32,	{ 0xE1, 0xAB, 0x94 },
	0x81359D33,	{ 0xE1, 0xAB, 0x95 },
	0x81359D34,	{ 0xE1, 0xAB, 0x96 },
	0x81359D35,	{ 0xE1, 0xAB, 0x97 },
	0x81359D36,	{ 0xE1, 0xAB, 0x98 },
	0x81359D37,	{ 0xE1, 0xAB, 0x99 },
	0x81359D38,	{ 0xE1, 0xAB, 0x9A },
	0x81359D39,	{ 0xE1, 0xAB, 0x9B },
	0x81359E30,	{ 0xE1, 0xAB, 0x9C },
	0x81359E31,	{ 0xE1, 0xAB, 0x9D },
	0x81359E32,	{ 0xE1, 0xAB, 0x9E },
	0x81359E33,	{ 0xE1, 0xAB, 0x9F },
	0x81359E34,	{ 0xE1, 0xAB, 0xA0 },
	0x81359E35,	{ 0xE1, 0xAB, 0xA1 },
	0x81359E36,	{ 0xE1, 0xAB, 0xA2 },
	0x81359E37,	{ 0xE1, 0xAB, 0xA3 },
	0x81359E38,	{ 0xE1, 0xAB, 0xA4 },
	0x81359E39,	{ 0xE1, 0xAB, 0xA5 },
	0x81359F30,	{ 0xE1, 0xAB, 0xA6 },
	0x81359F31,	{ 0xE1, 0xAB, 0xA7 },
	0x81359F32,	{ 0xE1, 0xAB, 0xA8 },
	0x81359F33,	{ 0xE1, 0xAB, 0xA9 },
	0x81359F34,	{ 0xE1, 0xAB, 0xAA },
	0x81359F35,	{ 0xE1, 0xAB, 0xAB },
	0x81359F36,	{ 0xE1, 0xAB, 0xAC },
	0x81359F37,	{ 0xE1, 0xAB, 0xAD },
	0x81359F38,	{ 0xE1, 0xAB, 0xAE },
	0x81359F39,	{ 0xE1, 0xAB, 0xAF },
	0x8135A030,	{ 0xE1, 0xAB, 0xB0 },
	0x8135A031,	{ 0xE1, 0xAB, 0xB1 },
	0x8135A032,	{ 0xE1, 0xAB, 0xB2 },
	0x8135A033,	{ 0xE1, 0xAB, 0xB3 },
	0x8135A034,	{ 0xE1, 0xAB, 0xB4 },
	0x8135A035,	{ 0xE1, 0xAB, 0xB5 },
	0x8135A036,	{ 0xE1, 0xAB, 0xB6 },
	0x8135A037,	{ 0xE1, 0xAB, 0xB7 },
	0x8135A038,	{ 0xE1, 0xAB, 0xB8 },
	0x8135A039,	{ 0xE1, 0xAB, 0xB9 },
	0x8135A130,	{ 0xE1, 0xAB, 0xBA },
	0x8135A131,	{ 0xE1, 0xAB, 0xBB },
	0x8135A132,	{ 0xE1, 0xAB, 0xBC },
	0x8135A133,	{ 0xE1, 0xAB, 0xBD },
	0x8135A134,	{ 0xE1, 0xAB, 0xBE },
	0x8135A135,	{ 0xE1, 0xAB, 0xBF },
	0x8135A136,	{ 0xE1, 0xAC, 0x80 },
	0x8135A137,	{ 0xE1, 0xAC, 0x81 },
	0x8135A138,	{ 0xE1, 0xAC, 0x82 },
	0x8135A139,	{ 0xE1, 0xAC, 0x83 },
	0x8135A230,	{ 0xE1, 0xAC, 0x84 },
	0x8135A231,	{ 0xE1, 0xAC, 0x85 },
	0x8135A232,	{ 0xE1, 0xAC, 0x86 },
	0x8135A233,	{ 0xE1, 0xAC, 0x87 },
	0x8135A234,	{ 0xE1, 0xAC, 0x88 },
	0x8135A235,	{ 0xE1, 0xAC, 0x89 },
	0x8135A236,	{ 0xE1, 0xAC, 0x8A },
	0x8135A237,	{ 0xE1, 0xAC, 0x8B },
	0x8135A238,	{ 0xE1, 0xAC, 0x8C },
	0x8135A239,	{ 0xE1, 0xAC, 0x8D },
	0x8135A330,	{ 0xE1, 0xAC, 0x8E },
	0x8135A331,	{ 0xE1, 0xAC, 0x8F },
	0x8135A332,	{ 0xE1, 0xAC, 0x90 },
	0x8135A333,	{ 0xE1, 0xAC, 0x91 },
	0x8135A334,	{ 0xE1, 0xAC, 0x92 },
	0x8135A335,	{ 0xE1, 0xAC, 0x93 },
	0x8135A336,	{ 0xE1, 0xAC, 0x94 },
	0x8135A337,	{ 0xE1, 0xAC, 0x95 },
	0x8135A338,	{ 0xE1, 0xAC, 0x96 },
	0x8135A339,	{ 0xE1, 0xAC, 0x97 },
	0x8135A430,	{ 0xE1, 0xAC, 0x98 },
	0x8135A431,	{ 0xE1, 0xAC, 0x99 },
	0x8135A432,	{ 0xE1, 0xAC, 0x9A },
	0x8135A433,	{ 0xE1, 0xAC, 0x9B },
	0x8135A434,	{ 0xE1, 0xAC, 0x9C },
	0x8135A435,	{ 0xE1, 0xAC, 0x9D },
	0x8135A436,	{ 0xE1, 0xAC, 0x9E },
	0x8135A437,	{ 0xE1, 0xAC, 0x9F },
	0x8135A438,	{ 0xE1, 0xAC, 0xA0 },
	0x8135A439,	{ 0xE1, 0xAC, 0xA1 },
	0x8135A530,	{ 0xE1, 0xAC, 0xA2 },
	0x8135A531,	{ 0xE1, 0xAC, 0xA3 },
	0x8135A532,	{ 0xE1, 0xAC, 0xA4 },
	0x8135A533,	{ 0xE1, 0xAC, 0xA5 },
	0x8135A534,	{ 0xE1, 0xAC, 0xA6 },
	0x8135A535,	{ 0xE1, 0xAC, 0xA7 },
	0x8135A536,	{ 0xE1, 0xAC, 0xA8 },
	0x8135A537,	{ 0xE1, 0xAC, 0xA9 },
	0x8135A538,	{ 0xE1, 0xAC, 0xAA },
	0x8135A539,	{ 0xE1, 0xAC, 0xAB },
	0x8135A630,	{ 0xE1, 0xAC, 0xAC },
	0x8135A631,	{ 0xE1, 0xAC, 0xAD },
	0x8135A632,	{ 0xE1, 0xAC, 0xAE },
	0x8135A633,	{ 0xE1, 0xAC, 0xAF },
	0x8135A634,	{ 0xE1, 0xAC, 0xB0 },
	0x8135A635,	{ 0xE1, 0xAC, 0xB1 },
	0x8135A636,	{ 0xE1, 0xAC, 0xB2 },
	0x8135A637,	{ 0xE1, 0xAC, 0xB3 },
	0x8135A638,	{ 0xE1, 0xAC, 0xB4 },
	0x8135A639,	{ 0xE1, 0xAC, 0xB5 },
	0x8135A730,	{ 0xE1, 0xAC, 0xB6 },
	0x8135A731,	{ 0xE1, 0xAC, 0xB7 },
	0x8135A732,	{ 0xE1, 0xAC, 0xB8 },
	0x8135A733,	{ 0xE1, 0xAC, 0xB9 },
	0x8135A734,	{ 0xE1, 0xAC, 0xBA },
	0x8135A735,	{ 0xE1, 0xAC, 0xBB },
	0x8135A736,	{ 0xE1, 0xAC, 0xBC },
	0x8135A737,	{ 0xE1, 0xAC, 0xBD },
	0x8135A738,	{ 0xE1, 0xAC, 0xBE },
	0x8135A739,	{ 0xE1, 0xAC, 0xBF },
	0x8135A830,	{ 0xE1, 0xAD, 0x80 },
	0x8135A831,	{ 0xE1, 0xAD, 0x81 },
	0x8135A832,	{ 0xE1, 0xAD, 0x82 },
	0x8135A833,	{ 0xE1, 0xAD, 0x83 },
	0x8135A834,	{ 0xE1, 0xAD, 0x84 },
	0x8135A835,	{ 0xE1, 0xAD, 0x85 },
	0x8135A836,	{ 0xE1, 0xAD, 0x86 },
	0x8135A837,	{ 0xE1, 0xAD, 0x87 },
	0x8135A838,	{ 0xE1, 0xAD, 0x88 },
	0x8135A839,	{ 0xE1, 0xAD, 0x89 },
	0x8135A930,	{ 0xE1, 0xAD, 0x8A },
	0x8135A931,	{ 0xE1, 0xAD, 0x8B },
	0x8135A932,	{ 0xE1, 0xAD, 0x8C },
	0x8135A933,	{ 0xE1, 0xAD, 0x8D },
	0x8135A934,	{ 0xE1, 0xAD, 0x8E },
	0x8135A935,	{ 0xE1, 0xAD, 0x8F },
	0x8135A936,	{ 0xE1, 0xAD, 0x90 },
	0x8135A937,	{ 0xE1, 0xAD, 0x91 },
	0x8135A938,	{ 0xE1, 0xAD, 0x92 },
	0x8135A939,	{ 0xE1, 0xAD, 0x93 },
	0x8135AA30,	{ 0xE1, 0xAD, 0x94 },
	0x8135AA31,	{ 0xE1, 0xAD, 0x95 },
	0x8135AA32,	{ 0xE1, 0xAD, 0x96 },
	0x8135AA33,	{ 0xE1, 0xAD, 0x97 },
	0x8135AA34,	{ 0xE1, 0xAD, 0x98 },
	0x8135AA35,	{ 0xE1, 0xAD, 0x99 },
	0x8135AA36,	{ 0xE1, 0xAD, 0x9A },
	0x8135AA37,	{ 0xE1, 0xAD, 0x9B },
	0x8135AA38,	{ 0xE1, 0xAD, 0x9C },
	0x8135AA39,	{ 0xE1, 0xAD, 0x9D },
	0x8135AB30,	{ 0xE1, 0xAD, 0x9E },
	0x8135AB31,	{ 0xE1, 0xAD, 0x9F },
	0x8135AB32,	{ 0xE1, 0xAD, 0xA0 },
	0x8135AB33,	{ 0xE1, 0xAD, 0xA1 },
	0x8135AB34,	{ 0xE1, 0xAD, 0xA2 },
	0x8135AB35,	{ 0xE1, 0xAD, 0xA3 },
	0x8135AB36,	{ 0xE1, 0xAD, 0xA4 },
	0x8135AB37,	{ 0xE1, 0xAD, 0xA5 },
	0x8135AB38,	{ 0xE1, 0xAD, 0xA6 },
	0x8135AB39,	{ 0xE1, 0xAD, 0xA7 },
	0x8135AC30,	{ 0xE1, 0xAD, 0xA8 },
	0x8135AC31,	{ 0xE1, 0xAD, 0xA9 },
	0x8135AC32,	{ 0xE1, 0xAD, 0xAA },
	0x8135AC33,	{ 0xE1, 0xAD, 0xAB },
	0x8135AC34,	{ 0xE1, 0xAD, 0xAC },
	0x8135AC35,	{ 0xE1, 0xAD, 0xAD },
	0x8135AC36,	{ 0xE1, 0xAD, 0xAE },
	0x8135AC37,	{ 0xE1, 0xAD, 0xAF },
	0x8135AC38,	{ 0xE1, 0xAD, 0xB0 },
	0x8135AC39,	{ 0xE1, 0xAD, 0xB1 },
	0x8135AD30,	{ 0xE1, 0xAD, 0xB2 },
	0x8135AD31,	{ 0xE1, 0xAD, 0xB3 },
	0x8135AD32,	{ 0xE1, 0xAD, 0xB4 },
	0x8135AD33,	{ 0xE1, 0xAD, 0xB5 },
	0x8135AD34,	{ 0xE1, 0xAD, 0xB6 },
	0x8135AD35,	{ 0xE1, 0xAD, 0xB7 },
	0x8135AD36,	{ 0xE1, 0xAD, 0xB8 },
	0x8135AD37,	{ 0xE1, 0xAD, 0xB9 },
	0x8135AD38,	{ 0xE1, 0xAD, 0xBA },
	0x8135AD39,	{ 0xE1, 0xAD, 0xBB },
	0x8135AE30,	{ 0xE1, 0xAD, 0xBC },
	0x8135AE31,	{ 0xE1, 0xAD, 0xBD },
	0x8135AE32,	{ 0xE1, 0xAD, 0xBE },
	0x8135AE33,	{ 0xE1, 0xAD, 0xBF },
	0x8135AE34,	{ 0xE1, 0xAE, 0x80 },
	0x8135AE35,	{ 0xE1, 0xAE, 0x81 },
	0x8135AE36,	{ 0xE1, 0xAE, 0x82 },
	0x8135AE37,	{ 0xE1, 0xAE, 0x83 },
	0x8135AE38,	{ 0xE1, 0xAE, 0x84 },
	0x8135AE39,	{ 0xE1, 0xAE, 0x85 },
	0x8135AF30,	{ 0xE1, 0xAE, 0x86 },
	0x8135AF31,	{ 0xE1, 0xAE, 0x87 },
	0x8135AF32,	{ 0xE1, 0xAE, 0x88 },
	0x8135AF33,	{ 0xE1, 0xAE, 0x89 },
	0x8135AF34,	{ 0xE1, 0xAE, 0x8A },
	0x8135AF35,	{ 0xE1, 0xAE, 0x8B },
	0x8135AF36,	{ 0xE1, 0xAE, 0x8C },
	0x8135AF37,	{ 0xE1, 0xAE, 0x8D },
	0x8135AF38,	{ 0xE1, 0xAE, 0x8E },
	0x8135AF39,	{ 0xE1, 0xAE, 0x8F },
	0x8135B030,	{ 0xE1, 0xAE, 0x90 },
	0x8135B031,	{ 0xE1, 0xAE, 0x91 },
	0x8135B032,	{ 0xE1, 0xAE, 0x92 },
	0x8135B033,	{ 0xE1, 0xAE, 0x93 },
	0x8135B034,	{ 0xE1, 0xAE, 0x94 },
	0x8135B035,	{ 0xE1, 0xAE, 0x95 },
	0x8135B036,	{ 0xE1, 0xAE, 0x96 },
	0x8135B037,	{ 0xE1, 0xAE, 0x97 },
	0x8135B038,	{ 0xE1, 0xAE, 0x98 },
	0x8135B039,	{ 0xE1, 0xAE, 0x99 },
	0x8135B130,	{ 0xE1, 0xAE, 0x9A },
	0x8135B131,	{ 0xE1, 0xAE, 0x9B },
	0x8135B132,	{ 0xE1, 0xAE, 0x9C },
	0x8135B133,	{ 0xE1, 0xAE, 0x9D },
	0x8135B134,	{ 0xE1, 0xAE, 0x9E },
	0x8135B135,	{ 0xE1, 0xAE, 0x9F },
	0x8135B136,	{ 0xE1, 0xAE, 0xA0 },
	0x8135B137,	{ 0xE1, 0xAE, 0xA1 },
	0x8135B138,	{ 0xE1, 0xAE, 0xA2 },
	0x8135B139,	{ 0xE1, 0xAE, 0xA3 },
	0x8135B230,	{ 0xE1, 0xAE, 0xA4 },
	0x8135B231,	{ 0xE1, 0xAE, 0xA5 },
	0x8135B232,	{ 0xE1, 0xAE, 0xA6 },
	0x8135B233,	{ 0xE1, 0xAE, 0xA7 },
	0x8135B234,	{ 0xE1, 0xAE, 0xA8 },
	0x8135B235,	{ 0xE1, 0xAE, 0xA9 },
	0x8135B236,	{ 0xE1, 0xAE, 0xAA },
	0x8135B237,	{ 0xE1, 0xAE, 0xAB },
	0x8135B238,	{ 0xE1, 0xAE, 0xAC },
	0x8135B239,	{ 0xE1, 0xAE, 0xAD },
	0x8135B330,	{ 0xE1, 0xAE, 0xAE },
	0x8135B331,	{ 0xE1, 0xAE, 0xAF },
	0x8135B332,	{ 0xE1, 0xAE, 0xB0 },
	0x8135B333,	{ 0xE1, 0xAE, 0xB1 },
	0x8135B334,	{ 0xE1, 0xAE, 0xB2 },
	0x8135B335,	{ 0xE1, 0xAE, 0xB3 },
	0x8135B336,	{ 0xE1, 0xAE, 0xB4 },
	0x8135B337,	{ 0xE1, 0xAE, 0xB5 },
	0x8135B338,	{ 0xE1, 0xAE, 0xB6 },
	0x8135B339,	{ 0xE1, 0xAE, 0xB7 },
	0x8135B430,	{ 0xE1, 0xAE, 0xB8 },
	0x8135B431,	{ 0xE1, 0xAE, 0xB9 },
	0x8135B432,	{ 0xE1, 0xAE, 0xBA },
	0x8135B433,	{ 0xE1, 0xAE, 0xBB },
	0x8135B434,	{ 0xE1, 0xAE, 0xBC },
	0x8135B435,	{ 0xE1, 0xAE, 0xBD },
	0x8135B436,	{ 0xE1, 0xAE, 0xBE },
	0x8135B437,	{ 0xE1, 0xAE, 0xBF },
	0x8135B438,	{ 0xE1, 0xAF, 0x80 },
	0x8135B439,	{ 0xE1, 0xAF, 0x81 },
	0x8135B530,	{ 0xE1, 0xAF, 0x82 },
	0x8135B531,	{ 0xE1, 0xAF, 0x83 },
	0x8135B532,	{ 0xE1, 0xAF, 0x84 },
	0x8135B533,	{ 0xE1, 0xAF, 0x85 },
	0x8135B534,	{ 0xE1, 0xAF, 0x86 },
	0x8135B535,	{ 0xE1, 0xAF, 0x87 },
	0x8135B536,	{ 0xE1, 0xAF, 0x88 },
	0x8135B537,	{ 0xE1, 0xAF, 0x89 },
	0x8135B538,	{ 0xE1, 0xAF, 0x8A },
	0x8135B539,	{ 0xE1, 0xAF, 0x8B },
	0x8135B630,	{ 0xE1, 0xAF, 0x8C },
	0x8135B631,	{ 0xE1, 0xAF, 0x8D },
	0x8135B632,	{ 0xE1, 0xAF, 0x8E },
	0x8135B633,	{ 0xE1, 0xAF, 0x8F },
	0x8135B634,	{ 0xE1, 0xAF, 0x90 },
	0x8135B635,	{ 0xE1, 0xAF, 0x91 },
	0x8135B636,	{ 0xE1, 0xAF, 0x92 },
	0x8135B637,	{ 0xE1, 0xAF, 0x93 },
	0x8135B638,	{ 0xE1, 0xAF, 0x94 },
	0x8135B639,	{ 0xE1, 0xAF, 0x95 },
	0x8135B730,	{ 0xE1, 0xAF, 0x96 },
	0x8135B731,	{ 0xE1, 0xAF, 0x97 },
	0x8135B732,	{ 0xE1, 0xAF, 0x98 },
	0x8135B733,	{ 0xE1, 0xAF, 0x99 },
	0x8135B734,	{ 0xE1, 0xAF, 0x9A },
	0x8135B735,	{ 0xE1, 0xAF, 0x9B },
	0x8135B736,	{ 0xE1, 0xAF, 0x9C },
	0x8135B737,	{ 0xE1, 0xAF, 0x9D },
	0x8135B738,	{ 0xE1, 0xAF, 0x9E },
	0x8135B739,	{ 0xE1, 0xAF, 0x9F },
	0x8135B830,	{ 0xE1, 0xAF, 0xA0 },
	0x8135B831,	{ 0xE1, 0xAF, 0xA1 },
	0x8135B832,	{ 0xE1, 0xAF, 0xA2 },
	0x8135B833,	{ 0xE1, 0xAF, 0xA3 },
	0x8135B834,	{ 0xE1, 0xAF, 0xA4 },
	0x8135B835,	{ 0xE1, 0xAF, 0xA5 },
	0x8135B836,	{ 0xE1, 0xAF, 0xA6 },
	0x8135B837,	{ 0xE1, 0xAF, 0xA7 },
	0x8135B838,	{ 0xE1, 0xAF, 0xA8 },
	0x8135B839,	{ 0xE1, 0xAF, 0xA9 },
	0x8135B930,	{ 0xE1, 0xAF, 0xAA },
	0x8135B931,	{ 0xE1, 0xAF, 0xAB },
	0x8135B932,	{ 0xE1, 0xAF, 0xAC },
	0x8135B933,	{ 0xE1, 0xAF, 0xAD },
	0x8135B934,	{ 0xE1, 0xAF, 0xAE },
	0x8135B935,	{ 0xE1, 0xAF, 0xAF },
	0x8135B936,	{ 0xE1, 0xAF, 0xB0 },
	0x8135B937,	{ 0xE1, 0xAF, 0xB1 },
	0x8135B938,	{ 0xE1, 0xAF, 0xB2 },
	0x8135B939,	{ 0xE1, 0xAF, 0xB3 },
	0x8135BA30,	{ 0xE1, 0xAF, 0xB4 },
	0x8135BA31,	{ 0xE1, 0xAF, 0xB5 },
	0x8135BA32,	{ 0xE1, 0xAF, 0xB6 },
	0x8135BA33,	{ 0xE1, 0xAF, 0xB7 },
	0x8135BA34,	{ 0xE1, 0xAF, 0xB8 },
	0x8135BA35,	{ 0xE1, 0xAF, 0xB9 },
	0x8135BA36,	{ 0xE1, 0xAF, 0xBA },
	0x8135BA37,	{ 0xE1, 0xAF, 0xBB },
	0x8135BA38,	{ 0xE1, 0xAF, 0xBC },
	0x8135BA39,	{ 0xE1, 0xAF, 0xBD },
	0x8135BB30,	{ 0xE1, 0xAF, 0xBE },
	0x8135BB31,	{ 0xE1, 0xAF, 0xBF },
	0x8135BB32,	{ 0xE1, 0xB0, 0x80 },
	0x8135BB33,	{ 0xE1, 0xB0, 0x81 },
	0x8135BB34,	{ 0xE1, 0xB0, 0x82 },
	0x8135BB35,	{ 0xE1, 0xB0, 0x83 },
	0x8135BB36,	{ 0xE1, 0xB0, 0x84 },
	0x8135BB37,	{ 0xE1, 0xB0, 0x85 },
	0x8135BB38,	{ 0xE1, 0xB0, 0x86 },
	0x8135BB39,	{ 0xE1, 0xB0, 0x87 },
	0x8135BC30,	{ 0xE1, 0xB0, 0x88 },
	0x8135BC31,	{ 0xE1, 0xB0, 0x89 },
	0x8135BC32,	{ 0xE1, 0xB0, 0x8A },
	0x8135BC33,	{ 0xE1, 0xB0, 0x8B },
	0x8135BC34,	{ 0xE1, 0xB0, 0x8C },
	0x8135BC35,	{ 0xE1, 0xB0, 0x8D },
	0x8135BC36,	{ 0xE1, 0xB0, 0x8E },
	0x8135BC37,	{ 0xE1, 0xB0, 0x8F },
	0x8135BC38,	{ 0xE1, 0xB0, 0x90 },
	0x8135BC39,	{ 0xE1, 0xB0, 0x91 },
	0x8135BD30,	{ 0xE1, 0xB0, 0x92 },
	0x8135BD31,	{ 0xE1, 0xB0, 0x93 },
	0x8135BD32,	{ 0xE1, 0xB0, 0x94 },
	0x8135BD33,	{ 0xE1, 0xB0, 0x95 },
	0x8135BD34,	{ 0xE1, 0xB0, 0x96 },
	0x8135BD35,	{ 0xE1, 0xB0, 0x97 },
	0x8135BD36,	{ 0xE1, 0xB0, 0x98 },
	0x8135BD37,	{ 0xE1, 0xB0, 0x99 },
	0x8135BD38,	{ 0xE1, 0xB0, 0x9A },
	0x8135BD39,	{ 0xE1, 0xB0, 0x9B },
	0x8135BE30,	{ 0xE1, 0xB0, 0x9C },
	0x8135BE31,	{ 0xE1, 0xB0, 0x9D },
	0x8135BE32,	{ 0xE1, 0xB0, 0x9E },
	0x8135BE33,	{ 0xE1, 0xB0, 0x9F },
	0x8135BE34,	{ 0xE1, 0xB0, 0xA0 },
	0x8135BE35,	{ 0xE1, 0xB0, 0xA1 },
	0x8135BE36,	{ 0xE1, 0xB0, 0xA2 },
	0x8135BE37,	{ 0xE1, 0xB0, 0xA3 },
	0x8135BE38,	{ 0xE1, 0xB0, 0xA4 },
	0x8135BE39,	{ 0xE1, 0xB0, 0xA5 },
	0x8135BF30,	{ 0xE1, 0xB0, 0xA6 },
	0x8135BF31,	{ 0xE1, 0xB0, 0xA7 },
	0x8135BF32,	{ 0xE1, 0xB0, 0xA8 },
	0x8135BF33,	{ 0xE1, 0xB0, 0xA9 },
	0x8135BF34,	{ 0xE1, 0xB0, 0xAA },
	0x8135BF35,	{ 0xE1, 0xB0, 0xAB },
	0x8135BF36,	{ 0xE1, 0xB0, 0xAC },
	0x8135BF37,	{ 0xE1, 0xB0, 0xAD },
	0x8135BF38,	{ 0xE1, 0xB0, 0xAE },
	0x8135BF39,	{ 0xE1, 0xB0, 0xAF },
	0x8135C030,	{ 0xE1, 0xB0, 0xB0 },
	0x8135C031,	{ 0xE1, 0xB0, 0xB1 },
	0x8135C032,	{ 0xE1, 0xB0, 0xB2 },
	0x8135C033,	{ 0xE1, 0xB0, 0xB3 },
	0x8135C034,	{ 0xE1, 0xB0, 0xB4 },
	0x8135C035,	{ 0xE1, 0xB0, 0xB5 },
	0x8135C036,	{ 0xE1, 0xB0, 0xB6 },
	0x8135C037,	{ 0xE1, 0xB0, 0xB7 },
	0x8135C038,	{ 0xE1, 0xB0, 0xB8 },
	0x8135C039,	{ 0xE1, 0xB0, 0xB9 },
	0x8135C130,	{ 0xE1, 0xB0, 0xBA },
	0x8135C131,	{ 0xE1, 0xB0, 0xBB },
	0x8135C132,	{ 0xE1, 0xB0, 0xBC },
	0x8135C133,	{ 0xE1, 0xB0, 0xBD },
	0x8135C134,	{ 0xE1, 0xB0, 0xBE },
	0x8135C135,	{ 0xE1, 0xB0, 0xBF },
	0x8135C136,	{ 0xE1, 0xB1, 0x80 },
	0x8135C137,	{ 0xE1, 0xB1, 0x81 },
	0x8135C138,	{ 0xE1, 0xB1, 0x82 },
	0x8135C139,	{ 0xE1, 0xB1, 0x83 },
	0x8135C230,	{ 0xE1, 0xB1, 0x84 },
	0x8135C231,	{ 0xE1, 0xB1, 0x85 },
	0x8135C232,	{ 0xE1, 0xB1, 0x86 },
	0x8135C233,	{ 0xE1, 0xB1, 0x87 },
	0x8135C234,	{ 0xE1, 0xB1, 0x88 },
	0x8135C235,	{ 0xE1, 0xB1, 0x89 },
	0x8135C236,	{ 0xE1, 0xB1, 0x8A },
	0x8135C237,	{ 0xE1, 0xB1, 0x8B },
	0x8135C238,	{ 0xE1, 0xB1, 0x8C },
	0x8135C239,	{ 0xE1, 0xB1, 0x8D },
	0x8135C330,	{ 0xE1, 0xB1, 0x8E },
	0x8135C331,	{ 0xE1, 0xB1, 0x8F },
	0x8135C332,	{ 0xE1, 0xB1, 0x90 },
	0x8135C333,	{ 0xE1, 0xB1, 0x91 },
	0x8135C334,	{ 0xE1, 0xB1, 0x92 },
	0x8135C335,	{ 0xE1, 0xB1, 0x93 },
	0x8135C336,	{ 0xE1, 0xB1, 0x94 },
	0x8135C337,	{ 0xE1, 0xB1, 0x95 },
	0x8135C338,	{ 0xE1, 0xB1, 0x96 },
	0x8135C339,	{ 0xE1, 0xB1, 0x97 },
	0x8135C430,	{ 0xE1, 0xB1, 0x98 },
	0x8135C431,	{ 0xE1, 0xB1, 0x99 },
	0x8135C432,	{ 0xE1, 0xB1, 0x9A },
	0x8135C433,	{ 0xE1, 0xB1, 0x9B },
	0x8135C434,	{ 0xE1, 0xB1, 0x9C },
	0x8135C435,	{ 0xE1, 0xB1, 0x9D },
	0x8135C436,	{ 0xE1, 0xB1, 0x9E },
	0x8135C437,	{ 0xE1, 0xB1, 0x9F },
	0x8135C438,	{ 0xE1, 0xB1, 0xA0 },
	0x8135C439,	{ 0xE1, 0xB1, 0xA1 },
	0x8135C530,	{ 0xE1, 0xB1, 0xA2 },
	0x8135C531,	{ 0xE1, 0xB1, 0xA3 },
	0x8135C532,	{ 0xE1, 0xB1, 0xA4 },
	0x8135C533,	{ 0xE1, 0xB1, 0xA5 },
	0x8135C534,	{ 0xE1, 0xB1, 0xA6 },
	0x8135C535,	{ 0xE1, 0xB1, 0xA7 },
	0x8135C536,	{ 0xE1, 0xB1, 0xA8 },
	0x8135C537,	{ 0xE1, 0xB1, 0xA9 },
	0x8135C538,	{ 0xE1, 0xB1, 0xAA },
	0x8135C539,	{ 0xE1, 0xB1, 0xAB },
	0x8135C630,	{ 0xE1, 0xB1, 0xAC },
	0x8135C631,	{ 0xE1, 0xB1, 0xAD },
	0x8135C632,	{ 0xE1, 0xB1, 0xAE },
	0x8135C633,	{ 0xE1, 0xB1, 0xAF },
	0x8135C634,	{ 0xE1, 0xB1, 0xB0 },
	0x8135C635,	{ 0xE1, 0xB1, 0xB1 },
	0x8135C636,	{ 0xE1, 0xB1, 0xB2 },
	0x8135C637,	{ 0xE1, 0xB1, 0xB3 },
	0x8135C638,	{ 0xE1, 0xB1, 0xB4 },
	0x8135C639,	{ 0xE1, 0xB1, 0xB5 },
	0x8135C730,	{ 0xE1, 0xB1, 0xB6 },
	0x8135C731,	{ 0xE1, 0xB1, 0xB7 },
	0x8135C732,	{ 0xE1, 0xB1, 0xB8 },
	0x8135C733,	{ 0xE1, 0xB1, 0xB9 },
	0x8135C734,	{ 0xE1, 0xB1, 0xBA },
	0x8135C735,	{ 0xE1, 0xB1, 0xBB },
	0x8135C736,	{ 0xE1, 0xB1, 0xBC },
	0x8135C737,	{ 0xE1, 0xB1, 0xBD },
	0x8135C738,	{ 0xE1, 0xB1, 0xBE },
	0x8135C739,	{ 0xE1, 0xB1, 0xBF },
	0x8135C830,	{ 0xE1, 0xB2, 0x80 },
	0x8135C831,	{ 0xE1, 0xB2, 0x81 },
	0x8135C832,	{ 0xE1, 0xB2, 0x82 },
	0x8135C833,	{ 0xE1, 0xB2, 0x83 },
	0x8135C834,	{ 0xE1, 0xB2, 0x84 },
	0x8135C835,	{ 0xE1, 0xB2, 0x85 },
	0x8135C836,	{ 0xE1, 0xB2, 0x86 },
	0x8135C837,	{ 0xE1, 0xB2, 0x87 },
	0x8135C838,	{ 0xE1, 0xB2, 0x88 },
	0x8135C839,	{ 0xE1, 0xB2, 0x89 },
	0x8135C930,	{ 0xE1, 0xB2, 0x8A },
	0x8135C931,	{ 0xE1, 0xB2, 0x8B },
	0x8135C932,	{ 0xE1, 0xB2, 0x8C },
	0x8135C933,	{ 0xE1, 0xB2, 0x8D },
	0x8135C934,	{ 0xE1, 0xB2, 0x8E },
	0x8135C935,	{ 0xE1, 0xB2, 0x8F },
	0x8135C936,	{ 0xE1, 0xB2, 0x90 },
	0x8135C937,	{ 0xE1, 0xB2, 0x91 },
	0x8135C938,	{ 0xE1, 0xB2, 0x92 },
	0x8135C939,	{ 0xE1, 0xB2, 0x93 },
	0x8135CA30,	{ 0xE1, 0xB2, 0x94 },
	0x8135CA31,	{ 0xE1, 0xB2, 0x95 },
	0x8135CA32,	{ 0xE1, 0xB2, 0x96 },
	0x8135CA33,	{ 0xE1, 0xB2, 0x97 },
	0x8135CA34,	{ 0xE1, 0xB2, 0x98 },
	0x8135CA35,	{ 0xE1, 0xB2, 0x99 },
	0x8135CA36,	{ 0xE1, 0xB2, 0x9A },
	0x8135CA37,	{ 0xE1, 0xB2, 0x9B },
	0x8135CA38,	{ 0xE1, 0xB2, 0x9C },
	0x8135CA39,	{ 0xE1, 0xB2, 0x9D },
	0x8135CB30,	{ 0xE1, 0xB2, 0x9E },
	0x8135CB31,	{ 0xE1, 0xB2, 0x9F },
	0x8135CB32,	{ 0xE1, 0xB2, 0xA0 },
	0x8135CB33,	{ 0xE1, 0xB2, 0xA1 },
	0x8135CB34,	{ 0xE1, 0xB2, 0xA2 },
	0x8135CB35,	{ 0xE1, 0xB2, 0xA3 },
	0x8135CB36,	{ 0xE1, 0xB2, 0xA4 },
	0x8135CB37,	{ 0xE1, 0xB2, 0xA5 },
	0x8135CB38,	{ 0xE1, 0xB2, 0xA6 },
	0x8135CB39,	{ 0xE1, 0xB2, 0xA7 },
	0x8135CC30,	{ 0xE1, 0xB2, 0xA8 },
	0x8135CC31,	{ 0xE1, 0xB2, 0xA9 },
	0x8135CC32,	{ 0xE1, 0xB2, 0xAA },
	0x8135CC33,	{ 0xE1, 0xB2, 0xAB },
	0x8135CC34,	{ 0xE1, 0xB2, 0xAC },
	0x8135CC35,	{ 0xE1, 0xB2, 0xAD },
	0x8135CC36,	{ 0xE1, 0xB2, 0xAE },
	0x8135CC37,	{ 0xE1, 0xB2, 0xAF },
	0x8135CC38,	{ 0xE1, 0xB2, 0xB0 },
	0x8135CC39,	{ 0xE1, 0xB2, 0xB1 },
	0x8135CD30,	{ 0xE1, 0xB2, 0xB2 },
	0x8135CD31,	{ 0xE1, 0xB2, 0xB3 },
	0x8135CD32,	{ 0xE1, 0xB2, 0xB4 },
	0x8135CD33,	{ 0xE1, 0xB2, 0xB5 },
	0x8135CD34,	{ 0xE1, 0xB2, 0xB6 },
	0x8135CD35,	{ 0xE1, 0xB2, 0xB7 },
	0x8135CD36,	{ 0xE1, 0xB2, 0xB8 },
	0x8135CD37,	{ 0xE1, 0xB2, 0xB9 },
	0x8135CD38,	{ 0xE1, 0xB2, 0xBA },
	0x8135CD39,	{ 0xE1, 0xB2, 0xBB },
	0x8135CE30,	{ 0xE1, 0xB2, 0xBC },
	0x8135CE31,	{ 0xE1, 0xB2, 0xBD },
	0x8135CE32,	{ 0xE1, 0xB2, 0xBE },
	0x8135CE33,	{ 0xE1, 0xB2, 0xBF },
	0x8135CE34,	{ 0xE1, 0xB3, 0x80 },
	0x8135CE35,	{ 0xE1, 0xB3, 0x81 },
	0x8135CE36,	{ 0xE1, 0xB3, 0x82 },
	0x8135CE37,	{ 0xE1, 0xB3, 0x83 },
	0x8135CE38,	{ 0xE1, 0xB3, 0x84 },
	0x8135CE39,	{ 0xE1, 0xB3, 0x85 },
	0x8135CF30,	{ 0xE1, 0xB3, 0x86 },
	0x8135CF31,	{ 0xE1, 0xB3, 0x87 },
	0x8135CF32,	{ 0xE1, 0xB3, 0x88 },
	0x8135CF33,	{ 0xE1, 0xB3, 0x89 },
	0x8135CF34,	{ 0xE1, 0xB3, 0x8A },
	0x8135CF35,	{ 0xE1, 0xB3, 0x8B },
	0x8135CF36,	{ 0xE1, 0xB3, 0x8C },
	0x8135CF37,	{ 0xE1, 0xB3, 0x8D },
	0x8135CF38,	{ 0xE1, 0xB3, 0x8E },
	0x8135CF39,	{ 0xE1, 0xB3, 0x8F },
	0x8135D030,	{ 0xE1, 0xB3, 0x90 },
	0x8135D031,	{ 0xE1, 0xB3, 0x91 },
	0x8135D032,	{ 0xE1, 0xB3, 0x92 },
	0x8135D033,	{ 0xE1, 0xB3, 0x93 },
	0x8135D034,	{ 0xE1, 0xB3, 0x94 },
	0x8135D035,	{ 0xE1, 0xB3, 0x95 },
	0x8135D036,	{ 0xE1, 0xB3, 0x96 },
	0x8135D037,	{ 0xE1, 0xB3, 0x97 },
	0x8135D038,	{ 0xE1, 0xB3, 0x98 },
	0x8135D039,	{ 0xE1, 0xB3, 0x99 },
	0x8135D130,	{ 0xE1, 0xB3, 0x9A },
	0x8135D131,	{ 0xE1, 0xB3, 0x9B },
	0x8135D132,	{ 0xE1, 0xB3, 0x9C },
	0x8135D133,	{ 0xE1, 0xB3, 0x9D },
	0x8135D134,	{ 0xE1, 0xB3, 0x9E },
	0x8135D135,	{ 0xE1, 0xB3, 0x9F },
	0x8135D136,	{ 0xE1, 0xB3, 0xA0 },
	0x8135D137,	{ 0xE1, 0xB3, 0xA1 },
	0x8135D138,	{ 0xE1, 0xB3, 0xA2 },
	0x8135D139,	{ 0xE1, 0xB3, 0xA3 },
	0x8135D230,	{ 0xE1, 0xB3, 0xA4 },
	0x8135D231,	{ 0xE1, 0xB3, 0xA5 },
	0x8135D232,	{ 0xE1, 0xB3, 0xA6 },
	0x8135D233,	{ 0xE1, 0xB3, 0xA7 },
	0x8135D234,	{ 0xE1, 0xB3, 0xA8 },
	0x8135D235,	{ 0xE1, 0xB3, 0xA9 },
	0x8135D236,	{ 0xE1, 0xB3, 0xAA },
	0x8135D237,	{ 0xE1, 0xB3, 0xAB },
	0x8135D238,	{ 0xE1, 0xB3, 0xAC },
	0x8135D239,	{ 0xE1, 0xB3, 0xAD },
	0x8135D330,	{ 0xE1, 0xB3, 0xAE },
	0x8135D331,	{ 0xE1, 0xB3, 0xAF },
	0x8135D332,	{ 0xE1, 0xB3, 0xB0 },
	0x8135D333,	{ 0xE1, 0xB3, 0xB1 },
	0x8135D334,	{ 0xE1, 0xB3, 0xB2 },
	0x8135D335,	{ 0xE1, 0xB3, 0xB3 },
	0x8135D336,	{ 0xE1, 0xB3, 0xB4 },
	0x8135D337,	{ 0xE1, 0xB3, 0xB5 },
	0x8135D338,	{ 0xE1, 0xB3, 0xB6 },
	0x8135D339,	{ 0xE1, 0xB3, 0xB7 },
	0x8135D430,	{ 0xE1, 0xB3, 0xB8 },
	0x8135D431,	{ 0xE1, 0xB3, 0xB9 },
	0x8135D432,	{ 0xE1, 0xB3, 0xBA },
	0x8135D433,	{ 0xE1, 0xB3, 0xBB },
	0x8135D434,	{ 0xE1, 0xB3, 0xBC },
	0x8135D435,	{ 0xE1, 0xB3, 0xBD },
	0x8135D436,	{ 0xE1, 0xB3, 0xBE },
	0x8135D437,	{ 0xE1, 0xB3, 0xBF },
	0x8135D438,	{ 0xE1, 0xB4, 0x80 },
	0x8135D439,	{ 0xE1, 0xB4, 0x81 },
	0x8135D530,	{ 0xE1, 0xB4, 0x82 },
	0x8135D531,	{ 0xE1, 0xB4, 0x83 },
	0x8135D532,	{ 0xE1, 0xB4, 0x84 },
	0x8135D533,	{ 0xE1, 0xB4, 0x85 },
	0x8135D534,	{ 0xE1, 0xB4, 0x86 },
	0x8135D535,	{ 0xE1, 0xB4, 0x87 },
	0x8135D536,	{ 0xE1, 0xB4, 0x88 },
	0x8135D537,	{ 0xE1, 0xB4, 0x89 },
	0x8135D538,	{ 0xE1, 0xB4, 0x8A },
	0x8135D539,	{ 0xE1, 0xB4, 0x8B },
	0x8135D630,	{ 0xE1, 0xB4, 0x8C },
	0x8135D631,	{ 0xE1, 0xB4, 0x8D },
	0x8135D632,	{ 0xE1, 0xB4, 0x8E },
	0x8135D633,	{ 0xE1, 0xB4, 0x8F },
	0x8135D634,	{ 0xE1, 0xB4, 0x90 },
	0x8135D635,	{ 0xE1, 0xB4, 0x91 },
	0x8135D636,	{ 0xE1, 0xB4, 0x92 },
	0x8135D637,	{ 0xE1, 0xB4, 0x93 },
	0x8135D638,	{ 0xE1, 0xB4, 0x94 },
	0x8135D639,	{ 0xE1, 0xB4, 0x95 },
	0x8135D730,	{ 0xE1, 0xB4, 0x96 },
	0x8135D731,	{ 0xE1, 0xB4, 0x97 },
	0x8135D732,	{ 0xE1, 0xB4, 0x98 },
	0x8135D733,	{ 0xE1, 0xB4, 0x99 },
	0x8135D734,	{ 0xE1, 0xB4, 0x9A },
	0x8135D735,	{ 0xE1, 0xB4, 0x9B },
	0x8135D736,	{ 0xE1, 0xB4, 0x9C },
	0x8135D737,	{ 0xE1, 0xB4, 0x9D },
	0x8135D738,	{ 0xE1, 0xB4, 0x9E },
	0x8135D739,	{ 0xE1, 0xB4, 0x9F },
	0x8135D830,	{ 0xE1, 0xB4, 0xA0 },
	0x8135D831,	{ 0xE1, 0xB4, 0xA1 },
	0x8135D832,	{ 0xE1, 0xB4, 0xA2 },
	0x8135D833,	{ 0xE1, 0xB4, 0xA3 },
	0x8135D834,	{ 0xE1, 0xB4, 0xA4 },
	0x8135D835,	{ 0xE1, 0xB4, 0xA5 },
	0x8135D836,	{ 0xE1, 0xB4, 0xA6 },
	0x8135D837,	{ 0xE1, 0xB4, 0xA7 },
	0x8135D838,	{ 0xE1, 0xB4, 0xA8 },
	0x8135D839,	{ 0xE1, 0xB4, 0xA9 },
	0x8135D930,	{ 0xE1, 0xB4, 0xAA },
	0x8135D931,	{ 0xE1, 0xB4, 0xAB },
	0x8135D932,	{ 0xE1, 0xB4, 0xAC },
	0x8135D933,	{ 0xE1, 0xB4, 0xAD },
	0x8135D934,	{ 0xE1, 0xB4, 0xAE },
	0x8135D935,	{ 0xE1, 0xB4, 0xAF },
	0x8135D936,	{ 0xE1, 0xB4, 0xB0 },
	0x8135D937,	{ 0xE1, 0xB4, 0xB1 },
	0x8135D938,	{ 0xE1, 0xB4, 0xB2 },
	0x8135D939,	{ 0xE1, 0xB4, 0xB3 },
	0x8135DA30,	{ 0xE1, 0xB4, 0xB4 },
	0x8135DA31,	{ 0xE1, 0xB4, 0xB5 },
	0x8135DA32,	{ 0xE1, 0xB4, 0xB6 },
	0x8135DA33,	{ 0xE1, 0xB4, 0xB7 },
	0x8135DA34,	{ 0xE1, 0xB4, 0xB8 },
	0x8135DA35,	{ 0xE1, 0xB4, 0xB9 },
	0x8135DA36,	{ 0xE1, 0xB4, 0xBA },
	0x8135DA37,	{ 0xE1, 0xB4, 0xBB },
	0x8135DA38,	{ 0xE1, 0xB4, 0xBC },
	0x8135DA39,	{ 0xE1, 0xB4, 0xBD },
	0x8135DB30,	{ 0xE1, 0xB4, 0xBE },
	0x8135DB31,	{ 0xE1, 0xB4, 0xBF },
	0x8135DB32,	{ 0xE1, 0xB5, 0x80 },
	0x8135DB33,	{ 0xE1, 0xB5, 0x81 },
	0x8135DB34,	{ 0xE1, 0xB5, 0x82 },
	0x8135DB35,	{ 0xE1, 0xB5, 0x83 },
	0x8135DB36,	{ 0xE1, 0xB5, 0x84 },
	0x8135DB37,	{ 0xE1, 0xB5, 0x85 },
	0x8135DB38,	{ 0xE1, 0xB5, 0x86 },
	0x8135DB39,	{ 0xE1, 0xB5, 0x87 },
	0x8135DC30,	{ 0xE1, 0xB5, 0x88 },
	0x8135DC31,	{ 0xE1, 0xB5, 0x89 },
	0x8135DC32,	{ 0xE1, 0xB5, 0x8A },
	0x8135DC33,	{ 0xE1, 0xB5, 0x8B },
	0x8135DC34,	{ 0xE1, 0xB5, 0x8C },
	0x8135DC35,	{ 0xE1, 0xB5, 0x8D },
	0x8135DC36,	{ 0xE1, 0xB5, 0x8E },
	0x8135DC37,	{ 0xE1, 0xB5, 0x8F },
	0x8135DC38,	{ 0xE1, 0xB5, 0x90 },
	0x8135DC39,	{ 0xE1, 0xB5, 0x91 },
	0x8135DD30,	{ 0xE1, 0xB5, 0x92 },
	0x8135DD31,	{ 0xE1, 0xB5, 0x93 },
	0x8135DD32,	{ 0xE1, 0xB5, 0x94 },
	0x8135DD33,	{ 0xE1, 0xB5, 0x95 },
	0x8135DD34,	{ 0xE1, 0xB5, 0x96 },
	0x8135DD35,	{ 0xE1, 0xB5, 0x97 },
	0x8135DD36,	{ 0xE1, 0xB5, 0x98 },
	0x8135DD37,	{ 0xE1, 0xB5, 0x99 },
	0x8135DD38,	{ 0xE1, 0xB5, 0x9A },
	0x8135DD39,	{ 0xE1, 0xB5, 0x9B },
	0x8135DE30,	{ 0xE1, 0xB5, 0x9C },
	0x8135DE31,	{ 0xE1, 0xB5, 0x9D },
	0x8135DE32,	{ 0xE1, 0xB5, 0x9E },
	0x8135DE33,	{ 0xE1, 0xB5, 0x9F },
	0x8135DE34,	{ 0xE1, 0xB5, 0xA0 },
	0x8135DE35,	{ 0xE1, 0xB5, 0xA1 },
	0x8135DE36,	{ 0xE1, 0xB5, 0xA2 },
	0x8135DE37,	{ 0xE1, 0xB5, 0xA3 },
	0x8135DE38,	{ 0xE1, 0xB5, 0xA4 },
	0x8135DE39,	{ 0xE1, 0xB5, 0xA5 },
	0x8135DF30,	{ 0xE1, 0xB5, 0xA6 },
	0x8135DF31,	{ 0xE1, 0xB5, 0xA7 },
	0x8135DF32,	{ 0xE1, 0xB5, 0xA8 },
	0x8135DF33,	{ 0xE1, 0xB5, 0xA9 },
	0x8135DF34,	{ 0xE1, 0xB5, 0xAA },
	0x8135DF35,	{ 0xE1, 0xB5, 0xAB },
	0x8135DF36,	{ 0xE1, 0xB5, 0xAC },
	0x8135DF37,	{ 0xE1, 0xB5, 0xAD },
	0x8135DF38,	{ 0xE1, 0xB5, 0xAE },
	0x8135DF39,	{ 0xE1, 0xB5, 0xAF },
	0x8135E030,	{ 0xE1, 0xB5, 0xB0 },
	0x8135E031,	{ 0xE1, 0xB5, 0xB1 },
	0x8135E032,	{ 0xE1, 0xB5, 0xB2 },
	0x8135E033,	{ 0xE1, 0xB5, 0xB3 },
	0x8135E034,	{ 0xE1, 0xB5, 0xB4 },
	0x8135E035,	{ 0xE1, 0xB5, 0xB5 },
	0x8135E036,	{ 0xE1, 0xB5, 0xB6 },
	0x8135E037,	{ 0xE1, 0xB5, 0xB7 },
	0x8135E038,	{ 0xE1, 0xB5, 0xB8 },
	0x8135E039,	{ 0xE1, 0xB5, 0xB9 },
	0x8135E130,	{ 0xE1, 0xB5, 0xBA },
	0x8135E131,	{ 0xE1, 0xB5, 0xBB },
	0x8135E132,	{ 0xE1, 0xB5, 0xBC },
	0x8135E133,	{ 0xE1, 0xB5, 0xBD },
	0x8135E134,	{ 0xE1, 0xB5, 0xBE },
	0x8135E135,	{ 0xE1, 0xB5, 0xBF },
	0x8135E136,	{ 0xE1, 0xB6, 0x80 },
	0x8135E137,	{ 0xE1, 0xB6, 0x81 },
	0x8135E138,	{ 0xE1, 0xB6, 0x82 },
	0x8135E139,	{ 0xE1, 0xB6, 0x83 },
	0x8135E230,	{ 0xE1, 0xB6, 0x84 },
	0x8135E231,	{ 0xE1, 0xB6, 0x85 },
	0x8135E232,	{ 0xE1, 0xB6, 0x86 },
	0x8135E233,	{ 0xE1, 0xB6, 0x87 },
	0x8135E234,	{ 0xE1, 0xB6, 0x88 },
	0x8135E235,	{ 0xE1, 0xB6, 0x89 },
	0x8135E236,	{ 0xE1, 0xB6, 0x8A },
	0x8135E237,	{ 0xE1, 0xB6, 0x8B },
	0x8135E238,	{ 0xE1, 0xB6, 0x8C },
	0x8135E239,	{ 0xE1, 0xB6, 0x8D },
	0x8135E330,	{ 0xE1, 0xB6, 0x8E },
	0x8135E331,	{ 0xE1, 0xB6, 0x8F },
	0x8135E332,	{ 0xE1, 0xB6, 0x90 },
	0x8135E333,	{ 0xE1, 0xB6, 0x91 },
	0x8135E334,	{ 0xE1, 0xB6, 0x92 },
	0x8135E335,	{ 0xE1, 0xB6, 0x93 },
	0x8135E336,	{ 0xE1, 0xB6, 0x94 },
	0x8135E337,	{ 0xE1, 0xB6, 0x95 },
	0x8135E338,	{ 0xE1, 0xB6, 0x96 },
	0x8135E339,	{ 0xE1, 0xB6, 0x97 },
	0x8135E430,	{ 0xE1, 0xB6, 0x98 },
	0x8135E431,	{ 0xE1, 0xB6, 0x99 },
	0x8135E432,	{ 0xE1, 0xB6, 0x9A },
	0x8135E433,	{ 0xE1, 0xB6, 0x9B },
	0x8135E434,	{ 0xE1, 0xB6, 0x9C },
	0x8135E435,	{ 0xE1, 0xB6, 0x9D },
	0x8135E436,	{ 0xE1, 0xB6, 0x9E },
	0x8135E437,	{ 0xE1, 0xB6, 0x9F },
	0x8135E438,	{ 0xE1, 0xB6, 0xA0 },
	0x8135E439,	{ 0xE1, 0xB6, 0xA1 },
	0x8135E530,	{ 0xE1, 0xB6, 0xA2 },
	0x8135E531,	{ 0xE1, 0xB6, 0xA3 },
	0x8135E532,	{ 0xE1, 0xB6, 0xA4 },
	0x8135E533,	{ 0xE1, 0xB6, 0xA5 },
	0x8135E534,	{ 0xE1, 0xB6, 0xA6 },
	0x8135E535,	{ 0xE1, 0xB6, 0xA7 },
	0x8135E536,	{ 0xE1, 0xB6, 0xA8 },
	0x8135E537,	{ 0xE1, 0xB6, 0xA9 },
	0x8135E538,	{ 0xE1, 0xB6, 0xAA },
	0x8135E539,	{ 0xE1, 0xB6, 0xAB },
	0x8135E630,	{ 0xE1, 0xB6, 0xAC },
	0x8135E631,	{ 0xE1, 0xB6, 0xAD },
	0x8135E632,	{ 0xE1, 0xB6, 0xAE },
	0x8135E633,	{ 0xE1, 0xB6, 0xAF },
	0x8135E634,	{ 0xE1, 0xB6, 0xB0 },
	0x8135E635,	{ 0xE1, 0xB6, 0xB1 },
	0x8135E636,	{ 0xE1, 0xB6, 0xB2 },
	0x8135E637,	{ 0xE1, 0xB6, 0xB3 },
	0x8135E638,	{ 0xE1, 0xB6, 0xB4 },
	0x8135E639,	{ 0xE1, 0xB6, 0xB5 },
	0x8135E730,	{ 0xE1, 0xB6, 0xB6 },
	0x8135E731,	{ 0xE1, 0xB6, 0xB7 },
	0x8135E732,	{ 0xE1, 0xB6, 0xB8 },
	0x8135E733,	{ 0xE1, 0xB6, 0xB9 },
	0x8135E734,	{ 0xE1, 0xB6, 0xBA },
	0x8135E735,	{ 0xE1, 0xB6, 0xBB },
	0x8135E736,	{ 0xE1, 0xB6, 0xBC },
	0x8135E737,	{ 0xE1, 0xB6, 0xBD },
	0x8135E738,	{ 0xE1, 0xB6, 0xBE },
	0x8135E739,	{ 0xE1, 0xB6, 0xBF },
	0x8135E830,	{ 0xE1, 0xB7, 0x80 },
	0x8135E831,	{ 0xE1, 0xB7, 0x81 },
	0x8135E832,	{ 0xE1, 0xB7, 0x82 },
	0x8135E833,	{ 0xE1, 0xB7, 0x83 },
	0x8135E834,	{ 0xE1, 0xB7, 0x84 },
	0x8135E835,	{ 0xE1, 0xB7, 0x85 },
	0x8135E836,	{ 0xE1, 0xB7, 0x86 },
	0x8135E837,	{ 0xE1, 0xB7, 0x87 },
	0x8135E838,	{ 0xE1, 0xB7, 0x88 },
	0x8135E839,	{ 0xE1, 0xB7, 0x89 },
	0x8135E930,	{ 0xE1, 0xB7, 0x8A },
	0x8135E931,	{ 0xE1, 0xB7, 0x8B },
	0x8135E932,	{ 0xE1, 0xB7, 0x8C },
	0x8135E933,	{ 0xE1, 0xB7, 0x8D },
	0x8135E934,	{ 0xE1, 0xB7, 0x8E },
	0x8135E935,	{ 0xE1, 0xB7, 0x8F },
	0x8135E936,	{ 0xE1, 0xB7, 0x90 },
	0x8135E937,	{ 0xE1, 0xB7, 0x91 },
	0x8135E938,	{ 0xE1, 0xB7, 0x92 },
	0x8135E939,	{ 0xE1, 0xB7, 0x93 },
	0x8135EA30,	{ 0xE1, 0xB7, 0x94 },
	0x8135EA31,	{ 0xE1, 0xB7, 0x95 },
	0x8135EA32,	{ 0xE1, 0xB7, 0x96 },
	0x8135EA33,	{ 0xE1, 0xB7, 0x97 },
	0x8135EA34,	{ 0xE1, 0xB7, 0x98 },
	0x8135EA35,	{ 0xE1, 0xB7, 0x99 },
	0x8135EA36,	{ 0xE1, 0xB7, 0x9A },
	0x8135EA37,	{ 0xE1, 0xB7, 0x9B },
	0x8135EA38,	{ 0xE1, 0xB7, 0x9C },
	0x8135EA39,	{ 0xE1, 0xB7, 0x9D },
	0x8135EB30,	{ 0xE1, 0xB7, 0x9E },
	0x8135EB31,	{ 0xE1, 0xB7, 0x9F },
	0x8135EB32,	{ 0xE1, 0xB7, 0xA0 },
	0x8135EB33,	{ 0xE1, 0xB7, 0xA1 },
	0x8135EB34,	{ 0xE1, 0xB7, 0xA2 },
	0x8135EB35,	{ 0xE1, 0xB7, 0xA3 },
	0x8135EB36,	{ 0xE1, 0xB7, 0xA4 },
	0x8135EB37,	{ 0xE1, 0xB7, 0xA5 },
	0x8135EB38,	{ 0xE1, 0xB7, 0xA6 },
	0x8135EB39,	{ 0xE1, 0xB7, 0xA7 },
	0x8135EC30,	{ 0xE1, 0xB7, 0xA8 },
	0x8135EC31,	{ 0xE1, 0xB7, 0xA9 },
	0x8135EC32,	{ 0xE1, 0xB7, 0xAA },
	0x8135EC33,	{ 0xE1, 0xB7, 0xAB },
	0x8135EC34,	{ 0xE1, 0xB7, 0xAC },
	0x8135EC35,	{ 0xE1, 0xB7, 0xAD },
	0x8135EC36,	{ 0xE1, 0xB7, 0xAE },
	0x8135EC37,	{ 0xE1, 0xB7, 0xAF },
	0x8135EC38,	{ 0xE1, 0xB7, 0xB0 },
	0x8135EC39,	{ 0xE1, 0xB7, 0xB1 },
	0x8135ED30,	{ 0xE1, 0xB7, 0xB2 },
	0x8135ED31,	{ 0xE1, 0xB7, 0xB3 },
	0x8135ED32,	{ 0xE1, 0xB7, 0xB4 },
	0x8135ED33,	{ 0xE1, 0xB7, 0xB5 },
	0x8135ED34,	{ 0xE1, 0xB7, 0xB6 },
	0x8135ED35,	{ 0xE1, 0xB7, 0xB7 },
	0x8135ED36,	{ 0xE1, 0xB7, 0xB8 },
	0x8135ED37,	{ 0xE1, 0xB7, 0xB9 },
	0x8135ED38,	{ 0xE1, 0xB7, 0xBA },
	0x8135ED39,	{ 0xE1, 0xB7, 0xBB },
	0x8135EE30,	{ 0xE1, 0xB7, 0xBC },
	0x8135EE31,	{ 0xE1, 0xB7, 0xBD },
	0x8135EE32,	{ 0xE1, 0xB7, 0xBE },
	0x8135EE33,	{ 0xE1, 0xB7, 0xBF },
	0x8135EE34,	{ 0xE1, 0xB8, 0x80 },
	0x8135EE35,	{ 0xE1, 0xB8, 0x81 },
	0x8135EE36,	{ 0xE1, 0xB8, 0x82 },
	0x8135EE37,	{ 0xE1, 0xB8, 0x83 },
	0x8135EE38,	{ 0xE1, 0xB8, 0x84 },
	0x8135EE39,	{ 0xE1, 0xB8, 0x85 },
	0x8135EF30,	{ 0xE1, 0xB8, 0x86 },
	0x8135EF31,	{ 0xE1, 0xB8, 0x87 },
	0x8135EF32,	{ 0xE1, 0xB8, 0x88 },
	0x8135EF33,	{ 0xE1, 0xB8, 0x89 },
	0x8135EF34,	{ 0xE1, 0xB8, 0x8A },
	0x8135EF35,	{ 0xE1, 0xB8, 0x8B },
	0x8135EF36,	{ 0xE1, 0xB8, 0x8C },
	0x8135EF37,	{ 0xE1, 0xB8, 0x8D },
	0x8135EF38,	{ 0xE1, 0xB8, 0x8E },
	0x8135EF39,	{ 0xE1, 0xB8, 0x8F },
	0x8135F030,	{ 0xE1, 0xB8, 0x90 },
	0x8135F031,	{ 0xE1, 0xB8, 0x91 },
	0x8135F032,	{ 0xE1, 0xB8, 0x92 },
	0x8135F033,	{ 0xE1, 0xB8, 0x93 },
	0x8135F034,	{ 0xE1, 0xB8, 0x94 },
	0x8135F035,	{ 0xE1, 0xB8, 0x95 },
	0x8135F036,	{ 0xE1, 0xB8, 0x96 },
	0x8135F037,	{ 0xE1, 0xB8, 0x97 },
	0x8135F038,	{ 0xE1, 0xB8, 0x98 },
	0x8135F039,	{ 0xE1, 0xB8, 0x99 },
	0x8135F130,	{ 0xE1, 0xB8, 0x9A },
	0x8135F131,	{ 0xE1, 0xB8, 0x9B },
	0x8135F132,	{ 0xE1, 0xB8, 0x9C },
	0x8135F133,	{ 0xE1, 0xB8, 0x9D },
	0x8135F134,	{ 0xE1, 0xB8, 0x9E },
	0x8135F135,	{ 0xE1, 0xB8, 0x9F },
	0x8135F136,	{ 0xE1, 0xB8, 0xA0 },
	0x8135F137,	{ 0xE1, 0xB8, 0xA1 },
	0x8135F138,	{ 0xE1, 0xB8, 0xA2 },
	0x8135F139,	{ 0xE1, 0xB8, 0xA3 },
	0x8135F230,	{ 0xE1, 0xB8, 0xA4 },
	0x8135F231,	{ 0xE1, 0xB8, 0xA5 },
	0x8135F232,	{ 0xE1, 0xB8, 0xA6 },
	0x8135F233,	{ 0xE1, 0xB8, 0xA7 },
	0x8135F234,	{ 0xE1, 0xB8, 0xA8 },
	0x8135F235,	{ 0xE1, 0xB8, 0xA9 },
	0x8135F236,	{ 0xE1, 0xB8, 0xAA },
	0x8135F237,	{ 0xE1, 0xB8, 0xAB },
	0x8135F238,	{ 0xE1, 0xB8, 0xAC },
	0x8135F239,	{ 0xE1, 0xB8, 0xAD },
	0x8135F330,	{ 0xE1, 0xB8, 0xAE },
	0x8135F331,	{ 0xE1, 0xB8, 0xAF },
	0x8135F332,	{ 0xE1, 0xB8, 0xB0 },
	0x8135F333,	{ 0xE1, 0xB8, 0xB1 },
	0x8135F334,	{ 0xE1, 0xB8, 0xB2 },
	0x8135F335,	{ 0xE1, 0xB8, 0xB3 },
	0x8135F336,	{ 0xE1, 0xB8, 0xB4 },
	0x8135F337,	{ 0xE1, 0xB8, 0xB5 },
	0x8135F338,	{ 0xE1, 0xB8, 0xB6 },
	0x8135F339,	{ 0xE1, 0xB8, 0xB7 },
	0x8135F430,	{ 0xE1, 0xB8, 0xB8 },
	0x8135F431,	{ 0xE1, 0xB8, 0xB9 },
	0x8135F432,	{ 0xE1, 0xB8, 0xBA },
	0x8135F433,	{ 0xE1, 0xB8, 0xBB },
	0x8135F434,	{ 0xE1, 0xB8, 0xBC },
	0x8135F435,	{ 0xE1, 0xB8, 0xBD },
	0x8135F436,	{ 0xE1, 0xB8, 0xBE },
	0x8135F437,	{ 0xE1, 0xB8, 0xBF },
	0x8135F438,	{ 0xE1, 0xB9, 0x80 },
	0x8135F439,	{ 0xE1, 0xB9, 0x81 },
	0x8135F530,	{ 0xE1, 0xB9, 0x82 },
	0x8135F531,	{ 0xE1, 0xB9, 0x83 },
	0x8135F532,	{ 0xE1, 0xB9, 0x84 },
	0x8135F533,	{ 0xE1, 0xB9, 0x85 },
	0x8135F534,	{ 0xE1, 0xB9, 0x86 },
	0x8135F535,	{ 0xE1, 0xB9, 0x87 },
	0x8135F536,	{ 0xE1, 0xB9, 0x88 },
	0x8135F537,	{ 0xE1, 0xB9, 0x89 },
	0x8135F538,	{ 0xE1, 0xB9, 0x8A },
	0x8135F539,	{ 0xE1, 0xB9, 0x8B },
	0x8135F630,	{ 0xE1, 0xB9, 0x8C },
	0x8135F631,	{ 0xE1, 0xB9, 0x8D },
	0x8135F632,	{ 0xE1, 0xB9, 0x8E },
	0x8135F633,	{ 0xE1, 0xB9, 0x8F },
	0x8135F634,	{ 0xE1, 0xB9, 0x90 },
	0x8135F635,	{ 0xE1, 0xB9, 0x91 },
	0x8135F636,	{ 0xE1, 0xB9, 0x92 },
	0x8135F637,	{ 0xE1, 0xB9, 0x93 },
	0x8135F638,	{ 0xE1, 0xB9, 0x94 },
	0x8135F639,	{ 0xE1, 0xB9, 0x95 },
	0x8135F730,	{ 0xE1, 0xB9, 0x96 },
	0x8135F731,	{ 0xE1, 0xB9, 0x97 },
	0x8135F732,	{ 0xE1, 0xB9, 0x98 },
	0x8135F733,	{ 0xE1, 0xB9, 0x99 },
	0x8135F734,	{ 0xE1, 0xB9, 0x9A },
	0x8135F735,	{ 0xE1, 0xB9, 0x9B },
	0x8135F736,	{ 0xE1, 0xB9, 0x9C },
	0x8135F737,	{ 0xE1, 0xB9, 0x9D },
	0x8135F738,	{ 0xE1, 0xB9, 0x9E },
	0x8135F739,	{ 0xE1, 0xB9, 0x9F },
	0x8135F830,	{ 0xE1, 0xB9, 0xA0 },
	0x8135F831,	{ 0xE1, 0xB9, 0xA1 },
	0x8135F832,	{ 0xE1, 0xB9, 0xA2 },
	0x8135F833,	{ 0xE1, 0xB9, 0xA3 },
	0x8135F834,	{ 0xE1, 0xB9, 0xA4 },
	0x8135F835,	{ 0xE1, 0xB9, 0xA5 },
	0x8135F836,	{ 0xE1, 0xB9, 0xA6 },
	0x8135F837,	{ 0xE1, 0xB9, 0xA7 },
	0x8135F838,	{ 0xE1, 0xB9, 0xA8 },
	0x8135F839,	{ 0xE1, 0xB9, 0xA9 },
	0x8135F930,	{ 0xE1, 0xB9, 0xAA },
	0x8135F931,	{ 0xE1, 0xB9, 0xAB },
	0x8135F932,	{ 0xE1, 0xB9, 0xAC },
	0x8135F933,	{ 0xE1, 0xB9, 0xAD },
	0x8135F934,	{ 0xE1, 0xB9, 0xAE },
	0x8135F935,	{ 0xE1, 0xB9, 0xAF },
	0x8135F936,	{ 0xE1, 0xB9, 0xB0 },
	0x8135F937,	{ 0xE1, 0xB9, 0xB1 },
	0x8135F938,	{ 0xE1, 0xB9, 0xB2 },
	0x8135F939,	{ 0xE1, 0xB9, 0xB3 },
	0x8135FA30,	{ 0xE1, 0xB9, 0xB4 },
	0x8135FA31,	{ 0xE1, 0xB9, 0xB5 },
	0x8135FA32,	{ 0xE1, 0xB9, 0xB6 },
	0x8135FA33,	{ 0xE1, 0xB9, 0xB7 },
	0x8135FA34,	{ 0xE1, 0xB9, 0xB8 },
	0x8135FA35,	{ 0xE1, 0xB9, 0xB9 },
	0x8135FA36,	{ 0xE1, 0xB9, 0xBA },
	0x8135FA37,	{ 0xE1, 0xB9, 0xBB },
	0x8135FA38,	{ 0xE1, 0xB9, 0xBC },
	0x8135FA39,	{ 0xE1, 0xB9, 0xBD },
	0x8135FB30,	{ 0xE1, 0xB9, 0xBE },
	0x8135FB31,	{ 0xE1, 0xB9, 0xBF },
	0x8135FB32,	{ 0xE1, 0xBA, 0x80 },
	0x8135FB33,	{ 0xE1, 0xBA, 0x81 },
	0x8135FB34,	{ 0xE1, 0xBA, 0x82 },
	0x8135FB35,	{ 0xE1, 0xBA, 0x83 },
	0x8135FB36,	{ 0xE1, 0xBA, 0x84 },
	0x8135FB37,	{ 0xE1, 0xBA, 0x85 },
	0x8135FB38,	{ 0xE1, 0xBA, 0x86 },
	0x8135FB39,	{ 0xE1, 0xBA, 0x87 },
	0x8135FC30,	{ 0xE1, 0xBA, 0x88 },
	0x8135FC31,	{ 0xE1, 0xBA, 0x89 },
	0x8135FC32,	{ 0xE1, 0xBA, 0x8A },
	0x8135FC33,	{ 0xE1, 0xBA, 0x8B },
	0x8135FC34,	{ 0xE1, 0xBA, 0x8C },
	0x8135FC35,	{ 0xE1, 0xBA, 0x8D },
	0x8135FC36,	{ 0xE1, 0xBA, 0x8E },
	0x8135FC37,	{ 0xE1, 0xBA, 0x8F },
	0x8135FC38,	{ 0xE1, 0xBA, 0x90 },
	0x8135FC39,	{ 0xE1, 0xBA, 0x91 },
	0x8135FD30,	{ 0xE1, 0xBA, 0x92 },
	0x8135FD31,	{ 0xE1, 0xBA, 0x93 },
	0x8135FD32,	{ 0xE1, 0xBA, 0x94 },
	0x8135FD33,	{ 0xE1, 0xBA, 0x95 },
	0x8135FD34,	{ 0xE1, 0xBA, 0x96 },
	0x8135FD35,	{ 0xE1, 0xBA, 0x97 },
	0x8135FD36,	{ 0xE1, 0xBA, 0x98 },
	0x8135FD37,	{ 0xE1, 0xBA, 0x99 },
	0x8135FD38,	{ 0xE1, 0xBA, 0x9A },
	0x8135FD39,	{ 0xE1, 0xBA, 0x9B },
	0x8135FE30,	{ 0xE1, 0xBA, 0x9C },
	0x8135FE31,	{ 0xE1, 0xBA, 0x9D },
	0x8135FE32,	{ 0xE1, 0xBA, 0x9E },
	0x8135FE33,	{ 0xE1, 0xBA, 0x9F },
	0x8135FE34,	{ 0xE1, 0xBA, 0xA0 },
	0x8135FE35,	{ 0xE1, 0xBA, 0xA1 },
	0x8135FE36,	{ 0xE1, 0xBA, 0xA2 },
	0x8135FE37,	{ 0xE1, 0xBA, 0xA3 },
	0x8135FE38,	{ 0xE1, 0xBA, 0xA4 },
	0x8135FE39,	{ 0xE1, 0xBA, 0xA5 },
	0x81368130,	{ 0xE1, 0xBA, 0xA6 },
	0x81368131,	{ 0xE1, 0xBA, 0xA7 },
	0x81368132,	{ 0xE1, 0xBA, 0xA8 },
	0x81368133,	{ 0xE1, 0xBA, 0xA9 },
	0x81368134,	{ 0xE1, 0xBA, 0xAA },
	0x81368135,	{ 0xE1, 0xBA, 0xAB },
	0x81368136,	{ 0xE1, 0xBA, 0xAC },
	0x81368137,	{ 0xE1, 0xBA, 0xAD },
	0x81368138,	{ 0xE1, 0xBA, 0xAE },
	0x81368139,	{ 0xE1, 0xBA, 0xAF },
	0x81368230,	{ 0xE1, 0xBA, 0xB0 },
	0x81368231,	{ 0xE1, 0xBA, 0xB1 },
	0x81368232,	{ 0xE1, 0xBA, 0xB2 },
	0x81368233,	{ 0xE1, 0xBA, 0xB3 },
	0x81368234,	{ 0xE1, 0xBA, 0xB4 },
	0x81368235,	{ 0xE1, 0xBA, 0xB5 },
	0x81368236,	{ 0xE1, 0xBA, 0xB6 },
	0x81368237,	{ 0xE1, 0xBA, 0xB7 },
	0x81368238,	{ 0xE1, 0xBA, 0xB8 },
	0x81368239,	{ 0xE1, 0xBA, 0xB9 },
	0x81368330,	{ 0xE1, 0xBA, 0xBA },
	0x81368331,	{ 0xE1, 0xBA, 0xBB },
	0x81368332,	{ 0xE1, 0xBA, 0xBC },
	0x81368333,	{ 0xE1, 0xBA, 0xBD },
	0x81368334,	{ 0xE1, 0xBA, 0xBE },
	0x81368335,	{ 0xE1, 0xBA, 0xBF },
	0x81368336,	{ 0xE1, 0xBB, 0x80 },
	0x81368337,	{ 0xE1, 0x