/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_KICONV_EUCTW_UTF8_H
#define	_SYS_KICONV_EUCTW_UTF8_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/* Maximum mapping number from CNS11643 to UTF-8. */
#define	KICONV_CNS1_UTF8_MAX		(5868)	/* plane #1 */
#define	KICONV_CNS2_UTF8_MAX		(7651)	/* plane #2 */
#define	KICONV_CNS3_UTF8_MAX		(6395)	/* plane #3 (orig plane #14) */
#define	KICONV_CNS4_UTF8_MAX		(7287)	/* plane #4 */
#define	KICONV_CNS5_UTF8_MAX		(8602)	/* plane #5 */
#define	KICONV_CNS6_UTF8_MAX		(6386)	/* plane #6 */
#define	KICONV_CNS7_UTF8_MAX		(6538)	/* plane #7 */
#define	KICONV_CNS15_UTF8_MAX		(6722)	/* plane #15 */

/*
 * Support Unicode 3.2 and mapping source is Unihan-3.2.0.txt.
 */

/* Conversion table from CNS 11643 plane #1 to UTF-8. */
static kiconv_table_array_t kiconv_cns1_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0xA1A1, { 0xE3, 0x80, 0x80 },
	0xA1A2, { 0xEF, 0xBC, 0x8C },
	0xA1A3, { 0xE3, 0x80, 0x81 },
	0xA1A4, { 0xE3, 0x80, 0x82 },
	0xA1A5, { 0xEF, 0xBC, 0x8E },
	0xA1A6, { 0xE3, 0x83, 0xBB },
	0xA1A7, { 0xEF, 0xBC, 0x9B },
	0xA1A8, { 0xEF, 0xBC, 0x9A },
	0xA1A9, { 0xEF, 0xBC, 0x9F },
	0xA1AA, { 0xEF, 0xBC, 0x81 },
	0xA1AB, { 0xEF, 0xB8, 0xB0 },
	0xA1AC, { 0xE2, 0x80, 0xA6 },
	0xA1AD, { 0xE2, 0x80, 0xA5 },
	0xA1AE, { 0xEF, 0xB9, 0x90 },
	0xA1AF, { 0xEF, 0xB9, 0x91 },
	0xA1B0, { 0xEF, 0xB9, 0x92 },
	0xA1B1, { 0xC2, 0xB7 },
	0xA1B2, { 0xEF, 0xB9, 0x94 },
	0xA1B3, { 0xEF, 0xB9, 0x95 },
	0xA1B4, { 0xEF, 0xB9, 0x96 },
	0xA1B5, { 0xEF, 0xB9, 0x97 },
	0xA1B6, { 0xEF, 0xB8, 0xB1 },
	0xA1B7, { 0xE2, 0x80, 0x94 },
	0xA1B8, { 0xEF, 0xB8, 0xB2 },
	0xA1B9, { 0xE2, 0x80, 0x93 },
	0xA1BE, { 0xEF, 0xBC, 0x88 },
	0xA1BF, { 0xEF, 0xBC, 0x89 },
	0xA1C0, { 0xEF, 0xB8, 0xB5 },
	0xA1C1, { 0xEF, 0xB8, 0xB6 },
	0xA1C2, { 0xEF, 0xBD, 0x9B },
	0xA1C3, { 0xEF, 0xBD, 0x9D },
	0xA1C4, { 0xEF, 0xB8, 0xB7 },
	0xA1C5, { 0xEF, 0xB8, 0xB8 },
	0xA1C6, { 0xE3, 0x80, 0x94 },
	0xA1C7, { 0xE3, 0x80, 0x95 },
	0xA1C8, { 0xEF, 0xB8, 0xB9 },
	0xA1C9, { 0xEF, 0xB8, 0xBA },
	0xA1CA, { 0xE3, 0x80, 0x90 },
	0xA1CB, { 0xE3, 0x80, 0x91 },
	0xA1CC, { 0xEF, 0xB8, 0xBB },
	0xA1CD, { 0xEF, 0xB8, 0xBC },
	0xA1CE, { 0xE3, 0x80, 0x8A },
	0xA1CF, { 0xE3, 0x80, 0x8B },
	0xA1D0, { 0xEF, 0xB8, 0xBD },
	0xA1D1, { 0xEF, 0xB8, 0xBE },
	0xA1D2, { 0xE3, 0x80, 0x88 },
	0xA1D3, { 0xE3, 0x80, 0x89 },
	0xA1D4, { 0xEF, 0xB8, 0xBF },
	0xA1D5, { 0xEF, 0xB9, 0x80 },
	0xA1D6, { 0xE3, 0x80, 0x8C },
	0xA1D7, { 0xE3, 0x80, 0x8D },
	0xA1D8, { 0xEF, 0xB9, 0x81 },
	0xA1D9, { 0xEF, 0xB9, 0x82 },
	0xA1DA, { 0xE3, 0x80, 0x8E },
	0xA1DB, { 0xE3, 0x80, 0x8F },
	0xA1DC, { 0xEF, 0xB9, 0x83 },
	0xA1DD, { 0xEF, 0xB9, 0x84 },
	0xA1DE, { 0xEF, 0xB9, 0x99 },
	0xA1DF, { 0xEF, 0xB9, 0x9A },
	0xA1E0, { 0xEF, 0xB9, 0x9B },
	0xA1E1, { 0xEF, 0xB9, 0x9C },
	0xA1E2, { 0xEF, 0xB9, 0x9D },
	0xA1E3, { 0xEF, 0xB9, 0x9E },
	0xA1E4, { 0xE2, 0x80, 0x98 },
	0xA1E5, { 0xE2, 0x80, 0x99 },
	0xA1E6, { 0xE2, 0x80, 0x9C },
	0xA1E7, { 0xE2, 0x80, 0x9D },
	0xA1E8, { 0xE3, 0x80, 0x9D },
	0xA1E9, { 0xE3, 0x80, 0x9E },
	0xA1EA, { 0xE2, 0x80, 0xB2 },
	0xA1EB, { 0xE2, 0x80, 0xB5 },
	0xA1EC, { 0xEF, 0xBC, 0x83 },
	0xA1ED, { 0xEF, 0xBC, 0x86 },
	0xA1EE, { 0xEF, 0xBC, 0x8A },
	0xA1EF, { 0xE2, 0x80, 0xBB },
	0xA1F0, { 0xC2, 0xA7 },
	0xA1F1, { 0xE3, 0x80, 0x83 },
	0xA1F2, { 0xE2, 0x97, 0x8B },
	0xA1F3, { 0xE2, 0x97, 0x8F },
	0xA1F4, { 0xE2, 0x96, 0xB3 },
	0xA1F5, { 0xE2, 0x96, 0xB2 },
	0xA1F6, { 0xE2, 0x97, 0x8E },
	0xA1F7, { 0xE2, 0x98, 0x86 },
	0xA1F8, { 0xE2, 0x98, 0x85 },
	0xA1F9, { 0xE2, 0x97, 0x87 },
	0xA1FA, { 0xE2, 0x97, 0x86 },
	0xA1FB, { 0xE2, 0x96, 0xA1 },
	0xA1FC, { 0xE2, 0x96, 0xA0 },
	0xA1FD, { 0xE2, 0x96, 0xBD },
	0xA1FE, { 0xE2, 0x96, 0xBC },
	0xA2A1, { 0xE3, 0x8A, 0xA3 },
	0xA2A2, { 0xE2, 0x84, 0x85 },
	0xA2A3, { 0xE2, 0x80, 0xBE },
	0xA2A5, { 0xEF, 0xBC, 0xBF },
	0xA2A7, { 0xEF, 0xB9, 0x89 },
	0xA2A8, { 0xEF, 0xB9, 0x8A },
	0xA2A9, { 0xEF, 0xB9, 0x8D },
	0xA2AA, { 0xEF, 0xB9, 0x8E },
	0xA2AB, { 0xEF, 0xB9, 0x8B },
	0xA2AC, { 0xEF, 0xB9, 0x8C },
	0xA2AD, { 0xEF, 0xB9, 0x9F },
	0xA2AE, { 0xEF, 0xB9, 0xA0 },
	0xA2AF, { 0xEF, 0xB9, 0xA1 },
	0xA2B0, { 0xEF, 0xBC, 0x8B },
	0xA2B1, { 0xEF, 0xBC, 0x8D },
	0xA2B2, { 0xC3, 0x97 },
	0xA2B3, { 0xC3, 0xB7 },
	0xA2B4, { 0xC2, 0xB1 },
	0xA2B5, { 0xE2, 0x88, 0x9A },
	0xA2B6, { 0xEF, 0xBC, 0x9C },
	0xA2B7, { 0xEF, 0xBC, 0x9E },
	0xA2B8, { 0xEF, 0xBC, 0x9D },
	0xA2B9, { 0xE2, 0x89, 0xA6 },
	0xA2BA, { 0xE2, 0x89, 0xA7 },
	0xA2BB, { 0xE2, 0x89, 0xA0 },
	0xA2BC, { 0xE2, 0x88, 0x9E },
	0xA2BD, { 0xE2, 0x89, 0x92 },
	0xA2BE, { 0xE2, 0x89, 0xA1 },
	0xA2BF, { 0xEF, 0xB9, 0xA2 },
	0xA2C0, { 0xEF, 0xB9, 0xA3 },
	0xA2C1, { 0xEF, 0xB9, 0xA4 },
	0xA2C2, { 0xEF, 0xB9, 0xA6 },
	0xA2C3, { 0xEF, 0xB9, 0xA5 },
	0xA2C4, { 0xE2, 0x88, 0xBC },
	0xA2C5, { 0xE2, 0x88, 0xA9 },
	0xA2C6, { 0xE2, 0x88, 0xAA },
	0xA2C7, { 0xE2, 0x8A, 0xA5 },
	0xA2C8, { 0xE2, 0x88, 0xA0 },
	0xA2C9, { 0xE2, 0x88, 0x9F },
	0xA2CA, { 0xE2, 0x8A, 0xBF },
	0xA2CB, { 0xE3, 0x8F, 0x92 },
	0xA2CC, { 0xE3, 0x8F, 0x91 },
	0xA2CD, { 0xE2, 0x88, 0xAB },
	0xA2CE, { 0xE2, 0x88, 0xAE },
	0xA2CF, { 0xE2, 0x88, 0xB5 },
	0xA2D0, { 0xE2, 0x88, 0xB4 },
	0xA2D1, { 0xE2, 0x99, 0x80 },
	0xA2D2, { 0xE2, 0x99, 0x82 },
	0xA2D3, { 0xE2, 0x99, 0x81 },
	0xA2D4, { 0xE2, 0x98, 0x89 },
	0xA2D5, { 0xE2, 0x86, 0x91 },
	0xA2D6, { 0xE2, 0x86, 0x93 },
	0xA2D7, { 0xE2, 0x86, 0x92 },
	0xA2D8, { 0xE2, 0x86, 0x90 },
	0xA2D9, { 0xE2, 0x86, 0x96 },
	0xA2DA, { 0xE2, 0x86, 0x97 },
	0xA2DB, { 0xE2, 0x86, 0x99 },
	0xA2DC, { 0xE2, 0x86, 0x98 },
	0xA2DD, { 0xE2, 0x80, 0x96 },
	0xA2DE, { 0xEF, 0xBD, 0x9C },
	0xA2DF, { 0xEF, 0xBC, 0x8F },
	0xA2E0, { 0xEF, 0xBC, 0xBC },
	0xA2E1, { 0xE2, 0x88, 0x95 },
	0xA2E2, { 0xEF, 0xB9, 0xA8 },
	0xA2E3, { 0xEF, 0xBC, 0x84 },
	0xA2E4, { 0xEF, 0xBF, 0xA5 },
	0xA2E5, { 0xE3, 0x80, 0x92 },
	0xA2E6, { 0xEF, 0xBF, 0xA0 },
	0xA2E7, { 0xEF, 0xBF, 0xA1 },
	0xA2E8, { 0xEF, 0xBC, 0x85 },
	0xA2E9, { 0xEF, 0xBC, 0xA0 },
	0xA2EA, { 0xE2, 0x84, 0x83 },
	0xA2EB, { 0xE2, 0x84, 0x89 },
	0xA2EC, { 0xEF, 0xB9, 0xA9 },
	0xA2ED, { 0xEF, 0xB9, 0xAA },
	0xA2EE, { 0xEF, 0xB9, 0xAB },
	0xA2EF, { 0xE3, 0x8F, 0x95 },
	0xA2F0, { 0xE3, 0x8E, 0x9C },
	0xA2F1, { 0xE3, 0x8E, 0x9D },
	0xA2F2, { 0xE3, 0x8E, 0x9E },
	0xA2F3, { 0xE3, 0x8F, 0x8E },
	0xA2F4, { 0xE3, 0x8E, 0xA1 },
	0xA2F5, { 0xE3, 0x8E, 0x8E },
	0xA2F6, { 0xE3, 0x8E, 0x8F },
	0xA2F7, { 0xE3, 0x8F, 0x84 },
	0xA2F8, { 0xC2, 0xB0 },
	0xA2F9, { 0xE5, 0x85, 0x99 },
	0xA2FA, { 0xE5, 0x85, 0x9B },
	0xA2FB, { 0xE5, 0x85, 0x9E },
	0xA2FC, { 0xE5, 0x85, 0x9D },
	0xA2FD, { 0xE5, 0x85, 0xA1 },
	0xA2FE, { 0xE5, 0x85, 0xA3 },
	0xA3A1, { 0xE5, 0x97, 0xA7 },
	0xA3A2, { 0xE7, 0x93, 0xA9 },
	0xA3A3, { 0xE7, 0xB3, 0x8E },
	0xA3A4, { 0xE2, 0x96, 0x81 },
	0xA3A5, { 0xE2, 0x96, 0x82 },
	0xA3A6, { 0xE2, 0x96, 0x83 },
	0xA3A7, { 0xE2, 0x96, 0x84 },
	0xA3A8, { 0xE2, 0x96, 0x85 },
	0xA3A9, { 0xE2, 0x96, 0x86 },
	0xA3AA, { 0xE2, 0x96, 0x87 },
	0xA3AB, { 0xE2, 0x96, 0x88 },
	0xA3AC, { 0xE2, 0x96, 0x8F },
	0xA3AD, { 0xE2, 0x96, 0x8E },
	0xA3AE, { 0xE2, 0x96, 0x8D },
	0xA3AF, { 0xE2, 0x96, 0x8C },
	0xA3B0, { 0xE2, 0x96, 0x8B },
	0xA3B1, { 0xE2, 0x96, 0x8A },
	0xA3B2, { 0xE2, 0x96, 0x89 },
	0xA3B3, { 0xE2, 0x94, 0xBC },
	0xA3B4, { 0xE2, 0x94, 0xB4 },
	0xA3B5, { 0xE2, 0x94, 0xAC },
	0xA3B6, { 0xE2, 0x94, 0xA4 },
	0xA3B7, { 0xE2, 0x94, 0x9C },
	0xA3B8, { 0xE2, 0x96, 0x94 },
	0xA3B9, { 0xE2, 0x94, 0x80 },
	0xA3BA, { 0xE2, 0x94, 0x82 },
	0xA3BB, { 0xE2, 0x96, 0x95 },
	0xA3BC, { 0xE2, 0x94, 0x8C },
	0xA3BD, { 0xE2, 0x94, 0x90 },
	0xA3BE, { 0xE2, 0x94, 0x94 },
	0xA3BF, { 0xE2, 0x94, 0x98 },
	0xA3C0, { 0xE2, 0x95, 0xAD },
	0xA3C1, { 0xE2, 0x95, 0xAE },
	0xA3C2, { 0xE2, 0x95, 0xB0 },
	0xA3C3, { 0xE2, 0x95, 0xAF },
	0xA3C4, { 0xE2, 0x95, 0x90 },
	0xA3C5, { 0xE2, 0x95, 0x9E },
	0xA3C6, { 0xE2, 0x95, 0xAA },
	0xA3C7, { 0xE2, 0x95, 0xA1 },
	0xA3C8, { 0xE2, 0x97, 0xA2 },
	0xA3C9, { 0xE2, 0x97, 0xA3 },
	0xA3CA, { 0xE2, 0x97, 0xA5 },
	0xA3CB, { 0xE2, 0x97, 0xA4 },
	0xA3CC, { 0xE2, 0x95, 0xB1 },
	0xA3CD, { 0xE2, 0x95, 0xB2 },
	0xA3CE, { 0xE2, 0x95, 0xB3 },
	0xA4A1, { 0xEF, 0xBC, 0x90 },
	0xA4A2, { 0xEF, 0xBC, 0x91 },
	0xA4A3, { 0xEF, 0xBC, 0x92 },
	0xA4A4, { 0xEF, 0xBC, 0x93 },
	0xA4A5, { 0xEF, 0xBC, 0x94 },
	0xA4A6, { 0xEF, 0xBC, 0x95 },
	0xA4A7, { 0xEF, 0xBC, 0x96 },
	0xA4A8, { 0xEF, 0xBC, 0x97 },
	0xA4A9, { 0xEF, 0xBC, 0x98 },
	0xA4AA, { 0xEF, 0xBC, 0x99 },
	0xA4AB, { 0xE2, 0x85, 0xA0 },
	0xA4AC, { 0xE2, 0x85, 0xA1 },
	0xA4AD, { 0xE2, 0x85, 0xA2 },
	0xA4AE, { 0xE2, 0x85, 0xA3 },
	0xA4AF, { 0xE2, 0x85, 0xA4 },
	0xA4B0, { 0xE2, 0x85, 0xA5 },
	0xA4B1, { 0xE2, 0x85, 0xA6 },
	0xA4B2, { 0xE2, 0x85, 0xA7 },
	0xA4B3, { 0xE2, 0x85, 0xA8 },
	0xA4B4, { 0xE2, 0x85, 0xA9 },
	0xA4B5, { 0xE3, 0x80, 0xA1 },
	0xA4B6, { 0xE3, 0x80, 0xA2 },
	0xA4B7, { 0xE3, 0x80, 0xA3 },
	0xA4B8, { 0xE3, 0x80, 0xA4 },
	0xA4B9, { 0xE3, 0x80, 0xA5 },
	0xA4BA, { 0xE3, 0x80, 0xA6 },
	0xA4BB, { 0xE3, 0x80, 0xA7 },
	0xA4BC, { 0xE3, 0x80, 0xA8 },
	0xA4BD, { 0xE3, 0x80, 0xA9 },
	0xA4BF, { 0xE5, 0x8D, 0x84 },
	0xA4C1, { 0xEF, 0xBC, 0xA1 },
	0xA4C2, { 0xEF, 0xBC, 0xA2 },
	0xA4C3, { 0xEF, 0xBC, 0xA3 },
	0xA4C4, { 0xEF, 0xBC, 0xA4 },
	0xA4C5, { 0xEF, 0xBC, 0xA5 },
	0xA4C6, { 0xEF, 0xBC, 0xA6 },
	0xA4C7, { 0xEF, 0xBC, 0xA7 },
	0xA4C8, { 0xEF, 0xBC, 0xA8 },
	0xA4C9, { 0xEF, 0xBC, 0xA9 },
	0xA4CA, { 0xEF, 0xBC, 0xAA },
	0xA4CB, { 0xEF, 0xBC, 0xAB },
	0xA4CC, { 0xEF, 0xBC, 0xAC },
	0xA4CD, { 0xEF, 0xBC, 0xAD },
	0xA4CE, { 0xEF, 0xBC, 0xAE },
	0xA4CF, { 0xEF, 0xBC, 0xAF },
	0xA4D0, { 0xEF, 0xBC, 0xB0 },
	0xA4D1, { 0xEF, 0xBC, 0xB1 },
	0xA4D2, { 0xEF, 0xBC, 0xB2 },
	0xA4D3, { 0xEF, 0xBC, 0xB3 },
	0xA4D4, { 0xEF, 0xBC, 0xB4 },
	0xA4D5, { 0xEF, 0xBC, 0xB5 },
	0xA4D6, { 0xEF, 0xBC, 0xB6 },
	0xA4D7, { 0xEF, 0xBC, 0xB7 },
	0xA4D8, { 0xEF, 0xBC, 0xB8 },
	0xA4D9, { 0xEF, 0xBC, 0xB9 },
	0xA4DA, { 0xEF, 0xBC, 0xBA },
	0xA4DB, { 0xEF, 0xBD, 0x81 },
	0xA4DC, { 0xEF, 0xBD, 0x82 },
	0xA4DD, { 0xEF, 0xBD, 0x83 },
	0xA4DE, { 0xEF, 0xBD, 0x84 },
	0xA4DF, { 0xEF, 0xBD, 0x85 },
	0xA4E0, { 0xEF, 0xBD, 0x86 },
	0xA4E1, { 0xEF, 0xBD, 0x87 },
	0xA4E2, { 0xEF, 0xBD, 0x88 },
	0xA4E3, { 0xEF, 0xBD, 0x89 },
	0xA4E4, { 0xEF, 0xBD, 0x8A },
	0xA4E5, { 0xEF, 0xBD, 0x8B },
	0xA4E6, { 0xEF, 0xBD, 0x8C },
	0xA4E7, { 0xEF, 0xBD, 0x8D },
	0xA4E8, { 0xEF, 0xBD, 0x8E },
	0xA4E9, { 0xEF, 0xBD, 0x8F },
	0xA4EA, { 0xEF, 0xBD, 0x90 },
	0xA4EB, { 0xEF, 0xBD, 0x91 },
	0xA4EC, { 0xEF, 0xBD, 0x92 },
	0xA4ED, { 0xEF, 0xBD, 0x93 },
	0xA4EE, { 0xEF, 0xBD, 0x94 },
	0xA4EF, { 0xEF, 0xBD, 0x95 },
	0xA4F0, { 0xEF, 0xBD, 0x96 },
	0xA4F1, { 0xEF, 0xBD, 0x97 },
	0xA4F2, { 0xEF, 0xBD, 0x98 },
	0xA4F3, { 0xEF, 0xBD, 0x99 },
	0xA4F4, { 0xEF, 0xBD, 0x9A },
	0xA4F5, { 0xCE, 0x91 },
	0xA4F6, { 0xCE, 0x92 },
	0xA4F7, { 0xCE, 0x93 },
	0xA4F8, { 0xCE, 0x94 },
	0xA4F9, { 0xCE, 0x95 },
	0xA4FA, { 0xCE, 0x96 },
	0xA4FB, { 0xCE, 0x97 },
	0xA4FC, { 0xCE, 0x98 },
	0xA4FD, { 0xCE, 0x99 },
	0xA4FE, { 0xCE, 0x9A },
	0xA5A1, { 0xCE, 0x9B },
	0xA5A2, { 0xCE, 0x9C },
	0xA5A3, { 0xCE, 0x9D },
	0xA5A4, { 0xCE, 0x9E },
	0xA5A5, { 0xCE, 0x9F },
	0xA5A6, { 0xCE, 0xA0 },
	0xA5A7, { 0xCE, 0xA1 },
	0xA5A8, { 0xCE, 0xA3 },
	0xA5A9, { 0xCE, 0xA4 },
	0xA5AA, { 0xCE, 0xA5 },
	0xA5AB, { 0xCE, 0xA6 },
	0xA5AC, { 0xCE, 0xA7 },
	0xA5AD, { 0xCE, 0xA8 },
	0xA5AE, { 0xCE, 0xA9 },
	0xA5AF, { 0xCE, 0xB1 },
	0xA5B0, { 0xCE, 0xB2 },
	0xA5B1, { 0xCE, 0xB3 },
	0xA5B2, { 0xCE, 0xB4 },
	0xA5B3, { 0xCE, 0xB5 },
	0xA5B4, { 0xCE, 0xB6 },
	0xA5B5, { 0xCE, 0xB7 },
	0xA5B6, { 0xCE, 0xB8 },
	0xA5B7, { 0xCE, 0xB9 },
	0xA5B8, { 0xCE, 0xBA },
	0xA5B9, { 0xCE, 0xBB },
	0xA5BA, { 0xCE, 0xBC },
	0xA5BB, { 0xCE, 0xBD },
	0xA5BC, { 0xCE, 0xBE },
	0xA5BD, { 0xCE, 0xBF },
	0xA5BE, { 0xCF, 0x80 },
	0xA5BF, { 0xCF, 0x81 },
	0xA5C0, { 0xCF, 0x83 },
	0xA5C1, { 0xCF, 0x84 },
	0xA5C2, { 0xCF, 0x85 },
	0xA5C3, { 0xCF, 0x86 },
	0xA5C4, { 0xCF, 0x87 },
	0xA5C5, { 0xCF, 0x88 },
	0xA5C6, { 0xCF, 0x89 },
	0xA5C7, { 0xE3, 0x84, 0x85 },
	0xA5C8, { 0xE3, 0x84, 0x86 },
	0xA5C9, { 0xE3, 0x84, 0x87 },
	0xA5CA, { 0xE3, 0x84, 0x88 },
	0xA5CB, { 0xE3, 0x84, 0x89 },
	0xA5CC, { 0xE3, 0x84, 0x8A },
	0xA5CD, { 0xE3, 0x84, 0x8B },
	0xA5CE, { 0xE3, 0x84, 0x8C },
	0xA5CF, { 0xE3, 0x84, 0x8D },
	0xA5D0, { 0xE3, 0x84, 0x8E },
	0xA5D1, { 0xE3, 0x84, 0x8F },
	0xA5D2, { 0xE3, 0x84, 0x90 },
	0xA5D3, { 0xE3, 0x84, 0x91 },
	0xA5D4, { 0xE3, 0x84, 0x92 },
	0xA5D5, { 0xE3, 0x84, 0x93 },
	0xA5D6, { 0xE3, 0x84, 0x94 },
	0xA5D7, { 0xE3, 0x84, 0x95 },
	0xA5D8, { 0xE3, 0x84, 0x96 },
	0xA5D9, { 0xE3, 0x84, 0x97 },
	0xA5DA, { 0xE3, 0x84, 0x98 },
	0xA5DB, { 0xE3, 0x84, 0x99 },
	0xA5DC, { 0xE3, 0x84, 0x9A },
	0xA5DD, { 0xE3, 0x84, 0x9B },
	0xA5DE, { 0xE3, 0x84, 0x9C },
	0xA5DF, { 0xE3, 0x84, 0x9D },
	0xA5E0, { 0xE3, 0x84, 0x9E },
	0xA5E1, { 0xE3, 0x84, 0x9F },
	0xA5E2, { 0xE3, 0x84, 0xA0 },
	0xA5E3, { 0xE3, 0x84, 0xA1 },
	0xA5E4, { 0xE3, 0x84, 0xA2 },
	0xA5E5, { 0xE3, 0x84, 0xA3 },
	0xA5E6, { 0xE3, 0x84, 0xA4 },
	0xA5E7, { 0xE3, 0x84, 0xA5 },
	0xA5E8, { 0xE3, 0x84, 0xA6 },
	0xA5E9, { 0xE3, 0x84, 0xA7 },
	0xA5EA, { 0xE3, 0x84, 0xA8 },
	0xA5EB, { 0xE3, 0x84, 0xA9 },
	0xA5EC, { 0xCB, 0x99 },
	0xA5ED, { 0xCB, 0x89 },
	0xA5EE, { 0xCB, 0x8A },
	0xA5EF, { 0xCB, 0x87 },
	0xA5F0, { 0xCB, 0x8B },
	0xA6A1, { 0xE2, 0x91, 0xA0 },
	0xA6A2, { 0xE2, 0x91, 0xA1 },
	0xA6A3, { 0xE2, 0x91, 0xA2 },
	0xA6A4, { 0xE2, 0x91, 0xA3 },
	0xA6A5, { 0xE2, 0x91, 0xA4 },
	0xA6A6, { 0xE2, 0x91, 0xA5 },
	0xA6A7, { 0xE2, 0x91, 0xA6 },
	0xA6A8, { 0xE2, 0x91, 0xA7 },
	0xA6A9, { 0xE2, 0x91, 0xA8 },
	0xA6AA, { 0xE2, 0x91, 0xA9 },
	0xA6AB, { 0xE2, 0x91, 0xB4 },
	0xA6AC, { 0xE2, 0x91, 0xB5 },
	0xA6AD, { 0xE2, 0x91, 0xB6 },
	0xA6AE, { 0xE2, 0x91, 0xB7 },
	0xA6AF, { 0xE2, 0x91, 0xB8 },
	0xA6B0, { 0xE2, 0x91, 0xB9 },
	0xA6B1, { 0xE2, 0x91, 0xBA },
	0xA6B2, { 0xE2, 0x91, 0xBB },
	0xA6B3, { 0xE2, 0x91, 0xBC },
	0xA6B4, { 0xE2, 0x91, 0xBD },
	0xA6B5, { 0xE2, 0x85, 0xB0 },
	0xA6B6, { 0xE2, 0x85, 0xB1 },
	0xA6B7, { 0xE2, 0x85, 0xB2 },
	0xA6B8, { 0xE2, 0x85, 0xB3 },
	0xA6B9, { 0xE2, 0x85, 0xB4 },
	0xA6BA, { 0xE2, 0x85, 0xB5 },
	0xA6BB, { 0xE2, 0x85, 0xB6 },
	0xA6BC, { 0xE2, 0x85, 0xB7 },
	0xA6BD, { 0xE2, 0x85, 0xB8 },
	0xA6BE, { 0xE2, 0x85, 0xB9 },
	0xA7A8, { 0xE4, 0xBA, 0xA0 },
	0xA7AF, { 0xE5, 0x86, 0xAB },
	0xA7B4, { 0xE5, 0x8B, 0xB9 },
	0xC2A1, { 0xE2, 0x90, 0x80 },
	0xC2A2, { 0xE2, 0x90, 0x81 },
	0xC2A3, { 0xE2, 0x90, 0x82 },
	0xC2A4, { 0xE2, 0x90, 0x83 },
	0xC2A5, { 0xE2, 0x90, 0x84 },
	0xC2A6, { 0xE2, 0x90, 0x85 },
	0xC2A7, { 0xE2, 0x90, 0x86 },
	0xC2A8, { 0xE2, 0x90, 0x87 },
	0xC2A9, { 0xE2, 0x90, 0x88 },
	0xC2AA, { 0xE2, 0x90, 0x89 },
	0xC2AB, { 0xE2, 0x90, 0x8A },
	0xC2AC, { 0xE2, 0x90, 0x8B },
	0xC2AD, { 0xE2, 0x90, 0x8C },
	0xC2AE, { 0xE2, 0x90, 0x8D },
	0xC2AF, { 0xE2, 0x90, 0x8E },
	0xC2B0, { 0xE2, 0x90, 0x8F },
	0xC2B1, { 0xE2, 0x90, 0x90 },
	0xC2B2, { 0xE2, 0x90, 0x91 },
	0xC2B3, { 0xE2, 0x90, 0x92 },
	0xC2B4, { 0xE2, 0x90, 0x93 },
	0xC2B5, { 0xE2, 0x90, 0x94 },
	0xC2B6, { 0xE2, 0x90, 0x95 },
	0xC2B7, { 0xE2, 0x90, 0x96 },
	0xC2B8, { 0xE2, 0x90, 0x97 },
	0xC2B9, { 0xE2, 0x90, 0x98 },
	0xC2BA, { 0xE2, 0x90, 0x99 },
	0xC2BB, { 0xE2, 0x90, 0x9A },
	0xC2BC, { 0xE2, 0x90, 0x9B },
	0xC2BD, { 0xE2, 0x90, 0x9C },
	0xC2BE, { 0xE2, 0x90, 0x9D },
	0xC2BF, { 0xE2, 0x90, 0x9E },
	0xC2C0, { 0xE2, 0x90, 0x9F },
	0xC2C1, { 0xE2, 0x90, 0xA1 },
	0xC4A1, { 0xE4, 0xB8, 0x80 },
	0xC4A2, { 0xE4, 0xB9, 0x99 },
	0xC4A3, { 0xE4, 0xB8, 0x81 },
	0xC4A4, { 0xE4, 0xB8, 0x83 },
	0xC4A5, { 0xE4, 0xB9, 0x83 },
	0xC4A6, { 0xE4, 0xB9, 0x9D },
	0xC4A7, { 0xE4, 0xBA, 0x86 },
	0xC4A8, { 0xE4, 0xBA, 0x8C },
	0xC4A9, { 0xE4, 0xBA, 0xBA },
	0xC4AA, { 0xE5, 0x84, 0xBF },
	0xC4AB, { 0xE5, 0x85, 0xA5 },
	0xC4AC, { 0xE5, 0x85, 0xAB },
	0xC4AD, { 0xE5, 0x87, 0xA0 },
	0xC4AE, { 0xE5, 0x88, 0x80 },
	0xC4AF, { 0xE5, 0x88, 0x81 },
	0xC4B0, { 0xE5, 0x8A, 0x9B },
	0xC4B1, { 0xE5, 0x8C, 0x95 },
	0xC4B2, { 0xE5, 0x8D, 0x81 },
	0xC4B3, { 0xE5, 0x8D, 0x9C },
	0xC4B4, { 0xE5, 0x8F, 0x88 },
	0xC4B5, { 0xE4, 0xB8, 0x89 },
	0xC4B6, { 0xE4, 0xB8, 0x8B },
	0xC4B7, { 0xE4, 0xB8, 0x88 },
	0xC4B8, { 0xE4, 0xB8, 0x8A },
	0xC4B9, { 0xE4, 0xB8, 0xAB },
	0xC4BA, { 0xE4, 0xB8, 0xB8 },
	0xC4BB, { 0xE5, 0x87, 0xA1 },
	0xC4BC, { 0xE4, 0xB9, 0x85 },
	0xC4BD, { 0xE4, 0xB9, 0x88 },
	0xC4BE, { 0xE4, 0xB9, 0x9F },
	0xC4BF, { 0xE4, 0xB9, 0x9E },
	0xC4C0, { 0xE4, 0xBA, 0x8E },
	0xC4C1, { 0xE4, 0xBA, 0xA1 },
	0xC4C2, { 0xE5, 0x85, 0x80 },
	0xC4C3, { 0xE5, 0x88, 0x83 },
	0xC4C4, { 0xE5, 0x8B, 0xBA },
	0xC4C5, { 0xE5, 0x8D, 0x83 },
	0xC4C6, { 0xE5, 0x8F, 0x89 },
	0xC4C7, { 0xE5, 0x8F, 0xA3 },
	0xC4C8, { 0xE5, 0x9C, 0x9F },
	0xC4C9, { 0xE5, 0xA3, 0xAB },
	0xC4CA, { 0xE5, 0xA4, 0x95 },
	0xC4CB, { 0xE5, 0xA4, 0xA7 },
	0xC4CC, { 0xE5, 0xA5, 0xB3 },
	0xC4CD, { 0xE5, 0xAD, 0x90 },
	0xC4CE, { 0xE5, 0xAD, 0x91 },
	0xC4CF, { 0xE5, 0xAD, 0x93 },
	0xC4D0, { 0xE5, 0xAF, 0xB8 },
	0xC4D1, { 0xE5, 0xB0, 0x8F },
	0xC4D2, { 0xE5, 0xB0, 0xA2 },
	0xC4D3, { 0xE5, 0xB0, 0xB8 },
	0xC4D4, { 0xE5, 0xB1, 0xB1 },
	0xC4D5, { 0xE5, 0xB7, 0x9D },
	0xC4D6, { 0xE5, 0xB7, 0xA5 },
	0xC4D7, { 0xE5, 0xB7, 0xB1 },
	0xC4D8, { 0xE5, 0xB7, 0xB2 },
	0xC4D9, { 0xE5, 0xB7, 0xB3 },
	0xC4DA, { 0xE5, 0xB7, 0xBE },
	0xC4DB, { 0xE5, 0xB9, 0xB2 },
	0xC4DC, { 0xE5, 0xBB, 0xBE },
	0xC4DD, { 0xE5, 0xBC, 0x8B },
	0xC4DE, { 0xE5, 0xBC, 0x93 },
	0xC4DF, { 0xE6, 0x89, 0x8D },
	0xC4E0, { 0xE4, 0xB8, 0x91 },
	0xC4E1, { 0xE4, 0xB8, 0x90 },
	0xC4E2, { 0xE4, 0xB8, 0x8D },
	0xC4E3, { 0xE4, 0xB8, 0xAD },
	0xC4E4, { 0xE4, 0xB8, 0xB0 },
	0xC4E5, { 0xE4, 0xB8, 0xB9 },
	0xC4E6, { 0xE4, 0xB9, 0x8B },
	0xC4E7, { 0xE5, 0xB0, 0xB9 },
	0xC4E8, { 0xE4, 0xBA, 0x88 },
	0xC4E9, { 0xE4, 0xBA, 0x91 },
	0xC4EA, { 0xE4, 0xBA, 0x95 },
	0xC4EB, { 0xE4, 0xBA, 0x92 },
	0xC4EC, { 0xE4, 0xBA, 0x94 },
	0xC4ED, { 0xE4, 0xBA, 0xA2 },
	0xC4EE, { 0xE4, 0xBB, 0x81 },
	0xC4EF, { 0xE4, 0xBB, 0x80 },
	0xC4F0, { 0xE4, 0xBB, 0x83 },
	0xC4F1, { 0xE4, 0xBB, 0x86 },
	0xC4F2, { 0xE4, 0xBB, 0x87 },
	0xC4F3, { 0xE4, 0xBB, 0x8D },
	0xC4F4, { 0xE4, 0xBB, 0x8A },
	0xC4F5, { 0xE4, 0xBB, 0x8B },
	0xC4F6, { 0xE4, 0xBB, 0x84 },
	0xC4F7, { 0xE5, 0x85, 0x83 },
	0xC4F8, { 0xE5, 0x85, 0x81 },
	0xC4F9, { 0xE5, 0x85, 0xA7 },
	0xC4FA, { 0xE5, 0x85, 0xAD },
	0xC4FB, { 0xE5, 0x85, 0xAE },
	0xC4FC, { 0xE5, 0x85, 0xAC },
	0xC4FD, { 0xE5, 0x86, 0x97 },
	0xC4FE, { 0xE5, 0x87, 0xB6 },
	0xC5A1, { 0xE5, 0x88, 0x86 },
	0xC5A2, { 0xE5, 0x88, 0x87 },
	0xC5A3, { 0xE5, 0x88, 0x88 },
	0xC5A4, { 0xE5, 0x8B, 0xBB },
	0xC5A5, { 0xE5, 0x8B, 0xBE },
	0xC5A6, { 0xE5, 0x8B, 0xBF },
	0xC5A7, { 0xE5, 0x8C, 0x96 },
	0xC5A8, { 0xE5, 0x8C, 0xB9 },
	0xC5A9, { 0xE5, 0x8D, 0x88 },
	0xC5AA, { 0xE5, 0x8D, 0x87 },
	0xC5AB, { 0xE5, 0x8D, 0x85 },
	0xC5AC, { 0xE5, 0x8D, 0x9E },
	0xC5AD, { 0xE5, 0x8E, 0x84 },
	0xC5AE, { 0xE5, 0x8F, 0x8B },
	0xC5AF, { 0xE5, 0x8F, 0x8A },
	0xC5B0, { 0xE5, 0x8F, 0x8D },
	0xC5B1, { 0xE5, 0xA3, 0xAC },
	0xC5B2, { 0xE5, 0xA4, 0xA9 },
	0xC5B3, { 0xE5, 0xA4, 0xAB },
	0xC5B4, { 0xE5, 0xA4, 0xAA },
	0xC5B5, { 0xE5, 0xA4, 0xAD },
	0xC5B6, { 0xE5, 0xAD, 0x94 },
	0xC5B7, { 0xE5, 0xB0, 0x91 },
	0xC5B8, { 0xE5, 0xB0, 0xA4 },
	0xC5B9, { 0xE5, 0xB0, 0xBA },
	0xC5BA, { 0xE5, 0xB1, 0xAF },
	0xC5BB, { 0xE5, 0xB7, 0xB4 },
	0xC5BC, { 0xE5, 0xB9, 0xBB },
	0xC5BD, { 0xE5, 0xBB, 0xBF },
	0xC5BE, { 0xE5, 0xBC, 0x94 },
	0xC5BF, { 0xE5, 0xBC, 0x95 },
	0xC5C0, { 0xE5, 0xBF, 0x83 },
	0xC5C1, { 0xE6, 0x88, 0x88 },
	0xC5C2, { 0xE6, 0x88, 0xB6 },
	0xC5C3, { 0xE6, 0x89, 0x8B },
	0xC5C4, { 0xE6, 0x89, 0x8E },
	0xC5C5, { 0xE6, 0x94, 0xAF },
	0xC5C6, { 0xE6, 0x96, 0x87 },
	0xC5C7, { 0xE6, 0x96, 0x97 },
	0xC5C8, { 0xE6, 0x96, 0xA4 },
	0xC5C9, { 0xE6, 0x96, 0xB9 },
	0xC5CA, { 0xE6, 0x97, 0xA5 },
	0xC5CB, { 0xE6, 0x9B, 0xB0 },
	0xC5CC, { 0xE6, 0x9C, 0x88 },
	0xC5CD, { 0xE6, 0x9C, 0xA8 },
	0xC5CE, { 0xE6, 0xAC, 0xA0 },
	0xC5CF, { 0xE6, 0xAD, 0xA2 },
	0xC5D0, { 0xE6, 0xAD, 0xB9 },
	0xC5D1, { 0xE6, 0xAF, 0x8B },
	0xC5D2, { 0xE6, 0xAF, 0x94 },
	0xC5D3, { 0xE6, 0xAF, 0x9B },
	0xC5D4, { 0xE6, 0xB0, 0x8F },
	0xC5D5, { 0xE6, 0xB0, 0xB4 },
	0xC5D6, { 0xE7, 0x81, 0xAB },
	0xC5D7, { 0xE7, 0x88, 0xAA },
	0xC5D8, { 0xE7, 0x88, 0xB6 },
	0xC5D9, { 0xE7, 0x88, 0xBB },
	0xC5DA, { 0xE7, 0x89, 0x87 },
	0xC5DB, { 0xE7, 0x89, 0x99 },
	0xC5DC, { 0xE7, 0x89, 0x9B },
	0xC5DD, { 0xE7, 0x8A, 0xAC },
	0xC5DE, { 0xE7, 0x8E, 0x8B },
	0xC5DF, { 0xE4, 0xB8, 0x99 },
	0xC5E0, { 0xE4, 0xB8, 0x96 },
	0xC5E1, { 0xE4, 0xB8, 0x95 },
	0xC5E2, { 0xE4, 0xB8, 0x94 },
	0xC5E3, { 0xE4, 0xB8, 0x98 },
	0xC5E4, { 0xE4, 0xB8, 0xBB },
	0xC5E5, { 0xE4, 0xB9, 0x8D },
	0xC5E6, { 0xE4, 0xB9, 0x8F },
	0xC5E7, { 0xE4, 0xB9, 0x8E },
	0xC5E8, { 0xE4, 0xBB, 0xA5 },
	0xC5E9, { 0xE4, 0xBB, 0x98 },
	0xC5EA, { 0xE4, 0xBB, 0x94 },
	0xC5EB, { 0xE4, 0xBB, 0x95 },
	0xC5EC, { 0xE4, 0xBB, 0x96 },
	0xC5ED, { 0xE4, 0xBB, 0x97 },
	0xC5EE, { 0xE4, 0xBB, 0xA3 },
	0xC5EF, { 0xE4, 0xBB, 0xA4 },
	0xC5F0, { 0xE4, 0xBB, 0x99 },
	0xC5F1, { 0xE4, 0xBB, 0x9E },
	0xC5F2, { 0xE5, 0x85, 0x85 },
	0xC5F3, { 0xE5, 0x85, 0x84 },
	0xC5F4, { 0xE5, 0x86, 0x89 },
	0xC5F5, { 0xE5, 0x86, 0x8A },
	0xC5F6, { 0xE5, 0x86, 0xAC },
	0xC5F7, { 0xE5, 0x87, 0xB9 },
	0xC5F8, { 0xE5, 0x87, 0xBA },
	0xC5F9, { 0xE5, 0x87, 0xB8 },
	0xC5FA, { 0xE5, 0x88, 0x8A },
	0xC5FB, { 0xE5, 0x8A, 0xA0 },
	0xC5FC, { 0xE5, 0x8A, 0x9F },
	0xC5FD, { 0xE5, 0x8C, 0x85 },
	0xC5FE, { 0xE5, 0x8C, 0x86 },
	0xC6A1, { 0xE5, 0x8C, 0x97 },
	0xC6A2, { 0xE5, 0x8C, 0x9D },
	0xC6A3, { 0xE4, 0xBB, 0x9F },
	0xC6A4, { 0xE5, 0x8D, 0x8A },
	0xC6A5, { 0xE5, 0x8D, 0x89 },
	0xC6A6, { 0xE5, 0x8D, 0xA1 },
	0xC6A7, { 0xE5, 0x8D, 0xA0 },
	0xC6A8, { 0xE5, 0x8D, 0xAF },
	0xC6A9, { 0xE5, 0x8D, 0xAE },
	0xC6AA, { 0xE5, 0x8E, 0xBB },
	0xC6AB, { 0xE5, 0x8F, 0xAF },
	0xC6AC, { 0xE5, 0x8F, 0xA4 },
	0xC6AD, { 0xE5, 0x8F, 0xB3 },
	0xC6AE, { 0xE5, 0x8F, 0xAC },
	0xC6AF, { 0xE5, 0x8F, 0xAE },
	0xC6B0, { 0xE5, 0x8F, 0xA9 },
	0xC6B1, { 0xE5, 0x8F, 0xA8 },
	0xC6B2, { 0xE5, 0x8F, 0xBC },
	0xC6B3, { 0xE5, 0x8F, 0xB8 },
	0xC6B4, { 0xE5, 0x8F, 0xB5 },
	0xC6B5, { 0xE5, 0x8F, 0xAB },
	0xC6B6, { 0xE5, 0x8F, 0xA6 },
	0xC6B7, { 0xE5, 0x8F, 0xAA },
	0xC6B8, { 0xE5, 0x8F, 0xB2 },
	0xC6B9, { 0xE5, 0x8F, 0xB1 },
	0xC6BA, { 0xE5, 0x8F, 0xB0 },
	0xC6BB, { 0xE5, 0x8F, 0xA5 },
	0xC6BC, { 0xE5, 0x8F, 0xAD },
	0xC6BD, { 0xE5, 0x8F, 0xBB },
	0xC6BE, { 0xE5, 0x9B, 0x9B },
	0xC6BF, { 0xE5, 0x9B, 0x9A },
	0xC6C0, { 0xE5, 0xA4, 0x96 },
	0xC6C1, { 0xE5, 0xA4, 0xAE },
	0xC6C2, { 0xE5, 0xA4, 0xB1 },
	0xC6C3, { 0xE5, 0xA5, 0xB4 },
	0xC6C4, { 0xE5, 0xA5, 0xB6 },
	0xC6C5, { 0xE5, 0xAD, 0x95 },
	0xC6C6, { 0xE5, 0xAE, 0x83 },
	0xC6C7, { 0xE5, 0xB0, 0xBC },
	0xC6C8, { 0xE5, 0xB7, 0xA8 },
	0xC6C9, { 0xE5, 0xB7, 0xA7 },
	0xC6CA, { 0xE5, 0xB7, 0xA6 },
	0xC6CB, { 0xE5, 0xB8, 0x82 },
	0xC6CC, { 0xE5, 0xB8, 0x83 },
	0xC6CD, { 0xE5, 0xB9, 0xB3 },
	0xC6CE, { 0xE5, 0xB9, 0xBC },
	0xC6CF, { 0xE5, 0xBC, 0x81 },
	0xC6D0, { 0xE5, 0xBC, 0x98 },
	0xC6D1, { 0xE5, 0xBC, 0x97 },
	0xC6D2, { 0xE5, 0xBF, 0x85 },
	0xC6D3, { 0xE6, 0x88, 0x8A },
	0xC6D4, { 0xE6, 0x89, 0x93 },
	0xC6D5, { 0xE6, 0x89, 0x94 },
	0xC6D6, { 0xE6, 0x89, 0x92 },
	0xC6D7, { 0xE6, 0x89, 0x91 },
	0xC6D8, { 0xE6, 0x96, 0xA5 },
	0xC6D9, { 0xE6, 0x97, 0xA6 },
	0xC6DA, { 0xE6, 0x9C, 0xAE },
	0xC6DB, { 0xE6, 0x9C, 0xAC },
	0xC6DC, { 0xE6, 0x9C, 0xAA },
	0xC6DD, { 0xE6, 0x9C, 0xAB },
	0xC6DE, { 0xE6, 0x9C, 0xAD },
	0xC6DF, { 0xE6, 0xAD, 0xA3 },
	0xC6E0, { 0xE6, 0xAF, 0x8D },
	0xC6E1, { 0xE6, 0xB0, 0x91 },
	0xC6E2, { 0xE6, 0xB0, 0x90 },
	0xC6E3, { 0xE6, 0xB0, 0xB8 },
	0xC6E4, { 0xE6, 0xB1, 0x81 },
	0xC6E5, { 0xE6, 0xB1, 0x80 },
	0xC6E6, { 0xE6, 0xB0, 0xBE },
	0xC6E7, { 0xE7, 0x8A, 0xAF },
	0xC6E8, { 0xE7, 0x8E, 0x84 },
	0xC6E9, { 0xE7, 0x8E, 0x89 },
	0xC6EA, { 0xE7, 0x93, 0x9C },
	0xC6EB, { 0xE7, 0x93, 0xA6 },
	0xC6EC, { 0xE7, 0x94, 0x98 },
	0xC6ED, { 0xE7, 0x94, 0x9F },
	0xC6EE, { 0xE7, 0x94, 0xA8 },
	0xC6EF, { 0xE7, 0x94, 0xA9 },
	0xC6F0, { 0xE7, 0x94, 0xB0 },
	0xC6F1, { 0xE7, 0x94, 0xB1 },
	0xC6F2, { 0xE7, 0x94, 0xB2 },
	0xC6F3, { 0xE7, 0x94, 0xB3 },
	0xC6F4, { 0xE7, 0x96, 0x8B },
	0xC6F5, { 0xE7, 0x99, 0xBD },
	0xC6F6, { 0xE7, 0x9A, 0xAE },
	0xC6F7, { 0xE7, 0x9A, 0xBF },
	0xC6F8, { 0xE7, 0x9B, 0xAE },
	0xC6F9, { 0xE7, 0x9F, 0x9B },
	0xC6FA, { 0xE7, 0x9F, 0xA2 },
	0xC6FB, { 0xE7, 0x9F, 0xB3 },
	0xC6FC, { 0xE7, 0xA4, 0xBA },
	0xC6FD, { 0xE7, 0xA6, 0xBE },
	0xC6FE, { 0xE7, 0xA9, 0xB4 },
	0xC7A1, { 0xE7, 0xAB, 0x8B },
	0xC7A2, { 0xE4, 0xB8, 0x9E },
	0xC7A3, { 0xE4, 0xB8, 0x9F },
	0xC7A4, { 0xE4, 0xB9, 0x92 },
	0xC7A5, { 0xE4, 0xB9, 0x93 },
	0xC7A6, { 0xE4, 0xB9, 0xA9 },
	0xC7A7, { 0xE4, 0xBA, 0x99 },
	0xC7A8, { 0xE4, 0xBA, 0xA4 },
	0xC7A9, { 0xE4, 0xBA, 0xA6 },
	0xC7AA, { 0xE4, 0xBA, 0xA5 },
	0xC7AB, { 0xE4, 0xBB, 0xBF },
	0xC7AC, { 0xE4, 0xBC, 0x89 },
	0xC7AD, { 0xE4, 0xBC, 0x99 },
	0xC7AE, { 0xE4, 0xBC, 0x8A },
	0xC7AF, { 0xE4, 0xBC, 0x95 },
	0xC7B0, { 0xE4, 0xBC, 0x8D },
	0xC7B1, { 0xE4, 0xBC, 0x90 },
	0xC7B2, { 0xE4, 0xBC, 0x91 },
	0xC7B3, { 0xE4, 0xBC, 0x8F },
	0xC7B4, { 0xE4, 0xBB, 0xB2 },
	0xC7B5, { 0xE4, 0xBB, 0xB6 },
	0xC7B6, { 0xE4, 0xBB, 0xBB },
	0xC7B7, { 0xE4, 0xBB, 0xB0 },
	0xC7B8, { 0xE4, 0xBB, 0xB3 },
	0xC7B9, { 0xE4, 0xBB, 0xBD },
	0xC7BA, { 0xE4, 0xBC, 0x81 },
	0xC7BB, { 0xE4, 0xBC, 0x8B },
	0xC7BC, { 0xE5, 0x85, 0x89 },
	0xC7BD, { 0xE5, 0x85, 0x87 },
	0xC7BE, { 0xE5, 0x85, 0x86 },
	0xC7BF, { 0xE5, 0x85, 0x88 },
	0xC7C0, { 0xE5, 0x85, 0xA8 },
	0xC7C1, { 0xE5, 0x85, 0xB1 },
	0xC7C2, { 0xE5, 0x86, 0x8D },
	0xC7C3, { 0xE5, 0x86, 0xB0 },
	0xC7C4, { 0xE5, 0x88, 0x97 },
	0xC7C5, { 0xE5, 0x88, 0x91 },
	0xC7C6, { 0xE5, 0x88, 0x92 },
	0xC7C7, { 0xE5, 0x88, 0x8E },
	0xC7C8, { 0xE5, 0x88, 0x96 },
	0xC7C9, { 0xE5, 0x8A, 0xA3 },
	0xC7CA, { 0xE5, 0x8C, 0x88 },
	0xC7CB, { 0xE5, 0x8C, 0xA1 },
	0xC7CC, { 0xE5, 0x8C, 0xA0 },
	0xC7CD, { 0xE5, 0x8D, 0xB0 },
	0xC7CE, { 0xE5, 0x8D, 0xB1 },
	0xC7CF, { 0xE5, 0x90, 0x89 },
	0xC7D0, { 0xE5, 0x90, 0x8F },
	0xC7D1, { 0xE5, 0x90, 0x8C },
	0xC7D2, { 0xE5, 0x90, 0x8A },
	0xC7D3, { 0xE5, 0x90, 0x90 },
	0xC7D4, { 0xE5, 0x90, 0x81 },
	0xC7D5, { 0xE5, 0x90, 0x8B },
	0xC7D6, { 0xE5, 0x90, 0x84 },
	0xC7D7, { 0xE5, 0x90, 0x91 },
	0xC7D8, { 0xE5, 0x90, 0x8D },
	0xC7D9, { 0xE5, 0x90, 0x88 },
	0xC7DA, { 0xE5, 0x90, 0x83 },
	0xC7DB, { 0xE5, 0x90, 0x8E },
	0xC7DC, { 0xE5, 0x90, 0x86 },
	0xC7DD, { 0xE5, 0x90, 0x92 },
	0xC7DE, { 0xE5, 0x9B, 0xA0 },
	0xC7DF, { 0xE5, 0x9B, 0x9E },
	0xC7E0, { 0xE5, 0x9B, 0x9D },
	0xC7E1, { 0xE5, 0x9C, 0xB3 },
	0xC7E2, { 0xE5, 0x9C, 0xB0 },
	0xC7E3, { 0xE5, 0x9C, 0xA8 },
	0xC7E4, { 0xE5, 0x9C, 0xAD },
	0xC7E5, { 0xE5, 0x9C, 0xAC },
	0xC7E6, { 0xE5, 0x9C, 0xAF },
	0xC7E7, { 0xE5, 0x9C, 0xA9 },
	0xC7E8, { 0xE5, 0xA4, 0x99 },
	0xC7E9, { 0xE5, 0xA4, 0x9A },
	0xC7EA, { 0xE5, 0xA4, 0xB7 },
	0xC7EB, { 0xE5, 0xA4, 0xB8 },
	0xC7EC, { 0xE5, 0xA6, 0x84 },
	0xC7ED, { 0xE5, 0xA5, 0xB8 },
	0xC7EE, { 0xE5, 0xA6, 0x83 },
	0xC7EF, { 0xE5, 0xA5, 0xBD },
	0xC7F0, { 0xE5, 0xA5, 0xB9 },
	0xC7F1, { 0xE5, 0xA6, 0x82 },
	0xC7F2, { 0xE5, 0xA6, 0x81 },
	0xC7F3, { 0xE5, 0xAD, 0x97 },
	0xC7F4, { 0xE5, 0xAD, 0x98 },
	0xC7F5, { 0xE5, 0xAE, 0x87 },
	0xC7F6, { 0xE5, 0xAE, 0x88 },
	0xC7F7, { 0xE5, 0xAE, 0x85 },
	0xC7F8, { 0xE5, 0xAE, 0x89 },
	0xC7F9, { 0xE5, 0xAF, 0xBA },
	0xC7FA, { 0xE5, 0xB0, 0x96 },
	0xC7FB, { 0xE5, 0xB1, 0xB9 },
	0xC7FC, { 0xE5, 0xB7, 0x9E },
	0xC7FD, { 0xE5, 0xB8, 0x86 },
	0xC7FE, { 0xE5, 0xB9, 0xB6 },
	0xC8A1, { 0xE5, 0xB9, 0xB4 },
	0xC8A2, { 0xE5, 0xBC, 0x8F },
	0xC8A3, { 0xE5, 0xBC, 0x9B },
	0xC8A4, { 0xE5, 0xBF, 0x99 },
	0xC8A5, { 0xE5, 0xBF, 0x96 },
	0xC8A6, { 0xE6, 0x88, 0x8E },
	0xC8A7, { 0xE6, 0x88, 0x8C },
	0xC8A8, { 0xE6, 0x88, 0x8D },
	0xC8A9, { 0xE6, 0x88, 0x90 },
	0xC8AA, { 0xE6, 0x89, 0xA3 },
	0xC8AB, { 0xE6, 0x89, 0x9B },
	0xC8AC, { 0xE6, 0x89, 0x98 },
	0xC8AD, { 0xE6, 0x94, 0xB6 },
	0xC8AE, { 0xE6, 0x97, 0xA9 },
	0xC8AF, { 0xE6, 0x97, 0xA8 },
	0xC8B0, { 0xE6, 0x97, 0xAC },
	0xC8B1, { 0xE6, 0x97, 0xAD },
	0xC8B2, { 0xE6, 0x9B, 0xB2 },
	0xC8B3, { 0xE6, 0x9B, 0xB3 },
	0xC8B4, { 0xE6, 0x9C, 0x89 },
	0xC8B5, { 0xE6, 0x9C, 0xBD },
	0xC8B6, { 0xE6, 0x9C, 0xB4 },
	0xC8B7, { 0xE6, 0x9C, 0xB1 },
	0xC8B8, { 0xE6, 0x9C, 0xB5 },
	0xC8B9, { 0xE6, 0xAC, 0xA1 },
	0xC8BA, { 0xE6, 0xAD, 0xA4 },
	0xC8BB, { 0xE6, 0xAD, 0xBB },
	0xC8BC, { 0xE6, 0xB0, 0x96 },
	0xC8BD, { 0xE6, 0xB1, 0x9D },
	0xC8BE, { 0xE6, 0xB1, 0x97 },
	0xC8BF, { 0xE6, 0xB1, 0x99 },
	0xC8C0, { 0xE6, 0xB1, 0x9F },
	0xC8C1, { 0xE6, 0xB1, 0xA0 },
	0xC8C2, { 0xE6, 0xB1, 0x90 },
	0xC8C3, { 0xE6, 0xB1, 0x95 },
	0xC8C4, { 0xE6, 0xB1, 0xA1 },
	0xC8C5, { 0xE6, 0xB1, 0x9B },
	0xC8C6, { 0xE6, 0xB1, 0x8D },
	0xC8C7, { 0xE6, 0xB1, 0x8E },
	0xC8C8, { 0xE7, 0x81, 0xB0 },
	0xC8C9, { 0xE7, 0x89, 0x9F },
	0xC8CA, { 0xE7, 0x89, 0x9D },
	0xC8CB, { 0xE7, 0x99, 0xBE },
	0xC8CC, { 0xE7, 0xAB, 0xB9 },
	0xC8CD, { 0xE7, 0xB1, 0xB3 },
	0xC8CE, { 0xE7, 0xB3, 0xB8 },
	0xC8CF, { 0xE7, 0xBC, 0xB6 },
	0xC8D0, { 0xE7, 0xBE, 0x8A },
	0xC8D1, { 0xE7, 0xBE, 0xBD },
	0xC8D2, { 0xE8, 0x80, 0x81 },
	0xC8D3, { 0xE8, 0x80, 0x83 },
	0xC8D4, { 0xE8, 0x80, 0x8C },
	0xC8D5, { 0xE8, 0x80, 0x92 },
	0xC8D6, { 0xE8, 0x80, 0xB3 },
	0xC8D7, { 0xE8, 0x81, 0xBF },
	0xC8D8, { 0xE8, 0x82, 0x89 },
	0xC8D9, { 0xE8, 0x82, 0x8B },
	0xC8DA, { 0xE8, 0x82, 0x8C },
	0xC8DB, { 0xE8, 0x87, 0xA3 },
	0xC8DC, { 0xE8, 0x87, 0xAA },
	0xC8DD, { 0xE8, 0x87, 0xB3 },
	0xC8DE, { 0xE8, 0x87, 0xBC },
	0xC8DF, { 0xE8, 0x88, 0x8C },
	0xC8E0, { 0xE8, 0x88, 0x9B },
	0xC8E1, { 0xE8, 0x88, 0x9F },
	0xC8E2, { 0xE8, 0x89, 0xAE },
	0xC8E3, { 0xE8, 0x89, 0xB2 },
	0xC8E4, { 0xE8, 0x89, 0xBE },
	0xC8E5, { 0xE8, 0x99, 0xAB },
	0xC8E6, { 0xE8, 0xA1, 0x80 },
	0xC8E7, { 0xE8, 0xA1, 0x8C },
	0xC8E8, { 0xE8, 0xA1, 0xA3 },
	0xC8E9, { 0xE8, 0xA5, 0xBF },
	0xC8EA, { 0xE9, 0x98, 0xA1 },
	0xC8EB, { 0xE4, 0xB8, 0xB2 },
	0xC8EC, { 0xE4, 0xBA, 0xA8 },
	0xC8ED, { 0xE4, 0xBD, 0x8D },
	0xC8EE, { 0xE4, 0xBD, 0x8F },
	0xC8EF, { 0xE4, 0xBD, 0x87 },
	0xC8F0, { 0xE4, 0xBD, 0x97 },
	0xC8F1, { 0xE4, 0xBD, 0x9E },
	0xC8F2, { 0xE4, 0xBC, 0xB4 },
	0xC8F3, { 0xE4, 0xBD, 0x9B },
	0xC8F4, { 0xE4, 0xBD, 0x95 },
	0xC8F5, { 0xE4, 0xBC, 0xB0 },
	0xC8F6, { 0xE4, 0xBD, 0x90 },
	0xC8F7, { 0xE4, 0xBD, 0x91 },
	0xC8F8, { 0xE4, 0xBC, 0xBD },
	0xC8F9, { 0xE4, 0xBC, 0xBA },
	0xC8FA, { 0xE4, 0xBC, 0xB8 },
	0xC8FB, { 0xE4, 0xBD, 0x83 },
	0xC8FC, { 0xE4, 0xBD, 0x94 },
	0xC8FD, { 0xE4, 0xBC, 0xBC },
	0xC8FE, { 0xE4, 0xBD, 0x86 },
	0xC9A1, { 0xE4, 0xBD, 0xA3 },
	0xC9A2, { 0xE4, 0xBD, 0x9C },
	0xC9A3, { 0xE4, 0xBD, 0xA0 },
	0xC9A4, { 0xE4, 0xBC, 0xAF },
	0xC9A5, { 0xE4, 0xBD, 0x8E },
	0xC9A6, { 0xE4, 0xBC, 0xB6 },
	0xC9A7, { 0xE4, 0xBD, 0x99 },
	0xC9A8, { 0xE4, 0xBD, 0x9D },
	0xC9A9, { 0xE4, 0xBD, 0x88 },
	0xC9AA, { 0xE4, 0xBD, 0x9A },
	0xC9AB, { 0xE5, 0x85, 0x8C },
	0xC9AC, { 0xE5, 0x85, 0x8B },
	0xC9AD, { 0xE5, 0x85, 0x8D },
	0xC9AE, { 0xE5, 0x85, 0xB5 },
	0xC9AF, { 0xE5, 0x86, 0xB6 },
	0xC9B0, { 0xE5, 0x86, 0xB7 },
	0xC9B1, { 0xE5, 0x88, 0xA5 },
	0xC9B2, { 0xE5, 0x88, 0xA4 },
	0xC9B3, { 0xE5, 0x88, 0xA9 },
	0xC9B4, { 0xE5, 0x88, 0xAA },
	0xC9B5, { 0xE5, 0x88, 0xA8 },
	0xC9B6, { 0xE5, 0x8A, 0xAB },
	0xC9B7, { 0xE5, 0x8A, 0xA9 },
	0xC9B8, { 0xE5, 0x8A, 0xAA },
	0xC9B9, { 0xE5, 0x8A, 0xAC },
	0xC9BA, { 0xE5, 0x8C, 0xA3 },
	0xC9BB, { 0xE5, 0x8D, 0xB3 },
	0xC9BC, { 0xE5, 0x8D, 0xB5 },
	0xC9BD, { 0xE5, 0x90, 0x9D },
	0xC9BE, { 0xE5, 0x90, 0xAD },
	0xC9BF, { 0xE5, 0x90, 0x9E },
	0xC9C0, { 0xE5, 0x90, 0xBE },
	0xC9C1, { 0xE5, 0x90, 0xA6 },
	0xC9C2, { 0xE5, 0x91, 0x8E },
	0xC9C3, { 0xE5, 0x90, 0xA7 },
	0xC9C4, { 0xE5, 0x91, 0x86 },
	0xC9C5, { 0xE5, 0x91, 0x83 },
	0xC9C6, { 0xE5, 0x90, 0xB3 },
	0xC9C7, { 0xE5, 0x91, 0x88 },
	0xC9C8, { 0xE5, 0x91, 0x82 },
	0xC9C9, { 0xE5, 0x90, 0x9B },
	0xC9CA, { 0xE5, 0x90, 0xA9 },
	0xC9CB, { 0xE5, 0x91, 0x8A },
	0xC9CC, { 0xE5, 0x90, 0xB9 },
	0xC9CD, { 0xE5, 0x90, 0xBB },
	0xC9CE, { 0xE5, 0x90, 0xB8 },
	0xC9CF, { 0xE5, 0x90, 0xAE },
	0xC9D0, { 0xE5, 0x90, 0xB5 },
	0xC9D1, { 0xE5, 0x90, 0xB6 },
	0xC9D2, { 0xE5, 0x90, 0xA0 },
	0xC9D3, { 0xE5, 0x90, 0xBC },
	0xC9D4, { 0xE5, 0x91, 0x80 },
	0xC9D5, { 0xE5, 0x90, 0xB1 },
	0xC9D6, { 0xE5, 0x90, 0xAB },
	0xC9D7, { 0xE5, 0x90, 0x9F },
	0xC9D8, { 0xE5, 0x90, 0xAC },
	0xC9D9, { 0xE5, 0x9B, 0xAA },
	0xC9DA, { 0xE5, 0x9B, 0xB0 },
	0xC9DB, { 0xE5, 0x9B, 0xA4 },
	0xC9DC, { 0xE5, 0x9B, 0xAB },
	0xC9DD, { 0xE5, 0x9D, 0x8A },
	0xC9DE, { 0xE5, 0x9D, 0x91 },
	0xC9DF, { 0xE5, 0x9D, 0x80 },
	0xC9E0, { 0xE5, 0x9D, 0x8D },
	0xC9E1, { 0xE5, 0x9D, 0x87 },
	0xC9E2, { 0xE5, 0x9D, 0x8E },
	0xC9E3, { 0xE5, 0x9C, 0xBE },
	0xC9E4, { 0xE5, 0x9D, 0x90 },
	0xC9E5, { 0xE5, 0x9D, 0x8F },
	0xC9E6, { 0xE5, 0x9C, 0xBB },
	0xC9E7, { 0xE5, 0xA3, 0xAF },
	0xC9E8, { 0xE5, 0xA4, 0xBE },
	0xC9E9, { 0xE5, 0xA6, 0x9D },
	0xC9EA, { 0xE5, 0xA6, 0x92 },
	0xC9EB, { 0xE5, 0xA6, 0xA8 },
	0xC9EC, { 0xE5, 0xA6, 0x9E },
	0xC9ED, { 0xE5, 0xA6, 0xA3 },
	0xC9EE, { 0xE5, 0xA6, 0x99 },
	0xC9EF, { 0xE5, 0xA6, 0x96 },
	0xC9F0, { 0xE5, 0xA6, 0x8D },
	0xC9F1, { 0xE5, 0xA6, 0xA4 },
	0xC9F2, { 0xE5, 0xA6, 0x93 },
	0xC9F3, { 0xE5, 0xA6, 0x8A },
	0xC9F4, { 0xE5, 0xA6, 0xA5 },
	0xC9F5, { 0xE5, 0xAD, 0x9D },
	0xC9F6, { 0xE5, 0xAD, 0x9C },
	0xC9F7, { 0xE5, 0xAD, 0x9A },
	0xC9F8, { 0xE5, 0xAD, 0x9B },
	0xC9F9, { 0xE5, 0xAE, 0x8C },
	0xC9FA, { 0xE5, 0xAE, 0x8B },
	0xC9FB, { 0xE5, 0xAE, 0x8F },
	0xC9FC, { 0xE5, 0xB0, 0xAC },
	0xC9FD, { 0xE5, 0xB1, 0x80 },
	0xC9FE, { 0xE5, 0xB1, 0x81 },
	0xCAA1, { 0xE5, 0xB0, 0xBF },
	0xCAA2, { 0xE5, 0xB0, 0xBE },
	0xCAA3, { 0xE5, 0xB2, 0x90 },
	0xCAA4, { 0xE5, 0xB2, 0x91 },
	0xCAA5, { 0xE5, 0xB2, 0x94 },
	0xCAA6, { 0xE5, 0xB2, 0x8C },
	0xCAA7, { 0xE5, 0xB7, 0xAB },
	0xCAA8, { 0xE5, 0xB8, 0x8C },
	0xCAA9, { 0xE5, 0xBA, 0x8F },
	0xCAAA, { 0xE5, 0xBA, 0x87 },
	0xCAAB, { 0xE5, 0xBA, 0x8A },
	0xCAAC, { 0xE5, 0xBB, 0xB7 },
	0xCAAD, { 0xE5, 0xBC, 0x84 },
	0xCAAE, { 0xE5, 0xBC, 0x9F },
	0xCAAF, { 0xE5, 0xBD, 0xA4 },
	0xCAB0, { 0xE5, 0xBD, 0xA2 },
	0xCAB1, { 0xE5, 0xBD, 0xB7 },
	0xCAB2, { 0xE5, 0xBD, 0xB9 },
	0xCAB3, { 0xE5, 0xBF, 0x98 },
	0xCAB4, { 0xE5, 0xBF, 0x8C },
	0xCAB5, { 0xE5, 0xBF, 0x97 },
	0xCAB6, { 0xE5, 0xBF, 0x8D },
	0xCAB7, { 0xE5, 0xBF, 0xB1 },
	0xCAB8, { 0xE5, 0xBF, 0xAB },
	0xCAB9, { 0xE5, 0xBF, 0xB8 },
	0xCABA, { 0xE5, 0xBF, 0xAA },
	0xCABB, { 0xE6, 0x88, 0x92 },
	0xCABC, { 0xE6, 0x88, 0x91 },
	0xCABD, { 0xE6, 0x8A, 0x84 },
	0xCABE, { 0xE6, 0x8A, 0x97 },
	0xCABF, { 0xE6, 0x8A, 0x96 },
	0xCAC0, { 0xE6, 0x8A, 0x80 },
	0xCAC1, { 0xE6, 0x89, 0xB6 },
	0xCAC2, { 0xE6, 0x8A, 0x89 },
	0xCAC3, { 0xE6, 0x89, 0xAD },
	0xCAC4, { 0xE6, 0x8A, 0x8A },
	0xCAC5, { 0xE6, 0x89, 0xBC },
	0xCAC6, { 0xE6, 0x89, 0xBE },
	0xCAC7, { 0xE6, 0x89, 0xB9 },
	0xCAC8, { 0xE6, 0x89, 0xB3 },
	0xCAC9, { 0xE6, 0x8A, 0x92 },
	0xCACA, { 0xE6, 0x89, 0xAF },
	0xCACB, { 0xE6, 0x8A, 0x98 },
	0xCACC, { 0xE6, 0x89, 0xAE },
	0xCACD, { 0xE6, 0x8A, 0x95 },
	0xCACE, { 0xE6, 0x8A, 0x93 },
	0xCACF, { 0xE6, 0x8A, 0x91 },
	0xCAD0, { 0xE6, 0x8A, 0x86 },
	0xCAD1, { 0xE6, 0x94, 0xB9 },
	0xCAD2, { 0xE6, 0x94, 0xBB },
	0xCAD3, { 0xE6, 0x94, 0xB8 },
	0xCAD4, { 0xE6, 0x97, 0xB1 },
	0xCAD5, { 0xE6, 0x9B, 0xB4 },
	0xCAD6, { 0xE6, 0x9D, 0x9F },
	0xCAD7, { 0xE6, 0x9D, 0x8E },
	0xCAD8, { 0xE6, 0x9D, 0x8F },
	0xCAD9, { 0xE6, 0x9D, 0x90 },
	0xCADA, { 0xE6, 0x9D, 0x91 },
	0xCADB, { 0xE6, 0x9D, 0x9C },
	0xCADC, { 0xE6, 0x9D, 0x96 },
	0xCADD, { 0xE6, 0x9D, 0x9E },
	0xCADE, { 0xE6, 0x9D, 0x89 },
	0xCADF, { 0xE6, 0x9D, 0x86 },
	0xCAE0, { 0xE6, 0x9D, 0xA0 },
	0xCAE1, { 0xE6, 0x9D, 0x93 },
	0xCAE2, { 0xE6, 0x9D, 0x97 },
	0xCAE3, { 0xE6, 0xAD, 0xA5 },
	0xCAE4, { 0xE6, 0xAF, 0x8F },
	0xCAE5, { 0xE6, 0xB1, 0x82 },
	0xCAE6, { 0xE6, 0xB1, 0x9E },
	0xCAE7, { 0xE6, 0xB2, 0x99 },
	0xCAE8, { 0xE6, 0xB2, 0x81 },
	0xCAE9, { 0xE6, 0xB2, 0x88 },
	0xCAEA, { 0xE6, 0xB2, 0x89 },
	0xCAEB, { 0xE6, 0xB2, 0x85 },
	0xCAEC, { 0xE6, 0xB2, 0x9B },
	0xCAED, { 0xE6, 0xB1, 0xAA },
	0xCAEE, { 0xE6, 0xB1, 0xBA },
	0xCAEF, { 0xE6, 0xB2, 0x90 },
	0xCAF0, { 0xE6, 0xB1, 0xB0 },
	0xCAF1, { 0xE6, 0xB2, 0x8C },
	0xCAF2, { 0xE6, 0xB1, 0xA8 },
	0xCAF3, { 0xE6, 0xB2, 0x96 },
	0xCAF4, { 0xE6, 0xB2, 0x92 },
	0xCAF5, { 0xE6, 0xB1, 0xBD },
	0xCAF6, { 0xE6, 0xB2, 0x83 },
	0xCAF7, { 0xE6, 0xB1, 0xB2 },
	0xCAF8, { 0xE6, 0xB1, 0xBE },
	0xCAF9, { 0xE6, 0xB1, 0xB4 },
	0xCAFA, { 0xE6, 0xB2, 0x86 },
	0xCAFB, { 0xE6, 0xB1, 0xB6 },
	0xCAFC, { 0xE6, 0xB2, 0x8D },
	0xCAFD, { 0xE6, 0xB2, 0x94 },
	0xCAFE, { 0xE6, 0xB2, 0x98 },
	0xCBA1, { 0xE6, 0xB2, 0x82 },
	0xCBA2, { 0xE7, 0x81, 0xB6 },
	0xCBA3, { 0xE7, 0x81, 0xBC },
	0xCBA4, { 0xE7, 0x81, 0xBD },
	0xCBA5, { 0xE7, 0x81, 0xB8 },
	0xCBA6, { 0xE7, 0x89, 0xA2 },
	0xCBA7, { 0xE7, 0x89, 0xA1 },
	0xCBA8, { 0xE7, 0x89, 0xA0 },
	0xCBA9, { 0xE7, 0x8B, 0x84 },
	0xCBAA, { 0xE7, 0x8B, 0x82 },
	0xCBAB, { 0xE7, 0x8E, 0x96 },
	0xCBAC, { 0xE7, 0x94, 0xAC },
	0xCBAD, { 0xE7, 0x94, 0xAB },
	0xCBAE, { 0xE7, 0x94, 0xB7 },
	0xCBAF, { 0xE7, 0x94, 0xB8 },
	0xCBB0, { 0xE7, 0x9A, 0x82 },
	0xCBB1, { 0xE7, 0x9B, 0xAF },
	0xCBB2, { 0xE7, 0x9F, 0xA3 },
	0xCBB3, { 0xE7, 0xA7, 0x81 },
	0xCBB4, { 0xE7, 0xA7, 0x80 },
	0xCBB5, { 0xE7, 0xA6, 0xBF },
	0xCBB6, { 0xE7, 0xA9, 0xB6 },
	0xCBB7, { 0xE7, 0xB3, 0xBB },
	0xCBB8, { 0xE7, 0xBD, 0x95 },
	0xCBB9, { 0xE8, 0x82, 0x96 },
	0xCBBA, { 0xE8, 0x82, 0x93 },
	0xCBBB, { 0xE8, 0x82, 0x9D },
	0xCBBC, { 0xE8, 0x82, 0x98 },
	0xCBBD, { 0xE8, 0x82, 0x9B },
	0xCBBE, { 0xE8, 0x82, 0x9A },
	0xCBBF, { 0xE8, 0x82, 0xB2 },
	0xCBC0, { 0xE8, 0x89, 0xAF },
	0xCBC1, { 0xE8, 0x8A, 0x92 },
	0xCBC2, { 0xE8, 0x8A, 0x8B },
	0xCBC3, { 0xE8, 0x8A, 0x8D },
	0xCBC4, { 0xE8, 0xA6, 0x8B },
	0xCBC5, { 0xE8, 0xA7, 0x92 },
	0xCBC6, { 0xE8, 0xA8, 0x80 },
	0xCBC7, { 0xE8, 0xB0, 0xB7 },
	0xCBC8, { 0xE8, 0xB1, 0x86 },
	0xCBC9, { 0xE8, 0xB1, 0x95 },
	0xCBCA, { 0xE8, 0xB2, 0x9D },
	0xCBCB, { 0xE8, 0xB5, 0xA4 },
	0xCBCC, { 0xE8, 0xB5, 0xB0 },
	0xCBCD, { 0xE8, 0xB6, 0xB3 },
	0xCBCE, { 0xE8, 0xBA, 0xAB },
	0xCBCF, { 0xE8, 0xBB, 0x8A },
	0xCBD0, { 0xE8, 0xBE, 0x9B },
	0xCBD1, { 0xE8, 0xBE, 0xB0 },
	0xCBD2, { 0xE8, 0xBF, 0x82 },
	0xCBD3, { 0xE8, 0xBF, 0x86 },
	0xCBD4, { 0xE8, 0xBF, 0x85 },
	0xCBD5, { 0xE8, 0xBF, 0x84 },
	0xCBD6, { 0xE5, 0xB7, 0xA1 },
	0xCBD7, { 0xE9, 0x82, 0x91 },
	0xCBD8, { 0xE9, 0x82, 0xA2 },
	0xCBD9, { 0xE9, 0x82, 0xAA },
	0xCBDA, { 0xE9, 0x82, 0xA6 },
	0xCBDB, { 0xE9, 0x82, 0xA3 },
	0xCBDC, { 0xE9, 0x85, 0x89 },
	0xCBDD, { 0xE9, 0x87, 0x86 },
	0xCBDE, { 0xE9, 0x87, 0x8C },
	0xCBDF, { 0xE9, 0x98, 0xB2 },
	0xCBE0, { 0xE9, 0x98, 0xAE },
	0xCBE1, { 0xE9, 0x98, 0xB1 },
	0xCBE2, { 0xE9, 0x98, 0xAA },
	0xCBE3, { 0xE9, 0x98, 0xAC },
	0xCBE4, { 0xE4, 0xB8, 0xA6 },
	0xCBE5, { 0xE4, 0xB9, 0x96 },
	0xCBE6, { 0xE4, 0xB9, 0xB3 },
	0xCBE7, { 0xE4, 0xBA, 0x8B },
	0xCBE8, { 0xE4, 0xBA, 0x9B },
	0xCBE9, { 0xE4, 0xBA, 0x9E },
	0xCBEA, { 0xE4, 0xBA, 0xAB },
	0xCBEB, { 0xE4, 0xBA, 0xAC },
	0xCBEC, { 0xE4, 0xBD, 0xAF },
	0xCBED, { 0xE4, 0xBE, 0x9D },
	0xCBEE, { 0xE4, 0xBE, 0x8D },
	0xCBEF, { 0xE4, 0xBD, 0xB3 },
	0xCBF0, { 0xE4, 0xBD, 0xBF },
	0xCBF1, { 0xE4, 0xBD, 0xAC },
	0xCBF2, { 0xE4, 0xBE, 0x9B },
	0xCBF3, { 0xE4, 0xBE, 0x8B },
	0xCBF4, { 0xE4, 0xBE, 0x86 },
	0xCBF5, { 0xE4, 0xBE, 0x83 },
	0xCBF6, { 0xE4, 0xBD, 0xB0 },
	0xCBF7, { 0xE4, 0xBD, 0xB5 },
	0xCBF8, { 0xE4, 0xBE, 0x88 },
	0xCBF9, { 0xE4, 0xBD, 0xA9 },
	0xCBFA, { 0xE4, 0xBD, 0xBB },
	0xCBFB, { 0xE4, 0xBE, 0x96 },
	0xCBFC, { 0xE4, 0xBD, 0xBE },
	0xCBFD, { 0xE4, 0xBE, 0x8F },
	0xCBFE, { 0xE4, 0xBE, 0x91 },
	0xCCA1, { 0xE4, 0xBD, 0xBA },
	0xCCA2, { 0xE5, 0x85, 0x94 },
	0xCCA3, { 0xE5, 0x85, 0x92 },
	0xCCA4, { 0xE5, 0x85, 0x95 },
	0xCCA5, { 0xE5, 0x85, 0xA9 },
	0xCCA6, { 0xE5, 0x85, 0xB7 },
	0xCCA7, { 0xE5, 0x85, 0xB6 },
	0xCCA8, { 0xE5, 0x85, 0xB8 },
	0xCCA9, { 0xE5, 0x86, 0xBD },
	0xCCAA, { 0xE5, 0x87, 0xBD },
	0xCCAB, { 0xE5, 0x88, 0xBB },
	0xCCAC, { 0xE5, 0x88, 0xB8 },
	0xCCAD, { 0xE5, 0x88, 0xB7 },
	0xCCAE, { 0xE5, 0x88, 0xBA },
	0xCCAF, { 0xE5, 0x88, 0xB0 },
	0xCCB0, { 0xE5, 0x88, 0xAE },
	0xCCB1, { 0xE5, 0x88, 0xB6 },
	0xCCB2, { 0xE5, 0x89, 0x81 },
	0xCCB3, { 0xE5, 0x8A, 0xBE },
	0xCCB4, { 0xE5, 0x8A, 0xBB },
	0xCCB5, { 0xE5, 0x8D, 0x92 },
	0xCCB6, { 0xE5, 0x8D, 0x94 },
	0xCCB7, { 0xE5, 0x8D, 0x93 },
	0xCCB8, { 0xE5, 0x8D, 0x91 },
	0xCCB9, { 0xE5, 0x8D, 0xA6 },
	0xCCBA, { 0xE5, 0x8D, 0xB7 },
	0xCCBB, { 0xE5, 0x8D, 0xB8 },
	0xCCBC, { 0xE5, 0x8D, 0xB9 },
	0xCCBD, { 0xE5, 0x8F, 0x96 },
	0xCCBE, { 0xE5, 0x8F, 0x94 },
	0xCCBF, { 0xE5, 0x8F, 0x97 },
	0xCCC0, { 0xE5, 0x91, 0xB3 },
	0xCCC1, { 0xE5, 0x91, 0xB5 },
	0xCCC2, { 0xE5, 0x92, 0x96 },
	0xCCC3, { 0xE5, 0x91, 0xB8 },
	0xCCC4, { 0xE5, 0x92, 0x95 },
	0xCCC5, { 0xE5, 0x92, 0x80 },
	0xCCC6, { 0xE5, 0x91, 0xBB },
	0xCCC7, { 0xE5, 0x91, 0xB7 },
	0xCCC8, { 0xE5, 0x92, 0x84 },
	0xCCC9, { 0xE5, 0x92, 0x92 },
	0xCCCA, { 0xE5, 0x92, 0x86 },
	0xCCCB, { 0xE5, 0x91, 0xBC },
	0xCCCC, { 0xE5, 0x92, 0x90 },
	0xCCCD, { 0xE5, 0x91, 0xB1 },
	0xCCCE, { 0xE5, 0x91, 0xB6 },
	0xCCCF, { 0xE5, 0x92, 0x8C },
	0xCCD0, { 0xE5, 0x92, 0x9A },
	0xCCD1, { 0xE5, 0x91, 0xA2 },
	0xCCD2, { 0xE5, 0x91, 0xA8 },
	0xCCD3, { 0xE5, 0x92, 0x8B },
	0xCCD4, { 0xE5, 0x91, 0xBD },
	0xCCD5, { 0xE5, 0x92, 0x8E },
	0xCCD6, { 0xE5, 0x9B, 0xBA },
	0xCCD7, { 0xE5, 0x9E, 0x83 },
	0xCCD8, { 0xE5, 0x9D, 0xB7 },
	0xCCD9, { 0xE5, 0x9D, 0xAA },
	0xCCDA, { 0xE5, 0x9D, 0xA9 },
	0xCCDB, { 0xE5, 0x9D, 0xA1 },
	0xCCDC, { 0xE5, 0x9D, 0xA6 },
	0xCCDD, { 0xE5, 0x9D, 0xA4 },
	0xCCDE, { 0xE5, 0x9D, 0xBC },
	0xCCDF, { 0xE5, 0xA4, 0x9C },
	0xCCE0, { 0xE5, 0xA5, 0x89 },
	0xCCE1, { 0xE5, 0xA5, 0x87 },
	0xCCE2, { 0xE5, 0xA5, 0x88 },
	0xCCE3, { 0xE5, 0xA5, 0x84 },
	0xCCE4, { 0xE5, 0xA5, 0x94 },
	0xCCE5, { 0xE5, 0xA6, 0xBE },
	0xCCE6, { 0xE5, 0xA6, 0xBB },
	0xCCE7, { 0xE5, 0xA7, 0x94 },
	0xCCE8, { 0xE5, 0xA6, 0xB9 },
	0xCCE9, { 0xE5, 0xA6, 0xAE },
	0xCCEA, { 0xE5, 0xA7, 0x91 },
	0xCCEB, { 0xE5, 0xA7, 0x86 },
	0xCCEC, { 0xE5, 0xA7, 0x90 },
	0xCCED, { 0xE5, 0xA7, 0x8D },
	0xCCEE, { 0xE5, 0xA7, 0x8B },
	0xCCEF, { 0xE5, 0xA7, 0x93 },
	0xCCF0, { 0xE5, 0xA7, 0x8A },
	0xCCF1, { 0xE5, 0xA6, 0xAF },
	0xCCF2, { 0xE5, 0xA6, 0xB3 },
	0xCCF3, { 0xE5, 0xA7, 0x92 },
	0xCCF4, { 0xE5, 0xA7, 0x85 },
	0xCCF5, { 0xE5, 0xAD, 0x9F },
	0xCCF6, { 0xE5, 0xAD, 0xA4 },
	0xCCF7, { 0xE5, 0xAD, 0xA3 },
	0xCCF8, { 0xE5, 0xAE, 0x97 },
	0xCCF9, { 0xE5, 0xAE, 0x9A },
	0xCCFA, { 0xE5, 0xAE, 0x98 },
	0xCCFB, { 0xE5, 0xAE, 0x9C },
	0xCCFC, { 0xE5, 0xAE, 0x99 },
	0xCCFD, { 0xE5, 0xAE, 0x9B },
	0xCCFE, { 0xE5, 0xB0, 0x9A },
	0xCDA1, { 0xE5, 0xB1, 0x88 },
	0xCDA2, { 0xE5, 0xB1, 0x85 },
	0xCDA3, { 0xE5, 0xB1, 0x86 },
	0xCDA4, { 0xE5, 0xB2, 0xB7 },
	0xCDA5, { 0xE5, 0xB2, 0xA1 },
	0xCDA6, { 0xE5, 0xB2, 0xB8 },
	0xCDA7, { 0xE5, 0xB2, 0xA9 },
	0xCDA8, { 0xE5, 0xB2, 0xAB },
	0xCDA9, { 0xE5, 0xB2, 0xB1 },
	0xCDAA, { 0xE5, 0xB2, 0xB3 },
	0xCDAB, { 0xE5, 0xB8, 0x98 },
	0xCDAC, { 0xE5, 0xB8, 0x9A },
	0xCDAD, { 0xE5, 0xB8, 0x96 },
	0xCDAE, { 0xE5, 0xB8, 0x95 },
	0xCDAF, { 0xE5, 0xB8, 0x9B },
	0xCDB0, { 0xE5, 0xB8, 0x91 },
	0xCDB1, { 0xE5, 0xB9, 0xB8 },
	0xCDB2, { 0xE5, 0xBA, 0x9A },
	0xCDB3, { 0xE5, 0xBA, 0x97 },
	0xCDB4, { 0xE5, 0xBA, 0x9C },
	0xCDB5, { 0xE5, 0xBA, 0x95 },
	0xCDB6, { 0xE5, 0xBA, 0x96 },
	0xCDB7, { 0xE5, 0xBB, 0xB6 },
	0xCDB8, { 0xE5, 0xBC, 0xA6 },
	0xCDB9, { 0xE5, 0xBC, 0xA7 },
	0xCDBA, { 0xE5, 0xBC, 0xA9 },
	0xCDBB, { 0xE5, 0xBE, 0x80 },
	0xCDBC, { 0xE5, 0xBE, 0x81 },
	0xCDBD, { 0xE5, 0xBD, 0xBF },
	0xCDBE, { 0xE5, 0xBD, 0xBC },
	0xCDBF, { 0xE5, 0xBF, 0x9D },
	0xCDC0, { 0xE5, 0xBF, 0xA0 },
	0xCDC1, { 0xE5, 0xBF, 0xBD },
	0xCDC2, { 0xE5, 0xBF, 0xB5 },
	0xCDC3, { 0xE5, 0xBF, 0xBF },
	0xCDC4, { 0xE6, 0x80, 0x8F },
	0xCDC5, { 0xE6, 0x80, 0x94 },
	0xCDC6, { 0xE6, 0x80, 0xAF },
	0xCDC7, { 0xE6, 0x80, 0xB5 },
	0xCDC8, { 0xE6, 0x80, 0x96 },
	0xCDC9, { 0xE6, 0x80, 0xAA },
	0xCDCA, { 0xE6, 0x80, 0x95 },
	0xCDCB, { 0xE6, 0x80, 0xA1 },
	0xCDCC, { 0xE6, 0x80, 0xA7 },
	0xCDCD, { 0xE6, 0x80, 0xA9 },
	0xCDCE, { 0xE6, 0x80, 0xAB },
	0xCDCF, { 0xE6, 0x80, 0x9B },
	0xCDD0, { 0xE6, 0x88, 0x96 },
	0xCDD1, { 0xE6, 0x88, 0x95 },
	0xCDD2, { 0xE6, 0x88, 0xBF },
	0xCDD3, { 0xE6, 0x88, 0xBE },
	0xCDD4, { 0xE6, 0x89, 0x80 },
	0xCDD5, { 0xE6, 0x89, 0xBF },
	0xCDD6, { 0xE6, 0x8B, 0x89 },
	0xCDD7, { 0xE6, 0x8B, 0x8C },
	0xCDD8, { 0xE6, 0x8B, 0x84 },
	0xCDD9, { 0xE6, 0x8A, 0xBF },
	0xCDDA, { 0xE6, 0x8B, 0x82 },
	0xCDDB, { 0xE6, 0x8A, 0xB9 },
	0xCDDC, { 0xE6, 0x8B, 0x92 },
	0xCDDD, { 0xE6, 0x8B, 0x9B },
	0xCDDE, { 0xE6, 0x8A, 0xAB },
	0xCDDF, { 0xE6, 0x8B, 0x93 },
	0xCDE0, { 0xE6, 0x8B, 0x94 },
	0xCDE1, { 0xE6, 0x8B, 0x8B },
	0xCDE2, { 0xE6, 0x8B, 0x88 },
	0xCDE3, { 0xE6, 0x8A, 0xA8 },
	0xCDE4, { 0xE6, 0x8A, 0xBD },
	0xCDE5, { 0xE6, 0x8A, 0xBC },
	0xCDE6, { 0xE6, 0x8B, 0x90 },
	0xCDE7, { 0xE6, 0x8B, 0x99 },
	0xCDE8, { 0xE6, 0x8B, 0x87 },
	0xCDE9, { 0xE6, 0x8B, 0x8D },
	0xCDEA, { 0xE6, 0x8A, 0xB5 },
	0xCDEB, { 0xE6, 0x8B, 0x9A },
	0xCDEC, { 0xE6, 0x8A, 0xB1 },
	0xCDED, { 0xE6, 0x8B, 0x98 },
	0xCDEE, { 0xE6, 0x8B, 0x96 },
	0xCDEF, { 0xE6, 0x8B, 0x97 },
	0xCDF0, { 0xE6, 0x8B, 0x86 },
	0xCDF1, { 0xE6, 0x8A, 0xAC },
	0xCDF2, { 0xE6, 0x8B, 0x8E },
	0xCDF3, { 0xE6, 0x94, 0xBE },
	0xCDF4, { 0xE6, 0x96, 0xA7 },
	0xCDF5, { 0xE6, 0x96, 0xBC },
	0xCDF6, { 0xE6, 0x97, 0xBA },
	0xCDF7, { 0xE6, 0x98, 0x94 },
	0xCDF8, { 0xE6, 0x98, 0x93 },
	0xCDF9, { 0xE6, 0x98, 0x8C },
	0xCDFA, { 0xE6, 0x98, 0x86 },
	0xCDFB, { 0xE6, 0x98, 0x82 },
	0xCDFC, { 0xE6, 0x98, 0x8E },
	0xCDFD, { 0xE6, 0x98, 0x80 },
	0xCDFE, { 0xE6, 0x98, 0x8F },
	0xCEA1, { 0xE6, 0x98, 0x95 },
	0xCEA2, { 0xE6, 0x98, 0x8A },
	0xCEA3, { 0xE6, 0x98, 0x87 },
	0xCEA4, { 0xE6, 0x9C, 0x8D },
	0xCEA5, { 0xE6, 0x9C, 0x8B },
	0xCEA6, { 0xE6, 0x9D, 0xAD },
	0xCEA7, { 0xE6, 0x9E, 0x8B },
	0xCEA8, { 0xE6, 0x9E, 0x95 },
	0xCEA9, { 0xE6, 0x9D, 0xB1 },
	0xCEAA, { 0xE6, 0x9E, 0x9C },
	0xCEAB, { 0xE6, 0x9D, 0xB3 },
	0xCEAC, { 0xE6, 0x9D, 0xB7 },
	0xCEAD, { 0xE6, 0x9E, 0x87 },
	0xCEAE, { 0xE6, 0x9E, 0x9D },
	0xCEAF, { 0xE6, 0x9E, 0x97 },
	0xCEB0, { 0xE6, 0x9D, 0xAF },
	0xCEB1, { 0xE6, 0x9D, 0xB0 },
	0xCEB2, { 0xE6, 0x9D, 0xBF },
	0xCEB3, { 0xE6, 0x9E, 0x89 },
	0xCEB4, { 0xE6, 0x9D, 0xBE },
	0xCEB5, { 0xE6, 0x9E, 0x90 },
	0xCEB6, { 0xE6, 0x9D, 0xB5 },
	0xCEB7, { 0xE6, 0x9E, 0x9A },
	0xCEB8, { 0xE6, 0x9E, 0x93 },
	0xCEB9, { 0xE6, 0x9D, 0xBC },
	0xCEBA, { 0xE6, 0x9D, 0xAA },
	0xCEBB, { 0xE6, 0x9D, 0xB2 },
	0xCEBC, { 0xE6, 0xAC, 0xA3 },
	0xCEBD, { 0xE6, 0xAD, 0xA6 },
	0xCEBE, { 0xE6, 0xAD, 0xA7 },
	0xCEBF, { 0xE6, 0xAD, 0xBF },
	0xCEC0, { 0xE6, 0xB0, 0x93 },
	0xCEC1, { 0xE6, 0xB0, 0x9B },
	0xCEC2, { 0xE6, 0xB3, 0xA3 },
	0xCEC3, { 0xE6, 0xB3, 0xA8 },
	0xCEC4, { 0xE6, 0xB3, 0xB3 },
	0xCEC5, { 0xE6, 0xB2, 0xB1 },
	0xCEC6, { 0xE6, 0xB3, 0x8C },
	0xCEC7, { 0xE6, 0xB3, 0xA5 },
	0xCEC8, { 0xE6, 0xB2, 0xB3 },
	0xCEC9, { 0xE6, 0xB2, 0xBD },
	0xCECA, { 0xE6, 0xB2, 0xBE },
	0xCECB, { 0xE6, 0xB2, 0xBC },
	0xCECC, { 0xE6, 0xB3, 0xA2 },
	0xCECD, { 0xE6, 0xB2, 0xAB },
	0xCECE, { 0xE6, 0xB3, 0x95 },
	0xCECF, { 0xE6, 0xB3, 0x93 },
	0xCED0, { 0xE6, 0xB2, 0xB8 },
	0xCED1, { 0xE6, 0xB3, 0x84 },
	0xCED2, { 0xE6, 0xB2, 0xB9 },
	0xCED3, { 0xE6, 0xB3, 0x81 },
	0xCED4, { 0xE6, 0xB2, 0xAE },
	0xCED5, { 0xE6, 0xB3, 0x97 },
	0xCED6, { 0xE6, 0xB3, 0x85 },
	0xCED7, { 0xE6, 0xB3, 0xB1 },
	0xCED8, { 0xE6, 0xB2, 0xBF },
	0xCED9, { 0xE6, 0xB2, 0xBB },
	0xCEDA, { 0xE6, 0xB3, 0xA1 },
	0xCEDB, { 0xE6, 0xB3, 0x9B },
	0xCEDC, { 0xE6, 0xB3, 0x8A },
	0xCEDD, { 0xE6, 0xB2, 0xAC },
	0xCEDE, { 0xE6, 0xB3, 0xAF },
	0xCEDF, { 0xE6, 0xB3, 0x9C },
	0xCEE0, { 0xE6, 0xB3, 0x96 },
	0xCEE1, { 0xE6, 0xB3, 0xA0 },
	0xCEE2, { 0xE7, 0x82, 0x95 },
	0xCEE3, { 0xE7, 0x82, 0x8E },
	0xCEE4, { 0xE7, 0x82, 0x92 },
	0xCEE5, { 0xE7, 0x82, 0x8A },
	0xCEE6, { 0xE7, 0x82, 0x99 },
	0xCEE7, { 0xE7, 0x88, 0xAC },
	0xCEE8, { 0xE7, 0x88, 0xAD },
	0xCEE9, { 0xE7, 0x88, 0xB8 },
	0xCEEA, { 0xE7, 0x89, 0x88 },
	0xCEEB, { 0xE7, 0x89, 0xA7 },
	0xCEEC, { 0xE7, 0x89, 0xA9 },
	0xCEED, { 0xE7, 0x8B, 0x80 },
	0xCEEE, { 0xE7, 0x8B, 0x8E },
	0xCEEF, { 0xE7, 0x8B, 0x99 },
	0xCEF0, { 0xE7, 0x8B, 0x97 },
	0xCEF1, { 0xE7, 0x8B, 0x90 },
	0xCEF2, { 0xE7, 0x8E, 0xA9 },
	0xCEF3, { 0xE7, 0x8E, 0xA8 },
	0xCEF4, { 0xE7, 0x8E, 0x9F },
	0xCEF5, { 0xE7, 0x8E, 0xAB },
	0xCEF6, { 0xE7, 0x8E, 0xA5 },
	0xCEF7, { 0xE7, 0x94, 0xBD },
	0xCEF8, { 0xE7, 0x96, 0x9D },
	0xCEF9, { 0xE7, 0x96, 0x99 },
	0xCEFA, { 0xE7, 0x96, 0x9A },
	0xCEFB, { 0xE7, 0x9A, 0x84 },
	0xCEFC, { 0xE7, 0x9B, 0x82 },
	0xCEFD, { 0xE7, 0x9B, 0xB2 },
	0xCEFE, { 0xE7, 0x9B, 0xB4 },
	0xCFA1, { 0xE7, 0x9F, 0xA5 },
	0xCFA2, { 0xE7, 0x9F, 0xBD },
	0xCFA3, { 0xE7, 0xA4, 0xBE },
	0xCFA4, { 0xE7, 0xA5, 0x80 },
	0xCFA5, { 0xE7, 0xA5, 0x81 },
	0xCFA6, { 0xE7, 0xA7, 0x89 },
	0xCFA7, { 0xE7, 0xA7, 0x88 },
	0xCFA8, { 0xE7, 0xA9, 0xBA },
	0xCFA9, { 0xE7, 0xA9, 0xB9 },
	0xCFAA, { 0xE7, 0xAB, 0xBA },
	0xCFAB, { 0xE7, 0xB3, 0xBE },
	0xCFAC, { 0xE7, 0xBD, 0x94 },
	0xCFAD, { 0xE7, 0xBE, 0x8C },
	0xCFAE, { 0xE7, 0xBE, 0x8B },
	0xCFAF, { 0xE8, 0x80, 0x85 },
	0xCFB0, { 0xE8, 0x82, 0xBA },
	0xCFB1, { 0xE8, 0x82, 0xA5 },
	0xCFB2, { 0xE8, 0x82, 0xA2 },
	0xCFB3, { 0xE8, 0x82, 0xB1 },
	0xCFB4, { 0xE8, 0x82, 0xA1 },
	0xCFB5, { 0xE8, 0x82, 0xAB },
	0xCFB6, { 0xE8, 0x82, 0xA9 },
	0xCFB7, { 0xE8, 0x82, 0xB4 },
	0xCFB8, { 0xE8, 0x82, 0xAA },
	0xCFB9, { 0xE8, 0x82, 0xAF },
	0xCFBA, { 0xE8, 0x87, 0xA5 },
	0xCFBB, { 0xE8, 0x87, 0xBE },
	0xCFBC, { 0xE8, 0x88, 0x8D },
	0xCFBD, { 0xE8, 0x8A, 0xB3 },
	0xCFBE, { 0xE8, 0x8A, 0x9D },
	0xCFBF, { 0xE8, 0x8A, 0x99 },
	0xCFC0, { 0xE8, 0x8A, 0xAD },
	0xCFC1, { 0xE8, 0x8A, 0xBD },
	0xCFC2, { 0xE8, 0x8A, 0x9F },
	0xCFC3, { 0xE8, 0x8A, 0xB9 },
	0xCFC4, { 0xE8, 0x8A, 0xB1 },
	0xCFC5, { 0xE8, 0x8A, 0xAC },
	0xCFC6, { 0xE8, 0x8A, 0xA5 },
	0xCFC7, { 0xE8, 0x8A, 0xAF },
	0xCFC8, { 0xE8, 0x8A, 0xB8 },
	0xCFC9, { 0xE8, 0x8A, 0xA3 },
	0xCFCA, { 0xE8, 0x8A, 0xB0 },
	0xCFCB, { 0xE8, 0x8A, 0xBE },
	0xCFCC, { 0xE8, 0x8A, 0xB7 },
	0xCFCD, { 0xE8, 0x99, 0x8E },
	0xCFCE, { 0xE8, 0x99, 0xB1 },
	0xCFCF, { 0xE5, 0x88, 0x9D },
	0xCFD0, { 0xE8, 0xA1, 0xA8 },
	0xCFD1, { 0xE8, 0xBB, 0x8B },
	0xCFD2, { 0xE8, 0xBF, 0x8E },
	0xCFD3, { 0xE8, 0xBF, 0x94 },
	0xCFD4, { 0xE8, 0xBF, 0x91 },
	0xCFD5, { 0xE9, 0x82, 0xB5 },
	0xCFD6, { 0xE9, 0x82, 0xB8 },
	0xCFD7, { 0xE9, 0x82, 0xB1 },
	0xCFD8, { 0xE9, 0x82, 0xB6 },
	0xCFD9, { 0xE9, 0x87, 0x87 },
	0xCFDA, { 0xE9, 0x87, 0x91 },
	0xCFDB, { 0xE9, 0x95, 0xB7 },
	0xCFDC, { 0xE9, 0x96, 0x80 },
	0xCFDD, { 0xE9, 0x98, 0x9C },
	0xCFDE, { 0xE9, 0x99, 0x80 },
	0xCFDF, { 0xE9, 0x98, 0xBF },
	0xCFE0, { 0xE9, 0x98, 0xBB },
	0xCFE1, { 0xE9, 0x99, 0x84 },
	0xCFE2, { 0xE9, 0x99, 0x82 },
	0xCFE3, { 0xE9, 0x9A, 0xB9 },
	0xCFE4, { 0xE9, 0x9B, 0xA8 },
	0xCFE5, { 0xE9, 0x9D, 0x92 },
	0xCFE6, { 0xE9, 0x9D, 0x9E },
	0xCFE7, { 0xE4, 0xBA, 0x9F },
	0xCFE8, { 0xE4, 0xBA, 0xAD },
	0xCFE9, { 0xE4, 0xBA, 0xAE },
	0xCFEA, { 0xE4, 0xBF, 0xA1 },
	0xCFEB, { 0xE4, 0xBE, 0xB5 },
	0xCFEC, { 0xE4, 0xBE, 0xAF },
	0xCFED, { 0xE4, 0xBE, 0xBF },
	0xCFEE, { 0xE4, 0xBF, 0xA0 },
	0xCFEF, { 0xE4, 0xBF, 0x91 },
	0xCFF0, { 0xE4, 0xBF, 0x8F },
	0xCFF1, { 0xE4, 0xBF, 0x9D },
	0xCFF2, { 0xE4, 0xBF, 0x83 },
	0xCFF3, { 0xE4, 0xBE, 0xB6 },
	0xCFF4, { 0xE4, 0xBF, 0x98 },
	0xCFF5, { 0xE4, 0xBF, 0x9F },
	0xCFF6, { 0xE4, 0xBF, 0x8A },
	0xCFF7, { 0xE4, 0xBF, 0x97 },
	0xCFF8, { 0xE4, 0xBE, 0xAE },
	0xCFF9, { 0xE4, 0xBF, 0x90 },
	0xCFFA, { 0xE4, 0xBF, 0x84 },
	0xCFFB, { 0xE4, 0xBF, 0x82 },
	0xCFFC, { 0xE4, 0xBF, 0x9A },
	0xCFFD, { 0xE4, 0xBF, 0x8E },
	0xCFFE, { 0xE4, 0xBF, 0x9E },
	0xD0A1, { 0xE4, 0xBE, 0xB7 },
	0xD0A2, { 0xE5, 0x85, 0x97 },
	0xD0A3, { 0xE5, 0x86, 0x92 },
	0xD0A4, { 0xE5, 0x86, 0x91 },
	0xD0A5, { 0xE5, 0x86, 0xA0 },
	0xD0A6, { 0xE5, 0x89, 0x8E },
	0xD0A7, { 0xE5, 0x89, 0x83 },
	0xD0A8, { 0xE5, 0x89, 0x8A },
	0xD0A9, { 0xE5, 0x89, 0x8D },
	0xD0AA, { 0xE5, 0x89, 0x8C },
	0xD0AB, { 0xE5, 0x89, 0x8B },
	0xD0AC, { 0xE5, 0x89, 0x87 },
	0xD0AD, { 0xE5, 0x8B, 0x87 },
	0xD0AE, { 0xE5, 0x8B, 0x89 },
	0xD0AF, { 0xE5, 0x8B, 0x83 },
	0xD0B0, { 0xE5, 0x8B, 0x81 },
	0xD0B1, { 0xE5, 0x8C, 0x8D },
	0xD0B2, { 0xE5, 0x8D, 0x97 },
	0xD0B3, { 0xE5, 0x8D, 0xBB },
	0xD0B4, { 0xE5, 0x8E, 0x9A },
	0xD0B5, { 0xE5, 0x8F, 0x9B },
	0xD0B6, { 0xE5, 0x92, 0xAC },
	0xD0B7, { 0xE5, 0x93, 0x80 },
	0xD0B8, { 0xE5, 0x92, 0xA8 },
	0xD0B9, { 0xE5, 0x93, 0x8E },
	0xD0BA, { 0xE5, 0x93, 0x89 },
	0xD0BB, { 0xE5, 0x92, 0xB8 },
	0xD0BC, { 0xE5, 0x92, 0xA6 },
	0xD0BD, { 0xE5, 0x92, 0xB3 },
	0xD0BE, { 0xE5, 0x93, 0x87 },
	0xD0BF, { 0xE5, 0x93, 0x82 },
	0xD0C0, { 0xE5, 0x92, 0xBD },
	0xD0C1, { 0xE5, 0x92, 0xAA },
	0xD0C2, { 0xE5, 0x93, 0x81 },
	0xD0C3, { 0xE5, 0x93, 0x84 },
	0xD0C4, { 0xE5, 0x93, 0x88 },
	0xD0C5, { 0xE5, 0x92, 0xAF },
	0xD0C6, { 0xE5, 0x92, 0xAB },
	0xD0C7, { 0xE5, 0x92, 0xB1 },
	0xD0C8, { 0xE5, 0x92, 0xBB },
	0xD0C9, { 0xE5, 0x92, 0xA9 },
	0xD0CA, { 0xE5, 0x92, 0xA7 },
	0xD0CB, { 0xE5, 0x92, 0xBF },
	0xD0CC, { 0xE5, 0x9B, 0xBF },
	0xD0CD, { 0xE5, 0x9E, 0x82 },
	0xD0CE, { 0xE5, 0x9E, 0x8B },
	0xD0CF, { 0xE5, 0x9E, 0xA0 },
	0xD0D0, { 0xE5, 0x9E, 0xA3 },
	0xD0D1, { 0xE5, 0x9E, 0xA2 },
	0xD0D2, { 0xE5, 0x9F, 0x8E },
	0xD0D3, { 0xE5, 0x9E, 0xAE },
	0xD0D4, { 0xE5, 0x9E, 0x93 },
	0xD0D5, { 0xE5, 0xA5, 0x95 },
	0xD0D6, { 0xE5, 0xA5, 0x91 },
	0xD0D7, { 0xE5, 0xA5, 0x8F },
	0xD0D8, { 0xE5, 0xA5, 0x8E },
	0xD0D9, { 0xE5, 0xA5, 0x90 },
	0xD0DA, { 0xE5, 0xA7, 0x9C },
	0xD0DB, { 0xE5, 0xA7, 0x98 },
	0xD0DC, { 0xE5, 0xA7, 0xBF },
	0xD0DD, { 0xE5, 0xA7, 0xA3 },
	0xD0DE, { 0xE5, 0xA7, 0xA8 },
	0xD0DF, { 0xE5, 0xA8, 0x83 },
	0xD0E0, { 0xE5, 0xA7, 0xA5 },
	0xD0E1, { 0xE5, 0xA7, 0xAA },
	0xD0E2, { 0xE5, 0xA7, 0x9A },
	0xD0E3, { 0xE5, 0xA7, 0xA6 },
	0xD0E4, { 0xE5, 0xA8, 0x81 },
	0xD0E5, { 0xE5, 0xA7, 0xBB },
	0xD0E6, { 0xE5, 0xAD, 0xA9 },
	0xD0E7, { 0xE5, 0xAE, 0xA3 },
	0xD0E8, { 0xE5, 0xAE, 0xA6 },
	0xD0E9, { 0xE5, 0xAE, 0xA4 },
	0xD0EA, { 0xE5, 0xAE, 0xA2 },
	0xD0EB, { 0xE5, 0xAE, 0xA5 },
	0xD0EC, { 0xE5, 0xB0, 0x81 },
	0xD0ED, { 0xE5, 0xB1, 0x8E },
	0xD0EE, { 0xE5, 0xB1, 0x8F },
	0xD0EF, { 0xE5, 0xB1, 0x8D },
	0xD0F0, { 0xE5, 0xB1, 0x8B },
	0xD0F1, { 0xE5, 0xB3, 0x99 },
	0xD0F2, { 0xE5, 0xB3, 0x92 },
	0xD0F3, { 0xE5, 0xB7, 0xB7 },
	0xD0F4, { 0xE5, 0xB8, 0x9D },
	0xD0F5, { 0xE5, 0xB8, 0xA5 },
	0xD0F6, { 0xE5, 0xB8, 0x9F },
	0xD0F7, { 0xE5, 0xB9, 0xBD },
	0xD0F8, { 0xE5, 0xBA, 0xA0 },
	0xD0F9, { 0xE5, 0xBA, 0xA6 },
	0xD0FA, { 0xE5, 0xBB, 0xBA },
	0xD0FB, { 0xE5, 0xBC, 0x88 },
	0xD0FC, { 0xE5, 0xBC, 0xAD },
	0xD0FD, { 0xE5, 0xBD, 0xA5 },
	0xD0FE, { 0xE5, 0xBE, 0x88 },
	0xD1A1, { 0xE5, 0xBE, 0x85 },
	0xD1A2, { 0xE5, 0xBE, 0x8A },
	0xD1A3, { 0xE5, 0xBE, 0x8B },
	0xD1A4, { 0xE5, 0xBE, 0x87 },
	0xD1A5, { 0xE5, 0xBE, 0x8C },
	0xD1A6, { 0xE5, 0xBE, 0x89 },
	0xD1A7, { 0xE6, 0x80, 0x92 },
	0xD1A8, { 0xE6, 0x80, 0x9D },
	0xD1A9, { 0xE6, 0x80, 0xA0 },
	0xD1AA, { 0xE6, 0x80, 0xA5 },
	0xD1AB, { 0xE6, 0x80, 0x8E },
	0xD1AC, { 0xE6, 0x80, 0xA8 },
	0xD1AD, { 0xE6, 0x81, 0x8D },
	0xD1AE, { 0xE6, 0x81, 0xB0 },
	0xD1AF, { 0xE6, 0x81, 0xA8 },
	0xD1B0, { 0xE6, 0x81, 0xA2 },
	0xD1B1, { 0xE6, 0x81, 0x86 },
	0xD1B2, { 0xE6, 0x81, 0x83 },
	0xD1B3, { 0xE6, 0x81, 0xAC },
	0xD1B4, { 0xE6, 0x81, 0xAB },
	0xD1B5, { 0xE6, 0x81, 0xAA },
	0xD1B6, { 0xE6, 0x81, 0xA4 },
	0xD1B7, { 0xE6, 0x89, 0x81 },
	0xD1B8, { 0xE6, 0x8B, 0x9C },
	0xD1B9, { 0xE6, 0x8C, 0x96 },
	0xD1BA, { 0xE6, 0x8C, 0x89 },
	0xD1BB, { 0xE6, 0x8B, 0xBC },
	0xD1BC, { 0xE6, 0x8B, 0xAD },
	0xD1BD, { 0xE6, 0x8C, 0x81 },
	0xD1BE, { 0xE6, 0x8B, 0xAE },
	0xD1BF, { 0xE6, 0x8B, 0xBD },
	0xD1C0, { 0xE6, 0x8C, 0x87 },
	0xD1C1, { 0xE6, 0x8B, 0xB1 },
	0xD1C2, { 0xE6, 0x8B, 0xB7 },
	0xD1C3, { 0xE6, 0x8B, 0xAF },
	0xD1C4, { 0xE6, 0x8B, 0xAC },
	0xD1C5, { 0xE6, 0x8B, 0xBE },
	0xD1C6, { 0xE6, 0x8B, 0xB4 },
	0xD1C7, { 0xE6, 0x8C, 0x91 },
	0xD1C8, { 0xE6, 0x8C, 0x82 },
	0xD1C9, { 0xE6, 0x94, 0xBF },
	0xD1CA, { 0xE6, 0x95, 0x85 },
	0xD1CB, { 0xE6, 0x96, 0xAB },
	0xD1CC, { 0xE6, 0x96, 0xBD },
	0xD1CD, { 0xE6, 0x97, 0xA2 },
	0xD1CE, { 0xE6, 0x98, 0xA5 },
	0xD1CF, { 0xE6, 0x98, 0xAD },
	0xD1D0, { 0xE6, 0x98, 0xA0 },
	0xD1D1, { 0xE6, 0x98, 0xA7 },
	0xD1D2, { 0xE6, 0x98, 0xAF },
	0xD1D3, { 0xE6, 0x98, 0x9F },
	0xD1D4, { 0xE6, 0x98, 0xA8 },
	0xD1D5, { 0xE6, 0x98, 0xB1 },
	0xD1D6, { 0xE6, 0x98, 0xA4 },
	0xD1D7, { 0xE6, 0x9B, 0xB7 },
	0xD1D8, { 0xE6, 0x9F, 0xBF },
	0xD1D9, { 0xE6, 0x9F, 0x93 },
	0xD1DA, { 0xE6, 0x9F, 0xB1 },
	0xD1DB, { 0xE6, 0x9F, 0x94 },
	0xD1DC, { 0xE6, 0x9F, 0x90 },
	0xD1DD, { 0xE6, 0x9F, 0xAC },
	0xD1DE, { 0xE6, 0x9E, 0xB6 },
	0xD1DF, { 0xE6, 0x9E, 0xAF },
	0xD1E0, { 0xE6, 0x9F, 0xB5 },
	0xD1E1, { 0xE6, 0x9F, 0xA9 },
	0xD1E2, { 0xE6, 0x9F, 0xAF },
	0xD1E3, { 0xE6, 0x9F, 0x84 },
	0xD1E4, { 0xE6, 0x9F, 0x91 },
	0xD1E5, { 0xE6, 0x9E, 0xB4 },
	0xD1E6, { 0xE6, 0x9F, 0x9A },
	0xD1E7, { 0xE6, 0x9F, 0xA5 },
	0xD1E8, { 0xE6, 0x9E, 0xB8 },
	0xD1E9, { 0xE6, 0x9F, 0x8F },
	0xD1EA, { 0xE6, 0x9F, 0x9E },
	0xD1EB, { 0xE6, 0x9F, 0xB3 },
	0xD1EC, { 0xE6, 0x9E, 0xB0 },
	0xD1ED, { 0xE6, 0x9F, 0x99 },
	0xD1EE, { 0xE6, 0x9F, 0xA2 },
	0xD1EF, { 0xE6, 0x9F, 0x9D },
	0xD1F0, { 0xE6, 0x9F, 0x92 },
	0xD1F1, { 0xE6, 0xAD, 0xAA },
	0xD1F2, { 0xE6, 0xAE, 0x83 },
	0xD1F3, { 0xE6, 0xAE, 0x86 },
	0xD1F4, { 0xE6, 0xAE, 0xB5 },
	0xD1F5, { 0xE6, 0xAF, 0x92 },
	0xD1F6, { 0xE6, 0xAF, 0x97 },
	0xD1F7, { 0xE6, 0xB0, 0x9F },
	0xD1F8, { 0xE6, 0xB3, 0x89 },
	0xD1F9, { 0xE6, 0xB4, 0x8B },
	0xD1FA, { 0xE6, 0xB4, 0xB2 },
	0xD1FB, { 0xE6, 0xB4, 0xAA },
	0xD1FC, { 0xE6, 0xB5, 0x81 },
	0xD1FD, { 0xE6, 0xB4, 0xA5 },
	0xD1FE, { 0xE6, 0xB4, 0x8C },
	0xD2A1, { 0xE6, 0xB4, 0xB1 },
	0xD2A2, { 0xE6, 0xB4, 0x9E },
	0xD2A3, { 0xE6, 0xB4, 0x97 },
	0xD2A4, { 0xE6, 0xB4, 0xBB },
	0xD2A5, { 0xE6, 0xB4, 0xBD },
	0xD2A6, { 0xE6, 0xB4, 0xBE },
	0xD2A7, { 0xE6, 0xB4, 0xB6 },
	0xD2A8, { 0xE6, 0xB4, 0x9B },
	0xD2A9, { 0xE6, 0xB3, 0xB5 },
	0xD2AA, { 0xE6, 0xB4, 0xB9 },
	0xD2AB, { 0xE6, 0xB4, 0xA7 },
	0xD2AC, { 0xE6, 0xB4, 0xB8 },
	0xD2AD, { 0xE6, 0xB4, 0xA9 },
	0xD2AE, { 0xE6, 0xB4, 0xAE },
	0xD2AF, { 0xE6, 0xB4, 0xB5 },
	0xD2B0, { 0xE6, 0xB4, 0x8E },
	0xD2B1, { 0xE6, 0xB4, 0xAB },
	0xD2B2, { 0xE7, 0x82, 0xAB },
	0xD2B3, { 0xE7, 0x82, 0xBA },
	0xD2B4, { 0xE7, 0x82, 0xB3 },
	0xD2B5, { 0xE7, 0x82, 0xAC },
	0xD2B6, { 0xE7, 0x82, 0xAF },
	0xD2B7, { 0xE7, 0x82, 0xAD },
	0xD2B8, { 0xE7, 0x82, 0xB8 },
	0xD2B9, { 0xE7, 0x82, 0xAE },
	0xD2BA, { 0xE7, 0x82, 0xA4 },
	0xD2BB, { 0xE7, 0x88, 0xB0 },
	0xD2BC, { 0xE7, 0x89, 0xB2 },
	0xD2BD, { 0xE7, 0x89, 0xAF },
	0xD2BE, { 0xE7, 0x89, 0xB4 },
	0xD2BF, { 0xE7, 0x8B, 0xA9 },
	0xD2C0, { 0xE7, 0x8B, 0xA0 },
	0xD2C1, { 0xE7, 0x8B, 0xA1 },
	0xD2C2, { 0xE7, 0x8E, 0xB7 },
	0xD2C3, { 0xE7, 0x8F, 0x8A },
	0xD2C4, { 0xE7, 0x8E, 0xBB },
	0xD2C5, { 0xE7, 0x8E, 0xB2 },
	0xD2C6, { 0xE7, 0x8F, 0x8D },
	0xD2C7, { 0xE7, 0x8F, 0x80 },
	0xD2C8, { 0xE7, 0x8E, 0xB3 },
	0xD2C9, { 0xE7, 0x94, 0x9A },
	0xD2CA, { 0xE7, 0x94, 0xAD },
	0xD2CB, { 0xE7, 0x95, 0x8F },
	0xD2CC, { 0xE7, 0x95, 0x8C },
	0xD2CD, { 0xE7, 0x95, 0x8E },
	0xD2CE, { 0xE7, 0x95, 0x8B },
	0xD2CF, { 0xE7, 0x96, 0xAB },
	0xD2D0, { 0xE7, 0x96, 0xA4 },
	0xD2D1, { 0xE7, 0x96, 0xA5 },
	0xD2D2, { 0xE7, 0x96, 0xA2 },
	0xD2D3, { 0xE7, 0x96, 0xA3 },
	0xD2D4, { 0xE7, 0x99, 0xB8 },
	0xD2D5, { 0xE7, 0x9A, 0x86 },
	0xD2D6, { 0xE7, 0x9A, 0x87 },
	0xD2D7, { 0xE7, 0x9A, 0x88 },
	0xD2D8, { 0xE7, 0x9B, 0x88 },
	0xD2D9, { 0xE7, 0x9B, 0x86 },
	0xD2DA, { 0xE7, 0x9B, 0x83 },
	0xD2DB, { 0xE7, 0x9B, 0x85 },
	0xD2DC, { 0xE7, 0x9C, 0x81 },
	0xD2DD, { 0xE7, 0x9B, 0xB9 },
	0xD2DE, { 0xE7, 0x9B, 0xB8 },
	0xD2DF, { 0xE7, 0x9C, 0x89 },
	0xD2E0, { 0xE7, 0x9C, 0x8B },
	0xD2E1, { 0xE7, 0x9B, 0xBE },
	0xD2E2, { 0xE7, 0x9B, 0xBC },
	0xD2E3, { 0xE7, 0x9C, 0x87 },
	0xD2E4, { 0xE7, 0x9F, 0x9C },
	0xD2E5, { 0xE7, 0xA0, 0x82 },
	0xD2E6, { 0xE7, 0xA0, 0x94 },
	0xD2E7, { 0xE7, 0xA0, 0x8C },
	0xD2E8, { 0xE7, 0xA0, 0x8D },
	0xD2E9, { 0xE7, 0xA5, 0x86 },
	0xD2EA, { 0xE7, 0xA5, 0x89 },
	0xD2EB, { 0xE7, 0xA5, 0x88 },
	0xD2EC, { 0xE7, 0xA5, 0x87 },
	0xD2ED, { 0xE7, 0xA6, 0xB9 },
	0xD2EE, { 0xE7, 0xA6, 0xBA },
	0xD2EF, { 0xE7, 0xA7, 0x91 },
	0xD2F0, { 0xE7, 0xA7, 0x92 },
	0xD2F1, { 0xE7, 0xA7, 0x8B },
	0xD2F2, { 0xE7, 0xA9, 0xBF },
	0xD2F3, { 0xE7, 0xAA, 0x81 },
	0xD2F4, { 0xE7, 0xAB, 0xBF },
	0xD2F5, { 0xE7, 0xAB, 0xBD },
	0xD2F6, { 0xE7, 0xB1, 0xBD },
	0xD2F7, { 0xE7, 0xB4, 0x82 },
	0xD2F8, { 0xE7, 0xB4, 0x85 },
	0xD2F9, { 0xE7, 0xB4, 0x80 },
	0xD2FA, { 0xE7, 0xB4, 0x89 },
	0xD2FB, { 0xE7, 0xB4, 0x87 },
	0xD2FC, { 0xE7, 0xB4, 0x84 },
	0xD2FD, { 0xE7, 0xB4, 0x86 },
	0xD2FE, { 0xE7, 0xBC, 0xB8 },
	0xD3A1, { 0xE7, 0xBE, 0x8E },
	0xD3A2, { 0xE7, 0xBE, 0xBF },
	0xD3A3, { 0xE8, 0x80, 0x90 },
	0xD3A4, { 0xE8, 0x80, 0x8D },
	0xD3A5, { 0xE8, 0x80, 0x91 },
	0xD3A6, { 0xE8, 0x80, 0xB6 },
	0xD3A7, { 0xE8, 0x83, 0x96 },
	0xD3A8, { 0xE8, 0x83, 0xA5 },
	0xD3A9, { 0xE8, 0x83, 0x9A },
	0xD3AA, { 0xE8, 0x83, 0x83 },
	0xD3AB, { 0xE8, 0x83, 0x84 },
	0xD3AC, { 0xE8, 0x83, 0x8C },
	0xD3AD, { 0xE8, 0x83, 0xA1 },
	0xD3AE, { 0xE8, 0x83, 0x9B },
	0xD3AF, { 0xE8, 0x83, 0x8E },
	0xD3B0, { 0xE8, 0x83, 0x9E },
	0xD3B1, { 0xE8, 0x83, 0xA4 },
	0xD3B2, { 0xE8, 0x83, 0x9D },
	0xD3B3, { 0xE8, 0x87, 0xB4 },
	0xD3B4, { 0xE8, 0x88, 0xA2 },
	0xD3B5, { 0xE8, 0x8B, 0xA7 },
	0xD3B6, { 0xE8, 0x8C, 0x83 },
	0xD3B7, { 0xE8, 0x8C, 0x85 },
	0xD3B8, { 0xE8, 0x8B, 0xA3 },
	0xD3B9, { 0xE8, 0x8B, 0x9B },
	0xD3BA, { 0xE8, 0x8B, 0xA6 },
	0xD3BB, { 0xE8, 0x8C, 0x84 },
	0xD3BC, { 0xE8, 0x8B, 0xA5 },
	0xD3BD, { 0xE8, 0x8C, 0x82 },
	0xD3BE, { 0xE8, 0x8C, 0x89 },
	0xD3BF, { 0xE8, 0x8B, 0x92 },
	0xD3C0, { 0xE8, 0x8B, 0x97 },
	0xD3C1, { 0xE8, 0x8B, 0xB1 },
	0xD3C2, { 0xE8, 0x8C, 0x81 },
	0xD3C3, { 0xE8, 0x8B, 0x9C },
	0xD3C4, { 0xE8, 0x8B, 0x94 },
	0xD3C5, { 0xE8, 0x8B, 0x91 },
	0xD3C6, { 0xE8, 0x8B, 0x9E },
	0xD3C7, { 0xE8, 0x8B, 0x93 },
	0xD3C8, { 0xE8, 0x8B, 0x9F },
	0xD3C9, { 0xE8, 0x8B, 0xAF },
	0xD3CA, { 0xE8, 0x8C, 0x86 },
	0xD3CB, { 0xE8, 0x99, 0x90 },
	0xD3CC, { 0xE8, 0x99, 0xB9 },
	0xD3CD, { 0xE8, 0x99, 0xBB },
	0xD3CE, { 0xE8, 0x99, 0xBA },
	0xD3CF, { 0xE8, 0xA1, 0x8D },
	0xD3D0, { 0xE8, 0xA1, 0xAB },
	0xD3D1, { 0xE8, 0xA6, 0x81 },
	0xD3D2, { 0xE8, 0xA7, 0x94 },
	0xD3D3, { 0xE8, 0xA8, 0x88 },
	0xD3D4, { 0xE8, 0xA8, 0x82 },
	0xD3D5, { 0xE8, 0xA8, 0x83 },
	0xD3D6, { 0xE8, 0xB2, 0x9E },
	0xD3D7, { 0xE8, 0xB2, 0xA0 },
	0xD3D8, { 0xE8, 0xB5, 0xB4 },
	0xD3D9, { 0xE8, 0xB5, 0xB3 },
	0xD3DA, { 0xE8, 0xB6, 0xB4 },
	0xD3DB, { 0xE8, 0xBB, 0x8D },
	0xD3DC, { 0xE8, 0xBB, 0x8C },
	0xD3DD, { 0xE8, 0xBF, 0xB0 },
	0xD3DE, { 0xE8, 0xBF, 0xA6 },
	0xD3DF, { 0xE8, 0xBF, 0xA2 },
	0xD3E0, { 0xE8, 0xBF, 0xAA },
	0xD3E1, { 0xE8, 0xBF, 0xA5 },
	0xD3E2, { 0xE8, 0xBF, 0xAD },
	0xD3E3, { 0xE8, 0xBF, 0xAB },
	0xD3E4, { 0xE8, 0xBF, 0xA4 },
	0xD3E5, { 0xE8, 0xBF, 0xA8 },
	0xD3E6, { 0xE9, 0x83, 0x8A },
	0xD3E7, { 0xE9, 0x83, 0x8E },
	0xD3E8, { 0xE9, 0x83, 0x81 },
	0xD3E9, { 0xE9, 0x83, 0x83 },
	0xD3EA, { 0xE9, 0x85, 0x8B },
	0xD3EB, { 0xE9, 0x85, 0x8A },
	0xD3EC, { 0xE9, 0x87, 0x8D },
	0xD3ED, { 0xE9, 0x96, 0x82 },
	0xD3EE, { 0xE9, 0x99, 0x90 },
	0xD3EF, { 0xE9, 0x99, 0x8B },
	0xD3F0, { 0xE9, 0x99, 0x8C },
	0xD3F1, { 0xE9, 0x99, 0x8D },
	0xD3F2, { 0xE9, 0x9D, 0xA2 },
	0xD3F3, { 0xE9, 0x9D, 0xA9 },
	0xD3F4, { 0xE9, 0x9F, 0x8B },
	0xD3F5, { 0xE9, 0x9F, 0xAD },
	0xD3F6, { 0xE9, 0x9F, 0xB3 },
	0xD3F7, { 0xE9, 0xA0, 0x81 },
	0xD3F8, { 0xE9, 0xA2, 0xA8 },
	0xD3F9, { 0xE9, 0xA3, 0x9B },
	0xD3FA, { 0xE9, 0xA3, 0x9F },
	0xD3FB, { 0xE9, 0xA6, 0x96 },
	0xD3FC, { 0xE9, 0xA6, 0x99 },
	0xD3FD, { 0xE4, 0xB9, 0x98 },
	0xD3FE, { 0xE4, 0xBA, 0xB3 },
	0xD4A1, { 0xE5, 0x80, 0x8C },
	0xD4A2, { 0xE5, 0x80, 0x8D },
	0xD4A3, { 0xE5, 0x80, 0xA3 },
	0xD4A4, { 0xE4, 0xBF, 0xAF },
	0xD4A5, { 0xE5, 0x80, 0xA6 },
	0xD4A6, { 0xE5, 0x80, 0xA5 },
	0xD4A7, { 0xE4, 0xBF, 0xB8 },
	0xD4A8, { 0xE5, 0x80, 0xA9 },
	0xD4A9, { 0xE5, 0x80, 0x96 },
	0xD4AA, { 0xE5, 0x80, 0x86 },
	0xD4AB, { 0xE5, 0x80, 0xBC },
	0xD4AC, { 0xE5, 0x80, 0x9F },
	0xD4AD, { 0xE5, 0x80, 0x9A },
	0xD4AE, { 0xE5, 0x80, 0x92 },
	0xD4AF, { 0xE5, 0x80, 0x91 },
	0xD4B0, { 0xE4, 0xBF, 0xBA },
	0xD4B1, { 0xE5, 0x80, 0x80 },
	0xD4B2, { 0xE5, 0x80, 0x94 },
	0xD4B3, { 0xE5, 0x80, 0xA8 },
	0xD4B4, { 0xE4, 0xBF, 0xB1 },
	0xD4B5, { 0xE5, 0x80, 0xA1 },
	0xD4B6, { 0xE5, 0x80, 0x8B },
	0xD4B7, { 0xE5, 0x80, 0x99 },
	0xD4B8, { 0xE5, 0x80, 0x98 },
	0xD4B9, { 0xE4, 0xBF, 0xB3 },
	0xD4BA, { 0xE4, 0xBF, 0xAE },
	0xD4BB, { 0xE5, 0x80, 0xAD },
	0xD4BC, { 0xE5, 0x80, 0xAA },
	0xD4BD, { 0xE4, 0xBF, 0xBE },
	0xD4BE, { 0xE5, 0x80, 0xAB },
	0xD4BF, { 0xE5, 0x80, 0x89 },
	0xD4C0, { 0xE5, 0x85, 0xBC },
	0xD4C1, { 0xE5, 0x86, 0xA4 },
	0xD4C2, { 0xE5, 0x86, 0xA5 },
	0xD4C3, { 0xE5, 0x86, 0xA2 },
	0xD4C4, { 0xE5, 0x87, 0x8D },
	0xD4C5, { 0xE5, 0x87, 0x8C },
	0xD4C6, { 0xE5, 0x87, 0x86 },
	0xD4C7, { 0xE5, 0x87, 0x8B },
	0xD4C8, { 0xE5, 0x89, 0x96 },
	0xD4C9, { 0xE5, 0x89, 0x9C },
	0xD4CA, { 0xE5, 0x89, 0x94 },
	0xD4CB, { 0xE5, 0x89, 0x9B },
	0xD4CC, { 0xE5, 0x89, 0x9D },
	0xD4CD, { 0xE5, 0x8C, 0xAA },
	0xD4CE, { 0xE5, 0x8D, 0xBF },
	0xD4CF, { 0xE5, 0x8E, 0x9F },
	0xD4D0, { 0xE5, 0x8E, 0x9D },
	0xD4D1, { 0xE5, 0x8F, 0x9F },
	0xD4D2, { 0xE5, 0x93, 0xA8 },
	0xD4D3, { 0xE5, 0x94, 0x90 },
	0xD4D4, { 0xE5, 0x94, 0x81 },
	0xD4D5, { 0xE5, 0x94, 0xB7 },
	0xD4D6, { 0xE5, 0x93, 0xBC },
	0xD4D7, { 0xE5, 0x93, 0xA5 },
	0xD4D8, { 0xE5, 0x93, 0xB2 },
	0xD4D9, { 0xE5, 0x94, 0x86 },
	0xD4DA, { 0xE5, 0x93, 0xBA },
	0xD4DB, { 0xE5, 0x94, 0x94 },
	0xD4DC, { 0xE5, 0x93, 0xA9 },
	0xD4DD, { 0xE5, 0x93, 0xAD },
	0xD4DE, { 0xE5, 0x93, 0xA1 },
	0xD4DF, { 0xE5, 0x94, 0x89 },
	0xD4E0, { 0xE5, 0x93, 0xAE },
	0xD4E1, { 0xE5, 0x93, 0xAA },
	0xD4E2, { 0xE5, 0x93, 0xA6 },
	0xD4E3, { 0xE5, 0x94, 0xA7 },
	0xD4E4, { 0xE5, 0x94, 0x87 },
	0xD4E5, { 0xE5, 0x93, 0xBD },
	0xD4E6, { 0xE5, 0x94, 0x8F },
	0xD4E7, { 0xE5, 0x9C, 0x83 },
	0xD4E8, { 0xE5, 0x9C, 0x84 },
	0xD4E9, { 0xE5, 0x9F, 0x82 },
	0xD4EA, { 0xE5, 0x9F, 0x94 },
	0xD4EB, { 0xE5, 0x9F, 0x8B },
	0xD4EC, { 0xE5, 0x9F, 0x83 },
	0xD4ED, { 0xE5, 0xA0, 0x89 },
	0xD4EE, { 0xE5, 0xA4, 0x8F },
	0xD4EF, { 0xE5, 0xA5, 0x97 },
	0xD4F0, { 0xE5, 0xA5, 0x98 },
	0xD4F1, { 0xE5, 0xA5, 0x9A },
	0xD4F2, { 0xE5, 0xA8, 0x91 },
	0xD4F3, { 0xE5, 0xA8, 0x98 },
	0xD4F4, { 0xE5, 0xA8, 0x9C },
	0xD4F5, { 0xE5, 0xA8, 0x9F },
	0xD4F6, { 0xE5, 0xA8, 0x9B },
	0xD4F7, { 0xE5, 0xA8, 0x93 },
	0xD4F8, { 0xE5, 0xA7, 0xAC },
	0xD4F9, { 0xE5, 0xA8, 0xA0 },
	0xD4FA, { 0xE5, 0xA8, 0xA3 },
	0xD4FB, { 0xE5, 0xA8, 0xA9 },
	0xD4FC, { 0xE5, 0xA8, 0xA5 },
	0xD4FD, { 0xE5, 0xA8, 0x8C },
	0xD4FE, { 0xE5, 0xA8, 0x89 },
	0xD5A1, { 0xE5, 0xAD, 0xAB },
	0xD5A2, { 0xE5, 0xB1, 0x98 },
	0xD5A3, { 0xE5, 0xAE, 0xB0 },
	0xD5A4, { 0xE5, 0xAE, 0xB3 },
	0xD5A5, { 0xE5, 0xAE, 0xB6 },
	0xD5A6, { 0xE5, 0xAE, 0xB4 },
	0xD5A7, { 0xE5, 0xAE, 0xAE },
	0xD5A8, { 0xE5, 0xAE, 0xB5 },
	0xD5A9, { 0xE5, 0xAE, 0xB9 },
	0xD5AA, { 0xE5, 0xAE, 0xB8 },
	0xD5AB, { 0xE5, 0xB0, 0x84 },
	0xD5AC, { 0xE5, 0xB1, 0x91 },
	0xD5AD, { 0xE5, 0xB1, 0x95 },
	0xD5AE, { 0xE5, 0xB1, 0x90 },
	0xD5AF, { 0xE5, 0xB3, 0xAD },
	0xD5B0, { 0xE5, 0xB3, 0xBD },
	0xD5B1, { 0xE5, 0xB3, 0xBB },
	0xD5B2, { 0xE5, 0xB3, 0xAA },
	0xD5B3, { 0xE5, 0xB3, 0xA8 },
	0xD5B4, { 0xE5, 0xB3, 0xB0 },
	0xD5B5, { 0xE5, 0xB3, 0xB6 },
	0xD5B6, { 0xE5, 0xB4, 0x81 },
	0xD5B7, { 0xE5, 0xB3, 0xB4 },
	0xD5B8, { 0xE5, 0xB7, 0xAE },
	0xD5B9, { 0xE5, 0xB8, 0xAD },
	0xD5BA, { 0xE5, 0xB8, 0xAB },
	0xD5BB, { 0xE5, 0xBA, 0xAB },
	0xD5BC, { 0xE5, 0xBA, 0xAD },
	0xD5BD, { 0xE5, 0xBA, 0xA7 },
	0xD5BE, { 0xE5, 0xBC, 0xB1 },
	0xD5BF, { 0xE5, 0xBE, 0x92 },
	0xD5C0, { 0xE5, 0xBE, 0x91 },
	0xD5C1, { 0xE5, 0xBE, 0x90 },
	0xD5C2, { 0xE6, 0x81, 0x99 },
	0xD5C3, { 0xE6, 0x81, 0xA3 },
	0xD5C4, { 0xE6, 0x81, 0xA5 },
	0xD5C5, { 0xE6, 0x81, 0x90 },
	0xD5C6, { 0xE6, 0x81, 0x95 },
	0xD5C7, { 0xE6, 0x81, 0xAD },
	0xD5C8, { 0xE6, 0x81, 0xA9 },
	0xD5C9, { 0xE6, 0x81, 0xAF },
	0xD5CA, { 0xE6, 0x82, 0x84 },
	0xD5CB, { 0xE6, 0x82, 0x9F },
	0xD5CC, { 0xE6, 0x82, 0x9A },
	0xD5CD, { 0xE6, 0x82, 0x8D },
	0xD5CE, { 0xE6, 0x82, 0x94 },
	0xD5CF, { 0xE6, 0x82, 0x8C },
	0xD5D0, { 0xE6, 0x82, 0x85 },
	0xD5D1, { 0xE6, 0x82, 0x96 },
	0xD5D2, { 0xE6, 0x89, 0x87 },
	0xD5D3, { 0xE6, 0x8B, 0xB3 },
	0xD5D4, { 0xE6, 0x8C, 0x88 },
	0xD5D5, { 0xE6, 0x8B, 0xBF },
	0xD5D6, { 0xE6, 0x8D, 0x8E },
	0xD5D7, { 0xE6, 0x8C, 0xBE },
	0xD5D8, { 0xE6, 0x8C, 0xAF },
	0xD5D9, { 0xE6, 0x8D, 0x95 },
	0xD5DA, { 0xE6, 0x8D, 0x82 },
	0xD5DB, { 0xE6, 0x8D, 0x86 },
	0xD5DC, { 0xE6, 0x8D, 0x8F },
	0xD5DD, { 0xE6, 0x8D, 0x89 },
	0xD5DE, { 0xE6, 0x8C, 0xBA },
	0xD5DF, { 0xE6, 0x8D, 0x90 },
	0xD5E0, { 0xE6, 0x8C, 0xBD },
	0xD5E1, { 0xE6, 0x8C, 0xAA },
	0xD5E2, { 0xE6, 0x8C, 0xAB },
	0xD5E3, { 0xE6, 0x8C, 0xA8 },
	0xD5E4, { 0xE6, 0x8D, 0x8D },
	0xD5E5, { 0xE6, 0x8D, 0x8C },
	0xD5E6, { 0xE6, 0x95, 0x88 },
	0xD5E7, { 0xE6, 0x95, 0x89 },
	0xD5E8, { 0xE6, 0x96, 0x99 },
	0xD5E9, { 0xE6, 0x97, 0x81 },
	0xD5EA, { 0xE6, 0x97, 0x85 },
	0xD5EB, { 0xE6, 0x99, 0x82 },
	0xD5EC, { 0xE6, 0x99, 0x89 },
	0xD5ED, { 0xE6, 0x99, 0x8F },
	0xD5EE, { 0xE6, 0x99, 0x83 },
	0xD5EF, { 0xE6, 0x99, 0x92 },
	0xD5F0, { 0xE6, 0x99, 0x8C },
	0xD5F1, { 0xE6, 0x99, 0x85 },
	0xD5F2, { 0xE6, 0x99, 0x81 },
	0xD5F3, { 0xE6, 0x9B, 0xB8 },
	0xD5F4, { 0xE6, 0x9C, 0x94 },
	0xD5F5, { 0xE6, 0x9C, 0x95 },
	0xD5F6, { 0xE6, 0x9C, 0x97 },
	0xD5F7, { 0xE6, 0xA0, 0xA1 },
	0xD5F8, { 0xE6, 0xA0, 0xB8 },
	0xD5F9, { 0xE6, 0xA1, 0x88 },
	0xD5FA, { 0xE6, 0xA1, 0x86 },
	0xD5FB, { 0xE6, 0xA1, 0x93 },
	0xD5FC, { 0xE6, 0xA0, 0xB9 },
	0xD5FD, { 0xE6, 0xA1, 0x82 },
	0xD5FE, { 0xE6, 0xA1, 0x94 },
	0xD6A1, { 0xE6, 0xA0, 0xA9 },
	0xD6A2, { 0xE6, 0xA2, 0xB3 },
	0xD6A3, { 0xE6, 0xA0, 0x97 },
	0xD6A4, { 0xE6, 0xA1, 0x8C },
	0xD6A5, { 0xE6, 0xA1, 0x91 },
	0xD6A6, { 0xE6, 0xA0, 0xBD },
	0xD6A7, { 0xE6, 0x9F, 0xB4 },
	0xD6A8, { 0xE6, 0xA1, 0x90 },
	0xD6A9, { 0xE6, 0xA1, 0x80 },
	0xD6AA, { 0xE6, 0xA0, 0xBC },
	0xD6AB, { 0xE6, 0xA1, 0x83 },
	0xD6AC, { 0xE6, 0xA0, 0xAA },
	0xD6AD, { 0xE6, 0xA1, 0x85 },
	0xD6AE, { 0xE6, 0xA0, 0x93 },
	0xD6AF, { 0xE6, 0xA0, 0x98 },
	0xD6B0, { 0xE6, 0xA1, 0x81 },
	0xD6B1, { 0xE6, 0xAE, 0x8A },
	0xD6B2, { 0xE6, 0xAE, 0x89 },
	0xD6B3, { 0xE6, 0xAE, 0xB7 },
	0xD6B4, { 0xE6, 0xB0, 0xA3 },
	0xD6B5, { 0xE6, 0xB0, 0xA7 },
	0xD6B6, { 0xE6, 0xB0, 0xA8 },
	0xD6B7, { 0xE6, 0xB0, 0xA6 },
	0xD6B8, { 0xE6, 0xB0, 0xA4 },
	0xD6B9, { 0xE6, 0xB3, 0xB0 },
	0xD6BA, { 0xE6, 0xB5, 0xAA },
	0xD6BB, { 0xE6, 0xB6, 0x95 },
	0xD6BC, { 0xE6, 0xB6, 0x88 },
	0xD6BD, { 0xE6, 0xB6, 0x87 },
	0xD6BE, { 0xE6, 0xB5, 0xA6 },
	0xD6BF, { 0xE6, 0xB5, 0xB8 },
	0xD6C0, { 0xE6, 0xB5, 0xB7 },
	0xD6C1, { 0xE6, 0xB5, 0x99 },
	0xD6C2, { 0xE6, 0xB6, 0x93 },
	0xD6C3, { 0xE6, 0xB5, 0xAC },
	0xD6C4, { 0xE6, 0xB6, 0x89 },
	0xD6C5, { 0xE6, 0xB5, 0xAE },
	0xD6C6, { 0xE6, 0xB5, 0x9A },
	0xD6C7, { 0xE6, 0xB5, 0xB4 },
	0xD6C8, { 0xE6, 0xB5, 0xA9 },
	0xD6C9, { 0xE6, 0xB6, 0x8C },
	0xD6CA, { 0xE6, 0xB6, 0x8A },
	0xD6CB, { 0xE6, 0xB5, 0xB9 },
	0xD6CC, { 0xE6, 0xB6, 0x85 },
	0xD6CD, { 0xE6, 0xB5, 0xA5 },
	0xD6CE, { 0xE6, 0xB6, 0x94 },
	0xD6CF, { 0xE7, 0x83, 0x8A },
	0xD6D0, { 0xE7, 0x83, 0x98 },
	0xD6D1, { 0xE7, 0x83, 0xA4 },
	0xD6D2, { 0xE7, 0x83, 0x99 },
	0xD6D3, { 0xE7, 0x83, 0x88 },
	0xD6D4, { 0xE7, 0x83, 0x8F },
	0xD6D5, { 0xE7, 0x88, 0xB9 },
	0xD6D6, { 0xE7, 0x89, 0xB9 },
	0xD6D7, { 0xE7, 0x8B, 0xBC },
	0xD6D8, { 0xE7, 0x8B, 0xB9 },
	0xD6D9, { 0xE7, 0x8B, 0xBD },
	0xD6DA, { 0xE7, 0x8B, 0xB8 },
	0xD6DB, { 0xE7, 0x8B, 0xB7 },
	0xD6DC, { 0xE7, 0x8E, 0x86 },
	0xD6DD, { 0xE7, 0x8F, 0xAD },
	0xD6DE, { 0xE7, 0x90, 0x89 },
	0xD6DF, { 0xE7, 0x8F, 0xAE },
	0xD6E0, { 0xE7, 0x8F, 0xA0 },
	0xD6E1, { 0xE7, 0x8F, 0xAA },
	0xD6E2, { 0xE7, 0x8F, 0x9E },
	0xD6E3, { 0xE7, 0x95, 0x94 },
	0xD6E4, { 0xE7, 0x95, 0x9D },
	0xD6E5, { 0xE7, 0x95, 0x9C },
	0xD6E6, { 0xE7, 0x95, 0x9A },
	0xD6E7, { 0xE7, 0x95, 0x99 },
	0xD6E8, { 0xE7, 0x96, 0xBE },
	0xD6E9, { 0xE7, 0x97, 0x85 },
	0xD6EA, { 0xE7, 0x97, 0x87 },
	0xD6EB, { 0xE7, 0x96, 0xB2 },
	0xD6EC, { 0xE7, 0x96, 0xB3 },
	0xD6ED, { 0xE7, 0x96, 0xBD },
	0xD6EE, { 0xE7, 0x96, 0xBC },
	0xD6EF, { 0xE7, 0x96, 0xB9 },
	0xD6F0, { 0xE7, 0x97, 0x82 },
	0xD6F1, { 0xE7, 0x96, 0xB8 },
	0xD6F2, { 0xE7, 0x9A, 0x8B },
	0xD6F3, { 0xE7, 0x9A, 0xB0 },
	0xD6F4, { 0xE7, 0x9B, 0x8A },
	0xD6F5, { 0xE7, 0x9B, 0x8D },
	0xD6F6, { 0xE7, 0x9B, 0x8E },
	0xD6F7, { 0xE7, 0x9C, 0xA9 },
	0xD6F8, { 0xE7, 0x9C, 0x9F },
	0xD6F9, { 0xE7, 0x9C, 0xA0 },
	0xD6FA, { 0xE7, 0x9C, 0xA8 },
	0xD6FB, { 0xE7, 0x9F, 0xA9 },
	0xD6FC, { 0xE7, 0xA0, 0xB0 },
	0xD6FD, { 0xE7, 0xA0, 0xA7 },
	0xD6FE, { 0xE7, 0xA0, 0xB8 },
	0xD7A1, { 0xE7, 0xA0, 0x9D },
	0xD7A2, { 0xE7, 0xA0, 0xB4 },
	0xD7A3, { 0xE7, 0xA0, 0xB7 },
	0xD7A4, { 0xE7, 0xA0, 0xA5 },
	0xD7A5, { 0xE7, 0xA0, 0xAD },
	0xD7A6, { 0xE7, 0xA0, 0xA0 },
	0xD7A7, { 0xE7, 0xA0, 0x9F },
	0xD7A8, { 0xE7, 0xA0, 0xB2 },
	0xD7A9, { 0xE7, 0xA5, 0x95 },
	0xD7AA, { 0xE7, 0xA5, 0x90 },
	0xD7AB, { 0xE7, 0xA5, 0xA0 },
	0xD7AC, { 0xE7, 0xA5, 0x9F },
	0xD7AD, { 0xE7, 0xA5, 0x96 },
	0xD7AE, { 0xE7, 0xA5, 0x9E },
	0xD7AF, { 0xE7, 0xA5, 0x9D },
	0xD7B0, { 0xE7, 0xA5, 0x97 },
	0xD7B1, { 0xE7, 0xA5, 0x9A },
	0xD7B2, { 0xE7, 0xA7, 0xA4 },
	0xD7B3, { 0xE7, 0xA7, 0xA3 },
	0xD7B4, { 0xE7, 0xA7, 0xA7 },
	0xD7B5, { 0xE7, 0xA7, 0x9F },
	0xD7B6, { 0xE7, 0xA7, 0xA6 },
	0xD7B7, { 0xE7, 0xA7, 0xA9 },
	0xD7B8, { 0xE7, 0xA7, 0x98 },
	0xD7B9, { 0xE7, 0xAA, 0x84 },
	0xD7BA, { 0xE7, 0xAA, 0x88 },
	0xD7BB, { 0xE7, 0xAB, 0x99 },
	0xD7BC, { 0xE7, 0xAC, 0x86 },
	0xD7BD, { 0xE7, 0xAC, 0x91 },
	0xD7BE, { 0xE7, 0xB2, 0x89 },
	0xD7BF, { 0xE7, 0xB4, 0xA1 },
	0xD7C0, { 0xE7, 0xB4, 0x97 },
	0xD7C1, { 0xE7, 0xB4, 0x8B },
	0xD7C2, { 0xE7, 0xB4, 0x8A },
	0xD7C3, { 0xE7, 0xB4, 0xA0 },
	0xD7C4, { 0xE7, 0xB4, 0xA2 },
	0xD7C5, { 0xE7, 0xB4, 0x94 },
	0xD7C6, { 0xE7, 0xB4, 0x90 },
	0xD7C7, { 0xE7, 0xB4, 0x95 },
	0xD7C8, { 0xE7, 0xB4, 0x9A },
	0xD7C9, { 0xE7, 0xB4, 0x9C },
	0xD7CA, { 0xE7, 0xB4, 0x8D },
	0xD7CB, { 0xE7, 0xB4, 0x99 },
	0xD7CC, { 0xE7, 0xB4, 0x9B },
	0xD7CD, { 0xE7, 0xBC, 0xBA },
	0xD7CE, { 0xE7, 0xBD, 0x9F },
	0xD7CF, { 0xE7, 0xBE, 0x94 },
	0xD7D0, { 0xE7, 0xBF, 0x85 },
	0xD7D1, { 0xE7, 0xBF, 0x81 },
	0xD7D2, { 0xE8, 0x80, 0x86 },
	0xD7D3, { 0xE8, 0x80, 0x84 },
	0xD7D4, { 0xE8, 0x80, 0x98 },
	0xD7D5, { 0xE8, 0x80, 0x95 },
	0xD7D6, { 0xE8, 0x80, 0x99 },
	0xD7D7, { 0xE8, 0x80, 0x97 },
	0xD7D8, { 0xE8, 0x80, 0xBD },
	0xD7D9, { 0xE8, 0x80, 0xBF },
	0xD7DA, { 0xE8, 0x83, 0xB1 },
	0xD7DB, { 0xE8, 0x84, 0x82 },
	0xD7DC, { 0xE8, 0x83, 0xB0 },
	0xD7DD, { 0xE8, 0x84, 0x85 },
	0xD7DE, { 0xE8, 0x83, 0xAD },
	0xD7DF, { 0xE8, 0x83, 0xB4 },
	0xD7E0, { 0xE8, 0x84, 0x86 },
	0xD7E1, { 0xE8, 0x83, 0xB8 },
	0xD7E2, { 0xE8, 0x83, 0xB3 },
	0xD7E3, { 0xE8, 0x84, 0x88 },
	0xD7E4, { 0xE8, 0x83, 0xBD },
	0xD7E5, { 0xE8, 0x84, 0x8A },
	0xD7E6, { 0xE8, 0x83, 0xBC },
	0xD7E7, { 0xE8, 0x83, 0xAF },
	0xD7E8, { 0xE8, 0x87, 0xAD },
	0xD7E9, { 0xE8, 0x87, 0xAC },
	0xD7EA, { 0xE8, 0x88, 0x80 },
	0xD7EB, { 0xE8, 0x88, 0x90 },
	0xD7EC, { 0xE8, 0x88, 0xAA },
	0xD7ED, { 0xE8, 0x88, 0xAB },
	0xD7EE, { 0xE8, 0x88, 0xA8 },
	0xD7EF, { 0xE8, 0x88, 0xAC },
	0xD7F0, { 0xE8, 0x8A, 0xBB },
	0xD7F1, { 0xE8, 0x8C, 0xAB },
	0xD7F2, { 0xE8, 0x8D, 0x92 },
	0xD7F3, { 0xE8, 0x8D, 0x94 },
	0xD7F4, { 0xE8, 0x8D, 0x8A },
	0xD7F5, { 0xE8, 0x8C, 0xB8 },
	0xD7F6, { 0xE8, 0x8D, 0x90 },
	0xD7F7, { 0xE8, 0x8D, 0x89 },
	0xD7F8, { 0xE8, 0x8C, 0xB5 },
	0xD7F9, { 0xE8, 0x8C, 0xB4 },
	0xD7FA, { 0xE8, 0x8D, 0x8F },
	0xD7FB, { 0xE8, 0x8C, 0xB2 },
	0xD7FC, { 0xE8, 0x8C, 0xB9 },
	0xD7FD, { 0xE8, 0x8C, 0xB6 },
	0xD7FE, { 0xE8, 0x8C, 0x97 },
	0xD8A1, { 0xE8, 0x8D, 0x80 },
	0xD8A2, { 0xE8, 0x8C, 0xB1 },
	0xD8A3, { 0xE8, 0x8C, 0xA8 },
	0xD8A4, { 0xE8, 0x8D, 0x83 },
	0xD8A5, { 0xE8, 0x99, 0x94 },
	0xD8A6, { 0xE8, 0x9A, 0x8A },
	0xD8A7, { 0xE8, 0x9A, 0xAA },
	0xD8A8, { 0xE8, 0x9A, 0x93 },
	0xD8A9, { 0xE8, 0x9A, 0xA4 },
	0xD8AA, { 0xE8, 0x9A, 0xA9 },
	0xD8AB, { 0xE8, 0x9A, 0x8C },
	0xD8AC, { 0xE8, 0x9A, 0xA3 },
	0xD8AD, { 0xE8, 0x9A, 0x9C },
	0xD8AE, { 0xE8, 0xA1, 0xB0 },
	0xD8AF, { 0xE8, 0xA1, 0xB7 },
	0xD8B0, { 0xE8, 0xA2, 0x81 },
	0xD8B1, { 0xE8, 0xA2, 0x82 },
	0xD8B2, { 0xE8, 0xA1, 0xBD },
	0xD8B3, { 0xE8, 0xA1, 0xB9 },
	0xD8B4, { 0xE8, 0xA8, 0x98 },
	0xD8B5, { 0xE8, 0xA8, 0x90 },
	0xD8B6, { 0xE8, 0xA8, 0x8E },
	0xD8B7, { 0xE8, 0xA8, 0x8C },
	0xD8B8, { 0xE8, 0xA8, 0x95 },
	0xD8B9, { 0xE8, 0xA8, 0x8A },
	0xD8BA, { 0xE8, 0xA8, 0x97 },
	0xD8BB, { 0xE8, 0xA8, 0x93 },
	0xD8BC, { 0xE8, 0xA8, 0x96 },
	0xD8BD, { 0xE8, 0xA8, 0x8F },
	0xD8BE, { 0xE8, 0xA8, 0x91 },
	0xD8BF, { 0xE8, 0xB1, 0x88 },
	0xD8C0, { 0xE8, 0xB1, 0xBA },
	0xD8C1, { 0xE8, 0xB1, 0xB9 },
	0xD8C2, { 0xE8, 0xB2, 0xA1 },
	0xD8C3, { 0xE8, 0xB2, 0xA2 },
	0xD8C4, { 0xE8, 0xB5, 0xB7 },
	0xD8C5, { 0xE8, 0xBA, 0xAC },
	0xD8C6, { 0xE8, 0xBB, 0x92 },
	0xD8C7, { 0xE8, 0xBB, 0x94 },
	0xD8C8, { 0xE8, 0xBB, 0x8F },
	0xD8C9, { 0xE8, 0xBE, 0xB1 },
	0xD8CA, { 0xE9, 0x80, 0x81 },
	0xD8CB, { 0xE9, 0x80, 0x86 },
	0xD8CC, { 0xE8, 0xBF, 0xB7 },
	0xD8CD, { 0xE9, 0x80, 0x80 },
	0xD8CE, { 0xE8, 0xBF, 0xBA },
	0xD8CF, { 0xE8, 0xBF, 0xB4 },
	0xD8D0, { 0xE9, 0x80, 0x83 },
	0xD8D1, { 0xE8, 0xBF, 0xBD },
	0xD8D2, { 0xE9, 0x80, 0x85 },
	0xD8D3, { 0xE8, 0xBF, 0xB8 },
	0xD8D4, { 0xE9, 0x82, 0x95 },
	0xD8D5, { 0xE9, 0x83, 0xA1 },
	0xD8D6, { 0xE9, 0x83, 0x9D },
	0xD8D7, { 0xE9, 0x83, 0xA2 },
	0xD8D8, { 0xE9, 0x85, 0x92 },
	0xD8D9, { 0xE9, 0x85, 0x8D },
	0xD8DA, { 0xE9, 0x85, 0x8C },
	0xD8DB, { 0xE9, 0x87, 0x98 },
	0xD8DC, { 0xE9, 0x87, 0x9D },
	0xD8DD, { 0xE9, 0x87, 0x97 },
	0xD8DE, { 0xE9, 0x87, 0x9C },
	0xD8DF, { 0xE9, 0x87, 0x99 },
	0xD8E0, { 0xE9, 0x96, 0x83 },
	0xD8E1, { 0xE9, 0x99, 0xA2 },
	0xD8E2, { 0xE9, 0x99, 0xA3 },
	0xD8E3, { 0xE9, 0x99, 0xA1 },
	0xD8E4, { 0xE9, 0x99, 0x9B },
	0xD8E5, { 0xE9, 0x99, 0x9D },
	0xD8E6, { 0xE9, 0x99, 0xA4 },
	0xD8E7, { 0xE9, 0x99, 0x98 },
	0xD8E8, { 0xE9, 0x99, 0x9E },
	0xD8E9, { 0xE9, 0x9A, 0xBB },
	0xD8EA, { 0xE9, 0xA3, 0xA2 },
	0xD8EB, { 0xE9, 0xA6, 0xAC },
	0xD8EC, { 0xE9, 0xAA, 0xA8 },
	0xD8ED, { 0xE9, 0xAB, 0x98 },
	0xD8EE, { 0xE9, 0xAC, 0xA5 },
	0xD8EF, { 0xE9, 0xAC, 0xB2 },
	0xD8F0, { 0xE9, 0xAC, 0xBC },
	0xD8F1, { 0xE4, 0xB9, 0xBE },
	0xD8F2, { 0xE5, 0x81, 0xBA },
	0xD8F3, { 0xE5, 0x81, 0xBD },
	0xD8F4, { 0xE5, 0x81, 0x9C },
	0xD8F5, { 0xE5, 0x81, 0x87 },
	0xD8F6, { 0xE5, 0x81, 0x83 },
	0xD8F7, { 0xE5, 0x81, 0x8C },
	0xD8F8, { 0xE5, 0x81, 0x9A },
	0xD8F9, { 0xE5, 0x81, 0x89 },
	0xD8FA, { 0xE5, 0x81, 0xA5 },
	0xD8FB, { 0xE5, 0x81, 0xB6 },
	0xD8FC, { 0xE5, 0x81, 0x8E },
	0xD8FD, { 0xE5, 0x81, 0x95 },
	0xD8FE, { 0xE5, 0x81, 0xB5 },
	0xD9A1, { 0xE5, 0x81, 0xB4 },
	0xD9A2, { 0xE5, 0x81, 0xB7 },
	0xD9A3, { 0xE5, 0x81, 0x8F },
	0xD9A4, { 0xE5, 0x80, 0x8F },
	0xD9A5, { 0xE5, 0x81, 0xAF },
	0xD9A6, { 0xE5, 0x81, 0xAD },
	0xD9A7, { 0xE5, 0x85, 0x9C },
	0xD9A8, { 0xE5, 0x86, 0x95 },
	0xD9A9, { 0xE5, 0x87, 0xB0 },
	0xD9AA, { 0xE5, 0x89, 0xAA },
	0xD9AB, { 0xE5, 0x89, 0xAF },
	0xD9AC, { 0xE5, 0x8B, 0x92 },
	0xD9AD, { 0xE5, 0x8B, 0x99 },
	0xD9AE, { 0xE5, 0x8B, 0x98 },
	0xD9AF, { 0xE5, 0x8B, 0x95 },
	0xD9B0, { 0xE5, 0x8C, 0x90 },
	0xD9B1, { 0xE5, 0x8C, 0x8F },
	0xD9B2, { 0xE5, 0x8C, 0x99 },
	0xD9B3, { 0xE5, 0x8C, 0xBF },
	0xD9B4, { 0xE5, 0x8D, 0x80 },
	0xD9B5, { 0xE5, 0x8C, 0xBE },
	0xD9B6, { 0xE5, 0x8F, 0x83 },
	0xD9B7, { 0xE6, 0x9B, 0xBC },
	0xD9B8, { 0xE5, 0x95, 0x86 },
	0xD9B9, { 0xE5, 0x95, 0xAA },
	0xD9BA, { 0xE5, 0x95, 0xA6 },
	0xD9BB, { 0xE5, 0x95, 0x84 },
	0xD9BC, { 0xE5, 0x95, 0x9E },
	0xD9BD, { 0xE5, 0x95, 0xA1 },
	0xD9BE, { 0xE5, 0x95, 0x83 },
	0xD9BF, { 0xE5, 0x95, 0x8A },
	0xD9C0, { 0xE5, 0x94, 0xB1 },
	0xD9C1, { 0xE5, 0x95, 0x96 },
	0xD9C2, { 0xE5, 0x95, 0x8F },
	0xD9C3, { 0xE5, 0x95, 0x95 },
	0xD9C4, { 0xE5, 0x94, 0xAF },
	0xD9C5, { 0xE5, 0x95, 0xA4 },
	0xD9C6, { 0xE5, 0x94, 0xB8 },
	0xD9C7, { 0xE5, 0x94, 0xAE },
	0xD9C8, { 0xE5, 0x95, 0x9C },
	0xD9C9, { 0xE5, 0x94, 0xAC },
	0xD9CA, { 0xE5, 0x95, 0xA3 },
	0xD9CB, { 0xE5, 0x94, 0xB3 },
	0xD9CC, { 0xE5, 0x95, 0x81 },
	0xD9CD, { 0xE5, 0x95, 0x97 },
	0xD9CE, { 0xE5, 0x9C, 0x88 },
	0xD9CF, { 0xE5, 0x9C, 0x8B },
	0xD9D0, { 0xE5, 0x9C, 0x89 },
	0xD9D1, { 0xE5, 0x9F, 0x9F },
	0xD9D2, { 0xE5, 0xA0, 0x85 },
	0xD9D3, { 0xE5, 0xA0, 0x8A },
	0xD9D4, { 0xE5, 0xA0, 0x86 },
	0xD9D5, { 0xE5, 0x9F, 0xA0 },
	0xD9D6, { 0xE5, 0x9F, 0xA4 },
	0xD9D7, { 0xE5, 0x9F, 0xBA },
	0xD9D8, { 0xE5, 0xA0, 0x82 },
	0xD9D9, { 0xE5, 0xA0, 0xB5 },
	0xD9DA, { 0xE5, 0x9F, 0xB7 },
	0xD9DB, { 0xE5, 0x9F, 0xB9 },
	0xD9DC, { 0xE5, 0xA4, 0xA0 },
	0xD9DD, { 0xE5, 0xA5, 0xA2 },
	0xD9DE, { 0xE5, 0xA8, 0xB6 },
	0xD9DF, { 0xE5, 0xA9, 0x81 },
	0xD9E0, { 0xE5, 0xA9, 0x89 },
	0xD9E1, { 0xE5, 0xA9, 0xA6 },
	0xD9E2, { 0xE5, 0xA9, 0xAA },
	0xD9E3, { 0xE5, 0xA9, 0x80 },
	0xD9E4, { 0xE5, 0xA8, 0xBC },
	0xD9E5, { 0xE5, 0xA9, 0xA2 },
	0xD9E6, { 0xE5, 0xA9, 0x9A },
	0xD9E7, { 0xE5, 0xA9, 0x86 },
	0xD9E8, { 0xE5, 0xA9, 0x8A },
	0xD9E9, { 0xE5, 0xAD, 0xB0 },
	0xD9EA, { 0xE5, 0xAF, 0x87 },
	0xD9EB, { 0xE5, 0xAF, 0x85 },
	0xD9EC, { 0xE5, 0xAF, 0x84 },
	0xD9ED, { 0xE5, 0xAF, 0x82 },
	0xD9EE, { 0xE5, 0xAE, 0xBF },
	0xD9EF, { 0xE5, 0xAF, 0x86 },
	0xD9F0, { 0xE5, 0xB0, 0x89 },
	0xD9F1, { 0xE5, 0xB0, 0x88 },
	0xD9F2, { 0xE5, 0xB0, 0x87 },
	0xD9F3, { 0xE5, 0xB1, 0xA0 },
	0xD9F4, { 0xE5, 0xB1, 0x9C },
	0xD9F5, { 0xE5, 0xB1, 0x9D },
	0xD9F6, { 0xE5, 0xB4, 0x87 },
	0xD9F7, { 0xE5, 0xB4, 0x86 },
	0xD9F8, { 0xE5, 0xB4, 0x8E },
	0xD9F9, { 0xE5, 0xB4, 0x9B },
	0xD9FA, { 0xE5, 0xB4, 0x96 },
	0xD9FB, { 0xE5, 0xB4, 0xA2 },
	0xD9FC, { 0xE5, 0xB4, 0x91 },
	0xD9FD, { 0xE5, 0xB4, 0xA9 },
	0xD9FE, { 0xE5, 0xB4, 0x94 },
	0xDAA1, { 0xE5, 0xB4, 0x99 },
	0xDAA2, { 0xE5, 0xB4, 0xA4 },
	0xDAA3, { 0xE5, 0xB4, 0xA7 },
	0xDAA4, { 0xE5, 0xB4, 0x97 },
	0xDAA5, { 0xE5, 0xB7, 0xA2 },
	0xDAA6, { 0xE5, 0xB8, 0xB8 },
	0xDAA7, { 0xE5, 0xB8, 0xB6 },
	0xDAA8, { 0xE5, 0xB8, 0xB3 },
	0xDAA9, { 0xE5, 0xB8, 0xB7 },
	0xDAAA, { 0xE5, 0xBA, 0xB7 },
	0xDAAB, { 0xE5, 0xBA, 0xB8 },
	0xDAAC, { 0xE5, 0xBA, 0xB6 },
	0xDAAD, { 0xE5, 0xBA, 0xB5 },
	0xDAAE, { 0xE5, 0xBA, 0xBE },
	0xDAAF, { 0xE5, 0xBC, 0xB5 },
	0xDAB0, { 0xE5, 0xBC, 0xB7 },
	0xDAB1, { 0xE5, 0xBD, 0x97 },
	0xDAB2, { 0xE5, 0xBD, 0xAC },
	0xDAB3, { 0xE5, 0xBD, 0xA9 },
	0xDAB4, { 0xE5, 0xBD, 0xAB },
	0xDAB5, { 0xE5, 0xBE, 0x97 },
	0xDAB6, { 0xE5, 0xBE, 0x99 },
	0xDAB7, { 0xE5, 0xBE, 0x9E },
	0xDAB8, { 0xE5, 0xBE, 0x98 },
	0xDAB9, { 0xE5, 0xBE, 0xA1 },
	0xDABA, { 0xE5, 0xBE, 0xA0 },
	0xDABB, { 0xE5, 0xBE, 0x9C },
	0xDABC, { 0xE6, 0x81, 0xBF },
	0xDABD, { 0xE6, 0x82, 0xA3 },
	0xDABE, { 0xE6, 0x82, 0x89 },
	0xDABF, { 0xE6, 0x82, 0xA0 },
	0xDAC0, { 0xE6, 0x82, 0xA8 },
	0xDAC1, { 0xE6, 0x83, 0x8B },
	0xDAC2, { 0xE6, 0x82, 0xB4 },
	0xDAC3, { 0xE6, 0x83, 0xA6 },
	0xDAC4, { 0xE6, 0x82, 0xBD },
	0xDAC5, { 0xE6, 0x83, 0x85 },
	0xDAC6, { 0xE6, 0x82, 0xBB },
	0xDAC7, { 0xE6, 0x82, 0xB5 },
	0xDAC8, { 0xE6, 0x83, 0x9C },
	0xDAC9, { 0xE6, 0x82, 0xBC },
	0xDACA, { 0xE6, 0x83, 0x98 },
	0xDACB, { 0xE6, 0x83, 0x95 },
	0xDACC, { 0xE6, 0x83, 0x86 },
	0xDACD, { 0xE6, 0x83, 0x9F },
	0xDACE, { 0xE6, 0x82, 0xB8 },
	0xDACF, { 0xE6, 0x83, 0x9A },
	0xDAD0, { 0xE6, 0x83, 0x87 },
	0xDAD1, { 0xE6, 0x88, 0x9A },
	0xDAD2, { 0xE6, 0x88, 0x9B },
	0xDAD3, { 0xE6, 0x89, 0x88 },
	0xDAD4, { 0xE6, 0x8E, 0xA0 },
	0xDAD5, { 0xE6, 0x8E, 0xA7 },
	0xDAD6, { 0xE6, 0x8D, 0xB2 },
	0xDAD7, { 0xE6, 0x8E, 0x96 },
	0xDAD8, { 0xE6, 0x8E, 0xA2 },
	0xDAD9, { 0xE6, 0x8E, 0xA5 },
	0xDADA, { 0xE6, 0x8D, 0xB7 },
	0xDADB, { 0xE6, 0x8D, 0xA7 },
	0xDADC, { 0xE6, 0x8E, 0x98 },
	0xDADD, { 0xE6, 0x8E, 0xAA },
	0xDADE, { 0xE6, 0x8D, 0xB1 },
	0xDADF, { 0xE6, 0x8E, 0xA9 },
	0xDAE0, { 0xE6, 0x8E, 0x89 },
	0xDAE1, { 0xE6, 0x8E, 0x83 },
	0xDAE2, { 0xE6, 0x8E, 0x9B },
	0xDAE3, { 0xE6, 0x8D, 0xAB },
	0xDAE4, { 0xE6, 0x8E, 0xA8 },
	0xDAE5, { 0xE6, 0x8E, 0x84 },
	0xDAE6, { 0xE6, 0x8E, 0x88 },
	0xDAE7, { 0xE6, 0x8E, 0x99 },
	0xDAE8, { 0xE6, 0x8E, 0xA1 },
	0xDAE9, { 0xE6, 0x8E, 0xAC },
	0xDAEA, { 0xE6, 0x8E, 0x92 },
	0xDAEB, { 0xE6, 0x8E, 0x8F },
	0xDAEC, { 0xE6, 0x8E, 0x80 },
	0xDAED, { 0xE6, 0x8D, 0xBB },
	0xDAEE, { 0xE6, 0x8D, 0xA9 },
	0xDAEF, { 0xE6, 0x8D, 0xA8 },
	0xDAF0, { 0xE6, 0x8D, 0xBA },
	0xDAF1, { 0xE6, 0x95, 0x9D },
	0xDAF2, { 0xE6, 0x95, 0x96 },
	0xDAF3, { 0xE6, 0x95, 0x91 },
	0xDAF4, { 0xE6, 0x95, 0x99 },
	0xDAF5, { 0xE6, 0x95, 0x97 },
	0xDAF6, { 0xE5, 0x95, 0x9F },
	0xDAF7, { 0xE6, 0x95, 0x8F },
	0xDAF8, { 0xE6, 0x95, 0x98 },
	0xDAF9, { 0xE6, 0x95, 0x95 },
	0xDAFA, { 0xE6, 0x95, 0x94 },
	0xDAFB, { 0xE6, 0x96, 0x9C },
	0xDAFC, { 0xE6, 0x96, 0x9B },
	0xDAFD, { 0xE6, 0x96, 0xAC },
	0xDAFE, { 0xE6, 0x97, 0x8F },
	0xDBA1, { 0xE6, 0x97, 0x8B },
	0xDBA2, { 0xE6, 0x97, 0x8C },
	0xDBA3, { 0xE6, 0x97, 0x8E },
	0xDBA4, { 0xE6, 0x99, 0x9D },
	0xDBA5, { 0xE6, 0x99, 0x9A },
	0xDBA6, { 0xE6, 0x99, 0xA4 },
	0xDBA7, { 0xE6, 0x99, 0xA8 },
	0xDBA8, { 0xE6, 0x99, 0xA6 },
	0xDBA9, { 0xE6, 0x99, 0x9E },
	0xDBAA, { 0xE6, 0x9B, 0xB9 },
	0xDBAB, { 0xE5, 0x8B, 0x97 },
	0xDBAC, { 0xE6, 0x9C, 0x9B },
	0xDBAD, { 0xE6, 0xA2, 0x81 },
	0xDBAE, { 0xE6, 0xA2, 0xAF },
	0xDBAF, { 0xE6, 0xA2, 0xA2 },
	0xDBB0, { 0xE6, 0xA2, 0x93 },
	0xDBB1, { 0xE6, 0xA2, 0xB5 },
	0xDBB2, { 0xE6, 0xA1, 0xBF },
	0xDBB3, { 0xE6, 0xA1, 0xB6 },
	0xDBB4, { 0xE6, 0xA2, 0xB1 },
	0xDBB5, { 0xE6, 0xA2, 0xA7 },
	0xDBB6, { 0xE6, 0xA2, 0x97 },
	0xDBB7, { 0xE6, 0xA2, 0xB0 },
	0xDBB8, { 0xE6, 0xA2, 0x83 },
	0xDBB9, { 0xE6, 0xA3, 0x84 },
	0xDBBA, { 0xE6, 0xA2, 0xAD },
	0xDBBB, { 0xE6, 0xA2, 0x86 },
	0xDBBC, { 0xE6, 0xA2, 0x85 },
	0xDBBD, { 0xE6, 0xA2, 0x94 },
	0xDBBE, { 0xE6, 0xA2, 0x9D },
	0xDBBF, { 0xE6, 0xA2, 0xA8 },
	0xDBC0, { 0xE6, 0xA2, 0x9F },
	0xDBC1, { 0xE6, 0xA2, 0xA1 },
	0xDBC2, { 0xE6, 0xA2, 0x82 },
	0xDBC3, { 0xE6, 0xAC, 0xB2 },
	0xDBC4, { 0xE6, 0xAE, 0xBA },
	0xDBC5, { 0xE6, 0xAF, 0xAB },
	0xDBC6, { 0xE6, 0xAF, 0xAC },
	0xDBC7, { 0xE6, 0xB0, 0xAB },
	0xDBC8, { 0xE6, 0xB6, 0x8E },
	0xDBC9, { 0xE6, 0xB6, 0xBC },
	0xDBCA, { 0xE6, 0xB7, 0xB3 },
	0xDBCB, { 0xE6, 0xB7, 0x99 },
	0xDBCC, { 0xE6, 0xB6, 0xB2 },
	0xDBCD, { 0xE6, 0xB7, 0xA1 },
	0xDBCE, { 0xE6, 0xB7, 0x8C },
	0xDBCF, { 0xE6, 0xB7, 0xA4 },
	0xDBD0, { 0xE6, 0xB7, 0xBB },
	0xDBD1, { 0xE6, 0xB7, 0xBA },
	0xDBD2, { 0xE6, 0xB8, 0x85 },
	0xDBD3, { 0xE6, 0xB7, 0x87 },
	0xDBD4, { 0xE6, 0xB7, 0x8B },
	0xDBD5, { 0xE6, 0xB6, 0xAF },
	0xDBD6, { 0xE6, 0xB7, 0x91 },
	0xDBD7, { 0xE6, 0xB6, 0xAE },
	0xDBD8, { 0xE6, 0xB7, 0x9E },
	0xDBD9, { 0xE6, 0xB7, 0xB9 },
	0xDBDA, { 0xE6, 0xB6, 0xB8 },
	0xDBDB, { 0xE6, 0xB7, 0xB7 },
	0xDBDC, { 0xE6, 0xB7, 0xB5 },
	0xDBDD, { 0xE6, 0xB7, 0x85 },
	0xDBDE, { 0xE6, 0xB7, 0x92 },
	0xDBDF, { 0xE6, 0xB8, 0x9A },
	0xDBE0, { 0xE6, 0xB6, 0xB5 },
	0xDBE1, { 0xE6, 0xB7, 0x9A },
	0xDBE2, { 0xE6, 0xB7, 0xAB },
	0xDBE3, { 0xE6, 0xB7, 0x98 },
	0xDBE4, { 0xE6, 0xB7, 0xAA },
	0xDBE5, { 0xE6, 0xB7, 0xB1 },
	0xDBE6, { 0xE6, 0xB7, 0xAE },
	0xDBE7, { 0xE6, 0xB7, 0xA8 },
	0xDBE8, { 0xE6, 0xB7, 0x86 },
	0xDBE9, { 0xE6, 0xB7, 0x84 },
	0xDBEA, { 0xE6, 0xB6, 0xAA },
	0xDBEB, { 0xE6, 0xB7, 0xAC },
	0xDBEC, { 0xE6, 0xB6, 0xBF },
	0xDBED, { 0xE6, 0xB7, 0xA6 },
	0xDBEE, { 0xE7, 0x83, 0xB9 },
	0xDBEF, { 0xE7, 0x84, 0x89 },
	0xDBF0, { 0xE7, 0x84, 0x8A },
	0xDBF1, { 0xE7, 0x83, 0xBD },
	0xDBF2, { 0xE7, 0x83, 0xAF },
	0xDBF3, { 0xE7, 0x88, 0xBD },
	0xDBF4, { 0xE7, 0x89, 0xBD },
	0xDBF5, { 0xE7, 0x8A, 0x81 },
	0xDBF6, { 0xE7, 0x8C, 0x9C },
	0xDBF7, { 0xE7, 0x8C, 0x9B },
	0xDBF8, { 0xE7, 0x8C, 0x96 },
	0xDBF9, { 0xE7, 0x8C, 0x93 },
	0xDBFA, { 0xE7, 0x8C, 0x99 },
	0xDBFB, { 0xE7, 0x8E, 0x87 },
	0xDBFC, { 0xE7, 0x90, 0x85 },
	0xDBFD, { 0xE7, 0x90, 0x8A },
	0xDBFE, { 0xE7, 0x90, 0x83 },
	0xDCA1, { 0xE7, 0x90, 0x86 },
	0xDCA2, { 0xE7, 0x8F, 0xBE },
	0xDCA3, { 0xE7, 0x90, 0x8D },
	0xDCA4, { 0xE7, 0x93, 0xA0 },
	0xDCA5, { 0xE7, 0x93, 0xB6 },
	0xDCA6, { 0xE7, 0x93, 0xB7 },
	0xDCA7, { 0xE7, 0x94, 0x9C },
	0xDCA8, { 0xE7, 0x94, 0xA2 },
	0xDCA9, { 0xE7, 0x95, 0xA5 },
	0xDCAA, { 0xE7, 0x95, 0xA6 },
	0xDCAB, { 0xE7, 0x95, 0xA2 },
	0xDCAC, { 0xE7, 0x95, 0xB0 },
	0xDCAD, { 0xE7, 0x96, 0x8F },
	0xDCAE, { 0xE7, 0x97, 0x94 },
	0xDCAF, { 0xE7, 0x97, 0x95 },
	0xDCB0, { 0xE7, 0x96, 0xB5 },
	0xDCB1, { 0xE7, 0x97, 0x8A },
	0xDCB2, { 0xE7, 0x97, 0x8D },
	0xDCB3, { 0xE7, 0x9A, 0x8E },
	0xDCB4, { 0xE7, 0x9B, 0x94 },
	0xDCB5, { 0xE7, 0x9B, 0x92 },
	0xDCB6, { 0xE7, 0x9B, 0x9B },
	0xDCB7, { 0xE7, 0x9C, 0xB7 },
	0xDCB8, { 0xE7, 0x9C, 0xBE },
	0xDCB9, { 0xE7, 0x9C, 0xBC },
	0xDCBA, { 0xE7, 0x9C, 0xB6 },
	0xDCBB, { 0xE7, 0x9C, 0xB8 },
	0xDCBC, { 0xE7, 0x9C, 0xBA },
	0xDCBD, { 0xE7, 0xA1, 0xAB },
	0xDCBE, { 0xE7, 0xA1, 0x83 },
	0xDCBF, { 0xE7, 0xA1, 0x8E },
	0xDCC0, { 0xE7, 0xA5, 0xA5 },
	0xDCC1, { 0xE7, 0xA5, 0xA8 },
	0xDCC2, { 0xE7, 0xA5, 0xAD },
	0xDCC3, { 0xE7, 0xA7, 0xBB },
	0xDCC4, { 0xE7, 0xAA, 0x92 },
	0xDCC5, { 0xE7, 0xAA, 0x95 },
	0xDCC6, { 0xE7, 0xAC, 0xA0 },
	0xDCC7, { 0xE7, 0xAC, 0xA8 },
	0xDCC8, { 0xE7, 0xAC, 0x9B },
	0xDCC9, { 0xE7, 0xAC, 0xAC },
	0xDCCA, { 0xE7, 0xAC, 0xA6 },
	0xDCCB, { 0xE7, 0xAC, 0x99 },
	0xDCCC, { 0xE7, 0xAC, 0x9E },
	0xDCCD, { 0xE7, 0xAC, 0xAE },
	0xDCCE, { 0xE7, 0xB2, 0x92 },
	0xDCCF, { 0xE7, 0xB2, 0x97 },
	0xDCD0, { 0xE7, 0xB2, 0x95 },
	0xDCD1, { 0xE7, 0xB5, 0x86 },
	0xDCD2, { 0xE7, 0xB5, 0x83 },
	0xDCD3, { 0xE7, 0xB5, 0xB1 },
	0xDCD4, { 0xE7, 0xB4, 0xAE },
	0xDCD5, { 0xE7, 0xB4, 0xB9 },
	0xDCD6, { 0xE7, 0xB4, 0xBC },
	0xDCD7, { 0xE7, 0xB5, 0x80 },
	0xDCD8, { 0xE7, 0xB4, 0xB0 },
	0xDCD9, { 0xE7, 0xB4, 0xB3 },
	0xDCDA, { 0xE7, 0xB5, 0x84 },
	0xDCDB, { 0xE7, 0xB4, 0xAF },
	0xDCDC, { 0xE7, 0xB5, 0x82 },
	0xDCDD, { 0xE7, 0xB4, 0xB2 },
	0xDCDE, { 0xE7, 0xB4, 0xB1 },
	0xDCDF, { 0xE7, 0xBC, 0xBD },
	0xDCE0, { 0xE7, 0xBE, 0x9E },
	0xDCE1, { 0xE7, 0xBE, 0x9A },
	0xDCE2, { 0xE7, 0xBF, 0x8C },
	0xDCE3, { 0xE7, 0xBF, 0x8E },
	0xDCE4, { 0xE7, 0xBF, 0x92 },
	0xDCE5, { 0xE8, 0x80, 0x9C },
	0xDCE6, { 0xE8, 0x81, 0x8A },
	0xDCE7, { 0xE8, 0x81, 0x86 },
	0xDCE8, { 0xE8, 0x84, 0xAF },
	0xDCE9, { 0xE8, 0x84, 0x96 },
	0xDCEA, { 0xE8, 0x84, 0xA3 },
	0xDCEB, { 0xE8, 0x84, 0xAB },
	0xDCEC, { 0xE8, 0x84, 0xA9 },
	0xDCED, { 0xE8, 0x84, 0xB0 },
	0xDCEE, { 0xE8, 0x84, 0xA4 },
	0xDCEF, { 0xE8, 0x88, 0x82 },
	0xDCF0, { 0xE8, 0x88, 0xB5 },
	0xDCF1, { 0xE8, 0x88, 0xB7 },
	0xDCF2, { 0xE8, 0x88, 0xB6 },
	0xDCF3, { 0xE8, 0x88, 0xB9 },
	0xDCF4, { 0xE8, 0x8E, 0x8E },
	0xDCF5, { 0xE8, 0x8E, 0x9E },
	0xDCF6, { 0xE8, 0x8E, 0x98 },
	0xDCF7, { 0xE8, 0x8D, 0xB8 },
	0xDCF8, { 0xE8, 0x8E, 0xA2 },
	0xDCF9, { 0xE8, 0x8E, 0x96 },
	0xDCFA, { 0xE8, 0x8E, 0xBD },
	0xDCFB, { 0xE8, 0x8E, 0xAB },
	0xDCFC, { 0xE8, 0x8E, 0x92 },
	0xDCFD, { 0xE8, 0x8E, 0x8A },
	0xDCFE, { 0xE8, 0x8E, 0x93 },
	0xDDA1, { 0xE8, 0x8E, 0x89 },
	0xDDA2, { 0xE8, 0x8E, 0xA0 },
	0xDDA3, { 0xE8, 0x8D, 0xB7 },
	0xDDA4, { 0xE8, 0x8D, 0xBB },
	0xDDA5, { 0xE8, 0x8D, 0xBC },
	0xDDA6, { 0xE8, 0x8E, 0x86 },
	0xDDA7, { 0xE8, 0x8E, 0xA7 },
	0xDDA8, { 0xE8, 0x99, 0x95 },
	0xDDA9, { 0xE5, 0xBD, 0xAA },
	0xDDAA, { 0xE8, 0x9B, 0x87 },
	0xDDAB, { 0xE8, 0x9B, 0x80 },
	0xDDAC, { 0xE8, 0x9A, 0xB6 },
	0xDDAD, { 0xE8, 0x9B, 0x84 },
	0xDDAE, { 0xE8, 0x9A, 0xB5 },
	0xDDAF, { 0xE8, 0x9B, 0x86 },
	0xDDB0, { 0xE8, 0x9B, 0x8B },
	0xDDB1, { 0xE8, 0x9A, 0xB1 },
	0xDDB2, { 0xE8, 0x9A, 0xAF },
	0xDDB3, { 0xE8, 0x9B, 0x89 },
	0xDDB4, { 0xE8, 0xA1, 0x93 },
	0xDDB5, { 0xE8, 0xA2, 0x9E },
	0xDDB6, { 0xE8, 0xA2, 0x88 },
	0xDDB7, { 0xE8, 0xA2, 0xAB },
	0xDDB8, { 0xE8, 0xA2, 0x92 },
	0xDDB9, { 0xE8, 0xA2, 0x96 },
	0xDDBA, { 0xE8, 0xA2, 0x8D },
	0xDDBB, { 0xE8, 0xA2, 0x8B },
	0xDDBC, { 0xE8, 0xA6, 0x93 },
	0xDDBD, { 0xE8, 0xA6, 0x8F },
	0xDDBE, { 0xE8, 0xA8, 0xAA },
	0xDDBF, { 0xE8, 0xA8, 0x9D },
	0xDDC0, { 0xE8, 0xA8, 0xA3 },
	0xDDC1, { 0xE8, 0xA8, 0xA5 },
	0xDDC2, { 0xE8, 0xA8, 0xB1 },
	0xDDC3, { 0xE8, 0xA8, 0xAD },
	0xDDC4, { 0xE8, 0xA8, 0x9F },
	0xDDC5, { 0xE8, 0xA8, 0x9B },
	0xDDC6, { 0xE8, 0xA8, 0xA2 },
	0xDDC7, { 0xE8, 0xB1, 0x89 },
	0xDDC8, { 0xE8, 0xB1, 0x9A },
	0xDDC9, { 0xE8, 0xB2, 0xA9 },
	0xDDCA, { 0xE8, 0xB2, 0xAC },
	0xDDCB, { 0xE8, 0xB2, 0xAB },
	0xDDCC, { 0xE8, 0xB2, 0xA8 },
	0xDDCD, { 0xE8, 0xB2, 0xAA },
	0xDDCE, { 0xE8, 0xB2, 0xA7 },
	0xDDCF, { 0xE8, 0xB5, 0xA7 },
	0xDDD0, { 0xE8, 0xB5, 0xA6 },
	0xDDD1, { 0xE8, 0xB6, 0xBE },
	0xDDD2, { 0xE8, 0xB6, 0xBA },
	0xDDD3, { 0xE8, 0xBB, 0x9B },
	0xDDD4, { 0xE8, 0xBB, 0x9F },
	0xDDD5, { 0xE9, 0x80, 0x99 },
	0xDDD6, { 0xE9, 0x80, 0x8D },
	0xDDD7, { 0xE9, 0x80, 0x9A },
	0xDDD8, { 0xE9, 0x80, 0x97 },
	0xDDD9, { 0xE9, 0x80, 0xA3 },
	0xDDDA, { 0xE9, 0x80, 0x9F },
	0xDDDB, { 0xE9, 0x80, 0x9D },
	0xDDDC, { 0xE9, 0x80, 0x90 },
	0xDDDD, { 0xE9, 0x80, 0x95 },
	0xDDDE, { 0xE9, 0x80, 0x9E },
	0xDDDF, { 0xE9, 0x80, 0xA0 },
	0xDDE0, { 0xE9, 0x80, 0x8F },
	0xDDE1, { 0xE9, 0x80, 0xA2 },
	0xDDE2, { 0xE9, 0x80, 0x96 },
	0xDDE3, { 0xE9, 0x80, 0x9B },
	0xDDE4, { 0xE9, 0x80, 0x94 },
	0xDDE5, { 0xE9, 0x83, 0xA8 },
	0xDDE6, { 0xE9, 0x83, 0xAD },
	0xDDE7, { 0xE9, 0x83, 0xBD },
	0xDDE8, { 0xE9, 0x85, 0x97 },
	0xDDE9, { 0xE9, 0x87, 0x8E },
	0xDDEA, { 0xE9, 0x87, 0xB5 },
	0xDDEB, { 0xE9, 0x87, 0xA6 },
	0xDDEC, { 0xE9, 0x87, 0xA3 },
	0xDDED, { 0xE9, 0x87, 0xA7 },
	0xDDEE, { 0xE9, 0x87, 0xAD },
	0xDDEF, { 0xE9, 0x87, 0xA9 },
	0xDDF0, { 0xE9, 0x96, 0x89 },
	0xDDF1, { 0xE9, 0x99, 0xAA },
	0xDDF2, { 0xE9, 0x99, 0xB5 },
	0xDDF3, { 0xE9, 0x99, 0xB3 },
	0xDDF4, { 0xE9, 0x99, 0xB8 },
	0xDDF5, { 0xE9, 0x99, 0xB0 },
	0xDDF6, { 0xE9, 0x99, 0xB4 },
	0xDDF7, { 0xE9, 0x99, 0xB6 },
	0xDDF8, { 0xE9, 0x99, 0xB7 },
	0xDDF9, { 0xE9, 0x99, 0xAC },
	0xDDFA, { 0xE9, 0x9B, 0x80 },
	0xDDFB, { 0xE9, 0x9B, 0xAA },
	0xDDFC, { 0xE9, 0x9B, 0xA9 },
	0xDDFD, { 0xE7, 0xAB, 0xA0 },
	0xDDFE, { 0xE7, 0xAB, 0x9F },
	0xDEA1, { 0xE9, 0xA0, 0x82 },
	0xDEA2, { 0xE9, 0xA0, 0x83 },
	0xDEA3, { 0xE9, 0xAD, 0x9A },
	0xDEA4, { 0xE9, 0xB3, 0xA5 },
	0xDEA5, { 0xE9, 0xB9, 0xB5 },
	0xDEA6, { 0xE9, 0xB9, 0xBF },
	0xDEA7, { 0xE9, 0xBA, 0xA5 },
	0xDEA8, { 0xE9, 0xBA, 0xBB },
	0xDEA9, { 0xE5, 0x82, 0xA2 },
	0xDEAA, { 0xE5, 0x82, 0x8D },
	0xDEAB, { 0xE5, 0x82, 0x85 },
	0xDEAC, { 0xE5, 0x82, 0x99 },
	0xDEAD, { 0xE5, 0x82, 0x91 },
	0xDEAE, { 0xE5, 0x82, 0x80 },
	0xDEAF, { 0xE5, 0x82, 0x96 },
	0xDEB0, { 0xE5, 0x82, 0x98 },
	0xDEB1, { 0xE5, 0x82, 0x9A },
	0xDEB2, { 0xE6, 0x9C, 0x80 },
	0xDEB3, { 0xE5, 0x87, 0xB1 },
	0xDEB4, { 0xE5, 0x89, 0xB2 },
	0xDEB5, { 0xE5, 0x89, 0xB4 },
	0xDEB6, { 0xE5, 0x89, 0xB5 },
	0xDEB7, { 0xE5, 0x89, 0xA9 },
	0xDEB8, { 0xE5, 0x8B, 0x9E },
	0xDEB9, { 0xE5, 0x8B, 0x9D },
	0xDEBA, { 0xE5, 0x8B, 0x9B },
	0xDEBB, { 0xE5, 0x8D, 0x9A },
	0xDEBC, { 0xE5, 0x8E, 0xA5 },
	0xDEBD, { 0xE5, 0x95, 0xBB },
	0xDEBE, { 0xE5, 0x96, 0x80 },
	0xDEBF, { 0xE5, 0x96, 0xA7 },
	0xDEC0, { 0xE5, 0x95, 0xBC },
	0xDEC1, { 0xE5, 0x96, 0x8A },
	0xDEC2, { 0xE5, 0x96, 0x9D },
	0xDEC3, { 0xE5, 0x96, 0x98 },
	0xDEC4, { 0xE5, 0x96, 0x82 },
	0xDEC5, { 0xE5, 0x96, 0x9C },
	0xDEC6, { 0xE5, 0x96, 0xAA },
	0xDEC7, { 0xE5, 0x96, 0x94 },
	0xDEC8, { 0xE5, 0x96, 0x87 },
	0xDEC9, { 0xE5, 0x96, 0x8B },
	0xDECA, { 0xE5, 0x96, 0x83 },
	0xDECB, { 0xE5, 0x96, 0xB3 },
	0xDECC, { 0xE5, 0x96, 0xAE },
	0xDECD, { 0xE5, 0x96, 0x9F },
	0xDECE, { 0xE5, 0x94, 0xBE },
	0xDECF, { 0xE5, 0x96, 0xB2 },
	0xDED0, { 0xE5, 0x96, 0x9A },
	0xDED1, { 0xE5, 0x96, 0xBB },
	0xDED2, { 0xE5, 0x96, 0xAC },
	0xDED3, { 0xE5, 0x96, 0xB1 },
	0xDED4, { 0xE5, 0x95, 0xBE },
	0xDED5, { 0xE5, 0x96, 0x89 },
	0xDED6, { 0xE5, 0x96, 0xAB },
	0xDED7, { 0xE5, 0x96, 0x99 },
	0xDED8, { 0xE5, 0x9C, 0x8D },
	0xDED9, { 0xE5, 0xA0, 0xAF },
	0xDEDA, { 0xE5, 0xA0, 0xAA },
	0xDEDB, { 0xE5, 0xA0, 0xB4 },
	0xDEDC, { 0xE5, 0xA0, 0xA4 },
	0xDEDD, { 0xE5, 0xA0, 0xB0 },
	0xDEDE, { 0xE5, 0xA0, 0xB1 },
	0xDEDF, { 0xE5, 0xA0, 0xA1 },
	0xDEE0, { 0xE5, 0xA0, 0x9D },
	0xDEE1, { 0xE5, 0xA0, 0xA0 },
	0xDEE2, { 0xE5, 0xA3, 0xB9 },
	0xDEE3, { 0xE5, 0xA3, 0xBA },
	0xDEE4, { 0xE5, 0xA5, 0xA0 },
	0xDEE5, { 0xE5, 0xA9, 0xB7 },
	0xDEE6, { 0xE5, 0xAA, 0x9A },
	0xDEE7, { 0xE5, 0xA9, 0xBF },
	0xDEE8, { 0xE5, 0xAA, 0x92 },
	0xDEE9, { 0xE5, 0xAA, 0x9B },
	0xDEEA, { 0xE5, 0xAA, 0xA7 },
	0xDEEB, { 0xE5, 0xAD, 0xB3 },
	0xDEEC, { 0xE5, 0xAD, 0xB1 },
	0xDEED, { 0xE5, 0xAF, 0x92 },
	0xDEEE, { 0xE5, 0xAF, 0x8C },
	0xDEEF, { 0xE5, 0xAF, 0x93 },
	0xDEF0, { 0xE5, 0xAF, 0x90 },
	0xDEF1, { 0xE5, 0xB0, 0x8A },
	0xDEF2, { 0xE5, 0xB0, 0x8B },
	0xDEF3, { 0xE5, 0xB0, 0xB1 },
	0xDEF4, { 0xE5, 0xB5, 0x8C },
	0xDEF5, { 0xE5, 0xB5, 0x90 },
	0xDEF6, { 0xE5, 0xB4, 0xB4 },
	0xDEF7, { 0xE5, 0xB5, 0x87 },
	0xDEF8, { 0xE5, 0xB7, 0xBD },
	0xDEF9, { 0xE5, 0xB9, 0x85 },
	0xDEFA, { 0xE5, 0xB8, 0xBD },
	0xDEFB, { 0xE5, 0xB9, 0x80 },
	0xDEFC, { 0xE5, 0xB9, 0x83 },
	0xDEFD, { 0xE5, 0xB9, 0xBE },
	0xDEFE, { 0xE5, 0xBB, 0x8A },
	0xDFA1, { 0xE5, 0xBB, 0x81 },
	0xDFA2, { 0xE5, 0xBB, 0x82 },
	0xDFA3, { 0xE5, 0xBB, 0x84 },
	0xDFA4, { 0xE5, 0xBC, 0xBC },
	0xDFA5, { 0xE5, 0xBD, 0xAD },
	0xDFA6, { 0xE5, 0xBE, 0xA9 },
	0xDFA7, { 0xE5, 0xBE, 0xAA },
	0xDFA8, { 0xE5, 0xBE, 0xA8 },
	0xDFA9, { 0xE6, 0x83, 0x91 },
	0xDFAA, { 0xE6, 0x83, 0xA1 },
	0xDFAB, { 0xE6, 0x82, 0xB2 },
	0xDFAC, { 0xE6, 0x82, 0xB6 },
	0xDFAD, { 0xE6, 0x83, 0xA0 },
	0xDFAE, { 0xE6, 0x84, 0x9C },
	0xDFAF, { 0xE6, 0x84, 0xA3 },
	0xDFB0, { 0xE6, 0x83, 0xBA },
	0xDFB1, { 0xE6, 0x84, 0x95 },
	0xDFB2, { 0xE6, 0x83, 0xB0 },
	0xDFB3, { 0xE6, 0x83, 0xBB },
	0xDFB4, { 0xE6, 0x83, 0xB4 },
	0xDFB5, { 0xE6, 0x85, 0xA8 },
	0xDFB6, { 0xE6, 0x83, 0xB1 },
	0xDFB7, { 0xE6, 0x84, 0x8E },
	0xDFB8, { 0xE6, 0x83, 0xB6 },
	0xDFB9, { 0xE6, 0x84, 0x89 },
	0xDFBA, { 0xE6, 0x84, 0x80 },
	0xDFBB, { 0xE6, 0x84, 0x92 },
	0xDFBC, { 0xE6, 0x88, 0x9F },
	0xDFBD, { 0xE6, 0x89, 0x89 },
	0xDFBE, { 0xE6, 0x8E, 0xA3 },
	0xDFBF, { 0xE6, 0x8E, 0x8C },
	0xDFC0, { 0xE6, 0x8F, 0x8F },
	0xDFC1, { 0xE6, 0x8F, 0x80 },
	0xDFC2, { 0xE6, 0x8F, 0xA9 },
	0xDFC3, { 0xE6, 0x8F, 0x89 },
	0xDFC4, { 0xE6, 0x8F, 0x86 },
	0xDFC5, { 0xE6, 0x8F, 0x8D },
	0xDFC6, { 0xE6, 0x8F, 0x92 },
	0xDFC7, { 0xE6, 0x8F, 0xA3 },
	0xDFC8, { 0xE6, 0x8F, 0x90 },
	0xDFC9, { 0xE6, 0x8F, 0xA1 },
	0xDFCA, { 0xE6, 0x8F, 0x96 },
	0xDFCB, { 0xE6, 0x8F, 0xAD },
	0xDFCC, { 0xE6, 0x8F, 0xAE },
	0xDFCD, { 0xE6, 0x8D, 0xB6 },
	0xDFCE, { 0xE6, 0x8F, 0xB4 },
	0xDFCF, { 0xE6, 0x8F, 0xAA },
	0xDFD0, { 0xE6, 0x8F, 0x9B },
	0xDFD1, { 0xE6, 0x91, 0x92 },
	0xDFD2, { 0xE6, 0x8F, 0x9A },
	0xDFD3, { 0xE6, 0x8F, 0xB9 },
	0xDFD4, { 0xE6, 0x95, 0x9E },
	0xDFD5, { 0xE6, 0x95, 0xA6 },
	0xDFD6, { 0xE6, 0x95, 0xA2 },
	0xDFD7, { 0xE6, 0x95, 0xA3 },
	0xDFD8, { 0xE6, 0x96, 0x91 },
	0xDFD9, { 0xE6, 0x96, 0x90 },
	0xDFDA, { 0xE6, 0x96, 0xAF },
	0xDFDB, { 0xE6, 0x99, 0xAE },
	0xDFDC, { 0xE6, 0x99, 0xB0 },
	0xDFDD, { 0xE6, 0x99, 0xB4 },
	0xDFDE, { 0xE6, 0x99, 0xB6 },
	0xDFDF, { 0xE6, 0x99, 0xAF },
	0xDFE0, { 0xE6, 0x9A, 0x91 },
	0xDFE1, { 0xE6, 0x99, 0xBA },
	0xDFE2, { 0xE6, 0x99, 0xBE },
	0xDFE3, { 0xE6, 0x99, 0xB7 },
	0xDFE4, { 0xE6, 0x9B, 0xBE },
	0xDFE5, { 0xE6, 0x9B, 0xBF },
	0xDFE6, { 0xE6, 0x9C, 0x9F },
	0xDFE7, { 0xE6, 0x9C, 0x9D },
	0xDFE8, { 0xE6, 0xA3, 0xBA },
	0xDFE9, { 0xE6, 0xA3, 0x95 },
	0xDFEA, { 0xE6, 0xA3, 0xA0 },
	0xDFEB, { 0xE6, 0xA3, 0x98 },
	0xDFEC, { 0xE6, 0xA3, 0x97 },
	0xDFED, { 0xE6, 0xA4, 0x85 },
	0xDFEE, { 0xE6, 0xA3, 0x9F },
	0xDFEF, { 0xE6, 0xA3, 0xB5 },
	0xDFF0, { 0xE6, 0xA3, 0xAE },
	0xDFF1, { 0xE6, 0xA3, 0xA7 },
	0xDFF2, { 0xE6, 0xA3, 0xB9 },
	0xDFF3, { 0xE6, 0xA3, 0x92 },
	0xDFF4, { 0xE6, 0xA3, 0xB2 },
	0xDFF5, { 0xE6, 0xA3, 0xA3 },
	0xDFF6, { 0xE6, 0xA3, 0x8B },
	0xDFF7, { 0xE6, 0xA3, 0x8D },
	0xDFF8, { 0xE6, 0xA4, 0x8D },
	0xDFF9, { 0xE6, 0xA4, 0x92 },
	0xDFFA, { 0xE6, 0xA4, 0x8E },
	0xDFFB, { 0xE6, 0xA3, 0x89 },
	0xDFFC, { 0xE6, 0xA3, 0x9A },
	0xDFFD, { 0xE6, 0xA5, 0xAE },
	0xDFFE, { 0xE6, 0xA3, 0xBB },
	0xE0A1, { 0xE6, 0xAC, 0xBE },
	0xE0A2, { 0xE6, 0xAC, 0xBA },
	0xE0A3, { 0xE6, 0xAC, 0xBD },
	0xE0A4, { 0xE6, 0xAE, 0x98 },
	0xE0A5, { 0xE6, 0xAE, 0x96 },
	0xE0A6, { 0xE6, 0xAE, 0xBC },
	0xE0A7, { 0xE6, 0xAF, 0xAF },
	0xE0A8, { 0xE6, 0xB0, 0xAE },
	0xE0A9, { 0xE6, 0xB0, 0xAF },
	0xE0AA, { 0xE6, 0xB0, 0xAC },
	0xE0AB, { 0xE6, 0xB8, 0xAF },
	0xE0AC, { 0xE6, 0xB8, 0xB8 },
	0xE0AD, { 0xE6, 0xB9, 0x94 },
	0xE0AE, { 0xE6, 0xB8, 0xA1 },
	0xE0AF, { 0xE6, 0xB8, 0xB2 },
	0xE0B0, { 0xE6, 0xB9, 0xA7 },
	0xE0B1, { 0xE6, 0xB9, 0x8A },
	0xE0B2, { 0xE6, 0xB8, 0xA0 },
	0xE0B3, { 0xE6, 0xB8, 0xA5 },
	0xE0B4, { 0xE6, 0xB8, 0xA3 },
	0xE0B5, { 0xE6, 0xB8, 0x9B },
	0xE0B6, { 0xE6, 0xB9, 0x9B },
	0xE0B7, { 0xE6, 0xB9, 0x98 },
	0xE0B8, { 0xE6, 0xB8, 0xA4 },
	0xE0B9, { 0xE6, 0xB9, 0x96 },
	0xE0BA, { 0xE6, 0xB9, 0xAE },
	0xE0BB, { 0xE6, 0xB8, 0xAD },
	0xE0BC, { 0xE6, 0xB8, 0xA6 },
	0xE0BD, { 0xE6, 0xB9, 0xAF },
	0xE0BE, { 0xE6, 0xB8, 0xB4 },
	0xE0BF, { 0xE6, 0xB9, 0x8D },
	0xE0C0, { 0xE6, 0xB8, 0xBA },
	0xE0C1, { 0xE6, 0xB8, 0xAC },
	0xE0C2, { 0xE6, 0xB9, 0x83 },
	0xE0C3, { 0xE6, 0xB8, 0x9D },
	0xE0C4, { 0xE6, 0xB8, 0xBE },
	0xE0C5, { 0xE6, 0xBB, 0x8B },
	0xE0C6, { 0xE6, 0xBA, 0x89 },
	0xE0C7, { 0xE6, 0xB8, 0x99 },
	0xE0C8, { 0xE6, 0xB9, 0x8E },
	0xE0C9, { 0xE6, 0xB9, 0xA3 },
	0xE0CA, { 0xE6, 0xB9, 0x84 },
	0xE0CB, { 0xE6, 0xB9, 0xB2 },
	0xE0CC, { 0xE6, 0xB9, 0xA9 },
	0xE0CD, { 0xE6, 0xB9, 0x9F },
	0xE0CE, { 0xE7, 0x84, 0x99 },
	0xE0CF, { 0xE7, 0x84, 0x9A },
	0xE0D0, { 0xE7, 0x84, 0xA6 },
	0xE0D1, { 0xE7, 0x84, 0xB0 },
	0xE0D2, { 0xE7, 0x84, 0xA1 },
	0xE0D3, { 0xE7, 0x84, 0xB6 },
	0xE0D4, { 0xE7, 0x85, 0xAE },
	0xE0D5, { 0xE7, 0x84, 0x9C },
	0xE0D6, { 0xE7, 0x89, 0x8C },
	0xE0D7, { 0xE7, 0x8A, 0x84 },
	0xE0D8, { 0xE7, 0x8A, 0x80 },
	0xE0D9, { 0xE7, 0x8C, 0xB6 },
	0xE0DA, { 0xE7, 0x8C, 0xA5 },
	0xE0DB, { 0xE7, 0x8C, 0xB4 },
	0xE0DC, { 0xE7, 0x8C, 0xA9 },
	0xE0DD, { 0xE7, 0x90, 0xBA },
	0xE0DE, { 0xE7, 0x90, 0xAA },
	0xE0DF, { 0xE7, 0x90, 0xB3 },
	0xE0E0, { 0xE7, 0x90, 0xA2 },
	0xE0E1, { 0xE7, 0x90, 0xA5 },
	0xE0E2, { 0xE7, 0x90, 0xB5 },
	0xE0E3, { 0xE7, 0x90, 0xB6 },
	0xE0E4, { 0xE7, 0x90, 0xB4 },
	0xE0E5, { 0xE7, 0x90, 0xAF },
	0xE0E6, { 0xE7, 0x90, 0x9B },
	0xE0E7, { 0xE7, 0x90, 0xA6 },
	0xE0E8, { 0xE7, 0x90, 0xA8 },
	0xE0E9, { 0xE7, 0x94, 0xA5 },
	0xE0EA, { 0xE7, 0x94, 0xA6 },
	0xE0EB, { 0xE7, 0x95, 0xAB },
	0xE0EC, { 0xE7, 0x95, 0xAA },
	0xE0ED, { 0xE7, 0x97, 0xA2 },
	0xE0EE, { 0xE7, 0x97, 0x9B },
	0xE0EF, { 0xE7, 0x97, 0xA3 },
	0xE0F0, { 0xE7, 0x97, 0x99 },
	0xE0F1, { 0xE7, 0x97, 0x98 },
	0xE0F2, { 0xE7, 0x97, 0x9E },
	0xE0F3, { 0xE7, 0x97, 0xA0 },
	0xE0F4, { 0xE7, 0x99, 0xBB },
	0xE0F5, { 0xE7, 0x99, 0xBC },
	0xE0F6, { 0xE7, 0x9A, 0x96 },
	0xE0F7, { 0xE7, 0x9A, 0x93 },
	0xE0F8, { 0xE7, 0x9A, 0xB4 },
	0xE0F9, { 0xE7, 0x9B, 0x9C },
	0xE0FA, { 0xE7, 0x9D, 0x8F },
	0xE0FB, { 0xE7, 0x9F, 0xAD },
	0xE0FC, { 0xE7, 0xA1, 0x9D },
	0xE0FD, { 0xE7, 0xA1, 0xAC },
	0xE0FE, { 0xE7, 0xA1, 0xAF },
	0xE1A1, { 0xE7, 0xA8, 0x8D },
	0xE1A2, { 0xE7, 0xA8, 0x88 },
	0xE1A3, { 0xE7, 0xA8, 0x8B },
	0xE1A4, { 0xE7, 0xA8, 0x85 },
	0xE1A5, { 0xE7, 0xA8, 0x80 },
	0xE1A6, { 0xE7, 0xAA, 0x98 },
	0xE1A7, { 0xE7, 0xAA, 0x97 },
	0xE1A8, { 0xE7, 0xAA, 0x96 },
	0xE1A9, { 0xE7, 0xAB, 0xA5 },
	0xE1AA, { 0xE7, 0xAB, 0xA3 },
	0xE1AB, { 0xE7, 0xAD, 0x89 },
	0xE1AC, { 0xE7, 0xAD, 0x96 },
	0xE1AD, { 0xE7, 0xAD, 0x86 },
	0xE1AE, { 0xE7, 0xAD, 0x90 },
	0xE1AF, { 0xE7, 0xAD, 0x92 },
	0xE1B0, { 0xE7, 0xAD, 0x94 },
	0xE1B1, { 0xE7, 0xAD, 0x8D },
	0xE1B2, { 0xE7, 0xAD, 0x8B },
	0xE1B3, { 0xE7, 0xAD, 0x8F },
	0xE1B4, { 0xE7, 0xAD, 0x91 },
	0xE1B5, { 0xE7, 0xB2, 0x9F },
	0xE1B6, { 0xE7, 0xB2, 0xA5 },
	0xE1B7, { 0xE7, 0xB5, 0x9E },
	0xE1B8, { 0xE7, 0xB5, 0x90 },
	0xE1B9, { 0xE7, 0xB5, 0xA8 },
	0xE1BA, { 0xE7, 0xB5, 0x95 },
	0xE1BB, { 0xE7, 0xB4, 0xAB },
	0xE1BC, { 0xE7, 0xB5, 0xAE },
	0xE1BD, { 0xE7, 0xB5, 0xB2 },
	0xE1BE, { 0xE7, 0xB5, 0xA1 },
	0xE1BF, { 0xE7, 0xB5, 0xA6 },
	0xE1C0, { 0xE7, 0xB5, 0xA2 },
	0xE1C1, { 0xE7, 0xB5, 0xB0 },
	0xE1C2, { 0xE7, 0xB5, 0xB3 },
	0xE1C3, { 0xE5, 0x96, 0x84 },
	0xE1C4, { 0xE7, 0xBF, 0x94 },
	0xE1C5, { 0xE7, 0xBF, 0x95 },
	0xE1C6, { 0xE8, 0x80, 0x8B },
	0xE1C7, { 0xE8, 0x81, 0x92 },
	0xE1C8, { 0xE8, 0x82, 0x85 },
	0xE1C9, { 0xE8, 0x85, 0x95 },
	0xE1CA, { 0xE8, 0x85, 0x94 },
	0xE1CB, { 0xE8, 0x85, 0x8B },
	0xE1CC, { 0xE8, 0x85, 0x91 },
	0xE1CD, { 0xE8, 0x85, 0x8E },
	0xE1CE, { 0xE8, 0x84, 0xB9 },
	0xE1CF, { 0xE8, 0x85, 0x86 },
	0xE1D0, { 0xE8, 0x84, 0xBE },
	0xE1D1, { 0xE8, 0x85, 0x8C },
	0xE1D2, { 0xE8, 0x85, 0x93 },
	0xE1D3, { 0xE8, 0x85, 0xB4 },
	0xE1D4, { 0xE8, 0x88, 0x92 },
	0xE1D5, { 0xE8, 0x88, 0x9C },
	0xE1D6, { 0xE8, 0x8F, 0xA9 },
	0xE1D7, { 0xE8, 0x90, 0x83 },
	0xE1D8, { 0xE8, 0x8F, 0xB8 },
	0xE1D9, { 0xE8, 0x90, 0x8D },
	0xE1DA, { 0xE8, 0x8F, 0xA0 },
	0xE1DB, { 0xE8, 0x8F, 0x85 },
	0xE1DC, { 0xE8, 0x90, 0x8B },
	0xE1DD, { 0xE8, 0x8F, 0x81 },
	0xE1DE, { 0xE8, 0x8F, 0xAF },
	0xE1DF, { 0xE8, 0x8F, 0xB1 },
	0xE1E0, { 0xE8, 0x8F, 0xB4 },
	0xE1E1, { 0xE8, 0x91, 0x97 },
	0xE1E2, { 0xE8, 0x90, 0x8A },
	0xE1E3, { 0xE8, 0x8F, 0xB0 },
	0xE1E4, { 0xE8, 0x90, 0x8C },
	0xE1E5, { 0xE8, 0x8F, 0x8C },
	0xE1E6, { 0xE8, 0x8F, 0xBD },
	0xE1E7, { 0xE8, 0x8F, 0xB2 },
	0xE1E8, { 0xE8, 0x8F, 0x8A },
	0xE1E9, { 0xE8, 0x90, 0xB8 },
	0xE1EA, { 0xE8, 0x90, 0x8E },
	0xE1EB, { 0xE8, 0x90, 0x84 },
	0xE1EC, { 0xE8, 0x8F, 0x9C },
	0xE1ED, { 0xE8, 0x90, 0x87 },
	0xE1EE, { 0xE8, 0x8F, 0x94 },
	0xE1EF, { 0xE8, 0x8F, 0x9F },
	0xE1F0, { 0xE8, 0x99, 0x9B },
	0xE1F1, { 0xE8, 0x9B, 0x9F },
	0xE1F2, { 0xE8, 0x9B, 0x99 },
	0xE1F3, { 0xE8, 0x9B, 0xAD },
	0xE1F4, { 0xE8, 0x9B, 0x94 },
	0xE1F5, { 0xE8, 0x9B, 0x9B },
	0xE1F6, { 0xE8, 0x9B, 0xA4 },
	0xE1F7, { 0xE8, 0x9B, 0x90 },
	0xE1F8, { 0xE8, 0x9B, 0x9E },
	0xE1F9, { 0xE8, 0xA1, 0x97 },
	0xE1FA, { 0xE8, 0xA3, 0x81 },
	0xE1FB, { 0xE8, 0xA3, 0x82 },
	0xE1FC, { 0xE8, 0xA2, 0xB1 },
	0xE1FD, { 0xE8, 0xA6, 0x83 },
	0xE1FE, { 0xE8, 0xA6, 0x96 },
	0xE2A1, { 0xE8, 0xA8, 0xBB },
	0xE2A2, { 0xE8, 0xA9, 0xA0 },
	0xE2A3, { 0xE8, 0xA9, 0x95 },
	0xE2A4, { 0xE8, 0xA9, 0x9E },
	0xE2A5, { 0xE8, 0xA8, 0xBC },
	0xE2A6, { 0xE8, 0xA9, 0x81 },
	0xE2A7, { 0xE8, 0xA9, 0x94 },
	0xE2A8, { 0xE8, 0xA9, 0x9B },
	0xE2A9, { 0xE8, 0xA9, 0x90 },
	0xE2AA, { 0xE8, 0xA9, 0x86 },
	0xE2AB, { 0xE8, 0xA8, 0xB4 },
	0xE2AC, { 0xE8, 0xA8, 0xBA },
	0xE2AD, { 0xE8, 0xA8, 0xB6 },
	0xE2AE, { 0xE8, 0xA9, 0x96 },
	0xE2AF, { 0xE8, 0xB1, 0xA1 },
	0xE2B0, { 0xE8, 0xB2, 0x82 },
	0xE2B1, { 0xE8, 0xB2, 0xAF },
	0xE2B2, { 0xE8, 0xB2, 0xBC },
	0xE2B3, { 0xE8, 0xB2, 0xB3 },
	0xE2B4, { 0xE8, 0xB2, 0xBD },
	0xE2B5, { 0xE8, 0xB3, 0x81 },
	0xE2B6, { 0xE8, 0xB2, 0xBB },
	0xE2B7, { 0xE8, 0xB3, 0x80 },
	0xE2B8, { 0xE8, 0xB2, 0xB4 },
	0xE2B9, { 0xE8, 0xB2, 0xB7 },
	0xE2BA, { 0xE8, 0xB2, 0xB6 },
	0xE2BB, { 0xE8, 0xB2, 0xBF },
	0xE2BC, { 0xE8, 0xB2, 0xB8 },
	0xE2BD, { 0xE8, 0xB6, 0x8A },
	0xE2BE, { 0xE8, 0xB6, 0x85 },
	0xE2BF, { 0xE8, 0xB6, 0x81 },
	0xE2C0, { 0xE8, 0xB7, 0x8E },
	0xE2C1, { 0xE8, 0xB7, 0x9D },
	0xE2C2, { 0xE8, 0xB7, 0x8B },
	0xE2C3, { 0xE8, 0xB7, 0x9A },
	0xE2C4, { 0xE8, 0xB7, 0x91 },
	0xE2C5, { 0xE8, 0xB7, 0x8C },
	0xE2C6, { 0xE8, 0xB7, 0x9B },
	0xE2C7, { 0xE8, 0xB7, 0x86 },
	0xE2C8, { 0xE8, 0xBB, 0xBB },
	0xE2C9, { 0xE8, 0xBB, 0xB8 },
	0xE2CA, { 0xE8, 0xBB, 0xBC },
	0xE2CB, { 0xE8, 0xBE, 0x9C },
	0xE2CC, { 0xE9, 0x80, 0xAE },
	0xE2CD, { 0xE9, 0x80, 0xB5 },
	0xE2CE, { 0xE9, 0x80, 0xB1 },
	0xE2CF, { 0xE9, 0x80, 0xB8 },
	0xE2D0, { 0xE9, 0x80, 0xB2 },
	0xE2D1, { 0xE9, 0x80, 0xB6 },
	0xE2D2, { 0xE9, 0x84, 0x82 },
	0xE2D3, { 0xE9, 0x83, 0xB5 },
	0xE2D4, { 0xE9, 0x84, 0x89 },
	0xE2D5, { 0xE9, 0x83, 0xBE },
	0xE2D6, { 0xE9, 0x85, 0xA3 },
	0xE2D7, { 0xE9, 0x85, 0xA5 },
	0xE2D8, { 0xE9, 0x87, 0x8F },
	0xE2D9, { 0xE9, 0x88, 0x94 },
	0xE2DA, { 0xE9, 0x88, 0x95 },
	0xE2DB, { 0xE9, 0x88, 0xA3 },
	0xE2DC, { 0xE9, 0x88, 0x89 },
	0xE2DD, { 0xE9, 0x88, 0x9E },
	0xE2DE, { 0xE9, 0x88, 0x8D },
	0xE2DF, { 0xE9, 0x88, 0x90 },
	0xE2E0, { 0xE9, 0x88, 0x87 },
	0xE2E1, { 0xE9, 0x88, 0x91 },
	0xE2E2, { 0xE9, 0x96, 0x94 },
	0xE2E3, { 0xE9, 0x96, 0x8F },
	0xE2E4, { 0xE9, 0x96, 0x8B },
	0xE2E5, { 0xE9, 0x96, 0x91 },
	0xE2E6, { 0xE9, 0x96, 0x93 },
	0xE2E7, { 0xE9, 0x96, 0x92 },
	0xE2E8, { 0xE9, 0x96, 0x8E },
	0xE2E9, { 0xE9, 0x9A, 0x8A },
	0xE2EA, { 0xE9, 0x9A, 0x8E },
	0xE2EB, { 0xE9, 0x9A, 0x8B },
	0xE2EC, { 0xE9, 0x99, 0xBD },
	0xE2ED, { 0xE9, 0x9A, 0x85 },
	0xE2EE, { 0xE9, 0x9A, 0x86 },
	0xE2EF, { 0xE9, 0x9A, 0x8D },
	0xE2F0, { 0xE9, 0x99, 0xB2 },
	0xE2F1, { 0xE9, 0x9A, 0x84 },
	0xE2F2, { 0xE9, 0x9B, 0x81 },
	0xE2F3, { 0xE9, 0x9B, 0x85 },
	0xE2F4, { 0xE9, 0x9B, 0x84 },
	0xE2F5, { 0xE9, 0x9B, 0x86 },
	0xE2F6, { 0xE9, 0x9B, 0x87 },
	0xE2F7, { 0xE9, 0x9B, 0xAF },
	0xE2F8, { 0xE9, 0x9B, 0xB2 },
	0xE2F9, { 0xE9, 0x9F, 0x8C },
	0xE2FA, { 0xE9, 0xA0, 0x85 },
	0xE2FB, { 0xE9, 0xA0, 0x86 },
	0xE2FC, { 0xE9, 0xA0, 0x88 },
	0xE2FD, { 0xE9, 0xA3, 0xA7 },
	0xE2FE, { 0xE9, 0xA3, 0xAA },
	0xE3A1, { 0xE9, 0xA3, 0xAF },
	0xE3A2, { 0xE9, 0xA3, 0xA9 },
	0xE3A3, { 0xE9, 0xA3, 0xB2 },
	0xE3A4, { 0xE9, 0xA3, 0xAD },
	0xE3A5, { 0xE9, 0xA6, 0xAE },
	0xE3A6, { 0xE9, 0xA6, 0xAD },
	0xE3A7, { 0xE9, 0xBB, 0x83 },
	0xE3A8, { 0xE9, 0xBB, 0x8D },
	0xE3A9, { 0xE9, 0xBB, 0x91 },
	0xE3AA, { 0xE4, 0xBA, 0x82 },
	0xE3AB, { 0xE5, 0x82, 0xAD },
	0xE3AC, { 0xE5, 0x82, 0xB5 },
	0xE3AD, { 0xE5, 0x82, 0xB2 },
	0xE3AE, { 0xE5, 0x82, 0xB3 },
	0xE3AF, { 0xE5, 0x83, 0x85 },
	0xE3B0, { 0xE5, 0x82, 0xBE },
	0xE3B1, { 0xE5, 0x82, 0xAC },
	0xE3B2, { 0xE5, 0x82, 0xB7 },
	0xE3B3, { 0xE5, 0x82, 0xBB },
	0xE3B4, { 0xE5, 0x82, 0xAF },
	0xE3B5, { 0xE5, 0x83, 0x87 },
	0xE3B6, { 0xE5, 0x89, 0xBF },
	0xE3B7, { 0xE5, 0x89, 0xB7 },
	0xE3B8, { 0xE5, 0x89, 0xBD },
	0xE3B9, { 0xE5, 0x8B, 0x9F },
	0xE3BA, { 0xE5, 0x8B, 0xA6 },
	0xE3BB, { 0xE5, 0x8B, 0xA4 },
	0xE3BC, { 0xE5, 0x8B, 0xA2 },
	0xE3BD, { 0xE5, 0x8B, 0xA3 },
	0xE3BE, { 0xE5, 0x8C, 0xAF },
	0xE3BF, { 0xE5, 0x97, 0x9F },
	0xE3C0, { 0xE5, 0x97, 0xA8 },
	0xE3C1, { 0xE5, 0x97, 0x93 },
	0xE3C2, { 0xE5, 0x97, 0xA6 },
	0xE3C3, { 0xE5, 0x97, 0x8E },
	0xE3C4, { 0xE5, 0x97, 0x9C },
	0xE3C5, { 0xE5, 0x97, 0x87 },
	0xE3C6, { 0xE5, 0x97, 0x91 },
	0xE3C7, { 0xE5, 0x97, 0xA3 },
	0xE3C8, { 0xE5, 0x97, 0xA4 },
	0xE3C9, { 0xE5, 0x97, 0xAF },
	0xE3CA, { 0xE5, 0x97, 0x9A },
	0xE3CB, { 0xE5, 0x97, 0xA1 },
	0xE3CC, { 0xE5, 0x97, 0x85 },
	0xE3CD, { 0xE5, 0x97, 0x86 },
	0xE3CE, { 0xE5, 0x97, 0xA5 },
	0xE3CF, { 0xE5, 0x97, 0x89 },
	0xE3D0, { 0xE5, 0x9C, 0x92 },
	0xE3D1, { 0xE5, 0x9C, 0x93 },
	0xE3D2, { 0xE5, 0xA1, 0x9E },
	0xE3D3, { 0xE5, 0xA1, 0x91 },
	0xE3D4, { 0xE5, 0xA1, 0x98 },
	0xE3D5, { 0xE5, 0xA1, 0x97 },
	0xE3D6, { 0xE5, 0xA1, 0x9A },
	0xE3D7, { 0xE5, 0xA1, 0x94 },
	0xE3D8, { 0xE5, 0xA1, 0xAB },
	0xE3D9, { 0xE5, 0xA1, 0x8C },
	0xE3DA, { 0xE5, 0xA1, 0xAD },
	0xE3DB, { 0xE5, 0xA1, 0x8A },
	0xE3DC, { 0xE5, 0xA1, 0xA2 },
	0xE3DD, { 0xE5, 0xA1, 0x92 },
	0xE3DE, { 0xE5, 0xA1, 0x8B },
	0xE3DF, { 0xE5, 0xA5, 0xA7 },
	0xE3E0, { 0xE5, 0xAB, 0x81 },
	0xE3E1, { 0xE5, 0xAB, 0x89 },
	0xE3E2, { 0xE5, 0xAB, 0x8C },
	0xE3E3, { 0xE5, 0xAA, 0xBE },
	0xE3E4, { 0xE5, 0xAA, 0xBD },
	0xE3E5, { 0xE5, 0xAA, 0xBC },
	0xE3E6, { 0xE5, 0xAA, 0xB3 },
	0xE3E7, { 0xE5, 0xAB, 0x82 },
	0xE3E8, { 0xE5, 0xAA, 0xB2 },
	0xE3E9, { 0xE5, 0xB5, 0xA9 },
	0xE3EA, { 0xE5, 0xB5, 0xAF },
	0xE3EB, { 0xE5, 0xB9, 0x8C },
	0xE3EC, { 0xE5, 0xB9, 0xB9 },
	0xE3ED, { 0xE5, 0xBB, 0x89 },
	0xE3EE, { 0xE5, 0xBB, 0x88 },
	0xE3EF, { 0xE5, 0xBC, 0x92 },
	0xE3F0, { 0xE5, 0xBD, 0x99 },
	0xE3F1, { 0xE5, 0xBE, 0xAC },
	0xE3F2, { 0xE5, 0xBE, 0xAE },
	0xE3F3, { 0xE6, 0x84, 0x9A },
	0xE3F4, { 0xE6, 0x84, 0x8F },
	0xE3F5, { 0xE6, 0x85, 0x88 },
	0xE3F6, { 0xE6, 0x84, 0x9F },
	0xE3F7, { 0xE6, 0x83, 0xB3 },
	0xE3F8, { 0xE6, 0x84, 0x9B },
	0xE3F9, { 0xE6, 0x83, 0xB9 },
	0xE3FA, { 0xE6, 0x84, 0x81 },
	0xE3FB, { 0xE6, 0x84, 0x88 },
	0xE3FC, { 0xE6, 0x85, 0x8E },
	0xE3FD, { 0xE6, 0x85, 0x8C },
	0xE3FE, { 0xE6, 0x85, 0x84 },
	0xE4A1, { 0xE6, 0x85, 0x8D },
	0xE4A2, { 0xE6, 0x84, 0xBE },
	0xE4A3, { 0xE6, 0x84, 0xB4 },
	0xE4A4, { 0xE6, 0x84, 0xA7 },
	0xE4A5, { 0xE6, 0x84, 0x8D },
	0xE4A6, { 0xE6, 0x84, 0x86 },
	0xE4A7, { 0xE6, 0x84, 0xB7 },
	0xE4A8, { 0xE6, 0x88, 0xA1 },
	0xE4A9, { 0xE6, 0x88, 0xA2 },
	0xE4AA, { 0xE6, 0x90, 0x93 },
	0xE4AB, { 0xE6, 0x90, 0xBE },
	0xE4AC, { 0xE6, 0x90, 0x9E },
	0xE4AD, { 0xE6, 0x90, 0xAA },
	0xE4AE, { 0xE6, 0x90, 0xAD },
	0xE4AF, { 0xE6, 0x90, 0xBD },
	0xE4B0, { 0xE6, 0x90, 0xAC },
	0xE4B1, { 0xE6, 0x90, 0x8F },
	0xE4B2, { 0xE6, 0x90, 0x9C },
	0xE4B3, { 0xE6, 0x90, 0x94 },
	0xE4B4, { 0xE6, 0x90, 0x8D },
	0xE4B5, { 0xE6, 0x90, 0xB6 },
	0xE4B6, { 0xE6, 0x90, 0x96 },
	0xE4B7, { 0xE6, 0x90, 0x97 },
	0xE4B8, { 0xE6, 0x90, 0x86 },
	0xE4B9, { 0xE6, 0x95, 0xAC },
	0xE4BA, { 0xE6, 0x96, 0x9F },
	0xE4BB, { 0xE6, 0x96, 0xB0 },
	0xE4BC, { 0xE6, 0x9A, 0x97 },
	0xE4BD, { 0xE6, 0x9A, 0x89 },
	0xE4BE, { 0xE6, 0x9A, 0x87 },
	0xE4BF, { 0xE6, 0x9A, 0x88 },
	0xE4C0, { 0xE6, 0x9A, 0x96 },
	0xE4C1, { 0xE6, 0x9A, 0x84 },
	0xE4C2, { 0xE6, 0x9A, 0x98 },
	0xE4C3, { 0xE6, 0x9A, 0x8D },
	0xE4C4, { 0xE6, 0x9C, 0x83 },
	0xE4C5, { 0xE6, 0xA6, 0x94 },
	0xE4C6, { 0xE6, 0xA5, 0xAD },
	0xE4C7, { 0xE6, 0xA5, 0x9A },
	0xE4C8, { 0xE6, 0xA5, 0xB7 },
	0xE4C9, { 0xE6, 0xA5, 0xA0 },
	0xE4CA, { 0xE6, 0xA5, 0x94 },
	0xE4CB, { 0xE6, 0xA5, 0xB5 },
	0xE4CC, { 0xE6, 0xA4, 0xB0 },
	0xE4CD, { 0xE6, 0xA6, 0x82 },
	0xE4CE, { 0xE6, 0xA5, 0x8A },
	0xE4CF, { 0xE6, 0xA5, 0xA8 },
	0xE4D0, { 0xE6, 0xA5, 0xAB },
	0xE4D1, { 0xE6, 0xA5, 0x9E },
	0xE4D2, { 0xE6, 0xA5, 0x93 },
	0xE4D3, { 0xE6, 0xA5, 0xB9 },
	0xE4D4, { 0xE6, 0xA6, 0x86 },
	0xE4D5, { 0xE6, 0xA5, 0x9D },
	0xE4D6, { 0xE6, 0xA5, 0xA3 },
	0xE4D7, { 0xE6, 0xA5, 0x9B },
	0xE4D8, { 0xE6, 0xAD, 0x87 },
	0xE4D9, { 0xE6, 0xAD, 0xB2 },
	0xE4DA, { 0xE6, 0xAF, 0x80 },
	0xE4DB, { 0xE6, 0xAE, 0xBF },
	0xE4DC, { 0xE6, 0xAF, 0x93 },
	0xE4DD, { 0xE6, 0xAF, 0xBD },
	0xE4DE, { 0xE6, 0xBA, 0xA2 },
	0xE4DF, { 0xE6, 0xBA, 0xAF },
	0xE4E0, { 0xE6, 0xBB, 0x93 },
	0xE4E1, { 0xE6, 0xBA, 0xB6 },
	0xE4E2, { 0xE6, 0xBB, 0x82 },
	0xE4E3, { 0xE6, 0xBA, 0x90 },
	0xE4E4, { 0xE6, 0xBA, 0x9D },
	0xE4E5, { 0xE6, 0xBB, 0x87 },
	0xE4E6, { 0xE6, 0xBB, 0x85 },
	0xE4E7, { 0xE6, 0xBA, 0xA5 },
	0xE4E8, { 0xE6, 0xBA, 0x98 },
	0xE4E9, { 0xE6, 0xBA, 0xBC },
	0xE4EA, { 0xE6, 0xBA, 0xBA },
	0xE4EB, { 0xE6, 0xBA, 0xAB },
	0xE4EC, { 0xE6, 0xBB, 0x91 },
	0xE4ED, { 0xE6, 0xBA, 0x96 },
	0xE4EE, { 0xE6, 0xBA, 0x9C },
	0xE4EF, { 0xE6, 0xBB, 0x84 },
	0xE4F0, { 0xE6, 0xBB, 0x94 },
	0xE4F1, { 0xE6, 0xBA, 0xAA },
	0xE4F2, { 0xE6, 0xBA, 0xA7 },
	0xE4F3, { 0xE6, 0xBA, 0xB4 },
	0xE4F4, { 0xE7, 0x85, 0x8E },
	0xE4F5, { 0xE7, 0x85, 0x99 },
	0xE4F6, { 0xE7, 0x85, 0xA9 },
	0xE4F7, { 0xE7, 0x85, 0xA4 },
	0xE4F8, { 0xE7, 0x85, 0x89 },
	0xE4F9, { 0xE7, 0x85, 0xA7 },
	0xE4FA, { 0xE7, 0x85, 0x9C },
	0xE4FB, { 0xE7, 0x85, 0xAC },
	0xE4FC, { 0xE7, 0x85, 0xA6 },
	0xE4FD, { 0xE7, 0x85, 0x8C },
	0xE4FE, { 0xE7, 0x85, 0xA5 },
	0xE5A1, { 0xE7, 0x85, 0x9E },
	0xE5A2, { 0xE7, 0x85, 0x86 },
	0xE5A3, { 0xE7, 0x85, 0xA8 },
	0xE5A4, { 0xE7, 0x85, 0x96 },
	0xE5A5, { 0xE7, 0x88, 0xBA },
	0xE5A6, { 0xE7, 0x89, 0x92 },
	0xE5A7, { 0xE7, 0x8C, 0xB7 },
	0xE5A8, { 0xE7, 0x8D, 0x85 },
	0xE5A9, { 0xE7, 0x8C, 0xBF },
	0xE5AA, { 0xE7, 0x8C, 0xBE },
	0xE5AB, { 0xE7, 0x91, 0xAF },
	0xE5AC, { 0xE7, 0x91, 0x9A },
	0xE5AD, { 0xE7, 0x91, 0x95 },
	0xE5AE, { 0xE7, 0x91, 0x9F },
	0xE5AF, { 0xE7, 0x91, 0x9E },
	0xE5B0, { 0xE7, 0x91, 0x81 },
	0xE5B1, { 0xE7, 0x90, 0xBF },
	0xE5B2, { 0xE7, 0x91, 0x99 },
	0xE5B3, { 0xE7, 0x91, 0x9B },
	0xE5B4, { 0xE7, 0x91, 0x9C },
	0xE5B5, { 0xE7, 0x95, 0xB6 },
	0xE5B6, { 0xE7, 0x95, 0xB8 },
	0xE5B7, { 0xE7, 0x98, 0x80 },
	0xE5B8, { 0xE7, 0x97, 0xB0 },
	0xE5B9, { 0xE7, 0x98, 0x81 },
	0xE5BA, { 0xE7, 0x97, 0xB2 },
	0xE5BB, { 0xE7, 0x97, 0xB1 },
	0xE5BC, { 0xE7, 0x97, 0xBA },
	0xE5BD, { 0xE7, 0x97, 0xBF },
	0xE5BE, { 0xE7, 0x97, 0xB4 },
	0xE5BF, { 0xE7, 0x97, 0xB3 },
	0xE5C0, { 0xE7, 0x9B, 0x9E },
	0xE5C1, { 0xE7, 0x9B, 0x9F },
	0xE5C2, { 0xE7, 0x9D, 0x9B },
	0xE5C3, { 0xE7, 0x9D, 0xAB },
	0xE5C4, { 0xE7, 0x9D, 0xA6 },
	0xE5C5, { 0xE7, 0x9D, 0x9E },
	0xE5C6, { 0xE7, 0x9D, 0xA3 },
	0xE5C7, { 0xE7, 0x9D, 0xB9 },
	0xE5C8, { 0xE7, 0x9D, 0xAA },
	0xE5C9, { 0xE7, 0x9D, 0xAC },
	0xE5CA, { 0xE7, 0x9D, 0x9C },
	0xE5CB, { 0xE7, 0x9D, 0xA5 },
	0xE5CC, { 0xE7, 0x9D, 0xA8 },
	0xE5CD, { 0xE7, 0x9D, 0xA2 },
	0xE5CE, { 0xE7, 0x9F, 0xAE },
	0xE5CF, { 0xE7, 0xA2, 0x8E },
	0xE5D0, { 0xE7, 0xA2, 0xB0 },
	0xE5D1, { 0xE7, 0xA2, 0x97 },
	0xE5D2, { 0xE7, 0xA2, 0x98 },
	0xE5D3, { 0xE7, 0xA2, 0x8C },
	0xE5D4, { 0xE7, 0xA2, 0x89 },
	0xE5D5, { 0xE7, 0xA1, 0xBC },
	0xE5D6, { 0xE7, 0xA2, 0x91 },
	0xE5D7, { 0xE7, 0xA2, 0x93 },
	0xE5D8, { 0xE7, 0xA1, 0xBF },
	0xE5D9, { 0xE7, 0xA5, 0xBA },
	0xE5DA, { 0xE7, 0xA5, 0xBF },
	0xE5DB, { 0xE7, 0xA6, 0x81 },
	0xE5DC, { 0xE8, 0x90, 0xAC },
	0xE5DD, { 0xE7, 0xA6, 0xBD },
	0xE5DE, { 0xE7, 0xA8, 0x9C },
	0xE5DF, { 0xE7, 0xA8, 0x9A },
	0xE5E0, { 0xE7, 0xA8, 0xA0 },
	0xE5E1, { 0xE7, 0xA8, 0x94 },
	0xE5E2, { 0xE7, 0xA8, 0x9F },
	0xE5E3, { 0xE7, 0xA8, 0x9E },
	0xE5E4, { 0xE7, 0xAA, 0x9F },
	0xE5E5, { 0xE7, 0xAA, 0xA0 },
	0xE5E6, { 0xE7, 0xAD, 0xB7 },
	0xE5E7, { 0xE7, 0xAF, 0x80 },
	0xE5E8, { 0xE7, 0xAD, 0xA0 },
	0xE5E9, { 0xE7, 0xAD, 0xAE },
	0xE5EA, { 0xE7, 0xAD, 0xA7 },
	0xE5EB, { 0xE7, 0xB2, 0xB1 },
	0xE5EC, { 0xE7, 0xB2, 0xB3 },
	0xE5ED, { 0xE7, 0xB2, 0xB5 },
	0xE5EE, { 0xE7, 0xB6, 0x93 },
	0xE5EF, { 0xE7, 0xB5, 0xB9 },
	0xE5F0, { 0xE7, 0xB6, 0x91 },
	0xE5F1, { 0xE7, 0xB6, 0x81 },
	0xE5F2, { 0xE7, 0xB6, 0x8F },
	0xE5F3, { 0xE7, 0xB5, 0x9B },
	0xE5F4, { 0xE7, 0xBD, 0xAE },
	0xE5F5, { 0xE7, 0xBD, 0xA9 },
	0xE5F6, { 0xE7, 0xBD, 0xAA },
	0xE5F7, { 0xE7, 0xBD, 0xB2 },
	0xE5F8, { 0xE7, 0xBE, 0xA9 },
	0xE5F9, { 0xE7, 0xBE, 0xA8 },
	0xE5FA, { 0xE7, 0xBE, 0xA4 },
	0xE5FB, { 0xE8, 0x81, 0x96 },
	0xE5FC, { 0xE8, 0x81, 0x98 },
	0xE5FD, { 0xE8, 0x82, 0x86 },
	0xE5FE, { 0xE8, 0x82, 0x84 },
	0xE6A1, { 0xE8, 0x85, 0xB1 },
	0xE6A2, { 0xE8, 0x85, 0xB0 },
	0xE6A3, { 0xE8, 0x85, 0xB8 },
	0xE6A4, { 0xE8, 0x85, 0xA5 },
	0xE6A5, { 0xE8, 0x85, 0xAE },
	0xE6A6, { 0xE8, 0x85, 0xB3 },
	0xE6A7, { 0xE8, 0x85, 0xAB },
	0xE6A8, { 0xE8, 0x85, 0xB9 },
	0xE6A9, { 0xE8, 0x85, 0xBA },
	0xE6AA, { 0xE8, 0x85, 0xA6 },
	0xE6AB, { 0xE8, 0x88, 0x85 },
	0xE6AC, { 0xE8, 0x89, 0x87 },
	0xE6AD, { 0xE8, 0x92, 0x82 },
	0xE6AE, { 0xE8, 0x91, 0xB7 },
	0xE6AF, { 0xE8, 0x90, 0xBD },
	0xE6B0, { 0xE8, 0x90, 0xB1 },
	0xE6B1, { 0xE8, 0x91, 0xB5 },
	0xE6B2, { 0xE8, 0x91, 0xA6 },
	0xE6B3, { 0xE8, 0x91, 0xAB },
	0xE6B4, { 0xE8, 0x91, 0x89 },
	0xE6B5, { 0xE8, 0x91, 0xAC },
	0xE6B6, { 0xE8, 0x91, 0x9B },
	0xE6B7, { 0xE8, 0x90, 0xBC },
	0xE6B8, { 0xE8, 0x90, 0xB5 },
	0xE6B9, { 0xE8, 0x91, 0xA1 },
	0xE6BA, { 0xE8, 0x91, 0xA3 },
	0xE6BB, { 0xE8, 0x91, 0xA9 },
	0xE6BC, { 0xE8, 0x91, 0xAD },
	0xE6BD, { 0xE8, 0x91, 0x86 },
	0xE6BE, { 0xE8, 0x99, 0x9E },
	0xE6BF, { 0xE8, 0x99, 0x9C },
	0xE6C0, { 0xE8, 0x99, 0x9F },
	0xE6C1, { 0xE8, 0x9B, 0xB9 },
	0xE6C2, { 0xE8, 0x9C, 0x93 },
	0xE6C3, { 0xE8, 0x9C, 0x88 },
	0xE6C4, { 0xE8, 0x9C, 0x87 },
	0xE6C5, { 0xE8, 0x9C, 0x80 },
	0xE6C6, { 0xE8, 0x9B, 0xBE },
	0xE6C7, { 0xE8, 0x9B, 0xBB },
	0xE6C8, { 0xE8, 0x9C, 0x82 },
	0xE6C9, { 0xE8, 0x9C, 0x83 },
	0xE6CA, { 0xE8, 0x9C, 0x86 },
	0xE6CB, { 0xE8, 0x9C, 0x8A },
	0xE6CC, { 0xE8, 0xA1, 0x99 },
	0xE6CD, { 0xE8, 0xA3, 0x9F },
	0xE6CE, { 0xE8, 0xA3, 0x94 },
	0xE6CF, { 0xE8, 0xA3, 0x99 },
	0xE6D0, { 0xE8, 0xA3, 0x9C },
	0xE6D1, { 0xE8, 0xA3, 0x98 },
	0xE6D2, { 0xE8, 0xA3, 0x9D },
	0xE6D3, { 0xE8, 0xA3, 0xA1 },
	0xE6D4, { 0xE8, 0xA3, 0x8A },
	0xE6D5, { 0xE8, 0xA3, 0x95 },
	0xE6D6, { 0xE8, 0xA3, 0x92 },
	0xE6D7, { 0xE8, 0xA6, 0x9C },
	0xE6D8, { 0xE8, 0xA7, 0xA3 },
	0xE6D9, { 0xE8, 0xA9, 0xAB },
	0xE6DA, { 0xE8, 0xA9, 0xB2 },
	0xE6DB, { 0xE8, 0xA9, 0xB3 },
	0xE6DC, { 0xE8, 0xA9, 0xA6 },
	0xE6DD, { 0xE8, 0xA9, 0xA9 },
	0xE6DE, { 0xE8, 0xA9, 0xB0 },
	0xE6DF, { 0xE8, 0xAA, 0x87 },
	0xE6E0, { 0xE8, 0xA9, 0xBC },
	0xE6E1, { 0xE8, 0xA9, 0xA3 },
	0xE6E2, { 0xE8, 0xAA, 0xA0 },
	0xE6E3, { 0xE8, 0xA9, 0xB1 },
	0xE6E4, { 0xE8, 0xAA, 0x85 },
	0xE6E5, { 0xE8, 0xA9, 0xAD },
	0xE6E6, { 0xE8, 0xA9, 0xA2 },
	0xE6E7, { 0xE8, 0xA9, 0xAE },
	0xE6E8, { 0xE8, 0xA9, 0xAC },
	0xE6E9, { 0xE8, 0xA9, 0xB9 },
	0xE6EA, { 0xE8, 0xA9, 0xBB },
	0xE6EB, { 0xE8, 0xA8, 0xBE },
	0xE6EC, { 0xE8, 0xA9, 0xA8 },
	0xE6ED, { 0xE8, 0xB1, 0xA2 },
	0xE6EE, { 0xE8, 0xB2, 0x8A },
	0xE6EF, { 0xE8, 0xB2, 0x89 },
	0xE6F0, { 0xE8, 0xB3, 0x8A },
	0xE6F1, { 0xE8, 0xB3, 0x87 },
	0xE6F2, { 0xE8, 0xB3, 0x88 },
	0xE6F3, { 0xE8, 0xB3, 0x84 },
	0xE6F4, { 0xE8, 0xB2, 0xB2 },
	0xE6F5, { 0xE8, 0xB3, 0x83 },
	0xE6F6, { 0xE8, 0xB3, 0x82 },
	0xE6F7, { 0xE8, 0xB3, 0x85 },
	0xE6F8, { 0xE8, 0xB7, 0xA1 },
	0xE6F9, { 0xE8, 0xB7, 0x9F },
	0xE6FA, { 0xE8, 0xB7, 0xA8 },
	0xE6FB, { 0xE8, 0xB7, 0xAF },
	0xE6FC, { 0xE8, 0xB7, 0xB3 },
	0xE6FD, { 0xE8, 0xB7, 0xBA },
	0xE6FE, { 0xE8, 0xB7, 0xAA },
	0xE7A1, { 0xE8, 0xB7, 0xA4 },
	0xE7A2, { 0xE8, 0xB7, 0xA6 },
	0xE7A3, { 0xE8, 0xBA, 0xB2 },
	0xE7A4, { 0xE8, 0xBC, 0x83 },
	0xE7A5, { 0xE8, 0xBC, 0x89 },
	0xE7A6, { 0xE8, 0xBB, 0xBE },
	0xE7A7, { 0xE8, 0xBC, 0x8A },
	0xE7A8, { 0xE8, 0xBE, 0x9F },
	0xE7A9, { 0xE8, 0xBE, 0xB2 },
	0xE7AA, { 0xE9, 0x81, 0x8B },
	0xE7AB, { 0xE9, 0x81, 0x8A },
	0xE7AC, { 0xE9, 0x81, 0x93 },
	0xE7AD, { 0xE9, 0x81, 0x82 },
	0xE7AE, { 0xE9, 0x81, 0x94 },
	0xE7AF, { 0xE9, 0x80, 0xBC },
	0xE7B0, { 0xE9, 0x81, 0x95 },
	0xE7B1, { 0xE9, 0x81, 0x90 },
	0xE7B2, { 0xE9, 0x81, 0x87 },
	0xE7B3, { 0xE9, 0x81, 0x8F },
	0xE7B4, { 0xE9, 0x81, 0x8E },
	0xE7B5, { 0xE9, 0x81, 0x8D },
	0xE7B6, { 0xE9, 0x81, 0x91 },
	0xE7B7, { 0xE9, 0x80, 0xBE },
	0xE7B8, { 0xE9, 0x81, 0x81 },
	0xE7B9, { 0xE9, 0x84, 0x92 },
	0xE7BA, { 0xE9, 0x84, 0x97 },
	0xE7BB, { 0xE9, 0x85, 0xAC },
	0xE7BC, { 0xE9, 0x85, 0xAA },
	0xE7BD, { 0xE9, 0x85, 0xA9 },
	0xE7BE, { 0xE9, 0x87, 0x89 },
	0xE7BF, { 0xE9, 0x88, 0xB7 },
	0xE7C0, { 0xE9, 0x89, 0x97 },
	0xE7C1, { 0xE9, 0x88, 0xB8 },
	0xE7C2, { 0xE9, 0x88, 0xBD },
	0xE7C3, { 0xE9, 0x89, 0x80 },
	0xE7C4, { 0xE9, 0x88, 0xBE },
	0xE7C5, { 0xE9, 0x89, 0x9B },
	0xE7C6, { 0xE9, 0x89, 0x8B },
	0xE7C7, { 0xE9, 0x89, 0xA4 },
	0xE7C8, { 0xE9, 0x89, 0x91 },
	0xE7C9, { 0xE9, 0x88, 0xB4 },
	0xE7CA, { 0xE9, 0x89, 0x89 },
	0xE7CB, { 0xE9, 0x89, 0x8D },
	0xE7CC, { 0xE9, 0x89, 0x85 },
	0xE7CD, { 0xE9, 0x88, 0xB9 },
	0xE7CE, { 0xE9, 0x88, 0xBF },
	0xE7CF, { 0xE9, 0x89, 0x9A },
	0xE7D0, { 0xE9, 0x96, 0x98 },
	0xE7D1, { 0xE9, 0x9A, 0x98 },
	0xE7D2, { 0xE9, 0x9A, 0x94 },
	0xE7D3, { 0xE9, 0x9A, 0x95 },
	0xE7D4, { 0xE9, 0x9B, 0x8D },
	0xE7D5, { 0xE9, 0x9B, 0x8B },
	0xE7D6, { 0xE9, 0x9B, 0x89 },
	0xE7D7, { 0xE9, 0x9B, 0x8A },
	0xE7D8, { 0xE9, 0x9B, 0xB7 },
	0xE7D9, { 0xE9, 0x9B, 0xBB },
	0xE7DA, { 0xE9, 0x9B, 0xB9 },
	0xE7DB, { 0xE9, 0x9B, 0xB6 },
	0xE7DC, { 0xE9, 0x9D, 0x96 },
	0xE7DD, { 0xE9, 0x9D, 0xB4 },
	0xE7DE, { 0xE9, 0x9D, 0xB6 },
	0xE7DF, { 0xE9, 0xA0, 0x90 },
	0xE7E0, { 0xE9, 0xA0, 0x91 },
	0xE7E1, { 0xE9, 0xA0, 0x93 },
	0xE7E2, { 0xE9, 0xA0, 0x8A },
	0xE7E3, { 0xE9, 0xA0, 0x92 },
	0xE7E4, { 0xE9, 0xA0, 0x8C },
	0xE7E5, { 0xE9, 0xA3, 0xBC },
	0xE7E6, { 0xE9, 0xA3, 0xB4 },
	0xE7E7, { 0xE9, 0xA3, 0xBD },
	0xE7E8, { 0xE9, 0xA3, 0xBE },
	0xE7E9, { 0xE9, 0xA6, 0xB3 },
	0xE7EA, { 0xE9, 0xA6, 0xB1 },
	0xE7EB, { 0xE9, 0xA6, 0xB4 },
	0xE7EC, { 0xE9, 0xAB, 0xA1 },
	0xE7ED, { 0xE9, 0xB3, 0xA9 },
	0xE7EE, { 0xE9, 0xBA, 0x82 },
	0xE7EF, { 0xE9, 0xBC, 0x8E },
	0xE7F0, { 0xE9, 0xBC, 0x93 },
	0xE7F1, { 0xE9, 0xBC, 0xA0 },
	0xE7F2, { 0xE5, 0x83, 0xA7 },
	0xE7F3, { 0xE5, 0x83, 0xAE },
	0xE7F4, { 0xE5, 0x83, 0xA5 },
	0xE7F5, { 0xE5, 0x83, 0x96 },
	0xE7F6, { 0xE5, 0x83, 0xAD },
	0xE7F7, { 0xE5, 0x83, 0x9A },
	0xE7F8, { 0xE5, 0x83, 0x95 },
	0xE7F9, { 0xE5, 0x83, 0x8F },
	0xE7FA, { 0xE5, 0x83, 0x91 },
	0xE7FB, { 0xE5, 0x83, 0xB1 },
	0xE7FC, { 0xE5, 0x83, 0x8E },
	0xE7FD, { 0xE5, 0x83, 0xA9 },
	0xE7FE, { 0xE5, 0x85, 0xA2 },
	0xE8A1, { 0xE5, 0x87, 0xB3 },
	0xE8A2, { 0xE5, 0x8A, 0x83 },
	0xE8A3, { 0xE5, 0x8A, 0x82 },
	0xE8A4, { 0xE5, 0x8C, 0xB1 },
	0xE8A5, { 0xE5, 0x8E, 0xAD },
	0xE8A6, { 0xE5, 0x97, 0xBE },
	0xE8A7, { 0xE5, 0x98, 0x80 },
	0xE8A8, { 0xE5, 0x98, 0x9B },
	0xE8A9, { 0xE5, 0x98, 0x97 },
	0xE8AA, { 0xE5, 0x97, 0xBD },
	0xE8AB, { 0xE5, 0x98, 0x94 },
	0xE8AC, { 0xE5, 0x98, 0x86 },
	0xE8AD, { 0xE5, 0x98, 0x89 },
	0xE8AE, { 0xE5, 0x98, 0x8D },
	0xE8AF, { 0xE5, 0x98, 0x8E },
	0xE8B0, { 0xE5, 0x97, 0xB7 },
	0xE8B1, { 0xE5, 0x98, 0x96 },
	0xE8B2, { 0xE5, 0x98, 0x9F },
	0xE8B3, { 0xE5, 0x98, 0x88 },
	0xE8B4, { 0xE5, 0x98, 0x90 },
	0xE8B5, { 0xE5, 0x97, 0xB6 },
	0xE8B6, { 0xE5, 0x9C, 0x98 },
	0xE8B7, { 0xE5, 0x9C, 0x96 },
	0xE8B8, { 0xE5, 0xA1, 0xB5 },
	0xE8B9, { 0xE5, 0xA1, 0xBE },
	0xE8BA, { 0xE5, 0xA2, 0x83 },
	0xE8BB, { 0xE5, 0xA2, 0x93 },
	0xE8BC, { 0xE5, 0xA2, 0x8A },
	0xE8BD, { 0xE5, 0xA1, 0xB9 },
	0xE8BE, { 0xE5, 0xA2, 0x85 },
	0xE8BF, { 0xE5, 0xA1, 0xBD },
	0xE8C0, { 0xE5, 0xA3, 0xBD },
	0xE8C1, { 0xE5, 0xA4, 0xA5 },
	0xE8C2, { 0xE5, 0xA4, 0xA2 },
	0xE8C3, { 0xE5, 0xA4, 0xA4 },
	0xE8C4, { 0xE5, 0xA5, 0xAA },
	0xE8C5, { 0xE5, 0xA5, 0xA9 },
	0xE8C6, { 0xE5, 0xAB, 0xA1 },
	0xE8C7, { 0xE5, 0xAB, 0xA6 },
	0xE8C8, { 0xE5, 0xAB, 0xA9 },
	0xE8C9, { 0xE5, 0xAB, 0x97 },
	0xE8CA, { 0xE5, 0xAB, 0x96 },
	0xE8CB, { 0xE5, 0xAB, 0x98 },
	0xE8CC, { 0xE5, 0xAB, 0xA3 },
	0xE8CD, { 0xE5, 0xAD, 0xB5 },
	0xE8CE, { 0xE5, 0xAF, 0x9E },
	0xE8CF, { 0xE5, 0xAF, 0xA7 },
	0xE8D0, { 0xE5, 0xAF, 0xA1 },
	0xE8D1, { 0xE5, 0xAF, 0xA5 },
	0xE8D2, { 0xE5, 0xAF, 0xA6 },
	0xE8D3, { 0xE5, 0xAF, 0xA8 },
	0xE8D4, { 0xE5, 0xAF, 0xA2 },
	0xE8D5, { 0xE5, 0xAF, 0xA4 },
	0xE8D6, { 0xE5, 0xAF, 0x9F },
	0xE8D7, { 0xE5, 0xB0, 0x8D },
	0xE8D8, { 0xE5, 0xB1, 0xA2 },
	0xE8D9, { 0xE5, 0xB6, 0x84 },
	0xE8DA, { 0xE5, 0xB6, 0x87 },
	0xE8DB, { 0xE5, 0xB9, 0x9B },
	0xE8DC, { 0xE5, 0xB9, 0xA3 },
	0xE8DD, { 0xE5, 0xB9, 0x95 },
	0xE8DE, { 0xE5, 0xB9, 0x97 },
	0xE8DF, { 0xE5, 0xB9, 0x94 },
	0xE8E0, { 0xE5, 0xBB, 0x93 },
	0xE8E1, { 0xE5, 0xBB, 0x96 },
	0xE8E2, { 0xE5, 0xBC, 0x8A },
	0xE8E3, { 0xE5, 0xBD, 0x86 },
	0xE8E4, { 0xE5, 0xBD, 0xB0 },
	0xE8E5, { 0xE5, 0xBE, 0xB9 },
	0xE8E6, { 0xE6, 0x85, 0x87 },
	0xE8E7, { 0xE6, 0x84, 0xBF },
	0xE8E8, { 0xE6, 0x85, 0x8B },
	0xE8E9, { 0xE6, 0x85, 0xB7 },
	0xE8EA, { 0xE6, 0x85, 0xA2 },
	0xE8EB, { 0xE6, 0x85, 0xA3 },
	0xE8EC, { 0xE6, 0x85, 0x9F },
	0xE8ED, { 0xE6, 0x85, 0x9A },
	0xE8EE, { 0xE6, 0x85, 0x98 },
	0xE8EF, { 0xE6, 0x85, 0xB5 },
	0xE8F0, { 0xE6, 0x88, 0xAA },
	0xE8F1, { 0xE6, 0x92, 0x87 },
	0xE8F2, { 0xE6, 0x91, 0x98 },
	0xE8F3, { 0xE6, 0x91, 0x94 },
	0xE8F4, { 0xE6, 0x92, 0xA4 },
	0xE8F5, { 0xE6, 0x91, 0xB8 },
	0xE8F6, { 0xE6, 0x91, 0x9F },
	0xE8F7, { 0xE6, 0x91, 0xBA },
	0xE8F8, { 0xE6, 0x91, 0x91 },
	0xE8F9, { 0xE6, 0x91, 0xA7 },
	0xE8FA, { 0xE6, 0x90, 0xB4 },
	0xE8FB, { 0xE6, 0x91, 0xAD },
	0xE8FC, { 0xE6, 0x91, 0xBB },
	0xE8FD, { 0xE6, 0x95, 0xB2 },
	0xE8FE, { 0xE6, 0x96, 0xA1 },
	0xE9A1, { 0xE6, 0x97, 0x97 },
	0xE9A2, { 0xE6, 0x97, 0x96 },
	0xE9A3, { 0xE6, 0x9A, 0xA2 },
	0xE9A4, { 0xE6, 0x9A, 0xA8 },
	0xE9A5, { 0xE6, 0x9A, 0x9D },
	0xE9A6, { 0xE6, 0xA6, 0x9C },
	0xE9A7, { 0xE6, 0xA6, 0xA8 },
	0xE9A8, { 0xE6, 0xA6, 0x95 },
	0xE9A9, { 0xE6, 0xA7, 0x81 },
	0xE9AA, { 0xE6, 0xA6, 0xAE },
	0xE9AB, { 0xE6, 0xA7, 0x93 },
	0xE9AC, { 0xE6, 0xA7, 0x8B },
	0xE9AD, { 0xE6, 0xA6, 0x9B },
	0xE9AE, { 0xE6, 0xA6, 0xB7 },
	0xE9AF, { 0xE6, 0xA6, 0xBB },
	0xE9B0, { 0xE6, 0xA6, 0xAB },
	0xE9B1, { 0xE6, 0xA6, 0xB4 },
	0xE9B2, { 0xE6, 0xA7, 0x90 },
	0xE9B3, { 0xE6, 0xA7, 0x8D },
	0xE9B4, { 0xE6, 0xA6, 0xAD },
	0xE9B5, { 0xE6, 0xA7, 0x8C },
	0xE9B6, { 0xE6, 0xA6, 0xA6 },
	0xE9B7, { 0xE6, 0xA7, 0x83 },
	0xE9B8, { 0xE6, 0xA6, 0xA3 },
	0xE9B9, { 0xE6, 0xAD, 0x89 },
	0xE9BA, { 0xE6, 0xAD, 0x8C },
	0xE9BB, { 0xE6, 0xB0, 0xB3 },
	0xE9BC, { 0xE6, 0xBC, 0xB3 },
	0xE9BD, { 0xE6, 0xBC, 0x94 },
	0xE9BE, { 0xE6, 0xBB, 0xBE },
	0xE9BF, { 0xE6, 0xBC, 0x93 },
	0xE9C0, { 0xE6, 0xBB, 0xB4 },
	0xE9C1, { 0xE6, 0xBC, 0xA9 },
	0xE9C2, { 0xE6, 0xBC, 0xBE },
	0xE9C3, { 0xE6, 0xBC, 0xA0 },
	0xE9C4, { 0xE6, 0xBC, 0xAC },
	0xE9C5, { 0xE6, 0xBC, 0x8F },
	0xE9C6, { 0xE6, 0xBC, 0x82 },
	0xE9C7, { 0xE6, 0xBC, 0xA2 },
	0xE9C8, { 0xE6, 0xBB, 0xBF },
	0xE9C9, { 0xE6, 0xBB, 0xAF },
	0xE9CA, { 0xE6, 0xBC, 0x86 },
	0xE9CB, { 0xE6, 0xBC, 0xB1 },
	0xE9CC, { 0xE6, 0xBC, 0xB8 },
	0xE9CD, { 0xE6, 0xBC, 0xB2 },
	0xE9CE, { 0xE6, 0xBC, 0xA3 },
	0xE9CF, { 0xE6, 0xBC, 0x95 },
	0xE9D0, { 0xE6, 0xBC, 0xAB },
	0xE9D1, { 0xE6, 0xBC, 0xAF },
	0xE9D2, { 0xE6, 0xBE, 0x88 },
	0xE9D3, { 0xE6, 0xBC, 0xAA },
	0xE9D4, { 0xE6, 0xBB, 0xAC },
	0xE9D5, { 0xE6, 0xBC, 0x81 },
	0xE9D6, { 0xE6, 0xBB, 0xB2 },
	0xE9D7, { 0xE6, 0xBB, 0x8C },
	0xE9D8, { 0xE6, 0xBB, 0xB7 },
	0xE9D9, { 0xE7, 0x86, 0x94 },
	0xE9DA, { 0xE7, 0x86, 0x99 },
	0xE9DB, { 0xE7, 0x85, 0xBD },
	0xE9DC, { 0xE7, 0x86, 0x8A },
	0xE9DD, { 0xE7, 0x86, 0x84 },
	0xE9DE, { 0xE7, 0x86, 0x92 },
	0xE9DF, { 0xE7, 0x88, 0xBE },
	0xE9E0, { 0xE7, 0x8A, 0x92 },
	0xE9E1, { 0xE7, 0x8A, 0x96 },
	0xE9E2, { 0xE7, 0x8D, 0x84 },
	0xE9E3, { 0xE7, 0x8D, 0x90 },
	0xE9E4, { 0xE7, 0x91, 0xA4 },
	0xE9E5, { 0xE7, 0x91, 0xA3 },
	0xE9E6, { 0xE7, 0x91, 0xAA },
	0xE9E7, { 0xE7, 0x91, 0xB0 },
	0xE9E8, { 0xE7, 0x91, 0xAD },
	0xE9E9, { 0xE7, 0x94, 0x84 },
	0xE9EA, { 0xE7, 0x96, 0x91 },
	0xE9EB, { 0xE7, 0x98, 0xA7 },
	0xE9EC, { 0xE7, 0x98, 0x8D },
	0xE9ED, { 0xE7, 0x98, 0x8B },
	0xE9EE, { 0xE7, 0x98, 0x89 },
	0xE9EF, { 0xE7, 0x98, 0x93 },
	0xE9F0, { 0xE7, 0x9B, 0xA1 },
	0xE9F1, { 0xE7, 0x9B, 0xA3 },
	0xE9F2, { 0xE7, 0x9E, 0x84 },
	0xE9F3, { 0xE7, 0x9D, 0xBD },
	0xE9F4, { 0xE7, 0x9D, 0xBF },
	0xE9F5, { 0xE7, 0x9D, 0xA1 },
	0xE9F6, { 0xE7, 0xA3, 0x81 },
	0xE9F7, { 0xE7, 0xA2, 0x9F },
	0xE9F8, { 0xE7, 0xA2, 0xA7 },
	0xE9F9, { 0xE7, 0xA2, 0xB3 },
	0xE9FA, { 0xE7, 0xA2, 0xA9 },
	0xE9FB, { 0xE7, 0xA2, 0xA3 },
	0xE9FC, { 0xE7, 0xA6, 0x8E },
	0xE9FD, { 0xE7, 0xA6, 0x8F },
	0xE9FE, { 0xE7, 0xA6, 0x8D },
	0xEAA1, { 0xE7, 0xA8, 0xAE },
	0xEAA2, { 0xE7, 0xA8, 0xB1 },
	0xEAA3, { 0xE7, 0xAA, 0xAA },
	0xEAA4, { 0xE7, 0xAA, 0xA9 },
	0xEAA5, { 0xE7, 0xAB, 0xAD },
	0xEAA6, { 0xE7, 0xAB, 0xAF },
	0xEAA7, { 0xE7, 0xAE, 0xA1 },
	0xEAA8, { 0xE7, 0xAE, 0x95 },
	0xEAA9, { 0xE7, 0xAE, 0x8B },
	0xEAAA, { 0xE7, 0xAD, 0xB5 },
	0xEAAB, { 0xE7, 0xAE, 0x97 },
	0xEAAC, { 0xE7, 0xAE, 0x9D },
	0xEAAD, { 0xE7, 0xAE, 0x94 },
	0xEAAE, { 0xE7, 0xAE, 0x8F },
	0xEAAF, { 0xE7, 0xAE, 0xB8 },
	0xEAB0, { 0xE7, 0xAE, 0x87 },
	0xEAB1, { 0xE7, 0xAE, 0x84 },
	0xEAB2, { 0xE7, 0xB2, 0xB9 },
	0xEAB3, { 0xE7, 0xB2, 0xBD },
	0xEAB4, { 0xE7, 0xB2, 0xBE },
	0xEAB5, { 0xE7, 0xB6, 0xBB },
	0xEAB6, { 0xE7, 0xB6, 0xB0 },
	0xEAB7, { 0xE7, 0xB6, 0x9C },
	0xEAB8, { 0xE7, 0xB6, 0xBD },
	0xEAB9, { 0xE7, 0xB6, 0xBE },
	0xEABA, { 0xE7, 0xB6, 0xA0 },
	0xEABB, { 0xE7, 0xB7, 0x8A },
	0xEABC, { 0xE7, 0xB6, 0xB4 },
	0xEABD, { 0xE7, 0xB6, 0xB2 },
	0xEABE, { 0xE7, 0xB6, 0xB1 },
	0xEABF, { 0xE7, 0xB6, 0xBA },
	0xEAC0, { 0xE7, 0xB6, 0xA2 },
	0xEAC1, { 0xE7, 0xB6, 0xBF },
	0xEAC2, { 0xE7, 0xB6, 0xB5 },
	0xEAC3, { 0xE7, 0xB6, 0xB8 },
	0xEAC4, { 0xE7, 0xB6, 0xAD },
	0xEAC5, { 0xE7, 0xB7, 0x92 },
	0xEAC6, { 0xE7, 0xB7, 0x87 },
	0xEAC7, { 0xE7, 0xB6, 0xAC },
	0xEAC8, { 0xE7, 0xBD, 0xB0 },
	0xEAC9, { 0xE7, 0xBF, 0xA0 },
	0xEACA, { 0xE7, 0xBF, 0xA1 },
	0xEACB, { 0xE7, 0xBF, 0x9F },
	0xEACC, { 0xE8, 0x81, 0x9E },
	0xEACD, { 0xE8, 0x81, 0x9A },
	0xEACE, { 0xE8, 0x82, 0x87 },
	0xEACF, { 0xE8, 0x85, 0x90 },
	0xEAD0, { 0xE8, 0x86, 0x80 },
	0xEAD1, { 0xE8, 0x86, 0x8F },
	0xEAD2, { 0xE8, 0x86, 0x88 },
	0xEAD3, { 0xE8, 0x86, 0x8A },
	0xEAD4, { 0xE8, 0x85, 0xBF },
	0xEAD5, { 0xE8, 0x86, 0x82 },
	0xEAD6, { 0xE8, 0x87, 0xA7 },
	0xEAD7, { 0xE8, 0x87, 0xBA },
	0xEAD8, { 0xE8, 0x88, 0x87 },
	0xEAD9, { 0xE8, 0x88, 0x94 },
	0xEADA, { 0xE8, 0x88, 0x9E },
	0xEADB, { 0xE8, 0x89, 0x8B },
	0xEADC, { 0xE8, 0x93, 0x89 },
	0xEADD, { 0xE8, 0x92, 0xBF },
	0xEADE, { 0xE8, 0x93, 0x86 },
	0xEADF, { 0xE8, 0x93, 0x84 },
	0xEAE0, { 0xE8, 0x92, 0x99 },
	0xEAE1, { 0xE8, 0x92, 0x9E },
	0xEAE2, { 0xE8, 0x92, 0xB2 },
	0xEAE3, { 0xE8, 0x92, 0x9C },
	0xEAE4, { 0xE8, 0x93, 0x8B },
	0xEAE5, { 0xE8, 0x92, 0xB8 },
	0xEAE6, { 0xE8, 0x93, 0x80 },
	0xEAE7, { 0xE8, 0x93, 0x93 },
	0xEAE8, { 0xE8, 0x92, 0x90 },
	0xEAE9, { 0xE8, 0x92, 0xBC },
	0xEAEA, { 0xE8, 0x93, 0x91 },
	0xEAEB, { 0xE8, 0x93, 0x8A },
	0xEAEC, { 0xE8, 0x9C, 0xBF },
	0xEAED, { 0xE8, 0x9C, 0x9C },
	0xEAEE, { 0xE8, 0x9C, 0xBB },
	0xEAEF, { 0xE8, 0x9C, 0xA2 },
	0xEAF0, { 0xE8, 0x9C, 0xA5 },
	0xEAF1, { 0xE8, 0x9C, 0xB4 },
	0xEAF2, { 0xE8, 0x9C, 0x98 },
	0xEAF3, { 0xE8, 0x9D, 0x95 },
	0xEAF4, { 0xE8, 0x9C, 0xB7 },
	0xEAF5, { 0xE8, 0x9C, 0xA9 },
	0xEAF6, { 0xE8, 0xA3, 0xB3 },
	0xEAF7, { 0xE8, 0xA4, 0x82 },
	0xEAF8, { 0xE8, 0xA3, 0xB4 },
	0xEAF9, { 0xE8, 0xA3, 0xB9 },
	0xEAFA, { 0xE8, 0xA3, 0xB8 },
	0xEAFB, { 0xE8, 0xA3, 0xBD },
	0xEAFC, { 0xE8, 0xA3, 0xA8 },
	0xEAFD, { 0xE8, 0xA4, 0x9A },
	0xEAFE, { 0xE8, 0xA3, 0xAF },
	0xEBA1, { 0xE8, 0xAA, 0xA6 },
	0xEBA2, { 0xE8, 0xAA, 0x8C },
	0xEBA3, { 0xE8, 0xAA, 0x9E },
	0xEBA4, { 0xE8, 0xAA, 0xA3 },
	0xEBA5, { 0xE8, 0xAA, 0x8D },
	0xEBA6, { 0xE8, 0xAA, 0xA1 },
	0xEBA7, { 0xE8, 0xAA, 0x93 },
	0xEBA8, { 0xE8, 0xAA, 0xA4 },
	0xEBA9, { 0xE8, 0xAA, 0xAA },
	0xEBAA, { 0xE8, 0xAA, 0xA5 },
	0xEBAB, { 0xE8, 0xAA, 0xA8 },
	0xEBAC, { 0xE8, 0xAA, 0x98 },
	0xEBAD, { 0xE8, 0xAA, 0x91 },
	0xEBAE, { 0xE8, 0xAA, 0x9A },
	0xEBAF, { 0xE8, 0xAA, 0xA7 },
	0xEBB0, { 0xE8, 0xB1, 0xAA },
	0xEBB1, { 0xE8, 0xB2, 0x8D },
	0xEBB2, { 0xE8, 0xB2, 0x8C },
	0xEBB3, { 0xE8, 0xB3, 0x93 },
	0xEBB4, { 0xE8, 0xB3, 0x91 },
	0xEBB5, { 0xE8, 0xB3, 0x92 },
	0xEBB6, { 0xE8, 0xB5, 0xAB },
	0xEBB7, { 0xE8, 0xB6, 0x99 },
	0xEBB8, { 0xE8, 0xB6, 0x95 },
	0xEBB9, { 0xE8, 0xB7, 0xBC },
	0xEBBA, { 0xE8, 0xBC, 0x94 },
	0xEBBB, { 0xE8, 0xBC, 0x92 },
	0xEBBC, { 0xE8, 0xBC, 0x95 },
	0xEBBD, { 0xE8, 0xBC, 0x93 },
	0xEBBE, { 0xE8, 0xBE, 0xA3 },
	0xEBBF, { 0xE9, 0x81, 0xA0 },
	0xEBC0, { 0xE9, 0x81, 0x98 },
	0xEBC1, { 0xE9, 0x81, 0x9C },
	0xEBC2, { 0xE9, 0x81, 0xA3 },
	0xEBC3, { 0xE9, 0x81, 0x99 },
	0xEBC4, { 0xE9, 0x81, 0x9E },
	0xEBC5, { 0xE9, 0x81, 0xA2 },
	0xEBC6, { 0xE9, 0x81, 0x9D },
	0xEBC7, { 0xE9, 0x81, 0x9B },
	0xEBC8, { 0xE9, 0x84, 0x99 },
	0xEBC9, { 0xE9, 0x84, 0x98 },
	0xEBCA, { 0xE9, 0x84, 0x9E },
	0xEBCB, { 0xE9, 0x85, 0xB5 },
	0xEBCC, { 0xE9, 0x85, 0xB8 },
	0xEBCD, { 0xE9, 0x85, 0xB7 },
	0xEBCE, { 0xE9, 0x85, 0xB4 },
	0xEBCF, { 0xE9, 0x89, 0xB8 },
	0xEBD0, { 0xE9, 0x8A, 0xAC },
	0xEBD1, { 0xE9, 0x8A, 0x80 },
	0xEBD2, { 0xE9, 0x8A, 0x85 },
	0xEBD3, { 0xE9, 0x8A, 0x98 },
	0xEBD4, { 0xE9, 0x8A, 0x96 },
	0xEBD5, { 0xE9, 0x89, 0xBB },
	0xEBD6, { 0xE9, 0x8A, 0x93 },
	0xEBD7, { 0xE9, 0x8A, 0x9C },
	0xEBD8, { 0xE9, 0x8A, 0xA8 },
	0xEBD9, { 0xE9, 0x89, 0xBC },
	0xEBDA, { 0xE9, 0x8A, 0x91 },
	0xEBDB, { 0xE9, 0x96, 0xA1 },
	0xEBDC, { 0xE9, 0x96, 0xA8 },
	0xEBDD, { 0xE9, 0x96, 0xA9 },
	0xEBDE, { 0xE9, 0x96, 0xA3 },
	0xEBDF, { 0xE9, 0x96, 0xA5 },
	0xEBE0, { 0xE9, 0x96, 0xA4 },
	0xEBE1, { 0xE9, 0x9A, 0x99 },
	0xEBE2, { 0xE9, 0x9A, 0x9C },
	0xEBE3, { 0xE9, 0x9A, 0x9B },
	0xEBE4, { 0xE9, 0x9B, 0x8C },
	0xEBE5, { 0xE9, 0x9B, 0x92 },
	0xEBE6, { 0xE9, 0x9C, 0x80 },
	0xEBE7, { 0xE9, 0x9D, 0xBC },
	0xEBE8, { 0xE9, 0x9E, 0x85 },
	0xEBE9, { 0xE9, 0x9F, 0xB6 },
	0xEBEA, { 0xE9, 0xA0, 0x97 },
	0xEBEB, { 0xE9, 0xA0, 0x98 },
	0xEBEC, { 0xE9, 0xA2, 0xAF },
	0xEBED, { 0xE9, 0xA2, 0xB1 },
	0xEBEE, { 0xE9, 0xA4, 0x83 },
	0xEBEF, { 0xE9, 0xA4, 0x85 },
	0xEBF0, { 0xE9, 0xA4, 0x8C },
	0xEBF1, { 0xE9, 0xA4, 0x89 },
	0xEBF2, { 0xE9, 0xA7, 0x81 },
	0xEBF3, { 0xE9, 0xAA, 0xAF },
	0xEBF4, { 0xE9, 0xAA, 0xB0 },
	0xEBF5, { 0xE9, 0xAB, 0xA6 },
	0xEBF6, { 0xE9, 0xAD, 0x81 },
	0xEBF7, { 0xE9, 0xAD, 0x82 },
	0xEBF8, { 0xE9, 0xB3, 0xB4 },
	0xEBF9, { 0xE9, 0xB3, 0xB6 },
	0xEBFA, { 0xE9, 0xB3, 0xB3 },
	0xEBFB, { 0xE9, 0xBA, 0xBC },
	0xEBFC, { 0xE9, 0xBC, 0xBB },
	0xEBFD, { 0xE9, 0xBD, 0x8A },
	0xEBFE, { 0xE5, 0x84, 0x84 },
	0xECA1, { 0xE5, 0x84, 0x80 },
	0xECA2, { 0xE5, 0x83, 0xBB },
	0xECA3, { 0xE5, 0x83, 0xB5 },
	0xECA4, { 0xE5, 0x83, 0xB9 },
	0xECA5, { 0xE5, 0x84, 0x82 },
	0xECA6, { 0xE5, 0x84, 0x88 },
	0xECA7, { 0xE5, 0x84, 0x89 },
	0xECA8, { 0xE5, 0x84, 0x85 },
	0xECA9, { 0xE5, 0x87, 0x9C },
	0xECAA, { 0xE5, 0x8A, 0x87 },
	0xECAB, { 0xE5, 0x8A, 0x88 },
	0xECAC, { 0xE5, 0x8A, 0x89 },
	0xECAD, { 0xE5, 0x8A, 0x8D },
	0xECAE, { 0xE5, 0x8A, 0x8A },
	0xECAF, { 0xE5, 0x8B, 0xB0 },
	0xECB0, { 0xE5, 0x8E, 0xB2 },
	0xECB1, { 0xE5, 0x98, 0xAE },
	0xECB2, { 0xE5, 0x98, 0xBB },
	0xECB3, { 0xE5, 0x98, 0xB9 },
	0xECB4, { 0xE5, 0x98, 0xB2 },
	0xECB5, { 0xE5, 0x98, 0xBF },
	0xECB6, { 0xE5, 0x98, 0xB4 },
	0xECB7, { 0xE5, 0x98, 0xA9 },
	0xECB8, { 0xE5, 0x99, 0x93 },
	0xECB9, { 0xE5, 0x99, 0x8E },
	0xECBA, { 0xE5, 0x99, 0x97 },
	0xECBB, { 0xE5, 0x99, 0xB4 },
	0xECBC, { 0xE5, 0x98, 0xB6 },
	0xECBD, { 0xE5, 0x98, 0xAF },
	0xECBE, { 0xE5, 0x98, 0xB0 },
	0xECBF, { 0xE5, 0xA2, 0x80 },
	0xECC0, { 0xE5, 0xA2, 0x9F },
	0xECC1, { 0xE5, 0xA2, 0x9E },
	0xECC2, { 0xE5, 0xA2, 0xB3 },
	0xECC3, { 0xE5, 0xA2, 0x9C },
	0xECC4, { 0xE5, 0xA2, 0xAE },
	0xECC5, { 0xE5, 0xA2, 0xA9 },
	0xECC6, { 0xE5, 0xA2, 0xA6 },
	0xECC7, { 0xE5, 0xA5, 0xAD },
	0xECC8, { 0xE5, 0xAC, 0x89 },
	0xECC9, { 0xE5, 0xAB, 0xBB },
	0xECCA, { 0xE5, 0xAC, 0x8B },
	0xECCB, { 0xE5, 0xAB, 0xB5 },
	0xECCC, { 0xE5, 0xAC, 0x8C },
	0xECCD, { 0xE5, 0xAC, 0x88 },
	0xECCE, { 0xE5, 0xAF, 0xAE },
	0xECCF, { 0xE5, 0xAF, 0xAC },
	0xECD0, { 0xE5, 0xAF, 0xA9 },
	0xECD1, { 0xE5, 0xAF, 0xAB },
	0xECD2, { 0xE5, 0xB1, 0xA4 },
	0xECD3, { 0xE5, 0xB1, 0xA5 },
	0xECD4, { 0xE5, 0xB6, 0x9D },
	0xECD5, { 0xE5, 0xB6, 0x94 },
	0xECD6, { 0xE5, 0xB9, 0xA2 },
	0xECD7, { 0xE5, 0xB9, 0x9F },
	0xECD8, { 0xE5, 0xB9, 0xA1 },
	0xECD9, { 0xE5, 0xBB, 0xA2 },
	0xECDA, { 0xE5, 0xBB, 0x9A },
	0xECDB, { 0xE5, 0xBB, 0x9F },
	0xECDC, { 0xE5, 0xBB, 0x9D },
	0xECDD, { 0xE5, 0xBB, 0xA3 },
	0xECDE, { 0xE5, 0xBB, 0xA0 },
	0xECDF, { 0xE5, 0xBD, 0x88 },
	0xECE0, { 0xE5, 0xBD, 0xB1 },
	0xECE1, { 0xE5, 0xBE, 0xB7 },
	0xECE2, { 0xE5, 0xBE, 0xB5 },
	0xECE3, { 0xE6, 0x85, 0xB6 },
	0xECE4, { 0xE6, 0x85, 0xA7 },
	0xECE5, { 0xE6, 0x85, 0xAE },
	0xECE6, { 0xE6, 0x85, 0x9D },
	0xECE7, { 0xE6, 0x85, 0x95 },
	0xECE8, { 0xE6, 0x86, 0x82 },
	0xECE9, { 0xE6, 0x85, 0xBC },
	0xECEA, { 0xE6, 0x85, 0xB0 },
	0xECEB, { 0xE6, 0x85, 0xAB },
	0xECEC, { 0xE6, 0x85, 0xBE },
	0xECED, { 0xE6, 0x86, 0xA7 },
	0xECEE, { 0xE6, 0x86, 0x90 },
	0xECEF, { 0xE6, 0x86, 0xAB },
	0xECF0, { 0xE6, 0x86, 0x8E },
	0xECF1, { 0xE6, 0x86, 0xAC },
	0xECF2, { 0xE6, 0x86, 0x9A },
	0xECF3, { 0xE6, 0x86, 0xA4 },
	0xECF4, { 0xE6, 0x86, 0x94 },
	0xECF5, { 0xE6, 0x86, 0xAE },
	0xECF6, { 0xE6, 0x88, 0xAE },
	0xECF7, { 0xE6, 0x91, 0xA9 },
	0xECF8, { 0xE6, 0x91, 0xAF },
	0xECF9, { 0xE6, 0x91, 0xB9 },
	0xECFA, { 0xE6, 0x92, 0x9E },
	0xECFB, { 0xE6, 0x92, 0xB2 },
	0xECFC, { 0xE6, 0x92, 0x88 },
	0xECFD, { 0xE6, 0x92, 0x90 },
	0xECFE, { 0xE6, 0x92, 0xB0 },
	0xEDA1, { 0xE6, 0x92, 0xA5 },
	0xEDA2, { 0xE6, 0x92, 0x93 },
	0xEDA3, { 0xE6, 0x92, 0x95 },
	0xEDA4, { 0xE6, 0x92, 0xA9 },
	0xEDA5, { 0xE6, 0x92, 0x92 },
	0xEDA6, { 0xE6, 0x92, 0xAE },
	0xEDA7, { 0xE6, 0x92, 0xAD },
	0xEDA8, { 0xE6, 0x92, 0xAB },
	0xEDA9, { 0xE6, 0x92, 0x9A },
	0xEDAA, { 0xE6, 0x92, 0xAC },
	0xEDAB, { 0xE6, 0x92, 0x99 },
	0xEDAC, { 0xE6, 0x92, 0xA2 },
	0xEDAD, { 0xE6, 0x92, 0xB3 },
	0xEDAE, { 0xE6, 0x95, 0xB5 },
	0xEDAF, { 0xE6, 0x95, 0xB7 },
	0xEDB0, { 0xE6, 0x95, 0xB8 },
	0xEDB1, { 0xE6, 0x9A, 0xAE },
	0xEDB2, { 0xE6, 0x9A, 0xAB },
	0xEDB3, { 0xE6, 0x9A, 0xB4 },
	0xEDB4, { 0xE6, 0x9A, 0xB1 },
	0xEDB5, { 0xE6, 0xA8, 0xA3 },
	0xEDB6, { 0xE6, 0xA8, 0x9F },
	0xEDB7, { 0xE6, 0xA7, 0xA8 },
	0xEDB8, { 0xE6, 0xA8, 0x81 },
	0xEDB9, { 0xE6, 0xA8, 0x9E },
	0xEDBA, { 0xE6, 0xA8, 0x99 },
	0xEDBB, { 0xE6, 0xA7, 0xBD },
	0xEDBC, { 0xE6, 0xA8, 0xA1 },
	0xEDBD, { 0xE6, 0xA8, 0x93 },
	0xEDBE, { 0xE6, 0xA8, 0x8A },
	0xEDBF, { 0xE6, 0xA7, 0xB3 },
	0xEDC0, { 0xE6, 0xA8, 0x82 },
	0xEDC1, { 0xE6, 0xA8, 0x85 },
	0xEDC2, { 0xE6, 0xA7, 0xAD },
	0xEDC3, { 0xE6, 0xA8, 0x91 },
	0xEDC4, { 0xE6, 0xAD, 0x90 },
	0xEDC5, { 0xE6, 0xAD, 0x8E },
	0xEDC6, { 0xE6, 0xAE, 0xA4 },
	0xEDC7, { 0xE6, 0xAF, 0x85 },
	0xEDC8, { 0xE6, 0xAF, 0x86 },
	0xEDC9, { 0xE6, 0xBC, 0xBF },
	0xEDCA, { 0xE6, 0xBD, 0xBC },
	0xEDCB, { 0xE6, 0xBE, 0x84 },
	0xEDCC, { 0xE6, 0xBD, 0x91 },
	0xEDCD, { 0xE6, 0xBD, 0xA6 },
	0xEDCE, { 0xE6, 0xBD, 0x94 },
	0xEDCF, { 0xE6, 0xBE, 0x86 },
	0xEDD0, { 0xE6, 0xBD, 0xAD },
	0xEDD1, { 0xE6, 0xBD, 0x9B },
	0xEDD2, { 0xE6, 0xBD, 0xB8 },
	0xEDD3, { 0xE6, 0xBD, 0xAE },
	0xEDD4, { 0xE6, 0xBE, 0x8E },
	0xEDD5, { 0xE6, 0xBD, 0xBA },
	0xEDD6, { 0xE6, 0xBD, 0xB0 },
	0xEDD7, { 0xE6, 0xBD, 0xA4 },
	0xEDD8, { 0xE6, 0xBE, 0x97 },
	0xEDD9, { 0xE6, 0xBD, 0x98 },
	0xEDDA, { 0xE6, 0xBB, 0x95 },
	0xEDDB, { 0xE6, 0xBD, 0xAF },
	0xEDDC, { 0xE6, 0xBD, 0xA0 },
	0xEDDD, { 0xE6, 0xBD, 0x9F },
	0xEDDE, { 0xE7, 0x86, 0x9F },
	0xEDDF, { 0xE7, 0x86, 0xAC },
	0xEDE0, { 0xE7, 0x86, 0xB1 },
	0xEDE1, { 0xE7, 0x86, 0xA8 },
	0xEDE2, { 0xE7, 0x89, 0x96 },
	0xEDE3, { 0xE7, 0x8A, 0x9B },
	0xEDE4, { 0xE7, 0x8D, 0x8E },
	0xEDE5, { 0xE7, 0x8D, 0x97 },
	0xEDE6, { 0xE7, 0x91, 0xA9 },
	0xEDE7, { 0xE7, 0x92, 0x8B },
	0xEDE8, { 0xE7, 0x92, 0x83 },
	0xEDE9, { 0xE7, 0x91, 0xBE },
	0xEDEA, { 0xE7, 0x92, 0x80 },
	0xEDEB, { 0xE7, 0x95, 0xBF },
	0xEDEC, { 0xE7, 0x98, 0xA0 },
	0xEDED, { 0xE7, 0x98, 0xA9 },
	0xEDEE, { 0xE7, 0x98, 0x9F },
	0xEDEF, { 0xE7, 0x98, 0xA4 },
	0xEDF0, { 0xE7, 0x98, 0xA6 },
	0xEDF1, { 0xE7, 0x98, 0xA1 },
	0xEDF2, { 0xE7, 0x98, 0xA2 },
	0xEDF3, { 0xE7, 0x9A, 0x9A },
	0xEDF4, { 0xE7, 0x9A, 0xBA },
	0xEDF5, { 0xE7, 0x9B, 0xA4 },
	0xEDF6, { 0xE7, 0x9E, 0x8E },
	0xEDF7, { 0xE7, 0x9E, 0x87 },
	0xEDF8, { 0xE7, 0x9E, 0x8C },
	0xEDF9, { 0xE7, 0x9E, 0x91 },
	0xEDFA, { 0xE7, 0x9E, 0x8B },
	0xEDFB, { 0xE7, 0xA3, 0x8B },
	0xEDFC, { 0xE7, 0xA3, 0x85 },
	0xEDFD, { 0xE7, 0xA2, 0xBA },
	0xEDFE, { 0xE7, 0xA3, 0x8A },
	0xEEA1, { 0xE7, 0xA2, 0xBE },
	0xEEA2, { 0xE7, 0xA3, 0x95 },
	0xEEA3, { 0xE7, 0xA2, 0xBC },
	0xEEA4, { 0xE7, 0xA3, 0x90 },
	0xEEA5, { 0xE7, 0xA8, 0xBF },
	0xEEA6, { 0xE7, 0xA8, 0xBC },
	0xEEA7, { 0xE7, 0xA9, 0x80 },
	0xEEA8, { 0xE7, 0xA8, 0xBD },
	0xEEA9, { 0xE7, 0xA8, 0xB7 },
	0xEEAA, { 0xE7, 0xA8, 0xBB },
	0xEEAB, { 0xE7, 0xAA, 0xAF },
	0xEEAC, { 0xE7, 0xAA, 0xAE },
	0xEEAD, { 0xE7, 0xAE, 0xAD },
	0xEEAE, { 0xE7, 0xAE, 0xB1 },
	0xEEAF, { 0xE7, 0xAF, 0x84 },
	0xEEB0, { 0xE7, 0xAE, 0xB4 },
	0xEEB1, { 0xE7, 0xAF, 0x86 },
	0xEEB2, { 0xE7, 0xAF, 0x87 },
	0xEEB3, { 0xE7, 0xAF, 0x81 },
	0xEEB4, { 0xE7, 0xAE, 0xA0 },
	0xEEB5, { 0xE7, 0xAF, 0x8C },
	0xEEB6, { 0xE7, 0xB3, 0x8A },
	0xEEB7, { 0xE7, 0xB7, 0xA0 },
	0xEEB8, { 0xE7, 0xB7, 0xB4 },
	0xEEB9, { 0xE7, 0xB7, 0xAF },
	0xEEBA, { 0xE7, 0xB7, 0xBB },
	0xEEBB, { 0xE7, 0xB7, 0x98 },
	0xEEBC, { 0xE7, 0xB7, 0xAC },
	0xEEBD, { 0xE7, 0xB7, 0x9D },
	0xEEBE, { 0xE7, 0xB7, 0xA8 },
	0xEEBF, { 0xE7, 0xB7, 0xA3 },
	0xEEC0, { 0xE7, 0xB7, 0x9A },
	0xEEC1, { 0xE7, 0xB7, 0x9E },
	0xEEC2, { 0xE7, 0xB7, 0xA9 },
	0xEEC3, { 0xE7, 0xB6, 0x9E },
	0xEEC4, { 0xE7, 0xB7, 0x99 },
	0xEEC5, { 0xE7, 0xB7, 0xB2 },
	0xEEC6, { 0xE7, 0xB7, 0xB9 },
	0xEEC7, { 0xE7, 0xBD, 0xB5 },
	0xEEC8, { 0xE7, 0xBD, 0xB7 },
	0xEEC9, { 0xE7, 0xBE, 0xAF },
	0xEECA, { 0xE7, 0xBF, 0xA9 },
	0xEECB, { 0xE8, 0x80, 0xA6 },
	0xEECC, { 0xE8, 0x86, 0x9B },
	0xEECD, { 0xE8, 0x86, 0x9C },
	0xEECE, { 0xE8, 0x86, 0x9D },
	0xEECF, { 0xE8, 0x86, 0xA0 },
	0xEED0, { 0xE8, 0x86, 0x9A },
	0xEED1, { 0xE8, 0x86, 0x98 },
	0xEED2, { 0xE8, 0x94, 0x97 },
	0xEED3, { 0xE8, 0x94, 0xBD },
	0xEED4, { 0xE8, 0x94, 0x9A },
	0xEED5, { 0xE8, 0x93, 0xAE },
	0xEED6, { 0xE8, 0x94, 0xAC },
	0xEED7, { 0xE8, 0x94, 0xAD },
	0xEED8, { 0xE8, 0x94, 0x93 },
	0xEED9, { 0xE8, 0x94, 0x91 },
	0xEEDA, { 0xE8, 0x94, 0xA3 },
	0xEEDB, { 0xE8, 0x94, 0xA1 },
	0xEEDC, { 0xE8, 0x94, 0x94 },
	0xEEDD, { 0xE8, 0x93, 0xAC },
	0xEEDE, { 0xE8, 0x94, 0xA5 },
	0xEEDF, { 0xE8, 0x93, 0xBF },
	0xEEE0, { 0xE8, 0x94, 0x86 },
	0xEEE1, { 0xE8, 0x9E, 0x82 },
	0xEEE2, { 0xE8, 0x9D, 0xB4 },
	0xEEE3, { 0xE8, 0x9D, 0xB6 },
	0xEEE4, { 0xE8, 0x9D, 0xA0 },
	0xEEE5, { 0xE8, 0x9D, 0xA6 },
	0xEEE6, { 0xE8, 0x9D, 0xB8 },
	0xEEE7, { 0xE8, 0x9D, 0xA8 },
	0xEEE8, { 0xE8, 0x9D, 0x99 },
	0xEEE9, { 0xE8, 0x9D, 0x97 },
	0xEEEA, { 0xE8, 0x9D, 0x8C },
	0xEEEB, { 0xE8, 0x9D, 0x93 },
	0xEEEC, { 0xE8, 0xA1, 0x9B },
	0xEEED, { 0xE8, 0xA1, 0x9D },
	0xEEEE, { 0xE8, 0xA4, 0x90 },
	0xEEEF, { 0xE8, 0xA4, 0x87 },
	0xEEF0, { 0xE8, 0xA4, 0x92 },
	0xEEF1, { 0xE8, 0xA4, 0x93 },
	0xEEF2, { 0xE8, 0xA4, 0x95 },
	0xEEF3, { 0xE8, 0xA4, 0x8A },
	0xEEF4, { 0xE8, 0xAA, 0xBC },
	0xEEF5, { 0xE8, 0xAB, 0x92 },
	0xEEF6, { 0xE8, 0xAB, 0x87 },
	0xEEF7, { 0xE8, 0xAB, 0x84 },
	0xEEF8, { 0xE8, 0xAA, 0x95 },
	0xEEF9, { 0xE8, 0xAB, 0x8B },
	0xEEFA, { 0xE8, 0xAB, 0xB8 },
	0xEEFB, { 0xE8, 0xAA, 0xB2 },
	0xEEFC, { 0xE8, 0xAB, 0x89 },
	0xEEFD, { 0xE8, 0xAB, 0x82 },
	0xEEFE, { 0xE8, 0xAA, 0xBF },
	0xEFA1, { 0xE8, 0xAA, 0xB0 },
	0xEFA2, { 0xE8, 0xAB, 0x96 },
	0xEFA3, { 0xE8, 0xAB, 0x8D },
	0xEFA4, { 0xE8, 0xAA, 0xB6 },
	0xEFA5, { 0xE8, 0xAA, 0xB9 },
	0xEFA6, { 0xE8, 0xAB, 0x9B },
	0xEFA7, { 0xE8, 0xB1, 0x8C },
	0xEFA8, { 0xE8, 0xB1, 0x8E },
	0xEFA9, { 0xE8, 0xB1, 0xAC },
	0xEFAA, { 0xE8, 0xB3, 0xA0 },
	0xEFAB, { 0xE8, 0xB3, 0x9E },
	0xEFAC, { 0xE8, 0xB3, 0xA6 },
	0xEFAD, { 0xE8, 0xB3, 0xA4 },
	0xEFAE, { 0xE8, 0xB3, 0xAC },
	0xEFAF, { 0xE8, 0xB3, 0xAD },
	0xEFB0, { 0xE8, 0xB3, 0xA2 },
	0xEFB1, { 0xE8, 0xB3, 0xA3 },
	0xEFB2, { 0xE8, 0xB3, 0x9C },
	0xEFB3, { 0xE8, 0xB3, 0xAA },
	0xEFB4, { 0xE8, 0xB3, 0xA1 },
	0xEFB5, { 0xE8, 0xB5, 0xAD },
	0xEFB6, { 0xE8, 0xB6, 0x9F },
	0xEFB7, { 0xE8, 0xB6, 0xA3 },
	0xEFB8, { 0xE8, 0xB8, 0xAB },
	0xEFB9, { 0xE8, 0xB8, 0x90 },
	0xEFBA, { 0xE8, 0xB8, 0x9D },
	0xEFBB, { 0xE8, 0xB8, 0xA2 },
	0xEFBC, { 0xE8, 0xB8, 0x8F },
	0xEFBD, { 0xE8, 0xB8, 0xA9 },
	0xEFBE, { 0xE8, 0xB8, 0x9F },
	0xEFBF, { 0xE8, 0xB8, 0xA1 },
	0xEFC0, { 0xE8, 0xB8, 0x9E },
	0xEFC1, { 0xE8, 0xBA, 0xBA },
	0xEFC2, { 0xE8, 0xBC, 0x9D },
	0xEFC3, { 0xE8, 0xBC, 0x9B },
	0xEFC4, { 0xE8, 0xBC, 0x9F },
	0xEFC5, { 0xE8, 0xBC, 0xA9 },
	0xEFC6, { 0xE8, 0xBC, 0xA6 },
	0xEFC7, { 0xE8, 0xBC, 0xAA },
	0xEFC8, { 0xE8, 0xBC, 0x9C },
	0xEFC9, { 0xE8, 0xBC, 0x9E },
	0xEFCA, { 0xE8, 0xBC, 0xA5 },
	0xEFCB, { 0xE9, 0x81, 0xA9 },
	0xEFCC, { 0xE9, 0x81, 0xAE },
	0xEFCD, { 0xE9, 0x81, 0xA8 },
	0xEFCE, { 0xE9, 0x81, 0xAD },
	0xEFCF, { 0xE9, 0x81, 0xB7 },
	0xEFD0, { 0xE9, 0x84, 0xB0 },
	0xEFD1, { 0xE9, 0x84, 0xAD },
	0xEFD2, { 0xE9, 0x84, 0xA7 },
	0xEFD3, { 0xE9, 0x84, 0xB1 },
	0xEFD4, { 0xE9, 0x86, 0x87 },
	0xEFD5, { 0xE9, 0x86, 0x89 },
	0xEFD6, { 0xE9, 0x86, 0x8B },
	0xEFD7, { 0xE9, 0x86, 0x83 },
	0xEFD8, { 0xE9, 0x8B, 0x85 },
	0xEFD9, { 0xE9, 0x8A, 0xBB },
	0xEFDA, { 0xE9, 0x8A, 0xB7 },
	0xEFDB, { 0xE9, 0x8B, 0xAA },
	0xEFDC, { 0xE9, 0x8B, 0xA4 },
	0xEFDD, { 0xE9, 0x8B, 0x81 },
	0xEFDE, { 0xE9, 0x8A, 0xB3 },
	0xEFDF, { 0xE9, 0x8A, 0xBC },
	0xEFE0, { 0xE9, 0x8B, 0x92 },
	0xEFE1, { 0xE9, 0x8B, 0x87 },
	0xEFE2, { 0xE9, 0x8B, 0xB0 },
	0xEFE3, { 0xE9, 0x8A, 0xB2 },
	0xEFE4, { 0xE9, 0x96, 0xAD },
	0xEFE5, { 0xE9, 0x96, 0xB1 },
	0xEFE6, { 0xE9, 0x9C, 0x84 },
	0xEFE7, { 0xE9, 0x9C, 0x86 },
	0xEFE8, { 0xE9, 0x9C, 0x87 },
	0xEFE9, { 0xE9, 0x9C, 0x89 },
	0xEFEA, { 0xE9, 0x9D, 0xA0 },
	0xEFEB, { 0xE9, 0x9E, 0x8D },
	0xEFEC, { 0xE9, 0x9E, 0x8B },
	0xEFED, { 0xE9, 0x9E, 0x8F },
	0xEFEE, { 0xE9, 0xA0, 0xA1 },
	0xEFEF, { 0xE9, 0xA0, 0xAB },
	0xEFF0, { 0xE9, 0xA0, 0x9C },
	0xEFF1, { 0xE9, 0xA2, 0xB3 },
	0xEFF2, { 0xE9, 0xA4, 0x8A },
	0xEFF3, { 0xE9, 0xA4, 0x93 },
	0xEFF4, { 0xE9, 0xA4, 0x92 },
	0xEFF5, { 0xE9, 0xA4, 0x98 },
	0xEFF6, { 0xE9, 0xA7, 0x9D },
	0xEFF7, { 0xE9, 0xA7, 0x90 },
	0xEFF8, { 0xE9, 0xA7, 0x9F },
	0xEFF9, { 0xE9, 0xA7, 0x9B },
	0xEFFA, { 0xE9, 0xA7, 0x91 },
	0xEFFB, { 0xE9, 0xA7, 0x95 },
	0xEFFC, { 0xE9, 0xA7, 0x92 },
	0xEFFD, { 0xE9, 0xA7, 0x99 },
	0xEFFE, { 0xE9, 0xAA, 0xB7 },
	0xF0A1, { 0xE9, 0xAB, 0xAE },
	0xF0A2, { 0xE9, 0xAB, 0xAF },
	0xF0A3, { 0xE9, 0xAC, 0xA7 },
	0xF0A4, { 0xE9, 0xAD, 0x85 },
	0xF0A5, { 0xE9, 0xAD, 0x84 },
	0xF0A6, { 0xE9, 0xAD, 0xB7 },
	0xF0A7, { 0xE9, 0xAD, 0xAF },
	0xF0A8, { 0xE9, 0xB4, 0x86 },
	0xF0A9, { 0xE9, 0xB4, 0x89 },
	0xF0AA, { 0xE9, 0xB4, 0x83 },
	0xF0AB, { 0xE9, 0xBA, 0xA9 },
	0xF0AC, { 0xE9, 0xBA, 0xBE },
	0xF0AD, { 0xE9, 0xBB, 0x8E },
	0xF0AE, { 0xE5, 0xA2, 0xA8 },
	0xF0AF, { 0xE9, 0xBD, 0x92 },
	0xF0B0, { 0xE5, 0x84, 0x92 },
	0xF0B1, { 0xE5, 0x84, 0x98 },
	0xF0B2, { 0xE5, 0x84, 0x94 },
	0xF0B3, { 0xE5, 0x84, 0x90 },
	0xF0B4, { 0xE5, 0x84, 0x95 },
	0xF0B5, { 0xE5, 0x86, 0x80 },
	0xF0B6, { 0xE5, 0x86, 0xAA },
	0xF0B7, { 0xE5, 0x87, 0x9D },
	0xF0B8, { 0xE5, 0x8A, 0x91 },
	0xF0B9, { 0xE5, 0x8A, 0x93 },
	0xF0BA, { 0xE5, 0x8B, 0xB3 },
	0xF0BB, { 0xE5, 0x99, 0x99 },
	0xF0BC, { 0xE5, 0x99, 0xAB },
	0xF0BD, { 0xE5, 0x99, 0xB9 },
	0xF0BE, { 0xE5, 0x99, 0xA9 },
	0xF0BF, { 0xE5, 0x99, 0xA4 },
	0xF0C0, { 0xE5, 0x99, 0xB8 },
	0xF0C1, { 0xE5, 0x99, 0xAA },
	0xF0C2, { 0xE5, 0x99, 0xA8 },
	0xF0C3, { 0xE5, 0x99, 0xA5 },
	0xF0C4, { 0xE5, 0x99, 0xB1 },
	0xF0C5, { 0xE5, 0x99, 0xAF },
	0xF0C6, { 0xE5, 0x99, 0xAC },
	0xF0C7, { 0xE5, 0x99, 0xA2 },
	0xF0C8, { 0xE5, 0x99, 0xB6 },
	0xF0C9, { 0xE5, 0xA3, 0x81 },
	0xF0CA, { 0xE5, 0xA2, 0xBE },
	0xF0CB, { 0xE5, 0xA3, 0x87 },
	0xF0CC, { 0xE5, 0xA3, 0x85 },
	0xF0CD, { 0xE5, 0xA5, 0xAE },
	0xF0CE, { 0xE5, 0xAC, 0x9D },
	0xF0CF, { 0xE5, 0xAC, 0xB4 },
	0xF0D0, { 0xE5, 0xAD, 0xB8 },
	0xF0D1, { 0xE5, 0xAF, 0xB0 },
	0xF0D2, { 0xE5, 0xB0, 0x8E },
	0xF0D3, { 0xE5, 0xBD, 0x8A },
	0xF0D4, { 0xE6, 0x86, 0xB2 },
	0xF0D5, { 0xE6, 0x86, 0x91 },
	0xF0D6, { 0xE6, 0x86, 0xA9 },
	0xF0D7, { 0xE6, 0x86, 0x8A },
	0xF0D8, { 0xE6, 0x87, 0x8D },
	0xF0D9, { 0xE6, 0x86, 0xB6 },
	0xF0DA, { 0xE6, 0x86, 0xBE },
	0xF0DB, { 0xE6, 0x87, 0x8A },
	0xF0DC, { 0xE6, 0x87, 0x88 },
	0xF0DD, { 0xE6, 0x88, 0xB0 },
	0xF0DE, { 0xE6, 0x93, 0x85 },
	0xF0DF, { 0xE6, 0x93, 0x81 },
	0xF0E0, { 0xE6, 0x93, 0x8B },
	0xF0E1, { 0xE6, 0x92, 0xBB },
	0xF0E2, { 0xE6, 0x92, 0xBC },
	0xF0E3, { 0xE6, 0x93, 0x9A },
	0xF0E4, { 0xE6, 0x93, 0x84 },
	0xF0E5, { 0xE6, 0x93, 0x87 },
	0xF0E6, { 0xE6, 0x93, 0x82 },
	0xF0E7, { 0xE6, 0x93, 0x8D },
	0xF0E8, { 0xE6, 0x92, 0xBF },
	0xF0E9, { 0xE6, 0x93, 0x92 },
	0xF0EA, { 0xE6, 0x93, 0x94 },
	0xF0EB, { 0xE6, 0x92, 0xBE },
	0xF0EC, { 0xE6, 0x95, 0xB4 },
	0xF0ED, { 0xE6, 0x9B, 0x86 },
	0xF0EE, { 0xE6, 0x9B, 0x89 },
	0xF0EF, { 0xE6, 0x9A, 0xB9 },
	0xF0F0, { 0xE6, 0x9B, 0x84 },
	0xF0F1, { 0xE6, 0x9B, 0x87 },
	0xF0F2, { 0xE6, 0x9A, 0xB8 },
	0xF0F3, { 0xE6, 0xA8, 0xBD },
	0xF0F4, { 0xE6, 0xA8, 0xB8 },
	0xF0F5, { 0xE6, 0xA8, 0xBA },
	0xF0F6, { 0xE6, 0xA9, 0x99 },
	0xF0F7, { 0xE6, 0xA9, 0xAB },
	0xF0F8, { 0xE6, 0xA9, 0x98 },
	0xF0F9, { 0xE6, 0xA8, 0xB9 },
	0xF0FA, { 0xE6, 0xA9, 0x84 },
	0xF0FB, { 0xE6, 0xA9, 0xA2 },
	0xF0FC, { 0xE6, 0xA9, 0xA1 },
	0xF0FD, { 0xE6, 0xA9, 0x8B },
	0xF0FE, { 0xE6, 0xA9, 0x87 },
	0xF1A1, { 0xE6, 0xA8, 0xB5 },
	0xF1A2, { 0xE6, 0xA9, 0x9F },
	0xF1A3, { 0xE6, 0xA9, 0x88 },
	0xF1A4, { 0xE6, 0xAD, 0x99 },
	0xF1A5, { 0xE6, 0xAD, 0xB7 },
	0xF1A6, { 0xE6, 0xB0, 0x85 },
	0xF1A7, { 0xE6, 0xBF, 0x82 },
	0xF1A8, { 0xE6, 0xBE, 0xB1 },
	0xF1A9, { 0xE6, 0xBE, 0xA1 },
	0xF1AA, { 0xE6, 0xBF, 0x83 },
	0xF1AB, { 0xE6, 0xBE, 0xA4 },
	0xF1AC, { 0xE6, 0xBF, 0x81 },
	0xF1AD, { 0xE6, 0xBE, 0xA7 },
	0xF1AE, { 0xE6, 0xBE, 0xB3 },
	0xF1AF, { 0xE6, 0xBF, 0x80 },
	0xF1B0, { 0xE6, 0xBE, 0xB9 },
	0xF1B1, { 0xE6, 0xBE, 0xB6 },
	0xF1B2, { 0xE6, 0xBE, 0xA6 },
	0xF1B3, { 0xE6, 0xBE, 0xA0 },
	0xF1B4, { 0xE6, 0xBE, 0xB4 },
	0xF1B5, { 0xE7, 0x86, 0xBE },
	0xF1B6, { 0xE7, 0x87, 0x89 },
	0xF1B7, { 0xE7, 0x87, 0x90 },
	0xF1B8, { 0xE7, 0x87, 0x92 },
	0xF1B9, { 0xE7, 0x87, 0x88 },
	0xF1BA, { 0xE7, 0x87, 0x95 },
	0xF1BB, { 0xE7, 0x86, 0xB9 },
	0xF1BC, { 0xE7, 0x87, 0x8E },
	0xF1BD, { 0xE7, 0x87, 0x99 },
	0xF1BE, { 0xE7, 0x87, 0x9C },
	0xF1BF, { 0xE7, 0x87, 0x83 },
	0xF1C0, { 0xE7, 0x87, 0x84 },
	0xF1C1, { 0xE7, 0x8D, 0xA8 },
	0xF1C2, { 0xE7, 0x92, 0x9C },
	0xF1C3, { 0xE7, 0x92, 0xA3 },
	0xF1C4, { 0xE7, 0x92, 0x98 },
	0xF1C5, { 0xE7, 0x92, 0x9F },
	0xF1C6, { 0xE7, 0x92, 0x9E },
	0xF1C7, { 0xE7, 0x93, 0xA2 },
	0xF1C8, { 0xE7, 0x94, 0x8C },
	0xF1C9, { 0xE7, 0x94, 0x8D },
	0xF1CA, { 0xE7, 0x98, 0xB4 },
	0xF1CB, { 0xE7, 0x98, 0xB8 },
	0xF1CC, { 0xE7, 0x98, 0xBA },
	0xF1CD, { 0xE7, 0x9B, 0xA7 },
	0xF1CE, { 0xE7, 0x9B, 0xA5 },
	0xF1CF, { 0xE7, 0x9E, 0xA0 },
	0xF1D0, { 0xE7, 0x9E, 0x9E },
	0xF1D1, { 0xE7, 0x9E, 0x9F },
	0xF1D2, { 0xE7, 0x9E, 0xA5 },
	0xF1D3, { 0xE7, 0xA3, 0xA8 },
	0xF1D4, { 0xE7, 0xA3, 0x9A },
	0xF1D5, { 0xE7, 0xA3, 0xAC },
	0xF1D6, { 0xE7, 0xA3, 0xA7 },
	0xF1D7, { 0xE7, 0xA6, 0xA6 },
	0xF1D8, { 0xE7, 0xA9, 0x8D },
	0xF1D9, { 0xE7, 0xA9, 0x8E },
	0xF1DA, { 0xE7, 0xA9, 0x86 },
	0xF1DB, { 0xE7, 0xA9, 0x8C },
	0xF1DC, { 0xE7, 0xA9, 0x8B },
	0xF1DD, { 0xE7, 0xAA, 0xBA },
	0xF1DE, { 0xE7, 0xAF, 0x99 },
	0xF1DF, { 0xE7, 0xB0, 0x91 },
	0xF1E0, { 0xE7, 0xAF, 0x89 },
	0xF1E1, { 0xE7, 0xAF, 0xA4 },
	0xF1E2, { 0xE7, 0xAF, 0x9B },
	0xF1E3, { 0xE7, 0xAF, 0xA1 },
	0xF1E4, { 0xE7, 0xAF, 0xA9 },
	0xF1E5, { 0xE7, 0xAF, 0xA6 },
	0xF1E6, { 0xE7, 0xB3, 0x95 },
	0xF1E7, { 0xE7, 0xB3, 0x96 },
	0xF1E8, { 0xE7, 0xB8, 0x8A },
	0xF1E9, { 0xE7, 0xB8, 0x91 },
	0xF1EA, { 0xE7, 0xB8, 0x88 },
	0xF1EB, { 0xE7, 0xB8, 0x9B },
	0xF1EC, { 0xE7, 0xB8, 0xA3 },
	0xF1ED, { 0xE7, 0xB8, 0x9E },
	0xF1EE, { 0xE7, 0xB8, 0x9D },
	0xF1EF, { 0xE7, 0xB8, 0x89 },
	0xF1F0, { 0xE7, 0xB8, 0x90 },
	0xF1F1, { 0xE7, 0xBD, 0xB9 },
	0xF1F2, { 0xE7, 0xBE, 0xB2 },
	0xF1F3, { 0xE7, 0xBF, 0xB0 },
	0xF1F4, { 0xE7, 0xBF, 0xB1 },
	0xF1F5, { 0xE7, 0xBF, 0xAE },
	0xF1F6, { 0xE8, 0x80, 0xA8 },
	0xF1F7, { 0xE8, 0x86, 0xB3 },
	0xF1F8, { 0xE8, 0x86, 0xA9 },
	0xF1F9, { 0xE8, 0x86, 0xA8 },
	0xF1FA, { 0xE8, 0x87, 0xBB },
	0xF1FB, { 0xE8, 0x88, 0x88 },
	0xF1FC, { 0xE8, 0x89, 0x98 },
	0xF1FD, { 0xE8, 0x89, 0x99 },
	0xF1FE, { 0xE8, 0x95, 0x8A },
	0xF2A1, { 0xE8, 0x95, 0x99 },
	0xF2A2, { 0xE8, 0x95, 0x88 },
	0xF2A3, { 0xE8, 0x95, 0xA8 },
	0xF2A4, { 0xE8, 0x95, 0xA9 },
	0xF2A5, { 0xE8, 0x95, 0x83 },
	0xF2A6, { 0xE8, 0x95, 0x89 },
	0xF2A7, { 0xE8, 0x95, 0xAD },
	0xF2A8, { 0xE8, 0x95, 0xAA },
	0xF2A9, { 0xE8, 0x95, 0x9E },
	0xF2AA, { 0xE8, 0x9E, 0x83 },
	0xF2AB, { 0xE8, 0x9E, 0x9F },
	0xF2AC, { 0xE8, 0x9E, 0x9E },
	0xF2AD, { 0xE8, 0x9E, 0xA2 },
	0xF2AE, { 0xE8, 0x9E, 0x8D },
	0xF2AF, { 0xE8, 0xA1, 0xA1 },
	0xF2B0, { 0xE8, 0xA4, 0xAA },
	0xF2B1, { 0xE8, 0xA4, 0xB2 },
	0xF2B2, { 0xE8, 0xA4, 0xA5 },
	0xF2B3, { 0xE8, 0xA4, 0xAB },
	0xF2B4, { 0xE8, 0xA4, 0xA1 },
	0xF2B5, { 0xE8, 0xA6, 0xAA },
	0xF2B6, { 0xE8, 0xA6, 0xA6 },
	0xF2B7, { 0xE8, 0xAB, 0xA6 },
	0xF2B8, { 0xE8, 0xAB, 0xBA },
	0xF2B9, { 0xE8, 0xAB, 0xAB },
	0xF2BA, { 0xE8, 0xAB, 0xB1 },
	0xF2BB, { 0xE8, 0xAC, 0x80 },
	0xF2BC, { 0xE8, 0xAB, 0x9C },
	0xF2BD, { 0xE8, 0xAB, 0xA7 },
	0xF2BE, { 0xE8, 0xAB, 0xAE },
	0xF2BF, { 0xE8, 0xAB, 0xBE },
	0xF2C0, { 0xE8, 0xAC, 0x81 },
	0xF2C1, { 0xE8, 0xAC, 0x82 },
	0xF2C2, { 0xE8, 0xAB, 0xB7 },
	0xF2C3, { 0xE8, 0xAB, 0xAD },
	0xF2C4, { 0xE8, 0xAB, 0xB3 },
	0xF2C5, { 0xE8, 0xAB, 0xB6 },
	0xF2C6, { 0xE8, 0xAB, 0xBC },
	0xF2C7, { 0xE8, 0xB1, 0xAB },
	0xF2C8, { 0xE8, 0xB1, 0xAD },
	0xF2C9, { 0xE8, 0xB2, 0x93 },
	0xF2CA, { 0xE8, 0xB3, 0xB4 },
	0xF2CB, { 0xE8, 0xB9, 0x84 },
	0xF2CC, { 0xE8, 0xB8, 0xB1 },
	0xF2CD, { 0xE8, 0xB8, 0xB4 },
	0xF2CE, { 0xE8, 0xB9, 0x82 },
	0xF2CF, { 0xE8, 0xB8, 0xB9 },
	0xF2D0, { 0xE8, 0xB8, 0xB5 },
	0xF2D1, { 0xE8, 0xBC, 0xBB },
	0xF2D2, { 0xE8, 0xBC, 0xAF },
	0xF2D3, { 0xE8, 0xBC, 0xB8 },
	0xF2D4, { 0xE8, 0xBC, 0xB3 },
	0xF2D5, { 0xE8, 0xBE, 0xA8 },
	0xF2D6, { 0xE8, 0xBE, 0xA6 },
	0xF2D7, { 0xE9, 0x81, 0xB5 },
	0xF2D8, { 0xE9, 0x81, 0xB4 },
	0xF2D9, { 0xE9, 0x81, 0xB8 },
	0xF2DA, { 0xE9, 0x81, 0xB2 },
	0xF2DB, { 0xE9, 0x81, 0xBC },
	0xF2DC, { 0xE9, 0x81, 0xBA },
	0xF2DD, { 0xE9, 0x84, 0xB4 },
	0xF2DE, { 0xE9, 0x86, 0x92 },
	0xF2DF, { 0xE9, 0x8C, 0xA0 },
	0xF2E0, { 0xE9, 0x8C, 0xB6 },
	0xF2E1, { 0xE9, 0x8B, 0xB8 },
	0xF2E2, { 0xE9, 0x8C, 0xB3 },
	0xF2E3, { 0xE9, 0x8C, 0xAF },
	0xF2E4, { 0xE9, 0x8C, 0xA2 },
	0xF2E5, { 0xE9, 0x8B, 0xBC },
	0xF2E6, { 0xE9, 0x8C, 0xAB },
	0xF2E7, { 0xE9, 0x8C, 0x84 },
	0xF2E8, { 0xE9, 0x8C, 0x9A },
	0xF2E9, { 0xE9, 0x8C, 0x90 },
	0xF2EA, { 0xE9, 0x8C, 0xA6 },
	0xF2EB, { 0xE9, 0x8C, 0xA1 },
	0xF2EC, { 0xE9, 0x8C, 0x95 },
	0xF2ED, { 0xE9, 0x8C, 0xAE },
	0xF2EE, { 0xE9, 0x8C, 0x99 },
	0xF2EF, { 0xE9, 0x96, 0xBB },
	0xF2F0, { 0xE9, 0x9A, 0xA7 },
	0xF2F1, { 0xE9, 0x9A, 0xA8 },
	0xF2F2, { 0xE9, 0x9A, 0xAA },
	0xF2F3, { 0xE9, 0x9B, 0x95 },
	0xF2F4, { 0xE9, 0x9C, 0x8E },
	0xF2F5, { 0xE9, 0x9C, 0x91 },
	0xF2F6, { 0xE9, 0x9C, 0x96 },
	0xF2F7, { 0xE9, 0x9C, 0x8D },
	0xF2F8, { 0xE9, 0x9C, 0x93 },
	0xF2F9, { 0xE9, 0x9C, 0x8F },
	0xF2FA, { 0xE9, 0x9D, 0x9B },
	0xF2FB, { 0xE9, 0x9D, 0x9C },
	0xF2FC, { 0xE9, 0x9D, 0xA6 },
	0xF2FD, { 0xE9, 0x9E, 0x98 },
	0xF2FE, { 0xE9, 0xA0, 0xB0 },
	0xF3A1, { 0xE9, 0xA0, 0xB8 },
	0xF3A2, { 0xE9, 0xA0, 0xBB },
	0xF3A3, { 0xE9, 0xA0, 0xB7 },
	0xF3A4, { 0xE9, 0xA0, 0xAD },
	0xF3A5, { 0xE9, 0xA0, 0xB9 },
	0xF3A6, { 0xE9, 0xA0, 0xA4 },
	0xF3A7, { 0xE9, 0xA4, 0x90 },
	0xF3A8, { 0xE9, 0xA4, 0xA8 },
	0xF3A9, { 0xE9, 0xA4, 0x9E },
	0xF3AA, { 0xE9, 0xA4, 0x9B },
	0xF3AB, { 0xE9, 0xA4, 0xA1 },
	0xF3AC, { 0xE9, 0xA4, 0x9A },
	0xF3AD, { 0xE9, 0xA7, 0xAD },
	0xF3AE, { 0xE9, 0xA7, 0xA2 },
	0xF3AF, { 0xE9, 0xA7, 0xB1 },
	0xF3B0, { 0xE9, 0xAA, 0xB8 },
	0xF3B1, { 0xE9, 0xAA, 0xBC },
	0xF3B2, { 0xE9, 0xAB, 0xBB },
	0xF3B3, { 0xE9, 0xAB, 0xAD },
	0xF3B4, { 0xE9, 0xAC, 0xA8 },
	0xF3B5, { 0xE9, 0xAE, 0x91 },
	0xF3B6, { 0xE9, 0xB4, 0x95 },
	0xF3B7, { 0xE9, 0xB4, 0xA3 },
	0xF3B8, { 0xE9, 0xB4, 0xA6 },
	0xF3B9, { 0xE9, 0xB4, 0xA8 },
	0xF3BA, { 0xE9, 0xB4, 0x92 },
	0xF3BB, { 0xE9, 0xB4, 0x9B },
	0xF3BC, { 0xE9, 0xBB, 0x98 },
	0xF3BD, { 0xE9, 0xBB, 0x94 },
	0xF3BE, { 0xE9, 0xBE, 0x8D },
	0xF3BF, { 0xE9, 0xBE, 0x9C },
	0xF3C0, { 0xE5, 0x84, 0xAA },
	0xF3C1, { 0xE5, 0x84, 0x9F },
	0xF3C2, { 0xE5, 0x84, 0xA1 },
	0xF3C3, { 0xE5, 0x84, 0xB2 },
	0xF3C4, { 0xE5, 0x8B, 0xB5 },
	0xF3C5, { 0xE5, 0x9A, 0x8E },
	0xF3C6, { 0xE5, 0x9A, 0x80 },
	0xF3C7, { 0xE5, 0x9A, 0x90 },
	0xF3C8, { 0xE5, 0x9A, 0x85 },
	0xF3C9, { 0xE5, 0x9A, 0x87 },
	0xF3CA, { 0xE5, 0x9A, 0x8F },
	0xF3CB, { 0xE5, 0xA3, 0x95 },
	0xF3CC, { 0xE5, 0xA3, 0x93 },
	0xF3CD, { 0xE5, 0xA3, 0x91 },
	0xF3CE, { 0xE5, 0xA3, 0x8E },
	0xF3CF, { 0xE5, 0xAC, 0xB0 },
	0xF3D0, { 0xE5, 0xAC, 0xAA },
	0xF3D1, { 0xE5, 0xAC, 0xA4 },
	0xF3D2, { 0xE5, 0xAD, 0xBA },
	0xF3D3, { 0xE5, 0xB0, 0xB7 },
	0xF3D4, { 0xE5, 0xB1, 0xA8 },
	0xF3D5, { 0xE5, 0xB6, 0xBC },
	0xF3D6, { 0xE5, 0xB6, 0xBA },
	0xF3D7, { 0xE5, 0xB6, 0xBD },
	0xF3D8, { 0xE5, 0xB6, 0xB8 },
	0xF3D9, { 0xE5, 0xB9, 0xAB },
	0xF3DA, { 0xE5, 0xBD, 0x8C },
	0xF3DB, { 0xE5, 0xBE, 0xBD },
	0xF3DC, { 0xE6, 0x87, 0x89 },
	0xF3DD, { 0xE6, 0x87, 0x82 },
	0xF3DE, { 0xE6, 0x87, 0x87 },
	0xF3DF, { 0xE6, 0x87, 0xA6 },
	0xF3E0, { 0xE6, 0x87, 0x8B },
	0xF3E1, { 0xE6, 0x88, 0xB2 },
	0xF3E2, { 0xE6, 0x88, 0xB4 },
	0xF3E3, { 0xE6, 0x93, 0x8E },
	0xF3E4, { 0xE6, 0x93, 0x8A },
	0xF3E5, { 0xE6, 0x93, 0x98 },
	0xF3E6, { 0xE6, 0x93, 0xA0 },
	0xF3E7, { 0xE6, 0x93, 0xB0 },
	0xF3E8, { 0xE6, 0x93, 0xA6 },
	0xF3E9, { 0xE6, 0x93, 0xAC },
	0xF3EA, { 0xE6, 0x93, 0xB1 },
	0xF3EB, { 0xE6, 0x93, 0xA2 },
	0xF3EC, { 0xE6, 0x93, 0xAD },
	0xF3ED, { 0xE6, 0x96, 0x82 },
	0xF3EE, { 0xE6, 0x96, 0x83 },
	0xF3EF, { 0xE6, 0x9B, 0x99 },
	0xF3F0, { 0xE6, 0x9B, 0x96 },
	0xF3F1, { 0xE6, 0xAA, 0x80 },
	0xF3F2, { 0xE6, 0xAA, 0x94 },
	0xF3F3, { 0xE6, 0xAA, 0x84 },
	0xF3F4, { 0xE6, 0xAA, 0xA2 },
	0xF3F5, { 0xE6, 0xAA, 0x9C },
	0xF3F6, { 0xE6, 0xAB, 0x9B },
	0xF3F7, { 0xE6, 0xAA, 0xA3 },
	0xF3F8, { 0xE6, 0xA9, 0xBE },
	0xF3F9, { 0xE6, 0xAA, 0x97 },
	0xF3FA, { 0xE6, 0xAA, 0x90 },
	0xF3FB, { 0xE6, 0xAA, 0xA0 },
	0xF3FC, { 0xE6, 0xAD, 0x9C },
	0xF3FD, { 0xE6, 0xAE, 0xAE },
	0xF3FE, { 0xE6, 0xAF, 0x9A },
	0xF4A1, { 0xE6, 0xB0, 0x88 },
	0xF4A2, { 0xE6, 0xBF, 0x98 },
	0xF4A3, { 0xE6, 0xBF, 0xB1 },
	0xF4A4, { 0xE6, 0xBF, 0x9F },
	0xF4A5, { 0xE6, 0xBF, 0xA0 },
	0xF4A6, { 0xE6, 0xBF, 0x9B },
	0xF4A7, { 0xE6, 0xBF, 0xA4 },
	0xF4A8, { 0xE6, 0xBF, 0xAB },
	0xF4A9, { 0xE6, 0xBF, 0xAF },
	0xF4AA, { 0xE6, 0xBE, 0x80 },
	0xF4AB, { 0xE6, 0xBF, 0xAC },
	0xF4AC, { 0xE6, 0xBF, 0xA1 },
	0xF4AD, { 0xE6, 0xBF, 0xA9 },
	0xF4AE, { 0xE6, 0xBF, 0x95 },
	0xF4AF, { 0xE6, 0xBF, 0xAE },
	0xF4B0, { 0xE6, 0xBF, 0xB0 },
	0xF4B1, { 0xE7, 0x87, 0xA7 },
	0xF4B2, { 0xE7, 0x87, 0x9F },
	0xF4B3, { 0xE7, 0x87, 0xAE },
	0xF4B4, { 0xE7, 0x87, 0xA6 },
	0xF4B5, { 0xE7, 0x87, 0xA5 },
	0xF4B6, { 0xE7, 0x87, 0xAD },
	0xF4B7, { 0xE7, 0x87, 0xAC },
	0xF4B8, { 0xE7, 0x87, 0xB4 },
	0xF4B9, { 0xE7, 0x87, 0xA0 },
	0xF4BA, { 0xE7, 0x88, 0xB5 },
	0xF4BB, { 0xE7, 0x89, 0x86 },
	0xF4BC, { 0xE7, 0x8D, 0xB0 },
	0xF4BD, { 0xE7, 0x8D, 0xB2 },
	0xF4BE, { 0xE7, 0x92, 0xA9 },
	0xF4BF, { 0xE7, 0x92, 0xB0 },
	0xF4C0, { 0xE7, 0x92, 0xA6 },
	0xF4C1, { 0xE7, 0x92, 0xA8 },
	0xF4C2, { 0xE7, 0x99, 0x86 },
	0xF4C3, { 0xE7, 0x99, 0x82 },
	0xF4C4, { 0xE7, 0x99, 0x8C },
	0xF4C5, { 0xE7, 0x9B, 0xAA },
	0xF4C6, { 0xE7, 0x9E, 0xB3 },
	0xF4C7, { 0xE7, 0x9E, 0xAA },
	0xF4C8, { 0xE7, 0x9E, 0xB0 },
	0xF4C9, { 0xE7, 0x9E, 0xAC },
	0xF4CA, { 0xE7, 0x9E, 0xA7 },
	0xF4CB, { 0xE7, 0x9E, 0xAD },
	0xF4CC, { 0xE7, 0x9F, 0xAF },
	0xF4CD, { 0xE7, 0xA3, 0xB7 },
	0xF4CE, { 0xE7, 0xA3, 0xBA },
	0xF4CF, { 0xE7, 0xA3, 0xB4 },
	0xF4D0, { 0xE7, 0xA3, 0xAF },
	0xF4D1, { 0xE7, 0xA4, 0x81 },
	0xF4D2, { 0xE7, 0xA6, 0xA7 },
	0xF4D3, { 0xE7, 0xA6, 0xAA },
	0xF4D4, { 0xE7, 0xA9, 0x97 },
	0xF4D5, { 0xE7, 0xAA, 0xBF },
	0xF4D6, { 0xE7, 0xB0, 0x87 },
	0xF4D7, { 0xE7, 0xB0, 0x8D },
	0xF4D8, { 0xE7, 0xAF, 0xBE },
	0xF4D9, { 0xE7, 0xAF, 0xB7 },
	0xF4DA, { 0xE7, 0xB0, 0x8C },
	0xF4DB, { 0xE7, 0xAF, 0xA0 },
	0xF4DC, { 0xE7, 0xB3, 0xA0 },
	0xF4DD, { 0xE7, 0xB3, 0x9C },
	0xF4DE, { 0xE7, 0xB3, 0x9E },
	0xF4DF, { 0xE7, 0xB3, 0xA2 },
	0xF4E0, { 0xE7, 0xB3, 0x9F },
	0xF4E1, { 0xE7, 0xB3, 0x99 },
	0xF4E2, { 0xE7, 0xB3, 0x9D },
	0xF4E3, { 0xE7, 0xB8, 0xAE },
	0xF4E4, { 0xE7, 0xB8, 0xBE },
	0xF4E5, { 0xE7, 0xB9, 0x86 },
	0xF4E6, { 0xE7, 0xB8, 0xB7 },
	0xF4E7, { 0xE7, 0xB8, 0xB2 },
	0xF4E8, { 0xE7, 0xB9, 0x83 },
	0xF4E9, { 0xE7, 0xB8, 0xAB },
	0xF4EA, { 0xE7, 0xB8, 0xBD },
	0xF4EB, { 0xE7, 0xB8, 0xB1 },
	0xF4EC, { 0xE7, 0xB9, 0x85 },
	0xF4ED, { 0xE7, 0xB9, 0x81 },
	0xF4EE, { 0xE7, 0xB8, 0xB4 },
	0xF4EF, { 0xE7, 0xB8, 0xB9 },
	0xF4F0, { 0xE7, 0xB9, 0x88 },
	0xF4F1, { 0xE7, 0xB8, 0xB5 },
	0xF4F2, { 0xE7, 0xB8, 0xBF },
	0xF4F3, { 0xE7, 0xB8, 0xAF },
	0xF4F4, { 0xE7, 0xBD, 0x84 },
	0xF4F5, { 0xE7, 0xBF, 0xB3 },
	0xF4F6, { 0xE7, 0xBF, 0xBC },
	0xF4F7, { 0xE8, 0x81, 0xB1 },
	0xF4F8, { 0xE8, 0x81, 0xB2 },
	0xF4F9, { 0xE8, 0x81, 0xB0 },
	0xF4FA, { 0xE8, 0x81, 0xAF },
	0xF4FB, { 0xE8, 0x81, 0xB3 },
	0xF4FC, { 0xE8, 0x87, 0x86 },
	0xF4FD, { 0xE8, 0x87, 0x83 },
	0xF4FE, { 0xE8, 0x86, 0xBA },
	0xF5A1, { 0xE8, 0x87, 0x82 },
	0xF5A2, { 0xE8, 0x87, 0x80 },
	0xF5A3, { 0xE8, 0x86, 0xBF },
	0xF5A4, { 0xE8, 0x86, 0xBD },
	0xF5A5, { 0xE8, 0x87, 0x89 },
	0xF5A6, { 0xE8, 0x86, 0xBE },
	0xF5A7, { 0xE8, 0x87, 0xA8 },
	0xF5A8, { 0xE8, 0x88, 0x89 },
	0xF5A9, { 0xE8, 0x89, 0xB1 },
	0xF5AA, { 0xE8, 0x96, 0xAA },
	0xF5AB, { 0xE8, 0x96, 0x84 },
	0xF5AC, { 0xE8, 0x95, 0xBE },
	0xF5AD, { 0xE8, 0x96, 0x9C },
	0xF5AE, { 0xE8, 0x96, 0x91 },
	0xF5AF, { 0xE8, 0x96, 0x94 },
	0xF5B0, { 0xE8, 0x96, 0xAF },
	0xF5B1, { 0xE8, 0x96, 0x9B },
	0xF5B2, { 0xE8, 0x96, 0x87 },
	0xF5B3, { 0xE8, 0x96, 0xA8 },
	0xF5B4, { 0xE8, 0x96, 0x8A },
	0xF5B5, { 0xE8, 0x96, 0xA6 },
	0xF5B6, { 0xE8, 0x99, 0xA7 },
	0xF5B7, { 0xE8, 0x9F, 0x80 },
	0xF5B8, { 0xE8, 0x9F, 0x91 },
	0xF5B9, { 0xE8, 0x9E, 0xB3 },
	0xF5BA, { 0xE8, 0x9F, 0x92 },
	0xF5BB, { 0xE8, 0x9F, 0x86 },
	0xF5BC, { 0xE8, 0x9E, 0xAB },
	0xF5BD, { 0xE8, 0x9E, 0xBB },
	0xF5BE, { 0xE8, 0x9E, 0xBA },
	0xF5BF, { 0xE8, 0x9F, 0x88 },
	0xF5C0, { 0xE8, 0x9F, 0x8B },
	0xF5C1, { 0xE8, 0xA4, 0xBB },
	0xF5C2, { 0xE8, 0xA4, 0xB6 },
	0xF5C3, { 0xE8, 0xA5, 0x84 },
	0xF5C4, { 0xE8, 0xA4, 0xB8 },
	0xF5C5, { 0xE8, 0xA4, 0xBD },
	0xF5C6, { 0xE8, 0xA6, 0xAC },
	0xF5C7, { 0xE8, 0xAC, 0x8E },
	0xF5C8, { 0xE8, 0xAC, 0x97 },
	0xF5C9, { 0xE8, 0xAC, 0x99 },
	0xF5CA, { 0xE8, 0xAC, 0x9B },
	0xF5CB, { 0xE8, 0xAC, 0x8A },
	0xF5CC, { 0xE8, 0xAC, 0xA0 },
	0xF5CD, { 0xE8, 0xAC, 0x9D },
	0xF5CE, { 0xE8, 0xAC, 0x84 },
	0xF5CF, { 0xE8, 0xAC, 0x90 },
	0xF5D0, { 0xE8, 0xB1, 0x81 },
	0xF5D1, { 0xE8, 0xB0, 0xBF },
	0xF5D2, { 0xE8, 0xB1, 0xB3 },
	0xF5D3, { 0xE8, 0xB3, 0xBA },
	0xF5D4, { 0xE8, 0xB3, 0xBD },
	0xF5D5, { 0xE8, 0xB3, 0xBC },
	0xF5D6, { 0xE8, 0xB3, 0xB8 },
	0xF5D7, { 0xE8, 0xB3, 0xBB },
	0xF5D8, { 0xE8, 0xB6, 0xA8 },
	0xF5D9, { 0xE8, 0xB9, 0x89 },
	0xF5DA, { 0xE8, 0xB9, 0x8B },
	0xF5DB, { 0xE8, 0xB9, 0x88 },
	0xF5DC, { 0xE8, 0xB9, 0x8A },
	0xF5DD, { 0xE8, 0xBD, 0x84 },
	0xF5DE, { 0xE8, 0xBC, 0xBE },
	0xF5DF, { 0xE8, 0xBD, 0x82 },
	0xF5E0, { 0xE8, 0xBD, 0x85 },
	0xF5E1, { 0xE8, 0xBC, 0xBF },
	0xF5E2, { 0xE9, 0x81, 0xBF },
	0xF5E3, { 0xE9, 0x81, 0xBD },
	0xF5E4, { 0xE9, 0x82, 0x84 },
	0xF5E5, { 0xE9, 0x82, 0x81 },
	0xF5E6, { 0xE9, 0x82, 0x82 },
	0xF5E7, { 0xE9, 0x82, 0x80 },
	0xF5E8, { 0xE9, 0x84, 0xB9 },
	0xF5E9, { 0xE9, 0x86, 0xA3 },
	0xF5EA, { 0xE9, 0x86, 0x9E },
	0xF5EB, { 0xE9, 0x86, 0x9C },
	0xF5EC, { 0xE9, 0x8D, 0x8D },
	0xF5ED, { 0xE9, 0x8E, 0x82 },
	0xF5EE, { 0xE9, 0x8C, 0xA8 },
	0xF5EF, { 0xE9, 0x8D, 0xB5 },
	0xF5F0, { 0xE9, 0x8D, 0x8A },
	0xF5F1, { 0xE9, 0x8D, 0xA5 },
	0xF5F2, { 0xE9, 0x8D, 0x8B },
	0xF5F3, { 0xE9, 0x8C, 0x98 },
	0xF5F4, { 0xE9, 0x8D, 0xBE },
	0xF5F5, { 0xE9, 0x8D, 0xAC },
	0xF5F6, { 0xE9, 0x8D, 0x9B },
	0xF5F7, { 0xE9, 0x8D, 0xB0 },
	0xF5F8, { 0xE9, 0x8D, 0x9A },
	0xF5F9, { 0xE9, 0x8D, 0x94 },
	0xF5FA, { 0xE9, 0x97, 0x8A },
	0xF5FB, { 0xE9, 0x97, 0x8B },
	0xF5FC, { 0xE9, 0x97, 0x8C },
	0xF5FD, { 0xE9, 0x97, 0x88 },
	0xF5FE, { 0xE9, 0x97, 0x86 },
	0xF6A1, { 0xE9, 0x9A, 0xB1 },
	0xF6A2, { 0xE9, 0x9A, 0xB8 },
	0xF6A3, { 0xE9, 0x9B, 0x96 },
	0xF6A4, { 0xE9, 0x9C, 0x9C },
	0xF6A5, { 0xE9, 0x9C, 0x9E },
	0xF6A6, { 0xE9, 0x9E, 0xA0 },
	0xF6A7, { 0xE9, 0x9F, 0x93 },
	0xF6A8, { 0xE9, 0xA1, 0x86 },
	0xF6A9, { 0xE9, 0xA2, 0xB6 },
	0xF6AA, { 0xE9, 0xA4, 0xB5 },
	0xF6AB, { 0xE9, 0xA8, 0x81 },
	0xF6AC, { 0xE9, 0xA7, 0xBF },
	0xF6AD, { 0xE9, 0xAE, 0xAE },
	0xF6AE, { 0xE9, 0xAE, 0xAB },
	0xF6AF, { 0xE9, 0xAE, 0xAA },
	0xF6B0, { 0xE9, 0xAE, 0xAD },
	0xF6B1, { 0xE9, 0xB4, 0xBB },
	0xF6B2, { 0xE9, 0xB4, 0xBF },
	0xF6B3, { 0xE9, 0xBA, 0x8B },
	0xF6B4, { 0xE9, 0xBB, 0x8F },
	0xF6B5, { 0xE9, 0xBB, 0x9E },
	0xF6B6, { 0xE9, 0xBB, 0x9C },
	0xF6B7, { 0xE9, 0xBB, 0x9D },
	0xF6B8, { 0xE9, 0xBB, 0x9B },
	0xF6B9, { 0xE9, 0xBC, 0xBE },
	0xF6BA, { 0xE9, 0xBD, 0x8B },
	0xF6BB, { 0xE5, 0x8F, 0xA2 },
	0xF6BC, { 0xE5, 0x9A, 0x95 },
	0xF6BD, { 0xE5, 0x9A, 0xAE },
	0xF6BE, { 0xE5, 0xA3, 0x99 },
	0xF6BF, { 0xE5, 0xA3, 0x98 },
	0xF6C0, { 0xE5, 0xAC, 0xB8 },
	0xF6C1, { 0xE5, 0xBD, 0x9E },
	0xF6C2, { 0xE6, 0x87, 0xA3 },
	0xF6C3, { 0xE6, 0x88, 0xB3 },
	0xF6C4, { 0xE6, 0x93, 0xB4 },
	0xF6C5, { 0xE6, 0x93, 0xB2 },
	0xF6C6, { 0xE6, 0x93, 0xBE },
	0xF6C7, { 0xE6, 0x94, 0x86 },
	0xF6C8, { 0xE6, 0x93, 0xBA },
	0xF6C9, { 0xE6, 0x93, 0xBB },
	0xF6CA, { 0xE6, 0x93, 0xB7 },
	0xF6CB, { 0xE6, 0x96, 0xB7 },
	0xF6CC, { 0xE6, 0x9B, 0x9C },
	0xF6CD, { 0xE6, 0x9C, 0xA6 },
	0xF6CE, { 0xE6, 0xAA, 0xB3 },
	0xF6CF, { 0xE6, 0xAA, 0xAC },
	0xF6D0, { 0xE6, 0xAB, 0x83 },
	0xF6D1, { 0xE6, 0xAA, 0xBB },
	0xF6D2, { 0xE6, 0xAA, 0xB8 },
	0xF6D3, { 0xE6, 0xAB, 0x82 },
	0xF6D4, { 0xE6, 0xAA, 0xAE },
	0xF6D5, { 0xE6, 0xAA, 0xAF },
	0xF6D6, { 0xE6, 0xAD, 0x9F },
	0xF6D7, { 0xE6, 0xAD, 0xB8 },
	0xF6D8, { 0xE6, 0xAE, 0xAF },
	0xF6D9, { 0xE7, 0x80, 0x89 },
	0xF6DA, { 0xE7, 0x80, 0x8B },
	0xF6DB, { 0xE6, 0xBF, 0xBE },
	0xF6DC, { 0xE7, 0x80, 0x86 },
	0xF6DD, { 0xE6, 0xBF, 0xBA },
	0xF6DE, { 0xE7, 0x80, 0x91 },
	0xF6DF, { 0xE7, 0x80, 0x8F },
	0xF6E0, { 0xE7, 0x87, 0xBB },
	0xF6E1, { 0xE7, 0x87, 0xBC },
	0xF6E2, { 0xE7, 0x87, 0xBE },
	0xF6E3, { 0xE7, 0x87, 0xB8 },
	0xF6E4, { 0xE7, 0x8D, 0xB7 },
	0xF6E5, { 0xE7, 0x8D, 0xB5 },
	0xF6E6, { 0xE7, 0x92, 0xA7 },
	0xF6E7, { 0xE7, 0x92, 0xBF },
	0xF6E8, { 0xE7, 0x94, 0x95 },
	0xF6E9, { 0xE7, 0x99, 0x96 },
	0xF6EA, { 0xE7, 0x99, 0x98 },
	0xF6EB, { 0xE7, 0x99, 0x92 },
	0xF6EC, { 0xE7, 0x9E, 0xBD },
	0xF6ED, { 0xE7, 0x9E, 0xBF },
	0xF6EE, { 0xE7, 0x9E, 0xBB },
	0xF6EF, { 0xE7, 0x9E, 0xBC },
	0xF6F0, { 0xE7, 0xA4, 0x8E },
	0xF6F1, { 0xE7, 0xA6, 0xAE },
	0xF6F2, { 0xE7, 0xA9, 0xA1 },
	0xF6F3, { 0xE7, 0xA9, 0xA2 },
	0xF6F4, { 0xE7, 0xA9, 0xA0 },
	0xF6F5, { 0xE7, 0xAB, 0x84 },
	0xF6F6, { 0xE7, 0xAB, 0x85 },
	0xF6F7, { 0xE7, 0xB0, 0xAB },
	0xF6F8, { 0xE7, 0xB0, 0xA7 },
	0xF6F9, { 0xE7, 0xB0, 0xAA },
	0xF6FA, { 0xE7, 0xB0, 0x9E },
	0xF6FB, { 0xE7, 0xB0, 0xA3 },
	0xF6FC, { 0xE7, 0xB0, 0xA1 },
	0xF6FD, { 0xE7, 0xB3, 0xA7 },
	0xF6FE, { 0xE7, 0xB9, 0x94 },
	0xF7A1, { 0xE7, 0xB9, 0x95 },
	0xF7A2, { 0xE7, 0xB9, 0x9E },
	0xF7A3, { 0xE7, 0xB9, 0x9A },
	0xF7A4, { 0xE7, 0xB9, 0xA1 },
	0xF7A5, { 0xE7, 0xB9, 0x92 },
	0xF7A6, { 0xE7, 0xB9, 0x99 },
	0xF7A7, { 0xE7, 0xBD, 0x88 },
	0xF7A8, { 0xE7, 0xBF, 0xB9 },
	0xF7A9, { 0xE7, 0xBF, 0xBB },
	0xF7AA, { 0xE8, 0x81, 0xB7 },
	0xF7AB, { 0xE8, 0x81, 0xB6 },
	0xF7AC, { 0xE8, 0x87, 0x8D },
	0xF7AD, { 0xE8, 0x87, 0x8F },
	0xF7AE, { 0xE8, 0x88, 0x8A },
	0xF7AF, { 0xE8, 0x97, 0x8F },
	0xF7B0, { 0xE8, 0x96, 0xA9 },
	0xF7B1, { 0xE8, 0x97, 0x8D },
	0xF7B2, { 0xE8, 0x97, 0x90 },
	0xF7B3, { 0xE8, 0x97, 0x89 },
	0xF7B4, { 0xE8, 0x96, 0xB0 },
	0xF7B5, { 0xE8, 0x96, 0xBA },
	0xF7B6, { 0xE8, 0x96, 0xB9 },
	0xF7B7, { 0xE8, 0x9F, 0xAF },
	0xF7B8, { 0xE8, 0x9F, 0xAC },
	0xF7B9, { 0xE8, 0x9F, 0xB2 },
	0xF7BA, { 0xE8, 0x9F, 0xA0 },
	0xF7BB, { 0xE8, 0xA6, 0x86 },
	0xF7BC, { 0xE8, 0xA6, 0xB2 },
	0xF7BD, { 0xE8, 0xA7, 0xB4 },
	0xF7BE, { 0xE8, 0xAC, 0xA8 },
	0xF7BF, { 0xE8, 0xAC, 0xB9 },
	0xF7C0, { 0xE8, 0xAC, 0xAC },
	0xF7C1, { 0xE8, 0xAC, 0xAB },
	0xF7C2, { 0xE8, 0xB1, 0x90 },
	0xF7C3, { 0xE8, 0xB4, 0x85 },
	0xF7C4, { 0xE8, 0xB9, 0x99 },
	0xF7C5, { 0xE8, 0xB9, 0xA3 },
	0xF7C6, { 0xE8, 0xB9, 0xA6 },
	0xF7C7, { 0xE8, 0xB9, 0xA4 },
	0xF7C8, { 0xE8, 0xB9, 0x9F },
	0xF7C9, { 0xE8, 0xB9, 0x95 },
	0xF7CA, { 0xE8, 0xBB, 0x80 },
	0xF7CB, { 0xE8, 0xBD, 0x89 },
	0xF7CC, { 0xE8, 0xBD, 0x8D },
	0xF7CD, { 0xE9, 0x82, 0x87 },
	0xF7CE, { 0xE9, 0x82, 0x83 },
	0xF7CF, { 0xE9, 0x82, 0x88 },
	0xF7D0, { 0xE9, 0x86, 0xAB },
	0xF7D1, { 0xE9, 0x86, 0xAC },
	0xF7D2, { 0xE9, 0x87, 0x90 },
	0xF7D3, { 0xE9, 0x8E, 0x94 },
	0xF7D4, { 0xE9, 0x8E, 0x8A },
	0xF7D5, { 0xE9, 0x8E, 0x96 },
	0xF7D6, { 0xE9, 0x8E, 0xA2 },
	0xF7D7, { 0xE9, 0x8E, 0xB3 },
	0xF7D8, { 0xE9, 0x8E, 0xAE },
	0xF7D9, { 0xE9, 0x8E, 0xAC },
	0xF7DA, { 0xE9, 0x8E, 0xB0 },
	0xF7DB, { 0xE9, 0x8E, 0x98 },
	0xF7DC, { 0xE9, 0x8E, 0x9A },
	0xF7DD, { 0xE9, 0x8E, 0x97 },
	0xF7DE, { 0xE9, 0x97, 0x94 },
	0xF7DF, { 0xE9, 0x97, 0x96 },
	0xF7E0, { 0xE9, 0x97, 0x90 },
	0xF7E1, { 0xE9, 0x97, 0x95 },
	0xF7E2, { 0xE9, 0x9B, 0xA2 },
	0xF7E3, { 0xE9, 0x9B, 0x9C },
	0xF7E4, { 0xE9, 0x9B, 0x99 },
	0xF7E5, { 0xE9, 0x9B, 0x9B },
	0xF7E6, { 0xE9, 0x9B, 0x9E },
	0xF7E7, { 0xE9, 0x9C, 0xA4 },
	0xF7E8, { 0xE9, 0x9E, 0xA3 },
	0xF7E9, { 0xE9, 0x9E, 0xA6 },
	0xF7EA, { 0xE9, 0x9E, 0xAD },
	0xF7EB, { 0xE9, 0x9F, 0xB9 },
	0xF7EC, { 0xE9, 0xA1, 0x8D },
	0xF7ED, { 0xE9, 0xA1, 0x8F },
	0xF7EE, { 0xE9, 0xA1, 0x8C },
	0xF7EF, { 0xE9, 0xA1, 0x8E },
	0xF7F0, { 0xE9, 0xA1, 0x93 },
	0xF7F1, { 0xE9, 0xA2, 0xBA },
	0xF7F2, { 0xE9, 0xA4, 0xBE },
	0xF7F3, { 0xE9, 0xA4, 0xBF },
	0xF7F4, { 0xE9, 0xA4, 0xBD },
	0xF7F5, { 0xE9, 0xA4, 0xAE },
	0xF7F6, { 0xE9, 0xA6, 0xA5 },
	0xF7F7, { 0xE9, 0xA8, 0x8E },
	0xF7F8, { 0xE9, 0xAB, 0x81 },
	0xF7F9, { 0xE9, 0xAC, 0x83 },
	0xF7FA, { 0xE9, 0xAC, 0x86 },
	0xF7FB, { 0xE9, 0xAD, 0x8F },
	0xF7FC, { 0xE9, 0xAD, 0x8E },
	0xF7FD, { 0xE9, 0xAD, 0x8D },
	0xF7FE, { 0xE9, 0xAF, 0x8A },
	0xF8A1, { 0xE9, 0xAF, 0x89 },
	0xF8A2, { 0xE9, 0xAF, 0xBD },
	0xF8A3, { 0xE9, 0xAF, 0x88 },
	0xF8A4, { 0xE9, 0xAF, 0x80 },
	0xF8A5, { 0xE9, 0xB5, 0x91 },
	0xF8A6, { 0xE9, 0xB5, 0x9D },
	0xF8A7, { 0xE9, 0xB5, 0xA0 },
	0xF8A8, { 0xE9, 0xBB, 0xA0 },
	0xF8A9, { 0xE9, 0xBC, 0x95 },
	0xF8AA, { 0xE9, 0xBC, 0xAC },
	0xF8AB, { 0xE5, 0x84, 0xB3 },
	0xF8AC, { 0xE5, 0x9A, 0xA5 },
	0xF8AD, { 0xE5, 0x9A, 0xA8 },
	0xF8AE, { 0xE5, 0xA3, 0x9E },
	0xF8AF, { 0xE5, 0xA3, 0x9F },
	0xF8B0, { 0xE5, 0xA3, 0xA2 },
	0xF8B1, { 0xE5, 0xAF, 0xB5 },
	0xF8B2, { 0xE9, 0xBE, 0x90 },
	0xF8B3, { 0xE5, 0xBB, 0xAC },
	0xF8B4, { 0xE6, 0x87, 0xB2 },
	0xF8B5, { 0xE6, 0x87, 0xB7 },
	0xF8B6, { 0xE6, 0x87, 0xB6 },
	0xF8B7, { 0xE6, 0x87, 0xB5 },
	0xF8B8, { 0xE6, 0x94, 0x80 },
	0xF8B9, { 0xE6, 0x94, 0x8F },
	0xF8BA, { 0xE6, 0x9B, 0xA0 },
	0xF8BB, { 0xE6, 0x9B, 0x9D },
	0xF8BC, { 0xE6, 0xAB, 0xA5 },
	0xF8BD, { 0xE6, 0xAB, 0x9D },
	0xF8BE, { 0xE6, 0xAB, 0x9A },
	0xF8BF, { 0xE6, 0xAB, 0x93 },
	0xF8C0, { 0xE7, 0x80, 0x9B },
	0xF8C1, { 0xE7, 0x80, 0x9F },
	0xF8C2, { 0xE7, 0x80, 0xA8 },
	0xF8C3, { 0xE7, 0x80, 0x9A },
	0xF8C4, { 0xE7, 0x80, 0x9D },
	0xF8C5, { 0xE7, 0x80, 0x95 },
	0xF8C6, { 0xE7, 0x80, 0x98 },
	0xF8C7, { 0xE7, 0x88, 0x86 },
	0xF8C8, { 0xE7, 0x88, 0x8D },
	0xF8C9, { 0xE7, 0x89, 0x98 },
	0xF8CA, { 0xE7, 0x8A, 0xA2 },
	0xF8CB, { 0xE7, 0x8D, 0xB8 },
	0xF8CC, { 0xE7, 0x8D, 0xBA },
	0xF8CD, { 0xE7, 0x92, 0xBD },
	0xF8CE, { 0xE7, 0x93, 0x8A },
	0xF8CF, { 0xE7, 0x93, 0xA3 },
	0xF8D0, { 0xE7, 0x96, 0x87 },
	0xF8D1, { 0xE7, 0x96, 0x86 },
	0xF8D2, { 0xE7, 0x99, 0x9F },
	0xF8D3, { 0xE7, 0x99, 0xA1 },
	0xF8D4, { 0xE7, 0x9F, 0x87 },
	0xF8D5, { 0xE7, 0xA4, 0x99 },
	0xF8D6, { 0xE7, 0xA6, 0xB1 },
	0xF8D7, { 0xE7, 0xA9, 0xAB },
	0xF8D8, { 0xE7, 0xA9, 0xA9 },
	0xF8D9, { 0xE7, 0xB0, 0xBE },
	0xF8DA, { 0xE7, 0xB0, 0xBF },
	0xF8DB, { 0xE7, 0xB0, 0xB8 },
	0xF8DC, { 0xE7, 0xB0, 0xBD },
	0xF8DD, { 0xE7, 0xB0, 0xB7 },
	0xF8DE, { 0xE7, 0xB1, 0x80 },
	0xF8DF, { 0xE7, 0xB9, 0xAB },
	0xF8E0, { 0xE7, 0xB9, 0xAD },
	0xF8E1, { 0xE7, 0xB9, 0xB9 },
	0xF8E2, { 0xE7, 0xB9, 0xA9 },
	0xF8E3, { 0xE7, 0xB9, 0xAA },
	0xF8E4, { 0xE7, 0xB9, 0xB3 },
	0xF8E5, { 0xE7, 0xBE, 0x85 },
	0xF8E6, { 0xE7, 0xBE, 0xB6 },
	0xF8E7, { 0xE7, 0xBE, 0xB9 },
	0xF8E8, { 0xE7, 0xBE, 0xB8 },
	0xF8E9, { 0xE8, 0x87, 0x98 },
	0xF8EA, { 0xE8, 0x97, 0xA9 },
	0xF8EB, { 0xE8, 0x97, 0x9D },
	0xF8EC, { 0xE8, 0x97, 0xAA },
	0xF8ED, { 0xE8, 0x97, 0x95 },
	0xF8EE, { 0xE8, 0x97, 0xA4 },
	0xF8EF, { 0xE8, 0x97, 0xA5 },
	0xF8F0, { 0xE8, 0x97, 0xB7 },
	0xF8F1, { 0xE8, 0x9F, 0xBB },
	0xF8F2, { 0xE8, 0xA0, 0x85 },
	0xF8F3, { 0xE8, 0xA0, 0x8D },
	0xF8F4, { 0xE8, 0x9F, 0xB9 },
	0xF8F5, { 0xE8, 0x9F, 0xBE },
	0xF8F6, { 0xE8, 0xA5, 0xA0 },
	0xF8F7, { 0xE8, 0xA5, 0x9F },
	0xF8F8, { 0xE8, 0xA5, 0x96 },
	0xF8F9, { 0xE8, 0xA5, 0x9E },
	0xF8FA, { 0xE8, 0xAD, 0x81 },
	0xF8FB, { 0xE8, 0xAD, 0x9C },
	0xF8FC, { 0xE8, 0xAD, 0x98 },
	0xF8FD, { 0xE8, 0xAD, 0x89 },
	0xF8FE, { 0xE8, 0xAD, 0x9A },
	0xF9A1, { 0xE8, 0xAD, 0x8E },
	0xF9A2, { 0xE8, 0xAD, 0x8F },
	0xF9A3, { 0xE8, 0xAD, 0x86 },
	0xF9A4, { 0xE8, 0xAD, 0x99 },
	0xF9A5, { 0xE8, 0xB4, 0x88 },
	0xF9A6, { 0xE8, 0xB4, 0x8A },
	0xF9A7, { 0xE8, 0xB9, 0xBC },
	0xF9A8, { 0xE8, 0xB9, 0xB2 },
	0xF9A9, { 0xE8, 0xBA, 0x87 },
	0xF9AA, { 0xE8, 0xB9, 0xB6 },
	0xF9AB, { 0xE8, 0xB9, 0xAC },
	0xF9AC, { 0xE8, 0xB9, 0xBA },
	0xF9AD, { 0xE8, 0xB9, 0xB4 },
	0xF9AE, { 0xE8, 0xBD, 0x94 },
	0xF9AF, { 0xE8, 0xBD, 0x8E },
	0xF9B0, { 0xE8, 0xBE, 0xAD },
	0xF9B1, { 0xE9, 0x82, 0x8A },
	0xF9B2, { 0xE9, 0x82, 0x8B },
	0xF9B3, { 0xE9, 0x86, 0xB1 },
	0xF9B4, { 0xE9, 0x86, 0xAE },
	0xF9B5, { 0xE9, 0x8F, 0xA1 },
	0xF9B6, { 0xE9, 0x8F, 0x91 },
	0xF9B7, { 0xE9, 0x8F, 0x9F },
	0xF9B8, { 0xE9, 0x8F, 0x83 },
	0xF9B9, { 0xE9, 0x8F, 0x88 },
	0xF9BA, { 0xE9, 0x8F, 0x9C },
	0xF9BB, { 0xE9, 0x8F, 0x9D },
	0xF9BC, { 0xE9, 0x8F, 0x96 },
	0xF9BD, { 0xE9, 0x8F, 0xA2 },
	0xF9BE, { 0xE9, 0x8F, 0x8D },
	0xF9BF, { 0xE9, 0x8F, 0x98 },
	0xF9C0, { 0xE9, 0x8F, 0xA4 },
	0xF9C1, { 0xE9, 0x8F, 0x97 },
	0xF9C2, { 0xE9, 0x8F, 0xA8 },
	0xF9C3, { 0xE9, 0x97, 0x9C },
	0xF9C4, { 0xE9, 0x9A, 0xB4 },
	0xF9C5, { 0xE9, 0x9B, 0xA3 },
	0xF9C6, { 0xE9, 0x9C, 0xAA },
	0xF9C7, { 0xE9, 0x9C, 0xA7 },
	0xF9C8, { 0xE9, 0x9D, 0xA1 },
	0xF9C9, { 0xE9, 0x9F, 0x9C },
	0xF9CA, { 0xE9, 0x9F, 0xBB },
	0xF9CB, { 0xE9, 0xA1, 0x9E },
	0xF9CC, { 0xE9, 0xA1, 0x98 },
	0xF9CD, { 0xE9, 0xA1, 0x9B },
	0xF9CE, { 0xE9, 0xA2, 0xBC },
	0xF9CF, { 0xE9, 0xA5, 0x85 },
	0xF9D0, { 0xE9, 0xA5, 0x89 },
	0xF9D1, { 0xE9, 0xA8, 0x96 },
	0xF9D2, { 0xE9, 0xA8, 0x99 },
	0xF9D3, { 0xE9, 0xAC, 0x8D },
	0xF9D4, { 0xE9, 0xAF, 0xA8 },
	0xF9D5, { 0xE9, 0xAF, 0xA7 },
	0xF9D6, { 0xE9, 0xAF, 0x96 },
	0xF9D7, { 0xE9, 0xAF, 0x9B },
	0xF9D8, { 0xE9, 0xB6, 0x89 },
	0xF9D9, { 0xE9, 0xB5, 0xA1 },
	0xF9DA, { 0xE9, 0xB5, 0xB2 },
	0xF9DB, { 0xE9, 0xB5, 0xAA },
	0xF9DC, { 0xE9, 0xB5, 0xAC },
	0xF9DD, { 0xE9, 0xBA, 0x92 },
	0xF9DE, { 0xE9, 0xBA, 0x97 },
	0xF9DF, { 0xE9, 0xBA, 0x93 },
	0xF9E0, { 0xE9, 0xBA, 0xB4 },
	0xF9E1, { 0xE5, 0x8B, 0xB8 },
	0xF9E2, { 0xE5, 0x9A, 0xB7 },
	0xF9E3, { 0xE5, 0x9A, 0xB6 },
	0xF9E4, { 0xE5, 0x9A, 0xB4 },
	0xF9E5, { 0xE5, 0x9A, 0xBC },
	0xF9E6, { 0xE5, 0xA3, 0xA4 },
	0xF9E7, { 0xE5, 0xAD, 0x80 },
	0xF9E8, { 0xE5, 0xAD, 0x83 },
	0xF9E9, { 0xE5, 0xAD, 0xBD },
	0xF9EA, { 0xE5, 0xAF, 0xB6 },
	0xF9EB, { 0xE5, 0xB7, 0x89 },
	0xF9EC, { 0xE6, 0x87, 0xB8 },
	0xF9ED, { 0xE6, 0x87, 0xBA },
	0xF9EE, { 0xE6, 0x94, 0x98 },
	0xF9EF, { 0xE6, 0x94, 0x94 },
	0xF9F0, { 0xE6, 0x94, 0x99 },
	0xF9F1, { 0xE6, 0x9B, 0xA6 },
	0xF9F2, { 0xE6, 0x9C, 0xA7 },
	0xF9F3, { 0xE6, 0xAB, 0xAC },
	0xF9F4, { 0xE7, 0x80, 0xBE },
	0xF9F5, { 0xE7, 0x80, 0xB0 },
	0xF9F6, { 0xE7, 0x80, 0xB2 },
	0xF9F7, { 0xE7, 0x88, 0x90 },
	0xF9F8, { 0xE7, 0x8D, 0xBB },
	0xF9F9, { 0xE7, 0x93, 0x8F },
	0xF9FA, { 0xE7, 0x99, 0xA2 },
	0xF9FB, { 0xE7, 0x99, 0xA5 },
	0xF9FC, { 0xE7, 0xA4, 0xA6 },
	0xF9FD, { 0xE7, 0xA4, 0xAA },
	0xF9FE, { 0xE7, 0xA4, 0xAC },
	0xFAA1, { 0xE7, 0xA4, 0xAB },
	0xFAA2, { 0xE7, 0xAB, 0x87 },
	0xFAA3, { 0xE7, 0xAB, 0xB6 },
	0xFAA4, { 0xE7, 0xB1, 0x8C },
	0xFAA5, { 0xE7, 0xB1, 0x83 },
	0xFAA6, { 0xE7, 0xB1, 0x8D },
	0xFAA7, { 0xE7, 0xB3, 0xAF },
	0xFAA8, { 0xE7, 0xB3, 0xB0 },
	0xFAA9, { 0xE8, 0xBE, 0xAE },
	0xFAAA, { 0xE7, 0xB9, 0xBD },
	0xFAAB, { 0xE7, 0xB9, 0xBC },
	0xFAAC, { 0xE7, 0xBA, 0x82 },
	0xFAAD, { 0xE7, 0xBD, 0x8C },
	0xFAAE, { 0xE8, 0x80, 0x80 },
	0xFAAF, { 0xE8, 0x87, 0x9A },
	0xFAB0, { 0xE8, 0x89, 0xA6 },
	0xFAB1, { 0xE8, 0x97, 0xBB },
	0xFAB2, { 0xE8, 0x97, 0xB9 },
	0xFAB3, { 0xE8, 0x98, 0x91 },
	0xFAB4, { 0xE8, 0x97, 0xBA },
	0xFAB5, { 0xE8, 0x98, 0x86 },
	0xFAB6, { 0xE8, 0x98, 0x8B },
	0xFAB7, { 0xE8, 0x98, 0x87 },
	0xFAB8, { 0xE8, 0x98, 0x8A },
	0xFAB9, { 0xE8, 0xA0, 0x94 },
	0xFABA, { 0xE8, 0xA0, 0x95 },
	0xFABB, { 0xE8, 0xA5, 0xA4 },
	0xFABC, { 0xE8, 0xA6, 0xBA },
	0xFABD, { 0xE8, 0xA7, 0xB8 },
	0xFABE, { 0xE8, 0xAD, 0xB0 },
	0xFABF, { 0xE8, 0xAD, 0xAC },
	0xFAC0, { 0xE8, 0xAD, 0xA6 },
	0xFAC1, { 0xE8, 0xAD, 0xAF },
	0xFAC2, { 0xE8, 0xAD, 0x9F },
	0xFAC3, { 0xE8, 0xAD, 0xAB },
	0xFAC4, { 0xE8, 0xB4, 0x8F },
	0xFAC5, { 0xE8, 0xB4, 0x8D },
	0xFAC6, { 0xE8, 0xBA, 0x89 },
	0xFAC7, { 0xE8, 0xBA, 0x81 },
	0xFAC8, { 0xE8, 0xBA, 0x85 },
	0xFAC9, { 0xE8, 0xBA, 0x82 },
	0xFACA, { 0xE9, 0x86, 0xB4 },
	0xFACB, { 0xE9, 0x87, 0x8B },
	0xFACC, { 0xE9, 0x90, 0x98 },
	0xFACD, { 0xE9, 0x90, 0x83 },
	0xFACE, { 0xE9, 0x8F, 0xBD },
	0xFACF, { 0xE9, 0x97, 0xA1 },
	0xFAD0, { 0xE9, 0x9C, 0xB0 },
	0xFAD1, { 0xE9, 0xA3, 0x84 },
	0xFAD2, { 0xE9, 0xA5, 0x92 },
	0xFAD3, { 0xE9, 0xA5, 0x91 },
	0xFAD4, { 0xE9, 0xA6, 0xA8 },
	0xFAD5, { 0xE9, 0xA8, 0xAB },
	0xFAD6, { 0xE9, 0xA8, 0xB0 },
	0xFAD7, { 0xE9, 0xA8, 0xB7 },
	0xFAD8, { 0xE9, 0xA8, 0xB5 },
	0xFAD9, { 0xE9, 0xB0, 0x93 },
	0xFADA, { 0xE9, 0xB0, 0x8D },
	0xFADB, { 0xE9, 0xB9, 0xB9 },
	0xFADC, { 0xE9, 0xBA, 0xB5 },
	0xFADD, { 0xE9, 0xBB, 0xA8 },
	0xFADE, { 0xE9, 0xBC, 0xAF },
	0xFADF, { 0xE9, 0xBD, 0x9F },
	0xFAE0, { 0xE9, 0xBD, 0xA3 },
	0xFAE1, { 0xE9, 0xBD, 0xA1 },
	0xFAE2, { 0xE5, 0x84, 0xB7 },
	0xFAE3, { 0xE5, 0x84, 0xB8 },
	0xFAE4, { 0xE5, 0x9B, 0x81 },
	0xFAE5, { 0xE5, 0x9B, 0x80 },
	0xFAE6, { 0xE5, 0x9B, 0x82 },
	0xFAE7, { 0xE5, 0xA4, 0x94 },
	0xFAE8, { 0xE5, 0xB1, 0xAC },
	0xFAE9, { 0xE5, 0xB7, 0x8D },
	0xFAEA, { 0xE6, 0x87, 0xBC },
	0xFAEB, { 0xE6, 0x87, 0xBE },
	0xFAEC, { 0xE6, 0x94, 0x9D },
	0xFAED, { 0xE6, 0x94, 0x9C },
	0xFAEE, { 0xE6, 0x96, 0x95 },
	0xFAEF, { 0xE6, 0x9B, 0xA9 },
	0xFAF0, { 0xE6, 0xAB, 0xBB },
	0xFAF1, { 0xE6, 0xAC, 0x84 },
	0xFAF2, { 0xE6, 0xAB, 0xBA },
	0xFAF3, { 0xE6, 0xAE, 0xB2 },
	0xFAF4, { 0xE7, 0x81, 0x8C },
	0xFAF5, { 0xE7, 0x88, 0x9B },
	0xFAF6, { 0xE7, 0x8A, 0xA7 },
	0xFAF7, { 0xE7, 0x93, 0x96 },
	0xFAF8, { 0xE7, 0x93, 0x94 },
	0xFAF9, { 0xE7, 0x99, 0xA9 },
	0xFAFA, { 0xE7, 0x9F, 0x93 },
	0xFAFB, { 0xE7, 0xB1, 0x90 },
	0xFAFC, { 0xE7, 0xBA, 0x8F },
	0xFAFD, { 0xE7, 0xBA, 0x8C },
	0xFAFE, { 0xE7, 0xBE, 0xBC },
	0xFBA1, { 0xE8, 0x98, 0x97 },
	0xFBA2, { 0xE8, 0x98, 0xAD },
	0xFBA3, { 0xE8, 0x98, 0x9A },
	0xFBA4, { 0xE8, 0xA0, 0xA3 },
	0xFBA5, { 0xE8, 0xA0, 0xA2 },
	0xFBA6, { 0xE8, 0xA0, 0xA1 },
	0xFBA7, { 0xE8, 0xA0, 0x9F },
	0xFBA8, { 0xE8, 0xA5, 0xAA },
	0xFBA9, { 0xE8, 0xA5, 0xAC },
	0xFBAA, { 0xE8, 0xA6, 0xBD },
	0xFBAB, { 0xE8, 0xAD, 0xB4 },
	0xFBAC, { 0xE8, 0xAD, 0xB7 },
	0xFBAD, { 0xE8, 0xAD, 0xBD },
	0xFBAE, { 0xE8, 0xB4, 0x93 },
	0xFBAF, { 0xE8, 0xBA, 0x8A },
	0xFBB0, { 0xE8, 0xBA, 0x8D },
	0xFBB1, { 0xE8, 0xBA, 0x8B },
	0xFBB2, { 0xE8, 0xBD, 0x9F },
	0xFBB3, { 0xE8, 0xBE, 0xAF },
	0xFBB4, { 0xE9, 0x86, 0xBA },
	0xFBB5, { 0xE9, 0x90, 0xAE },
	0xFBB6, { 0xE9, 0x90, 0xB3 },
	0xFBB7, { 0xE9, 0x90, 0xB5 },
	0xFBB8, { 0xE9, 0x90, 0xBA },
	0xFBB9, { 0xE9, 0x90, 0xB8 },
	0xFBBA, { 0xE9, 0x90, 0xB2 },
	0xFBBB, { 0xE9, 0x90, 0xAB },
	0xFBBC, { 0xE9, 0x97, 0xA2 },
	0xFBBD, { 0xE9, 0x9C, 0xB8 },
	0xFBBE, { 0xE9, 0x9C, 0xB9 },
	0xFBBF, { 0xE9, 0x9C, 0xB2 },
	0xFBC0, { 0xE9, 0x9F, 0xBF },
	0xFBC1, { 0xE9, 0xA1, 0xA7 },
	0xFBC2, { 0xE9, 0xA1, 0xA5 },
	0xFBC3, { 0xE9, 0xA5, 0x97 },
	0xFBC4, { 0xE9, 0xA9, 0x85 },
	0xFBC5, { 0xE9, 0xA9, 0x83 },
	0xFBC6, { 0xE9, 0xA9, 0x80 },
	0xFBC7, { 0xE9, 0xA8, 0xBE },
	0xFBC8, { 0xE9, 0xAB, 0x8F },
	0xFBC9, { 0xE9, 0xAD, 0x94 },
	0xFBCA, { 0xE9, 0xAD, 0x91 },
	0xFBCB, { 0xE9, 0xB0, 0xAD },
	0xFBCC, { 0xE9, 0xB0, 0xA5 },
	0xFBCD, { 0xE9, 0xB6, 0xAF },
	0xFBCE, { 0xE9, 0xB6, 0xB4 },
	0xFBCF, { 0xE9, 0xB7, 0x82 },
	0xFBD0, { 0xE9, 0xB6, 0xB8 },
	0xFBD1, { 0xE9, 0xBA, 0x9D },
	0xFBD2, { 0xE9, 0xBB, 0xAF },
	0xFBD3, { 0xE9, 0xBC, 0x99 },
	0xFBD4, { 0xE9, 0xBD, 0x9C },
	0xFBD5, { 0xE9, 0xBD, 0xA6 },
	0xFBD6, { 0xE9, 0xBD, 0xA7 },
	0xFBD7, { 0xE5, 0x84, 0xBC },
	0xFBD8, { 0xE5, 0x84, 0xBB },
	0xFBD9, { 0xE5, 0x9B, 0x88 },
	0xFBDA, { 0xE5, 0x9B, 0x8A },
	0xFBDB, { 0xE5, 0x9B, 0x89 },
	0xFBDC, { 0xE5, 0xAD, 0xBF },
	0xFBDD, { 0xE5, 0xB7, 0x94 },
	0xFBDE, { 0xE5, 0xB7, 0x92 },
	0xFBDF, { 0xE5, 0xBD, 0x8E },
	0xFBE0, { 0xE6, 0x87, 0xBF },
	0xFBE1, { 0xE6, 0x94, 0xA4 },
	0xFBE2, { 0xE6, 0xAC, 0x8A },
	0xFBE3, { 0xE6, 0xAD, 0xA1 },
	0xFBE4, { 0xE7, 0x81, 0x91 },
	0xFBE5, { 0xE7, 0x81, 0x98 },
	0xFBE6, { 0xE7, 0x8E, 0x80 },
	0xFBE7, { 0xE7, 0x93, 0xA4 },
	0xFBE8, { 0xE7, 0x96, 0x8A },
	0xFBE9, { 0xE7, 0x99, 0xAE },
	0xFBEA, { 0xE7, 0x99, 0xAC },
	0xFBEB, { 0xE7, 0xA6, 0xB3 },
	0xFBEC, { 0xE7, 0xB1, 0xA0 },
	0xFBED, { 0xE7, 0xB1, 0x9F },
	0xFBEE, { 0xE8, 0x81, 0xBE },
	0xFBEF, { 0xE8, 0x81, 0xBD },
	0xFBF0, { 0xE8, 0x87, 0x9F },
	0xFBF1, { 0xE8, 0xA5, 0xB2 },
	0xFBF2, { 0xE8, 0xA5, 0xAF },
	0xFBF3, { 0xE8, 0xA7, 0xBC },
	0xFBF4, { 0xE8, 0xAE, 0x80 },
	0xFBF5, { 0xE8, 0xB4, 0x96 },
	0xFBF6, { 0xE8, 0xB4, 0x97 },
	0xFBF7, { 0xE8, 0xBA, 0x91 },
	0xFBF8, { 0xE8, 0xBA, 0x93 },
	0xFBF9, { 0xE8, 0xBD, 0xA1 },
	0xFBFA, { 0xE9, 0x85, 0x88 },
	0xFBFB, { 0xE9, 0x91, 0x84 },
	0xFBFC, { 0xE9, 0x91, 0x91 },
	0xFBFD, { 0xE9, 0x91, 0x92 },
	0xFBFE, { 0xE9, 0x9C, 0xBD },
	0xFCA1, { 0xE9, 0x9C, 0xBE },
	0xFCA2, { 0xE9, 0x9F, 0x83 },
	0xFCA3, { 0xE9, 0x9F, 0x81 },
	0xFCA4, { 0xE9, 0xA1, 0xAB },
	0xFCA5, { 0xE9, 0xA5, 0x95 },
	0xFCA6, { 0xE9, 0xA9, 0x95 },
	0xFCA7, { 0xE9, 0xA9, 0x8D },
	0xFCA8, { 0xE9, 0xAB, 0x92 },
	0xFCA9, { 0xE9, 0xAC, 0x9A },
	0xFCAA, { 0xE9, 0xB1, 0x89 },
	0xFCAB, { 0xE9, 0xB0, 0xB1 },
	0xFCAC, { 0xE9, 0xB0, 0xBE },
	0xFCAD, { 0xE9, 0xB0, 0xBB },
	0xFCAE, { 0xE9, 0xB7, 0x93 },
	0xFCAF, { 0xE9, 0xB7, 0x97 },
	0xFCB0, { 0xE9, 0xBC, 0xB4 },
	0xFCB1, { 0xE9, 0xBD, 0xAC },
	0xFCB2, { 0xE9, 0xBD, 0xAA },
	0xFCB3, { 0xE9, 0xBE, 0x94 },
	0xFCB4, { 0xE5, 0x9B, 0x8C },
	0xFCB5, { 0xE5, 0xB7, 0x96 },
	0xFCB6, { 0xE6, 0x88, 0x80 },
	0xFCB7, { 0xE6, 0x94, 0xA3 },
	0xFCB8, { 0xE6, 0x94, 0xAB },
	0xFCB9, { 0xE6, 0x94, 0xAA },
	0xFCBA, { 0xE6, 0x9B, 0xAC },
	0xFCBB, { 0xE6, 0xAC, 0x90 },
	0xFCBC, { 0xE7, 0x93, 0x9A },
	0xFCBD, { 0xE7, 0xAB, 0x8A },
	0xFCBE, { 0xE7, 0xB1, 0xA4 },
	0xFCBF, { 0xE7, 0xB1, 0xA3 },
	0xFCC0, { 0xE7, 0xB1, 0xA5 },
	0xFCC1, { 0xE7, 0xBA, 0x93 },
	0xFCC2, { 0xE7, 0xBA, 0x96 },
	0xFCC3, { 0xE7, 0xBA, 0x94 },
	0xFCC4, { 0xE8, 0x87, 0xA2 },
	0xFCC5, { 0xE8, 0x98, 0xB8 },
	0xFCC6, { 0xE8, 0x98, 0xBF },
	0xFCC7, { 0xE8, 0xA0, 0xB1 },
	0xFCC8, { 0xE8, 0xAE, 0x8A },
	0xFCC9, { 0xE9, 0x82, 0x90 },
	0xFCCA, { 0xE9, 0x82, 0x8F },
	0xFCCB, { 0xE9, 0x91, 0xA3 },
	0xFCCC, { 0xE9, 0x91, 0xA0 },
	0xFCCD, { 0xE9, 0x91, 0xA4 },
	0xFCCE, { 0xE9, 0x9D, 0xA8 },
	0xFCCF, { 0xE9, 0xA1, 0xAF },
	0xFCD0, { 0xE9, 0xA5, 0x9C },
	0xFCD1, { 0xE9, 0xA9, 0x9A },
	0xFCD2, { 0xE9, 0xA9, 0x9B },
	0xFCD3, { 0xE9, 0xA9, 0x97 },
	0xFCD4, { 0xE9, 0xAB, 0x93 },
	0xFCD5, { 0xE9, 0xAB, 0x94 },
	0xFCD6, { 0xE9, 0xAB, 0x91 },
	0xFCD7, { 0xE9, 0xB1, 0x94 },
	0xFCD8, { 0xE9, 0xB1, 0x97 },
	0xFCD9, { 0xE9, 0xB1, 0x96 },
	0xFCDA, { 0xE9, 0xB7, 0xA5 },
	0xFCDB, { 0xE9, 0xBA, 0x9F },
	0xFCDC, { 0xE9, 0xBB, 0xB4 },
	0xFCDD, { 0xE5, 0x9B, 0x91 },
	0xFCDE, { 0xE5, 0xA3, 0xA9 },
	0xFCDF, { 0xE6, 0x94, 0xAC },
	0xFCE0, { 0xE7, 0x81, 0x9E },
	0xFCE1, { 0xE7, 0x99, 0xB1 },
	0xFCE2, { 0xE7, 0x99, 0xB2 },
	0xFCE3, { 0xE7, 0x9F, 0x97 },
	0xFCE4, { 0xE7, 0xBD, 0x90 },
	0xFCE5, { 0xE7, 0xBE, 0x88 },
	0xFCE6, { 0xE8, 0xA0, 0xB6 },
	0xFCE7, { 0xE8, 0xA0, 0xB9 },
	0xFCE8, { 0xE8, 0xA1, 0xA2 },
	0xFCE9, { 0xE8, 0xAE, 0x93 },
	0xFCEA, { 0xE8, 0xAE, 0x92 },
	0xFCEB, { 0xE8, 0xAE, 0x96 },
	0xFCEC, { 0xE8, 0x89, 0xB7 },
	0xFCED, { 0xE8, 0xB4, 0x9B },
	0xFCEE, { 0xE9, 0x87, 0x80 },
	0xFCEF, { 0xE9, 0x91, 0xAA },
	0xFCF0, { 0xE9, 0x9D, 0x82 },
	0xFCF1, { 0xE9, 0x9D, 0x88 },
	0xFCF2, { 0xE9, 0x9D, 0x84 },
	0xFCF3, { 0xE9, 0x9F, 0x86 },
	0xFCF4, { 0xE9, 0xA1, 0xB0 },
	0xFCF5, { 0xE9, 0xA9, 0x9F },
	0xFCF6, { 0xE9, 0xAC, 0xA2 },
	0xFCF7, { 0xE9, 0xAD, 0x98 },
	0xFCF8, { 0xE9, 0xB1, 0x9F },
	0xFCF9, { 0xE9, 0xB7, 0xB9 },
	0xFCFA, { 0xE9, 0xB7, 0xBA },
	0xFCFB, { 0xE9, 0xB9, 0xBC },
	0xFCFC, { 0xE9, 0xB9, 0xBD },
	0xFCFD, { 0xE9, 0xBC, 0x87 },
	0xFCFE, { 0xE9, 0xBD, 0xB7 },
	0xFDA1, { 0xE9, 0xBD, 0xB2 },
	0xFDA2, { 0xE5, 0xBB, 0xB3 },
	0xFDA3, { 0xE6, 0xAC, 0x96 },
	0xFDA4, { 0xE7, 0x81, 0xA3 },
	0xFDA5, { 0xE7, 0xB1, 0xAC },
	0xFDA6, { 0xE7, 0xB1, 0xAE },
	0xFDA7, { 0xE8, 0xA0, 0xBB },
	0xFDA8, { 0xE8, 0xA7, 0x80 },
	0xFDA9, { 0xE8, 0xBA, 0xA1 },
	0xFDAA, { 0xE9, 0x87, 0x81 },
	0xFDAB, { 0xE9, 0x91, 0xB2 },
	0xFDAC, { 0xE9, 0x91, 0xB0 },
	0xFDAD, { 0xE9, 0xA1, 0xB1 },
	0xFDAE, { 0xE9, 0xA5, 0x9E },
	0xFDAF, { 0xE9, 0xAB, 0x96 },
	0xFDB0, { 0xE9, 0xAC, 0xA3 },
	0xFDB1, { 0xE9, 0xBB, 0x8C },
	0xFDB2, { 0xE7, 0x81, 0xA4 },
	0xFDB3, { 0xE7, 0x9F, 0x9A },
	0xFDB4, { 0xE8, 0xAE, 0x9A },
	0xFDB5, { 0xE9, 0x91, 0xB7 },
	0xFDB6, { 0xE9, 0x9F, 0x89 },
	0xFDB7, { 0xE9, 0xA9, 0xA2 },
	0xFDB8, { 0xE9, 0xA9, 0xA5 },
	0xFDB9, { 0xE7, 0xBA, 0x9C },
	0xFDBA, { 0xE8, 0xAE, 0x9C },
	0xFDBB, { 0xE8, 0xBA, 0xAA },
	0xFDBC, { 0xE9, 0x87, 0x85 },
	0xFDBD, { 0xE9, 0x91, 0xBD },
	0xFDBE, { 0xE9, 0x91, 0xBE },
	0xFDBF, { 0xE9, 0x91, 0xBC },
	0xFDC0, { 0xE9, 0xB1, 0xB7 },
	0xFDC1, { 0xE9, 0xB1, 0xB8 },
	0xFDC2, { 0xE9, 0xBB, 0xB7 },
	0xFDC3, { 0xE8, 0xB1, 0x94 },
	0xFDC4, { 0xE9, 0x91, 0xBF },
	0xFDC5, { 0xE9, 0xB8, 0x9A },
	0xFDC6, { 0xE7, 0x88, 0xA8 },
	0xFDC7, { 0xE9, 0xA9, 0xAA },
	0xFDC8, { 0xE9, 0xAC, 0xB1 },
	0xFDC9, { 0xE9, 0xB8, 0x9B },
	0xFDCA, { 0xE9, 0xB8, 0x9E },
	0xFDCB, { 0xE7, 0xB1, 0xB2 }
};

/* Conversion table from CNS 11643 plane #2 to UTF-8. */
static kiconv_table_array_t kiconv_cns2_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0xA1A1, { 0xE4, 0xB9, 0x82 },
	0xA1A2, { 0xE4, 0xB9, 0x9C },
	0xA1A3, { 0xE5, 0x87, 0xB5 },
	0xA1A4, { 0xE5, 0x8C, 0x9A },
	0xA1A5, { 0xE5, 0x8E, 0x82 },
	0xA1A6, { 0xE4, 0xB8, 0x87 },
	0xA1A7, { 0xE4, 0xB8, 0x8C },
	0xA1A8, { 0xE4, 0xB9, 0x87 },
	0xA1A9, { 0xE4, 0xBA, 0x8D },
	0xA1AA, { 0xE5, 0x9B, 0x97 },
	0xA1AB, { 0xE5, 0xB1, 0xAE },
	0xA1AC, { 0xE5, 0xBD, 0xB3 },
	0xA1AD, { 0xE4, 0xB8, 0x8F },
	0xA1AE, { 0xE5, 0x86, 0x87 },
	0xA1AF, { 0xE4, 0xB8, 0x8E },
	0xA1B0, { 0xE4, 0xB8, 0xAE },
	0xA1B1, { 0xE4, 0xBA, 0x93 },
	0xA1B2, { 0xE4, 0xBB, 0x82 },
	0xA1B3, { 0xE4, 0xBB, 0x89 },
	0xA1B4, { 0xE4, 0xBB, 0x88 },
	0xA1B5, { 0xE5, 0x86, 0x98 },
	0xA1B6, { 0xE5, 0x8B, 0xBC },
	0xA1B7, { 0xE5, 0x8D, 0xAC },
	0xA1B8, { 0xE5, 0x8E, 0xB9 },
	0xA1B9, { 0xE5, 0x9C, 0xA0 },
	0xA1BA, { 0xE5, 0xA4, 0x83 },
	0xA1BB, { 0xE5, 0xA4, 0xAC },
	0xA1BC, { 0xE5, 0xB0, 0x90 },
	0xA1BD, { 0xE5, 0xB7, 0xBF },
	0xA1BE, { 0xE6, 0x97, 0xA1 },
	0xA1BF, { 0xE6, 0xAE, 0xB3 },
	0xA1C0, { 0xE6, 0xAF, 0x8C },
	0xA1C1, { 0xE6, 0xB0, 0x94 },
	0xA1C2, { 0xE7, 0x88, 0xBF },
	0xA1C3, { 0xE4, 0xB8, 0xB1 },
	0xA1C4, { 0xE4, 0xB8, 0xBC },
	0xA1C5, { 0xE4, 0xBB, 0xA8 },
	0xA1C6, { 0xE4, 0xBB, 0x9C },
	0xA1C7, { 0xE4, 0xBB, 0xA9 },
	0xA1C8, { 0xE4, 0xBB, 0xA1 },
	0xA1C9, { 0xE4, 0xBB, 0x9D },
	0xA1CA, { 0xE4, 0xBB, 0x9A },
	0xA1CB, { 0xE5, 0x88, 0x8C },
	0xA1CC, { 0xE5, 0x88, 0x89 },
	0xA1CD, { 0xE5, 0x8C, 0x9C },
	0xA1CE, { 0xE5, 0x8D, 0x8C },
	0xA1CF, { 0xE5, 0x9C, 0xA2 },
	0xA1D0, { 0xE5, 0x9C, 0xA3 },
	0xA1D1, { 0xE5, 0xA4, 0x97 },
	0xA1D2, { 0xE5, 0xA4, 0xAF },
	0xA1D3, { 0xE5, 0xAE, 0x81 },
	0xA1D4, { 0xE5, 0xAE, 0x84 },
	0xA1D5, { 0xE5, 0xB0, 0x92 },
	0xA1D6, { 0xE5, 0xB0, 0xBB },
	0xA1D7, { 0xE5, 0xB1, 0xB4 },
	0xA1D8, { 0xE5, 0xB1, 0xB3 },
	0xA1D9, { 0xE5, 0xB8, 0x84 },
	0xA1DA, { 0xE5, 0xBA, 0x80 },
	0xA1DB, { 0xE5, 0xBA, 0x82 },
	0xA1DC, { 0xE5, 0xBF, 0x89 },
	0xA1DD, { 0xE6, 0x88, 0x89 },
	0xA1DE, { 0xE6, 0x89, 0x90 },
	0xA1DF, { 0xE6, 0xB0, 0x95 },
	0xA1E0, { 0xE6, 0xB0, 0xB6 },
	0xA1E1, { 0xE6, 0xB1, 0x83 },
	0xA1E2, { 0xE6, 0xB0, 0xBF },
	0xA1E3, { 0xE6, 0xB0, 0xBB },
	0xA1E4, { 0xE7, 0x8A, 0xAE },
	0xA1E5, { 0xE7, 0x8A, 0xB0 },
	0xA1E6, { 0xE7, 0x8E, 0x8A },
	0xA1E7, { 0xE7, 0xA6, 0xB8 },
	0xA1E8, { 0xE8, 0x82, 0x8A },
	0xA1E9, { 0xE9, 0x98, 0x9E },
	0xA1EA, { 0xE4, 0xBC, 0x8E },
	0xA1EB, { 0xE4, 0xBC, 0x98 },
	0xA1EC, { 0xE4, 0xBC, 0xAC },
	0xA1ED, { 0xE4, 0xBB, 0xB5 },
	0xA1EE, { 0xE4, 0xBC, 0x94 },
	0xA1EF, { 0xE4, 0xBB, 0xB1 },
	0xA1F0, { 0xE4, 0xBC, 0x80 },
	0xA1F1, { 0xE4, 0xBB, 0xB7 },
	0xA1F2, { 0xE4, 0xBC, 0x88 },
	0xA1F3, { 0xE4, 0xBC, 0x9D },
	0xA1F4, { 0xE4, 0xBC, 0x82 },
	0xA1F5, { 0xE4, 0xBC, 0x85 },
	0xA1F6, { 0xE4, 0xBC, 0xA2 },
	0xA1F7, { 0xE4, 0xBC, 0x93 },
	0xA1F8, { 0xE4, 0xBC, 0x84 },
	0xA1F9, { 0xE4, 0xBB, 0xB4 },
	0xA1FA, { 0xE4, 0xBC, 0x92 },
	0xA1FB, { 0xE5, 0x86, 0xB1 },
	0xA1FC, { 0xE5, 0x88, 0x93 },
	0xA1FD, { 0xE5, 0x88, 0x90 },
	0xA1FE, { 0xE5, 0x8A, 0xA6 },
	0xA2A1, { 0xE5, 0x8C, 0xA2 },
	0xA2A2, { 0xE5, 0x8C, 0x9F },
	0xA2A3, { 0xE5, 0x8D, 0x8D },
	0xA2A4, { 0xE5, 0x8E, 0x8A },
	0xA2A5, { 0xE5, 0x90, 0x87 },
	0xA2A6, { 0xE5, 0x9B, 0xA1 },
	0xA2A7, { 0xE5, 0x9B, 0x9F },
	0xA2A8, { 0xE5, 0x9C, 0xAE },
	0xA2A9, { 0xE5, 0x9C, 0xAA },
	0xA2AA, { 0xE5, 0x9C, 0xB4 },
	0xA2AB, { 0xE5, 0xA4, 0xBC },
	0xA2AC, { 0xE5, 0xA6, 0x80 },
	0xA2AD, { 0xE5, 0xA5, 0xBC },
	0xA2AE, { 0xE5, 0xA6, 0x85 },
	0xA2AF, { 0xE5, 0xA5, 0xBB },
	0xA2B0, { 0xE5, 0xA5, 0xBE },
	0xA2B1, { 0xE5, 0xA5, 0xB7 },
	0xA2B2, { 0xE5, 0xA5, 0xBF },
	0xA2B3, { 0xE5, 0xAD, 0x96 },
	0xA2B4, { 0xE5, 0xB0, 0x95 },
	0xA2B5, { 0xE5, 0xB0, 0xA5 },
	0xA2B6, { 0xE5, 0xB1, 0xBC },
	0xA2B7, { 0xE5, 0xB1, 0xBA },
	0xA2B8, { 0xE5, 0xB1, 0xBB },
	0xA2B9, { 0xE5, 0xB1, 0xBE },
	0xA2BA, { 0xE5, 0xB7, 0x9F },
	0xA2BB, { 0xE5, 0xB9, 0xB5 },
	0xA2BC, { 0xE5, 0xBA, 0x84 },
	0xA2BD, { 0xE5, 0xBC, 0x82 },
	0xA2BE, { 0xE5, 0xBC, 0x9A },
	0xA2BF, { 0xE5, 0xBD, 0xB4 },
	0xA2C0, { 0xE5, 0xBF, 0x95 },
	0xA2C1, { 0xE5, 0xBF, 0x94 },
	0xA2C2, { 0xE5, 0xBF, 0x8F },
	0xA2C3, { 0xE6, 0x89, 0x9C },
	0xA2C4, { 0xE6, 0x89, 0x9E },
	0xA2C5, { 0xE6, 0x89, 0xA4 },
	0xA2C6, { 0xE6, 0x89, 0xA1 },
	0xA2C7, { 0xE6, 0x89, 0xA6 },
	0xA2C8, { 0xE6, 0x89, 0xA2 },
	0xA2C9, { 0xE6, 0x89, 0x99 },
	0xA2CA, { 0xE6, 0x89, 0xA0 },
	0xA2CB, { 0xE6, 0x89, 0x9A },
	0xA2CC, { 0xE6, 0x89, 0xA5 },
	0xA2CD, { 0xE6, 0x94, 0xB7 },
	0xA2CE, { 0xE6, 0x97, 0xAF },
	0xA2CF, { 0xE6, 0x97, 0xAE },
	0xA2D0, { 0xE6, 0x9C, 0xBE },
	0xA2D1, { 0xE6, 0x9C, 0xB9 },
	0xA2D2, { 0xE6, 0x9C, 0xB8 },
	0xA2D3, { 0xE6, 0x9C, 0xBB },
	0xA2D4, { 0xE6, 0x9C, 0xBA },
	0xA2D5, { 0xE6, 0x9C, 0xBF },
	0xA2D6, { 0xE6, 0x9C, 0xBC },
	0xA2D7, { 0xE6, 0x9C, 0xB3 },
	0xA2D8, { 0xE6, 0xB0, 0x98 },
	0xA2D9, { 0xE6, 0xB1, 0x86 },
	0xA2DA, { 0xE6, 0xB1, 0x92 },
	0xA2DB, { 0xE6, 0xB1, 0x9C },
	0xA2DC, { 0xE6, 0xB1, 0x8F },
	0xA2DD, { 0xE6, 0xB1, 0x8A },
	0xA2DE, { 0xE6, 0xB1, 0x94 },
	0xA2DF, { 0xE6, 0xB1, 0x8B },
	0xA2E0, { 0xE6, 0xB1, 0x8C },
	0xA2E1, { 0xE7, 0x81, 0xB1 },
	0xA2E2, { 0xE7, 0x89, 0x9E },
	0xA2E3, { 0xE7, 0x8A, 0xB4 },
	0xA2E4, { 0xE7, 0x8A, 0xB5 },
	0xA2E5, { 0xE7, 0x8E, 0x8E },
	0xA2E6, { 0xE7, 0x94, 0xAA },
	0xA2E7, { 0xE7, 0x99, 0xBF },
	0xA2E8, { 0xE7, 0xA9, 0xB5 },
	0xA2E9, { 0xE7, 0xBD, 0x91 },
	0xA2EA, { 0xE8, 0x89, 0xB8 },
	0xA2EB, { 0xE8, 0x89, 0xBC },
	0xA2EC, { 0xE8, 0x8A, 0x80 },
	0xA2ED, { 0xE8, 0x89, 0xBD },
	0xA2EE, { 0xE8, 0x89, 0xBF },
	0xA2EF, { 0xE8, 0x99, 0x8D },
	0xA2F0, { 0xE8, 0xA5, 0xBE },
	0xA2F1, { 0xE9, 0x82, 0x99 },
	0xA2F2, { 0xE9, 0x82, 0x97 },
	0xA2F3, { 0xE9, 0x82, 0x98 },
	0xA2F4, { 0xE9, 0x82, 0x9B },
	0xA2F5, { 0xE9, 0x82, 0x94 },
	0xA2F6, { 0xE9, 0x98, 0xA2 },
	0xA2F7, { 0xE9, 0x98, 0xA4 },
	0xA2F8, { 0xE9, 0x98, 0xA0 },
	0xA2F9, { 0xE9, 0x98, 0xA3 },
	0xA2FA, { 0xE4, 0xBD, 0x96 },
	0xA2FB, { 0xE4, 0xBC, 0xBB },
	0xA2FC, { 0xE4, 0xBD, 0xA2 },
	0xA2FD, { 0xE4, 0xBD, 0x89 },
	0xA2FE, { 0xE4, 0xBD, 0x93 },
	0xA3A1, { 0xE4, 0xBD, 0xA4 },
	0xA3A2, { 0xE4, 0xBC, 0xBE },
	0xA3A3, { 0xE4, 0xBD, 0xA7 },
	0xA3A4, { 0xE4, 0xBD, 0x92 },
	0xA3A5, { 0xE4, 0xBD, 0x9F },
	0xA3A6, { 0xE4, 0xBD, 0x81 },
	0xA3A7, { 0xE4, 0xBD, 0x98 },
	0xA3A8, { 0xE4, 0xBC, 0xAD },
	0xA3A9, { 0xE4, 0xBC, 0xB3 },
	0xA3AA, { 0xE4, 0xBC, 0xBF },
	0xA3AB, { 0xE4, 0xBD, 0xA1 },
	0xA3AC, { 0xE5, 0x86, 0x8F },
	0xA3AD, { 0xE5, 0x86, 0xB9 },
	0xA3AE, { 0xE5, 0x88, 0x9C },
	0xA3AF, { 0xE5, 0x88, 0x9E },
	0xA3B0, { 0xE5, 0x88, 0xA1 },
	0xA3B1, { 0xE5, 0x8A, 0xAD },
	0xA3B2, { 0xE5, 0x8A, 0xAE },
	0xA3B3, { 0xE5, 0x8C, 0x89 },
	0xA3B4, { 0xE5, 0x8D, 0xA3 },
	0xA3B5, { 0xE5, 0x8D, 0xB2 },
	0xA3B6, { 0xE5, 0x8E, 0x8E },
	0xA3B7, { 0xE5, 0x8E, 0x8F },
	0xA3B8, { 0xE5, 0x90, 0xB0 },
	0xA3B9, { 0xE5, 0x90, 0xB7 },
	0xA3BA, { 0xE5, 0x90, 0xAA },
	0xA3BB, { 0xE5, 0x91, 0x94 },
	0xA3BC, { 0xE5, 0x91, 0x85 },
	0xA3BD, { 0xE5, 0x90, 0x99 },
	0xA3BE, { 0xE5, 0x90, 0x9C },
	0xA3BF, { 0xE5, 0x90, 0xA5 },
	0xA3C0, { 0xE5, 0x90, 0x98 },
	0xA3C1, { 0xE5, 0x90, 0xBD },
	0xA3C2, { 0xE5, 0x91, 0x8F },
	0xA3C3, { 0xE5, 0x91, 0x81 },
	0xA3C4, { 0xE5, 0x90, 0xA8 },
	0xA3C5, { 0xE5, 0x90, 0xA4 },
	0xA3C6, { 0xE5, 0x91, 0x87 },
	0xA3C7, { 0xE5, 0x9B, 0xAE },
	0xA3C8, { 0xE5, 0x9B, 0xA7 },
	0xA3C9, { 0xE5, 0x9B, 0xA5 },
	0xA3CA, { 0xE5, 0x9D, 0x81 },
	0xA3CB, { 0xE5, 0x9D, 0x85 },
	0xA3CC, { 0xE5, 0x9D, 0x8C },
	0xA3CD, { 0xE5, 0x9D, 0x89 },
	0xA3CE, { 0xE5, 0x9D, 0x8B },
	0xA3CF, { 0xE5, 0x9D, 0x92 },
	0xA3D0, { 0xE5, 0xA4, 0x86 },
	0xA3D1, { 0xE5, 0xA5, 0x80 },
	0xA3D2, { 0xE5, 0xA6, 0xA6 },
	0xA3D3, { 0xE5, 0xA6, 0x98 },
	0xA3D4, { 0xE5, 0xA6, 0xA0 },
	0xA3D5, { 0xE5, 0xA6, 0x97 },
	0xA3D6, { 0xE5, 0xA6, 0x8E },
	0xA3D7, { 0xE5, 0xA6, 0xA2 },
	0xA3D8, { 0xE5, 0xA6, 0x90 },
	0xA3D9, { 0xE5, 0xA6, 0x8F },
	0xA3DA, { 0xE5, 0xA6, 0xA7 },
	0xA3DB, { 0xE5, 0xA6, 0xA1 },
	0xA3DC, { 0xE5, 0xAE, 0x8E },
	0xA3DD, { 0xE5, 0xAE, 0x92 },
	0xA3DE, { 0xE5, 0xB0, 0xA8 },
	0xA3DF, { 0xE5, 0xB0, 0xAA },
	0xA3E0, { 0xE5, 0xB2, 0x8D },
	0xA3E1, { 0xE5, 0xB2, 0x8F },
	0xA3E2, { 0xE5, 0xB2, 0x88 },
	0xA3E3, { 0xE5, 0xB2, 0x8B },
	0xA3E4, { 0xE5, 0xB2, 0x89 },
	0xA3E5, { 0xE5, 0xB2, 0x92 },
	0xA3E6, { 0xE5, 0xB2, 0x8A },
	0xA3E7, { 0xE5, 0xB2, 0x86 },
	0xA3E8, { 0xE5, 0xB2, 0x93 },
	0xA3E9, { 0xE5, 0xB2, 0x95 },
	0xA3EA, { 0xE5, 0xB7, 0xA0 },
	0xA3EB, { 0xE5, 0xB8, 0x8A },
	0xA3EC, { 0xE5, 0xB8, 0x8E },
	0xA3ED, { 0xE5, 0xBA, 0x8B },
	0xA3EE, { 0xE5, 0xBA, 0x89 },
	0xA3EF, { 0xE5, 0xBA, 0x8C },
	0xA3F0, { 0xE5, 0xBA, 0x88 },
	0xA3F1, { 0xE5, 0xBA, 0x8D },
	0xA3F2, { 0xE5, 0xBC, 0x85 },
	0xA3F3, { 0xE5, 0xBC, 0x9D },
	0xA3F4, { 0xE5, 0xBD, 0xB8 },
	0xA3F5, { 0xE5, 0xBD, 0xB6 },
	0xA3F6, { 0xE5, 0xBF, 0x92 },
	0xA3F7, { 0xE5, 0xBF, 0x91 },
	0xA3F8, { 0xE5, 0xBF, 0x90 },
	0xA3F9, { 0xE5, 0xBF, 0xAD },
	0xA3FA, { 0xE5, 0xBF, 0xA8 },
	0xA3FB, { 0xE5, 0xBF, 0xAE },
	0xA3FC, { 0xE5, 0xBF, 0xB3 },
	0xA3FD, { 0xE5, 0xBF, 0xA1 },
	0xA3FE, { 0xE5, 0xBF, 0xA4 },
	0xA4A1, { 0xE5, 0xBF, 0xA3 },
	0xA4A2, { 0xE5, 0xBF, 0xBA },
	0xA4A3, { 0xE5, 0xBF, 0xAF },
	0xA4A4, { 0xE5, 0xBF, 0xB7 },
	0xA4A5, { 0xE5, 0xBF, 0xBB },
	0xA4A6, { 0xE6, 0x80, 0x80 },
	0xA4A7, { 0xE5, 0xBF, 0xB4 },
	0xA4A8, { 0xE6, 0x88, 0xBA },
	0xA4A9, { 0xE6, 0x8A, 0x83 },
	0xA4AA, { 0xE6, 0x8A, 0x8C },
	0xA4AB, { 0xE6, 0x8A, 0x8E },
	0xA4AC, { 0xE6, 0x8A, 0x8F },
	0xA4AD, { 0xE6, 0x8A, 0x94 },
	0xA4AE, { 0xE6, 0x8A, 0x87 },
	0xA4AF, { 0xE6, 0x89, 0xB1 },
	0xA4B0, { 0xE6, 0x89, 0xBB },
	0xA4B1, { 0xE6, 0x89, 0xBA },
	0xA4B2, { 0xE6, 0x89, 0xB0 },
	0xA4B3, { 0xE6, 0x8A, 0x81 },
	0xA4B4, { 0xE6, 0x8A, 0x88 },
	0xA4B5, { 0xE6, 0x89, 0xB7 },
	0xA4B6, { 0xE6, 0x89, 0xBD },
	0xA4B7, { 0xE6, 0x89, 0xB2 },
	0xA4B8, { 0xE6, 0x89, 0xB4 },
	0xA4B9, { 0xE6, 0x97, 0xB0 },
	0xA4BA, { 0xE6, 0x97, 0xB4 },
	0xA4BB, { 0xE6, 0x97, 0xB3 },
	0xA4BC, { 0xE6, 0x97, 0xB2 },
	0xA4BD, { 0xE6, 0x97, 0xB5 },
	0xA4BE, { 0xE6, 0x9D, 0x85 },
	0xA4BF, { 0xE6, 0x9D, 0x87 },
	0xA4C0, { 0xE6, 0x9D, 0x99 },
	0xA4C1, { 0xE6, 0x9D, 0x95 },
	0xA4C2, { 0xE6, 0x9D, 0x8C },
	0xA4C3, { 0xE6, 0x9D, 0x88 },
	0xA4C4, { 0xE6, 0x9D, 0x9D },
	0xA4C5, { 0xE6, 0x9D, 0x8D },
	0xA4C6, { 0xE6, 0x9D, 0x9A },
	0xA4C7, { 0xE6, 0x9D, 0x8B },
	0xA4C8, { 0xE6, 0xAF, 0x90 },
	0xA4C9, { 0xE6, 0xB0, 0x99 },
	0xA4CA, { 0xE6, 0xB0, 0x9A },
	0xA4CB, { 0xE6, 0xB1, 0xB8 },
	0xA4CC, { 0xE6, 0xB1, 0xA7 },
	0xA4CD, { 0xE6, 0xB1, 0xAB },
	0xA4CE, { 0xE6, 0xB2, 0x84 },
	0xA4CF, { 0xE6, 0xB2, 0x8B },
	0xA4D0, { 0xE6, 0xB2, 0x8F },
	0xA4D1, { 0xE6, 0xB1, 0xB1 },
	0xA4D2, { 0xE6, 0xB1, 0xAF },
	0xA4D3, { 0xE6, 0xB1, 0xA9 },
	0xA4D4, { 0xE6, 0xB2, 0x9A },
	0xA4D5, { 0xE6, 0xB1, 0xAD },
	0xA4D6, { 0xE6, 0xB2, 0x87 },
	0xA4D7, { 0xE6, 0xB2, 0x95 },
	0xA4D8, { 0xE6, 0xB2, 0x9C },
	0xA4D9, { 0xE6, 0xB1, 0xA6 },
	0xA4DA, { 0xE6, 0xB1, 0xB3 },
	0xA4DB, { 0xE6, 0xB1, 0xA5 },
	0xA4DC, { 0xE6, 0xB1, 0xBB },
	0xA4DD, { 0xE6, 0xB2, 0x8E },
	0xA4DE, { 0xE7, 0x81, 0xB4 },
	0xA4DF, { 0xE7, 0x81, 0xBA },
	0xA4E0, { 0xE7, 0x89, 0xA3 },
	0xA4E1, { 0xE7, 0x8A, 0xBF },
	0xA4E2, { 0xE7, 0x8A, 0xBD },
	0xA4E3, { 0xE7, 0x8B, 0x83 },
	0xA4E4, { 0xE7, 0x8B, 0x86 },
	0xA4E5, { 0xE7, 0x8B, 0x81 },
	0xA4E6, { 0xE7, 0x8A, 0xBA },
	0xA4E7, { 0xE7, 0x8B, 0x85 },
	0xA4E8, { 0xE7, 0x8E, 0x95 },
	0xA4E9, { 0xE7, 0x8E, 0x97 },
	0xA4EA, { 0xE7, 0x8E, 0x93 },
	0xA4EB, { 0xE7, 0x8E, 0x94 },
	0xA4EC, { 0xE7, 0x8E, 0x92 },
	0xA4ED, { 0xE7, 0x94, 0xBA },
	0xA4EE, { 0xE7, 0x94, 0xB9 },
	0xA4EF, { 0xE7, 0x96, 0x94 },
	0xA4F0, { 0xE7, 0x96, 0x95 },
	0xA4F1, { 0xE7, 0x9A, 0x81 },
	0xA4F2, { 0xE7, 0xA4, 0xBD },
	0xA4F3, { 0xE8, 0x80, 0xB4 },
	0xA4F4, { 0xE8, 0x82, 0x95 },
	0xA4F5, { 0xE8, 0x82, 0x99 },
	0xA4F6, { 0xE8, 0x82, 0x90 },
	0xA4F7, { 0xE8, 0x82, 0x92 },
	0xA4F8, { 0xE8, 0x82, 0x9C },
	0xA4F9, { 0xE8, 0x8A, 0x90 },
	0xA4FA, { 0xE8, 0x8A, 0x8F },
	0xA4FB, { 0xE8, 0x8A, 0x85 },
	0xA4FC, { 0xE8, 0x8A, 0x8E },
	0xA4FD, { 0xE8, 0x8A, 0x91 },
	0xA4FE, { 0xE8, 0x8A, 0x93 },
	0xA5A1, { 0xE8, 0x8A, 0x8A },
	0xA5A2, { 0xE8, 0x8A, 0x83 },
	0xA5A3, { 0xE8, 0x8A, 0x84 },
	0xA5A4, { 0xE8, 0xB1, 0xB8 },
	0xA5A5, { 0xE8, 0xBF, 0x89 },
	0xA5A6, { 0xE8, 0xBE, 0xBF },
	0xA5A7, { 0xE9, 0x82, 0x9F },
	0xA5A8, { 0xE9, 0x82, 0xA1 },
	0xA5A9, { 0xE9, 0x82, 0xA5 },
	0xA5AA, { 0xE9, 0x82, 0x9E },
	0xA5AB, { 0xE9, 0x82, 0xA7 },
	0xA5AC, { 0xE9, 0x82, 0xA0 },
	0xA5AD, { 0xE9, 0x98, 0xB0 },
	0xA5AE, { 0xE9, 0x98, 0xA8 },
	0xA5AF, { 0xE9, 0x98, 0xAF },
	0xA5B0, { 0xE9, 0x98, 0xAD },
	0xA5B1, { 0xE4, 0xB8, 0xB3 },
	0xA5B2, { 0xE4, 0xBE, 0x98 },
	0xA5B3, { 0xE4, 0xBD, 0xBC },
	0xA5B4, { 0xE4, 0xBE, 0x85 },
	0xA5B5, { 0xE4, 0xBD, 0xBD },
	0xA5B6, { 0xE4, 0xBE, 0x80 },
	0xA5B7, { 0xE4, 0xBE, 0x87 },
	0xA5B8, { 0xE4, 0xBD, 0xB6 },
	0xA5B9, { 0xE4, 0xBD, 0xB4 },
	0xA5BA, { 0xE4, 0xBE, 0x89 },
	0xA5BB, { 0xE4, 0xBE, 0x84 },
	0xA5BC, { 0xE4, 0xBD, 0xB7 },
	0xA5BD, { 0xE4, 0xBD, 0x8C },
	0xA5BE, { 0xE4, 0xBE, 0x97 },
	0xA5BF, { 0xE4, 0xBD, 0xAA },
	0xA5C0, { 0xE4, 0xBE, 0x9A },
	0xA5C1, { 0xE4, 0xBD, 0xB9 },
	0xA5C2, { 0xE4, 0xBE, 0x81 },
	0xA5C3, { 0xE4, 0xBD, 0xB8 },
	0xA5C4, { 0xE4, 0xBE, 0x90 },
	0xA5C5, { 0xE4, 0xBE, 0x9C },
	0xA5C6, { 0xE4, 0xBE, 0x94 },
	0xA5C7, { 0xE4, 0xBE, 0x9E },
	0xA5C8, { 0xE4, 0xBE, 0x92 },
	0xA5C9, { 0xE4, 0xBE, 0x82 },
	0xA5CA, { 0xE4, 0xBE, 0x95 },
	0xA5CB, { 0xE4, 0xBD, 0xAB },
	0xA5CC, { 0xE4, 0xBD, 0xAE },
	0xA5CD, { 0xE5, 0x86, 0x9E },
	0xA5CE, { 0xE5, 0x86, 0xBC },
	0xA5CF, { 0xE5, 0x86, 0xBE },
	0xA5D0, { 0xE5, 0x88, 0xB5 },
	0xA5D1, { 0xE5, 0x88, 0xB2 },
	0xA5D2, { 0xE5, 0x88, 0xB3 },
	0xA5D3, { 0xE5, 0x89, 0x86 },
	0xA5D4, { 0xE5, 0x88, 0xB1 },
	0xA5D5, { 0xE5, 0x8A, 0xBC },
	0xA5D6, { 0xE5, 0x8C, 0x8A },
	0xA5D7, { 0xE5, 0x8C, 0x8B },
	0xA5D8, { 0xE5, 0x8C, 0xBC },
	0xA5D9, { 0xE5, 0x8E, 0x92 },
	0xA5DA, { 0xE5, 0x8E, 0x94 },
	0xA5DB, { 0xE5, 0x92, 0x87 },
	0xA5DC, { 0xE5, 0x91, 0xBF },
	0xA5DD, { 0xE5, 0x92, 0x81 },
	0xA5DE, { 0xE5, 0x92, 0x91 },
	0xA5DF, { 0xE5, 0x92, 0x82 },
	0xA5E0, { 0xE5, 0x92, 0x88 },
	0xA5E1, { 0xE5, 0x91, 0xAB },
	0xA5E2, { 0xE5, 0x91, 0xBA },
	0xA5E3, { 0xE5, 0x91, 0xBE },
	0xA5E4, { 0xE5, 0x91, 0xA5 },
	0xA5E5, { 0xE5, 0x91, 0xAC },
	0xA5E6, { 0xE5, 0x91, 0xB4 },
	0xA5E7, { 0xE5, 0x91, 0xA6 },
	0xA5E8, { 0xE5, 0x92, 0x8D },
	0xA5E9, { 0xE5, 0x91, 0xAF },
	0xA5EA, { 0xE5, 0x91, 0xA1 },
	0xA5EB, { 0xE5, 0x91, 0xA0 },
	0xA5EC, { 0xE5, 0x92, 0x98 },
	0xA5ED, { 0xE5, 0x91, 0xA3 },
	0xA5EE, { 0xE5, 0x91, 0xA7 },
	0xA5EF, { 0xE5, 0x91, 0xA4 },
	0xA5F0, { 0xE5, 0x9B, 0xB7 },
	0xA5F1, { 0xE5, 0x9B, 0xB9 },
	0xA5F2, { 0xE5, 0x9D, 0xAF },
	0xA5F3, { 0xE5, 0x9D, 0xB2 },
	0xA5F4, { 0xE5, 0x9D, 0xAD },
	0xA5F5, { 0xE5, 0x9D, 0xAB },
	0xA5F6, { 0xE5, 0x9D, 0xB1 },
	0xA5F7, { 0xE5, 0x9D, 0xB0 },
	0xA5F8, { 0xE5, 0x9D, 0xB6 },
	0xA5F9, { 0xE5, 0x9E, 0x80 },
	0xA5FA, { 0xE5, 0x9D, 0xB5 },
	0xA5FB, { 0xE5, 0x9D, 0xBB },
	0xA5FC, { 0xE5, 0x9D, 0xB3 },
	0xA5FD, { 0xE5, 0x9D, 0xB4 },
	0xA5FE, { 0xE5, 0x9D, 0xA2 },
	0xA6A1, { 0xE5, 0x9D, 0xA8 },
	0xA6A2, { 0xE5, 0x9D, 0xBD },
	0xA6A3, { 0xE5, 0xA4, 0x8C },
	0xA6A4, { 0xE5, 0xA5, 0x85 },
	0xA6A5, { 0xE5, 0xA6, 0xB5 },
	0xA6A6, { 0xE5, 0xA6, 0xBA },
	0xA6A7, { 0xE5, 0xA7, 0x8F },
	0xA6A8, { 0xE5, 0xA7, 0x8E },
	0xA6A9, { 0xE5, 0xA6, 0xB2 },
	0xA6AA, { 0xE5, 0xA7, 0x8C },
	0xA6AB, { 0xE5, 0xA7, 0x81 },
	0xA6AC, { 0xE5, 0xA6, 0xB6 },
	0xA6AD, { 0xE5, 0xA6, 0xBC },
	0xA6AE, { 0xE5, 0xA7, 0x83 },
	0xA6AF, { 0xE5, 0xA7, 0x96 },
	0xA6B0, { 0xE5, 0xA6, 0xB1 },
	0xA6B1, { 0xE5, 0xA6, 0xBD },
	0xA6B2, { 0xE5, 0xA7, 0x80 },
	0xA6B3, { 0xE5, 0xA7, 0x88 },
	0xA6B4, { 0xE5, 0xA6, 0xB4 },
	0xA6B5, { 0xE5, 0xA7, 0x87 },
	0xA6B6, { 0xE5, 0xAD, 0xA2 },
	0xA6B7, { 0xE5, 0xAD, 0xA5 },
	0xA6B8, { 0xE5, 0xAE, 0x93 },
	0xA6B9, { 0xE5, 0xAE, 0x95 },
	0xA6BA, { 0xE5, 0xB1, 0x84 },
	0xA6BB, { 0xE5, 0xB1, 0x87 },
	0xA6BC, { 0xE5, 0xB2, 0xAE },
	0xA6BD, { 0xE5, 0xB2, 0xA4 },
	0xA6BE, { 0xE5, 0xB2, 0xA0 },
	0xA6BF, { 0xE5, 0xB2, 0xB5 },
	0xA6C0, { 0xE5, 0xB2, 0xAF },
	0xA6C1, { 0xE5, 0xB2, 0xA8 },
	0xA6C2, { 0xE5, 0xB2, 0xAC },
	0xA6C3, { 0xE5, 0xB2, 0x9F },
	0xA6C4, { 0xE5, 0xB2, 0xA3 },
	0xA6C5, { 0xE5, 0xB2, 0xAD },
	0xA6C6, { 0xE5, 0xB2, 0xA2 },
	0xA6C7, { 0xE5, 0xB2, 0xAA },
	0xA6C8, { 0xE5, 0xB2, 0xA7 },
	0xA6C9, { 0xE5, 0xB2, 0x9D },
	0xA6CA, { 0xE5, 0xB2, 0xA5 },
	0xA6CB, { 0xE5, 0xB2, 0xB6 },
	0xA6CC, { 0xE5, 0xB2, 0xB0 },
	0xA6CD, { 0xE5, 0xB2, 0xA6 },
	0xA6CE, { 0xE5, 0xB8, 0x97 },
	0xA6CF, { 0xE5, 0xB8, 0x94 },
	0xA6D0, { 0xE5, 0xB8, 0x99 },
	0xA6D1, { 0xE5, 0xBC, 0xA8 },
	0xA6D2, { 0xE5, 0xBC, 0xA2 },
	0xA6D3, { 0xE5, 0xBC, 0xA3 },
	0xA6D4, { 0xE5, 0xBC, 0xA4 },
	0xA6D5, { 0xE5, 0xBD, 0x94 },
	0xA6D6, { 0xE5, 0xBE, 0x82 },
	0xA6D7, { 0xE5, 0xBD, 0xBE },
	0xA6D8, { 0xE5, 0xBD, 0xBD },
	0xA6D9, { 0xE5, 0xBF, 0x9E },
	0xA6DA, { 0xE5, 0xBF, 0xA5 },
	0xA6DB, { 0xE6, 0x80, 0xAD },
	0xA6DC, { 0xE6, 0x80, 0xA6 },
	0xA6DD, { 0xE6, 0x80, 0x99 },
	0xA6DE, { 0xE6, 0x80, 0xB2 },
	0xA6DF, { 0xE6, 0x80, 0x8B },
	0xA6E0, { 0xE6, 0x80, 0xB4 },
	0xA6E1, { 0xE6, 0x80, 0x8A },
	0xA6E2, { 0xE6, 0x80, 0x97 },
	0xA6E3, { 0xE6, 0x80, 0xB3 },
	0xA6E4, { 0xE6, 0x80, 0x9A },
	0xA6E5, { 0xE6, 0x80, 0x9E },
	0xA6E6, { 0xE6, 0x80, 0xAC },
	0xA6E7, { 0xE6, 0x80, 0xA2 },
	0xA6E8, { 0xE6, 0x80, 0x8D },
	0xA6E9, { 0xE6, 0x80, 0x90 },
	0xA6EA, { 0xE6, 0x80, 0xAE },
	0xA6EB, { 0xE6, 0x80, 0x93 },
	0xA6EC, { 0xE6, 0x80, 0x91 },
	0xA6ED, { 0xE6, 0x80, 0x8C },
	0xA6EE, { 0xE6, 0x80, 0x89 },
	0xA6EF, { 0xE6, 0x80, 0x9C },
	0xA6F0, { 0xE6, 0x88, 0x94 },
	0xA6F1, { 0xE6, 0x88, 0xBD },
	0xA6F2, { 0xE6, 0x8A, 0xAD },
	0xA6F3, { 0xE6, 0x8A, 0xB4 },
	0xA6F4, { 0xE6, 0x8B, 0x91 },
	0xA6F5, { 0xE6, 0x8A, 0xBE },
	0xA6F6, { 0xE6, 0x8A, 0xAA },
	0xA6F7, { 0xE6, 0x8A, 0xB6 },
	0xA6F8, { 0xE6, 0x8B, 0x8A },
	0xA6F9, { 0xE6, 0x8A, 0xAE },
	0xA6FA, { 0xE6, 0x8A, 0xB3 },
	0xA6FB, { 0xE6, 0x8A, 0xAF },
	0xA6FC, { 0xE6, 0x8A, 0xBB },
	0xA6FD, { 0xE6, 0x8A, 0xA9 },
	0xA6FE, { 0xE6, 0x8A, 0xB0 },
	0xA7A1, { 0xE6, 0x8A, 0xB8 },
	0xA7A2, { 0xE6, 0x94, 0xBD },
	0xA7A3, { 0xE6, 0x96, 0xA8 },
	0xA7A4, { 0xE6, 0x96, 0xBB },
	0xA7A5, { 0xE6, 0x98, 0x89 },
	0xA7A6, { 0xE6, 0x97, 0xBC },
	0xA7A7, { 0xE6, 0x98, 0x84 },
	0xA7A8, { 0xE6, 0x98, 0x92 },
	0xA7A9, { 0xE6, 0x98, 0x88 },
	0xA7AA, { 0xE6, 0x97, 0xBB },
	0xA7AB, { 0xE6, 0x98, 0x83 },
	0xA7AC, { 0xE6, 0x98, 0x8B },
	0xA7AD, { 0xE6, 0x98, 0x8D },
	0xA7AE, { 0xE6, 0x98, 0x85 },
	0xA7AF, { 0xE6, 0x97, 0xBD },
	0xA7B0, { 0xE6, 0x98, 0x91 },
	0xA7B1, { 0xE6, 0x98, 0x90 },
	0xA7B2, { 0xE6, 0x9B, 0xB6 },
	0xA7B3, { 0xE6, 0x9C, 0x8A },
	0xA7B4, { 0xE6, 0x9E, 0x85 },
	0xA7B5, { 0xE6, 0x9D, 0xAC },
	0xA7B6, { 0xE6, 0x9E, 0x8E },
	0xA7B7, { 0xE6, 0x9E, 0x92 },
	0xA7B8, { 0xE6, 0x9D, 0xB6 },
	0xA7B9, { 0xE6, 0x9D, 0xBB },
	0xA7BA, { 0xE6, 0x9E, 0x98 },
	0xA7BB, { 0xE6, 0x9E, 0x86 },
	0xA7BC, { 0xE6, 0x9E, 0x84 },
	0xA7BD, { 0xE6, 0x9D, 0xB4 },
	0xA7BE, { 0xE6, 0x9E, 0x8D },
	0xA7BF, { 0xE6, 0x9E, 0x8C },
	0xA7C0, { 0xE6, 0x9D, 0xBA },
	0xA7C1, { 0xE6, 0x9E, 0x9F },
	0xA7C2, { 0xE6, 0x9E, 0x91 },
	0xA7C3, { 0xE6, 0x9E, 0x99 },
	0xA7C4, { 0xE6, 0x9E, 0x83 },
	0xA7C5, { 0xE6, 0x9D, 0xBD },
	0xA7C6, { 0xE6, 0x9E, 0x81 },
	0xA7C7, { 0xE6, 0x9D, 0xB8 },
	0xA7C8, { 0xE6, 0x9D, 0xB9 },
	0xA7C9, { 0xE6, 0x9E, 0x94 },
	0xA7CA, { 0xE6, 0xAC, 0xA5 },
	0xA7CB, { 0xE6, 0xAE, 0x80 },
	0xA7CC, { 0xE6, 0xAD, 0xBE },
	0xA7CD, { 0xE6, 0xAF, 0x9E },
	0xA7CE, { 0xE6, 0xB0, 0x9D },
	0xA7CF, { 0xE6, 0xB2, 0x93 },
	0xA7D0, { 0xE6, 0xB3, 0xAC },
	0xA7D1, { 0xE6, 0xB3, 0xAB },
	0xA7D2, { 0xE6, 0xB3, 0xAE },
	0xA7D3, { 0xE6, 0xB3, 0x99 },
	0xA7D4, { 0xE6, 0xB2, 0xB6 },
	0xA7D5, { 0xE6, 0xB3, 0x94 },
	0xA7D6, { 0xE6, 0xB2, 0xAD },
	0xA7D7, { 0xE6, 0xB3, 0xA7 },
	0xA7D8, { 0xE6, 0xB2, 0xB7 },
	0xA7D9, { 0xE6, 0xB3, 0x90 },
	0xA7DA, { 0xE6, 0xB3, 0x82 },
	0xA7DB, { 0xE6, 0xB2, 0xBA },
	0xA7DC, { 0xE6, 0xB3, 0x83 },
	0xA7DD, { 0xE6, 0xB3, 0x86 },
	0xA7DE, { 0xE6, 0xB3, 0xAD },
	0xA7DF, { 0xE6, 0xB3, 0xB2 },
	0xA7E0, { 0xE6, 0xB3, 0x92 },
	0xA7E1, { 0xE6, 0xB3, 0x9D },
	0xA7E2, { 0xE6, 0xB2, 0xB4 },
	0xA7E3, { 0xE6, 0xB2, 0x8A },
	0xA7E4, { 0xE6, 0xB2, 0x9D },
	0xA7E5, { 0xE6, 0xB2, 0x80 },
	0xA7E6, { 0xE6, 0xB3, 0x9E },
	0xA7E7, { 0xE6, 0xB3, 0x80 },
	0xA7E8, { 0xE6, 0xB4, 0xB0 },
	0xA7E9, { 0xE6, 0xB3, 0x8D },
	0xA7EA, { 0xE6, 0xB3, 0x87 },
	0xA7EB, { 0xE6, 0xB2, 0xB0 },
	0xA7EC, { 0xE6, 0xB3, 0xB9 },
	0xA7ED, { 0xE6, 0xB3, 0x8F },
	0xA7EE, { 0xE6, 0xB3, 0xA9 },
	0xA7EF, { 0xE6, 0xB3, 0x91 },
	0xA7F0, { 0xE7, 0x82, 0x94 },
	0xA7F1, { 0xE7, 0x82, 0x98 },
	0xA7F2, { 0xE7, 0x82, 0x85 },
	0xA7F3, { 0xE7, 0x82, 0x93 },
	0xA7F4, { 0xE7, 0x82, 0x86 },
	0xA7F5, { 0xE7, 0x82, 0x84 },
	0xA7F6, { 0xE7, 0x82, 0x91 },
	0xA7F7, { 0xE7, 0x82, 0x96 },
	0xA7F8, { 0xE7, 0x82, 0x82 },
	0xA7F9, { 0xE7, 0x82, 0x9A },
	0xA7FA, { 0xE7, 0x82, 0x83 },
	0xA7FB, { 0xE7, 0x89, 0xAA },
	0xA7FC, { 0xE7, 0x8B, 0x96 },
	0xA7FD, { 0xE7, 0x8B, 0x8B },
	0xA7FE, { 0xE7, 0x8B, 0x98 },
	0xA8A1, { 0xE7, 0x8B, 0x89 },
	0xA8A2, { 0xE7, 0x8B, 0x9C },
	0xA8A3, { 0xE7, 0x8B, 0x92 },
	0xA8A4, { 0xE7, 0x8B, 0x94 },
	0xA8A5, { 0xE7, 0x8B, 0x9A },
	0xA8A6, { 0xE7, 0x8B, 0x8C },
	0xA8A7, { 0xE7, 0x8B, 0x91 },
	0xA8A8, { 0xE7, 0x8E, 0xA4 },
	0xA8A9, { 0xE7, 0x8E, 0xA1 },
	0xA8AA, { 0xE7, 0x8E, 0xAD },
	0xA8AB, { 0xE7, 0x8E, 0xA6 },
	0xA8AC, { 0xE7, 0x8E, 0xA2 },
	0xA8AD, { 0xE7, 0x8E, 0xA0 },
	0xA8AE, { 0xE7, 0x8E, 0xAC },
	0xA8AF, { 0xE7, 0x8E, 0x9D },
	0xA8B0, { 0xE7, 0x93, 0x9D },
	0xA8B1, { 0xE7, 0x93, 0xA8 },
	0xA8B2, { 0xE7, 0x94, 0xBF },
	0xA8B3, { 0xE7, 0x95, 0x80 },
	0xA8B4, { 0xE7, 0x94, 0xBE },
	0xA8B5, { 0xE7, 0x96, 0x8C },
	0xA8B6, { 0xE7, 0x96, 0x98 },
	0xA8B7, { 0xE7, 0x9A, 0xAF },
	0xA8B8, { 0xE7, 0x9B, 0xB3 },
	0xA8B9, { 0xE7, 0x9B, 0xB1 },
	0xA8BA, { 0xE7, 0x9B, 0xB0 },
	0xA8BB, { 0xE7, 0x9B, 0xB5 },
	0xA8BC, { 0xE7, 0x9F, 0xB8 },
	0xA8BD, { 0xE7, 0x9F, 0xBC },
	0xA8BE, { 0xE7, 0x9F, 0xB9 },
	0xA8BF, { 0xE7, 0x9F, 0xBB },
	0xA8C0, { 0xE7, 0x9F, 0xBA },
	0xA8C1, { 0xE7, 0x9F, 0xB7 },
	0xA8C2, { 0xE7, 0xA5, 0x82 },
	0xA8C3, { 0xE7, 0xA4, 0xBF },
	0xA8C4, { 0xE7, 0xA7, 0x85 },
	0xA8C5, { 0xE7, 0xA9, 0xB8 },
	0xA8C6, { 0xE7, 0xA9, 0xBB },
	0xA8C7, { 0xE7, 0xAB, 0xBB },
	0xA8C8, { 0xE7, 0xB1, 0xB5 },
	0xA8C9, { 0xE7, 0xB3, 0xBD },
	0xA8CA, { 0xE8, 0x80, 0xB5 },
	0xA8CB, { 0xE8, 0x82, 0x8F },
	0xA8CC, { 0xE8, 0x82, 0xAE },
	0xA8CD, { 0xE8, 0x82, 0xA3 },
	0xA8CE, { 0xE8, 0x82, 0xB8 },
	0xA8CF, { 0xE8, 0x82, 0xB5 },
	0xA8D0, { 0xE8, 0x82, 0xAD },
	0xA8D1, { 0xE8, 0x88, 0xA0 },
	0xA8D2, { 0xE8, 0x8A, 0xA0 },
	0xA8D3, { 0xE8, 0x8B, 0x80 },
	0xA8D4, { 0xE8, 0x8A, 0xAB },
	0xA8D5, { 0xE8, 0x8A, 0x9A },
	0xA8D6, { 0xE8, 0x8A, 0x98 },
	0xA8D7, { 0xE8, 0x8A, 0x9B },
	0xA8D8, { 0xE8, 0x8A, 0xB5 },
	0xA8D9, { 0xE8, 0x8A, 0xA7 },
	0xA8DA, { 0xE8, 0x8A, 0xAE },
	0xA8DB, { 0xE8, 0x8A, 0xBC },
	0xA8DC, { 0xE8, 0x8A, 0x9E },
	0xA8DD, { 0xE8, 0x8A, 0xBA },
	0xA8DE, { 0xE8, 0x8A, 0xB4 },
	0xA8DF, { 0xE8, 0x8A, 0xA8 },
	0xA8E0, { 0xE8, 0x8A, 0xA1 },
	0xA8E1, { 0xE8, 0x8A, 0xA9 },
	0xA8E2, { 0xE8, 0x8B, 0x82 },
	0xA8E3, { 0xE8, 0x8A, 0xA4 },
	0xA8E4, { 0xE8, 0x8B, 0x83 },
	0xA8E5, { 0xE8, 0x8A, 0xB6 },
	0xA8E6, { 0xE8, 0x8A, 0xA2 },
	0xA8E7, { 0xE8, 0x99, 0xB0 },
	0xA8E8, { 0xE8, 0x99, 0xAF },
	0xA8E9, { 0xE8, 0x99, 0xAD },
	0xA8EA, { 0xE8, 0x99, 0xAE },
	0xA8EB, { 0xE8, 0xB1, 0x96 },
	0xA8EC, { 0xE8, 0xBF, 0x92 },
	0xA8ED, { 0xE8, 0xBF, 0x8B },
	0xA8EE, { 0xE8, 0xBF, 0x93 },
	0xA8EF, { 0xE8, 0xBF, 0x8D },
	0xA8F0, { 0xE8, 0xBF, 0x96 },
	0xA8F1, { 0xE8, 0xBF, 0x95 },
	0xA8F2, { 0xE8, 0xBF, 0x97 },
	0xA8F3, { 0xE9, 0x82, 0xB2 },
	0xA8F4, { 0xE9, 0x82, 0xB4 },
	0xA8F5, { 0xE9, 0x82, 0xAF },
	0xA8F6, { 0xE9, 0x82, 0xB3 },
	0xA8F7, { 0xE9, 0x82, 0xB0 },
	0xA8F8, { 0xE9, 0x98, 0xB9 },
	0xA8F9, { 0xE9, 0x98, 0xBD },
	0xA8FA, { 0xE9, 0x98, 0xBC },
	0xA8FB, { 0xE9, 0x98, 0xBA },
	0xA8FC, { 0xE9, 0x99, 0x83 },
	0xA8FD, { 0xE4, 0xBF, 0x8D },
	0xA8FE, { 0xE4, 0xBF, 0x85 },
	0xA9A1, { 0xE4, 0xBF, 0x93 },
	0xA9A2, { 0xE4, 0xBE, 0xB2 },
	0xA9A3, { 0xE4, 0xBF, 0x89 },
	0xA9A4, { 0xE4, 0xBF, 0x8B },
	0xA9A5, { 0xE4, 0xBF, 0x81 },
	0xA9A6, { 0xE4, 0xBF, 0x94 },
	0xA9A7, { 0xE4, 0xBF, 0x9C },
	0xA9A8, { 0xE4, 0xBF, 0x99 },
	0xA9A9, { 0xE4, 0xBE, 0xBB },
	0xA9AA, { 0xE4, 0xBE, 0xB3 },
	0xA9AB, { 0xE4, 0xBF, 0x9B },
	0xA9AC, { 0xE4, 0xBF, 0x87 },
	0xA9AD, { 0xE4, 0xBF, 0x96 },
	0xA9AE, { 0xE4, 0xBE, 0xBA },
	0xA9AF, { 0xE4, 0xBF, 0x80 },
	0xA9B0, { 0xE4, 0xBE, 0xB9 },
	0xA9B1, { 0xE4, 0xBF, 0xAC },
	0xA9B2, { 0xE5, 0x89, 0x84 },
	0xA9B3, { 0xE5, 0x89, 0x89 },
	0xA9B4, { 0xE5, 0x8B, 0x80 },
	0xA9B5, { 0xE5, 0x8B, 0x82 },
	0xA9B6, { 0xE5, 0x8C, 0xBD },
	0xA9B7, { 0xE5, 0x8D, 0xBC },
	0xA9B8, { 0xE5, 0x8E, 0x97 },
	0xA9B9, { 0xE5, 0x8E, 0x96 },
	0xA9BA, { 0xE5, 0x8E, 0x99 },
	0xA9BB, { 0xE5, 0x8E, 0x98 },
	0xA9BC, { 0xE5, 0x92, 0xBA },
	0xA9BD, { 0xE5, 0x92, 0xA1 },
	0xA9BE, { 0xE5, 0x92, 0xAD },
	0xA9BF, { 0xE5, 0x92, 0xA5 },
	0xA9C0, { 0xE5, 0x93, 0x8F },
	0xA9C1, { 0xE5, 0x93, 0x83 },
	0xA9C2, { 0xE8, 0x8C, 0x8D },
	0xA9C3, { 0xE5, 0x92, 0xB7 },
	0xA9C4, { 0xE5, 0x92, 0xAE },
	0xA9C5, { 0xE5, 0x93, 0x96 },
	0xA9C6, { 0xE5, 0x92, 0xB6 },
	0xA9C7, { 0xE5, 0x93, 0x85 },
	0xA9C8, { 0xE5, 0x93, 0x86 },
	0xA9C9, { 0xE5, 0x92, 0xA0 },
	0xA9CA, { 0xE5, 0x91, 0xB0 },
	0xA9CB, { 0xE5, 0x92, 0xBC },
	0xA9CC, { 0xE5, 0x92, 0xA2 },
	0xA9CD, { 0xE5, 0x92, 0xBE },
	0xA9CE, { 0xE5, 0x91, 0xB2 },
	0xA9CF, { 0xE5, 0x93, 0x9E },
	0xA9D0, { 0xE5, 0x92, 0xB0 },
	0xA9D1, { 0xE5, 0x9E, 0xB5 },
	0xA9D2, { 0xE5, 0x9E, 0x9E },
	0xA9D3, { 0xE5, 0x9E, 0x9F },
	0xA9D4, { 0xE5, 0x9E, 0xA4 },
	0xA9D5, { 0xE5, 0x9E, 0x8C },
	0xA9D6, { 0xE5, 0x9E, 0x97 },
	0xA9D7, { 0xE5, 0x9E, 0x9D },
	0xA9D8, { 0xE5, 0x9E, 0x9B },
	0xA9D9, { 0xE5, 0x9E, 0x94 },
	0xA9DA, { 0xE5, 0x9E, 0x98 },
	0xA9DB, { 0xE5, 0x9E, 0x8F },
	0xA9DC, { 0xE5, 0x9E, 0x99 },
	0xA9DD, { 0xE5, 0x9E, 0xA5 },
	0xA9DE, { 0xE5, 0x9E, 0x9A },
	0xA9DF, { 0xE5, 0x9E, 0x95 },
	0xA9E0, { 0xE5, 0xA3, 0xB4 },
	0xA9E1, { 0xE5, 0xA4, 0x8D },
	0xA9E2, { 0xE5, 0xA5, 0x93 },
	0xA9E3, { 0xE5, 0xA7, 0xA1 },
	0xA9E4, { 0xE5, 0xA7, 0x9E },
	0xA9E5, { 0xE5, 0xA7, 0xAE },
	0xA9E6, { 0xE5, 0xA8, 0x80 },
	0xA9E7, { 0xE5, 0xA7, 0xB1 },
	0xA9E8, { 0xE5, 0xA7, 0x9D },
	0xA9E9, { 0xE5, 0xA7, 0xBA },
	0xA9EA, { 0xE5, 0xA7, 0xBD },
	0xA9EB, { 0xE5, 0xA7, 0xBC },
	0xA9EC, { 0xE5, 0xA7, 0xB6 },
	0xA9ED, { 0xE5, 0xA7, 0xA4 },
	0xA9EE, { 0xE5, 0xA7, 0xB2 },
	0xA9EF, { 0xE5, 0xA7, 0xB7 },
	0xA9F0, { 0xE5, 0xA7, 0x9B },
	0xA9F1, { 0xE5, 0xA7, 0xA9 },
	0xA9F2, { 0xE5, 0xA7, 0xB3 },
	0xA9F3, { 0xE5, 0xA7, 0xB5 },
	0xA9F4, { 0xE5, 0xA7, 0xA0 },
	0xA9F5, { 0xE5, 0xA7, 0xBE },
	0xA9F6, { 0xE5, 0xA7, 0xB4 },
	0xA9F7, { 0xE5, 0xA7, 0xAD },
	0xA9F8, { 0xE5, 0xAE, 0xA8 },
	0xA9F9, { 0xE5, 0xB1, 0x8C },
	0xA9FA, { 0xE5, 0xB3, 0x90 },
	0xA9FB, { 0xE5, 0xB3, 0x98 },
	0xA9FC, { 0xE5, 0xB3, 0x8C },
	0xA9FD, { 0xE5, 0xB3, 0x97 },
	0xA9FE, { 0xE5, 0xB3, 0x8B },
	0xAAA1, { 0xE5, 0xB3, 0x9B },
	0xAAA2, { 0xE5, 0xB3, 0x9E },
	0xAAA3, { 0xE5, 0xB3, 0x9A },
	0xAAA4, { 0xE5, 0xB3, 0x89 },
	0xAAA5, { 0xE5, 0xB3, 0x87 },
	0xAAA6, { 0xE5, 0xB3, 0x8A },
	0xAAA7, { 0xE5, 0xB3, 0x96 },
	0xAAA8, { 0xE5, 0xB3, 0x93 },
	0xAAA9, { 0xE5, 0xB3, 0x94 },
	0xAAAA, { 0xE5, 0xB3, 0x8F },
	0xAAAB, { 0xE5, 0xB3, 0x88 },
	0xAAAC, { 0xE5, 0xB3, 0x86 },
	0xAAAD, { 0xE5, 0xB3, 0x8E },
	0xAAAE, { 0xE5, 0xB3, 0x9F },
	0xAAAF, { 0xE5, 0xB3, 0xB8 },
	0xAAB0, { 0xE5, 0xB7, 0xB9 },
	0xAAB1, { 0xE5, 0xB8, 0xA1 },
	0xAAB2, { 0xE5, 0xB8, 0xA2 },
	0xAAB3, { 0xE5, 0xB8, 0xA3 },
	0xAAB4, { 0xE5, 0xB8, 0xA0 },
	0xAAB5, { 0xE5, 0xB8, 0xA4 },
	0xAAB6, { 0xE5, 0xBA, 0xB0 },
	0xAAB7, { 0xE5, 0xBA, 0xA4 },
	0xAAB8, { 0xE5, 0xBA, 0xA2 },
	0xAAB9, { 0xE5, 0xBA, 0x9B },
	0xAABA, { 0xE5, 0xBA, 0xA3 },
	0xAABB, { 0xE5, 0xBA, 0xA5 },
	0xAABC, { 0xE5, 0xBC, 0x87 },
	0xAABD, { 0xE5, 0xBC, 0xAE },
	0xAABE, { 0xE5, 0xBD, 0x96 },
	0xAABF, { 0xE5, 0xBE, 0x86 },
	0xAAC0, { 0xE6, 0x80, 0xB7 },
	0xAAC1, { 0xE6, 0x80, 0xB9 },
	0xAAC2, { 0xE6, 0x81, 0x94 },
	0xAAC3, { 0xE6, 0x81, 0xB2 },
	0xAAC4, { 0xE6, 0x81, 0x9E },
	0xAAC5, { 0xE6, 0x81, 0x85 },
	0xAAC6, { 0xE6, 0x81, 0x93 },
	0xAAC7, { 0xE6, 0x81, 0x87 },
	0xAAC8, { 0xE6, 0x81, 0x89 },
	0xAAC9, { 0xE6, 0x81, 0x9B },
	0xAACA, { 0xE6, 0x81, 0x8C },
	0xAACB, { 0xE6, 0x81, 0x80 },
	0xAACC, { 0xE6, 0x81, 0x82 },
	0xAACD, { 0xE6, 0x81, 0x9F },
	0xAACE, { 0xE6, 0x80, 0xA4 },
	0xAACF, { 0xE6, 0x81, 0x84 },
	0xAAD0, { 0xE6, 0x81, 0x98 },
	0xAAD1, { 0xE6, 0x81, 0xA6 },
	0xAAD2, { 0xE6, 0x81, 0xAE },
	0xAAD3, { 0xE6, 0x89, 0x82 },
	0xAAD4, { 0xE6, 0x89, 0x83 },
	0xAAD5, { 0xE6, 0x8B, 0x8F },
	0xAAD6, { 0xE6, 0x8C, 0x8D },
	0xAAD7, { 0xE6, 0x8C, 0x8B },
	0xAAD8, { 0xE6, 0x8B, 0xB5 },
	0xAAD9, { 0xE6, 0x8C, 0x8E },
	0xAADA, { 0xE6, 0x8C, 0x83 },
	0xAADB, { 0xE6, 0x8B, 0xAB },
	0xAADC, { 0xE6, 0x8B, 0xB9 },
	0xAADD, { 0xE6, 0x8C, 0x8F },
	0xAADE, { 0xE6, 0x8C, 0x8C },
	0xAADF, { 0xE6, 0x8B, 0xB8 },
	0xAAE0, { 0xE6, 0x8B, 0xB6 },
	0xAAE1, { 0xE6, 0x8C, 0x80 },
	0xAAE2, { 0xE6, 0x8C, 0x93 },
	0xAAE3, { 0xE6, 0x8C, 0x94 },
	0xAAE4, { 0xE6, 0x8B, 0xBA },
	0xAAE5, { 0xE6, 0x8C, 0x95 },
	0xAAE6, { 0xE6, 0x8B, 0xBB },
	0xAAE7, { 0xE6, 0x8B, 0xB0 },
	0xAAE8, { 0xE6, 0x95, 0x81 },
	0xAAE9, { 0xE6, 0x95, 0x83 },
	0xAAEA, { 0xE6, 0x96, 0xAA },
	0xAAEB, { 0xE6, 0x96, 0xBF },
	0xAAEC, { 0xE6, 0x98, 0xB6 },
	0xAAED, { 0xE6, 0x98, 0xA1 },
	0xAAEE, { 0xE6, 0x98, 0xB2 },
	0xAAEF, { 0xE6, 0x98, 0xB5 },
	0xAAF0, { 0xE6, 0x98, 0x9C },
	0xAAF1, { 0xE6, 0x98, 0xA6 },
	0xAAF2, { 0xE6, 0x98, 0xA2 },
	0xAAF3, { 0xE6, 0x98, 0xB3 },
	0xAAF4, { 0xE6, 0x98, 0xAB },
	0xAAF5, { 0xE6, 0x98, 0xBA },
	0xAAF6, { 0xE6, 0x98, 0x9D },
	0xAAF7, { 0xE6, 0x98, 0xB4 },
	0xAAF8, { 0xE6, 0x98, 0xB9 },
	0xAAF9, { 0xE6, 0x98, 0xAE },
	0xAAFA, { 0xE6, 0x9C, 0x8F },
	0xAAFB, { 0xE6, 0x9C, 0x90 },
	0xAAFC, { 0xE6, 0x9F, 0x81 },
	0xAAFD, { 0xE6, 0x9F, 0xB2 },
	0xAAFE, { 0xE6, 0x9F, 0x88 },
	0xABA1, { 0xE6, 0x9E, 0xBA },
	0xABA2, { 0xE6, 0x9F, 0x9C },
	0xABA3, { 0xE6, 0x9E, 0xBB },
	0xABA4, { 0xE6, 0x9F, 0xB8 },
	0xABA5, { 0xE6, 0x9F, 0x98 },
	0xABA6, { 0xE6, 0x9F, 0x80 },
	0xABA7, { 0xE6, 0x9E, 0xB7 },
	0xABA8, { 0xE6, 0x9F, 0x85 },
	0xABA9, { 0xE6, 0x9F, 0xAB },
	0xABAA, { 0xE6, 0x9F, 0xA4 },
	0xABAB, { 0xE6, 0x9F, 0x9F },
	0xABAC, { 0xE6, 0x9E, 0xB5 },
	0xABAD, { 0xE6, 0x9F, 0x8D },
	0xABAE, { 0xE6, 0x9E, 0xB3 },
	0xABAF, { 0xE6, 0x9F, 0xB7 },
	0xABB0, { 0xE6, 0x9F, 0xB6 },
	0xABB1, { 0xE6, 0x9F, 0xAE },
	0xABB2, { 0xE6, 0x9F, 0xA3 },
	0xABB3, { 0xE6, 0x9F, 0x82 },
	0xABB4, { 0xE6, 0x9E, 0xB9 },
	0xABB5, { 0xE6, 0x9F, 0x8E },
	0xABB6, { 0xE6, 0x9F, 0xA7 },
	0xABB7, { 0xE6, 0x9F, 0xB0 },
	0xABB8, { 0xE6, 0x9E, 0xB2 },
	0xABB9, { 0xE6, 0x9F, 0xBC },
	0xABBA, { 0xE6, 0x9F, 0x86 },
	0xABBB, { 0xE6, 0x9F, 0xAD },
	0xABBC, { 0xE6, 0x9F, 0x8C },
	0xABBD, { 0xE6, 0x9E, 0xAE },
	0xABBE, { 0xE6, 0x9F, 0xA6 },
	0xABBF, { 0xE6, 0x9F, 0x9B },
	0xABC0, { 0xE6, 0x9F, 0xBA },
	0xABC1, { 0xE6, 0x9F, 0x89 },
	0xABC2, { 0xE6, 0x9F, 0x8A },
	0xABC3, { 0xE6, 0x9F, 0x83 },
	0xABC4, { 0xE6, 0x9F, 0xAA },
	0xABC5, { 0xE6, 0x9F, 0x8B },
	0xABC6, { 0xE6, 0xAC, 0xA8 },
	0xABC7, { 0xE6, 0xAE, 0x82 },
	0xABC8, { 0xE6, 0xAE, 0x84 },
	0xABC9, { 0xE6, 0xAE, 0xB6 },
	0xABCA, { 0xE6, 0xAF, 0x96 },
	0xABCB, { 0xE6, 0xAF, 0x98 },
	0xABCC, { 0xE6, 0xAF, 0xA0 },
	0xABCD, { 0xE6, 0xB0, 0xA0 },
	0xABCE, { 0xE6, 0xB0, 0xA1 },
	0xABCF, { 0xE6, 0xB4, 0xA8 },
	0xABD0, { 0xE6, 0xB4, 0xB4 },
	0xABD1, { 0xE6, 0xB4, 0xAD },
	0xABD2, { 0xE6, 0xB4, 0x9F },
	0xABD3, { 0xE6, 0xB4, 0xBC },
	0xABD4, { 0xE6, 0xB4, 0xBF },
	0xABD5, { 0xE6, 0xB4, 0x92 },
	0xABD6, { 0xE6, 0xB4, 0x8A },
	0xABD7, { 0xE6, 0xB3, 0x9A },
	0xABD8, { 0xE6, 0xB4, 0xB3 },
	0xABD9, { 0xE6, 0xB4, 0x84 },
	0xABDA, { 0xE6, 0xB4, 0x99 },
	0xABDB, { 0xE6, 0xB4, 0xBA },
	0xABDC, { 0xE6, 0xB4, 0x9A },
	0xABDD, { 0xE6, 0xB4, 0x91 },
	0xABDE, { 0xE6, 0xB4, 0x80 },
	0xABDF, { 0xE6, 0xB4, 0x9D },
	0xABE0, { 0xE6, 0xB5, 0x82 },
	0xABE1, { 0xE6, 0xB4, 0x81 },
	0xABE2, { 0xE6, 0xB4, 0x98 },
	0xABE3, { 0xE6, 0xB4, 0xB7 },
	0xABE4, { 0xE6, 0xB4, 0x83 },
	0xABE5, { 0xE6, 0xB4, 0x8F },
	0xABE6, { 0xE6, 0xB5, 0x80 },
	0xABE7, { 0xE6, 0xB4, 0x87 },
	0xABE8, { 0xE6, 0xB4, 0xA0 },
	0xABE9, { 0xE6, 0xB4, 0xAC },
	0xABEA, { 0xE6, 0xB4, 0x88 },
	0xABEB, { 0xE6, 0xB4, 0xA2 },
	0xABEC, { 0xE6, 0xB4, 0x89 },
	0xABED, { 0xE6, 0xB4, 0x90 },
	0xABEE, { 0xE7, 0x82, 0xB7 },
	0xABEF, { 0xE7, 0x82, 0x9F },
	0xABF0, { 0xE7, 0x82, 0xBE },
	0xABF1, { 0xE7, 0x82, 0xB1 },
	0xABF2, { 0xE7, 0x82, 0xB0 },
	0xABF3, { 0xE7, 0x82, 0xA1 },
	0xABF4, { 0xE7, 0x82, 0xB4 },
	0xABF5, { 0xE7, 0x82, 0xB5 },
	0xABF6, { 0xE7, 0x82, 0xA9 },
	0xABF7, { 0xE7, 0x89, 0x81 },
	0xABF8, { 0xE7, 0x89, 0x89 },
	0xABF9, { 0xE7, 0x89, 0x8A },
	0xABFA, { 0xE7, 0x89, 0xAC },
	0xABFB, { 0xE7, 0x89, 0xB0 },
	0xABFC, { 0xE7, 0x89, 0xB3 },
	0xABFD, { 0xE7, 0x89, 0xAE },
	0xABFE, { 0xE7, 0x8B, 0x8A },
	0xACA1, { 0xE7, 0x8B, 0xA4 },
	0xACA2, { 0xE7, 0x8B, 0xA8 },
	0xACA3, { 0xE7, 0x8B, 0xAB },
	0xACA4, { 0xE7, 0x8B, 0x9F },
	0xACA5, { 0xE7, 0x8B, 0xAA },
	0xACA6, { 0xE7, 0x8B, 0xA6 },
	0xACA7, { 0xE7, 0x8B, 0xA3 },
	0xACA8, { 0xE7, 0x8E, 0x85 },
	0xACA9, { 0xE7, 0x8F, 0x8C },
	0xACAA, { 0xE7, 0x8F, 0x82 },
	0xACAB, { 0xE7, 0x8F, 0x88 },
	0xACAC, { 0xE7, 0x8F, 0x85 },
	0xACAD, { 0xE7, 0x8E, 0xB9 },
	0xACAE, { 0xE7, 0x8E, 0xB6 },
	0xACAF, { 0xE7, 0x8E, 0xB5 },
	0xACB0, { 0xE7, 0x8E, 0xB4 },
	0xACB1, { 0xE7, 0x8F, 0xAB },
	0xACB2, { 0xE7, 0x8E, 0xBF },
	0xACB3, { 0xE7, 0x8F, 0x87 },
	0xACB4, { 0xE7, 0x8E, 0xBE },
	0xACB5, { 0xE7, 0x8F, 0x83 },
	0xACB6, { 0xE7, 0x8F, 0x86 },
	0xACB7, { 0xE7, 0x8E, 0xB8 },
	0xACB8, { 0xE7, 0x8F, 0x8B },
	0xACB9, { 0xE7, 0x93, 0xAC },
	0xACBA, { 0xE7, 0x93, 0xAE },
	0xACBB, { 0xE7, 0x94, 0xAE },
	0xACBC, { 0xE7, 0x95, 0x87 },
	0xACBD, { 0xE7, 0x95, 0x88 },
	0xACBE, { 0xE7, 0x96, 0xA7 },
	0xACBF, { 0xE7, 0x96, 0xAA },
	0xACC0, { 0xE7, 0x99, 0xB9 },
	0xACC1, { 0xE7, 0x9B, 0x84 },
	0xACC2, { 0xE7, 0x9C, 0x88 },
	0xACC3, { 0xE7, 0x9C, 0x83 },
	0xACC4, { 0xE7, 0x9C, 0x84 },
	0xACC5, { 0xE7, 0x9C, 0x85 },
	0xACC6, { 0xE7, 0x9C, 0x8A },
	0xACC7, { 0xE7, 0x9B, 0xB7 },
	0xACC8, { 0xE7, 0x9B, 0xBB },
	0xACC9, { 0xE7, 0x9B, 0xBA },
	0xACCA, { 0xE7, 0x9F, 0xA7 },
	0xACCB, { 0xE7, 0x9F, 0xA8 },
	0xACCC, { 0xE7, 0xA0, 0x86 },
	0xACCD, { 0xE7, 0xA0, 0x91 },
	0xACCE, { 0xE7, 0xA0, 0x92 },
	0xACCF, { 0xE7, 0xA0, 0x85 },
	0xACD0, { 0xE7, 0xA0, 0x90 },
	0xACD1, { 0xE7, 0xA0, 0x8F },
	0xACD2, { 0xE7, 0xA0, 0x8E },
	0xACD3, { 0xE7, 0xA0, 0x89 },
	0xACD4, { 0xE7, 0xA0, 0x83 },
	0xACD5, { 0xE7, 0xA0, 0x93 },
	0xACD6, { 0xE7, 0xA5, 0x8A },
	0xACD7, { 0xE7, 0xA5, 0x8C },
	0xACD8, { 0xE7, 0xA5, 0x8B },
	0xACD9, { 0xE7, 0xA5, 0x85 },
	0xACDA, { 0xE7, 0xA5, 0x84 },
	0xACDB, { 0xE7, 0xA7, 0x95 },
	0xACDC, { 0xE7, 0xA7, 0x8D },
	0xACDD, { 0xE7, 0xA7, 0x8F },
	0xACDE, { 0xE7, 0xA7, 0x96 },
	0xACDF, { 0xE7, 0xA7, 0x8E },
	0xACE0, { 0xE7, 0xAA, 0x80 },
	0xACE1, { 0xE7, 0xA9, 0xBE },
	0xACE2, { 0xE7, 0xAB, 0x91 },
	0xACE3, { 0xE7, 0xAC, 0x80 },
	0xACE4, { 0xE7, 0xAC, 0x81 },
	0xACE5, { 0xE7, 0xB1, 0xBA },
	0xACE6, { 0xE7, 0xB1, 0xB8 },
	0xACE7, { 0xE7, 0xB1, 0xB9 },
	0xACE8, { 0xE7, 0xB1, 0xBF },
	0xACE9, { 0xE7, 0xB2, 0x80 },
	0xACEA, { 0xE7, 0xB2, 0x81 },
	0xACEB, { 0xE7, 0xB4, 0x83 },
	0xACEC, { 0xE7, 0xB4, 0x88 },
	0xACED, { 0xE7, 0xB4, 0x81 },
	0xACEE, { 0xE7, 0xBD, 0x98 },
	0xACEF, { 0xE7, 0xBE, 0x91 },
	0xACF0, { 0xE7, 0xBE, 0x8D },
	0xACF1, { 0xE7, 0xBE, 0xBE },
	0xACF2, { 0xE8, 0x80, 0x87 },
	0xACF3, { 0xE8, 0x80, 0x8E },
	0xACF4, { 0xE8, 0x80, 0x8F },
	0xACF5, { 0xE8, 0x80, 0x94 },
	0xACF6, { 0xE8, 0x80, 0xB7 },
	0xACF7, { 0xE8, 0x83, 0x98 },
	0xACF8, { 0xE8, 0x83, 0x87 },
	0xACF9, { 0xE8, 0x83, 0xA0 },
	0xACFA, { 0xE8, 0x83, 0x91 },
	0xACFB, { 0xE8, 0x83, 0x88 },
	0xACFC, { 0xE8, 0x83, 0x82 },
	0xACFD, { 0xE8, 0x83, 0x90 },
	0xACFE, { 0xE8, 0x83, 0x85 },
	0xADA1, { 0xE8, 0x83, 0xA3 },
	0xADA2, { 0xE8, 0x83, 0x99 },
	0xADA3, { 0xE8, 0x83, 0x9C },
	0xADA4, { 0xE8, 0x83, 0x8A },
	0xADA5, { 0xE8, 0x83, 0x95 },
	0xADA6, { 0xE8, 0x83, 0x89 },
	0xADA7, { 0xE8, 0x83, 0x8F },
	0xADA8, { 0xE8, 0x83, 0x97 },
	0xADA9, { 0xE8, 0x83, 0xA6 },
	0xADAA, { 0xE8, 0x83, 0x8D },
	0xADAB, { 0xE8, 0x87, 0xBF },
	0xADAC, { 0xE8, 0x88, 0xA1 },
	0xADAD, { 0xE8, 0x8A, 0x94 },
	0xADAE, { 0xE8, 0x8B, 0x99 },
	0xADAF, { 0xE8, 0x8B, 0xBE },
	0xADB0, { 0xE8, 0x8B, 0xB9 },
	0xADB1, { 0xE8, 0x8C, 0x87 },
	0xADB2, { 0xE8, 0x8B, 0xA8 },
	0xADB3, { 0xE8, 0x8C, 0x80 },
	0xADB4, { 0xE8, 0x8B, 0x95 },
	0xADB5, { 0xE8, 0x8C, 0xBA },
	0xADB6, { 0xE8, 0x8B, 0xAB },
	0xADB7, { 0xE8, 0x8B, 0x96 },
	0xADB8, { 0xE8, 0x8B, 0xB4 },
	0xADB9, { 0xE8, 0x8B, 0xAC },
	0xADBA, { 0xE8, 0x8B, 0xA1 },
	0xADBB, { 0xE8, 0x8B, 0xB2 },
	0xADBC, { 0xE8, 0x8B, 0xB5 },
	0xADBD, { 0xE8, 0x8C, 0x8C },
	0xADBE, { 0xE8, 0x8B, 0xBB },
	0xADBF, { 0xE8, 0x8B, 0xB6 },
	0xADC0, { 0xE8, 0x8B, 0xB0 },
	0xADC1, { 0xE8, 0x8B, 0xAA },
	0xADC2, { 0xE8, 0x8B, 0xA4 },
	0xADC3, { 0xE8, 0x8B, 0xA0 },
	0xADC4, { 0xE8, 0x8B, 0xBA },
	0xADC5, { 0xE8, 0x8B, 0xB3 },
	0xADC6, { 0xE8, 0x8B, 0xAD },
	0xADC7, { 0xE8, 0x99, 0xB7 },
	0xADC8, { 0xE8, 0x99, 0xB4 },
	0xADC9, { 0xE8, 0x99, 0xBC },
	0xADCA, { 0xE8, 0x99, 0xB3 },
	0xADCB, { 0xE8, 0xA1, 0x81 },
	0xADCC, { 0xE8, 0xA1, 0x8E },
	0xADCD, { 0xE8, 0xA1, 0xA7 },
	0xADCE, { 0xE8, 0xA1, 0xAA },
	0xADCF, { 0xE8, 0xA1, 0xA9 },
	0xADD0, { 0xE8, 0xA7, 0x93 },
	0xADD1, { 0xE8, 0xA8, 0x84 },
	0xADD2, { 0xE8, 0xA8, 0x87 },
	0xADD3, { 0xE8, 0xB5, 0xB2 },
	0xADD4, { 0xE8, 0xBF, 0xA3 },
	0xADD5, { 0xE8, 0xBF, 0xA1 },
	0xADD6, { 0xE8, 0xBF, 0xAE },
	0xADD7, { 0xE8, 0xBF, 0xA0 },
	0xADD8, { 0xE9, 0x83, 0xB1 },
	0xADD9, { 0xE9, 0x82, 0xBD },
	0xADDA, { 0xE9, 0x82, 0xBF },
	0xADDB, { 0xE9, 0x83, 0x95 },
	0xADDC, { 0xE9, 0x83, 0x85 },
	0xADDD, { 0xE9, 0x82, 0xBE },
	0xADDE, { 0xE9, 0x83, 0x87 },
	0xADDF, { 0xE9, 0x83, 0x8B },
	0xADE0, { 0xE9, 0x83, 0x88 },
	0xADE1, { 0xE9, 0x87, 0x94 },
	0xADE2, { 0xE9, 0x87, 0x93 },
	0xADE3, { 0xE9, 0x99, 0x94 },
	0xADE4, { 0xE9, 0x99, 0x8F },
	0xADE5, { 0xE9, 0x99, 0x91 },
	0xADE6, { 0xE9, 0x99, 0x93 },
	0xADE7, { 0xE9, 0x99, 0x8A },
	0xADE8, { 0xE9, 0x99, 0x8E },
	0xADE9, { 0xE5, 0x80, 0x9E },
	0xADEA, { 0xE5, 0x80, 0x85 },
	0xADEB, { 0xE5, 0x80, 0x87 },
	0xADEC, { 0xE5, 0x80, 0x93 },
	0xADED, { 0xE5, 0x80, 0xA2 },
	0xADEE, { 0xE5, 0x80, 0xB0 },
	0xADEF, { 0xE5, 0x80, 0x9B },
	0xADF0, { 0xE4, 0xBF, 0xB5 },
	0xADF1, { 0xE4, 0xBF, 0xB4 },
	0xADF2, { 0xE5, 0x80, 0xB3 },
	0xADF3, { 0xE5, 0x80, 0xB7 },
	0xADF4, { 0xE5, 0x80, 0xAC },
	0xADF5, { 0xE4, 0xBF, 0xB6 },
	0xADF6, { 0xE4, 0xBF, 0xB7 },
	0xADF7, { 0xE5, 0x80, 0x97 },
	0xADF8, { 0xE5, 0x80, 0x9C },
	0xADF9, { 0xE5, 0x80, 0xA0 },
	0xADFA, { 0xE5, 0x80, 0xA7 },
	0xADFB, { 0xE5, 0x80, 0xB5 },
	0xADFC, { 0xE5, 0x80, 0xAF },
	0xADFD, { 0xE5, 0x80, 0xB1 },
	0xADFE, { 0xE5, 0x80, 0x8E },
	0xAEA1, { 0xE5, 0x85, 0x9A },
	0xAEA2, { 0xE5, 0x86, 0x94 },
	0xAEA3, { 0xE5, 0x86, 0x93 },
	0xAEA4, { 0xE5, 0x87, 0x8A },
	0xAEA5, { 0xE5, 0x87, 0x84 },
	0xAEA6, { 0xE5, 0x87, 0x85 },
	0xAEA7, { 0xE5, 0x87, 0x88 },
	0xAEA8, { 0xE5, 0x87, 0x8E },
	0xAEA9, { 0xE5, 0x89, 0xA1 },
	0xAEAA, { 0xE5, 0x89, 0x9A },
	0xAEAB, { 0xE5, 0x89, 0x92 },
	0xAEAC, { 0xE5, 0x89, 0x9E },
	0xAEAD, { 0xE5, 0x89, 0x9F },
	0xAEAE, { 0xE5, 0x89, 0x95 },
	0xAEAF, { 0xE5, 0x89, 0xA2 },
	0xAEB0, { 0xE5, 0x8B, 0x8D },
	0xAEB1, { 0xE5, 0x8C, 0x8E },
	0xAEB2, { 0xE5, 0x8E, 0x9E },
	0xAEB3, { 0xE5, 0x94, 0xA6 },
	0xAEB4, { 0xE5, 0x93, 0xA2 },
	0xAEB5, { 0xE5, 0x94, 0x97 },
	0xAEB6, { 0xE5, 0x94, 0x92 },
	0xAEB7, { 0xE5, 0x93, 0xA7 },
	0xAEB8, { 0xE5, 0x93, 0xB3 },
	0xAEB9, { 0xE5, 0x93, 0xA4 },
	0xAEBA, { 0xE5, 0x94, 0x9A },
	0xAEBB, { 0xE5, 0x93, 0xBF },
	0xAEBC, { 0xE5, 0x94, 0x84 },
	0xAEBD, { 0xE5, 0x94, 0x88 },
	0xAEBE, { 0xE5, 0x93, 0xAB },
	0xAEBF, { 0xE5, 0x94, 0x91 },
	0xAEC0, { 0xE5, 0x94, 0x85 },
	0xAEC1, { 0xE5, 0x93, 0xB1 },
	0xAEC2, { 0xE5, 0x94, 0x8A },
	0xAEC3, { 0xE5, 0x93, 0xBB },
	0xAEC4, { 0xE5, 0x93, 0xB7 },
	0xAEC5, { 0xE5, 0x93, 0xB8 },
	0xAEC6, { 0xE5, 0x93, 0xA0 },
	0xAEC7, { 0xE5, 0x94, 0x8E },
	0xAEC8, { 0xE5, 0x94, 0x83 },
	0xAEC9, { 0xE5, 0x94, 0x8B },
	0xAECA, { 0xE5, 0x9C, 0x81 },
	0xAECB, { 0xE5, 0x9C, 0x82 },
	0xAECC, { 0xE5, 0x9F, 0x8C },
	0xAECD, { 0xE5, 0xA0, 0xB2 },
	0xAECE, { 0xE5, 0x9F, 0x95 },
	0xAECF, { 0xE5, 0x9F, 0x92 },
	0xAED0, { 0xE5, 0x9E, 0xBA },
	0xAED1, { 0xE5, 0x9F, 0x86 },
	0xAED2, { 0xE5, 0x9E, 0xBD },
	0xAED3, { 0xE5, 0x9E, 0xBC },
	0xAED4, { 0xE5, 0x9E, 0xB8 },
	0xAED5, { 0xE5, 0x9E, 0xB6 },
	0xAED6, { 0xE5, 0x9E, 0xBF },
	0xAED7, { 0xE5, 0x9F, 0x87 },
	0xAED8, { 0xE5, 0x9F, 0x90 },
	0xAED9, { 0xE5, 0x9E, 0xB9 },
	0xAEDA, { 0xE5, 0x9F, 0x81 },
	0xAEDB, { 0xE5, 0xA4, 0x8E },
	0xAEDC, { 0xE5, 0xA5, 0x8A },
	0xAEDD, { 0xE5, 0xA8, 0x99 },
	0xAEDE, { 0xE5, 0xA8, 0x96 },
	0xAEDF, { 0xE5, 0xA8, 0xAD },
	0xAEE0, { 0xE5, 0xA8, 0xAE },
	0xAEE1, { 0xE5, 0xA8, 0x95 },
	0xAEE2, { 0xE5, 0xA8, 0x8F },
	0xAEE3, { 0xE5, 0xA8, 0x97 },
	0xAEE4, { 0xE5, 0xA8, 0x8A },
	0xAEE5, { 0xE5, 0xA8, 0x9E },
	0xAEE6, { 0xE5, 0xA8, 0xB3 },
	0xAEE7, { 0xE5, 0xAD, 0xAC },
	0xAEE8, { 0xE5, 0xAE, 0xA7 },
	0xAEE9, { 0xE5, 0xAE, 0xAD },
	0xAEEA, { 0xE5, 0xAE, 0xAC },
	0xAEEB, { 0xE5, 0xB0, 0x83 },
	0xAEEC, { 0xE5, 0xB1, 0x96 },
	0xAEED, { 0xE5, 0xB1, 0x94 },
	0xAEEE, { 0xE5, 0xB3, 0xAC },
	0xAEEF, { 0xE5, 0xB3, 0xBF },
	0xAEF0, { 0xE5, 0xB3, 0xAE },
	0xAEF1, { 0xE5, 0xB3, 0xB1 },
	0xAEF2, { 0xE5, 0xB3, 0xB7 },
	0xAEF3, { 0xE5, 0xB4, 0x80 },
	0xAEF4, { 0xE5, 0xB3, 0xB9 },
	0xAEF5, { 0xE5, 0xB8, 0xA9 },
	0xAEF6, { 0xE5, 0xB8, 0xA8 },
	0xAEF7, { 0xE5, 0xBA, 0xA8 },
	0xAEF8, { 0xE5, 0xBA, 0xAE },
	0xAEF9, { 0xE5, 0xBA, 0xAA },
	0xAEFA, { 0xE5, 0xBA, 0xAC },
	0xAEFB, { 0xE5, 0xBC, 0xB3 },
	0xAEFC, { 0xE5, 0xBC, 0xB0 },
	0xAEFD, { 0xE5, 0xBD, 0xA7 },
	0xAEFE, { 0xE6, 0x81, 0x9D },
	0xAFA1, { 0xE6, 0x81, 0x9A },
	0xAFA2, { 0xE6, 0x81, 0xA7 },
	0xAFA3, { 0xE6, 0x81, 0x81 },
	0xAFA4, { 0xE6, 0x82, 0xA2 },
	0xAFA5, { 0xE6, 0x82, 0x88 },
	0xAFA6, { 0xE6, 0x82, 0x80 },
	0xAFA7, { 0xE6, 0x82, 0x92 },
	0xAFA8, { 0xE6, 0x82, 0x81 },
	0xAFA9, { 0xE6, 0x82, 0x9D },
	0xAFAA, { 0xE6, 0x82, 0x83 },
	0xAFAB, { 0xE6, 0x82, 0x95 },
	0xAFAC, { 0xE6, 0x82, 0x9B },
	0xAFAD, { 0xE6, 0x82, 0x97 },
	0xAFAE, { 0xE6, 0x82, 0x87 },
	0xAFAF, { 0xE6, 0x82, 0x9C },
	0xAFB0, { 0xE6, 0x82, 0x8E },
	0xAFB1, { 0xE6, 0x88, 0x99 },
	0xAFB2, { 0xE6, 0x89, 0x86 },
	0xAFB3, { 0xE6, 0x8B, 0xB2 },
	0xAFB4, { 0xE6, 0x8C, 0x90 },
	0xAFB5, { 0xE6, 0x8D, 0x96 },
	0xAFB6, { 0xE6, 0x8C, 0xAC },
	0xAFB7, { 0xE6, 0x8D, 0x84 },
	0xAFB8, { 0xE6, 0x8D, 0x85 },
	0xAFB9, { 0xE6, 0x8C, 0xB6 },
	0xAFBA, { 0xE6, 0x8D, 0x83 },
	0xAFBB, { 0xE6, 0x8F, 0xA4 },
	0xAFBC, { 0xE6, 0x8C, 0xB9 },
	0xAFBD, { 0xE6, 0x8D, 0x8B },
	0xAFBE, { 0xE6, 0x8D, 0x8A },
	0xAFBF, { 0xE6, 0x8C, 0xBC },
	0xAFC0, { 0xE6, 0x8C, 0xA9 },
	0xAFC1, { 0xE6, 0x8D, 0x81 },
	0xAFC2, { 0xE6, 0x8C, 0xB4 },
	0xAFC3, { 0xE6, 0x8D, 0x98 },
	0xAFC4, { 0xE6, 0x8D, 0x94 },
	0xAFC5, { 0xE6, 0x8D, 0x99 },
	0xAFC6, { 0xE6, 0x8C, 0xAD },
	0xAFC7, { 0xE6, 0x8D, 0x87 },
	0xAFC8, { 0xE6, 0x8C, 0xB3 },
	0xAFC9, { 0xE6, 0x8D, 0x9A },
	0xAFCA, { 0xE6, 0x8D, 0x91 },
	0xAFCB, { 0xE6, 0x8C, 0xB8 },
	0xAFCC, { 0xE6, 0x8D, 0x97 },
	0xAFCD, { 0xE6, 0x8D, 0x80 },
	0xAFCE, { 0xE6, 0x8D, 0x88 },
	0xAFCF, { 0xE6, 0x95, 0x8A },
	0xAFD0, { 0xE6, 0x95, 0x86 },
	0xAFD1, { 0xE6, 0x97, 0x86 },
	0xAFD2, { 0xE6, 0x97, 0x83 },
	0xAFD3, { 0xE6, 0x97, 0x84 },
	0xAFD4, { 0xE6, 0x97, 0x82 },
	0xAFD5, { 0xE6, 0x99, 0x8A },
	0xAFD6, { 0xE6, 0x99, 0x9F },
	0xAFD7, { 0xE6, 0x99, 0x87 },
	0xAFD8, { 0xE6, 0x99, 0x91 },
	0xAFD9, { 0xE6, 0x9C, 0x92 },
	0xAFDA, { 0xE6, 0x9C, 0x93 },
	0xAFDB, { 0xE6, 0xA0, 0x9F },
	0xAFDC, { 0xE6, 0xA0, 0x9A },
	0xAFDD, { 0xE6, 0xA1, 0x89 },
	0xAFDE, { 0xE6, 0xA0, 0xB2 },
	0xAFDF, { 0xE6, 0xA0, 0xB3 },
	0xAFE0, { 0xE6, 0xA0, 0xBB },
	0xAFE1, { 0xE6, 0xA1, 0x8B },
	0xAFE2, { 0xE6, 0xA1, 0x8F },
	0xAFE3, { 0xE6, 0xA0, 0x96 },
	0xAFE4, { 0xE6, 0xA0, 0xB1 },
	0xAFE5, { 0xE6, 0xA0, 0x9C },
	0xAFE6, { 0xE6, 0xA0, 0xB5 },
	0xAFE7, { 0xE6, 0xA0, 0xAB },
	0xAFE8, { 0xE6, 0xA0, 0xAD },
	0xAFE9, { 0xE6, 0xA0, 0xAF },
	0xAFEA, { 0xE6, 0xA1, 0x8E },
	0xAFEB, { 0xE6, 0xA1, 0x84 },
	0xAFEC, { 0xE6, 0xA0, 0xB4 },
	0xAFED, { 0xE6, 0xA0, 0x9D },
	0xAFEE, { 0xE6, 0xA0, 0x92 },
	0xAFEF, { 0xE6, 0xA0, 0x94 },
	0xAFF0, { 0xE6, 0xA0, 0xA6 },
	0xAFF1, { 0xE6, 0xA0, 0xA8 },
	0xAFF2, { 0xE6, 0xA0, 0xAE },
	0xAFF3, { 0xE6, 0xA1, 0x8D },
	0xAFF4, { 0xE6, 0xA0, 0xBA },
	0xAFF5, { 0xE6, 0xA0, 0xA5 },
	0xAFF6, { 0xE6, 0xA0, 0xA0 },
	0xAFF7, { 0xE6, 0xAC, 0xAC },
	0xAFF8, { 0xE6, 0xAC, 0xAF },
	0xAFF9, { 0xE6, 0xAC, 0xAD },
	0xAFFA, { 0xE6, 0xAC, 0xB1 },
	0xAFFB, { 0xE6, 0xAC, 0xB4 },
	0xAFFC, { 0xE6, 0xAD, 0xAD },
	0xAFFD, { 0xE8, 0x82, 0x82 },
	0xAFFE, { 0xE6, 0xAE, 0x88 },
	0xB0A1, { 0xE6, 0xAF, 0xA6 },
	0xB0A2, { 0xE6, 0xAF, 0xA4 },
	0xB0A3, { 0xE6, 0xAF, 0xA8 },
	0xB0A4, { 0xE6, 0xAF, 0xA3 },
	0xB0A5, { 0xE6, 0xAF, 0xA2 },
	0xB0A6, { 0xE6, 0xAF, 0xA7 },
	0xB0A7, { 0xE6, 0xB0, 0xA5 },
	0xB0A8, { 0xE6, 0xB5, 0xBA },
	0xB0A9, { 0xE6, 0xB5, 0xA3 },
	0xB0AA, { 0xE6, 0xB5, 0xA4 },
	0xB0AB, { 0xE6, 0xB5, 0xB6 },
	0xB0AC, { 0xE6, 0xB4, 0x8D },
	0xB0AD, { 0xE6, 0xB5, 0xA1 },
	0xB0AE, { 0xE6, 0xB6, 0x92 },
	0xB0AF, { 0xE6, 0xB5, 0x98 },
	0xB0B0, { 0xE6, 0xB5, 0xA2 },
	0xB0B1, { 0xE6, 0xB5, 0xAD },
	0xB0B2, { 0xE6, 0xB5, 0xAF },
	0xB0B3, { 0xE6, 0xB6, 0x91 },
	0xB0B4, { 0xE6, 0xB6, 0x8D },
	0xB0B5, { 0xE6, 0xB7, 0xAF },
	0xB0B6, { 0xE6, 0xB5, 0xBF },
	0xB0B7, { 0xE6, 0xB6, 0x86 },
	0xB0B8, { 0xE6, 0xB5, 0x9E },
	0xB0B9, { 0xE6, 0xB5, 0xA7 },
	0xB0BA, { 0xE6, 0xB5, 0xA0 },
	0xB0BB, { 0xE6, 0xB6, 0x97 },
	0xB0BC, { 0xE6, 0xB5, 0xB0 },
	0xB0BD, { 0xE6, 0xB5, 0xBC },
	0xB0BE, { 0xE6, 0xB5, 0x9F },
	0xB0BF, { 0xE6, 0xB6, 0x82 },
	0xB0C0, { 0xE6, 0xB6, 0x98 },
	0xB0C1, { 0xE6, 0xB4, 0xAF },
	0xB0C2, { 0xE6, 0xB5, 0xA8 },
	0xB0C3, { 0xE6, 0xB6, 0x8B },
	0xB0C4, { 0xE6, 0xB5, 0xBE },
	0xB0C5, { 0xE6, 0xB6, 0x80 },
	0xB0C6, { 0xE6, 0xB6, 0x84 },
	0xB0C7, { 0xE6, 0xB4, 0x96 },
	0xB0C8, { 0xE6, 0xB6, 0x83 },
	0xB0C9, { 0xE6, 0xB5, 0xBB },
	0xB0CA, { 0xE6, 0xB5, 0xBD },
	0xB0CB, { 0xE6, 0xB5, 0xB5 },
	0xB0CC, { 0xE6, 0xB6, 0x90 },
	0xB0CD, { 0xE7, 0x83, 0x9C },
	0xB0CE, { 0xE7, 0x83, 0x93 },
	0xB0CF, { 0xE7, 0x83, 0x91 },
	0xB0D0, { 0xE7, 0x83, 0x9D },
	0xB0D1, { 0xE7, 0x83, 0x8B },
	0xB0D2, { 0xE7, 0xBC, 0xB9 },
	0xB0D3, { 0xE7, 0x83, 0xA2 },
	0xB0D4, { 0xE7, 0x83, 0x97 },
	0xB0D5, { 0xE7, 0x83, 0x92 },
	0xB0D6, { 0xE7, 0x83, 0x9E },
	0xB0D7, { 0xE7, 0x83, 0xA0 },
	0xB0D8, { 0xE7, 0x83, 0x94 },
	0xB0D9, { 0xE7, 0x83, 0x8D },
	0xB0DA, { 0xE7, 0x83, 0x85 },
	0xB0DB, { 0xE7, 0x83, 0x86 },
	0xB0DC, { 0xE7, 0x83, 0x87 },
	0xB0DD, { 0xE7, 0x83, 0x9A },
	0xB0DE, { 0xE7, 0x83, 0x8E },
	0xB0DF, { 0xE7, 0x83, 0xA1 },
	0xB0E0, { 0xE7, 0x89, 0x82 },
	0xB0E1, { 0xE7, 0x89, 0xB8 },
	0xB0E2, { 0xE7, 0x89, 0xB7 },
	0xB0E3, { 0xE7, 0x89, 0xB6 },
	0xB0E4, { 0xE7, 0x8C, 0x80 },
	0xB0E5, { 0xE7, 0x8B, 0xBA },
	0xB0E6, { 0xE7, 0x8B, 0xB4 },
	0xB0E7, { 0xE7, 0x8B, 0xBE },
	0xB0E8, { 0xE7, 0x8B, 0xB6 },
	0xB0E9, { 0xE7, 0x8B, 0xB3 },
	0xB0EA, { 0xE7, 0x8B, 0xBB },
	0xB0EB, { 0xE7, 0x8C, 0x81 },
	0xB0EC, { 0xE7, 0x8F, 0x93 },
	0xB0ED, { 0xE7, 0x8F, 0x99 },
	0xB0EE, { 0xE7, 0x8F, 0xA5 },
	0xB0EF, { 0xE7, 0x8F, 0x96 },
	0xB0F0, { 0xE7, 0x8E, 0xBC },
	0xB0F1, { 0xE7, 0x8F, 0xA7 },
	0xB0F2, { 0xE7, 0x8F, 0xA3 },
	0xB0F3, { 0xE7, 0x8F, 0xA9 },
	0xB0F4, { 0xE7, 0x8F, 0x9C },
	0xB0F5, { 0xE7, 0x8F, 0x92 },
	0xB0F6, { 0xE7, 0x8F, 0x9B },
	0xB0F7, { 0xE7, 0x8F, 0x94 },
	0xB0F8, { 0xE7, 0x8F, 0x9D },
	0xB0F9, { 0xE7, 0x8F, 0x9A },
	0xB0FA, { 0xE7, 0x8F, 0x97 },
	0xB0FB, { 0xE7, 0x8F, 0x98 },
	0xB0FC, { 0xE7, 0x8F, 0xA8 },
	0xB0FD, { 0xE7, 0x93, 0x9E },
	0xB0FE, { 0xE7, 0x93, 0x9F },
	0xB1A1, { 0xE7, 0x93, 0xB4 },
	0xB1A2, { 0xE7, 0x93, 0xB5 },
	0xB1A3, { 0xE7, 0x94, 0xA1 },
	0xB1A4, { 0xE7, 0x95, 0x9B },
	0xB1A5, { 0xE7, 0x95, 0x9F },
	0xB1A6, { 0xE7, 0x96, 0xB0 },
	0xB1A7, { 0xE7, 0x97, 0x81 },
	0xB1A8, { 0xE7, 0x96, 0xBB },
	0xB1A9, { 0xE7, 0x97, 0x84 },
	0xB1AA, { 0xE7, 0x97, 0x80 },
	0xB1AB, { 0xE7, 0x96, 0xBF },
	0xB1AC, { 0xE7, 0x96, 0xB6 },
	0xB1AD, { 0xE7, 0x96, 0xBA },
	0xB1AE, { 0xE7, 0x9A, 0x8A },
	0xB1AF, { 0xE7, 0x9B, 0x89 },
	0xB1B0, { 0xE7, 0x9C, 0x9D },
	0xB1B1, { 0xE7, 0x9C, 0x9B },
	0xB1B2, { 0xE7, 0x9C, 0x90 },
	0xB1B3, { 0xE7, 0x9C, 0x93 },
	0xB1B4, { 0xE7, 0x9C, 0x92 },
	0xB1B5, { 0xE7, 0x9C, 0xA3 },
	0xB1B6, { 0xE7, 0x9C, 0x91 },
	0xB1B7, { 0xE7, 0x9C, 0x95 },
	0xB1B8, { 0xE7, 0x9C, 0x99 },
	0xB1B9, { 0xE7, 0x9C, 0x9A },
	0xB1BA, { 0xE7, 0x9C, 0xA2 },
	0xB1BB, { 0xE7, 0x9C, 0xA7 },
	0xB1BC, { 0xE7, 0xA0, 0xA3 },
	0xB1BD, { 0xE7, 0xA0, 0xAC },
	0xB1BE, { 0xE7, 0xA0, 0xA2 },
	0xB1BF, { 0xE7, 0xA0, 0xB5 },
	0xB1C0, { 0xE7, 0xA0, 0xAF },
	0xB1C1, { 0xE7, 0xA0, 0xA8 },
	0xB1C2, { 0xE7, 0xA0, 0xAE },
	0xB1C3, { 0xE7, 0xA0, 0xAB },
	0xB1C4, { 0xE7, 0xA0, 0xA1 },
	0xB1C5, { 0xE7, 0xA0, 0xA9 },
	0xB1C6, { 0xE7, 0xA0, 0xB3 },
	0xB1C7, { 0xE7, 0xA0, 0xAA },
	0xB1C8, { 0xE7, 0xA0, 0xB1 },
	0xB1C9, { 0xE7, 0xA5, 0x94 },
	0xB1CA, { 0xE7, 0xA5, 0x9B },
	0xB1CB, { 0xE7, 0xA5, 0x8F },
	0xB1CC, { 0xE7, 0xA5, 0x9C },
	0xB1CD, { 0xE7, 0xA5, 0x93 },
	0xB1CE, { 0xE7, 0xA5, 0x92 },
	0xB1CF, { 0xE7, 0xA5, 0x91 },
	0xB1D0, { 0xE7, 0xA7, 0xAB },
	0xB1D1, { 0xE7, 0xA7, 0xAC },
	0xB1D2, { 0xE7, 0xA7, 0xA0 },
	0xB1D3, { 0xE7, 0xA7, 0xAE },
	0xB1D4, { 0xE7, 0xA7, 0xAD },
	0xB1D5, { 0xE7, 0xA7, 0xAA },
	0xB1D6, { 0xE7, 0xA7, 0x9C },
	0xB1D7, { 0xE7, 0xA7, 0x9E },
	0xB1D8, { 0xE7, 0xA7, 0x9D },
	0xB1D9, { 0xE7, 0xAA, 0x86 },
	0xB1DA, { 0xE7, 0xAA, 0x89 },
	0xB1DB, { 0xE7, 0xAA, 0x85 },
	0xB1DC, { 0xE7, 0xAA, 0x8B },
	0xB1DD, { 0xE7, 0xAA, 0x8C },
	0xB1DE, { 0xE7, 0xAA, 0x8A },
	0xB1DF, { 0xE7, 0xAA, 0x87 },
	0xB1E0, { 0xE7, 0xAB, 0x98 },
	0xB1E1, { 0xE7, 0xAC, 0x90 },
	0xB1E2, { 0xE7, 0xAC, 0x84 },
	0xB1E3, { 0xE7, 0xAC, 0x93 },
	0xB1E4, { 0xE7, 0xAC, 0x85 },
	0xB1E5, { 0xE7, 0xAC, 0x8F },
	0xB1E6, { 0xE7, 0xAC, 0x88 },
	0xB1E7, { 0xE7, 0xAC, 0x8A },
	0xB1E8, { 0xE7, 0xAC, 0x8E },
	0xB1E9, { 0xE7, 0xAC, 0x89 },
	0xB1EA, { 0xE7, 0xAC, 0x92 },
	0xB1EB, { 0xE7, 0xB2, 0x84 },
	0xB1EC, { 0xE7, 0xB2, 0x91 },
	0xB1ED, { 0xE7, 0xB2, 0x8A },
	0xB1EE, { 0xE7, 0xB2, 0x8C },
	0xB1EF, { 0xE7, 0xB2, 0x88 },
	0xB1F0, { 0xE7, 0xB2, 0x8D },
	0xB1F1, { 0xE7, 0xB2, 0x85 },
	0xB1F2, { 0xE7, 0xB4, 0x9E },
	0xB1F3, { 0xE7, 0xB4, 0x9D },
	0xB1F4, { 0xE7, 0xB4, 0x91 },
	0xB1F5, { 0xE7, 0xB4, 0x8E },
	0xB1F6, { 0xE7, 0xB4, 0x98 },
	0xB1F7, { 0xE7, 0xB4, 0x96 },
	0xB1F8, { 0xE7, 0xB4, 0x93 },
	0xB1F9, { 0xE7, 0xB4, 0x9F },
	0xB1FA, { 0xE7, 0xB4, 0x92 },
	0xB1FB, { 0xE7, 0xB4, 0x8F },
	0xB1FC, { 0xE7, 0xB4, 0x8C },
	0xB1FD, { 0xE7, 0xBD, 0x9C },
	0xB1FE, { 0xE7, 0xBD, 0xA1 },
	0xB2A1, { 0xE7, 0xBD, 0x9E },
	0xB2A2, { 0xE7, 0xBD, 0xA0 },
	0xB2A3, { 0xE7, 0xBD, 0x9D },
	0xB2A4, { 0xE7, 0xBD, 0x9B },
	0xB2A5, { 0xE7, 0xBE, 0x96 },
	0xB2A6, { 0xE7, 0xBE, 0x92 },
	0xB2A7, { 0xE7, 0xBF, 0x83 },
	0xB2A8, { 0xE7, 0xBF, 0x82 },
	0xB2A9, { 0xE7, 0xBF, 0x80 },
	0xB2AA, { 0xE8, 0x80, 0x96 },
	0xB2AB, { 0xE8, 0x80, 0xBE },
	0xB2AC, { 0xE8, 0x80, 0xB9 },
	0xB2AD, { 0xE8, 0x83, 0xBA },
	0xB2AE, { 0xE8, 0x83, 0xB2 },
	0xB2AF, { 0xE8, 0x83, 0xB9 },
	0xB2B0, { 0xE8, 0x83, 0xB5 },
	0xB2B1, { 0xE8, 0x84, 0x81 },
	0xB2B2, { 0xE8, 0x83, 0xBB },
	0xB2B3, { 0xE8, 0x84, 0x80 },
	0xB2B4, { 0xE8, 0x88, 0x81 },
	0xB2B5, { 0xE8, 0x88, 0xAF },
	0xB2B6, { 0xE8, 0x88, 0xA5 },
	0xB2B7, { 0xE8, 0x8C, 0xB3 },
	0xB2B8, { 0xE8, 0x8C, 0xAD },
	0xB2B9, { 0xE8, 0x8D, 0x84 },
	0xB2BA, { 0xE8, 0x8C, 0x99 },
	0xB2BB, { 0xE8, 0x8D, 0x91 },
	0xB2BC, { 0xE8, 0x8C, 0xA5 },
	0xB2BD, { 0xE8, 0x8D, 0x96 },
	0xB2BE, { 0xE8, 0x8C, 0xBF },
	0xB2BF, { 0xE8, 0x8D, 0x81 },
	0xB2C0, { 0xE8, 0x8C, 0xA6 },
	0xB2C1, { 0xE8, 0x8C, 0x9C },
	0xB2C2, { 0xE8, 0x8C, 0xA2 },
	0xB2C3, { 0xE8, 0x8D, 0x82 },
	0xB2C4, { 0xE8, 0x8D, 0x8E },
	0xB2C5, { 0xE8, 0x8C, 0x9B },
	0xB2C6, { 0xE8, 0x8C, 0xAA },
	0xB2C7, { 0xE8, 0x8C, 0x88 },
	0xB2C8, { 0xE8, 0x8C, 0xBC },
	0xB2C9, { 0xE8, 0x8D, 0x8D },
	0xB2CA, { 0xE8, 0x8C, 0x96 },
	0xB2CB, { 0xE8, 0x8C, 0xA4 },
	0xB2CC, { 0xE8, 0x8C, 0xA0 },
	0xB2CD, { 0xE8, 0x8C, 0xB7 },
	0xB2CE, { 0xE8, 0x8C, 0xAF },
	0xB2CF, { 0xE8, 0x8C, 0xA9 },
	0xB2D0, { 0xE8, 0x8D, 0x87 },
	0xB2D1, { 0xE8, 0x8D, 0x85 },
	0xB2D2, { 0xE8, 0x8D, 0x8C },
	0xB2D3, { 0xE8, 0x8D, 0x93 },
	0xB2D4, { 0xE8, 0x8C, 0x9E },
	0xB2D5, { 0xE8, 0x8C, 0xAC },
	0xB2D6, { 0xE8, 0x8D, 0x8B },
	0xB2D7, { 0xE8, 0x8C, 0xA7 },
	0xB2D8, { 0xE8, 0x8D, 0x88 },
	0xB2D9, { 0xE8, 0x99, 0x93 },
	0xB2DA, { 0xE8, 0x99, 0x92 },
	0xB2DB, { 0xE8, 0x9A, 0xA2 },
	0xB2DC, { 0xE8, 0x9A, 0xA8 },
	0xB2DD, { 0xE8, 0x9A, 0x96 },
	0xB2DE, { 0xE8, 0x9A, 0x8D },
	0xB2DF, { 0xE8, 0x9A, 0x91 },
	0xB2E0, { 0xE8, 0x9A, 0x9E },
	0xB2E1, { 0xE8, 0x9A, 0x87 },
	0xB2E2, { 0xE8, 0x9A, 0x97 },
	0xB2E3, { 0xE8, 0x9A, 0x86 },
	0xB2E4, { 0xE8, 0x9A, 0x8B },
	0xB2E5, { 0xE8, 0x9A, 0x9A },
	0xB2E6, { 0xE8, 0x9A, 0x85 },
	0xB2E7, { 0xE8, 0x9A, 0xA5 },
	0xB2E8, { 0xE8, 0x9A, 0x99 },
	0xB2E9, { 0xE8, 0x9A, 0xA1 },
	0xB2EA, { 0xE8, 0x9A, 0xA7 },
	0xB2EB, { 0xE8, 0x9A, 0x95 },
	0xB2EC, { 0xE8, 0x9A, 0x98 },
	0xB2ED, { 0xE8, 0x9A, 0x8E },
	0xB2EE, { 0xE8, 0x9A, 0x9D },
	0xB2EF, { 0xE8, 0x9A, 0x90 },
	0xB2F0, { 0xE8, 0x9A, 0x94 },
	0xB2F1, { 0xE8, 0xA1, 0x83 },
	0xB2F2, { 0xE8, 0xA1, 0x84 },
	0xB2F3, { 0xE8, 0xA1, 0xAD },
	0xB2F4, { 0xE8, 0xA1, 0xB5 },
	0xB2F5, { 0xE8, 0xA1, 0xB6 },
	0xB2F6, { 0xE8, 0xA1, 0xB2 },
	0xB2F7, { 0xE8, 0xA2, 0x80 },
	0xB2F8, { 0xE8, 0xA1, 0xB1 },
	0xB2F9, { 0xE8, 0xA1, 0xBF },
	0xB2FA, { 0xE8, 0xA1, 0xAF },
	0xB2FB, { 0xE8, 0xA2, 0x83 },
	0xB2FC, { 0xE8, 0xA1, 0xBE },
	0xB2FD, { 0xE8, 0xA1, 0xB4 },
	0xB2FE, { 0xE8, 0xA1, 0xBC },
	0xB3A1, { 0xE8, 0xA8, 0x92 },
	0xB3A2, { 0xE8, 0xB1, 0x87 },
	0xB3A3, { 0xE8, 0xB1, 0x97 },
	0xB3A4, { 0xE8, 0xB1, 0xBB },
	0xB3A5, { 0xE8, 0xB2, 0xA4 },
	0xB3A6, { 0xE8, 0xB2, 0xA3 },
	0xB3A7, { 0xE8, 0xB5, 0xB6 },
	0xB3A8, { 0xE8, 0xB5, 0xB8 },
	0xB3A9, { 0xE8, 0xB6, 0xB5 },
	0xB3AA, { 0xE8, 0xB6, 0xB7 },
	0xB3AB, { 0xE8, 0xB6, 0xB6 },
	0xB3AC, { 0xE8, 0xBB, 0x91 },
	0xB3AD, { 0xE8, 0xBB, 0x93 },
	0xB3AE, { 0xE8, 0xBF, 0xBE },
	0xB3AF, { 0xE8, 0xBF, 0xB5 },
	0xB3B0, { 0xE9, 0x80, 0x82 },
	0xB3B1, { 0xE8, 0xBF, 0xBF },
	0xB3B2, { 0xE8, 0xBF, 0xBB },
	0xB3B3, { 0xE9, 0x80, 0x84 },
	0xB3B4, { 0xE8, 0xBF, 0xBC },
	0xB3B5, { 0xE8, 0xBF, 0xB6 },
	0xB3B6, { 0xE9, 0x83, 0x96 },
	0xB3B7, { 0xE9, 0x83, 0xA0 },
	0xB3B8, { 0xE9, 0x83, 0x99 },
	0xB3B9, { 0xE9, 0x83, 0x9A },
	0xB3BA, { 0xE9, 0x83, 0xA3 },
	0xB3BB, { 0xE9, 0x83, 0x9F },
	0xB3BC, { 0xE9, 0x83, 0xA5 },
	0xB3BD, { 0xE9, 0x83, 0x98 },
	0xB3BE, { 0xE9, 0x83, 0x9B },
	0xB3BF, { 0xE9, 0x83, 0x97 },
	0xB3C0, { 0xE9, 0x83, 0x9C },
	0xB3C1, { 0xE9, 0x83, 0xA4 },
	0xB3C2, { 0xE9, 0x85, 0x90 },
	0xB3C3, { 0xE9, 0x85, 0x8E },
	0xB3C4, { 0xE9, 0x85, 0x8F },
	0xB3C5, { 0xE9, 0x87, 0x95 },
	0xB3C6, { 0xE9, 0x87, 0xA2 },
	0xB3C7, { 0xE9, 0x87, 0x9A },
	0xB3C8, { 0xE9, 0x99, 0x9C },
	0xB3C9, { 0xE9, 0x99, 0x9F },
	0xB3CA, { 0xE9, 0x9A, 0xBC },
	0xB3CB, { 0xE9, 0xA3, 0xA3 },
	0xB3CC, { 0xE9, 0xAB, 0x9F },
	0xB3CD, { 0xE9, 0xAC, 0xAF },
	0xB3CE, { 0xE4, 0xB9, 0xBF },
	0xB3CF, { 0xE5, 0x81, 0xB0 },
	0xB3D0, { 0xE5, 0x81, 0xAA },
	0xB3D1, { 0xE5, 0x81, 0xA1 },
	0xB3D2, { 0xE5, 0x81, 0x9E },
	0xB3D3, { 0xE5, 0x81, 0xA0 },
	0xB3D4, { 0xE5, 0x81, 0x93 },
	0xB3D5, { 0xE5, 0x81, 0x8B },
	0xB3D6, { 0xE5, 0x81, 0x9D },
	0xB3D7, { 0xE5, 0x81, 0xB2 },
	0xB3D8, { 0xE5, 0x81, 0x88 },
	0xB3D9, { 0xE5, 0x81, 0x8D },
	0xB3DA, { 0xE5, 0x81, 0x81 },
	0xB3DB, { 0xE5, 0x81, 0x9B },
	0xB3DC, { 0xE5, 0x81, 0x8A },
	0xB3DD, { 0xE5, 0x81, 0xA2 },
	0xB3DE, { 0xE5, 0x80, 0x95 },
	0xB3DF, { 0xE5, 0x81, 0x85 },
	0xB3E0, { 0xE5, 0x81, 0x9F },
	0xB3E1, { 0xE5, 0x81, 0xA9 },
	0xB3E2, { 0xE5, 0x81, 0xAB },
	0xB3E3, { 0xE5, 0x81, 0xA3 },
	0xB3E4, { 0xE5, 0x81, 0xA4 },
	0xB3E5, { 0xE5, 0x81, 0x86 },
	0xB3E6, { 0xE5, 0x81, 0x80 },
	0xB3E7, { 0xE5, 0x81, 0xAE },
	0xB3E8, { 0xE5, 0x81, 0xB3 },
	0xB3E9, { 0xE5, 0x81, 0x97 },
	0xB3EA, { 0xE5, 0x81, 0x91 },
	0xB3EB, { 0xE5, 0x87, 0x90 },
	0xB3EC, { 0xE5, 0x89, 0xAB },
	0xB3ED, { 0xE5, 0x89, 0xAD },
	0xB3EE, { 0xE5, 0x89, 0xAC },
	0xB3EF, { 0xE5, 0x89, 0xAE },
	0xB3F0, { 0xE5, 0x8B, 0x96 },
	0xB3F1, { 0xE5, 0x8B, 0x93 },
	0xB3F2, { 0xE5, 0x8C, 0xAD },
	0xB3F3, { 0xE5, 0x8E, 0x9C },
	0xB3F4, { 0xE5, 0x95, 0xB5 },
	0xB3F5, { 0xE5, 0x95, 0xB6 },
	0xB3F6, { 0xE5, 0x94, 0xBC },
	0xB3F7, { 0xE5, 0x95, 0x8D },
	0xB3F8, { 0xE5, 0x95, 0x90 },
	0xB3F9, { 0xE5, 0x94, 0xB4 },
	0xB3FA, { 0xE5, 0x94, 0xAA },
	0xB3FB, { 0xE5, 0x95, 0x91 },
	0xB3FC, { 0xE5, 0x95, 0xA2 },
	0xB3FD, { 0xE5, 0x94, 0xB6 },
	0xB3FE, { 0xE5, 0x94, 0xB5 },
	0xB4A1, { 0xE5, 0x94, 0xB0 },
	0xB4A2, { 0xE5, 0x95, 0x92 },
	0xB4A3, { 0xE5, 0x95, 0x85 },
	0xB4A4, { 0xE5, 0x94, 0x8C },
	0xB4A5, { 0xE5, 0x94, 0xB2 },
	0xB4A6, { 0xE5, 0x95, 0xA5 },
	0xB4A7, { 0xE5, 0x95, 0x8E },
	0xB4A8, { 0xE5, 0x94, 0xB9 },
	0xB4A9, { 0xE5, 0x95, 0x88 },
	0xB4AA, { 0xE5, 0x94, 0xAD },
	0xB4AB, { 0xE5, 0x94, 0xBB },
	0xB4AC, { 0xE5, 0x95, 0x80 },
	0xB4AD, { 0xE5, 0x95, 0x8B },
	0xB4AE, { 0xE5, 0x9C, 0x8A },
	0xB4AF, { 0xE5, 0x9C, 0x87 },
	0xB4B0, { 0xE5, 0x9F, 0xBB },
	0xB4B1, { 0xE5, 0xA0, 0x94 },
	0xB4B2, { 0xE5, 0x9F, 0xA2 },
	0xB4B3, { 0xE5, 0x9F, 0xB6 },
	0xB4B4, { 0xE5, 0x9F, 0x9C },
	0xB4B5, { 0xE5, 0x9F, 0xB4 },
	0xB4B6, { 0xE5, 0xA0, 0x80 },
	0xB4B7, { 0xE5, 0x9F, 0xAD },
	0xB4B8, { 0xE5, 0x9F, 0xBD },
	0xB4B9, { 0xE5, 0xA0, 0x88 },
	0xB4BA, { 0xE5, 0x9F, 0xB8 },
	0xB4BB, { 0xE5, 0xA0, 0x8B },
	0xB4BC, { 0xE5, 0x9F, 0xB3 },
	0xB4BD, { 0xE5, 0x9F, 0x8F },
	0xB4BE, { 0xE5, 0xA0, 0x87 },
	0xB4BF, { 0xE5, 0x9F, 0xAE },
	0xB4C0, { 0xE5, 0x9F, 0xA3 },
	0xB4C1, { 0xE5, 0x9F, 0xB2 },
	0xB4C2, { 0xE5, 0x9F, 0xA5 },
	0xB4C3, { 0xE5, 0x9F, 0xAC },
	0xB4C4, { 0xE5, 0x9F, 0xA1 },
	0xB4C5, { 0xE5, 0xA0, 0x8E },
	0xB4C6, { 0xE5, 0x9F, 0xBC },
	0xB4C7, { 0xE5, 0xA0, 0x90 },
	0xB4C8, { 0xE5, 0x9F, 0xA7 },
	0xB4C9, { 0xE5, 0xA0, 0x81 },
	0xB4CA, { 0xE5, 0xA0, 0x8C },
	0xB4CB, { 0xE5, 0x9F, 0xB1 },
	0xB4CC, { 0xE5, 0x9F, 0xA9 },
	0xB4CD, { 0xE5, 0x9F, 0xB0 },
	0xB4CE, { 0xE5, 0xA0, 0x8D },
	0xB4CF, { 0xE5, 0xA0, 0x84 },
	0xB4D0, { 0xE5, 0xA5, 0x9C },
	0xB4D1, { 0xE5, 0xA9, 0xA0 },
	0xB4D2, { 0xE5, 0xA9, 0x98 },
	0xB4D3, { 0xE5, 0xA9, 0x95 },
	0xB4D4, { 0xE5, 0xA9, 0xA7 },
	0xB4D5, { 0xE5, 0xA9, 0x9E },
	0xB4D6, { 0xE5, 0xA8, 0xB8 },
	0xB4D7, { 0xE5, 0xA8, 0xB5 },
	0xB4D8, { 0xE5, 0xA9, 0xAD },
	0xB4D9, { 0xE5, 0xA9, 0x90 },
	0xB4DA, { 0xE5, 0xA9, 0x9F },
	0xB4DB, { 0xE5, 0xA9, 0xA5 },
	0xB4DC, { 0xE5, 0xA9, 0xAC },
	0xB4DD, { 0xE5, 0xA9, 0x93 },
	0xB4DE, { 0xE5, 0xA9, 0xA4 },
	0xB4DF, { 0xE5, 0xA9, 0x97 },
	0xB4E0, { 0xE5, 0xA9, 0x83 },
	0xB4E1, { 0xE5, 0xA9, 0x9D },
	0xB4E2, { 0xE5, 0xA9, 0x92 },
	0xB4E3, { 0xE5, 0xA9, 0x84 },
	0xB4E4, { 0xE5, 0xA9, 0x9B },
	0xB4E5, { 0xE5, 0xA9, 0x88 },
	0xB4E6, { 0xE5, 0xAA, 0x8E },
	0xB4E7, { 0xE5, 0xA8, 0xBE },
	0xB4E8, { 0xE5, 0xA9, 0x8D },
	0xB4E9, { 0xE5, 0xA8, 0xB9 },
	0xB4EA, { 0xE5, 0xA9, 0x8C },
	0xB4EB, { 0xE5, 0xA9, 0xB0 },
	0xB4EC, { 0xE5, 0xA9, 0xA9 },
	0xB4ED, { 0xE5, 0xA9, 0x87 },
	0xB4EE, { 0xE5, 0xA9, 0x91 },
	0xB4EF, { 0xE5, 0xA9, 0x96 },
	0xB4F0, { 0xE5, 0xA9, 0x82 },
	0xB4F1, { 0xE5, 0xA9, 0x9C },
	0xB4F2, { 0xE5, 0xAD, 0xB2 },
	0xB4F3, { 0xE5, 0xAD, 0xAE },
	0xB4F4, { 0xE5, 0xAF, 0x81 },
	0xB4F5, { 0xE5, 0xAF, 0x80 },
	0xB4F6, { 0xE5, 0xB1, 0x99 },
	0xB4F7, { 0xE5, 0xB4, 0x9E },
	0xB4F8, { 0xE5, 0xB4, 0x8B },
	0xB4F9, { 0xE5, 0xB4, 0x9D },
	0xB4FA, { 0xE5, 0xB4, 0x9A },
	0xB4FB, { 0xE5, 0xB4, 0xA0 },
	0xB4FC, { 0xE5, 0xB4, 0x8C },
	0xB4FD, { 0xE5, 0xB4, 0xA8 },
	0xB4FE, { 0xE5, 0xB4, 0x8D },
	0xB5A1, { 0xE5, 0xB4, 0xA6 },
	0xB5A2, { 0xE5, 0xB4, 0xA5 },
	0xB5A3, { 0xE5, 0xB4, 0x8F },
	0xB5A4, { 0xE5, 0xB4, 0xB0 },
	0xB5A5, { 0xE5, 0xB4, 0x92 },
	0xB5A6, { 0xE5, 0xB4, 0xA3 },
	0xB5A7, { 0xE5, 0xB4, 0x9F },
	0xB5A8, { 0xE5, 0xB4, 0xAE },
	0xB5A9, { 0xE5, 0xB8, 0xBE },
	0xB5AA, { 0xE5, 0xB8, 0xB4 },
	0xB5AB, { 0xE5, 0xBA, 0xB1 },
	0xB5AC, { 0xE5, 0xBA, 0xB4 },
	0xB5AD, { 0xE5, 0xBA, 0xB9 },
	0xB5AE, { 0xE5, 0xBA, 0xB2 },
	0xB5AF, { 0xE5, 0xBA, 0xB3 },
	0xB5B0, { 0xE5, 0xBC, 0xB6 },
	0xB5B1, { 0xE5, 0xBC, 0xB8 },
	0xB5B2, { 0xE5, 0xBE, 0x9B },
	0xB5B3, { 0xE5, 0xBE, 0x96 },
	0xB5B4, { 0xE5, 0xBE, 0x9F },
	0xB5B5, { 0xE6, 0x82, 0x8A },
	0xB5B6, { 0xE6, 0x82, 0x90 },
	0xB5B7, { 0xE6, 0x82, 0x86 },
	0xB5B8, { 0xE6, 0x82, 0xBE },
	0xB5B9, { 0xE6, 0x82, 0xB0 },
	0xB5BA, { 0xE6, 0x82, 0xBA },
	0xB5BB, { 0xE6, 0x83, 0x93 },
	0xB5BC, { 0xE6, 0x83, 0x94 },
	0xB5BD, { 0xE6, 0x83, 0x8F },
	0xB5BE, { 0xE6, 0x83, 0xA4 },
	0xB5BF, { 0xE6, 0x83, 0x99 },
	0xB5C0, { 0xE6, 0x83, 0x9D },
	0xB5C1, { 0xE6, 0x83, 0x88 },
	0xB5C2, { 0xE6, 0x82, 0xB1 },
	0xB5C3, { 0xE6, 0x83, 0x9B },
	0xB5C4, { 0xE6, 0x82, 0xB7 },
	0xB5C5, { 0xE6, 0x83, 0x8A },
	0xB5C6, { 0xE6, 0x82, 0xBF },
	0xB5C7, { 0xE6, 0x83, 0x83 },
	0xB5C8, { 0xE6, 0x83, 0x8D },
	0xB5C9, { 0xE6, 0x83, 0x80 },
	0xB5CA, { 0xE6, 0x8C, 0xB2 },
	0xB5CB, { 0xE6, 0x8D, 0xA5 },
	0xB5CC, { 0xE6, 0x8E, 0x8A },
	0xB5CD, { 0xE6, 0x8E, 0x82 },
	0xB5CE, { 0xE6, 0x8D, 0xBD },
	0xB5CF, { 0xE6, 0x8E, 0xBD },
	0xB5D0, { 0xE6, 0x8E, 0x9E },
	0xB5D1, { 0xE6, 0x8E, 0xAD },
	0xB5D2, { 0xE6, 0x8E, 0x9D },
	0xB5D3, { 0xE6, 0x8E, 0x97 },
	0xB5D4, { 0xE6, 0x8E, 0xAB },
	0xB5D5, { 0xE6, 0x8E, 0x8E },
	0xB5D6, { 0xE6, 0x8D, 0xAF },
	0xB5D7, { 0xE6, 0x8E, 0x87 },
	0xB5D8, { 0xE6, 0x8E, 0x90 },
	0xB5D9, { 0xE6, 0x8D, 0xAE },
	0xB5DA, { 0xE6, 0x8E, 0xAF },
	0xB5DB, { 0xE6, 0x8D, 0xB5 },
	0xB5DC, { 0xE6, 0x8E, 0x9C },
	0xB5DD, { 0xE6, 0x8D, 0xAD },
	0xB5DE, { 0xE6, 0x8E, 0xAE },
	0xB5DF, { 0xE6, 0x8D, 0xBC },
	0xB5E0, { 0xE6, 0x8E, 0xA4 },
	0xB5E1, { 0xE6, 0x8C, 0xBB },
	0xB5E2, { 0xE6, 0x8E, 0x9F },
	0xB5E3, { 0xE6, 0x8D, 0xB8 },
	0xB5E4, { 0xE6, 0x8E, 0x85 },
	0xB5E5, { 0xE6, 0x8E, 0x81 },
	0xB5E6, { 0xE6, 0x8E, 0x91 },
	0xB5E7, { 0xE6, 0x8E, 0x8D },
	0xB5E8, { 0xE6, 0x8D, 0xB0 },
	0xB5E9, { 0xE6, 0x95, 0x93 },
	0xB5EA, { 0xE6, 0x97, 0x8D },
	0xB5EB, { 0xE6, 0x99, 0xA5 },
	0xB5EC, { 0xE6, 0x99, 0xA1 },
	0xB5ED, { 0xE6, 0x99, 0x9B },
	0xB5EE, { 0xE6, 0x99, 0x99 },
	0xB5EF, { 0xE6, 0x99, 0x9C },
	0xB5F0, { 0xE6, 0x99, 0xA2 },
	0xB5F1, { 0xE6, 0x9C, 0x98 },
	0xB5F2, { 0xE6, 0xA1, 0xB9 },
	0xB5F3, { 0xE6, 0xA2, 0x87 },
	0xB5F4, { 0xE6, 0xA2, 0x90 },
	0xB5F5, { 0xE6, 0xA2, 0x9C },
	0xB5F6, { 0xE6, 0xA1, 0xAD },
	0xB5F7, { 0xE6, 0xA1, 0xAE },
	0xB5F8, { 0xE6, 0xA2, 0xAE },
	0xB5F9, { 0xE6, 0xA2, 0xAB },
	0xB5FA, { 0xE6, 0xA5, 0x96 },
	0xB5FB, { 0xE6, 0xA1, 0xAF },
	0xB5FC, { 0xE6, 0xA2, 0xA3 },
	0xB5FD, { 0xE6, 0xA2, 0xAC },
	0xB5FE, { 0xE6, 0xA2, 0xA9 },
	0xB6A1, { 0xE6, 0xA1, 0xB5 },
	0xB6A2, { 0xE6, 0xA1, 0xB4 },
	0xB6A3, { 0xE6, 0xA2, 0xB2 },
	0xB6A4, { 0xE6, 0xA2, 0x8F },
	0xB6A5, { 0xE6, 0xA1, 0xB7 },
	0xB6A6, { 0xE6, 0xA2, 0x92 },
	0xB6A7, { 0xE6, 0xA1, 0xBC },
	0xB6A8, { 0xE6, 0xA1, 0xAB },
	0xB6A9, { 0xE6, 0xA1, 0xB2 },
	0xB6AA, { 0xE6, 0xA2, 0xAA },
	0xB6AB, { 0xE6, 0xA2, 0x80 },
	0xB6AC, { 0xE6, 0xA1, 0xB1 },
	0xB6AD, { 0xE6, 0xA1, 0xBE },
	0xB6AE, { 0xE6, 0xA2, 0x9B },
	0xB6AF, { 0xE6, 0xA2, 0x96 },
	0xB6B0, { 0xE6, 0xA2, 0x8B },
	0xB6B1, { 0xE6, 0xA2, 0xA0 },
	0xB6B2, { 0xE6, 0xA2, 0x89 },
	0xB6B3, { 0xE6, 0xA2, 0xA4 },
	0xB6B4, { 0xE6, 0xA1, 0xB8 },
	0xB6B5, { 0xE6, 0xA1, 0xBB },
	0xB6B6, { 0xE6, 0xA2, 0x91 },
	0xB6B7, { 0xE6, 0xA2, 0x8C },
	0xB6B8, { 0xE6, 0xA2, 0x8A },
	0xB6B9, { 0xE6, 0xA1, 0xBD },
	0xB6BA, { 0xE6, 0xAC, 0xB6 },
	0xB6BB, { 0xE6, 0xAC, 0xB3 },
	0xB6BC, { 0xE6, 0xAC, 0xB7 },
	0xB6BD, { 0xE6, 0xAC, 0xB8 },
	0xB6BE, { 0xE6, 0xAE, 0x91 },
	0xB6BF, { 0xE6, 0xAE, 0x8F },
	0xB6C0, { 0xE6, 0xAE, 0x8D },
	0xB6C1, { 0xE6, 0xAE, 0x8E },
	0xB6C2, { 0xE6, 0xAE, 0x8C },
	0xB6C3, { 0xE6, 0xB0, 0xAA },
	0xB6C4, { 0xE6, 0xB7, 0x80 },
	0xB6C5, { 0xE6, 0xB6, 0xAB },
	0xB6C6, { 0xE6, 0xB6, 0xB4 },
	0xB6C7, { 0xE6, 0xB6, 0xB3 },
	0xB6C8, { 0xE6, 0xB9, 0xB4 },
	0xB6C9, { 0xE6, 0xB6, 0xAC },
	0xB6CA, { 0xE6, 0xB7, 0xA9 },
	0xB6CB, { 0xE6, 0xB7, 0xA2 },
	0xB6CC, { 0xE6, 0xB6, 0xB7 },
	0xB6CD, { 0xE6, 0xB7, 0xB6 },
	0xB6CE, { 0xE6, 0xB7, 0x94 },
	0xB6CF, { 0xE6, 0xB8, 0x80 },
	0xB6D0, { 0xE6, 0xB7, 0x88 },
	0xB6D1, { 0xE6, 0xB7, 0xA0 },
	0xB6D2, { 0xE6, 0xB7, 0x9F },
	0xB6D3, { 0xE6, 0xB7, 0x96 },
	0xB6D4, { 0xE6, 0xB6, 0xBE },
	0xB6D5, { 0xE6, 0xB7, 0xA5 },
	0xB6D6, { 0xE6, 0xB7, 0x9C },
	0xB6D7, { 0xE6, 0xB7, 0x9D },
	0xB6D8, { 0xE6, 0xB7, 0x9B },
	0xB6D9, { 0xE6, 0xB7, 0xB4 },
	0xB6DA, { 0xE6, 0xB7, 0x8A },
	0xB6DB, { 0xE6, 0xB6, 0xBD },
	0xB6DC, { 0xE6, 0xB7, 0xAD },
	0xB6DD, { 0xE6, 0xB7, 0xB0 },
	0xB6DE, { 0xE6, 0xB6, 0xBA },
	0xB6DF, { 0xE6, 0xB7, 0x95 },
	0xB6E0, { 0xE6, 0xB7, 0x82 },
	0xB6E1, { 0xE6, 0xB7, 0x8F },
	0xB6E2, { 0xE6, 0xB7, 0x89 },
	0xB6E3, { 0xE6, 0xB7, 0x90 },
	0xB6E4, { 0xE6, 0xB7, 0xB2 },
	0xB6E5, { 0xE6, 0xB7, 0x93 },
	0xB6E6, { 0xE6, 0xB7, 0xBD },
	0xB6E7, { 0xE6, 0xB7, 0x97 },
	0xB6E8, { 0xE6, 0xB7, 0x8D },
	0xB6E9, { 0xE6, 0xB7, 0xA3 },
	0xB6EA, { 0xE6, 0xB6, 0xBB },
	0xB6EB, { 0xE7, 0x83, 0xBA },
	0xB6EC, { 0xE7, 0x84, 0x8D },
	0xB6ED, { 0xE7, 0x83, 0xB7 },
	0xB6EE, { 0xE7, 0x84, 0x97 },
	0xB6EF, { 0xE7, 0x83, 0xB4 },
	0xB6F0, { 0xE7, 0x84, 0x8C },
	0xB6F1, { 0xE7, 0x83, 0xB0 },
	0xB6F2, { 0xE7, 0x84, 0x84 },
	0xB6F3, { 0xE7, 0x83, 0xB3 },
	0xB6F4, { 0xE7, 0x84, 0x90 },
	0xB6F5, { 0xE7, 0x83, 0xBC },
	0xB6F6, { 0xE7, 0x83, 0xBF },
	0xB6F7, { 0xE7, 0x84, 0x86 },
	0xB6F8, { 0xE7, 0x84, 0x93 },
	0xB6F9, { 0xE7, 0x84, 0x80 },
	0xB6FA, { 0xE7, 0x83, 0xB8 },
	0xB6FB, { 0xE7, 0x83, 0xB6 },
	0xB6FC, { 0xE7, 0x84, 0x8B },
	0xB6FD, { 0xE7, 0x84, 0x82 },
	0xB6FE, { 0xE7, 0x84, 0x8E },
	0xB7A1, { 0xE7, 0x89, 0xBE },
	0xB7A2, { 0xE7, 0x89, 0xBB },
	0xB7A3, { 0xE7, 0x89, 0xBC },
	0xB7A4, { 0xE7, 0x89, 0xBF },
	0xB7A5, { 0xE7, 0x8C, 0x9D },
	0xB7A6, { 0xE7, 0x8C, 0x97 },
	0xB7A7, { 0xE7, 0x8C, 0x87 },
	0xB7A8, { 0xE7, 0x8C, 0x91 },
	0xB7A9, { 0xE7, 0x8C, 0x98 },
	0xB7AA, { 0xE7, 0x8C, 0x8A },
	0xB7AB, { 0xE7, 0x8C, 0x88 },
	0xB7AC, { 0xE7, 0x8B, 0xBF },
	0xB7AD, { 0xE7, 0x8C, 0x8F },
	0xB7AE, { 0xE7, 0x8C, 0x9E },
	0xB7AF, { 0xE7, 0x8E, 0x88 },
	0xB7B0, { 0xE7, 0x8F, 0xB6 },
	0xB7B1, { 0xE7, 0x8F, 0xB8 },
	0xB7B2, { 0xE7, 0x8F, 0xB5 },
	0xB7B3, { 0xE7, 0x90, 0x84 },
	0xB7B4, { 0xE7, 0x90, 0x81 },
	0xB7B5, { 0xE7, 0x8F, 0xBD },
	0xB7B6, { 0xE7, 0x90, 0x87 },
	0xB7B7, { 0xE7, 0x90, 0x80 },
	0xB7B8, { 0xE7, 0x8F, 0xBA },
	0xB7B9, { 0xE7, 0x8F, 0xBC },
	0xB7BA, { 0xE7, 0x8F, 0xBF },
	0xB7BB, { 0xE7, 0x90, 0x8C },
	0xB7BC, { 0xE7, 0x90, 0x8B },
	0xB7BD, { 0xE7, 0x8F, 0xB4 },
	0xB7BE, { 0xE7, 0x90, 0x88 },
	0xB7BF, { 0xE7, 0x95, 0xA4 },
	0xB7C0, { 0xE7, 0x95, 0xA3 },
	0xB7C1, { 0xE7, 0x97, 0x8E },
	0xB7C2, { 0xE7, 0x97, 0x92 },
	0xB7C3, { 0xE7, 0x97, 0x8F },
	0xB7C4, { 0xE7, 0x97, 0x8B },
	0xB7C5, { 0xE7, 0x97, 0x8C },
	0xB7C6, { 0xE7, 0x97, 0x91 },
	0xB7C7, { 0xE7, 0x97, 0x90 },
	0xB7C8, { 0xE7, 0x9A, 0x8F },
	0xB7C9, { 0xE7, 0x9A, 0x89 },
	0xB7CA, { 0xE7, 0x9B, 0x93 },
	0xB7CB, { 0xE7, 0x9C, 0xB9 },
	0xB7CC, { 0xE7, 0x9C, 0xAF },
	0xB7CD, { 0xE7, 0x9C, 0xAD },
	0xB7CE, { 0xE7, 0x9C, 0xB1 },
	0xB7CF, { 0xE7, 0x9C, 0xB2 },
	0xB7D0, { 0xE7, 0x9C, 0xB4 },
	0xB7D1, { 0xE7, 0x9C, 0xB3 },
	0xB7D2, { 0xE7, 0x9C, 0xBD },
	0xB7D3, { 0xE7, 0x9C, 0xA5 },
	0xB7D4, { 0xE7, 0x9C, 0xBB },
	0xB7D5, { 0xE7, 0x9C, 0xB5 },
	0xB7D6, { 0xE7, 0xA1, 0x88 },
	0xB7D7, { 0xE7, 0xA1, 0x92 },
	0xB7D8, { 0xE7, 0xA1, 0x89 },
	0xB7D9, { 0xE7, 0xA1, 0x8D },
	0xB7DA, { 0xE7, 0xA1, 0x8A },
	0xB7DB, { 0xE7, 0xA1, 0x8C },
	0xB7DC, { 0xE7, 0xA0, 0xA6 },
	0xB7DD, { 0xE7, 0xA1, 0x85 },
	0xB7DE, { 0xE7, 0xA1, 0x90 },
	0xB7DF, { 0xE7, 0xA5, 0xA4 },
	0xB7E0, { 0xE7, 0xA5, 0xA7 },
	0xB7E1, { 0xE7, 0xA5, 0xA9 },
	0xB7E2, { 0xE7, 0xA5, 0xAA },
	0xB7E3, { 0xE7, 0xA5, 0xA3 },
	0xB7E4, { 0xE7, 0xA5, 0xAB },
	0xB7E5, { 0xE7, 0xA5, 0xA1 },
	0xB7E6, { 0xE7, 0xA6, 0xBB },
	0xB7E7, { 0xE7, 0xA7, 0xBA },
	0xB7E8, { 0xE7, 0xA7, 0xB8 },
	0xB7E9, { 0xE7, 0xA7, 0xB6 },
	0xB7EA, { 0xE7, 0xA7, 0xB7 },
	0xB7EB, { 0xE7, 0xAA, 0x8F },
	0xB7EC, { 0xE7, 0xAA, 0x94 },
	0xB7ED, { 0xE7, 0xAA, 0x90 },
	0xB7EE, { 0xE7, 0xAC, 0xB5 },
	0xB7EF, { 0xE7, 0xAC, 0xBB },
	0xB7F0, { 0xE7, 0xAC, 0xB4 },
	0xB7F1, { 0xE7, 0xAC, 0xA5 },
	0xB7F2, { 0xE7, 0xAC, 0xB0 },
	0xB7F3, { 0xE7, 0xAC, 0xA2 },
	0xB7F4, { 0xE7, 0xAC, 0xA4 },
	0xB7F5, { 0xE7, 0xAC, 0xB3 },
	0xB7F6, { 0xE7, 0xAC, 0x98 },
	0xB7F7, { 0xE7, 0xAC, 0xAA },
	0xB7F8, { 0xE7, 0xAC, 0x9D },
	0xB7F9, { 0xE7, 0xAC, 0xB1 },
	0xB7FA, { 0xE7, 0xAC, 0xAB },
	0xB7FB, { 0xE7, 0xAC, 0xAD },
	0xB7FC, { 0xE7, 0xAC, 0xAF },
	0xB7FD, { 0xE7, 0xAC, 0xB2 },
	0xB7FE, { 0xE7, 0xAC, 0xB8 },
	0xB8A1, { 0xE7, 0xAC, 0x9A },
	0xB8A2, { 0xE7, 0xAC, 0xA3 },
	0xB8A3, { 0xE7, 0xB2, 0x94 },
	0xB8A4, { 0xE7, 0xB2, 0x98 },
	0xB8A5, { 0xE7, 0xB2, 0x96 },
	0xB8A6, { 0xE7, 0xB2, 0xA3 },
	0xB8A7, { 0xE7, 0xB4, 0xB5 },
	0xB8A8, { 0xE7, 0xB4, 0xBD },
	0xB8A9, { 0xE7, 0xB4, 0xB8 },
	0xB8AA, { 0xE7, 0xB4, 0xB6 },
	0xB8AB, { 0xE7, 0xB4, 0xBA },
	0xB8AC, { 0xE7, 0xB5, 0x85 },
	0xB8AD, { 0xE7, 0xB4, 0xAC },
	0xB8AE, { 0xE7, 0xB4, 0xA9 },
	0xB8AF, { 0xE7, 0xB5, 0x81 },
	0xB8B0, { 0xE7, 0xB5, 0x87 },
	0xB8B1, { 0xE7, 0xB4, 0xBE },
	0xB8B2, { 0xE7, 0xB4, 0xBF },
	0xB8B3, { 0xE7, 0xB5, 0x8A },
	0xB8B4, { 0xE7, 0xB4, 0xBB },
	0xB8B5, { 0xE7, 0xB4, 0xA8 },
	0xB8B6, { 0xE7, 0xBD, 0xA3 },
	0xB8B7, { 0xE7, 0xBE, 0x95 },
	0xB8B8, { 0xE7, 0xBE, 0x9C },
	0xB8B9, { 0xE7, 0xBE, 0x9D },
	0xB8BA, { 0xE7, 0xBE, 0x9B },
	0xB8BB, { 0xE7, 0xBF, 0x8A },
	0xB8BC, { 0xE7, 0xBF, 0x8B },
	0xB8BD, { 0xE7, 0xBF, 0x8D },
	0xB8BE, { 0xE7, 0xBF, 0x90 },
	0xB8BF, { 0xE7, 0xBF, 0x91 },
	0xB8C0, { 0xE7, 0xBF, 0x87 },
	0xB8C1, { 0xE7, 0xBF, 0x8F },
	0xB8C2, { 0xE7, 0xBF, 0x89 },
	0xB8C3, { 0xE8, 0x80, 0x9F },
	0xB8C4, { 0xE8, 0x80, 0x9E },
	0xB8C5, { 0xE8, 0x80, 0x9B },
	0xB8C6, { 0xE8, 0x81, 0x87 },
	0xB8C7, { 0xE8, 0x81, 0x83 },
	0xB8C8, { 0xE8, 0x81, 0x88 },
	0xB8C9, { 0xE8, 0x84, 0x98 },
	0xB8CA, { 0xE8, 0x84, 0xA5 },
	0xB8CB, { 0xE8, 0x84, 0x99 },
	0xB8CC, { 0xE8, 0x84, 0x9B },
	0xB8CD, { 0xE8, 0x84, 0xAD },
	0xB8CE, { 0xE8, 0x84, 0x9F },
	0xB8CF, { 0xE8, 0x84, 0xAC },
	0xB8D0, { 0xE8, 0x84, 0x9E },
	0xB8D1, { 0xE8, 0x84, 0xA1 },
	0xB8D2, { 0xE8, 0x84, 0x95 },
	0xB8D3, { 0xE8, 0x84, 0xA7 },
	0xB8D4, { 0xE8, 0x84, 0x9D },
	0xB8D5, { 0xE8, 0x84, 0xA2 },
	0xB8D6, { 0xE8, 0x88, 0x91 },
	0xB8D7, { 0xE8, 0x88, 0xB8 },
	0xB8D8, { 0xE8, 0x88, 0xB3 },
	0xB8D9, { 0xE8, 0x88, 0xBA },
	0xB8DA, { 0xE8, 0x88, 0xB4 },
	0xB8DB, { 0xE8, 0x88, 0xB2 },
	0xB8DC, { 0xE8, 0x89, 0xB4 },
	0xB8DD, { 0xE8, 0x8E, 0x90 },
	0xB8DE, { 0xE8, 0x8E, 0xA3 },
	0xB8DF, { 0xE8, 0x8E, 0xA8 },
	0xB8E0, { 0xE8, 0x8E, 0x8D },
	0xB8E1, { 0xE8, 0x8D, 0xBA },
	0xB8E2, { 0xE8, 0x8D, 0xB3 },
	0xB8E3, { 0xE8, 0x8E, 0xA4 },
	0xB8E4, { 0xE8, 0x8D, 0xB4 },
	0xB8E5, { 0xE8, 0x8E, 0x8F },
	0xB8E6, { 0xE8, 0x8E, 0x81 },
	0xB8E7, { 0xE8, 0x8E, 0x95 },
	0xB8E8, { 0xE8, 0x8E, 0x99 },
	0xB8E9, { 0xE8, 0x8D, 0xB5 },
	0xB8EA, { 0xE8, 0x8E, 0x94 },
	0xB8EB, { 0xE8, 0x8E, 0xA9 },
	0xB8EC, { 0xE8, 0x8D, 0xBD },
	0xB8ED, { 0xE8, 0x8E, 0x83 },
	0xB8EE, { 0xE8, 0x8E, 0x8C },
	0xB8EF, { 0xE8, 0x8E, 0x9D },
	0xB8F0, { 0xE8, 0x8E, 0x9B },
	0xB8F1, { 0xE8, 0x8E, 0xAA },
	0xB8F2, { 0xE8, 0x8E, 0x8B },
	0xB8F3, { 0xE8, 0x8D, 0xBE },
	0xB8F4, { 0xE8, 0x8E, 0xA5 },
	0xB8F5, { 0xE8, 0x8E, 0xAF },
	0xB8F6, { 0xE8, 0x8E, 0x88 },
	0xB8F7, { 0xE8, 0x8E, 0x97 },
	0xB8F8, { 0xE8, 0x8E, 0xB0 },
	0xB8F9, { 0xE8, 0x8D, 0xBF },
	0xB8FA, { 0xE8, 0x8E, 0xA6 },
	0xB8FB, { 0xE8, 0x8E, 0x87 },
	0xB8FC, { 0xE8, 0x8E, 0xAE },
	0xB8FD, { 0xE8, 0x8D, 0xB6 },
	0xB8FE, { 0xE8, 0x99, 0x99 },
	0xB9A1, { 0xE8, 0x99, 0x96 },
	0xB9A2, { 0xE8, 0x9A, 0xBF },
	0xB9A3, { 0xE8, 0x9A, 0xB7 },
	0xB9A4, { 0xE8, 0x9B, 0x82 },
	0xB9A5, { 0xE8, 0x9B, 0x81 },
	0xB9A6, { 0xE8, 0x9B, 0x85 },
	0xB9A7, { 0xE8, 0x9A, 0xBA },
	0xB9A8, { 0xE8, 0x9A, 0xB0 },
	0xB9A9, { 0xE8, 0x9B, 0x88 },
	0xB9AA, { 0xE8, 0x9A, 0xB9 },
	0xB9AB, { 0xE8, 0x9A, 0xB3 },
	0xB9AC, { 0xE8, 0x9A, 0xB8 },
	0xB9AD, { 0xE8, 0x9B, 0x8C },
	0xB9AE, { 0xE8, 0x9A, 0xB4 },
	0xB9AF, { 0xE8, 0x9A, 0xBB },
	0xB9B0, { 0xE8, 0x9A, 0xBC },
	0xB9B1, { 0xE8, 0x9B, 0x83 },
	0xB9B2, { 0xE8, 0x9A, 0xBD },
	0xB9B3, { 0xE8, 0x9A, 0xBE },
	0xB9B4, { 0xE8, 0xA1, 0x92 },
	0xB9B5, { 0xE8, 0xA2, 0x89 },
	0xB9B6, { 0xE8, 0xA2, 0x95 },
	0xB9B7, { 0xE8, 0xA2, 0xA8 },
	0xB9B8, { 0xE8, 0xA2, 0xA2 },
	0xB9B9, { 0xE8, 0xA2, 0xAA },
	0xB9BA, { 0xE8, 0xA2, 0x9A },
	0xB9BB, { 0xE8, 0xA2, 0x91 },
	0xB9BC, { 0xE8, 0xA2, 0xA1 },
	0xB9BD, { 0xE8, 0xA2, 0x9F },
	0xB9BE, { 0xE8, 0xA2, 0x98 },
	0xB9BF, { 0xE8, 0xA2, 0xA7 },
	0xB9C0, { 0xE8, 0xA2, 0x99 },
	0xB9C1, { 0xE8, 0xA2, 0x9B },
	0xB9C2, { 0xE8, 0xA2, 0x97 },
	0xB9C3, { 0xE8, 0xA2, 0xA4 },
	0xB9C4, { 0xE8, 0xA2, 0xAC },
	0xB9C5, { 0xE8, 0xA2, 0x8C },
	0xB9C6, { 0xE8, 0xA2, 0x93 },
	0xB9C7, { 0xE8, 0xA2, 0x8E },
	0xB9C8, { 0xE8, 0xA6, 0x82 },
	0xB9C9, { 0xE8, 0xA7, 0x96 },
	0xB9CA, { 0xE8, 0xA7, 0x99 },
	0xB9CB, { 0xE8, 0xA7, 0x95 },
	0xB9CC, { 0xE8, 0xA8, 0xB0 },
	0xB9CD, { 0xE8, 0xA8, 0xA7 },
	0xB9CE, { 0xE8, 0xA8, 0xAC },
	0xB9CF, { 0xE8, 0xA8, 0x9E },
	0xB9D0, { 0xE8, 0xB0, 0xB9 },
	0xB9D1, { 0xE8, 0xB0, 0xBB },
	0xB9D2, { 0xE8, 0xB1, 0x9C },
	0xB9D3, { 0xE8, 0xB1, 0x9D },
	0xB9D4, { 0xE8, 0xB1, 0xBD },
	0xB9D5, { 0xE8, 0xB2, 0xA5 },
	0xB9D6, { 0xE8, 0xB5, 0xBD },
	0xB9D7, { 0xE8, 0xB5, 0xBB },
	0xB9D8, { 0xE8, 0xB5, 0xB9 },
	0xB9D9, { 0xE8, 0xB6, 0xBC },
	0xB9DA, { 0xE8, 0xB7, 0x82 },
	0xB9DB, { 0xE8, 0xB6, 0xB9 },
	0xB9DC, { 0xE8, 0xB6, 0xBF },
	0xB9DD, { 0xE8, 0xB7, 0x81 },
	0xB9DE, { 0xE8, 0xBB, 0x98 },
	0xB9DF, { 0xE8, 0xBB, 0x9E },
	0xB9E0, { 0xE8, 0xBB, 0x9D },
	0xB9E1, { 0xE8, 0xBB, 0x9C },
	0xB9E2, { 0xE8, 0xBB, 0x97 },
	0xB9E3, { 0xE8, 0xBB, 0xA0 },
	0xB9E4, { 0xE8, 0xBB, 0xA1 },
	0xB9E5, { 0xE9, 0x80, 0xA4 },
	0xB9E6, { 0xE9, 0x80, 0x8B },
	0xB9E7, { 0xE9, 0x80, 0x91 },
	0xB9E8, { 0xE9, 0x80, 0x9C },
	0xB9E9, { 0xE9, 0x80, 0x8C },
	0xB9EA, { 0xE9, 0x80, 0xA1 },
	0xB9EB, { 0xE9, 0x83, 0xAF },
	0xB9EC, { 0xE9, 0x83, 0xAA },
	0xB9ED, { 0xE9, 0x83, 0xB0 },
	0xB9EE, { 0xE9, 0x83, 0xB4 },
	0xB9EF, { 0xE9, 0x83, 0xB2 },
	0xB9F0, { 0xE9, 0x83, 0xB3 },
	0xB9F1, { 0xE9, 0x83, 0x94 },
	0xB9F2, { 0xE9, 0x83, 0xAB },
	0xB9F3, { 0xE9, 0x83, 0xAC },
	0xB9F4, { 0xE9, 0x83, 0xA9 },
	0xB9F5, { 0xE9, 0x85, 0x96 },
	0xB9F6, { 0xE9, 0x85, 0x98 },
	0xB9F7, { 0xE9, 0x85, 0x9A },
	0xB9F8, { 0xE9, 0x85, 0x93 },
	0xB9F9, { 0xE9, 0x85, 0x95 },
	0xB9FA, { 0xE9, 0x87, 0xAC },
	0xB9FB, { 0xE9, 0x87, 0xB4 },
	0xB9FC, { 0xE9, 0x87, 0xB1 },
	0xB9FD, { 0xE9, 0x87, 0xB3 },
	0xB9FE, { 0xE9, 0x87, 0xB8 },
	0xBAA1, { 0xE9, 0x87, 0xA4 },
	0xBAA2, { 0xE9, 0x87, 0xB9 },
	0xBAA3, { 0xE9, 0x87, 0xAA },
	0xBAA4, { 0xE9, 0x87, 0xAB },
	0xBAA5, { 0xE9, 0x87, 0xB7 },
	0xBAA6, { 0xE9, 0x87, 0xA8 },
	0xBAA7, { 0xE9, 0x87, 0xAE },
	0xBAA8, { 0xE9, 0x95, 0xBA },
	0xBAA9, { 0xE9, 0x96, 0x86 },
	0xBAAA, { 0xE9, 0x96, 0x88 },
	0xBAAB, { 0xE9, 0x99, 0xBC },
	0xBAAC, { 0xE9, 0x99, 0xAD },
	0xBAAD, { 0xE9, 0x99, 0xAB },
	0xBAAE, { 0xE9, 0x99, 0xB1 },
	0xBAAF, { 0xE9, 0x99, 0xAF },
	0xBAB0, { 0xE9, 0x9A, 0xBF },
	0xBAB1, { 0xE9, 0x9D, 0xAA },
	0xBAB2, { 0xE9, 0xA0, 0x84 },
	0xBAB3, { 0xE9, 0xA3, 0xA5 },
	0xBAB4, { 0xE9, 0xA6, 0x97 },
	0xBAB5, { 0xE5, 0x82, 0x9B },
	0xBAB6, { 0xE5, 0x82, 0x95 },
	0xBAB7, { 0xE5, 0x82, 0x94 },
	0xBAB8, { 0xE5, 0x82, 0x9E },
	0xBAB9, { 0xE5, 0x82, 0x8B },
	0xBABA, { 0xE5, 0x82, 0xA3 },
	0xBABB, { 0xE5, 0x82, 0x83 },
	0xBABC, { 0xE5, 0x82, 0x8C },
	0xBABD, { 0xE5, 0x82, 0x8E },
	0xBABE, { 0xE5, 0x82, 0x9D },
	0xBABF, { 0xE5, 0x81, 0xA8 },
	0xBAC0, { 0xE5, 0x82, 0x9C },
	0xBAC1, { 0xE5, 0x82, 0x92 },
	0xBAC2, { 0xE5, 0x82, 0x82 },
	0xBAC3, { 0xE5, 0x82, 0x87 },
	0xBAC4, { 0xE5, 0x85, 0x9F },
	0xBAC5, { 0xE5, 0x87, 0x94 },
	0xBAC6, { 0xE5, 0x8C, 0x92 },
	0xBAC7, { 0xE5, 0x8C, 0x91 },
	0xBAC8, { 0xE5, 0x8E, 0xA4 },
	0xBAC9, { 0xE5, 0x8E, 0xA7 },
	0xBACA, { 0xE5, 0x96, 0x91 },
	0xBACB, { 0xE5, 0x96, 0xA8 },
	0xBACC, { 0xE5, 0x96, 0xA5 },
	0xBACD, { 0xE5, 0x96, 0xAD },
	0xBACE, { 0xE5, 0x95, 0xB7 },
	0xBACF, { 0xE5, 0x99, 0x85 },
	0xBAD0, { 0xE5, 0x96, 0xA2 },
	0xBAD1, { 0xE5, 0x96, 0x93 },
	0xBAD2, { 0xE5, 0x96, 0x88 },
	0xBAD3, { 0xE5, 0x96, 0x8F },
	0xBAD4, { 0xE5, 0x96, 0xB5 },
	0xBAD5, { 0xE5, 0x96, 0x81 },
	0xBAD6, { 0xE5, 0x96, 0xA3 },
	0xBAD7, { 0xE5, 0x96, 0x92 },
	0xBAD8, { 0xE5, 0x96, 0xA4 },
	0xBAD9, { 0xE5, 0x95, 0xBD },
	0xBADA, { 0xE5, 0x96, 0x8C },
	0xBADB, { 0xE5, 0x96, 0xA6 },
	0xBADC, { 0xE5, 0x95, 0xBF },
	0xBADD, { 0xE5, 0x96, 0x95 },
	0xBADE, { 0xE5, 0x96, 0xA1 },
	0xBADF, { 0xE5, 0x96, 0x8E },
	0xBAE0, { 0xE5, 0x9C, 0x8C },
	0xBAE1, { 0xE5, 0xA0, 0xA9 },
	0xBAE2, { 0xE5, 0xA0, 0xB7 },
	0xBAE3, { 0xE5, 0xA0, 0x99 },
	0xBAE4, { 0xE5, 0xA0, 0x9E },
	0xBAE5, { 0xE5, 0xA0, 0xA7 },
	0xBAE6, { 0xE5, 0xA0, 0xA3 },
	0xBAE7, { 0xE5, 0xA0, 0xA8 },
	0xBAE8, { 0xE5, 0x9F, 0xB5 },
	0xBAE9, { 0xE5, 0xA1, 0x88 },
	0xBAEA, { 0xE5, 0xA0, 0xA5 },
	0xBAEB, { 0xE5, 0xA0, 0x9C },
	0xBAEC, { 0xE5, 0xA0, 0x9B },
	0xBAED, { 0xE5, 0xA0, 0xB3 },
	0xBAEE, { 0xE5, 0xA0, 0xBF },
	0xBAEF, { 0xE5, 0xA0, 0xB6 },
	0xBAF0, { 0xE5, 0xA0, 0xAE },
	0xBAF1, { 0xE5, 0xA0, 0xB9 },
	0xBAF2, { 0xE5, 0xA0, 0xB8 },
	0xBAF3, { 0xE5, 0xA0, 0xAD },
	0xBAF4, { 0xE5, 0xA0, 0xAC },
	0xBAF5, { 0xE5, 0xA0, 0xBB },
	0xBAF6, { 0xE5, 0xA5, 0xA1 },
	0xBAF7, { 0xE5, 0xAA, 0xAF },
	0xBAF8, { 0xE5, 0xAA, 0x94 },
	0xBAF9, { 0xE5, 0xAA, 0x9F },
	0xBAFA, { 0xE5, 0xA9, 0xBA },
	0xBAFB, { 0xE5, 0xAA, 0xA2 },
	0xBAFC, { 0xE5, 0xAA, 0x9E },
	0xBAFD, { 0xE5, 0xA9, 0xB8 },
	0xBAFE, { 0xE5, 0xAA, 0xA6 },
	0xBBA1, { 0xE5, 0xA9, 0xBC },
	0xBBA2, { 0xE5, 0xAA, 0xA5 },
	0xBBA3, { 0xE5, 0xAA, 0xAC },
	0xBBA4, { 0xE5, 0xAA, 0x95 },
	0xBBA5, { 0xE5, 0xAA, 0xAE },
	0xBBA6, { 0xE5, 0xA8, 0xB7 },
	0xBBA7, { 0xE5, 0xAA, 0x84 },
	0xBBA8, { 0xE5, 0xAA, 0x8A },
	0xBBA9, { 0xE5, 0xAA, 0x97 },
	0xBBAA, { 0xE5, 0xAA, 0x83 },
	0xBBAB, { 0xE5, 0xAA, 0x8B },
	0xBBAC, { 0xE5, 0xAA, 0xA9 },
	0xBBAD, { 0xE5, 0xA9, 0xBB },
	0xBBAE, { 0xE5, 0xA9, 0xBD },
	0xBBAF, { 0xE5, 0xAA, 0x8C },
	0xBBB0, { 0xE5, 0xAA, 0x9C },
	0xBBB1, { 0xE5, 0xAA, 0x8F },
	0xBBB2, { 0xE5, 0xAA, 0x93 },
	0xBBB3, { 0xE5, 0xAA, 0x9D },
	0xBBB4, { 0xE5, 0xAF, 0xAA },
	0xBBB5, { 0xE5, 0xAF, 0x8D },
	0xBBB6, { 0xE5, 0xAF, 0x8B },
	0xBBB7, { 0xE5, 0xAF, 0x94 },
	0xBBB8, { 0xE5, 0xAF, 0x91 },
	0xBBB9, { 0xE5, 0xAF, 0x8A },
	0xBBBA, { 0xE5, 0xAF, 0x8E },
	0xBBBB, { 0xE5, 0xB0, 0x8C },
	0xBBBC, { 0xE5, 0xB0, 0xB0 },
	0xBBBD, { 0xE5, 0xB4, 0xB7 },
	0xBBBE, { 0xE5, 0xB5, 0x83 },
	0xBBBF, { 0xE5, 0xB5, 0xAB },
	0xBBC0, { 0xE5, 0xB5, 0x81 },
	0xBBC1, { 0xE5, 0xB5, 0x8B },
	0xBBC2, { 0xE5, 0xB4, 0xBF },
	0xBBC3, { 0xE5, 0xB4, 0xB5 },
	0xBBC4, { 0xE5, 0xB5, 0x91 },
	0xBBC5, { 0xE5, 0xB5, 0x8E },
	0xBBC6, { 0xE5, 0xB5, 0x95 },
	0xBBC7, { 0xE5, 0xB4, 0xB3 },
	0xBBC8, { 0xE5, 0xB4, 0xBA },
	0xBBC9, { 0xE5, 0xB5, 0x92 },
	0xBBCA, { 0xE5, 0xB4, 0xBD },
	0xBBCB, { 0xE5, 0xB4, 0xB1 },
	0xBBCC, { 0xE5, 0xB5, 0x99 },
	0xBBCD, { 0xE5, 0xB5, 0x82 },
	0xBBCE, { 0xE5, 0xB4, 0xB9 },
	0xBBCF, { 0xE5, 0xB5, 0x89 },
	0xBBD0, { 0xE5, 0xB4, 0xB8 },
	0xBBD1, { 0xE5, 0xB4, 0xBC },
	0xBBD2, { 0xE5, 0xB4, 0xB2 },
	0xBBD3, { 0xE5, 0xB4, 0xB6 },
	0xBBD4, { 0xE5, 0xB5, 0x80 },
	0xBBD5, { 0xE5, 0xB5, 0x85 },
	0xBBD6, { 0xE5, 0xB9, 0x84 },
	0xBBD7, { 0xE5, 0xB9, 0x81 },
	0xBBD8, { 0xE5, 0xBD, 0x98 },
	0xBBD9, { 0xE5, 0xBE, 0xA6 },
	0xBBDA, { 0xE5, 0xBE, 0xA5 },
	0xBBDB, { 0xE5, 0xBE, 0xAB },
	0xBBDC, { 0xE6, 0x83, 0x89 },
	0xBBDD, { 0xE6, 0x82, 0xB9 },
	0xBBDE, { 0xE6, 0x83, 0x8C },
	0xBBDF, { 0xE6, 0x83, 0xA2 },
	0xBBE0, { 0xE6, 0x83, 0x8E },
	0xBBE1, { 0xE6, 0x83, 0x84 },
	0xBBE2, { 0xE6, 0x84, 0x94 },
	0xBBE3, { 0xE6, 0x83, 0xB2 },
	0xBBE4, { 0xE6, 0x84, 0x8A },
	0xBBE5, { 0xE6, 0x84, 0x96 },
	0xBBE6, { 0xE6, 0x84, 0x85 },
	0xBBE7, { 0xE6, 0x83, 0xB5 },
	0xBBE8, { 0xE6, 0x84, 0x93 },
	0xBBE9, { 0xE6, 0x83, 0xB8 },
	0xBBEA, { 0xE6, 0x83, 0xBC },
	0xBBEB, { 0xE6, 0x83, 0xBE },
	0xBBEC, { 0xE6, 0x83, 0x81 },
	0xBBED, { 0xE6, 0x84, 0x83 },
	0xBBEE, { 0xE6, 0x84, 0x98 },
	0xBBEF, { 0xE6, 0x84, 0x9D },
	0xBBF0, { 0xE6, 0x84, 0x90 },
	0xBBF1, { 0xE6, 0x83, 0xBF },
	0xBBF2, { 0xE6, 0x84, 0x84 },
	0xBBF3, { 0xE6, 0x84, 0x8B },
	0xBBF4, { 0xE6, 0x89, 0x8A },
	0xBBF5, { 0xE6, 0x8E, 0x94 },
	0xBBF6, { 0xE6, 0x8E, 0xB1 },
	0xBBF7, { 0xE6, 0x8E, 0xB0 },
	0xBBF8, { 0xE6, 0x8F, 0x8E },
	0xBBF9, { 0xE6, 0x8F, 0xA5 },
	0xBBFA, { 0xE6, 0x8F, 0xA8 },
	0xBBFB, { 0xE6, 0x8F, 0xAF },
	0xBBFC, { 0xE6, 0x8F, 0x83 },
	0xBBFD, { 0xE6, 0x92, 0x9D },
	0xBBFE, { 0xE6, 0x8F, 0xB3 },
	0xBCA1, { 0xE6, 0x8F, 0x8A },
	0xBCA2, { 0xE6, 0x8F, 0xA0 },
	0xBCA3, { 0xE6, 0x8F, 0xB6 },
	0xBCA4, { 0xE6, 0x8F, 0x95 },
	0xBCA5, { 0xE6, 0x8F, 0xB2 },
	0xBCA6, { 0xE6, 0x8F, 0xB5 },
	0xBCA7, { 0xE6, 0x91, 0xA1 },
	0xBCA8, { 0xE6, 0x8F, 0x9F },
	0xBCA9, { 0xE6, 0x8E, 0xBE },
	0xBCAA, { 0xE6, 0x8F, 0x9D },
	0xBCAB, { 0xE6, 0x8F, 0x9C },
	0xBCAC, { 0xE6, 0x8F, 0x84 },
	0xBCAD, { 0xE6, 0x8F, 0x98 },
	0xBCAE, { 0xE6, 0x8F, 0x93 },
	0xBCAF, { 0xE6, 0x8F, 0x82 },
	0xBCB0, { 0xE6, 0x8F, 0x87 },
	0xBCB1, { 0xE6, 0x8F, 0x8C },
	0xBCB2, { 0xE6, 0x8F, 0x8B },
	0xBCB3, { 0xE6, 0x8F, 0x88 },
	0xBCB4, { 0xE6, 0x8F, 0xB0 },
	0xBCB5, { 0xE6, 0x8F, 0x97 },
	0xBCB6, { 0xE6, 0x8F, 0x99 },
	0xBCB7, { 0xE6, 0x94, 0xB2 },
	0xBCB8, { 0xE6, 0x95, 0xA7 },
	0xBCB9, { 0xE6, 0x95, 0xAA },
	0xBCBA, { 0xE6, 0x95, 0xA4 },
	0xBCBB, { 0xE6, 0x95, 0x9C },
	0xBCBC, { 0xE6, 0x95, 0xA8 },
	0xBCBD, { 0xE6, 0x95, 0xA5 },
	0xBCBE, { 0xE6, 0x96, 0x8C },
	0xBCBF, { 0xE6, 0x96, 0x9D },
	0xBCC0, { 0xE6, 0x96, 0x9E },
	0xBCC1, { 0xE6, 0x96, 0xAE },
	0xBCC2, { 0xE6, 0x97, 0x90 },
	0xBCC3, { 0xE6, 0x97, 0x92 },
	0xBCC4, { 0xE6, 0x99, 0xBC },
	0xBCC5, { 0xE6, 0x99, 0xAC },
	0xBCC6, { 0xE6, 0x99, 0xBB },
	0xBCC7, { 0xE6, 0x9A, 0x80 },
	0xBCC8, { 0xE6, 0x99, 0xB1 },
	0xBCC9, { 0xE6, 0x99, 0xB9 },
	0xBCCA, { 0xE6, 0x99, 0xAA },
	0xBCCB, { 0xE6, 0x99, 0xB2 },
	0xBCCC, { 0xE6, 0x9C, 0x81 },
	0xBCCD, { 0xE6, 0xA4, 0x8C },
	0xBCCE, { 0xE6, 0xA3, 0x93 },
	0xBCCF, { 0xE6, 0xA4, 0x84 },
	0xBCD0, { 0xE6, 0xA3, 0x9C },
	0xBCD1, { 0xE6, 0xA4, 0xAA },
	0xBCD2, { 0xE6, 0xA3, 0xAC },
	0xBCD3, { 0xE6, 0xA3, 0xAA },
	0xBCD4, { 0xE6, 0xA3, 0xB1 },
	0xBCD5, { 0xE6, 0xA4, 0x8F },
	0xBCD6, { 0xE6, 0xA3, 0x96 },
	0xBCD7, { 0xE6, 0xA3, 0xB7 },
	0xBCD8, { 0xE6, 0xA3, 0xAB },
	0xBCD9, { 0xE6, 0xA3, 0xA4 },
	0xBCDA, { 0xE6, 0xA3, 0xB6 },
	0xBCDB, { 0xE6, 0xA4, 0x93 },
	0xBCDC, { 0xE6, 0xA4, 0x90 },
	0xBCDD, { 0xE6, 0xA3, 0xB3 },
	0xBCDE, { 0xE6, 0xA3, 0xA1 },
	0xBCDF, { 0xE6, 0xA4, 0x87 },
	0xBCE0, { 0xE6, 0xA3, 0x8C },
	0xBCE1, { 0xE6, 0xA4, 0x88 },
	0xBCE2, { 0xE6, 0xA5, 0xB0 },
	0xBCE3, { 0xE6, 0xA2, 0xB4 },
	0xBCE4, { 0xE6, 0xA4, 0x91 },
	0xBCE5, { 0xE6, 0xA3, 0xAF },
	0xBCE6, { 0xE6, 0xA3, 0x86 },
	0xBCE7, { 0xE6, 0xA4, 0x94 },
	0xBCE8, { 0xE6, 0xA3, 0xB8 },
	0xBCE9, { 0xE6, 0xA3, 0x90 },
	0xBCEA, { 0xE6, 0xA3, 0xBD },
	0xBCEB, { 0xE6, 0xA3, 0xBC },
	0xBCEC, { 0xE6, 0xA3, 0xA8 },
	0xBCED, { 0xE6, 0xA4, 0x8B },
	0xBCEE, { 0xE6, 0xA4, 0x8A },
	0xBCEF, { 0xE6, 0xA4, 0x97 },
	0xBCF0, { 0xE6, 0xA3, 0x8E },
	0xBCF1, { 0xE6, 0xA3, 0x88 },
	0xBCF2, { 0xE6, 0xA3, 0x9D },
	0xBCF3, { 0xE6, 0xA3, 0x9E },
	0xBCF4, { 0xE6, 0xA3, 0xA6 },
	0xBCF5, { 0xE6, 0xA3, 0xB4 },
	0xBCF6, { 0xE6, 0xA3, 0x91 },
	0xBCF7, { 0xE6, 0xA4, 0x86 },
	0xBCF8, { 0xE6, 0xA3, 0x94 },
	0xBCF9, { 0xE6, 0xA3, 0xA9 },
	0xBCFA, { 0xE6, 0xA4, 0x95 },
	0xBCFB, { 0xE6, 0xA4, 0xA5 },
	0xBCFC, { 0xE6, 0xA3, 0x87 },
	0xBCFD, { 0xE6, 0xAC, 0xB9 },
	0xBCFE, { 0xE6, 0xAC, 0xBB },
	0xBDA1, { 0xE6, 0xAC, 0xBF },
	0xBDA2, { 0xE6, 0xAC, 0xBC },
	0xBDA3, { 0xE6, 0xAE, 0x94 },
	0xBDA4, { 0xE6, 0xAE, 0x97 },
	0xBDA5, { 0xE6, 0xAE, 0x99 },
	0xBDA6, { 0xE6, 0xAE, 0x95 },
	0xBDA7, { 0xE6, 0xAE, 0xBD },
	0xBDA8, { 0xE6, 0xAF, 0xB0 },
	0xBDA9, { 0xE6, 0xAF, 0xB2 },
	0xBDAA, { 0xE6, 0xAF, 0xB3 },
	0xBDAB, { 0xE6, 0xB0, 0xB0 },
	0xBDAC, { 0xE6, 0xB7, 0xBC },
	0xBDAD, { 0xE6, 0xB9, 0x86 },
	0xBDAE, { 0xE6, 0xB9, 0x87 },
	0xBDAF, { 0xE6, 0xB8, 0x9F },
	0xBDB0, { 0xE6, 0xB9, 0x89 },
	0xBDB1, { 0xE6, 0xBA, 0x88 },
	0xBDB2, { 0xE6, 0xB8, 0xBC },
	0xBDB3, { 0xE6, 0xB8, 0xBD },
	0xBDB4, { 0xE6, 0xB9, 0x85 },
	0xBDB5, { 0xE6, 0xB9, 0xA2 },
	0xBDB6, { 0xE6, 0xB8, 0xAB },
	0xBDB7, { 0xE6, 0xB8, 0xBF },
	0xBDB8, { 0xE6, 0xB9, 0x81 },
	0xBDB9, { 0xE6, 0xB9, 0x9D },
	0xBDBA, { 0xE6, 0xB9, 0xB3 },
	0xBDBB, { 0xE6, 0xB8, 0x9C },
	0xBDBC, { 0xE6, 0xB8, 0xB3 },
	0xBDBD, { 0xE6, 0xB9, 0x8B },
	0xBDBE, { 0xE6, 0xB9, 0x80 },
	0xBDBF, { 0xE6, 0xB9, 0x91 },
	0xBDC0, { 0xE6, 0xB8, 0xBB },
	0xBDC1, { 0xE6, 0xB8, 0x83 },
	0xBDC2, { 0xE6, 0xB8, 0xAE },
	0xBDC3, { 0xE6, 0xB9, 0x9E },
	0xBDC4, { 0xE6, 0xB9, 0xA8 },
	0xBDC5, { 0xE6, 0xB9, 0x9C },
	0xBDC6, { 0xE6, 0xB9, 0xA1 },
	0xBDC7, { 0xE6, 0xB8, 0xB1 },
	0xBDC8, { 0xE6, 0xB8, 0xA8 },
	0xBDC9, { 0xE6, 0xB9, 0xA0 },
	0xBDCA, { 0xE6, 0xB9, 0xB1 },
	0xBDCB, { 0xE6, 0xB9, 0xAB },
	0xBDCC, { 0xE6, 0xB8, 0xB9 },
	0xBDCD, { 0xE6, 0xB8, 0xA2 },
	0xBDCE, { 0xE6, 0xB8, 0xB0 },
	0xBDCF, { 0xE6, 0xB9, 0x93 },
	0xBDD0, { 0xE6, 0xB9, 0xA5 },
	0xBDD1, { 0xE6, 0xB8, 0xA7 },
	0xBDD2, { 0xE6, 0xB9, 0xB8 },
	0xBDD3, { 0xE6, 0xB9, 0xA4 },
	0xBDD4, { 0xE6, 0xB9, 0xB7 },
	0xBDD5, { 0xE6, 0xB9, 0x95 },
	0xBDD6, { 0xE6, 0xB9, 0xB9 },
	0xBDD7, { 0xE6, 0xB9, 0x92 },
	0xBDD8, { 0xE6, 0xB9, 0xA6 },
	0xBDD9, { 0xE6, 0xB8, 0xB5 },
	0xBDDA, { 0xE6, 0xB8, 0xB6 },
	0xBDDB, { 0xE6, 0xB9, 0x9A },
	0xBDDC, { 0xE7, 0x84, 0xA0 },
	0xBDDD, { 0xE7, 0x84, 0x9E },
	0xBDDE, { 0xE7, 0x84, 0xAF },
	0xBDDF, { 0xE7, 0x83, 0xBB },
	0xBDE0, { 0xE7, 0x84, 0xAE },
	0xBDE1, { 0xE7, 0x84, 0xB1 },
	0xBDE2, { 0xE7, 0x84, 0xA3 },
	0xBDE3, { 0xE7, 0x84, 0xA5 },
	0xBDE4, { 0xE7, 0x84, 0xA2 },
	0xBDE5, { 0xE7, 0x84, 0xB2 },
	0xBDE6, { 0xE7, 0x84, 0x9F },
	0xBDE7, { 0xE7, 0x84, 0xA8 },
	0xBDE8, { 0xE7, 0x84, 0xBA },
	0xBDE9, { 0xE7, 0x84, 0x9B },
	0xBDEA, { 0xE7, 0x89, 0x8B },
	0xBDEB, { 0xE7, 0x89, 0x9A },
	0xBDEC, { 0xE7, 0x8A, 0x88 },
	0xBDED, { 0xE7, 0x8A, 0x89 },
	0xBDEE, { 0xE7, 0x8A, 0x86 },
	0xBDEF, { 0xE7, 0x8A, 0x85 },
	0xBDF0, { 0xE7, 0x8A, 0x8B },
	0xBDF1, { 0xE7, 0x8C, 0x92 },
	0xBDF2, { 0xE7, 0x8C, 0x8B },
	0xBDF3, { 0xE7, 0x8C, 0xB0 },
	0xBDF4, { 0xE7, 0x8C, 0xA2 },
	0xBDF5, { 0xE7, 0x8C, 0xB1 },
	0xBDF6, { 0xE7, 0x8C, 0xB3 },
	0xBDF7, { 0xE7, 0x8C, 0xA7 },
	0xBDF8, { 0xE7, 0x8C, 0xB2 },
	0xBDF9, { 0xE7, 0x8C, 0xAD },
	0xBDFA, { 0xE7, 0x8C, 0xA6 },
	0xBDFB, { 0xE7, 0x8C, 0xA3 },
	0xBDFC, { 0xE7, 0x8C, 0xB5 },
	0xBDFD, { 0xE7, 0x8C, 0x8C },
	0xBDFE, { 0xE7, 0x90, 0xAE },
	0xBEA1, { 0xE7, 0x90, 0xAC },
	0xBEA2, { 0xE7, 0x90, 0xB0 },
	0xBEA3, { 0xE7, 0x90, 0xAB },
	0xBEA4, { 0xE7, 0x90, 0x96 },
	0xBEA5, { 0xE7, 0x90, 0x9A },
	0xBEA6, { 0xE7, 0x90, 0xA1 },
	0xBEA7, { 0xE7, 0x90, 0xAD },
	0xBEA8, { 0xE7, 0x90, 0xB1 },
	0xBEA9, { 0xE7, 0x90, 0xA4 },
	0xBEAA, { 0xE7, 0x90, 0xA3 },
	0xBEAB, { 0xE7, 0x90, 0x9D },
	0xBEAC, { 0xE7, 0x90, 0xA9 },
	0xBEAD, { 0xE7, 0x90, 0xA0 },
	0xBEAE, { 0xE7, 0x90, 0xB2 },
	0xBEAF, { 0xE7, 0x93, 0xBB },
	0xBEB0, { 0xE7, 0x94, 0xAF },
	0xBEB1, { 0xE7, 0x95, 0xAF },
	0xBEB2, { 0xE7, 0x95, 0xAC },
	0xBEB3, { 0xE7, 0x97, 0xA7 },
	0xBEB4, { 0xE7, 0x97, 0x9A },
	0xBEB5, { 0xE7, 0x97, 0xA1 },
	0xBEB6, { 0xE7, 0x97, 0xA6 },
	0xBEB7, { 0xE7, 0x97, 0x9D },
	0xBEB8, { 0xE7, 0x97, 0x9F },
	0xBEB9, { 0xE7, 0x97, 0xA4 },
	0xBEBA, { 0xE7, 0x97, 0x97 },
	0xBEBB, { 0xE7, 0x9A, 0x95 },
	0xBEBC, { 0xE7, 0x9A, 0x92 },
	0xBEBD, { 0xE7, 0x9B, 0x9A },
	0xBEBE, { 0xE7, 0x9D, 0x86 },
	0xBEBF, { 0xE7, 0x9D, 0x87 },
	0xBEC0, { 0xE7, 0x9D, 0x84 },
	0xBEC1, { 0xE7, 0x9D, 0x8D },
	0xBEC2, { 0xE7, 0x9D, 0x85 },
	0xBEC3, { 0xE7, 0x9D, 0x8A },
	0xBEC4, { 0xE7, 0x9D, 0x8E },
	0xBEC5, { 0xE7, 0x9D, 0x8B },
	0xBEC6, { 0xE7, 0x9D, 0x8C },
	0xBEC7, { 0xE7, 0x9F, 0x9E },
	0xBEC8, { 0xE7, 0x9F, 0xAC },
	0xBEC9, { 0xE7, 0xA1, 0xA0 },
	0xBECA, { 0xE7, 0xA1, 0xA4 },
	0xBECB, { 0xE7, 0xA1, 0xA5 },
	0xBECC, { 0xE7, 0xA1, 0x9C },
	0xBECD, { 0xE7, 0xA1, 0xAD },
	0xBECE, { 0xE7, 0xA1, 0xB1 },
	0xBECF, { 0xE7, 0xA1, 0xAA },
	0xBED0, { 0xE7, 0xA1, 0xAE },
	0xBED1, { 0xE7, 0xA1, 0xB0 },
	0xBED2, { 0xE7, 0xA1, 0xA9 },
	0xBED3, { 0xE7, 0xA1, 0xA8 },
	0xBED4, { 0xE7, 0xA1, 0x9E },
	0xBED5, { 0xE7, 0xA1, 0xA2 },
	0xBED6, { 0xE7, 0xA5, 0xB4 },
	0xBED7, { 0xE7, 0xA5, 0xB3 },
	0xBED8, { 0xE7, 0xA5, 0xB2 },
	0xBED9, { 0xE7, 0xA5, 0xB0 },
	0xBEDA, { 0xE7, 0xA8, 0x82 },
	0xBEDB, { 0xE7, 0xA8, 0x8A },
	0xBEDC, { 0xE7, 0xA8, 0x83 },
	0xBEDD, { 0xE7, 0xA8, 0x8C },
	0xBEDE, { 0xE7, 0xA8, 0x84 },
	0xBEDF, { 0xE7, 0xAA, 0x99 },
	0xBEE0, { 0xE7, 0xAB, 0xA6 },
	0xBEE1, { 0xE7, 0xAB, 0xA4 },
	0xBEE2, { 0xE7, 0xAD, 0x8A },
	0xBEE3, { 0xE7, 0xAD, 0x87 },
	0xBEE4, { 0xE7, 0xAD, 0x84 },
	0xBEE5, { 0xE7, 0xAD, 0x88 },
	0xBEE6, { 0xE7, 0xAD, 0x8C },
	0xBEE7, { 0xE7, 0xAD, 0x8E },
	0xBEE8, { 0xE7, 0xAD, 0x80 },
	0xBEE9, { 0xE7, 0xAD, 0x98 },
	0xBEEA, { 0xE7, 0xAD, 0x85 },
	0xBEEB, { 0xE7, 0xB2, 0xA2 },
	0xBEEC, { 0xE7, 0xB2, 0x9E },
	0xBEED, { 0xE7, 0xB2, 0xA8 },
	0xBEEE, { 0xE7, 0xB2, 0xA1 },
	0xBEEF, { 0xE7, 0xB5, 0x98 },
	0xBEF0, { 0xE7, 0xB5, 0xAF },
	0xBEF1, { 0xE7, 0xB5, 0xA3 },
	0xBEF2, { 0xE7, 0xB5, 0x93 },
	0xBEF3, { 0xE7, 0xB5, 0x96 },
	0xBEF4, { 0xE7, 0xB5, 0xA7 },
	0xBEF5, { 0xE7, 0xB5, 0xAA },
	0xBEF6, { 0xE7, 0xB5, 0x8F },
	0xBEF7, { 0xE7, 0xB5, 0xAD },
	0xBEF8, { 0xE7, 0xB5, 0x9C },
	0xBEF9, { 0xE7, 0xB5, 0xAB },
	0xBEFA, { 0xE7, 0xB5, 0x92 },
	0xBEFB, { 0xE7, 0xB5, 0x94 },
	0xBEFC, { 0xE7, 0xB5, 0xA9 },
	0xBEFD, { 0xE7, 0xB5, 0x91 },
	0xBEFE, { 0xE7, 0xB5, 0x9F },
	0xBFA1, { 0xE7, 0xB5, 0x8E },
	0xBFA2, { 0xE7, 0xBC, 0xBE },
	0xBFA3, { 0xE7, 0xBC, 0xBF },
	0xBFA4, { 0xE7, 0xBD, 0xA5 },
	0xBFA5, { 0xE7, 0xBD, 0xA6 },
	0xBFA6, { 0xE7, 0xBE, 0xA2 },
	0xBFA7, { 0xE7, 0xBE, 0xA0 },
	0xBFA8, { 0xE7, 0xBE, 0xA1 },
	0xBFA9, { 0xE7, 0xBF, 0x97 },
	0xBFAA, { 0xE8, 0x81, 0x91 },
	0xBFAB, { 0xE8, 0x81, 0x8F },
	0xBFAC, { 0xE8, 0x81, 0x90 },
	0xBFAD, { 0xE8, 0x83, 0xBE },
	0xBFAE, { 0xE8, 0x83, 0x94 },
	0xBFAF, { 0xE8, 0x85, 0x83 },
	0xBFB0, { 0xE8, 0x85, 0x8A },
	0xBFB1, { 0xE8, 0x85, 0x92 },
	0xBFB2, { 0xE8, 0x85, 0x8F },
	0xBFB3, { 0xE8, 0x85, 0x87 },
	0xBFB4, { 0xE8, 0x84, 0xBD },
	0xBFB5, { 0xE8, 0x85, 0x8D },
	0xBFB6, { 0xE8, 0x84, 0xBA },
	0xBFB7, { 0xE8, 0x87, 0xA6 },
	0xBFB8, { 0xE8, 0x87, 0xAE },
	0xBFB9, { 0xE8, 0x87, 0xB7 },
	0xBFBA, { 0xE8, 0x87, 0xB8 },
	0xBFBB, { 0xE8, 0x87, 0xB9 },
	0xBFBC, { 0xE8, 0x88, 0x84 },
	0xBFBD, { 0xE8, 0x88, 0xBC },
	0xBFBE, { 0xE8, 0x88, 0xBD },
	0xBFBF, { 0xE8, 0x88, 0xBF },
	0xBFC0, { 0xE8, 0x89, 0xB5 },
	0xBFC1, { 0xE8, 0x8C, 0xBB },
	0xBFC2, { 0xE8, 0x8F, 0x8F },
	0xBFC3, { 0xE8, 0x8F, 0xB9 },
	0xBFC4, { 0xE8, 0x90, 0xA3 },
	0xBFC5, { 0xE8, 0x8F, 0x80 },
	0xBFC6, { 0xE8, 0x8F, 0xA8 },
	0xBFC7, { 0xE8, 0x90, 0x92 },
	0xBFC8, { 0xE8, 0x8F, 0xA7 },
	0xBFC9, { 0xE8, 0x8F, 0xA4 },
	0xBFCA, { 0xE8, 0x8F, 0xBC },
	0xBFCB, { 0xE8, 0x8F, 0xB6 },
	0xBFCC, { 0xE8, 0x90, 0x90 },
	0xBFCD, { 0xE8, 0x8F, 0x86 },
	0xBFCE, { 0xE8, 0x8F, 0x88 },
	0xBFCF, { 0xE8, 0x8F, 0xAB },
	0xBFD0, { 0xE8, 0x8F, 0xA3 },
	0xBFD1, { 0xE8, 0x8E, 0xBF },
	0xBFD2, { 0xE8, 0x90, 0x81 },
	0xBFD3, { 0xE8, 0x8F, 0x9D },
	0xBFD4, { 0xE8, 0x8F, 0xA5 },
	0xBFD5, { 0xE8, 0x8F, 0x98 },
	0xBFD6, { 0xE8, 0x8F, 0xBF },
	0xBFD7, { 0xE8, 0x8F, 0xA1 },
	0xBFD8, { 0xE8, 0x8F, 0x8B },
	0xBFD9, { 0xE8, 0x8F, 0x8E },
	0xBFDA, { 0xE8, 0x8F, 0x96 },
	0xBFDB, { 0xE8, 0x8F, 0xB5 },
	0xBFDC, { 0xE8, 0x8F, 0x89 },
	0xBFDD, { 0xE8, 0x90, 0x89 },
	0xBFDE, { 0xE8, 0x90, 0x8F },
	0xBFDF, { 0xE8, 0x8F, 0x9E },
	0xBFE0, { 0xE8, 0x90, 0x91 },
	0xBFE1, { 0xE8, 0x90, 0x86 },
	0xBFE2, { 0xE8, 0x8F, 0x82 },
	0xBFE3, { 0xE8, 0x8F, 0xB3 },
	0xBFE4, { 0xE8, 0x8F, 0x95 },
	0xBFE5, { 0xE8, 0x8F, 0xBA },
	0xBFE6, { 0xE8, 0x8F, 0x87 },
	0xBFE7, { 0xE8, 0x8F, 0x91 },
	0xBFE8, { 0xE8, 0x8F, 0xAA },
	0xBFE9, { 0xE8, 0x90, 0x93 },
	0xBFEA, { 0xE8, 0x8E, 0x9A },
	0xBFEB, { 0xE8, 0x8F, 0x83 },
	0xBFEC, { 0xE8, 0x8F, 0xAC },
	0xBFED, { 0xE8, 0x8F, 0xAE },
	0xBFEE, { 0xE8, 0x8F, 0x84 },
	0xBFEF, { 0xE8, 0x8F, 0xBB },
	0xBFF0, { 0xE8, 0x8F, 0x97 },
	0xBFF1, { 0xE8, 0x8F, 0xA2 },
	0xBFF2, { 0xE8, 0x90, 0x9B },
	0xBFF3, { 0xE8, 0x8F, 0x9B },
	0xBFF4, { 0xE8, 0x8F, 0xBE },
	0xBFF5, { 0xE8, 0x9B, 0x98 },
	0xBFF6, { 0xE8, 0x9B, 0xA2 },
	0xBFF7, { 0xE8, 0x9B, 0xA6 },
	0xBFF8, { 0xE8, 0x9B, 0x93 },
	0xBFF9, { 0xE8, 0x9B, 0xA3 },
	0xBFFA, { 0xE8, 0x9B, 0x9A },
	0xBFFB, { 0xE8, 0x9B, 0xAA },
	0xBFFC, { 0xE8, 0x9B, 0x9D },
	0xBFFD, { 0xE8, 0x9B, 0xAB },
	0xBFFE, { 0xE8, 0x9B, 0x9C },
	0xC0A1, { 0xE8, 0x9B, 0xAC },
	0xC0A2, { 0xE8, 0x9B, 0xA9 },
	0xC0A3, { 0xE8, 0x9B, 0x97 },
	0xC0A4, { 0xE8, 0x9B, 0xA8 },
	0xC0A5, { 0xE8, 0x9B, 0x91 },
	0xC0A6, { 0xE8, 0xA1, 0x88 },
	0xC0A7, { 0xE8, 0xA1, 0x96 },
	0xC0A8, { 0xE8, 0xA1, 0x95 },
	0xC0A9, { 0xE8, 0xA2, 0xBA },
	0xC0AA, { 0xE8, 0xA3, 0x97 },
	0xC0AB, { 0xE8, 0xA2, 0xB9 },
	0xC0AC, { 0xE8, 0xA2, 0xB8 },
	0xC0AD, { 0xE8, 0xA3, 0x80 },
	0xC0AE, { 0xE8, 0xA2, 0xBE },
	0xC0AF, { 0xE8, 0xA2, 0xB6 },
	0xC0B0, { 0xE8, 0xA2, 0xBC },
	0xC0B1, { 0xE8, 0xA2, 0xB7 },
	0xC0B2, { 0xE8, 0xA2, 0xBD },
	0xC0B3, { 0xE8, 0xA2, 0xB2 },
	0xC0B4, { 0xE8, 0xA4, 0x81 },
	0xC0B5, { 0xE8, 0xA3, 0x89 },
	0xC0B6, { 0xE8, 0xA6, 0x95 },
	0xC0B7, { 0xE8, 0xA6, 0x98 },
	0xC0B8, { 0xE8, 0xA6, 0x97 },
	0xC0B9, { 0xE8, 0xA7, 0x9D },
	0xC0BA, { 0xE8, 0xA7, 0x9A },
	0xC0BB, { 0xE8, 0xA7, 0x9B },
	0xC0BC, { 0xE8, 0xA9, 0x8E },
	0xC0BD, { 0xE8, 0xA9, 0x8D },
	0xC0BE, { 0xE8, 0xA8, 0xB9 },
	0xC0BF, { 0xE8, 0xA9, 0x99 },
	0xC0C0, { 0xE8, 0xA9, 0x80 },
	0xC0C1, { 0xE8, 0xA9, 0x97 },
	0xC0C2, { 0xE8, 0xA9, 0x98 },
	0xC0C3, { 0xE8, 0xA9, 0x84 },
	0xC0C4, { 0xE8, 0xA9, 0x85 },
	0xC0C5, { 0xE8, 0xA9, 0x92 },
	0xC0C6, { 0xE8, 0xA9, 0x88 },
	0xC0C7, { 0xE8, 0xA9, 0x91 },
	0xC0C8, { 0xE8, 0xA9, 0x8A },
	0xC0C9, { 0xE8, 0xA9, 0x8C },
	0xC0CA, { 0xE8, 0xA9, 0x8F },
	0xC0CB, { 0xE8, 0xB1, 0x9F },
	0xC0CC, { 0xE8, 0xB2, 0x81 },
	0xC0CD, { 0xE8, 0xB2, 0x80 },
	0xC0CE, { 0xE8, 0xB2, 0xBA },
	0xC0CF, { 0xE8, 0xB2, 0xBE },
	0xC0D0, { 0xE8, 0xB2, 0xB0 },
	0xC0D1, { 0xE8, 0xB2, 0xB9 },
	0xC0D2, { 0xE8, 0xB2, 0xB5 },
	0xC0D3, { 0xE8, 0xB6, 0x84 },
	0xC0D4, { 0xE8, 0xB6, 0x80 },
	0xC0D5, { 0xE8, 0xB6, 0x89 },
	0xC0D6, { 0xE8, 0xB7, 0x98 },
	0xC0D7, { 0xE8, 0xB7, 0x93 },
	0xC0D8, { 0xE8, 0xB7, 0x8D },
	0xC0D9, { 0xE8, 0xB7, 0x87 },
	0xC0DA, { 0xE8, 0xB7, 0x96 },
	0xC0DB, { 0xE8, 0xB7, 0x9C },
	0xC0DC, { 0xE8, 0xB7, 0x8F },
	0xC0DD, { 0xE8, 0xB7, 0x95 },
	0xC0DE, { 0xE8, 0xB7, 0x99 },
	0xC0DF, { 0xE8, 0xB7, 0x88 },
	0xC0E0, { 0xE8, 0xB7, 0x97 },
	0xC0E1, { 0xE8, 0xB7, 0x85 },
	0xC0E2, { 0xE8, 0xBB, 0xAF },
	0xC0E3, { 0xE8, 0xBB, 0xB7 },
	0xC0E4, { 0xE8, 0xBB, 0xBA },
	0xC0E5, { 0xE8, 0xBB, 0xB9 },
	0xC0E6, { 0xE8, 0xBB, 0xA6 },
	0xC0E7, { 0xE8, 0xBB, 0xAE },
	0xC0E8, { 0xE8, 0xBB, 0xA5 },
	0xC0E9, { 0xE8, 0xBB, 0xB5 },
	0xC0EA, { 0xE8, 0xBB, 0xA7 },
	0xC0EB, { 0xE8, 0xBB, 0xA8 },
	0xC0EC, { 0xE8, 0xBB, 0xB6 },
	0xC0ED, { 0xE8, 0xBB, 0xAB },
	0xC0EE, { 0xE8, 0xBB, 0xB1 },
	0xC0EF, { 0xE8, 0xBB, 0xAC },
	0xC0F0, { 0xE8, 0xBB, 0xB4 },
	0xC0F1, { 0xE8, 0xBB, 0xA9 },
	0xC0F2, { 0xE9, 0x80, 0xAD },
	0xC0F3, { 0xE9, 0x80, 0xB4 },
	0xC0F4, { 0xE9, 0x80, 0xAF },
	0xC0F5, { 0xE9, 0x84, 0x86 },
	0xC0F6, { 0xE9, 0x84, 0xAC },
	0xC0F7, { 0xE9, 0x84, 0x84 },
	0xC0F8, { 0xE9, 0x83, 0xBF },
	0xC0F9, { 0xE9, 0x83, 0xBC },
	0xC0FA, { 0xE9, 0x84, 0x88 },
	0xC0FB, { 0xE9, 0x83, 0xB9 },
	0xC0FC, { 0xE9, 0x83, 0xBB },
	0xC0FD, { 0xE9, 0x84, 0x81 },
	0xC0FE, { 0xE9, 0x84, 0x80 },
	0xC1A1, { 0xE9, 0x84, 0x87 },
	0xC1A2, { 0xE9, 0x84, 0x85 },
	0xC1A3, { 0xE9, 0x84, 0x83 },
	0xC1A4, { 0xE9, 0x85, 0xA1 },
	0xC1A5, { 0xE9, 0x85, 0xA4 },
	0xC1A6, { 0xE9, 0x85, 0x9F },
	0xC1A7, { 0xE9, 0x85, 0xA2 },
	0xC1A8, { 0xE9, 0x85, 0xA0 },
	0xC1A9, { 0xE9, 0x88, 0x81 },
	0xC1AA, { 0xE9, 0x88, 0x8A },
	0xC1AB, { 0xE9, 0x88, 0xA5 },
	0xC1AC, { 0xE9, 0x88, 0x83 },
	0xC1AD, { 0xE9, 0x88, 0x9A },
	0xC1AE, { 0xE9, 0x88, 0xA6 },
	0xC1AF, { 0xE9, 0x88, 0x8F },
	0xC1B0, { 0xE9, 0x88, 0x8C },
	0xC1B1, { 0xE9, 0x88, 0x80 },
	0xC1B2, { 0xE9, 0x88, 0x92 },
	0xC1B3, { 0xE9, 0x87, 0xBF },
	0xC1B4, { 0xE9, 0x87, 0xBD },
	0xC1B5, { 0xE9, 0x88, 0x86 },
	0xC1B6, { 0xE9, 0x88, 0x84 },
	0xC1B7, { 0xE9, 0x88, 0xA7 },
	0xC1B8, { 0xE9, 0x88, 0x82 },
	0xC1B9, { 0xE9, 0x88, 0x9C },
	0xC1BA, { 0xE9, 0x88, 0xA4 },
	0xC1BB, { 0xE9, 0x88, 0x99 },
	0xC1BC, { 0xE9, 0x88, 0x97 },
	0xC1BD, { 0xE9, 0x88, 0x85 },
	0xC1BE, { 0xE9, 0x88, 0x96 },
	0xC1BF, { 0xE9, 0x95, 0xBB },
	0xC1C0, { 0xE9, 0x96, 0x8D },
	0xC1C1, { 0xE9, 0x96, 0x8C },
	0xC1C2, { 0xE9, 0x96, 0x90 },
	0xC1C3, { 0xE9, 0x9A, 0x87 },
	0xC1C4, { 0xE9, 0x99, 0xBE },
	0xC1C5, { 0xE9, 0x9A, 0x88 },
	0xC1C6, { 0xE9, 0x9A, 0x89 },
	0xC1C7, { 0xE9, 0x9A, 0x83 },
	0xC1C8, { 0xE9, 0x9A, 0x80 },
	0xC1C9, { 0xE9, 0x9B, 0x82 },
	0xC1CA, { 0xE9, 0x9B, 0x88 },
	0xC1CB, { 0xE9, 0x9B, 0x83 },
	0xC1CC, { 0xE9, 0x9B, 0xB1 },
	0xC1CD, { 0xE9, 0x9B, 0xB0 },
	0xC1CE, { 0xE9, 0x9D, 0xAC },
	0xC1CF, { 0xE9, 0x9D, 0xB0 },
	0xC1D0, { 0xE9, 0x9D, 0xAE },
	0xC1D1, { 0xE9, 0xA0, 0x87 },
	0xC1D2, { 0xE9, 0xA2, 0xA9 },
	0xC1D3, { 0xE9, 0xA3, 0xAB },
	0xC1D4, { 0xE9, 0xB3, 0xA6 },
	0xC1D5, { 0xE9, 0xBB, 0xB9 },
	0xC1D6, { 0xE4, 0xBA, 0x83 },
	0xC1D7, { 0xE4, 0xBA, 0x84 },
	0xC1D8, { 0xE4, 0xBA, 0xB6 },
	0xC1D9, { 0xE5, 0x82, 0xBD },
	0xC1DA, { 0xE5, 0x82, 0xBF },
	0xC1DB, { 0xE5, 0x83, 0x86 },
	0xC1DC, { 0xE5, 0x82, 0xAE },
	0xC1DD, { 0xE5, 0x83, 0x84 },
	0xC1DE, { 0xE5, 0x83, 0x8A },
	0xC1DF, { 0xE5, 0x82, 0xB4 },
	0xC1E0, { 0xE5, 0x83, 0x88 },
	0xC1E1, { 0xE5, 0x83, 0x82 },
	0xC1E2, { 0xE5, 0x82, 0xB0 },
	0xC1E3, { 0xE5, 0x83, 0x81 },
	0xC1E4, { 0xE5, 0x82, 0xBA },
	0xC1E5, { 0xE5, 0x82, 0xB1 },
	0xC1E6, { 0xE5, 0x83, 0x8B },
	0xC1E7, { 0xE5, 0x83, 0x89 },
	0xC1E8, { 0xE5, 0x82, 0xB6 },
	0xC1E9, { 0xE5, 0x82, 0xB8 },
	0xC1EA, { 0xE5, 0x87, 0x97 },
	0xC1EB, { 0xE5, 0x89, 0xBA },
	0xC1EC, { 0xE5, 0x89, 0xB8 },
	0xC1ED, { 0xE5, 0x89, 0xBB },
	0xC1EE, { 0xE5, 0x89, 0xBC },
	0xC1EF, { 0xE5, 0x97, 0x83 },
	0xC1F0, { 0xE5, 0x97, 0x9B },
	0xC1F1, { 0xE5, 0x97, 0x8C },
	0xC1F2, { 0xE5, 0x97, 0x90 },
	0xC1F3, { 0xE5, 0x97, 0x8B },
	0xC1F4, { 0xE5, 0x97, 0x8A },
	0xC1F5, { 0xE5, 0x97, 0x9D },
	0xC1F6, { 0xE5, 0x97, 0x80 },
	0xC1F7, { 0xE5, 0x97, 0x94 },
	0xC1F8, { 0xE5, 0x97, 0x84 },
	0xC1F9, { 0xE5, 0x97, 0xA9 },
	0xC1FA, { 0xE5, 0x96, 0xBF },
	0xC1FB, { 0xE5, 0x97, 0x92 },
	0xC1FC, { 0xE5, 0x96, 0x8D },
	0xC1FD, { 0xE5, 0x97, 0x8F },
	0xC1FE, { 0xE5, 0x97, 0x95 },
	0xC2A1, { 0xE5, 0x97, 0xA2 },
	0xC2A2, { 0xE5, 0x97, 0x96 },
	0xC2A3, { 0xE5, 0x97, 0x88 },
	0xC2A4, { 0xE5, 0x97, 0xB2 },
	0xC2A5, { 0xE5, 0x97, 0x8D },
	0xC2A6, { 0xE5, 0x97, 0x99 },
	0xC2A7, { 0xE5, 0x97, 0x82 },
	0xC2A8, { 0xE5, 0x9C, 0x94 },
	0xC2A9, { 0xE5, 0xA1, 0x93 },
	0xC2AA, { 0xE5, 0xA1, 0xA8 },
	0xC2AB, { 0xE5, 0xA1, 0xA4 },
	0xC2AC, { 0xE5, 0xA1, 0x8F },
	0xC2AD, { 0xE5, 0xA1, 0x8D },
	0xC2AE, { 0xE5, 0xA1, 0x89 },
	0xC2AF, { 0xE5, 0xA1, 0xAF },
	0xC2B0, { 0xE5, 0xA1, 0x95 },
	0xC2B1, { 0xE5, 0xA1, 0x8E },
	0xC2B2, { 0xE5, 0xA1, 0x9D },
	0xC2B3, { 0xE5, 0xA1, 0x99 },
	0xC2B4, { 0xE5, 0xA1, 0xA5 },
	0xC2B5, { 0xE5, 0xA1, 0x9B },
	0xC2B6, { 0xE5, 0xA0, 0xBD },
	0xC2B7, { 0xE5, 0xA1, 0xA3 },
	0xC2B8, { 0xE5, 0xA1, 0xB1 },
	0xC2B9, { 0xE5, 0xA3, 0xBC },
	0xC2BA, { 0xE5, 0xAB, 0x87 },
	0xC2BB, { 0xE5, 0xAB, 0x84 },
	0xC2BC, { 0xE5, 0xAB, 0x8B },
	0xC2BD, { 0xE5, 0xAA, 0xBA },
	0xC2BE, { 0xE5, 0xAA, 0xB8 },
	0xC2BF, { 0xE5, 0xAA, 0xB1 },
	0xC2C0, { 0xE5, 0xAA, 0xB5 },
	0xC2C1, { 0xE5, 0xAA, 0xB0 },
	0xC2C2, { 0xE5, 0xAA, 0xBF },
	0xC2C3, { 0xE5, 0xAB, 0x88 },
	0xC2C4, { 0xE5, 0xAA, 0xBB },
	0xC2C5, { 0xE5, 0xAB, 0x86 },
	0xC2C6, { 0xE5, 0xAA, 0xB7 },
	0xC2C7, { 0xE5, 0xAB, 0x80 },
	0xC2C8, { 0xE5, 0xAB, 0x8A },
	0xC2C9, { 0xE5, 0xAA, 0xB4 },
	0xC2CA, { 0xE5, 0xAA, 0xB6 },
	0xC2CB, { 0xE5, 0xAB, 0x8D },
	0xC2CC, { 0xE5, 0xAA, 0xB9 },
	0xC2CD, { 0xE5, 0xAA, 0x90 },
	0xC2CE, { 0xE5, 0xAF, 0x96 },
	0xC2CF, { 0xE5, 0xAF, 0x98 },
	0xC2D0, { 0xE5, 0xAF, 0x99 },
	0xC2D1, { 0xE5, 0xB0, 0x9F },
	0xC2D2, { 0xE5, 0xB0, 0xB3 },
	0xC2D3, { 0xE5, 0xB5, 0xB1 },
	0xC2D4, { 0xE5, 0xB5, 0xA3 },
	0xC2D5, { 0xE5, 0xB5, 0x8A },
	0xC2D6, { 0xE5, 0xB5, 0xA5 },
	0xC2D7, { 0xE5, 0xB5, 0xB2 },
	0xC2D8, { 0xE5, 0xB5, 0xAC },
	0xC2D9, { 0xE5, 0xB5, 0x9E },
	0xC2DA, { 0xE5, 0xB5, 0xA8 },
	0xC2DB, { 0xE5, 0xB5, 0xA7 },
	0xC2DC, { 0xE5, 0xB5, 0xA2 },
	0xC2DD, { 0xE5, 0xB7, 0xB0 },
	0xC2DE, { 0xE5, 0xB9, 0x8F },
	0xC2DF, { 0xE5, 0xB9, 0x8E },
	0xC2E0, { 0xE5, 0xB9, 0x8A },
	0xC2E1, { 0xE5, 0xB9, 0x8D },
	0xC2E2, { 0xE5, 0xB9, 0x8B },
	0xC2E3, { 0xE5, 0xBB, 0x85 },
	0xC2E4, { 0xE5, 0xBB, 0x8C },
	0xC2E5, { 0xE5, 0xBB, 0x86 },
	0xC2E6, { 0xE5, 0xBB, 0x8B },
	0xC2E7, { 0xE5, 0xBB, 0x87 },
	0xC2E8, { 0xE5, 0xBD, 0x80 },
	0xC2E9, { 0xE5, 0xBE, 0xAF },
	0xC2EA, { 0xE5, 0xBE, 0xAD },
	0xC2EB, { 0xE6, 0x83, 0xB7 },
	0xC2EC, { 0xE6, 0x85, 0x89 },
	0xC2ED, { 0xE6, 0x85, 0x8A },
	0xC2EE, { 0xE6, 0x84, 0xAB },
	0xC2EF, { 0xE6, 0x85, 0x85 },
	0xC2F0, { 0xE6, 0x84, 0xB6 },
	0xC2F1, { 0xE6, 0x84, 0xB2 },
	0xC2F2, { 0xE6, 0x84, 0xAE },
	0xC2F3, { 0xE6, 0x85, 0x86 },
	0xC2F4, { 0xE6, 0x84, 0xAF },
	0xC2F5, { 0xE6, 0x85, 0x8F },
	0xC2F6, { 0xE6, 0x84, 0xA9 },
	0xC2F7, { 0xE6, 0x85, 0x80 },
	0xC2F8, { 0xE6, 0x88, 0xA0 },
	0xC2F9, { 0xE9, 0x85, 0xA8 },
	0xC2FA, { 0xE6, 0x88, 0xA3 },
	0xC2FB, { 0xE6, 0x88, 0xA5 },
	0xC2FC, { 0xE6, 0x88, 0xA4 },
	0xC2FD, { 0xE6, 0x8F, 0x85 },
	0xC2FE, { 0xE6, 0x8F, 0xB1 },
	0xC3A1, { 0xE6, 0x8F, 0xAB },
	0xC3A2, { 0xE6, 0x90, 0x90 },
	0xC3A3, { 0xE6, 0x90, 0x92 },
	0xC3A4, { 0xE6, 0x90, 0x89 },
	0xC3A5, { 0xE6, 0x90, 0xA0 },
	0xC3A6, { 0xE6, 0x90, 0xA4 },
	0xC3A7, { 0xE6, 0x90, 0xB3 },
	0xC3A8, { 0xE6, 0x91, 0x83 },
	0xC3A9, { 0xE6, 0x90, 0x9F },
	0xC3AA, { 0xE6, 0x90, 0x95 },
	0xC3AB, { 0xE6, 0x90, 0x98 },
	0xC3AC, { 0xE6, 0x90, 0xB9 },
	0xC3AD, { 0xE6, 0x90, 0xB7 },
	0xC3AE, { 0xE6, 0x90, 0xA2 },
	0xC3AF, { 0xE6, 0x90, 0xA3 },
	0xC3B0, { 0xE6, 0x90, 0x8C },
	0xC3B1, { 0xE6, 0x90, 0xA6 },
	0xC3B2, { 0xE6, 0x90, 0xB0 },
	0xC3B3, { 0xE6, 0x90, 0xA8 },
	0xC3B4, { 0xE6, 0x91, 0x81 },
	0xC3B5, { 0xE6, 0x90, 0xB5 },
	0xC3B6, { 0xE6, 0x90, 0xAF },
	0xC3B7, { 0xE6, 0x90, 0x8A },
	0xC3B8, { 0xE6, 0x90, 0x9A },
	0xC3B9, { 0xE6, 0x91, 0x80 },
	0xC3BA, { 0xE6, 0x90, 0xA5 },
	0xC3BB, { 0xE6, 0x90, 0xA7 },
	0xC3BC, { 0xE6, 0x90, 0x8B },
	0xC3BD, { 0xE6, 0x8F, 0xA7 },
	0xC3BE, { 0xE6, 0x90, 0x9B },
	0xC3BF, { 0xE6, 0x90, 0xAE },
	0xC3C0, { 0xE6, 0x90, 0xA1 },
	0xC3C1, { 0xE6, 0x90, 0x8E },
	0xC3C2, { 0xE6, 0x95, 0xAF },
	0xC3C3, { 0xE6, 0x96, 0x92 },
	0xC3C4, { 0xE6, 0x97, 0x93 },
	0xC3C5, { 0xE6, 0x9A, 0x86 },
	0xC3C6, { 0xE6, 0x9A, 0x8C },
	0xC3C7, { 0xE6, 0x9A, 0x95 },
	0xC3C8, { 0xE6, 0x9A, 0x90 },
	0xC3C9, { 0xE6, 0x9A, 0x8B },
	0xC3CA, { 0xE6, 0x9A, 0x8A },
	0xC3CB, { 0xE6, 0x9A, 0x99 },
	0xC3CC, { 0xE6, 0x9A, 0x94 },
	0xC3CD, { 0xE6, 0x99, 0xB8 },
	0xC3CE, { 0xE6, 0x9C, 0xA0 },
	0xC3CF, { 0xE6, 0xA5, 0xA6 },
	0xC3D0, { 0xE6, 0xA5, 0x9F },
	0xC3D1, { 0xE6, 0xA4, 0xB8 },
	0xC3D2, { 0xE6, 0xA5, 0x8E },
	0xC3D3, { 0xE6, 0xA5, 0xA2 },
	0xC3D4, { 0xE6, 0xA5, 0xB1 },
	0xC3D5, { 0xE6, 0xA4, 0xBF },
	0xC3D6, { 0xE6, 0xA5, 0x85 },
	0xC3D7, { 0xE6, 0xA5, 0xAA },
	0xC3D8, { 0xE6, 0xA4, 0xB9 },
	0xC3D9, { 0xE6, 0xA5, 0x82 },
	0xC3DA, { 0xE6, 0xA5, 0x97 },
	0xC3DB, { 0xE6, 0xA5, 0x99 },
	0xC3DC, { 0xE6, 0xA5, 0xBA },
	0xC3DD, { 0xE6, 0xA5, 0x88 },
	0xC3DE, { 0xE6, 0xA5, 0x89 },
	0xC3DF, { 0xE6, 0xA4, 0xB5 },
	0xC3E0, { 0xE6, 0xA5, 0xAC },
	0xC3E1, { 0xE6, 0xA4, 0xB3 },
	0xC3E2, { 0xE6, 0xA4, 0xBD },
	0xC3E3, { 0xE6, 0xA5, 0xA5 },
	0xC3E4, { 0xE6, 0xA3, 0xB0 },
	0xC3E5, { 0xE6, 0xA5, 0xB8 },
	0xC3E6, { 0xE6, 0xA4, 0xB4 },
	0xC3E7, { 0xE6, 0xA5, 0xA9 },
	0xC3E8, { 0xE6, 0xA5, 0x80 },
	0xC3E9, { 0xE6, 0xA5, 0xAF },
	0xC3EA, { 0xE6, 0xA5, 0x84 },
	0xC3EB, { 0xE6, 0xA5, 0xB6 },
	0xC3EC, { 0xE6, 0xA5, 0x98 },
	0xC3ED, { 0xE6, 0xA5, 0x81 },
	0xC3EE, { 0xE6, 0xA5, 0xB4 },
	0xC3EF, { 0xE6, 0xA5, 0x8C },
	0xC3F0, { 0xE6, 0xA4, 0xBB },
	0xC3F1, { 0xE6, 0xA5, 0x8B },
	0xC3F2, { 0xE6, 0xA4, 0xB7 },
	0xC3F3, { 0xE6, 0xA5, 0x9C },
	0xC3F4, { 0xE6, 0xA5, 0x8F },
	0xC3F5, { 0xE6, 0xA5, 0x91 },
	0xC3F6, { 0xE6, 0xA4, 0xB2 },
	0xC3F7, { 0xE6, 0xA5, 0x92 },
	0xC3F8, { 0xE6, 0xA4, 0xAF },
	0xC3F9, { 0xE6, 0xA5, 0xBB },
	0xC3FA, { 0xE6, 0xA4, 0xBC },
	0xC3FB, { 0xE6, 0xAD, 0x86 },
	0xC3FC, { 0xE6, 0xAD, 0x85 },
	0xC3FD, { 0xE6, 0xAD, 0x83 },
	0xC3FE, { 0xE6, 0xAD, 0x82 },
	0xC4A1, { 0xE6, 0xAD, 0x88 },
	0xC4A2, { 0xE6, 0xAD, 0x81 },
	0xC4A3, { 0xE6, 0xAE, 0x9B },
	0xC4A4, { 0xE6, 0xAF, 0xBB },
	0xC4A5, { 0xE6, 0xAF, 0xBC },
	0xC4A6, { 0xE6, 0xAF, 0xB9 },
	0xC4A7, { 0xE6, 0xAF, 0xB7 },
	0xC4A8, { 0xE6, 0xAF, 0xB8 },
	0xC4A9, { 0xE6, 0xBA, 0x9B },
	0xC4AA, { 0xE6, 0xBB, 0x96 },
	0xC4AB, { 0xE6, 0xBB, 0x88 },
	0xC4AC, { 0xE6, 0xBA, 0x8F },
	0xC4AD, { 0xE6, 0xBB, 0x80 },
	0xC4AE, { 0xE6, 0xBA, 0x9F },
	0xC4AF, { 0xE6, 0xBA, 0x93 },
	0xC4B0, { 0xE6, 0xBA, 0x94 },
	0xC4B1, { 0xE6, 0xBA, 0xA0 },
	0xC4B2, { 0xE6, 0xBA, 0xB1 },
	0xC4B3, { 0xE6, 0xBA, 0xB9 },
	0xC4B4, { 0xE6, 0xBB, 0x86 },
	0xC4B5, { 0xE6, 0xBB, 0x92 },
	0xC4B6, { 0xE6, 0xBA, 0xBD },
	0xC4B7, { 0xE6, 0xBB, 0x81 },
	0xC4B8, { 0xE6, 0xBA, 0x9E },
	0xC4B9, { 0xE6, 0xBB, 0x89 },
	0xC4BA, { 0xE6, 0xBA, 0xB7 },
	0xC4BB, { 0xE6, 0xBA, 0xB0 },
	0xC4BC, { 0xE6, 0xBB, 0x8D },
	0xC4BD, { 0xE6, 0xBA, 0xA6 },
	0xC4BE, { 0xE6, 0xBB, 0x8F },
	0xC4BF, { 0xE6, 0xBA, 0xB2 },
	0xC4C0, { 0xE6, 0xBA, 0xBE },
	0xC4C1, { 0xE6, 0xBB, 0x83 },
	0xC4C2, { 0xE6, 0xBB, 0x9C },
	0xC4C3, { 0xE6, 0xBB, 0x98 },
	0xC4C4, { 0xE6, 0xBA, 0x99 },
	0xC4C5, { 0xE6, 0xBA, 0x92 },
	0xC4C6, { 0xE6, 0xBA, 0x8E },
	0xC4C7, { 0xE6, 0xBA, 0x8D },
	0xC4C8, { 0xE6, 0xBA, 0xA4 },
	0xC4C9, { 0xE6, 0xBA, 0xA1 },
	0xC4CA, { 0xE6, 0xBA, 0xBF },
	0xC4CB, { 0xE6, 0xBA, 0xB3 },
	0xC4CC, { 0xE6, 0xBB, 0x90 },
	0xC4CD, { 0xE6, 0xBB, 0x8A },
	0xC4CE, { 0xE6, 0xBA, 0x97 },
	0xC4CF, { 0xE6, 0xBA, 0xAE },
	0xC4D0, { 0xE6, 0xBA, 0xA3 },
	0xC4D1, { 0xE7, 0x85, 0x87 },
	0xC4D2, { 0xE7, 0x85, 0x94 },
	0xC4D3, { 0xE7, 0x85, 0x92 },
	0xC4D4, { 0xE7, 0x85, 0xA3 },
	0xC4D5, { 0xE7, 0x85, 0xA0 },
	0xC4D6, { 0xE7, 0x85, 0x81 },
	0xC4D7, { 0xE7, 0x85, 0x9D },
	0xC4D8, { 0xE7, 0x85, 0xA2 },
	0xC4D9, { 0xE7, 0x85, 0xB2 },
	0xC4DA, { 0xE7, 0x85, 0xB8 },
	0xC4DB, { 0xE7, 0x85, 0xAA },
	0xC4DC, { 0xE7, 0x85, 0xA1 },
	0xC4DD, { 0xE7, 0x85, 0x82 },
	0xC4DE, { 0xE7, 0x85, 0x98 },
	0xC4DF, { 0xE7, 0x85, 0x83 },
	0xC4E0, { 0xE7, 0x85, 0x8B },
	0xC4E1, { 0xE7, 0x85, 0xB0 },
	0xC4E2, { 0xE7, 0x85, 0x9F },
	0xC4E3, { 0xE7, 0x85, 0x90 },
	0xC4E4, { 0xE7, 0x85, 0x93 },
	0xC4E5, { 0xE7, 0x85, 0x84 },
	0xC4E6, { 0xE7, 0x85, 0x8D },
	0xC4E7, { 0xE7, 0x85, 0x9A },
	0xC4E8, { 0xE7, 0x89, 0x8F },
	0xC4E9, { 0xE7, 0x8A, 0x8D },
	0xC4EA, { 0xE7, 0x8A, 0x8C },
	0xC4EB, { 0xE7, 0x8A, 0x91 },
	0xC4EC, { 0xE7, 0x8A, 0x90 },
	0xC4ED, { 0xE7, 0x8A, 0x8E },
	0xC4EE, { 0xE7, 0x8C, 0xBC },
	0xC4EF, { 0xE7, 0x8D, 0x82 },
	0xC4F0, { 0xE7, 0x8C, 0xBB },
	0xC4F1, { 0xE7, 0x8C, 0xBA },
	0xC4F2, { 0xE7, 0x8D, 0x80 },
	0xC4F3, { 0xE7, 0x8D, 0x8A },
	0xC4F4, { 0xE7, 0x8D, 0x89 },
	0xC4F5, { 0xE7, 0x91, 0x84 },
	0xC4F6, { 0xE7, 0x91, 0x8A },
	0xC4F7, { 0xE7, 0x91, 0x8B },
	0xC4F8, { 0xE7, 0x91, 0x92 },
	0xC4F9, { 0xE7, 0x91, 0x91 },
	0xC4FA, { 0xE7, 0x91, 0x97 },
	0xC4FB, { 0xE7, 0x91, 0x80 },
	0xC4FC, { 0xE7, 0x91, 0x8F },
	0xC4FD, { 0xE7, 0x91, 0x90 },
	0xC4FE, { 0xE7, 0x91, 0x8E },
	0xC5A1, { 0xE7, 0x91, 0x82 },
	0xC5A2, { 0xE7, 0x91, 0x86 },
	0xC5A3, { 0xE7, 0x91, 0x8D },
	0xC5A4, { 0xE7, 0x91, 0x94 },
	0xC5A5, { 0xE7, 0x93, 0xA1 },
	0xC5A6, { 0xE7, 0x93, 0xBF },
	0xC5A7, { 0xE7, 0x93, 0xBE },
	0xC5A8, { 0xE7, 0x93, 0xBD },
	0xC5A9, { 0xE7, 0x94, 0x9D },
	0xC5AA, { 0xE7, 0x95, 0xB9 },
	0xC5AB, { 0xE7, 0x95, 0xB7 },
	0xC5AC, { 0xE6, 0xA6, 0x83 },
	0xC5AD, { 0xE7, 0x97, 0xAF },
	0xC5AE, { 0xE7, 0x98, 0x8F },
	0xC5AF, { 0xE7, 0x98, 0x83 },
	0xC5B0, { 0xE7, 0x97, 0xB7 },
	0xC5B1, { 0xE7, 0x97, 0xBE },
	0xC5B2, { 0xE7, 0x97, 0xBC },
	0xC5B3, { 0xE7, 0x97, 0xB9 },
	0xC5B4, { 0xE7, 0x97, 0xB8 },
	0xC5B5, { 0xE7, 0x98, 0x90 },
	0xC5B6, { 0xE7, 0x97, 0xBB },
	0xC5B7, { 0xE7, 0x97, 0xB6 },
	0xC5B8, { 0xE7, 0x97, 0xAD },
	0xC5B9, { 0xE7, 0x97, 0xB5 },
	0xC5BA, { 0xE7, 0x97, 0xBD },
	0xC5BB, { 0xE7, 0x9A, 0x99 },
	0xC5BC, { 0xE7, 0x9A, 0xB5 },
	0xC5BD, { 0xE7, 0x9B, 0x9D },
	0xC5BE, { 0xE7, 0x9D, 0x95 },
	0xC5BF, { 0xE7, 0x9D, 0x9F },
	0xC5C0, { 0xE7, 0x9D, 0xA0 },
	0xC5C1, { 0xE7, 0x9D, 0x92 },
	0xC5C2, { 0xE7, 0x9D, 0x96 },
	0xC5C3, { 0xE7, 0x9D, 0x9A },
	0xC5C4, { 0xE7, 0x9D, 0xA9 },
	0xC5C5, { 0xE7, 0x9D, 0xA7 },
	0xC5C6, { 0xE7, 0x9D, 0x94 },
	0xC5C7, { 0xE7, 0x9D, 0x99 },
	0xC5C8, { 0xE7, 0x9D, 0xAD },
	0xC5C9, { 0xE7, 0x9F, 0xA0 },
	0xC5CA, { 0xE7, 0xA2, 0x87 },
	0xC5CB, { 0xE7, 0xA2, 0x9A },
	0xC5CC, { 0xE7, 0xA2, 0x94 },
	0xC5CD, { 0xE7, 0xA2, 0x8F },
	0xC5CE, { 0xE7, 0xA2, 0x84 },
	0xC5CF, { 0xE7, 0xA2, 0x95 },
	0xC5D0, { 0xE7, 0xA2, 0x85 },
	0xC5D1, { 0xE7, 0xA2, 0x86 },
	0xC5D2, { 0xE7, 0xA2, 0xA1 },
	0xC5D3, { 0xE7, 0xA2, 0x83 },
	0xC5D4, { 0xE7, 0xA1, 0xB9 },
	0xC5D5, { 0xE7, 0xA2, 0x99 },
	0xC5D6, { 0xE7, 0xA2, 0x80 },
	0xC5D7, { 0xE7, 0xA2, 0x96 },
	0xC5D8, { 0xE7, 0xA1, 0xBB },
	0xC5D9, { 0xE7, 0xA5, 0xBC },
	0xC5DA, { 0xE7, 0xA6, 0x82 },
	0xC5DB, { 0xE7, 0xA5, 0xBD },
	0xC5DC, { 0xE7, 0xA5, 0xB9 },
	0xC5DD, { 0xE7, 0xA8, 0x91 },
	0xC5DE, { 0xE7, 0xA8, 0x98 },
	0xC5DF, { 0xE7, 0xA8, 0x99 },
	0xC5E0, { 0xE7, 0xA8, 0x92 },
	0xC5E1, { 0xE7, 0xA8, 0x97 },
	0xC5E2, { 0xE7, 0xA8, 0x95 },
	0xC5E3, { 0xE7, 0xA8, 0xA2 },
	0xC5E4, { 0xE7, 0xA8, 0x93 },
	0xC5E5, { 0xE7, 0xA8, 0x9B },
	0xC5E6, { 0xE7, 0xA8, 0x90 },
	0xC5E7, { 0xE7, 0xAA, 0xA3 },
	0xC5E8, { 0xE7, 0xAA, 0xA2 },
	0xC5E9, { 0xE7, 0xAA, 0x9E },
	0xC5EA, { 0xE7, 0xAB, 0xAB },
	0xC5EB, { 0xE7, 0xAD, 0xA6 },
	0xC5EC, { 0xE7, 0xAD, 0xA4 },
	0xC5ED, { 0xE7, 0xAD, 0xAD },
	0xC5EE, { 0xE7, 0xAD, 0xB4 },
	0xC5EF, { 0xE7, 0xAD, 0xA9 },
	0xC5F0, { 0xE7, 0xAD, 0xB2 },
	0xC5F1, { 0xE7, 0xAD, 0xA5 },
	0xC5F2, { 0xE7, 0xAD, 0xB3 },
	0xC5F3, { 0xE7, 0xAD, 0xB1 },
	0xC5F4, { 0xE7, 0xAD, 0xB0 },
	0xC5F5, { 0xE7, 0xAD, 0xA1 },
	0xC5F6, { 0xE7, 0xAD, 0xB8 },
	0xC5F7, { 0xE7, 0xAD, 0xB6 },
	0xC5F8, { 0xE7, 0xAD, 0xA3 },
	0xC5F9, { 0xE7, 0xB2, 0xB2 },
	0xC5FA, { 0xE7, 0xB2, 0xB4 },
	0xC5FB, { 0xE7, 0xB2, 0xAF },
	0xC5FC, { 0xE7, 0xB6, 0x88 },
	0xC5FD, { 0xE7, 0xB6, 0x86 },
	0xC5FE, { 0xE7, 0xB6, 0x80 },
	0xC6A1, { 0xE7, 0xB6, 0x8D },
	0xC6A2, { 0xE7, 0xB5, 0xBF },
	0xC6A3, { 0xE7, 0xB6, 0x85 },
	0xC6A4, { 0xE7, 0xB5, 0xBA },
	0xC6A5, { 0xE7, 0xB6, 0x8E },
	0xC6A6, { 0xE7, 0xB5, 0xBB },
	0xC6A7, { 0xE7, 0xB6, 0x83 },
	0xC6A8, { 0xE7, 0xB5, 0xBC },
	0xC6A9, { 0xE7, 0xB6, 0x8C },
	0xC6AA, { 0xE7, 0xB6, 0x94 },
	0xC6AB, { 0xE7, 0xB6, 0x84 },
	0xC6AC, { 0xE7, 0xB5, 0xBD },
	0xC6AD, { 0xE7, 0xB6, 0x92 },
	0xC6AE, { 0xE7, 0xBD, 0xAD },
	0xC6AF, { 0xE7, 0xBD, 0xAB },
	0xC6B0, { 0xE7, 0xBD, 0xA7 },
	0xC6B1, { 0xE7, 0xBD, 0xA8 },
	0xC6B2, { 0xE7, 0xBD, 0xAC },
	0xC6B3, { 0xE7, 0xBE, 0xA6 },
	0xC6B4, { 0xE7, 0xBE, 0xA5 },
	0xC6B5, { 0xE7, 0xBE, 0xA7 },
	0xC6B6, { 0xE7, 0xBF, 0x9B },
	0xC6B7, { 0xE7, 0xBF, 0x9C },
	0xC6B8, { 0xE8, 0x80, 0xA1 },
	0xC6B9, { 0xE8, 0x85, 0xA4 },
	0xC6BA, { 0xE8, 0x85, 0xA0 },
	0xC6BB, { 0xE8, 0x85, 0xB7 },
	0xC6BC, { 0xE8, 0x85, 0x9C },
	0xC6BD, { 0xE8, 0x85, 0xA9 },
	0xC6BE, { 0xE8, 0x85, 0x9B },
	0xC6BF, { 0xE8, 0x85, 0xA2 },
	0xC6C0, { 0xE8, 0x85, 0xB2 },
	0xC6C1, { 0xE6, 0x9C, 0xA1 },
	0xC6C2, { 0xE8, 0x85, 0x9E },
	0xC6C3, { 0xE8, 0x85, 0xB6 },
	0xC6C4, { 0xE8, 0x85, 0xA7 },
	0xC6C5, { 0xE8, 0x85, 0xAF },
	0xC6C6, { 0xE8, 0x85, 0x84 },
	0xC6C7, { 0xE8, 0x85, 0xA1 },
	0xC6C8, { 0xE8, 0x88, 0x9D },
	0xC6C9, { 0xE8, 0x89, 0x89 },
	0xC6CA, { 0xE8, 0x89, 0x84 },
	0xC6CB, { 0xE8, 0x89, 0x80 },
	0xC6CC, { 0xE8, 0x89, 0x82 },
	0xC6CD, { 0xE8, 0x89, 0x85 },
	0xC6CE, { 0xE8, 0x93, 0xB1 },
	0xC6CF, { 0xE8, 0x90, 0xBF },
	0xC6D0, { 0xE8, 0x91, 0x96 },
	0xC6D1, { 0xE8, 0x91, 0xB6 },
	0xC6D2, { 0xE8, 0x91, 0xB9 },
	0xC6D3, { 0xE8, 0x92, 0x8F },
	0xC6D4, { 0xE8, 0x92, 0x8D },
	0xC6D5, { 0xE8, 0x91, 0xA5 },
	0xC6D6, { 0xE8, 0x91, 0x91 },
	0xC6D7, { 0xE8, 0x91, 0x80 },
	0xC6D8, { 0xE8, 0x92, 0x86 },
	0xC6D9, { 0xE8, 0x91, 0xA7 },
	0xC6DA, { 0xE8, 0x90, 0xB0 },
	0xC6DB, { 0xE8, 0x91, 0x8D },
	0xC6DC, { 0xE8, 0x91, 0xBD },
	0xC6DD, { 0xE8, 0x91, 0x9A },
	0xC6DE, { 0xE8, 0x91, 0x99 },
	0xC6DF, { 0xE8, 0x91, 0xB4 },
	0xC6E0, { 0xE8, 0x91, 0xB3 },
	0xC6E1, { 0xE8, 0x91, 0x9D },
	0xC6E2, { 0xE8, 0x94, 0x87 },
	0xC6E3, { 0xE8, 0x91, 0x9E },
	0xC6E4, { 0xE8, 0x90, 0xB7 },
	0xC6E5, { 0xE8, 0x90, 0xBA },
	0xC6E6, { 0xE8, 0x90, 0xB4 },
	0xC6E7, { 0xE8, 0x91, 0xBA },
	0xC6E8, { 0xE8, 0x91, 0x83 },
	0xC6E9, { 0xE8, 0x91, 0xB8 },
	0xC6EA, { 0xE8, 0x90, 0xB2 },
	0xC6EB, { 0xE8, 0x91, 0x85 },
	0xC6EC, { 0xE8, 0x90, 0xA9 },
	0xC6ED, { 0xE8, 0x8F, 0x99 },
	0xC6EE, { 0xE8, 0x91, 0x8B },
	0xC6EF, { 0xE8, 0x90, 0xAF },
	0xC6F0, { 0xE8, 0x91, 0x82 },
	0xC6F1, { 0xE8, 0x90, 0xAD },
	0xC6F2, { 0xE8, 0x91, 0x9F },
	0xC6F3, { 0xE8, 0x91, 0xB0 },
	0xC6F4, { 0xE8, 0x90, 0xB9 },
	0xC6F5, { 0xE8, 0x91, 0x8E },
	0xC6F6, { 0xE8, 0x91, 0x8C },
	0xC6F7, { 0xE8, 0x91, 0x92 },
	0xC6F8, { 0xE8, 0x91, 0xAF },
	0xC6F9, { 0xE8, 0x93, 0x85 },
	0xC6FA, { 0xE8, 0x92, 0x8E },
	0xC6FB, { 0xE8, 0x90, 0xBB },
	0xC6FC, { 0xE8, 0x91, 0x87 },
	0xC6FD, { 0xE8, 0x90, 0xB6 },
	0xC6FE, { 0xE8, 0x90, 0xB3 },
	0xC7A1, { 0xE8, 0x91, 0xA8 },
	0xC7A2, { 0xE8, 0x91, 0xBE },
	0xC7A3, { 0xE8, 0x91, 0x84 },
	0xC7A4, { 0xE8, 0x90, 0xAB },
	0xC7A5, { 0xE8, 0x91, 0xA0 },
	0xC7A6, { 0xE8, 0x91, 0x94 },
	0xC7A7, { 0xE8, 0x91, 0xAE },
	0xC7A8, { 0xE8, 0x91, 0x90 },
	0xC7A9, { 0xE8, 0x9C, 0x8B },
	0xC7AA, { 0xE8, 0x9C, 0x84 },
	0xC7AB, { 0xE8, 0x9B, 0xB7 },
	0xC7AC, { 0xE8, 0x9C, 0x8C },
	0xC7AD, { 0xE8, 0x9B, 0xBA },
	0xC7AE, { 0xE8, 0x9B, 0x96 },
	0xC7AF, { 0xE8, 0x9B, 0xB5 },
	0xC7B0, { 0xE8, 0x9D, 0x8D },
	0xC7B1, { 0xE8, 0x9B, 0xB8 },
	0xC7B2, { 0xE8, 0x9C, 0x8E },
	0xC7B3, { 0xE8, 0x9C, 0x89 },
	0xC7B4, { 0xE8, 0x9C, 0x81 },
	0xC7B5, { 0xE8, 0x9B, 0xB6 },
	0xC7B6, { 0xE8, 0x9C, 0x8D },
	0xC7B7, { 0xE8, 0x9C, 0x85 },
	0xC7B8, { 0xE8, 0xA3, 0x96 },
	0xC7B9, { 0xE8, 0xA3, 0x8B },
	0xC7BA, { 0xE8, 0xA3, 0x8D },
	0xC7BB, { 0xE8, 0xA3, 0x8E },
	0xC7BC, { 0xE8, 0xA3, 0x9E },
	0xC7BD, { 0xE8, 0xA3, 0x9B },
	0xC7BE, { 0xE8, 0xA3, 0x9A },
	0xC7BF, { 0xE8, 0xA3, 0x8C },
	0xC7C0, { 0xE8, 0xA3, 0x90 },
	0xC7C1, { 0xE8, 0xA6, 0x85 },
	0xC7C2, { 0xE8, 0xA6, 0x9B },
	0xC7C3, { 0xE8, 0xA7, 0x9F },
	0xC7C4, { 0xE8, 0xA7, 0xA5 },
	0xC7C5, { 0xE8, 0xA7, 0xA4 },
	0xC7C6, { 0xE8, 0xA7, 0xA1 },
	0xC7C7, { 0xE8, 0xA7, 0xA0 },
	0xC7C8, { 0xE8, 0xA7, 0xA2 },
	0xC7C9, { 0xE8, 0xA7, 0x9C },
	0xC7CA, { 0xE8, 0xA7, 0xA6 },
	0xC7CB, { 0xE8, 0xA9, 0xB6 },
	0xC7CC, { 0xE8, 0xAA, 0x86 },
	0xC7CD, { 0xE8, 0xA9, 0xBF },
	0xC7CE, { 0xE8, 0xA9, 0xA1 },
	0xC7CF, { 0xE8, 0xA8, 0xBF },
	0xC7D0, { 0xE8, 0xA9, 0xB7 },
	0xC7D1, { 0xE8, 0xAA, 0x82 },
	0xC7D2, { 0xE8, 0xAA, 0x84 },
	0xC7D3, { 0xE8, 0xA9, 0xB5 },
	0xC7D4, { 0xE8, 0xAA, 0x83 },
	0xC7D5, { 0xE8, 0xAA, 0x81 },
	0xC7D6, { 0xE8, 0xA9, 0xB4 },
	0xC7D7, { 0xE8, 0xA9, 0xBA },
	0xC7D8, { 0xE8, 0xB0, 0xBC },
	0xC7D9, { 0xE8, 0xB1, 0x8B },
	0xC7DA, { 0xE8, 0xB1, 0x8A },
	0xC7DB, { 0xE8, 0xB1, 0xA5 },
	0xC7DC, { 0xE8, 0xB1, 0xA4 },
	0xC7DD, { 0xE8, 0xB1, 0xA6 },
	0xC7DE, { 0xE8, 0xB2, 0x86 },
	0xC7DF, { 0xE8, 0xB2, 0x84 },
	0xC7E0, { 0xE8, 0xB2, 0x85 },
	0xC7E1, { 0xE8, 0xB3, 0x8C },
	0xC7E2, { 0xE8, 0xB5, 0xA8 },
	0xC7E3, { 0xE8, 0xB5, 0xA9 },
	0xC7E4, { 0xE8, 0xB6, 0x91 },
	0xC7E5, { 0xE8, 0xB6, 0x8C },
	0xC7E6, { 0xE8, 0xB6, 0x8E },
	0xC7E7, { 0xE8, 0xB6, 0x8F },
	0xC7E8, { 0xE8, 0xB6, 0x8D },
	0xC7E9, { 0xE8, 0xB6, 0x93 },
	0xC7EA, { 0xE8, 0xB6, 0x94 },
	0xC7EB, { 0xE8, 0xB6, 0x90 },
	0xC7EC, { 0xE8, 0xB6, 0x92 },
	0xC7ED, { 0xE8, 0xB7, 0xB0 },
	0xC7EE, { 0xE8, 0xB7, 0xA0 },
	0xC7EF, { 0xE8, 0xB7, 0xAC },
	0xC7F0, { 0xE8, 0xB7, 0xB1 },
	0xC7F1, { 0xE8, 0xB7, 0xAE },
	0xC7F2, { 0xE8, 0xB7, 0x90 },
	0xC7F3, { 0xE8, 0xB7, 0xA9 },
	0xC7F4, { 0xE8, 0xB7, 0xA3 },
	0xC7F5, { 0xE8, 0xB7, 0xA2 },
	0xC7F6, { 0xE8, 0xB7, 0xA7 },
	0xC7F7, { 0xE8, 0xB7, 0xB2 },
	0xC7F8, { 0xE8, 0xB7, 0xAB },
	0xC7F9, { 0xE8, 0xB7, 0xB4 },
	0xC7FA, { 0xE8, 0xBC, 0x86 },
	0xC7FB, { 0xE8, 0xBB, 0xBF },
	0xC7FC, { 0xE8, 0xBC, 0x81 },
	0xC7FD, { 0xE8, 0xBC, 0x80 },
	0xC7FE, { 0xE8, 0xBC, 0x85 },
	0xC8A1, { 0xE8, 0xBC, 0x87 },
	0xC8A2, { 0xE8, 0xBC, 0x88 },
	0xC8A3, { 0xE8, 0xBC, 0x82 },
	0xC8A4, { 0xE8, 0xBC, 0x8B },
	0xC8A5, { 0xE9, 0x81, 0x92 },
	0xC8A6, { 0xE9, 0x80, 0xBF },
	0xC8A7, { 0xE9, 0x81, 0x84 },
	0xC8A8, { 0xE9, 0x81, 0x89 },
	0xC8A9, { 0xE9, 0x80, 0xBD },
	0xC8AA, { 0xE9, 0x84, 0x90 },
	0xC8AB, { 0xE9, 0x84, 0x8D },
	0xC8AC, { 0xE9, 0x84, 0x8F },
	0xC8AD, { 0xE9, 0x84, 0x91 },
	0xC8AE, { 0xE9, 0x84, 0x96 },
	0xC8AF, { 0xE9, 0x84, 0x94 },
	0xC8B0, { 0xE9, 0x84, 0x8B },
	0xC8B1, { 0xE9, 0x84, 0x8E },
	0xC8B2, { 0xE9, 0x85, 0xAE },
	0xC8B3, { 0xE9, 0x85, 0xAF },
	0xC8B4, { 0xE9, 0x89, 0x88 },
	0xC8B5, { 0xE9, 0x89, 0x92 },
	0xC8B6, { 0xE9, 0x88, 0xB0 },
	0xC8B7, { 0xE9, 0x88, 0xBA },
	0xC8B8, { 0xE9, 0x89, 0xA6 },
	0xC8B9, { 0xE9, 0x88, 0xB3 },
	0xC8BA, { 0xE9, 0x89, 0xA5 },
	0xC8BB, { 0xE9, 0x89, 0x9E },
	0xC8BC, { 0xE9, 0x8A, 0x83 },
	0xC8BD, { 0xE9, 0x88, 0xAE },
	0xC8BE, { 0xE9, 0x89, 0x8A },
	0xC8BF, { 0xE9, 0x89, 0x86 },
	0xC8C0, { 0xE9, 0x89, 0xAD },
	0xC8C1, { 0xE9, 0x89, 0xAC },
	0xC8C2, { 0xE9, 0x89, 0x8F },
	0xC8C3, { 0xE9, 0x89, 0xA0 },
	0xC8C4, { 0xE9, 0x89, 0xA7 },
	0xC8C5, { 0xE9, 0x89, 0xAF },
	0xC8C6, { 0xE9, 0x88, 0xB6 },
	0xC8C7, { 0xE9, 0x89, 0xA1 },
	0xC8C8, { 0xE9, 0x89, 0xB0 },
	0xC8C9, { 0xE9, 0x88, 0xB1 },
	0xC8CA, { 0xE9, 0x89, 0x94 },
	0xC8CB, { 0xE9, 0x89, 0xA3 },
	0xC8CC, { 0xE9, 0x89, 0x90 },
	0xC8CD, { 0xE9, 0x89, 0xB2 },
	0xC8CE, { 0xE9, 0x89, 0x8E },
	0xC8CF, { 0xE9, 0x89, 0x93 },
	0xC8D0, { 0xE9, 0x89, 0x8C },
	0xC8D1, { 0xE9, 0x89, 0x96 },
	0xC8D2, { 0xE9, 0x88, 0xB2 },
	0xC8D3, { 0xE9, 0x96, 0x9F },
	0xC8D4, { 0xE9, 0x96, 0x9C },
	0xC8D5, { 0xE9, 0x96, 0x9E },
	0xC8D6, { 0xE9, 0x96, 0x9B },
	0xC8D7, { 0xE9, 0x9A, 0x92 },
	0xC8D8, { 0xE9, 0x9A, 0x93 },
	0xC8D9, { 0xE9, 0x9A, 0x91 },
	0xC8DA, { 0xE9, 0x9A, 0x97 },
	0xC8DB, { 0xE9, 0x9B, 0x8E },
	0xC8DC, { 0xE9, 0x9B, 0xBA },
	0xC8DD, { 0xE9, 0x9B, 0xBD },
	0xC8DE, { 0xE9, 0x9B, 0xB8 },
	0xC8DF, { 0xE9, 0x9B, 0xB5 },
	0xC8E0, { 0xE9, 0x9D, 0xB3 },
	0xC8E1, { 0xE9, 0x9D, 0xB7 },
	0xC8E2, { 0xE9, 0x9D, 0xB8 },
	0xC8E3, { 0xE9, 0x9D, 0xB2 },
	0xC8E4, { 0xE9, 0xA0, 0x8F },
	0xC8E5, { 0xE9, 0xA0, 0x8D },
	0xC8E6, { 0xE9, 0xA0, 0x8E },
	0xC8E7, { 0xE9, 0xA2, 0xAC },
	0xC8E8, { 0xE9, 0xA3, 0xB6 },
	0xC8E9, { 0xE9, 0xA3, 0xB9 },
	0xC8EA, { 0xE9, 0xA6, 0xAF },
	0xC8EB, { 0xE9, 0xA6, 0xB2 },
	0xC8EC, { 0xE9, 0xA6, 0xB0 },
	0xC8ED, { 0xE9, 0xA6, 0xB5 },
	0xC8EE, { 0xE9, 0xAA, 0xAD },
	0xC8EF, { 0xE9, 0xAA, 0xAB },
	0xC8F0, { 0xE9, 0xAD, 0x9B },
	0xC8F1, { 0xE9, 0xB3, 0xAA },
	0xC8F2, { 0xE9, 0xB3, 0xAD },
	0xC8F3, { 0xE9, 0xB3, 0xA7 },
	0xC8F4, { 0xE9, 0xBA, 0x80 },
	0xC8F5, { 0xE9, 0xBB, 0xBD },
	0xC8F6, { 0xE5, 0x83, 0xA6 },
	0xC8F7, { 0xE5, 0x83, 0x94 },
	0xC8F8, { 0xE5, 0x83, 0x97 },
	0xC8F9, { 0xE5, 0x83, 0xA8 },
	0xC8FA, { 0xE5, 0x83, 0xB3 },
	0xC8FB, { 0xE5, 0x83, 0x9B },
	0xC8FC, { 0xE5, 0x83, 0xAA },
	0xC8FD, { 0xE5, 0x83, 0x9D },
	0xC8FE, { 0xE5, 0x83, 0xA4 },
	0xC9A1, { 0xE5, 0x83, 0x93 },
	0xC9A2, { 0xE5, 0x83, 0xAC },
	0xC9A3, { 0xE5, 0x83, 0xB0 },
	0xC9A4, { 0xE5, 0x83, 0xAF },
	0xC9A5, { 0xE5, 0x83, 0xA3 },
	0xC9A6, { 0xE5, 0x83, 0xA0 },
	0xC9A7, { 0xE5, 0x87, 0x98 },
	0xC9A8, { 0xE5, 0x8A, 0x80 },
	0xC9A9, { 0xE5, 0x8A, 0x81 },
	0xC9AA, { 0xE5, 0x8B, 0xA9 },
	0xC9AB, { 0xE5, 0x8B, 0xAB },
	0xC9AC, { 0xE5, 0x8C, 0xB0 },
	0xC9AD, { 0xE5, 0x8E, 0xAC },
	0xC9AE, { 0xE5, 0x98, 0xA7 },
	0xC9AF, { 0xE5, 0x98, 0x95 },
	0xC9B0, { 0xE5, 0x98, 0x8C },
	0xC9B1, { 0xE5, 0x98, 0x92 },
	0xC9B2, { 0xE5, 0x97, 0xBC },
	0xC9B3, { 0xE5, 0x98, 0x8F },
	0xC9B4, { 0xE5, 0x98, 0x9C },
	0xC9B5, { 0xE5, 0x98, 0x81 },
	0xC9B6, { 0xE5, 0x98, 0x93 },
	0xC9B7, { 0xE5, 0x98, 0x82 },
	0xC9B8, { 0xE5, 0x97, 0xBA },
	0xC9B9, { 0xE5, 0x98, 0x9D },
	0xC9BA, { 0xE5, 0x98, 0x84 },
	0xC9BB, { 0xE5, 0x97, 0xBF },
	0xC9BC, { 0xE5, 0x97, 0xB9 },
	0xC9BD, { 0xE5, 0xA2, 0x89 },
	0xC9BE, { 0xE5, 0xA1, 0xBC },
	0xC9BF, { 0xE5, 0xA2, 0x90 },
	0xC9C0, { 0xE5, 0xA2, 0x98 },
	0xC9C1, { 0xE5, 0xA2, 0x86 },
	0xC9C2, { 0xE5, 0xA2, 0x81 },
	0xC9C3, { 0xE5, 0xA1, 0xBF },
	0xC9C4, { 0xE5, 0xA1, 0xB4 },
	0xC9C5, { 0xE5, 0xA2, 0x8B },
	0xC9C6, { 0xE5, 0xA1, 0xBA },
	0xC9C7, { 0xE5, 0xA2, 0x87 },
	0xC9C8, { 0xE5, 0xA2, 0x91 },
	0xC9C9, { 0xE5, 0xA2, 0x8E },
	0xC9CA, { 0xE5, 0xA1, 0xB6 },
	0xC9CB, { 0xE5, 0xA2, 0x82 },
	0xC9CC, { 0xE5, 0xA2, 0x88 },
	0xC9CD, { 0xE5, 0xA1, 0xBB },
	0xC9CE, { 0xE5, 0xA2, 0x94 },
	0xC9CF, { 0xE5, 0xA2, 0x8F },
	0xC9D0, { 0xE5, 0xA3, 0xBE },
	0xC9D1, { 0xE5, 0xA5, 0xAB },
	0xC9D2, { 0xE5, 0xAB, 0x9C },
	0xC9D3, { 0xE5, 0xAB, 0xAE },
	0xC9D4, { 0xE5, 0xAB, 0xA5 },
	0xC9D5, { 0xE5, 0xAB, 0x95 },
	0xC9D6, { 0xE5, 0xAB, 0xAA },
	0xC9D7, { 0xE5, 0xAB, 0x9A },
	0xC9D8, { 0xE5, 0xAB, 0xAD },
	0xC9D9, { 0xE5, 0xAB, 0xAB },
	0xC9DA, { 0xE5, 0xAB, 0xB3 },
	0xC9DB, { 0xE5, 0xAB, 0xA2 },
	0xC9DC, { 0xE5, 0xAB, 0xA0 },
	0xC9DD, { 0xE5, 0xAB, 0x9B },
	0xC9DE, { 0xE5, 0xAB, 0xAC },
	0xC9DF, { 0xE5, 0xAB, 0x9E },
	0xC9E0, { 0xE5, 0xAB, 0x9D },
	0xC9E1, { 0xE5, 0xAB, 0x99 },
	0xC9E2, { 0xE5, 0xAB, 0xA8 },
	0xC9E3, { 0xE5, 0xAB, 0x9F },
	0xC9E4, { 0xE5, 0xAD, 0xB7 },
	0xC9E5, { 0xE5, 0xAF, 0xA0 },
	0xC9E6, { 0xE5, 0xAF, 0xA3 },
	0xC9E7, { 0xE5, 0xB1, 0xA3 },
	0xC9E8, { 0xE5, 0xB6, 0x82 },
	0xC9E9, { 0xE5, 0xB6, 0x80 },
	0xC9EA, { 0xE5, 0xB5, 0xBD },
	0xC9EB, { 0xE5, 0xB6, 0x86 },
	0xC9EC, { 0xE5, 0xB5, 0xBA },
	0xC9ED, { 0xE5, 0xB6, 0x81 },
	0xC9EE, { 0xE5, 0xB5, 0xB7 },
	0xC9EF, { 0xE5, 0xB6, 0x8A },
	0xC9F0, { 0xE5, 0xB6, 0x89 },
	0xC9F1, { 0xE5, 0xB6, 0x88 },
	0xC9F2, { 0xE5, 0xB5, 0xBE },
	0xC9F3, { 0xE5, 0xB5, 0xBC },
	0xC9F4, { 0xE5, 0xB6, 0x8D },
	0xC9F5, { 0xE5, 0xB5, 0xB9 },
	0xC9F6, { 0xE5, 0xB5, 0xBF },
	0xC9F7, { 0xE5, 0xB9, 0x98 },
	0xC9F8, { 0xE5, 0xB9, 0x99 },
	0xC9F9, { 0xE5, 0xB9, 0x93 },
	0xC9FA, { 0xE5, 0xBB, 0x98 },
	0xC9FB, { 0xE5, 0xBB, 0x91 },
	0xC9FC, { 0xE5, 0xBB, 0x97 },
	0xC9FD, { 0xE5, 0xBB, 0x8E },
	0xC9FE, { 0xE5, 0xBB, 0x9C },
	0xCAA1, { 0xE5, 0xBB, 0x95 },
	0xCAA2, { 0xE5, 0xBB, 0x99 },
	0xCAA3, { 0xE5, 0xBB, 0x92 },
	0xCAA4, { 0xE5, 0xBB, 0x94 },
	0xCAA5, { 0xE5, 0xBD, 0x84 },
	0xCAA6, { 0xE5, 0xBD, 0x83 },
	0xCAA7, { 0xE5, 0xBD, 0xAF },
	0xCAA8, { 0xE5, 0xBE, 0xB6 },
	0xCAA9, { 0xE6, 0x84, 0xAC },
	0xCAAA, { 0xE6, 0x84, 0xA8 },
	0xCAAB, { 0xE6, 0x85, 0x81 },
	0xCAAC, { 0xE6, 0x85, 0x9E },
	0xCAAD, { 0xE6, 0x85, 0xB1 },
	0xCAAE, { 0xE6, 0x85, 0xB3 },
	0xCAAF, { 0xE6, 0x85, 0x92 },
	0xCAB0, { 0xE6, 0x85, 0x93 },
	0xCAB1, { 0xE6, 0x85, 0xB2 },
	0xCAB2, { 0xE6, 0x85, 0xAC },
	0xCAB3, { 0xE6, 0x86, 0x80 },
	0xCAB4, { 0xE6, 0x85, 0xB4 },
	0xCAB5, { 0xE6, 0x85, 0x94 },
	0xCAB6, { 0xE6, 0x85, 0xBA },
	0xCAB7, { 0xE6, 0x85, 0x9B },
	0xCAB8, { 0xE6, 0x85, 0xA5 },
	0xCAB9, { 0xE6, 0x84, 0xBB },
	0xCABA, { 0xE6, 0x85, 0xAA },
	0xCABB, { 0xE6, 0x85, 0xA1 },
	0xCABC, { 0xE6, 0x85, 0x96 },
	0xCABD, { 0xE6, 0x88, 0xA9 },
	0xCABE, { 0xE6, 0x88, 0xA7 },
	0xCABF, { 0xE6, 0x88, 0xAB },
	0xCAC0, { 0xE6, 0x90, 0xAB },
	0xCAC1, { 0xE6, 0x91, 0x8D },
	0xCAC2, { 0xE6, 0x91, 0x9B },
	0xCAC3, { 0xE6, 0x91, 0x9D },
	0xCAC4, { 0xE6, 0x91, 0xB4 },
	0xCAC5, { 0xE6, 0x91, 0xB6 },
	0xCAC6, { 0xE6, 0x91, 0xB2 },
	0xCAC7, { 0xE6, 0x91, 0xB3 },
	0xCAC8, { 0xE6, 0x91, 0xBD },
	0xCAC9, { 0xE6, 0x91, 0xB5 },
	0xCACA, { 0xE6, 0x91, 0xA6 },
	0xCACB, { 0xE6, 0x92, 0xA6 },
	0xCACC, { 0xE6, 0x91, 0x8E },
	0xCACD, { 0xE6, 0x92, 0x82 },
	0xCACE, { 0xE6, 0x91, 0x9E },
	0xCACF, { 0xE6, 0x91, 0x9C },
	0xCAD0, { 0xE6, 0x91, 0x8B },
	0xCAD1, { 0xE6, 0x91, 0x93 },
	0xCAD2, { 0xE6, 0x91, 0xA0 },
	0xCAD3, { 0xE6, 0x91, 0x90 },
	0xCAD4, { 0xE6, 0x91, 0xBF },
	0xCAD5, { 0xE6, 0x90, 0xBF },
	0xCAD6, { 0xE6, 0x91, 0xAC },
	0xCAD7, { 0xE6, 0x91, 0xAB },
	0xCAD8, { 0xE6, 0x91, 0x99 },
	0xCAD9, { 0xE6, 0x91, 0xA5 },
	0xCADA, { 0xE6, 0x91, 0xB7 },
	0xCADB, { 0xE6, 0x95, 0xB3 },
	0xCADC, { 0xE6, 0x96, 0xA0 },
	0xCADD, { 0xE6, 0x9A, 0xA1 },
	0xCADE, { 0xE6, 0x9A, 0xA0 },
	0xCADF, { 0xE6, 0x9A, 0x9F },
	0xCAE0, { 0xE6, 0x9C, 0x85 },
	0xCAE1, { 0xE6, 0x9C, 0x84 },
	0xCAE2, { 0xE6, 0x9C, 0xA2 },
	0xCAE3, { 0xE6, 0xA6, 0xB1 },
	0xCAE4, { 0xE6, 0xA6, 0xB6 },
	0xCAE5, { 0xE6, 0xA7, 0x89 },
	0xCAE6, { 0xE6, 0xA6, 0xA0 },
	0xCAE7, { 0xE6, 0xA7, 0x8E },
	0xCAE8, { 0xE6, 0xA6, 0x96 },
	0xCAE9, { 0xE6, 0xA6, 0xB0 },
	0xCAEA, { 0xE6, 0xA6, 0xAC },
	0xCAEB, { 0xE6, 0xA6, 0xBC },
	0xCAEC, { 0xE6, 0xA6, 0x91 },
	0xCAED, { 0xE6, 0xA6, 0x99 },
	0xCAEE, { 0xE6, 0xA6, 0x8E },
	0xCAEF, { 0xE6, 0xA6, 0xA7 },
	0xCAF0, { 0xE6, 0xA6, 0x8D },
	0xCAF1, { 0xE6, 0xA6, 0xA9 },
	0xCAF2, { 0xE6, 0xA6, 0xBE },
	0xCAF3, { 0xE6, 0xA6, 0xAF },
	0xCAF4, { 0xE6, 0xA6, 0xBF },
	0xCAF5, { 0xE6, 0xA7, 0x84 },
	0xCAF6, { 0xE6, 0xA6, 0xBD },
	0xCAF7, { 0xE6, 0xA6, 0xA4 },
	0xCAF8, { 0xE6, 0xA7, 0x94 },
	0xCAF9, { 0xE6, 0xA6, 0xB9 },
	0xCAFA, { 0xE6, 0xA7, 0x8A },
	0xCAFB, { 0xE6, 0xA6, 0x9A },
	0xCAFC, { 0xE6, 0xA7, 0x8F },
	0xCAFD, { 0xE6, 0xA6, 0xB3 },
	0xCAFE, { 0xE6, 0xA6, 0x93 },
	0xCBA1, { 0xE6, 0xA6, 0xAA },
	0xCBA2, { 0xE6, 0xA6, 0xA1 },
	0xCBA3, { 0xE6, 0xA6, 0x9E },
	0xCBA4, { 0xE6, 0xA7, 0x99 },
	0xCBA5, { 0xE6, 0xA6, 0x97 },
	0xCBA6, { 0xE6, 0xA6, 0x90 },
	0xCBA7, { 0xE6, 0xA7, 0x82 },
	0xCBA8, { 0xE6, 0xA6, 0xB5 },
	0xCBA9, { 0xE6, 0xA6, 0xA5 },
	0xCBAA, { 0xE6, 0xA7, 0x86 },
	0xCBAB, { 0xE6, 0xAD, 0x8A },
	0xCBAC, { 0xE6, 0xAD, 0x8D },
	0xCBAD, { 0xE6, 0xAD, 0x8B },
	0xCBAE, { 0xE6, 0xAE, 0x9E },
	0xCBAF, { 0xE6, 0xAE, 0x9F },
	0xCBB0, { 0xE6, 0xAE, 0xA0 },
	0xCBB1, { 0xE6, 0xAF, 0x83 },
	0xCBB2, { 0xE6, 0xAF, 0x84 },
	0xCBB3, { 0xE6, 0xAF, 0xBE },
	0xCBB4, { 0xE6, 0xBB, 0x8E },
	0xCBB5, { 0xE6, 0xBB, 0xB5 },
	0xCBB6, { 0xE6, 0xBB, 0xB1 },
	0xCBB7, { 0xE6, 0xBC, 0x83 },
	0xCBB8, { 0xE6, 0xBC, 0xA5 },
	0xCBB9, { 0xE6, 0xBB, 0xB8 },
	0xCBBA, { 0xE6, 0xBC, 0xB7 },
	0xCBBB, { 0xE6, 0xBB, 0xBB },
	0xCBBC, { 0xE6, 0xBC, 0xAE },
	0xCBBD, { 0xE6, 0xBC, 0x89 },
	0xCBBE, { 0xE6, 0xBD, 0x8E },
	0xCBBF, { 0xE6, 0xBC, 0x99 },
	0xCBC0, { 0xE6, 0xBC, 0x9A },
	0xCBC1, { 0xE6, 0xBC, 0xA7 },
	0xCBC2, { 0xE6, 0xBC, 0x98 },
	0xCBC3, { 0xE6, 0xBC, 0xBB },
	0xCBC4, { 0xE6, 0xBC, 0x92 },
	0xCBC5, { 0xE6, 0xBB, 0xAD },
	0xCBC6, { 0xE6, 0xBC, 0x8A },
	0xCBC7, { 0xE6, 0xBC, 0xB6 },
	0xCBC8, { 0xE6, 0xBD, 0xB3 },
	0xCBC9, { 0xE6, 0xBB, 0xB9 },
	0xCBCA, { 0xE6, 0xBB, 0xAE },
	0xCBCB, { 0xE6, 0xBC, 0xAD },
	0xCBCC, { 0xE6, 0xBD, 0x80 },
	0xCBCD, { 0xE6, 0xBC, 0xB0 },
	0xCBCE, { 0xE6, 0xBC, 0xBC },
	0xCBCF, { 0xE6, 0xBC, 0xB5 },
	0xCBD0, { 0xE6, 0xBB, 0xAB },
	0xCBD1, { 0xE6, 0xBC, 0x87 },
	0xCBD2, { 0xE6, 0xBC, 0x8E },
	0xCBD3, { 0xE6, 0xBD, 0x83 },
	0xCBD4, { 0xE6, 0xBC, 0x85 },
	0xCBD5, { 0xE6, 0xBB, 0xBD },
	0xCBD6, { 0xE6, 0xBB, 0xB6 },
	0xCBD7, { 0xE6, 0xBC, 0xB9 },
	0xCBD8, { 0xE6, 0xBC, 0x9C },
	0xCBD9, { 0xE6, 0xBB, 0xBC },
	0xCBDA, { 0xE6, 0xBC, 0xBA },
	0xCBDB, { 0xE6, 0xBC, 0x9F },
	0xCBDC, { 0xE6, 0xBC, 0x8D },
	0xCBDD, { 0xE6, 0xBC, 0x9E },
	0xCBDE, { 0xE6, 0xBC, 0x88 },
	0xCBDF, { 0xE6, 0xBC, 0xA1 },
	0xCBE0, { 0xE7, 0x86, 0x87 },
	0xCBE1, { 0xE7, 0x86, 0x90 },
	0xCBE2, { 0xE7, 0x86, 0x89 },
	0xCBE3, { 0xE7, 0x86, 0x80 },
	0xCBE4, { 0xE7, 0x86, 0x85 },
	0xCBE5, { 0xE7, 0x86, 0x82 },
	0xCBE6, { 0xE7, 0x86, 0x8F },
	0xCBE7, { 0xE7, 0x85, 0xBB },
	0xCBE8, { 0xE7, 0x86, 0x86 },
	0xCBE9, { 0xE7, 0x86, 0x81 },
	0xCBEA, { 0xE7, 0x86, 0x97 },
	0xCBEB, { 0xE7, 0x89, 0x84 },
	0xCBEC, { 0xE7, 0x89, 0x93 },
	0xCBED, { 0xE7, 0x8A, 0x97 },
	0xCBEE, { 0xE7, 0x8A, 0x95 },
	0xCBEF, { 0xE7, 0x8A, 0x93 },
	0xCBF0, { 0xE7, 0x8D, 0x83 },
	0xCBF1, { 0xE7, 0x8D, 0x8D },
	0xCBF2, { 0xE7, 0x8D, 0x91 },
	0xCBF3, { 0xE7, 0x8D, 0x8C },
	0xCBF4, { 0xE7, 0x91, 0xA2 },
	0xCBF5, { 0xE7, 0x91, 0xB3 },
	0xCBF6, { 0xE7, 0x91, 0xB1 },
	0xCBF7, { 0xE7, 0x91, 0xB5 },
	0xCBF8, { 0xE7, 0x91, 0xB2 },
	0xCBF9, { 0xE7, 0x91, 0xA7 },
	0xCBFA, { 0xE7, 0x91, 0xAE },
	0xCBFB, { 0xE7, 0x94, 0x80 },
	0xCBFC, { 0xE7, 0x94, 0x82 },
	0xCBFD, { 0xE7, 0x94, 0x83 },
	0xCBFE, { 0xE7, 0x95, 0xBD },
	0xCCA1, { 0xE7, 0x96, 0x90 },
	0xCCA2, { 0xE7, 0x98, 0x96 },
	0xCCA3, { 0xE7, 0x98, 0x88 },
	0xCCA4, { 0xE7, 0x98, 0x8C },
	0xCCA5, { 0xE7, 0x98, 0x95 },
	0xCCA6, { 0xE7, 0x98, 0x91 },
	0xCCA7, { 0xE7, 0x98, 0x8A },
	0xCCA8, { 0xE7, 0x98, 0x94 },
	0xCCA9, { 0xE7, 0x9A, 0xB8 },
	0xCCAA, { 0xE7, 0x9E, 0x81 },
	0xCCAB, { 0xE7, 0x9D, 0xBC },
	0xCCAC, { 0xE7, 0x9E, 0x85 },
	0xCCAD, { 0xE7, 0x9E, 0x82 },
	0xCCAE, { 0xE7, 0x9D, 0xAE },
	0xCCAF, { 0xE7, 0x9E, 0x80 },
	0xCCB0, { 0xE7, 0x9D, 0xAF },
	0xCCB1, { 0xE7, 0x9D, 0xBE },
	0xCCB2, { 0xE7, 0x9E, 0x83 },
	0xCCB3, { 0xE7, 0xA2, 0xB2 },
	0xCCB4, { 0xE7, 0xA2, 0xAA },
	0xCCB5, { 0xE7, 0xA2, 0xB4 },
	0xCCB6, { 0xE7, 0xA2, 0xAD },
	0xCCB7, { 0xE7, 0xA2, 0xA8 },
	0xCCB8, { 0xE7, 0xA1, 0xBE },
	0xCCB9, { 0xE7, 0xA2, 0xAB },
	0xCCBA, { 0xE7, 0xA2, 0x9E },
	0xCCBB, { 0xE7, 0xA2, 0xA5 },
	0xCCBC, { 0xE7, 0xA2, 0xA0 },
	0xCCBD, { 0xE7, 0xA2, 0xAC },
	0xCCBE, { 0xE7, 0xA2, 0xA2 },
	0xCCBF, { 0xE7, 0xA2, 0xA4 },
	0xCCC0, { 0xE7, 0xA6, 0x98 },
	0xCCC1, { 0xE7, 0xA6, 0x8A },
	0xCCC2, { 0xE7, 0xA6, 0x8B },
	0xCCC3, { 0xE7, 0xA6, 0x96 },
	0xCCC4, { 0xE7, 0xA6, 0x95 },
	0xCCC5, { 0xE7, 0xA6, 0x94 },
	0xCCC6, { 0xE7, 0xA6, 0x93 },
	0xCCC7, { 0xE7, 0xA6, 0x97 },
	0xCCC8, { 0xE7, 0xA6, 0x88 },
	0xCCC9, { 0xE7, 0xA6, 0x92 },
	0xCCCA, { 0xE7, 0xA6, 0x90 },
	0xCCCB, { 0xE7, 0xA8, 0xAB },
	0xCCCC, { 0xE7, 0xA9, 0x8A },
	0xCCCD, { 0xE7, 0xA8, 0xB0 },
	0xCCCE, { 0xE7, 0xA8, 0xAF },
	0xCCCF, { 0xE7, 0xA8, 0xA8 },
	0xCCD0, { 0xE7, 0xA8, 0xA6 },
	0xCCD1, { 0xE7, 0xAA, 0xA8 },
	0xCCD2, { 0xE7, 0xAA, 0xAB },
	0xCCD3, { 0xE7, 0xAA, 0xAC },
	0xCCD4, { 0xE7, 0xAB, 0xAE },
	0xCCD5, { 0xE7, 0xAE, 0x88 },
	0xCCD6, { 0xE7, 0xAE, 0x9C },
	0xCCD7, { 0xE7, 0xAE, 0x8A },
	0xCCD8, { 0xE7, 0xAE, 0x91 },
	0xCCD9, { 0xE7, 0xAE, 0x90 },
	0xCCDA, { 0xE7, 0xAE, 0x96 },
	0xCCDB, { 0xE7, 0xAE, 0x8D },
	0xCCDC, { 0xE7, 0xAE, 0x8C },
	0xCCDD, { 0xE7, 0xAE, 0x9B },
	0xCCDE, { 0xE7, 0xAE, 0x8E },
	0xCCDF, { 0xE7, 0xAE, 0x85 },
	0xCCE0, { 0xE7, 0xAE, 0x98 },
	0xCCE1, { 0xE5, 0x8A, 0x84 },
	0xCCE2, { 0xE7, 0xAE, 0x99 },
	0xCCE3, { 0xE7, 0xAE, 0xA4 },
	0xCCE4, { 0xE7, 0xAE, 0x82 },
	0xCCE5, { 0xE7, 0xB2, 0xBB },
	0xCCE6, { 0xE7, 0xB2, 0xBF },
	0xCCE7, { 0xE7, 0xB2, 0xBC },
	0xCCE8, { 0xE7, 0xB2, 0xBA },
	0xCCE9, { 0xE7, 0xB6, 0xA7 },
	0xCCEA, { 0xE7, 0xB6, 0xB7 },
	0xCCEB, { 0xE7, 0xB7, 0x82 },
	0xCCEC, { 0xE7, 0xB6, 0xA3 },
	0xCCED, { 0xE7, 0xB6, 0xAA },
	0xCCEE, { 0xE7, 0xB7, 0x81 },
	0xCCEF, { 0xE7, 0xB7, 0x80 },
	0xCCF0, { 0xE7, 0xB7, 0x85 },
	0xCCF1, { 0xE7, 0xB6, 0x9D },
	0xCCF2, { 0xE7, 0xB7, 0x8E },
	0xCCF3, { 0xE7, 0xB7, 0x84 },
	0xCCF4, { 0xE7, 0xB7, 0x86 },
	0xCCF5, { 0xE7, 0xB7, 0x8B },
	0xCCF6, { 0xE7, 0xB7, 0x8C },
	0xCCF7, { 0xE7, 0xB6, 0xAF },
	0xCCF8, { 0xE7, 0xB6, 0xB9 },
	0xCCF9, { 0xE7, 0xB6, 0x96 },
	0xCCFA, { 0xE7, 0xB6, 0xBC },
	0xCCFB, { 0xE7, 0xB6, 0x9F },
	0xCCFC, { 0xE7, 0xB6, 0xA6 },
	0xCCFD, { 0xE7, 0xB6, 0xAE },
	0xCCFE, { 0xE7, 0xB6, 0xA9 },
	0xCDA1, { 0xE7, 0xB6, 0xA1 },
	0xCDA2, { 0xE7, 0xB7, 0x89 },
	0xCDA3, { 0xE7, 0xBD, 0xB3 },
	0xCDA4, { 0xE7, 0xBF, 0xA2 },
	0xCDA5, { 0xE7, 0xBF, 0xA3 },
	0xCDA6, { 0xE7, 0xBF, 0xA5 },
	0xCDA7, { 0xE7, 0xBF, 0x9E },
	0xCDA8, { 0xE8, 0x80, 0xA4 },
	0xCDA9, { 0xE8, 0x81, 0x9D },
	0xCDAA, { 0xE8, 0x81, 0x9C },
	0xCDAB, { 0xE8, 0x86, 0x89 },
	0xCDAC, { 0xE8, 0x86, 0x86 },
	0xCDAD, { 0xE8, 0x86, 0x83 },
	0xCDAE, { 0xE8, 0x86, 0x87 },
	0xCDAF, { 0xE8, 0x86, 0x8D },
	0xCDB0, { 0xE8, 0x86, 0x8C },
	0xCDB1, { 0xE8, 0x86, 0x8B },
	0xCDB2, { 0xE8, 0x88, 0x95 },
	0xCDB3, { 0xE8, 0x92, 0x97 },
	0xCDB4, { 0xE8, 0x92, 0xA4 },
	0xCDB5, { 0xE8, 0x92, 0xA1 },
	0xCDB6, { 0xE8, 0x92, 0x9F },
	0xCDB7, { 0xE8, 0x92, 0xBA },
	0xCDB8, { 0xE8, 0x93, 0x8E },
	0xCDB9, { 0xE8, 0x93, 0x82 },
	0xCDBA, { 0xE8, 0x92, 0xAC },
	0xCDBB, { 0xE8, 0x92, 0xAE },
	0xCDBC, { 0xE8, 0x92, 0xAB },
	0xCDBD, { 0xE8, 0x92, 0xB9 },
	0xCDBE, { 0xE8, 0x92, 0xB4 },
	0xCDBF, { 0xE8, 0x93, 0x81 },
	0xCDC0, { 0xE8, 0x93, 0x8D },
	0xCDC1, { 0xE8, 0x92, 0xAA },
	0xCDC2, { 0xE8, 0x92, 0x9A },
	0xCDC3, { 0xE8, 0x92, 0xB1 },
	0xCDC4, { 0xE8, 0x93, 0x90 },
	0xCDC5, { 0xE8, 0x92, 0x9D },
	0xCDC6, { 0xE8, 0x92, 0xA7 },
	0xCDC7, { 0xE8, 0x92, 0xBB },
	0xCDC8, { 0xE8, 0x92, 0xA2 },
	0xCDC9, { 0xE8, 0x92, 0x94 },
	0xCDCA, { 0xE8, 0x93, 0x87 },
	0xCDCB, { 0xE8, 0x93, 0x8C },
	0xCDCC, { 0xE8, 0x92, 0x9B },
	0xCDCD, { 0xE8, 0x92, 0xA9 },
	0xCDCE, { 0xE8, 0x92, 0xAF },
	0xCDCF, { 0xE8, 0x92, 0xA8 },
	0xCDD0, { 0xE8, 0x93, 0x96 },
	0xCDD1, { 0xE8, 0x92, 0x98 },
	0xCDD2, { 0xE8, 0x92, 0xB6 },
	0xCDD3, { 0xE8, 0x93, 0x8F },
	0xCDD4, { 0xE8, 0x92, 0xA0 },
	0xCDD5, { 0xE8, 0x93, 0x97 },
	0xCDD6, { 0xE8, 0x93, 0x94 },
	0xCDD7, { 0xE8, 0x93, 0x92 },
	0xCDD8, { 0xE8, 0x93, 0x9B },
	0xCDD9, { 0xE8, 0x92, 0xB0 },
	0xCDDA, { 0xE8, 0x92, 0x91 },
	0xCDDB, { 0xE8, 0x99, 0xA1 },
	0xCDDC, { 0xE8, 0x9C, 0xB3 },
	0xCDDD, { 0xE8, 0x9C, 0xA3 },
	0xCDDE, { 0xE8, 0x9C, 0xA8 },
	0xCDDF, { 0xE8, 0x9D, 0xAB },
	0xCDE0, { 0xE8, 0x9D, 0x80 },
	0xCDE1, { 0xE8, 0x9C, 0xAE },
	0xCDE2, { 0xE8, 0x9C, 0x9E },
	0xCDE3, { 0xE8, 0x9C, 0xA1 },
	0xCDE4, { 0xE8, 0x9C, 0x99 },
	0xCDE5, { 0xE8, 0x9C, 0x9B },
	0xCDE6, { 0xE8, 0x9D, 0x83 },
	0xCDE7, { 0xE8, 0x9C, 0xAC },
	0xCDE8, { 0xE8, 0x9D, 0x81 },
	0xCDE9, { 0xE8, 0x9C, 0xBE },
	0xCDEA, { 0xE8, 0x9D, 0x86 },
	0xCDEB, { 0xE8, 0x9C, 0xA0 },
	0xCDEC, { 0xE8, 0x9C, 0xB2 },
	0xCDED, { 0xE8, 0x9C, 0xAA },
	0xCDEE, { 0xE8, 0x9C, 0xAD },
	0xCDEF, { 0xE8, 0x9C, 0xBC },
	0xCDF0, { 0xE8, 0x9C, 0x92 },
	0xCDF1, { 0xE8, 0x9C, 0xBA },
	0xCDF2, { 0xE8, 0x9C, 0xB1 },
	0xCDF3, { 0xE8, 0x9C, 0xB5 },
	0xCDF4, { 0xE8, 0x9D, 0x82 },
	0xCDF5, { 0xE8, 0x9C, 0xA6 },
	0xCDF6, { 0xE8, 0x9C, 0xA7 },
	0xCDF7, { 0xE8, 0x9C, 0xB8 },
	0xCDF8, { 0xE8, 0x9C, 0xA4 },
	0xCDF9, { 0xE8, 0x9C, 0x9A },
	0xCDFA, { 0xE8, 0x9C, 0xB0 },
	0xCDFB, { 0xE8, 0x9C, 0x91 },
	0xCDFC, { 0xE8, 0xA3, 0xB7 },
	0xCDFD, { 0xE8, 0xA3, 0xA7 },
	0xCDFE, { 0xE8, 0xA3, 0xB1 },
	0xCEA1, { 0xE8, 0xA3, 0xB2 },
	0xCEA2, { 0xE8, 0xA3, 0xBA },
	0xCEA3, { 0xE8, 0xA3, 0xBE },
	0xCEA4, { 0xE8, 0xA3, 0xAE },
	0xCEA5, { 0xE8, 0xA3, 0xBC },
	0xCEA6, { 0xE8, 0xA3, 0xB6 },
	0xCEA7, { 0xE8, 0xA3, 0xBB },
	0xCEA8, { 0xE8, 0xA3, 0xB0 },
	0xCEA9, { 0xE8, 0xA3, 0xAC },
	0xCEAA, { 0xE8, 0xA3, 0xAB },
	0xCEAB, { 0xE8, 0xA6, 0x9D },
	0xCEAC, { 0xE8, 0xA6, 0xA1 },
	0xCEAD, { 0xE8, 0xA6, 0x9F },
	0xCEAE, { 0xE8, 0xA6, 0x9E },
	0xCEAF, { 0xE8, 0xA7, 0xA9 },
	0xCEB0, { 0xE8, 0xA7, 0xAB },
	0xCEB1, { 0xE8, 0xA7, 0xA8 },
	0xCEB2, { 0xE8, 0xAA, 0xAB },
	0xCEB3, { 0xE8, 0xAA, 0x99 },
	0xCEB4, { 0xE8, 0xAA, 0x8B },
	0xCEB5, { 0xE8, 0xAA, 0x92 },
	0xCEB6, { 0xE8, 0xAA, 0x8F },
	0xCEB7, { 0xE8, 0xAA, 0x96 },
	0xCEB8, { 0xE8, 0xB0, 0xBD },
	0xCEB9, { 0xE8, 0xB1, 0xA8 },
	0xCEBA, { 0xE8, 0xB1, 0xA9 },
	0xCEBB, { 0xE8, 0xB3, 0x95 },
	0xCEBC, { 0xE8, 0xB3, 0x8F },
	0xCEBD, { 0xE8, 0xB3, 0x97 },
	0xCEBE, { 0xE8, 0xB6, 0x96 },
	0xCEBF, { 0xE8, 0xB8, 0x89 },
	0xCEC0, { 0xE8, 0xB8, 0x82 },
	0xCEC1, { 0xE8, 0xB7, 0xBF },
	0xCEC2, { 0xE8, 0xB8, 0x8D },
	0xCEC3, { 0xE8, 0xB7, 0xBD },
	0xCEC4, { 0xE8, 0xB8, 0x8A },
	0xCEC5, { 0xE8, 0xB8, 0x83 },
	0xCEC6, { 0xE8, 0xB8, 0x87 },
	0xCEC7, { 0xE8, 0xB8, 0x86 },
	0xCEC8, { 0xE8, 0xB8, 0x85 },
	0xCEC9, { 0xE8, 0xB7, 0xBE },
	0xCECA, { 0xE8, 0xB8, 0x80 },
	0xCECB, { 0xE8, 0xB8, 0x84 },
	0xCECC, { 0xE8, 0xBC, 0x90 },
	0xCECD, { 0xE8, 0xBC, 0x91 },
	0xCECE, { 0xE8, 0xBC, 0x8E },
	0xCECF, { 0xE8, 0xBC, 0x8D },
	0xCED0, { 0xE9, 0x84, 0xA3 },
	0xCED1, { 0xE9, 0x84, 0x9C },
	0xCED2, { 0xE9, 0x84, 0xA0 },
	0xCED3, { 0xE9, 0x84, 0xA2 },
	0xCED4, { 0xE9, 0x84, 0x9F },
	0xCED5, { 0xE9, 0x84, 0x9D },
	0xCED6, { 0xE9, 0x84, 0x9A },
	0xCED7, { 0xE9, 0x84, 0xA4 },
	0xCED8, { 0xE9, 0x84, 0xA1 },
	0xCED9, { 0xE9, 0x84, 0x9B },
	0xCEDA, { 0xE9, 0x85, 0xBA },
	0xCEDB, { 0xE9, 0x85, 0xB2 },
	0xCEDC, { 0xE9, 0x85, 0xB9 },
	0xCEDD, { 0xE9, 0x85, 0xB3 },
	0xCEDE, { 0xE9, 0x8A, 0xA5 },
	0xCEDF, { 0xE9, 0x8A, 0xA4 },
	0xCEE0, { 0xE9, 0x89, 0xB6 },
	0xCEE1, { 0xE9, 0x8A, 0x9B },
	0xCEE2, { 0xE9, 0x89, 0xBA },
	0xCEE3, { 0xE9, 0x8A, 0xA0 },
	0xCEE4, { 0xE9, 0x8A, 0x94 },
	0xCEE5, { 0xE9, 0x8A, 0xAA },
	0xCEE6, { 0xE9, 0x8A, 0x8D },
	0xCEE7, { 0xE9, 0x8A, 0xA6 },
	0xCEE8, { 0xE9, 0x8A, 0x9A },
	0xCEE9, { 0xE9, 0x8A, 0xAB },
	0xCEEA, { 0xE9, 0x89, 0xB9 },
	0xCEEB, { 0xE9, 0x8A, 0x97 },
	0xCEEC, { 0xE9, 0x89, 0xBF },
	0xCEED, { 0xE9, 0x8A, 0xA3 },
	0xCEEE, { 0xE9, 0x8B, 0xAE },
	0xCEEF, { 0xE9, 0x8A, 0x8E },
	0xCEF0, { 0xE9, 0x8A, 0x82 },
	0xCEF1, { 0xE9, 0x8A, 0x95 },
	0xCEF2, { 0xE9, 0x8A, 0xA2 },
	0xCEF3, { 0xE9, 0x89, 0xBD },
	0xCEF4, { 0xE9, 0x8A, 0x88 },
	0xCEF5, { 0xE9, 0x8A, 0xA1 },
	0xCEF6, { 0xE9, 0x8A, 0x8A },
	0xCEF7, { 0xE9, 0x8A, 0x86 },
	0xCEF8, { 0xE9, 0x8A, 0x8C },
	0xCEF9, { 0xE9, 0x8A, 0x99 },
	0xCEFA, { 0xE9, 0x8A, 0xA7 },
	0xCEFB, { 0xE9, 0x89, 0xBE },
	0xCEFC, { 0xE9, 0x8A, 0x87 },
	0xCEFD, { 0xE9, 0x8A, 0xA9 },
	0xCEFE, { 0xE9, 0x8A, 0x9D },
	0xCFA1, { 0xE9, 0x8A, 0x8B },
	0xCFA2, { 0xE9, 0x88, 0xAD },
	0xCFA3, { 0xE9, 0x9A, 0x9E },
	0xCFA4, { 0xE9, 0x9A, 0xA1 },
	0xCFA5, { 0xE9, 0x9B, 0xBF },
	0xCFA6, { 0xE9, 0x9D, 0x98 },
	0xCFA7, { 0xE9, 0x9D, 0xBD },
	0xCFA8, { 0xE9, 0x9D, 0xBA },
	0xCFA9, { 0xE9, 0x9D, 0xBE },
	0xCFAA, { 0xE9, 0x9E, 0x83 },
	0xCFAB, { 0xE9, 0x9E, 0x80 },
	0xCFAC, { 0xE9, 0x9E, 0x82 },
	0xCFAD, { 0xE9, 0x9D, 0xBB },
	0xCFAE, { 0xE9, 0x9E, 0x84 },
	0xCFAF, { 0xE9, 0x9E, 0x81 },
	0xCFB0, { 0xE9, 0x9D, 0xBF },
	0xCFB1, { 0xE9, 0x9F, 0x8E },
	0xCFB2, { 0xE9, 0x9F, 0x8D },
	0xCFB3, { 0xE9, 0xA0, 0x96 },
	0xCFB4, { 0xE9, 0xA2, 0xAD },
	0xCFB5, { 0xE9, 0xA2, 0xAE },
	0xCFB6, { 0xE9, 0xA4, 0x82 },
	0xCFB7, { 0xE9, 0xA4, 0x80 },
	0xCFB8, { 0xE9, 0xA4, 0x87 },
	0xCFB9, { 0xE9, 0xA6, 0x9D },
	0xCFBA, { 0xE9, 0xA6, 0x9C },
	0xCFBB, { 0xE9, 0xA7, 0x83 },
	0xCFBC, { 0xE9, 0xA6, 0xB9 },
	0xCFBD, { 0xE9, 0xA6, 0xBB },
	0xCFBE, { 0xE9, 0xA6, 0xBA },
	0xCFBF, { 0xE9, 0xA7, 0x82 },
	0xCFC0, { 0xE9, 0xA6, 0xBD },
	0xCFC1, { 0xE9, 0xA7, 0x87 },
	0xCFC2, { 0xE9, 0xAA, 0xB1 },
	0xCFC3, { 0xE9, 0xAB, 0xA3 },
	0xCFC4, { 0xE9, 0xAB, 0xA7 },
	0xCFC5, { 0xE9, 0xAC, 0xBE },
	0xCFC6, { 0xE9, 0xAC, 0xBF },
	0xCFC7, { 0xE9, 0xAD, 0xA0 },
	0xCFC8, { 0xE9, 0xAD, 0xA1 },
	0xCFC9, { 0xE9, 0xAD, 0x9F },
	0xCFCA, { 0xE9, 0xB3, 0xB1 },
	0xCFCB, { 0xE9, 0xB3, 0xB2 },
	0xCFCC, { 0xE9, 0xB3, 0xB5 },
	0xCFCD, { 0xE9, 0xBA, 0xA7 },
	0xCFCE, { 0xE5, 0x83, 0xBF },
	0xCFCF, { 0xE5, 0x84, 0x83 },
	0xCFD0, { 0xE5, 0x84, 0xB0 },
	0xCFD1, { 0xE5, 0x83, 0xB8 },
	0xCFD2, { 0xE5, 0x84, 0x86 },
	0xCFD3, { 0xE5, 0x84, 0x87 },
	0xCFD4, { 0xE5, 0x83, 0xB6 },
	0xCFD5, { 0xE5, 0x83, 0xBE },
	0xCFD6, { 0xE5, 0x84, 0x8B },
	0xCFD7, { 0xE5, 0x84, 0x8C },
	0xCFD8, { 0xE5, 0x83, 0xBD },
	0xCFD9, { 0xE5, 0x84, 0x8A },
	0xCFDA, { 0xE5, 0x8A, 0x8B },
	0xCFDB, { 0xE5, 0x8A, 0x8C },
	0xCFDC, { 0xE5, 0x8B, 0xB1 },
	0xCFDD, { 0xE5, 0x8B, 0xAF },
	0xCFDE, { 0xE5, 0x99, 0x88 },
	0xCFDF, { 0xE5, 0x99, 0x82 },
	0xCFE0, { 0xE5, 0x99, 0x8C },
	0xCFE1, { 0xE5, 0x98, 0xB5 },
	0xCFE2, { 0xE5, 0x99, 0x81 },
	0xCFE3, { 0xE5, 0x99, 0x8A },
	0xCFE4, { 0xE5, 0x99, 0x89 },
	0xCFE5, { 0xE5, 0x99, 0x86 },
	0xCFE6, { 0xE5, 0x99, 0x98 },
	0xCFE7, { 0xE5, 0x99, 0x9A },
	0xCFE8, { 0xE5, 0x99, 0x80 },
	0xCFE9, { 0xE5, 0x98, 0xB3 },
	0xCFEA, { 0xE5, 0x98, 0xBD },
	0xCFEB, { 0xE5, 0x98, 0xAC },
	0xCFEC, { 0xE5, 0x98, 0xBE },
	0xCFED, { 0xE5, 0x98, 0xB8 },
	0xCFEE, { 0xE5, 0x98, 0xAA },
	0xCFEF, { 0xE5, 0x98, 0xBA },
	0xCFF0, { 0xE5, 0x9C, 0x9A },
	0xCFF1, { 0xE5, 0xA2, 0xAB },
	0xCFF2, { 0xE5, 0xA2, 0x9D },
	0xCFF3, { 0xE5, 0xA2, 0xB1 },
	0xCFF4, { 0xE5, 0xA2, 0xA0 },
	0xCFF5, { 0xE5, 0xA2, 0xA3 },
	0xCFF6, { 0xE5, 0xA2, 0xAF },
	0xCFF7, { 0xE5, 0xA2, 0xAC },
	0xCFF8, { 0xE5, 0xA2, 0xA5 },
	0xCFF9, { 0xE5, 0xA2, 0xA1 },
	0xCFFA, { 0xE5, 0xA3, 0xBF },
	0xCFFB, { 0xE5, 0xAB, 0xBF },
	0xCFFC, { 0xE5, 0xAB, 0xB4 },
	0xCFFD, { 0xE5, 0xAB, 0xBD },
	0xCFFE, { 0xE5, 0xAB, 0xB7 },
	0xD0A1, { 0xE5, 0xAB, 0xB6 },
	0xD0A2, { 0xE5, 0xAC, 0x83 },
	0xD0A3, { 0xE5, 0xAB, 0xB8 },
	0xD0A4, { 0xE5, 0xAC, 0x82 },
	0xD0A5, { 0xE5, 0xAB, 0xB9 },
	0xD0A6, { 0xE5, 0xAC, 0x81 },
	0xD0A7, { 0xE5, 0xAC, 0x87 },
	0xD0A8, { 0xE5, 0xAC, 0x85 },
	0xD0A9, { 0xE5, 0xAC, 0x8F },
	0xD0AA, { 0xE5, 0xB1, 0xA7 },
	0xD0AB, { 0xE5, 0xB6, 0x99 },
	0xD0AC, { 0xE5, 0xB6, 0x97 },
	0xD0AD, { 0xE5, 0xB6, 0x9F },
	0xD0AE, { 0xE5, 0xB6, 0x92 },
	0xD0AF, { 0xE5, 0xB6, 0xA2 },
	0xD0B0, { 0xE5, 0xB6, 0x93 },
	0xD0B1, { 0xE5, 0xB6, 0x95 },
	0xD0B2, { 0xE5, 0xB6, 0xA0 },
	0xD0B3, { 0xE5, 0xB6, 0x9C },
	0xD0B4, { 0xE5, 0xB6, 0xA1 },
	0xD0B5, { 0xE5, 0xB6, 0x9A },
	0xD0B6, { 0xE5, 0xB6, 0x9E },
	0xD0B7, { 0xE5, 0xB9, 0xA9 },
	0xD0B8, { 0xE5, 0xB9, 0x9D },
	0xD0B9, { 0xE5, 0xB9, 0xA0 },
	0xD0BA, { 0xE5, 0xB9, 0x9C },
	0xD0BB, { 0xE7, 0xB7, 0xB3 },
	0xD0BC, { 0xE5, 0xBB, 0x9B },
	0xD0BD, { 0xE5, 0xBB, 0x9E },
	0xD0BE, { 0xE5, 0xBB, 0xA1 },
	0xD0BF, { 0xE5, 0xBD, 0x89 },
	0xD0C0, { 0xE5, 0xBE, 0xB2 },
	0xD0C1, { 0xE6, 0x86, 0x8B },
	0xD0C2, { 0xE6, 0x86, 0x83 },
	0xD0C3, { 0xE6, 0x85, 0xB9 },
	0xD0C4, { 0xE6, 0x86, 0xB1 },
	0xD0C5, { 0xE6, 0x86, 0xB0 },
	0xD0C6, { 0xE6, 0x86, 0xA2 },
	0xD0C7, { 0xE6, 0x86, 0x89 },
	0xD0C8, { 0xE6, 0x86, 0x9B },
	0xD0C9, { 0xE6, 0x86, 0x93 },
	0xD0CA, { 0xE6, 0x86, 0xAF },
	0xD0CB, { 0xE6, 0x86, 0xAD },
	0xD0CC, { 0xE6, 0x86, 0x9F },
	0xD0CD, { 0xE6, 0x86, 0x92 },
	0xD0CE, { 0xE6, 0x86, 0xAA },
	0xD0CF, { 0xE6, 0x86, 0xA1 },
	0xD0D0, { 0xE6, 0x86, 0x8D },
	0xD0D1, { 0xE6, 0x85, 0xA6 },
	0xD0D2, { 0xE6, 0x86, 0xB3 },
	0xD0D3, { 0xE6, 0x88, 0xAD },
	0xD0D4, { 0xE6, 0x91, 0xAE },
	0xD0D5, { 0xE6, 0x91, 0xB0 },
	0xD0D6, { 0xE6, 0x92, 0x96 },
	0xD0D7, { 0xE6, 0x92, 0xA0 },
	0xD0D8, { 0xE6, 0x92, 0x85 },
	0xD0D9, { 0xE6, 0x92, 0x97 },
	0xD0DA, { 0xE6, 0x92, 0x9C },
	0xD0DB, { 0xE6, 0x92, 0x8F },
	0xD0DC, { 0xE6, 0x92, 0x8B },
	0xD0DD, { 0xE6, 0x92, 0x8A },
	0xD0DE, { 0xE6, 0x92, 0x8C },
	0xD0DF, { 0xE6, 0x92, 0xA3 },
	0xD0E0, { 0xE6, 0x92, 0x9F },
	0xD0E1, { 0xE6, 0x91, 0xA8 },
	0xD0E2, { 0xE6, 0x92, 0xB1 },
	0xD0E3, { 0xE6, 0x92, 0x98 },
	0xD0E4, { 0xE6, 0x95, 0xB6 },
	0xD0E5, { 0xE6, 0x95, 0xBA },
	0xD0E6, { 0xE6, 0x95, 0xB9 },
	0xD0E7, { 0xE6, 0x95, 0xBB },
	0xD0E8, { 0xE6, 0x96, 0xB2 },
	0xD0E9, { 0xE6, 0x96, 0xB3 },
	0xD0EA, { 0xE6, 0x9A, 0xB5 },
	0xD0EB, { 0xE6, 0x9A, 0xB0 },
	0xD0EC, { 0xE6, 0x9A, 0xA9 },
	0xD0ED, { 0xE6, 0x9A, 0xB2 },
	0xD0EE, { 0xE6, 0x9A, 0xB7 },
	0xD0EF, { 0xE6, 0x9A, 0xAA },
	0xD0F0, { 0xE6, 0x9A, 0xAF },
	0xD0F1, { 0xE6, 0xA8, 0x80 },
	0xD0F2, { 0xE6, 0xA8, 0x86 },
	0xD0F3, { 0xE6, 0xA8, 0x97 },
	0xD0F4, { 0xE6, 0xA7, 0xA5 },
	0xD0F5, { 0xE6, 0xA7, 0xB8 },
	0xD0F6, { 0xE6, 0xA8, 0x95 },
	0xD0F7, { 0xE6, 0xA7, 0xB1 },
	0xD0F8, { 0xE6, 0xA7, 0xA4 },
	0xD0F9, { 0xE6, 0xA8, 0xA0 },
	0xD0FA, { 0xE6, 0xA7, 0xBF },
	0xD0FB, { 0xE6, 0xA7, 0xAC },
	0xD0FC, { 0xE6, 0xA7, 0xA2 },
	0xD0FD, { 0xE6, 0xA8, 0x9B },
	0xD0FE, { 0xE6, 0xA8, 0x9D },
	0xD1A1, { 0xE6, 0xA7, 0xBE },
	0xD1A2, { 0xE6, 0xA8, 0xA7 },
	0xD1A3, { 0xE6, 0xA7, 0xB2 },
	0xD1A4, { 0xE6, 0xA7, 0xAE },
	0xD1A5, { 0xE6, 0xA8, 0x94 },
	0xD1A6, { 0xE6, 0xA7, 0xB7 },
	0xD1A7, { 0xE6, 0xA7, 0xA7 },
	0xD1A8, { 0xE6, 0xA9, 0x80 },
	0xD1A9, { 0xE6, 0xA8, 0x88 },
	0xD1AA, { 0xE6, 0xA7, 0xA6 },
	0xD1AB, { 0xE6, 0xA7, 0xBB },
	0xD1AC, { 0xE6, 0xA8, 0x8D },
	0xD1AD, { 0xE6, 0xA7, 0xBC },
	0xD1AE, { 0xE6, 0xA7, 0xAB },
	0xD1AF, { 0xE6, 0xA8, 0x89 },
	0xD1B0, { 0xE6, 0xA8, 0x84 },
	0xD1B1, { 0xE6, 0xA8, 0x98 },
	0xD1B2, { 0xE6, 0xA8, 0xA5 },
	0xD1B3, { 0xE6, 0xA8, 0x8F },
	0xD1B4, { 0xE6, 0xA7, 0xB6 },
	0xD1B5, { 0xE6, 0xA8, 0xA6 },
	0xD1B6, { 0xE6, 0xA8, 0x87 },
	0xD1B7, { 0xE6, 0xA7, 0xB4 },
	0xD1B8, { 0xE6, 0xA8, 0x96 },
	0xD1B9, { 0xE6, 0xAD, 0x91 },
	0xD1BA, { 0xE6, 0xAE, 0xA5 },
	0xD1BB, { 0xE6, 0xAE, 0xA3 },
	0xD1BC, { 0xE6, 0xAE, 0xA2 },
	0xD1BD, { 0xE6, 0xAE, 0xA6 },
	0xD1BE, { 0xE6, 0xB0, 0x81 },
	0xD1BF, { 0xE6, 0xB0, 0x80 },
	0xD1C0, { 0xE6, 0xAF, 0xBF },
	0xD1C1, { 0xE6, 0xB0, 0x82 },
	0xD1C2, { 0xE6, 0xBD, 0x81 },
	0xD1C3, { 0xE6, 0xBC, 0xA6 },
	0xD1C4, { 0xE6, 0xBD, 0xBE },
	0xD1C5, { 0xE6, 0xBE, 0x87 },
	0xD1C6, { 0xE6, 0xBF, 0x86 },
	0xD1C7, { 0xE6, 0xBE, 0x92 },
	0xD1C8, { 0xE6, 0xBE, 0x8D },
	0xD1C9, { 0xE6, 0xBE, 0x89 },
	0xD1CA, { 0xE6, 0xBE, 0x8C },
	0xD1CB, { 0xE6, 0xBD, 0xA2 },
	0xD1CC, { 0xE6, 0xBD, 0x8F },
	0xD1CD, { 0xE6, 0xBE, 0x85 },
	0xD1CE, { 0xE6, 0xBD, 0x9A },
	0xD1CF, { 0xE6, 0xBE, 0x96 },
	0xD1D0, { 0xE6, 0xBD, 0xB6 },
	0xD1D1, { 0xE6, 0xBD, 0xAC },
	0xD1D2, { 0xE6, 0xBE, 0x82 },
	0xD1D3, { 0xE6, 0xBD, 0x95 },
	0xD1D4, { 0xE6, 0xBD, 0xB2 },
	0xD1D5, { 0xE6, 0xBD, 0x92 },
	0xD1D6, { 0xE6, 0xBD, 0x90 },
	0xD1D7, { 0xE6, 0xBD, 0x97 },
	0xD1D8, { 0xE6, 0xBE, 0x94 },
	0xD1D9, { 0xE6, 0xBE, 0x93 },
	0xD1DA, { 0xE6, 0xBD, 0x9D },
	0xD1DB, { 0xE6, 0xBC, 0x80 },
	0xD1DC, { 0xE6, 0xBD, 0xA1 },
	0xD1DD, { 0xE6, 0xBD, 0xAB },
	0xD1DE, { 0xE6, 0xBD, 0xBD },
	0xD1DF, { 0xE6, 0xBD, 0xA7 },
	0xD1E0, { 0xE6, 0xBE, 0x90 },
	0xD1E1, { 0xE6, 0xBD, 0x93 },
	0xD1E2, { 0xE6, 0xBE, 0x8B },
	0xD1E3, { 0xE6, 0xBD, 0xA9 },
	0xD1E4, { 0xE6, 0xBD, 0xBF },
	0xD1E5, { 0xE6, 0xBE, 0x95 },
	0xD1E6, { 0xE6, 0xBD, 0xA3 },
	0xD1E7, { 0xE6, 0xBD, 0xB7 },
	0xD1E8, { 0xE6, 0xBD, 0xAA },
	0xD1E9, { 0xE6, 0xBD, 0xBB },
	0xD1EA, { 0xE7, 0x86, 0xB2 },
	0xD1EB, { 0xE7, 0x86, 0xAF },
	0xD1EC, { 0xE7, 0x86, 0x9B },
	0xD1ED, { 0xE7, 0x86, 0xB0 },
	0xD1EE, { 0xE7, 0x86, 0xA0 },
	0xD1EF, { 0xE7, 0x86, 0x9A },
	0xD1F0, { 0xE7, 0x86, 0xA9 },
	0xD1F1, { 0xE7, 0x86, 0xB5 },
	0xD1F2, { 0xE7, 0x86, 0x9D },
	0xD1F3, { 0xE7, 0x86, 0xA5 },
	0xD1F4, { 0xE7, 0x86, 0x9E },
	0xD1F5, { 0xE7, 0x86, 0xA4 },
	0xD1F6, { 0xE7, 0x86, 0xA1 },
	0xD1F7, { 0xE7, 0x86, 0xAA },
	0xD1F8, { 0xE7, 0x86, 0x9C },
	0xD1F9, { 0xE7, 0x86, 0xA7 },
	0xD1FA, { 0xE7, 0x86, 0xB3 },
	0xD1FB, { 0xE7, 0x8A, 0x98 },
	0xD1FC, { 0xE7, 0x8A, 0x9A },
	0xD1FD, { 0xE7, 0x8D, 0x98 },
	0xD1FE, { 0xE7, 0x8D, 0x92 },
	0xD2A1, { 0xE7, 0x8D, 0x9E },
	0xD2A2, { 0xE7, 0x8D, 0x9F },
	0xD2A3, { 0xE7, 0x8D, 0xA0 },
	0xD2A4, { 0xE7, 0x8D, 0x9D },
	0xD2A5, { 0xE7, 0x8D, 0x9B },
	0xD2A6, { 0xE7, 0x8D, 0xA1 },
	0xD2A7, { 0xE7, 0x8D, 0x9A },
	0xD2A8, { 0xE7, 0x8D, 0x99 },
	0xD2A9, { 0xE7, 0x8D, 0xA2 },
	0xD2AA, { 0xE7, 0x92, 0x87 },
	0xD2AB, { 0xE7, 0x92, 0x89 },
	0xD2AC, { 0xE7, 0x92, 0x8A },
	0xD2AD, { 0xE7, 0x92, 0x86 },
	0xD2AE, { 0xE7, 0x92, 0x81 },
	0xD2AF, { 0xE7, 0x91, 0xBD },
	0xD2B0, { 0xE7, 0x92, 0x85 },
	0xD2B1, { 0xE7, 0x92, 0x88 },
	0xD2B2, { 0xE7, 0x91, 0xBC },
	0xD2B3, { 0xE7, 0x91, 0xB9 },
	0xD2B4, { 0xE7, 0x94, 0x88 },
	0xD2B5, { 0xE7, 0x94, 0x87 },
	0xD2B6, { 0xE7, 0x95, 0xBE },
	0xD2B7, { 0xE7, 0x98, 0xA5 },
	0xD2B8, { 0xE7, 0x98, 0x9E },
	0xD2B9, { 0xE7, 0x98, 0x99 },
	0xD2BA, { 0xE7, 0x98, 0x9D },
	0xD2BB, { 0xE7, 0x98, 0x9C },
	0xD2BC, { 0xE7, 0x98, 0xA3 },
	0xD2BD, { 0xE7, 0x98, 0x9A },
	0xD2BE, { 0xE7, 0x98, 0xA8 },
	0xD2BF, { 0xE7, 0x98, 0x9B },
	0xD2C0, { 0xE7, 0x9A, 0x9C },
	0xD2C1, { 0xE7, 0x9A, 0x9D },
	0xD2C2, { 0xE7, 0x9A, 0x9E },
	0xD2C3, { 0xE7, 0x9A, 0x9B },
	0xD2C4, { 0xE7, 0x9E, 0x8D },
	0xD2C5, { 0xE7, 0x9E, 0x8F },
	0xD2C6, { 0xE7, 0x9E, 0x89 },
	0xD2C7, { 0xE7, 0x9E, 0x88 },
	0xD2C8, { 0xE7, 0xA3, 0x8D },
	0xD2C9, { 0xE7, 0xA2, 0xBB },
	0xD2CA, { 0xE7, 0xA3, 0x8F },
	0xD2CB, { 0xE7, 0xA3, 0x8C },
	0xD2CC, { 0xE7, 0xA3, 0x91 },
	0xD2CD, { 0xE7, 0xA3, 0x8E },
	0xD2CE, { 0xE7, 0xA3, 0x94 },
	0xD2CF, { 0xE7, 0xA3, 0x88 },
	0xD2D0, { 0xE7, 0xA3, 0x83 },
	0xD2D1, { 0xE7, 0xA3, 0x84 },
	0xD2D2, { 0xE7, 0xA3, 0x89 },
	0xD2D3, { 0xE7, 0xA6, 0x9A },
	0xD2D4, { 0xE7, 0xA6, 0xA1 },
	0xD2D5, { 0xE7, 0xA6, 0xA0 },
	0xD2D6, { 0xE7, 0xA6, 0x9C },
	0xD2D7, { 0xE7, 0xA6, 0xA2 },
	0xD2D8, { 0xE7, 0xA6, 0x9B },
	0xD2D9, { 0xE6, 0xAD, 0xB6 },
	0xD2DA, { 0xE7, 0xA8, 0xB9 },
	0xD2DB, { 0xE7, 0xAA, 0xB2 },
	0xD2DC, { 0xE7, 0xAA, 0xB4 },
	0xD2DD, { 0xE7, 0xAA, 0xB3 },
	0xD2DE, { 0xE7, 0xAE, 0xB7 },
	0xD2DF, { 0xE7, 0xAF, 0x8B },
	0xD2E0, { 0xE7, 0xAE, 0xBE },
	0xD2E1, { 0xE7, 0xAE, 0xAC },
	0xD2E2, { 0xE7, 0xAF, 0x8E },
	0xD2E3, { 0xE7, 0xAE, 0xAF },
	0xD2E4, { 0xE7, 0xAE, 0xB9 },
	0xD2E5, { 0xE7, 0xAF, 0x8A },
	0xD2E6, { 0xE7, 0xAE, 0xB5 },
	0xD2E7, { 0xE7, 0xB3, 0x85 },
	0xD2E8, { 0xE7, 0xB3, 0x88 },
	0xD2E9, { 0xE7, 0xB3, 0x8C },
	0xD2EA, { 0xE7, 0xB3, 0x8B },
	0xD2EB, { 0xE7, 0xB7, 0xB7 },
	0xD2EC, { 0xE7, 0xB7, 0x9B },
	0xD2ED, { 0xE7, 0xB7, 0xAA },
	0xD2EE, { 0xE7, 0xB7, 0xA7 },
	0xD2EF, { 0xE7, 0xB7, 0x97 },
	0xD2F0, { 0xE7, 0xB7, 0xA1 },
	0xD2F1, { 0xE7, 0xB8, 0x83 },
	0xD2F2, { 0xE7, 0xB7, 0xBA },
	0xD2F3, { 0xE7, 0xB7, 0xA6 },
	0xD2F4, { 0xE7, 0xB7, 0xB6 },
	0xD2F5, { 0xE7, 0xB7, 0xB1 },
	0xD2F6, { 0xE7, 0xB7, 0xB0 },
	0xD2F7, { 0xE7, 0xB7, 0xAE },
	0xD2F8, { 0xE7, 0xB7, 0x9F },
	0xD2F9, { 0xE7, 0xBD, 0xB6 },
	0xD2FA, { 0xE7, 0xBE, 0xAC },
	0xD2FB, { 0xE7, 0xBE, 0xB0 },
	0xD2FC, { 0xE7, 0xBE, 0xAD },
	0xD2FD, { 0xE7, 0xBF, 0xAD },
	0xD2FE, { 0xE7, 0xBF, 0xAB },
	0xD3A1, { 0xE7, 0xBF, 0xAA },
	0xD3A2, { 0xE7, 0xBF, 0xAC },
	0xD3A3, { 0xE7, 0xBF, 0xA6 },
	0xD3A4, { 0xE7, 0xBF, 0xA8 },
	0xD3A5, { 0xE8, 0x81, 0xA4 },
	0xD3A6, { 0xE8, 0x81, 0xA7 },
	0xD3A7, { 0xE8, 0x86, 0xA3 },
	0xD3A8, { 0xE8, 0x86, 0x9F },
	0xD3A9, { 0xE8, 0x86, 0x9E },
	0xD3AA, { 0xE8, 0x86, 0x95 },
	0xD3AB, { 0xE8, 0x86, 0xA2 },
	0xD3AC, { 0xE8, 0x86, 0x99 },
	0xD3AD, { 0xE8, 0x86, 0x97 },
	0xD3AE, { 0xE8, 0x88, 0x96 },
	0xD3AF, { 0xE8, 0x89, 0x8F },
	0xD3B0, { 0xE8, 0x89, 0x93 },
	0xD3B1, { 0xE8, 0x89, 0x92 },
	0xD3B2, { 0xE8, 0x89, 0x90 },
	0xD3B3, { 0xE8, 0x89, 0x8E },
	0xD3B4, { 0xE8, 0x89, 0x91 },
	0xD3B5, { 0xE8, 0x94, 0xA4 },
	0xD3B6, { 0xE8, 0x94, 0xBB },
	0xD3B7, { 0xE8, 0x94, 0x8F },
	0xD3B8, { 0xE8, 0x94, 0x80 },
	0xD3B9, { 0xE8, 0x94, 0xA9 },
	0xD3BA, { 0xE8, 0x94, 0x8E },
	0xD3BB, { 0xE8, 0x94, 0x89 },
	0xD3BC, { 0xE8, 0x94, 0x8D },
	0xD3BD, { 0xE8, 0x94, 0x9F },
	0xD3BE, { 0xE8, 0x94, 0x8A },
	0xD3BF, { 0xE8, 0x94, 0xA7 },
	0xD3C0, { 0xE8, 0x94, 0x9C },
	0xD3C1, { 0xE8, 0x93, 0xBB },
	0xD3C2, { 0xE8, 0x94, 0xAB },
	0xD3C3, { 0xE8, 0x93, 0xBA },
	0xD3C4, { 0xE8, 0x94, 0x88 },
	0xD3C5, { 0xE8, 0x94, 0x8C },
	0xD3C6, { 0xE8, 0x93, 0xB4 },
	0xD3C7, { 0xE8, 0x94, 0xAA },
	0xD3C8, { 0xE8, 0x93, 0xB2 },
	0xD3C9, { 0xE8, 0x94, 0x95 },
	0xD3CA, { 0xE8, 0x93, 0xB7 },
	0xD3CB, { 0xE8, 0x93, 0xAB },
	0xD3CC, { 0xE8, 0x93, 0xB3 },
	0xD3CD, { 0xE8, 0x93, 0xBC },
	0xD3CE, { 0xE8, 0x94, 0x92 },
	0xD3CF, { 0xE8, 0x93, 0xAA },
	0xD3D0, { 0xE8, 0x93, 0xA9 },
	0xD3D1, { 0xE8, 0x94, 0x96 },
	0xD3D2, { 0xE8, 0x93, 0xBE },
	0xD3D3, { 0xE8, 0x94, 0xA8 },
	0xD3D4, { 0xE8, 0x94, 0x9D },
	0xD3D5, { 0xE8, 0x94, 0xAE },
	0xD3D6, { 0xE8, 0x94, 0x82 },
	0xD3D7, { 0xE8, 0x93, 0xBD },
	0xD3D8, { 0xE8, 0x94, 0x9E },
	0xD3D9, { 0xE8, 0x93, 0xB6 },
	0xD3DA, { 0xE8, 0x94, 0xB1 },
	0xD3DB, { 0xE8, 0x94, 0xA6 },
	0xD3DC, { 0xE8, 0x93, 0xA7 },
	0xD3DD, { 0xE8, 0x93, 0xA8 },
	0xD3DE, { 0xE8, 0x93, 0xB0 },
	0xD3DF, { 0xE8, 0x93, 0xAF },
	0xD3E0, { 0xE8, 0x93, 0xB9 },
	0xD3E1, { 0xE8, 0x94, 0x98 },
	0xD3E2, { 0xE8, 0x94, 0xA0 },
	0xD3E3, { 0xE8, 0x94, 0xB0 },
	0xD3E4, { 0xE8, 0x94, 0x8B },
	0xD3E5, { 0xE8, 0x94, 0x99 },
	0xD3E6, { 0xE8, 0x94, 0xAF },
	0xD3E7, { 0xE8, 0x99, 0xA2 },
	0xD3E8, { 0xE8, 0x9D, 0x96 },
	0xD3E9, { 0xE8, 0x9D, 0xA3 },
	0xD3EA, { 0xE8, 0x9D, 0xA4 },
	0xD3EB, { 0xE8, 0x9D, 0xB7 },
	0xD3EC, { 0xE8, 0x9F, 0xA1 },
	0xD3ED, { 0xE8, 0x9D, 0xB3 },
	0xD3EE, { 0xE8, 0x9D, 0x98 },
	0xD3EF, { 0xE8, 0x9D, 0x94 },
	0xD3F0, { 0xE8, 0x9D, 0x9B },
	0xD3F1, { 0xE8, 0x9D, 0x92 },
	0xD3F2, { 0xE8, 0x9D, 0xA1 },
	0xD3F3, { 0xE8, 0x9D, 0x9A },
	0xD3F4, { 0xE8, 0x9D, 0x91 },
	0xD3F5, { 0xE8, 0x9D, 0x9E },
	0xD3F6, { 0xE8, 0x9D, 0xAD },
	0xD3F7, { 0xE8, 0x9D, 0xAA },
	0xD3F8, { 0xE8, 0x9D, 0x90 },
	0xD3F9, { 0xE8, 0x9D, 0x8E },
	0xD3FA, { 0xE8, 0x9D, 0x9F },
	0xD3FB, { 0xE8, 0x9D, 0x9D },
	0xD3FC, { 0xE8, 0x9D, 0xAF },
	0xD3FD, { 0xE8, 0x9D, 0xAC },
	0xD3FE, { 0xE8, 0x9D, 0xBA },
	0xD4A1, { 0xE8, 0x9D, 0xAE },
	0xD4A2, { 0xE8, 0x9D, 0x9C },
	0xD4A3, { 0xE8, 0x9D, 0xA5 },
	0xD4A4, { 0xE8, 0x9D, 0x8F },
	0xD4A5, { 0xE8, 0x9D, 0xBB },
	0xD4A6, { 0xE8, 0x9D, 0xB5 },
	0xD4A7, { 0xE8, 0x9D, 0xA2 },
	0xD4A8, { 0xE8, 0x9D, 0xA7 },
	0xD4A9, { 0xE8, 0x9D, 0xA9 },
	0xD4AA, { 0xE8, 0xA1, 0x9A },
	0xD4AB, { 0xE8, 0xA4, 0x85 },
	0xD4AC, { 0xE8, 0xA4, 0x8C },
	0xD4AD, { 0xE8, 0xA4, 0x94 },
	0xD4AE, { 0xE8, 0xA4, 0x8B },
	0xD4AF, { 0xE8, 0xA4, 0x97 },
	0xD4B0, { 0xE8, 0xA4, 0x98 },
	0xD4B1, { 0xE8, 0xA4, 0x99 },
	0xD4B2, { 0xE8, 0xA4, 0x86 },
	0xD4B3, { 0xE8, 0xA4, 0x96 },
	0xD4B4, { 0xE8, 0xA4, 0x91 },
	0xD4B5, { 0xE8, 0xA4, 0x8E },
	0xD4B6, { 0xE8, 0xA4, 0x89 },
	0xD4B7, { 0xE8, 0xA6, 0xA2 },
	0xD4B8, { 0xE8, 0xA6, 0xA4 },
	0xD4B9, { 0xE8, 0xA6, 0xA3 },
	0xD4BA, { 0xE8, 0xA7, 0xAD },
	0xD4BB, { 0xE8, 0xA7, 0xB0 },
	0xD4BC, { 0xE8, 0xA7, 0xAC },
	0xD4BD, { 0xE8, 0xAB, 0x8F },
	0xD4BE, { 0xE8, 0xAB, 0x86 },
	0xD4BF, { 0xE8, 0xAA, 0xB8 },
	0xD4C0, { 0xE8, 0xAB, 0x93 },
	0xD4C1, { 0xE8, 0xAB, 0x91 },
	0xD4C2, { 0xE8, 0xAB, 0x94 },
	0xD4C3, { 0xE8, 0xAB, 0x95 },
	0xD4C4, { 0xE8, 0xAA, 0xBB },
	0xD4C5, { 0xE8, 0xAB, 0x97 },
	0xD4C6, { 0xE8, 0xAA, 0xBE },
	0xD4C7, { 0xE8, 0xAB, 0x80 },
	0xD4C8, { 0xE8, 0xAB, 0x85 },
	0xD4C9, { 0xE8, 0xAB, 0x98 },
	0xD4CA, { 0xE8, 0xAB, 0x83 },
	0xD4CB, { 0xE8, 0xAA, 0xBA },
	0xD4CC, { 0xE8, 0xAA, 0xBD },
	0xD4CD, { 0xE8, 0xAB, 0x99 },
	0xD4CE, { 0xE8, 0xB0, 0xBE },
	0xD4CF, { 0xE8, 0xB1, 0x8D },
	0xD4D0, { 0xE8, 0xB2, 0x8F },
	0xD4D1, { 0xE8, 0xB3, 0xA5 },
	0xD4D2, { 0xE8, 0xB3, 0x9F },
	0xD4D3, { 0xE8, 0xB3, 0x99 },
	0xD4D4, { 0xE8, 0xB3, 0xA8 },
	0xD4D5, { 0xE8, 0xB3, 0x9A },
	0xD4D6, { 0xE8, 0xB3, 0x9D },
	0xD4D7, { 0xE8, 0xB3, 0xA7 },
	0xD4D8, { 0xE8, 0xB6, 0xA0 },
	0xD4D9, { 0xE8, 0xB6, 0x9C },
	0xD4DA, { 0xE8, 0xB6, 0xA1 },
	0xD4DB, { 0xE8, 0xB6, 0x9B },
	0xD4DC, { 0xE8, 0xB8, 0xA0 },
	0xD4DD, { 0xE8, 0xB8, 0xA3 },
	0xD4DE, { 0xE8, 0xB8, 0xA5 },
	0xD4DF, { 0xE8, 0xB8, 0xA4 },
	0xD4E0, { 0xE8, 0xB8, 0xAE },
	0xD4E1, { 0xE8, 0xB8, 0x95 },
	0xD4E2, { 0xE8, 0xB8, 0x9B },
	0xD4E3, { 0xE8, 0xB8, 0x96 },
	0xD4E4, { 0xE8, 0xB8, 0x91 },
	0xD4E5, { 0xE8, 0xB8, 0x99 },
	0xD4E6, { 0xE8, 0xB8, 0xA6 },
	0xD4E7, { 0xE8, 0xB8, 0xA7 },
	0xD4E8, { 0xE8, 0xB8, 0x94 },
	0xD4E9, { 0xE8, 0xB8, 0x92 },
	0xD4EA, { 0xE8, 0xB8, 0x98 },
	0xD4EB, { 0xE8, 0xB8, 0x93 },
	0xD4EC, { 0xE8, 0xB8, 0x9C },
	0xD4ED, { 0xE8, 0xB8, 0x97 },
	0xD4EE, { 0xE8, 0xB8, 0x9A },
	0xD4EF, { 0xE8, 0xBC, 0xAC },
	0xD4F0, { 0xE8, 0xBC, 0xA4 },
	0xD4F1, { 0xE8, 0xBC, 0x98 },
	0xD4F2, { 0xE8, 0xBC, 0x9A },
	0xD4F3, { 0xE8, 0xBC, 0xA0 },
	0xD4F4, { 0xE8, 0xBC, 0xA3 },
	0xD4F5, { 0xE8, 0xBC, 0x96 },
	0xD4F6, { 0xE8, 0xBC, 0x97 },
	0xD4F7, { 0xE9, 0x81, 0xB3 },
	0xD4F8, { 0xE9, 0x81, 0xB0 },
	0xD4F9, { 0xE9, 0x81, 0xAF },
	0xD4FA, { 0xE9, 0x81, 0xA7 },
	0xD4FB, { 0xE9, 0x81, 0xAB },
	0xD4FC, { 0xE9, 0x84, 0xAF },
	0xD4FD, { 0xE9, 0x84, 0xAB },
	0xD4FE, { 0xE9, 0x84, 0xA9 },
	0xD5A1, { 0xE9, 0x84, 0xAA },
	0xD5A2, { 0xE9, 0x84, 0xB2 },
	0xD5A3, { 0xE9, 0x84, 0xA6 },
	0xD5A4, { 0xE9, 0x84, 0xAE },
	0xD5A5, { 0xE9, 0x86, 0x85 },
	0xD5A6, { 0xE9, 0x86, 0x86 },
	0xD5A7, { 0xE9, 0x86, 0x8A },
	0xD5A8, { 0xE9, 0x86, 0x81 },
	0xD5A9, { 0xE9, 0x86, 0x82 },
	0xD5AA, { 0xE9, 0x86, 0x84 },
	0xD5AB, { 0xE9, 0x86, 0x80 },
	0xD5AC, { 0xE9, 0x8B, 0x90 },
	0xD5AD, { 0xE9, 0x8B, 0x83 },
	0xD5AE, { 0xE9, 0x8B, 0x84 },
	0xD5AF, { 0xE9, 0x8B, 0x80 },
	0xD5B0, { 0xE9, 0x8B, 0x99 },
	0xD5B1, { 0xE9, 0x8A, 0xB6 },
	0xD5B2, { 0xE9, 0x8B, 0x8F },
	0xD5B3, { 0xE9, 0x8B, 0xB1 },
	0xD5B4, { 0xE9, 0x8B, 0x9F },
	0xD5B5, { 0xE9, 0x8B, 0x98 },
	0xD5B6, { 0xE9, 0x8B, 0xA9 },
	0xD5B7, { 0xE9, 0x8B, 0x97 },
	0xD5B8, { 0xE9, 0x8B, 0x9D },
	0xD5B9, { 0xE9, 0x8B, 0x8C },
	0xD5BA, { 0xE9, 0x8B, 0xAF },
	0xD5BB, { 0xE9, 0x8B, 0x82 },
	0xD5BC, { 0xE9, 0x8B, 0xA8 },
	0xD5BD, { 0xE9, 0x8B, 0x8A },
	0xD5BE, { 0xE9, 0x8B, 0x88 },
	0xD5BF, { 0xE9, 0x8B, 0x8E },
	0xD5C0, { 0xE9, 0x8B, 0xA6 },
	0xD5C1, { 0xE9, 0x8B, 0x8D },
	0xD5C2, { 0xE9, 0x8B, 0x95 },
	0xD5C3, { 0xE9, 0x8B, 0x89 },
	0xD5C4, { 0xE9, 0x8B, 0xA0 },
	0xD5C5, { 0xE9, 0x8B, 0x9E },
	0xD5C6, { 0xE9, 0x8B, 0xA7 },
	0xD5C7, { 0xE9, 0x8B, 0x91 },
	0xD5C8, { 0xE9, 0x8B, 0x93 },
	0xD5C9, { 0xE9, 0x8A, 0xB5 },
	0xD5CA, { 0xE9, 0x8B, 0xA1 },
	0xD5CB, { 0xE9, 0x8C, 0xA5 },
	0xD5CC, { 0xE9, 0x8B, 0x86 },
	0xD5CD, { 0xE9, 0x8A, 0xB4 },
	0xD5CE, { 0xE9, 0x95, 0xBC },
	0xD5CF, { 0xE9, 0x96, 0xAC },
	0xD5D0, { 0xE9, 0x96, 0xAB },
	0xD5D1, { 0xE9, 0x96, 0xAE },
	0xD5D2, { 0xE9, 0x96, 0xB0 },
	0xD5D3, { 0xE9, 0x9A, 0xA4 },
	0xD5D4, { 0xE9, 0x9A, 0xA2 },
	0xD5D5, { 0xE9, 0x9B, 0x93 },
	0xD5D6, { 0xE9, 0x9C, 0x85 },
	0xD5D7, { 0xE9, 0x9C, 0x88 },
	0xD5D8, { 0xE9, 0x9C, 0x82 },
	0xD5D9, { 0xE9, 0x9D, 0x9A },
	0xD5DA, { 0xE9, 0x9E, 0x8A },
	0xD5DB, { 0xE9, 0x9E, 0x8E },
	0xD5DC, { 0xE9, 0x9E, 0x88 },
	0xD5DD, { 0xE9, 0x9F, 0x90 },
	0xD5DE, { 0xE9, 0x9F, 0x8F },
	0xD5DF, { 0xE9, 0xA0, 0x9E },
	0xD5E0, { 0xE9, 0xA0, 0x9D },
	0xD5E1, { 0xE9, 0xA0, 0xA6 },
	0xD5E2, { 0xE9, 0xA0, 0xA9 },
	0xD5E3, { 0xE9, 0xA0, 0xA8 },
	0xD5E4, { 0xE9, 0xA0, 0xA0 },
	0xD5E5, { 0xE9, 0xA0, 0x9B },
	0xD5E6, { 0xE9, 0xA0, 0xA7 },
	0xD5E7, { 0xE9, 0xA2, 0xB2 },
	0xD5E8, { 0xE9, 0xA4, 0x88 },
	0xD5E9, { 0xE9, 0xA3, 0xBA },
	0xD5EA, { 0xE9, 0xA4, 0x91 },
	0xD5EB, { 0xE9, 0xA4, 0x94 },
	0xD5EC, { 0xE9, 0xA4, 0x96 },
	0xD5ED, { 0xE9, 0xA4, 0x97 },
	0xD5EE, { 0xE9, 0xA4, 0x95 },
	0xD5EF, { 0xE9, 0xA7, 0x9C },
	0xD5F0, { 0xE9, 0xA7, 0x8D },
	0xD5F1, { 0xE9, 0xA7, 0x8F },
	0xD5F2, { 0xE9, 0xA7, 0x93 },
	0xD5F3, { 0xE9, 0xA7, 0x94 },
	0xD5F4, { 0xE9, 0xA7, 0x8E },
	0xD5F5, { 0xE9, 0xA7, 0x89 },
	0xD5F6, { 0xE9, 0xA7, 0x96 },
	0xD5F7, { 0xE9, 0xA7, 0x98 },
	0xD5F8, { 0xE9, 0xA7, 0x8B },
	0xD5F9, { 0xE9, 0xA7, 0x97 },
	0xD5FA, { 0xE9, 0xA7, 0x8C },
	0xD5FB, { 0xE9, 0xAA, 0xB3 },
	0xD5FC, { 0xE9, 0xAB, 0xAC },
	0xD5FD, { 0xE9, 0xAB, 0xAB },
	0xD5FE, { 0xE9, 0xAB, 0xB3 },
	0xD6A1, { 0xE9, 0xAB, 0xB2 },
	0xD6A2, { 0xE9, 0xAB, 0xB1 },
	0xD6A3, { 0xE9, 0xAD, 0x86 },
	0xD6A4, { 0xE9, 0xAD, 0x83 },
	0xD6A5, { 0xE9, 0xAD, 0xA7 },
	0xD6A6, { 0xE9, 0xAD, 0xB4 },
	0xD6A7, { 0xE9, 0xAD, 0xB1 },
	0xD6A8, { 0xE9, 0xAD, 0xA6 },
	0xD6A9, { 0xE9, 0xAD, 0xB6 },
	0xD6AA, { 0xE9, 0xAD, 0xB5 },
	0xD6AB, { 0xE9, 0xAD, 0xB0 },
	0xD6AC, { 0xE9, 0xAD, 0xA8 },
	0xD6AD, { 0xE9, 0xAD, 0xA4 },
	0xD6AE, { 0xE9, 0xAD, 0xAC },
	0xD6AF, { 0xE9, 0xB3, 0xBC },
	0xD6B0, { 0xE9, 0xB3, 0xBA },
	0xD6B1, { 0xE9, 0xB3, 0xBD },
	0xD6B2, { 0xE9, 0xB3, 0xBF },
	0xD6B3, { 0xE9, 0xB3, 0xB7 },
	0xD6B4, { 0xE9, 0xB4, 0x87 },
	0xD6B5, { 0xE9, 0xB4, 0x80 },
	0xD6B6, { 0xE9, 0xB3, 0xB9 },
	0xD6B7, { 0xE9, 0xB3, 0xBB },
	0xD6B8, { 0xE9, 0xB4, 0x88 },
	0xD6B9, { 0xE9, 0xB4, 0x85 },
	0xD6BA, { 0xE9, 0xB4, 0x84 },
	0xD6BB, { 0xE9, 0xBA, 0x83 },
	0xD6BC, { 0xE9, 0xBB, 0x93 },
	0xD6BD, { 0xE9, 0xBC, 0x8F },
	0xD6BE, { 0xE9, 0xBC, 0x90 },
	0xD6BF, { 0xE5, 0x84, 0x9C },
	0xD6C0, { 0xE5, 0x84, 0x93 },
	0xD6C1, { 0xE5, 0x84, 0x97 },
	0xD6C2, { 0xE5, 0x84, 0x9A },
	0xD6C3, { 0xE5, 0x84, 0x91 },
	0xD6C4, { 0xE5, 0x87, 0x9E },
	0xD6C5, { 0xE5, 0x8C, 0xB4 },
	0xD6C6, { 0xE5, 0x8F, 0xA1 },
	0xD6C7, { 0xE5, 0x99, 0xB0 },
	0xD6C8, { 0xE5, 0x99, 0xA0 },
	0xD6C9, { 0xE5, 0x99, 0xAE },
	0xD6CA, { 0xE5, 0x99, 0xB3 },
	0xD6CB, { 0xE5, 0x99, 0xA6 },
	0xD6CC, { 0xE5, 0x99, 0xA3 },
	0xD6CD, { 0xE5, 0x99, 0xAD },
	0xD6CE, { 0xE5, 0x99, 0xB2 },
	0xD6CF, { 0xE5, 0x99, 0x9E },
	0xD6D0, { 0xE5, 0x99, 0xB7 },
	0xD6D1, { 0xE5, 0x9C, 0x9C },
	0xD6D2, { 0xE5, 0x9C, 0x9B },
	0xD6D3, { 0xE5, 0xA3, 0x88 },
	0xD6D4, { 0xE5, 0xA2, 0xBD },
	0xD6D5, { 0xE5, 0xA3, 0x89 },
	0xD6D6, { 0xE5, 0xA2, 0xBF },
	0xD6D7, { 0xE5, 0xA2, 0xBA },
	0xD6D8, { 0xE5, 0xA3, 0x82 },
	0xD6D9, { 0xE5, 0xA2, 0xBC },
	0xD6DA, { 0xE5, 0xA3, 0x86 },
	0xD6DB, { 0xE5, 0xAC, 0x97 },
	0xD6DC, { 0xE5, 0xAC, 0x99 },
	0xD6DD, { 0xE5, 0xAC, 0x9B },
	0xD6DE, { 0xE5, 0xAC, 0xA1 },
	0xD6DF, { 0xE5, 0xAC, 0x94 },
	0xD6E0, { 0xE5, 0xAC, 0x93 },
	0xD6E1, { 0xE5, 0xAC, 0x90 },
	0xD6E2, { 0xE5, 0xAC, 0x96 },
	0xD6E3, { 0xE5, 0xAC, 0xA8 },
	0xD6E4, { 0xE5, 0xAC, 0x9A },
	0xD6E5, { 0xE5, 0xAC, 0xA0 },
	0xD6E6, { 0xE5, 0xAC, 0x9E },
	0xD6E7, { 0xE5, 0xAF, 0xAF },
	0xD6E8, { 0xE5, 0xB6, 0xAC },
	0xD6E9, { 0xE5, 0xB6, 0xB1 },
	0xD6EA, { 0xE5, 0xB6, 0xA9 },
	0xD6EB, { 0xE5, 0xB6, 0xA7 },
	0xD6EC, { 0xE5, 0xB6, 0xB5 },
	0xD6ED, { 0xE5, 0xB6, 0xB0 },
	0xD6EE, { 0xE5, 0xB6, 0xAE },
	0xD6EF, { 0xE5, 0xB6, 0xAA },
	0xD6F0, { 0xE5, 0xB6, 0xA8 },
	0xD6F1, { 0xE5, 0xB6, 0xB2 },
	0xD6F2, { 0xE5, 0xB6, 0xAD },
	0xD6F3, { 0xE5, 0xB6, 0xAF },
	0xD6F4, { 0xE5, 0xB6, 0xB4 },
	0xD6F5, { 0xE5, 0xB9, 0xA7 },
	0xD6F6, { 0xE5, 0xB9, 0xA8 },
	0xD6F7, { 0xE5, 0xB9, 0xA6 },
	0xD6F8, { 0xE5, 0xB9, 0xAF },
	0xD6F9, { 0xE5, 0xBB, 0xA9 },
	0xD6FA, { 0xE5, 0xBB, 0xA7 },
	0xD6FB, { 0xE5, 0xBB, 0xA6 },
	0xD6FC, { 0xE5, 0xBB, 0xA8 },
	0xD6FD, { 0xE5, 0xBB, 0xA5 },
	0xD6FE, { 0xE5, 0xBD, 0x8B },
	0xD7A1, { 0xE5, 0xBE, 0xBC },
	0xD7A2, { 0xE5, 0xBE, 0xBB },
	0xD7A3, { 0xE6, 0x86, 0x9D },
	0xD7A4, { 0xE6, 0x86, 0xA8 },
	0xD7A5, { 0xE6, 0x86, 0x96 },
	0xD7A6, { 0xE6, 0x87, 0x85 },
	0xD7A7, { 0xE6, 0x86, 0xB4 },
	0xD7A8, { 0xE6, 0x87, 0x86 },
	0xD7A9, { 0xE6, 0x87, 0x81 },
	0xD7AA, { 0xE6, 0x87, 0x8C },
	0xD7AB, { 0xE6, 0x86, 0xBA },
	0xD7AC, { 0xE6, 0x86, 0xBF },
	0xD7AD, { 0xE6, 0x86, 0xB8 },
	0xD7AE, { 0xE6, 0x86, 0x8C },
	0xD7AF, { 0xE6, 0x93, 0x97 },
	0xD7B0, { 0xE6, 0x93, 0x96 },
	0xD7B1, { 0xE6, 0x93, 0x90 },
	0xD7B2, { 0xE6, 0x93, 0x8F },
	0xD7B3, { 0xE6, 0x93, 0x89 },
	0xD7B4, { 0xE6, 0x92, 0xBD },
	0xD7B5, { 0xE6, 0x92, 0x89 },
	0xD7B6, { 0xE6, 0x93, 0x83 },
	0xD7B7, { 0xE6, 0x93, 0x9B },
	0xD7B8, { 0xE6, 0x93, 0xB3 },
	0xD7B9, { 0xE6, 0x93, 0x99 },
	0xD7BA, { 0xE6, 0x94, 0xB3 },
	0xD7BB, { 0xE6, 0x95, 0xBF },
	0xD7BC, { 0xE6, 0x95, 0xBC },
	0xD7BD, { 0xE6, 0x96, 0xA2 },
	0xD7BE, { 0xE6, 0x9B, 0x88 },
	0xD7BF, { 0xE6, 0x9A, 0xBE },
	0xD7C0, { 0xE6, 0x9B, 0x80 },
	0xD7C1, { 0xE6, 0x9B, 0x8A },
	0xD7C2, { 0xE6, 0x9B, 0x8B },
	0xD7C3, { 0xE6, 0x9B, 0x8F },
	0xD7C4, { 0xE6, 0x9A, 0xBD },
	0xD7C5, { 0xE6, 0x9A, 0xBB },
	0xD7C6, { 0xE6, 0x9A, 0xBA },
	0xD7C7, { 0xE6, 0x9B, 0x8C },
	0xD7C8, { 0xE6, 0x9C, 0xA3 },
	0xD7C9, { 0xE6, 0xA8, 0xB4 },
	0xD7CA, { 0xE6, 0xA9, 0xA6 },
	0xD7CB, { 0xE6, 0xA9, 0x89 },
	0xD7CC, { 0xE6, 0xA9, 0xA7 },
	0xD7CD, { 0xE6, 0xA8, 0xB2 },
	0xD7CE, { 0xE6, 0xA9, 0xA8 },
	0xD7CF, { 0xE6, 0xA8, 0xBE },
	0xD7D0, { 0xE6, 0xA9, 0x9D },
	0xD7D1, { 0xE6, 0xA9, 0xAD },
	0xD7D2, { 0xE6, 0xA9, 0xB6 },
	0xD7D3, { 0xE6, 0xA9, 0x9B },
	0xD7D4, { 0xE6, 0xA9, 0x91 },
	0xD7D5, { 0xE6, 0xA8, 0xA8 },
	0xD7D6, { 0xE6, 0xA9, 0x9A },
	0xD7D7, { 0xE6, 0xA8, 0xBB },
	0xD7D8, { 0xE6, 0xA8, 0xBF },
	0xD7D9, { 0xE6, 0xA9, 0x81 },
	0xD7DA, { 0xE6, 0xA9, 0xAA },
	0xD7DB, { 0xE6, 0xA9, 0xA4 },
	0xD7DC, { 0xE6, 0xA9, 0x90 },
	0xD7DD, { 0xE6, 0xA9, 0x8F },
	0xD7DE, { 0xE6, 0xA9, 0x94 },
	0xD7DF, { 0xE6, 0xA9, 0xAF },
	0xD7E0, { 0xE6, 0xA9, 0xA9 },
	0xD7E1, { 0xE6, 0xA9, 0xA0 },
	0xD7E2, { 0xE6, 0xA8, 0xBC },
	0xD7E3, { 0xE6, 0xA9, 0x9E },
	0xD7E4, { 0xE6, 0xA9, 0x96 },
	0xD7E5, { 0xE6, 0xA9, 0x95 },
	0xD7E6, { 0xE6, 0xA9, 0x8D },
	0xD7E7, { 0xE6, 0xA9, 0x8E },
	0xD7E8, { 0xE6, 0xA9, 0x86 },
	0xD7E9, { 0xE6, 0xAD, 0x95 },
	0xD7EA, { 0xE6, 0xAD, 0x94 },
	0xD7EB, { 0xE6, 0xAD, 0x96 },
	0xD7EC, { 0xE6, 0xAE, 0xA7 },
	0xD7ED, { 0xE6, 0xAE, 0xAA },
	0xD7EE, { 0xE6, 0xAE, 0xAB },
	0xD7EF, { 0xE6, 0xAF, 0x88 },
	0xD7F0, { 0xE6, 0xAF, 0x87 },
	0xD7F1, { 0xE6, 0xB0, 0x84 },
	0xD7F2, { 0xE6, 0xB0, 0x83 },
	0xD7F3, { 0xE6, 0xB0, 0x86 },
	0xD7F4, { 0xE6, 0xBE, 0xAD },
	0xD7F5, { 0xE6, 0xBF, 0x8B },
	0xD7F6, { 0xE6, 0xBE, 0xA3 },
	0xD7F7, { 0xE6, 0xBF, 0x87 },
	0xD7F8, { 0xE6, 0xBE, 0xBC },
	0xD7F9, { 0xE6, 0xBF, 0x8E },
	0xD7FA, { 0xE6, 0xBF, 0x88 },
	0xD7FB, { 0xE6, 0xBD, 0x9E },
	0xD7FC, { 0xE6, 0xBF, 0x84 },
	0xD7FD, { 0xE6, 0xBE, 0xBD },
	0xD7FE, { 0xE6, 0xBE, 0x9E },
	0xD8A1, { 0xE6, 0xBF, 0x8A },
	0xD8A2, { 0xE6, 0xBE, 0xA8 },
	0xD8A3, { 0xE7, 0x80, 0x84 },
	0xD8A4, { 0xE6, 0xBE, 0xA5 },
	0xD8A5, { 0xE6, 0xBE, 0xAE },
	0xD8A6, { 0xE6, 0xBE, 0xBA },
	0xD8A7, { 0xE6, 0xBE, 0xAC },
	0xD8A8, { 0xE6, 0xBE, 0xAA },
	0xD8A9, { 0xE6, 0xBF, 0x8F },
	0xD8AA, { 0xE6, 0xBE, 0xBF },
	0xD8AB, { 0xE6, 0xBE, 0xB8 },
	0xD8AC, { 0xE6, 0xBE, 0xA2 },
	0xD8AD, { 0xE6, 0xBF, 0x89 },
	0xD8AE, { 0xE6, 0xBE, 0xAB },
	0xD8AF, { 0xE6, 0xBF, 0x8D },
	0xD8B0, { 0xE6, 0xBE, 0xAF },
	0xD8B1, { 0xE6, 0xBE, 0xB2 },
	0xD8B2, { 0xE6, 0xBE, 0xB0 },
	0xD8B3, { 0xE7, 0x87, 0x85 },
	0xD8B4, { 0xE7, 0x87, 0x82 },
	0xD8B5, { 0xE7, 0x86, 0xBF },
	0xD8B6, { 0xE7, 0x86, 0xB8 },
	0xD8B7, { 0xE7, 0x87, 0x96 },
	0xD8B8, { 0xE7, 0x87, 0x80 },
	0xD8B9, { 0xE7, 0x87, 0x81 },
	0xD8BA, { 0xE7, 0x87, 0x8B },
	0xD8BB, { 0xE7, 0x87, 0x94 },
	0xD8BC, { 0xE7, 0x87, 0x8A },
	0xD8BD, { 0xE7, 0x87, 0x87 },
	0xD8BE, { 0xE7, 0x87, 0x8F },
	0xD8BF, { 0xE7, 0x86, 0xBD },
	0xD8C0, { 0xE7, 0x87, 0x98 },
	0xD8C1, { 0xE7, 0x86, 0xBC },
	0xD8C2, { 0xE7, 0x87, 0x86 },
	0xD8C3, { 0xE7, 0x87, 0x9A },
	0xD8C4, { 0xE7, 0x87, 0x9B },
	0xD8C5, { 0xE7, 0x8A, 0x9D },
	0xD8C6, { 0xE7, 0x8A, 0x9E },
	0xD8C7, { 0xE7, 0x8D, 0xA9 },
	0xD8C8, { 0xE7, 0x8D, 0xA6 },
	0xD8C9, { 0xE7, 0x8D, 0xA7 },
	0xD8CA, { 0xE7, 0x8D, 0xAC },
	0xD8CB, { 0xE7, 0x8D, 0xA5 },
	0xD8CC, { 0xE7, 0x8D, 0xAB },
	0xD8CD, { 0xE7, 0x8D, 0xAA },
	0xD8CE, { 0xE7, 0x91, 0xBF },
	0xD8CF, { 0xE7, 0x92, 0x9A },
	0xD8D0, { 0xE7, 0x92, 0xA0 },
	0xD8D1, { 0xE7, 0x92, 0x94 },
	0xD8D2, { 0xE7, 0x92, 0x92 },
	0xD8D3, { 0xE7, 0x92, 0x95 },
	0xD8D4, { 0xE7, 0x92, 0xA1 },
	0xD8D5, { 0xE7, 0x94, 0x8B },
	0xD8D6, { 0xE7, 0x96, 0x80 },
	0xD8D7, { 0xE7, 0x98, 0xAF },
	0xD8D8, { 0xE7, 0x98, 0xAD },
	0xD8D9, { 0xE7, 0x98, 0xB1 },
	0xD8DA, { 0xE7, 0x98, 0xBD },
	0xD8DB, { 0xE7, 0x98, 0xB3 },
	0xD8DC, { 0xE7, 0x98, 0xBC },
	0xD8DD, { 0xE7, 0x98, 0xB5 },
	0xD8DE, { 0xE7, 0x98, 0xB2 },
	0xD8DF, { 0xE7, 0x98, 0xB0 },
	0xD8E0, { 0xE7, 0x9A, 0xBB },
	0xD8E1, { 0xE7, 0x9B, 0xA6 },
	0xD8E2, { 0xE7, 0x9E, 0x9A },
	0xD8E3, { 0xE7, 0x9E, 0x9D },
	0xD8E4, { 0xE7, 0x9E, 0xA1 },
	0xD8E5, { 0xE7, 0x9E, 0x9C },
	0xD8E6, { 0xE7, 0x9E, 0x9B },
	0xD8E7, { 0xE7, 0x9E, 0xA2 },
	0xD8E8, { 0xE7, 0x9E, 0xA3 },
	0xD8E9, { 0xE7, 0x9E, 0x95 },
	0xD8EA, { 0xE7, 0x9E, 0x99 },
	0xD8EB, { 0xE7, 0x9E, 0x97 },
	0xD8EC, { 0xE7, 0xA3, 0x9D },
	0xD8ED, { 0xE7, 0xA3, 0xA9 },
	0xD8EE, { 0xE7, 0xA3, 0xA5 },
	0xD8EF, { 0xE7, 0xA3, 0xAA },
	0xD8F0, { 0xE7, 0xA3, 0x9E },
	0xD8F1, { 0xE7, 0xA3, 0xA3 },
	0xD8F2, { 0xE7, 0xA3, 0x9B },
	0xD8F3, { 0xE7, 0xA3, 0xA1 },
	0xD8F4, { 0xE7, 0xA3, 0xA2 },
	0xD8F5, { 0xE7, 0xA3, 0xAD },
	0xD8F6, { 0xE7, 0xA3, 0x9F },
	0xD8F7, { 0xE7, 0xA3, 0xA0 },
	0xD8F8, { 0xE7, 0xA6, 0xA4 },
	0xD8F9, { 0xE7, 0xA9, 0x84 },
	0xD8FA, { 0xE7, 0xA9, 0x88 },
	0xD8FB, { 0xE7, 0xA9, 0x87 },
	0xD8FC, { 0xE7, 0xAA, 0xB6 },
	0xD8FD, { 0xE7, 0xAA, 0xB8 },
	0xD8FE, { 0xE7, 0xAA, 0xB5 },
	0xD9A1, { 0xE7, 0xAA, 0xB1 },
	0xD9A2, { 0xE7, 0xAA, 0xB7 },
	0xD9A3, { 0xE7, 0xAF, 0x9E },
	0xD9A4, { 0xE7, 0xAF, 0xA3 },
	0xD9A5, { 0xE7, 0xAF, 0xA7 },
	0xD9A6, { 0xE7, 0xAF, 0x9D },
	0xD9A7, { 0xE7, 0xAF, 0x95 },
	0xD9A8, { 0xE7, 0xAF, 0xA5 },
	0xD9A9, { 0xE7, 0xAF, 0x9A },
	0xD9AA, { 0xE7, 0xAF, 0xA8 },
	0xD9AB, { 0xE7, 0xAF, 0xB9 },
	0xD9AC, { 0xE7, 0xAF, 0x94 },
	0xD9AD, { 0xE7, 0xAF, 0xAA },
	0xD9AE, { 0xE7, 0xAF, 0xA2 },
	0xD9AF, { 0xE7, 0xAF, 0x9C },
	0xD9B0, { 0xE7, 0xAF, 0xAB },
	0xD9B1, { 0xE7, 0xAF, 0x98 },
	0xD9B2, { 0xE7, 0xAF, 0x9F },
	0xD9B3, { 0xE7, 0xB3, 0x92 },
	0xD9B4, { 0xE7, 0xB3, 0x94 },
	0xD9B5, { 0xE7, 0xB3, 0x97 },
	0xD9B6, { 0xE7, 0xB3, 0x90 },
	0xD9B7, { 0xE7, 0xB3, 0x91 },
	0xD9B8, { 0xE7, 0xB8, 0x92 },
	0xD9B9, { 0xE7, 0xB8, 0xA1 },
	0xD9BA, { 0xE7, 0xB8, 0x97 },
	0xD9BB, { 0xE7, 0xB8, 0x8C },
	0xD9BC, { 0xE7, 0xB8, 0x9F },
	0xD9BD, { 0xE7, 0xB8, 0xA0 },
	0xD9BE, { 0xE7, 0xB8, 0x93 },
	0xD9BF, { 0xE7, 0xB8, 0x8E },
	0xD9C0, { 0xE7, 0xB8, 0x9C },
	0xD9C1, { 0xE7, 0xB8, 0x95 },
	0xD9C2, { 0xE7, 0xB8, 0x9A },
	0xD9C3, { 0xE7, 0xB8, 0xA2 },
	0xD9C4, { 0xE7, 0xB8, 0x8B },
	0xD9C5, { 0xE7, 0xB8, 0x8F },
	0xD9C6, { 0xE7, 0xB8, 0x96 },
	0xD9C7, { 0xE7, 0xB8, 0x8D },
	0xD9C8, { 0xE7, 0xB8, 0x94 },
	0xD9C9, { 0xE7, 0xB8, 0xA5 },
	0xD9CA, { 0xE7, 0xB8, 0xA4 },
	0xD9CB, { 0xE7, 0xBD, 0x83 },
	0xD9CC, { 0xE7, 0xBD, 0xBB },
	0xD9CD, { 0xE7, 0xBD, 0xBC },
	0xD9CE, { 0xE7, 0xBD, 0xBA },
	0xD9CF, { 0xE7, 0xBE, 0xB1 },
	0xD9D0, { 0xE7, 0xBF, 0xAF },
	0xD9D1, { 0xE8, 0x80, 0xAA },
	0xD9D2, { 0xE8, 0x80, 0xA9 },
	0xD9D3, { 0xE8, 0x81, 0xAC },
	0xD9D4, { 0xE8, 0x86, 0xB1 },
	0xD9D5, { 0xE8, 0x86, 0xA6 },
	0xD9D6, { 0xE8, 0x86, 0xAE },
	0xD9D7, { 0xE8, 0x86, 0xB9 },
	0xD9D8, { 0xE8, 0x86, 0xB5 },
	0xD9D9, { 0xE8, 0x86, 0xAB },
	0xD9DA, { 0xE8, 0x86, 0xB0 },
	0xD9DB, { 0xE8, 0x86, 0xAC },
	0xD9DC, { 0xE8, 0x86, 0xB4 },
	0xD9DD, { 0xE8, 0x86, 0xB2 },
	0xD9DE, { 0xE8, 0x86, 0xB7 },
	0xD9DF, { 0xE8, 0x86, 0xA7 },
	0xD9E0, { 0xE8, 0x87, 0xB2 },
	0xD9E1, { 0xE8, 0x89, 0x95 },
	0xD9E2, { 0xE8, 0x89, 0x96 },
	0xD9E3, { 0xE8, 0x89, 0x97 },
	0xD9E4, { 0xE8, 0x95, 0x96 },
	0xD9E5, { 0xE8, 0x95, 0x85 },
	0xD9E6, { 0xE8, 0x95, 0xAB },
	0xD9E7, { 0xE8, 0x95, 0x8D },
	0xD9E8, { 0xE8, 0x95, 0x93 },
	0xD9E9, { 0xE8, 0x95, 0xA1 },
	0xD9EA, { 0xE8, 0x95, 0x98 },
	0xD9EB, { 0xE8, 0x95, 0x80 },
	0xD9EC, { 0xE8, 0x95, 0x86 },
	0xD9ED, { 0xE8, 0x95, 0xA4 },
	0xD9EE, { 0xE8, 0x95, 0x81 },
	0xD9EF, { 0xE8, 0x95, 0xA2 },
	0xD9F0, { 0xE8, 0x95, 0x84 },
	0xD9F1, { 0xE8, 0x95, 0x91 },
	0xD9F2, { 0xE8, 0x95, 0x87 },
	0xD9F3, { 0xE8, 0x95, 0xA3 },
	0xD9F4, { 0xE8, 0x94, 0xBE },
	0xD9F5, { 0xE8, 0x95, 0x9B },
	0xD9F6, { 0xE8, 0x95, 0xB1 },
	0xD9F7, { 0xE8, 0x95, 0x8E },
	0xD9F8, { 0xE8, 0x95, 0xAE },
	0xD9F9, { 0xE8, 0x95, 0xB5 },
	0xD9FA, { 0xE8, 0x95, 0x95 },
	0xD9FB, { 0xE8, 0x95, 0xA7 },
	0xD9FC, { 0xE8, 0x95, 0xA0 },
	0xD9FD, { 0xE8, 0x96, 0x8C },
	0xD9FE, { 0xE8, 0x95, 0xA6 },
	0xDAA1, { 0xE8, 0x95, 0x9D },
	0xDAA2, { 0xE8, 0x95, 0x94 },
	0xDAA3, { 0xE8, 0x95, 0xA5 },
	0xDAA4, { 0xE8, 0x95, 0xAC },
	0xDAA5, { 0xE8, 0x99, 0xA3 },
	0xDAA6, { 0xE8, 0x99, 0xA5 },
	0xDAA7, { 0xE8, 0x99, 0xA4 },
	0xDAA8, { 0xE8, 0x9E, 0xA4 },
	0xDAA9, { 0xE8, 0x9E, 0x9B },
	0xDAAA, { 0xE8, 0x9E, 0x8F },
	0xDAAB, { 0xE8, 0x9E, 0x97 },
	0xDAAC, { 0xE8, 0x9E, 0x93 },
	0xDAAD, { 0xE8, 0x9E, 0x92 },
	0xDAAE, { 0xE8, 0x9E, 0x88 },
	0xDAAF, { 0xE8, 0x9E, 0x81 },
	0xDAB0, { 0xE8, 0x9E, 0x96 },
	0xDAB1, { 0xE8, 0x9E, 0x98 },
	0xDAB2, { 0xE8, 0x9D, 0xB9 },
	0xDAB3, { 0xE8, 0x9E, 0x87 },
	0xDAB4, { 0xE8, 0x9E, 0xA3 },
	0xDAB5, { 0xE8, 0x9E, 0x85 },
	0xDAB6, { 0xE8, 0x9E, 0x90 },
	0xDAB7, { 0xE8, 0x9E, 0x91 },
	0xDAB8, { 0xE8, 0x9E, 0x9D },
	0xDAB9, { 0xE8, 0x9E, 0x84 },
	0xDABA, { 0xE8, 0x9E, 0x94 },
	0xDABB, { 0xE8, 0x9E, 0x9C },
	0xDABC, { 0xE8, 0x9E, 0x9A },
	0xDABD, { 0xE8, 0x9E, 0x89 },
	0xDABE, { 0xE8, 0xA4, 0x9E },
	0xDABF, { 0xE8, 0xA4, 0xA6 },
	0xDAC0, { 0xE8, 0xA4, 0xB0 },
	0xDAC1, { 0xE8, 0xA4, 0xAD },
	0xDAC2, { 0xE8, 0xA4, 0xAE },
	0xDAC3, { 0xE8, 0xA4, 0xA7 },
	0xDAC4, { 0xE8, 0xA4, 0xB1 },
	0xDAC5, { 0xE8, 0xA4, 0xA2 },
	0xDAC6, { 0xE8, 0xA4, 0xA9 },
	0xDAC7, { 0xE8, 0xA4, 0xA3 },
	0xDAC8, { 0xE8, 0xA4, 0xAF },
	0xDAC9, { 0xE8, 0xA4, 0xAC },
	0xDACA, { 0xE8, 0xA4, 0x9F },
	0xDACB, { 0xE8, 0xA7, 0xB1 },
	0xDACC, { 0xE8, 0xAB, 0xA0 },
	0xDACD, { 0xE8, 0xAB, 0xA2 },
	0xDACE, { 0xE8, 0xAB, 0xB2 },
	0xDACF, { 0xE8, 0xAB, 0xB4 },
	0xDAD0, { 0xE8, 0xAB, 0xB5 },
	0xDAD1, { 0xE8, 0xAB, 0x9D },
	0xDAD2, { 0xE8, 0xAC, 0x94 },
	0xDAD3, { 0xE8, 0xAB, 0xA4 },
	0xDAD4, { 0xE8, 0xAB, 0x9F },
	0xDAD5, { 0xE8, 0xAB, 0xB0 },
	0xDAD6, { 0xE8, 0xAB, 0x88 },
	0xDAD7, { 0xE8, 0xAB, 0x9E },
	0xDAD8, { 0xE8, 0xAB, 0xA1 },
	0xDAD9, { 0xE8, 0xAB, 0xA8 },
	0xDADA, { 0xE8, 0xAB, 0xBF },
	0xDADB, { 0xE8, 0xAB, 0xAF },
	0xDADC, { 0xE8, 0xAB, 0xBB },
	0xDADD, { 0xE8, 0xB2, 0x91 },
	0xDADE, { 0xE8, 0xB2, 0x92 },
	0xDADF, { 0xE8, 0xB2, 0x90 },
	0xDAE0, { 0xE8, 0xB3, 0xB5 },
	0xDAE1, { 0xE8, 0xB3, 0xAE },
	0xDAE2, { 0xE8, 0xB3, 0xB1 },
	0xDAE3, { 0xE8, 0xB3, 0xB0 },
	0xDAE4, { 0xE8, 0xB3, 0xB3 },
	0xDAE5, { 0xE8, 0xB5, 0xAC },
	0xDAE6, { 0xE8, 0xB5, 0xAE },
	0xDAE7, { 0xE8, 0xB6, 0xA5 },
	0xDAE8, { 0xE8, 0xB6, 0xA7 },
	0xDAE9, { 0xE8, 0xB8, 0xB3 },
	0xDAEA, { 0xE8, 0xB8, 0xBE },
	0xDAEB, { 0xE8, 0xB8, 0xB8 },
	0xDAEC, { 0xE8, 0xB9, 0x80 },
	0xDAED, { 0xE8, 0xB9, 0x85 },
	0xDAEE, { 0xE8, 0xB8, 0xB6 },
	0xDAEF, { 0xE8, 0xB8, 0xBC },
	0xDAF0, { 0xE8, 0xB8, 0xBD },
	0xDAF1, { 0xE8, 0xB9, 0x81 },
	0xDAF2, { 0xE8, 0xB8, 0xB0 },
	0xDAF3, { 0xE8, 0xB8, 0xBF },
	0xDAF4, { 0xE8, 0xBA, 0xBD },
	0xDAF5, { 0xE8, 0xBC, 0xB6 },
	0xDAF6, { 0xE8, 0xBC, 0xAE },
	0xDAF7, { 0xE8, 0xBC, 0xB5 },
	0xDAF8, { 0xE8, 0xBC, 0xB2 },
	0xDAF9, { 0xE8, 0xBC, 0xB9 },
	0xDAFA, { 0xE8, 0xBC, 0xB7 },
	0xDAFB, { 0xE8, 0xBC, 0xB4 },
	0xDAFC, { 0xE9, 0x81, 0xB6 },
	0xDAFD, { 0xE9, 0x81, 0xB9 },
	0xDAFE, { 0xE9, 0x81, 0xBB },
	0xDBA1, { 0xE9, 0x82, 0x86 },
	0xDBA2, { 0xE9, 0x83, 0xBA },
	0xDBA3, { 0xE9, 0x84, 0xB3 },
	0xDBA4, { 0xE9, 0x84, 0xB5 },
	0xDBA5, { 0xE9, 0x84, 0xB6 },
	0xDBA6, { 0xE9, 0x86, 0x93 },
	0xDBA7, { 0xE9, 0x86, 0x90 },
	0xDBA8, { 0xE9, 0x86, 0x91 },
	0xDBA9, { 0xE9, 0x86, 0x8D },
	0xDBAA, { 0xE9, 0x86, 0x8F },
	0xDBAB, { 0xE9, 0x8C, 0xA7 },
	0xDBAC, { 0xE9, 0x8C, 0x9E },
	0xDBAD, { 0xE9, 0x8C, 0x88 },
	0xDBAE, { 0xE9, 0x8C, 0x9F },
	0xDBAF, { 0xE9, 0x8C, 0x86 },
	0xDBB0, { 0xE9, 0x8C, 0x8F },
	0xDBB1, { 0xE9, 0x8D, 0xBA },
	0xDBB2, { 0xE9, 0x8C, 0xB8 },
	0xDBB3, { 0xE9, 0x8C, 0xBC },
	0xDBB4, { 0xE9, 0x8C, 0x9B },
	0xDBB5, { 0xE9, 0x8C, 0xA3 },
	0xDBB6, { 0xE9, 0x8C, 0x92 },
	0xDBB7, { 0xE9, 0x8C, 0x81 },
	0xDBB8, { 0xE9, 0x8D, 0x86 },
	0xDBB9, { 0xE9, 0x8C, 0xAD },
	0xDBBA, { 0xE9, 0x8C, 0x8E },
	0xDBBB, { 0xE9, 0x8C, 0x8D },
	0xDBBC, { 0xE9, 0x8B, 0x8B },
	0xDBBD, { 0xE9, 0x8C, 0x9D },
	0xDBBE, { 0xE9, 0x8B, 0xBA },
	0xDBBF, { 0xE9, 0x8C, 0x93 },
	0xDBC0, { 0xE9, 0x8B, 0xB9 },
	0xDBC1, { 0xE9, 0x8B, 0xB7 },
	0xDBC2, { 0xE9, 0x8C, 0xB4 },
	0xDBC3, { 0xE9, 0x8C, 0x82 },
	0xDBC4, { 0xE9, 0x8C, 0xA4 },
	0xDBC5, { 0xE9, 0x8B, 0xBF },
	0xDBC6, { 0xE9, 0x8C, 0xA9 },
	0xDBC7, { 0xE9, 0x8C, 0xB9 },
	0xDBC8, { 0xE9, 0x8C, 0xB5 },
	0xDBC9, { 0xE9, 0x8C, 0xAA },
	0xDBCA, { 0xE9, 0x8C, 0x94 },
	0xDBCB, { 0xE9, 0x8C, 0x8C },
	0xDBCC, { 0xE9, 0x8C, 0x8B },
	0xDBCD, { 0xE9, 0x8B, 0xBE },
	0xDBCE, { 0xE9, 0x8C, 0x89 },
	0xDBCF, { 0xE9, 0x8C, 0x80 },
	0xDBD0, { 0xE9, 0x8B, 0xBB },
	0xDBD1, { 0xE9, 0x8C, 0x96 },
	0xDBD2, { 0xE9, 0x96, 0xBC },
	0xDBD3, { 0xE9, 0x97, 0x8D },
	0xDBD4, { 0xE9, 0x96, 0xBE },
	0xDBD5, { 0xE9, 0x96, 0xB9 },
	0xDBD6, { 0xE9, 0x96, 0xBA },
	0xDBD7, { 0xE9, 0x96, 0xB6 },
	0xDBD8, { 0xE9, 0x96, 0xBF },
	0xDBD9, { 0xE9, 0x96, 0xB5 },
	0xDBDA, { 0xE9, 0x96, 0xBD },
	0xDBDB, { 0xE9, 0x9A, 0xA9 },
	0xDBDC, { 0xE9, 0x9B, 0x94 },
	0xDBDD, { 0xE9, 0x9C, 0x8B },
	0xDBDE, { 0xE9, 0x9C, 0x92 },
	0xDBDF, { 0xE9, 0x9C, 0x90 },
	0xDBE0, { 0xE9, 0x9E, 0x99 },
	0xDBE1, { 0xE9, 0x9E, 0x97 },
	0xDBE2, { 0xE9, 0x9E, 0x94 },
	0xDBE3, { 0xE9, 0x9F, 0xB0 },
	0xDBE4, { 0xE9, 0x9F, 0xB8 },
	0xDBE5, { 0xE9, 0xA0, 0xB5 },
	0xDBE6, { 0xE9, 0xA0, 0xAF },
	0xDBE7, { 0xE9, 0xA0, 0xB2 },
	0xDBE8, { 0xE9, 0xA4, 0xA4 },
	0xDBE9, { 0xE9, 0xA4, 0x9F },
	0xDBEA, { 0xE9, 0xA4, 0xA7 },
	0xDBEB, { 0xE9, 0xA4, 0xA9 },
	0xDBEC, { 0xE9, 0xA6, 0x9E },
	0xDBED, { 0xE9, 0xA7, 0xAE },
	0xDBEE, { 0xE9, 0xA7, 0xAC },
	0xDBEF, { 0xE9, 0xA7, 0xA5 },
	0xDBF0, { 0xE9, 0xA7, 0xA4 },
	0xDBF1, { 0xE9, 0xA7, 0xB0 },
	0xDBF2, { 0xE9, 0xA7, 0xA3 },
	0xDBF3, { 0xE9, 0xA7, 0xAA },
	0xDBF4, { 0xE9, 0xA7, 0xA9 },
	0xDBF5, { 0xE9, 0xA7, 0xA7 },
	0xDBF6, { 0xE9, 0xAA, 0xB9 },
	0xDBF7, { 0xE9, 0xAA, 0xBF },
	0xDBF8, { 0xE9, 0xAA, 0xB4 },
	0xDBF9, { 0xE9, 0xAA, 0xBB },
	0xDBFA, { 0xE9, 0xAB, 0xB6 },
	0xDBFB, { 0xE9, 0xAB, 0xBA },
	0xDBFC, { 0xE9, 0xAB, 0xB9 },
	0xDBFD, { 0xE9, 0xAB, 0xB7 },
	0xDBFE, { 0xE9, 0xAC, 0xB3 },
	0xDCA1, { 0xE9, 0xAE, 0x80 },
	0xDCA2, { 0xE9, 0xAE, 0x85 },
	0xDCA3, { 0xE9, 0xAE, 0x87 },
	0xDCA4, { 0xE9, 0xAD, 0xBC },
	0xDCA5, { 0xE9, 0xAD, 0xBE },
	0xDCA6, { 0xE9, 0xAD, 0xBB },
	0xDCA7, { 0xE9, 0xAE, 0x82 },
	0xDCA8, { 0xE9, 0xAE, 0x93 },
	0xDCA9, { 0xE9, 0xAE, 0x92 },
	0xDCAA, { 0xE9, 0xAE, 0x90 },
	0xDCAB, { 0xE9, 0xAD, 0xBA },
	0xDCAC, { 0xE9, 0xAE, 0x95 },
	0xDCAD, { 0xE9, 0xAD, 0xBD },
	0xDCAE, { 0xE9, 0xAE, 0x88 },
	0xDCAF, { 0xE9, 0xB4, 0xA5 },
	0xDCB0, { 0xE9, 0xB4, 0x97 },
	0xDCB1, { 0xE9, 0xB4, 0xA0 },
	0xDCB2, { 0xE9, 0xB4, 0x9E },
	0xDCB3, { 0xE9, 0xB4, 0x94 },
	0xDCB4, { 0xE9, 0xB4, 0xA9 },
	0xDCB5, { 0xE9, 0xB4, 0x9D },
	0xDCB6, { 0xE9, 0xB4, 0x98 },
	0xDCB7, { 0xE9, 0xB4, 0xA2 },
	0xDCB8, { 0xE9, 0xB4, 0x90 },
	0xDCB9, { 0xE9, 0xB4, 0x99 },
	0xDCBA, { 0xE9, 0xB4, 0x9F },
	0xDCBB, { 0xE9, 0xBA, 0x88 },
	0xDCBC, { 0xE9, 0xBA, 0x86 },
	0xDCBD, { 0xE9, 0xBA, 0x87 },
	0xDCBE, { 0xE9, 0xBA, 0xAE },
	0xDCBF, { 0xE9, 0xBA, 0xAD },
	0xDCC0, { 0xE9, 0xBB, 0x95 },
	0xDCC1, { 0xE9, 0xBB, 0x96 },
	0xDCC2, { 0xE9, 0xBB, 0xBA },
	0xDCC3, { 0xE9, 0xBC, 0x92 },
	0xDCC4, { 0xE9, 0xBC, 0xBD },
	0xDCC5, { 0xE5, 0x84, 0xA6 },
	0xDCC6, { 0xE5, 0x84, 0xA5 },
	0xDCC7, { 0xE5, 0x84, 0xA2 },
	0xDCC8, { 0xE5, 0x84, 0xA4 },
	0xDCC9, { 0xE5, 0x84, 0xA0 },
	0xDCCA, { 0xE5, 0x84, 0xA9 },
	0xDCCB, { 0xE5, 0x8B, 0xB4 },
	0xDCCC, { 0xE5, 0x9A, 0x93 },
	0xDCCD, { 0xE5, 0x9A, 0x8C },
	0xDCCE, { 0xE5, 0x9A, 0x8D },
	0xDCCF, { 0xE5, 0x9A, 0x86 },
	0xDCD0, { 0xE5, 0x9A, 0x84 },
	0xDCD1, { 0xE5, 0x9A, 0x83 },
	0xDCD2, { 0xE5, 0x99, 0xBE },
	0xDCD3, { 0xE5, 0x9A, 0x82 },
	0xDCD4, { 0xE5, 0x99, 0xBF },
	0xDCD5, { 0xE5, 0x9A, 0x81 },
	0xDCD6, { 0xE5, 0xA3, 0x96 },
	0xDCD7, { 0xE5, 0xA3, 0x94 },
	0xDCD8, { 0xE5, 0xA3, 0x8F },
	0xDCD9, { 0xE5, 0xA3, 0x92 },
	0xDCDA, { 0xE5, 0xAC, 0xAD },
	0xDCDB, { 0xE5, 0xAC, 0xA5 },
	0xDCDC, { 0xE5, 0xAC, 0xB2 },
	0xDCDD, { 0xE5, 0xAC, 0xA3 },
	0xDCDE, { 0xE5, 0xAC, 0xAC },
	0xDCDF, { 0xE5, 0xAC, 0xA7 },
	0xDCE0, { 0xE5, 0xAC, 0xA6 },
	0xDCE1, { 0xE5, 0xAC, 0xAF },
	0xDCE2, { 0xE5, 0xAC, 0xAE },
	0xDCE3, { 0xE5, 0xAD, 0xBB },
	0xDCE4, { 0xE5, 0xAF, 0xB1 },
	0xDCE5, { 0xE5, 0xAF, 0xB2 },
	0xDCE6, { 0xE5, 0xB6, 0xB7 },
	0xDCE7, { 0xE5, 0xB9, 0xAC },
	0xDCE8, { 0xE5, 0xB9, 0xAA },
	0xDCE9, { 0xE5, 0xBE, 0xBE },
	0xDCEA, { 0xE6, 0x87, 0x83 },
	0xDCEB, { 0xE6, 0x86, 0xB5 },
	0xDCEC, { 0xE6, 0x86, 0xBC },
	0xDCED, { 0xE6, 0x87, 0xA7 },
	0xDCEE, { 0xE6, 0x87, 0xA0 },
	0xDCEF, { 0xE6, 0x87, 0xA5 },
	0xDCF0, { 0xE6, 0x87, 0xA4 },
	0xDCF1, { 0xE6, 0x87, 0xA8 },
	0xDCF2, { 0xE6, 0x87, 0x9E },
	0xDCF3, { 0xE6, 0x93, 0xAF },
	0xDCF4, { 0xE6, 0x93, 0xA9 },
	0xDCF5, { 0xE6, 0x93, 0xA3 },
	0xDCF6, { 0xE6, 0x93, 0xAB },
	0xDCF7, { 0xE6, 0x93, 0xA4 },
	0xDCF8, { 0xE6, 0x93, 0xA8 },
	0xDCF9, { 0xE6, 0x96, 0x81 },
	0xDCFA, { 0xE6, 0x96, 0x80 },
	0xDCFB, { 0xE6, 0x96, 0xB6 },
	0xDCFC, { 0xE6, 0x97, 0x9A },
	0xDCFD, { 0xE6, 0x9B, 0x92 },
	0xDCFE, { 0xE6, 0xAA, 0x8D },
	0xDDA1, { 0xE6, 0xAA, 0x96 },
	0xDDA2, { 0xE6, 0xAA, 0x81 },
	0xDDA3, { 0xE6, 0xAA, 0xA5 },
	0xDDA4, { 0xE6, 0xAA, 0x89 },
	0xDDA5, { 0xE6, 0xAA, 0x9F },
	0xDDA6, { 0xE6, 0xAA, 0x9B },
	0xDDA7, { 0xE6, 0xAA, 0xA1 },
	0xDDA8, { 0xE6, 0xAA, 0x9E },
	0xDDA9, { 0xE6, 0xAA, 0x87 },
	0xDDAA, { 0xE6, 0xAA, 0x93 },
	0xDDAB, { 0xE6, 0xAA, 0x8E },
	0xDDAC, { 0xE6, 0xAA, 0x95 },
	0xDDAD, { 0xE6, 0xAA, 0x83 },
	0xDDAE, { 0xE6, 0xAA, 0xA8 },
	0xDDAF, { 0xE6, 0xAA, 0xA4 },
	0xDDB0, { 0xE6, 0xAA, 0x91 },
	0xDDB1, { 0xE6, 0xA9, 0xBF },
	0xDDB2, { 0xE6, 0xAA, 0xA6 },
	0xDDB3, { 0xE6, 0xAA, 0x9A },
	0xDDB4, { 0xE6, 0xAA, 0x85 },
	0xDDB5, { 0xE6, 0xAA, 0x8C },
	0xDDB6, { 0xE6, 0xAA, 0x92 },
	0xDDB7, { 0xE6, 0xAD, 0x9B },
	0xDDB8, { 0xE6, 0xAE, 0xAD },
	0xDDB9, { 0xE6, 0xB0, 0x89 },
	0xDDBA, { 0xE6, 0xBF, 0x8C },
	0xDDBB, { 0xE6, 0xBE, 0xA9 },
	0xDDBC, { 0xE6, 0xBF, 0xB4 },
	0xDDBD, { 0xE6, 0xBF, 0x94 },
	0xDDBE, { 0xE6, 0xBF, 0xA3 },
	0xDDBF, { 0xE6, 0xBF, 0x9C },
	0xDDC0, { 0xE6, 0xBF, 0xAD },
	0xDDC1, { 0xE6, 0xBF, 0xA7 },
	0xDDC2, { 0xE6, 0xBF, 0xA6 },
	0xDDC3, { 0xE6, 0xBF, 0x9E },
	0xDDC4, { 0xE6, 0xBF, 0xB2 },
	0xDDC5, { 0xE6, 0xBF, 0x9D },
	0xDDC6, { 0xE6, 0xBF, 0xA2 },
	0xDDC7, { 0xE6, 0xBF, 0xA8 },
	0xDDC8, { 0xE7, 0x87, 0xA1 },
	0xDDC9, { 0xE7, 0x87, 0xB1 },
	0xDDCA, { 0xE7, 0x87, 0xA8 },
	0xDDCB, { 0xE7, 0x87, 0xB2 },
	0xDDCC, { 0xE7, 0x87, 0xA4 },
	0xDDCD, { 0xE7, 0x87, 0xB0 },
	0xDDCE, { 0xE7, 0x87, 0xA2 },
	0xDDCF, { 0xE7, 0x8D, 0xB3 },
	0xDDD0, { 0xE7, 0x8D, 0xAE },
	0xDDD1, { 0xE7, 0x8D, 0xAF },
	0xDDD2, { 0xE7, 0x92, 0x97 },
	0xDDD3, { 0xE7, 0x92, 0xB2 },
	0xDDD4, { 0xE7, 0x92, 0xAB },
	0xDDD5, { 0xE7, 0x92, 0x90 },
	0xDDD6, { 0xE7, 0x92, 0xAA },
	0xDDD7, { 0xE7, 0x92, 0xAD },
	0xDDD8, { 0xE7, 0x92, 0xB1 },
	0xDDD9, { 0xE7, 0x92, 0xA5 },
	0xDDDA, { 0xE7, 0x92, 0xAF },
	0xDDDB, { 0xE7, 0x94, 0x90 },
	0xDDDC, { 0xE7, 0x94, 0x91 },
	0xDDDD, { 0xE7, 0x94, 0x92 },
	0xDDDE, { 0xE7, 0x94, 0x8F },
	0xDDDF, { 0xE7, 0x96, 0x84 },
	0xDDE0, { 0xE7, 0x99, 0x83 },
	0xDDE1, { 0xE7, 0x99, 0x88 },
	0xDDE2, { 0xE7, 0x99, 0x89 },
	0xDDE3, { 0xE7, 0x99, 0x87 },
	0xDDE4, { 0xE7, 0x9A, 0xA4 },
	0xDDE5, { 0xE7, 0x9B, 0xA9 },
	0xDDE6, { 0xE7, 0x9E, 0xB5 },
	0xDDE7, { 0xE7, 0x9E, 0xAB },
	0xDDE8, { 0xE7, 0x9E, 0xB2 },
	0xDDE9, { 0xE7, 0x9E, 0xB7 },
	0xDDEA, { 0xE7, 0x9E, 0xB6 },
	0xDDEB, { 0xE7, 0x9E, 0xB4 },
	0xDDEC, { 0xE7, 0x9E, 0xB1 },
	0xDDED, { 0xE7, 0x9E, 0xA8 },
	0xDDEE, { 0xE7, 0x9F, 0xB0 },
	0xDDEF, { 0xE7, 0xA3, 0xB3 },
	0xDDF0, { 0xE7, 0xA3, 0xBD },
	0xDDF1, { 0xE7, 0xA4, 0x82 },
	0xDDF2, { 0xE7, 0xA3, 0xBB },
	0xDDF3, { 0xE7, 0xA3, 0xBC },
	0xDDF4, { 0xE7, 0xA3, 0xBF },
	0xDDF5, { 0xE7, 0xA3, 0xB2 },
	0xDDF6, { 0xE7, 0xA4, 0x85 },
	0xDDF7, { 0xE7, 0xA3, 0xB9 },
	0xDDF8, { 0xE7, 0xA3, 0xBE },
	0xDDF9, { 0xE7, 0xA4, 0x84 },
	0xDDFA, { 0xE7, 0xA6, 0xAB },
	0xDDFB, { 0xE7, 0xA6, 0xA8 },
	0xDDFC, { 0xE7, 0xA9, 0x9C },
	0xDDFD, { 0xE7, 0xA9, 0x9B },
	0xDDFE, { 0xE7, 0xA9, 0x96 },
	0xDEA1, { 0xE7, 0xA9, 0x98 },
	0xDEA2, { 0xE7, 0xA9, 0x94 },
	0xDEA3, { 0xE7, 0xA9, 0x9A },
	0xDEA4, { 0xE7, 0xAA, 0xBE },
	0xDEA5, { 0xE7, 0xAB, 0x80 },
	0xDEA6, { 0xE7, 0xAB, 0x81 },
	0xDEA7, { 0xE7, 0xB0, 0x85 },
	0xDEA8, { 0xE7, 0xB0, 0x8F },
	0xDEA9, { 0xE7, 0xAF, 0xB2 },
	0xDEAA, { 0xE7, 0xB0, 0x80 },
	0xDEAB, { 0xE7, 0xAF, 0xBF },
	0xDEAC, { 0xE7, 0xAF, 0xBB },
	0xDEAD, { 0xE7, 0xB0, 0x8E },
	0xDEAE, { 0xE7, 0xAF, 0xB4 },
	0xDEAF, { 0xE7, 0xB0, 0x8B },
	0xDEB0, { 0xE7, 0xAF, 0xB3 },
	0xDEB1, { 0xE7, 0xB0, 0x82 },
	0xDEB2, { 0xE7, 0xB0, 0x89 },
	0xDEB3, { 0xE7, 0xB0, 0x83 },
	0xDEB4, { 0xE7, 0xB0, 0x81 },
	0xDEB5, { 0xE7, 0xAF, 0xB8 },
	0xDEB6, { 0xE7, 0xAF, 0xBD },
	0xDEB7, { 0xE7, 0xB0, 0x86 },
	0xDEB8, { 0xE7, 0xAF, 0xB0 },
	0xDEB9, { 0xE7, 0xAF, 0xB1 },
	0xDEBA, { 0xE7, 0xB0, 0x90 },
	0xDEBB, { 0xE7, 0xB0, 0x8A },
	0xDEBC, { 0xE7, 0xB3, 0xA8 },
	0xDEBD, { 0xE7, 0xB8, 0xAD },
	0xDEBE, { 0xE7, 0xB8, 0xBC },
	0xDEBF, { 0xE7, 0xB9, 0x82 },
	0xDEC0, { 0xE7, 0xB8, 0xB3 },
	0xDEC1, { 0xE9, 0xA1, 0x88 },
	0xDEC2, { 0xE7, 0xB8, 0xB8 },
	0xDEC3, { 0xE7, 0xB8, 0xAA },
	0xDEC4, { 0xE7, 0xB9, 0x89 },
	0xDEC5, { 0xE7, 0xB9, 0x80 },
	0xDEC6, { 0xE7, 0xB9, 0x87 },
	0xDEC7, { 0xE7, 0xB8, 0xA9 },
	0xDEC8, { 0xE7, 0xB9, 0x8C },
	0xDEC9, { 0xE7, 0xB8, 0xB0 },
	0xDECA, { 0xE7, 0xB8, 0xBB },
	0xDECB, { 0xE7, 0xB8, 0xB6 },
	0xDECC, { 0xE7, 0xB9, 0x84 },
	0xDECD, { 0xE7, 0xB8, 0xBA },
	0xDECE, { 0xE7, 0xBD, 0x85 },
	0xDECF, { 0xE7, 0xBD, 0xBF },
	0xDED0, { 0xE7, 0xBD, 0xBE },
	0xDED1, { 0xE7, 0xBD, 0xBD },
	0xDED2, { 0xE7, 0xBF, 0xB4 },
	0xDED3, { 0xE7, 0xBF, 0xB2 },
	0xDED4, { 0xE8, 0x80, 0xAC },
	0xDED5, { 0xE8, 0x86, 0xBB },
	0xDED6, { 0xE8, 0x87, 0x84 },
	0xDED7, { 0xE8, 0x87, 0x8C },
	0xDED8, { 0xE8, 0x87, 0x8A },
	0xDED9, { 0xE8, 0x87, 0x85 },
	0xDEDA, { 0xE8, 0x87, 0x87 },
	0xDEDB, { 0xE8, 0x86, 0xBC },
	0xDEDC, { 0xE8, 0x87, 0xA9 },
	0xDEDD, { 0xE8, 0x89, 0x9B },
	0xDEDE, { 0xE8, 0x89, 0x9A },
	0xDEDF, { 0xE8, 0x89, 0x9C },
	0xDEE0, { 0xE8, 0x96, 0x83 },
	0xDEE1, { 0xE8, 0x96, 0x80 },
	0xDEE2, { 0xE8, 0x96, 0x8F },
	0xDEE3, { 0xE8, 0x96, 0xA7 },
	0xDEE4, { 0xE8, 0x96, 0x95 },
	0xDEE5, { 0xE8, 0x96, 0xA0 },
	0xDEE6, { 0xE8, 0x96, 0x8B },
	0xDEE7, { 0xE8, 0x96, 0xA3 },
	0xDEE8, { 0xE8, 0x95, 0xBB },
	0xDEE9, { 0xE8, 0x96, 0xA4 },
	0xDEEA, { 0xE8, 0x96, 0x9A },
	0xDEEB, { 0xE8, 0x96, 0x9E },
	0xDEEC, { 0xE8, 0x95, 0xB7 },
	0xDEED, { 0xE8, 0x95, 0xBC },
	0xDEEE, { 0xE8, 0x96, 0x89 },
	0xDEEF, { 0xE8, 0x96, 0xA1 },
	0xDEF0, { 0xE8, 0x95, 0xBA },
	0xDEF1, { 0xE8, 0x95, 0xB8 },
	0xDEF2, { 0xE8, 0x95, 0x97 },
	0xDEF3, { 0xE8, 0x96, 0x8E },
	0xDEF4, { 0xE8, 0x96, 0x96 },
	0xDEF5, { 0xE8, 0x96, 0x86 },
	0xDEF6, { 0xE8, 0x96, 0x8D },
	0xDEF7, { 0xE8, 0x96, 0x99 },
	0xDEF8, { 0xE8, 0x96, 0x9D },
	0xDEF9, { 0xE8, 0x96, 0x81 },
	0xDEFA, { 0xE8, 0x96, 0xA2 },
	0xDEFB, { 0xE8, 0x96, 0x82 },
	0xDEFC, { 0xE8, 0x96, 0x88 },
	0xDEFD, { 0xE8, 0x96, 0x85 },
	0xDEFE, { 0xE8, 0x95, 0xB9 },
	0xDFA1, { 0xE8, 0x95, 0xB6 },
	0xDFA2, { 0xE8, 0x96, 0x98 },
	0xDFA3, { 0xE8, 0x96, 0x90 },
	0xDFA4, { 0xE8, 0x96, 0x9F },
	0xDFA5, { 0xE8, 0x99, 0xA8 },
	0xDFA6, { 0xE8, 0x9E, 0xBE },
	0xDFA7, { 0xE8, 0x9E, 0xAA },
	0xDFA8, { 0xE8, 0x9E, 0xAD },
	0xDFA9, { 0xE8, 0x9F, 0x85 },
	0xDFAA, { 0xE8, 0x9E, 0xB0 },
	0xDFAB, { 0xE8, 0x9E, 0xAC },
	0xDFAC, { 0xE8, 0x9E, 0xB9 },
	0xDFAD, { 0xE8, 0x9E, 0xB5 },
	0xDFAE, { 0xE8, 0x9E, 0xBC },
	0xDFAF, { 0xE8, 0x9E, 0xAE },
	0xDFB0, { 0xE8, 0x9F, 0x89 },
	0xDFB1, { 0xE8, 0x9F, 0x83 },
	0xDFB2, { 0xE8, 0x9F, 0x82 },
	0xDFB3, { 0xE8, 0x9F, 0x8C },
	0xDFB4, { 0xE8, 0x9E, 0xB7 },
	0xDFB5, { 0xE8, 0x9E, 0xAF },
	0xDFB6, { 0xE8, 0x9F, 0x84 },
	0xDFB7, { 0xE8, 0x9F, 0x8A },
	0xDFB8, { 0xE8, 0x9E, 0xB4 },
	0xDFB9, { 0xE8, 0x9E, 0xB6 },
	0xDFBA, { 0xE8, 0x9E, 0xBF },
	0xDFBB, { 0xE8, 0x9E, 0xB8 },
	0xDFBC, { 0xE8, 0x9E, 0xBD },
	0xDFBD, { 0xE8, 0x9F, 0x9E },
	0xDFBE, { 0xE8, 0x9E, 0xB2 },
	0xDFBF, { 0xE8, 0xA4, 0xB5 },
	0xDFC0, { 0xE8, 0xA4, 0xB3 },
	0xDFC1, { 0xE8, 0xA4, 0xBC },
	0xDFC2, { 0xE8, 0xA4, 0xBE },
	0xDFC3, { 0xE8, 0xA5, 0x81 },
	0xDFC4, { 0xE8, 0xA5, 0x92 },
	0xDFC5, { 0xE8, 0xA4, 0xB7 },
	0xDFC6, { 0xE8, 0xA5, 0x82 },
	0xDFC7, { 0xE8, 0xA6, 0xAD },
	0xDFC8, { 0xE8, 0xA6, 0xAF },
	0xDFC9, { 0xE8, 0xA6, 0xAE },
	0xDFCA, { 0xE8, 0xA7, 0xB2 },
	0xDFCB, { 0xE8, 0xA7, 0xB3 },
	0xDFCC, { 0xE8, 0xAC, 0x9E },
	0xDFCD, { 0xE8, 0xAC, 0x98 },
	0xDFCE, { 0xE8, 0xAC, 0x96 },
	0xDFCF, { 0xE8, 0xAC, 0x91 },
	0xDFD0, { 0xE8, 0xAC, 0x85 },
	0xDFD1, { 0xE8, 0xAC, 0x8B },
	0xDFD2, { 0xE8, 0xAC, 0xA2 },
	0xDFD3, { 0xE8, 0xAC, 0x8F },
	0xDFD4, { 0xE8, 0xAC, 0x92 },
	0xDFD5, { 0xE8, 0xAC, 0x95 },
	0xDFD6, { 0xE8, 0xAC, 0x87 },
	0xDFD7, { 0xE8, 0xAC, 0x8D },
	0xDFD8, { 0xE8, 0xAC, 0x88 },
	0xDFD9, { 0xE8, 0xAC, 0x86 },
	0xDFDA, { 0xE8, 0xAC, 0x9C },
	0xDFDB, { 0xE8, 0xAC, 0x93 },
	0xDFDC, { 0xE8, 0xAC, 0x9A },
	0xDFDD, { 0xE8, 0xB1, 0x8F },
	0xDFDE, { 0xE8, 0xB1, 0xB0 },
	0xDFDF, { 0xE8, 0xB1, 0xB2 },
	0xDFE0, { 0xE8, 0xB1, 0xB1 },
	0xDFE1, { 0xE8, 0xB1, 0xAF },
	0xDFE2, { 0xE8, 0xB2, 0x95 },
	0xDFE3, { 0xE8, 0xB2, 0x94 },
	0xDFE4, { 0xE8, 0xB3, 0xB9 },
	0xDFE5, { 0xE8, 0xB5, 0xAF },
	0xDFE6, { 0xE8, 0xB9, 0x8E },
	0xDFE7, { 0xE8, 0xB9, 0x8D },
	0xDFE8, { 0xE8, 0xB9, 0x93 },
	0xDFE9, { 0xE8, 0xB9, 0x90 },
	0xDFEA, { 0xE8, 0xB9, 0x8C },
	0xDFEB, { 0xE8, 0xB9, 0x87 },
	0xDFEC, { 0xE8, 0xBD, 0x83 },
	0xDFED, { 0xE8, 0xBD, 0x80 },
	0xDFEE, { 0xE9, 0x82, 0x85 },
	0xDFEF, { 0xE9, 0x81, 0xBE },
	0xDFF0, { 0xE9, 0x84, 0xB8 },
	0xDFF1, { 0xE9, 0x86, 0x9A },
	0xDFF2, { 0xE9, 0x86, 0xA2 },
	0xDFF3, { 0xE9, 0x86, 0x9B },
	0xDFF4, { 0xE9, 0x86, 0x99 },
	0xDFF5, { 0xE9, 0x86, 0x9F },
	0xDFF6, { 0xE9, 0x86, 0xA1 },
	0xDFF7, { 0xE9, 0x86, 0x9D },
	0xDFF8, { 0xE9, 0x86, 0xA0 },
	0xDFF9, { 0xE9, 0x8E, 0xA1 },
	0xDFFA, { 0xE9, 0x8E, 0x83 },
	0xDFFB, { 0xE9, 0x8E, 0xAF },
	0xDFFC, { 0xE9, 0x8D, 0xA4 },
	0xDFFD, { 0xE9, 0x8D, 0x96 },
	0xDFFE, { 0xE9, 0x8D, 0x87 },
	0xE0A1, { 0xE9, 0x8D, 0xBC },
	0xE0A2, { 0xE9, 0x8D, 0x98 },
	0xE0A3, { 0xE9, 0x8D, 0x9C },
	0xE0A4, { 0xE9, 0x8D, 0xB6 },
	0xE0A5, { 0xE9, 0x8D, 0x89 },
	0xE0A6, { 0xE9, 0x8D, 0x90 },
	0xE0A7, { 0xE9, 0x8D, 0x91 },
	0xE0A8, { 0xE9, 0x8D, 0xA0 },
	0xE0A9, { 0xE9, 0x8D, 0xAD },
	0xE0AA, { 0xE9, 0x8E, 0x8F },
	0xE0AB, { 0xE9, 0x8D, 0x8C },
	0xE0AC, { 0xE9, 0x8D, 0xAA },
	0xE0AD, { 0xE9, 0x8D, 0xB9 },
	0xE0AE, { 0xE9, 0x8D, 0x97 },
	0xE0AF, { 0xE9, 0x8D, 0x95 },
	0xE0B0, { 0xE9, 0x8D, 0x92 },
	0xE0B1, { 0xE9, 0x8D, 0x8F },
	0xE0B2, { 0xE9, 0x8D, 0xB1 },
	0xE0B3, { 0xE9, 0x8D, 0xB7 },
	0xE0B4, { 0xE9, 0x8D, 0xBB },
	0xE0B5, { 0xE9, 0x8D, 0xA1 },
	0xE0B6, { 0xE9, 0x8D, 0x9E },
	0xE0B7, { 0xE9, 0x8D, 0xA3 },
	0xE0B8, { 0xE9, 0x8D, 0xA7 },
	0xE0B9, { 0xE9, 0x8D, 0x8E },
	0xE0BA, { 0xE9, 0x8D, 0x99 },
	0xE0BB, { 0xE9, 0x97, 0x87 },
	0xE0BC, { 0xE9, 0x97, 0x80 },
	0xE0BD, { 0xE9, 0x97, 0x89 },
	0xE0BE, { 0xE9, 0x97, 0x83 },
	0xE0BF, { 0xE9, 0x97, 0x85 },
	0xE0C0, { 0xE9, 0x96, 0xB7 },
	0xE0C1, { 0xE9, 0x9A, 0xAE },
	0xE0C2, { 0xE9, 0x9A, 0xB0 },
	0xE0C3, { 0xE9, 0x9A, 0xAC },
	0xE0C4, { 0xE9, 0x9C, 0xA0 },
	0xE0C5, { 0xE9, 0x9C, 0x9F },
	0xE0C6, { 0xE9, 0x9C, 0x98 },
	0xE0C7, { 0xE9, 0x9C, 0x9D },
	0xE0C8, { 0xE9, 0x9C, 0x99 },
	0xE0C9, { 0xE9, 0x9E, 0x9A },
	0xE0CA, { 0xE9, 0x9E, 0xA1 },
	0xE0CB, { 0xE9, 0x9E, 0x9C },
	0xE0CC, { 0xE9, 0x9E, 0x9E },
	0xE0CD, { 0xE9, 0x9E, 0x9D },
	0xE0CE, { 0xE9, 0x9F, 0x95 },
	0xE0CF, { 0xE9, 0x9F, 0x94 },
	0xE0D0, { 0xE9, 0x9F, 0xB1 },
	0xE0D1, { 0xE9, 0xA1, 0x81 },
	0xE0D2, { 0xE9, 0xA1, 0x84 },
	0xE0D3, { 0xE9, 0xA1, 0x8A },
	0xE0D4, { 0xE9, 0xA1, 0x89 },
	0xE0D5, { 0xE9, 0xA1, 0x85 },
	0xE0D6, { 0xE9, 0xA1, 0x83 },
	0xE0D7, { 0xE9, 0xA4, 0xA5 },
	0xE0D8, { 0xE9, 0xA4, 0xAB },
	0xE0D9, { 0xE9, 0xA4, 0xAC },
	0xE0DA, { 0xE9, 0xA4, 0xAA },
	0xE0DB, { 0xE9, 0xA4, 0xB3 },
	0xE0DC, { 0xE9, 0xA4, 0xB2 },
	0xE0DD, { 0xE9, 0xA4, 0xAF },
	0xE0DE, { 0xE9, 0xA4, 0xAD },
	0xE0DF, { 0xE9, 0xA4, 0xB1 },
	0xE0E0, { 0xE9, 0xA4, 0xB0 },
	0xE0E1, { 0xE9, 0xA6, 0x98 },
	0xE0E2, { 0xE9, 0xA6, 0xA3 },
	0xE0E3, { 0xE9, 0xA6, 0xA1 },
	0xE0E4, { 0xE9, 0xA8, 0x82 },
	0xE0E5, { 0xE9, 0xA7, 0xBA },
	0xE0E6, { 0xE9, 0xA7, 0xB4 },
	0xE0E7, { 0xE9, 0xA7, 0xB7 },
	0xE0E8, { 0xE9, 0xA7, 0xB9 },
	0xE0E9, { 0xE9, 0xA7, 0xB8 },
	0xE0EA, { 0xE9, 0xA7, 0xB6 },
	0xE0EB, { 0xE9, 0xA7, 0xBB },
	0xE0EC, { 0xE9, 0xA7, 0xBD },
	0xE0ED, { 0xE9, 0xA7, 0xBE },
	0xE0EE, { 0xE9, 0xA7, 0xBC },
	0xE0EF, { 0xE9, 0xA8, 0x83 },
	0xE0F0, { 0xE9, 0xAA, 0xBE },
	0xE0F1, { 0xE9, 0xAB, 0xBE },
	0xE0F2, { 0xE9, 0xAB, 0xBD },
	0xE0F3, { 0xE9, 0xAC, 0x81 },
	0xE0F4, { 0xE9, 0xAB, 0xBC },
	0xE0F5, { 0xE9, 0xAD, 0x88 },
	0xE0F6, { 0xE9, 0xAE, 0x9A },
	0xE0F7, { 0xE9, 0xAE, 0xA8 },
	0xE0F8, { 0xE9, 0xAE, 0x9E },
	0xE0F9, { 0xE9, 0xAE, 0x9B },
	0xE0FA, { 0xE9, 0xAE, 0xA6 },
	0xE0FB, { 0xE9, 0xAE, 0xA1 },
	0xE0FC, { 0xE9, 0xAE, 0xA5 },
	0xE0FD, { 0xE9, 0xAE, 0xA4 },
	0xE0FE, { 0xE9, 0xAE, 0x86 },
	0xE1A1, { 0xE9, 0xAE, 0xA2 },
	0xE1A2, { 0xE9, 0xAE, 0xA0 },
	0xE1A3, { 0xE9, 0xAE, 0xAF },
	0xE1A4, { 0xE9, 0xB4, 0xB3 },
	0xE1A5, { 0xE9, 0xB5, 0x81 },
	0xE1A6, { 0xE9, 0xB5, 0xA7 },
	0xE1A7, { 0xE9, 0xB4, 0xB6 },
	0xE1A8, { 0xE9, 0xB4, 0xAE },
	0xE1A9, { 0xE9, 0xB4, 0xAF },
	0xE1AA, { 0xE9, 0xB4, 0xB1 },
	0xE1AB, { 0xE9, 0xB4, 0xB8 },
	0xE1AC, { 0xE9, 0xB4, 0xB0 },
	0xE1AD, { 0xE9, 0xB5, 0x85 },
	0xE1AE, { 0xE9, 0xB5, 0x82 },
	0xE1AF, { 0xE9, 0xB5, 0x83 },
	0xE1B0, { 0xE9, 0xB4, 0xBE },
	0xE1B1, { 0xE9, 0xB4, 0xB7 },
	0xE1B2, { 0xE9, 0xB5, 0x80 },
	0xE1B3, { 0xE9, 0xB4, 0xBD },
	0xE1B4, { 0xE7, 0xBF, 0xB5 },
	0xE1B5, { 0xE9, 0xB4, 0xAD },
	0xE1B6, { 0xE9, 0xBA, 0x8A },
	0xE1B7, { 0xE9, 0xBA, 0x89 },
	0xE1B8, { 0xE9, 0xBA, 0x8D },
	0xE1B9, { 0xE9, 0xBA, 0xB0 },
	0xE1BA, { 0xE9, 0xBB, 0x88 },
	0xE1BB, { 0xE9, 0xBB, 0x9A },
	0xE1BC, { 0xE9, 0xBB, 0xBB },
	0xE1BD, { 0xE9, 0xBB, 0xBF },
	0xE1BE, { 0xE9, 0xBC, 0xA4 },
	0xE1BF, { 0xE9, 0xBC, 0xA3 },
	0xE1C0, { 0xE9, 0xBC, 0xA2 },
	0xE1C1, { 0xE9, 0xBD, 0x94 },
	0xE1C2, { 0xE9, 0xBE, 0xA0 },
	0xE1C3, { 0xE5, 0x84, 0xB1 },
	0xE1C4, { 0xE5, 0x84, 0xAD },
	0xE1C5, { 0xE5, 0x84, 0xAE },
	0xE1C6, { 0xE5, 0x9A, 0x98 },
	0xE1C7, { 0xE5, 0x9A, 0x9C },
	0xE1C8, { 0xE5, 0x9A, 0x97 },
	0xE1C9, { 0xE5, 0x9A, 0x9A },
	0xE1CA, { 0xE5, 0x9A, 0x9D },
	0xE1CB, { 0xE5, 0x9A, 0x99 },
	0xE1CC, { 0xE5, 0xA5, 0xB0 },
	0xE1CD, { 0xE5, 0xAC, 0xBC },
	0xE1CE, { 0xE5, 0xB1, 0xA9 },
	0xE1CF, { 0xE5, 0xB1, 0xAA },
	0xE1D0, { 0xE5, 0xB7, 0x80 },
	0xE1D1, { 0xE5, 0xB9, 0xAD },
	0xE1D2, { 0xE5, 0xB9, 0xAE },
	0xE1D3, { 0xE6, 0x87, 0x98 },
	0xE1D4, { 0xE6, 0x87, 0x9F },
	0xE1D5, { 0xE6, 0x87, 0xAD },
	0xE1D6, { 0xE6, 0x87, 0xAE },
	0xE1D7, { 0xE6, 0x87, 0xB1 },
	0xE1D8, { 0xE6, 0x87, 0xAA },
	0xE1D9, { 0xE6, 0x87, 0xB0 },
	0xE1DA, { 0xE6, 0x87, 0xAB },
	0xE1DB, { 0xE6, 0x87, 0x96 },
	0xE1DC, { 0xE6, 0x87, 0xA9 },
	0xE1DD, { 0xE6, 0x93, 0xBF },
	0xE1DE, { 0xE6, 0x94, 0x84 },
	0xE1DF, { 0xE6, 0x93, 0xBD },
	0xE1E0, { 0xE6, 0x93, 0xB8 },
	0xE1E1, { 0xE6, 0x94, 0x81 },
	0xE1E2, { 0xE6, 0x94, 0x83 },
	0xE1E3, { 0xE6, 0x93, 0xBC },
	0xE1E4, { 0xE6, 0x96, 0x94 },
	0xE1E5, { 0xE6, 0x97, 0x9B },
	0xE1E6, { 0xE6, 0x9B, 0x9A },
	0xE1E7, { 0xE6, 0x9B, 0x9B },
	0xE1E8, { 0xE6, 0x9B, 0x98 },
	0xE1E9, { 0xE6, 0xAB, 0x85 },
	0xE1EA, { 0xE6, 0xAA, 0xB9 },
	0xE1EB, { 0xE6, 0xAA, 0xBD },
	0xE1EC, { 0xE6, 0xAB, 0xA1 },
	0xE1ED, { 0xE6, 0xAB, 0x86 },
	0xE1EE, { 0xE6, 0xAA, 0xBA },
	0xE1EF, { 0xE6, 0xAA, 0xB6 },
	0xE1F0, { 0xE6, 0xAA, 0xB7 },
	0xE1F1, { 0xE6, 0xAB, 0x87 },
	0xE1F2, { 0xE6, 0xAA, 0xB4 },
	0xE1F3, { 0xE6, 0xAA, 0xAD },
	0xE1F4, { 0xE6, 0xAD, 0x9E },
	0xE1F5, { 0xE6, 0xAF, 0x89 },
	0xE1F6, { 0xE6, 0xB0, 0x8B },
	0xE1F7, { 0xE7, 0x80, 0x87 },
	0xE1F8, { 0xE7, 0x80, 0x8C },
	0xE1F9, { 0xE7, 0x80, 0x8D },
	0xE1FA, { 0xE7, 0x80, 0x81 },
	0xE1FB, { 0xE7, 0x80, 0x85 },
	0xE1FC, { 0xE7, 0x80, 0x94 },
	0xE1FD, { 0xE7, 0x80, 0x8E },
	0xE1FE, { 0xE6, 0xBF, 0xBF },
	0xE2A1, { 0xE7, 0x80, 0x80 },
	0xE2A2, { 0xE6, 0xBF, 0xBB },
	0xE2A3, { 0xE7, 0x80, 0xA6 },
	0xE2A4, { 0xE6, 0xBF, 0xBC },
	0xE2A5, { 0xE6, 0xBF, 0xB7 },
	0xE2A6, { 0xE7, 0x80, 0x8A },
	0xE2A7, { 0xE7, 0x88, 0x81 },
	0xE2A8, { 0xE7, 0x87, 0xBF },
	0xE2A9, { 0xE7, 0x87, 0xB9 },
	0xE2AA, { 0xE7, 0x88, 0x83 },
	0xE2AB, { 0xE7, 0x87, 0xBD },
	0xE2AC, { 0xE7, 0x8D, 0xB6 },
	0xE2AD, { 0xE7, 0x92, 0xB8 },
	0xE2AE, { 0xE7, 0x93, 0x80 },
	0xE2AF, { 0xE7, 0x92, 0xB5 },
	0xE2B0, { 0xE7, 0x93, 0x81 },
	0xE2B1, { 0xE7, 0x92, 0xBE },
	0xE2B2, { 0xE7, 0x92, 0xB6 },
	0xE2B3, { 0xE7, 0x92, 0xBB },
	0xE2B4, { 0xE7, 0x93, 0x82 },
	0xE2B5, { 0xE7, 0x94, 0x94 },
	0xE2B6, { 0xE7, 0x94, 0x93 },
	0xE2B7, { 0xE7, 0x99, 0x9C },
	0xE2B8, { 0xE7, 0x99, 0xA4 },
	0xE2B9, { 0xE7, 0x99, 0x99 },
	0xE2BA, { 0xE7, 0x99, 0x90 },
	0xE2BB, { 0xE7, 0x99, 0x93 },
	0xE2BC, { 0xE7, 0x99, 0x97 },
	0xE2BD, { 0xE7, 0x99, 0x9A },
	0xE2BE, { 0xE7, 0x9A, 0xA6 },
	0xE2BF, { 0xE7, 0x9A, 0xBD },
	0xE2C0, { 0xE7, 0x9B, 0xAC },
	0xE2C1, { 0xE7, 0x9F, 0x82 },
	0xE2C2, { 0xE7, 0x9E, 0xBA },
	0xE2C3, { 0xE7, 0xA4, 0x8C },
	0xE2C4, { 0xE7, 0xA4, 0x93 },
	0xE2C5, { 0xE7, 0xA4, 0x94 },
	0xE2C6, { 0xE7, 0xA4, 0x89 },
	0xE2C7, { 0xE7, 0xA4, 0x90 },
	0xE2C8, { 0xE7, 0xA4, 0x92 },
	0xE2C9, { 0xE7, 0xA4, 0x91 },
	0xE2CA, { 0xE7, 0xA6, 0xAD },
	0xE2CB, { 0xE7, 0xA6, 0xAC },
	0xE2CC, { 0xE7, 0xA9, 0x9F },
	0xE2CD, { 0xE7, 0xB0, 0x9C },
	0xE2CE, { 0xE7, 0xB0, 0xA9 },
	0xE2CF, { 0xE7, 0xB0, 0x99 },
	0xE2D0, { 0xE7, 0xB0, 0xA0 },
	0xE2D1, { 0xE7, 0xB0, 0x9F },
	0xE2D2, { 0xE7, 0xB0, 0xAD },
	0xE2D3, { 0xE7, 0xB0, 0x9D },
	0xE2D4, { 0xE7, 0xB0, 0xA6 },
	0xE2D5, { 0xE7, 0xB0, 0xA8 },
	0xE2D6, { 0xE7, 0xB0, 0xA2 },
	0xE2D7, { 0xE7, 0xB0, 0xA5 },
	0xE2D8, { 0xE7, 0xB0, 0xB0 },
	0xE2D9, { 0xE7, 0xB9, 0x9C },
	0xE2DA, { 0xE7, 0xB9, 0x90 },
	0xE2DB, { 0xE7, 0xB9, 0x96 },
	0xE2DC, { 0xE7, 0xB9, 0xA3 },
	0xE2DD, { 0xE7, 0xB9, 0x98 },
	0xE2DE, { 0xE7, 0xB9, 0xA2 },
	0xE2DF, { 0xE7, 0xB9, 0x9F },
	0xE2E0, { 0xE7, 0xB9, 0x91 },
	0xE2E1, { 0xE7, 0xB9, 0xA0 },
	0xE2E2, { 0xE7, 0xB9, 0x97 },
	0xE2E3, { 0xE7, 0xB9, 0x93 },
	0xE2E4, { 0xE7, 0xBE, 0xB5 },
	0xE2E5, { 0xE7, 0xBE, 0xB3 },
	0xE2E6, { 0xE7, 0xBF, 0xB7 },
	0xE2E7, { 0xE7, 0xBF, 0xB8 },
	0xE2E8, { 0xE8, 0x81, 0xB5 },
	0xE2E9, { 0xE8, 0x87, 0x91 },
	0xE2EA, { 0xE8, 0x87, 0x92 },
	0xE2EB, { 0xE8, 0x87, 0x90 },
	0xE2EC, { 0xE8, 0x89, 0x9F },
	0xE2ED, { 0xE8, 0x89, 0x9E },
	0xE2EE, { 0xE8, 0x96, 0xB4 },
	0xE2EF, { 0xE8, 0x97, 0x86 },
	0xE2F0, { 0xE8, 0x97, 0x80 },
	0xE2F1, { 0xE8, 0x97, 0x83 },
	0xE2F2, { 0xE8, 0x97, 0x82 },
	0xE2F3, { 0xE8, 0x96, 0xB3 },
	0xE2F4, { 0xE8, 0x96, 0xB5 },
	0xE2F5, { 0xE8, 0x96, 0xBD },
	0xE2F6, { 0xE8, 0x97, 0x87 },
	0xE2F7, { 0xE8, 0x97, 0x84 },
	0xE2F8, { 0xE8, 0x96, 0xBF },
	0xE2F9, { 0xE8, 0x97, 0x8B },
	0xE2FA, { 0xE8, 0x97, 0x8E },
	0xE2FB, { 0xE8, 0x97, 0x88 },
	0xE2FC, { 0xE8, 0x97, 0x85 },
	0xE2FD, { 0xE8, 0x96, 0xB1 },
	0xE2FE, { 0xE8, 0x96, 0xB6 },
	0xE3A1, { 0xE8, 0x97, 0x92 },
	0xE3A2, { 0xE8, 0x98, 0xA4 },
	0xE3A3, { 0xE8, 0x96, 0xB8 },
	0xE3A4, { 0xE8, 0x96, 0xB7 },
	0xE3A5, { 0xE8, 0x96, 0xBE },
	0xE3A6, { 0xE8, 0x99, 0xA9 },
	0xE3A7, { 0xE8, 0x9F, 0xA7 },
	0xE3A8, { 0xE8, 0x9F, 0xA6 },
	0xE3A9, { 0xE8, 0x9F, 0xA2 },
	0xE3AA, { 0xE8, 0x9F, 0x9B },
	0xE3AB, { 0xE8, 0x9F, 0xAB },
	0xE3AC, { 0xE8, 0x9F, 0xAA },
	0xE3AD, { 0xE8, 0x9F, 0xA5 },
	0xE3AE, { 0xE8, 0x9F, 0x9F },
	0xE3AF, { 0xE8, 0x9F, 0xB3 },
	0xE3B0, { 0xE8, 0x9F, 0xA4 },
	0xE3B1, { 0xE8, 0x9F, 0x94 },
	0xE3B2, { 0xE8, 0x9F, 0x9C },
	0xE3B3, { 0xE8, 0x9F, 0x93 },
	0xE3B4, { 0xE8, 0x9F, 0xAD },
	0xE3B5, { 0xE8, 0x9F, 0x98 },
	0xE3B6, { 0xE8, 0x9F, 0xA3 },
	0xE3B7, { 0xE8, 0x9F, 0x97 },
	0xE3B8, { 0xE8, 0x9F, 0x99 },
	0xE3B9, { 0xE8, 0xA0, 0x81 },
	0xE3BA, { 0xE8, 0x9F, 0xB4 },
	0xE3BB, { 0xE8, 0x9F, 0xA8 },
	0xE3BC, { 0xE8, 0x9F, 0x9D },
	0xE3BD, { 0xE8, 0xA5, 0x93 },
	0xE3BE, { 0xE8, 0xA5, 0x8B },
	0xE3BF, { 0xE8, 0xA5, 0x8F },
	0xE3C0, { 0xE8, 0xA5, 0x8C },
	0xE3C1, { 0xE8, 0xA5, 0x86 },
	0xE3C2, { 0xE8, 0xA5, 0x90 },
	0xE3C3, { 0xE8, 0xA5, 0x91 },
	0xE3C4, { 0xE8, 0xA5, 0x89 },
	0xE3C5, { 0xE8, 0xAC, 0xAA },
	0xE3C6, { 0xE8, 0xAC, 0xA7 },
	0xE3C7, { 0xE8, 0xAC, 0xA3 },
	0xE3C8, { 0xE8, 0xAC, 0xB3 },
	0xE3C9, { 0xE8, 0xAC, 0xB0 },
	0xE3CA, { 0xE8, 0xAC, 0xB5 },
	0xE3CB, { 0xE8, 0xAD, 0x87 },
	0xE3CC, { 0xE8, 0xAC, 0xAF },
	0xE3CD, { 0xE8, 0xAC, 0xBC },
	0xE3CE, { 0xE8, 0xAC, 0xBE },
	0xE3CF, { 0xE8, 0xAC, 0xB1 },
	0xE3D0, { 0xE8, 0xAC, 0xA5 },
	0xE3D1, { 0xE8, 0xAC, 0xB7 },
	0xE3D2, { 0xE8, 0xAC, 0xA6 },
	0xE3D3, { 0xE8, 0xAC, 0xB6 },
	0xE3D4, { 0xE8, 0xAC, 0xAE },
	0xE3D5, { 0xE8, 0xAC, 0xA4 },
	0xE3D6, { 0xE8, 0xAC, 0xBB },
	0xE3D7, { 0xE8, 0xAC, 0xBD },
	0xE3D8, { 0xE8, 0xAC, 0xBA },
	0xE3D9, { 0xE8, 0xB1, 0x82 },
	0xE3DA, { 0xE8, 0xB1, 0xB5 },
	0xE3DB, { 0xE8, 0xB2, 0x99 },
	0xE3DC, { 0xE8, 0xB2, 0x98 },
	0xE3DD, { 0xE8, 0xB2, 0x97 },
	0xE3DE, { 0xE8, 0xB3, 0xBE },
	0xE3DF, { 0xE8, 0xB4, 0x84 },
	0xE3E0, { 0xE8, 0xB4, 0x82 },
	0xE3E1, { 0xE8, 0xB4, 0x80 },
	0xE3E2, { 0xE8, 0xB9, 0x9C },
	0xE3E3, { 0xE8, 0xB9, 0xA2 },
	0xE3E4, { 0xE8, 0xB9, 0xA0 },
	0xE3E5, { 0xE8, 0xB9, 0x97 },
	0xE3E6, { 0xE8, 0xB9, 0x96 },
	0xE3E7, { 0xE8, 0xB9, 0x9E },
	0xE3E8, { 0xE8, 0xB9, 0xA5 },
	0xE3E9, { 0xE8, 0xB9, 0xA7 },
	0xE3EA, { 0xE8, 0xB9, 0x9B },
	0xE3EB, { 0xE8, 0xB9, 0x9A },
	0xE3EC, { 0xE8, 0xB9, 0xA1 },
	0xE3ED, { 0xE8, 0xB9, 0x9D },
	0xE3EE, { 0xE8, 0xB9, 0xA9 },
	0xE3EF, { 0xE8, 0xB9, 0x94 },
	0xE3F0, { 0xE8, 0xBD, 0x86 },
	0xE3F1, { 0xE8, 0xBD, 0x87 },
	0xE3F2, { 0xE8, 0xBD, 0x88 },
	0xE3F3, { 0xE8, 0xBD, 0x8B },
	0xE3F4, { 0xE9, 0x84, 0xA8 },
	0xE3F5, { 0xE9, 0x84, 0xBA },
	0xE3F6, { 0xE9, 0x84, 0xBB },
	0xE3F7, { 0xE9, 0x84, 0xBE },
	0xE3F8, { 0xE9, 0x86, 0xA8 },
	0xE3F9, { 0xE9, 0x86, 0xA5 },
	0xE3FA, { 0xE9, 0x86, 0xA7 },
	0xE3FB, { 0xE9, 0x86, 0xAF },
	0xE3FC, { 0xE9, 0x86, 0xAA },
	0xE3FD, { 0xE9, 0x8E, 0xB5 },
	0xE3FE, { 0xE9, 0x8E, 0x8C },
	0xE4A1, { 0xE9, 0x8E, 0x92 },
	0xE4A2, { 0xE9, 0x8E, 0xB7 },
	0xE4A3, { 0xE9, 0x8E, 0x9B },
	0xE4A4, { 0xE9, 0x8E, 0x9D },
	0xE4A5, { 0xE9, 0x8E, 0x89 },
	0xE4A6, { 0xE9, 0x8E, 0xA7 },
	0xE4A7, { 0xE9, 0x8E, 0x8E },
	0xE4A8, { 0xE9, 0x8E, 0xAA },
	0xE4A9, { 0xE9, 0x8E, 0x9E },
	0xE4AA, { 0xE9, 0x8E, 0xA6 },
	0xE4AB, { 0xE9, 0x8E, 0x95 },
	0xE4AC, { 0xE9, 0x8E, 0x88 },
	0xE4AD, { 0xE9, 0x8E, 0x99 },
	0xE4AE, { 0xE9, 0x8E, 0x9F },
	0xE4AF, { 0xE9, 0x8E, 0x80 },
	0xE4B0, { 0xE9, 0x8E, 0x8D },
	0xE4B1, { 0xE9, 0x8E, 0xB1 },
	0xE4B2, { 0xE9, 0x8E, 0x91 },
	0xE4B3, { 0xE9, 0x8E, 0xB2 },
	0xE4B4, { 0xE9, 0x8E, 0xA4 },
	0xE4B5, { 0xE9, 0x8E, 0xA8 },
	0xE4B6, { 0xE9, 0x8E, 0xB4 },
	0xE4B7, { 0xE9, 0x8E, 0xA3 },
	0xE4B8, { 0xE9, 0x97, 0x92 },
	0xE4B9, { 0xE9, 0x97, 0x93 },
	0xE4BA, { 0xE9, 0x97, 0x91 },
	0xE4BB, { 0xE9, 0x9A, 0xB3 },
	0xE4BC, { 0xE9, 0x9B, 0x97 },
	0xE4BD, { 0xE9, 0x9B, 0x9A },
	0xE4BE, { 0xE5, 0xB7, 0x82 },
	0xE4BF, { 0xE9, 0x9B, 0x9F },
	0xE4C0, { 0xE9, 0x9B, 0x98 },
	0xE4C1, { 0xE9, 0x9B, 0x9D },
	0xE4C2, { 0xE9, 0x9C, 0xA3 },
	0xE4C3, { 0xE9, 0x9C, 0xA2 },
	0xE4C4, { 0xE9, 0x9C, 0xA5 },
	0xE4C5, { 0xE9, 0x9E, 0xAC },
	0xE4C6, { 0xE9, 0x9E, 0xAE },
	0xE4C7, { 0xE9, 0x9E, 0xA8 },
	0xE4C8, { 0xE9, 0x9E, 0xAB },
	0xE4C9, { 0xE9, 0x9E, 0xA4 },
	0xE4CA, { 0xE9, 0x9E, 0xAA },
	0xE4CB, { 0xE9, 0x9E, 0xA2 },
	0xE4CC, { 0xE9, 0x9E, 0xA5 },
	0xE4CD, { 0xE9, 0x9F, 0x97 },
	0xE4CE, { 0xE9, 0x9F, 0x99 },
	0xE4CF, { 0xE9, 0x9F, 0x96 },
	0xE4D0, { 0xE9, 0x9F, 0x98 },
	0xE4D1, { 0xE9, 0x9F, 0xBA },
	0xE4D2, { 0xE9, 0xA1, 0x90 },
	0xE4D3, { 0xE9, 0xA1, 0x91 },
	0xE4D4, { 0xE9, 0xA1, 0x92 },
	0xE4D5, { 0xE9, 0xA2, 0xB8 },
	0xE4D6, { 0xE9, 0xA5, 0x81 },
	0xE4D7, { 0xE9, 0xA4, 0xBC },
	0xE4D8, { 0xE9, 0xA4, 0xBA },
	0xE4D9, { 0xE9, 0xA8, 0x8F },
	0xE4DA, { 0xE9, 0xA8, 0x8B },
	0xE4DB, { 0xE9, 0xA8, 0x89 },
	0xE4DC, { 0xE9, 0xA8, 0x8D },
	0xE4DD, { 0xE9, 0xA8, 0x84 },
	0xE4DE, { 0xE9, 0xA8, 0x91 },
	0xE4DF, { 0xE9, 0xA8, 0x8A },
	0xE4E0, { 0xE9, 0xA8, 0x85 },
	0xE4E1, { 0xE9, 0xA8, 0x87 },
	0xE4E2, { 0xE9, 0xA8, 0x86 },
	0xE4E3, { 0xE9, 0xAB, 0x80 },
	0xE4E4, { 0xE9, 0xAB, 0x9C },
	0xE4E5, { 0xE9, 0xAC, 0x88 },
	0xE4E6, { 0xE9, 0xAC, 0x84 },
	0xE4E7, { 0xE9, 0xAC, 0x85 },
	0xE4E8, { 0xE9, 0xAC, 0xA9 },
	0xE4E9, { 0xE9, 0xAC, 0xB5 },
	0xE4EA, { 0xE9, 0xAD, 0x8A },
	0xE4EB, { 0xE9, 0xAD, 0x8C },
	0xE4EC, { 0xE9, 0xAD, 0x8B },
	0xE4ED, { 0xE9, 0xAF, 0x87 },
	0xE4EE, { 0xE9, 0xAF, 0x86 },
	0xE4EF, { 0xE9, 0xAF, 0x83 },
	0xE4F0, { 0xE9, 0xAE, 0xBF },
	0xE4F1, { 0xE9, 0xAF, 0x81 },
	0xE4F2, { 0xE9, 0xAE, 0xB5 },
	0xE4F3, { 0xE9, 0xAE, 0xB8 },
	0xE4F4, { 0xE9, 0xAF, 0x93 },
	0xE4F5, { 0xE9, 0xAE, 0xB6 },
	0xE4F6, { 0xE9, 0xAF, 0x84 },
	0xE4F7, { 0xE9, 0xAE, 0xB9 },
	0xE4F8, { 0xE9, 0xAE, 0xBD },
	0xE4F9, { 0xE9, 0xB5, 0x9C },
	0xE4FA, { 0xE9, 0xB5, 0x93 },
	0xE4FB, { 0xE9, 0xB5, 0x8F },
	0xE4FC, { 0xE9, 0xB5, 0x8A },
	0xE4FD, { 0xE9, 0xB5, 0x9B },
	0xE4FE, { 0xE9, 0xB5, 0x8B },
	0xE5A1, { 0xE9, 0xB5, 0x99 },
	0xE5A2, { 0xE9, 0xB5, 0x96 },
	0xE5A3, { 0xE9, 0xB5, 0x8C },
	0xE5A4, { 0xE9, 0xB5, 0x97 },
	0xE5A5, { 0xE9, 0xB5, 0x92 },
	0xE5A6, { 0xE9, 0xB5, 0x94 },
	0xE5A7, { 0xE9, 0xB5, 0x9F },
	0xE5A8, { 0xE9, 0xB5, 0x98 },
	0xE5A9, { 0xE9, 0xB5, 0x9A },
	0xE5AA, { 0xE9, 0xBA, 0x8E },
	0xE5AB, { 0xE9, 0xBA, 0x8C },
	0xE5AC, { 0xE9, 0xBB, 0x9F },
	0xE5AD, { 0xE9, 0xBC, 0x81 },
	0xE5AE, { 0xE9, 0xBC, 0x80 },
	0xE5AF, { 0xE9, 0xBC, 0x96 },
	0xE5B0, { 0xE9, 0xBC, 0xA5 },
	0xE5B1, { 0xE9, 0xBC, 0xAB },
	0xE5B2, { 0xE9, 0xBC, 0xAA },
	0xE5B3, { 0xE9, 0xBC, 0xA9 },
	0xE5B4, { 0xE9, 0xBC, 0xA8 },
	0xE5B5, { 0xE9, 0xBD, 0x8C },
	0xE5B6, { 0xE9, 0xBD, 0x95 },
	0xE5B7, { 0xE5, 0x84, 0xB4 },
	0xE5B8, { 0xE5, 0x84, 0xB5 },
	0xE5B9, { 0xE5, 0x8A, 0x96 },
	0xE5BA, { 0xE5, 0x8B, 0xB7 },
	0xE5BB, { 0xE5, 0x8E, 0xB4 },
	0xE5BC, { 0xE5, 0x9A, 0xAB },
	0xE5BD, { 0xE5, 0x9A, 0xAD },
	0xE5BE, { 0xE5, 0x9A, 0xA6 },
	0xE5BF, { 0xE5, 0x9A, 0xA7 },
	0xE5C0, { 0xE5, 0x9A, 0xAA },
	0xE5C1, { 0xE5, 0x9A, 0xAC },
	0xE5C2, { 0xE5, 0xA3, 0x9A },
	0xE5C3, { 0xE5, 0xA3, 0x9D },
	0xE5C4, { 0xE5, 0xA3, 0x9B },
	0xE5C5, { 0xE5, 0xA4, 0x92 },
	0xE5C6, { 0xE5, 0xAC, 0xBD },
	0xE5C7, { 0xE5, 0xAC, 0xBE },
	0xE5C8, { 0xE5, 0xAC, 0xBF },
	0xE5C9, { 0xE5, 0xB7, 0x83 },
	0xE5CA, { 0xE5, 0xB9, 0xB0 },
	0xE5CB, { 0xE5, 0xBE, 0xBF },
	0xE5CC, { 0xE6, 0x87, 0xBB },
	0xE5CD, { 0xE6, 0x94, 0x87 },
	0xE5CE, { 0xE6, 0x94, 0x90 },
	0xE5CF, { 0xE6, 0x94, 0x8D },
	0xE5D0, { 0xE6, 0x94, 0x89 },
	0xE5D1, { 0xE6, 0x94, 0x8C },
	0xE5D2, { 0xE6, 0x94, 0x8E },
	0xE5D3, { 0xE6, 0x96, 0x84 },
	0xE5D4, { 0xE6, 0x97, 0x9E },
	0xE5D5, { 0xE6, 0x97, 0x9D },
	0xE5D6, { 0xE6, 0x9B, 0x9E },
	0xE5D7, { 0xE6, 0xAB, 0xA7 },
	0xE5D8, { 0xE6, 0xAB, 0xA0 },
	0xE5D9, { 0xE6, 0xAB, 0x8C },
	0xE5DA, { 0xE6, 0xAB, 0x91 },
	0xE5DB, { 0xE6, 0xAB, 0x99 },
	0xE5DC, { 0xE6, 0xAB, 0x8B },
	0xE5DD, { 0xE6, 0xAB, 0x9F },
	0xE5DE, { 0xE6, 0xAB, 0x9C },
	0xE5DF, { 0xE6, 0xAB, 0x90 },
	0xE5E0, { 0xE6, 0xAB, 0xAB },
	0xE5E1, { 0xE6, 0xAB, 0x8F },
	0xE5E2, { 0xE6, 0xAB, 0x8D },
	0xE5E3, { 0xE6, 0xAB, 0x9E },
	0xE5E4, { 0xE6, 0xAD, 0xA0 },
	0xE5E5, { 0xE6, 0xAE, 0xB0 },
	0xE5E6, { 0xE6, 0xB0, 0x8C },
	0xE5E7, { 0xE7, 0x80, 0x99 },
	0xE5E8, { 0xE7, 0x80, 0xA7 },
	0xE5E9, { 0xE7, 0x80, 0xA0 },
	0xE5EA, { 0xE7, 0x80, 0x96 },
	0xE5EB, { 0xE7, 0x80, 0xAB },
	0xE5EC, { 0xE7, 0x80, 0xA1 },
	0xE5ED, { 0xE7, 0x80, 0xA2 },
	0xE5EE, { 0xE7, 0x80, 0xA3 },
	0xE5EF, { 0xE7, 0x80, 0xA9 },
	0xE5F0, { 0xE7, 0x80, 0x97 },
	0xE5F1, { 0xE7, 0x80, 0xA4 },
	0xE5F2, { 0xE7, 0x80, 0x9C },
	0xE5F3, { 0xE7, 0x88, 0x8C },
	0xE5F4, { 0xE7, 0x88, 0x8A },
	0xE5F5, { 0xE7, 0x88, 0x87 },
	0xE5F6, { 0xE7, 0x88, 0x82 },
	0xE5F7, { 0xE7, 0x88, 0x85 },
	0xE5F8, { 0xE7, 0x8A, 0xA5 },
	0xE5F9, { 0xE7, 0x8A, 0xA6 },
	0xE5FA, { 0xE7, 0x8A, 0xA4 },
	0xE5FB, { 0xE7, 0x8A, 0xA3 },
	0xE5FC, { 0xE7, 0x8A, 0xA1 },
	0xE5FD, { 0xE7, 0x93, 0x8B },
	0xE5FE, { 0xE7, 0x93, 0x85 },
	0xE6A1, { 0xE7, 0x92, 0xB7 },
	0xE6A2, { 0xE7, 0x93, 0x83 },
	0xE6A3, { 0xE7, 0x94, 0x96 },
	0xE6A4, { 0xE7, 0x99, 0xA0 },
	0xE6A5, { 0xE7, 0x9F, 0x89 },
	0xE6A6, { 0xE7, 0x9F, 0x8A },
	0xE6A7, { 0xE7, 0x9F, 0x84 },
	0xE6A8, { 0xE7, 0x9F, 0xB1 },
	0xE6A9, { 0xE7, 0xA4, 0x9D },
	0xE6AA, { 0xE7, 0xA4, 0x9B },
	0xE6AB, { 0xE7, 0xA4, 0xA1 },
	0xE6AC, { 0xE7, 0xA4, 0x9C },
	0xE6AD, { 0xE7, 0xA4, 0x97 },
	0xE6AE, { 0xE7, 0xA4, 0x9E },
	0xE6AF, { 0xE7, 0xA6, 0xB0 },
	0xE6B0, { 0xE7, 0xA9, 0xA7 },
	0xE6B1, { 0xE7, 0xA9, 0xA8 },
	0xE6B2, { 0xE7, 0xB0, 0xB3 },
	0xE6B3, { 0xE7, 0xB0, 0xBC },
	0xE6B4, { 0xE7, 0xB0, 0xB9 },
	0xE6B5, { 0xE7, 0xB0, 0xAC },
	0xE6B6, { 0xE7, 0xB0, 0xBB },
	0xE6B7, { 0xE7, 0xB3, 0xAC },
	0xE6B8, { 0xE7, 0xB3, 0xAA },
	0xE6B9, { 0xE7, 0xB9, 0xB6 },
	0xE6BA, { 0xE7, 0xB9, 0xB5 },
	0xE6BB, { 0xE7, 0xB9, 0xB8 },
	0xE6BC, { 0xE7, 0xB9, 0xB0 },
	0xE6BD, { 0xE7, 0xB9, 0xB7 },
	0xE6BE, { 0xE7, 0xB9, 0xAF },
	0xE6BF, { 0xE7, 0xB9, 0xBA },
	0xE6C0, { 0xE7, 0xB9, 0xB2 },
	0xE6C1, { 0xE7, 0xB9, 0xB4 },
	0xE6C2, { 0xE7, 0xB9, 0xA8 },
	0xE6C3, { 0xE7, 0xBD, 0x8B },
	0xE6C4, { 0xE7, 0xBD, 0x8A },
	0xE6C5, { 0xE7, 0xBE, 0x83 },
	0xE6C6, { 0xE7, 0xBE, 0x86 },
	0xE6C7, { 0xE7, 0xBE, 0xB7 },
	0xE6C8, { 0xE7, 0xBF, 0xBD },
	0xE6C9, { 0xE7, 0xBF, 0xBE },
	0xE6CA, { 0xE8, 0x81, 0xB8 },
	0xE6CB, { 0xE8, 0x87, 0x97 },
	0xE6CC, { 0xE8, 0x87, 0x95 },
	0xE6CD, { 0xE8, 0x88, 0x8B },
	0xE6CE, { 0xE8, 0x89, 0xA4 },
	0xE6CF, { 0xE8, 0x89, 0xA1 },
	0xE6D0, { 0xE8, 0x89, 0xA3 },
	0xE6D1, { 0xE8, 0x97, 0xAB },
	0xE6D2, { 0xE8, 0x97, 0xB1 },
	0xE6D3, { 0xE8, 0x97, 0xAD },
	0xE6D4, { 0xE8, 0x97, 0x99 },
	0xE6D5, { 0xE8, 0x97, 0xA1 },
	0xE6D6, { 0xE8, 0x97, 0xA8 },
	0xE6D7, { 0xE8, 0x97, 0x9A },
	0xE6D8, { 0xE8, 0x97, 0x97 },
	0xE6D9, { 0xE8, 0x97, 0xAC },
	0xE6DA, { 0xE8, 0x97, 0xB2 },
	0xE6DB, { 0xE8, 0x97, 0xB8 },
	0xE6DC, { 0xE8, 0x97, 0x98 },
	0xE6DD, { 0xE8, 0x97, 0x9F },
	0xE6DE, { 0xE8, 0x97, 0xA3 },
	0xE6DF, { 0xE8, 0x97, 0x9C },
	0xE6E0, { 0xE8, 0x97, 0x91 },
	0xE6E1, { 0xE8, 0x97, 0xB0 },
	0xE6E2, { 0xE8, 0x97, 0xA6 },
	0xE6E3, { 0xE8, 0x97, 0xAF },
	0xE6E4, { 0xE8, 0x97, 0x9E },
	0xE6E5, { 0xE8, 0x97, 0xA2 },
	0xE6E6, { 0xE8, 0xA0, 0x80 },
	0xE6E7, { 0xE8, 0x9F, 0xBA },
	0xE6E8, { 0xE8, 0xA0, 0x83 },
	0xE6E9, { 0xE8, 0x9F, 0xB6 },
	0xE6EA, { 0xE8, 0x9F, 0xB7 },
	0xE6EB, { 0xE8, 0xA0, 0x89 },
	0xE6EC, { 0xE8, 0xA0, 0x8C },
	0xE6ED, { 0xE8, 0xA0, 0x8B },
	0xE6EE, { 0xE8, 0xA0, 0x86 },
	0xE6EF, { 0xE8, 0x9F, 0xBC },
	0xE6F0, { 0xE8, 0xA0, 0x88 },
	0xE6F1, { 0xE8, 0x9F, 0xBF },
	0xE6F2, { 0xE8, 0xA0, 0x8A },
	0xE6F3, { 0xE8, 0xA0, 0x82 },
	0xE6F4, { 0xE8, 0xA5, 0xA2 },
	0xE6F5, { 0xE8, 0xA5, 0x9A },
	0xE6F6, { 0xE8, 0xA5, 0x9B },
	0xE6F7, { 0xE8, 0xA5, 0x97 },
	0xE6F8, { 0xE8, 0xA5, 0xA1 },
	0xE6F9, { 0xE8, 0xA5, 0x9C },
	0xE6FA, { 0xE8, 0xA5, 0x98 },
	0xE6FB, { 0xE8, 0xA5, 0x9D },
	0xE6FC, { 0xE8, 0xA5, 0x99 },
	0xE6FD, { 0xE8, 0xA6, 0x88 },
	0xE6FE, { 0xE8, 0xA6, 0xB7 },
	0xE7A1, { 0xE8, 0xA6, 0xB6 },
	0xE7A2, { 0xE8, 0xA7, 0xB6 },
	0xE7A3, { 0xE8, 0xAD, 0x90 },
	0xE7A4, { 0xE8, 0xAD, 0x88 },
	0xE7A5, { 0xE8, 0xAD, 0x8A },
	0xE7A6, { 0xE8, 0xAD, 0x80 },
	0xE7A7, { 0xE8, 0xAD, 0x93 },
	0xE7A8, { 0xE8, 0xAD, 0x96 },
	0xE7A9, { 0xE8, 0xAD, 0x94 },
	0xE7AA, { 0xE8, 0xAD, 0x8B },
	0xE7AB, { 0xE8, 0xAD, 0x95 },
	0xE7AC, { 0xE8, 0xAD, 0x91 },
	0xE7AD, { 0xE8, 0xAD, 0x82 },
	0xE7AE, { 0xE8, 0xAD, 0x92 },
	0xE7AF, { 0xE8, 0xAD, 0x97 },
	0xE7B0, { 0xE8, 0xB1, 0x83 },
	0xE7B1, { 0xE8, 0xB1, 0xB7 },
	0xE7B2, { 0xE8, 0xB1, 0xB6 },
	0xE7B3, { 0xE8, 0xB2, 0x9A },
	0xE7B4, { 0xE8, 0xB4, 0x86 },
	0xE7B5, { 0xE8, 0xB4, 0x87 },
	0xE7B6, { 0xE8, 0xB4, 0x89 },
	0xE7B7, { 0xE8, 0xB6, 0xAC },
	0xE7B8, { 0xE8, 0xB6, 0xAA },
	0xE7B9, { 0xE8, 0xB6, 0xAD },
	0xE7BA, { 0xE8, 0xB6, 0xAB },
	0xE7BB, { 0xE8, 0xB9, 0xAD },
	0xE7BC, { 0xE8, 0xB9, 0xB8 },
	0xE7BD, { 0xE8, 0xB9, 0xB3 },
	0xE7BE, { 0xE8, 0xB9, 0xAA },
	0xE7BF, { 0xE8, 0xB9, 0xAF },
	0xE7C0, { 0xE8, 0xB9, 0xBB },
	0xE7C1, { 0xE8, 0xBB, 0x82 },
	0xE7C2, { 0xE8, 0xBD, 0x92 },
	0xE7C3, { 0xE8, 0xBD, 0x91 },
	0xE7C4, { 0xE8, 0xBD, 0x8F },
	0xE7C5, { 0xE8, 0xBD, 0x90 },
	0xE7C6, { 0xE8, 0xBD, 0x93 },
	0xE7C7, { 0xE8, 0xBE, 0xB4 },
	0xE7C8, { 0xE9, 0x85, 0x80 },
	0xE7C9, { 0xE9, 0x84, 0xBF },
	0xE7CA, { 0xE9, 0x86, 0xB0 },
	0xE7CB, { 0xE9, 0x86, 0xAD },
	0xE7CC, { 0xE9, 0x8F, 0x9E },
	0xE7CD, { 0xE9, 0x8F, 0x87 },
	0xE7CE, { 0xE9, 0x8F, 0x8F },
	0xE7CF, { 0xE9, 0x8F, 0x82 },
	0xE7D0, { 0xE9, 0x8F, 0x9A },
	0xE7D1, { 0xE9, 0x8F, 0x90 },
	0xE7D2, { 0xE9, 0x8F, 0xB9 },
	0xE7D3, { 0xE9, 0x8F, 0xAC },
	0xE7D4, { 0xE9, 0x8F, 0x8C },
	0xE7D5, { 0xE9, 0x8F, 0x99 },
	0xE7D6, { 0xE9, 0x8E, 0xA9 },
	0xE7D7, { 0xE9, 0x8F, 0xA6 },
	0xE7D8, { 0xE9, 0x8F, 0x8A },
	0xE7D9, { 0xE9, 0x8F, 0x94 },
	0xE7DA, { 0xE9, 0x8F, 0xAE },
	0xE7DB, { 0xE9, 0x8F, 0xA3 },
	0xE7DC, { 0xE9, 0x8F, 0x95 },
	0xE7DD, { 0xE9, 0x8F, 0x84 },
	0xE7DE, { 0xE9, 0x8F, 0x8E },
	0xE7DF, { 0xE9, 0x8F, 0x80 },
	0xE7E0, { 0xE9, 0x8F, 0x92 },
	0xE7E1, { 0xE9, 0x8E, 0xA5 },
	0xE7E2, { 0xE9, 0x8F, 0xA7 },
	0xE7E3, { 0xE9, 0x95, 0xBD },
	0xE7E4, { 0xE9, 0x97, 0x9A },
	0xE7E5, { 0xE9, 0x97, 0x9B },
	0xE7E6, { 0xE9, 0x9B, 0xA1 },
	0xE7E7, { 0xE9, 0x9C, 0xA9 },
	0xE7E8, { 0xE9, 0x9C, 0xAB },
	0xE7E9, { 0xE9, 0x9C, 0xAC },
	0xE7EA, { 0xE9, 0x9C, 0xA8 },
	0xE7EB, { 0xE9, 0x9C, 0xA6 },
	0xE7EC, { 0xE9, 0x9E, 0xB3 },
	0xE7ED, { 0xE9, 0x9E, 0xB7 },
	0xE7EE, { 0xE9, 0x9E, 0xB6 },
	0xE7EF, { 0xE9, 0x9F, 0x9D },
	0xE7F0, { 0xE9, 0x9F, 0x9E },
	0xE7F1, { 0xE9, 0x9F, 0x9F },
	0xE7F2, { 0xE9, 0xA1, 0x9C },
	0xE7F3, { 0xE9, 0xA1, 0x99 },
	0xE7F4, { 0xE9, 0xA1, 0x9D },
	0xE7F5, { 0xE9, 0xA1, 0x97 },
	0xE7F6, { 0xE9, 0xA2, 0xBF },
	0xE7F7, { 0xE9, 0xA2, 0xBD },
	0xE7F8, { 0xE9, 0xA2, 0xBB },
	0xE7F9, { 0xE9, 0xA2, 0xBE },
	0xE7FA, { 0xE9, 0xA5, 0x88 },
	0xE7FB, { 0xE9, 0xA5, 0x87 },
	0xE7FC, { 0xE9, 0xA5, 0x83 },
	0xE7FD, { 0xE9, 0xA6, 0xA6 },
	0xE7FE, { 0xE9, 0xA6, 0xA7 },
	0xE8A1, { 0xE9, 0xA8, 0x9A },
	0xE8A2, { 0xE9, 0xA8, 0x95 },
	0xE8A3, { 0xE9, 0xA8, 0xA5 },
	0xE8A4, { 0xE9, 0xA8, 0x9D },
	0xE8A5, { 0xE9, 0xA8, 0xA4 },
	0xE8A6, { 0xE9, 0xA8, 0x9B },
	0xE8A7, { 0xE9, 0xA8, 0xA2 },
	0xE8A8, { 0xE9, 0xA8, 0xA0 },
	0xE8A9, { 0xE9, 0xA8, 0xA7 },
	0xE8AA, { 0xE9, 0xA8, 0xA3 },
	0xE8AB, { 0xE9, 0xA8, 0x9E },
	0xE8AC, { 0xE9, 0xA8, 0x9C },
	0xE8AD, { 0xE9, 0xA8, 0x94 },
	0xE8AE, { 0xE9, 0xAB, 0x82 },
	0xE8AF, { 0xE9, 0xAC, 0x8B },
	0xE8B0, { 0xE9, 0xAC, 0x8A },
	0xE8B1, { 0xE9, 0xAC, 0x8E },
	0xE8B2, { 0xE9, 0xAC, 0x8C },
	0xE8B3, { 0xE9, 0xAC, 0xB7 },
	0xE8B4, { 0xE9, 0xAF, 0xAA },
	0xE8B5, { 0xE9, 0xAF, 0xAB },
	0xE8B6, { 0xE9, 0xAF, 0xA0 },
	0xE8B7, { 0xE9, 0xAF, 0x9E },
	0xE8B8, { 0xE9, 0xAF, 0xA4 },
	0xE8B9, { 0xE9, 0xAF, 0xA6 },
	0xE8BA, { 0xE9, 0xAF, 0xA2 },
	0xE8BB, { 0xE9, 0xAF, 0xB0 },
	0xE8BC, { 0xE9, 0xAF, 0x94 },
	0xE8BD, { 0xE9, 0xAF, 0x97 },
	0xE8BE, { 0xE9, 0xAF, 0xAC },
	0xE8BF, { 0xE9, 0xAF, 0x9C },
	0xE8C0, { 0xE9, 0xAF, 0x99 },
	0xE8C1, { 0xE9, 0xAF, 0xA5 },
	0xE8C2, { 0xE9, 0xAF, 0x95 },
	0xE8C3, { 0xE9, 0xAF, 0xA1 },
	0xE8C4, { 0xE9, 0xAF, 0x9A },
	0xE8C5, { 0xE9, 0xB5, 0xB7 },
	0xE8C6, { 0xE9, 0xB6, 0x81 },
	0xE8C7, { 0xE9, 0xB6, 0x8A },
	0xE8C8, { 0xE9, 0xB6, 0x84 },
	0xE8C9, { 0xE9, 0xB6, 0x88 },
	0xE8CA, { 0xE9, 0xB5, 0xB1 },
	0xE8CB, { 0xE9, 0xB6, 0x80 },
	0xE8CC, { 0xE9, 0xB5, 0xB8 },
	0xE8CD, { 0xE9, 0xB6, 0x86 },
	0xE8CE, { 0xE9, 0xB6, 0x8B },
	0xE8CF, { 0xE9, 0xB6, 0x8C },
	0xE8D0, { 0xE9, 0xB5, 0xBD },
	0xE8D1, { 0xE9, 0xB5, 0xAB },
	0xE8D2, { 0xE9, 0xB5, 0xB4 },
	0xE8D3, { 0xE9, 0xB5, 0xB5 },
	0xE8D4, { 0xE9, 0xB5, 0xB0 },
	0xE8D5, { 0xE9, 0xB5, 0xA9 },
	0xE8D6, { 0xE9, 0xB6, 0x85 },
	0xE8D7, { 0xE9, 0xB5, 0xB3 },
	0xE8D8, { 0xE9, 0xB5, 0xBB },
	0xE8D9, { 0xE9, 0xB6, 0x82 },
	0xE8DA, { 0xE9, 0xB5, 0xAF },
	0xE8DB, { 0xE9, 0xB5, 0xB9 },
	0xE8DC, { 0xE9, 0xB5, 0xBF },
	0xE8DD, { 0xE9, 0xB6, 0x87 },
	0xE8DE, { 0xE9, 0xB5, 0xA8 },
	0xE8DF, { 0xE9, 0xBA, 0x94 },
	0xE8E0, { 0xE9, 0xBA, 0x91 },
	0xE8E1, { 0xE9, 0xBB, 0x80 },
	0xE8E2, { 0xE9, 0xBB, 0xBC },
	0xE8E3, { 0xE9, 0xBC, 0xAD },
	0xE8E4, { 0xE9, 0xBD, 0x80 },
	0xE8E5, { 0xE9, 0xBD, 0x81 },
	0xE8E6, { 0xE9, 0xBD, 0x8D },
	0xE8E7, { 0xE9, 0xBD, 0x96 },
	0xE8E8, { 0xE9, 0xBD, 0x97 },
	0xE8E9, { 0xE9, 0xBD, 0x98 },
	0xE8EA, { 0xE5, 0x8C, 0xB7 },
	0xE8EB, { 0xE5, 0x9A, 0xB2 },
	0xE8EC, { 0xE5, 0x9A, 0xB5 },
	0xE8ED, { 0xE5, 0x9A, 0xB3 },
	0xE8EE, { 0xE5, 0xA3, 0xA3 },
	0xE8EF, { 0xE5, 0xAD, 0x85 },
	0xE8F0, { 0xE5, 0xB7, 0x86 },
	0xE8F1, { 0xE5, 0xB7, 0x87 },
	0xE8F2, { 0xE5, 0xBB, 0xAE },
	0xE8F3, { 0xE5, 0xBB, 0xAF },
	0xE8F4, { 0xE5, 0xBF, 0x80 },
	0xE8F5, { 0xE5, 0xBF, 0x81 },
	0xE8F6, { 0xE6, 0x87, 0xB9 },
	0xE8F7, { 0xE6, 0x94, 0x97 },
	0xE8F8, { 0xE6, 0x94, 0x96 },
	0xE8F9, { 0xE6, 0x94, 0x95 },
	0xE8FA, { 0xE6, 0x94, 0x93 },
	0xE8FB, { 0xE6, 0x97, 0x9F },
	0xE8FC, { 0xE6, 0x9B, 0xA8 },
	0xE8FD, { 0xE6, 0x9B, 0xA3 },
	0xE8FE, { 0xE6, 0x9B, 0xA4 },
	0xE9A1, { 0xE6, 0xAB, 0xB3 },
	0xE9A2, { 0xE6, 0xAB, 0xB0 },
	0xE9A3, { 0xE6, 0xAB, 0xAA },
	0xE9A4, { 0xE6, 0xAB, 0xA8 },
	0xE9A5, { 0xE6, 0xAB, 0xB9 },
	0xE9A6, { 0xE6, 0xAB, 0xB1 },
	0xE9A7, { 0xE6, 0xAB, 0xAE },
	0xE9A8, { 0xE6, 0xAB, 0xAF },
	0xE9A9, { 0xE7, 0x80, 0xBC },
	0xE9AA, { 0xE7, 0x80, 0xB5 },
	0xE9AB, { 0xE7, 0x80, 0xAF },
	0xE9AC, { 0xE7, 0x80, 0xB7 },
	0xE9AD, { 0xE7, 0x80, 0xB4 },
	0xE9AE, { 0xE7, 0x80, 0xB1 },
	0xE9AF, { 0xE7, 0x81, 0x82 },
	0xE9B0, { 0xE7, 0x80, 0xB8 },
	0xE9B1, { 0xE7, 0x80, 0xBF },
	0xE9B2, { 0xE7, 0x80, 0xBA },
	0xE9B3, { 0xE7, 0x80, 0xB9 },
	0xE9B4, { 0xE7, 0x80, 0xAA },
	0xE9B5, { 0xE7, 0x81, 0x80 },
	0xE9B6, { 0xE7, 0x80, 0xBB },
	0xE9B7, { 0xE7, 0x80, 0xB3 },
	0xE9B8, { 0xE7, 0x81, 0x81 },
	0xE9B9, { 0xE7, 0x88, 0x93 },
	0xE9BA, { 0xE7, 0x88, 0x94 },
	0xE9BB, { 0xE7, 0x8A, 0xA8 },
	0xE9BC, { 0xE7, 0x8D, 0xBD },
	0xE9BD, { 0xE7, 0x8D, 0xBC },
	0xE9BE, { 0xE7, 0x92, 0xBA },
	0xE9BF, { 0xE7, 0x9A, 0xAB },
	0xE9C0, { 0xE7, 0x9A, 0xAA },
	0xE9C1, { 0xE7, 0x9A, 0xBE },
	0xE9C2, { 0xE7, 0x9B, 0xAD },
	0xE9C3, { 0xE7, 0x9F, 0x8C },
	0xE9C4, { 0xE7, 0x9F, 0x8E },
	0xE9C5, { 0xE7, 0x9F, 0x8F },
	0xE9C6, { 0xE7, 0x9F, 0x8D },
	0xE9C7, { 0xE7, 0x9F, 0xB2 },
	0xE9C8, { 0xE7, 0xA4, 0xA5 },
	0xE9C9, { 0xE7, 0xA4, 0xA3 },
	0xE9CA, { 0xE7, 0xA4, 0xA7 },
	0xE9CB, { 0xE7, 0xA4, 0xA8 },
	0xE9CC, { 0xE7, 0xA4, 0xA4 },
	0xE9CD, { 0xE7, 0xA4, 0xA9 },
	0xE9CE, { 0xE7, 0xA6, 0xB2 },
	0xE9CF, { 0xE7, 0xA9, 0xAE },
	0xE9D0, { 0xE7, 0xA9, 0xAC },
	0xE9D1, { 0xE7, 0xA9, 0xAD },
	0xE9D2, { 0xE7, 0xAB, 0xB7 },
	0xE9D3, { 0xE7, 0xB1, 0x89 },
	0xE9D4, { 0xE7, 0xB1, 0x88 },
	0xE9D5, { 0xE7, 0xB1, 0x8A },
	0xE9D6, { 0xE7, 0xB1, 0x87 },
	0xE9D7, { 0xE7, 0xB1, 0x85 },
	0xE9D8, { 0xE7, 0xB3, 0xAE },
	0xE9D9, { 0xE7, 0xB9, 0xBB },
	0xE9DA, { 0xE7, 0xB9, 0xBE },
	0xE9DB, { 0xE7, 0xBA, 0x81 },
	0xE9DC, { 0xE7, 0xBA, 0x80 },
	0xE9DD, { 0xE7, 0xBE, 0xBA },
	0xE9DE, { 0xE7, 0xBF, 0xBF },
	0xE9DF, { 0xE8, 0x81, 0xB9 },
	0xE9E0, { 0xE8, 0x87, 0x9B },
	0xE9E1, { 0xE8, 0x87, 0x99 },
	0xE9E2, { 0xE8, 0x89, 0xA8 },
	0xE9E3, { 0xE8, 0x89, 0xA9 },
	0xE9E4, { 0xE8, 0x98, 0xA2 },
	0xE9E5, { 0xE8, 0x97, 0xBF },
	0xE9E6, { 0xE8, 0x98, 0x81 },
	0xE9E7, { 0xE8, 0x97, 0xBE },
	0xE9E8, { 0xE8, 0x98, 0x9B },
	0xE9E9, { 0xE8, 0x98, 0x80 },
	0xE9EA, { 0xE8, 0x97, 0xB6 },
	0xE9EB, { 0xE8, 0x98, 0x84 },
	0xE9EC, { 0xE8, 0x98, 0x89 },
	0xE9ED, { 0xE8, 0x98, 0x85 },
	0xE9EE, { 0xE8, 0x98, 0x8C },
	0xE9EF, { 0xE8, 0x97, 0xBD },
	0xE9F0, { 0xE8, 0xA0, 0x99 },
	0xE9F1, { 0xE8, 0xA0, 0x90 },
	0xE9F2, { 0xE8, 0xA0, 0x91 },
	0xE9F3, { 0xE8, 0xA0, 0x97 },
	0xE9F4, { 0xE8, 0xA0, 0x93 },
	0xE9F5, { 0xE8, 0xA0, 0x96 },
	0xE9F6, { 0xE8, 0xA5, 0xA3 },
	0xE9F7, { 0xE8, 0xA5, 0xA6 },
	0xE9F8, { 0xE8, 0xA6, 0xB9 },
	0xE9F9, { 0xE8, 0xA7, 0xB7 },
	0xE9FA, { 0xE8, 0xAD, 0xA0 },
	0xE9FB, { 0xE8, 0xAD, 0xAA },
	0xE9FC, { 0xE8, 0xAD, 0x9D },
	0xE9FD, { 0xE8, 0xAD, 0xA8 },
	0xE9FE, { 0xE8, 0xAD, 0xA3 },
	0xEAA1, { 0xE8, 0xAD, 0xA5 },
	0xEAA2, { 0xE8, 0xAD, 0xA7 },
	0xEAA3, { 0xE8, 0xAD, 0xAD },
	0xEAA4, { 0xE8, 0xB6, 0xAE },
	0xEAA5, { 0xE8, 0xBA, 0x86 },
	0xEAA6, { 0xE8, 0xBA, 0x88 },
	0xEAA7, { 0xE8, 0xBA, 0x84 },
	0xEAA8, { 0xE8, 0xBD, 0x99 },
	0xEAA9, { 0xE8, 0xBD, 0x96 },
	0xEAAA, { 0xE8, 0xBD, 0x97 },
	0xEAAB, { 0xE8, 0xBD, 0x95 },
	0xEAAC, { 0xE8, 0xBD, 0x98 },
	0xEAAD, { 0xE8, 0xBD, 0x9A },
	0xEAAE, { 0xE9, 0x82, 0x8D },
	0xEAAF, { 0xE9, 0x85, 0x83 },
	0xEAB0, { 0xE9, 0x85, 0x81 },
	0xEAB1, { 0xE9, 0x86, 0xB7 },
	0xEAB2, { 0xE9, 0x86, 0xB5 },
	0xEAB3, { 0xE9, 0x86, 0xB2 },
	0xEAB4, { 0xE9, 0x86, 0xB3 },
	0xEAB5, { 0xE9, 0x90, 0x8B },
	0xEAB6, { 0xE9, 0x90, 0x93 },
	0xEAB7, { 0xE9, 0x8F, 0xBB },
	0xEAB8, { 0xE9, 0x90, 0xA0 },
	0xEAB9, { 0xE9, 0x90, 0x8F },
	0xEABA, { 0xE9, 0x90, 0x94 },
	0xEABB, { 0xE9, 0x8F, 0xBE },
	0xEABC, { 0xE9, 0x90, 0x95 },
	0xEABD, { 0xE9, 0x90, 0x90 },
	0xEABE, { 0xE9, 0x90, 0xA8 },
	0xEABF, { 0xE9, 0x90, 0x99 },
	0xEAC0, { 0xE9, 0x90, 0x8D },
	0xEAC1, { 0xE9, 0x8F, 0xB5 },
	0xEAC2, { 0xE9, 0x90, 0x80 },
	0xEAC3, { 0xE9, 0x8F, 0xB7 },
	0xEAC4, { 0xE9, 0x90, 0x87 },
	0xEAC5, { 0xE9, 0x90, 0x8E },
	0xEAC6, { 0xE9, 0x90, 0x96 },
	0xEAC7, { 0xE9, 0x90, 0x92 },
	0xEAC8, { 0xE9, 0x8F, 0xBA },
	0xEAC9, { 0xE9, 0x90, 0x89 },
	0xEACA, { 0xE9, 0x8F, 0xB8 },
	0xEACB, { 0xE9, 0x90, 0xBC },
	0xEACC, { 0xE9, 0x90, 0x8A },
	0xEACD, { 0xE9, 0x8F, 0xBF },
	0xEACE, { 0xE9, 0x8F, 0xBC },
	0xEACF, { 0xE9, 0x90, 0x8C },
	0xEAD0, { 0xE9, 0x8F, 0xB6 },
	0xEAD1, { 0xE9, 0x90, 0x91 },
	0xEAD2, { 0xE9, 0x90, 0x86 },
	0xEAD3, { 0xE9, 0x97, 0x9E },
	0xEAD4, { 0xE9, 0x97, 0xA0 },
	0xEAD5, { 0xE9, 0x97, 0x9F },
	0xEAD6, { 0xE9, 0x9C, 0xAE },
	0xEAD7, { 0xE9, 0x9C, 0xAF },
	0xEAD8, { 0xE9, 0x9E, 0xB9 },
	0xEAD9, { 0xE9, 0x9E, 0xBB },
	0xEADA, { 0xE9, 0x9F, 0xBD },
	0xEADB, { 0xE9, 0x9F, 0xBE },
	0xEADC, { 0xE9, 0xA1, 0xA0 },
	0xEADD, { 0xE9, 0xA1, 0xA2 },
	0xEADE, { 0xE9, 0xA1, 0xA3 },
	0xEADF, { 0xE9, 0xA1, 0x9F },
	0xEAE0, { 0xE9, 0xA3, 0x81 },
	0xEAE1, { 0xE9, 0xA3, 0x82 },
	0xEAE2, { 0xE9, 0xA5, 0x90 },
	0xEAE3, { 0xE9, 0xA5, 0x8E },
	0xEAE4, { 0xE9, 0xA5, 0x99 },
	0xEAE5, { 0xE9, 0xA5, 0x8C },
	0xEAE6, { 0xE9, 0xA5, 0x8B },
	0xEAE7, { 0xE9, 0xA5, 0x93 },
	0xEAE8, { 0xE9, 0xA8, 0xB2 },
	0xEAE9, { 0xE9, 0xA8, 0xB4 },
	0xEAEA, { 0xE9, 0xA8, 0xB1 },
	0xEAEB, { 0xE9, 0xA8, 0xAC },
	0xEAEC, { 0xE9, 0xA8, 0xAA },
	0xEAED, { 0xE9, 0xA8, 0xB6 },
	0xEAEE, { 0xE9, 0xA8, 0xA9 },
	0xEAEF, { 0xE9, 0xA8, 0xAE },
	0xEAF0, { 0xE9, 0xA8, 0xB8 },
	0xEAF1, { 0xE9, 0xA8, 0xAD },
	0xEAF2, { 0xE9, 0xAB, 0x87 },
	0xEAF3, { 0xE9, 0xAB, 0x8A },
	0xEAF4, { 0xE9, 0xAB, 0x86 },
	0xEAF5, { 0xE9, 0xAC, 0x90 },
	0xEAF6, { 0xE9, 0xAC, 0x92 },
	0xEAF7, { 0xE9, 0xAC, 0x91 },
	0xEAF8, { 0xE9, 0xB0, 0x8B },
	0xEAF9, { 0xE9, 0xB0, 0x88 },
	0xEAFA, { 0xE9, 0xAF, 0xB7 },
	0xEAFB, { 0xE9, 0xB0, 0x85 },
	0xEAFC, { 0xE9, 0xB0, 0x92 },
	0xEAFD, { 0xE9, 0xAF, 0xB8 },
	0xEAFE, { 0xE9, 0xB1, 0x80 },
	0xEBA1, { 0xE9, 0xB0, 0x87 },
	0xEBA2, { 0xE9, 0xB0, 0x8E },
	0xEBA3, { 0xE9, 0xB0, 0x86 },
	0xEBA4, { 0xE9, 0xB0, 0x97 },
	0xEBA5, { 0xE9, 0xB0, 0x94 },
	0xEBA6, { 0xE9, 0xB0, 0x89 },
	0xEBA7, { 0xE9, 0xB6, 0x9F },
	0xEBA8, { 0xE9, 0xB6, 0x99 },
	0xEBA9, { 0xE9, 0xB6, 0xA4 },
	0xEBAA, { 0xE9, 0xB6, 0x9D },
	0xEBAB, { 0xE9, 0xB6, 0x92 },
	0xEBAC, { 0xE9, 0xB6, 0x98 },
	0xEBAD, { 0xE9, 0xB6, 0x90 },
	0xEBAE, { 0xE9, 0xB6, 0x9B },
	0xEBAF, { 0xE9, 0xB6, 0xA0 },
	0xEBB0, { 0xE9, 0xB6, 0x94 },
	0xEBB1, { 0xE9, 0xB6, 0x9C },
	0xEBB2, { 0xE9, 0xB6, 0xAA },
	0xEBB3, { 0xE9, 0xB6, 0x97 },
	0xEBB4, { 0xE9, 0xB6, 0xA1 },
	0xEBB5, { 0xE9, 0xB6, 0x9A },
	0xEBB6, { 0xE9, 0xB6, 0xA2 },
	0xEBB7, { 0xE9, 0xB6, 0xA8 },
	0xEBB8, { 0xE9, 0xB6, 0x9E },
	0xEBB9, { 0xE9, 0xB6, 0xA3 },
	0xEBBA, { 0xE9, 0xB6, 0xBF },
	0xEBBB, { 0xE9, 0xB6, 0xA9 },
	0xEBBC, { 0xE9, 0xB6, 0x96 },
	0xEBBD, { 0xE9, 0xB6, 0xA6 },
	0xEBBE, { 0xE9, 0xB6, 0xA7 },
	0xEBBF, { 0xE9, 0xBA, 0x99 },
	0xEBC0, { 0xE9, 0xBA, 0x9B },
	0xEBC1, { 0xE9, 0xBA, 0x9A },
	0xEBC2, { 0xE9, 0xBB, 0xA5 },
	0xEBC3, { 0xE9, 0xBB, 0xA4 },
	0xEBC4, { 0xE9, 0xBB, 0xA7 },
	0xEBC5, { 0xE9, 0xBB, 0xA6 },
	0xEBC6, { 0xE9, 0xBC, 0xB0 },
	0xEBC7, { 0xE9, 0xBC, 0xAE },
	0xEBC8, { 0xE9, 0xBD, 0x9B },
	0xEBC9, { 0xE9, 0xBD, 0xA0 },
	0xEBCA, { 0xE9, 0xBD, 0x9E },
	0xEBCB, { 0xE9, 0xBD, 0x9D },
	0xEBCC, { 0xE9, 0xBD, 0x99 },
	0xEBCD, { 0xE9, 0xBE, 0x91 },
	0xEBCE, { 0xE5, 0x84, 0xBA },
	0xEBCF, { 0xE5, 0x84, 0xB9 },
	0xEBD0, { 0xE5, 0x8A, 0x98 },
	0xEBD1, { 0xE5, 0x8A, 0x97 },
	0xEBD2, { 0xE5, 0x9B, 0x83 },
	0xEBD3, { 0xE5, 0x9A, 0xBD },
	0xEBD4, { 0xE5, 0x9A, 0xBE },
	0xEBD5, { 0xE5, 0xAD, 0x88 },
	0xEBD6, { 0xE5, 0xAD, 0x87 },
	0xEBD7, { 0xE5, 0xB7, 0x8B },
	0xEBD8, { 0xE5, 0xB7, 0x8F },
	0xEBD9, { 0xE5, 0xBB, 0xB1 },
	0xEBDA, { 0xE6, 0x87, 0xBD },
	0xEBDB, { 0xE6, 0x94, 0x9B },
	0xEBDC, { 0xE6, 0xAC, 0x82 },
	0xEBDD, { 0xE6, 0xAB, 0xBC },
	0xEBDE, { 0xE6, 0xAC, 0x83 },
	0xEBDF, { 0xE6, 0xAB, 0xB8 },
	0xEBE0, { 0xE6, 0xAC, 0x80 },
	0xEBE1, { 0xE7, 0x81, 0x83 },
	0xEBE2, { 0xE7, 0x81, 0x84 },
	0xEBE3, { 0xE7, 0x81, 0x8A },
	0xEBE4, { 0xE7, 0x81, 0x88 },
	0xEBE5, { 0xE7, 0x81, 0x89 },
	0xEBE6, { 0xE7, 0x81, 0x85 },
	0xEBE7, { 0xE7, 0x81, 0x86 },
	0xEBE8, { 0xE7, 0x88, 0x9D },
	0xEBE9, { 0xE7, 0x88, 0x9A },
	0xEBEA, { 0xE7, 0x88, 0x99 },
	0xEBEB, { 0xE7, 0x8D, 0xBE },
	0xEBEC, { 0xE7, 0x94, 0x97 },
	0xEBED, { 0xE7, 0x99, 0xAA },
	0xEBEE, { 0xE7, 0x9F, 0x90 },
	0xEBEF, { 0xE7, 0xA4, 0xAD },
	0xEBF0, { 0xE7, 0xA4, 0xB1 },
	0xEBF1, { 0xE7, 0xA4, 0xAF },
	0xEBF2, { 0xE7, 0xB1, 0x94 },
	0xEBF3, { 0xE7, 0xB1, 0x93 },
	0xEBF4, { 0xE7, 0xB3, 0xB2 },
	0xEBF5, { 0xE7, 0xBA, 0x8A },
	0xEBF6, { 0xE7, 0xBA, 0x87 },
	0xEBF7, { 0xE7, 0xBA, 0x88 },
	0xEBF8, { 0xE7, 0xBA, 0x8B },
	0xEBF9, { 0xE7, 0xBA, 0x86 },
	0xEBFA, { 0xE7, 0xBA, 0x8D },
	0xEBFB, { 0xE7, 0xBD, 0x8D },
	0xEBFC, { 0xE7, 0xBE, 0xBB },
	0xEBFD, { 0xE8, 0x80, 0xB0 },
	0xEBFE, { 0xE8, 0x87, 0x9D },
	0xECA1, { 0xE8, 0x98, 0x98 },
	0xECA2, { 0xE8, 0x98, 0xAA },
	0xECA3, { 0xE8, 0x98, 0xA6 },
	0xECA4, { 0xE8, 0x98, 0x9F },
	0xECA5, { 0xE8, 0x98, 0xA3 },
	0xECA6, { 0xE8, 0x98, 0x9C },
	0xECA7, { 0xE8, 0x98, 0x99 },
	0xECA8, { 0xE8, 0x98, 0xA7 },
	0xECA9, { 0xE8, 0x98, 0xAE },
	0xECAA, { 0xE8, 0x98, 0xA1 },
	0xECAB, { 0xE8, 0x98, 0xA0 },
	0xECAC, { 0xE8, 0x98, 0xA9 },
	0xECAD, { 0xE8, 0x98, 0x9E },
	0xECAE, { 0xE8, 0x98, 0xA5 },
	0xECAF, { 0xE8, 0xA0, 0xA9 },
	0xECB0, { 0xE8, 0xA0, 0x9D },
	0xECB1, { 0xE8, 0xA0, 0x9B },
	0xECB2, { 0xE8, 0xA0, 0xA0 },
	0xECB3, { 0xE8, 0xA0, 0xA4 },
	0xECB4, { 0xE8, 0xA0, 0x9C },
	0xECB5, { 0xE8, 0xA0, 0xAB },
	0xECB6, { 0xE8, 0xA1, 0x8A },
	0xECB7, { 0xE8, 0xA5, 0xAD },
	0xECB8, { 0xE8, 0xA5, 0xA9 },
	0xECB9, { 0xE8, 0xA5, 0xAE },
	0xECBA, { 0xE8, 0xA5, 0xAB },
	0xECBB, { 0xE8, 0xA7, 0xBA },
	0xECBC, { 0xE8, 0xAD, 0xB9 },
	0xECBD, { 0xE8, 0xAD, 0xB8 },
	0xECBE, { 0xE8, 0xAD, 0x85 },
	0xECBF, { 0xE8, 0xAD, 0xBA },
	0xECC0, { 0xE8, 0xAD, 0xBB },
	0xECC1, { 0xE8, 0xB4, 0x90 },
	0xECC2, { 0xE8, 0xB4, 0x94 },
	0xECC3, { 0xE8, 0xB6, 0xAF },
	0xECC4, { 0xE8, 0xBA, 0x8E },
	0xECC5, { 0xE8, 0xBA, 0x8C },
	0xECC6, { 0xE8, 0xBD, 0x9E },
	0xECC7, { 0xE8, 0xBD, 0x9B },
	0xECC8, { 0xE8, 0xBD, 0x9D },
	0xECC9, { 0xE9, 0x85, 0x86 },
	0xECCA, { 0xE9, 0x85, 0x84 },
	0xECCB, { 0xE9, 0x85, 0x85 },
	0xECCC, { 0xE9, 0x86, 0xB9 },
	0xECCD, { 0xE9, 0x90, 0xBF },
	0xECCE, { 0xE9, 0x90, 0xBB },
	0xECCF, { 0xE9, 0x90, 0xB6 },
	0xECD0, { 0xE9, 0x90, 0xA9 },
	0xECD1, { 0xE9, 0x90, 0xBD },
	0xECD2, { 0xE9, 0x90, 0xB0 },
	0xECD3, { 0xE9, 0x90, 0xB9 },
	0xECD4, { 0xE9, 0x90, 0xAA },
	0xECD5, { 0xE9, 0x90, 0xB7 },
	0xECD6, { 0xE9, 0x90, 0xAC },
	0xECD7, { 0xE9, 0x91, 0x80 },
	0xECD8, { 0xE9, 0x90, 0xB1 },
	0xECD9, { 0xE9, 0x97, 0xA5 },
	0xECDA, { 0xE9, 0x97, 0xA4 },
	0xECDB, { 0xE9, 0x97, 0xA3 },
	0xECDC, { 0xE9, 0x9C, 0xB5 },
	0xECDD, { 0xE9, 0x9C, 0xBA },
	0xECDE, { 0xE9, 0x9E, 0xBF },
	0xECDF, { 0xE9, 0x9F, 0xA1 },
	0xECE0, { 0xE9, 0xA1, 0xA4 },
	0xECE1, { 0xE9, 0xA3, 0x89 },
	0xECE2, { 0xE9, 0xA3, 0x86 },
	0xECE3, { 0xE9, 0xA3, 0x80 },
	0xECE4, { 0xE9, 0xA5, 0x98 },
	0xECE5, { 0xE9, 0xA5, 0x96 },
	0xECE6, { 0xE9, 0xA8, 0xB9 },
	0xECE7, { 0xE9, 0xA8, 0xBD },
	0xECE8, { 0xE9, 0xA9, 0x86 },
	0xECE9, { 0xE9, 0xA9, 0x84 },
	0xECEA, { 0xE9, 0xA9, 0x82 },
	0xECEB, { 0xE9, 0xA9, 0x81 },
	0xECEC, { 0xE9, 0xA8, 0xBA },
	0xECED, { 0xE9, 0xA8, 0xBF },
	0xECEE, { 0xE9, 0xAB, 0x8D },
	0xECEF, { 0xE9, 0xAC, 0x95 },
	0xECF0, { 0xE9, 0xAC, 0x97 },
	0xECF1, { 0xE9, 0xAC, 0x98 },
	0xECF2, { 0xE9, 0xAC, 0x96 },
	0xECF3, { 0xE9, 0xAC, 0xBA },
	0xECF4, { 0xE9, 0xAD, 0x92 },
	0xECF5, { 0xE9, 0xB0, 0xAB },
	0xECF6, { 0xE9, 0xB0, 0x9D },
	0xECF7, { 0xE9, 0xB0, 0x9C },
	0xECF8, { 0xE9, 0xB0, 0xAC },
	0xECF9, { 0xE9, 0xB0, 0xA3 },
	0xECFA, { 0xE9, 0xB0, 0xA8 },
	0xECFB, { 0xE9, 0xB0, 0xA9 },
	0xECFC, { 0xE9, 0xB0, 0xA4 },
	0xECFD, { 0xE9, 0xB0, 0xA1 },
	0xECFE, { 0xE9, 0xB6, 0xB7 },
	0xEDA1, { 0xE9, 0xB6, 0xB6 },
	0xEDA2, { 0xE9, 0xB6, 0xBC },
	0xEDA3, { 0xE9, 0xB7, 0x81 },
	0xEDA4, { 0xE9, 0xB7, 0x87 },
	0xEDA5, { 0xE9, 0xB7, 0x8A },
	0xEDA6, { 0xE9, 0xB7, 0x8F },
	0xEDA7, { 0xE9, 0xB6, 0xBE },
	0xEDA8, { 0xE9, 0xB7, 0x85 },
	0xEDA9, { 0xE9, 0xB7, 0x83 },
	0xEDAA, { 0xE9, 0xB6, 0xBB },
	0xEDAB, { 0xE9, 0xB6, 0xB5 },
	0xEDAC, { 0xE9, 0xB7, 0x8E },
	0xEDAD, { 0xE9, 0xB6, 0xB9 },
	0xEDAE, { 0xE9, 0xB6, 0xBA },
	0xEDAF, { 0xE9, 0xB6, 0xAC },
	0xEDB0, { 0xE9, 0xB7, 0x88 },
	0xEDB1, { 0xE9, 0xB6, 0xB1 },
	0xEDB2, { 0xE9, 0xB6, 0xAD },
	0xEDB3, { 0xE9, 0xB7, 0x8C },
	0xEDB4, { 0xE9, 0xB6, 0xB3 },
	0xEDB5, { 0xE9, 0xB7, 0x8D },
	0xEDB6, { 0xE9, 0xB6, 0xB2 },
	0xEDB7, { 0xE9, 0xB9, 0xBA },
	0xEDB8, { 0xE9, 0xBA, 0x9C },
	0xEDB9, { 0xE9, 0xBB, 0xAB },
	0xEDBA, { 0xE9, 0xBB, 0xAE },
	0xEDBB, { 0xE9, 0xBB, 0xAD },
	0xEDBC, { 0xE9, 0xBC, 0x9B },
	0xEDBD, { 0xE9, 0xBC, 0x98 },
	0xEDBE, { 0xE9, 0xBC, 0x9A },
	0xEDBF, { 0xE9, 0xBC, 0xB1 },
	0xEDC0, { 0xE9, 0xBD, 0x8E },
	0xEDC1, { 0xE9, 0xBD, 0xA5 },
	0xEDC2, { 0xE9, 0xBD, 0xA4 },
	0xEDC3, { 0xE9, 0xBE, 0x92 },
	0xEDC4, { 0xE4, 0xBA, 0xB9 },
	0xEDC5, { 0xE5, 0x9B, 0x86 },
	0xEDC6, { 0xE5, 0x9B, 0x85 },
	0xEDC7, { 0xE5, 0x9B, 0x8B },
	0xEDC8, { 0xE5, 0xA5, 0xB1 },
	0xEDC9, { 0xE5, 0xAD, 0x8B },
	0xEDCA, { 0xE5, 0xAD, 0x8C },
	0xEDCB, { 0xE5, 0xB7, 0x95 },
	0xEDCC, { 0xE5, 0xB7, 0x91 },
	0xEDCD, { 0xE5, 0xBB, 0xB2 },
	0xEDCE, { 0xE6, 0x94, 0xA1 },
	0xEDCF, { 0xE6, 0x94, 0xA0 },
	0xEDD0, { 0xE6, 0x94, 0xA6 },
	0xEDD1, { 0xE6, 0x94, 0xA2 },
	0xEDD2, { 0xE6, 0xAC, 0x8B },
	0xEDD3, { 0xE6, 0xAC, 0x88 },
	0xEDD4, { 0xE6, 0xAC, 0x89 },
	0xEDD5, { 0xE6, 0xB0, 0x8D },
	0xEDD6, { 0xE7, 0x81, 0x95 },
	0xEDD7, { 0xE7, 0x81, 0x96 },
	0xEDD8, { 0xE7, 0x81, 0x97 },
	0xEDD9, { 0xE7, 0x81, 0x92 },
	0xEDDA, { 0xE7, 0x88, 0x9E },
	0xEDDB, { 0xE7, 0x88, 0x9F },
	0xEDDC, { 0xE7, 0x8A, 0xA9 },
	0xEDDD, { 0xE7, 0x8D, 0xBF },
	0xEDDE, { 0xE7, 0x93, 0x98 },
	0xEDDF, { 0xE7, 0x93, 0x95 },
	0xEDE0, { 0xE7, 0x93, 0x99 },
	0xEDE1, { 0xE7, 0x93, 0x97 },
	0xEDE2, { 0xE7, 0x99, 0xAD },
	0xEDE3, { 0xE7, 0x9A, 0xAD },
	0xEDE4, { 0xE7, 0xA4, 0xB5 },
	0xEDE5, { 0xE7, 0xA6, 0xB4 },
	0xEDE6, { 0xE7, 0xA9, 0xB0 },
	0xEDE7, { 0xE7, 0xA9, 0xB1 },
	0xEDE8, { 0xE7, 0xB1, 0x97 },
	0xEDE9, { 0xE7, 0xB1, 0x9C },
	0xEDEA, { 0xE7, 0xB1, 0x99 },
	0xEDEB, { 0xE7, 0xB1, 0x9B },
	0xEDEC, { 0xE7, 0xB1, 0x9A },
	0xEDED, { 0xE7, 0xB3, 0xB4 },
	0xEDEE, { 0xE7, 0xB3, 0xB1 },
	0xEDEF, { 0xE7, 0xBA, 0x91 },
	0xEDF0, { 0xE7, 0xBD, 0x8F },
	0xEDF1, { 0xE7, 0xBE, 0x87 },
	0xEDF2, { 0xE8, 0x87, 0x9E },
	0xEDF3, { 0xE8, 0x89, 0xAB },
	0xEDF4, { 0xE8, 0x98, 0xB4 },
	0xEDF5, { 0xE8, 0x98, 0xB5 },
	0xEDF6, { 0xE8, 0x98, 0xB3 },
	0xEDF7, { 0xE8, 0x98, 0xAC },
	0xEDF8, { 0xE8, 0x98, 0xB2 },
	0xEDF9, { 0xE8, 0x98, 0xB6 },
	0xEDFA, { 0xE8, 0xA0, 0xAC },
	0xEDFB, { 0xE8, 0xA0, 0xA8 },
	0xEDFC, { 0xE8, 0xA0, 0xA6 },
	0xEDFD, { 0xE8, 0xA0, 0xAA },
	0xEDFE, { 0xE8, 0xA0, 0xA5 },
	0xEEA1, { 0xE8, 0xA5, 0xB1 },
	0xEEA2, { 0xE8, 0xA6, 0xBF },
	0xEEA3, { 0xE8, 0xA6, 0xBE },
	0xEEA4, { 0xE8, 0xA7, 0xBB },
	0xEEA5, { 0xE8, 0xAD, 0xBE },
	0xEEA6, { 0xE8, 0xAE, 0x84 },
	0xEEA7, { 0xE8, 0xAE, 0x82 },
	0xEEA8, { 0xE8, 0xAE, 0x86 },
	0xEEA9, { 0xE8, 0xAE, 0x85 },
	0xEEAA, { 0xE8, 0xAD, 0xBF },
	0xEEAB, { 0xE8, 0xB4, 0x95 },
	0xEEAC, { 0xE8, 0xBA, 0x95 },
	0xEEAD, { 0xE8, 0xBA, 0x94 },
	0xEEAE, { 0xE8, 0xBA, 0x9A },
	0xEEAF, { 0xE8, 0xBA, 0x92 },
	0xEEB0, { 0xE8, 0xBA, 0x90 },
	0xEEB1, { 0xE8, 0xBA, 0x96 },
	0xEEB2, { 0xE8, 0xBA, 0x97 },
	0xEEB3, { 0xE8, 0xBD, 0xA0 },
	0xEEB4, { 0xE8, 0xBD, 0xA2 },
	0xEEB5, { 0xE9, 0x85, 0x87 },
	0xEEB6, { 0xE9, 0x91, 0x8C },
	0xEEB7, { 0xE9, 0x91, 0x90 },
	0xEEB8, { 0xE9, 0x91, 0x8A },
	0xEEB9, { 0xE9, 0x91, 0x8B },
	0xEEBA, { 0xE9, 0x91, 0x8F },
	0xEEBB, { 0xE9, 0x91, 0x87 },
	0xEEBC, { 0xE9, 0x91, 0x85 },
	0xEEBD, { 0xE9, 0x91, 0x88 },
	0xEEBE, { 0xE9, 0x91, 0x89 },
	0xEEBF, { 0xE9, 0x91, 0x86 },
	0xEEC0, { 0xE9, 0x9C, 0xBF },
	0xEEC1, { 0xE9, 0x9F, 0xA3 },
	0xEEC2, { 0xE9, 0xA1, 0xAA },
	0xEEC3, { 0xE9, 0xA1, 0xA9 },
	0xEEC4, { 0xE9, 0xA3, 0x8B },
	0xEEC5, { 0xE9, 0xA5, 0x94 },
	0xEEC6, { 0xE9, 0xA5, 0x9B },
	0xEEC7, { 0xE9, 0xA9, 0x8E },
	0xEEC8, { 0xE9, 0xA9, 0x93 },
	0xEEC9, { 0xE9, 0xA9, 0x94 },
	0xEECA, { 0xE9, 0xA9, 0x8C },
	0xEECB, { 0xE9, 0xA9, 0x8F },
	0xEECC, { 0xE9, 0xA9, 0x88 },
	0xEECD, { 0xE9, 0xA9, 0x8A },
	0xEECE, { 0xE9, 0xA9, 0x89 },
	0xEECF, { 0xE9, 0xA9, 0x92 },
	0xEED0, { 0xE9, 0xA9, 0x90 },
	0xEED1, { 0xE9, 0xAB, 0x90 },
	0xEED2, { 0xE9, 0xAC, 0x99 },
	0xEED3, { 0xE9, 0xAC, 0xAB },
	0xEED4, { 0xE9, 0xAC, 0xBB },
	0xEED5, { 0xE9, 0xAD, 0x96 },
	0xEED6, { 0xE9, 0xAD, 0x95 },
	0xEED7, { 0xE9, 0xB1, 0x86 },
	0xEED8, { 0xE9, 0xB1, 0x88 },
	0xEED9, { 0xE9, 0xB0, 0xBF },
	0xEEDA, { 0xE9, 0xB1, 0x84 },
	0xEEDB, { 0xE9, 0xB0, 0xB9 },
	0xEEDC, { 0xE9, 0xB0, 0xB3 },
	0xEEDD, { 0xE9, 0xB1, 0x81 },
	0xEEDE, { 0xE9, 0xB0, 0xBC },
	0xEEDF, { 0xE9, 0xB0, 0xB7 },
	0xEEE0, { 0xE9, 0xB0, 0xB4 },
	0xEEE1, { 0xE9, 0xB0, 0xB2 },
	0xEEE2, { 0xE9, 0xB0, 0xBD },
	0xEEE3, { 0xE9, 0xB0, 0xB6 },
	0xEEE4, { 0xE9, 0xB7, 0x9B },
	0xEEE5, { 0xE9, 0xB7, 0x92 },
	0xEEE6, { 0xE9, 0xB7, 0x9E },
	0xEEE7, { 0xE9, 0xB7, 0x9A },
	0xEEE8, { 0xE9, 0xB7, 0x8B },
	0xEEE9, { 0xE9, 0xB7, 0x90 },
	0xEEEA, { 0xE9, 0xB7, 0x9C },
	0xEEEB, { 0xE9, 0xB7, 0x91 },
	0xEEEC, { 0xE9, 0xB7, 0x9F },
	0xEEED, { 0xE9, 0xB7, 0xA9 },
	0xEEEE, { 0xE9, 0xB7, 0x99 },
	0xEEEF, { 0xE9, 0xB7, 0x98 },
	0xEEF0, { 0xE9, 0xB7, 0x96 },
	0xEEF1, { 0xE9, 0xB7, 0xB5 },
	0xEEF2, { 0xE9, 0xB7, 0x95 },
	0xEEF3, { 0xE9, 0xB7, 0x9D },
	0xEEF4, { 0xE9, 0xBA, 0xB6 },
	0xEEF5, { 0xE9, 0xBB, 0xB0 },
	0xEEF6, { 0xE9, 0xBC, 0xB5 },
	0xEEF7, { 0xE9, 0xBC, 0xB3 },
	0xEEF8, { 0xE9, 0xBC, 0xB2 },
	0xEEF9, { 0xE9, 0xBD, 0x82 },
	0xEEFA, { 0xE9, 0xBD, 0xAB },
	0xEEFB, { 0xE9, 0xBE, 0x95 },
	0xEEFC, { 0xE9, 0xBE, 0xA2 },
	0xEEFD, { 0xE5, 0x84, 0xBD },
	0xEEFE, { 0xE5, 0x8A, 0x99 },
	0xEFA1, { 0xE5, 0xA3, 0xA8 },
	0xEFA2, { 0xE5, 0xA3, 0xA7 },
	0xEFA3, { 0xE5, 0xA5, 0xB2 },
	0xEFA4, { 0xE5, 0xAD, 0x8D },
	0xEFA5, { 0xE5, 0xB7, 0x98 },
	0xEFA6, { 0xE8, 0xA0, 0xAF },
	0xEFA7, { 0xE5, 0xBD, 0x8F },
	0xEFA8, { 0xE6, 0x88, 0x81 },
	0xEFA9, { 0xE6, 0x88, 0x83 },
	0xEFAA, { 0xE6, 0x88, 0x84 },
	0xEFAB, { 0xE6, 0x94, 0xA9 },
	0xEFAC, { 0xE6, 0x94, 0xA5 },
	0xEFAD, { 0xE6, 0x96, 0x96 },
	0xEFAE, { 0xE6, 0x9B, 0xAB },
	0xEFAF, { 0xE6, 0xAC, 0x91 },
	0xEFB0, { 0xE6, 0xAC, 0x92 },
	0xEFB1, { 0xE6, 0xAC, 0x8F },
	0xEFB2, { 0xE6, 0xAF, 0x8A },
	0xEFB3, { 0xE7, 0x81, 0x9B },
	0xEFB4, { 0xE7, 0x81, 0x9A },
	0xEFB5, { 0xE7, 0x88, 0xA2 },
	0xEFB6, { 0xE7, 0x8E, 0x82 },
	0xEFB7, { 0xE7, 0x8E, 0x81 },
	0xEFB8, { 0xE7, 0x8E, 0x83 },
	0xEFB9, { 0xE7, 0x99, 0xB0 },
	0xEFBA, { 0xE7, 0x9F, 0x94 },
	0xEFBB, { 0xE7, 0xB1, 0xA7 },
	0xEFBC, { 0xE7, 0xB1, 0xA6 },
	0xEFBD, { 0xE7, 0xBA, 0x95 },
	0xEFBE, { 0xE8, 0x89, 0xAC },
	0xEFBF, { 0xE8, 0x98, 0xBA },
	0xEFC0, { 0xE8, 0x99, 0x80 },
	0xEFC1, { 0xE8, 0x98, 0xB9 },
	0xEFC2, { 0xE8, 0x98, 0xBC },
	0xEFC3, { 0xE8, 0x98, 0xB1 },
	0xEFC4, { 0xE8, 0x98, 0xBB },
	0xEFC5, { 0xE8, 0x98, 0xBE },
	0xEFC6, { 0xE8, 0xA0, 0xB0 },
	0xEFC7, { 0xE8, 0xA0, 0xB2 },
	0xEFC8, { 0xE8, 0xA0, 0xAE },
	0xEFC9, { 0xE8, 0xA0, 0xB3 },
	0xEFCA, { 0xE8, 0xA5, 0xB6 },
	0xEFCB, { 0xE8, 0xA5, 0xB4 },
	0xEFCC, { 0xE8, 0xA5, 0xB3 },
	0xEFCD, { 0xE8, 0xA7, 0xBE },
	0xEFCE, { 0xE8, 0xAE, 0x8C },
	0xEFCF, { 0xE8, 0xAE, 0x8E },
	0xEFD0, { 0xE8, 0xAE, 0x8B },
	0xEFD1, { 0xE8, 0xAE, 0x88 },
	0xEFD2, { 0xE8, 0xB1, 0x85 },
	0xEFD3, { 0xE8, 0xB4, 0x99 },
	0xEFD4, { 0xE8, 0xBA, 0x98 },
	0xEFD5, { 0xE8, 0xBD, 0xA4 },
	0xEFD6, { 0xE8, 0xBD, 0xA3 },
	0xEFD7, { 0xE9, 0x86, 0xBC },
	0xEFD8, { 0xE9, 0x91, 0xA2 },
	0xEFD9, { 0xE9, 0x91, 0x95 },
	0xEFDA, { 0xE9, 0x91, 0x9D },
	0xEFDB, { 0xE9, 0x91, 0x97 },
	0xEFDC, { 0xE9, 0x91, 0x9E },
	0xEFDD, { 0xE9, 0x9F, 0x84 },
	0xEFDE, { 0xE9, 0x9F, 0x85 },
	0xEFDF, { 0xE9, 0xA0, 0x80 },
	0xEFE0, { 0xE9, 0xA9, 0x96 },
	0xEFE1, { 0xE9, 0xA9, 0x99 },
	0xEFE2, { 0xE9, 0xAC, 0x9E },
	0xEFE3, { 0xE9, 0xAC, 0x9F },
	0xEFE4, { 0xE9, 0xAC, 0xA0 },
	0xEFE5, { 0xE9, 0xB1, 0x92 },
	0xEFE6, { 0xE9, 0xB1, 0x98 },
	0xEFE7, { 0xE9, 0xB1, 0x90 },
	0xEFE8, { 0xE9, 0xB1, 0x8A },
	0xEFE9, { 0xE9, 0xB1, 0x8D },
	0xEFEA, { 0xE9, 0xB1, 0x8B },
	0xEFEB, { 0xE9, 0xB1, 0x95 },
	0xEFEC, { 0xE9, 0xB1, 0x99 },
	0xEFED, { 0xE9, 0xB1, 0x8C },
	0xEFEE, { 0xE9, 0xB1, 0x8E },
	0xEFEF, { 0xE9, 0xB7, 0xBB },
	0xEFF0, { 0xE9, 0xB7, 0xB7 },
	0xEFF1, { 0xE9, 0xB7, 0xAF },
	0xEFF2, { 0xE9, 0xB7, 0xA3 },
	0xEFF3, { 0xE9, 0xB7, 0xAB },
	0xEFF4, { 0xE9, 0xB7, 0xB8 },
	0xEFF5, { 0xE9, 0xB7, 0xA4 },
	0xEFF6, { 0xE9, 0xB7, 0xB6 },
	0xEFF7, { 0xE9, 0xB7, 0xA1 },
	0xEFF8, { 0xE9, 0xB7, 0xAE },
	0xEFF9, { 0xE9, 0xB7, 0xA6 },
	0xEFFA, { 0xE9, 0xB7, 0xB2 },
	0xEFFB, { 0xE9, 0xB7, 0xB0 },
	0xEFFC, { 0xE9, 0xB7, 0xA2 },
	0xEFFD, { 0xE9, 0xB7, 0xAC },
	0xEFFE, { 0xE9, 0xB7, 0xB4 },
	0xF0A1, { 0xE9, 0xB7, 0xB3 },
	0xF0A2, { 0xE9, 0xB7, 0xA8 },
	0xF0A3, { 0xE9, 0xB7, 0xAD },
	0xF0A4, { 0xE9, 0xBB, 0x82 },
	0xF0A5, { 0xE9, 0xBB, 0x90 },
	0xF0A6, { 0xE9, 0xBB, 0xB2 },
	0xF0A7, { 0xE9, 0xBB, 0xB3 },
	0xF0A8, { 0xE9, 0xBC, 0x86 },
	0xF0A9, { 0xE9, 0xBC, 0x9C },
	0xF0AA, { 0xE9, 0xBC, 0xB8 },
	0xF0AB, { 0xE9, 0xBC, 0xB7 },
	0xF0AC, { 0xE9, 0xBC, 0xB6 },
	0xF0AD, { 0xE9, 0xBD, 0x83 },
	0xF0AE, { 0xE9, 0xBD, 0x8F },
	0xF0AF, { 0xE9, 0xBD, 0xB1 },
	0xF0B0, { 0xE9, 0xBD, 0xB0 },
	0xF0B1, { 0xE9, 0xBD, 0xAE },
	0xF0B2, { 0xE9, 0xBD, 0xAF },
	0xF0B3, { 0xE5, 0x9B, 0x93 },
	0xF0B4, { 0xE5, 0x9B, 0x8D },
	0xF0B5, { 0xE5, 0xAD, 0x8E },
	0xF0B6, { 0xE5, 0xB1, 0xAD },
	0xF0B7, { 0xE6, 0x94, 0xAD },
	0xF0B8, { 0xE6, 0x9B, 0xAD },
	0xF0B9, { 0xE6, 0x9B, 0xAE },
	0xF0BA, { 0xE6, 0xAC, 0x93 },
	0xF0BB, { 0xE7, 0x81, 0x9F },
	0xF0BC, { 0xE7, 0x81, 0xA1 },
	0xF0BD, { 0xE7, 0x81, 0x9D },
	0xF0BE, { 0xE7, 0x81, 0xA0 },
	0xF0BF, { 0xE7, 0x88, 0xA3 },
	0xF0C0, { 0xE7, 0x93, 0x9B },
	0xF0C1, { 0xE7, 0x93, 0xA5 },
	0xF0C2, { 0xE7, 0x9F, 0x95 },
	0xF0C3, { 0xE7, 0xA4, 0xB8 },
	0xF0C4, { 0xE7, 0xA6, 0xB7 },
	0xF0C5, { 0xE7, 0xA6, 0xB6 },
	0xF0C6, { 0xE7, 0xB1, 0xAA },
	0xF0C7, { 0xE7, 0xBA, 0x97 },
	0xF0C8, { 0xE7, 0xBE, 0x89 },
	0xF0C9, { 0xE8, 0x89, 0xAD },
	0xF0CA, { 0xE8, 0x99, 0x83 },
	0xF0CB, { 0xE8, 0xA0, 0xB8 },
	0xF0CC, { 0xE8, 0xA0, 0xB7 },
	0xF0CD, { 0xE8, 0xA0, 0xB5 },
	0xF0CE, { 0xE8, 0xA1, 0x8B },
	0xF0CF, { 0xE8, 0xAE, 0x94 },
	0xF0D0, { 0xE8, 0xAE, 0x95 },
	0xF0D1, { 0xE8, 0xBA, 0x9E },
	0xF0D2, { 0xE8, 0xBA, 0x9F },
	0xF0D3, { 0xE8, 0xBA, 0xA0 },
	0xF0D4, { 0xE8, 0xBA, 0x9D },
	0xF0D5, { 0xE9, 0x86, 0xBE },
	0xF0D6, { 0xE9, 0x86, 0xBD },
	0xF0D7, { 0xE9, 0x87, 0x82 },
	0xF0D8, { 0xE9, 0x91, 0xAB },
	0xF0D9, { 0xE9, 0x91, 0xA8 },
	0xF0DA, { 0xE9, 0x91, 0xA9 },
	0xF0DB, { 0xE9, 0x9B, 0xA5 },
	0xF0DC, { 0xE9, 0x9D, 0x86 },
	0xF0DD, { 0xE9, 0x9D, 0x83 },
	0xF0DE, { 0xE9, 0x9D, 0x87 },
	0xF0DF, { 0xE9, 0x9F, 0x87 },
	0xF0E0, { 0xE9, 0x9F, 0xA5 },
	0xF0E1, { 0xE9, 0xA9, 0x9E },
	0xF0E2, { 0xE9, 0xAB, 0x95 },
	0xF0E3, { 0xE9, 0xAD, 0x99 },
	0xF0E4, { 0xE9, 0xB1, 0xA3 },
	0xF0E5, { 0xE9, 0xB1, 0xA7 },
	0xF0E6, { 0xE9, 0xB1, 0xA6 },
	0xF0E7, { 0xE9, 0xB1, 0xA2 },
	0xF0E8, { 0xE9, 0xB1, 0x9E },
	0xF0E9, { 0xE9, 0xB1, 0xA0 },
	0xF0EA, { 0xE9, 0xB8, 0x82 },
	0xF0EB, { 0xE9, 0xB7, 0xBE },
	0xF0EC, { 0xE9, 0xB8, 0x87 },
	0xF0ED, { 0xE9, 0xB8, 0x83 },
	0xF0EE, { 0xE9, 0xB8, 0x86 },
	0xF0EF, { 0xE9, 0xB8, 0x85 },
	0xF0F0, { 0xE9, 0xB8, 0x80 },
	0xF0F1, { 0xE9, 0xB8, 0x81 },
	0xF0F2, { 0xE9, 0xB8, 0x89 },
	0xF0F3, { 0xE9, 0xB7, 0xBF },
	0xF0F4, { 0xE9, 0xB7, 0xBD },
	0xF0F5, { 0xE9, 0xB8, 0x84 },
	0xF0F6, { 0xE9, 0xBA, 0xA0 },
	0xF0F7, { 0xE9, 0xBC, 0x9E },
	0xF0F8, { 0xE9, 0xBD, 0x86 },
	0xF0F9, { 0xE9, 0xBD, 0xB4 },
	0xF0FA, { 0xE9, 0xBD, 0xB5 },
	0xF0FB, { 0xE9, 0xBD, 0xB6 },
	0xF0FC, { 0xE5, 0x9B, 0x94 },
	0xF0FD, { 0xE6, 0x94, 0xAE },
	0xF0FE, { 0xE6, 0x96, 0xB8 },
	0xF1A1, { 0xE6, 0xAC, 0x98 },
	0xF1A2, { 0xE6, 0xAC, 0x99 },
	0xF1A3, { 0xE6, 0xAC, 0x97 },
	0xF1A4, { 0xE6, 0xAC, 0x9A },
	0xF1A5, { 0xE7, 0x81, 0xA2 },
	0xF1A6, { 0xE7, 0x88, 0xA6 },
	0xF1A7, { 0xE7, 0x8A, 0xAA },
	0xF1A8, { 0xE7, 0x9F, 0x98 },
	0xF1A9, { 0xE7, 0x9F, 0x99 },
	0xF1AA, { 0xE7, 0xA4, 0xB9 },
	0xF1AB, { 0xE7, 0xB1, 0xA9 },
	0xF1AC, { 0xE7, 0xB1, 0xAB },
	0xF1AD, { 0xE7, 0xB3, 0xB6 },
	0xF1AE, { 0xE7, 0xBA, 0x9A },
	0xF1AF, { 0xE7, 0xBA, 0x98 },
	0xF1B0, { 0xE7, 0xBA, 0x9B },
	0xF1B1, { 0xE7, 0xBA, 0x99 },
	0xF1B2, { 0xE8, 0x87, 0xA0 },
	0xF1B3, { 0xE8, 0x87, 0xA1 },
	0xF1B4, { 0xE8, 0x99, 0x86 },
	0xF1B5, { 0xE8, 0x99, 0x87 },
	0xF1B6, { 0xE8, 0x99, 0x88 },
	0xF1B7, { 0xE8, 0xA5, 0xB9 },
	0xF1B8, { 0xE8, 0xA5, 0xBA },
	0xF1B9, { 0xE8, 0xA5, 0xBC },
	0xF1BA, { 0xE8, 0xA5, 0xBB },
	0xF1BB, { 0xE8, 0xA7, 0xBF },
	0xF1BC, { 0xE8, 0xAE, 0x98 },
	0xF1BD, { 0xE8, 0xAE, 0x99 },
	0xF1BE, { 0xE8, 0xBA, 0xA5 },
	0xF1BF, { 0xE8, 0xBA, 0xA4 },
	0xF1C0, { 0xE8, 0xBA, 0xA3 },
	0xF1C1, { 0xE9, 0x91, 0xAE },
	0xF1C2, { 0xE9, 0x91, 0xAD },
	0xF1C3, { 0xE9, 0x91, 0xAF },
	0xF1C4, { 0xE9, 0x91, 0xB1 },
	0xF1C5, { 0xE9, 0x91, 0xB3 },
	0xF1C6, { 0xE9, 0x9D, 0x89 },
	0xF1C7, { 0xE9, 0xA1, 0xB2 },
	0xF1C8, { 0xE9, 0xA5, 0x9F },
	0xF1C9, { 0xE9, 0xB1, 0xA8 },
	0xF1CA, { 0xE9, 0xB1, 0xAE },
	0xF1CB, { 0xE9, 0xB1, 0xAD },
	0xF1CC, { 0xE9, 0xB8, 0x8B },
	0xF1CD, { 0xE9, 0xB8, 0x8D },
	0xF1CE, { 0xE9, 0xB8, 0x90 },
	0xF1CF, { 0xE9, 0xB8, 0x8F },
	0xF1D0, { 0xE9, 0xB8, 0x92 },
	0xF1D1, { 0xE9, 0xB8, 0x91 },
	0xF1D2, { 0xE9, 0xBA, 0xA1 },
	0xF1D3, { 0xE9, 0xBB, 0xB5 },
	0xF1D4, { 0xE9, 0xBC, 0x89 },
	0xF1D5, { 0xE9, 0xBD, 0x87 },
	0xF1D6, { 0xE9, 0xBD, 0xB8 },
	0xF1D7, { 0xE9, 0xBD, 0xBB },
	0xF1D8, { 0xE9, 0xBD, 0xBA },
	0xF1D9, { 0xE9, 0xBD, 0xB9 },
	0xF1DA, { 0xE5, 0x9C, 0x9E },
	0xF1DB, { 0xE7, 0x81, 0xA6 },
	0xF1DC, { 0xE7, 0xB1, 0xAF },
	0xF1DD, { 0xE8, 0xA0, 0xBC },
	0xF1DE, { 0xE8, 0xB6, 0xB2 },
	0xF1DF, { 0xE8, 0xBA, 0xA6 },
	0xF1E0, { 0xE9, 0x87, 0x83 },
	0xF1E1, { 0xE9, 0x91, 0xB4 },
	0xF1E2, { 0xE9, 0x91, 0xB8 },
	0xF1E3, { 0xE9, 0x91, 0xB6 },
	0xF1E4, { 0xE9, 0x91, 0xB5 },
	0xF1E5, { 0xE9, 0xA9, 0xA0 },
	0xF1E6, { 0xE9, 0xAC, 0xAE },
	0xF1E7, { 0xE9, 0xB1, 0xB4 },
	0xF1E8, { 0xE9, 0xB1, 0xB3 },
	0xF1E9, { 0xE9, 0xB1, 0xB1 },
	0xF1EA, { 0xE9, 0xB1, 0xB5 },
	0xF1EB, { 0xE9, 0xB8, 0x94 },
	0xF1EC, { 0xE9, 0xB8, 0x93 },
	0xF1ED, { 0xE9, 0xBB, 0xB6 },
	0xF1EE, { 0xE9, 0xBC, 0x8A },
	0xF1EF, { 0xE9, 0xBE, 0xA4 },
	0xF1F0, { 0xE7, 0x81, 0xA8 },
	0xF1F1, { 0xE7, 0x81, 0xA5 },
	0xF1F2, { 0xE7, 0xB3, 0xB7 },
	0xF1F3, { 0xE8, 0x99, 0xAA },
	0xF1F4, { 0xE8, 0xA0, 0xBE },
	0xF1F5, { 0xE8, 0xA0, 0xBD },
	0xF1F6, { 0xE8, 0xA0, 0xBF },
	0xF1F7, { 0xE8, 0xAE, 0x9E },
	0xF1F8, { 0xE8, 0xB2, 0x9C },
	0xF1F9, { 0xE8, 0xBA, 0xA9 },
	0xF1FA, { 0xE8, 0xBB, 0x89 },
	0xF1FB, { 0xE9, 0x9D, 0x8B },
	0xF1FC, { 0xE9, 0xA1, 0xB3 },
	0xF1FD, { 0xE9, 0xA1, 0xB4 },
	0xF1FE, { 0xE9, 0xA3, 0x8C },
	0xF2A1, { 0xE9, 0xA5, 0xA1 },
	0xF2A2, { 0xE9, 0xA6, 0xAB },
	0xF2A3, { 0xE9, 0xA9, 0xA4 },
	0xF2A4, { 0xE9, 0xA9, 0xA6 },
	0xF2A5, { 0xE9, 0xA9, 0xA7 },
	0xF2A6, { 0xE9, 0xAC, 0xA4 },
	0xF2A7, { 0xE9, 0xB8, 0x95 },
	0xF2A8, { 0xE9, 0xB8, 0x97 },
	0xF2A9, { 0xE9, 0xBD, 0x88 },
	0xF2AA, { 0xE6, 0x88, 0x87 },
	0xF2AB, { 0xE6, 0xAC, 0x9E },
	0xF2AC, { 0xE7, 0x88, 0xA7 },
	0xF2AD, { 0xE8, 0x99, 0x8C },
	0xF2AE, { 0xE8, 0xBA, 0xA8 },
	0xF2AF, { 0xE9, 0x92, 0x82 },
	0xF2B0, { 0xE9, 0x92, 0x80 },
	0xF2B1, { 0xE9, 0x92, 0x81 },
	0xF2B2, { 0xE9, 0xA9, 0xA9 },
	0xF2B3, { 0xE9, 0xA9, 0xA8 },
	0xF2B4, { 0xE9, 0xB8, 0x99 },
	0xF2B5, { 0xE8, 0x99, 0x8B },
	0xF2B6, { 0xE8, 0xAE, 0x9F },
	0xF2B7, { 0xE9, 0x92, 0x83 },
	0xF2B8, { 0xE9, 0xB1, 0xB9 },
	0xF2B9, { 0xE9, 0xBA, 0xB7 },
	0xF2BA, { 0xE7, 0x99, 0xB5 },
	0xF2BB, { 0xE9, 0xA9, 0xAB },
	0xF2BC, { 0xE9, 0xB1, 0xBA },
	0xF2BD, { 0xE9, 0xB8, 0x9D },
	0xF2BE, { 0xE7, 0x81, 0xA9 },
	0xF2BF, { 0xE7, 0x81, 0xAA },
	0xF2C0, { 0xE7, 0x88, 0xA9 },
	0xF2C1, { 0xE9, 0xBA, 0xA4 },
	0xF2C2, { 0xE9, 0xBD, 0xBE },
	0xF2C3, { 0xE9, 0xBD, 0x89 },
	0xF2C4, { 0xE9, 0xBE, 0x98 }
};

/* Conversion table from CNS 11643 plane #3 to UTF-8. */
static kiconv_table_array_t kiconv_cns3_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0xA1A1, { 0xE4, 0xB8, 0xA8 },
	0xA1A2, { 0xE4, 0xB8, 0xB6 },
	0xA1A3, { 0xE4, 0xB8, 0xBF },
	0xA1A4, { 0xE4, 0xBA, 0x85 },
	0xA1A5, { 0xE4, 0xB8, 0x85 },
	0xA1A6, { 0xE4, 0xB8, 0x84 },
	0xA1A7, { 0xE5, 0x86, 0x82 },
	0xA1A8, { 0xE5, 0x86, 0x96 },
	0xA1A9, { 0xE5, 0x8C, 0xB8 },
	0xA1AA, { 0xE5, 0x8D, 0xA9 },
	0xA1AB, { 0xE5, 0x8E, 0xB6 },
	0xA1AC, { 0xE4, 0xB8, 0xAA },
	0xA1AD, { 0xE4, 0xBA, 0x87 },
	0xA1AE, { 0xE4, 0xB9, 0x89 },
	0xA1AF, { 0xE5, 0x87, 0xA2 },
	0xA1B0, { 0xE4, 0xB9, 0x86 },
	0xA1B1, { 0xE4, 0xBA, 0x8F },
	0xA1B2, { 0xE4, 0xBA, 0xBC },
	0xA1B3, { 0xE4, 0xBA, 0xBE },
	0xA1B4, { 0xE5, 0x85, 0xA6 },
	0xA1B5, { 0xE5, 0x87, 0xA3 },
	0xA1B6, { 0xE5, 0x88, 0x84 },
	0xA1B7, { 0xE5, 0x8A, 0x9C },
	0xA1B8, { 0xE5, 0x8D, 0x84 },
	0xA1B9, { 0xE5, 0xA4, 0x82 },
	0xA1BA, { 0xE5, 0xA4, 0x8A },
	0xA1BB, { 0xE5, 0xAE, 0x80 },
	0xA1BC, { 0xE5, 0xB7, 0x9B },
	0xA1BD, { 0xE5, 0xB9, 0xBA },
	0xA1BE, { 0xE5, 0xB9, 0xBF },
	0xA1BF, { 0xE5, 0xBB, 0xB4 },
	0xA1C0, { 0xE5, 0xBD, 0x90 },
	0xA1C1, { 0xE5, 0xBD, 0x91 },
	0xA1C2, { 0xE5, 0xBD, 0xA1 },
	0xA1C3, { 0xE9, 0x98, 0x9D },
	0xA1C4, { 0xF0, 0xA0, 0x80, 0x8B },
	0xA1C5, { 0xE4, 0xB9, 0xA3 },
	0xA1C6, { 0xE4, 0xB9, 0xA2 },
	0xA1C7, { 0xE4, 0xBA, 0xA3 },
	0xA1C8, { 0xE5, 0x86, 0x85 },
	0xA1C9, { 0xE4, 0xBB, 0x85 },
	0xA1CA, { 0xE4, 0xBB, 0x8F },
	0xA1CB, { 0xE4, 0xBB, 0x8E },
	0xA1CC, { 0xE4, 0xBB, 0x8C },
	0xA1CD, { 0xE5, 0x86, 0x84 },
	0xA1CE, { 0xE5, 0x86, 0x86 },
	0xA1CF, { 0xF0, 0xAF, 0xA0, 0x97 },
	0xA1D0, { 0xE3, 0x93, 0x85 },
	0xA1D1, { 0xE5, 0x87, 0xA4 },
	0xA1D2, { 0xE5, 0x88, 0x85 },
	0xA1D3, { 0xE5, 0x8A, 0x9E },
	0xA1D4, { 0xE5, 0x8A, 0x9D },
	0xA1D5, { 0xE5, 0x8B, 0xBD },
	0xA1D6, { 0xE5, 0x8C, 0x80 },
	0xA1D7, { 0xE5, 0x8C, 0xBA },
	0xA1D8, { 0xE3, 0x94, 0xB9 },
	0xA1D9, { 0xE5, 0x8D, 0x86 },
	0xA1DA, { 0xE5, 0x8D, 0x9D },
	0xA1DB, { 0xE5, 0x8E, 0x86 },
	0xA1DC, { 0xE5, 0x8E, 0xB7 },
	0xA1DD, { 0xE3, 0x95, 0x95 },
	0xA1DE, { 0xE5, 0x8F, 0x8C },
	0xA1DF, { 0xE3, 0x95, 0x9B },
	0xA1E0, { 0xE5, 0x8F, 0x8E },
	0xA1E1, { 0xE5, 0x9C, 0xA1 },
	0xA1E2, { 0xE3, 0x9E, 0xA2 },
	0xA1E3, { 0xE5, 0xB8, 0x80 },
	0xA1E4, { 0xE5, 0xBC, 0x8C },
	0xA1E5, { 0xE6, 0x88, 0xB7 },
	0xA1E6, { 0xE6, 0x88, 0xB8 },
	0xA1E7, { 0xE6, 0x94, 0xB4 },
	0xA1E8, { 0xE6, 0x94, 0xB5 },
	0xA1E9, { 0xE6, 0x97, 0xA0 },
	0xA1EA, { 0xE3, 0xB8, 0xA6 },
	0xA1EB, { 0xE7, 0x8E, 0x8D },
	0xA1EC, { 0xE4, 0xBA, 0x97 },
	0xA1ED, { 0xE4, 0xBB, 0xA0 },
	0xA1EE, { 0xE3, 0x90, 0xB2 },
	0xA1EF, { 0xF0, 0xA0, 0x86, 0xA9 },
	0xA1F0, { 0xE4, 0xBB, 0xA7 },
	0xA1F1, { 0xE3, 0x90, 0xB3 },
	0xA1F2, { 0xE4, 0xBB, 0xA6 },
	0xA1F3, { 0xE3, 0x90, 0xB4 },
	0xA1F4, { 0xE3, 0x9A, 0xA2 },
	0xA1F5, { 0xE3, 0x90, 0xB1 },
	0xA1F6, { 0xE3, 0x92, 0xB0 },
	0xA1F7, { 0xE5, 0x9B, 0x98 },
	0xA1F8, { 0xE5, 0x86, 0x8B },
	0xA1F9, { 0xE5, 0x86, 0x8C },
	0xA1FA, { 0xE5, 0x86, 0x99 },
	0xA1FB, { 0xE5, 0x87, 0xA5 },
	0xA1FC, { 0xF0, 0xAF, 0xA1, 0x90 },
	0xA1FD, { 0xE5, 0x88, 0x8B },
	0xA1FE, { 0xE3, 0x93, 0x9C },
	0xA2A1, { 0xE3, 0x98, 0x9E },
	0xA2A2, { 0xE5, 0x8C, 0x84 },
	0xA2A3, { 0xE5, 0x8C, 0x83 },
	0xA2A4, { 0xE5, 0x8C, 0x87 },
	0xA2A5, { 0xF0, 0xAF, 0xA0, 0xAA },
	0xA2A6, { 0xE5, 0x8C, 0x9E },
	0xA2A7, { 0xE5, 0x8D, 0x9F },
	0xA2A8, { 0xE5, 0x8D, 0xAD },
	0xA2A9, { 0xE5, 0x8E, 0x89 },
	0xA2AA, { 0xE5, 0x8E, 0xBA },
	0xA2AB, { 0xE5, 0x8F, 0x90 },
	0xA2AC, { 0xE3, 0x95, 0xA5 },
	0xA2AD, { 0xE5, 0x8F, 0xB6 },
	0xA2AE, { 0xE5, 0x8F, 0xB7 },
	0xA2AF, { 0xE5, 0x8F, 0xB9 },
	0xA2B0, { 0xE3, 0x95, 0xA4 },
	0xA2B1, { 0xE5, 0x8F, 0xB4 },
	0xA2B2, { 0xE3, 0x98, 0x9D },
	0xA2B3, { 0xE3, 0x98, 0xA6 },
	0xA2B4, { 0xE5, 0x9C, 0xA4 },
	0xA2B5, { 0xE5, 0xA4, 0x84 },
	0xA2B6, { 0xE5, 0xA4, 0x98 },
	0xA2B7, { 0xE5, 0xA4, 0xB2 },
	0xA2B8, { 0xE5, 0xA4, 0xB0 },
	0xA2B9, { 0xE5, 0xA4, 0xB4 },
	0xA2BA, { 0xE3, 0x9A, 0x8E },
	0xA2BB, { 0xE5, 0xA5, 0xB5 },
	0xA2BC, { 0xE3, 0x9D, 0x8A },
	0xA2BD, { 0xE5, 0xAE, 0x82 },
	0xA2BE, { 0xE5, 0xAF, 0xB9 },
	0xA2BF, { 0xE5, 0xB0, 0x94 },
	0xA2C0, { 0xE3, 0x9E, 0x8B },
	0xA2C1, { 0xE3, 0x9E, 0xA6 },
	0xA2C2, { 0xE3, 0x9E, 0xA4 },
	0xA2C3, { 0xE3, 0x9E, 0xA5 },
	0xA2C4, { 0xE3, 0x9E, 0xA7 },
	0xA2C5, { 0xE3, 0xA0, 0xAF },
	0xA2C6, { 0xE3, 0xA0, 0xB2 },
	0xA2C7, { 0xE5, 0xBA, 0x81 },
	0xA2C8, { 0xE5, 0xBA, 0x83 },
	0xA2C9, { 0xE5, 0xBC, 0x8D },
	0xA2CA, { 0xE5, 0xBD, 0x92 },
	0xA2CB, { 0xE3, 0xA3, 0x94 },
	0xA2CC, { 0xE5, 0xBF, 0x8A },
	0xA2CD, { 0xE5, 0xBF, 0x87 },
	0xA2CE, { 0xE6, 0x88, 0xB9 },
	0xA2CF, { 0xE3, 0xA7, 0x85 },
	0xA2D0, { 0xE6, 0x89, 0x8F },
	0xA2D1, { 0xE6, 0x97, 0xA7 },
	0xA2D2, { 0xE6, 0x9C, 0xAF },
	0xA2D3, { 0xE6, 0xAD, 0xBA },
	0xA2D4, { 0xE6, 0xB0, 0xB9 },
	0xA2D5, { 0xE3, 0xB2, 0xBA },
	0xA2D6, { 0xE3, 0xB2, 0xB9 },
	0xA2D7, { 0xE6, 0xB0, 0xB7 },
	0xA2D8, { 0xE6, 0xB1, 0x84 },
	0xA2D9, { 0xE6, 0xB1, 0x85 },
	0xA2DA, { 0xE7, 0x8E, 0x8C },
	0xA2DB, { 0xE7, 0x96, 0x92 },
	0xA2DC, { 0xE7, 0x99, 0xB6 },
	0xA2DD, { 0xE9, 0x82, 0x93 },
	0xA2DE, { 0xE9, 0x82, 0x92 },
	0xA2DF, { 0xE4, 0xA2, 0xB3 },
	0xA2E0, { 0xE4, 0xA6, 0xBA },
	0xA2E1, { 0xE4, 0xB8, 0xA1 },
	0xA2E2, { 0xE4, 0xB8, 0xA0 },
	0xA2E3, { 0xE4, 0xB8, 0xA2 },
	0xA2E4, { 0xE4, 0xB9, 0xA8 },
	0xA2E5, { 0xE4, 0xBA, 0x89 },
	0xA2E6, { 0xE4, 0xBA, 0x98 },
	0xA2E7, { 0xE4, 0xBB, 0xB9 },
	0xA2E8, { 0xE4, 0xBB, 0xAF },
	0xA2E9, { 0xE3, 0x90, 0xBB },
	0xA2EA, { 0xE3, 0x90, 0xBC },
	0xA2EB, { 0xE4, 0xBB, 0xB8 },
	0xA2EC, { 0xE4, 0xBC, 0x86 },
	0xA2ED, { 0xE4, 0xBC, 0x83 },
	0xA2EE, { 0xE4, 0xBB, 0xBC },
	0xA2EF, { 0xE4, 0xBB, 0xAE },
	0xA2F0, { 0xE4, 0xBC, 0x96 },
	0xA2F1, { 0xE3, 0x90, 0xB9 },
	0xA2F2, { 0xE4, 0xBC, 0xA8 },
	0xA2F3, { 0xE4, 0xBC, 0x9C },
	0xA2F4, { 0xE4, 0xBC, 0x87 },
	0xA2F5, { 0xE4, 0xBC, 0x9A },
	0xA2F6, { 0xE4, 0xBB, 0xBA },
	0xA2F7, { 0xE4, 0xBC, 0x97 },
	0xA2F8, { 0xE5, 0x85, 0x8A },
	0xA2F9, { 0xE3, 0x92, 0xB2 },
	0xA2FA, { 0xE5, 0x85, 0xB2 },
	0xA2FB, { 0xF0, 0xAF, 0xA0, 0x95 },
	0xA2FC, { 0xE5, 0x86, 0xB4 },
	0xA2FD, { 0xE5, 0x86, 0xB3 },
	0xA2FE, { 0xE5, 0x86, 0xB2 },
	0xA3A1, { 0xE3, 0x93, 0x87 },
	0xA3A2, { 0xE5, 0x87, 0xA8 },
	0xA3A3, { 0xE3, 0x90, 0xAB },
	0xA3A4, { 0xE5, 0x88, 0x94 },
	0xA3A5, { 0xE5, 0x88, 0x8F },
	0xA3A6, { 0xE5, 0x88, 0x95 },
	0xA3A7, { 0xE5, 0x88, 0x98 },
	0xA3A8, { 0xE5, 0x8A, 0xA8 },
	0xA3A9, { 0xF0, 0xAF, 0xA0, 0xAC },
	0xA3AA, { 0xE5, 0x8D, 0x8B },
	0xA3AB, { 0xE5, 0x8D, 0x8F },
	0xA3AC, { 0xE3, 0x94, 0xBB },
	0xA3AD, { 0xE5, 0x8D, 0x90 },
	0xA3AE, { 0xE3, 0x95, 0x84 },
	0xA3AF, { 0xE5, 0x8E, 0x8B },
	0xA3B0, { 0xE3, 0x95, 0x82 },
	0xA3B1, { 0xE5, 0x8E, 0xBE },
	0xA3B2, { 0xE3, 0x95, 0x9C },
	0xA3B3, { 0xE5, 0x8F, 0x92 },
	0xA3B4, { 0xE5, 0x90, 0x96 },
	0xA3B5, { 0xE5, 0x8F, 0xBF },
	0xA3B6, { 0xE3, 0x95, 0xA7 },
	0xA3B7, { 0xE5, 0x90, 0x80 },
	0xA3B8, { 0xE3, 0x95, 0xA6 },
	0xA3B9, { 0xE5, 0x90, 0x85 },
	0xA3BA, { 0xE5, 0x90, 0x93 },
	0xA3BB, { 0xE5, 0x90, 0x95 },
	0xA3BC, { 0xF0, 0xAF, 0xA0, 0xBB },
	0xA3BD, { 0xE3, 0x98, 0x9F },
	0xA3BE, { 0xE5, 0x9B, 0xA3 },
	0xA3BF, { 0xE5, 0x9C, 0xB5 },
	0xA3C0, { 0xE5, 0x9C, 0xB6 },
	0xA3C1, { 0xE5, 0x9C, 0xB1 },
	0xA3C2, { 0xE5, 0x9C, 0xB2 },
	0xA3C3, { 0xE5, 0xA3, 0xAE },
	0xA3C4, { 0xE5, 0xA4, 0x85 },
	0xA3C5, { 0xE4, 0xB9, 0x94 },
	0xA3C6, { 0xE3, 0x9A, 0x8F },
	0xA3C7, { 0xE5, 0xA4, 0xB6 },
	0xA3C8, { 0xE3, 0x9A, 0x90 },
	0xA3C9, { 0xE3, 0x9A, 0xA8 },
	0xA3CA, { 0xE3, 0x9A, 0xA4 },
	0xA3CB, { 0xE5, 0xA5, 0xBA },
	0xA3CC, { 0xE3, 0x9A, 0xA3 },
	0xA3CD, { 0xE5, 0xA6, 0x86 },
	0xA3CE, { 0xE3, 0x9C, 0xBD },
	0xA3CF, { 0xE3, 0x9D, 0x8C },
	0xA3D0, { 0xE5, 0xAE, 0x86 },
	0xA3D1, { 0xE5, 0xBD, 0x93 },
	0xA3D2, { 0xE5, 0xB0, 0x98 },
	0xA3D3, { 0xE3, 0x9E, 0x8C },
	0xA3D4, { 0xE5, 0xB0, 0xBD },
	0xA3D5, { 0xE5, 0xB1, 0xB8 },
	0xA3D6, { 0xE3, 0x9E, 0xA8 },
	0xA3D7, { 0xE3, 0x9E, 0xAD },
	0xA3D8, { 0xE3, 0x9E, 0xAF },
	0xA3D9, { 0xF0, 0xA1, 0xB5, 0x86 },
	0xA3DA, { 0xE5, 0xB2, 0x80 },
	0xA3DB, { 0xE3, 0xA0, 0xA9 },
	0xA3DC, { 0xE5, 0xB8, 0x88 },
	0xA3DD, { 0xE3, 0xA0, 0xB6 },
	0xA3DE, { 0xE3, 0xA1, 0xB1 },
	0xA3DF, { 0xE3, 0xA1, 0xB0 },
	0xA3E0, { 0xE3, 0xA1, 0xAF },
	0xA3E1, { 0xE5, 0xBB, 0xB5 },
	0xA3E2, { 0xE5, 0xBC, 0x8E },
	0xA3E3, { 0xE3, 0xA2, 0xA9 },
	0xA3E4, { 0xE3, 0xA2, 0xAA },
	0xA3E5, { 0xE3, 0xA3, 0xBB },
	0xA3E6, { 0xE5, 0xBF, 0x93 },
	0xA3E7, { 0xE5, 0xBF, 0x9A },
	0xA3E8, { 0xE3, 0xA3, 0xBC },
	0xA3E9, { 0xE5, 0xBF, 0x9B },
	0xA3EA, { 0xE3, 0xA6, 0xAE },
	0xA3EB, { 0xE6, 0x88, 0x8F },
	0xA3EC, { 0xE6, 0x89, 0x9D },
	0xA3ED, { 0xE6, 0x89, 0x9F },
	0xA3EE, { 0xE6, 0x89, 0xA7 },
	0xA3EF, { 0xE6, 0x89, 0x97 },
	0xA3F0, { 0xE9, 0xBD, 0x90 },
	0xA3F1, { 0xE3, 0xAB, 0x83 },
	0xA3F2, { 0xE6, 0x97, 0xAB },
	0xA3F3, { 0xE6, 0x97, 0xAA },
	0xA3F4, { 0xE3, 0xAC, 0xB0 },
	0xA3F5, { 0xE6, 0x9C, 0xB7 },
	0xA3F6, { 0xE3, 0xAD, 0x81 },
	0xA3F7, { 0xE6, 0x9C, 0xB2 },
	0xA3F8, { 0xE6, 0x9C, 0xB6 },
	0xA3F9, { 0xE6, 0xAC, 0xA2 },
	0xA3FA, { 0xE6, 0xAF, 0x8E },
	0xA3FB, { 0xE3, 0xB2, 0x8C },
	0xA3FC, { 0xE6, 0xB1, 0x98 },
	0xA3FD, { 0xE6, 0xB1, 0x91 },
	0xA3FE, { 0xE6, 0xB1, 0xB7 },
	0xA4A1, { 0xE6, 0xB0, 0xBC },
	0xA4A2, { 0xE3, 0xB2, 0xBB },
	0xA4A3, { 0xE6, 0xB1, 0x9A },
	0xA4A4, { 0xF0, 0xA3, 0xB2, 0x86 },
	0xA4A5, { 0xE6, 0xB1, 0x93 },
	0xA4A6, { 0xE7, 0x81, 0xAF },
	0xA4A7, { 0xE7, 0x81, 0xB2 },
	0xA4A8, { 0xE7, 0x81, 0xAE },
	0xA4A9, { 0xF0, 0xAF, 0xA0, 0xB5 },
	0xA4AA, { 0xE3, 0xB6, 0xA1 },
	0xA4AB, { 0xE7, 0x81, 0xB3 },
	0xA4AC, { 0xE7, 0x8A, 0xB1 },
	0xA4AD, { 0xE7, 0x8A, 0xB2 },
	0xA4AE, { 0xE3, 0xBA, 0xA8 },
	0xA4AF, { 0xE7, 0x8E, 0x8F },
	0xA4B0, { 0xE3, 0xBA, 0xAA },
	0xA4B1, { 0xE3, 0xBA, 0xAB },
	0xA4B2, { 0xE4, 0x82, 0x96 },
	0xA4B3, { 0xE7, 0xA4, 0xBC },
	0xA4B4, { 0xE4, 0x87, 0x82 },
	0xA4B5, { 0xE8, 0x82, 0x8D },
	0xA4B6, { 0xE8, 0x82, 0x8E },
	0xA4B7, { 0xE4, 0x92, 0x93 },
	0xA4B8, { 0xE8, 0x89, 0xBB },
	0xA4B9, { 0xE4, 0x92, 0x94 },
	0xA4BA, { 0xE8, 0xB5, 0xB1 },
	0xA4BB, { 0xE8, 0xBE, 0xB9 },
	0xA4BC, { 0xE9, 0x82, 0x96 },
	0xA4BD, { 0xE9, 0x82, 0x9A },
	0xA4BE, { 0xE4, 0xA6, 0xBB },
	0xA4BF, { 0xE4, 0xB8, 0xA4 },
	0xA4C0, { 0xE4, 0xB9, 0xB1 },
	0xA4C1, { 0xF0, 0xAF, 0xA0, 0x9B },
	0xA4C2, { 0xE4, 0xBA, 0x9C },
	0xA4C3, { 0xE4, 0xBD, 0x85 },
	0xA4C4, { 0xE4, 0xBD, 0x8A },
	0xA4C5, { 0xE4, 0xBC, 0xB9 },
	0xA4C6, { 0xE4, 0xBC, 0xB7 },
	0xA4C7, { 0xE3, 0x91, 0x83 },
	0xA4C8, { 0xE4, 0xBC, 0xB2 },
	0xA4C9, { 0xE4, 0xBD, 0x82 },
	0xA4CA, { 0xE3, 0x91, 0x82 },
	0xA4CB, { 0xE4, 0xBD, 0x84 },
	0xA4CC, { 0xE4, 0xBD, 0x8B },
	0xA4CD, { 0xE3, 0x91, 0x84 },
	0xA4CE, { 0xE4, 0xBD, 0x80 },
	0xA4CF, { 0xE4, 0xBC, 0xB5 },
	0xA4D0, { 0xE4, 0xBC, 0xB1 },
	0xA4D1, { 0xE5, 0x85, 0x91 },
	0xA4D2, { 0xF0, 0xAF, 0xA0, 0x8E },
	0xA4D3, { 0xE5, 0x85, 0x90 },
	0xA4D4, { 0xE5, 0x85, 0x8E },
	0xA4D5, { 0xE3, 0x92, 0xB3 },
	0xA4D6, { 0xE3, 0x92, 0xB7 },
	0xA4D7, { 0xE5, 0x86, 0x9D },
	0xA4D8, { 0xE3, 0x93, 0x88 },
	0xA4D9, { 0xE5, 0x86, 0xB5 },
	0xA4DA, { 0xE5, 0x86, 0xB8 },
	0xA4DB, { 0xE5, 0x87, 0xAC },
	0xA4DC, { 0xE5, 0x88, 0xA3 },
	0xA4DD, { 0xE5, 0x88, 0xA7 },
	0xA4DE, { 0xE5, 0x88, 0xA6 },
	0xA4DF, { 0xE5, 0x88, 0x9F },
	0xA4E0, { 0xE5, 0x88, 0xAB },
	0xA4E1, { 0xE5, 0x88, 0xA0 },
	0xA4E2, { 0xE5, 0x8A, 0xB4 },
	0xA4E3, { 0xE5, 0x8A, 0xB3 },
	0xA4E4, { 0xE3, 0x94, 0x98 },
	0xA4E5, { 0xE5, 0x8C, 0xA5 },
	0xA4E6, { 0xE5, 0x8C, 0xBB },
	0xA4E7, { 0xE5, 0x8D, 0xB4 },
	0xA4E8, { 0xE3, 0x95, 0x87 },
	0xA4E9, { 0xE3, 0x95, 0x86 },
	0xA4EA, { 0xE3, 0x95, 0x85 },
	0xA4EB, { 0xE3, 0x95, 0xAB },
	0xA4EC, { 0xE3, 0x95, 0xA9 },
	0xA4ED, { 0xE5, 0x91, 0x8D },
	0xA4EE, { 0xE3, 0x95, 0xB2 },
	0xA4EF, { 0xE3, 0x95, 0xB1 },
	0xA4F0, { 0xE5, 0x90, 0xBA },
	0xA4F1, { 0xE3, 0x95, 0xAC },
	0xA4F2, { 0xE3, 0x95, 0xAF },
	0xA4F3, { 0xE5, 0x91, 0x84 },
	0xA4F4, { 0xE5, 0x91, 0x8C },
	0xA4F5, { 0xE5, 0x90, 0xA3 },
	0xA4F6, { 0xE5, 0x90, 0x9A },
	0xA4F7, { 0xE5, 0x90, 0xB2 },
	0xA4F8, { 0xE5, 0x91, 0x8B },
	0xA4F9, { 0xE5, 0x90, 0xA1 },
	0xA4FA, { 0xE3, 0x95, 0xB3 },
	0xA4FB, { 0xE5, 0x90, 0xB4 },
	0xA4FC, { 0xE5, 0x91, 0x89 },
	0xA4FD, { 0xE5, 0x91, 0x90 },
	0xA4FE, { 0xE5, 0x90, 0xA2 },
	0xA5A1, { 0xE5, 0x90, 0xBF },
	0xA5A2, { 0xE5, 0x91, 0x91 },
	0xA5A3, { 0xE5, 0x91, 0x9A },
	0xA5A4, { 0xE5, 0x90, 0xAF },
	0xA5A5, { 0xE3, 0x95, 0xB6 },
	0xA5A6, { 0xE5, 0x9B, 0xA9 },
	0xA5A7, { 0xE5, 0x9B, 0xB2 },
	0xA5A8, { 0xE5, 0x9B, 0xB3 },
	0xA5A9, { 0xE5, 0x9B, 0xAF },
	0xA5AA, { 0xE5, 0x9B, 0xAD },
	0xA5AB, { 0xE5, 0x9B, 0xAC },
	0xA5AC, { 0xE5, 0x9B, 0xA6 },
	0xA5AD, { 0xE5, 0x9D, 0x88 },
	0xA5AE, { 0xE3, 0x98, 0xA7 },
	0xA5AF, { 0xE5, 0x9D, 0x84 },
	0xA5B0, { 0xE5, 0x9C, 0xBF },
	0xA5B1, { 0xE5, 0x9C, 0xBC },
	0xA5B2, { 0xE5, 0x9D, 0x93 },
	0xA5B3, { 0xE5, 0x9D, 0x96 },
	0xA5B4, { 0xE3, 0x98, 0xB0 },
	0xA5B5, { 0xE5, 0x9D, 0x9F },
	0xA5B6, { 0xE5, 0x9D, 0x83 },
	0xA5B7, { 0xE5, 0x9D, 0x98 },
	0xA5B8, { 0xE5, 0x9D, 0x97 },
	0xA5B9, { 0xE3, 0x98, 0xA9 },
	0xA5BA, { 0xE3, 0x98, 0xAA },
	0xA5BB, { 0xE3, 0x98, 0xAF },
	0xA5BC, { 0xE5, 0x9D, 0x86 },
	0xA5BD, { 0xE3, 0x98, 0xAC },
	0xA5BE, { 0xE5, 0x9C, 0xBD },
	0xA5BF, { 0xE3, 0x98, 0xAD },
	0xA5C0, { 0xE5, 0x9D, 0x82 },
	0xA5C1, { 0xE5, 0x9D, 0x94 },
	0xA5C2, { 0xE5, 0x9D, 0x95 },
	0xA5C3, { 0xE5, 0xA3, 0xB1 },
	0xA5C4, { 0xE5, 0xA3, 0xB2 },
	0xA5C5, { 0xE5, 0xA3, 0xB0 },
	0xA5C6, { 0xE5, 0xA4, 0x8B },
	0xA5C7, { 0xE9, 0xBA, 0xA6 },
	0xA5C8, { 0xE5, 0x9B, 0xB1 },
	0xA5C9, { 0xE5, 0xA4, 0xBD },
	0xA5CA, { 0xE3, 0x9A, 0x93 },
	0xA5CB, { 0xE5, 0xA6, 0x94 },
	0xA5CC, { 0xE5, 0xA6, 0x8C },
	0xA5CD, { 0xE3, 0x9A, 0xAD },
	0xA5CE, { 0xE5, 0xA6, 0x9C },
	0xA5CF, { 0xE3, 0x9A, 0xAC },
	0xA5D0, { 0xE3, 0x9A, 0xAB },
	0xA5D1, { 0xE5, 0xA6, 0x9F },
	0xA5D2, { 0xE3, 0x9A, 0xA9 },
	0xA5D3, { 0xE5, 0xA6, 0x9B },
	0xA5D4, { 0xE3, 0x9A, 0xAE },
	0xA5D5, { 0xE5, 0xA6, 0x89 },
	0xA5D6, { 0xE5, 0xA6, 0x9A },
	0xA5D7, { 0xE3, 0x9A, 0xAA },
	0xA5D8, { 0xE6, 0x96, 0x88 },
	0xA5D9, { 0xE3, 0x9D, 0x8E },
	0xA5DA, { 0xE5, 0xAE, 0x8D },
	0xA5DB, { 0xE3, 0x9D, 0x90 },
	0xA5DC, { 0xE5, 0xAF, 0xBE },
	0xA5DD, { 0xE5, 0xAF, 0xBF },
	0xA5DE, { 0xE5, 0xAF, 0xBD },
	0xA5DF, { 0xE5, 0xB0, 0xAB },
	0xA5E0, { 0xE3, 0x9E, 0xB2 },
	0xA5E1, { 0xE5, 0xB2, 0x84 },
	0xA5E2, { 0xE5, 0xB2, 0x8E },
	0xA5E3, { 0xE5, 0xB2, 0x9C },
	0xA5E4, { 0xE3, 0x9E, 0xB5 },
	0xA5E5, { 0xE3, 0x9E, 0xB6 },
	0xA5E6, { 0xE5, 0xB2, 0x85 },
	0xA5E7, { 0xE5, 0xB7, 0xB5 },
	0xA5E8, { 0xE5, 0xB8, 0x89 },
	0xA5E9, { 0xE3, 0xA0, 0xB9 },
	0xA5EA, { 0xE3, 0xA0, 0xBB },
	0xA5EB, { 0xE5, 0xB8, 0x8B },
	0xA5EC, { 0xE3, 0xA1, 0xB2 },
	0xA5ED, { 0xE5, 0xBA, 0x92 },
	0xA5EE, { 0xE5, 0xBA, 0x90 },
	0xA5EF, { 0xE5, 0xBC, 0x83 },
	0xA5F0, { 0xE3, 0xA2, 0xAC },
	0xA5F1, { 0xE5, 0xBC, 0x9E },
	0xA5F2, { 0xE5, 0xBD, 0xA3 },
	0xA5F3, { 0xE3, 0xA4, 0x88 },
	0xA5F4, { 0xE5, 0xBF, 0xA7 },
	0xA5F5, { 0xE5, 0xBF, 0xBE },
	0xA5F6, { 0xE5, 0xBF, 0xA6 },
	0xA5F7, { 0xE5, 0xBF, 0x9C },
	0xA5F8, { 0xE5, 0xBF, 0x8E },
	0xA5F9, { 0xE3, 0xA4, 0x83 },
	0xA5FA, { 0xE5, 0xBF, 0xBC },
	0xA5FB, { 0xE5, 0xBF, 0x9F },
	0xA5FC, { 0xE5, 0xBF, 0xAC },
	0xA5FD, { 0xE5, 0xBF, 0xB6 },
	0xA5FE, { 0xF0, 0xA2, 0x97, 0x97 },
	0xA6A1, { 0xE5, 0xBF, 0xB2 },
	0xA6A2, { 0xE5, 0xBF, 0xB0 },
	0xA6A3, { 0xE5, 0xBF, 0xB9 },
	0xA6A4, { 0xE3, 0xA4, 0x8B },
	0xA6A5, { 0xE6, 0x88, 0x93 },
	0xA6A6, { 0xE3, 0xA6, 0xAF },
	0xA6A7, { 0xF0, 0xAF, 0xA2, 0xB2 },
	0xA6A8, { 0xE6, 0x88, 0xBB },
	0xA6A9, { 0xE6, 0x88, 0xBC },
	0xA6AA, { 0xE6, 0x8A, 0x82 },
	0xA6AB, { 0xE3, 0xA7, 0x8E },
	0xA6AC, { 0xE3, 0xA7, 0x8B },
	0xA6AD, { 0xE3, 0xA7, 0x8C },
	0xA6AE, { 0xE6, 0x89, 0xB8 },
	0xA6AF, { 0xE6, 0x8A, 0x8B },
	0xA6B0, { 0xE3, 0xA7, 0x8D },
	0xA6B1, { 0xE6, 0x8A, 0x9E },
	0xA6B2, { 0xE6, 0x8A, 0xA5 },
	0xA6B3, { 0xE6, 0x8A, 0x9B },
	0xA6B4, { 0xE6, 0x8A, 0x9C },
	0xA6B5, { 0xE6, 0x8A, 0x99 },
	0xA6B6, { 0xE6, 0x8A, 0x8D },
	0xA6B7, { 0xE6, 0x8A, 0x85 },
	0xA6B8, { 0xE6, 0x8A, 0x9D },
	0xA6B9, { 0xE6, 0x89, 0xB5 },
	0xA6BA, { 0xE3, 0xAA, 0x80 },
	0xA6BB, { 0xE3, 0xAA, 0xAF },
	0xA6BC, { 0xE3, 0xAB, 0x93 },
	0xA6BD, { 0xE6, 0x97, 0xB6 },
	0xA6BE, { 0xE3, 0xAB, 0x95 },
	0xA6BF, { 0xE3, 0xAB, 0x94 },
	0xA6C0, { 0xE3, 0xAB, 0x97 },
	0xA6C1, { 0xE6, 0x9B, 0xB5 },
	0xA6C2, { 0xE6, 0x9D, 0x9B },
	0xA6C3, { 0xE3, 0xAD, 0x82 },
	0xA6C4, { 0xE6, 0x9D, 0x94 },
	0xA6C5, { 0xE6, 0x9D, 0x92 },
	0xA6C6, { 0xE3, 0xAD, 0x84 },
	0xA6C7, { 0xE6, 0x9D, 0x98 },
	0xA6C8, { 0xE6, 0x9D, 0x84 },
	0xA6C9, { 0xE6, 0x9D, 0x8A },
	0xA6CA, { 0xE6, 0x9D, 0xA1 },
	0xA6CB, { 0xE3, 0xB3, 0x86 },
	0xA6CC, { 0xE6, 0xB1, 0xBF },
	0xA6CD, { 0xE6, 0xB2, 0x91 },
	0xA6CE, { 0xE6, 0xB2, 0x9E },
	0xA6CF, { 0xE3, 0xB3, 0x80 },
	0xA6D0, { 0xE6, 0xB1, 0xAE },
	0xA6D1, { 0xE6, 0xB1, 0xBC },
	0xA6D2, { 0xE6, 0xB2, 0x9F },
	0xA6D3, { 0xE6, 0xB1, 0xB5 },
	0xA6D4, { 0xE3, 0xB2, 0xBE },
	0xA6D5, { 0xE6, 0xB1, 0x96 },
	0xA6D6, { 0xE6, 0xB2, 0xA2 },
	0xA6D7, { 0xE6, 0xB1, 0xB9 },
	0xA6D8, { 0xE3, 0xB3, 0x8A },
	0xA6D9, { 0xE6, 0xB2, 0xA1 },
	0xA6DA, { 0xE3, 0xB3, 0x84 },
	0xA6DB, { 0xE6, 0xB2, 0xAA },
	0xA6DC, { 0xE6, 0xB2, 0xA0 },
	0xA6DD, { 0xE3, 0xB3, 0x82 },
	0xA6DE, { 0xE7, 0x81, 0xB9 },
	0xA6DF, { 0xE7, 0x81, 0xB7 },
	0xA6E0, { 0xE7, 0x81, 0xBE },
	0xA6E1, { 0xE3, 0xB6, 0xA4 },
	0xA6E2, { 0xE7, 0x81, 0xB5 },
	0xA6E3, { 0xE7, 0x81, 0xBB },
	0xA6E4, { 0xE7, 0x89, 0xA4 },
	0xA6E5, { 0xE3, 0xB8, 0xA9 },
	0xA6E6, { 0xE7, 0x8A, 0xBB },
	0xA6E7, { 0xE7, 0x8A, 0xBC },
	0xA6E8, { 0xE7, 0x8B, 0x87 },
	0xA6E9, { 0xE7, 0x8A, 0xB9 },
	0xA6EA, { 0xE7, 0x8A, 0xBE },
	0xA6EB, { 0xE7, 0x8A, 0xB6 },
	0xA6EC, { 0xE3, 0xB9, 0xA0 },
	0xA6ED, { 0xE3, 0xB9, 0x9E },
	0xA6EE, { 0xE7, 0x8E, 0x98 },
	0xA6EF, { 0xE3, 0xBA, 0xAD },
	0xA6F0, { 0xE3, 0xBA, 0xAE },
	0xA6F1, { 0xE3, 0xBA, 0xAC },
	0xA6F2, { 0xE3, 0xBD, 0x97 },
	0xA6F3, { 0xE7, 0x96, 0x93 },
	0xA6F4, { 0xE7, 0x9A, 0x80 },
	0xA6F5, { 0xE3, 0xBF, 0x9D },
	0xA6F6, { 0xE7, 0x9A, 0x83 },
	0xA6F7, { 0xE7, 0x9B, 0x80 },
	0xA6F8, { 0xE7, 0x9B, 0x81 },
	0xA6F9, { 0xE4, 0x80, 0x8E },
	0xA6FA, { 0xE4, 0x82, 0x97 },
	0xA6FB, { 0xE7, 0x9F, 0xB4 },
	0xA6FC, { 0xE7, 0x9F, 0xB5 },
	0xA6FD, { 0xE4, 0x84, 0xA7 },
	0xA6FE, { 0xE7, 0xAB, 0x8C },
	0xA7A1, { 0xE7, 0xAB, 0x8D },
	0xA7A2, { 0xE7, 0xB3, 0xBA },
	0xA7A3, { 0xE8, 0x82, 0x9F },
	0xA7A4, { 0xE8, 0x82, 0x91 },
	0xA7A5, { 0xE8, 0x82, 0x97 },
	0xA7A6, { 0xE8, 0x82, 0x94 },
	0xA7A7, { 0xE4, 0x92, 0x95 },
	0xA7A8, { 0xE8, 0x8A, 0x86 },
	0xA7A9, { 0xE8, 0x8A, 0x8C },
	0xA7AA, { 0xF0, 0xAF, 0xA6, 0x8F },
	0xA7AB, { 0xE8, 0x8A, 0x95 },
	0xA7AC, { 0xE4, 0x92, 0x98 },
	0xA7AD, { 0xE8, 0x99, 0xAC },
	0xA7AE, { 0xE4, 0x96, 0x9D },
	0xA7AF, { 0xE8, 0xBE, 0xB5 },
	0xA7B0, { 0xE8, 0xBE, 0xBE },
	0xA7B1, { 0xE8, 0xBF, 0x87 },
	0xA7B2, { 0xE4, 0xA2, 0x8A },
	0xA7B3, { 0xE8, 0xBF, 0x81 },
	0xA7B4, { 0xE9, 0x82, 0xA9 },
	0xA7B5, { 0xE9, 0x82, 0xA4 },
	0xA7B6, { 0xE4, 0xA2, 0xB5 },
	0xA7B7, { 0xE4, 0xA2, 0xB6 },
	0xA7B8, { 0xE4, 0xA2, 0xB7 },
	0xA7B9, { 0xE9, 0x82, 0xA8 },
	0xA7BA, { 0xE9, 0x98, 0xA7 },
	0xA7BB, { 0xE9, 0x98, 0xA6 },
	0xA7BC, { 0xE9, 0x98, 0xAB },
	0xA7BD, { 0xE9, 0x98, 0xB3 },
	0xA7BE, { 0xE9, 0x98, 0xB4 },
	0xA7BF, { 0xE9, 0x98, 0xA9 },
	0xA7C0, { 0xE4, 0xB8, 0xBD },
	0xA7C1, { 0xE3, 0x90, 0xA8 },
	0xA7C2, { 0xE4, 0xBA, 0x9D },
	0xA7C3, { 0xE4, 0xBE, 0x93 },
	0xA7C4, { 0xE4, 0xBE, 0x8A },
	0xA7C5, { 0xE3, 0x91, 0x8D },
	0xA7C6, { 0xE3, 0x91, 0x89 },
	0xA7C7, { 0xE4, 0xBD, 0xAD },
	0xA7C8, { 0xE4, 0xBE, 0x8E },
	0xA7C9, { 0xE4, 0xBE, 0xA0 },
	0xA7CA, { 0xE4, 0xBE, 0xA2 },
	0xA7CB, { 0xE4, 0xBE, 0xA1 },
	0xA7CC, { 0xE4, 0xBE, 0x9F },
	0xA7CD, { 0xE4, 0xBE, 0xA3 },
	0xA7CE, { 0xF0, 0xA0, 0x88, 0x89 },
	0xA7CF, { 0xE4, 0xBD, 0xB2 },
	0xA7D0, { 0xE3, 0x91, 0x91 },
	0xA7D1, { 0xE4, 0xBE, 0x8C },
	0xA7D2, { 0xE5, 0x85, 0x96 },
	0xA7D3, { 0xF0, 0xAF, 0xA0, 0x8F },
	0xA7D4, { 0xF0, 0xAF, 0xA0, 0x91 },
	0xA7D5, { 0xE5, 0x86, 0x90 },
	0xA7D6, { 0xE3, 0x93, 0x8B },
	0xA7D7, { 0xE3, 0x93, 0x8A },
	0xA7D8, { 0xE3, 0x93, 0x8C },
	0xA7D9, { 0xE5, 0x87, 0xAD },
	0xA7DA, { 0xE5, 0x87, 0xBE },
	0xA7DB, { 0xE5, 0x88, 0xAF },
	0xA7DC, { 0xF0, 0xA0, 0x9B, 0xAC },
	0xA7DD, { 0xE5, 0x88, 0xBC },
	0xA7DE, { 0xE5, 0x88, 0xB4 },
	0xA7DF, { 0xE5, 0x88, 0xB9 },
	0xA7E0, { 0xE5, 0x8A, 0xB9 },
	0xA7E1, { 0xE5, 0x8A, 0xB5 },
	0xA7E2, { 0xE5, 0x8A, 0xBF },
	0xA7E3, { 0xE5, 0x8D, 0x95 },
	0xA7E4, { 0xE3, 0x94, 0xBD },
	0xA7E5, { 0xE5, 0x8D, 0xB6 },
	0xA7E6, { 0xE5, 0x8D, 0xBA },
	0xA7E7, { 0xE5, 0x8E, 0x93 },
	0xA7E8, { 0xE3, 0x95, 0x88 },
	0xA7E9, { 0xE5, 0x8F, 0x81 },
	0xA7EA, { 0xE5, 0x8F, 0x82 },
	0xA7EB, { 0xE5, 0x8F, 0x95 },
	0xA7EC, { 0xE5, 0x92, 0x85 },
	0xA7ED, { 0xE3, 0x95, 0xB8 },
	0xA7EE, { 0xE5, 0x91, 0x9F },
	0xA7EF, { 0xE5, 0x92, 0x93 },
	0xA7F0, { 0xE5, 0x92, 0x89 },
	0xA7F1, { 0xE5, 0x91, 0xB9 },
	0xA7F2, { 0xE9, 0xBB, 0xBE },
	0xA7F3, { 0xE5, 0x92, 0x8F },
	0xA7F4, { 0xE5, 0x91, 0xA9 },
	0xA7F5, { 0xE5, 0x91, 0xAD },
	0xA7F6, { 0xE3, 0x95, 0xBA },
	0xA7F7, { 0xE5, 0x92, 0x94 },
	0xA7F8, { 0xE5, 0x91, 0xAA },
	0xA7F9, { 0xE5, 0x92, 0x8A },
	0xA7FA, { 0xE3, 0x95, 0xB7 },
	0xA7FB, { 0xE5, 0x9B, 0xBD },
	0xA7FC, { 0xE5, 0x9B, 0xBB },
	0xA7FD, { 0xE5, 0x9B, 0xB8 },
	0xA7FE, { 0xE3, 0x98, 0xA1 },
	0xA8A1, { 0xE5, 0x9B, 0xBC },
	0xA8A2, { 0xE5, 0x9B, 0xB6 },
	0xA8A3, { 0xE5, 0x9D, 0xA5 },
	0xA8A4, { 0xE5, 0x9E, 0x81 },
	0xA8A5, { 0xE5, 0x9D, 0xA3 },
	0xA8A6, { 0xE5, 0x9D, 0xA7 },
	0xA8A7, { 0xE3, 0x98, 0xB1 },
	0xA8A8, { 0xE5, 0x9D, 0xAE },
	0xA8A9, { 0xE5, 0x9D, 0xB8 },
	0xA8AA, { 0xE5, 0x9D, 0xBF },
	0xA8AB, { 0xE3, 0x98, 0xB3 },
	0xA8AC, { 0xE3, 0x98, 0xB4 },
	0xA8AD, { 0xE5, 0xA3, 0xB3 },
	0xA8AE, { 0xE5, 0xA5, 0x8B },
	0xA8AF, { 0xE5, 0xA5, 0x8C },
	0xA8B0, { 0xE3, 0x9B, 0x81 },
	0xA8B1, { 0xE3, 0x9A, 0xB0 },
	0xA8B2, { 0xE3, 0x9A, 0xB4 },
	0xA8B3, { 0xE5, 0xA6, 0xAD },
	0xA8B4, { 0xE3, 0x9A, 0xB8 },
	0xA8B5, { 0xE5, 0xA7, 0x84 },
	0xA8B6, { 0xE3, 0x9A, 0xBC },
	0xA8B7, { 0xE5, 0xA7, 0x82 },
	0xA8B8, { 0xE5, 0xA6, 0xB0 },
	0xA8B9, { 0xE3, 0x9A, 0xBF },
	0xA8BA, { 0xE3, 0x9A, 0xB5 },
	0xA8BB, { 0xE3, 0x9A, 0xB1 },
	0xA8BC, { 0xE3, 0x9A, 0xBD },
	0xA8BD, { 0xE5, 0xA6, 0xBF },
	0xA8BE, { 0xE3, 0x9A, 0xBB },
	0xA8BF, { 0xE5, 0xA7, 0x89 },
	0xA8C0, { 0xE5, 0xA6, 0xB8 },
	0xA8C1, { 0xE5, 0xA6, 0xAC },
	0xA8C2, { 0xE3, 0x9A, 0xB3 },
	0xA8C3, { 0xE3, 0x9A, 0xB6 },
	0xA8C4, { 0xE3, 0x9A, 0xBA },
	0xA8C5, { 0xE5, 0xA6, 0xB7 },
	0xA8C6, { 0xE5, 0xA7, 0x97 },
	0xA8C7, { 0xE3, 0x9A, 0xB7 },
	0xA8C8, { 0xE5, 0xAD, 0xA0 },
	0xA8C9, { 0xE3, 0x9D, 0x80 },
	0xA8CA, { 0xE5, 0xAE, 0x96 },
	0xA8CB, { 0xE5, 0xAE, 0x9E },
	0xA8CC, { 0xE5, 0xAE, 0x94 },
	0xA8CD, { 0xE5, 0xAE, 0x9F },
	0xA8CE, { 0xE5, 0xAE, 0x9D },
	0xA8CF, { 0xE3, 0x9D, 0x92 },
	0xA8D0, { 0xE5, 0xB0, 0x80 },
	0xA8D1, { 0xE5, 0xB0, 0x99 },
	0xA8D2, { 0xE3, 0x9E, 0x90 },
	0xA8D3, { 0xE3, 0x9E, 0x91 },
	0xA8D4, { 0xE5, 0xB1, 0x89 },
	0xA8D5, { 0xE5, 0xB1, 0x8A },
	0xA8D6, { 0xE3, 0x9E, 0xBE },
	0xA8D7, { 0xE5, 0xB2, 0xBB },
	0xA8D8, { 0xE5, 0xB3, 0x81 },
	0xA8D9, { 0xE3, 0x9F, 0x80 },
	0xA8DA, { 0xE3, 0x9F, 0x81 },
	0xA8DB, { 0xE3, 0x9E, 0xB9 },
	0xA8DC, { 0xE5, 0xB2, 0xB9 },
	0xA8DD, { 0xE5, 0xB2, 0x9E },
	0xA8DE, { 0xE5, 0xB2, 0xB4 },
	0xA8DF, { 0xE5, 0xB2, 0xBA },
	0xA8E0, { 0xE5, 0xB7, 0xB6 },
	0xA8E1, { 0xE5, 0xB8, 0x93 },
	0xA8E2, { 0xE5, 0xB8, 0x92 },
	0xA8E3, { 0xE5, 0xB9, 0xB7 },
	0xA8E4, { 0xE3, 0xA1, 0xB9 },
	0xA8E5, { 0xE5, 0xBA, 0x98 },
	0xA8E6, { 0xE3, 0xA1, 0xBB },
	0xA8E7, { 0xE5, 0xBA, 0x99 },
	0xA8E8, { 0xE5, 0xBA, 0x9D },
	0xA8E9, { 0xE5, 0xBB, 0xB8 },
	0xA8EA, { 0xE3, 0xA2, 0xA0 },
	0xA8EB, { 0xE5, 0xBB, 0xB9 },
	0xA8EC, { 0xE3, 0x90, 0xA9 },
	0xA8ED, { 0xE5, 0xBC, 0x86 },
	0xA8EE, { 0xE5, 0xBC, 0xA1 },
	0xA8EF, { 0xE3, 0xA2, 0xAE },
	0xA8F0, { 0xE5, 0xBC, 0xA5 },
	0xA8F1, { 0xE5, 0xBD, 0x95 },
	0xA8F2, { 0xE3, 0xA3, 0x8D },
	0xA8F3, { 0xE3, 0xA3, 0x8B },
	0xA8F4, { 0xE3, 0xA3, 0x99 },
	0xA8F5, { 0xE5, 0xBE, 0x84 },
	0xA8F6, { 0xE5, 0xBE, 0x83 },
	0xA8F7, { 0xE6, 0x80, 0xB0 },
	0xA8F8, { 0xE6, 0x80, 0x87 },
	0xA8F9, { 0xE3, 0xA4, 0x8C },
	0xA8FA, { 0xE6, 0x80, 0xB6 },
	0xA8FB, { 0xE3, 0xA4, 0x81 },
	0xA8FC, { 0xE3, 0xA4, 0x85 },
	0xA8FD, { 0xE3, 0xA4, 0x82 },
	0xA8FE, { 0xE5, 0xBF, 0xA9 },
	0xA9A1, { 0xE6, 0x80, 0xBD },
	0xA9A2, { 0xE6, 0x80, 0x88 },
	0xA9A3, { 0xE3, 0xA4, 0x93 },
	0xA9A4, { 0xE3, 0xA4, 0x91 },
	0xA9A5, { 0xE6, 0x8A, 0xBA },
	0xA9A6, { 0xE6, 0x8A, 0xB2 },
	0xA9A7, { 0xE3, 0xA7, 0xA4 },
	0xA9A8, { 0xE6, 0x8A, 0xB7 },
	0xA9A9, { 0xE6, 0x8B, 0xA4 },
	0xA9AA, { 0xE6, 0x8A, 0xA7 },
	0xA9AB, { 0xE3, 0xA7, 0x9A },
	0xA9AC, { 0xE3, 0xA7, 0x95 },
	0xA9AD, { 0xE3, 0xA7, 0x93 },
	0xA9AE, { 0xE6, 0x8B, 0x95 },
	0xA9AF, { 0xE6, 0x8B, 0xA1 },
	0xA9B0, { 0xE6, 0x8B, 0x9D },
	0xA9B1, { 0xE6, 0x8A, 0xA6 },
	0xA9B2, { 0xE6, 0x8B, 0x81 },
	0xA9B3, { 0xE6, 0x8B, 0x85 },
	0xA9B4, { 0xE6, 0x8B, 0x80 },
	0xA9B5, { 0xE6, 0x8B, 0x9F },
	0xA9B6, { 0xE6, 0x8B, 0xA0 },
	0xA9B7, { 0xE6, 0x8B, 0x9E },
	0xA9B8, { 0xE3, 0xA7, 0x96 },
	0xA9B9, { 0xE6, 0x96, 0x89 },
	0xA9BA, { 0xE3, 0xAA, 0xB4 },
	0xA9BB, { 0xE6, 0x96, 0xA6 },
	0xA9BC, { 0xE6, 0x96, 0xBA },
	0xA9BD, { 0xE3, 0xAB, 0x99 },
	0xA9BE, { 0xE6, 0x97, 0xBF },
	0xA9BF, { 0xE3, 0xAB, 0x98 },
	0xA9C0, { 0xE6, 0x98, 0x97 },
	0xA9C1, { 0xE6, 0x98, 0x98 },
	0xA9C2, { 0xE6, 0x98, 0x81 },
	0xA9C3, { 0xE6, 0x97, 0xBE },
	0xA9C4, { 0xE3, 0xAC, 0xB3 },
	0xA9C5, { 0xE6, 0x9C, 0x8C },
	0xA9C6, { 0xE3, 0xAD, 0x88 },
	0xA9C7, { 0xE6, 0x9D, 0xAB },
	0xA9C8, { 0xE6, 0x9E, 0x96 },
	0xA9C9, { 0xE6, 0x9E, 0x82 },
	0xA9CA, { 0xE6, 0x9E, 0x8A },
	0xA9CB, { 0xE3, 0xAD, 0x87 },
	0xA9CC, { 0xE6, 0x9E, 0xA3 },
	0xA9CD, { 0xE3, 0xAD, 0x8B },
	0xA9CE, { 0xE6, 0x9E, 0xA2 },
	0xA9CF, { 0xE6, 0x9E, 0x8F },
	0xA9D0, { 0xE3, 0xAD, 0x8A },
	0xA9D1, { 0xE6, 0x9F, 0xB9 },
	0xA9D2, { 0xE6, 0x9E, 0x80 },
	0xA9D3, { 0xE6, 0xAC, 0xA6 },
	0xA9D4, { 0xE6, 0xAC, 0xA7 },
	0xA9D5, { 0xE6, 0xAD, 0xA8 },
	0xA9D6, { 0xE6, 0xAD, 0xA9 },
	0xA9D7, { 0xE3, 0xB1, 0x9A },
	0xA9D8, { 0xE6, 0xAE, 0x81 },
	0xA9D9, { 0xE6, 0xAE, 0xB4 },
	0xA9DA, { 0xE6, 0xAF, 0x91 },
	0xA9DB, { 0xE3, 0xB2, 0x8E },
	0xA9DC, { 0xE3, 0xB2, 0xB4 },
	0xA9DD, { 0xE6, 0xB0, 0x9C },
	0xA9DE, { 0xE3, 0xB3, 0x8D },
	0xA9DF, { 0xE3, 0xB3, 0x8C },
	0xA9E0, { 0xE3, 0xB3, 0x8F },
	0xA9E1, { 0xE3, 0xB3, 0x8B },
	0xA9E2, { 0xE3, 0xB3, 0x8E },
	0xA9E3, { 0xE6, 0xB2, 0x97 },
	0xA9E4, { 0xE6, 0xB1, 0xAC },
	0xA9E5, { 0xE6, 0xB3, 0x9F },
	0xA9E6, { 0xE3, 0xB3, 0x92 },
	0xA9E7, { 0xE6, 0xB3, 0xAA },
	0xA9E8, { 0xE3, 0xB3, 0x91 },
	0xA9E9, { 0xE6, 0xB3, 0xA4 },
	0xA9EA, { 0xE6, 0xB3, 0x98 },
	0xA9EB, { 0xE6, 0xB2, 0xB2 },
	0xA9EC, { 0xE6, 0xB3, 0x8E },
	0xA9ED, { 0xE6, 0xB3, 0x88 },
	0xA9EE, { 0xE3, 0xB6, 0xA6 },
	0xA9EF, { 0xE7, 0x82, 0x8B },
	0xA9F0, { 0xE7, 0x82, 0x88 },
	0xA9F1, { 0xE7, 0x82, 0x90 },
	0xA9F2, { 0xE7, 0x82, 0x8F },
	0xA9F3, { 0xE3, 0xB6, 0xAA },
	0xA9F4, { 0xE7, 0x82, 0x87 },
	0xA9F5, { 0xE7, 0x82, 0x89 },
	0xA9F6, { 0xE7, 0x82, 0x8D },
	0xA9F7, { 0xE7, 0x82, 0x81 },
	0xA9F8, { 0xE3, 0xB6, 0xA8 },
	0xA9F9, { 0xE7, 0x82, 0x8C },
	0xA9FA, { 0xE3, 0xB8, 0x93 },
	0xA9FB, { 0xE3, 0xB8, 0x9A },
	0xA9FC, { 0xE7, 0x89, 0x80 },
	0xA9FD, { 0xE3, 0xB8, 0x9D },
	0xA9FE, { 0xE3, 0xB8, 0x9E },
	0xAAA1, { 0xE7, 0x89, 0xA5 },
	0xAAA2, { 0xE7, 0x89, 0xA6 },
	0xAAA3, { 0xE7, 0x89, 0xA8 },
	0xAAA4, { 0xE3, 0xB9, 0xA5 },
	0xAAA5, { 0xE3, 0xB9, 0xA6 },
	0xAAA6, { 0xE7, 0x8B, 0x8D },
	0xAAA7, { 0xE7, 0x8B, 0x93 },
	0xAAA8, { 0xE7, 0x8B, 0x9B },
	0xAAA9, { 0xE3, 0xB9, 0xA4 },
	0xAAAA, { 0xE7, 0x8B, 0x8F },
	0xAAAB, { 0xE7, 0x8E, 0xA7 },
	0xAAAC, { 0xE7, 0x8E, 0xA3 },
	0xAAAD, { 0xE7, 0x8E, 0x9E },
	0xAAAE, { 0xE3, 0xBA, 0xB0 },
	0xAAAF, { 0xE7, 0x8E, 0xAF },
	0xAAB0, { 0xE3, 0xBA, 0xB3 },
	0xAAB1, { 0xE3, 0xBA, 0xB5 },
	0xAAB2, { 0xE7, 0x8E, 0xAA },
	0xAAB3, { 0xE7, 0x8E, 0x9C },
	0xAAB4, { 0xE3, 0xBC, 0x99 },
	0xAAB5, { 0xE7, 0x95, 0x82 },
	0xAAB6, { 0xE7, 0x95, 0x84 },
	0xAAB7, { 0xE7, 0x94, 0xBB },
	0xAAB8, { 0xE7, 0x95, 0x81 },
	0xAAB9, { 0xF0, 0xA2, 0x8C, 0xBF },
	0xAABA, { 0xE7, 0x96, 0x9B },
	0xAABB, { 0xE7, 0x96, 0x9E },
	0xAABC, { 0xE3, 0xBD, 0xB5 },
	0xAABD, { 0xE7, 0xA7, 0x84 },
	0xAABE, { 0xE7, 0xA7, 0x83 },
	0xAABF, { 0xE7, 0xA7, 0x86 },
	0xAAC0, { 0xE4, 0x84, 0xAB },
	0xAAC1, { 0xE4, 0x84, 0xAC },
	0xAAC2, { 0xE7, 0xA7, 0x87 },
	0xAAC3, { 0xE4, 0x84, 0xAD },
	0xAAC4, { 0xE7, 0xA7, 0x8A },
	0xAAC5, { 0xF0, 0xA5, 0xA4, 0xAE },
	0xAAC6, { 0xE4, 0x87, 0x83 },
	0xAAC7, { 0xE7, 0xAB, 0x8F },
	0xAAC8, { 0xE7, 0xB1, 0xB6 },
	0xAAC9, { 0xE7, 0xB1, 0xB4 },
	0xAACA, { 0xE7, 0xB3, 0xBF },
	0xAACB, { 0xE7, 0xB3, 0xBC },
	0xAACC, { 0xE3, 0x92, 0xBA },
	0xAACD, { 0xE4, 0x8D, 0x90 },
	0xAACE, { 0xE7, 0xBD, 0x99 },
	0xAACF, { 0xE8, 0x82, 0xA8 },
	0xAAD0, { 0xE4, 0x8F, 0x93 },
	0xAAD1, { 0xE4, 0x8F, 0x90 },
	0xAAD2, { 0xE8, 0x82, 0xB0 },
	0xAAD3, { 0xE4, 0x8F, 0x9C },
	0xAAD4, { 0xE8, 0x82, 0xB3 },
	0xAAD5, { 0xE4, 0x8F, 0x92 },
	0xAAD6, { 0xE8, 0x82, 0xA4 },
	0xAAD7, { 0xE8, 0x82, 0xB6 },
	0xAAD8, { 0xE8, 0x82, 0xA7 },
	0xAAD9, { 0xE8, 0x82, 0xAC },
	0xAADA, { 0xE4, 0x8F, 0x9B },
	0xAADB, { 0xE8, 0x82, 0xA6 },
	0xAADC, { 0xE5, 0x8D, 0xA7 },
	0xAADD, { 0xE8, 0x88, 0x8E },
	0xAADE, { 0xE8, 0x8B, 0x84 },
	0xAADF, { 0xE8, 0x8C, 0xBE },
	0xAAE0, { 0xE8, 0x8A, 0x9C },
	0xAAE1, { 0xE4, 0x92, 0xA5 },
	0xAAE2, { 0xE4, 0x92, 0x9F },
	0xAAE3, { 0xE4, 0x92, 0x9A },
	0xAAE4, { 0xE4, 0x92, 0x9C },
	0xAAE5, { 0xE4, 0x92, 0xA2 },
	0xAAE6, { 0xE8, 0x8A, 0xAA },
	0xAAE7, { 0xE4, 0x92, 0x9B },
	0xAAE8, { 0xE8, 0x8B, 0x89 },
	0xAAE9, { 0xE4, 0x92, 0xA3 },
	0xAAEA, { 0xE4, 0x92, 0x9D },
	0xAAEB, { 0xE8, 0x8A, 0xA6 },
	0xAAEC, { 0xE8, 0x8A, 0xB2 },
	0xAAED, { 0xE4, 0x96, 0x88 },
	0xAAEE, { 0xE4, 0x98, 0x9A },
	0xAAEF, { 0xE4, 0xA2, 0x8D },
	0xAAF0, { 0xE8, 0xBF, 0x8C },
	0xAAF1, { 0xE8, 0xBF, 0x99 },
	0xAAF2, { 0xE8, 0xBF, 0x8A },
	0xAAF3, { 0xE8, 0xBF, 0x98 },
	0xAAF4, { 0xE8, 0xBF, 0x8F },
	0xAAF5, { 0xE9, 0x82, 0xB7 },
	0xAAF6, { 0xE4, 0xA2, 0xB8 },
	0xAAF7, { 0xE9, 0x82, 0xAD },
	0xAAF8, { 0xE9, 0x82, 0xB9 },
	0xAAF9, { 0xE9, 0x98, 0xB7 },
	0xAAFA, { 0xE4, 0xA7, 0x83 },
	0xAAFB, { 0xE9, 0x99, 0x81 },
	0xAAFC, { 0xE9, 0x98, 0xBE },
	0xAAFD, { 0xE9, 0x9A, 0xB6 },
	0xAAFE, { 0xE9, 0x9D, 0x91 },
	0xABA1, { 0xE9, 0x9D, 0xA3 },
	0xABA2, { 0xE4, 0xB9, 0x97 },
	0xABA3, { 0xE4, 0xB9, 0xB9 },
	0xABA4, { 0xE4, 0xBA, 0xB2 },
	0xABA5, { 0xE4, 0xBA, 0xB0 },
	0xABA6, { 0xE4, 0xBA, 0xAF },
	0xABA7, { 0xE4, 0xBA, 0xB1 },
	0xABA8, { 0xE4, 0xBF, 0x92 },
	0xABA9, { 0xE4, 0xBF, 0x95 },
	0xABAA, { 0xE3, 0x91, 0x9D },
	0xABAB, { 0xE4, 0xBE, 0xBE },
	0xABAC, { 0xE4, 0xBE, 0xB8 },
	0xABAD, { 0xE4, 0xBE, 0xB0 },
	0xABAE, { 0xE4, 0xBE, 0xB1 },
	0xABAF, { 0xE4, 0xBF, 0x88 },
	0xABB0, { 0xE3, 0x91, 0x9A },
	0xABB1, { 0xE3, 0x91, 0x97 },
	0xABB2, { 0xE4, 0xBF, 0x86 },
	0xABB3, { 0xE4, 0xBF, 0x8C },
	0xABB4, { 0xE4, 0xBF, 0xA5 },
	0xABB5, { 0xE4, 0xBF, 0xA3 },
	0xABB6, { 0xE4, 0xBE, 0xB4 },
	0xABB7, { 0xE5, 0x85, 0xAA },
	0xABB8, { 0xE3, 0x92, 0xB8 },
	0xABB9, { 0xE5, 0x86, 0x9F },
	0xABBA, { 0xE3, 0x93, 0x82 },
	0xABBB, { 0xE5, 0x87, 0x81 },
	0xABBC, { 0xE3, 0x93, 0x8F },
	0xABBD, { 0xE5, 0x87, 0x82 },
	0xABBE, { 0xE5, 0x87, 0x83 },
	0xABBF, { 0xE5, 0x89, 0x85 },
	0xABC0, { 0xE5, 0x89, 0x88 },
	0xABC1, { 0xE3, 0x93, 0xA7 },
	0xABC2, { 0xE3, 0x93, 0xA9 },
	0xABC3, { 0xE5, 0x89, 0x8F },
	0xABC4, { 0xE4, 0x91, 0x92 },
	0xABC5, { 0xE3, 0x93, 0xA8 },
	0xABC6, { 0xE5, 0x8B, 0x85 },
	0xABC7, { 0xE5, 0x8B, 0x8A },
	0xABC8, { 0xE5, 0x8B, 0x84 },
	0xABC9, { 0xE5, 0x8C, 0xA7 },
	0xABCA, { 0xE5, 0x8D, 0x98 },
	0xABCB, { 0xE5, 0x8D, 0xBD },
	0xABCC, { 0xE3, 0x95, 0x8A },
	0xABCD, { 0xE5, 0x8F, 0x9D },
	0xABCE, { 0xE5, 0x8F, 0x9C },
	0xABCF, { 0xE5, 0x8F, 0x9A },
	0xABD0, { 0xE5, 0x8F, 0x99 },
	0xABD1, { 0xE5, 0x92, 0xB9 },
	0xABD2, { 0xE3, 0x96, 0x80 },
	0xABD3, { 0xE5, 0x93, 0x90 },
	0xABD4, { 0xE5, 0x92, 0xB4 },
	0xABD5, { 0xE5, 0x93, 0x8A },
	0xABD6, { 0xE3, 0x96, 0x87 },
	0xABD7, { 0xE5, 0x92, 0xA3 },
	0xABD8, { 0xE5, 0x93, 0x9A },
	0xABD9, { 0xE5, 0x92, 0xA4 },
	0xABDA, { 0xE3, 0x96, 0x84 },
	0xABDB, { 0xE5, 0x92, 0xB2 },
	0xABDC, { 0xE5, 0x92, 0x9E },
	0xABDD, { 0xE5, 0x92, 0x9F },
	0xABDE, { 0xE5, 0x92, 0xB5 },
	0xABDF, { 0xE3, 0x96, 0x82 },
	0xABE0, { 0xE3, 0x96, 0x81 },
	0xABE1, { 0xE5, 0x93, 0x8D },
	0xABE2, { 0xE3, 0x96, 0x83 },
	0xABE3, { 0xE5, 0x93, 0x8C },
	0xABE4, { 0xE3, 0x98, 0xA2 },
	0xABE5, { 0xE5, 0x9C, 0x80 },
	0xABE6, { 0xE5, 0x9E, 0xAC },
	0xABE7, { 0xE5, 0x9E, 0x91 },
	0xABE8, { 0xE5, 0x9E, 0x8E },
	0xABE9, { 0xE5, 0x9E, 0x8D },
	0xABEA, { 0xE5, 0x9E, 0x92 },
	0xABEB, { 0xE5, 0x9E, 0xA1 },
	0xABEC, { 0xE5, 0x9E, 0x90 },
	0xABED, { 0xE5, 0x9E, 0xA6 },
	0xABEE, { 0xE5, 0x9E, 0xA8 },
	0xABEF, { 0xE3, 0x98, 0xBB },
	0xABF0, { 0xE5, 0x9E, 0x9C },
	0xABF1, { 0xE5, 0x9E, 0x96 },
	0xABF2, { 0xE5, 0x9E, 0xA7 },
	0xABF3, { 0xE3, 0x98, 0xBA },
	0xABF4, { 0xE3, 0x98, 0xB8 },
	0xABF5, { 0xE3, 0x98, 0xB9 },
	0xABF6, { 0xE3, 0x98, 0xB6 },
	0xABF7, { 0xE5, 0xA3, 0xB5 },
	0xABF8, { 0xE3, 0x9A, 0x85 },
	0xABF9, { 0xE5, 0xA4, 0x89 },
	0xABFA, { 0xE5, 0xA4, 0x88 },
	0xABFB, { 0xE3, 0xB1, 0x94 },
	0xABFC, { 0xE5, 0xA5, 0x92 },
	0xABFD, { 0xE3, 0x9A, 0x9A },
	0xABFE, { 0xE3, 0x9B, 0x84 },
	0xACA1, { 0xE5, 0xA7, 0x9F },
	0xACA2, { 0xE3, 0x9B, 0x85 },
	0xACA3, { 0xE5, 0xA7, 0xAB },
	0xACA4, { 0xE5, 0xA7, 0xAF },
	0xACA5, { 0xE5, 0xA7, 0xB0 },
	0xACA6, { 0xE5, 0xA7, 0x95 },
	0xACA7, { 0xE5, 0xA8, 0x8D },
	0xACA8, { 0xE5, 0xA8, 0x84 },
	0xACA9, { 0xE5, 0xA7, 0xB9 },
	0xACAA, { 0xE5, 0xA8, 0x82 },
	0xACAB, { 0xE5, 0xA7, 0xB8 },
	0xACAC, { 0xE5, 0xA7, 0xA2 },
	0xACAD, { 0xE5, 0xA7, 0x99 },
	0xACAE, { 0xE5, 0xA7, 0xA7 },
	0xACAF, { 0xE5, 0xAD, 0xAA },
	0xACB0, { 0xE3, 0x9D, 0x94 },
	0xACB1, { 0xE3, 0x9D, 0x95 },
	0xACB2, { 0xE5, 0xAE, 0xAB },
	0xACB3, { 0xE3, 0x9D, 0x96 },
	0xACB4, { 0xE5, 0xB0, 0x9B },
	0xACB5, { 0xE5, 0xB0, 0xAF },
	0xACB6, { 0xE3, 0x9E, 0x96 },
	0xACB7, { 0xE6, 0x98, 0xBC },
	0xACB8, { 0xE3, 0x9E, 0x95 },
	0xACB9, { 0xE3, 0x9E, 0x94 },
	0xACBA, { 0xE3, 0x9F, 0x84 },
	0xACBB, { 0xE5, 0xB3, 0x91 },
	0xACBC, { 0xE5, 0xB3, 0x9C },
	0xACBD, { 0xE5, 0xB3, 0xA6 },
	0xACBE, { 0xE5, 0xB3, 0xA1 },
	0xACBF, { 0xE5, 0xB3, 0x8D },
	0xACC0, { 0xF0, 0xAF, 0xA1, 0xBA },
	0xACC1, { 0xE5, 0xB3, 0xA2 },
	0xACC2, { 0xE5, 0xB3, 0x9D },
	0xACC3, { 0xE5, 0xB3, 0xA5 },
	0xACC4, { 0xE5, 0xB7, 0xBB },
	0xACC5, { 0xE5, 0xB7, 0xBA },
	0xACC6, { 0xE5, 0xB8, 0x9E },
	0xACC7, { 0xE3, 0xA1, 0x84 },
	0xACC8, { 0xE5, 0xBA, 0xA1 },
	0xACC9, { 0xE3, 0xA1, 0xBD },
	0xACCA, { 0xE3, 0xA1, 0xBE },
	0xACCB, { 0xE5, 0xBB, 0xBC },
	0xACCC, { 0xE5, 0xBB, 0xBB },
	0xACCD, { 0xE5, 0xBC, 0xAF },
	0xACCE, { 0xE3, 0xA2, 0xB2 },
	0xACCF, { 0xE3, 0xA2, 0xB6 },
	0xACD0, { 0xE5, 0xBD, 0xA6 },
	0xACD1, { 0xF0, 0xAF, 0xA2, 0x99 },
	0xACD2, { 0xE3, 0xA3, 0x9C },
	0xACD3, { 0xE3, 0xA3, 0x9F },
	0xACD4, { 0xE6, 0x81, 0x9C },
	0xACD5, { 0xE3, 0xA4, 0xA8 },
	0xACD6, { 0xE6, 0x81, 0x8E },
	0xACD7, { 0xE6, 0x81, 0x91 },
	0xACD8, { 0xE3, 0xA4, 0x99 },
	0xACD9, { 0xE3, 0xA4, 0x90 },
	0xACDA, { 0xE6, 0x80, 0xA3 },
	0xACDB, { 0xE6, 0x80, 0xB1 },
	0xACDC, { 0xE6, 0x81, 0xBC },
	0xACDD, { 0xE6, 0x81, 0x92 },
	0xACDE, { 0xE3, 0xA4, 0xAC },
	0xACDF, { 0xE6, 0x81, 0xA0 },
	0xACE0, { 0xE6, 0x81, 0x8A },
	0xACE1, { 0xE6, 0x81, 0xA1 },
	0xACE2, { 0xE3, 0xA4, 0x9B },
	0xACE3, { 0xE6, 0x88, 0x98 },
	0xACE4, { 0xE3, 0xA7, 0x82 },
	0xACE5, { 0xE3, 0xA7, 0xAF },
	0xACE6, { 0xE3, 0xA7, 0xA3 },
	0xACE7, { 0xE3, 0xA7, 0xA5 },
	0xACE8, { 0xE3, 0xA7, 0xAA },
	0xACE9, { 0xE3, 0xA7, 0xA6 },
	0xACEA, { 0xE3, 0xA7, 0xAE },
	0xACEB, { 0xE6, 0x8C, 0x9F },
	0xACEC, { 0xE6, 0x8C, 0x97 },
	0xACED, { 0xE6, 0x8B, 0xAA },
	0xACEE, { 0xE6, 0x8C, 0xA1 },
	0xACEF, { 0xE6, 0x8C, 0x84 },
	0xACF0, { 0xE6, 0x8C, 0x85 },
	0xACF1, { 0xE3, 0xA7, 0xA8 },
	0xACF2, { 0xE6, 0x94, 0xB1 },
	0xACF3, { 0xE6, 0x95, 0x84 },
	0xACF4, { 0xE6, 0x95, 0x80 },
	0xACF5, { 0xE3, 0xAA, 0x85 },
	0xACF6, { 0xE6, 0x95, 0x82 },
	0xACF7, { 0xE6, 0x96, 0xBE },
	0xACF8, { 0xE3, 0xAB, 0xA0 },
	0xACF9, { 0xE6, 0x98, 0xA9 },
	0xACFA, { 0xE6, 0x98, 0x9B },
	0xACFB, { 0xE3, 0xAB, 0x9D },
	0xACFC, { 0xE6, 0x98, 0xA3 },
	0xACFD, { 0xE6, 0x98, 0xAC },
	0xACFE, { 0xE6, 0x98, 0x9A },
	0xADA1, { 0xE6, 0x98, 0xB0 },
	0xADA2, { 0xE6, 0x98, 0xBB },
	0xADA3, { 0xE6, 0x98, 0x9E },
	0xADA4, { 0xE6, 0x98, 0xB7 },
	0xADA5, { 0xE6, 0x98, 0xB8 },
	0xADA6, { 0xE3, 0xAB, 0xA1 },
	0xADA7, { 0xE6, 0x9C, 0x8E },
	0xADA8, { 0xE3, 0xAD, 0x91 },
	0xADA9, { 0xE3, 0xAD, 0x95 },
	0xADAA, { 0xE6, 0x9F, 0xA8 },
	0xADAB, { 0xE6, 0x9F, 0x96 },
	0xADAC, { 0xE3, 0xAD, 0x92 },
	0xADAD, { 0xE6, 0x9F, 0x87 },
	0xADAE, { 0xE6, 0x9E, 0xBC },
	0xADAF, { 0xE6, 0xA1, 0x92 },
	0xADB0, { 0xE6, 0x9E, 0xBF },
	0xADB1, { 0xE6, 0x9F, 0x95 },
	0xADB2, { 0xE6, 0x9F, 0xBE },
	0xADB3, { 0xE8, 0x8D, 0xA3 },
	0xADB4, { 0xE6, 0x9F, 0xBB },
	0xADB5, { 0xF0, 0xAF, 0xA3, 0x9F },
	0xADB6, { 0xE6, 0x9E, 0xB1 },
	0xADB7, { 0xE6, 0xA0, 0x81 },
	0xADB8, { 0xE6, 0xA0, 0x85 },
	0xADB9, { 0xE6, 0xA0, 0x80 },
	0xADBA, { 0xE6, 0x9F, 0x97 },
	0xADBB, { 0xE4, 0x82, 0x9E },
	0xADBC, { 0xE6, 0xAC, 0xAA },
	0xADBD, { 0xE6, 0xAD, 0xAB },
	0xADBE, { 0xE3, 0xB1, 0x92 },
	0xADBF, { 0xE3, 0xB1, 0x9E },
	0xADC0, { 0xE3, 0xB1, 0xA0 },
	0xADC1, { 0xE3, 0xB1, 0x9F },
	0xADC2, { 0xE6, 0xAF, 0xA1 },
	0xADC3, { 0xE3, 0xB2, 0x92 },
	0xADC4, { 0xE3, 0xB3, 0x96 },
	0xADC5, { 0xE6, 0xB4, 0xA3 },
	0xADC6, { 0xE6, 0xB3, 0xBF },
	0xADC7, { 0xE6, 0xB4, 0x94 },
	0xADC8, { 0xE6, 0xB4, 0x85 },
	0xADC9, { 0xE6, 0xB4, 0x93 },
	0xADCA, { 0xE6, 0xB4, 0x86 },
	0xADCB, { 0xE6, 0xB4, 0xA1 },
	0xADCC, { 0xE3, 0xB3, 0x9E },
	0xADCD, { 0xE6, 0xB4, 0x95 },
	0xADCE, { 0xE6, 0xB2, 0xAF },
	0xADCF, { 0xE6, 0xB3, 0xB4 },
	0xADD0, { 0xE6, 0xB4, 0x82 },
	0xADD1, { 0xE6, 0xB5, 0x85 },
	0xADD2, { 0xF0, 0xAF, 0xA3, 0xBE },
	0xADD3, { 0xE6, 0xB4, 0xA6 },
	0xADD4, { 0xE3, 0xB3, 0x99 },
	0xADD5, { 0xE6, 0xB5, 0x84 },
	0xADD6, { 0xE3, 0xB3, 0x9D },
	0xADD7, { 0xE6, 0xB4, 0xA4 },
	0xADD8, { 0xE7, 0x82, 0xA5 },
	0xADD9, { 0xE3, 0xB6, 0xAC },
	0xADDA, { 0xE7, 0x82, 0xA3 },
	0xADDB, { 0xE3, 0xB6, 0xB0 },
	0xADDC, { 0xE7, 0x82, 0xA2 },
	0xADDD, { 0xE7, 0x82, 0xBB },
	0xADDE, { 0xE7, 0x82, 0xA0 },
	0xADDF, { 0xE7, 0x82, 0xAA },
	0xADE0, { 0xE3, 0xB6, 0xAF },
	0xADE1, { 0xE3, 0xB6, 0xAE },
	0xADE2, { 0xE7, 0x82, 0xA8 },
	0xADE3, { 0xE7, 0x82, 0xB6 },
	0xADE4, { 0xE7, 0x82, 0xB2 },
	0xADE5, { 0xE7, 0x82, 0xA7 },
	0xADE6, { 0xE3, 0xB6, 0xAD },
	0xADE7, { 0xE3, 0xB6, 0xAB },
	0xADE8, { 0xE7, 0x82, 0xB9 },
	0xADE9, { 0xE7, 0x88, 0xAE },
	0xADEA, { 0xE3, 0xB8, 0x96 },
	0xADEB, { 0xE7, 0x88, 0xBC },
	0xADEC, { 0xE3, 0xB8, 0xB0 },
	0xADED, { 0xE7, 0x89, 0xAD },
	0xADEE, { 0xE3, 0xB8, 0xB3 },
	0xADEF, { 0xE3, 0xB8, 0xB1 },
	0xADF0, { 0xE7, 0x8B, 0xA7 },
	0xADF1, { 0xE7, 0x8B, 0xAD },
	0xADF2, { 0xE3, 0xB9, 0xAE },
	0xADF3, { 0xE7, 0x8B, 0xAC },
	0xADF4, { 0xE7, 0x8B, 0xA5 },
	0xADF5, { 0xE7, 0x8B, 0xA2 },
	0xADF6, { 0xE3, 0xBA, 0xB1 },
	0xADF7, { 0xE7, 0x8F, 0x84 },
	0xADF8, { 0xE7, 0x8E, 0xBD },
	0xADF9, { 0xE7, 0x8F, 0x8F },
	0xADFA, { 0xE7, 0x8F, 0x89 },
	0xADFB, { 0xE7, 0x8F, 0x81 },
	0xADFC, { 0xE7, 0x8F, 0x90 },
	0xADFD, { 0xE3, 0xBA, 0xB7 },
	0xADFE, { 0xE7, 0x8F, 0x8E },
	0xAEA1, { 0xE7, 0x93, 0xAD },
	0xAEA2, { 0xE7, 0x93, 0xAB },
	0xAEA3, { 0xE3, 0xBC, 0x9A },
	0xAEA4, { 0xE7, 0x93, 0xAF },
	0xAEA5, { 0xE7, 0x95, 0x89 },
	0xAEA6, { 0xE7, 0x95, 0x90 },
	0xAEA7, { 0xE7, 0x95, 0x86 },
	0xAEA8, { 0xE7, 0x95, 0x8A },
	0xAEA9, { 0xE3, 0xBD, 0x99 },
	0xAEAA, { 0xE7, 0x95, 0x8D },
	0xAEAB, { 0xE7, 0x96, 0xA6 },
	0xAEAC, { 0xE3, 0xBD, 0xBA },
	0xAEAD, { 0xE3, 0xBD, 0xB8 },
	0xAEAE, { 0xE3, 0xBD, 0xBB },
	0xAEAF, { 0xE7, 0x96, 0xA8 },
	0xAEB0, { 0xE3, 0xBF, 0x9E },
	0xAEB1, { 0xE3, 0xBF, 0xAC },
	0xAEB2, { 0xE7, 0x9B, 0x87 },
	0xAEB3, { 0xE7, 0x9B, 0xBF },
	0xAEB4, { 0xE4, 0x80, 0x9E },
	0xAEB5, { 0xE7, 0x9B, 0xBD },
	0xAEB6, { 0xE7, 0x9F, 0xA6 },
	0xAEB7, { 0xE7, 0xA0, 0x8A },
	0xAEB8, { 0xE4, 0x82, 0x9B },
	0xAEB9, { 0xE7, 0xA0, 0x84 },
	0xAEBA, { 0xE7, 0xA0, 0x8B },
	0xAEBB, { 0xE7, 0xA0, 0x87 },
	0xAEBC, { 0xE4, 0x82, 0x9D },
	0xAEBD, { 0xE7, 0xA0, 0x95 },
	0xAEBE, { 0xE7, 0xA0, 0x88 },
	0xAEBF, { 0xE4, 0x83, 0xBD },
	0xAEC0, { 0xE7, 0xA7, 0x93 },
	0xAEC1, { 0xE7, 0xA7, 0x94 },
	0xAEC2, { 0xE7, 0xA7, 0x90 },
	0xAEC3, { 0xE7, 0xA7, 0x97 },
	0xAEC4, { 0xE7, 0xA9, 0xBC },
	0xAEC5, { 0xE4, 0x86, 0x94 },
	0xAEC6, { 0xE4, 0x86, 0x93 },
	0xAEC7, { 0xE7, 0xA9, 0xBD },
	0xAEC8, { 0xE7, 0xAA, 0x83 },
	0xAEC9, { 0xE7, 0xAA, 0x82 },
	0xAECA, { 0xE4, 0x87, 0x86 },
	0xAECB, { 0xE7, 0xAB, 0x94 },
	0xAECC, { 0xE7, 0xAB, 0x95 },
	0xAECD, { 0xE7, 0xAB, 0x93 },
	0xAECE, { 0xE7, 0xAB, 0x90 },
	0xAECF, { 0xE7, 0xAB, 0x92 },
	0xAED0, { 0xE7, 0xAB, 0xBE },
	0xAED1, { 0xE7, 0xAB, 0xBC },
	0xAED2, { 0xE7, 0xB1, 0xB7 },
	0xAED3, { 0xE7, 0xB1, 0xBC },
	0xAED4, { 0xE7, 0xB1, 0xBB },
	0xAED5, { 0xE4, 0x8A, 0xB8 },
	0xAED6, { 0xF0, 0xAF, 0xA5, 0xAA },
	0xAED7, { 0xE4, 0x8A, 0xB7 },
	0xAED8, { 0xE4, 0x8A, 0xB9 },
	0xAED9, { 0xE4, 0x8D, 0x93 },
	0xAEDA, { 0xF0, 0xA5, 0x84, 0xB3 },
	0xAEDB, { 0xE4, 0x8D, 0x92 },
	0xAEDC, { 0xE4, 0x8D, 0x91 },
	0xAEDD, { 0xE7, 0xBE, 0x8F },
	0xAEDE, { 0xE8, 0x83, 0x93 },
	0xAEDF, { 0xE4, 0x8F, 0xA3 },
	0xAEE0, { 0xE8, 0x83, 0x8B },
	0xAEE1, { 0xE8, 0x83, 0x92 },
	0xAEE2, { 0xE4, 0x8F, 0xA2 },
	0xAEE3, { 0xE8, 0x84, 0x89 },
	0xAEE4, { 0xE8, 0x83, 0xA2 },
	0xAEE5, { 0xE8, 0x83, 0x9F },
	0xAEE6, { 0xE8, 0x83, 0x86 },
	0xAEE7, { 0xE4, 0x91, 0xA3 },
	0xAEE8, { 0xE8, 0x88, 0xA4 },
	0xAEE9, { 0xE8, 0x8B, 0xB7 },
	0xAEEA, { 0xE8, 0x8B, 0x98 },
	0xAEEB, { 0xE8, 0x8B, 0x9D },
	0xAEEC, { 0xE4, 0x92, 0xAA },
	0xAEED, { 0xE4, 0x92, 0xA6 },
	0xAEEE, { 0xE8, 0x8B, 0xB8 },
	0xAEEF, { 0xE8, 0x8B, 0xBC },
	0xAEF0, { 0xE4, 0x92, 0xA8 },
	0xAEF1, { 0xE4, 0x92, 0xA9 },
	0xAEF2, { 0xE8, 0x8B, 0xA9 },
	0xAEF3, { 0xE4, 0x92, 0xAB },
	0xAEF4, { 0xE8, 0x8B, 0xAE },
	0xAEF5, { 0xE4, 0x92, 0xAC },
	0xAEF6, { 0xE8, 0x8B, 0x90 },
	0xAEF7, { 0xE8, 0x8C, 0x8E },
	0xAEF8, { 0xE8, 0x8B, 0xA2 },
	0xAEF9, { 0xE8, 0x8C, 0x8B },
	0xAEFA, { 0xE8, 0x8B, 0xBD },
	0xAEFB, { 0xE5, 0x85, 0xB9 },
	0xAEFC, { 0xE8, 0x99, 0xB6 },
	0xAEFD, { 0xE4, 0x96, 0x9E },
	0xAEFE, { 0xE8, 0x99, 0xB8 },
	0xAFA1, { 0xE4, 0x96, 0x9F },
	0xAFA2, { 0xE4, 0x96, 0xA0 },
	0xAFA3, { 0xE8, 0x99, 0xB5 },
	0xAFA4, { 0xE8, 0x99, 0xBD },
	0xAFA5, { 0xE4, 0x98, 0x8F },
	0xAFA6, { 0xE8, 0xA1, 0x82 },
	0xAFA7, { 0xE8, 0xA1, 0xA6 },
	0xAFA8, { 0xE4, 0x98, 0x9C },
	0xAFA9, { 0xE8, 0xA6, 0x8C },
	0xAFAA, { 0xE8, 0xA8, 0x85 },
	0xAFAB, { 0xE4, 0x9A, 0xAE },
	0xAFAC, { 0xE8, 0xA8, 0x86 },
	0xAFAD, { 0xE4, 0x9A, 0xB0 },
	0xAFAE, { 0xE8, 0xB2, 0x9F },
	0xAFAF, { 0xE4, 0x9F, 0x94 },
	0xAFB0, { 0xE8, 0xBF, 0xB1 },
	0xAFB1, { 0xE8, 0xBF, 0xA7 },
	0xAFB2, { 0xE8, 0xBF, 0xA9 },
	0xAFB3, { 0xE8, 0xBF, 0xAF },
	0xAFB4, { 0xE9, 0x83, 0x82 },
	0xAFB5, { 0xE9, 0x82, 0xBC },
	0xAFB6, { 0xE4, 0xA2, 0xBB },
	0xAFB7, { 0xE9, 0x83, 0x86 },
	0xAFB8, { 0xE9, 0x83, 0x80 },
	0xAFB9, { 0xE4, 0xA3, 0x81 },
	0xAFBA, { 0xE4, 0xA3, 0x82 },
	0xAFBB, { 0xE9, 0x83, 0x8D },
	0xAFBC, { 0xE9, 0x83, 0x89 },
	0xAFBD, { 0xE4, 0xA2, 0xBE },
	0xAFBE, { 0xE9, 0x83, 0x84 },
	0xAFBF, { 0xE4, 0xA3, 0xA5 },
	0xAFC0, { 0xE9, 0x96, 0x81 },
	0xAFC1, { 0xE4, 0xA7, 0x86 },
	0xAFC2, { 0xE9, 0xB3, 0xAC },
	0xAFC3, { 0xE5, 0x80, 0xB2 },
	0xAFC4, { 0xE4, 0xBF, 0xB9 },
	0xAFC5, { 0xE5, 0x80, 0x9D },
	0xAFC6, { 0xE4, 0xBF, 0xBF },
	0xAFC7, { 0xE5, 0x80, 0x84 },
	0xAFC8, { 0xE4, 0xBF, 0xB0 },
	0xAFC9, { 0xE5, 0x80, 0x83 },
	0xAFCA, { 0xE4, 0x98, 0xAE },
	0xAFCB, { 0xE5, 0x80, 0x82 },
	0xAFCC, { 0xE4, 0xBF, 0xBC },
	0xAFCD, { 0xE4, 0xBF, 0xB2 },
	0xAFCE, { 0xE5, 0x80, 0xA4 },
	0xAFCF, { 0xE5, 0x80, 0x88 },
	0xAFD0, { 0xE5, 0x80, 0xB6 },
	0xAFD1, { 0xE5, 0x80, 0xAE },
	0xAFD2, { 0xE3, 0x91, 0xA5 },
	0xAFD3, { 0xE5, 0x80, 0x90 },
	0xAFD4, { 0xE5, 0x80, 0xB8 },
	0xAFD5, { 0xE5, 0x80, 0xB9 },
	0xAFD6, { 0xE4, 0xBF, 0xBD },
	0xAFD7, { 0xE5, 0x81, 0x96 },
	0xAFD8, { 0xE4, 0xBF, 0xBB },
	0xAFD9, { 0xE5, 0x86, 0xA3 },
	0xAFDA, { 0xE5, 0x86, 0xA6 },
	0xAFDB, { 0xE5, 0x86, 0xA1 },
	0xAFDC, { 0xE3, 0x93, 0x91 },
	0xAFDD, { 0xE3, 0x93, 0x90 },
	0xAFDE, { 0xE5, 0x87, 0x87 },
	0xAFDF, { 0xE5, 0x87, 0x89 },
	0xAFE0, { 0xE5, 0x89, 0xA0 },
	0xAFE1, { 0xE5, 0x89, 0xA4 },
	0xAFE2, { 0xE5, 0x89, 0x99 },
	0xAFE3, { 0xE5, 0x89, 0xA5 },
	0xAFE4, { 0xE5, 0x89, 0xA7 },
	0xAFE5, { 0xE5, 0x89, 0x97 },
	0xAFE6, { 0xE5, 0x89, 0xA3 },
	0xAFE7, { 0xE3, 0x93, 0xAE },
	0xAFE8, { 0xE5, 0x89, 0x93 },
	0xAFE9, { 0xE3, 0x93, 0xAF },
	0xAFEA, { 0xE5, 0x8B, 0x8F },
	0xAFEB, { 0xE3, 0x94, 0x9E },
	0xAFEC, { 0xE5, 0x8B, 0x8E },
	0xAFED, { 0xE5, 0x8B, 0x90 },
	0xAFEE, { 0xE5, 0x8B, 0x91 },
	0xAFEF, { 0xE5, 0x8B, 0x8C },
	0xAFF0, { 0xE3, 0x95, 0x8B },
	0xAFF1, { 0xE3, 0x95, 0x8D },
	0xAFF2, { 0xE3, 0x95, 0x96 },
	0xAFF3, { 0xE5, 0x94, 0x8D },
	0xAFF4, { 0xE5, 0x93, 0xB4 },
	0xAFF5, { 0xE3, 0x96, 0x92 },
	0xAFF6, { 0xE5, 0x94, 0x93 },
	0xAFF7, { 0xE5, 0x93, 0xAF },
	0xAFF8, { 0xE5, 0x93, 0xB5 },
	0xAFF9, { 0xE5, 0x93, 0xB9 },
	0xAFFA, { 0xE5, 0x94, 0x82 },
	0xAFFB, { 0xE5, 0x94, 0x80 },
	0xAFFC, { 0xE3, 0x96, 0x93 },
	0xAFFD, { 0xE3, 0x96, 0x90 },
	0xAFFE, { 0xE5, 0x94, 0x98 },
	0xB0A1, { 0xE5, 0x93, 0xB0 },
	0xB0A2, { 0xE5, 0x93, 0xB6 },
	0xB0A3, { 0xF0, 0xAF, 0xA1, 0x81 },
	0xB0A4, { 0xE3, 0x96, 0x97 },
	0xB0A5, { 0xE5, 0x94, 0x99 },
	0xB0A6, { 0xE3, 0x98, 0xA3 },
	0xB0A7, { 0xE5, 0x9C, 0x85 },
	0xB0A8, { 0xE5, 0x9F, 0x89 },
	0xB0A9, { 0xE3, 0x98, 0xBF },
	0xB0AA, { 0xE5, 0x9E, 0xB7 },
	0xB0AB, { 0xE5, 0x9F, 0x8D },
	0xB0AC, { 0xE3, 0x99, 0x83 },
	0xB0AD, { 0xE3, 0x99, 0x82 },
	0xB0AE, { 0xE3, 0x99, 0x84 },
	0xB0AF, { 0xE5, 0x9E, 0xBE },
	0xB0B0, { 0xE5, 0x9E, 0xBB },
	0xB0B1, { 0xE3, 0x99, 0x85 },
	0xB0B2, { 0xE5, 0x9F, 0x9B },
	0xB0B3, { 0xE5, 0x9F, 0x88 },
	0xB0B4, { 0xE5, 0x9F, 0x84 },
	0xB0B5, { 0xE5, 0x9F, 0x85 },
	0xB0B6, { 0xE5, 0x9F, 0x91 },
	0xB0B7, { 0xE5, 0x9F, 0x8A },
	0xB0B8, { 0xE5, 0x9F, 0x80 },
	0xB0B9, { 0xE3, 0x9B, 0x99 },
	0xB0BA, { 0xE3, 0x9B, 0x9E },
	0xB0BB, { 0xE5, 0xA8, 0xA1 },
	0xB0BC, { 0xE5, 0xA8, 0xAA },
	0xB0BD, { 0xE3, 0x9B, 0x8F },
	0xB0BE, { 0xE5, 0xA8, 0x9D },
	0xB0BF, { 0xE3, 0x9B, 0x8D },
	0xB0C0, { 0xE5, 0xA8, 0x8B },
	0xB0C1, { 0xE3, 0x9B, 0x9D },
	0xB0C2, { 0xE3, 0x9B, 0x8E },
	0xB0C3, { 0xE3, 0x9B, 0x93 },
	0xB0C4, { 0xE3, 0x9B, 0x96 },
	0xB0C5, { 0xE5, 0xA8, 0xA2 },
	0xB0C6, { 0xE3, 0x9B, 0x9C },
	0xB0C7, { 0xE3, 0x9B, 0x91 },
	0xB0C8, { 0xE5, 0xA8, 0xA4 },
	0xB0C9, { 0xE3, 0x9B, 0x90 },
	0xB0CA, { 0xE5, 0xA8, 0x94 },
	0xB0CB, { 0xE5, 0xA8, 0xB1 },
	0xB0CC, { 0xE3, 0x9B, 0x95 },
	0xB0CD, { 0xE5, 0xA8, 0xAF },
	0xB0CE, { 0xE5, 0xA8, 0x9A },
	0xB0CF, { 0xE5, 0xA8, 0x92 },
	0xB0D0, { 0xE3, 0x9B, 0x94 },
	0xB0D1, { 0xE3, 0x9B, 0x9B },
	0xB0D2, { 0xE5, 0xA8, 0xA6 },
	0xB0D3, { 0xF0, 0xA1, 0x9C, 0xAE },
	0xB0D4, { 0xE3, 0x9D, 0x83 },
	0xB0D5, { 0xE5, 0xAE, 0xBC },
	0xB0D6, { 0xE5, 0xAE, 0xBB },
	0xB0D7, { 0xE5, 0xAE, 0xB7 },
	0xB0D8, { 0xE5, 0xB0, 0x85 },
	0xB0D9, { 0xE5, 0xB0, 0x86 },
	0xB0DA, { 0xE5, 0xB1, 0x92 },
	0xB0DB, { 0xE5, 0xB1, 0x93 },
	0xB0DC, { 0xE3, 0x9F, 0x8D },
	0xB0DD, { 0xE3, 0x9F, 0x91 },
	0xB0DE, { 0xE5, 0xB3, 0xBA },
	0xB0DF, { 0xE5, 0xB3, 0xAB },
	0xB0E0, { 0xE3, 0x9F, 0x8A },
	0xB0E1, { 0xE5, 0xB3, 0xB3 },
	0xB0E2, { 0xE5, 0xB3, 0xB5 },
	0xB0E3, { 0xE5, 0xB3, 0xA9 },
	0xB0E4, { 0xE5, 0xB3, 0xAF },
	0xB0E5, { 0xE3, 0x9F, 0x94 },
	0xB0E6, { 0xE5, 0xB8, 0xAA },
	0xB0E7, { 0xE5, 0xB8, 0xB0 },
	0xB0E8, { 0xE5, 0xB8, 0xAE },
	0xB0E9, { 0xE5, 0xB8, 0xAC },
	0xB0EA, { 0xE5, 0xB8, 0xAF },
	0xB0EB, { 0xE5, 0xBA, 0xAF },
	0xB0EC, { 0xE5, 0xBA, 0xA9 },
	0xB0ED, { 0xE3, 0xA2, 0x86 },
	0xB0EE, { 0xE5, 0xBB, 0xBD },
	0xB0EF, { 0xE5, 0xBC, 0xB2 },
	0xB0F0, { 0xE5, 0xBE, 0x8E },
	0xB0F1, { 0xE5, 0xBE, 0x93 },
	0xB0F2, { 0xE5, 0xBE, 0x8F },
	0xB0F3, { 0xE6, 0x81, 0x8F },
	0xB0F4, { 0xE6, 0x82, 0x99 },
	0xB0F5, { 0xE3, 0xA4, 0xB3 },
	0xB0F6, { 0xE6, 0x81, 0xBE },
	0xB0F7, { 0xE3, 0xA4, 0xB7 },
	0xB0F8, { 0xE6, 0x81, 0xB4 },
	0xB0F9, { 0xE6, 0x81, 0x8B },
	0xB0FA, { 0xE6, 0x81, 0xB3 },
	0xB0FB, { 0xE6, 0x81, 0xB5 },
	0xB0FC, { 0xE3, 0xA4, 0xAA },
	0xB0FD, { 0xE3, 0xA4, 0x9F },
	0xB0FE, { 0xE6, 0x81, 0x96 },
	0xB1A1, { 0xE6, 0x82, 0xA9 },
	0xB1A2, { 0xE6, 0x82, 0x8B },
	0xB1A3, { 0xE6, 0x82, 0xA6 },
	0xB1A4, { 0xE3, 0xA4, 0xB9 },
	0xB1A5, { 0xE6, 0x82, 0x93 },
	0xB1A6, { 0xE6, 0x82, 0xAE },
	0xB1A7, { 0xE6, 0x82, 0x9E },
	0xB1A8, { 0xE6, 0x82, 0xA7 },
	0xB1A9, { 0xE6, 0x89, 0x85 },
	0xB1AA, { 0xE3, 0xA7, 0xB2 },
	0xB1AB, { 0xE3, 0xA7, 0xB8 },
	0xB1AC, { 0xE6, 0x8C, 0xAE },
	0xB1AD, { 0xE3, 0xA7, 0xB7 },
	0xB1AE, { 0xE6, 0x8D, 0x92 },
	0xB1AF, { 0xE6, 0x8C, 0xB0 },
	0xB1B0, { 0xE6, 0x8D, 0x9B },
	0xB1B1, { 0xE3, 0xA7, 0xB4 },
	0xB1B2, { 0xE6, 0x8C, 0x99 },
	0xB1B3, { 0xE6, 0x8C, 0x9B },
	0xB1B4, { 0xE3, 0xA7, 0xB1 },
	0xB1B5, { 0xE6, 0x8C, 0xB1 },
	0xB1B6, { 0xE6, 0x8D, 0x9D },
	0xB1B7, { 0xE6, 0x8C, 0xB7 },
	0xB1B8, { 0xE6, 0x8C, 0xB5 },
	0xB1B9, { 0xE6, 0x8D, 0x93 },
	0xB1BA, { 0xE3, 0xA7, 0xB5 },
	0xB1BB, { 0xE6, 0x8D, 0x9C },
	0xB1BC, { 0xE6, 0x8C, 0xBF },
	0xB1BD, { 0xE6, 0x95, 0x8B },
	0xB1BE, { 0xE3, 0xAA, 0x87 },
	0xB1BF, { 0xE4, 0x8D, 0xA9 },
	0xB1C0, { 0xE6, 0x96, 0x8B },
	0xB1C1, { 0xE3, 0xAA, 0xB6 },
	0xB1C2, { 0xE6, 0x96, 0x9A },
	0xB1C3, { 0xE6, 0x99, 0x90 },
	0xB1C4, { 0xE6, 0x99, 0x86 },
	0xB1C5, { 0xE6, 0x99, 0x8E },
	0xB1C6, { 0xE6, 0x99, 0x80 },
	0xB1C7, { 0xE3, 0xAB, 0xA9 },
	0xB1C8, { 0xE6, 0x99, 0x8B },
	0xB1C9, { 0xE6, 0x99, 0x88 },
	0xB1CA, { 0xE3, 0xAB, 0xAB },
	0xB1CB, { 0xE6, 0x99, 0xA0 },
	0xB1CC, { 0xE6, 0x99, 0x84 },
	0xB1CD, { 0xE6, 0x99, 0x8D },
	0xB1CE, { 0xE3, 0xAC, 0xB4 },
	0xB1CF, { 0xE6, 0xA0, 0xB7 },
	0xB1D0, { 0xE6, 0xA0, 0xA4 },
	0xB1D1, { 0xE3, 0xAD, 0xA2 },
	0xB1D2, { 0xE3, 0xAD, 0x9C },
	0xB1D3, { 0xE6, 0xA0, 0x9B },
	0xB1D4, { 0xE6, 0xA0, 0xB6 },
	0xB1D5, { 0xE3, 0xAD, 0xA0 },
	0xB1D6, { 0xE6, 0xA0, 0xAC },
	0xB1D7, { 0xE6, 0xA0, 0x99 },
	0xB1D8, { 0xE6, 0xA1, 0x96 },
	0xB1D9, { 0xE6, 0xA1, 0x87 },
	0xB1DA, { 0xE6, 0xA0, 0xBE },
	0xB1DB, { 0xE6, 0xA0, 0x9E },
	0xB1DC, { 0xF0, 0xAF, 0xA3, 0xA1 },
	0xB1DD, { 0xE6, 0xA0, 0x95 },
	0xB1DE, { 0xE6, 0xA0, 0xA2 },
	0xB1DF, { 0xE6, 0xA0, 0xA7 },
	0xB1E0, { 0xE6, 0xA1, 0x99 },
	0xB1E1, { 0xE6, 0xA1, 0x98 },
	0xB1E2, { 0xE6, 0xA1, 0x95 },
	0xB1E3, { 0xE6, 0xA0, 0xB0 },
	0xB1E4, { 0xE6, 0xA0, 0xA3 },
	0xB1E5, { 0xE6, 0xAC, 0xAE },
	0xB1E6, { 0xE6, 0xAC, 0xAB },
	0xB1E7, { 0xE6, 0xAC, 0xB0 },
	0xB1E8, { 0xE6, 0xAD, 0xAC },
	0xB1E9, { 0xE3, 0xB1, 0xA1 },
	0xB1EA, { 0xE6, 0xAE, 0x8B },
	0xB1EB, { 0xE3, 0xB1, 0xBF },
	0xB1EC, { 0xE6, 0xAF, 0xA9 },
	0xB1ED, { 0xE6, 0xAF, 0xAA },
	0xB1EE, { 0xE6, 0xAF, 0xA5 },
	0xB1EF, { 0xE6, 0xB5, 0xAB },
	0xB1F0, { 0xE3, 0xB3, 0xA5 },
	0xB1F1, { 0xE3, 0xB3, 0xA6 },
	0xB1F2, { 0xE6, 0xB5, 0xB3 },
	0xB1F3, { 0xE6, 0xB5, 0x97 },
	0xB1F4, { 0xE3, 0xB3, 0xA9 },
	0xB1F5, { 0xE3, 0xB3, 0xB3 },
	0xB1F6, { 0xE6, 0xB5, 0x9D },
	0xB1F7, { 0xE6, 0xB5, 0x96 },
	0xB1F8, { 0xE6, 0xB6, 0x8F },
	0xB1F9, { 0xE6, 0xB5, 0x9B },
	0xB1FA, { 0xE6, 0xB4, 0x9C },
	0xB1FB, { 0xE6, 0xB6, 0x9A },
	0xB1FC, { 0xE6, 0xB6, 0x9B },
	0xB1FD, { 0xE6, 0xB6, 0x99 },
	0xB1FE, { 0xE3, 0xB3, 0xAE },
	0xB2A1, { 0xE6, 0xB6, 0x81 },
	0xB2A2, { 0xE6, 0xB5, 0xB1 },
	0xB2A3, { 0xE3, 0xB3, 0xAD },
	0xB2A4, { 0xE3, 0xB3, 0xAC },
	0xB2A5, { 0xE6, 0xB5, 0xB2 },
	0xB2A6, { 0xE6, 0xB5, 0x9C },
	0xB2A7, { 0xE6, 0xB6, 0x96 },
	0xB2A8, { 0xE7, 0x83, 0x84 },
	0xB2A9, { 0xE7, 0x83, 0x9B },
	0xB2AA, { 0xE7, 0x83, 0x8C },
	0xB2AB, { 0xE7, 0x83, 0x90 },
	0xB2AC, { 0xE7, 0x83, 0xA3 },
	0xB2AD, { 0xE7, 0x83, 0x9F },
	0xB2AE, { 0xE3, 0xB6, 0xB3 },
	0xB2AF, { 0xE7, 0x83, 0x96 },
	0xB2B0, { 0xE7, 0x83, 0xAE },
	0xB2B1, { 0xE7, 0x83, 0x95 },
	0xB2B2, { 0xE3, 0xB6, 0xB5 },
	0xB2B3, { 0xE3, 0xB8, 0xA7 },
	0xB2B4, { 0xE3, 0xB8, 0xB5 },
	0xB2B5, { 0xE3, 0xB8, 0xB6 },
	0xB2B6, { 0xE7, 0x89, 0xBA },
	0xB2B7, { 0xE3, 0xB9, 0xB1 },
	0xB2B8, { 0xE7, 0x8B, 0xB5 },
	0xB2B9, { 0xE7, 0x8C, 0x82 },
	0xB2BA, { 0xE3, 0xBA, 0xB8 },
	0xB2BB, { 0xE3, 0xBB, 0x82 },
	0xB2BC, { 0xE7, 0x8F, 0xA2 },
	0xB2BD, { 0xE7, 0x8F, 0xAC },
	0xB2BE, { 0xE7, 0x8F, 0x95 },
	0xB2BF, { 0xE7, 0x8F, 0xB9 },
	0xB2C0, { 0xE7, 0x8F, 0x9F },
	0xB2C1, { 0xE7, 0x8F, 0xA6 },
	0xB2C2, { 0xE3, 0xBB, 0x88 },
	0xB2C3, { 0xE3, 0xBB, 0x80 },
	0xB2C4, { 0xE3, 0xBB, 0x81 },
	0xB2C5, { 0xE3, 0xBB, 0x84 },
	0xB2C6, { 0xE7, 0x8F, 0xA4 },
	0xB2C7, { 0xE7, 0x8F, 0xA1 },
	0xB2C8, { 0xE7, 0x93, 0xB3 },
	0xB2C9, { 0xE3, 0xBC, 0x9F },
	0xB2CA, { 0xE3, 0xBC, 0x9C },
	0xB2CB, { 0xE3, 0xBC, 0x9D },
	0xB2CC, { 0xE3, 0xBD, 0x8D },
	0xB2CD, { 0xE7, 0x95, 0x96 },
	0xB2CE, { 0xE7, 0x95, 0x95 },
	0xB2CF, { 0xE7, 0x95, 0x98 },
	0xB2D0, { 0xE7, 0x95, 0x97 },
	0xB2D1, { 0xE7, 0x95, 0x9E },
	0xB2D2, { 0xE7, 0x97, 0x83 },
	0xB2D3, { 0xE3, 0xBE, 0x87 },
	0xB2D4, { 0xE3, 0xBE, 0x82 },
	0xB2D5, { 0xE7, 0x96, 0xB4 },
	0xB2D6, { 0xE3, 0xBD, 0xBD },
	0xB2D7, { 0xE7, 0x96, 0xB1 },
	0xB2D8, { 0xE3, 0xBF, 0x9F },
	0xB2D9, { 0xE4, 0x80, 0x80 },
	0xB2DA, { 0xE7, 0x9B, 0x8B },
	0xB2DB, { 0xE7, 0x9B, 0x8C },
	0xB2DC, { 0xE7, 0x9C, 0xAA },
	0xB2DD, { 0xE4, 0x80, 0xA0 },
	0xB2DE, { 0xE7, 0x9C, 0x96 },
	0xB2DF, { 0xE7, 0x9C, 0x8F },
	0xB2E0, { 0xE4, 0x80, 0xA2 },
	0xB2E1, { 0xE4, 0x80, 0xA4 },
	0xB2E2, { 0xE7, 0x9C, 0xBF },
	0xB2E3, { 0xE7, 0x9C, 0xAB },
	0xB2E4, { 0xE7, 0x9C, 0x8E },
	0xB2E5, { 0xE7, 0x9C, 0xA4 },
	0xB2E6, { 0xE4, 0x80, 0xA1 },
	0xB2E7, { 0xE7, 0x9C, 0xA1 },
	0xB2E8, { 0xE7, 0x9C, 0x98 },
	0xB2E9, { 0xE7, 0x9F, 0x9D },
	0xB2EA, { 0xE4, 0x82, 0xA4 },
	0xB2EB, { 0xE4, 0x82, 0xA5 },
	0xB2EC, { 0xE7, 0xA0, 0xA4 },
	0xB2ED, { 0xE7, 0xA0, 0xB6 },
	0xB2EE, { 0xE4, 0x84, 0x81 },
	0xB2EF, { 0xE7, 0xA5, 0x98 },
	0xB2F0, { 0xE7, 0xA5, 0x99 },
	0xB2F1, { 0xE4, 0x84, 0x83 },
	0xB2F2, { 0xE7, 0xA5, 0xA2 },
	0xB2F3, { 0xE7, 0xA7, 0x9A },
	0xB2F4, { 0xE7, 0xA7, 0x99 },
	0xB2F5, { 0xE4, 0x84, 0xB7 },
	0xB2F6, { 0xE7, 0xA7, 0xA1 },
	0xB2F7, { 0xE7, 0xA7, 0xA5 },
	0xB2F8, { 0xE7, 0xA7, 0xA8 },
	0xB2F9, { 0xE7, 0xA7, 0x9B },
	0xB2FA, { 0xE4, 0x84, 0xB8 },
	0xB2FB, { 0xE7, 0xA7, 0xA2 },
	0xB2FC, { 0xE7, 0xA7, 0xB0 },
	0xB2FD, { 0xE4, 0x86, 0x99 },
	0xB2FE, { 0xE4, 0x86, 0x98 },
	0xB3A1, { 0xE4, 0x86, 0x97 },
	0xB3A2, { 0xE4, 0x87, 0x89 },
	0xB3A3, { 0xE7, 0xAB, 0x9A },
	0xB3A4, { 0xE7, 0xAB, 0x9D },
	0xB3A5, { 0xE4, 0x87, 0x87 },
	0xB3A6, { 0xE7, 0xAB, 0x9B },
	0xB3A7, { 0xE7, 0xAB, 0x9C },
	0xB3A8, { 0xE4, 0x87, 0x99 },
	0xB3A9, { 0xE4, 0x87, 0x9B },
	0xB3AA, { 0xE7, 0xAC, 0x8D },
	0xB3AB, { 0xE7, 0xAC, 0x8B },
	0xB3AC, { 0xE7, 0xAC, 0x94 },
	0xB3AD, { 0xE7, 0xB2, 0x8E },
	0xB3AE, { 0xE7, 0xB2, 0x86 },
	0xB3AF, { 0xE4, 0x89, 0xBB },
	0xB3B0, { 0xE7, 0xB2, 0x87 },
	0xB3B1, { 0xE7, 0xB2, 0x83 },
	0xB3B2, { 0xE7, 0xB2, 0x8B },
	0xB3B3, { 0xE4, 0x89, 0xBC },
	0xB3B4, { 0xE4, 0x8A, 0xBD },
	0xB3B5, { 0xE4, 0x8A, 0xBC },
	0xB3B6, { 0xE4, 0x8B, 0x83 },
	0xB3B7, { 0xE7, 0xB4, 0xA4 },
	0xB3B8, { 0xE4, 0x8B, 0x81 },
	0xB3B9, { 0xE4, 0x8A, 0xBF },
	0xB3BA, { 0xE4, 0x8B, 0x84 },
	0xB3BB, { 0xE7, 0xB4, 0xA5 },
	0xB3BC, { 0xE7, 0xBD, 0xA2 },
	0xB3BD, { 0xE7, 0xBE, 0x93 },
	0xB3BE, { 0xE7, 0xBE, 0x99 },
	0xB3BF, { 0xE7, 0xBE, 0x97 },
	0xB3C0, { 0xE4, 0x8D, 0xBE },
	0xB3C1, { 0xE4, 0x8D, 0xBF },
	0xB3C2, { 0xE7, 0xBF, 0x84 },
	0xB3C3, { 0xE7, 0xBF, 0x86 },
	0xB3C4, { 0xE8, 0x80, 0x8A },
	0xB3C5, { 0xE4, 0x8E, 0xB4 },
	0xB3C6, { 0xE4, 0x8E, 0xB3 },
	0xB3C7, { 0xE8, 0x81, 0x80 },
	0xB3C8, { 0xE8, 0x80, 0xBC },
	0xB3C9, { 0xE8, 0x80, 0xBB },
	0xB3CA, { 0xE8, 0x83, 0xB6 },
	0xB3CB, { 0xE8, 0x83, 0xBF },
	0xB3CC, { 0xE8, 0x83, 0xAE },
	0xB3CD, { 0xE8, 0x84, 0x84 },
	0xB3CE, { 0xE8, 0x84, 0x83 },
	0xB3CF, { 0xE8, 0x84, 0x87 },
	0xB3D0, { 0xF0, 0xAF, 0xA6, 0x83 },
	0xB3D1, { 0xE4, 0x8F, 0xA6 },
	0xB3D2, { 0xE8, 0x83, 0xB7 },
	0xB3D3, { 0xE4, 0x91, 0x99 },
	0xB3D4, { 0xE4, 0x91, 0x9A },
	0xB3D5, { 0xE8, 0x88, 0xAD },
	0xB3D6, { 0xE4, 0x91, 0xA4 },
	0xB3D7, { 0xE8, 0x88, 0xA7 },
	0xB3D8, { 0xE8, 0x88, 0xA9 },
	0xB3D9, { 0xE8, 0x8C, 0x9F },
	0xB3DA, { 0xE8, 0x8D, 0x97 },
	0xB3DB, { 0xE4, 0x92, 0xB4 },
	0xB3DC, { 0xE4, 0x92, 0xB9 },
	0xB3DD, { 0xE4, 0x92, 0xB7 },
	0xB3DE, { 0xE4, 0x92, 0xB5 },
	0xB3DF, { 0xE8, 0x8C, 0xA1 },
	0xB3E0, { 0xE4, 0x93, 0x81 },
	0xB3E1, { 0xE4, 0x92, 0xB1 },
	0xB3E2, { 0xE8, 0x8C, 0x98 },
	0xB3E3, { 0xE8, 0x8D, 0x98 },
	0xB3E4, { 0xE4, 0x92, 0xB3 },
	0xB3E5, { 0xE4, 0x92, 0xBA },
	0xB3E6, { 0xE4, 0x96, 0x8C },
	0xB3E7, { 0xE4, 0x96, 0x8B },
	0xB3E8, { 0xE4, 0x96, 0x8D },
	0xB3E9, { 0xE8, 0x9A, 0x84 },
	0xB3EA, { 0xE8, 0x9A, 0x9F },
	0xB3EB, { 0xE8, 0x9A, 0x9B },
	0xB3EC, { 0xE8, 0x9A, 0x89 },
	0xB3ED, { 0xE8, 0x9A, 0xA6 },
	0xB3EE, { 0xE8, 0x9A, 0x92 },
	0xB3EF, { 0xE8, 0x9A, 0x8F },
	0xB3F0, { 0xE8, 0x9A, 0xA0 },
	0xB3F1, { 0xE8, 0xA1, 0x8F },
	0xB3F2, { 0xE8, 0xA1, 0xB8 },
	0xB3F3, { 0xE8, 0xA1, 0xBA },
	0xB3F4, { 0xE8, 0xA1, 0xAE },
	0xB3F5, { 0xE8, 0xA1, 0xBB },
	0xB3F6, { 0xE8, 0xA2, 0x84 },
	0xB3F7, { 0xE8, 0xA1, 0xB3 },
	0xB3F8, { 0xE4, 0x99, 0xB8 },
	0xB3F9, { 0xE4, 0x99, 0xB7 },
	0xB3FA, { 0xE8, 0xA8, 0x8D },
	0xB3FB, { 0xE8, 0xA8, 0x8B },
	0xB3FC, { 0xE8, 0xA8, 0x99 },
	0xB3FD, { 0xE4, 0x9A, 0xB2 },
	0xB3FE, { 0xE4, 0x9F, 0x96 },
	0xB4A1, { 0xE8, 0xBB, 0x90 },
	0xB4A2, { 0xE4, 0xA1, 0x85 },
	0xB4A3, { 0xE4, 0xA2, 0x92 },
	0xB4A4, { 0xE4, 0xA2, 0x95 },
	0xB4A5, { 0xE8, 0xBF, 0xB9 },
	0xB4A6, { 0xE9, 0x80, 0x89 },
	0xB4A7, { 0xE9, 0x80, 0x88 },
	0xB4A8, { 0xE4, 0xA3, 0x86 },
	0xB4A9, { 0xE9, 0x83, 0x9E },
	0xB4AA, { 0xE9, 0x85, 0x91 },
	0xB4AB, { 0xE4, 0xA3, 0xA7 },
	0xB4AC, { 0xE4, 0xA3, 0xA8 },
	0xB4AD, { 0xE9, 0x87, 0x9B },
	0xB4AE, { 0xE9, 0x87, 0x9F },
	0xB4AF, { 0xE9, 0x87, 0x9E },
	0xB4B0, { 0xE9, 0x87, 0x96 },
	0xB4B1, { 0xE9, 0x87, 0xA0 },
	0xB4B2, { 0xE9, 0x96, 0x85 },
	0xB4B3, { 0xE9, 0x99, 0xA0 },
	0xB4B4, { 0xE9, 0x99, 0x99 },
	0xB4B5, { 0xE4, 0xA7, 0x8B },
	0xB4B6, { 0xE9, 0x99, 0x96 },
	0xB4B7, { 0xE4, 0xA7, 0x8D },
	0xB4B8, { 0xE4, 0xA7, 0xB1 },
	0xB4B9, { 0xE9, 0x9A, 0xBD },
	0xB4BA, { 0xE4, 0xAC, 0xA2 },
	0xB4BB, { 0xE3, 0x90, 0xA1 },
	0xB4BC, { 0xE5, 0x81, 0x82 },
	0xB4BD, { 0xE5, 0x81, 0x99 },
	0xB4BE, { 0xE3, 0x91, 0xAF },
	0xB4BF, { 0xE5, 0x81, 0x84 },
	0xB4C0, { 0xE5, 0x81, 0xA6 },
	0xB4C1, { 0xE5, 0x81, 0x92 },
	0xB4C2, { 0xE5, 0x81, 0x94 },
	0xB4C3, { 0xE5, 0x81, 0xB1 },
	0xB4C4, { 0xE5, 0x81, 0x90 },
	0xB4C5, { 0xE5, 0x81, 0xBB },
	0xB4C6, { 0xE5, 0x81, 0xBC },
	0xB4C7, { 0xE5, 0x81, 0x98 },
	0xB4C8, { 0xE3, 0x91, 0xB0 },
	0xB4C9, { 0xE3, 0x91, 0xA4 },
	0xB4CA, { 0xE5, 0x81, 0xB9 },
	0xB4CB, { 0xE5, 0x81, 0xAC },
	0xB4CC, { 0xE5, 0x81, 0xB8 },
	0xB4CD, { 0xE5, 0x86, 0xA8 },
	0xB4CE, { 0xE5, 0x87, 0x91 },
	0xB4CF, { 0xE5, 0x87, 0x8F },
	0xB4D0, { 0xE5, 0x89, 0xA8 },
	0xB4D1, { 0xE5, 0x89, 0xB6 },
	0xB4D2, { 0xE5, 0x8B, 0x94 },
	0xB4D3, { 0xE3, 0x94, 0xAD },
	0xB4D4, { 0xE5, 0x8E, 0xA0 },
	0xB4D5, { 0xE5, 0x8F, 0x84 },
	0xB4D6, { 0xE3, 0x95, 0x98 },
	0xB4D7, { 0xE5, 0x95, 0x98 },
	0xB4D8, { 0xE5, 0x95, 0x8C },
	0xB4D9, { 0xE5, 0x95, 0xA8 },
	0xB4DA, { 0xE3, 0x96, 0xA6 },
	0xB4DB, { 0xE5, 0x95, 0x89 },
	0xB4DC, { 0xE3, 0x96, 0xA4 },
	0xB4DD, { 0xE3, 0x96, 0x9F },
	0xB4DE, { 0xE5, 0x95, 0x9D },
	0xB4DF, { 0xE5, 0x94, 0xA9 },
	0xB4E0, { 0xF0, 0xA0, 0xB6, 0xAE },
	0xB4E1, { 0xE5, 0x95, 0x94 },
	0xB4E2, { 0xE5, 0x95, 0x93 },
	0xB4E3, { 0xE3, 0x96, 0xA3 },
	0xB4E4, { 0xE5, 0x95, 0x9A },
	0xB4E5, { 0xE3, 0x96, 0xA0 },
	0xB4E6, { 0xE5, 0x94, 0xBA },
	0xB4E7, { 0xE5, 0x94, 0xBF },
	0xB4E8, { 0xE5, 0x94, 0xAB },
	0xB4E9, { 0xE5, 0x9F, 0xAA },
	0xB4EA, { 0xE3, 0x99, 0x8A },
	0xB4EB, { 0xE5, 0x9F, 0xAF },
	0xB4EC, { 0xE3, 0x99, 0x87 },
	0xB4ED, { 0xE3, 0x99, 0x88 },
	0xB4EE, { 0xE5, 0x9F, 0x9D },
	0xB4EF, { 0xE5, 0x9F, 0xBE },
	0xB4F0, { 0xF0, 0xAF, 0xA1, 0x95 },
	0xB4F1, { 0xE5, 0x9F, 0x9E },
	0xB4F2, { 0xE5, 0x9F, 0xA6 },
	0xB4F3, { 0xE3, 0x99, 0x89 },
	0xB4F4, { 0xE5, 0x9F, 0xA8 },
	0xB4F5, { 0xE5, 0x9F, 0xBF },
	0xB4F6, { 0xE5, 0xA0, 0x83 },
	0xB4F7, { 0xE5, 0xA3, 0xB7 },
	0xB4F8, { 0xE6, 0xA2, 0xA6 },
	0xB4F9, { 0xE5, 0xA4, 0x9F },
	0xB4FA, { 0xE3, 0x9A, 0x9E },
	0xB4FB, { 0xE5, 0xA5, 0x9B },
	0xB4FC, { 0xE5, 0xA5, 0x9D },
	0xB4FD, { 0xE5, 0xA5, 0x9E },
	0xB4FE, { 0xF0, 0xA1, 0x98, 0xB7 },
	0xB5A1, { 0xE3, 0x9B, 0xA8 },
	0xB5A2, { 0xE5, 0xA8, 0xAB },
	0xB5A3, { 0xE3, 0x9B, 0xAC },
	0xB5A4, { 0xE5, 0xA8, 0xBB },
	0xB5A5, { 0xE3, 0x9B, 0xAD },
	0xB5A6, { 0xE3, 0x9B, 0xA6 },
	0xB5A7, { 0xE5, 0xA9, 0xA1 },
	0xB5A8, { 0xE5, 0xA8, 0xBA },
	0xB5A9, { 0xE5, 0xA9, 0xAE },
	0xB5AA, { 0xE5, 0xA9, 0x8B },
	0xB5AB, { 0xE5, 0xA9, 0xAB },
	0xB5AC, { 0xE3, 0x9B, 0xAB },
	0xB5AD, { 0xE3, 0x9B, 0xA7 },
	0xB5AE, { 0xE5, 0xA9, 0x85 },
	0xB5AF, { 0xE5, 0xA9, 0x8E },
	0xB5B0, { 0xE5, 0xA9, 0xA8 },
	0xB5B1, { 0xE5, 0xA8, 0xBD },
	0xB5B2, { 0xE5, 0xA9, 0xB1 },
	0xB5B3, { 0xE5, 0xA8, 0xBF },
	0xB5B4, { 0xE5, 0xA9, 0xAF },
	0xB5B5, { 0xE5, 0xA9, 0xB5 },
	0xB5B6, { 0xE3, 0x9B, 0xA9 },
	0xB5B7, { 0xE5, 0xA9, 0xB3 },
	0xB5B8, { 0xE5, 0xA8, 0xAC },
	0xB5B9, { 0xE5, 0xA9, 0x99 },
	0xB5BA, { 0xE5, 0xA9, 0x94 },
	0xB5BB, { 0xE5, 0xA9, 0x8F },
	0xB5BC, { 0xE5, 0xA9, 0xA3 },
	0xB5BD, { 0xE3, 0x9D, 0x9C },
	0xB5BE, { 0xE3, 0x9D, 0x9D },
	0xB5BF, { 0xE5, 0xAF, 0x88 },
	0xB5C0, { 0xE3, 0x9D, 0xA0 },
	0xB5C1, { 0xE5, 0xAF, 0x83 },
	0xB5C2, { 0xE3, 0x9D, 0x9B },
	0xB5C3, { 0xE5, 0xB1, 0x9B },
	0xB5C4, { 0xE5, 0xB1, 0xA1 },
	0xB5C5, { 0xE3, 0x9E, 0x99 },
	0xB5C6, { 0xE5, 0xB4, 0xA1 },
	0xB5C7, { 0xE5, 0xB4, 0x8A },
	0xB5C8, { 0xE5, 0xB4, 0x89 },
	0xB5C9, { 0xE3, 0x9F, 0x98 },
	0xB5CA, { 0xE5, 0xB4, 0xAC },
	0xB5CB, { 0xE5, 0xB4, 0x88 },
	0xB5CC, { 0xE3, 0x9F, 0x9A },
	0xB5CD, { 0xE3, 0x9F, 0x9D },
	0xB5CE, { 0xE5, 0xB4, 0xAA },
	0xB5CF, { 0xE5, 0xB4, 0x95 },
	0xB5D0, { 0xE3, 0x9F, 0xA0 },
	0xB5D1, { 0xE5, 0xB4, 0x90 },
	0xB5D2, { 0xE5, 0xB4, 0x93 },
	0xB5D3, { 0xE3, 0x9F, 0xA5 },
	0xB5D4, { 0xE5, 0xB4, 0xAF },
	0xB5D5, { 0xE5, 0xB4, 0x98 },
	0xB5D6, { 0xE3, 0x9F, 0x97 },
	0xB5D7, { 0xE5, 0xB7, 0xA3 },
	0xB5D8, { 0xE5, 0xB8, 0xB9 },
	0xB5D9, { 0xE5, 0xB8, 0xB5 },
	0xB5DA, { 0xE5, 0xB8, 0xBA },
	0xB5DB, { 0xE5, 0xB8, 0xB2 },
	0xB5DC, { 0xE3, 0xA1, 0x8E },
	0xB5DD, { 0xE3, 0xA2, 0x8C },
	0xB5DE, { 0xE3, 0xA2, 0x88 },
	0xB5DF, { 0xF0, 0xAF, 0xA2, 0x8D },
	0xB5E0, { 0xE5, 0xBA, 0xBB },
	0xB5E1, { 0xE5, 0xBA, 0xBA },
	0xB5E2, { 0xE5, 0xBC, 0xB4 },
	0xB5E3, { 0xE5, 0xBC, 0xB9 },
	0xB5E4, { 0xE3, 0xA3, 0x8E },
	0xB5E5, { 0xF0, 0xAF, 0xA2, 0x9C },
	0xB5E6, { 0xE3, 0xA3, 0xA5 },
	0xB5E7, { 0xE3, 0xA3, 0xA6 },
	0xB5E8, { 0xE6, 0x82, 0x98 },
	0xB5E9, { 0xE3, 0xA4, 0xB2 },
	0xB5EA, { 0xE6, 0x83, 0x90 },
	0xB5EB, { 0xE3, 0xA5, 0x80 },
	0xB5EC, { 0xE3, 0xA5, 0x87 },
	0xB5ED, { 0xE3, 0xA5, 0x8C },
	0xB5EE, { 0xE6, 0x83, 0x97 },
	0xB5EF, { 0xE6, 0x82, 0xAA },
	0xB5F0, { 0xE3, 0xA4, 0xB5 },
	0xB5F1, { 0xE6, 0x82, 0xA1 },
	0xB5F2, { 0xE6, 0x82, 0xA4 },
	0xB5F3, { 0xE3, 0xA4, 0xB0 },
	0xB5F4, { 0xE6, 0x83, 0xAE },
	0xB5F5, { 0xE3, 0xA5, 0x83 },
	0xB5F6, { 0xE6, 0x83, 0xA7 },
	0xB5F7, { 0xE3, 0xA5, 0x8D },
	0xB5F8, { 0xE6, 0x83, 0xA8 },
	0xB5F9, { 0xE6, 0x83, 0x9E },
	0xB5FA, { 0xE3, 0xA6, 0xB7 },
	0xB5FB, { 0xE3, 0xA7, 0xB3 },
	0xB5FC, { 0xE6, 0x8D, 0xBE },
	0xB5FD, { 0xE6, 0x8E, 0x8B },
	0xB5FE, { 0xE3, 0xA8, 0x82 },
	0xB6A1, { 0xE3, 0xA8, 0x8B },
	0xB6A2, { 0xE6, 0x8D, 0xB9 },
	0xB6A3, { 0xE6, 0x8E, 0x86 },
	0xB6A4, { 0xE6, 0x8E, 0x93 },
	0xB6A5, { 0xE3, 0xA8, 0x84 },
	0xB6A6, { 0xE6, 0x8D, 0xB3 },
	0xB6A7, { 0xE6, 0x8D, 0xAA },
	0xB6A8, { 0xF0, 0xAF, 0xA2, 0xBA },
	0xB6A9, { 0xE6, 0x8D, 0xAC },
	0xB6AA, { 0xE3, 0xA8, 0x88 },
	0xB6AB, { 0xE6, 0x8D, 0xBF },
	0xB6AC, { 0xE3, 0xA7, 0xBC },
	0xB6AD, { 0xE6, 0x8E, 0xB2 },
	0xB6AE, { 0xE6, 0x8E, 0xBA },
	0xB6AF, { 0xE3, 0xA7, 0xBF },
	0xB6B0, { 0xE3, 0xA8, 0x80 },
	0xB6B1, { 0xE6, 0x8D, 0xA6 },
	0xB6B2, { 0xE6, 0x8D, 0xB4 },
	0xB6B3, { 0xE3, 0xAA, 0x8B },
	0xB6B4, { 0xE6, 0x95, 0x9A },
	0xB6B5, { 0xE3, 0xAA, 0x8D },
	0xB6B6, { 0xE6, 0x95, 0x8E },
	0xB6B7, { 0xE6, 0x95, 0x8D },
	0xB6B8, { 0xE6, 0x96, 0x8D },
	0xB6B9, { 0xE6, 0x96, 0x8E },
	0xB6BA, { 0xE6, 0x96, 0xAD },
	0xB6BB, { 0xE3, 0xAB, 0x8A },
	0xB6BC, { 0xE6, 0x97, 0x87 },
	0xB6BD, { 0xE6, 0x97, 0x8A },
	0xB6BE, { 0xE3, 0xAB, 0x8B },
	0xB6BF, { 0xE6, 0x97, 0x89 },
	0xB6C0, { 0xF0, 0xAF, 0xA3, 0x8B },
	0xB6C1, { 0xE6, 0x97, 0xA3 },
	0xB6C2, { 0xE6, 0x99, 0x97 },
	0xB6C3, { 0xE3, 0xAB, 0xB3 },
	0xB6C4, { 0xE6, 0x99, 0xA3 },
	0xB6C5, { 0xE6, 0x99, 0xA7 },
	0xB6C6, { 0xE6, 0x9C, 0x9A },
	0xB6C7, { 0xE6, 0x9C, 0x99 },
	0xB6C8, { 0xE6, 0x9C, 0x96 },
	0xB6C9, { 0xE3, 0xAC, 0xB6 },
	0xB6CA, { 0xE3, 0xAD, 0xAA },
	0xB6CB, { 0xE6, 0xA2, 0x9E },
	0xB6CC, { 0xE6, 0xA2, 0xB6 },
	0xB6CD, { 0xE6, 0xA2, 0x98 },
	0xB6CE, { 0xE6, 0xA1, 0xB3 },
	0xB6CF, { 0xE3, 0xAD, 0xAB },
	0xB6D0, { 0xE6, 0xA2, 0x9A },
	0xB6D1, { 0xE6, 0xA2, 0x8E },
	0xB6D2, { 0xE6, 0xA2, 0xB7 },
	0xB6D3, { 0xE6, 0xA3, 0x9B },
	0xB6D4, { 0xE6, 0xA2, 0xA5 },
	0xB6D5, { 0xE6, 0xA1, 0xAC },
	0xB6D6, { 0xE6, 0xA3, 0x81 },
	0xB6D7, { 0xE6, 0xA2, 0x84 },
	0xB6D8, { 0xE3, 0xAD, 0xB1 },
	0xB6D9, { 0xE3, 0xAD, 0xA8 },
	0xB6DA, { 0xE6, 0xA2, 0x95 },
	0xB6DB, { 0xE6, 0xA1, 0xBA },
	0xB6DC, { 0xE6, 0xA2, 0x99 },
	0xB6DD, { 0xE3, 0xAD, 0xB2 },
	0xB6DE, { 0xE6, 0xA2, 0xB8 },
	0xB6DF, { 0xE6, 0xA2, 0xB9 },
	0xB6E0, { 0xE6, 0xA1, 0xB0 },
	0xB6E1, { 0xE3, 0xB0, 0xAE },
	0xB6E2, { 0xE6, 0xAC, 0xB5 },
	0xB6E3, { 0xE3, 0xB1, 0xA2 },
	0xB6E4, { 0xE6, 0xAE, 0x90 },
	0xB6E5, { 0xE6, 0xAE, 0xBB },
	0xB6E6, { 0xE6, 0xAF, 0xAD },
	0xB6E7, { 0xE3, 0xB2, 0x98 },
	0xB6E8, { 0xE3, 0xB2, 0xB5 },
	0xB6E9, { 0xE3, 0xB3, 0xAB },
	0xB6EA, { 0xE6, 0xB7, 0x81 },
	0xB6EB, { 0xE6, 0xB7, 0x83 },
	0xB6EC, { 0xE6, 0xB7, 0x8E },
	0xB6ED, { 0xE3, 0xB3, 0xBB },
	0xB6EE, { 0xE3, 0xB3, 0xB8 },
	0xB6EF, { 0xE6, 0xB6, 0xAD },
	0xB6F0, { 0xE6, 0xB8, 0x84 },
	0xB6F1, { 0xE3, 0xB3, 0xB5 },
	0xB6F2, { 0xE6, 0xB6, 0xB9 },
	0xB6F3, { 0xE3, 0xB4, 0x88 },
	0xB6F4, { 0xE6, 0xB7, 0xA7 },
	0xB6F5, { 0xF0, 0xAF, 0xA4, 0x87 },
	0xB6F6, { 0xE6, 0xB8, 0x88 },
	0xB6F7, { 0xE6, 0xB8, 0x86 },
	0xB6F8, { 0xE3, 0xB4, 0x8A },
	0xB6F9, { 0xE6, 0xB8, 0x8A },
	0xB6FA, { 0xE6, 0xB6, 0xB0 },
	0xB6FB, { 0xE3, 0xB4, 0x86 },
	0xB6FC, { 0xE6, 0xB7, 0xB8 },
	0xB6FD, { 0xE6, 0xB8, 0x8C },
	0xB6FE, { 0xE3, 0xB3, 0xBD },
	0xB7A1, { 0xE6, 0xB6, 0xB1 },
	0xB7A2, { 0xE3, 0xB3, 0xBA },
	0xB7A3, { 0xE6, 0xB8, 0x82 },
	0xB7A4, { 0xE6, 0xB8, 0x87 },
	0xB7A5, { 0xE6, 0xB8, 0x89 },
	0xB7A6, { 0xE6, 0xB8, 0x81 },
	0xB7A7, { 0xE6, 0xB8, 0x97 },
	0xB7A8, { 0xE6, 0xB7, 0xBF },
	0xB7A9, { 0xE6, 0xB8, 0x92 },
	0xB7AA, { 0xE3, 0xB6, 0xBA },
	0xB7AB, { 0xE3, 0xB6, 0xB9 },
	0xB7AC, { 0xE7, 0x84, 0x83 },
	0xB7AD, { 0xE7, 0x84, 0x87 },
	0xB7AE, { 0xE7, 0x84, 0x81 },
	0xB7AF, { 0xE7, 0x83, 0xB5 },
	0xB7B0, { 0xE7, 0x83, 0xB1 },
	0xB7B1, { 0xE7, 0x84, 0x88 },
	0xB7B2, { 0xE7, 0x83, 0xB2 },
	0xB7B3, { 0xE7, 0x84, 0x8F },
	0xB7B4, { 0xE3, 0xB6, 0xBB },
	0xB7B5, { 0xE7, 0x83, 0xBE },
	0xB7B6, { 0xE3, 0xB8, 0x98 },
	0xB7B7, { 0xE3, 0xB9, 0x80 },
	0xB7B8, { 0xE3, 0xB8, 0xBD },
	0xB7B9, { 0xE7, 0x8C, 0x9A },
	0xB7BA, { 0xE7, 0x8C, 0x90 },
	0xB7BB, { 0xE7, 0x8C, 0x8E },
	0xB7BC, { 0xE7, 0x90, 0x82 },
	0xB7BD, { 0xE7, 0x8F, 0xB3 },
	0xB7BE, { 0xE3, 0xBB, 0x8D },
	0xB7BF, { 0xE3, 0xBB, 0x89 },
	0xB7C0, { 0xE7, 0x8F, 0xBB },
	0xB7C1, { 0xE3, 0xBB, 0x8B },
	0xB7C2, { 0xE3, 0xBB, 0x8A },
	0xB7C3, { 0xE3, 0xBB, 0x8E },
	0xB7C4, { 0xE7, 0x94, 0x9B },
	0xB7C5, { 0xE7, 0x94, 0xA3 },
	0xB7C6, { 0xE7, 0x95, 0xA1 },
	0xB7C7, { 0xE7, 0x95, 0xA8 },
	0xB7C8, { 0xE3, 0xBD, 0x9E },
	0xB7C9, { 0xE7, 0x95, 0xA7 },
	0xB7CA, { 0xE7, 0x97, 0x93 },
	0xB7CB, { 0xE3, 0xBE, 0x91 },
	0xB7CC, { 0xE3, 0xBE, 0x8C },
	0xB7CD, { 0xE7, 0x9A, 0x90 },
	0xB7CE, { 0xE3, 0xBF, 0xA1 },
	0xB7CF, { 0xE4, 0x80, 0x82 },
	0xB7D0, { 0xE7, 0x9B, 0x95 },
	0xB7D1, { 0xE7, 0x9B, 0x97 },
	0xB7D2, { 0xE7, 0x9B, 0x96 },
	0xB7D3, { 0xE7, 0x9C, 0xB0 },
	0xB7D4, { 0xE4, 0x80, 0xAB },
	0xB7D5, { 0xE7, 0x9C, 0xA6 },
	0xB7D6, { 0xE4, 0x80, 0xAA },
	0xB7D7, { 0xE7, 0x9D, 0x80 },
	0xB7D8, { 0xE3, 0xB8, 0x94 },
	0xB7D9, { 0xE7, 0x9C, 0x9E },
	0xB7DA, { 0xE4, 0x82, 0xAD },
	0xB7DB, { 0xE4, 0x82, 0xA3 },
	0xB7DC, { 0xE4, 0x82, 0xAB },
	0xB7DD, { 0xE7, 0xA1, 0x87 },
	0xB7DE, { 0xE4, 0x82, 0xAF },
	0xB7DF, { 0xE7, 0xA1, 0x8B },
	0xB7E0, { 0xE7, 0xA1, 0x91 },
	0xB7E1, { 0xE7, 0xA1, 0x8F },
	0xB7E2, { 0xE7, 0xA1, 0x82 },
	0xB7E3, { 0xE7, 0xA1, 0x86 },
	0xB7E4, { 0xE4, 0x84, 0x84 },
	0xB7E5, { 0xE7, 0xA5, 0xAE },
	0xB7E6, { 0xE7, 0xA5, 0xAC },
	0xB7E7, { 0xE7, 0xA7, 0xB2 },
	0xB7E8, { 0xE4, 0x85, 0x84 },
	0xB7E9, { 0xE7, 0xA7, 0xB1 },
	0xB7EA, { 0xE7, 0xA7, 0xB5 },
	0xB7EB, { 0xE7, 0xA7, 0xB3 },
	0xB7EC, { 0xE7, 0xA7, 0xB9 },
	0xB7ED, { 0xE4, 0x84, 0xBD },
	0xB7EE, { 0xE4, 0x85, 0x87 },
	0xB7EF, { 0xE4, 0x86, 0x9C },
	0xB7F0, { 0xE7, 0xAA, 0x9A },
	0xB7F1, { 0xE7, 0xAA, 0x93 },
	0xB7F2, { 0xE7, 0xAA, 0x91 },
	0xB7F3, { 0xE7, 0xAB, 0xA1 },
	0xB7F4, { 0xE4, 0x87, 0xA0 },
	0xB7F5, { 0xE4, 0x87, 0xA4 },
	0xB7F6, { 0xE7, 0xAC, 0xA1 },
	0xB7F7, { 0xE7, 0xAC, 0x9C },
	0xB7F8, { 0xE7, 0xAC, 0x96 },
	0xB7F9, { 0xE7, 0xAC, 0x97 },
	0xB7FA, { 0xE7, 0xAC, 0xB6 },
	0xB7FB, { 0xE7, 0xAC, 0x9F },
	0xB7FC, { 0xE4, 0x8A, 0x80 },
	0xB7FD, { 0xE7, 0xB2, 0x93 },
	0xB7FE, { 0xE7, 0xB2, 0x99 },
	0xB8A1, { 0xE7, 0xB2, 0x9A },
	0xB8A2, { 0xE7, 0xB2, 0x9C },
	0xB8A3, { 0xE4, 0x8B, 0x8A },
	0xB8A4, { 0xE7, 0xB5, 0x89 },
	0xB8A5, { 0xE4, 0x8B, 0x94 },
	0xB8A6, { 0xE7, 0xB4, 0xB4 },
	0xB8A7, { 0xE7, 0xB4, 0xB7 },
	0xB8A8, { 0xE4, 0x8B, 0x92 },
	0xB8A9, { 0xE7, 0xB4, 0xAD },
	0xB8AA, { 0xE4, 0x8B, 0x8B },
	0xB8AB, { 0xE7, 0xB5, 0x8C },
	0xB8AC, { 0xE4, 0x8B, 0x8E },
	0xB8AD, { 0xE4, 0x8B, 0x93 },
	0xB8AE, { 0xE7, 0xB5, 0x88 },
	0xB8AF, { 0xE4, 0x8D, 0x84 },
	0xB8B0, { 0xE4, 0x8D, 0x88 },
	0xB8B1, { 0xE7, 0xBC, 0xBB },
	0xB8B2, { 0xE4, 0x8D, 0x85 },
	0xB8B3, { 0xE4, 0x8E, 0x81 },
	0xB8B4, { 0xE4, 0x8E, 0x86 },
	0xB8B5, { 0xE4, 0x8E, 0x85 },
	0xB8B6, { 0xE8, 0x80, 0x88 },
	0xB8B7, { 0xE8, 0x80, 0x9A },
	0xB8B8, { 0xE4, 0x8E, 0xA3 },
	0xB8B9, { 0xE8, 0x80, 0x9D },
	0xB8BA, { 0xE4, 0x8E, 0xB5 },
	0xB8BB, { 0xE8, 0x81, 0x89 },
	0xB8BC, { 0xE8, 0x81, 0x85 },
	0xB8BD, { 0xE8, 0x81, 0x84 },
	0xB8BE, { 0xE7, 0xB2, 0x9B },
	0xB8BF, { 0xE4, 0x8F, 0xBA },
	0xB8C0, { 0xE4, 0x8F, 0xB9 },
	0xB8C1, { 0xE8, 0x84, 0xAA },
	0xB8C2, { 0xE8, 0x84, 0xAE },
	0xB8C3, { 0xE4, 0x8F, 0xBB },
	0xB8C4, { 0xE4, 0x8F, 0xB2 },
	0xB8C5, { 0xE8, 0x84, 0xB1 },
	0xB8C6, { 0xE4, 0x8F, 0xAF },
	0xB8C7, { 0xE8, 0x84, 0x9A },
	0xB8C8, { 0xE8, 0x84, 0xB4 },
	0xB8C9, { 0xE8, 0x84, 0x97 },
	0xB8CA, { 0xE4, 0x91, 0x9B },
	0xB8CB, { 0xE4, 0x91, 0xA6 },
	0xB8CC, { 0xE4, 0x93, 0x8E },
	0xB8CD, { 0xE8, 0x8C, 0x9D },
	0xB8CE, { 0xE8, 0x8D, 0xB1 },
	0xB8CF, { 0xE8, 0x8E, 0x84 },
	0xB8D0, { 0xE8, 0x8E, 0x80 },
	0xB8D1, { 0xE8, 0x8D, 0xB2 },
	0xB8D2, { 0xE8, 0x8E, 0xA1 },
	0xB8D3, { 0xE3, 0x96, 0xB4 },
	0xB8D4, { 0xE8, 0x8D, 0xB9 },
	0xB8D5, { 0xE8, 0x8E, 0x91 },
	0xB8D6, { 0xE4, 0x93, 0x88 },
	0xB8D7, { 0xE8, 0x8E, 0x9F },
	0xB8D8, { 0xE8, 0x8E, 0xAD },
	0xB8D9, { 0xE4, 0x93, 0x91 },
	0xB8DA, { 0xE4, 0x93, 0x85 },
	0xB8DB, { 0xE8, 0x8C, 0xA3 },
	0xB8DC, { 0xE4, 0x93, 0x92 },
	0xB8DD, { 0xE8, 0x8E, 0x85 },
	0xB8DE, { 0xE8, 0x8E, 0x9C },
	0xB8DF, { 0xE8, 0x8E, 0xB7 },
	0xB8E0, { 0xE8, 0x99, 0x98 },
	0xB8E1, { 0xE8, 0x99, 0x9A },
	0xB8E2, { 0xE4, 0x96, 0x8F },
	0xB8E3, { 0xE8, 0x99, 0x97 },
	0xB8E4, { 0xE8, 0x9A, 0xB2 },
	0xB8E5, { 0xE4, 0x96, 0xA7 },
	0xB8E6, { 0xE8, 0x9A, 0xAE },
	0xB8E7, { 0xE4, 0x96, 0xA5 },
	0xB8E8, { 0xE4, 0x96, 0xA4 },
	0xB8E9, { 0xE4, 0x98, 0x91 },
	0xB8EA, { 0xE8, 0xA1, 0x85 },
	0xB8EB, { 0xE8, 0xA2, 0x9C },
	0xB8EC, { 0xE8, 0xA2, 0x94 },
	0xB8ED, { 0xE8, 0xA2, 0xA3 },
	0xB8EE, { 0xE8, 0xA2, 0x8F },
	0xB8EF, { 0xE8, 0xA2, 0xA5 },
	0xB8F0, { 0xE8, 0xA2, 0xA9 },
	0xB8F1, { 0xE8, 0xA2, 0xA6 },
	0xB8F2, { 0xE8, 0xA2, 0x8A },
	0xB8F3, { 0xE8, 0xA2, 0xA0 },
	0xB8F4, { 0xE8, 0xA2, 0x90 },
	0xB8F5, { 0xE8, 0xA6, 0x92 },
	0xB8F6, { 0xE8, 0xA6, 0x91 },
	0xB8F7, { 0xE8, 0xA6, 0x94 },
	0xB8F8, { 0xE4, 0x9A, 0xB5 },
	0xB8F9, { 0xE8, 0xA8, 0xA6 },
	0xB8FA, { 0xE8, 0xA8, 0xB2 },
	0xB8FB, { 0xE8, 0xA8, 0xA8 },
	0xB8FC, { 0xE4, 0x9A, 0xB4 },
	0xB8FD, { 0xE4, 0x9A, 0xBD },
	0xB8FE, { 0xE8, 0xA8, 0x9C },
	0xB9A1, { 0xE4, 0x9A, 0xBB },
	0xB9A2, { 0xE8, 0xA8, 0xAB },
	0xB9A3, { 0xE8, 0xA8, 0xA0 },
	0xB9A4, { 0xE4, 0x9A, 0xB9 },
	0xB9A5, { 0xE8, 0xA8, 0xA9 },
	0xB9A6, { 0xE4, 0x9B, 0x82 },
	0xB9A7, { 0xE4, 0x9A, 0xBE },
	0xB9A8, { 0xE4, 0x9A, 0xBA },
	0xB9A9, { 0xE8, 0xA8, 0xA1 },
	0xB9AA, { 0xE8, 0xB0, 0xBA },
	0xB9AB, { 0xE3, 0xAA, 0xB7 },
	0xB9AC, { 0xE8, 0xB1, 0x9B },
	0xB9AD, { 0xE8, 0xB1, 0x98 },
	0xB9AE, { 0xE8, 0xB1, 0xBC },
	0xB9AF, { 0xE4, 0x9D, 0x98 },
	0xB9B0, { 0xE8, 0xB2, 0xA6 },
	0xB9B1, { 0xE8, 0xB2, 0xAE },
	0xB9B2, { 0xE8, 0xB2, 0xAD },
	0xB9B3, { 0xE8, 0xB5, 0xA5 },
	0xB9B4, { 0xE4, 0x9E, 0x9B },
	0xB9B5, { 0xE8, 0xB5, 0xBE },
	0xB9B6, { 0xE4, 0x9E, 0x9C },
	0xB9B7, { 0xE8, 0xB5, 0xBC },
	0xB9B8, { 0xE8, 0xB5, 0xBF },
	0xB9B9, { 0xE8, 0xB5, 0xBA },
	0xB9BA, { 0xE8, 0xB6, 0xBD },
	0xB9BB, { 0xE4, 0x9F, 0x9A },
	0xB9BC, { 0xE4, 0x9F, 0x9E },
	0xB9BD, { 0xE8, 0xB7, 0x80 },
	0xB9BE, { 0xE8, 0xB6, 0xBB },
	0xB9BF, { 0xE8, 0xBA, 0xAD },
	0xB9C0, { 0xE8, 0xBA, 0xAF },
	0xB9C1, { 0xE8, 0xBB, 0x96 },
	0xB9C2, { 0xE4, 0xA1, 0x8D },
	0xB9C3, { 0xE4, 0xA1, 0x86 },
	0xB9C4, { 0xE4, 0xA1, 0x87 },
	0xB9C5, { 0xE4, 0xA1, 0x8B },
	0xB9C6, { 0xE4, 0xA1, 0x8C },
	0xB9C7, { 0xE8, 0xBB, 0x99 },
	0xB9C8, { 0xE4, 0xA1, 0x88 },
	0xB9C9, { 0xE4, 0xA2, 0x99 },
	0xB9CA, { 0xE9, 0x80, 0x92 },
	0xB9CB, { 0xE9, 0x80, 0x8E },
	0xB9CC, { 0xE9, 0x80, 0xA5 },
	0xB9CD, { 0xE4, 0xA2, 0x9B },
	0xB9CE, { 0xE9, 0x80, 0x93 },
	0xB9CF, { 0xE9, 0x83, 0xAE },
	0xB9D0, { 0xE4, 0xA3, 0x8E },
	0xB9D1, { 0xE9, 0x82, 0xAB },
	0xB9D2, { 0xE9, 0x83, 0xB7 },
	0xB9D3, { 0xE4, 0xA3, 0xAB },
	0xB9D4, { 0xE9, 0x85, 0x99 },
	0xB9D5, { 0xE9, 0x85, 0x94 },
	0xB9D6, { 0xE9, 0x87, 0xB2 },
	0xB9D7, { 0xE9, 0x87, 0xB0 },
	0xB9D8, { 0xE9, 0x87, 0xA5 },
	0xB9D9, { 0xE9, 0x87, 0xB6 },
	0xB9DA, { 0xE4, 0xA4, 0x9C },
	0xB9DB, { 0xE4, 0xA6, 0x8C },
	0xB9DC, { 0xE9, 0x96, 0x87 },
	0xB9DD, { 0xE4, 0xA7, 0x91 },
	0xB9DE, { 0xE9, 0x99, 0x9A },
	0xB9DF, { 0xE4, 0xA7, 0x96 },
	0xB9E0, { 0xE4, 0xA7, 0x93 },
	0xB9E1, { 0xE9, 0x99, 0xAE },
	0xB9E2, { 0xE4, 0xA7, 0x94 },
	0xB9E3, { 0xE4, 0xA7, 0x90 },
	0xB9E4, { 0xE4, 0xA7, 0x95 },
	0xB9E5, { 0xE9, 0x99, 0xB9 },
	0xB9E6, { 0xE4, 0xA8, 0x8B },
	0xB9E7, { 0xE9, 0xA3, 0xA1 },
	0xB9E8, { 0xE9, 0xA3, 0xA6 },
	0xB9E9, { 0xE4, 0xAF, 0x86 },
	0xB9EA, { 0xE9, 0xBB, 0x84 },
	0xB9EB, { 0xE9, 0xBB, 0x92 },
	0xB9EC, { 0xE4, 0xBA, 0x80 },
	0xB9ED, { 0xE3, 0x90, 0xA4 },
	0xB9EE, { 0xE4, 0xBA, 0x81 },
	0xB9EF, { 0xE5, 0x82, 0x8F },
	0xB9F0, { 0xE5, 0x82, 0x97 },
	0xB9F1, { 0xE5, 0x82, 0x88 },
	0xB9F2, { 0xE5, 0x82, 0x89 },
	0xB9F3, { 0xE3, 0x91, 0xB4 },
	0xB9F4, { 0xE3, 0x91, 0xBA },
	0xB9F5, { 0xE5, 0x82, 0x81 },
	0xB9F6, { 0xE5, 0x85, 0xA0 },
	0xB9F7, { 0xF0, 0xA0, 0x95, 0xA4 },
	0xB9F8, { 0xE3, 0x93, 0x83 },
	0xB9F9, { 0xE5, 0xB9, 0x82 },
	0xB9FA, { 0xE5, 0x87, 0x93 },
	0xB9FB, { 0xE3, 0x93, 0x94 },
	0xB9FC, { 0xE3, 0x93, 0x95 },
	0xB9FD, { 0xE5, 0x87, 0x92 },
	0xB9FE, { 0xE5, 0x87, 0x96 },
	0xBAA1, { 0xE5, 0x89, 0xB3 },
	0xBAA2, { 0xE3, 0x93, 0xBB },
	0xBAA3, { 0xE5, 0x89, 0xB0 },
	0xBAA4, { 0xE3, 0x93, 0xB7 },
	0xBAA5, { 0xE3, 0x94, 0xB2 },
	0xBAA6, { 0xF0, 0xAF, 0xA0, 0xB3 },
	0xBAA7, { 0xE5, 0x8E, 0xA8 },
	0xBAA8, { 0xE5, 0x8E, 0xA6 },
	0xBAA9, { 0xE5, 0x8F, 0x85 },
	0xBAAA, { 0xE5, 0x96, 0x97 },
	0xBAAB, { 0xE5, 0x97, 0x9E },
	0xBAAC, { 0xE3, 0x96, 0xBA },
	0xBAAD, { 0xE3, 0x96, 0xBF },
	0xBAAE, { 0xE5, 0x96, 0x96 },
	0xBAAF, { 0xE5, 0x96, 0xB4 },
	0xBAB0, { 0xE3, 0x97, 0x87 },
	0xBAB1, { 0xE5, 0x96, 0x85 },
	0xBAB2, { 0xE3, 0x96, 0xB7 },
	0xBAB3, { 0xE5, 0x96, 0x9B },
	0xBAB4, { 0xE5, 0x96, 0xA0 },
	0xBAB5, { 0xE3, 0x96, 0xB9 },
	0xBAB6, { 0xE5, 0x95, 0x99 },
	0xBAB7, { 0xE3, 0x97, 0x83 },
	0xBAB8, { 0xE5, 0x96, 0x86 },
	0xBAB9, { 0xE3, 0x96, 0xBD },
	0xBABA, { 0xE3, 0x97, 0x90 },
	0xBABB, { 0xE5, 0x96, 0xAF },
	0xBABC, { 0xE5, 0x95, 0xBA },
	0xBABD, { 0xE3, 0x97, 0x81 },
	0xBABE, { 0xE3, 0x96, 0xBE },
	0xBABF, { 0xE3, 0x97, 0x8D },
	0xBAC0, { 0xE5, 0x96, 0x9E },
	0xBAC1, { 0xE3, 0x97, 0x8B },
	0xBAC2, { 0xE5, 0x96, 0xA9 },
	0xBAC3, { 0xE5, 0x9C, 0x8F },
	0xBAC4, { 0xE5, 0x9C, 0x8E },
	0xBAC5, { 0xE5, 0xA0, 0x9A },
	0xBAC6, { 0xE3, 0x99, 0x8F },
	0xBAC7, { 0xE5, 0xA0, 0x9F },
	0xBAC8, { 0xE3, 0x99, 0x93 },
	0xBAC9, { 0xE5, 0xA0, 0xBC },
	0xBACA, { 0xE5, 0xA0, 0x98 },
	0xBACB, { 0xE5, 0xA0, 0xBE },
	0xBACC, { 0xE5, 0xA0, 0xA6 },
	0xBACD, { 0xE3, 0x99, 0x95 },
	0xBACE, { 0xE5, 0xA0, 0xBA },
	0xBACF, { 0xF0, 0xA1, 0x8D, 0xA4 },
	0xBAD0, { 0xE5, 0xA0, 0xA2 },
	0xBAD1, { 0xE3, 0x99, 0x91 },
	0xBAD2, { 0xE5, 0xA3, 0xBB },
	0xBAD3, { 0xE5, 0xA5, 0xA3 },
	0xBAD4, { 0xE5, 0xA5, 0xA4 },
	0xBAD5, { 0xE3, 0x9A, 0x9F },
	0xBAD6, { 0xE5, 0xAA, 0xA8 },
	0xBAD7, { 0xE5, 0xAA, 0xA3 },
	0xBAD8, { 0xE5, 0xAA, 0x82 },
	0xBAD9, { 0xE5, 0xAA, 0x88 },
	0xBADA, { 0xE5, 0xAA, 0xA1 },
	0xBADB, { 0xE5, 0xAA, 0x85 },
	0xBADC, { 0xE5, 0xAA, 0x98 },
	0xBADD, { 0xE3, 0x9B, 0xBE },
	0xBADE, { 0xE5, 0xAA, 0x99 },
	0xBADF, { 0xE3, 0x9B, 0xBB },
	0xBAE0, { 0xE5, 0xAA, 0x89 },
	0xBAE1, { 0xE5, 0xAA, 0x81 },
	0xBAE2, { 0xE5, 0xAA, 0x96 },
	0xBAE3, { 0xE5, 0xAA, 0x80 },
	0xBAE4, { 0xE3, 0x9B, 0xB1 },
	0xBAE5, { 0xE3, 0x9B, 0xB5 },
	0xBAE6, { 0xE5, 0xAA, 0x91 },
	0xBAE7, { 0xE3, 0x9B, 0xAF },
	0xBAE8, { 0xE3, 0x9C, 0x84 },
	0xBAE9, { 0xE3, 0x9C, 0x83 },
	0xBAEA, { 0xE3, 0x9B, 0xB4 },
	0xBAEB, { 0xE5, 0xAB, 0x8F },
	0xBAEC, { 0xE3, 0x9B, 0xB3 },
	0xBAED, { 0xE3, 0x9C, 0x82 },
	0xBAEE, { 0xE3, 0x9B, 0xB7 },
	0xBAEF, { 0xE3, 0x9B, 0xBA },
	0xBAF0, { 0xE3, 0x9B, 0xBD },
	0xBAF1, { 0xE3, 0x9B, 0xAE },
	0xBAF2, { 0xE5, 0xAA, 0x87 },
	0xBAF3, { 0xE5, 0xAA, 0xA0 },
	0xBAF4, { 0xE3, 0x9B, 0xB0 },
	0xBAF5, { 0xE5, 0xA9, 0xB9 },
	0xBAF6, { 0xE3, 0x9B, 0xB2 },
	0xBAF7, { 0xE5, 0xAA, 0x86 },
	0xBAF8, { 0xE5, 0xAA, 0xAB },
	0xBAF9, { 0xE5, 0xAA, 0xAA },
	0xBAFA, { 0xE5, 0xAA, 0xA4 },
	0xBAFB, { 0xE5, 0xAA, 0x8D },
	0xBAFC, { 0xE5, 0xA9, 0xBE },
	0xBAFD, { 0xE3, 0x9D, 0x84 },
	0xBAFE, { 0xE5, 0xAF, 0x95 },
	0xBBA1, { 0xE3, 0x9D, 0xA2 },
	0xBBA2, { 0xE3, 0x9D, 0xB7 },
	0xBBA3, { 0xE3, 0xB7, 0x89 },
	0xBBA4, { 0xE5, 0xB0, 0x9E },
	0xBBA5, { 0xE5, 0xB1, 0x9F },
	0xBBA6, { 0xE5, 0xB1, 0x9E },
	0xBBA7, { 0xE5, 0xB5, 0x84 },
	0xBBA8, { 0xE5, 0xB4, 0xBE },
	0xBBA9, { 0xE3, 0x9F, 0xA8 },
	0xBBAA, { 0xE5, 0xB5, 0x88 },
	0xBBAB, { 0xE5, 0xB4, 0x9C },
	0xBBAC, { 0xE3, 0x9F, 0xAF },
	0xBBAD, { 0xE5, 0xB5, 0x9B },
	0xBBAE, { 0xE5, 0xB5, 0x8D },
	0xBBAF, { 0xE3, 0x9F, 0xA6 },
	0xBBB0, { 0xE3, 0x9F, 0xAD },
	0xBBB1, { 0xE5, 0xB5, 0x97 },
	0xBBB2, { 0xE3, 0x9F, 0xA7 },
	0xBBB3, { 0xE5, 0xB5, 0x93 },
	0xBBB4, { 0xE5, 0xB5, 0x8F },
	0xBBB5, { 0xE3, 0x9F, 0xAB },
	0xBBB6, { 0xE5, 0xB4, 0xBB },
	0xBBB7, { 0xE5, 0xB5, 0x86 },
	0xBBB8, { 0xE3, 0xA0, 0xAD },
	0xBBB9, { 0xE3, 0xA1, 0x95 },
	0xBBBA, { 0xE5, 0xB9, 0x86 },
	0xBBBB, { 0xE5, 0xB9, 0x87 },
	0xBBBC, { 0xE3, 0xA1, 0x93 },
	0xBBBD, { 0xE5, 0xB9, 0x88 },
	0xBBBE, { 0xE5, 0xBB, 0x80 },
	0xBBBF, { 0xE5, 0xBA, 0xBD },
	0xBBC0, { 0xE5, 0xBA, 0xBF },
	0xBBC1, { 0xE3, 0xA2, 0x90 },
	0xBBC2, { 0xE5, 0xBC, 0x91 },
	0xBBC3, { 0xE3, 0xA2, 0xBE },
	0xBBC4, { 0xE5, 0xBC, 0xBE },
	0xBBC5, { 0xE5, 0xBC, 0xBB },
	0xBBC6, { 0xE3, 0xA2, 0xBD },
	0xBBC7, { 0xE5, 0xBC, 0xBA },
	0xBBC8, { 0xE3, 0xA3, 0x8F },
	0xBBC9, { 0xE3, 0xA3, 0x90 },
	0xBBCA, { 0xE3, 0xA3, 0xAC },
	0xBBCB, { 0xE5, 0xBE, 0xA7 },
	0xBBCC, { 0xE3, 0xA5, 0x8B },
	0xBBCD, { 0xE6, 0x83, 0xAA },
	0xBBCE, { 0xE3, 0xA5, 0x88 },
	0xBBCF, { 0xE6, 0x84, 0x87 },
	0xBBD0, { 0xE6, 0x84, 0xA2 },
	0xBBD1, { 0xE6, 0x84, 0x8C },
	0xBBD2, { 0xE3, 0xA5, 0x95 },
	0xBBD3, { 0xE3, 0xA5, 0x91 },
	0xBBD4, { 0xE6, 0x82, 0xB3 },
	0xBBD5, { 0xE6, 0x83, 0x96 },
	0xBBD6, { 0xE6, 0x83, 0x92 },
	0xBBD7, { 0xE3, 0xA5, 0x8E },
	0xBBD8, { 0xE6, 0x83, 0xA3 },
	0xBBD9, { 0xE6, 0x83, 0xA5 },
	0xBBDA, { 0xE6, 0x83, 0xA9 },
	0xBBDB, { 0xE3, 0xA5, 0xAB },
	0xBBDC, { 0xE3, 0xA5, 0x9E },
	0xBBDD, { 0xE6, 0x84, 0x91 },
	0xBBDE, { 0xE6, 0x83, 0xBD },
	0xBBDF, { 0xE3, 0xA5, 0xA0 },
	0xBBE0, { 0xE3, 0xA5, 0xA7 },
	0xBBE1, { 0xE6, 0x84, 0x9E },
	0xBBE2, { 0xE6, 0x84, 0xA0 },
	0xBBE3, { 0xE6, 0x84, 0xA1 },
	0xBBE4, { 0xE6, 0x88, 0x9E },
	0xBBE5, { 0xE3, 0xA6, 0xB8 },
	0xBBE6, { 0xE6, 0x8F, 0xA2 },
	0xBBE7, { 0xE6, 0x8F, 0x9E },
	0xBBE8, { 0xE6, 0x8F, 0xA6 },
	0xBBE9, { 0xE3, 0xA8, 0x94 },
	0xBBEA, { 0xE3, 0xA8, 0x8F },
	0xBBEB, { 0xE3, 0xA8, 0x87 },
	0xBBEC, { 0xE3, 0xA8, 0x93 },
	0xBBED, { 0xE6, 0x8F, 0xB8 },
	0xBBEE, { 0xE3, 0xA8, 0x97 },
	0xBBEF, { 0xE6, 0x8F, 0xBE },
	0xBBF0, { 0xE6, 0x8F, 0x81 },
	0xBBF1, { 0xE6, 0x8E, 0xBF },
	0xBBF2, { 0xE6, 0x8F, 0xB7 },
	0xBBF3, { 0xE6, 0x8F, 0x91 },
	0xBBF4, { 0xE6, 0x95, 0x9F },
	0xBBF5, { 0xE6, 0x95, 0xA0 },
	0xBBF6, { 0xE6, 0x95, 0xA1 },
	0xBBF7, { 0xE3, 0xAA, 0x9A },
	0xBBF8, { 0xE3, 0xAA, 0xB8 },
	0xBBF9, { 0xE6, 0x97, 0x91 },
	0xBBFA, { 0xE3, 0xAB, 0xB7 },
	0xBBFB, { 0xE3, 0xAB, 0xB8 },
	0xBBFC, { 0xE6, 0x99, 0xBD },
	0xBBFD, { 0xE6, 0x99, 0xAB },
	0xBBFE, { 0xE6, 0x99, 0xBF },
	0xBCA1, { 0xE3, 0xAB, 0xBD },
	0xBCA2, { 0xE3, 0xAB, 0xB5 },
	0xBCA3, { 0xE6, 0x99, 0xB3 },
	0xBCA4, { 0xE6, 0x9A, 0x81 },
	0xBCA5, { 0xE6, 0x99, 0xAD },
	0xBCA6, { 0xE6, 0x99, 0xA9 },
	0xBCA7, { 0xE3, 0xAB, 0xBA },
	0xBCA8, { 0xE3, 0xAC, 0xB8 },
	0xBCA9, { 0xE6, 0x9C, 0x9E },
	0xBCAA, { 0xE6, 0xA3, 0xAD },
	0xBCAB, { 0xE3, 0xAE, 0x87 },
	0xBCAC, { 0xE3, 0xAE, 0x80 },
	0xBCAD, { 0xE3, 0xAE, 0x88 },
	0xBCAE, { 0xE3, 0xAD, 0xB9 },
	0xBCAF, { 0xE6, 0xA4, 0x83 },
	0xBCB0, { 0xE3, 0xAD, 0xBC },
	0xBCB1, { 0xE6, 0xA3, 0xBE },
	0xBCB2, { 0xE6, 0xA3, 0xA5 },
	0xBCB3, { 0xE6, 0xA4, 0x9E },
	0xBCB4, { 0xE6, 0xA4, 0x82 },
	0xBCB5, { 0xE3, 0xAE, 0x83 },
	0xBCB6, { 0xE3, 0xAE, 0x85 },
	0xBCB7, { 0xE6, 0xA4, 0x89 },
	0xBCB8, { 0xE6, 0xA3, 0x8A },
	0xBCB9, { 0xE6, 0xA4, 0x80 },
	0xBCBA, { 0xF0, 0xAF, 0xA3, 0xA5 },
	0xBCBB, { 0xE6, 0xA4, 0x81 },
	0xBCBC, { 0xE6, 0xA4, 0x98 },
	0xBCBD, { 0xE6, 0xA3, 0xA2 },
	0xBCBE, { 0xE6, 0xA3, 0x8F },
	0xBCBF, { 0xE3, 0xAD, 0xBB },
	0xBCC0, { 0xE6, 0xA4, 0xAE },
	0xBCC1, { 0xE6, 0xA3, 0x85 },
	0xBCC2, { 0xE6, 0xA3, 0xBF },
	0xBCC3, { 0xE3, 0xAE, 0x86 },
	0xBCC4, { 0xE6, 0xA4, 0x9C },
	0xBCC5, { 0xE6, 0xA3, 0x83 },
	0xBCC6, { 0xE3, 0xB0, 0xB4 },
	0xBCC7, { 0xE6, 0xAD, 0xAF },
	0xBCC8, { 0xE3, 0xB1, 0x95 },
	0xBCC9, { 0xE6, 0xAD, 0xAE },
	0xBCCA, { 0xE3, 0xB1, 0xA8 },
	0xBCCB, { 0xE6, 0xAE, 0xBE },
	0xBCCC, { 0xE3, 0xB2, 0x9C },
	0xBCCD, { 0xE6, 0xAF, 0xB4 },
	0xBCCE, { 0xE6, 0xB0, 0xAD },
	0xBCCF, { 0xE3, 0xB3, 0xBC },
	0xBCD0, { 0xE6, 0xB6, 0xB6 },
	0xBCD1, { 0xE6, 0xB9, 0xB5 },
	0xBCD2, { 0xE6, 0xB8, 0x9E },
	0xBCD3, { 0xE3, 0xB4, 0x9A },
	0xBCD4, { 0xE6, 0xB8, 0x98 },
	0xBCD5, { 0xE3, 0xB4, 0x97 },
	0xBCD6, { 0xE6, 0xB9, 0x88 },
	0xBCD7, { 0xE3, 0xB4, 0x9B },
	0xBCD8, { 0xE6, 0xB9, 0x8F },
	0xBCD9, { 0xE3, 0xB4, 0x93 },
	0xBCDA, { 0xE6, 0xB9, 0x82 },
	0xBCDB, { 0xE6, 0xB9, 0xAA },
	0xBCDC, { 0xE6, 0xB9, 0xB0 },
	0xBCDD, { 0xE6, 0xB7, 0xBE },
	0xBCDE, { 0xE3, 0xB4, 0x85 },
	0xBCDF, { 0xE3, 0xB4, 0x87 },
	0xBCE0, { 0xE6, 0xB9, 0xAD },
	0xBCE1, { 0xE3, 0xB4, 0x9C },
	0xBCE2, { 0xE6, 0xB9, 0xBB },
	0xBCE3, { 0xE6, 0xB9, 0xBE },
	0xBCE4, { 0xE6, 0xB9, 0x99 },
	0xBCE5, { 0xE3, 0xB4, 0x91 },
	0xBCE6, { 0xE6, 0xB9, 0x97 },
	0xBCE7, { 0xE3, 0xB4, 0x96 },
	0xBCE8, { 0xE6, 0xBA, 0x80 },
	0xBCE9, { 0xE6, 0xB9, 0x90 },
	0xBCEA, { 0xE3, 0xB4, 0x95 },
	0xBCEB, { 0xE6, 0xB8, 0xA9 },
	0xBCEC, { 0xE6, 0xB9, 0xB6 },
	0xBCED, { 0xE6, 0xB8, 0xAA },
	0xBCEE, { 0xE6, 0xB9, 0x8C },
	0xBCEF, { 0xE7, 0x84, 0xAA },
	0xBCF0, { 0xE3, 0xB7, 0x8B },
	0xBCF1, { 0xE7, 0x84, 0xB5 },
	0xBCF2, { 0xE7, 0x84, 0xAC },
	0xBCF3, { 0xE7, 0x84, 0xB7 },
	0xBCF4, { 0xE7, 0x84, 0x9D },
	0xBCF5, { 0xE3, 0xB7, 0x85 },
	0xBCF6, { 0xE3, 0xB7, 0x82 },
	0xBCF7, { 0xE7, 0x84, 0xB8 },
	0xBCF8, { 0xE3, 0xB7, 0x8D },
	0xBCF9, { 0xE7, 0x84, 0xB4 },
	0xBCFA, { 0xE7, 0x84, 0xAB },
	0xBCFB, { 0xE7, 0x84, 0xB3 },
	0xBCFC, { 0xE7, 0x84, 0xA7 },
	0xBCFD, { 0xE7, 0x84, 0xA4 },
	0xBCFE, { 0xE3, 0xB7, 0x8A },
	0xBDA1, { 0xE7, 0x84, 0xAD },
	0xBDA2, { 0xE7, 0x88, 0xB2 },
	0xBDA3, { 0xE7, 0x8A, 0x83 },
	0xBDA4, { 0xE7, 0x8A, 0x82 },
	0xBDA5, { 0xE7, 0x8A, 0x87 },
	0xBDA6, { 0xE7, 0x8C, 0x86 },
	0xBDA7, { 0xE7, 0x8C, 0xA4 },
	0xBDA8, { 0xE7, 0x8C, 0xB8 },
	0xBDA9, { 0xE7, 0x8C, 0xAA },
	0xBDAA, { 0xE7, 0x8C, 0xAC },
	0xBDAB, { 0xE7, 0x8C, 0xAB },
	0xBDAC, { 0xE3, 0xBA, 0x83 },
	0xBDAD, { 0xE7, 0x8C, 0xAF },
	0xBDAE, { 0xE7, 0x8C, 0xA8 },
	0xBDAF, { 0xE7, 0x90, 0x97 },
	0xBDB0, { 0xE3, 0xBB, 0x96 },
	0xBDB1, { 0xE3, 0xBB, 0x95 },
	0xBDB2, { 0xE7, 0x90, 0x99 },
	0xBDB3, { 0xE7, 0x90, 0xB8 },
	0xBDB4, { 0xE3, 0xBB, 0x91 },
	0xBDB5, { 0xE7, 0x90, 0x9F },
	0xBDB6, { 0xE7, 0x90, 0x94 },
	0xBDB7, { 0xE7, 0x90, 0xBC },
	0xBDB8, { 0xE7, 0x8F, 0xB7 },
	0xBDB9, { 0xE7, 0x90, 0x9C },
	0xBDBA, { 0xE7, 0x90, 0x95 },
	0xBDBB, { 0xE7, 0x90, 0x98 },
	0xBDBC, { 0xE7, 0x90, 0xB9 },
	0xBDBD, { 0xE7, 0x93, 0xB9 },
	0xBDBE, { 0xE7, 0x94, 0xA4 },
	0xBDBF, { 0xF0, 0xAF, 0xA4, 0xB4 },
	0xBDC0, { 0xE3, 0xBD, 0x92 },
	0xBDC1, { 0xE3, 0xBD, 0x9F },
	0xBDC2, { 0xE7, 0x95, 0xAE },
	0xBDC3, { 0xE7, 0x95, 0xAD },
	0xBDC4, { 0xE7, 0x95, 0xB1 },
	0xBDC5, { 0xE7, 0x96, 0x8E },
	0xBDC6, { 0xE3, 0xBE, 0x95 },
	0xBDC7, { 0xE7, 0x97, 0xA5 },
	0xBDC8, { 0xE3, 0xBE, 0x9D },
	0xBDC9, { 0xE3, 0xBE, 0x98 },
	0xBDCA, { 0xE3, 0xBE, 0x9E },
	0xBDCB, { 0xE3, 0xBE, 0x96 },
	0xBDCC, { 0xE7, 0x9A, 0x94 },
	0xBDCD, { 0xE7, 0x9A, 0xB3 },
	0xBDCE, { 0xE4, 0x80, 0x83 },
	0xBDCF, { 0xE7, 0x9B, 0x99 },
	0xBDD0, { 0xE4, 0x80, 0xAF },
	0xBDD1, { 0xE7, 0x9D, 0x88 },
	0xBDD2, { 0xE7, 0x9D, 0x89 },
	0xBDD3, { 0xE7, 0x9D, 0x83 },
	0xBDD4, { 0xE4, 0x80, 0xB1 },
	0xBDD5, { 0xE4, 0x80, 0xB3 },
	0xBDD6, { 0xE7, 0x9D, 0x82 },
	0xBDD7, { 0xE7, 0x9F, 0x9F },
	0xBDD8, { 0xE4, 0x82, 0xB4 },
	0xBDD9, { 0xE7, 0xA1, 0xA3 },
	0xBDDA, { 0xE7, 0xA1, 0xB6 },
	0xBDDB, { 0xE4, 0x82, 0xB0 },
	0xBDDC, { 0xE7, 0xA1, 0x9F },
	0xBDDD, { 0xE7, 0xA1, 0xA6 },
	0xBDDE, { 0xE7, 0xA5, 0xA6 },
	0xBDDF, { 0xE7, 0xA5, 0xB1 },
	0xBDE0, { 0xE4, 0x84, 0x88 },
	0xBDE1, { 0xE4, 0x84, 0x87 },
	0xBDE2, { 0xE7, 0xA5, 0xB6 },
	0xBDE3, { 0xE7, 0xA6, 0x84 },
	0xBDE4, { 0xE7, 0xA5, 0xB5 },
	0xBDE5, { 0xE7, 0xA7, 0xBF },
	0xBDE6, { 0xE7, 0xA8, 0x87 },
	0xBDE7, { 0xE4, 0x85, 0x8E },
	0xBDE8, { 0xE7, 0xA8, 0x8E },
	0xBDE9, { 0xE7, 0xA8, 0x89 },
	0xBDEA, { 0xE4, 0x85, 0x90 },
	0xBDEB, { 0xE4, 0x85, 0x92 },
	0xBDEC, { 0xE4, 0x86, 0xA1 },
	0xBDED, { 0xE4, 0x86, 0xA3 },
	0xBDEE, { 0xE4, 0x86, 0xA5 },
	0xBDEF, { 0xE4, 0x87, 0x8C },
	0xBDF0, { 0xE7, 0xAB, 0xA7 },
	0xBDF1, { 0xE7, 0xAB, 0xA2 },
	0xBDF2, { 0xE7, 0xAD, 0x95 },
	0xBDF3, { 0xE4, 0x87, 0xAF },
	0xBDF4, { 0xE4, 0x87, 0xAA },
	0xBDF5, { 0xE7, 0xAD, 0x83 },
	0xBDF6, { 0xE7, 0xAD, 0x97 },
	0xBDF7, { 0xE7, 0xAD, 0xAC },
	0xBDF8, { 0xE7, 0xAD, 0x82 },
	0xBDF9, { 0xE7, 0xAD, 0x93 },
	0xBDFA, { 0xE4, 0x87, 0xAD },
	0xBDFB, { 0xE7, 0xAD, 0x81 },
	0xBDFC, { 0xE4, 0x8A, 0x85 },
	0xBDFD, { 0xE4, 0x8A, 0x84 },
	0xBDFE, { 0xE7, 0xB2, 0xA7 },
	0xBEA1, { 0xE7, 0xB2, 0xA0 },
	0xBEA2, { 0xE7, 0xB2, 0xA6 },
	0xBEA3, { 0xE7, 0xB2, 0xA4 },
	0xBEA4, { 0xE7, 0xB5, 0xB4 },
	0xBEA5, { 0xE4, 0x8B, 0x9B },
	0xBEA6, { 0xE7, 0xB5, 0x99 },
	0xBEA7, { 0xE4, 0x8B, 0x99 },
	0xBEA8, { 0xE7, 0xB5, 0xA0 },
	0xBEA9, { 0xE7, 0xB5, 0x97 },
	0xBEAA, { 0xE7, 0xB5, 0xAC },
	0xBEAB, { 0xE7, 0xB5, 0xBE },
	0xBEAC, { 0xE7, 0xB5, 0xA4 },
	0xBEAD, { 0xE4, 0x8B, 0x97 },
	0xBEAE, { 0xE7, 0xB5, 0x9A },
	0xBEAF, { 0xE7, 0xB5, 0x9D },
	0xBEB0, { 0xE4, 0x8B, 0x9A },
	0xBEB1, { 0xE4, 0x8B, 0x9E },
	0xBEB2, { 0xE4, 0x8B, 0x98 },
	0xBEB3, { 0xE7, 0xB5, 0xB6 },
	0xBEB4, { 0xE7, 0xB5, 0x8D },
	0xBEB5, { 0xE7, 0xB5, 0xB5 },
	0xBEB6, { 0xE4, 0x8B, 0x95 },
	0xBEB7, { 0xE7, 0xBF, 0x93 },
	0xBEB8, { 0xE7, 0xBF, 0x96 },
	0xBEB9, { 0xE4, 0x8E, 0x9C },
	0xBEBA, { 0xE4, 0x8E, 0x9D },
	0xBEBB, { 0xE8, 0x81, 0xA0 },
	0xBEBC, { 0xE8, 0x81, 0x8E },
	0xBEBD, { 0xE8, 0x85, 0x85 },
	0xBEBE, { 0xE8, 0x84, 0xBB },
	0xBEBF, { 0xE4, 0x8F, 0xBE },
	0xBEC0, { 0xE8, 0x85, 0x88 },
	0xBEC1, { 0xE8, 0x85, 0x82 },
	0xBEC2, { 0xE8, 0x85, 0x89 },
	0xBEC3, { 0xE8, 0x85, 0x80 },
	0xBEC4, { 0xE8, 0x84, 0x94 },
	0xBEC5, { 0xE8, 0x85, 0x81 },
	0xBEC6, { 0xE4, 0x90, 0x87 },
	0xBEC7, { 0xE8, 0x87, 0xAF },
	0xBEC8, { 0xE8, 0x87, 0xB6 },
	0xBEC9, { 0xE8, 0x88, 0x83 },
	0xBECA, { 0xE4, 0x91, 0xAA },
	0xBECB, { 0xE8, 0x8F, 0xAD },
	0xBECC, { 0xE4, 0x93, 0xA7 },
	0xBECD, { 0xE8, 0x8F, 0x9A },
	0xBECE, { 0xE8, 0x90, 0x98 },
	0xBECF, { 0xE8, 0x8F, 0x92 },
	0xBED0, { 0xE8, 0x90, 0x88 },
	0xBED1, { 0xE4, 0x93, 0xA2 },
	0xBED2, { 0xE8, 0x90, 0x80 },
	0xBED3, { 0xE4, 0x93, 0x9F },
	0xBED4, { 0xE4, 0x93, 0xA1 },
	0xBED5, { 0xE4, 0x93, 0xA5 },
	0xBED6, { 0xE8, 0x90, 0x97 },
	0xBED7, { 0xE8, 0x8D, 0x86 },
	0xBED8, { 0xE8, 0x90, 0x94 },
	0xBED9, { 0xE8, 0x8F, 0x93 },
	0xBEDA, { 0xE8, 0x90, 0x85 },
	0xBEDB, { 0xE8, 0x90, 0x9F },
	0xBEDC, { 0xE8, 0x90, 0x82 },
	0xBEDD, { 0xE8, 0x90, 0x96 },
	0xBEDE, { 0xE8, 0x8F, 0x8D },
	0xBEDF, { 0xE8, 0x8F, 0xA6 },
	0xBEE0, { 0xE4, 0x96, 0x91 },
	0xBEE1, { 0xE8, 0x99, 0x9D },
	0xBEE2, { 0xE8, 0x9B, 0x95 },
	0xBEE3, { 0xE8, 0x9B, 0xA1 },
	0xBEE4, { 0xE4, 0x96, 0xB4 },
	0xBEE5, { 0xE4, 0x96, 0xB0 },
	0xBEE6, { 0xE4, 0x96, 0xB5 },
	0xBEE7, { 0xE4, 0x96, 0xAE },
	0xBEE8, { 0xE8, 0x9B, 0xAE },
	0xBEE9, { 0xE8, 0xA1, 0x87 },
	0xBEEA, { 0xE8, 0xA1, 0x86 },
	0xBEEB, { 0xE4, 0x98, 0xAD },
	0xBEEC, { 0xE4, 0x98, 0xAC },
	0xBEED, { 0xE8, 0xA2, 0xBB },
	0xBEEE, { 0xE4, 0x98, 0xAB },
	0xBEEF, { 0xE8, 0xA2, 0xBF },
	0xBEF0, { 0xE8, 0xA2, 0xB4 },
	0xBEF1, { 0xE4, 0x98, 0xA9 },
	0xBEF2, { 0xE8, 0xA2, 0xB5 },
	0xBEF3, { 0xE4, 0x99, 0xBF },
	0xBEF4, { 0xE8, 0xA6, 0x9A },
	0xBEF5, { 0xE8, 0xA9, 0x83 },
	0xBEF6, { 0xE4, 0x9B, 0x89 },
	0xBEF7, { 0xE4, 0x9B, 0x8B },
	0xBEF8, { 0xE8, 0xA9, 0x9A },
	0xBEF9, { 0xE4, 0x9B, 0x85 },
	0xBEFA, { 0xE4, 0x9B, 0x86 },
	0xBEFB, { 0xE4, 0x9B, 0x8A },
	0xBEFC, { 0xE8, 0xA8, 0xB5 },
	0xBEFD, { 0xE8, 0xA8, 0xB8 },
	0xBEFE, { 0xE8, 0xA9, 0x82 },
	0xBFA1, { 0xE8, 0xA9, 0x89 },
	0xBFA2, { 0xE8, 0xA9, 0x9D },
	0xBFA3, { 0xE8, 0xA9, 0x8B },
	0xBFA4, { 0xE8, 0xA8, 0xBD },
	0xBFA5, { 0xE4, 0x9B, 0x92 },
	0xBFA6, { 0xE4, 0x9B, 0x90 },
	0xBFA7, { 0xE4, 0x9C, 0xAD },
	0xBFA8, { 0xE4, 0x9C, 0xB5 },
	0xBFA9, { 0xE8, 0xB1, 0xA0 },
	0xBFAA, { 0xE8, 0xB1, 0x9E },
	0xBFAB, { 0xE8, 0xB1, 0xBF },
	0xBFAC, { 0xE8, 0xB1, 0xBE },
	0xBFAD, { 0xE8, 0xB2, 0x83 },
	0xBFAE, { 0xE4, 0x9D, 0xAC },
	0xBFAF, { 0xE8, 0xB2, 0xB1 },
	0xBFB0, { 0xE8, 0xB6, 0x87 },
	0xBFB1, { 0xE4, 0x9E, 0x9D },
	0xBFB2, { 0xE4, 0x9E, 0xA0 },
	0xBFB3, { 0xE8, 0xB6, 0x88 },
	0xBFB4, { 0xE8, 0xB6, 0x83 },
	0xBFB5, { 0xE4, 0x9E, 0xA2 },
	0xBFB6, { 0xE4, 0x9E, 0x9F },
	0xBFB7, { 0xE8, 0xB6, 0x86 },
	0xBFB8, { 0xE8, 0xB6, 0x8B },
	0xBFB9, { 0xE8, 0xB6, 0x82 },
	0xBFBA, { 0xE8, 0xB7, 0x8A },
	0xBFBB, { 0xE8, 0xB7, 0x92 },
	0xBFBC, { 0xE4, 0x9F, 0xAB },
	0xBFBD, { 0xE4, 0x9F, 0xA2 },
	0xBFBE, { 0xE8, 0xB7, 0x94 },
	0xBFBF, { 0xE8, 0xB7, 0x89 },
	0xBFC0, { 0xE8, 0xBA, 0xB0 },
	0xBFC1, { 0xE4, 0xA0, 0xB6 },
	0xBFC2, { 0xE4, 0xA0, 0xB2 },
	0xBFC3, { 0xE4, 0xA1, 0x90 },
	0xBFC4, { 0xE8, 0xBB, 0xB2 },
	0xBFC5, { 0xE8, 0xBB, 0xA4 },
	0xBFC6, { 0xE8, 0xBB, 0xB3 },
	0xBFC7, { 0xE8, 0xBB, 0xAA },
	0xBFC8, { 0xE4, 0xA1, 0x8F },
	0xBFC9, { 0xE8, 0xBB, 0xBD },
	0xBFCA, { 0xE4, 0xA1, 0x92 },
	0xBFCB, { 0xE8, 0xBE, 0x9D },
	0xBFCC, { 0xE9, 0x80, 0xAB },
	0xBFCD, { 0xE9, 0x80, 0xAA },
	0xBFCE, { 0xE4, 0xA2, 0x9E },
	0xBFCF, { 0xE9, 0x80, 0xA8 },
	0xBFD0, { 0xE9, 0x80, 0xA9 },
	0xBFD1, { 0xE9, 0x80, 0xAC },
	0xBFD2, { 0xE4, 0xA2, 0xA0 },
	0xBFD3, { 0xE4, 0xA2, 0x9C },
	0xBFD4, { 0xE9, 0x80, 0xBA },
	0xBFD5, { 0xE9, 0x80, 0xB0 },
	0xBFD6, { 0xE9, 0x80, 0xB7 },
	0xBFD7, { 0xE9, 0x80, 0xBB },
	0xBFD8, { 0xE4, 0xA3, 0x91 },
	0xBFD9, { 0xE9, 0x84, 0x8A },
	0xBFDA, { 0xE4, 0xA3, 0xAF },
	0xBFDB, { 0xE4, 0xA3, 0xB0 },
	0xBFDC, { 0xE4, 0xA3, 0xB1 },
	0xBFDD, { 0xE9, 0x87, 0xBE },
	0xBFDE, { 0xE9, 0x88, 0xA0 },
	0xBFDF, { 0xE4, 0xA4, 0x9D },
	0xBFE0, { 0xE9, 0x88, 0x8B },
	0xBFE1, { 0xE4, 0xA4, 0x9F },
	0xBFE2, { 0xE9, 0x88, 0x98 },
	0xBFE3, { 0xE9, 0x88, 0xA2 },
	0xBFE4, { 0xE4, 0xA4, 0x9E },
	0xBFE5, { 0xE9, 0x88, 0x9B },
	0xBFE6, { 0xE9, 0x88, 0x88 },
	0xBFE7, { 0xE4, 0xA4, 0xA0 },
	0xBFE8, { 0xE9, 0x88, 0x8E },
	0xBFE9, { 0xE9, 0x88, 0x93 },
	0xBFEA, { 0xE4, 0xA6, 0x8E },
	0xBFEB, { 0xE4, 0xA6, 0x91 },
	0xBFEC, { 0xE9, 0x96, 0x95 },
	0xBFED, { 0xF0, 0xA8, 0xB3, 0x9D },
	0xBFEE, { 0xE4, 0xA6, 0x90 },
	0xBFEF, { 0xE4, 0xA7, 0x97 },
	0xBFF0, { 0xE9, 0x9A, 0x8C },
	0xBFF1, { 0xE9, 0x99, 0xBB },
	0xBFF2, { 0xE9, 0x99, 0xBF },
	0xBFF3, { 0xE9, 0x9A, 0x81 },
	0xBFF4, { 0xE4, 0xA7, 0x99 },
	0xBFF5, { 0xE9, 0x9A, 0x82 },
	0xBFF6, { 0xE4, 0xA7, 0xB4 },
	0xBFF7, { 0xE4, 0xA7, 0xB6 },
	0xBFF8, { 0xE3, 0x95, 0xA0 },
	0xBFF9, { 0xE4, 0xA7, 0xB5 },
	0xBFFA, { 0xE4, 0xA7, 0xB3 },
	0xBFFB, { 0xE9, 0x9B, 0xAE },
	0xBFFC, { 0xE9, 0x9B, 0xAD },
	0xBFFD, { 0xE4, 0xA8, 0x8C },
	0xBFFE, { 0xE9, 0x9B, 0xAC },
	0xC0A1, { 0xE9, 0x9D, 0x9F },
	0xC0A2, { 0xE9, 0x9D, 0xAF },
	0xC0A3, { 0xE4, 0xA9, 0x91 },
	0xC0A4, { 0xE9, 0x9D, 0xAD },
	0xC0A5, { 0xE4, 0xAA, 0xA6 },
	0xC0A6, { 0xE4, 0xAA, 0xA7 },
	0xC0A7, { 0xE4, 0xAA, 0xA8 },
	0xC0A8, { 0xE4, 0xAC, 0xA7 },
	0xC0A9, { 0xE4, 0xAC, 0xA4 },
	0xC0AA, { 0xE4, 0xAC, 0xA5 },
	0xC0AB, { 0xE9, 0xA3, 0xB0 },
	0xC0AC, { 0xE4, 0xAC, 0xAA },
	0xC0AD, { 0xE4, 0xAD, 0xB4 },
	0xC0AE, { 0xE4, 0xAF, 0x87 },
	0xC0AF, { 0xE9, 0xAA, 0xA9 },
	0xC0B0, { 0xE4, 0xAF, 0xA7 },
	0xC0B1, { 0xE4, 0xAF, 0xAD },
	0xC0B2, { 0xE9, 0xAB, 0xA0 },
	0xC0B3, { 0xE4, 0xBA, 0xB7 },
	0xC0B4, { 0xE3, 0x90, 0xAE },
	0xC0B5, { 0xE3, 0x91, 0xBB },
	0xC0B6, { 0xE5, 0x83, 0x8C },
	0xC0B7, { 0xE5, 0x82, 0xBC },
	0xC0B8, { 0xE3, 0x91, 0xBC },
	0xC0B9, { 0xE5, 0x82, 0xAA },
	0xC0BA, { 0xE5, 0x82, 0xB9 },
	0xC0BB, { 0xE3, 0x91, 0xBD },
	0xC0BC, { 0xE5, 0x82, 0xAB },
	0xC0BD, { 0xE5, 0x83, 0x83 },
	0xC0BE, { 0xE5, 0x83, 0x8D },
	0xC0BF, { 0xE5, 0x85, 0xBE },
	0xC0C0, { 0xE5, 0x89, 0xBE },
	0xC0C1, { 0xE5, 0x89, 0xB9 },
	0xC0C2, { 0xE3, 0x93, 0xBD },
	0xC0C3, { 0xF0, 0xAF, 0xA0, 0xA3 },
	0xC0C4, { 0xE5, 0x8B, 0xA1 },
	0xC0C5, { 0xE5, 0x8B, 0xA0 },
	0xC0C6, { 0xE5, 0x8B, 0xA7 },
	0xC0C7, { 0xE5, 0x8E, 0x80 },
	0xC0C8, { 0xE5, 0x8E, 0xAB },
	0xC0C9, { 0xE5, 0x8E, 0xAA },
	0xC0CA, { 0xE5, 0x8E, 0xA9 },
	0xC0CB, { 0xE5, 0x8F, 0xA0 },
	0xC0CC, { 0xE5, 0x97, 0xAA },
	0xC0CD, { 0xE3, 0x97, 0x9A },
	0xC0CE, { 0xE5, 0x97, 0x97 },
	0xC0CF, { 0xE3, 0x97, 0x96 },
	0xC0D0, { 0xE3, 0x97, 0x9B },
	0xC0D1, { 0xE5, 0x97, 0x81 },
	0xC0D2, { 0xE5, 0x9C, 0x95 },
	0xC0D3, { 0xE3, 0x99, 0x9B },
	0xC0D4, { 0xE5, 0xA1, 0xAC },
	0xC0D5, { 0xE3, 0x99, 0x9C },
	0xC0D6, { 0xE5, 0xA1, 0x9C },
	0xC0D7, { 0xE5, 0xA1, 0x90 },
	0xC0D8, { 0xE5, 0xA1, 0xA1 },
	0xC0D9, { 0xE5, 0xA1, 0xAA },
	0xC0DA, { 0xE5, 0xA1, 0xA9 },
	0xC0DB, { 0xE5, 0xA1, 0x96 },
	0xC0DC, { 0xE5, 0xA1, 0xA0 },
	0xC0DD, { 0xE5, 0xA1, 0xA6 },
	0xC0DE, { 0xE5, 0xA1, 0x9F },
	0xC0DF, { 0xE5, 0xA4, 0xA3 },
	0xC0E0, { 0xE5, 0xA5, 0xA6 },
	0xC0E1, { 0xE5, 0xA5, 0xA8 },
	0xC0E2, { 0xE3, 0x9C, 0x86 },
	0xC0E3, { 0xE3, 0x9C, 0x8B },
	0xC0E4, { 0xE5, 0xAB, 0x8E },
	0xC0E5, { 0xE3, 0x9C, 0x8D },
	0xC0E6, { 0xE5, 0xAB, 0x85 },
	0xC0E7, { 0xE5, 0xAB, 0x83 },
	0xC0E8, { 0xE3, 0x9C, 0x8A },
	0xC0E9, { 0xE3, 0x9C, 0x93 },
	0xC0EA, { 0xE5, 0xAB, 0x90 },
	0xC0EB, { 0xE3, 0x9C, 0x90 },
	0xC0EC, { 0xE3, 0x9C, 0x92 },
	0xC0ED, { 0xE3, 0x9C, 0x89 },
	0xC0EE, { 0xE3, 0x9C, 0x88 },
	0xC0EF, { 0xE3, 0x9C, 0x91 },
	0xC0F0, { 0xE3, 0x9C, 0x8F },
	0xC0F1, { 0xE5, 0xAD, 0xB4 },
	0xC0F2, { 0xE5, 0xAD, 0xB6 },
	0xC0F3, { 0xE5, 0xAF, 0x9C },
	0xC0F4, { 0xE5, 0xAF, 0x97 },
	0xC0F5, { 0xE5, 0xAF, 0x9A },
	0xC0F6, { 0xE5, 0xAF, 0x9B },
	0xC0F7, { 0xE3, 0x9D, 0xA7 },
	0xC0F8, { 0xE5, 0xB0, 0xA0 },
	0xC0F9, { 0xE5, 0xB5, 0xAD },
	0xC0FA, { 0xE5, 0xB5, 0xA6 },
	0xC0FB, { 0xE3, 0x9F, 0xB6 },
	0xC0FC, { 0xE5, 0xB5, 0xA4 },
	0xC0FD, { 0xE5, 0xB5, 0xAE },
	0xC0FE, { 0xF0, 0xAF, 0xA1, 0xBE },
	0xC1A1, { 0xE5, 0xB5, 0xA0 },
	0xC1A2, { 0xE5, 0xBD, 0x82 },
	0xC1A3, { 0xE5, 0xBD, 0x9A },
	0xC1A4, { 0xE5, 0xBD, 0xAE },
	0xC1A5, { 0xE3, 0xA5, 0xA4 },
	0xC1A6, { 0xE3, 0xA5, 0xAC },
	0xC1A7, { 0xE6, 0x84, 0xB0 },
	0xC1A8, { 0xE6, 0x84, 0xBA },
	0xC1A9, { 0xE6, 0x84, 0xAA },
	0xC1AA, { 0xE6, 0x85, 0x83 },
	0xC1AB, { 0xE6, 0x84, 0x99 },
	0xC1AC, { 0xE6, 0x84, 0xB1 },
	0xC1AD, { 0xE3, 0xA5, 0xAD },
	0xC1AE, { 0xE6, 0x84, 0xBD },
	0xC1AF, { 0xE3, 0xA5, 0xBA },
	0xC1B0, { 0xE3, 0xA5, 0xB5 },
	0xC1B1, { 0xE3, 0xA8, 0x8D },
	0xC1B2, { 0xE6, 0x90, 0x88 },
	0xC1B3, { 0xE6, 0x90, 0xB2 },
	0xC1B4, { 0xE6, 0x90, 0xB8 },
	0xC1B5, { 0xE3, 0xA8, 0x9E },
	0xC1B6, { 0xE6, 0x90, 0xB1 },
	0xC1B7, { 0xE3, 0xA8, 0x9B },
	0xC1B8, { 0xE6, 0x90, 0x99 },
	0xC1B9, { 0xE3, 0xA8, 0xAA },
	0xC1BA, { 0xE6, 0x90, 0x91 },
	0xC1BB, { 0xE3, 0xA8, 0x9F },
	0xC1BC, { 0xE3, 0xA8, 0xA2 },
	0xC1BD, { 0xE6, 0x90, 0xA9 },
	0xC1BE, { 0xE6, 0x90, 0x9D },
	0xC1BF, { 0xE3, 0xA8, 0xA5 },
	0xC1C0, { 0xE3, 0xA8, 0xA7 },
	0xC1C1, { 0xE3, 0xA8, 0xA9 },
	0xC1C2, { 0xE6, 0x90, 0xBC },
	0xC1C3, { 0xE3, 0xA8, 0xA4 },
	0xC1C4, { 0xE6, 0x91, 0x86 },
	0xC1C5, { 0xE6, 0x91, 0x87 },
	0xC1C6, { 0xE3, 0xA8, 0xA8 },
	0xC1C7, { 0xE3, 0xA8, 0xA6 },
	0xC1C8, { 0xE6, 0x90, 0xBA },
	0xC1C9, { 0xE6, 0x90, 0x87 },
	0xC1CA, { 0xE3, 0xA8, 0xA3 },
	0xC1CB, { 0xE6, 0x95, 0xAB },
	0xC1CC, { 0xE3, 0xAA, 0x9F },
	0xC1CD, { 0xE6, 0x95, 0xB0 },
	0xC1CE, { 0xE6, 0x95, 0xAD },
	0xC1CF, { 0xE3, 0xAA, 0xB1 },
	0xC1D0, { 0xE6, 0x97, 0xA4 },
	0xC1D1, { 0xE6, 0x9A, 0x93 },
	0xC1D2, { 0xE3, 0xAC, 0x83 },
	0xC1D3, { 0xE3, 0xAC, 0x87 },
	0xC1D4, { 0xE3, 0xAC, 0x8C },
	0xC1D5, { 0xE3, 0xAC, 0x86 },
	0xC1D6, { 0xE6, 0x9A, 0x8F },
	0xC1D7, { 0xE3, 0xAC, 0x84 },
	0xC1D8, { 0xE3, 0xAC, 0x89 },
	0xC1D9, { 0xE6, 0x9A, 0x92 },
	0xC1DA, { 0xE3, 0xAC, 0x85 },
	0xC1DB, { 0xE6, 0x9A, 0x8E },
	0xC1DC, { 0xE3, 0xAC, 0x88 },
	0xC1DD, { 0xE6, 0xA5, 0x86 },
	0xC1DE, { 0xE3, 0xAE, 0x96 },
	0xC1DF, { 0xE3, 0xAE, 0x9C },
	0xC1E0, { 0xE3, 0xAE, 0x9F },
	0xC1E1, { 0xE3, 0xAE, 0x9B },
	0xC1E2, { 0xE3, 0xAE, 0x98 },
	0xC1E3, { 0xE3, 0xAE, 0x99 },
	0xC1E4, { 0xE3, 0xAE, 0x94 },
	0xC1E5, { 0xE6, 0xA4, 0xB1 },
	0xC1E6, { 0xE3, 0xAE, 0x8D },
	0xC1E7, { 0xE3, 0xAE, 0xA3 },
	0xC1E8, { 0xE6, 0xA4, 0xBE },
	0xC1E9, { 0xE3, 0xAE, 0x93 },
	0xC1EA, { 0xE6, 0xA5, 0xBC },
	0xC1EB, { 0xE6, 0xA5, 0x83 },
	0xC1EC, { 0xE3, 0xAE, 0x92 },
	0xC1ED, { 0xE6, 0xA5, 0xB3 },
	0xC1EE, { 0xF0, 0xAF, 0xA3, 0xA8 },
	0xC1EF, { 0xE6, 0xA5, 0x95 },
	0xC1F0, { 0xE3, 0xAE, 0x8E },
	0xC1F1, { 0xE3, 0xAE, 0x8C },
	0xC1F2, { 0xE6, 0xA6, 0x85 },
	0xC1F3, { 0xE6, 0xA5, 0x8D },
	0xC1F4, { 0xE6, 0xA5, 0x90 },
	0xC1F5, { 0xE6, 0xA5, 0x87 },
	0xC1F6, { 0xE6, 0xA5, 0xA7 },
	0xC1F7, { 0xE6, 0xA4, 0xB6 },
	0xC1F8, { 0xE6, 0xA5, 0xA4 },
	0xC1F9, { 0xE6, 0xA5, 0xA1 },
	0xC1FA, { 0xE3, 0xAE, 0x9A },
	0xC1FB, { 0xE6, 0xA5, 0xBD },
	0xC1FC, { 0xE6, 0xAD, 0x84 },
	0xC1FD, { 0xE6, 0xAD, 0x80 },
	0xC1FE, { 0xE6, 0xAD, 0xB1 },
	0xC2A1, { 0xE6, 0xAD, 0xB3 },
	0xC2A2, { 0xE6, 0xAE, 0x9C },
	0xC2A3, { 0xE3, 0xB1, 0xAA },
	0xC2A4, { 0xE3, 0xB1, 0xAD },
	0xC2A5, { 0xE3, 0xB2, 0x84 },
	0xC2A6, { 0xE6, 0xAF, 0x81 },
	0xC2A7, { 0xE3, 0xB2, 0xA0 },
	0xC2A8, { 0xE6, 0xAF, 0xBA },
	0xC2A9, { 0xE6, 0xB0, 0xB1 },
	0xC2AA, { 0xE6, 0xB0, 0xB2 },
	0xC2AB, { 0xE3, 0xB4, 0x9D },
	0xC2AC, { 0xE3, 0xB4, 0xA6 },
	0xC2AD, { 0xE6, 0xBA, 0xB8 },
	0xC2AE, { 0xE6, 0xBA, 0xA8 },
	0xC2AF, { 0xE3, 0xB4, 0xB3 },
	0xC2B0, { 0xE6, 0xBA, 0x91 },
	0xC2B1, { 0xE6, 0xBA, 0xBB },
	0xC2B2, { 0xE3, 0xB4, 0xB8 },
	0xC2B3, { 0xE6, 0xBA, 0x9A },
	0xC2B4, { 0xE3, 0xB4, 0xB0 },
	0xC2B5, { 0xE3, 0xB4, 0xA8 },
	0xC2B6, { 0xE6, 0xBA, 0xA9 },
	0xC2B7, { 0xE3, 0xB4, 0xA7 },
	0xC2B8, { 0xE3, 0xB4, 0xAA },
	0xC2B9, { 0xE6, 0xBA, 0xB5 },
	0xC2BA, { 0xE6, 0xB9, 0xAC },
	0xC2BB, { 0xE6, 0xBB, 0xA8 },
	0xC2BC, { 0xE3, 0xB4, 0xB1 },
	0xC2BD, { 0xE6, 0xBB, 0x9D },
	0xC2BE, { 0xE6, 0xBB, 0x9A },
	0xC2BF, { 0xE6, 0xBB, 0xA6 },
	0xC2C0, { 0xE6, 0xBA, 0xAC },
	0xC2C1, { 0xE3, 0xB4, 0xB4 },
	0xC2C2, { 0xE3, 0xB4, 0xAE },
	0xC2C3, { 0xE3, 0xB4, 0xBB },
	0xC2C4, { 0xE6, 0xBB, 0x99 },
	0xC2C5, { 0xE6, 0xBB, 0xA3 },
	0xC2C6, { 0xE6, 0xBB, 0xA9 },
	0xC2C7, { 0xE6, 0xBB, 0x9B },
	0xC2C8, { 0xE3, 0xB4, 0xA9 },
	0xC2C9, { 0xE7, 0x85, 0xAF },
	0xC2CA, { 0xE3, 0xB7, 0x92 },
	0xC2CB, { 0xE3, 0xB7, 0x98 },
	0xC2CC, { 0xE7, 0x85, 0x88 },
	0xC2CD, { 0xE3, 0xB7, 0x8F },
	0xC2CE, { 0xE7, 0x85, 0x8A },
	0xC2CF, { 0xE7, 0x85, 0xAB },
	0xC2D0, { 0xE3, 0xB7, 0x99 },
	0xC2D1, { 0xE7, 0x85, 0x8F },
	0xC2D2, { 0xE7, 0x85, 0x97 },
	0xC2D3, { 0xE7, 0x85, 0xB4 },
	0xC2D4, { 0xE3, 0xB7, 0x8E },
	0xC2D5, { 0xE3, 0xB7, 0x93 },
	0xC2D6, { 0xE3, 0xB7, 0x90 },
	0xC2D7, { 0xE7, 0x85, 0x85 },
	0xC2D8, { 0xE7, 0x85, 0x91 },
	0xC2D9, { 0xE7, 0x85, 0xAD },
	0xC2DA, { 0xE3, 0xAE, 0xA1 },
	0xC2DB, { 0xE7, 0x89, 0x91 },
	0xC2DC, { 0xE7, 0x89, 0x90 },
	0xC2DD, { 0xE7, 0x89, 0x8E },
	0xC2DE, { 0xE3, 0xB9, 0x87 },
	0xC2DF, { 0xE7, 0x8D, 0x81 },
	0xC2E0, { 0xE3, 0xBA, 0x8B },
	0xC2E1, { 0xE7, 0x8C, 0xAE },
	0xC2E2, { 0xE7, 0x8D, 0x86 },
	0xC2E3, { 0xE3, 0xBB, 0x94 },
	0xC2E4, { 0xE7, 0x90, 0xA7 },
	0xC2E5, { 0xE3, 0xBB, 0x9E },
	0xC2E6, { 0xE7, 0x91, 0x88 },
	0xC2E7, { 0xE7, 0x91, 0x93 },
	0xC2E8, { 0xE7, 0x90, 0xBD },
	0xC2E9, { 0xE3, 0xBB, 0x9F },
	0xC2EA, { 0xE7, 0x91, 0x9D },
	0xC2EB, { 0xE7, 0x91, 0x96 },
	0xC2EC, { 0xE3, 0xBB, 0x97 },
	0xC2ED, { 0xE7, 0x90, 0x9E },
	0xC2EE, { 0xE7, 0x91, 0x87 },
	0xC2EF, { 0xE7, 0x91, 0x83 },
	0xC2F0, { 0xE7, 0x91, 0x98 },
	0xC2F1, { 0xE7, 0x91, 0x89 },
	0xC2F2, { 0xE3, 0xBB, 0xA1 },
	0xC2F3, { 0xE7, 0x91, 0x8C },
	0xC2F4, { 0xE7, 0x91, 0x85 },
	0xC2F5, { 0xE7, 0x90, 0xBE },
	0xC2F6, { 0xE3, 0xBC, 0xAF },
	0xC2F7, { 0xE7, 0x94, 0x81 },
	0xC2F8, { 0xE7, 0x94, 0x9E },
	0xC2F9, { 0xE3, 0xBD, 0xA2 },
	0xC2FA, { 0xE3, 0xBD, 0xA3 },
	0xC2FB, { 0xE7, 0x95, 0xBA },
	0xC2FC, { 0xE7, 0x97, 0xAE },
	0xC2FD, { 0xE7, 0x98, 0x82 },
	0xC2FE, { 0xE7, 0x9A, 0x97 },
	0xC3A1, { 0xE7, 0x9A, 0x98 },
	0xC3A2, { 0xE3, 0xBF, 0xA2 },
	0xC3A3, { 0xE4, 0x80, 0x84 },
	0xC3A4, { 0xE4, 0x81, 0x83 },
	0xC3A5, { 0xE7, 0x9D, 0x9D },
	0xC3A6, { 0xE7, 0x9D, 0xA4 },
	0xC3A7, { 0xE7, 0x9D, 0x93 },
	0xC3A8, { 0xE7, 0x9D, 0x98 },
	0xC3A9, { 0xE7, 0xA2, 0x82 },
	0xC3AA, { 0xE7, 0xA2, 0x90 },
	0xC3AB, { 0xE7, 0xA2, 0x8A },
	0xC3AC, { 0xE4, 0x82, 0xBE },
	0xC3AD, { 0xE7, 0xA1, 0xBA },
	0xC3AE, { 0xE7, 0xA1, 0xBD },
	0xC3AF, { 0xE4, 0x82, 0xBA },
	0xC3B0, { 0xE7, 0xA2, 0x8B },
	0xC3B1, { 0xE7, 0xA1, 0xB8 },
	0xC3B2, { 0xE4, 0x82, 0xBC },
	0xC3B3, { 0xF0, 0xAF, 0xA5, 0x8E },
	0xC3B4, { 0xE7, 0xA2, 0x8D },
	0xC3B5, { 0xE7, 0xA2, 0x88 },
	0xC3B6, { 0xE7, 0xA2, 0x92 },
	0xC3B7, { 0xE7, 0xA2, 0x81 },
	0xC3B8, { 0xE7, 0xA5, 0xBE },
	0xC3B9, { 0xE7, 0xA6, 0x83 },
	0xC3BA, { 0xE4, 0x84, 0x8D },
	0xC3BB, { 0xE4, 0x84, 0x8E },
	0xC3BC, { 0xE4, 0x84, 0x91 },
	0xC3BD, { 0xE7, 0xA6, 0x80 },
	0xC3BE, { 0xE4, 0x84, 0x8F },
	0xC3BF, { 0xE4, 0x84, 0x92 },
	0xC3C0, { 0xE4, 0x85, 0x95 },
	0xC3C1, { 0xE7, 0xA8, 0x8F },
	0xC3C2, { 0xE4, 0x85, 0x99 },
	0xC3C3, { 0xE4, 0x85, 0x9B },
	0xC3C4, { 0xE7, 0xA8, 0x9D },
	0xC3C5, { 0xE4, 0x85, 0x97 },
	0xC3C6, { 0xE7, 0xAA, 0xA1 },
	0xC3C7, { 0xE7, 0xAA, 0xA4 },
	0xC3C8, { 0xE4, 0x87, 0x8E },
	0xC3C9, { 0xE7, 0xAB, 0xA9 },
	0xC3CA, { 0xE7, 0xAB, 0xAA },
	0xC3CB, { 0xE4, 0x87, 0xBE },
	0xC3CC, { 0xE7, 0xAD, 0xA2 },
	0xC3CD, { 0xE7, 0xAD, 0xAB },
	0xC3CE, { 0xE4, 0x87, 0xBC },
	0xC3CF, { 0xE7, 0xAD, 0x9E },
	0xC3D0, { 0xE4, 0x87, 0xB5 },
	0xC3D1, { 0xE7, 0xAD, 0xB9 },
	0xC3D2, { 0xE4, 0x87, 0xB9 },
	0xC3D3, { 0xE4, 0x87, 0xBA },
	0xC3D4, { 0xE7, 0xAD, 0xAF },
	0xC3D5, { 0xE7, 0xAD, 0xA8 },
	0xC3D6, { 0xE4, 0x8A, 0x88 },
	0xC3D7, { 0xE4, 0x8A, 0x89 },
	0xC3D8, { 0xE7, 0xB2, 0xAE },
	0xC3D9, { 0xE4, 0x8A, 0x8A },
	0xC3DA, { 0xE4, 0x8A, 0x87 },
	0xC3DB, { 0xE4, 0x8A, 0x8B },
	0xC3DC, { 0xE7, 0xB2, 0xB0 },
	0xC3DD, { 0xE4, 0x8B, 0xA6 },
	0xC3DE, { 0xE7, 0xB6, 0x90 },
	0xC3DF, { 0xE4, 0x8B, 0xAD },
	0xC3E0, { 0xE7, 0xB6, 0x8A },
	0xC3E1, { 0xE4, 0x8B, 0xA5 },
	0xC3E2, { 0xE7, 0xB6, 0x8B },
	0xC3E3, { 0xE7, 0xB6, 0x99 },
	0xC3E4, { 0xE7, 0xB6, 0x95 },
	0xC3E5, { 0xE4, 0x8B, 0xA0 },
	0xC3E6, { 0xE7, 0xB6, 0x87 },
	0xC3E7, { 0xE7, 0xB5, 0xB8 },
	0xC3E8, { 0xE7, 0xB6, 0x97 },
	0xC3E9, { 0xE7, 0xB6, 0x89 },
	0xC3EA, { 0xE7, 0xB6, 0x98 },
	0xC3EB, { 0xE4, 0x8B, 0xA1 },
	0xC3EC, { 0xE4, 0x8D, 0x9B },
	0xC3ED, { 0xE4, 0x8D, 0x9C },
	0xC3EE, { 0xE7, 0xBE, 0xA3 },
	0xC3EF, { 0xE4, 0x8E, 0x8F },
	0xC3F0, { 0xE4, 0x8E, 0x8B },
	0xC3F1, { 0xE4, 0x8E, 0x8D },
	0xC3F2, { 0xE7, 0xBF, 0x9D },
	0xC3F3, { 0xE8, 0x81, 0x97 },
	0xC3F4, { 0xE4, 0x8E, 0xB9 },
	0xC3F5, { 0xE8, 0x85, 0xA3 },
	0xC3F6, { 0xE8, 0x85, 0xAA },
	0xC3F7, { 0xE8, 0x85, 0xAC },
	0xC3F8, { 0xE4, 0x90, 0x8F },
	0xC3F9, { 0xE4, 0x90, 0x99 },
	0xC3FA, { 0xE4, 0x90, 0x93 },
	0xC3FB, { 0xE8, 0x85, 0x9D },
	0xC3FC, { 0xE8, 0x85, 0xB5 },
	0xC3FD, { 0xE4, 0x90, 0x98 },
	0xC3FE, { 0xE8, 0x85, 0x9F },
	0xC4A1, { 0xE4, 0x90, 0x96 },
	0xC4A2, { 0xE8, 0x85, 0xBD },
	0xC4A3, { 0xE8, 0x85, 0xAD },
	0xC4A4, { 0xE4, 0x91, 0x93 },
	0xC4A5, { 0xF0, 0xAF, 0xA6, 0x8D },
	0xC4A6, { 0xE8, 0x89, 0x81 },
	0xC4A7, { 0xE8, 0x91, 0x8F },
	0xC4A8, { 0xE8, 0x92, 0x84 },
	0xC4A9, { 0xE4, 0x93, 0xB6 },
	0xC4AA, { 0xE8, 0x91, 0xBF },
	0xC4AB, { 0xE4, 0x93, 0xB5 },
	0xC4AC, { 0xE8, 0x91, 0x88 },
	0xC4AD, { 0xE8, 0x90, 0xAA },
	0xC4AE, { 0xE8, 0x91, 0xBB },
	0xC4AF, { 0xE8, 0x91, 0xB2 },
	0xC4B0, { 0xE8, 0x91, 0xA4 },
	0xC4B1, { 0xE8, 0x90, 0xAE },
	0xC4B2, { 0xE8, 0x91, 0x9C },
	0xC4B3, { 0xE8, 0x91, 0x93 },
	0xC4B4, { 0xE4, 0x93, 0xB7 },
	0xC4B5, { 0xE8, 0x91, 0x81 },
	0xC4B6, { 0xE8, 0x93, 0x88 },
	0xC4B7, { 0xE4, 0x93, 0xB0 },
	0xC4B8, { 0xE8, 0x91, 0xA2 },
	0xC4B9, { 0xE8, 0x92, 0x80 },
	0xC4BA, { 0xE8, 0x90, 0xBE },
	0xC4BB, { 0xE8, 0x92, 0x83 },
	0xC4BC, { 0xE8, 0x91, 0xB1 },
	0xC4BD, { 0xE4, 0x93, 0xB9 },
	0xC4BE, { 0xE8, 0x91, 0x8A },
	0xC4BF, { 0xE8, 0x91, 0x95 },
	0xC4C0, { 0xE8, 0x91, 0x98 },
	0xC4C1, { 0xE4, 0x96, 0x92 },
	0xC4C2, { 0xE4, 0x96, 0x95 },
	0xC4C3, { 0xE4, 0x96, 0x96 },
	0xC4C4, { 0xE8, 0x9B, 0xBC },
	0xC4C5, { 0xE8, 0x9B, 0xBD },
	0xC4C6, { 0xE8, 0x9C, 0x95 },
	0xC4C7, { 0xE4, 0x96, 0xB9 },
	0xC4C8, { 0xE8, 0x9C, 0x96 },
	0xC4C9, { 0xE8, 0x9B, 0xBF },
	0xC4CA, { 0xE4, 0x96, 0xBD },
	0xC4CB, { 0xE4, 0x96, 0xB8 },
	0xC4CC, { 0xE4, 0x98, 0x92 },
	0xC4CD, { 0xE8, 0xA1, 0x98 },
	0xC4CE, { 0xE8, 0xA3, 0x8F },
	0xC4CF, { 0xE8, 0xA3, 0xA0 },
	0xC4D0, { 0xE4, 0x9A, 0x80 },
	0xC4D1, { 0xE4, 0x9A, 0x81 },
	0xC4D2, { 0xE4, 0x9A, 0x9A },
	0xC4D3, { 0xE4, 0x9A, 0x98 },
	0xC4D4, { 0xE8, 0xA7, 0xA7 },
	0xC4D5, { 0xE8, 0xA9, 0xAA },
	0xC4D6, { 0xE8, 0xAA, 0x80 },
	0xC4D7, { 0xE4, 0x9B, 0x94 },
	0xC4D8, { 0xE8, 0xA9, 0xAF },
	0xC4D9, { 0xE8, 0xA9, 0xA5 },
	0xC4DA, { 0xE4, 0x9B, 0x9A },
	0xC4DB, { 0xE8, 0xA9, 0xB8 },
	0xC4DC, { 0xE8, 0xA9, 0xBD },
	0xC4DD, { 0xE8, 0xAA, 0x88 },
	0xC4DE, { 0xE4, 0x9B, 0x96 },
	0xC4DF, { 0xE4, 0x9B, 0x9B },
	0xC4E0, { 0xE8, 0xA9, 0xA4 },
	0xC4E1, { 0xE8, 0xA9, 0xBE },
	0xC4E2, { 0xE4, 0x9B, 0x9C },
	0xC4E3, { 0xE8, 0xA9, 0xA7 },
	0xC4E4, { 0xE8, 0xB1, 0xA3 },
	0xC4E5, { 0xE8, 0xB2, 0x88 },
	0xC4E6, { 0xE4, 0x9D, 0xB1 },
	0xC4E7, { 0xE8, 0xB3, 0x8D },
	0xC4E8, { 0xE4, 0x9D, 0xB2 },
	0xC4E9, { 0xE8, 0xB3, 0x89 },
	0xC4EA, { 0xE4, 0x9E, 0xA8 },
	0xC4EB, { 0xE8, 0xB7, 0xAD },
	0xC4EC, { 0xE4, 0x9F, 0xB0 },
	0xC4ED, { 0xF0, 0xAF, 0xA7, 0x9B },
	0xC4EE, { 0xE4, 0x9F, 0xB1 },
	0xC4EF, { 0xE4, 0x9F, 0xBD },
	0xC4F0, { 0xE4, 0xA0, 0xB8 },
	0xC4F1, { 0xE4, 0xA0, 0xB7 },
	0xC4F2, { 0xE4, 0xA0, 0xB9 },
	0xC4F3, { 0xE8, 0xBA, 0xB1 },
	0xC4F4, { 0xE4, 0xA1, 0x95 },
	0xC4F5, { 0xE4, 0xA1, 0x93 },
	0xC4F6, { 0xE8, 0xBC, 0x84 },
	0xC4F7, { 0xE8, 0xBE, 0x9E },
	0xC4F8, { 0xE8, 0xBE, 0xA0 },
	0xC4F9, { 0xE9, 0x81, 0x83 },
	0xC4FA, { 0xE9, 0x81, 0x86 },
	0xC4FB, { 0xE9, 0x81, 0x88 },
	0xC4FC, { 0xE9, 0x81, 0x85 },
	0xC4FD, { 0xE9, 0x81, 0x80 },
	0xC4FE, { 0xE9, 0x81, 0x8C },
	0xC5A1, { 0xE4, 0xA3, 0x95 },
	0xC5A2, { 0xE4, 0xA2, 0xBD },
	0xC5A3, { 0xE9, 0x84, 0x8C },
	0xC5A4, { 0xE9, 0x84, 0x93 },
	0xC5A5, { 0xE9, 0x84, 0x95 },
	0xC5A6, { 0xE4, 0xA3, 0xB5 },
	0xC5A7, { 0xE9, 0x85, 0xAB },
	0xC5A8, { 0xE9, 0x85, 0xA7 },
	0xC5A9, { 0xE9, 0x89, 0x9D },
	0xC5AA, { 0xE9, 0x89, 0x95 },
	0xC5AB, { 0xE9, 0x88, 0xB5 },
	0xC5AC, { 0xE4, 0xA4, 0xA1 },
	0xC5AD, { 0xE9, 0x89, 0x99 },
	0xC5AE, { 0xE9, 0x88, 0xAF },
	0xC5AF, { 0xE9, 0x88, 0xBC },
	0xC5B0, { 0xE9, 0x8A, 0x8F },
	0xC5B1, { 0xE9, 0x89, 0x9C },
	0xC5B2, { 0xE9, 0x89, 0xAA },
	0xC5B3, { 0xE9, 0x89, 0xA2 },
	0xC5B4, { 0xE9, 0x89, 0x9F },
	0xC5B5, { 0xE9, 0x89, 0xAB },
	0xC5B6, { 0xE9, 0x89, 0xAE },
	0xC5B7, { 0xE9, 0x88, 0xBB },
	0xC5B8, { 0xE9, 0x89, 0x84 },
	0xC5B9, { 0xE9, 0x89, 0x81 },
	0xC5BA, { 0xE9, 0x96, 0x9A },
	0xC5BB, { 0xE4, 0xA6, 0x92 },
	0xC5BC, { 0xE9, 0x96, 0x99 },
	0xC5BD, { 0xE4, 0xA7, 0x9E },
	0xC5BE, { 0xE4, 0xA7, 0x9B },
	0xC5BF, { 0xE4, 0xA7, 0x9A },
	0xC5C0, { 0xE9, 0x9A, 0x8F },
	0xC5C1, { 0xE4, 0xA7, 0x9F },
	0xC5C2, { 0xE9, 0x9A, 0x96 },
	0xC5C3, { 0xE4, 0xA7, 0xB9 },
	0xC5C4, { 0xE4, 0xA7, 0xB8 },
	0xC5C5, { 0xE4, 0xA7, 0xBA },
	0xC5C6, { 0xE9, 0x9B, 0xB4 },
	0xC5C7, { 0xE9, 0x9B, 0xBC },
	0xC5C8, { 0xE4, 0xA8, 0x8E },
	0xC5C9, { 0xE9, 0x9D, 0x95 },
	0xC5CA, { 0xE4, 0xA9, 0x83 },
	0xC5CB, { 0xE9, 0x9D, 0xB9 },
	0xC5CC, { 0xE4, 0xA9, 0x96 },
	0xC5CD, { 0xE4, 0xA9, 0x93 },
	0xC5CE, { 0xE4, 0xAA, 0x9E },
	0xC5CF, { 0xE9, 0x9F, 0xAE },
	0xC5D0, { 0xE9, 0x9F, 0xB5 },
	0xC5D1, { 0xE4, 0xAA, 0xA9 },
	0xC5D2, { 0xE9, 0xA0, 0x8B },
	0xC5D3, { 0xE4, 0xAB, 0xBA },
	0xC5D4, { 0xE9, 0xA3, 0xB3 },
	0xC5D5, { 0xE4, 0xAC, 0xB1 },
	0xC5D6, { 0xE4, 0xAC, 0xB0 },
	0xC5D7, { 0xE9, 0xA3, 0xB7 },
	0xC5D8, { 0xE9, 0xA3, 0xBF },
	0xC5D9, { 0xE9, 0xA3, 0xB5 },
	0xC5DA, { 0xE4, 0xAC, 0xB2 },
	0xC5DB, { 0xE9, 0xA3, 0xAC },
	0xC5DC, { 0xE9, 0xA3, 0xB1 },
	0xC5DD, { 0xE4, 0xAC, 0xA9 },
	0xC5DE, { 0xE4, 0xAC, 0xAE },
	0xC5DF, { 0xE9, 0xA6, 0x9A },
	0xC5E0, { 0xE4, 0xAD, 0xB6 },
	0xC5E1, { 0xE9, 0xAB, 0xA2 },
	0xC5E2, { 0xE9, 0xAC, 0xBD },
	0xC5E3, { 0xE9, 0xAD, 0x9D },
	0xC5E4, { 0xE9, 0xB3, 0xA8 },
	0xC5E5, { 0xE4, 0xB2, 0xA5 },
	0xC5E6, { 0xE9, 0xB3, 0xAB },
	0xC5E7, { 0xE9, 0xB3, 0xAF },
	0xC5E8, { 0xE9, 0xB3, 0xAE },
	0xC5E9, { 0xE9, 0xBA, 0x81 },
	0xC5EA, { 0xE9, 0xBC, 0x94 },
	0xC5EB, { 0xE5, 0x83, 0x90 },
	0xC5EC, { 0xE5, 0x83, 0x99 },
	0xC5ED, { 0xE5, 0x83, 0x9C },
	0xC5EE, { 0xE5, 0x83, 0x98 },
	0xC5EF, { 0xE3, 0x92, 0x8C },
	0xC5F0, { 0xE5, 0x83, 0xA1 },
	0xC5F1, { 0xE5, 0x83, 0xAB },
	0xC5F2, { 0xE3, 0x92, 0x8B },
	0xC5F3, { 0xE3, 0x92, 0x89 },
	0xC5F4, { 0xE5, 0x83, 0xB4 },
	0xC5F5, { 0xE5, 0x83, 0xA2 },
	0xC5F6, { 0xE5, 0x83, 0x9E },
	0xC5F7, { 0xE3, 0x92, 0x8D },
	0xC5F8, { 0xE3, 0x92, 0x86 },
	0xC5F9, { 0xE3, 0x93, 0x97 },
	0xC5FA, { 0xE5, 0x87, 0xB4 },
	0xC5FB, { 0xE3, 0x94, 0x84 },
	0xC5FC, { 0xE3, 0x94, 0x87 },
	0xC5FD, { 0xE3, 0x94, 0x83 },
	0xC5FE, { 0xE5, 0x8B, 0xAD },
	0xC6A1, { 0xE5, 0x8B, 0xAA },
	0xC6A2, { 0xE3, 0x94, 0xA2 },
	0xC6A3, { 0xE5, 0x8C, 0xB2 },
	0xC6A4, { 0xE3, 0x95, 0x91 },
	0xC6A5, { 0xE5, 0x8E, 0xAE },
	0xC6A6, { 0xE5, 0x8E, 0xB0 },
	0xC6A7, { 0xE3, 0x95, 0xA1 },
	0xC6A8, { 0xE5, 0x97, 0xBB },
	0xC6A9, { 0xE5, 0x98, 0x83 },
	0xC6AA, { 0xE5, 0x98, 0x8B },
	0xC6AB, { 0xE3, 0x97, 0xA9 },
	0xC6AC, { 0xE5, 0x98, 0x87 },
	0xC6AD, { 0xE3, 0x97, 0xA5 },
	0xC6AE, { 0xE5, 0x97, 0xB8 },
	0xC6AF, { 0xE3, 0x97, 0xA4 },
	0xC6B0, { 0xE5, 0x98, 0xA8 },
	0xC6B1, { 0xE5, 0x98, 0x9E },
	0xC6B2, { 0xE3, 0x97, 0xA3 },
	0xC6B3, { 0xE5, 0x98, 0x98 },
	0xC6B4, { 0xE5, 0x98, 0x91 },
	0xC6B5, { 0xE5, 0x99, 0x91 },
	0xC6B6, { 0xE5, 0x98, 0x85 },
	0xC6B7, { 0xE5, 0x9C, 0x97 },
	0xC6B8, { 0xE5, 0xA2, 0x92 },
	0xC6B9, { 0xE3, 0x99, 0xA5 },
	0xC6BA, { 0xE5, 0xA2, 0x8C },
	0xC6BB, { 0xE3, 0x99, 0xA3 },
	0xC6BC, { 0xE5, 0xA1, 0xB8 },
	0xC6BD, { 0xE5, 0xA2, 0x84 },
	0xC6BE, { 0xE5, 0xA1, 0xB3 },
	0xC6BF, { 0xE5, 0xA2, 0xAD },
	0xC6C0, { 0xE5, 0xA2, 0x97 },
	0xC6C1, { 0xE5, 0xA2, 0x95 },
	0xC6C2, { 0xE5, 0xA1, 0xB7 },
	0xC6C3, { 0xE5, 0xA1, 0xB2 },
	0xC6C4, { 0xE5, 0xA2, 0x96 },
	0xC6C5, { 0xE5, 0xA2, 0x8D },
	0xC6C6, { 0xE5, 0xA4, 0x90 },
	0xC6C7, { 0xE3, 0x9A, 0x8C },
	0xC6C8, { 0xE5, 0xA5, 0xAC },
	0xC6C9, { 0xE3, 0x9C, 0x9A },
	0xC6CA, { 0xE5, 0xAB, 0xA7 },
	0xC6CB, { 0xE3, 0x9C, 0x95 },
	0xC6CC, { 0xE5, 0xAB, 0xA4 },
	0xC6CD, { 0xE3, 0x9C, 0xA0 },
	0xC6CE, { 0xE3, 0x9C, 0xA1 },
	0xC6CF, { 0xE5, 0xAB, 0xAF },
	0xC6D0, { 0xE5, 0x98, 0xA6 },
	0xC6D1, { 0xE3, 0x9C, 0x9C },
	0xC6D2, { 0xE3, 0x9C, 0x9B },
	0xC6D3, { 0xE5, 0xAB, 0xB0 },
	0xC6D4, { 0xE5, 0xB5, 0xBB },
	0xC6D5, { 0xE3, 0x9F, 0xBE },
	0xC6D6, { 0xE5, 0xB6, 0x83 },
	0xC6D7, { 0xE3, 0xA0, 0x84 },
	0xC6D8, { 0xE3, 0xA0, 0x81 },
	0xC6D9, { 0xE5, 0xB6, 0x8B },
	0xC6DA, { 0xE5, 0xB6, 0x8C },
	0xC6DB, { 0xE3, 0xA0, 0x80 },
	0xC6DC, { 0xE5, 0xB5, 0xB8 },
	0xC6DD, { 0xE5, 0xB9, 0x92 },
	0xC6DE, { 0xE3, 0xA1, 0xAD },
	0xC6DF, { 0xE3, 0xA2, 0x93 },
	0xC6E0, { 0xE5, 0xBB, 0x90 },
	0xC6E1, { 0xE5, 0xBB, 0x8F },
	0xC6E2, { 0xE3, 0xA2, 0xA1 },
	0xC6E3, { 0xE5, 0xBE, 0xB3 },
	0xC6E4, { 0xE5, 0xBE, 0xB4 },
	0xC6E5, { 0xE3, 0xA5, 0xB6 },
	0xC6E6, { 0xE3, 0xA5, 0xB9 },
	0xC6E7, { 0xE3, 0xA5, 0xB2 },
	0xC6E8, { 0xE6, 0x85, 0xBB },
	0xC6E9, { 0xE3, 0xA6, 0x83 },
	0xC6EA, { 0xE6, 0x85, 0xAF },
	0xC6EB, { 0xE6, 0x86, 0x81 },
	0xC6EC, { 0xE6, 0x84, 0xBC },
	0xC6ED, { 0xE6, 0x85, 0x82 },
	0xC6EE, { 0xE6, 0x84, 0xB8 },
	0xC6EF, { 0xE6, 0x84, 0xB3 },
	0xC6F0, { 0xF0, 0xAF, 0xA2, 0xA6 },
	0xC6F1, { 0xE6, 0x85, 0xA0 },
	0xC6F2, { 0xE6, 0x85, 0xA9 },
	0xC6F3, { 0xE6, 0x85, 0xBD },
	0xC6F4, { 0xE6, 0x86, 0x86 },
	0xC6F5, { 0xE6, 0x88, 0xAC },
	0xC6F6, { 0xE6, 0x88, 0xA8 },
	0xC6F7, { 0xE3, 0xA8, 0xB8 },
	0xC6F8, { 0xE6, 0x91, 0x8C },
	0xC6F9, { 0xE3, 0xA8, 0xB0 },
	0xC6FA, { 0xE6, 0x91, 0x97 },
	0xC6FB, { 0xE6, 0x91, 0xBC },
	0xC6FC, { 0xE3, 0xA8, 0xB4 },
	0xC6FD, { 0xE3, 0xA8, 0xBA },
	0xC6FE, { 0xE6, 0x91, 0x95 },
	0xC7A1, { 0xE6, 0x91, 0xA2 },
	0xC7A2, { 0xE6, 0x91, 0xB1 },
	0xC7A3, { 0xE6, 0x91, 0xAA },
	0xC7A4, { 0xE6, 0x91, 0x96 },
	0xC7A5, { 0xE6, 0x90, 0xBB },
	0xC7A6, { 0xE6, 0x92, 0x81 },
	0xC7A7, { 0xE3, 0xA8, 0xB5 },
	0xC7A8, { 0xE6, 0x91, 0x8F },
	0xC7A9, { 0xE6, 0x91, 0xBE },
	0xC7AA, { 0xE6, 0x91, 0xA4 },
	0xC7AB, { 0xE3, 0xA8, 0xBF },
	0xC7AC, { 0xE3, 0xA9, 0x80 },
	0xC7AD, { 0xE3, 0xA8, 0xB2 },
	0xC7AE, { 0xE3, 0xA8, 0xB1 },
	0xC7AF, { 0xE3, 0xA8, 0xB6 },
	0xC7B0, { 0xE6, 0x95, 0xB1 },
	0xC7B1, { 0xF0, 0xA3, 0x82, 0xBA },
	0xC7B2, { 0xE3, 0xAC, 0x8F },
	0xC7B3, { 0xE6, 0x9A, 0xA5 },
	0xC7B4, { 0xE6, 0x9A, 0x9A },
	0xC7B5, { 0xE6, 0x9A, 0x9C },
	0xC7B6, { 0xE3, 0xAC, 0x90 },
	0xC7B7, { 0xE6, 0x9A, 0xA6 },
	0xC7B8, { 0xE3, 0xAC, 0x8D },
	0xC7B9, { 0xE6, 0x9A, 0xA4 },
	0xC7BA, { 0xE6, 0xA6, 0x8F },
	0xC7BB, { 0xE6, 0xA7, 0x85 },
	0xC7BC, { 0xE6, 0xA7, 0x88 },
	0xC7BD, { 0xE6, 0xA6, 0x92 },
	0xC7BE, { 0xE6, 0xA6, 0xB2 },
	0xC7BF, { 0xE3, 0xAE, 0xA9 },
	0xC7C0, { 0xE3, 0xAE, 0xB4 },
	0xC7C1, { 0xE3, 0xAE, 0xAC },
	0xC7C2, { 0xE6, 0xA7, 0xA3 },
	0xC7C3, { 0xE6, 0xA7, 0x80 },
	0xC7C4, { 0xE6, 0xA7, 0x96 },
	0xC7C5, { 0xE6, 0xA7, 0x91 },
	0xC7C6, { 0xE6, 0xA6, 0x9F },
	0xC7C7, { 0xE6, 0xA6, 0xA2 },
	0xC7C8, { 0xE6, 0xA7, 0x92 },
	0xC7C9, { 0xE3, 0xAE, 0xB8 },
	0xC7CA, { 0xE3, 0xAE, 0xAE },
	0xC7CB, { 0xF0, 0xA3, 0x97, 0xB3 },
	0xC7CC, { 0xE6, 0xA7, 0xA1 },
	0xC7CD, { 0xE6, 0xA7, 0x95 },
	0xC7CE, { 0xE6, 0xA6, 0x9D },
	0xC7CF, { 0xE3, 0xAE, 0xB3 },
	0xC7D0, { 0xE3, 0xAE, 0xBA },
	0xC7D1, { 0xE6, 0xA6, 0x98 },
	0xC7D2, { 0xE3, 0xB0, 0xBF },
	0xC7D3, { 0xE6, 0xAD, 0xB4 },
	0xC7D4, { 0xE6, 0xAE, 0xA1 },
	0xC7D5, { 0xE3, 0xB4, 0xBC },
	0xC7D6, { 0xE6, 0xBB, 0xB0 },
	0xC7D7, { 0xE6, 0xBB, 0xB3 },
	0xC7D8, { 0xE3, 0xB5, 0x82 },
	0xC7D9, { 0xE3, 0xB5, 0x80 },
	0xC7DA, { 0xE6, 0xBC, 0x9B },
	0xC7DB, { 0xE6, 0xBC, 0x8C },
	0xC7DC, { 0xE6, 0xBC, 0x9D },
	0xC7DD, { 0xE6, 0xBC, 0xB4 },
	0xC7DE, { 0xE6, 0xBC, 0xA8 },
	0xC7DF, { 0xE6, 0xBC, 0x97 },
	0xC7E0, { 0xE3, 0xB4, 0xBE },
	0xC7E1, { 0xE6, 0xBD, 0x84 },
	0xC7E2, { 0xE6, 0xBD, 0x82 },
	0xC7E3, { 0xE6, 0xBC, 0x84 },
	0xC7E4, { 0xE6, 0xBC, 0x91 },
	0xC7E5, { 0xE6, 0xBB, 0xBA },
	0xC7E6, { 0xE6, 0xBD, 0x8A },
	0xC7E7, { 0xE7, 0x86, 0x91 },
	0xC7E8, { 0xE7, 0x86, 0x8E },
	0xC7E9, { 0xE3, 0xB7, 0xA1 },
	0xC7EA, { 0xE7, 0x86, 0x8B },
	0xC7EB, { 0xE7, 0x86, 0x8D },
	0xC7EC, { 0xE7, 0x85, 0xBF },
	0xC7ED, { 0xE7, 0x86, 0x8C },
	0xC7EE, { 0xE7, 0x85, 0xBE },
	0xC7EF, { 0xE7, 0x85, 0xBC },
	0xC7F0, { 0xE7, 0x86, 0x83 },
	0xC7F1, { 0xE3, 0xB7, 0xA6 },
	0xC7F2, { 0xE7, 0x86, 0x88 },
	0xC7F3, { 0xE3, 0xB7, 0xA0 },
	0xC7F4, { 0xE3, 0xB8, 0x95 },
	0xC7F5, { 0xE7, 0x8A, 0x94 },
	0xC7F6, { 0xE3, 0xBA, 0x93 },
	0xC7F7, { 0xE7, 0x8D, 0x95 },
	0xC7F8, { 0xE7, 0x8D, 0x93 },
	0xC7F9, { 0xE7, 0x8D, 0x8F },
	0xC7FA, { 0xE7, 0x8D, 0x94 },
	0xC7FB, { 0xE7, 0x91, 0xAC },
	0xC7FC, { 0xE7, 0x91, 0xA5 },
	0xC7FD, { 0xE7, 0x91, 0xA6 },
	0xC7FE, { 0xE7, 0x91, 0xA1 },
	0xC8A1, { 0xE7, 0x91, 0xAB },
	0xC8A2, { 0xE7, 0x91, 0xA8 },
	0xC8A3, { 0xE7, 0x91, 0xB6 },
	0xC8A4, { 0xE3, 0xBB, 0xA7 },
	0xC8A5, { 0xE7, 0x91, 0xA0 },
	0xC8A6, { 0xF0, 0xA4, 0xA8, 0x8F },
	0xC8A7, { 0xE7, 0x91, 0xB4 },
	0xC8A8, { 0xE7, 0x94, 0x86 },
	0xC8A9, { 0xE7, 0x98, 0x8E },
	0xC8AA, { 0xE3, 0xBE, 0xAD },
	0xC8AB, { 0xE7, 0x98, 0x87 },
	0xC8AC, { 0xE3, 0xBE, 0xAE },
	0xC8AD, { 0xE3, 0xBF, 0xA3 },
	0xC8AE, { 0xE7, 0x9A, 0xB9 },
	0xC8AF, { 0xE3, 0xBF, 0xB5 },
	0xC8B0, { 0xE7, 0x9A, 0xB7 },
	0xC8B1, { 0xE7, 0x9B, 0xA2 },
	0xC8B2, { 0xE4, 0x80, 0x86 },
	0xC8B3, { 0xE7, 0x9D, 0xB4 },
	0xC8B4, { 0xE7, 0x9D, 0xB7 },
	0xC8B5, { 0xE7, 0x9D, 0xB6 },
	0xC8B6, { 0xE7, 0x9D, 0xB5 },
	0xC8B7, { 0xE4, 0x81, 0x8F },
	0xC8B8, { 0xE7, 0x9D, 0xB8 },
	0xC8B9, { 0xE7, 0x9D, 0xB1 },
	0xC8BA, { 0xE4, 0x81, 0x94 },
	0xC8BB, { 0xE7, 0x9D, 0xBA },
	0xC8BC, { 0xE7, 0x85, 0x9B },
	0xC8BD, { 0xE7, 0x9D, 0xBB },
	0xC8BE, { 0xE7, 0xA2, 0xA6 },
	0xC8BF, { 0xE7, 0xA2, 0xAE },
	0xC8C0, { 0xE7, 0xA2, 0xB8 },
	0xC8C1, { 0xE4, 0x83, 0x8B },
	0xC8C2, { 0xE4, 0x83, 0xA3 },
	0xC8C3, { 0xE4, 0x83, 0x89 },
	0xC8C4, { 0xE7, 0xA2, 0xB1 },
	0xC8C5, { 0xE7, 0xA2, 0xAF },
	0xC8C6, { 0xE4, 0x84, 0x93 },
	0xC8C7, { 0xE7, 0xA6, 0x89 },
	0xC8C8, { 0xE7, 0xA6, 0x87 },
	0xC8C9, { 0xE4, 0x84, 0x95 },
	0xC8CA, { 0xE4, 0x85, 0xA1 },
	0xC8CB, { 0xE7, 0xA8, 0xA9 },
	0xC8CC, { 0xE4, 0x85, 0xA6 },
	0xC8CD, { 0xE7, 0xA8, 0xAA },
	0xC8CE, { 0xE4, 0x85, 0xA4 },
	0xC8CF, { 0xE7, 0xA8, 0xAD },
	0xC8D0, { 0xE7, 0xA8, 0xAC },
	0xC8D1, { 0xE4, 0x85, 0xA0 },
	0xC8D2, { 0xE7, 0xA8, 0xB2 },
	0xC8D3, { 0xE4, 0x85, 0xA3 },
	0xC8D4, { 0xE7, 0xAB, 0xAC },
	0xC8D5, { 0xE7, 0xAB, 0xB0 },
	0xC8D6, { 0xE7, 0xAE, 0x81 },
	0xC8D7, { 0xE7, 0xAE, 0x9E },
	0xC8D8, { 0xE7, 0xAE, 0x83 },
	0xC8D9, { 0xE4, 0x88, 0x8A },
	0xC8DA, { 0xE7, 0xAE, 0x92 },
	0xC8DB, { 0xE4, 0x88, 0x84 },
	0xC8DC, { 0xE7, 0xAE, 0xA3 },
	0xC8DD, { 0xE7, 0xAE, 0x9F },
	0xC8DE, { 0xE7, 0xAE, 0x93 },
	0xC8DF, { 0xE4, 0x88, 0x87 },
	0xC8E0, { 0xE7, 0xAE, 0x86 },
	0xC8E1, { 0xE7, 0xB2, 0xB8 },
	0xC8E2, { 0xE7, 0xB2, 0xB7 },
	0xC8E3, { 0xE4, 0x8A, 0x8D },
	0xC8E4, { 0xE4, 0x8A, 0x8F },
	0xC8E5, { 0xE4, 0x8A, 0x90 },
	0xC8E6, { 0xE4, 0x8A, 0x92 },
	0xC8E7, { 0xE4, 0x8B, 0xAC },
	0xC8E8, { 0xE7, 0xB7, 0x88 },
	0xC8E9, { 0xE7, 0xB6, 0xB6 },
	0xC8EA, { 0xF0, 0xAF, 0xA5, 0xAC },
	0xC8EB, { 0xE7, 0xB7, 0x91 },
	0xC8EC, { 0xE4, 0x8B, 0xA7 },
	0xC8ED, { 0xE7, 0xB6, 0xA8 },
	0xC8EE, { 0xE7, 0xB6, 0xAB },
	0xC8EF, { 0xE4, 0x8B, 0xB2 },
	0xC8F0, { 0xE7, 0xB6, 0xB3 },
	0xC8F1, { 0xE7, 0xB7, 0x8D },
	0xC8F2, { 0xE4, 0x8B, 0xAE },
	0xC8F3, { 0xE7, 0xB7, 0x8F },
	0xC8F4, { 0xE7, 0xB6, 0xA4 },
	0xC8F5, { 0xE4, 0x8B, 0xAF },
	0xC8F6, { 0xE4, 0x8D, 0x8C },
	0xC8F7, { 0xE7, 0xBD, 0x81 },
	0xC8F8, { 0xE7, 0xBD, 0xAF },
	0xC8F9, { 0xE7, 0xBD, 0xB1 },
	0xC8FA, { 0xE4, 0x8D, 0x9E },
	0xC8FB, { 0xE4, 0x8D, 0x9F },
	0xC8FC, { 0xE4, 0x8D, 0xB6 },
	0xC8FD, { 0xE4, 0x8D, 0xB4 },
	0xC8FE, { 0xE4, 0x8D, 0xB2 },
	0xC9A1, { 0xE4, 0x8E, 0x90 },
	0xC9A2, { 0xE8, 0x80, 0xA3 },
	0xC9A3, { 0xE8, 0x81, 0x9B },
	0xC9A4, { 0xE4, 0x8E, 0xBE },
	0xC9A5, { 0xE8, 0x81, 0xA1 },
	0xC9A6, { 0xE8, 0x81, 0x9F },
	0xC9A7, { 0xE8, 0x86, 0x81 },
	0xC9A8, { 0xE4, 0x90, 0xA6 },
	0xC9A9, { 0xE4, 0x90, 0xA5 },
	0xC9AA, { 0xE8, 0x86, 0x84 },
	0xC9AB, { 0xE8, 0x88, 0x93 },
	0xC9AC, { 0xE4, 0x91, 0xB4 },
	0xC9AD, { 0xE8, 0x89, 0x8A },
	0xC9AE, { 0xE8, 0x89, 0x8C },
	0xC9AF, { 0xE4, 0x93, 0xBD },
	0xC9B0, { 0xE4, 0x94, 0x85 },
	0xC9B1, { 0xE4, 0x94, 0x81 },
	0xC9B2, { 0xE8, 0x92, 0xBD },
	0xC9B3, { 0xE8, 0x92, 0x95 },
	0xC9B4, { 0xE4, 0x94, 0x89 },
	0xC9B5, { 0xE8, 0x92, 0x92 },
	0xC9B6, { 0xE8, 0x93, 0x83 },
	0xC9B7, { 0xE4, 0x94, 0x8C },
	0xC9B8, { 0xE8, 0x92, 0x96 },
	0xC9B9, { 0xE8, 0x92, 0xA5 },
	0xC9BA, { 0xE8, 0x92, 0xB5 },
	0xC9BB, { 0xE8, 0x92, 0xB3 },
	0xC9BC, { 0xE8, 0x92, 0xA3 },
	0xC9BD, { 0xE8, 0x93, 0xA4 },
	0xC9BE, { 0xE8, 0x93, 0x98 },
	0xC9BF, { 0xE8, 0x93, 0x95 },
	0xC9C0, { 0xE4, 0x94, 0x8D },
	0xC9C1, { 0xE8, 0x92, 0xB7 },
	0xC9C2, { 0xE8, 0x92, 0xAD },
	0xC9C3, { 0xE8, 0x93, 0x9A },
	0xC9C4, { 0xE8, 0x92, 0x93 },
	0xC9C5, { 0xE8, 0x9C, 0xB6 },
	0xC9C6, { 0xE4, 0x97, 0x80 },
	0xC9C7, { 0xE4, 0x97, 0x85 },
	0xC9C8, { 0xE4, 0x97, 0x89 },
	0xC9C9, { 0xE8, 0x9C, 0xBD },
	0xC9CA, { 0xE8, 0x9C, 0xAB },
	0xC9CB, { 0xE8, 0x9D, 0x87 },
	0xC9CC, { 0xE8, 0x9C, 0xB9 },
	0xC9CD, { 0xE4, 0x97, 0x95 },
	0xC9CE, { 0xE8, 0x9D, 0x85 },
	0xC9CF, { 0xE8, 0x9C, 0x9D },
	0xC9D0, { 0xE4, 0x99, 0x81 },
	0xC9D1, { 0xE8, 0xA3, 0xBF },
	0xC9D2, { 0xE8, 0xA3, 0xAA },
	0xC9D3, { 0xE4, 0x98, 0xB3 },
	0xC9D4, { 0xE8, 0xA3, 0xB5 },
	0xC9D5, { 0xE4, 0x98, 0xBA },
	0xC9D6, { 0xE8, 0xA4, 0x80 },
	0xC9D7, { 0xE8, 0xA3, 0xAD },
	0xC9D8, { 0xE8, 0xA4, 0x83 },
	0xC9D9, { 0xE8, 0xA3, 0xA9 },
	0xC9DA, { 0xE4, 0x99, 0x80 },
	0xC9DB, { 0xE4, 0x99, 0x82 },
	0xC9DC, { 0xE8, 0xA7, 0xAA },
	0xC9DD, { 0xE4, 0x9B, 0xA8 },
	0xC9DE, { 0xE8, 0xAA, 0x9B },
	0xC9DF, { 0xE8, 0xAA, 0x8E },
	0xC9E0, { 0xE8, 0xAA, 0xA2 },
	0xC9E1, { 0xE4, 0x9B, 0xA4 },
	0xC9E2, { 0xE8, 0xAA, 0x9C },
	0xC9E3, { 0xE8, 0xAA, 0x94 },
	0xC9E4, { 0xE8, 0xAA, 0x90 },
	0xC9E5, { 0xE8, 0xAA, 0xA9 },
	0xC9E6, { 0xE8, 0xAA, 0xAC },
	0xC9E7, { 0xE4, 0x9B, 0xA7 },
	0xC9E8, { 0xE8, 0xAA, 0x9F },
	0xC9E9, { 0xE4, 0x9B, 0xA6 },
	0xC9EA, { 0xE4, 0x9B, 0xA1 },
	0xC9EB, { 0xE8, 0xAA, 0x9D },
	0xC9EC, { 0xE4, 0x9C, 0xB9 },
	0xC9ED, { 0xE8, 0xB1, 0xA7 },
	0xC9EE, { 0xE4, 0x9D, 0x9C },
	0xC9EF, { 0xE4, 0x9D, 0xB5 },
	0xC9F0, { 0xE8, 0xB3, 0x90 },
	0xC9F1, { 0xE8, 0xB3, 0x96 },
	0xC9F2, { 0xE8, 0xB3, 0x94 },
	0xC9F3, { 0xE8, 0xB6, 0x98 },
	0xC9F4, { 0xE8, 0xB6, 0x9A },
	0xC9F5, { 0xE8, 0xB6, 0x97 },
	0xC9F6, { 0xE4, 0x9E, 0xAE },
	0xC9F7, { 0xE4, 0x9E, 0xB0 },
	0xC9F8, { 0xE4, 0x9F, 0xBA },
	0xC9F9, { 0xE8, 0xB8, 0x8B },
	0xC9FA, { 0xE8, 0xB8, 0x88 },
	0xC9FB, { 0xE8, 0xB8, 0x81 },
	0xC9FC, { 0xE8, 0xBA, 0xB4 },
	0xC9FD, { 0xE8, 0xBA, 0xB3 },
	0xC9FE, { 0xE4, 0xA1, 0x9B },
	0xCAA1, { 0xE8, 0xBE, 0xA1 },
	0xCAA2, { 0xE8, 0xBE, 0xA2 },
	0xCAA3, { 0xE4, 0xA2, 0xA5 },
	0xCAA4, { 0xE9, 0x81, 0x9A },
	0xCAA5, { 0xE4, 0xA2, 0xA2 },
	0xCAA6, { 0xE9, 0x81, 0xA1 },
	0xCAA7, { 0xE9, 0x81, 0x9F },
	0xCAA8, { 0xE4, 0xA3, 0x9B },
	0xCAA9, { 0xE4, 0xA3, 0x9A },
	0xCAAA, { 0xE9, 0x84, 0xA5 },
	0xCAAB, { 0xE9, 0x85, 0xBB },
	0xCAAC, { 0xE9, 0x85, 0xB6 },
	0xCAAD, { 0xE9, 0x85, 0xBC },
	0xCAAE, { 0xE4, 0xA4, 0xA4 },
	0xCAAF, { 0xE9, 0x8A, 0x89 },
	0xCAB0, { 0xE9, 0x8B, 0xB6 },
	0xCAB1, { 0xE9, 0x8A, 0xB1 },
	0xCAB2, { 0xE9, 0x8A, 0xAD },
	0xCAB3, { 0xE9, 0x8A, 0x92 },
	0xCAB4, { 0xE9, 0x8A, 0x81 },
	0xCAB5, { 0xE9, 0x8A, 0x84 },
	0xCAB6, { 0xE4, 0xA4, 0xA6 },
	0xCAB7, { 0xE9, 0x8A, 0xAE },
	0xCAB8, { 0xE9, 0x8A, 0x90 },
	0xCAB9, { 0xE9, 0x8A, 0x9E },
	0xCABA, { 0xE4, 0xA6, 0x98 },
	0xCABB, { 0xE4, 0xA6, 0x96 },
	0xCABC, { 0xE4, 0xA6, 0x9A },
	0xCABD, { 0xE9, 0x96, 0xA2 },
	0xCABE, { 0xE9, 0x96, 0xA7 },
	0xCABF, { 0xE4, 0xA6, 0x97 },
	0xCAC0, { 0xE4, 0xA7, 0xA1 },
	0xCAC1, { 0xE4, 0xA7, 0xA0 },
	0xCAC2, { 0xE4, 0xA7, 0xA3 },
	0xCAC3, { 0xE4, 0xA7, 0xA2 },
	0xCAC4, { 0xE9, 0x9A, 0xA0 },
	0xCAC5, { 0xE9, 0x9A, 0x9D },
	0xCAC6, { 0xE9, 0x9A, 0x9F },
	0xCAC7, { 0xE9, 0x9B, 0x90 },
	0xCAC8, { 0xE4, 0xA7, 0xBB },
	0xCAC9, { 0xE9, 0x9B, 0x91 },
	0xCACA, { 0xE4, 0xA8, 0x92 },
	0xCACB, { 0xE4, 0xA8, 0x94 },
	0xCACC, { 0xE9, 0x9D, 0x99 },
	0xCACD, { 0xE4, 0xA9, 0x85 },
	0xCACE, { 0xE9, 0x9D, 0xA4 },
	0xCACF, { 0xE4, 0xA9, 0x9C },
	0xCAD0, { 0xE4, 0xA9, 0x9D },
	0xCAD1, { 0xE4, 0xAA, 0xB8 },
	0xCAD2, { 0xE9, 0xA0, 0x99 },
	0xCAD3, { 0xE4, 0xAA, 0xBA },
	0xCAD4, { 0xE9, 0xA0, 0x94 },
	0xCAD5, { 0xE9, 0xA0, 0x95 },
	0xCAD6, { 0xE9, 0xA0, 0x9A },
	0xCAD7, { 0xE4, 0xAC, 0x83 },
	0xCAD8, { 0xE4, 0xAC, 0xB5 },
	0xCAD9, { 0xE4, 0xAC, 0xB6 },
	0xCADA, { 0xE4, 0xAC, 0xB9 },
	0xCADB, { 0xE9, 0xA4, 0x86 },
	0xCADC, { 0xE4, 0xAC, 0xAD },
	0xCADD, { 0xE9, 0xA3, 0xB8 },
	0xCADE, { 0xE9, 0xA4, 0x81 },
	0xCADF, { 0xE4, 0xAD, 0xBA },
	0xCAE0, { 0xE9, 0xA6, 0xBE },
	0xCAE1, { 0xE9, 0xA6, 0xBC },
	0xCAE2, { 0xE9, 0xA6, 0xB7 },
	0xCAE3, { 0xE9, 0xA6, 0xB6 },
	0xCAE4, { 0xE9, 0xA7, 0x80 },
	0xCAE5, { 0xE4, 0xAD, 0xB8 },
	0xCAE6, { 0xE9, 0xA6, 0xB8 },
	0xCAE7, { 0xE4, 0xAD, 0xBB },
	0xCAE8, { 0xE4, 0xAD, 0xBC },
	0xCAE9, { 0xE4, 0xAD, 0xBE },
	0xCAEA, { 0xE9, 0xA7, 0x84 },
	0xCAEB, { 0xE4, 0xAD, 0xBD },
	0xCAEC, { 0xE9, 0xA6, 0xBF },
	0xCAED, { 0xE4, 0xAF, 0x89 },
	0xCAEE, { 0xE9, 0xAB, 0x9A },
	0xCAEF, { 0xE9, 0xAB, 0xA4 },
	0xCAF0, { 0xE9, 0xAB, 0xA9 },
	0xCAF1, { 0xE9, 0xAB, 0xA8 },
	0xCAF2, { 0xE9, 0xAB, 0xAA },
	0xCAF3, { 0xE9, 0xAB, 0xA5 },
	0xCAF4, { 0xE4, 0xAF, 0xB3 },
	0xCAF5, { 0xE9, 0xAC, 0xA6 },
	0xCAF6, { 0xE4, 0xB0, 0x9A },
	0xCAF7, { 0xE4, 0xB0, 0x99 },
	0xCAF8, { 0xE9, 0xAD, 0x80 },
	0xCAF9, { 0xE4, 0xB0, 0x9F },
	0xCAFA, { 0xE4, 0xB2, 0xA6 },
	0xCAFB, { 0xE4, 0xB2, 0xA7 },
	0xCAFC, { 0xE4, 0xB2, 0xA8 },
	0xCAFD, { 0xE4, 0xB2, 0xAB },
	0xCAFE, { 0xE4, 0xB2, 0xA9 },
	0xCBA1, { 0xE4, 0xB4, 0xAE },
	0xCBA2, { 0xE9, 0xBA, 0xBD },
	0xCBA3, { 0xE4, 0xB5, 0x9E },
	0xCBA4, { 0xE3, 0x92, 0x95 },
	0xCBA5, { 0xE3, 0x92, 0x93 },
	0xCBA6, { 0xE3, 0x92, 0x92 },
	0xCBA7, { 0xE5, 0x84, 0x8E },
	0xCBA8, { 0xE3, 0x92, 0x96 },
	0xCBA9, { 0xE5, 0x83, 0xB7 },
	0xCBAA, { 0xE3, 0x92, 0x97 },
	0xCBAB, { 0xE5, 0x83, 0xBC },
	0xCBAC, { 0xE5, 0x84, 0x8D },
	0xCBAD, { 0xE5, 0x84, 0x81 },
	0xCBAE, { 0xE5, 0x87, 0x9A },
	0xCBAF, { 0xE5, 0x87, 0x99 },
	0xCBB0, { 0xE5, 0x87, 0x9B },
	0xCBB1, { 0xE5, 0x8A, 0x86 },
	0xCBB2, { 0xE5, 0x8A, 0x8E },
	0xCBB3, { 0xE5, 0x8B, 0xAE },
	0xCBB4, { 0xE5, 0x8C, 0xB3 },
	0xCBB5, { 0xE5, 0x8E, 0xB1 },
	0xCBB6, { 0xE3, 0x97, 0xB5 },
	0xCBB7, { 0xE5, 0x99, 0x87 },
	0xCBB8, { 0xE5, 0x98, 0xAD },
	0xCBB9, { 0xE5, 0x99, 0x94 },
	0xCBBA, { 0xE3, 0x97, 0xAA },
	0xCBBB, { 0xE5, 0x99, 0x8B },
	0xCBBC, { 0xE5, 0x99, 0x92 },
	0xCBBD, { 0xE5, 0x98, 0xB1 },
	0xCBBE, { 0xE5, 0x99, 0x84 },
	0xCBBF, { 0xE5, 0x99, 0x96 },
	0xCBC0, { 0xE5, 0x99, 0x90 },
	0xCBC1, { 0xE5, 0x98, 0xAB },
	0xCBC2, { 0xE3, 0x97, 0xB3 },
	0xCBC3, { 0xE5, 0x99, 0x8D },
	0xCBC4, { 0xE5, 0x98, 0xB7 },
	0xCBC5, { 0xE5, 0x99, 0x8F },
	0xCBC6, { 0xE5, 0xA2, 0xA2 },
	0xCBC7, { 0xE5, 0xA2, 0xB7 },
	0xCBC8, { 0xE3, 0x99, 0xA9 },
	0xCBC9, { 0xE5, 0xA2, 0xB2 },
	0xCBCA, { 0xE3, 0x99, 0xAB },
	0xCBCB, { 0xE5, 0xA2, 0xAA },
	0xCBCC, { 0xE5, 0xA2, 0xB5 },
	0xCBCD, { 0xE5, 0xA2, 0xB0 },
	0xCBCE, { 0xE3, 0x99, 0xAC },
	0xCBCF, { 0xE5, 0xA2, 0xB4 },
	0xCBD0, { 0xE5, 0xA2, 0xA4 },
	0xCBD1, { 0xE5, 0xA2, 0xA7 },
	0xCBD2, { 0xE3, 0x99, 0xA8 },
	0xCBD3, { 0xE5, 0xA4, 0xA6 },
	0xCBD4, { 0xE5, 0xAB, 0xBE },
	0xCBD5, { 0xE3, 0x9C, 0xA8 },
	0xCBD6, { 0xE5, 0xAC, 0x84 },
	0xCBD7, { 0xE3, 0x9C, 0xA6 },
	0xCBD8, { 0xE5, 0xAB, 0xBC },
	0xCBD9, { 0xE3, 0x9C, 0xA5 },
	0xCBDA, { 0xE5, 0xAC, 0x86 },
	0xCBDB, { 0xE5, 0xAC, 0x8A },
	0xCBDC, { 0xE5, 0xAB, 0xBA },
	0xCBDD, { 0xE5, 0xAC, 0x8D },
	0xCBDE, { 0xE5, 0xAC, 0x80 },
	0xCBDF, { 0xE5, 0xAC, 0x8E },
	0xCBE0, { 0xE3, 0x9D, 0xAB },
	0xCBE1, { 0xE3, 0xA0, 0x8F },
	0xCBE2, { 0xE3, 0xA0, 0x88 },
	0xCBE3, { 0xE5, 0xB6, 0x91 },
	0xCBE4, { 0xE3, 0xA0, 0x8C },
	0xCBE5, { 0xE5, 0xB6, 0x8F },
	0xCBE6, { 0xE5, 0xB6, 0x90 },
	0xCBE7, { 0xE5, 0xB6, 0x98 },
	0xCBE8, { 0xE5, 0xB6, 0xA4 },
	0xCBE9, { 0xE5, 0xB6, 0x9B },
	0xCBEA, { 0xE5, 0xB6, 0xA3 },
	0xCBEB, { 0xE5, 0xB6, 0x96 },
	0xCBEC, { 0xE5, 0xB7, 0xA4 },
	0xCBED, { 0xE5, 0xB9, 0x9A },
	0xCBEE, { 0xE3, 0xA1, 0xA0 },
	0xCBEF, { 0xE3, 0xA1, 0xA2 },
	0xCBF0, { 0xE5, 0xB9, 0x9E },
	0xCBF1, { 0xE3, 0xA2, 0x98 },
	0xCBF2, { 0xE5, 0xBE, 0xB8 },
	0xCBF3, { 0xE6, 0x85, 0x97 },
	0xCBF4, { 0xE6, 0x85, 0x9C },
	0xCBF5, { 0xE6, 0x86, 0xA6 },
	0xCBF6, { 0xE6, 0x86, 0x95 },
	0xCBF7, { 0xE6, 0x86, 0x88 },
	0xCBF8, { 0xE3, 0xA6, 0x8A },
	0xCBF9, { 0xE6, 0x86, 0xA3 },
	0xCBFA, { 0xE6, 0x86, 0x8F },
	0xCBFB, { 0xE3, 0xA6, 0x84 },
	0xCBFC, { 0xE6, 0x85, 0xA4 },
	0xCBFD, { 0xE3, 0xA5, 0xBF },
	0xCBFE, { 0xE6, 0x85, 0x99 },
	0xCCA1, { 0xE6, 0x85, 0xB8 },
	0xCCA2, { 0xE3, 0xA6, 0x82 },
	0xCCA3, { 0xE6, 0x86, 0x85 },
	0xCCA4, { 0xE6, 0x86, 0x87 },
	0xCCA5, { 0xE6, 0x86, 0x9E },
	0xCCA6, { 0xE3, 0xA6, 0x96 },
	0xCCA7, { 0xE3, 0xA6, 0x89 },
	0xCCA8, { 0xE6, 0x86, 0x98 },
	0xCCA9, { 0xE6, 0x86, 0x9C },
	0xCCAA, { 0xE3, 0xA6, 0x8D },
	0xCCAB, { 0xE3, 0xA6, 0xBC },
	0xCCAC, { 0xE6, 0x88, 0xAF },
	0xCCAD, { 0xE6, 0x92, 0x80 },
	0xCCAE, { 0xE6, 0x92, 0x9B },
	0xCCAF, { 0xE6, 0x92, 0x8E },
	0xCCB0, { 0xE6, 0x92, 0x8D },
	0xCCB1, { 0xE6, 0x92, 0x94 },
	0xCCB2, { 0xE6, 0x93, 0x86 },
	0xCCB3, { 0xE3, 0xA9, 0x84 },
	0xCCB4, { 0xE6, 0x92, 0xA8 },
	0xCCB5, { 0xE6, 0x92, 0x83 },
	0xCCB6, { 0xE3, 0xA8, 0xBC },
	0xCCB7, { 0xE6, 0x92, 0xB9 },
	0xCCB8, { 0xE6, 0x92, 0x86 },
	0xCCB9, { 0xE6, 0x92, 0xB4 },
	0xCCBA, { 0xE6, 0x92, 0xAF },
	0xCCBB, { 0xE6, 0x92, 0x91 },
	0xCCBC, { 0xE3, 0xA9, 0x8E },
	0xCCBD, { 0xE6, 0x92, 0xAA },
	0xCCBE, { 0xE6, 0x92, 0xA1 },
	0xCCBF, { 0xE6, 0x92, 0xA7 },
	0xCCC0, { 0xE6, 0x9A, 0xB6 },
	0xCCC1, { 0xE6, 0x9A, 0xB3 },
	0xCCC2, { 0xE3, 0xAC, 0x94 },
	0xCCC3, { 0xE6, 0x9A, 0xBC },
	0xCCC4, { 0xE6, 0x9A, 0xAC },
	0xCCC5, { 0xE3, 0xAC, 0x95 },
	0xCCC6, { 0xE6, 0x9A, 0xAD },
	0xCCC7, { 0xE6, 0xA8, 0x8E },
	0xCCC8, { 0xE3, 0xAF, 0x8E },
	0xCCC9, { 0xE6, 0xA8, 0x9C },
	0xCCCA, { 0xE6, 0xA8, 0x9A },
	0xCCCB, { 0xE3, 0xAF, 0xA0 },
	0xCCCC, { 0xE3, 0xAF, 0x82 },
	0xCCCD, { 0xE6, 0xA8, 0x8B },
	0xCCCE, { 0xE3, 0xAE, 0xBF },
	0xCCCF, { 0xE6, 0xA7, 0xAF },
	0xCCD0, { 0xE6, 0xA8, 0x8C },
	0xCCD1, { 0xE6, 0xA7, 0xB0 },
	0xCCD2, { 0xE6, 0xA8, 0xA2 },
	0xCCD3, { 0xE3, 0xAF, 0x84 },
	0xCCD4, { 0xE6, 0xA7, 0x98 },
	0xCCD5, { 0xE3, 0xAF, 0x8F },
	0xCCD6, { 0xE6, 0xA8, 0x92 },
	0xCCD7, { 0xE6, 0xA7, 0xBA },
	0xCCD8, { 0xE3, 0xAF, 0x88 },
	0xCCD9, { 0xE6, 0xA8, 0xAA },
	0xCCDA, { 0xE3, 0xAF, 0x8C },
	0xCCDB, { 0xE6, 0xA8, 0x90 },
	0xCCDC, { 0xE3, 0xAF, 0x8D },
	0xCCDD, { 0xE3, 0xAF, 0x87 },
	0xCCDE, { 0xE6, 0xA8, 0xA9 },
	0xCCDF, { 0xE6, 0xA7, 0xB9 },
	0xCCE0, { 0xE6, 0xA7, 0xAA },
	0xCCE1, { 0xE6, 0xA8, 0xAC },
	0xCCE2, { 0xE6, 0xA8, 0xA4 },
	0xCCE3, { 0xE4, 0xB2, 0xB7 },
	0xCCE4, { 0xE6, 0xA7, 0xA9 },
	0xCCE5, { 0xE6, 0xAD, 0x92 },
	0xCCE6, { 0xE6, 0xAD, 0x8F },
	0xCCE7, { 0xE6, 0xAD, 0x93 },
	0xCCE8, { 0xE3, 0xB1, 0x83 },
	0xCCE9, { 0xE3, 0xB2, 0xB6 },
	0xCCEA, { 0xE6, 0xBC, 0x90 },
	0xCCEB, { 0xE6, 0xBD, 0xA5 },
	0xCCEC, { 0xE6, 0xBD, 0xB5 },
	0xCCED, { 0xE3, 0xB5, 0x91 },
	0xCCEE, { 0xE3, 0xB5, 0x8A },
	0xCCEF, { 0xE3, 0xB5, 0x8D },
	0xCCF0, { 0xE3, 0xB5, 0x96 },
	0xCCF1, { 0xE6, 0xBF, 0x90 },
	0xCCF2, { 0xE3, 0xB5, 0x93 },
	0xCCF3, { 0xE6, 0xBD, 0x9C },
	0xCCF4, { 0xE6, 0xBC, 0xBD },
	0xCCF5, { 0xE6, 0xBD, 0xB1 },
	0xCCF6, { 0xE3, 0xB5, 0x99 },
	0xCCF7, { 0xE6, 0xBE, 0x91 },
	0xCCF8, { 0xE6, 0xBC, 0x8B },
	0xCCF9, { 0xE6, 0xBD, 0xB9 },
	0xCCFA, { 0xE6, 0xBE, 0x81 },
	0xCCFB, { 0xE6, 0xBE, 0x8F },
	0xCCFC, { 0xE3, 0xB5, 0x8E },
	0xCCFD, { 0xE6, 0xBD, 0x99 },
	0xCCFE, { 0xE6, 0xBD, 0xB4 },
	0xCDA1, { 0xE3, 0xB7, 0xAE },
	0xCDA2, { 0xE7, 0x86, 0xAE },
	0xCDA3, { 0xE3, 0xB7, 0xAC },
	0xCDA4, { 0xE7, 0x86, 0xA3 },
	0xCDA5, { 0xE7, 0x86, 0xAD },
	0xCDA6, { 0xE3, 0xB7, 0xAB },
	0xCDA7, { 0xE3, 0xB7, 0xAF },
	0xCDA8, { 0xE7, 0x86, 0xAB },
	0xCDA9, { 0xE7, 0x86, 0xA6 },
	0xCDAA, { 0xE7, 0x86, 0xA2 },
	0xCDAB, { 0xE3, 0xB7, 0xAD },
	0xCDAC, { 0xE5, 0x8B, 0xB2 },
	0xCDAD, { 0xE7, 0x89, 0x97 },
	0xCDAE, { 0xE7, 0x89, 0x95 },
	0xCDAF, { 0xE7, 0x8A, 0x99 },
	0xCDB0, { 0xE7, 0x8D, 0x8B },
	0xCDB1, { 0xE7, 0x91, 0xBA },
	0xCDB2, { 0xE3, 0xBB, 0xB2 },
	0xCDB3, { 0xE3, 0xBB, 0xAF },
	0xCDB4, { 0xE3, 0xBB, 0xB1 },
	0xCDB5, { 0xE7, 0x92, 0x8C },
	0xCDB6, { 0xE7, 0x92, 0x84 },
	0xCDB7, { 0xE3, 0xBB, 0xAD },
	0xCDB8, { 0xE3, 0xBB, 0xB0 },
	0xCDB9, { 0xE7, 0x92, 0x82 },
	0xCDBA, { 0xE7, 0x92, 0x93 },
	0xCDBB, { 0xE7, 0x91, 0xBB },
	0xCDBC, { 0xE3, 0xBB, 0xAE },
	0xCDBD, { 0xE7, 0x94, 0x89 },
	0xCDBE, { 0xE4, 0xB0, 0x9B },
	0xCDBF, { 0xE3, 0xBD, 0x90 },
	0xCDC0, { 0xE3, 0xBD, 0xA6 },
	0xCDC1, { 0xE3, 0x9A, 0x84 },
	0xCDC2, { 0xE3, 0xBE, 0xB8 },
	0xCDC3, { 0xE3, 0xBF, 0xB6 },
	0xCDC4, { 0xE7, 0x9E, 0x8A },
	0xCDC5, { 0xE4, 0x81, 0x97 },
	0xCDC6, { 0xE7, 0x9E, 0x90 },
	0xCDC7, { 0xE4, 0x81, 0x9E },
	0xCDC8, { 0xE7, 0xA3, 0x86 },
	0xCDC9, { 0xE7, 0xA3, 0x93 },
	0xCDCA, { 0xE7, 0xA3, 0x80 },
	0xCDCB, { 0xE7, 0xA3, 0x92 },
	0xCDCC, { 0xE7, 0xA3, 0x87 },
	0xCDCD, { 0xE7, 0xA3, 0x82 },
	0xCDCE, { 0xE4, 0x84, 0x99 },
	0xCDCF, { 0xE7, 0xA6, 0x9F },
	0xCDD0, { 0xE7, 0xA6, 0x9D },
	0xCDD1, { 0xE7, 0xA6, 0x9E },
	0xCDD2, { 0xE4, 0x85, 0xB0 },
	0xCDD3, { 0xE7, 0xA9, 0x81 },
	0xCDD4, { 0xE4, 0x85, 0xAE },
	0xCDD5, { 0xE7, 0xA8, 0xB8 },
	0xCDD6, { 0xE7, 0xA8, 0xBA },
	0xCDD7, { 0xE7, 0xA9, 0x82 },
	0xCDD8, { 0xE4, 0x85, 0xB2 },
	0xCDD9, { 0xE4, 0x85, 0xB6 },
	0xCDDA, { 0xE7, 0xA8, 0xBE },
	0xCDDB, { 0xE7, 0xAA, 0xB0 },
	0xCDDC, { 0xE7, 0xAE, 0xAE },
	0xCDDD, { 0xE7, 0xAE, 0xB3 },
	0xCDDE, { 0xE4, 0x88, 0x92 },
	0xCDDF, { 0xE4, 0x88, 0x9F },
	0xCDE0, { 0xE7, 0xAE, 0xBF },
	0xCDE1, { 0xE4, 0x88, 0x91 },
	0xCDE2, { 0xE4, 0x88, 0x96 },
	0xCDE3, { 0xE7, 0xAF, 0x8D },
	0xCDE4, { 0xE4, 0x88, 0x99 },
	0xCDE5, { 0xE7, 0xAE, 0xB2 },
	0xCDE6, { 0xE4, 0x88, 0xA4 },
	0xCDE7, { 0xE4, 0x88, 0x94 },
	0xCDE8, { 0xE4, 0x88, 0xA5 },
	0xCDE9, { 0xE4, 0x8A, 0x95 },
	0xCDEA, { 0xE4, 0x8A, 0x96 },
	0xCDEB, { 0xE4, 0x8A, 0x93 },
	0xCDEC, { 0xE4, 0x8A, 0x94 },
	0xCDED, { 0xE7, 0xB3, 0x84 },
	0xCDEE, { 0xE7, 0xB3, 0x8D },
	0xCDEF, { 0xE7, 0xB3, 0x82 },
	0xCDF0, { 0xE7, 0xB3, 0x86 },
	0xCDF1, { 0xE7, 0xB3, 0x83 },
	0xCDF2, { 0xE7, 0xB3, 0x89 },
	0xCDF3, { 0xE7, 0xB3, 0x87 },
	0xCDF4, { 0xE4, 0x8A, 0xA0 },
	0xCDF5, { 0xE7, 0xB7, 0xB8 },
	0xCDF6, { 0xE4, 0x8B, 0xBB },
	0xCDF7, { 0xE7, 0xB7, 0xAD },
	0xCDF8, { 0xE7, 0xB7, 0xA2 },
	0xCDF9, { 0xE4, 0x8B, 0xBC },
	0xCDFA, { 0xE4, 0x8C, 0x80 },
	0xCDFB, { 0xE4, 0x8B, 0xB8 },
	0xCDFC, { 0xE7, 0xB7, 0x9C },
	0xCDFD, { 0xE7, 0xB8, 0x82 },
	0xCDFE, { 0xE7, 0xB8, 0x81 },
	0xCEA1, { 0xE4, 0x8B, 0xB9 },
	0xCEA2, { 0xE7, 0xB7, 0x96 },
	0xCEA3, { 0xE4, 0x8C, 0x84 },
	0xCEA4, { 0xE7, 0xB7, 0xA4 },
	0xCEA5, { 0xE7, 0xB7, 0xBE },
	0xCEA6, { 0xE4, 0x8C, 0x83 },
	0xCEA7, { 0xE7, 0xB8, 0x80 },
	0xCEA8, { 0xE7, 0xB7, 0xBC },
	0xCEA9, { 0xE7, 0xB7, 0xBD },
	0xCEAA, { 0xE4, 0x8B, 0xB3 },
	0xCEAB, { 0xE7, 0xB7, 0xB5 },
	0xCEAC, { 0xE7, 0xB7, 0xBF },
	0xCEAD, { 0xE4, 0x8B, 0xBA },
	0xCEAE, { 0xE7, 0xB7, 0xAB },
	0xCEAF, { 0xE7, 0xB7, 0xA5 },
	0xCEB0, { 0xE7, 0xBD, 0xB8 },
	0xCEB1, { 0xE7, 0xBE, 0xAE },
	0xCEB2, { 0xE7, 0xBF, 0xA7 },
	0xCEB3, { 0xE4, 0x8E, 0xBF },
	0xCEB4, { 0xE8, 0x81, 0xA5 },
	0xCEB5, { 0xE8, 0x81, 0xAA },
	0xCEB6, { 0xE8, 0x81, 0xA6 },
	0xCEB7, { 0xE8, 0x81, 0xA8 },
	0xCEB8, { 0xE8, 0x81, 0xAB },
	0xCEB9, { 0xE8, 0x86, 0x94 },
	0xCEBA, { 0xE8, 0x86, 0xA1 },
	0xCEBB, { 0xE8, 0x86, 0x92 },
	0xCEBC, { 0xE8, 0x86, 0x96 },
	0xCEBD, { 0xE8, 0x86, 0x93 },
	0xCEBE, { 0xE4, 0x91, 0xB9 },
	0xCEBF, { 0xE4, 0x94, 0x90 },
	0xCEC0, { 0xE8, 0x94, 0x81 },
	0xCEC1, { 0xE4, 0x94, 0x94 },
	0xCEC2, { 0xE8, 0x93, 0xB8 },
	0xCEC3, { 0xE4, 0x94, 0x8E },
	0xCEC4, { 0xE8, 0x93, 0xB5 },
	0xCEC5, { 0xE4, 0x94, 0x9A },
	0xCEC6, { 0xE8, 0x94, 0x84 },
	0xCEC7, { 0xE4, 0x94, 0x99 },
	0xCEC8, { 0xE4, 0x94, 0xA1 },
	0xCEC9, { 0xE4, 0x94, 0xA3 },
	0xCECA, { 0xE4, 0x94, 0x9F },
	0xCECB, { 0xE8, 0x94, 0x9B },
	0xCECC, { 0xE8, 0x94, 0x83 },
	0xCECD, { 0xE8, 0x94, 0xB3 },
	0xCECE, { 0xE8, 0x94, 0xB4 },
	0xCECF, { 0xE8, 0x93, 0xAD },
	0xCED0, { 0xE4, 0x94, 0xA5 },
	0xCED1, { 0xE4, 0x94, 0xAB },
	0xCED2, { 0xE8, 0x94, 0xB5 },
	0xCED3, { 0xE4, 0x94, 0x96 },
	0xCED4, { 0xE8, 0x94, 0x85 },
	0xCED5, { 0xE4, 0x94, 0xA2 },
	0xCED6, { 0xE4, 0x94, 0x9B },
	0xCED7, { 0xE4, 0x97, 0x8E },
	0xCED8, { 0xE4, 0x97, 0x8F },
	0xCED9, { 0xE8, 0x9D, 0xBD },
	0xCEDA, { 0xE4, 0x97, 0x8B },
	0xCEDB, { 0xE4, 0x97, 0x91 },
	0xCEDC, { 0xE4, 0x97, 0x8C },
	0xCEDD, { 0xE8, 0x9D, 0xB1 },
	0xCEDE, { 0xE4, 0x98, 0x97 },
	0xCEDF, { 0xE8, 0xA1, 0x9C },
	0xCEE0, { 0xE8, 0xA3, 0xA6 },
	0xCEE1, { 0xE8, 0xA4, 0x8F },
	0xCEE2, { 0xE8, 0xA4, 0x9B },
	0xCEE3, { 0xE4, 0x99, 0x91 },
	0xCEE4, { 0xE8, 0xA6, 0xA9 },
	0xCEE5, { 0xE8, 0xA6, 0xA5 },
	0xCEE6, { 0xE8, 0xA7, 0xAE },
	0xCEE7, { 0xE8, 0xAA, 0xB1 },
	0xCEE8, { 0xE4, 0x9B, 0xAD },
	0xCEE9, { 0xE8, 0xAB, 0x8C },
	0xCEEA, { 0xE8, 0xAB, 0x8E },
	0xCEEB, { 0xE4, 0x9B, 0xB4 },
	0xCEEC, { 0xE8, 0xAA, 0xB7 },
	0xCEED, { 0xE4, 0x9B, 0xB1 },
	0xCEEE, { 0xE8, 0xAA, 0xB5 },
	0xCEEF, { 0xE8, 0xAB, 0xA9 },
	0xCEF0, { 0xE8, 0xAA, 0xB4 },
	0xCEF1, { 0xE4, 0x9B, 0xB8 },
	0xCEF2, { 0xE8, 0xAA, 0xB3 },
	0xCEF3, { 0xE8, 0xAB, 0x81 },
	0xCEF4, { 0xE8, 0xAA, 0xAF },
	0xCEF5, { 0xE8, 0xAB, 0x8A },
	0xCEF6, { 0xE8, 0xAB, 0x90 },
	0xCEF7, { 0xE4, 0x9C, 0xAF },
	0xCEF8, { 0xE4, 0x9D, 0x9E },
	0xCEF9, { 0xE4, 0x9D, 0x9D },
	0xCEFA, { 0xE8, 0xB2, 0x8E },
	0xCEFB, { 0xE4, 0x9D, 0xB6 },
	0xCEFC, { 0xE4, 0x9D, 0xB7 },
	0xCEFD, { 0xE8, 0xB3, 0xA9 },
	0xCEFE, { 0xE8, 0xB3, 0x9B },
	0xCFA1, { 0xE4, 0x9D, 0xBE },
	0xCFA2, { 0xE8, 0xB3, 0xAB },
	0xCFA3, { 0xE8, 0xB6, 0xA4 },
	0xCFA4, { 0xE4, 0x9E, 0xB6 },
	0xCFA5, { 0xE8, 0xB6, 0xA2 },
	0xCFA6, { 0xE8, 0xB6, 0x9D },
	0xCFA7, { 0xE4, 0x9E, 0xB3 },
	0xCFA8, { 0xE4, 0x9F, 0xBC },
	0xCFA9, { 0xE4, 0xA0, 0x83 },
	0xCFAA, { 0xE4, 0xA0, 0x80 },
	0xCFAB, { 0xE8, 0xB8, 0xAA },
	0xCFAC, { 0xE8, 0xB8, 0xA8 },
	0xCFAD, { 0xE4, 0xA0, 0x8A },
	0xCFAE, { 0xE4, 0xA0, 0x82 },
	0xCFAF, { 0xE8, 0xBA, 0xB8 },
	0xCFB0, { 0xE8, 0xBA, 0xB6 },
	0xCFB1, { 0xE8, 0xBA, 0xB9 },
	0xCFB2, { 0xE8, 0xBA, 0xB7 },
	0xCFB3, { 0xE8, 0xBC, 0xA2 },
	0xCFB4, { 0xE8, 0xBC, 0xAB },
	0xCFB5, { 0xE8, 0xBC, 0xA7 },
	0xCFB6, { 0xE8, 0xBC, 0x99 },
	0xCFB7, { 0xE8, 0xBE, 0xA4 },
	0xCFB8, { 0xE4, 0xA2, 0x87 },
	0xCFB9, { 0xE8, 0xBE, 0xB3 },
	0xCFBA, { 0xE4, 0xA2, 0xA6 },
	0xCFBB, { 0xE9, 0x81, 0xB1 },
	0xCFBC, { 0xE9, 0x81, 0xAA },
	0xCFBD, { 0xE4, 0xA2, 0xA9 },
	0xCFBE, { 0xE4, 0xA3, 0x9E },
	0xCFBF, { 0xE9, 0x86, 0x88 },
	0xCFC0, { 0xE9, 0x86, 0x8C },
	0xCFC1, { 0xE9, 0x8A, 0xBF },
	0xCFC2, { 0xE9, 0x8A, 0xB8 },
	0xCFC3, { 0xE9, 0x8A, 0xBE },
	0xCFC4, { 0xE9, 0x8B, 0x9C },
	0xCFC5, { 0xE9, 0x8B, 0xA5 },
	0xCFC6, { 0xE4, 0xA4, 0xAE },
	0xCFC7, { 0xE4, 0xA4, 0xAD },
	0xCFC8, { 0xE9, 0x8B, 0x94 },
	0xCFC9, { 0xE9, 0x8B, 0x96 },
	0xCFCA, { 0xE4, 0xA4, 0xB0 },
	0xCFCB, { 0xE9, 0x8B, 0x9A },
	0xCFCC, { 0xE9, 0x8B, 0xAD },
	0xCFCD, { 0xE9, 0x8B, 0xB3 },
	0xCFCE, { 0xE9, 0x8B, 0x9B },
	0xCFCF, { 0xE4, 0xA4, 0xAB },
	0xCFD0, { 0xE9, 0x8A, 0xB9 },
	0xCFD1, { 0xE9, 0x8B, 0xA2 },
	0xCFD2, { 0xE9, 0x8B, 0xAB },
	0xCFD3, { 0xE9, 0x96, 0xAF },
	0xCFD4, { 0xE4, 0xA6, 0x9E },
	0xCFD5, { 0xE9, 0x96, 0xB2 },
	0xCFD6, { 0xE9, 0x96, 0xB3 },
	0xCFD7, { 0xE4, 0xA6, 0x9F },
	0xCFD8, { 0xE4, 0xA7, 0xA5 },
	0xCFD9, { 0xE4, 0xA7, 0xA4 },
	0xCFDA, { 0xE9, 0x9A, 0xA3 },
	0xCFDB, { 0xE9, 0x9A, 0xA5 },
	0xCFDC, { 0xE4, 0xA7, 0xBD },
	0xCFDD, { 0xE4, 0xA7, 0xBC },
	0xCFDE, { 0xE4, 0xA8, 0x97 },
	0xCFDF, { 0xE4, 0xA8, 0x99 },
	0xCFE0, { 0xE9, 0x9C, 0x8A },
	0xCFE1, { 0xE4, 0xA8, 0x98 },
	0xCFE2, { 0xE9, 0x9E, 0x87 },
	0xCFE3, { 0xE9, 0x9E, 0x89 },
	0xCFE4, { 0xE9, 0x9E, 0x8C },
	0xCFE5, { 0xE9, 0x9F, 0xAF },
	0xCFE6, { 0xE9, 0xA0, 0xAA },
	0xCFE7, { 0xE9, 0xA0, 0xA2 },
	0xCFE8, { 0xE4, 0xAA, 0xBF },
	0xCFE9, { 0xE9, 0xA0, 0x9F },
	0xCFEA, { 0xE4, 0xAC, 0xBC },
	0xCFEB, { 0xE9, 0xA4, 0x99 },
	0xCFEC, { 0xE4, 0xAD, 0xAB },
	0xCFED, { 0xE9, 0xA7, 0x8A },
	0xCFEE, { 0xE9, 0xA7, 0x9A },
	0xCFEF, { 0xE4, 0xAE, 0x83 },
	0xCFF0, { 0xE4, 0xAE, 0x81 },
	0xCFF1, { 0xE4, 0xAE, 0x80 },
	0xCFF2, { 0xE9, 0xA7, 0x9E },
	0xCFF3, { 0xE9, 0xA7, 0x88 },
	0xCFF4, { 0xE9, 0xA7, 0xA0 },
	0xCFF5, { 0xE4, 0xAF, 0x8A },
	0xCFF6, { 0xE9, 0xAA, 0xB6 },
	0xCFF7, { 0xE9, 0xAA, 0xB5 },
	0xCFF8, { 0xE4, 0xAF, 0x8E },
	0xCFF9, { 0xE9, 0xAB, 0xB4 },
	0xCFFA, { 0xE4, 0xAF, 0xB6 },
	0xCFFB, { 0xE9, 0xAD, 0xAB },
	0xCFFC, { 0xE9, 0xAD, 0xA9 },
	0xCFFD, { 0xE9, 0xAD, 0xB2 },
	0xCFFE, { 0xE9, 0xAD, 0xA3 },
	0xD0A1, { 0xE4, 0xB0, 0xB9 },
	0xD0A2, { 0xE9, 0xB4, 0x8D },
	0xD0A3, { 0xE4, 0xB2, 0xAE },
	0xD0A4, { 0xE9, 0xB4, 0x81 },
	0xD0A5, { 0xE9, 0xB4, 0x8C },
	0xD0A6, { 0xE4, 0xB2, 0xB5 },
	0xD0A7, { 0xE9, 0xB3, 0xB8 },
	0xD0A8, { 0xE4, 0xB2, 0xB3 },
	0xD0A9, { 0xE4, 0xB2, 0xB4 },
	0xD0AA, { 0xE9, 0xB3, 0xBE },
	0xD0AB, { 0xE9, 0xB4, 0x82 },
	0xD0AC, { 0xE9, 0xBA, 0x84 },
	0xD0AD, { 0xE4, 0xB4, 0xA2 },
	0xD0AE, { 0xE9, 0xBA, 0xAB },
	0xD0AF, { 0xE9, 0xBA, 0xAA },
	0xD0B0, { 0xE5, 0x84, 0x9D },
	0xD0B1, { 0xE5, 0x84, 0x96 },
	0xD0B2, { 0xE3, 0x92, 0x99 },
	0xD0B3, { 0xE5, 0x84, 0xAB },
	0xD0B4, { 0xE5, 0x84, 0x9E },
	0xD0B5, { 0xE5, 0x84, 0x9B },
	0xD0B6, { 0xE5, 0x8A, 0x90 },
	0xD0B7, { 0xE5, 0x8A, 0x94 },
	0xD0B8, { 0xE5, 0x8C, 0x94 },
	0xD0B9, { 0xF0, 0xA0, 0xAE, 0x89 },
	0xD0BA, { 0xE3, 0x98, 0x82 },
	0xD0BB, { 0xE5, 0x99, 0xA7 },
	0xD0BC, { 0xE3, 0x98, 0x81 },
	0xD0BD, { 0xE5, 0x99, 0xBB },
	0xD0BE, { 0xE3, 0x9A, 0xA1 },
	0xD0BF, { 0xE5, 0x99, 0x9F },
	0xD0C0, { 0xE5, 0x99, 0xA1 },
	0xD0C1, { 0xE3, 0x97, 0xBD },
	0xD0C2, { 0xE3, 0x99, 0xB3 },
	0xD0C3, { 0xE3, 0x99, 0xB4 },
	0xD0C4, { 0xE3, 0x99, 0xB0 },
	0xD0C5, { 0xE3, 0x99, 0xB6 },
	0xD0C6, { 0xE3, 0x99, 0xB5 },
	0xD0C7, { 0xE3, 0x99, 0xB2 },
	0xD0C8, { 0xE5, 0xA3, 0x83 },
	0xD0C9, { 0xE5, 0xA3, 0x8A },
	0xD0CA, { 0xE5, 0xA2, 0xBB },
	0xD0CB, { 0xE5, 0xA3, 0x80 },
	0xD0CC, { 0xE5, 0xA3, 0x84 },
	0xD0CD, { 0xE5, 0xA4, 0x81 },
	0xD0CE, { 0xE5, 0xAC, 0x9F },
	0xD0CF, { 0xE5, 0xAC, 0x98 },
	0xD0D0, { 0xE5, 0xAC, 0x91 },
	0xD0D1, { 0xE5, 0xAC, 0x95 },
	0xD0D2, { 0xE3, 0x9C, 0xA9 },
	0xD0D3, { 0xE5, 0xAC, 0x92 },
	0xD0D4, { 0xE5, 0xAC, 0x9C },
	0xD0D5, { 0xE3, 0x9C, 0xAA },
	0xD0D6, { 0xE5, 0xAC, 0xA2 },
	0xD0D7, { 0xE5, 0xAD, 0xB9 },
	0xD0D8, { 0xE5, 0xB6, 0xA6 },
	0xD0D9, { 0xE3, 0xA0, 0x96 },
	0xD0DA, { 0xE5, 0xB6, 0xB3 },
	0xD0DB, { 0xE5, 0xB6, 0xAB },
	0xD0DC, { 0xE5, 0xBB, 0xAA },
	0xD0DD, { 0xE3, 0xA2, 0x99 },
	0xD0DE, { 0xE5, 0xBD, 0x9B },
	0xD0DF, { 0xE3, 0xA3, 0x93 },
	0xD0E0, { 0xE3, 0xA3, 0xB5 },
	0xD0E1, { 0xE6, 0x86, 0xB7 },
	0xD0E2, { 0xE6, 0x87, 0x8E },
	0xD0E3, { 0xE6, 0x86, 0xB9 },
	0xD0E4, { 0xE6, 0x86, 0xBD },
	0xD0E5, { 0xE6, 0x87, 0x8F },
	0xD0E6, { 0xE6, 0x87, 0x80 },
	0xD0E7, { 0xE6, 0x86, 0x99 },
	0xD0E8, { 0xE6, 0x86, 0x97 },
	0xD0E9, { 0xE3, 0xA6, 0x94 },
	0xD0EA, { 0xE6, 0x86, 0xBB },
	0xD0EB, { 0xE6, 0x87, 0x90 },
	0xD0EC, { 0xE6, 0x87, 0x84 },
	0xD0ED, { 0xE6, 0x88, 0xB1 },
	0xD0EE, { 0xE3, 0xA9, 0x96 },
	0xD0EF, { 0xE6, 0x93, 0x93 },
	0xD0F0, { 0xE6, 0x93, 0x80 },
	0xD0F1, { 0xE3, 0xA9, 0x99 },
	0xD0F2, { 0xE3, 0xA9, 0x98 },
	0xD0F3, { 0xE3, 0xA9, 0x95 },
	0xD0F4, { 0xE3, 0xA9, 0x92 },
	0xD0F5, { 0xE6, 0x93, 0x9C },
	0xD0F6, { 0xE6, 0x93, 0x91 },
	0xD0F7, { 0xE6, 0x93, 0x88 },
	0xD0F8, { 0xE3, 0xA9, 0x97 },
	0xD0F9, { 0xE6, 0x93, 0x95 },
	0xD0FA, { 0xE6, 0x9B, 0x83 },
	0xD0FB, { 0xE3, 0xAC, 0x9B },
	0xD0FC, { 0xE3, 0xAC, 0x9C },
	0xD0FD, { 0xE6, 0x9A, 0xBF },
	0xD0FE, { 0xE6, 0x9B, 0x85 },
	0xD1A1, { 0xE3, 0xAC, 0x99 },
	0xD1A2, { 0xE6, 0x9B, 0x8D },
	0xD1A3, { 0xE6, 0x9B, 0x81 },
	0xD1A4, { 0xE6, 0x9C, 0x86 },
	0xD1A5, { 0xE3, 0xAC, 0xBF },
	0xD1A6, { 0xE6, 0x9C, 0xA4 },
	0xD1A7, { 0xE6, 0xA9, 0xA3 },
	0xD1A8, { 0xE6, 0xA9, 0x82 },
	0xD1A9, { 0xE6, 0xA9, 0x92 },
	0xD1AA, { 0xE3, 0xAF, 0x9B },
	0xD1AB, { 0xE6, 0xA9, 0x83 },
	0xD1AC, { 0xE6, 0xA8, 0xB3 },
	0xD1AD, { 0xE3, 0xAF, 0xA2 },
	0xD1AE, { 0xE6, 0xA9, 0xAC },
	0xD1AF, { 0xE6, 0xA9, 0x97 },
	0xD1B0, { 0xE3, 0xAF, 0x97 },
	0xD1B1, { 0xE6, 0xA9, 0x8C },
	0xD1B2, { 0xE6, 0xA9, 0xAE },
	0xD1B3, { 0xE3, 0xAF, 0x9E },
	0xD1B4, { 0xE3, 0xAF, 0xA5 },
	0xD1B5, { 0xE3, 0xAF, 0xA4 },
	0xD1B6, { 0xE3, 0xAF, 0xA6 },
	0xD1B7, { 0xE3, 0xAF, 0x96 },
	0xD1B8, { 0xE6, 0xA8, 0xB7 },
	0xD1B9, { 0xE3, 0xAF, 0x9F },
	0xD1BA, { 0xE6, 0xA9, 0xB1 },
	0xD1BB, { 0xE6, 0xA9, 0x8A },
	0xD1BC, { 0xE6, 0xA8, 0xB6 },
	0xD1BD, { 0xE3, 0xAF, 0x9C },
	0xD1BE, { 0xE6, 0xA9, 0x93 },
	0xD1BF, { 0xE3, 0xAF, 0x9A },
	0xD1C0, { 0xE6, 0xA9, 0x85 },
	0xD1C1, { 0xE6, 0xA9, 0xB0 },
	0xD1C2, { 0xE3, 0xAF, 0x93 },
	0xD1C3, { 0xE3, 0xAF, 0x90 },
	0xD1C4, { 0xE6, 0xA9, 0x9C },
	0xD1C5, { 0xE6, 0xAD, 0x98 },
	0xD1C6, { 0xE6, 0xAD, 0x97 },
	0xD1C7, { 0xE3, 0xB2, 0x86 },
	0xD1C8, { 0xE3, 0xB2, 0x87 },
	0xD1C9, { 0xE3, 0xB2, 0xAD },
	0xD1CA, { 0xE3, 0xB2, 0xB7 },
	0xD1CB, { 0xE3, 0xB5, 0x98 },
	0xD1CC, { 0xE3, 0xB5, 0xAA },
	0xD1CD, { 0xE6, 0xBE, 0xBB },
	0xD1CE, { 0xE3, 0xB5, 0xA2 },
	0xD1CF, { 0xE3, 0xB5, 0xA1 },
	0xD1D0, { 0xE6, 0xBE, 0xBE },
	0xD1D1, { 0xE3, 0xB5, 0xA9 },
	0xD1D2, { 0xE3, 0xB5, 0xAC },
	0xD1D3, { 0xE3, 0xB5, 0xA5 },
	0xD1D4, { 0xE6, 0xBE, 0xB5 },
	0xD1D5, { 0xE6, 0xBF, 0x93 },
	0xD1D6, { 0xE6, 0xBE, 0x9F },
	0xD1D7, { 0xE3, 0xB5, 0xA6 },
	0xD1D8, { 0xE6, 0xBE, 0xB7 },
	0xD1D9, { 0xE6, 0xBF, 0xB5 },
	0xD1DA, { 0xE7, 0x86, 0xB7 },
	0xD1DB, { 0xE3, 0xB7, 0xB5 },
	0xD1DC, { 0xE7, 0x86, 0xBB },
	0xD1DD, { 0xE3, 0xB7, 0xB4 },
	0xD1DE, { 0xE7, 0x87, 0x91 },
	0xD1DF, { 0xE3, 0xB7, 0xB7 },
	0xD1E0, { 0xE7, 0x86, 0xBA },
	0xD1E1, { 0xE3, 0xB7, 0xB8 },
	0xD1E2, { 0xE7, 0x86, 0xB6 },
	0xD1E3, { 0xE7, 0x87, 0x8C },
	0xD1E4, { 0xE3, 0xB7, 0xBB },
	0xD1E5, { 0xE3, 0xB7, 0xBC },
	0xD1E6, { 0xE7, 0x87, 0x93 },
	0xD1E7, { 0xE7, 0x92, 0x9B },
	0xD1E8, { 0xE3, 0xBB, 0xB5 },
	0xD1E9, { 0xE3, 0xBB, 0xB8 },
	0xD1EA, { 0xE7, 0x92, 0x96 },
	0xD1EB, { 0xE7, 0x92, 0xA2 },
	0xD1EC, { 0xE7, 0x92, 0x9D },
	0xD1ED, { 0xE7, 0x94, 0x8A },
	0xD1EE, { 0xE7, 0x94, 0x8E },
	0xD1EF, { 0xE3, 0xBC, 0xBC },
	0xD1F0, { 0xE7, 0x96, 0x81 },
	0xD1F1, { 0xE7, 0x98, 0xAC },
	0xD1F2, { 0xE7, 0x98, 0xB7 },
	0xD1F3, { 0xE7, 0x98, 0xB6 },
	0xD1F4, { 0xE7, 0x98, 0xBB },
	0xD1F5, { 0xE3, 0xBF, 0x85 },
	0xD1F6, { 0xE7, 0x9A, 0xA1 },
	0xD1F7, { 0xE4, 0x81, 0xA2 },
	0xD1F8, { 0xE4, 0x81, 0xA3 },
	0xD1F9, { 0xE7, 0x9E, 0x98 },
	0xD1FA, { 0xE4, 0x81, 0xA7 },
	0xD1FB, { 0xE7, 0x9E, 0x96 },
	0xD1FC, { 0xE4, 0x81, 0xA6 },
	0xD1FD, { 0xE4, 0x83, 0x99 },
	0xD1FE, { 0xE4, 0x83, 0x9B },
	0xD2A1, { 0xE7, 0xA3, 0x96 },
	0xD2A2, { 0xE7, 0xA3, 0xAB },
	0xD2A3, { 0xE4, 0x83, 0x98 },
	0xD2A4, { 0xE7, 0xA3, 0x9C },
	0xD2A5, { 0xE4, 0x84, 0x9B },
	0xD2A6, { 0xE7, 0xA6, 0xA5 },
	0xD2A7, { 0xE7, 0xA6, 0xA9 },
	0xD2A8, { 0xE9, 0xA0, 0xB4 },
	0xD2A9, { 0xE7, 0xA9, 0x93 },
	0xD2AA, { 0xE7, 0xA9, 0x85 },
	0xD2AB, { 0xE4, 0x85, 0xB9 },
	0xD2AC, { 0xE7, 0xA9, 0x8F },
	0xD2AD, { 0xE4, 0x85, 0xBD },
	0xD2AE, { 0xE7, 0xAA, 0xBD },
	0xD2AF, { 0xE7, 0xAA, 0xBB },
	0xD2B0, { 0xE7, 0xAB, 0xB1 },
	0xD2B1, { 0xE4, 0x88, 0xAC },
	0xD2B2, { 0xE4, 0x88, 0xB7 },
	0xD2B3, { 0xE7, 0xAF, 0xAC },
	0xD2B4, { 0xE7, 0xAF, 0xAD },
	0xD2B5, { 0xE4, 0x88, 0xB0 },
	0xD2B6, { 0xE4, 0x8A, 0x9A },
	0xD2B7, { 0xE7, 0xB3, 0x93 },
	0xD2B8, { 0xE4, 0xA8, 0x80 },
	0xD2B9, { 0xE7, 0xB3, 0xA1 },
	0xD2BA, { 0xE4, 0x8C, 0x85 },
	0xD2BB, { 0xE7, 0xB8, 0x99 },
	0xD2BC, { 0xE4, 0x8C, 0x87 },
	0xD2BD, { 0xE4, 0x8C, 0x89 },
	0xD2BE, { 0xE4, 0x8C, 0x8A },
	0xD2BF, { 0xE7, 0xB8, 0xA7 },
	0xD2C0, { 0xE7, 0xB8, 0xA6 },
	0xD2C1, { 0xE4, 0x8D, 0xB9 },
	0xD2C2, { 0xE4, 0x8F, 0x82 },
	0xD2C3, { 0xE8, 0x81, 0xAE },
	0xD2C4, { 0xE8, 0x86, 0xAF },
	0xD2C5, { 0xE4, 0x90, 0xB8 },
	0xD2C6, { 0xE4, 0x90, 0xB7 },
	0xD2C7, { 0xE8, 0x86, 0xAD },
	0xD2C8, { 0xE4, 0x90, 0xA1 },
	0xD2C9, { 0xE8, 0x86, 0xAA },
	0xD2CA, { 0xE8, 0x88, 0x98 },
	0xD2CB, { 0xE4, 0x91, 0x9E },
	0xD2CC, { 0xE4, 0x94, 0xBD },
	0xD2CD, { 0xE4, 0x94, 0xB7 },
	0xD2CE, { 0xE4, 0x95, 0x80 },
	0xD2CF, { 0xE8, 0x95, 0xAF },
	0xD2D0, { 0xE8, 0x95, 0x8C },
	0xD2D1, { 0xE4, 0x94, 0x9D },
	0xD2D2, { 0xE8, 0x95, 0x82 },
	0xD2D3, { 0xE4, 0x94, 0xB3 },
	0xD2D4, { 0xE8, 0x95, 0x9C },
	0xD2D5, { 0xE8, 0x95, 0xB0 },
	0xD2D6, { 0xE8, 0x95, 0x9F },
	0xD2D7, { 0xE4, 0x94, 0xB5 },
	0xD2D8, { 0xE8, 0x95, 0x9A },
	0xD2D9, { 0xE8, 0x95, 0x8B },
	0xD2DA, { 0xE8, 0x94, 0xBF },
	0xD2DB, { 0xE8, 0x9E, 0x8A },
	0xD2DC, { 0xE4, 0x97, 0x98 },
	0xD2DD, { 0xE8, 0x9E, 0x8B },
	0xD2DE, { 0xE8, 0x9E, 0xA1 },
	0xD2DF, { 0xE8, 0x9E, 0x8E },
	0xD2E0, { 0xE4, 0x97, 0x9C },
	0xD2E1, { 0xE4, 0x97, 0x9E },
	0xD2E2, { 0xE8, 0x9E, 0x99 },
	0xD2E3, { 0xE8, 0xA1, 0x9E },
	0xD2E4, { 0xE8, 0xA1, 0x9F },
	0xD2E5, { 0xE8, 0xA4, 0xA4 },
	0xD2E6, { 0xE8, 0xA6, 0xA7 },
	0xD2E7, { 0xE8, 0xAB, 0xAA },
	0xD2E8, { 0xE8, 0xAB, 0xBD },
	0xD2E9, { 0xE8, 0xAB, 0xB9 },
	0xD2EA, { 0xE8, 0xAB, 0xA3 },
	0xD2EB, { 0xE8, 0xAB, 0xA5 },
	0xD2EC, { 0xE4, 0x9B, 0xBA },
	0xD2ED, { 0xE4, 0x9B, 0xBB },
	0xD2EE, { 0xE8, 0xAB, 0xAC },
	0xD2EF, { 0xE4, 0x9C, 0xBD },
	0xD2F0, { 0xE4, 0x9C, 0xBB },
	0xD2F1, { 0xE4, 0x9C, 0xBF },
	0xD2F2, { 0xE4, 0x9D, 0x9F },
	0xD2F3, { 0xE8, 0xB3, 0xB2 },
	0xD2F4, { 0xE4, 0x9D, 0xBF },
	0xD2F5, { 0xE8, 0xB3, 0xAF },
	0xD2F6, { 0xE4, 0x9E, 0x84 },
	0xD2F7, { 0xE8, 0xB6, 0xA6 },
	0xD2F8, { 0xE4, 0x9E, 0xBC },
	0xD2F9, { 0xE4, 0xA0, 0x94 },
	0xD2FA, { 0xE4, 0xA0, 0x8F },
	0xD2FB, { 0xE8, 0xB8, 0xBB },
	0xD2FC, { 0xE8, 0xB9, 0x83 },
	0xD2FD, { 0xE4, 0xA0, 0x8E },
	0xD2FE, { 0xE8, 0xB8, 0xB2 },
	0xD3A1, { 0xE8, 0xBC, 0xB1 },
	0xD3A2, { 0xE8, 0xBC, 0xB0 },
	0xD3A3, { 0xE4, 0xA1, 0xA0 },
	0xD3A4, { 0xE8, 0xBC, 0xAD },
	0xD3A5, { 0xE8, 0xBC, 0xBC },
	0xD3A6, { 0xE8, 0xBE, 0xA7 },
	0xD3A7, { 0xE8, 0xBE, 0xA5 },
	0xD3A8, { 0xE4, 0xA2, 0xAB },
	0xD3A9, { 0xE4, 0xA2, 0xAC },
	0xD3AA, { 0xE4, 0xA2, 0xAA },
	0xD3AB, { 0xE9, 0x84, 0xB7 },
	0xD3AC, { 0xE9, 0x86, 0x95 },
	0xD3AD, { 0xE9, 0x86, 0x8E },
	0xD3AE, { 0xE4, 0xA4, 0x84 },
	0xD3AF, { 0xE9, 0x86, 0x96 },
	0xD3B0, { 0xE4, 0xA4, 0x88 },
	0xD3B1, { 0xE9, 0x8D, 0x85 },
	0xD3B2, { 0xE9, 0x8C, 0x8A },
	0xD3B3, { 0xE4, 0xA4, 0xB3 },
	0xD3B4, { 0xE4, 0xA4, 0xB4 },
	0xD3B5, { 0xE9, 0x8B, 0xBD },
	0xD3B6, { 0xE9, 0x8C, 0x97 },
	0xD3B7, { 0xE9, 0x8C, 0x9C },
	0xD3B8, { 0xE9, 0x8C, 0x87 },
	0xD3B9, { 0xE9, 0x8C, 0xB1 },
	0xD3BA, { 0xE9, 0x8C, 0xB2 },
	0xD3BB, { 0xE9, 0x8C, 0xAC },
	0xD3BC, { 0xE9, 0x8C, 0xB0 },
	0xD3BD, { 0xE9, 0x8C, 0x83 },
	0xD3BE, { 0xE9, 0x8C, 0x85 },
	0xD3BF, { 0xE4, 0xA6, 0xA2 },
	0xD3C0, { 0xE9, 0x97, 0x82 },
	0xD3C1, { 0xE4, 0xA6, 0xA4 },
	0xD3C2, { 0xE9, 0x96, 0xB8 },
	0xD3C3, { 0xE4, 0xA6, 0xA5 },
	0xD3C4, { 0xE9, 0x97, 0x81 },
	0xD3C5, { 0xE4, 0xA6, 0xA7 },
	0xD3C6, { 0xE4, 0xA6, 0xA6 },
	0xD3C7, { 0xE4, 0xA7, 0xA7 },
	0xD3C8, { 0xE9, 0x9A, 0xAB },
	0xD3C9, { 0xE9, 0x9A, 0xB7 },
	0xD3CA, { 0xE4, 0xA7, 0xBF },
	0xD3CB, { 0xE4, 0xA7, 0xBE },
	0xD3CC, { 0xE9, 0x9C, 0x95 },
	0xD3CD, { 0xE9, 0x9C, 0x94 },
	0xD3CE, { 0xE4, 0xA8, 0x9D },
	0xD3CF, { 0xE4, 0xA8, 0x9C },
	0xD3D0, { 0xE9, 0x9C, 0x8C },
	0xD3D1, { 0xE9, 0x9C, 0x97 },
	0xD3D2, { 0xE4, 0xA9, 0xA7 },
	0xD3D3, { 0xE9, 0x9E, 0x93 },
	0xD3D4, { 0xE4, 0xAA, 0x94 },
	0xD3D5, { 0xE9, 0x9F, 0x92 },
	0xD3D6, { 0xE4, 0xAB, 0x85 },
	0xD3D7, { 0xE4, 0xAB, 0x88 },
	0xD3D8, { 0xE9, 0xA0, 0xB6 },
	0xD3D9, { 0xE9, 0xA0, 0xB1 },
	0xD3DA, { 0xE9, 0xA0, 0xB3 },
	0xD3DB, { 0xE9, 0xA0, 0xBC },
	0xD3DC, { 0xE9, 0xA0, 0xAE },
	0xD3DD, { 0xE9, 0xA0, 0xBA },
	0xD3DE, { 0xE4, 0xAB, 0x89 },
	0xD3DF, { 0xE9, 0xA0, 0xBD },
	0xD3E0, { 0xE4, 0xAB, 0x87 },
	0xD3E1, { 0xE9, 0xA2, 0xB5 },
	0xD3E2, { 0xE9, 0xA4, 0xA2 },
	0xD3E3, { 0xE9, 0xA4, 0xA3 },
	0xD3E4, { 0xE9, 0xA4, 0xA0 },
	0xD3E5, { 0xE9, 0xA4, 0x9C },
	0xD3E6, { 0xE9, 0xA4, 0x9D },
	0xD3E7, { 0xE4, 0xAD, 0xAC },
	0xD3E8, { 0xE9, 0xA6, 0xA0 },
	0xD3E9, { 0xE4, 0xAE, 0x8A },
	0xD3EA, { 0xE9, 0xA7, 0xAF },
	0xD3EB, { 0xE9, 0xA7, 0xA8 },
	0xD3EC, { 0xE9, 0xA7, 0xAB },
	0xD3ED, { 0xE4, 0xAE, 0x88 },
	0xD3EE, { 0xE4, 0xAE, 0x87 },
	0xD3EF, { 0xE4, 0xAE, 0x86 },
	0xD3F0, { 0xE9, 0xA7, 0xA1 },
	0xD3F1, { 0xE9, 0xA7, 0xA6 },
	0xD3F2, { 0xE4, 0xAF, 0x8F },
	0xD3F3, { 0xE4, 0xAF, 0x90 },
	0xD3F4, { 0xE9, 0xAB, 0xB8 },
	0xD3F5, { 0xE9, 0xAB, 0xB5 },
	0xD3F6, { 0xE4, 0xB0, 0x9C },
	0xD3F7, { 0xE4, 0xB0, 0xA3 },
	0xD3F8, { 0xE9, 0xAE, 0x83 },
	0xD3F9, { 0xE9, 0xAE, 0x94 },
	0xD3FA, { 0xE9, 0xAE, 0x84 },
	0xD3FB, { 0xE4, 0xB1, 0x89 },
	0xD3FC, { 0xE9, 0xAE, 0x8B },
	0xD3FD, { 0xE9, 0xAE, 0x8F },
	0xD3FE, { 0xE4, 0xB1, 0x83 },
	0xD4A1, { 0xE9, 0xAE, 0x8C },
	0xD4A2, { 0xE4, 0xB1, 0x88 },
	0xD4A3, { 0xE9, 0xAE, 0x89 },
	0xD4A4, { 0xE4, 0xB1, 0x87 },
	0xD4A5, { 0xE9, 0xAE, 0x8E },
	0xD4A6, { 0xE4, 0xB1, 0x86 },
	0xD4A7, { 0xE4, 0xB0, 0xBF },
	0xD4A8, { 0xE4, 0xB1, 0x84 },
	0xD4A9, { 0xE9, 0xB4, 0xA4 },
	0xD4AA, { 0xE9, 0xB4, 0x8F },
	0xD4AB, { 0xE4, 0xB2, 0xBE },
	0xD4AC, { 0xE9, 0xB4, 0x93 },
	0xD4AD, { 0xE9, 0xB4, 0x8A },
	0xD4AE, { 0xE4, 0xB3, 0x82 },
	0xD4AF, { 0xE4, 0xB2, 0xBA },
	0xD4B0, { 0xE4, 0xB2, 0xBC },
	0xD4B1, { 0xE4, 0xB3, 0x86 },
	0xD4B2, { 0xE9, 0xB4, 0xAA },
	0xD4B3, { 0xE9, 0xB4, 0x9A },
	0xD4B4, { 0xE4, 0xB3, 0x88 },
	0xD4B5, { 0xE9, 0xB4, 0xA7 },
	0xD4B6, { 0xE9, 0xB4, 0x96 },
	0xD4B7, { 0xE9, 0xB4, 0xA1 },
	0xD4B8, { 0xE4, 0xB4, 0xA3 },
	0xD4B9, { 0xE9, 0xBA, 0x85 },
	0xD4BA, { 0xE9, 0xBA, 0xAC },
	0xD4BB, { 0xE9, 0xBB, 0x86 },
	0xD4BC, { 0xE9, 0xBB, 0x85 },
	0xD4BD, { 0xE9, 0xBB, 0x97 },
	0xD4BE, { 0xE9, 0xBD, 0x93 },
	0xD4BF, { 0xE3, 0x92, 0x9D },
	0xD4C0, { 0xE5, 0x84, 0xA8 },
	0xD4C1, { 0xE5, 0x84, 0xA7 },
	0xD4C2, { 0xE5, 0x87, 0x9F },
	0xD4C3, { 0xE3, 0x94, 0xA4 },
	0xD4C4, { 0xE5, 0x8C, 0xB5 },
	0xD4C5, { 0xE5, 0x8E, 0xB3 },
	0xD4C6, { 0xE3, 0x98, 0x87 },
	0xD4C7, { 0xE5, 0x9A, 0x8A },
	0xD4C8, { 0xE5, 0x99, 0xBD },
	0xD4C9, { 0xE5, 0x9A, 0x89 },
	0xD4CA, { 0xE3, 0x99, 0xB9 },
	0xD4CB, { 0xE5, 0xA3, 0x8D },
	0xD4CC, { 0xE5, 0xA3, 0x90 },
	0xD4CD, { 0xE3, 0x99, 0xB8 },
	0xD4CE, { 0xE5, 0xAC, 0xAB },
	0xD4CF, { 0xE5, 0xAC, 0xB3 },
	0xD4D0, { 0xE5, 0xAC, 0xA9 },
	0xD4D1, { 0xE5, 0xAC, 0xB5 },
	0xD4D2, { 0xE5, 0xAC, 0xB1 },
	0xD4D3, { 0xE5, 0xAC, 0xB7 },
	0xD4D4, { 0xE5, 0xB0, 0xB6 },
	0xD4D5, { 0xE5, 0xB6, 0xBE },
	0xD4D6, { 0xE3, 0xA0, 0x99 },
	0xD4D7, { 0xE5, 0xB6, 0xB9 },
	0xD4D8, { 0xE3, 0xA0, 0x9C },
	0xD4D9, { 0xE5, 0xB6, 0xBB },
	0xD4DA, { 0xE3, 0xA0, 0x98 },
	0xD4DB, { 0xE6, 0x87, 0xA2 },
	0xD4DC, { 0xE6, 0x87, 0x9B },
	0xD4DD, { 0xE6, 0x87, 0x9D },
	0xD4DE, { 0xE6, 0x87, 0x9C },
	0xD4DF, { 0xE6, 0x87, 0x9A },
	0xD4E0, { 0xF0, 0xAF, 0xA2, 0xAF },
	0xD4E1, { 0xE6, 0x87, 0x99 },
	0xD4E2, { 0xE3, 0xA6, 0xBD },
	0xD4E3, { 0xE3, 0xA9, 0x9D },
	0xD4E4, { 0xE6, 0x93, 0x9F },
	0xD4E5, { 0xE3, 0xA9, 0x9A },
	0xD4E6, { 0xE3, 0xA9, 0x9E },
	0xD4E7, { 0xE6, 0x93, 0xA1 },
	0xD4E8, { 0xE3, 0xA9, 0x9C },
	0xD4E9, { 0xE6, 0x93, 0xAE },
	0xD4EA, { 0xE3, 0xA9, 0x9B },
	0xD4EB, { 0xE6, 0x96, 0xB5 },
	0xD4EC, { 0xE6, 0x9B, 0x94 },
	0xD4ED, { 0xE6, 0x9B, 0x95 },
	0xD4EE, { 0xE3, 0xAC, 0xA1 },
	0xD4EF, { 0xE6, 0x9B, 0x90 },
	0xD4F0, { 0xE6, 0x9B, 0x91 },
	0xD4F1, { 0xE6, 0x9B, 0x8E },
	0xD4F2, { 0xE6, 0x9B, 0x97 },
	0xD4F3, { 0xE3, 0xAC, 0xA0 },
	0xD4F4, { 0xE3, 0xAC, 0xB2 },
	0xD4F5, { 0xE6, 0xA9, 0xBD },
	0xD4F6, { 0xE6, 0xAA, 0x8A },
	0xD4F7, { 0xE3, 0xAF, 0xB2 },
	0xD4F8, { 0xE6, 0xAA, 0xA7 },
	0xD4F9, { 0xE3, 0xAF, 0xB5 },
	0xD4FA, { 0xE6, 0xAA, 0x99 },
	0xD4FB, { 0xE6, 0xAA, 0x82 },
	0xD4FC, { 0xE6, 0xAA, 0x88 },
	0xD4FD, { 0xE3, 0xAF, 0xAE },
	0xD4FE, { 0xE3, 0xAF, 0xAC },
	0xD5A1, { 0xE6, 0xAA, 0x86 },
	0xD5A2, { 0xE3, 0xAF, 0xAA },
	0xD5A3, { 0xE6, 0xAA, 0x98 },
	0xD5A4, { 0xE6, 0xAA, 0x9D },
	0xD5A5, { 0xE3, 0xAF, 0xAD },
	0xD5A6, { 0xE3, 0xAF, 0xB3 },
	0xD5A7, { 0xE6, 0xAA, 0x8F },
	0xD5A8, { 0xE3, 0xAF, 0xB6 },
	0xD5A9, { 0xE6, 0xAA, 0xAA },
	0xD5AA, { 0xE3, 0xB1, 0x88 },
	0xD5AB, { 0xE6, 0xAD, 0x9D },
	0xD5AC, { 0xE3, 0xB1, 0x89 },
	0xD5AD, { 0xE6, 0xB0, 0x8A },
	0xD5AE, { 0xE3, 0xB5, 0xB5 },
	0xD5AF, { 0xE6, 0xBF, 0x97 },
	0xD5B0, { 0xE6, 0xBF, 0x96 },
	0xD5B1, { 0xE6, 0xBF, 0xA5 },
	0xD5B2, { 0xE3, 0xB5, 0xAF },
	0xD5B3, { 0xE3, 0xB5, 0xBB },
	0xD5B4, { 0xE3, 0xB5, 0xB3 },
	0xD5B5, { 0xE6, 0xBF, 0x99 },
	0xD5B6, { 0xE6, 0xBF, 0x9A },
	0xD5B7, { 0xE6, 0xBF, 0xAA },
	0xD5B8, { 0xE3, 0xB5, 0xB0 },
	0xD5B9, { 0xE6, 0xBF, 0xB6 },
	0xD5BA, { 0xF0, 0xA4, 0x80, 0xB9 },
	0xD5BB, { 0xE3, 0xB5, 0xB8 },
	0xD5BC, { 0xE7, 0x87, 0xA3 },
	0xD5BD, { 0xE3, 0xB7, 0xBE },
	0xD5BE, { 0xE7, 0x87, 0xA9 },
	0xD5BF, { 0xE3, 0xB8, 0x80 },
	0xD5C0, { 0xE7, 0x87, 0xAB },
	0xD5C1, { 0xE7, 0x87, 0xAF },
	0xD5C2, { 0xE7, 0x87, 0xB3 },
	0xD5C3, { 0xE7, 0x87, 0xAA },
	0xD5C4, { 0xE3, 0xB8, 0x81 },
	0xD5C5, { 0xF0, 0xAF, 0xA4, 0xA1 },
	0xD5C6, { 0xE3, 0xB9, 0x95 },
	0xD5C7, { 0xE3, 0xB9, 0x96 },
	0xD5C8, { 0xE3, 0xBA, 0x9D },
	0xD5C9, { 0xE7, 0x8D, 0xB1 },
	0xD5CA, { 0xE3, 0xBB, 0xB9 },
	0xD5CB, { 0xE7, 0x92, 0xAE },
	0xD5CC, { 0xE3, 0xBB, 0xBF },
	0xD5CD, { 0xE7, 0x92, 0xB3 },
	0xD5CE, { 0xE3, 0xBB, 0xBD },
	0xD5CF, { 0xE7, 0x92, 0xAC },
	0xD5D0, { 0xE3, 0xBD, 0x83 },
	0xD5D1, { 0xE3, 0xBD, 0x81 },
	0xD5D2, { 0xE7, 0x96, 0x83 },
	0xD5D3, { 0xE7, 0x99, 0x85 },
	0xD5D4, { 0xE7, 0x99, 0x8E },
	0xD5D5, { 0xE7, 0x99, 0x84 },
	0xD5D6, { 0xE7, 0x9A, 0xA3 },
	0xD5D7, { 0xE7, 0x9A, 0xA5 },
	0xD5D8, { 0xE7, 0x9E, 0xA6 },
	0xD5D9, { 0xE7, 0x9E, 0xA4 },
	0xD5DA, { 0xE4, 0x81, 0xAF },
	0xD5DB, { 0xE7, 0x9E, 0xA9 },
	0xD5DC, { 0xE7, 0x9E, 0xAF },
	0xD5DD, { 0xE4, 0x82, 0x8A },
	0xD5DE, { 0xE4, 0x83, 0xA5 },
	0xD5DF, { 0xE4, 0x83, 0xA6 },
	0xD5E0, { 0xE7, 0xA3, 0xB0 },
	0xD5E1, { 0xE7, 0xA3, 0xB8 },
	0xD5E2, { 0xE7, 0xA3, 0xB1 },
	0xD5E3, { 0xE4, 0x85, 0xBF },
	0xD5E4, { 0xE7, 0xA9, 0x89 },
	0xD5E5, { 0xE4, 0x86, 0xB5 },
	0xD5E6, { 0xE4, 0x86, 0xB6 },
	0xD5E7, { 0xE4, 0x86, 0xBB },
	0xD5E8, { 0xE7, 0xAB, 0x82 },
	0xD5E9, { 0xE7, 0xAB, 0xB2 },
	0xD5EA, { 0xE7, 0xAB, 0xB3 },
	0xD5EB, { 0xE7, 0xAF, 0xBA },
	0xD5EC, { 0xE4, 0x89, 0x80 },
	0xD5ED, { 0xE7, 0xAF, 0xB6 },
	0xD5EE, { 0xE7, 0xAF, 0xBC },
	0xD5EF, { 0xE7, 0xB0, 0x98 },
	0xD5F0, { 0xE7, 0xB0, 0x88 },
	0xD5F1, { 0xE7, 0xB0, 0x92 },
	0xD5F2, { 0xE4, 0x8A, 0x9D },
	0xD5F3, { 0xE4, 0x8A, 0x9C },
	0xD5F4, { 0xE7, 0xB3, 0x9B },
	0xD5F5, { 0xE7, 0xB3, 0x9A },
	0xD5F6, { 0xE4, 0x8C, 0x8F },
	0xD5F7, { 0xE4, 0x8C, 0x91 },
	0xD5F8, { 0xE4, 0x8C, 0x8D },
	0xD5F9, { 0xE7, 0xB8, 0xAC },
	0xD5FA, { 0xE7, 0xB9, 0x8D },
	0xD5FB, { 0xE4, 0x8C, 0x94 },
	0xD5FC, { 0xE4, 0x8C, 0x93 },
	0xD5FD, { 0xE7, 0xBD, 0x86 },
	0xD5FE, { 0xE7, 0xBF, 0xB6 },
	0xD6A1, { 0xE8, 0x80, 0xAB },
	0xD6A2, { 0xE8, 0x81, 0xB4 },
	0xD6A3, { 0xE8, 0x86, 0xB8 },
	0xD6A4, { 0xE8, 0x87, 0x88 },
	0xD6A5, { 0xE4, 0x92, 0x82 },
	0xD6A6, { 0xE4, 0x92, 0x83 },
	0xD6A7, { 0xE4, 0x95, 0x8D },
	0xD6A8, { 0xE8, 0x96, 0x92 },
	0xD6A9, { 0xE8, 0x96, 0x93 },
	0xD6AA, { 0xE4, 0x95, 0x8F },
	0xD6AB, { 0xE8, 0x95, 0xBF },
	0xD6AC, { 0xE8, 0x96, 0xAB },
	0xD6AD, { 0xE8, 0x96, 0x97 },
	0xD6AE, { 0xE4, 0x95, 0x8C },
	0xD6AF, { 0xE4, 0x95, 0x91 },
	0xD6B0, { 0xE8, 0x96, 0xAC },
	0xD6B1, { 0xE4, 0x97, 0xAE },
	0xD6B2, { 0xE4, 0x97, 0xA8 },
	0xD6B3, { 0xE4, 0xB3, 0x8B },
	0xD6B4, { 0xE8, 0x9F, 0x8E },
	0xD6B5, { 0xE4, 0x97, 0xAB },
	0xD6B6, { 0xE8, 0x9F, 0x8D },
	0xD6B7, { 0xE4, 0x97, 0xA2 },
	0xD6B8, { 0xE4, 0x97, 0xA6 },
	0xD6B9, { 0xE8, 0x9F, 0x81 },
	0xD6BA, { 0xE8, 0x9E, 0xB1 },
	0xD6BB, { 0xE8, 0x9F, 0x87 },
	0xD6BC, { 0xE4, 0x97, 0xAC },
	0xD6BD, { 0xE8, 0xA5, 0x80 },
	0xD6BE, { 0xE4, 0x99, 0x99 },
	0xD6BF, { 0xE8, 0xA4, 0xBF },
	0xD6C0, { 0xE8, 0xA4, 0xB9 },
	0xD6C1, { 0xE4, 0x99, 0x9D },
	0xD6C2, { 0xE8, 0xA5, 0x83 },
	0xD6C3, { 0xE4, 0x99, 0x97 },
	0xD6C4, { 0xE4, 0x99, 0x9B },
	0xD6C5, { 0xE4, 0x99, 0x96 },
	0xD6C6, { 0xE8, 0xA6, 0xAB },
	0xD6C7, { 0xE4, 0x9B, 0xBE },
	0xD6C8, { 0xE8, 0xAC, 0x9F },
	0xD6C9, { 0xE8, 0xAC, 0x89 },
	0xD6CA, { 0xE8, 0xAC, 0x8C },
	0xD6CB, { 0xE4, 0x9C, 0x80 },
	0xD6CC, { 0xE4, 0x9C, 0x81 },
	0xD6CD, { 0xE8, 0xB1, 0x80 },
	0xD6CE, { 0xE4, 0x9D, 0x82 },
	0xD6CF, { 0xE8, 0xB2, 0x96 },
	0xD6D0, { 0xE4, 0x9D, 0xA0 },
	0xD6D1, { 0xE8, 0xB3, 0xB6 },
	0xD6D2, { 0xE8, 0xB3, 0xB7 },
	0xD6D3, { 0xE4, 0xA0, 0x9D },
	0xD6D4, { 0xE8, 0xB9, 0x86 },
	0xD6D5, { 0xE8, 0xB9, 0x8F },
	0xD6D6, { 0xE4, 0xA0, 0xBE },
	0xD6D7, { 0xE4, 0xA1, 0xA9 },
	0xD6D8, { 0xE4, 0xA1, 0xA5 },
	0xD6D9, { 0xE8, 0xBC, 0xBD },
	0xD6DA, { 0xE8, 0xBD, 0x81 },
	0xD6DB, { 0xE9, 0x8D, 0xA6 },
	0xD6DC, { 0xE9, 0x8D, 0xB8 },
	0xD6DD, { 0xE9, 0x8D, 0x9D },
	0xD6DE, { 0xE9, 0x8D, 0xA9 },
	0xD6DF, { 0xE9, 0x8D, 0xB4 },
	0xD6E0, { 0xE9, 0x8D, 0xBD },
	0xD6E1, { 0xE9, 0x8D, 0xAE },
	0xD6E2, { 0xE9, 0x8D, 0xB2 },
	0xD6E3, { 0xE9, 0x8D, 0xB3 },
	0xD6E4, { 0xE9, 0x8D, 0xA2 },
	0xD6E5, { 0xE9, 0x8D, 0x88 },
	0xD6E6, { 0xE9, 0x8D, 0x93 },
	0xD6E7, { 0xE9, 0x8D, 0x9F },
	0xD6E8, { 0xE9, 0x8D, 0xA8 },
	0xD6E9, { 0xE4, 0xA4, 0xB8 },
	0xD6EA, { 0xE9, 0x8D, 0xBF },
	0xD6EB, { 0xE9, 0x8D, 0xAB },
	0xD6EC, { 0xE4, 0xA6, 0xAE },
	0xD6ED, { 0xE9, 0x97, 0x84 },
	0xD6EE, { 0xE4, 0xA6, 0xAD },
	0xD6EF, { 0xE9, 0x9A, 0xAF },
	0xD6F0, { 0xE9, 0x9A, 0xAD },
	0xD6F1, { 0xE9, 0x9A, 0xB2 },
	0xD6F2, { 0xE4, 0xA8, 0x82 },
	0xD6F3, { 0xE4, 0xA8, 0x9F },
	0xD6F4, { 0xE9, 0x9C, 0x9A },
	0xD6F5, { 0xE9, 0x9C, 0x9B },
	0xD6F6, { 0xE4, 0xA8, 0xA2 },
	0xD6F7, { 0xE4, 0xA8, 0xA0 },
	0xD6F8, { 0xF0, 0xAF, 0xA7, 0xB5 },
	0xD6F9, { 0xE4, 0xA9, 0xAC },
	0xD6FA, { 0xE9, 0x9E, 0x9B },
	0xD6FB, { 0xE9, 0x9E, 0x9F },
	0xD6FC, { 0xE4, 0xA9, 0xA8 },
	0xD6FD, { 0xE4, 0xA9, 0xAD },
	0xD6FE, { 0xE4, 0xA9, 0xAE },
	0xD7A1, { 0xE4, 0xAA, 0xA0 },
	0xD7A2, { 0xE4, 0xAB, 0x8E },
	0xD7A3, { 0xE4, 0xAB, 0x90 },
	0xD7A4, { 0xE4, 0xAB, 0x91 },
	0xD7A5, { 0xE4, 0xAB, 0x8B },
	0xD7A6, { 0xE9, 0xA1, 0x80 },
	0xD7A7, { 0xE4, 0xAB, 0x92 },
	0xD7A8, { 0xE9, 0xA1, 0x87 },
	0xD7A9, { 0xE4, 0xAB, 0x93 },
	0xD7AA, { 0xE9, 0xA2, 0xB7 },
	0xD7AB, { 0xE4, 0xAC, 0xA0 },
	0xD7AC, { 0xE4, 0xAD, 0x8E },
	0xD7AD, { 0xE4, 0xAD, 0x8B },
	0xD7AE, { 0xE4, 0xAD, 0xB2 },
	0xD7AF, { 0xE4, 0xAD, 0xB0 },
	0xD7B0, { 0xE9, 0xA6, 0xA2 },
	0xD7B1, { 0xE4, 0xAE, 0x92 },
	0xD7B2, { 0xE4, 0xAE, 0x8F },
	0xD7B3, { 0xE9, 0xA8, 0x80 },
	0xD7B4, { 0xE9, 0xA7, 0xB3 },
	0xD7B5, { 0xE4, 0xAE, 0x90 },
	0xD7B6, { 0xF0, 0xA9, 0xA4, 0xB7 },
	0xD7B7, { 0xE9, 0xA7, 0xB5 },
	0xD7B8, { 0xE4, 0xAF, 0x99 },
	0xD7B9, { 0xE4, 0xAF, 0x95 },
	0xD7BA, { 0xE9, 0xAA, 0xBD },
	0xD7BB, { 0xE9, 0xAC, 0x80 },
	0xD7BC, { 0xE9, 0xAC, 0x82 },
	0xD7BD, { 0xE4, 0xAF, 0xBA },
	0xD7BE, { 0xE9, 0xAC, 0xB4 },
	0xD7BF, { 0xE9, 0xAD, 0x89 },
	0xD7C0, { 0xE9, 0xAE, 0x9F },
	0xD7C1, { 0xE4, 0xB1, 0x8B },
	0xD7C2, { 0xE9, 0xAE, 0xA3 },
	0xD7C3, { 0xE9, 0xAF, 0x8D },
	0xD7C4, { 0xE9, 0xAE, 0x99 },
	0xD7C5, { 0xE9, 0xAE, 0x9D },
	0xD7C6, { 0xE4, 0xB3, 0x90 },
	0xD7C7, { 0xE4, 0xB3, 0x8E },
	0xD7C8, { 0xE9, 0xB4, 0xB9 },
	0xD7C9, { 0xE4, 0xB3, 0x8F },
	0xD7CA, { 0xE9, 0xB5, 0x84 },
	0xD7CB, { 0xE4, 0xB3, 0x84 },
	0xD7CC, { 0xE4, 0xB3, 0x8C },
	0xD7CD, { 0xE9, 0xB4, 0xB5 },
	0xD7CE, { 0xE4, 0xB3, 0x92 },
	0xD7CF, { 0xE4, 0xB4, 0xB5 },
	0xD7D0, { 0xE9, 0xBA, 0xAF },
	0xD7D1, { 0xE3, 0xB8, 0x83 },
	0xD7D2, { 0xE5, 0x84, 0xAF },
	0xD7D3, { 0xE3, 0x92, 0x9E },
	0xD7D4, { 0xE3, 0x92, 0xAF },
	0xD7D5, { 0xE9, 0xBE, 0x8E },
	0xD7D6, { 0xE3, 0x98, 0x8C },
	0xD7D7, { 0xE5, 0x9A, 0x9F },
	0xD7D8, { 0xE5, 0x9A, 0x9B },
	0xD7D9, { 0xE5, 0x9A, 0x9E },
	0xD7DA, { 0xE5, 0x9A, 0x96 },
	0xD7DB, { 0xE5, 0x9A, 0x94 },
	0xD7DC, { 0xE5, 0x9A, 0xA0 },
	0xD7DD, { 0xE3, 0x99, 0xBC },
	0xD7DE, { 0xE5, 0xAC, 0xBB },
	0xD7DF, { 0xE3, 0x9C, 0xB0 },
	0xD7E0, { 0xE3, 0x9C, 0xB1 },
	0xD7E1, { 0xE5, 0xAC, 0xBA },
	0xD7E2, { 0xE5, 0xB7, 0x81 },
	0xD7E3, { 0xE5, 0xBD, 0x8D },
	0xD7E4, { 0xE5, 0xBD, 0x9D },
	0xD7E5, { 0xE6, 0x87, 0xB3 },
	0xD7E6, { 0xE3, 0xA6, 0xA1 },
	0xD7E7, { 0xE3, 0xA6, 0x9E },
	0xD7E8, { 0xE3, 0xA9, 0xA8 },
	0xD7E9, { 0xE3, 0xA9, 0xA1 },
	0xD7EA, { 0xE6, 0x93, 0xB6 },
	0xD7EB, { 0xE6, 0x93, 0xA5 },
	0xD7EC, { 0xE6, 0x93, 0xAA },
	0xD7ED, { 0xE6, 0x93, 0xA7 },
	0xD7EE, { 0xE6, 0x94, 0x85 },
	0xD7EF, { 0xE3, 0xA9, 0xA5 },
	0xD7F0, { 0xE6, 0x93, 0xB9 },
	0xD7F1, { 0xE3, 0xA9, 0xA6 },
	0xD7F2, { 0xE3, 0xA9, 0xAA },
	0xD7F3, { 0xE3, 0xAA, 0xAB },
	0xD7F4, { 0xE6, 0xAA, 0xAB },
	0xD7F5, { 0xE6, 0xAB, 0xAD },
	0xD7F6, { 0xE6, 0xAA, 0xB2 },
	0xD7F7, { 0xE6, 0xAA, 0xB0 },
	0xD7F8, { 0xE6, 0xAA, 0xB5 },
	0xD7F9, { 0xE6, 0xAA, 0xBE },
	0xD7FA, { 0xE6, 0xAB, 0x81 },
	0xD7FB, { 0xE6, 0xAB, 0x88 },
	0xD7FC, { 0xE3, 0xAF, 0xB9 },
	0xD7FD, { 0xE6, 0xAB, 0x80 },
	0xD7FE, { 0xE6, 0xAA, 0xBC },
	0xD8A1, { 0xE6, 0xAA, 0xB1 },
	0xD8A2, { 0xE6, 0xAB, 0x84 },
	0xD8A3, { 0xE6, 0xAA, 0xBF },
	0xD8A4, { 0xE3, 0xB1, 0x98 },
	0xD8A5, { 0xE3, 0xB2, 0x8A },
	0xD8A6, { 0xE7, 0x80, 0x88 },
	0xD8A7, { 0xE7, 0x80, 0x83 },
	0xD8A8, { 0xE6, 0xBF, 0xBD },
	0xD8A9, { 0xE7, 0x80, 0x90 },
	0xD8AA, { 0xE7, 0x80, 0x82 },
	0xD8AB, { 0xE7, 0x80, 0x93 },
	0xD8AC, { 0xE3, 0xB8, 0x84 },
	0xD8AD, { 0xE7, 0x87, 0xBA },
	0xD8AE, { 0xE7, 0x88, 0x80 },
	0xD8AF, { 0xE7, 0x92, 0xB9 },
	0xD8B0, { 0xE7, 0x92, 0xBC },
	0xD8B1, { 0xE3, 0xBC, 0x82 },
	0xD8B2, { 0xE7, 0x99, 0x9B },
	0xD8B3, { 0xE7, 0x99, 0x91 },
	0xD8B4, { 0xE7, 0x99, 0x8F },
	0xD8B5, { 0xE7, 0x9B, 0xAB },
	0xD8B6, { 0xE7, 0x9E, 0xB8 },
	0xD8B7, { 0xE4, 0x81, 0xB9 },
	0xD8B8, { 0xE7, 0x9E, 0xB9 },
	0xD8B9, { 0xE7, 0x9F, 0x81 },
	0xD8BA, { 0xE7, 0x9F, 0x80 },
	0xD8BB, { 0xE7, 0x9E, 0xBE },
	0xD8BC, { 0xE7, 0xA4, 0x8B },
	0xD8BD, { 0xE4, 0x83, 0xAB },
	0xD8BE, { 0xE7, 0xA4, 0x87 },
	0xD8BF, { 0xE7, 0xA4, 0x8A },
	0xD8C0, { 0xE7, 0xA4, 0x88 },
	0xD8C1, { 0xE4, 0x83, 0xA9 },
	0xD8C2, { 0xE7, 0xA4, 0x8D },
	0xD8C3, { 0xE7, 0xA4, 0x86 },
	0xD8C4, { 0xE7, 0xA4, 0x95 },
	0xD8C5, { 0xE7, 0xA6, 0xAF },
	0xD8C6, { 0xE4, 0x84, 0xA0 },
	0xD8C7, { 0xE4, 0x84, 0xA1 },
	0xD8C8, { 0xE4, 0x86, 0x81 },
	0xD8C9, { 0xE7, 0xAB, 0xB5 },
	0xD8CA, { 0xE4, 0x89, 0x8D },
	0xD8CB, { 0xE4, 0x89, 0x99 },
	0xD8CC, { 0xE7, 0xB0, 0xAE },
	0xD8CD, { 0xE4, 0x89, 0x98 },
	0xD8CE, { 0xE7, 0xB0, 0x9B },
	0xD8CF, { 0xF0, 0xA5, 0xB3, 0x91 },
	0xD8D0, { 0xE7, 0xB0, 0x9A },
	0xD8D1, { 0xE7, 0xB0, 0xA4 },
	0xD8D2, { 0xE4, 0x8A, 0xA5 },
	0xD8D3, { 0xE4, 0x8A, 0xA9 },
	0xD8D4, { 0xE7, 0xB3, 0xA6 },
	0xD8D5, { 0xE7, 0xB3, 0xA3 },
	0xD8D6, { 0xE4, 0x8C, 0x9A },
	0xD8D7, { 0xE4, 0x8C, 0x99 },
	0xD8D8, { 0xE7, 0xB9, 0x9D },
	0xD8D9, { 0xE7, 0xB9, 0x8F },
	0xD8DA, { 0xE7, 0xB9, 0xA6 },
	0xD8DB, { 0xE7, 0xB9, 0x9B },
	0xD8DC, { 0xE7, 0xBD, 0x87 },
	0xD8DD, { 0xE7, 0xBE, 0xB4 },
	0xD8DE, { 0xE4, 0x8E, 0x96 },
	0xD8DF, { 0xE4, 0x8E, 0x98 },
	0xD8E0, { 0xE4, 0x8E, 0x97 },
	0xD8E1, { 0xE7, 0xBF, 0xBA },
	0xD8E2, { 0xE8, 0x80, 0xAE },
	0xD8E3, { 0xF0, 0xA6, 0x97, 0x9F },
	0xD8E4, { 0xE4, 0x8F, 0x88 },
	0xD8E5, { 0xE8, 0x87, 0x8E },
	0xD8E6, { 0xE4, 0x91, 0x83 },
	0xD8E7, { 0xE4, 0x91, 0x85 },
	0xD8E8, { 0xE8, 0x88, 0x99 },
	0xD8E9, { 0xE4, 0x95, 0x92 },
	0xD8EA, { 0xE4, 0x95, 0x97 },
	0xD8EB, { 0xE8, 0x97, 0x8C },
	0xD8EC, { 0xE8, 0x96, 0xB2 },
	0xD8ED, { 0xE4, 0x95, 0x95 },
	0xD8EE, { 0xE8, 0x96, 0xBB },
	0xD8EF, { 0xE8, 0x97, 0x81 },
	0xD8F0, { 0xE4, 0x95, 0x96 },
	0xD8F1, { 0xE4, 0x95, 0x98 },
	0xD8F2, { 0xE4, 0x97, 0xB2 },
	0xD8F3, { 0xE8, 0x9F, 0xA9 },
	0xD8F4, { 0xE8, 0x9F, 0xAE },
	0xD8F5, { 0xE8, 0x9F, 0xB0 },
	0xD8F6, { 0xE8, 0x9F, 0x96 },
	0xD8F7, { 0xE8, 0xA0, 0x8E },
	0xD8F8, { 0xE8, 0x9F, 0x9A },
	0xD8F9, { 0xE8, 0xA5, 0x88 },
	0xD8FA, { 0xE8, 0xA5, 0x8A },
	0xD8FB, { 0xE8, 0xA5, 0x8E },
	0xD8FC, { 0xE8, 0xA5, 0x8D },
	0xD8FD, { 0xE8, 0xA6, 0xB1 },
	0xD8FE, { 0xE8, 0xA6, 0xB0 },
	0xD9A1, { 0xE8, 0xA6, 0xB3 },
	0xD9A2, { 0xE4, 0x9C, 0x87 },
	0xD9A3, { 0xE8, 0xAC, 0xB8 },
	0xD9A4, { 0xE8, 0xAC, 0xB2 },
	0xD9A5, { 0xE4, 0x9C, 0x88 },
	0xD9A6, { 0xE8, 0xAC, 0xAD },
	0xD9A7, { 0xE4, 0x9C, 0x8A },
	0xD9A8, { 0xE8, 0xAC, 0xB4 },
	0xD9A9, { 0xE4, 0x8C, 0x9B },
	0xD9AA, { 0xE8, 0xAC, 0xA9 },
	0xD9AB, { 0xE8, 0xB1, 0xB4 },
	0xD9AC, { 0xE4, 0x9D, 0xA1 },
	0xD9AD, { 0xE4, 0x9D, 0xA2 },
	0xD9AE, { 0xE8, 0xB4, 0x83 },
	0xD9AF, { 0xE4, 0x9F, 0x82 },
	0xD9B0, { 0xE4, 0x9F, 0x86 },
	0xD9B1, { 0xE8, 0xB6, 0xA9 },
	0xD9B2, { 0xE8, 0xB9, 0x98 },
	0xD9B3, { 0xE4, 0xA0, 0x9E },
	0xD9B4, { 0xE4, 0xA0, 0xA5 },
	0xD9B5, { 0xE8, 0xBA, 0xBF },
	0xD9B6, { 0xE8, 0xBB, 0x81 },
	0xD9B7, { 0xE8, 0xBD, 0x8A },
	0xD9B8, { 0xE8, 0xBE, 0xAC },
	0xD9B9, { 0xE4, 0xA2, 0xB0 },
	0xD9BA, { 0xE9, 0x82, 0x89 },
	0xD9BB, { 0xE9, 0x84, 0xBD },
	0xD9BC, { 0xE9, 0x84, 0xBC },
	0xD9BD, { 0xE9, 0x86, 0xA9 },
	0xD9BE, { 0xE9, 0x8E, 0xA0 },
	0xD9BF, { 0xE4, 0xA4, 0xBD },
	0xD9C0, { 0xE9, 0x8E, 0x90 },
	0xD9C1, { 0xE4, 0xA4, 0xBE },
	0xD9C2, { 0xE9, 0x8E, 0x93 },
	0xD9C3, { 0xE9, 0x8E, 0x8B },
	0xD9C4, { 0xE9, 0x8E, 0xAD },
	0xD9C5, { 0xE9, 0x8E, 0xBB },
	0xD9C6, { 0xE9, 0x8E, 0xB8 },
	0xD9C7, { 0xE4, 0xA5, 0x86 },
	0xD9C8, { 0xE4, 0xA5, 0x85 },
	0xD9C9, { 0xE9, 0x8E, 0x9C },
	0xD9CA, { 0xE9, 0x97, 0x98 },
	0xD9CB, { 0xE9, 0x97, 0x97 },
	0xD9CC, { 0xE4, 0xA8, 0x83 },
	0xD9CD, { 0xE4, 0xA8, 0xA6 },
	0xD9CE, { 0xE4, 0xA8, 0xA7 },
	0xD9CF, { 0xE9, 0x9D, 0x9D },
	0xD9D0, { 0xE9, 0x9E, 0xA9 },
	0xD9D1, { 0xE9, 0x9F, 0x9A },
	0xD9D2, { 0xE4, 0xAA, 0x98 },
	0xD9D3, { 0xE4, 0xAA, 0xAD },
	0xD9D4, { 0xE4, 0xAB, 0x95 },
	0xD9D5, { 0xE4, 0xAB, 0x9A },
	0xD9D6, { 0xE9, 0xA1, 0x94 },
	0xD9D7, { 0xE4, 0xAB, 0x99 },
	0xD9D8, { 0xE9, 0xA1, 0x95 },
	0xD9D9, { 0xE9, 0xA1, 0x8B },
	0xD9DA, { 0xE4, 0xAB, 0x9D },
	0xD9DB, { 0xE9, 0xA0, 0xBF },
	0xD9DC, { 0xE9, 0xA2, 0xB9 },
	0xD9DD, { 0xE4, 0xAC, 0x95 },
	0xD9DE, { 0xE4, 0xAC, 0x96 },
	0xD9DF, { 0xE4, 0xAC, 0x97 },
	0xD9E0, { 0xE4, 0xAC, 0xA1 },
	0xD9E1, { 0xE9, 0xA4, 0xB8 },
	0xD9E2, { 0xE9, 0xA4, 0xB6 },
	0xD9E3, { 0xE9, 0xA5, 0x80 },
	0xD9E4, { 0xE4, 0xAD, 0x8C },
	0xD9E5, { 0xE9, 0xA4, 0xBB },
	0xD9E6, { 0xE9, 0xA4, 0xB9 },
	0xD9E7, { 0xE9, 0xA6, 0xA4 },
	0xD9E8, { 0xE4, 0xAE, 0x96 },
	0xD9E9, { 0xE4, 0xAE, 0x98 },
	0xD9EA, { 0xE9, 0xA8, 0x88 },
	0xD9EB, { 0xE9, 0xA8, 0x8C },
	0xD9EC, { 0xE4, 0xAE, 0x9B },
	0xD9ED, { 0xE9, 0xA8, 0x90 },
	0xD9EE, { 0xE4, 0xAF, 0xBF },
	0xD9EF, { 0xE9, 0xAC, 0x87 },
	0xD9F0, { 0xE4, 0xB0, 0xA5 },
	0xD9F1, { 0xE9, 0xAF, 0x92 },
	0xD9F2, { 0xE4, 0xB1, 0x8F },
	0xD9F3, { 0xE9, 0xAF, 0x82 },
	0xD9F4, { 0xE9, 0xAE, 0xBB },
	0xD9F5, { 0xE9, 0xAF, 0x8C },
	0xD9F6, { 0xE9, 0xAF, 0x8B },
	0xD9F7, { 0xE4, 0xB1, 0x96 },
	0xD9F8, { 0xE4, 0xB1, 0x94 },
	0xD9F9, { 0xE9, 0xB5, 0x8D },
	0xD9FA, { 0xE9, 0xB5, 0xA3 },
	0xD9FB, { 0xE9, 0xB5, 0x8E },
	0xD9FC, { 0xE4, 0xB3, 0x98 },
	0xD9FD, { 0xE9, 0xB5, 0x90 },
	0xD9FE, { 0xE9, 0xB5, 0x95 },
	0xDAA1, { 0xE4, 0xB3, 0x97 },
	0xDAA2, { 0xE9, 0xB5, 0x9E },
	0xDAA3, { 0xE4, 0xB4, 0xA6 },
	0xDAA4, { 0xE9, 0xBA, 0x90 },
	0xDAA5, { 0xE9, 0xBA, 0xB2 },
	0xDAA6, { 0xE9, 0xBA, 0xB1 },
	0xDAA7, { 0xE4, 0xB4, 0xB8 },
	0xDAA8, { 0xE9, 0xBB, 0x8A },
	0xDAA9, { 0xE9, 0xBC, 0x82 },
	0xDAAA, { 0xE9, 0xBC, 0xA7 },
	0xDAAB, { 0xE9, 0xBC, 0xA6 },
	0xDAAC, { 0xE4, 0xB6, 0x8A },
	0xDAAD, { 0xE5, 0x9A, 0xAF },
	0xDAAE, { 0xE5, 0xA3, 0xA0 },
	0xDAAF, { 0xE5, 0xA3, 0x9C },
	0xDAB0, { 0xE3, 0x9C, 0xB4 },
	0xDAB1, { 0xE5, 0xAC, 0xB9 },
	0xDAB2, { 0xE3, 0x9C, 0xB5 },
	0xDAB3, { 0xF0, 0xAF, 0xA1, 0xAA },
	0xDAB4, { 0xE5, 0xAD, 0xBC },
	0xDAB5, { 0xE5, 0xAF, 0xB3 },
	0xDAB6, { 0xF0, 0xAF, 0xA1, 0xB0 },
	0xDAB7, { 0xE3, 0x9E, 0xA1 },
	0xDAB8, { 0xE5, 0xB1, 0xAB },
	0xDAB9, { 0xE5, 0xB7, 0x84 },
	0xDABA, { 0xE6, 0x94, 0x8B },
	0xDABB, { 0xE6, 0x94, 0x88 },
	0xDABC, { 0xE6, 0x94, 0x8A },
	0xDABD, { 0xE3, 0xA9, 0xAC },
	0xDABE, { 0xE3, 0xA9, 0xAD },
	0xDABF, { 0xE6, 0x97, 0x9C },
	0xDAC0, { 0xE3, 0xAC, 0xA9 },
	0xDAC1, { 0xE3, 0xAC, 0xAA },
	0xDAC2, { 0xE6, 0x9B, 0xA1 },
	0xDAC3, { 0xE6, 0x9B, 0x9F },
	0xDAC4, { 0xE6, 0xAB, 0x8E },
	0xDAC5, { 0xE6, 0xAB, 0x94 },
	0xDAC6, { 0xE6, 0xAB, 0xA3 },
	0xDAC7, { 0xE6, 0xAB, 0x97 },
	0xDAC8, { 0xE6, 0xAB, 0xA2 },
	0xDAC9, { 0xE3, 0xB0, 0x80 },
	0xDACA, { 0xE3, 0xB0, 0x88 },
	0xDACB, { 0xE3, 0xB0, 0x86 },
	0xDACC, { 0xE3, 0xB0, 0x85 },
	0xDACD, { 0xE6, 0xAB, 0x98 },
	0xDACE, { 0xE6, 0xAB, 0x95 },
	0xDACF, { 0xE6, 0xAB, 0x92 },
	0xDAD0, { 0xE3, 0xB2, 0xB1 },
	0xDAD1, { 0xE3, 0xB6, 0x88 },
	0xDAD2, { 0xE7, 0x80, 0x9E },
	0xDAD3, { 0xE7, 0x80, 0xAC },
	0xDAD4, { 0xE7, 0x80, 0xA5 },
	0xDAD5, { 0xE6, 0xBF, 0xB3 },
	0xDAD6, { 0xE7, 0x88, 0x84 },
	0xDAD7, { 0xE7, 0x88, 0x88 },
	0xDAD8, { 0xE7, 0x88, 0x95 },
	0xDAD9, { 0xE3, 0xB8, 0x89 },
	0xDADA, { 0xE7, 0x93, 0x84 },
	0xDADB, { 0xE7, 0x93, 0x89 },
	0xDADC, { 0xE7, 0x93, 0x87 },
	0xDADD, { 0xE7, 0x93, 0x88 },
	0xDADE, { 0xE7, 0x9A, 0xA9 },
	0xDADF, { 0xE7, 0x9F, 0x86 },
	0xDAE0, { 0xE7, 0x9F, 0x85 },
	0xDAE1, { 0xE7, 0xA4, 0x98 },
	0xDAE2, { 0xE7, 0xA4, 0x9A },
	0xDAE3, { 0xE7, 0xA4, 0xA0 },
	0xDAE4, { 0xE4, 0x84, 0xA2 },
	0xDAE5, { 0xE7, 0xA9, 0xA6 },
	0xDAE6, { 0xE7, 0xA9, 0xA4 },
	0xDAE7, { 0xE7, 0xA9, 0xAA },
	0xDAE8, { 0xE4, 0x87, 0x95 },
	0xDAE9, { 0xE4, 0x89, 0xA1 },
	0xDAEA, { 0xE4, 0x89, 0x9D },
	0xDAEB, { 0xE4, 0x89, 0xA2 },
	0xDAEC, { 0xE4, 0x89, 0x8F },
	0xDAED, { 0xE4, 0x89, 0xA0 },
	0xDAEE, { 0xE7, 0xB0, 0xB5 },
	0xDAEF, { 0xE7, 0xB0, 0xB4 },
	0xDAF0, { 0xE4, 0x8A, 0xAA },
	0xDAF1, { 0xE4, 0x8C, 0xA2 },
	0xDAF2, { 0xE7, 0xB9, 0xAC },
	0xDAF3, { 0xE4, 0x8C, 0xA1 },
	0xDAF4, { 0xE7, 0xB9, 0xAE },
	0xDAF5, { 0xE7, 0xB9, 0xB1 },
	0xDAF6, { 0xE4, 0x91, 0x86 },
	0xDAF7, { 0xE8, 0x87, 0x94 },
	0xDAF8, { 0xE8, 0x87, 0x96 },
	0xDAF9, { 0xE8, 0x88, 0x9A },
	0xDAFA, { 0xE8, 0x89, 0xA2 },
	0xDAFB, { 0xE8, 0x89, 0xA5 },
	0xDAFC, { 0xE8, 0x89, 0xB6 },
	0xDAFD, { 0xE8, 0x97, 0x9B },
	0xDAFE, { 0xE8, 0x97, 0x96 },
	0xDBA1, { 0xE4, 0x95, 0xA2 },
	0xDBA2, { 0xE8, 0x97, 0xA7 },
	0xDBA3, { 0xE4, 0x95, 0xA0 },
	0xDBA4, { 0xE4, 0x95, 0xA4 },
	0xDBA5, { 0xE8, 0x97, 0xB4 },
	0xDBA6, { 0xF0, 0xAF, 0xA6, 0xB6 },
	0xDBA7, { 0xE8, 0x9F, 0xBD },
	0xDBA8, { 0xE8, 0x9F, 0x95 },
	0xDBA9, { 0xE8, 0xA0, 0x87 },
	0xDBAA, { 0xE4, 0x97, 0xB6 },
	0xDBAB, { 0xE8, 0xA0, 0x8F },
	0xDBAC, { 0xE8, 0x9F, 0xB8 },
	0xDBAD, { 0xF0, 0xAF, 0xA7, 0x81 },
	0xDBAE, { 0xE4, 0x98, 0x99 },
	0xDBAF, { 0xE8, 0xA6, 0x87 },
	0xDBB0, { 0xE4, 0x9A, 0x91 },
	0xDBB1, { 0xE8, 0xA6, 0xB5 },
	0xDBB2, { 0xE8, 0xA7, 0xB5 },
	0xDBB3, { 0xE4, 0x9C, 0x8D },
	0xDBB4, { 0xE8, 0xAC, 0xBF },
	0xDBB5, { 0xE8, 0xAD, 0x83 },
	0xDBB6, { 0xE8, 0xAD, 0x8C },
	0xDBB7, { 0xE4, 0x9D, 0xA5 },
	0xDBB8, { 0xE8, 0xB4, 0x8B },
	0xDBB9, { 0xE8, 0xB9, 0xAB },
	0xDBBA, { 0xE8, 0xB9, 0xA8 },
	0xDBBB, { 0xE8, 0xB9, 0xB0 },
	0xDBBC, { 0xE8, 0xB9, 0xB5 },
	0xDBBD, { 0xE8, 0xB9, 0xB7 },
	0xDBBE, { 0xE4, 0xA0, 0xBF },
	0xDBBF, { 0xE8, 0xBB, 0x83 },
	0xDBC0, { 0xE4, 0xA5, 0x8B },
	0xDBC1, { 0xE9, 0x8F, 0xA9 },
	0xDBC2, { 0xE9, 0x8F, 0xAA },
	0xDBC3, { 0xE9, 0x8F, 0x8B },
	0xDBC4, { 0xE9, 0x8F, 0x85 },
	0xDBC5, { 0xE9, 0x8F, 0x86 },
	0xDBC6, { 0xE4, 0xA5, 0x88 },
	0xDBC7, { 0xE9, 0x8F, 0xAD },
	0xDBC8, { 0xE9, 0x8F, 0x93 },
	0xDBC9, { 0xE4, 0xA5, 0x92 },
	0xDBCA, { 0xE9, 0x8F, 0xA5 },
	0xDBCB, { 0xE4, 0xA5, 0x8A },
	0xDBCC, { 0xE4, 0xA5, 0x91 },
	0xDBCD, { 0xE9, 0x8F, 0x9B },
	0xDBCE, { 0xE9, 0x8F, 0xAB },
	0xDBCF, { 0xE9, 0x8F, 0xA0 },
	0xDBD0, { 0xE9, 0x8F, 0x81 },
	0xDBD1, { 0xE4, 0xA5, 0x90 },
	0xDBD2, { 0xE4, 0xA5, 0x8C },
	0xDBD3, { 0xE9, 0x97, 0x9D },
	0xDBD4, { 0xE4, 0xA7, 0xAE },
	0xDBD5, { 0xE4, 0xA8, 0x84 },
	0xDBD6, { 0xE4, 0xA8, 0x86 },
	0xDBD7, { 0xE4, 0xA8, 0xAD },
	0xDBD8, { 0xE4, 0xA8, 0xAE },
	0xDBD9, { 0xE4, 0xA8, 0xAF },
	0xDBDA, { 0xE4, 0xA9, 0xBB },
	0xDBDB, { 0xE4, 0xA9, 0xB8 },
	0xDBDC, { 0xE4, 0xA9, 0xB7 },
	0xDBDD, { 0xE9, 0x9E, 0xB2 },
	0xDBDE, { 0xE9, 0x9E, 0xB4 },
	0xDBDF, { 0xE9, 0x9E, 0xB1 },
	0xDBE0, { 0xE9, 0x9E, 0xB5 },
	0xDBE1, { 0xE9, 0x9F, 0xB2 },
	0xDBE2, { 0xE4, 0xAA, 0xA2 },
	0xDBE3, { 0xE4, 0xAA, 0xA1 },
	0xDBE4, { 0xE4, 0xAB, 0xA3 },
	0xDBE5, { 0xE9, 0xA1, 0x96 },
	0xDBE6, { 0xE4, 0xAC, 0x9A },
	0xDBE7, { 0xE4, 0xAC, 0x99 },
	0xDBE8, { 0xE4, 0xAD, 0x97 },
	0xDBE9, { 0xE9, 0xA5, 0x84 },
	0xDBEA, { 0xE4, 0xAE, 0x9E },
	0xDBEB, { 0xE9, 0xA8, 0xA6 },
	0xDBEC, { 0xE9, 0xA8, 0x9F },
	0xDBED, { 0xE9, 0xA8, 0x98 },
	0xDBEE, { 0xE9, 0xA8, 0xA1 },
	0xDBEF, { 0xE9, 0xA8, 0x97 },
	0xDBF0, { 0xE4, 0xAF, 0x9D },
	0xDBF1, { 0xE9, 0xAC, 0x89 },
	0xDBF2, { 0xE4, 0xB0, 0x85 },
	0xDBF3, { 0xE4, 0xB0, 0xA8 },
	0xDBF4, { 0xE9, 0xAF, 0x85 },
	0xDBF5, { 0xE9, 0xAF, 0x9F },
	0xDBF6, { 0xE4, 0xB1, 0xA0 },
	0xDBF7, { 0xE9, 0xAF, 0xA3 },
	0xDBF8, { 0xE4, 0xB1, 0xA6 },
	0xDBF9, { 0xE9, 0xAF, 0xA9 },
	0xDBFA, { 0xE9, 0xAF, 0xAE },
	0xDBFB, { 0xE4, 0xB1, 0xA7 },
	0xDBFC, { 0xE4, 0xB1, 0xA8 },
	0xDBFD, { 0xE9, 0xB5, 0xA6 },
	0xDBFE, { 0xE9, 0xB5, 0xBA },
	0xDCA1, { 0xE4, 0xB3, 0x9E },
	0xDCA2, { 0xE9, 0xB5, 0xAE },
	0xDCA3, { 0xE9, 0xB6, 0x91 },
	0xDCA4, { 0xE9, 0xB6, 0x83 },
	0xDCA5, { 0xE9, 0xB5, 0xB6 },
	0xDCA6, { 0xE9, 0xB5, 0xBE },
	0xDCA7, { 0xE9, 0xB5, 0xAD },
	0xDCA8, { 0xE4, 0xB3, 0xA1 },
	0xDCA9, { 0xE9, 0xBA, 0x95 },
	0xDCAA, { 0xE9, 0xBB, 0xA3 },
	0xDCAB, { 0xE4, 0xB5, 0xA9 },
	0xDCAC, { 0xE4, 0xB5, 0xB7 },
	0xDCAD, { 0xE9, 0xBC, 0x83 },
	0xDCAE, { 0xE9, 0xBC, 0x84 },
	0xDCAF, { 0xF0, 0xAF, 0xA8, 0x99 },
	0xDCB0, { 0xE9, 0xBC, 0x97 },
	0xDCB1, { 0xE3, 0x92, 0xA6 },
	0xDCB2, { 0xE5, 0x84, 0xB6 },
	0xDCB3, { 0xE3, 0x92, 0xA5 },
	0xDCB4, { 0xE5, 0x8C, 0xB6 },
	0xDCB5, { 0xE3, 0x98, 0x94 },
	0xDCB6, { 0xE5, 0xAD, 0x82 },
	0xDCB7, { 0xE3, 0x9C, 0xB6 },
	0xDCB8, { 0xE3, 0x9C, 0xB8 },
	0xDCB9, { 0xE5, 0xAD, 0x84 },
	0xDCBA, { 0xE5, 0xAD, 0x86 },
	0xDCBB, { 0xE5, 0xAD, 0xBE },
	0xDCBC, { 0xE5, 0xB7, 0x8A },
	0xDCBD, { 0xE5, 0xB7, 0x88 },
	0xDCBE, { 0xE5, 0xB7, 0x8C },
	0xDCBF, { 0xE5, 0xBB, 0xB0 },
	0xDCC0, { 0xE3, 0xA9, 0xB0 },
	0xDCC1, { 0xE6, 0x96, 0x85 },
	0xDCC2, { 0xE6, 0x9B, 0xA5 },
	0xDCC3, { 0xE6, 0x9B, 0xA7 },
	0xDCC4, { 0xE3, 0xAC, 0xAB },
	0xDCC5, { 0xE3, 0xB0, 0x91 },
	0xDCC6, { 0xE3, 0xB0, 0x8A },
	0xDCC7, { 0xE6, 0xAB, 0xB4 },
	0xDCC8, { 0xE3, 0xB0, 0x8D },
	0xDCC9, { 0xE6, 0xAB, 0xA9 },
	0xDCCA, { 0xE3, 0xB0, 0x96 },
	0xDCCB, { 0xE3, 0xB0, 0x90 },
	0xDCCC, { 0xE3, 0xB0, 0x89 },
	0xDCCD, { 0xE3, 0xB0, 0x8E },
	0xDCCE, { 0xE3, 0xB1, 0xBA },
	0xDCCF, { 0xE7, 0x80, 0xBD },
	0xDCD0, { 0xE3, 0xB6, 0x8C },
	0xDCD1, { 0xE7, 0x80, 0xB6 },
	0xDCD2, { 0xE3, 0xB6, 0x91 },
	0xDCD3, { 0xE7, 0x88, 0x96 },
	0xDCD4, { 0xE3, 0xB8, 0x8A },
	0xDCD5, { 0xE7, 0x88, 0x92 },
	0xDCD6, { 0xE7, 0x88, 0x8F },
	0xDCD7, { 0xE7, 0x88, 0x97 },
	0xDCD8, { 0xE7, 0x88, 0x91 },
	0xDCD9, { 0xE7, 0x88, 0x8B },
	0xDCDA, { 0xE3, 0xB8, 0x88 },
	0xDCDB, { 0xE3, 0xB8, 0x8B },
	0xDCDC, { 0xE7, 0x93, 0x8D },
	0xDCDD, { 0xE7, 0x93, 0x90 },
	0xDCDE, { 0xE7, 0x93, 0x8C },
	0xDCDF, { 0xE7, 0x93, 0x8E },
	0xDCE0, { 0xE7, 0x93, 0x91 },
	0xDCE1, { 0xE3, 0xBC, 0x87 },
	0xDCE2, { 0xE7, 0x96, 0x89 },
	0xDCE3, { 0xE4, 0x83, 0xB2 },
	0xDCE4, { 0xE7, 0xA9, 0xAF },
	0xDCE5, { 0xE7, 0xB1, 0x8B },
	0xDCE6, { 0xE7, 0xB1, 0x84 },
	0xDCE7, { 0xE7, 0xB1, 0x95 },
	0xDCE8, { 0xE4, 0x8A, 0xAE },
	0xDCE9, { 0xE4, 0x8C, 0xA4 },
	0xDCEA, { 0xE4, 0x8C, 0xA6 },
	0xDCEB, { 0xE4, 0x8C, 0xA7 },
	0xDCEC, { 0xE7, 0xB9, 0xBF },
	0xDCED, { 0xE8, 0xAD, 0xB1 },
	0xDCEE, { 0xE4, 0x8E, 0x99 },
	0xDCEF, { 0xE8, 0x80, 0xAF },
	0xDCF0, { 0xE8, 0x81, 0xBA },
	0xDCF1, { 0xE8, 0x81, 0xBB },
	0xDCF2, { 0xE8, 0x81, 0xBC },
	0xDCF3, { 0xE4, 0x95, 0x9F },
	0xDCF4, { 0xE4, 0x95, 0xAA },
	0xDCF5, { 0xE4, 0x95, 0xB1 },
	0xDCF6, { 0xE8, 0x97, 0xBC },
	0xDCF7, { 0xE8, 0x98, 0x90 },
	0xDCF8, { 0xE8, 0x98, 0x82 },
	0xDCF9, { 0xE4, 0x95, 0xAC },
	0xDCFA, { 0xE4, 0x95, 0xAF },
	0xDCFB, { 0xE8, 0x97, 0xAE },
	0xDCFC, { 0xE8, 0x98, 0x83 },
	0xDCFD, { 0xE4, 0x95, 0xA8 },
	0xDCFE, { 0xE8, 0x98, 0x8D },
	0xDDA1, { 0xE8, 0x98, 0x93 },
	0xDDA2, { 0xE8, 0x98, 0x88 },
	0xDDA3, { 0xE8, 0x98, 0x8F },
	0xDDA4, { 0xE8, 0xA0, 0x98 },
	0xDDA5, { 0xE8, 0xA0, 0x92 },
	0xDDA6, { 0xE4, 0x98, 0x81 },
	0xDDA7, { 0xE4, 0x99, 0xA8 },
	0xDDA8, { 0xE8, 0xA5, 0xA7 },
	0xDDA9, { 0xE8, 0xA5, 0xA5 },
	0xDDAA, { 0xE8, 0xA6, 0xBB },
	0xDDAB, { 0xE8, 0xAD, 0xA9 },
	0xDDAC, { 0xE8, 0xAD, 0xA2 },
	0xDDAD, { 0xE4, 0x9C, 0x93 },
	0xDDAE, { 0xE8, 0xAD, 0xAE },
	0xDDAF, { 0xE4, 0x9C, 0x96 },
	0xDDB0, { 0xE8, 0xAD, 0xA1 },
	0xDDB1, { 0xE4, 0x9C, 0x98 },
	0xDDB2, { 0xE8, 0xAD, 0xA4 },
	0xDDB3, { 0xE8, 0xAD, 0x8D },
	0xDDB4, { 0xE8, 0xB1, 0x91 },
	0xDDB5, { 0xE4, 0x9E, 0x89 },
	0xDDB6, { 0xE4, 0x9F, 0x88 },
	0xDDB7, { 0xE8, 0xBA, 0x83 },
	0xDDB8, { 0xE8, 0xBB, 0x86 },
	0xDDB9, { 0xE4, 0xA2, 0x84 },
	0xDDBA, { 0xE9, 0x90, 0x9F },
	0xDDBB, { 0xE4, 0xA5, 0x94 },
	0xDDBC, { 0xE9, 0x90, 0x84 },
	0xDDBD, { 0xE9, 0x90, 0x97 },
	0xDDBE, { 0xE9, 0x90, 0x88 },
	0xDDBF, { 0xE9, 0x90, 0x85 },
	0xDDC0, { 0xE4, 0xA5, 0x96 },
	0xDDC1, { 0xE9, 0x8F, 0xB3 },
	0xDDC2, { 0xE9, 0x90, 0x9E },
	0xDDC3, { 0xE9, 0x90, 0x82 },
	0xDDC4, { 0xE9, 0x90, 0x9A },
	0xDDC5, { 0xE9, 0x90, 0x9B },
	0xDDC6, { 0xE9, 0x90, 0xA7 },
	0xDDC7, { 0xE9, 0x90, 0x9C },
	0xDDC8, { 0xE4, 0xA5, 0x9A },
	0xDDC9, { 0xE9, 0x9A, 0xB5 },
	0xDDCA, { 0xE4, 0xA8, 0x85 },
	0xDDCB, { 0xE4, 0xA8, 0x87 },
	0xDDCC, { 0xE9, 0x9C, 0xB3 },
	0xDDCD, { 0xE4, 0xA8, 0xB1 },
	0xDDCE, { 0xE9, 0x9C, 0xB4 },
	0xDDCF, { 0xE9, 0x9C, 0xB1 },
	0xDDD0, { 0xE9, 0x9E, 0xB8 },
	0xDDD1, { 0xE9, 0x9E, 0xBA },
	0xDDD2, { 0xE4, 0xAA, 0xA3 },
	0xDDD3, { 0xE9, 0x9F, 0xBC },
	0xDDD4, { 0xE4, 0xAB, 0xAB },
	0xDDD5, { 0xE4, 0xAC, 0x9C },
	0xDDD6, { 0xE9, 0xA3, 0x83 },
	0xDDD7, { 0xE4, 0xAD, 0x9A },
	0xDDD8, { 0xE9, 0xA5, 0x8D },
	0xDDD9, { 0xE4, 0xAD, 0x9B },
	0xDDDA, { 0xE9, 0xA8, 0xAF },
	0xDDDB, { 0xE4, 0xAE, 0xA6 },
	0xDDDC, { 0xE4, 0xAE, 0xAA },
	0xDDDD, { 0xE4, 0xAE, 0xA5 },
	0xDDDE, { 0xE9, 0xAB, 0x89 },
	0xDDDF, { 0xE4, 0xAF, 0xA1 },
	0xDDE0, { 0xE9, 0xAB, 0x88 },
	0xDDE1, { 0xE9, 0xAB, 0x84 },
	0xDDE2, { 0xE9, 0xAC, 0xAA },
	0xDDE3, { 0xE9, 0xAC, 0xB8 },
	0xDDE4, { 0xE9, 0xAD, 0x90 },
	0xDDE5, { 0xE4, 0xB0, 0xAA },
	0xDDE6, { 0xE9, 0xB0, 0x8A },
	0xDDE7, { 0xE9, 0xAF, 0xBB },
	0xDDE8, { 0xE9, 0xB0, 0x84 },
	0xDDE9, { 0xE9, 0xAF, 0xBC },
	0xDDEA, { 0xE9, 0xAF, 0xBE },
	0xDDEB, { 0xE4, 0xB1, 0xB2 },
	0xDDEC, { 0xE4, 0xB1, 0xAF },
	0xDDED, { 0xE4, 0xB1, 0xB3 },
	0xDDEE, { 0xE9, 0xB0, 0x82 },
	0xDDEF, { 0xE9, 0xAF, 0xB6 },
	0xDDF0, { 0xE9, 0xB0, 0x9B },
	0xDDF1, { 0xE9, 0xAF, 0xB9 },
	0xDDF2, { 0xE9, 0xB0, 0x95 },
	0xDDF3, { 0xE9, 0xB0, 0x90 },
	0xDDF4, { 0xE9, 0xAF, 0xBF },
	0xDDF5, { 0xE9, 0xB0, 0x80 },
	0xDDF6, { 0xE9, 0xB0, 0x8C },
	0xDDF7, { 0xE4, 0xB1, 0xAB },
	0xDDF8, { 0xE4, 0xB3, 0xA6 },
	0xDDF9, { 0xE9, 0xB6, 0x95 },
	0xDDFA, { 0xE9, 0xB6, 0xA5 },
	0xDDFB, { 0xE4, 0xB3, 0xA9 },
	0xDDFC, { 0xE4, 0xB3, 0xAC },
	0xDDFD, { 0xE4, 0xB3, 0xA8 },
	0xDDFE, { 0xE4, 0xB3, 0xB0 },
	0xDEA1, { 0xE9, 0xBA, 0x98 },
	0xDEA2, { 0xE9, 0xBB, 0x81 },
	0xDEA3, { 0xE4, 0xB6, 0x8C },
	0xDEA4, { 0xE9, 0xBD, 0x9A },
	0xDEA5, { 0xE5, 0x85, 0xA4 },
	0xDEA6, { 0xE5, 0x9A, 0xBB },
	0xDEA7, { 0xE3, 0x98, 0x95 },
	0xDEA8, { 0xE5, 0xA3, 0xA6 },
	0xDEA9, { 0xE5, 0xAD, 0x89 },
	0xDEAA, { 0xE5, 0xAF, 0xB7 },
	0xDEAB, { 0xE3, 0x9D, 0xB1 },
	0xDEAC, { 0xE3, 0xA0, 0xA6 },
	0xDEAD, { 0xE5, 0xB7, 0x90 },
	0xDEAE, { 0xE3, 0xA3, 0x86 },
	0xDEAF, { 0xE5, 0xBF, 0x82 },
	0xDEB0, { 0xE3, 0xA6, 0xA8 },
	0xDEB1, { 0xE6, 0x94, 0x91 },
	0xDEB2, { 0xE3, 0xA9, 0xB3 },
	0xDEB3, { 0xE6, 0xAB, 0xBF },
	0xDEB4, { 0xE6, 0xAB, 0xBE },
	0xDEB5, { 0xE6, 0xAB, 0xBD },
	0xDEB6, { 0xE3, 0xB0, 0x95 },
	0xDEB7, { 0xE6, 0xAC, 0x81 },
	0xDEB8, { 0xE3, 0xB6, 0x98 },
	0xDEB9, { 0xE3, 0xB6, 0x97 },
	0xDEBA, { 0xE7, 0x81, 0x8B },
	0xDEBB, { 0xE7, 0x81, 0x8D },
	0xDEBC, { 0xE7, 0x81, 0x87 },
	0xDEBD, { 0xE7, 0x93, 0x93 },
	0xDEBE, { 0xE7, 0x99, 0xA8 },
	0xDEBF, { 0xE7, 0x99, 0xA7 },
	0xDEC0, { 0xE3, 0xBF, 0x97 },
	0xDEC1, { 0xE4, 0x82, 0x80 },
	0xDEC2, { 0xE7, 0x9F, 0x91 },
	0xDEC3, { 0xE7, 0xA4, 0xB0 },
	0xDEC4, { 0xE7, 0xA4, 0xB2 },
	0xDEC5, { 0xE7, 0xA4, 0xAE },
	0xDEC6, { 0xE4, 0x86, 0x88 },
	0xDEC7, { 0xE9, 0xBE, 0x9D },
	0xDEC8, { 0xE7, 0xAB, 0x89 },
	0xDEC9, { 0xE7, 0xAB, 0x88 },
	0xDECA, { 0xE4, 0x89, 0xA9 },
	0xDECB, { 0xE7, 0xB1, 0x96 },
	0xDECC, { 0xE7, 0xB1, 0x91 },
	0xDECD, { 0xE4, 0x89, 0xAB },
	0xDECE, { 0xE4, 0x8C, 0xA9 },
	0xDECF, { 0xE4, 0x8C, 0xA8 },
	0xDED0, { 0xE7, 0xBA, 0x85 },
	0xDED1, { 0xE7, 0xBA, 0x89 },
	0xDED2, { 0xE7, 0xBA, 0x8E },
	0xDED3, { 0xE7, 0xBA, 0x84 },
	0xDED4, { 0xE4, 0x91, 0x9F },
	0xDED5, { 0xE8, 0x89, 0xAA },
	0xDED6, { 0xE8, 0x98, 0xAB },
	0xDED7, { 0xE8, 0x98, 0xAF },
	0xDED8, { 0xE8, 0x98, 0xA8 },
	0xDED9, { 0xE4, 0x95, 0xB4 },
	0xDEDA, { 0xE8, 0x98, 0x96 },
	0xDEDB, { 0xE8, 0x98, 0x95 },
	0xDEDC, { 0xE8, 0x98, 0x9D },
	0xDEDD, { 0xE8, 0xA0, 0x9A },
	0xDEDE, { 0xE4, 0x98, 0x82 },
	0xDEDF, { 0xE4, 0x99, 0xAA },
	0xDEE0, { 0xE4, 0x9A, 0x94 },
	0xDEE1, { 0xE8, 0xA6, 0xBC },
	0xDEE2, { 0xE8, 0xAD, 0xB5 },
	0xDEE3, { 0xE8, 0xAD, 0xBC },
	0xDEE4, { 0xE4, 0x9E, 0x8A },
	0xDEE5, { 0xE8, 0xB4, 0x91 },
	0xDEE6, { 0xE8, 0xB4, 0x92 },
	0xDEE7, { 0xE8, 0xBD, 0x9C },
	0xDEE8, { 0xE9, 0x86, 0xBB },
	0xDEE9, { 0xE4, 0xA5, 0xA4 },
	0xDEEA, { 0xE9, 0x8F, 0xB4 },
	0xDEEB, { 0xE4, 0xA5, 0x9E },
	0xDEEC, { 0xE4, 0xA5, 0xA1 },
	0xDEED, { 0xE9, 0x90, 0xAD },
	0xDEEE, { 0xE4, 0xA5, 0xA5 },
	0xDEEF, { 0xE4, 0xA5, 0xA6 },
	0xDEF0, { 0xE9, 0x9B, 0xA4 },
	0xDEF1, { 0xE9, 0x9C, 0xB7 },
	0xDEF2, { 0xE9, 0x9C, 0xB6 },
	0xDEF3, { 0xE9, 0x9D, 0xA7 },
	0xDEF4, { 0xE9, 0x9E, 0xBE },
	0xDEF5, { 0xE9, 0x9E, 0xBD },
	0xDEF6, { 0xE9, 0x9F, 0xA2 },
	0xDEF7, { 0xE9, 0xA1, 0xA8 },
	0xDEF8, { 0xE9, 0xA1, 0xA6 },
	0xDEF9, { 0xE9, 0xA3, 0x88 },
	0xDEFA, { 0xE9, 0xA3, 0x8A },
	0xDEFB, { 0xE9, 0xA3, 0x87 },
	0xDEFC, { 0xE9, 0xA3, 0x9C },
	0xDEFD, { 0xE4, 0xAD, 0x9F },
	0xDEFE, { 0xE9, 0xA5, 0x8F },
	0xDFA1, { 0xE9, 0xA6, 0xA9 },
	0xDFA2, { 0xE9, 0xA8, 0xBC },
	0xDFA3, { 0xE4, 0xAE, 0xAF },
	0xDFA4, { 0xE9, 0xA8, 0xBB },
	0xDFA5, { 0xE9, 0xAB, 0x8E },
	0xDFA6, { 0xE4, 0xB0, 0x8D },
	0xDFA7, { 0xE9, 0xAC, 0x94 },
	0xDFA8, { 0xE9, 0xAD, 0x93 },
	0xDFA9, { 0xE4, 0xB1, 0xBC },
	0xDFAA, { 0xE9, 0xB0, 0xAE },
	0xDFAB, { 0xE4, 0xB1, 0xBA },
	0xDFAC, { 0xE9, 0xB0, 0x9F },
	0xDFAD, { 0xE4, 0xB1, 0xB6 },
	0xDFAE, { 0xE4, 0xB1, 0xB9 },
	0xDFAF, { 0xE4, 0xB1, 0xBD },
	0xDFB0, { 0xE4, 0xB1, 0xB7 },
	0xDFB1, { 0xE9, 0xB6, 0xB0 },
	0xDFB2, { 0xE9, 0xB6, 0xBD },
	0xDFB3, { 0xE4, 0xB3, 0xB6 },
	0xDFB4, { 0xE4, 0xB3, 0xB1 },
	0xDFB5, { 0xE9, 0xB6, 0xAE },
	0xDFB6, { 0xE9, 0xB7, 0x84 },
	0xDFB7, { 0xE9, 0xB9, 0xBB },
	0xDFB8, { 0xE4, 0x80, 0x8B },
	0xDFB9, { 0xE4, 0xB4, 0xA9 },
	0xDFBA, { 0xE9, 0xBA, 0x9E },
	0xDFBB, { 0xE4, 0xB5, 0xAF },
	0xDFBC, { 0xE9, 0xBC, 0x85 },
	0xDFBD, { 0xE4, 0xB6, 0x9A },
	0xDFBE, { 0xE9, 0xBD, 0xA9 },
	0xDFBF, { 0xE9, 0xBE, 0xA1 },
	0xDFC0, { 0xE5, 0x9B, 0x87 },
	0xDFC1, { 0xE5, 0x9C, 0x9D },
	0xDFC2, { 0xE5, 0xAD, 0x8A },
	0xDFC3, { 0xE5, 0xB7, 0x93 },
	0xDFC4, { 0xE3, 0xA1, 0xA9 },
	0xDFC5, { 0xE5, 0xBD, 0xB2 },
	0xDFC6, { 0xE6, 0x88, 0x82 },
	0xDFC7, { 0xE3, 0xA6, 0xAB },
	0xDFC8, { 0xE6, 0x88, 0xB5 },
	0xDFC9, { 0xE6, 0x94, 0xA7 },
	0xDFCA, { 0xE6, 0x94, 0x9E },
	0xDFCB, { 0xE6, 0x94, 0x9F },
	0xDFCC, { 0xE3, 0xAC, 0xAC },
	0xDFCD, { 0xE3, 0xAC, 0xAD },
	0xDFCE, { 0xE6, 0xAC, 0x87 },
	0xDFCF, { 0xE6, 0xAC, 0x86 },
	0xDFD0, { 0xE3, 0xB0, 0x97 },
	0xDFD1, { 0xE3, 0xB6, 0x9A },
	0xDFD2, { 0xE7, 0x81, 0x94 },
	0xDFD3, { 0xE7, 0x88, 0x9C },
	0xDFD4, { 0xE7, 0x88, 0xA0 },
	0xDFD5, { 0xE7, 0xAB, 0xB8 },
	0xDFD6, { 0xE4, 0x89, 0xAE },
	0xDFD7, { 0xE7, 0xB1, 0x9D },
	0xDFD8, { 0xE7, 0xB1, 0x98 },
	0xDFD9, { 0xE4, 0x8C, 0xAC },
	0xDFDA, { 0xE7, 0xBA, 0x92 },
	0xDFDB, { 0xE7, 0xBD, 0x8E },
	0xDFDC, { 0xE4, 0x8F, 0x8A },
	0xDFDD, { 0xE4, 0x95, 0xB8 },
	0xDFDE, { 0xE4, 0x98, 0x86 },
	0xDFDF, { 0xE8, 0xA0, 0xA7 },
	0xDFE0, { 0xE4, 0x98, 0x87 },
	0xDFE1, { 0xE8, 0xAE, 0x81 },
	0xDFE2, { 0xE8, 0xAE, 0x83 },
	0xDFE3, { 0xE4, 0x9C, 0xA0 },
	0xDFE4, { 0xE8, 0xB1, 0x84 },
	0xDFE5, { 0xE4, 0x9D, 0x93 },
	0xDFE6, { 0xE4, 0x9F, 0x8E },
	0xDFE7, { 0xE4, 0xA1, 0xBA },
	0xDFE8, { 0xE4, 0xA1, 0xB9 },
	0xDFE9, { 0xE9, 0x91, 0x82 },
	0xDFEA, { 0xE9, 0x91, 0x8D },
	0xDFEB, { 0xE9, 0x91, 0x94 },
	0xDFEC, { 0xE9, 0x91, 0x8E },
	0xDFED, { 0xE4, 0xA5, 0xAB },
	0xDFEE, { 0xE9, 0x91, 0x83 },
	0xDFEF, { 0xE4, 0xA5, 0xA7 },
	0xDFF0, { 0xE4, 0xA5, 0xAD },
	0xDFF1, { 0xE9, 0x9C, 0xBC },
	0xDFF2, { 0xE9, 0x9D, 0x80 },
	0xDFF3, { 0xE9, 0x9F, 0x80 },
	0xDFF4, { 0xE4, 0xAA, 0x85 },
	0xDFF5, { 0xE4, 0xAA, 0xB0 },
	0xDFF6, { 0xE4, 0xAB, 0xB3 },
	0xDFF7, { 0xE4, 0xAD, 0xA3 },
	0xDFF8, { 0xE9, 0xA5, 0x9A },
	0xDFF9, { 0xE9, 0xA9, 0x91 },
	0xDFFA, { 0xE4, 0xAE, 0xB6 },
	0xDFFB, { 0xE9, 0xAB, 0x9D },
	0xDFFC, { 0xE4, 0xB2, 0x82 },
	0xDFFD, { 0xE4, 0xB1, 0xBF },
	0xDFFE, { 0xE9, 0xB0, 0xB8 },
	0xE0A1, { 0xE4, 0xB2, 0x86 },
	0xE0A2, { 0xE9, 0xB1, 0x85 },
	0xE0A3, { 0xE9, 0xB0, 0xBA },
	0xE0A4, { 0xE4, 0xB2, 0x84 },
	0xE0A5, { 0xE9, 0xB0, 0xB5 },
	0xE0A6, { 0xE4, 0xB3, 0xBC },
	0xE0A7, { 0xE4, 0xB3, 0xBD },
	0xE0A8, { 0xE4, 0xB3, 0xBA },
	0xE0A9, { 0xE9, 0xBB, 0xB1 },
	0xE0AA, { 0xE4, 0xB6, 0x87 },
	0xE0AB, { 0xE9, 0xBE, 0x93 },
	0xE0AC, { 0xE5, 0x8A, 0x9A },
	0xE0AD, { 0xE3, 0x98, 0x9A },
	0xE0AE, { 0xE3, 0x98, 0x99 },
	0xE0AF, { 0xE8, 0x99, 0x81 },
	0xE0B0, { 0xE5, 0xB7, 0x97 },
	0xE0B1, { 0xE3, 0xA9, 0xB5 },
	0xE0B2, { 0xE6, 0x94, 0xA8 },
	0xE0B3, { 0xE3, 0xB0, 0x9A },
	0xE0B4, { 0xE3, 0xB0, 0x9B },
	0xE0B5, { 0xE3, 0xB0, 0x99 },
	0xE0B6, { 0xE7, 0x81, 0x93 },
	0xE0B7, { 0xE7, 0x81, 0x99 },
	0xE0B8, { 0xE3, 0xB6, 0x9C },
	0xE0B9, { 0xE7, 0x88, 0xA1 },
	0xE0BA, { 0xE3, 0xB8, 0x90 },
	0xE0BB, { 0xE7, 0x99, 0xAF },
	0xE0BC, { 0xE7, 0xA4, 0xB7 },
	0xE0BD, { 0xE7, 0xA6, 0xB5 },
	0xE0BE, { 0xE7, 0xB1, 0xA2 },
	0xE0BF, { 0xE7, 0xB1, 0x9E },
	0xE0C0, { 0xE7, 0xB3, 0xB5 },
	0xE0C1, { 0xE4, 0x95, 0xBB },
	0xE0C2, { 0xE4, 0x95, 0xBC },
	0xE0C3, { 0xE8, 0x98, 0xBD },
	0xE0C4, { 0xE4, 0x98, 0x88 },
	0xE0C5, { 0xE8, 0xA0, 0xAD },
	0xE0C6, { 0xE8, 0xA6, 0x89 },
	0xE0C7, { 0xE8, 0xAE, 0x8D },
	0xE0C8, { 0xE8, 0xAE, 0x87 },
	0xE0C9, { 0xE8, 0xAE, 0x90 },
	0xE0CA, { 0xE8, 0xB4, 0x9A },
	0xE0CB, { 0xE8, 0xBA, 0x99 },
	0xE0CC, { 0xE4, 0xA1, 0x81 },
	0xE0CD, { 0xE4, 0xA3, 0xA3 },
	0xE0CE, { 0xE4, 0xA5, 0xB2 },
	0xE0CF, { 0xE9, 0x91, 0x9F },
	0xE0D0, { 0xE4, 0xA5, 0xB3 },
	0xE0D1, { 0xE4, 0xA5, 0xA8 },
	0xE0D2, { 0xE9, 0x91, 0x96 },
	0xE0D3, { 0xE9, 0x91, 0xA1 },
	0xE0D4, { 0xE9, 0x91, 0x9B },
	0xE0D5, { 0xE9, 0x91, 0x9A },
	0xE0D6, { 0xE9, 0x91, 0x9C },
	0xE0D7, { 0xE9, 0x91, 0xA5 },
	0xE0D8, { 0xE4, 0xA8, 0xB5 },
	0xE0D9, { 0xE9, 0x9D, 0x81 },
	0xE0DA, { 0xE4, 0xAA, 0x88 },
	0xE0DB, { 0xE4, 0xAA, 0x9D },
	0xE0DC, { 0xE9, 0xA1, 0xAE },
	0xE0DD, { 0xE9, 0xA1, 0xAC },
	0xE0DE, { 0xE9, 0xA1, 0xAD },
	0xE0DF, { 0xE4, 0x89, 0xB5 },
	0xE0E0, { 0xE9, 0xA6, 0xAA },
	0xE0E1, { 0xE9, 0xA9, 0x9C },
	0xE0E2, { 0xE9, 0xA9, 0x98 },
	0xE0E3, { 0xE9, 0xAB, 0x9E },
	0xE0E4, { 0xE4, 0xB2, 0x8F },
	0xE0E5, { 0xE9, 0xB1, 0x8F },
	0xE0E6, { 0xE9, 0xB1, 0x91 },
	0xE0E7, { 0xE4, 0xB2, 0x8E },
	0xE0E8, { 0xE9, 0xB1, 0x93 },
	0xE0E9, { 0xE4, 0xB4, 0x85 },
	0xE0EA, { 0xE4, 0xB4, 0x84 },
	0xE0EB, { 0xE4, 0xB3, 0xBF },
	0xE0EC, { 0xE9, 0xB7, 0xBC },
	0xE0ED, { 0xE9, 0xBC, 0xB9 },
	0xE0EE, { 0xE4, 0xB6, 0x9E },
	0xE0EF, { 0xE5, 0x84, 0xBE },
	0xE0F0, { 0xE3, 0x95, 0x94 },
	0xE0F1, { 0xE5, 0x9B, 0x92 },
	0xE0F2, { 0xE3, 0x9A, 0x81 },
	0xE0F3, { 0xE5, 0xAD, 0x8F },
	0xE0F4, { 0xE6, 0xAC, 0x94 },
	0xE0F5, { 0xE4, 0x83, 0xBA },
	0xE0F6, { 0xE7, 0xA9, 0xB2 },
	0xE0F7, { 0xE7, 0xA9, 0xB3 },
	0xE0F8, { 0xE4, 0x8C, 0xB2 },
	0xE0F9, { 0xE4, 0x99, 0xB0 },
	0xE0FA, { 0xE4, 0x99, 0xAE },
	0xE0FB, { 0xE8, 0xAE, 0x91 },
	0xE0FC, { 0xF0, 0xAF, 0xA7, 0x96 },
	0xE0FD, { 0xE4, 0xA1, 0xBC },
	0xE0FE, { 0xE9, 0x86, 0xBF },
	0xE1A1, { 0xE4, 0xA5, 0xB5 },
	0xE1A2, { 0xE9, 0x91, 0xAC },
	0xE1A3, { 0xE4, 0xA5, 0xB4 },
	0xE1A4, { 0xE4, 0xA5, 0xB7 },
	0xE1A5, { 0xE9, 0x9B, 0xA6 },
	0xE1A6, { 0xE9, 0x9D, 0x85 },
	0xE1A7, { 0xE4, 0xA8, 0xB7 },
	0xE1A8, { 0xE9, 0x9F, 0x88 },
	0xE1A9, { 0xE9, 0x9F, 0xA4 },
	0xE1AA, { 0xE9, 0xA5, 0x9D },
	0xE1AB, { 0xE4, 0xAE, 0xBA },
	0xE1AC, { 0xE9, 0xAC, 0xA1 },
	0xE1AD, { 0xE4, 0xB0, 0x91 },
	0xE1AE, { 0xE9, 0xAC, 0xAC },
	0xE1AF, { 0xE9, 0xAD, 0x97 },
	0xE1B0, { 0xE4, 0xB2, 0x92 },
	0xE1B1, { 0xE4, 0xB2, 0x99 },
	0xE1B2, { 0xE9, 0xB1, 0x9D },
	0xE1B3, { 0xE9, 0xB1, 0xA1 },
	0xE1B4, { 0xE9, 0xB1, 0xA5 },
	0xE1B5, { 0xE9, 0xB8, 0x88 },
	0xE1B6, { 0xE4, 0xB4, 0x8A },
	0xE1B7, { 0xE4, 0xB4, 0xAA },
	0xE1B8, { 0xE4, 0xB4, 0xAB },
	0xE1B9, { 0xE4, 0xB5, 0x84 },
	0xE1BA, { 0xE4, 0xB5, 0xB9 },
	0xE1BB, { 0xE9, 0xBD, 0x85 },
	0xE1BC, { 0xE3, 0x92, 0xAA },
	0xE1BD, { 0xE3, 0x9D, 0x88 },
	0xE1BE, { 0xE6, 0x88, 0x85 },
	0xE1BF, { 0xE6, 0x9B, 0xAF },
	0xE1C0, { 0xE6, 0xAC, 0x9B },
	0xE1C1, { 0xE6, 0xAC, 0x9D },
	0xE1C2, { 0xE7, 0x88, 0xA5 },
	0xE1C3, { 0xE7, 0x88, 0xA4 },
	0xE1C4, { 0xE7, 0xB1, 0xAD },
	0xE1C5, { 0xE4, 0x8A, 0xB4 },
	0xE1C6, { 0xE8, 0x99, 0x82 },
	0xE1C7, { 0xE8, 0x99, 0x89 },
	0xE1C8, { 0xE4, 0x98, 0x8D },
	0xE1C9, { 0xE8, 0xA5, 0xB8 },
	0xE1CA, { 0xE8, 0xA6, 0x8A },
	0xE1CB, { 0xE8, 0xAE, 0x97 },
	0xE1CC, { 0xE4, 0x9D, 0x94 },
	0xE1CD, { 0xE8, 0xB2, 0x9B },
	0xE1CE, { 0xE8, 0xB4, 0x9C },
	0xE1CF, { 0xE4, 0xA0, 0xB0 },
	0xE1D0, { 0xE8, 0xBA, 0xA2 },
	0xE1D1, { 0xE4, 0xA8, 0x89 },
	0xE1D2, { 0xE4, 0xA8, 0xB8 },
	0xE1D3, { 0xE4, 0xA8, 0xB6 },
	0xE1D4, { 0xE4, 0xAA, 0x8B },
	0xE1D5, { 0xE4, 0xAB, 0xB7 },
	0xE1D6, { 0xE4, 0xAD, 0xA6 },
	0xE1D7, { 0xE4, 0xAE, 0xBD },
	0xE1D8, { 0xE4, 0xB0, 0x9E },
	0xE1D9, { 0xE9, 0xB1, 0xAC },
	0xE1DA, { 0xE4, 0xB2, 0x96 },
	0xE1DB, { 0xE9, 0xB1, 0xAF },
	0xE1DC, { 0xE4, 0xB4, 0x8D },
	0xE1DD, { 0xE9, 0xB8, 0x8E },
	0xE1DE, { 0xE4, 0xB5, 0xB3 },
	0xE1DF, { 0xE9, 0xBC, 0x88 },
	0xE1E0, { 0xE9, 0xBC, 0x9D },
	0xE1E1, { 0xE9, 0xBE, 0xA3 },
	0xE1E2, { 0xE3, 0x9C, 0xBB },
	0xE1E3, { 0xE3, 0x9C, 0xBC },
	0xE1E4, { 0xE5, 0xBD, 0xA0 },
	0xE1E5, { 0xE6, 0xAC, 0x9C },
	0xE1E6, { 0xE3, 0xB6, 0xA0 },
	0xE1E7, { 0xE4, 0x83, 0xBB },
	0xE1E9, { 0xE7, 0xB3, 0xB3 },
	0xE1EA, { 0xE4, 0x96, 0x81 },
	0xE1EB, { 0xE8, 0xAE, 0x9B },
	0xE1EC, { 0xE8, 0xBA, 0xA7 },
	0xE1ED, { 0xE9, 0x87, 0x84 },
	0xE1EE, { 0xE4, 0xA5, 0xB8 },
	0xE1EF, { 0xE9, 0x91, 0xBA },
	0xE1F0, { 0xE4, 0xAA, 0x8D },
	0xE1F1, { 0xE4, 0xAD, 0xB3 },
	0xE1F2, { 0xE9, 0xA9, 0xA1 },
	0xE1F3, { 0xE9, 0xA9, 0xA3 },
	0xE1F4, { 0xE9, 0xAB, 0x97 },
	0xE1F5, { 0xE9, 0xB1, 0xB6 },
	0xE1F6, { 0xE4, 0xB6, 0xA6 },
	0xE1F7, { 0xE9, 0xBE, 0xA5 },
	0xE1F8, { 0xE3, 0xA6, 0xAD },
	0xE1F9, { 0xE7, 0x81, 0xA7 },
	0xE1FA, { 0xE3, 0xB8, 0x91 },
	0xE1FB, { 0xE7, 0x8A, 0xAB },
	0xE1FC, { 0xE8, 0x99, 0x8A },
	0xE1FD, { 0xE8, 0xA5, 0xBD },
	0xE1FE, { 0xE8, 0xAE, 0x9D },
	0xE2A1, { 0xE8, 0xB1, 0x93 },
	0xE2A2, { 0xE8, 0xBD, 0xA5 },
	0xE2A3, { 0xE9, 0x91, 0xBB },
	0xE2A4, { 0xE4, 0xA8, 0xB9 },
	0xE2A5, { 0xE9, 0xA3, 0x8D },
	0xE2A6, { 0xE9, 0xA3, 0x9D },
	0xE2A7, { 0xE4, 0xAE, 0xBF },
	0xE2A8, { 0xE9, 0xAC, 0xB0 },
	0xE2A9, { 0xE9, 0xB8, 0x96 },
	0xE2AA, { 0xE4, 0xB4, 0x8F },
	0xE2AB, { 0xE4, 0xB6, 0xA7 },
	0xE2AC, { 0xE4, 0xB6, 0xB5 },
	0xE2AD, { 0xE3, 0xBF, 0x9C },
	0xE2AE, { 0xE4, 0xA0, 0xB1 },
	0xE2AF, { 0xE9, 0x9B, 0xA7 },
	0xE2B0, { 0xE9, 0xB8, 0x98 },
	0xE2B1, { 0xE9, 0xBA, 0xA2 },
	0xE2B2, { 0xE4, 0xB6, 0xA8 },
	0xE2B3, { 0xE9, 0xBD, 0xBC },
	0xE2B4, { 0xE4, 0x84, 0xA5 },
	0xE2B5, { 0xE7, 0xBA, 0x9E },
	0xE2B6, { 0xE9, 0x92, 0x84 },
	0xE2B7, { 0xE4, 0xAF, 0x81 },
	0xE2B8, { 0xE9, 0xB8, 0x9C },
	0xE2B9, { 0xE4, 0x86, 0x90 },
	0xE2BA, { 0xE7, 0xB1, 0xB1 },
	0xE2BB, { 0xE9, 0x9F, 0x8A },
	0xE2BC, { 0xE4, 0x9A, 0x96 },
	0xE2BD, { 0xE4, 0xA1, 0xBF },
	0xE2BE, { 0xE4, 0xB4, 0x90 },
	0xE2BF, { 0xE9, 0xBA, 0xA3 },
	0xE2C0, { 0xE4, 0xA8, 0x8A },
	0xE2C1, { 0xE9, 0xB1, 0xBB },
	0xE2C2, { 0xE9, 0xBE, 0x97 },
	0xE2C3, { 0xE4, 0xB4, 0x92 },
	0xE2C4, { 0xE4, 0xA8, 0xBA },
	0xE2C5, { 0xE9, 0x9D, 0x90 },
	0xE2C6, { 0xE4, 0xA8, 0xBB },
	0xE4C8, { 0xE4, 0xBD, 0xA6 },
	0xE4C9, { 0xE4, 0xBD, 0xA8 },
	0xE4CA, { 0xE4, 0xBF, 0xA7 },
	0xE4CB, { 0xE5, 0x80, 0xBF },
	0xE4CD, { 0xE5, 0x82, 0xA6 },
	0xE4CE, { 0xE5, 0x84, 0x8F },
	0xE4CF, { 0xE5, 0x88, 0xBE },
	0xE4D0, { 0xE5, 0x8C, 0xA4 },
	0xE4D1, { 0xE5, 0x8D, 0xA5 },
	0xE4D2, { 0xE5, 0x8E, 0x9B },
	0xE4D3, { 0xE5, 0x85, 0xBF },
	0xE4D4, { 0xE5, 0x93, 0x8B },
	0xE4D5, { 0xE5, 0x95, 0xB3 },
	0xE4D6, { 0xE5, 0x95, 0xB1 },
	0xE4D7, { 0xE5, 0x95, 0xAB },
	0xE4D8, { 0xE5, 0x97, 0xB4 },
	0xE4D9, { 0xE5, 0x98, 0xA2 },
	0xE4DA, { 0xE5, 0x98, 0xA0 },
	0xE4DB, { 0xE5, 0x9A, 0x92 },
	0xE4DC, { 0xE5, 0x9A, 0xBA },
	0xE4DD, { 0xE5, 0x9A, 0x91 },
	0xE4DE, { 0xE5, 0x9A, 0xB0 },
	0xE4DF, { 0xE5, 0x9D, 0x99 },
	0xE4E0, { 0xE5, 0x9E, 0x8A },
	0xE4E1, { 0xE5, 0xA0, 0x8F },
	0xE4E2, { 0xE5, 0xA0, 0x92 },
	0xE4E3, { 0xE5, 0xA0, 0x93 },
	0xE4E4, { 0xE5, 0xA1, 0x87 },
	0xE4E5, { 0xE5, 0xA2, 0x9B },
	0xE4E6, { 0xE5, 0xA4, 0x80 },
	0xE4E7, { 0xE5, 0xA5, 0x8D },
	0xE4E8, { 0xE5, 0xAB, 0x91 },
	0xE4E9, { 0xE5, 0xAB, 0x93 },
	0xE4EA, { 0xE5, 0xAD, 0xA7 },
	0xE4EB, { 0xE5, 0xB1, 0x97 },
	0xE4EC, { 0xE5, 0xB1, 0xB7 },
	0xE4ED, { 0xE5, 0xB3, 0x95 },
	0xE4EE, { 0xE5, 0xB5, 0xB5 },
	0xE4EF, { 0xE5, 0xB6, 0x8E },
	0xE4F0, { 0xE5, 0xB6, 0xA5 },
	0xE4F1, { 0xE5, 0xB6, 0xB6 },
	0xE4F2, { 0xE5, 0xB6, 0xBF },
	0xE4F3, { 0xE5, 0xB9, 0xA5 },
	0xE4F4, { 0xE5, 0xBB, 0x8D },
	0xE4F5, { 0xE5, 0xBB, 0xAD },
	0xE4F6, { 0xE5, 0xBE, 0x94 },
	0xE4F7, { 0xE5, 0xBE, 0x9A },
	0xE4F8, { 0xE5, 0xBE, 0xBA },
	0xE4F9, { 0xE6, 0x84, 0xA5 },
	0xE4FA, { 0xE6, 0x85, 0x90 },
	0xE4FB, { 0xE6, 0x8A, 0xA3 },
	0xE4FC, { 0xE6, 0x8D, 0xA0 },
	0xE4FD, { 0xE6, 0x8D, 0xA4 },
	0xE4FE, { 0xE6, 0x8E, 0xB6 },
	0xE5A1, { 0xE6, 0x90, 0x83 },
	0xE5A2, { 0xE6, 0x92, 0xB6 },
	0xE5A3, { 0xE6, 0x94, 0x9A },
	0xE5A4, { 0xE7, 0xA8, 0xA5 },
	0xE5A5, { 0xE5, 0xB0, 0xA1 },
	0xE5A6, { 0xE6, 0x9B, 0xA2 },
	0xE5A7, { 0xE6, 0x9C, 0x82 },
	0xE5A8, { 0xE6, 0x9E, 0xA4 },
	0xE5A9, { 0xE6, 0x9E, 0xAC },
	0xE5AA, { 0xE6, 0xA0, 0x90 },
	0xE5AB, { 0xE6, 0xA0, 0x86 },
	0xE5AC, { 0xE6, 0xA1, 0x9E },
	0xE5AD, { 0xE6, 0xA1, 0x9A },
	0xE5AE, { 0xE6, 0xA4, 0xAC },
	0xE5AF, { 0xE6, 0xA4, 0xA9 },
	0xE5B0, { 0xE6, 0xA8, 0xAD },
	0xE5B1, { 0xE6, 0xA9, 0xB7 },
	0xE5B2, { 0xE6, 0xA9, 0xBA },
	0xE5B3, { 0xE6, 0xAB, 0x8A },
	0xE5B4, { 0xE6, 0xAB, 0xA6 },
	0xE5B5, { 0xE6, 0xAB, 0xB5 },
	0xE5B6, { 0xE6, 0xAC, 0x8D },
	0xE5B7, { 0xE6, 0xAC, 0x8E },
	0xE5B8, { 0xE6, 0xAF, 0x9C },
	0xE5B9, { 0xE6, 0xAF, 0x9D },
	0xE5BA, { 0xE6, 0xAF, 0xB6 },
	0xE5BB, { 0xE6, 0xB0, 0x9E },
	0xE5BC, { 0xE6, 0xB1, 0xA3 },
	0xE5BD, { 0xE6, 0xB6, 0xA5 },
	0xE5BE, { 0xE6, 0xB8, 0x8F },
	0xE5BF, { 0xE6, 0xBA, 0x8A },
	0xE5C0, { 0xE6, 0xBA, 0x84 },
	0xE5C1, { 0xE6, 0xBA, 0x8B },
	0xE5C2, { 0xE6, 0xB9, 0xBC },
	0xE5C3, { 0xE6, 0xBD, 0x8C },
	0xE5C4, { 0xE6, 0xBD, 0x88 },
	0xE5C5, { 0xE6, 0xBD, 0x89 },
	0xE5C6, { 0xE6, 0xBE, 0x9D },
	0xE5C7, { 0xE6, 0xBE, 0x99 },
	0xE5C8, { 0xE6, 0xBF, 0xB8 },
	0xE5C9, { 0xE7, 0x80, 0xAE },
	0xE5CA, { 0xE7, 0x80, 0xAD },
	0xE5CB, { 0xE7, 0x81, 0x9C },
	0xE5CC, { 0xE7, 0xA7, 0x8C },
	0xE5CD, { 0xE7, 0x82, 0xBF },
	0xE5CE, { 0xE7, 0x83, 0xAA },
	0xE5CF, { 0xE7, 0x83, 0xA5 },
	0xE5D0, { 0xE7, 0x84, 0x91 },
	0xE5D1, { 0xE7, 0x84, 0x92 },
	0xE5D2, { 0xE7, 0x84, 0xBF },
	0xE5D3, { 0xE7, 0x84, 0xB9 },
	0xE5D4, { 0xE7, 0x84, 0xBB },
	0xE5D5, { 0xE7, 0x84, 0xBD },
	0xE5D6, { 0xE7, 0x85, 0xB7 },
	0xE5D7, { 0xE7, 0x85, 0xB5 },
	0xE5D8, { 0xE7, 0x85, 0xB6 },
	0xE5D9, { 0xE7, 0x85, 0xB1 },
	0xE5DA, { 0xE7, 0x86, 0x96 },
	0xE5DB, { 0xE7, 0x86, 0x93 },
	0xE5DC, { 0xE7, 0x86, 0xB4 },
	0xE5DD, { 0xE7, 0x87, 0x9D },
	0xE5DE, { 0xE7, 0x87, 0x9E },
	0xE5DF, { 0xE7, 0x88, 0x8E },
	0xE5E0, { 0xE5, 0xA4, 0x91 },
	0xE5E1, { 0xE7, 0x88, 0x98 },
	0xE5E2, { 0xE7, 0x8D, 0x87 },
	0xE5E3, { 0xE7, 0x8D, 0x88 },
	0xE5E4, { 0xE7, 0x8F, 0xAF },
	0xE5E5, { 0xE7, 0x90, 0x92 },
	0xE5E6, { 0xE7, 0x90, 0xBB },
	0xE5E7, { 0xE7, 0x92, 0xA4 },
	0xE5E8, { 0xE7, 0x92, 0x8D },
	0xE5E9, { 0xE7, 0x92, 0xB4 },
	0xE5EA, { 0xE7, 0x99, 0xB3 },
	0xE5EB, { 0xE7, 0x99, 0xB7 },
	0xE5EC, { 0xE7, 0x9A, 0xBC },
	0xE5ED, { 0xE7, 0xA0, 0x99 },
	0xE5EE, { 0xE7, 0xA0, 0x9B },
	0xE5EF, { 0xE7, 0xA0, 0xBD },
	0xE5F0, { 0xE7, 0xA1, 0x93 },
	0xE5F1, { 0xE7, 0xA1, 0x94 },
	0xE5F2, { 0xE7, 0xA1, 0x98 },
	0xE5F3, { 0xE7, 0xA2, 0xB7 },
	0xE5F4, { 0xE7, 0xA3, 0x98 },
	0xE5F5, { 0xE7, 0xA3, 0xAE },
	0xE5F6, { 0xE7, 0xA4, 0xA2 },
	0xE5F7, { 0xE7, 0xA5, 0x8D },
	0xE5F8, { 0xE7, 0xA6, 0x86 },
	0xE5F9, { 0xE7, 0xA6, 0x99 },
	0xE5FA, { 0xE7, 0xA6, 0xA3 },
	0xE5FB, { 0xE7, 0xA6, 0xBC },
	0xE5FC, { 0xE7, 0xAA, 0xA7 },
	0xE5FD, { 0xE7, 0xAC, 0xB7 },
	0xE5FE, { 0xE7, 0xAD, 0x99 },
	0xE6A1, { 0xE7, 0xAF, 0x90 },
	0xE6A2, { 0xE7, 0xB0, 0xAF },
	0xE6A3, { 0xE7, 0xB0, 0xB2 },
	0xE6A4, { 0xE7, 0xB1, 0x82 },
	0xE6A5, { 0xE7, 0xB1, 0x8E },
	0xE6A6, { 0xE7, 0xB1, 0xA8 },
	0xE6A7, { 0xE7, 0xB2, 0xA9 },
	0xE6A8, { 0xE7, 0xB3, 0xAD },
	0xE6A9, { 0xE7, 0xB7, 0x90 },
	0xE6AA, { 0xE7, 0xB8, 0x87 },
	0xE6AB, { 0xE7, 0xB7, 0x93 },
	0xE6AC, { 0xE7, 0xB9, 0xA4 },
	0xE6AD, { 0xE7, 0xBD, 0x80 },
	0xE6AF, { 0xE8, 0x81, 0x81 },
	0xE6B0, { 0xE8, 0x81, 0xA3 },
	0xE6B1, { 0xE8, 0x82, 0xBB },
	0xE6B2, { 0xE6, 0x9C, 0x91 },
	0xE6B3, { 0xE6, 0x9C, 0xA5 },
	0xE6B4, { 0xE8, 0x89, 0x88 },
	0xE6B5, { 0xE8, 0x8C, 0x90 },
	0xE6B6, { 0xE8, 0x8D, 0xA2 },
	0xE6B7, { 0xE8, 0x8C, 0x92 },
	0xE6B8, { 0xE8, 0x90, 0xA1 },
	0xE6B9, { 0xE8, 0x90, 0x9E },
	0xE6BA, { 0xE8, 0x93, 0xA2 },
	0xE6BB, { 0xE8, 0x93, 0x9E },
	0xE6BC, { 0xE8, 0x93, 0xA1 },
	0xE6BD, { 0xE8, 0x95, 0xB3 },
	0xE6BE, { 0xE8, 0x97, 0x94 },
	0xE6BF, { 0xE8, 0x97, 0xB5 },
	0xE6C0, { 0xE8, 0x98, 0xB7 },
	0xE6C1, { 0xE8, 0x99, 0x85 },
	0xE6C2, { 0xE8, 0x99, 0xB2 },
	0xE6C3, { 0xE8, 0x9D, 0x8A },
	0xE6C4, { 0xE8, 0x9E, 0xA9 },
	0xE6C5, { 0xE8, 0x9E, 0xA5 },
	0xE6C6, { 0xE8, 0x9F, 0xB5 },
	0xE6C7, { 0xE8, 0xA0, 0xB4 },
	0xE6C8, { 0xE8, 0xA1, 0x90 },
	0xE6C9, { 0xE8, 0xA2, 0x87 },
	0xE6CA, { 0xE8, 0xA5, 0x94 },
	0xE6CB, { 0xE8, 0xA6, 0x84 },
	0xE6CC, { 0xE8, 0xAC, 0x83 },
	0xE6CD, { 0xE8, 0xB1, 0x92 },
	0xE6CE, { 0xE8, 0xB3, 0x98 },
	0xE6CF, { 0xE8, 0xB4, 0x8C },
	0xE6D0, { 0xE8, 0xB4, 0x98 },
	0xE6D1, { 0xE8, 0xB6, 0xB0 },
	0xE6D2, { 0xE8, 0xBA, 0xBC },
	0xE6D3, { 0xE8, 0xBB, 0x95 },
	0xE6D4, { 0xE8, 0xBE, 0xAA },
	0xE6D5, { 0xE9, 0x82, 0x9C },
	0xE6D7, { 0xE9, 0x85, 0x9C },
	0xE6D8, { 0xE9, 0x88, 0xAB },
	0xE6D9, { 0xE9, 0x88, 0xA1 },
	0xE6DA, { 0xE9, 0x89, 0xB3 },
	0xE6DB, { 0xE9, 0x8B, 0xB4 },
	0xE6DC, { 0xE9, 0x8B, 0xB5 },
	0xE6DD, { 0xE9, 0x8C, 0xBF },
	0xE6DE, { 0xE9, 0x8D, 0x82 },
	0xE6DF, { 0xE9, 0x8E, 0x86 },
	0xE6E0, { 0xE9, 0x8E, 0xBE },
	0xE6E1, { 0xE9, 0x8E, 0xBC },
	0xE6E2, { 0xE9, 0x8E, 0xBD },
	0xE6E3, { 0xE9, 0x8F, 0xB1 },
	0xE6E4, { 0xE9, 0x8F, 0xB2 },
	0xE6E5, { 0xE9, 0x8F, 0xAF },
	0xE6E6, { 0xE9, 0x90, 0xA2 },
	0xE6E7, { 0xE9, 0x90, 0xA3 },
	0xE6E8, { 0xE9, 0x90, 0xA4 },
	0xE6E9, { 0xE9, 0x91, 0xA7 },
	0xE6EA, { 0xE9, 0x91, 0xA6 },
	0xE6EB, { 0xE9, 0x96, 0x97 },
	0xE6EC, { 0xE9, 0x97, 0x8E },
	0xE6ED, { 0xE9, 0x97, 0xA7 },
	0xE6EE, { 0xE9, 0x9C, 0xBB },
	0xE6EF, { 0xE9, 0x9D, 0x8D },
	0xE6F0, { 0xE9, 0xA3, 0xA4 },
	0xE6F1, { 0xE9, 0xA5, 0x82 },
	0xE6F2, { 0xE9, 0xAC, 0x9D },
	0xE6F3, { 0xE9, 0xAE, 0x98 },
	0xE6F5, { 0xE9, 0xB5, 0x89 },
	0xE6F6, { 0xE6, 0x91, 0x89 },
	0xE6F7, { 0xE5, 0xB9, 0xB1 },
	0xE6F8, { 0xE5, 0xBA, 0x85 },
	0xE6F9, { 0xE6, 0x87, 0x93 },
	0xE6FA, { 0xE9, 0xA4, 0x8E },
	0xE6FB, { 0xE8, 0x80, 0x82 },
	0xE6FC, { 0xE7, 0xA0, 0x9E },
	0xE7A1, { 0xE5, 0x94, 0xA8 },
	0xE7A2, { 0xE5, 0x95, 0xB2 },
	0xE7A3, { 0xE5, 0x96, 0xBA },
	0xE7A4, { 0xE5, 0x97, 0xB0 },
	0xE7A5, { 0xE5, 0x97, 0xAE },
	0xE7A6, { 0xE5, 0x9A, 0xB8 },
	0xE7A7, { 0xE5, 0x9A, 0xB9 },
	0xE7A8, { 0xE5, 0x9B, 0x84 },
	0xE7A9, { 0xE8, 0x81, 0x93 },
	0xE7AA, { 0xE9, 0x8A, 0xB0 }
};

/* Conversion table from CNS 11643 plane #4 to UTF-8. */
static kiconv_table_array_t kiconv_cns4_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0xA1A1, { 0xF0, 0xA0, 0x82, 0x86 },
	0xA1A2, { 0xE4, 0xB9, 0x80 },
	0xA1A3, { 0xE4, 0xB9, 0x81 },
	0xA1A4, { 0xE4, 0xB9, 0x9A },
	0xA1A5, { 0xF0, 0xA1, 0xBF, 0xA8 },
	0xA1A6, { 0xE4, 0xB8, 0x82 },
	0xA1A7, { 0xE4, 0xB8, 0xA9 },
	0xA1A8, { 0xF0, 0xA0, 0x84, 0x8E },
	0xA1A9, { 0xF0, 0xA0, 0x98, 0xA7 },
	0xA1AA, { 0xE5, 0x88, 0x82 },
	0xA1AB, { 0xE3, 0x94, 0xBE },
	0xA1AC, { 0xE5, 0xB7, 0x9C },
	0xA1AD, { 0xF0, 0xA0, 0x94, 0xBC },
	0xA1AE, { 0xF0, 0xA0, 0x99, 0xB5 },
	0xA1AF, { 0xF0, 0xAF, 0xA0, 0xA8 },
	0xA1B0, { 0xE5, 0x8D, 0x82 },
	0xA1B1, { 0xE5, 0x8D, 0xAA },
	0xA1B2, { 0xE5, 0xAD, 0x92 },
	0xA1B3, { 0xF0, 0xA1, 0xA4, 0xBC },
	0xA1B4, { 0xF0, 0xAF, 0xA1, 0xB5 },
	0xA1B5, { 0xF0, 0xAF, 0xA1, 0xB8 },
	0xA1B6, { 0xE5, 0xBF, 0x84 },
	0xA1B7, { 0xE6, 0x89, 0x8C },
	0xA1B8, { 0xE7, 0x8A, 0xAD },
	0xA1B9, { 0xE4, 0xB8, 0x92 },
	0xA1BA, { 0xE4, 0xB8, 0xAF },
	0xA1BB, { 0xE4, 0xBA, 0x96 },
	0xA1BC, { 0xE4, 0xBB, 0x90 },
	0xA1BD, { 0xE5, 0x85, 0x82 },
	0xA1BE, { 0xE5, 0x86, 0x83 },
	0xA1BF, { 0xF0, 0xAF, 0xA0, 0x99 },
	0xA1C0, { 0xF0, 0xA0, 0x9A, 0xA5 },
	0xA1C1, { 0xF0, 0xA0, 0x9A, 0xAA },
	0xA1C2, { 0xF0, 0xA0, 0xA4, 0x8F },
	0xA1C3, { 0xF0, 0xA0, 0xA8, 0x8E },
	0xA1C4, { 0xE5, 0x8E, 0x83 },
	0xA1C5, { 0xE5, 0x8E, 0xB8 },
	0xA1C6, { 0xF0, 0xA0, 0xAE, 0x9C },
	0xA1C7, { 0xF0, 0xA0, 0xAE, 0x9B },
	0xA1C8, { 0xF0, 0xA1, 0x88, 0xBC },
	0xA1C9, { 0xE5, 0xA4, 0xA8 },
	0xA1CA, { 0xF0, 0xA1, 0xAF, 0x82 },
	0xA1CB, { 0xE5, 0xB0, 0xA3 },
	0xA1CC, { 0xE5, 0xB8, 0x81 },
	0xA1CD, { 0xE5, 0xBC, 0x80 },
	0xA1CE, { 0xF0, 0xA3, 0x8E, 0xB4 },
	0xA1CF, { 0xE3, 0xB2, 0xB8 },
	0xA1D0, { 0xE7, 0x81, 0xAC },
	0xA1D1, { 0xE7, 0x88, 0xAB },
	0xA1D2, { 0xE5, 0x86, 0x88 },
	0xA1D3, { 0xE8, 0x89, 0xB9 },
	0xA1D4, { 0xE8, 0xBE, 0xB6 },
	0xA1D5, { 0xE4, 0xB8, 0x97 },
	0xA1D6, { 0xF0, 0xA0, 0x81, 0xA5 },
	0xA1D7, { 0xE3, 0x90, 0x8C },
	0xA1D8, { 0xF0, 0xA0, 0x86, 0xB2 },
	0xA1D9, { 0xE3, 0x90, 0xB0 },
	0xA1DA, { 0xE4, 0xBB, 0xA2 },
	0xA1DB, { 0xE4, 0xBB, 0x9B },
	0xA1DC, { 0xF0, 0xA0, 0x91, 0xB7 },
	0xA1DD, { 0xF0, 0xA0, 0x95, 0x82 },
	0xA1DE, { 0xE5, 0x86, 0xAD },
	0xA1DF, { 0xF0, 0xA0, 0x98, 0xB3 },
	0xA1E0, { 0xE5, 0x87, 0xB7 },
	0xA1E1, { 0xE3, 0x93, 0x9A },
	0xA1E2, { 0xF0, 0xA0, 0x9A, 0xAF },
	0xA1E3, { 0xF0, 0xA0, 0xA0, 0xB6 },
	0xA1E4, { 0xE3, 0x94, 0x93 },
	0xA1E5, { 0xE5, 0x8C, 0x9B },
	0xA1E6, { 0xE5, 0x8E, 0x88 },
	0xA1E7, { 0xE5, 0x8E, 0x87 },
	0xA1E8, { 0xF0, 0xA0, 0xAC, 0xA2 },
	0xA1E9, { 0xE5, 0x8F, 0x8F },
	0xA1EA, { 0xE5, 0x8F, 0xBD },
	0xA1EB, { 0xE3, 0x95, 0xA3 },
	0xA1EC, { 0xE5, 0x8F, 0xA7 },
	0xA1ED, { 0xE5, 0x9B, 0x9C },
	0xA1EE, { 0xF0, 0xA1, 0x86, 0xA3 },
	0xA1EF, { 0xE5, 0x9B, 0x99 },
	0xA1F0, { 0xE5, 0x9C, 0xA5 },
	0xA1F1, { 0xE5, 0x9C, 0xA7 },
	0xA1F2, { 0xE5, 0xA4, 0xB3 },
	0xA1F3, { 0xE5, 0xB0, 0x93 },
	0xA1F4, { 0xF0, 0xA1, 0xB0, 0xA5 },
	0xA1F5, { 0xF0, 0xA1, 0xB0, 0xA4 },
	0xA1F6, { 0xE5, 0xB1, 0xB5 },
	0xA1F7, { 0xF0, 0xA2, 0x81, 0x92 },
	0xA1F8, { 0xF0, 0xA2, 0x86, 0x89 },
	0xA1F9, { 0xF0, 0xA2, 0x92, 0xBF },
	0xA1FA, { 0xE3, 0xA7, 0x84 },
	0xA1FB, { 0xE3, 0xA7, 0x83 },
	0xA1FC, { 0xE6, 0x9B, 0xB1 },
	0xA1FD, { 0xF0, 0xA3, 0x8E, 0xB5 },
	0xA1FE, { 0xF0, 0xA5, 0x9D, 0x8C },
	0xA2A1, { 0xE7, 0xBD, 0x92 },
	0xA2A2, { 0xF0, 0xA8, 0xB8, 0x94 },
	0xA2A3, { 0xF0, 0xA8, 0xB8, 0x92 },
	0xA2A4, { 0xE3, 0x90, 0x81 },
	0xA2A5, { 0xF0, 0xA0, 0x82, 0xA3 },
	0xA2A6, { 0xF0, 0xA0, 0x82, 0xA2 },
	0xA2A7, { 0xE4, 0xB9, 0x91 },
	0xA2A8, { 0xE4, 0xB9, 0xAA },
	0xA2A9, { 0xF0, 0xA0, 0x86, 0xB6 },
	0xA2AA, { 0xE4, 0xBC, 0x8C },
	0xA2AB, { 0xF0, 0xA0, 0x86, 0xB5 },
	0xA2AC, { 0xF0, 0xA0, 0x86, 0xB4 },
	0xA2AD, { 0xE4, 0xBB, 0xBE },
	0xA2AE, { 0xE4, 0xBC, 0x9B },
	0xA2AF, { 0xF0, 0xA0, 0x87, 0x82 },
	0xA2B0, { 0xF0, 0xA0, 0x86, 0xB8 },
	0xA2B1, { 0xE3, 0x90, 0xBA },
	0xA2B2, { 0xF0, 0xA0, 0x91, 0xB9 },
	0xA2B3, { 0xE3, 0x92, 0xAB },
	0xA2B4, { 0xE5, 0x85, 0xB3 },
	0xA2B5, { 0xF0, 0xA0, 0x94, 0x88 },
	0xA2B6, { 0xE5, 0x86, 0x8E },
	0xA2B7, { 0xF0, 0xA0, 0x95, 0xBA },
	0xA2B8, { 0xF0, 0xA0, 0x96, 0xB6 },
	0xA2B9, { 0xF0, 0xA0, 0x9A, 0xBD },
	0xA2BA, { 0xF0, 0xA0, 0x9A, 0xB7 },
	0xA2BB, { 0xF0, 0xA0, 0x9A, 0xBC },
	0xA2BC, { 0xE3, 0x93, 0x9D },
	0xA2BD, { 0xF0, 0xA0, 0x9B, 0x84 },
	0xA2BE, { 0xF0, 0xA0, 0x9B, 0x89 },
	0xA2BF, { 0xE5, 0x8A, 0xA5 },
	0xA2C0, { 0xE3, 0x94, 0x95 },
	0xA2C1, { 0xE5, 0x8A, 0xA7 },
	0xA2C2, { 0xE5, 0x8A, 0xA4 },
	0xA2C3, { 0xF0, 0xA0, 0xA4, 0xB0 },
	0xA2C4, { 0xF0, 0xA0, 0xA6, 0x83 },
	0xA2C5, { 0xF0, 0xA0, 0xA6, 0x85 },
	0xA2C6, { 0xF0, 0xA0, 0xA8, 0x92 },
	0xA2C7, { 0xF0, 0xA0, 0xA8, 0xB4 },
	0xA2C8, { 0xE5, 0x8E, 0xBD },
	0xA2C9, { 0xF0, 0xA0, 0xAB, 0xA4 },
	0xA2CA, { 0xF0, 0xA0, 0xAB, 0x9E },
	0xA2CB, { 0xF0, 0xA0, 0xAC, 0xAA },
	0xA2CC, { 0xE5, 0x90, 0x82 },
	0xA2CD, { 0xF0, 0xA0, 0xAE, 0xAF },
	0xA2CE, { 0xF0, 0xA0, 0xAE, 0xB4 },
	0xA2CF, { 0xF0, 0xA0, 0xAE, 0xB3 },
	0xA2D0, { 0xF0, 0xA0, 0xAE, 0xB1 },
	0xA2D1, { 0xE5, 0x9C, 0xAB },
	0xA2D2, { 0xE5, 0xA4, 0x9B },
	0xA2D3, { 0xE5, 0xA4, 0xB5 },
	0xA2D4, { 0xF0, 0xA1, 0x97, 0x9E },
	0xA2D5, { 0xE3, 0x9A, 0xA7 },
	0xA2D6, { 0xE3, 0x9A, 0xA5 },
	0xA2D7, { 0xF0, 0xA1, 0x9A, 0xB8 },
	0xA2D8, { 0xF0, 0xA1, 0x9A, 0xB0 },
	0xA2D9, { 0xE3, 0x9A, 0xA6 },
	0xA2DA, { 0xF0, 0xA1, 0xA7, 0x82 },
	0xA2DC, { 0xE5, 0xB0, 0x97 },
	0xA2DD, { 0xE3, 0x9D, 0xBC },
	0xA2DE, { 0xF0, 0xA1, 0xB0, 0xAA },
	0xA2DF, { 0xE5, 0xB1, 0xB0 },
	0xA2E0, { 0xE5, 0xB1, 0xBD },
	0xA2E1, { 0xE3, 0x9E, 0xA9 },
	0xA2E2, { 0xF0, 0xA1, 0xBF, 0xA9 },
	0xA2E3, { 0xE5, 0xB7, 0xA9 },
	0xA2E4, { 0xF0, 0xA2, 0x81, 0x97 },
	0xA2E5, { 0xE3, 0xA0, 0xB4 },
	0xA2E6, { 0xE3, 0xA0, 0xB5 },
	0xA2E7, { 0xF0, 0xA2, 0x86, 0xB6 },
	0xA2E8, { 0xF0, 0xA2, 0x87, 0x97 },
	0xA2E9, { 0xF0, 0xA2, 0x87, 0x9E },
	0xA2EA, { 0xE3, 0xA2, 0xA8 },
	0xA2EB, { 0xE5, 0xBC, 0x99 },
	0xA2EC, { 0xE5, 0xBC, 0x9C },
	0xA2ED, { 0xE5, 0xBD, 0xB5 },
	0xA2EE, { 0xF0, 0xA2, 0x93, 0x82 },
	0xA2EF, { 0xF0, 0xA2, 0x96, 0xAB },
	0xA2F0, { 0xE3, 0xA3, 0xBF },
	0xA2F1, { 0xE5, 0xBF, 0x88 },
	0xA2F2, { 0xF0, 0xA2, 0xA6, 0x8F },
	0xA2F3, { 0xE3, 0xA7, 0x87 },
	0xA2F4, { 0xE3, 0xA7, 0x86 },
	0xA2F5, { 0xE3, 0xA7, 0x88 },
	0xA2F6, { 0xF0, 0xA2, 0xA9, 0xAD },
	0xA2F7, { 0xF0, 0xA2, 0xBA, 0xB5 },
	0xA2F8, { 0xE3, 0xAB, 0x90 },
	0xA2F9, { 0xE3, 0xAB, 0x91 },
	0xA2FA, { 0xF0, 0xA3, 0x8F, 0x80 },
	0xA2FB, { 0xF0, 0xA3, 0x8E, 0xBF },
	0xA2FC, { 0xE3, 0xB1, 0x99 },
	0xA2FD, { 0xF0, 0xA3, 0xA6, 0xB9 },
	0xA2FE, { 0xF0, 0xA3, 0xAC, 0x9C },
	0xA3A1, { 0xE6, 0xB0, 0x92 },
	0xA3A2, { 0xE3, 0xB2, 0xBD },
	0xA3A3, { 0xF0, 0xA3, 0xB2, 0x80 },
	0xA3A4, { 0xF0, 0xA4, 0x86, 0x84 },
	0xA3A5, { 0xF0, 0xA4, 0x86, 0x85 },
	0xA3A6, { 0xE3, 0xB8, 0xA8 },
	0xA3A7, { 0xE7, 0x8A, 0xB3 },
	0xA3A8, { 0xF0, 0xA4, 0x9C, 0xA4 },
	0xA3A9, { 0xE3, 0xBA, 0xA9 },
	0xA3AA, { 0xE7, 0x8E, 0x90 },
	0xA3AB, { 0xE7, 0x94, 0xB6 },
	0xA3AC, { 0xF0, 0xA6, 0x8D, 0x8C },
	0xA3AD, { 0xE4, 0x8F, 0x8C },
	0xA3AE, { 0xF0, 0xA6, 0xAB, 0xB6 },
	0xA3AF, { 0xE8, 0x8A, 0x81 },
	0xA3B0, { 0xE8, 0xBE, 0xB8 },
	0xA3B1, { 0xF0, 0xA8, 0x99, 0xB0 },
	0xA3B2, { 0xE4, 0xA2, 0xB4 },
	0xA3B3, { 0xF0, 0xA8, 0x99, 0xB5 },
	0xA3B4, { 0xF0, 0xA8, 0xB8, 0x97 },
	0xA3B5, { 0xE4, 0xB8, 0xA3 },
	0xA3B6, { 0xE3, 0x90, 0x96 },
	0xA3B7, { 0xE3, 0x90, 0xAC },
	0xA3B8, { 0xF0, 0xA0, 0x87, 0xB1 },
	0xA3B9, { 0xE4, 0xBC, 0xAE },
	0xA3BA, { 0xF0, 0xA0, 0x87, 0x9A },
	0xA3BB, { 0xE5, 0x85, 0x8F },
	0xA3BC, { 0xF0, 0xA0, 0x96, 0xB9 },
	0xA3BD, { 0xE5, 0x86, 0xBA },
	0xA3BE, { 0xE3, 0x93, 0x9F },
	0xA3BF, { 0xE3, 0x93, 0xA0 },
	0xA3C0, { 0xE5, 0x88, 0xA2 },
	0xA3C1, { 0xF0, 0xA0, 0x9B, 0x8E },
	0xA3C2, { 0xF0, 0xA0, 0x9B, 0x92 },
	0xA3C3, { 0xF0, 0xA0, 0x9B, 0x90 },
	0xA3C4, { 0xE3, 0x94, 0x97 },
	0xA3C5, { 0xF0, 0xA0, 0xA1, 0x83 },
	0xA3C6, { 0xE5, 0x8A, 0xAF },
	0xA3C7, { 0xE5, 0x8A, 0xB0 },
	0xA3C8, { 0xE5, 0x8A, 0xB1 },
	0xA3C9, { 0xF0, 0xA0, 0xA1, 0x8D },
	0xA3CA, { 0xF0, 0xA0, 0xA4, 0xB4 },
	0xA3CB, { 0xE3, 0x94, 0xAF },
	0xA3CC, { 0xF0, 0xA0, 0xA7, 0x99 },
	0xA3CD, { 0xE5, 0x8D, 0xA4 },
	0xA3CE, { 0xF0, 0xA0, 0xA8, 0x98 },
	0xA3CF, { 0xE5, 0x8F, 0x93 },
	0xA3D0, { 0xF0, 0xA0, 0xAC, 0xB8 },
	0xA3D1, { 0xE3, 0x95, 0xAA },
	0xA3D2, { 0xF0, 0xA0, 0xAF, 0x97 },
	0xA3D3, { 0xE3, 0x95, 0xB0 },
	0xA3D4, { 0xE3, 0x95, 0xAD },
	0xA3D5, { 0xF0, 0xA0, 0xAF, 0x9C },
	0xA3D6, { 0xF0, 0xA0, 0xAF, 0x8B },
	0xA3D7, { 0xF0, 0xA0, 0xAF, 0x96 },
	0xA3D8, { 0xF0, 0xA0, 0xAF, 0x98 },
	0xA3D9, { 0xE3, 0x95, 0xAE },
	0xA3DA, { 0xF0, 0xA0, 0xAF, 0x91 },
	0xA3DB, { 0xF0, 0xAF, 0xA0, 0xBE },
	0xA3DC, { 0xF0, 0xAF, 0xA0, 0xBC },
	0xA3DD, { 0xF0, 0xA0, 0xAF, 0x92 },
	0xA3DE, { 0xE3, 0x98, 0xAB },
	0xA3DF, { 0xE3, 0x98, 0xA8 },
	0xA3E0, { 0xF0, 0xA1, 0x89, 0x99 },
	0xA3E2, { 0xE5, 0xA4, 0xBF },
	0xA3E3, { 0xF0, 0xA1, 0x97, 0xA5 },
	0xA3E4, { 0xF0, 0xA1, 0x97, 0xA6 },
	0xA3E5, { 0xE3, 0x9A, 0x92 },
	0xA3E6, { 0xF0, 0xA1, 0x97, 0xA8 },
	0xA3E7, { 0xE5, 0xA6, 0x8B },
	0xA3E8, { 0xF0, 0xA1, 0x9A, 0xBD },
	0xA3E9, { 0xE5, 0xA6, 0x91 },
	0xA3EA, { 0xE5, 0xA6, 0x95 },
	0xA3EB, { 0xF0, 0xA1, 0x9A, 0xBE },
	0xA3EC, { 0xF0, 0xA1, 0xA5, 0x89 },
	0xA3ED, { 0xE3, 0x9C, 0xBF },
	0xA3EE, { 0xF0, 0xA1, 0xA7, 0x8D },
	0xA3EF, { 0xE5, 0xAE, 0x8A },
	0xA3F0, { 0xE3, 0x9D, 0x8F },
	0xA3F1, { 0xE3, 0x9D, 0xB4 },
	0xA3F2, { 0xF0, 0xA1, 0xAD, 0x9E },
	0xA3F3, { 0xF0, 0xA1, 0xAF, 0x90 },
	0xA3F4, { 0xE3, 0x9D, 0xBD },
	0xA3F5, { 0xF0, 0xA1, 0xB4, 0x86 },
	0xA3F6, { 0xE3, 0x9E, 0xB7 },
	0xA3F7, { 0xE3, 0x9E, 0xA3 },
	0xA3F8, { 0xE3, 0x9E, 0xB0 },
	0xA3F9, { 0xE3, 0x9E, 0xB1 },
	0xA3FA, { 0xE5, 0xB2, 0x87 },
	0xA3FB, { 0xE3, 0x9E, 0xAB },
	0xA3FC, { 0xF0, 0xA1, 0xB5, 0xBC },
	0xA3FD, { 0xF0, 0xA1, 0xB5, 0xB1 },
	0xA3FE, { 0xF0, 0xA1, 0xBF, 0xAF },
	0xA4A1, { 0xE3, 0xA0, 0xBA },
	0xA4A2, { 0xE3, 0xA0, 0xB7 },
	0xA4A3, { 0xE5, 0xB8, 0x8D },
	0xA4A4, { 0xE3, 0xA0, 0xB8 },
	0xA4A5, { 0xE3, 0xA1, 0x80 },
	0xA4A6, { 0xF0, 0xA2, 0x86, 0x8D },
	0xA4A7, { 0xF0, 0xA2, 0x86, 0xB7 },
	0xA4A8, { 0xE5, 0xBA, 0x8E },
	0xA4A9, { 0xE3, 0xA2, 0x9F },
	0xA4AA, { 0xF0, 0xA2, 0x8C, 0xB3 },
	0xA4AB, { 0xF0, 0xA2, 0x8D, 0xBF },
	0xA4AC, { 0xE5, 0xBD, 0xBA },
	0xA4AD, { 0xF0, 0xA2, 0x97, 0xB2 },
	0xA4AE, { 0xE3, 0xA4, 0x84 },
	0xA4AF, { 0xE3, 0xA4, 0x89 },
	0xA4B0, { 0xE3, 0xA4, 0x86 },
	0xA4B1, { 0xE3, 0xA3, 0xBD },
	0xA4B2, { 0xE3, 0xA4, 0x8A },
	0xA4B3, { 0xE3, 0xA4, 0x87 },
	0xA4B4, { 0xF0, 0xA2, 0xA8, 0xAA },
	0xA4B5, { 0xF0, 0xA2, 0xAA, 0x8B },
	0xA4B6, { 0xE3, 0xA7, 0x8A },
	0xA4B7, { 0xF0, 0xA2, 0xAA, 0x83 },
	0xA4B8, { 0xF0, 0xA2, 0xAA, 0x8A },
	0xA4B9, { 0xE6, 0x8A, 0x90 },
	0xA4BA, { 0xE3, 0xA7, 0x89 },
	0xA4BB, { 0xF0, 0xA2, 0xAA, 0x8E },
	0xA4BC, { 0xE6, 0x8A, 0x9A },
	0xA4BD, { 0xF0, 0xA2, 0xBA, 0xB6 },
	0xA4BE, { 0xE6, 0x94, 0xBC },
	0xA4BF, { 0xE6, 0x94, 0xBA },
	0xA4C0, { 0xE3, 0xA9, 0xBF },
	0xA4C1, { 0xE6, 0x96, 0x98 },
	0xA4C2, { 0xF0, 0xA3, 0x83, 0x98 },
	0xA4C3, { 0xE3, 0xAB, 0x92 },
	0xA4C4, { 0xF0, 0xA3, 0x85, 0x96 },
	0xA4C5, { 0xF0, 0xA3, 0x8F, 0x92 },
	0xA4C6, { 0xE6, 0x9D, 0xA5 },
	0xA4C7, { 0xF0, 0xAF, 0xA3, 0x9B },
	0xA4C8, { 0xE3, 0xAD, 0x83 },
	0xA4C9, { 0xF0, 0xA3, 0x8F, 0x82 },
	0xA4CA, { 0xF0, 0xA3, 0xA2, 0x87 },
	0xA4CB, { 0xF0, 0xA3, 0xA2, 0x81 },
	0xA4CC, { 0xF0, 0xA3, 0xA7, 0x82 },
	0xA4CD, { 0xF0, 0xA3, 0xA6, 0xBC },
	0xA4CE, { 0xF0, 0xA3, 0xAC, 0xA3 },
	0xA4CF, { 0xE3, 0xB3, 0x81 },
	0xA4D0, { 0xF0, 0xA3, 0xB2, 0x93 },
	0xA4D1, { 0xE3, 0xB3, 0x85 },
	0xA4D2, { 0xE3, 0xB6, 0xA3 },
	0xA4D3, { 0xF0, 0xA4, 0x86, 0x8D },
	0xA4D4, { 0xF0, 0xA4, 0x86, 0x8E },
	0xA4D5, { 0xE3, 0xB8, 0xAA },
	0xA4D6, { 0xE3, 0xB9, 0x9F },
	0xA4D7, { 0xF0, 0xA4, 0x9C, 0xBB },
	0xA4D8, { 0xF0, 0xA4, 0x9D, 0x8D },
	0xA4D9, { 0xE3, 0xB9, 0x9D },
	0xA4DA, { 0xF0, 0xA4, 0x9C, 0xB4 },
	0xA4DB, { 0xF0, 0xA4, 0x9C, 0xB1 },
	0xA4DC, { 0xF0, 0xA4, 0xA3, 0xB2 },
	0xA4DD, { 0xF0, 0xA4, 0xA3, 0xB0 },
	0xA4DE, { 0xE3, 0xBC, 0x97 },
	0xA4DF, { 0xF0, 0xA4, 0xB0, 0x95 },
	0xA4E0, { 0xF0, 0xA4, 0xB4, 0xA8 },
	0xA4E1, { 0xE3, 0xBD, 0xB1 },
	0xA4E2, { 0xE3, 0xBD, 0xB2 },
	0xA4E3, { 0xF0, 0xA4, 0xBC, 0xA5 },
	0xA4E4, { 0xF0, 0xA5, 0x83, 0xA7 },
	0xA4E5, { 0xE4, 0x80, 0x8F },
	0xA4E6, { 0xF0, 0xA5, 0x83, 0xA9 },
	0xA4E7, { 0xF0, 0xA5, 0x90, 0x97 },
	0xA4E8, { 0xE7, 0xA7, 0x82 },
	0xA4E9, { 0xE4, 0x86, 0x91 },
	0xA4EA, { 0xF0, 0xA6, 0x89, 0xAC },
	0xA4EB, { 0xF0, 0xA6, 0x8A, 0x80 },
	0xA4EC, { 0xF0, 0xA6, 0x8D, 0x8B },
	0xA4ED, { 0xE4, 0x8E, 0xB2 },
	0xA4EE, { 0xE4, 0x8F, 0x8F },
	0xA4EF, { 0xE4, 0x8F, 0x8E },
	0xA4F0, { 0xE8, 0x82, 0x9E },
	0xA4F1, { 0xF0, 0xA6, 0xA3, 0x9E },
	0xA4F2, { 0xF0, 0xA6, 0xA3, 0xBB },
	0xA4F3, { 0xE8, 0x87, 0xAB },
	0xA4F4, { 0xF0, 0xA6, 0xA5, 0x91 },
	0xA4F5, { 0xE8, 0x8A, 0x89 },
	0xA4F6, { 0xE4, 0x92, 0x96 },
	0xA4F7, { 0xF0, 0xA6, 0xAC, 0x81 },
	0xA4F8, { 0xF0, 0xA6, 0xAC, 0x82 },
	0xA4F9, { 0xE8, 0x8A, 0x96 },
	0xA4FA, { 0xF0, 0xA6, 0xAC, 0x85 },
	0xA4FB, { 0xE8, 0x8A, 0x87 },
	0xA4FC, { 0xF0, 0xA6, 0xAC, 0x83 },
	0xA4FD, { 0xE4, 0x92, 0x97 },
	0xA4FE, { 0xF0, 0xA8, 0x91, 0x91 },
	0xA5A1, { 0xE8, 0xBF, 0x80 },
	0xA5A2, { 0xE4, 0xA2, 0x8B },
	0xA5A3, { 0xE8, 0xBF, 0x83 },
	0xA5A4, { 0xF0, 0xA8, 0x91, 0x93 },
	0xA5A5, { 0xF0, 0xA8, 0x99, 0xBA },
	0xA5A6, { 0xF0, 0xA8, 0x99, 0xB8 },
	0xA5A7, { 0xF0, 0xA8, 0x99, 0xB6 },
	0xA5A8, { 0xF0, 0xA8, 0x99, 0xB9 },
	0xA5A9, { 0xF0, 0xA8, 0x9A, 0x8F },
	0xA5AA, { 0xF0, 0xA8, 0x99, 0xBC },
	0xA5AB, { 0xE9, 0x95, 0xB8 },
	0xA5AC, { 0xF0, 0xA8, 0xB8, 0x9B },
	0xA5AD, { 0xF0, 0xA8, 0xB8, 0x9C },
	0xA5AE, { 0xE9, 0x98, 0xA5 },
	0xA5AF, { 0xF0, 0xA3, 0xB6, 0x92 },
	0xA5B0, { 0xE4, 0xB9, 0xB5 },
	0xA5B1, { 0xE4, 0xB9, 0xB4 },
	0xA5B2, { 0xF0, 0xA0, 0x84, 0xAE },
	0xA5B3, { 0xF0, 0xA0, 0x84, 0xAC },
	0xA5B4, { 0xE3, 0x90, 0xAD },
	0xA5B5, { 0xF0, 0xA0, 0x88, 0x8C },
	0xA5B6, { 0xE4, 0xBE, 0x99 },
	0xA5B7, { 0xF0, 0xA0, 0x88, 0x8B },
	0xA5B8, { 0xE3, 0x91, 0x90 },
	0xA5B9, { 0xE3, 0x91, 0x8B },
	0xA5BA, { 0xF0, 0xA0, 0x88, 0x85 },
	0xA5BB, { 0xE3, 0x91, 0x8F },
	0xA5BC, { 0xE3, 0x91, 0x8C },
	0xA5BD, { 0xF0, 0xAF, 0xA0, 0x85 },
	0xA5BE, { 0xE4, 0xBD, 0xB1 },
	0xA5BF, { 0xE5, 0x85, 0x93 },
	0xA5C0, { 0xE5, 0x86, 0xBF },
	0xA5C1, { 0xF0, 0xA0, 0x97, 0x82 },
	0xA5C2, { 0xF0, 0xA0, 0x97, 0x83 },
	0xA5C3, { 0xE5, 0x87, 0x80 },
	0xA5C4, { 0xF0, 0xA0, 0x99, 0x88 },
	0xA5C5, { 0xE5, 0x87, 0xAE },
	0xA5C6, { 0xF0, 0xA0, 0x99, 0x86 },
	0xA5C7, { 0xE3, 0x93, 0xA4 },
	0xA5C8, { 0xE3, 0x93, 0xA3 },
	0xA5C9, { 0xF0, 0xA0, 0x9B, 0xAA },
	0xA5CA, { 0xE3, 0x93, 0xA1 },
	0xA5CB, { 0xF0, 0xA0, 0x9B, 0xAB },
	0xA5CC, { 0xE3, 0x93, 0xA2 },
	0xA5CD, { 0xF0, 0xA0, 0x9B, 0xAE },
	0xA5CE, { 0xE5, 0x88, 0xBD },
	0xA5CF, { 0xE3, 0x94, 0x99 },
	0xA5D0, { 0xE5, 0x8A, 0xBD },
	0xA5D1, { 0xE5, 0x8C, 0x8C },
	0xA5D2, { 0xF0, 0xA0, 0xA3, 0x98 },
	0xA5D3, { 0xF0, 0xA4, 0xB0, 0x9E },
	0xA5D4, { 0xF0, 0xA0, 0xA7, 0x9F },
	0xA5D5, { 0xF0, 0xA0, 0xA7, 0x9E },
	0xA5D6, { 0xE3, 0x95, 0x81 },
	0xA5D7, { 0xE7, 0xBC, 0xB7 },
	0xA5D8, { 0xF0, 0xA0, 0xA9, 0x8F },
	0xA5D9, { 0xE5, 0x8F, 0x80 },
	0xA5DA, { 0xE3, 0x95, 0x9E },
	0xA5DB, { 0xF0, 0xA0, 0xB0, 0x8D },
	0xA5DC, { 0xF0, 0xA0, 0xB0, 0x88 },
	0xA5DD, { 0xE3, 0x95, 0xB9 },
	0xA5DE, { 0xF0, 0xA0, 0xB0, 0x89 },
	0xA5DF, { 0xE5, 0x91, 0xAE },
	0xA5E0, { 0xE5, 0x92, 0x83 },
	0xA5E1, { 0xF0, 0xA0, 0xB0, 0x92 },
	0xA5E2, { 0xF0, 0xA0, 0xB1, 0xA5 },
	0xA5E3, { 0xE5, 0x91, 0x9E },
	0xA5E4, { 0xE5, 0x91, 0x9D },
	0xA5E5, { 0xE5, 0x9D, 0xBE },
	0xA5E6, { 0xE5, 0x9D, 0xB9 },
	0xA5E7, { 0xF0, 0xA1, 0x8A, 0x89 },
	0xA5E8, { 0xE5, 0x9D, 0xBA },
	0xA5E9, { 0xE5, 0x9D, 0xAC },
	0xA5EA, { 0xF0, 0xA1, 0x8A, 0x84 },
	0xA5EB, { 0xF0, 0xA1, 0x8A, 0x9E },
	0xA5EC, { 0xF0, 0xA1, 0x8A, 0x8B },
	0xA5ED, { 0xE3, 0x98, 0xB2 },
	0xA5EE, { 0xE5, 0x9E, 0x87 },
	0xA5EF, { 0xF0, 0xA1, 0x95, 0xA2 },
	0xA5F0, { 0xE5, 0xA4, 0x9D },
	0xA5F1, { 0xE3, 0x9A, 0x94 },
	0xA5F2, { 0xE5, 0xA5, 0x86 },
	0xA5F3, { 0xE3, 0x9A, 0x97 },
	0xA5F4, { 0xF0, 0xA1, 0x97, 0xB9 },
	0xA5F5, { 0xE5, 0xA5, 0x83 },
	0xA5F6, { 0xF0, 0xA1, 0x97, 0xB7 },
	0xA5F7, { 0xE3, 0x9A, 0x96 },
	0xA5F8, { 0xE3, 0x9A, 0x98 },
	0xA5F9, { 0xF0, 0xA1, 0x98, 0x86 },
	0xA5FA, { 0xF0, 0xA1, 0x9B, 0x9D },
	0xA5FB, { 0xE3, 0x9A, 0xB2 },
	0xA5FC, { 0xF0, 0xA1, 0x9B, 0x99 },
	0xA5FD, { 0xF0, 0xA1, 0x9B, 0x9F },
	0xA5FE, { 0xF0, 0xA1, 0x9B, 0xA2 },
	0xA6A1, { 0xE3, 0x9A, 0xB9 },
	0xA6A2, { 0xE5, 0xAD, 0xA1 },
	0xA6A3, { 0xE5, 0xAD, 0xA6 },
	0xA6A4, { 0xF0, 0xA0, 0x83, 0xB1 },
	0xA6A5, { 0xE5, 0xAE, 0x90 },
	0xA6A6, { 0xE3, 0x9D, 0xB5 },
	0xA6A7, { 0xE3, 0x9D, 0xBF },
	0xA6A8, { 0xE3, 0x9D, 0xBE },
	0xA6A9, { 0xE5, 0xB0, 0xA9 },
	0xA6AA, { 0xE3, 0x9E, 0x8F },
	0xA6AB, { 0xF0, 0xA1, 0xB0, 0xBF },
	0xA6AC, { 0xF0, 0xA1, 0xB0, 0xBE },
	0xA6AD, { 0xF0, 0xA1, 0xB4, 0x8B },
	0xA6AE, { 0xE3, 0x9E, 0xBD },
	0xA6AF, { 0xE5, 0xB2, 0xB2 },
	0xA6B0, { 0xF0, 0xA1, 0xB6, 0x83 },
	0xA6B1, { 0xE3, 0x9E, 0xBB },
	0xA6B2, { 0xE3, 0x9E, 0xBC },
	0xA6B3, { 0xF0, 0xA1, 0xB6, 0x86 },
	0xA6B4, { 0xE5, 0xB3, 0x80 },
	0xA6B5, { 0xF0, 0xA2, 0x81, 0xBC },
	0xA6B6, { 0xE3, 0xA0, 0xBD },
	0xA6B7, { 0xE3, 0xA0, 0xBE },
	0xA6B8, { 0xE3, 0xA1, 0xB4 },
	0xA6B9, { 0xF0, 0xA2, 0x87, 0xB7 },
	0xA6BA, { 0xE3, 0xA1, 0xBA },
	0xA6BB, { 0xE3, 0xA1, 0xB6 },
	0xA6BC, { 0xE3, 0xA1, 0xB8 },
	0xA6BD, { 0xE3, 0xA1, 0xB5 },
	0xA6BE, { 0xF0, 0xA2, 0x87, 0xBB },
	0xA6BF, { 0xF0, 0xA2, 0x8C, 0xBB },
	0xA6C0, { 0xE3, 0xA2, 0xAF },
	0xA6C1, { 0xE3, 0xA2, 0xB0 },
	0xA6C2, { 0xE3, 0xA3, 0x87 },
	0xA6C3, { 0xE3, 0xA3, 0x8C },
	0xA6C4, { 0xF0, 0xA2, 0x97, 0xB9 },
	0xA6C5, { 0xF0, 0xA2, 0x97, 0x8A },
	0xA6C6, { 0xE3, 0xA4, 0x96 },
	0xA6C7, { 0xF0, 0xA2, 0x97, 0xBF },
	0xA6C8, { 0xE3, 0xA4, 0x92 },
	0xA6C9, { 0xE3, 0xA4, 0x9D },
	0xA6CA, { 0xF0, 0xA2, 0x98, 0x89 },
	0xA6CB, { 0xF0, 0xA2, 0x98, 0x83 },
	0xA6CC, { 0xE3, 0xA4, 0x95 },
	0xA6CD, { 0xE3, 0xA4, 0x8F },
	0xA6CE, { 0xE3, 0xA4, 0x94 },
	0xA6CF, { 0xE6, 0x80, 0x9F },
	0xA6D0, { 0xE5, 0xBF, 0xA2 },
	0xA6D1, { 0xF0, 0xA2, 0x98, 0x90 },
	0xA6D2, { 0xF0, 0xA2, 0xA6, 0x9A },
	0xA6D3, { 0xF0, 0xA2, 0xA6, 0x9F },
	0xA6D4, { 0xE3, 0xA6, 0xB0 },
	0xA6D5, { 0xE3, 0xA6, 0xBF },
	0xA6D6, { 0xE3, 0xA7, 0x80 },
	0xA6D7, { 0xF0, 0xA2, 0xAA, 0x87 },
	0xA6D8, { 0xE3, 0xA7, 0x92 },
	0xA6D9, { 0xE3, 0xA7, 0x99 },
	0xA6DA, { 0xF0, 0xA2, 0xBA, 0xB7 },
	0xA6DB, { 0xE3, 0xA9, 0xBA },
	0xA6DC, { 0xF0, 0xA2, 0xBC, 0x88 },
	0xA6DD, { 0xF0, 0xA2, 0xBB, 0xB9 },
	0xA6DE, { 0xE3, 0xAA, 0x81 },
	0xA6DF, { 0xE3, 0xAA, 0x82 },
	0xA6E0, { 0xF0, 0xA2, 0xBB, 0xB4 },
	0xA6E1, { 0xE6, 0x98, 0x96 },
	0xA6E2, { 0xE6, 0x97, 0xB9 },
	0xA6E3, { 0xE3, 0xAB, 0x9A },
	0xA6E4, { 0xF0, 0xA6, 0x99, 0x97 },
	0xA6E5, { 0xE6, 0x9E, 0x88 },
	0xA6E6, { 0xF0, 0xA3, 0x8F, 0x96 },
	0xA6E7, { 0xE6, 0x9E, 0x9B },
	0xA6E8, { 0xF0, 0xAF, 0xA3, 0x9E },
	0xA6E9, { 0xE6, 0x9D, 0xAE },
	0xA6EA, { 0xE6, 0x9E, 0x9E },
	0xA6EB, { 0xF0, 0xA3, 0x8F, 0x94 },
	0xA6EC, { 0xE3, 0xB0, 0xA2 },
	0xA6ED, { 0xE3, 0xB0, 0x9F },
	0xA6EE, { 0xF0, 0xA3, 0xA2, 0x90 },
	0xA6EF, { 0xF0, 0xA3, 0xA2, 0x8D },
	0xA6F0, { 0xE3, 0xB0, 0xA1 },
	0xA6F1, { 0xE6, 0xAC, 0xA4 },
	0xA6F2, { 0xF0, 0xA3, 0xA5, 0xA0 },
	0xA6F3, { 0xF0, 0xA3, 0xA7, 0x8E },
	0xA6F4, { 0xF0, 0xA3, 0xA7, 0x8F },
	0xA6F5, { 0xE3, 0xB1, 0x9C },
	0xA6F6, { 0xE6, 0xAD, 0xBD },
	0xA6F7, { 0xF0, 0xA3, 0xA7, 0x91 },
	0xA6F8, { 0xE3, 0xB1, 0xBD },
	0xA6F9, { 0xE3, 0xB2, 0x8D },
	0xA6FA, { 0xE3, 0xB2, 0x8F },
	0xA6FB, { 0xE6, 0xB3, 0xA6 },
	0xA6FC, { 0xF0, 0xA3, 0xB3, 0x8A },
	0xA6FD, { 0xE6, 0xB3, 0x8B },
	0xA6FE, { 0xE3, 0xB3, 0x90 },
	0xA7A1, { 0xF0, 0xA3, 0xB2, 0xB7 },
	0xA7A2, { 0xE3, 0xB3, 0x98 },
	0xA7A3, { 0xF0, 0xA3, 0xB2, 0xB2 },
	0xA7A4, { 0xF0, 0xA3, 0xB2, 0xBB },
	0xA7A5, { 0xF0, 0xA3, 0xB2, 0xB9 },
	0xA7A6, { 0xE6, 0xB2, 0xB5 },
	0xA7A7, { 0xE3, 0xB6, 0xA7 },
	0xA7A8, { 0xF0, 0xA4, 0x86, 0x9E },
	0xA7A9, { 0xE7, 0x82, 0x97 },
	0xA7AA, { 0xF0, 0xA4, 0x86, 0xB2 },
	0xA7AB, { 0xE7, 0x82, 0x9B },
	0xA7AC, { 0xE3, 0xB8, 0x92 },
	0xA7AD, { 0xF0, 0xA4, 0x95, 0xAF },
	0xA7AE, { 0xF0, 0xA4, 0x96, 0xAC },
	0xA7AF, { 0xE3, 0xB8, 0xAF },
	0xA7B0, { 0xF0, 0xA4, 0x98, 0xA3 },
	0xA7B1, { 0xE7, 0x89, 0xAB },
	0xA7B2, { 0xE3, 0xB8, 0xAE },
	0xA7B3, { 0xE3, 0xB8, 0xAC },
	0xA7B4, { 0xE3, 0xB9, 0x9C },
	0xA7B5, { 0xF0, 0xA4, 0x9D, 0xAC },
	0xA7B6, { 0xE7, 0x8B, 0x95 },
	0xA7B7, { 0xF0, 0xA4, 0x9C, 0xB2 },
	0xA7B8, { 0xF0, 0xA4, 0x9D, 0x9E },
	0xA7B9, { 0xE3, 0xB9, 0xA2 },
	0xA7BA, { 0xE3, 0xB9, 0xA7 },
	0xA7BB, { 0xE3, 0xBA, 0xB4 },
	0xA7BC, { 0xF0, 0xA4, 0xA3, 0xBB },
	0xA7BD, { 0xF0, 0xA4, 0xAC, 0xA9 },
	0xA7BE, { 0xF0, 0xA4, 0xAE, 0xBD },
	0xA7BF, { 0xF0, 0xA4, 0xB0, 0x9F },
	0xA7C0, { 0xE7, 0x95, 0x83 },
	0xA7C1, { 0xF0, 0xA2, 0x8D, 0x81 },
	0xA7C2, { 0xF0, 0xA4, 0xB0, 0x9D },
	0xA7C3, { 0xE7, 0x96, 0x9C },
	0xA7C4, { 0xF0, 0xA4, 0xB4, 0xB1 },
	0xA7C5, { 0xF0, 0xA4, 0xB4, 0xAF },
	0xA7C6, { 0xE3, 0xBF, 0xAA },
	0xA7C7, { 0xF0, 0xA5, 0x81, 0x83 },
	0xA7C8, { 0xE3, 0xBF, 0xBB },
	0xA7C9, { 0xF0, 0xA5, 0x81, 0x81 },
	0xA7CA, { 0xE4, 0x80, 0x94 },
	0xA7CB, { 0xF0, 0xA5, 0x83, 0xB5 },
	0xA7CC, { 0xE4, 0x80, 0x93 },
	0xA7CD, { 0xE4, 0x80, 0x92 },
	0xA7CE, { 0xE4, 0x80, 0x90 },
	0xA7CF, { 0xE4, 0x80, 0x91 },
	0xA7D0, { 0xF0, 0xA5, 0x83, 0xB2 },
	0xA7D1, { 0xE4, 0x82, 0x86 },
	0xA7D2, { 0xE7, 0x9F, 0xA4 },
	0xA7D3, { 0xE4, 0x82, 0x98 },
	0xA7D4, { 0xF0, 0xA5, 0x90, 0x9E },
	0xA7D5, { 0xF0, 0xA5, 0x9D, 0x94 },
	0xA7D6, { 0xE4, 0x84, 0xAA },
	0xA7D7, { 0xF0, 0xA5, 0x9D, 0x96 },
	0xA7D8, { 0xF0, 0xA5, 0xA4, 0xA9 },
	0xA7D9, { 0xF0, 0xA5, 0xA4, 0xA7 },
	0xA7DA, { 0xF0, 0xA5, 0xA4, 0xA8 },
	0xA7DB, { 0xE7, 0xAB, 0x8E },
	0xA7DC, { 0xE4, 0x8A, 0xB5 },
	0xA7DD, { 0xF0, 0xA6, 0x89, 0xB9 },
	0xA7DE, { 0xF0, 0xA6, 0x89, 0xBE },
	0xA7DF, { 0xF0, 0xA6, 0x92, 0xB6 },
	0xA7E0, { 0xF0, 0xA6, 0x92, 0xB7 },
	0xA7E1, { 0xE8, 0x80, 0x93 },
	0xA7E2, { 0xE4, 0x8F, 0x96 },
	0xA7E3, { 0xE4, 0x8F, 0x98 },
	0xA7E4, { 0xE8, 0x82, 0xB7 },
	0xA7E5, { 0xE4, 0x8F, 0x99 },
	0xA7E6, { 0xE4, 0x8F, 0x94 },
	0xA7E7, { 0xE4, 0x8F, 0x97 },
	0xA7E8, { 0xF0, 0xAF, 0xA6, 0x81 },
	0xA7E9, { 0xE8, 0x82, 0xB9 },
	0xA7EB, { 0xF0, 0xA6, 0x99, 0x8D },
	0xA7EC, { 0xE8, 0x87, 0xA4 },
	0xA7ED, { 0xE8, 0x87, 0xBD },
	0xA7EE, { 0xE8, 0x88, 0x8F },
	0xA7EF, { 0xE4, 0x91, 0xA0 },
	0xA7F0, { 0xF0, 0xA6, 0xA8, 0x89 },
	0xA7F1, { 0xF0, 0xA6, 0xA8, 0x88 },
	0xA7F2, { 0xE4, 0x92, 0x9E },
	0xA7F3, { 0xE4, 0x92, 0xA1 },
	0xA7F4, { 0xF0, 0xA6, 0xAC, 0x9E },
	0xA7F5, { 0xF0, 0xA6, 0xAC, 0x9A },
	0xA7F6, { 0xF0, 0xA6, 0xAC, 0xA3 },
	0xA7F7, { 0xF0, 0xA6, 0xAC, 0x95 },
	0xA7F8, { 0xF0, 0xA6, 0xAC, 0x99 },
	0xA7F9, { 0xF0, 0xA6, 0xAC, 0x96 },
	0xA7FA, { 0xE8, 0x8A, 0xBF },
	0xA7FB, { 0xE8, 0x8B, 0x8A },
	0xA7FC, { 0xF0, 0xA6, 0xAC, 0x94 },
	0xA7FD, { 0xF0, 0xA6, 0xAC, 0x98 },
	0xA7FE, { 0xE8, 0x8B, 0x81 },
	0xA8A1, { 0xE4, 0x92, 0xA0 },
	0xA8A2, { 0xF0, 0xA7, 0x88, 0x9F },
	0xA8A3, { 0xF0, 0xA7, 0x97, 0x9D },
	0xA8A4, { 0xF0, 0xA7, 0x97, 0x9F },
	0xA8A5, { 0xF0, 0xA8, 0x91, 0xA9 },
	0xA8A6, { 0xE8, 0xBF, 0x90 },
	0xA8A8, { 0xF0, 0xA8, 0x91, 0xAC },
	0xA8A9, { 0xE4, 0xA2, 0xB9 },
	0xA8AA, { 0xF0, 0xA8, 0x9A, 0x93 },
	0xA8AB, { 0xE9, 0x82, 0xAE },
	0xA8AC, { 0xF0, 0xA8, 0x9A, 0x95 },
	0xA8AD, { 0xF0, 0xA8, 0x9A, 0x94 },
	0xA8AE, { 0xF0, 0xA8, 0x9A, 0x91 },
	0xA8AF, { 0xF0, 0xA8, 0x9A, 0x97 },
	0xA8B0, { 0xF0, 0xA8, 0xB8, 0xB0 },
	0xA8B1, { 0xE4, 0xA7, 0x81 },
	0xA8B2, { 0xE4, 0xA7, 0x82 },
	0xA8B3, { 0xE9, 0x98, 0xB8 },
	0xA8B4, { 0xF0, 0xAF, 0xA8, 0x98 },
	0xA8B5, { 0xE3, 0x90, 0x9C },
	0xA8B6, { 0xF0, 0xA0, 0x88, 0xB1 },
	0xA8B7, { 0xE3, 0x91, 0x9E },
	0xA8B8, { 0xE4, 0xBE, 0xBC },
	0xA8B9, { 0xE3, 0x91, 0x99 },
	0xA8BA, { 0xE3, 0x91, 0x9C },
	0xA8BB, { 0xF0, 0xA0, 0x88, 0xB6 },
	0xA8BC, { 0xE3, 0x91, 0x9F },
	0xA8BD, { 0xE4, 0xBF, 0xA9 },
	0xA8BE, { 0xE4, 0xBE, 0xBD },
	0xA8BF, { 0xE4, 0xBF, 0xA2 },
	0xA8C0, { 0xE5, 0x85, 0x98 },
	0xA8C1, { 0xF0, 0xA0, 0x97, 0x89 },
	0xA8C2, { 0xF0, 0xA0, 0x97, 0x8A },
	0xA8C3, { 0xE3, 0x93, 0x8E },
	0xA8C4, { 0xF0, 0xA0, 0x9C, 0x98 },
	0xA8C5, { 0xF0, 0xA0, 0x9C, 0x92 },
	0xA8C6, { 0xF0, 0xA0, 0x9C, 0x99 },
	0xA8C7, { 0xF0, 0xA0, 0x9C, 0x90 },
	0xA8C8, { 0xF0, 0xA0, 0x9C, 0x96 },
	0xA8C9, { 0xE5, 0x8B, 0x86 },
	0xA8CA, { 0xF0, 0xA0, 0xA1, 0x9F },
	0xA8CB, { 0xE5, 0x8B, 0x88 },
	0xA8CC, { 0xF0, 0xA0, 0xA3, 0x9F },
	0xA8CD, { 0xF0, 0xA0, 0xA4, 0x97 },
	0xA8CE, { 0xE5, 0x8C, 0xA8 },
	0xA8CF, { 0xF0, 0xA0, 0xA4, 0xBC },
	0xA8D0, { 0xE5, 0x8C, 0xA9 },
	0xA8D1, { 0xF0, 0xA0, 0xA7, 0xAA },
	0xA8D2, { 0xF0, 0xA0, 0xA7, 0xA9 },
	0xA8D3, { 0xF0, 0xA0, 0xA8, 0x9C },
	0xA8D4, { 0xF0, 0xA0, 0xA9, 0x98 },
	0xA8D5, { 0xF0, 0xA0, 0xA9, 0xA4 },
	0xA8D6, { 0xF0, 0xA0, 0xAB, 0xB3 },
	0xA8D7, { 0xE3, 0x95, 0x9F },
	0xA8D8, { 0xF0, 0xA0, 0xB2, 0x97 },
	0xA8D9, { 0xE3, 0x96, 0x85 },
	0xA8DA, { 0xF0, 0xA0, 0xB1, 0x9A },
	0xA8DB, { 0xF0, 0xA0, 0xB1, 0x99 },
	0xA8DC, { 0xE3, 0x96, 0x86 },
	0xA8DD, { 0xF0, 0xA0, 0xB2, 0x8E },
	0xA8DE, { 0xE5, 0x9E, 0xB4 },
	0xA8DF, { 0xF0, 0xA1, 0x8A, 0xBC },
	0xA8E0, { 0xE5, 0x9E, 0xA9 },
	0xA8E1, { 0xE3, 0x9A, 0x87 },
	0xA8E2, { 0xF0, 0xA1, 0x98, 0x8D },
	0xA8E3, { 0xF0, 0xA1, 0x97, 0xBC },
	0xA8E4, { 0xF0, 0xA1, 0x98, 0x8C },
	0xA8E5, { 0xF0, 0xA1, 0x9C, 0x87 },
	0xA8E6, { 0xF0, 0xA1, 0x9C, 0x8A },
	0xA8E7, { 0xE3, 0x9B, 0x8A },
	0xA8E8, { 0xF0, 0xA1, 0x9C, 0x82 },
	0xA8E9, { 0xE3, 0x9B, 0x83 },
	0xA8EA, { 0xF0, 0xA1, 0x9C, 0xA6 },
	0xA8EB, { 0xF0, 0xA1, 0x9C, 0x88 },
	0xA8EC, { 0xF0, 0xA1, 0x9C, 0x9D },
	0xA8ED, { 0xE3, 0x9B, 0x82 },
	0xA8EE, { 0xE5, 0xAD, 0xA8 },
	0xA8EF, { 0xF0, 0xA1, 0xA5, 0x8E },
	0xA8F0, { 0xE3, 0x9D, 0x81 },
	0xA8F1, { 0xF0, 0xA1, 0xA7, 0xAD },
	0xA8F2, { 0xF0, 0xA1, 0xA7, 0xAE },
	0xA8F3, { 0xF0, 0xA1, 0xA7, 0xAF },
	0xA8F4, { 0xE3, 0x9E, 0x80 },
	0xA8F5, { 0xE3, 0x9E, 0x81 },
	0xA8F6, { 0xF0, 0xA1, 0xB1, 0x90 },
	0xA8F7, { 0xF0, 0xA1, 0xB1, 0x8C },
	0xA8F8, { 0xE3, 0x9E, 0x93 },
	0xA8F9, { 0xE3, 0x9E, 0x92 },
	0xA8FA, { 0xF0, 0xA1, 0xB1, 0x8F },
	0xA8FB, { 0xE3, 0x9F, 0x85 },
	0xA8FC, { 0xF0, 0xA1, 0xB7, 0x94 },
	0xA8FE, { 0xF0, 0xA1, 0xB6, 0xB0 },
	0xA9A1, { 0xE3, 0xA1, 0x86 },
	0xA9A2, { 0xE3, 0xA1, 0x81 },
	0xA9A3, { 0xE3, 0xA1, 0x85 },
	0xA9A4, { 0xE3, 0xA1, 0x82 },
	0xA9A5, { 0xE3, 0xA0, 0xBF },
	0xA9A6, { 0xF0, 0xA2, 0x82, 0xA5 },
	0xA9A7, { 0xF0, 0xA2, 0x88, 0x89 },
	0xA9A8, { 0xE3, 0xA2, 0x82 },
	0xA9A9, { 0xE3, 0xA2, 0x81 },
	0xA9AA, { 0xE3, 0xA1, 0xBF },
	0xA9AB, { 0xE3, 0xA2, 0xA5 },
	0xA9AC, { 0xE5, 0xBC, 0xAB },
	0xA9AD, { 0xE3, 0xA2, 0xB3 },
	0xA9AE, { 0xE3, 0xA2, 0xB5 },
	0xA9AF, { 0xF0, 0xA2, 0x8F, 0xB3 },
	0xA9B0, { 0xF0, 0xA2, 0x8F, 0x97 },
	0xA9B1, { 0xE5, 0xBE, 0x8D },
	0xA9B2, { 0xE3, 0xA3, 0x9A },
	0xA9B3, { 0xF0, 0xA2, 0x93, 0x9C },
	0xA9B4, { 0xE3, 0xA3, 0x9B },
	0xA9B5, { 0xE3, 0xA4, 0x8D },
	0xA9B6, { 0xE6, 0x80, 0x98 },
	0xA9B7, { 0xE3, 0xA4, 0x8E },
	0xA9B8, { 0xF0, 0xA2, 0x98, 0x8B },
	0xA9B9, { 0xE3, 0xA4, 0x9E },
	0xA9BA, { 0xE3, 0xA4, 0xA5 },
	0xA9BB, { 0xE3, 0xA4, 0xA6 },
	0xA9BC, { 0xE3, 0xA4, 0x9C },
	0xA9BD, { 0xE3, 0xA4, 0xA1 },
	0xA9BE, { 0xE6, 0x81, 0x97 },
	0xA9BF, { 0xE6, 0x81, 0x88 },
	0xA9C0, { 0xE3, 0xA4, 0xA7 },
	0xA9C1, { 0xE3, 0xA4, 0x9A },
	0xA9C2, { 0xF0, 0xA2, 0x98, 0xBA },
	0xA9C3, { 0xF0, 0xA2, 0x98, 0x8D },
	0xA9C4, { 0xF0, 0xA2, 0x98, 0x91 },
	0xA9C5, { 0xE6, 0x80, 0xB8 },
	0xA9C6, { 0xF0, 0xA2, 0x98, 0xA0 },
	0xA9C7, { 0xF0, 0xA2, 0x98, 0x81 },
	0xA9C8, { 0xE3, 0xA4, 0xA4 },
	0xA9C9, { 0xF0, 0xA2, 0x98, 0xB7 },
	0xA9CA, { 0xF0, 0xAF, 0xA2, 0xA3 },
	0xA9CB, { 0xE6, 0x81, 0xB1 },
	0xA9CC, { 0xF0, 0xA2, 0xA6, 0xAA },
	0xA9CD, { 0xE3, 0xA7, 0x81 },
	0xA9CE, { 0xE3, 0xA7, 0xA1 },
	0xA9CF, { 0xF0, 0xA2, 0xAB, 0xA7 },
	0xA9D0, { 0xF0, 0xA2, 0xAB, 0xA8 },
	0xA9D1, { 0xE6, 0x8C, 0x92 },
	0xA9D2, { 0xE3, 0xA7, 0xAB },
	0xA9D3, { 0xF0, 0xA2, 0xAB, 0xB5 },
	0xA9D4, { 0xE3, 0xA7, 0xA2 },
	0xA9D5, { 0xE3, 0xA7, 0x97 },
	0xA9D6, { 0xE3, 0xA7, 0xA9 },
	0xA9D7, { 0xF0, 0xA2, 0xAC, 0xB5 },
	0xA9D8, { 0xF0, 0xA2, 0xAB, 0xA6 },
	0xA9D9, { 0xE6, 0x8C, 0x8A },
	0xA9DA, { 0xF0, 0xA2, 0xAB, 0xB8 },
	0xA9DB, { 0xE6, 0x8C, 0xA3 },
	0xA9DC, { 0xF0, 0xA2, 0xAB, 0xB1 },
	0xA9DD, { 0xE3, 0xAA, 0x84 },
	0xA9DE, { 0xF0, 0xA2, 0xBC, 0x94 },
	0xA9DF, { 0xF0, 0xA2, 0xBC, 0x95 },
	0xA9E0, { 0xF0, 0xA2, 0xBC, 0x89 },
	0xA9E1, { 0xE3, 0xAA, 0xB5 },
	0xA9E2, { 0xE3, 0xAA, 0xBC },
	0xA9E3, { 0xE3, 0xAB, 0x9C },
	0xA9E4, { 0xE3, 0xAB, 0x9E },
	0xA9E5, { 0xE3, 0xAB, 0x9F },
	0xA9E6, { 0xF0, 0xA3, 0x85, 0xBB },
	0xA9E7, { 0xE6, 0x98, 0xAA },
	0xA9E8, { 0xF0, 0xA3, 0x85, 0xBE },
	0xA9E9, { 0xF0, 0xA3, 0x8D, 0xA6 },
	0xA9EA, { 0xF0, 0xA3, 0x8D, 0xA7 },
	0xA9EB, { 0xF0, 0xA3, 0x90, 0x8A },
	0xA9EC, { 0xE3, 0xAD, 0x94 },
	0xA9ED, { 0xE6, 0x9F, 0xA0 },
	0xA9EE, { 0xE6, 0x9E, 0xBE },
	0xA9EF, { 0xE3, 0xAD, 0x93 },
	0xA9F0, { 0xE3, 0xB0, 0xA4 },
	0xA9F1, { 0xE3, 0xB0, 0xA5 },
	0xA9F2, { 0xE6, 0xAC, 0xA9 },
	0xA9F3, { 0xE3, 0xB0, 0xA8 },
	0xA9F4, { 0xE3, 0xB0, 0xA7 },
	0xA9F5, { 0xF0, 0xA3, 0xA2, 0x9C },
	0xA9F6, { 0xF0, 0xA3, 0xA5, 0xA2 },
	0xA9F7, { 0xF0, 0xA3, 0xA7, 0xA1 },
	0xA9F8, { 0xF0, 0xA3, 0xA7, 0x9E },
	0xA9F9, { 0xF0, 0xA3, 0xA7, 0x9F },
	0xA9FA, { 0xF0, 0xA3, 0xA7, 0xA9 },
	0xA9FB, { 0xE3, 0xB2, 0x8B },
	0xA9FC, { 0xF0, 0xA3, 0xB3, 0xA4 },
	0xA9FD, { 0xF0, 0xA3, 0xB3, 0xB7 },
	0xA9FE, { 0xE3, 0xB3, 0x9C },
	0xAAA1, { 0xE6, 0xB5, 0x83 },
	0xAAA2, { 0xF0, 0xA3, 0xB3, 0xAA },
	0xAAA3, { 0xF0, 0xA3, 0xB3, 0xB6 },
	0xAAA4, { 0xF0, 0xA3, 0xB4, 0x92 },
	0xAAA5, { 0xF0, 0xAF, 0xA4, 0x81 },
	0xAAA6, { 0xE7, 0x82, 0xA6 },
	0xAAA7, { 0xE3, 0xB6, 0xB2 },
	0xAAA8, { 0xE7, 0x83, 0x80 },
	0xAAA9, { 0xF0, 0xA4, 0x87, 0x99 },
	0xAAAA, { 0xE7, 0x88, 0xAF },
	0xAAAB, { 0xF0, 0xA4, 0x95, 0x9F },
	0xAAAC, { 0xE3, 0xB8, 0x9B },
	0xAAAD, { 0xF0, 0xA4, 0x95, 0xB3 },
	0xAAAE, { 0xE3, 0xB8, 0xB2 },
	0xAAAF, { 0xE7, 0x89, 0xB1 },
	0xAAB0, { 0xF0, 0xA4, 0x98, 0xBF },
	0xAAB1, { 0xF0, 0xA4, 0x9D, 0xB8 },
	0xAAB2, { 0xE3, 0xB9, 0xAB },
	0xAAB3, { 0xF0, 0xA4, 0x9D, 0xBD },
	0xAAB4, { 0xE3, 0xB9, 0xAC },
	0xAAB5, { 0xE3, 0xB9, 0xAD },
	0xAAB6, { 0xF0, 0xA4, 0xA4, 0x92 },
	0xAAB7, { 0xE3, 0xBA, 0xB9 },
	0xAAB8, { 0xE3, 0xBA, 0xBA },
	0xAAB9, { 0xE3, 0xBC, 0x89 },
	0xAABA, { 0xE3, 0xBC, 0x8A },
	0xAABB, { 0xF0, 0xA4, 0xAC, 0xAF },
	0xAABC, { 0xE7, 0x93, 0xAA },
	0xAABD, { 0xE3, 0xBC, 0x9B },
	0xAABE, { 0xF0, 0xA4, 0xAC, 0xB0 },
	0xAABF, { 0xF0, 0xA4, 0xAF, 0x9B },
	0xAAC0, { 0xE7, 0x94, 0xA0 },
	0xAAC1, { 0xE3, 0xBD, 0x98 },
	0xAAC2, { 0xF0, 0xA4, 0xB0, 0xA9 },
	0xAAC3, { 0xE3, 0xBD, 0x9A },
	0xAAC4, { 0xF0, 0xAF, 0xA4, 0xB6 },
	0xAAC5, { 0xF0, 0xA4, 0xB5, 0x80 },
	0xAAC6, { 0xE3, 0xBD, 0xB7 },
	0xAAC7, { 0xF0, 0xA4, 0xB4, 0xBD },
	0xAAC8, { 0xF0, 0xA4, 0xB4, 0xBE },
	0xAAC9, { 0xE3, 0xBD, 0xB9 },
	0xAACA, { 0xE7, 0x96, 0xA9 },
	0xAACB, { 0xF0, 0xA4, 0xB4, 0xB8 },
	0xAACC, { 0xE7, 0x9A, 0x85 },
	0xAACD, { 0xF0, 0xA4, 0xBD, 0x88 },
	0xAACE, { 0xE3, 0xBF, 0xAB },
	0xAACF, { 0xF0, 0xA4, 0xBF, 0x90 },
	0xAAD0, { 0xE3, 0xBF, 0xBD },
	0xAAD1, { 0xE3, 0xBF, 0xBC },
	0xAAD2, { 0xE7, 0x9C, 0x86 },
	0xAAD3, { 0xE4, 0x80, 0x95 },
	0xAAD4, { 0xE4, 0x80, 0x98 },
	0xAAD5, { 0xE7, 0x9B, 0xB6 },
	0xAAD6, { 0xE4, 0x80, 0x96 },
	0xAAD7, { 0xE4, 0x80, 0x97 },
	0xAAD8, { 0xE4, 0x80, 0x99 },
	0xAAD9, { 0xE7, 0x9C, 0x80 },
	0xAADA, { 0xE4, 0x80, 0x9B },
	0xAADB, { 0xF0, 0xA5, 0x84, 0x8E },
	0xAADC, { 0xF0, 0xA5, 0x84, 0x89 },
	0xAADD, { 0xE7, 0x9C, 0x82 },
	0xAADE, { 0xF0, 0xA5, 0x84, 0x87 },
	0xAADF, { 0xE4, 0x82, 0x87 },
	0xAAE0, { 0xF0, 0xA5, 0x8D, 0x9F },
	0xAAE1, { 0xF0, 0xA5, 0x8D, 0xA0 },
	0xAAE2, { 0xE4, 0x82, 0x9C },
	0xAAE3, { 0xF0, 0xA5, 0x90, 0xAA },
	0xAAE4, { 0xE4, 0x82, 0x9A },
	0xAAE5, { 0xF0, 0xA5, 0x90, 0xA9 },
	0xAAE6, { 0xE4, 0x83, 0xBF },
	0xAAE7, { 0xE4, 0x83, 0xBE },
	0xAAE8, { 0xF0, 0xA5, 0x99, 0x8D },
	0xAAE9, { 0xE4, 0x84, 0xB1 },
	0xAAEA, { 0xE4, 0x84, 0xAE },
	0xAAEB, { 0xE4, 0x84, 0xB0 },
	0xAAEC, { 0xE4, 0x84, 0xB2 },
	0xAAED, { 0xF0, 0xA5, 0x9D, 0xAC },
	0xAAEF, { 0xE4, 0x84, 0xAF },
	0xAAF0, { 0xF0, 0xA5, 0x9D, 0xA7 },
	0xAAF1, { 0xE4, 0x86, 0x95 },
	0xAAF2, { 0xE4, 0x86, 0x96 },
	0xAAF3, { 0xF0, 0xA5, 0xA4, 0xB9 },
	0xAAF4, { 0xF0, 0xA5, 0xA4, 0xB4 },
	0xAAF5, { 0xF0, 0xA5, 0xA9, 0x99 },
	0xAAF6, { 0xE4, 0x87, 0x85 },
	0xAAF7, { 0xE4, 0x89, 0xBA },
	0xAAF8, { 0xF0, 0xA6, 0x88, 0xA3 },
	0xAAF9, { 0xE4, 0x8D, 0x82 },
	0xAAFA, { 0xF0, 0xA6, 0x8A, 0x82 },
	0xAAFB, { 0xE4, 0x8D, 0x94 },
	0xAAFC, { 0xF0, 0xA6, 0x8A, 0x83 },
	0xAAFD, { 0xF0, 0xA6, 0x8A, 0xA8 },
	0xAAFE, { 0xF0, 0xA6, 0x8D, 0x95 },
	0xABA1, { 0xF0, 0xA6, 0x8F, 0xB9 },
	0xABA2, { 0xF0, 0xA6, 0x8F, 0xB8 },
	0xABA3, { 0xF0, 0xA6, 0x8F, 0xBC },
	0xABA4, { 0xF0, 0xA6, 0x8F, 0xBA },
	0xABA5, { 0xE8, 0x80, 0x89 },
	0xABA6, { 0xF0, 0xAF, 0xA5, 0xBA },
	0xABA7, { 0xE4, 0x8E, 0x9F },
	0xABA8, { 0xE4, 0x8E, 0xA0 },
	0xABA9, { 0xE4, 0x8E, 0xA2 },
	0xABAA, { 0xE4, 0x8F, 0xA0 },
	0xABAB, { 0xF0, 0xA6, 0x99, 0xB4 },
	0xABAC, { 0xE4, 0x8F, 0xA1 },
	0xABAD, { 0xF0, 0xA6, 0x99, 0xAB },
	0xABAE, { 0xF0, 0xA6, 0x99, 0xB1 },
	0xABAF, { 0xE4, 0x8F, 0x9F },
	0xABB0, { 0xF0, 0xA6, 0x99, 0xB6 },
	0xABB1, { 0xF0, 0xA6, 0xA8, 0x8E },
	0xABB2, { 0xE4, 0x91, 0xA2 },
	0xABB3, { 0xE4, 0x91, 0xA1 },
	0xABB4, { 0xF0, 0xA6, 0xA8, 0x90 },
	0xABB5, { 0xF0, 0xA6, 0xA8, 0x8F },
	0xABB6, { 0xE4, 0x92, 0xA7 },
	0xABB7, { 0xF0, 0xA6, 0xAC, 0xB8 },
	0xABB8, { 0xF0, 0xA6, 0xAC, 0xB9 },
	0xABB9, { 0xF0, 0xA6, 0xAC, 0xBA },
	0xABBA, { 0xE8, 0x8B, 0x9A },
	0xABBB, { 0xF0, 0xA6, 0xAC, 0xB7 },
	0xABBC, { 0xF0, 0xA6, 0xAC, 0xBE },
	0xABBD, { 0xE8, 0x8C, 0x8A },
	0xABBE, { 0xE4, 0x96, 0x89 },
	0xABBF, { 0xF0, 0xA7, 0x86, 0x9C },
	0xABC0, { 0xF0, 0xA7, 0x88, 0xAA },
	0xABC1, { 0xF0, 0xA7, 0x88, 0xBA },
	0xABC2, { 0xF0, 0xA7, 0x88, 0xAB },
	0xABC3, { 0xF0, 0xA7, 0x88, 0xA8 },
	0xABC4, { 0xF0, 0xA7, 0x96, 0xAA },
	0xABC5, { 0xF0, 0xA7, 0x98, 0x8F },
	0xABC6, { 0xE4, 0x98, 0x9D },
	0xABC7, { 0xF0, 0xA7, 0x98, 0x90 },
	0xABC8, { 0xF0, 0xA7, 0x9F, 0xA6 },
	0xABC9, { 0xE4, 0x9C, 0xAA },
	0xABCA, { 0xF0, 0xA7, 0xB4, 0xA5 },
	0xABCB, { 0xF0, 0xA7, 0xBA, 0x8E },
	0xABCC, { 0xE4, 0x9F, 0x93 },
	0xABCD, { 0xE4, 0xA1, 0x82 },
	0xABCE, { 0xE4, 0xA1, 0x83 },
	0xABCF, { 0xF0, 0xA8, 0x92, 0x8B },
	0xABD0, { 0xE4, 0xA2, 0x91 },
	0xABD1, { 0xF0, 0xA8, 0x92, 0x8C },
	0xABD2, { 0xF0, 0xA8, 0x92, 0x9A },
	0xABD3, { 0xE4, 0xA2, 0x90 },
	0xABD4, { 0xE4, 0xA2, 0xBF },
	0xABD5, { 0xF0, 0xA8, 0x9A, 0xB3 },
	0xABD6, { 0xE4, 0xA2, 0xBC },
	0xABD7, { 0xF0, 0xA8, 0x9A, 0xB2 },
	0xABD8, { 0xE4, 0xA3, 0x80 },
	0xABD9, { 0xE4, 0xA7, 0x87 },
	0xABDA, { 0xE4, 0xA7, 0x85 },
	0xABDB, { 0xE9, 0x99, 0x95 },
	0xABDC, { 0xF0, 0xA8, 0xB9, 0x84 },
	0xABDD, { 0xE9, 0x99, 0x92 },
	0xABDE, { 0xE4, 0xB8, 0xB5 },
	0xABDF, { 0xF0, 0xA0, 0x85, 0x98 },
	0xABE0, { 0xF0, 0xA0, 0x8A, 0xA7 },
	0xABE1, { 0xE5, 0x80, 0xB4 },
	0xABE2, { 0xE5, 0x80, 0x81 },
	0xABE3, { 0xF0, 0xA0, 0x89, 0xA3 },
	0xABE4, { 0xE5, 0x80, 0x8A },
	0xABE5, { 0xE3, 0x91, 0xA6 },
	0xABE6, { 0xF0, 0xA0, 0x89, 0xAA },
	0xABE7, { 0xF0, 0xA0, 0x89, 0xA5 },
	0xABE8, { 0xF0, 0xA0, 0x89, 0xAB },
	0xABE9, { 0xE3, 0x92, 0xAD },
	0xABEA, { 0xF0, 0xA0, 0x93, 0xAD },
	0xABEB, { 0xF0, 0xA0, 0x97, 0x99 },
	0xABEC, { 0xF0, 0xA0, 0x9C, 0xBB },
	0xABED, { 0xF0, 0xA0, 0x9C, 0xB2 },
	0xABEE, { 0xE5, 0x89, 0x98 },
	0xABEF, { 0xF0, 0xA0, 0x9C, 0xB5 },
	0xABF0, { 0xF0, 0xA0, 0x9C, 0xB1 },
	0xABF1, { 0xF0, 0xA0, 0x9C, 0xBE },
	0xABF2, { 0xF0, 0xA0, 0x9D, 0x83 },
	0xABF3, { 0xF0, 0xA0, 0x9C, 0xB6 },
	0xABF4, { 0xF0, 0xA0, 0xA1, 0xAD },
	0xABF5, { 0xE3, 0x94, 0x9D },
	0xABF6, { 0xF0, 0xA0, 0xA3, 0xA4 },
	0xABF7, { 0xE3, 0x94, 0xB1 },
	0xABF8, { 0xE5, 0x8C, 0xAB },
	0xABF9, { 0xF0, 0xA0, 0xA7, 0xB4 },
	0xABFA, { 0xE3, 0x95, 0x8C },
	0xABFB, { 0xF0, 0xA0, 0xA9, 0xA9 },
	0xABFC, { 0xF0, 0xA0, 0xA9, 0xAB },
	0xABFD, { 0xE3, 0x96, 0x95 },
	0xABFE, { 0xE3, 0x96, 0x91 },
	0xACA1, { 0xE3, 0x96, 0x94 },
	0xACA2, { 0xF0, 0xA0, 0xB2, 0xBF },
	0xACA3, { 0xF0, 0xA0, 0xB3, 0x83 },
	0xACA4, { 0xF0, 0xA0, 0xB2, 0xAE },
	0xACA5, { 0xE3, 0x96, 0x8F },
	0xACA6, { 0xE5, 0x93, 0xAC },
	0xACA7, { 0xF0, 0xA0, 0xB2, 0xB1 },
	0xACA8, { 0xE5, 0x94, 0x95 },
	0xACA9, { 0xE5, 0x93, 0xBE },
	0xACAA, { 0xF0, 0xA0, 0xB2, 0xBB },
	0xACAB, { 0xF0, 0xA0, 0xB2, 0xAF },
	0xACAC, { 0xF0, 0xA0, 0xB2, 0xB0 },
	0xACAD, { 0xE5, 0x93, 0xA3 },
	0xACAE, { 0xE5, 0x94, 0x96 },
	0xACAF, { 0xE3, 0x99, 0x80 },
	0xACB0, { 0xF0, 0xA1, 0x8B, 0xAF },
	0xACB1, { 0xE3, 0x99, 0x81 },
	0xACB2, { 0xF0, 0xA1, 0x8B, 0xAD },
	0xACB3, { 0xE5, 0x9F, 0x93 },
	0xACB4, { 0xF0, 0xA1, 0x8B, 0xB0 },
	0xACB5, { 0xF0, 0xA1, 0x96, 0x93 },
	0xACB6, { 0xF0, 0xA1, 0x98, 0xB4 },
	0xACB7, { 0xF0, 0xA1, 0x98, 0xAB },
	0xACB8, { 0xE5, 0xA5, 0x99 },
	0xACB9, { 0xE5, 0xA8, 0xA7 },
	0xACBA, { 0xE3, 0x9B, 0x98 },
	0xACBB, { 0xE3, 0x9B, 0x92 },
	0xACBC, { 0xE3, 0x9B, 0x9A },
	0xACBD, { 0xE5, 0xA8, 0xA8 },
	0xACBE, { 0xE5, 0xA8, 0x90 },
	0xACBF, { 0xE3, 0x9B, 0x97 },
	0xACC0, { 0xE5, 0xA8, 0x8E },
	0xACC1, { 0xE3, 0x9D, 0x82 },
	0xACC2, { 0xE3, 0x9D, 0x97 },
	0xACC3, { 0xF0, 0xA1, 0xA8, 0x84 },
	0xACC4, { 0xF0, 0xA1, 0xA8, 0x83 },
	0xACC5, { 0xF0, 0xA1, 0xA8, 0x82 },
	0xACC6, { 0xE5, 0xAE, 0xAF },
	0xACC7, { 0xF0, 0xA1, 0xA8, 0x85 },
	0xACC8, { 0xE5, 0xAE, 0xBA },
	0xACC9, { 0xE5, 0xAE, 0xB1 },
	0xACCA, { 0xF0, 0xA1, 0xA8, 0x80 },
	0xACCB, { 0xF0, 0xA1, 0xAD, 0xB4 },
	0xACCC, { 0xE3, 0x9D, 0xB8 },
	0xACCD, { 0xE3, 0x9E, 0x82 },
	0xACCE, { 0xE3, 0x9E, 0x97 },
	0xACCF, { 0xF0, 0xA1, 0xB1, 0xA5 },
	0xACD0, { 0xF0, 0xA1, 0xB1, 0xA3 },
	0xACD1, { 0xE3, 0x9F, 0x89 },
	0xACD2, { 0xF0, 0xA1, 0xB7, 0x97 },
	0xACD3, { 0xE3, 0x9F, 0x88 },
	0xACD4, { 0xE3, 0x9F, 0x96 },
	0xACD5, { 0xE3, 0x9F, 0x8C },
	0xACD6, { 0xF0, 0xA1, 0xB7, 0xA8 },
	0xACD7, { 0xE3, 0x9F, 0x90 },
	0xACD8, { 0xF0, 0xA1, 0xB7, 0x9B },
	0xACD9, { 0xF0, 0xA1, 0xB7, 0x98 },
	0xACDA, { 0xE3, 0x9F, 0x8E },
	0xACDB, { 0xE3, 0x9F, 0x87 },
	0xACDC, { 0xE5, 0xB3, 0xBC },
	0xACDD, { 0xF0, 0xA1, 0xB8, 0x89 },
	0xACDE, { 0xE3, 0x9F, 0x8F },
	0xACDF, { 0xE3, 0x9F, 0x8B },
	0xACE0, { 0xE5, 0xB3, 0xB2 },
	0xACE1, { 0xE5, 0xB3, 0xBE },
	0xACE2, { 0xF0, 0xA1, 0xB7, 0xA5 },
	0xACE3, { 0xF0, 0xA1, 0xB7, 0xA7 },
	0xACE4, { 0xE5, 0xB7, 0xB8 },
	0xACE5, { 0xF0, 0xA2, 0x80, 0xBF },
	0xACE6, { 0xE3, 0xA1, 0x87 },
	0xACE7, { 0xF0, 0xA2, 0x83, 0x80 },
	0xACE8, { 0xE3, 0xA1, 0x88 },
	0xACE9, { 0xF0, 0xA2, 0x82, 0xB9 },
	0xACEA, { 0xF0, 0xA2, 0x82, 0xBA },
	0xACEB, { 0xE3, 0xA2, 0x83 },
	0xACEC, { 0xE3, 0xA2, 0x85 },
	0xACED, { 0xE3, 0xA2, 0x84 },
	0xACEE, { 0xF0, 0xA2, 0x88, 0xA0 },
	0xACEF, { 0xF0, 0xA2, 0x8D, 0x8F },
	0xACF0, { 0xE5, 0xBC, 0xAC },
	0xACF1, { 0xE3, 0xA2, 0xB8 },
	0xACF2, { 0xE3, 0xA2, 0xBC },
	0xACF3, { 0xF0, 0xA2, 0x92, 0x91 },
	0xACF4, { 0xF0, 0xA2, 0x92, 0x90 },
	0xACF5, { 0xF0, 0xA2, 0x93, 0xAE },
	0xACF6, { 0xF0, 0xA2, 0x93, 0xB3 },
	0xACF7, { 0xF0, 0xA2, 0x93, 0xAC },
	0xACF8, { 0xF0, 0xA2, 0x93, 0xB1 },
	0xACF9, { 0xF0, 0xA2, 0x93, 0xAB },
	0xACFA, { 0xF0, 0xA2, 0x93, 0xB2 },
	0xACFB, { 0xF0, 0xA2, 0x93, 0xB4 },
	0xACFC, { 0xF0, 0xA2, 0x93, 0xAD },
	0xACFD, { 0xF0, 0xA2, 0x99, 0x81 },
	0xACFE, { 0xF0, 0xA2, 0x99, 0x88 },
	0xADA1, { 0xF0, 0xA2, 0x99, 0x85 },
	0xADA2, { 0xE3, 0xA4, 0xB1 },
	0xADA3, { 0xE3, 0xA4, 0xB4 },
	0xADA4, { 0xE3, 0xA4, 0xB6 },
	0xADA5, { 0xE6, 0x82, 0x82 },
	0xADA6, { 0xF0, 0xA2, 0x99, 0xBF },
	0xADA7, { 0xF0, 0xA2, 0x9A, 0x8B },
	0xADA8, { 0xE3, 0xA4, 0xA3 },
	0xADA9, { 0xF0, 0xA2, 0x98, 0xBB },
	0xADAA, { 0xF0, 0xA2, 0x99, 0x8E },
	0xADAB, { 0xE3, 0xA4, 0xBA },
	0xADAC, { 0xE6, 0x82, 0x91 },
	0xADAD, { 0xE6, 0x82, 0x8F },
	0xADAE, { 0xF0, 0xA2, 0x99, 0xBC },
	0xADAF, { 0xE3, 0xA6, 0xB4 },
	0xADB0, { 0xE3, 0xA6, 0xB5 },
	0xADB1, { 0xE3, 0xA7, 0xAD },
	0xADB2, { 0xE3, 0xA7, 0xAC },
	0xADB3, { 0xE3, 0xA7, 0x98 },
	0xADB4, { 0xF0, 0xA2, 0xAB, 0xB0 },
	0xADB5, { 0xF0, 0xA2, 0xAC, 0xB6 },
	0xADB6, { 0xF0, 0xA2, 0xAC, 0xBF },
	0xADB7, { 0xF0, 0xA2, 0xAD, 0x83 },
	0xADB8, { 0xF0, 0xA2, 0xAC, 0xB1 },
	0xADB9, { 0xF0, 0xA2, 0xAC, 0xB4 },
	0xADBA, { 0xF0, 0xA2, 0xAD, 0x86 },
	0xADBB, { 0xE3, 0xA7, 0xB6 },
	0xADBC, { 0xE3, 0xA7, 0xA7 },
	0xADBD, { 0xF0, 0xA2, 0xAC, 0xAF },
	0xADBE, { 0xF0, 0xA2, 0xBB, 0x83 },
	0xADBF, { 0xE3, 0xA9, 0xBC },
	0xADC0, { 0xE3, 0xA9, 0xBB },
	0xADC1, { 0xF0, 0xA2, 0xBC, 0xB6 },
	0xADC2, { 0xE3, 0xAA, 0x88 },
	0xADC3, { 0xE6, 0x95, 0x87 },
	0xADC4, { 0xE6, 0x95, 0x8C },
	0xADC5, { 0xF0, 0xA2, 0xBC, 0xA1 },
	0xADC6, { 0xF0, 0xAF, 0xA3, 0x88 },
	0xADC7, { 0xE6, 0x96, 0x8A },
	0xADC8, { 0xF0, 0xA3, 0x81, 0xB3 },
	0xADC9, { 0xE3, 0xAA, 0xBE },
	0xADCA, { 0xF0, 0xA3, 0x83, 0xA6 },
	0xADCB, { 0xE3, 0xAB, 0xA7 },
	0xADCC, { 0xE3, 0xAB, 0xA5 },
	0xADCD, { 0xE3, 0xAB, 0xAE },
	0xADCE, { 0xE6, 0x9F, 0xA1 },
	0xADCF, { 0xE6, 0xA1, 0x8A },
	0xADD0, { 0xF0, 0xA3, 0x90, 0xBF },
	0xADD1, { 0xE3, 0xAD, 0x99 },
	0xADD2, { 0xE3, 0xAD, 0x9E },
	0xADD3, { 0xF0, 0xA3, 0x91, 0xAB },
	0xADD4, { 0xE3, 0xAD, 0x9A },
	0xADD5, { 0xE6, 0xA0, 0xBF },
	0xADD6, { 0xE3, 0xAD, 0xA1 },
	0xADD7, { 0xE3, 0xAD, 0x98 },
	0xADD8, { 0xE3, 0xAD, 0x9B },
	0xADD9, { 0xE6, 0x9E, 0xBD },
	0xADDA, { 0xF0, 0xA3, 0x91, 0xB1 },
	0xADDB, { 0xE3, 0xAD, 0x9F },
	0xADDC, { 0xF0, 0xAF, 0xA3, 0xA2 },
	0xADDD, { 0xE3, 0xB0, 0xAA },
	0xADDE, { 0xE3, 0xB0, 0xAD },
	0xADDF, { 0xF0, 0xA3, 0xA2, 0xB0 },
	0xADE0, { 0xE3, 0xB0, 0xA3 },
	0xADE1, { 0xE3, 0xB0, 0xAB },
	0xADE2, { 0xE3, 0xB0, 0xAC },
	0xADE3, { 0xF0, 0xA3, 0xA7, 0xB3 },
	0xADE4, { 0xE3, 0xB1, 0xBE },
	0xADE5, { 0xF0, 0xAF, 0xA3, 0xB5 },
	0xADE6, { 0xE3, 0xB2, 0x93 },
	0xADE7, { 0xE3, 0xB2, 0x99 },
	0xADE8, { 0xF0, 0xA3, 0xAD, 0xA1 },
	0xADE9, { 0xF0, 0xA3, 0xAD, 0x9F },
	0xADEA, { 0xE3, 0xB2, 0xB3 },
	0xADEB, { 0xE3, 0xB3, 0xA7 },
	0xADEC, { 0xE3, 0xB3, 0xAA },
	0xADED, { 0xF0, 0xA3, 0xB4, 0xA8 },
	0xADEE, { 0xF0, 0xA3, 0xB4, 0x9E },
	0xADEF, { 0xF0, 0xA3, 0xB4, 0xA9 },
	0xADF0, { 0xF0, 0xAF, 0xA4, 0x82 },
	0xADF1, { 0xF0, 0xA3, 0xB3, 0xAB },
	0xADF2, { 0xF0, 0xA3, 0xB5, 0xA6 },
	0xADF3, { 0xE3, 0xB6, 0xB4 },
	0xADF4, { 0xF0, 0xA4, 0x87, 0xB6 },
	0xADF5, { 0xE7, 0x83, 0x89 },
	0xADF6, { 0xE3, 0xB8, 0x97 },
	0xADF7, { 0xF0, 0xA4, 0x95, 0xA0 },
	0xADF8, { 0xF0, 0xA4, 0x95, 0xB7 },
	0xADF9, { 0xF0, 0xA4, 0x96, 0xBB },
	0xADFA, { 0xE3, 0xB8, 0xA1 },
	0xADFB, { 0xF0, 0xA4, 0x96, 0xBC },
	0xADFC, { 0xE3, 0xB8, 0xB8 },
	0xADFD, { 0xE3, 0xB8, 0xB7 },
	0xADFE, { 0xE3, 0xB9, 0xB4 },
	0xAEA1, { 0xE3, 0xB9, 0xB3 },
	0xAEA2, { 0xE3, 0xB9, 0xB5 },
	0xAEA3, { 0xF0, 0xA4, 0x9E, 0xA2 },
	0xAEA4, { 0xF0, 0xA4, 0x9E, 0xB2 },
	0xAEA5, { 0xF0, 0xA4, 0x9E, 0x9E },
	0xAEA6, { 0xE3, 0xB9, 0xB6 },
	0xAEA7, { 0xE3, 0xB9, 0xB8 },
	0xAEA8, { 0xF0, 0xA4, 0xA4, 0xBA },
	0xAEA9, { 0xF0, 0xA4, 0xA4, 0xB8 },
	0xAEAA, { 0xE7, 0x8E, 0xBA },
	0xAEAB, { 0xE3, 0xBC, 0x8C },
	0xAEAC, { 0xE3, 0xBC, 0xA0 },
	0xAEAD, { 0xE3, 0xBC, 0x9E },
	0xAEAE, { 0xF0, 0xA4, 0xB1, 0x8D },
	0xAEAF, { 0xE3, 0xBD, 0x9B },
	0xAEB0, { 0xF0, 0xA4, 0xB1, 0x9E },
	0xAEB1, { 0xE3, 0xBD, 0x9C },
	0xAEB2, { 0xF0, 0xA4, 0xB4, 0x97 },
	0xAEB3, { 0xE3, 0xBE, 0x83 },
	0xAEB4, { 0xE7, 0x97, 0x86 },
	0xAEB5, { 0xE3, 0xBE, 0x80 },
	0xAEB6, { 0xE3, 0xBE, 0x81 },
	0xAEB7, { 0xE3, 0xBD, 0xBE },
	0xAEB8, { 0xE3, 0xBE, 0x88 },
	0xAEB9, { 0xE3, 0xBE, 0x85 },
	0xAEBA, { 0xE3, 0xBE, 0x89 },
	0xAEBB, { 0xE3, 0xBD, 0xBF },
	0xAEBC, { 0xE3, 0xBE, 0x8E },
	0xAEBD, { 0xF0, 0xA4, 0xB5, 0xA4 },
	0xAEBE, { 0xF0, 0xA4, 0xB5, 0xA7 },
	0xAEBF, { 0xE3, 0xBE, 0x84 },
	0xAEC0, { 0xE7, 0x96, 0xB7 },
	0xAEC1, { 0xE7, 0x9A, 0x8C },
	0xAEC2, { 0xF0, 0xA4, 0xBD, 0x99 },
	0xAEC3, { 0xE7, 0x9A, 0x8D },
	0xAEC4, { 0xF0, 0xA4, 0xBF, 0x9A },
	0xAEC5, { 0xE3, 0xBF, 0xAE },
	0xAEC6, { 0xE3, 0xBF, 0xAD },
	0xAEC7, { 0xE3, 0xBF, 0xBE },
	0xAEC8, { 0xF0, 0xA5, 0x81, 0x91 },
	0xAEC9, { 0xE3, 0xBF, 0xBF },
	0xAECA, { 0xF0, 0xA5, 0x81, 0x95 },
	0xAECB, { 0xF0, 0xA5, 0x84, 0xBB },
	0xAECC, { 0xF0, 0xA5, 0x84, 0xB4 },
	0xAECD, { 0xE4, 0x80, 0xA3 },
	0xAECE, { 0xF0, 0xA5, 0x84, 0xB7 },
	0xAECF, { 0xE7, 0x9C, 0x97 },
	0xAED0, { 0xF0, 0xA5, 0x84, 0xB1 },
	0xAED1, { 0xE7, 0x9C, 0x9C },
	0xAED2, { 0xE4, 0x80, 0x9F },
	0xAED3, { 0xF0, 0xA5, 0x84, 0xBF },
	0xAED4, { 0xF0, 0xA5, 0x85, 0x99 },
	0xAED5, { 0xE7, 0x9C, 0x94 },
	0xAED6, { 0xF0, 0xA5, 0x8D, 0xA1 },
	0xAED7, { 0xE4, 0x82, 0x8F },
	0xAED8, { 0xE4, 0x82, 0x90 },
	0xAED9, { 0xF0, 0xA5, 0x91, 0x98 },
	0xAEDA, { 0xF0, 0xA5, 0x91, 0xA2 },
	0xAEDB, { 0xF0, 0xA5, 0x91, 0x90 },
	0xAEDC, { 0xE4, 0x82, 0xA0 },
	0xAEDD, { 0xF0, 0xA5, 0x91, 0x91 },
	0xAEDE, { 0xE4, 0x82, 0xA6 },
	0xAEDF, { 0xE4, 0x82, 0x9F },
	0xAEE0, { 0xF0, 0xA5, 0x91, 0x86 },
	0xAEE1, { 0xE4, 0x82, 0xA7 },
	0xAEE2, { 0xE4, 0x82, 0xA1 },
	0xAEE3, { 0xF0, 0xA5, 0x98, 0xAD },
	0xAEE4, { 0xE4, 0x84, 0x82 },
	0xAEE5, { 0xE4, 0x84, 0xB6 },
	0xAEE6, { 0xF0, 0xA5, 0xA5, 0x88 },
	0xAEE7, { 0xF0, 0xA5, 0xA5, 0x91 },
	0xAEE8, { 0xF0, 0xA5, 0xA5, 0x8A },
	0xAEE9, { 0xF0, 0xA5, 0xA5, 0x8F },
	0xAEEA, { 0xF0, 0xA5, 0xA5, 0x90 },
	0xAEEB, { 0xF0, 0xA5, 0xA5, 0x89 },
	0xAEEC, { 0xF0, 0xA5, 0xA9, 0xA3 },
	0xAEED, { 0xE4, 0x87, 0x88 },
	0xAEEE, { 0xF0, 0xA5, 0xA9, 0xA6 },
	0xAEEF, { 0xF0, 0xA5, 0xA9, 0xA0 },
	0xAEF0, { 0xE4, 0x87, 0x98 },
	0xAEF1, { 0xE7, 0xAC, 0x8C },
	0xAEF2, { 0xE4, 0x87, 0x9D },
	0xAEF3, { 0xE4, 0x87, 0x9C },
	0xAEF4, { 0xF0, 0xA5, 0xAB, 0xB1 },
	0xAEF5, { 0xE4, 0x87, 0x97 },
	0xAEF6, { 0xF0, 0xA5, 0xAC, 0x87 },
	0xAEF7, { 0xE4, 0x87, 0x9A },
	0xAEF8, { 0xE4, 0x8A, 0xBA },
	0xAEF9, { 0xF0, 0xA5, 0xBE, 0x9B },
	0xAEFA, { 0xF0, 0xA5, 0xBE, 0xA3 },
	0xAEFB, { 0xF0, 0xA5, 0xBE, 0x9D },
	0xAEFC, { 0xE4, 0x8A, 0xBE },
	0xAEFD, { 0xE4, 0x8B, 0x82 },
	0xAEFE, { 0xE4, 0x8A, 0xBB },
	0xAFA1, { 0xE4, 0x8B, 0x80 },
	0xAFA2, { 0xF0, 0xA5, 0xBE, 0xA9 },
	0xAFA3, { 0xF0, 0xA5, 0xBE, 0xA7 },
	0xAFA4, { 0xF0, 0xA5, 0xBE, 0xA4 },
	0xAFA5, { 0xE7, 0xB4, 0xA3 },
	0xAFA6, { 0xF0, 0xA5, 0xBE, 0xBA },
	0xAFA7, { 0xF0, 0xA2, 0x87, 0x81 },
	0xAFA8, { 0xF0, 0xA6, 0x88, 0xA6 },
	0xAFA9, { 0xE4, 0x8D, 0x83 },
	0xAFAA, { 0xE4, 0x8D, 0x95 },
	0xAFAB, { 0xF0, 0xA6, 0x8A, 0x94 },
	0xAFAC, { 0xF0, 0xA6, 0x8A, 0x93 },
	0xAFAD, { 0xE4, 0x8D, 0x97 },
	0xAFAE, { 0xE4, 0x8D, 0xA8 },
	0xAFAF, { 0xE7, 0xBE, 0x98 },
	0xAFB0, { 0xE7, 0xBE, 0x90 },
	0xAFB1, { 0xF0, 0xA6, 0x90, 0x87 },
	0xAFB2, { 0xF0, 0xA6, 0x90, 0x8D },
	0xAFB3, { 0xF0, 0xA6, 0x90, 0x82 },
	0xAFB4, { 0xF0, 0xA6, 0x90, 0x8C },
	0xAFB5, { 0xF0, 0xA6, 0x90, 0x89 },
	0xAFB6, { 0xF0, 0xA6, 0x90, 0x88 },
	0xAFB7, { 0xF0, 0xA6, 0x90, 0x93 },
	0xAFB8, { 0xE4, 0x8E, 0xA1 },
	0xAFB9, { 0xF0, 0xA6, 0x93, 0x92 },
	0xAFBA, { 0xE8, 0x80, 0xBA },
	0xAFBB, { 0xF0, 0xA6, 0x94, 0xBE },
	0xAFBC, { 0xF0, 0xA6, 0x94, 0xBC },
	0xAFBD, { 0xF0, 0xA6, 0x99, 0xA7 },
	0xAFBE, { 0xF0, 0xA6, 0x9A, 0x9E },
	0xAFBF, { 0xE4, 0x8F, 0xAA },
	0xAFC0, { 0xF0, 0xA6, 0x9A, 0xAD },
	0xAFC1, { 0xE4, 0x8F, 0xA7 },
	0xAFC2, { 0xF0, 0xA6, 0x9B, 0x99 },
	0xAFC3, { 0xF0, 0xA6, 0x99, 0x82 },
	0xAFC4, { 0xF0, 0xA6, 0x9A, 0xA3 },
	0xAFC5, { 0xF0, 0xA6, 0x9A, 0xA0 },
	0xAFC6, { 0xE4, 0x8F, 0xA8 },
	0xAFC7, { 0xE4, 0x8F, 0xA9 },
	0xAFC8, { 0xF0, 0xA6, 0x99, 0xBC },
	0xAFC9, { 0xF0, 0xA6, 0xA4, 0x84 },
	0xAFCA, { 0xE4, 0x91, 0x94 },
	0xAFCB, { 0xF0, 0xA6, 0xA5, 0x98 },
	0xAFCC, { 0xF0, 0xA6, 0xA5, 0xA0 },
	0xAFCD, { 0xF0, 0xA6, 0xA7, 0x89 },
	0xAFCE, { 0xF0, 0xA6, 0xA7, 0x88 },
	0xAFCF, { 0xE8, 0x88, 0xA6 },
	0xAFD0, { 0xE4, 0x91, 0xA5 },
	0xAFD1, { 0xF0, 0xA6, 0xA8, 0x9C },
	0xAFD2, { 0xF0, 0xA6, 0xA8, 0x9A },
	0xAFD3, { 0xE4, 0x92, 0x8A },
	0xAFD4, { 0xF0, 0xA6, 0xAD, 0xB4 },
	0xAFD5, { 0xE4, 0x92, 0xB0 },
	0xAFD6, { 0xF0, 0xA6, 0xAD, 0xAE },
	0xAFD7, { 0xF0, 0xA6, 0xAD, 0xAF },
	0xAFD8, { 0xF0, 0xA6, 0xAD, 0xB9 },
	0xAFD9, { 0xE4, 0x92, 0xBC },
	0xAFDA, { 0xE8, 0x8C, 0xAE },
	0xAFDB, { 0xF0, 0xA6, 0xAD, 0xB7 },
	0xAFDC, { 0xE8, 0x8D, 0x95 },
	0xAFDD, { 0xE8, 0x8C, 0x9A },
	0xAFDE, { 0xE4, 0x92, 0xB8 },
	0xAFDF, { 0xE8, 0x8C, 0xBD },
	0xAFE0, { 0xF0, 0xA6, 0xAD, 0xBC },
	0xAFE1, { 0xE4, 0x92, 0xB2 },
	0xAFE2, { 0xF0, 0xA6, 0xAD, 0xB0 },
	0xAFE3, { 0xE8, 0x8C, 0xB0 },
	0xAFE4, { 0xE4, 0x92, 0xBD },
	0xAFE5, { 0xF0, 0xA6, 0xAD, 0xBA },
	0xAFE6, { 0xF0, 0xA6, 0xAE, 0x82 },
	0xAFE7, { 0xE4, 0x96, 0x8A },
	0xAFE8, { 0xE8, 0x99, 0x91 },
	0xAFE9, { 0xE4, 0x96, 0xA1 },
	0xAFEA, { 0xF0, 0xA7, 0x89, 0x84 },
	0xAFEB, { 0xE4, 0x96, 0xA2 },
	0xAFEC, { 0xF0, 0xA7, 0x89, 0x83 },
	0xAFED, { 0xE8, 0x9A, 0x88 },
	0xAFEE, { 0xF0, 0xA7, 0x89, 0x85 },
	0xAFEF, { 0xE4, 0x98, 0x95 },
	0xAFF0, { 0xF0, 0xA7, 0x98, 0xA5 },
	0xAFF1, { 0xF0, 0xA7, 0x98, 0x9F },
	0xAFF2, { 0xE4, 0x98, 0xA0 },
	0xAFF3, { 0xE4, 0x99, 0xB3 },
	0xAFF4, { 0xF0, 0xA7, 0x9F, 0xA8 },
	0xAFF5, { 0xE8, 0xA6, 0x8E },
	0xAFF6, { 0xE8, 0xA6, 0x8D },
	0xAFF7, { 0xF0, 0xA7, 0xA0, 0x89 },
	0xAFF8, { 0xF0, 0xA7, 0xA2, 0xB7 },
	0xAFF9, { 0xF0, 0xA7, 0xA2, 0xB9 },
	0xAFFA, { 0xF0, 0xA7, 0xA5, 0xA4 },
	0xAFFB, { 0xF0, 0xA7, 0xA5, 0xA3 },
	0xAFFC, { 0xE8, 0xA8, 0x89 },
	0xAFFD, { 0xE8, 0xA8, 0x94 },
	0xAFFE, { 0xE4, 0x9A, 0xB1 },
	0xB0A1, { 0xF0, 0xA7, 0xA5, 0xA2 },
	0xB0A2, { 0xF0, 0xA7, 0xA5, 0xA5 },
	0xB0A3, { 0xE4, 0x9C, 0xAB },
	0xB0A4, { 0xF0, 0xA7, 0xAE, 0xAC },
	0xB0A5, { 0xE4, 0x9D, 0x85 },
	0xB0A6, { 0xF0, 0xA7, 0xB4, 0xAA },
	0xB0A7, { 0xE4, 0x9E, 0x97 },
	0xB0A8, { 0xE4, 0x9E, 0x98 },
	0xB0A9, { 0xF0, 0xA7, 0xBA, 0x96 },
	0xB0AA, { 0xE4, 0x9F, 0x95 },
	0xB0AB, { 0xF0, 0xA7, 0xBF, 0x82 },
	0xB0AC, { 0xF0, 0xAF, 0xA7, 0x9E },
	0xB0AD, { 0xE4, 0xA2, 0x93 },
	0xB0AE, { 0xE4, 0xA2, 0x96 },
	0xB0AF, { 0xE9, 0x80, 0x87 },
	0xB0B0, { 0xE4, 0xA2, 0x94 },
	0xB0B1, { 0xF0, 0xA8, 0x92, 0xAA },
	0xB0B2, { 0xF0, 0xA8, 0x92, 0xB0 },
	0xB0B3, { 0xE4, 0xA3, 0x87 },
	0xB0B4, { 0xE4, 0xA3, 0x85 },
	0xB0B5, { 0xF0, 0xA8, 0x9B, 0x94 },
	0xB0B6, { 0xF0, 0xA8, 0x9B, 0x8D },
	0xB0B7, { 0xF0, 0xA8, 0x9B, 0x96 },
	0xB0B8, { 0xE4, 0xA3, 0x84 },
	0xB0B9, { 0xF0, 0xA8, 0x9F, 0xB0 },
	0xB0BA, { 0xE9, 0x95, 0xB9 },
	0xB0BB, { 0xE9, 0x96, 0x84 },
	0xB0BC, { 0xE4, 0xA7, 0x8E },
	0xB0BD, { 0xE4, 0xA7, 0x8A },
	0xB0BE, { 0xE4, 0xA7, 0x8C },
	0xB0BF, { 0xE9, 0x99, 0x97 },
	0xB0C0, { 0xE4, 0xA7, 0x89 },
	0xB0C1, { 0xE9, 0x9A, 0xBA },
	0xB0C3, { 0xF0, 0xA9, 0xB5, 0x8B },
	0xB0C4, { 0xF0, 0xA0, 0x85, 0xA2 },
	0xB0C5, { 0xE3, 0x91, 0xAE },
	0xB0C6, { 0xF0, 0xA0, 0x8A, 0xB7 },
	0xB0C7, { 0xE5, 0x81, 0xA7 },
	0xB0C8, { 0xF0, 0xA0, 0x8A, 0xAC },
	0xB0C9, { 0xF0, 0xA0, 0x8A, 0xAB },
	0xB0CA, { 0xE3, 0x91, 0xB1 },
	0xB0CB, { 0xF0, 0xA0, 0x8B, 0x81 },
	0xB0CC, { 0xE3, 0x92, 0xBB },
	0xB0CD, { 0xE3, 0x93, 0x93 },
	0xB0CE, { 0xF0, 0xA0, 0x97, 0xA8 },
	0xB0CF, { 0xF0, 0xA0, 0x9D, 0xA9 },
	0xB0D0, { 0xF0, 0xA0, 0x9D, 0x9D },
	0xB0D1, { 0xF0, 0xA0, 0x9D, 0x9F },
	0xB0D2, { 0xE3, 0x93, 0xB3 },
	0xB0D3, { 0xE3, 0x93, 0xAD },
	0xB0D4, { 0xE3, 0x93, 0xB5 },
	0xB0D5, { 0xF0, 0xA0, 0x9D, 0xA4 },
	0xB0D6, { 0xF0, 0xA0, 0x9D, 0xA2 },
	0xB0D7, { 0xE3, 0x93, 0xB1 },
	0xB0D8, { 0xE3, 0x93, 0xB2 },
	0xB0D9, { 0xE3, 0x93, 0xB6 },
	0xB0DA, { 0xE3, 0x94, 0xA0 },
	0xB0DB, { 0xF0, 0xA0, 0xA3, 0xB9 },
	0xB0DC, { 0xE3, 0x94, 0xA8 },
	0xB0DD, { 0xF0, 0xA0, 0xA3, 0xAE },
	0xB0DE, { 0xE5, 0x8C, 0x98 },
	0xB0DF, { 0xE5, 0x8C, 0xAC },
	0xB0E0, { 0xE5, 0x8D, 0x99 },
	0xB0E1, { 0xF0, 0xA0, 0xA6, 0xAB },
	0xB0E2, { 0xF0, 0xA0, 0xA6, 0xAC },
	0xB0E3, { 0xF0, 0xA0, 0xA6, 0xAA },
	0xB0E4, { 0xE5, 0x8D, 0xA8 },
	0xB0E5, { 0xE5, 0x8D, 0xBE },
	0xB0E6, { 0xF0, 0xA0, 0xAA, 0x86 },
	0xB0E7, { 0xF0, 0xA0, 0xA9, 0xBA },
	0xB0E8, { 0xE5, 0x8E, 0xA1 },
	0xB0E9, { 0xF0, 0xA0, 0xB4, 0xA8 },
	0xB0EA, { 0xE3, 0x96, 0xA1 },
	0xB0EB, { 0xE5, 0x95, 0x9B },
	0xB0EC, { 0xE3, 0x96, 0xAA },
	0xB0ED, { 0xE3, 0x96, 0xA9 },
	0xB0EE, { 0xF0, 0xA0, 0xB4, 0xB1 },
	0xB0EF, { 0xE3, 0x96, 0xB5 },
	0xB0F0, { 0xE3, 0x96, 0xA5 },
	0xB0F1, { 0xE3, 0x96, 0xA8 },
	0xB0F2, { 0xE5, 0x95, 0x82 },
	0xB0F3, { 0xE3, 0x96, 0xA7 },
	0xB0F4, { 0xE5, 0x95, 0x87 },
	0xB0F5, { 0xF0, 0xA0, 0xB4, 0xAD },
	0xB0F6, { 0xF0, 0xAF, 0xA1, 0x83 },
	0xB0F7, { 0xE5, 0x94, 0xBD },
	0xB0F8, { 0xF0, 0xA0, 0xB4, 0xAB },
	0xB0F9, { 0xF0, 0xA0, 0xB4, 0xB2 },
	0xB0FA, { 0xE5, 0x95, 0xA0 },
	0xB0FB, { 0xE5, 0x9F, 0xAB },
	0xB0FC, { 0xF0, 0xA1, 0x8C, 0xA9 },
	0xB0FD, { 0xF0, 0xA1, 0x8C, 0xA6 },
	0xB0FE, { 0xF0, 0xA1, 0x8D, 0x93 },
	0xB1A1, { 0xE3, 0x99, 0x8D },
	0xB1A2, { 0xF0, 0xA1, 0x8C, 0xB3 },
	0xB1A3, { 0xF0, 0xA1, 0x8C, 0xB4 },
	0xB1A4, { 0xF0, 0xA1, 0x96, 0x9D },
	0xB1A5, { 0xE3, 0x9A, 0x9C },
	0xB1A6, { 0xE5, 0xA5, 0x9F },
	0xB1A7, { 0xF0, 0xA1, 0x99, 0x81 },
	0xB1A8, { 0xE3, 0x9B, 0xAA },
	0xB1A9, { 0xE3, 0x9B, 0xA5 },
	0xB1AA, { 0xF0, 0xA1, 0x9E, 0x91 },
	0xB1AB, { 0xF0, 0xA1, 0x9D, 0xA9 },
	0xB1AC, { 0xE5, 0xAD, 0xAF },
	0xB1AD, { 0xF0, 0xA1, 0xA8, 0xA2 },
	0xB1AE, { 0xE3, 0x9D, 0x9E },
	0xB1AF, { 0xF0, 0xA1, 0xA8, 0xB4 },
	0xB1B0, { 0xF0, 0xAF, 0xA1, 0xAD },
	0xB1B1, { 0xF0, 0xA1, 0xAC, 0xAE },
	0xB1B2, { 0xE3, 0x9E, 0x86 },
	0xB1B3, { 0xE3, 0x9E, 0x84 },
	0xB1B4, { 0xF0, 0xA1, 0xAF, 0xB4 },
	0xB1B5, { 0xE5, 0xB1, 0x9A },
	0xB1B6, { 0xF0, 0xA1, 0xB8, 0xA8 },
	0xB1B7, { 0xE3, 0x9F, 0x99 },
	0xB1B8, { 0xF0, 0xA1, 0xB8, 0x9C },
	0xB1B9, { 0xE3, 0x9F, 0x9E },
	0xB1BA, { 0xF0, 0xA1, 0xB8, 0x91 },
	0xB1BB, { 0xF0, 0xA1, 0xB8, 0xA4 },
	0xB1BC, { 0xF0, 0xA1, 0xB8, 0x95 },
	0xB1BD, { 0xE3, 0x9F, 0x9B },
	0xB1BE, { 0xF0, 0xA1, 0xB8, 0x96 },
	0xB1BF, { 0xF0, 0xA1, 0xB9, 0x94 },
	0xB1C0, { 0xF0, 0xA1, 0xB8, 0xA3 },
	0xB1C1, { 0xF0, 0xA1, 0xBF, 0xBF },
	0xB1C2, { 0xE3, 0xA0, 0xB1 },
	0xB1C3, { 0xF0, 0xA2, 0x83, 0x8F },
	0xB1C4, { 0xF0, 0xA2, 0x83, 0x90 },
	0xB1C5, { 0xE3, 0xA1, 0x8B },
	0xB1C6, { 0xF0, 0xA2, 0x83, 0x8E },
	0xB1C7, { 0xE3, 0xA1, 0x89 },
	0xB1C8, { 0xE3, 0xA1, 0x8A },
	0xB1C9, { 0xE3, 0xA1, 0x8C },
	0xB1CA, { 0xF0, 0xA2, 0x87, 0x87 },
	0xB1CB, { 0xF0, 0xA2, 0x89, 0x9C },
	0xB1CC, { 0xE3, 0xA2, 0x8A },
	0xB1CD, { 0xF0, 0xA2, 0x88, 0xB6 },
	0xB1CE, { 0xE3, 0xA2, 0x89 },
	0xB1CF, { 0xE3, 0xA2, 0x8B },
	0xB1D0, { 0xF0, 0xA2, 0x89, 0x83 },
	0xB1D1, { 0xE3, 0xA2, 0xBB },
	0xB1D2, { 0xE5, 0xBE, 0xA2 },
	0xB1D3, { 0xE5, 0xBE, 0x9D },
	0xB1D4, { 0xE3, 0xA3, 0xA4 },
	0xB1D5, { 0xF0, 0xA2, 0x94, 0xAA },
	0xB1D6, { 0xF0, 0xA2, 0x94, 0x81 },
	0xB1D7, { 0xE5, 0xBE, 0xA3 },
	0xB1D8, { 0xF0, 0xA2, 0x94, 0x8B },
	0xB1D9, { 0xF0, 0xA2, 0x94, 0x8F },
	0xB1DA, { 0xE3, 0xA4, 0xBB },
	0xB1DB, { 0xE3, 0xA4, 0xAE },
	0xB1DC, { 0xE3, 0xA4, 0xBE },
	0xB1DD, { 0xE3, 0xA5, 0x86 },
	0xB1DE, { 0xE3, 0xA5, 0x93 },
	0xB1DF, { 0xF0, 0xA2, 0x9B, 0x9F },
	0xB1E0, { 0xE3, 0xA5, 0x84 },
	0xB1E1, { 0xF0, 0xA2, 0x9B, 0x92 },
	0xB1E2, { 0xE3, 0xA4, 0xBF },
	0xB1E3, { 0xE3, 0xA5, 0x82 },
	0xB1E4, { 0xE3, 0xA5, 0x8F },
	0xB1E5, { 0xF0, 0xA2, 0x9B, 0x8D },
	0xB1E6, { 0xE3, 0xA5, 0x92 },
	0xB1E7, { 0xE3, 0xA5, 0x8A },
	0xB1E8, { 0xE6, 0x83, 0x82 },
	0xB1E9, { 0xF0, 0xA2, 0x9B, 0x9B },
	0xB1EA, { 0xE3, 0xA5, 0x9A },
	0xB1EB, { 0xE6, 0x82, 0xA5 },
	0xB1EC, { 0xE3, 0xA5, 0x89 },
	0xB1ED, { 0xF0, 0xA2, 0x9B, 0x8F },
	0xB1EE, { 0xE6, 0x88, 0x9C },
	0xB1EF, { 0xF0, 0xA2, 0xA7, 0x80 },
	0xB1F0, { 0xE6, 0x88, 0x9D },
	0xB1F1, { 0xE3, 0xA8, 0x83 },
	0xB1F2, { 0xF0, 0xA2, 0xAE, 0x81 },
	0xB1F3, { 0xF0, 0xA2, 0xAE, 0x82 },
	0xB1F4, { 0xF0, 0xA2, 0xAE, 0x8A },
	0xB1F5, { 0xF0, 0xA2, 0xAE, 0xA8 },
	0xB1F6, { 0xF0, 0xA2, 0xAE, 0x8C },
	0xB1F7, { 0xE6, 0x8E, 0x95 },
	0xB1F8, { 0xE6, 0x8E, 0x9A },
	0xB1F9, { 0xE3, 0xA8, 0x81 },
	0xB1FA, { 0xE3, 0xA8, 0x86 },
	0xB1FB, { 0xE3, 0xA7, 0xBB },
	0xB1FC, { 0xE3, 0xA7, 0xB9 },
	0xB1FD, { 0xF0, 0xA2, 0xAE, 0x8E },
	0xB1FE, { 0xE3, 0xA8, 0x85 },
	0xB2A1, { 0xE3, 0xA7, 0xBA },
	0xB2A2, { 0xF0, 0xA2, 0xAE, 0x8B },
	0xB2A3, { 0xE6, 0x8E, 0xA6 },
	0xB2A4, { 0xF0, 0xA2, 0xAE, 0x96 },
	0xB2A5, { 0xE3, 0xA7, 0xBE },
	0xB2A6, { 0xF0, 0xA2, 0xAF, 0x8C },
	0xB2A7, { 0xE3, 0xA9, 0xBD },
	0xB2A8, { 0xE3, 0xAA, 0x8C },
	0xB2A9, { 0xF0, 0xA2, 0xBD, 0x8F },
	0xB2AA, { 0xF0, 0xA2, 0xBD, 0x8A },
	0xB2AB, { 0xE6, 0x95, 0x90 },
	0xB2AC, { 0xE3, 0xAA, 0x8E },
	0xB2AD, { 0xF0, 0xA2, 0xBD, 0x8B },
	0xB2AE, { 0xF0, 0xA2, 0xBC, 0xBD },
	0xB2AF, { 0xE6, 0x95, 0x92 },
	0xB2B0, { 0xF0, 0xA2, 0xBD, 0x84 },
	0xB2B1, { 0xF0, 0xA2, 0xBD, 0x89 },
	0xB2B2, { 0xF0, 0xA3, 0x82, 0x9E },
	0xB2B3, { 0xF0, 0xA3, 0x83, 0xB3 },
	0xB2B4, { 0xE6, 0x97, 0x88 },
	0xB2B5, { 0xF0, 0xA3, 0x83, 0xB5 },
	0xB2B6, { 0xE3, 0xAB, 0xB0 },
	0xB2B7, { 0xE3, 0xAB, 0xB2 },
	0xB2B8, { 0xF0, 0xA3, 0x86, 0xB3 },
	0xB2B9, { 0xE6, 0x99, 0x98 },
	0xB2BA, { 0xE3, 0xAB, 0xB1 },
	0xB2BB, { 0xE3, 0xAB, 0xA6 },
	0xB2BC, { 0xF0, 0xA3, 0x87, 0xA5 },
	0xB2BD, { 0xF0, 0xA3, 0x86, 0xB6 },
	0xB2BE, { 0xF0, 0xAF, 0xA3, 0x98 },
	0xB2BF, { 0xE6, 0xA2, 0x88 },
	0xB2C0, { 0xF0, 0xA3, 0x92, 0x86 },
	0xB2C1, { 0xE3, 0xAD, 0xAF },
	0xB2C2, { 0xE3, 0xAD, 0xAD },
	0xB2C3, { 0xE3, 0xAD, 0xA9 },
	0xB2C4, { 0xF0, 0xA3, 0x92, 0xB6 },
	0xB2C5, { 0xF0, 0xA3, 0x92, 0x85 },
	0xB2C6, { 0xE3, 0xAD, 0xAE },
	0xB2C7, { 0xF0, 0xA3, 0x92, 0xAB },
	0xB2C8, { 0xE3, 0xB0, 0xAF },
	0xB2C9, { 0xE3, 0xB0, 0xB0 },
	0xB2CA, { 0xE3, 0xB1, 0xA3 },
	0xB2CB, { 0xF0, 0xA3, 0xA8, 0x8D },
	0xB2CC, { 0xF0, 0xA3, 0xAA, 0x8B },
	0xB2CD, { 0xF0, 0xA3, 0xAA, 0x8C },
	0xB2CE, { 0xE6, 0xAE, 0xB8 },
	0xB2CF, { 0xE3, 0xB2, 0x80 },
	0xB2D0, { 0xE6, 0xAE, 0xB9 },
	0xB2D1, { 0xE3, 0xB2, 0x9A },
	0xB2D2, { 0xE3, 0xB2, 0x94 },
	0xB2D3, { 0xE3, 0xB2, 0x96 },
	0xB2D4, { 0xE3, 0xB2, 0x95 },
	0xB2D5, { 0xE3, 0xB2, 0x97 },
	0xB2D6, { 0xF0, 0xA3, 0xAD, 0xB2 },
	0xB2D7, { 0xE3, 0xB3, 0xB4 },
	0xB2D8, { 0xE3, 0xB3, 0xBE },
	0xB2D9, { 0xF0, 0xA3, 0xB6, 0x8F },
	0xB2DA, { 0xE3, 0xB4, 0x81 },
	0xB2DB, { 0xF0, 0xA3, 0xB5, 0xB9 },
	0xB2DC, { 0xE3, 0xB4, 0x82 },
	0xB2DD, { 0xF0, 0xA3, 0xB5, 0xB7 },
	0xB2DE, { 0xE3, 0xB3, 0xB9 },
	0xB2DF, { 0xF0, 0xA3, 0xB6, 0x90 },
	0xB2E0, { 0xF0, 0xA3, 0xB6, 0x88 },
	0xB2E1, { 0xF0, 0xA3, 0xB6, 0x80 },
	0xB2E2, { 0xF0, 0xA3, 0xB6, 0x9E },
	0xB2E3, { 0xE3, 0xB3, 0xB6 },
	0xB2E4, { 0xE3, 0xB3, 0xB7 },
	0xB2E5, { 0xF0, 0xA3, 0xB6, 0x82 },
	0xB2E6, { 0xF0, 0xA3, 0xB4, 0xB4 },
	0xB2E7, { 0xF0, 0xA3, 0xB6, 0x89 },
	0xB2E8, { 0xE3, 0xB3, 0xBF },
	0xB2E9, { 0xF0, 0xA3, 0xB6, 0x85 },
	0xB2EA, { 0xF0, 0xA3, 0xB5, 0xBE },
	0xB2EB, { 0xF0, 0xA3, 0xB5, 0xBA },
	0xB2EC, { 0xF0, 0xA3, 0xB6, 0xA6 },
	0xB2ED, { 0xE6, 0xB8, 0x8B },
	0xB2EE, { 0xF0, 0xA3, 0xB6, 0xB5 },
	0xB2EF, { 0xF0, 0xA4, 0x87, 0xB4 },
	0xB2F0, { 0xE3, 0xB6, 0xBF },
	0xB2F1, { 0xE3, 0xB6, 0xBC },
	0xB2F2, { 0xE7, 0x84, 0x85 },
	0xB2F3, { 0xF0, 0xA4, 0x88, 0xA9 },
	0xB2F4, { 0xF0, 0xA4, 0x88, 0xA6 },
	0xB2F5, { 0xF0, 0xA4, 0x88, 0xAA },
	0xB2F6, { 0xE3, 0xB6, 0xBE },
	0xB2F7, { 0xE3, 0xB7, 0x80 },
	0xB2F8, { 0xF0, 0xA4, 0x95, 0xBE },
	0xB2F9, { 0xE3, 0xB8, 0xBB },
	0xB2FA, { 0xE3, 0xB8, 0xB9 },
	0xB2FB, { 0xF0, 0xA4, 0x99, 0x9B },
	0xB2FC, { 0xF0, 0xA4, 0x99, 0xA1 },
	0xB2FD, { 0xF0, 0xA4, 0x99, 0xA0 },
	0xB2FE, { 0xE3, 0xB8, 0xBC },
	0xB3A1, { 0xF0, 0xA4, 0x9E, 0x9B },
	0xB3A2, { 0xE7, 0x8C, 0x94 },
	0xB3A3, { 0xE7, 0x8C, 0x84 },
	0xB3A4, { 0xF0, 0xA4, 0x9F, 0x83 },
	0xB3A5, { 0xE3, 0xB9, 0xBD },
	0xB3A6, { 0xF0, 0xA4, 0x9F, 0x8D },
	0xB3A7, { 0xE3, 0xB9, 0xBF },
	0xB3A8, { 0xE3, 0xB9, 0xBA },
	0xB3A9, { 0xE3, 0xB9, 0xBC },
	0xB3AA, { 0xE7, 0x8C, 0x85 },
	0xB3AB, { 0xE3, 0xB9, 0xBE },
	0xB3AC, { 0xE7, 0x8C, 0x95 },
	0xB3AD, { 0xE7, 0x8C, 0x8D },
	0xB3AE, { 0xE3, 0xBA, 0x80 },
	0xB3AF, { 0xE3, 0xBA, 0xBF },
	0xB3B0, { 0xE3, 0xBB, 0x83 },
	0xB3B1, { 0xF0, 0xA4, 0xA5, 0x94 },
	0xB3B2, { 0xF0, 0xA4, 0xA5, 0x99 },
	0xB3B3, { 0xE3, 0xBB, 0x8C },
	0xB3B4, { 0xE3, 0xBC, 0x8E },
	0xB3B5, { 0xE3, 0xBC, 0x8D },
	0xB3B6, { 0xF0, 0xA4, 0xAB, 0xB5 },
	0xB3B7, { 0xE3, 0xBC, 0xA6 },
	0xB3B8, { 0xE3, 0xBC, 0xA4 },
	0xB3B9, { 0xE3, 0xBC, 0xA5 },
	0xB3BA, { 0xE3, 0xBC, 0xA3 },
	0xB3BB, { 0xE3, 0xBC, 0xA1 },
	0xB3BC, { 0xE3, 0xBC, 0xA9 },
	0xB3BD, { 0xF0, 0xA4, 0xB1, 0xA9 },
	0xB3BE, { 0xF0, 0xA4, 0xB1, 0xA5 },
	0xB3BF, { 0xE3, 0xBE, 0x8F },
	0xB3C0, { 0xE3, 0xBE, 0x8D },
	0xB3C1, { 0xF0, 0xA4, 0xB5, 0xBC },
	0xB3C2, { 0xE3, 0xBE, 0x8B },
	0xB3C3, { 0xE3, 0xBE, 0x92 },
	0xB3C4, { 0xF0, 0xA4, 0xB6, 0x80 },
	0xB3C5, { 0xE3, 0xBE, 0x90 },
	0xB3C6, { 0xF0, 0xA4, 0xBD, 0xA5 },
	0xB3C7, { 0xE3, 0xBF, 0xAF },
	0xB3C8, { 0xE3, 0xBF, 0xB0 },
	0xB3C9, { 0xF0, 0xA4, 0xBF, 0x9F },
	0xB3CA, { 0xF0, 0xA5, 0x81, 0xA0 },
	0xB3CB, { 0xE4, 0x80, 0x81 },
	0xB3CC, { 0xF0, 0xA5, 0x81, 0x9E },
	0xB3CD, { 0xE4, 0x80, 0xAE },
	0xB3CE, { 0xE4, 0x80, 0xAD },
	0xB3CF, { 0xE7, 0x9C, 0xAE },
	0xB3D0, { 0xE4, 0x80, 0xA8 },
	0xB3D1, { 0xE4, 0x80, 0xA9 },
	0xB3D2, { 0xE4, 0x80, 0xAC },
	0xB3D3, { 0xF0, 0xA5, 0x86, 0x8F },
	0xB3D4, { 0xF0, 0xA5, 0x85, 0xA1 },
	0xB3D5, { 0xF0, 0xA5, 0x85, 0x9A },
	0xB3D6, { 0xE7, 0x9D, 0x81 },
	0xB3D7, { 0xE4, 0x82, 0x88 },
	0xB3D8, { 0xF0, 0xA5, 0x8D, 0xA7 },
	0xB3D9, { 0xE4, 0x82, 0x92 },
	0xB3DA, { 0xE4, 0x82, 0x91 },
	0xB3DB, { 0xE7, 0x9F, 0xAA },
	0xB3DC, { 0xF0, 0xA5, 0x8E, 0xBB },
	0xB3DD, { 0xE7, 0xA1, 0x84 },
	0xB3DE, { 0xE4, 0x82, 0xA9 },
	0xB3DF, { 0xE4, 0x82, 0xAC },
	0xB3E0, { 0xE4, 0x82, 0xAE },
	0xB3E1, { 0xE4, 0x82, 0xAA },
	0xB3E2, { 0xE4, 0x84, 0x86 },
	0xB3E3, { 0xE4, 0x84, 0x85 },
	0xB3E4, { 0xE4, 0x85, 0x8A },
	0xB3E5, { 0xE4, 0x84, 0xBE },
	0xB3E6, { 0xE4, 0x84, 0xBC },
	0xB3E7, { 0xE4, 0x84, 0xBB },
	0xB3E8, { 0xF0, 0xA5, 0x9E, 0x9B },
	0xB3E9, { 0xE4, 0x85, 0x82 },
	0xB3EA, { 0xE4, 0x85, 0x81 },
	0xB3EB, { 0xE4, 0x85, 0x83 },
	0xB3EC, { 0xF0, 0xA5, 0x9E, 0xA9 },
	0xB3ED, { 0xE4, 0x85, 0x85 },
	0xB3EE, { 0xF0, 0xA5, 0xA5, 0xA6 },
	0xB3EF, { 0xE4, 0x86, 0x9A },
	0xB3F0, { 0xE4, 0x86, 0x9B },
	0xB3F1, { 0xE4, 0x86, 0x9F },
	0xB3F2, { 0xE4, 0x86, 0x9E },
	0xB3F3, { 0xF0, 0xA5, 0xA9, 0xB2 },
	0xB3F4, { 0xF0, 0xA5, 0xA9, 0xB6 },
	0xB3F5, { 0xF0, 0xA5, 0xAC, 0x94 },
	0xB3F6, { 0xE4, 0x87, 0x9E },
	0xB3F7, { 0xE4, 0x87, 0xA2 },
	0xB3F8, { 0xE4, 0x87, 0xA6 },
	0xB3F9, { 0xF0, 0xA5, 0xAC, 0x8F },
	0xB3FA, { 0xE7, 0xAC, 0xA9 },
	0xB3FB, { 0xE4, 0x87, 0xA3 },
	0xB3FC, { 0xE7, 0xAC, 0xA7 },
	0xB3FD, { 0xE4, 0x87, 0x9F },
	0xB3FE, { 0xF0, 0xA5, 0xB9, 0x81 },
	0xB4A1, { 0xF0, 0xA5, 0xB9, 0x86 },
	0xB4A2, { 0xE7, 0xB2, 0x9D },
	0xB4A3, { 0xF0, 0xA5, 0xB9, 0x8B },
	0xB4A4, { 0xF0, 0xA5, 0xB9, 0x83 },
	0xB4A5, { 0xE4, 0x89, 0xBE },
	0xB4A6, { 0xE4, 0x8B, 0x89 },
	0xB4A7, { 0xE4, 0x8B, 0x8C },
	0xB4A8, { 0xF0, 0xA5, 0xBF, 0x86 },
	0xB4A9, { 0xE4, 0x8B, 0x91 },
	0xB4AA, { 0xF0, 0xA5, 0xBF, 0x87 },
	0xB4AB, { 0xE4, 0x8B, 0x90 },
	0xB4AC, { 0xF0, 0xA5, 0xBF, 0x8E },
	0xB4AD, { 0xE4, 0x8B, 0x8F },
	0xB4AE, { 0xE4, 0x8B, 0x88 },
	0xB4AF, { 0xF0, 0xA5, 0xBF, 0x89 },
	0xB4B0, { 0xE4, 0x8B, 0x8D },
	0xB4B1, { 0xF0, 0xA5, 0xBF, 0x8B },
	0xB4B2, { 0xF0, 0xA5, 0xBF, 0x85 },
	0xB4B3, { 0xE4, 0x8D, 0x89 },
	0xB4B4, { 0xE4, 0x8D, 0x87 },
	0xB4B5, { 0xE4, 0x8D, 0x98 },
	0xB4B6, { 0xE4, 0x8D, 0xAB },
	0xB4B7, { 0xE4, 0x8D, 0xAC },
	0xB4B8, { 0xE4, 0x8D, 0xAA },
	0xB4B9, { 0xF0, 0xA6, 0x8D, 0xA9 },
	0xB4BA, { 0xE4, 0x8E, 0x80 },
	0xB4BB, { 0xE4, 0x8E, 0x82 },
	0xB4BC, { 0xE4, 0x8E, 0x84 },
	0xB4BD, { 0xE7, 0xBF, 0x88 },
	0xB4BE, { 0xE4, 0x8E, 0x83 },
	0xB4BF, { 0xF0, 0xA6, 0x90, 0x9E },
	0xB4C0, { 0xF0, 0xA6, 0x92, 0xBA },
	0xB4C1, { 0xE4, 0x8E, 0xB6 },
	0xB4C2, { 0xF0, 0xA6, 0x95, 0x92 },
	0xB4C3, { 0xF0, 0xA6, 0x95, 0x91 },
	0xB4C4, { 0xF0, 0xA6, 0x95, 0x93 },
	0xB4C5, { 0xF0, 0xA6, 0x9A, 0x9F },
	0xB4C6, { 0xF0, 0xA6, 0x9B, 0x9B },
	0xB4C7, { 0xE8, 0x84, 0xA6 },
	0xB4C8, { 0xE4, 0x8F, 0xB1 },
	0xB4C9, { 0xF0, 0xA6, 0x9B, 0xA3 },
	0xB4CA, { 0xE4, 0x8F, 0xB6 },
	0xB4CB, { 0xE4, 0x8F, 0xB3 },
	0xB4CC, { 0xE4, 0x8F, 0xB0 },
	0xB4CD, { 0xE8, 0x84, 0x9C },
	0xB4CE, { 0xF0, 0xA6, 0x9B, 0x97 },
	0xB4CF, { 0xF0, 0xA6, 0x9B, 0xA9 },
	0xB4D0, { 0xE8, 0x84, 0xA8 },
	0xB4D1, { 0xE4, 0x8F, 0xB5 },
	0xB4D2, { 0xE4, 0x8F, 0xB4 },
	0xB4D3, { 0xE4, 0x8F, 0xB7 },
	0xB4D4, { 0xF0, 0xA6, 0x9B, 0x9E },
	0xB4D5, { 0xF0, 0xA6, 0x9B, 0x9C },
	0xB4D6, { 0xF0, 0xA6, 0xA4, 0xBC },
	0xB4D7, { 0xF0, 0xAF, 0xA6, 0x8B },
	0xB4D8, { 0xE4, 0x91, 0x95 },
	0xB4D9, { 0xF0, 0xA6, 0xA8, 0xA2 },
	0xB4DA, { 0xF0, 0xA6, 0xA8, 0xB2 },
	0xB4DB, { 0xF0, 0xA6, 0xA8, 0xA3 },
	0xB4DC, { 0xE4, 0x92, 0x8B },
	0xB4DD, { 0xE4, 0x93, 0x8B },
	0xB4DE, { 0xE4, 0x93, 0x82 },
	0xB4DF, { 0xF0, 0xA6, 0xAF, 0x94 },
	0xB4E0, { 0xF0, 0xA6, 0xAF, 0x88 },
	0xB4E1, { 0xF0, 0xA6, 0xAE, 0xBC },
	0xB4E2, { 0xE4, 0x93, 0x8A },
	0xB4E3, { 0xE4, 0x93, 0x8C },
	0xB4E4, { 0xF0, 0xA6, 0xAF, 0x8D },
	0xB4E5, { 0xE4, 0x93, 0x87 },
	0xB4E6, { 0xE4, 0x93, 0x89 },
	0xB4E7, { 0xE8, 0x8D, 0xB0 },
	0xB4E8, { 0xF0, 0xA6, 0xAE, 0xBE },
	0xB4E9, { 0xE4, 0x93, 0x86 },
	0xB4EA, { 0xF0, 0xA6, 0xB1, 0x80 },
	0xB4EB, { 0xF0, 0xA6, 0xAF, 0x96 },
	0xB4EC, { 0xE4, 0x93, 0x83 },
	0xB4ED, { 0xE8, 0x8E, 0x82 },
	0xB4EE, { 0xF0, 0xA6, 0xAE, 0xBD },
	0xB4EF, { 0xE8, 0x8E, 0xAC },
	0xB4F0, { 0xF0, 0xA6, 0xAE, 0xBA },
	0xB4F1, { 0xE4, 0x93, 0x84 },
	0xB4F2, { 0xF0, 0xA6, 0xAF, 0x80 },
	0xB4F3, { 0xF0, 0xAF, 0xA6, 0x9B },
	0xB4F4, { 0xF0, 0xAF, 0xA6, 0x9D },
	0xB4F5, { 0xF0, 0xA6, 0xAF, 0x81 },
	0xB4F6, { 0xF0, 0xA7, 0x86, 0xA6 },
	0xB4F7, { 0xF0, 0xA7, 0x86, 0xA5 },
	0xB4F8, { 0xF0, 0xA7, 0x86, 0xA8 },
	0xB4F9, { 0xE4, 0x96, 0xA9 },
	0xB4FA, { 0xE8, 0x9A, 0xAD },
	0xB4FB, { 0xE4, 0x96, 0xA8 },
	0xB4FC, { 0xE4, 0x96, 0xA6 },
	0xB4FD, { 0xF0, 0xA7, 0x89, 0x9F },
	0xB4FE, { 0xF0, 0xA7, 0x89, 0xB0 },
	0xB5A1, { 0xF0, 0xA7, 0x89, 0xAA },
	0xB5A2, { 0xF0, 0xA7, 0x89, 0xA5 },
	0xB5A3, { 0xF0, 0xA7, 0x89, 0xA7 },
	0xB5A4, { 0xF0, 0xA7, 0x89, 0xAF },
	0xB5A5, { 0xF0, 0xA7, 0x8A, 0x87 },
	0xB5A6, { 0xE8, 0x9B, 0x8A },
	0xB5A7, { 0xE8, 0xA1, 0x91 },
	0xB5A8, { 0xF0, 0xA7, 0x98, 0xBD },
	0xB5A9, { 0xF0, 0xA7, 0x99, 0x83 },
	0xB5AA, { 0xE4, 0x98, 0xA2 },
	0xB5AB, { 0xF0, 0xA7, 0x99, 0x80 },
	0xB5AC, { 0xE4, 0x98, 0xA6 },
	0xB5AD, { 0xE4, 0x98, 0xA4 },
	0xB5AE, { 0xE4, 0x98, 0xA5 },
	0xB5AF, { 0xE8, 0xA2, 0x9D },
	0xB5B0, { 0xE4, 0x98, 0xAA },
	0xB5B1, { 0xE4, 0x99, 0xB4 },
	0xB5B2, { 0xF0, 0xA7, 0xA0, 0x98 },
	0xB5B3, { 0xE4, 0x99, 0xB9 },
	0xB5B4, { 0xE8, 0xA6, 0x90 },
	0xB5B5, { 0xE4, 0x99, 0xBA },
	0xB5B6, { 0xF0, 0xA7, 0xA0, 0x99 },
	0xB5B7, { 0xF0, 0xA7, 0xA3, 0x81 },
	0xB5B8, { 0xE8, 0xA7, 0x98 },
	0xB5B9, { 0xE8, 0xA7, 0x97 },
	0xB5BA, { 0xE4, 0x9A, 0x97 },
	0xB5BB, { 0xF0, 0xA7, 0xA2, 0xBC },
	0xB5BC, { 0xF0, 0xA7, 0xA3, 0x88 },
	0xB5BD, { 0xE8, 0xA8, 0xAE },
	0xB5BE, { 0xF0, 0xA7, 0xA5, 0xB1 },
	0xB5BF, { 0xE4, 0x9A, 0xBC },
	0xB5C0, { 0xF0, 0xA7, 0xA5, 0xAE },
	0xB5C1, { 0xE4, 0x9A, 0xB3 },
	0xB5C2, { 0xF0, 0xA7, 0xA5, 0xB8 },
	0xB5C3, { 0xE4, 0x9A, 0xBF },
	0xB5C4, { 0xE4, 0x9A, 0xB7 },
	0xB5C5, { 0xF0, 0xAF, 0xA7, 0x8D },
	0xB5C6, { 0xF0, 0xA7, 0xA5, 0xBA },
	0xB5C7, { 0xF0, 0xA7, 0xAE, 0xB1 },
	0xB5C8, { 0xF0, 0xA7, 0xAE, 0xAF },
	0xB5C9, { 0xF0, 0xA7, 0xAE, 0xB0 },
	0xB5CA, { 0xE4, 0x9C, 0xB4 },
	0xB5CB, { 0xE4, 0x9D, 0x86 },
	0xB5CC, { 0xE4, 0x9D, 0x88 },
	0xB5CD, { 0xE8, 0xB1, 0x99 },
	0xB5CE, { 0xF0, 0xA7, 0xB2, 0xA8 },
	0xB5CF, { 0xF0, 0xA7, 0xB2, 0xA6 },
	0xB5D0, { 0xE4, 0x9D, 0x96 },
	0xB5D1, { 0xE4, 0x9D, 0xA7 },
	0xB5D2, { 0xF0, 0xA7, 0xB5, 0x88 },
	0xB5D3, { 0xF0, 0xA7, 0xB5, 0x85 },
	0xB5D4, { 0xE4, 0x9D, 0xA8 },
	0xB5D5, { 0xE4, 0x9E, 0x99 },
	0xB5D6, { 0xE4, 0x9E, 0x9A },
	0xB5D7, { 0xF0, 0xA7, 0xBA, 0xA0 },
	0xB5D8, { 0xF0, 0xA7, 0xBA, 0xA4 },
	0xB5D9, { 0xE4, 0x9F, 0x98 },
	0xB5DA, { 0xF0, 0xA7, 0xBF, 0x94 },
	0xB5DB, { 0xE4, 0x9F, 0x9B },
	0xB5DC, { 0xE4, 0x9F, 0x9C },
	0xB5DD, { 0xE4, 0x9F, 0x9D },
	0xB5DE, { 0xE4, 0x9F, 0x97 },
	0xB5DF, { 0xF0, 0xA7, 0xBF, 0x92 },
	0xB5E0, { 0xF0, 0xA8, 0x88, 0xA2 },
	0xB5E1, { 0xE4, 0xA1, 0x89 },
	0xB5E2, { 0xE4, 0xA1, 0x8A },
	0xB5E3, { 0xE8, 0xBB, 0x9A },
	0xB5E4, { 0xF0, 0xA8, 0x8A, 0xB7 },
	0xB5E5, { 0xF0, 0xA8, 0x8B, 0x8C },
	0xB5E6, { 0xE9, 0x80, 0xB3 },
	0xB5E7, { 0xF0, 0xA8, 0x93, 0xA6 },
	0xB5E8, { 0xE9, 0x80, 0x98 },
	0xB5E9, { 0xE4, 0xA2, 0x9A },
	0xB5EA, { 0xF0, 0xA8, 0x93, 0x88 },
	0xB5EB, { 0xE4, 0xA3, 0x8D },
	0xB5EC, { 0xE4, 0xA3, 0x8A },
	0xB5ED, { 0xF0, 0xA8, 0x9B, 0xB4 },
	0xB5EE, { 0xE4, 0xA3, 0x8B },
	0xB5EF, { 0xF0, 0xA8, 0x9B, 0xAD },
	0xB5F0, { 0xE4, 0xA3, 0x8F },
	0xB5F1, { 0xF0, 0xA8, 0x99, 0xBE },
	0xB5F2, { 0xF0, 0xAF, 0xA7, 0xA3 },
	0xB5F3, { 0xE4, 0xA3, 0x8C },
	0xB5F4, { 0xE4, 0xA3, 0xAA },
	0xB5F5, { 0xE4, 0xA3, 0xAD },
	0xB5F6, { 0xF0, 0xA8, 0x9F, 0xB9 },
	0xB5F7, { 0xF0, 0xA8, 0x9F, 0xBD },
	0xB5F8, { 0xE4, 0xA3, 0xA9 },
	0xB5F9, { 0xF0, 0xA8, 0xA0, 0x87 },
	0xB5FA, { 0xE4, 0xA4, 0x9A },
	0xB5FB, { 0xE9, 0x87, 0xAF },
	0xB5FC, { 0xE4, 0xA6, 0x8D },
	0xB5FD, { 0xE4, 0xA7, 0x92 },
	0xB5FE, { 0xF0, 0xA8, 0xB9, 0xB8 },
	0xB6A1, { 0xF0, 0xA8, 0xB9, 0xBA },
	0xB6A2, { 0xF0, 0xA8, 0xB9, 0xB9 },
	0xB6A3, { 0xF0, 0xA8, 0xBE, 0x8A },
	0xB6A4, { 0xE4, 0xA7, 0xB2 },
	0xB6A5, { 0xF0, 0xA9, 0x81, 0xBB },
	0xB6A6, { 0xF0, 0xA9, 0x87, 0x95 },
	0xB6A7, { 0xF0, 0xA9, 0x87, 0xA9 },
	0xB6A8, { 0xE4, 0xA8, 0xBD },
	0xB6A9, { 0xF0, 0xA9, 0x87, 0xAB },
	0xB6AA, { 0xE4, 0xA8, 0xBE },
	0xB6AB, { 0xE4, 0xAB, 0xB8 },
	0xB6AC, { 0xE4, 0xAC, 0xA3 },
	0xB6AD, { 0xE9, 0xAB, 0x99 },
	0xB6AE, { 0xE4, 0xBA, 0xB4 },
	0xB6AF, { 0xF0, 0xA0, 0x85, 0xAC },
	0xB6B0, { 0xE5, 0x82, 0xA0 },
	0xB6B1, { 0xE5, 0x82, 0x90 },
	0xB6B2, { 0xE3, 0x91, 0xB5 },
	0xB6B3, { 0xE5, 0x82, 0x86 },
	0xB6B4, { 0xE5, 0x82, 0x84 },
	0xB6B5, { 0xF0, 0xA0, 0x8B, 0xBA },
	0xB6B6, { 0xE5, 0x82, 0x8A },
	0xB6B7, { 0xE3, 0x91, 0xB6 },
	0xB6B8, { 0xE3, 0x91, 0xB3 },
	0xB6B9, { 0xE5, 0x82, 0x9F },
	0xB6BA, { 0xE5, 0x82, 0xA1 },
	0xB6BB, { 0xF0, 0xA0, 0x8C, 0x98 },
	0xB6BC, { 0xE5, 0x82, 0x93 },
	0xB6BD, { 0xE3, 0x92, 0xBD },
	0xB6BE, { 0xF0, 0xA0, 0x97, 0xB6 },
	0xB6BF, { 0xE5, 0x87, 0x95 },
	0xB6C0, { 0xF0, 0xA0, 0x9E, 0x8A },
	0xB6C1, { 0xF0, 0xA0, 0x9E, 0x89 },
	0xB6C2, { 0xE3, 0x93, 0xB9 },
	0xB6C3, { 0xF0, 0xA0, 0x9D, 0xBF },
	0xB6C4, { 0xF0, 0xA0, 0x9E, 0x88 },
	0xB6C5, { 0xE3, 0x93, 0xBA },
	0xB6C6, { 0xF0, 0xA0, 0x9E, 0x83 },
	0xB6C7, { 0xF0, 0xA0, 0x9E, 0x84 },
	0xB6C8, { 0xF0, 0xA0, 0x9E, 0x98 },
	0xB6C9, { 0xF0, 0xA0, 0x9D, 0xA3 },
	0xB6CA, { 0xF0, 0xA0, 0x9E, 0x87 },
	0xB6CB, { 0xE3, 0x94, 0xA1 },
	0xB6CC, { 0xF0, 0xAF, 0xA0, 0xA7 },
	0xB6CD, { 0xE3, 0x94, 0xA9 },
	0xB6CE, { 0xF0, 0xA0, 0xA3, 0xB5 },
	0xB6CF, { 0xF0, 0xA0, 0xA5, 0x90 },
	0xB6D0, { 0xE3, 0x94, 0xB8 },
	0xB6D1, { 0xE3, 0x95, 0x8E },
	0xB6D2, { 0xF0, 0xA0, 0xAA, 0x87 },
	0xB6D3, { 0xF0, 0xA0, 0xAA, 0x8A },
	0xB6D4, { 0xF0, 0xA0, 0xAD, 0xA5 },
	0xB6D5, { 0xF0, 0xA0, 0xB6, 0xB7 },
	0xB6D6, { 0xF0, 0xA0, 0xB7, 0x81 },
	0xB6D7, { 0xF0, 0xA0, 0xB7, 0x87 },
	0xB6D8, { 0xE3, 0x97, 0x88 },
	0xB6D9, { 0xE3, 0x96, 0xBC },
	0xB6DA, { 0xF0, 0xA0, 0xB7, 0x85 },
	0xB6DB, { 0xF0, 0xA0, 0xB7, 0x8B },
	0xB6DC, { 0xE5, 0x96, 0x90 },
	0xB6DD, { 0xF0, 0xA0, 0xB7, 0x91 },
	0xB6DE, { 0xE3, 0x96, 0xBB },
	0xB6DF, { 0xE3, 0x97, 0x82 },
	0xB6E0, { 0xE3, 0x97, 0x80 },
	0xB6E1, { 0xF0, 0xA0, 0xB6, 0xB8 },
	0xB6E2, { 0xF0, 0xA0, 0xB7, 0x8A },
	0xB6E3, { 0xE3, 0x97, 0x8A },
	0xB6E4, { 0xF0, 0xA0, 0xB7, 0x9E },
	0xB6E5, { 0xE3, 0x97, 0x89 },
	0xB6E6, { 0xF0, 0xA0, 0xB7, 0x8E },
	0xB6E7, { 0xE3, 0x96, 0xB8 },
	0xB6E8, { 0xE5, 0x9C, 0x90 },
	0xB6E9, { 0xE5, 0xA0, 0x97 },
	0xB6EA, { 0xF0, 0xA1, 0x8D, 0xA8 },
	0xB6EB, { 0xE3, 0x99, 0x8E },
	0xB6EC, { 0xF0, 0xA1, 0x8D, 0xAB },
	0xB6ED, { 0xE5, 0xA1, 0x84 },
	0xB6EE, { 0xE3, 0x99, 0x90 },
	0xB6EF, { 0xE5, 0xA0, 0xAB },
	0xB6F0, { 0xF0, 0xA1, 0x8D, 0xAA },
	0xB6F1, { 0xE5, 0xA1, 0x85 },
	0xB6F2, { 0xF0, 0xA1, 0x8D, 0xA6 },
	0xB6F3, { 0xF0, 0xA1, 0x8D, 0xB7 },
	0xB6F4, { 0xF0, 0xA1, 0x8E, 0x96 },
	0xB6F5, { 0xF0, 0xA1, 0x8D, 0xAE },
	0xB6F6, { 0xF0, 0xAF, 0xA1, 0x96 },
	0xB6F7, { 0xE3, 0x9A, 0x8A },
	0xB6F8, { 0xF0, 0xA1, 0x99, 0x97 },
	0xB6F9, { 0xE5, 0xA5, 0xA5 },
	0xB6FA, { 0xF0, 0xA1, 0x99, 0x96 },
	0xB6FB, { 0xF0, 0xA1, 0x9E, 0x9C },
	0xB6FC, { 0xF0, 0xA1, 0x9E, 0x9E },
	0xB6FD, { 0xE3, 0x9B, 0xBC },
	0xB6FE, { 0xE3, 0x9B, 0xB9 },
	0xB7A1, { 0xF0, 0xA1, 0x9E, 0xA1 },
	0xB7A2, { 0xE3, 0x9D, 0xA3 },
	0xB7A3, { 0xF0, 0xA1, 0xA9, 0x82 },
	0xB7A4, { 0xE5, 0xAF, 0x8F },
	0xB7A5, { 0xF0, 0xA1, 0xA9, 0x86 },
	0xB7A6, { 0xF0, 0xA1, 0xA8, 0xBE },
	0xB7A7, { 0xF0, 0xA1, 0xAC, 0xB3 },
	0xB7A8, { 0xE3, 0x9E, 0x87 },
	0xB7A9, { 0xE3, 0x9E, 0x88 },
	0xB7AA, { 0xF0, 0xA1, 0xAF, 0xBA },
	0xB7AB, { 0xE3, 0x9E, 0x9A },
	0xB7AC, { 0xF0, 0xA1, 0xB2, 0x97 },
	0xB7AD, { 0xF0, 0xA1, 0xB2, 0x9B },
	0xB7AE, { 0xF0, 0xA1, 0xB2, 0xAA },
	0xB7AF, { 0xE5, 0xB5, 0x96 },
	0xB7B0, { 0xF0, 0xA1, 0xB9, 0xB3 },
	0xB7B1, { 0xF0, 0xA1, 0xB9, 0xBC },
	0xB7B2, { 0xE3, 0x9F, 0xA9 },
	0xB7B3, { 0xF0, 0xA1, 0xBA, 0x86 },
	0xB7B4, { 0xE3, 0x9F, 0xAA },
	0xB7B5, { 0xE5, 0xB5, 0x94 },
	0xB7B6, { 0xE3, 0xA1, 0x90 },
	0xB7B7, { 0xF0, 0xA2, 0x83, 0xB3 },
	0xB7B8, { 0xF0, 0xA2, 0x83, 0xB0 },
	0xB7B9, { 0xE3, 0xA1, 0x96 },
	0xB7BA, { 0xE3, 0xA1, 0x92 },
	0xB7BB, { 0xE3, 0xA1, 0x8F },
	0xB7BC, { 0xE3, 0xA1, 0x94 },
	0xB7BD, { 0xE3, 0xA1, 0x91 },
	0xB7BE, { 0xF0, 0xA2, 0x83, 0xAC },
	0xB7BF, { 0xF0, 0xA2, 0x8A, 0xAF },
	0xB7C0, { 0xE3, 0xA2, 0x8E },
	0xB7C1, { 0xE3, 0xA2, 0x8F },
	0xB7C2, { 0xF0, 0xA2, 0x89, 0xA4 },
	0xB7C3, { 0xF0, 0xA2, 0x89, 0xA8 },
	0xB7C4, { 0xF0, 0xA2, 0x8D, 0x9A },
	0xB7C5, { 0xE5, 0xBC, 0xBD },
	0xB7C6, { 0xF0, 0xA2, 0x94, 0x9F },
	0xB7C7, { 0xF0, 0xA2, 0x94, 0xA5 },
	0xB7C8, { 0xE3, 0xA3, 0xAD },
	0xB7C9, { 0xE3, 0xA3, 0xAB },
	0xB7CA, { 0xE5, 0xBE, 0xA4 },
	0xB7CB, { 0xF0, 0xA2, 0x9B, 0x86 },
	0xB7CC, { 0xF0, 0xA2, 0x9B, 0x96 },
	0xB7CD, { 0xF0, 0xA2, 0x9B, 0x83 },
	0xB7CE, { 0xE3, 0xA5, 0xA2 },
	0xB7CF, { 0xF0, 0xA2, 0x9C, 0xAC },
	0xB7D0, { 0xE3, 0xA5, 0x9D },
	0xB7D1, { 0xF0, 0xA2, 0x9C, 0xAE },
	0xB7D2, { 0xF0, 0xA2, 0x9D, 0x9E },
	0xB7D3, { 0xF0, 0xA2, 0x9C, 0xB3 },
	0xB7D4, { 0xE3, 0xA5, 0xA1 },
	0xB7D5, { 0xE3, 0xA5, 0xA5 },
	0xB7D6, { 0xE3, 0xA5, 0x9C },
	0xB7D7, { 0xF0, 0xA2, 0x9C, 0xAD },
	0xB7D8, { 0xF0, 0xA2, 0x9D, 0x86 },
	0xB7D9, { 0xE3, 0xA5, 0x9F },
	0xB7DA, { 0xF0, 0xA2, 0x9B, 0x81 },
	0xB7DB, { 0xF0, 0xA2, 0x9C, 0xBA },
	0xB7DC, { 0xF0, 0xA2, 0xA7, 0x8C },
	0xB7DD, { 0xF0, 0xA2, 0xAE, 0x9D },
	0xB7DE, { 0xF0, 0xA2, 0xAE, 0x83 },
	0xB7DF, { 0xF0, 0xA2, 0xAF, 0xB6 },
	0xB7E0, { 0xE6, 0x8F, 0xAC },
	0xB7E1, { 0xE3, 0xA8, 0x96 },
	0xB7E2, { 0xE3, 0xA8, 0x8A },
	0xB7E3, { 0xF0, 0xA2, 0xAF, 0xB8 },
	0xB7E4, { 0xE3, 0xA8, 0x8E },
	0xB7E5, { 0xE3, 0xA8, 0x92 },
	0xB7E6, { 0xF0, 0xA2, 0xAF, 0xBE },
	0xB7E7, { 0xF0, 0xA2, 0xAF, 0xB3 },
	0xB7E8, { 0xE3, 0xA8, 0x91 },
	0xB7E9, { 0xF0, 0xA2, 0xAF, 0xAB },
	0xB7EA, { 0xF0, 0xA2, 0xAF, 0xBA },
	0xB7EB, { 0xE3, 0xA8, 0x90 },
	0xB7EC, { 0xF0, 0xA2, 0xB0, 0x87 },
	0xB7ED, { 0xF0, 0xA2, 0xAF, 0xBC },
	0xB7EE, { 0xE3, 0xA8, 0x89 },
	0xB7EF, { 0xE6, 0x8F, 0xBA },
	0xB7F0, { 0xE3, 0xA8, 0x95 },
	0xB7F1, { 0xE6, 0x8F, 0x94 },
	0xB7F2, { 0xF0, 0xA2, 0xBD, 0xB2 },
	0xB7F3, { 0xF0, 0xA2, 0xBD, 0xB3 },
	0xB7F4, { 0xF0, 0xA2, 0xBD, 0xB4 },
	0xB7F5, { 0xE3, 0xAA, 0x91 },
	0xB7F6, { 0xE3, 0xAA, 0x95 },
	0xB7F7, { 0xE3, 0xAA, 0x93 },
	0xB7F8, { 0xE3, 0xAA, 0x92 },
	0xB7F9, { 0xE3, 0xAA, 0x8F },
	0xB7FA, { 0xF0, 0xA2, 0xBD, 0x9F },
	0xB7FB, { 0xF0, 0xA2, 0xBD, 0xA0 },
	0xB7FC, { 0xF0, 0xA3, 0x82, 0xAA },
	0xB7FD, { 0xF0, 0xA3, 0x84, 0xB4 },
	0xB7FE, { 0xE3, 0xAB, 0xB6 },
	0xB8A1, { 0xF0, 0xA3, 0x86, 0xB4 },
	0xB8A2, { 0xE3, 0xAB, 0xBB },
	0xB8A3, { 0xF0, 0xA3, 0x87, 0xB0 },
	0xB8A4, { 0xE6, 0x99, 0xB5 },
	0xB8A5, { 0xE3, 0xAB, 0xB9 },
	0xB8A6, { 0xF0, 0xA3, 0x88, 0x8D },
	0xB8A7, { 0xF0, 0xA3, 0x87, 0xB3 },
	0xB8A8, { 0xF0, 0xA3, 0x88, 0x8F },
	0xB8A9, { 0xE6, 0x9C, 0x9C },
	0xB8AA, { 0xE3, 0xAD, 0xBD },
	0xB8AB, { 0xF0, 0xA3, 0x93, 0x89 },
	0xB8AC, { 0xE3, 0xAD, 0xBA },
	0xB8AD, { 0xE3, 0xAD, 0xBF },
	0xB8AE, { 0xF0, 0xA3, 0x93, 0x85 },
	0xB8AF, { 0xE3, 0xAD, 0xB8 },
	0xB8B0, { 0xF0, 0xA3, 0x93, 0x97 },
	0xB8B1, { 0xF0, 0xA3, 0x93, 0x8C },
	0xB8B2, { 0xE6, 0xA3, 0x99 },
	0xB8B3, { 0xF0, 0xA3, 0x93, 0xA7 },
	0xB8B4, { 0xE3, 0xAD, 0xB0 },
	0xB8B5, { 0xE3, 0xAE, 0x82 },
	0xB8B6, { 0xF0, 0xA3, 0x93, 0x81 },
	0xB8B7, { 0xE3, 0xAE, 0x84 },
	0xB8B8, { 0xF0, 0xA3, 0x93, 0xA8 },
	0xB8B9, { 0xE3, 0xB0, 0xB3 },
	0xB8BA, { 0xF0, 0xA3, 0xA3, 0x8B },
	0xB8BB, { 0xE3, 0xB0, 0xB2 },
	0xB8BC, { 0xE3, 0xB0, 0xB6 },
	0xB8BD, { 0xF0, 0xA3, 0xA3, 0x88 },
	0xB8BE, { 0xF0, 0xA3, 0xA5, 0xBA },
	0xB8BF, { 0xE3, 0xB1, 0x96 },
	0xB8C0, { 0xF0, 0xA3, 0xA5, 0xB9 },
	0xB8C1, { 0xF0, 0xA3, 0xA5, 0xBE },
	0xB8C2, { 0xE3, 0xB1, 0xA7 },
	0xB8C3, { 0xF0, 0xA3, 0xA8, 0x9B },
	0xB8C4, { 0xE3, 0xB1, 0xA5 },
	0xB8C5, { 0xE3, 0xB1, 0xA4 },
	0xB8C6, { 0xE3, 0xB1, 0xA6 },
	0xB8C7, { 0xF0, 0xA3, 0xA8, 0x9F },
	0xB8C8, { 0xF0, 0xA3, 0xA8, 0x99 },
	0xB8C9, { 0xE3, 0xB2, 0x81 },
	0xB8CA, { 0xE3, 0xB2, 0x82 },
	0xB8CB, { 0xE3, 0xB2, 0x83 },
	0xB8CC, { 0xE3, 0xB2, 0x9E },
	0xB8CD, { 0xF0, 0xA3, 0xAE, 0x89 },
	0xB8CE, { 0xE6, 0xAF, 0xB1 },
	0xB8CF, { 0xE3, 0xB2, 0x9D },
	0xB8D0, { 0xF0, 0xA3, 0xAE, 0x8B },
	0xB8D1, { 0xE3, 0xB4, 0x8F },
	0xB8D2, { 0xE3, 0xB4, 0x92 },
	0xB8D3, { 0xF0, 0xA3, 0xB8, 0x89 },
	0xB8D4, { 0xF0, 0xA3, 0xB7, 0xBE },
	0xB8D5, { 0xF0, 0xA3, 0xB8, 0x80 },
	0xB8D6, { 0xE3, 0xB4, 0x90 },
	0xB8D7, { 0xE3, 0xB4, 0x98 },
	0xB8D8, { 0xF0, 0xA3, 0xB8, 0x8B },
	0xB8D9, { 0xE3, 0xB4, 0x94 },
	0xB8DA, { 0xE3, 0xB4, 0x99 },
	0xB8DB, { 0xE6, 0xB8, 0xB7 },
	0xB8DD, { 0xF0, 0xA3, 0xB9, 0x8A },
	0xB8DE, { 0xE6, 0xB9, 0xBD },
	0xB8DF, { 0xE6, 0xBA, 0x86 },
	0xB8E0, { 0xE3, 0xB7, 0x88 },
	0xB8E1, { 0xE3, 0xB7, 0x84 },
	0xB8E2, { 0xE3, 0xB7, 0x86 },
	0xB8E3, { 0xF0, 0xA4, 0x89, 0xB9 },
	0xB8E4, { 0xE3, 0xB7, 0x87 },
	0xB8E5, { 0xE3, 0xB7, 0x83 },
	0xB8E6, { 0xF0, 0xA4, 0x89, 0xAC },
	0xB8E7, { 0xF0, 0xA4, 0x8A, 0x99 },
	0xB8E8, { 0xF0, 0xAF, 0xA4, 0x9B },
	0xB8E9, { 0xF0, 0xA4, 0x89, 0xA2 },
	0xB8EA, { 0xF0, 0xA4, 0x94, 0x94 },
	0xB8EB, { 0xE3, 0xB8, 0x99 },
	0xB8EC, { 0xE3, 0xB8, 0x9C },
	0xB8ED, { 0xF0, 0xA4, 0x97, 0x88 },
	0xB8EE, { 0xF0, 0xA4, 0x97, 0x97 },
	0xB8EF, { 0xF0, 0xA4, 0x98, 0x8C },
	0xB8F0, { 0xE3, 0xB9, 0x81 },
	0xB8F1, { 0xF0, 0xA4, 0x99, 0xB0 },
	0xB8F2, { 0xE3, 0xB9, 0x82 },
	0xB8F3, { 0xE3, 0xB9, 0x83 },
	0xB8F4, { 0xF0, 0xA4, 0x99, 0xB1 },
	0xB8F5, { 0xF0, 0xA4, 0x9F, 0x9F },
	0xB8F6, { 0xF0, 0xA4, 0x9F, 0xA4 },
	0xB8F7, { 0xE3, 0xBA, 0x82 },
	0xB8F8, { 0xF0, 0xA4, 0x9F, 0xA7 },
	0xB8F9, { 0xE3, 0xBA, 0x81 },
	0xB8FA, { 0xE3, 0xBA, 0x94 },
	0xB8FB, { 0xE3, 0xBA, 0x84 },
	0xB8FC, { 0xF0, 0xA4, 0xA6, 0x90 },
	0xB8FD, { 0xE3, 0xBB, 0x92 },
	0xB8FE, { 0xE3, 0xBC, 0x8F },
	0xB9A1, { 0xE3, 0xBC, 0xA2 },
	0xB9A2, { 0xF0, 0xA4, 0xAD, 0x8C },
	0xB9A3, { 0xE3, 0xBC, 0xA7 },
	0xB9A4, { 0xE3, 0xBC, 0xAA },
	0xB9A5, { 0xE7, 0x93, 0xBA },
	0xB9A6, { 0xE3, 0xBC, 0xA8 },
	0xB9A7, { 0xF0, 0xA4, 0xAD, 0x8F },
	0xB9A8, { 0xE3, 0xBD, 0xA0 },
	0xB9A9, { 0xF0, 0xA4, 0xB1, 0xBD },
	0xB9AA, { 0xF0, 0xA4, 0xB1, 0xBE },
	0xB9AB, { 0xF0, 0xA4, 0xB1, 0xBC },
	0xB9AC, { 0xE7, 0x95, 0xB2 },
	0xB9AD, { 0xF0, 0xA4, 0xB2, 0x8D },
	0xB9AE, { 0xF0, 0xA4, 0xB4, 0x99 },
	0xB9AF, { 0xE3, 0xBE, 0x9B },
	0xB9B0, { 0xE3, 0xBE, 0x9C },
	0xB9B1, { 0xF0, 0xA4, 0xB7, 0x80 },
	0xB9B2, { 0xE3, 0xBE, 0x93 },
	0xB9B3, { 0xE3, 0xBE, 0x94 },
	0xB9B4, { 0xE7, 0x97, 0x9C },
	0xB9B5, { 0xE3, 0xBE, 0xA0 },
	0xB9B6, { 0xE3, 0xBE, 0x99 },
	0xB9B7, { 0xF0, 0xA4, 0xB6, 0xB6 },
	0xB9B8, { 0xE3, 0xBE, 0xA1 },
	0xB9B9, { 0xF0, 0xA4, 0xB6, 0xA8 },
	0xB9BA, { 0xE3, 0xBF, 0xB1 },
	0xB9BB, { 0xF0, 0xA4, 0xBF, 0xAB },
	0xB9BC, { 0xF0, 0xA4, 0xBF, 0xA7 },
	0xB9BD, { 0xF0, 0xA5, 0x81, 0xAF },
	0xB9BE, { 0xF0, 0xA5, 0x87, 0x87 },
	0xB9BF, { 0xE4, 0x80, 0xB6 },
	0xB9C0, { 0xF0, 0xA5, 0x86, 0x9F },
	0xB9C1, { 0xE4, 0x80, 0xB7 },
	0xB9C2, { 0xE4, 0x80, 0xBF },
	0xB9C3, { 0xE4, 0x80, 0xBC },
	0xB9C4, { 0xF0, 0xA5, 0x87, 0x84 },
	0xB9C5, { 0xE4, 0x80, 0xB4 },
	0xB9C6, { 0xE4, 0x80, 0xB9 },
	0xB9C7, { 0xE4, 0x80, 0xBB },
	0xB9C8, { 0xE4, 0x80, 0xB5 },
	0xB9C9, { 0xE4, 0x80, 0xB0 },
	0xB9CA, { 0xE4, 0x80, 0xB2 },
	0xB9CB, { 0xE4, 0x80, 0xB8 },
	0xB9CC, { 0xE4, 0x80, 0xBE },
	0xB9CD, { 0xE4, 0x80, 0xBA },
	0xB9CE, { 0xF0, 0xA5, 0x86, 0x9B },
	0xB9CF, { 0xF0, 0xA5, 0x86, 0x97 },
	0xB9D0, { 0xF0, 0xA5, 0x87, 0x85 },
	0xB9D1, { 0xF0, 0xA5, 0x8D, 0xAB },
	0xB9D2, { 0xF0, 0xA5, 0x8F, 0x8E },
	0xB9D3, { 0xE4, 0x82, 0xB6 },
	0xB9D4, { 0xE7, 0xA1, 0xA7 },
	0xB9D5, { 0xF0, 0xA5, 0x92, 0xB1 },
	0xB9D6, { 0xF0, 0xA5, 0x92, 0xAE },
	0xB9D7, { 0xF0, 0xA5, 0x92, 0xB0 },
	0xB9D8, { 0xE4, 0x82, 0xB3 },
	0xB9D9, { 0xE4, 0x84, 0x89 },
	0xB9DA, { 0xE7, 0xA5, 0xB7 },
	0xB9DB, { 0xF0, 0xA5, 0x9C, 0xBE },
	0xB9DC, { 0xF0, 0xA5, 0x9E, 0xB5 },
	0xB9DD, { 0xF0, 0xA5, 0x9E, 0xBA },
	0xB9DE, { 0xE4, 0x85, 0x8C },
	0xB9DF, { 0xF0, 0xA5, 0x9E, 0xB2 },
	0xB9E0, { 0xF0, 0xA5, 0x9E, 0xB4 },
	0xB9E1, { 0xE4, 0x85, 0x93 },
	0xB9E2, { 0xE4, 0x85, 0x8D },
	0xB9E3, { 0xE4, 0x85, 0x91 },
	0xB9E4, { 0xE4, 0x85, 0x8F },
	0xB9E5, { 0xE7, 0xAA, 0x9B },
	0xB9E6, { 0xF0, 0xA5, 0xA5, 0xB7 },
	0xB9E7, { 0xE4, 0x86, 0xA2 },
	0xB9E8, { 0xF0, 0xA5, 0xA6, 0x86 },
	0xB9E9, { 0xF0, 0xA5, 0xA5, 0xBB },
	0xB9EA, { 0xE4, 0x87, 0x8D },
	0xB9EB, { 0xF0, 0xA5, 0xA9, 0xBE },
	0xB9EC, { 0xF0, 0xA5, 0xAC, 0xAE },
	0xB9ED, { 0xE4, 0x87, 0xA7 },
	0xB9EE, { 0xF0, 0xA5, 0xAC, 0xAF },
	0xB9EF, { 0xE4, 0x87, 0xB0 },
	0xB9F0, { 0xF0, 0xA5, 0xAC, 0xB7 },
	0xB9F1, { 0xE4, 0x87, 0xA9 },
	0xB9F2, { 0xE4, 0x87, 0xAC },
	0xB9F3, { 0xF0, 0xA5, 0xAC, 0xB2 },
	0xB9F4, { 0xE4, 0x87, 0xA8 },
	0xB9F5, { 0xE4, 0x87, 0xAE },
	0xB9F6, { 0xE4, 0x88, 0x82 },
	0xB9F7, { 0xF0, 0xA5, 0xAC, 0xB6 },
	0xB9F8, { 0xF0, 0xA5, 0xAC, 0xB9 },
	0xB9F9, { 0xF0, 0xA5, 0xAC, 0xB5 },
	0xB9FA, { 0xF0, 0xA5, 0xB9, 0x9C },
	0xB9FB, { 0xE4, 0x8A, 0x82 },
	0xB9FC, { 0xE4, 0x8A, 0x83 },
	0xB9FD, { 0xE4, 0x8A, 0x86 },
	0xB9FE, { 0xF0, 0xA5, 0xB9, 0xBB },
	0xBAA1, { 0xF0, 0xA5, 0xB9, 0xA1 },
	0xBAA2, { 0xF0, 0xA5, 0xBF, 0xAE },
	0xBAA3, { 0xF0, 0xA5, 0xBF, 0xAB },
	0xBAA4, { 0xF0, 0xA5, 0xBF, 0xAF },
	0xBAA5, { 0xF0, 0xA6, 0x80, 0xA0 },
	0xBAA6, { 0xE7, 0xB4, 0xAA },
	0xBAA7, { 0xE7, 0xB5, 0xA5 },
	0xBAA8, { 0xE4, 0x8D, 0x8A },
	0xBAA9, { 0xF0, 0xA6, 0x88, 0xB0 },
	0xBAAA, { 0xE4, 0x8D, 0x9A },
	0xBAAB, { 0xE7, 0xBD, 0xA4 },
	0xBAAC, { 0xF0, 0xA6, 0x8A, 0xBE },
	0xBAAD, { 0xE4, 0x8D, 0xAE },
	0xBAAE, { 0xF0, 0xA6, 0x8D, 0xA7 },
	0xBAAF, { 0xF0, 0xA6, 0x8D, 0xBC },
	0xBAB0, { 0xE4, 0x8D, 0xB0 },
	0xBAB1, { 0xE4, 0x8D, 0xAF },
	0xBAB2, { 0xF0, 0xA6, 0x90, 0xA4 },
	0xBAB3, { 0xE4, 0x8E, 0x8A },
	0xBAB4, { 0xE4, 0x8E, 0x87 },
	0xBAB5, { 0xE4, 0x8E, 0x88 },
	0xBAB6, { 0xF0, 0xA6, 0x90, 0xA9 },
	0xBAB7, { 0xF0, 0xA6, 0x93, 0xAF },
	0xBAB8, { 0xE8, 0x80, 0xA0 },
	0xBAB9, { 0xE4, 0x8E, 0xB7 },
	0xBABA, { 0xE4, 0x8F, 0xBD },
	0xBABB, { 0xE8, 0x84, 0xA0 },
	0xBABC, { 0xF0, 0xA6, 0x9C, 0x8D },
	0xBABD, { 0xE4, 0x90, 0x85 },
	0xBABE, { 0xE8, 0x84, 0xBC },
	0xBABF, { 0xE4, 0x90, 0x88 },
	0xBAC0, { 0xE4, 0x90, 0x83 },
	0xBAC1, { 0xE4, 0x90, 0x82 },
	0xBAC2, { 0xE4, 0x90, 0x84 },
	0xBAC3, { 0xE3, 0xAC, 0xB9 },
	0xBAC4, { 0xE4, 0x90, 0x89 },
	0xBAC5, { 0xE4, 0x8F, 0xBF },
	0xBAC6, { 0xF0, 0xA6, 0x9D, 0xA4 },
	0xBAC7, { 0xE8, 0x84, 0xBF },
	0xBAC8, { 0xF0, 0xA6, 0x9C, 0x95 },
	0xBAC9, { 0xE4, 0x8F, 0xBC },
	0xBACA, { 0xE4, 0x90, 0x81 },
	0xBACB, { 0xE4, 0x90, 0x8A },
	0xBACC, { 0xE8, 0x87, 0xB0 },
	0xBACD, { 0xE8, 0x87, 0xB5 },
	0xBACE, { 0xE4, 0x91, 0xAB },
	0xBACF, { 0xE4, 0x91, 0xAC },
	0xBAD0, { 0xF0, 0xA6, 0xA8, 0xB5 },
	0xBAD1, { 0xF0, 0xA6, 0xA8, 0xB6 },
	0xBAD2, { 0xF0, 0xA6, 0xA8, 0xB4 },
	0xBAD3, { 0xF0, 0xA6, 0xA8, 0xB7 },
	0xBAD4, { 0xF0, 0xA6, 0xB1, 0x87 },
	0xBAD5, { 0xF0, 0xA6, 0xB0, 0xAB },
	0xBAD6, { 0xE4, 0x93, 0x9E },
	0xBAD7, { 0xF0, 0xA6, 0xB1, 0x81 },
	0xBAD8, { 0xF0, 0xA6, 0xB1, 0x83 },
	0xBAD9, { 0xE4, 0x93, 0x9B },
	0xBADA, { 0xF0, 0xA6, 0xB1, 0x82 },
	0xBADB, { 0xE4, 0x93, 0x9D },
	0xBADC, { 0xE4, 0x93, 0xA3 },
	0xBADD, { 0xF0, 0xA6, 0xB0, 0xB2 },
	0xBADE, { 0xE4, 0x93, 0xA0 },
	0xBADF, { 0xE4, 0x93, 0x99 },
	0xBAE0, { 0xE4, 0x93, 0x98 },
	0xBAE1, { 0xE4, 0x93, 0xA4 },
	0xBAE2, { 0xF0, 0xA6, 0xB1, 0x84 },
	0xBAE3, { 0xF0, 0xA6, 0xB1, 0x8A },
	0xBAE4, { 0xE4, 0x93, 0x9A },
	0xBAE5, { 0xE4, 0x93, 0xAF },
	0xBAE6, { 0xF0, 0xAF, 0xA6, 0xA0 },
	0xBAE7, { 0xE8, 0x90, 0x95 },
	0xBAE8, { 0xE8, 0x8E, 0xBE },
	0xBAE9, { 0xF0, 0xA6, 0xB1, 0x94 },
	0xBAEA, { 0xF0, 0xA6, 0xB1, 0xAE },
	0xBAEB, { 0xF0, 0xA6, 0xB1, 0x92 },
	0xBAEC, { 0xE4, 0x93, 0x97 },
	0xBAED, { 0xE4, 0x96, 0xB3 },
	0xBAEE, { 0xE4, 0x96, 0xBB },
	0xBAEF, { 0xE8, 0x9B, 0xA5 },
	0xBAF0, { 0xE4, 0x96, 0xB2 },
	0xBAF1, { 0xE8, 0x9B, 0x92 },
	0xBAF2, { 0xE4, 0x96, 0xAD },
	0xBAF3, { 0xF0, 0xA7, 0x8A, 0x92 },
	0xBAF4, { 0xE4, 0x96, 0xAF },
	0xBAF5, { 0xF0, 0xAF, 0xA6, 0xB8 },
	0xBAF6, { 0xE8, 0x9B, 0xA0 },
	0xBAF7, { 0xF0, 0xA7, 0x8A, 0xBF },
	0xBAF8, { 0xE4, 0x98, 0x96 },
	0xBAF9, { 0xE4, 0x98, 0xA8 },
	0xBAFA, { 0xE4, 0x98, 0xA3 },
	0xBAFB, { 0xE8, 0xA2, 0xB3 },
	0xBAFC, { 0xF0, 0xA7, 0x99, 0x81 },
	0xBAFD, { 0xF0, 0xA7, 0x99, 0xA9 },
	0xBAFE, { 0xF0, 0xA7, 0x99, 0xA5 },
	0xBBA1, { 0xE4, 0x99, 0xB5 },
	0xBBA2, { 0xE4, 0x99, 0xBE },
	0xBBA3, { 0xE4, 0x99, 0xBC },
	0xBBA4, { 0xF0, 0xA7, 0xA0, 0xA2 },
	0xBBA5, { 0xF0, 0xA7, 0xA0, 0x9D },
	0xBBA6, { 0xF0, 0xA7, 0xA3, 0x92 },
	0xBBA7, { 0xF0, 0xA7, 0xA3, 0x9A },
	0xBBA8, { 0xF0, 0xA7, 0xA3, 0x9B },
	0xBBA9, { 0xE4, 0x9B, 0x8E },
	0xBBAA, { 0xE4, 0x9B, 0x8D },
	0xBBAB, { 0xE4, 0x9B, 0x8F },
	0xBBAC, { 0xE8, 0xA9, 0x93 },
	0xBBAD, { 0xF0, 0xA7, 0xA6, 0xA4 },
	0xBBAE, { 0xF0, 0xA7, 0xA6, 0x9E },
	0xBBAF, { 0xE8, 0xA8, 0xB7 },
	0xBBB0, { 0xE8, 0xA9, 0x87 },
	0xBBB1, { 0xE8, 0xA9, 0x9C },
	0xBBB2, { 0xF0, 0xA7, 0xA6, 0x9D },
	0xBBB3, { 0xE4, 0x9B, 0x84 },
	0xBBB4, { 0xE4, 0x9B, 0x8C },
	0xBBB5, { 0xE4, 0x9B, 0x88 },
	0xBBB6, { 0xE4, 0x9B, 0x87 },
	0xBBB7, { 0xF0, 0xA7, 0xA6, 0xAD },
	0xBBB8, { 0xF0, 0xA7, 0xA6, 0xA6 },
	0xBBB9, { 0xF0, 0xA7, 0xA6, 0xA7 },
	0xBBBA, { 0xF0, 0xA7, 0xAE, 0xB3 },
	0xBBBB, { 0xF0, 0xA7, 0xAF, 0xA0 },
	0xBBBC, { 0xF0, 0xA7, 0xB0, 0xB5 },
	0xBBBD, { 0xF0, 0xA7, 0xB0, 0xB7 },
	0xBBBE, { 0xE4, 0x9D, 0x9A },
	0xBBBF, { 0xE4, 0x9D, 0xAA },
	0xBBC0, { 0xF0, 0xA7, 0xB5, 0x8A },
	0xBBC1, { 0xE4, 0x9D, 0xAB },
	0xBBC2, { 0xE4, 0x9D, 0xAD },
	0xBBC3, { 0xE4, 0x9D, 0xAF },
	0xBBC4, { 0xF0, 0xA7, 0xB9, 0x9E },
	0xBBC5, { 0xE4, 0x9E, 0x9E },
	0xBBC6, { 0xF0, 0xA7, 0xBB, 0x80 },
	0xBBC7, { 0xE4, 0x9E, 0xA4 },
	0xBBC8, { 0xE4, 0x9E, 0xA3 },
	0xBBC9, { 0xE4, 0x9F, 0xA4 },
	0xBBCA, { 0xE4, 0x9F, 0xA8 },
	0xBBCB, { 0xE4, 0x9F, 0xA9 },
	0xBBCC, { 0xE4, 0x9F, 0xA0 },
	0xBBCD, { 0xE4, 0x9F, 0xA3 },
	0xBBCE, { 0xF0, 0xA7, 0xBF, 0xB9 },
	0xBBCF, { 0xE4, 0x9F, 0xAA },
	0xBBD0, { 0xE4, 0x9F, 0xA1 },
	0xBBD1, { 0xE4, 0x9F, 0xAD },
	0xBBD2, { 0xE4, 0xA0, 0xB4 },
	0xBBD3, { 0xE4, 0xA0, 0xB5 },
	0xBBD4, { 0xE4, 0xA1, 0x91 },
	0xBBD5, { 0xE8, 0xBB, 0xB0 },
	0xBBD6, { 0xF0, 0xA8, 0x93, 0xB0 },
	0xBBD7, { 0xE4, 0xA2, 0x9D },
	0xBBD8, { 0xF0, 0xA8, 0x93, 0xB3 },
	0xBBD9, { 0xF0, 0xA8, 0x94, 0x9B },
	0xBBDA, { 0xF0, 0xA8, 0x93, 0xB2 },
	0xBBDB, { 0xF0, 0xA8, 0x93, 0xBB },
	0xBBDC, { 0xF0, 0xA8, 0x9C, 0x9C },
	0xBBDD, { 0xF0, 0xA8, 0x9C, 0x93 },
	0xBBDE, { 0xE4, 0xA3, 0x90 },
	0xBBDF, { 0xF0, 0xA8, 0x9C, 0x8F },
	0xBBE0, { 0xE4, 0xA3, 0xAE },
	0xBBE1, { 0xF0, 0xA8, 0xA0, 0x96 },
	0xBBE2, { 0xF0, 0xA8, 0xA0, 0x91 },
	0xBBE3, { 0xF0, 0xA8, 0xA0, 0x92 },
	0xBBE4, { 0xE4, 0xA3, 0xB2 },
	0xBBE5, { 0xF0, 0xA8, 0xA0, 0x8E },
	0xBBE6, { 0xE9, 0x88, 0x9D },
	0xBBE7, { 0xE4, 0xA6, 0x88 },
	0xBBE8, { 0xF0, 0xA8, 0xB1, 0xA7 },
	0xBBE9, { 0xF0, 0xA8, 0xB3, 0xB2 },
	0xBBEA, { 0xF0, 0xA8, 0xB3, 0x9A },
	0xBBEB, { 0xE4, 0xA6, 0x8F },
	0xBBEC, { 0xF0, 0xA8, 0xB3, 0x9C },
	0xBBED, { 0xE4, 0xA7, 0x98 },
	0xBBEE, { 0xF0, 0xA8, 0xBE, 0x94 },
	0xBBEF, { 0xF0, 0xA8, 0xBE, 0x9B },
	0xBBF0, { 0xF0, 0xA8, 0xBE, 0x92 },
	0xBBF1, { 0xF0, 0xA8, 0xBE, 0x9A },
	0xBBF2, { 0xF0, 0xA9, 0x82, 0x88 },
	0xBBF3, { 0xF0, 0xA9, 0x82, 0x86 },
	0xBBF4, { 0xE4, 0xA8, 0xBF },
	0xBBF5, { 0xF0, 0xA9, 0x87, 0xAF },
	0xBBF6, { 0xE4, 0xA9, 0x92 },
	0xBBF7, { 0xE9, 0x9D, 0xAB },
	0xBBF8, { 0xF0, 0xA9, 0x89, 0x9E },
	0xBBF9, { 0xE4, 0xA9, 0x90 },
	0xBBFA, { 0xF0, 0xA9, 0x91, 0x98 },
	0xBBFB, { 0xE4, 0xAA, 0xB1 },
	0xBBFC, { 0xF0, 0xA9, 0x91, 0x96 },
	0xBBFD, { 0xF0, 0xA9, 0x91, 0x94 },
	0xBBFE, { 0xE4, 0xAB, 0xB9 },
	0xBCA1, { 0xF0, 0xA9, 0x96, 0x9B },
	0xBCA2, { 0xF0, 0xA9, 0x9A, 0x96 },
	0xBCA3, { 0xF0, 0xA9, 0x9A, 0xA4 },
	0xBCA4, { 0xE4, 0xAC, 0xA6 },
	0xBCA5, { 0xE4, 0xAC, 0xA8 },
	0xBCA6, { 0xF0, 0xA9, 0x9A, 0x9A },
	0xBCA7, { 0xF0, 0xA9, 0xA8, 0x92 },
	0xBCA8, { 0xE3, 0x92, 0x80 },
	0xBCA9, { 0xE5, 0x83, 0x80 },
	0xBCAA, { 0xE3, 0x92, 0x81 },
	0xBCAB, { 0xF0, 0xA0, 0x8D, 0xAB },
	0xBCAC, { 0xE3, 0x91, 0xBE },
	0xBCAD, { 0xE3, 0x91, 0xBF },
	0xBCAE, { 0xF0, 0xA0, 0x8C, 0xB7 },
	0xBCAF, { 0xF0, 0xA0, 0x8C, 0xBC },
	0xBCB0, { 0xF0, 0xAF, 0xA0, 0x8A },
	0xBCB1, { 0xF0, 0xA0, 0x93, 0xB7 },
	0xBCB2, { 0xE3, 0x92, 0xBE },
	0xBCB3, { 0xF0, 0xA0, 0x95, 0xA6 },
	0xBCB4, { 0xE3, 0x93, 0x96 },
	0xBCB5, { 0xF0, 0xA0, 0x9E, 0xA9 },
	0xBCB6, { 0xF0, 0xA0, 0x9E, 0xAE },
	0xBCB7, { 0xF0, 0xA0, 0x9E, 0xAD },
	0xBCB8, { 0xF0, 0xA0, 0x9F, 0x88 },
	0xBCB9, { 0xF0, 0xA0, 0x9E, 0xA5 },
	0xBCBA, { 0xF0, 0xA0, 0x9E, 0xB0 },
	0xBCBB, { 0xF0, 0xA0, 0xA2, 0x95 },
	0xBCBC, { 0xE5, 0x8B, 0xA5 },
	0xBCBD, { 0xF0, 0xA0, 0xA4, 0xA5 },
	0xBCBE, { 0xE3, 0x94, 0xB4 },
	0xBCBF, { 0xF0, 0xA0, 0xAA, 0x99 },
	0xBCC0, { 0xE5, 0x8E, 0xAF },
	0xBCC1, { 0xF0, 0xA0, 0xAD, 0xB4 },
	0xBCC2, { 0xF0, 0xA0, 0xAD, 0xB0 },
	0xBCC3, { 0xF0, 0xA0, 0xAD, 0xAF },
	0xBCC4, { 0xF0, 0xA0, 0xB9, 0x81 },
	0xBCC5, { 0xF0, 0xA0, 0xB9, 0x94 },
	0xBCC6, { 0xE3, 0x97, 0x95 },
	0xBCC7, { 0xE3, 0x97, 0x98 },
	0xBCC8, { 0xF0, 0xA0, 0xB9, 0x80 },
	0xBCC9, { 0xF0, 0xA0, 0xB8, 0xB8 },
	0xBCCA, { 0xE3, 0x97, 0x94 },
	0xBCCB, { 0xE5, 0x97, 0x98 },
	0xBCCC, { 0xE3, 0x97, 0x99 },
	0xBCCD, { 0xF0, 0xA0, 0xB9, 0x92 },
	0xBCCE, { 0xF0, 0xA0, 0xB8, 0xBA },
	0xBCCF, { 0xF0, 0xA0, 0xB9, 0x97 },
	0xBCD0, { 0xF0, 0xAF, 0xA1, 0x8A },
	0xBCD1, { 0xF0, 0xA0, 0xB9, 0x99 },
	0xBCD2, { 0xE5, 0x9C, 0x91 },
	0xBCD3, { 0xE5, 0xA1, 0xA7 },
	0xBCD4, { 0xF0, 0xA1, 0x8E, 0xB4 },
	0xBCD5, { 0xF0, 0xA1, 0x8F, 0x80 },
	0xBCD6, { 0xE3, 0x99, 0x9D },
	0xBCD7, { 0xE5, 0xA1, 0x83 },
	0xBCD8, { 0xE3, 0x99, 0x9E },
	0xBCD9, { 0xE3, 0x99, 0x99 },
	0xBCDA, { 0xF0, 0xA1, 0x8D, 0xB5 },
	0xBCDB, { 0xE3, 0x99, 0x9A },
	0xBCDC, { 0xE3, 0x9A, 0xA0 },
	0xBCDD, { 0xF0, 0xA1, 0x99, 0xA0 },
	0xBCDE, { 0xF0, 0xA1, 0x99, 0x87 },
	0xBCDF, { 0xE3, 0x9C, 0x85 },
	0xBCE0, { 0xF0, 0xA1, 0x9F, 0xB0 },
	0xBCE1, { 0xE3, 0x9C, 0x87 },
	0xBCE2, { 0xF0, 0xA1, 0x9F, 0xAF },
	0xBCE3, { 0xE3, 0x9C, 0x8E },
	0xBCE4, { 0xE3, 0x9C, 0x8C },
	0xBCE5, { 0xF0, 0xA1, 0x9F, 0xAC },
	0xBCE6, { 0xF0, 0xA1, 0xA6, 0x83 },
	0xBCE7, { 0xE3, 0x9D, 0x85 },
	0xBCE8, { 0xF0, 0xA1, 0xA6, 0x84 },
	0xBCE9, { 0xF0, 0xA1, 0xA6, 0x8F },
	0xBCEA, { 0xE3, 0x9D, 0xA4 },
	0xBCEB, { 0xF0, 0xA1, 0xA9, 0xA1 },
	0xBCEC, { 0xE3, 0x9D, 0xA5 },
	0xBCED, { 0xF0, 0xA1, 0xA9, 0xA9 },
	0xBCEE, { 0xE5, 0xAF, 0x9D },
	0xBCEF, { 0xE3, 0x9D, 0xA6 },
	0xBCF0, { 0xF0, 0xA1, 0xA9, 0xA2 },
	0xBCF1, { 0xE3, 0x9E, 0x89 },
	0xBCF2, { 0xE3, 0x9F, 0xAC },
	0xBCF3, { 0xE3, 0x9F, 0xB1 },
	0xBCF4, { 0xE5, 0xB5, 0xB0 },
	0xBCF5, { 0xE5, 0xB5, 0xAA },
	0xBCF6, { 0xE3, 0x9F, 0xB0 },
	0xBCF7, { 0xE3, 0x9F, 0xB8 },
	0xBCF8, { 0xE5, 0xB5, 0xB4 },
	0xBCF9, { 0xE5, 0xB5, 0x9F },
	0xBCFA, { 0xF0, 0xA1, 0xBA, 0xAE },
	0xBCFB, { 0xE5, 0xB5, 0xA1 },
	0xBCFC, { 0xE5, 0xB5, 0xB3 },
	0xBCFD, { 0xF0, 0xA1, 0xBA, 0xB2 },
	0xBCFE, { 0xE3, 0x9F, 0xB2 },
	0xBDA1, { 0xE3, 0x9F, 0xB4 },
	0xBDA2, { 0xF0, 0xA2, 0x84, 0x8B },
	0xBDA3, { 0xE3, 0xA1, 0x98 },
	0xBDA4, { 0xF0, 0xA2, 0x84, 0x90 },
	0xBDA5, { 0xF0, 0xA2, 0x84, 0x8D },
	0xBDA6, { 0xE3, 0xA1, 0x9A },
	0xBDA7, { 0xE3, 0xA1, 0x99 },
	0xBDA8, { 0xE3, 0xA1, 0x97 },
	0xBDA9, { 0xE3, 0xA1, 0x9B },
	0xBDAA, { 0xE5, 0xB9, 0x90 },
	0xBDAB, { 0xF0, 0xA2, 0x89, 0xBF },
	0xBDAC, { 0xF0, 0xA2, 0x8A, 0x81 },
	0xBDAD, { 0xE3, 0xA2, 0xA6 },
	0xBDAE, { 0xE3, 0xA3, 0x82 },
	0xBDAF, { 0xE3, 0xA3, 0x81 },
	0xBDB0, { 0xE5, 0xBC, 0xBF },
	0xBDB1, { 0xF0, 0xA2, 0x90, 0x8B },
	0xBDB2, { 0xF0, 0xA2, 0x95, 0x8E },
	0xBDB3, { 0xE3, 0xA3, 0xAF },
	0xBDB4, { 0xE5, 0xBE, 0xB0 },
	0xBDB5, { 0xF0, 0xA2, 0x9F, 0xAA },
	0xBDB6, { 0xF0, 0xA2, 0x9D, 0x85 },
	0xBDB7, { 0xE3, 0xA5, 0xA8 },
	0xBDB8, { 0xE6, 0x84, 0xB5 },
	0xBDB9, { 0xE6, 0x84, 0xAD },
	0xBDBA, { 0xE3, 0xA5, 0xB3 },
	0xBDBB, { 0xE3, 0xA5, 0xAE },
	0xBDBC, { 0xE3, 0xA5, 0xB4 },
	0xBDBD, { 0xE6, 0x84, 0x82 },
	0xBDBE, { 0xE3, 0xA5, 0xA6 },
	0xBDBF, { 0xF0, 0xA2, 0x9C, 0xA8 },
	0xBDC0, { 0xF0, 0xA2, 0x9D, 0x9D },
	0xBDC1, { 0xF0, 0xA2, 0xA7, 0x9C },
	0xBDC2, { 0xE3, 0xA6, 0xB9 },
	0xBDC3, { 0xE6, 0x88, 0xA6 },
	0xBDC4, { 0xF0, 0xA2, 0xA7, 0x94 },
	0xBDC5, { 0xE3, 0xA8, 0x8C },
	0xBDC6, { 0xF0, 0xA2, 0xB1, 0xA4 },
	0xBDC7, { 0xF0, 0xA2, 0xB1, 0xA8 },
	0xBDC8, { 0xE3, 0xA8, 0xA0 },
	0xBDC9, { 0xF0, 0xA2, 0xB1, 0xA2 },
	0xBDCA, { 0xE3, 0xA8, 0x9D },
	0xBDCB, { 0xF0, 0xA2, 0xB1, 0xA1 },
	0xBDCC, { 0xE3, 0xA8, 0x9C },
	0xBDCD, { 0xF0, 0xA2, 0xB1, 0xA6 },
	0xBDCE, { 0xE3, 0xA8, 0xA1 },
	0xBDCF, { 0xE3, 0xA8, 0x9A },
	0xBDD0, { 0xE3, 0xA8, 0x99 },
	0xBDD1, { 0xF0, 0xA2, 0xAF, 0xB2 },
	0xBDD2, { 0xF0, 0xA2, 0xB1, 0xA9 },
	0xBDD3, { 0xF0, 0xA2, 0xB1, 0xA7 },
	0xBDD4, { 0xE3, 0xA9, 0xBE },
	0xBDD5, { 0xF0, 0xA2, 0xBE, 0x9A },
	0xBDD6, { 0xF0, 0xA2, 0xBE, 0x9B },
	0xBDD7, { 0xF0, 0xA2, 0xBE, 0x85 },
	0xBDD8, { 0xF0, 0xA2, 0xBE, 0x9C },
	0xBDD9, { 0xE3, 0xAA, 0x9D },
	0xBDDA, { 0xF0, 0xA2, 0xBE, 0xA4 },
	0xBDDB, { 0xE3, 0xAA, 0x9E },
	0xBDDC, { 0xE3, 0xAA, 0x9C },
	0xBDDD, { 0xE6, 0x95, 0xAE },
	0xBDDE, { 0xF0, 0xA2, 0xBE, 0x99 },
	0xBDDF, { 0xF0, 0xA2, 0xBE, 0x86 },
	0xBDE0, { 0xF0, 0xA2, 0xBE, 0x90 },
	0xBDE1, { 0xF0, 0xA3, 0x82, 0x81 },
	0xBDE2, { 0xF0, 0xA3, 0x82, 0xAE },
	0xBDE3, { 0xE6, 0x96, 0xB1 },
	0xBDE4, { 0xE6, 0x97, 0x94 },
	0xBDE5, { 0xE3, 0xAB, 0x8D },
	0xBDE6, { 0xF0, 0xA3, 0x84, 0xB8 },
	0xBDE7, { 0xE3, 0xAC, 0x8B },
	0xBDE8, { 0xE3, 0xAC, 0x8A },
	0xBDE9, { 0xE6, 0x9A, 0x85 },
	0xBDEA, { 0xF0, 0xA3, 0x94, 0xBB },
	0xBDEB, { 0xE3, 0xAE, 0x8F },
	0xBDEC, { 0xE6, 0xA5, 0xB2 },
	0xBDED, { 0xE3, 0xAE, 0x95 },
	0xBDEE, { 0xE3, 0xAE, 0x90 },
	0xBDEF, { 0xE3, 0xAE, 0x91 },
	0xBDF0, { 0xF0, 0xA3, 0x95, 0x8C },
	0xBDF1, { 0xE6, 0xA4, 0xBA },
	0xBDF2, { 0xE3, 0xAE, 0xB9 },
	0xBDF3, { 0xF0, 0xA3, 0x95, 0x87 },
	0xBDF4, { 0xF0, 0xA3, 0x94, 0xB5 },
	0xBDF5, { 0xE3, 0xAE, 0x97 },
	0xBDF6, { 0xE3, 0xAE, 0x9E },
	0xBDF7, { 0xF0, 0xA3, 0x94, 0xB3 },
	0xBDF8, { 0xE3, 0xAE, 0x8B },
	0xBDF9, { 0xF0, 0xA3, 0x96, 0x82 },
	0xBDFA, { 0xF0, 0xA3, 0x95, 0x80 },
	0xBDFB, { 0xE3, 0xB0, 0xBB },
	0xBDFC, { 0xE3, 0xB0, 0xBA },
	0xBDFD, { 0xE3, 0xB0, 0xBC },
	0xBDFE, { 0xE3, 0xB0, 0xBD },
	0xBEA1, { 0xE3, 0xB0, 0xB9 },
	0xBEA2, { 0xE3, 0xB0, 0xBE },
	0xBEA3, { 0xE3, 0xB1, 0xAB },
	0xBEA4, { 0xE3, 0xB1, 0xAC },
	0xBEA5, { 0xF0, 0xA3, 0xA8, 0xB6 },
	0xBEA6, { 0xF0, 0xA3, 0xAC, 0x8E },
	0xBEA7, { 0xE3, 0xB2, 0xA2 },
	0xBEA8, { 0xE3, 0xB2, 0xA1 },
	0xBEA9, { 0xE3, 0xB2, 0x9F },
	0xBEAA, { 0xF0, 0xA3, 0xAE, 0xAD },
	0xBEAB, { 0xF0, 0xA3, 0xAE, 0xAA },
	0xBEAC, { 0xF0, 0xA3, 0xB8, 0x97 },
	0xBEAD, { 0xE3, 0xB4, 0xAD },
	0xBEAE, { 0xF0, 0xA3, 0xB9, 0xA7 },
	0xBEAF, { 0xE3, 0xB4, 0xB6 },
	0xBEB0, { 0xE3, 0xB4, 0xAB },
	0xBEB1, { 0xF0, 0xA3, 0xB9, 0xB2 },
	0xBEB2, { 0xE3, 0xB4, 0xB7 },
	0xBEB3, { 0xF0, 0xAF, 0xA4, 0x8A },
	0xBEB4, { 0xF0, 0xA3, 0xB9, 0xA1 },
	0xBEB5, { 0xF0, 0xA3, 0xBA, 0xB0 },
	0xBEB6, { 0xE6, 0xBA, 0xAD },
	0xBEB7, { 0xE3, 0xB4, 0xA5 },
	0xBEB8, { 0xE3, 0xB4, 0xAF },
	0xBEB9, { 0xE3, 0xB4, 0xAC },
	0xBEBA, { 0xF0, 0xA3, 0xB9, 0xAE },
	0xBEBB, { 0xF0, 0xA3, 0xB9, 0xA4 },
	0xBEBC, { 0xE3, 0xB4, 0xB2 },
	0xBEBD, { 0xF0, 0xA3, 0xBA, 0x8C },
	0xBEBE, { 0xF0, 0xA3, 0xB9, 0xA6 },
	0xBEBF, { 0xE6, 0xBA, 0x95 },
	0xBEC0, { 0xF0, 0xA3, 0xB9, 0xAB },
	0xBEC1, { 0xF0, 0xA3, 0xB9, 0x9F },
	0xBEC2, { 0xF0, 0xA3, 0xB9, 0xB4 },
	0xBEC3, { 0xF0, 0xA3, 0xB9, 0xA5 },
	0xBEC4, { 0xF0, 0xA4, 0x8A, 0xBB },
	0xBEC5, { 0xF0, 0xA4, 0x8A, 0xBE },
	0xBEC6, { 0xE3, 0xB7, 0x95 },
	0xBEC7, { 0xF0, 0xA4, 0x8A, 0xB9 },
	0xBEC8, { 0xE3, 0xB7, 0x94 },
	0xBEC9, { 0xE3, 0xB7, 0x96 },
	0xBECA, { 0xF0, 0xA4, 0x8B, 0xAF },
	0xBECB, { 0xE3, 0xB7, 0x91 },
	0xBECC, { 0xE7, 0x89, 0x83 },
	0xBECD, { 0xF0, 0xA4, 0x97, 0x9A },
	0xBECE, { 0xE3, 0xB9, 0x86 },
	0xBECF, { 0xE7, 0x8A, 0x8F },
	0xBED0, { 0xF0, 0xA4, 0x9A, 0x90 },
	0xBED1, { 0xF0, 0xA4, 0x9F, 0xA9 },
	0xBED2, { 0xE3, 0xBA, 0x8C },
	0xBED3, { 0xE3, 0xBA, 0x8A },
	0xBED4, { 0xE3, 0xBA, 0x88 },
	0xBED5, { 0xF0, 0xA4, 0xA0, 0x91 },
	0xBED6, { 0xF0, 0xA4, 0xA0, 0x8D },
	0xBED7, { 0xF0, 0xA4, 0x9F, 0xAD },
	0xBED8, { 0xF0, 0xA4, 0xA0, 0xA1 },
	0xBED9, { 0xE3, 0xBB, 0x9D },
	0xBEDA, { 0xF0, 0xA4, 0xA6, 0x81 },
	0xBEDB, { 0xF0, 0xA4, 0xA6, 0xB1 },
	0xBEDC, { 0xF0, 0xA4, 0xAC, 0x81 },
	0xBEDD, { 0xE3, 0xBC, 0xAD },
	0xBEDE, { 0xF0, 0xA4, 0xAD, 0x9E },
	0xBEDF, { 0xF0, 0xA4, 0xAD, 0xA2 },
	0xBEE0, { 0xE3, 0xBC, 0xAE },
	0xBEE1, { 0xE3, 0xBC, 0xAC },
	0xBEE2, { 0xE3, 0xBC, 0xAB },
	0xBEE3, { 0xE3, 0xBC, 0xB0 },
	0xBEE4, { 0xF0, 0xA4, 0xAD, 0x9B },
	0xBEE5, { 0xE3, 0xBD, 0x8E },
	0xBEE6, { 0xF0, 0xA4, 0xB2, 0x96 },
	0xBEE7, { 0xF0, 0xA4, 0xB2, 0x93 },
	0xBEE8, { 0xE3, 0xBD, 0xA4 },
	0xBEE9, { 0xE3, 0xBD, 0xA1 },
	0xBEEA, { 0xF0, 0xA4, 0xB2, 0x92 },
	0xBEEB, { 0xE7, 0x95, 0xB5 },
	0xBEEC, { 0xF0, 0xAF, 0xA4, 0xB9 },
	0xBEED, { 0xE3, 0xBD, 0xB0 },
	0xBEEE, { 0xE3, 0xBE, 0xA6 },
	0xBEEF, { 0xE3, 0xBE, 0xA4 },
	0xBEF0, { 0xF0, 0xA4, 0xB7, 0x84 },
	0xBEF1, { 0xF0, 0xA4, 0xB7, 0x87 },
	0xBEF2, { 0xF0, 0xA4, 0xB7, 0x83 },
	0xBEF3, { 0xE3, 0xBE, 0xA8 },
	0xBEF4, { 0xE3, 0xBE, 0xA2 },
	0xBEF5, { 0xF0, 0xA4, 0xB7, 0x88 },
	0xBEF6, { 0xE3, 0xBE, 0xA7 },
	0xBEF7, { 0xE7, 0x97, 0xAC },
	0xBEF8, { 0xE3, 0xBE, 0xA5 },
	0xBEF9, { 0xF0, 0xA4, 0xB7, 0x8A },
	0xBEFA, { 0xE3, 0xBE, 0xA9 },
	0xBEFB, { 0xF0, 0xA4, 0xB7, 0x85 },
	0xBEFC, { 0xF0, 0xA4, 0xB7, 0x8F },
	0xBEFD, { 0xF0, 0xA4, 0xB7, 0x9C },
	0xBEFE, { 0xF0, 0xA4, 0xBD, 0xBC },
	0xBFA1, { 0xF0, 0xA5, 0x80, 0x81 },
	0xBFA2, { 0xE4, 0x80, 0xBD },
	0xBFA3, { 0xF0, 0xA5, 0x87, 0x93 },
	0xBFA4, { 0xF0, 0xA5, 0x87, 0x9C },
	0xBFA5, { 0xE4, 0x81, 0x84 },
	0xBFA6, { 0xE4, 0x81, 0x85 },
	0xBFA7, { 0xE4, 0x81, 0x86 },
	0xBFA8, { 0xF0, 0xA5, 0x87, 0x94 },
	0xBFA9, { 0xE7, 0x9D, 0x97 },
	0xBFAA, { 0xF0, 0xA5, 0x87, 0x8C },
	0xBFAB, { 0xE4, 0x81, 0x87 },
	0xBFAC, { 0xE4, 0x81, 0x88 },
	0xBFAD, { 0xE4, 0x81, 0x82 },
	0xBFAE, { 0xF0, 0xA5, 0x87, 0x96 },
	0xBFAF, { 0xF0, 0xA5, 0x87, 0x9B },
	0xBFB0, { 0xE4, 0x81, 0x81 },
	0xBFB1, { 0xF0, 0xA5, 0x87, 0x95 },
	0xBFB2, { 0xF0, 0xA5, 0x8F, 0x99 },
	0xBFB3, { 0xE4, 0x82, 0x94 },
	0xBFB4, { 0xF0, 0xA5, 0x8F, 0x9D },
	0xBFB5, { 0xF0, 0xA5, 0x8F, 0x9C },
	0xBFB6, { 0xF0, 0xA5, 0x8F, 0xA0 },
	0xBFB7, { 0xF0, 0xA5, 0x93, 0x8C },
	0xBFB8, { 0xE4, 0x83, 0x80 },
	0xBFB9, { 0xE4, 0x82, 0xB8 },
	0xBFBA, { 0xE4, 0x83, 0x81 },
	0xBFBB, { 0xE4, 0x83, 0x82 },
	0xBFBC, { 0xE4, 0x82, 0xBB },
	0xBFBD, { 0xE4, 0x82, 0xBD },
	0xBFBE, { 0xE4, 0x82, 0xBF },
	0xBFBF, { 0xE4, 0x82, 0xB9 },
	0xBFC0, { 0xE4, 0x82, 0xB7 },
	0xBFC1, { 0xF0, 0xA5, 0x93, 0x92 },
	0xBFC2, { 0xE4, 0x83, 0x87 },
	0xBFC3, { 0xF0, 0xA5, 0x93, 0x93 },
	0xBFC4, { 0xE4, 0x84, 0x8C },
	0xBFC5, { 0xE4, 0x84, 0x8B },
	0xBFC6, { 0xE7, 0xA5, 0xBB },
	0xBFC7, { 0xE4, 0x84, 0x90 },
	0xBFC8, { 0xF0, 0xA5, 0x9A, 0x8D },
	0xBFC9, { 0xE4, 0x85, 0x9D },
	0xBFCA, { 0xE7, 0xA8, 0xA1 },
	0xBFCB, { 0xE4, 0x85, 0x9A },
	0xBFCC, { 0xE4, 0x85, 0x98 },
	0xBFCD, { 0xE4, 0x85, 0x96 },
	0xBFCE, { 0xF0, 0xA5, 0x9F, 0x98 },
	0xBFCF, { 0xE4, 0x85, 0x94 },
	0xBFD0, { 0xE7, 0xA8, 0x96 },
	0xBFD1, { 0xF0, 0xA5, 0x9E, 0xBC },
	0xBFD2, { 0xE4, 0x86, 0xA8 },
	0xBFD3, { 0xE4, 0x86, 0xA7 },
	0xBFD4, { 0xE4, 0x87, 0x8F },
	0xBFD5, { 0xE4, 0x87, 0x90 },
	0xBFD6, { 0xF0, 0xA5, 0xAA, 0x8A },
	0xBFD7, { 0xE7, 0xAB, 0xA8 },
	0xBFD8, { 0xF0, 0xA5, 0xAA, 0x8B },
	0xBFD9, { 0xF0, 0xA5, 0xAA, 0x8D },
	0xBFDA, { 0xE4, 0x87, 0x91 },
	0xBFDB, { 0xE4, 0x87, 0xAB },
	0xBFDC, { 0xF0, 0xA5, 0xAD, 0x93 },
	0xBFDD, { 0xE4, 0x87, 0xBB },
	0xBFDE, { 0xE7, 0xAD, 0xAA },
	0xBFDF, { 0xF0, 0xA5, 0xAD, 0x99 },
	0xBFE0, { 0xE4, 0x87, 0xBD },
	0xBFE1, { 0xE4, 0x87, 0xB8 },
	0xBFE2, { 0xE4, 0x87, 0xB7 },
	0xBFE3, { 0xE4, 0x88, 0x80 },
	0xBFE4, { 0xF0, 0xA5, 0xAD, 0x96 },
	0xBFE5, { 0xF0, 0xA5, 0xAD, 0x97 },
	0xBFE6, { 0xE4, 0x87, 0xB6 },
	0xBFE7, { 0xE7, 0xAD, 0x9F },
	0xBFE8, { 0xF0, 0xA5, 0xB9, 0xB3 },
	0xBFE9, { 0xF0, 0xA6, 0x80, 0x9B },
	0xBFEA, { 0xE4, 0x8B, 0x9F },
	0xBFEB, { 0xF0, 0xA6, 0x80, 0xA1 },
	0xBFEC, { 0xF0, 0xA6, 0x80, 0x96 },
	0xBFED, { 0xF0, 0xA6, 0x80, 0x98 },
	0xBFEE, { 0xE4, 0x8B, 0xA2 },
	0xBFEF, { 0xE4, 0x8B, 0xA4 },
	0xBFF0, { 0xF0, 0xA6, 0x81, 0x84 },
	0xBFF1, { 0xE7, 0xB6, 0x82 },
	0xBFF2, { 0xF0, 0xA6, 0x80, 0xA6 },
	0xBFF3, { 0xE4, 0x8B, 0xA3 },
	0xBFF4, { 0xF0, 0xA6, 0x88, 0xB6 },
	0xBFF5, { 0xE4, 0x8D, 0x99 },
	0xBFF6, { 0xE4, 0x8D, 0xB1 },
	0xBFF7, { 0xE4, 0x8E, 0x8E },
	0xBFF8, { 0xE4, 0x8E, 0x8C },
	0xBFF9, { 0xF0, 0xA6, 0x90, 0xBA },
	0xBFFA, { 0xE4, 0x8E, 0xA4 },
	0xBFFB, { 0xF0, 0xA6, 0x93, 0xB4 },
	0xBFFC, { 0xE8, 0x81, 0x95 },
	0xBFFD, { 0xE4, 0x90, 0x94 },
	0xBFFE, { 0xF0, 0xA6, 0x9D, 0xA2 },
	0xC0A1, { 0xF0, 0xA6, 0x9D, 0x9B },
	0xC0A2, { 0xF0, 0xA6, 0x9D, 0xAA },
	0xC0A3, { 0xE4, 0x90, 0x91 },
	0xC0A4, { 0xF0, 0xA6, 0x9D, 0xA8 },
	0xC0A5, { 0xE4, 0x90, 0x9B },
	0xC0A6, { 0xE4, 0x90, 0x92 },
	0xC0A7, { 0xE4, 0x90, 0x8E },
	0xC0A8, { 0xE4, 0x90, 0x95 },
	0xC0A9, { 0xE8, 0x85, 0xA8 },
	0xC0AA, { 0xE4, 0x90, 0x90 },
	0xC0AB, { 0xF0, 0xA6, 0x9E, 0x81 },
	0xC0AC, { 0xE4, 0x90, 0x97 },
	0xC0AD, { 0xE8, 0x89, 0x86 },
	0xC0AE, { 0xE8, 0x89, 0x83 },
	0xC0AF, { 0xE4, 0x91, 0xB0 },
	0xC0B0, { 0xE4, 0x93, 0xAD },
	0xC0B1, { 0xF0, 0xA6, 0xB3, 0xA7 },
	0xC0B2, { 0xE4, 0x93, 0xAE },
	0xC0B3, { 0xF0, 0xA6, 0xB3, 0xA6 },
	0xC0B4, { 0xF0, 0xA6, 0xB3, 0x91 },
	0xC0B5, { 0xF0, 0xA6, 0xB4, 0x91 },
	0xC0B6, { 0xE8, 0x92, 0x81 },
	0xC0B7, { 0xF0, 0xA6, 0xB3, 0x90 },
	0xC0B8, { 0xF0, 0xA6, 0xB3, 0x99 },
	0xC0B9, { 0xF0, 0xA6, 0xB4, 0x8A },
	0xC0BA, { 0xE4, 0x93, 0xB4 },
	0xC0BB, { 0xF0, 0xA6, 0xB3, 0x9A },
	0xC0BC, { 0xF0, 0xA6, 0xB3, 0x9D },
	0xC0BD, { 0xF0, 0xA6, 0xB3, 0x88 },
	0xC0BE, { 0xF0, 0xA6, 0xB3, 0xA2 },
	0xC0BF, { 0xF0, 0xA6, 0xB3, 0xA9 },
	0xC0C0, { 0xF0, 0xA6, 0xB3, 0x8B },
	0xC0C1, { 0xE8, 0x91, 0xBC },
	0xC0C2, { 0xF0, 0xA6, 0xB3, 0x8C },
	0xC0C3, { 0xF0, 0xA6, 0xB3, 0x81 },
	0xC0C4, { 0xE8, 0x91, 0xAA },
	0xC0C5, { 0xF0, 0xA6, 0xB3, 0x9E },
	0xC0C6, { 0xE8, 0x92, 0x88 },
	0xC0C7, { 0xE4, 0x93, 0xB2 },
	0xC0C8, { 0xE4, 0x93, 0xB8 },
	0xC0C9, { 0xE4, 0x93, 0xB3 },
	0xC0CA, { 0xF0, 0xA6, 0xB5, 0x91 },
	0xC0CB, { 0xF0, 0xA6, 0xB4, 0x92 },
	0xC0CC, { 0xE4, 0x93, 0xBA },
	0xC0CD, { 0xF0, 0xA6, 0xB3, 0xA0 },
	0xC0CE, { 0xF0, 0xA6, 0xB4, 0xAB },
	0xC0CF, { 0xF0, 0xAF, 0xA6, 0xB4 },
	0xC0D0, { 0xF0, 0xA7, 0x8B, 0x98 },
	0xC0D1, { 0xF0, 0xA7, 0x8B, 0x91 },
	0xC0D2, { 0xE8, 0x9C, 0x90 },
	0xC0D3, { 0xF0, 0xA7, 0x8B, 0x92 },
	0xC0D4, { 0xF0, 0xA7, 0x8B, 0x8D },
	0xC0D5, { 0xE8, 0x9C, 0x9F },
	0xC0D6, { 0xE4, 0x96, 0xB6 },
	0xC0D7, { 0xE4, 0x96, 0xB7 },
	0xC0D8, { 0xF0, 0xA7, 0x8C, 0xBD },
	0xC0D9, { 0xE8, 0x9C, 0x8F },
	0xC0DA, { 0xF0, 0xA7, 0x8B, 0x8A },
	0xC0DB, { 0xE4, 0x96, 0xBA },
	0xC0DC, { 0xF0, 0xA7, 0x8B, 0x8B },
	0xC0DD, { 0xE4, 0x96, 0xBC },
	0xC0DE, { 0xF0, 0xA7, 0x8B, 0x97 },
	0xC0DF, { 0xF0, 0xA7, 0x97, 0xB4 },
	0xC0E0, { 0xE4, 0x98, 0xBB },
	0xC0E1, { 0xE8, 0xA3, 0x93 },
	0xC0E2, { 0xE4, 0x98, 0xAF },
	0xC0E3, { 0xF0, 0xA7, 0x9A, 0x87 },
	0xC0E4, { 0xF0, 0xA7, 0x9A, 0x8B },
	0xC0E5, { 0xF0, 0xA7, 0x9A, 0x83 },
	0xC0E6, { 0xE4, 0x98, 0xB7 },
	0xC0E7, { 0xE4, 0x9A, 0x99 },
	0xC0E8, { 0xF0, 0xA7, 0xA7, 0x85 },
	0xC0E9, { 0xF0, 0xA7, 0xA7, 0x92 },
	0xC0EA, { 0xF0, 0xA7, 0xA7, 0x86 },
	0xC0EB, { 0xF0, 0xA7, 0xA7, 0x93 },
	0xC0EC, { 0xE4, 0x9B, 0x99 },
	0xC0ED, { 0xE4, 0x9B, 0x98 },
	0xC0EE, { 0xE4, 0x9B, 0x97 },
	0xC0EF, { 0xF0, 0xA7, 0xA7, 0xB0 },
	0xC0F0, { 0xF0, 0xA7, 0xA7, 0x8D },
	0xC0F1, { 0xF0, 0xA7, 0xA7, 0x8C },
	0xC0F2, { 0xF0, 0xA7, 0xA7, 0x9C },
	0xC0F3, { 0xF0, 0xA7, 0xA7, 0x96 },
	0xC0F4, { 0xE4, 0x9C, 0xB6 },
	0xC0F5, { 0xF0, 0xA7, 0xAF, 0xA6 },
	0xC0F6, { 0xF0, 0xA7, 0xB1, 0x81 },
	0xC0F7, { 0xF0, 0xA7, 0xB0, 0xBF },
	0xC0F8, { 0xE8, 0xB2, 0x87 },
	0xC0F9, { 0xF0, 0xA7, 0xB3, 0x85 },
	0xC0FA, { 0xF0, 0xA7, 0xB3, 0x80 },
	0xC0FB, { 0xF0, 0xA7, 0xB3, 0x86 },
	0xC0FC, { 0xF0, 0xA7, 0xB2, 0xBE },
	0xC0FD, { 0xF0, 0xA7, 0xB2, 0xBF },
	0xC0FE, { 0xE8, 0xB3, 0x86 },
	0xC1A1, { 0xE4, 0x9D, 0xB0 },
	0xC1A2, { 0xF0, 0xA7, 0xB5, 0xA3 },
	0xC1A3, { 0xF0, 0xA7, 0xBB, 0x93 },
	0xC1A4, { 0xF0, 0xA7, 0xBB, 0x9A },
	0xC1A5, { 0xF0, 0xA7, 0xBB, 0x95 },
	0xC1A6, { 0xE4, 0x9E, 0xA5 },
	0xC1A7, { 0xE4, 0x9E, 0xA6 },
	0xC1A8, { 0xE4, 0x9E, 0xA9 },
	0xC1A9, { 0xE4, 0x9F, 0xAE },
	0xC1AA, { 0xE4, 0xA1, 0x94 },
	0xC1AB, { 0xF0, 0xA8, 0x8B, 0xAE },
	0xC1AC, { 0xE4, 0xA1, 0x97 },
	0xC1AD, { 0xF0, 0xA8, 0x8B, 0xBC },
	0xC1AE, { 0xF0, 0xA8, 0x90, 0x94 },
	0xC1AF, { 0xE4, 0xA2, 0xA1 },
	0xC1B0, { 0xF0, 0xA8, 0x94, 0xA3 },
	0xC1B1, { 0xF0, 0xA8, 0x94, 0xA2 },
	0xC1B2, { 0xF0, 0xA8, 0x94, 0xB0 },
	0xC1B3, { 0xF0, 0xA8, 0x9A, 0xB5 },
	0xC1B4, { 0xE4, 0xA3, 0x93 },
	0xC1B5, { 0xF0, 0xA8, 0x9C, 0xB8 },
	0xC1B6, { 0xE4, 0xA3, 0x94 },
	0xC1B7, { 0xF0, 0xA8, 0x9C, 0xBF },
	0xC1B8, { 0xE4, 0xA3, 0x97 },
	0xC1B9, { 0xE9, 0x83, 0x8C },
	0xC1BA, { 0xE9, 0x85, 0xAD },
	0xC1BB, { 0xE9, 0x85, 0xB0 },
	0xC1BC, { 0xE4, 0xA3, 0xB7 },
	0xC1BD, { 0xE4, 0xA3, 0xB6 },
	0xC1BE, { 0xE4, 0xA3, 0xB9 },
	0xC1BF, { 0xE4, 0xA3, 0xB8 },
	0xC1C0, { 0xE9, 0x89, 0x98 },
	0xC1C1, { 0xE9, 0x89, 0x82 },
	0xC1C2, { 0xE9, 0x89, 0xA8 },
	0xC1C3, { 0xE9, 0x89, 0xA9 },
	0xC1C4, { 0xF0, 0xA8, 0xA5, 0xA8 },
	0xC1C5, { 0xF0, 0xA8, 0xA5, 0xA7 },
	0xC1C6, { 0xE9, 0x89, 0x83 },
	0xC1C7, { 0xF0, 0xA8, 0xA5, 0xA5 },
	0xC1C8, { 0xE9, 0x89, 0x87 },
	0xC1C9, { 0xE4, 0xA6, 0x8A },
	0xC1CA, { 0xF0, 0xA8, 0xB1, 0xB5 },
	0xC1CB, { 0xF0, 0xA8, 0xB3, 0xB7 },
	0xC1CC, { 0xF0, 0xA8, 0xB3, 0xB3 },
	0xC1CD, { 0xF0, 0xA8, 0xB3, 0xB6 },
	0xC1CE, { 0xE4, 0xA6, 0x94 },
	0xC1CF, { 0xF0, 0xA8, 0xB4, 0x80 },
	0xC1D0, { 0xE4, 0xA6, 0x93 },
	0xC1D1, { 0xF0, 0xA8, 0xB3, 0xBF },
	0xC1D2, { 0xF0, 0xA8, 0xB3, 0xB5 },
	0xC1D3, { 0xE9, 0x96, 0x9D },
	0xC1D4, { 0xE4, 0xA7, 0x9D },
	0xC1D5, { 0xE4, 0xA7, 0x9C },
	0xC1D6, { 0xE4, 0xA7, 0xB7 },
	0xC1D7, { 0xE9, 0x9B, 0x8F },
	0xC1D8, { 0xF0, 0xA9, 0x82, 0x92 },
	0xC1D9, { 0xF0, 0xA9, 0x88, 0x86 },
	0xC1DA, { 0xE4, 0xA9, 0x82 },
	0xC1DB, { 0xF0, 0xA9, 0x88, 0x87 },
	0xC1DC, { 0xF0, 0xA9, 0x89, 0xAB },
	0xC1DD, { 0xE4, 0xA9, 0x94 },
	0xC1DE, { 0xF0, 0xA9, 0x89, 0xAC },
	0xC1DF, { 0xE4, 0xA9, 0x95 },
	0xC1E0, { 0xF0, 0xA9, 0x8E, 0x93 },
	0xC1E1, { 0xE4, 0xAA, 0x8F },
	0xC1E2, { 0xF0, 0xA9, 0x8E, 0x94 },
	0xC1E3, { 0xE9, 0x9F, 0xB4 },
	0xC1E4, { 0xE4, 0xAA, 0xB4 },
	0xC1E5, { 0xE4, 0xAA, 0xB3 },
	0xC1E6, { 0xF0, 0xA9, 0x91, 0xA2 },
	0xC1E7, { 0xF0, 0xA9, 0x91, 0xA3 },
	0xC1E8, { 0xE9, 0xA0, 0x89 },
	0xC1E9, { 0xF0, 0xA9, 0x91, 0x9F },
	0xC1EA, { 0xF0, 0xA9, 0x91, 0xA4 },
	0xC1EB, { 0xF0, 0xA9, 0x91, 0x9B },
	0xC1EC, { 0xF0, 0xA9, 0x91, 0x99 },
	0xC1ED, { 0xE4, 0xAB, 0xBB },
	0xC1EE, { 0xE4, 0xAB, 0xBD },
	0xC1EF, { 0xF0, 0xA9, 0x96, 0xA4 },
	0xC1F0, { 0xF0, 0xA9, 0x96, 0xAC },
	0xC1F1, { 0xE9, 0xA2, 0xAB },
	0xC1F2, { 0xE4, 0xAB, 0xBC },
	0xC1F3, { 0xF0, 0xA9, 0x9A, 0xB5 },
	0xC1F4, { 0xE4, 0xAC, 0xAC },
	0xC1F5, { 0xE4, 0xAC, 0xAF },
	0xC1F6, { 0xF0, 0xA9, 0x9A, 0xAE },
	0xC1F7, { 0xE4, 0xAC, 0xAB },
	0xC1F8, { 0xF0, 0xA9, 0x9B, 0x85 },
	0xC1F9, { 0xE4, 0xAC, 0xB3 },
	0xC1FA, { 0xE4, 0xAC, 0xB4 },
	0xC1FB, { 0xE9, 0xA3, 0xBB },
	0xC1FC, { 0xF0, 0xA9, 0xA0, 0xBB },
	0xC1FD, { 0xE9, 0xAA, 0xAC },
	0xC1FE, { 0xE9, 0xAA, 0xAE },
	0xC2A1, { 0xE9, 0xAA, 0xAA },
	0xC2A2, { 0xE4, 0xAF, 0xA8 },
	0xC2A3, { 0xF0, 0xA9, 0xAA, 0xBF },
	0xC2A4, { 0xF0, 0xA9, 0xB0, 0xAB },
	0xC2A5, { 0xF0, 0xA9, 0xB2, 0x84 },
	0xC2A6, { 0xF0, 0xA9, 0xB2, 0x80 },
	0xC2A7, { 0xF0, 0xA9, 0xB5, 0x8D },
	0xC2A8, { 0xF0, 0xA9, 0xB5, 0x8F },
	0xC2A9, { 0xE9, 0xAD, 0x9C },
	0xC2AA, { 0xF0, 0xA9, 0xB5, 0x8C },
	0xC2AB, { 0xF0, 0xA9, 0xBE, 0x92 },
	0xC2AC, { 0xE4, 0xB5, 0x9D },
	0xC2AD, { 0xE5, 0x83, 0x92 },
	0xC2AE, { 0xE3, 0x92, 0x85 },
	0xC2AF, { 0xE3, 0x92, 0x88 },
	0xC2B0, { 0xF0, 0xA0, 0x8E, 0xAE },
	0xC2B1, { 0xF0, 0xA0, 0x8D, 0xB9 },
	0xC2B2, { 0xE3, 0x92, 0x8E },
	0xC2B3, { 0xE3, 0x92, 0x84 },
	0xC2B4, { 0xF0, 0xA0, 0x8D, 0xB1 },
	0xC2B5, { 0xE5, 0x83, 0x9F },
	0xC2B6, { 0xF0, 0xA0, 0x8E, 0xB3 },
	0xC2B7, { 0xE3, 0x92, 0x83 },
	0xC2B8, { 0xF0, 0xA0, 0x8C, 0xAC },
	0xC2B9, { 0xF0, 0xA0, 0x8D, 0xB7 },
	0xC2BA, { 0xF0, 0xA0, 0x94, 0xAF },
	0xC2BB, { 0xF0, 0xA0, 0x9F, 0x83 },
	0xC2BC, { 0xE3, 0x94, 0x82 },
	0xC2BD, { 0xF0, 0xA0, 0x9F, 0x8D },
	0xC2BE, { 0xE3, 0x94, 0x86 },
	0xC2BF, { 0xE3, 0x94, 0x85 },
	0xC2C0, { 0xF0, 0xA0, 0x9F, 0x89 },
	0xC2C1, { 0xE3, 0x93, 0xBE },
	0xC2C2, { 0xE3, 0x94, 0x81 },
	0xC2C3, { 0xE3, 0x94, 0x80 },
	0xC2C4, { 0xF0, 0xA0, 0x9F, 0x8E },
	0xC2C5, { 0xF0, 0xA0, 0xA2, 0xA5 },
	0xC2C6, { 0xF0, 0xA0, 0xA2, 0xA0 },
	0xC2C7, { 0xF0, 0xA0, 0xA3, 0xBE },
	0xC2C8, { 0xF0, 0xA0, 0xA5, 0x99 },
	0xC2C9, { 0xF0, 0xA0, 0xAA, 0x9A },
	0xC2CA, { 0xE3, 0x97, 0xA7 },
	0xC2CB, { 0xE5, 0x98, 0x99 },
	0xC2CC, { 0xF0, 0xA0, 0xBB, 0xA4 },
	0xC2CD, { 0xF0, 0xA0, 0xBB, 0x97 },
	0xC2CE, { 0xF0, 0xA0, 0xBB, 0x9C },
	0xC2CF, { 0xE3, 0x97, 0xA6 },
	0xC2D0, { 0xF0, 0xA0, 0xBB, 0xA7 },
	0xC2D1, { 0xE3, 0x97, 0xAD },
	0xC2D2, { 0xE3, 0x97, 0xA2 },
	0xC2D3, { 0xE3, 0x97, 0xAB },
	0xC2D4, { 0xF0, 0xA0, 0xBB, 0xA5 },
	0xC2D5, { 0xE3, 0x97, 0xA8 },
	0xC2D6, { 0xE3, 0x97, 0xAC },
	0xC2D7, { 0xE5, 0x98, 0x8A },
	0xC2D8, { 0xE3, 0x98, 0xA4 },
	0xC2D9, { 0xE5, 0xA2, 0x9A },
	0xC2DA, { 0xF0, 0xA1, 0x90, 0x94 },
	0xC2DB, { 0xE3, 0x99, 0xA2 },
	0xC2DC, { 0xF0, 0xA1, 0x8F, 0xB1 },
	0xC2DD, { 0xE3, 0x99, 0xA1 },
	0xC2DE, { 0xE3, 0x99, 0xA0 },
	0xC2DF, { 0xE3, 0x99, 0xA4 },
	0xC2E0, { 0xE3, 0x9A, 0x8B },
	0xC2E1, { 0xF0, 0xA1, 0x96, 0xB6 },
	0xC2E2, { 0xF0, 0xA1, 0x99, 0xAE },
	0xC2E3, { 0xF0, 0xA1, 0x99, 0xAC },
	0xC2E4, { 0xF0, 0xA1, 0x9A, 0x81 },
	0xC2E5, { 0xF0, 0xA1, 0xA1, 0x82 },
	0xC2E6, { 0xE3, 0x9C, 0x99 },
	0xC2E7, { 0xE3, 0x9C, 0x96 },
	0xC2E8, { 0xE3, 0x9C, 0x98 },
	0xC2E9, { 0xE3, 0x9C, 0xA2 },
	0xC2EA, { 0xF0, 0xA1, 0xA0, 0x9A },
	0xC2EB, { 0xE3, 0x9C, 0x9D },
	0xC2EC, { 0xE3, 0x9C, 0x97 },
	0xC2ED, { 0xE3, 0x9C, 0x9E },
	0xC2EE, { 0xF0, 0xA1, 0xA0, 0xA7 },
	0xC2EF, { 0xF0, 0xA1, 0xA0, 0xA5 },
	0xC2F0, { 0xF0, 0xA1, 0xA0, 0x97 },
	0xC2F1, { 0xF0, 0xA1, 0xA0, 0x9C },
	0xC2F2, { 0xF0, 0xA1, 0xA0, 0xBD },
	0xC2F3, { 0xF0, 0xA1, 0xA0, 0xA0 },
	0xC2F4, { 0xE3, 0x9D, 0xA9 },
	0xC2F5, { 0xE3, 0x9D, 0xAA },
	0xC2F6, { 0xF0, 0xA1, 0xAA, 0x81 },
	0xC2F7, { 0xE3, 0x9D, 0xAC },
	0xC2F8, { 0xE3, 0x9D, 0xBA },
	0xC2F9, { 0xE3, 0x9E, 0x8A },
	0xC2FA, { 0xF0, 0xA1, 0xB0, 0x89 },
	0xC2FB, { 0xF0, 0xA1, 0xB3, 0x86 },
	0xC2FC, { 0xF0, 0xA1, 0xB3, 0x84 },
	0xC2FD, { 0xE3, 0x9E, 0x9C },
	0xC2FE, { 0xF0, 0xA1, 0xB3, 0x85 },
	0xC3A1, { 0xE3, 0x9F, 0xBD },
	0xC3A2, { 0xE3, 0x9F, 0xB9 },
	0xC3A3, { 0xF0, 0xA1, 0xBB, 0xAF },
	0xC3A4, { 0xE3, 0x9F, 0xBF },
	0xC3A5, { 0xF0, 0xA1, 0xBB, 0x9F },
	0xC3A6, { 0xF0, 0xA1, 0xBB, 0x9E },
	0xC3A7, { 0xF0, 0xA1, 0xBB, 0xAE },
	0xC3A8, { 0xF0, 0xA1, 0xBB, 0xB5 },
	0xC3A9, { 0xF0, 0xA1, 0xBB, 0xAC },
	0xC3AA, { 0xE3, 0x9F, 0xBC },
	0xC3AB, { 0xF0, 0xA1, 0xBB, 0x9D },
	0xC3AC, { 0xE5, 0xB6, 0x85 },
	0xC3AD, { 0xE3, 0x9F, 0xBB },
	0xC3AE, { 0xE3, 0xA0, 0x82 },
	0xC3AF, { 0xE3, 0xA1, 0x9F },
	0xC3B0, { 0xE5, 0xB9, 0x96 },
	0xC3B1, { 0xE3, 0xA1, 0x9E },
	0xC3B2, { 0xE3, 0xA1, 0x9D },
	0xC3B3, { 0xE3, 0xA1, 0x9C },
	0xC3B4, { 0xF0, 0xA2, 0x84, 0xA2 },
	0xC3B5, { 0xE5, 0xB9, 0x91 },
	0xC3B6, { 0xE3, 0xA2, 0x92 },
	0xC3B7, { 0xF0, 0xA2, 0x8A, 0x97 },
	0xC3B8, { 0xF0, 0xA2, 0x8A, 0x95 },
	0xC3B9, { 0xE3, 0xA2, 0x94 },
	0xC3BA, { 0xE3, 0xA2, 0x95 },
	0xC3BB, { 0xE3, 0xA3, 0x91 },
	0xC3BC, { 0xF0, 0xA2, 0x92, 0xA9 },
	0xC3BD, { 0xE3, 0xA3, 0xB1 },
	0xC3BE, { 0xF0, 0xA2, 0x95, 0x93 },
	0xC3BF, { 0xE5, 0xBE, 0xB1 },
	0xC3C0, { 0xF0, 0xA2, 0x95, 0x96 },
	0xC3C1, { 0xF0, 0xA2, 0x95, 0x95 },
	0xC3C2, { 0xE3, 0xA5, 0xB7 },
	0xC3C3, { 0xE3, 0xA5, 0xAF },
	0xC3C4, { 0xF0, 0xA2, 0x9F, 0xA3 },
	0xC3C5, { 0xF0, 0xA2, 0x9F, 0xA2 },
	0xC3C6, { 0xE3, 0xA6, 0x87 },
	0xC3C7, { 0xE3, 0xA5, 0xBD },
	0xC3C8, { 0xE3, 0xA5, 0xBC },
	0xC3C9, { 0xE3, 0xA5, 0xBE },
	0xC3CA, { 0xE3, 0xA6, 0x85 },
	0xC3CB, { 0xE3, 0xA6, 0x8B },
	0xC3CC, { 0xE3, 0xA6, 0x86 },
	0xC3CD, { 0xE3, 0xA6, 0x80 },
	0xC3CF, { 0xF0, 0xA2, 0x9E, 0xA9 },
	0xC3D0, { 0xE3, 0xA5, 0xB8 },
	0xC3D1, { 0xF0, 0xAF, 0xA2, 0xAB },
	0xC3D2, { 0xF0, 0xA2, 0xA0, 0xB3 },
	0xC3D3, { 0xF0, 0xA2, 0xA0, 0x8A },
	0xC3D4, { 0xE3, 0xA6, 0xBA },
	0xC3D5, { 0xF0, 0xA2, 0xA9, 0x99 },
	0xC3D6, { 0xE3, 0xA8, 0xB3 },
	0xC3D7, { 0xF0, 0xA2, 0xB2, 0xBC },
	0xC3D8, { 0xE3, 0xA8, 0xAD },
	0xC3D9, { 0xF0, 0xA2, 0xB3, 0x84 },
	0xC3DA, { 0xF0, 0xA2, 0xB3, 0x87 },
	0xC3DB, { 0xF0, 0xA2, 0xB3, 0x86 },
	0xC3DC, { 0xE3, 0xA8, 0xB7 },
	0xC3DD, { 0xE6, 0x91, 0x9A },
	0xC3DE, { 0xE6, 0x91, 0xA3 },
	0xC3DF, { 0xF0, 0xA2, 0xB2, 0xB8 },
	0xC3E0, { 0xF0, 0xA2, 0xB3, 0x9A },
	0xC3E1, { 0xE3, 0xA8, 0xAE },
	0xC3E2, { 0xF0, 0xA2, 0xB2, 0xB7 },
	0xC3E3, { 0xF0, 0xA2, 0xB3, 0x80 },
	0xC3E4, { 0xE3, 0xA8, 0xBD },
	0xC3E5, { 0xF0, 0xA2, 0xB3, 0x8D },
	0xC3E6, { 0xE3, 0xAA, 0xA0 },
	0xC3E7, { 0xF0, 0xA2, 0xBE, 0xBC },
	0xC3E8, { 0xF0, 0xA2, 0xBE, 0xAB },
	0xC3E9, { 0xE3, 0xAA, 0xA3 },
	0xC3EA, { 0xF0, 0xA3, 0x82, 0x86 },
	0xC3EB, { 0xE6, 0x9A, 0x9B },
	0xC3EC, { 0xF0, 0xA3, 0x89, 0x9A },
	0xC3ED, { 0xE6, 0x9A, 0xA3 },
	0xC3EE, { 0xE3, 0xAC, 0x8E },
	0xC3EF, { 0xE6, 0x9A, 0x9E },
	0xC3F0, { 0xF0, 0xA3, 0x8D, 0x83 },
	0xC3F1, { 0xE3, 0xAE, 0xB6 },
	0xC3F2, { 0xF0, 0xA3, 0x96, 0xAC },
	0xC3F3, { 0xE3, 0xAE, 0xAB },
	0xC3F4, { 0xE3, 0xAE, 0xAD },
	0xC3F5, { 0xE3, 0xAE, 0xA6 },
	0xC3F6, { 0xF0, 0xA3, 0x96, 0xBE },
	0xC3F7, { 0xE6, 0xA6, 0xB8 },
	0xC3F8, { 0xE3, 0xAE, 0xAA },
	0xC3F9, { 0xE6, 0xA6, 0xBA },
	0xC3FA, { 0xE3, 0xAE, 0xB1 },
	0xC3FB, { 0xF0, 0xA3, 0x96, 0xAB },
	0xC3FC, { 0xE3, 0xAE, 0xA8 },
	0xC3FD, { 0xE3, 0xAE, 0xAF },
	0xC3FE, { 0xE3, 0xAE, 0xB0 },
	0xC4A1, { 0xE3, 0xAE, 0xA7 },
	0xC4A2, { 0xE3, 0xAE, 0xB2 },
	0xC4A3, { 0xE3, 0xAE, 0x9D },
	0xC4A4, { 0xE3, 0xAE, 0xA5 },
	0xC4A5, { 0xE3, 0xAE, 0xB5 },
	0xC4A6, { 0xF0, 0xA1, 0xAC, 0xBE },
	0xC4A7, { 0xE6, 0xA7, 0x87 },
	0xC4A8, { 0xE6, 0xA7, 0x97 },
	0xC4A9, { 0xF0, 0xA3, 0xA3, 0xB9 },
	0xC4AA, { 0xE3, 0xB1, 0x81 },
	0xC4AB, { 0xF0, 0xA3, 0xA3, 0xB3 },
	0xC4AC, { 0xF0, 0xA3, 0xA3, 0xB7 },
	0xC4AD, { 0xE6, 0xAD, 0xB0 },
	0xC4AE, { 0xF0, 0xA3, 0xA9, 0x85 },
	0xC4AF, { 0xF0, 0xA3, 0xA9, 0x88 },
	0xC4B0, { 0xE3, 0xB1, 0xB2 },
	0xC4B1, { 0xE6, 0xAE, 0x9D },
	0xC4B2, { 0xE3, 0xB1, 0xAF },
	0xC4B3, { 0xE3, 0xB1, 0xB1 },
	0xC4B4, { 0xF0, 0xA3, 0xA9, 0x84 },
	0xC4B5, { 0xE3, 0xB2, 0x85 },
	0xC4B6, { 0xF0, 0xA3, 0xAA, 0xAF },
	0xC4B7, { 0xF0, 0xA3, 0xAA, 0xB1 },
	0xC4B8, { 0xE3, 0xB2, 0xA4 },
	0xC4B9, { 0xE3, 0xB2, 0xA5 },
	0xC4BA, { 0xE3, 0xB2, 0xA6 },
	0xC4BB, { 0xF0, 0xA3, 0xAF, 0x8F },
	0xC4BC, { 0xE3, 0xB2, 0xA8 },
	0xC4BD, { 0xF0, 0xA3, 0xAF, 0x8B },
	0xC4BE, { 0xF0, 0xA3, 0xAF, 0x8D },
	0xC4BF, { 0xE3, 0xB2, 0xA3 },
	0xC4C0, { 0xF0, 0xA3, 0xB1, 0x90 },
	0xC4C1, { 0xF0, 0xA3, 0xBB, 0xAC },
	0xC4C2, { 0xF0, 0xA3, 0xBC, 0x9A },
	0xC4C3, { 0xE6, 0xBC, 0x96 },
	0xC4C4, { 0xE6, 0xBC, 0xA4 },
	0xC4C5, { 0xF0, 0xA3, 0xBB, 0x98 },
	0xC4C6, { 0xE3, 0xB5, 0x83 },
	0xC4C7, { 0xF0, 0xA3, 0xBB, 0x90 },
	0xC4C8, { 0xF0, 0xA3, 0xBB, 0x91 },
	0xC4C9, { 0xE3, 0xB4, 0xBD },
	0xC4CA, { 0xE3, 0xB5, 0x85 },
	0xC4CB, { 0xF0, 0xA3, 0xB9, 0xBB },
	0xC4CC, { 0xF0, 0xA3, 0xBB, 0x92 },
	0xC4CD, { 0xE3, 0xB5, 0x84 },
	0xC4CE, { 0xF0, 0xA3, 0xBB, 0x94 },
	0xC4CF, { 0xF0, 0xA3, 0xBB, 0xA7 },
	0xC4D0, { 0xF0, 0xA3, 0xBB, 0x9F },
	0xC4D1, { 0xF0, 0xA3, 0xBB, 0x9E },
	0xC4D2, { 0xE6, 0xBD, 0x85 },
	0xC4D3, { 0xF0, 0xA3, 0xBB, 0x99 },
	0xC4D4, { 0xF0, 0xA3, 0xBB, 0x8F },
	0xC4D5, { 0xF0, 0xA4, 0x8C, 0x8D },
	0xC4D6, { 0xE3, 0xB7, 0xA3 },
	0xC4D7, { 0xE7, 0x85, 0xB9 },
	0xC4D9, { 0xE3, 0xB7, 0x9F },
	0xC4DA, { 0xE3, 0xB7, 0xA4 },
	0xC4DB, { 0xE7, 0x85, 0xBA },
	0xC4DC, { 0xE3, 0xB7, 0xA5 },
	0xC4DD, { 0xF0, 0xA4, 0x8C, 0xB8 },
	0xC4DE, { 0xE7, 0x89, 0x94 },
	0xC4DF, { 0xE3, 0xB8, 0xA2 },
	0xC4E0, { 0xE3, 0xB9, 0x8A },
	0xC4E1, { 0xF0, 0xA4, 0x9A, 0xA9 },
	0xC4E2, { 0xE3, 0xB9, 0x89 },
	0xC4E3, { 0xE3, 0xB9, 0x84 },
	0xC4E4, { 0xE3, 0xB9, 0x8B },
	0xC4E5, { 0xE3, 0xBA, 0x87 },
	0xC4E6, { 0xE3, 0xBA, 0x89 },
	0xC4E7, { 0xE3, 0xBA, 0x92 },
	0xC4E8, { 0xE3, 0xBA, 0x91 },
	0xC4E9, { 0xE3, 0xBA, 0x90 },
	0xC4EA, { 0xE3, 0xBA, 0x8E },
	0xC4EB, { 0xF0, 0xA4, 0xA0, 0xBE },
	0xC4EC, { 0xF0, 0xA4, 0xA1, 0x86 },
	0xC4ED, { 0xF0, 0xA4, 0xA7, 0xAD },
	0xC4EE, { 0xF0, 0xAF, 0xA4, 0xB0 },
	0xC4EF, { 0xE3, 0xBC, 0x92 },
	0xC4F0, { 0xE3, 0xBC, 0x90 },
	0xC4F1, { 0xE3, 0xBC, 0x91 },
	0xC4F2, { 0xF0, 0xA4, 0xAD, 0xAC },
	0xC4F3, { 0xE3, 0xBC, 0xB2 },
	0xC4F4, { 0xE3, 0xBC, 0xB4 },
	0xC4F5, { 0xE3, 0xBC, 0xB7 },
	0xC4F6, { 0xE3, 0xBC, 0xB3 },
	0xC4F7, { 0xE3, 0xBC, 0xB6 },
	0xC4F8, { 0xE3, 0xBC, 0xB5 },
	0xC4F9, { 0xE3, 0xBD, 0xA5 },
	0xC4FA, { 0xF0, 0xA4, 0xB2, 0xAC },
	0xC4FB, { 0xE7, 0x95, 0xBC },
	0xC4FC, { 0xE7, 0x95, 0xBB },
	0xC4FD, { 0xF0, 0xA4, 0xB7, 0x89 },
	0xC4FE, { 0xE7, 0x98, 0x92 },
	0xC5A1, { 0xE3, 0xBE, 0xB0 },
	0xC5A2, { 0xF0, 0xA4, 0xB8, 0x92 },
	0xC5A3, { 0xE3, 0xBE, 0xAF },
	0xC5A4, { 0xE3, 0xBE, 0xAA },
	0xC5A5, { 0xF0, 0xA4, 0xB7, 0xBD },
	0xC5A6, { 0xF0, 0xA4, 0xB8, 0x81 },
	0xC5A7, { 0xF0, 0xA4, 0xB8, 0x91 },
	0xC5A8, { 0xE3, 0xBE, 0xAB },
	0xC5A9, { 0xF0, 0xA4, 0xBA, 0x89 },
	0xC5AA, { 0xF0, 0xA4, 0xB8, 0x85 },
	0xC5AB, { 0xF0, 0xA4, 0xB7, 0xBE },
	0xC5AC, { 0xF0, 0xA4, 0xB8, 0x8B },
	0xC5AD, { 0xF0, 0xA4, 0xB8, 0xA0 },
	0xC5AE, { 0xF0, 0xA4, 0xB8, 0x84 },
	0xC5AF, { 0xF0, 0xA4, 0xBE, 0x88 },
	0xC5B0, { 0xE3, 0xBF, 0xB3 },
	0xC5B1, { 0xF0, 0xA5, 0x80, 0x82 },
	0xC5B2, { 0xE3, 0xBF, 0xB4 },
	0xC5B3, { 0xF0, 0xA5, 0x80, 0x83 },
	0xC5B4, { 0xE7, 0x9A, 0xB6 },
	0xC5B5, { 0xE7, 0x9B, 0xA0 },
	0xC5B6, { 0xE4, 0x80, 0x88 },
	0xC5B7, { 0xE4, 0x81, 0x8E },
	0xC5B8, { 0xE4, 0x81, 0x95 },
	0xC5B9, { 0xE4, 0x81, 0x8B },
	0xC5BA, { 0xF0, 0xA5, 0x88, 0xA9 },
	0xC5BB, { 0xF0, 0xA5, 0x88, 0xBB },
	0xC5BC, { 0xE4, 0x81, 0x8D },
	0xC5BD, { 0xE7, 0x9D, 0xB3 },
	0xC5BE, { 0xF0, 0xA5, 0x88, 0x86 },
	0xC5BF, { 0xE4, 0x81, 0x92 },
	0xC5C0, { 0xE7, 0x9D, 0xB2 },
	0xC5C1, { 0xE4, 0x81, 0x8C },
	0xC5C2, { 0xE7, 0x9D, 0xB0 },
	0xC5C3, { 0xE4, 0x81, 0x90 },
	0xC5C4, { 0xE4, 0x81, 0x93 },
	0xC5C5, { 0xF0, 0xA5, 0x88, 0x83 },
	0xC5C6, { 0xE4, 0x81, 0x91 },
	0xC5C7, { 0xF0, 0xA5, 0x8D, 0xB8 },
	0xC5C8, { 0xF0, 0xA5, 0x8D, 0xB9 },
	0xC5C9, { 0xF0, 0xA5, 0x8D, 0xBD },
	0xC5CA, { 0xE4, 0x82, 0x89 },
	0xC5CB, { 0xF0, 0xA5, 0x8D, 0xBF },
	0xC5CC, { 0xE4, 0x82, 0x95 },
	0xC5CD, { 0xE4, 0x83, 0x8C },
	0xC5CE, { 0xE4, 0x83, 0x88 },
	0xC5CF, { 0xE4, 0x83, 0x8E },
	0xC5D0, { 0xF0, 0xA5, 0x94, 0xB2 },
	0xC5D1, { 0xE4, 0x83, 0x8A },
	0xC5D2, { 0xF0, 0xA5, 0x94, 0x80 },
	0xC5D3, { 0xE7, 0xA2, 0x9D },
	0xC5D4, { 0xF0, 0xA5, 0x94, 0xA2 },
	0xC5D5, { 0xE4, 0x83, 0x8D },
	0xC5D6, { 0xF0, 0xA5, 0x9A, 0xA9 },
	0xC5D7, { 0xE4, 0x85, 0x9C },
	0xC5D8, { 0xE4, 0x85, 0xA7 },
	0xC5D9, { 0xE4, 0x85, 0xA9 },
	0xC5DA, { 0xE4, 0x85, 0xA5 },
	0xC5DB, { 0xE4, 0x85, 0xA2 },
	0xC5DC, { 0xF0, 0xA5, 0xA0, 0x84 },
	0xC5DD, { 0xE7, 0xA8, 0xA7 },
	0xC5DE, { 0xE7, 0xA8, 0xB5 },
	0xC5DF, { 0xF0, 0xAF, 0xA5, 0x99 },
	0xC5E0, { 0xE4, 0x86, 0xAA },
	0xC5E1, { 0xF0, 0xA5, 0xA6, 0xB8 },
	0xC5E2, { 0xF0, 0xA5, 0xAA, 0x9B },
	0xC5E3, { 0xE4, 0x87, 0x92 },
	0xC5E4, { 0xE7, 0xAE, 0xA2 },
	0xC5E5, { 0xE4, 0x88, 0x83 },
	0xC5E6, { 0xE4, 0x88, 0x8C },
	0xC5E7, { 0xF0, 0xA5, 0xAE, 0x92 },
	0xC5E8, { 0xE4, 0x88, 0x89 },
	0xC5E9, { 0xE4, 0x88, 0x86 },
	0xC5EA, { 0xE4, 0x88, 0x85 },
	0xC5EB, { 0xE7, 0xAE, 0x89 },
	0xC5EC, { 0xF0, 0xA5, 0xAE, 0x8F },
	0xC5ED, { 0xE4, 0x88, 0x8B },
	0xC5EE, { 0xE4, 0x88, 0x88 },
	0xC5EF, { 0xF0, 0xA5, 0xAE, 0x98 },
	0xC5F0, { 0xE7, 0xAE, 0xA5 },
	0xC5F1, { 0xF0, 0xA5, 0xAE, 0xAE },
	0xC5F2, { 0xE4, 0x8A, 0x8E },
	0xC5F3, { 0xF0, 0xA5, 0xBA, 0x9D },
	0xC5F4, { 0xE7, 0xB2, 0xB6 },
	0xC5F5, { 0xE4, 0x8B, 0xA8 },
	0xC5F6, { 0xF0, 0xA6, 0x81, 0x89 },
	0xC5F7, { 0xF0, 0xA6, 0x81, 0x90 },
	0xC5F8, { 0xF0, 0xA6, 0x81, 0x86 },
	0xC5F9, { 0xE4, 0x8B, 0xAA },
	0xC5FA, { 0xF0, 0xA6, 0x81, 0x8E },
	0xC5FB, { 0xE7, 0xB6, 0xA5 },
	0xC5FC, { 0xE7, 0xB7, 0x83 },
	0xC5FD, { 0xF0, 0xA6, 0x81, 0x95 },
	0xC5FE, { 0xE4, 0x8B, 0xA9 },
	0xC6A1, { 0xE4, 0x8B, 0xAB },
	0xC6A2, { 0xF0, 0xA6, 0x81, 0xA4 },
	0xC6A3, { 0xE4, 0x8B, 0xB0 },
	0xC6A4, { 0xF0, 0xA6, 0x88, 0xB8 },
	0xC6A5, { 0xE4, 0x8D, 0x8B },
	0xC6A6, { 0xE7, 0xBE, 0xAB },
	0xC6A7, { 0xE4, 0x8D, 0xB3 },
	0xC6A8, { 0xE4, 0x8D, 0xB5 },
	0xC6A9, { 0xE4, 0x8E, 0x92 },
	0xC6AA, { 0xE4, 0x8E, 0x91 },
	0xC6AB, { 0xE4, 0x8E, 0x93 },
	0xC6AC, { 0xE8, 0x80, 0xA5 },
	0xC6AD, { 0xE4, 0x8E, 0xA7 },
	0xC6AE, { 0xE4, 0x8E, 0xA6 },
	0xC6AF, { 0xE4, 0x8E, 0xA8 },
	0xC6B0, { 0xE4, 0x8E, 0xAA },
	0xC6B1, { 0xF0, 0xA6, 0x93, 0xBE },
	0xC6B2, { 0xE4, 0x8E, 0xA9 },
	0xC6B3, { 0xE8, 0x81, 0x99 },
	0xC6B4, { 0xE4, 0x8E, 0xBB },
	0xC6B5, { 0xE4, 0x8E, 0xBC },
	0xC6B6, { 0xE4, 0x8E, 0xBA },
	0xC6B7, { 0xE4, 0x8E, 0xBD },
	0xC6B8, { 0xE4, 0x90, 0xA7 },
	0xC6B9, { 0xE8, 0x86, 0x85 },
	0xC6BA, { 0xF0, 0xA6, 0x9E, 0xA6 },
	0xC6BB, { 0xE4, 0x90, 0xA4 },
	0xC6BC, { 0xE4, 0x90, 0x9E },
	0xC6BD, { 0xE4, 0x90, 0x9F },
	0xC6BE, { 0xE4, 0x90, 0x9D },
	0xC6BF, { 0xE4, 0x90, 0xA0 },
	0xC6C0, { 0xE4, 0x90, 0xA3 },
	0xC6C1, { 0xE4, 0x90, 0xA9 },
	0xC6C2, { 0xE4, 0x90, 0xA2 },
	0xC6C3, { 0xF0, 0xA6, 0x9E, 0x9C },
	0xC6C4, { 0xF0, 0xA6, 0x9E, 0x99 },
	0xC6C5, { 0xE4, 0x90, 0x9C },
	0xC6C6, { 0xE8, 0x86, 0x8E },
	0xC6C7, { 0xE4, 0x90, 0xA8 },
	0xC6C8, { 0xF0, 0xA6, 0x9E, 0xB5 },
	0xC6C9, { 0xF0, 0xA6, 0x9E, 0xA3 },
	0xC6CA, { 0xF0, 0xA6, 0x9E, 0xA0 },
	0xC6CB, { 0xF0, 0xA6, 0x9E, 0xA7 },
	0xC6CC, { 0xF0, 0xA6, 0x9E, 0x9B },
	0xC6CD, { 0xF0, 0xA6, 0xA7, 0x9F },
	0xC6CE, { 0xF0, 0xA6, 0xA7, 0xA1 },
	0xC6CF, { 0xE4, 0x91, 0xB1 },
	0xC6D0, { 0xE4, 0x91, 0xB3 },
	0xC6D1, { 0xE4, 0x91, 0xB2 },
	0xC6D2, { 0xF0, 0xA6, 0xA9, 0x8D },
	0xC6D3, { 0xE4, 0x94, 0x82 },
	0xC6D4, { 0xF0, 0xA6, 0xB7, 0xB3 },
	0xC6D5, { 0xF0, 0xA6, 0xB5, 0xAF },
	0xC6D6, { 0xF0, 0xA6, 0xB5, 0xA9 },
	0xC6D7, { 0xE4, 0x93, 0xBE },
	0xC6D8, { 0xE8, 0x92, 0xBE },
	0xC6D9, { 0xF0, 0xA6, 0xB5, 0xAB },
	0xC6DA, { 0xF0, 0xA6, 0xB5, 0xB8 },
	0xC6DB, { 0xF0, 0xA6, 0xB6, 0x87 },
	0xC6DC, { 0xE4, 0x94, 0x88 },
	0xC6DD, { 0xF0, 0xA6, 0xB6, 0x85 },
	0xC6DE, { 0xF0, 0xA6, 0xB6, 0x82 },
	0xC6DF, { 0xF0, 0xA6, 0xB6, 0x90 },
	0xC6E0, { 0xE4, 0x94, 0x87 },
	0xC6E1, { 0xE4, 0x94, 0x84 },
	0xC6E2, { 0xF0, 0xA6, 0xB6, 0x80 },
	0xC6E3, { 0xF0, 0xA6, 0xB5, 0xA7 },
	0xC6E4, { 0xE4, 0x94, 0x80 },
	0xC6E5, { 0xE4, 0x93, 0xBC },
	0xC6E6, { 0xF0, 0xA6, 0xB5, 0xA1 },
	0xC6E7, { 0xE4, 0x95, 0x84 },
	0xC6E8, { 0xF0, 0xA6, 0xB6, 0x93 },
	0xC6E9, { 0xE4, 0x93, 0xB1 },
	0xC6EA, { 0xF0, 0xA6, 0xB7, 0xB2 },
	0xC6EB, { 0xF0, 0xA6, 0xB6, 0x86 },
	0xC6EC, { 0xE8, 0x92, 0xA6 },
	0xC6ED, { 0xE4, 0x94, 0x86 },
	0xC6EE, { 0xF0, 0xA7, 0x87, 0x8D },
	0xC6EF, { 0xF0, 0xA7, 0x87, 0x84 },
	0xC6F0, { 0xE4, 0x97, 0x86 },
	0xC6F1, { 0xE4, 0x97, 0x83 },
	0xC6F2, { 0xE4, 0x97, 0x81 },
	0xC6F3, { 0xE4, 0x97, 0x82 },
	0xC6F4, { 0xF0, 0xA7, 0x8C, 0x8F },
	0xC6F5, { 0xE4, 0x97, 0x84 },
	0xC6F6, { 0xE4, 0x97, 0x87 },
	0xC6F7, { 0xF0, 0xA7, 0x8C, 0x8D },
	0xC6F8, { 0xE4, 0x96, 0xBF },
	0xC6F9, { 0xE4, 0x97, 0x92 },
	0xC6FA, { 0xF0, 0xA7, 0x8D, 0xB3 },
	0xC6FB, { 0xE4, 0x97, 0x8A },
	0xC6FC, { 0xF0, 0xAF, 0xA6, 0xBA },
	0xC6FD, { 0xF0, 0xA7, 0x8C, 0x8A },
	0xC6FE, { 0xE8, 0x9C, 0xAF },
	0xC7A1, { 0xF0, 0xA7, 0x8C, 0x88 },
	0xC7A2, { 0xF0, 0xA7, 0x8C, 0x93 },
	0xC7A3, { 0xE4, 0x98, 0x93 },
	0xC7A4, { 0xF0, 0xA7, 0x97, 0xB8 },
	0xC7A5, { 0xE4, 0x98, 0xB0 },
	0xC7A6, { 0xE4, 0x98, 0xBE },
	0xC7A7, { 0xE4, 0x98, 0xB9 },
	0xC7A8, { 0xF0, 0xA7, 0x9A, 0xAB },
	0xC7A9, { 0xF0, 0xA7, 0x9A, 0xA8 },
	0xC7AA, { 0xE4, 0x98, 0xBC },
	0xC7AB, { 0xE4, 0x98, 0xBF },
	0xC7AC, { 0xF0, 0xA7, 0x9A, 0xA5 },
	0xC7AD, { 0xE4, 0x98, 0xB4 },
	0xC7AE, { 0xE4, 0x98, 0xBD },
	0xC7AF, { 0xF0, 0xA7, 0x9B, 0x83 },
	0xC7B0, { 0xF0, 0xA7, 0x9A, 0xA4 },
	0xC7B1, { 0xE4, 0x98, 0xB8 },
	0xC7B2, { 0xF0, 0xA7, 0x9B, 0x94 },
	0xC7B3, { 0xF0, 0xA7, 0x9A, 0xBA },
	0xC7B4, { 0xF0, 0xA7, 0x9F, 0xB1 },
	0xC7B5, { 0xE8, 0xA6, 0xA0 },
	0xC7B6, { 0xE4, 0x9A, 0x82 },
	0xC7B7, { 0xF0, 0xA7, 0xA0, 0xBF },
	0xC7B8, { 0xE4, 0x9A, 0x83 },
	0xC7B9, { 0xF0, 0xA7, 0xA3, 0xAA },
	0xC7BA, { 0xE4, 0x9A, 0x9B },
	0xC7BB, { 0xF0, 0xA7, 0xA7, 0xB7 },
	0xC7BC, { 0xE4, 0x9B, 0xA0 },
	0xC7BD, { 0xE4, 0x9B, 0x9D },
	0xC7BE, { 0xF0, 0xA7, 0xA7, 0xBA },
	0xC7BF, { 0xF0, 0xA7, 0xA7, 0xB5 },
	0xC7C0, { 0xE4, 0x9B, 0x9E },
	0xC7C1, { 0xF0, 0xA7, 0xA7, 0xBE },
	0xC7C2, { 0xE4, 0x9B, 0xA3 },
	0xC7C3, { 0xE4, 0x9B, 0xA5 },
	0xC7C4, { 0xF0, 0xA7, 0xA8, 0x80 },
	0xC7C5, { 0xE8, 0xAA, 0x97 },
	0xC7C6, { 0xE4, 0x9B, 0xA2 },
	0xC7C7, { 0xF0, 0xA7, 0xA8, 0x82 },
	0xC7C8, { 0xF0, 0xA7, 0xA7, 0xBB },
	0xC7C9, { 0xF0, 0xA7, 0xA8, 0x87 },
	0xC7CA, { 0xE4, 0x9B, 0x9F },
	0xC7CB, { 0xF0, 0xA7, 0xA8, 0x9A },
	0xC7CC, { 0xE4, 0x9C, 0xAE },
	0xC7CD, { 0xF0, 0xA7, 0xAE, 0xB8 },
	0xC7CE, { 0xE4, 0x9C, 0xB7 },
	0xC7CF, { 0xE4, 0x9C, 0xB8 },
	0xC7D0, { 0xF0, 0xA7, 0xAF, 0xA9 },
	0xC7D1, { 0xF0, 0xA7, 0xAF, 0xAB },
	0xC7D2, { 0xF0, 0xA7, 0xB1, 0x90 },
	0xC7D3, { 0xF0, 0xA7, 0xB1, 0x8F },
	0xC7D4, { 0xE8, 0xB2, 0x8B },
	0xC7D5, { 0xF0, 0xA7, 0xB6, 0x86 },
	0xC7D6, { 0xE3, 0x95, 0xA2 },
	0xC7D7, { 0xF0, 0xA7, 0xB6, 0x8E },
	0xC7D8, { 0xE4, 0x9E, 0x94 },
	0xC7D9, { 0xE4, 0x9E, 0x93 },
	0xC7DA, { 0xE4, 0x9E, 0xAB },
	0xC7DB, { 0xE4, 0x9E, 0xAD },
	0xC7DC, { 0xF0, 0xA7, 0xBB, 0xB0 },
	0xC7DD, { 0xF0, 0xA7, 0xBB, 0xBB },
	0xC7DE, { 0xE4, 0x9F, 0xB5 },
	0xC7DF, { 0xE4, 0x9F, 0xB7 },
	0xC7E0, { 0xF0, 0xA8, 0x81, 0x82 },
	0xC7E1, { 0xE4, 0x9F, 0xB6 },
	0xC7E2, { 0xE4, 0x9F, 0xB8 },
	0xC7E3, { 0xF0, 0xA8, 0x82, 0x85 },
	0xC7E4, { 0xE4, 0x9F, 0xBB },
	0xC7E5, { 0xE4, 0x9F, 0xB9 },
	0xC7E6, { 0xE4, 0xA1, 0x98 },
	0xC7E7, { 0xE4, 0xA1, 0x9A },
	0xC7E8, { 0xF0, 0xA8, 0x8C, 0x85 },
	0xC7E9, { 0xE4, 0xA1, 0x99 },
	0xC7EA, { 0xE8, 0xBC, 0x8F },
	0xC7EB, { 0xE4, 0xA2, 0x85 },
	0xC7EC, { 0xE4, 0xA2, 0xA4 },
	0xC7ED, { 0xE4, 0xA3, 0x98 },
	0xC7EE, { 0xE4, 0xA3, 0x99 },
	0xC7EF, { 0xF0, 0xA8, 0x9D, 0x8B },
	0xC7F0, { 0xE4, 0xA3, 0x9D },
	0xC7F1, { 0xE4, 0xA3, 0x88 },
	0xC7F2, { 0xF0, 0xA8, 0x9D, 0xA3 },
	0xC7F3, { 0xE4, 0xA3, 0xBA },
	0xC7F4, { 0xE4, 0xA3, 0xBB },
	0xC7F5, { 0xE9, 0x89, 0xB5 },
	0xC7F6, { 0xE4, 0xA4, 0xA7 },
	0xC7F7, { 0xE9, 0x8A, 0x9F },
	0xC7F8, { 0xE4, 0xA4, 0xAA },
	0xC7F9, { 0xE4, 0xA4, 0xA5 },
	0xC7FA, { 0xF0, 0xA8, 0xA6, 0x99 },
	0xC7FB, { 0xE4, 0xA4, 0xA8 },
	0xC7FC, { 0xF0, 0xA8, 0xB2, 0x81 },
	0xC7FD, { 0xF0, 0xA8, 0xB4, 0x97 },
	0xC7FE, { 0xF0, 0xA8, 0xB4, 0x90 },
	0xC8A1, { 0xF0, 0xA8, 0xB4, 0x92 },
	0xC8A2, { 0xE9, 0x96, 0xA6 },
	0xC8A3, { 0xE4, 0xA6, 0x95 },
	0xC8A4, { 0xE9, 0x9A, 0x9A },
	0xC8A5, { 0xF0, 0xA8, 0xBB, 0xBA },
	0xC8A6, { 0xF0, 0xA8, 0xBB, 0xB3 },
	0xC8A7, { 0xF0, 0xA8, 0xBB, 0xB2 },
	0xC8A8, { 0xF0, 0xA8, 0xBB, 0xB5 },
	0xC8A9, { 0xF0, 0xA8, 0xBB, 0xB6 },
	0xC8AA, { 0xF0, 0xA8, 0xBE, 0xBB },
	0xC8AB, { 0xF0, 0xA8, 0xBF, 0x82 },
	0xC8AC, { 0xF0, 0xA9, 0x82, 0xA7 },
	0xC8AD, { 0xE4, 0xA8, 0x8F },
	0xC8AE, { 0xE4, 0xA8, 0x91 },
	0xC8AF, { 0xF0, 0xA9, 0x82, 0xA8 },
	0xC8B0, { 0xF0, 0xA9, 0x82, 0xA3 },
	0xC8B1, { 0xE4, 0xA8, 0x90 },
	0xC8B2, { 0xF0, 0xA9, 0x82, 0xAA },
	0xC8B3, { 0xE4, 0xA8, 0x95 },
	0xC8B4, { 0xE4, 0xA8, 0x93 },
	0xC8B5, { 0xE9, 0x9D, 0x97 },
	0xC8B6, { 0xF0, 0xA9, 0x87, 0x9C },
	0xC8B7, { 0xE4, 0xA9, 0x87 },
	0xC8B8, { 0xE4, 0xA9, 0x86 },
	0xC8B9, { 0xF0, 0xA9, 0x88, 0x8F },
	0xC8BA, { 0xE4, 0xA9, 0x99 },
	0xC8BB, { 0xE4, 0xA9, 0x9B },
	0xC8BC, { 0xF0, 0xA9, 0x89, 0xB9 },
	0xC8BD, { 0xE4, 0xA9, 0x9E },
	0xC8BE, { 0xF0, 0xA9, 0x89, 0xBF },
	0xC8BF, { 0xF0, 0xA9, 0x8A, 0x85 },
	0xC8C0, { 0xE4, 0xA9, 0x9A },
	0xC8C1, { 0xE4, 0xAA, 0x91 },
	0xC8C2, { 0xE4, 0xAA, 0x92 },
	0xC8C3, { 0xE4, 0xAA, 0x90 },
	0xC8C4, { 0xE4, 0xAA, 0x93 },
	0xC8C5, { 0xF0, 0xA9, 0x90, 0x9B },
	0xC8C6, { 0xE9, 0x9F, 0xB7 },
	0xC8C7, { 0xE4, 0xAA, 0xBE },
	0xC8C8, { 0xF0, 0xA9, 0x91, 0xB7 },
	0xC8C9, { 0xF0, 0xA9, 0x91, 0xB6 },
	0xC8CA, { 0xF0, 0xA9, 0x92, 0x98 },
	0xC8CB, { 0xE4, 0xAA, 0xBC },
	0xC8CC, { 0xE4, 0xAA, 0xBB },
	0xC8CD, { 0xE4, 0xAA, 0xB7 },
	0xC8CE, { 0xE4, 0xAA, 0xB9 },
	0xC8CF, { 0xF0, 0xA9, 0x91, 0xBA },
	0xC8D0, { 0xE4, 0xAC, 0x81 },
	0xC8D1, { 0xE4, 0xAB, 0xBE },
	0xC8D2, { 0xF0, 0xA9, 0x96, 0xBC },
	0xC8D3, { 0xF0, 0xA9, 0x96, 0xBA },
	0xC8D4, { 0xE4, 0xAC, 0x82 },
	0xC8D5, { 0xF0, 0xA9, 0x96, 0xB6 },
	0xC8D6, { 0xE4, 0xAB, 0xBF },
	0xC8D7, { 0xE9, 0xA2, 0xB0 },
	0xC8D8, { 0xF0, 0xA9, 0x96, 0xB4 },
	0xC8D9, { 0xE4, 0xAC, 0x80 },
	0xC8DA, { 0xF0, 0xA9, 0x9B, 0x8F },
	0xC8DB, { 0xE4, 0xAC, 0xB7 },
	0xC8DC, { 0xE4, 0xAC, 0xBA },
	0xC8DD, { 0xE4, 0xAD, 0xAF },
	0xC8DE, { 0xE4, 0xAD, 0xB7 },
	0xC8DF, { 0xE4, 0xAD, 0xB9 },
	0xC8E0, { 0xE9, 0xA7, 0x86 },
	0xC8E1, { 0xF0, 0xA9, 0xA1, 0xBB },
	0xC8E2, { 0xE4, 0xAF, 0x88 },
	0xC8E3, { 0xF0, 0xA9, 0xA8, 0x9C },
	0xC8E4, { 0xF0, 0xA9, 0xA8, 0xA1 },
	0xC8E5, { 0xF0, 0xA9, 0xA8, 0x9D },
	0xC8E6, { 0xF0, 0xA9, 0xAB, 0x80 },
	0xC8E7, { 0xE4, 0xAF, 0xB2 },
	0xC8E8, { 0xF0, 0xA9, 0xAB, 0xBF },
	0xC8E9, { 0xE4, 0xAF, 0xB1 },
	0xC8EA, { 0xE4, 0xAF, 0xB0 },
	0xC8EB, { 0xE9, 0xAD, 0xA2 },
	0xC8EC, { 0xF0, 0xA9, 0xB5, 0x96 },
	0xC8ED, { 0xE4, 0xB0, 0xB4 },
	0xC8EE, { 0xF0, 0xA9, 0xBE, 0xA1 },
	0xC8EF, { 0xF0, 0xA9, 0xBE, 0xA2 },
	0xC8F0, { 0xF0, 0xA9, 0xBE, 0xA6 },
	0xC8F1, { 0xF0, 0xAA, 0x89, 0x96 },
	0xC8F2, { 0xF0, 0xAA, 0x89, 0x97 },
	0xC8F3, { 0xE4, 0xB4, 0xAC },
	0xC8F4, { 0xE4, 0xB4, 0xAD },
	0xC8F5, { 0xF0, 0xAA, 0x8C, 0x81 },
	0xC8F6, { 0xF0, 0xAA, 0x8F, 0xAD },
	0xC8F7, { 0xF0, 0xAF, 0xA8, 0x9C },
	0xC8F8, { 0xF0, 0xAA, 0x97, 0xB2 },
	0xC8F9, { 0xE5, 0x83, 0xBA },
	0xC8FA, { 0xF0, 0xA0, 0x8E, 0xB8 },
	0xC8FB, { 0xE3, 0x92, 0x91 },
	0xC8FC, { 0xF0, 0xA0, 0x8F, 0x80 },
	0xC8FD, { 0xE3, 0x92, 0x94 },
	0xC8FE, { 0xF0, 0xA0, 0x8E, 0xB7 },
	0xC9A1, { 0xF0, 0xA0, 0x8F, 0xA1 },
	0xC9A2, { 0xE3, 0x93, 0x84 },
	0xC9A3, { 0xE3, 0x94, 0x8A },
	0xC9A4, { 0xF0, 0xA0, 0x9F, 0xA8 },
	0xC9A5, { 0xE5, 0x8A, 0x85 },
	0xC9A6, { 0xF0, 0xA0, 0xA2, 0xB2 },
	0xC9A7, { 0xE3, 0x95, 0x92 },
	0xC9A8, { 0xF0, 0xA0, 0xAA, 0xAE },
	0xC9A9, { 0xE3, 0x95, 0x99 },
	0xC9AA, { 0xE3, 0x99, 0xAF },
	0xC9AB, { 0xF0, 0xA0, 0xBD, 0xBE },
	0xC9AC, { 0xE3, 0x97, 0xB2 },
	0xC9AD, { 0xE3, 0x97, 0xB4 },
	0xC9AE, { 0xE5, 0x99, 0x83 },
	0xC9AF, { 0xF0, 0xA0, 0xBD, 0xB6 },
	0xC9B0, { 0xE3, 0x97, 0xB1 },
	0xC9B1, { 0xE5, 0x98, 0xBC },
	0xC9B2, { 0xF0, 0xA0, 0xBE, 0x96 },
	0xC9B3, { 0xE3, 0x99, 0xAA },
	0xC9B4, { 0xF0, 0xA1, 0x90, 0xA0 },
	0xC9B5, { 0xF0, 0xA1, 0x90, 0xA1 },
	0xC9B6, { 0xF0, 0xA1, 0x90, 0xA3 },
	0xC9B7, { 0xF0, 0xA1, 0x90, 0xA9 },
	0xC9B8, { 0xF0, 0xA1, 0x99, 0xB7 },
	0xC9B9, { 0xF0, 0xA1, 0xA1, 0x91 },
	0xC9BA, { 0xE3, 0x9C, 0xA4 },
	0xC9BB, { 0xF0, 0xA1, 0xA1, 0x96 },
	0xC9BC, { 0xE3, 0x9C, 0xA3 },
	0xC9BD, { 0xF0, 0xA1, 0xA2, 0x88 },
	0xC9BE, { 0xF0, 0xA1, 0xA1, 0x99 },
	0xC9BF, { 0xF0, 0xA1, 0xA1, 0x95 },
	0xC9C0, { 0xE3, 0x9C, 0xA7 },
	0xC9C1, { 0xF0, 0xA1, 0xA6, 0x97 },
	0xC9C2, { 0xF0, 0xA1, 0xA6, 0x98 },
	0xC9C3, { 0xE3, 0x9D, 0xAD },
	0xC9C4, { 0xE5, 0xAF, 0xAD },
	0xC9C5, { 0xE3, 0x9D, 0xAE },
	0xC9C6, { 0xE3, 0x9D, 0xAF },
	0xC9C7, { 0xF0, 0xA1, 0xAA, 0xA1 },
	0xC9C8, { 0xF0, 0xA1, 0xAA, 0xA3 },
	0xC9C9, { 0xE5, 0xB0, 0xB5 },
	0xC9CA, { 0xE3, 0x9E, 0x9F },
	0xC9CB, { 0xE3, 0xA0, 0x8A },
	0xC9CC, { 0xE3, 0xA0, 0x86 },
	0xC9CD, { 0xE3, 0xA0, 0x8E },
	0xC9CE, { 0xF0, 0xA1, 0xBC, 0x8A },
	0xC9CF, { 0xE3, 0xA0, 0x8D },
	0xC9D0, { 0xE3, 0xA0, 0x85 },
	0xC9D1, { 0xF0, 0xA1, 0xBC, 0xBD },
	0xC9D2, { 0xF0, 0xA1, 0xBC, 0x8C },
	0xC9D3, { 0xE3, 0xA0, 0x8B },
	0xC9D4, { 0xE3, 0xA0, 0x90 },
	0xC9D5, { 0xE3, 0xA0, 0xAE },
	0xC9D6, { 0xF0, 0xA2, 0x84, 0xBD },
	0xC9D7, { 0xF0, 0xA2, 0x84, 0xB9 },
	0xC9D8, { 0xF0, 0xA2, 0x8A, 0xB0 },
	0xC9D9, { 0xF0, 0xA2, 0x8A, 0xB2 },
	0xC9DA, { 0xF0, 0xA2, 0x8A, 0xAE },
	0xC9DB, { 0xE3, 0xA2, 0x96 },
	0xC9DC, { 0xE3, 0xA2, 0x97 },
	0xC9DD, { 0xE3, 0xA3, 0x84 },
	0xC9DE, { 0xE5, 0xBD, 0x87 },
	0xC9DF, { 0xE3, 0xA3, 0x85 },
	0xC9E0, { 0xF0, 0xA2, 0x90, 0xA0 },
	0xC9E1, { 0xE3, 0xA3, 0x92 },
	0xC9E2, { 0xF0, 0xA2, 0x95, 0xAE },
	0xC9E3, { 0xF0, 0xA2, 0x95, 0xAD },
	0xC9E4, { 0xF0, 0xA2, 0x95, 0xAA },
	0xC9E5, { 0xE3, 0xA6, 0x81 },
	0xC9E6, { 0xF0, 0xA2, 0xA0, 0xB2 },
	0xC9E7, { 0xE3, 0xA6, 0x8E },
	0xC9E8, { 0xE3, 0xA6, 0x90 },
	0xC9E9, { 0xE3, 0xA6, 0x8F },
	0xC9EA, { 0xF0, 0xA2, 0xA0, 0xB9 },
	0xC9EB, { 0xE3, 0xA6, 0x91 },
	0xC9EC, { 0xE3, 0xA6, 0x95 },
	0xC9ED, { 0xE3, 0xA6, 0x93 },
	0xC9EE, { 0xF0, 0xA2, 0x9E, 0xA3 },
	0xC9EF, { 0xE6, 0x85, 0xAD },
	0xC9F0, { 0xF0, 0xA2, 0xA1, 0xBF },
	0xC9F1, { 0xF0, 0xA2, 0xA0, 0xB5 },
	0xC9F2, { 0xF0, 0xA2, 0xA0, 0xBD },
	0xC9F3, { 0xF0, 0xA2, 0xA7, 0xB4 },
	0xC9F4, { 0xF0, 0xA2, 0xA7, 0xB5 },
	0xC9F5, { 0xE3, 0xA8, 0xBB },
	0xC9F6, { 0xE3, 0xA9, 0x88 },
	0xC9F7, { 0xF0, 0xA2, 0xB5, 0x88 },
	0xC9F8, { 0xF0, 0xA2, 0xB4, 0xA8 },
	0xC9F9, { 0xE3, 0xA9, 0x86 },
	0xC9FA, { 0xE3, 0xA9, 0x87 },
	0xC9FB, { 0xF0, 0xA2, 0xB4, 0xA7 },
	0xC9FC, { 0xF0, 0xA2, 0xB4, 0xB2 },
	0xC9FD, { 0xF0, 0xA2, 0xB4, 0xAC },
	0xC9FE, { 0xE3, 0xA9, 0x8C },
	0xCAA1, { 0xF0, 0xA2, 0xB4, 0xAE },
	0xCAA2, { 0xE3, 0xA9, 0x8A },
	0xCAA3, { 0xE3, 0xA9, 0x90 },
	0xCAA4, { 0xE3, 0xA9, 0x83 },
	0xCAA5, { 0xF0, 0xA2, 0xB4, 0xA3 },
	0xCAA6, { 0xF0, 0xA2, 0xB4, 0xB1 },
	0xCAA7, { 0xF0, 0xAF, 0xA3, 0x85 },
	0xCAA8, { 0xE3, 0xA9, 0x89 },
	0xCAA9, { 0xE3, 0xAA, 0xA6 },
	0xCAAA, { 0xE3, 0xAA, 0xA5 },
	0xCAAB, { 0xE3, 0xAA, 0xA4 },
	0xCAAC, { 0xF0, 0xA2, 0xBF, 0x89 },
	0xCAAD, { 0xF0, 0xA3, 0x82, 0x89 },
	0xCAAE, { 0xE3, 0xAA, 0xB9 },
	0xCAAF, { 0xF0, 0xA3, 0x82, 0xBB },
	0xCAB0, { 0xE3, 0xAB, 0x8E },
	0xCAB1, { 0xE3, 0xAB, 0x8F },
	0xCAB2, { 0xE3, 0xAC, 0x93 },
	0xCAB3, { 0xF0, 0xA3, 0x8E, 0x97 },
	0xCAB4, { 0xF0, 0xA3, 0x8E, 0x93 },
	0xCAB5, { 0xF0, 0xA3, 0x98, 0xA8 },
	0xCAB6, { 0xE3, 0xAF, 0x86 },
	0xCAB7, { 0xE3, 0xAF, 0x85 },
	0xCAB8, { 0xE3, 0xAF, 0x8A },
	0xCAB9, { 0xE3, 0xAF, 0x99 },
	0xCABA, { 0xE3, 0xAF, 0x81 },
	0xCABB, { 0xF0, 0xA3, 0x98, 0x98 },
	0xCABC, { 0xF0, 0xA3, 0x98, 0xBB },
	0xCABD, { 0xE6, 0xA7, 0xB5 },
	0xCABE, { 0xF0, 0xA3, 0x98, 0xA7 },
	0xCABF, { 0xF0, 0xA3, 0x98, 0xA4 },
	0xCAC0, { 0xF0, 0xA3, 0x98, 0x9B },
	0xCAC1, { 0xF0, 0xA3, 0x98, 0xB1 },
	0xCAC2, { 0xE3, 0xAF, 0x8B },
	0xCAC3, { 0xF0, 0xA3, 0x98, 0xA6 },
	0xCAC4, { 0xF0, 0xA3, 0x9A, 0xA3 },
	0xCAC5, { 0xF0, 0xA3, 0x98, 0xBF },
	0xCAC6, { 0xF0, 0xA3, 0x98, 0xA2 },
	0xCAC7, { 0xF0, 0xA3, 0x98, 0x99 },
	0xCAC8, { 0xE6, 0xA8, 0x83 },
	0xCAC9, { 0xF0, 0xA3, 0x99, 0x81 },
	0xCACA, { 0xF0, 0xA3, 0x98, 0xAB },
	0xCACB, { 0xE6, 0xA9, 0xA5 },
	0xCACC, { 0xE3, 0xB1, 0x82 },
	0xCACD, { 0xF0, 0xA3, 0xA4, 0x8C },
	0xCACE, { 0xE6, 0xAD, 0xB5 },
	0xCACF, { 0xE3, 0xB1, 0xB4 },
	0xCAD0, { 0xE3, 0xB1, 0xB3 },
	0xCAD1, { 0xF0, 0xA3, 0xA9, 0x8E },
	0xCAD2, { 0xF0, 0xA3, 0xAA, 0xB9 },
	0xCAD3, { 0xF0, 0xA3, 0xAB, 0xBA },
	0xCAD4, { 0xF0, 0xA3, 0xAF, 0xA9 },
	0xCAD5, { 0xF0, 0xA3, 0xAF, 0xA8 },
	0xCAD6, { 0xF0, 0xA3, 0xAF, 0xA4 },
	0xCAD7, { 0xE6, 0xBE, 0x8A },
	0xCAD8, { 0xE6, 0xBD, 0x96 },
	0xCAD9, { 0xE3, 0xB5, 0x92 },
	0xCADA, { 0xF0, 0xA3, 0xBD, 0x9F },
	0xCADB, { 0xF0, 0xA3, 0xBD, 0x9D },
	0xCADC, { 0xF0, 0xA3, 0xBD, 0x92 },
	0xCADD, { 0xE3, 0xB5, 0x90 },
	0xCADE, { 0xF0, 0xA3, 0xBD, 0xB4 },
	0xCADF, { 0xE3, 0xB5, 0x8B },
	0xCAE0, { 0xF0, 0xA3, 0xBD, 0x86 },
	0xCAE1, { 0xE3, 0xB5, 0x8C },
	0xCAE2, { 0xE3, 0xB5, 0xAD },
	0xCAE3, { 0xF0, 0xA3, 0xBE, 0xAA },
	0xCAE4, { 0xE6, 0xBE, 0x98 },
	0xCAE5, { 0xF0, 0xA3, 0xBD, 0x8A },
	0xCAE6, { 0xF0, 0xA3, 0xBD, 0x99 },
	0xCAE7, { 0xF0, 0xA3, 0xBD, 0x8B },
	0xCAE8, { 0xE3, 0xB5, 0x8F },
	0xCAE9, { 0xE6, 0xBD, 0xA8 },
	0xCAEA, { 0xE3, 0xB7, 0xB0 },
	0xCAEB, { 0xF0, 0xA4, 0x8D, 0x90 },
	0xCAEC, { 0xE7, 0x88, 0xB4 },
	0xCAED, { 0xE7, 0x89, 0x85 },
	0xCAEE, { 0xE3, 0xB9, 0x8D },
	0xCAEF, { 0xE3, 0xB9, 0x8C },
	0xCAF0, { 0xF0, 0xA4, 0x9B, 0x90 },
	0xCAF1, { 0xE3, 0xB9, 0x8F },
	0xCAF2, { 0xE3, 0xB9, 0x8E },
	0xCAF3, { 0xE3, 0xB9, 0x90 },
	0xCAF4, { 0xF0, 0xA4, 0x9B, 0x8C },
	0xCAF5, { 0xE7, 0x8D, 0x9C },
	0xCAF6, { 0xE3, 0xBA, 0x96 },
	0xCAF7, { 0xE7, 0x8D, 0x96 },
	0xCAF8, { 0xF0, 0xA4, 0xA1, 0xA4 },
	0xCAF9, { 0xF0, 0xA4, 0xA1, 0xA5 },
	0xCAFA, { 0xE3, 0xBA, 0x97 },
	0xCAFB, { 0xE3, 0xBA, 0x95 },
	0xCAFC, { 0xE3, 0xBA, 0x98 },
	0xCAFD, { 0xF0, 0xA4, 0xA1, 0x9C },
	0xCAFE, { 0xF0, 0xA4, 0xA8, 0x95 },
	0xCBA1, { 0xE3, 0xBB, 0xAC },
	0xCBA2, { 0xE3, 0xBB, 0xAB },
	0xCBA3, { 0xE3, 0xBC, 0x93 },
	0xCBA4, { 0xE3, 0xBC, 0x94 },
	0xCBA5, { 0xE3, 0xBC, 0xB8 },
	0xCBA6, { 0xE3, 0xBC, 0xBA },
	0xCBA7, { 0xE3, 0xBC, 0xB9 },
	0xCBA8, { 0xF0, 0xA4, 0xAD, 0xB9 },
	0xCBA9, { 0xE3, 0xBD, 0xA8 },
	0xCBAA, { 0xE3, 0xBD, 0xA7 },
	0xCBAB, { 0xF0, 0xA4, 0xB3, 0x85 },
	0xCBAC, { 0xF0, 0xA4, 0xB2, 0xB8 },
	0xCBAD, { 0xF0, 0xA4, 0xB8, 0xAC },
	0xCBAE, { 0xE3, 0xBE, 0xBE },
	0xCBAF, { 0xE3, 0xBE, 0xBC },
	0xCBB0, { 0xF0, 0xA4, 0xB8, 0xB7 },
	0xCBB1, { 0xF0, 0xA4, 0xB8, 0xB5 },
	0xCBB2, { 0xF0, 0xA4, 0xB8, 0xB1 },
	0xCBB3, { 0xE3, 0xBE, 0xBB },
	0xCBB4, { 0xF0, 0xA4, 0xB8, 0xAF },
	0xCBB5, { 0xE3, 0xBE, 0xBA },
	0xCBB6, { 0xF0, 0xA4, 0xB8, 0xAB },
	0xCBB7, { 0xE3, 0xBE, 0xB9 },
	0xCBB8, { 0xE3, 0xBE, 0xB7 },
	0xCBB9, { 0xF0, 0xA4, 0xB8, 0xAD },
	0xCBBA, { 0xF0, 0xA4, 0xB8, 0xAA },
	0xCBBB, { 0xE3, 0xBF, 0x81 },
	0xCBBC, { 0xF0, 0xA4, 0xBE, 0x95 },
	0xCBBD, { 0xE3, 0xBF, 0xB7 },
	0xCBBE, { 0xF0, 0xA5, 0x88, 0xBE },
	0xCBBF, { 0xE4, 0x81, 0xA0 },
	0xCBC0, { 0xF0, 0xA5, 0x89, 0x87 },
	0xCBC1, { 0xF0, 0xA5, 0x89, 0x85 },
	0xCBC2, { 0xE4, 0x81, 0x99 },
	0xCBC3, { 0xE4, 0x81, 0x9C },
	0xCBC4, { 0xE4, 0x81, 0x9A },
	0xCBC5, { 0xE4, 0x81, 0x98 },
	0xCBC6, { 0xF0, 0xA5, 0x89, 0x92 },
	0xCBC7, { 0xE4, 0x81, 0x9B },
	0xCBC8, { 0xF0, 0xA5, 0x89, 0xB0 },
	0xCBC9, { 0xF0, 0xA5, 0x89, 0x90 },
	0xCBCA, { 0xF0, 0xA5, 0x89, 0x98 },
	0xCBCB, { 0xF0, 0xA5, 0x89, 0x91 },
	0xCBCC, { 0xF0, 0xA5, 0x88, 0xBD },
	0xCBCD, { 0xE4, 0x81, 0x9D },
	0xCBCE, { 0xF0, 0xA5, 0x89, 0x81 },
	0xCBCF, { 0xF0, 0xA5, 0x88, 0x8C },
	0xCBD0, { 0xF0, 0xA5, 0x88, 0xBC },
	0xCBD1, { 0xF0, 0xA5, 0x8E, 0x86 },
	0xCBD2, { 0xF0, 0xA5, 0x8E, 0x83 },
	0xCBD3, { 0xF0, 0xA5, 0x8E, 0x89 },
	0xCBD4, { 0xF0, 0xA5, 0x8F, 0xB3 },
	0xCBD5, { 0xE4, 0x83, 0x94 },
	0xCBD6, { 0xE4, 0x83, 0x93 },
	0xCBD7, { 0xE7, 0xA2, 0xBF },
	0xCBD8, { 0xE4, 0x83, 0x92 },
	0xCBD9, { 0xE7, 0xA2, 0xBD },
	0xCBDA, { 0xF0, 0xA5, 0x94, 0xAD },
	0xCBDB, { 0xE4, 0x83, 0x97 },
	0xCBDC, { 0xE4, 0x83, 0x91 },
	0xCBDD, { 0xE7, 0xA3, 0xA4 },
	0xCBDE, { 0xE4, 0x83, 0x95 },
	0xCBDF, { 0xF0, 0xA5, 0x9B, 0x85 },
	0xCBE0, { 0xF0, 0xAF, 0xA5, 0x95 },
	0xCBE1, { 0xE4, 0x85, 0xAD },
	0xCBE2, { 0xE4, 0x85, 0xAF },
	0xCBE3, { 0xE7, 0xA8, 0xB4 },
	0xCBE4, { 0xE4, 0x85, 0xB5 },
	0xCBE5, { 0xE4, 0x85, 0xAC },
	0xCBE6, { 0xE4, 0x85, 0xB4 },
	0xCBE7, { 0xF0, 0xA5, 0xA1, 0x83 },
	0xCBE8, { 0xE4, 0x85, 0xB3 },
	0xCBE9, { 0xF0, 0xA5, 0xA0, 0xB7 },
	0xCBEA, { 0xF0, 0xA5, 0xA1, 0x85 },
	0xCBEB, { 0xE7, 0xA8, 0xB6 },
	0xCBEC, { 0xE4, 0x86, 0xAC },
	0xCBED, { 0xF0, 0xA5, 0xA7, 0xA5 },
	0xCBEE, { 0xF0, 0xA5, 0xAA, 0xA6 },
	0xCBEF, { 0xF0, 0xA5, 0xAF, 0x9B },
	0xCBF0, { 0xE4, 0x88, 0x90 },
	0xCBF1, { 0xF0, 0xA5, 0xAF, 0x9A },
	0xCBF2, { 0xF0, 0xA5, 0xAF, 0xA6 },
	0xCBF3, { 0xE7, 0xAE, 0xBA },
	0xCBF4, { 0xE7, 0xAE, 0xBC },
	0xCBF5, { 0xE4, 0x88, 0x8F },
	0xCBF6, { 0xE7, 0xAF, 0x88 },
	0xCBF7, { 0xE4, 0x88, 0xA3 },
	0xCBF8, { 0xE7, 0xAF, 0x83 },
	0xCBF9, { 0xE4, 0x88, 0x9D },
	0xCBFA, { 0xE7, 0xAE, 0xB6 },
	0xCBFB, { 0xE4, 0x88, 0x8E },
	0xCBFC, { 0xF0, 0xA5, 0xAF, 0xB8 },
	0xCBFD, { 0xF0, 0xA5, 0xAF, 0xA9 },
	0xCBFE, { 0xE4, 0x88, 0x95 },
	0xCCA1, { 0xE7, 0xAF, 0x82 },
	0xCCA2, { 0xE4, 0x88, 0x93 },
	0xCCA3, { 0xF0, 0xA5, 0xAF, 0xA8 },
	0xCCA4, { 0xF0, 0xA5, 0xAF, 0xB6 },
	0xCCA5, { 0xE4, 0x88, 0x9B },
	0xCCA6, { 0xE7, 0xAF, 0x85 },
	0xCCA7, { 0xE4, 0x88, 0xA2 },
	0xCCA8, { 0xE4, 0x88, 0xA6 },
	0xCCA9, { 0xF0, 0xA5, 0xAF, 0xA7 },
	0xCCAA, { 0xE7, 0xAE, 0xBD },
	0xCCAB, { 0xE7, 0xAE, 0xB0 },
	0xCCAC, { 0xE4, 0x88, 0xA1 },
	0xCCAD, { 0xE4, 0x88, 0x9C },
	0xCCAE, { 0xE4, 0x88, 0x97 },
	0xCCAF, { 0xF0, 0xA5, 0xAF, 0x95 },
	0xCCB0, { 0xE4, 0x88, 0x9A },
	0xCCB1, { 0xE7, 0xAE, 0xBB },
	0xCCB2, { 0xF0, 0xA5, 0xBB, 0x93 },
	0xCCB3, { 0xF0, 0xA5, 0xBB, 0x87 },
	0xCCB4, { 0xF0, 0xA5, 0xBB, 0x91 },
	0xCCB5, { 0xE4, 0x8A, 0x99 },
	0xCCB6, { 0xF0, 0xA5, 0xBB, 0x83 },
	0xCCB7, { 0xE4, 0x8A, 0x97 },
	0xCCB8, { 0xF0, 0xA6, 0x82, 0x80 },
	0xCCB9, { 0xF0, 0xA6, 0x82, 0x98 },
	0xCCBA, { 0xE4, 0x8B, 0xBD },
	0xCCBB, { 0xF0, 0xA6, 0x82, 0x84 },
	0xCCBC, { 0xE4, 0x8B, 0xB6 },
	0xCCBD, { 0xE4, 0x8B, 0xBE },
	0xCCBE, { 0xE4, 0x8B, 0xB5 },
	0xCCBF, { 0xE4, 0x8B, 0xBF },
	0xCCC0, { 0xE4, 0x8B, 0xB7 },
	0xCCC1, { 0xF0, 0xA6, 0x82, 0x97 },
	0xCCC2, { 0xF0, 0xA6, 0x82, 0x83 },
	0xCCC3, { 0xF0, 0xA6, 0x82, 0x81 },
	0xCCC4, { 0xE4, 0x8C, 0x81 },
	0xCCC5, { 0xE7, 0xB8, 0x84 },
	0xCCC6, { 0xF0, 0xA6, 0x82, 0x8C },
	0xCCC7, { 0xF0, 0xA6, 0x89, 0x82 },
	0xCCC8, { 0xF0, 0xA6, 0x8E, 0xAB },
	0xCCC9, { 0xE4, 0x8D, 0xB7 },
	0xCCCA, { 0xF0, 0xA6, 0x8E, 0xA3 },
	0xCCCB, { 0xF0, 0xA6, 0x8E, 0xA6 },
	0xCCCC, { 0xF0, 0xA6, 0x91, 0x9C },
	0xCCCD, { 0xF0, 0xA6, 0x91, 0xA9 },
	0xCCCE, { 0xF0, 0xA6, 0x91, 0xA7 },
	0xCCCF, { 0xE4, 0x8E, 0xAB },
	0xCCD0, { 0xF0, 0xA6, 0x96, 0x8B },
	0xCCD1, { 0xF0, 0xA6, 0x96, 0xA8 },
	0xCCD2, { 0xE4, 0x8F, 0x80 },
	0xCCD3, { 0xF0, 0xA6, 0x9F, 0x98 },
	0xCCD4, { 0xE4, 0x90, 0xB1 },
	0xCCD5, { 0xE4, 0x90, 0xAE },
	0xCCD6, { 0xF0, 0xAF, 0xA6, 0x89 },
	0xCCD7, { 0xF0, 0xA6, 0x9F, 0x9C },
	0xCCD8, { 0xE4, 0x90, 0xAC },
	0xCCD9, { 0xF0, 0xA6, 0x9F, 0xA0 },
	0xCCDA, { 0xF0, 0xA6, 0x9F, 0xA5 },
	0xCCDB, { 0xE4, 0x90, 0xB2 },
	0xCCDC, { 0xE4, 0x90, 0xAF },
	0xCCDD, { 0xE4, 0x90, 0xAB },
	0xCCDE, { 0xE4, 0x90, 0xAD },
	0xCCDF, { 0xE4, 0x90, 0xB3 },
	0xCCE0, { 0xF0, 0xA6, 0xA4, 0x98 },
	0xCCE1, { 0xF0, 0xA6, 0xA4, 0x99 },
	0xCCE2, { 0xE8, 0x87, 0xB1 },
	0xCCE3, { 0xE4, 0x91, 0x97 },
	0xCCE4, { 0xE4, 0x91, 0x9C },
	0xCCE5, { 0xE4, 0x91, 0xBB },
	0xCCE6, { 0xF0, 0xA6, 0xA9, 0x9F },
	0xCCE7, { 0xF0, 0xA6, 0xA9, 0x9E },
	0xCCE8, { 0xE4, 0x91, 0xBA },
	0xCCE9, { 0xF0, 0xA6, 0xB8, 0x82 },
	0xCCEA, { 0xE8, 0x94, 0xA2 },
	0xCCEB, { 0xE4, 0x94, 0x93 },
	0xCCEC, { 0xE4, 0x94, 0x9E },
	0xCCED, { 0xE4, 0x94, 0x97 },
	0xCCEE, { 0xE4, 0x94, 0xA0 },
	0xCCEF, { 0xE4, 0x94, 0xAA },
	0xCCF0, { 0xE4, 0x94, 0x91 },
	0xCCF1, { 0xE4, 0x94, 0x95 },
	0xCCF2, { 0xE4, 0x94, 0x8F },
	0xCCF3, { 0xE4, 0x94, 0x98 },
	0xCCF4, { 0xE8, 0x94, 0xB8 },
	0xCCF5, { 0xF0, 0xA6, 0xB8, 0x92 },
	0xCCF6, { 0xF0, 0xA6, 0xB8, 0xB6 },
	0xCCF7, { 0xE4, 0x94, 0xAC },
	0xCCF8, { 0xE8, 0x94, 0xB2 },
	0xCCF9, { 0xF0, 0xAF, 0xA6, 0xA8 },
	0xCCFA, { 0xE8, 0x94, 0x90 },
	0xCCFB, { 0xF0, 0xA6, 0xB8, 0xA3 },
	0xCCFC, { 0xF0, 0xA6, 0xB8, 0x83 },
	0xCCFD, { 0xE4, 0x94, 0x9C },
	0xCCFE, { 0xF0, 0xA6, 0xB8, 0x80 },
	0xCDA1, { 0xE4, 0x94, 0xA9 },
	0xCDA2, { 0xF0, 0xA6, 0xB9, 0x86 },
	0xCDA3, { 0xF0, 0xA6, 0xB9, 0xA1 },
	0xCDA4, { 0xE4, 0x94, 0x92 },
	0xCDA5, { 0xE8, 0x95, 0x8F },
	0xCDA6, { 0xE4, 0x96, 0x97 },
	0xCDA7, { 0xF0, 0xA7, 0x8E, 0x84 },
	0xCDA8, { 0xE8, 0x9D, 0xB2 },
	0xCDA9, { 0xF0, 0xA7, 0x8D, 0xAB },
	0xCDAA, { 0xF0, 0xA7, 0x8D, 0xA2 },
	0xCDAB, { 0xF0, 0xA7, 0x8D, 0x96 },
	0xCDAC, { 0xF0, 0xA7, 0x8D, 0xAA },
	0xCDAD, { 0xF0, 0xA7, 0x8D, 0x92 },
	0xCDAE, { 0xF0, 0xA7, 0x8D, 0x95 },
	0xCDAF, { 0xE4, 0x97, 0x94 },
	0xCDB0, { 0xE4, 0x97, 0x90 },
	0xCDB1, { 0xE8, 0x9D, 0xBC },
	0xCDB2, { 0xF0, 0xA7, 0x8D, 0xA1 },
	0xCDB3, { 0xF0, 0xAF, 0xA6, 0xBB },
	0xCDB4, { 0xF0, 0xA7, 0x8D, 0x98 },
	0xCDB5, { 0xF0, 0xA7, 0x8D, 0xB7 },
	0xCDB6, { 0xE4, 0x97, 0x93 },
	0xCDB7, { 0xE4, 0x98, 0x94 },
	0xCDB8, { 0xF0, 0xA7, 0x9B, 0x97 },
	0xCDB9, { 0xE4, 0x99, 0x86 },
	0xCDBA, { 0xE4, 0x99, 0x85 },
	0xCDBB, { 0xF0, 0xA7, 0x9B, 0x9E },
	0xCDBC, { 0xE4, 0x99, 0x83 },
	0xCDBD, { 0xF0, 0xA7, 0x9B, 0x9F },
	0xCDBE, { 0xE8, 0xA4, 0x8D },
	0xCDBF, { 0xE4, 0x99, 0x84 },
	0xCDC0, { 0xE4, 0x99, 0x88 },
	0xCDC1, { 0xF0, 0xA7, 0x9B, 0x91 },
	0xCDC2, { 0xE4, 0x99, 0x87 },
	0xCDC3, { 0xF0, 0xA7, 0x9B, 0xA2 },
	0xCDC4, { 0xF0, 0xA7, 0x9B, 0xA1 },
	0xCDC5, { 0xF0, 0xA7, 0x9B, 0x9D },
	0xCDC6, { 0xE8, 0xA4, 0x88 },
	0xCDC7, { 0xE4, 0x99, 0x89 },
	0xCDC8, { 0xE4, 0x9A, 0x85 },
	0xCDC9, { 0xF0, 0xA7, 0xA1, 0x8B },
	0xCDCA, { 0xE4, 0x9A, 0x84 },
	0xCDCB, { 0xF0, 0xA7, 0xA1, 0x8E },
	0xCDCC, { 0xE4, 0x9A, 0x9D },
	0xCDCD, { 0xF0, 0xA7, 0xA3, 0xBC },
	0xCDCE, { 0xE4, 0x9A, 0x9E },
	0xCDCF, { 0xE4, 0x9A, 0xA0 },
	0xCDD0, { 0xF0, 0xA7, 0xA3, 0xBA },
	0xCDD1, { 0xE4, 0x9A, 0x9C },
	0xCDD2, { 0xF0, 0xA7, 0xA3, 0xBB },
	0xCDD3, { 0xE4, 0x9A, 0x9F },
	0xCDD4, { 0xF0, 0xA7, 0xA3, 0xBE },
	0xCDD5, { 0xE4, 0x9B, 0xB7 },
	0xCDD6, { 0xE4, 0x9B, 0xAA },
	0xCDD7, { 0xF0, 0xA7, 0xA8, 0xB1 },
	0xCDD8, { 0xE4, 0x9B, 0xAF },
	0xCDD9, { 0xE4, 0x9B, 0xA9 },
	0xCDDA, { 0xE4, 0x9B, 0xB3 },
	0xCDDB, { 0xE4, 0x9B, 0xB0 },
	0xCDDC, { 0xE4, 0x9B, 0xAB },
	0xCDDD, { 0xF0, 0xA7, 0xA8, 0xB8 },
	0xCDDE, { 0xE4, 0x9B, 0xAC },
	0xCDDF, { 0xE4, 0x9B, 0xB2 },
	0xCDE0, { 0xE4, 0x9B, 0xB5 },
	0xCDE1, { 0xE4, 0x9B, 0xAE },
	0xCDE2, { 0xF0, 0xA7, 0xA8, 0xBA },
	0xCDE3, { 0xF0, 0xA7, 0xAE, 0xBB },
	0xCDE4, { 0xE4, 0x9C, 0xBA },
	0xCDE5, { 0xE4, 0x9D, 0x8B },
	0xCDE6, { 0xF0, 0xA7, 0xB1, 0x99 },
	0xCDE7, { 0xE4, 0x9D, 0x8A },
	0xCDE8, { 0xE4, 0x9D, 0x8C },
	0xCDE9, { 0xF0, 0xA7, 0xB3, 0x9B },
	0xCDEA, { 0xF0, 0xA7, 0xB3, 0x9F },
	0xCDEB, { 0xF0, 0xA7, 0xB3, 0xA2 },
	0xCDEC, { 0xE4, 0x9D, 0xB9 },
	0xCDED, { 0xE4, 0x9D, 0xBB },
	0xCDEE, { 0xE4, 0x9D, 0xB8 },
	0xCDEF, { 0xF0, 0xA7, 0xB6, 0x9E },
	0xCDF0, { 0xF0, 0xA7, 0xB6, 0xA1 },
	0xCDF1, { 0xE4, 0x9E, 0xB5 },
	0xCDF2, { 0xF0, 0xA7, 0xBC, 0x90 },
	0xCDF3, { 0xE4, 0x9E, 0xB4 },
	0xCDF4, { 0xE4, 0x9E, 0xB7 },
	0xCDF5, { 0xE8, 0xB6, 0x9E },
	0xCDF6, { 0xE4, 0xA0, 0x89 },
	0xCDF7, { 0xE4, 0x9F, 0xBE },
	0xCDF8, { 0xE4, 0xA0, 0x88 },
	0xCDF9, { 0xE4, 0xA0, 0x87 },
	0xCDFA, { 0xF0, 0xA8, 0x81, 0xB6 },
	0xCDFB, { 0xF0, 0xA8, 0x81, 0xBF },
	0xCDFC, { 0xF0, 0xA8, 0x81, 0xBD },
	0xCDFD, { 0xE4, 0xA0, 0x86 },
	0xCDFE, { 0xE4, 0xA0, 0x84 },
	0xCEA1, { 0xE4, 0xA0, 0x85 },
	0xCEA2, { 0xE4, 0x9F, 0xBF },
	0xCEA3, { 0xE4, 0xA0, 0x8B },
	0xCEA4, { 0xF0, 0xA8, 0x82, 0x82 },
	0xCEA5, { 0xF0, 0xA8, 0x89, 0x97 },
	0xCEA6, { 0xE4, 0xA0, 0xBB },
	0xCEA7, { 0xE4, 0xA1, 0x9D },
	0xCEA8, { 0xE4, 0xA1, 0x9C },
	0xCEA9, { 0xE4, 0xA1, 0x9F },
	0xCEAA, { 0xE4, 0xA1, 0x9E },
	0xCEAB, { 0xE8, 0xBC, 0xA8 },
	0xCEAC, { 0xF0, 0xA8, 0x8C, 0xAE },
	0xCEAD, { 0xE8, 0xBC, 0xA1 },
	0xCEAE, { 0xE4, 0xA2, 0x83 },
	0xCEAF, { 0xF0, 0xA8, 0x96, 0x8B },
	0xCEB0, { 0xF0, 0xA8, 0x96, 0x8D },
	0xCEB1, { 0xE4, 0xA2, 0xA7 },
	0xCEB2, { 0xE9, 0x81, 0xA6 },
	0xCEB3, { 0xE9, 0x81, 0xAC },
	0xCEB4, { 0xF0, 0xA8, 0x96, 0x90 },
	0xCEB5, { 0xE4, 0xA2, 0xA8 },
	0xCEB6, { 0xF0, 0xA8, 0x9B, 0xAC },
	0xCEB7, { 0xF0, 0xA8, 0x9D, 0xAF },
	0xCEB8, { 0xF0, 0xA8, 0x9D, 0xAB },
	0xCEB9, { 0xF0, 0xA8, 0x9D, 0xB1 },
	0xCEBA, { 0xF0, 0xA8, 0x9D, 0xB8 },
	0xCEBB, { 0xE9, 0x83, 0xB6 },
	0xCEBC, { 0xE4, 0xA3, 0xA0 },
	0xCEBD, { 0xE4, 0xA3, 0x9F },
	0xCEBE, { 0xE4, 0xA3, 0xBE },
	0xCEBF, { 0xE4, 0xA3, 0xBC },
	0xCEC0, { 0xE4, 0xA3, 0xBF },
	0xCEC1, { 0xE4, 0xA3, 0xBD },
	0xCEC2, { 0xF0, 0xA8, 0xA6, 0xAD },
	0xCEC3, { 0xE4, 0xA4, 0xAC },
	0xCEC4, { 0xE9, 0x8B, 0xAC },
	0xCEC5, { 0xE9, 0x8A, 0xBA },
	0xCEC6, { 0xE9, 0x8B, 0xA3 },
	0xCEC7, { 0xE9, 0x8A, 0xBD },
	0xCEC8, { 0xE4, 0xA6, 0x9D },
	0xCEC9, { 0xF0, 0xA8, 0xB4, 0xAF },
	0xCECA, { 0xE9, 0x96, 0xB4 },
	0xCECB, { 0xF0, 0xA8, 0xBD, 0xB8 },
	0xCECC, { 0xE4, 0xA9, 0x80 },
	0xCECD, { 0xF0, 0xA9, 0x87, 0xB8 },
	0xCECE, { 0xF0, 0xA9, 0x88, 0x99 },
	0xCECF, { 0xE4, 0xA9, 0x9F },
	0xCED0, { 0xF0, 0xA9, 0x8A, 0x9B },
	0xCED1, { 0xF0, 0xA9, 0x8A, 0x94 },
	0xCED2, { 0xF0, 0xA9, 0x8A, 0x97 },
	0xCED3, { 0xF0, 0xA9, 0x8A, 0x99 },
	0xCED4, { 0xF0, 0xA9, 0x8E, 0xA6 },
	0xCED5, { 0xF0, 0xA9, 0x8E, 0xA4 },
	0xCED6, { 0xF0, 0xA9, 0x8E, 0xA7 },
	0xCED7, { 0xE9, 0x9F, 0x91 },
	0xCED8, { 0xF0, 0xA9, 0x92, 0x95 },
	0xCED9, { 0xE4, 0xAB, 0x80 },
	0xCEDA, { 0xE9, 0xA0, 0xA3 },
	0xCEDB, { 0xF0, 0xA9, 0x92, 0x90 },
	0xCEDC, { 0xE4, 0xAB, 0x81 },
	0xCEDD, { 0xE4, 0xAB, 0x86 },
	0xCEDE, { 0xF0, 0xA9, 0x92, 0x9B },
	0xCEDF, { 0xF0, 0xA9, 0x97, 0x84 },
	0xCEE0, { 0xE4, 0xAC, 0x84 },
	0xCEE1, { 0xE4, 0xAC, 0x85 },
	0xCEE2, { 0xF0, 0xA9, 0x97, 0x86 },
	0xCEE3, { 0xE9, 0xA4, 0x8B },
	0xCEE4, { 0xE4, 0xAC, 0xBE },
	0xCEE5, { 0xE4, 0xAC, 0xBD },
	0xCEE6, { 0xE4, 0xAD, 0x80 },
	0xCEE7, { 0xE4, 0xAC, 0xBF },
	0xCEE8, { 0xF0, 0xA9, 0x9B, 0xA3 },
	0xCEE9, { 0xE4, 0xAD, 0x82 },
	0xCEEA, { 0xF0, 0xA9, 0x9B, 0x9F },
	0xCEEB, { 0xF0, 0xA9, 0x9B, 0x9D },
	0xCEEC, { 0xF0, 0xA9, 0x9B, 0xA7 },
	0xCEED, { 0xE4, 0xAE, 0x84 },
	0xCEEE, { 0xE4, 0xAE, 0x82 },
	0xCEEF, { 0xE4, 0xAD, 0xBF },
	0xCEF0, { 0xE4, 0xAE, 0x85 },
	0xCEF1, { 0xF0, 0xA9, 0xA8, 0xAD },
	0xCEF2, { 0xF0, 0xA9, 0xA8, 0xAC },
	0xCEF3, { 0xE4, 0xAF, 0x8C },
	0xCEF4, { 0xE9, 0xAA, 0xB2 },
	0xCEF5, { 0xE4, 0xAF, 0x8B },
	0xCEF6, { 0xE4, 0xAF, 0x8D },
	0xCEF7, { 0xF0, 0xA9, 0xA8, 0xB4 },
	0xCEF8, { 0xF0, 0xA9, 0xA8, 0xB8 },
	0xCEF9, { 0xE9, 0xAB, 0x9B },
	0xCEFA, { 0xF0, 0xA9, 0xAC, 0x9D },
	0xCEFB, { 0xE4, 0xAF, 0xB5 },
	0xCEFC, { 0xF0, 0xA9, 0xAC, 0x9A },
	0xCEFD, { 0xF0, 0xA9, 0xAC, 0x9B },
	0xCEFE, { 0xF0, 0xA9, 0xAC, 0x94 },
	0xCFA1, { 0xE9, 0xAB, 0xB0 },
	0xCFA2, { 0xF0, 0xA9, 0xAC, 0x97 },
	0xCFA3, { 0xF0, 0xA9, 0xB0, 0xA1 },
	0xCFA4, { 0xE4, 0xB0, 0xA0 },
	0xCFA5, { 0xE4, 0xB0, 0xA1 },
	0xCFA6, { 0xF0, 0xA9, 0xB2, 0xAA },
	0xCFA7, { 0xF0, 0xA9, 0xB2, 0xA1 },
	0xCFA8, { 0xE4, 0xB0, 0xB7 },
	0xCFA9, { 0xE4, 0xB0, 0xBE },
	0xCFAA, { 0xE9, 0xAD, 0xB3 },
	0xCFAB, { 0xE4, 0xB0, 0xBD },
	0xCFAC, { 0xE9, 0xAD, 0xAE },
	0xCFAD, { 0xF0, 0xA9, 0xB5, 0xA3 },
	0xCFAE, { 0xF0, 0xA9, 0xB5, 0xB9 },
	0xCFAF, { 0xF0, 0xA9, 0xB5, 0xA0 },
	0xCFB0, { 0xE9, 0xAD, 0xA5 },
	0xCFB1, { 0xF0, 0xA9, 0xB5, 0xA2 },
	0xCFB2, { 0xE4, 0xB0, 0xBC },
	0xCFB3, { 0xF0, 0xA9, 0xB5, 0xA1 },
	0xCFB4, { 0xE4, 0xB0, 0xB8 },
	0xCFB5, { 0xE9, 0xAD, 0xAA },
	0xCFB6, { 0xF0, 0xA9, 0xB5, 0xB0 },
	0xCFB7, { 0xE9, 0xAD, 0xAD },
	0xCFB8, { 0xF0, 0xA9, 0xB5, 0xAA },
	0xCFB9, { 0xE4, 0xB0, 0xBB },
	0xCFBA, { 0xF0, 0xA9, 0xBF, 0x88 },
	0xCFBB, { 0xE4, 0xB2, 0xB0 },
	0xCFBC, { 0xF0, 0xA9, 0xBF, 0x85 },
	0xCFBD, { 0xF0, 0xA9, 0xBE, 0xBE },
	0xCFBE, { 0xF0, 0xA9, 0xBF, 0x82 },
	0xCFBF, { 0xE4, 0xB2, 0xAD },
	0xCFC0, { 0xE4, 0xB2, 0xB2 },
	0xCFC1, { 0xE4, 0xB2, 0xB8 },
	0xCFC2, { 0xE9, 0xB4, 0x8B },
	0xCFC3, { 0xF0, 0xA9, 0xBF, 0x87 },
	0xCFC4, { 0xE4, 0xB2, 0xAF },
	0xCFC5, { 0xF0, 0xA9, 0xBE, 0xB0 },
	0xCFC6, { 0xF0, 0xA9, 0xBF, 0x8A },
	0xCFC7, { 0xE4, 0xB4, 0x9A },
	0xCFC8, { 0xE9, 0xB9, 0xB6 },
	0xCFC9, { 0xE4, 0xB4, 0xA0 },
	0xCFCA, { 0xE4, 0xB4, 0xA1 },
	0xCFCB, { 0xE4, 0xB4, 0xB0 },
	0xCFCC, { 0xE9, 0xBA, 0xA8 },
	0xCFCD, { 0xE4, 0xB4, 0xAF },
	0xCFCE, { 0xF0, 0xAA, 0x8C, 0x8D },
	0xCFCF, { 0xF0, 0xAA, 0x8C, 0x87 },
	0xCFD0, { 0xF0, 0xAA, 0x8E, 0x96 },
	0xCFD1, { 0xF0, 0xAA, 0x8F, 0xAF },
	0xCFD2, { 0xE4, 0xB5, 0x9F },
	0xCFD3, { 0xE4, 0xB5, 0xA0 },
	0xCFD4, { 0xF0, 0xAA, 0x90, 0x9E },
	0xCFD5, { 0xF0, 0xAA, 0x90, 0x9D },
	0xCFD6, { 0xE9, 0xBC, 0x91 },
	0xCFD7, { 0xF0, 0xAA, 0x96, 0x90 },
	0xCFD8, { 0xF0, 0xA0, 0x8F, 0xAB },
	0xCFD9, { 0xE3, 0x92, 0x8A },
	0xCFDA, { 0xE5, 0x84, 0x99 },
	0xCFDB, { 0xE3, 0x92, 0x9C },
	0xCFDC, { 0xF0, 0xA0, 0x8F, 0xAE },
	0xCFDD, { 0xE3, 0x92, 0x9A },
	0xCFDE, { 0xF0, 0xA0, 0x8F, 0xAF },
	0xCFDF, { 0xF0, 0xA0, 0x8F, 0xAC },
	0xCFE0, { 0xF0, 0xA0, 0x9F, 0xBA },
	0xCFE1, { 0xE3, 0x94, 0x8C },
	0xCFE2, { 0xE3, 0x94, 0x8B },
	0xCFE3, { 0xE3, 0x94, 0x8D },
	0xCFE4, { 0xE5, 0x8A, 0x92 },
	0xCFE5, { 0xF0, 0xA0, 0xA4, 0x84 },
	0xCFE6, { 0xF0, 0xA0, 0xBF, 0x93 },
	0xCFE7, { 0xE3, 0x97, 0xBE },
	0xCFE8, { 0xF0, 0xA0, 0xBF, 0x91 },
	0xCFE9, { 0xF0, 0xA0, 0xBF, 0xBA },
	0xCFEA, { 0xE3, 0x97, 0xBF },
	0xCFEB, { 0xE3, 0x97, 0xBB },
	0xCFEC, { 0xE3, 0x97, 0xBC },
	0xCFED, { 0xE3, 0x98, 0x89 },
	0xCFEE, { 0xF0, 0xA0, 0xBF, 0x88 },
	0xCFEF, { 0xE3, 0x98, 0x80 },
	0xCFF0, { 0xF0, 0xA0, 0xBF, 0x95 },
	0xCFF1, { 0xE5, 0x99, 0xB5 },
	0xCFF2, { 0xF0, 0xA0, 0xBF, 0x8D },
	0xCFF3, { 0xF0, 0xA0, 0xBF, 0x92 },
	0xCFF4, { 0xF0, 0xA0, 0xBF, 0xBB },
	0xCFF5, { 0xF0, 0xA1, 0x88, 0xAA },
	0xCFF6, { 0xF0, 0xA1, 0x92, 0x88 },
	0xCFF7, { 0xF0, 0xA1, 0x91, 0xA1 },
	0xCFF8, { 0xE3, 0x99, 0xB1 },
	0xCFF9, { 0xF0, 0xA1, 0x91, 0xA3 },
	0xCFFA, { 0xF0, 0xA1, 0x91, 0xA2 },
	0xCFFB, { 0xE5, 0xA5, 0xAF },
	0xCFFC, { 0xF0, 0xA0, 0x81, 0x97 },
	0xCFFD, { 0xF0, 0xA1, 0xA3, 0x88 },
	0xCFFE, { 0xF0, 0xA1, 0xA2, 0x98 },
	0xD0A1, { 0xE3, 0x9C, 0xAB },
	0xD0A2, { 0xF0, 0xA1, 0xAB, 0x81 },
	0xD0A3, { 0xF0, 0xA1, 0xBC, 0xBF },
	0xD0A4, { 0xF0, 0xA1, 0xBD, 0x81 },
	0xD0A5, { 0xE3, 0xA0, 0x94 },
	0xD0A6, { 0xE3, 0xA0, 0x91 },
	0xD0A7, { 0xE3, 0xA0, 0x92 },
	0xD0A8, { 0xF0, 0xA2, 0x85, 0x92 },
	0xD0A9, { 0xE3, 0xA1, 0xA3 },
	0xD0AA, { 0xF0, 0xA2, 0x85, 0x9E },
	0xD0AB, { 0xE3, 0xA1, 0xAE },
	0xD0AC, { 0xE3, 0xA2, 0x9A },
	0xD0AD, { 0xF0, 0xA2, 0x8B, 0x87 },
	0xD0AE, { 0xE3, 0xA2, 0x9B },
	0xD0AF, { 0xF0, 0xA2, 0x8D, 0xB0 },
	0xD0B0, { 0xF0, 0xA2, 0x90, 0xA7 },
	0xD0B1, { 0xE3, 0xA3, 0x88 },
	0xD0B2, { 0xF0, 0xA2, 0x91, 0xB1 },
	0xD0B3, { 0xF0, 0xA2, 0x92, 0xB0 },
	0xD0B4, { 0xE3, 0xA3, 0xB6 },
	0xD0B5, { 0xF0, 0xA2, 0xA1, 0x82 },
	0xD0B6, { 0xF0, 0xA2, 0xA1, 0x83 },
	0xD0B7, { 0xE6, 0x86, 0xA5 },
	0xD0B8, { 0xE3, 0xA6, 0x8C },
	0xD0B9, { 0xE3, 0xA6, 0x97 },
	0xD0BA, { 0xE3, 0xA6, 0xA2 },
	0xD0BB, { 0xE6, 0x86, 0xA0 },
	0xD0BC, { 0xF0, 0xA2, 0xA1, 0x97 },
	0xD0BD, { 0xF0, 0xA2, 0xA2, 0x9D },
	0xD0BE, { 0xF0, 0xA2, 0xB6, 0x89 },
	0xD0BF, { 0xF0, 0xA2, 0xB6, 0x8D },
	0xD0C0, { 0xF0, 0xA2, 0xB6, 0x8B },
	0xD0C1, { 0xF0, 0xA2, 0xB6, 0x80 },
	0xD0C2, { 0xF0, 0xA2, 0xB6, 0x92 },
	0xD0C3, { 0xF0, 0xA2, 0xB6, 0x8A },
	0xD0C4, { 0xF0, 0xA2, 0xB7, 0x88 },
	0xD0C5, { 0xE3, 0xA9, 0x94 },
	0xD0C6, { 0xF0, 0xA2, 0xB6, 0x8F },
	0xD0C7, { 0xF0, 0xA2, 0xB6, 0x93 },
	0xD0C8, { 0xF0, 0xA2, 0xB6, 0x91 },
	0xD0C9, { 0xE3, 0xAA, 0xA8 },
	0xD0CA, { 0xF0, 0xA2, 0xBF, 0xB2 },
	0xD0CB, { 0xF0, 0xA2, 0xBF, 0x9E },
	0xD0CC, { 0xE3, 0xAA, 0xA9 },
	0xD0CD, { 0xF0, 0xA3, 0x83, 0x88 },
	0xD0CE, { 0xE6, 0x96, 0xB4 },
	0xD0CF, { 0xE6, 0x97, 0x98 },
	0xD0D0, { 0xE6, 0x9B, 0x82 },
	0xD0D1, { 0xE3, 0xAC, 0x98 },
	0xD0D2, { 0xE3, 0xAC, 0x97 },
	0xD0D3, { 0xE3, 0xAC, 0x9D },
	0xD0D4, { 0xF0, 0xA3, 0x8A, 0xA7 },
	0xD0D5, { 0xF0, 0xA3, 0x8A, 0xA1 },
	0xD0D6, { 0xE3, 0xAC, 0xB1 },
	0xD0D7, { 0xF0, 0xA3, 0x9A, 0x8C },
	0xD0D8, { 0xF0, 0xA3, 0x99, 0xBF },
	0xD0D9, { 0xE3, 0xAF, 0x98 },
	0xD0DA, { 0xE3, 0xAF, 0x95 },
	0xD0DB, { 0xF0, 0xA3, 0x99, 0xBB },
	0xD0DC, { 0xF0, 0xA3, 0x9A, 0x95 },
	0xD0DD, { 0xF0, 0xA3, 0x9A, 0x99 },
	0xD0DE, { 0xE3, 0xAF, 0xA1 },
	0xD0DF, { 0xF0, 0xA3, 0x9A, 0x8E },
	0xD0E0, { 0xE3, 0xAF, 0x94 },
	0xD0E1, { 0xF0, 0xA3, 0x9B, 0x9A },
	0xD0E2, { 0xF0, 0xA3, 0x9A, 0x8A },
	0xD0E3, { 0xF0, 0xA3, 0x9A, 0x9C },
	0xD0E4, { 0xE3, 0xAF, 0xA3 },
	0xD0E5, { 0xF0, 0xA3, 0x99, 0xBE },
	0xD0E6, { 0xE3, 0xB1, 0x84 },
	0xD0E7, { 0xE3, 0xB1, 0x85 },
	0xD0E8, { 0xF0, 0xA3, 0xA4, 0x9A },
	0xD0E9, { 0xF0, 0xA3, 0xA9, 0x95 },
	0xD0EA, { 0xE3, 0xB1, 0xB6 },
	0xD0EB, { 0xE3, 0xB1, 0xB5 },
	0xD0EC, { 0xF0, 0xA3, 0xA9, 0xA0 },
	0xD0ED, { 0xE6, 0xAE, 0xA8 },
	0xD0EE, { 0xE3, 0xB2, 0x88 },
	0xD0EF, { 0xE3, 0xB2, 0xAA },
	0xD0F0, { 0xF0, 0xA3, 0xAF, 0xBB },
	0xD0F1, { 0xE3, 0xB2, 0xAB },
	0xD0F2, { 0xE3, 0xB2, 0xAC },
	0xD0F3, { 0xF0, 0xA3, 0xAF, 0xBD },
	0xD0F4, { 0xE3, 0xB5, 0x97 },
	0xD0F5, { 0xE6, 0xBE, 0x83 },
	0xD0F6, { 0xE3, 0xB5, 0xA0 },
	0xD0F7, { 0xE3, 0xB5, 0x9D },
	0xD0F8, { 0xE3, 0xB5, 0xAB },
	0xD0F9, { 0xF0, 0xA3, 0xBF, 0x90 },
	0xD0FA, { 0xE3, 0xB5, 0xA3 },
	0xD0FB, { 0xE3, 0xB5, 0xA7 },
	0xD0FC, { 0xF0, 0xA3, 0xBF, 0x85 },
	0xD0FD, { 0xE3, 0xB5, 0x9E },
	0xD0FE, { 0xF0, 0xA3, 0xBF, 0x92 },
	0xD1A1, { 0xF0, 0xA4, 0x80, 0x91 },
	0xD1A2, { 0xE6, 0xBF, 0x85 },
	0xD1A3, { 0xE7, 0x87, 0x8D },
	0xD1A4, { 0xE3, 0xB7, 0xB9 },
	0xD1A5, { 0xE3, 0xB7, 0xB3 },
	0xD1A6, { 0xF0, 0xA4, 0x8E, 0xAD },
	0xD1A7, { 0xF0, 0xA4, 0x8E, 0xA4 },
	0xD1A8, { 0xF0, 0xA4, 0x8E, 0xA9 },
	0xD1A9, { 0xF0, 0xA4, 0x8E, 0xB0 },
	0xD1AA, { 0xF0, 0xA4, 0x8E, 0x9D },
	0xD1AB, { 0xE3, 0xB7, 0xB6 },
	0xD1AC, { 0xF0, 0xA4, 0x96, 0x98 },
	0xD1AD, { 0xE7, 0x8A, 0x9C },
	0xD1AE, { 0xE3, 0xB9, 0x91 },
	0xD1AF, { 0xE3, 0xB9, 0x93 },
	0xD1B0, { 0xE3, 0xB9, 0x92 },
	0xD1B1, { 0xF0, 0xA4, 0xA2, 0x92 },
	0xD1B2, { 0xE3, 0xBA, 0x9B },
	0xD1B3, { 0xF0, 0xA4, 0xA2, 0x8A },
	0xD1B4, { 0xE3, 0xBA, 0x9C },
	0xD1B5, { 0xF0, 0xA4, 0xA2, 0x8D },
	0xD1B6, { 0xF0, 0xA4, 0xA2, 0x96 },
	0xD1B7, { 0xE3, 0xBB, 0xB7 },
	0xD1B8, { 0xE7, 0x92, 0x99 },
	0xD1B9, { 0xE7, 0x92, 0x8F },
	0xD1BA, { 0xE7, 0x92, 0x91 },
	0xD1BB, { 0xF0, 0xA4, 0xA9, 0x85 },
	0xD1BC, { 0xF0, 0xA4, 0xA9, 0x8B },
	0xD1BD, { 0xF0, 0xA4, 0xAC, 0x8F },
	0xD1BE, { 0xF0, 0xA4, 0xAC, 0x96 },
	0xD1BF, { 0xE3, 0xBC, 0xBB },
	0xD1C0, { 0xF0, 0xA4, 0xAE, 0x8A },
	0xD1C1, { 0xE3, 0xBC, 0xBE },
	0xD1C2, { 0xE3, 0xBC, 0xBD },
	0xD1C3, { 0xF0, 0xA4, 0xB3, 0x89 },
	0xD1C4, { 0xE3, 0xBD, 0xA9 },
	0xD1C5, { 0xF0, 0xA4, 0xB3, 0x88 },
	0xD1C6, { 0xF0, 0xA4, 0xB3, 0x8A },
	0xD1C7, { 0xF0, 0xA4, 0xB9, 0xA4 },
	0xD1C8, { 0xE3, 0xBF, 0x83 },
	0xD1C9, { 0xE3, 0xBF, 0x84 },
	0xD1CA, { 0xE3, 0xBF, 0x87 },
	0xD1CB, { 0xF0, 0xA4, 0xB9, 0x9D },
	0xD1CC, { 0xF0, 0xA4, 0xB9, 0xA3 },
	0xD1CD, { 0xE7, 0x98, 0xB9 },
	0xD1CE, { 0xE3, 0xBF, 0x86 },
	0xD1CF, { 0xE7, 0x98, 0xAE },
	0xD1D0, { 0xE3, 0xBF, 0x88 },
	0xD1D1, { 0xF0, 0xA4, 0xBA, 0x88 },
	0xD1D2, { 0xF0, 0xA4, 0xBC, 0xBA },
	0xD1D3, { 0xF0, 0xA4, 0xBC, 0xB9 },
	0xD1D4, { 0xE7, 0x9A, 0x9F },
	0xD1D5, { 0xE7, 0x9A, 0xA0 },
	0xD1D6, { 0xE3, 0xBF, 0xA6 },
	0xD1D7, { 0xE3, 0xBF, 0xB8 },
	0xD1D8, { 0xF0, 0xA5, 0x80, 0x97 },
	0xD1D9, { 0xF0, 0xA5, 0x82, 0x93 },
	0xD1DA, { 0xE4, 0x80, 0x87 },
	0xD1DB, { 0xF0, 0xA5, 0x82, 0x95 },
	0xD1DC, { 0xE4, 0x81, 0xA4 },
	0xD1DD, { 0xE4, 0x81, 0xA8 },
	0xD1DE, { 0xF0, 0xA5, 0x89, 0xB6 },
	0xD1DF, { 0xE7, 0x9E, 0x94 },
	0xD1E0, { 0xE4, 0x81, 0xA5 },
	0xD1E1, { 0xE7, 0x9E, 0xAE },
	0xD1E2, { 0xF0, 0xA5, 0x8A, 0x80 },
	0xD1E3, { 0xF0, 0xA5, 0x89, 0xBB },
	0xD1E4, { 0xE4, 0x81, 0xA9 },
	0xD1E5, { 0xF0, 0xA5, 0x89, 0x88 },
	0xD1E6, { 0xF0, 0xA5, 0x8A, 0xA8 },
	0xD1E7, { 0xF0, 0xA5, 0x8A, 0x88 },
	0xD1E8, { 0xF0, 0xA5, 0x8E, 0x8B },
	0xD1E9, { 0xF0, 0xA5, 0x8E, 0x8A },
	0xD1EA, { 0xF0, 0xA5, 0x8E, 0x8C },
	0xD1EB, { 0xF0, 0xA5, 0x8F, 0xBC },
	0xD1EC, { 0xE4, 0x83, 0x9A },
	0xD1ED, { 0xE4, 0x83, 0xA0 },
	0xD1EE, { 0xE7, 0xA3, 0xA6 },
	0xD1EF, { 0xF0, 0xA5, 0x95, 0x98 },
	0xD1F0, { 0xE4, 0x83, 0x9E },
	0xD1F1, { 0xF0, 0xA5, 0x95, 0x91 },
	0xD1F2, { 0xF0, 0xA5, 0x95, 0x95 },
	0xD1F3, { 0xF0, 0xA5, 0x95, 0x93 },
	0xD1F4, { 0xE4, 0x84, 0x9C },
	0xD1F5, { 0xE4, 0x84, 0x9D },
	0xD1F6, { 0xE4, 0x84, 0x9A },
	0xD1F7, { 0xF0, 0xA5, 0x9B, 0x9C },
	0xD1F8, { 0xE4, 0x85, 0xBB },
	0xD1F9, { 0xE4, 0x85, 0xBA },
	0xD1FA, { 0xE4, 0x85, 0xBC },
	0xD1FB, { 0xF0, 0xA5, 0xA1, 0x9C },
	0xD1FC, { 0xE4, 0x85, 0xB8 },
	0xD1FD, { 0xE4, 0x85, 0xB7 },
	0xD1FE, { 0xF0, 0xA5, 0xA1, 0xA5 },
	0xD2A1, { 0xF0, 0xAF, 0xA5, 0x9A },
	0xD2A2, { 0xE4, 0x86, 0xB1 },
	0xD2A3, { 0xF0, 0xA5, 0xA7, 0xAE },
	0xD2A4, { 0xE4, 0x86, 0xB2 },
	0xD2A5, { 0xE4, 0x86, 0xB0 },
	0xD2A6, { 0xF0, 0xA5, 0xA7, 0xB0 },
	0xD2A7, { 0xE7, 0xAA, 0xBC },
	0xD2A8, { 0xF0, 0xA5, 0xA7, 0xB2 },
	0xD2A9, { 0xE4, 0x88, 0xB6 },
	0xD2AA, { 0xF0, 0xA5, 0xB0, 0xB5 },
	0xD2AB, { 0xE4, 0x88, 0xAE },
	0xD2AC, { 0xF0, 0xA5, 0xB0, 0xA2 },
	0xD2AD, { 0xE7, 0xAF, 0x96 },
	0xD2AE, { 0xF0, 0xA5, 0xB0, 0xA0 },
	0xD2AF, { 0xE4, 0x88, 0xB4 },
	0xD2B0, { 0xF0, 0xA5, 0xB0, 0xAD },
	0xD2B1, { 0xF0, 0xA5, 0xB0, 0xA8 },
	0xD2B2, { 0xF0, 0xA5, 0xB0, 0xA6 },
	0xD2B3, { 0xF0, 0xA5, 0xB0, 0xBC },
	0xD2B4, { 0xE4, 0x88, 0xAA },
	0xD2B5, { 0xF0, 0xA5, 0xB0, 0xB8 },
	0xD2B6, { 0xE4, 0x88, 0xB3 },
	0xD2B7, { 0xE4, 0x88, 0xAD },
	0xD2B8, { 0xE4, 0x88, 0xAF },
	0xD2B9, { 0xE4, 0x88, 0xB1 },
	0xD2BA, { 0xE4, 0x88, 0xAB },
	0xD2BB, { 0xE4, 0x88, 0xB2 },
	0xD2BC, { 0xF0, 0xA5, 0xB0, 0xAA },
	0xD2BD, { 0xE4, 0x88, 0xB5 },
	0xD2BE, { 0xF0, 0xA5, 0xB0, 0x9A },
	0xD2BF, { 0xF0, 0xA5, 0xB0, 0xB0 },
	0xD2C0, { 0xF0, 0xA5, 0xAF, 0xA3 },
	0xD2C1, { 0xF0, 0xA5, 0xB0, 0x99 },
	0xD2C2, { 0xF0, 0xA5, 0xBB, 0xA9 },
	0xD2C3, { 0xF0, 0xA5, 0xBB, 0xA7 },
	0xD2C4, { 0xE7, 0xB3, 0x8F },
	0xD2C5, { 0xF0, 0xA6, 0x83, 0x96 },
	0xD2C6, { 0xF0, 0xA6, 0x83, 0x84 },
	0xD2C7, { 0xE4, 0x8C, 0x88 },
	0xD2C8, { 0xF0, 0xA6, 0x82, 0x87 },
	0xD2C9, { 0xE4, 0x8C, 0x86 },
	0xD2CA, { 0xF0, 0xA6, 0x83, 0x87 },
	0xD2CB, { 0xF0, 0xA6, 0x83, 0x99 },
	0xD2CC, { 0xE7, 0xB8, 0x98 },
	0xD2CD, { 0xF0, 0xA6, 0x83, 0x9F },
	0xD2CE, { 0xE4, 0x8D, 0x8D },
	0xD2CF, { 0xE4, 0x8D, 0xA1 },
	0xD2D0, { 0xF0, 0xA6, 0x8C, 0x8A },
	0xD2D1, { 0xF0, 0xA6, 0x8C, 0x81 },
	0xD2D2, { 0xF0, 0xA6, 0x8E, 0xB1 },
	0xD2D3, { 0xE4, 0x8D, 0xB8 },
	0xD2D4, { 0xF0, 0xA6, 0x8F, 0x81 },
	0xD2D5, { 0xE4, 0x8E, 0x94 },
	0xD2D6, { 0xE4, 0x8E, 0x95 },
	0xD2D7, { 0xF0, 0xA6, 0x91, 0xB6 },
	0xD2D8, { 0xF0, 0xA6, 0x94, 0x8D },
	0xD2D9, { 0xF0, 0xA6, 0x94, 0x8E },
	0xD2DA, { 0xE4, 0x8F, 0x81 },
	0xD2DB, { 0xE4, 0x8F, 0x83 },
	0xD2DC, { 0xE8, 0x81, 0xAD },
	0xD2DD, { 0xF0, 0xA6, 0xA0, 0x87 },
	0xD2DE, { 0xE4, 0x90, 0xB9 },
	0xD2DF, { 0xF0, 0xA6, 0xA0, 0x89 },
	0xD2E0, { 0xF0, 0xA6, 0xA0, 0x96 },
	0xD2E1, { 0xE4, 0x90, 0xBA },
	0xD2E2, { 0xE4, 0x90, 0xBB },
	0xD2E3, { 0xE4, 0x90, 0xB5 },
	0xD2E4, { 0xE4, 0x90, 0xB6 },
	0xD2E5, { 0xF0, 0xA6, 0xA0, 0x8E },
	0xD2E6, { 0xE4, 0x90, 0xBC },
	0xD2E7, { 0xE8, 0x86, 0x90 },
	0xD2E8, { 0xF0, 0xA6, 0xA0, 0x86 },
	0xD2E9, { 0xF0, 0xA6, 0xA4, 0x9E },
	0xD2EA, { 0xF0, 0xA6, 0xA5, 0x8A },
	0xD2EB, { 0xE4, 0x91, 0x98 },
	0xD2EC, { 0xE4, 0x91, 0xBC },
	0xD2ED, { 0xE4, 0x91, 0xBD },
	0xD2EE, { 0xE4, 0x92, 0x8D },
	0xD2EF, { 0xE4, 0x92, 0x8C },
	0xD2F0, { 0xF0, 0xA6, 0xBA, 0xA6 },
	0xD2F1, { 0xF0, 0xA6, 0xBA, 0x91 },
	0xD2F2, { 0xE4, 0x94, 0xBB },
	0xD2F3, { 0xE4, 0x94, 0xBF },
	0xD2F4, { 0xF0, 0xA6, 0xBA, 0xB8 },
	0xD2F5, { 0xF0, 0xA6, 0xBA, 0x96 },
	0xD2F6, { 0xE4, 0x94, 0xB2 },
	0xD2F7, { 0xE4, 0x94, 0xAD },
	0xD2F8, { 0xF0, 0xA6, 0xBB, 0x85 },
	0xD2F9, { 0xE4, 0x94, 0xAF },
	0xD2FA, { 0xE4, 0x94, 0xB9 },
	0xD2FB, { 0xE4, 0x94, 0xAE },
	0xD2FC, { 0xE4, 0x94, 0xBA },
	0xD2FD, { 0xF0, 0xA6, 0xBC, 0x8A },
	0xD2FE, { 0xE4, 0x94, 0xB6 },
	0xD3A1, { 0xE4, 0x94, 0xB1 },
	0xD3A2, { 0xE4, 0x94, 0xBE },
	0xD3A3, { 0xE4, 0x94, 0xB8 },
	0xD3A4, { 0xE8, 0x95, 0x92 },
	0xD3A5, { 0xE4, 0x94, 0xB4 },
	0xD3A6, { 0xF0, 0xA6, 0xBA, 0xB2 },
	0xD3A7, { 0xE4, 0x95, 0x81 },
	0xD3A8, { 0xF0, 0xA6, 0xBA, 0xB7 },
	0xD3A9, { 0xF0, 0xA6, 0xBA, 0xB4 },
	0xD3AA, { 0xF0, 0xA6, 0xBA, 0x89 },
	0xD3AB, { 0xF0, 0xA6, 0xBA, 0x8D },
	0xD3AC, { 0xE4, 0x94, 0xB0 },
	0xD3AD, { 0xF0, 0xA6, 0xBA, 0x87 },
	0xD3AE, { 0xF0, 0xA6, 0xBB, 0x82 },
	0xD3AF, { 0xF0, 0xA6, 0xBA, 0x9C },
	0xD3B0, { 0xF0, 0xA6, 0xBA, 0x92 },
	0xD3B1, { 0xE4, 0x95, 0x83 },
	0xD3B2, { 0xF0, 0xA6, 0xBB, 0x8A },
	0xD3B3, { 0xE8, 0x95, 0x90 },
	0xD3B4, { 0xF0, 0xA6, 0xBA, 0x8A },
	0xD3B5, { 0xF0, 0xA7, 0x87, 0xA0 },
	0xD3B6, { 0xE4, 0x96, 0x98 },
	0xD3B7, { 0xF0, 0xA7, 0x87, 0xA6 },
	0xD3B8, { 0xF0, 0xA7, 0x87, 0xA5 },
	0xD3B9, { 0xE8, 0x9E, 0xA0 },
	0xD3BA, { 0xF0, 0xA7, 0x8E, 0xA5 },
	0xD3BB, { 0xF0, 0xA7, 0x8E, 0xB3 },
	0xD3BC, { 0xE8, 0x9E, 0x86 },
	0xD3BD, { 0xE4, 0x97, 0x9A },
	0xD3BE, { 0xE4, 0x97, 0x97 },
	0xD3BF, { 0xF0, 0xA7, 0x8E, 0xB5 },
	0xD3C0, { 0xF0, 0xA7, 0x8E, 0xAF },
	0xD3C1, { 0xE8, 0x9E, 0x95 },
	0xD3C2, { 0xF0, 0xA7, 0x8E, 0xB0 },
	0xD3C3, { 0xF0, 0xA7, 0x8F, 0x8C },
	0xD3C4, { 0xE8, 0x9E, 0x8C },
	0xD3C5, { 0xF0, 0xA7, 0x8E, 0xA2 },
	0xD3C6, { 0xF0, 0xA7, 0x8E, 0xBE },
	0xD3C7, { 0xF0, 0xA7, 0x8F, 0x86 },
	0xD3C8, { 0xF0, 0xA7, 0x8E, 0xAC },
	0xD3C9, { 0xF0, 0xA7, 0x8E, 0xAE },
	0xD3CA, { 0xE4, 0x98, 0x98 },
	0xD3CB, { 0xE8, 0xA1, 0xA0 },
	0xD3CC, { 0xF0, 0xAF, 0xA7, 0x83 },
	0xD3CD, { 0xF0, 0xA7, 0x9C, 0x88 },
	0xD3CE, { 0xF0, 0xA7, 0x9C, 0x85 },
	0xD3CF, { 0xE4, 0x99, 0x92 },
	0xD3D0, { 0xE8, 0xA4, 0xA8 },
	0xD3D1, { 0xF0, 0xA7, 0x9B, 0xBE },
	0xD3D2, { 0xE4, 0x99, 0x8E },
	0xD3D3, { 0xE8, 0xA4, 0xA0 },
	0xD3D4, { 0xF0, 0xA7, 0x9C, 0x80 },
	0xD3D5, { 0xE4, 0x99, 0x8F },
	0xD3D6, { 0xE4, 0x99, 0x90 },
	0xD3D7, { 0xF0, 0xA7, 0xA1, 0xA4 },
	0xD3D8, { 0xF0, 0xA7, 0xA1, 0xA8 },
	0xD3D9, { 0xE8, 0xA6, 0xA8 },
	0xD3DA, { 0xE4, 0x9A, 0x86 },
	0xD3DB, { 0xE4, 0x9A, 0x87 },
	0xD3DC, { 0xE4, 0x9A, 0x89 },
	0xD3DD, { 0xF0, 0xA7, 0xA1, 0xAA },
	0xD3DE, { 0xF0, 0xA7, 0xA1, 0xA9 },
	0xD3DF, { 0xF0, 0xA7, 0xA4, 0x8D },
	0xD3E0, { 0xF0, 0xA7, 0xA4, 0x92 },
	0xD3E1, { 0xE4, 0x9A, 0xA2 },
	0xD3E2, { 0xE4, 0x9A, 0xA3 },
	0xD3E3, { 0xF0, 0xA7, 0xA4, 0x8F },
	0xD3E4, { 0xE4, 0x9A, 0xA1 },
	0xD3E5, { 0xF0, 0xA7, 0xA9, 0xA7 },
	0xD3E6, { 0xF0, 0xA7, 0xA9, 0xB9 },
	0xD3E7, { 0xF0, 0xA7, 0xA9, 0xB2 },
	0xD3E8, { 0xF0, 0xA7, 0xA9, 0xA6 },
	0xD3E9, { 0xF0, 0xA7, 0xA9, 0xBC },
	0xD3EA, { 0xE4, 0x9B, 0xB9 },
	0xD3EB, { 0xE4, 0x9B, 0xBD },
	0xD3EC, { 0xF0, 0xA7, 0xA9, 0xA8 },
	0xD3ED, { 0xF0, 0xA7, 0xAA, 0x85 },
	0xD3EE, { 0xF0, 0xA7, 0xA9, 0xB6 },
	0xD3EF, { 0xF0, 0xA7, 0xA9, 0xB4 },
	0xD3F0, { 0xF0, 0xA7, 0xA9, 0xB1 },
	0xD3F1, { 0xF0, 0xA7, 0xA9, 0xA4 },
	0xD3F2, { 0xE4, 0x9C, 0xBE },
	0xD3F3, { 0xE4, 0x9C, 0xBC },
	0xD3F4, { 0xF0, 0xA7, 0xAF, 0xB8 },
	0xD3F5, { 0xE4, 0x9D, 0x8D },
	0xD3F6, { 0xF0, 0xA7, 0xB1, 0xAC },
	0xD3F7, { 0xE4, 0x9D, 0x8E },
	0xD3F8, { 0xF0, 0xA7, 0xB3, 0xAB },
	0xD3F9, { 0xE4, 0x9E, 0x81 },
	0xD3FA, { 0xE4, 0x9E, 0x83 },
	0xD3FB, { 0xE4, 0x9E, 0x82 },
	0xD3FC, { 0xF0, 0xA7, 0xB6, 0xB8 },
	0xD3FD, { 0xE4, 0x9E, 0x80 },
	0xD3FE, { 0xE4, 0x9E, 0x88 },
	0xD4A1, { 0xF0, 0xA7, 0xBC, 0xAD },
	0xD4A2, { 0xF0, 0xA7, 0xBC, 0xAE },
	0xD4A3, { 0xF0, 0xA7, 0xBC, 0xA8 },
	0xD4A4, { 0xF0, 0xA7, 0xBC, 0xA9 },
	0xD4A5, { 0xF0, 0xA7, 0xBC, 0xB1 },
	0xD4A6, { 0xE4, 0x9E, 0xB9 },
	0xD4A7, { 0xF0, 0xA7, 0xBC, 0xAF },
	0xD4A8, { 0xF0, 0xA7, 0xBC, 0xAA },
	0xD4A9, { 0xE8, 0xB8, 0xBA },
	0xD4AA, { 0xF0, 0xA8, 0x82, 0xA4 },
	0xD4AB, { 0xF0, 0xA8, 0x82, 0xB7 },
	0xD4AC, { 0xF0, 0xA8, 0x82, 0xBF },
	0xD4AD, { 0xE4, 0xA0, 0x91 },
	0xD4AE, { 0xE4, 0xA0, 0x8D },
	0xD4AF, { 0xE4, 0xA0, 0x90 },
	0xD4B0, { 0xE4, 0xA0, 0x93 },
	0xD4B1, { 0xF0, 0xA8, 0x89, 0xA3 },
	0xD4B2, { 0xE4, 0xA0, 0xBC },
	0xD4B3, { 0xE4, 0xA1, 0xA2 },
	0xD4B4, { 0xE4, 0xA1, 0xA3 },
	0xD4B5, { 0xF0, 0xA8, 0x8D, 0xA7 },
	0xD4B6, { 0xF0, 0xA8, 0x96, 0xBE },
	0xD4B7, { 0xF0, 0xAF, 0xA7, 0xA0 },
	0xD4B8, { 0xF0, 0xA8, 0x9E, 0x95 },
	0xD4B9, { 0xF0, 0xA8, 0x9E, 0x9C },
	0xD4BA, { 0xE4, 0xA4, 0x83 },
	0xD4BB, { 0xE4, 0xA4, 0x86 },
	0xD4BC, { 0xE4, 0xA4, 0x82 },
	0xD4BD, { 0xE4, 0xA4, 0x81 },
	0xD4BE, { 0xF0, 0xA8, 0xA1, 0xB1 },
	0xD4BF, { 0xF0, 0xA8, 0xA1, 0xB2 },
	0xD4C0, { 0xE4, 0xA4, 0x85 },
	0xD4C1, { 0xF0, 0xA8, 0xA1, 0xAF },
	0xD4C2, { 0xE9, 0x86, 0x94 },
	0xD4C3, { 0xE9, 0x8C, 0x91 },
	0xD4C4, { 0xF0, 0xA8, 0xA7, 0xB1 },
	0xD4C5, { 0xE9, 0x8C, 0xB7 },
	0xD4C6, { 0xE4, 0xA4, 0xB6 },
	0xD4C7, { 0xF0, 0xA8, 0xA7, 0xA8 },
	0xD4C8, { 0xE4, 0xA4, 0xB5 },
	0xD4C9, { 0xE9, 0x8D, 0x83 },
	0xD4CA, { 0xF0, 0xAF, 0xA7, 0xAA },
	0xD4CB, { 0xE4, 0xA6, 0xA1 },
	0xD4CC, { 0xE4, 0xA6, 0xA3 },
	0xD4CD, { 0xF0, 0xA8, 0xB5, 0x89 },
	0xD4CE, { 0xF0, 0xA8, 0xB5, 0xA4 },
	0xD4CF, { 0xE4, 0xA6, 0xA0 },
	0xD4D0, { 0xF0, 0xA8, 0xB5, 0x88 },
	0xD4D1, { 0xE4, 0xA7, 0xAA },
	0xD4D2, { 0xE9, 0x9A, 0xA6 },
	0xD4D3, { 0xE4, 0xA7, 0xA8 },
	0xD4D4, { 0xF0, 0xA8, 0xBC, 0xAC },
	0xD4D5, { 0xF0, 0xA8, 0xBF, 0xA1 },
	0xD4D6, { 0xF0, 0xA8, 0xBF, 0xAF },
	0xD4D7, { 0xF0, 0xA9, 0x83, 0x80 },
	0xD4D8, { 0xE4, 0xA8, 0xA1 },
	0xD4D9, { 0xE4, 0xA8, 0x9B },
	0xD4DA, { 0xF0, 0xA9, 0x83, 0x97 },
	0xD4DB, { 0xF0, 0xA9, 0x83, 0x94 },
	0xD4DC, { 0xE4, 0xA9, 0x89 },
	0xD4DD, { 0xE4, 0xA9, 0x88 },
	0xD4DE, { 0xF0, 0xA9, 0x8A, 0xAD },
	0xD4DF, { 0xE9, 0x9E, 0x95 },
	0xD4E0, { 0xE4, 0xA9, 0xA2 },
	0xD4E1, { 0xE4, 0xA9, 0xA1 },
	0xD4E2, { 0xE4, 0xA9, 0xA4 },
	0xD4E3, { 0xE4, 0xA9, 0xA0 },
	0xD4E4, { 0xE4, 0xA9, 0xA3 },
	0xD4E5, { 0xF0, 0xA9, 0x8A, 0xAE },
	0xD4E6, { 0xF0, 0xA9, 0x8A, 0xAC },
	0xD4E7, { 0xE9, 0x9E, 0x96 },
	0xD4E8, { 0xE4, 0xA9, 0xA6 },
	0xD4E9, { 0xE4, 0xAA, 0xAC },
	0xD4EA, { 0xE4, 0xAA, 0xAB },
	0xD4EB, { 0xF0, 0xA9, 0x90, 0xA7 },
	0xD4EC, { 0xF0, 0xA9, 0x92, 0xAE },
	0xD4ED, { 0xE4, 0xAB, 0x83 },
	0xD4EE, { 0xF0, 0xA9, 0x92, 0xB0 },
	0xD4EF, { 0xE4, 0xAB, 0x84 },
	0xD4F0, { 0xE9, 0xA0, 0xA5 },
	0xD4F1, { 0xF0, 0xA9, 0x93, 0x80 },
	0xD4F2, { 0xF0, 0xA9, 0x93, 0x84 },
	0xD4F3, { 0xE4, 0xAC, 0x88 },
	0xD4F4, { 0xE4, 0xAC, 0x89 },
	0xD4F5, { 0xE4, 0xAC, 0x8A },
	0xD4F6, { 0xE4, 0xAC, 0x86 },
	0xD4F7, { 0xE4, 0xAC, 0x87 },
	0xD4F8, { 0xE4, 0xAD, 0x81 },
	0xD4F9, { 0xF0, 0xA9, 0x9C, 0x87 },
	0xD4FA, { 0xE4, 0xAD, 0x85 },
	0xD4FB, { 0xF0, 0xA9, 0x9B, 0xBD },
	0xD4FC, { 0xE4, 0xAD, 0x83 },
	0xD4FD, { 0xE4, 0xAD, 0x84 },
	0xD4FE, { 0xE9, 0xA4, 0xA6 },
	0xD5A1, { 0xE9, 0xA4, 0xB4 },
	0xD5A2, { 0xE4, 0xAD, 0x87 },
	0xD5A3, { 0xF0, 0xAF, 0xA8, 0x84 },
	0xD5A4, { 0xF0, 0xA9, 0xA0, 0x9B },
	0xD5A5, { 0xF0, 0xA9, 0xA0, 0x9C },
	0xD5A6, { 0xE4, 0xAD, 0xB1 },
	0xD5A7, { 0xF0, 0xA9, 0xA2, 0xB2 },
	0xD5A8, { 0xF0, 0xA9, 0xA2, 0xB4 },
	0xD5A9, { 0xF0, 0xA9, 0xA2, 0xB7 },
	0xD5AA, { 0xF0, 0xA9, 0xA2, 0xB1 },
	0xD5AB, { 0xF0, 0xA9, 0xA2, 0xB3 },
	0xD5AC, { 0xF0, 0xA9, 0xA2, 0xAE },
	0xD5AD, { 0xE4, 0xAE, 0x8B },
	0xD5AE, { 0xE4, 0xAF, 0x94 },
	0xD5AF, { 0xE4, 0xAF, 0x93 },
	0xD5B0, { 0xE4, 0xAF, 0x91 },
	0xD5B1, { 0xE9, 0xAA, 0xBA },
	0xD5B2, { 0xE4, 0xAF, 0x92 },
	0xD5B3, { 0xF0, 0xA9, 0xA8, 0xBF },
	0xD5B4, { 0xF0, 0xA9, 0xAC, 0xB6 },
	0xD5B5, { 0xE4, 0xAF, 0xB7 },
	0xD5B6, { 0xE4, 0xAF, 0xB8 },
	0xD5B7, { 0xF0, 0xA9, 0xAC, 0xB1 },
	0xD5B8, { 0xF0, 0xA9, 0xAC, 0xBB },
	0xD5B9, { 0xF0, 0xA9, 0xAC, 0xB5 },
	0xD5BA, { 0xF0, 0xA9, 0xAC, 0xBA },
	0xD5BB, { 0xF0, 0xA9, 0xAC, 0xB7 },
	0xD5BC, { 0xF0, 0xA9, 0xB0, 0xA2 },
	0xD5BD, { 0xF0, 0xA9, 0xB0, 0xB6 },
	0xD5BE, { 0xF0, 0xA9, 0xB0, 0xB2 },
	0xD5BF, { 0xE4, 0xB0, 0xA2 },
	0xD5C0, { 0xF0, 0xA9, 0xB3, 0x80 },
	0xD5C1, { 0xE4, 0xB1, 0x85 },
	0xD5C2, { 0xE4, 0xB1, 0x81 },
	0xD5C3, { 0xE9, 0xAE, 0x81 },
	0xD5C4, { 0xE4, 0xB1, 0x80 },
	0xD5C5, { 0xE9, 0xAE, 0x8A },
	0xD5C6, { 0xF0, 0xA9, 0xB6, 0x85 },
	0xD5C7, { 0xE9, 0xAD, 0xBF },
	0xD5C8, { 0xE4, 0xB1, 0x82 },
	0xD5C9, { 0xF0, 0xA9, 0xB6, 0x89 },
	0xD5CA, { 0xE4, 0xB3, 0x81 },
	0xD5CB, { 0xE4, 0xB3, 0x85 },
	0xD5CC, { 0xF0, 0xA9, 0xBF, 0xA1 },
	0xD5CD, { 0xE4, 0xB2, 0xBB },
	0xD5CE, { 0xE4, 0xB2, 0xB9 },
	0xD5CF, { 0xE4, 0xB2, 0xBD },
	0xD5D0, { 0xE4, 0xB3, 0x89 },
	0xD5D1, { 0xF0, 0xAA, 0x80, 0x8A },
	0xD5D2, { 0xE9, 0xB4, 0x91 },
	0xD5D3, { 0xF0, 0xAA, 0x80, 0x89 },
	0xD5D4, { 0xE4, 0xB2, 0xBF },
	0xD5D5, { 0xE4, 0xB3, 0x87 },
	0xD5D6, { 0xF0, 0xA9, 0xBF, 0xA8 },
	0xD5D7, { 0xE4, 0xB3, 0x83 },
	0xD5D8, { 0xE4, 0xB4, 0xA4 },
	0xD5D9, { 0xE4, 0xB4, 0xB1 },
	0xD5DA, { 0xE4, 0xB4, 0xB3 },
	0xD5DB, { 0xF0, 0xAA, 0x8C, 0x98 },
	0xD5DC, { 0xE4, 0xB4, 0xB2 },
	0xD5DD, { 0xE4, 0xB4, 0xB4 },
	0xD5DE, { 0xE4, 0xB5, 0x92 },
	0xD5DF, { 0xE4, 0xB5, 0xA1 },
	0xD5E0, { 0xE9, 0xBB, 0x99 },
	0xD5E1, { 0xE4, 0xB5, 0xBA },
	0xD5E2, { 0xE4, 0xB6, 0x82 },
	0xD5E3, { 0xE9, 0xBC, 0xBC },
	0xD5E4, { 0xF0, 0xAA, 0x97, 0x85 },
	0xD5E5, { 0xE5, 0x84, 0xA3 },
	0xD5E6, { 0xF0, 0xA0, 0x90, 0x8D },
	0xD5E7, { 0xF0, 0xA0, 0x90, 0x8C },
	0xD5E8, { 0xF0, 0xA0, 0x90, 0xA1 },
	0xD5E9, { 0xE5, 0x84, 0xAC },
	0xD5EA, { 0xF0, 0xA0, 0x98, 0x96 },
	0xD5EB, { 0xF0, 0xA0, 0xA0, 0x8E },
	0xD5EC, { 0xE3, 0x94, 0x8F },
	0xD5ED, { 0xE5, 0x8A, 0x95 },
	0xD5EE, { 0xF0, 0xA0, 0xA0, 0x97 },
	0xD5EF, { 0xE3, 0x94, 0xA3 },
	0xD5F0, { 0xE3, 0x94, 0xA5 },
	0xD5F1, { 0xF0, 0xA1, 0x81, 0x88 },
	0xD5F2, { 0xE3, 0x98, 0x86 },
	0xD5F3, { 0xE3, 0x98, 0x88 },
	0xD5F4, { 0xE5, 0x9A, 0x88 },
	0xD5F5, { 0xF0, 0xA1, 0x81, 0x95 },
	0xD5F6, { 0xF0, 0xA1, 0x81, 0x89 },
	0xD5F7, { 0xF0, 0xA1, 0x81, 0x8C },
	0xD5F8, { 0xE5, 0x9A, 0x8B },
	0xD5F9, { 0xF0, 0xA1, 0x81, 0x8F },
	0xD5FA, { 0xF0, 0xA1, 0x80, 0xBD },
	0xD5FB, { 0xE3, 0x99, 0xBA },
	0xD5FC, { 0xE3, 0x99, 0xB7 },
	0xD5FD, { 0xF0, 0xA1, 0x92, 0x8A },
	0xD5FE, { 0xF0, 0xA1, 0x92, 0xA8 },
	0xD6A1, { 0xF0, 0xA1, 0x9A, 0x8A },
	0xD6A2, { 0xE3, 0x9C, 0xAE },
	0xD6A3, { 0xF0, 0xA1, 0xA3, 0x8B },
	0xD6A4, { 0xE3, 0x9C, 0xAF },
	0xD6A5, { 0xF0, 0xA1, 0xA3, 0x95 },
	0xD6A6, { 0xF0, 0xA2, 0x87, 0x94 },
	0xD6A7, { 0xE3, 0xA0, 0x9B },
	0xD6A8, { 0xE3, 0xA0, 0x93 },
	0xD6A9, { 0xF0, 0xA1, 0xBD, 0x9C },
	0xD6AA, { 0xF0, 0xA1, 0xBD, 0xB5 },
	0xD6AB, { 0xE3, 0xA1, 0xA6 },
	0xD6AC, { 0xF0, 0xA2, 0x85, 0xA1 },
	0xD6AD, { 0xE3, 0xA1, 0xA5 },
	0xD6AE, { 0xF0, 0xA1, 0x9A, 0x96 },
	0xD6AF, { 0xE3, 0xA3, 0xB7 },
	0xD6B0, { 0xF0, 0xA2, 0x96, 0x8A },
	0xD6B1, { 0xF0, 0xA2, 0xA3, 0x90 },
	0xD6B2, { 0xE6, 0x87, 0xA1 },
	0xD6B3, { 0xE6, 0x87, 0x97 },
	0xD6B4, { 0xF0, 0xA2, 0xA1, 0x89 },
	0xD6B5, { 0xF0, 0xA2, 0xA3, 0x8F },
	0xD6B6, { 0xE3, 0xA6, 0x9C },
	0xD6B7, { 0xF0, 0xA2, 0xB7, 0x96 },
	0xD6B8, { 0xF0, 0xA2, 0xB5, 0xBF },
	0xD6B9, { 0xE3, 0xA9, 0x93 },
	0xD6BA, { 0xF0, 0xA2, 0xB7, 0x92 },
	0xD6BB, { 0xF0, 0xA2, 0xB7, 0x8F },
	0xD6BC, { 0xF0, 0xA3, 0x80, 0x86 },
	0xD6BD, { 0xF0, 0xA3, 0x80, 0x89 },
	0xD6BE, { 0xE3, 0xAA, 0xBA },
	0xD6BF, { 0xE6, 0x96, 0xA3 },
	0xD6C0, { 0xE3, 0xAC, 0xA2 },
	0xD6C1, { 0xE6, 0x9B, 0x93 },
	0xD6C2, { 0xF0, 0xA3, 0x9C, 0x86 },
	0xD6C3, { 0xF0, 0xA3, 0x9B, 0xB1 },
	0xD6C4, { 0xF0, 0xA3, 0x9C, 0x84 },
	0xD6C5, { 0xE6, 0xAA, 0x8B },
	0xD6C6, { 0xF0, 0xA3, 0x9B, 0xBA },
	0xD6C7, { 0xF0, 0xA3, 0x9B, 0xB4 },
	0xD6C8, { 0xE3, 0xAF, 0xAB },
	0xD6C9, { 0xE3, 0xAF, 0x9D },
	0xD6CA, { 0xF0, 0xA3, 0x9B, 0xB9 },
	0xD6CB, { 0xE3, 0xAF, 0xAF },
	0xD6CC, { 0xF0, 0xA3, 0x9A, 0x8B },
	0xD6CD, { 0xF0, 0xA3, 0x9C, 0x83 },
	0xD6CE, { 0xE3, 0xB1, 0x87 },
	0xD6CF, { 0xE3, 0xB1, 0x86 },
	0xD6D0, { 0xF0, 0xA3, 0xA6, 0xA2 },
	0xD6D1, { 0xE3, 0xB1, 0xB8 },
	0xD6D2, { 0xE6, 0xAE, 0xAC },
	0xD6D3, { 0xE3, 0xB2, 0x89 },
	0xD6D4, { 0xF0, 0xA3, 0xB0, 0x8C },
	0xD6D5, { 0xF0, 0xA3, 0xB0, 0x8B },
	0xD6D6, { 0xE3, 0xB5, 0xA8 },
	0xD6D7, { 0xE3, 0xB5, 0xB6 },
	0xD6D8, { 0xE3, 0xB5, 0xB4 },
	0xD6D9, { 0xE3, 0xB5, 0xB9 },
	0xD6DA, { 0xF0, 0xA4, 0x80, 0xA4 },
	0xD6DB, { 0xE3, 0xB5, 0xBA },
	0xD6DC, { 0xE3, 0xB5, 0xB7 },
	0xD6DD, { 0xF0, 0xAF, 0xA4, 0x94 },
	0xD6DE, { 0xE3, 0xB5, 0xB1 },
	0xD6DF, { 0xF0, 0xA4, 0x80, 0xA5 },
	0xD6E0, { 0xE3, 0xB5, 0xB2 },
	0xD6E1, { 0xF0, 0xA4, 0x8F, 0xB6 },
	0xD6E2, { 0xE3, 0xB7, 0xBF },
	0xD6E3, { 0xF0, 0xA4, 0x8F, 0xBB },
	0xD6E4, { 0xE3, 0xB8, 0x85 },
	0xD6E5, { 0xF0, 0xA4, 0x94, 0xB2 },
	0xD6E6, { 0xF0, 0xA4, 0x97, 0xBB },
	0xD6E7, { 0xE3, 0xB9, 0x94 },
	0xD6E8, { 0xF0, 0xA4, 0x9B, 0xB2 },
	0xD6E9, { 0xF0, 0xA4, 0x9B, 0xB3 },
	0xD6EA, { 0xE3, 0xBA, 0x9E },
	0xD6EB, { 0xE3, 0xBA, 0x9F },
	0xD6EC, { 0xE7, 0x8D, 0xB4 },
	0xD6ED, { 0xF0, 0xA4, 0xA2, 0x9C },
	0xD6EE, { 0xF0, 0xA4, 0xA9, 0xB2 },
	0xD6EF, { 0xE3, 0xBB, 0xBA },
	0xD6F0, { 0xF0, 0xA4, 0xA9, 0xB4 },
	0xD6F1, { 0xE3, 0xBD, 0x84 },
	0xD6F2, { 0xE3, 0xBC, 0xBF },
	0xD6F3, { 0xE3, 0xBD, 0x80 },
	0xD6F4, { 0xF0, 0xA4, 0xAE, 0x86 },
	0xD6F5, { 0xE3, 0xBD, 0x82 },
	0xD6F6, { 0xF0, 0xA4, 0xAE, 0x8E },
	0xD6F7, { 0xF0, 0xA4, 0xAE, 0x90 },
	0xD6F8, { 0xE3, 0xBD, 0x91 },
	0xD6F9, { 0xF0, 0xA4, 0xAF, 0x8D },
	0xD6FA, { 0xF0, 0xA4, 0xAF, 0xB7 },
	0xD6FB, { 0xF0, 0xA4, 0xB3, 0x96 },
	0xD6FC, { 0xF0, 0xA4, 0xBA, 0x84 },
	0xD6FD, { 0xF0, 0xA4, 0xBA, 0x95 },
	0xD6FE, { 0xF0, 0xA4, 0xBA, 0x8A },
	0xD7A1, { 0xE7, 0x99, 0x80 },
	0xD7A2, { 0xE3, 0xBF, 0x8A },
	0xD7A3, { 0xF0, 0xA4, 0xBA, 0x97 },
	0xD7A4, { 0xE7, 0x99, 0x81 },
	0xD7A5, { 0xE3, 0xBF, 0x8E },
	0xD7A6, { 0xE3, 0xBF, 0x89 },
	0xD7A7, { 0xF0, 0xA4, 0xBE, 0xA0 },
	0xD7A8, { 0xF0, 0xA4, 0xBE, 0xA1 },
	0xD7A9, { 0xF0, 0xA5, 0x80, 0xA2 },
	0xD7AA, { 0xF0, 0xA5, 0x82, 0xA6 },
	0xD7AB, { 0xF0, 0xA5, 0x82, 0xA4 },
	0xD7AC, { 0xE4, 0x80, 0x89 },
	0xD7AD, { 0xE7, 0x9B, 0xA8 },
	0xD7AE, { 0xE4, 0x81, 0xAC },
	0xD7AF, { 0xE4, 0x81, 0xAE },
	0xD7B0, { 0xE4, 0x81, 0xB0 },
	0xD7B1, { 0xE4, 0x81, 0xAD },
	0xD7B2, { 0xE4, 0x81, 0xAB },
	0xD7B3, { 0xE4, 0x81, 0xB1 },
	0xD7B4, { 0xE4, 0x81, 0xB2 },
	0xD7B5, { 0xF0, 0xA5, 0x8A, 0xAF },
	0xD7B6, { 0xF0, 0xA5, 0x8A, 0xB0 },
	0xD7B7, { 0xF0, 0xA5, 0x8A, 0xBD },
	0xD7B8, { 0xE4, 0x82, 0x8C },
	0xD7B9, { 0xE4, 0x83, 0xA4 },
	0xD7BA, { 0xF0, 0xA5, 0x95, 0xB6 },
	0xD7BB, { 0xE4, 0x83, 0xA1 },
	0xD7BC, { 0xF0, 0xA5, 0x95, 0xBB },
	0xD7BD, { 0xF0, 0xA5, 0x95, 0xB9 },
	0xD7BE, { 0xE7, 0xA3, 0xB6 },
	0xD7BF, { 0xE4, 0x83, 0xA7 },
	0xD7C0, { 0xE7, 0xA4, 0x80 },
	0xD7C1, { 0xE4, 0x83, 0xA2 },
	0xD7C2, { 0xE4, 0x84, 0x9F },
	0xD7C3, { 0xF0, 0xA5, 0x9B, 0xAE },
	0xD7C4, { 0xF0, 0xA5, 0x9B, 0xB1 },
	0xD7C5, { 0xE4, 0x85, 0xBE },
	0xD7C6, { 0xF0, 0xA5, 0xA2, 0x94 },
	0xD7C7, { 0xE4, 0x86, 0x80 },
	0xD7C8, { 0xE7, 0xA9, 0x99 },
	0xD7C9, { 0xE7, 0xA9, 0x95 },
	0xD7CA, { 0xF0, 0xA5, 0xA2, 0x91 },
	0xD7CB, { 0xE4, 0x86, 0xB9 },
	0xD7CC, { 0xE4, 0x86, 0xB7 },
	0xD7CD, { 0xE4, 0x86, 0xB8 },
	0xD7CE, { 0xF0, 0xA5, 0xA8, 0x90 },
	0xD7CF, { 0xE4, 0x86, 0xBA },
	0xD7D0, { 0xE7, 0xAB, 0xB4 },
	0xD7D1, { 0xF0, 0xA5, 0xAA, 0xAF },
	0xD7D2, { 0xE4, 0x87, 0x93 },
	0xD7D3, { 0xE4, 0x88, 0xBF },
	0xD7D4, { 0xE7, 0xB0, 0x84 },
	0xD7D5, { 0xE4, 0x89, 0x85 },
	0xD7D6, { 0xE4, 0x89, 0x81 },
	0xD7D7, { 0xE7, 0xB0, 0x95 },
	0xD7D8, { 0xE4, 0x89, 0x82 },
	0xD7D9, { 0xE4, 0x89, 0x83 },
	0xD7DA, { 0xE4, 0x88, 0xBB },
	0xD7DB, { 0xE4, 0x88, 0xB8 },
	0xD7DC, { 0xF0, 0xA5, 0xB1, 0xBB },
	0xD7DD, { 0xF0, 0xA5, 0xB1, 0xB7 },
	0xD7DE, { 0xE4, 0x88, 0xBA },
	0xD7DF, { 0xE7, 0xAF, 0xB5 },
	0xD7E0, { 0xF0, 0xA5, 0xB2, 0x80 },
	0xD7E1, { 0xF0, 0xA5, 0xB3, 0x86 },
	0xD7E2, { 0xE4, 0x88, 0xBC },
	0xD7E3, { 0xF0, 0xA5, 0xB1, 0xBC },
	0xD7E4, { 0xF0, 0xA5, 0xB2, 0x90 },
	0xD7E5, { 0xE4, 0x88, 0xBE },
	0xD7E6, { 0xF0, 0xA5, 0xB2, 0xA3 },
	0xD7E7, { 0xF0, 0xA5, 0xB1, 0xBD },
	0xD7E8, { 0xF0, 0xA5, 0xB2, 0xBD },
	0xD7E9, { 0xE4, 0x8A, 0x9E },
	0xD7EA, { 0xE4, 0x8A, 0x9F },
	0xD7EB, { 0xE4, 0x8A, 0xA1 },
	0xD7EC, { 0xF0, 0xA5, 0xBC, 0x93 },
	0xD7ED, { 0xE4, 0x8A, 0x9B },
	0xD7EE, { 0xE4, 0x8C, 0x92 },
	0xD7EF, { 0xF0, 0xA6, 0x84, 0x91 },
	0xD7F0, { 0xF0, 0xA6, 0x85, 0x84 },
	0xD7F1, { 0xF0, 0xA6, 0x84, 0x8D },
	0xD7F2, { 0xE4, 0x8C, 0x98 },
	0xD7F3, { 0xE4, 0x8C, 0x8C },
	0xD7F4, { 0xF0, 0xA6, 0x8C, 0x94 },
	0xD7F5, { 0xE4, 0x8D, 0xA2 },
	0xD7F6, { 0xF0, 0xA6, 0x8E, 0xB8 },
	0xD7F7, { 0xE4, 0x8D, 0xBA },
	0xD7F8, { 0xF0, 0xA6, 0x8E, 0xB7 },
	0xD7F9, { 0xF0, 0xA6, 0x92, 0x83 },
	0xD7FA, { 0xE4, 0x8E, 0xAE },
	0xD7FB, { 0xE4, 0x8E, 0xAF },
	0xD7FC, { 0xF0, 0xA6, 0x94, 0x94 },
	0xD7FD, { 0xE4, 0x8E, 0xAD },
	0xD7FE, { 0xF0, 0xA6, 0x94, 0x9C },
	0xD8A1, { 0xE4, 0x8F, 0x84 },
	0xD8A2, { 0xE4, 0x8F, 0x87 },
	0xD8A3, { 0xE4, 0x8F, 0x86 },
	0xD8A4, { 0xE4, 0x8F, 0x85 },
	0xD8A5, { 0xF0, 0xA6, 0x97, 0x94 },
	0xD8A6, { 0xF0, 0xA6, 0x97, 0x95 },
	0xD8A7, { 0xE8, 0x87, 0x81 },
	0xD8A8, { 0xE4, 0x91, 0x80 },
	0xD8A9, { 0xF0, 0xA6, 0xA1, 0x83 },
	0xD8AA, { 0xF0, 0xA6, 0xA1, 0x82 },
	0xD8AB, { 0xE4, 0x90, 0xBF },
	0xD8AC, { 0xE4, 0x91, 0x81 },
	0xD8AD, { 0xF0, 0xAF, 0xA6, 0x8A },
	0xD8AE, { 0xF0, 0xA6, 0xA1, 0x81 },
	0xD8AF, { 0xF0, 0xA6, 0xA5, 0x8E },
	0xD8B0, { 0xE4, 0x91, 0xBF },
	0xD8B1, { 0xF0, 0xA6, 0xAA, 0x87 },
	0xD8B2, { 0xE4, 0x92, 0x86 },
	0xD8B3, { 0xE4, 0x92, 0x81 },
	0xD8B4, { 0xE4, 0x92, 0x80 },
	0xD8B5, { 0xE4, 0x92, 0x8E },
	0xD8B6, { 0xE4, 0x95, 0x8A },
	0xD8B7, { 0xF0, 0xA6, 0xBC, 0xB9 },
	0xD8B8, { 0xE4, 0x95, 0x87 },
	0xD8B9, { 0xF0, 0xA6, 0xBE, 0x8F },
	0xD8BA, { 0xF0, 0xA6, 0xBC, 0xAA },
	0xD8BB, { 0xE4, 0x95, 0x8B },
	0xD8BC, { 0xE4, 0x95, 0x86 },
	0xD8BD, { 0xE4, 0x95, 0x8E },
	0xD8BE, { 0xE8, 0x95, 0xBD },
	0xD8BF, { 0xF0, 0xA6, 0xBC, 0xAB },
	0xD8C0, { 0xE8, 0x96, 0xA5 },
	0xD8C1, { 0xF0, 0xA6, 0xBD, 0x90 },
	0xD8C2, { 0xE4, 0x95, 0x88 },
	0xD8C3, { 0xF0, 0xA6, 0xBD, 0xAE },
	0xD8C4, { 0xE4, 0x95, 0x85 },
	0xD8C5, { 0xF0, 0xA6, 0xBC, 0xBB },
	0xD8C6, { 0xF0, 0xA6, 0xBD, 0x93 },
	0xD8C7, { 0xF0, 0xA6, 0xBD, 0x9F },
	0xD8C8, { 0xF0, 0xA6, 0xBC, 0xAF },
	0xD8C9, { 0xF0, 0xA6, 0xBC, 0xB0 },
	0xD8CA, { 0xF0, 0xA6, 0xBC, 0xB8 },
	0xD8CB, { 0xF0, 0xA6, 0xBD, 0x8C },
	0xD8CC, { 0xF0, 0xA7, 0x87, 0xB1 },
	0xD8CD, { 0xE4, 0x97, 0x9B },
	0xD8CE, { 0xE4, 0x97, 0xA7 },
	0xD8CF, { 0xE4, 0x97, 0xA4 },
	0xD8D0, { 0xF0, 0xA7, 0x90, 0x87 },
	0xD8D1, { 0xF0, 0xA7, 0x90, 0x96 },
	0xD8D2, { 0xE4, 0x97, 0xA1 },
	0xD8D3, { 0xF0, 0xA7, 0x90, 0x94 },
	0xD8D4, { 0xE4, 0x97, 0xA9 },
	0xD8D5, { 0xF0, 0xA7, 0x8F, 0xBB },
	0xD8D6, { 0xE4, 0x97, 0xA5 },
	0xD8D7, { 0xE4, 0x97, 0xA0 },
	0xD8D8, { 0xE4, 0x97, 0xA3 },
	0xD8D9, { 0xF0, 0xA7, 0x8F, 0xB8 },
	0xD8DA, { 0xF0, 0xA7, 0x90, 0x90 },
	0xD8DB, { 0xF0, 0xA7, 0x90, 0x9D },
	0xD8DC, { 0xF0, 0xA7, 0x8F, 0xBF },
	0xD8DD, { 0xF0, 0xA7, 0x90, 0x8B },
	0xD8DE, { 0xF0, 0xA7, 0x90, 0x84 },
	0xD8DF, { 0xE4, 0x97, 0xAA },
	0xD8E0, { 0xF0, 0xA7, 0x8F, 0xBE },
	0xD8E1, { 0xF0, 0xA7, 0x97, 0xBF },
	0xD8E2, { 0xE8, 0xA4, 0xBA },
	0xD8E3, { 0xE4, 0x99, 0x94 },
	0xD8E4, { 0xE4, 0x99, 0x98 },
	0xD8E5, { 0xE4, 0x99, 0x9C },
	0xD8E6, { 0xF0, 0xA7, 0x9C, 0xA3 },
	0xD8E7, { 0xE4, 0x99, 0x95 },
	0xD8E8, { 0xE4, 0x9A, 0x8B },
	0xD8E9, { 0xE4, 0x9A, 0x8C },
	0xD8EA, { 0xE4, 0x9A, 0xA6 },
	0xD8EB, { 0xE4, 0x9A, 0xA5 },
	0xD8EC, { 0xF0, 0xA7, 0xA4, 0xAA },
	0xD8ED, { 0xF0, 0xA7, 0xAA, 0xA0 },
	0xD8EE, { 0xF0, 0xA7, 0xAA, 0x98 },
	0xD8EF, { 0xF0, 0xA7, 0xAA, 0x9C },
	0xD8F0, { 0xE4, 0x9B, 0xBF },
	0xD8F1, { 0xF0, 0xA7, 0xAA, 0x9E },
	0xD8F2, { 0xF0, 0xA7, 0xAA, 0xA6 },
	0xD8F3, { 0xF0, 0xA7, 0xAA, 0xB5 },
	0xD8F4, { 0xF0, 0xA7, 0xAA, 0xB0 },
	0xD8F5, { 0xE4, 0x9C, 0xB0 },
	0xD8F6, { 0xE4, 0x9D, 0x80 },
	0xD8F7, { 0xE4, 0x9D, 0x81 },
	0xD8F8, { 0xF0, 0xA7, 0xB3, 0xB9 },
	0xD8F9, { 0xF0, 0xA7, 0xB3, 0xB5 },
	0xD8FA, { 0xE4, 0x9E, 0x86 },
	0xD8FB, { 0xF0, 0xA7, 0xB7, 0x92 },
	0xD8FC, { 0xE4, 0x9E, 0xBF },
	0xD8FD, { 0xE4, 0x9E, 0xBD },
	0xD8FE, { 0xF0, 0xA7, 0xBD, 0x90 },
	0xD9A1, { 0xF0, 0xA7, 0xBD, 0x8E },
	0xD9A2, { 0xF0, 0xA7, 0xBD, 0x8B },
	0xD9A3, { 0xF0, 0xA7, 0xBD, 0x92 },
	0xD9A4, { 0xF0, 0xA7, 0xBD, 0x8D },
	0xD9A5, { 0xE4, 0x9E, 0xBE },
	0xD9A6, { 0xE4, 0xA0, 0x99 },
	0xD9A7, { 0xF0, 0xA8, 0x83, 0xA4 },
	0xD9A8, { 0xE4, 0xA0, 0x9C },
	0xD9A9, { 0xF0, 0xA8, 0x83, 0x9A },
	0xD9AA, { 0xE4, 0xA0, 0x9B },
	0xD9AB, { 0xE4, 0xA0, 0x97 },
	0xD9AC, { 0xE4, 0xA0, 0x98 },
	0xD9AD, { 0xE8, 0xB9, 0x91 },
	0xD9AE, { 0xF0, 0xA8, 0x83, 0x9F },
	0xD9AF, { 0xF0, 0xA8, 0x83, 0xA8 },
	0xD9B0, { 0xE4, 0xA0, 0xBD },
	0xD9B1, { 0xE4, 0xA1, 0xAA },
	0xD9B2, { 0xE4, 0xA1, 0xA6 },
	0xD9B3, { 0xF0, 0xA8, 0x8D, 0xB0 },
	0xD9B4, { 0xF0, 0xA8, 0x8D, 0xB2 },
	0xD9B5, { 0xE4, 0xA1, 0xA7 },
	0xD9B6, { 0xF0, 0xA8, 0x8D, 0xB7 },
	0xD9B7, { 0xE4, 0xA1, 0xA8 },
	0xD9B8, { 0xE4, 0xA2, 0xAD },
	0xD9B9, { 0xE4, 0xA2, 0xAE },
	0xD9BA, { 0xF0, 0xA8, 0x97, 0xA6 },
	0xD9BB, { 0xF0, 0xA8, 0x9E, 0xAA },
	0xD9BC, { 0xE4, 0xA3, 0x96 },
	0xD9BD, { 0xE4, 0xA4, 0x89 },
	0xD9BE, { 0xF0, 0xA8, 0xA2, 0x8C },
	0xD9BF, { 0xE9, 0x86, 0x98 },
	0xD9C0, { 0xF0, 0xA8, 0xA2, 0x89 },
	0xD9C1, { 0xE4, 0xA4, 0x8C },
	0xD9C2, { 0xE4, 0xA4, 0x8A },
	0xD9C3, { 0xF0, 0xA8, 0xA8, 0xB2 },
	0xD9C4, { 0xE4, 0xA4, 0xBB },
	0xD9C5, { 0xE4, 0xA4, 0xBA },
	0xD9C6, { 0xE9, 0x8E, 0x84 },
	0xD9C7, { 0xE9, 0x8E, 0x81 },
	0xD9C8, { 0xF0, 0xA8, 0xA9, 0xBA },
	0xD9C9, { 0xE9, 0x8D, 0xAF },
	0xD9CA, { 0xF0, 0xA8, 0xB2, 0x9E },
	0xD9CB, { 0xF0, 0xA8, 0xB2, 0xA0 },
	0xD9CC, { 0xF0, 0xA8, 0xB5, 0xB0 },
	0xD9CD, { 0xE4, 0xA6, 0xAF },
	0xD9CE, { 0xE4, 0xA6, 0xAA },
	0xD9CF, { 0xE4, 0xA6, 0xAB },
	0xD9D0, { 0xF0, 0xA8, 0xB5, 0xAE },
	0xD9D1, { 0xF0, 0xA8, 0xB5, 0xA6 },
	0xD9D2, { 0xE4, 0xA6, 0xB1 },
	0xD9D3, { 0xF0, 0xA8, 0xB5, 0xA5 },
	0xD9D4, { 0xE4, 0xA6, 0xAC },
	0xD9D5, { 0xE4, 0xA7, 0xAC },
	0xD9D6, { 0xF0, 0xA8, 0xBD, 0xBF },
	0xD9D7, { 0xF0, 0xA8, 0xBF, 0xA0 },
	0xD9D8, { 0xE4, 0xA8, 0x81 },
	0xD9D9, { 0xF0, 0xA8, 0xBF, 0xBF },
	0xD9DA, { 0xF0, 0xA9, 0x83, 0xB6 },
	0xD9DB, { 0xF0, 0xA9, 0x83, 0xB7 },
	0xD9DC, { 0xF0, 0xA9, 0x83, 0xB5 },
	0xD9DD, { 0xE4, 0xA8, 0xA3 },
	0xD9DE, { 0xF0, 0xA9, 0x83, 0xBC },
	0xD9DF, { 0xE4, 0xA8, 0xA4 },
	0xD9E0, { 0xE4, 0xA8, 0x9E },
	0xD9E1, { 0xF0, 0xA9, 0x83, 0xB9 },
	0xD9E2, { 0xE4, 0xA9, 0x8A },
	0xD9E3, { 0xE4, 0xA9, 0xA5 },
	0xD9E4, { 0xE4, 0xA9, 0xAA },
	0xD9E5, { 0xF0, 0xA9, 0x8B, 0x8A },
	0xD9E6, { 0xF0, 0xA9, 0x8B, 0x83 },
	0xD9E7, { 0xF0, 0xA9, 0x8B, 0x86 },
	0xD9E8, { 0xE4, 0xA9, 0xA9 },
	0xD9E9, { 0xF0, 0xA9, 0x8E, 0xB8 },
	0xD9EA, { 0xF0, 0xA9, 0x8E, 0xBD },
	0xD9EB, { 0xE4, 0xAA, 0x95 },
	0xD9EC, { 0xF0, 0xA9, 0x8E, 0xBC },
	0xD9ED, { 0xF0, 0xA9, 0x90, 0x85 },
	0xD9EE, { 0xF0, 0xA9, 0x93, 0xA0 },
	0xD9EF, { 0xF0, 0xA9, 0x93, 0xA9 },
	0xD9F0, { 0xE9, 0xA1, 0x82 },
	0xD9F1, { 0xF0, 0xA9, 0x93, 0x9F },
	0xD9F2, { 0xF0, 0xA9, 0x93, 0xAC },
	0xD9F3, { 0xE4, 0xAB, 0x8C },
	0xD9F4, { 0xF0, 0xA9, 0x93, 0xA5 },
	0xD9F5, { 0xF0, 0xA9, 0x93, 0x9E },
	0xD9F6, { 0xF0, 0xAF, 0xA8, 0x80 },
	0xD9F7, { 0xE4, 0xAB, 0x8F },
	0xD9F8, { 0xF0, 0xA9, 0x93, 0xB0 },
	0xD9F9, { 0xF0, 0xA9, 0x93, 0xA3 },
	0xD9FA, { 0xE4, 0xAC, 0x8F },
	0xD9FB, { 0xF0, 0xA9, 0x97, 0xAC },
	0xD9FC, { 0xE4, 0xAC, 0x8E },
	0xD9FD, { 0xE4, 0xAC, 0x8B },
	0xD9FE, { 0xE4, 0xAC, 0x90 },
	0xDAA1, { 0xE4, 0xAC, 0x8D },
	0xDAA2, { 0xE4, 0xAC, 0x8C },
	0xDAA3, { 0xF0, 0xA9, 0x97, 0xB2 },
	0xDAA4, { 0xF0, 0xA9, 0x97, 0xAF },
	0xDAA5, { 0xF0, 0xA9, 0x97, 0xA9 },
	0xDAA6, { 0xF0, 0xA9, 0x9B, 0xBB },
	0xDAA7, { 0xE4, 0xAD, 0x86 },
	0xDAA8, { 0xE4, 0xAD, 0x88 },
	0xDAA9, { 0xE9, 0xA4, 0xB7 },
	0xDAAA, { 0xE4, 0xAD, 0x89 },
	0xDAAB, { 0xF0, 0xA9, 0x9C, 0xB7 },
	0xDAAC, { 0xF0, 0xA9, 0xA3, 0x9E },
	0xDAAD, { 0xE4, 0xAE, 0x91 },
	0xDAAE, { 0xE4, 0xAE, 0x8E },
	0xDAAF, { 0xF0, 0xA9, 0xA3, 0x9A },
	0xDAB0, { 0xE4, 0xAF, 0x98 },
	0xDAB1, { 0xE4, 0xAF, 0x96 },
	0xDAB2, { 0xF0, 0xA9, 0xA9, 0x8B },
	0xDAB3, { 0xE4, 0xAF, 0x9A },
	0xDAB4, { 0xF0, 0xA9, 0xA9, 0x89 },
	0xDAB5, { 0xE4, 0xAF, 0x97 },
	0xDAB6, { 0xF0, 0xA9, 0xAB, 0x95 },
	0xDAB7, { 0xE9, 0xAB, 0xBF },
	0xDAB8, { 0xE4, 0xAF, 0xB9 },
	0xDAB9, { 0xF0, 0xA9, 0xAD, 0x92 },
	0xDABA, { 0xF0, 0xA9, 0xAD, 0x87 },
	0xDABB, { 0xE4, 0xAF, 0xBC },
	0xDABC, { 0xF0, 0xA9, 0xAD, 0x88 },
	0xDABD, { 0xF0, 0xA9, 0xB3, 0x8C },
	0xDABE, { 0xF0, 0xA9, 0xB3, 0x90 },
	0xDABF, { 0xE9, 0xAE, 0xA9 },
	0xDAC0, { 0xE4, 0xB1, 0x8A },
	0xDAC1, { 0xE9, 0xAE, 0xA7 },
	0xDAC2, { 0xE4, 0xB1, 0x8E },
	0xDAC3, { 0xE9, 0xAE, 0xB3 },
	0xDAC4, { 0xE9, 0xAE, 0xAC },
	0xDAC5, { 0xE9, 0xAE, 0xB0 },
	0xDAC6, { 0xF0, 0xA9, 0xB6, 0x86 },
	0xDAC7, { 0xF0, 0xA9, 0xB6, 0xA7 },
	0xDAC8, { 0xF0, 0xA9, 0xB6, 0xA3 },
	0xDAC9, { 0xE9, 0xAE, 0x9C },
	0xDACA, { 0xF0, 0xA9, 0xB6, 0xB6 },
	0xDACB, { 0xF0, 0xA9, 0xB6, 0xAD },
	0xDACC, { 0xF0, 0xAA, 0x80, 0x93 },
	0xDACD, { 0xE9, 0xB4, 0xBC },
	0xDACE, { 0xE9, 0xB4, 0x9C },
	0xDACF, { 0xE9, 0xB4, 0xBA },
	0xDAD0, { 0xE4, 0xB3, 0x93 },
	0xDAD1, { 0xE4, 0xB3, 0x8D },
	0xDAD2, { 0xE4, 0xB3, 0x91 },
	0xDAD3, { 0xF0, 0xAA, 0x80, 0x97 },
	0xDAD4, { 0xF0, 0xAA, 0x80, 0xA2 },
	0xDAD5, { 0xE9, 0xB4, 0xB2 },
	0xDAD6, { 0xE9, 0xB4, 0xB4 },
	0xDAD7, { 0xF0, 0xAA, 0x81, 0x89 },
	0xDAD8, { 0xF0, 0xAA, 0x80, 0xA6 },
	0xDAD9, { 0xF0, 0xAF, 0xA8, 0x8C },
	0xDADA, { 0xF0, 0xAA, 0x80, 0xBC },
	0xDADB, { 0xF0, 0xAA, 0x80, 0xA8 },
	0xDADC, { 0xF0, 0xAA, 0x8A, 0xA8 },
	0xDADD, { 0xE9, 0xBB, 0x87 },
	0xDADE, { 0xF0, 0xAA, 0x8F, 0xBB },
	0xDADF, { 0xE4, 0xB5, 0xA2 },
	0xDAE0, { 0xF0, 0xAA, 0x90, 0xB2 },
	0xDAE1, { 0xF0, 0xAA, 0x93, 0x96 },
	0xDAE2, { 0xF0, 0xAA, 0x95, 0x88 },
	0xDAE3, { 0xE4, 0xB6, 0x83 },
	0xDAE4, { 0xE9, 0xBC, 0xBF },
	0xDAE5, { 0xF0, 0xAA, 0x97, 0x86 },
	0xDAE6, { 0xE4, 0xB6, 0x92 },
	0xDAE7, { 0xE3, 0x92, 0x9F },
	0xDAE8, { 0xE3, 0x92, 0xA0 },
	0xDAE9, { 0xF0, 0xA0, 0x90, 0xA5 },
	0xDAEA, { 0xF0, 0xA0, 0x90, 0xA6 },
	0xDAEB, { 0xF0, 0xA0, 0x90, 0xA4 },
	0xDAEC, { 0xF0, 0xA0, 0x90, 0xB3 },
	0xDAED, { 0xF0, 0xA0, 0x95, 0xB0 },
	0xDAEE, { 0xE3, 0x94, 0xA7 },
	0xDAEF, { 0xF0, 0xA0, 0xAE, 0x90 },
	0xDAF0, { 0xE3, 0x98, 0x8B },
	0xDAF1, { 0xF0, 0xA1, 0x82, 0x95 },
	0xDAF2, { 0xF0, 0xA1, 0x82, 0xA1 },
	0xDAF3, { 0xF0, 0xA1, 0x82, 0x92 },
	0xDAF4, { 0xF0, 0xA1, 0x82, 0x8F },
	0xDAF5, { 0xF0, 0xA1, 0x82, 0x9F },
	0xDAF6, { 0xF0, 0xA1, 0x82, 0x96 },
	0xDAF7, { 0xF0, 0xA1, 0x82, 0x98 },
	0xDAF8, { 0xF0, 0xA1, 0x82, 0x9D },
	0xDAF9, { 0xF0, 0xA1, 0x82, 0xA0 },
	0xDAFA, { 0xE3, 0x9A, 0x8D },
	0xDAFB, { 0xF0, 0xA1, 0x9A, 0x97 },
	0xDAFC, { 0xF0, 0xA1, 0xA3, 0xAB },
	0xDAFD, { 0xE3, 0x9D, 0xB0 },
	0xDAFE, { 0xF0, 0xA1, 0xBE, 0x87 },
	0xDBA1, { 0xE5, 0xBB, 0xAB },
	0xDBA2, { 0xF0, 0xA2, 0x90, 0xB2 },
	0xDBA3, { 0xE3, 0xA6, 0x9A },
	0xDBA4, { 0xE3, 0xA6, 0x9F },
	0xDBA5, { 0xE3, 0xA6, 0x9D },
	0xDBA6, { 0xF0, 0xA2, 0xA3, 0x98 },
	0xDBA7, { 0xF0, 0xA2, 0xA3, 0xBB },
	0xDBA8, { 0xF0, 0xA2, 0xA4, 0x86 },
	0xDBA9, { 0xE3, 0xA6, 0x9B },
	0xDBAA, { 0xF0, 0xA2, 0xA3, 0x91 },
	0xDBAB, { 0xE6, 0x87, 0x95 },
	0xDBAC, { 0xF0, 0xAF, 0xA2, 0xB0 },
	0xDBAD, { 0xE3, 0xA9, 0xA0 },
	0xDBAE, { 0xE3, 0xA9, 0xA4 },
	0xDBAF, { 0xE3, 0xA9, 0xA9 },
	0xDBB0, { 0xE3, 0xA9, 0xA3 },
	0xDBB1, { 0xE3, 0xA9, 0xA7 },
	0xDBB2, { 0xE3, 0xA9, 0xA2 },
	0xDBB3, { 0xF0, 0xA2, 0xB7, 0xB6 },
	0xDBB4, { 0xF0, 0xA2, 0xB8, 0x84 },
	0xDBB5, { 0xF0, 0xA2, 0xB7, 0xBE },
	0xDBB6, { 0xE6, 0x94, 0x82 },
	0xDBB7, { 0xF0, 0xA2, 0xB7, 0xBF },
	0xDBB8, { 0xF0, 0xA2, 0xB7, 0xB7 },
	0xDBB9, { 0xF0, 0xA3, 0x80, 0x98 },
	0xDBBA, { 0xE3, 0xAA, 0xAC },
	0xDBBB, { 0xF0, 0xA3, 0x80, 0x94 },
	0xDBBC, { 0xF0, 0xA3, 0x83, 0x8D },
	0xDBBD, { 0xF0, 0xA3, 0x84, 0xA0 },
	0xDBBE, { 0xF0, 0xA3, 0x8B, 0x9E },
	0xDBBF, { 0xE3, 0xAC, 0xA6 },
	0xDBC0, { 0xE3, 0xAC, 0xA3 },
	0xDBC1, { 0xE3, 0xAC, 0xA5 },
	0xDBC2, { 0xF0, 0xA3, 0x9D, 0x85 },
	0xDBC3, { 0xF0, 0xA3, 0x9D, 0x93 },
	0xDBC4, { 0xE3, 0xAF, 0xB8 },
	0xDBC5, { 0xF0, 0xA3, 0x9D, 0x8B },
	0xDBC6, { 0xF0, 0xA3, 0x9D, 0x95 },
	0xDBC7, { 0xF0, 0xA3, 0x9D, 0x81 },
	0xDBC8, { 0xE3, 0xAF, 0xB7 },
	0xDBC9, { 0xE3, 0xAF, 0xBB },
	0xDBCA, { 0xE3, 0xAF, 0xBA },
	0xDBCB, { 0xF0, 0xA3, 0x9D, 0x9C },
	0xDBCC, { 0xF0, 0xA3, 0x9D, 0x94 },
	0xDBCD, { 0xF0, 0xA3, 0xA9, 0xB1 },
	0xDBCE, { 0xF0, 0xA3, 0xAB, 0x90 },
	0xDBCF, { 0xE3, 0xB2, 0xB0 },
	0xDBD0, { 0xE3, 0xB2, 0xAF },
	0xDBD1, { 0xF0, 0xA3, 0xB1, 0x93 },
	0xDBD2, { 0xF0, 0xA4, 0x80, 0xA9 },
	0xDBD3, { 0xF0, 0xA4, 0x81, 0xBE },
	0xDBD4, { 0xE3, 0xB5, 0xBE },
	0xDBD5, { 0xF0, 0xA4, 0x81, 0xB9 },
	0xDBD6, { 0xE3, 0xB5, 0xBD },
	0xDBD7, { 0xE3, 0xB6, 0x80 },
	0xDBD8, { 0xF0, 0xA4, 0x81, 0xB0 },
	0xDBD9, { 0xF0, 0xA4, 0x81, 0xAA },
	0xDBDA, { 0xE3, 0xB5, 0xBF },
	0xDBDB, { 0xE3, 0xB6, 0x86 },
	0xDBDC, { 0xF0, 0xA4, 0x82, 0x85 },
	0xDBDD, { 0xF0, 0xA4, 0x81, 0xA4 },
	0xDBDE, { 0xE7, 0x80, 0x92 },
	0xDBDF, { 0xF0, 0xA4, 0x81, 0xB8 },
	0xDBE0, { 0xE3, 0xB6, 0x81 },
	0xDBE1, { 0xF0, 0xA4, 0x90, 0xB2 },
	0xDBE2, { 0xF0, 0xA4, 0x90, 0xA7 },
	0xDBE3, { 0xF0, 0xA4, 0x90, 0xAF },
	0xDBE4, { 0xE3, 0xB8, 0xA4 },
	0xDBE5, { 0xE3, 0xB9, 0x98 },
	0xDBE6, { 0xE3, 0xB9, 0x97 },
	0xDBE7, { 0xE3, 0xBA, 0xA0 },
	0xDBE8, { 0xF0, 0xA4, 0xA2, 0xBA },
	0xDBE9, { 0xE3, 0xBB, 0xBE },
	0xDBEA, { 0xF0, 0xA4, 0xA9, 0xB1 },
	0xDBEB, { 0xF0, 0xA4, 0xAA, 0x8C },
	0xDBEC, { 0xE3, 0xBC, 0x95 },
	0xDBED, { 0xF0, 0xA4, 0xAC, 0x9A },
	0xDBEE, { 0xE3, 0xBD, 0x87 },
	0xDBEF, { 0xE3, 0xBD, 0x86 },
	0xDBF0, { 0xF0, 0xA4, 0xAE, 0x98 },
	0xDBF1, { 0xF0, 0xA4, 0xB3, 0xA4 },
	0xDBF2, { 0xE3, 0xBD, 0xAB },
	0xDBF3, { 0xE3, 0xBD, 0xAC },
	0xDBF4, { 0xE7, 0x96, 0x85 },
	0xDBF5, { 0xE7, 0x99, 0x94 },
	0xDBF6, { 0xF0, 0xA4, 0xBB, 0x82 },
	0xDBF7, { 0xE3, 0xBF, 0x8C },
	0xDBF8, { 0xF0, 0xA4, 0xBA, 0xBA },
	0xDBF9, { 0xE7, 0x99, 0x95 },
	0xDBFA, { 0xF0, 0xA4, 0xBB, 0x88 },
	0xDBFB, { 0xE3, 0xBF, 0x8B },
	0xDBFC, { 0xE7, 0x9A, 0xA7 },
	0xDBFD, { 0xE7, 0x9A, 0xA8 },
	0xDBFE, { 0xE3, 0xBF, 0xB9 },
	0xDCA1, { 0xF0, 0xA5, 0x82, 0xB9 },
	0xDCA2, { 0xF0, 0xA5, 0x82, 0xB8 },
	0xDCA3, { 0xF0, 0xA5, 0x82, 0xA5 },
	0xDCA4, { 0xF0, 0xA5, 0x8B, 0xA2 },
	0xDCA5, { 0xE4, 0x81, 0xB8 },
	0xDCA6, { 0xE4, 0x81, 0xBA },
	0xDCA7, { 0xE4, 0x81, 0xB5 },
	0xDCA8, { 0xF0, 0xA5, 0x8B, 0x99 },
	0xDCA9, { 0xE4, 0x81, 0xB6 },
	0xDCAA, { 0xE4, 0x81, 0xB7 },
	0xDCAB, { 0xF0, 0xA5, 0x8A, 0xAC },
	0xDCAC, { 0xF0, 0xA5, 0x8B, 0x9D },
	0xDCAD, { 0xE4, 0x83, 0xAA },
	0xDCAE, { 0xE4, 0x83, 0xAE },
	0xDCAF, { 0xE4, 0x83, 0xAD },
	0xDCB0, { 0xF0, 0xA5, 0x96, 0x9D },
	0xDCB1, { 0xE4, 0x83, 0xAC },
	0xDCB2, { 0xE7, 0xA4, 0x8F },
	0xDCB3, { 0xF0, 0xA5, 0x9C, 0x91 },
	0xDCB4, { 0xF0, 0xA5, 0x9C, 0x83 },
	0xDCB5, { 0xE4, 0x86, 0x84 },
	0xDCB6, { 0xE4, 0x86, 0x85 },
	0xDCB7, { 0xE4, 0x86, 0x83 },
	0xDCB8, { 0xF0, 0xA5, 0xA3, 0xAE },
	0xDCB9, { 0xE4, 0x86, 0xBC },
	0xDCBA, { 0xE4, 0x86, 0xBD },
	0xDCBB, { 0xE4, 0x87, 0x94 },
	0xDCBC, { 0xF0, 0xA5, 0xB2, 0xA4 },
	0xDCBD, { 0xF0, 0xA5, 0xB3, 0x98 },
	0xDCBE, { 0xF0, 0xA5, 0xB3, 0x9D },
	0xDCBF, { 0xF0, 0xA5, 0xB3, 0x9E },
	0xDCC0, { 0xE4, 0x89, 0x95 },
	0xDCC1, { 0xF0, 0xA5, 0xB3, 0xA7 },
	0xDCC2, { 0xE4, 0x89, 0x90 },
	0xDCC3, { 0xE4, 0x89, 0x8C },
	0xDCC4, { 0xE4, 0x89, 0x88 },
	0xDCC5, { 0xF0, 0xA5, 0xB3, 0x94 },
	0xDCC6, { 0xE4, 0x89, 0x93 },
	0xDCC7, { 0xF0, 0xA5, 0xB3, 0x8E },
	0xDCC8, { 0xE4, 0x89, 0x97 },
	0xDCC9, { 0xE4, 0x89, 0x94 },
	0xDCCA, { 0xE4, 0x89, 0x8E },
	0xDCCB, { 0xE4, 0x89, 0x8A },
	0xDCCC, { 0xE4, 0x89, 0x91 },
	0xDCCD, { 0xF0, 0xA5, 0xB3, 0xB1 },
	0xDCCE, { 0xF0, 0xA5, 0xB3, 0x93 },
	0xDCCF, { 0xE4, 0x89, 0x89 },
	0xDCD0, { 0xE4, 0x89, 0x8B },
	0xDCD1, { 0xE4, 0x89, 0xA3 },
	0xDCD2, { 0xF0, 0xA5, 0xB3, 0x8A },
	0xDCD3, { 0xF0, 0xA5, 0xB3, 0xA9 },
	0xDCD4, { 0xE4, 0x8A, 0xA7 },
	0xDCD5, { 0xE4, 0x8A, 0xA6 },
	0xDCD6, { 0xE4, 0x8A, 0xA4 },
	0xDCD7, { 0xF0, 0xA5, 0xBC, 0x9A },
	0xDCD8, { 0xF0, 0xA5, 0xBD, 0x81 },
	0xDCD9, { 0xF0, 0xAF, 0xA5, 0xA8 },
	0xDCDA, { 0xE7, 0xB3, 0xA4 },
	0xDCDB, { 0xE7, 0xB3, 0xA5 },
	0xDCDC, { 0xF0, 0xA6, 0x84, 0xBD },
	0xDCDD, { 0xF0, 0xA6, 0x85, 0x80 },
	0xDCDE, { 0xE7, 0xB9, 0xA5 },
	0xDCDF, { 0xE7, 0xB9, 0x8E },
	0xDCE0, { 0xE4, 0x8C, 0x97 },
	0xDCE1, { 0xF0, 0xA6, 0x85, 0x83 },
	0xDCE2, { 0xE4, 0x8C, 0x96 },
	0xDCE3, { 0xF0, 0xA6, 0x84, 0xBF },
	0xDCE4, { 0xF0, 0xA6, 0x84, 0xBC },
	0xDCE5, { 0xE4, 0x8D, 0xA3 },
	0xDCE6, { 0xF0, 0xA6, 0x8C, 0xA1 },
	0xDCE7, { 0xF0, 0xA6, 0x8C, 0xA0 },
	0xDCE8, { 0xE7, 0xBE, 0x82 },
	0xDCE9, { 0xF0, 0xA6, 0x8F, 0x86 },
	0xDCEA, { 0xE4, 0x8D, 0xBB },
	0xDCEB, { 0xE4, 0x8D, 0xBC },
	0xDCEC, { 0xF0, 0xA6, 0x8F, 0x91 },
	0xDCED, { 0xF0, 0xA6, 0x8F, 0x8A },
	0xDCEE, { 0xF0, 0xA6, 0x92, 0x8E },
	0xDCEF, { 0xF0, 0xA6, 0x92, 0x91 },
	0xDCF0, { 0xE4, 0x8E, 0xB0 },
	0xDCF1, { 0xE8, 0x80, 0xAD },
	0xDCF2, { 0xF0, 0xA6, 0x97, 0xA3 },
	0xDCF3, { 0xF0, 0xA6, 0xA2, 0x88 },
	0xDCF4, { 0xE4, 0x91, 0x82 },
	0xDCF5, { 0xF0, 0xA6, 0xA1, 0xB0 },
	0xDCF6, { 0xE4, 0x91, 0x84 },
	0xDCF7, { 0xF0, 0xA6, 0xA6, 0x9D },
	0xDCF8, { 0xF0, 0xA6, 0xAA, 0x9D },
	0xDCF9, { 0xF0, 0xA6, 0xAA, 0x91 },
	0xDCFA, { 0xF0, 0xA6, 0xAA, 0x98 },
	0xDCFB, { 0xF0, 0xA6, 0xAA, 0x99 },
	0xDCFC, { 0xE4, 0x92, 0x88 },
	0xDCFD, { 0xE4, 0x92, 0x8F },
	0xDCFE, { 0xE4, 0x95, 0x93 },
	0xDDA1, { 0xE4, 0x95, 0x9B },
	0xDDA2, { 0xF0, 0xA6, 0xBE, 0xBF },
	0xDDA3, { 0xE4, 0x95, 0x99 },
	0xDDA4, { 0xF0, 0xA6, 0xBE, 0xAE },
	0xDDA5, { 0xF0, 0xA6, 0xBE, 0xB1 },
	0xDDA6, { 0xF0, 0xA6, 0xBF, 0x8C },
	0xDDA7, { 0xF0, 0xA7, 0x80, 0x84 },
	0xDDA8, { 0xE8, 0x97, 0x8A },
	0xDDA9, { 0xF0, 0xA7, 0x80, 0x96 },
	0xDDAA, { 0xF0, 0xA6, 0xBF, 0x8D },
	0xDDAB, { 0xE4, 0x95, 0x94 },
	0xDDAC, { 0xE8, 0x96, 0xBC },
	0xDDAD, { 0xF0, 0xA6, 0xBF, 0xA0 },
	0xDDAE, { 0xF0, 0xA6, 0xBF, 0x8B },
	0xDDAF, { 0xF0, 0xA6, 0xBF, 0x94 },
	0xDDB0, { 0xF0, 0xA6, 0xBF, 0x89 },
	0xDDB1, { 0xF0, 0xA7, 0x87, 0xBF },
	0xDDB2, { 0xE4, 0x96, 0x99 },
	0xDDB3, { 0xF0, 0xA7, 0x87, 0xBD },
	0xDDB4, { 0xF0, 0xA7, 0x91, 0x97 },
	0xDDB5, { 0xF0, 0xA7, 0x91, 0x92 },
	0xDDB6, { 0xF0, 0xA7, 0x91, 0x90 },
	0xDDB7, { 0xF0, 0xA7, 0x91, 0x85 },
	0xDDB8, { 0xF0, 0xA7, 0x91, 0x8D },
	0xDDB9, { 0xE4, 0x97, 0xB1 },
	0xDDBA, { 0xF0, 0xA7, 0x91, 0x93 },
	0xDDBB, { 0xE4, 0x97, 0xAF },
	0xDDBC, { 0xF0, 0xA7, 0x92, 0x82 },
	0xDDBD, { 0xF0, 0xA7, 0x91, 0x84 },
	0xDDBE, { 0xF0, 0xA7, 0x97, 0x8E },
	0xDDBF, { 0xF0, 0xA7, 0x97, 0x8F },
	0xDDC0, { 0xF0, 0xA7, 0x97, 0x92 },
	0xDDC1, { 0xF0, 0xA7, 0x98, 0x82 },
	0xDDC2, { 0xF0, 0xA7, 0x9D, 0x8F },
	0xDDC3, { 0xF0, 0xA7, 0x9D, 0x98 },
	0xDDC4, { 0xE4, 0x99, 0xA2 },
	0xDDC5, { 0xF0, 0xA7, 0x9D, 0x83 },
	0xDDC6, { 0xE4, 0x99, 0xA3 },
	0xDDC7, { 0xF0, 0xA7, 0x9D, 0x92 },
	0xDDC8, { 0xE4, 0x99, 0xA0 },
	0xDDC9, { 0xE4, 0x99, 0xA1 },
	0xDDCA, { 0xE4, 0x99, 0x9F },
	0xDDCB, { 0xF0, 0xA7, 0x9D, 0x89 },
	0xDDCC, { 0xF0, 0xA7, 0x9D, 0x93 },
	0xDDCD, { 0xF0, 0xA7, 0x9D, 0x8D },
	0xDDCE, { 0xE4, 0x9A, 0x8D },
	0xDDCF, { 0xF0, 0xA7, 0xA2, 0x84 },
	0xDDD0, { 0xE4, 0x9A, 0x8E },
	0xDDD1, { 0xF0, 0xA7, 0xA2, 0x83 },
	0xDDD2, { 0xF0, 0xA7, 0xA4, 0xB2 },
	0xDDD3, { 0xF0, 0xA7, 0xAB, 0xA2 },
	0xDDD4, { 0xE4, 0x9C, 0x89 },
	0xDDD5, { 0xF0, 0xA7, 0xAB, 0xA4 },
	0xDDD6, { 0xF0, 0xA7, 0xAB, 0x93 },
	0xDDD7, { 0xE4, 0x9C, 0x85 },
	0xDDD8, { 0xF0, 0xA7, 0xAB, 0x95 },
	0xDDD9, { 0xF0, 0xA7, 0xAB, 0x9D },
	0xDDDA, { 0xE4, 0x9C, 0x83 },
	0xDDDB, { 0xE4, 0x9C, 0x86 },
	0xDDDC, { 0xF0, 0xA7, 0xAB, 0xAC },
	0xDDDD, { 0xF0, 0xA7, 0xAB, 0xA6 },
	0xDDDE, { 0xF0, 0xA7, 0xAB, 0x92 },
	0xDDDF, { 0xF0, 0xA7, 0xAB, 0xBA },
	0xDDE0, { 0xF0, 0xA7, 0xAB, 0x9A },
	0xDDE1, { 0xE4, 0x9C, 0xB1 },
	0xDDE2, { 0xF0, 0xA7, 0xB0, 0x86 },
	0xDDE3, { 0xF0, 0xA7, 0xB0, 0x84 },
	0xDDE4, { 0xE4, 0x9D, 0x8F },
	0xDDE5, { 0xF0, 0xA7, 0xB1, 0xBB },
	0xDDE6, { 0xF0, 0xA7, 0xB4, 0x84 },
	0xDDE7, { 0xF0, 0xA7, 0xB4, 0x82 },
	0xDDE8, { 0xE4, 0x9D, 0xA6 },
	0xDDE9, { 0xE8, 0xB3, 0xBF },
	0xDDEA, { 0xE4, 0x9F, 0x84 },
	0xDDEB, { 0xF0, 0xA7, 0xBD, 0xA0 },
	0xDDEC, { 0xE4, 0x9F, 0x83 },
	0xDDED, { 0xE4, 0x9F, 0x81 },
	0xDDEE, { 0xE4, 0x9F, 0x85 },
	0xDDEF, { 0xF0, 0xA8, 0x84, 0x87 },
	0xDDF0, { 0xF0, 0xA8, 0x84, 0x85 },
	0xDDF1, { 0xF0, 0xA8, 0x84, 0x8C },
	0xDDF2, { 0xE4, 0xA0, 0xA1 },
	0xDDF3, { 0xF0, 0xA8, 0x85, 0x9A },
	0xDDF4, { 0xE4, 0xA0, 0x9F },
	0xDDF5, { 0xE4, 0xA0, 0xA2 },
	0xDDF6, { 0xF0, 0xA8, 0x84, 0x9A },
	0xDDF7, { 0xE4, 0xA0, 0xA7 },
	0xDDF8, { 0xE4, 0xA0, 0xA0 },
	0xDDF9, { 0xF0, 0xA8, 0x8E, 0x8A },
	0xDDFA, { 0xE4, 0xA1, 0xAD },
	0xDDFB, { 0xE4, 0xA1, 0xAC },
	0xDDFC, { 0xE4, 0xA1, 0xAB },
	0xDDFD, { 0xE4, 0xA1, 0xAF },
	0xDDFE, { 0xE4, 0xA1, 0xB0 },
	0xDEA1, { 0xF0, 0xA8, 0x8E, 0x8C },
	0xDEA2, { 0xF0, 0xA8, 0x98, 0x89 },
	0xDEA3, { 0xF0, 0xA8, 0xA2, 0xA6 },
	0xDEA4, { 0xE9, 0x86, 0xA6 },
	0xDEA5, { 0xF0, 0xA8, 0xA2, 0xAC },
	0xDEA6, { 0xF0, 0xA8, 0xA2, 0xA9 },
	0xDEA7, { 0xE4, 0xA5, 0x82 },
	0xDEA8, { 0xF0, 0xA8, 0xAA, 0x8B },
	0xDEA9, { 0xE9, 0x8E, 0xB6 },
	0xDEAA, { 0xF0, 0xA8, 0xAA, 0x8C },
	0xDEAB, { 0xE4, 0xA5, 0x84 },
	0xDEAC, { 0xE4, 0xA5, 0x80 },
	0xDEAD, { 0xF0, 0xA8, 0xAA, 0x88 },
	0xDEAE, { 0xF0, 0xA8, 0xAA, 0x89 },
	0xDEAF, { 0xE4, 0xA4, 0xBF },
	0xDEB0, { 0xF0, 0xA8, 0xAA, 0x93 },
	0xDEB1, { 0xE9, 0x8E, 0xAB },
	0xDEB2, { 0xE4, 0xA6, 0x8B },
	0xDEB3, { 0xF0, 0xA8, 0xB6, 0x83 },
	0xDEB4, { 0xF0, 0xA8, 0xBD, 0x8F },
	0xDEB5, { 0xE4, 0xA8, 0xA5 },
	0xDEB6, { 0xE4, 0xA8, 0xA8 },
	0xDEB7, { 0xF0, 0xA9, 0x84, 0xA0 },
	0xDEB8, { 0xE9, 0x9C, 0xA1 },
	0xDEB9, { 0xF0, 0xA9, 0x88, 0xB6 },
	0xDEBA, { 0xF0, 0xA9, 0x8B, 0xA2 },
	0xDEBB, { 0xE4, 0xA9, 0xB5 },
	0xDEBC, { 0xE4, 0xA9, 0xB2 },
	0xDEBD, { 0xF0, 0xA9, 0x8B, 0xAE },
	0xDEBE, { 0xE4, 0xA9, 0xAF },
	0xDEBF, { 0xF0, 0xA9, 0x8B, 0xA7 },
	0xDEC0, { 0xF0, 0xA9, 0x8B, 0xA9 },
	0xDEC1, { 0xE4, 0xA9, 0xB6 },
	0xDEC2, { 0xE4, 0xA9, 0xB1 },
	0xDEC3, { 0xE9, 0x9E, 0xA7 },
	0xDEC4, { 0xF0, 0xA9, 0x8B, 0x9F },
	0xDEC5, { 0xE4, 0xAA, 0x97 },
	0xDEC6, { 0xF0, 0xA9, 0x8F, 0x87 },
	0xDEC7, { 0xE4, 0xAB, 0x97 },
	0xDEC8, { 0xF0, 0xA9, 0x94, 0x89 },
	0xDEC9, { 0xE4, 0xAB, 0x96 },
	0xDECA, { 0xF0, 0xA9, 0x94, 0x81 },
	0xDECB, { 0xE4, 0xAB, 0x98 },
	0xDECC, { 0xE4, 0xAB, 0x9C },
	0xDECD, { 0xE4, 0xAB, 0x9B },
	0xDECE, { 0xE4, 0xAB, 0x94 },
	0xDECF, { 0xE9, 0xA0, 0xBE },
	0xDED0, { 0xE4, 0xAC, 0x93 },
	0xDED1, { 0xE4, 0xAC, 0x91 },
	0xDED2, { 0xE4, 0xAC, 0x94 },
	0xDED3, { 0xF0, 0xA9, 0x98, 0x85 },
	0xDED4, { 0xF0, 0xA9, 0x98, 0x8C },
	0xDED5, { 0xF0, 0xA9, 0x9D, 0xB8 },
	0xDED6, { 0xF0, 0xA9, 0x9D, 0x9D },
	0xDED7, { 0xE4, 0xAD, 0x91 },
	0xDED8, { 0xE4, 0xAD, 0x90 },
	0xDED9, { 0xE4, 0xAD, 0x93 },
	0xDEDA, { 0xE4, 0xAD, 0x94 },
	0xDEDB, { 0xE4, 0xAD, 0x92 },
	0xDEDC, { 0xF0, 0xA9, 0x9D, 0x9E },
	0xDEDD, { 0xF0, 0xA9, 0x9D, 0xA0 },
	0xDEDE, { 0xF0, 0xA9, 0x9D, 0xA7 },
	0xDEDF, { 0xE4, 0xAD, 0xAD },
	0xDEE0, { 0xF0, 0xAF, 0xA8, 0x85 },
	0xDEE1, { 0xF0, 0xA9, 0xA3, 0xB4 },
	0xDEE2, { 0xE4, 0xAE, 0x95 },
	0xDEE3, { 0xE4, 0xAE, 0x99 },
	0xDEE4, { 0xF0, 0xA9, 0xA3, 0xB1 },
	0xDEE5, { 0xE4, 0xAE, 0x9A },
	0xDEE6, { 0xF0, 0xA9, 0xA3, 0xBA },
	0xDEE7, { 0xE4, 0xAE, 0x93 },
	0xDEE8, { 0xE4, 0xAE, 0x97 },
	0xDEE9, { 0xF0, 0xA9, 0xA3, 0xB8 },
	0xDEEA, { 0xF0, 0xA9, 0xA3, 0xB9 },
	0xDEEB, { 0xF0, 0xA9, 0xA4, 0x89 },
	0xDEEC, { 0xF0, 0xA9, 0xA3, 0xBD },
	0xDEED, { 0xF0, 0xA9, 0xA3, 0xB7 },
	0xDEEE, { 0xE4, 0xAF, 0x9C },
	0xDEEF, { 0xF0, 0xA9, 0xA9, 0x99 },
	0xDEF0, { 0xE4, 0xAF, 0xBD },
	0xDEF1, { 0xF0, 0xA9, 0xAD, 0xA0 },
	0xDEF2, { 0xF0, 0xA9, 0xAD, 0xA8 },
	0xDEF3, { 0xE4, 0xAF, 0xBE },
	0xDEF4, { 0xE4, 0xB0, 0x80 },
	0xDEF5, { 0xE4, 0xB0, 0x82 },
	0xDEF6, { 0xE4, 0xB0, 0x81 },
	0xDEF7, { 0xE4, 0xB0, 0x83 },
	0xDEF8, { 0xF0, 0xA9, 0xAD, 0xAA },
	0xDEF9, { 0xF0, 0xA9, 0xB0, 0x94 },
	0xDEFA, { 0xF0, 0xA9, 0xB0, 0xBE },
	0xDEFB, { 0xF0, 0xA9, 0xB3, 0xA4 },
	0xDEFC, { 0xE4, 0xB0, 0xA7 },
	0xDEFD, { 0xE4, 0xB0, 0xA6 },
	0xDEFE, { 0xE4, 0xB0, 0xA4 },
	0xDFA1, { 0xE4, 0xB1, 0x8C },
	0xDFA2, { 0xE9, 0xAE, 0xBC },
	0xDFA3, { 0xE4, 0xB1, 0x90 },
	0xDFA4, { 0xE4, 0xB1, 0x95 },
	0xDFA5, { 0xE4, 0xB1, 0x93 },
	0xDFA6, { 0xE9, 0xAE, 0xB7 },
	0xDFA7, { 0xE4, 0xB1, 0x92 },
	0xDFA8, { 0xF0, 0xA9, 0xB7, 0x92 },
	0xDFA9, { 0xE4, 0xB1, 0x97 },
	0xDFAA, { 0xE9, 0xAE, 0xBE },
	0xDFAB, { 0xE4, 0xB1, 0x98 },
	0xDFAC, { 0xE4, 0xB3, 0x96 },
	0xDFAD, { 0xF0, 0xAA, 0x81, 0x98 },
	0xDFAE, { 0xF0, 0xAA, 0x81, 0x90 },
	0xDFAF, { 0xE4, 0xB3, 0x94 },
	0xDFB0, { 0xF0, 0xAA, 0x81, 0x9C },
	0xDFB1, { 0xE4, 0xB3, 0x9A },
	0xDFB2, { 0xE4, 0xB3, 0x99 },
	0xDFB3, { 0xF0, 0xA8, 0x84, 0x99 },
	0xDFB4, { 0xE9, 0xB5, 0xA2 },
	0xDFB5, { 0xE4, 0xB3, 0x95 },
	0xDFB6, { 0xE4, 0xB3, 0xA4 },
	0xDFB7, { 0xF0, 0xAF, 0xA8, 0x8E },
	0xDFB8, { 0xE4, 0xB3, 0x9C },
	0xDFB9, { 0xE4, 0xB4, 0x9B },
	0xDFBA, { 0xE9, 0xBA, 0x8F },
	0xDFBB, { 0xE4, 0xB4, 0xB7 },
	0xDFBC, { 0xE4, 0xB4, 0xB6 },
	0xDFBD, { 0xE4, 0xB5, 0x8B },
	0xDFBE, { 0xE9, 0xBB, 0x8B },
	0xDFBF, { 0xE4, 0xB5, 0xA6 },
	0xDFC0, { 0xE4, 0xB5, 0xB6 },
	0xDFC1, { 0xF0, 0xAA, 0x93, 0x9F },
	0xDFC2, { 0xE4, 0xB5, 0xBE },
	0xDFC3, { 0xE4, 0xB5, 0xBD },
	0xDFC4, { 0xE4, 0xB5, 0xBF },
	0xDFC5, { 0xE4, 0xB6, 0x84 },
	0xDFC6, { 0xE4, 0xB6, 0x8B },
	0xDFC7, { 0xF0, 0xAA, 0x97, 0x99 },
	0xDFC8, { 0xE4, 0xB6, 0x94 },
	0xDFC9, { 0xE3, 0x92, 0xA1 },
	0xDFCA, { 0xE3, 0x94, 0x91 },
	0xDFCB, { 0xF0, 0xA0, 0xA5, 0xA6 },
	0xDFCC, { 0xE3, 0x98, 0x90 },
	0xDFCD, { 0xE5, 0x9A, 0xA9 },
	0xDFCE, { 0xF0, 0xA1, 0x83, 0xA1 },
	0xDFCF, { 0xF0, 0xA1, 0x83, 0xAF },
	0xDFD0, { 0xF0, 0xA1, 0x83, 0xA8 },
	0xDFD1, { 0xF0, 0xA1, 0x88, 0xB3 },
	0xDFD2, { 0xE5, 0xA4, 0x93 },
	0xDFD3, { 0xF0, 0xA1, 0xA3, 0xBE },
	0xDFD4, { 0xE3, 0x9C, 0xB2 },
	0xDFD5, { 0xE5, 0xAF, 0xB4 },
	0xDFD6, { 0xF0, 0xA1, 0xAB, 0xAF },
	0xDFD7, { 0xF0, 0xA1, 0xAB, 0xAC },
	0xDFD8, { 0xF0, 0xA1, 0xB3, 0xAC },
	0xDFD9, { 0xF0, 0xA1, 0xBE, 0x9C },
	0xDFDA, { 0xE3, 0xA0, 0xA0 },
	0xDFDB, { 0xF0, 0xA1, 0xBE, 0x99 },
	0xDFDC, { 0xF0, 0xA2, 0x85, 0xB0 },
	0xDFDD, { 0xF0, 0xA2, 0x85, 0xAE },
	0xDFDE, { 0xE3, 0xA2, 0x9D },
	0xDFDF, { 0xF0, 0xA2, 0x91, 0x81 },
	0xDFE0, { 0xE6, 0x87, 0xAC },
	0xDFE1, { 0xE6, 0x87, 0xAF },
	0xDFE2, { 0xF0, 0xA2, 0xA4, 0x82 },
	0xDFE3, { 0xF0, 0xA2, 0xA4, 0x81 },
	0xDFE4, { 0xE3, 0xA6, 0xA5 },
	0xDFE5, { 0xF0, 0xA2, 0xA8, 0x9B },
	0xDFE6, { 0xF0, 0xA2, 0xB8, 0xA3 },
	0xDFE7, { 0xF0, 0xA2, 0xB8, 0xA5 },
	0xDFE8, { 0xF0, 0xA2, 0xB8, 0xA4 },
	0xDFE9, { 0xF0, 0xA2, 0xB8, 0xA6 },
	0xDFEA, { 0xF0, 0xA2, 0xB8, 0xB3 },
	0xDFEB, { 0xF0, 0xA2, 0xB8, 0xAF },
	0xDFEC, { 0xF0, 0xA3, 0x82, 0x8F },
	0xDFED, { 0xF0, 0xA3, 0x8D, 0x96 },
	0xDFEE, { 0xE3, 0xB0, 0x82 },
	0xDFEF, { 0xE3, 0xAF, 0xBE },
	0xDFF0, { 0xE3, 0xB0, 0x81 },
	0xDFF1, { 0xE6, 0xAB, 0x96 },
	0xDFF2, { 0xE3, 0xB0, 0x83 },
	0xDFF3, { 0xE3, 0xAF, 0xBF },
	0xDFF4, { 0xF0, 0xA3, 0x9E, 0x99 },
	0xDFF5, { 0xE3, 0xB0, 0x84 },
	0xDFF6, { 0xF0, 0xAF, 0xA3, 0xAD },
	0xDFF7, { 0xE3, 0xB1, 0x8A },
	0xDFF8, { 0xF0, 0xA3, 0xAB, 0x99 },
	0xDFF9, { 0xE3, 0xB6, 0x87 },
	0xDFFA, { 0xF0, 0xA4, 0x82, 0xB7 },
	0xDFFB, { 0xE3, 0xB6, 0x84 },
	0xDFFC, { 0xF0, 0xA4, 0x82, 0xB6 },
	0xDFFD, { 0xE3, 0xB6, 0x85 },
	0xDFFE, { 0xE7, 0x88, 0x89 },
	0xE0A1, { 0xF0, 0xA4, 0x91, 0x94 },
	0xE0A2, { 0xF0, 0xA4, 0x91, 0x97 },
	0xE0A3, { 0xF0, 0xA4, 0x91, 0xBA },
	0xE0A4, { 0xE3, 0xB9, 0x99 },
	0xE0A5, { 0xE7, 0x8D, 0xB9 },
	0xE0A6, { 0xF0, 0xA4, 0xAA, 0x8E },
	0xE0A7, { 0xE7, 0x93, 0x86 },
	0xE0A8, { 0xF0, 0xA4, 0xAA, 0x90 },
	0xE0A9, { 0xF0, 0xA4, 0xAA, 0xB9 },
	0xE0AA, { 0xE3, 0xBC, 0x84 },
	0xE0AB, { 0xE3, 0xBD, 0x89 },
	0xE0AC, { 0xE3, 0xBD, 0x88 },
	0xE0AD, { 0xF0, 0xA4, 0xB3, 0xAF },
	0xE0AE, { 0xE3, 0xBD, 0xAD },
	0xE0AF, { 0xE3, 0xBF, 0x92 },
	0xE0B0, { 0xE3, 0xBF, 0x93 },
	0xE0B1, { 0xF0, 0xA4, 0xBB, 0xA2 },
	0xE0B2, { 0xE3, 0xBF, 0x91 },
	0xE0B3, { 0xF0, 0xA4, 0xBB, 0x96 },
	0xE0B4, { 0xF0, 0xA4, 0xBB, 0x98 },
	0xE0B5, { 0xF0, 0xA4, 0xBB, 0x9A },
	0xE0B6, { 0xF0, 0xA4, 0xBB, 0x9E },
	0xE0B7, { 0xE3, 0xBF, 0xA7 },
	0xE0B8, { 0xE4, 0x80, 0x8A },
	0xE0B9, { 0xE7, 0x9F, 0x83 },
	0xE0BA, { 0xF0, 0xA5, 0x8C, 0x88 },
	0xE0BB, { 0xF0, 0xA5, 0x8C, 0x84 },
	0xE0BC, { 0xF0, 0xA5, 0x8C, 0x8A },
	0xE0BD, { 0xF0, 0xA5, 0x8C, 0x8B },
	0xE0BE, { 0xF0, 0xA5, 0x8C, 0x82 },
	0xE0BF, { 0xE4, 0x83, 0xB0 },
	0xE0C0, { 0xF0, 0xA5, 0x96, 0xAA },
	0xE0C1, { 0xF0, 0xA5, 0x97, 0x81 },
	0xE0C2, { 0xE7, 0xA4, 0x9F },
	0xE0C3, { 0xF0, 0xA5, 0xA3, 0x97 },
	0xE0C4, { 0xF0, 0xA5, 0xA3, 0x99 },
	0xE0C5, { 0xE7, 0xA9, 0xA5 },
	0xE0C6, { 0xF0, 0xA5, 0xA3, 0x9E },
	0xE0C7, { 0xF0, 0xA5, 0xA3, 0x9A },
	0xE0C8, { 0xE4, 0x86, 0xBE },
	0xE0C9, { 0xE4, 0x86, 0xBF },
	0xE0CA, { 0xF0, 0xA5, 0xA8, 0xAA },
	0xE0CB, { 0xE7, 0xAB, 0x86 },
	0xE0CC, { 0xE7, 0xB0, 0xBA },
	0xE0CD, { 0xF0, 0xA5, 0xB4, 0xB1 },
	0xE0CE, { 0xE7, 0xB0, 0xB6 },
	0xE0CF, { 0xF0, 0xA5, 0xB4, 0xAB },
	0xE0D0, { 0xF0, 0xA5, 0xB4, 0xAC },
	0xE0D1, { 0xF0, 0xA5, 0xB4, 0xA9 },
	0xE0D2, { 0xF0, 0xA5, 0xB4, 0xAE },
	0xE0D3, { 0xE4, 0x89, 0x9E },
	0xE0D4, { 0xF0, 0xA5, 0xB4, 0xA7 },
	0xE0D5, { 0xF0, 0xA5, 0xB4, 0xA8 },
	0xE0D6, { 0xE4, 0x89, 0x9B },
	0xE0D7, { 0xF0, 0xA5, 0xB5, 0x9F },
	0xE0D8, { 0xF0, 0xA5, 0xB4, 0xB0 },
	0xE0D9, { 0xF0, 0xA5, 0xB4, 0xA4 },
	0xE0DA, { 0xE7, 0xB3, 0xAB },
	0xE0DB, { 0xE4, 0x8A, 0xAB },
	0xE0DC, { 0xF0, 0xA5, 0xBC, 0xBA },
	0xE0DD, { 0xE4, 0x8A, 0xAC },
	0xE0DE, { 0xF0, 0xA5, 0xBC, 0xB9 },
	0xE0DF, { 0xF0, 0xA5, 0xBD, 0x80 },
	0xE0E0, { 0xF0, 0xA6, 0x86, 0x80 },
	0xE0E1, { 0xF0, 0xA6, 0x86, 0x84 },
	0xE0E2, { 0xE4, 0x8C, 0x9F },
	0xE0E3, { 0xE4, 0x8C, 0x9D },
	0xE0E4, { 0xF0, 0xA6, 0x85, 0xB5 },
	0xE0E5, { 0xF0, 0xA6, 0x85, 0xB6 },
	0xE0E6, { 0xE4, 0x8C, 0x9C },
	0xE0E7, { 0xF0, 0xA6, 0x85, 0xBC },
	0xE0E8, { 0xE4, 0x8C, 0x9E },
	0xE0E9, { 0xF0, 0xA6, 0x85, 0xB8 },
	0xE0EA, { 0xF0, 0xA6, 0x86, 0x9B },
	0xE0EB, { 0xF0, 0xA6, 0x85, 0xBE },
	0xE0EC, { 0xF0, 0xA6, 0x89, 0x9A },
	0xE0ED, { 0xE4, 0x8D, 0xA4 },
	0xE0EE, { 0xF0, 0xA6, 0x8C, 0xAC },
	0xE0EF, { 0xE7, 0xBE, 0x84 },
	0xE0F0, { 0xF0, 0xA6, 0x92, 0x9C },
	0xE0F1, { 0xF0, 0xA6, 0xA1, 0x87 },
	0xE0F2, { 0xF0, 0xA6, 0xA2, 0x8A },
	0xE0F3, { 0xE4, 0x91, 0x88 },
	0xE0F4, { 0xE4, 0x91, 0x87 },
	0xE0F5, { 0xF0, 0xA6, 0xA4, 0xA7 },
	0xE0F6, { 0xF0, 0xA7, 0x81, 0x8A },
	0xE0F7, { 0xE4, 0x95, 0x9E },
	0xE0F8, { 0xE4, 0x95, 0xA1 },
	0xE0F9, { 0xF0, 0xA7, 0x80, 0xA7 },
	0xE0FA, { 0xE8, 0x97, 0xA0 },
	0xE0FB, { 0xE8, 0x97, 0xB3 },
	0xE0FC, { 0xF0, 0xA7, 0x80, 0xAE },
	0xE0FD, { 0xF0, 0xA7, 0x80, 0xA6 },
	0xE0FE, { 0xF0, 0xA7, 0x88, 0x88 },
	0xE1A1, { 0xE4, 0x97, 0xB7 },
	0xE1A2, { 0xF0, 0xA7, 0x92, 0xBD },
	0xE1A3, { 0xF0, 0xA7, 0x92, 0x96 },
	0xE1A4, { 0xE4, 0x97, 0xB4 },
	0xE1A5, { 0xE4, 0x97, 0xB8 },
	0xE1A6, { 0xE8, 0xA0, 0x9E },
	0xE1A7, { 0xF0, 0xA7, 0x92, 0xBE },
	0xE1A8, { 0xF0, 0xA7, 0x92, 0x8E },
	0xE1A9, { 0xF0, 0xA7, 0x9D, 0xB4 },
	0xE1AA, { 0xE4, 0x99, 0xA4 },
	0xE1AB, { 0xF0, 0xA7, 0x9E, 0x80 },
	0xE1AC, { 0xE4, 0x9A, 0x92 },
	0xE1AD, { 0xE4, 0x9A, 0x8F },
	0xE1AE, { 0xE4, 0x9A, 0x90 },
	0xE1AF, { 0xE8, 0xA6, 0xB4 },
	0xE1B0, { 0xE4, 0x9A, 0x93 },
	0xE1B1, { 0xE4, 0x9A, 0xA8 },
	0xE1B2, { 0xF0, 0xA7, 0xA4, 0xBC },
	0xE1B3, { 0xF0, 0xA7, 0xA4, 0xBD },
	0xE1B4, { 0xE4, 0x9A, 0xA9 },
	0xE1B5, { 0xF0, 0xA7, 0xA4, 0xBA },
	0xE1B6, { 0xF0, 0xA7, 0xA5, 0x82 },
	0xE1B7, { 0xE8, 0xA7, 0xB9 },
	0xE1B8, { 0xF0, 0xA7, 0xAC, 0xA4 },
	0xE1B9, { 0xF0, 0xA7, 0xAC, 0x86 },
	0xE1BA, { 0xE8, 0xAD, 0x84 },
	0xE1BB, { 0xE4, 0x9C, 0x8E },
	0xE1BC, { 0xF0, 0xA7, 0xAC, 0x95 },
	0xE1BD, { 0xE4, 0x9C, 0x8F },
	0xE1BE, { 0xF0, 0xA7, 0xAC, 0x82 },
	0xE1BF, { 0xF0, 0xA7, 0xAC, 0x8C },
	0xE1C0, { 0xE4, 0x9C, 0x8B },
	0xE1C1, { 0xF0, 0xA7, 0xAC, 0x88 },
	0xE1C2, { 0xF0, 0xA7, 0xAC, 0x8A },
	0xE1C3, { 0xF0, 0xA7, 0xAC, 0x85 },
	0xE1C4, { 0xF0, 0xA7, 0xAC, 0x9C },
	0xE1C5, { 0xE4, 0x9C, 0x90 },
	0xE1C6, { 0xE4, 0x9D, 0x91 },
	0xE1C7, { 0xF0, 0xA7, 0xB2, 0x82 },
	0xE1C8, { 0xE4, 0x9D, 0x90 },
	0xE1C9, { 0xF0, 0xA7, 0xB2, 0x86 },
	0xE1CA, { 0xE4, 0x9D, 0xA3 },
	0xE1CB, { 0xF0, 0xA7, 0xB8, 0x83 },
	0xE1CC, { 0xF0, 0xA7, 0xBD, 0xBB },
	0xE1CD, { 0xE4, 0x9F, 0x87 },
	0xE1CE, { 0xF0, 0xA7, 0xBD, 0xBA },
	0xE1CF, { 0xE8, 0xB9, 0xB1 },
	0xE1D0, { 0xE4, 0xA0, 0xA4 },
	0xE1D1, { 0xE4, 0xA0, 0xA6 },
	0xE1D2, { 0xE8, 0xB9, 0xAE },
	0xE1D3, { 0xF0, 0xA8, 0x86, 0x80 },
	0xE1D4, { 0xE8, 0xB9, 0xB9 },
	0xE1D5, { 0xF0, 0xA8, 0x85, 0x98 },
	0xE1D6, { 0xE8, 0xBB, 0x84 },
	0xE1D7, { 0xE4, 0xA1, 0xB4 },
	0xE1D8, { 0xE4, 0xA1, 0xB3 },
	0xE1D9, { 0xE4, 0xA1, 0xB2 },
	0xE1DA, { 0xF0, 0xA8, 0x8E, 0xAA },
	0xE1DB, { 0xF0, 0xA8, 0x8E, 0xAB },
	0xE1DC, { 0xF0, 0xA8, 0x90, 0xB6 },
	0xE1DD, { 0xF0, 0xA8, 0x91, 0x8A },
	0xE1DE, { 0xE4, 0xA2, 0xB1 },
	0xE1DF, { 0xE9, 0x82, 0x8C },
	0xE1E0, { 0xF0, 0xA8, 0x9F, 0x96 },
	0xE1E1, { 0xE4, 0xA4, 0x8E },
	0xE1E2, { 0xE4, 0xA4, 0x91 },
	0xE1E3, { 0xE4, 0xA4, 0x90 },
	0xE1E4, { 0xE4, 0xA4, 0x8F },
	0xE1E5, { 0xE4, 0xA4, 0x92 },
	0xE1E6, { 0xE4, 0xA5, 0x89 },
	0xE1E7, { 0xE9, 0x8F, 0x89 },
	0xE1E8, { 0xE4, 0xA5, 0x8F },
	0xE1E9, { 0xE4, 0xA5, 0x8D },
	0xE1EA, { 0xF0, 0xA8, 0xAC, 0x83 },
	0xE1EB, { 0xF0, 0xA8, 0xAB, 0x8F },
	0xE1EC, { 0xE4, 0xA5, 0x95 },
	0xE1ED, { 0xF0, 0xA8, 0xB6, 0x9F },
	0xE1EE, { 0xF0, 0xA8, 0xB6, 0xA2 },
	0xE1EF, { 0xF0, 0xA9, 0x80, 0xAA },
	0xE1F0, { 0xF0, 0xA9, 0x80, 0xAF },
	0xE1F1, { 0xF0, 0xA9, 0x85, 0x84 },
	0xE1F2, { 0xF0, 0xA9, 0x85, 0x80 },
	0xE1F3, { 0xE4, 0xA8, 0xAC },
	0xE1F4, { 0xE4, 0xA8, 0xAB },
	0xE1F5, { 0xF0, 0xA9, 0x8C, 0x91 },
	0xE1F6, { 0xF0, 0xA9, 0x8C, 0x8F },
	0xE1F7, { 0xE4, 0xA9, 0xB9 },
	0xE1F8, { 0xF0, 0xA9, 0x8C, 0x8D },
	0xE1F9, { 0xF0, 0xA9, 0x8C, 0x87 },
	0xE1FA, { 0xF0, 0xA9, 0x8C, 0x83 },
	0xE1FB, { 0xE4, 0xA9, 0xBA },
	0xE1FC, { 0xE9, 0x9E, 0xB0 },
	0xE1FD, { 0xE4, 0xAA, 0x99 },
	0xE1FE, { 0xE4, 0xAA, 0x9A },
	0xE2A1, { 0xF0, 0xA9, 0x90, 0xB5 },
	0xE2A2, { 0xE4, 0xAA, 0xAE },
	0xE2A3, { 0xE4, 0xAA, 0xAF },
	0xE2A4, { 0xF0, 0xA9, 0x94, 0x84 },
	0xE2A5, { 0xE4, 0xAB, 0xA4 },
	0xE2A6, { 0xE4, 0xAB, 0xA1 },
	0xE2A7, { 0xE4, 0xAB, 0x9E },
	0xE2A8, { 0xE4, 0xAB, 0xA6 },
	0xE2A9, { 0xE4, 0xAB, 0x9F },
	0xE2AA, { 0xF0, 0xA9, 0x94, 0xA6 },
	0xE2AB, { 0xE4, 0xAB, 0xA7 },
	0xE2AC, { 0xE4, 0xAB, 0xA2 },
	0xE2AD, { 0xE4, 0xAB, 0xA0 },
	0xE2AE, { 0xF0, 0xA9, 0x94, 0x9E },
	0xE2AF, { 0xE4, 0xAB, 0xA5 },
	0xE2B0, { 0xE9, 0xA1, 0x9A },
	0xE2B1, { 0xF0, 0xA9, 0x98, 0x8E },
	0xE2B2, { 0xE4, 0xAC, 0x98 },
	0xE2B3, { 0xF0, 0xA9, 0x98, 0x9D },
	0xE2B4, { 0xF0, 0xA9, 0x98, 0x9E },
	0xE2B5, { 0xF0, 0xA9, 0x98, 0x9F },
	0xE2B6, { 0xE4, 0xAD, 0x96 },
	0xE2B7, { 0xF0, 0xA9, 0x9E, 0x88 },
	0xE2B8, { 0xE9, 0xA5, 0x86 },
	0xE2B9, { 0xF0, 0xA9, 0x9E, 0x8D },
	0xE2BA, { 0xF0, 0xA9, 0x9E, 0x91 },
	0xE2BB, { 0xF0, 0xA9, 0x9E, 0x80 },
	0xE2BC, { 0xE4, 0xAD, 0xAE },
	0xE2BD, { 0xF0, 0xA9, 0xA1, 0x94 },
	0xE2BE, { 0xF0, 0xA9, 0xA1, 0x95 },
	0xE2BF, { 0xE4, 0xAE, 0x9D },
	0xE2C0, { 0xE4, 0xAE, 0xA0 },
	0xE2C1, { 0xE4, 0xAE, 0x9C },
	0xE2C2, { 0xF0, 0xA9, 0xA4, 0xA5 },
	0xE2C3, { 0xF0, 0xA9, 0xA4, 0x9A },
	0xE2C4, { 0xE4, 0xAE, 0xA1 },
	0xE2C5, { 0xE4, 0xAE, 0xA2 },
	0xE2C6, { 0xE4, 0xAE, 0x9F },
	0xE2C7, { 0xE4, 0xAF, 0x9F },
	0xE2C8, { 0xE4, 0xAF, 0x9E },
	0xE2C9, { 0xE9, 0xAB, 0x83 },
	0xE2CA, { 0xE4, 0xAF, 0xAA },
	0xE2CB, { 0xF0, 0xA9, 0xAE, 0x88 },
	0xE2CC, { 0xE4, 0xB0, 0x86 },
	0xE2CD, { 0xF0, 0xA9, 0xAD, 0xBA },
	0xE2CE, { 0xE4, 0xB0, 0x84 },
	0xE2CF, { 0xE9, 0xAC, 0x8F },
	0xE2D0, { 0xF0, 0xA9, 0xAE, 0x80 },
	0xE2D1, { 0xF0, 0xA9, 0xB4, 0x9E },
	0xE2D2, { 0xF0, 0xA9, 0xB7, 0xBC },
	0xE2D3, { 0xF0, 0xA9, 0xB8, 0xA5 },
	0xE2D4, { 0xE4, 0xB1, 0x9F },
	0xE2D5, { 0xE9, 0xAF, 0xB4 },
	0xE2D6, { 0xE9, 0xAF, 0xBA },
	0xE2D7, { 0xE4, 0xB1, 0x9C },
	0xE2D8, { 0xF0, 0xA9, 0xB8, 0x8B },
	0xE2D9, { 0xE4, 0xB1, 0x9E },
	0xE2DA, { 0xF0, 0xA9, 0xB8, 0x86 },
	0xE2DB, { 0xF0, 0xA9, 0xB8, 0x84 },
	0xE2DC, { 0xE9, 0xAF, 0x9D },
	0xE2DD, { 0xE4, 0xB1, 0x99 },
	0xE2DE, { 0xF0, 0xA9, 0xB7, 0xB9 },
	0xE2DF, { 0xF0, 0xA9, 0xB8, 0x80 },
	0xE2E0, { 0xE4, 0xB1, 0xA4 },
	0xE2E1, { 0xE4, 0xB1, 0x9D },
	0xE2E2, { 0xE4, 0xB1, 0xA2 },
	0xE2E3, { 0xF0, 0xA9, 0xB8, 0x82 },
	0xE2E4, { 0xE4, 0xB1, 0xA5 },
	0xE2E5, { 0xF0, 0xA9, 0xB8, 0x87 },
	0xE2E6, { 0xE9, 0xAF, 0xAD },
	0xE2E7, { 0xE4, 0xB1, 0x9B },
	0xE2E8, { 0xE9, 0xAF, 0xAF },
	0xE2E9, { 0xF0, 0xAA, 0x82, 0xB5 },
	0xE2EA, { 0xE4, 0xB3, 0x9D },
	0xE2EB, { 0xF0, 0xAA, 0x82, 0x87 },
	0xE2EC, { 0xE4, 0xB3, 0x9F },
	0xE2ED, { 0xF0, 0xAA, 0x82, 0x93 },
	0xE2EE, { 0xF0, 0xAF, 0xA8, 0x8F },
	0xE2EF, { 0xE4, 0xB3, 0xA2 },
	0xE2F0, { 0xF0, 0xAA, 0x82, 0xBE },
	0xE2F1, { 0xF0, 0xAA, 0x89, 0xA6 },
	0xE2F2, { 0xE4, 0xB4, 0xA7 },
	0xE2F3, { 0xF0, 0xAA, 0x8B, 0x87 },
	0xE2F4, { 0xF0, 0xAA, 0x8B, 0x8F },
	0xE2F5, { 0xE9, 0xBA, 0x96 },
	0xE2F6, { 0xE4, 0xB4, 0xBA },
	0xE2F7, { 0xE4, 0xB4, 0xBC },
	0xE2F8, { 0xF0, 0xAA, 0x8C, 0xBD },
	0xE2F9, { 0xE4, 0xB4, 0xB9 },
	0xE2FA, { 0xF0, 0xAA, 0x8C, 0xBC },
	0xE2FB, { 0xF0, 0xAA, 0x8D, 0x87 },
	0xE2FC, { 0xE4, 0xB4, 0xBD },
	0xE2FD, { 0xE4, 0xB4, 0xBB },
	0xE2FE, { 0xE9, 0xBA, 0xB3 },
	0xE3A1, { 0xE4, 0xB5, 0x8C },
	0xE3A2, { 0xF0, 0xAA, 0x8F, 0x83 },
	0xE3A3, { 0xE4, 0xB5, 0xA8 },
	0xE3A4, { 0xE9, 0xBB, 0xA2 },
	0xE3A5, { 0xF0, 0xAA, 0x94, 0x9B },
	0xE3A6, { 0xE4, 0xB6, 0x80 },
	0xE3A7, { 0xE4, 0xB6, 0x85 },
	0xE3A8, { 0xF0, 0xAA, 0x97, 0x89 },
	0xE3A9, { 0xE4, 0xB6, 0x95 },
	0xE3AA, { 0xF0, 0xAA, 0x97, 0x9D },
	0xE3AB, { 0xE4, 0xB6, 0x96 },
	0xE3AC, { 0xF0, 0xAA, 0x9A, 0x93 },
	0xE3AD, { 0xE9, 0xBE, 0x8F },
	0xE3AE, { 0xF0, 0xA0, 0x90, 0xBD },
	0xE3AF, { 0xE3, 0x92, 0xA4 },
	0xE3B0, { 0xE3, 0x94, 0x92 },
	0xE3B1, { 0xE5, 0x9A, 0xB1 },
	0xE3B2, { 0xE3, 0x98, 0xA5 },
	0xE3B3, { 0xF0, 0xA1, 0x93, 0xA6 },
	0xE3B4, { 0xE5, 0xAD, 0x81 },
	0xE3B5, { 0xE3, 0x9C, 0xB7 },
	0xE3B6, { 0xF0, 0xA1, 0xAB, 0xB7 },
	0xE3B7, { 0xF0, 0xA1, 0xBE, 0xB0 },
	0xE3B8, { 0xF0, 0xA1, 0xBE, 0xAE },
	0xE3BA, { 0xE3, 0xA1, 0xA8 },
	0xE3BB, { 0xE3, 0xA1, 0xA7 },
	0xE3BC, { 0xE3, 0xA2, 0x9E },
	0xE3BD, { 0xF0, 0xA2, 0x96, 0x9F },
	0xE3BE, { 0xF0, 0xA2, 0x96, 0x9E },
	0xE3BF, { 0xF0, 0xA2, 0xA4, 0xB0 },
	0xE3C0, { 0xE3, 0xA6, 0xAA },
	0xE3C1, { 0xF0, 0xA2, 0xA5, 0x8F },
	0xE3C2, { 0xE3, 0xA6, 0xA9 },
	0xE3C3, { 0xE3, 0xA6, 0xA4 },
	0xE3C4, { 0xF0, 0xA2, 0xA4, 0xA7 },
	0xE3C5, { 0xF0, 0xA2, 0xA5, 0x91 },
	0xE3C6, { 0xE3, 0xA9, 0xB1 },
	0xE3C7, { 0xE3, 0xA9, 0xAF },
	0xE3C8, { 0xF0, 0xA2, 0xB9, 0x91 },
	0xE3C9, { 0xF0, 0xA2, 0xB9, 0x94 },
	0xE3CA, { 0xF0, 0xA2, 0xB9, 0x96 },
	0xE3CB, { 0xF0, 0xA3, 0x80, 0xA7 },
	0xE3CC, { 0xE3, 0xAA, 0xAD },
	0xE3CD, { 0xF0, 0xA3, 0x80, 0xA4 },
	0xE3CE, { 0xE6, 0xAB, 0xB6 },
	0xE3CF, { 0xE3, 0xB0, 0x8C },
	0xE3D0, { 0xE6, 0xAB, 0xB2 },
	0xE3D1, { 0xE3, 0xB0, 0x8B },
	0xE3D2, { 0xF0, 0xA3, 0x9F, 0xAC },
	0xE3D3, { 0xF0, 0xA3, 0x9F, 0x84 },
	0xE3D4, { 0xE3, 0xB0, 0x8F },
	0xE3D5, { 0xE3, 0xB1, 0xB9 },
	0xE3D6, { 0xF0, 0xA4, 0x83, 0xB8 },
	0xE3D7, { 0xF0, 0xA4, 0x83, 0xB6 },
	0xE3D8, { 0xF0, 0xA4, 0x83, 0xB7 },
	0xE3D9, { 0xF0, 0xA4, 0x83, 0xAD },
	0xE3DA, { 0xE3, 0xB6, 0x8D },
	0xE3DB, { 0xE3, 0xB6, 0x8F },
	0xE3DC, { 0xF0, 0xA4, 0x83, 0xB4 },
	0xE3DD, { 0xF0, 0xA4, 0x83, 0xAF },
	0xE3DE, { 0xE3, 0xB6, 0x8E },
	0xE3DF, { 0xE3, 0xB8, 0x8C },
	0xE3E0, { 0xF0, 0xA4, 0x91, 0xBF },
	0xE3E1, { 0xF0, 0xA4, 0x92, 0xA2 },
	0xE3E2, { 0xF0, 0xA4, 0x91, 0xBE },
	0xE3E3, { 0xE3, 0xBA, 0xA6 },
	0xE3E4, { 0xF0, 0xA4, 0xA3, 0x85 },
	0xE3E5, { 0xE3, 0xBA, 0xA3 },
	0xE3E6, { 0xE3, 0xBA, 0xA4 },
	0xE3E7, { 0xE3, 0xBA, 0xA5 },
	0xE3E8, { 0xE7, 0x96, 0x88 },
	0xE3E9, { 0xE3, 0xBD, 0xAE },
	0xE3EA, { 0xF0, 0xA4, 0xBB, 0xB1 },
	0xE3EB, { 0xF0, 0xA4, 0xBB, 0xB2 },
	0xE3EC, { 0xE3, 0xBF, 0xBA },
	0xE3ED, { 0xF0, 0xA5, 0x80, 0xAF },
	0xE3EE, { 0xE4, 0x81, 0xBC },
	0xE3EF, { 0xE4, 0x81, 0xBE },
	0xE3F0, { 0xE4, 0x81, 0xBB },
	0xE3F1, { 0xE4, 0x81, 0xBD },
	0xE3F2, { 0xF0, 0xA5, 0x8C, 0xA3 },
	0xE3F3, { 0xF0, 0xA5, 0x8C, 0xA9 },
	0xE3F4, { 0xE4, 0x82, 0x8D },
	0xE3F5, { 0xE4, 0x83, 0xB4 },
	0xE3F6, { 0xE4, 0x83, 0xB3 },
	0xE3F7, { 0xF0, 0xA5, 0x9C, 0x9B },
	0xE3F8, { 0xF0, 0xA5, 0xA3, 0xAB },
	0xE3F9, { 0xE4, 0x86, 0x89 },
	0xE3FA, { 0xF0, 0xA5, 0xA3, 0xAA },
	0xE3FB, { 0xF0, 0xA5, 0xA8, 0xB3 },
	0xE3FC, { 0xE4, 0x87, 0x80 },
	0xE3FD, { 0xF0, 0xA5, 0xB5, 0xA3 },
	0xE3FE, { 0xE4, 0x89, 0xA5 },
	0xE4A1, { 0xF0, 0xA5, 0xB6, 0x92 },
	0xE4A2, { 0xF0, 0xA5, 0xB5, 0xA5 },
	0xE4A3, { 0xE4, 0x8A, 0xAD },
	0xE4A4, { 0xE4, 0x8C, 0xA5 },
	0xE4A5, { 0xF0, 0xA6, 0x86, 0xA0 },
	0xE4A6, { 0xF0, 0xAF, 0xA5, 0xB0 },
	0xE4A7, { 0xF0, 0xA6, 0x89, 0x9E },
	0xE4A8, { 0xE4, 0x8F, 0x89 },
	0xE4A9, { 0xF0, 0xA6, 0xA2, 0xAA },
	0xE4AA, { 0xE4, 0x91, 0x8A },
	0xE4AB, { 0xF0, 0xA6, 0xA2, 0xA9 },
	0xE4AC, { 0xE8, 0x89, 0xA7 },
	0xE4AD, { 0xE4, 0x92, 0x89 },
	0xE4AE, { 0xF0, 0xA7, 0x82, 0x9C },
	0xE4AF, { 0xE4, 0x95, 0xA6 },
	0xE4B0, { 0xE4, 0x95, 0xB0 },
	0xE4B1, { 0xF0, 0xA7, 0x82, 0x92 },
	0xE4B2, { 0xE4, 0x95, 0xAD },
	0xE4B3, { 0xE4, 0x95, 0xA9 },
	0xE4B4, { 0xE4, 0x95, 0xA7 },
	0xE4B5, { 0xF0, 0xA7, 0x82, 0x86 },
	0xE4B6, { 0xE4, 0x95, 0xB2 },
	0xE4B7, { 0xE8, 0x98, 0x8E },
	0xE4B8, { 0xE4, 0x95, 0xAE },
	0xE4B9, { 0xF0, 0xA7, 0x82, 0x83 },
	0xE4BA, { 0xE4, 0x96, 0x9C },
	0xE4BB, { 0xE4, 0x97, 0xBC },
	0xE4BC, { 0xE4, 0x97, 0xBD },
	0xE4BD, { 0xE4, 0x98, 0x84 },
	0xE4BE, { 0xE4, 0x97, 0xBF },
	0xE4BF, { 0xF0, 0xAF, 0xA7, 0x82 },
	0xE4C0, { 0xE4, 0x97, 0xBE },
	0xE4C1, { 0xE4, 0x98, 0x80 },
	0xE4C2, { 0xF0, 0xA7, 0x93, 0x8E },
	0xE4C3, { 0xE4, 0x99, 0xA6 },
	0xE4C4, { 0xE4, 0x99, 0xA9 },
	0xE4C5, { 0xF0, 0xA7, 0x9E, 0x93 },
	0xE4C6, { 0xE4, 0x9A, 0xAA },
	0xE4C7, { 0xE4, 0x9A, 0xAB },
	0xE4C8, { 0xE4, 0x9C, 0x97 },
	0xE4C9, { 0xF0, 0xA7, 0xAC, 0xAE },
	0xE4CA, { 0xF0, 0xA7, 0xAC, 0xA7 },
	0xE4CB, { 0xF0, 0xA7, 0xAC, 0xA8 },
	0xE4CC, { 0xE4, 0x9C, 0x95 },
	0xE4CD, { 0xE8, 0xAD, 0x9E },
	0xE4CE, { 0xE4, 0x9C, 0x92 },
	0xE4CF, { 0xE8, 0xB4, 0x8E },
	0xE4D0, { 0xF0, 0xA7, 0xB8, 0x98 },
	0xE4D1, { 0xF0, 0xA7, 0xB8, 0x96 },
	0xE4D2, { 0xF0, 0xA7, 0xBE, 0x8D },
	0xE4D3, { 0xE4, 0x9F, 0x8A },
	0xE4D4, { 0xF0, 0xA7, 0xBE, 0x8E },
	0xE4D5, { 0xE4, 0x9F, 0x89 },
	0xE4D6, { 0xE4, 0x9F, 0x8B },
	0xE4D7, { 0xF0, 0xA7, 0xBE, 0x90 },
	0xE4D8, { 0xF0, 0xA7, 0xBE, 0x8F },
	0xE4D9, { 0xF0, 0xA8, 0x86, 0x81 },
	0xE4DA, { 0xE4, 0xA0, 0xA9 },
	0xE4DB, { 0xE4, 0xA0, 0xA8 },
	0xE4DC, { 0xF0, 0xA8, 0x86, 0x8A },
	0xE4DD, { 0xF0, 0xA8, 0x86, 0x8C },
	0xE4DE, { 0xF0, 0xA8, 0x8A, 0x8D },
	0xE4DF, { 0xE4, 0xA1, 0x80 },
	0xE4E0, { 0xE4, 0xA1, 0xB5 },
	0xE4E1, { 0xE4, 0xA1, 0xB6 },
	0xE4E2, { 0xF0, 0xA8, 0x8E, 0xB2 },
	0xE4E3, { 0xE4, 0xA2, 0x88 },
	0xE4E4, { 0xF0, 0xA8, 0x9F, 0x99 },
	0xE4E5, { 0xE9, 0x86, 0xB6 },
	0xE4E6, { 0xE4, 0xA5, 0x97 },
	0xE4E7, { 0xE9, 0x90, 0x81 },
	0xE4E8, { 0xF0, 0xA8, 0xAC, 0x8D },
	0xE4E9, { 0xE4, 0xA5, 0x9F },
	0xE4EA, { 0xF0, 0xA8, 0xAC, 0x93 },
	0xE4EB, { 0xE9, 0x90, 0x9D },
	0xE4EC, { 0xE4, 0xA5, 0x98 },
	0xE4ED, { 0xE4, 0xA5, 0x9B },
	0xE4EE, { 0xF0, 0xA8, 0xAC, 0x9B },
	0xE4EF, { 0xE9, 0x90, 0xAF },
	0xE4F0, { 0xF0, 0xA8, 0xB6, 0xAC },
	0xE4F1, { 0xE4, 0xA6, 0xB3 },
	0xE4F2, { 0xF0, 0xA8, 0xB6, 0xB3 },
	0xE4F3, { 0xE4, 0xA7, 0xAF },
	0xE4F4, { 0xF0, 0xA9, 0x85, 0x9E },
	0xE4F5, { 0xE4, 0xA8, 0xB0 },
	0xE4F6, { 0xF0, 0xA9, 0x85, 0xA0 },
	0xE4F7, { 0xF0, 0xA9, 0x85, 0xA8 },
	0xE4F8, { 0xF0, 0xA9, 0x85, 0xA3 },
	0xE4F9, { 0xF0, 0xA9, 0x85, 0xA9 },
	0xE4FA, { 0xF0, 0xA9, 0x85, 0xA7 },
	0xE4FB, { 0xE4, 0xA9, 0x81 },
	0xE4FC, { 0xE4, 0xA9, 0x8B },
	0xE4FD, { 0xF0, 0xA9, 0x8C, 0xA8 },
	0xE4FE, { 0xE4, 0xA9, 0xBD },
	0xE5A1, { 0xF0, 0xA9, 0x8C, 0xAE },
	0xE5A2, { 0xF0, 0xA9, 0x8C, 0xB0 },
	0xE5A3, { 0xE4, 0xA9, 0xBC },
	0xE5A4, { 0xF0, 0xA9, 0x8C, 0xA6 },
	0xE5A5, { 0xF0, 0xA9, 0x8C, 0xB1 },
	0xE5A6, { 0xF0, 0xA9, 0x8D, 0x81 },
	0xE5A7, { 0xE9, 0x9F, 0xA0 },
	0xE5A8, { 0xF0, 0xA9, 0x8F, 0x9A },
	0xE5A9, { 0xE9, 0x9F, 0x9B },
	0xE5AA, { 0xF0, 0xAF, 0xA7, 0xBA },
	0xE5AB, { 0xF0, 0xA9, 0x90, 0x8B },
	0xE5AC, { 0xE9, 0xA1, 0xA1 },
	0xE5AD, { 0xF0, 0xA9, 0x94, 0xB4 },
	0xE5AE, { 0xF0, 0xA9, 0x94, 0xB3 },
	0xE5AF, { 0xE4, 0xAB, 0xA8 },
	0xE5B0, { 0xE4, 0xAB, 0xAA },
	0xE5B1, { 0xE4, 0xAB, 0xA9 },
	0xE5B2, { 0xF0, 0xA9, 0x94, 0xB9 },
	0xE5B3, { 0xF0, 0xA9, 0x94, 0xBB },
	0xE5B4, { 0xF0, 0xA9, 0x95, 0x80 },
	0xE5B5, { 0xF0, 0xA9, 0x98, 0xB0 },
	0xE5B6, { 0xE4, 0xAC, 0x9B },
	0xE5B7, { 0xF0, 0xA9, 0x98, 0xB2 },
	0xE5B8, { 0xF0, 0xA9, 0x98, 0xB7 },
	0xE5B9, { 0xE4, 0xAD, 0x95 },
	0xE5BA, { 0xE9, 0xA5, 0x8A },
	0xE5BB, { 0xE4, 0xAD, 0x99 },
	0xE5BC, { 0xE4, 0xAD, 0x98 },
	0xE5BD, { 0xF0, 0xA9, 0x9E, 0x81 },
	0xE5BE, { 0xF0, 0xA9, 0x9E, 0x9F },
	0xE5BF, { 0xF0, 0xA9, 0x9E, 0xA7 },
	0xE5C0, { 0xE4, 0xAE, 0xA4 },
	0xE5C1, { 0xE4, 0xAE, 0xA3 },
	0xE5C2, { 0xF0, 0xA9, 0xA5, 0x84 },
	0xE5C3, { 0xF0, 0xA9, 0xA5, 0x87 },
	0xE5C4, { 0xF0, 0xA9, 0xA5, 0x88 },
	0xE5C5, { 0xF0, 0xA9, 0xA4, 0xBD },
	0xE5C6, { 0xE9, 0xA8, 0xB3 },
	0xE5C7, { 0xE4, 0xAE, 0xA7 },
	0xE5C8, { 0xF0, 0xA9, 0xA5, 0x89 },
	0xE5C9, { 0xE4, 0xAF, 0xA0 },
	0xE5CA, { 0xF0, 0xA9, 0xAA, 0x80 },
	0xE5CB, { 0xF0, 0xA9, 0xAE, 0xA0 },
	0xE5CC, { 0xF0, 0xA9, 0xAE, 0x9D },
	0xE5CD, { 0xE4, 0xB0, 0x88 },
	0xE5CE, { 0xE4, 0xB0, 0x8A },
	0xE5CF, { 0xE4, 0xB0, 0x89 },
	0xE5D0, { 0xF0, 0xA9, 0xAE, 0x9C },
	0xE5D1, { 0xF0, 0xA9, 0xB1, 0x87 },
	0xE5D2, { 0xF0, 0xA9, 0xB4, 0x87 },
	0xE5D3, { 0xE4, 0xB1, 0xB1 },
	0xE5D4, { 0xE9, 0xB0, 0x8F },
	0xE5D5, { 0xE4, 0xB1, 0xAC },
	0xE5D6, { 0xF0, 0xA9, 0xB9, 0x89 },
	0xE5D7, { 0xE9, 0xB0, 0x91 },
	0xE5D8, { 0xF0, 0xA9, 0xB9, 0x84 },
	0xE5D9, { 0xE9, 0xB0, 0x83 },
	0xE5DA, { 0xE9, 0xB0, 0x81 },
	0xE5DB, { 0xE4, 0xB1, 0xAE },
	0xE5DC, { 0xF0, 0xA9, 0xBB, 0x9F },
	0xE5DD, { 0xE9, 0xB0, 0x96 },
	0xE5DE, { 0xF0, 0xA9, 0xB9, 0x8C },
	0xE5E0, { 0xF0, 0xA9, 0xB9, 0x8F },
	0xE5E1, { 0xE4, 0xB3, 0xA0 },
	0xE5E2, { 0xE4, 0xB3, 0xAE },
	0xE5E3, { 0xF0, 0xAA, 0x83, 0x81 },
	0xE5E4, { 0xE4, 0xB3, 0xAB },
	0xE5E5, { 0xF0, 0xAA, 0x82, 0xB9 },
	0xE5E6, { 0xF0, 0xAA, 0x83, 0x8B },
	0xE5E7, { 0xF0, 0xAA, 0x83, 0x8F },
	0xE5E8, { 0xF0, 0xAA, 0x83, 0x84 },
	0xE5E9, { 0xE9, 0xB6, 0x93 },
	0xE5EA, { 0xE4, 0xB3, 0xAA },
	0xE5EB, { 0xE4, 0xB3, 0xAF },
	0xE5EC, { 0xE4, 0xB3, 0xA7 },
	0xE5ED, { 0xF0, 0xAA, 0x83, 0x8A },
	0xE5EE, { 0xF0, 0xAA, 0x83, 0x83 },
	0xE5EF, { 0xF0, 0xAA, 0x8B, 0x90 },
	0xE5F0, { 0xF0, 0xAA, 0x8D, 0x91 },
	0xE5F1, { 0xE4, 0xB5, 0x88 },
	0xE5F2, { 0xE4, 0xB5, 0x89 },
	0xE5F3, { 0xF0, 0xAA, 0x8E, 0xA8 },
	0xE5F4, { 0xF0, 0xAA, 0x8F, 0x87 },
	0xE5F5, { 0xF0, 0xAA, 0x8F, 0x86 },
	0xE5F6, { 0xE4, 0xB5, 0x8D },
	0xE5F7, { 0xF0, 0xAA, 0x8F, 0x8A },
	0xE5F8, { 0xF0, 0xAA, 0x90, 0x82 },
	0xE5F9, { 0xE4, 0xB5, 0x95 },
	0xE5FA, { 0xF0, 0xAA, 0x91, 0x9D },
	0xE5FB, { 0xF0, 0xAA, 0x91, 0x9A },
	0xE5FC, { 0xE4, 0xB5, 0xAA },
	0xE5FD, { 0xE4, 0xB5, 0xAC },
	0xE5FE, { 0xF0, 0xAA, 0x91, 0x99 },
	0xE6A1, { 0xE4, 0xB5, 0xAB },
	0xE6A2, { 0xF0, 0xAA, 0x93, 0x8C },
	0xE6A3, { 0xF0, 0xAA, 0x94, 0x9C },
	0xE6A4, { 0xF0, 0xAA, 0x97, 0x8C },
	0xE6A5, { 0xE4, 0xB6, 0x98 },
	0xE6A6, { 0xE4, 0xB6, 0x99 },
	0xE6A7, { 0xE4, 0xB6, 0x97 },
	0xE6A8, { 0xF0, 0xAA, 0x97, 0xA8 },
	0xE6A9, { 0xF0, 0xAA, 0x97, 0xAC },
	0xE6AA, { 0xF0, 0xAA, 0x97, 0xAA },
	0xE6AB, { 0xF0, 0xAA, 0x9A, 0xAD },
	0xE6AC, { 0xF0, 0xAA, 0x9A, 0xB0 },
	0xE6AD, { 0xF0, 0xA0, 0x91, 0x9F },
	0xE6AE, { 0xF0, 0xA0, 0x91, 0x98 },
	0xE6AF, { 0xF0, 0xA0, 0x91, 0x97 },
	0xE6B0, { 0xE5, 0x8D, 0x9B },
	0xE6B1, { 0xF0, 0xA0, 0xAE, 0x93 },
	0xE6B2, { 0xE3, 0x98, 0x96 },
	0xE6B3, { 0xF0, 0xA1, 0x84, 0xBB },
	0xE6B4, { 0xE5, 0x9A, 0xBF },
	0xE6B5, { 0xF0, 0xA1, 0x84, 0xB4 },
	0xE6B6, { 0xF0, 0xA1, 0x93, 0xB2 },
	0xE6B7, { 0xE3, 0x9C, 0xB9 },
	0xE6B8, { 0xF0, 0xA1, 0xAB, 0xBD },
	0xE6B9, { 0xF0, 0xA1, 0xB0, 0x9D },
	0xE6BA, { 0xE3, 0xA0, 0xA5 },
	0xE6BB, { 0xE5, 0xB7, 0x8E },
	0xE6BC, { 0xF0, 0xA2, 0x8C, 0x84 },
	0xE6BD, { 0xF0, 0xA2, 0x91, 0x88 },
	0xE6BE, { 0xF0, 0xA2, 0xA5, 0x98 },
	0xE6BF, { 0xF0, 0xA2, 0xB9, 0x8F },
	0xE6C0, { 0xE3, 0xA9, 0xB4 },
	0xE6C1, { 0xF0, 0xA2, 0xB9, 0xAE },
	0xE6C2, { 0xF0, 0xA2, 0xB9, 0xB2 },
	0xE6C3, { 0xE3, 0xAA, 0xAE },
	0xE6C4, { 0xF0, 0xA3, 0x80, 0xAE },
	0xE6C5, { 0xF0, 0xA3, 0x9F, 0xBC },
	0xE6C6, { 0xF0, 0xA3, 0x9F, 0xB4 },
	0xE6C7, { 0xF0, 0xA3, 0xB0, 0xB6 },
	0xE6C8, { 0xF0, 0xA4, 0x84, 0x8E },
	0xE6C9, { 0xE3, 0xB6, 0x92 },
	0xE6CA, { 0xE3, 0xB6, 0x94 },
	0xE6CB, { 0xF0, 0xA4, 0x84, 0x94 },
	0xE6CC, { 0xE3, 0xB6, 0x95 },
	0xE6CD, { 0xF0, 0xA4, 0x84, 0x99 },
	0xE6CE, { 0xE3, 0xB8, 0x8D },
	0xE6CF, { 0xF0, 0xA4, 0x92, 0xA6 },
	0xE6D0, { 0xE3, 0xB8, 0xA5 },
	0xE6D1, { 0xF0, 0xA4, 0xAB, 0x89 },
	0xE6D2, { 0xF0, 0xA4, 0xAB, 0x80 },
	0xE6D3, { 0xF0, 0xA4, 0xAB, 0x8C },
	0xE6D4, { 0xF0, 0xA4, 0xAC, 0x9B },
	0xE6D5, { 0xF0, 0xA4, 0xAE, 0xAA },
	0xE6D6, { 0xF0, 0xA4, 0xAE, 0xA8 },
	0xE6D7, { 0xF0, 0xA4, 0xBC, 0x83 },
	0xE6D8, { 0xE3, 0xBF, 0x95 },
	0xE6D9, { 0xE3, 0xBF, 0x96 },
	0xE6DA, { 0xE7, 0x9A, 0xAC },
	0xE6DB, { 0xE3, 0xBF, 0xA8 },
	0xE6DC, { 0xF0, 0xA5, 0x80, 0xB5 },
	0xE6DD, { 0xE4, 0x81, 0xBF },
	0xE6DE, { 0xE7, 0x9F, 0x92 },
	0xE6DF, { 0xE4, 0x83, 0xB5 },
	0xE6E0, { 0xE4, 0x83, 0xB6 },
	0xE6E1, { 0xE4, 0x83, 0xB7 },
	0xE6E2, { 0xF0, 0xA5, 0x97, 0x99 },
	0xE6E3, { 0xE4, 0x84, 0xA4 },
	0xE6E4, { 0xE4, 0x86, 0x8D },
	0xE6E5, { 0xE4, 0x86, 0x8A },
	0xE6E6, { 0xF0, 0xA5, 0xA8, 0xBF },
	0xE6E7, { 0xF0, 0xA5, 0xA8, 0xBD },
	0xE6E8, { 0xE4, 0x89, 0xAC },
	0xE6E9, { 0xE4, 0x89, 0xA6 },
	0xE6EA, { 0xE4, 0x89, 0xAA },
	0xE6EB, { 0xF0, 0xA5, 0xB6, 0x8B },
	0xE6EC, { 0xE4, 0x89, 0xA7 },
	0xE6ED, { 0xE4, 0x89, 0xAD },
	0xE6EE, { 0xE4, 0x89, 0xA8 },
	0xE6EF, { 0xE7, 0xB1, 0x92 },
	0xE6F0, { 0xF0, 0xA5, 0xB5, 0xA8 },
	0xE6F1, { 0xF0, 0xA5, 0xB6, 0x8A },
	0xE6F2, { 0xF0, 0xA5, 0xBD, 0x98 },
	0xE6F3, { 0xF0, 0xA5, 0xBD, 0x97 },
	0xE6F4, { 0xF0, 0xA6, 0x87, 0x8E },
	0xE6F5, { 0xF0, 0xA6, 0x86, 0xBC },
	0xE6F6, { 0xF0, 0xA6, 0x87, 0x80 },
	0xE6F7, { 0xF0, 0xA6, 0x87, 0x81 },
	0xE6F8, { 0xF0, 0xA6, 0x86, 0xBF },
	0xE6F9, { 0xF0, 0xA6, 0x86, 0xAB },
	0xE6FA, { 0xF0, 0xA6, 0x89, 0x9F },
	0xE6FB, { 0xE4, 0x8D, 0xA5 },
	0xE6FC, { 0xF0, 0xA6, 0x92, 0xA6 },
	0xE6FD, { 0xE4, 0x8E, 0x9A },
	0xE6FE, { 0xF0, 0xA6, 0x94, 0xA9 },
	0xE7A1, { 0xE4, 0x8E, 0xB1 },
	0xE7A2, { 0xE4, 0x91, 0x8B },
	0xE7A3, { 0xE4, 0x91, 0x8D },
	0xE7A4, { 0xE4, 0x91, 0x8C },
	0xE7A5, { 0xE4, 0x91, 0x8E },
	0xE7A6, { 0xF0, 0xA6, 0xA2, 0xB8 },
	0xE7A7, { 0xE4, 0x95, 0xB3 },
	0xE7A8, { 0xE4, 0x95, 0xB5 },
	0xE7A9, { 0xF0, 0xA7, 0x83, 0x9D },
	0xE7AA, { 0xF0, 0xA7, 0x83, 0x96 },
	0xE7AB, { 0xF0, 0xAF, 0xA6, 0xB1 },
	0xE7AC, { 0xF0, 0xA7, 0x83, 0x95 },
	0xE7AD, { 0xF0, 0xA7, 0x83, 0xA7 },
	0xE7AE, { 0xF0, 0xA7, 0x83, 0x98 },
	0xE7AF, { 0xF0, 0xA7, 0x93, 0xAC },
	0xE7B0, { 0xE4, 0x98, 0x83 },
	0xE7B1, { 0xF0, 0xA7, 0x94, 0x80 },
	0xE7B2, { 0xF0, 0xA7, 0x94, 0x87 },
	0xE7B3, { 0xF0, 0xA7, 0x93, 0xBD },
	0xE7B4, { 0xF0, 0xA7, 0x93, 0xB1 },
	0xE7B5, { 0xF0, 0xA7, 0x93, 0xBF },
	0xE7B6, { 0xF0, 0xA7, 0x9E, 0xAA },
	0xE7B7, { 0xF0, 0xA7, 0x9E, 0xB0 },
	0xE7B8, { 0xF0, 0xA7, 0xAD, 0x88 },
	0xE7B9, { 0xE4, 0x9C, 0x9E },
	0xE7BA, { 0xF0, 0xA7, 0xAD, 0x93 },
	0xE7BB, { 0xE8, 0xAD, 0xB3 },
	0xE7BC, { 0xF0, 0xA7, 0xAD, 0x8D },
	0xE7BD, { 0xE4, 0x9C, 0x99 },
	0xE7BE, { 0xE4, 0x9C, 0x9C },
	0xE7BF, { 0xE4, 0x9C, 0x9A },
	0xE7C0, { 0xE4, 0x9C, 0x9D },
	0xE7C1, { 0xE8, 0xAD, 0xB6 },
	0xE7C2, { 0xF0, 0xA7, 0xAD, 0x83 },
	0xE7C3, { 0xF0, 0xA7, 0xAD, 0x90 },
	0xE7C4, { 0xE4, 0x9D, 0x83 },
	0xE7C5, { 0xE4, 0x9D, 0x92 },
	0xE7C6, { 0xF0, 0xA7, 0xB2, 0x8C },
	0xE7C7, { 0xF0, 0xA7, 0xB8, 0xA7 },
	0xE7C8, { 0xE4, 0x9E, 0x95 },
	0xE7C9, { 0xF0, 0xA7, 0xBE, 0x99 },
	0xE7CA, { 0xE4, 0x9F, 0x8C },
	0xE7CB, { 0xF0, 0xA8, 0x86, 0xB1 },
	0xE7CC, { 0xE4, 0xA0, 0xAB },
	0xE7CD, { 0xF0, 0xA8, 0x86, 0xB0 },
	0xE7CE, { 0xF0, 0xA8, 0x86, 0xAA },
	0xE7CF, { 0xF0, 0xA8, 0x86, 0xAC },
	0xE7D0, { 0xE4, 0xA0, 0xAA },
	0xE7D1, { 0xE8, 0xBB, 0x87 },
	0xE7D2, { 0xE4, 0xA1, 0xB7 },
	0xE7D3, { 0xF0, 0xA8, 0x8F, 0x88 },
	0xE7D4, { 0xF0, 0xA8, 0x8F, 0x8A },
	0xE7D5, { 0xF0, 0xA8, 0x99, 0x82 },
	0xE7D6, { 0xF0, 0xA8, 0x9F, 0xA0 },
	0xE7D7, { 0xF0, 0xA8, 0xA3, 0xA7 },
	0xE7D8, { 0xF0, 0xA8, 0xA3, 0xA8 },
	0xE7D9, { 0xF0, 0xA8, 0xA3, 0xA6 },
	0xE7DA, { 0xE4, 0xA4, 0x93 },
	0xE7DB, { 0xE4, 0xA4, 0x94 },
	0xE7DC, { 0xE9, 0x90, 0xB4 },
	0xE7DD, { 0xF0, 0xA8, 0xAD, 0x9B },
	0xE7DE, { 0xF0, 0xA8, 0xAD, 0x96 },
	0xE7DF, { 0xE4, 0xA5, 0x9D },
	0xE7E0, { 0xF0, 0xA8, 0xAD, 0x9A },
	0xE7E1, { 0xE4, 0xA5, 0xA0 },
	0xE7E2, { 0xE9, 0x90, 0xBE },
	0xE7E3, { 0xE4, 0xA5, 0xA2 },
	0xE7E4, { 0xF0, 0xA8, 0xB2, 0xB8 },
	0xE7E5, { 0xF0, 0xA8, 0xB7, 0x85 },
	0xE7E6, { 0xE4, 0xA6, 0xB2 },
	0xE7E7, { 0xE4, 0xA7, 0xB0 },
	0xE7E8, { 0xF0, 0xA9, 0x81, 0x88 },
	0xE7E9, { 0xF0, 0xA9, 0x85, 0xBD },
	0xE7EA, { 0xF0, 0xA9, 0x85, 0xBC },
	0xE7EB, { 0xF0, 0xA9, 0x86, 0x81 },
	0xE7EC, { 0xF0, 0xA9, 0x86, 0x82 },
	0xE7ED, { 0xF0, 0xA9, 0x85, 0xA2 },
	0xE7EE, { 0xE4, 0xA9, 0x8C },
	0xE7EF, { 0xF0, 0xA9, 0x8D, 0x85 },
	0xE7F0, { 0xE4, 0xAA, 0x82 },
	0xE7F1, { 0xE9, 0x9E, 0xBC },
	0xE7F2, { 0xE4, 0xAA, 0x81 },
	0xE7F3, { 0xE4, 0xAA, 0x9B },
	0xE7F4, { 0xF0, 0xA9, 0x8F, 0xA3 },
	0xE7F5, { 0xE4, 0xAA, 0xA4 },
	0xE7F6, { 0xE4, 0xAB, 0xAE },
	0xE7F7, { 0xE4, 0xAB, 0xAC },
	0xE7F8, { 0xF0, 0xA9, 0x95, 0x90 },
	0xE7F9, { 0xE4, 0xAB, 0xAD },
	0xE7FA, { 0xF0, 0xA9, 0x95, 0x8F },
	0xE7FB, { 0xE4, 0xAB, 0xB0 },
	0xE7FC, { 0xE4, 0xAB, 0xAF },
	0xE7FD, { 0xF0, 0xA9, 0x98, 0xB9 },
	0xE7FE, { 0xE4, 0xAC, 0x9D },
	0xE8A1, { 0xF0, 0xA9, 0x98, 0xBA },
	0xE8A2, { 0xE4, 0xAD, 0xA0 },
	0xE8A3, { 0xE4, 0xAD, 0x9E },
	0xE8A4, { 0xE4, 0xAD, 0x9D },
	0xE8A5, { 0xF0, 0xA9, 0x9F, 0x81 },
	0xE8A6, { 0xF0, 0xA9, 0xA5, 0x8E },
	0xE8A7, { 0xF0, 0xA9, 0xA5, 0xAE },
	0xE8A8, { 0xE4, 0xAE, 0xB1 },
	0xE8A9, { 0xE4, 0xAE, 0xAB },
	0xE8AA, { 0xE4, 0xAE, 0xAC },
	0xE8AB, { 0xE4, 0xAE, 0xAD },
	0xE8AC, { 0xF0, 0xA9, 0xA5, 0xB1 },
	0xE8AD, { 0xE4, 0xAE, 0xAE },
	0xE8AE, { 0xF0, 0xA9, 0xAA, 0x8C },
	0xE8AF, { 0xF0, 0xA9, 0xAA, 0x89 },
	0xE8B0, { 0xE4, 0xAF, 0xA2 },
	0xE8B1, { 0xF0, 0xA9, 0xAB, 0xA5 },
	0xE8B2, { 0xF0, 0xA9, 0xAE, 0xB3 },
	0xE8B3, { 0xF0, 0xA9, 0xAE, 0xB6 },
	0xE8B4, { 0xF0, 0xA9, 0xAE, 0xB4 },
	0xE8B5, { 0xF0, 0xA9, 0xB1, 0x8D },
	0xE8B6, { 0xE9, 0xAC, 0xB9 },
	0xE8B7, { 0xF0, 0xA9, 0xB4, 0x93 },
	0xE8B8, { 0xF0, 0xA9, 0xB9, 0xB8 },
	0xE8B9, { 0xE9, 0xB0, 0xAA },
	0xE8BA, { 0xE4, 0xB1, 0xBB },
	0xE8BB, { 0xE9, 0xB0, 0xA6 },
	0xE8BC, { 0xE4, 0xB1, 0xB8 },
	0xE8BD, { 0xE4, 0xB1, 0xB5 },
	0xE8BE, { 0xE9, 0xB0, 0xA7 },
	0xE8BF, { 0xF0, 0xA9, 0xB9, 0xB2 },
	0xE8C0, { 0xE4, 0xB3, 0xB2 },
	0xE8C1, { 0xE4, 0xB3, 0xB4 },
	0xE8C2, { 0xE4, 0xB3, 0xB3 },
	0xE8C3, { 0xE9, 0xB7, 0x80 },
	0xE8C4, { 0xE9, 0xB7, 0x89 },
	0xE8C5, { 0xF0, 0xAA, 0x89, 0xB5 },
	0xE8C6, { 0xF0, 0xAA, 0x8B, 0x9A },
	0xE8C7, { 0xF0, 0xAA, 0x8B, 0x97 },
	0xE8C8, { 0xE4, 0xB4, 0xBF },
	0xE8C9, { 0xE4, 0xB4, 0xBE },
	0xE8CA, { 0xE4, 0xB5, 0x80 },
	0xE8CB, { 0xE4, 0xB5, 0x8E },
	0xE8CC, { 0xE4, 0xB5, 0x97 },
	0xE8CD, { 0xE4, 0xB5, 0x99 },
	0xE8CE, { 0xE4, 0xB5, 0x98 },
	0xE8CF, { 0xF0, 0xAF, 0xA8, 0x96 },
	0xE8D0, { 0xF0, 0xAA, 0x91, 0xA9 },
	0xE8D1, { 0xF0, 0xAA, 0x91, 0xA7 },
	0xE8D2, { 0xE4, 0xB5, 0xAE },
	0xE8D3, { 0xF0, 0xAA, 0x91, 0xA6 },
	0xE8D4, { 0xF0, 0xAA, 0x91, 0xAF },
	0xE8D5, { 0xF0, 0xAA, 0x91, 0xB1 },
	0xE8D6, { 0xE9, 0xBB, 0xAC },
	0xE8D7, { 0xF0, 0xAA, 0x93, 0x8F },
	0xE8D8, { 0xF0, 0xAA, 0x94, 0xA3 },
	0xE8D9, { 0xE4, 0xB6, 0x81 },
	0xE8DA, { 0xE4, 0xB6, 0x86 },
	0xE8DB, { 0xF0, 0xAA, 0x96, 0xA5 },
	0xE8DC, { 0xE4, 0xB6, 0x8F },
	0xE8DD, { 0xF0, 0xAA, 0x97, 0xBE },
	0xE8DE, { 0xF0, 0xAA, 0x97, 0xBB },
	0xE8DF, { 0xF0, 0xAA, 0x97, 0xBD },
	0xE8E0, { 0xE9, 0xBD, 0xA8 },
	0xE8E1, { 0xE4, 0xB6, 0x9B },
	0xE8E2, { 0xE4, 0xB6, 0xB1 },
	0xE8E3, { 0xE4, 0xB6, 0xB3 },
	0xE8E4, { 0xF0, 0xA1, 0x85, 0xAD },
	0xE8E5, { 0xE3, 0x9C, 0xBA },
	0xE8E6, { 0xF0, 0xA1, 0xAC, 0x85 },
	0xE8E7, { 0xF0, 0xA1, 0xB0, 0xA0 },
	0xE8E8, { 0xE3, 0xA0, 0xA7 },
	0xE8E9, { 0xF0, 0xA1, 0xBF, 0x88 },
	0xE8EA, { 0xF0, 0xA1, 0xBF, 0x89 },
	0xE8EB, { 0xE3, 0xA1, 0xAA },
	0xE8EC, { 0xE3, 0xA6, 0xAC },
	0xE8ED, { 0xF0, 0xA3, 0x84, 0xA7 },
	0xE8EE, { 0xE3, 0xB0, 0x98 },
	0xE8EF, { 0xF0, 0xA3, 0xA0, 0x9E },
	0xE8F0, { 0xF0, 0xA3, 0xA4, 0xB6 },
	0xE8F1, { 0xE3, 0xB1, 0x8C },
	0xE8F2, { 0xF0, 0xA4, 0x84, 0xBD },
	0xE8F3, { 0xE3, 0xB6, 0x96 },
	0xE8F4, { 0xF0, 0xA4, 0xA3, 0x97 },
	0xE8F5, { 0xE3, 0xBD, 0x8A },
	0xE8F6, { 0xF0, 0xA4, 0xAE, 0xAD },
	0xE8F7, { 0xF0, 0xA4, 0xB4, 0x80 },
	0xE8F8, { 0xE4, 0x82, 0x81 },
	0xE8F9, { 0xF0, 0xA5, 0x8C, 0xBA },
	0xE8FA, { 0xE4, 0x82, 0x83 },
	0xE8FB, { 0xE4, 0x83, 0xB9 },
	0xE8FC, { 0xE4, 0x83, 0xB8 },
	0xE8FD, { 0xF0, 0xA5, 0x9C, 0xA6 },
	0xE8FE, { 0xE4, 0x86, 0x8E },
	0xE9A1, { 0xE4, 0x86, 0x8F },
	0xE9A2, { 0xE4, 0x87, 0x81 },
	0xE9A3, { 0xF0, 0xA5, 0xB6, 0xB7 },
	0xE9A4, { 0xF0, 0xA5, 0xB6, 0xB6 },
	0xE9A5, { 0xF0, 0xA5, 0xB7, 0x80 },
	0xE9A6, { 0xE4, 0x89, 0xB0 },
	0xE9A7, { 0xF0, 0xA5, 0xB6, 0x9B },
	0xE9A8, { 0xE4, 0x89, 0xB1 },
	0xE9A9, { 0xF0, 0xA6, 0x87, 0x98 },
	0xE9AA, { 0xE4, 0x8C, 0xAA },
	0xE9AB, { 0xE4, 0x8C, 0xAD },
	0xE9AC, { 0xE4, 0x8D, 0xBD },
	0xE9AD, { 0xE8, 0x80, 0xB2 },
	0xE9AE, { 0xE8, 0x80, 0xB1 },
	0xE9AF, { 0xF0, 0xA6, 0xA3, 0x80 },
	0xE9B0, { 0xE4, 0x91, 0x8F },
	0xE9B1, { 0xF0, 0xA6, 0xA2, 0xBF },
	0xE9B2, { 0xF0, 0xA6, 0xAA, 0xBF },
	0xE9B3, { 0xE4, 0x92, 0x90 },
	0xE9B4, { 0xF0, 0xA7, 0x84, 0xA0 },
	0xE9B5, { 0xF0, 0xA7, 0x83, 0x90 },
	0xE9B6, { 0xF0, 0xA7, 0x84, 0x8E },
	0xE9B7, { 0xE4, 0x95, 0xB9 },
	0xE9B8, { 0xF0, 0xA7, 0x84, 0x9D },
	0xE9B9, { 0xF0, 0xA7, 0x84, 0x9E },
	0xE9BA, { 0xF0, 0xA7, 0x84, 0x95 },
	0xE9BB, { 0xF0, 0xA7, 0x84, 0x94 },
	0xE9BC, { 0xF0, 0xA7, 0x94, 0x9E },
	0xE9BD, { 0xF0, 0xA7, 0x94, 0xAC },
	0xE9BE, { 0xE4, 0x98, 0x85 },
	0xE9BF, { 0xF0, 0xA7, 0x9E, 0xB9 },
	0xE9C0, { 0xF0, 0xA7, 0x9E, 0xB8 },
	0xE9C1, { 0xF0, 0xA7, 0x9E, 0xB6 },
	0xE9C2, { 0xF0, 0xA7, 0xA2, 0x9E },
	0xE9C3, { 0xF0, 0xA7, 0xA2, 0x9C },
	0xE9C4, { 0xF0, 0xA7, 0xA5, 0x8D },
	0xE9C5, { 0xE8, 0xA7, 0xBD },
	0xE9C6, { 0xF0, 0xA7, 0xAD, 0xAE },
	0xE9C7, { 0xF0, 0xA7, 0xAD, 0xA0 },
	0xE9C8, { 0xE4, 0x9C, 0xA1 },
	0xE9C9, { 0xF0, 0xA7, 0xAD, 0xA4 },
	0xE9CA, { 0xF0, 0xA7, 0xAD, 0xA2 },
	0xE9CB, { 0xF0, 0xA6, 0x87, 0xA5 },
	0xE9CC, { 0xE4, 0x9C, 0xB2 },
	0xE9CD, { 0xF0, 0xA7, 0xBE, 0xA3 },
	0xE9CE, { 0xE4, 0x9F, 0x8D },
	0xE9CF, { 0xE4, 0x9F, 0x8F },
	0xE9D0, { 0xF0, 0xA8, 0x8F, 0x92 },
	0xE9D1, { 0xF0, 0xA8, 0x8F, 0x95 },
	0xE9D2, { 0xE9, 0x82, 0x8E },
	0xE9D3, { 0xE4, 0xA4, 0x96 },
	0xE9D4, { 0xE4, 0xA4, 0x95 },
	0xE9D5, { 0xE4, 0xA6, 0xB5 },
	0xE9D6, { 0xE4, 0xA8, 0x88 },
	0xE9D7, { 0xF0, 0xA9, 0x81, 0x95 },
	0xE9D8, { 0xE4, 0xA8, 0xB2 },
	0xE9D9, { 0xF0, 0xA9, 0x86, 0x93 },
	0xE9DA, { 0xE4, 0xA8, 0xB3 },
	0xE9DB, { 0xE4, 0xA8, 0xB4 },
	0xE9DC, { 0xE4, 0xA8, 0xBC },
	0xE9DD, { 0xF0, 0xA9, 0x8D, 0x96 },
	0xE9DE, { 0xE9, 0x9F, 0x82 },
	0xE9DF, { 0xF0, 0xA9, 0x8F, 0xA9 },
	0xE9E0, { 0xE4, 0xAA, 0x9C },
	0xE9E1, { 0xF0, 0xA9, 0x91, 0x85 },
	0xE9E2, { 0xE4, 0xAB, 0xB4 },
	0xE9E3, { 0xE4, 0xAB, 0xB2 },
	0xE9E4, { 0xF0, 0xA9, 0x99, 0xBC },
	0xE9E5, { 0xE4, 0xAD, 0xA2 },
	0xE9E6, { 0xF0, 0xA9, 0x9F, 0x93 },
	0xE9E7, { 0xE4, 0xAD, 0xA1 },
	0xE9E8, { 0xE4, 0xAD, 0xA4 },
	0xE9E9, { 0xE4, 0xAE, 0xB5 },
	0xE9EA, { 0xE9, 0xA9, 0x8B },
	0xE9EB, { 0xE4, 0xAE, 0xB4 },
	0xE9EC, { 0xF0, 0xA9, 0xA6, 0x8E },
	0xE9ED, { 0xF0, 0xA9, 0xAA, 0x97 },
	0xE9EE, { 0xE4, 0xAF, 0xA3 },
	0xE9EF, { 0xF0, 0xA9, 0xAA, 0x9B },
	0xE9F0, { 0xF0, 0xA9, 0xAA, 0x99 },
	0xE9F1, { 0xE9, 0xAC, 0x9C },
	0xE9F2, { 0xE4, 0xB0, 0x8E },
	0xE9F3, { 0xF0, 0xA9, 0xAF, 0x8F },
	0xE9F4, { 0xE9, 0xAC, 0x9B },
	0xE9F5, { 0xF0, 0xA9, 0xB1, 0x99 },
	0xE9F6, { 0xE4, 0xB0, 0xAC },
	0xE9F7, { 0xE4, 0xB0, 0xAB },
	0xE9F8, { 0xF0, 0xA9, 0xB4, 0xA0 },
	0xE9F9, { 0xF0, 0xA9, 0xB4, 0xA3 },
	0xE9FA, { 0xF0, 0xA9, 0xB4, 0xAA },
	0xE9FB, { 0xE4, 0xB2, 0x85 },
	0xE9FC, { 0xE4, 0xB2, 0x81 },
	0xE9FD, { 0xE4, 0xB1, 0xBE },
	0xE9FE, { 0xE4, 0xB2, 0x83 },
	0xEAA1, { 0xE4, 0xB2, 0x80 },
	0xEAA2, { 0xF0, 0xA9, 0xBA, 0xB0 },
	0xEAA3, { 0xE9, 0xB1, 0x82 },
	0xEAA4, { 0xF0, 0xAA, 0x84, 0xAF },
	0xEAA5, { 0xE9, 0xB7, 0x94 },
	0xEAA6, { 0xE4, 0xB3, 0xBB },
	0xEAA7, { 0xE4, 0xB3, 0xB7 },
	0xEAA8, { 0xF0, 0xAA, 0x84, 0xB2 },
	0xEAA9, { 0xF0, 0xAA, 0x85, 0x83 },
	0xEAAA, { 0xF0, 0xAA, 0x84, 0xBF },
	0xEAAB, { 0xF0, 0xAA, 0x84, 0xB9 },
	0xEAAC, { 0xE4, 0xB3, 0xB8 },
	0xEAAD, { 0xF0, 0xAA, 0x84, 0xB0 },
	0xEAAE, { 0xF0, 0xAA, 0x8B, 0x9D },
	0xEAAF, { 0xF0, 0xAA, 0x8F, 0x9A },
	0xEAB0, { 0xF0, 0xAA, 0x8F, 0x9B },
	0xEAB1, { 0xE4, 0xB5, 0x9A },
	0xEAB2, { 0xF0, 0xAA, 0x92, 0x84 },
	0xEAB3, { 0xF0, 0xAA, 0x91, 0xBF },
	0xEAB4, { 0xF0, 0xAA, 0x91, 0xB2 },
	0xEAB5, { 0xF0, 0xAA, 0x92, 0x80 },
	0xEAB6, { 0xF0, 0xAA, 0x93, 0xAE },
	0xEAB7, { 0xE4, 0xB5, 0xB8 },
	0xEAB8, { 0xF0, 0xAA, 0x94, 0xAA },
	0xEAB9, { 0xF0, 0xAA, 0x94, 0xA2 },
	0xEABA, { 0xF0, 0xAA, 0x95, 0xB1 },
	0xEABB, { 0xF0, 0xAA, 0x97, 0x8D },
	0xEABC, { 0xE4, 0xB6, 0x9D },
	0xEABD, { 0xE4, 0xB6, 0x9C },
	0xEABE, { 0xF0, 0xAA, 0x98, 0x8F },
	0xEABF, { 0xF0, 0xAA, 0x98, 0x98 },
	0xEAC0, { 0xF0, 0xA0, 0x91, 0xAA },
	0xEAC1, { 0xE3, 0x92, 0xA9 },
	0xEAC2, { 0xE3, 0x92, 0xBF },
	0xEAC3, { 0xE5, 0x9B, 0x90 },
	0xEAC4, { 0xE5, 0x9B, 0x8F },
	0xEAC5, { 0xF0, 0xA1, 0xAC, 0x8C },
	0xEAC6, { 0xE5, 0xB7, 0x9A },
	0xEAC7, { 0xF0, 0xA2, 0x96, 0xA6 },
	0xEAC8, { 0xE3, 0xA9, 0xB7 },
	0xEAC9, { 0xE3, 0xA9, 0xB6 },
	0xEACA, { 0xF0, 0xA3, 0x80, 0xB7 },
	0xEACB, { 0xE3, 0xAA, 0xBB },
	0xEACC, { 0xE6, 0x9B, 0xAA },
	0xEACD, { 0xF0, 0xA3, 0xAB, 0xA2 },
	0xEACE, { 0xE3, 0xB6, 0x9B },
	0xEACF, { 0xF0, 0xA4, 0x92, 0xBC },
	0xEAD0, { 0xE3, 0xB8, 0x8F },
	0xEAD1, { 0xE3, 0xB9, 0x9B },
	0xEAD2, { 0xF0, 0xA4, 0xAB, 0x95 },
	0xEAD3, { 0xE3, 0xBD, 0x8C },
	0xEAD4, { 0xE3, 0xBD, 0xAF },
	0xEAD5, { 0xE3, 0xBF, 0x99 },
	0xEAD6, { 0xF0, 0xA4, 0xBC, 0x92 },
	0xEAD7, { 0xE4, 0x82, 0x82 },
	0xEAD8, { 0xF0, 0xA5, 0x8D, 0x8B },
	0xEAD9, { 0xF0, 0xA5, 0x8D, 0x81 },
	0xEADA, { 0xF0, 0xA5, 0x8E, 0xA1 },
	0xEADB, { 0xF0, 0xA5, 0x97, 0xAC },
	0xEADC, { 0xE4, 0x89, 0xB4 },
	0xEADD, { 0xE4, 0x89, 0xB2 },
	0xEADE, { 0xF0, 0xA5, 0xB7, 0x94 },
	0xEADF, { 0xF0, 0xA5, 0xB7, 0x98 },
	0xEAE0, { 0xF0, 0xA5, 0xB7, 0x99 },
	0xEAE1, { 0xE4, 0x89, 0xB3 },
	0xEAE2, { 0xF0, 0xA5, 0xB7, 0x9A },
	0xEAE3, { 0xF0, 0xA5, 0xBD, 0xAC },
	0xEAE4, { 0xF0, 0xA5, 0xBD, 0xAD },
	0xEAE5, { 0xE4, 0x8A, 0xB1 },
	0xEAE6, { 0xE4, 0x8C, 0xAE },
	0xEAE7, { 0xF0, 0xA6, 0x87, 0xA7 },
	0xEAE8, { 0xF0, 0xA6, 0x87, 0xAB },
	0xEAE9, { 0xF0, 0xA6, 0x87, 0xAC },
	0xEAEA, { 0xF0, 0xA6, 0x89, 0xA2 },
	0xEAEB, { 0xE4, 0x8D, 0x8E },
	0xEAEC, { 0xF0, 0xA6, 0x94, 0xAB },
	0xEAED, { 0xF0, 0xA6, 0x98, 0x8D },
	0xEAEE, { 0xF0, 0xA6, 0xA3, 0x8D },
	0xEAEF, { 0xF0, 0xA6, 0xAB, 0x83 },
	0xEAF0, { 0xF0, 0xA7, 0x84, 0xBF },
	0xEAF1, { 0xF0, 0xA7, 0x84, 0xBC },
	0xEAF2, { 0xF0, 0xA7, 0x84, 0xBE },
	0xEAF3, { 0xF0, 0xA7, 0x84, 0xBD },
	0xEAF4, { 0xF0, 0xA7, 0x84, 0xBA },
	0xEAF5, { 0xF0, 0xA7, 0x84, 0xB8 },
	0xEAF6, { 0xF0, 0xA7, 0x95, 0x84 },
	0xEAF7, { 0xF0, 0xA7, 0x95, 0x85 },
	0xEAF8, { 0xE4, 0x98, 0x8B },
	0xEAF9, { 0xF0, 0xA7, 0x95, 0x88 },
	0xEAFA, { 0xF0, 0xA7, 0x95, 0x90 },
	0xEAFB, { 0xE4, 0x99, 0xAC },
	0xEAFC, { 0xE8, 0xAE, 0x89 },
	0xEAFD, { 0xF0, 0xA7, 0xAD, 0xB8 },
	0xEAFE, { 0xF0, 0xA7, 0xAD, 0xB9 },
	0xEBA1, { 0xE4, 0x9E, 0x8B },
	0xEBA2, { 0xF0, 0xA7, 0xB8, 0xBE },
	0xEBA3, { 0xE4, 0x9F, 0x90 },
	0xEBA4, { 0xE4, 0xA0, 0xAD },
	0xEBA5, { 0xF0, 0xA8, 0x99, 0x94 },
	0xEBA6, { 0xE4, 0xA3, 0xA4 },
	0xEBA7, { 0xE4, 0xA5, 0xB1 },
	0xEBA8, { 0xF0, 0xA8, 0xAE, 0xB9 },
	0xEBA9, { 0xE9, 0x91, 0x98 },
	0xEBAA, { 0xE4, 0xA5, 0xAF },
	0xEBAB, { 0xF0, 0xA9, 0x81, 0x9F },
	0xEBAC, { 0xE4, 0xAA, 0x87 },
	0xEBAD, { 0xE4, 0xAA, 0xA5 },
	0xEBAE, { 0xF0, 0xA9, 0x95, 0xB2 },
	0xEBAF, { 0xF0, 0xA9, 0x95, 0xB5 },
	0xEBB0, { 0xE4, 0xAC, 0x9E },
	0xEBB1, { 0xE4, 0xAD, 0xA5 },
	0xEBB2, { 0xE4, 0xAE, 0xB9 },
	0xEBB3, { 0xE4, 0xAE, 0xB7 },
	0xEBB4, { 0xE4, 0xAE, 0xB8 },
	0xEBB5, { 0xE4, 0xAF, 0xA4 },
	0xEBB6, { 0xF0, 0xA9, 0xAA, 0xA3 },
	0xEBB7, { 0xF0, 0xA9, 0xAA, 0xA5 },
	0xEBB8, { 0xF0, 0xA9, 0xAF, 0x9C },
	0xEBB9, { 0xF0, 0xA9, 0xAF, 0x9D },
	0xEBBA, { 0xF0, 0xA9, 0xB1, 0x9A },
	0xEBBB, { 0xE4, 0xB2, 0x8C },
	0xEBBC, { 0xE4, 0xB2, 0x89 },
	0xEBBD, { 0xE4, 0xB2, 0x8A },
	0xEBBE, { 0xF0, 0xA9, 0xBB, 0x9B },
	0xEBBF, { 0xF0, 0xA9, 0xBB, 0x9C },
	0xEBC0, { 0xE4, 0xB2, 0x8B },
	0xEBC1, { 0xF0, 0xAA, 0x86, 0xAB },
	0xEBC2, { 0xF0, 0xAA, 0x86, 0x84 },
	0xEBC3, { 0xF0, 0xAA, 0x85, 0xB6 },
	0xEBC4, { 0xE4, 0xB4, 0x81 },
	0xEBC5, { 0xE4, 0xB3, 0xBE },
	0xEBC6, { 0xE9, 0xB7, 0xA7 },
	0xEBC7, { 0xE4, 0xB4, 0x83 },
	0xEBC8, { 0xE4, 0xB4, 0x86 },
	0xEBC9, { 0xF0, 0xAA, 0x86, 0x83 },
	0xEBCA, { 0xE9, 0xB7, 0xAA },
	0xEBCB, { 0xE9, 0xB7, 0xB1 },
	0xEBCC, { 0xF0, 0xAA, 0x89, 0xBF },
	0xEBCD, { 0xE4, 0xB4, 0x9D },
	0xEBCE, { 0xE4, 0xB5, 0x83 },
	0xEBCF, { 0xF0, 0xAA, 0x8D, 0xB3 },
	0xEBD0, { 0xF0, 0xAA, 0x8E, 0xAD },
	0xEBD1, { 0xF0, 0xAA, 0x8E, 0xB0 },
	0xEBD2, { 0xE4, 0xB5, 0x8F },
	0xEBD3, { 0xF0, 0xAA, 0x90, 0x8F },
	0xEBD4, { 0xF0, 0xAA, 0x90, 0x8C },
	0xEBD5, { 0xE4, 0xB5, 0x9B },
	0xEBD6, { 0xE4, 0xB5, 0xB0 },
	0xEBD7, { 0xF0, 0xAA, 0x95, 0xB9 },
	0xEBD8, { 0xE4, 0xB6, 0x88 },
	0xEBD9, { 0xF0, 0xAA, 0x95, 0xB7 },
	0xEBDA, { 0xF0, 0xAA, 0x95, 0xBA },
	0xEBDB, { 0xE4, 0xB6, 0x89 },
	0xEBDC, { 0xE9, 0xBD, 0x84 },
	0xEBDD, { 0xF0, 0xAA, 0x98, 0xB2 },
	0xEBDE, { 0xF0, 0xAA, 0x98, 0xA7 },
	0xEBDF, { 0xF0, 0xAA, 0x98, 0xAA },
	0xEBE0, { 0xF0, 0xAA, 0x98, 0xAC },
	0xEBE1, { 0xE9, 0xBD, 0xAD },
	0xEBE2, { 0xF0, 0xAA, 0x98, 0xA8 },
	0xEBE3, { 0xF0, 0xAA, 0x98, 0xA9 },
	0xEBE4, { 0xF0, 0xAA, 0x98, 0xB8 },
	0xEBE5, { 0xF0, 0xA0, 0xA0, 0xAF },
	0xEBE6, { 0xF0, 0xA1, 0x85, 0xBB },
	0xEBE7, { 0xF0, 0xA1, 0xAC, 0x8D },
	0xEBE8, { 0xE5, 0xB7, 0x99 },
	0xEBE9, { 0xF0, 0xA1, 0xBF, 0x96 },
	0xEBEA, { 0xF0, 0xA1, 0xBF, 0x95 },
	0xEBEB, { 0xF0, 0xA2, 0xBA, 0xA1 },
	0xEBEC, { 0xF0, 0xA3, 0xA1, 0x8C },
	0xEBED, { 0xE3, 0xB6, 0x9E },
	0xEBEE, { 0xE3, 0xB6, 0x9F },
	0xEBEF, { 0xE3, 0xBA, 0xA7 },
	0xEBF0, { 0xE3, 0xBD, 0x8B },
	0xEBF1, { 0xE3, 0xBF, 0x9B },
	0xEBF2, { 0xE3, 0xBF, 0x9A },
	0xEBF3, { 0xF0, 0xA4, 0xBF, 0x80 },
	0xEBF4, { 0xE7, 0x9F, 0x96 },
	0xEBF5, { 0xE4, 0x82, 0x8E },
	0xEBF6, { 0xE4, 0x89, 0xB6 },
	0xEBF7, { 0xF0, 0xA5, 0xB7, 0xB4 },
	0xEBF8, { 0xE4, 0x8C, 0xB0 },
	0xEBF9, { 0xE4, 0x8C, 0xAF },
	0xEBFA, { 0xF0, 0xA6, 0x87, 0xB0 },
	0xEBFB, { 0xE4, 0x8D, 0xA6 },
	0xEBFC, { 0xF0, 0xA6, 0x8C, 0xBF },
	0xEBFD, { 0xE4, 0x95, 0xBE },
	0xEBFE, { 0xF0, 0xA7, 0x95, 0x9D },
	0xECA1, { 0xF0, 0xA7, 0x95, 0xB2 },
	0xECA2, { 0xF0, 0xA7, 0x95, 0xA2 },
	0xECA3, { 0xE8, 0xA0, 0xBA },
	0xECA4, { 0xF0, 0xA7, 0x95, 0xA6 },
	0xECA5, { 0xE8, 0xA5, 0xB5 },
	0xECA6, { 0xE4, 0x99, 0xAF },
	0xECA7, { 0xF0, 0xA7, 0xAE, 0x88 },
	0xECA8, { 0xE4, 0x9F, 0x91 },
	0xECA9, { 0xE4, 0xA0, 0xAF },
	0xECAA, { 0xF0, 0xA8, 0x87, 0xA8 },
	0xECAB, { 0xF0, 0xA8, 0x87, 0xA4 },
	0xECAC, { 0xE4, 0xA2, 0xB2 },
	0xECAD, { 0xE4, 0xA4, 0x98 },
	0xECAE, { 0xE4, 0xA4, 0x97 },
	0xECAF, { 0xF0, 0xA8, 0xA3, 0xBF },
	0xECB0, { 0xE4, 0xA5, 0xB6 },
	0xECB1, { 0xF0, 0xA9, 0x86, 0xAF },
	0xECB2, { 0xF0, 0xA9, 0x86, 0xAE },
	0xECB3, { 0xE4, 0xA9, 0x8F },
	0xECB4, { 0xE4, 0xAA, 0x89 },
	0xECB5, { 0xF0, 0xA9, 0x8F, 0xB2 },
	0xECB6, { 0xF0, 0xA9, 0x91, 0x88 },
	0xECB7, { 0xF0, 0xA9, 0x96, 0x81 },
	0xECB8, { 0xF0, 0xA9, 0x95, 0xBE },
	0xECB9, { 0xE4, 0xAB, 0xB5 },
	0xECBA, { 0xE4, 0xAC, 0x9F },
	0xECBB, { 0xF0, 0xA9, 0x99, 0x92 },
	0xECBC, { 0xF0, 0xA9, 0x9F, 0xAF },
	0xECBD, { 0xE9, 0xA9, 0x9D },
	0xECBE, { 0xE4, 0xAF, 0xA5 },
	0xECBF, { 0xF0, 0xA9, 0xAA, 0xAD },
	0xECC0, { 0xF0, 0xA9, 0xAF, 0xA6 },
	0xECC1, { 0xE4, 0xB0, 0x90 },
	0xECC2, { 0xF0, 0xA9, 0xAF, 0xAD },
	0xECC3, { 0xE4, 0xB0, 0x8F },
	0xECC4, { 0xF0, 0xA9, 0xAF, 0xA9 },
	0xECC5, { 0xF0, 0xA9, 0xB1, 0xA1 },
	0xECC6, { 0xF0, 0xA9, 0xB1, 0xA0 },
	0xECC7, { 0xF0, 0xA9, 0xB4, 0xB3 },
	0xECC8, { 0xE4, 0xB0, 0xAF },
	0xECC9, { 0xE4, 0xB0, 0xB0 },
	0xECCA, { 0xE9, 0xB1, 0xA4 },
	0xECCB, { 0xF0, 0xA9, 0xBC, 0x8B },
	0xECCC, { 0xF0, 0xA9, 0xBC, 0x88 },
	0xECCD, { 0xE4, 0xB2, 0x93 },
	0xECCE, { 0xE4, 0xB2, 0x94 },
	0xECCF, { 0xF0, 0xA9, 0xBC, 0x87 },
	0xECD0, { 0xE4, 0xB4, 0x87 },
	0xECD1, { 0xE4, 0xB4, 0x89 },
	0xECD2, { 0xE4, 0xB4, 0x88 },
	0xECD3, { 0xF0, 0xAA, 0x87, 0x8A },
	0xECD4, { 0xE4, 0xB4, 0x8B },
	0xECD5, { 0xF0, 0xAA, 0x87, 0x86 },
	0xECD6, { 0xE9, 0xB8, 0x8A },
	0xECD7, { 0xF0, 0xAA, 0x8A, 0x84 },
	0xECD8, { 0xF0, 0xAA, 0x8B, 0xAB },
	0xECD9, { 0xF0, 0xAA, 0x8D, 0xBD },
	0xECDA, { 0xE4, 0xB5, 0x90 },
	0xECDB, { 0xE4, 0xB5, 0xB1 },
	0xECDC, { 0xF0, 0xAA, 0x92, 0x9B },
	0xECDD, { 0xF0, 0xAA, 0x92, 0xA2 },
	0xECDE, { 0xF0, 0xAA, 0x92, 0xA1 },
	0xECDF, { 0xF0, 0xAA, 0x92, 0xA0 },
	0xECE0, { 0xF0, 0xAA, 0x92, 0x9C },
	0xECE1, { 0xE4, 0xB5, 0xBB },
	0xECE2, { 0xE4, 0xB5, 0xBC },
	0xECE3, { 0xF0, 0xAA, 0x96, 0x80 },
	0xECE4, { 0xE9, 0xBD, 0xB3 },
	0xECE5, { 0xF0, 0xAA, 0x99, 0x80 },
	0xECE6, { 0xE4, 0xB6, 0xA1 },
	0xECE7, { 0xF0, 0xAA, 0x98, 0xB9 },
	0xECE8, { 0xF0, 0xAA, 0x98, 0xBC },
	0xECE9, { 0xE4, 0xB6, 0xA0 },
	0xECEA, { 0xE4, 0xB6, 0xA2 },
	0xECEB, { 0xF0, 0xA0, 0xA3, 0x8A },
	0xECEC, { 0xE3, 0x98, 0x9B },
	0xECED, { 0xF0, 0xA1, 0x86, 0x89 },
	0xECEE, { 0xE3, 0x9A, 0x82 },
	0xECEF, { 0xF0, 0xA3, 0x80, 0xBC },
	0xECF0, { 0xF0, 0xA3, 0xA5, 0x80 },
	0xECF1, { 0xF0, 0xA4, 0x85, 0xA3 },
	0xECF2, { 0xF0, 0xA4, 0x85, 0xA9 },
	0xECF3, { 0xE3, 0xBF, 0xA9 },
	0xECF4, { 0xF0, 0xA5, 0x8D, 0x93 },
	0xECF5, { 0xE4, 0x82, 0x84 },
	0xECF6, { 0xE7, 0x9F, 0xA1 },
	0xECF7, { 0xF0, 0xA5, 0xA4, 0x97 },
	0xECF8, { 0xF0, 0xA5, 0xA4, 0x9A },
	0xECF9, { 0xF0, 0xA5, 0xB8, 0x80 },
	0xECFA, { 0xE4, 0x8A, 0xB3 },
	0xECFB, { 0xE4, 0x8C, 0xB4 },
	0xECFC, { 0xE4, 0x8C, 0xB3 },
	0xECFD, { 0xE4, 0x96, 0x80 },
	0xECFE, { 0xF0, 0xA7, 0x95, 0xAF },
	0xEDA1, { 0xF0, 0xA7, 0xA2, 0xAB },
	0xEDA2, { 0xE4, 0x9A, 0xAD },
	0xEDA3, { 0xF0, 0xA7, 0xAE, 0x91 },
	0xEDA4, { 0xE4, 0x9D, 0x84 },
	0xEDA5, { 0xE4, 0x9D, 0x95 },
	0xEDA6, { 0xF0, 0xA7, 0xBE, 0xB1 },
	0xEDA7, { 0xE4, 0x9F, 0x92 },
	0xEDA8, { 0xF0, 0xA8, 0x87, 0xAF },
	0xEDA9, { 0xF0, 0xA8, 0xB7, 0xB1 },
	0xEDAA, { 0xF0, 0xA8, 0xB7, 0xB2 },
	0xEDAB, { 0xF0, 0xA9, 0x86, 0xB7 },
	0xEDAC, { 0xF0, 0xA9, 0x86, 0xB5 },
	0xEDAD, { 0xE4, 0xAA, 0x8A },
	0xEDAE, { 0xF0, 0xA9, 0x96, 0x86 },
	0xEDAF, { 0xF0, 0xA9, 0x99, 0x9A },
	0xEDB0, { 0xE4, 0xAD, 0xA7 },
	0xEDB1, { 0xF0, 0xA9, 0xA7, 0x86 },
	0xEDB2, { 0xF0, 0xA9, 0xA7, 0x8B },
	0xEDB3, { 0xE4, 0xAF, 0xA6 },
	0xEDB4, { 0xF0, 0xA9, 0xAA, 0xB2 },
	0xEDB5, { 0xE4, 0xB0, 0x93 },
	0xEDB6, { 0xF0, 0xA9, 0xAF, 0xB3 },
	0xEDB7, { 0xE9, 0xAC, 0xAD },
	0xEDB8, { 0xF0, 0xA9, 0xBC, 0xA7 },
	0xEDB9, { 0xE4, 0xB2, 0x97 },
	0xEDBA, { 0xE9, 0xB8, 0x8C },
	0xEDBB, { 0xF0, 0xAA, 0x87, 0x95 },
	0xEDBC, { 0xF0, 0xAA, 0x87, 0x98 },
	0xEDBD, { 0xE4, 0xB4, 0x8C },
	0xEDBE, { 0xF0, 0xAA, 0x87, 0xAC },
	0xEDBF, { 0xF0, 0xAA, 0x8A, 0x87 },
	0xEDC0, { 0xF0, 0xAA, 0x8B, 0xB2 },
	0xEDC1, { 0xE4, 0xB5, 0x86 },
	0xEDC2, { 0xE4, 0xB5, 0x9C },
	0xEDC3, { 0xE4, 0xB5, 0xB4 },
	0xEDC4, { 0xE4, 0xB5, 0xB2 },
	0xEDC5, { 0xF0, 0xAA, 0x92, 0xAD },
	0xEDC6, { 0xF0, 0xAA, 0x92, 0xB0 },
	0xEDC7, { 0xF0, 0xAA, 0x93, 0xBD },
	0xEDC8, { 0xE9, 0xBC, 0x9F },
	0xEDC9, { 0xF0, 0xAA, 0x96, 0x87 },
	0xEDCA, { 0xF0, 0xAA, 0x99, 0x8A },
	0xEDCB, { 0xE4, 0xB6, 0xA4 },
	0xEDCC, { 0xE4, 0xB6, 0xA3 },
	0xEDCD, { 0xF0, 0xAA, 0x99, 0x8E },
	0xEDCE, { 0xF0, 0xAA, 0x99, 0x89 },
	0xEDCF, { 0xF0, 0xAA, 0x99, 0x91 },
	0xEDD0, { 0xF0, 0xAA, 0x99, 0x8D },
	0xEDD1, { 0xE4, 0xB6, 0xB4 },
	0xEDD2, { 0xF0, 0xA0, 0x91, 0xB2 },
	0xEDD3, { 0xE3, 0x94, 0xB6 },
	0xEDD4, { 0xF0, 0xA1, 0xAC, 0x96 },
	0xEDD5, { 0xF0, 0xA3, 0xA1, 0xAD },
	0xEDD6, { 0xF0, 0xA3, 0xA5, 0x81 },
	0xEDD7, { 0xE3, 0xB2, 0xB2 },
	0xEDD8, { 0xF0, 0xA4, 0x85, 0xB1 },
	0xEDD9, { 0xF0, 0xA4, 0x85, 0xB4 },
	0xEDDA, { 0xE3, 0xBC, 0x96 },
	0xEDDB, { 0xE7, 0xB1, 0xB0 },
	0xEDDC, { 0xE4, 0x89, 0xB7 },
	0xEDDD, { 0xF0, 0xA5, 0xBD, 0xBC },
	0xEDDE, { 0xE4, 0x95, 0xBF },
	0xEDDF, { 0xF0, 0xA7, 0x86, 0x8A },
	0xEDE0, { 0xF0, 0xA7, 0xA5, 0x96 },
	0xEDE1, { 0xE4, 0xA1, 0xBD },
	0xEDE2, { 0xE9, 0x91, 0xB9 },
	0xEDE3, { 0xF0, 0xA8, 0xAF, 0xBA },
	0xEDE4, { 0xE9, 0x9D, 0x8A },
	0xEDE5, { 0xE4, 0xAA, 0x8C },
	0xEDE6, { 0xF0, 0xA9, 0x99, 0x9B },
	0xEDE7, { 0xE4, 0xAD, 0xA8 },
	0xEDE8, { 0xE4, 0xAE, 0xBE },
	0xEDE9, { 0xE4, 0xB0, 0x95 },
	0xEDEA, { 0xF0, 0xAA, 0x87, 0xB5 },
	0xEDEB, { 0xF0, 0xAA, 0x87, 0xB0 },
	0xEDEC, { 0xF0, 0xAA, 0x8B, 0xB3 },
	0xEDED, { 0xF0, 0xAA, 0x8D, 0xBF },
	0xEDEE, { 0xF0, 0xAA, 0x90, 0x93 },
	0xEDEF, { 0xE4, 0xB5, 0xB5 },
	0xEDF0, { 0xE4, 0xB6, 0xA5 },
	0xEDF1, { 0xF0, 0xA1, 0xAC, 0x99 },
	0xEDF2, { 0xF0, 0xA2, 0xA6, 0x85 },
	0xEDF3, { 0xF0, 0xA2, 0xBA, 0xB0 },
	0xEDF4, { 0xF0, 0xA4, 0x85, 0xB7 },
	0xEDF5, { 0xF0, 0xA5, 0x97, 0xBF },
	0xEDF6, { 0xE4, 0x89, 0xB8 },
	0xEDF7, { 0xE4, 0x8C, 0xB5 },
	0xEDF8, { 0xE7, 0xBA, 0x9D },
	0xEDF9, { 0xE4, 0x96, 0x82 },
	0xEDFA, { 0xF0, 0xA7, 0x86, 0x87 },
	0xEDFB, { 0xE4, 0x96, 0x83 },
	0xEDFC, { 0xF0, 0xA7, 0x86, 0x8B },
	0xEDFD, { 0xE4, 0x99, 0xB1 },
	0xEDFE, { 0xF0, 0xA7, 0xAE, 0x9E },
	0xEEA1, { 0xE4, 0xA1, 0xBE },
	0xEEA2, { 0xE4, 0xAA, 0x8E },
	0xEEA3, { 0xF0, 0xA9, 0x96, 0x8F },
	0xEEA4, { 0xE9, 0xA5, 0xA0 },
	0xEEA5, { 0xE4, 0xAD, 0xA9 },
	0xEEA6, { 0xF0, 0xA9, 0xA0, 0xB9 },
	0xEEA7, { 0xF0, 0xA9, 0xA7, 0x94 },
	0xEEA8, { 0xF0, 0xA9, 0xAB, 0xB1 },
	0xEEA9, { 0xF0, 0xA9, 0xB0, 0x82 },
	0xEEAA, { 0xF0, 0xA9, 0xB1, 0xAB },
	0xEEAB, { 0xF0, 0xA9, 0xB5, 0x80 },
	0xEEAC, { 0xE4, 0xB2, 0x9A },
	0xEEAD, { 0xE4, 0xB2, 0x9B },
	0xEEAE, { 0xF0, 0xAA, 0x88, 0x90 },
	0xEEAF, { 0xF0, 0xAA, 0x92, 0xBE },
	0xEEB0, { 0xF0, 0xAA, 0x92, 0xB9 },
	0xEEB1, { 0xE4, 0xB6, 0x90 },
	0xEEB2, { 0xF0, 0xAA, 0x99, 0xA4 },
	0xEEB3, { 0xE9, 0xBE, 0x9E },
	0xEEB4, { 0xF0, 0xA4, 0xAB, 0xA9 },
	0xEEB5, { 0xF0, 0xA7, 0x86, 0x90 },
	0xEEB6, { 0xE4, 0x96, 0x86 },
	0xEEB7, { 0xE4, 0x96, 0x85 },
	0xEEB8, { 0xF0, 0xA7, 0x88, 0x9C },
	0xEEB9, { 0xE4, 0x98, 0x8E },
	0xEEBA, { 0xF0, 0xA7, 0x96, 0x92 },
	0xEEBB, { 0xF0, 0xA7, 0xA2, 0xAE },
	0xEEBC, { 0xF0, 0xA7, 0xAE, 0xA3 },
	0xEEBD, { 0xE4, 0xA4, 0x99 },
	0xEEBE, { 0xF0, 0xA9, 0x87, 0x89 },
	0xEEBF, { 0xE4, 0xAF, 0x80 },
	0xEEC0, { 0xF0, 0xA9, 0xA7, 0x98 },
	0xEEC1, { 0xF0, 0xA9, 0xB5, 0x84 },
	0xEEC2, { 0xF0, 0xAA, 0x88, 0xA4 },
	0xEEC3, { 0xE9, 0xBB, 0xB8 },
	0xEEC4, { 0xE9, 0xBC, 0xBA },
	0xEEC5, { 0xE9, 0xBD, 0xBD },
	0xEEC6, { 0xF0, 0xAA, 0x99, 0xB0 },
	0xEEC7, { 0xF0, 0xAA, 0x9B, 0x93 },
	0xEEC8, { 0xE4, 0x80, 0x8D },
	0xEEC9, { 0xE4, 0xB0, 0x96 },
	0xEECA, { 0xF0, 0xAA, 0x93, 0x83 },
	0xEECB, { 0xE4, 0xB6, 0xA9 },
	0xEECC, { 0xE4, 0xB6, 0xAA },
	0xEECD, { 0xE4, 0x82, 0x85 },
	0xEECE, { 0xF0, 0xA5, 0xB8, 0xA1 },
	0xEECF, { 0xF0, 0xA6, 0xAB, 0x8A },
	0xEED0, { 0xF0, 0xA7, 0x96, 0x9C },
	0xEED1, { 0xF0, 0xA9, 0xB1, 0xB3 },
	0xEED2, { 0xF0, 0xAA, 0x8E, 0x86 },
	0xEED3, { 0xF0, 0xAA, 0x97, 0x81 },
	0xEED4, { 0xF0, 0xA9, 0xB0, 0x89 },
	0xEED5, { 0xE9, 0xBE, 0x96 },
	0xEED6, { 0xF0, 0xAA, 0x9B, 0x95 },
	0xEED7, { 0xE4, 0xAF, 0x82 },
	0xEED8, { 0xE4, 0xB0, 0xB1 },
	0xEED9, { 0xE4, 0xB4, 0x91 },
	0xEEDA, { 0xE4, 0xB6, 0xAB },
	0xEEDB, { 0xE4, 0xB2, 0x9C },
	0xEEDC, { 0xF0, 0xA9, 0x87, 0x94 }
};

/* Conversion table from CNS 11643 plane #5 to UTF-8. */
static kiconv_table_array_t kiconv_cns5_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0xA1A1, { 0xF0, 0xA0, 0x83, 0x91 },
	0xA1A2, { 0xF0, 0xA0, 0x83, 0x8B },
	0xA1A3, { 0xF0, 0xA0, 0x83, 0x89 },
	0xA1A4, { 0xF0, 0xA0, 0x84, 0x8C },
	0xA1A5, { 0xF0, 0xA0, 0x80, 0x80 },
	0xA1A6, { 0xF0, 0xA0, 0x82, 0x87 },
	0xA1A7, { 0xF0, 0xA0, 0x84, 0x8D },
	0xA1A8, { 0xF0, 0xA0, 0x84, 0x8F },
	0xA1A9, { 0xF0, 0xAF, 0xA0, 0x9D },
	0xA1AA, { 0xF0, 0xA2, 0x8E, 0x98 },
	0xA1AB, { 0xF0, 0xA0, 0x83, 0x92 },
	0xA1AC, { 0xF0, 0xA0, 0x84, 0x91 },
	0xA1AD, { 0xF0, 0xA0, 0x81, 0xBE },
	0xA1AE, { 0xF0, 0xA0, 0xAB, 0x93 },
	0xA1AF, { 0xF0, 0xA1, 0x95, 0x92 },
	0xA1B0, { 0xF0, 0xA1, 0xB3, 0xBE },
	0xA1B1, { 0xF0, 0xA2, 0x96, 0xA9 },
	0xA1B2, { 0xF0, 0xA3, 0xA5, 0x82 },
	0xA1B3, { 0xF0, 0xA0, 0x80, 0x89 },
	0xA1B4, { 0xF0, 0xA0, 0x83, 0x96 },
	0xA1B5, { 0xF0, 0xA0, 0x93, 0x9D },
	0xA1B6, { 0xF0, 0xA0, 0x93, 0x9C },
	0xA1B7, { 0xF0, 0xA0, 0x94, 0x82 },
	0xA1B8, { 0xF0, 0xA0, 0x95, 0xB3 },
	0xA1B9, { 0xF0, 0xA0, 0x99, 0xB6 },
	0xA1BA, { 0xF0, 0xA0, 0x9A, 0xA7 },
	0xA1BB, { 0xF0, 0xA0, 0x9A, 0xA8 },
	0xA1BC, { 0xF0, 0xA0, 0xA0, 0xB3 },
	0xA1BD, { 0xF0, 0xA0, 0xA3, 0x8C },
	0xA1BE, { 0xF0, 0xA0, 0xA8, 0x8D },
	0xA1BF, { 0xF0, 0xA0, 0xA8, 0xAC },
	0xA1C0, { 0xF0, 0xA0, 0xAC, 0x9B },
	0xA1C1, { 0xE3, 0x95, 0x9A },
	0xA1C2, { 0xF0, 0xA0, 0xAC, 0x9D },
	0xA1C3, { 0xF0, 0xA0, 0xAE, 0x99 },
	0xA1C4, { 0xF0, 0xA1, 0x88, 0xBE },
	0xA1C5, { 0xF0, 0xA1, 0xB4, 0xAD },
	0xA1C6, { 0xF0, 0xA1, 0xB4, 0xAF },
	0xA1C7, { 0xF0, 0xA2, 0x8E, 0x99 },
	0xA1C8, { 0xF0, 0xA3, 0x8E, 0xB3 },
	0xA1C9, { 0xF0, 0xA3, 0xA6, 0xB6 },
	0xA1CA, { 0xF0, 0xA3, 0xAC, 0x9B },
	0xA1CB, { 0xF0, 0xA4, 0x93, 0xAF },
	0xA1CC, { 0xF0, 0xA4, 0xA3, 0xA9 },
	0xA1CD, { 0xF0, 0xA0, 0x80, 0x94 },
	0xA1CE, { 0xF0, 0xA0, 0x82, 0x94 },
	0xA1CF, { 0xF0, 0xA0, 0x83, 0xA1 },
	0xA1D0, { 0xF0, 0xA0, 0x94, 0x86 },
	0xA1D1, { 0xF0, 0xA0, 0x95, 0x8A },
	0xA1D2, { 0xF0, 0xA0, 0x95, 0x84 },
	0xA1D3, { 0xF0, 0xA0, 0x98, 0xB1 },
	0xA1D4, { 0xF0, 0xA0, 0x99, 0xBA },
	0xA1D5, { 0xF0, 0xA0, 0x9A, 0xAD },
	0xA1D6, { 0xF0, 0xA0, 0x9A, 0xAE },
	0xA1D7, { 0xF0, 0xA0, 0x9A, 0xB1 },
	0xA1D8, { 0xF0, 0xA0, 0xA0, 0xB8 },
	0xA1D9, { 0xF0, 0xA0, 0xA0, 0xB7 },
	0xA1DA, { 0xF0, 0xA0, 0xA5, 0xBD },
	0xA1DB, { 0xF0, 0xA0, 0xA5, 0xBE },
	0xA1DC, { 0xF0, 0xA0, 0xA8, 0xAD },
	0xA1DD, { 0xF0, 0xA0, 0xA8, 0xB2 },
	0xA1DE, { 0xF0, 0xA0, 0xAC, 0xA3 },
	0xA1DF, { 0xF0, 0xA0, 0xAC, 0xA6 },
	0xA1E0, { 0xF0, 0xAF, 0xA0, 0xBA },
	0xA1E1, { 0xF0, 0xA0, 0xAE, 0xA0 },
	0xA1E2, { 0xF0, 0xA1, 0x9A, 0xA8 },
	0xA1E3, { 0xF0, 0xA1, 0xA4, 0xBF },
	0xA1E4, { 0xF0, 0xA1, 0xA6, 0xBC },
	0xA1E5, { 0xF0, 0xA1, 0xAF, 0x84 },
	0xA1E6, { 0xF0, 0xA1, 0xB4, 0xBB },
	0xA1E7, { 0xF0, 0xA2, 0x80, 0x99 },
	0xA1E8, { 0xF0, 0xA2, 0x80, 0x98 },
	0xA1E9, { 0xF0, 0xA2, 0x86, 0xB3 },
	0xA1EA, { 0xF0, 0xA2, 0x8E, 0xAA },
	0xA1EB, { 0xF0, 0xA2, 0x92, 0xBE },
	0xA1EC, { 0xF0, 0xA2, 0x96, 0xAC },
	0xA1ED, { 0xF0, 0xA2, 0xA8, 0xA5 },
	0xA1EE, { 0xF0, 0xA2, 0xA9, 0xA6 },
	0xA1EF, { 0xF0, 0xA2, 0xA9, 0xAB },
	0xA1F0, { 0xF0, 0xA3, 0xA5, 0x83 },
	0xA1F1, { 0xF0, 0xA3, 0xA6, 0xB5 },
	0xA1F2, { 0xF0, 0xA3, 0xAB, 0xAC },
	0xA1F3, { 0xF0, 0xA3, 0xB1, 0xB6 },
	0xA1F4, { 0xE3, 0xB2, 0xBC },
	0xA1F5, { 0xF0, 0xA4, 0x98, 0x94 },
	0xA1F6, { 0xF0, 0xA1, 0x97, 0x9C },
	0xA1F7, { 0xF0, 0xA4, 0x9C, 0x9C },
	0xA1F8, { 0xF0, 0xA4, 0x9C, 0x9D },
	0xA1F9, { 0xF0, 0xA6, 0x93, 0x90 },
	0xA1FA, { 0xF0, 0xA6, 0x98, 0x92 },
	0xA1FB, { 0xF0, 0xA6, 0xAB, 0xB3 },
	0xA1FC, { 0xF0, 0xA8, 0x99, 0xA9 },
	0xA1FD, { 0xE4, 0xA6, 0xB9 },
	0xA1FE, { 0xF0, 0xA8, 0xB8, 0x91 },
	0xA2A1, { 0xF0, 0xA8, 0xB8, 0x95 },
	0xA2A2, { 0xF0, 0xA8, 0xB8, 0x90 },
	0xA2A3, { 0xF0, 0xA8, 0xB8, 0x93 },
	0xA2A4, { 0xF0, 0xA0, 0x82, 0xA4 },
	0xA2A5, { 0xF0, 0xA0, 0x82, 0xA5 },
	0xA2A6, { 0xF0, 0xA0, 0x87, 0x90 },
	0xA2A7, { 0xF0, 0xA0, 0x86, 0xBA },
	0xA2A8, { 0xF0, 0xA0, 0x87, 0x8B },
	0xA2A9, { 0xF0, 0xA0, 0x95, 0xBB },
	0xA2AA, { 0xF0, 0xA0, 0x9A, 0x86 },
	0xA2AB, { 0xF0, 0xA0, 0x9A, 0xBB },
	0xA2AC, { 0xF0, 0xA0, 0x9A, 0xBA },
	0xA2AD, { 0xF0, 0xA0, 0x9B, 0x83 },
	0xA2AE, { 0xF0, 0xA0, 0x9A, 0xB9 },
	0xA2AF, { 0xF0, 0xA0, 0x9B, 0x80 },
	0xA2B0, { 0xE3, 0x93, 0x9E },
	0xA2B1, { 0xF0, 0xA0, 0xA0, 0xB9 },
	0xA2B2, { 0xF0, 0xA0, 0xA0, 0xBB },
	0xA2B3, { 0xF0, 0xA0, 0xA1, 0x81 },
	0xA2B4, { 0xF0, 0xA0, 0xA3, 0x91 },
	0xA2B5, { 0xF0, 0xA0, 0xA3, 0x8F },
	0xA2B6, { 0xF0, 0xA0, 0xA3, 0x92 },
	0xA2B7, { 0xF0, 0xA0, 0xA4, 0xAE },
	0xA2B8, { 0xF0, 0xA0, 0xA5, 0xAE },
	0xA2B9, { 0xF0, 0xA0, 0xA6, 0x8C },
	0xA2BA, { 0xF0, 0xA0, 0xA6, 0x88 },
	0xA2BB, { 0xF0, 0xA0, 0xA8, 0xB5 },
	0xA2BC, { 0xE3, 0x95, 0x83 },
	0xA2BD, { 0xF0, 0xA0, 0xA8, 0xBA },
	0xA2BE, { 0xF0, 0xA0, 0xA8, 0xBB },
	0xA2BF, { 0xF0, 0xA0, 0xA8, 0xB8 },
	0xA2C0, { 0xF0, 0xA0, 0xA8, 0xB9 },
	0xA2C1, { 0xF0, 0xA0, 0xAC, 0xAE },
	0xA2C2, { 0xF0, 0xA0, 0xAC, 0xAC },
	0xA2C3, { 0xF0, 0xA0, 0xAF, 0x88 },
	0xA2C4, { 0xF0, 0xA0, 0xAE, 0xB5 },
	0xA2C5, { 0xF0, 0xA0, 0xAE, 0xAD },
	0xA2C6, { 0xF0, 0xA0, 0xAE, 0xB0 },
	0xA2C7, { 0xF0, 0xA0, 0xAE, 0xAB },
	0xA2C8, { 0xF0, 0xA1, 0x86, 0xB3 },
	0xA2C9, { 0xF0, 0xA1, 0x86, 0xA9 },
	0xA2CA, { 0xF0, 0xA1, 0x9A, 0xBB },
	0xA2CB, { 0xF0, 0xA1, 0x9A, 0xB9 },
	0xA2CC, { 0xF0, 0xA1, 0xAD, 0x9A },
	0xA2CD, { 0xF0, 0xA1, 0xAF, 0x8D },
	0xA2CE, { 0xF0, 0xA1, 0xB0, 0xAB },
	0xA2CF, { 0xF0, 0xA1, 0xB4, 0x85 },
	0xA2D0, { 0xE3, 0x9E, 0xAC },
	0xA2D1, { 0xE3, 0x9E, 0xAA },
	0xA2D2, { 0xF0, 0xA1, 0xB5, 0x91 },
	0xA2D3, { 0xF0, 0xA1, 0xB5, 0x8B },
	0xA2D4, { 0xF0, 0xA1, 0xBF, 0xAA },
	0xA2D5, { 0xF0, 0xA1, 0xBF, 0xAD },
	0xA2D6, { 0xF0, 0xA2, 0x80, 0xB6 },
	0xA2D7, { 0xF0, 0xA2, 0x81, 0xA2 },
	0xA2D8, { 0xF0, 0xA2, 0x81, 0x96 },
	0xA2D9, { 0xF0, 0xA2, 0x81, 0x95 },
	0xA2DA, { 0xF0, 0xA2, 0x81, 0xA4 },
	0xA2DB, { 0xF0, 0xA2, 0x81, 0x98 },
	0xA2DC, { 0xE5, 0xB8, 0x87 },
	0xA2DD, { 0xF0, 0xA2, 0x87, 0x9A },
	0xA2DE, { 0xF0, 0xA2, 0x87, 0x98 },
	0xA2DF, { 0xF0, 0xA2, 0x8E, 0xAD },
	0xA2E0, { 0xF0, 0xA2, 0x8E, 0xAB },
	0xA2E1, { 0xF0, 0xA2, 0x93, 0x80 },
	0xA2E2, { 0xF0, 0xA2, 0x93, 0x83 },
	0xA2E3, { 0xF0, 0xA2, 0x96, 0xB3 },
	0xA2E4, { 0xF0, 0xA2, 0x96, 0xB7 },
	0xA2E5, { 0xF0, 0xA2, 0x96, 0xBA },
	0xA2E6, { 0xE5, 0xBF, 0x8B },
	0xA2E7, { 0xE3, 0xA3, 0xBE },
	0xA2E8, { 0xF0, 0xA2, 0x97, 0x87 },
	0xA2E9, { 0xF0, 0xA2, 0x96, 0xB5 },
	0xA2EA, { 0xF0, 0xA2, 0xA6, 0x8E },
	0xA2EB, { 0xF0, 0xA2, 0xA9, 0xB3 },
	0xA2EC, { 0xF0, 0xA2, 0xA9, 0xAC },
	0xA2ED, { 0xF0, 0xA2, 0xA9, 0xB4 },
	0xA2EE, { 0xF0, 0xAF, 0xA2, 0xB4 },
	0xA2EF, { 0xF0, 0xA2, 0xA9, 0xB2 },
	0xA2F0, { 0xF0, 0xA2, 0xA9, 0xB1 },
	0xA2F1, { 0xF0, 0xA2, 0xAA, 0x82 },
	0xA2F2, { 0xF0, 0xA2, 0xA9, 0xB0 },
	0xA2F3, { 0xF0, 0xA3, 0x84, 0xBF },
	0xA2F4, { 0xF0, 0xA3, 0x8E, 0xBA },
	0xA2F5, { 0xF0, 0xA3, 0x8E, 0xB8 },
	0xA2F6, { 0xF0, 0xA3, 0xA6, 0xB7 },
	0xA2F7, { 0xF0, 0xA4, 0x9C, 0xA3 },
	0xA2F8, { 0xF0, 0xA4, 0x9C, 0xA1 },
	0xA2F9, { 0xF0, 0xA4, 0x9C, 0xAB },
	0xA2FA, { 0xF0, 0xA4, 0x9C, 0xA6 },
	0xA2FB, { 0xF0, 0xA4, 0x9C, 0xA2 },
	0xA2FC, { 0xF0, 0xA4, 0xB4, 0xA5 },
	0xA2FD, { 0xF0, 0xA5, 0x83, 0xA4 },
	0xA2FE, { 0xF0, 0xA5, 0x90, 0x95 },
	0xA3A1, { 0xF0, 0xA6, 0x93, 0xA4 },
	0xA3A2, { 0xF0, 0xA6, 0x98, 0xB3 },
	0xA3A3, { 0xF0, 0xA6, 0x98, 0xAA },
	0xA3A4, { 0xF0, 0xA6, 0x98, 0xB2 },
	0xA3A5, { 0xF0, 0xA6, 0x98, 0xA9 },
	0xA3A6, { 0xF0, 0xA6, 0xAB, 0xBB },
	0xA3A7, { 0xF0, 0xA7, 0xA5, 0x9B },
	0xA3A8, { 0xF0, 0xA7, 0xA5, 0x9C },
	0xA3A9, { 0xF0, 0xA7, 0xB0, 0xA8 },
	0xA3AA, { 0xF0, 0xA8, 0x99, 0xAF },
	0xA3AB, { 0xF0, 0xA8, 0x99, 0xAD },
	0xA3AC, { 0xF0, 0xA8, 0x99, 0xAB },
	0xA3AD, { 0xF0, 0xA8, 0x99, 0xAE },
	0xA3AE, { 0xF0, 0xA8, 0xB8, 0x96 },
	0xA3AF, { 0xF0, 0xA0, 0x80, 0xA2 },
	0xA3B0, { 0xF0, 0xA0, 0x84, 0x96 },
	0xA3B1, { 0xF0, 0xA0, 0x85, 0x88 },
	0xA3B2, { 0xF0, 0xA0, 0x87, 0x98 },
	0xA3B3, { 0xF0, 0xA0, 0x88, 0x80 },
	0xA3B4, { 0xE3, 0x91, 0x81 },
	0xA3B5, { 0xF0, 0xA0, 0x92, 0x80 },
	0xA3B6, { 0xF0, 0xA0, 0x93, 0xA4 },
	0xA3B7, { 0xE3, 0x92, 0xB4 },
	0xA3B8, { 0xF0, 0xA0, 0x93, 0xA7 },
	0xA3B9, { 0xF0, 0xA0, 0x94, 0x8C },
	0xA3BA, { 0xF0, 0xA0, 0x95, 0x93 },
	0xA3BB, { 0xF0, 0xA0, 0x96, 0xB7 },
	0xA3BC, { 0xF0, 0xA0, 0xAB, 0xA8 },
	0xA3BD, { 0xF0, 0xA0, 0x9B, 0x91 },
	0xA3BE, { 0xF0, 0xA0, 0x9B, 0xA5 },
	0xA3BF, { 0xF0, 0xA0, 0x9B, 0x98 },
	0xA3C0, { 0xF0, 0xA0, 0x9B, 0x96 },
	0xA3C1, { 0xF0, 0xA0, 0x9B, 0x9A },
	0xA3C2, { 0xF0, 0xA0, 0x9B, 0x99 },
	0xA3C3, { 0xF0, 0xA0, 0x9B, 0x95 },
	0xA3C4, { 0xF0, 0xA0, 0x9B, 0xA6 },
	0xA3C5, { 0xF0, 0xA0, 0x9B, 0x94 },
	0xA3C6, { 0xF0, 0xA0, 0x9B, 0x93 },
	0xA3C7, { 0xF0, 0xA0, 0xA1, 0x84 },
	0xA3C8, { 0xF0, 0xA0, 0xA3, 0x96 },
	0xA3C9, { 0xF0, 0xA0, 0xA3, 0x97 },
	0xA3CA, { 0xF0, 0xA0, 0xA4, 0x93 },
	0xA3CC, { 0xF0, 0xA0, 0xA5, 0xB0 },
	0xA3CD, { 0xF0, 0xA0, 0xA6, 0x92 },
	0xA3CE, { 0xF0, 0xA0, 0xA7, 0x9B },
	0xA3CF, { 0xF0, 0xA0, 0xA7, 0x9A },
	0xA3D0, { 0xF0, 0xA0, 0xA9, 0x81 },
	0xA3D1, { 0xF0, 0xA0, 0xA9, 0x83 },
	0xA3D2, { 0xF0, 0xA0, 0xAC, 0xB3 },
	0xA3D3, { 0xF0, 0xA0, 0xAF, 0xB6 },
	0xA3D4, { 0xF0, 0xA0, 0xAF, 0x94 },
	0xA3D5, { 0xF0, 0xA0, 0xAF, 0x9D },
	0xA3D6, { 0xF0, 0xA0, 0xAF, 0x90 },
	0xA3D7, { 0xF0, 0xA0, 0xB0, 0x84 },
	0xA3D8, { 0xF0, 0xA0, 0xAF, 0x99 },
	0xA3D9, { 0xF0, 0xA0, 0xAF, 0x9B },
	0xA3DA, { 0xF0, 0xA0, 0xB0, 0x85 },
	0xA3DB, { 0xF0, 0xA0, 0xAF, 0x93 },
	0xA3DC, { 0xF0, 0xA0, 0xAF, 0xA1 },
	0xA3DD, { 0xF0, 0xA1, 0x8A, 0x80 },
	0xA3DE, { 0xF0, 0xA1, 0x89, 0xB7 },
	0xA3DF, { 0xF0, 0xA1, 0x8A, 0x81 },
	0xA3E0, { 0xF0, 0xA1, 0x8A, 0x82 },
	0xA3E1, { 0xF0, 0xA1, 0x8A, 0x83 },
	0xA3E2, { 0xF0, 0xAF, 0xA1, 0x9C },
	0xA3E3, { 0xF0, 0xA1, 0x95, 0xA1 },
	0xA3E4, { 0xF0, 0xA1, 0x95, 0xA0 },
	0xA3E5, { 0xF0, 0xA1, 0x9B, 0x98 },
	0xA3E6, { 0xF0, 0xA1, 0x9B, 0x96 },
	0xA3E7, { 0xF0, 0xA1, 0x9B, 0x97 },
	0xA3E8, { 0xF0, 0xA4, 0x98, 0x85 },
	0xA3E9, { 0xF0, 0xA1, 0xA5, 0x8D },
	0xA3EA, { 0xF0, 0xA1, 0xA5, 0x88 },
	0xA3EB, { 0xF0, 0xA1, 0xAF, 0x96 },
	0xA3EC, { 0xF0, 0xA1, 0xAF, 0x8F },
	0xA3ED, { 0xF0, 0xA1, 0xAF, 0x99 },
	0xA3EE, { 0xF0, 0xA1, 0xAF, 0x98 },
	0xA3EF, { 0xF0, 0xA1, 0xB0, 0xBD },
	0xA3F0, { 0xE3, 0x9E, 0xB3 },
	0xA3F1, { 0xF0, 0xA1, 0xB5, 0x94 },
	0xA3F2, { 0xF0, 0xA1, 0xB5, 0x9B },
	0xA3F3, { 0xF0, 0xA1, 0xB5, 0x9C },
	0xA3F4, { 0xE3, 0x9E, 0xB4 },
	0xA3F5, { 0xF0, 0xA1, 0xB5, 0x99 },
	0xA3F6, { 0xF0, 0xA1, 0xB5, 0x98 },
	0xA3F7, { 0xF0, 0xA1, 0xB5, 0x9A },
	0xA3F8, { 0xF0, 0xA1, 0xB5, 0x95 },
	0xA3F9, { 0xF0, 0xA1, 0xB5, 0x96 },
	0xA3FA, { 0xF0, 0xA1, 0xB6, 0x82 },
	0xA3FB, { 0xF0, 0xA1, 0xBF, 0xB0 },
	0xA3FC, { 0xF0, 0xA2, 0x80, 0x9C },
	0xA3FD, { 0xF0, 0xA2, 0x81, 0xAA },
	0xA3FE, { 0xF0, 0xA2, 0x81, 0xA9 },
	0xA4A1, { 0xF0, 0xA2, 0x81, 0xB1 },
	0xA4A2, { 0xF0, 0xA2, 0x81, 0xA7 },
	0xA4A3, { 0xF0, 0xA2, 0x81, 0xAC },
	0xA4A4, { 0xF0, 0xA2, 0x81, 0xAE },
	0xA4A5, { 0xF0, 0xA2, 0x81, 0xB9 },
	0xA4A6, { 0xF0, 0xA2, 0x86, 0x8B },
	0xA4A7, { 0xF0, 0xA2, 0x86, 0xB8 },
	0xA4A8, { 0xF0, 0xA2, 0x87, 0xA7 },
	0xA4A9, { 0xF0, 0xA2, 0x87, 0xA8 },
	0xA4AA, { 0xF0, 0xA2, 0x87, 0xA4 },
	0xA4AB, { 0xF0, 0xA2, 0x87, 0xA6 },
	0xA4AC, { 0xF0, 0xA2, 0x87, 0xA5 },
	0xA4AD, { 0xF0, 0xA2, 0x87, 0xB0 },
	0xA4AE, { 0xF0, 0xA2, 0x8E, 0x83 },
	0xA4AF, { 0xF0, 0xA2, 0x8E, 0xB7 },
	0xA4B0, { 0xF0, 0xA2, 0x8E, 0xBB },
	0xA4B1, { 0xF0, 0xA2, 0x8E, 0xB9 },
	0xA4B2, { 0xF0, 0xA2, 0x8F, 0x85 },
	0xA4B3, { 0xF0, 0xA2, 0x91, 0x93 },
	0xA4B4, { 0xF0, 0xA2, 0x93, 0x84 },
	0xA4B5, { 0xF0, 0xA2, 0x93, 0x86 },
	0xA4B6, { 0xF0, 0xA2, 0x93, 0x8B },
	0xA4B7, { 0xF0, 0xA2, 0x97, 0x88 },
	0xA4B8, { 0xF0, 0xAF, 0xA2, 0x9F },
	0xA4B9, { 0xF0, 0xA2, 0x97, 0x89 },
	0xA4BA, { 0xF0, 0xA2, 0x97, 0x9B },
	0xA4BB, { 0xF0, 0xA2, 0xA6, 0x94 },
	0xA4BC, { 0xF0, 0xA2, 0xAA, 0x95 },
	0xA4BD, { 0xF0, 0xA2, 0xAA, 0x88 },
	0xA4BE, { 0xF0, 0xA2, 0xAA, 0x8D },
	0xA4BF, { 0xF0, 0xA2, 0xBB, 0xAC },
	0xA4C0, { 0xF0, 0xA2, 0xBB, 0xAE },
	0xA4C1, { 0xF0, 0xA2, 0xBB, 0xB1 },
	0xA4C2, { 0xF0, 0xA3, 0x84, 0xAE },
	0xA4C3, { 0xF0, 0xA3, 0x85, 0x89 },
	0xA4C4, { 0xF0, 0xA3, 0x8D, 0x9F },
	0xA4C5, { 0xF0, 0xA3, 0x8F, 0x91 },
	0xA4C6, { 0xF0, 0xA3, 0x8F, 0x8B },
	0xA4C7, { 0xF0, 0xA3, 0xA2, 0x85 },
	0xA4C8, { 0xE3, 0xB0, 0x9D },
	0xA4C9, { 0xF0, 0xA3, 0xA5, 0x8A },
	0xA4CA, { 0xF0, 0xA3, 0xA5, 0x87 },
	0xA4CB, { 0xF0, 0xA3, 0xA5, 0x8B },
	0xA4CC, { 0xF0, 0xA3, 0xA6, 0xBB },
	0xA4CD, { 0xF0, 0xA3, 0xA7, 0x84 },
	0xA4CE, { 0xE3, 0xB1, 0xBC },
	0xA4CF, { 0xF0, 0xA3, 0xAC, 0x82 },
	0xA4D0, { 0xF0, 0xA3, 0xB2, 0x82 },
	0xA4D1, { 0xF0, 0xA3, 0xB2, 0x91 },
	0xA4D2, { 0xF0, 0xA3, 0xB2, 0x8F },
	0xA4D3, { 0xF0, 0xA3, 0xB2, 0x92 },
	0xA4D4, { 0xF0, 0xA4, 0x86, 0x8F },
	0xA4D5, { 0xF0, 0xA4, 0x86, 0x91 },
	0xA4D6, { 0xF0, 0xA4, 0x86, 0xB4 },
	0xA4D7, { 0xF0, 0xA4, 0x86, 0x92 },
	0xA4D8, { 0xF0, 0xA4, 0x93, 0xB4 },
	0xA4D9, { 0xF0, 0xA4, 0x96, 0xAA },
	0xA4DA, { 0xF0, 0xA4, 0x9C, 0xB5 },
	0xA4DB, { 0xF0, 0xA4, 0x9C, 0xB7 },
	0xA4DC, { 0xF0, 0xA4, 0x9C, 0xBD },
	0xA4DD, { 0xF0, 0xA4, 0x9C, 0xBC },
	0xA4DE, { 0xF0, 0xA4, 0x9C, 0xAF },
	0xA4DF, { 0xF0, 0xA4, 0x9C, 0xB0 },
	0xA4E0, { 0xF0, 0xA4, 0xA3, 0xB8 },
	0xA4E1, { 0xF0, 0xA4, 0xA3, 0xAF },
	0xA4E2, { 0xF0, 0xA4, 0xAC, 0xA6 },
	0xA4E3, { 0xE3, 0xBD, 0x95 },
	0xA4E4, { 0xF0, 0xA4, 0xB4, 0xA6 },
	0xA4E5, { 0xF0, 0xA4, 0xB4, 0xA7 },
	0xA4E6, { 0xF0, 0xA4, 0xBD, 0x81 },
	0xA4E7, { 0xF0, 0xA4, 0xBF, 0x86 },
	0xA4E8, { 0xF0, 0xA4, 0xBF, 0x87 },
	0xA4E9, { 0xF0, 0xA5, 0x83, 0xAB },
	0xA4EA, { 0xF0, 0xA5, 0x83, 0xA8 },
	0xA4EB, { 0xF0, 0xA5, 0x83, 0xAA },
	0xA4EC, { 0xF0, 0xA5, 0x90, 0x9A },
	0xA4ED, { 0xF0, 0xA5, 0x90, 0x99 },
	0xA4EE, { 0xE4, 0x84, 0xA6 },
	0xA4EF, { 0xF0, 0xA5, 0xA4, 0xA3 },
	0xA4F0, { 0xF0, 0xA5, 0xA4, 0xA4 },
	0xA4F1, { 0xF0, 0xA5, 0xB8, 0xA5 },
	0xA4F2, { 0xF0, 0xA6, 0x98, 0xB5 },
	0xA4F3, { 0xF0, 0xA6, 0x98, 0xB4 },
	0xA4F4, { 0xF0, 0xA6, 0xA8, 0x87 },
	0xA4F5, { 0xF0, 0xA7, 0x88, 0x9D },
	0xA4F6, { 0xF0, 0xA7, 0x9F, 0xA1 },
	0xA4F7, { 0xF0, 0xA7, 0xAE, 0xAB },
	0xA4F8, { 0xF0, 0xA8, 0x91, 0xA0 },
	0xA4F9, { 0xF0, 0xA8, 0x99, 0xB7 },
	0xA4FA, { 0xF0, 0xA8, 0x99, 0xBD },
	0xA4FB, { 0xE4, 0xA6, 0xBC },
	0xA4FC, { 0xF0, 0xA8, 0xB8, 0x9E },
	0xA4FD, { 0xF0, 0xA8, 0xB8, 0x9A },
	0xA4FE, { 0xF0, 0xA8, 0xB8, 0x9D },
	0xA5A1, { 0xF0, 0xA0, 0x81, 0xAB },
	0xA5A2, { 0xF0, 0xA0, 0x84, 0xAD },
	0xA5A3, { 0xF0, 0xA0, 0x85, 0x8C },
	0xA5A4, { 0xF0, 0xA0, 0x88, 0xAA },
	0xA5A5, { 0xE3, 0x91, 0x8A },
	0xA5A6, { 0xF0, 0xA0, 0x88, 0x95 },
	0xA5A7, { 0xF0, 0xA0, 0x88, 0xAC },
	0xA5A8, { 0xF0, 0xA0, 0x88, 0x86 },
	0xA5A9, { 0xF0, 0xA0, 0x88, 0x88 },
	0xA5AA, { 0xF0, 0xA0, 0x88, 0x8A },
	0xA5AB, { 0xE3, 0x91, 0x8E },
	0xA5AC, { 0xF0, 0xA0, 0x95, 0x96 },
	0xA5AD, { 0xF0, 0xA0, 0x96, 0x84 },
	0xA5AE, { 0xE3, 0x93, 0x89 },
	0xA5AF, { 0xF0, 0xA0, 0x97, 0x86 },
	0xA5B0, { 0xF0, 0xA0, 0x9B, 0xB5 },
	0xA5B1, { 0xF0, 0xA0, 0x9C, 0x89 },
	0xA5B2, { 0xF0, 0xA0, 0x9B, 0xB8 },
	0xA5B3, { 0xF0, 0xA0, 0x9B, 0xA8 },
	0xA5B4, { 0xF0, 0xA0, 0x9B, 0xBB },
	0xA5B5, { 0xF0, 0xA0, 0x9B, 0xA9 },
	0xA5B6, { 0xF0, 0xA0, 0x9B, 0xB6 },
	0xA5B7, { 0xE5, 0x8A, 0xB7 },
	0xA5B8, { 0xE5, 0x8A, 0xB8 },
	0xA5B9, { 0xF0, 0xA0, 0xA1, 0x92 },
	0xA5BA, { 0xE5, 0x8A, 0xB6 },
	0xA5BB, { 0xE5, 0x8A, 0xBA },
	0xA5BC, { 0xF0, 0xA0, 0xA1, 0x94 },
	0xA5BD, { 0xF0, 0xA0, 0xA1, 0x91 },
	0xA5BE, { 0xF0, 0xA0, 0xA4, 0xB9 },
	0xA5BF, { 0xF0, 0xA0, 0xA4, 0xBA },
	0xA5C0, { 0xF0, 0xA0, 0xA6, 0x98 },
	0xA5C1, { 0xF0, 0xA0, 0xA9, 0x8E },
	0xA5C2, { 0xE3, 0x95, 0xBB },
	0xA5C3, { 0xF0, 0xA0, 0xB0, 0xB6 },
	0xA5C4, { 0xF0, 0xA0, 0xB0, 0x8C },
	0xA5C5, { 0xF0, 0xA0, 0xB0, 0x90 },
	0xA5C6, { 0xF0, 0xA0, 0xB0, 0xB2 },
	0xA5C7, { 0xF0, 0xA0, 0xB0, 0x91 },
	0xA5C8, { 0xF0, 0xA0, 0xB0, 0x98 },
	0xA5C9, { 0xF0, 0xA0, 0xB0, 0x9C },
	0xA5CA, { 0xF0, 0xA0, 0xB0, 0x9A },
	0xA5CB, { 0xF0, 0xA0, 0xB0, 0x99 },
	0xA5CC, { 0xF0, 0xA0, 0xB0, 0x8B },
	0xA5CD, { 0xF0, 0xA0, 0xB0, 0x8F },
	0xA5CE, { 0xF0, 0xA0, 0xB0, 0x9D },
	0xA5CF, { 0xF0, 0xA0, 0xB0, 0xA1 },
	0xA5D0, { 0xF0, 0xA0, 0xB0, 0x93 },
	0xA5D1, { 0xF0, 0xA0, 0xB0, 0x9B },
	0xA5D2, { 0xF0, 0xA0, 0xB0, 0x95 },
	0xA5D3, { 0xE3, 0x98, 0xA0 },
	0xA5D4, { 0xF0, 0xA1, 0x87, 0x91 },
	0xA5D5, { 0xF0, 0xA1, 0x87, 0x88 },
	0xA5D6, { 0xF0, 0xA1, 0x8A, 0x8D },
	0xA5D7, { 0xF0, 0xA1, 0x8A, 0xB5 },
	0xA5D8, { 0xE3, 0x9A, 0x89 },
	0xA5D9, { 0xE3, 0x9A, 0x95 },
	0xA5DA, { 0xF0, 0xA1, 0x97, 0xB8 },
	0xA5DB, { 0xF0, 0xA1, 0x9B, 0xA0 },
	0xA5DC, { 0xF0, 0xA1, 0x9B, 0xA1 },
	0xA5DD, { 0xE3, 0x9A, 0xBE },
	0xA5DE, { 0xF0, 0xA1, 0x9B, 0x9E },
	0xA5DF, { 0xF0, 0xA1, 0x9B, 0xBE },
	0xA5E0, { 0xF0, 0xA1, 0x9B, 0x9C },
	0xA5E1, { 0xF0, 0xA1, 0x9C, 0x81 },
	0xA5E2, { 0xF0, 0xA1, 0x9B, 0xBD },
	0xA5E3, { 0xF0, 0xA1, 0x9C, 0x80 },
	0xA5E4, { 0xF0, 0xA1, 0xA7, 0x97 },
	0xA5E5, { 0xF0, 0xA1, 0xA7, 0x96 },
	0xA5E6, { 0xF0, 0xA1, 0xA7, 0x99 },
	0xA5E7, { 0xF0, 0xA1, 0xAD, 0xA5 },
	0xA5E8, { 0xF0, 0xA1, 0xAF, 0x92 },
	0xA5E9, { 0xF0, 0xA1, 0xAF, 0x9C },
	0xA5EA, { 0xF0, 0xA1, 0xAF, 0xA1 },
	0xA5EB, { 0xF0, 0xA1, 0xAF, 0x9E },
	0xA5EC, { 0xF0, 0xA1, 0xB1, 0x82 },
	0xA5ED, { 0xF0, 0xA1, 0xB1, 0x8B },
	0xA5EE, { 0xE3, 0x9F, 0x83 },
	0xA5EF, { 0xF0, 0xA1, 0xB6, 0x8E },
	0xA5F0, { 0xF0, 0xA1, 0xB6, 0x91 },
	0xA5F1, { 0xF0, 0xA1, 0xB6, 0x8B },
	0xA5F2, { 0xF0, 0xA1, 0xB6, 0x90 },
	0xA5F3, { 0xF0, 0xA1, 0xB6, 0x88 },
	0xA5F4, { 0xF0, 0xA1, 0xB6, 0x89 },
	0xA5F5, { 0xF0, 0xA1, 0xB6, 0x84 },
	0xA5F6, { 0xF0, 0xA1, 0xB6, 0xAA },
	0xA5F7, { 0xF0, 0xA2, 0x82, 0x8D },
	0xA5F8, { 0xF0, 0xA2, 0x82, 0x8F },
	0xA5F9, { 0xF0, 0xA2, 0x81, 0xBD },
	0xA5FA, { 0xF0, 0xA2, 0x81, 0xBF },
	0xA5FB, { 0xF0, 0xA2, 0x81, 0xBB },
	0xA5FC, { 0xF0, 0xA2, 0x82, 0x80 },
	0xA5FD, { 0xF0, 0xA2, 0x81, 0xBE },
	0xA5FE, { 0xF0, 0xA2, 0x82, 0x83 },
	0xA6A1, { 0xF0, 0xA2, 0x82, 0x81 },
	0xA6A2, { 0xF0, 0xA2, 0x82, 0x86 },
	0xA6A3, { 0xF0, 0xA2, 0x82, 0x8A },
	0xA6A4, { 0xF0, 0xA2, 0x86, 0xBD },
	0xA6A5, { 0xF0, 0xA2, 0x86, 0xBE },
	0xA6A6, { 0xE3, 0xA1, 0xB7 },
	0xA6A7, { 0xF0, 0xA2, 0x87, 0xB4 },
	0xA6A8, { 0xF0, 0xA2, 0x87, 0xB3 },
	0xA6A9, { 0xF0, 0xA2, 0x88, 0x82 },
	0xA6AA, { 0xF0, 0xA2, 0x87, 0xB6 },
	0xA6AB, { 0xF0, 0xA2, 0x87, 0xB5 },
	0xA6AC, { 0xF0, 0xA2, 0x87, 0xB2 },
	0xA6AD, { 0xF0, 0xA2, 0x88, 0x84 },
	0xA6AE, { 0xF0, 0xA2, 0x8C, 0xBD },
	0xA6AF, { 0xF0, 0xA2, 0x8F, 0x86 },
	0xA6B0, { 0xF0, 0xA2, 0x92, 0x89 },
	0xA6B1, { 0xF0, 0xA2, 0x93, 0x94 },
	0xA6B2, { 0xF0, 0xA2, 0x93, 0x96 },
	0xA6B3, { 0xF0, 0xA2, 0x93, 0x92 },
	0xA6B4, { 0xF0, 0xA2, 0x97, 0xBA },
	0xA6B5, { 0xF0, 0xA2, 0x98, 0x86 },
	0xA6B6, { 0xF0, 0xA2, 0x98, 0x8C },
	0xA6B7, { 0xF0, 0xA2, 0x98, 0x8A },
	0xA6B8, { 0xF0, 0xA2, 0x98, 0x8F },
	0xA6B9, { 0xF0, 0xA2, 0xA8, 0xAF },
	0xA6BA, { 0xE3, 0xA7, 0x94 },
	0xA6BB, { 0xF0, 0xA2, 0xAA, 0xB7 },
	0xA6BC, { 0xF0, 0xA2, 0xAA, 0xBE },
	0xA6BD, { 0xF0, 0xA2, 0xAA, 0xBC },
	0xA6BE, { 0xF0, 0xA2, 0xAB, 0xA2 },
	0xA6BF, { 0xF0, 0xA2, 0xBC, 0x86 },
	0xA6C0, { 0xF0, 0xA2, 0xBB, 0xB7 },
	0xA6C1, { 0xF0, 0xA2, 0xBC, 0x87 },
	0xA6C2, { 0xF0, 0xA2, 0xBB, 0xB6 },
	0xA6C3, { 0xF0, 0xA3, 0xAC, 0xB5 },
	0xA6C4, { 0xF0, 0xA3, 0x85, 0x9F },
	0xA6C5, { 0xF0, 0xA3, 0x85, 0xA5 },
	0xA6C6, { 0xF0, 0xA3, 0x85, 0xA4 },
	0xA6C7, { 0xF0, 0xA3, 0x85, 0xA1 },
	0xA6C8, { 0xF0, 0xA3, 0x85, 0x9A },
	0xA6C9, { 0xF0, 0xA3, 0x85, 0x9D },
	0xA6CA, { 0xF0, 0xAF, 0xA3, 0x97 },
	0xA6CB, { 0xF0, 0xA3, 0x8F, 0x97 },
	0xA6CC, { 0xF0, 0xA3, 0x8F, 0x95 },
	0xA6CD, { 0xF0, 0xA3, 0x8F, 0x9E },
	0xA6CE, { 0xF0, 0xA3, 0x8F, 0xA1 },
	0xA6CF, { 0xF0, 0xA3, 0x8F, 0xA0 },
	0xA6D0, { 0xF0, 0xA3, 0x8F, 0x99 },
	0xA6D1, { 0xE3, 0xAD, 0x8C },
	0xA6D2, { 0xF0, 0xA3, 0x8F, 0x9A },
	0xA6D3, { 0xF0, 0xA3, 0x8F, 0x9F },
	0xA6D4, { 0xF0, 0xA3, 0x8F, 0xB6 },
	0xA6D5, { 0xF0, 0xA3, 0x90, 0x83 },
	0xA6D6, { 0xE3, 0xB0, 0xA0 },
	0xA6D7, { 0xF0, 0xA3, 0xA2, 0x93 },
	0xA6D8, { 0xF0, 0xA3, 0xA2, 0x8B },
	0xA6D9, { 0xF0, 0xA3, 0xA2, 0x91 },
	0xA6DA, { 0xF0, 0xA3, 0xA2, 0x92 },
	0xA6DB, { 0xF0, 0xA3, 0xA2, 0x8A },
	0xA6DC, { 0xF0, 0xA3, 0xA2, 0x89 },
	0xA6DD, { 0xF0, 0xA3, 0xA2, 0x8F },
	0xA6DE, { 0xF0, 0xA3, 0xA5, 0x96 },
	0xA6DF, { 0xF0, 0xA3, 0xA5, 0x99 },
	0xA6E0, { 0xF0, 0xA3, 0xA7, 0x8A },
	0xA6E1, { 0xF0, 0xA3, 0xA7, 0x8C },
	0xA6E2, { 0xE3, 0xB1, 0x9B },
	0xA6E3, { 0xF0, 0xA3, 0xA7, 0x90 },
	0xA6E4, { 0xF0, 0xA3, 0xA7, 0x8D },
	0xA6E5, { 0xF0, 0xA3, 0xA7, 0x96 },
	0xA6E6, { 0xF0, 0xA3, 0xA7, 0x8B },
	0xA6E7, { 0xF0, 0xA3, 0xAA, 0x83 },
	0xA6E8, { 0xF0, 0xA3, 0xAA, 0x82 },
	0xA6E9, { 0xF0, 0xA3, 0xAC, 0x86 },
	0xA6EA, { 0xF0, 0xA3, 0xAC, 0xAA },
	0xA6EB, { 0xF0, 0xA3, 0xAC, 0xAC },
	0xA6EC, { 0xF0, 0xA3, 0xAC, 0xAB },
	0xA6ED, { 0xF0, 0xA3, 0xAC, 0xA9 },
	0xA6EE, { 0xF0, 0xA3, 0xB2, 0xBD },
	0xA6EF, { 0xF0, 0xA3, 0xB2, 0xB3 },
	0xA6F0, { 0xF0, 0xA3, 0xB2, 0xBE },
	0xA6F1, { 0xF0, 0xA3, 0xB3, 0x80 },
	0xA6F2, { 0xF0, 0xA3, 0xB2, 0xB5 },
	0xA6F3, { 0xF0, 0xA3, 0xB2, 0xB6 },
	0xA6F4, { 0xF0, 0xA4, 0x86, 0x9D },
	0xA6F5, { 0xF0, 0xA4, 0x86, 0x9F },
	0xA6F6, { 0xF0, 0xA4, 0x98, 0xA0 },
	0xA6F7, { 0xE3, 0xB8, 0xAD },
	0xA6F8, { 0xF0, 0xA4, 0x98, 0x9E },
	0xA6F9, { 0xF0, 0xA4, 0x98, 0x9C },
	0xA6FA, { 0xF0, 0xA4, 0x98, 0xB2 },
	0xA6FB, { 0xF0, 0xA4, 0x98, 0x9F },
	0xA6FC, { 0xF0, 0xA4, 0x98, 0xAB },
	0xA6FD, { 0xF0, 0xA4, 0x98, 0xA1 },
	0xA6FE, { 0xF0, 0xA4, 0x98, 0xA6 },
	0xA7A1, { 0xF0, 0xA4, 0x98, 0xA4 },
	0xA7A2, { 0xF0, 0xA4, 0x98, 0x9D },
	0xA7A3, { 0xF0, 0xA4, 0x98, 0xA7 },
	0xA7A4, { 0xF0, 0xA4, 0x9D, 0x9B },
	0xA7A5, { 0xF0, 0xA4, 0x9D, 0x99 },
	0xA7A6, { 0xF0, 0xA4, 0x9E, 0x80 },
	0xA7A7, { 0xF0, 0xA4, 0x9D, 0x95 },
	0xA7A8, { 0xF0, 0xA4, 0x9D, 0x90 },
	0xA7A9, { 0xF0, 0xA4, 0x9D, 0x9A },
	0xA7AA, { 0xF0, 0xA4, 0x9D, 0x96 },
	0xA7AB, { 0xF0, 0xA4, 0x9D, 0xA3 },
	0xA7AC, { 0xF0, 0xA4, 0x9D, 0x92 },
	0xA7AD, { 0xF0, 0xA4, 0x9D, 0x98 },
	0xA7AE, { 0xE3, 0xB9, 0xA3 },
	0xA7AF, { 0xF0, 0xA4, 0x9C, 0xB9 },
	0xA7B0, { 0xF0, 0xA4, 0xA3, 0xB9 },
	0xA7B1, { 0xF0, 0xA4, 0xAC, 0xA8 },
	0xA7B2, { 0xE3, 0xBC, 0x98 },
	0xA7B3, { 0xF0, 0xA4, 0xAE, 0xBC },
	0xA7B4, { 0xF0, 0xA4, 0xAF, 0x96 },
	0xA7B5, { 0xF0, 0xA4, 0xB0, 0x85 },
	0xA7B6, { 0xF0, 0xA4, 0xB0, 0xA0 },
	0xA7B7, { 0xE3, 0xBD, 0xB4 },
	0xA7B8, { 0xF0, 0xA4, 0xB4, 0xB3 },
	0xA7B9, { 0xF0, 0xA4, 0xBD, 0x86 },
	0xA7BA, { 0xF0, 0xA4, 0xBD, 0x82 },
	0xA7BB, { 0xF0, 0xA4, 0xBD, 0x83 },
	0xA7BC, { 0xF0, 0xA4, 0xBD, 0x87 },
	0xA7BD, { 0xF0, 0xA4, 0xBF, 0x8B },
	0xA7BE, { 0xF0, 0xA5, 0x81, 0x82 },
	0xA7BF, { 0xF0, 0xA5, 0x81, 0x85 },
	0xA7C0, { 0xF0, 0xA5, 0x83, 0xBD },
	0xA7C1, { 0xF0, 0xA5, 0x83, 0xB4 },
	0xA7C2, { 0xF0, 0xA5, 0x83, 0xB9 },
	0xA7C3, { 0xF0, 0xA5, 0x83, 0xBA },
	0xA7C4, { 0xF0, 0xA5, 0x8D, 0x9E },
	0xA7C5, { 0xF0, 0xA5, 0x90, 0x9D },
	0xA7C6, { 0xE4, 0x84, 0xA8 },
	0xA7C7, { 0xF0, 0xA5, 0x9D, 0x98 },
	0xA7C8, { 0xF0, 0xA5, 0x9D, 0x95 },
	0xA7C9, { 0xF0, 0xA5, 0xA9, 0x97 },
	0xA7CA, { 0xF0, 0xA5, 0xA9, 0x98 },
	0xA7CB, { 0xF0, 0xA5, 0xAB, 0x99 },
	0xA7CC, { 0xF0, 0xA5, 0xAB, 0x9C },
	0xA7CD, { 0xF0, 0xA5, 0xAB, 0x9B },
	0xA7CE, { 0xF0, 0xA5, 0xB8, 0xA7 },
	0xA7CF, { 0xF0, 0xA5, 0xBE, 0x85 },
	0xA7D0, { 0xF0, 0xA5, 0xBE, 0x87 },
	0xA7D1, { 0xF0, 0xA5, 0xBE, 0x8A },
	0xA7D2, { 0xF0, 0xA6, 0x8A, 0x8B },
	0xA7D3, { 0xF0, 0xA6, 0x8D, 0x8F },
	0xA7D4, { 0xF0, 0xA6, 0x94, 0xB0 },
	0xA7D5, { 0xF0, 0xA6, 0x94, 0xAF },
	0xA7D6, { 0xF0, 0xA6, 0x99, 0xA8 },
	0xA7D7, { 0xF0, 0xA6, 0x99, 0x89 },
	0xA7D8, { 0xE4, 0x8F, 0x9A },
	0xA7D9, { 0xF0, 0xA6, 0x99, 0x88 },
	0xA7DA, { 0xF0, 0xA6, 0x98, 0xBF },
	0xA7DB, { 0xF0, 0xA6, 0x99, 0x8B },
	0xA7DC, { 0xF0, 0xA6, 0x99, 0x9C },
	0xA7DD, { 0xF0, 0xA6, 0x99, 0x86 },
	0xA7DE, { 0xF0, 0xA6, 0x99, 0x80 },
	0xA7DF, { 0xF0, 0xA6, 0xA8, 0x8D },
	0xA7E0, { 0xF0, 0xA6, 0xAC, 0x9B },
	0xA7E1, { 0xF0, 0xA6, 0xAC, 0x9D },
	0xA7E2, { 0xF0, 0xA6, 0xAC, 0x97 },
	0xA7E3, { 0xE4, 0x92, 0xA4 },
	0xA7E4, { 0xF0, 0xA6, 0xAC, 0xA2 },
	0xA7E5, { 0xF0, 0xA7, 0x96, 0xA7 },
	0xA7E6, { 0xF0, 0xA7, 0x98, 0x88 },
	0xA7E7, { 0xF0, 0xA7, 0xA0, 0x86 },
	0xA7E8, { 0xF0, 0xA8, 0x91, 0xBD },
	0xA7E9, { 0xE4, 0xA2, 0x8E },
	0xA7EA, { 0xF0, 0xA8, 0x91, 0xA3 },
	0xA7EB, { 0xF0, 0xA8, 0x91, 0xA4 },
	0xA7EC, { 0xF0, 0xA8, 0x91, 0xBF },
	0xA7ED, { 0xF0, 0xA8, 0x91, 0xAB },
	0xA7EE, { 0xF0, 0xA8, 0x91, 0xBC },
	0xA7EF, { 0xF0, 0xA8, 0x91, 0xA8 },
	0xA7F0, { 0xF0, 0xA8, 0x91, 0xA5 },
	0xA7F1, { 0xF0, 0xA8, 0x91, 0xAA },
	0xA7F2, { 0xF0, 0xA8, 0x9A, 0x98 },
	0xA7F3, { 0xF0, 0xA8, 0x9A, 0x99 },
	0xA7F4, { 0xF0, 0xA8, 0x9A, 0xAE },
	0xA7F5, { 0xF0, 0xA8, 0xB8, 0xAB },
	0xA7F6, { 0xF0, 0xA8, 0xB8, 0xAD },
	0xA7F7, { 0xF0, 0xA8, 0xB8, 0xB1 },
	0xA7F8, { 0xF0, 0xA8, 0xB8, 0xAE },
	0xA7F9, { 0xF0, 0xA8, 0xB8, 0xAF },
	0xA7FA, { 0xF0, 0xA0, 0x81, 0xAD },
	0xA7FB, { 0xF0, 0xA0, 0x84, 0xB1 },
	0xA7FC, { 0xF0, 0xA0, 0x88, 0xAD },
	0xA7FD, { 0xF0, 0xA0, 0x88, 0xB9 },
	0xA7FE, { 0xF0, 0xA0, 0x88, 0xB8 },
	0xA8A1, { 0xE3, 0x91, 0x9B },
	0xA8A2, { 0xF0, 0xA0, 0x88, 0xBA },
	0xA8A3, { 0xF0, 0xA0, 0x88, 0xB5 },
	0xA8A4, { 0xF0, 0xA0, 0x89, 0xA2 },
	0xA8A5, { 0xF0, 0xA0, 0x93, 0xAA },
	0xA8A6, { 0xF0, 0xA0, 0x93, 0xAB },
	0xA8A7, { 0xF0, 0xA0, 0x94, 0x95 },
	0xA8A8, { 0xF0, 0xA0, 0x97, 0x8C },
	0xA8A9, { 0xF0, 0xA0, 0x97, 0x88 },
	0xA8AA, { 0xF0, 0xA0, 0x97, 0x8D },
	0xA8AB, { 0xF0, 0xA0, 0x97, 0x9B },
	0xA8AC, { 0xF0, 0xA0, 0x97, 0x8B },
	0xA8AD, { 0xF0, 0xA0, 0x9C, 0x91 },
	0xA8AE, { 0xF0, 0xA0, 0x9C, 0xA6 },
	0xA8AF, { 0xF0, 0xA0, 0xA1, 0xA2 },
	0xA8B0, { 0xF0, 0xA0, 0xA1, 0x9E },
	0xA8B1, { 0xF0, 0xA0, 0xA1, 0xA1 },
	0xA8B2, { 0xF0, 0xA0, 0xA5, 0x81 },
	0xA8B3, { 0xF0, 0xA0, 0xA4, 0xBF },
	0xA8B4, { 0xF0, 0xA0, 0xA5, 0xB5 },
	0xA8B5, { 0xF0, 0xA3, 0xA5, 0xA5 },
	0xA8B6, { 0xF0, 0xA0, 0xAD, 0x89 },
	0xA8B7, { 0xF0, 0xA0, 0xA7, 0xAB },
	0xA8B8, { 0xF0, 0xA0, 0xA8, 0x9A },
	0xA8B9, { 0xF0, 0xA0, 0xA9, 0x97 },
	0xA8BA, { 0xF0, 0xA0, 0xB1, 0xAB },
	0xA8BB, { 0xF0, 0xA0, 0xB2, 0xA9 },
	0xA8BC, { 0xF0, 0xA0, 0xB1, 0x94 },
	0xA8BD, { 0xF0, 0xA0, 0xB1, 0xA2 },
	0xA8BE, { 0xF0, 0xA0, 0xB2, 0xAA },
	0xA8BF, { 0xF0, 0xA0, 0xB1, 0x98 },
	0xA8C0, { 0xF0, 0xA0, 0xB1, 0xB2 },
	0xA8C1, { 0xF0, 0xA0, 0xB1, 0xA3 },
	0xA8C2, { 0xF0, 0xA0, 0xB1, 0xB3 },
	0xA8C3, { 0xF0, 0xA0, 0xB2, 0x8B },
	0xA8C4, { 0xF0, 0xA0, 0xB2, 0x8C },
	0xA8C5, { 0xF0, 0xA0, 0xB1, 0x9C },
	0xA8C6, { 0xF0, 0xA0, 0xB1, 0x91 },
	0xA8C7, { 0xF0, 0xA0, 0xB0, 0x96 },
	0xA8C8, { 0xF0, 0xA0, 0xB1, 0xA0 },
	0xA8C9, { 0xF0, 0xA0, 0xB1, 0xA1 },
	0xA8CA, { 0xF0, 0xA0, 0xB1, 0x9E },
	0xA8CB, { 0xF0, 0xA0, 0xB1, 0x9D },
	0xA8CC, { 0xF0, 0xA0, 0xB1, 0xA4 },
	0xA8CD, { 0xF0, 0xA0, 0xB1, 0x93 },
	0xA8CE, { 0xF0, 0xA0, 0xB1, 0x9F },
	0xA8CF, { 0xF0, 0xA0, 0xB1, 0x9B },
	0xA8D0, { 0xF0, 0xA0, 0xB1, 0xAE },
	0xA8D1, { 0xF0, 0xA0, 0xB1, 0x95 },
	0xA8D2, { 0xF0, 0xA0, 0xB1, 0x92 },
	0xA8D3, { 0xF0, 0xA0, 0xB1, 0xA8 },
	0xA8D4, { 0xF0, 0xA1, 0x87, 0x92 },
	0xA8D5, { 0xF0, 0xA1, 0x87, 0x96 },
	0xA8D6, { 0xF0, 0xA1, 0x87, 0x93 },
	0xA8D7, { 0xF0, 0xA1, 0x8A, 0xB8 },
	0xA8D8, { 0xF0, 0xA1, 0x8A, 0xBB },
	0xA8D9, { 0xF0, 0xA1, 0x8B, 0xAB },
	0xA8DA, { 0xF0, 0xA1, 0x8B, 0xA8 },
	0xA8DB, { 0xF0, 0xA1, 0x8A, 0xB6 },
	0xA8DC, { 0xF0, 0xA1, 0x8B, 0xAA },
	0xA8DD, { 0xF0, 0xA1, 0x8B, 0xA7 },
	0xA8DE, { 0xF0, 0xA1, 0x8B, 0xA9 },
	0xA8DF, { 0xF0, 0xA1, 0x96, 0x91 },
	0xA8E0, { 0xF0, 0xA1, 0x98, 0x90 },
	0xA8E1, { 0xF0, 0xA1, 0x98, 0x8E },
	0xA8E2, { 0xF0, 0xA1, 0x98, 0x8F },
	0xA8E3, { 0xF0, 0xA1, 0x9C, 0x8B },
	0xA8E4, { 0xF0, 0xA1, 0x9C, 0x83 },
	0xA8E5, { 0xF0, 0xA1, 0x9C, 0xAB },
	0xA8E6, { 0xF0, 0xA1, 0x9C, 0x89 },
	0xA8E7, { 0xF0, 0xA1, 0x9C, 0xA8 },
	0xA8E8, { 0xF0, 0xA1, 0x9C, 0xAC },
	0xA8E9, { 0xF0, 0xA1, 0x9C, 0xA5 },
	0xA8EA, { 0xF0, 0xA1, 0x9C, 0xA7 },
	0xA8EB, { 0xF0, 0xA1, 0x9C, 0x8F },
	0xA8EC, { 0xF0, 0xA1, 0xA7, 0xA9 },
	0xA8ED, { 0xF0, 0xA1, 0xA7, 0xAC },
	0xA8EE, { 0xE3, 0x9D, 0x93 },
	0xA8EF, { 0xF0, 0xA1, 0xAC, 0xA7 },
	0xA8F0, { 0xF0, 0xA1, 0xAD, 0xB3 },
	0xA8F1, { 0xF0, 0xA1, 0xAF, 0xA2 },
	0xA8F2, { 0xF0, 0xA1, 0xAF, 0xA6 },
	0xA8F3, { 0xF0, 0xAF, 0xA1, 0xB6 },
	0xA8F4, { 0xF0, 0xA1, 0xB1, 0xA1 },
	0xA8F5, { 0xF0, 0xA1, 0xB1, 0x91 },
	0xA8F6, { 0xF0, 0xA1, 0xB4, 0x92 },
	0xA8F7, { 0xF0, 0xA1, 0xB4, 0x8E },
	0xA8F8, { 0xF0, 0xA1, 0xB6, 0xAD },
	0xA8F9, { 0xF0, 0xA1, 0xB6, 0xAF },
	0xA8FA, { 0xF0, 0xA1, 0xB6, 0xB1 },
	0xA8FB, { 0xF0, 0xA1, 0xB7, 0x93 },
	0xA8FC, { 0xF0, 0xA2, 0x82, 0x94 },
	0xA8FD, { 0xF0, 0xA2, 0x82, 0x92 },
	0xA8FE, { 0xF0, 0xA2, 0x82, 0x90 },
	0xA9A1, { 0xF0, 0xA2, 0x82, 0x9D },
	0xA9A2, { 0xF0, 0xA2, 0x82, 0x93 },
	0xA9A3, { 0xF0, 0xA2, 0x82, 0x95 },
	0xA9A4, { 0xF0, 0xA2, 0x82, 0x98 },
	0xA9A5, { 0xF0, 0xA2, 0x82, 0x97 },
	0xA9A6, { 0xE3, 0xA2, 0x80 },
	0xA9A7, { 0xF0, 0xAF, 0xA2, 0x8A },
	0xA9A8, { 0xF0, 0xA2, 0x88, 0x87 },
	0xA9A9, { 0xF0, 0xA2, 0x88, 0x8B },
	0xA9AA, { 0xF0, 0xA2, 0x88, 0x88 },
	0xA9AB, { 0xF0, 0xA2, 0x8F, 0x99 },
	0xA9AC, { 0xF0, 0xA2, 0x8F, 0x95 },
	0xA9AD, { 0xF0, 0xA2, 0x93, 0x97 },
	0xA9AE, { 0xF0, 0xA2, 0x93, 0x9F },
	0xA9AF, { 0xE3, 0xA3, 0x9D },
	0xA9B0, { 0xF0, 0xA2, 0x93, 0x9E },
	0xA9B1, { 0xF0, 0xA2, 0x93, 0xA3 },
	0xA9B2, { 0xF0, 0xA2, 0x93, 0xA2 },
	0xA9B3, { 0xE3, 0xA3, 0x9E },
	0xA9B4, { 0xF0, 0xA2, 0x99, 0x87 },
	0xA9B5, { 0xE3, 0xA4, 0xA2 },
	0xA9B6, { 0xF0, 0xA2, 0x98, 0xBD },
	0xA9B7, { 0xF0, 0xA2, 0x98, 0xB8 },
	0xA9B8, { 0xF0, 0xA2, 0xA9, 0x84 },
	0xA9B9, { 0xF0, 0xA2, 0xA8, 0xBA },
	0xA9BA, { 0xF0, 0xA2, 0xAA, 0xB8 },
	0xA9BB, { 0xF0, 0xA2, 0xAC, 0xAA },
	0xA9BC, { 0xF0, 0xA2, 0xAC, 0x80 },
	0xA9BD, { 0xF0, 0xA2, 0xAB, 0xB3 },
	0xA9BE, { 0xF0, 0xA2, 0xAB, 0xB2 },
	0xA9BF, { 0xF0, 0xA2, 0xAB, 0xAB },
	0xA9C0, { 0xF0, 0xA2, 0xAB, 0xBA },
	0xA9C1, { 0xF0, 0xA2, 0xAB, 0xAD },
	0xA9C2, { 0xF0, 0xA2, 0xAB, 0xAC },
	0xA9C3, { 0xF0, 0xA2, 0xAB, 0xBF },
	0xA9C4, { 0xF0, 0xA2, 0xAB, 0xBB },
	0xA9C5, { 0xE6, 0x8C, 0x86 },
	0xA9C6, { 0xF0, 0xA2, 0xAD, 0x8E },
	0xA9C7, { 0xF0, 0xA2, 0xAB, 0xAF },
	0xA9C8, { 0xF0, 0xA2, 0xAB, 0xB7 },
	0xA9C9, { 0xF0, 0xA2, 0xBC, 0x90 },
	0xA9CA, { 0xF0, 0xA2, 0xBC, 0x91 },
	0xA9CB, { 0xF0, 0xA2, 0xBC, 0x8C },
	0xA9CC, { 0xF0, 0xA2, 0xBC, 0x8B },
	0xA9CD, { 0xF0, 0xA3, 0x83, 0x9D },
	0xA9CE, { 0xF0, 0xA3, 0x84, 0xB0 },
	0xA9CF, { 0xE3, 0xAB, 0x9B },
	0xA9D0, { 0xF0, 0xA3, 0x85, 0xBA },
	0xA9D1, { 0xF0, 0xA3, 0x85, 0xB7 },
	0xA9D2, { 0xF0, 0xA3, 0x8C, 0xA8 },
	0xA9D3, { 0xF0, 0xA3, 0x8C, 0xA7 },
	0xA9D4, { 0xF0, 0xA3, 0x8D, 0xA5 },
	0xA9D5, { 0xF0, 0xA3, 0x90, 0x8E },
	0xA9D6, { 0xF0, 0xA3, 0x90, 0x8B },
	0xA9D7, { 0xF0, 0xA3, 0x91, 0x81 },
	0xA9D8, { 0xF0, 0xA3, 0x90, 0x93 },
	0xA9D9, { 0xF0, 0xA3, 0x90, 0x8F },
	0xA9DA, { 0xF0, 0xA3, 0x90, 0x92 },
	0xA9DB, { 0xF0, 0xA3, 0x90, 0xB0 },
	0xA9DC, { 0xF0, 0xA3, 0xA2, 0xA0 },
	0xA9DD, { 0xF0, 0xA3, 0xA2, 0xA3 },
	0xA9DE, { 0xF0, 0xA3, 0xA2, 0x9E },
	0xA9DF, { 0xF0, 0xA3, 0xA2, 0x97 },
	0xA9E0, { 0xF0, 0xA3, 0xA2, 0xA1 },
	0xA9E1, { 0xF0, 0xA3, 0xA2, 0x9D },
	0xA9E2, { 0xF0, 0xA3, 0xA2, 0x9B },
	0xA9E3, { 0xF0, 0xA3, 0xA5, 0xA3 },
	0xA9E4, { 0xF0, 0xA3, 0xA7, 0xA3 },
	0xA9E5, { 0xF0, 0xA3, 0xA7, 0xA4 },
	0xA9E6, { 0xF0, 0xA3, 0xA7, 0xA6 },
	0xA9E7, { 0xF0, 0xA3, 0xA7, 0xA7 },
	0xA9E8, { 0xF0, 0xA3, 0xA7, 0x9D },
	0xA9E9, { 0xE6, 0xAE, 0x85 },
	0xA9EA, { 0xF0, 0xA3, 0xA7, 0xAC },
	0xA9EB, { 0xF0, 0xA3, 0xA7, 0xA5 },
	0xA9EC, { 0xF0, 0xA3, 0xA7, 0xB1 },
	0xA9ED, { 0xF0, 0xA3, 0xAC, 0xBB },
	0xA9EE, { 0xF0, 0xA3, 0xAC, 0xB9 },
	0xA9EF, { 0xF0, 0xA3, 0xAC, 0xBA },
	0xA9F0, { 0xF0, 0xA3, 0xAC, 0xBC },
	0xA9F1, { 0xF0, 0xA3, 0xAC, 0xBD },
	0xA9F2, { 0xF0, 0xA3, 0xAD, 0x87 },
	0xA9F3, { 0xF0, 0xA3, 0xAC, 0xBF },
	0xA9F4, { 0xF0, 0xA3, 0xAD, 0x84 },
	0xA9F5, { 0xF0, 0xA3, 0xB1, 0x88 },
	0xA9F6, { 0xF0, 0xA3, 0xB1, 0x89 },
	0xA9F7, { 0xF0, 0xA3, 0xB1, 0xA0 },
	0xA9F8, { 0xF0, 0xA3, 0xB3, 0xA3 },
	0xA9F9, { 0xF0, 0xA3, 0xB3, 0xA9 },
	0xA9FA, { 0xF0, 0xA3, 0xB3, 0xB0 },
	0xA9FB, { 0xE3, 0xB3, 0x9A },
	0xA9FC, { 0xE3, 0xB3, 0x9B },
	0xA9FD, { 0xF0, 0xA3, 0xB3, 0xB2 },
	0xA9FE, { 0xF0, 0xA3, 0xB3, 0xAD },
	0xAAA1, { 0xF0, 0xA3, 0xB3, 0xAC },
	0xAAA2, { 0xF0, 0xA3, 0xB3, 0xA6 },
	0xAAA3, { 0xF0, 0xA3, 0xB4, 0x96 },
	0xAAA4, { 0xE3, 0xB3, 0x97 },
	0xAAA5, { 0xF0, 0xA4, 0x86, 0xBC },
	0xAAA6, { 0xF0, 0xA4, 0x86, 0xBE },
	0xAAA7, { 0xF0, 0xA4, 0x87, 0x80 },
	0xAAA8, { 0xF0, 0xA4, 0x87, 0xA0 },
	0xAAA9, { 0xF0, 0xA4, 0x94, 0x80 },
	0xAAAA, { 0xF0, 0xA4, 0x94, 0x82 },
	0xAAAB, { 0xF0, 0xA4, 0x93, 0xBE },
	0xAAAC, { 0xF0, 0xA4, 0x95, 0x9E },
	0xAAAD, { 0xF0, 0xA4, 0x96, 0xB3 },
	0xAAAE, { 0xF0, 0xA4, 0x96, 0xB7 },
	0xAAAF, { 0xF0, 0xA4, 0x98, 0xBA },
	0xAAB0, { 0xF0, 0xA4, 0x98, 0xB9 },
	0xAAB1, { 0xF0, 0xA4, 0x98, 0xBE },
	0xAAB2, { 0xF0, 0xA4, 0x98, 0xB8 },
	0xAAB3, { 0xF0, 0xA4, 0x98, 0xBD },
	0xAAB4, { 0xF0, 0xA4, 0x99, 0x8F },
	0xAAB5, { 0xF0, 0xA4, 0x9D, 0xAE },
	0xAAB6, { 0xF0, 0xA4, 0x9D, 0x9F },
	0xAAB7, { 0xF0, 0xA4, 0x9E, 0x81 },
	0xAAB8, { 0xF0, 0xA4, 0x9E, 0x82 },
	0xAAB9, { 0xF0, 0xA4, 0x9D, 0xB1 },
	0xAABA, { 0xF0, 0xA4, 0x9D, 0xBB },
	0xAABB, { 0xF0, 0xA4, 0x9D, 0xB9 },
	0xAABC, { 0xF0, 0xA4, 0x9D, 0xB7 },
	0xAABD, { 0xF0, 0xA4, 0x9D, 0xB3 },
	0xAABE, { 0xF0, 0xA4, 0x9D, 0xAF },
	0xAABF, { 0xF0, 0xA4, 0x9E, 0x97 },
	0xAAC0, { 0xF0, 0xA4, 0x9D, 0xBE },
	0xAAC1, { 0xF0, 0xA4, 0xA3, 0xBC },
	0xAAC2, { 0xF0, 0xA4, 0xA4, 0x91 },
	0xAAC3, { 0xF0, 0xA4, 0xA4, 0xB2 },
	0xAAC4, { 0xF0, 0xA4, 0xA4, 0xB1 },
	0xAAC5, { 0xF0, 0xA4, 0xA4, 0x90 },
	0xAAC6, { 0xF0, 0xA4, 0xAB, 0xAC },
	0xAAC7, { 0xF0, 0xA4, 0xAB, 0xAB },
	0xAAC8, { 0xF0, 0xA4, 0xAC, 0xAC },
	0xAAC9, { 0xF0, 0xA4, 0xAC, 0xAD },
	0xAACA, { 0xF0, 0xA4, 0xAF, 0x9A },
	0xAACB, { 0xF0, 0xA4, 0xB0, 0xAE },
	0xAACC, { 0xF0, 0xA4, 0xB0, 0xAC },
	0xAACD, { 0xF0, 0xA4, 0xB0, 0xAA },
	0xAACE, { 0xF0, 0xA4, 0xB0, 0xB3 },
	0xAACF, { 0xF0, 0xA4, 0xB1, 0x8B },
	0xAAD0, { 0xF0, 0xA4, 0xB4, 0x98 },
	0xAAD1, { 0xF0, 0xA4, 0xB5, 0x82 },
	0xAAD2, { 0xF0, 0xA4, 0xB4, 0xBB },
	0xAAD3, { 0xF0, 0xA4, 0xB4, 0xBF },
	0xAAD4, { 0xF0, 0xA4, 0xB5, 0x81 },
	0xAAD5, { 0xF0, 0xA4, 0xB5, 0x83 },
	0xAAD6, { 0xF0, 0xA4, 0xB4, 0xBC },
	0xAAD7, { 0xF0, 0xA4, 0xBD, 0x8C },
	0xAAD8, { 0xF0, 0xA4, 0xBD, 0x8A },
	0xAAD9, { 0xF0, 0xA4, 0xBD, 0x89 },
	0xAADA, { 0xF0, 0xA4, 0xBD, 0x96 },
	0xAADB, { 0xF0, 0xA4, 0xBF, 0x8F },
	0xAADC, { 0xF0, 0xA5, 0x81, 0x87 },
	0xAADD, { 0xF0, 0xA5, 0x81, 0x88 },
	0xAADE, { 0xF0, 0xA5, 0x81, 0x86 },
	0xAADF, { 0xF0, 0xA5, 0x84, 0x9B },
	0xAAE0, { 0xF0, 0xA5, 0x84, 0x91 },
	0xAAE1, { 0xF0, 0xA5, 0x84, 0x94 },
	0xAAE2, { 0xF0, 0xA5, 0x84, 0x9D },
	0xAAE3, { 0xF0, 0xA5, 0x84, 0x97 },
	0xAAE4, { 0xF0, 0xA5, 0x84, 0x9E },
	0xAAE5, { 0xF0, 0xA5, 0x84, 0x8B },
	0xAAE6, { 0xF0, 0xA5, 0x84, 0x9C },
	0xAAE7, { 0xF0, 0xA5, 0x84, 0x92 },
	0xAAE8, { 0xF0, 0xA5, 0x84, 0x96 },
	0xAAE9, { 0xF0, 0xA5, 0x84, 0x8D },
	0xAAEA, { 0xF0, 0xA5, 0x84, 0x95 },
	0xAAEB, { 0xF0, 0xA5, 0x84, 0x93 },
	0xAAEC, { 0xF0, 0xA5, 0x84, 0x98 },
	0xAAED, { 0xE4, 0x80, 0x9A },
	0xAAEE, { 0xF0, 0xA5, 0x8E, 0xAC },
	0xAAEF, { 0xF0, 0xA5, 0x91, 0x84 },
	0xAAF0, { 0xF0, 0xA5, 0x90, 0xAC },
	0xAAF1, { 0xF0, 0xA5, 0x91, 0x85 },
	0xAAF2, { 0xF0, 0xA5, 0x9D, 0xA6 },
	0xAAF3, { 0xF0, 0xA5, 0x9D, 0xAE },
	0xAAF4, { 0xF0, 0xA5, 0x9D, 0xA5 },
	0xAAF5, { 0xF0, 0xA5, 0x9D, 0xA8 },
	0xAAF6, { 0xF0, 0xA5, 0x9E, 0x84 },
	0xAAF7, { 0xF0, 0xA5, 0xA4, 0xB8 },
	0xAAF8, { 0xF0, 0xA5, 0xA4, 0xBB },
	0xAAF9, { 0xF0, 0xA5, 0xA4, 0xBA },
	0xAAFA, { 0xF0, 0xA5, 0xA4, 0xBF },
	0xAAFB, { 0xF0, 0xA5, 0xAB, 0x9F },
	0xAAFC, { 0xF0, 0xA5, 0xAB, 0x9D },
	0xAAFD, { 0xF0, 0xA5, 0xAB, 0x9E },
	0xAAFE, { 0xF0, 0xA5, 0xAB, 0xA2 },
	0xABA1, { 0xE4, 0x87, 0x96 },
	0xABA2, { 0xF0, 0xA5, 0xB8, 0xAC },
	0xABA3, { 0xF0, 0xA5, 0xB8, 0xAF },
	0xABA4, { 0xF0, 0xA5, 0xBE, 0x8F },
	0xABA5, { 0xF0, 0xA5, 0xBE, 0x90 },
	0xABA6, { 0xF0, 0xA5, 0xBE, 0x8C },
	0xABA7, { 0xF0, 0xA5, 0xBE, 0x93 },
	0xABA8, { 0xF0, 0xA6, 0x88, 0xA5 },
	0xABA9, { 0xF0, 0xA6, 0x8A, 0x88 },
	0xABAA, { 0xF0, 0xA6, 0x8A, 0xA7 },
	0xABAB, { 0xF0, 0xA6, 0x8F, 0xB7 },
	0xABAC, { 0xF0, 0xA6, 0x92, 0xBB },
	0xABAD, { 0xF0, 0xA6, 0x94, 0xB8 },
	0xABAE, { 0xF0, 0xA6, 0x94, 0xB9 },
	0xABAF, { 0xF0, 0xA6, 0x94, 0xB7 },
	0xABB0, { 0xF0, 0xA6, 0x98, 0x94 },
	0xABB1, { 0xF0, 0xA6, 0x99, 0xAE },
	0xABB2, { 0xF0, 0xA6, 0x99, 0xBB },
	0xABB3, { 0xE4, 0x8F, 0x9E },
	0xABB4, { 0xF0, 0xA6, 0x99, 0xAC },
	0xABB5, { 0xF0, 0xA6, 0x99, 0xBF },
	0xABB6, { 0xF0, 0xA6, 0x99, 0xB8 },
	0xABB7, { 0xF0, 0xA6, 0x99, 0xBA },
	0xABB8, { 0xF0, 0xA6, 0x99, 0xAF },
	0xABB9, { 0xE4, 0x8F, 0xA5 },
	0xABBA, { 0xF0, 0xA6, 0xA3, 0xBE },
	0xABBB, { 0xF0, 0xA6, 0xAD, 0x88 },
	0xABBC, { 0xF0, 0xA6, 0xAD, 0x8B },
	0xABBD, { 0xF0, 0xA6, 0xAD, 0x81 },
	0xABBE, { 0xF0, 0xA6, 0xAD, 0x89 },
	0xABBF, { 0xF0, 0xA6, 0xAC, 0xBB },
	0xABC0, { 0xF0, 0xA7, 0x88, 0xAD },
	0xABC1, { 0xF0, 0xA7, 0x97, 0xA3 },
	0xABC2, { 0xF0, 0xA7, 0x98, 0x9A },
	0xABC3, { 0xF0, 0xA7, 0x98, 0x8D },
	0xABC4, { 0xF0, 0xA7, 0x98, 0x93 },
	0xABC5, { 0xF0, 0xA7, 0x98, 0x91 },
	0xABC6, { 0xF0, 0xA7, 0x98, 0x9C },
	0xABC7, { 0xE4, 0x99, 0xB2 },
	0xABC8, { 0xF0, 0xA7, 0xA2, 0xB5 },
	0xABC9, { 0xE4, 0x9A, 0xAF },
	0xABCA, { 0xF0, 0xA7, 0xB0, 0xA9 },
	0xABCB, { 0xF0, 0xA7, 0xB2, 0xA1 },
	0xABCC, { 0xF0, 0xA7, 0xB4, 0xA4 },
	0xABCD, { 0xF0, 0xA7, 0xBE, 0xBB },
	0xABCE, { 0xF0, 0xA8, 0x8A, 0xA1 },
	0xABCF, { 0xF0, 0xA8, 0x92, 0x83 },
	0xABD0, { 0xF0, 0xA8, 0x92, 0x8D },
	0xABD1, { 0xF0, 0xA8, 0x92, 0x87 },
	0xABD2, { 0xF0, 0xA8, 0x92, 0x85 },
	0xABD3, { 0xF0, 0xA8, 0x92, 0x8A },
	0xABD4, { 0xF0, 0xA8, 0x92, 0xA3 },
	0xABD5, { 0xF0, 0xA8, 0x92, 0x89 },
	0xABD6, { 0xF0, 0xA8, 0x92, 0x84 },
	0xABD7, { 0xF0, 0xA8, 0x92, 0xA2 },
	0xABD8, { 0xF0, 0xA8, 0x9A, 0xB1 },
	0xABD9, { 0xF0, 0xA8, 0x9A, 0xB0 },
	0xABDA, { 0xF0, 0xA8, 0x9A, 0xAF },
	0xABDB, { 0xF0, 0xA8, 0x9A, 0xB6 },
	0xABDC, { 0xF0, 0xA8, 0x9B, 0x89 },
	0xABDD, { 0xF0, 0xA8, 0x9B, 0x8A },
	0xABDE, { 0xF0, 0xA8, 0x9B, 0x88 },
	0xABDF, { 0xF0, 0xA8, 0x9A, 0xB4 },
	0xABE0, { 0xF0, 0xA8, 0xB1, 0x99 },
	0xABE1, { 0xF0, 0xA8, 0xB3, 0x89 },
	0xABE2, { 0xF0, 0xA8, 0xB9, 0x81 },
	0xABE3, { 0xF0, 0xA8, 0xB9, 0x8C },
	0xABE4, { 0xE4, 0xA7, 0x84 },
	0xABE5, { 0xF0, 0xA8, 0xB9, 0x85 },
	0xABE6, { 0xF0, 0xA8, 0xB9, 0x9A },
	0xABE7, { 0xF0, 0xA0, 0x82, 0xB9 },
	0xABE8, { 0xF0, 0xA0, 0x8A, 0x94 },
	0xABE9, { 0xF0, 0xA0, 0x89, 0xAE },
	0xABEA, { 0xF0, 0xA0, 0x8A, 0xA2 },
	0xABEB, { 0xF0, 0xA0, 0x89, 0xA7 },
	0xABEC, { 0xE3, 0x91, 0xA3 },
	0xABED, { 0xF0, 0xA0, 0x8A, 0xA3 },
	0xABEE, { 0xF0, 0xA0, 0x89, 0xB6 },
	0xABEF, { 0xF0, 0xA0, 0x89, 0xAC },
	0xABF0, { 0xF0, 0xA0, 0x89, 0xA4 },
	0xABF1, { 0xF0, 0xA0, 0x8A, 0xA5 },
	0xABF2, { 0xF0, 0xA0, 0x88, 0xB0 },
	0xABF3, { 0xF0, 0xA0, 0x8A, 0xA6 },
	0xABF4, { 0xF0, 0xA0, 0x89, 0xA9 },
	0xABF5, { 0xF0, 0xA0, 0x8A, 0xA4 },
	0xABF6, { 0xF0, 0xA0, 0x92, 0x90 },
	0xABF7, { 0xF0, 0xA0, 0x95, 0x9F },
	0xABF8, { 0xF0, 0xA0, 0x95, 0xA0 },
	0xABF9, { 0xF0, 0xA0, 0x97, 0x9A },
	0xABFA, { 0xF0, 0xA0, 0x97, 0x98 },
	0xABFB, { 0xF0, 0xA0, 0x97, 0x9D },
	0xABFC, { 0xE3, 0x93, 0xAC },
	0xABFD, { 0xF0, 0xA0, 0x9D, 0x99 },
	0xABFE, { 0xF0, 0xA0, 0x9D, 0x9B },
	0xACA1, { 0xF0, 0xA0, 0x9D, 0x9A },
	0xACA2, { 0xF0, 0xA0, 0x9C, 0xB9 },
	0xACA3, { 0xF0, 0xA0, 0x9C, 0xB4 },
	0xACA4, { 0xF0, 0xA0, 0x9D, 0x84 },
	0xACA5, { 0xF0, 0xA0, 0x9C, 0xB3 },
	0xACA6, { 0xF0, 0xA0, 0x9C, 0xBC },
	0xACA7, { 0xF0, 0xA0, 0x9D, 0x98 },
	0xACA8, { 0xF0, 0xA0, 0x9D, 0xAA },
	0xACA9, { 0xF0, 0xA0, 0xA1, 0xAF },
	0xACAA, { 0xF0, 0xA0, 0xA1, 0xB2 },
	0xACAB, { 0xF0, 0xA0, 0xA1, 0xB0 },
	0xACAC, { 0xF0, 0xA0, 0xA1, 0xB1 },
	0xACAD, { 0xF0, 0xA0, 0xA1, 0xAE },
	0xACAE, { 0xF0, 0xA0, 0xA3, 0xB0 },
	0xACAF, { 0xF0, 0xA0, 0xA3, 0xAB },
	0xACB0, { 0xF0, 0xA0, 0xA5, 0x89 },
	0xACB1, { 0xF0, 0xA0, 0xA5, 0x8C },
	0xACB2, { 0xF0, 0xA0, 0xA7, 0xB5 },
	0xACB3, { 0xF0, 0xA0, 0xA8, 0xA0 },
	0xACB4, { 0xF0, 0xA0, 0xA9, 0xAA },
	0xACB5, { 0xF0, 0xA0, 0xA9, 0xB2 },
	0xACB6, { 0xF0, 0xA0, 0xAD, 0x8B },
	0xACB7, { 0xF0, 0xA0, 0xAD, 0x9D },
	0xACB8, { 0xF0, 0xA0, 0xB1, 0x90 },
	0xACB9, { 0xF0, 0xA0, 0xB3, 0xB9 },
	0xACBA, { 0xF0, 0xA0, 0xB3, 0xBA },
	0xACBB, { 0xF0, 0xA0, 0xB3, 0xBB },
	0xACBC, { 0xF0, 0xA0, 0xB4, 0xA3 },
	0xACBD, { 0xF0, 0xA0, 0xB2, 0xB7 },
	0xACBE, { 0xF0, 0xA0, 0xB4, 0xA2 },
	0xACBF, { 0xF0, 0xA0, 0xB2, 0xB5 },
	0xACC0, { 0xF0, 0xA0, 0xB3, 0x84 },
	0xACC1, { 0xF0, 0xA0, 0xB2, 0xB4 },
	0xACC2, { 0xF0, 0xA0, 0xB3, 0xAF },
	0xACC3, { 0xE3, 0x96, 0x98 },
	0xACC4, { 0xF0, 0xA0, 0xB3, 0x8D },
	0xACC5, { 0xF0, 0xA0, 0xB3, 0xB0 },
	0xACC6, { 0xF0, 0xA0, 0xB2, 0xB8 },
	0xACC7, { 0xF0, 0xA0, 0xB3, 0x8B },
	0xACC8, { 0xF0, 0xA0, 0xB3, 0xB1 },
	0xACC9, { 0xF0, 0xA0, 0xB2, 0xBA },
	0xACCA, { 0xF0, 0xA0, 0xB4, 0x83 },
	0xACCB, { 0xF0, 0xA0, 0xB3, 0xB8 },
	0xACCC, { 0xF0, 0xA0, 0xB2, 0xB6 },
	0xACCD, { 0xF0, 0xA0, 0xB2, 0xBC },
	0xACCE, { 0xF0, 0xA0, 0xB2, 0xB3 },
	0xACCF, { 0xF0, 0xA0, 0xB4, 0xA1 },
	0xACD0, { 0xF0, 0xA0, 0xB3, 0xB7 },
	0xACD1, { 0xF0, 0xA0, 0xB3, 0x82 },
	0xACD2, { 0xF0, 0xA0, 0xB2, 0xBE },
	0xACD3, { 0xF0, 0xA0, 0xB3, 0x89 },
	0xACD4, { 0xF0, 0xA0, 0xB2, 0xBD },
	0xACD5, { 0xF0, 0xA0, 0xB3, 0x8E },
	0xACD6, { 0xF0, 0xA0, 0xB2, 0xB9 },
	0xACD7, { 0xF0, 0xA0, 0xB3, 0x87 },
	0xACD8, { 0xF0, 0xA0, 0xB3, 0x8A },
	0xACD9, { 0xF0, 0xA0, 0xB3, 0x8C },
	0xACDA, { 0xF0, 0xA0, 0xB4, 0xA6 },
	0xACDB, { 0xF0, 0xA1, 0x87, 0xA4 },
	0xACDC, { 0xF0, 0xA1, 0x87, 0xA0 },
	0xACDD, { 0xF0, 0xA1, 0x87, 0xB0 },
	0xACDE, { 0xF0, 0xA1, 0x8B, 0xAC },
	0xACDF, { 0xF0, 0xA1, 0x8C, 0xA4 },
	0xACE0, { 0xF0, 0xA1, 0x8C, 0x98 },
	0xACE1, { 0xF0, 0xA1, 0x8C, 0xAF },
	0xACE2, { 0xF0, 0xA1, 0x8C, 0xA5 },
	0xACE3, { 0xF0, 0xA1, 0x94, 0xA8 },
	0xACE4, { 0xF0, 0xA1, 0x94, 0xA2 },
	0xACE5, { 0xF0, 0xA1, 0x95, 0xAA },
	0xACE6, { 0xF0, 0xA0, 0x85, 0x97 },
	0xACE7, { 0xF0, 0xA1, 0x96, 0x94 },
	0xACE8, { 0xF0, 0xA1, 0x96, 0x92 },
	0xACE9, { 0xF0, 0xA1, 0x96, 0x9C },
	0xACEA, { 0xF0, 0xA1, 0x98, 0xA2 },
	0xACEB, { 0xF0, 0xA1, 0x98, 0xB0 },
	0xACEC, { 0xF0, 0xA1, 0x98, 0x9D },
	0xACED, { 0xF0, 0xA1, 0x98, 0xA3 },
	0xACEE, { 0xF0, 0xA1, 0x9C, 0xB5 },
	0xACEF, { 0xF0, 0xA1, 0x9C, 0xB3 },
	0xACF0, { 0xF0, 0xA1, 0x9C, 0xAF },
	0xACF1, { 0xF0, 0xA1, 0x9D, 0x8D },
	0xACF2, { 0xF0, 0xA1, 0x9C, 0xB1 },
	0xACF3, { 0xF0, 0xA1, 0x9D, 0x9B },
	0xACF4, { 0xF0, 0xA1, 0x9D, 0x9A },
	0xACF5, { 0xF0, 0xA1, 0x9C, 0xB2 },
	0xACF6, { 0xF0, 0xA1, 0x9D, 0x9C },
	0xACF7, { 0xF0, 0xA1, 0x9D, 0x99 },
	0xACF8, { 0xF0, 0xA1, 0x9D, 0x9D },
	0xACF9, { 0xF0, 0xA1, 0xA5, 0xA9 },
	0xACFA, { 0xF0, 0xA1, 0xA5, 0xAD },
	0xACFB, { 0xF0, 0xA2, 0x88, 0xB2 },
	0xACFC, { 0xE3, 0x9D, 0x98 },
	0xACFD, { 0xF0, 0xA1, 0xA8, 0x8A },
	0xACFE, { 0xF0, 0xA1, 0xA8, 0xA0 },
	0xADA1, { 0xF0, 0xA1, 0xA8, 0x9F },
	0xADA2, { 0xF0, 0xA1, 0xA8, 0x8D },
	0xADA3, { 0xF0, 0xA1, 0xAF, 0xA8 },
	0xADA4, { 0xF0, 0xA1, 0xAF, 0xAC },
	0xADA5, { 0xF0, 0xA1, 0xB1, 0xB7 },
	0xADA6, { 0xF0, 0xA1, 0xB1, 0xB0 },
	0xADA7, { 0xF0, 0xA1, 0xB1, 0xB1 },
	0xADA8, { 0xF0, 0xA1, 0xB7, 0xB8 },
	0xADA9, { 0xF0, 0xA1, 0xB7, 0x96 },
	0xADAA, { 0xF0, 0xA1, 0xB7, 0x99 },
	0xADAB, { 0xF0, 0xA1, 0xB7, 0x9E },
	0xADAC, { 0xF0, 0xA1, 0xB7, 0x95 },
	0xADAD, { 0xF0, 0xA1, 0xB7, 0xA1 },
	0xADAE, { 0xE3, 0x9F, 0x93 },
	0xADAF, { 0xF0, 0xA1, 0xB7, 0xA2 },
	0xADB0, { 0xF0, 0xA1, 0xB7, 0x9D },
	0xADB1, { 0xF0, 0xA1, 0xB7, 0xA0 },
	0xADB2, { 0xF0, 0xA1, 0xB8, 0x8E },
	0xADB3, { 0xF0, 0xA1, 0xB8, 0x88 },
	0xADB4, { 0xF0, 0xA1, 0xB7, 0x9C },
	0xADB5, { 0xF0, 0xA1, 0xB8, 0x8A },
	0xADB6, { 0xF0, 0xA1, 0xB8, 0x8C },
	0xADB7, { 0xF0, 0xA2, 0x82, 0xB4 },
	0xADB8, { 0xF0, 0xA2, 0x82, 0xB1 },
	0xADB9, { 0xF0, 0xA2, 0x82, 0xB6 },
	0xADBA, { 0xF0, 0xA2, 0x82, 0xBC },
	0xADBB, { 0xF0, 0xA2, 0x88, 0x9D },
	0xADBC, { 0xF0, 0xA2, 0x88, 0xA4 },
	0xADBD, { 0xF0, 0xA2, 0x88, 0x99 },
	0xADBE, { 0xF0, 0xA2, 0x88, 0x9B },
	0xADBF, { 0xF0, 0xA2, 0x88, 0xA2 },
	0xADC0, { 0xF0, 0xA2, 0x88, 0x9A },
	0xADC1, { 0xF0, 0xA2, 0x88, 0x9C },
	0xADC2, { 0xF0, 0xA2, 0x88, 0xA1 },
	0xADC3, { 0xF0, 0xA2, 0x8F, 0xA6 },
	0xADC4, { 0xF0, 0xA2, 0x8F, 0xA4 },
	0xADC5, { 0xF0, 0xA2, 0x8F, 0xA7 },
	0xADC6, { 0xF0, 0xA2, 0x8F, 0xAA },
	0xADC7, { 0xE3, 0xA3, 0xA2 },
	0xADC8, { 0xF0, 0xAF, 0xA2, 0x9B },
	0xADC9, { 0xF0, 0xA2, 0x93, 0xB0 },
	0xADCA, { 0xF0, 0xA2, 0x93, 0xB5 },
	0xADCB, { 0xF0, 0xA2, 0x93, 0xAF },
	0xADCC, { 0xF0, 0xA2, 0x99, 0x82 },
	0xADCD, { 0xF0, 0xA2, 0x99, 0xAE },
	0xADCE, { 0xF0, 0xA2, 0x98, 0xBC },
	0xADCF, { 0xF0, 0xA2, 0x9A, 0x97 },
	0xADD0, { 0xF0, 0xA2, 0x9A, 0x8C },
	0xADD1, { 0xF0, 0xA2, 0x9A, 0x81 },
	0xADD2, { 0xF0, 0xA2, 0x99, 0xB1 },
	0xADD3, { 0xF0, 0xA2, 0x9B, 0x8E },
	0xADD4, { 0xF0, 0xA2, 0x9A, 0xBA },
	0xADD5, { 0xF0, 0xA2, 0x99, 0xBA },
	0xADD6, { 0xF0, 0xA2, 0x99, 0xBE },
	0xADD7, { 0xE3, 0xA5, 0x94 },
	0xADD8, { 0xF0, 0xA2, 0x99, 0xB2 },
	0xADD9, { 0xF0, 0xA2, 0x9A, 0xBB },
	0xADDA, { 0xE3, 0xA4, 0xAF },
	0xADDB, { 0xF0, 0xA2, 0x99, 0xB3 },
	0xADDC, { 0xF0, 0xA2, 0x9A, 0x82 },
	0xADDD, { 0xE3, 0xA6, 0xB6 },
	0xADDE, { 0xF0, 0xA2, 0xA6, 0xBA },
	0xADDF, { 0xF0, 0xA2, 0xA6, 0xB8 },
	0xADE0, { 0xF0, 0xA2, 0xA9, 0x8B },
	0xADE1, { 0xF0, 0xA2, 0xA9, 0x88 },
	0xADE2, { 0xF0, 0xA2, 0xAC, 0xAB },
	0xADE3, { 0xF0, 0xA2, 0xAB, 0xB4 },
	0xADE4, { 0xF0, 0xA2, 0xAC, 0xAC },
	0xADE5, { 0xF0, 0xA2, 0xAD, 0x82 },
	0xADE6, { 0xF0, 0xA2, 0xAD, 0x88 },
	0xADE7, { 0xF0, 0xA2, 0xAD, 0x84 },
	0xADE8, { 0xF0, 0xA2, 0xAD, 0x85 },
	0xADE9, { 0xF0, 0xA2, 0xAC, 0xBC },
	0xADEA, { 0xF0, 0xA2, 0xAC, 0xB7 },
	0xADEB, { 0xF0, 0xA2, 0xAC, 0xB3 },
	0xADEC, { 0xF0, 0xA2, 0xAD, 0x81 },
	0xADED, { 0xF0, 0xA2, 0xAC, 0xB2 },
	0xADEE, { 0xF0, 0xA2, 0xAE, 0x87 },
	0xADEF, { 0xF0, 0xA2, 0xBC, 0xA7 },
	0xADF0, { 0xF0, 0xA2, 0xBC, 0xA3 },
	0xADF1, { 0xF0, 0xA2, 0xBC, 0xAD },
	0xADF2, { 0xF0, 0xA2, 0xBC, 0x9F },
	0xADF3, { 0xF0, 0xA2, 0xBC, 0xAC },
	0xADF4, { 0xF0, 0xA2, 0xBC, 0xA8 },
	0xADF5, { 0xF0, 0xA3, 0x81, 0xB5 },
	0xADF6, { 0xF0, 0xA3, 0x81, 0xB4 },
	0xADF7, { 0xF0, 0xA3, 0x83, 0xA7 },
	0xADF8, { 0xF0, 0xA3, 0x84, 0xB2 },
	0xADF9, { 0xF0, 0xA3, 0x84, 0xB1 },
	0xADFA, { 0xF0, 0xA3, 0x86, 0x99 },
	0xADFB, { 0xF0, 0xA3, 0x86, 0x96 },
	0xADFC, { 0xF0, 0xA3, 0x86, 0x98 },
	0xADFD, { 0xF0, 0xA3, 0x86, 0x9D },
	0xADFE, { 0xF0, 0xA3, 0x86, 0x92 },
	0xAEA1, { 0xF0, 0xA3, 0x86, 0x94 },
	0xAEA2, { 0xF0, 0xA3, 0x86, 0x95 },
	0xAEA3, { 0xF0, 0xA3, 0x86, 0x97 },
	0xAEA4, { 0xF0, 0xA6, 0x9A, 0xB9 },
	0xAEA5, { 0xE3, 0xAC, 0xB5 },
	0xAEA6, { 0xF0, 0xA3, 0x90, 0x91 },
	0xAEA7, { 0xF0, 0xA3, 0x90, 0xBB },
	0xAEA8, { 0xF0, 0xA3, 0x91, 0xB9 },
	0xAEA9, { 0xF0, 0xA3, 0x91, 0x82 },
	0xAEAA, { 0xF0, 0xA3, 0x91, 0x83 },
	0xAEAB, { 0xE3, 0xAD, 0x9D },
	0xAEAC, { 0xF0, 0xA3, 0x91, 0xB8 },
	0xAEAD, { 0xF0, 0xA3, 0xA2, 0xAC },
	0xAEAE, { 0xE3, 0xB0, 0xA9 },
	0xAEAF, { 0xF0, 0xA3, 0xA2, 0xB1 },
	0xAEB0, { 0xF0, 0xA3, 0xA2, 0xB4 },
	0xAEB1, { 0xF0, 0xA3, 0xA2, 0xB3 },
	0xAEB2, { 0xF0, 0xA3, 0xA2, 0xAF },
	0xAEB3, { 0xF0, 0xA3, 0xA2, 0xAA },
	0xAEB4, { 0xF0, 0xA3, 0xA2, 0xB2 },
	0xAEB5, { 0xF0, 0xA3, 0xA5, 0xA8 },
	0xAEB6, { 0xF0, 0xA3, 0xA7, 0xB2 },
	0xAEB7, { 0xF0, 0xA3, 0xA7, 0xBE },
	0xAEB8, { 0xF0, 0xA3, 0xA7, 0xB8 },
	0xAEB9, { 0xF0, 0xA3, 0xA7, 0xB9 },
	0xAEBA, { 0xF0, 0xA3, 0xA7, 0xBF },
	0xAEBB, { 0xF0, 0xA3, 0xA7, 0xB5 },
	0xAEBC, { 0xF0, 0xA3, 0xA7, 0xB7 },
	0xAEBD, { 0xF0, 0xA3, 0xA7, 0xBD },
	0xAEBE, { 0xF0, 0xA3, 0xA8, 0x80 },
	0xAEBF, { 0xF0, 0xA3, 0xAA, 0x88 },
	0xAEC0, { 0xF0, 0xA3, 0xAD, 0xAE },
	0xAEC1, { 0xF0, 0xA3, 0xAD, 0x9D },
	0xAEC2, { 0xF0, 0xA3, 0xAD, 0xA3 },
	0xAEC3, { 0xF0, 0xA3, 0xAD, 0xA0 },
	0xAEC4, { 0xF0, 0xA3, 0xB1, 0xA1 },
	0xAEC5, { 0xF0, 0xA3, 0xB4, 0xB7 },
	0xAEC6, { 0xF0, 0xA3, 0xB5, 0xB1 },
	0xAEC7, { 0xF0, 0xA3, 0xB4, 0xA3 },
	0xAEC8, { 0xF0, 0xA3, 0xB4, 0xA2 },
	0xAEC9, { 0xF0, 0xA3, 0xB4, 0x9F },
	0xAECA, { 0xF0, 0xA3, 0xB4, 0xA5 },
	0xAECB, { 0xF0, 0xA4, 0x87, 0xBD },
	0xAECC, { 0xF0, 0xA4, 0x88, 0x91 },
	0xAECD, { 0xF0, 0xA4, 0x88, 0xA3 },
	0xAECE, { 0xF0, 0xA4, 0x87, 0xB0 },
	0xAECF, { 0xF0, 0xA4, 0x87, 0xAF },
	0xAED0, { 0xF0, 0xA4, 0x94, 0x8E },
	0xAED1, { 0xF0, 0xA4, 0x94, 0x8C },
	0xAED2, { 0xF0, 0xA4, 0x96, 0xBA },
	0xAED3, { 0xE3, 0xB8, 0x9F },
	0xAED4, { 0xF0, 0xA4, 0x99, 0x92 },
	0xAED5, { 0xF0, 0xA4, 0x99, 0x95 },
	0xAED6, { 0xF0, 0xA4, 0x99, 0x93 },
	0xAED7, { 0xF0, 0xA4, 0x99, 0x94 },
	0xAED8, { 0xF0, 0xA4, 0x99, 0x91 },
	0xAED9, { 0xF0, 0xA4, 0x99, 0x98 },
	0xAEDA, { 0xF0, 0xA4, 0x9E, 0xB0 },
	0xAEDB, { 0xF0, 0xA4, 0x9E, 0x9F },
	0xAEDC, { 0xE3, 0xB9, 0xB2 },
	0xAEDD, { 0xF0, 0xA4, 0x9E, 0xA1 },
	0xAEDE, { 0xF0, 0xA4, 0x9E, 0x9A },
	0xAEDF, { 0xF0, 0xA4, 0x9E, 0xBE },
	0xAEE0, { 0xF0, 0xA4, 0x9E, 0xA0 },
	0xAEE1, { 0xF0, 0xA4, 0xA4, 0xB7 },
	0xAEE2, { 0xE3, 0xBC, 0x8B },
	0xAEE3, { 0xF0, 0xA4, 0xAB, 0xB1 },
	0xAEE4, { 0xF0, 0xA4, 0xAB, 0xB2 },
	0xAEE5, { 0xF0, 0xA4, 0xAC, 0xB4 },
	0xAEE6, { 0xF0, 0xA4, 0xAC, 0xB7 },
	0xAEE7, { 0xF0, 0xA4, 0xAC, 0xB5 },
	0xAEE8, { 0xF0, 0xA2, 0x8E, 0x8C },
	0xAEE9, { 0xF0, 0xA4, 0xAF, 0x9F },
	0xAEEA, { 0xF0, 0xA4, 0xB1, 0x8C },
	0xAEEB, { 0xF0, 0xA4, 0xB1, 0x8E },
	0xAEEC, { 0xF0, 0xA4, 0xB1, 0xA4 },
	0xAEED, { 0xF0, 0xA4, 0xB1, 0xA3 },
	0xAEEE, { 0xF0, 0xA4, 0xB0, 0xB6 },
	0xAEEF, { 0xF0, 0xA4, 0xB5, 0x98 },
	0xAEF0, { 0xF0, 0xA4, 0xB5, 0xA8 },
	0xAEF1, { 0xF0, 0xA4, 0xB5, 0x9B },
	0xAEF2, { 0xF0, 0xA4, 0xB5, 0x9F },
	0xAEF3, { 0xF0, 0xA4, 0xB5, 0x99 },
	0xAEF4, { 0xF0, 0xA4, 0xB5, 0xA5 },
	0xAEF5, { 0xF0, 0xA4, 0xB5, 0xA0 },
	0xAEF6, { 0xF0, 0xA4, 0xB5, 0x9E },
	0xAEF7, { 0xF0, 0xA4, 0xBF, 0x95 },
	0xAEF8, { 0xF0, 0xA4, 0xBF, 0x96 },
	0xAEF9, { 0xF0, 0xA5, 0x81, 0x8E },
	0xAEFA, { 0xF0, 0xA5, 0x81, 0x92 },
	0xAEFB, { 0xF0, 0xA5, 0x84, 0xB5 },
	0xAEFC, { 0xF0, 0xA5, 0x84, 0xB9 },
	0xAEFD, { 0xF0, 0xA5, 0x85, 0x98 },
	0xAEFE, { 0xF0, 0xA5, 0x85, 0x81 },
	0xAFA1, { 0xF0, 0xA5, 0x85, 0x97 },
	0xAFA2, { 0xF0, 0xA5, 0x84, 0xB8 },
	0xAFA3, { 0xF0, 0xA5, 0x84, 0xBD },
	0xAFA4, { 0xF0, 0xA5, 0x84, 0xB2 },
	0xAFA5, { 0xF0, 0xA5, 0x85, 0x84 },
	0xAFA6, { 0xF0, 0xAF, 0xA5, 0x84 },
	0xAFA7, { 0xF0, 0xA5, 0x8D, 0xA3 },
	0xAFA8, { 0xF0, 0xA5, 0x8D, 0xA2 },
	0xAFA9, { 0xF0, 0xA5, 0x8E, 0xB8 },
	0xAFAA, { 0xF0, 0xA5, 0x8E, 0xB0 },
	0xAFAB, { 0xF0, 0xA5, 0x8E, 0xB1 },
	0xAFAC, { 0xF0, 0xA5, 0x91, 0x8D },
	0xAFAD, { 0xF0, 0xA5, 0x91, 0xA3 },
	0xAFAE, { 0xF0, 0xA5, 0x91, 0xB0 },
	0xAFAF, { 0xF0, 0xA5, 0x91, 0x8B },
	0xAFB0, { 0xF0, 0xA5, 0x91, 0x8F },
	0xAFB1, { 0xF0, 0xA5, 0x91, 0x8E },
	0xAFB2, { 0xF0, 0xA5, 0x91, 0x93 },
	0xAFB3, { 0xF0, 0xA5, 0x91, 0x87 },
	0xAFB4, { 0xE4, 0x82, 0xA2 },
	0xAFB5, { 0xF0, 0xA5, 0x91, 0x94 },
	0xAFB6, { 0xF0, 0xA5, 0x91, 0x92 },
	0xAFB7, { 0xF0, 0xA5, 0x91, 0x99 },
	0xAFB8, { 0xF0, 0xA5, 0x91, 0xBE },
	0xAFB9, { 0xF0, 0xA5, 0x98, 0xAB },
	0xAFBA, { 0xF0, 0xA5, 0x98, 0xAE },
	0xAFBB, { 0xF0, 0xA5, 0x9D, 0xBF },
	0xAFBC, { 0xF0, 0xA5, 0x9D, 0xBE },
	0xAFBD, { 0xF0, 0xA5, 0x9E, 0x81 },
	0xAFBE, { 0xF0, 0xA5, 0x9E, 0x83 },
	0xAFBF, { 0xF0, 0xA5, 0xA5, 0x87 },
	0xAFC0, { 0xF0, 0xA5, 0xA5, 0x94 },
	0xAFC1, { 0xF0, 0xA5, 0xA5, 0x8D },
	0xAFC2, { 0xF0, 0xA5, 0xA5, 0x8C },
	0xAFC3, { 0xF0, 0xA5, 0xA5, 0x8B },
	0xAFC4, { 0xF0, 0xA5, 0xA5, 0x97 },
	0xAFC5, { 0xF0, 0xA5, 0xA9, 0xA5 },
	0xAFC6, { 0xF0, 0xA5, 0xA9, 0xA4 },
	0xAFC7, { 0xF0, 0xA5, 0xA9, 0xA1 },
	0xAFC8, { 0xF0, 0xA5, 0xA9, 0xA2 },
	0xAFC9, { 0xF0, 0xA5, 0xAB, 0xB0 },
	0xAFCA, { 0xF0, 0xA5, 0xAB, 0xB3 },
	0xAFCB, { 0xF0, 0xA5, 0xAB, 0xB9 },
	0xAFCC, { 0xF0, 0xA5, 0xAB, 0xB4 },
	0xAFCD, { 0xF0, 0xA5, 0xAB, 0xB5 },
	0xAFCE, { 0xF0, 0xA5, 0xAB, 0xAF },
	0xAFCF, { 0xF0, 0xA5, 0xAB, 0xB8 },
	0xAFD0, { 0xF0, 0xA5, 0xAB, 0xBC },
	0xAFD1, { 0xF0, 0xA5, 0xAB, 0xB7 },
	0xAFD2, { 0xF0, 0xA5, 0xAB, 0xBD },
	0xAFD3, { 0xF0, 0xA5, 0xAC, 0x97 },
	0xAFD4, { 0xF0, 0xA5, 0xB8, 0xB4 },
	0xAFD5, { 0xF0, 0xA5, 0xB8, 0xB6 },
	0xAFD6, { 0xF0, 0xA5, 0xB8, 0xB8 },
	0xAFD7, { 0xF0, 0xA5, 0xBE, 0xAF },
	0xAFD8, { 0xF0, 0xA5, 0xBE, 0xAE },
	0xAFD9, { 0xF0, 0xA5, 0xBE, 0xAC },
	0xAFDA, { 0xF0, 0xA5, 0xBE, 0xA2 },
	0xAFDB, { 0xF0, 0xA6, 0x88, 0xA8 },
	0xAFDC, { 0xF0, 0xA2, 0xBB, 0x82 },
	0xAFDD, { 0xF0, 0xA6, 0x8A, 0x9C },
	0xAFDE, { 0xF0, 0xA6, 0x8A, 0xB3 },
	0xAFDF, { 0xF0, 0xA6, 0x8A, 0x90 },
	0xAFE0, { 0xF0, 0xA6, 0x90, 0x86 },
	0xAFE1, { 0xF0, 0xA6, 0x90, 0x84 },
	0xAFE2, { 0xF0, 0xA6, 0x90, 0x8B },
	0xAFE3, { 0xF0, 0xA6, 0x90, 0x85 },
	0xAFE4, { 0xF0, 0xA6, 0x95, 0x80 },
	0xAFE5, { 0xF0, 0xA6, 0x95, 0x8F },
	0xAFE6, { 0xF0, 0xA6, 0x9A, 0xAB },
	0xAFE7, { 0xF0, 0xA6, 0x9A, 0x9D },
	0xAFE8, { 0xF0, 0xA6, 0x9A, 0xB8 },
	0xAFE9, { 0xF0, 0xA6, 0x9A, 0xB2 },
	0xAFEA, { 0xF0, 0xA6, 0x9B, 0x92 },
	0xAFEB, { 0xF0, 0xA6, 0x9B, 0x8F },
	0xAFEC, { 0xF0, 0xA6, 0x9A, 0xA2 },
	0xAFED, { 0xE4, 0x8F, 0xAC },
	0xAFEE, { 0xF0, 0xA6, 0x9A, 0xA5 },
	0xAFEF, { 0xF0, 0xA6, 0x9A, 0xA9 },
	0xAFF0, { 0xF0, 0xA6, 0x9A, 0xA7 },
	0xAFF1, { 0xF0, 0xA6, 0x9B, 0x90 },
	0xAFF2, { 0xF0, 0xA6, 0xA4, 0x82 },
	0xAFF3, { 0xF0, 0xA6, 0xA7, 0x8F },
	0xAFF4, { 0xF0, 0xA6, 0xA7, 0x90 },
	0xAFF5, { 0xF0, 0xA6, 0xA8, 0x96 },
	0xAFF6, { 0xF0, 0xA6, 0xA8, 0x99 },
	0xAFF7, { 0xF0, 0xA6, 0xAD, 0xB5 },
	0xAFF8, { 0xF0, 0xA6, 0xAD, 0xB1 },
	0xAFF9, { 0xF0, 0xA6, 0xAE, 0x91 },
	0xAFFA, { 0xF0, 0xA6, 0xAD, 0xB2 },
	0xAFFB, { 0xF0, 0xA6, 0xAE, 0x8E },
	0xAFFC, { 0xF0, 0xA6, 0xAD, 0xAD },
	0xAFFD, { 0xF0, 0xA6, 0xAE, 0x88 },
	0xAFFE, { 0xF0, 0xA6, 0xAD, 0xB3 },
	0xB0A1, { 0xE4, 0x92, 0xBB },
	0xB0A2, { 0xF0, 0xA6, 0xAE, 0x81 },
	0xB0A3, { 0xF0, 0xA6, 0xAD, 0xB6 },
	0xB0A4, { 0xF0, 0xA6, 0xAD, 0xBB },
	0xB0A5, { 0xF0, 0xA6, 0xAD, 0xBF },
	0xB0A6, { 0xF0, 0xA6, 0xAE, 0x90 },
	0xB0A7, { 0xF0, 0xA6, 0xAD, 0xB8 },
	0xB0A8, { 0xF0, 0xA7, 0x89, 0x8B },
	0xB0A9, { 0xF0, 0xA7, 0x89, 0x88 },
	0xB0AA, { 0xF0, 0xA7, 0x89, 0x9B },
	0xB0AB, { 0xF0, 0xA7, 0x89, 0x91 },
	0xB0AC, { 0xF0, 0xA7, 0x88, 0xBD },
	0xB0AD, { 0xF0, 0xA7, 0x89, 0x80 },
	0xB0AE, { 0xF0, 0xA7, 0x89, 0x86 },
	0xB0AF, { 0xF0, 0xA7, 0x89, 0x8D },
	0xB0B0, { 0xF0, 0xA7, 0x88, 0xBB },
	0xB0B1, { 0xF0, 0xA7, 0x89, 0x8A },
	0xB0B2, { 0xF0, 0xA7, 0x89, 0x81 },
	0xB0B3, { 0xF0, 0xA7, 0x88, 0xBE },
	0xB0B4, { 0xF0, 0xA7, 0x89, 0x8E },
	0xB0B5, { 0xF0, 0xA7, 0x96, 0xAC },
	0xB0B6, { 0xF0, 0xA7, 0x97, 0xA6 },
	0xB0B7, { 0xF0, 0xA7, 0x97, 0xA9 },
	0xB0B8, { 0xF0, 0xA7, 0x98, 0xA9 },
	0xB0B9, { 0xE4, 0x98, 0xA1 },
	0xB0BA, { 0xF0, 0xA7, 0x98, 0xB3 },
	0xB0BB, { 0xF0, 0xA7, 0x98, 0xAE },
	0xB0BC, { 0xF0, 0xA7, 0x98, 0x9E },
	0xB0BD, { 0xE4, 0x98, 0x9F },
	0xB0BE, { 0xF0, 0xAF, 0xA7, 0x85 },
	0xB0BF, { 0xF0, 0xA7, 0x98, 0xA2 },
	0xB0C0, { 0xF0, 0xA7, 0x98, 0xA7 },
	0xB0C1, { 0xF0, 0xA7, 0x9F, 0xA7 },
	0xB0C2, { 0xF0, 0xA7, 0xA0, 0x8B },
	0xB0C3, { 0xF0, 0xA7, 0xA5, 0xA6 },
	0xB0C4, { 0xF0, 0xA7, 0xAE, 0xAD },
	0xB0C5, { 0xF0, 0xA7, 0xAE, 0xAE },
	0xB0C6, { 0xE8, 0xB0, 0xB8 },
	0xB0C7, { 0xF0, 0xA7, 0xB0, 0xAB },
	0xB0C8, { 0xF0, 0xA7, 0xB0, 0xAA },
	0xB0C9, { 0xF0, 0xA7, 0xB4, 0xAC },
	0xB0CA, { 0xF0, 0xA7, 0xB4, 0xAD },
	0xB0CB, { 0xE4, 0x9E, 0x91 },
	0xB0CC, { 0xE4, 0x9E, 0x96 },
	0xB0CD, { 0xF0, 0xA7, 0xBA, 0x8F },
	0xB0CE, { 0xF0, 0xA7, 0xBA, 0x93 },
	0xB0CF, { 0xF0, 0xA7, 0xBF, 0x86 },
	0xB0D0, { 0xF0, 0xA7, 0xBF, 0x85 },
	0xB0D1, { 0xF0, 0xA8, 0x88, 0x95 },
	0xB0D2, { 0xF0, 0xA8, 0x88, 0x93 },
	0xB0D3, { 0xF0, 0xA8, 0x8A, 0xB1 },
	0xB0D4, { 0xF0, 0xA8, 0x8A, 0xA9 },
	0xB0D5, { 0xE8, 0xBB, 0x8E },
	0xB0D6, { 0xF0, 0xA8, 0x92, 0xA8 },
	0xB0D7, { 0xF0, 0xA8, 0x92, 0xAB },
	0xB0D8, { 0xF0, 0xA8, 0x92, 0xBE },
	0xB0D9, { 0xF0, 0xA8, 0x92, 0xAC },
	0xB0DA, { 0xF0, 0xA8, 0x92, 0xA9 },
	0xB0DB, { 0xF0, 0xA8, 0x92, 0xA6 },
	0xB0DC, { 0xF0, 0xA8, 0x93, 0x81 },
	0xB0DD, { 0xF0, 0xA8, 0x9B, 0x8C },
	0xB0DE, { 0xF0, 0xA8, 0x9B, 0x91 },
	0xB0DF, { 0xF0, 0xA8, 0x9B, 0x93 },
	0xB0E0, { 0xF0, 0xA8, 0x9B, 0xA4 },
	0xB0E1, { 0xF0, 0xA8, 0x9B, 0x8B },
	0xB0E2, { 0xF0, 0xA8, 0x9B, 0xA1 },
	0xB0E3, { 0xF0, 0xA8, 0x9B, 0x92 },
	0xB0E4, { 0xF0, 0xA8, 0x9B, 0xA3 },
	0xB0E5, { 0xF0, 0xA8, 0x9B, 0x8F },
	0xB0E6, { 0xF0, 0xA8, 0x9B, 0x90 },
	0xB0E7, { 0xF0, 0xA8, 0x9B, 0xA5 },
	0xB0E8, { 0xF0, 0xA8, 0x9C, 0x8E },
	0xB0E9, { 0xF0, 0xA8, 0xB3, 0x8C },
	0xB0EA, { 0xF0, 0xA8, 0xB3, 0x8A },
	0xB0EB, { 0xF0, 0xA8, 0xB3, 0x8B },
	0xB0EC, { 0xF0, 0xA8, 0xB9, 0x9C },
	0xB0ED, { 0xF0, 0xA8, 0xB9, 0xA1 },
	0xB0EE, { 0xF0, 0xA8, 0xB9, 0x9D },
	0xB0EF, { 0xF0, 0xA8, 0xB9, 0x99 },
	0xB0F0, { 0xF0, 0xA9, 0x81, 0xB7 },
	0xB0F1, { 0xF0, 0xA9, 0x9A, 0x84 },
	0xB0F2, { 0xF0, 0xA0, 0x81, 0x81 },
	0xB0F3, { 0xF0, 0xA0, 0x83, 0xBD },
	0xB0F4, { 0xF0, 0xA0, 0x84, 0x9A },
	0xB0F5, { 0xF0, 0xA0, 0x85, 0xA3 },
	0xB0F6, { 0xF0, 0xA0, 0x8A, 0xB6 },
	0xB0F7, { 0xF0, 0xA0, 0x8A, 0xB2 },
	0xB0F8, { 0xF0, 0xA0, 0x8B, 0xA9 },
	0xB0F9, { 0xF0, 0xA0, 0x8B, 0xA7 },
	0xB0FA, { 0xF0, 0xA0, 0x8B, 0x96 },
	0xB0FB, { 0xF0, 0xA0, 0x8C, 0xB0 },
	0xB0FC, { 0xF0, 0xA0, 0x8B, 0xAC },
	0xB0FD, { 0xF0, 0xA0, 0x8B, 0x9D },
	0xB0FE, { 0xF0, 0xA0, 0x8B, 0xA8 },
	0xB1A1, { 0xF0, 0xA0, 0x8A, 0xB0 },
	0xB1A2, { 0xF0, 0xA0, 0x8A, 0xB5 },
	0xB1A3, { 0xF0, 0xA0, 0x8B, 0xA1 },
	0xB1A4, { 0xF0, 0xA0, 0x92, 0x98 },
	0xB1A5, { 0xF0, 0xA0, 0x92, 0x99 },
	0xB1A6, { 0xE3, 0x92, 0xBC },
	0xB1A7, { 0xF0, 0xA0, 0x96, 0x93 },
	0xB1A8, { 0xF0, 0xA0, 0x97, 0xA5 },
	0xB1A9, { 0xE3, 0x93, 0x98 },
	0xB1AA, { 0xF0, 0xA0, 0x9D, 0xA0 },
	0xB1AB, { 0xF0, 0xA0, 0x9D, 0x9E },
	0xB1AC, { 0xE3, 0x93, 0xB4 },
	0xB1AD, { 0xF0, 0xA0, 0xA1, 0xBB },
	0xB1AE, { 0xF0, 0xA0, 0xA3, 0xB1 },
	0xB1AF, { 0xF0, 0xA0, 0xA3, 0xB3 },
	0xB1B0, { 0xF0, 0xA0, 0xA9, 0xBF },
	0xB1B1, { 0xF0, 0xAF, 0xA0, 0xB8 },
	0xB1B2, { 0xF0, 0xA0, 0xAD, 0x97 },
	0xB1B3, { 0xF0, 0xA0, 0xAD, 0x98 },
	0xB1B4, { 0xF0, 0xA0, 0xB4, 0xB9 },
	0xB1B5, { 0xF0, 0xA0, 0xB6, 0xA7 },
	0xB1B6, { 0xF0, 0xA0, 0xB4, 0xB5 },
	0xB1B7, { 0xF0, 0xA0, 0xB5, 0xA0 },
	0xB1B8, { 0xF0, 0xA0, 0xB5, 0x91 },
	0xB1B9, { 0xF0, 0xA0, 0xB5, 0xA2 },
	0xB1BA, { 0xF0, 0xA0, 0xB5, 0x82 },
	0xB1BB, { 0xF0, 0xA0, 0xB4, 0xBC },
	0xB1BC, { 0xF0, 0xA0, 0xB5, 0x83 },
	0xB1BD, { 0xF0, 0xA0, 0xB6, 0xAB },
	0xB1BE, { 0xF0, 0xA0, 0xB6, 0xA9 },
	0xB1BF, { 0xF0, 0xA0, 0xB6, 0xB4 },
	0xB1C0, { 0xF0, 0xA0, 0xB5, 0xB9 },
	0xB1C1, { 0xF0, 0xA0, 0xB5, 0xAA },
	0xB1C2, { 0xF0, 0xA0, 0xB4, 0xBB },
	0xB1C3, { 0xF0, 0xA0, 0xB6, 0xAA },
	0xB1C4, { 0xF0, 0xA0, 0xB4, 0xB3 },
	0xB1C5, { 0xF0, 0xA0, 0xB4, 0xB7 },
	0xB1C6, { 0xF0, 0xA0, 0xB4, 0xA7 },
	0xB1C7, { 0xF0, 0xA0, 0xB6, 0xA8 },
	0xB1C8, { 0xF0, 0xA0, 0xB5, 0xB0 },
	0xB1C9, { 0xF0, 0xA0, 0xB4, 0xAF },
	0xB1CA, { 0xF0, 0xA0, 0xB4, 0xB6 },
	0xB1CB, { 0xF0, 0xA0, 0xB6, 0xB5 },
	0xB1CC, { 0xF0, 0xA0, 0xB4, 0xB0 },
	0xB1CD, { 0xF0, 0xA0, 0xB4, 0xBA },
	0xB1CE, { 0xF0, 0xA0, 0xB4, 0xB8 },
	0xB1CF, { 0xF0, 0xA0, 0xB6, 0xB1 },
	0xB1D0, { 0xF0, 0xA0, 0xB6, 0xAC },
	0xB1D1, { 0xF0, 0xA0, 0xB4, 0xAE },
	0xB1D2, { 0xF0, 0xA0, 0xB5, 0xB5 },
	0xB1D3, { 0xF0, 0xA0, 0xB6, 0xB0 },
	0xB1D4, { 0xF0, 0xA1, 0x87, 0xB7 },
	0xB1D5, { 0xF0, 0xA1, 0x88, 0x80 },
	0xB1D6, { 0xF0, 0xA1, 0x87, 0xB1 },
	0xB1D7, { 0xF0, 0xA1, 0x87, 0xB3 },
	0xB1D8, { 0xF0, 0xA1, 0x8D, 0xA0 },
	0xB1D9, { 0xF0, 0xA1, 0x8D, 0xA1 },
	0xB1DA, { 0xF0, 0xA1, 0x8C, 0xB2 },
	0xB1DB, { 0xF0, 0xA1, 0x8C, 0xAD },
	0xB1DC, { 0xF0, 0xA1, 0x8D, 0x8A },
	0xB1DD, { 0xF0, 0xA1, 0x8C, 0xAA },
	0xB1DE, { 0xF0, 0xA1, 0x95, 0xA7 },
	0xB1DF, { 0xF0, 0xA1, 0x96, 0xA2 },
	0xB1E0, { 0xF0, 0xA1, 0x96, 0xA3 },
	0xB1E1, { 0xF0, 0xA1, 0x96, 0x9E },
	0xB1E2, { 0xF0, 0xA1, 0x96, 0xA4 },
	0xB1E3, { 0xF0, 0xA1, 0x99, 0x84 },
	0xB1E4, { 0xF0, 0xA1, 0x98, 0xB2 },
	0xB1E5, { 0xF0, 0xA1, 0x9E, 0x9B },
	0xB1E6, { 0xF0, 0xA1, 0x9E, 0x98 },
	0xB1E7, { 0xF0, 0xA1, 0x9E, 0x99 },
	0xB1E8, { 0xF0, 0xA1, 0x9E, 0x9A },
	0xB1E9, { 0xF0, 0xA1, 0x9D, 0xA6 },
	0xB1EA, { 0xF0, 0xA1, 0x9D, 0xA2 },
	0xB1EB, { 0xF0, 0xA1, 0x9D, 0xAB },
	0xB1EC, { 0xF0, 0xA4, 0x95, 0xA2 },
	0xB1ED, { 0xF0, 0xA1, 0x9D, 0xA7 },
	0xB1EE, { 0xF0, 0xA1, 0xA8, 0xBB },
	0xB1EF, { 0xF0, 0xA1, 0xA8, 0xA3 },
	0xB1F0, { 0xF0, 0xA1, 0xA8, 0xA9 },
	0xB1F1, { 0xF0, 0xA1, 0xAD, 0xBE },
	0xB1F2, { 0xF0, 0xA1, 0xAF, 0xB3 },
	0xB1F3, { 0xE3, 0x9E, 0x85 },
	0xB1F4, { 0xF0, 0xA1, 0xAF, 0xB5 },
	0xB1F5, { 0xE3, 0x9E, 0x83 },
	0xB1F6, { 0xF0, 0xA1, 0xB2, 0x80 },
	0xB1F7, { 0xF0, 0xA1, 0xB1, 0xBE },
	0xB1F8, { 0xF0, 0xA1, 0xB1, 0xBC },
	0xB1F9, { 0xF0, 0xA1, 0xB1, 0xBF },
	0xB1FA, { 0xF0, 0xA1, 0xB1, 0xBD },
	0xB1FB, { 0xF0, 0xA1, 0xB2, 0x81 },
	0xB1FC, { 0xF0, 0xA1, 0xB8, 0xA5 },
	0xB1FD, { 0xF0, 0xA1, 0xB8, 0xA9 },
	0xB1FE, { 0xF0, 0xA1, 0xB8, 0x97 },
	0xB2A1, { 0xF0, 0xA1, 0xB9, 0xA3 },
	0xB2A2, { 0xF0, 0xA1, 0xB9, 0xA7 },
	0xB2A3, { 0xF0, 0xA1, 0xB9, 0xA5 },
	0xB2A4, { 0xF0, 0xA1, 0xB8, 0xAA },
	0xB2A5, { 0xF0, 0xA1, 0xB9, 0xA8 },
	0xB2A6, { 0xF0, 0xA1, 0xB8, 0xA6 },
	0xB2A7, { 0xF0, 0xA1, 0xB9, 0xA4 },
	0xB2A8, { 0xF0, 0xA1, 0xB8, 0x9B },
	0xB2A9, { 0xF0, 0xA1, 0xB9, 0xA2 },
	0xB2AA, { 0xF0, 0xA1, 0xB9, 0xA9 },
	0xB2AB, { 0xF0, 0xA1, 0xBF, 0xBE },
	0xB2AC, { 0xF0, 0xA2, 0x81, 0x84 },
	0xB2AD, { 0xF0, 0xA2, 0x81, 0x82 },
	0xB2AE, { 0xF0, 0xA2, 0x82, 0xB7 },
	0xB2AF, { 0xF0, 0xA2, 0x83, 0x92 },
	0xB2B0, { 0xF0, 0xA2, 0x83, 0x94 },
	0xB2B1, { 0xF0, 0xA2, 0x83, 0x97 },
	0xB2B2, { 0xF0, 0xA2, 0x83, 0x9C },
	0xB2B3, { 0xF0, 0xA2, 0x83, 0x91 },
	0xB2B4, { 0xF0, 0xA2, 0x83, 0x95 },
	0xB2B5, { 0xF0, 0xA2, 0x83, 0x8D },
	0xB2B6, { 0xF0, 0xA2, 0x83, 0x98 },
	0xB2B7, { 0xF0, 0xA2, 0x86, 0x9A },
	0xB2B8, { 0xF0, 0xA2, 0x89, 0x82 },
	0xB2B9, { 0xF0, 0xA2, 0x88, 0xB5 },
	0xB2BA, { 0xF0, 0xA2, 0x89, 0x98 },
	0xB2BB, { 0xF0, 0xA2, 0x88, 0xB4 },
	0xB2BC, { 0xF0, 0xA2, 0x88, 0xBC },
	0xB2BD, { 0xF0, 0xA2, 0x88, 0xBB },
	0xB2BE, { 0xF0, 0xA2, 0x88, 0xBE },
	0xB2BF, { 0xF0, 0xA2, 0x88, 0xBD },
	0xB2C0, { 0xF0, 0xA2, 0x89, 0x9A },
	0xB2C1, { 0xF0, 0xA2, 0x89, 0x81 },
	0xB2C2, { 0xF0, 0xA2, 0x88, 0xB8 },
	0xB2C3, { 0xF0, 0xA2, 0x89, 0x85 },
	0xB2C4, { 0xF0, 0xA2, 0x88, 0xB3 },
	0xB2C5, { 0xF0, 0xA2, 0x8C, 0xA6 },
	0xB2C6, { 0xE3, 0xA2, 0xBA },
	0xB2C7, { 0xF0, 0xA2, 0x8F, 0xB7 },
	0xB2C8, { 0xF0, 0xA2, 0x8F, 0xAF },
	0xB2C9, { 0xF0, 0xA2, 0x8F, 0xB0 },
	0xB2CA, { 0xF0, 0xA2, 0x8F, 0xAE },
	0xB2CB, { 0xF0, 0xA2, 0x92, 0x9D },
	0xB2CC, { 0xF0, 0xA2, 0x94, 0x86 },
	0xB2CD, { 0xF0, 0xA2, 0x94, 0x91 },
	0xB2CE, { 0xF0, 0xA2, 0x94, 0x88 },
	0xB2CF, { 0xF0, 0xA2, 0x94, 0x82 },
	0xB2D0, { 0xF0, 0xA2, 0x94, 0x8A },
	0xB2D1, { 0xF0, 0xA2, 0x94, 0x87 },
	0xB2D2, { 0xF0, 0xA2, 0x9A, 0x91 },
	0xB2D3, { 0xF0, 0xA2, 0x9A, 0x8E },
	0xB2D4, { 0xF0, 0xA2, 0x9A, 0x85 },
	0xB2D5, { 0xF0, 0xA2, 0x9B, 0xA8 },
	0xB2D6, { 0xF0, 0xA2, 0x9C, 0x97 },
	0xB2D7, { 0xF0, 0xA2, 0x9B, 0x94 },
	0xB2D8, { 0xE3, 0xA5, 0xA9 },
	0xB2D9, { 0xF0, 0xA2, 0x9B, 0x84 },
	0xB2DA, { 0xF0, 0xA2, 0x9B, 0x95 },
	0xB2DB, { 0xE3, 0xA5, 0x85 },
	0xB2DC, { 0xF0, 0xA2, 0x9B, 0x98 },
	0xB2DD, { 0xF0, 0xA2, 0x9A, 0x80 },
	0xB2DE, { 0xF0, 0xA2, 0x9B, 0x9E },
	0xB2DF, { 0xF0, 0xA2, 0x9D, 0x82 },
	0xB2E0, { 0xF0, 0xA2, 0xA7, 0x87 },
	0xB2E1, { 0xF0, 0xA2, 0xA6, 0xBF },
	0xB2E2, { 0xF0, 0xA2, 0xAE, 0x8D },
	0xB2E3, { 0xF0, 0xA2, 0xAE, 0x89 },
	0xB2E4, { 0xF0, 0xA2, 0xAE, 0x90 },
	0xB2E5, { 0xF0, 0xA2, 0xAE, 0x9A },
	0xB2E6, { 0xF0, 0xA2, 0xAF, 0x88 },
	0xB2E7, { 0xF0, 0xA2, 0xAE, 0x92 },
	0xB2E8, { 0xF0, 0xA2, 0xAE, 0xA1 },
	0xB2E9, { 0xF0, 0xA2, 0xAE, 0x84 },
	0xB2EA, { 0xF0, 0xA2, 0xBD, 0x97 },
	0xB2EB, { 0xF0, 0xA2, 0xBD, 0x87 },
	0xB2EC, { 0xF0, 0xA2, 0xBD, 0xB7 },
	0xB2ED, { 0xF0, 0xA2, 0xBC, 0xBA },
	0xB2EE, { 0xF0, 0xA2, 0xBD, 0x90 },
	0xB2EF, { 0xF0, 0xA2, 0xBD, 0x82 },
	0xB2F0, { 0xF0, 0xA2, 0xBD, 0x83 },
	0xB2F1, { 0xF0, 0xA2, 0xBE, 0xA3 },
	0xB2F2, { 0xF0, 0xA3, 0x81, 0xB7 },
	0xB2F3, { 0xF0, 0xA3, 0x86, 0xB2 },
	0xB2F4, { 0xF0, 0xA3, 0x87, 0xA2 },
	0xB2F5, { 0xF0, 0xA3, 0x86, 0xBD },
	0xB2F6, { 0xF0, 0xA3, 0x8D, 0xB4 },
	0xB2F7, { 0xF0, 0xA3, 0x92, 0x82 },
	0xB2F8, { 0xF0, 0xA3, 0x92, 0xB8 },
	0xB2F9, { 0xE3, 0xAD, 0xAC },
	0xB2FA, { 0xF0, 0xA3, 0x92, 0xBA },
	0xB2FB, { 0xF0, 0xA3, 0x92, 0xB9 },
	0xB2FC, { 0xF0, 0xA3, 0x92, 0xBB },
	0xB2FD, { 0xF0, 0xA3, 0x92, 0x87 },
	0xB2FE, { 0xF0, 0xAF, 0xA3, 0xA4 },
	0xB3A1, { 0xF0, 0xA3, 0x92, 0x83 },
	0xB3A2, { 0xF0, 0xA3, 0x92, 0xB7 },
	0xB3A3, { 0xF0, 0xA0, 0x81, 0x83 },
	0xB3A4, { 0xF0, 0xA3, 0xA3, 0x8E },
	0xB3A5, { 0xF0, 0xA3, 0xA2, 0xBA },
	0xB3A6, { 0xF0, 0xA3, 0xA5, 0xB3 },
	0xB3A7, { 0xF0, 0xA3, 0xA8, 0x89 },
	0xB3A8, { 0xF0, 0xA3, 0xA8, 0x8A },
	0xB3A9, { 0xF0, 0xA3, 0xA8, 0x8B },
	0xB3AA, { 0xF0, 0xA3, 0xA8, 0x87 },
	0xB3AB, { 0xF0, 0xA3, 0xA8, 0x85 },
	0xB3AC, { 0xF0, 0xA3, 0xA8, 0x8E },
	0xB3AD, { 0xF0, 0xA3, 0xAA, 0x97 },
	0xB3AE, { 0xF0, 0xA3, 0xAD, 0xB7 },
	0xB3AF, { 0xF0, 0xA3, 0xAD, 0xBB },
	0xB3B0, { 0xF0, 0xA3, 0xAD, 0xBA },
	0xB3B1, { 0xF0, 0xA3, 0xAD, 0xB4 },
	0xB3B2, { 0xF0, 0xA3, 0xAD, 0xB9 },
	0xB3B3, { 0xF0, 0xA3, 0xB6, 0x86 },
	0xB3B4, { 0xF0, 0xA3, 0xB7, 0xB5 },
	0xB3B5, { 0xF0, 0xA3, 0xB6, 0xA5 },
	0xB3B6, { 0xF0, 0xA3, 0xB6, 0x9D },
	0xB3B7, { 0xF0, 0xA3, 0xB6, 0xBE },
	0xB3B8, { 0xF0, 0xA3, 0xB6, 0x96 },
	0xB3B9, { 0xF0, 0xA3, 0xB7, 0xA1 },
	0xB3BA, { 0xF0, 0xA3, 0xB6, 0xA4 },
	0xB3BB, { 0xF0, 0xA3, 0xB6, 0xA1 },
	0xB3BC, { 0xF0, 0xA3, 0xB7, 0xB6 },
	0xB3BD, { 0xE3, 0xB4, 0x84 },
	0xB3BE, { 0xF0, 0xA3, 0xB6, 0x8D },
	0xB3BF, { 0xF0, 0xA3, 0xB6, 0x8B },
	0xB3C0, { 0xF0, 0xA3, 0xB5, 0xB8 },
	0xB3C1, { 0xF0, 0xA3, 0xB6, 0x98 },
	0xB3C2, { 0xF0, 0xA3, 0xB8, 0x8A },
	0xB3C3, { 0xF0, 0xA4, 0x89, 0x9D },
	0xB3C4, { 0xF0, 0xA4, 0x88, 0xA7 },
	0xB3C5, { 0xF0, 0xA4, 0x89, 0x9F },
	0xB3C6, { 0xF0, 0xA4, 0x97, 0x80 },
	0xB3C7, { 0xF0, 0xA4, 0x97, 0x81 },
	0xB3C8, { 0xF0, 0xA4, 0x99, 0xAD },
	0xB3C9, { 0xF0, 0xA4, 0x99, 0x9E },
	0xB3CA, { 0xF0, 0xA4, 0x9A, 0x8A },
	0xB3CB, { 0xF0, 0xA4, 0x99, 0xA2 },
	0xB3CC, { 0xF0, 0xA4, 0x99, 0xA4 },
	0xB3CD, { 0xE3, 0xB8, 0xBA },
	0xB3CE, { 0xF0, 0xA4, 0x9F, 0x80 },
	0xB3CF, { 0xF0, 0xA4, 0x9F, 0x8A },
	0xB3D0, { 0xF0, 0xA4, 0x9F, 0x91 },
	0xB3D1, { 0xE3, 0xB9, 0xB9 },
	0xB3D2, { 0xF0, 0xA4, 0x9F, 0x87 },
	0xB3D3, { 0xF0, 0xA4, 0x9F, 0x8E },
	0xB3D4, { 0xE7, 0x8C, 0x89 },
	0xB3D5, { 0xF0, 0xA4, 0x9F, 0x85 },
	0xB3D6, { 0xF0, 0xA4, 0xA4, 0xB6 },
	0xB3D7, { 0xF0, 0xA4, 0xA5, 0x97 },
	0xB3D8, { 0xF0, 0xA4, 0xA5, 0xB7 },
	0xB3D9, { 0xF0, 0xA4, 0xAB, 0xB6 },
	0xB3DA, { 0xF0, 0xA4, 0xAB, 0xB7 },
	0xB3DB, { 0xF0, 0xA4, 0xAD, 0x95 },
	0xB3DC, { 0xF0, 0xA4, 0xAD, 0x84 },
	0xB3DD, { 0xF0, 0xA4, 0xAC, 0xBE },
	0xB3DE, { 0xF0, 0xA4, 0xAD, 0x82 },
	0xB3DF, { 0xF0, 0xA4, 0xAD, 0x92 },
	0xB3E0, { 0xF0, 0xA4, 0xAF, 0xA1 },
	0xB3E1, { 0xF0, 0xA4, 0xB0, 0x88 },
	0xB3E2, { 0xF0, 0xA4, 0xB1, 0xA8 },
	0xB3E3, { 0xF0, 0xA4, 0xB1, 0xA7 },
	0xB3E4, { 0xE3, 0xBD, 0x9D },
	0xB3E5, { 0xF0, 0xAF, 0xA4, 0xB7 },
	0xB3E6, { 0xF0, 0xA4, 0xB5, 0xBE },
	0xB3E7, { 0xF0, 0xA4, 0xB6, 0x93 },
	0xB3E8, { 0xF0, 0xA4, 0xB5, 0xB9 },
	0xB3E9, { 0xF0, 0xA4, 0xB6, 0x81 },
	0xB3EA, { 0xF0, 0xA4, 0xB5, 0xBD },
	0xB3EB, { 0xF0, 0xA4, 0xB5, 0xBB },
	0xB3EC, { 0xF0, 0xA4, 0xB6, 0x94 },
	0xB3ED, { 0xE3, 0xBE, 0x8A },
	0xB3EE, { 0xF0, 0xA4, 0xBD, 0xA6 },
	0xB3EF, { 0xF0, 0xA4, 0xBF, 0x99 },
	0xB3F0, { 0xF0, 0xA4, 0xBF, 0xA0 },
	0xB3F1, { 0xF0, 0xAF, 0xA4, 0xBE },
	0xB3F2, { 0xF0, 0xA5, 0x81, 0x9F },
	0xB3F3, { 0xF0, 0xA5, 0x85, 0x9F },
	0xB3F4, { 0xF0, 0xA5, 0x85, 0x9E },
	0xB3F5, { 0xF0, 0xA5, 0x85, 0xA8 },
	0xB3F6, { 0xE4, 0x80, 0xA7 },
	0xB3F7, { 0xF0, 0xA5, 0x86, 0x88 },
	0xB3F8, { 0xF0, 0xA5, 0x85, 0xAA },
	0xB3F9, { 0xF0, 0xA5, 0x85, 0xAC },
	0xB3FA, { 0xF0, 0xA5, 0x85, 0xA6 },
	0xB3FB, { 0xF0, 0xA5, 0x85, 0xA7 },
	0xB3FC, { 0xF0, 0xA5, 0x86, 0x89 },
	0xB3FD, { 0xF0, 0xA5, 0x85, 0xA0 },
	0xB3FE, { 0xF0, 0xA5, 0x86, 0x85 },
	0xB4A1, { 0xF0, 0xA0, 0x8C, 0xAA },
	0xB4A2, { 0xF0, 0xA5, 0x8D, 0xA8 },
	0xB4A3, { 0xF0, 0xA5, 0x8E, 0xB9 },
	0xB4A4, { 0xF0, 0xA5, 0x8E, 0xBA },
	0xB4A5, { 0xF0, 0xA5, 0x8E, 0xBE },
	0xB4A6, { 0xF0, 0xA5, 0x91, 0xAF },
	0xB4A7, { 0xF0, 0xA5, 0x92, 0x80 },
	0xB4A8, { 0xF0, 0xA5, 0x91, 0xB4 },
	0xB4A9, { 0xF0, 0xA5, 0x92, 0x81 },
	0xB4AA, { 0xF0, 0xA5, 0x91, 0xBA },
	0xB4AB, { 0xF0, 0xA5, 0x92, 0x9C },
	0xB4AC, { 0xF0, 0xA5, 0x91, 0xB3 },
	0xB4AD, { 0xF0, 0xA5, 0x92, 0x82 },
	0xB4AE, { 0xF0, 0xA5, 0x91, 0xBF },
	0xB4AF, { 0xF0, 0xA5, 0x92, 0xA7 },
	0xB4B0, { 0xF0, 0xA5, 0x91, 0xB9 },
	0xB4B1, { 0xF0, 0xA5, 0x91, 0xB8 },
	0xB4B2, { 0xF0, 0xA5, 0x91, 0xBD },
	0xB4B3, { 0xF0, 0xA5, 0x92, 0xA8 },
	0xB4B4, { 0xF0, 0xA5, 0x91, 0xBC },
	0xB4B5, { 0xF0, 0xA5, 0x99, 0xA8 },
	0xB4B6, { 0xF0, 0xA5, 0x99, 0x8E },
	0xB4B7, { 0xF0, 0xA5, 0x9E, 0x9E },
	0xB4B8, { 0xE4, 0x85, 0x86 },
	0xB4B9, { 0xE4, 0x85, 0x80 },
	0xB4BA, { 0xF0, 0xA5, 0x9E, 0x98 },
	0xB4BB, { 0xE4, 0x84, 0xBF },
	0xB4BC, { 0xF0, 0xA5, 0x9E, 0x85 },
	0xB4BD, { 0xF0, 0xA5, 0x9E, 0x9C },
	0xB4BE, { 0xF0, 0xA5, 0x9F, 0x85 },
	0xB4BF, { 0xF0, 0xA5, 0x9E, 0x9A },
	0xB4C0, { 0xF0, 0xA5, 0xA5, 0xA8 },
	0xB4C1, { 0xF0, 0xA5, 0xA5, 0xA5 },
	0xB4C2, { 0xF0, 0xA5, 0xA5, 0xA7 },
	0xB4C3, { 0xF0, 0xA5, 0xA5, 0xA1 },
	0xB4C4, { 0xF0, 0xA5, 0xA5, 0xA0 },
	0xB4C5, { 0xE4, 0x86, 0x9D },
	0xB4C6, { 0xE4, 0x87, 0x8B },
	0xB4C7, { 0xF0, 0xA5, 0xA9, 0xBB },
	0xB4C8, { 0xE4, 0x87, 0xA1 },
	0xB4C9, { 0xF0, 0xA5, 0xAC, 0x99 },
	0xB4CA, { 0xF0, 0xA5, 0xAC, 0x8E },
	0xB4CB, { 0xF0, 0xA5, 0xAC, 0xB1 },
	0xB4CC, { 0xF0, 0xA5, 0xAC, 0x92 },
	0xB4CD, { 0xF0, 0xA5, 0xAC, 0x90 },
	0xB4CE, { 0xF0, 0xA5, 0xAC, 0x95 },
	0xB4CF, { 0xF0, 0xA5, 0xAC, 0xBF },
	0xB4D0, { 0xF0, 0xA5, 0xAC, 0x9D },
	0xB4D1, { 0xF0, 0xA5, 0xAC, 0x9E },
	0xB4D2, { 0xF0, 0xA5, 0xB9, 0x8D },
	0xB4D3, { 0xF0, 0xA5, 0xB9, 0x88 },
	0xB4D4, { 0xF0, 0xA5, 0xB9, 0x85 },
	0xB4D5, { 0xF0, 0xA5, 0xB9, 0x82 },
	0xB4D6, { 0xF0, 0xA5, 0xB9, 0x89 },
	0xB4D7, { 0xF0, 0xA5, 0xB9, 0x8A },
	0xB4D8, { 0xF0, 0xA5, 0xB9, 0x87 },
	0xB4D9, { 0xE4, 0x89, 0xBF },
	0xB4DA, { 0xF0, 0xA5, 0xB9, 0x8C },
	0xB4DB, { 0xF0, 0xA5, 0xBF, 0x8D },
	0xB4DC, { 0xF0, 0xA5, 0xBF, 0x95 },
	0xB4DD, { 0xF0, 0xA5, 0xBF, 0x84 },
	0xB4DE, { 0xF0, 0xA5, 0xBF, 0x8A },
	0xB4DF, { 0xF0, 0xA5, 0xBF, 0x83 },
	0xB4E0, { 0xE4, 0x8D, 0x86 },
	0xB4E1, { 0xF0, 0xA6, 0x88, 0xA9 },
	0xB4E2, { 0xF0, 0xA6, 0x8A, 0xB4 },
	0xB4E3, { 0xF0, 0xA6, 0x8D, 0xAD },
	0xB4E4, { 0xF0, 0xA6, 0x8D, 0xA6 },
	0xB4E5, { 0xF0, 0xA6, 0x8D, 0xAA },
	0xB4E6, { 0xF0, 0xA6, 0x90, 0x95 },
	0xB4E7, { 0xF0, 0xA6, 0x93, 0x93 },
	0xB4E8, { 0xF0, 0xA6, 0x93, 0xAC },
	0xB4E9, { 0xF0, 0xA6, 0x95, 0x95 },
	0xB4EA, { 0xE4, 0x90, 0x9A },
	0xB4EB, { 0xF0, 0xA6, 0x9B, 0x96 },
	0xB4EC, { 0xF0, 0xA6, 0x9B, 0x98 },
	0xB4ED, { 0xF0, 0xA6, 0x9D, 0x91 },
	0xB4EE, { 0xF0, 0xA6, 0x9B, 0xA0 },
	0xB4EF, { 0xF0, 0xA6, 0x9C, 0x83 },
	0xB4F0, { 0xF0, 0xA6, 0x9C, 0x84 },
	0xB4F1, { 0xF0, 0xA6, 0x9B, 0x9A },
	0xB4F2, { 0xF0, 0xA6, 0x9B, 0xAA },
	0xB4F3, { 0xF0, 0xA6, 0x9C, 0x82 },
	0xB4F4, { 0xF0, 0xA6, 0x9B, 0x93 },
	0xB4F5, { 0xF0, 0xA6, 0x9B, 0xA4 },
	0xB4F6, { 0xF0, 0xA6, 0x9B, 0xA5 },
	0xB4F7, { 0xF0, 0xA6, 0xA4, 0xBB },
	0xB4F8, { 0xF0, 0xA6, 0xA5, 0xA6 },
	0xB4F9, { 0xF0, 0xA6, 0xA8, 0xAC },
	0xB4FA, { 0xF0, 0xA6, 0xA8, 0xA1 },
	0xB4FB, { 0xF0, 0xA6, 0xA8, 0xA6 },
	0xB4FC, { 0xF0, 0xA6, 0xAB, 0x94 },
	0xB4FD, { 0xF0, 0xA6, 0xAB, 0x95 },
	0xB4FE, { 0xF0, 0xA6, 0xAB, 0x99 },
	0xB5A1, { 0xF0, 0xA6, 0xAF, 0x95 },
	0xB5A2, { 0xF0, 0xA6, 0xAF, 0xAB },
	0xB5A3, { 0xF0, 0xA6, 0xAF, 0x85 },
	0xB5A4, { 0xE4, 0x93, 0x93 },
	0xB5A5, { 0xF0, 0xA6, 0xB0, 0xA7 },
	0xB5A6, { 0xF0, 0xA6, 0xAF, 0xB0 },
	0xB5A7, { 0xF0, 0xA6, 0xAE, 0xB9 },
	0xB5A8, { 0xF0, 0xA6, 0xB0, 0x98 },
	0xB5A9, { 0xF0, 0xA6, 0xAF, 0xAE },
	0xB5AA, { 0xE4, 0x93, 0x90 },
	0xB5AB, { 0xF0, 0xA6, 0xAE, 0xB7 },
	0xB5AC, { 0xF0, 0xA6, 0xAE, 0xBB },
	0xB5AD, { 0xF0, 0xA6, 0xAF, 0xAF },
	0xB5AE, { 0xF0, 0xA6, 0xAE, 0xB8 },
	0xB5AF, { 0xF0, 0xA6, 0xAF, 0x9F },
	0xB5B0, { 0xF0, 0xA6, 0xAF, 0x9A },
	0xB5B1, { 0xF0, 0xA6, 0xAF, 0xA3 },
	0xB5B2, { 0xF0, 0xA6, 0xAF, 0x89 },
	0xB5B3, { 0xF0, 0xA6, 0xAF, 0xAC },
	0xB5B4, { 0xF0, 0xA7, 0x86, 0xA4 },
	0xB5B5, { 0xE4, 0x96, 0x8E },
	0xB5B6, { 0xF0, 0xA7, 0x86, 0xA3 },
	0xB5B7, { 0xF0, 0xA7, 0x89, 0x9E },
	0xB5B8, { 0xF0, 0xA7, 0x89, 0xA1 },
	0xB5B9, { 0xF0, 0xA7, 0x89, 0xA2 },
	0xB5BA, { 0xF0, 0xA7, 0x89, 0xA3 },
	0xB5BB, { 0xF0, 0xA7, 0x8A, 0x8E },
	0xB5BC, { 0xF0, 0xA7, 0x89, 0xA9 },
	0xB5BD, { 0xF0, 0xA7, 0x89, 0xAB },
	0xB5BE, { 0xF0, 0xA7, 0x8A, 0x85 },
	0xB5BF, { 0xF0, 0xA7, 0x8A, 0x8D },
	0xB5C0, { 0xF0, 0xA7, 0x89, 0xA4 },
	0xB5C1, { 0xF0, 0xA7, 0x89, 0xAD },
	0xB5C2, { 0xF0, 0xA7, 0x99, 0x8C },
	0xB5C3, { 0xF0, 0xA7, 0x99, 0x89 },
	0xB5C4, { 0xF0, 0xA7, 0x99, 0x87 },
	0xB5C5, { 0xF0, 0xA7, 0x99, 0x88 },
	0xB5C6, { 0xF0, 0xA7, 0x99, 0x82 },
	0xB5C7, { 0xF0, 0xA7, 0x99, 0x85 },
	0xB5C8, { 0xF0, 0xA7, 0x99, 0x9B },
	0xB5C9, { 0xF0, 0xA7, 0x99, 0x9D },
	0xB5CA, { 0xF0, 0xA7, 0x99, 0x86 },
	0xB5CB, { 0xF0, 0xA7, 0xA0, 0x93 },
	0xB5CC, { 0xF0, 0xA7, 0xA0, 0x9A },
	0xB5CD, { 0xF0, 0xA7, 0xA0, 0x8E },
	0xB5CE, { 0xF0, 0xA7, 0xA0, 0x8F },
	0xB5CF, { 0xF0, 0xA7, 0xA0, 0x9B },
	0xB5D0, { 0xF0, 0xA7, 0xA0, 0x92 },
	0xB5D1, { 0xF0, 0xA7, 0xA3, 0x83 },
	0xB5D2, { 0xF0, 0xA7, 0xA2, 0xBE },
	0xB5D3, { 0xF0, 0xA7, 0xA2, 0xBD },
	0xB5D4, { 0xF0, 0xA7, 0xA5, 0xB9 },
	0xB5D5, { 0xF0, 0xA7, 0xA5, 0xBC },
	0xB5D6, { 0xE4, 0x9B, 0x83 },
	0xB5D7, { 0xE4, 0x9A, 0xB6 },
	0xB5D8, { 0xF0, 0xA7, 0xA6, 0x80 },
	0xB5D9, { 0xF0, 0xA7, 0xA5, 0xB5 },
	0xB5DA, { 0xF0, 0xA7, 0xA6, 0x9B },
	0xB5DB, { 0xE8, 0xA8, 0xAF },
	0xB5DC, { 0xF0, 0xA7, 0xA5, 0xB4 },
	0xB5DD, { 0xE4, 0x9B, 0x80 },
	0xB5DE, { 0xE4, 0x9A, 0xB8 },
	0xB5DF, { 0xF0, 0xA2, 0x81, 0x81 },
	0xB5E0, { 0xF0, 0xA2, 0x92, 0x94 },
	0xB5E1, { 0xF0, 0xA7, 0xB0, 0xB0 },
	0xB5E2, { 0xF0, 0xA7, 0xB2, 0xA7 },
	0xB5E3, { 0xF0, 0xA7, 0xB2, 0xA5 },
	0xB5E4, { 0xF0, 0xA7, 0xB2, 0xA4 },
	0xB5E5, { 0xF0, 0xA7, 0xB4, 0xBA },
	0xB5E6, { 0xF0, 0xA7, 0xB9, 0x9B },
	0xB5E7, { 0xF0, 0xA7, 0xBA, 0x9F },
	0xB5E8, { 0xF0, 0xA7, 0xBA, 0xA8 },
	0xB5E9, { 0xF0, 0xA7, 0xBA, 0xB3 },
	0xB5EA, { 0xF0, 0xA7, 0xBA, 0xA1 },
	0xB5EB, { 0xF0, 0xA7, 0xBA, 0xA7 },
	0xB5EC, { 0xF0, 0xA7, 0xBA, 0xB2 },
	0xB5ED, { 0xF0, 0xA7, 0xBA, 0x9D },
	0xB5EE, { 0xF0, 0xA7, 0xBA, 0xA3 },
	0xB5EF, { 0xF0, 0xA7, 0xBA, 0xA2 },
	0xB5F0, { 0xF0, 0xA7, 0xBF, 0xAF },
	0xB5F1, { 0xF0, 0xA7, 0xBF, 0x99 },
	0xB5F2, { 0xE4, 0x9F, 0x99 },
	0xB5F3, { 0xF0, 0xA7, 0xBF, 0x95 },
	0xB5F4, { 0xF0, 0xA7, 0xBF, 0x9D },
	0xB5F5, { 0xF0, 0xA7, 0xBF, 0x9A },
	0xB5F6, { 0xF0, 0xA7, 0xBF, 0xAE },
	0xB5F7, { 0xF0, 0xA7, 0xBF, 0x97 },
	0xB5F8, { 0xF0, 0xA8, 0x88, 0x9A },
	0xB5F9, { 0xF0, 0xA8, 0x88, 0x99 },
	0xB5FA, { 0xF0, 0xA8, 0x88, 0x98 },
	0xB5FB, { 0xF0, 0xA8, 0x8A, 0xB3 },
	0xB5FC, { 0xF0, 0xA8, 0x8A, 0xBF },
	0xB5FD, { 0xF0, 0xA8, 0x8A, 0xBB },
	0xB5FE, { 0xF0, 0xA8, 0x8B, 0x80 },
	0xB6A1, { 0xF0, 0xA8, 0x8A, 0xB9 },
	0xB6A2, { 0xF0, 0xA8, 0x8A, 0xB8 },
	0xB6A3, { 0xF0, 0xA8, 0x8B, 0x95 },
	0xB6A4, { 0xF0, 0xA8, 0x90, 0x91 },
	0xB6A5, { 0xF0, 0xA8, 0x90, 0x90 },
	0xB6A6, { 0xF0, 0xA8, 0x93, 0x83 },
	0xB6A7, { 0xF0, 0xA8, 0x93, 0x82 },
	0xB6A8, { 0xF0, 0xA8, 0x93, 0xA9 },
	0xB6A9, { 0xF0, 0xA8, 0x93, 0x8D },
	0xB6AA, { 0xF0, 0xA8, 0x93, 0xA5 },
	0xB6AB, { 0xF0, 0xA8, 0x93, 0x8A },
	0xB6AC, { 0xF0, 0xA8, 0x93, 0x87 },
	0xB6AD, { 0xF0, 0xA8, 0x93, 0xA8 },
	0xB6AE, { 0xF0, 0xA8, 0x9B, 0xB1 },
	0xB6AF, { 0xF0, 0xA8, 0x9C, 0x8C },
	0xB6B0, { 0xF0, 0xA8, 0x9B, 0xAF },
	0xB6B1, { 0xF0, 0xA8, 0x9B, 0xAE },
	0xB6B2, { 0xF0, 0xA8, 0x9B, 0xB3 },
	0xB6B3, { 0xF0, 0xA8, 0x9C, 0x8D },
	0xB6B4, { 0xF0, 0xA8, 0x9B, 0xB6 },
	0xB6B5, { 0xF0, 0xA8, 0x9B, 0xB0 },
	0xB6B6, { 0xE4, 0xA3, 0xAC },
	0xB6B7, { 0xF0, 0xA8, 0x9F, 0xB5 },
	0xB6B8, { 0xF0, 0xA8, 0x9F, 0xB4 },
	0xB6B9, { 0xF0, 0xA8, 0x9F, 0xB8 },
	0xB6BA, { 0xF0, 0xA8, 0x9F, 0xBE },
	0xB6BB, { 0xF0, 0xA8, 0xA4, 0x91 },
	0xB6BC, { 0xF0, 0xA8, 0xA4, 0xA2 },
	0xB6BD, { 0xF0, 0xA8, 0xA5, 0x82 },
	0xB6BE, { 0xF0, 0xA8, 0xB1, 0x9C },
	0xB6BF, { 0xF0, 0xA8, 0xB1, 0x9A },
	0xB6C0, { 0xF0, 0xA8, 0xB1, 0x9D },
	0xB6C1, { 0xF0, 0xA8, 0xB3, 0x91 },
	0xB6C2, { 0xF0, 0xA8, 0xB3, 0x90 },
	0xB6C3, { 0xF0, 0xA8, 0xB9, 0xB5 },
	0xB6C4, { 0xF0, 0xA8, 0xB9, 0xBB },
	0xB6C5, { 0xF0, 0xA8, 0xBE, 0x89 },
	0xB6C6, { 0xF0, 0xA9, 0x91, 0x8D },
	0xB6C7, { 0xF0, 0xA9, 0x9A, 0x89 },
	0xB6C8, { 0xF0, 0xA9, 0x9A, 0x92 },
	0xB6C9, { 0xF0, 0xA9, 0x9A, 0x8C },
	0xB6CA, { 0xF0, 0xA9, 0x9A, 0x88 },
	0xB6CB, { 0xF0, 0xA9, 0xA1, 0xA7 },
	0xB6CC, { 0xF0, 0xA9, 0xA1, 0xA8 },
	0xB6CD, { 0xF0, 0xA0, 0x8C, 0xA1 },
	0xB6CE, { 0xF0, 0xA0, 0x8B, 0xB2 },
	0xB6CF, { 0xF0, 0xA0, 0x8C, 0x89 },
	0xB6D0, { 0xF0, 0xA0, 0x8B, 0xB8 },
	0xB6D1, { 0xF0, 0xA0, 0x8B, 0xB0 },
	0xB6D2, { 0xF0, 0xA0, 0x8B, 0xB3 },
	0xB6D3, { 0xF0, 0xA0, 0x8B, 0xB5 },
	0xB6D4, { 0xF0, 0xA0, 0x8B, 0xBB },
	0xB6D5, { 0xF0, 0xA0, 0x8B, 0xB7 },
	0xB6D6, { 0xF0, 0xA0, 0x8B, 0xAF },
	0xB6D7, { 0xF0, 0xA0, 0x8C, 0x8B },
	0xB6D8, { 0xF0, 0xA0, 0x92, 0xA2 },
	0xB6D9, { 0xF0, 0xA0, 0x97, 0xB5 },
	0xB6DA, { 0xF0, 0xA0, 0x97, 0xB3 },
	0xB6DB, { 0xF0, 0xA0, 0x97, 0xB4 },
	0xB6DC, { 0xF0, 0xA0, 0x97, 0xB2 },
	0xB6DD, { 0xF0, 0xA0, 0x9A, 0x98 },
	0xB6DE, { 0xF0, 0xA0, 0x9D, 0xA8 },
	0xB6DF, { 0xF0, 0xA0, 0x9E, 0x80 },
	0xB6E0, { 0xF0, 0xA0, 0x9E, 0x85 },
	0xB6E1, { 0xF0, 0xA0, 0x9E, 0x8E },
	0xB6E2, { 0xF0, 0xA0, 0x9E, 0x8F },
	0xB6E3, { 0xF0, 0xA0, 0x8B, 0xB4 },
	0xB6E4, { 0xF0, 0xA0, 0x9E, 0x86 },
	0xB6E5, { 0xF0, 0xA0, 0x9E, 0xA4 },
	0xB6E6, { 0xF0, 0xA0, 0xA2, 0x86 },
	0xB6E7, { 0xF0, 0xA0, 0xA2, 0x89 },
	0xB6E8, { 0xF0, 0xA0, 0xA2, 0x87 },
	0xB6E9, { 0xF0, 0xA0, 0xA2, 0x85 },
	0xB6EA, { 0xE5, 0x8B, 0x9C },
	0xB6EB, { 0xF0, 0xA0, 0xA2, 0x88 },
	0xB6EC, { 0xF0, 0xA0, 0xAB, 0xBF },
	0xB6ED, { 0xF0, 0xA0, 0xAD, 0xA6 },
	0xB6EE, { 0xE3, 0x97, 0x8C },
	0xB6EF, { 0xF0, 0xA0, 0xB7, 0x83 },
	0xB6F0, { 0xE3, 0x96, 0xA2 },
	0xB6F1, { 0xF0, 0xA0, 0xB7, 0x84 },
	0xB6F2, { 0xF0, 0xA0, 0xB8, 0xBB },
	0xB6F3, { 0xF0, 0xA0, 0xB7, 0xA7 },
	0xB6F4, { 0xF0, 0xA0, 0xB7, 0xB8 },
	0xB6F5, { 0xF0, 0xA0, 0xB7, 0xBB },
	0xB6F6, { 0xE3, 0x96, 0xB6 },
	0xB6F7, { 0xF0, 0xA0, 0xB6, 0xBE },
	0xB6F8, { 0xF0, 0xA0, 0xB7, 0x86 },
	0xB6F9, { 0xE3, 0x97, 0x85 },
	0xB6FA, { 0xE3, 0x97, 0x86 },
	0xB6FB, { 0xF0, 0xA0, 0xB7, 0xBC },
	0xB6FC, { 0xF0, 0xA0, 0xB7, 0x80 },
	0xB6FD, { 0xF0, 0xA0, 0xB8, 0xB3 },
	0xB6FE, { 0xF0, 0xA0, 0xB7, 0x89 },
	0xB7A1, { 0xF0, 0xA0, 0xB7, 0xBE },
	0xB7A2, { 0xF0, 0xA0, 0xB7, 0x9A },
	0xB7A3, { 0xF0, 0xA0, 0xB7, 0x8C },
	0xB7A4, { 0xF0, 0xA0, 0xB6, 0xBB },
	0xB7A5, { 0xF0, 0xA0, 0xB7, 0xBD },
	0xB7A6, { 0xF0, 0xA0, 0xB7, 0x9F },
	0xB7A7, { 0xF0, 0xA0, 0xB7, 0x8D },
	0xB7A8, { 0xF0, 0xA0, 0xB7, 0x82 },
	0xB7A9, { 0xF0, 0xA0, 0xB7, 0x88 },
	0xB7AA, { 0xF0, 0xA0, 0xB8, 0xB2 },
	0xB7AB, { 0xF0, 0xA0, 0xB8, 0xAD },
	0xB7AC, { 0xF0, 0xA0, 0xB7, 0x92 },
	0xB7AD, { 0xF0, 0xA0, 0xB8, 0xB1 },
	0xB7AE, { 0xF0, 0xA0, 0xB7, 0x93 },
	0xB7AF, { 0xF0, 0xA0, 0xB8, 0xAE },
	0xB7B0, { 0xF0, 0xA0, 0xB7, 0x8F },
	0xB7B1, { 0xF0, 0xA1, 0x87, 0xBF },
	0xB7B2, { 0xF0, 0xA1, 0x88, 0x89 },
	0xB7B3, { 0xF0, 0xA1, 0x87, 0xBC },
	0xB7B4, { 0xF0, 0xA1, 0x8D, 0xB2 },
	0xB7B5, { 0xF0, 0xA1, 0x8E, 0xAA },
	0xB7B6, { 0xF0, 0xA1, 0x8E, 0xAB },
	0xB7B7, { 0xF0, 0xA1, 0x8E, 0xA7 },
	0xB7B8, { 0xF0, 0xA1, 0x8D, 0xBB },
	0xB7B9, { 0xF0, 0xA1, 0x8D, 0xB6 },
	0xB7BA, { 0xF0, 0xA1, 0x8E, 0xA8 },
	0xB7BB, { 0xF0, 0xA1, 0x8E, 0xAC },
	0xB7BC, { 0xE3, 0x9A, 0x83 },
	0xB7BD, { 0xE5, 0xA4, 0xA1 },
	0xB7BE, { 0xF0, 0xA1, 0x96, 0xAA },
	0xB7BF, { 0xF0, 0xA0, 0xA8, 0x83 },
	0xB7C0, { 0xF0, 0xA1, 0x96, 0xAC },
	0xB7C1, { 0xF0, 0xA1, 0x96, 0xAD },
	0xB7C2, { 0xF0, 0xA1, 0x96, 0xAB },
	0xB7C3, { 0xF0, 0xA1, 0x99, 0x90 },
	0xB7C4, { 0xF0, 0xA1, 0x99, 0x98 },
	0xB7C5, { 0xF0, 0xA1, 0x9F, 0x9D },
	0xB7C6, { 0xE3, 0x9B, 0xB8 },
	0xB7C7, { 0xF0, 0xA1, 0x9E, 0xAE },
	0xB7C8, { 0xF0, 0xA1, 0x9E, 0xA2 },
	0xB7C9, { 0xF0, 0xA1, 0x9E, 0xAB },
	0xB7CA, { 0xF0, 0xA1, 0x9F, 0xA3 },
	0xB7CB, { 0xF0, 0xA1, 0x9E, 0xAF },
	0xB7CC, { 0xF0, 0xA1, 0x9F, 0xA0 },
	0xB7CD, { 0xF0, 0xA1, 0x9F, 0xA4 },
	0xB7CE, { 0xE3, 0x9B, 0xB6 },
	0xB7CF, { 0xF0, 0xA1, 0x9E, 0xA7 },
	0xB7D0, { 0xF0, 0xA1, 0x9E, 0xAA },
	0xB7D1, { 0xF0, 0xA1, 0x9F, 0xA2 },
	0xB7D2, { 0xF0, 0xA1, 0x9F, 0xA1 },
	0xB7D3, { 0xF0, 0xA1, 0x9F, 0x9F },
	0xB7D4, { 0xF0, 0xA1, 0x9E, 0xAD },
	0xB7D5, { 0xF0, 0xA1, 0x9F, 0xA5 },
	0xB7D6, { 0xF0, 0xA1, 0x9F, 0x91 },
	0xB7D7, { 0xF0, 0xA1, 0x9E, 0xAC },
	0xB7D8, { 0xF0, 0xA1, 0x9F, 0x95 },
	0xB7D9, { 0xF0, 0xA1, 0x9E, 0xA3 },
	0xB7DA, { 0xF0, 0xA1, 0x9E, 0x9F },
	0xB7DB, { 0xF0, 0xA1, 0xA5, 0xB9 },
	0xB7DC, { 0xF0, 0xA1, 0xA5, 0xB6 },
	0xB7DD, { 0xF0, 0xA1, 0xA9, 0x83 },
	0xB7DE, { 0xF0, 0xA1, 0xA8, 0xBD },
	0xB7DF, { 0xF0, 0xA1, 0xA9, 0x87 },
	0xB7E0, { 0xF0, 0xA1, 0xA9, 0x84 },
	0xB7E1, { 0xF0, 0xA1, 0xA8, 0xBF },
	0xB7E2, { 0xF0, 0xA1, 0xA9, 0x9B },
	0xB7E3, { 0xF0, 0xA1, 0xAD, 0xBF },
	0xB7E4, { 0xF0, 0xA1, 0xB2, 0x9A },
	0xB7E5, { 0xF0, 0xA1, 0xB2, 0x9C },
	0xB7E6, { 0xE3, 0x9E, 0x9B },
	0xB7E7, { 0xF0, 0xA1, 0xB4, 0x9E },
	0xB7E8, { 0xF0, 0xA1, 0xBA, 0x88 },
	0xB7E9, { 0xF0, 0xA1, 0xB9, 0xAA },
	0xB7EA, { 0xF0, 0xA1, 0xB9, 0xB6 },
	0xB7EB, { 0xF0, 0xA1, 0xB9, 0xB2 },
	0xB7EC, { 0xF0, 0xA1, 0xB9, 0xB0 },
	0xB7ED, { 0xF0, 0xA1, 0xB9, 0xBE },
	0xB7EE, { 0xF0, 0xA1, 0xB9, 0xAC },
	0xB7EF, { 0xF0, 0xA1, 0xB9, 0xAF },
	0xB7F0, { 0xF0, 0xA1, 0xB9, 0xB5 },
	0xB7F1, { 0xF0, 0xA1, 0xB9, 0xB7 },
	0xB7F2, { 0xF0, 0xA1, 0xB9, 0xB8 },
	0xB7F3, { 0xF0, 0xA1, 0xBA, 0x8A },
	0xB7F4, { 0xF0, 0xA1, 0xB9, 0xB9 },
	0xB7F5, { 0xF0, 0xA1, 0xBA, 0x94 },
	0xB7F6, { 0xF0, 0xA2, 0x80, 0x81 },
	0xB7F7, { 0xF0, 0xA2, 0x84, 0x85 },
	0xB7F8, { 0xF0, 0xA2, 0x83, 0xB1 },
	0xB7F9, { 0xF0, 0xA2, 0x83, 0xAE },
	0xB7FA, { 0xF0, 0xA2, 0x83, 0xAF },
	0xB7FB, { 0xF0, 0xA2, 0x84, 0x84 },
	0xB7FC, { 0xE5, 0xB8, 0xBF },
	0xB7FD, { 0xF0, 0xA2, 0x83, 0xBA },
	0xB7FE, { 0xF0, 0xA2, 0x84, 0x87 },
	0xB8A1, { 0xF0, 0xA2, 0x83, 0xB4 },
	0xB8A2, { 0xF0, 0xA2, 0x83, 0xB5 },
	0xB8A3, { 0xF0, 0xA2, 0x86, 0x9C },
	0xB8A4, { 0xF0, 0xA2, 0x89, 0xAD },
	0xB8A5, { 0xF0, 0xA2, 0x89, 0xA9 },
	0xB8A6, { 0xF0, 0xA2, 0x89, 0xA6 },
	0xB8A7, { 0xF0, 0xA2, 0x89, 0xA2 },
	0xB8A8, { 0xF0, 0xA2, 0x89, 0x86 },
	0xB8A9, { 0xE3, 0xA2, 0x8D },
	0xB8AA, { 0xF0, 0xA2, 0x89, 0xA5 },
	0xB8AB, { 0xF0, 0xA2, 0x89, 0x9D },
	0xB8AC, { 0xF0, 0xA2, 0x89, 0x9E },
	0xB8AD, { 0xF0, 0xA2, 0x89, 0x9F },
	0xB8AE, { 0xF0, 0xA2, 0x8E, 0x8E },
	0xB8AF, { 0xF0, 0xA2, 0x90, 0x82 },
	0xB8B0, { 0xF0, 0xA2, 0x90, 0x86 },
	0xB8B1, { 0xF0, 0xA2, 0x90, 0x84 },
	0xB8B2, { 0xF0, 0xA2, 0x90, 0x83 },
	0xB8B3, { 0xF0, 0xA2, 0x91, 0xA2 },
	0xB8B4, { 0xF0, 0xA2, 0x94, 0xA7 },
	0xB8B5, { 0xF0, 0xA2, 0x94, 0xA1 },
	0xB8B6, { 0xF0, 0xA2, 0x94, 0xA0 },
	0xB8B7, { 0xF0, 0xA2, 0x94, 0xA4 },
	0xB8B8, { 0xF0, 0xA2, 0x94, 0xA9 },
	0xB8B9, { 0xF0, 0xA2, 0x94, 0xB1 },
	0xB8BA, { 0xF0, 0xA2, 0x94, 0xA3 },
	0xB8BB, { 0xF0, 0xA2, 0x94, 0xA2 },
	0xB8BC, { 0xF0, 0xA2, 0x9B, 0x9C },
	0xB8BD, { 0xF0, 0xA2, 0x9D, 0x8D },
	0xB8BE, { 0xF0, 0xA2, 0x9B, 0xA5 },
	0xB8BF, { 0xF0, 0xA2, 0x9B, 0x93 },
	0xB8C0, { 0xF0, 0xA2, 0x9B, 0xAE },
	0xB8C1, { 0xF0, 0xA2, 0x9B, 0xA6 },
	0xB8C2, { 0xE3, 0xA5, 0x96 },
	0xB8C3, { 0xF0, 0xA2, 0x9C, 0xB6 },
	0xB8C4, { 0xF0, 0xA2, 0x9D, 0x80 },
	0xB8C5, { 0xF0, 0xA2, 0xA0, 0xBF },
	0xB8C6, { 0xF0, 0xA2, 0x9C, 0xBD },
	0xB8C7, { 0xF0, 0xA2, 0x9D, 0x84 },
	0xB8C8, { 0xE3, 0xA5, 0x9B },
	0xB8C9, { 0xF0, 0xA2, 0x9D, 0x9F },
	0xB8CA, { 0xF0, 0xA2, 0x9C, 0xA9 },
	0xB8CB, { 0xF0, 0xA2, 0x9D, 0x89 },
	0xB8CC, { 0xF0, 0xA2, 0x9E, 0x8A },
	0xB8CD, { 0xF0, 0xA2, 0x9C, 0xAA },
	0xB8CE, { 0xF0, 0xA2, 0x9E, 0x87 },
	0xB8CF, { 0xF0, 0xA2, 0x9D, 0x8C },
	0xB8D0, { 0xF0, 0xA2, 0x9C, 0xB1 },
	0xB8D1, { 0xF0, 0xA2, 0x9D, 0x88 },
	0xB8D2, { 0xF0, 0xA2, 0x9C, 0xAB },
	0xB8D3, { 0xF0, 0xA2, 0x9C, 0xBB },
	0xB8D4, { 0xF0, 0xA2, 0x9D, 0x81 },
	0xB8D5, { 0xF0, 0xA2, 0x9B, 0x89 },
	0xB8D6, { 0xF0, 0xA2, 0x9C, 0xB4 },
	0xB8D7, { 0xF0, 0xA2, 0x9D, 0x93 },
	0xB8D8, { 0xF0, 0xA2, 0x9C, 0xB5 },
	0xB8D9, { 0xF0, 0xA2, 0x9D, 0x87 },
	0xB8DA, { 0xF0, 0xA2, 0x9C, 0xB8 },
	0xB8DB, { 0xF0, 0xA2, 0xA7, 0x91 },
	0xB8DC, { 0xF0, 0xA2, 0xA7, 0x92 },
	0xB8DD, { 0xF0, 0xA2, 0xA9, 0x91 },
	0xB8DE, { 0xF0, 0xA2, 0xA9, 0x95 },
	0xB8DF, { 0xF0, 0xA2, 0xA9, 0x92 },
	0xB8E0, { 0xF0, 0xA2, 0xA9, 0x93 },
	0xB8E1, { 0xF0, 0xA2, 0xAE, 0x8F },
	0xB8E2, { 0xF0, 0xA2, 0xAF, 0xB4 },
	0xB8E3, { 0xF0, 0xA2, 0xB1, 0x87 },
	0xB8E4, { 0xF0, 0xA2, 0xB0, 0x8D },
	0xB8E5, { 0xF0, 0xA2, 0xB0, 0x9C },
	0xB8E6, { 0xF0, 0xA2, 0xAF, 0xBB },
	0xB8E7, { 0xF0, 0xA2, 0xB0, 0x99 },
	0xB8E8, { 0xF0, 0xA2, 0xAF, 0xB7 },
	0xB8E9, { 0xF0, 0xA2, 0xAF, 0xB9 },
	0xB8EA, { 0xF0, 0xA2, 0xAF, 0xB5 },
	0xB8EB, { 0xF0, 0xA2, 0xAF, 0xA9 },
	0xB8EC, { 0xF0, 0xA2, 0xB0, 0x8A },
	0xB8ED, { 0xF0, 0xA2, 0xAF, 0xAE },
	0xB8EE, { 0xF0, 0xA2, 0xB0, 0x8B },
	0xB8EF, { 0xF0, 0xA2, 0xAF, 0xBD },
	0xB8F0, { 0xF0, 0xA2, 0xB0, 0x86 },
	0xB8F1, { 0xF0, 0xA2, 0xB0, 0x82 },
	0xB8F2, { 0xF0, 0xA2, 0xB0, 0x96 },
	0xB8F3, { 0xF0, 0xA2, 0xB0, 0x98 },
	0xB8F4, { 0xF0, 0xA2, 0xAF, 0xB0 },
	0xB8F5, { 0xF0, 0xA2, 0xBB, 0x94 },
	0xB8F6, { 0xF0, 0xA2, 0xBD, 0xA6 },
	0xB8F7, { 0xF0, 0xA2, 0xBD, 0xAA },
	0xB8F8, { 0xF0, 0xA2, 0xBD, 0xB5 },
	0xB8F9, { 0xF0, 0xA2, 0xBD, 0xB6 },
	0xB8FA, { 0xF0, 0xA2, 0xBE, 0x80 },
	0xB8FB, { 0xF0, 0xA2, 0xBD, 0xAD },
	0xB8FC, { 0xE3, 0xAA, 0x96 },
	0xB8FD, { 0xF0, 0xA2, 0xBD, 0xA9 },
	0xB8FE, { 0xF0, 0xA2, 0xBD, 0xA7 },
	0xB9A1, { 0xF0, 0xA2, 0xBD, 0xA8 },
	0xB9A2, { 0xF0, 0xA2, 0xBD, 0x9D },
	0xB9A3, { 0xF0, 0xA3, 0x82, 0xA4 },
	0xB9A4, { 0xF0, 0xA3, 0x83, 0xBE },
	0xB9A5, { 0xF0, 0xA3, 0x83, 0xBD },
	0xB9A6, { 0xF0, 0xA3, 0x87, 0xAC },
	0xB9A7, { 0xF0, 0xA3, 0x87, 0xA9 },
	0xB9A8, { 0xF0, 0xA3, 0x88, 0xA1 },
	0xB9A9, { 0xF0, 0xA3, 0x87, 0xAB },
	0xB9AA, { 0xF0, 0xA3, 0x87, 0xA7 },
	0xB9AB, { 0xF0, 0xA3, 0x87, 0xB2 },
	0xB9AC, { 0xF0, 0xA3, 0x88, 0xA0 },
	0xB9AD, { 0xF0, 0xA3, 0x8D, 0xBA },
	0xB9AE, { 0xF0, 0xA3, 0x94, 0xAD },
	0xB9AF, { 0xF0, 0xA3, 0x94, 0xAE },
	0xB9B0, { 0xF0, 0xA3, 0x93, 0x8A },
	0xB9B1, { 0xF0, 0xA3, 0x94, 0xAF },
	0xB9B2, { 0xF0, 0xA3, 0x93, 0x88 },
	0xB9B3, { 0xE3, 0xAD, 0xBE },
	0xB9B4, { 0xF0, 0xA3, 0x93, 0x8B },
	0xB9B5, { 0xF0, 0xA3, 0x93, 0x83 },
	0xB9B6, { 0xF0, 0xA3, 0x92, 0x84 },
	0xB9B7, { 0xF0, 0xA3, 0x93, 0x92 },
	0xB9B8, { 0xF0, 0xA3, 0x93, 0x86 },
	0xB9B9, { 0xE3, 0xAE, 0x81 },
	0xB9BA, { 0xF0, 0xA3, 0x93, 0x8F },
	0xB9BB, { 0xF0, 0xA3, 0x93, 0x95 },
	0xB9BC, { 0xF0, 0xA3, 0x93, 0x94 },
	0xB9BD, { 0xF0, 0xA3, 0x93, 0x9D },
	0xB9BE, { 0xF0, 0xA3, 0x94, 0xAB },
	0xB9BF, { 0xF0, 0xA3, 0x96, 0xA3 },
	0xB9C0, { 0xF0, 0xA3, 0x93, 0x9B },
	0xB9C1, { 0xF0, 0xA3, 0x94, 0xAC },
	0xB9C2, { 0xF0, 0xA3, 0x94, 0x93 },
	0xB9C3, { 0xE3, 0xB0, 0xB5 },
	0xB9C4, { 0xF0, 0xA3, 0xA3, 0x91 },
	0xB9C5, { 0xF0, 0xA3, 0xA3, 0x8C },
	0xB9C6, { 0xF0, 0xA3, 0xA3, 0x95 },
	0xB9C7, { 0xF0, 0xA3, 0xA3, 0x89 },
	0xB9C8, { 0xF0, 0xA3, 0xA3, 0x8F },
	0xB9C9, { 0xF0, 0xA3, 0xA3, 0x92 },
	0xB9CA, { 0xF0, 0xA3, 0xA5, 0xBB },
	0xB9CB, { 0xF0, 0xA3, 0xA5, 0xBC },
	0xB9CC, { 0xF0, 0xA3, 0xA8, 0xA3 },
	0xB9CD, { 0xF0, 0xA3, 0xA8, 0x9D },
	0xB9CE, { 0xF0, 0xA3, 0xA8, 0x9C },
	0xB9CF, { 0xF0, 0xA3, 0xA8, 0x9E },
	0xB9D0, { 0xF0, 0xA3, 0xA8, 0xA2 },
	0xB9D1, { 0xF0, 0xA3, 0xA8, 0xA4 },
	0xB9D2, { 0xF0, 0xA3, 0xA8, 0xA0 },
	0xB9D3, { 0xF0, 0xA3, 0xA8, 0x98 },
	0xB9D4, { 0xF0, 0xA3, 0xA8, 0xA1 },
	0xB9D5, { 0xF0, 0xA3, 0xAE, 0x88 },
	0xB9D6, { 0xF0, 0xA3, 0xAE, 0x8A },
	0xB9D7, { 0xF0, 0xA3, 0xAE, 0x94 },
	0xB9D8, { 0xF0, 0xA3, 0xAE, 0x8F },
	0xB9D9, { 0xF0, 0xA3, 0xAE, 0x8E },
	0xB9DA, { 0xF0, 0xA3, 0xAE, 0x90 },
	0xB9DB, { 0xE3, 0xB2, 0x9B },
	0xB9DC, { 0xF0, 0xA3, 0xAE, 0xA7 },
	0xB9DD, { 0xF0, 0xA3, 0xB1, 0xA4 },
	0xB9DE, { 0xE3, 0xB4, 0x80 },
	0xB9DF, { 0xF0, 0xA3, 0xB8, 0x98 },
	0xB9E0, { 0xF0, 0xA3, 0xB8, 0x94 },
	0xB9E1, { 0xF0, 0xA3, 0xB8, 0x9D },
	0xB9E2, { 0xF0, 0xA3, 0xB8, 0x85 },
	0xB9E3, { 0xF0, 0xA3, 0xB7, 0xBF },
	0xB9E4, { 0xF0, 0xA3, 0xB8, 0x9B },
	0xB9E5, { 0xF0, 0xA3, 0xB8, 0x9A },
	0xB9E6, { 0xF0, 0xA3, 0xB8, 0x99 },
	0xB9E7, { 0xF0, 0xA3, 0xB8, 0x83 },
	0xB9E8, { 0xF0, 0xA3, 0xB8, 0x8E },
	0xB9E9, { 0xF0, 0xA3, 0xB9, 0x87 },
	0xB9EA, { 0xF0, 0xA3, 0xB8, 0x84 },
	0xB9EB, { 0xF0, 0xA3, 0xB9, 0x9A },
	0xB9EC, { 0xF0, 0xA3, 0xB8, 0x87 },
	0xB9ED, { 0xF0, 0xA3, 0xB8, 0xA0 },
	0xB9EE, { 0xF0, 0xA4, 0x89, 0xAA },
	0xB9EF, { 0xF0, 0xA4, 0x89, 0xA6 },
	0xB9F0, { 0xF0, 0xA4, 0x89, 0xBA },
	0xB9F1, { 0xF0, 0xA4, 0x89, 0xA5 },
	0xB9F2, { 0xF0, 0xA4, 0x8A, 0xAF },
	0xB9F3, { 0xF0, 0xA4, 0x97, 0x8D },
	0xB9F4, { 0xF0, 0xA4, 0x97, 0x8F },
	0xB9F5, { 0xF0, 0xA4, 0x97, 0x91 },
	0xB9F6, { 0xF0, 0xA4, 0x97, 0x8E },
	0xB9F7, { 0xF0, 0xA4, 0x99, 0x9F },
	0xB9F8, { 0xF0, 0xA4, 0x99, 0xB7 },
	0xB9F9, { 0xF0, 0xA4, 0x99, 0xB4 },
	0xB9FA, { 0xF0, 0xA4, 0x9A, 0x88 },
	0xB9FB, { 0xF0, 0xA4, 0x99, 0xB5 },
	0xB9FC, { 0xF0, 0xA4, 0x9A, 0x89 },
	0xB9FD, { 0xF0, 0xA4, 0x99, 0xB2 },
	0xB9FE, { 0xF0, 0xA4, 0x9F, 0x86 },
	0xBAA1, { 0xF0, 0xA4, 0x9F, 0xAA },
	0xBAA2, { 0xF0, 0xA4, 0x9F, 0xA0 },
	0xBAA3, { 0xF0, 0xA4, 0xA0, 0x87 },
	0xBAA4, { 0xF0, 0xA4, 0x9F, 0xA6 },
	0xBAA5, { 0xF0, 0xA4, 0x9F, 0xA5 },
	0xBAA6, { 0xF0, 0xA4, 0x9F, 0x9D },
	0xBAA7, { 0xF0, 0xA4, 0x9F, 0xA3 },
	0xBAA8, { 0xF0, 0xA4, 0x9F, 0x9A },
	0xBAA9, { 0xF0, 0xA4, 0xA6, 0xAE },
	0xBAAA, { 0xF0, 0xA4, 0xA5, 0xBE },
	0xBAAB, { 0xF0, 0xA4, 0xA5, 0xBD },
	0xBAAC, { 0xF0, 0xA4, 0xA5, 0xBF },
	0xBAAD, { 0xE3, 0xBB, 0x93 },
	0xBAAE, { 0xF0, 0xA4, 0xA7, 0x99 },
	0xBAAF, { 0xF0, 0xA4, 0xAB, 0xBA },
	0xBAB0, { 0xF0, 0xA4, 0xAB, 0xBB },
	0xBAB1, { 0xF0, 0xA4, 0xAD, 0x8D },
	0xBAB2, { 0xF0, 0xA4, 0xAD, 0x94 },
	0xBAB3, { 0xF0, 0xA4, 0xAD, 0x91 },
	0xBAB4, { 0xF0, 0xA4, 0xAD, 0x90 },
	0xBAB5, { 0xF0, 0xA4, 0xB6, 0x98 },
	0xBAB6, { 0xF0, 0xA4, 0xB6, 0x95 },
	0xBAB7, { 0xF0, 0xA4, 0xB6, 0x9D },
	0xBAB8, { 0xF0, 0xA4, 0xB7, 0x81 },
	0xBAB9, { 0xF0, 0xA4, 0xB6, 0x9A },
	0xBABA, { 0xF0, 0xA4, 0xB6, 0x9B },
	0xBABB, { 0xE3, 0xBE, 0x9F },
	0xBABC, { 0xF0, 0xA4, 0xB6, 0x9C },
	0xBABD, { 0xF0, 0xA4, 0xB7, 0x97 },
	0xBABE, { 0xF0, 0xA4, 0xB6, 0xA4 },
	0xBABF, { 0xF0, 0xA4, 0xB6, 0x96 },
	0xBAC0, { 0xF0, 0xA4, 0xB6, 0xA0 },
	0xBAC1, { 0xF0, 0xA4, 0xBC, 0xB1 },
	0xBAC2, { 0xF0, 0xA4, 0xBF, 0xA9 },
	0xBAC3, { 0xF0, 0xA5, 0x81, 0xAE },
	0xBAC4, { 0xF0, 0xA5, 0x86, 0x9A },
	0xBAC5, { 0xF0, 0xA5, 0x86, 0xA5 },
	0xBAC6, { 0xF0, 0xA5, 0x86, 0x94 },
	0xBAC7, { 0xF0, 0xA5, 0x86, 0xA6 },
	0xBAC8, { 0xF0, 0xA5, 0x86, 0x99 },
	0xBAC9, { 0xF0, 0xA5, 0x86, 0x8B },
	0xBACA, { 0xF0, 0xA5, 0x86, 0x98 },
	0xBACB, { 0xF0, 0xA5, 0x86, 0x91 },
	0xBACC, { 0xF0, 0xA5, 0x86, 0x8C },
	0xBACD, { 0xF0, 0xA5, 0x86, 0xA1 },
	0xBACE, { 0xF0, 0xA5, 0x86, 0xA3 },
	0xBACF, { 0xF0, 0xA5, 0x87, 0x86 },
	0xBAD0, { 0xF0, 0xA5, 0x8D, 0xAF },
	0xBAD1, { 0xF0, 0xA5, 0x8D, 0xAD },
	0xBAD2, { 0xF0, 0xA5, 0x8D, 0xAA },
	0xBAD3, { 0xF0, 0xA5, 0x8D, 0xAC },
	0xBAD4, { 0xF0, 0xA5, 0x8D, 0xB1 },
	0xBAD5, { 0xF0, 0xA5, 0x8D, 0xAE },
	0xBAD6, { 0xF0, 0xA5, 0x8F, 0x9F },
	0xBAD7, { 0xF0, 0xA5, 0x92, 0xAC },
	0xBAD8, { 0xF0, 0xA5, 0x92, 0xAA },
	0xBAD9, { 0xE4, 0x82, 0xB1 },
	0xBADA, { 0xF0, 0xA5, 0x92, 0xB5 },
	0xBADB, { 0xF0, 0xA5, 0x92, 0xAD },
	0xBADC, { 0xF0, 0xA5, 0x92, 0xB2 },
	0xBADD, { 0xF0, 0xA5, 0x92, 0xB3 },
	0xBADE, { 0xF0, 0xA5, 0x92, 0xAB },
	0xBADF, { 0xF0, 0xA5, 0x92, 0xB6 },
	0xBAE0, { 0xF0, 0xA5, 0x93, 0x87 },
	0xBAE1, { 0xF0, 0xA5, 0x93, 0x86 },
	0xBAE2, { 0xF0, 0xA5, 0x99, 0xAC },
	0xBAE3, { 0xF0, 0xA5, 0x99, 0xB0 },
	0xBAE4, { 0xF0, 0xA5, 0x9E, 0xB3 },
	0xBAE5, { 0xE4, 0x85, 0x8B },
	0xBAE6, { 0xF0, 0xA5, 0xA6, 0x8C },
	0xBAE7, { 0xF0, 0xA5, 0xA6, 0x81 },
	0xBAE8, { 0xF0, 0xA5, 0xA6, 0x83 },
	0xBAE9, { 0xF0, 0xA5, 0xA5, 0xBD },
	0xBAEA, { 0xF0, 0xA5, 0xA6, 0x85 },
	0xBAEB, { 0xF0, 0xA5, 0xA6, 0x90 },
	0xBAEC, { 0xF0, 0xA5, 0xA6, 0xA2 },
	0xBAED, { 0xF0, 0xA5, 0xA6, 0x8D },
	0xBAEE, { 0xF0, 0xA5, 0xA6, 0x8F },
	0xBAEF, { 0xF0, 0xA5, 0xA5, 0xBE },
	0xBAF0, { 0xF0, 0xA5, 0xA6, 0x8A },
	0xBAF1, { 0xF0, 0xA5, 0xA5, 0xBF },
	0xBAF2, { 0xF0, 0xA5, 0xA5, 0xB6 },
	0xBAF3, { 0xF0, 0xA5, 0xA6, 0x87 },
	0xBAF4, { 0xF0, 0xA5, 0xA5, 0xB8 },
	0xBAF5, { 0xF0, 0xA5, 0xAA, 0x80 },
	0xBAF6, { 0xF0, 0xA5, 0xAA, 0x82 },
	0xBAF7, { 0xF0, 0xA5, 0xAA, 0x81 },
	0xBAF8, { 0xF0, 0xA5, 0xAA, 0x83 },
	0xBAF9, { 0xF0, 0xA5, 0xAD, 0x9A },
	0xBAFA, { 0xF0, 0xA5, 0xAC, 0xB4 },
	0xBAFB, { 0xF0, 0xA5, 0xAC, 0xAC },
	0xBAFC, { 0xF0, 0xA5, 0xAC, 0xAA },
	0xBAFD, { 0xF0, 0xA5, 0xAD, 0x80 },
	0xBAFE, { 0xF0, 0xA5, 0xAC, 0xAD },
	0xBBA1, { 0xF0, 0xA5, 0xAC, 0xB3 },
	0xBBA2, { 0xF0, 0xA5, 0xAC, 0xAB },
	0xBBA3, { 0xF0, 0xA5, 0xAD, 0x8B },
	0xBBA4, { 0xE7, 0xAC, 0xBF },
	0xBBA5, { 0xF0, 0xA5, 0xAC, 0xBC },
	0xBBA6, { 0xF0, 0xA5, 0xB9, 0x9A },
	0xBBA7, { 0xF0, 0xA5, 0xB9, 0xB7 },
	0xBBA8, { 0xF0, 0xA5, 0xB9, 0xA0 },
	0xBBA9, { 0xF0, 0xA5, 0xBF, 0xBA },
	0xBBAA, { 0xF0, 0xA5, 0xBF, 0xB9 },
	0xBBAB, { 0xF0, 0xA5, 0xBF, 0xBC },
	0xBBAC, { 0xE4, 0x8B, 0x96 },
	0xBBAD, { 0xF0, 0xA5, 0xBF, 0xB5 },
	0xBBAE, { 0xF0, 0xA5, 0xBF, 0xA8 },
	0xBBAF, { 0xF0, 0xA6, 0x80, 0x89 },
	0xBBB0, { 0xF0, 0xA5, 0xBF, 0xA7 },
	0xBBB1, { 0xF0, 0xA5, 0xBF, 0xA6 },
	0xBBB2, { 0xF0, 0xA5, 0xBF, 0xA9 },
	0xBBB3, { 0xF0, 0xA6, 0x88, 0xB2 },
	0xBBB4, { 0xF0, 0xA6, 0x88, 0xAC },
	0xBBB5, { 0xF0, 0xA6, 0x8A, 0xBD },
	0xBBB6, { 0xF0, 0xA6, 0x8A, 0xBC },
	0xBBB7, { 0xF0, 0xA6, 0x8D, 0xBA },
	0xBBB8, { 0xF0, 0xA6, 0x8D, 0xBE },
	0xBBB9, { 0xF0, 0xA6, 0x8D, 0xB9 },
	0xBBBA, { 0xE4, 0x8E, 0x89 },
	0xBBBB, { 0xF0, 0xA6, 0x90, 0xA3 },
	0xBBBC, { 0xF0, 0xA6, 0x90, 0xB0 },
	0xBBBD, { 0xF0, 0xA6, 0x90, 0xA8 },
	0xBBBE, { 0xF0, 0xA6, 0x93, 0x94 },
	0xBBBF, { 0xF0, 0xA6, 0xAB, 0x8E },
	0xBBC0, { 0xF0, 0xA6, 0x93, 0xB1 },
	0xBBC1, { 0xF0, 0xA6, 0x93, 0xB0 },
	0xBBC2, { 0xF0, 0xA6, 0x95, 0xA0 },
	0xBBC3, { 0xF0, 0xA6, 0x95, 0xA5 },
	0xBBC4, { 0xF0, 0xA6, 0x9A, 0xA8 },
	0xBBC5, { 0xF0, 0xA6, 0x9C, 0x8A },
	0xBBC6, { 0xF0, 0xA6, 0x9C, 0x9B },
	0xBBC7, { 0xF0, 0xA6, 0x9C, 0x92 },
	0xBBC8, { 0xF0, 0xA6, 0x9C, 0x87 },
	0xBBC9, { 0xF0, 0xA6, 0x9D, 0x8F },
	0xBBCA, { 0xF0, 0xA6, 0x9C, 0x8E },
	0xBBCB, { 0xF0, 0xA6, 0x9D, 0x92 },
	0xBBCC, { 0xF0, 0xA6, 0x9C, 0x96 },
	0xBBCD, { 0xE4, 0x90, 0x80 },
	0xBBCE, { 0xF0, 0xA6, 0x9D, 0x93 },
	0xBBCF, { 0xF0, 0xA6, 0x9D, 0x94 },
	0xBBD0, { 0xF0, 0xAF, 0xA6, 0x84 },
	0xBBD1, { 0xF0, 0xA6, 0x9D, 0x96 },
	0xBBD2, { 0xF0, 0xA6, 0xA5, 0xAD },
	0xBBD3, { 0xF0, 0xA6, 0xA5, 0xB2 },
	0xBBD4, { 0xF0, 0xA6, 0xA8, 0xAF },
	0xBBD5, { 0xF0, 0xA6, 0xB0, 0xAA },
	0xBBD6, { 0xE4, 0x93, 0x9C },
	0xBBD7, { 0xF0, 0xA6, 0xB1, 0xA3 },
	0xBBD8, { 0xF0, 0xA6, 0xB2, 0x84 },
	0xBBD9, { 0xF0, 0xA6, 0xB2, 0xAF },
	0xBBDA, { 0xF0, 0xA6, 0xB1, 0x85 },
	0xBBDB, { 0xF0, 0xA6, 0xB1, 0xB0 },
	0xBBDC, { 0xF0, 0xA6, 0xB1, 0x96 },
	0xBBDD, { 0xF0, 0xA6, 0xB0, 0x96 },
	0xBBDE, { 0xF0, 0xA6, 0xB0, 0xBD },
	0xBBDF, { 0xF0, 0xA6, 0xB0, 0xB8 },
	0xBBE0, { 0xF0, 0xA6, 0xB1, 0xAF },
	0xBBE1, { 0xF0, 0xA6, 0xB1, 0xB7 },
	0xBBE2, { 0xF0, 0xA6, 0xB0, 0xAE },
	0xBBE3, { 0xF0, 0xA6, 0xB0, 0xB1 },
	0xBBE4, { 0xF0, 0xA6, 0xB1, 0x8C },
	0xBBE5, { 0xF0, 0xA6, 0xB1, 0x9F },
	0xBBE6, { 0xF0, 0xA6, 0xB1, 0xB5 },
	0xBBE7, { 0xF0, 0xA6, 0xB0, 0xB9 },
	0xBBE8, { 0xF0, 0xA6, 0xB0, 0xBA },
	0xBBE9, { 0xF0, 0xA6, 0xB0, 0xAC },
	0xBBEA, { 0xF0, 0xA6, 0xB0, 0xAD },
	0xBBEB, { 0xF0, 0xA6, 0xB0, 0xBF },
	0xBBEC, { 0xF0, 0xA6, 0xB0, 0xAF },
	0xBBED, { 0xF0, 0xA6, 0xB0, 0xB0 },
	0xBBEE, { 0xF0, 0xA6, 0xB0, 0xBE },
	0xBBEF, { 0xE8, 0x8F, 0x90 },
	0xBBF0, { 0xE4, 0x96, 0x90 },
	0xBBF1, { 0xF0, 0xA7, 0x86, 0xB2 },
	0xBBF2, { 0xF0, 0xA7, 0x8A, 0xB7 },
	0xBBF3, { 0xF0, 0xA7, 0x8A, 0x8F },
	0xBBF4, { 0xE4, 0x96, 0xB1 },
	0xBBF5, { 0xF0, 0xA7, 0x8A, 0x96 },
	0xBBF6, { 0xF0, 0xA7, 0x8A, 0x9E },
	0xBBF7, { 0xF0, 0xA7, 0x8A, 0x97 },
	0xBBF8, { 0xF0, 0xA7, 0x8A, 0x95 },
	0xBBF9, { 0xF0, 0xA7, 0x8A, 0xA5 },
	0xBBFA, { 0xF0, 0xA7, 0x8A, 0x98 },
	0xBBFB, { 0xE8, 0x9B, 0xA7 },
	0xBBFC, { 0xF0, 0xA7, 0x8A, 0xA3 },
	0xBBFD, { 0xF0, 0xA7, 0x8A, 0x9A },
	0xBBFE, { 0xF0, 0xA7, 0x8A, 0xAD },
	0xBCA1, { 0xF0, 0xA7, 0x8A, 0xA6 },
	0xBCA2, { 0xF0, 0xA7, 0x8A, 0xB6 },
	0xBCA3, { 0xF0, 0xA7, 0x8A, 0x99 },
	0xBCA4, { 0xF0, 0xA7, 0x8A, 0xAF },
	0xBCA5, { 0xF0, 0xA7, 0x8A, 0xAC },
	0xBCA6, { 0xE4, 0x96, 0xAA },
	0xBCA7, { 0xF0, 0xA7, 0x8A, 0x9F },
	0xBCA8, { 0xF0, 0xA7, 0x8A, 0x94 },
	0xBCA9, { 0xF0, 0xA7, 0x97, 0xAB },
	0xBCAA, { 0xF0, 0xA7, 0x99, 0xAF },
	0xBCAB, { 0xF0, 0xA7, 0x99, 0xAD },
	0xBCAC, { 0xF0, 0xA7, 0x99, 0xBE },
	0xBCAD, { 0xF0, 0xA7, 0x99, 0xAC },
	0xBCAE, { 0xF0, 0xA7, 0x99, 0xA1 },
	0xBCAF, { 0xF0, 0xA7, 0x99, 0xA3 },
	0xBCB0, { 0xF0, 0xA7, 0x99, 0xAB },
	0xBCB1, { 0xF0, 0xA7, 0x99, 0x9E },
	0xBCB2, { 0xF0, 0xA7, 0x98, 0xBE },
	0xBCB3, { 0xF0, 0xA7, 0x99, 0xA4 },
	0xBCB4, { 0xF0, 0xA7, 0x9A, 0xAD },
	0xBCB5, { 0xE4, 0x99, 0xBD },
	0xBCB6, { 0xF0, 0xA7, 0xA0, 0xA0 },
	0xBCB7, { 0xF0, 0xA7, 0xA3, 0x91 },
	0xBCB8, { 0xF0, 0xA7, 0xA3, 0x95 },
	0xBCB9, { 0xF0, 0xA7, 0xA6, 0xAE },
	0xBCBA, { 0xF0, 0xA7, 0xA6, 0xAF },
	0xBCBB, { 0xF0, 0xA7, 0xA6, 0x9F },
	0xBCBC, { 0xF0, 0xA7, 0xA6, 0xA8 },
	0xBCBD, { 0xF0, 0xA7, 0xA7, 0x8A },
	0xBCBE, { 0xF0, 0xA7, 0xAF, 0xA1 },
	0xBCBF, { 0xF0, 0xA7, 0xB0, 0xB9 },
	0xBCC0, { 0xF0, 0xA7, 0xB0, 0xB8 },
	0xBCC1, { 0xF0, 0xA7, 0xB0, 0xBB },
	0xBCC2, { 0xF0, 0xA7, 0xB2, 0xAD },
	0xBCC3, { 0xF0, 0xA7, 0xB2, 0xB5 },
	0xBCC4, { 0xF0, 0xA7, 0xB2, 0xAF },
	0xBCC5, { 0xF0, 0xA7, 0xB2, 0xB1 },
	0xBCC6, { 0xF0, 0xA7, 0xB2, 0xAE },
	0xBCC7, { 0xF0, 0xA7, 0xB2, 0xB4 },
	0xBCC8, { 0xF0, 0xA7, 0xB2, 0xB0 },
	0xBCC9, { 0xF0, 0xA7, 0xB5, 0x8B },
	0xBCCA, { 0xF0, 0xA7, 0xB5, 0x91 },
	0xBCCB, { 0xF0, 0xA7, 0xB5, 0x8C },
	0xBCCC, { 0xE4, 0x9D, 0xA9 },
	0xBCCD, { 0xF0, 0xA7, 0xB5, 0xA0 },
	0xBCCE, { 0xF0, 0xA7, 0xBA, 0xBE },
	0xBCCF, { 0xF0, 0xA7, 0xBA, 0xB9 },
	0xBCD0, { 0xF0, 0xA7, 0xBA, 0xB7 },
	0xBCD1, { 0xF0, 0xA7, 0xBA, 0xB6 },
	0xBCD2, { 0xE4, 0x9E, 0xA1 },
	0xBCD3, { 0xF0, 0xA7, 0xBA, 0xBD },
	0xBCD4, { 0xF0, 0xA7, 0xBA, 0xB8 },
	0xBCD5, { 0xF0, 0xA7, 0xBB, 0x81 },
	0xBCD6, { 0xF0, 0xA7, 0xBF, 0xB7 },
	0xBCD7, { 0xF0, 0xA7, 0xBF, 0xB3 },
	0xBCD8, { 0xF0, 0xA7, 0xBF, 0xB4 },
	0xBCD9, { 0xF0, 0xA7, 0xBF, 0xBB },
	0xBCDA, { 0xF0, 0xA7, 0xBF, 0xBD },
	0xBCDB, { 0xF0, 0xA7, 0xBF, 0xB5 },
	0xBCDC, { 0xE4, 0x9F, 0xA7 },
	0xBCDD, { 0xF0, 0xA7, 0xBF, 0xBA },
	0xBCDE, { 0xF0, 0xA8, 0x80, 0x94 },
	0xBCDF, { 0xE4, 0x9F, 0xAC },
	0xBCE0, { 0xF0, 0xA7, 0xBF, 0xB2 },
	0xBCE1, { 0xF0, 0xA7, 0xBF, 0xBC },
	0xBCE2, { 0xF0, 0xA8, 0x80, 0x80 },
	0xBCE3, { 0xE4, 0x9F, 0x9F },
	0xBCE4, { 0xF0, 0xA8, 0x88, 0xAB },
	0xBCE5, { 0xF0, 0xA8, 0x88, 0xA9 },
	0xBCE6, { 0xF0, 0xA8, 0x88, 0xAE },
	0xBCE7, { 0xE4, 0xA0, 0xB3 },
	0xBCE8, { 0xF0, 0xA8, 0x8B, 0x97 },
	0xBCE9, { 0xF0, 0xA8, 0x8B, 0x9B },
	0xBCEA, { 0xF0, 0xA8, 0x8B, 0x99 },
	0xBCEB, { 0xF0, 0xA8, 0x8B, 0x98 },
	0xBCEC, { 0xF0, 0xA8, 0x8B, 0xA6 },
	0xBCED, { 0xF0, 0xA8, 0x8B, 0x96 },
	0xBCEE, { 0xF0, 0xA8, 0x8B, 0x91 },
	0xBCEF, { 0xF0, 0xA8, 0x8B, 0xA7 },
	0xBCF0, { 0xF0, 0xA8, 0x8B, 0x90 },
	0xBCF1, { 0xF0, 0xA8, 0x8B, 0x9C },
	0xBCF2, { 0xF0, 0xA8, 0x93, 0xAD },
	0xBCF3, { 0xF0, 0xA8, 0x94, 0x9A },
	0xBCF4, { 0xF0, 0xA8, 0x94, 0x99 },
	0xBCF5, { 0xF0, 0xA8, 0x94, 0x96 },
	0xBCF6, { 0xF0, 0xA8, 0x93, 0xAC },
	0xBCF7, { 0xF0, 0xA8, 0x93, 0xAF },
	0xBCF8, { 0xF0, 0xA8, 0x93, 0xAE },
	0xBCF9, { 0xF0, 0xA8, 0x93, 0xB4 },
	0xBCFA, { 0xF0, 0xA8, 0x94, 0xAF },
	0xBCFB, { 0xF0, 0xA8, 0x9C, 0xB0 },
	0xBCFC, { 0xF0, 0xA8, 0x9C, 0x99 },
	0xBCFD, { 0xF0, 0xA8, 0x9C, 0x98 },
	0xBCFE, { 0xF0, 0xA8, 0x9C, 0x91 },
	0xBDA1, { 0xF0, 0xA8, 0x9C, 0x96 },
	0xBDA2, { 0xF0, 0xA8, 0x9C, 0x92 },
	0xBDA3, { 0xF0, 0xA8, 0x9C, 0x90 },
	0xBDA4, { 0xF0, 0xA8, 0x9C, 0x94 },
	0xBDA5, { 0xF0, 0xA8, 0xA0, 0x8C },
	0xBDA6, { 0xF0, 0xA8, 0xA0, 0x8D },
	0xBDA7, { 0xF0, 0xA8, 0xA4, 0x90 },
	0xBDA8, { 0xF0, 0xA8, 0xA4, 0xA9 },
	0xBDA9, { 0xF0, 0xA8, 0xA4, 0xA8 },
	0xBDAA, { 0xF0, 0xA8, 0xB1, 0xA5 },
	0xBDAB, { 0xF0, 0xA8, 0xB1, 0xA6 },
	0xBDAC, { 0xF0, 0xA8, 0xB3, 0x9E },
	0xBDAD, { 0xF0, 0xA8, 0xB3, 0x9F },
	0xBDAE, { 0xF0, 0xA8, 0xB3, 0xA0 },
	0xBDAF, { 0xF0, 0xA8, 0xB3, 0x99 },
	0xBDB0, { 0xF0, 0xA8, 0xB3, 0x9B },
	0xBDB1, { 0xF0, 0xA8, 0xB3, 0x98 },
	0xBDB2, { 0xF0, 0xA8, 0xB3, 0xA3 },
	0xBDB3, { 0xF0, 0xA8, 0xB3, 0x97 },
	0xBDB4, { 0xF0, 0xA8, 0xBA, 0xA6 },
	0xBDB5, { 0xF0, 0xA8, 0xBA, 0xA7 },
	0xBDB6, { 0xF0, 0xA8, 0xBA, 0xBF },
	0xBDB7, { 0xF0, 0xA8, 0xBA, 0xA8 },
	0xBDB8, { 0xF0, 0xA8, 0xBA, 0x9F },
	0xBDB9, { 0xF0, 0xA8, 0xBA, 0xA1 },
	0xBDBA, { 0xF0, 0xA8, 0xBA, 0xA2 },
	0xBDBB, { 0xF0, 0xA8, 0xBA, 0xAD },
	0xBDBC, { 0xF0, 0xA8, 0xBA, 0xA3 },
	0xBDBD, { 0xF0, 0xA8, 0xBA, 0xA0 },
	0xBDBE, { 0xF0, 0xA9, 0x82, 0x83 },
	0xBDBF, { 0xF0, 0xA9, 0x82, 0x85 },
	0xBDC0, { 0xF0, 0xA9, 0x82, 0x82 },
	0xBDC1, { 0xF0, 0xA9, 0x82, 0x84 },
	0xBDC2, { 0xF0, 0xA9, 0x87, 0xAE },
	0xBDC3, { 0xF0, 0xA9, 0x89, 0x9D },
	0xBDC4, { 0xF0, 0xA9, 0x8E, 0x92 },
	0xBDC5, { 0xF0, 0xA9, 0x91, 0x95 },
	0xBDC6, { 0xF0, 0xA9, 0x91, 0x93 },
	0xBDC7, { 0xF0, 0xAF, 0xA7, 0xBC },
	0xBDC8, { 0xF0, 0xA9, 0x91, 0x91 },
	0xBDC9, { 0xF0, 0xA9, 0x91, 0x92 },
	0xBDCA, { 0xF0, 0xA9, 0x91, 0x90 },
	0xBDCB, { 0xF0, 0xA9, 0x96, 0x9D },
	0xBDCC, { 0xF0, 0xA9, 0x9A, 0x87 },
	0xBDCD, { 0xF0, 0xA9, 0x9A, 0x97 },
	0xBDCE, { 0xF0, 0xA9, 0x9A, 0x9B },
	0xBDCF, { 0xF0, 0xA9, 0x9A, 0x9D },
	0xBDD0, { 0xF0, 0xA9, 0xA1, 0xA9 },
	0xBDD1, { 0xF0, 0xA9, 0xA8, 0x91 },
	0xBDD2, { 0xE4, 0xAF, 0xAE },
	0xBDD3, { 0xF0, 0xA9, 0xB1, 0xBA },
	0xBDD4, { 0xE4, 0xB0, 0xB2 },
	0xBDD5, { 0xF0, 0xA3, 0x89, 0x84 },
	0xBDD6, { 0xF0, 0xA0, 0x83, 0x86 },
	0xBDD7, { 0xF0, 0xA0, 0x8D, 0x80 },
	0xBDD8, { 0xF0, 0xA0, 0x8C, 0xAE },
	0xBDD9, { 0xF0, 0xA0, 0x8D, 0xA8 },
	0xBDDA, { 0xF0, 0xA0, 0x8C, 0xAD },
	0xBDDB, { 0xF0, 0xA0, 0x8C, 0xB4 },
	0xBDDC, { 0xF0, 0xA0, 0x8C, 0xB2 },
	0xBDDD, { 0xF0, 0xA0, 0x8D, 0xA9 },
	0xBDDE, { 0xF0, 0xA0, 0x8C, 0xB1 },
	0xBDDF, { 0xF0, 0xA0, 0x8D, 0xAA },
	0xBDE0, { 0xF0, 0xA0, 0x8C, 0xBE },
	0xBDE1, { 0xF0, 0xA0, 0x8D, 0xAF },
	0xBDE2, { 0xF0, 0xA0, 0x8D, 0xB5 },
	0xBDE3, { 0xF0, 0xA0, 0x93, 0xB6 },
	0xBDE4, { 0xF0, 0xA0, 0x94, 0xA0 },
	0xBDE5, { 0xF0, 0xA0, 0x94, 0xA8 },
	0xBDE6, { 0xF0, 0xA0, 0x95, 0xA7 },
	0xBDE7, { 0xF0, 0xA0, 0x97, 0xBB },
	0xBDE8, { 0xF0, 0xA0, 0x97, 0xBE },
	0xBDE9, { 0xF0, 0xA0, 0x97, 0xBC },
	0xBDEA, { 0xF0, 0xA0, 0x97, 0xBD },
	0xBDEB, { 0xF0, 0xA0, 0x97, 0xBF },
	0xBDEC, { 0xF0, 0xA0, 0x97, 0xBA },
	0xBDED, { 0xF0, 0xA0, 0x9E, 0xAC },
	0xBDEE, { 0xF0, 0xA0, 0x9E, 0xAF },
	0xBDEF, { 0xF0, 0xA0, 0x9E, 0xB1 },
	0xBDF0, { 0xE3, 0x93, 0xBC },
	0xBDF1, { 0xF0, 0xA0, 0x9E, 0xBF },
	0xBDF2, { 0xF0, 0xA0, 0x9E, 0xBE },
	0xBDF3, { 0xF0, 0xA0, 0x9E, 0xA7 },
	0xBDF4, { 0xF0, 0xA0, 0x9E, 0xAA },
	0xBDF5, { 0xF0, 0xA0, 0xA2, 0x94 },
	0xBDF6, { 0xF0, 0xA0, 0xA2, 0x93 },
	0xBDF7, { 0xF0, 0xA0, 0xA2, 0x99 },
	0xBDF8, { 0xE3, 0x94, 0xAA },
	0xBDF9, { 0xF0, 0xA0, 0xA3, 0xBA },
	0xBDFA, { 0xF0, 0xA0, 0xA5, 0x96 },
	0xBDFB, { 0xF0, 0xA0, 0xA8, 0xA2 },
	0xBDFC, { 0xF0, 0xA0, 0xAA, 0x91 },
	0xBDFD, { 0xF0, 0xA0, 0xAA, 0x92 },
	0xBDFE, { 0xF0, 0xA0, 0xAC, 0x88 },
	0xBEA1, { 0xF0, 0xA0, 0xAC, 0x86 },
	0xBEA2, { 0xF0, 0xA0, 0xB7, 0x96 },
	0xBEA3, { 0xF0, 0xA0, 0xB8, 0xB7 },
	0xBEA4, { 0xF0, 0xA0, 0xB9, 0x8B },
	0xBEA5, { 0xF0, 0xA0, 0xBB, 0x8E },
	0xBEA6, { 0xF0, 0xA0, 0xBB, 0x90 },
	0xBEA7, { 0xF0, 0xA0, 0xB8, 0xB9 },
	0xBEA8, { 0xF0, 0xA0, 0xB9, 0xA4 },
	0xBEA9, { 0xF0, 0xA0, 0xBB, 0x8F },
	0xBEAA, { 0xF0, 0xA0, 0xB9, 0x86 },
	0xBEAB, { 0xF0, 0xA0, 0xB9, 0xA6 },
	0xBEAC, { 0xF0, 0xA0, 0xB9, 0x96 },
	0xBEAD, { 0xF0, 0xA0, 0xB9, 0x83 },
	0xBEAE, { 0xF0, 0xA0, 0xB9, 0x8A },
	0xBEAF, { 0xF0, 0xA0, 0xB9, 0x98 },
	0xBEB0, { 0xF0, 0xA0, 0xB9, 0xA5 },
	0xBEB1, { 0xF0, 0xA0, 0xB9, 0x9A },
	0xBEB2, { 0xF0, 0xA0, 0xB9, 0x9B },
	0xBEB3, { 0xF0, 0xA0, 0xB9, 0x95 },
	0xBEB4, { 0xF0, 0xA0, 0xB9, 0x90 },
	0xBEB5, { 0xF0, 0xA0, 0xB9, 0x8C },
	0xBEB6, { 0xF0, 0xA0, 0xBB, 0x8D },
	0xBEB7, { 0xF0, 0xA0, 0xB9, 0x91 },
	0xBEB8, { 0xF0, 0xA0, 0xB9, 0x87 },
	0xBEB9, { 0xE3, 0x97, 0x93 },
	0xBEBA, { 0xF0, 0xA0, 0xB9, 0x93 },
	0xBEBB, { 0xF0, 0xA0, 0xB9, 0xA2 },
	0xBEBC, { 0xF0, 0xA0, 0xBB, 0x8C },
	0xBEBD, { 0xE3, 0x97, 0x97 },
	0xBEBE, { 0xF0, 0xA0, 0xB9, 0xBF },
	0xBEBF, { 0xF0, 0xA0, 0xB9, 0x8D },
	0xBEC0, { 0xF0, 0xA1, 0x88, 0x8A },
	0xBEC1, { 0xF0, 0xA1, 0x88, 0x8C },
	0xBEC2, { 0xF0, 0xA1, 0x88, 0x8F },
	0xBEC3, { 0xF0, 0xA1, 0x8E, 0xBB },
	0xBEC4, { 0xF0, 0xA1, 0x8E, 0xB9 },
	0xBEC5, { 0xF0, 0xA1, 0x8F, 0xAB },
	0xBEC6, { 0xF0, 0xA1, 0x8E, 0xAE },
	0xBEC7, { 0xF0, 0xA1, 0x8F, 0x81 },
	0xBEC8, { 0xF0, 0xA1, 0x8F, 0xAA },
	0xBEC9, { 0xF0, 0xA1, 0x8E, 0xBE },
	0xBECA, { 0xF0, 0xA1, 0x8E, 0xBF },
	0xBECB, { 0xF0, 0xA1, 0x8E, 0xBA },
	0xBECC, { 0xF0, 0xA1, 0x8E, 0xB7 },
	0xBECD, { 0xF0, 0xA1, 0x8E, 0xB3 },
	0xBECE, { 0xF0, 0xA1, 0x8F, 0xA9 },
	0xBECF, { 0xF0, 0xA1, 0x95, 0xAE },
	0xBED0, { 0xF0, 0xA1, 0x96, 0xAF },
	0xBED1, { 0xF0, 0xA1, 0x96, 0xB3 },
	0xBED2, { 0xF0, 0xA1, 0x96, 0xB2 },
	0xBED3, { 0xF0, 0xA1, 0x99, 0xA8 },
	0xBED4, { 0xF0, 0xA1, 0x99, 0xA9 },
	0xBED5, { 0xF0, 0xA1, 0x99, 0xAA },
	0xBED6, { 0xF0, 0xA1, 0x9F, 0x9E },
	0xBED7, { 0xF0, 0xA1, 0x9F, 0xAB },
	0xBED8, { 0xF0, 0xA1, 0xA0, 0x91 },
	0xBED9, { 0xF0, 0xA1, 0x9F, 0xAD },
	0xBEDA, { 0xF0, 0xA1, 0x9F, 0xA9 },
	0xBEDB, { 0xF0, 0xA1, 0x9F, 0xB7 },
	0xBEDC, { 0xF0, 0xA1, 0x9F, 0xB4 },
	0xBEDD, { 0xF0, 0xA1, 0x9F, 0xAA },
	0xBEDE, { 0xF0, 0xA1, 0xA0, 0x92 },
	0xBEDF, { 0xF0, 0xA1, 0x9F, 0xA8 },
	0xBEE0, { 0xF0, 0xA1, 0xA0, 0x93 },
	0xBEE1, { 0xF0, 0xA1, 0xA6, 0x8E },
	0xBEE2, { 0xF0, 0xA1, 0xA6, 0x86 },
	0xBEE3, { 0xF0, 0xA1, 0xA9, 0xA3 },
	0xBEE4, { 0xF0, 0xA1, 0xA9, 0xA5 },
	0xBEE5, { 0xF0, 0xA1, 0xAE, 0x99 },
	0xBEE6, { 0xF0, 0xA1, 0xB3, 0x82 },
	0xBEE7, { 0xF0, 0xA1, 0xB2, 0xAE },
	0xBEE8, { 0xF0, 0xA1, 0xB2, 0xB0 },
	0xBEE9, { 0xF0, 0xA1, 0xB2, 0xAD },
	0xBEEA, { 0xF0, 0xA1, 0xBA, 0xB4 },
	0xBEEB, { 0xF0, 0xA1, 0xBB, 0x91 },
	0xBEEC, { 0xF0, 0xA1, 0xBA, 0xAD },
	0xBEED, { 0xE3, 0x9F, 0xB3 },
	0xBEEE, { 0xF0, 0xA1, 0xBA, 0xBD },
	0xBEEF, { 0xF0, 0xA1, 0xBA, 0xB7 },
	0xBEF0, { 0xF0, 0xA1, 0xBA, 0xAB },
	0xBEF1, { 0xF0, 0xA1, 0xBA, 0xAF },
	0xBEF2, { 0xF0, 0xA1, 0xBB, 0x81 },
	0xBEF3, { 0xF0, 0xA1, 0xBA, 0xB5 },
	0xBEF4, { 0xF0, 0xA2, 0x84, 0x8F },
	0xBEF5, { 0xF0, 0xA2, 0x84, 0x8E },
	0xBEF6, { 0xF0, 0xA2, 0x84, 0x9C },
	0xBEF7, { 0xF0, 0xA2, 0x84, 0x93 },
	0xBEF8, { 0xF0, 0xA2, 0x84, 0x8A },
	0xBEF9, { 0xF0, 0xA2, 0x84, 0x9E },
	0xBEFA, { 0xF0, 0xA2, 0x84, 0x94 },
	0xBEFB, { 0xF0, 0xA2, 0x84, 0x9A },
	0xBEFC, { 0xF0, 0xA2, 0x87, 0x8B },
	0xBEFD, { 0xF0, 0xA2, 0x8A, 0x87 },
	0xBEFE, { 0xF0, 0xA2, 0x8A, 0x93 },
	0xBFA1, { 0xE3, 0xA2, 0x91 },
	0xBFA2, { 0xF0, 0xA2, 0x8A, 0x84 },
	0xBFA3, { 0xF0, 0xA2, 0x8A, 0x85 },
	0xBFA4, { 0xF0, 0xA2, 0x8A, 0x92 },
	0xBFA5, { 0xF0, 0xA2, 0x8A, 0x80 },
	0xBFA6, { 0xF0, 0xA2, 0x8C, 0xAB },
	0xBFA7, { 0xF0, 0xA2, 0x8D, 0xA3 },
	0xBFA8, { 0xF0, 0xA2, 0x90, 0x8A },
	0xBFA9, { 0xE3, 0xA3, 0x80 },
	0xBFAA, { 0xF0, 0xA2, 0x91, 0xA6 },
	0xBFAB, { 0xF0, 0xA2, 0x94, 0xB4 },
	0xBFAC, { 0xF0, 0xA2, 0x94, 0xB3 },
	0xBFAD, { 0xF0, 0xA2, 0x95, 0x8D },
	0xBFAE, { 0xF0, 0xA2, 0x9E, 0x89 },
	0xBFAF, { 0xF0, 0xA2, 0x9D, 0x97 },
	0xBFB0, { 0xE6, 0x84, 0x97 },
	0xBFB1, { 0xF0, 0xA2, 0x9D, 0x8A },
	0xBFB2, { 0xE3, 0xA5, 0xA3 },
	0xBFB3, { 0xF0, 0xA2, 0x9C, 0xB9 },
	0xBFB4, { 0xF0, 0xA2, 0x9C, 0xBF },
	0xBFB5, { 0xF0, 0xA2, 0x9E, 0x90 },
	0xBFB6, { 0xF0, 0xA2, 0x9E, 0x8F },
	0xBFB7, { 0xF0, 0xA2, 0x9E, 0xB2 },
	0xBFB8, { 0xF0, 0xA2, 0x9E, 0x9F },
	0xBFB9, { 0xF0, 0xA2, 0x9E, 0x95 },
	0xBFBA, { 0xF0, 0xA2, 0x9E, 0xA1 },
	0xBFBB, { 0xF0, 0xA2, 0x9E, 0x9C },
	0xBFBC, { 0xF0, 0xA2, 0x9E, 0x8E },
	0xBFBD, { 0xF0, 0xA2, 0x9E, 0xA0 },
	0xBFBE, { 0xF0, 0xA2, 0x9E, 0xAE },
	0xBFBF, { 0xF0, 0xA2, 0x9E, 0x96 },
	0xBFC0, { 0xF0, 0xA2, 0x9F, 0x8A },
	0xBFC1, { 0xF0, 0xA2, 0x9E, 0xAC },
	0xBFC2, { 0xE3, 0xA5, 0xB0 },
	0xBFC3, { 0xF0, 0xA2, 0x9E, 0xA6 },
	0xBFC4, { 0xF0, 0xA2, 0x9E, 0x97 },
	0xBFC5, { 0xF0, 0xA2, 0x9E, 0x93 },
	0xBFC6, { 0xF0, 0xA0, 0x8E, 0xB6 },
	0xBFC7, { 0xF0, 0xA2, 0xA7, 0x96 },
	0xBFC8, { 0xF0, 0xA2, 0xA7, 0xA0 },
	0xBFC9, { 0xF0, 0xA2, 0xA7, 0x98 },
	0xBFCA, { 0xF0, 0xA2, 0xA9, 0x96 },
	0xBFCB, { 0xF0, 0xA2, 0xB1, 0xAE },
	0xBFCC, { 0xF0, 0xA2, 0xB1, 0xBE },
	0xBFCD, { 0xF0, 0xA2, 0xB1, 0xB4 },
	0xBFCE, { 0xF0, 0xA2, 0xB1, 0xB7 },
	0xBFCF, { 0xF0, 0xA2, 0xB2, 0x80 },
	0xBFD0, { 0xF0, 0xA2, 0xB1, 0xBA },
	0xBFD1, { 0xF0, 0xA2, 0xB1, 0xAB },
	0xBFD2, { 0xF0, 0xA2, 0xB1, 0x9F },
	0xBFD3, { 0xF0, 0xA2, 0xB1, 0xB6 },
	0xBFD4, { 0xF0, 0xA2, 0xB2, 0xB0 },
	0xBFD5, { 0xF0, 0xA2, 0xB1, 0xA3 },
	0xBFD6, { 0xF0, 0xA2, 0xBE, 0x92 },
	0xBFD7, { 0xF0, 0xA2, 0xBE, 0x82 },
	0xBFD8, { 0xF0, 0xA2, 0xBE, 0x9D },
	0xBFD9, { 0xF0, 0xA2, 0xBE, 0x94 },
	0xBFDA, { 0xF0, 0xA2, 0xBE, 0x83 },
	0xBFDB, { 0xF0, 0xA2, 0xBE, 0x8B },
	0xBFDC, { 0xF0, 0xA2, 0xBE, 0x84 },
	0xBFDD, { 0xF0, 0xA3, 0x81, 0x97 },
	0xBFDE, { 0xF0, 0xA3, 0x82, 0x84 },
	0xBFDF, { 0xF0, 0xA3, 0x82, 0xB5 },
	0xBFE0, { 0xF0, 0xA3, 0x84, 0x89 },
	0xBFE1, { 0xF0, 0xA3, 0x87, 0xA6 },
	0xBFE2, { 0xE3, 0xAC, 0x82 },
	0xBFE3, { 0xF0, 0xA3, 0x88, 0xA5 },
	0xBFE4, { 0xF0, 0xA3, 0x89, 0x91 },
	0xBFE5, { 0xF0, 0xA3, 0x8C, 0xBE },
	0xBFE6, { 0xF0, 0xAF, 0xA3, 0x9A },
	0xBFE7, { 0xF0, 0xA3, 0x8E, 0x85 },
	0xBFE8, { 0xF0, 0xA3, 0x94, 0xBF },
	0xBFE9, { 0xF0, 0xA3, 0x95, 0x82 },
	0xBFEA, { 0xF0, 0xA3, 0x94, 0xB8 },
	0xBFEB, { 0xF0, 0xA3, 0x94, 0xBA },
	0xBFEC, { 0xF0, 0xA3, 0x95, 0x8E },
	0xBFED, { 0xF0, 0xA3, 0x95, 0x85 },
	0xBFEE, { 0xF0, 0xA3, 0x94, 0xB9 },
	0xBFEF, { 0xF0, 0xA3, 0x94, 0xB7 },
	0xBFF0, { 0xF0, 0xA3, 0x95, 0x84 },
	0xBFF1, { 0xF0, 0xAF, 0xA3, 0xA7 },
	0xBFF2, { 0xF0, 0xA3, 0x96, 0xA4 },
	0xBFF3, { 0xF0, 0xA3, 0x94, 0xBD },
	0xBFF4, { 0xF0, 0xA3, 0x95, 0x81 },
	0xBFF5, { 0xF0, 0xA3, 0xA3, 0x9F },
	0xBFF6, { 0xF0, 0xA3, 0xA3, 0x9E },
	0xBFF7, { 0xF0, 0xA3, 0xA3, 0x8A },
	0xBFF8, { 0xF0, 0xA3, 0xA3, 0xA9 },
	0xBFF9, { 0xF0, 0xA3, 0xA3, 0xA2 },
	0xBFFA, { 0xF0, 0xA3, 0xA3, 0xA0 },
	0xBFFB, { 0xF0, 0xA3, 0xA6, 0x89 },
	0xBFFC, { 0xF0, 0xA3, 0xA6, 0x87 },
	0xBFFD, { 0xF0, 0xA3, 0xA8, 0xB2 },
	0xBFFE, { 0xF0, 0xA3, 0xA8, 0xB3 },
	0xC0A1, { 0xF0, 0xA3, 0xAA, 0xAC },
	0xC0A2, { 0xF0, 0xA3, 0xAB, 0xB9 },
	0xC0A3, { 0xF0, 0xA3, 0xAC, 0x8D },
	0xC0A4, { 0xF0, 0xA3, 0xAE, 0xB9 },
	0xC0A5, { 0xF0, 0xA3, 0xB9, 0x9E },
	0xC0A6, { 0xF0, 0xA3, 0xB9, 0xAA },
	0xC0A7, { 0xE3, 0xB4, 0xB5 },
	0xC0A8, { 0xF0, 0xA3, 0xBA, 0x81 },
	0xC0A9, { 0xF0, 0xA3, 0xB9, 0xA9 },
	0xC0AA, { 0xF0, 0xA3, 0xBA, 0xAC },
	0xC0AB, { 0xF0, 0xA3, 0xBA, 0x80 },
	0xC0AC, { 0xF0, 0xA3, 0xB9, 0xB5 },
	0xC0AD, { 0xF0, 0xA3, 0xB9, 0xB1 },
	0xC0AE, { 0xF0, 0xA3, 0xB9, 0xB6 },
	0xC0AF, { 0xF0, 0xA3, 0xB9, 0xAF },
	0xC0B0, { 0xF0, 0xA4, 0x8A, 0xB6 },
	0xC0B1, { 0xF0, 0xA4, 0x8C, 0x83 },
	0xC0B2, { 0xF0, 0xA4, 0x8A, 0xBF },
	0xC0B3, { 0xF0, 0xA4, 0x8C, 0x81 },
	0xC0B4, { 0xF0, 0xA4, 0x8A, 0xB2 },
	0xC0B5, { 0xF0, 0xA4, 0x8B, 0x84 },
	0xC0B6, { 0xF0, 0xA4, 0x97, 0x9B },
	0xC0B7, { 0xF0, 0xA4, 0x97, 0x9C },
	0xC0B8, { 0xF0, 0xA4, 0x97, 0x98 },
	0xC0B9, { 0xF0, 0xA9, 0x99, 0xB2 },
	0xC0BA, { 0xF0, 0xA4, 0x9A, 0xB5 },
	0xC0BB, { 0xF0, 0xA4, 0x9A, 0xA8 },
	0xC0BC, { 0xF0, 0xA4, 0x9A, 0x8F },
	0xC0BD, { 0xF0, 0xA4, 0x9A, 0x9E },
	0xC0BE, { 0xF0, 0xA4, 0x9A, 0x8E },
	0xC0BF, { 0xF0, 0xA4, 0x9F, 0x9E },
	0xC0C0, { 0xF0, 0xA4, 0x9F, 0xA2 },
	0xC0C1, { 0xF0, 0xA4, 0xA0, 0xA0 },
	0xC0C2, { 0xF0, 0xA4, 0xA0, 0x9D },
	0xC0C3, { 0xF0, 0xA4, 0xA0, 0x9A },
	0xC0C4, { 0xF0, 0xA4, 0xA0, 0x99 },
	0xC0C5, { 0xF0, 0xA4, 0xA0, 0xAB },
	0xC0C6, { 0xF0, 0xA4, 0xA0, 0x98 },
	0xC0C7, { 0xF0, 0xA4, 0xA0, 0x90 },
	0xC0C8, { 0xF0, 0xA4, 0xA0, 0x8E },
	0xC0C9, { 0xF0, 0xA4, 0xA0, 0xA4 },
	0xC0CA, { 0xF0, 0xA4, 0xA0, 0x9F },
	0xC0CB, { 0xF0, 0xA4, 0xA0, 0x93 },
	0xC0CC, { 0xF0, 0xA4, 0xA0, 0xB5 },
	0xC0CD, { 0xF0, 0xA4, 0xA6, 0x83 },
	0xC0CE, { 0xE3, 0xBB, 0xA0 },
	0xC0CF, { 0xF0, 0xA4, 0xA7, 0x97 },
	0xC0D0, { 0xF0, 0xA4, 0xAC, 0x82 },
	0xC0D1, { 0xF0, 0xA4, 0xAC, 0x83 },
	0xC0D2, { 0xF0, 0xA4, 0xAD, 0x9C },
	0xC0D3, { 0xF0, 0xA4, 0xAD, 0x9F },
	0xC0D4, { 0xF0, 0xA4, 0xAF, 0x87 },
	0xC0D5, { 0xF0, 0xA4, 0xB2, 0x9A },
	0xC0D6, { 0xF0, 0xA4, 0xB2, 0x97 },
	0xC0D7, { 0xF0, 0xA4, 0xB2, 0xA3 },
	0xC0D8, { 0xF0, 0xA4, 0xB7, 0xB7 },
	0xC0D9, { 0xF0, 0xA4, 0xB7, 0x86 },
	0xC0DA, { 0xF0, 0xA4, 0xB7, 0x8C },
	0xC0DB, { 0xF0, 0xA4, 0xB7, 0x96 },
	0xC0DC, { 0xF0, 0xA4, 0xB7, 0x8D },
	0xC0DD, { 0xF0, 0xA4, 0xB7, 0xB9 },
	0xC0DE, { 0xF0, 0xA4, 0xB7, 0x99 },
	0xC0DF, { 0xF0, 0xA4, 0xB7, 0x98 },
	0xC0E0, { 0xE3, 0xBE, 0x9A },
	0xC0E1, { 0xF0, 0xA4, 0xB7, 0x91 },
	0xC0E2, { 0xF0, 0xA4, 0xB7, 0x8E },
	0xC0E3, { 0xF0, 0xA4, 0xB7, 0x95 },
	0xC0E4, { 0xE3, 0xBE, 0xA3 },
	0xC0E5, { 0xF0, 0xA4, 0xB7, 0x94 },
	0xC0E6, { 0xF0, 0xA4, 0xB7, 0xB8 },
	0xC0E7, { 0xF0, 0xA4, 0xBD, 0xBA },
	0xC0E8, { 0xF0, 0xA4, 0xBD, 0xB9 },
	0xC0E9, { 0xF0, 0xA4, 0xBD, 0xBF },
	0xC0EA, { 0xF0, 0xA4, 0xBF, 0xB3 },
	0xC0EB, { 0xF0, 0xA4, 0xBF, 0xB5 },
	0xC0EC, { 0xF0, 0xA4, 0xBF, 0xB6 },
	0xC0ED, { 0xF0, 0xA4, 0xBF, 0xB4 },
	0xC0EE, { 0xF0, 0xA4, 0xBF, 0xB7 },
	0xC0EF, { 0xE4, 0x80, 0x85 },
	0xC0F0, { 0xF0, 0xA5, 0x81, 0xB9 },
	0xC0F1, { 0xF0, 0xA5, 0x86, 0x9C },
	0xC0F2, { 0xF0, 0xA5, 0x87, 0x9F },
	0xC0F3, { 0xF0, 0xA5, 0x87, 0xB5 },
	0xC0F4, { 0xF0, 0xA5, 0x87, 0xBF },
	0xC0F5, { 0xF0, 0xA5, 0x87, 0x91 },
	0xC0F6, { 0xF0, 0xA5, 0x87, 0x9A },
	0xC0F7, { 0xF0, 0xA5, 0x87, 0x8F },
	0xC0F8, { 0xF0, 0xA5, 0x87, 0x8D },
	0xC0F9, { 0xF0, 0xA5, 0x87, 0x9E },
	0xC0FA, { 0xF0, 0xA5, 0x87, 0x98 },
	0xC0FB, { 0xF0, 0xA3, 0xAA, 0xAD },
	0xC0FC, { 0xF0, 0xA5, 0x87, 0xA0 },
	0xC0FD, { 0xF0, 0xA5, 0x87, 0xBE },
	0xC0FE, { 0xF0, 0xA5, 0x86, 0x9E },
	0xC1A1, { 0xF0, 0xA5, 0x8D, 0xB5 },
	0xC1A2, { 0xF0, 0xA5, 0x8D, 0xB3 },
	0xC1A3, { 0xF0, 0xA5, 0x8D, 0xB2 },
	0xC1A4, { 0xF0, 0xA5, 0x8F, 0x98 },
	0xC1A5, { 0xF0, 0xA5, 0x93, 0x90 },
	0xC1A6, { 0xF0, 0xA5, 0x93, 0x96 },
	0xC1A7, { 0xF0, 0xA5, 0x93, 0x97 },
	0xC1A8, { 0xF0, 0xA5, 0x93, 0x8A },
	0xC1A9, { 0xF0, 0xA5, 0x93, 0x8D },
	0xC1AA, { 0xF0, 0xA5, 0x9A, 0x8A },
	0xC1AB, { 0xF0, 0xA5, 0x9A, 0x89 },
	0xC1AC, { 0xF0, 0xA5, 0x9A, 0x8B },
	0xC1AD, { 0xF0, 0xA5, 0x9F, 0x93 },
	0xC1AE, { 0xF0, 0xA5, 0x9F, 0x9A },
	0xC1AF, { 0xF0, 0xA5, 0x9F, 0x8E },
	0xC1B0, { 0xF0, 0xA5, 0x9F, 0x92 },
	0xC1B1, { 0xE4, 0x85, 0x9E },
	0xC1B2, { 0xF0, 0xA5, 0x9F, 0x94 },
	0xC1B3, { 0xF0, 0xA5, 0x9F, 0x97 },
	0xC1B4, { 0xF0, 0xA5, 0x9F, 0x95 },
	0xC1B5, { 0xF0, 0xA5, 0x9F, 0xBB },
	0xC1B6, { 0xF0, 0xA5, 0x9F, 0x8D },
	0xC1B7, { 0xF0, 0xA5, 0x9F, 0xBA },
	0xC1B8, { 0xF0, 0xA5, 0x9F, 0x96 },
	0xC1B9, { 0xE4, 0x86, 0xA6 },
	0xC1BA, { 0xF0, 0xA5, 0xA6, 0x9B },
	0xC1BB, { 0xF0, 0xA5, 0xA6, 0x9E },
	0xC1BC, { 0xF0, 0xA5, 0xA6, 0x9D },
	0xC1BD, { 0xF0, 0xA5, 0xA6, 0xA4 },
	0xC1BE, { 0xF0, 0xA5, 0xA6, 0x9F },
	0xC1BF, { 0xF0, 0xA5, 0xA6, 0xA5 },
	0xC1C0, { 0xF0, 0xA5, 0xA6, 0xA8 },
	0xC1C1, { 0xF0, 0xA5, 0xAA, 0x8F },
	0xC1C2, { 0xF0, 0xA5, 0xAA, 0x8C },
	0xC1C3, { 0xF0, 0xA5, 0xAA, 0x95 },
	0xC1C4, { 0xF0, 0xA5, 0xAD, 0xA0 },
	0xC1C5, { 0xF0, 0xA5, 0xAD, 0x95 },
	0xC1C6, { 0xF0, 0xA5, 0xAD, 0x9C },
	0xC1C7, { 0xF0, 0xA5, 0xAD, 0xAF },
	0xC1C8, { 0xF0, 0xA5, 0xAD, 0x91 },
	0xC1C9, { 0xF0, 0xA5, 0xAD, 0xA1 },
	0xC1CA, { 0xF0, 0xA5, 0xAE, 0xA7 },
	0xC1CB, { 0xF0, 0xA5, 0xAD, 0x9E },
	0xC1CC, { 0xF0, 0xA5, 0xAD, 0xA2 },
	0xC1CD, { 0xF0, 0xA5, 0xAD, 0x94 },
	0xC1CE, { 0xF0, 0xA5, 0xAD, 0xAE },
	0xC1CF, { 0xF0, 0xA5, 0xAD, 0x92 },
	0xC1D0, { 0xF0, 0xA5, 0xAD, 0x98 },
	0xC1D1, { 0xF0, 0xA5, 0xAD, 0xAD },
	0xC1D2, { 0xF0, 0xA5, 0xAD, 0x9F },
	0xC1D3, { 0xF0, 0xA5, 0xAD, 0xAC },
	0xC1D4, { 0xF0, 0xA5, 0xAD, 0x90 },
	0xC1D5, { 0xF0, 0xA5, 0xAD, 0x9D },
	0xC1D6, { 0xF0, 0xA5, 0xAE, 0x8E },
	0xC1D7, { 0xF0, 0xA5, 0xB9, 0xB2 },
	0xC1D8, { 0xF0, 0xA5, 0xB9, 0xB8 },
	0xC1D9, { 0xF0, 0xA5, 0xB9, 0xB5 },
	0xC1DA, { 0xF0, 0xA5, 0xB9, 0xB6 },
	0xC1DB, { 0xF0, 0xA5, 0xB9, 0xBC },
	0xC1DC, { 0xF0, 0xA5, 0xB9, 0xBE },
	0xC1DD, { 0xF0, 0xA5, 0xB9, 0xBD },
	0xC1DE, { 0xF0, 0xA6, 0x80, 0x95 },
	0xC1DF, { 0xF0, 0xA6, 0x80, 0x94 },
	0xC1E0, { 0xF0, 0xA6, 0x80, 0x9D },
	0xC1E1, { 0xF0, 0xA6, 0x80, 0x9C },
	0xC1E2, { 0xF0, 0xA6, 0x80, 0xA3 },
	0xC1E3, { 0xF0, 0xA6, 0x81, 0x97 },
	0xC1E4, { 0xF0, 0xA6, 0x8B, 0x88 },
	0xC1E5, { 0xE4, 0x8D, 0x9D },
	0xC1E6, { 0xF0, 0xA6, 0x8B, 0x89 },
	0xC1E7, { 0xF0, 0xA6, 0x8B, 0x85 },
	0xC1E8, { 0xF0, 0xA6, 0x8E, 0x87 },
	0xC1E9, { 0xF0, 0xA6, 0x8E, 0x8A },
	0xC1EA, { 0xF0, 0xA6, 0x8E, 0x94 },
	0xC1EB, { 0xF0, 0xA6, 0x90, 0xB9 },
	0xC1EC, { 0xF0, 0xA6, 0x91, 0x80 },
	0xC1ED, { 0xF0, 0xA6, 0x90, 0xBE },
	0xC1EE, { 0xF0, 0xA6, 0x90, 0xB8 },
	0xC1EF, { 0xF0, 0xA6, 0x93, 0x96 },
	0xC1F0, { 0xE4, 0x8E, 0xB8 },
	0xC1F1, { 0xF0, 0xA6, 0x95, 0xB7 },
	0xC1F2, { 0xF0, 0xA6, 0x95, 0xB8 },
	0xC1F3, { 0xF0, 0xA6, 0x95, 0xBD },
	0xC1F4, { 0xF0, 0xA6, 0x9B, 0x9D },
	0xC1F5, { 0xF0, 0xA6, 0x9D, 0x9E },
	0xC1F6, { 0xF0, 0xA6, 0x9D, 0xB7 },
	0xC1F7, { 0xF0, 0xA6, 0x9F, 0x94 },
	0xC1F8, { 0xF0, 0xA6, 0x9D, 0xA6 },
	0xC1F9, { 0xF0, 0xA6, 0x9D, 0x9F },
	0xC1FA, { 0xF0, 0xA6, 0x9D, 0xB3 },
	0xC1FB, { 0xF0, 0xA6, 0x9D, 0xB2 },
	0xC1FC, { 0xF0, 0xA6, 0x9E, 0x97 },
	0xC1FD, { 0xF0, 0xA6, 0x9D, 0x9A },
	0xC1FE, { 0xF0, 0xA6, 0x9E, 0x96 },
	0xC2A1, { 0xF0, 0xA6, 0x9D, 0x9D },
	0xC2A2, { 0xF0, 0xA6, 0x9D, 0xA5 },
	0xC2A3, { 0xF0, 0xA6, 0x9D, 0xB0 },
	0xC2A4, { 0xF0, 0xA6, 0x9D, 0xB5 },
	0xC2A5, { 0xF0, 0xA6, 0x9D, 0xB4 },
	0xC2A6, { 0xF0, 0xA6, 0x9D, 0x9C },
	0xC2A7, { 0xF0, 0xA6, 0x9D, 0xA0 },
	0xC2A8, { 0xE4, 0x90, 0xB4 },
	0xC2A9, { 0xF0, 0xA6, 0x9D, 0xAD },
	0xC2AA, { 0xF0, 0xA6, 0xA5, 0x81 },
	0xC2AB, { 0xF0, 0xA6, 0xA8, 0xBC },
	0xC2AC, { 0xF0, 0xA6, 0xA8, 0xBE },
	0xC2AD, { 0xE4, 0x91, 0xAF },
	0xC2AE, { 0xF0, 0xA6, 0xA9, 0x89 },
	0xC2AF, { 0xF0, 0xA6, 0xAF, 0xA4 },
	0xC2B0, { 0xF0, 0xA6, 0xB4, 0x8C },
	0xC2B1, { 0xF0, 0xA6, 0xB4, 0x95 },
	0xC2B2, { 0xF0, 0xA6, 0xB4, 0x8E },
	0xC2B3, { 0xF0, 0xA6, 0xB3, 0x94 },
	0xC2B4, { 0xF0, 0xA6, 0xB3, 0x87 },
	0xC2B5, { 0xF0, 0xA6, 0xB4, 0x94 },
	0xC2B6, { 0xF0, 0xA6, 0xB3, 0x9B },
	0xC2B7, { 0xF0, 0xA6, 0xB5, 0x9F },
	0xC2B8, { 0xF0, 0xA6, 0xB3, 0xAD },
	0xC2B9, { 0xF0, 0xA6, 0xB4, 0x89 },
	0xC2BA, { 0xF0, 0xA6, 0xB3, 0x8F },
	0xC2BB, { 0xF0, 0xA6, 0xB3, 0xBF },
	0xC2BC, { 0xF0, 0xA6, 0xB4, 0x9A },
	0xC2BD, { 0xF0, 0xA6, 0xB3, 0xB5 },
	0xC2BE, { 0xF0, 0xA6, 0xB3, 0xAE },
	0xC2BF, { 0xF0, 0xA6, 0xB3, 0xA5 },
	0xC2C0, { 0xF0, 0xA6, 0xB4, 0x8D },
	0xC2C1, { 0xF0, 0xA6, 0xB3, 0x9F },
	0xC2C2, { 0xF0, 0xA6, 0xB3, 0xAC },
	0xC2C3, { 0xF0, 0xA6, 0xB3, 0x97 },
	0xC2C4, { 0xF0, 0xA6, 0xB4, 0xAC },
	0xC2C5, { 0xF0, 0xA6, 0xB3, 0x8D },
	0xC2C6, { 0xF0, 0xA6, 0xB3, 0xA3 },
	0xC2C7, { 0xF0, 0xA6, 0xB4, 0x80 },
	0xC2C8, { 0xF0, 0xA6, 0xB3, 0xAB },
	0xC2C9, { 0xF0, 0xA6, 0xB3, 0xBD },
	0xC2CA, { 0xF0, 0xA6, 0xB4, 0x8F },
	0xC2CB, { 0xF0, 0xA6, 0xB4, 0xAD },
	0xC2CC, { 0xF0, 0xA6, 0xB5, 0x90 },
	0xC2CD, { 0xF0, 0xA6, 0xB3, 0xBE },
	0xC2CE, { 0xF0, 0xA6, 0xB3, 0x84 },
	0xC2CF, { 0xF0, 0xA6, 0xB3, 0xA1 },
	0xC2D0, { 0xF0, 0xA6, 0xB3, 0xB9 },
	0xC2D1, { 0xF0, 0xA7, 0x86, 0xBB },
	0xC2D2, { 0xF0, 0xA7, 0x86, 0xBC },
	0xC2D3, { 0xE4, 0x96, 0x94 },
	0xC2D4, { 0xE4, 0x96, 0x93 },
	0xC2D5, { 0xF0, 0xA7, 0x86, 0xBA },
	0xC2D6, { 0xF0, 0xA7, 0x8B, 0x90 },
	0xC2D7, { 0xF0, 0xA7, 0x8B, 0x96 },
	0xC2D8, { 0xF0, 0xA7, 0x8B, 0x8E },
	0xC2D9, { 0xF0, 0xA7, 0x8B, 0xA1 },
	0xC2DA, { 0xF0, 0xA7, 0x8B, 0x95 },
	0xC2DB, { 0xF0, 0xA7, 0x8B, 0x8F },
	0xC2DC, { 0xF0, 0xA7, 0x8B, 0x93 },
	0xC2DD, { 0xE8, 0x9C, 0x94 },
	0xC2DE, { 0xF0, 0xA7, 0x8B, 0x94 },
	0xC2DF, { 0xF0, 0xA7, 0x96, 0xB5 },
	0xC2E0, { 0xF0, 0xA7, 0x9A, 0x90 },
	0xC2E1, { 0xF0, 0xA7, 0x9A, 0xA1 },
	0xC2E2, { 0xF0, 0xA7, 0x9A, 0x81 },
	0xC2E3, { 0xF0, 0xA7, 0x9A, 0x85 },
	0xC2E4, { 0xF0, 0xA7, 0x99, 0xAE },
	0xC2E5, { 0xF0, 0xA7, 0x9A, 0x88 },
	0xC2E6, { 0xF0, 0xA7, 0x9A, 0x82 },
	0xC2E7, { 0xF0, 0xA7, 0x9A, 0x86 },
	0xC2E8, { 0xF0, 0xA7, 0x9A, 0x8F },
	0xC2E9, { 0xF0, 0xA7, 0x9A, 0x89 },
	0xC2EA, { 0xF0, 0xA7, 0x9A, 0x80 },
	0xC2EB, { 0xF0, 0xA7, 0x9A, 0x84 },
	0xC2EC, { 0xE8, 0xA3, 0x91 },
	0xC2ED, { 0xF0, 0xA7, 0xA0, 0xA9 },
	0xC2EE, { 0xF0, 0xA7, 0xA0, 0xAB },
	0xC2EF, { 0xF0, 0xA7, 0xA0, 0xAA },
	0xC2F0, { 0xF0, 0xA7, 0xA0, 0xB0 },
	0xC2F1, { 0xF0, 0xA7, 0xA3, 0xA2 },
	0xC2F2, { 0xF0, 0xA7, 0xA3, 0xA3 },
	0xC2F3, { 0xF0, 0xA7, 0xA3, 0xA1 },
	0xC2F4, { 0xF0, 0xA7, 0xA7, 0x95 },
	0xC2F5, { 0xF0, 0xA7, 0xA7, 0x84 },
	0xC2F6, { 0xF0, 0xA7, 0xA7, 0x89 },
	0xC2F7, { 0xF0, 0xA7, 0xA7, 0xA0 },
	0xC2F8, { 0xF0, 0xA7, 0xA7, 0x9F },
	0xC2F9, { 0xF0, 0xA7, 0xA7, 0x8B },
	0xC2FA, { 0xF0, 0xA7, 0xA7, 0x9D },
	0xC2FB, { 0xF0, 0xA7, 0xA7, 0xA8 },
	0xC2FC, { 0xF0, 0xA7, 0xA7, 0x94 },
	0xC2FD, { 0xF0, 0xA7, 0xA8, 0x9C },
	0xC2FE, { 0xF0, 0xA7, 0xAE, 0xB5 },
	0xC3A1, { 0xF0, 0xA7, 0xAE, 0xB6 },
	0xC3A2, { 0xF0, 0xA7, 0xAF, 0xA5 },
	0xC3A3, { 0xF0, 0xA7, 0xB1, 0x85 },
	0xC3A4, { 0xF0, 0xA7, 0xB1, 0x89 },
	0xC3A5, { 0xF0, 0xA7, 0xB1, 0x80 },
	0xC3A6, { 0xF0, 0xA7, 0xB1, 0x86 },
	0xC3A7, { 0xF0, 0xA7, 0xB1, 0x84 },
	0xC3A8, { 0xF0, 0xA7, 0xB1, 0x8A },
	0xC3A9, { 0xF0, 0xA7, 0xB3, 0x89 },
	0xC3AA, { 0xF0, 0xA7, 0xB3, 0x84 },
	0xC3AB, { 0xF0, 0xA7, 0xB3, 0x82 },
	0xC3AC, { 0xF0, 0xA7, 0xB5, 0xA8 },
	0xC3AD, { 0xE8, 0xB3, 0x8B },
	0xC3AE, { 0xF0, 0xA7, 0xB6, 0x82 },
	0xC3AF, { 0xF0, 0xA7, 0xB5, 0xAB },
	0xC3B0, { 0xF0, 0xA7, 0xB5, 0xA7 },
	0xC3B1, { 0xF0, 0xA7, 0xB5, 0xAC },
	0xC3B2, { 0xF0, 0xA7, 0xB5, 0xAD },
	0xC3B3, { 0xF0, 0xA7, 0xB5, 0xB1 },
	0xC3B4, { 0xE4, 0x9E, 0x92 },
	0xC3B5, { 0xF0, 0xA7, 0xBB, 0x97 },
	0xC3B6, { 0xF0, 0xA7, 0xBB, 0x92 },
	0xC3B7, { 0xF0, 0xA7, 0xBB, 0x99 },
	0xC3B8, { 0xE4, 0x9E, 0xAA },
	0xC3B9, { 0xF0, 0xA7, 0xBA, 0xBC },
	0xC3BA, { 0xF0, 0xA7, 0xBB, 0x9D },
	0xC3BB, { 0xF0, 0xA7, 0xBB, 0x96 },
	0xC3BC, { 0xE4, 0x9E, 0xA7 },
	0xC3BD, { 0xF0, 0xA7, 0xBB, 0x98 },
	0xC3BE, { 0xF0, 0xA8, 0x80, 0xA0 },
	0xC3BF, { 0xF0, 0xA8, 0x80, 0x96 },
	0xC3C0, { 0xF0, 0xA8, 0x80, 0x98 },
	0xC3C1, { 0xF0, 0xA8, 0x80, 0x95 },
	0xC3C2, { 0xF0, 0xA8, 0x80, 0x99 },
	0xC3C3, { 0xF0, 0xA8, 0x80, 0xA7 },
	0xC3C4, { 0xF0, 0xA8, 0x81, 0x90 },
	0xC3C5, { 0xF0, 0xA8, 0x80, 0x9D },
	0xC3C6, { 0xF0, 0xA8, 0x80, 0xAC },
	0xC3C7, { 0xF0, 0xA8, 0x80, 0x9C },
	0xC3C8, { 0xF0, 0xA8, 0x80, 0xA9 },
	0xC3C9, { 0xF0, 0xA8, 0x80, 0xAB },
	0xC3CA, { 0xF0, 0xA8, 0x80, 0xA4 },
	0xC3CB, { 0xE4, 0x9F, 0xAF },
	0xC3CC, { 0xF0, 0xA8, 0x80, 0xA8 },
	0xC3CD, { 0xF0, 0xA8, 0x88, 0xB9 },
	0xC3CE, { 0xF0, 0xA8, 0x8B, 0xB2 },
	0xC3CF, { 0xF0, 0xA8, 0x8B, 0xB0 },
	0xC3D0, { 0xE8, 0xBB, 0xAD },
	0xC3D1, { 0xF0, 0xA8, 0x8B, 0xAD },
	0xC3D2, { 0xF0, 0xA8, 0x8B, 0xAF },
	0xC3D3, { 0xF0, 0xA8, 0x8B, 0xAA },
	0xC3D4, { 0xF0, 0xA8, 0x8C, 0x81 },
	0xC3D5, { 0xF0, 0xA8, 0x92, 0xBC },
	0xC3D6, { 0xF0, 0xA8, 0x95, 0x9C },
	0xC3D7, { 0xF0, 0xA8, 0x95, 0x9B },
	0xC3D8, { 0xF0, 0xA8, 0x95, 0x9A },
	0xC3D9, { 0xF0, 0xA8, 0x94, 0xA6 },
	0xC3DA, { 0xF0, 0xA8, 0x9D, 0x83 },
	0xC3DB, { 0xF0, 0xA8, 0x9C, 0xB3 },
	0xC3DC, { 0xF0, 0xA8, 0x9C, 0xBA },
	0xC3DD, { 0xF0, 0xA8, 0x9C, 0xB7 },
	0xC3DE, { 0xF0, 0xA8, 0x9C, 0xB6 },
	0xC3DF, { 0xF0, 0xA8, 0x9C, 0xBC },
	0xC3E0, { 0xF0, 0xA8, 0x9C, 0xB4 },
	0xC3E1, { 0xF0, 0xA8, 0x9D, 0x8A },
	0xC3E2, { 0xF0, 0xA8, 0x9C, 0xBB },
	0xC3E3, { 0xF0, 0xA8, 0x9C, 0xB5 },
	0xC3E4, { 0xF0, 0xA8, 0x9C, 0xBD },
	0xC3E5, { 0xF0, 0xA8, 0x9D, 0x80 },
	0xC3E6, { 0xF0, 0xA8, 0x9C, 0xBE },
	0xC3E7, { 0xF0, 0xA8, 0x9C, 0x97 },
	0xC3E8, { 0xF0, 0xA8, 0xA0, 0xA6 },
	0xC3E9, { 0xF0, 0xA8, 0xA0, 0xA4 },
	0xC3EA, { 0xF0, 0xA8, 0xA0, 0x90 },
	0xC3EB, { 0xF0, 0xA8, 0xA0, 0xB6 },
	0xC3EC, { 0xF0, 0xA8, 0xA0, 0xA5 },
	0xC3ED, { 0xE4, 0xA4, 0xA2 },
	0xC3EE, { 0xF0, 0xA8, 0xA5, 0xA6 },
	0xC3EF, { 0xF0, 0xA8, 0xB1, 0xBF },
	0xC3F0, { 0xF0, 0xA8, 0xB1, 0xBA },
	0xC3F1, { 0xF0, 0xA8, 0xB3, 0xBB },
	0xC3F2, { 0xF0, 0xA8, 0xB3, 0xBD },
	0xC3F3, { 0xF0, 0xA8, 0xB3, 0xBC },
	0xC3F4, { 0xF0, 0xA8, 0xB3, 0xBA },
	0xC3F5, { 0xF0, 0xA8, 0xBB, 0x96 },
	0xC3F6, { 0xF0, 0xA8, 0xBB, 0x92 },
	0xC3F7, { 0xF0, 0xA8, 0xBB, 0x88 },
	0xC3F8, { 0xF0, 0xA8, 0xBB, 0x82 },
	0xC3F9, { 0xF0, 0xA8, 0xBB, 0x87 },
	0xC3FA, { 0xF0, 0xA8, 0xBB, 0x8D },
	0xC3FB, { 0xF0, 0xA8, 0xBB, 0x81 },
	0xC3FC, { 0xF0, 0xA8, 0xBB, 0x86 },
	0xC3FD, { 0xF0, 0xA8, 0xBB, 0x8C },
	0xC3FE, { 0xF0, 0xA8, 0xBE, 0xA1 },
	0xC4A1, { 0xF0, 0xA9, 0x82, 0x95 },
	0xC4A2, { 0xF0, 0xA9, 0x82, 0x94 },
	0xC4A3, { 0xF0, 0xA9, 0x82, 0x97 },
	0xC4A4, { 0xF0, 0xA9, 0x82, 0x96 },
	0xC4A5, { 0xF0, 0xA9, 0x82, 0x93 },
	0xC4A6, { 0xF0, 0xA9, 0x82, 0xA1 },
	0xC4A7, { 0xF0, 0xA9, 0x88, 0x89 },
	0xC4A8, { 0xF0, 0xA9, 0x88, 0x88 },
	0xC4A9, { 0xF0, 0xA9, 0x89, 0xA7 },
	0xC4AA, { 0xF0, 0xA9, 0x89, 0xA5 },
	0xC4AB, { 0xF0, 0xA9, 0x89, 0xA2 },
	0xC4AC, { 0xF0, 0xA9, 0x89, 0xA1 },
	0xC4AD, { 0xF0, 0xA9, 0x8E, 0x97 },
	0xC4AE, { 0xF0, 0xA9, 0x90, 0x81 },
	0xC4AF, { 0xF0, 0xA9, 0x90, 0x99 },
	0xC4B0, { 0xF0, 0xA9, 0x90, 0x98 },
	0xC4B1, { 0xF0, 0xA9, 0x91, 0x9C },
	0xC4B2, { 0xF0, 0xA9, 0x91, 0xA7 },
	0xC4B3, { 0xF0, 0xA9, 0x91, 0xAC },
	0xC4B4, { 0xE4, 0xAA, 0xB5 },
	0xC4B5, { 0xF0, 0xAF, 0xA7, 0xBD },
	0xC4B6, { 0xF0, 0xA9, 0x91, 0xA6 },
	0xC4B7, { 0xF0, 0xA9, 0x91, 0xA1 },
	0xC4B8, { 0xF0, 0xA9, 0x91, 0xAE },
	0xC4B9, { 0xF0, 0xA9, 0x91, 0x9D },
	0xC4BA, { 0xF0, 0xA9, 0x91, 0x9A },
	0xC4BB, { 0xF0, 0xA9, 0x96, 0xA2 },
	0xC4BC, { 0xF0, 0xA9, 0x96, 0xA9 },
	0xC4BD, { 0xF0, 0xA9, 0x96, 0xA5 },
	0xC4BE, { 0xF0, 0xA9, 0x96, 0xA6 },
	0xC4BF, { 0xF0, 0xA9, 0x96, 0xB2 },
	0xC4C0, { 0xF0, 0xA9, 0x96, 0xA3 },
	0xC4C1, { 0xF0, 0xA9, 0x9A, 0xAC },
	0xC4C2, { 0xF0, 0xA9, 0x9A, 0xAA },
	0xC4C3, { 0xF0, 0xA9, 0x9A, 0xAF },
	0xC4C4, { 0xF0, 0xA9, 0x9A, 0xAB },
	0xC4C5, { 0xF0, 0xA9, 0x9A, 0xB1 },
	0xC4C6, { 0xF0, 0xA9, 0x9B, 0x86 },
	0xC4C7, { 0xF0, 0xA9, 0x9A, 0xAD },
	0xC4C8, { 0xF0, 0xA9, 0x9A, 0xB9 },
	0xC4C9, { 0xF0, 0xA9, 0xA1, 0xB0 },
	0xC4CA, { 0xE4, 0xAD, 0xB5 },
	0xC4CB, { 0xF0, 0xA9, 0xB0, 0x8C },
	0xC4CC, { 0xF0, 0xA9, 0xB2, 0x81 },
	0xC4CD, { 0xF0, 0xA9, 0xB2, 0x83 },
	0xC4CE, { 0xF0, 0xA9, 0xB1, 0xBE },
	0xC4CF, { 0xF0, 0xA9, 0xB5, 0x91 },
	0xC4D0, { 0xF0, 0xA9, 0xBE, 0x99 },
	0xC4D1, { 0xF0, 0xA9, 0xBE, 0x94 },
	0xC4D2, { 0xF0, 0xA9, 0xBE, 0x95 },
	0xC4D3, { 0xF0, 0xAA, 0x8B, 0xBE },
	0xC4D4, { 0xF0, 0xAA, 0x90, 0x98 },
	0xC4D5, { 0xF0, 0xA0, 0x84, 0x85 },
	0xC4D6, { 0xF0, 0xA0, 0x8D, 0xB2 },
	0xC4D7, { 0xE3, 0x92, 0x82 },
	0xC4D8, { 0xF0, 0xA0, 0x8E, 0x99 },
	0xC4D9, { 0xF0, 0xA0, 0x92, 0xAD },
	0xC4DA, { 0xF0, 0xA0, 0x98, 0x86 },
	0xC4DB, { 0xF0, 0xA0, 0x9F, 0x82 },
	0xC4DC, { 0xF0, 0xA0, 0x9F, 0x8B },
	0xC4DD, { 0xF0, 0xA0, 0x9F, 0x95 },
	0xC4DE, { 0xF0, 0xA0, 0x9F, 0x92 },
	0xC4DF, { 0xF0, 0xA0, 0x9F, 0x8C },
	0xC4E0, { 0xF0, 0xA0, 0x9F, 0x97 },
	0xC4E1, { 0xF0, 0xA0, 0x9F, 0x85 },
	0xC4E2, { 0xF0, 0xA0, 0x9F, 0x8A },
	0xC4E3, { 0xE5, 0x8B, 0xAC },
	0xC4E4, { 0xF0, 0xA0, 0xA2, 0xA2 },
	0xC4E5, { 0xF0, 0xA0, 0xA2, 0xA3 },
	0xC4E6, { 0xF0, 0xA0, 0xA2, 0xA1 },
	0xC4E7, { 0xE5, 0x8B, 0xA8 },
	0xC4E8, { 0xF0, 0xA0, 0xA2, 0xA6 },
	0xC4E9, { 0xF0, 0xA0, 0xA2, 0xA4 },
	0xC4EA, { 0xF0, 0xA0, 0xA3, 0xBF },
	0xC4EB, { 0xF0, 0xA0, 0xA4, 0x80 },
	0xC4EC, { 0xE3, 0x94, 0xB5 },
	0xC4ED, { 0xF0, 0xA0, 0xA8, 0x86 },
	0xC4EE, { 0xF0, 0xA0, 0xA8, 0xA5 },
	0xC4EF, { 0xF0, 0xA0, 0xAA, 0x9F },
	0xC4F0, { 0xF0, 0xA0, 0xAD, 0xBF },
	0xC4F1, { 0xF0, 0xA0, 0xBB, 0xAA },
	0xC4F2, { 0xF0, 0xA0, 0xBB, 0xAB },
	0xC4F3, { 0xF0, 0xA0, 0xBB, 0x9E },
	0xC4F4, { 0xF0, 0xA0, 0xBC, 0x98 },
	0xC4F5, { 0xF0, 0xA0, 0xBB, 0xA0 },
	0xC4F6, { 0xF0, 0xA0, 0xBB, 0xA8 },
	0xC4F7, { 0xF0, 0xA0, 0xBB, 0x9F },
	0xC4F8, { 0xF0, 0xA0, 0xBB, 0xB1 },
	0xC4F9, { 0xF0, 0xA0, 0xBB, 0xAC },
	0xC4FA, { 0xF0, 0xA0, 0xBC, 0x9A },
	0xC4FB, { 0xF0, 0xA0, 0xBB, 0xA6 },
	0xC4FC, { 0xF0, 0xA0, 0xBB, 0xA1 },
	0xC4FD, { 0xF0, 0xA0, 0xBD, 0x9D },
	0xC4FE, { 0xF0, 0xA0, 0x81, 0xB7 },
	0xC5A1, { 0xF0, 0xA0, 0xBC, 0x9E },
	0xC5A2, { 0xE3, 0x97, 0xB0 },
	0xC5A3, { 0xF0, 0xA0, 0xBE, 0x80 },
	0xC5A4, { 0xF0, 0xA1, 0x88, 0x97 },
	0xC5A5, { 0xF0, 0xA1, 0x90, 0x9D },
	0xC5A6, { 0xF0, 0xA1, 0x8F, 0xB7 },
	0xC5A7, { 0xF0, 0xA1, 0x8F, 0xAF },
	0xC5A8, { 0xF0, 0xA1, 0x8F, 0xAE },
	0xC5A9, { 0xF0, 0xA1, 0x8F, 0xAD },
	0xC5AA, { 0xF0, 0xA1, 0x8F, 0xB5 },
	0xC5AB, { 0xF0, 0xA1, 0x90, 0x9E },
	0xC5AC, { 0xF0, 0xA1, 0x96, 0xBD },
	0xC5AD, { 0xF0, 0xA5, 0x9F, 0xBF },
	0xC5AE, { 0xF0, 0xA1, 0x96, 0xBE },
	0xC5AF, { 0xF0, 0xA1, 0x99, 0xAD },
	0xC5B0, { 0xF0, 0xA1, 0x99, 0xB6 },
	0xC5B1, { 0xF0, 0xA1, 0xA1, 0x8C },
	0xC5B2, { 0xF0, 0xA1, 0xA0, 0x99 },
	0xC5B3, { 0xF0, 0xA1, 0xA1, 0x88 },
	0xC5B4, { 0xF0, 0xA1, 0xA0, 0x9E },
	0xC5B5, { 0xF0, 0xA1, 0xA1, 0x8A },
	0xC5B6, { 0xF0, 0xA1, 0xA1, 0x89 },
	0xC5B7, { 0xF0, 0xA1, 0xA0, 0xA6 },
	0xC5B8, { 0xF0, 0xA1, 0xA6, 0x95 },
	0xC5B9, { 0xF0, 0xA1, 0xAA, 0x85 },
	0xC5BA, { 0xF0, 0xA1, 0xA9, 0xBE },
	0xC5BB, { 0xF0, 0xA1, 0xAA, 0x97 },
	0xC5BC, { 0xF0, 0xA1, 0xA9, 0xBD },
	0xC5BD, { 0xF0, 0xA1, 0xAD, 0x82 },
	0xC5BE, { 0xF0, 0xA1, 0xAE, 0x9E },
	0xC5BF, { 0xF0, 0xA1, 0xB0, 0x8C },
	0xC5C0, { 0xF0, 0xA1, 0xB0, 0x8B },
	0xC5C1, { 0xF0, 0xA1, 0xB0, 0x8E },
	0xC5C2, { 0xF0, 0xA1, 0xB3, 0x8F },
	0xC5C3, { 0xF0, 0xA1, 0xBB, 0x98 },
	0xC5C4, { 0xF0, 0xA1, 0xBB, 0xA0 },
	0xC5C5, { 0xF0, 0xA1, 0xBB, 0xA8 },
	0xC5C6, { 0xF0, 0xA1, 0xBB, 0xA9 },
	0xC5C7, { 0xF0, 0xA1, 0xBB, 0xA2 },
	0xC5C8, { 0xF0, 0xA1, 0xBB, 0xA1 },
	0xC5C9, { 0xF0, 0xA1, 0xBB, 0x9A },
	0xC5CA, { 0xF0, 0xA1, 0xBB, 0xA3 },
	0xC5CB, { 0xF0, 0xA1, 0xBB, 0x99 },
	0xC5CC, { 0xF0, 0xA1, 0xBB, 0xB0 },
	0xC5CD, { 0xF0, 0xA1, 0xBB, 0xA7 },
	0xC5CE, { 0xF0, 0xA1, 0xBB, 0xA4 },
	0xC5CF, { 0xF0, 0xA2, 0x84, 0xA3 },
	0xC5D0, { 0xF0, 0xA2, 0x84, 0xB1 },
	0xC5D1, { 0xF0, 0xA2, 0x84, 0xB3 },
	0xC5D2, { 0xF0, 0xA2, 0x84, 0x8C },
	0xC5D3, { 0xF0, 0xA6, 0xA7, 0xA0 },
	0xC5D4, { 0xF0, 0xA2, 0x84, 0xA6 },
	0xC5D5, { 0xF0, 0xA2, 0x84, 0xA4 },
	0xC5D6, { 0xF0, 0xA2, 0x84, 0xB2 },
	0xC5D7, { 0xF0, 0xA2, 0x84, 0xA7 },
	0xC5D8, { 0xF0, 0xA2, 0x84, 0xA1 },
	0xC5D9, { 0xF0, 0xA2, 0x84, 0xB0 },
	0xC5DA, { 0xF0, 0xA2, 0x86, 0xA2 },
	0xC5DB, { 0xF0, 0xA2, 0x87, 0x8C },
	0xC5DC, { 0xF0, 0xA2, 0x8A, 0x96 },
	0xC5DD, { 0xF0, 0xAF, 0xA2, 0x8F },
	0xC5DE, { 0xF0, 0xA2, 0x8A, 0x98 },
	0xC5DF, { 0xF0, 0xA2, 0x8A, 0x9C },
	0xC5E0, { 0xF0, 0xA2, 0x8A, 0x9B },
	0xC5E1, { 0xF0, 0xA2, 0x8D, 0xAB },
	0xC5E2, { 0xF0, 0xA2, 0x90, 0x92 },
	0xC5E3, { 0xF0, 0xA2, 0x90, 0x94 },
	0xC5E4, { 0xF0, 0xA2, 0x95, 0x9A },
	0xC5E5, { 0xF0, 0xA2, 0x95, 0x94 },
	0xC5E6, { 0xF0, 0xA2, 0x95, 0x91 },
	0xC5E7, { 0xF0, 0xA2, 0x95, 0x9E },
	0xC5E8, { 0xF0, 0xA2, 0x95, 0x98 },
	0xC5E9, { 0xE3, 0xA3, 0xB0 },
	0xC5EA, { 0xF0, 0xA2, 0x95, 0x99 },
	0xC5EB, { 0xF0, 0xA2, 0x9E, 0x9A },
	0xC5EC, { 0xF0, 0xA2, 0x9F, 0xB2 },
	0xC5ED, { 0xF0, 0xA2, 0x9E, 0xAD },
	0xC5EE, { 0xF0, 0xA2, 0xA0, 0xA0 },
	0xC5EF, { 0xF0, 0xA2, 0x9F, 0xB1 },
	0xC5F0, { 0xF0, 0xA2, 0x9F, 0xB0 },
	0xC5F1, { 0xF0, 0xA2, 0x9F, 0xB3 },
	0xC5F2, { 0xF0, 0xA2, 0x9F, 0xB4 },
	0xC5F3, { 0xF0, 0xA2, 0x9F, 0xA9 },
	0xC5F4, { 0xF0, 0xA2, 0x9F, 0xBE },
	0xC5F5, { 0xF0, 0xA2, 0xA0, 0xAE },
	0xC5F6, { 0xF0, 0xA2, 0x9F, 0xA8 },
	0xC5F7, { 0xF0, 0xA2, 0x9F, 0xA7 },
	0xC5F8, { 0xF0, 0xA2, 0x9F, 0xBF },
	0xC5F9, { 0xF0, 0xA2, 0x9F, 0xB5 },
	0xC5FA, { 0xF0, 0xA2, 0xA7, 0xA5 },
	0xC5FB, { 0xF0, 0xA2, 0xA7, 0xA7 },
	0xC5FC, { 0xF0, 0xA2, 0xA7, 0xA6 },
	0xC5FD, { 0xF0, 0xA2, 0xA7, 0xA9 },
	0xC5FE, { 0xF0, 0xA2, 0xA9, 0x98 },
	0xC6A1, { 0xF0, 0xA2, 0xB1, 0xAC },
	0xC6A2, { 0xF0, 0xA2, 0xB3, 0x99 },
	0xC6A3, { 0xE3, 0xA8, 0xBE },
	0xC6A4, { 0xF0, 0xA2, 0xB3, 0x8B },
	0xC6A5, { 0xE3, 0xA8, 0xB9 },
	0xC6A6, { 0xF0, 0xA2, 0xB2, 0xBE },
	0xC6A7, { 0xF0, 0xA2, 0xB2, 0xB5 },
	0xC6A8, { 0xF0, 0xA2, 0xB3, 0x91 },
	0xC6A9, { 0xF0, 0xA2, 0xB3, 0x82 },
	0xC6AA, { 0xF0, 0xA2, 0xB2, 0xB6 },
	0xC6AB, { 0xF0, 0xA2, 0xB3, 0x93 },
	0xC6AC, { 0xF0, 0xAF, 0xA3, 0x82 },
	0xC6AD, { 0xF0, 0xA2, 0xBB, 0x9A },
	0xC6AE, { 0xE3, 0xAA, 0xA2 },
	0xC6AF, { 0xF0, 0xA2, 0xBE, 0xAE },
	0xC6B0, { 0xE3, 0xAA, 0xA1 },
	0xC6B1, { 0xF0, 0xA2, 0xBE, 0xAC },
	0xC6B2, { 0xF0, 0xA2, 0xBE, 0xA9 },
	0xC6B3, { 0xF0, 0xA2, 0xBE, 0xBA },
	0xC6B4, { 0xF0, 0xA2, 0xBE, 0xA7 },
	0xC6B5, { 0xF0, 0xA2, 0xBE, 0xB3 },
	0xC6B6, { 0xF0, 0xA2, 0xBE, 0xBD },
	0xC6B7, { 0xF0, 0xA2, 0xBE, 0xB1 },
	0xC6B8, { 0xF0, 0xA3, 0x84, 0x8E },
	0xC6B9, { 0xF0, 0xA3, 0x84, 0x91 },
	0xC6BA, { 0xF0, 0xA3, 0x84, 0x8F },
	0xC6BB, { 0xF0, 0xA3, 0x89, 0x92 },
	0xC6BC, { 0xF0, 0xA3, 0x89, 0xAA },
	0xC6BD, { 0xF0, 0xA3, 0x89, 0x94 },
	0xC6BE, { 0xF0, 0xA3, 0x89, 0x95 },
	0xC6BF, { 0xF0, 0xA3, 0x89, 0x93 },
	0xC6C0, { 0xF0, 0xA3, 0x89, 0x97 },
	0xC6C1, { 0xF0, 0xAF, 0xA3, 0x90 },
	0xC6C2, { 0xF0, 0xA3, 0x89, 0x9B },
	0xC6C3, { 0xF0, 0xA3, 0x89, 0x98 },
	0xC6C4, { 0xF0, 0xA3, 0x89, 0x99 },
	0xC6C5, { 0xE3, 0xAC, 0xBB },
	0xC6C6, { 0xF0, 0xA3, 0x96, 0xB8 },
	0xC6C7, { 0xF0, 0xA3, 0x96, 0xB5 },
	0xC6C8, { 0xF0, 0xA3, 0x96, 0xBF },
	0xC6C9, { 0xF0, 0xA3, 0x97, 0x81 },
	0xC6CA, { 0xF0, 0xA3, 0x96, 0xBB },
	0xC6CB, { 0xE3, 0xAE, 0xB7 },
	0xC6CC, { 0xF0, 0xA3, 0x97, 0x83 },
	0xC6CD, { 0xF0, 0xA3, 0x96, 0xAD },
	0xC6CE, { 0xF0, 0xA3, 0x96, 0xA8 },
	0xC6CF, { 0xF0, 0xA3, 0x96, 0xAE },
	0xC6D0, { 0xF0, 0xA3, 0x96, 0xAA },
	0xC6D1, { 0xF0, 0xA3, 0x97, 0x90 },
	0xC6D2, { 0xF0, 0xA3, 0x96, 0xB1 },
	0xC6D3, { 0xF0, 0xA3, 0x96, 0xBC },
	0xC6D4, { 0xF0, 0xA3, 0x96, 0xB7 },
	0xC6D5, { 0xF0, 0xA3, 0x96, 0xB0 },
	0xC6D6, { 0xF0, 0xA3, 0x97, 0xBA },
	0xC6D7, { 0xF0, 0xA3, 0x97, 0xBB },
	0xC6D8, { 0xF0, 0xA3, 0x96, 0xB9 },
	0xC6D9, { 0xF0, 0xA3, 0xA4, 0x87 },
	0xC6DA, { 0xF0, 0xA3, 0xA3, 0xBC },
	0xC6DB, { 0xF0, 0xA3, 0xA3, 0xBF },
	0xC6DC, { 0xF0, 0xA3, 0xA3, 0xB2 },
	0xC6DD, { 0xF0, 0xA3, 0xA3, 0xB8 },
	0xC6DE, { 0xF0, 0xA3, 0xA3, 0xB4 },
	0xC6DF, { 0xE3, 0xB1, 0x97 },
	0xC6E0, { 0xE3, 0xB1, 0xB0 },
	0xC6E1, { 0xF0, 0xA3, 0xAA, 0xAE },
	0xC6E2, { 0xF0, 0xA3, 0xAC, 0x8F },
	0xC6E3, { 0xF0, 0xA3, 0xAC, 0x90 },
	0xC6E4, { 0xF0, 0xA9, 0xAB, 0x81 },
	0xC6E5, { 0xF0, 0xA3, 0xAF, 0x87 },
	0xC6E6, { 0xF0, 0xA3, 0xAF, 0x86 },
	0xC6E7, { 0xF0, 0xA3, 0xAF, 0x8E },
	0xC6E8, { 0xE3, 0xB2, 0xA7 },
	0xC6E9, { 0xF0, 0xA3, 0xAF, 0x9C },
	0xC6EA, { 0xF0, 0xA3, 0xBB, 0x95 },
	0xC6EB, { 0xF0, 0xA3, 0xBB, 0x93 },
	0xC6EC, { 0xF0, 0xA3, 0xBC, 0xA0 },
	0xC6ED, { 0xF0, 0xA3, 0xBB, 0xA2 },
	0xC6EE, { 0xF0, 0xA3, 0xBB, 0xB1 },
	0xC6EF, { 0xF0, 0xA3, 0xBB, 0x9B },
	0xC6F0, { 0xF0, 0xA3, 0xBB, 0xAA },
	0xC6F1, { 0xF0, 0xA3, 0xBB, 0xAB },
	0xC6F2, { 0xF0, 0xA3, 0xBB, 0xA1 },
	0xC6F3, { 0xF0, 0xA3, 0xBB, 0xBF },
	0xC6F4, { 0xF0, 0xA3, 0xBB, 0x96 },
	0xC6F5, { 0xF0, 0xA3, 0xBB, 0xA0 },
	0xC6F6, { 0xF0, 0xA3, 0xBB, 0x97 },
	0xC6F7, { 0xF0, 0xA3, 0xBB, 0xA5 },
	0xC6F8, { 0xE3, 0xB5, 0x94 },
	0xC6F9, { 0xF0, 0xA4, 0x8C, 0x9B },
	0xC6FA, { 0xF0, 0xA4, 0x8C, 0x90 },
	0xC6FB, { 0xF0, 0xA4, 0x8C, 0x8F },
	0xC6FC, { 0xF0, 0xA4, 0x8C, 0x8E },
	0xC6FD, { 0xF0, 0xA4, 0x8C, 0xB9 },
	0xC6FE, { 0xF0, 0xA4, 0x8C, 0x8A },
	0xC7A1, { 0xF0, 0xA4, 0x8C, 0x94 },
	0xC7A2, { 0xF0, 0xA4, 0x8C, 0x8C },
	0xC7A3, { 0xF0, 0xA4, 0x94, 0xA3 },
	0xC7A4, { 0xF0, 0xA4, 0x95, 0x9A },
	0xC7A5, { 0xF0, 0xA4, 0x97, 0xA2 },
	0xC7A6, { 0xF0, 0xA4, 0x9A, 0x93 },
	0xC7A7, { 0xF0, 0xA4, 0x9A, 0xB0 },
	0xC7A8, { 0xF0, 0xA4, 0x9A, 0xAB },
	0xC7A9, { 0xF0, 0xA4, 0x9A, 0xBD },
	0xC7AA, { 0xF0, 0xA4, 0x9A, 0xB1 },
	0xC7AB, { 0xF0, 0xA4, 0x9A, 0x8D },
	0xC7AC, { 0xF0, 0xA4, 0x9A, 0xAD },
	0xC7AD, { 0xF