/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_KICONV_EUCKR_UTF8_H
#define	_SYS_KICONV_EUCKR_UTF8_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/* Maximum mapping number from EUC-KR to UTF-8. */
#define	KICONV_EUCKR_UTF8_MAX		(8227)

static kiconv_table_array_t kiconv_euckr_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0xA1A1, { 0xE3, 0x80, 0x80 },
	0xA1A2, { 0xE3, 0x80, 0x81 },
	0xA1A3, { 0xE3, 0x80, 0x82 },
	0xA1A4, { 0xC2, 0xB7 },
	0xA1A5, { 0xE2, 0x80, 0xA5 },
	0xA1A6, { 0xE2, 0x80, 0xA6 },
	0xA1A7, { 0xC2, 0xA8 },
	0xA1A8, { 0xE3, 0x80, 0x83 },
	0xA1A9, { 0xC2, 0xAD },
	0xA1AA, { 0xE2, 0x80, 0x95 },
	0xA1AB, { 0xE2, 0x88, 0xA5 },
	0xA1AC, { 0xEF, 0xBC, 0xBC },
	0xA1AD, { 0xE2, 0x88, 0xBC },
	0xA1AE, { 0xE2, 0x80, 0x98 },
	0xA1AF, { 0xE2, 0x80, 0x99 },
	0xA1B0, { 0xE2, 0x80, 0x9C },
	0xA1B1, { 0xE2, 0x80, 0x9D },
	0xA1B2, { 0xE3, 0x80, 0x94 },
	0xA1B3, { 0xE3, 0x80, 0x95 },
	0xA1B4, { 0xE3, 0x80, 0x88 },
	0xA1B5, { 0xE3, 0x80, 0x89 },
	0xA1B6, { 0xE3, 0x80, 0x8A },
	0xA1B7, { 0xE3, 0x80, 0x8B },
	0xA1B8, { 0xE3, 0x80, 0x8C },
	0xA1B9, { 0xE3, 0x80, 0x8D },
	0xA1BA, { 0xE3, 0x80, 0x8E },
	0xA1BB, { 0xE3, 0x80, 0x8F },
	0xA1BC, { 0xE3, 0x80, 0x90 },
	0xA1BD, { 0xE3, 0x80, 0x91 },
	0xA1BE, { 0xC2, 0xB1 },
	0xA1BF, { 0xC3, 0x97 },
	0xA1C0, { 0xC3, 0xB7 },
	0xA1C1, { 0xE2, 0x89, 0xA0 },
	0xA1C2, { 0xE2, 0x89, 0xA4 },
	0xA1C3, { 0xE2, 0x89, 0xA5 },
	0xA1C4, { 0xE2, 0x88, 0x9E },
	0xA1C5, { 0xE2, 0x88, 0xB4 },
	0xA1C6, { 0xC2, 0xB0 },
	0xA1C7, { 0xE2, 0x80, 0xB2 },
	0xA1C8, { 0xE2, 0x80, 0xB3 },
	0xA1C9, { 0xE2, 0x84, 0x83 },
	0xA1CA, { 0xE2, 0x84, 0xAB },
	0xA1CB, { 0xEF, 0xBF, 0xA0 },
	0xA1CC, { 0xEF, 0xBF, 0xA1 },
	0xA1CD, { 0xEF, 0xBF, 0xA5 },
	0xA1CE, { 0xE2, 0x99, 0x82 },
	0xA1CF, { 0xE2, 0x99, 0x80 },
	0xA1D0, { 0xE2, 0x88, 0xA0 },
	0xA1D1, { 0xE2, 0x8A, 0xA5 },
	0xA1D2, { 0xE2, 0x8C, 0x92 },
	0xA1D3, { 0xE2, 0x88, 0x82 },
	0xA1D4, { 0xE2, 0x88, 0x87 },
	0xA1D5, { 0xE2, 0x89, 0xA1 },
	0xA1D6, { 0xE2, 0x89, 0x92 },
	0xA1D7, { 0xC2, 0xA7 },
	0xA1D8, { 0xE2, 0x80, 0xBB },
	0xA1D9, { 0xE2, 0x98, 0x86 },
	0xA1DA, { 0xE2, 0x98, 0x85 },
	0xA1DB, { 0xE2, 0x97, 0x8B },
	0xA1DC, { 0xE2, 0x97, 0x8F },
	0xA1DD, { 0xE2, 0x97, 0x8E },
	0xA1DE, { 0xE2, 0x97, 0x87 },
	0xA1DF, { 0xE2, 0x97, 0x86 },
	0xA1E0, { 0xE2, 0x96, 0xA1 },
	0xA1E1, { 0xE2, 0x96, 0xA0 },
	0xA1E2, { 0xE2, 0x96, 0xB3 },
	0xA1E3, { 0xE2, 0x96, 0xB2 },
	0xA1E4, { 0xE2, 0x96, 0xBD },
	0xA1E5, { 0xE2, 0x96, 0xBC },
	0xA1E6, { 0xE2, 0x86, 0x92 },
	0xA1E7, { 0xE2, 0x86, 0x90 },
	0xA1E8, { 0xE2, 0x86, 0x91 },
	0xA1E9, { 0xE2, 0x86, 0x93 },
	0xA1EA, { 0xE2, 0x86, 0x94 },
	0xA1EB, { 0xE3, 0x80, 0x93 },
	0xA1EC, { 0xE2, 0x89, 0xAA },
	0xA1ED, { 0xE2, 0x89, 0xAB },
	0xA1EE, { 0xE2, 0x88, 0x9A },
	0xA1EF, { 0xE2, 0x88, 0xBD },
	0xA1F0, { 0xE2, 0x88, 0x9D },
	0xA1F1, { 0xE2, 0x88, 0xB5 },
	0xA1F2, { 0xE2, 0x88, 0xAB },
	0xA1F3, { 0xE2, 0x88, 0xAC },
	0xA1F4, { 0xE2, 0x88, 0x88 },
	0xA1F5, { 0xE2, 0x88, 0x8B },
	0xA1F6, { 0xE2, 0x8A, 0x86 },
	0xA1F7, { 0xE2, 0x8A, 0x87 },
	0xA1F8, { 0xE2, 0x8A, 0x82 },
	0xA1F9, { 0xE2, 0x8A, 0x83 },
	0xA1FA, { 0xE2, 0x88, 0xAA },
	0xA1FB, { 0xE2, 0x88, 0xA9 },
	0xA1FC, { 0xE2, 0x88, 0xA7 },
	0xA1FD, { 0xE2, 0x88, 0xA8 },
	0xA1FE, { 0xEF, 0xBF, 0xA2 },
	0xA2A1, { 0xE2, 0x87, 0x92 },
	0xA2A2, { 0xE2, 0x87, 0x94 },
	0xA2A3, { 0xE2, 0x88, 0x80 },
	0xA2A4, { 0xE2, 0x88, 0x83 },
	0xA2A5, { 0xC2, 0xB4 },
	0xA2A6, { 0xEF, 0xBD, 0x9E },
	0xA2A7, { 0xCB, 0x87 },
	0xA2A8, { 0xCB, 0x98 },
	0xA2A9, { 0xCB, 0x9D },
	0xA2AA, { 0xCB, 0x9A },
	0xA2AB, { 0xCB, 0x99 },
	0xA2AC, { 0xC2, 0xB8 },
	0xA2AD, { 0xCB, 0x9B },
	0xA2AE, { 0xC2, 0xA1 },
	0xA2AF, { 0xC2, 0xBF },
	0xA2B0, { 0xCB, 0x90 },
	0xA2B1, { 0xE2, 0x88, 0xAE },
	0xA2B2, { 0xE2, 0x88, 0x91 },
	0xA2B3, { 0xE2, 0x88, 0x8F },
	0xA2B4, { 0xC2, 0xA4 },
	0xA2B5, { 0xE2, 0x84, 0x89 },
	0xA2B6, { 0xE2, 0x80, 0xB0 },
	0xA2B7, { 0xE2, 0x97, 0x81 },
	0xA2B8, { 0xE2, 0x97, 0x80 },
	0xA2B9, { 0xE2, 0x96, 0xB7 },
	0xA2BA, { 0xE2, 0x96, 0xB6 },
	0xA2BB, { 0xE2, 0x99, 0xA4 },
	0xA2BC, { 0xE2, 0x99, 0xA0 },
	0xA2BD, { 0xE2, 0x99, 0xA1 },
	0xA2BE, { 0xE2, 0x99, 0xA5 },
	0xA2BF, { 0xE2, 0x99, 0xA7 },
	0xA2C0, { 0xE2, 0x99, 0xA3 },
	0xA2C1, { 0xE2, 0x8A, 0x99 },
	0xA2C2, { 0xE2, 0x97, 0x88 },
	0xA2C3, { 0xE2, 0x96, 0xA3 },
	0xA2C4, { 0xE2, 0x97, 0x90 },
	0xA2C5, { 0xE2, 0x97, 0x91 },
	0xA2C6, { 0xE2, 0x96, 0x92 },
	0xA2C7, { 0xE2, 0x96, 0xA4 },
	0xA2C8, { 0xE2, 0x96, 0xA5 },
	0xA2C9, { 0xE2, 0x96, 0xA8 },
	0xA2CA, { 0xE2, 0x96, 0xA7 },
	0xA2CB, { 0xE2, 0x96, 0xA6 },
	0xA2CC, { 0xE2, 0x96, 0xA9 },
	0xA2CD, { 0xE2, 0x99, 0xA8 },
	0xA2CE, { 0xE2, 0x98, 0x8F },
	0xA2CF, { 0xE2, 0x98, 0x8E },
	0xA2D0, { 0xE2, 0x98, 0x9C },
	0xA2D1, { 0xE2, 0x98, 0x9E },
	0xA2D2, { 0xC2, 0xB6 },
	0xA2D3, { 0xE2, 0x80, 0xA0 },
	0xA2D4, { 0xE2, 0x80, 0xA1 },
	0xA2D5, { 0xE2, 0x86, 0x95 },
	0xA2D6, { 0xE2, 0x86, 0x97 },
	0xA2D7, { 0xE2, 0x86, 0x99 },
	0xA2D8, { 0xE2, 0x86, 0x96 },
	0xA2D9, { 0xE2, 0x86, 0x98 },
	0xA2DA, { 0xE2, 0x99, 0xAD },
	0xA2DB, { 0xE2, 0x99, 0xA9 },
	0xA2DC, { 0xE2, 0x99, 0xAA },
	0xA2DD, { 0xE2, 0x99, 0xAC },
	0xA2DE, { 0xE3, 0x89, 0xBF },
	0xA2DF, { 0xE3, 0x88, 0x9C },
	0xA2E0, { 0xE2, 0x84, 0x96 },
	0xA2E1, { 0xE3, 0x8F, 0x87 },
	0xA2E2, { 0xE2, 0x84, 0xA2 },
	0xA2E3, { 0xE3, 0x8F, 0x82 },
	0xA2E4, { 0xE3, 0x8F, 0x98 },
	0xA2E5, { 0xE2, 0x84, 0xA1 },
	0xA2E6, { 0xE2, 0x82, 0xAC },	/* Euro currency symbol. */
	0xA2E7, { 0xC2, 0xAE },		/* Registered mark. */
	0xA3A1, { 0xEF, 0xBC, 0x81 },
	0xA3A2, { 0xEF, 0xBC, 0x82 },
	0xA3A3, { 0xEF, 0xBC, 0x83 },
	0xA3A4, { 0xEF, 0xBC, 0x84 },
	0xA3A5, { 0xEF, 0xBC, 0x85 },
	0xA3A6, { 0xEF, 0xBC, 0x86 },
	0xA3A7, { 0xEF, 0xBC, 0x87 },
	0xA3A8, { 0xEF, 0xBC, 0x88 },
	0xA3A9, { 0xEF, 0xBC, 0x89 },
	0xA3AA, { 0xEF, 0xBC, 0x8A },
	0xA3AB, { 0xEF, 0xBC, 0x8B },
	0xA3AC, { 0xEF, 0xBC, 0x8C },
	0xA3AD, { 0xEF, 0xBC, 0x8D },
	0xA3AE, { 0xEF, 0xBC, 0x8E },
	0xA3AF, { 0xEF, 0xBC, 0x8F },
	0xA3B0, { 0xEF, 0xBC, 0x90 },
	0xA3B1, { 0xEF, 0xBC, 0x91 },
	0xA3B2, { 0xEF, 0xBC, 0x92 },
	0xA3B3, { 0xEF, 0xBC, 0x93 },
	0xA3B4, { 0xEF, 0xBC, 0x94 },
	0xA3B5, { 0xEF, 0xBC, 0x95 },
	0xA3B6, { 0xEF, 0xBC, 0x96 },
	0xA3B7, { 0xEF, 0xBC, 0x97 },
	0xA3B8, { 0xEF, 0xBC, 0x98 },
	0xA3B9, { 0xEF, 0xBC, 0x99 },
	0xA3BA, { 0xEF, 0xBC, 0x9A },
	0xA3BB, { 0xEF, 0xBC, 0x9B },
	0xA3BC, { 0xEF, 0xBC, 0x9C },
	0xA3BD, { 0xEF, 0xBC, 0x9D },
	0xA3BE, { 0xEF, 0xBC, 0x9E },
	0xA3BF, { 0xEF, 0xBC, 0x9F },
	0xA3C0, { 0xEF, 0xBC, 0xA0 },
	0xA3C1, { 0xEF, 0xBC, 0xA1 },
	0xA3C2, { 0xEF, 0xBC, 0xA2 },
	0xA3C3, { 0xEF, 0xBC, 0xA3 },
	0xA3C4, { 0xEF, 0xBC, 0xA4 },
	0xA3C5, { 0xEF, 0xBC, 0xA5 },
	0xA3C6, { 0xEF, 0xBC, 0xA6 },
	0xA3C7, { 0xEF, 0xBC, 0xA7 },
	0xA3C8, { 0xEF, 0xBC, 0xA8 },
	0xA3C9, { 0xEF, 0xBC, 0xA9 },
	0xA3CA, { 0xEF, 0xBC, 0xAA },
	0xA3CB, { 0xEF, 0xBC, 0xAB },
	0xA3CC, { 0xEF, 0xBC, 0xAC },
	0xA3CD, { 0xEF, 0xBC, 0xAD },
	0xA3CE, { 0xEF, 0xBC, 0xAE },
	0xA3CF, { 0xEF, 0xBC, 0xAF },
	0xA3D0, { 0xEF, 0xBC, 0xB0 },
	0xA3D1, { 0xEF, 0xBC, 0xB1 },
	0xA3D2, { 0xEF, 0xBC, 0xB2 },
	0xA3D3, { 0xEF, 0xBC, 0xB3 },
	0xA3D4, { 0xEF, 0xBC, 0xB4 },
	0xA3D5, { 0xEF, 0xBC, 0xB5 },
	0xA3D6, { 0xEF, 0xBC, 0xB6 },
	0xA3D7, { 0xEF, 0xBC, 0xB7 },
	0xA3D8, { 0xEF, 0xBC, 0xB8 },
	0xA3D9, { 0xEF, 0xBC, 0xB9 },
	0xA3DA, { 0xEF, 0xBC, 0xBA },
	0xA3DB, { 0xEF, 0xBC, 0xBB },
	0xA3DC, { 0xEF, 0xBF, 0xA6 },
	0xA3DD, { 0xEF, 0xBC, 0xBD },
	0xA3DE, { 0xEF, 0xBC, 0xBE },
	0xA3DF, { 0xEF, 0xBC, 0xBF },
	0xA3E0, { 0xEF, 0xBD, 0x80 },
	0xA3E1, { 0xEF, 0xBD, 0x81 },
	0xA3E2, { 0xEF, 0xBD, 0x82 },
	0xA3E3, { 0xEF, 0xBD, 0x83 },
	0xA3E4, { 0xEF, 0xBD, 0x84 },
	0xA3E5, { 0xEF, 0xBD, 0x85 },
	0xA3E6, { 0xEF, 0xBD, 0x86 },
	0xA3E7, { 0xEF, 0xBD, 0x87 },
	0xA3E8, { 0xEF, 0xBD, 0x88 },
	0xA3E9, { 0xEF, 0xBD, 0x89 },
	0xA3EA, { 0xEF, 0xBD, 0x8A },
	0xA3EB, { 0xEF, 0xBD, 0x8B },
	0xA3EC, { 0xEF, 0xBD, 0x8C },
	0xA3ED, { 0xEF, 0xBD, 0x8D },
	0xA3EE, { 0xEF, 0xBD, 0x8E },
	0xA3EF, { 0xEF, 0xBD, 0x8F },
	0xA3F0, { 0xEF, 0xBD, 0x90 },
	0xA3F1, { 0xEF, 0xBD, 0x91 },
	0xA3F2, { 0xEF, 0xBD, 0x92 },
	0xA3F3, { 0xEF, 0xBD, 0x93 },
	0xA3F4, { 0xEF, 0xBD, 0x94 },
	0xA3F5, { 0xEF, 0xBD, 0x95 },
	0xA3F6, { 0xEF, 0xBD, 0x96 },
	0xA3F7, { 0xEF, 0xBD, 0x97 },
	0xA3F8, { 0xEF, 0xBD, 0x98 },
	0xA3F9, { 0xEF, 0xBD, 0x99 },
	0xA3FA, { 0xEF, 0xBD, 0x9A },
	0xA3FB, { 0xEF, 0xBD, 0x9B },
	0xA3FC, { 0xEF, 0xBD, 0x9C },
	0xA3FD, { 0xEF, 0xBD, 0x9D },
	0xA3FE, { 0xEF, 0xBF, 0xA3 },
	0xA4A1, { 0xE3, 0x84, 0xB1 },
	0xA4A2, { 0xE3, 0x84, 0xB2 },
	0xA4A3, { 0xE3, 0x84, 0xB3 },
	0xA4A4, { 0xE3, 0x84, 0xB4 },
	0xA4A5, { 0xE3, 0x84, 0xB5 },
	0xA4A6, { 0xE3, 0x84, 0xB6 },
	0xA4A7, { 0xE3, 0x84, 0xB7 },
	0xA4A8, { 0xE3, 0x84, 0xB8 },
	0xA4A9, { 0xE3, 0x84, 0xB9 },
	0xA4AA, { 0xE3, 0x84, 0xBA },
	0xA4AB, { 0xE3, 0x84, 0xBB },
	0xA4AC, { 0xE3, 0x84, 0xBC },
	0xA4AD, { 0xE3, 0x84, 0xBD },
	0xA4AE, { 0xE3, 0x84, 0xBE },
	0xA4AF, { 0xE3, 0x84, 0xBF },
	0xA4B0, { 0xE3, 0x85, 0x80 },
	0xA4B1, { 0xE3, 0x85, 0x81 },
	0xA4B2, { 0xE3, 0x85, 0x82 },
	0xA4B3, { 0xE3, 0x85, 0x83 },
	0xA4B4, { 0xE3, 0x85, 0x84 },
	0xA4B5, { 0xE3, 0x85, 0x85 },
	0xA4B6, { 0xE3, 0x85, 0x86 },
	0xA4B7, { 0xE3, 0x85, 0x87 },
	0xA4B8, { 0xE3, 0x85, 0x88 },
	0xA4B9, { 0xE3, 0x85, 0x89 },
	0xA4BA, { 0xE3, 0x85, 0x8A },
	0xA4BB, { 0xE3, 0x85, 0x8B },
	0xA4BC, { 0xE3, 0x85, 0x8C },
	0xA4BD, { 0xE3, 0x85, 0x8D },
	0xA4BE, { 0xE3, 0x85, 0x8E },
	0xA4BF, { 0xE3, 0x85, 0x8F },
	0xA4C0, { 0xE3, 0x85, 0x90 },
	0xA4C1, { 0xE3, 0x85, 0x91 },
	0xA4C2, { 0xE3, 0x85, 0x92 },
	0xA4C3, { 0xE3, 0x85, 0x93 },
	0xA4C4, { 0xE3, 0x85, 0x94 },
	0xA4C5, { 0xE3, 0x85, 0x95 },
	0xA4C6, { 0xE3, 0x85, 0x96 },
	0xA4C7, { 0xE3, 0x85, 0x97 },
	0xA4C8, { 0xE3, 0x85, 0x98 },
	0xA4C9, { 0xE3, 0x85, 0x99 },
	0xA4CA, { 0xE3, 0x85, 0x9A },
	0xA4CB, { 0xE3, 0x85, 0x9B },
	0xA4CC, { 0xE3, 0x85, 0x9C },
	0xA4CD, { 0xE3, 0x85, 0x9D },
	0xA4CE, { 0xE3, 0x85, 0x9E },
	0xA4CF, { 0xE3, 0x85, 0x9F },
	0xA4D0, { 0xE3, 0x85, 0xA0 },
	0xA4D1, { 0xE3, 0x85, 0xA1 },
	0xA4D2, { 0xE3, 0x85, 0xA2 },
	0xA4D3, { 0xE3, 0x85, 0xA3 },
	0xA4D4, { 0xE3, 0x85, 0xA4 },
	0xA4D5, { 0xE3, 0x85, 0xA5 },
	0xA4D6, { 0xE3, 0x85, 0xA6 },
	0xA4D7, { 0xE3, 0x85, 0xA7 },
	0xA4D8, { 0xE3, 0x85, 0xA8 },
	0xA4D9, { 0xE3, 0x85, 0xA9 },
	0xA4DA, { 0xE3, 0x85, 0xAA },
	0xA4DB, { 0xE3, 0x85, 0xAB },
	0xA4DC, { 0xE3, 0x85, 0xAC },
	0xA4DD, { 0xE3, 0x85, 0xAD },
	0xA4DE, { 0xE3, 0x85, 0xAE },
	0xA4DF, { 0xE3, 0x85, 0xAF },
	0xA4E0, { 0xE3, 0x85, 0xB0 },
	0xA4E1, { 0xE3, 0x85, 0xB1 },
	0xA4E2, { 0xE3, 0x85, 0xB2 },
	0xA4E3, { 0xE3, 0x85, 0xB3 },
	0xA4E4, { 0xE3, 0x85, 0xB4 },
	0xA4E5, { 0xE3, 0x85, 0xB5 },
	0xA4E6, { 0xE3, 0x85, 0xB6 },
	0xA4E7, { 0xE3, 0x85, 0xB7 },
	0xA4E8, { 0xE3, 0x85, 0xB8 },
	0xA4E9, { 0xE3, 0x85, 0xB9 },
	0xA4EA, { 0xE3, 0x85, 0xBA },
	0xA4EB, { 0xE3, 0x85, 0xBB },
	0xA4EC, { 0xE3, 0x85, 0xBC },
	0xA4ED, { 0xE3, 0x85, 0xBD },
	0xA4EE, { 0xE3, 0x85, 0xBE },
	0xA4EF, { 0xE3, 0x85, 0xBF },
	0xA4F0, { 0xE3, 0x86, 0x80 },
	0xA4F1, { 0xE3, 0x86, 0x81 },
	0xA4F2, { 0xE3, 0x86, 0x82 },
	0xA4F3, { 0xE3, 0x86, 0x83 },
	0xA4F4, { 0xE3, 0x86, 0x84 },
	0xA4F5, { 0xE3, 0x86, 0x85 },
	0xA4F6, { 0xE3, 0x86, 0x86 },
	0xA4F7, { 0xE3, 0x86, 0x87 },
	0xA4F8, { 0xE3, 0x86, 0x88 },
	0xA4F9, { 0xE3, 0x86, 0x89 },
	0xA4FA, { 0xE3, 0x86, 0x8A },
	0xA4FB, { 0xE3, 0x86, 0x8B },
	0xA4FC, { 0xE3, 0x86, 0x8C },
	0xA4FD, { 0xE3, 0x86, 0x8D },
	0xA4FE, { 0xE3, 0x86, 0x8E },
	0xA5A1, { 0xE2, 0x85, 0xB0 },
	0xA5A2, { 0xE2, 0x85, 0xB1 },
	0xA5A3, { 0xE2, 0x85, 0xB2 },
	0xA5A4, { 0xE2, 0x85, 0xB3 },
	0xA5A5, { 0xE2, 0x85, 0xB4 },
	0xA5A6, { 0xE2, 0x85, 0xB5 },
	0xA5A7, { 0xE2, 0x85, 0xB6 },
	0xA5A8, { 0xE2, 0x85, 0xB7 },
	0xA5A9, { 0xE2, 0x85, 0xB8 },
	0xA5AA, { 0xE2, 0x85, 0xB9 },
	0xA5B0, { 0xE2, 0x85, 0xA0 },
	0xA5B1, { 0xE2, 0x85, 0xA1 },
	0xA5B2, { 0xE2, 0x85, 0xA2 },
	0xA5B3, { 0xE2, 0x85, 0xA3 },
	0xA5B4, { 0xE2, 0x85, 0xA4 },
	0xA5B5, { 0xE2, 0x85, 0xA5 },
	0xA5B6, { 0xE2, 0x85, 0xA6 },
	0xA5B7, { 0xE2, 0x85, 0xA7 },
	0xA5B8, { 0xE2, 0x85, 0xA8 },
	0xA5B9, { 0xE2, 0x85, 0xA9 },
	0xA5C1, { 0xCE, 0x91 },
	0xA5C2, { 0xCE, 0x92 },
	0xA5C3, { 0xCE, 0x93 },
	0xA5C4, { 0xCE, 0x94 },
	0xA5C5, { 0xCE, 0x95 },
	0xA5C6, { 0xCE, 0x96 },
	0xA5C7, { 0xCE, 0x97 },
	0xA5C8, { 0xCE, 0x98 },
	0xA5C9, { 0xCE, 0x99 },
	0xA5CA, { 0xCE, 0x9A },
	0xA5CB, { 0xCE, 0x9B },
	0xA5CC, { 0xCE, 0x9C },
	0xA5CD, { 0xCE, 0x9D },
	0xA5CE, { 0xCE, 0x9E },
	0xA5CF, { 0xCE, 0x9F },
	0xA5D0, { 0xCE, 0xA0 },
	0xA5D1, { 0xCE, 0xA1 },
	0xA5D2, { 0xCE, 0xA3 },
	0xA5D3, { 0xCE, 0xA4 },
	0xA5D4, { 0xCE, 0xA5 },
	0xA5D5, { 0xCE, 0xA6 },
	0xA5D6, { 0xCE, 0xA7 },
	0xA5D7, { 0xCE, 0xA8 },
	0xA5D8, { 0xCE, 0xA9 },
	0xA5E1, { 0xCE, 0xB1 },
	0xA5E2, { 0xCE, 0xB2 },
	0xA5E3, { 0xCE, 0xB3 },
	0xA5E4, { 0xCE, 0xB4 },
	0xA5E5, { 0xCE, 0xB5 },
	0xA5E6, { 0xCE, 0xB6 },
	0xA5E7, { 0xCE, 0xB7 },
	0xA5E8, { 0xCE, 0xB8 },
	0xA5E9, { 0xCE, 0xB9 },
	0xA5EA, { 0xCE, 0xBA },
	0xA5EB, { 0xCE, 0xBB },
	0xA5EC, { 0xCE, 0xBC },
	0xA5ED, { 0xCE, 0xBD },
	0xA5EE, { 0xCE, 0xBE },
	0xA5EF, { 0xCE, 0xBF },
	0xA5F0, { 0xCF, 0x80 },
	0xA5F1, { 0xCF, 0x81 },
	0xA5F2, { 0xCF, 0x83 },
	0xA5F3, { 0xCF, 0x84 },
	0xA5F4, { 0xCF, 0x85 },
	0xA5F5, { 0xCF, 0x86 },
	0xA5F6, { 0xCF, 0x87 },
	0xA5F7, { 0xCF, 0x88 },
	0xA5F8, { 0xCF, 0x89 },
	0xA6A1, { 0xE2, 0x94, 0x80 },
	0xA6A2, { 0xE2, 0x94, 0x82 },
	0xA6A3, { 0xE2, 0x94, 0x8C },
	0xA6A4, { 0xE2, 0x94, 0x90 },
	0xA6A5, { 0xE2, 0x94, 0x98 },
	0xA6A6, { 0xE2, 0x94, 0x94 },
	0xA6A7, { 0xE2, 0x94, 0x9C },
	0xA6A8, { 0xE2, 0x94, 0xAC },
	0xA6A9, { 0xE2, 0x94, 0xA4 },
	0xA6AA, { 0xE2, 0x94, 0xB4 },
	0xA6AB, { 0xE2, 0x94, 0xBC },
	0xA6AC, { 0xE2, 0x94, 0x81 },
	0xA6AD, { 0xE2, 0x94, 0x83 },
	0xA6AE, { 0xE2, 0x94, 0x8F },
	0xA6AF, { 0xE2, 0x94, 0x93 },
	0xA6B0, { 0xE2, 0x94, 0x9B },
	0xA6B1, { 0xE2, 0x94, 0x97 },
	0xA6B2, { 0xE2, 0x94, 0xA3 },
	0xA6B3, { 0xE2, 0x94, 0xB3 },
	0xA6B4, { 0xE2, 0x94, 0xAB },
	0xA6B5, { 0xE2, 0x94, 0xBB },
	0xA6B6, { 0xE2, 0x95, 0x8B },
	0xA6B7, { 0xE2, 0x94, 0xA0 },
	0xA6B8, { 0xE2, 0x94, 0xAF },
	0xA6B9, { 0xE2, 0x94, 0xA8 },
	0xA6BA, { 0xE2, 0x94, 0xB7 },
	0xA6BB, { 0xE2, 0x94, 0xBF },
	0xA6BC, { 0xE2, 0x94, 0x9D },
	0xA6BD, { 0xE2, 0x94, 0xB0 },
	0xA6BE, { 0xE2, 0x94, 0xA5 },
	0xA6BF, { 0xE2, 0x94, 0xB8 },
	0xA6C0, { 0xE2, 0x95, 0x82 },
	0xA6C1, { 0xE2, 0x94, 0x92 },
	0xA6C2, { 0xE2, 0x94, 0x91 },
	0xA6C3, { 0xE2, 0x94, 0x9A },
	0xA6C4, { 0xE2, 0x94, 0x99 },
	0xA6C5, { 0xE2, 0x94, 0x96 },
	0xA6C6, { 0xE2, 0x94, 0x95 },
	0xA6C7, { 0xE2, 0x94, 0x8E },
	0xA6C8, { 0xE2, 0x94, 0x8D },
	0xA6C9, { 0xE2, 0x94, 0x9E },
	0xA6CA, { 0xE2, 0x94, 0x9F },
	0xA6CB, { 0xE2, 0x94, 0xA1 },
	0xA6CC, { 0xE2, 0x94, 0xA2 },
	0xA6CD, { 0xE2, 0x94, 0xA6 },
	0xA6CE, { 0xE2, 0x94, 0xA7 },
	0xA6CF, { 0xE2, 0x94, 0xA9 },
	0xA6D0, { 0xE2, 0x94, 0xAA },
	0xA6D1, { 0xE2, 0x94, 0xAD },
	0xA6D2, { 0xE2, 0x94, 0xAE },
	0xA6D3, { 0xE2, 0x94, 0xB1 },
	0xA6D4, { 0xE2, 0x94, 0xB2 },
	0xA6D5, { 0xE2, 0x94, 0xB5 },
	0xA6D6, { 0xE2, 0x94, 0xB6 },
	0xA6D7, { 0xE2, 0x94, 0xB9 },
	0xA6D8, { 0xE2, 0x94, 0xBA },
	0xA6D9, { 0xE2, 0x94, 0xBD },
	0xA6DA, { 0xE2, 0x94, 0xBE },
	0xA6DB, { 0xE2, 0x95, 0x80 },
	0xA6DC, { 0xE2, 0x95, 0x81 },
	0xA6DD, { 0xE2, 0x95, 0x83 },
	0xA6DE, { 0xE2, 0x95, 0x84 },
	0xA6DF, { 0xE2, 0x95, 0x85 },
	0xA6E0, { 0xE2, 0x95, 0x86 },
	0xA6E1, { 0xE2, 0x95, 0x87 },
	0xA6E2, { 0xE2, 0x95, 0x88 },
	0xA6E3, { 0xE2, 0x95, 0x89 },
	0xA6E4, { 0xE2, 0x95, 0x8A },
	0xA7A1, { 0xE3, 0x8E, 0x95 },
	0xA7A2, { 0xE3, 0x8E, 0x96 },
	0xA7A3, { 0xE3, 0x8E, 0x97 },
	0xA7A4, { 0xE2, 0x84, 0x93 },
	0xA7A5, { 0xE3, 0x8E, 0x98 },
	0xA7A6, { 0xE3, 0x8F, 0x84 },
	0xA7A7, { 0xE3, 0x8E, 0xA3 },
	0xA7A8, { 0xE3, 0x8E, 0xA4 },
	0xA7A9, { 0xE3, 0x8E, 0xA5 },
	0xA7AA, { 0xE3, 0x8E, 0xA6 },
	0xA7AB, { 0xE3, 0x8E, 0x99 },
	0xA7AC, { 0xE3, 0x8E, 0x9A },
	0xA7AD, { 0xE3, 0x8E, 0x9B },
	0xA7AE, { 0xE3, 0x8E, 0x9C },
	0xA7AF, { 0xE3, 0x8E, 0x9D },
	0xA7B0, { 0xE3, 0x8E, 0x9E },
	0xA7B1, { 0xE3, 0x8E, 0x9F },
	0xA7B2, { 0xE3, 0x8E, 0xA0 },
	0xA7B3, { 0xE3, 0x8E, 0xA1 },
	0xA7B4, { 0xE3, 0x8E, 0xA2 },
	0xA7B5, { 0xE3, 0x8F, 0x8A },
	0xA7B6, { 0xE3, 0x8E, 0x8D },
	0xA7B7, { 0xE3, 0x8E, 0x8E },
	0xA7B8, { 0xE3, 0x8E, 0x8F },
	0xA7B9, { 0xE3, 0x8F, 0x8F },
	0xA7BA, { 0xE3, 0x8E, 0x88 },
	0xA7BB, { 0xE3, 0x8E, 0x89 },
	0xA7BC, { 0xE3, 0x8F, 0x88 },
	0xA7BD, { 0xE3, 0x8E, 0xA7 },
	0xA7BE, { 0xE3, 0x8E, 0xA8 },
	0xA7BF, { 0xE3, 0x8E, 0xB0 },
	0xA7C0, { 0xE3, 0x8E, 0xB1 },
	0xA7C1, { 0xE3, 0x8E, 0xB2 },
	0xA7C2, { 0xE3, 0x8E, 0xB3 },
	0xA7C3, { 0xE3, 0x8E, 0xB4 },
	0xA7C4, { 0xE3, 0x8E, 0xB5 },
	0xA7C5, { 0xE3, 0x8E, 0xB6 },
	0xA7C6, { 0xE3, 0x8E, 0xB7 },
	0xA7C7, { 0xE3, 0x8E, 0xB8 },
	0xA7C8, { 0xE3, 0x8E, 0xB9 },
	0xA7C9, { 0xE3, 0x8E, 0x80 },
	0xA7CA, { 0xE3, 0x8E, 0x81 },
	0xA7CB, { 0xE3, 0x8E, 0x82 },
	0xA7CC, { 0xE3, 0x8E, 0x83 },
	0xA7CD, { 0xE3, 0x8E, 0x84 },
	0xA7CE, { 0xE3, 0x8E, 0xBA },
	0xA7CF, { 0xE3, 0x8E, 0xBB },
	0xA7D0, { 0xE3, 0x8E, 0xBC },
	0xA7D1, { 0xE3, 0x8E, 0xBD },
	0xA7D2, { 0xE3, 0x8E, 0xBE },
	0xA7D3, { 0xE3, 0x8E, 0xBF },
	0xA7D4, { 0xE3, 0x8E, 0x90 },
	0xA7D5, { 0xE3, 0x8E, 0x91 },
	0xA7D6, { 0xE3, 0x8E, 0x92 },
	0xA7D7, { 0xE3, 0x8E, 0x93 },
	0xA7D8, { 0xE3, 0x8E, 0x94 },
	0xA7D9, { 0xE2, 0x84, 0xA6 },
	0xA7DA, { 0xE3, 0x8F, 0x80 },
	0xA7DB, { 0xE3, 0x8F, 0x81 },
	0xA7DC, { 0xE3, 0x8E, 0x8A },
	0xA7DD, { 0xE3, 0x8E, 0x8B },
	0xA7DE, { 0xE3, 0x8E, 0x8C },
	0xA7DF, { 0xE3, 0x8F, 0x96 },
	0xA7E0, { 0xE3, 0x8F, 0x85 },
	0xA7E1, { 0xE3, 0x8E, 0xAD },
	0xA7E2, { 0xE3, 0x8E, 0xAE },
	0xA7E3, { 0xE3, 0x8E, 0xAF },
	0xA7E4, { 0xE3, 0x8F, 0x9B },
	0xA7E5, { 0xE3, 0x8E, 0xA9 },
	0xA7E6, { 0xE3, 0x8E, 0xAA },
	0xA7E7, { 0xE3, 0x8E, 0xAB },
	0xA7E8, { 0xE3, 0x8E, 0xAC },
	0xA7E9, { 0xE3, 0x8F, 0x9D },
	0xA7EA, { 0xE3, 0x8F, 0x90 },
	0xA7EB, { 0xE3, 0x8F, 0x93 },
	0xA7EC, { 0xE3, 0x8F, 0x83 },
	0xA7ED, { 0xE3, 0x8F, 0x89 },
	0xA7EE, { 0xE3, 0x8F, 0x9C },
	0xA7EF, { 0xE3, 0x8F, 0x86 },
	0xA8A1, { 0xC3, 0x86 },
	0xA8A2, { 0xC3, 0x90 },
	0xA8A3, { 0xC2, 0xAA },
	0xA8A4, { 0xC4, 0xA6 },
	0xA8A6, { 0xC4, 0xB2 },
	0xA8A8, { 0xC4, 0xBF },
	0xA8A9, { 0xC5, 0x81 },
	0xA8AA, { 0xC3, 0x98 },
	0xA8AB, { 0xC5, 0x92 },
	0xA8AC, { 0xC2, 0xBA },
	0xA8AD, { 0xC3, 0x9E },
	0xA8AE, { 0xC5, 0xA6 },
	0xA8AF, { 0xC5, 0x8A },
	0xA8B1, { 0xE3, 0x89, 0xA0 },
	0xA8B2, { 0xE3, 0x89, 0xA1 },
	0xA8B3, { 0xE3, 0x89, 0xA2 },
	0xA8B4, { 0xE3, 0x89, 0xA3 },
	0xA8B5, { 0xE3, 0x89, 0xA4 },
	0xA8B6, { 0xE3, 0x89, 0xA5 },
	0xA8B7, { 0xE3, 0x89, 0xA6 },
	0xA8B8, { 0xE3, 0x89, 0xA7 },
	0xA8B9, { 0xE3, 0x89, 0xA8 },
	0xA8BA, { 0xE3, 0x89, 0xA9 },
	0xA8BB, { 0xE3, 0x89, 0xAA },
	0xA8BC, { 0xE3, 0x89, 0xAB },
	0xA8BD, { 0xE3, 0x89, 0xAC },
	0xA8BE, { 0xE3, 0x89, 0xAD },
	0xA8BF, { 0xE3, 0x89, 0xAE },
	0xA8C0, { 0xE3, 0x89, 0xAF },
	0xA8C1, { 0xE3, 0x89, 0xB0 },
	0xA8C2, { 0xE3, 0x89, 0xB1 },
	0xA8C3, { 0xE3, 0x89, 0xB2 },
	0xA8C4, { 0xE3, 0x89, 0xB3 },
	0xA8C5, { 0xE3, 0x89, 0xB4 },
	0xA8C6, { 0xE3, 0x89, 0xB5 },
	0xA8C7, { 0xE3, 0x89, 0xB6 },
	0xA8C8, { 0xE3, 0x89, 0xB7 },
	0xA8C9, { 0xE3, 0x89, 0xB8 },
	0xA8CA, { 0xE3, 0x89, 0xB9 },
	0xA8CB, { 0xE3, 0x89, 0xBA },
	0xA8CC, { 0xE3, 0x89, 0xBB },
	0xA8CD, { 0xE2, 0x93, 0x90 },
	0xA8CE, { 0xE2, 0x93, 0x91 },
	0xA8CF, { 0xE2, 0x93, 0x92 },
	0xA8D0, { 0xE2, 0x93, 0x93 },
	0xA8D1, { 0xE2, 0x93, 0x94 },
	0xA8D2, { 0xE2, 0x93, 0x95 },
	0xA8D3, { 0xE2, 0x93, 0x96 },
	0xA8D4, { 0xE2, 0x93, 0x97 },
	0xA8D5, { 0xE2, 0x93, 0x98 },
	0xA8D6, { 0xE2, 0x93, 0x99 },
	0xA8D7, { 0xE2, 0x93, 0x9A },
	0xA8D8, { 0xE2, 0x93, 0x9B },
	0xA8D9, { 0xE2, 0x93, 0x9C },
	0xA8DA, { 0xE2, 0x93, 0x9D },
	0xA8DB, { 0xE2, 0x93, 0x9E },
	0xA8DC, { 0xE2, 0x93, 0x9F },
	0xA8DD, { 0xE2, 0x93, 0xA0 },
	0xA8DE, { 0xE2, 0x93, 0xA1 },
	0xA8DF, { 0xE2, 0x93, 0xA2 },
	0xA8E0, { 0xE2, 0x93, 0xA3 },
	0xA8E1, { 0xE2, 0x93, 0xA4 },
	0xA8E2, { 0xE2, 0x93, 0xA5 },
	0xA8E3, { 0xE2, 0x93, 0xA6 },
	0xA8E4, { 0xE2, 0x93, 0xA7 },
	0xA8E5, { 0xE2, 0x93, 0xA8 },
	0xA8E6, { 0xE2, 0x93, 0xA9 },
	0xA8E7, { 0xE2, 0x91, 0xA0 },
	0xA8E8, { 0xE2, 0x91, 0xA1 },
	0xA8E9, { 0xE2, 0x91, 0xA2 },
	0xA8EA, { 0xE2, 0x91, 0xA3 },
	0xA8EB, { 0xE2, 0x91, 0xA4 },
	0xA8EC, { 0xE2, 0x91, 0xA5 },
	0xA8ED, { 0xE2, 0x91, 0xA6 },
	0xA8EE, { 0xE2, 0x91, 0xA7 },
	0xA8EF, { 0xE2, 0x91, 0xA8 },
	0xA8F0, { 0xE2, 0x91, 0xA9 },
	0xA8F1, { 0xE2, 0x91, 0xAA },
	0xA8F2, { 0xE2, 0x91, 0xAB },
	0xA8F3, { 0xE2, 0x91, 0xAC },
	0xA8F4, { 0xE2, 0x91, 0xAD },
	0xA8F5, { 0xE2, 0x91, 0xAE },
	0xA8F6, { 0xC2, 0xBD },
	0xA8F7, { 0xE2, 0x85, 0x93 },
	0xA8F8, { 0xE2, 0x85, 0x94 },
	0xA8F9, { 0xC2, 0xBC },
	0xA8FA, { 0xC2, 0xBE },
	0xA8FB, { 0xE2, 0x85, 0x9B },
	0xA8FC, { 0xE2, 0x85, 0x9C },
	0xA8FD, { 0xE2, 0x85, 0x9D },
	0xA8FE, { 0xE2, 0x85, 0x9E },
	0xA9A1, { 0xC3, 0xA6 },
	0xA9A2, { 0xC4, 0x91 },
	0xA9A3, { 0xC3, 0xB0 },
	0xA9A4, { 0xC4, 0xA7 },
	0xA9A5, { 0xC4, 0xB1 },
	0xA9A6, { 0xC4, 0xB3 },
	0xA9A7, { 0xC4, 0xB8 },
	0xA9A8, { 0xC5, 0x80 },
	0xA9A9, { 0xC5, 0x82 },
	0xA9AA, { 0xC3, 0xB8 },
	0xA9AB, { 0xC5, 0x93 },
	0xA9AC, { 0xC3, 0x9F },
	0xA9AD, { 0xC3, 0xBE },
	0xA9AE, { 0xC5, 0xA7 },
	0xA9AF, { 0xC5, 0x8B },
	0xA9B0, { 0xC5, 0x89 },
	0xA9B1, { 0xE3, 0x88, 0x80 },
	0xA9B2, { 0xE3, 0x88, 0x81 },
	0xA9B3, { 0xE3, 0x88, 0x82 },
	0xA9B4, { 0xE3, 0x88, 0x83 },
	0xA9B5, { 0xE3, 0x88, 0x84 },
	0xA9B6, { 0xE3, 0x88, 0x85 },
	0xA9B7, { 0xE3, 0x88, 0x86 },
	0xA9B8, { 0xE3, 0x88, 0x87 },
	0xA9B9, { 0xE3, 0x88, 0x88 },
	0xA9BA, { 0xE3, 0x88, 0x89 },
	0xA9BB, { 0xE3, 0x88, 0x8A },
	0xA9BC, { 0xE3, 0x88, 0x8B },
	0xA9BD, { 0xE3, 0x88, 0x8C },
	0xA9BE, { 0xE3, 0x88, 0x8D },
	0xA9BF, { 0xE3, 0x88, 0x8E },
	0xA9C0, { 0xE3, 0x88, 0x8F },
	0xA9C1, { 0xE3, 0x88, 0x90 },
	0xA9C2, { 0xE3, 0x88, 0x91 },
	0xA9C3, { 0xE3, 0x88, 0x92 },
	0xA9C4, { 0xE3, 0x88, 0x93 },
	0xA9C5, { 0xE3, 0x88, 0x94 },
	0xA9C6, { 0xE3, 0x88, 0x95 },
	0xA9C7, { 0xE3, 0x88, 0x96 },
	0xA9C8, { 0xE3, 0x88, 0x97 },
	0xA9C9, { 0xE3, 0x88, 0x98 },
	0xA9CA, { 0xE3, 0x88, 0x99 },
	0xA9CB, { 0xE3, 0x88, 0x9A },
	0xA9CC, { 0xE3, 0x88, 0x9B },
	0xA9CD, { 0xE2, 0x92, 0x9C },
	0xA9CE, { 0xE2, 0x92, 0x9D },
	0xA9CF, { 0xE2, 0x92, 0x9E },
	0xA9D0, { 0xE2, 0x92, 0x9F },
	0xA9D1, { 0xE2, 0x92, 0xA0 },
	0xA9D2, { 0xE2, 0x92, 0xA1 },
	0xA9D3, { 0xE2, 0x92, 0xA2 },
	0xA9D4, { 0xE2, 0x92, 0xA3 },
	0xA9D5, { 0xE2, 0x92, 0xA4 },
	0xA9D6, { 0xE2, 0x92, 0xA5 },
	0xA9D7, { 0xE2, 0x92, 0xA6 },
	0xA9D8, { 0xE2, 0x92, 0xA7 },
	0xA9D9, { 0xE2, 0x92, 0xA8 },
	0xA9DA, { 0xE2, 0x92, 0xA9 },
	0xA9DB, { 0xE2, 0x92, 0xAA },
	0xA9DC, { 0xE2, 0x92, 0xAB },
	0xA9DD, { 0xE2, 0x92, 0xAC },
	0xA9DE, { 0xE2, 0x92, 0xAD },
	0xA9DF, { 0xE2, 0x92, 0xAE },
	0xA9E0, { 0xE2, 0x92, 0xAF },
	0xA9E1, { 0xE2, 0x92, 0xB0 },
	0xA9E2, { 0xE2, 0x92, 0xB1 },
	0xA9E3, { 0xE2, 0x92, 0xB2 },
	0xA9E4, { 0xE2, 0x92, 0xB3 },
	0xA9E5, { 0xE2, 0x92, 0xB4 },
	0xA9E6, { 0xE2, 0x92, 0xB5 },
	0xA9E7, { 0xE2, 0x91, 0xB4 },
	0xA9E8, { 0xE2, 0x91, 0xB5 },
	0xA9E9, { 0xE2, 0x91, 0xB6 },
	0xA9EA, { 0xE2, 0x91, 0xB7 },
	0xA9EB, { 0xE2, 0x91, 0xB8 },
	0xA9EC, { 0xE2, 0x91, 0xB9 },
	0xA9ED, { 0xE2, 0x91, 0xBA },
	0xA9EE, { 0xE2, 0x91, 0xBB },
	0xA9EF, { 0xE2, 0x91, 0xBC },
	0xA9F0, { 0xE2, 0x91, 0xBD },
	0xA9F1, { 0xE2, 0x91, 0xBE },
	0xA9F2, { 0xE2, 0x91, 0xBF },
	0xA9F3, { 0xE2, 0x92, 0x80 },
	0xA9F4, { 0xE2, 0x92, 0x81 },
	0xA9F5, { 0xE2, 0x92, 0x82 },
	0xA9F6, { 0xC2, 0xB9 },
	0xA9F7, { 0xC2, 0xB2 },
	0xA9F8, { 0xC2, 0xB3 },
	0xA9F9, { 0xE2, 0x81, 0xB4 },
	0xA9FA, { 0xE2, 0x81, 0xBF },
	0xA9FB, { 0xE2, 0x82, 0x81 },
	0xA9FC, { 0xE2, 0x82, 0x82 },
	0xA9FD, { 0xE2, 0x82, 0x83 },
	0xA9FE, { 0xE2, 0x82, 0x84 },
	0xAAA1, { 0xE3, 0x81, 0x81 },
	0xAAA2, { 0xE3, 0x81, 0x82 },
	0xAAA3, { 0xE3, 0x81, 0x83 },
	0xAAA4, { 0xE3, 0x81, 0x84 },
	0xAAA5, { 0xE3, 0x81, 0x85 },
	0xAAA6, { 0xE3, 0x81, 0x86 },
	0xAAA7, { 0xE3, 0x81, 0x87 },
	0xAAA8, { 0xE3, 0x81, 0x88 },
	0xAAA9, { 0xE3, 0x81, 0x89 },
	0xAAAA, { 0xE3, 0x81, 0x8A },
	0xAAAB, { 0xE3, 0x81, 0x8B },
	0xAAAC, { 0xE3, 0x81, 0x8C },
	0xAAAD, { 0xE3, 0x81, 0x8D },
	0xAAAE, { 0xE3, 0x81, 0x8E },
	0xAAAF, { 0xE3, 0x81, 0x8F },
	0xAAB0, { 0xE3, 0x81, 0x90 },
	0xAAB1, { 0xE3, 0x81, 0x91 },
	0xAAB2, { 0xE3, 0x81, 0x92 },
	0xAAB3, { 0xE3, 0x81, 0x93 },
	0xAAB4, { 0xE3, 0x81, 0x94 },
	0xAAB5, { 0xE3, 0x81, 0x95 },
	0xAAB6, { 0xE3, 0x81, 0x96 },
	0xAAB7, { 0xE3, 0x81, 0x97 },
	0xAAB8, { 0xE3, 0x81, 0x98 },
	0xAAB9, { 0xE3, 0x81, 0x99 },
	0xAABA, { 0xE3, 0x81, 0x9A },
	0xAABB, { 0xE3, 0x81, 0x9B },
	0xAABC, { 0xE3, 0x81, 0x9C },
	0xAABD, { 0xE3, 0x81, 0x9D },
	0xAABE, { 0xE3, 0x81, 0x9E },
	0xAABF, { 0xE3, 0x81, 0x9F },
	0xAAC0, { 0xE3, 0x81, 0xA0 },
	0xAAC1, { 0xE3, 0x81, 0xA1 },
	0xAAC2, { 0xE3, 0x81, 0xA2 },
	0xAAC3, { 0xE3, 0x81, 0xA3 },
	0xAAC4, { 0xE3, 0x81, 0xA4 },
	0xAAC5, { 0xE3, 0x81, 0xA5 },
	0xAAC6, { 0xE3, 0x81, 0xA6 },
	0xAAC7, { 0xE3, 0x81, 0xA7 },
	0xAAC8, { 0xE3, 0x81, 0xA8 },
	0xAAC9, { 0xE3, 0x81, 0xA9 },
	0xAACA, { 0xE3, 0x81, 0xAA },
	0xAACB, { 0xE3, 0x81, 0xAB },
	0xAACC, { 0xE3, 0x81, 0xAC },
	0xAACD, { 0xE3, 0x81, 0xAD },
	0xAACE, { 0xE3, 0x81, 0xAE },
	0xAACF, { 0xE3, 0x81, 0xAF },
	0xAAD0, { 0xE3, 0x81, 0xB0 },
	0xAAD1, { 0xE3, 0x81, 0xB1 },
	0xAAD2, { 0xE3, 0x81, 0xB2 },
	0xAAD3, { 0xE3, 0x81, 0xB3 },
	0xAAD4, { 0xE3, 0x81, 0xB4 },
	0xAAD5, { 0xE3, 0x81, 0xB5 },
	0xAAD6, { 0xE3, 0x81, 0xB6 },
	0xAAD7, { 0xE3, 0x81, 0xB7 },
	0xAAD8, { 0xE3, 0x81, 0xB8 },
	0xAAD9, { 0xE3, 0x81, 0xB9 },
	0xAADA, { 0xE3, 0x81, 0xBA },
	0xAADB, { 0xE3, 0x81, 0xBB },
	0xAADC, { 0xE3, 0x81, 0xBC },
	0xAADD, { 0xE3, 0x81, 0xBD },
	0xAADE, { 0xE3, 0x81, 0xBE },
	0xAADF, { 0xE3, 0x81, 0xBF },
	0xAAE0, { 0xE3, 0x82, 0x80 },
	0xAAE1, { 0xE3, 0x82, 0x81 },
	0xAAE2, { 0xE3, 0x82, 0x82 },
	0xAAE3, { 0xE3, 0x82, 0x83 },
	0xAAE4, { 0xE3, 0x82, 0x84 },
	0xAAE5, { 0xE3, 0x82, 0x85 },
	0xAAE6, { 0xE3, 0x82, 0x86 },
	0xAAE7, { 0xE3, 0x82, 0x87 },
	0xAAE8, { 0xE3, 0x82, 0x88 },
	0xAAE9, { 0xE3, 0x82, 0x89 },
	0xAAEA, { 0xE3, 0x82, 0x8A },
	0xAAEB, { 0xE3, 0x82, 0x8B },
	0xAAEC, { 0xE3, 0x82, 0x8C },
	0xAAED, { 0xE3, 0x82, 0x8D },
	0xAAEE, { 0xE3, 0x82, 0x8E },
	0xAAEF, { 0xE3, 0x82, 0x8F },
	0xAAF0, { 0xE3, 0x82, 0x90 },
	0xAAF1, { 0xE3, 0x82, 0x91 },
	0xAAF2, { 0xE3, 0x82, 0x92 },
	0xAAF3, { 0xE3, 0x82, 0x93 },
	0xABA1, { 0xE3, 0x82, 0xA1 },
	0xABA2, { 0xE3, 0x82, 0xA2 },
	0xABA3, { 0xE3, 0x82, 0xA3 },
	0xABA4, { 0xE3, 0x82, 0xA4 },
	0xABA5, { 0xE3, 0x82, 0xA5 },
	0xABA6, { 0xE3, 0x82, 0xA6 },
	0xABA7, { 0xE3, 0x82, 0xA7 },
	0xABA8, { 0xE3, 0x82, 0xA8 },
	0xABA9, { 0xE3, 0x82, 0xA9 },
	0xABAA, { 0xE3, 0x82, 0xAA },
	0xABAB, { 0xE3, 0x82, 0xAB },
	0xABAC, { 0xE3, 0x82, 0xAC },
	0xABAD, { 0xE3, 0x82, 0xAD },
	0xABAE, { 0xE3, 0x82, 0xAE },
	0xABAF, { 0xE3, 0x82, 0xAF },
	0xABB0, { 0xE3, 0x82, 0xB0 },
	0xABB1, { 0xE3, 0x82, 0xB1 },
	0xABB2, { 0xE3, 0x82, 0xB2 },
	0xABB3, { 0xE3, 0x82, 0xB3 },
	0xABB4, { 0xE3, 0x82, 0xB4 },
	0xABB5, { 0xE3, 0x82, 0xB5 },
	0xABB6, { 0xE3, 0x82, 0xB6 },
	0xABB7, { 0xE3, 0x82, 0xB7 },
	0xABB8, { 0xE3, 0x82, 0xB8 },
	0xABB9, { 0xE3, 0x82, 0xB9 },
	0xABBA, { 0xE3, 0x82, 0xBA },
	0xABBB, { 0xE3, 0x82, 0xBB },
	0xABBC, { 0xE3, 0x82, 0xBC },
	0xABBD, { 0xE3, 0x82, 0xBD },
	0xABBE, { 0xE3, 0x82, 0xBE },
	0xABBF, { 0xE3, 0x82, 0xBF },
	0xABC0, { 0xE3, 0x83, 0x80 },
	0xABC1, { 0xE3, 0x83, 0x81 },
	0xABC2, { 0xE3, 0x83, 0x82 },
	0xABC3, { 0xE3, 0x83, 0x83 },
	0xABC4, { 0xE3, 0x83, 0x84 },
	0xABC5, { 0xE3, 0x83, 0x85 },
	0xABC6, { 0xE3, 0x83, 0x86 },
	0xABC7, { 0xE3, 0x83, 0x87 },
	0xABC8, { 0xE3, 0x83, 0x88 },
	0xABC9, { 0xE3, 0x83, 0x89 },
	0xABCA, { 0xE3, 0x83, 0x8A },
	0xABCB, { 0xE3, 0x83, 0x8B },
	0xABCC, { 0xE3, 0x83, 0x8C },
	0xABCD, { 0xE3, 0x83, 0x8D },
	0xABCE, { 0xE3, 0x83, 0x8E },
	0xABCF, { 0xE3, 0x83, 0x8F },
	0xABD0, { 0xE3, 0x83, 0x90 },
	0xABD1, { 0xE3, 0x83, 0x91 },
	0xABD2, { 0xE3, 0x83, 0x92 },
	0xABD3, { 0xE3, 0x83, 0x93 },
	0xABD4, { 0xE3, 0x83, 0x94 },
	0xABD5, { 0xE3, 0x83, 0x95 },
	0xABD6, { 0xE3, 0x83, 0x96 },
	0xABD7, { 0xE3, 0x83, 0x97 },
	0xABD8, { 0xE3, 0x83, 0x98 },
	0xABD9, { 0xE3, 0x83, 0x99 },
	0xABDA, { 0xE3, 0x83, 0x9A },
	0xABDB, { 0xE3, 0x83, 0x9B },
	0xABDC, { 0xE3, 0x83, 0x9C },
	0xABDD, { 0xE3, 0x83, 0x9D },
	0xABDE, { 0xE3, 0x83, 0x9E },
	0xABDF, { 0xE3, 0x83, 0x9F },
	0xABE0, { 0xE3, 0x83, 0xA0 },
	0xABE1, { 0xE3, 0x83, 0xA1 },
	0xABE2, { 0xE3, 0x83, 0xA2 },
	0xABE3, { 0xE3, 0x83, 0xA3 },
	0xABE4, { 0xE3, 0x83, 0xA4 },
	0xABE5, { 0xE3, 0x83, 0xA5 },
	0xABE6, { 0xE3, 0x83, 0xA6 },
	0xABE7, { 0xE3, 0x83, 0xA7 },
	0xABE8, { 0xE3, 0x83, 0xA8 },
	0xABE9, { 0xE3, 0x83, 0xA9 },
	0xABEA, { 0xE3, 0x83, 0xAA },
	0xABEB, { 0xE3, 0x83, 0xAB },
	0xABEC, { 0xE3, 0x83, 0xAC },
	0xABED, { 0xE3, 0x83, 0xAD },
	0xABEE, { 0xE3, 0x83, 0xAE },
	0xABEF, { 0xE3, 0x83, 0xAF },
	0xABF0, { 0xE3, 0x83, 0xB0 },
	0xABF1, { 0xE3, 0x83, 0xB1 },
	0xABF2, { 0xE3, 0x83, 0xB2 },
	0xABF3, { 0xE3, 0x83, 0xB3 },
	0xABF4, { 0xE3, 0x83, 0xB4 },
	0xABF5, { 0xE3, 0x83, 0xB5 },
	0xABF6, { 0xE3, 0x83, 0xB6 },
	0xACA1, { 0xD0, 0x90 },
	0xACA2, { 0xD0, 0x91 },
	0xACA3, { 0xD0, 0x92 },
	0xACA4, { 0xD0, 0x93 },
	0xACA5, { 0xD0, 0x94 },
	0xACA6, { 0xD0, 0x95 },
	0xACA7, { 0xD0, 0x81 },
	0xACA8, { 0xD0, 0x96 },
	0xACA9, { 0xD0, 0x97 },
	0xACAA, { 0xD0, 0x98 },
	0xACAB, { 0xD0, 0x99 },
	0xACAC, { 0xD0, 0x9A },
	0xACAD, { 0xD0, 0x9B },
	0xACAE, { 0xD0, 0x9C },
	0xACAF, { 0xD0, 0x9D },
	0xACB0, { 0xD0, 0x9E },
	0xACB1, { 0xD0, 0x9F },
	0xACB2, { 0xD0, 0xA0 },
	0xACB3, { 0xD0, 0xA1 },
	0xACB4, { 0xD0, 0xA2 },
	0xACB5, { 0xD0, 0xA3 },
	0xACB6, { 0xD0, 0xA4 },
	0xACB7, { 0xD0, 0xA5 },
	0xACB8, { 0xD0, 0xA6 },
	0xACB9, { 0xD0, 0xA7 },
	0xACBA, { 0xD0, 0xA8 },
	0xACBB, { 0xD0, 0xA9 },
	0xACBC, { 0xD0, 0xAA },
	0xACBD, { 0xD0, 0xAB },
	0xACBE, { 0xD0, 0xAC },
	0xACBF, { 0xD0, 0xAD },
	0xACC0, { 0xD0, 0xAE },
	0xACC1, { 0xD0, 0xAF },
	0xACD1, { 0xD0, 0xB0 },
	0xACD2, { 0xD0, 0xB1 },
	0xACD3, { 0xD0, 0xB2 },
	0xACD4, { 0xD0, 0xB3 },
	0xACD5, { 0xD0, 0xB4 },
	0xACD6, { 0xD0, 0xB5 },
	0xACD7, { 0xD1, 0x91 },
	0xACD8, { 0xD0, 0xB6 },
	0xACD9, { 0xD0, 0xB7 },
	0xACDA, { 0xD0, 0xB8 },
	0xACDB, { 0xD0, 0xB9 },
	0xACDC, { 0xD0, 0xBA },
	0xACDD, { 0xD0, 0xBB },
	0xACDE, { 0xD0, 0xBC },
	0xACDF, { 0xD0, 0xBD },
	0xACE0, { 0xD0, 0xBE },
	0xACE1, { 0xD0, 0xBF },
	0xACE2, { 0xD1, 0x80 },
	0xACE3, { 0xD1, 0x81 },
	0xACE4, { 0xD1, 0x82 },
	0xACE5, { 0xD1, 0x83 },
	0xACE6, { 0xD1, 0x84 },
	0xACE7, { 0xD1, 0x85 },
	0xACE8, { 0xD1, 0x86 },
	0xACE9, { 0xD1, 0x87 },
	0xACEA, { 0xD1, 0x88 },
	0xACEB, { 0xD1, 0x89 },
	0xACEC, { 0xD1, 0x8A },
	0xACED, { 0xD1, 0x8B },
	0xACEE, { 0xD1, 0x8C },
	0xACEF, { 0xD1, 0x8D },
	0xACF0, { 0xD1, 0x8E },
	0xACF1, { 0xD1, 0x8F },
	0xB0A1, { 0xEA, 0xB0, 0x80 },
	0xB0A2, { 0xEA, 0xB0, 0x81 },
	0xB0A3, { 0xEA, 0xB0, 0x84 },
	0xB0A4, { 0xEA, 0xB0, 0x87 },
	0xB0A5, { 0xEA, 0xB0, 0x88 },
	0xB0A6, { 0xEA, 0xB0, 0x89 },
	0xB0A7, { 0xEA, 0xB0, 0x8A },
	0xB0A8, { 0xEA, 0xB0, 0x90 },
	0xB0A9, { 0xEA, 0xB0, 0x91 },
	0xB0AA, { 0xEA, 0xB0, 0x92 },
	0xB0AB, { 0xEA, 0xB0, 0x93 },
	0xB0AC, { 0xEA, 0xB0, 0x94 },
	0xB0AD, { 0xEA, 0xB0, 0x95 },
	0xB0AE, { 0xEA, 0xB0, 0x96 },
	0xB0AF, { 0xEA, 0xB0, 0x97 },
	0xB0B0, { 0xEA, 0xB0, 0x99 },
	0xB0B1, { 0xEA, 0xB0, 0x9A },
	0xB0B2, { 0xEA, 0xB0, 0x9B },
	0xB0B3, { 0xEA, 0xB0, 0x9C },
	0xB0B4, { 0xEA, 0xB0, 0x9D },
	0xB0B5, { 0xEA, 0xB0, 0xA0 },
	0xB0B6, { 0xEA, 0xB0, 0xA4 },
	0xB0B7, { 0xEA, 0xB0, 0xAC },
	0xB0B8, { 0xEA, 0xB0, 0xAD },
	0xB0B9, { 0xEA, 0xB0, 0xAF },
	0xB0BA, { 0xEA, 0xB0, 0xB0 },
	0xB0BB, { 0xEA, 0xB0, 0xB1 },
	0xB0BC, { 0xEA, 0xB0, 0xB8 },
	0xB0BD, { 0xEA, 0xB0, 0xB9 },
	0xB0BE, { 0xEA, 0xB0, 0xBC },
	0xB0BF, { 0xEA, 0xB1, 0x80 },
	0xB0C0, { 0xEA, 0xB1, 0x8B },
	0xB0C1, { 0xEA, 0xB1, 0x8D },
	0xB0C2, { 0xEA, 0xB1, 0x94 },
	0xB0C3, { 0xEA, 0xB1, 0x98 },
	0xB0C4, { 0xEA, 0xB1, 0x9C },
	0xB0C5, { 0xEA, 0xB1, 0xB0 },
	0xB0C6, { 0xEA, 0xB1, 0xB1 },
	0xB0C7, { 0xEA, 0xB1, 0xB4 },
	0xB0C8, { 0xEA, 0xB1, 0xB7 },
	0xB0C9, { 0xEA, 0xB1, 0xB8 },
	0xB0CA, { 0xEA, 0xB1, 0xBA },
	0xB0CB, { 0xEA, 0xB2, 0x80 },
	0xB0CC, { 0xEA, 0xB2, 0x81 },
	0xB0CD, { 0xEA, 0xB2, 0x83 },
	0xB0CE, { 0xEA, 0xB2, 0x84 },
	0xB0CF, { 0xEA, 0xB2, 0x85 },
	0xB0D0, { 0xEA, 0xB2, 0x86 },
	0xB0D1, { 0xEA, 0xB2, 0x89 },
	0xB0D2, { 0xEA, 0xB2, 0x8A },
	0xB0D3, { 0xEA, 0xB2, 0x8B },
	0xB0D4, { 0xEA, 0xB2, 0x8C },
	0xB0D5, { 0xEA, 0xB2, 0x90 },
	0xB0D6, { 0xEA, 0xB2, 0x94 },
	0xB0D7, { 0xEA, 0xB2, 0x9C },
	0xB0D8, { 0xEA, 0xB2, 0x9D },
	0xB0D9, { 0xEA, 0xB2, 0x9F },
	0xB0DA, { 0xEA, 0xB2, 0xA0 },
	0xB0DB, { 0xEA, 0xB2, 0xA1 },
	0xB0DC, { 0xEA, 0xB2, 0xA8 },
	0xB0DD, { 0xEA, 0xB2, 0xA9 },
	0xB0DE, { 0xEA, 0xB2, 0xAA },
	0xB0DF, { 0xEA, 0xB2, 0xAC },
	0xB0E0, { 0xEA, 0xB2, 0xAF },
	0xB0E1, { 0xEA, 0xB2, 0xB0 },
	0xB0E2, { 0xEA, 0xB2, 0xB8 },
	0xB0E3, { 0xEA, 0xB2, 0xB9 },
	0xB0E4, { 0xEA, 0xB2, 0xBB },
	0xB0E5, { 0xEA, 0xB2, 0xBC },
	0xB0E6, { 0xEA, 0xB2, 0xBD },
	0xB0E7, { 0xEA, 0xB3, 0x81 },
	0xB0E8, { 0xEA, 0xB3, 0x84 },
	0xB0E9, { 0xEA, 0xB3, 0x88 },
	0xB0EA, { 0xEA, 0xB3, 0x8C },
	0xB0EB, { 0xEA, 0xB3, 0x95 },
	0xB0EC, { 0xEA, 0xB3, 0x97 },
	0xB0ED, { 0xEA, 0xB3, 0xA0 },
	0xB0EE, { 0xEA, 0xB3, 0xA1 },
	0xB0EF, { 0xEA, 0xB3, 0xA4 },
	0xB0F0, { 0xEA, 0xB3, 0xA7 },
	0xB0F1, { 0xEA, 0xB3, 0xA8 },
	0xB0F2, { 0xEA, 0xB3, 0xAA },
	0xB0F3, { 0xEA, 0xB3, 0xAC },
	0xB0F4, { 0xEA, 0xB3, 0xAF },
	0xB0F5, { 0xEA, 0xB3, 0xB0 },
	0xB0F6, { 0xEA, 0xB3, 0xB1 },
	0xB0F7, { 0xEA, 0xB3, 0xB3 },
	0xB0F8, { 0xEA, 0xB3, 0xB5 },
	0xB0F9, { 0xEA, 0xB3, 0xB6 },
	0xB0FA, { 0xEA, 0xB3, 0xBC },
	0xB0FB, { 0xEA, 0xB3, 0xBD },
	0xB0FC, { 0xEA, 0xB4, 0x80 },
	0xB0FD, { 0xEA, 0xB4, 0x84 },
	0xB0FE, { 0xEA, 0xB4, 0x86 },
	0xB1A1, { 0xEA, 0xB4, 0x8C },
	0xB1A2, { 0xEA, 0xB4, 0x8D },
	0xB1A3, { 0xEA, 0xB4, 0x8F },
	0xB1A4, { 0xEA, 0xB4, 0x91 },
	0xB1A5, { 0xEA, 0xB4, 0x98 },
	0xB1A6, { 0xEA, 0xB4, 0x9C },
	0xB1A7, { 0xEA, 0xB4, 0xA0 },
	0xB1A8, { 0xEA, 0xB4, 0xA9 },
	0xB1A9, { 0xEA, 0xB4, 0xAC },
	0xB1AA, { 0xEA, 0xB4, 0xAD },
	0xB1AB, { 0xEA, 0xB4, 0xB4 },
	0xB1AC, { 0xEA, 0xB4, 0xB5 },
	0xB1AD, { 0xEA, 0xB4, 0xB8 },
	0xB1AE, { 0xEA, 0xB4, 0xBC },
	0xB1AF, { 0xEA, 0xB5, 0x84 },
	0xB1B0, { 0xEA, 0xB5, 0x85 },
	0xB1B1, { 0xEA, 0xB5, 0x87 },
	0xB1B2, { 0xEA, 0xB5, 0x89 },
	0xB1B3, { 0xEA, 0xB5, 0x90 },
	0xB1B4, { 0xEA, 0xB5, 0x94 },
	0xB1B5, { 0xEA, 0xB5, 0x98 },
	0xB1B6, { 0xEA, 0xB5, 0xA1 },
	0xB1B7, { 0xEA, 0xB5, 0xA3 },
	0xB1B8, { 0xEA, 0xB5, 0xAC },
	0xB1B9, { 0xEA, 0xB5, 0xAD },
	0xB1BA, { 0xEA, 0xB5, 0xB0 },
	0xB1BB, { 0xEA, 0xB5, 0xB3 },
	0xB1BC, { 0xEA, 0xB5, 0xB4 },
	0xB1BD, { 0xEA, 0xB5, 0xB5 },
	0xB1BE, { 0xEA, 0xB5, 0xB6 },
	0xB1BF, { 0xEA, 0xB5, 0xBB },
	0xB1C0, { 0xEA, 0xB5, 0xBC },
	0xB1C1, { 0xEA, 0xB5, 0xBD },
	0xB1C2, { 0xEA, 0xB5, 0xBF },
	0xB1C3, { 0xEA, 0xB6, 0x81 },
	0xB1C4, { 0xEA, 0xB6, 0x82 },
	0xB1C5, { 0xEA, 0xB6, 0x88 },
	0xB1C6, { 0xEA, 0xB6, 0x89 },
	0xB1C7, { 0xEA, 0xB6, 0x8C },
	0xB1C8, { 0xEA, 0xB6, 0x90 },
	0xB1C9, { 0xEA, 0xB6, 0x9C },
	0xB1CA, { 0xEA, 0xB6, 0x9D },
	0xB1CB, { 0xEA, 0xB6, 0xA4 },
	0xB1CC, { 0xEA, 0xB6, 0xB7 },
	0xB1CD, { 0xEA, 0xB7, 0x80 },
	0xB1CE, { 0xEA, 0xB7, 0x81 },
	0xB1CF, { 0xEA, 0xB7, 0x84 },
	0xB1D0, { 0xEA, 0xB7, 0x88 },
	0xB1D1, { 0xEA, 0xB7, 0x90 },
	0xB1D2, { 0xEA, 0xB7, 0x91 },
	0xB1D3, { 0xEA, 0xB7, 0x93 },
	0xB1D4, { 0xEA, 0xB7, 0x9C },
	0xB1D5, { 0xEA, 0xB7, 0xA0 },
	0xB1D6, { 0xEA, 0xB7, 0xA4 },
	0xB1D7, { 0xEA, 0xB7, 0xB8 },
	0xB1D8, { 0xEA, 0xB7, 0xB9 },
	0xB1D9, { 0xEA, 0xB7, 0xBC },
	0xB1DA, { 0xEA, 0xB7, 0xBF },
	0xB1DB, { 0xEA, 0xB8, 0x80 },
	0xB1DC, { 0xEA, 0xB8, 0x81 },
	0xB1DD, { 0xEA, 0xB8, 0x88 },
	0xB1DE, { 0xEA, 0xB8, 0x89 },
	0xB1DF, { 0xEA, 0xB8, 0x8B },
	0xB1E0, { 0xEA, 0xB8, 0x8D },
	0xB1E1, { 0xEA, 0xB8, 0x94 },
	0xB1E2, { 0xEA, 0xB8, 0xB0 },
	0xB1E3, { 0xEA, 0xB8, 0xB1 },
	0xB1E4, { 0xEA, 0xB8, 0xB4 },
	0xB1E5, { 0xEA, 0xB8, 0xB7 },
	0xB1E6, { 0xEA, 0xB8, 0xB8 },
	0xB1E7, { 0xEA, 0xB8, 0xBA },
	0xB1E8, { 0xEA, 0xB9, 0x80 },
	0xB1E9, { 0xEA, 0xB9, 0x81 },
	0xB1EA, { 0xEA, 0xB9, 0x83 },
	0xB1EB, { 0xEA, 0xB9, 0x85 },
	0xB1EC, { 0xEA, 0xB9, 0x86 },
	0xB1ED, { 0xEA, 0xB9, 0x8A },
	0xB1EE, { 0xEA, 0xB9, 0x8C },
	0xB1EF, { 0xEA, 0xB9, 0x8D },
	0xB1F0, { 0xEA, 0xB9, 0x8E },
	0xB1F1, { 0xEA, 0xB9, 0x90 },
	0xB1F2, { 0xEA, 0xB9, 0x94 },
	0xB1F3, { 0xEA, 0xB9, 0x96 },
	0xB1F4, { 0xEA, 0xB9, 0x9C },
	0xB1F5, { 0xEA, 0xB9, 0x9D },
	0xB1F6, { 0xEA, 0xB9, 0x9F },
	0xB1F7, { 0xEA, 0xB9, 0xA0 },
	0xB1F8, { 0xEA, 0xB9, 0xA1 },
	0xB1F9, { 0xEA, 0xB9, 0xA5 },
	0xB1FA, { 0xEA, 0xB9, 0xA8 },
	0xB1FB, { 0xEA, 0xB9, 0xA9 },
	0xB1FC, { 0xEA, 0xB9, 0xAC },
	0xB1FD, { 0xEA, 0xB9, 0xB0 },
	0xB1FE, { 0xEA, 0xB9, 0xB8 },
	0xB2A1, { 0xEA, 0xB9, 0xB9 },
	0xB2A2, { 0xEA, 0xB9, 0xBB },
	0xB2A3, { 0xEA, 0xB9, 0xBC },
	0xB2A4, { 0xEA, 0xB9, 0xBD },
	0xB2A5, { 0xEA, 0xBA, 0x84 },
	0xB2A6, { 0xEA, 0xBA, 0x85 },
	0xB2A7, { 0xEA, 0xBA, 0x8C },
	0xB2A8, { 0xEA, 0xBA, 0xBC },
	0xB2A9, { 0xEA, 0xBA, 0xBD },
	0xB2AA, { 0xEA, 0xBA, 0xBE },
	0xB2AB, { 0xEA, 0xBB, 0x80 },
	0xB2AC, { 0xEA, 0xBB, 0x84 },
	0xB2AD, { 0xEA, 0xBB, 0x8C },
	0xB2AE, { 0xEA, 0xBB, 0x8D },
	0xB2AF, { 0xEA, 0xBB, 0x8F },
	0xB2B0, { 0xEA, 0xBB, 0x90 },
	0xB2B1, { 0xEA, 0xBB, 0x91 },
	0xB2B2, { 0xEA, 0xBB, 0x98 },
	0xB2B3, { 0xEA, 0xBB, 0x99 },
	0xB2B4, { 0xEA, 0xBB, 0x9C },
	0xB2B5, { 0xEA, 0xBB, 0xA8 },
	0xB2B6, { 0xEA, 0xBB, 0xAB },
	0xB2B7, { 0xEA, 0xBB, 0xAD },
	0xB2B8, { 0xEA, 0xBB, 0xB4 },
	0xB2B9, { 0xEA, 0xBB, 0xB8 },
	0xB2BA, { 0xEA, 0xBB, 0xBC },
	0xB2BB, { 0xEA, 0xBC, 0x87 },
	0xB2BC, { 0xEA, 0xBC, 0x88 },
	0xB2BD, { 0xEA, 0xBC, 0x8D },
	0xB2BE, { 0xEA, 0xBC, 0x90 },
	0xB2BF, { 0xEA, 0xBC, 0xAC },
	0xB2C0, { 0xEA, 0xBC, 0xAD },
	0xB2C1, { 0xEA, 0xBC, 0xB0 },
	0xB2C2, { 0xEA, 0xBC, 0xB2 },
	0xB2C3, { 0xEA, 0xBC, 0xB4 },
	0xB2C4, { 0xEA, 0xBC, 0xBC },
	0xB2C5, { 0xEA, 0xBC, 0xBD },
	0xB2C6, { 0xEA, 0xBC, 0xBF },
	0xB2C7, { 0xEA, 0xBD, 0x81 },
	0xB2C8, { 0xEA, 0xBD, 0x82 },
	0xB2C9, { 0xEA, 0xBD, 0x83 },
	0xB2CA, { 0xEA, 0xBD, 0x88 },
	0xB2CB, { 0xEA, 0xBD, 0x89 },
	0xB2CC, { 0xEA, 0xBD, 0x90 },
	0xB2CD, { 0xEA, 0xBD, 0x9C },
	0xB2CE, { 0xEA, 0xBD, 0x9D },
	0xB2CF, { 0xEA, 0xBD, 0xA4 },
	0xB2D0, { 0xEA, 0xBD, 0xA5 },
	0xB2D1, { 0xEA, 0xBD, 0xB9 },
	0xB2D2, { 0xEA, 0xBE, 0x80 },
	0xB2D3, { 0xEA, 0xBE, 0x84 },
	0xB2D4, { 0xEA, 0xBE, 0x88 },
	0xB2D5, { 0xEA, 0xBE, 0x90 },
	0xB2D6, { 0xEA, 0xBE, 0x91 },
	0xB2D7, { 0xEA, 0xBE, 0x95 },
	0xB2D8, { 0xEA, 0xBE, 0x9C },
	0xB2D9, { 0xEA, 0xBE, 0xB8 },
	0xB2DA, { 0xEA, 0xBE, 0xB9 },
	0xB2DB, { 0xEA, 0xBE, 0xBC },
	0xB2DC, { 0xEA, 0xBF, 0x80 },
	0xB2DD, { 0xEA, 0xBF, 0x87 },
	0xB2DE, { 0xEA, 0xBF, 0x88 },
	0xB2DF, { 0xEA, 0xBF, 0x89 },
	0xB2E0, { 0xEA, 0xBF, 0x8B },
	0xB2E1, { 0xEA, 0xBF, 0x8D },
	0xB2E2, { 0xEA, 0xBF, 0x8E },
	0xB2E3, { 0xEA, 0xBF, 0x94 },
	0xB2E4, { 0xEA, 0xBF, 0x9C },
	0xB2E5, { 0xEA, 0xBF, 0xA8 },
	0xB2E6, { 0xEA, 0xBF, 0xA9 },
	0xB2E7, { 0xEA, 0xBF, 0xB0 },
	0xB2E8, { 0xEA, 0xBF, 0xB1 },
	0xB2E9, { 0xEA, 0xBF, 0xB4 },
	0xB2EA, { 0xEA, 0xBF, 0xB8 },
	0xB2EB, { 0xEB, 0x80, 0x80 },
	0xB2EC, { 0xEB, 0x80, 0x81 },
	0xB2ED, { 0xEB, 0x80, 0x84 },
	0xB2EE, { 0xEB, 0x80, 0x8C },
	0xB2EF, { 0xEB, 0x80, 0x90 },
	0xB2F0, { 0xEB, 0x80, 0x94 },
	0xB2F1, { 0xEB, 0x80, 0x9C },
	0xB2F2, { 0xEB, 0x80, 0x9D },
	0xB2F3, { 0xEB, 0x80, 0xA8 },
	0xB2F4, { 0xEB, 0x81, 0x84 },
	0xB2F5, { 0xEB, 0x81, 0x85 },
	0xB2F6, { 0xEB, 0x81, 0x88 },
	0xB2F7, { 0xEB, 0x81, 0x8A },
	0xB2F8, { 0xEB, 0x81, 0x8C },
	0xB2F9, { 0xEB, 0x81, 0x8E },
	0xB2FA, { 0xEB, 0x81, 0x93 },
	0xB2FB, { 0xEB, 0x81, 0x94 },
	0xB2FC, { 0xEB, 0x81, 0x95 },
	0xB2FD, { 0xEB, 0x81, 0x97 },
	0xB2FE, { 0xEB, 0x81, 0x99 },
	0xB3A1, { 0xEB, 0x81, 0x9D },
	0xB3A2, { 0xEB, 0x81, 0xBC },
	0xB3A3, { 0xEB, 0x81, 0xBD },
	0xB3A4, { 0xEB, 0x82, 0x80 },
	0xB3A5, { 0xEB, 0x82, 0x84 },
	0xB3A6, { 0xEB, 0x82, 0x8C },
	0xB3A7, { 0xEB, 0x82, 0x8D },
	0xB3A8, { 0xEB, 0x82, 0x8F },
	0xB3A9, { 0xEB, 0x82, 0x91 },
	0xB3AA, { 0xEB, 0x82, 0x98 },
	0xB3AB, { 0xEB, 0x82, 0x99 },
	0xB3AC, { 0xEB, 0x82, 0x9A },
	0xB3AD, { 0xEB, 0x82, 0x9C },
	0xB3AE, { 0xEB, 0x82, 0x9F },
	0xB3AF, { 0xEB, 0x82, 0xA0 },
	0xB3B0, { 0xEB, 0x82, 0xA1 },
	0xB3B1, { 0xEB, 0x82, 0xA2 },
	0xB3B2, { 0xEB, 0x82, 0xA8 },
	0xB3B3, { 0xEB, 0x82, 0xA9 },
	0xB3B4, { 0xEB, 0x82, 0xAB },
	0xB3B5, { 0xEB, 0x82, 0xAC },
	0xB3B6, { 0xEB, 0x82, 0xAD },
	0xB3B7, { 0xEB, 0x82, 0xAE },
	0xB3B8, { 0xEB, 0x82, 0xAF },
	0xB3B9, { 0xEB, 0x82, 0xB1 },
	0xB3BA, { 0xEB, 0x82, 0xB3 },
	0xB3BB, { 0xEB, 0x82, 0xB4 },
	0xB3BC, { 0xEB, 0x82, 0xB5 },
	0xB3BD, { 0xEB, 0x82, 0xB8 },
	0xB3BE, { 0xEB, 0x82, 0xBC },
	0xB3BF, { 0xEB, 0x83, 0x84 },
	0xB3C0, { 0xEB, 0x83, 0x85 },
	0xB3C1, { 0xEB, 0x83, 0x87 },
	0xB3C2, { 0xEB, 0x83, 0x88 },
	0xB3C3, { 0xEB, 0x83, 0x89 },
	0xB3C4, { 0xEB, 0x83, 0x90 },
	0xB3C5, { 0xEB, 0x83, 0x91 },
	0xB3C6, { 0xEB, 0x83, 0x94 },
	0xB3C7, { 0xEB, 0x83, 0x98 },
	0xB3C8, { 0xEB, 0x83, 0xA0 },
	0xB3C9, { 0xEB, 0x83, 0xA5 },
	0xB3CA, { 0xEB, 0x84, 0x88 },
	0xB3CB, { 0xEB, 0x84, 0x89 },
	0xB3CC, { 0xEB, 0x84, 0x8B },
	0xB3CD, { 0xEB, 0x84, 0x8C },
	0xB3CE, { 0xEB, 0x84, 0x90 },
	0xB3CF, { 0xEB, 0x84, 0x92 },
	0xB3D0, { 0xEB, 0x84, 0x93 },
	0xB3D1, { 0xEB, 0x84, 0x98 },
	0xB3D2, { 0xEB, 0x84, 0x99 },
	0xB3D3, { 0xEB, 0x84, 0x9B },
	0xB3D4, { 0xEB, 0x84, 0x9C },
	0xB3D5, { 0xEB, 0x84, 0x9D },
	0xB3D6, { 0xEB, 0x84, 0xA3 },
	0xB3D7, { 0xEB, 0x84, 0xA4 },
	0xB3D8, { 0xEB, 0x84, 0xA5 },
	0xB3D9, { 0xEB, 0x84, 0xA8 },
	0xB3DA, { 0xEB, 0x84, 0xAC },
	0xB3DB, { 0xEB, 0x84, 0xB4 },
	0xB3DC, { 0xEB, 0x84, 0xB5 },
	0xB3DD, { 0xEB, 0x84, 0xB7 },
	0xB3DE, { 0xEB, 0x84, 0xB8 },
	0xB3DF, { 0xEB, 0x84, 0xB9 },
	0xB3E0, { 0xEB, 0x85, 0x80 },
	0xB3E1, { 0xEB, 0x85, 0x81 },
	0xB3E2, { 0xEB, 0x85, 0x84 },
	0xB3E3, { 0xEB, 0x85, 0x88 },
	0xB3E4, { 0xEB, 0x85, 0x90 },
	0xB3E5, { 0xEB, 0x85, 0x91 },
	0xB3E6, { 0xEB, 0x85, 0x94 },
	0xB3E7, { 0xEB, 0x85, 0x95 },
	0xB3E8, { 0xEB, 0x85, 0x98 },
	0xB3E9, { 0xEB, 0x85, 0x9C },
	0xB3EA, { 0xEB, 0x85, 0xA0 },
	0xB3EB, { 0xEB, 0x85, 0xB8 },
	0xB3EC, { 0xEB, 0x85, 0xB9 },
	0xB3ED, { 0xEB, 0x85, 0xBC },
	0xB3EE, { 0xEB, 0x86, 0x80 },
	0xB3EF, { 0xEB, 0x86, 0x82 },
	0xB3F0, { 0xEB, 0x86, 0x88 },
	0xB3F1, { 0xEB, 0x86, 0x89 },
	0xB3F2, { 0xEB, 0x86, 0x8B },
	0xB3F3, { 0xEB, 0x86, 0x8D },
	0xB3F4, { 0xEB, 0x86, 0x92 },
	0xB3F5, { 0xEB, 0x86, 0x93 },
	0xB3F6, { 0xEB, 0x86, 0x94 },
	0xB3F7, { 0xEB, 0x86, 0x98 },
	0xB3F8, { 0xEB, 0x86, 0x9C },
	0xB3F9, { 0xEB, 0x86, 0xA8 },
	0xB3FA, { 0xEB, 0x87, 0x8C },
	0xB3FB, { 0xEB, 0x87, 0x90 },
	0xB3FC, { 0xEB, 0x87, 0x94 },
	0xB3FD, { 0xEB, 0x87, 0x9C },
	0xB3FE, { 0xEB, 0x87, 0x9D },
	0xB4A1, { 0xEB, 0x87, 0x9F },
	0xB4A2, { 0xEB, 0x87, 0xA8 },
	0xB4A3, { 0xEB, 0x87, 0xA9 },
	0xB4A4, { 0xEB, 0x87, 0xAC },
	0xB4A5, { 0xEB, 0x87, 0xB0 },
	0xB4A6, { 0xEB, 0x87, 0xB9 },
	0xB4A7, { 0xEB, 0x87, 0xBB },
	0xB4A8, { 0xEB, 0x87, 0xBD },
	0xB4A9, { 0xEB, 0x88, 0x84 },
	0xB4AA, { 0xEB, 0x88, 0x85 },
	0xB4AB, { 0xEB, 0x88, 0x88 },
	0xB4AC, { 0xEB, 0x88, 0x8B },
	0xB4AD, { 0xEB, 0x88, 0x8C },
	0xB4AE, { 0xEB, 0x88, 0x94 },
	0xB4AF, { 0xEB, 0x88, 0x95 },
	0xB4B0, { 0xEB, 0x88, 0x97 },
	0xB4B1, { 0xEB, 0x88, 0x99 },
	0xB4B2, { 0xEB, 0x88, 0xA0 },
	0xB4B3, { 0xEB, 0x88, 0xB4 },
	0xB4B4, { 0xEB, 0x88, 0xBC },
	0xB4B5, { 0xEB, 0x89, 0x98 },
	0xB4B6, { 0xEB, 0x89, 0x9C },
	0xB4B7, { 0xEB, 0x89, 0xA0 },
	0xB4B8, { 0xEB, 0x89, 0xA8 },
	0xB4B9, { 0xEB, 0x89, 0xA9 },
	0xB4BA, { 0xEB, 0x89, 0xB4 },
	0xB4BB, { 0xEB, 0x89, 0xB5 },
	0xB4BC, { 0xEB, 0x89, 0xBC },
	0xB4BD, { 0xEB, 0x8A, 0x84 },
	0xB4BE, { 0xEB, 0x8A, 0x85 },
	0xB4BF, { 0xEB, 0x8A, 0x89 },
	0xB4C0, { 0xEB, 0x8A, 0x90 },
	0xB4C1, { 0xEB, 0x8A, 0x91 },
	0xB4C2, { 0xEB, 0x8A, 0x94 },
	0xB4C3, { 0xEB, 0x8A, 0x98 },
	0xB4C4, { 0xEB, 0x8A, 0x99 },
	0xB4C5, { 0xEB, 0x8A, 0x9A },
	0xB4C6, { 0xEB, 0x8A, 0xA0 },
	0xB4C7, { 0xEB, 0x8A, 0xA1 },
	0xB4C8, { 0xEB, 0x8A, 0xA3 },
	0xB4C9, { 0xEB, 0x8A, 0xA5 },
	0xB4CA, { 0xEB, 0x8A, 0xA6 },
	0xB4CB, { 0xEB, 0x8A, 0xAA },
	0xB4CC, { 0xEB, 0x8A, 0xAC },
	0xB4CD, { 0xEB, 0x8A, 0xB0 },
	0xB4CE, { 0xEB, 0x8A, 0xB4 },
	0xB4CF, { 0xEB, 0x8B, 0x88 },
	0xB4D0, { 0xEB, 0x8B, 0x89 },
	0xB4D1, { 0xEB, 0x8B, 0x8C },
	0xB4D2, { 0xEB, 0x8B, 0x90 },
	0xB4D3, { 0xEB, 0x8B, 0x92 },
	0xB4D4, { 0xEB, 0x8B, 0x98 },
	0xB4D5, { 0xEB, 0x8B, 0x99 },
	0xB4D6, { 0xEB, 0x8B, 0x9B },
	0xB4D7, { 0xEB, 0x8B, 0x9D },
	0xB4D8, { 0xEB, 0x8B, 0xA2 },
	0xB4D9, { 0xEB, 0x8B, 0xA4 },
	0xB4DA, { 0xEB, 0x8B, 0xA5 },
	0xB4DB, { 0xEB, 0x8B, 0xA6 },
	0xB4DC, { 0xEB, 0x8B, 0xA8 },
	0xB4DD, { 0xEB, 0x8B, 0xAB },
	0xB4DE, { 0xEB, 0x8B, 0xAC },
	0xB4DF, { 0xEB, 0x8B, 0xAD },
	0xB4E0, { 0xEB, 0x8B, 0xAE },
	0xB4E1, { 0xEB, 0x8B, 0xAF },
	0xB4E2, { 0xEB, 0x8B, 0xB3 },
	0xB4E3, { 0xEB, 0x8B, 0xB4 },
	0xB4E4, { 0xEB, 0x8B, 0xB5 },
	0xB4E5, { 0xEB, 0x8B, 0xB7 },
	0xB4E6, { 0xEB, 0x8B, 0xB8 },
	0xB4E7, { 0xEB, 0x8B, 0xB9 },
	0xB4E8, { 0xEB, 0x8B, 0xBA },
	0xB4E9, { 0xEB, 0x8B, 0xBB },
	0xB4EA, { 0xEB, 0x8B, 0xBF },
	0xB4EB, { 0xEB, 0x8C, 0x80 },
	0xB4EC, { 0xEB, 0x8C, 0x81 },
	0xB4ED, { 0xEB, 0x8C, 0x84 },
	0xB4EE, { 0xEB, 0x8C, 0x88 },
	0xB4EF, { 0xEB, 0x8C, 0x90 },
	0xB4F0, { 0xEB, 0x8C, 0x91 },
	0xB4F1, { 0xEB, 0x8C, 0x93 },
	0xB4F2, { 0xEB, 0x8C, 0x94 },
	0xB4F3, { 0xEB, 0x8C, 0x95 },
	0xB4F4, { 0xEB, 0x8C, 0x9C },
	0xB4F5, { 0xEB, 0x8D, 0x94 },
	0xB4F6, { 0xEB, 0x8D, 0x95 },
	0xB4F7, { 0xEB, 0x8D, 0x96 },
	0xB4F8, { 0xEB, 0x8D, 0x98 },
	0xB4F9, { 0xEB, 0x8D, 0x9B },
	0xB4FA, { 0xEB, 0x8D, 0x9C },
	0xB4FB, { 0xEB, 0x8D, 0x9E },
	0xB4FC, { 0xEB, 0x8D, 0x9F },
	0xB4FD, { 0xEB, 0x8D, 0xA4 },
	0xB4FE, { 0xEB, 0x8D, 0xA5 },
	0xB5A1, { 0xEB, 0x8D, 0xA7 },
	0xB5A2, { 0xEB, 0x8D, 0xA9 },
	0xB5A3, { 0xEB, 0x8D, 0xAB },
	0xB5A4, { 0xEB, 0x8D, 0xAE },
	0xB5A5, { 0xEB, 0x8D, 0xB0 },
	0xB5A6, { 0xEB, 0x8D, 0xB1 },
	0xB5A7, { 0xEB, 0x8D, 0xB4 },
	0xB5A8, { 0xEB, 0x8D, 0xB8 },
	0xB5A9, { 0xEB, 0x8E, 0x80 },
	0xB5AA, { 0xEB, 0x8E, 0x81 },
	0xB5AB, { 0xEB, 0x8E, 0x83 },
	0xB5AC, { 0xEB, 0x8E, 0x84 },
	0xB5AD, { 0xEB, 0x8E, 0x85 },
	0xB5AE, { 0xEB, 0x8E, 0x8C },
	0xB5AF, { 0xEB, 0x8E, 0x90 },
	0xB5B0, { 0xEB, 0x8E, 0x94 },
	0xB5B1, { 0xEB, 0x8E, 0xA0 },
	0xB5B2, { 0xEB, 0x8E, 0xA1 },
	0xB5B3, { 0xEB, 0x8E, 0xA8 },
	0xB5B4, { 0xEB, 0x8E, 0xAC },
	0xB5B5, { 0xEB, 0x8F, 0x84 },
	0xB5B6, { 0xEB, 0x8F, 0x85 },
	0xB5B7, { 0xEB, 0x8F, 0x88 },
	0xB5B8, { 0xEB, 0x8F, 0x8B },
	0xB5B9, { 0xEB, 0x8F, 0x8C },
	0xB5BA, { 0xEB, 0x8F, 0x8E },
	0xB5BB, { 0xEB, 0x8F, 0x90 },
	0xB5BC, { 0xEB, 0x8F, 0x94 },
	0xB5BD, { 0xEB, 0x8F, 0x95 },
	0xB5BE, { 0xEB, 0x8F, 0x97 },
	0xB5BF, { 0xEB, 0x8F, 0x99 },
	0xB5C0, { 0xEB, 0x8F, 0x9B },
	0xB5C1, { 0xEB, 0x8F, 0x9D },
	0xB5C2, { 0xEB, 0x8F, 0xA0 },
	0xB5C3, { 0xEB, 0x8F, 0xA4 },
	0xB5C4, { 0xEB, 0x8F, 0xA8 },
	0xB5C5, { 0xEB, 0x8F, 0xBC },
	0xB5C6, { 0xEB, 0x90, 0x90 },
	0xB5C7, { 0xEB, 0x90, 0x98 },
	0xB5C8, { 0xEB, 0x90, 0x9C },
	0xB5C9, { 0xEB, 0x90, 0xA0 },
	0xB5CA, { 0xEB, 0x90, 0xA8 },
	0xB5CB, { 0xEB, 0x90, 0xA9 },
	0xB5CC, { 0xEB, 0x90, 0xAB },
	0xB5CD, { 0xEB, 0x90, 0xB4 },
	0xB5CE, { 0xEB, 0x91, 0x90 },
	0xB5CF, { 0xEB, 0x91, 0x91 },
	0xB5D0, { 0xEB, 0x91, 0x94 },
	0xB5D1, { 0xEB, 0x91, 0x98 },
	0xB5D2, { 0xEB, 0x91, 0xA0 },
	0xB5D3, { 0xEB, 0x91, 0xA1 },
	0xB5D4, { 0xEB, 0x91, 0xA3 },
	0xB5D5, { 0xEB, 0x91, 0xA5 },
	0xB5D6, { 0xEB, 0x91, 0xAC },
	0xB5D7, { 0xEB, 0x92, 0x80 },
	0xB5D8, { 0xEB, 0x92, 0x88 },
	0xB5D9, { 0xEB, 0x92, 0x9D },
	0xB5DA, { 0xEB, 0x92, 0xA4 },
	0xB5DB, { 0xEB, 0x92, 0xA8 },
	0xB5DC, { 0xEB, 0x92, 0xAC },
	0xB5DD, { 0xEB, 0x92, 0xB5 },
	0xB5DE, { 0xEB, 0x92, 0xB7 },
	0xB5DF, { 0xEB, 0x92, 0xB9 },
	0xB5E0, { 0xEB, 0x93, 0x80 },
	0xB5E1, { 0xEB, 0x93, 0x84 },
	0xB5E2, { 0xEB, 0x93, 0x88 },
	0xB5E3, { 0xEB, 0x93, 0x90 },
	0xB5E4, { 0xEB, 0x93, 0x95 },
	0xB5E5, { 0xEB, 0x93, 0x9C },
	0xB5E6, { 0xEB, 0x93, 0x9D },
	0xB5E7, { 0xEB, 0x93, 0xA0 },
	0xB5E8, { 0xEB, 0x93, 0xA3 },
	0xB5E9, { 0xEB, 0x93, 0xA4 },
	0xB5EA, { 0xEB, 0x93, 0xA6 },
	0xB5EB, { 0xEB, 0x93, 0xAC },
	0xB5EC, { 0xEB, 0x93, 0xAD },
	0xB5ED, { 0xEB, 0x93, 0xAF },
	0xB5EE, { 0xEB, 0x93, 0xB1 },
	0xB5EF, { 0xEB, 0x93, 0xB8 },
	0xB5F0, { 0xEB, 0x94, 0x94 },
	0xB5F1, { 0xEB, 0x94, 0x95 },
	0xB5F2, { 0xEB, 0x94, 0x98 },
	0xB5F3, { 0xEB, 0x94, 0x9B },
	0xB5F4, { 0xEB, 0x94, 0x9C },
	0xB5F5, { 0xEB, 0x94, 0xA4 },
	0xB5F6, { 0xEB, 0x94, 0xA5 },
	0xB5F7, { 0xEB, 0x94, 0xA7 },
	0xB5F8, { 0xEB, 0x94, 0xA8 },
	0xB5F9, { 0xEB, 0x94, 0xA9 },
	0xB5FA, { 0xEB, 0x94, 0xAA },
	0xB5FB, { 0xEB, 0x94, 0xB0 },
	0xB5FC, { 0xEB, 0x94, 0xB1 },
	0xB5FD, { 0xEB, 0x94, 0xB4 },
	0xB5FE, { 0xEB, 0x94, 0xB8 },
	0xB6A1, { 0xEB, 0x95, 0x80 },
	0xB6A2, { 0xEB, 0x95, 0x81 },
	0xB6A3, { 0xEB, 0x95, 0x83 },
	0xB6A4, { 0xEB, 0x95, 0x84 },
	0xB6A5, { 0xEB, 0x95, 0x85 },
	0xB6A6, { 0xEB, 0x95, 0x8B },
	0xB6A7, { 0xEB, 0x95, 0x8C },
	0xB6A8, { 0xEB, 0x95, 0x8D },
	0xB6A9, { 0xEB, 0x95, 0x90 },
	0xB6AA, { 0xEB, 0x95, 0x94 },
	0xB6AB, { 0xEB, 0x95, 0x9C },
	0xB6AC, { 0xEB, 0x95, 0x9D },
	0xB6AD, { 0xEB, 0x95, 0x9F },
	0xB6AE, { 0xEB, 0x95, 0xA0 },
	0xB6AF, { 0xEB, 0x95, 0xA1 },
	0xB6B0, { 0xEB, 0x96, 0xA0 },
	0xB6B1, { 0xEB, 0x96, 0xA1 },
	0xB6B2, { 0xEB, 0x96, 0xA4 },
	0xB6B3, { 0xEB, 0x96, 0xA8 },
	0xB6B4, { 0xEB, 0x96, 0xAA },
	0xB6B5, { 0xEB, 0x96, 0xAB },
	0xB6B6, { 0xEB, 0x96, 0xB0 },
	0xB6B7, { 0xEB, 0x96, 0xB1 },
	0xB6B8, { 0xEB, 0x96, 0xB3 },
	0xB6B9, { 0xEB, 0x96, 0xB4 },
	0xB6BA, { 0xEB, 0x96, 0xB5 },
	0xB6BB, { 0xEB, 0x96, 0xBB },
	0xB6BC, { 0xEB, 0x96, 0xBC },
	0xB6BD, { 0xEB, 0x96, 0xBD },
	0xB6BE, { 0xEB, 0x97, 0x80 },
	0xB6BF, { 0xEB, 0x97, 0x84 },
	0xB6C0, { 0xEB, 0x97, 0x8C },
	0xB6C1, { 0xEB, 0x97, 0x8D },
	0xB6C2, { 0xEB, 0x97, 0x8F },
	0xB6C3, { 0xEB, 0x97, 0x90 },
	0xB6C4, { 0xEB, 0x97, 0x91 },
	0xB6C5, { 0xEB, 0x97, 0x98 },
	0xB6C6, { 0xEB, 0x97, 0xAC },
	0xB6C7, { 0xEB, 0x98, 0x90 },
	0xB6C8, { 0xEB, 0x98, 0x91 },
	0xB6C9, { 0xEB, 0x98, 0x94 },
	0xB6CA, { 0xEB, 0x98, 0x98 },
	0xB6CB, { 0xEB, 0x98, 0xA5 },
	0xB6CC, { 0xEB, 0x98, 0xAC },
	0xB6CD, { 0xEB, 0x98, 0xB4 },
	0xB6CE, { 0xEB, 0x99, 0x88 },
	0xB6CF, { 0xEB, 0x99, 0xA4 },
	0xB6D0, { 0xEB, 0x99, 0xA8 },
	0xB6D1, { 0xEB, 0x9A, 0x9C },
	0xB6D2, { 0xEB, 0x9A, 0x9D },
	0xB6D3, { 0xEB, 0x9A, 0xA0 },
	0xB6D4, { 0xEB, 0x9A, 0xA4 },
	0xB6D5, { 0xEB, 0x9A, 0xAB },
	0xB6D6, { 0xEB, 0x9A, 0xAC },
	0xB6D7, { 0xEB, 0x9A, 0xB1 },
	0xB6D8, { 0xEB, 0x9B, 0x94 },
	0xB6D9, { 0xEB, 0x9B, 0xB0 },
	0xB6DA, { 0xEB, 0x9B, 0xB4 },
	0xB6DB, { 0xEB, 0x9B, 0xB8 },
	0xB6DC, { 0xEB, 0x9C, 0x80 },
	0xB6DD, { 0xEB, 0x9C, 0x81 },
	0xB6DE, { 0xEB, 0x9C, 0x85 },
	0xB6DF, { 0xEB, 0x9C, 0xA8 },
	0xB6E0, { 0xEB, 0x9C, 0xA9 },
	0xB6E1, { 0xEB, 0x9C, 0xAC },
	0xB6E2, { 0xEB, 0x9C, 0xAF },
	0xB6E3, { 0xEB, 0x9C, 0xB0 },
	0xB6E4, { 0xEB, 0x9C, 0xB8 },
	0xB6E5, { 0xEB, 0x9C, 0xB9 },
	0xB6E6, { 0xEB, 0x9C, 0xBB },
	0xB6E7, { 0xEB, 0x9D, 0x84 },
	0xB6E8, { 0xEB, 0x9D, 0x88 },
	0xB6E9, { 0xEB, 0x9D, 0x8C },
	0xB6EA, { 0xEB, 0x9D, 0x94 },
	0xB6EB, { 0xEB, 0x9D, 0x95 },
	0xB6EC, { 0xEB, 0x9D, 0xA0 },
	0xB6ED, { 0xEB, 0x9D, 0xA4 },
	0xB6EE, { 0xEB, 0x9D, 0xA8 },
	0xB6EF, { 0xEB, 0x9D, 0xB0 },
	0xB6F0, { 0xEB, 0x9D, 0xB1 },
	0xB6F1, { 0xEB, 0x9D, 0xB3 },
	0xB6F2, { 0xEB, 0x9D, 0xB5 },
	0xB6F3, { 0xEB, 0x9D, 0xBC },
	0xB6F4, { 0xEB, 0x9D, 0xBD },
	0xB6F5, { 0xEB, 0x9E, 0x80 },
	0xB6F6, { 0xEB, 0x9E, 0x84 },
	0xB6F7, { 0xEB, 0x9E, 0x8C },
	0xB6F8, { 0xEB, 0x9E, 0x8D },
	0xB6F9, { 0xEB, 0x9E, 0x8F },
	0xB6FA, { 0xEB, 0x9E, 0x90 },
	0xB6FB, { 0xEB, 0x9E, 0x91 },
	0xB6FC, { 0xEB, 0x9E, 0x92 },
	0xB6FD, { 0xEB, 0x9E, 0x96 },
	0xB6FE, { 0xEB, 0x9E, 0x97 },
	0xB7A1, { 0xEB, 0x9E, 0x98 },
	0xB7A2, { 0xEB, 0x9E, 0x99 },
	0xB7A3, { 0xEB, 0x9E, 0x9C },
	0xB7A4, { 0xEB, 0x9E, 0xA0 },
	0xB7A5, { 0xEB, 0x9E, 0xA8 },
	0xB7A6, { 0xEB, 0x9E, 0xA9 },
	0xB7A7, { 0xEB, 0x9E, 0xAB },
	0xB7A8, { 0xEB, 0x9E, 0xAC },
	0xB7A9, { 0xEB, 0x9E, 0xAD },
	0xB7AA, { 0xEB, 0x9E, 0xB4 },
	0xB7AB, { 0xEB, 0x9E, 0xB5 },
	0xB7AC, { 0xEB, 0x9E, 0xB8 },
	0xB7AD, { 0xEB, 0x9F, 0x87 },
	0xB7AE, { 0xEB, 0x9F, 0x89 },
	0xB7AF, { 0xEB, 0x9F, 0xAC },
	0xB7B0, { 0xEB, 0x9F, 0xAD },
	0xB7B1, { 0xEB, 0x9F, 0xB0 },
	0xB7B2, { 0xEB, 0x9F, 0xB4 },
	0xB7B3, { 0xEB, 0x9F, 0xBC },
	0xB7B4, { 0xEB, 0x9F, 0xBD },
	0xB7B5, { 0xEB, 0x9F, 0xBF },
	0xB7B6, { 0xEB, 0xA0, 0x80 },
	0xB7B7, { 0xEB, 0xA0, 0x81 },
	0xB7B8, { 0xEB, 0xA0, 0x87 },
	0xB7B9, { 0xEB, 0xA0, 0x88 },
	0xB7BA, { 0xEB, 0xA0, 0x89 },
	0xB7BB, { 0xEB, 0xA0, 0x8C },
	0xB7BC, { 0xEB, 0xA0, 0x90 },
	0xB7BD, { 0xEB, 0xA0, 0x98 },
	0xB7BE, { 0xEB, 0xA0, 0x99 },
	0xB7BF, { 0xEB, 0xA0, 0x9B },
	0xB7C0, { 0xEB, 0xA0, 0x9D },
	0xB7C1, { 0xEB, 0xA0, 0xA4 },
	0xB7C2, { 0xEB, 0xA0, 0xA5 },
	0xB7C3, { 0xEB, 0xA0, 0xA8 },
	0xB7C4, { 0xEB, 0xA0, 0xAC },
	0xB7C5, { 0xEB, 0xA0, 0xB4 },
	0xB7C6, { 0xEB, 0xA0, 0xB5 },
	0xB7C7, { 0xEB, 0xA0, 0xB7 },
	0xB7C8, { 0xEB, 0xA0, 0xB8 },
	0xB7C9, { 0xEB, 0xA0, 0xB9 },
	0xB7CA, { 0xEB, 0xA1, 0x80 },
	0xB7CB, { 0xEB, 0xA1, 0x84 },
	0xB7CC, { 0xEB, 0xA1, 0x91 },
	0xB7CD, { 0xEB, 0xA1, 0x93 },
	0xB7CE, { 0xEB, 0xA1, 0x9C },
	0xB7CF, { 0xEB, 0xA1, 0x9D },
	0xB7D0, { 0xEB, 0xA1, 0xA0 },
	0xB7D1, { 0xEB, 0xA1, 0xA4 },
	0xB7D2, { 0xEB, 0xA1, 0xAC },
	0xB7D3, { 0xEB, 0xA1, 0xAD },
	0xB7D4, { 0xEB, 0xA1, 0xAF },
	0xB7D5, { 0xEB, 0xA1, 0xB1 },
	0xB7D6, { 0xEB, 0xA1, 0xB8 },
	0xB7D7, { 0xEB, 0xA1, 0xBC },
	0xB7D8, { 0xEB, 0xA2, 0x8D },
	0xB7D9, { 0xEB, 0xA2, 0xA8 },
	0xB7DA, { 0xEB, 0xA2, 0xB0 },
	0xB7DB, { 0xEB, 0xA2, 0xB4 },
	0xB7DC, { 0xEB, 0xA2, 0xB8 },
	0xB7DD, { 0xEB, 0xA3, 0x80 },
	0xB7DE, { 0xEB, 0xA3, 0x81 },
	0xB7DF, { 0xEB, 0xA3, 0x83 },
	0xB7E0, { 0xEB, 0xA3, 0x85 },
	0xB7E1, { 0xEB, 0xA3, 0x8C },
	0xB7E2, { 0xEB, 0xA3, 0x90 },
	0xB7E3, { 0xEB, 0xA3, 0x94 },
	0xB7E4, { 0xEB, 0xA3, 0x9D },
	0xB7E5, { 0xEB, 0xA3, 0x9F },
	0xB7E6, { 0xEB, 0xA3, 0xA1 },
	0xB7E7, { 0xEB, 0xA3, 0xA8 },
	0xB7E8, { 0xEB, 0xA3, 0xA9 },
	0xB7E9, { 0xEB, 0xA3, 0xAC },
	0xB7EA, { 0xEB, 0xA3, 0xB0 },
	0xB7EB, { 0xEB, 0xA3, 0xB8 },
	0xB7EC, { 0xEB, 0xA3, 0xB9 },
	0xB7ED, { 0xEB, 0xA3, 0xBB },
	0xB7EE, { 0xEB, 0xA3, 0xBD },
	0xB7EF, { 0xEB, 0xA4, 0x84 },
	0xB7F0, { 0xEB, 0xA4, 0x98 },
	0xB7F1, { 0xEB, 0xA4, 0xA0 },
	0xB7F2, { 0xEB, 0xA4, 0xBC },
	0xB7F3, { 0xEB, 0xA4, 0xBD },
	0xB7F4, { 0xEB, 0xA5, 0x80 },
	0xB7F5, { 0xEB, 0xA5, 0x84 },
	0xB7F6, { 0xEB, 0xA5, 0x8C },
	0xB7F7, { 0xEB, 0xA5, 0x8F },
	0xB7F8, { 0xEB, 0xA5, 0x91 },
	0xB7F9, { 0xEB, 0xA5, 0x98 },
	0xB7FA, { 0xEB, 0xA5, 0x99 },
	0xB7FB, { 0xEB, 0xA5, 0x9C },
	0xB7FC, { 0xEB, 0xA5, 0xA0 },
	0xB7FD, { 0xEB, 0xA5, 0xA8 },
	0xB7FE, { 0xEB, 0xA5, 0xA9 },
	0xB8A1, { 0xEB, 0xA5, 0xAB },
	0xB8A2, { 0xEB, 0xA5, 0xAD },
	0xB8A3, { 0xEB, 0xA5, 0xB4 },
	0xB8A4, { 0xEB, 0xA5, 0xB5 },
	0xB8A5, { 0xEB, 0xA5, 0xB8 },
	0xB8A6, { 0xEB, 0xA5, 0xBC },
	0xB8A7, { 0xEB, 0xA6, 0x84 },
	0xB8A8, { 0xEB, 0xA6, 0x85 },
	0xB8A9, { 0xEB, 0xA6, 0x87 },
	0xB8AA, { 0xEB, 0xA6, 0x89 },
	0xB8AB, { 0xEB, 0xA6, 0x8A },
	0xB8AC, { 0xEB, 0xA6, 0x8D },
	0xB8AD, { 0xEB, 0xA6, 0x8E },
	0xB8AE, { 0xEB, 0xA6, 0xAC },
	0xB8AF, { 0xEB, 0xA6, 0xAD },
	0xB8B0, { 0xEB, 0xA6, 0xB0 },
	0xB8B1, { 0xEB, 0xA6, 0xB4 },
	0xB8B2, { 0xEB, 0xA6, 0xBC },
	0xB8B3, { 0xEB, 0xA6, 0xBD },
	0xB8B4, { 0xEB, 0xA6, 0xBF },
	0xB8B5, { 0xEB, 0xA7, 0x81 },
	0xB8B6, { 0xEB, 0xA7, 0x88 },
	0xB8B7, { 0xEB, 0xA7, 0x89 },
	0xB8B8, { 0xEB, 0xA7, 0x8C },
	0xB8B9, { 0xEB, 0xA7, 0x8E },
	0xB8BA, { 0xEB, 0xA7, 0x8F },
	0xB8BB, { 0xEB, 0xA7, 0x90 },
	0xB8BC, { 0xEB, 0xA7, 0x91 },
	0xB8BD, { 0xEB, 0xA7, 0x92 },
	0xB8BE, { 0xEB, 0xA7, 0x98 },
	0xB8BF, { 0xEB, 0xA7, 0x99 },
	0xB8C0, { 0xEB, 0xA7, 0x9B },
	0xB8C1, { 0xEB, 0xA7, 0x9D },
	0xB8C2, { 0xEB, 0xA7, 0x9E },
	0xB8C3, { 0xEB, 0xA7, 0xA1 },
	0xB8C4, { 0xEB, 0xA7, 0xA3 },
	0xB8C5, { 0xEB, 0xA7, 0xA4 },
	0xB8C6, { 0xEB, 0xA7, 0xA5 },
	0xB8C7, { 0xEB, 0xA7, 0xA8 },
	0xB8C8, { 0xEB, 0xA7, 0xAC },
	0xB8C9, { 0xEB, 0xA7, 0xB4 },
	0xB8CA, { 0xEB, 0xA7, 0xB5 },
	0xB8CB, { 0xEB, 0xA7, 0xB7 },
	0xB8CC, { 0xEB, 0xA7, 0xB8 },
	0xB8CD, { 0xEB, 0xA7, 0xB9 },
	0xB8CE, { 0xEB, 0xA7, 0xBA },
	0xB8CF, { 0xEB, 0xA8, 0x80 },
	0xB8D0, { 0xEB, 0xA8, 0x81 },
	0xB8D1, { 0xEB, 0xA8, 0x88 },
	0xB8D2, { 0xEB, 0xA8, 0x95 },
	0xB8D3, { 0xEB, 0xA8, 0xB8 },
	0xB8D4, { 0xEB, 0xA8, 0xB9 },
	0xB8D5, { 0xEB, 0xA8, 0xBC },
	0xB8D6, { 0xEB, 0xA9, 0x80 },
	0xB8D7, { 0xEB, 0xA9, 0x82 },
	0xB8D8, { 0xEB, 0xA9, 0x88 },
	0xB8D9, { 0xEB, 0xA9, 0x89 },
	0xB8DA, { 0xEB, 0xA9, 0x8B },
	0xB8DB, { 0xEB, 0xA9, 0x8D },
	0xB8DC, { 0xEB, 0xA9, 0x8E },
	0xB8DD, { 0xEB, 0xA9, 0x93 },
	0xB8DE, { 0xEB, 0xA9, 0x94 },
	0xB8DF, { 0xEB, 0xA9, 0x95 },
	0xB8E0, { 0xEB, 0xA9, 0x98 },
	0xB8E1, { 0xEB, 0xA9, 0x9C },
	0xB8E2, { 0xEB, 0xA9, 0xA4 },
	0xB8E3, { 0xEB, 0xA9, 0xA5 },
	0xB8E4, { 0xEB, 0xA9, 0xA7 },
	0xB8E5, { 0xEB, 0xA9, 0xA8 },
	0xB8E6, { 0xEB, 0xA9, 0xA9 },
	0xB8E7, { 0xEB, 0xA9, 0xB0 },
	0xB8E8, { 0xEB, 0xA9, 0xB1 },
	0xB8E9, { 0xEB, 0xA9, 0xB4 },
	0xB8EA, { 0xEB, 0xA9, 0xB8 },
	0xB8EB, { 0xEB, 0xAA, 0x83 },
	0xB8EC, { 0xEB, 0xAA, 0x84 },
	0xB8ED, { 0xEB, 0xAA, 0x85 },
	0xB8EE, { 0xEB, 0xAA, 0x87 },
	0xB8EF, { 0xEB, 0xAA, 0x8C },
	0xB8F0, { 0xEB, 0xAA, 0xA8 },
	0xB8F1, { 0xEB, 0xAA, 0xA9 },
	0xB8F2, { 0xEB, 0xAA, 0xAB },
	0xB8F3, { 0xEB, 0xAA, 0xAC },
	0xB8F4, { 0xEB, 0xAA, 0xB0 },
	0xB8F5, { 0xEB, 0xAA, 0xB2 },
	0xB8F6, { 0xEB, 0xAA, 0xB8 },
	0xB8F7, { 0xEB, 0xAA, 0xB9 },
	0xB8F8, { 0xEB, 0xAA, 0xBB },
	0xB8F9, { 0xEB, 0xAA, 0xBD },
	0xB8FA, { 0xEB, 0xAB, 0x84 },
	0xB8FB, { 0xEB, 0xAB, 0x88 },
	0xB8FC, { 0xEB, 0xAB, 0x98 },
	0xB8FD, { 0xEB, 0xAB, 0x99 },
	0xB8FE, { 0xEB, 0xAB, 0xBC },
	0xB9A1, { 0xEB, 0xAC, 0x80 },
	0xB9A2, { 0xEB, 0xAC, 0x84 },
	0xB9A3, { 0xEB, 0xAC, 0x8D },
	0xB9A4, { 0xEB, 0xAC, 0x8F },
	0xB9A5, { 0xEB, 0xAC, 0x91 },
	0xB9A6, { 0xEB, 0xAC, 0x98 },
	0xB9A7, { 0xEB, 0xAC, 0x9C },
	0xB9A8, { 0xEB, 0xAC, 0xA0 },
	0xB9A9, { 0xEB, 0xAC, 0xA9 },
	0xB9AA, { 0xEB, 0xAC, 0xAB },
	0xB9AB, { 0xEB, 0xAC, 0xB4 },
	0xB9AC, { 0xEB, 0xAC, 0xB5 },
	0xB9AD, { 0xEB, 0xAC, 0xB6 },
	0xB9AE, { 0xEB, 0xAC, 0xB8 },
	0xB9AF, { 0xEB, 0xAC, 0xBB },
	0xB9B0, { 0xEB, 0xAC, 0xBC },
	0xB9B1, { 0xEB, 0xAC, 0xBD },
	0xB9B2, { 0xEB, 0xAC, 0xBE },
	0xB9B3, { 0xEB, 0xAD, 0x84 },
	0xB9B4, { 0xEB, 0xAD, 0x85 },
	0xB9B5, { 0xEB, 0xAD, 0x87 },
	0xB9B6, { 0xEB, 0xAD, 0x89 },
	0xB9B7, { 0xEB, 0xAD, 0x8D },
	0xB9B8, { 0xEB, 0xAD, 0x8F },
	0xB9B9, { 0xEB, 0xAD, 0x90 },
	0xB9BA, { 0xEB, 0xAD, 0x94 },
	0xB9BB, { 0xEB, 0xAD, 0x98 },
	0xB9BC, { 0xEB, 0xAD, 0xA1 },
	0xB9BD, { 0xEB, 0xAD, 0xA3 },
	0xB9BE, { 0xEB, 0xAD, 0xAC },
	0xB9BF, { 0xEB, 0xAE, 0x88 },
	0xB9C0, { 0xEB, 0xAE, 0x8C },
	0xB9C1, { 0xEB, 0xAE, 0x90 },
	0xB9C2, { 0xEB, 0xAE, 0xA4 },
	0xB9C3, { 0xEB, 0xAE, 0xA8 },
	0xB9C4, { 0xEB, 0xAE, 0xAC },
	0xB9C5, { 0xEB, 0xAE, 0xB4 },
	0xB9C6, { 0xEB, 0xAE, 0xB7 },
	0xB9C7, { 0xEB, 0xAF, 0x80 },
	0xB9C8, { 0xEB, 0xAF, 0x84 },
	0xB9C9, { 0xEB, 0xAF, 0x88 },
	0xB9CA, { 0xEB, 0xAF, 0x90 },
	0xB9CB, { 0xEB, 0xAF, 0x93 },
	0xB9CC, { 0xEB, 0xAF, 0xB8 },
	0xB9CD, { 0xEB, 0xAF, 0xB9 },
	0xB9CE, { 0xEB, 0xAF, 0xBC },
	0xB9CF, { 0xEB, 0xAF, 0xBF },
	0xB9D0, { 0xEB, 0xB0, 0x80 },
	0xB9D1, { 0xEB, 0xB0, 0x82 },
	0xB9D2, { 0xEB, 0xB0, 0x88 },
	0xB9D3, { 0xEB, 0xB0, 0x89 },
	0xB9D4, { 0xEB, 0xB0, 0x8B },
	0xB9D5, { 0xEB, 0xB0, 0x8C },
	0xB9D6, { 0xEB, 0xB0, 0x8D },
	0xB9D7, { 0xEB, 0xB0, 0x8F },
	0xB9D8, { 0xEB, 0xB0, 0x91 },
	0xB9D9, { 0xEB, 0xB0, 0x94 },
	0xB9DA, { 0xEB, 0xB0, 0x95 },
	0xB9DB, { 0xEB, 0xB0, 0x96 },
	0xB9DC, { 0xEB, 0xB0, 0x97 },
	0xB9DD, { 0xEB, 0xB0, 0x98 },
	0xB9DE, { 0xEB, 0xB0, 0x9B },
	0xB9DF, { 0xEB, 0xB0, 0x9C },
	0xB9E0, { 0xEB, 0xB0, 0x9D },
	0xB9E1, { 0xEB, 0xB0, 0x9E },
	0xB9E2, { 0xEB, 0xB0, 0x9F },
	0xB9E3, { 0xEB, 0xB0, 0xA4 },
	0xB9E4, { 0xEB, 0xB0, 0xA5 },
	0xB9E5, { 0xEB, 0xB0, 0xA7 },
	0xB9E6, { 0xEB, 0xB0, 0xA9 },
	0xB9E7, { 0xEB, 0xB0, 0xAD },
	0xB9E8, { 0xEB, 0xB0, 0xB0 },
	0xB9E9, { 0xEB, 0xB0, 0xB1 },
	0xB9EA, { 0xEB, 0xB0, 0xB4 },
	0xB9EB, { 0xEB, 0xB0, 0xB8 },
	0xB9EC, { 0xEB, 0xB1, 0x80 },
	0xB9ED, { 0xEB, 0xB1, 0x81 },
	0xB9EE, { 0xEB, 0xB1, 0x83 },
	0xB9EF, { 0xEB, 0xB1, 0x84 },
	0xB9F0, { 0xEB, 0xB1, 0x85 },
	0xB9F1, { 0xEB, 0xB1, 0x89 },
	0xB9F2, { 0xEB, 0xB1, 0x8C },
	0xB9F3, { 0xEB, 0xB1, 0x8D },
	0xB9F4, { 0xEB, 0xB1, 0x90 },
	0xB9F5, { 0xEB, 0xB1, 0x9D },
	0xB9F6, { 0xEB, 0xB2, 0x84 },
	0xB9F7, { 0xEB, 0xB2, 0x85 },
	0xB9F8, { 0xEB, 0xB2, 0x88 },
	0xB9F9, { 0xEB, 0xB2, 0x8B },
	0xB9FA, { 0xEB, 0xB2, 0x8C },
	0xB9FB, { 0xEB, 0xB2, 0x8E },
	0xB9FC, { 0xEB, 0xB2, 0x94 },
	0xB9FD, { 0xEB, 0xB2, 0x95 },
	0xB9FE, { 0xEB, 0xB2, 0x97 },
	0xBAA1, { 0xEB, 0xB2, 0x99 },
	0xBAA2, { 0xEB, 0xB2, 0x9A },
	0xBAA3, { 0xEB, 0xB2, 0xA0 },
	0xBAA4, { 0xEB, 0xB2, 0xA1 },
	0xBAA5, { 0xEB, 0xB2, 0xA4 },
	0xBAA6, { 0xEB, 0xB2, 0xA7 },
	0xBAA7, { 0xEB, 0xB2, 0xA8 },
	0xBAA8, { 0xEB, 0xB2, 0xB0 },
	0xBAA9, { 0xEB, 0xB2, 0xB1 },
	0xBAAA, { 0xEB, 0xB2, 0xB3 },
	0xBAAB, { 0xEB, 0xB2, 0xB4 },
	0xBAAC, { 0xEB, 0xB2, 0xB5 },
	0xBAAD, { 0xEB, 0xB2, 0xBC },
	0xBAAE, { 0xEB, 0xB2, 0xBD },
	0xBAAF, { 0xEB, 0xB3, 0x80 },
	0xBAB0, { 0xEB, 0xB3, 0x84 },
	0xBAB1, { 0xEB, 0xB3, 0x8D },
	0xBAB2, { 0xEB, 0xB3, 0x8F },
	0xBAB3, { 0xEB, 0xB3, 0x90 },
	0xBAB4, { 0xEB, 0xB3, 0x91 },
	0xBAB5, { 0xEB, 0xB3, 0x95 },
	0xBAB6, { 0xEB, 0xB3, 0x98 },
	0xBAB7, { 0xEB, 0xB3, 0x9C },
	0xBAB8, { 0xEB, 0xB3, 0xB4 },
	0xBAB9, { 0xEB, 0xB3, 0xB5 },
	0xBABA, { 0xEB, 0xB3, 0xB6 },
	0xBABB, { 0xEB, 0xB3, 0xB8 },
	0xBABC, { 0xEB, 0xB3, 0xBC },
	0xBABD, { 0xEB, 0xB4, 0x84 },
	0xBABE, { 0xEB, 0xB4, 0x85 },
	0xBABF, { 0xEB, 0xB4, 0x87 },
	0xBAC0, { 0xEB, 0xB4, 0x89 },
	0xBAC1, { 0xEB, 0xB4, 0x90 },
	0xBAC2, { 0xEB, 0xB4, 0x94 },
	0xBAC3, { 0xEB, 0xB4, 0xA4 },
	0xBAC4, { 0xEB, 0xB4, 0xAC },
	0xBAC5, { 0xEB, 0xB5, 0x80 },
	0xBAC6, { 0xEB, 0xB5, 0x88 },
	0xBAC7, { 0xEB, 0xB5, 0x89 },
	0xBAC8, { 0xEB, 0xB5, 0x8C },
	0xBAC9, { 0xEB, 0xB5, 0x90 },
	0xBACA, { 0xEB, 0xB5, 0x98 },
	0xBACB, { 0xEB, 0xB5, 0x99 },
	0xBACC, { 0xEB, 0xB5, 0xA4 },
	0xBACD, { 0xEB, 0xB5, 0xA8 },
	0xBACE, { 0xEB, 0xB6, 0x80 },
	0xBACF, { 0xEB, 0xB6, 0x81 },
	0xBAD0, { 0xEB, 0xB6, 0x84 },
	0xBAD1, { 0xEB, 0xB6, 0x87 },
	0xBAD2, { 0xEB, 0xB6, 0x88 },
	0xBAD3, { 0xEB, 0xB6, 0x89 },
	0xBAD4, { 0xEB, 0xB6, 0x8A },
	0xBAD5, { 0xEB, 0xB6, 0x90 },
	0xBAD6, { 0xEB, 0xB6, 0x91 },
	0xBAD7, { 0xEB, 0xB6, 0x93 },
	0xBAD8, { 0xEB, 0xB6, 0x95 },
	0xBAD9, { 0xEB, 0xB6, 0x99 },
	0xBADA, { 0xEB, 0xB6, 0x9A },
	0xBADB, { 0xEB, 0xB6, 0x9C },
	0xBADC, { 0xEB, 0xB6, 0xA4 },
	0xBADD, { 0xEB, 0xB6, 0xB0 },
	0xBADE, { 0xEB, 0xB6, 0xB8 },
	0xBADF, { 0xEB, 0xB7, 0x94 },
	0xBAE0, { 0xEB, 0xB7, 0x95 },
	0xBAE1, { 0xEB, 0xB7, 0x98 },
	0xBAE2, { 0xEB, 0xB7, 0x9C },
	0xBAE3, { 0xEB, 0xB7, 0xA9 },
	0xBAE4, { 0xEB, 0xB7, 0xB0 },
	0xBAE5, { 0xEB, 0xB7, 0xB4 },
	0xBAE6, { 0xEB, 0xB7, 0xB8 },
	0xBAE7, { 0xEB, 0xB8, 0x80 },
	0xBAE8, { 0xEB, 0xB8, 0x83 },
	0xBAE9, { 0xEB, 0xB8, 0x85 },
	0xBAEA, { 0xEB, 0xB8, 0x8C },
	0xBAEB, { 0xEB, 0xB8, 0x8D },
	0xBAEC, { 0xEB, 0xB8, 0x90 },
	0xBAED, { 0xEB, 0xB8, 0x94 },
	0xBAEE, { 0xEB, 0xB8, 0x9C },
	0xBAEF, { 0xEB, 0xB8, 0x9D },
	0xBAF0, { 0xEB, 0xB8, 0x9F },
	0xBAF1, { 0xEB, 0xB9, 0x84 },
	0xBAF2, { 0xEB, 0xB9, 0x85 },
	0xBAF3, { 0xEB, 0xB9, 0x88 },
	0xBAF4, { 0xEB, 0xB9, 0x8C },
	0xBAF5, { 0xEB, 0xB9, 0x8E },
	0xBAF6, { 0xEB, 0xB9, 0x94 },
	0xBAF7, { 0xEB, 0xB9, 0x95 },
	0xBAF8, { 0xEB, 0xB9, 0x97 },
	0xBAF9, { 0xEB, 0xB9, 0x99 },
	0xBAFA, { 0xEB, 0xB9, 0x9A },
	0xBAFB, { 0xEB, 0xB9, 0x9B },
	0xBAFC, { 0xEB, 0xB9, 0xA0 },
	0xBAFD, { 0xEB, 0xB9, 0xA1 },
	0xBAFE, { 0xEB, 0xB9, 0xA4 },
	0xBBA1, { 0xEB, 0xB9, 0xA8 },
	0xBBA2, { 0xEB, 0xB9, 0xAA },
	0xBBA3, { 0xEB, 0xB9, 0xB0 },
	0xBBA4, { 0xEB, 0xB9, 0xB1 },
	0xBBA5, { 0xEB, 0xB9, 0xB3 },
	0xBBA6, { 0xEB, 0xB9, 0xB4 },
	0xBBA7, { 0xEB, 0xB9, 0xB5 },
	0xBBA8, { 0xEB, 0xB9, 0xBB },
	0xBBA9, { 0xEB, 0xB9, 0xBC },
	0xBBAA, { 0xEB, 0xB9, 0xBD },
	0xBBAB, { 0xEB, 0xBA, 0x80 },
	0xBBAC, { 0xEB, 0xBA, 0x84 },
	0xBBAD, { 0xEB, 0xBA, 0x8C },
	0xBBAE, { 0xEB, 0xBA, 0x8D },
	0xBBAF, { 0xEB, 0xBA, 0x8F },
	0xBBB0, { 0xEB, 0xBA, 0x90 },
	0xBBB1, { 0xEB, 0xBA, 0x91 },
	0xBBB2, { 0xEB, 0xBA, 0x98 },
	0xBBB3, { 0xEB, 0xBA, 0x99 },
	0xBBB4, { 0xEB, 0xBA, 0xA8 },
	0xBBB5, { 0xEB, 0xBB, 0x90 },
	0xBBB6, { 0xEB, 0xBB, 0x91 },
	0xBBB7, { 0xEB, 0xBB, 0x94 },
	0xBBB8, { 0xEB, 0xBB, 0x97 },
	0xBBB9, { 0xEB, 0xBB, 0x98 },
	0xBBBA, { 0xEB, 0xBB, 0xA0 },
	0xBBBB, { 0xEB, 0xBB, 0xA3 },
	0xBBBC, { 0xEB, 0xBB, 0xA4 },
	0xBBBD, { 0xEB, 0xBB, 0xA5 },
	0xBBBE, { 0xEB, 0xBB, 0xAC },
	0xBBBF, { 0xEB, 0xBC, 0x81 },
	0xBBC0, { 0xEB, 0xBC, 0x88 },
	0xBBC1, { 0xEB, 0xBC, 0x89 },
	0xBBC2, { 0xEB, 0xBC, 0x98 },
	0xBBC3, { 0xEB, 0xBC, 0x99 },
	0xBBC4, { 0xEB, 0xBC, 0x9B },
	0xBBC5, { 0xEB, 0xBC, 0x9C },
	0xBBC6, { 0xEB, 0xBC, 0x9D },
	0xBBC7, { 0xEB, 0xBD, 0x80 },
	0xBBC8, { 0xEB, 0xBD, 0x81 },
	0xBBC9, { 0xEB, 0xBD, 0x84 },
	0xBBCA, { 0xEB, 0xBD, 0x88 },
	0xBBCB, { 0xEB, 0xBD, 0x90 },
	0xBBCC, { 0xEB, 0xBD, 0x91 },
	0xBBCD, { 0xEB, 0xBD, 0x95 },
	0xBBCE, { 0xEB, 0xBE, 0x94 },
	0xBBCF, { 0xEB, 0xBE, 0xB0 },
	0xBBD0, { 0xEB, 0xBF, 0x85 },
	0xBBD1, { 0xEB, 0xBF, 0x8C },
	0xBBD2, { 0xEB, 0xBF, 0x8D },
	0xBBD3, { 0xEB, 0xBF, 0x90 },
	0xBBD4, { 0xEB, 0xBF, 0x94 },
	0xBBD5, { 0xEB, 0xBF, 0x9C },
	0xBBD6, { 0xEB, 0xBF, 0x9F },
	0xBBD7, { 0xEB, 0xBF, 0xA1 },
	0xBBD8, { 0xEC, 0x80, 0xBC },
	0xBBD9, { 0xEC, 0x81, 0x91 },
	0xBBDA, { 0xEC, 0x81, 0x98 },
	0xBBDB, { 0xEC, 0x81, 0x9C },
	0xBBDC, { 0xEC, 0x81, 0xA0 },
	0xBBDD, { 0xEC, 0x81, 0xA8 },
	0xBBDE, { 0xEC, 0x81, 0xA9 },
	0xBBDF, { 0xEC, 0x82, 0x90 },
	0xBBE0, { 0xEC, 0x82, 0x91 },
	0xBBE1, { 0xEC, 0x82, 0x94 },
	0xBBE2, { 0xEC, 0x82, 0x98 },
	0xBBE3, { 0xEC, 0x82, 0xA0 },
	0xBBE4, { 0xEC, 0x82, 0xA1 },
	0xBBE5, { 0xEC, 0x82, 0xA3 },
	0xBBE6, { 0xEC, 0x82, 0xA5 },
	0xBBE7, { 0xEC, 0x82, 0xAC },
	0xBBE8, { 0xEC, 0x82, 0xAD },
	0xBBE9, { 0xEC, 0x82, 0xAF },
	0xBBEA, { 0xEC, 0x82, 0xB0 },
	0xBBEB, { 0xEC, 0x82, 0xB3 },
	0xBBEC, { 0xEC, 0x82, 0xB4 },
	0xBBED, { 0xEC, 0x82, 0xB5 },
	0xBBEE, { 0xEC, 0x82, 0xB6 },
	0xBBEF, { 0xEC, 0x82, 0xBC },
	0xBBF0, { 0xEC, 0x82, 0xBD },
	0xBBF1, { 0xEC, 0x82, 0xBF },
	0xBBF2, { 0xEC, 0x83, 0x80 },
	0xBBF3, { 0xEC, 0x83, 0x81 },
	0xBBF4, { 0xEC, 0x83, 0x85 },
	0xBBF5, { 0xEC, 0x83, 0x88 },
	0xBBF6, { 0xEC, 0x83, 0x89 },
	0xBBF7, { 0xEC, 0x83, 0x8C },
	0xBBF8, { 0xEC, 0x83, 0x90 },
	0xBBF9, { 0xEC, 0x83, 0x98 },
	0xBBFA, { 0xEC, 0x83, 0x99 },
	0xBBFB, { 0xEC, 0x83, 0x9B },
	0xBBFC, { 0xEC, 0x83, 0x9C },
	0xBBFD, { 0xEC, 0x83, 0x9D },
	0xBBFE, { 0xEC, 0x83, 0xA4 },
	0xBCA1, { 0xEC, 0x83, 0xA5 },
	0xBCA2, { 0xEC, 0x83, 0xA8 },
	0xBCA3, { 0xEC, 0x83, 0xAC },
	0xBCA4, { 0xEC, 0x83, 0xB4 },
	0xBCA5, { 0xEC, 0x83, 0xB5 },
	0xBCA6, { 0xEC, 0x83, 0xB7 },
	0xBCA7, { 0xEC, 0x83, 0xB9 },
	0xBCA8, { 0xEC, 0x84, 0x80 },
	0xBCA9, { 0xEC, 0x84, 0x84 },
	0xBCAA, { 0xEC, 0x84, 0x88 },
	0xBCAB, { 0xEC, 0x84, 0x90 },
	0xBCAC, { 0xEC, 0x84, 0x95 },
	0xBCAD, { 0xEC, 0x84, 0x9C },
	0xBCAE, { 0xEC, 0x84, 0x9D },
	0xBCAF, { 0xEC, 0x84, 0x9E },
	0xBCB0, { 0xEC, 0x84, 0x9F },
	0xBCB1, { 0xEC, 0x84, 0xA0 },
	0xBCB2, { 0xEC, 0x84, 0xA3 },
	0xBCB3, { 0xEC, 0x84, 0xA4 },
	0xBCB4, { 0xEC, 0x84, 0xA6 },
	0xBCB5, { 0xEC, 0x84, 0xA7 },
	0xBCB6, { 0xEC, 0x84, 0xAC },
	0xBCB7, { 0xEC, 0x84, 0xAD },
	0xBCB8, { 0xEC, 0x84, 0xAF },
	0xBCB9, { 0xEC, 0x84, 0xB0 },
	0xBCBA, { 0xEC, 0x84, 0xB1 },
	0xBCBB, { 0xEC, 0x84, 0xB6 },
	0xBCBC, { 0xEC, 0x84, 0xB8 },
	0xBCBD, { 0xEC, 0x84, 0xB9 },
	0xBCBE, { 0xEC, 0x84, 0xBC },
	0xBCBF, { 0xEC, 0x85, 0x80 },
	0xBCC0, { 0xEC, 0x85, 0x88 },
	0xBCC1, { 0xEC, 0x85, 0x89 },
	0xBCC2, { 0xEC, 0x85, 0x8B },
	0xBCC3, { 0xEC, 0x85, 0x8C },
	0xBCC4, { 0xEC, 0x85, 0x8D },
	0xBCC5, { 0xEC, 0x85, 0x94 },
	0xBCC6, { 0xEC, 0x85, 0x95 },
	0xBCC7, { 0xEC, 0x85, 0x98 },
	0xBCC8, { 0xEC, 0x85, 0x9C },
	0xBCC9, { 0xEC, 0x85, 0xA4 },
	0xBCCA, { 0xEC, 0x85, 0xA5 },
	0xBCCB, { 0xEC, 0x85, 0xA7 },
	0xBCCC, { 0xEC, 0x85, 0xA8 },
	0xBCCD, { 0xEC, 0x85, 0xA9 },
	0xBCCE, { 0xEC, 0x85, 0xB0 },
	0xBCCF, { 0xEC, 0x85, 0xB4 },
	0xBCD0, { 0xEC, 0x85, 0xB8 },
	0xBCD1, { 0xEC, 0x86, 0x85 },
	0xBCD2, { 0xEC, 0x86, 0x8C },
	0xBCD3, { 0xEC, 0x86, 0x8D },
	0xBCD4, { 0xEC, 0x86, 0x8E },
	0xBCD5, { 0xEC, 0x86, 0x90 },
	0xBCD6, { 0xEC, 0x86, 0x94 },
	0xBCD7, { 0xEC, 0x86, 0x96 },
	0xBCD8, { 0xEC, 0x86, 0x9C },
	0xBCD9, { 0xEC, 0x86, 0x9D },
	0xBCDA, { 0xEC, 0x86, 0x9F },
	0xBCDB, { 0xEC, 0x86, 0xA1 },
	0xBCDC, { 0xEC, 0x86, 0xA5 },
	0xBCDD, { 0xEC, 0x86, 0xA8 },
	0xBCDE, { 0xEC, 0x86, 0xA9 },
	0xBCDF, { 0xEC, 0x86, 0xAC },
	0xBCE0, { 0xEC, 0x86, 0xB0 },
	0xBCE1, { 0xEC, 0x86, 0xBD },
	0xBCE2, { 0xEC, 0x87, 0x84 },
	0xBCE3, { 0xEC, 0x87, 0x88 },
	0xBCE4, { 0xEC, 0x87, 0x8C },
	0xBCE5, { 0xEC, 0x87, 0x94 },
	0xBCE6, { 0xEC, 0x87, 0x97 },
	0xBCE7, { 0xEC, 0x87, 0x98 },
	0xBCE8, { 0xEC, 0x87, 0xA0 },
	0xBCE9, { 0xEC, 0x87, 0xA4 },
	0xBCEA, { 0xEC, 0x87, 0xA8 },
	0xBCEB, { 0xEC, 0x87, 0xB0 },
	0xBCEC, { 0xEC, 0x87, 0xB1 },
	0xBCED, { 0xEC, 0x87, 0xB3 },
	0xBCEE, { 0xEC, 0x87, 0xBC },
	0xBCEF, { 0xEC, 0x87, 0xBD },
	0xBCF0, { 0xEC, 0x88, 0x80 },
	0xBCF1, { 0xEC, 0x88, 0x84 },
	0xBCF2, { 0xEC, 0x88, 0x8C },
	0xBCF3, { 0xEC, 0x88, 0x8D },
	0xBCF4, { 0xEC, 0x88, 0x8F },
	0xBCF5, { 0xEC, 0x88, 0x91 },
	0xBCF6, { 0xEC, 0x88, 0x98 },
	0xBCF7, { 0xEC, 0x88, 0x99 },
	0xBCF8, { 0xEC, 0x88, 0x9C },
	0xBCF9, { 0xEC, 0x88, 0x9F },
	0xBCFA, { 0xEC, 0x88, 0xA0 },
	0xBCFB, { 0xEC, 0x88, 0xA8 },
	0xBCFC, { 0xEC, 0x88, 0xA9 },
	0xBCFD, { 0xEC, 0x88, 0xAB },
	0xBCFE, { 0xEC, 0x88, 0xAD },
	0xBDA1, { 0xEC, 0x88, 0xAF },
	0xBDA2, { 0xEC, 0x88, 0xB1 },
	0xBDA3, { 0xEC, 0x88, 0xB2 },
	0xBDA4, { 0xEC, 0x88, 0xB4 },
	0xBDA5, { 0xEC, 0x89, 0x88 },
	0xBDA6, { 0xEC, 0x89, 0x90 },
	0xBDA7, { 0xEC, 0x89, 0x91 },
	0xBDA8, { 0xEC, 0x89, 0x94 },
	0xBDA9, { 0xEC, 0x89, 0x98 },
	0xBDAA, { 0xEC, 0x89, 0xA0 },
	0xBDAB, { 0xEC, 0x89, 0xA5 },
	0xBDAC, { 0xEC, 0x89, 0xAC },
	0xBDAD, { 0xEC, 0x89, 0xAD },
	0xBDAE, { 0xEC, 0x89, 0xB0 },
	0xBDAF, { 0xEC, 0x89, 0xB4 },
	0xBDB0, { 0xEC, 0x89, 0xBC },
	0xBDB1, { 0xEC, 0x89, 0xBD },
	0xBDB2, { 0xEC, 0x89, 0xBF },
	0xBDB3, { 0xEC, 0x8A, 0x81 },
	0xBDB4, { 0xEC, 0x8A, 0x88 },
	0xBDB5, { 0xEC, 0x8A, 0x89 },
	0xBDB6, { 0xEC, 0x8A, 0x90 },
	0xBDB7, { 0xEC, 0x8A, 0x98 },
	0xBDB8, { 0xEC, 0x8A, 0x9B },
	0xBDB9, { 0xEC, 0x8A, 0x9D },
	0xBDBA, { 0xEC, 0x8A, 0xA4 },
	0xBDBB, { 0xEC, 0x8A, 0xA5 },
	0xBDBC, { 0xEC, 0x8A, 0xA8 },
	0xBDBD, { 0xEC, 0x8A, 0xAC },
	0xBDBE, { 0xEC, 0x8A, 0xAD },
	0xBDBF, { 0xEC, 0x8A, 0xB4 },
	0xBDC0, { 0xEC, 0x8A, 0xB5 },
	0xBDC1, { 0xEC, 0x8A, 0xB7 },
	0xBDC2, { 0xEC, 0x8A, 0xB9 },
	0xBDC3, { 0xEC, 0x8B, 0x9C },
	0xBDC4, { 0xEC, 0x8B, 0x9D },
	0xBDC5, { 0xEC, 0x8B, 0xA0 },
	0xBDC6, { 0xEC, 0x8B, 0xA3 },
	0xBDC7, { 0xEC, 0x8B, 0xA4 },
	0xBDC8, { 0xEC, 0x8B, 0xAB },
	0xBDC9, { 0xEC, 0x8B, 0xAC },
	0xBDCA, { 0xEC, 0x8B, 0xAD },
	0xBDCB, { 0xEC, 0x8B, 0xAF },
	0xBDCC, { 0xEC, 0x8B, 0xB1 },
	0xBDCD, { 0xEC, 0x8B, 0xB6 },
	0xBDCE, { 0xEC, 0x8B, 0xB8 },
	0xBDCF, { 0xEC, 0x8B, 0xB9 },
	0xBDD0, { 0xEC, 0x8B, 0xBB },
	0xBDD1, { 0xEC, 0x8B, 0xBC },
	0xBDD2, { 0xEC, 0x8C, 0x80 },
	0xBDD3, { 0xEC, 0x8C, 0x88 },
	0xBDD4, { 0xEC, 0x8C, 0x89 },
	0xBDD5, { 0xEC, 0x8C, 0x8C },
	0xBDD6, { 0xEC, 0x8C, 0x8D },
	0xBDD7, { 0xEC, 0x8C, 0x93 },
	0xBDD8, { 0xEC, 0x8C, 0x94 },
	0xBDD9, { 0xEC, 0x8C, 0x95 },
	0xBDDA, { 0xEC, 0x8C, 0x98 },
	0xBDDB, { 0xEC, 0x8C, 0x9C },
	0xBDDC, { 0xEC, 0x8C, 0xA4 },
	0xBDDD, { 0xEC, 0x8C, 0xA5 },
	0xBDDE, { 0xEC, 0x8C, 0xA8 },
	0xBDDF, { 0xEC, 0x8C, 0xA9 },
	0xBDE0, { 0xEC, 0x8D, 0x85 },
	0xBDE1, { 0xEC, 0x8D, 0xA8 },
	0xBDE2, { 0xEC, 0x8D, 0xA9 },
	0xBDE3, { 0xEC, 0x8D, 0xAC },
	0xBDE4, { 0xEC, 0x8D, 0xB0 },
	0xBDE5, { 0xEC, 0x8D, 0xB2 },
	0xBDE6, { 0xEC, 0x8D, 0xB8 },
	0xBDE7, { 0xEC, 0x8D, 0xB9 },
	0xBDE8, { 0xEC, 0x8D, 0xBC },
	0xBDE9, { 0xEC, 0x8D, 0xBD },
	0xBDEA, { 0xEC, 0x8E, 0x84 },
	0xBDEB, { 0xEC, 0x8E, 0x88 },
	0xBDEC, { 0xEC, 0x8E, 0x8C },
	0xBDED, { 0xEC, 0x8F, 0x80 },
	0xBDEE, { 0xEC, 0x8F, 0x98 },
	0xBDEF, { 0xEC, 0x8F, 0x99 },
	0xBDF0, { 0xEC, 0x8F, 0x9C },
	0xBDF1, { 0xEC, 0x8F, 0x9F },
	0xBDF2, { 0xEC, 0x8F, 0xA0 },
	0xBDF3, { 0xEC, 0x8F, 0xA2 },
	0xBDF4, { 0xEC, 0x8F, 0xA8 },
	0xBDF5, { 0xEC, 0x8F, 0xA9 },
	0xBDF6, { 0xEC, 0x8F, 0xAD },
	0xBDF7, { 0xEC, 0x8F, 0xB4 },
	0xBDF8, { 0xEC, 0x8F, 0xB5 },
	0xBDF9, { 0xEC, 0x8F, 0xB8 },
	0xBDFA, { 0xEC, 0x90, 0x88 },
	0xBDFB, { 0xEC, 0x90, 0x90 },
	0xBDFC, { 0xEC, 0x90, 0xA4 },
	0xBDFD, { 0xEC, 0x90, 0xAC },
	0xBDFE, { 0xEC, 0x90, 0xB0 },
	0xBEA1, { 0xEC, 0x90, 0xB4 },
	0xBEA2, { 0xEC, 0x90, 0xBC },
	0xBEA3, { 0xEC, 0x90, 0xBD },
	0xBEA4, { 0xEC, 0x91, 0x88 },
	0xBEA5, { 0xEC, 0x91, 0xA4 },
	0xBEA6, { 0xEC, 0x91, 0xA5 },
	0xBEA7, { 0xEC, 0x91, 0xA8 },
	0xBEA8, { 0xEC, 0x91, 0xAC },
	0xBEA9, { 0xEC, 0x91, 0xB4 },
	0xBEAA, { 0xEC, 0x91, 0xB5 },
	0xBEAB, { 0xEC, 0x91, 0xB9 },
	0xBEAC, { 0xEC, 0x92, 0x80 },
	0xBEAD, { 0xEC, 0x92, 0x94 },
	0xBEAE, { 0xEC, 0x92, 0x9C },
	0xBEAF, { 0xEC, 0x92, 0xB8 },
	0xBEB0, { 0xEC, 0x92, 0xBC },
	0xBEB1, { 0xEC, 0x93, 0xA9 },
	0xBEB2, { 0xEC, 0x93, 0xB0 },
	0xBEB3, { 0xEC, 0x93, 0xB1 },
	0xBEB4, { 0xEC, 0x93, 0xB4 },
	0xBEB5, { 0xEC, 0x93, 0xB8 },
	0xBEB6, { 0xEC, 0x93, 0xBA },
	0xBEB7, { 0xEC, 0x93, 0xBF },
	0xBEB8, { 0xEC, 0x94, 0x80 },
	0xBEB9, { 0xEC, 0x94, 0x81 },
	0xBEBA, { 0xEC, 0x94, 0x8C },
	0xBEBB, { 0xEC, 0x94, 0x90 },
	0xBEBC, { 0xEC, 0x94, 0x94 },
	0xBEBD, { 0xEC, 0x94, 0x9C },
	0xBEBE, { 0xEC, 0x94, 0xA8 },
	0xBEBF, { 0xEC, 0x94, 0xA9 },
	0xBEC0, { 0xEC, 0x94, 0xAC },
	0xBEC1, { 0xEC, 0x94, 0xB0 },
	0xBEC2, { 0xEC, 0x94, 0xB8 },
	0xBEC3, { 0xEC, 0x94, 0xB9 },
	0xBEC4, { 0xEC, 0x94, 0xBB },
	0xBEC5, { 0xEC, 0x94, 0xBD },
	0xBEC6, { 0xEC, 0x95, 0x84 },
	0xBEC7, { 0xEC, 0x95, 0x85 },
	0xBEC8, { 0xEC, 0x95, 0x88 },
	0xBEC9, { 0xEC, 0x95, 0x89 },
	0xBECA, { 0xEC, 0x95, 0x8A },
	0xBECB, { 0xEC, 0x95, 0x8C },
	0xBECC, { 0xEC, 0x95, 0x8D },
	0xBECD, { 0xEC, 0x95, 0x8E },
	0xBECE, { 0xEC, 0x95, 0x93 },
	0xBECF, { 0xEC, 0x95, 0x94 },
	0xBED0, { 0xEC, 0x95, 0x95 },
	0xBED1, { 0xEC, 0x95, 0x97 },
	0xBED2, { 0xEC, 0x95, 0x98 },
	0xBED3, { 0xEC, 0x95, 0x99 },
	0xBED4, { 0xEC, 0x95, 0x9D },
	0xBED5, { 0xEC, 0x95, 0x9E },
	0xBED6, { 0xEC, 0x95, 0xA0 },
	0xBED7, { 0xEC, 0x95, 0xA1 },
	0xBED8, { 0xEC, 0x95, 0xA4 },
	0xBED9, { 0xEC, 0x95, 0xA8 },
	0xBEDA, { 0xEC, 0x95, 0xB0 },
	0xBEDB, { 0xEC, 0x95, 0xB1 },
	0xBEDC, { 0xEC, 0x95, 0xB3 },
	0xBEDD, { 0xEC, 0x95, 0xB4 },
	0xBEDE, { 0xEC, 0x95, 0xB5 },
	0xBEDF, { 0xEC, 0x95, 0xBC },
	0xBEE0, { 0xEC, 0x95, 0xBD },
	0xBEE1, { 0xEC, 0x96, 0x80 },
	0xBEE2, { 0xEC, 0x96, 0x84 },
	0xBEE3, { 0xEC, 0x96, 0x87 },
	0xBEE4, { 0xEC, 0x96, 0x8C },
	0xBEE5, { 0xEC, 0x96, 0x8D },
	0xBEE6, { 0xEC, 0x96, 0x8F },
	0xBEE7, { 0xEC, 0x96, 0x91 },
	0xBEE8, { 0xEC, 0x96, 0x95 },
	0xBEE9, { 0xEC, 0x96, 0x97 },
	0xBEEA, { 0xEC, 0x96, 0x98 },
	0xBEEB, { 0xEC, 0x96, 0x9C },
	0xBEEC, { 0xEC, 0x96, 0xA0 },
	0xBEED, { 0xEC, 0x96, 0xA9 },
	0xBEEE, { 0xEC, 0x96, 0xB4 },
	0xBEEF, { 0xEC, 0x96, 0xB5 },
	0xBEF0, { 0xEC, 0x96, 0xB8 },
	0xBEF1, { 0xEC, 0x96, 0xB9 },
	0xBEF2, { 0xEC, 0x96, 0xBB },
	0xBEF3, { 0xEC, 0x96, 0xBC },
	0xBEF4, { 0xEC, 0x96, 0xBD },
	0xBEF5, { 0xEC, 0x96, 0xBE },
	0xBEF6, { 0xEC, 0x97, 0x84 },
	0xBEF7, { 0xEC, 0x97, 0x85 },
	0xBEF8, { 0xEC, 0x97, 0x86 },
	0xBEF9, { 0xEC, 0x97, 0x87 },
	0xBEFA, { 0xEC, 0x97, 0x88 },
	0xBEFB, { 0xEC, 0x97, 0x89 },
	0xBEFC, { 0xEC, 0x97, 0x8A },
	0xBEFD, { 0xEC, 0x97, 0x8C },
	0xBEFE, { 0xEC, 0x97, 0x8E },
	0xBFA1, { 0xEC, 0x97, 0x90 },
	0xBFA2, { 0xEC, 0x97, 0x91 },
	0xBFA3, { 0xEC, 0x97, 0x94 },
	0xBFA4, { 0xEC, 0x97, 0x98 },
	0xBFA5, { 0xEC, 0x97, 0xA0 },
	0xBFA6, { 0xEC, 0x97, 0xA1 },
	0xBFA7, { 0xEC, 0x97, 0xA3 },
	0xBFA8, { 0xEC, 0x97, 0xA5 },
	0xBFA9, { 0xEC, 0x97, 0xAC },
	0xBFAA, { 0xEC, 0x97, 0xAD },
	0xBFAB, { 0xEC, 0x97, 0xAE },
	0xBFAC, { 0xEC, 0x97, 0xB0 },
	0xBFAD, { 0xEC, 0x97, 0xB4 },
	0xBFAE, { 0xEC, 0x97, 0xB6 },
	0xBFAF, { 0xEC, 0x97, 0xB7 },
	0xBFB0, { 0xEC, 0x97, 0xBC },
	0xBFB1, { 0xEC, 0x97, 0xBD },
	0xBFB2, { 0xEC, 0x97, 0xBE },
	0xBFB3, { 0xEC, 0x97, 0xBF },
	0xBFB4, { 0xEC, 0x98, 0x80 },
	0xBFB5, { 0xEC, 0x98, 0x81 },
	0xBFB6, { 0xEC, 0x98, 0x85 },
	0xBFB7, { 0xEC, 0x98, 0x86 },
	0xBFB8, { 0xEC, 0x98, 0x87 },
	0xBFB9, { 0xEC, 0x98, 0x88 },
	0xBFBA, { 0xEC, 0x98, 0x8C },
	0xBFBB, { 0xEC, 0x98, 0x90 },
	0xBFBC, { 0xEC, 0x98, 0x98 },
	0xBFBD, { 0xEC, 0x98, 0x99 },
	0xBFBE, { 0xEC, 0x98, 0x9B },
	0xBFBF, { 0xEC, 0x98, 0x9C },
	0xBFC0, { 0xEC, 0x98, 0xA4 },
	0xBFC1, { 0xEC, 0x98, 0xA5 },
	0xBFC2, { 0xEC, 0x98, 0xA8 },
	0xBFC3, { 0xEC, 0x98, 0xAC },
	0xBFC4, { 0xEC, 0x98, 0xAD },
	0xBFC5, { 0xEC, 0x98, 0xAE },
	0xBFC6, { 0xEC, 0x98, 0xB0 },
	0xBFC7, { 0xEC, 0x98, 0xB3 },
	0xBFC8, { 0xEC, 0x98, 0xB4 },
	0xBFC9, { 0xEC, 0x98, 0xB5 },
	0xBFCA, { 0xEC, 0x98, 0xB7 },
	0xBFCB, { 0xEC, 0x98, 0xB9 },
	0xBFCC, { 0xEC, 0x98, 0xBB },
	0xBFCD, { 0xEC, 0x99, 0x80 },
	0xBFCE, { 0xEC, 0x99, 0x81 },
	0xBFCF, { 0xEC, 0x99, 0x84 },
	0xBFD0, { 0xEC, 0x99, 0x88 },
	0xBFD1, { 0xEC, 0x99, 0x90 },
	0xBFD2, { 0xEC, 0x99, 0x91 },
	0xBFD3, { 0xEC, 0x99, 0x93 },
	0xBFD4, { 0xEC, 0x99, 0x94 },
	0xBFD5, { 0xEC, 0x99, 0x95 },
	0xBFD6, { 0xEC, 0x99, 0x9C },
	0xBFD7, { 0xEC, 0x99, 0x9D },
	0xBFD8, { 0xEC, 0x99, 0xA0 },
	0xBFD9, { 0xEC, 0x99, 0xAC },
	0xBFDA, { 0xEC, 0x99, 0xAF },
	0xBFDB, { 0xEC, 0x99, 0xB1 },
	0xBFDC, { 0xEC, 0x99, 0xB8 },
	0xBFDD, { 0xEC, 0x99, 0xB9 },
	0xBFDE, { 0xEC, 0x99, 0xBC },
	0xBFDF, { 0xEC, 0x9A, 0x80 },
	0xBFE0, { 0xEC, 0x9A, 0x88 },
	0xBFE1, { 0xEC, 0x9A, 0x89 },
	0xBFE2, { 0xEC, 0x9A, 0x8B },
	0xBFE3, { 0xEC, 0x9A, 0x8D },
	0xBFE4, { 0xEC, 0x9A, 0x94 },
	0xBFE5, { 0xEC, 0x9A, 0x95 },
	0xBFE6, { 0xEC, 0x9A, 0x98 },
	0xBFE7, { 0xEC, 0x9A, 0x9C },
	0xBFE8, { 0xEC, 0x9A, 0xA4 },
	0xBFE9, { 0xEC, 0x9A, 0xA5 },
	0xBFEA, { 0xEC, 0x9A, 0xA7 },
	0xBFEB, { 0xEC, 0x9A, 0xA9 },
	0xBFEC, { 0xEC, 0x9A, 0xB0 },
	0xBFED, { 0xEC, 0x9A, 0xB1 },
	0xBFEE, { 0xEC, 0x9A, 0xB4 },
	0xBFEF, { 0xEC, 0x9A, 0xB8 },
	0xBFF0, { 0xEC, 0x9A, 0xB9 },
	0xBFF1, { 0xEC, 0x9A, 0xBA },
	0xBFF2, { 0xEC, 0x9B, 0x80 },
	0xBFF3, { 0xEC, 0x9B, 0x81 },
	0xBFF4, { 0xEC, 0x9B, 0x83 },
	0xBFF5, { 0xEC, 0x9B, 0x85 },
	0xBFF6, { 0xEC, 0x9B, 0x8C },
	0xBFF7, { 0xEC, 0x9B, 0x8D },
	0xBFF8, { 0xEC, 0x9B, 0x90 },
	0xBFF9, { 0xEC, 0x9B, 0x94 },
	0xBFFA, { 0xEC, 0x9B, 0x9C },
	0xBFFB, { 0xEC, 0x9B, 0x9D },
	0xBFFC, { 0xEC, 0x9B, 0xA0 },
	0xBFFD, { 0xEC, 0x9B, 0xA1 },
	0xBFFE, { 0xEC, 0x9B, 0xA8 },
	0xC0A1, { 0xEC, 0x9B, 0xA9 },
	0xC0A2, { 0xEC, 0x9B, 0xAC },
	0xC0A3, { 0xEC, 0x9B, 0xB0 },
	0xC0A4, { 0xEC, 0x9B, 0xB8 },
	0xC0A5, { 0xEC, 0x9B, 0xB9 },
	0xC0A6, { 0xEC, 0x9B, 0xBD },
	0xC0A7, { 0xEC, 0x9C, 0x84 },
	0xC0A8, { 0xEC, 0x9C, 0x85 },
	0xC0A9, { 0xEC, 0x9C, 0x88 },
	0xC0AA, { 0xEC, 0x9C, 0x8C },
	0xC0AB, { 0xEC, 0x9C, 0x94 },
	0xC0AC, { 0xEC, 0x9C, 0x95 },
	0xC0AD, { 0xEC, 0x9C, 0x97 },
	0xC0AE, { 0xEC, 0x9C, 0x99 },
	0xC0AF, { 0xEC, 0x9C, 0xA0 },
	0xC0B0, { 0xEC, 0x9C, 0xA1 },
	0xC0B1, { 0xEC, 0x9C, 0xA4 },
	0xC0B2, { 0xEC, 0x9C, 0xA8 },
	0xC0B3, { 0xEC, 0x9C, 0xB0 },
	0xC0B4, { 0xEC, 0x9C, 0xB1 },
	0xC0B5, { 0xEC, 0x9C, 0xB3 },
	0xC0B6, { 0xEC, 0x9C, 0xB5 },
	0xC0B7, { 0xEC, 0x9C, 0xB7 },
	0xC0B8, { 0xEC, 0x9C, 0xBC },
	0xC0B9, { 0xEC, 0x9C, 0xBD },
	0xC0BA, { 0xEC, 0x9D, 0x80 },
	0xC0BB, { 0xEC, 0x9D, 0x84 },
	0xC0BC, { 0xEC, 0x9D, 0x8A },
	0xC0BD, { 0xEC, 0x9D, 0x8C },
	0xC0BE, { 0xEC, 0x9D, 0x8D },
	0xC0BF, { 0xEC, 0x9D, 0x8F },
	0xC0C0, { 0xEC, 0x9D, 0x91 },
	0xC0C1, { 0xEC, 0x9D, 0x92 },
	0xC0C2, { 0xEC, 0x9D, 0x93 },
	0xC0C3, { 0xEC, 0x9D, 0x94 },
	0xC0C4, { 0xEC, 0x9D, 0x95 },
	0xC0C5, { 0xEC, 0x9D, 0x96 },
	0xC0C6, { 0xEC, 0x9D, 0x97 },
	0xC0C7, { 0xEC, 0x9D, 0x98 },
	0xC0C8, { 0xEC, 0x9D, 0x9C },
	0xC0C9, { 0xEC, 0x9D, 0xA0 },
	0xC0CA, { 0xEC, 0x9D, 0xA8 },
	0xC0CB, { 0xEC, 0x9D, 0xAB },
	0xC0CC, { 0xEC, 0x9D, 0xB4 },
	0xC0CD, { 0xEC, 0x9D, 0xB5 },
	0xC0CE, { 0xEC, 0x9D, 0xB8 },
	0xC0CF, { 0xEC, 0x9D, 0xBC },
	0xC0D0, { 0xEC, 0x9D, 0xBD },
	0xC0D1, { 0xEC, 0x9D, 0xBE },
	0xC0D2, { 0xEC, 0x9E, 0x83 },
	0xC0D3, { 0xEC, 0x9E, 0x84 },
	0xC0D4, { 0xEC, 0x9E, 0x85 },
	0xC0D5, { 0xEC, 0x9E, 0x87 },
	0xC0D6, { 0xEC, 0x9E, 0x88 },
	0xC0D7, { 0xEC, 0x9E, 0x89 },
	0xC0D8, { 0xEC, 0x9E, 0x8A },
	0xC0D9, { 0xEC, 0x9E, 0x8E },
	0xC0DA, { 0xEC, 0x9E, 0x90 },
	0xC0DB, { 0xEC, 0x9E, 0x91 },
	0xC0DC, { 0xEC, 0x9E, 0x94 },
	0xC0DD, { 0xEC, 0x9E, 0x96 },
	0xC0DE, { 0xEC, 0x9E, 0x97 },
	0xC0DF, { 0xEC, 0x9E, 0x98 },
	0xC0E0, { 0xEC, 0x9E, 0x9A },
	0xC0E1, { 0xEC, 0x9E, 0xA0 },
	0xC0E2, { 0xEC, 0x9E, 0xA1 },
	0xC0E3, { 0xEC, 0x9E, 0xA3 },
	0xC0E4, { 0xEC, 0x9E, 0xA4 },
	0xC0E5, { 0xEC, 0x9E, 0xA5 },
	0xC0E6, { 0xEC, 0x9E, 0xA6 },
	0xC0E7, { 0xEC, 0x9E, 0xAC },
	0xC0E8, { 0xEC, 0x9E, 0xAD },
	0xC0E9, { 0xEC, 0x9E, 0xB0 },
	0xC0EA, { 0xEC, 0x9E, 0xB4 },
	0xC0EB, { 0xEC, 0x9E, 0xBC },
	0xC0EC, { 0xEC, 0x9E, 0xBD },
	0xC0ED, { 0xEC, 0x9E, 0xBF },
	0xC0EE, { 0xEC, 0x9F, 0x80 },
	0xC0EF, { 0xEC, 0x9F, 0x81 },
	0xC0F0, { 0xEC, 0x9F, 0x88 },
	0xC0F1, { 0xEC, 0x9F, 0x89 },
	0xC0F2, { 0xEC, 0x9F, 0x8C },
	0xC0F3, { 0xEC, 0x9F, 0x8E },
	0xC0F4, { 0xEC, 0x9F, 0x90 },
	0xC0F5, { 0xEC, 0x9F, 0x98 },
	0xC0F6, { 0xEC, 0x9F, 0x9D },
	0xC0F7, { 0xEC, 0x9F, 0xA4 },
	0xC0F8, { 0xEC, 0x9F, 0xA8 },
	0xC0F9, { 0xEC, 0x9F, 0xAC },
	0xC0FA, { 0xEC, 0xA0, 0x80 },
	0xC0FB, { 0xEC, 0xA0, 0x81 },
	0xC0FC, { 0xEC, 0xA0, 0x84 },
	0xC0FD, { 0xEC, 0xA0, 0x88 },
	0xC0FE, { 0xEC, 0xA0, 0x8A },
	0xC1A1, { 0xEC, 0xA0, 0x90 },
	0xC1A2, { 0xEC, 0xA0, 0x91 },
	0xC1A3, { 0xEC, 0xA0, 0x93 },
	0xC1A4, { 0xEC, 0xA0, 0x95 },
	0xC1A5, { 0xEC, 0xA0, 0x96 },
	0xC1A6, { 0xEC, 0xA0, 0x9C },
	0xC1A7, { 0xEC, 0xA0, 0x9D },
	0xC1A8, { 0xEC, 0xA0, 0xA0 },
	0xC1A9, { 0xEC, 0xA0, 0xA4 },
	0xC1AA, { 0xEC, 0xA0, 0xAC },
	0xC1AB, { 0xEC, 0xA0, 0xAD },
	0xC1AC, { 0xEC, 0xA0, 0xAF },
	0xC1AD, { 0xEC, 0xA0, 0xB1 },
	0xC1AE, { 0xEC, 0xA0, 0xB8 },
	0xC1AF, { 0xEC, 0xA0, 0xBC },
	0xC1B0, { 0xEC, 0xA1, 0x80 },
	0xC1B1, { 0xEC, 0xA1, 0x88 },
	0xC1B2, { 0xEC, 0xA1, 0x89 },
	0xC1B3, { 0xEC, 0xA1, 0x8C },
	0xC1B4, { 0xEC, 0xA1, 0x8D },
	0xC1B5, { 0xEC, 0xA1, 0x94 },
	0xC1B6, { 0xEC, 0xA1, 0xB0 },
	0xC1B7, { 0xEC, 0xA1, 0xB1 },
	0xC1B8, { 0xEC, 0xA1, 0xB4 },
	0xC1B9, { 0xEC, 0xA1, 0xB8 },
	0xC1BA, { 0xEC, 0xA1, 0xBA },
	0xC1BB, { 0xEC, 0xA2, 0x80 },
	0xC1BC, { 0xEC, 0xA2, 0x81 },
	0xC1BD, { 0xEC, 0xA2, 0x83 },
	0xC1BE, { 0xEC, 0xA2, 0x85 },
	0xC1BF, { 0xEC, 0xA2, 0x86 },
	0xC1C0, { 0xEC, 0xA2, 0x87 },
	0xC1C1, { 0xEC, 0xA2, 0x8B },
	0xC1C2, { 0xEC, 0xA2, 0x8C },
	0xC1C3, { 0xEC, 0xA2, 0x8D },
	0xC1C4, { 0xEC, 0xA2, 0x94 },
	0xC1C5, { 0xEC, 0xA2, 0x9D },
	0xC1C6, { 0xEC, 0xA2, 0x9F },
	0xC1C7, { 0xEC, 0xA2, 0xA1 },
	0xC1C8, { 0xEC, 0xA2, 0xA8 },
	0xC1C9, { 0xEC, 0xA2, 0xBC },
	0xC1CA, { 0xEC, 0xA2, 0xBD },
	0xC1CB, { 0xEC, 0xA3, 0x84 },
	0xC1CC, { 0xEC, 0xA3, 0x88 },
	0xC1CD, { 0xEC, 0xA3, 0x8C },
	0xC1CE, { 0xEC, 0xA3, 0x94 },
	0xC1CF, { 0xEC, 0xA3, 0x95 },
	0xC1D0, { 0xEC, 0xA3, 0x97 },
	0xC1D1, { 0xEC, 0xA3, 0x99 },
	0xC1D2, { 0xEC, 0xA3, 0xA0 },
	0xC1D3, { 0xEC, 0xA3, 0xA1 },
	0xC1D4, { 0xEC, 0xA3, 0xA4 },
	0xC1D5, { 0xEC, 0xA3, 0xB5 },
	0xC1D6, { 0xEC, 0xA3, 0xBC },
	0xC1D7, { 0xEC, 0xA3, 0xBD },
	0xC1D8, { 0xEC, 0xA4, 0x80 },
	0xC1D9, { 0xEC, 0xA4, 0x84 },
	0xC1DA, { 0xEC, 0xA4, 0x85 },
	0xC1DB, { 0xEC, 0xA4, 0x86 },
	0xC1DC, { 0xEC, 0xA4, 0x8C },
	0xC1DD, { 0xEC, 0xA4, 0x8D },
	0xC1DE, { 0xEC, 0xA4, 0x8F },
	0xC1DF, { 0xEC, 0xA4, 0x91 },
	0xC1E0, { 0xEC, 0xA4, 0x98 },
	0xC1E1, { 0xEC, 0xA4, 0xAC },
	0xC1E2, { 0xEC, 0xA4, 0xB4 },
	0xC1E3, { 0xEC, 0xA5, 0x90 },
	0xC1E4, { 0xEC, 0xA5, 0x91 },
	0xC1E5, { 0xEC, 0xA5, 0x94 },
	0xC1E6, { 0xEC, 0xA5, 0x98 },
	0xC1E7, { 0xEC, 0xA5, 0xA0 },
	0xC1E8, { 0xEC, 0xA5, 0xA1 },
	0xC1E9, { 0xEC, 0xA5, 0xA3 },
	0xC1EA, { 0xEC, 0xA5, 0xAC },
	0xC1EB, { 0xEC, 0xA5, 0xB0 },
	0xC1EC, { 0xEC, 0xA5, 0xB4 },
	0xC1ED, { 0xEC, 0xA5, 0xBC },
	0xC1EE, { 0xEC, 0xA6, 0x88 },
	0xC1EF, { 0xEC, 0xA6, 0x89 },
	0xC1F0, { 0xEC, 0xA6, 0x8C },
	0xC1F1, { 0xEC, 0xA6, 0x90 },
	0xC1F2, { 0xEC, 0xA6, 0x98 },
	0xC1F3, { 0xEC, 0xA6, 0x99 },
	0xC1F4, { 0xEC, 0xA6, 0x9B },
	0xC1F5, { 0xEC, 0xA6, 0x9D },
	0xC1F6, { 0xEC, 0xA7, 0x80 },
	0xC1F7, { 0xEC, 0xA7, 0x81 },
	0xC1F8, { 0xEC, 0xA7, 0x84 },
	0xC1F9, { 0xEC, 0xA7, 0x87 },
	0xC1FA, { 0xEC, 0xA7, 0x88 },
	0xC1FB, { 0xEC, 0xA7, 0x8A },
	0xC1FC, { 0xEC, 0xA7, 0x90 },
	0xC1FD, { 0xEC, 0xA7, 0x91 },
	0xC1FE, { 0xEC, 0xA7, 0x93 },
	0xC2A1, { 0xEC, 0xA7, 0x95 },
	0xC2A2, { 0xEC, 0xA7, 0x96 },
	0xC2A3, { 0xEC, 0xA7, 0x99 },
	0xC2A4, { 0xEC, 0xA7, 0x9A },
	0xC2A5, { 0xEC, 0xA7, 0x9C },
	0xC2A6, { 0xEC, 0xA7, 0x9D },
	0xC2A7, { 0xEC, 0xA7, 0xA0 },
	0xC2A8, { 0xEC, 0xA7, 0xA2 },
	0xC2A9, { 0xEC, 0xA7, 0xA4 },
	0xC2AA, { 0xEC, 0xA7, 0xA7 },
	0xC2AB, { 0xEC, 0xA7, 0xAC },
	0xC2AC, { 0xEC, 0xA7, 0xAD },
	0xC2AD, { 0xEC, 0xA7, 0xAF },
	0xC2AE, { 0xEC, 0xA7, 0xB0 },
	0xC2AF, { 0xEC, 0xA7, 0xB1 },
	0xC2B0, { 0xEC, 0xA7, 0xB8 },
	0xC2B1, { 0xEC, 0xA7, 0xB9 },
	0xC2B2, { 0xEC, 0xA7, 0xBC },
	0xC2B3, { 0xEC, 0xA8, 0x80 },
	0xC2B4, { 0xEC, 0xA8, 0x88 },
	0xC2B5, { 0xEC, 0xA8, 0x89 },
	0xC2B6, { 0xEC, 0xA8, 0x8B },
	0xC2B7, { 0xEC, 0xA8, 0x8C },
	0xC2B8, { 0xEC, 0xA8, 0x8D },
	0xC2B9, { 0xEC, 0xA8, 0x94 },
	0xC2BA, { 0xEC, 0xA8, 0x98 },
	0xC2BB, { 0xEC, 0xA8, 0xA9 },
	0xC2BC, { 0xEC, 0xA9, 0x8C },
	0xC2BD, { 0xEC, 0xA9, 0x8D },
	0xC2BE, { 0xEC, 0xA9, 0x90 },
	0xC2BF, { 0xEC, 0xA9, 0x94 },
	0xC2C0, { 0xEC, 0xA9, 0x9C },
	0xC2C1, { 0xEC, 0xA9, 0x9D },
	0xC2C2, { 0xEC, 0xA9, 0x9F },
	0xC2C3, { 0xEC, 0xA9, 0xA0 },
	0xC2C4, { 0xEC, 0xA9, 0xA1 },
	0xC2C5, { 0xEC, 0xA9, 0xA8 },
	0xC2C6, { 0xEC, 0xA9, 0xBD },
	0xC2C7, { 0xEC, 0xAA, 0x84 },
	0xC2C8, { 0xEC, 0xAA, 0x98 },
	0xC2C9, { 0xEC, 0xAA, 0xBC },
	0xC2CA, { 0xEC, 0xAA, 0xBD },
	0xC2CB, { 0xEC, 0xAB, 0x80 },
	0xC2CC, { 0xEC, 0xAB, 0x84 },
	0xC2CD, { 0xEC, 0xAB, 0x8C },
	0xC2CE, { 0xEC, 0xAB, 0x8D },
	0xC2CF, { 0xEC, 0xAB, 0x8F },
	0xC2D0, { 0xEC, 0xAB, 0x91 },
	0xC2D1, { 0xEC, 0xAB, 0x93 },
	0xC2D2, { 0xEC, 0xAB, 0x98 },
	0xC2D3, { 0xEC, 0xAB, 0x99 },
	0xC2D4, { 0xEC, 0xAB, 0xA0 },
	0xC2D5, { 0xEC, 0xAB, 0xAC },
	0xC2D6, { 0xEC, 0xAB, 0xB4 },
	0xC2D7, { 0xEC, 0xAC, 0x88 },
	0xC2D8, { 0xEC, 0xAC, 0x90 },
	0xC2D9, { 0xEC, 0xAC, 0x94 },
	0xC2DA, { 0xEC, 0xAC, 0x98 },
	0xC2DB, { 0xEC, 0xAC, 0xA0 },
	0xC2DC, { 0xEC, 0xAC, 0xA1 },
	0xC2DD, { 0xEC, 0xAD, 0x81 },
	0xC2DE, { 0xEC, 0xAD, 0x88 },
	0xC2DF, { 0xEC, 0xAD, 0x89 },
	0xC2E0, { 0xEC, 0xAD, 0x8C },
	0xC2E1, { 0xEC, 0xAD, 0x90 },
	0xC2E2, { 0xEC, 0xAD, 0x98 },
	0xC2E3, { 0xEC, 0xAD, 0x99 },
	0xC2E4, { 0xEC, 0xAD, 0x9D },
	0xC2E5, { 0xEC, 0xAD, 0xA4 },
	0xC2E6, { 0xEC, 0xAD, 0xB8 },
	0xC2E7, { 0xEC, 0xAD, 0xB9 },
	0xC2E8, { 0xEC, 0xAE, 0x9C },
	0xC2E9, { 0xEC, 0xAE, 0xB8 },
	0xC2EA, { 0xEC, 0xAF, 0x94 },
	0xC2EB, { 0xEC, 0xAF, 0xA4 },
	0xC2EC, { 0xEC, 0xAF, 0xA7 },
	0xC2ED, { 0xEC, 0xAF, 0xA9 },
	0xC2EE, { 0xEC, 0xB0, 0x8C },
	0xC2EF, { 0xEC, 0xB0, 0x8D },
	0xC2F0, { 0xEC, 0xB0, 0x90 },
	0xC2F1, { 0xEC, 0xB0, 0x94 },
	0xC2F2, { 0xEC, 0xB0, 0x9C },
	0xC2F3, { 0xEC, 0xB0, 0x9D },
	0xC2F4, { 0xEC, 0xB0, 0xA1 },
	0xC2F5, { 0xEC, 0xB0, 0xA2 },
	0xC2F6, { 0xEC, 0xB0, 0xA7 },
	0xC2F7, { 0xEC, 0xB0, 0xA8 },
	0xC2F8, { 0xEC, 0xB0, 0xA9 },
	0xC2F9, { 0xEC, 0xB0, 0xAC },
	0xC2FA, { 0xEC, 0xB0, 0xAE },
	0xC2FB, { 0xEC, 0xB0, 0xB0 },
	0xC2FC, { 0xEC, 0xB0, 0xB8 },
	0xC2FD, { 0xEC, 0xB0, 0xB9 },
	0xC2FE, { 0xEC, 0xB0, 0xBB },
	0xC3A1, { 0xEC, 0xB0, 0xBC },
	0xC3A2, { 0xEC, 0xB0, 0xBD },
	0xC3A3, { 0xEC, 0xB0, 0xBE },
	0xC3A4, { 0xEC, 0xB1, 0x84 },
	0xC3A5, { 0xEC, 0xB1, 0x85 },
	0xC3A6, { 0xEC, 0xB1, 0x88 },
	0xC3A7, { 0xEC, 0xB1, 0x8C },
	0xC3A8, { 0xEC, 0xB1, 0x94 },
	0xC3A9, { 0xEC, 0xB1, 0x95 },
	0xC3AA, { 0xEC, 0xB1, 0x97 },
	0xC3AB, { 0xEC, 0xB1, 0x98 },
	0xC3AC, { 0xEC, 0xB1, 0x99 },
	0xC3AD, { 0xEC, 0xB1, 0xA0 },
	0xC3AE, { 0xEC, 0xB1, 0xA4 },
	0xC3AF, { 0xEC, 0xB1, 0xA6 },
	0xC3B0, { 0xEC, 0xB1, 0xA8 },
	0xC3B1, { 0xEC, 0xB1, 0xB0 },
	0xC3B2, { 0xEC, 0xB1, 0xB5 },
	0xC3B3, { 0xEC, 0xB2, 0x98 },
	0xC3B4, { 0xEC, 0xB2, 0x99 },
	0xC3B5, { 0xEC, 0xB2, 0x9C },
	0xC3B6, { 0xEC, 0xB2, 0xA0 },
	0xC3B7, { 0xEC, 0xB2, 0xA8 },
	0xC3B8, { 0xEC, 0xB2, 0xA9 },
	0xC3B9, { 0xEC, 0xB2, 0xAB },
	0xC3BA, { 0xEC, 0xB2, 0xAC },
	0xC3BB, { 0xEC, 0xB2, 0xAD },
	0xC3BC, { 0xEC, 0xB2, 0xB4 },
	0xC3BD, { 0xEC, 0xB2, 0xB5 },
	0xC3BE, { 0xEC, 0xB2, 0xB8 },
	0xC3BF, { 0xEC, 0xB2, 0xBC },
	0xC3C0, { 0xEC, 0xB3, 0x84 },
	0xC3C1, { 0xEC, 0xB3, 0x85 },
	0xC3C2, { 0xEC, 0xB3, 0x87 },
	0xC3C3, { 0xEC, 0xB3, 0x89 },
	0xC3C4, { 0xEC, 0xB3, 0x90 },
	0xC3C5, { 0xEC, 0xB3, 0x94 },
	0xC3C6, { 0xEC, 0xB3, 0xA4 },
	0xC3C7, { 0xEC, 0xB3, 0xAC },
	0xC3C8, { 0xEC, 0xB3, 0xB0 },
	0xC3C9, { 0xEC, 0xB4, 0x81 },
	0xC3CA, { 0xEC, 0xB4, 0x88 },
	0xC3CB, { 0xEC, 0xB4, 0x89 },
	0xC3CC, { 0xEC, 0xB4, 0x8C },
	0xC3CD, { 0xEC, 0xB4, 0x90 },
	0xC3CE, { 0xEC, 0xB4, 0x98 },
	0xC3CF, { 0xEC, 0xB4, 0x99 },
	0xC3D0, { 0xEC, 0xB4, 0x9B },
	0xC3D1, { 0xEC, 0xB4, 0x9D },
	0xC3D2, { 0xEC, 0xB4, 0xA4 },
	0xC3D3, { 0xEC, 0xB4, 0xA8 },
	0xC3D4, { 0xEC, 0xB4, 0xAC },
	0xC3D5, { 0xEC, 0xB4, 0xB9 },
	0xC3D6, { 0xEC, 0xB5, 0x9C },
	0xC3D7, { 0xEC, 0xB5, 0xA0 },
	0xC3D8, { 0xEC, 0xB5, 0xA4 },
	0xC3D9, { 0xEC, 0xB5, 0xAC },
	0xC3DA, { 0xEC, 0xB5, 0xAD },
	0xC3DB, { 0xEC, 0xB5, 0xAF },
	0xC3DC, { 0xEC, 0xB5, 0xB1 },
	0xC3DD, { 0xEC, 0xB5, 0xB8 },
	0xC3DE, { 0xEC, 0xB6, 0x88 },
	0xC3DF, { 0xEC, 0xB6, 0x94 },
	0xC3E0, { 0xEC, 0xB6, 0x95 },
	0xC3E1, { 0xEC, 0xB6, 0x98 },
	0xC3E2, { 0xEC, 0xB6, 0x9C },
	0xC3E3, { 0xEC, 0xB6, 0xA4 },
	0xC3E4, { 0xEC, 0xB6, 0xA5 },
	0xC3E5, { 0xEC, 0xB6, 0xA7 },
	0xC3E6, { 0xEC, 0xB6, 0xA9 },
	0xC3E7, { 0xEC, 0xB6, 0xB0 },
	0xC3E8, { 0xEC, 0xB7, 0x84 },
	0xC3E9, { 0xEC, 0xB7, 0x8C },
	0xC3EA, { 0xEC, 0xB7, 0x90 },
	0xC3EB, { 0xEC, 0xB7, 0xA8 },
	0xC3EC, { 0xEC, 0xB7, 0xAC },
	0xC3ED, { 0xEC, 0xB7, 0xB0 },
	0xC3EE, { 0xEC, 0xB7, 0xB8 },
	0xC3EF, { 0xEC, 0xB7, 0xB9 },
	0xC3F0, { 0xEC, 0xB7, 0xBB },
	0xC3F1, { 0xEC, 0xB7, 0xBD },
	0xC3F2, { 0xEC, 0xB8, 0x84 },
	0xC3F3, { 0xEC, 0xB8, 0x88 },
	0xC3F4, { 0xEC, 0xB8, 0x8C },
	0xC3F5, { 0xEC, 0xB8, 0x94 },
	0xC3F6, { 0xEC, 0xB8, 0x99 },
	0xC3F7, { 0xEC, 0xB8, 0xA0 },
	0xC3F8, { 0xEC, 0xB8, 0xA1 },
	0xC3F9, { 0xEC, 0xB8, 0xA4 },
	0xC3FA, { 0xEC, 0xB8, 0xA8 },
	0xC3FB, { 0xEC, 0xB8, 0xB0 },
	0xC3FC, { 0xEC, 0xB8, 0xB1 },
	0xC3FD, { 0xEC, 0xB8, 0xB3 },
	0xC3FE, { 0xEC, 0xB8, 0xB5 },
	0xC4A1, { 0xEC, 0xB9, 0x98 },
	0xC4A2, { 0xEC, 0xB9, 0x99 },
	0xC4A3, { 0xEC, 0xB9, 0x9C },
	0xC4A4, { 0xEC, 0xB9, 0x9F },
	0xC4A5, { 0xEC, 0xB9, 0xA0 },
	0xC4A6, { 0xEC, 0xB9, 0xA1 },
	0xC4A7, { 0xEC, 0xB9, 0xA8 },
	0xC4A8, { 0xEC, 0xB9, 0xA9 },
	0xC4A9, { 0xEC, 0xB9, 0xAB },
	0xC4AA, { 0xEC, 0xB9, 0xAD },
	0xC4AB, { 0xEC, 0xB9, 0xB4 },
	0xC4AC, { 0xEC, 0xB9, 0xB5 },
	0xC4AD, { 0xEC, 0xB9, 0xB8 },
	0xC4AE, { 0xEC, 0xB9, 0xBC },
	0xC4AF, { 0xEC, 0xBA, 0x84 },
	0xC4B0, { 0xEC, 0xBA, 0x85 },
	0xC4B1, { 0xEC, 0xBA, 0x87 },
	0xC4B2, { 0xEC, 0xBA, 0x89 },
	0xC4B3, { 0xEC, 0xBA, 0x90 },
	0xC4B4, { 0xEC, 0xBA, 0x91 },
	0xC4B5, { 0xEC, 0xBA, 0x94 },
	0xC4B6, { 0xEC, 0xBA, 0x98 },
	0xC4B7, { 0xEC, 0xBA, 0xA0 },
	0xC4B8, { 0xEC, 0xBA, 0xA1 },
	0xC4B9, { 0xEC, 0xBA, 0xA3 },
	0xC4BA, { 0xEC, 0xBA, 0xA4 },
	0xC4BB, { 0xEC, 0xBA, 0xA5 },
	0xC4BC, { 0xEC, 0xBA, 0xAC },
	0xC4BD, { 0xEC, 0xBA, 0xAD },
	0xC4BE, { 0xEC, 0xBB, 0x81 },
	0xC4BF, { 0xEC, 0xBB, 0xA4 },
	0xC4C0, { 0xEC, 0xBB, 0xA5 },
	0xC4C1, { 0xEC, 0xBB, 0xA8 },
	0xC4C2, { 0xEC, 0xBB, 0xAB },
	0xC4C3, { 0xEC, 0xBB, 0xAC },
	0xC4C4, { 0xEC, 0xBB, 0xB4 },
	0xC4C5, { 0xEC, 0xBB, 0xB5 },
	0xC4C6, { 0xEC, 0xBB, 0xB7 },
	0xC4C7, { 0xEC, 0xBB, 0xB8 },
	0xC4C8, { 0xEC, 0xBB, 0xB9 },
	0xC4C9, { 0xEC, 0xBC, 0x80 },
	0xC4CA, { 0xEC, 0xBC, 0x81 },
	0xC4CB, { 0xEC, 0xBC, 0x84 },
	0xC4CC, { 0xEC, 0xBC, 0x88 },
	0xC4CD, { 0xEC, 0xBC, 0x90 },
	0xC4CE, { 0xEC, 0xBC, 0x91 },
	0xC4CF, { 0xEC, 0xBC, 0x93 },
	0xC4D0, { 0xEC, 0xBC, 0x95 },
	0xC4D1, { 0xEC, 0xBC, 0x9C },
	0xC4D2, { 0xEC, 0xBC, 0xA0 },
	0xC4D3, { 0xEC, 0xBC, 0xA4 },
	0xC4D4, { 0xEC, 0xBC, 0xAC },
	0xC4D5, { 0xEC, 0xBC, 0xAD },
	0xC4D6, { 0xEC, 0xBC, 0xAF },
	0xC4D7, { 0xEC, 0xBC, 0xB0 },
	0xC4D8, { 0xEC, 0xBC, 0xB1 },
	0xC4D9, { 0xEC, 0xBC, 0xB8 },
	0xC4DA, { 0xEC, 0xBD, 0x94 },
	0xC4DB, { 0xEC, 0xBD, 0x95 },
	0xC4DC, { 0xEC, 0xBD, 0x98 },
	0xC4DD, { 0xEC, 0xBD, 0x9C },
	0xC4DE, { 0xEC, 0xBD, 0xA4 },
	0xC4DF, { 0xEC, 0xBD, 0xA5 },
	0xC4E0, { 0xEC, 0xBD, 0xA7 },
	0xC4E1, { 0xEC, 0xBD, 0xA9 },
	0xC4E2, { 0xEC, 0xBD, 0xB0 },
	0xC4E3, { 0xEC, 0xBD, 0xB1 },
	0xC4E4, { 0xEC, 0xBD, 0xB4 },
	0xC4E5, { 0xEC, 0xBD, 0xB8 },
	0xC4E6, { 0xEC, 0xBE, 0x80 },
	0xC4E7, { 0xEC, 0xBE, 0x85 },
	0xC4E8, { 0xEC, 0xBE, 0x8C },
	0xC4E9, { 0xEC, 0xBE, 0xA1 },
	0xC4EA, { 0xEC, 0xBE, 0xA8 },
	0xC4EB, { 0xEC, 0xBE, 0xB0 },
	0xC4EC, { 0xEC, 0xBF, 0x84 },
	0xC4ED, { 0xEC, 0xBF, 0xA0 },
	0xC4EE, { 0xEC, 0xBF, 0xA1 },
	0xC4EF, { 0xEC, 0xBF, 0xA4 },
	0xC4F0, { 0xEC, 0xBF, 0xA8 },
	0xC4F1, { 0xEC, 0xBF, 0xB0 },
	0xC4F2, { 0xEC, 0xBF, 0xB1 },
	0xC4F3, { 0xEC, 0xBF, 0xB3 },
	0xC4F4, { 0xEC, 0xBF, 0xB5 },
	0xC4F5, { 0xEC, 0xBF, 0xBC },
	0xC4F6, { 0xED, 0x80, 0x80 },
	0xC4F7, { 0xED, 0x80, 0x84 },
	0xC4F8, { 0xED, 0x80, 0x91 },
	0xC4F9, { 0xED, 0x80, 0x98 },
	0xC4FA, { 0xED, 0x80, 0xAD },
	0xC4FB, { 0xED, 0x80, 0xB4 },
	0xC4FC, { 0xED, 0x80, 0xB5 },
	0xC4FD, { 0xED, 0x80, 0xB8 },
	0xC4FE, { 0xED, 0x80, 0xBC },
	0xC5A1, { 0xED, 0x81, 0x84 },
	0xC5A2, { 0xED, 0x81, 0x85 },
	0xC5A3, { 0xED, 0x81, 0x87 },
	0xC5A4, { 0xED, 0x81, 0x89 },
	0xC5A5, { 0xED, 0x81, 0x90 },
	0xC5A6, { 0xED, 0x81, 0x94 },
	0xC5A7, { 0xED, 0x81, 0x98 },
	0xC5A8, { 0xED, 0x81, 0xA0 },
	0xC5A9, { 0xED, 0x81, 0xAC },
	0xC5AA, { 0xED, 0x81, 0xAD },
	0xC5AB, { 0xED, 0x81, 0xB0 },
	0xC5AC, { 0xED, 0x81, 0xB4 },
	0xC5AD, { 0xED, 0x81, 0xBC },
	0xC5AE, { 0xED, 0x81, 0xBD },
	0xC5AF, { 0xED, 0x82, 0x81 },
	0xC5B0, { 0xED, 0x82, 0xA4 },
	0xC5B1, { 0xED, 0x82, 0xA5 },
	0xC5B2, { 0xED, 0x82, 0xA8 },
	0xC5B3, { 0xED, 0x82, 0xAC },
	0xC5B4, { 0xED, 0x82, 0xB4 },
	0xC5B5, { 0xED, 0x82, 0xB5 },
	0xC5B6, { 0xED, 0x82, 0xB7 },
	0xC5B7, { 0xED, 0x82, 0xB9 },
	0xC5B8, { 0xED, 0x83, 0x80 },
	0xC5B9, { 0xED, 0x83, 0x81 },
	0xC5BA, { 0xED, 0x83, 0x84 },
	0xC5BB, { 0xED, 0x83, 0x88 },
	0xC5BC, { 0xED, 0x83, 0x89 },
	0xC5BD, { 0xED, 0x83, 0x90 },
	0xC5BE, { 0xED, 0x83, 0x91 },
	0xC5BF, { 0xED, 0x83, 0x93 },
	0xC5C0, { 0xED, 0x83, 0x94 },
	0xC5C1, { 0xED, 0x83, 0x95 },
	0xC5C2, { 0xED, 0x83, 0x9C },
	0xC5C3, { 0xED, 0x83, 0x9D },
	0xC5C4, { 0xED, 0x83, 0xA0 },
	0xC5C5, { 0xED, 0x83, 0xA4 },
	0xC5C6, { 0xED, 0x83, 0xAC },
	0xC5C7, { 0xED, 0x83, 0xAD },
	0xC5C8, { 0xED, 0x83, 0xAF },
	0xC5C9, { 0xED, 0x83, 0xB0 },
	0xC5CA, { 0xED, 0x83, 0xB1 },
	0xC5CB, { 0xED, 0x83, 0xB8 },
	0xC5CC, { 0xED, 0x84, 0x8D },
	0xC5CD, { 0xED, 0x84, 0xB0 },
	0xC5CE, { 0xED, 0x84, 0xB1 },
	0xC5CF, { 0xED, 0x84, 0xB4 },
	0xC5D0, { 0xED, 0x84, 0xB8 },
	0xC5D1, { 0xED, 0x84, 0xBA },
	0xC5D2, { 0xED, 0x85, 0x80 },
	0xC5D3, { 0xED, 0x85, 0x81 },
	0xC5D4, { 0xED, 0x85, 0x83 },
	0xC5D5, { 0xED, 0x85, 0x84 },
	0xC5D6, { 0xED, 0x85, 0x85 },
	0xC5D7, { 0xED, 0x85, 0x8C },
	0xC5D8, { 0xED, 0x85, 0x8D },
	0xC5D9, { 0xED, 0x85, 0x90 },
	0xC5DA, { 0xED, 0x85, 0x94 },
	0xC5DB, { 0xED, 0x85, 0x9C },
	0xC5DC, { 0xED, 0x85, 0x9D },
	0xC5DD, { 0xED, 0x85, 0x9F },
	0xC5DE, { 0xED, 0x85, 0xA1 },
	0xC5DF, { 0xED, 0x85, 0xA8 },
	0xC5E0, { 0xED, 0x85, 0xAC },
	0xC5E1, { 0xED, 0x85, 0xBC },
	0xC5E2, { 0xED, 0x86, 0x84 },
	0xC5E3, { 0xED, 0x86, 0x88 },
	0xC5E4, { 0xED, 0x86, 0xA0 },
	0xC5E5, { 0xED, 0x86, 0xA1 },
	0xC5E6, { 0xED, 0x86, 0xA4 },
	0xC5E7, { 0xED, 0x86, 0xA8 },
	0xC5E8, { 0xED, 0x86, 0xB0 },
	0xC5E9, { 0xED, 0x86, 0xB1 },
	0xC5EA, { 0xED, 0x86, 0xB3 },
	0xC5EB, { 0xED, 0x86, 0xB5 },
	0xC5EC, { 0xED, 0x86, 0xBA },
	0xC5ED, { 0xED, 0x86, 0xBC },
	0xC5EE, { 0xED, 0x87, 0x80 },
	0xC5EF, { 0xED, 0x87, 0x98 },
	0xC5F0, { 0xED, 0x87, 0xB4 },
	0xC5F1, { 0xED, 0x87, 0xB8 },
	0xC5F2, { 0xED, 0x88, 0x87 },
	0xC5F3, { 0xED, 0x88, 0x89 },
	0xC5F4, { 0xED, 0x88, 0x90 },
	0xC5F5, { 0xED, 0x88, 0xAC },
	0xC5F6, { 0xED, 0x88, 0xAD },
	0xC5F7, { 0xED, 0x88, 0xB0 },
	0xC5F8, { 0xED, 0x88, 0xB4 },
	0xC5F9, { 0xED, 0x88, 0xBC },
	0xC5FA, { 0xED, 0x88, 0xBD },
	0xC5FB, { 0xED, 0x88, 0xBF },
	0xC5FC, { 0xED, 0x89, 0x81 },
	0xC5FD, { 0xED, 0x89, 0x88 },
	0xC5FE, { 0xED, 0x89, 0x9C },
	0xC6A1, { 0xED, 0x89, 0xA4 },
	0xC6A2, { 0xED, 0x8A, 0x80 },
	0xC6A3, { 0xED, 0x8A, 0x81 },
	0xC6A4, { 0xED, 0x8A, 0x84 },
	0xC6A5, { 0xED, 0x8A, 0x88 },
	0xC6A6, { 0xED, 0x8A, 0x90 },
	0xC6A7, { 0xED, 0x8A, 0x91 },
	0xC6A8, { 0xED, 0x8A, 0x95 },
	0xC6A9, { 0xED, 0x8A, 0x9C },
	0xC6AA, { 0xED, 0x8A, 0xA0 },
	0xC6AB, { 0xED, 0x8A, 0xA4 },
	0xC6AC, { 0xED, 0x8A, 0xAC },
	0xC6AD, { 0xED, 0x8A, 0xB1 },
	0xC6AE, { 0xED, 0x8A, 0xB8 },
	0xC6AF, { 0xED, 0x8A, 0xB9 },
	0xC6B0, { 0xED, 0x8A, 0xBC },
	0xC6B1, { 0xED, 0x8A, 0xBF },
	0xC6B2, { 0xED, 0x8B, 0x80 },
	0xC6B3, { 0xED, 0x8B, 0x82 },
	0xC6B4, { 0xED, 0x8B, 0x88 },
	0xC6B5, { 0xED, 0x8B, 0x89 },
	0xC6B6, { 0xED, 0x8B, 0x8B },
	0xC6B7, { 0xED, 0x8B, 0x94 },
	0xC6B8, { 0xED, 0x8B, 0x98 },
	0xC6B9, { 0xED, 0x8B, 0x9C },
	0xC6BA, { 0xED, 0x8B, 0xA4 },
	0xC6BB, { 0xED, 0x8B, 0xA5 },
	0xC6BC, { 0xED, 0x8B, 0xB0 },
	0xC6BD, { 0xED, 0x8B, 0xB1 },
	0xC6BE, { 0xED, 0x8B, 0xB4 },
	0xC6BF, { 0xED, 0x8B, 0xB8 },
	0xC6C0, { 0xED, 0x8C, 0x80 },
	0xC6C1, { 0xED, 0x8C, 0x81 },
	0xC6C2, { 0xED, 0x8C, 0x83 },
	0xC6C3, { 0xED, 0x8C, 0x85 },
	0xC6C4, { 0xED, 0x8C, 0x8C },
	0xC6C5, { 0xED, 0x8C, 0x8D },
	0xC6C6, { 0xED, 0x8C, 0x8E },
	0xC6C7, { 0xED, 0x8C, 0x90 },
	0xC6C8, { 0xED, 0x8C, 0x94 },
	0xC6C9, { 0xED, 0x8C, 0x96 },
	0xC6CA, { 0xED, 0x8C, 0x9C },
	0xC6CB, { 0xED, 0x8C, 0x9D },
	0xC6CC, { 0xED, 0x8C, 0x9F },
	0xC6CD, { 0xED, 0x8C, 0xA0 },
	0xC6CE, { 0xED, 0x8C, 0xA1 },
	0xC6CF, { 0xED, 0x8C, 0xA5 },
	0xC6D0, { 0xED, 0x8C, 0xA8 },
	0xC6D1, { 0xED, 0x8C, 0xA9 },
	0xC6D2, { 0xED, 0x8C, 0xAC },
	0xC6D3, { 0xED, 0x8C, 0xB0 },
	0xC6D4, { 0xED, 0x8C, 0xB8 },
	0xC6D5, { 0xED, 0x8C, 0xB9 },
	0xC6D6, { 0xED, 0x8C, 0xBB },
	0xC6D7, { 0xED, 0x8C, 0xBC },
	0xC6D8, { 0xED, 0x8C, 0xBD },
	0xC6D9, { 0xED, 0x8D, 0x84 },
	0xC6DA, { 0xED, 0x8D, 0x85 },
	0xC6DB, { 0xED, 0x8D, 0xBC },
	0xC6DC, { 0xED, 0x8D, 0xBD },
	0xC6DD, { 0xED, 0x8E, 0x80 },
	0xC6DE, { 0xED, 0x8E, 0x84 },
	0xC6DF, { 0xED, 0x8E, 0x8C },
	0xC6E0, { 0xED, 0x8E, 0x8D },
	0xC6E1, { 0xED, 0x8E, 0x8F },
	0xC6E2, { 0xED, 0x8E, 0x90 },
	0xC6E3, { 0xED, 0x8E, 0x91 },
	0xC6E4, { 0xED, 0x8E, 0x98 },
	0xC6E5, { 0xED, 0x8E, 0x99 },
	0xC6E6, { 0xED, 0x8E, 0x9C },
	0xC6E7, { 0xED, 0x8E, 0xA0 },
	0xC6E8, { 0xED, 0x8E, 0xA8 },
	0xC6E9, { 0xED, 0x8E, 0xA9 },
	0xC6EA, { 0xED, 0x8E, 0xAB },
	0xC6EB, { 0xED, 0x8E, 0xAD },
	0xC6EC, { 0xED, 0x8E, 0xB4 },
	0xC6ED, { 0xED, 0x8E, 0xB8 },
	0xC6EE, { 0xED, 0x8E, 0xBC },
	0xC6EF, { 0xED, 0x8F, 0x84 },
	0xC6F0, { 0xED, 0x8F, 0x85 },
	0xC6F1, { 0xED, 0x8F, 0x88 },
	0xC6F2, { 0xED, 0x8F, 0x89 },
	0xC6F3, { 0xED, 0x8F, 0x90 },
	0xC6F4, { 0xED, 0x8F, 0x98 },
	0xC6F5, { 0xED, 0x8F, 0xA1 },
	0xC6F6, { 0xED, 0x8F, 0xA3 },
	0xC6F7, { 0xED, 0x8F, 0xAC },
	0xC6F8, { 0xED, 0x8F, 0xAD },
	0xC6F9, { 0xED, 0x8F, 0xB0 },
	0xC6FA, { 0xED, 0x8F, 0xB4 },
	0xC6FB, { 0xED, 0x8F, 0xBC },
	0xC6FC, { 0xED, 0x8F, 0xBD },
	0xC6FD, { 0xED, 0x8F, 0xBF },
	0xC6FE, { 0xED, 0x90, 0x81 },
	0xC7A1, { 0xED, 0x90, 0x88 },
	0xC7A2, { 0xED, 0x90, 0x9D },
	0xC7A3, { 0xED, 0x91, 0x80 },
	0xC7A4, { 0xED, 0x91, 0x84 },
	0xC7A5, { 0xED, 0x91, 0x9C },
	0xC7A6, { 0xED, 0x91, 0xA0 },
	0xC7A7, { 0xED, 0x91, 0xA4 },
	0xC7A8, { 0xED, 0x91, 0xAD },
	0xC7A9, { 0xED, 0x91, 0xAF },
	0xC7AA, { 0xED, 0x91, 0xB8 },
	0xC7AB, { 0xED, 0x91, 0xB9 },
	0xC7AC, { 0xED, 0x91, 0xBC },
	0xC7AD, { 0xED, 0x91, 0xBF },
	0xC7AE, { 0xED, 0x92, 0x80 },
	0xC7AF, { 0xED, 0x92, 0x82 },
	0xC7B0, { 0xED, 0x92, 0x88 },
	0xC7B1, { 0xED, 0x92, 0x89 },
	0xC7B2, { 0xED, 0x92, 0x8B },
	0xC7B3, { 0xED, 0x92, 0x8D },
	0xC7B4, { 0xED, 0x92, 0x94 },
	0xC7B5, { 0xED, 0x92, 0xA9 },
	0xC7B6, { 0xED, 0x93, 0x8C },
	0xC7B7, { 0xED, 0x93, 0x90 },
	0xC7B8, { 0xED, 0x93, 0x94 },
	0xC7B9, { 0xED, 0x93, 0x9C },
	0xC7BA, { 0xED, 0x93, 0x9F },
	0xC7BB, { 0xED, 0x93, 0xA8 },
	0xC7BC, { 0xED, 0x93, 0xAC },
	0xC7BD, { 0xED, 0x93, 0xB0 },
	0xC7BE, { 0xED, 0x93, 0xB8 },
	0xC7BF, { 0xED, 0x93, 0xBB },
	0xC7C0, { 0xED, 0x93, 0xBD },
	0xC7C1, { 0xED, 0x94, 0x84 },
	0xC7C2, { 0xED, 0x94, 0x88 },
	0xC7C3, { 0xED, 0x94, 0x8C },
	0xC7C4, { 0xED, 0x94, 0x94 },
	0xC7C5, { 0xED, 0x94, 0x95 },
	0xC7C6, { 0xED, 0x94, 0x97 },
	0xC7C7, { 0xED, 0x94, 0xBC },
	0xC7C8, { 0xED, 0x94, 0xBD },
	0xC7C9, { 0xED, 0x95, 0x80 },
	0xC7CA, { 0xED, 0x95, 0x84 },
	0xC7CB, { 0xED, 0x95, 0x8C },
	0xC7CC, { 0xED, 0x95, 0x8D },
	0xC7CD, { 0xED, 0x95, 0x8F },
	0xC7CE, { 0xED, 0x95, 0x91 },
	0xC7CF, { 0xED, 0x95, 0x98 },
	0xC7D0, { 0xED, 0x95, 0x99 },
	0xC7D1, { 0xED, 0x95, 0x9C },
	0xC7D2, { 0xED, 0x95, 0xA0 },
	0xC7D3, { 0xED, 0x95, 0xA5 },
	0xC7D4, { 0xED, 0x95, 0xA8 },
	0xC7D5, { 0xED, 0x95, 0xA9 },
	0xC7D6, { 0xED, 0x95, 0xAB },
	0xC7D7, { 0xED, 0x95, 0xAD },
	0xC7D8, { 0xED, 0x95, 0xB4 },
	0xC7D9, { 0xED, 0x95, 0xB5 },
	0xC7DA, { 0xED, 0x95, 0xB8 },
	0xC7DB, { 0xED, 0x95, 0xBC },
	0xC7DC, { 0xED, 0x96, 0x84 },
	0xC7DD, { 0xED, 0x96, 0x85 },
	0xC7DE, { 0xED, 0x96, 0x87 },
	0xC7DF, { 0xED, 0x96, 0x88 },
	0xC7E0, { 0xED, 0x96, 0x89 },
	0xC7E1, { 0xED, 0x96, 0x90 },
	0xC7E2, { 0xED, 0x96, 0xA5 },
	0xC7E3, { 0xED, 0x97, 0x88 },
	0xC7E4, { 0xED, 0x97, 0x89 },
	0xC7E5, { 0xED, 0x97, 0x8C },
	0xC7E6, { 0xED, 0x97, 0x90 },
	0xC7E7, { 0xED, 0x97, 0x92 },
	0xC7E8, { 0xED, 0x97, 0x98 },
	0xC7E9, { 0xED, 0x97, 0x99 },
	0xC7EA, { 0xED, 0x97, 0x9B },
	0xC7EB, { 0xED, 0x97, 0x9D },
	0xC7EC, { 0xED, 0x97, 0xA4 },
	0xC7ED, { 0xED, 0x97, 0xA5 },
	0xC7EE, { 0xED, 0x97, 0xA8 },
	0xC7EF, { 0xED, 0x97, 0xAC },
	0xC7F0, { 0xED, 0x97, 0xB4 },
	0xC7F1, { 0xED, 0x97, 0xB5 },
	0xC7F2, { 0xED, 0x97, 0xB7 },
	0xC7F3, { 0xED, 0x97, 0xB9 },
	0xC7F4, { 0xED, 0x98, 0x80 },
	0xC7F5, { 0xED, 0x98, 0x81 },
	0xC7F6, { 0xED, 0x98, 0x84 },
	0xC7F7, { 0xED, 0x98, 0x88 },
	0xC7F8, { 0xED, 0x98, 0x90 },
	0xC7F9, { 0xED, 0x98, 0x91 },
	0xC7FA, { 0xED, 0x98, 0x93 },
	0xC7FB, { 0xED, 0x98, 0x94 },
	0xC7FC, { 0xED, 0x98, 0x95 },
	0xC7FD, { 0xED, 0x98, 0x9C },
	0xC7FE, { 0xED, 0x98, 0xA0 },
	0xC8A1, { 0xED, 0x98, 0xA4 },
	0xC8A2, { 0xED, 0x98, 0xAD },
	0xC8A3, { 0xED, 0x98, 0xB8 },
	0xC8A4, { 0xED, 0x98, 0xB9 },
	0xC8A5, { 0xED, 0x98, 0xBC },
	0xC8A6, { 0xED, 0x99, 0x80 },
	0xC8A7, { 0xED, 0x99, 0x85 },
	0xC8A8, { 0xED, 0x99, 0x88 },
	0xC8A9, { 0xED, 0x99, 0x89 },
	0xC8AA, { 0xED, 0x99, 0x8B },
	0xC8AB, { 0xED, 0x99, 0x8D },
	0xC8AC, { 0xED, 0x99, 0x91 },
	0xC8AD, { 0xED, 0x99, 0x94 },
	0xC8AE, { 0xED, 0x99, 0x95 },
	0xC8AF, { 0xED, 0x99, 0x98 },
	0xC8B0, { 0xED, 0x99, 0x9C },
	0xC8B1, { 0xED, 0x99, 0xA7 },
	0xC8B2, { 0xED, 0x99, 0xA9 },
	0xC8B3, { 0xED, 0x99, 0xB0 },
	0xC8B4, { 0xED, 0x99, 0xB1 },
	0xC8B5, { 0xED, 0x99, 0xB4 },
	0xC8B6, { 0xED, 0x9A, 0x83 },
	0xC8B7, { 0xED, 0x9A, 0x85 },
	0xC8B8, { 0xED, 0x9A, 0x8C },
	0xC8B9, { 0xED, 0x9A, 0x8D },
	0xC8BA, { 0xED, 0x9A, 0x90 },
	0xC8BB, { 0xED, 0x9A, 0x94 },
	0xC8BC, { 0xED, 0x9A, 0x9D },
	0xC8BD, { 0xED, 0x9A, 0x9F },
	0xC8BE, { 0xED, 0x9A, 0xA1 },
	0xC8BF, { 0xED, 0x9A, 0xA8 },
	0xC8C0, { 0xED, 0x9A, 0xAC },
	0xC8C1, { 0xED, 0x9A, 0xB0 },
	0xC8C2, { 0xED, 0x9A, 0xB9 },
	0xC8C3, { 0xED, 0x9A, 0xBB },
	0xC8C4, { 0xED, 0x9B, 0x84 },
	0xC8C5, { 0xED, 0x9B, 0x85 },
	0xC8C6, { 0xED, 0x9B, 0x88 },
	0xC8C7, { 0xED, 0x9B, 0x8C },
	0xC8C8, { 0xED, 0x9B, 0x91 },
	0xC8C9, { 0xED, 0x9B, 0x94 },
	0xC8CA, { 0xED, 0x9B, 0x97 },
	0xC8CB, { 0xED, 0x9B, 0x99 },
	0xC8CC, { 0xED, 0x9B, 0xA0 },
	0xC8CD, { 0xED, 0x9B, 0xA4 },
	0xC8CE, { 0xED, 0x9B, 0xA8 },
	0xC8CF, { 0xED, 0x9B, 0xB0 },
	0xC8D0, { 0xED, 0x9B, 0xB5 },
	0xC8D1, { 0xED, 0x9B, 0xBC },
	0xC8D2, { 0xED, 0x9B, 0xBD },
	0xC8D3, { 0xED, 0x9C, 0x80 },
	0xC8D4, { 0xED, 0x9C, 0x84 },
	0xC8D5, { 0xED, 0x9C, 0x91 },
	0xC8D6, { 0xED, 0x9C, 0x98 },
	0xC8D7, { 0xED, 0x9C, 0x99 },
	0xC8D8, { 0xED, 0x9C, 0x9C },
	0xC8D9, { 0xED, 0x9C, 0xA0 },
	0xC8DA, { 0xED, 0x9C, 0xA8 },
	0xC8DB, { 0xED, 0x9C, 0xA9 },
	0xC8DC, { 0xED, 0x9C, 0xAB },
	0xC8DD, { 0xED, 0x9C, 0xAD },
	0xC8DE, { 0xED, 0x9C, 0xB4 },
	0xC8DF, { 0xED, 0x9C, 0xB5 },
	0xC8E0, { 0xED, 0x9C, 0xB8 },
	0xC8E1, { 0xED, 0x9C, 0xBC },
	0xC8E2, { 0xED, 0x9D, 0x84 },
	0xC8E3, { 0xED, 0x9D, 0x87 },
	0xC8E4, { 0xED, 0x9D, 0x89 },
	0xC8E5, { 0xED, 0x9D, 0x90 },
	0xC8E6, { 0xED, 0x9D, 0x91 },
	0xC8E7, { 0xED, 0x9D, 0x94 },
	0xC8E8, { 0xED, 0x9D, 0x96 },
	0xC8E9, { 0xED, 0x9D, 0x97 },
	0xC8EA, { 0xED, 0x9D, 0x98 },
	0xC8EB, { 0xED, 0x9D, 0x99 },
	0xC8EC, { 0xED, 0x9D, 0xA0 },
	0xC8ED, { 0xED, 0x9D, 0xA1 },
	0xC8EE, { 0xED, 0x9D, 0xA3 },
	0xC8EF, { 0xED, 0x9D, 0xA5 },
	0xC8F0, { 0xED, 0x9D, 0xA9 },
	0xC8F1, { 0xED, 0x9D, 0xAC },
	0xC8F2, { 0xED, 0x9D, 0xB0 },
	0xC8F3, { 0xED, 0x9D, 0xB4 },
	0xC8F4, { 0xED, 0x9D, 0xBC },
	0xC8F5, { 0xED, 0x9D, 0xBD },
	0xC8F6, { 0xED, 0x9E, 0x81 },
	0xC8F7, { 0xED, 0x9E, 0x88 },
	0xC8F8, { 0xED, 0x9E, 0x89 },
	0xC8F9, { 0xED, 0x9E, 0x8C },
	0xC8FA, { 0xED, 0x9E, 0x90 },
	0xC8FB, { 0xED, 0x9E, 0x98 },
	0xC8FC, { 0xED, 0x9E, 0x99 },
	0xC8FD, { 0xED, 0x9E, 0x9B },
	0xC8FE, { 0xED, 0x9E, 0x9D },
	0xCAA1, { 0xE4, 0xBC, 0xBD },
	0xCAA2, { 0xE4, 0xBD, 0xB3 },
	0xCAA3, { 0xE5, 0x81, 0x87 },
	0xCAA4, { 0xE5, 0x83, 0xB9 },
	0xCAA5, { 0xE5, 0x8A, 0xA0 },
	0xCAA6, { 0xE5, 0x8F, 0xAF },
	0xCAA7, { 0xE5, 0x91, 0xB5 },
	0xCAA8, { 0xE5, 0x93, 0xA5 },
	0xCAA9, { 0xE5, 0x98, 0x89 },
	0xCAAA, { 0xE5, 0xAB, 0x81 },
	0xCAAB, { 0xE5, 0xAE, 0xB6 },
	0xCAAC, { 0xE6, 0x9A, 0x87 },
	0xCAAD, { 0xE6, 0x9E, 0xB6 },
	0xCAAE, { 0xE6, 0x9E, 0xB7 },
	0xCAAF, { 0xE6, 0x9F, 0xAF },
	0xCAB0, { 0xE6, 0xAD, 0x8C },
	0xCAB1, { 0xE7, 0x8F, 0x82 },
	0xCAB2, { 0xE7, 0x97, 0x82 },
	0xCAB3, { 0xE7, 0xA8, 0xBC },
	0xCAB4, { 0xE8, 0x8B, 0x9B },
	0xCAB5, { 0xE8, 0x8C, 0x84 },
	0xCAB6, { 0xE8, 0xA1, 0x97 },
	0xCAB7, { 0xE8, 0xA2, 0x88 },
	0xCAB8, { 0xE8, 0xA8, 0xB6 },
	0xCAB9, { 0xE8, 0xB3, 0x88 },
	0xCABA, { 0xE8, 0xB7, 0x8F },
	0xCABB, { 0xE8, 0xBB, 0xBB },
	0xCABC, { 0xE8, 0xBF, 0xA6 },
	0xCABD, { 0xE9, 0xA7, 0x95 },
	0xCABE, { 0xE5, 0x88, 0xBB },
	0xCABF, { 0xE5, 0x8D, 0xB4 },
	0xCAC0, { 0xE5, 0x90, 0x84 },
	0xCAC1, { 0xE6, 0x81, 0xAA },
	0xCAC2, { 0xE6, 0x85, 0xA4 },
	0xCAC3, { 0xE6, 0xAE, 0xBC },
	0xCAC4, { 0xE7, 0x8F, 0x8F },
	0xCAC5, { 0xE8, 0x84, 0x9A },
	0xCAC6, { 0xE8, 0xA6, 0xBA },
	0xCAC7, { 0xE8, 0xA7, 0x92 },
	0xCAC8, { 0xE9, 0x96, 0xA3 },
	0xCAC9, { 0xE4, 0xBE, 0x83 },
	0xCACA, { 0xE5, 0x88, 0x8A },
	0xCACB, { 0xE5, 0xA2, 0xBE },
	0xCACC, { 0xE5, 0xA5, 0xB8 },
	0xCACD, { 0xE5, 0xA7, 0xA6 },
	0xCACE, { 0xE5, 0xB9, 0xB2 },
	0xCACF, { 0xE5, 0xB9, 0xB9 },
	0xCAD0, { 0xE6, 0x87, 0x87 },
	0xCAD1, { 0xE6, 0x8F, 0x80 },
	0xCAD2, { 0xE6, 0x9D, 0x86 },
	0xCAD3, { 0xE6, 0x9F, 0xAC },
	0xCAD4, { 0xE6, 0xA1, 0xBF },
	0xCAD5, { 0xE6, 0xBE, 0x97 },
	0xCAD6, { 0xE7, 0x99, 0x8E },
	0xCAD7, { 0xE7, 0x9C, 0x8B },
	0xCAD8, { 0xE7, 0xA3, 0xB5 },
	0xCAD9, { 0xE7, 0xA8, 0x88 },
	0xCADA, { 0xE7, 0xAB, 0xBF },
	0xCADB, { 0xE7, 0xB0, 0xA1 },
	0xCADC, { 0xE8, 0x82, 0x9D },
	0xCADD, { 0xE8, 0x89, 0xAE },
	0xCADE, { 0xE8, 0x89, 0xB1 },
	0xCADF, { 0xE8, 0xAB, 0xAB },
	0xCAE0, { 0xE9, 0x96, 0x93 },
	0xCAE1, { 0xE4, 0xB9, 0xAB },
	0xCAE2, { 0xE5, 0x96, 0x9D },
	0xCAE3, { 0xE6, 0x9B, 0xB7 },
	0xCAE4, { 0xE6, 0xB8, 0xB4 },
	0xCAE5, { 0xE7, 0xA2, 0xA3 },
	0xCAE6, { 0xE7, 0xAB, 0xAD },
	0xCAE7, { 0xE8, 0x91, 0x9B },
	0xCAE8, { 0xE8, 0xA4, 0x90 },
	0xCAE9, { 0xE8, 0x9D, 0x8E },
	0xCAEA, { 0xE9, 0x9E, 0xA8 },
	0xCAEB, { 0xE5, 0x8B, 0x98 },
	0xCAEC, { 0xE5, 0x9D, 0x8E },
	0xCAED, { 0xE5, 0xA0, 0xAA },
	0xCAEE, { 0xE5, 0xB5, 0x8C },
	0xCAEF, { 0xE6, 0x84, 0x9F },
	0xCAF0, { 0xE6, 0x86, 0xBE },
	0xCAF1, { 0xE6, 0x88, 0xA1 },
	0xCAF2, { 0xE6, 0x95, 0xA2 },
	0xCAF3, { 0xE6, 0x9F, 0x91 },
	0xCAF4, { 0xE6, 0xA9, 0x84 },
	0xCAF5, { 0xE6, 0xB8, 0x9B },
	0xCAF6, { 0xE7, 0x94, 0x98 },
	0xCAF7, { 0xE7, 0x96, 0xB3 },
	0xCAF8, { 0xE7, 0x9B, 0xA3 },
	0xCAF9, { 0xE7, 0x9E, 0xB0 },
	0xCAFA, { 0xE7, 0xB4, 0xBA },
	0xCAFB, { 0xE9, 0x82, 0xAF },
	0xCAFC, { 0xE9, 0x91, 0x91 },
	0xCAFD, { 0xE9, 0x91, 0x92 },
	0xCAFE, { 0xE9, 0xBE, 0x95 },
	0xCBA1, { 0xE5, 0x8C, 0xA3 },
	0xCBA2, { 0xE5, 0xB2, 0xAC },
	0xCBA3, { 0xE7, 0x94, 0xB2 },
	0xCBA4, { 0xE8, 0x83, 0x9B },
	0xCBA5, { 0xE9, 0x89, 0x80 },
	0xCBA6, { 0xE9, 0x96, 0x98 },
	0xCBA7, { 0xE5, 0x89, 0x9B },
	0xCBA8, { 0xE5, 0xA0, 0x88 },
	0xCBA9, { 0xE5, 0xA7, 0x9C },
	0xCBAA, { 0xE5, 0xB2, 0xA1 },
	0xCBAB, { 0xE5, 0xB4, 0x97 },
	0xCBAC, { 0xE5, 0xBA, 0xB7 },
	0xCBAD, { 0xE5, 0xBC, 0xBA },
	0xCBAE, { 0xE5, 0xBD, 0x8A },
	0xCBAF, { 0xE6, 0x85, 0xB7 },
	0xCBB0, { 0xE6, 0xB1, 0x9F },
	0xCBB1, { 0xE7, 0x95, 0xBA },
	0xCBB2, { 0xE7, 0x96, 0x86 },
	0xCBB3, { 0xE7, 0xB3, 0xA0 },
	0xCBB4, { 0xE7, 0xB5, 0xB3 },
	0xCBB5, { 0xE7, 0xB6, 0xB1 },
	0xCBB6, { 0xE7, 0xBE, 0x8C },
	0xCBB7, { 0xE8, 0x85, 0x94 },
	0xCBB8, { 0xE8, 0x88, 0xA1 },
	0xCBB9, { 0xE8, 0x96, 0x91 },
	0xCBBA, { 0xE8, 0xA5, 0x81 },
	0xCBBB, { 0xE8, 0xAC, 0x9B },
	0xCBBC, { 0xE9, 0x8B, 0xBC },
	0xCBBD, { 0xE9, 0x99, 0x8D },
	0xCBBE, { 0xE9, 0xB1, 0x87 },
	0xCBBF, { 0xE4, 0xBB, 0x8B },
	0xCBC0, { 0xE4, 0xBB, 0xB7 },
	0xCBC1, { 0xE5, 0x80, 0x8B },
	0xCBC2, { 0xE5, 0x87, 0xB1 },
	0xCBC3, { 0xE5, 0xA1, 0x8F },
	0xCBC4, { 0xE6, 0x84, 0xB7 },
	0xCBC5, { 0xE6, 0x84, 0xBE },
	0xCBC6, { 0xE6, 0x85, 0xA8 },
	0xCBC7, { 0xE6, 0x94, 0xB9 },
	0xCBC8, { 0xE6, 0xA7, 0xAA },
	0xCBC9, { 0xE6, 0xBC, 0x91 },
	0xCBCA, { 0xE7, 0x96, 0xA5 },
	0xCBCB, { 0xE7, 0x9A, 0x86 },
	0xCBCC, { 0xE7, 0x9B, 0x96 },
	0xCBCD, { 0xE7, 0xAE, 0x87 },
	0xCBCE, { 0xE8, 0x8A, 0xA5 },
	0xCBCF, { 0xE8, 0x93, 0x8B },
	0xCBD0, { 0xEF, 0xA4, 0x80 },
	0xCBD1, { 0xE9, 0x8E, 0xA7 },
	0xCBD2, { 0xE9, 0x96, 0x8B },
	0xCBD3, { 0xE5, 0x96, 0x80 },
	0xCBD4, { 0xE5, 0xAE, 0xA2 },
	0xCBD5, { 0xE5, 0x9D, 0x91 },
	0xCBD6, { 0xEF, 0xA4, 0x81 },
	0xCBD7, { 0xE7, 0xB2, 0xB3 },
	0xCBD8, { 0xE7, 0xBE, 0xB9 },
	0xCBD9, { 0xE9, 0x86, 0xB5 },
	0xCBDA, { 0xE5, 0x80, 0xA8 },
	0xCBDB, { 0xE5, 0x8E, 0xBB },
	0xCBDC, { 0xE5, 0xB1, 0x85 },
	0xCBDD, { 0xE5, 0xB7, 0xA8 },
	0xCBDE, { 0xE6, 0x8B, 0x92 },
	0xCBDF, { 0xE6, 0x8D, 0xAE },
	0xCBE0, { 0xE6, 0x93, 0x9A },
	0xCBE1, { 0xE6, 0x93, 0xA7 },
	0xCBE2, { 0xE6, 0xB8, 0xA0 },
	0xCBE3, { 0xE7, 0x82, 0xAC },
	0xCBE4, { 0xE7, 0xA5, 0x9B },
	0xCBE5, { 0xE8, 0xB7, 0x9D },
	0xCBE6, { 0xE8, 0xB8, 0x9E },
	0xCBE7, { 0xEF, 0xA4, 0x82 },
	0xCBE8, { 0xE9, 0x81, 0xBD },
	0xCBE9, { 0xE9, 0x89, 0x85 },
	0xCBEA, { 0xE9, 0x8B, 0xB8 },
	0xCBEB, { 0xE4, 0xB9, 0xBE },
	0xCBEC, { 0xE4, 0xBB, 0xB6 },
	0xCBED, { 0xE5, 0x81, 0xA5 },
	0xCBEE, { 0xE5, 0xB7, 0xBE },
	0xCBEF, { 0xE5, 0xBB, 0xBA },
	0xCBF0, { 0xE6, 0x84, 0x86 },
	0xCBF1, { 0xE6, 0xA5, 0x97 },
	0xCBF2, { 0xE8, 0x85, 0xB1 },
	0xCBF3, { 0xE8, 0x99, 0x94 },
	0xCBF4, { 0xE8, 0xB9, 0x87 },
	0xCBF5, { 0xE9, 0x8D, 0xB5 },
	0xCBF6, { 0xE9, 0xA8, 0xAB },
	0xCBF7, { 0xE4, 0xB9, 0x9E },
	0xCBF8, { 0xE5, 0x82, 0x91 },
	0xCBF9, { 0xE6, 0x9D, 0xB0 },
	0xCBFA, { 0xE6, 0xA1, 0x80 },
	0xCBFB, { 0xE5, 0x84, 0x89 },
	0xCBFC, { 0xE5, 0x8A, 0x8D },
	0xCBFD, { 0xE5, 0x8A, 0x92 },
	0xCBFE, { 0xE6, 0xAA, 0xA2 },
	0xCCA1, { 0xE7, 0x9E, 0xBC },
	0xCCA2, { 0xE9, 0x88, 0x90 },
	0xCCA3, { 0xE9, 0xBB, 0x94 },
	0xCCA4, { 0xE5, 0x8A, 0xAB },
	0xCCA5, { 0xE6, 0x80, 0xAF },
	0xCCA6, { 0xE8, 0xBF, 0xB2 },
	0xCCA7, { 0xE5, 0x81, 0x88 },
	0xCCA8, { 0xE6, 0x86, 0xA9 },
	0xCCA9, { 0xE6, 0x8F, 0xAD },
	0xCCAA, { 0xE6, 0x93, 0x8A },
	0xCCAB, { 0xE6, 0xA0, 0xBC },
	0xCCAC, { 0xE6, 0xAA, 0x84 },
	0xCCAD, { 0xE6, 0xBF, 0x80 },
	0xCCAE, { 0xE8, 0x86, 0x88 },
	0xCCAF, { 0xE8, 0xA6, 0xA1 },
	0xCCB0, { 0xE9, 0x9A, 0x94 },
	0xCCB1, { 0xE5, 0xA0, 0x85 },
	0xCCB2, { 0xE7, 0x89, 0xBD },
	0xCCB3, { 0xE7, 0x8A, 0xAC },
	0xCCB4, { 0xE7, 0x94, 0x84 },
	0xCCB5, { 0xE7, 0xB5, 0xB9 },
	0xCCB6, { 0xE7, 0xB9, 0xAD },
	0xCCB7, { 0xE8, 0x82, 0xA9 },
	0xCCB8, { 0xE8, 0xA6, 0x8B },
	0xCCB9, { 0xE8, 0xAD, 0xB4 },
	0xCCBA, { 0xE9, 0x81, 0xA3 },
	0xCCBB, { 0xE9, 0xB5, 0x91 },
	0xCCBC, { 0xE6, 0x8A, 0x89 },
	0xCCBD, { 0xE6, 0xB1, 0xBA },
	0xCCBE, { 0xE6, 0xBD, 0x94 },
	0xCCBF, { 0xE7, 0xB5, 0x90 },
	0xCCC0, { 0xE7, 0xBC, 0xBA },
	0xCCC1, { 0xE8, 0xA8, 0xA3 },
	0xCCC2, { 0xE5, 0x85, 0xBC },
	0xCCC3, { 0xE6, 0x85, 0x8A },
	0xCCC4, { 0xE7, 0xAE, 0x9D },
	0xCCC5, { 0xE8, 0xAC, 0x99 },
	0xCCC6, { 0xE9, 0x89, 0x97 },
	0xCCC7, { 0xE9, 0x8E, 0x8C },
	0xCCC8, { 0xE4, 0xBA, 0xAC },
	0xCCC9, { 0xE4, 0xBF, 0x93 },
	0xCCCA, { 0xE5, 0x80, 0x9E },
	0xCCCB, { 0xE5, 0x82, 0xBE },
	0xCCCC, { 0xE5, 0x84, 0x86 },
	0xCCCD, { 0xE5, 0x8B, 0x81 },
	0xCCCE, { 0xE5, 0x8B, 0x8D },
	0xCCCF, { 0xE5, 0x8D, 0xBF },
	0xCCD0, { 0xE5, 0x9D, 0xB0 },
	0xCCD1, { 0xE5, 0xA2, 0x83 },
	0xCCD2, { 0xE5, 0xBA, 0x9A },
	0xCCD3, { 0xE5, 0xBE, 0x91 },
	0xCCD4, { 0xE6, 0x85, 0xB6 },
	0xCCD5, { 0xE6, 0x86, 0xAC },
	0xCCD6, { 0xE6, 0x93, 0x8E },
	0xCCD7, { 0xE6, 0x95, 0xAC },
	0xCCD8, { 0xE6, 0x99, 0xAF },
	0xCCD9, { 0xE6, 0x9A, 0xBB },
	0xCCDA, { 0xE6, 0x9B, 0xB4 },
	0xCCDB, { 0xE6, 0xA2, 0x97 },
	0xCCDC, { 0xE6, 0xB6, 0x87 },
	0xCCDD, { 0xE7, 0x82, 0x85 },
	0xCCDE, { 0xE7, 0x83, 0xB1 },
	0xCCDF, { 0xE7, 0x92, 0x9F },
	0xCCE0, { 0xE7, 0x92, 0xA5 },
	0xCCE1, { 0xE7, 0x93, 0x8A },
	0xCCE2, { 0xE7, 0x97, 0x99 },
	0xCCE3, { 0xE7, 0xA1, 0xAC },
	0xCCE4, { 0xE7, 0xA3, 0xAC },
	0xCCE5, { 0xE7, 0xAB, 0x9F },
	0xCCE6, { 0xE7, 0xAB, 0xB6 },
	0xCCE7, { 0xE7, 0xB5, 0x85 },
	0xCCE8, { 0xE7, 0xB6, 0x93 },
	0xCCE9, { 0xE8, 0x80, 0x95 },
	0xCCEA, { 0xE8, 0x80, 0xBF },
	0xCCEB, { 0xE8, 0x84, 0x9B },
	0xCCEC, { 0xE8, 0x8E, 0x96 },
	0xCCED, { 0xE8, 0xAD, 0xA6 },
	0xCCEE, { 0xE8, 0xBC, 0x95 },
	0xCCEF, { 0xE9, 0x80, 0x95 },
	0xCCF0, { 0xE9, 0x8F, 0xA1 },
	0xCCF1, { 0xE9, 0xA0, 0x83 },
	0xCCF2, { 0xE9, 0xA0, 0xB8 },
	0xCCF3, { 0xE9, 0xA9, 0x9A },
	0xCCF4, { 0xE9, 0xAF, 0xA8 },
	0xCCF5, { 0xE4, 0xBF, 0x82 },
	0xCCF6, { 0xE5, 0x95, 0x93 },
	0xCCF7, { 0xE5, 0xA0, 0xBA },
	0xCCF8, { 0xE5, 0xA5, 0x91 },
	0xCCF9, { 0xE5, 0xAD, 0xA3 },
	0xCCFA, { 0xE5, 0xB1, 0x86 },
	0xCCFB, { 0xE6, 0x82, 0xB8 },
	0xCCFC, { 0xE6, 0x88, 0x92 },
	0xCCFD, { 0xE6, 0xA1, 0x82 },
	0xCCFE, { 0xE6, 0xA2, 0xB0 },
	0xCDA1, { 0xE6, 0xA3, 0xA8 },
	0xCDA2, { 0xE6, 0xBA, 0xAA },
	0xCDA3, { 0xE7, 0x95, 0x8C },
	0xCDA4, { 0xE7, 0x99, 0xB8 },
	0xCDA5, { 0xE7, 0xA3, 0x8E },
	0xCDA6, { 0xE7, 0xA8, 0xBD },
	0xCDA7, { 0xE7, 0xB3, 0xBB },
	0xCDA8, { 0xE7, 0xB9, 0xAB },
	0xCDA9, { 0xE7, 0xB9, 0xBC },
	0xCDAA, { 0xE8, 0xA8, 0x88 },
	0xCDAB, { 0xE8, 0xAA, 0xA1 },
	0xCDAC, { 0xE8, 0xB0, 0xBF },
	0xCDAD, { 0xE9, 0x9A, 0x8E },
	0xCDAE, { 0xE9, 0xB7, 0x84 },
	0xCDAF, { 0xE5, 0x8F, 0xA4 },
	0xCDB0, { 0xE5, 0x8F, 0xA9 },
	0xCDB1, { 0xE5, 0x91, 0x8A },
	0xCDB2, { 0xE5, 0x91, 0xB1 },
	0xCDB3, { 0xE5, 0x9B, 0xBA },
	0xCDB4, { 0xE5, 0xA7, 0x91 },
	0xCDB5, { 0xE5, 0xAD, 0xA4 },
	0xCDB6, { 0xE5, 0xB0, 0xBB },
	0xCDB7, { 0xE5, 0xBA, 0xAB },
	0xCDB8, { 0xE6, 0x8B, 0xB7 },
	0xCDB9, { 0xE6, 0x94, 0xB7 },
	0xCDBA, { 0xE6, 0x95, 0x85 },
	0xCDBB, { 0xE6, 0x95, 0xB2 },
	0xCDBC, { 0xE6, 0x9A, 0xA0 },
	0xCDBD, { 0xE6, 0x9E, 0xAF },
	0xCDBE, { 0xE6, 0xA7, 0x81 },
	0xCDBF, { 0xE6, 0xB2, 0xBD },
	0xCDC0, { 0xE7, 0x97, 0xBC },
	0xCDC1, { 0xE7, 0x9A, 0x90 },
	0xCDC2, { 0xE7, 0x9D, 0xBE },
	0xCDC3, { 0xE7, 0xA8, 0xBF },
	0xCDC4, { 0xE7, 0xBE, 0x94 },
	0xCDC5, { 0xE8, 0x80, 0x83 },
	0xCDC6, { 0xE8, 0x82, 0xA1 },
	0xCDC7, { 0xE8, 0x86, 0x8F },
	0xCDC8, { 0xE8, 0x8B, 0xA6 },
	0xCDC9, { 0xE8, 0x8B, 0xBD },
	0xCDCA, { 0xE8, 0x8F, 0xB0 },
	0xCDCB, { 0xE8, 0x97, 0x81 },
	0xCDCC, { 0xE8, 0xA0, 0xB1 },
	0xCDCD, { 0xE8, 0xA2, 0xB4 },
	0xCDCE, { 0xE8, 0xAA, 0xA5 },
	0xCDCF, { 0xEF, 0xA4, 0x83 },
	0xCDD0, { 0xE8, 0xBE, 0x9C },
	0xCDD1, { 0xE9, 0x8C, 0xAE },
	0xCDD2, { 0xE9, 0x9B, 0x87 },
	0xCDD3, { 0xE9, 0xA1, 0xA7 },
	0xCDD4, { 0xE9, 0xAB, 0x98 },
	0xCDD5, { 0xE9, 0xBC, 0x93 },
	0xCDD6, { 0xE5, 0x93, 0xAD },
	0xCDD7, { 0xE6, 0x96, 0x9B },
	0xCDD8, { 0xE6, 0x9B, 0xB2 },
	0xCDD9, { 0xE6, 0xA2, 0x8F },
	0xCDDA, { 0xE7, 0xA9, 0x80 },
	0xCDDB, { 0xE8, 0xB0, 0xB7 },
	0xCDDC, { 0xE9, 0xB5, 0xA0 },
	0xCDDD, { 0xE5, 0x9B, 0xB0 },
	0xCDDE, { 0xE5, 0x9D, 0xA4 },
	0xCDDF, { 0xE5, 0xB4, 0x91 },
	0xCDE0, { 0xE6, 0x98, 0x86 },
	0xCDE1, { 0xE6, 0xA2, 0xB1 },
	0xCDE2, { 0xE6, 0xA3, 0x8D },
	0xCDE3, { 0xE6, 0xBB, 0xBE },
	0xCDE4, { 0xE7, 0x90, 0xA8 },
	0xCDE5, { 0xE8, 0xA2, 0x9E },
	0xCDE6, { 0xE9, 0xAF, 0xA4 },
	0xCDE7, { 0xE6, 0xB1, 0xA8 },
	0xCDE8, { 0xEF, 0xA4, 0x84 },
	0xCDE9, { 0xE9, 0xAA, 0xA8 },
	0xCDEA, { 0xE4, 0xBE, 0x9B },
	0xCDEB, { 0xE5, 0x85, 0xAC },
	0xCDEC, { 0xE5, 0x85, 0xB1 },
	0xCDED, { 0xE5, 0x8A, 0x9F },
	0xCDEE, { 0xE5, 0xAD, 0x94 },
	0xCDEF, { 0xE5, 0xB7, 0xA5 },
	0xCDF0, { 0xE6, 0x81, 0x90 },
	0xCDF1, { 0xE6, 0x81, 0xAD },
	0xCDF2, { 0xE6, 0x8B, 0xB1 },
	0xCDF3, { 0xE6, 0x8E, 0xA7 },
	0xCDF4, { 0xE6, 0x94, 0xBB },
	0xCDF5, { 0xE7, 0x8F, 0x99 },
	0xCDF6, { 0xE7, 0xA9, 0xBA },
	0xCDF7, { 0xE8, 0x9A, 0xA3 },
	0xCDF8, { 0xE8, 0xB2, 0xA2 },
	0xCDF9, { 0xE9, 0x9E, 0x8F },
	0xCDFA, { 0xE4, 0xB8, 0xB2 },
	0xCDFB, { 0xE5, 0xAF, 0xA1 },
	0xCDFC, { 0xE6, 0x88, 0x88 },
	0xCDFD, { 0xE6, 0x9E, 0x9C },
	0xCDFE, { 0xE7, 0x93, 0x9C },
	0xCEA1, { 0xE7, 0xA7, 0x91 },
	0xCEA2, { 0xE8, 0x8F, 0x93 },
	0xCEA3, { 0xE8, 0xAA, 0x87 },
	0xCEA4, { 0xE8, 0xAA, 0xB2 },
	0xCEA5, { 0xE8, 0xB7, 0xA8 },
	0xCEA6, { 0xE9, 0x81, 0x8E },
	0xCEA7, { 0xE9, 0x8D, 0x8B },
	0xCEA8, { 0xE9, 0xA1, 0x86 },
	0xCEA9, { 0xE5, 0xBB, 0x93 },
	0xCEAA, { 0xE6, 0xA7, 0xA8 },
	0xCEAB, { 0xE8, 0x97, 0xBF },
	0xCEAC, { 0xE9, 0x83, 0xAD },
	0xCEAD, { 0xEF, 0xA4, 0x85 },
	0xCEAE, { 0xE5, 0x86, 0xA0 },
	0xCEAF, { 0xE5, 0xAE, 0x98 },
	0xCEB0, { 0xE5, 0xAF, 0xAC },
	0xCEB1, { 0xE6, 0x85, 0xA3 },
	0xCEB2, { 0xE6, 0xA3, 0xBA },
	0xCEB3, { 0xE6, 0xAC, 0xBE },
	0xCEB4, { 0xE7, 0x81, 0x8C },
	0xCEB5, { 0xE7, 0x90, 0xAF },
	0xCEB6, { 0xE7, 0x93, 0x98 },
	0xCEB7, { 0xE7, 0xAE, 0xA1 },
	0xCEB8, { 0xE7, 0xBD, 0x90 },
	0xCEB9, { 0xE8, 0x8F, 0x85 },
	0xCEBA, { 0xE8, 0xA7, 0x80 },
	0xCEBB, { 0xE8, 0xB2, 0xAB },
	0xCEBC, { 0xE9, 0x97, 0x9C },
	0xCEBD, { 0xE9, 0xA4, 0xA8 },
	0xCEBE, { 0xE5, 0x88, 0xAE },
	0xCEBF, { 0xE6, 0x81, 0x9D },
	0xCEC0, { 0xE6, 0x8B, 0xAC },
	0xCEC1, { 0xE9, 0x80, 0x82 },
	0xCEC2, { 0xE4, 0xBE, 0x8A },
	0xCEC3, { 0xE5, 0x85, 0x89 },
	0xCEC4, { 0xE5, 0x8C, 0xA1 },
	0xCEC5, { 0xE5, 0xA3, 0x99 },
	0xCEC6, { 0xE5, 0xBB, 0xA3 },
	0xCEC7, { 0xE6, 0x9B, 0xA0 },
	0xCEC8, { 0xE6, 0xB4, 0xB8 },
	0xCEC9, { 0xE7, 0x82, 0x9A },
	0xCECA, { 0xE7, 0x8B, 0x82 },
	0xCECB, { 0xE7, 0x8F, 0x96 },
	0xCECC, { 0xE7, 0xAD, 0x90 },
	0xCECD, { 0xE8, 0x83, 0xB1 },
	0xCECE, { 0xE9, 0x91, 0x9B },
	0xCECF, { 0xE5, 0x8D, 0xA6 },
	0xCED0, { 0xE6, 0x8E, 0x9B },
	0xCED1, { 0xE7, 0xBD, 0xAB },
	0xCED2, { 0xE4, 0xB9, 0x96 },
	0xCED3, { 0xE5, 0x82, 0x80 },
	0xCED4, { 0xE5, 0xA1, 0x8A },
	0xCED5, { 0xE5, 0xA3, 0x9E },
	0xCED6, { 0xE6, 0x80, 0xAA },
	0xCED7, { 0xE6, 0x84, 0xA7 },
	0xCED8, { 0xE6, 0x8B, 0x90 },
	0xCED9, { 0xE6, 0xA7, 0x90 },
	0xCEDA, { 0xE9, 0xAD, 0x81 },
	0xCEDB, { 0xE5, 0xAE, 0x8F },
	0xCEDC, { 0xE7, 0xB4, 0x98 },
	0xCEDD, { 0xE8, 0x82, 0xB1 },
	0xCEDE, { 0xE8, 0xBD, 0x9F },
	0xCEDF, { 0xE4, 0xBA, 0xA4 },
	0xCEE0, { 0xE5, 0x83, 0x91 },
	0xCEE1, { 0xE5, 0x92, 0xAC },
	0xCEE2, { 0xE5, 0x96, 0xAC },
	0xCEE3, { 0xE5, 0xAC, 0x8C },
	0xCEE4, { 0xE5, 0xB6, 0xA0 },
	0xCEE5, { 0xE5, 0xB7, 0xA7 },
	0xCEE6, { 0xE6, 0x94, 0xAA },
	0xCEE7, { 0xE6, 0x95, 0x8E },
	0xCEE8, { 0xE6, 0xA0, 0xA1 },
	0xCEE9, { 0xE6, 0xA9, 0x8B },
	0xCEEA, { 0xE7, 0x8B, 0xA1 },
	0xCEEB, { 0xE7, 0x9A, 0x8E },
	0xCEEC, { 0xE7, 0x9F, 0xAF },
	0xCEED, { 0xE7, 0xB5, 0x9E },
	0xCEEE, { 0xE7, 0xBF, 0xB9 },
	0xCEEF, { 0xE8, 0x86, 0xA0 },
	0xCEF0, { 0xE8, 0x95, 0x8E },
	0xCEF1, { 0xE8, 0x9B, 0x9F },
	0xCEF2, { 0xE8, 0xBC, 0x83 },
	0xCEF3, { 0xE8, 0xBD, 0x8E },
	0xCEF4, { 0xE9, 0x83, 0x8A },
	0xCEF5, { 0xE9, 0xA4, 0x83 },
	0xCEF6, { 0xE9, 0xA9, 0x95 },
	0xCEF7, { 0xE9, 0xAE, 0xAB },
	0xCEF8, { 0xE4, 0xB8, 0x98 },
	0xCEF9, { 0xE4, 0xB9, 0x85 },
	0xCEFA, { 0xE4, 0xB9, 0x9D },
	0xCEFB, { 0xE4, 0xBB, 0x87 },
	0xCEFC, { 0xE4, 0xBF, 0xB1 },
	0xCEFD, { 0xE5, 0x85, 0xB7 },
	0xCEFE, { 0xE5, 0x8B, 0xBE },
	0xCFA1, { 0xE5, 0x8D, 0x80 },
	0xCFA2, { 0xE5, 0x8F, 0xA3 },
	0xCFA3, { 0xE5, 0x8F, 0xA5 },
	0xCFA4, { 0xE5, 0x92, 0x8E },
	0xCFA5, { 0xE5, 0x98, 0x94 },
	0xCFA6, { 0xE5, 0x9D, 0xB5 },
	0xCFA7, { 0xE5, 0x9E, 0xA2 },
	0xCFA8, { 0xE5, 0xAF, 0x87 },
	0xCFA9, { 0xE5, 0xB6, 0x87 },
	0xCFAA, { 0xE5, 0xBB, 0x90 },
	0xCFAB, { 0xE6, 0x87, 0xBC },
	0xCFAC, { 0xE6, 0x8B, 0x98 },
	0xCFAD, { 0xE6, 0x95, 0x91 },
	0xCFAE, { 0xE6, 0x9E, 0xB8 },
	0xCFAF, { 0xE6, 0x9F, 0xA9 },
	0xCFB0, { 0xE6, 0xA7, 0x8B },
	0xCFB1, { 0xE6, 0xAD, 0x90 },
	0xCFB2, { 0xE6, 0xAF, 0x86 },
	0xCFB3, { 0xE6, 0xAF, 0xAC },
	0xCFB4, { 0xE6, 0xB1, 0x82 },
	0xCFB5, { 0xE6, 0xBA, 0x9D },
	0xCFB6, { 0xE7, 0x81, 0xB8 },
	0xCFB7, { 0xE7, 0x8B, 0x97 },
	0xCFB8, { 0xE7, 0x8E, 0x96 },
	0xCFB9, { 0xE7, 0x90, 0x83 },
	0xCFBA, { 0xE7, 0x9E, 0xBF },
	0xCFBB, { 0xE7, 0x9F, 0xA9 },
	0xCFBC, { 0xE7, 0xA9, 0xB6 },
	0xCFBD, { 0xE7, 0xB5, 0xBF },
	0xCFBE, { 0xE8, 0x80, 0x89 },
	0xCFBF, { 0xE8, 0x87, 0xBC },
	0xCFC0, { 0xE8, 0x88, 0x85 },
	0xCFC1, { 0xE8, 0x88, 0x8A },
	0xCFC2, { 0xE8, 0x8B, 0x9F },
	0xCFC3, { 0xE8, 0xA1, 0xA2 },
	0xCFC4, { 0xE8, 0xAC, 0xB3 },
	0xCFC5, { 0xE8, 0xB3, 0xBC },
	0xCFC6, { 0xE8, 0xBB, 0x80 },
	0xCFC7, { 0xE9, 0x80, 0x91 },
	0xCFC8, { 0xE9, 0x82, 0xB1 },
	0xCFC9, { 0xE9, 0x89, 0xA4 },
	0xCFCA, { 0xE9, 0x8A, 0xB6 },
	0xCFCB, { 0xE9, 0xA7, 0x92 },
	0xCFCC, { 0xE9, 0xA9, 0x85 },
	0xCFCD, { 0xE9, 0xB3, 0xA9 },
	0xCFCE, { 0xE9, 0xB7, 0x97 },
	0xCFCF, { 0xE9, 0xBE, 0x9C },
	0xCFD0, { 0xE5, 0x9C, 0x8B },
	0xCFD1, { 0xE5, 0xB1, 0x80 },
	0xCFD2, { 0xE8, 0x8F, 0x8A },
	0xCFD3, { 0xE9, 0x9E, 0xA0 },
	0xCFD4, { 0xE9, 0x9E, 0xAB },
	0xCFD5, { 0xE9, 0xBA, 0xB4 },
	0xCFD6, { 0xE5, 0x90, 0x9B },
	0xCFD7, { 0xE7, 0xAA, 0x98 },
	0xCFD8, { 0xE7, 0xBE, 0xA4 },
	0xCFD9, { 0xE8, 0xA3, 0x99 },
	0xCFDA, { 0xE8, 0xBB, 0x8D },
	0xCFDB, { 0xE9, 0x83, 0xA1 },
	0xCFDC, { 0xE5, 0xA0, 0x80 },
	0xCFDD, { 0xE5, 0xB1, 0x88 },
	0xCFDE, { 0xE6, 0x8E, 0x98 },
	0xCFDF, { 0xE7, 0xAA, 0x9F },
	0xCFE0, { 0xE5, 0xAE, 0xAE },
	0xCFE1, { 0xE5, 0xBC, 0x93 },
	0xCFE2, { 0xE7, 0xA9, 0xB9 },
	0xCFE3, { 0xE7, 0xAA, 0xAE },
	0xCFE4, { 0xE8, 0x8A, 0x8E },
	0xCFE5, { 0xE8, 0xBA, 0xAC },
	0xCFE6, { 0xE5, 0x80, 0xA6 },
	0xCFE7, { 0xE5, 0x88, 0xB8 },
	0xCFE8, { 0xE5, 0x8B, 0xB8 },
	0xCFE9, { 0xE5, 0x8D, 0xB7 },
	0xCFEA, { 0xE5, 0x9C, 0x88 },
	0xCFEB, { 0xE6, 0x8B, 0xB3 },
	0xCFEC, { 0xE6, 0x8D, 0xB2 },
	0xCFED, { 0xE6, 0xAC, 0x8A },
	0xCFEE, { 0xE6, 0xB7, 0x83 },
	0xCFEF, { 0xE7, 0x9C, 0xB7 },
	0xCFF0, { 0xE5, 0x8E, 0xA5 },
	0xCFF1, { 0xE7, 0x8D, 0x97 },
	0xCFF2, { 0xE8, 0x95, 0xA8 },
	0xCFF3, { 0xE8, 0xB9, 0xB6 },
	0xCFF4, { 0xE9, 0x97, 0x95 },
	0xCFF5, { 0xE6, 0x9C, 0xBA },
	0xCFF6, { 0xE6, 0xAB, 0x83 },
	0xCFF7, { 0xE6, 0xBD, 0xB0 },
	0xCFF8, { 0xE8, 0xA9, 0xAD },
	0xCFF9, { 0xE8, 0xBB, 0x8C },
	0xCFFA, { 0xE9, 0xA5, 0x8B },
	0xCFFB, { 0xEF, 0xA4, 0x86 },
	0xCFFC, { 0xE6, 0x99, 0xB7 },
	0xCFFD, { 0xE6, 0xAD, 0xB8 },
	0xCFFE, { 0xE8, 0xB2, 0xB4 },
	0xD0A1, { 0xE9, 0xAC, 0xBC },
	0xD0A2, { 0xEF, 0xA4, 0x87 },
	0xD0A3, { 0xE5, 0x8F, 0xAB },
	0xD0A4, { 0xE5, 0x9C, 0xAD },
	0xD0A5, { 0xE5, 0xA5, 0x8E },
	0xD0A6, { 0xE6, 0x8F, 0x86 },
	0xD0A7, { 0xE6, 0xA7, 0xBB },
	0xD0A8, { 0xE7, 0x8F, 0xAA },
	0xD0A9, { 0xE7, 0xA1, 0x85 },
	0xD0AA, { 0xE7, 0xAA, 0xBA },
	0xD0AB, { 0xE7, 0xAB, 0x85 },
	0xD0AC, { 0xE7, 0xB3, 0xBE },
	0xD0AD, { 0xE8, 0x91, 0xB5 },
	0xD0AE, { 0xE8, 0xA6, 0x8F },
	0xD0AF, { 0xE8, 0xB5, 0xB3 },
	0xD0B0, { 0xE9, 0x80, 0xB5 },
	0xD0B1, { 0xE9, 0x96, 0xA8 },
	0xD0B2, { 0xE5, 0x8B, 0xBB },
	0xD0B3, { 0xE5, 0x9D, 0x87 },
	0xD0B4, { 0xE7, 0x95, 0x87 },
	0xD0B5, { 0xE7, 0xAD, 0xA0 },
	0xD0B6, { 0xE8, 0x8F, 0x8C },
	0xD0B7, { 0xE9, 0x88, 0x9E },
	0xD0B8, { 0xEF, 0xA4, 0x88 },
	0xD0B9, { 0xE6, 0xA9, 0x98 },
	0xD0BA, { 0xE5, 0x85, 0x8B },
	0xD0BB, { 0xE5, 0x89, 0x8B },
	0xD0BC, { 0xE5, 0x8A, 0x87 },
	0xD0BD, { 0xE6, 0x88, 0x9F },
	0xD0BE, { 0xE6, 0xA3, 0x98 },
	0xD0BF, { 0xE6, 0xA5, 0xB5 },
	0xD0C0, { 0xE9, 0x9A, 0x99 },
	0xD0C1, { 0xE5, 0x83, 0x85 },
	0xD0C2, { 0xE5, 0x8A, 0xA4 },
	0xD0C3, { 0xE5, 0x8B, 0xA4 },
	0xD0C4, { 0xE6, 0x87, 0x83 },
	0xD0C5, { 0xE6, 0x96, 0xA4 },
	0xD0C6, { 0xE6, 0xA0, 0xB9 },
	0xD0C7, { 0xE6, 0xA7, 0xBF },
	0xD0C8, { 0xE7, 0x91, 0xBE },
	0xD0C9, { 0xE7, 0xAD, 0x8B },
	0xD0CA, { 0xE8, 0x8A, 0xB9 },
	0xD0CB, { 0xE8, 0x8F, 0xAB },
	0xD0CC, { 0xE8, 0xA6, 0xB2 },
	0xD0CD, { 0xE8, 0xAC, 0xB9 },
	0xD0CE, { 0xE8, 0xBF, 0x91 },
	0xD0CF, { 0xE9, 0xA5, 0x89 },
	0xD0D0, { 0xEF, 0xA4, 0x89 },
	0xD0D1, { 0xE4, 0xBB, 0x8A },
	0xD0D2, { 0xE5, 0xA6, 0x97 },
	0xD0D3, { 0xE6, 0x93, 0x92 },
	0xD0D4, { 0xE6, 0x98, 0x91 },
	0xD0D5, { 0xE6, 0xAA, 0x8E },
	0xD0D6, { 0xE7, 0x90, 0xB4 },
	0xD0D7, { 0xE7, 0xA6, 0x81 },
	0xD0D8, { 0xE7, 0xA6, 0xBD },
	0xD0D9, { 0xE8, 0x8A, 0xA9 },
	0xD0DA, { 0xE8, 0xA1, 0xBE },
	0xD0DB, { 0xE8, 0xA1, 0xBF },
	0xD0DC, { 0xE8, 0xA5, 0x9F },
	0xD0DD, { 0xEF, 0xA4, 0x8A },
	0xD0DE, { 0xE9, 0x8C, 0xA6 },
	0xD0DF, { 0xE4, 0xBC, 0x8B },
	0xD0E0, { 0xE5, 0x8F, 0x8A },
	0xD0E1, { 0xE6, 0x80, 0xA5 },
	0xD0E2, { 0xE6, 0x89, 0xB1 },
	0xD0E3, { 0xE6, 0xB1, 0xB2 },
	0xD0E4, { 0xE7, 0xB4, 0x9A },
	0xD0E5, { 0xE7, 0xB5, 0xA6 },
	0xD0E6, { 0xE4, 0xBA, 0x98 },
	0xD0E7, { 0xE5, 0x85, 0xA2 },
	0xD0E8, { 0xE7, 0x9F, 0x9C },
	0xD0E9, { 0xE8, 0x82, 0xAF },
	0xD0EA, { 0xE4, 0xBC, 0x81 },
	0xD0EB, { 0xE4, 0xBC, 0x8E },
	0xD0EC, { 0xE5, 0x85, 0xB6 },
	0xD0ED, { 0xE5, 0x86, 0x80 },
	0xD0EE, { 0xE5, 0x97, 0x9C },
	0xD0EF, { 0xE5, 0x99, 0xA8 },
	0xD0F0, { 0xE5, 0x9C, 0xBB },
	0xD0F1, { 0xE5, 0x9F, 0xBA },
	0xD0F2, { 0xE5, 0x9F, 0xBC },
	0xD0F3, { 0xE5, 0xA4, 0x94 },
	0xD0F4, { 0xE5, 0xA5, 0x87 },
	0xD0F5, { 0xE5, 0xA6, 0x93 },
	0xD0F6, { 0xE5, 0xAF, 0x84 },
	0xD0F7, { 0xE5, 0xB2, 0x90 },
	0xD0F8, { 0xE5, 0xB4, 0x8E },
	0xD0F9, { 0xE5, 0xB7, 0xB1 },
	0xD0FA, { 0xE5, 0xB9, 0xBE },
	0xD0FB, { 0xE5, 0xBF, 0x8C },
	0xD0FC, { 0xE6, 0x8A, 0x80 },
	0xD0FD, { 0xE6, 0x97, 0x97 },
	0xD0FE, { 0xE6, 0x97, 0xA3 },
	0xD1A1, { 0xE6, 0x9C, 0x9E },
	0xD1A2, { 0xE6, 0x9C, 0x9F },
	0xD1A3, { 0xE6, 0x9D, 0x9E },
	0xD1A4, { 0xE6, 0xA3, 0x8B },
	0xD1A5, { 0xE6, 0xA3, 0x84 },
	0xD1A6, { 0xE6, 0xA9, 0x9F },
	0xD1A7, { 0xE6, 0xAC, 0xBA },
	0xD1A8, { 0xE6, 0xB0, 0xA3 },
	0xD1A9, { 0xE6, 0xB1, 0xBD },
	0xD1AA, { 0xE6, 0xB2, 0x82 },
	0xD1AB, { 0xE6, 0xB7, 0x87 },
	0xD1AC, { 0xE7, 0x8E, 0x98 },
	0xD1AD, { 0xE7, 0x90, 0xA6 },
	0xD1AE, { 0xE7, 0x90, 0xAA },
	0xD1AF, { 0xE7, 0x92, 0x82 },
	0xD1B0, { 0xE7, 0x92, 0xA3 },
	0xD1B1, { 0xE7, 0x95, 0xB8 },
	0xD1B2, { 0xE7, 0x95, 0xBF },
	0xD1B3, { 0xE7, 0xA2, 0x81 },
	0xD1B4, { 0xE7, 0xA3, 0xAF },
	0xD1B5, { 0xE7, 0xA5, 0x81 },
	0xD1B6, { 0xE7, 0xA5, 0x87 },
	0xD1B7, { 0xE7, 0xA5, 0x88 },
	0xD1B8, { 0xE7, 0xA5, 0xBA },
	0xD1B9, { 0xE7, 0xAE, 0x95 },
	0xD1BA, { 0xE7, 0xB4, 0x80 },
	0xD1BB, { 0xE7, 0xB6, 0xBA },
	0xD1BC, { 0xE7, 0xBE, 0x88 },
	0xD1BD, { 0xE8, 0x80, 0x86 },
	0xD1BE, { 0xE8, 0x80, 0xAD },
	0xD1BF, { 0xE8, 0x82, 0x8C },
	0xD1C0, { 0xE8, 0xA8, 0x98 },
	0xD1C1, { 0xE8, 0xAD, 0x8F },
	0xD1C2, { 0xE8, 0xB1, 0x88 },
	0xD1C3, { 0xE8, 0xB5, 0xB7 },
	0xD1C4, { 0xE9, 0x8C, 0xA1 },
	0xD1C5, { 0xE9, 0x8C, 0xA4 },
	0xD1C6, { 0xE9, 0xA3, 0xA2 },
	0xD1C7, { 0xE9, 0xA5, 0x91 },
	0xD1C8, { 0xE9, 0xA8, 0x8E },
	0xD1C9, { 0xE9, 0xA8, 0x8F },
	0xD1CA, { 0xE9, 0xA9, 0xA5 },
	0xD1CB, { 0xE9, 0xBA, 0x92 },
	0xD1CC, { 0xE7, 0xB7, 0x8A },
	0xD1CD, { 0xE4, 0xBD, 0xB6 },
	0xD1CE, { 0xE5, 0x90, 0x89 },
	0xD1CF, { 0xE6, 0x8B, 0xAE },
	0xD1D0, { 0xE6, 0xA1, 0x94 },
	0xD1D1, { 0xE9, 0x87, 0x91 },
	0xD1D2, { 0xE5, 0x96, 0xAB },
	0xD1D3, { 0xE5, 0x84, 0xBA },
	0xD1D4, { 0xEF, 0xA4, 0x8B },
	0xD1D5, { 0xEF, 0xA4, 0x8C },
	0xD1D6, { 0xE5, 0xA8, 0x9C },
	0xD1D7, { 0xE6, 0x87, 0xA6 },
	0xD1D8, { 0xEF, 0xA4, 0x8D },
	0xD1D9, { 0xE6, 0x8B, 0x8F },
	0xD1DA, { 0xE6, 0x8B, 0xBF },
	0xD1DB, { 0xEF, 0xA4, 0x8E },
	0xD1DC, { 0xEF, 0xA4, 0x8F },
	0xD1DD, { 0xEF, 0xA4, 0x90 },
	0xD1DE, { 0xEF, 0xA4, 0x91 },
	0xD1DF, { 0xEF, 0xA4, 0x92 },
	0xD1E0, { 0xEF, 0xA4, 0x93 },
	0xD1E1, { 0xE9, 0x82, 0xA3 },
	0xD1E2, { 0xEF, 0xA4, 0x94 },
	0xD1E3, { 0xEF, 0xA4, 0x95 },
	0xD1E4, { 0xEF, 0xA4, 0x96 },
	0xD1E5, { 0xEF, 0xA4, 0x97 },
	0xD1E6, { 0xEF, 0xA4, 0x98 },
	0xD1E7, { 0xE8, 0xAB, 0xBE },
	0xD1E8, { 0xEF, 0xA4, 0x99 },
	0xD1E9, { 0xEF, 0xA4, 0x9A },
	0xD1EA, { 0xEF, 0xA4, 0x9B },
	0xD1EB, { 0xEF, 0xA4, 0x9C },
	0xD1EC, { 0xE6, 0x9A, 0x96 },
	0xD1ED, { 0xEF, 0xA4, 0x9D },
	0xD1EE, { 0xE7, 0x85, 0x96 },
	0xD1EF, { 0xEF, 0xA4, 0x9E },
	0xD1F0, { 0xEF, 0xA4, 0x9F },
	0xD1F1, { 0xE9, 0x9B, 0xA3 },
	0xD1F2, { 0xEF, 0xA4, 0xA0 },
	0xD1F3, { 0xE6, 0x8D, 0x8F },
	0xD1F4, { 0xE6, 0x8D, 0xBA },
	0xD1F5, { 0xE5, 0x8D, 0x97 },
	0xD1F6, { 0xEF, 0xA4, 0xA1 },
	0xD1F7, { 0xE6, 0x9E, 0x8F },
	0xD1F8, { 0xE6, 0xA5, 0xA0 },
	0xD1F9, { 0xE6, 0xB9, 0xB3 },
	0xD1FA, { 0xEF, 0xA4, 0xA2 },
	0xD1FB, { 0xE7, 0x94, 0xB7 },
	0xD1FC, { 0xEF, 0xA4, 0xA3 },
	0xD1FD, { 0xEF, 0xA4, 0xA4 },
	0xD1FE, { 0xEF, 0xA4, 0xA5 },
	0xD2A1, { 0xE7, 0xB4, 0x8D },
	0xD2A2, { 0xEF, 0xA4, 0xA6 },
	0xD2A3, { 0xEF, 0xA4, 0xA7 },
	0xD2A4, { 0xE8, 0xA1, 0xB2 },
	0xD2A5, { 0xE5, 0x9B, 0x8A },
	0xD2A6, { 0xE5, 0xA8, 0x98 },
	0xD2A7, { 0xEF, 0xA4, 0xA8 },
	0xD2A8, { 0xEF, 0xA4, 0xA9 },
	0xD2A9, { 0xEF, 0xA4, 0xAA },
	0xD2AA, { 0xEF, 0xA4, 0xAB },
	0xD2AB, { 0xEF, 0xA4, 0xAC },
	0xD2AC, { 0xE4, 0xB9, 0x83 },
	0xD2AD, { 0xEF, 0xA4, 0xAD },
	0xD2AE, { 0xE5, 0x85, 0xA7 },
	0xD2AF, { 0xE5, 0xA5, 0x88 },
	0xD2B0, { 0xE6, 0x9F, 0xB0 },
	0xD2B1, { 0xE8, 0x80, 0x90 },
	0xD2B2, { 0xEF, 0xA4, 0xAE },
	0xD2B3, { 0xE5, 0xA5, 0xB3 },
	0xD2B4, { 0xE5, 0xB9, 0xB4 },
	0xD2B5, { 0xE6, 0x92, 0x9A },
	0xD2B6, { 0xE7, 0xA7, 0x8A },
	0xD2B7, { 0xE5, 0xBF, 0xB5 },
	0xD2B8, { 0xE6, 0x81, 0xAC },
	0xD2B9, { 0xE6, 0x8B, 0x88 },
	0xD2BA, { 0xE6, 0x8D, 0xBB },
	0xD2BB, { 0xE5, 0xAF, 0xA7 },
	0xD2BC, { 0xE5, 0xAF, 0x97 },
	0xD2BD, { 0xE5, 0x8A, 0xAA },
	0xD2BE, { 0xEF, 0xA4, 0xAF },
	0xD2BF, { 0xE5, 0xA5, 0xB4 },
	0xD2C0, { 0xE5, 0xBC, 0xA9 },
	0xD2C1, { 0xE6, 0x80, 0x92 },
	0xD2C2, { 0xEF, 0xA4, 0xB0 },
	0xD2C3, { 0xEF, 0xA4, 0xB1 },
	0xD2C4, { 0xEF, 0xA4, 0xB2 },
	0xD2C5, { 0xE7, 0x91, 0x99 },
	0xD2C6, { 0xEF, 0xA4, 0xB3 },
	0xD2C7, { 0xEF, 0xA4, 0xB4 },
	0xD2C8, { 0xEF, 0xA4, 0xB5 },
	0xD2C9, { 0xEF, 0xA4, 0xB6 },
	0xD2CA, { 0xEF, 0xA4, 0xB7 },
	0xD2CB, { 0xEF, 0xA4, 0xB8 },
	0xD2CC, { 0xE9, 0xA7, 0x91 },
	0xD2CD, { 0xEF, 0xA4, 0xB9 },
	0xD2CE, { 0xEF, 0xA4, 0xBA },
	0xD2CF, { 0xEF, 0xA4, 0xBB },
	0xD2D0, { 0xEF, 0xA4, 0xBC },
	0xD2D1, { 0xEF, 0xA4, 0xBD },
	0xD2D2, { 0xEF, 0xA4, 0xBE },
	0xD2D3, { 0xEF, 0xA4, 0xBF },
	0xD2D4, { 0xEF, 0xA5, 0x80 },
	0xD2D5, { 0xEF, 0xA5, 0x81 },
	0xD2D6, { 0xEF, 0xA5, 0x82 },
	0xD2D7, { 0xEF, 0xA5, 0x83 },
	0xD2D8, { 0xE6, 0xBF, 0x83 },
	0xD2D9, { 0xEF, 0xA5, 0x84 },
	0xD2DA, { 0xEF, 0xA5, 0x85 },
	0xD2DB, { 0xE8, 0x86, 0xBF },
	0xD2DC, { 0xE8, 0xBE, 0xB2 },
	0xD2DD, { 0xE6, 0x83, 0xB1 },
	0xD2DE, { 0xEF, 0xA5, 0x86 },
	0xD2DF, { 0xEF, 0xA5, 0x87 },
	0xD2E0, { 0xE8, 0x85, 0xA6 },
	0xD2E1, { 0xEF, 0xA5, 0x88 },
	0xD2E2, { 0xEF, 0xA5, 0x89 },
	0xD2E3, { 0xE5, 0xB0, 0xBF },
	0xD2E4, { 0xEF, 0xA5, 0x8A },
	0xD2E5, { 0xEF, 0xA5, 0x8B },
	0xD2E6, { 0xEF, 0xA5, 0x8C },
	0xD2E7, { 0xEF, 0xA5, 0x8D },
	0xD2E8, { 0xEF, 0xA5, 0x8E },
	0xD2E9, { 0xEF, 0xA5, 0x8F },
	0xD2EA, { 0xEF, 0xA5, 0x90 },
	0xD2EB, { 0xEF, 0xA5, 0x91 },
	0xD2EC, { 0xE5, 0xAB, 0xA9 },
	0xD2ED, { 0xE8, 0xA8, 0xA5 },
	0xD2EE, { 0xE6, 0x9D, 0xBB },
	0xD2EF, { 0xE7, 0xB4, 0x90 },
	0xD2F0, { 0xEF, 0xA5, 0x92 },
	0xD2F1, { 0xEF, 0xA5, 0x93 },
	0xD2F2, { 0xEF, 0xA5, 0x94 },
	0xD2F3, { 0xEF, 0xA5, 0x95 },
	0xD2F4, { 0xEF, 0xA5, 0x96 },
	0xD2F5, { 0xEF, 0xA5, 0x97 },
	0xD2F6, { 0xE8, 0x83, 0xBD },
	0xD2F7, { 0xEF, 0xA5, 0x98 },
	0xD2F8, { 0xEF, 0xA5, 0x99 },
	0xD2F9, { 0xE5, 0xB0, 0xBC },
	0xD2FA, { 0xE6, 0xB3, 0xA5 },
	0xD2FB, { 0xE5, 0x8C, 0xBF },
	0xD2FC, { 0xE6, 0xBA, 0xBA },
	0xD2FD, { 0xE5, 0xA4, 0x9A },
	0xD2FE, { 0xE8, 0x8C, 0xB6 },
	0xD3A1, { 0xE4, 0xB8, 0xB9 },
	0xD3A2, { 0xE4, 0xBA, 0xB6 },
	0xD3A3, { 0xE4, 0xBD, 0x86 },
	0xD3A4, { 0xE5, 0x96, 0xAE },
	0xD3A5, { 0xE5, 0x9C, 0x98 },
	0xD3A6, { 0xE5, 0xA3, 0x87 },
	0xD3A7, { 0xE5, 0xBD, 0x96 },
	0xD3A8, { 0xE6, 0x96, 0xB7 },
	0xD3A9, { 0xE6, 0x97, 0xA6 },
	0xD3AA, { 0xE6, 0xAA, 0x80 },
	0xD3AB, { 0xE6, 0xAE, 0xB5 },
	0xD3AC, { 0xE6, 0xB9, 0x8D },
	0xD3AD, { 0xE7, 0x9F, 0xAD },
	0xD3AE, { 0xE7, 0xAB, 0xAF },
	0xD3AF, { 0xE7, 0xB0, 0x9E },
	0xD3B0, { 0xE7, 0xB7, 0x9E },
	0xD3B1, { 0xE8, 0x9B, 0x8B },
	0xD3B2, { 0xE8, 0xA2, 0x92 },
	0xD3B3, { 0xE9, 0x84, 0xB2 },
	0xD3B4, { 0xE9, 0x8D, 0x9B },
	0xD3B5, { 0xE6, 0x92, 0xBB },
	0xD3B6, { 0xE6, 0xBE, 0xBE },
	0xD3B7, { 0xE7, 0x8D, 0xBA },
	0xD3B8, { 0xE7, 0x96, 0xB8 },
	0xD3B9, { 0xE9, 0x81, 0x94 },
	0xD3BA, { 0xE5, 0x95, 0x96 },
	0xD3BB, { 0xE5, 0x9D, 0x8D },
	0xD3BC, { 0xE6, 0x86, 0xBA },
	0xD3BD, { 0xE6, 0x93, 0x94 },
	0xD3BE, { 0xE6, 0x9B, 0x87 },
	0xD3BF, { 0xE6, 0xB7, 0xA1 },
	0xD3C0, { 0xE6, 0xB9, 0x9B },
	0xD3C1, { 0xE6, 0xBD, 0xAD },
	0xD3C2, { 0xE6, 0xBE, 0xB9 },
	0xD3C3, { 0xE7, 0x97, 0xB0 },
	0xD3C4, { 0xE8, 0x81, 0x83 },
	0xD3C5, { 0xE8, 0x86, 0xBD },
	0xD3C6, { 0xE8, 0x95, 0x81 },
	0xD3C7, { 0xE8, 0xA6, 0x83 },
	0xD3C8, { 0xE8, 0xAB, 0x87 },
	0xD3C9, { 0xE8, 0xAD, 0x9A },
	0xD3CA, { 0xE9, 0x8C, 0x9F },
	0xD3CB, { 0xE6, 0xB2, 0x93 },
	0xD3CC, { 0xE7, 0x95, 0x93 },
	0xD3CD, { 0xE7, 0xAD, 0x94 },
	0xD3CE, { 0xE8, 0xB8, 0x8F },
	0xD3CF, { 0xE9, 0x81, 0x9D },
	0xD3D0, { 0xE5, 0x94, 0x90 },
	0xD3D1, { 0xE5, 0xA0, 0x82 },
	0xD3D2, { 0xE5, 0xA1, 0x98 },
	0xD3D3, { 0xE5, 0xB9, 0xA2 },
	0xD3D4, { 0xE6, 0x88, 0x87 },
	0xD3D5, { 0xE6, 0x92, 0x9E },
	0xD3D6, { 0xE6, 0xA3, 0xA0 },
	0xD3D7, { 0xE7, 0x95, 0xB6 },
	0xD3D8, { 0xE7, 0xB3, 0x96 },
	0xD3D9, { 0xE8, 0x9E, 0xB3 },
	0xD3DA, { 0xE9, 0xBB, 0xA8 },
	0xD3DB, { 0xE4, 0xBB, 0xA3 },
	0xD3DC, { 0xE5, 0x9E, 0x88 },
	0xD3DD, { 0xE5, 0x9D, 0xAE },
	0xD3DE, { 0xE5, 0xA4, 0xA7 },
	0xD3DF, { 0xE5, 0xB0, 0x8D },
	0xD3E0, { 0xE5, 0xB2, 0xB1 },
	0xD3E1, { 0xE5, 0xB8, 0xB6 },
	0xD3E2, { 0xE5, 0xBE, 0x85 },
	0xD3E3, { 0xE6, 0x88, 0xB4 },
	0xD3E4, { 0xE6, 0x93, 0xA1 },
	0xD3E5, { 0xE7, 0x8E, 0xB3 },
	0xD3E6, { 0xE8, 0x87, 0xBA },
	0xD3E7, { 0xE8, 0xA2, 0x8B },
	0xD3E8, { 0xE8, 0xB2, 0xB8 },
	0xD3E9, { 0xE9, 0x9A, 0x8A },
	0xD3EA, { 0xE9, 0xBB, 0x9B },
	0xD3EB, { 0xE5, 0xAE, 0x85 },
	0xD3EC, { 0xE5, 0xBE, 0xB7 },
	0xD3ED, { 0xE6, 0x82, 0xB3 },
	0xD3EE, { 0xE5, 0x80, 0x92 },
	0xD3EF, { 0xE5, 0x88, 0x80 },
	0xD3F0, { 0xE5, 0x88, 0xB0 },
	0xD3F1, { 0xE5, 0x9C, 0x96 },
	0xD3F2, { 0xE5, 0xA0, 0xB5 },
	0xD3F3, { 0xE5, 0xA1, 0x97 },
	0xD3F4, { 0xE5, 0xB0, 0x8E },
	0xD3F5, { 0xE5, 0xB1, 0xA0 },
	0xD3F6, { 0xE5, 0xB3, 0xB6 },
	0xD3F7, { 0xE5, 0xB6, 0x8B },
	0xD3F8, { 0xE5, 0xBA, 0xA6 },
	0xD3F9, { 0xE5, 0xBE, 0x92 },
	0xD3FA, { 0xE6, 0x82, 0xBC },
	0xD3FB, { 0xE6, 0x8C, 0x91 },
	0xD3FC, { 0xE6, 0x8E, 0x89 },
	0xD3FD, { 0xE6, 0x90, 0x97 },
	0xD3FE, { 0xE6, 0xA1, 0x83 },
	0xD4A1, { 0xE6, 0xA3, 0xB9 },
	0xD4A2, { 0xE6, 0xAB, 0x82 },
	0xD4A3, { 0xE6, 0xB7, 0x98 },
	0xD4A4, { 0xE6, 0xB8, 0xA1 },
	0xD4A5, { 0xE6, 0xBB, 0x94 },
	0xD4A6, { 0xE6, 0xBF, 0xA4 },
	0xD4A7, { 0xE7, 0x87, 0xBE },
	0xD4A8, { 0xE7, 0x9B, 0x9C },
	0xD4A9, { 0xE7, 0x9D, 0xB9 },
	0xD4AA, { 0xE7, 0xA6, 0xB1 },
	0xD4AB, { 0xE7, 0xA8, 0xBB },
	0xD4AC, { 0xE8, 0x90, 0x84 },
	0xD4AD, { 0xE8, 0xA6, 0xA9 },
	0xD4AE, { 0xE8, 0xB3, 0xAD },
	0xD4AF, { 0xE8, 0xB7, 0xB3 },
	0xD4B0, { 0xE8, 0xB9, 0x88 },
	0xD4B1, { 0xE9, 0x80, 0x83 },
	0xD4B2, { 0xE9, 0x80, 0x94 },
	0xD4B3, { 0xE9, 0x81, 0x93 },
	0xD4B4, { 0xE9, 0x83, 0xBD },
	0xD4B5, { 0xE9, 0x8D, 0x8D },
	0xD4B6, { 0xE9, 0x99, 0xB6 },
	0xD4B7, { 0xE9, 0x9F, 0x9C },
	0xD4B8, { 0xE6, 0xAF, 0x92 },
	0xD4B9, { 0xE7, 0x80, 0x86 },
	0xD4BA, { 0xE7, 0x89, 0x98 },
	0xD4BB, { 0xE7, 0x8A, 0xA2 },
	0xD4BC, { 0xE7, 0x8D, 0xA8 },
	0xD4BD, { 0xE7, 0x9D, 0xA3 },
	0xD4BE, { 0xE7, 0xA6, 0xBF },
	0xD4BF, { 0xE7, 0xAF, 0xA4 },
	0xD4C0, { 0xE7, 0xBA, 0x9B },
	0xD4C1, { 0xE8, 0xAE, 0x80 },
	0xD4C2, { 0xE5, 0xA2, 0xA9 },
	0xD4C3, { 0xE6, 0x83, 0x87 },
	0xD4C4, { 0xE6, 0x95, 0xA6 },
	0xD4C5, { 0xE6, 0x97, 0xBD },
	0xD4C6, { 0xE6, 0x9A, 0xBE },
	0xD4C7, { 0xE6, 0xB2, 0x8C },
	0xD4C8, { 0xE7, 0x84, 0x9E },
	0xD4C9, { 0xE7, 0x87, 0x89 },
	0xD4CA, { 0xE8, 0xB1, 0x9A },
	0xD4CB, { 0xE9, 0xA0, 0x93 },
	0xD4CC, { 0xE4, 0xB9, 0xAD },
	0xD4CD, { 0xE7, 0xAA, 0x81 },
	0xD4CE, { 0xE4, 0xBB, 0x9D },
	0xD4CF, { 0xE5, 0x86, 0xAC },
	0xD4D0, { 0xE5, 0x87, 0x8D },
	0xD4D1, { 0xE5, 0x8B, 0x95 },
	0xD4D2, { 0xE5, 0x90, 0x8C },
	0xD4D3, { 0xE6, 0x86, 0xA7 },
	0xD4D4, { 0xE6, 0x9D, 0xB1 },
	0xD4D5, { 0xE6, 0xA1, 0x90 },
	0xD4D6, { 0xE6, 0xA3, 0x9F },
	0xD4D7, { 0xE6, 0xB4, 0x9E },
	0xD4D8, { 0xE6, 0xBD, 0xBC },
	0xD4D9, { 0xE7, 0x96, 0xBC },
	0xD4DA, { 0xE7, 0x9E, 0xB3 },
	0xD4DB, { 0xE7, 0xAB, 0xA5 },
	0xD4DC, { 0xE8, 0x83, 0xB4 },
	0xD4DD, { 0xE8, 0x91, 0xA3 },
	0xD4DE, { 0xE9, 0x8A, 0x85 },
	0xD4DF, { 0xE5, 0x85, 0x9C },
	0xD4E0, { 0xE6, 0x96, 0x97 },
	0xD4E1, { 0xE6, 0x9D, 0x9C },
	0xD4E2, { 0xE6, 0x9E, 0x93 },
	0xD4E3, { 0xE7, 0x97, 0x98 },
	0xD4E4, { 0xE7, 0xAB, 0x87 },
	0xD4E5, { 0xE8, 0x8D, 0xB3 },
	0xD4E6, { 0xEF, 0xA5, 0x9A },
	0xD4E7, { 0xE8, 0xB1, 0x86 },
	0xD4E8, { 0xE9, 0x80, 0x97 },
	0xD4E9, { 0xE9, 0xA0, 0xAD },
	0xD4EA, { 0xE5, 0xB1, 0xAF },
	0xD4EB, { 0xE8, 0x87, 0x80 },
	0xD4EC, { 0xE8, 0x8A, 0x9A },
	0xD4ED, { 0xE9, 0x81, 0x81 },
	0xD4EE, { 0xE9, 0x81, 0xAF },
	0xD4EF, { 0xE9, 0x88, 0x8D },
	0xD4F0, { 0xE5, 0xBE, 0x97 },
	0xD4F1, { 0xE5, 0xB6, 0x9D },
	0xD4F2, { 0xE6, 0xA9, 0x99 },
	0xD4F3, { 0xE7, 0x87, 0x88 },
	0xD4F4, { 0xE7, 0x99, 0xBB },
	0xD4F5, { 0xE7, 0xAD, 0x89 },
	0xD4F6, { 0xE8, 0x97, 0xA4 },
	0xD4F7, { 0xE8, 0xAC, 0x84 },
	0xD4F8, { 0xE9, 0x84, 0xA7 },
	0xD4F9, { 0xE9, 0xA8, 0xB0 },
	0xD4FA, { 0xE5, 0x96, 0x87 },
	0xD4FB, { 0xE6, 0x87, 0xB6 },
	0xD4FC, { 0xEF, 0xA5, 0x9B },
	0xD4FD, { 0xE7, 0x99, 0xA9 },
	0xD4FE, { 0xE7, 0xBE, 0x85 },
	0xD5A1, { 0xE8, 0x98, 0xBF },
	0xD5A2, { 0xE8, 0x9E, 0xBA },
	0xD5A3, { 0xE8, 0xA3, 0xB8 },
	0xD5A4, { 0xE9, 0x82, 0x8F },
	0xD5A5, { 0xEF, 0xA5, 0x9C },
	0xD5A6, { 0xE6, 0xB4, 0x9B },
	0xD5A7, { 0xE7, 0x83, 0x99 },
	0xD5A8, { 0xE7, 0x8F, 0x9E },
	0xD5A9, { 0xE7, 0xB5, 0xA1 },
	0xD5AA, { 0xE8, 0x90, 0xBD },
	0xD5AB, { 0xEF, 0xA5, 0x9D },
	0xD5AC, { 0xE9, 0x85, 0xAA },
	0xD5AD, { 0xE9, 0xA7, 0xB1 },
	0xD5AE, { 0xEF, 0xA5, 0x9E },
	0xD5AF, { 0xE4, 0xBA, 0x82 },
	0xD5B0, { 0xE5, 0x8D, 0xB5 },
	0xD5B1, { 0xE6, 0xAC, 0x84 },
	0xD5B2, { 0xE6, 0xAC, 0x92 },
	0xD5B3, { 0xE7, 0x80, 0xBE },
	0xD5B4, { 0xE7, 0x88, 0x9B },
	0xD5B5, { 0xE8, 0x98, 0xAD },
	0xD5B6, { 0xE9, 0xB8, 0x9E },
	0xD5B7, { 0xE5, 0x89, 0x8C },
	0xD5B8, { 0xE8, 0xBE, 0xA3 },
	0xD5B9, { 0xE5, 0xB5, 0x90 },
	0xD5BA, { 0xE6, 0x93, 0xA5 },
	0xD5BB, { 0xE6, 0x94, 0xAC },
	0xD5BC, { 0xE6, 0xAC, 0x96 },
	0xD5BD, { 0xE6, 0xBF, 0xAB },
	0xD5BE, { 0xE7, 0xB1, 0x83 },
	0xD5BF, { 0xE7, 0xBA, 0x9C },
	0xD5C0, { 0xE8, 0x97, 0x8D },
	0xD5C1, { 0xE8, 0xA5, 0xA4 },
	0xD5C2, { 0xE8, 0xA6, 0xBD },
	0xD5C3, { 0xE6, 0x8B, 0x89 },
	0xD5C4, { 0xE8, 0x87, 0x98 },
	0xD5C5, { 0xE8, 0xA0, 0x9F },
	0xD5C6, { 0xE5, 0xBB, 0x8A },
	0xD5C7, { 0xE6, 0x9C, 0x97 },
	0xD5C8, { 0xE6, 0xB5, 0xAA },
	0xD5C9, { 0xE7, 0x8B, 0xBC },
	0xD5CA, { 0xE7, 0x90, 0x85 },
	0xD5CB, { 0xE7, 0x91, 0xAF },
	0xD5CC, { 0xE8, 0x9E, 0x82 },
	0xD5CD, { 0xE9, 0x83, 0x9E },
	0xD5CE, { 0xE4, 0xBE, 0x86 },
	0xD5CF, { 0xE5, 0xB4, 0x8D },
	0xD5D0, { 0xE5, 0xBE, 0xA0 },
	0xD5D1, { 0xE8, 0x90, 0x8A },
	0xD5D2, { 0xE5, 0x86, 0xB7 },
	0xD5D3, { 0xE6, 0x8E, 0xA0 },
	0xD5D4, { 0xE7, 0x95, 0xA5 },
	0xD5D5, { 0xE4, 0xBA, 0xAE },
	0xD5D6, { 0xE5, 0x80, 0x86 },
	0xD5D7, { 0xE5, 0x85, 0xA9 },
	0xD5D8, { 0xE5, 0x87, 0x89 },
	0xD5D9, { 0xE6, 0xA2, 0x81 },
	0xD5DA, { 0xE6, 0xA8, 0x91 },
	0xD5DB, { 0xE7, 0xB2, 0xAE },
	0xD5DC, { 0xE7, 0xB2, 0xB1 },
	0xD5DD, { 0xE7, 0xB3, 0xA7 },
	0xD5DE, { 0xE8, 0x89, 0xAF },
	0xD5DF, { 0xE8, 0xAB, 0x92 },
	0xD5E0, { 0xE8, 0xBC, 0x9B },
	0xD5E1, { 0xE9, 0x87, 0x8F },
	0xD5E2, { 0xE4, 0xBE, 0xB6 },
	0xD5E3, { 0xE5, 0x84, 0xB7 },
	0xD5E4, { 0xE5, 0x8B, 0xB5 },
	0xD5E5, { 0xE5, 0x91, 0x82 },
	0xD5E6, { 0xE5, 0xBB, 0xAC },
	0xD5E7, { 0xE6, 0x85, 0xAE },
	0xD5E8, { 0xE6, 0x88, 0xBE },
	0xD5E9, { 0xE6, 0x97, 0x85 },
	0xD5EA, { 0xE6, 0xAB, 0x9A },
	0xD5EB, { 0xE6, 0xBF, 0xBE },
	0xD5EC, { 0xE7, 0xA4, 0xAA },
	0xD5ED, { 0xE8, 0x97, 0x9C },
	0xD5EE, { 0xE8, 0xA0, 0xA3 },
	0xD5EF, { 0xE9, 0x96, 0xAD },
	0xD5F0, { 0xE9, 0xA9, 0xA2 },
	0xD5F1, { 0xE9, 0xA9, 0xAA },
	0xD5F2, { 0xE9, 0xBA, 0x97 },
	0xD5F3, { 0xE9, 0xBB, 0x8E },
	0xD5F4, { 0xE5, 0x8A, 0x9B },
	0xD5F5, { 0xE6, 0x9B, 0x86 },
	0xD5F6, { 0xE6, 0xAD, 0xB7 },
	0xD5F7, { 0xE7, 0x80, 0x9D },
	0xD5F8, { 0xE7, 0xA4, 0xAB },
	0xD5F9, { 0xE8, 0xBD, 0xA2 },
	0xD5FA, { 0xE9, 0x9D, 0x82 },
	0xD5FB, { 0xE6, 0x86, 0x90 },
	0xD5FC, { 0xE6, 0x88, 0x80 },
	0xD5FD, { 0xE6, 0x94, 0xA3 },
	0xD5FE, { 0xE6, 0xBC, 0xA3 },
	0xD6A1, { 0xE7, 0x85, 0x89 },
	0xD6A2, { 0xE7, 0x92, 0x89 },
	0xD6A3, { 0xE7, 0xB7, 0xB4 },
	0xD6A4, { 0xE8, 0x81, 0xAF },
	0xD6A5, { 0xE8, 0x93, 0xAE },
	0xD6A6, { 0xE8, 0xBC, 0xA6 },
	0xD6A7, { 0xE9, 0x80, 0xA3 },
	0xD6A8, { 0xE9, 0x8D, 0x8A },
	0xD6A9, { 0xE5, 0x86, 0xBD },
	0xD6AA, { 0xE5, 0x88, 0x97 },
	0xD6AB, { 0xE5, 0x8A, 0xA3 },
	0xD6AC, { 0xE6, 0xB4, 0x8C },
	0xD6AD, { 0xE7, 0x83, 0x88 },
	0xD6AE, { 0xE8, 0xA3, 0x82 },
	0xD6AF, { 0xE5, 0xBB, 0x89 },
	0xD6B0, { 0xE6, 0x96, 0x82 },
	0xD6B1, { 0xE6, 0xAE, 0xAE },
	0xD6B2, { 0xE6, 0xBF, 0x82 },
	0xD6B3, { 0xE7, 0xB0, 0xBE },
	0xD6B4, { 0xE7, 0x8D, 0xB5 },
	0xD6B5, { 0xE4, 0xBB, 0xA4 },
	0xD6B6, { 0xE4, 0xBC, 0xB6 },
	0xD6B7, { 0xE5, 0x9B, 0xB9 },
	0xD6B8, { 0xEF, 0xA5, 0x9F },
	0xD6B9, { 0xE5, 0xB2, 0xBA },
	0xD6BA, { 0xE5, 0xB6, 0xBA },
	0xD6BB, { 0xE6, 0x80, 0x9C },
	0xD6BC, { 0xE7, 0x8E, 0xB2 },
	0xD6BD, { 0xE7, 0xAC, 0xAD },
	0xD6BE, { 0xE7, 0xBE, 0x9A },
	0xD6BF, { 0xE7, 0xBF, 0x8E },
	0xD6C0, { 0xE8, 0x81, 0x86 },
	0xD6C1, { 0xE9, 0x80, 0x9E },
	0xD6C2, { 0xE9, 0x88, 0xB4 },
	0xD6C3, { 0xE9, 0x9B, 0xB6 },
	0xD6C4, { 0xE9, 0x9D, 0x88 },
	0xD6C5, { 0xE9, 0xA0, 0x98 },
	0xD6C6, { 0xE9, 0xBD, 0xA1 },
	0xD6C7, { 0xE4, 0xBE, 0x8B },
	0xD6C8, { 0xE6, 0xBE, 0xA7 },
	0xD6C9, { 0xE7, 0xA6, 0xAE },
	0xD6CA, { 0xE9, 0x86, 0xB4 },
	0xD6CB, { 0xE9, 0x9A, 0xB7 },
	0xD6CC, { 0xE5, 0x8B, 0x9E },
	0xD6CD, { 0xEF, 0xA5, 0xA0 },
	0xD6CE, { 0xE6, 0x92, 0x88 },
	0xD6CF, { 0xE6, 0x93, 0x84 },
	0xD6D0, { 0xE6, 0xAB, 0x93 },
	0xD6D1, { 0xE6, 0xBD, 0x9E },
	0xD6D2, { 0xE7, 0x80, 0x98 },
	0xD6D3, { 0xE7, 0x88, 0x90 },
	0xD6D4, { 0xE7, 0x9B, 0xA7 },
	0xD6D5, { 0xE8, 0x80, 0x81 },
	0xD6D6, { 0xE8, 0x98, 0x86 },
	0xD6D7, { 0xE8, 0x99, 0x9C },
	0xD6D8, { 0xE8, 0xB7, 0xAF },
	0xD6D9, { 0xE8, 0xBC, 0x85 },
	0xD6DA, { 0xE9, 0x9C, 0xB2 },
	0xD6DB, { 0xE9, 0xAD, 0xAF },
	0xD6DC, { 0xE9, 0xB7, 0xBA },
	0xD6DD, { 0xE9, 0xB9, 0xB5 },
	0xD6DE, { 0xE7, 0xA2, 0x8C },
	0xD6DF, { 0xE7, 0xA5, 0xBF },
	0xD6E0, { 0xE7, 0xB6, 0xA0 },
	0xD6E1, { 0xE8, 0x8F, 0x89 },
	0xD6E2, { 0xE9, 0x8C, 0x84 },
	0xD6E3, { 0xE9, 0xB9, 0xBF },
	0xD6E4, { 0xE9, 0xBA, 0x93 },
	0xD6E5, { 0xE8, 0xAB, 0x96 },
	0xD6E6, { 0xE5, 0xA3, 0x9F },
	0xD6E7, { 0xE5, 0xBC, 0x84 },
	0xD6E8, { 0xE6, 0x9C, 0xA7 },
	0xD6E9, { 0xE7, 0x80, 0xA7 },
	0xD6EA, { 0xE7, 0x93, 0x8F },
	0xD6EB, { 0xE7, 0xB1, 0xA0 },
	0xD6EC, { 0xE8, 0x81, 0xBE },
	0xD6ED, { 0xE5, 0x84, 0xA1 },
	0xD6EE, { 0xE7, 0x80, 0xA8 },
	0xD6EF, { 0xE7, 0x89, 0xA2 },
	0xD6F0, { 0xE7, 0xA3, 0x8A },
	0xD6F1, { 0xE8, 0xB3, 0x82 },
	0xD6F2, { 0xE8, 0xB3, 0x9A },
	0xD6F3, { 0xE8, 0xB3, 0xB4 },
	0xD6F4, { 0xE9, 0x9B, 0xB7 },
	0xD6F5, { 0xE4, 0xBA, 0x86 },
	0xD6F6, { 0xE5, 0x83, 0x9A },
	0xD6F7, { 0xE5, 0xAF, 0xAE },
	0xD6F8, { 0xE5, 0xBB, 0x96 },
	0xD6F9, { 0xE6, 0x96, 0x99 },
	0xD6FA, { 0xE7, 0x87, 0x8E },
	0xD6FB, { 0xE7, 0x99, 0x82 },
	0xD6FC, { 0xE7, 0x9E, 0xAD },
	0xD6FD, { 0xE8, 0x81, 0x8A },
	0xD6FE, { 0xE8, 0x93, 0xBC },
	0xD7A1, { 0xE9, 0x81, 0xBC },
	0xD7A2, { 0xE9, 0xAC, 0xA7 },
	0xD7A3, { 0xE9, 0xBE, 0x8D },
	0xD7A4, { 0xE5, 0xA3, 0x98 },
	0xD7A5, { 0xE5, 0xA9, 0x81 },
	0xD7A6, { 0xE5, 0xB1, 0xA2 },
	0xD7A7, { 0xE6, 0xA8, 0x93 },
	0xD7A8, { 0xE6, 0xB7, 0x9A },
	0xD7A9, { 0xE6, 0xBC, 0x8F },
	0xD7AA, { 0xE7, 0x98, 0xBB },
	0xD7AB, { 0xE7, 0xB4, 0xAF },
	0xD7AC, { 0xE7, 0xB8, 0xB7 },
	0xD7AD, { 0xE8, 0x94, 0x9E },
	0xD7AE, { 0xE8, 0xA4, 0xB8 },
	0xD7AF, { 0xE9, 0x8F, 0xA4 },
	0xD7B0, { 0xE9, 0x99, 0x8B },
	0xD7B1, { 0xE5, 0x8A, 0x89 },
	0xD7B2, { 0xE6, 0x97, 0x92 },
	0xD7B3, { 0xE6, 0x9F, 0xB3 },
	0xD7B4, { 0xE6, 0xA6, 0xB4 },
	0xD7B5, { 0xE6, 0xB5, 0x81 },
	0xD7B6, { 0xE6, 0xBA, 0x9C },
	0xD7B7, { 0xE7, 0x80, 0x8F },
	0xD7B8, { 0xE7, 0x90, 0x89 },
	0xD7B9, { 0xE7, 0x91, 0xA0 },
	0xD7BA, { 0xE7, 0x95, 0x99 },
	0xD7BB, { 0xE7, 0x98, 0xA4 },
	0xD7BC, { 0xE7, 0xA1, 0xAB },
	0xD7BD, { 0xE8, 0xAC, 0xAC },
	0xD7BE, { 0xE9, 0xA1, 0x9E },
	0xD7BF, { 0xE5, 0x85, 0xAD },
	0xD7C0, { 0xE6, 0x88, 0xAE },
	0xD7C1, { 0xE9, 0x99, 0xB8 },
	0xD7C2, { 0xE4, 0xBE, 0x96 },
	0xD7C3, { 0xE5, 0x80, 0xAB },
	0xD7C4, { 0xE5, 0xB4, 0x99 },
	0xD7C5, { 0xE6, 0xB7, 0xAA },
	0xD7C6, { 0xE7, 0xB6, 0xB8 },
	0xD7C7, { 0xE8, 0xBC, 0xAA },
	0xD7C8, { 0xE5, 0xBE, 0x8B },
	0xD7C9, { 0xE6, 0x85, 0x84 },
	0xD7CA, { 0xE6, 0xA0, 0x97 },
	0xD7CB, { 0xEF, 0xA5, 0xA1 },
	0xD7CC, { 0xE9, 0x9A, 0x86 },
	0xD7CD, { 0xE5, 0x8B, 0x92 },
	0xD7CE, { 0xE8, 0x82, 0x8B },
	0xD7CF, { 0xE5, 0x87, 0x9C },
	0xD7D0, { 0xE5, 0x87, 0x8C },
	0xD7D1, { 0xE6, 0xA5, 0x9E },
	0xD7D2, { 0xE7, 0xA8, 0x9C },
	0xD7D3, { 0xE7, 0xB6, 0xBE },
	0xD7D4, { 0xE8, 0x8F, 0xB1 },
	0xD7D5, { 0xE9, 0x99, 0xB5 },
	0xD7D6, { 0xE4, 0xBF, 0x9A },
	0xD7D7, { 0xE5, 0x88, 0xA9 },
	0xD7D8, { 0xE5, 0x8E, 0x98 },
	0xD7D9, { 0xE5, 0x90, 0x8F },
	0xD7DA, { 0xE5, 0x94, 0x8E },
	0xD7DB, { 0xE5, 0xB1, 0xA5 },
	0xD7DC, { 0xE6, 0x82, 0xA7 },
	0xD7DD, { 0xE6, 0x9D, 0x8E },
	0xD7DE, { 0xE6, 0xA2, 0xA8 },
	0xD7DF, { 0xE6, 0xB5, 0xAC },
	0xD7E0, { 0xE7, 0x8A, 0x81 },
	0xD7E1, { 0xE7, 0x8B, 0xB8 },
	0xD7E2, { 0xE7, 0x90, 0x86 },
	0xD7E3, { 0xE7, 0x92, 0x83 },
	0xD7E4, { 0xEF, 0xA5, 0xA2 },
	0xD7E5, { 0xE7, 0x97, 0xA2 },
	0xD7E6, { 0xE7, 0xB1, 0xAC },
	0xD7E7, { 0xE7, 0xBD, 0xB9 },
	0xD7E8, { 0xE7, 0xBE, 0xB8 },
	0xD7E9, { 0xE8, 0x8E, 0x89 },
	0xD7EA, { 0xE8, 0xA3, 0x8F },
	0xD7EB, { 0xE8, 0xA3, 0xA1 },
	0xD7EC, { 0xE9, 0x87, 0x8C },
	0xD7ED, { 0xE9, 0x87, 0x90 },
	0xD7EE, { 0xE9, 0x9B, 0xA2 },
	0xD7EF, { 0xE9, 0xAF, 0x89 },
	0xD7F0, { 0xE5, 0x90, 0x9D },
	0xD7F1, { 0xE6, 0xBD, 0xBE },
	0xD7F2, { 0xE7, 0x87, 0x90 },
	0xD7F3, { 0xE7, 0x92, 0x98 },
	0xD7F4, { 0xE8, 0x97, 0xBA },
	0xD7F5, { 0xE8, 0xBA, 0xAA },
	0xD7F6, { 0xE9, 0x9A, 0xA3 },
	0xD7F7, { 0xE9, 0xB1, 0x97 },
	0xD7F8, { 0xE9, 0xBA, 0x9F },
	0xD7F9, { 0xE6, 0x9E, 0x97 },
	0xD7FA, { 0xE6, 0xB7, 0x8B },
	0xD7FB, { 0xE7, 0x90, 0xB3 },
	0xD7FC, { 0xE8, 0x87, 0xA8 },
	0xD7FD, { 0xE9, 0x9C, 0x96 },
	0xD7FE, { 0xE7, 0xA0, 0xAC },
	0xD8A1, { 0xE7, 0xAB, 0x8B },
	0xD8A2, { 0xE7, 0xAC, 0xA0 },
	0xD8A3, { 0xE7, 0xB2, 0x92 },
	0xD8A4, { 0xE6, 0x91, 0xA9 },
	0xD8A5, { 0xE7, 0x91, 0xAA },
	0xD8A6, { 0xE7, 0x97, 0xB2 },
	0xD8A7, { 0xE7, 0xA2, 0xBC },
	0xD8A8, { 0xE7, 0xA3, 0xA8 },
	0xD8A9, { 0xE9, 0xA6, 0xAC },
	0xD8AA, { 0xE9, 0xAD, 0x94 },
	0xD8AB, { 0xE9, 0xBA, 0xBB },
	0xD8AC, { 0xE5, 0xAF, 0x9E },
	0xD8AD, { 0xE5, 0xB9, 0x95 },
	0xD8AE, { 0xE6, 0xBC, 0xA0 },
	0xD8AF, { 0xE8, 0x86, 0x9C },
	0xD8B0, { 0xE8, 0x8E, 0xAB },
	0xD8B1, { 0xE9, 0x82, 0x88 },
	0xD8B2, { 0xE4, 0xB8, 0x87 },
	0xD8B3, { 0xE5, 0x8D, 0x8D },
	0xD8B4, { 0xE5, 0xA8, 0xA9 },
	0xD8B5, { 0xE5, 0xB7, 0x92 },
	0xD8B6, { 0xE5, 0xBD, 0x8E },
	0xD8B7, { 0xE6, 0x85, 0xA2 },
	0xD8B8, { 0xE6, 0x8C, 0xBD },
	0xD8B9, { 0xE6, 0x99, 0xA9 },
	0xD8BA, { 0xE6, 0x9B, 0xBC },
	0xD8BB, { 0xE6, 0xBB, 0xBF },
	0xD8BC, { 0xE6, 0xBC, 0xAB },
	0xD8BD, { 0xE7, 0x81, 0xA3 },
	0xD8BE, { 0xE7, 0x9E, 0x9E },
	0xD8BF, { 0xE8, 0x90, 0xAC },
	0xD8C0, { 0xE8, 0x94, 0x93 },
	0xD8C1, { 0xE8, 0xA0, 0xBB },
	0xD8C2, { 0xE8, 0xBC, 0x93 },
	0xD8C3, { 0xE9, 0xA5, 0x85 },
	0xD8C4, { 0xE9, 0xB0, 0xBB },
	0xD8C5, { 0xE5, 0x94, 0x9C },
	0xD8C6, { 0xE6, 0x8A, 0xB9 },
	0xD8C7, { 0xE6, 0x9C, 0xAB },
	0xD8C8, { 0xE6, 0xB2, 0xAB },
	0xD8C9, { 0xE8, 0x8C, 0x89 },
	0xD8CA, { 0xE8, 0xA5, 0xAA },
	0xD8CB, { 0xE9, 0x9D, 0xBA },
	0xD8CC, { 0xE4, 0xBA, 0xA1 },
	0xD8CD, { 0xE5, 0xA6, 0x84 },
	0xD8CE, { 0xE5, 0xBF, 0x98 },
	0xD8CF, { 0xE5, 0xBF, 0x99 },
	0xD8D0, { 0xE6, 0x9C, 0x9B },
	0xD8D1, { 0xE7, 0xB6, 0xB2 },
	0xD8D2, { 0xE7, 0xBD, 0x94 },
	0xD8D3, { 0xE8, 0x8A, 0x92 },
	0xD8D4, { 0xE8, 0x8C, 0xAB },
	0xD8D5, { 0xE8, 0x8E, 0xBD },
	0xD8D6, { 0xE8, 0xBC, 0x9E },
	0xD8D7, { 0xE9, 0x82, 0x99 },
	0xD8D8, { 0xE5, 0x9F, 0x8B },
	0xD8D9, { 0xE5, 0xA6, 0xB9 },
	0xD8DA, { 0xE5, 0xAA, 0x92 },
	0xD8DB, { 0xE5, 0xAF, 0x90 },
	0xD8DC, { 0xE6, 0x98, 0xA7 },
	0xD8DD, { 0xE6, 0x9E, 0x9A },
	0xD8DE, { 0xE6, 0xA2, 0x85 },
	0xD8DF, { 0xE6, 0xAF, 0x8F },
	0xD8E0, { 0xE7, 0x85, 0xA4 },
	0xD8E1, { 0xE7, 0xBD, 0xB5 },
	0xD8E2, { 0xE8, 0xB2, 0xB7 },
	0xD8E3, { 0xE8, 0xB3, 0xA3 },
	0xD8E4, { 0xE9, 0x82, 0x81 },
	0xD8E5, { 0xE9, 0xAD, 0x85 },
	0xD8E6, { 0xE8, 0x84, 0x88 },
	0xD8E7, { 0xE8, 0xB2, 0x8A },
	0xD8E8, { 0xE9, 0x99, 0x8C },
	0xD8E9, { 0xE9, 0xA9, 0x80 },
	0xD8EA, { 0xE9, 0xBA, 0xA5 },
	0xD8EB, { 0xE5, 0xAD, 0x9F },
	0xD8EC, { 0xE6, 0xB0, 0x93 },
	0xD8ED, { 0xE7, 0x8C, 0x9B },
	0xD8EE, { 0xE7, 0x9B, 0xB2 },
	0xD8EF, { 0xE7, 0x9B, 0x9F },
	0xD8F0, { 0xE8, 0x90, 0x8C },
	0xD8F1, { 0xE5, 0x86, 0xAA },
	0xD8F2, { 0xE8, 0xA6, 0x93 },
	0xD8F3, { 0xE5, 0x85, 0x8D },
	0xD8F4, { 0xE5, 0x86, 0x95 },
	0xD8F5, { 0xE5, 0x8B, 0x89 },
	0xD8F6, { 0xE6, 0xA3, 0x89 },
	0xD8F7, { 0xE6, 0xB2, 0x94 },
	0xD8F8, { 0xE7, 0x9C, 0x84 },
	0xD8F9, { 0xE7, 0x9C, 0xA0 },
	0xD8FA, { 0xE7, 0xB6, 0xBF },
	0xD8FB, { 0xE7, 0xB7, 0xAC },
	0xD8FC, { 0xE9, 0x9D, 0xA2 },
	0xD8FD, { 0xE9, 0xBA, 0xB5 },
	0xD8FE, { 0xE6, 0xBB, 0x85 },
	0xD9A1, { 0xE8, 0x94, 0x91 },
	0xD9A2, { 0xE5, 0x86, 0xA5 },
	0xD9A3, { 0xE5, 0x90, 0x8D },
	0xD9A4, { 0xE5, 0x91, 0xBD },
	0xD9A5, { 0xE6, 0x98, 0x8E },
	0xD9A6, { 0xE6, 0x9A, 0x9D },
	0xD9A7, { 0xE6, 0xA4, 0xA7 },
	0xD9A8, { 0xE6, 0xBA, 0x9F },
	0xD9A9, { 0xE7, 0x9A, 0xBF },
	0xD9AA, { 0xE7, 0x9E, 0x91 },
	0xD9AB, { 0xE8, 0x8C, 0x97 },
	0xD9AC, { 0xE8, 0x93, 0x82 },
	0xD9AD, { 0xE8, 0x9E, 0x9F },
	0xD9AE, { 0xE9, 0x85, 0xA9 },
	0xD9AF, { 0xE9, 0x8A, 0x98 },
	0xD9B0, { 0xE9, 0xB3, 0xB4 },
	0xD9B1, { 0xE8, 0xA2, 0x82 },
	0xD9B2, { 0xE4, 0xBE, 0xAE },
	0xD9B3, { 0xE5, 0x86, 0x92 },
	0xD9B4, { 0xE5, 0x8B, 0x9F },
	0xD9B5, { 0xE5, 0xA7, 0x86 },
	0xD9B6, { 0xE5, 0xB8, 0xBD },
	0xD9B7, { 0xE6, 0x85, 0x95 },
	0xD9B8, { 0xE6, 0x91, 0xB8 },
	0xD9B9, { 0xE6, 0x91, 0xB9 },
	0xD9BA, { 0xE6, 0x9A, 0xAE },
	0xD9BB, { 0xE6, 0x9F, 0x90 },
	0xD9BC, { 0xE6, 0xA8, 0xA1 },
	0xD9BD, { 0xE6, 0xAF, 0x8D },
	0xD9BE, { 0xE6, 0xAF, 0x9B },
	0xD9BF, { 0xE7, 0x89, 0x9F },
	0xD9C0, { 0xE7, 0x89, 0xA1 },
	0xD9C1, { 0xE7, 0x91, 0x81 },
	0xD9C2, { 0xE7, 0x9C, 0xB8 },
	0xD9C3, { 0xE7, 0x9F, 0x9B },
	0xD9C4, { 0xE8, 0x80, 0x97 },
	0xD9C5, { 0xE8, 0x8A, 0xBC },
	0xD9C6, { 0xE8, 0x8C, 0x85 },
	0xD9C7, { 0xE8, 0xAC, 0x80 },
	0xD9C8, { 0xE8, 0xAC, 0xA8 },
	0xD9C9, { 0xE8, 0xB2, 0x8C },
	0xD9CA, { 0xE6, 0x9C, 0xA8 },
	0xD9CB, { 0xE6, 0xB2, 0x90 },
	0xD9CC, { 0xE7, 0x89, 0xA7 },
	0xD9CD, { 0xE7, 0x9B, 0xAE },
	0xD9CE, { 0xE7, 0x9D, 0xA6 },
	0xD9CF, { 0xE7, 0xA9, 0x86 },
	0xD9D0, { 0xE9, 0xB6, 0xA9 },
	0xD9D1, { 0xE6, 0xAD, 0xBF },
	0xD9D2, { 0xE6, 0xB2, 0x92 },
	0xD9D3, { 0xE5, 0xA4, 0xA2 },
	0xD9D4, { 0xE6, 0x9C, 0xA6 },
	0xD9D5, { 0xE8, 0x92, 0x99 },
	0xD9D6, { 0xE5, 0x8D, 0xAF },
	0xD9D7, { 0xE5, 0xA2, 0x93 },
	0xD9D8, { 0xE5, 0xA6, 0x99 },
	0xD9D9, { 0xE5, 0xBB, 0x9F },
	0xD9DA, { 0xE6, 0x8F, 0x8F },
	0xD9DB, { 0xE6, 0x98, 0xB4 },
	0xD9DC, { 0xE6, 0x9D, 0xB3 },
	0xD9DD, { 0xE6, 0xB8, 0xBA },
	0xD9DE, { 0xE7, 0x8C, 0xAB },
	0xD9DF, { 0xE7, 0xAB, 0x97 },
	0xD9E0, { 0xE8, 0x8B, 0x97 },
	0xD9E1, { 0xE9, 0x8C, 0xA8 },
	0xD9E2, { 0xE5, 0x8B, 0x99 },
	0xD9E3, { 0xE5, 0xB7, 0xAB },
	0xD9E4, { 0xE6, 0x86, 0xAE },
	0xD9E5, { 0xE6, 0x87, 0x8B },
	0xD9E6, { 0xE6, 0x88, 0x8A },
	0xD9E7, { 0xE6, 0x8B, 0x87 },
	0xD9E8, { 0xE6, 0x92, 0xAB },
	0xD9E9, { 0xE6, 0x97, 0xA0 },
	0xD9EA, { 0xE6, 0xA5, 0x99 },
	0xD9EB, { 0xE6, 0xAD, 0xA6 },
	0xD9EC, { 0xE6, 0xAF, 0x8B },
	0xD9ED, { 0xE7, 0x84, 0xA1 },
	0xD9EE, { 0xE7, 0x8F, 0xB7 },
	0xD9EF, { 0xE7, 0x95, 0x9D },
	0xD9F0, { 0xE7, 0xB9, 0x86 },
	0xD9F1, { 0xE8, 0x88, 0x9E },
	0xD9F2, { 0xE8, 0x8C, 0x82 },
	0xD9F3, { 0xE8, 0x95, 0xAA },
	0xD9F4, { 0xE8, 0xAA, 0xA3 },
	0xD9F5, { 0xE8, 0xB2, 0xBF },
	0xD9F6, { 0xE9, 0x9C, 0xA7 },
	0xD9F7, { 0xE9, 0xB5, 0xA1 },
	0xD9F8, { 0xE5, 0xA2, 0xA8 },
	0xD9F9, { 0xE9, 0xBB, 0x98 },
	0xD9FA, { 0xE5, 0x80, 0x91 },
	0xD9FB, { 0xE5, 0x88, 0x8E },
	0xD9FC, { 0xE5, 0x90, 0xBB },
	0xD9FD, { 0xE5, 0x95, 0x8F },
	0xD9FE, { 0xE6, 0x96, 0x87 },
	0xDAA1, { 0xE6, 0xB1, 0xB6 },
	0xDAA2, { 0xE7, 0xB4, 0x8A },
	0xDAA3, { 0xE7, 0xB4, 0x8B },
	0xDAA4, { 0xE8, 0x81, 0x9E },
	0xDAA5, { 0xE8, 0x9A, 0x8A },
	0xDAA6, { 0xE9, 0x96, 0x80 },
	0xDAA7, { 0xE9, 0x9B, 0xAF },
	0xDAA8, { 0xE5, 0x8B, 0xBF },
	0xDAA9, { 0xE6, 0xB2, 0x95 },
	0xDAAA, { 0xE7, 0x89, 0xA9 },
	0xDAAB, { 0xE5, 0x91, 0xB3 },
	0xDAAC, { 0xE5, 0xAA, 0x9A },
	0xDAAD, { 0xE5, 0xB0, 0xBE },
	0xDAAE, { 0xE5, 0xB5, 0x8B },
	0xDAAF, { 0xE5, 0xBD, 0x8C },
	0xDAB0, { 0xE5, 0xBE, 0xAE },
	0xDAB1, { 0xE6, 0x9C, 0xAA },
	0xDAB2, { 0xE6, 0xA2, 0xB6 },
	0xDAB3, { 0xE6, 0xA5, 0xA3 },
	0xDAB4, { 0xE6, 0xB8, 0xBC },
	0xDAB5, { 0xE6, 0xB9, 0x84 },
	0xDAB6, { 0xE7, 0x9C, 0x89 },
	0xDAB7, { 0xE7, 0xB1, 0xB3 },
	0xDAB8, { 0xE7, 0xBE, 0x8E },
	0xDAB9, { 0xE8, 0x96, 0x87 },
	0xDABA, { 0xE8, 0xAC, 0x8E },
	0xDABB, { 0xE8, 0xBF, 0xB7 },
	0xDABC, { 0xE9, 0x9D, 0xA1 },
	0xDABD, { 0xE9, 0xBB, 0xB4 },
	0xDABE, { 0xE5, 0xB2, 0xB7 },
	0xDABF, { 0xE6, 0x82, 0xB6 },
	0xDAC0, { 0xE6, 0x84, 0x8D },
	0xDAC1, { 0xE6, 0x86, 0xAB },
	0xDAC2, { 0xE6, 0x95, 0x8F },
	0xDAC3, { 0xE6, 0x97, 0xBB },
	0xDAC4, { 0xE6, 0x97, 0xBC },
	0xDAC5, { 0xE6, 0xB0, 0x91 },
	0xDAC6, { 0xE6, 0xB3, 0xAF },
	0xDAC7, { 0xE7, 0x8E, 0x9F },
	0xDAC8, { 0xE7, 0x8F, 0x89 },
	0xDAC9, { 0xE7, 0xB7, 0xA1 },
	0xDACA, { 0xE9, 0x96, 0x94 },
	0xDACB, { 0xE5, 0xAF, 0x86 },
	0xDACC, { 0xE8, 0x9C, 0x9C },
	0xDACD, { 0xE8, 0xAC, 0x90 },
	0xDACE, { 0xE5, 0x89, 0x9D },
	0xDACF, { 0xE5, 0x8D, 0x9A },
	0xDAD0, { 0xE6, 0x8B, 0x8D },
	0xDAD1, { 0xE6, 0x90, 0x8F },
	0xDAD2, { 0xE6, 0x92, 0xB2 },
	0xDAD3, { 0xE6, 0x9C, 0xB4 },
	0xDAD4, { 0xE6, 0xA8, 0xB8 },
	0xDAD5, { 0xE6, 0xB3, 0x8A },
	0xDAD6, { 0xE7, 0x8F, 0x80 },
	0xDAD7, { 0xE7, 0x92, 0x9E },
	0xDAD8, { 0xE7, 0xAE, 0x94 },
	0xDAD9, { 0xE7, 0xB2, 0x95 },
	0xDADA, { 0xE7, 0xB8, 0x9B },
	0xDADB, { 0xE8, 0x86, 0x8A },
	0xDADC, { 0xE8, 0x88, 0xB6 },
	0xDADD, { 0xE8, 0x96, 0x84 },
	0xDADE, { 0xE8, 0xBF, 0xAB },
	0xDADF, { 0xE9, 0x9B, 0xB9 },
	0xDAE0, { 0xE9, 0xA7, 0x81 },
	0xDAE1, { 0xE4, 0xBC, 0xB4 },
	0xDAE2, { 0xE5, 0x8D, 0x8A },
	0xDAE3, { 0xE5, 0x8F, 0x8D },
	0xDAE4, { 0xE5, 0x8F, 0x9B },
	0xDAE5, { 0xE6, 0x8B, 0x8C },
	0xDAE6, { 0xE6, 0x90, 0xAC },
	0xDAE7, { 0xE6, 0x94, 0x80 },
	0xDAE8, { 0xE6, 0x96, 0x91 },
	0xDAE9, { 0xE6, 0xA7, 0x83 },
	0xDAEA, { 0xE6, 0xB3, 0xAE },
	0xDAEB, { 0xE6, 0xBD, 0x98 },
	0xDAEC, { 0xE7, 0x8F, 0xAD },
	0xDAED, { 0xE7, 0x95, 0x94 },
	0xDAEE, { 0xE7, 0x98, 0xA2 },
	0xDAEF, { 0xE7, 0x9B, 0xA4 },
	0xDAF0, { 0xE7, 0x9B, 0xBC },
	0xDAF1, { 0xE7, 0xA3, 0x90 },
	0xDAF2, { 0xE7, 0xA3, 0xBB },
	0xDAF3, { 0xE7, 0xA4, 0xAC },
	0xDAF4, { 0xE7, 0xB5, 0x86 },
	0xDAF5, { 0xE8, 0x88, 0xAC },
	0xDAF6, { 0xE8, 0x9F, 0xA0 },
	0xDAF7, { 0xE8, 0xBF, 0x94 },
	0xDAF8, { 0xE9, 0xA0, 0x92 },
	0xDAF9, { 0xE9, 0xA3, 0xAF },
	0xDAFA, { 0xE5, 0x8B, 0x83 },
	0xDAFB, { 0xE6, 0x8B, 0x94 },
	0xDAFC, { 0xE6, 0x92, 0xA5 },
	0xDAFD, { 0xE6, 0xB8, 0xA4 },
	0xDAFE, { 0xE6, 0xBD, 0x91 },
	0xDBA1, { 0xE7, 0x99, 0xBC },
	0xDBA2, { 0xE8, 0xB7, 0x8B },
	0xDBA3, { 0xE9, 0x86, 0xB1 },
	0xDBA4, { 0xE9, 0x89, 0xA2 },
	0xDBA5, { 0xE9, 0xAB, 0xAE },
	0xDBA6, { 0xE9, 0xAD, 0x83 },
	0xDBA7, { 0xE5, 0x80, 0xA3 },
	0xDBA8, { 0xE5, 0x82, 0x8D },
	0xDBA9, { 0xE5, 0x9D, 0x8A },
	0xDBAA, { 0xE5, 0xA6, 0xA8 },
	0xDBAB, { 0xE5, 0xB0, 0xA8 },
	0xDBAC, { 0xE5, 0xB9, 0x87 },
	0xDBAD, { 0xE5, 0xBD, 0xB7 },
	0xDBAE, { 0xE6, 0x88, 0xBF },
	0xDBAF, { 0xE6, 0x94, 0xBE },
	0xDBB0, { 0xE6, 0x96, 0xB9 },
	0xDBB1, { 0xE6, 0x97, 0x81 },
	0xDBB2, { 0xE6, 0x98, 0x89 },
	0xDBB3, { 0xE6, 0x9E, 0x8B },
	0xDBB4, { 0xE6, 0xA6, 0x9C },
	0xDBB5, { 0xE6, 0xBB, 0x82 },
	0xDBB6, { 0xE7, 0xA3, 0x85 },
	0xDBB7, { 0xE7, 0xB4, 0xA1 },
	0xDBB8, { 0xE8, 0x82, 0xAA },
	0xDBB9, { 0xE8, 0x86, 0x80 },
	0xDBBA, { 0xE8, 0x88, 0xAB },
	0xDBBB, { 0xE8, 0x8A, 0xB3 },
	0xDBBC, { 0xE8, 0x92, 0xA1 },
	0xDBBD, { 0xE8, 0x9A, 0x8C },
	0xDBBE, { 0xE8, 0xA8, 0xAA },
	0xDBBF, { 0xE8, 0xAC, 0x97 },
	0xDBC0, { 0xE9, 0x82, 0xA6 },
	0xDBC1, { 0xE9, 0x98, 0xB2 },
	0xDBC2, { 0xE9, 0xBE, 0x90 },
	0xDBC3, { 0xE5, 0x80, 0x8D },
	0xDBC4, { 0xE4, 0xBF, 0xB3 },
	0xDBC5, { 0xEF, 0xA5, 0xA3 },
	0xDBC6, { 0xE5, 0x9F, 0xB9 },
	0xDBC7, { 0xE5, 0xBE, 0x98 },
	0xDBC8, { 0xE6, 0x8B, 0x9C },
	0xDBC9, { 0xE6, 0x8E, 0x92 },
	0xDBCA, { 0xE6, 0x9D, 0xAF },
	0xDBCB, { 0xE6, 0xB9, 0x83 },
	0xDBCC, { 0xE7, 0x84, 0x99 },
	0xDBCD, { 0xE7, 0x9B, 0x83 },
	0xDBCE, { 0xE8, 0x83, 0x8C },
	0xDBCF, { 0xE8, 0x83, 0x9A },
	0xDBD0, { 0xE8, 0xA3, 0xB4 },
	0xDBD1, { 0xE8, 0xA3, 0xB5 },
	0xDBD2, { 0xE8, 0xA4, 0x99 },
	0xDBD3, { 0xE8, 0xB3, 0xA0 },
	0xDBD4, { 0xE8, 0xBC, 0xA9 },
	0xDBD5, { 0xE9, 0x85, 0x8D },
	0xDBD6, { 0xE9, 0x99, 0xAA },
	0xDBD7, { 0xE4, 0xBC, 0xAF },
	0xDBD8, { 0xE4, 0xBD, 0xB0 },
	0xDBD9, { 0xE5, 0xB8, 0x9B },
	0xDBDA, { 0xE6, 0x9F, 0x8F },
	0xDBDB, { 0xE6, 0xA0, 0xA2 },
	0xDBDC, { 0xE7, 0x99, 0xBD },
	0xDBDD, { 0xE7, 0x99, 0xBE },
	0xDBDE, { 0xE9, 0xAD, 0x84 },
	0xDBDF, { 0xE5, 0xB9, 0xA1 },
	0xDBE0, { 0xE6, 0xA8, 0x8A },
	0xDBE1, { 0xE7, 0x85, 0xA9 },
	0xDBE2, { 0xE7, 0x87, 0x94 },
	0xDBE3, { 0xE7, 0x95, 0xAA },
	0xDBE4, { 0xEF, 0xA5, 0xA4 },
	0xDBE5, { 0xE7, 0xB9, 0x81 },
	0xDBE6, { 0xE8, 0x95, 0x83 },
	0xDBE7, { 0xE8, 0x97, 0xA9 },
	0xDBE8, { 0xE9, 0xA3, 0x9C },
	0xDBE9, { 0xE4, 0xBC, 0x90 },
	0xDBEA, { 0xE7, 0xAD, 0x8F },
	0xDBEB, { 0xE7, 0xBD, 0xB0 },
	0xDBEC, { 0xE9, 0x96, 0xA5 },
	0xDBED, { 0xE5, 0x87, 0xA1 },
	0xDBEE, { 0xE5, 0xB8, 0x86 },
	0xDBEF, { 0xE6, 0xA2, 0xB5 },
	0xDBF0, { 0xE6, 0xB0, 0xBE },
	0xDBF1, { 0xE6, 0xB1, 0x8E },
	0xDBF2, { 0xE6, 0xB3, 0x9B },
	0xDBF3, { 0xE7, 0x8A, 0xAF },
	0xDBF4, { 0xE7, 0xAF, 0x84 },
	0xDBF5, { 0xE8, 0x8C, 0x83 },
	0xDBF6, { 0xE6, 0xB3, 0x95 },
	0xDBF7, { 0xE7, 0x90, 0xBA },
	0xDBF8, { 0xE5, 0x83, 0xBB },
	0xDBF9, { 0xE5, 0x8A, 0x88 },
	0xDBFA, { 0xE5, 0xA3, 0x81 },
	0xDBFB, { 0xE6, 0x93, 0x98 },
	0xDBFC, { 0xE6, 0xAA, 0x97 },
	0xDBFD, { 0xE7, 0x92, 0xA7 },
	0xDBFE, { 0xE7, 0x99, 0x96 },
	0xDCA1, { 0xE7, 0xA2, 0xA7 },
	0xDCA2, { 0xE8, 0x98, 0x97 },
	0xDCA3, { 0xE9, 0x97, 0xA2 },
	0xDCA4, { 0xE9, 0x9C, 0xB9 },
	0xDCA5, { 0xEF, 0xA5, 0xA5 },
	0xDCA6, { 0xE5, 0x8D, 0x9E },
	0xDCA7, { 0xE5, 0xBC, 0x81 },
	0xDCA8, { 0xE8, 0xAE, 0x8A },
	0xDCA9, { 0xE8, 0xBE, 0xA8 },
	0xDCAA, { 0xE8, 0xBE, 0xAF },
	0xDCAB, { 0xE9, 0x82, 0x8A },
	0xDCAC, { 0xE5, 0x88, 0xA5 },
	0xDCAD, { 0xE7, 0x9E, 0xA5 },
	0xDCAE, { 0xE9, 0xB1, 0x89 },
	0xDCAF, { 0xE9, 0xBC, 0x88 },
	0xDCB0, { 0xE4, 0xB8, 0x99 },
	0xDCB1, { 0xE5, 0x80, 0x82 },
	0xDCB2, { 0xE5, 0x85, 0xB5 },
	0xDCB3, { 0xE5, 0xB1, 0x9B },
	0xDCB4, { 0xE5, 0xB9, 0xB7 },
	0xDCB5, { 0xE6, 0x98, 0x9E },
	0xDCB6, { 0xE6, 0x98, 0xBA },
	0xDCB7, { 0xE6, 0x9F, 0x84 },
	0xDCB8, { 0xE6, 0xA3, 0x85 },
	0xDCB9, { 0xE7, 0x82, 0xB3 },
	0xDCBA, { 0xE7, 0x94, 0x81 },
	0xDCBB, { 0xE7, 0x97, 0x85 },
	0xDCBC, { 0xE7, 0xA7, 0x89 },
	0xDCBD, { 0xE7, 0xAB, 0x9D },
	0xDCBE, { 0xE8, 0xBC, 0xA7 },
	0xDCBF, { 0xE9, 0xA4, 0xA0 },
	0xDCC0, { 0xE9, 0xA8, 0x88 },
	0xDCC1, { 0xE4, 0xBF, 0x9D },
	0xDCC2, { 0xE5, 0xA0, 0xA1 },
	0xDCC3, { 0xE5, 0xA0, 0xB1 },
	0xDCC4, { 0xE5, 0xAF, 0xB6 },
	0xDCC5, { 0xE6, 0x99, 0xAE },
	0xDCC6, { 0xE6, 0xAD, 0xA5 },
	0xDCC7, { 0xE6, 0xB4, 0x91 },
	0xDCC8, { 0xE6, 0xB9, 0xBA },
	0xDCC9, { 0xE6, 0xBD, 0xBD },
	0xDCCA, { 0xE7, 0x8F, 0xA4 },
	0xDCCB, { 0xE7, 0x94, 0xAB },
	0xDCCC, { 0xE8, 0x8F, 0xA9 },
	0xDCCD, { 0xE8, 0xA3, 0x9C },
	0xDCCE, { 0xE8, 0xA4, 0x93 },
	0xDCCF, { 0xE8, 0xAD, 0x9C },
	0xDCD0, { 0xE8, 0xBC, 0x94 },
	0xDCD1, { 0xE4, 0xBC, 0x8F },
	0xDCD2, { 0xE5, 0x83, 0x95 },
	0xDCD3, { 0xE5, 0x8C, 0x90 },
	0xDCD4, { 0xE5, 0x8D, 0x9C },
	0xDCD5, { 0xE5, 0xAE, 0x93 },
	0xDCD6, { 0xE5, 0xBE, 0xA9 },
	0xDCD7, { 0xE6, 0x9C, 0x8D },
	0xDCD8, { 0xE7, 0xA6, 0x8F },
	0xDCD9, { 0xE8, 0x85, 0xB9 },
	0xDCDA, { 0xE8, 0x8C, 0xAF },
	0xDCDB, { 0xE8, 0x94, 0x94 },
	0xDCDC, { 0xE8, 0xA4, 0x87 },
	0xDCDD, { 0xE8, 0xA6, 0x86 },
	0xDCDE, { 0xE8, 0xBC, 0xB9 },
	0xDCDF, { 0xE8, 0xBC, 0xBB },
	0xDCE0, { 0xE9, 0xA6, 0xA5 },
	0xDCE1, { 0xE9, 0xB0, 0x92 },
	0xDCE2, { 0xE6, 0x9C, 0xAC },
	0xDCE3, { 0xE4, 0xB9, 0xB6 },
	0xDCE4, { 0xE4, 0xBF, 0xB8 },
	0xDCE5, { 0xE5, 0xA5, 0x89 },
	0xDCE6, { 0xE5, 0xB0, 0x81 },
	0xDCE7, { 0xE5, 0xB3, 0xAF },
	0xDCE8, { 0xE5, 0xB3, 0xB0 },
	0xDCE9, { 0xE6, 0x8D, 0xA7 },
	0xDCEA, { 0xE6, 0xA3, 0x92 },
	0xDCEB, { 0xE7, 0x83, 0xBD },
	0xDCEC, { 0xE7, 0x86, 0xA2 },
	0xDCED, { 0xE7, 0x90, 0xAB },
	0xDCEE, { 0xE7, 0xB8, 0xAB },
	0xDCEF, { 0xE8, 0x93, 0xAC },
	0xDCF0, { 0xE8, 0x9C, 0x82 },
	0xDCF1, { 0xE9, 0x80, 0xA2 },
	0xDCF2, { 0xE9, 0x8B, 0x92 },
	0xDCF3, { 0xE9, 0xB3, 0xB3 },
	0xDCF4, { 0xE4, 0xB8, 0x8D },
	0xDCF5, { 0xE4, 0xBB, 0x98 },
	0xDCF6, { 0xE4, 0xBF, 0xAF },
	0xDCF7, { 0xE5, 0x82, 0x85 },
	0xDCF8, { 0xE5, 0x89, 0x96 },
	0xDCF9, { 0xE5, 0x89, 0xAF },
	0xDCFA, { 0xE5, 0x90, 0xA6 },
	0xDCFB, { 0xE5, 0x92, 0x90 },
	0xDCFC, { 0xE5, 0x9F, 0xA0 },
	0xDCFD, { 0xE5, 0xA4, 0xAB },
	0xDCFE, { 0xE5, 0xA9, 0xA6 },
	0xDDA1, { 0xE5, 0xAD, 0x9A },
	0xDDA2, { 0xE5, 0xAD, 0xB5 },
	0xDDA3, { 0xE5, 0xAF, 0x8C },
	0xDDA4, { 0xE5, 0xBA, 0x9C },
	0xDDA5, { 0xEF, 0xA5, 0xA6 },
	0xDDA6, { 0xE6, 0x89, 0xB6 },
	0xDDA7, { 0xE6, 0x95, 0xB7 },
	0xDDA8, { 0xE6, 0x96, 0xA7 },
	0xDDA9, { 0xE6, 0xB5, 0xAE },
	0xDDAA, { 0xE6, 0xBA, 0xA5 },
	0xDDAB, { 0xE7, 0x88, 0xB6 },
	0xDDAC, { 0xE7, 0xAC, 0xA6 },
	0xDDAD, { 0xE7, 0xB0, 0xBF },
	0xDDAE, { 0xE7, 0xBC, 0xB6 },
	0xDDAF, { 0xE8, 0x85, 0x90 },
	0xDDB0, { 0xE8, 0x85, 0x91 },
	0xDDB1, { 0xE8, 0x86, 0x9A },
	0xDDB2, { 0xE8, 0x89, 0x80 },
	0xDDB3, { 0xE8, 0x8A, 0x99 },
	0xDDB4, { 0xE8, 0x8E, 0xA9 },
	0xDDB5, { 0xE8, 0xA8, 0x83 },
	0xDDB6, { 0xE8, 0xB2, 0xA0 },
	0xDDB7, { 0xE8, 0xB3, 0xA6 },
	0xDDB8, { 0xE8, 0xB3, 0xBB },
	0xDDB9, { 0xE8, 0xB5, 0xB4 },
	0xDDBA, { 0xE8, 0xB6, 0xBA },
	0xDDBB, { 0xE9, 0x83, 0xA8 },
	0xDDBC, { 0xE9, 0x87, 0x9C },
	0xDDBD, { 0xE9, 0x98, 0x9C },
	0xDDBE, { 0xE9, 0x99, 0x84 },
	0xDDBF, { 0xE9, 0xA7, 0x99 },
	0xDDC0, { 0xE9, 0xB3, 0xA7 },
	0xDDC1, { 0xE5, 0x8C, 0x97 },
	0xDDC2, { 0xE5, 0x88, 0x86 },
	0xDDC3, { 0xE5, 0x90, 0xA9 },
	0xDDC4, { 0xE5, 0x99, 0xB4 },
	0xDDC5, { 0xE5, 0xA2, 0xB3 },
	0xDDC6, { 0xE5, 0xA5, 0x94 },
	0xDDC7, { 0xE5, 0xA5, 0xAE },
	0xDDC8, { 0xE5, 0xBF, 0xBF },
	0xDDC9, { 0xE6, 0x86, 0xA4 },
	0xDDCA, { 0xE6, 0x89, 0xAE },
	0xDDCB, { 0xE6, 0x98, 0x90 },
	0xDDCC, { 0xE6, 0xB1, 0xBE },
	0xDDCD, { 0xE7, 0x84, 0x9A },
	0xDDCE, { 0xE7, 0x9B, 0x86 },
	0xDDCF, { 0xE7, 0xB2, 0x89 },
	0xDDD0, { 0xE7, 0xB3, 0x9E },
	0xDDD1, { 0xE7, 0xB4, 0x9B },
	0xDDD2, { 0xE8, 0x8A, 0xAC },
	0xDDD3, { 0xE8, 0xB3, 0x81 },
	0xDDD4, { 0xE9, 0x9B, 0xB0 },
	0xDDD5, { 0xEF, 0xA5, 0xA7 },
	0xDDD6, { 0xE4, 0xBD, 0x9B },
	0xDDD7, { 0xE5, 0xBC, 0x97 },
	0xDDD8, { 0xE5, 0xBD, 0xBF },
	0xDDD9, { 0xE6, 0x8B, 0x82 },
	0xDDDA, { 0xE5, 0xB4, 0xA9 },
	0xDDDB, { 0xE6, 0x9C, 0x8B },
	0xDDDC, { 0xE6, 0xA3, 0x9A },
	0xDDDD, { 0xE7, 0xA1, 0xBC },
	0xDDDE, { 0xE7, 0xB9, 0x83 },
	0xDDDF, { 0xE9, 0xB5, 0xAC },
	0xDDE0, { 0xE4, 0xB8, 0x95 },
	0xDDE1, { 0xE5, 0x82, 0x99 },
	0xDDE2, { 0xE5, 0x8C, 0x95 },
	0xDDE3, { 0xE5, 0x8C, 0xAA },
	0xDDE4, { 0xE5, 0x8D, 0x91 },
	0xDDE5, { 0xE5, 0xA6, 0x83 },
	0xDDE6, { 0xE5, 0xA9, 0xA2 },
	0xDDE7, { 0xE5, 0xBA, 0x87 },
	0xDDE8, { 0xE6, 0x82, 0xB2 },
	0xDDE9, { 0xE6, 0x86, 0x8A },
	0xDDEA, { 0xE6, 0x89, 0x89 },
	0xDDEB, { 0xE6, 0x89, 0xB9 },
	0xDDEC, { 0xE6, 0x96, 0x90 },
	0xDDED, { 0xE6, 0x9E, 0x87 },
	0xDDEE, { 0xE6, 0xA6, 0xA7 },
	0xDDEF, { 0xE6, 0xAF, 0x94 },
	0xDDF0, { 0xE6, 0xAF, 0x96 },
	0xDDF1, { 0xE6, 0xAF, 0x97 },
	0xDDF2, { 0xE6, 0xAF, 0x98 },
	0xDDF3, { 0xE6, 0xB2, 0xB8 },
	0xDDF4, { 0xEF, 0xA5, 0xA8 },
	0xDDF5, { 0xE7, 0x90, 0xB5 },
	0xDDF6, { 0xE7, 0x97, 0xBA },
	0xDDF7, { 0xE7, 0xA0, 0x92 },
	0xDDF8, { 0xE7, 0xA2, 0x91 },
	0xDDF9, { 0xE7, 0xA7, 0x95 },
	0xDDFA, { 0xE7, 0xA7, 0x98 },
	0xDDFB, { 0xE7, 0xB2, 0x83 },
	0xDDFC, { 0xE7, 0xB7, 0x8B },
	0xDDFD, { 0xE7, 0xBF, 0xA1 },
	0xDDFE, { 0xE8, 0x82, 0xA5 },
	0xDEA1, { 0xE8, 0x84, 0xBE },
	0xDEA2, { 0xE8, 0x87, 0x82 },
	0xDEA3, { 0xE8, 0x8F, 0xB2 },
	0xDEA4, { 0xE8, 0x9C, 0x9A },
	0xDEA5, { 0xE8, 0xA3, 0xA8 },
	0xDEA6, { 0xE8, 0xAA, 0xB9 },
	0xDEA7, { 0xE8, 0xAD, 0xAC },
	0xDEA8, { 0xE8, 0xB2, 0xBB },
	0xDEA9, { 0xE9, 0x84, 0x99 },
	0xDEAA, { 0xE9, 0x9D, 0x9E },
	0xDEAB, { 0xE9, 0xA3, 0x9B },
	0xDEAC, { 0xE9, 0xBC, 0xBB },
	0xDEAD, { 0xE5, 0x9A, 0xAC },
	0xDEAE, { 0xE5, 0xAC, 0xAA },
	0xDEAF, { 0xE5, 0xBD, 0xAC },
	0xDEB0, { 0xE6, 0x96, 0x8C },
	0xDEB1, { 0xE6, 0xAA, 0xB3 },
	0xDEB2, { 0xE6, 0xAE, 0xAF },
	0xDEB3, { 0xE6, 0xB5, 0x9C },
	0xDEB4, { 0xE6, 0xBF, 0xB1 },
	0xDEB5, { 0xE7, 0x80, 0x95 },
	0xDEB6, { 0xE7, 0x89, 0x9D },
	0xDEB7, { 0xE7, 0x8E, 0xAD },
	0xDEB8, { 0xE8, 0xB2, 0xA7 },
	0xDEB9, { 0xE8, 0xB3, 0x93 },
	0xDEBA, { 0xE9, 0xA0, 0xBB },
	0xDEBB, { 0xE6, 0x86, 0x91 },
	0xDEBC, { 0xE6, 0xB0, 0xB7 },
	0xDEBD, { 0xE8, 0x81, 0x98 },
	0xDEBE, { 0xE9, 0xA8, 0x81 },
	0xDEBF, { 0xE4, 0xB9, 0x8D },
	0xDEC0, { 0xE4, 0xBA, 0x8B },
	0xDEC1, { 0xE4, 0xBA, 0x9B },
	0xDEC2, { 0xE4, 0xBB, 0x95 },
	0xDEC3, { 0xE4, 0xBC, 0xBA },
	0xDEC4, { 0xE4, 0xBC, 0xBC },
	0xDEC5, { 0xE4, 0xBD, 0xBF },
	0xDEC6, { 0xE4, 0xBF, 0x9F },
	0xDEC7, { 0xE5, 0x83, 0xBF },
	0xDEC8, { 0xE5, 0x8F, 0xB2 },
	0xDEC9, { 0xE5, 0x8F, 0xB8 },
	0xDECA, { 0xE5, 0x94, 0x86 },
	0xDECB, { 0xE5, 0x97, 0xA3 },
	0xDECC, { 0xE5, 0x9B, 0x9B },
	0xDECD, { 0xE5, 0xA3, 0xAB },
	0xDECE, { 0xE5, 0xA5, 0xA2 },
	0xDECF, { 0xE5, 0xA8, 0x91 },
	0xDED0, { 0xE5, 0xAF, 0xAB },
	0xDED1, { 0xE5, 0xAF, 0xBA },
	0xDED2, { 0xE5, 0xB0, 0x84 },
	0xDED3, { 0xE5, 0xB7, 0xB3 },
	0xDED4, { 0xE5, 0xB8, 0xAB },
	0xDED5, { 0xE5, 0xBE, 0x99 },
	0xDED6, { 0xE6, 0x80, 0x9D },
	0xDED7, { 0xE6, 0x8D, 0xA8 },
	0xDED8, { 0xE6, 0x96, 0x9C },
	0xDED9, { 0xE6, 0x96, 0xAF },
	0xDEDA, { 0xE6, 0x9F, 0xB6 },
	0xDEDB, { 0xE6, 0x9F, 0xBB },
	0xDEDC, { 0xE6, 0xA2, 0xAD },
	0xDEDD, { 0xE6, 0xAD, 0xBB },
	0xDEDE, { 0xE6, 0xB2, 0x99 },
	0xDEDF, { 0xE6, 0xB3, 0x97 },
	0xDEE0, { 0xE6, 0xB8, 0xA3 },
	0xDEE1, { 0xE7, 0x80, 0x89 },
	0xDEE2, { 0xE7, 0x8D, 0x85 },
	0xDEE3, { 0xE7, 0xA0, 0x82 },
	0xDEE4, { 0xE7, 0xA4, 0xBE },
	0xDEE5, { 0xE7, 0xA5, 0x80 },
	0xDEE6, { 0xE7, 0xA5, 0xA0 },
	0xDEE7, { 0xE7, 0xA7, 0x81 },
	0xDEE8, { 0xE7, 0xAF, 0xA9 },
	0xDEE9, { 0xE7, 0xB4, 0x97 },
	0xDEEA, { 0xE7, 0xB5, 0xB2 },
	0xDEEB, { 0xE8, 0x82, 0x86 },
	0xDEEC, { 0xE8, 0x88, 0x8D },
	0xDEED, { 0xE8, 0x8E, 0x8E },
	0xDEEE, { 0xE8, 0x93, 0x91 },
	0xDEEF, { 0xE8, 0x9B, 0x87 },
	0xDEF0, { 0xE8, 0xA3, 0x9F },
	0xDEF1, { 0xE8, 0xA9, 0x90 },
	0xDEF2, { 0xE8, 0xA9, 0x9E },
	0xDEF3, { 0xE8, 0xAC, 0x9D },
	0xDEF4, { 0xE8, 0xB3, 0x9C },
	0xDEF5, { 0xE8, 0xB5, 0xA6 },
	0xDEF6, { 0xE8, 0xBE, 0xAD },
	0xDEF7, { 0xE9, 0x82, 0xAA },
	0xDEF8, { 0xE9, 0xA3, 0xBC },
	0xDEF9, { 0xE9, 0xA7, 0x9F },
	0xDEFA, { 0xE9, 0xBA, 0x9D },
	0xDEFB, { 0xE5, 0x89, 0x8A },
	0xDEFC, { 0xEF, 0xA5, 0xA9 },
	0xDEFD, { 0xE6, 0x9C, 0x94 },
	0xDEFE, { 0xEF, 0xA5, 0xAA },
	0xDFA1, { 0xE5, 0x82, 0x98 },
	0xDFA2, { 0xE5, 0x88, 0xAA },
	0xDFA3, { 0xE5, 0xB1, 0xB1 },
	0xDFA4, { 0xE6, 0x95, 0xA3 },
	0xDFA5, { 0xE6, 0xB1, 0x95 },
	0xDFA6, { 0xE7, 0x8F, 0x8A },
	0xDFA7, { 0xE7, 0x94, 0xA3 },
	0xDFA8, { 0xE7, 0x96, 0x9D },
	0xDFA9, { 0xE7, 0xAE, 0x97 },
	0xDFAA, { 0xE8, 0x92, 0x9C },
	0xDFAB, { 0xE9, 0x85, 0xB8 },
	0xDFAC, { 0xE9, 0x9C, 0xB0 },
	0xDFAD, { 0xE4, 0xB9, 0xB7 },
	0xDFAE, { 0xE6, 0x92, 0x92 },
	0xDFAF, { 0xE6, 0xAE, 0xBA },
	0xDFB0, { 0xE7, 0x85, 0x9E },
	0xDFB1, { 0xE8, 0x96, 0xA9 },
	0xDFB2, { 0xE4, 0xB8, 0x89 },
	0xDFB3, { 0xEF, 0xA5, 0xAB },
	0xDFB4, { 0xE6, 0x9D, 0x89 },
	0xDFB5, { 0xE6, 0xA3, 0xAE },
	0xDFB6, { 0xE6, 0xB8, 0x97 },
	0xDFB7, { 0xE8, 0x8A, 0x9F },
	0xDFB8, { 0xE8, 0x94, 0x98 },
	0xDFB9, { 0xE8, 0xA1, 0xAB },
	0xDFBA, { 0xE6, 0x8F, 0xB7 },
	0xDFBB, { 0xE6, 0xBE, 0x81 },
	0xDFBC, { 0xE9, 0x88, 0x92 },
	0xDFBD, { 0xE9, 0xA2, 0xAF },
	0xDFBE, { 0xE4, 0xB8, 0x8A },
	0xDFBF, { 0xE5, 0x82, 0xB7 },
	0xDFC0, { 0xE5, 0x83, 0x8F },
	0xDFC1, { 0xE5, 0x84, 0x9F },
	0xDFC2, { 0xE5, 0x95, 0x86 },
	0xDFC3, { 0xE5, 0x96, 0xAA },
	0xDFC4, { 0xE5, 0x98, 0x97 },
	0xDFC5, { 0xE5, 0xAD, 0x80 },
	0xDFC6, { 0xE5, 0xB0, 0x99 },
	0xDFC7, { 0xE5, 0xB3, 0xA0 },
	0xDFC8, { 0xE5, 0xB8, 0xB8 },
	0xDFC9, { 0xE5, 0xBA, 0x8A },
	0xDFCA, { 0xE5, 0xBA, 0xA0 },
	0xDFCB, { 0xE5, 0xBB, 0x82 },
	0xDFCC, { 0xE6, 0x83, 0xB3 },
	0xDFCD, { 0xE6, 0xA1, 0x91 },
	0xDFCE, { 0xE6, 0xA9, 0xA1 },
	0xDFCF, { 0xE6, 0xB9, 0x98 },
	0xDFD0, { 0xE7, 0x88, 0xBD },
	0xDFD1, { 0xE7, 0x89, 0x80 },
	0xDFD2, { 0xE7, 0x8B, 0x80 },
	0xDFD3, { 0xE7, 0x9B, 0xB8 },
	0xDFD4, { 0xE7, 0xA5, 0xA5 },
	0xDFD5, { 0xE7, 0xAE, 0xB1 },
	0xDFD6, { 0xE7, 0xBF, 0x94 },
	0xDFD7, { 0xE8, 0xA3, 0xB3 },
	0xDFD8, { 0xE8, 0xA7, 0xB4 },
	0xDFD9, { 0xE8, 0xA9, 0xB3 },
	0xDFDA, { 0xE8, 0xB1, 0xA1 },
	0xDFDB, { 0xE8, 0xB3, 0x9E },
	0xDFDC, { 0xE9, 0x9C, 0x9C },
	0xDFDD, { 0xE5, 0xA1, 0x9E },
	0xDFDE, { 0xE7, 0x92, 0xBD },
	0xDFDF, { 0xE8, 0xB3, 0xBD },
	0xDFE0, { 0xE5, 0x97, 0x87 },
	0xDFE1, { 0xEF, 0xA5, 0xAC },
	0xDFE2, { 0xE7, 0xA9, 0xA1 },
	0xDFE3, { 0xE7, 0xB4, 0xA2 },
	0xDFE4, { 0xE8, 0x89, 0xB2 },
	0xDFE5, { 0xE7, 0x89, 0xB2 },
	0xDFE6, { 0xE7, 0x94, 0x9F },
	0xDFE7, { 0xE7, 0x94, 0xA5 },
	0xDFE8, { 0xEF, 0xA5, 0xAD },
	0xDFE9, { 0xE7, 0xAC, 0x99 },
	0xDFEA, { 0xE5, 0xA2, 0x85 },
	0xDFEB, { 0xE5, 0xA3, 0xBB },
	0xDFEC, { 0xE5, 0xB6, 0xBC },
	0xDFED, { 0xE5, 0xBA, 0x8F },
	0xDFEE, { 0xE5, 0xBA, 0xB6 },
	0xDFEF, { 0xE5, 0xBE, 0x90 },
	0xDFF0, { 0xE6, 0x81, 0x95 },
	0xDFF1, { 0xE6, 0x8A, 0x92 },
	0xDFF2, { 0xE6, 0x8D, 0xBF },
	0xDFF3, { 0xE6, 0x95, 0x8D },
	0xDFF4, { 0xE6, 0x9A, 0x91 },
	0xDFF5, { 0xE6, 0x9B, 0x99 },
	0xDFF6, { 0xE6, 0x9B, 0xB8 },
	0xDFF7, { 0xE6, 0xA0, 0x96 },
	0xDFF8, { 0xE6, 0xA3, 0xB2 },
	0xDFF9, { 0xE7, 0x8A, 0x80 },
	0xDFFA, { 0xE7, 0x91, 0x9E },
	0xDFFB, { 0xE7, 0xAD, 0xAE },
	0xDFFC, { 0xE7, 0xB5, 0xAE },
	0xDFFD, { 0xE7, 0xB7, 0x96 },
	0xDFFE, { 0xE7, 0xBD, 0xB2 },
	0xE0A1, { 0xE8, 0x83, 0xA5 },
	0xE0A2, { 0xE8, 0x88, 0x92 },
	0xE0A3, { 0xE8, 0x96, 0xAF },
	0xE0A4, { 0xE8, 0xA5, 0xBF },
	0xE0A5, { 0xE8, 0xAA, 0x93 },
	0xE0A6, { 0xE9, 0x80, 0x9D },
	0xE0A7, { 0xE9, 0x8B, 0xA4 },
	0xE0A8, { 0xE9, 0xBB, 0x8D },
	0xE0A9, { 0xE9, 0xBC, 0xA0 },
	0xE0AA, { 0xE5, 0xA4, 0x95 },
	0xE0AB, { 0xE5, 0xA5, 0xAD },
	0xE0AC, { 0xE5, 0xB8, 0xAD },
	0xE0AD, { 0xE6, 0x83, 0x9C },
	0xE0AE, { 0xE6, 0x98, 0x94 },
	0xE0AF, { 0xE6, 0x99, 0xB3 },
	0xE0B0, { 0xE6, 0x9E, 0x90 },
	0xE0B1, { 0xE6, 0xB1, 0x90 },
	0xE0B2, { 0xE6, 0xB7, 0x85 },
	0xE0B3, { 0xE6, 0xBD, 0x9F },
	0xE0B4, { 0xE7, 0x9F, 0xB3 },
	0xE0B5, { 0xE7, 0xA2, 0xA9 },
	0xE0B6, { 0xE8, 0x93, 0x86 },
	0xE0B7, { 0xE9, 0x87, 0x8B },
	0xE0B8, { 0xE9, 0x8C, 0xAB },
	0xE0B9, { 0xE4, 0xBB, 0x99 },
	0xE0BA, { 0xE5, 0x83, 0x8A },
	0xE0BB, { 0xE5, 0x85, 0x88 },
	0xE0BC, { 0xE5, 0x96, 0x84 },
	0xE0BD, { 0xE5, 0xAC, 0x8B },
	0xE0BE, { 0xE5, 0xAE, 0xA3 },
	0xE0BF, { 0xE6, 0x89, 0x87 },
	0xE0C0, { 0xE6, 0x95, 0xBE },
	0xE0C1, { 0xE6, 0x97, 0x8B },
	0xE0C2, { 0xE6, 0xB8, 0xB2 },
	0xE0C3, { 0xE7, 0x85, 0xBD },
	0xE0C4, { 0xE7, 0x90, 0x81 },
	0xE0C5, { 0xE7, 0x91, 0x84 },
	0xE0C6, { 0xE7, 0x92, 0x87 },
	0xE0C7, { 0xE7, 0x92, 0xBF },
	0xE0C8, { 0xE7, 0x99, 0xAC },
	0xE0C9, { 0xE7, 0xA6, 0xAA },
	0xE0CA, { 0xE7, 0xB7, 0x9A },
	0xE0CB, { 0xE7, 0xB9, 0x95 },
	0xE0CC, { 0xE7, 0xBE, 0xA8 },
	0xE0CD, { 0xE8, 0x85, 0xBA },
	0xE0CE, { 0xE8, 0x86, 0xB3 },
	0xE0CF, { 0xE8, 0x88, 0xB9 },
	0xE0D0, { 0xE8, 0x98, 0x9A },
	0xE0D1, { 0xE8, 0x9F, 0xAC },
	0xE0D2, { 0xE8, 0xA9, 0xB5 },
	0xE0D3, { 0xE8, 0xB7, 0xA3 },
	0xE0D4, { 0xE9, 0x81, 0xB8 },
	0xE0D5, { 0xE9, 0x8A, 0x91 },
	0xE0D6, { 0xE9, 0x90, 0xA5 },
	0xE0D7, { 0xE9, 0xA5, 0x8D },
	0xE0D8, { 0xE9, 0xAE, 0xAE },
	0xE0D9, { 0xE5, 0x8D, 0xA8 },
	0xE0DA, { 0xE5, 0xB1, 0x91 },
	0xE0DB, { 0xE6, 0xA5, 0x94 },
	0xE0DC, { 0xE6, 0xB3, 0x84 },
	0xE0DD, { 0xE6, 0xB4, 0xA9 },
	0xE0DE, { 0xE6, 0xB8, 0xAB },
	0xE0DF, { 0xE8, 0x88, 0x8C },
	0xE0E0, { 0xE8, 0x96, 0x9B },
	0xE0E1, { 0xE8, 0xA4, 0xBB },
	0xE0E2, { 0xE8, 0xA8, 0xAD },
	0xE0E3, { 0xE8, 0xAA, 0xAA },
	0xE0E4, { 0xE9, 0x9B, 0xAA },
	0xE0E5, { 0xE9, 0xBD, 0xA7 },
	0xE0E6, { 0xE5, 0x89, 0xA1 },
	0xE0E7, { 0xE6, 0x9A, 0xB9 },
	0xE0E8, { 0xE6, 0xAE, 0xB2 },
	0xE0E9, { 0xE7, 0xBA, 0x96 },
	0xE0EA, { 0xE8, 0x9F, 0xBE },
	0xE0EB, { 0xE8, 0xB4, 0x8D },
	0xE0EC, { 0xE9, 0x96, 0x83 },
	0xE0ED, { 0xE9, 0x99, 0x9D },
	0xE0EE, { 0xE6, 0x94, 0x9D },
	0xE0EF, { 0xE6, 0xB6, 0x89 },
	0xE0F0, { 0xE7, 0x87, 0xAE },
	0xE0F1, { 0xEF, 0xA5, 0xAE },
	0xE0F2, { 0xE5, 0x9F, 0x8E },
	0xE0F3, { 0xE5, 0xA7, 0x93 },
	0xE0F4, { 0xE5, 0xAE, 0xAC },
	0xE0F5, { 0xE6, 0x80, 0xA7 },
	0xE0F6, { 0xE6, 0x83, 0xBA },
	0xE0F7, { 0xE6, 0x88, 0x90 },
	0xE0F8, { 0xE6, 0x98, 0x9F },
	0xE0F9, { 0xE6, 0x99, 0x9F },
	0xE0FA, { 0xE7, 0x8C, 0xA9 },
	0xE0FB, { 0xE7, 0x8F, 0xB9 },
	0xE0FC, { 0xE7, 0x9B, 0x9B },
	0xE0FD, { 0xE7, 0x9C, 0x81 },
	0xE0FE, { 0xE7, 0xAD, 0xAC },
	0xE1A1, { 0xE8, 0x81, 0x96 },
	0xE1A2, { 0xE8, 0x81, 0xB2 },
	0xE1A3, { 0xE8, 0x85, 0xA5 },
	0xE1A4, { 0xE8, 0xAA, 0xA0 },
	0xE1A5, { 0xE9, 0x86, 0x92 },
	0xE1A6, { 0xE4, 0xB8, 0x96 },
	0xE1A7, { 0xE5, 0x8B, 0xA2 },
	0xE1A8, { 0xE6, 0xAD, 0xB2 },
	0xE1A9, { 0xE6, 0xB4, 0x97 },
	0xE1AA, { 0xE7, 0xA8, 0x85 },
	0xE1AB, { 0xE7, 0xAC, 0xB9 },
	0xE1AC, { 0xE7, 0xB4, 0xB0 },
	0xE1AD, { 0xEF, 0xA5, 0xAF },
	0xE1AE, { 0xE8, 0xB2, 0xB0 },
	0xE1AF, { 0xE5, 0x8F, 0xAC },
	0xE1B0, { 0xE5, 0x98, 0xAF },
	0xE1B1, { 0xE5, 0xA1, 0x91 },
	0xE1B2, { 0xE5, 0xAE, 0xB5 },
	0xE1B3, { 0xE5, 0xB0, 0x8F },
	0xE1B4, { 0xE5, 0xB0, 0x91 },
	0xE1B5, { 0xE5, 0xB7, 0xA2 },
	0xE1B6, { 0xE6, 0x89, 0x80 },
	0xE1B7, { 0xE6, 0x8E, 0x83 },
	0xE1B8, { 0xE6, 0x90, 0x94 },
	0xE1B9, { 0xE6, 0x98, 0xAD },
	0xE1BA, { 0xE6, 0xA2, 0xB3 },
	0xE1BB, { 0xE6, 0xB2, 0xBC },
	0xE1BC, { 0xE6, 0xB6, 0x88 },
	0xE1BD, { 0xE6, 0xBA, 0xAF },
	0xE1BE, { 0xE7, 0x80, 0x9F },
	0xE1BF, { 0xE7, 0x82, 0xA4 },
	0xE1C0, { 0xE7, 0x87, 0x92 },
	0xE1C1, { 0xE7, 0x94, 0xA6 },
	0xE1C2, { 0xE7, 0x96, 0x8F },
	0xE1C3, { 0xE7, 0x96, 0x8E },
	0xE1C4, { 0xE7, 0x98, 0x99 },
	0xE1C5, { 0xE7, 0xAC, 0x91 },
	0xE1C6, { 0xE7, 0xAF, 0xA0 },
	0xE1C7, { 0xE7, 0xB0, 0xAB },
	0xE1C8, { 0xE7, 0xB4, 0xA0 },
	0xE1C9, { 0xE7, 0xB4, 0xB9 },
	0xE1CA, { 0xE8, 0x94, 0xAC },
	0xE1CB, { 0xE8, 0x95, 0xAD },
	0xE1CC, { 0xE8, 0x98, 0x87 },
	0xE1CD, { 0xE8, 0xA8, 0xB4 },
	0xE1CE, { 0xE9, 0x80, 0x8D },
	0xE1CF, { 0xE9, 0x81, 0xA1 },
	0xE1D0, { 0xE9, 0x82, 0xB5 },
	0xE1D1, { 0xE9, 0x8A, 0xB7 },
	0xE1D2, { 0xE9, 0x9F, 0xB6 },
	0xE1D3, { 0xE9, 0xA8, 0xB7 },
	0xE1D4, { 0xE4, 0xBF, 0x97 },
	0xE1D5, { 0xE5, 0xB1, 0xAC },
	0xE1D6, { 0xE6, 0x9D, 0x9F },
	0xE1D7, { 0xE6, 0xB6, 0x91 },
	0xE1D8, { 0xE7, 0xB2, 0x9F },
	0xE1D9, { 0xE7, 0xBA, 0x8C },
	0xE1DA, { 0xE8, 0xAC, 0x96 },
	0xE1DB, { 0xE8, 0xB4, 0x96 },
	0xE1DC, { 0xE9, 0x80, 0x9F },
	0xE1DD, { 0xE5, 0xAD, 0xAB },
	0xE1DE, { 0xE5, 0xB7, 0xBD },
	0xE1DF, { 0xE6, 0x90, 0x8D },
	0xE1E0, { 0xE8, 0x93, 0x80 },
	0xE1E1, { 0xE9, 0x81, 0x9C },
	0xE1E2, { 0xE9, 0xA3, 0xA1 },
	0xE1E3, { 0xE7, 0x8E, 0x87 },
	0xE1E4, { 0xE5, 0xAE, 0x8B },
	0xE1E5, { 0xE6, 0x82, 0x9A },
	0xE1E6, { 0xE6, 0x9D, 0xBE },
	0xE1E7, { 0xE6, 0xB7, 0x9E },
	0xE1E8, { 0xE8, 0xA8, 0x9F },
	0xE1E9, { 0xE8, 0xAA, 0xA6 },
	0xE1EA, { 0xE9, 0x80, 0x81 },
	0xE1EB, { 0xE9, 0xA0, 0x8C },
	0xE1EC, { 0xE5, 0x88, 0xB7 },
	0xE1ED, { 0xEF, 0xA5, 0xB0 },
	0xE1EE, { 0xE7, 0x81, 0x91 },
	0xE1EF, { 0xE7, 0xA2, 0x8E },
	0xE1F0, { 0xE9, 0x8E, 0x96 },
	0xE1F1, { 0xE8, 0xA1, 0xB0 },
	0xE1F2, { 0xE9, 0x87, 0x97 },
	0xE1F3, { 0xE4, 0xBF, 0xAE },
	0xE1F4, { 0xE5, 0x8F, 0x97 },
	0xE1F5, { 0xE5, 0x97, 0xBD },
	0xE1F6, { 0xE5, 0x9B, 0x9A },
	0xE1F7, { 0xE5, 0x9E, 0x82 },
	0xE1F8, { 0xE5, 0xA3, 0xBD },
	0xE1F9, { 0xE5, 0xAB, 0x82 },
	0xE1FA, { 0xE5, 0xAE, 0x88 },
	0xE1FB, { 0xE5, 0xB2, 0xAB },
	0xE1FC, { 0xE5, 0xB3, 0x80 },
	0xE1FD, { 0xE5, 0xB8, 0xA5 },
	0xE1FE, { 0xE6, 0x84, 0x81 },
	0xE2A1, { 0xE6, 0x88, 0x8D },
	0xE2A2, { 0xE6, 0x89, 0x8B },
	0xE2A3, { 0xE6, 0x8E, 0x88 },
	0xE2A4, { 0xE6, 0x90, 0x9C },
	0xE2A5, { 0xE6, 0x94, 0xB6 },
	0xE2A6, { 0xE6, 0x95, 0xB8 },
	0xE2A7, { 0xE6, 0xA8, 0xB9 },
	0xE2A8, { 0xE6, 0xAE, 0x8A },
	0xE2A9, { 0xE6, 0xB0, 0xB4 },
	0xE2AA, { 0xE6, 0xB4, 0x99 },
	0xE2AB, { 0xE6, 0xBC, 0xB1 },
	0xE2AC, { 0xE7, 0x87, 0xA7 },
	0xE2AD, { 0xE7, 0x8B, 0xA9 },
	0xE2AE, { 0xE7, 0x8D, 0xB8 },
	0xE2AF, { 0xE7, 0x90, 0x87 },
	0xE2B0, { 0xE7, 0x92, 0xB2 },
	0xE2B1, { 0xE7, 0x98, 0xA6 },
	0xE2B2, { 0xE7, 0x9D, 0xA1 },
	0xE2B3, { 0xE7, 0xA7, 0x80 },
	0xE2B4, { 0xE7, 0xA9, 0x97 },
	0xE2B5, { 0xE7, 0xAB, 0xAA },
	0xE2B6, { 0xE7, 0xB2, 0xB9 },
	0xE2B7, { 0xE7, 0xB6, 0x8F },
	0xE2B8, { 0xE7, 0xB6, 0xAC },
	0xE2B9, { 0xE7, 0xB9, 0xA1 },
	0xE2BA, { 0xE7, 0xBE, 0x9E },
	0xE2BB, { 0xE8, 0x84, 0xA9 },
	0xE2BC, { 0xE8, 0x8C, 0xB1 },
	0xE2BD, { 0xE8, 0x92, 0x90 },
	0xE2BE, { 0xE8, 0x93, 0x9A },
	0xE2BF, { 0xE8, 0x97, 0xAA },
	0xE2C0, { 0xE8, 0xA2, 0x96 },
	0xE2C1, { 0xE8, 0xAA, 0xB0 },
	0xE2C2, { 0xE8, 0xAE, 0x90 },
	0xE2C3, { 0xE8, 0xBC, 0xB8 },
	0xE2C4, { 0xE9, 0x81, 0x82 },
	0xE2C5, { 0xE9, 0x82, 0x83 },
	0xE2C6, { 0xE9, 0x85, 0xAC },
	0xE2C7, { 0xE9, 0x8A, 0x96 },
	0xE2C8, { 0xE9, 0x8A, 0xB9 },
	0xE2C9, { 0xE9, 0x9A, 0x8B },
	0xE2CA, { 0xE9, 0x9A, 0xA7 },
	0xE2CB, { 0xE9, 0x9A, 0xA8 },
	0xE2CC, { 0xE9, 0x9B, 0x96 },
	0xE2CD, { 0xE9, 0x9C, 0x80 },
	0xE2CE, { 0xE9, 0xA0, 0x88 },
	0xE2CF, { 0xE9, 0xA6, 0x96 },
	0xE2D0, { 0xE9, 0xAB, 0x93 },
	0xE2D1, { 0xE9, 0xAC, 0x9A },
	0xE2D2, { 0xE5, 0x8F, 0x94 },
	0xE2D3, { 0xE5, 0xA1, 0xBE },
	0xE2D4, { 0xE5, 0xA4, 0x99 },
	0xE2D5, { 0xE5, 0xAD, 0xB0 },
	0xE2D6, { 0xE5, 0xAE, 0xBF },
	0xE2D7, { 0xE6, 0xB7, 0x91 },
	0xE2D8, { 0xE6, 0xBD, 0x9A },
	0xE2D9, { 0xE7, 0x86, 0x9F },
	0xE2DA, { 0xE7, 0x90, 0xA1 },
	0xE2DB, { 0xE7, 0x92, 0xB9 },
	0xE2DC, { 0xE8, 0x82, 0x85 },
	0xE2DD, { 0xE8, 0x8F, 0xBD },
	0xE2DE, { 0xE5, 0xB7, 0xA1 },
	0xE2DF, { 0xE5, 0xBE, 0x87 },
	0xE2E0, { 0xE5, 0xBE, 0xAA },
	0xE2E1, { 0xE6, 0x81, 0x82 },
	0xE2E2, { 0xE6, 0x97, 0xAC },
	0xE2E3, { 0xE6, 0xA0, 0x92 },
	0xE2E4, { 0xE6, 0xA5, 0xAF },
	0xE2E5, { 0xE6, 0xA9, 0x93 },
	0xE2E6, { 0xE6, 0xAE, 0x89 },
	0xE2E7, { 0xE6, 0xB4, 0xB5 },
	0xE2E8, { 0xE6, 0xB7, 0xB3 },
	0xE2E9, { 0xE7, 0x8F, 0xA3 },
	0xE2EA, { 0xE7, 0x9B, 0xBE },
	0xE2EB, { 0xE7, 0x9E, 0xAC },
	0xE2EC, { 0xE7, 0xAD, 0x8D },
	0xE2ED, { 0xE7, 0xB4, 0x94 },
	0xE2EE, { 0xE8, 0x84, 0xA3 },
	0xE2EF, { 0xE8, 0x88, 0x9C },
	0xE2F0, { 0xE8, 0x8D, 0x80 },
	0xE2F1, { 0xE8, 0x93, 0xB4 },
	0xE2F2, { 0xE8, 0x95, 0xA3 },
	0xE2F3, { 0xE8, 0xA9, 0xA2 },
	0xE2F4, { 0xE8, 0xAB, 0x84 },
	0xE2F5, { 0xE9, 0x86, 0x87 },
	0xE2F6, { 0xE9, 0x8C, 0x9E },
	0xE2F7, { 0xE9, 0xA0, 0x86 },
	0xE2F8, { 0xE9, 0xA6, 0xB4 },
	0xE2F9, { 0xE6, 0x88, 0x8C },
	0xE2FA, { 0xE8, 0xA1, 0x93 },
	0xE2FB, { 0xE8, 0xBF, 0xB0 },
	0xE2FC, { 0xE9, 0x89, 0xA5 },
	0xE2FD, { 0xE5, 0xB4, 0x87 },
	0xE2FE, { 0xE5, 0xB4, 0xA7 },
	0xE3A1, { 0xE5, 0xB5, 0xA9 },
	0xE3A2, { 0xE7, 0x91, 0x9F },
	0xE3A3, { 0xE8, 0x86, 0x9D },
	0xE3A4, { 0xE8, 0x9D, 0xA8 },
	0xE3A5, { 0xE6, 0xBF, 0x95 },
	0xE3A6, { 0xE6, 0x8B, 0xBE },
	0xE3A7, { 0xE7, 0xBF, 0x92 },
	0xE3A8, { 0xE8, 0xA4, 0xB6 },
	0xE3A9, { 0xE8, 0xA5, 0xB2 },
	0xE3AA, { 0xE4, 0xB8, 0x9E },
	0xE3AB, { 0xE4, 0xB9, 0x98 },
	0xE3AC, { 0xE5, 0x83, 0xA7 },
	0xE3AD, { 0xE5, 0x8B, 0x9D },
	0xE3AE, { 0xE5, 0x8D, 0x87 },
	0xE3AF, { 0xE6, 0x89, 0xBF },
	0xE3B0, { 0xE6, 0x98, 0x87 },
	0xE3B1, { 0xE7, 0xB9, 0xA9 },
	0xE3B2, { 0xE8, 0xA0, 0x85 },
	0xE3B3, { 0xE9, 0x99, 0x9E },
	0xE3B4, { 0xE4, 0xBE, 0x8D },
	0xE3B5, { 0xE5, 0x8C, 0x99 },
	0xE3B6, { 0xE5, 0x98, 0xB6 },
	0xE3B7, { 0xE5, 0xA7, 0x8B },
	0xE3B8, { 0xE5, 0xAA, 0xA4 },
	0xE3B9, { 0xE5, 0xB0, 0xB8 },
	0xE3BA, { 0xE5, 0xB1, 0x8E },
	0xE3BB, { 0xE5, 0xB1, 0x8D },
	0xE3BC, { 0xE5, 0xB8, 0x82 },
	0xE3BD, { 0xE5, 0xBC, 0x91 },
	0xE3BE, { 0xE6, 0x81, 0x83 },
	0xE3BF, { 0xE6, 0x96, 0xBD },
	0xE3C0, { 0xE6, 0x98, 0xAF },
	0xE3C1, { 0xE6, 0x99, 0x82 },
	0xE3C2, { 0xE6, 0x9E, 0xBE },
	0xE3C3, { 0xE6, 0x9F, 0xB4 },
	0xE3C4, { 0xE7, 0x8C, 0x9C },
	0xE3C5, { 0xE7, 0x9F, 0xA2 },
	0xE3C6, { 0xE7, 0xA4, 0xBA },
	0xE3C7, { 0xE7, 0xBF, 0x85 },
	0xE3C8, { 0xE8, 0x92, 0x94 },
	0xE3C9, { 0xE8, 0x93, 0x8D },
	0xE3CA, { 0xE8, 0xA6, 0x96 },
	0xE3CB, { 0xE8, 0xA9, 0xA6 },
	0xE3CC, { 0xE8, 0xA9, 0xA9 },
	0xE3CD, { 0xE8, 0xAB, 0xA1 },
	0xE3CE, { 0xE8, 0xB1, 0x95 },
	0xE3CF, { 0xE8, 0xB1, 0xBA },
	0xE3D0, { 0xE5, 0x9F, 0xB4 },
	0xE3D1, { 0xE5, 0xAF, 0x94 },
	0xE3D2, { 0xE5, 0xBC, 0x8F },
	0xE3D3, { 0xE6, 0x81, 0xAF },
	0xE3D4, { 0xE6, 0x8B, 0xAD },
	0xE3D5, { 0xE6, 0xA4, 0x8D },
	0xE3D6, { 0xE6, 0xAE, 0x96 },
	0xE3D7, { 0xE6, 0xB9, 0x9C },
	0xE3D8, { 0xE7, 0x86, 0x84 },
	0xE3D9, { 0xE7, 0xAF, 0x92 },
	0xE3DA, { 0xE8, 0x9D, 0x95 },
	0xE3DB, { 0xE8, 0xAD, 0x98 },
	0xE3DC, { 0xE8, 0xBB, 0xBE },
	0xE3DD, { 0xE9, 0xA3, 0x9F },
	0xE3DE, { 0xE9, 0xA3, 0xBE },
	0xE3DF, { 0xE4, 0xBC, 0xB8 },
	0xE3E0, { 0xE4, 0xBE, 0x81 },
	0xE3E1, { 0xE4, 0xBF, 0xA1 },
	0xE3E2, { 0xE5, 0x91, 0xBB },
	0xE3E3, { 0xE5, 0xA8, 0xA0 },
	0xE3E4, { 0xE5, 0xAE, 0xB8 },
	0xE3E5, { 0xE6, 0x84, 0xBC },
	0xE3E6, { 0xE6, 0x96, 0xB0 },
	0xE3E7, { 0xE6, 0x99, 0xA8 },
	0xE3E8, { 0xE7, 0x87, 0xBC },
	0xE3E9, { 0xE7, 0x94, 0xB3 },
	0xE3EA, { 0xE7, 0xA5, 0x9E },
	0xE3EB, { 0xE7, 0xB4, 0xB3 },
	0xE3EC, { 0xE8, 0x85, 0x8E },
	0xE3ED, { 0xE8, 0x87, 0xA3 },
	0xE3EE, { 0xE8, 0x8E, 0x98 },
	0xE3EF, { 0xE8, 0x96, 0xAA },
	0xE3F0, { 0xE8, 0x97, 0x8E },
	0xE3F1, { 0xE8, 0x9C, 0x83 },
	0xE3F2, { 0xE8, 0xA8, 0x8A },
	0xE3F3, { 0xE8, 0xBA, 0xAB },
	0xE3F4, { 0xE8, 0xBE, 0x9B },
	0xE3F5, { 0xEF, 0xA5, 0xB1 },
	0xE3F6, { 0xE8, 0xBF, 0x85 },
	0xE3F7, { 0xE5, 0xA4, 0xB1 },
	0xE3F8, { 0xE5, 0xAE, 0xA4 },
	0xE3F9, { 0xE5, 0xAF, 0xA6 },
	0xE3FA, { 0xE6, 0x82, 0x89 },
	0xE3FB, { 0xE5, 0xAF, 0xA9 },
	0xE3FC, { 0xE5, 0xB0, 0x8B },
	0xE3FD, { 0xE5, 0xBF, 0x83 },
	0xE3FE, { 0xE6, 0xB2, 0x81 },
	0xE4A1, { 0xEF, 0xA5, 0xB2 },
	0xE4A2, { 0xE6, 0xB7, 0xB1 },
	0xE4A3, { 0xE7, 0x80, 0x8B },
	0xE4A4, { 0xE7, 0x94, 0x9A },
	0xE4A5, { 0xE8, 0x8A, 0xAF },
	0xE4A6, { 0xE8, 0xAB, 0xB6 },
	0xE4A7, { 0xE4, 0xBB, 0x80 },
	0xE4A8, { 0xE5, 0x8D, 0x81 },
	0xE4A9, { 0xEF, 0xA5, 0xB3 },
	0xE4AA, { 0xE9, 0x9B, 0x99 },
	0xE4AB, { 0xE6, 0xB0, 0x8F },
	0xE4AC, { 0xE4, 0xBA, 0x9E },
	0xE4AD, { 0xE4, 0xBF, 0x84 },
	0xE4AE, { 0xE5, 0x85, 0x92 },
	0xE4AF, { 0xE5, 0x95, 0x9E },
	0xE4B0, { 0xE5, 0xA8, 0xA5 },
	0xE4B1, { 0xE5, 0xB3, 0xA8 },
	0xE4B2, { 0xE6, 0x88, 0x91 },
	0xE4B3, { 0xE7, 0x89, 0x99 },
	0xE4B4, { 0xE8, 0x8A, 0xBD },
	0xE4B5, { 0xE8, 0x8E, 0xAA },
	0xE4B6, { 0xE8, 0x9B, 0xBE },
	0xE4B7, { 0xE8, 0xA1, 0x99 },
	0xE4B8, { 0xE8, 0xA8, 0x9D },
	0xE4B9, { 0xE9, 0x98, 0xBF },
	0xE4BA, { 0xE9, 0x9B, 0x85 },
	0xE4BB, { 0xE9, 0xA4, 0x93 },
	0xE4BC, { 0xE9, 0xB4, 0x89 },
	0xE4BD, { 0xE9, 0xB5, 0x9D },
	0xE4BE, { 0xE5, 0xA0, 0x8A },
	0xE4BF, { 0xE5, 0xB2, 0xB3 },
	0xE4C0, { 0xE5, 0xB6, 0xBD },
	0xE4C1, { 0xE5, 0xB9, 0x84 },
	0xE4C2, { 0xE6, 0x83, 0xA1 },
	0xE4C3, { 0xE6, 0x84, 0x95 },
	0xE4C4, { 0xE6, 0x8F, 0xA1 },
	0xE4C5, { 0xE6, 0xA8, 0x82 },
	0xE4C6, { 0xE6, 0xB8, 0xA5 },
	0xE4C7, { 0xE9, 0x84, 0x82 },
	0xE4C8, { 0xE9, 0x8D, 0x94 },
	0xE4C9, { 0xE9, 0xA1, 0x8E },
	0xE4CA, { 0xE9, 0xB0, 0x90 },
	0xE4CB, { 0xE9, 0xBD, 0xB7 },
	0xE4CC, { 0xE5, 0xAE, 0x89 },
	0xE4CD, { 0xE5, 0xB2, 0xB8 },
	0xE4CE, { 0xE6, 0x8C, 0x89 },
	0xE4CF, { 0xE6, 0x99, 0x8F },
	0xE4D0, { 0xE6, 0xA1, 0x88 },
	0xE4D1, { 0xE7, 0x9C, 0xBC },
	0xE4D2, { 0xE9, 0x9B, 0x81 },
	0xE4D3, { 0xE9, 0x9E, 0x8D },
	0xE4D4, { 0xE9, 0xA1, 0x94 },
	0xE4D5, { 0xE9, 0xAE, 0x9F },
	0xE4D6, { 0xE6, 0x96, 0xA1 },
	0xE4D7, { 0xE8, 0xAC, 0x81 },
	0xE4D8, { 0xE8, 0xBB, 0x8B },
	0xE4D9, { 0xE9, 0x96, 0xBC },
	0xE4DA, { 0xE5, 0x94, 0xB5 },
	0xE4DB, { 0xE5, 0xB2, 0xA9 },
	0xE4DC, { 0xE5, 0xB7, 0x96 },
	0xE4DD, { 0xE5, 0xBA, 0xB5 },
	0xE4DE, { 0xE6, 0x9A, 0x97 },
	0xE4DF, { 0xE7, 0x99, 0x8C },
	0xE4E0, { 0xE8, 0x8F, 0xB4 },
	0xE4E1, { 0xE9, 0x97, 0x87 },
	0xE4E2, { 0xE5, 0xA3, 0x93 },
	0xE4E3, { 0xE6, 0x8A, 0xBC },
	0xE4E4, { 0xE7, 0x8B, 0x8E },
	0xE4E5, { 0xE9, 0xB4, 0xA8 },
	0xE4E6, { 0xE4, 0xBB, 0xB0 },
	0xE4E7, { 0xE5, 0xA4, 0xAE },
	0xE4E8, { 0xE6, 0x80, 0x8F },
	0xE4E9, { 0xE6, 0x98, 0xBB },
	0xE4EA, { 0xE6, 0xAE, 0x83 },
	0xE4EB, { 0xE7, 0xA7, 0xA7 },
	0xE4EC, { 0xE9, 0xB4, 0xA6 },
	0xE4ED, { 0xE5, 0x8E, 0x93 },
	0xE4EE, { 0xE5, 0x93, 0x80 },
	0xE4EF, { 0xE5, 0x9F, 0x83 },
	0xE4F0, { 0xE5, 0xB4, 0x96 },
	0xE4F1, { 0xE6, 0x84, 0x9B },
	0xE4F2, { 0xE6, 0x9B, 0x96 },
	0xE4F3, { 0xE6, 0xB6, 0xAF },
	0xE4F4, { 0xE7, 0xA2, 0x8D },
	0xE4F5, { 0xE8, 0x89, 0xBE },
	0xE4F6, { 0xE9, 0x9A, 0x98 },
	0xE4F7, { 0xE9, 0x9D, 0x84 },
	0xE4F8, { 0xE5, 0x8E, 0x84 },
	0xE4F9, { 0xE6, 0x89, 0xBC },
	0xE4FA, { 0xE6, 0x8E, 0x96 },
	0xE4FB, { 0xE6, 0xB6, 0xB2 },
	0xE4FC, { 0xE7, 0xB8, 0x8A },
	0xE4FD, { 0xE8, 0x85, 0x8B },
	0xE4FE, { 0xE9, 0xA1, 0x8D },
	0xE5A1, { 0xE6, 0xAB, 0xBB },
	0xE5A2, { 0xE7, 0xBD, 0x8C },
	0xE5A3, { 0xE9, 0xB6, 0xAF },
	0xE5A4, { 0xE9, 0xB8, 0x9A },
	0xE5A5, { 0xE4, 0xB9, 0x9F },
	0xE5A6, { 0xE5, 0x80, 0xBB },
	0xE5A7, { 0xE5, 0x86, 0xB6 },
	0xE5A8, { 0xE5, 0xA4, 0x9C },
	0xE5A9, { 0xE6, 0x83, 0xB9 },
	0xE5AA, { 0xE6, 0x8F, 0xB6 },
	0xE5AB, { 0xE6, 0xA4, 0xB0 },
	0xE5AC, { 0xE7, 0x88, 0xBA },
	0xE5AD, { 0xE8, 0x80, 0xB6 },
	0xE5AE, { 0xEF, 0xA5, 0xB4 },
	0xE5AF, { 0xE9, 0x87, 0x8E },
	0xE5B0, { 0xE5, 0xBC, 0xB1 },
	0xE5B1, { 0xEF, 0xA5, 0xB5 },
	0xE5B2, { 0xEF, 0xA5, 0xB6 },
	0xE5B3, { 0xE7, 0xB4, 0x84 },
	0xE5B4, { 0xE8, 0x8B, 0xA5 },
	0xE5B5, { 0xE8, 0x91, 0xAF },
	0xE5B6, { 0xE8, 0x92, 0xBB },
	0xE5B7, { 0xE8, 0x97, 0xA5 },
	0xE5B8, { 0xE8, 0xBA, 0x8D },
	0xE5B9, { 0xEF, 0xA5, 0xB7 },
	0xE5BA, { 0xE4, 0xBD, 0xAF },
	0xE5BB, { 0xEF, 0xA5, 0xB8 },
	0xE5BC, { 0xEF, 0xA5, 0xB9 },
	0xE5BD, { 0xE5, 0xA3, 0xA4 },
	0xE5BE, { 0xE5, 0xAD, 0x83 },
	0xE5BF, { 0xE6, 0x81, 0x99 },
	0xE5C0, { 0xE6, 0x8F, 0x9A },
	0xE5C1, { 0xE6, 0x94, 0x98 },
	0xE5C2, { 0xE6, 0x95, 0xAD },
	0xE5C3, { 0xE6, 0x9A, 0x98 },
	0xE5C4, { 0xEF, 0xA5, 0xBA },
	0xE5C5, { 0xE6, 0xA5, 0x8A },
	0xE5C6, { 0xE6, 0xA8, 0xA3 },
	0xE5C7, { 0xE6, 0xB4, 0x8B },
	0xE5C8, { 0xE7, 0x80, 0x81 },
	0xE5C9, { 0xE7, 0x85, 0xAC },
	0xE5CA, { 0xE7, 0x97, 0x92 },
	0xE5CB, { 0xE7, 0x98, 0x8D },
	0xE5CC, { 0xE7, 0xA6, 0xB3 },
	0xE5CD, { 0xE7, 0xA9, 0xB0 },
	0xE5CE, { 0xEF, 0xA5, 0xBB },
	0xE5CF, { 0xE7, 0xBE, 0x8A },
	0xE5D0, { 0xEF, 0xA5, 0xBC },
	0xE5D1, { 0xE8, 0xA5, 0x84 },
	0xE5D2, { 0xEF, 0xA5, 0xBD },
	0xE5D3, { 0xE8, 0xAE, 0x93 },
	0xE5D4, { 0xE9, 0x87, 0x80 },
	0xE5D5, { 0xE9, 0x99, 0xBD },
	0xE5D6, { 0xEF, 0xA5, 0xBE },
	0xE5D7, { 0xE9, 0xA4, 0x8A },
	0xE5D8, { 0xE5, 0x9C, 0x84 },
	0xE5D9, { 0xE5, 0xBE, 0xA1 },
	0xE5DA, { 0xE6, 0x96, 0xBC },
	0xE5DB, { 0xE6, 0xBC, 0x81 },
	0xE5DC, { 0xE7, 0x98, 0x80 },
	0xE5DD, { 0xE7, 0xA6, 0xA6 },
	0xE5DE, { 0xE8, 0xAA, 0x9E },
	0xE5DF, { 0xE9, 0xA6, 0xAD },
	0xE5E0, { 0xE9, 0xAD, 0x9A },
	0xE5E1, { 0xE9, 0xBD, 0xAC },
	0xE5E2, { 0xE5, 0x84, 0x84 },
	0xE5E3, { 0xE6, 0x86, 0xB6 },
	0xE5E4, { 0xE6, 0x8A, 0x91 },
	0xE5E5, { 0xE6, 0xAA, 0x8D },
	0xE5E6, { 0xE8, 0x87, 0x86 },
	0xE5E7, { 0xE5, 0x81, 0x83 },
	0xE5E8, { 0xE5, 0xA0, 0xB0 },
	0xE5E9, { 0xE5, 0xBD, 0xA6 },
	0xE5EA, { 0xE7, 0x84, 0x89 },
	0xE5EB, { 0xE8, 0xA8, 0x80 },
	0xE5EC, { 0xE8, 0xAB, 0xBA },
	0xE5ED, { 0xE5, 0xAD, 0xBC },
	0xE5EE, { 0xE8, 0x98, 0x96 },
	0xE5EF, { 0xE4, 0xBF, 0xBA },
	0xE5F0, { 0xE5, 0x84, 0xBC },
	0xE5F1, { 0xE5, 0x9A, 0xB4 },
	0xE5F2, { 0xE5, 0xA5, 0x84 },
	0xE5F3, { 0xE6, 0x8E, 0xA9 },
	0xE5F4, { 0xE6, 0xB7, 0xB9 },
	0xE5F5, { 0xE5, 0xB6, 0xAA },
	0xE5F6, { 0xE6, 0xA5, 0xAD },
	0xE5F7, { 0xE5, 0x86, 0x86 },
	0xE5F8, { 0xE4, 0xBA, 0x88 },
	0xE5F9, { 0xE4, 0xBD, 0x99 },
	0xE5FA, { 0xEF, 0xA5, 0xBF },
	0xE5FB, { 0xEF, 0xA6, 0x80 },
	0xE5FC, { 0xEF, 0xA6, 0x81 },
	0xE5FD, { 0xE5, 0xA6, 0x82 },
	0xE5FE, { 0xEF, 0xA6, 0x82 },
	0xE6A1, { 0xEF, 0xA6, 0x83 },
	0xE6A2, { 0xE6, 0xAD, 0x9F },
	0xE6A3, { 0xE6, 0xB1, 0x9D },
	0xE6A4, { 0xEF, 0xA6, 0x84 },
	0xE6A5, { 0xE7, 0x92, 0xB5 },
	0xE6A6, { 0xE7, 0xA4, 0x96 },
	0xE6A7, { 0xEF, 0xA6, 0x85 },
	0xE6A8, { 0xE8, 0x88, 0x87 },
	0xE6A9, { 0xE8, 0x89, 0x85 },
	0xE6AA, { 0xE8, 0x8C, 0xB9 },
	0xE6AB, { 0xE8, 0xBC, 0xBF },
	0xE6AC, { 0xE8, 0xBD, 0x9D },
	0xE6AD, { 0xEF, 0xA6, 0x86 },
	0xE6AE, { 0xE9, 0xA4, 0x98 },
	0xE6AF, { 0xEF, 0xA6, 0x87 },
	0xE6B0, { 0xEF, 0xA6, 0x88 },
	0xE6B1, { 0xEF, 0xA6, 0x89 },
	0xE6B2, { 0xE4, 0xBA, 0xA6 },
	0xE6B3, { 0xEF, 0xA6, 0x8A },
	0xE6B4, { 0xE5, 0x9F, 0x9F },
	0xE6B5, { 0xE5, 0xBD, 0xB9 },
	0xE6B6, { 0xE6, 0x98, 0x93 },
	0xE6B7, { 0xEF, 0xA6, 0x8B },
	0xE6B8, { 0xEF, 0xA6, 0x8C },
	0xE6B9, { 0xE7, 0x96, 0xAB },
	0xE6BA, { 0xE7, 0xB9, 0xB9 },
	0xE6BB, { 0xE8, 0xAD, 0xAF },
	0xE6BC, { 0xEF, 0xA6, 0x8D },
	0xE6BD, { 0xE9, 0x80, 0x86 },
	0xE6BE, { 0xE9, 0xA9, 0x9B },
	0xE6BF, { 0xE5, 0x9A, 0xA5 },
	0xE6C0, { 0xE5, 0xA0, 0xA7 },
	0xE6C1, { 0xE5, 0xA7, 0xB8 },
	0xE6C2, { 0xE5, 0xA8, 0x9F },
	0xE6C3, { 0xE5, 0xAE, 0xB4 },
	0xE6C4, { 0xEF, 0xA6, 0x8E },
	0xE6C5, { 0xE5, 0xBB, 0xB6 },
	0xE6C6, { 0xEF, 0xA6, 0x8F },
	0xE6C7, { 0xEF, 0xA6, 0x90 },
	0xE6C8, { 0xE6, 0x8D, 0x90 },
	0xE6C9, { 0xE6, 0x8C, 0xBB },
	0xE6CA, { 0xEF, 0xA6, 0x91 },
	0xE6CB, { 0xE6, 0xA4, 0xBD },
	0xE6CC, { 0xE6, 0xB2, 0x87 },
	0xE6CD, { 0xE6, 0xB2, 0xBF },
	0xE6CE, { 0xE6, 0xB6, 0x8E },
	0xE6CF, { 0xE6, 0xB6, 0x93 },
	0xE6D0, { 0xE6, 0xB7, 0xB5 },
	0xE6D1, { 0xE6, 0xBC, 0x94 },
	0xE6D2, { 0xEF, 0xA6, 0x92 },
	0xE6D3, { 0xE7, 0x83, 0x9F },
	0xE6D4, { 0xE7, 0x84, 0xB6 },
	0xE6D5, { 0xE7, 0x85, 0x99 },
	0xE6D6, { 0xEF, 0xA6, 0x93 },
	0xE6D7, { 0xE7, 0x87, 0x83 },
	0xE6D8, { 0xE7, 0x87, 0x95 },
	0xE6D9, { 0xEF, 0xA6, 0x94 },
	0xE6DA, { 0xE7, 0xA1, 0x8F },
	0xE6DB, { 0xE7, 0xA1, 0xAF },
	0xE6DC, { 0xEF, 0xA6, 0x95 },
	0xE6DD, { 0xE7, 0xAD, 0xB5 },
	0xE6DE, { 0xE7, 0xB7, 0xA3 },
	0xE6DF, { 0xEF, 0xA6, 0x96 },
	0xE6E0, { 0xE7, 0xB8, 0xAF },
	0xE6E1, { 0xEF, 0xA6, 0x97 },
	0xE6E2, { 0xE8, 0xA1, 0x8D },
	0xE6E3, { 0xE8, 0xBB, 0x9F },
	0xE6E4, { 0xEF, 0xA6, 0x98 },
	0xE6E5, { 0xEF, 0xA6, 0x99 },
	0xE6E6, { 0xEF, 0xA6, 0x9A },
	0xE6E7, { 0xE9, 0x89, 0x9B },
	0xE6E8, { 0xEF, 0xA6, 0x9B },
	0xE6E9, { 0xE9, 0xB3, 0xB6 },
	0xE6EA, { 0xEF, 0xA6, 0x9C },
	0xE6EB, { 0xEF, 0xA6, 0x9D },
	0xE6EC, { 0xEF, 0xA6, 0x9E },
	0xE6ED, { 0xE6, 0x82, 0x85 },
	0xE6EE, { 0xE6, 0xB6, 0x85 },
	0xE6EF, { 0xEF, 0xA6, 0x9F },
	0xE6F0, { 0xE7, 0x86, 0xB1 },
	0xE6F1, { 0xEF, 0xA6, 0xA0 },
	0xE6F2, { 0xEF, 0xA6, 0xA1 },
	0xE6F3, { 0xE9, 0x96, 0xB1 },
	0xE6F4, { 0xE5, 0x8E, 0xAD },
	0xE6F5, { 0xEF, 0xA6, 0xA2 },
	0xE6F6, { 0xEF, 0xA6, 0xA3 },
	0xE6F7, { 0xEF, 0xA6, 0xA4 },
	0xE6F8, { 0xE6, 0x9F, 0x93 },
	0xE6F9, { 0xEF, 0xA6, 0xA5 },
	0xE6FA, { 0xE7, 0x82, 0x8E },
	0xE6FB, { 0xE7, 0x84, 0xB0 },
	0xE6FC, { 0xE7, 0x90, 0xB0 },
	0xE6FD, { 0xE8, 0x89, 0xB6 },
	0xE6FE, { 0xE8, 0x8B, 0x92 },
	0xE7A1, { 0xEF, 0xA6, 0xA6 },
	0xE7A2, { 0xE9, 0x96, 0xBB },
	0xE7A3, { 0xE9, 0xAB, 0xA5 },
	0xE7A4, { 0xE9, 0xB9, 0xBD },
	0xE7A5, { 0xE6, 0x9B, 0x84 },
	0xE7A6, { 0xEF, 0xA6, 0xA7 },
	0xE7A7, { 0xE7, 0x87, 0x81 },
	0xE7A8, { 0xE8, 0x91, 0x89 },
	0xE7A9, { 0xEF, 0xA6, 0xA8 },
	0xE7AA, { 0xEF, 0xA6, 0xA9 },
	0xE7AB, { 0xE5, 0xA1, 0x8B },
	0xE7AC, { 0xEF, 0xA6, 0xAA },
	0xE7AD, { 0xEF, 0xA6, 0xAB },
	0xE7AE, { 0xE5, 0xB6, 0xB8 },
	0xE7AF, { 0xE5, 0xBD, 0xB1 },
	0xE7B0, { 0xEF, 0xA6, 0xAC },
	0xE7B1, { 0xE6, 0x98, 0xA0 },
	0xE7B2, { 0xE6, 0x9A, 0x8E },
	0xE7B3, { 0xE6, 0xA5, 0xB9 },
	0xE7B4, { 0xE6, 0xA6, 0xAE },
	0xE7B5, { 0xE6, 0xB0, 0xB8 },
	0xE7B6, { 0xE6, 0xB3, 0xB3 },
	0xE7B7, { 0xE6, 0xB8, 0xB6 },
	0xE7B8, { 0xE6, 0xBD, 0x81 },
	0xE7B9, { 0xE6, 0xBF, 0x9A },
	0xE7BA, { 0xE7, 0x80, 0x9B },
	0xE7BB, { 0xE7, 0x80, 0xAF },
	0xE7BC, { 0xE7, 0x85, 0x90 },
	0xE7BD, { 0xE7, 0x87, 0x9F },
	0xE7BE, { 0xE7, 0x8D, 0xB0 },
	0xE7BF, { 0xEF, 0xA6, 0xAD },
	0xE7C0, { 0xE7, 0x91, 0x9B },
	0xE7C1, { 0xEF, 0xA6, 0xAE },
	0xE7C2, { 0xE7, 0x93, 0x94 },
	0xE7C3, { 0xE7, 0x9B, 0x88 },
	0xE7C4, { 0xE7, 0xA9, 0x8E },
	0xE7C5, { 0xE7, 0xBA, 0x93 },
	0xE7C6, { 0xEF, 0xA6, 0xAF },
	0xE7C7, { 0xEF, 0xA6, 0xB0 },
	0xE7C8, { 0xE8, 0x8B, 0xB1 },
	0xE7C9, { 0xE8, 0xA9, 0xA0 },
	0xE7CA, { 0xE8, 0xBF, 0x8E },
	0xE7CB, { 0xEF, 0xA6, 0xB1 },
	0xE7CC, { 0xE9, 0x8D, 0x88 },
	0xE7CD, { 0xEF, 0xA6, 0xB2 },
	0xE7CE, { 0xE9, 0x9C, 0x99 },
	0xE7CF, { 0xEF, 0xA6, 0xB3 },
	0xE7D0, { 0xEF, 0xA6, 0xB4 },
	0xE7D1, { 0xE4, 0xB9, 0x82 },
	0xE7D2, { 0xE5, 0x80, 0xAA },
	0xE7D3, { 0xEF, 0xA6, 0xB5 },
	0xE7D4, { 0xE5, 0x88, 0x88 },
	0xE7D5, { 0xE5, 0x8F, 0xA1 },
	0xE7D6, { 0xE6, 0x9B, 0xB3 },
	0xE7D7, { 0xE6, 0xB1, 0xAD },
	0xE7D8, { 0xE6, 0xBF, 0x8A },
	0xE7D9, { 0xE7, 0x8C, 0x8A },
	0xE7DA, { 0xE7, 0x9D, 0xBF },
	0xE7DB, { 0xE7, 0xA9, 0xA2 },
	0xE7DC, { 0xE8, 0x8A, 0xAE },
	0xE7DD, { 0xE8, 0x97, 0x9D },
	0xE7DE, { 0xE8, 0x98, 0x82 },
	0xE7DF, { 0xEF, 0xA6, 0xB6 },
	0xE7E0, { 0xE8, 0xA3, 0x94 },
	0xE7E1, { 0xE8, 0xA9, 0xA3 },
	0xE7E2, { 0xE8, 0xAD, 0xBD },
	0xE7E3, { 0xE8, 0xB1, 0xAB },
	0xE7E4, { 0xEF, 0xA6, 0xB7 },
	0xE7E5, { 0xE9, 0x8A, 0xB3 },
	0xE7E6, { 0xEF, 0xA6, 0xB8 },
	0xE7E7, { 0xE9, 0x9C, 0x93 },
	0xE7E8, { 0xE9, 0xA0, 0x90 },
	0xE7E9, { 0xE4, 0xBA, 0x94 },
	0xE7EA, { 0xE4, 0xBC, 0x8D },
	0xE7EB, { 0xE4, 0xBF, 0x89 },
	0xE7EC, { 0xE5, 0x82, 0xB2 },
	0xE7ED, { 0xE5, 0x8D, 0x88 },
	0xE7EE, { 0xE5, 0x90, 0xBE },
	0xE7EF, { 0xE5, 0x90, 0xB3 },
	0xE7F0, { 0xE5, 0x97, 0x9A },
	0xE7F1, { 0xE5, 0xA1, 0xA2 },
	0xE7F2, { 0xE5, 0xA2, 0xBA },
	0xE7F3, { 0xE5, 0xA5, 0xA7 },
	0xE7F4, { 0xE5, 0xA8, 0x9B },
	0xE7F5, { 0xE5, 0xAF, 0xA4 },
	0xE7F6, { 0xE6, 0x82, 0x9F },
	0xE7F7, { 0xEF, 0xA6, 0xB9 },
	0xE7F8, { 0xE6, 0x87, 0x8A },
	0xE7F9, { 0xE6, 0x95, 0x96 },
	0xE7FA, { 0xE6, 0x97, 0xBF },
	0xE7FB, { 0xE6, 0x99, 0xA4 },
	0xE7FC, { 0xE6, 0xA2, 0xA7 },
	0xE7FD, { 0xE6, 0xB1, 0x9A },
	0xE7FE, { 0xE6, 0xBE, 0xB3 },
	0xE8A1, { 0xE7, 0x83, 0x8F },
	0xE8A2, { 0xE7, 0x86, 0xAC },
	0xE8A3, { 0xE7, 0x8D, 0x92 },
	0xE8A4, { 0xE7, 0xAD, 0xBD },
	0xE8A5, { 0xE8, 0x9C, 0x88 },
	0xE8A6, { 0xE8, 0xAA, 0xA4 },
	0xE8A7, { 0xE9, 0xB0, 0xB2 },
	0xE8A8, { 0xE9, 0xBC, 0x87 },
	0xE8A9, { 0xE5, 0xB1, 0x8B },
	0xE8AA, { 0xE6, 0xB2, 0x83 },
	0xE8AB, { 0xE7, 0x8D, 0x84 },
	0xE8AC, { 0xE7, 0x8E, 0x89 },
	0xE8AD, { 0xE9, 0x88, 0xBA },
	0xE8AE, { 0xE6, 0xBA, 0xAB },
	0xE8AF, { 0xE7, 0x91, 0xA5 },
	0xE8B0, { 0xE7, 0x98, 0x9F },
	0xE8B1, { 0xE7, 0xA9, 0xA9 },
	0xE8B2, { 0xE7, 0xB8, 0x95 },
	0xE8B3, { 0xE8, 0x98, 0x8A },
	0xE8B4, { 0xE5, 0x85, 0x80 },
	0xE8B5, { 0xE5, 0xA3, 0x85 },
	0xE8B6, { 0xE6, 0x93, 0x81 },
	0xE8B7, { 0xE7, 0x93, 0xAE },
	0xE8B8, { 0xE7, 0x94, 0x95 },
	0xE8B9, { 0xE7, 0x99, 0xB0 },
	0xE8BA, { 0xE7, 0xBF, 0x81 },
	0xE8BB, { 0xE9, 0x82, 0x95 },
	0xE8BC, { 0xE9, 0x9B, 0x8D },
	0xE8BD, { 0xE9, 0xA5, 0x94 },
	0xE8BE, { 0xE6, 0xB8, 0xA6 },
	0xE8BF, { 0xE7, 0x93, 0xA6 },
	0xE8C0, { 0xE7, 0xAA, 0xA9 },
	0xE8C1, { 0xE7, 0xAA, 0xAA },
	0xE8C2, { 0xE8, 0x87, 0xA5 },
	0xE8C3, { 0xE8, 0x9B, 0x99 },
	0xE8C4, { 0xE8, 0x9D, 0xB8 },
	0xE8C5, { 0xE8, 0xA8, 0x9B },
	0xE8C6, { 0xE5, 0xA9, 0x89 },
	0xE8C7, { 0xE5, 0xAE, 0x8C },
	0xE8C8, { 0xE5, 0xAE, 0x9B },
	0xE8C9, { 0xE6, 0xA2, 0xA1 },
	0xE8CA, { 0xE6, 0xA4, 0x80 },
	0xE8CB, { 0xE6, 0xB5, 0xA3 },
	0xE8CC, { 0xE7, 0x8E, 0xA9 },
	0xE8CD, { 0xE7, 0x90, 0x93 },
	0xE8CE, { 0xE7, 0x90, 0xAC },
	0xE8CF, { 0xE7, 0xA2, 0x97 },
	0xE8D0, { 0xE7, 0xB7, 0xA9 },
	0xE8D1, { 0xE7, 0xBF, 0xAB },
	0xE8D2, { 0xE8, 0x84, 0x98 },
	0xE8D3, { 0xE8, 0x85, 0x95 },
	0xE8D4, { 0xE8, 0x8E, 0x9E },
	0xE8D5, { 0xE8, 0xB1, 0x8C },
	0xE8D6, { 0xE9, 0x98, 0xAE },
	0xE8D7, { 0xE9, 0xA0, 0x91 },
	0xE8D8, { 0xE6, 0x9B, 0xB0 },
	0xE8D9, { 0xE5, 0xBE, 0x80 },
	0xE8DA, { 0xE6, 0x97, 0xBA },
	0xE8DB, { 0xE6, 0x9E, 0x89 },
	0xE8DC, { 0xE6, 0xB1, 0xAA },
	0xE8DD, { 0xE7, 0x8E, 0x8B },
	0xE8DE, { 0xE5, 0x80, 0xAD },
	0xE8DF, { 0xE5, 0xA8, 0x83 },
	0xE8E0, { 0xE6, 0xAD, 0xAA },
	0xE8E1, { 0xE7, 0x9F, 0xAE },
	0xE8E2, { 0xE5, 0xA4, 0x96 },
	0xE8E3, { 0xE5, 0xB5, 0xAC },
	0xE8E4, { 0xE5, 0xB7, 0x8D },
	0xE8E5, { 0xE7, 0x8C, 0xA5 },
	0xE8E6, { 0xE7, 0x95, 0x8F },
	0xE8E7, { 0xEF, 0xA6, 0xBA },
	0xE8E8, { 0xEF, 0xA6, 0xBB },
	0xE8E9, { 0xE5, 0x83, 0xA5 },
	0xE8EA, { 0xE5, 0x87, 0xB9 },
	0xE8EB, { 0xE5, 0xA0, 0xAF },
	0xE8EC, { 0xE5, 0xA4, 0xAD },
	0xE8ED, { 0xE5, 0xA6, 0x96 },
	0xE8EE, { 0xE5, 0xA7, 0x9A },
	0xE8EF, { 0xE5, 0xAF, 0xA5 },
	0xE8F0, { 0xEF, 0xA6, 0xBC },
	0xE8F1, { 0xEF, 0xA6, 0xBD },
	0xE8F2, { 0xE5, 0xB6, 0xA2 },
	0xE8F3, { 0xE6, 0x8B, 0x97 },
	0xE8F4, { 0xE6, 0x90, 0x96 },
	0xE8F5, { 0xE6, 0x92, 0x93 },
	0xE8F6, { 0xE6, 0x93, 0xBE },
	0xE8F7, { 0xEF, 0xA6, 0xBE },
	0xE8F8, { 0xE6, 0x9B, 0x9C },
	0xE8F9, { 0xEF, 0xA6, 0xBF },
	0xE8FA, { 0xE6, 0xA9, 0x88 },
	0xE8FB, { 0xEF, 0xA7, 0x80 },
	0xE8FC, { 0xE7, 0x87, 0xBF },
	0xE8FD, { 0xE7, 0x91, 0xA4 },
	0xE8FE, { 0xEF, 0xA7, 0x81 },
	0xE9A1, { 0xE7, 0xAA, 0x88 },
	0xE9A2, { 0xE7, 0xAA, 0xAF },
	0xE9A3, { 0xE7, 0xB9, 0x87 },
	0xE9A4, { 0xE7, 0xB9, 0x9E },
	0xE9A5, { 0xE8, 0x80, 0x80 },
	0xE9A6, { 0xE8, 0x85, 0xB0 },
	0xE9A7, { 0xEF, 0xA7, 0x82 },
	0xE9A8, { 0xE8, 0x9F, 0xAF },
	0xE9A9, { 0xE8, 0xA6, 0x81 },
	0xE9AA, { 0xE8, 0xAC, 0xA0 },
	0xE9AB, { 0xE9, 0x81, 0x99 },
	0xE9AC, { 0xEF, 0xA7, 0x83 },
	0xE9AD, { 0xE9, 0x82, 0x80 },
	0xE9AE, { 0xE9, 0xA5, 0x92 },
	0xE9AF, { 0xE6, 0x85, 0xBE },
	0xE9B0, { 0xE6, 0xAC, 0xB2 },
	0xE9B1, { 0xE6, 0xB5, 0xB4 },
	0xE9B2, { 0xE7, 0xB8, 0x9F },
	0xE9B3, { 0xE8, 0xA4, 0xA5 },
	0xE9B4, { 0xE8, 0xBE, 0xB1 },
	0xE9B5, { 0xE4, 0xBF, 0x91 },
	0xE9B6, { 0xE5, 0x82, 0xAD },
	0xE9B7, { 0xE5, 0x86, 0x97 },
	0xE9B8, { 0xE5, 0x8B, 0x87 },
	0xE9B9, { 0xE5, 0x9F, 0x87 },
	0xE9BA, { 0xE5, 0xA2, 0x89 },
	0xE9BB, { 0xE5, 0xAE, 0xB9 },
	0xE9BC, { 0xE5, 0xBA, 0xB8 },
	0xE9BD, { 0xE6, 0x85, 0x82 },
	0xE9BE, { 0xE6, 0xA6, 0x95 },
	0xE9BF, { 0xE6, 0xB6, 0x8C },
	0xE9C0, { 0xE6, 0xB9, 0xA7 },
	0xE9C1, { 0xE6, 0xBA, 0xB6 },
	0xE9C2, { 0xE7, 0x86, 0x94 },
	0xE9C3, { 0xE7, 0x91, 0xA2 },
	0xE9C4, { 0xE7, 0x94, 0xA8 },
	0xE9C5, { 0xE7, 0x94, 0xAC },
	0xE9C6, { 0xE8, 0x81, 0xB3 },
	0xE9C7, { 0xE8, 0x8C, 0xB8 },
	0xE9C8, { 0xE8, 0x93, 0x89 },
	0xE9C9, { 0xE8, 0xB8, 0x8A },
	0xE9CA, { 0xE9, 0x8E, 0x94 },
	0xE9CB, { 0xE9, 0x8F, 0x9E },
	0xE9CC, { 0xEF, 0xA7, 0x84 },
	0xE9CD, { 0xE4, 0xBA, 0x8E },
	0xE9CE, { 0xE4, 0xBD, 0x91 },
	0xE9CF, { 0xE5, 0x81, 0xB6 },
	0xE9D0, { 0xE5, 0x84, 0xAA },
	0xE9D1, { 0xE5, 0x8F, 0x88 },
	0xE9D2, { 0xE5, 0x8F, 0x8B },
	0xE9D3, { 0xE5, 0x8F, 0xB3 },
	0xE9D4, { 0xE5, 0xAE, 0x87 },
	0xE9D5, { 0xE5, 0xAF, 0x93 },
	0xE9D6, { 0xE5, 0xB0, 0xA4 },
	0xE9D7, { 0xE6, 0x84, 0x9A },
	0xE9D8, { 0xE6, 0x86, 0x82 },
	0xE9D9, { 0xE6, 0x97, 0xB4 },
	0xE9DA, { 0xE7, 0x89, 0x9B },
	0xE9DB, { 0xE7, 0x8E, 0x97 },
	0xE9DC, { 0xE7, 0x91, 0x80 },
	0xE9DD, { 0xE7, 0x9B, 0x82 },
	0xE9DE, { 0xE7, 0xA5, 0x90 },
	0xE9DF, { 0xE7, 0xA6, 0x91 },
	0xE9E0, { 0xE7, 0xA6, 0xB9 },
	0xE9E1, { 0xE7, 0xB4, 0x86 },
	0xE9E2, { 0xE7, 0xBE, 0xBD },
	0xE9E3, { 0xE8, 0x8A, 0x8B },
	0xE9E4, { 0xE8, 0x97, 0x95 },
	0xE9E5, { 0xE8, 0x99, 0x9E },
	0xE9E6, { 0xE8, 0xBF, 0x82 },
	0xE9E7, { 0xE9, 0x81, 0x87 },
	0xE9E8, { 0xE9, 0x83, 0xB5 },
	0xE9E9, { 0xE9, 0x87, 0xAA },
	0xE9EA, { 0xE9, 0x9A, 0x85 },
	0xE9EB, { 0xE9, 0x9B, 0xA8 },
	0xE9EC, { 0xE9, 0x9B, 0xA9 },
	0xE9ED, { 0xE5, 0x8B, 0x96 },
	0xE9EE, { 0xE5, 0xBD, 0xA7 },
	0xE9EF, { 0xE6, 0x97, 0xAD },
	0xE9F0, { 0xE6, 0x98, 0xB1 },
	0xE9F1, { 0xE6, 0xA0, 0xAF },
	0xE9F2, { 0xE7, 0x85, 0x9C },
	0xE9F3, { 0xE7, 0xA8, 0xB6 },
	0xE9F4, { 0xE9, 0x83, 0x81 },
	0xE9F5, { 0xE9, 0xA0, 0x8A },
	0xE9F6, { 0xE4, 0xBA, 0x91 },
	0xE9F7, { 0xEF, 0xA7, 0x85 },
	0xE9F8, { 0xE6, 0xA9, 0x92 },
	0xE9F9, { 0xE6, 0xAE, 0x9E },
	0xE9FA, { 0xE6, 0xBE, 0x90 },
	0xE9FB, { 0xE7, 0x86, 0x89 },
	0xE9FC, { 0xE8, 0x80, 0x98 },
	0xE9FD, { 0xE8, 0x8A, 0xB8 },
	0xE9FE, { 0xE8, 0x95, 0x93 },
	0xEAA1, { 0xE9, 0x81, 0x8B },
	0xEAA2, { 0xE9, 0x9A, 0x95 },
	0xEAA3, { 0xE9, 0x9B, 0xB2 },
	0xEAA4, { 0xE9, 0x9F, 0xBB },
	0xEAA5, { 0xE8, 0x94, 0x9A },
	0xEAA6, { 0xE9, 0xAC, 0xB1 },
	0xEAA7, { 0xE4, 0xBA, 0x90 },
	0xEAA8, { 0xE7, 0x86, 0x8A },
	0xEAA9, { 0xE9, 0x9B, 0x84 },
	0xEAAA, { 0xE5, 0x85, 0x83 },
	0xEAAB, { 0xE5, 0x8E, 0x9F },
	0xEAAC, { 0xE5, 0x93, 0xA1 },
	0xEAAD, { 0xE5, 0x9C, 0x93 },
	0xEAAE, { 0xE5, 0x9C, 0x92 },
	0xEAAF, { 0xE5, 0x9E, 0xA3 },
	0xEAB0, { 0xE5, 0xAA, 0x9B },
	0xEAB1, { 0xE5, 0xAB, 0x84 },
	0xEAB2, { 0xE5, 0xAF, 0x83 },
	0xEAB3, { 0xE6, 0x80, 0xA8 },
	0xEAB4, { 0xE6, 0x84, 0xBF },
	0xEAB5, { 0xE6, 0x8F, 0xB4 },
	0xEAB6, { 0xE6, 0xB2, 0x85 },
	0xEAB7, { 0xE6, 0xB4, 0xB9 },
	0xEAB8, { 0xE6, 0xB9, 0xB2 },
	0xEAB9, { 0xE6, 0xBA, 0x90 },
	0xEABA, { 0xE7, 0x88, 0xB0 },
	0xEABB, { 0xE7, 0x8C, 0xBF },
	0xEABC, { 0xE7, 0x91, 0x97 },
	0xEABD, { 0xE8, 0x8B, 0x91 },
	0xEABE, { 0xE8, 0xA2, 0x81 },
	0xEABF, { 0xE8, 0xBD, 0x85 },
	0xEAC0, { 0xE9, 0x81, 0xA0 },
	0xEAC1, { 0xEF, 0xA7, 0x86 },
	0xEAC2, { 0xE9, 0x99, 0xA2 },
	0xEAC3, { 0xE9, 0xA1, 0x98 },
	0xEAC4, { 0xE9, 0xB4, 0x9B },
	0xEAC5, { 0xE6, 0x9C, 0x88 },
	0xEAC6, { 0xE8, 0xB6, 0x8A },
	0xEAC7, { 0xE9, 0x89, 0x9E },
	0xEAC8, { 0xE4, 0xBD, 0x8D },
	0xEAC9, { 0xE5, 0x81, 0x89 },
	0xEACA, { 0xE5, 0x83, 0x9E },
	0xEACB, { 0xE5, 0x8D, 0xB1 },
	0xEACC, { 0xE5, 0x9C, 0x8D },
	0xEACD, { 0xE5, 0xA7, 0x94 },
	0xEACE, { 0xE5, 0xA8, 0x81 },
	0xEACF, { 0xE5, 0xB0, 0x89 },
	0xEAD0, { 0xE6, 0x85, 0xB0 },
	0xEAD1, { 0xE6, 0x9A, 0x90 },
	0xEAD2, { 0xE6, 0xB8, 0xAD },
	0xEAD3, { 0xE7, 0x88, 0xB2 },
	0xEAD4, { 0xE7, 0x91, 0x8B },
	0xEAD5, { 0xE7, 0xB7, 0xAF },
	0xEAD6, { 0xE8, 0x83, 0x83 },
	0xEAD7, { 0xE8, 0x90, 0x8E },
	0xEAD8, { 0xE8, 0x91, 0xA6 },
	0xEAD9, { 0xE8, 0x94, 0xBF },
	0xEADA, { 0xE8, 0x9D, 0x9F },
	0xEADB, { 0xE8, 0xA1, 0x9B },
	0xEADC, { 0xE8, 0xA4, 0x98 },
	0xEADD, { 0xE8, 0xAC, 0x82 },
	0xEADE, { 0xE9, 0x81, 0x95 },
	0xEADF, { 0xE9, 0x9F, 0x8B },
	0xEAE0, { 0xE9, 0xAD, 0x8F },
	0xEAE1, { 0xE4, 0xB9, 0xB3 },
	0xEAE2, { 0xE4, 0xBE, 0x91 },
	0xEAE3, { 0xE5, 0x84, 0x92 },
	0xEAE4, { 0xE5, 0x85, 0xAA },
	0xEAE5, { 0xEF, 0xA7, 0x87 },
	0xEAE6, { 0xE5, 0x94, 0xAF },
	0xEAE7, { 0xE5, 0x96, 0xA9 },
	0xEAE8, { 0xE5, 0xAD, 0xBA },
	0xEAE9, { 0xE5, 0xAE, 0xA5 },
	0xEAEA, { 0xE5, 0xB9, 0xBC },
	0xEAEB, { 0xE5, 0xB9, 0xBD },
	0xEAEC, { 0xE5, 0xBA, 0xBE },
	0xEAED, { 0xE6, 0x82, 0xA0 },
	0xEAEE, { 0xE6, 0x83, 0x9F },
	0xEAEF, { 0xE6, 0x84, 0x88 },
	0xEAF0, { 0xE6, 0x84, 0x89 },
	0xEAF1, { 0xE6, 0x8F, 0x84 },
	0xEAF2, { 0xE6, 0x94, 0xB8 },
	0xEAF3, { 0xE6, 0x9C, 0x89 },
	0xEAF4, { 0xEF, 0xA7, 0x88 },
	0xEAF5, { 0xE6, 0x9F, 0x94 },
	0xEAF6, { 0xE6, 0x9F, 0x9A },
	0xEAF7, { 0xEF, 0xA7, 0x89 },
	0xEAF8, { 0xE6, 0xA5, 0xA1 },
	0xEAF9, { 0xE6, 0xA5, 0xA2 },
	0xEAFA, { 0xE6, 0xB2, 0xB9 },
	0xEAFB, { 0xE6, 0xB4, 0xA7 },
	0xEAFC, { 0xEF, 0xA7, 0x8A },
	0xEAFD, { 0xE6, 0xB8, 0xB8 },
	0xEAFE, { 0xEF, 0xA7, 0x8B },
	0xEBA1, { 0xE6, 0xBF, 0xA1 },
	0xEBA2, { 0xE7, 0x8C, 0xB6 },
	0xEBA3, { 0xE7, 0x8C, 0xB7 },
	0xEBA4, { 0xEF, 0xA7, 0x8C },
	0xEBA5, { 0xE7, 0x91, 0x9C },
	0xEBA6, { 0xE7, 0x94, 0xB1 },
	0xEBA7, { 0xEF, 0xA7, 0x8D },
	0xEBA8, { 0xE7, 0x99, 0x92 },
	0xEBA9, { 0xEF, 0xA7, 0x8E },
	0xEBAA, { 0xEF, 0xA7, 0x8F },
	0xEBAB, { 0xE7, 0xB6, 0xAD },
	0xEBAC, { 0xE8, 0x87, 0xBE },
	0xEBAD, { 0xE8, 0x90, 0xB8 },
	0xEBAE, { 0xE8, 0xA3, 0x95 },
	0xEBAF, { 0xE8, 0xAA, 0x98 },
	0xEBB0, { 0xE8, 0xAB, 0x9B },
	0xEBB1, { 0xE8, 0xAB, 0xAD },
	0xEBB2, { 0xE8, 0xB8, 0xB0 },
	0xEBB3, { 0xE8, 0xB9, 0x82 },
	0xEBB4, { 0xE9, 0x81, 0x8A },
	0xEBB5, { 0xE9, 0x80, 0xBE },
	0xEBB6, { 0xE9, 0x81, 0xBA },
	0xEBB7, { 0xE9, 0x85, 0x89 },
	0xEBB8, { 0xE9, 0x87, 0x89 },
	0xEBB9, { 0xE9, 0x8D, 0xAE },
	0xEBBA, { 0xEF, 0xA7, 0x90 },
	0xEBBB, { 0xEF, 0xA7, 0x91 },
	0xEBBC, { 0xE5, 0xA0, 0x89 },
	0xEBBD, { 0xEF, 0xA7, 0x92 },
	0xEBBE, { 0xE6, 0xAF, 0x93 },
	0xEBBF, { 0xE8, 0x82, 0x89 },
	0xEBC0, { 0xE8, 0x82, 0xB2 },
	0xEBC1, { 0xEF, 0xA7, 0x93 },
	0xEBC2, { 0xEF, 0xA7, 0x94 },
	0xEBC3, { 0xE5, 0x85, 0x81 },
	0xEBC4, { 0xE5, 0xA5, 0xAB },
	0xEBC5, { 0xE5, 0xB0, 0xB9 },
	0xEBC6, { 0xEF, 0xA7, 0x95 },
	0xEBC7, { 0xEF, 0xA7, 0x96 },
	0xEBC8, { 0xE6, 0xBD, 0xA4 },
	0xEBC9, { 0xE7, 0x8E, 0xA7 },
	0xEBCA, { 0xE8, 0x83, 0xA4 },
	0xEBCB, { 0xE8, 0xB4, 0x87 },
	0xEBCC, { 0xEF, 0xA7, 0x97 },
	0xEBCD, { 0xE9, 0x88, 0x97 },
	0xEBCE, { 0xE9, 0x96, 0x8F },
	0xEBCF, { 0xEF, 0xA7, 0x98 },
	0xEBD0, { 0xEF, 0xA7, 0x99 },
	0xEBD1, { 0xEF, 0xA7, 0x9A },
	0xEBD2, { 0xEF, 0xA7, 0x9B },
	0xEBD3, { 0xE8, 0x81, 0xBF },
	0xEBD4, { 0xE6, 0x88, 0x8E },
	0xEBD5, { 0xE7, 0x80, 0x9C },
	0xEBD6, { 0xE7, 0xB5, 0xA8 },
	0xEBD7, { 0xE8, 0x9E, 0x8D },
	0xEBD8, { 0xEF, 0xA7, 0x9C },
	0xEBD9, { 0xE5, 0x9E, 0xA0 },
	0xEBDA, { 0xE6, 0x81, 0xA9 },
	0xEBDB, { 0xE6, 0x85, 0x87 },
	0xEBDC, { 0xE6, 0xAE, 0xB7 },
	0xEBDD, { 0xE8, 0xAA, 0xBE },
	0xEBDE, { 0xE9, 0x8A, 0x80 },
	0xEBDF, { 0xE9, 0x9A, 0xB1 },
	0xEBE0, { 0xE4, 0xB9, 0x99 },
	0xEBE1, { 0xE5, 0x90, 0x9F },
	0xEBE2, { 0xE6, 0xB7, 0xAB },
	0xEBE3, { 0xE8, 0x94, 0xAD },
	0xEBE4, { 0xE9, 0x99, 0xB0 },
	0xEBE5, { 0xE9, 0x9F, 0xB3 },
	0xEBE6, { 0xE9, 0xA3, 0xAE },
	0xEBE7, { 0xE6, 0x8F, 0x96 },
	0xEBE8, { 0xE6, 0xB3, 0xA3 },
	0xEBE9, { 0xE9, 0x82, 0x91 },
	0xEBEA, { 0xE5, 0x87, 0x9D },
	0xEBEB, { 0xE6, 0x87, 0x89 },
	0xEBEC, { 0xE8, 0x86, 0xBA },
	0xEBED, { 0xE9, 0xB7, 0xB9 },
	0xEBEE, { 0xE4, 0xBE, 0x9D },
	0xEBEF, { 0xE5, 0x80, 0x9A },
	0xEBF0, { 0xE5, 0x84, 0x80 },
	0xEBF1, { 0xE5, 0xAE, 0x9C },
	0xEBF2, { 0xE6, 0x84, 0x8F },
	0xEBF3, { 0xE6, 0x87, 0xBF },
	0xEBF4, { 0xE6, 0x93, 0xAC },
	0xEBF5, { 0xE6, 0xA4, 0x85 },
	0xEBF6, { 0xE6, 0xAF, 0x85 },
	0xEBF7, { 0xE7, 0x96, 0x91 },
	0xEBF8, { 0xE7, 0x9F, 0xA3 },
	0xEBF9, { 0xE7, 0xBE, 0xA9 },
	0xEBFA, { 0xE8, 0x89, 0xA4 },
	0xEBFB, { 0xE8, 0x96, 0x8F },
	0xEBFC, { 0xE8, 0x9F, 0xBB },
	0xEBFD, { 0xE8, 0xA1, 0xA3 },
	0xEBFE, { 0xE8, 0xAA, 0xBC },
	0xECA1, { 0xE8, 0xAD, 0xB0 },
	0xECA2, { 0xE9, 0x86, 0xAB },
	0xECA3, { 0xE4, 0xBA, 0x8C },
	0xECA4, { 0xE4, 0xBB, 0xA5 },
	0xECA5, { 0xE4, 0xBC, 0x8A },
	0xECA6, { 0xEF, 0xA7, 0x9D },
	0xECA7, { 0xEF, 0xA7, 0x9E },
	0xECA8, { 0xE5, 0xA4, 0xB7 },
	0xECA9, { 0xE5, 0xA7, 0xA8 },
	0xECAA, { 0xEF, 0xA7, 0x9F },
	0xECAB, { 0xE5, 0xB7, 0xB2 },
	0xECAC, { 0xE5, 0xBC, 0x9B },
	0xECAD, { 0xE5, 0xBD, 0x9B },
	0xECAE, { 0xE6, 0x80, 0xA1 },
	0xECAF, { 0xEF, 0xA7, 0xA0 },
	0xECB0, { 0xEF, 0xA7, 0xA1 },
	0xECB1, { 0xEF, 0xA7, 0xA2 },
	0xECB2, { 0xEF, 0xA7, 0xA3 },
	0xECB3, { 0xE7, 0x88, 0xBE },
	0xECB4, { 0xE7, 0x8F, 0xA5 },
	0xECB5, { 0xEF, 0xA7, 0xA4 },
	0xECB6, { 0xE7, 0x95, 0xB0 },
	0xECB7, { 0xE7, 0x97, 0x8D },
	0xECB8, { 0xEF, 0xA7, 0xA5 },
	0xECB9, { 0xE7, 0xA7, 0xBB },
	0xECBA, { 0xEF, 0xA7, 0xA6 },
	0xECBB, { 0xE8, 0x80, 0x8C },
	0xECBC, { 0xE8, 0x80, 0xB3 },
	0xECBD, { 0xE8, 0x82, 0x84 },
	0xECBE, { 0xE8, 0x8B, 0xA1 },
	0xECBF, { 0xE8, 0x8D, 0x91 },
	0xECC0, { 0xEF, 0xA7, 0xA7 },
	0xECC1, { 0xEF, 0xA7, 0xA8 },
	0xECC2, { 0xE8, 0xB2, 0xBD },
	0xECC3, { 0xE8, 0xB2, 0xB3 },
	0xECC4, { 0xE9, 0x82, 0x87 },
	0xECC5, { 0xEF, 0xA7, 0xA9 },
	0xECC6, { 0xEF, 0xA7, 0xAA },
	0xECC7, { 0xE9, 0xA3, 0xB4 },
	0xECC8, { 0xE9, 0xA4, 0x8C },
	0xECC9, { 0xEF, 0xA7, 0xAB },
	0xECCA, { 0xEF, 0xA7, 0xAC },
	0xECCB, { 0xE7, 0x80, 0xB7 },
	0xECCC, { 0xE7, 0x9B, 0x8A },
	0xECCD, { 0xE7, 0xBF, 0x8A },
	0xECCE, { 0xE7, 0xBF, 0x8C },
	0xECCF, { 0xE7, 0xBF, 0xBC },
	0xECD0, { 0xE8, 0xAC, 0x9A },
	0xECD1, { 0xE4, 0xBA, 0xBA },
	0xECD2, { 0xE4, 0xBB, 0x81 },
	0xECD3, { 0xE5, 0x88, 0x83 },
	0xECD4, { 0xE5, 0x8D, 0xB0 },
	0xECD5, { 0xEF, 0xA7, 0xAD },
	0xECD6, { 0xE5, 0x92, 0xBD },
	0xECD7, { 0xE5, 0x9B, 0xA0 },
	0xECD8, { 0xE5, 0xA7, 0xBB },
	0xECD9, { 0xE5, 0xAF, 0x85 },
	0xECDA, { 0xE5, 0xBC, 0x95 },
	0xECDB, { 0xE5, 0xBF, 0x8D },
	0xECDC, { 0xE6, 0xB9, 0xAE },
	0xECDD, { 0xEF, 0xA7, 0xAE },
	0xECDE, { 0xEF, 0xA7, 0xAF },
	0xECDF, { 0xE7, 0xB5, 0xAA },
	0xECE0, { 0xE8, 0x8C, 0xB5 },
	0xECE1, { 0xEF, 0xA7, 0xB0 },
	0xECE2, { 0xE8, 0x9A, 0x93 },
	0xECE3, { 0xE8, 0xAA, 0x8D },
	0xECE4, { 0xEF, 0xA7, 0xB1 },
	0xECE5, { 0xE9, 0x9D, 0xAD },
	0xECE6, { 0xE9, 0x9D, 0xB7 },
	0xECE7, { 0xEF, 0xA7, 0xB2 },
	0xECE8, { 0xEF, 0xA7, 0xB3 },
	0xECE9, { 0xE4, 0xB8, 0x80 },
	0xECEA, { 0xE4, 0xBD, 0x9A },
	0xECEB, { 0xE4, 0xBD, 0xBE },
	0xECEC, { 0xE5, 0xA3, 0xB9 },
	0xECED, { 0xE6, 0x97, 0xA5 },
	0xECEE, { 0xE6, 0xBA, 0xA2 },
	0xECEF, { 0xE9, 0x80, 0xB8 },
	0xECF0, { 0xE9, 0x8E, 0xB0 },
	0xECF1, { 0xE9, 0xA6, 0xB9 },
	0xECF2, { 0xE4, 0xBB, 0xBB },
	0xECF3, { 0xE5, 0xA3, 0xAC },
	0xECF4, { 0xE5, 0xA6, 0x8A },
	0xECF5, { 0xE5, 0xA7, 0x99 },
	0xECF6, { 0xE6, 0x81, 0x81 },
	0xECF7, { 0xEF, 0xA7, 0xB4 },
	0xECF8, { 0xEF, 0xA7, 0xB5 },
	0xECF9, { 0xE7, 0xA8, 0x94 },
	0xECFA, { 0xEF, 0xA7, 0xB6 },
	0xECFB, { 0xE8, 0x8D, 0x8F },
	0xECFC, { 0xE8, 0xB3, 0x83 },
	0xECFD, { 0xE5, 0x85, 0xA5 },
	0xECFE, { 0xE5, 0x8D, 0x84 },
	0xEDA1, { 0xEF, 0xA7, 0xB7 },
	0xEDA2, { 0xEF, 0xA7, 0xB8 },
	0xEDA3, { 0xEF, 0xA7, 0xB9 },
	0xEDA4, { 0xE4, 0xBB, 0x8D },
	0xEDA5, { 0xE5, 0x89, 0xA9 },
	0xEDA6, { 0xE5, 0xAD, 0x95 },
	0xEDA7, { 0xE8, 0x8A, 0xBF },
	0xEDA8, { 0xE4, 0xBB, 0x94 },
	0xEDA9, { 0xE5, 0x88, 0xBA },
	0xEDAA, { 0xE5, 0x92, 0xA8 },
	0xEDAB, { 0xE5, 0xA7, 0x89 },
	0xEDAC, { 0xE5, 0xA7, 0xBF },
	0xEDAD, { 0xE5, 0xAD, 0x90 },
	0xEDAE, { 0xE5, 0xAD, 0x97 },
	0xEDAF, { 0xE5, 0xAD, 0x9C },
	0xEDB0, { 0xE6, 0x81, 0xA3 },
	0xEDB1, { 0xE6, 0x85, 0x88 },
	0xEDB2, { 0xE6, 0xBB, 0x8B },
	0xEDB3, { 0xE7, 0x82, 0x99 },
	0xEDB4, { 0xE7, 0x85, 0xAE },
	0xEDB5, { 0xE7, 0x8E, 0x86 },
	0xEDB6, { 0xE7, 0x93, 0xB7 },
	0xEDB7, { 0xE7, 0x96, 0xB5 },
	0xEDB8, { 0xE7, 0xA3, 0x81 },
	0xEDB9, { 0xE7, 0xB4, 0xAB },
	0xEDBA, { 0xE8, 0x80, 0x85 },
	0xEDBB, { 0xE8, 0x87, 0xAA },
	0xEDBC, { 0xE8, 0x8C, 0xA8 },
	0xEDBD, { 0xE8, 0x94, 0x97 },
	0xEDBE, { 0xE8, 0x97, 0x89 },
	0xEDBF, { 0xE8, 0xAB, 0xAE },
	0xEDC0, { 0xE8, 0xB3, 0x87 },
	0xEDC1, { 0xE9, 0x9B, 0x8C },
	0xEDC2, { 0xE4, 0xBD, 0x9C },
	0xEDC3, { 0xE5, 0x8B, 0xBA },
	0xEDC4, { 0xE5, 0x9A, 0xBC },
	0xEDC5, { 0xE6, 0x96, 0xAB },
	0xEDC6, { 0xE6, 0x98, 0xA8 },
	0xEDC7, { 0xE7, 0x81, 0xBC },
	0xEDC8, { 0xE7, 0x82, 0xB8 },
	0xEDC9, { 0xE7, 0x88, 0xB5 },
	0xEDCA, { 0xE7, 0xB6, 0xBD },
	0xEDCB, { 0xE8, 0x8A, 0x8D },
	0xEDCC, { 0xE9, 0x85, 0x8C },
	0xEDCD, { 0xE9, 0x9B, 0x80 },
	0xEDCE, { 0xE9, 0xB5, 0xB2 },
	0xEDCF, { 0xE5, 0xAD, 0xB1 },
	0xEDD0, { 0xE6, 0xA3, 0xA7 },
	0xEDD1, { 0xE6, 0xAE, 0x98 },
	0xEDD2, { 0xE6, 0xBD, 0xBA },
	0xEDD3, { 0xE7, 0x9B, 0x9E },
	0xEDD4, { 0xE5, 0xB2, 0x91 },
	0xEDD5, { 0xE6, 0x9A, 0xAB },
	0xEDD6, { 0xE6, 0xBD, 0x9B },
	0xEDD7, { 0xE7, 0xAE, 0xB4 },
	0xEDD8, { 0xE7, 0xB0, 0xAA },
	0xEDD9, { 0xE8, 0xA0, 0xB6 },
	0xEDDA, { 0xE9, 0x9B, 0x9C },
	0xEDDB, { 0xE4, 0xB8, 0x88 },
	0xEDDC, { 0xE4, 0xBB, 0x97 },
	0xEDDD, { 0xE5, 0x8C, 0xA0 },
	0xEDDE, { 0xE5, 0xA0, 0xB4 },
	0xEDDF, { 0xE5, 0xA2, 0xBB },
	0xEDE0, { 0xE5, 0xA3, 0xAF },
	0xEDE1, { 0xE5, 0xA5, 0xAC },
	0xEDE2, { 0xE5, 0xB0, 0x87 },
	0xEDE3, { 0xE5, 0xB8, 0xB3 },
	0xEDE4, { 0xE5, 0xBA, 0x84 },
	0xEDE5, { 0xE5, 0xBC, 0xB5 },
	0xEDE6, { 0xE6, 0x8E, 0x8C },
	0xEDE7, { 0xE6, 0x9A, 0xB2 },
	0xEDE8, { 0xE6, 0x9D, 0x96 },
	0xEDE9, { 0xE6, 0xA8, 0x9F },
	0xEDEA, { 0xE6, 0xAA, 0xA3 },
	0xEDEB, { 0xE6, 0xAC, 0x8C },
	0xEDEC, { 0xE6, 0xBC, 0xBF },
	0xEDED, { 0xE7, 0x89, 0x86 },
	0xEDEE, { 0xEF, 0xA7, 0xBA },
	0xEDEF, { 0xE7, 0x8D, 0x90 },
	0xEDF0, { 0xE7, 0x92, 0x8B },
	0xEDF1, { 0xE7, 0xAB, 0xA0 },
	0xEDF2, { 0xE7, 0xB2, 0xA7 },
	0xEDF3, { 0xE8, 0x85, 0xB8 },
	0xEDF4, { 0xE8, 0x87, 0x9F },
	0xEDF5, { 0xE8, 0x87, 0xA7 },
	0xEDF6, { 0xE8, 0x8E, 0x8A },
	0xEDF7, { 0xE8, 0x91, 0xAC },
	0xEDF8, { 0xE8, 0x94, 0xA3 },
	0xEDF9, { 0xE8, 0x96, 0x94 },
	0xEDFA, { 0xE8, 0x97, 0x8F },
	0xEDFB, { 0xE8, 0xA3, 0x9D },
	0xEDFC, { 0xE8, 0xB4, 0x93 },
	0xEDFD, { 0xE9, 0x86, 0xAC },
	0xEDFE, { 0xE9, 0x95, 0xB7 },
	0xEEA1, { 0xE9, 0x9A, 0x9C },
	0xEEA2, { 0xE5, 0x86, 0x8D },
	0xEEA3, { 0xE5, 0x93, 0x89 },
	0xEEA4, { 0xE5, 0x9C, 0xA8 },
	0xEEA5, { 0xE5, 0xAE, 0xB0 },
	0xEEA6, { 0xE6, 0x89, 0x8D },
	0xEEA7, { 0xE6, 0x9D, 0x90 },
	0xEEA8, { 0xE6, 0xA0, 0xBD },
	0xEEA9, { 0xE6, 0xA2, 0x93 },
	0xEEAA, { 0xE6, 0xB8, 0xBD },
	0xEEAB, { 0xE6, 0xBB, 0x93 },
	0xEEAC, { 0xE7, 0x81, 0xBD },
	0xEEAD, { 0xE7, 0xB8, 0xA1 },
	0xEEAE, { 0xE8, 0xA3, 0x81 },
	0xEEAF, { 0xE8, 0xB2, 0xA1 },
	0xEEB0, { 0xE8, 0xBC, 0x89 },
	0xEEB1, { 0xE9, 0xBD, 0x8B },
	0xEEB2, { 0xE9, 0xBD, 0x8E },
	0xEEB3, { 0xE7, 0x88, 0xAD },
	0xEEB4, { 0xE7, 0xAE, 0x8F },
	0xEEB5, { 0xE8, 0xAB, 0x8D },
	0xEEB6, { 0xE9, 0x8C, 0x9A },
	0xEEB7, { 0xE4, 0xBD, 0x87 },
	0xEEB8, { 0xE4, 0xBD, 0x8E },
	0xEEB9, { 0xE5, 0x84, 0xB2 },
	0xEEBA, { 0xE5, 0x92, 0x80 },
	0xEEBB, { 0xE5, 0xA7, 0x90 },
	0xEEBC, { 0xE5, 0xBA, 0x95 },
	0xEEBD, { 0xE6, 0x8A, 0xB5 },
	0xEEBE, { 0xE6, 0x9D, 0xB5 },
	0xEEBF, { 0xE6, 0xA5, 0xAE },
	0xEEC0, { 0xE6, 0xA8, 0x97 },
	0xEEC1, { 0xE6, 0xB2, 0xAE },
	0xEEC2, { 0xE6, 0xB8, 0x9A },
	0xEEC3, { 0xE7, 0x8B, 0x99 },
	0xEEC4, { 0xE7, 0x8C, 0xAA },
	0xEEC5, { 0xE7, 0x96, 0xBD },
	0xEEC6, { 0xE7, 0xAE, 0xB8 },
	0xEEC7, { 0xE7, 0xB4, 0xB5 },
	0xEEC8, { 0xE8, 0x8B, 0xA7 },
	0xEEC9, { 0xE8, 0x8F, 0xB9 },
	0xEECA, { 0xE8, 0x91, 0x97 },
	0xEECB, { 0xE8, 0x97, 0xB7 },
	0xEECC, { 0xE8, 0xA9, 0x9B },
	0xEECD, { 0xE8, 0xB2, 0xAF },
	0xEECE, { 0xE8, 0xBA, 0x87 },
	0xEECF, { 0xE9, 0x80, 0x99 },
	0xEED0, { 0xE9, 0x82, 0xB8 },
	0xEED1, { 0xE9, 0x9B, 0x8E },
	0xEED2, { 0xE9, 0xBD, 0x9F },
	0xEED3, { 0xE5, 0x8B, 0xA3 },
	0xEED4, { 0xE5, 0x90, 0x8A },
	0xEED5, { 0xE5, 0xAB, 0xA1 },
	0xEED6, { 0xE5, 0xAF, 0x82 },
	0xEED7, { 0xE6, 0x91, 0x98 },
	0xEED8, { 0xE6, 0x95, 0xB5 },
	0xEED9, { 0xE6, 0xBB, 0xB4 },
	0xEEDA, { 0xE7, 0x8B, 0x84 },
	0xEEDB, { 0xEF, 0xA7, 0xBB },
	0xEEDC, { 0xE7, 0x9A, 0x84 },
	0xEEDD, { 0xE7, 0xA9, 0x8D },
	0xEEDE, { 0xE7, 0xAC, 0x9B },
	0xEEDF, { 0xE7, 0xB1, 0x8D },
	0xEEE0, { 0xE7, 0xB8, 0xBE },
	0xEEE1, { 0xE7, 0xBF, 0x9F },
	0xEEE2, { 0xE8, 0x8D, 0xBB },
	0xEEE3, { 0xE8, 0xAC, 0xAB },
	0xEEE4, { 0xE8, 0xB3, 0x8A },
	0xEEE5, { 0xE8, 0xB5, 0xA4 },
	0xEEE6, { 0xE8, 0xB7, 0xA1 },
	0xEEE7, { 0xE8, 0xB9, 0x9F },
	0xEEE8, { 0xE8, 0xBF, 0xAA },
	0xEEE9, { 0xE8, 0xBF, 0xB9 },
	0xEEEA, { 0xE9, 0x81, 0xA9 },
	0xEEEB, { 0xE9, 0x8F, 0x91 },
	0xEEEC, { 0xE4, 0xBD, 0x83 },
	0xEEED, { 0xE4, 0xBD, 0xBA },
	0xEEEE, { 0xE5, 0x82, 0xB3 },
	0xEEEF, { 0xE5, 0x85, 0xA8 },
	0xEEF0, { 0xE5, 0x85, 0xB8 },
	0xEEF1, { 0xE5, 0x89, 0x8D },
	0xEEF2, { 0xE5, 0x89, 0xAA },
	0xEEF3, { 0xE5, 0xA1, 0xA1 },
	0xEEF4, { 0xE5, 0xA1, 0xBC },
	0xEEF5, { 0xE5, 0xA5, 0xA0 },
	0xEEF6, { 0xE5, 0xB0, 0x88 },
	0xEEF7, { 0xE5, 0xB1, 0x95 },
	0xEEF8, { 0xE5, 0xBB, 0x9B },
	0xEEF9, { 0xE6, 0x82, 0x9B },
	0xEEFA, { 0xE6, 0x88, 0xB0 },
	0xEEFB, { 0xE6, 0xA0, 0x93 },
	0xEEFC, { 0xE6, 0xAE, 0xBF },
	0xEEFD, { 0xE6, 0xB0, 0x88 },
	0xEEFE, { 0xE6, 0xBE, 0xB1 },
	0xEFA1, { 0xE7, 0x85, 0x8E },
	0xEFA2, { 0xE7, 0x90, 0xA0 },
	0xEFA3, { 0xE7, 0x94, 0xB0 },
	0xEFA4, { 0xE7, 0x94, 0xB8 },
	0xEFA5, { 0xE7, 0x95, 0x91 },
	0xEFA6, { 0xE7, 0x99, 0xB2 },
	0xEFA7, { 0xE7, 0xAD, 0x8C },
	0xEFA8, { 0xE7, 0xAE, 0x8B },
	0xEFA9, { 0xE7, 0xAE, 0xAD },
	0xEFAA, { 0xE7, 0xAF, 0x86 },
	0xEFAB, { 0xE7, 0xBA, 0x8F },
	0xEFAC, { 0xE8, 0xA9, 0xAE },
	0xEFAD, { 0xE8, 0xBC, 0xBE },
	0xEFAE, { 0xE8, 0xBD, 0x89 },
	0xEFAF, { 0xE9, 0x88, 0xBF },
	0xEFB0, { 0xE9, 0x8A, 0x93 },
	0xEFB1, { 0xE9, 0x8C, 0xA2 },
	0xEFB2, { 0xE9, 0x90, 0xAB },
	0xEFB3, { 0xE9, 0x9B, 0xBB },
	0xEFB4, { 0xE9, 0xA1, 0x9A },
	0xEFB5, { 0xE9, 0xA1, 0xAB },
	0xEFB6, { 0xE9, 0xA4, 0x9E },
	0xEFB7, { 0xE5, 0x88, 0x87 },
	0xEFB8, { 0xE6, 0x88, 0xAA },
	0xEFB9, { 0xE6, 0x8A, 0x98 },
	0xEFBA, { 0xE6, 0xB5, 0x99 },
	0xEFBB, { 0xE7, 0x99, 0xA4 },
	0xEFBC, { 0xE7, 0xAB, 0x8A },
	0xEFBD, { 0xE7, 0xAF, 0x80 },
	0xEFBE, { 0xE7, 0xB5, 0xB6 },
	0xEFBF, { 0xE5, 0x8D, 0xA0 },
	0xEFC0, { 0xE5, 0xB2, 0xBE },
	0xEFC1, { 0xE5, 0xBA, 0x97 },
	0xEFC2, { 0xE6, 0xBC, 0xB8 },
	0xEFC3, { 0xE7, 0x82, 0xB9 },
	0xEFC4, { 0xE7, 0xB2, 0x98 },
	0xEFC5, { 0xE9, 0x9C, 0x91 },
	0xEFC6, { 0xE9, 0xAE, 0x8E },
	0xEFC7, { 0xE9, 0xBB, 0x9E },
	0xEFC8, { 0xE6, 0x8E, 0xA5 },
	0xEFC9, { 0xE6, 0x91, 0xBA },
	0xEFCA, { 0xE8, 0x9D, 0xB6 },
	0xEFCB, { 0xE4, 0xB8, 0x81 },
	0xEFCC, { 0xE4, 0xBA, 0x95 },
	0xEFCD, { 0xE4, 0xBA, 0xAD },
	0xEFCE, { 0xE5, 0x81, 0x9C },
	0xEFCF, { 0xE5, 0x81, 0xB5 },
	0xEFD0, { 0xE5, 0x91, 0x88 },
	0xEFD1, { 0xE5, 0xA7, 0x83 },
	0xEFD2, { 0xE5, 0xAE, 0x9A },
	0xEFD3, { 0xE5, 0xB9, 0x80 },
	0xEFD4, { 0xE5, 0xBA, 0xAD },
	0xEFD5, { 0xE5, 0xBB, 0xB7 },
	0xEFD6, { 0xE5, 0xBE, 0x81 },
	0xEFD7, { 0xE6, 0x83, 0x85 },
	0xEFD8, { 0xE6, 0x8C, 0xBA },
	0xEFD9, { 0xE6, 0x94, 0xBF },
	0xEFDA, { 0xE6, 0x95, 0xB4 },
	0xEFDB, { 0xE6, 0x97, 0x8C },
	0xEFDC, { 0xE6, 0x99, 0xB6 },
	0xEFDD, { 0xE6, 0x99, 0xB8 },
	0xEFDE, { 0xE6, 0x9F, 0xBE },
	0xEFDF, { 0xE6, 0xA5, 0xA8 },
	0xEFE0, { 0xE6, 0xAA, 0x89 },
	0xEFE1, { 0xE6, 0xAD, 0xA3 },
	0xEFE2, { 0xE6, 0xB1, 0x80 },
	0xEFE3, { 0xE6, 0xB7, 0x80 },
	0xEFE4, { 0xE6, 0xB7, 0xA8 },
	0xEFE5, { 0xE6, 0xB8, 0x9F },
	0xEFE6, { 0xE6, 0xB9, 0x9E },
	0xEFE7, { 0xE7, 0x80, 0x9E },
	0xEFE8, { 0xE7, 0x82, 0xA1 },
	0xEFE9, { 0xE7, 0x8E, 0x8E },
	0xEFEA, { 0xE7, 0x8F, 0xBD },
	0xEFEB, { 0xE7, 0x94, 0xBA },
	0xEFEC, { 0xE7, 0x9D, 0x9B },
	0xEFED, { 0xE7, 0xA2, 0x87 },
	0xEFEE, { 0xE7, 0xA6, 0x8E },
	0xEFEF, { 0xE7, 0xA8, 0x8B },
	0xEFF0, { 0xE7, 0xA9, 0xBD },
	0xEFF1, { 0xE7, 0xB2, 0xBE },
	0xEFF2, { 0xE7, 0xB6, 0x8E },
	0xEFF3, { 0xE8, 0x89, 0x87 },
	0xEFF4, { 0xE8, 0xA8, 0x82 },
	0xEFF5, { 0xE8, 0xAB, 0xAA },
	0xEFF6, { 0xE8, 0xB2, 0x9E },
	0xEFF7, { 0xE9, 0x84, 0xAD },
	0xEFF8, { 0xE9, 0x85, 0x8A },
	0xEFF9, { 0xE9, 0x87, 0x98 },
	0xEFFA, { 0xE9, 0x89, 0xA6 },
	0xEFFB, { 0xE9, 0x8B, 0x8C },
	0xEFFC, { 0xE9, 0x8C, 0xA0 },
	0xEFFD, { 0xE9, 0x9C, 0x86 },
	0xEFFE, { 0xE9, 0x9D, 0x96 },
	0xF0A1, { 0xE9, 0x9D, 0x9C },
	0xF0A2, { 0xE9, 0xA0, 0x82 },
	0xF0A3, { 0xE9, 0xBC, 0x8E },
	0xF0A4, { 0xE5, 0x88, 0xB6 },
	0xF0A5, { 0xE5, 0x8A, 0x91 },
	0xF0A6, { 0xE5, 0x95, 0xBC },
	0xF0A7, { 0xE5, 0xA0, 0xA4 },
	0xF0A8, { 0xE5, 0xB8, 0x9D },
	0xF0A9, { 0xE5, 0xBC, 0x9F },
	0xF0AA, { 0xE6, 0x82, 0x8C },
	0xF0AB, { 0xE6, 0x8F, 0x90 },
	0xF0AC, { 0xE6, 0xA2, 0xAF },
	0xF0AD, { 0xE6, 0xBF, 0x9F },
	0xF0AE, { 0xE7, 0xA5, 0xAD },
	0xF0AF, { 0xE7, 0xAC, 0xAC },
	0xF0B0, { 0xE8, 0x87, 0x8D },
	0xF0B1, { 0xE8, 0x96, 0xBA },
	0xF0B2, { 0xE8, 0xA3, 0xBD },
	0xF0B3, { 0xE8, 0xAB, 0xB8 },
	0xF0B4, { 0xE8, 0xB9, 0x84 },
	0xF0B5, { 0xE9, 0x86, 0x8D },
	0xF0B6, { 0xE9, 0x99, 0xA4 },
	0xF0B7, { 0xE9, 0x9A, 0x9B },
	0xF0B8, { 0xE9, 0x9C, 0xBD },
	0xF0B9, { 0xE9, 0xA1, 0x8C },
	0xF0BA, { 0xE9, 0xBD, 0x8A },
	0xF0BB, { 0xE4, 0xBF, 0x8E },
	0xF0BC, { 0xE5, 0x85, 0x86 },
	0xF0BD, { 0xE5, 0x87, 0x8B },
	0xF0BE, { 0xE5, 0x8A, 0xA9 },
	0xF0BF, { 0xE5, 0x98, 0xB2 },
	0xF0C0, { 0xE5, 0xBC, 0x94 },
	0xF0C1, { 0xE5, 0xBD, 0xAB },
	0xF0C2, { 0xE6, 0x8E, 0xAA },
	0xF0C3, { 0xE6, 0x93, 0x8D },
	0xF0C4, { 0xE6, 0x97, 0xA9 },
	0xF0C5, { 0xE6, 0x99, 0x81 },
	0xF0C6, { 0xE6, 0x9B, 0xBA },
	0xF0C7, { 0xE6, 0x9B, 0xB9 },
	0xF0C8, { 0xE6, 0x9C, 0x9D },
	0xF0C9, { 0xE6, 0xA2, 0x9D },
	0xF0CA, { 0xE6, 0xA3, 0x97 },
	0xF0CB, { 0xE6, 0xA7, 0xBD },
	0xF0CC, { 0xE6, 0xBC, 0x95 },
	0xF0CD, { 0xE6, 0xBD, 0xAE },
	0xF0CE, { 0xE7, 0x85, 0xA7 },
	0xF0CF, { 0xE7, 0x87, 0xA5 },
	0xF0D0, { 0xE7, 0x88, 0xAA },
	0xF0D1, { 0xE7, 0x92, 0xAA },
	0xF0D2, { 0xE7, 0x9C, 0xBA },
	0xF0D3, { 0xE7, 0xA5, 0x96 },
	0xF0D4, { 0xE7, 0xA5, 0x9A },
	0xF0D5, { 0xE7, 0xA7, 0x9F },
	0xF0D6, { 0xE7, 0xA8, 0xA0 },
	0xF0D7, { 0xE7, 0xAA, 0x95 },
	0xF0D8, { 0xE7, 0xB2, 0x97 },
	0xF0D9, { 0xE7, 0xB3, 0x9F },
	0xF0DA, { 0xE7, 0xB5, 0x84 },
	0xF0DB, { 0xE7, 0xB9, 0xB0 },
	0xF0DC, { 0xE8, 0x82, 0x87 },
	0xF0DD, { 0xE8, 0x97, 0xBB },
	0xF0DE, { 0xE8, 0x9A, 0xA4 },
	0xF0DF, { 0xE8, 0xA9, 0x94 },
	0xF0E0, { 0xE8, 0xAA, 0xBF },
	0xF0E1, { 0xE8, 0xB6, 0x99 },
	0xF0E2, { 0xE8, 0xBA, 0x81 },
	0xF0E3, { 0xE9, 0x80, 0xA0 },
	0xF0E4, { 0xE9, 0x81, 0xAD },
	0xF0E5, { 0xE9, 0x87, 0xA3 },
	0xF0E6, { 0xE9, 0x98, 0xBB },
	0xF0E7, { 0xE9, 0x9B, 0x95 },
	0xF0E8, { 0xE9, 0xB3, 0xA5 },
	0xF0E9, { 0xE6, 0x97, 0x8F },
	0xF0EA, { 0xE7, 0xB0, 0x87 },
	0xF0EB, { 0xE8, 0xB6, 0xB3 },
	0xF0EC, { 0xE9, 0x8F, 0x83 },
	0xF0ED, { 0xE5, 0xAD, 0x98 },
	0xF0EE, { 0xE5, 0xB0, 0x8A },
	0xF0EF, { 0xE5, 0x8D, 0x92 },
	0xF0F0, { 0xE6, 0x8B, 0x99 },
	0xF0F1, { 0xE7, 0x8C, 0x9D },
	0xF0F2, { 0xE5, 0x80, 0xA7 },
	0xF0F3, { 0xE5, 0xAE, 0x97 },
	0xF0F4, { 0xE5, 0xBE, 0x9E },
	0xF0F5, { 0xE6, 0x82, 0xB0 },
	0xF0F6, { 0xE6, 0x85, 0xAB },
	0xF0F7, { 0xE6, 0xA3, 0x95 },
	0xF0F8, { 0xE6, 0xB7, 0x99 },
	0xF0F9, { 0xE7, 0x90, 0xAE },
	0xF0FA, { 0xE7, 0xA8, 0xAE },
	0xF0FB, { 0xE7, 0xB5, 0x82 },
	0xF0FC, { 0xE7, 0xB6, 0x9C },
	0xF0FD, { 0xE7, 0xB8, 0xB1 },
	0xF0FE, { 0xE8, 0x85, 0xAB },
	0xF1A1, { 0xE8, 0xB8, 0xAA },
	0xF1A2, { 0xE8, 0xB8, 0xB5 },
	0xF1A3, { 0xE9, 0x8D, 0xBE },
	0xF1A4, { 0xE9, 0x90, 0x98 },
	0xF1A5, { 0xE4, 0xBD, 0x90 },
	0xF1A6, { 0xE5, 0x9D, 0x90 },
	0xF1A7, { 0xE5, 0xB7, 0xA6 },
	0xF1A8, { 0xE5, 0xBA, 0xA7 },
	0xF1A9, { 0xE6, 0x8C, 0xAB },
	0xF1AA, { 0xE7, 0xBD, 0xAA },
	0xF1AB, { 0xE4, 0xB8, 0xBB },
	0xF1AC, { 0xE4, 0xBD, 0x8F },
	0xF1AD, { 0xE4, 0xBE, 0x8F },
	0xF1AE, { 0xE5, 0x81, 0x9A },
	0xF1AF, { 0xE5, 0xA7, 0x9D },
	0xF1B0, { 0xE8, 0x83, 0x84 },
	0xF1B1, { 0xE5, 0x91, 0xAA },
	0xF1B2, { 0xE5, 0x91, 0xA8 },
	0xF1B3, { 0xE5, 0x97, 0xBE },
	0xF1B4, { 0xE5, 0xA5, 0x8F },
	0xF1B5, { 0xE5, 0xAE, 0x99 },
	0xF1B6, { 0xE5, 0xB7, 0x9E },
	0xF1B7, { 0xE5, 0xBB, 0x9A },
	0xF1B8, { 0xE6, 0x99, 0x9D },
	0xF1B9, { 0xE6, 0x9C, 0xB1 },
	0xF1BA, { 0xE6, 0x9F, 0xB1 },
	0xF1BB, { 0xE6, 0xA0, 0xAA },
	0xF1BC, { 0xE6, 0xB3, 0xA8 },
	0xF1BD, { 0xE6, 0xB4, 0xB2 },
	0xF1BE, { 0xE6, 0xB9, 0x8A },
	0xF1BF, { 0xE6, 0xBE, 0x8D },
	0xF1C0, { 0xE7, 0x82, 0xB7 },
	0xF1C1, { 0xE7, 0x8F, 0xA0 },
	0xF1C2, { 0xE7, 0x96, 0x87 },
	0xF1C3, { 0xE7, 0xB1, 0x8C },
	0xF1C4, { 0xE7, 0xB4, 0x82 },
	0xF1C5, { 0xE7, 0xB4, 0xAC },
	0xF1C6, { 0xE7, 0xB6, 0xA2 },
	0xF1C7, { 0xE8, 0x88, 0x9F },
	0xF1C8, { 0xE8, 0x9B, 0x9B },
	0xF1C9, { 0xE8, 0xA8, 0xBB },
	0xF1CA, { 0xE8, 0xAA, 0x85 },
	0xF1CB, { 0xE8, 0xB5, 0xB0 },
	0xF1CC, { 0xE8, 0xBA, 0x8A },
	0xF1CD, { 0xE8, 0xBC, 0xB3 },
	0xF1CE, { 0xE9, 0x80, 0xB1 },
	0xF1CF, { 0xE9, 0x85, 0x8E },
	0xF1D0, { 0xE9, 0x85, 0x92 },
	0xF1D1, { 0xE9, 0x91, 0x84 },
	0xF1D2, { 0xE9, 0xA7, 0x90 },
	0xF1D3, { 0xE7, 0xAB, 0xB9 },
	0xF1D4, { 0xE7, 0xB2, 0xA5 },
	0xF1D5, { 0xE4, 0xBF, 0x8A },
	0xF1D6, { 0xE5, 0x84, 0x81 },
	0xF1D7, { 0xE5, 0x87, 0x86 },
	0xF1D8, { 0xE5, 0x9F, 0x88 },
	0xF1D9, { 0xE5, 0xAF, 0xAF },
	0xF1DA, { 0xE5, 0xB3, 0xBB },
	0xF1DB, { 0xE6, 0x99, 0x99 },
	0xF1DC, { 0xE6, 0xA8, 0xBD },
	0xF1DD, { 0xE6, 0xB5, 0x9A },
	0xF1DE, { 0xE6, 0xBA, 0x96 },
	0xF1DF, { 0xE6, 0xBF, 0xAC },
	0xF1E0, { 0xE7, 0x84, 0x8C },
	0xF1E1, { 0xE7, 0x95, 0xAF },
	0xF1E2, { 0xE7, 0xAB, 0xA3 },
	0xF1E3, { 0xE8, 0xA0, 0xA2 },
	0xF1E4, { 0xE9, 0x80, 0xA1 },
	0xF1E5, { 0xE9, 0x81, 0xB5 },
	0xF1E6, { 0xE9, 0x9B, 0x8B },
	0xF1E7, { 0xE9, 0xA7, 0xBF },
	0xF1E8, { 0xE8, 0x8C, 0x81 },
	0xF1E9, { 0xE4, 0xB8, 0xAD },
	0xF1EA, { 0xE4, 0xBB, 0xB2 },
	0xF1EB, { 0xE8, 0xA1, 0x86 },
	0xF1EC, { 0xE9, 0x87, 0x8D },
	0xF1ED, { 0xE5, 0x8D, 0xBD },
	0xF1EE, { 0xE6, 0xAB, 0x9B },
	0xF1EF, { 0xE6, 0xA5, 0xAB },
	0xF1F0, { 0xE6, 0xB1, 0x81 },
	0xF1F1, { 0xE8, 0x91, 0xBA },
	0xF1F2, { 0xE5, 0xA2, 0x9E },
	0xF1F3, { 0xE6, 0x86, 0x8E },
	0xF1F4, { 0xE6, 0x9B, 0xBE },
	0xF1F5, { 0xE6, 0x8B, 0xAF },
	0xF1F6, { 0xE7, 0x83, 0x9D },
	0xF1F7, { 0xE7, 0x94, 0x91 },
	0xF1F8, { 0xE7, 0x97, 0x87 },
	0xF1F9, { 0xE7, 0xB9, 0x92 },
	0xF1FA, { 0xE8, 0x92, 0xB8 },
	0xF1FB, { 0xE8, 0xAD, 0x89 },
	0xF1FC, { 0xE8, 0xB4, 0x88 },
	0xF1FD, { 0xE4, 0xB9, 0x8B },
	0xF1FE, { 0xE5, 0x8F, 0xAA },
	0xF2A1, { 0xE5, 0x92, 0xAB },
	0xF2A2, { 0xE5, 0x9C, 0xB0 },
	0xF2A3, { 0xE5, 0x9D, 0x80 },
	0xF2A4, { 0xE5, 0xBF, 0x97 },
	0xF2A5, { 0xE6, 0x8C, 0x81 },
	0xF2A6, { 0xE6, 0x8C, 0x87 },
	0xF2A7, { 0xE6, 0x91, 0xAF },
	0xF2A8, { 0xE6, 0x94, 0xAF },
	0xF2A9, { 0xE6, 0x97, 0xA8 },
	0xF2AA, { 0xE6, 0x99, 0xBA },
	0xF2AB, { 0xE6, 0x9E, 0x9D },
	0xF2AC, { 0xE6, 0x9E, 0xB3 },
	0xF2AD, { 0xE6, 0xAD, 0xA2 },
	0xF2AE, { 0xE6, 0xB1, 0xA0 },
	0xF2AF, { 0xE6, 0xB2, 0x9A },
	0xF2B0, { 0xE6, 0xBC, 0xAC },
	0xF2B1, { 0xE7, 0x9F, 0xA5 },
	0xF2B2, { 0xE7, 0xA0, 0xA5 },
	0xF2B3, { 0xE7, 0xA5, 0x89 },
	0xF2B4, { 0xE7, 0xA5, 0x97 },
	0xF2B5, { 0xE7, 0xB4, 0x99 },
	0xF2B6, { 0xE8, 0x82, 0xA2 },
	0xF2B7, { 0xE8, 0x84, 0x82 },
	0xF2B8, { 0xE8, 0x87, 0xB3 },
	0xF2B9, { 0xE8, 0x8A, 0x9D },
	0xF2BA, { 0xE8, 0x8A, 0xB7 },
	0xF2BB, { 0xE8, 0x9C, 0x98 },
	0xF2BC, { 0xE8, 0xAA, 0x8C },
	0xF2BD, { 0xEF, 0xA7, 0xBC },
	0xF2BE, { 0xE8, 0xB4, 0x84 },
	0xF2BF, { 0xE8, 0xB6, 0xBE },
	0xF2C0, { 0xE9, 0x81, 0xB2 },
	0xF2C1, { 0xE7, 0x9B, 0xB4 },
	0xF2C2, { 0xE7, 0xA8, 0x99 },
	0xF2C3, { 0xE7, 0xA8, 0xB7 },
	0xF2C4, { 0xE7, 0xB9, 0x94 },
	0xF2C5, { 0xE8, 0x81, 0xB7 },
	0xF2C6, { 0xE5, 0x94, 0x87 },
	0xF2C7, { 0xE5, 0x97, 0x94 },
	0xF2C8, { 0xE5, 0xA1, 0xB5 },
	0xF2C9, { 0xE6, 0x8C, 0xAF },
	0xF2CA, { 0xE6, 0x90, 0xA2 },
	0xF2CB, { 0xE6, 0x99, 0x89 },
	0xF2CC, { 0xE6, 0x99, 0x8B },
	0xF2CD, { 0xE6, 0xA1, 0xAD },
	0xF2CE, { 0xE6, 0xA6, 0x9B },
	0xF2CF, { 0xE6, 0xAE, 0x84 },
	0xF2D0, { 0xE6, 0xB4, 0xA5 },
	0xF2D1, { 0xE6, 0xBA, 0xB1 },
	0xF2D2, { 0xE7, 0x8F, 0x8D },
	0xF2D3, { 0xE7, 0x91, 0xA8 },
	0xF2D4, { 0xE7, 0x92, 0xA1 },
	0xF2D5, { 0xE7, 0x95, 0x9B },
	0xF2D6, { 0xE7, 0x96, 0xB9 },
	0xF2D7, { 0xE7, 0x9B, 0xA1 },
	0xF2D8, { 0xE7, 0x9C, 0x9E },
	0xF2D9, { 0xE7, 0x9E, 0x8B },
	0xF2DA, { 0xE7, 0xA7, 0xA6 },
	0xF2DB, { 0xE7, 0xB8, 0x89 },
	0xF2DC, { 0xE7, 0xB8, 0x9D },
	0xF2DD, { 0xE8, 0x87, 0xBB },
	0xF2DE, { 0xE8, 0x94, 0xAF },
	0xF2DF, { 0xE8, 0xA2, 0x97 },
	0xF2E0, { 0xE8, 0xA8, 0xBA },
	0xF2E1, { 0xE8, 0xB3, 0x91 },
	0xF2E2, { 0xE8, 0xBB, 0xAB },
	0xF2E3, { 0xE8, 0xBE, 0xB0 },
	0xF2E4, { 0xE9, 0x80, 0xB2 },
	0xF2E5, { 0xE9, 0x8E, 0xAD },
	0xF2E6, { 0xE9, 0x99, 0xA3 },
	0xF2E7, { 0xE9, 0x99, 0xB3 },
	0xF2E8, { 0xE9, 0x9C, 0x87 },
	0xF2E9, { 0xE4, 0xBE, 0x84 },
	0xF2EA, { 0xE5, 0x8F, 0xB1 },
	0xF2EB, { 0xE5, 0xA7, 0xAA },
	0xF2EC, { 0xE5, 0xAB, 0x89 },
	0xF2ED, { 0xE5, 0xB8, 0x99 },
	0xF2EE, { 0xE6, 0xA1, 0x8E },
	0xF2EF, { 0xE7, 0x93, 0x86 },
	0xF2F0, { 0xE7, 0x96, 0xBE },
	0xF2F1, { 0xE7, 0xA7, 0xA9 },
	0xF2F2, { 0xE7, 0xAA, 0x92 },
	0xF2F3, { 0xE8, 0x86, 0xA3 },
	0xF2F4, { 0xE8, 0x9B, 0xAD },
	0xF2F5, { 0xE8, 0xB3, 0xAA },
	0xF2F6, { 0xE8, 0xB7, 0x8C },
	0xF2F7, { 0xE8, 0xBF, 0xAD },
	0xF2F8, { 0xE6, 0x96, 0x9F },
	0xF2F9, { 0xE6, 0x9C, 0x95 },
	0xF2FA, { 0xEF, 0xA7, 0xBD },
	0xF2FB, { 0xE5, 0x9F, 0xB7 },
	0xF2FC, { 0xE6, 0xBD, 0x97 },
	0xF2FD, { 0xE7, 0xB7, 0x9D },
	0xF2FE, { 0xE8, 0xBC, 0xAF },
	0xF3A1, { 0xE9, 0x8F, 0xB6 },
	0xF3A2, { 0xE9, 0x9B, 0x86 },
	0xF3A3, { 0xE5, 0xBE, 0xB5 },
	0xF3A4, { 0xE6, 0x87, 0xB2 },
	0xF3A5, { 0xE6, 0xBE, 0x84 },
	0xF3A6, { 0xE4, 0xB8, 0x94 },
	0xF3A7, { 0xE4, 0xBE, 0x98 },
	0xF3A8, { 0xE5, 0x80, 0x9F },
	0xF3A9, { 0xE5, 0x8F, 0x89 },
	0xF3AA, { 0xE5, 0x97, 0x9F },
	0xF3AB, { 0xE5, 0xB5, 0xAF },
	0xF3AC, { 0xE5, 0xB7, 0xAE },
	0xF3AD, { 0xE6, 0xAC, 0xA1 },
	0xF3AE, { 0xE6, 0xAD, 0xA4 },
	0xF3AF, { 0xE7, 0xA3, 0x8B },
	0xF3B0, { 0xE7, 0xAE, 0x9A },
	0xF3B1, { 0xEF, 0xA7, 0xBE },
	0xF3B2, { 0xE8, 0xB9, 0x89 },
	0xF3B3, { 0xE8, 0xBB, 0x8A },
	0xF3B4, { 0xE9, 0x81, 0xAE },
	0xF3B5, { 0xE6, 0x8D, 0x89 },
	0xF3B6, { 0xE6, 0x90, 0xBE },
	0xF3B7, { 0xE7, 0x9D, 0x80 },
	0xF3B8, { 0xE7, 0xAA, 0x84 },
	0xF3B9, { 0xE9, 0x8C, 0xAF },
	0xF3BA, { 0xE9, 0x91, 0xBF },
	0xF3BB, { 0xE9, 0xBD, 0xAA },
	0xF3BC, { 0xE6, 0x92, 0xB0 },
	0xF3BD, { 0xE6, 0xBE, 0xAF },
	0xF3BE, { 0xE7, 0x87, 0xA6 },
	0xF3BF, { 0xE7, 0x92, 0xA8 },
	0xF3C0, { 0xE7, 0x93, 0x9A },
	0xF3C1, { 0xE7, 0xAB, 0x84 },
	0xF3C2, { 0xE7, 0xB0, 0x92 },
	0xF3C3, { 0xE7, 0xBA, 0x82 },
	0xF3C4, { 0xE7, 0xB2, 0xB2 },
	0xF3C5, { 0xE7, 0xBA, 0x98 },
	0xF3C6, { 0xE8, 0xAE, 0x9A },
	0xF3C7, { 0xE8, 0xB4, 0x8A },
	0xF3C8, { 0xE9, 0x91, 0xBD },
	0xF3C9, { 0xE9, 0xA4, 0x90 },
	0xF3CA, { 0xE9, 0xA5, 0x8C },
	0xF3CB, { 0xE5, 0x88, 0xB9 },
	0xF3CC, { 0xE5, 0xAF, 0x9F },
	0xF3CD, { 0xE6, 0x93, 0xA6 },
	0xF3CE, { 0xE6, 0x9C, 0xAD },
	0xF3CF, { 0xE7, 0xB4, 0xAE },
	0xF3D0, { 0xE5, 0x83, 0xAD },
	0xF3D1, { 0xE5, 0x8F, 0x83 },
	0xF3D2, { 0xE5, 0xA1, 0xB9 },
	0xF3D3, { 0xE6, 0x85, 0x98 },
	0xF3D4, { 0xE6, 0x85, 0x99 },
	0xF3D5, { 0xE6, 0x87, 0xBA },
	0xF3D6, { 0xE6, 0x96, 0xAC },
	0xF3D7, { 0xE7, 0xAB, 0x99 },
	0xF3D8, { 0xE8, 0xAE, 0x92 },
	0xF3D9, { 0xE8, 0xAE, 0x96 },
	0xF3DA, { 0xE5, 0x80, 0x89 },
	0xF3DB, { 0xE5, 0x80, 0xA1 },
	0xF3DC, { 0xE5, 0x89, 0xB5 },
	0xF3DD, { 0xE5, 0x94, 0xB1 },
	0xF3DE, { 0xE5, 0xA8, 0xBC },
	0xF3DF, { 0xE5, 0xBB, 0xA0 },
	0xF3E0, { 0xE5, 0xBD, 0xB0 },
	0xF3E1, { 0xE6, 0x84, 0xB4 },
	0xF3E2, { 0xE6, 0x95, 0x9E },
	0xF3E3, { 0xE6, 0x98, 0x8C },
	0xF3E4, { 0xE6, 0x98, 0xB6 },
	0xF3E5, { 0xE6, 0x9A, 0xA2 },
	0xF3E6, { 0xE6, 0xA7, 0x8D },
	0xF3E7, { 0xE6, 0xBB, 0x84 },
	0xF3E8, { 0xE6, 0xBC, 0xB2 },
	0xF3E9, { 0xE7, 0x8C, 0x96 },
	0xF3EA, { 0xE7, 0x98, 0xA1 },
	0xF3EB, { 0xE7, 0xAA, 0x93 },
	0xF3EC, { 0xE8, 0x84, 0xB9 },
	0xF3ED, { 0xE8, 0x89, 0x99 },
	0xF3EE, { 0xE8, 0x8F, 0x96 },
	0xF3EF, { 0xE8, 0x92, 0xBC },
	0xF3F0, { 0xE5, 0x82, 0xB5 },
	0xF3F1, { 0xE5, 0x9F, 0xB0 },
	0xF3F2, { 0xE5, 0xAF, 0x80 },
	0xF3F3, { 0xE5, 0xAF, 0xA8 },
	0xF3F4, { 0xE5, 0xBD, 0xA9 },
	0xF3F5, { 0xE6, 0x8E, 0xA1 },
	0xF3F6, { 0xE7, 0xA0, 0xA6 },
	0xF3F7, { 0xE7, 0xB6, 0xB5 },
	0xF3F8, { 0xE8, 0x8F, 0x9C },
	0xF3F9, { 0xE8, 0x94, 0xA1 },
	0xF3FA, { 0xE9, 0x87, 0x87 },
	0xF3FB, { 0xE9, 0x87, 0xB5 },
	0xF3FC, { 0xE5, 0x86, 0x8A },
	0xF3FD, { 0xE6, 0x9F, 0xB5 },
	0xF3FE, { 0xE7, 0xAD, 0x96 },
	0xF4A1, { 0xE8, 0xB2, 0xAC },
	0xF4A2, { 0xE5, 0x87, 0x84 },
	0xF4A3, { 0xE5, 0xA6, 0xBB },
	0xF4A4, { 0xE6, 0x82, 0xBD },
	0xF4A5, { 0xE8, 0x99, 0x95 },
	0xF4A6, { 0xE5, 0x80, 0x9C },
	0xF4A7, { 0xEF, 0xA7, 0xBF },
	0xF4A8, { 0xE5, 0x89, 0x94 },
	0xF4A9, { 0xE5, 0xB0, 0xBA },
	0xF4AA, { 0xE6, 0x85, 0xBD },
	0xF4AB, { 0xE6, 0x88, 0x9A },
	0xF4AC, { 0xE6, 0x8B, 0x93 },
	0xF4AD, { 0xE6, 0x93, 0xB2 },
	0xF4AE, { 0xE6, 0x96, 0xA5 },
	0xF4AF, { 0xE6, 0xBB, 0x8C },
	0xF4B0, { 0xE7, 0x98, 0xA0 },
	0xF4B1, { 0xE8, 0x84, 0x8A },
	0xF4B2, { 0xE8, 0xB9, 0xA0 },
	0xF4B3, { 0xE9, 0x99, 0x9F },
	0xF4B4, { 0xE9, 0x9A, 0xBB },
	0xF4B5, { 0xE4, 0xBB, 0x9F },
	0xF4B6, { 0xE5, 0x8D, 0x83 },
	0xF4B7, { 0xE5, 0x96, 0x98 },
	0xF4B8, { 0xE5, 0xA4, 0xA9 },
	0xF4B9, { 0xE5, 0xB7, 0x9D },
	0xF4BA, { 0xE6, 0x93, 0x85 },
	0xF4BB, { 0xE6, 0xB3, 0x89 },
	0xF4BC, { 0xE6, 0xB7, 0xBA },
	0xF4BD, { 0xE7, 0x8E, 0x94 },
	0xF4BE, { 0xE7, 0xA9, 0xBF },
	0xF4BF, { 0xE8, 0x88, 0x9B },
	0xF4C0, { 0xE8, 0x96, 0xA6 },
	0xF4C1, { 0xE8, 0xB3, 0xA4 },
	0xF4C2, { 0xE8, 0xB8, 0x90 },
	0xF4C3, { 0xE9, 0x81, 0xB7 },
	0xF4C4, { 0xE9, 0x87, 0xA7 },
	0xF4C5, { 0xE9, 0x97, 0xA1 },
	0xF4C6, { 0xE9, 0x98, 0xA1 },
	0xF4C7, { 0xE9, 0x9F, 0x86 },
	0xF4C8, { 0xE5, 0x87, 0xB8 },
	0xF4C9, { 0xE5, 0x93, 0xB2 },
	0xF4CA, { 0xE5, 0x96, 0x86 },
	0xF4CB, { 0xE5, 0xBE, 0xB9 },
	0xF4CC, { 0xE6, 0x92, 0xA4 },
	0xF4CD, { 0xE6, 0xBE, 0x88 },
	0xF4CE, { 0xE7, 0xB6, 0xB4 },
	0xF4CF, { 0xE8, 0xBC, 0x9F },
	0xF4D0, { 0xE8, 0xBD, 0x8D },
	0xF4D1, { 0xE9, 0x90, 0xB5 },
	0xF4D2, { 0xE5, 0x83, 0x89 },
	0xF4D3, { 0xE5, 0xB0, 0x96 },
	0xF4D4, { 0xE6, 0xB2, 0xBE },
	0xF4D5, { 0xE6, 0xB7, 0xBB },
	0xF4D6, { 0xE7, 0x94, 0x9B },
	0xF4D7, { 0xE7, 0x9E, 0xBB },
	0xF4D8, { 0xE7, 0xB0, 0xBD },
	0xF4D9, { 0xE7, 0xB1, 0xA4 },
	0xF4DA, { 0xE8, 0xA9, 0xB9 },
	0xF4DB, { 0xE8, 0xAB, 0x82 },
	0xF4DC, { 0xE5, 0xA0, 0x9E },
	0xF4DD, { 0xE5, 0xA6, 0xBE },
	0xF4DE, { 0xE5, 0xB8, 0x96 },
	0xF4DF, { 0xE6, 0x8D, 0xB7 },
	0xF4E0, { 0xE7, 0x89, 0x92 },
	0xF4E1, { 0xE7, 0x96, 0x8A },
	0xF4E2, { 0xE7, 0x9D, 0xAB },
	0xF4E3, { 0xE8, 0xAB, 0x9C },
	0xF4E4, { 0xE8, 0xB2, 0xBC },
	0xF4E5, { 0xE8, 0xBC, 0x92 },
	0xF4E6, { 0xE5, 0xBB, 0xB3 },
	0xF4E7, { 0xE6, 0x99, 0xB4 },
	0xF4E8, { 0xE6, 0xB7, 0xB8 },
	0xF4E9, { 0xE8, 0x81, 0xBD },
	0xF4EA, { 0xE8, 0x8F, 0x81 },
	0xF4EB, { 0xE8, 0xAB, 0x8B },
	0xF4EC, { 0xE9, 0x9D, 0x91 },
	0xF4ED, { 0xE9, 0xAF, 0x96 },
	0xF4EE, { 0xEF, 0xA8, 0x80 },
	0xF4EF, { 0xE5, 0x89, 0x83 },
	0xF4F0, { 0xE6, 0x9B, 0xBF },
	0xF4F1, { 0xE6, 0xB6, 0x95 },
	0xF4F2, { 0xE6, 0xBB, 0xAF },
	0xF4F3, { 0xE7, 0xB7, 0xA0 },
	0xF4F4, { 0xE8, 0xAB, 0xA6 },
	0xF4F5, { 0xE9, 0x80, 0xAE },
	0xF4F6, { 0xE9, 0x81, 0x9E },
	0xF4F7, { 0xE9, 0xAB, 0x94 },
	0xF4F8, { 0xE5, 0x88, 0x9D },
	0xF4F9, { 0xE5, 0x89, 0xBF },
	0xF4FA, { 0xE5, 0x93, 0xA8 },
	0xF4FB, { 0xE6, 0x86, 0x94 },
	0xF4FC, { 0xE6, 0x8A, 0x84 },
	0xF4FD, { 0xE6, 0x8B, 0x9B },
	0xF4FE, { 0xE6, 0xA2, 0xA2 },
	0xF5A1, { 0xE6, 0xA4, 0x92 },
	0xF5A2, { 0xE6, 0xA5, 0x9A },
	0xF5A3, { 0xE6, 0xA8, 0xB5 },
	0xF5A4, { 0xE7, 0x82, 0x92 },
	0xF5A5, { 0xE7, 0x84, 0xA6 },
	0xF5A6, { 0xE7, 0xA1, 0x9D },
	0xF5A7, { 0xE7, 0xA4, 0x81 },
	0xF5A8, { 0xE7, 0xA4, 0x8E },
	0xF5A9, { 0xE7, 0xA7, 0x92 },
	0xF5AA, { 0xE7, 0xA8, 0x8D },
	0xF5AB, { 0xE8, 0x82, 0x96 },
	0xF5AC, { 0xE8, 0x89, 0xB8 },
	0xF5AD, { 0xE8, 0x8B, 0x95 },
	0xF5AE, { 0xE8, 0x8D, 0x89 },
	0xF5AF, { 0xE8, 0x95, 0x89 },
	0xF5B0, { 0xE8, 0xB2, 0x82 },
	0xF5B1, { 0xE8, 0xB6, 0x85 },
	0xF5B2, { 0xE9, 0x85, 0xA2 },
	0xF5B3, { 0xE9, 0x86, 0x8B },
	0xF5B4, { 0xE9, 0x86, 0xAE },
	0xF5B5, { 0xE4, 0xBF, 0x83 },
	0xF5B6, { 0xE5, 0x9B, 0x91 },
	0xF5B7, { 0xE7, 0x87, 0xAD },
	0xF5B8, { 0xE7, 0x9F, 0x97 },
	0xF5B9, { 0xE8, 0x9C, 0x80 },
	0xF5BA, { 0xE8, 0xA7, 0xB8 },
	0xF5BB, { 0xE5, 0xAF, 0xB8 },
	0xF5BC, { 0xE5, 0xBF, 0x96 },
	0xF5BD, { 0xE6, 0x9D, 0x91 },
	0xF5BE, { 0xE9, 0x82, 0xA8 },
	0xF5BF, { 0xE5, 0x8F, 0xA2 },
	0xF5C0, { 0xE5, 0xA1, 0x9A },
	0xF5C1, { 0xE5, 0xAF, 0xB5 },
	0xF5C2, { 0xE6, 0x82, 0xA4 },
	0xF5C3, { 0xE6, 0x86, 0x81 },
	0xF5C4, { 0xE6, 0x91, 0xA0 },
	0xF5C5, { 0xE7, 0xB8, 0xBD },
	0xF5C6, { 0xE8, 0x81, 0xB0 },
	0xF5C7, { 0xE8, 0x94, 0xA5 },
	0xF5C8, { 0xE9, 0x8A, 0x83 },
	0xF5C9, { 0xE6, 0x92, 0xAE },
	0xF5CA, { 0xE5, 0x82, 0xAC },
	0xF5CB, { 0xE5, 0xB4, 0x94 },
	0xF5CC, { 0xE6, 0x9C, 0x80 },
	0xF5CD, { 0xE5, 0xA2, 0x9C },
	0xF5CE, { 0xE6, 0x8A, 0xBD },
	0xF5CF, { 0xE6, 0x8E, 0xA8 },
	0xF5D0, { 0xE6, 0xA4, 0x8E },
	0xF5D1, { 0xE6, 0xA5, 0xB8 },
	0xF5D2, { 0xE6, 0xA8, 0x9E },
	0xF5D3, { 0xE6, 0xB9, 0xAB },
	0xF5D4, { 0xE7, 0x9A, 0xBA },
	0xF5D5, { 0xE7, 0xA7, 0x8B },
	0xF5D6, { 0xE8, 0x8A, 0xBB },
	0xF5D7, { 0xE8, 0x90, 0xA9 },
	0xF5D8, { 0xE8, 0xAB, 0x8F },
	0xF5D9, { 0xE8, 0xB6, 0xA8 },
	0xF5DA, { 0xE8, 0xBF, 0xBD },
	0xF5DB, { 0xE9, 0x84, 0x92 },
	0xF5DC, { 0xE9, 0x85, 0x8B },
	0xF5DD, { 0xE9, 0x86, 0x9C },
	0xF5DE, { 0xE9, 0x8C, 0x90 },
	0xF5DF, { 0xE9, 0x8C, 0x98 },
	0xF5E0, { 0xE9, 0x8E, 0x9A },
	0xF5E1, { 0xE9, 0x9B, 0x9B },
	0xF5E2, { 0xE9, 0xA8, 0xB6 },
	0xF5E3, { 0xE9, 0xB0, 0x8D },
	0xF5E4, { 0xE4, 0xB8, 0x91 },
	0xF5E5, { 0xE7, 0x95, 0x9C },
	0xF5E6, { 0xE7, 0xA5, 0x9D },
	0xF5E7, { 0xE7, 0xAB, 0xBA },
	0xF5E8, { 0xE7, 0xAD, 0x91 },
	0xF5E9, { 0xE7, 0xAF, 0x89 },
	0xF5EA, { 0xE7, 0xB8, 0xAE },
	0xF5EB, { 0xE8, 0x93, 0x84 },
	0xF5EC, { 0xE8, 0xB9, 0x99 },
	0xF5ED, { 0xE8, 0xB9, 0xB4 },
	0xF5EE, { 0xE8, 0xBB, 0xB8 },
	0xF5EF, { 0xE9, 0x80, 0x90 },
	0xF5F0, { 0xE6, 0x98, 0xA5 },
	0xF5F1, { 0xE6, 0xA4, 0xBF },
	0xF5F2, { 0xE7, 0x91, 0x83 },
	0xF5F3, { 0xE5, 0x87, 0xBA },
	0xF5F4, { 0xE6, 0x9C, 0xAE },
	0xF5F5, { 0xE9, 0xBB, 0x9C },
	0xF5F6, { 0xE5, 0x85, 0x85 },
	0xF5F7, { 0xE5, 0xBF, 0xA0 },
	0xF5F8, { 0xE6, 0xB2, 0x96 },
	0xF5F9, { 0xE8, 0x9F, 0xB2 },
	0xF5FA, { 0xE8, 0xA1, 0x9D },
	0xF5FB, { 0xE8, 0xA1, 0xB7 },
	0xF5FC, { 0xE6, 0x82, 0xB4 },
	0xF5FD, { 0xE8, 0x86, 0xB5 },
	0xF5FE, { 0xE8, 0x90, 0x83 },
	0xF6A1, { 0xE8, 0xB4, 0x85 },
	0xF6A2, { 0xE5, 0x8F, 0x96 },
	0xF6A3, { 0xE5, 0x90, 0xB9 },
	0xF6A4, { 0xE5, 0x98, 0xB4 },
	0xF6A5, { 0xE5, 0xA8, 0xB6 },
	0xF6A6, { 0xE5, 0xB0, 0xB1 },
	0xF6A7, { 0xE7, 0x82, 0x8A },
	0xF6A8, { 0xE7, 0xBF, 0xA0 },
	0xF6A9, { 0xE8, 0x81, 0x9A },
	0xF6AA, { 0xE8, 0x84, 0x86 },
	0xF6AB, { 0xE8, 0x87, 0xAD },
	0xF6AC, { 0xE8, 0xB6, 0xA3 },
	0xF6AD, { 0xE9, 0x86, 0x89 },
	0xF6AE, { 0xE9, 0xA9, 0x9F },
	0xF6AF, { 0xE9, 0xB7, 0xB2 },
	0xF6B0, { 0xE5, 0x81, 0xB4 },
	0xF6B1, { 0xE4, 0xBB, 0x84 },
	0xF6B2, { 0xE5, 0x8E, 0xA0 },
	0xF6B3, { 0xE6, 0x83, 0xBB },
	0xF6B4, { 0xE6, 0xB8, 0xAC },
	0xF6B5, { 0xE5, 0xB1, 0xA4 },
	0xF6B6, { 0xE4, 0xBE, 0x88 },
	0xF6B7, { 0xE5, 0x80, 0xA4 },
	0xF6B8, { 0xE5, 0x97, 0xA4 },
	0xF6B9, { 0xE5, 0xB3, 0x99 },
	0xF6BA, { 0xE5, 0xB9, 0x9F },
	0xF6BB, { 0xE6, 0x81, 0xA5 },
	0xF6BC, { 0xE6, 0xA2, 0x94 },
	0xF6BD, { 0xE6, 0xB2, 0xBB },
	0xF6BE, { 0xE6, 0xB7, 0x84 },
	0xF6BF, { 0xE7, 0x86, 0xBE },
	0xF6C0, { 0xE7, 0x97, 0x94 },
	0xF6C1, { 0xE7, 0x97, 0xB4 },
	0xF6C2, { 0xE7, 0x99, 0xA1 },
	0xF6C3, { 0xE7, 0xA8, 0x9A },
	0xF6C4, { 0xE7, 0xA9, 0x89 },
	0xF6C5, { 0xE7, 0xB7, 0x87 },
	0xF6C6, { 0xE7, 0xB7, 0xBB },
	0xF6C7, { 0xE7, 0xBD, 0xAE },
	0xF6C8, { 0xE8, 0x87, 0xB4 },
	0xF6C9, { 0xE8, 0x9A, 0xA9 },
	0xF6CA, { 0xE8, 0xBC, 0x9C },
	0xF6CB, { 0xE9, 0x9B, 0x89 },
	0xF6CC, { 0xE9, 0xA6, 0xB3 },
	0xF6CD, { 0xE9, 0xBD, 0x92 },
	0xF6CE, { 0xE5, 0x89, 0x87 },
	0xF6CF, { 0xE5, 0x8B, 0x85 },
	0xF6D0, { 0xE9, 0xA3, 0xAD },
	0xF6D1, { 0xE8, 0xA6, 0xAA },
	0xF6D2, { 0xE4, 0xB8, 0x83 },
	0xF6D3, { 0xE6, 0x9F, 0x92 },
	0xF6D4, { 0xE6, 0xBC, 0x86 },
	0xF6D5, { 0xE4, 0xBE, 0xB5 },
	0xF6D6, { 0xE5, 0xAF, 0xA2 },
	0xF6D7, { 0xE6, 0x9E, 0x95 },
	0xF6D8, { 0xE6, 0xB2, 0x88 },
	0xF6D9, { 0xE6, 0xB5, 0xB8 },
	0xF6DA, { 0xE7, 0x90, 0x9B },
	0xF6DB, { 0xE7, 0xA0, 0xA7 },
	0xF6DC, { 0xE9, 0x87, 0x9D },
	0xF6DD, { 0xE9, 0x8D, 0xBC },
	0xF6DE, { 0xE8, 0x9F, 0x84 },
	0xF6DF, { 0xE7, 0xA7, 0xA4 },
	0xF6E0, { 0xE7, 0xA8, 0xB1 },
	0xF6E1, { 0xE5, 0xBF, 0xAB },
	0xF6E2, { 0xE4, 0xBB, 0x96 },
	0xF6E3, { 0xE5, 0x92, 0xA4 },
	0xF6E4, { 0xE5, 0x94, 0xBE },
	0xF6E5, { 0xE5, 0xA2, 0xAE },
	0xF6E6, { 0xE5, 0xA6, 0xA5 },
	0xF6E7, { 0xE6, 0x83, 0xB0 },
	0xF6E8, { 0xE6, 0x89, 0x93 },
	0xF6E9, { 0xE6, 0x8B, 0x96 },
	0xF6EA, { 0xE6, 0x9C, 0xB6 },
	0xF6EB, { 0xE6, 0xA5, 0x95 },
	0xF6EC, { 0xE8, 0x88, 0xB5 },
	0xF6ED, { 0xE9, 0x99, 0x80 },
	0xF6EE, { 0xE9, 0xA6, 0xB1 },
	0xF6EF, { 0xE9, 0xA7, 0x9D },
	0xF6F0, { 0xE5, 0x80, 0xAC },
	0xF6F1, { 0xE5, 0x8D, 0x93 },
	0xF6F2, { 0xE5, 0x95, 0x84 },
	0xF6F3, { 0xE5, 0x9D, 0xBC },
	0xF6F4, { 0xEF, 0xA8, 0x81 },
	0xF6F5, { 0xE6, 0x89, 0x98 },
	0xF6F6, { 0xEF, 0xA8, 0x82 },
	0xF6F7, { 0xE6, 0x93, 0xA2 },
	0xF6F8, { 0xE6, 0x99, 0xAB },
	0xF6F9, { 0xE6, 0x9F, 0x9D },
	0xF6FA, { 0xE6, 0xBF, 0x81 },
	0xF6FB, { 0xE6, 0xBF, 0xAF },
	0xF6FC, { 0xE7, 0x90, 0xA2 },
	0xF6FD, { 0xE7, 0x90, 0xB8 },
	0xF6FE, { 0xE8, 0xA8, 0x97 },
	0xF7A1, { 0xE9, 0x90, 0xB8 },
	0xF7A2, { 0xE5, 0x91, 0x91 },
	0xF7A3, { 0xE5, 0x98, 0x86 },
	0xF7A4, { 0xE5, 0x9D, 0xA6 },
	0xF7A5, { 0xE5, 0xBD, 0x88 },
	0xF7A6, { 0xE6, 0x86, 0x9A },
	0xF7A7, { 0xE6, 0xAD, 0x8E },
	0xF7A8, { 0xE7, 0x81, 0x98 },
	0xF7A9, { 0xE7, 0x82, 0xAD },
	0xF7AA, { 0xE7, 0xB6, 0xBB },
	0xF7AB, { 0xE8, 0xAA, 0x95 },
	0xF7AC, { 0xE5, 0xA5, 0xAA },
	0xF7AD, { 0xE8, 0x84, 0xAB },
	0xF7AE, { 0xE6, 0x8E, 0xA2 },
	0xF7AF, { 0xE7, 0x9C, 0x88 },
	0xF7B0, { 0xE8, 0x80, 0xBD },
	0xF7B1, { 0xE8, 0xB2, 0xAA },
	0xF7B2, { 0xE5, 0xA1, 0x94 },
	0xF7B3, { 0xE6, 0x90, 0xAD },
	0xF7B4, { 0xE6, 0xA6, 0xBB },
	0xF7B5, { 0xE5, 0xAE, 0x95 },
	0xF7B6, { 0xE5, 0xB8, 0x91 },
	0xF7B7, { 0xE6, 0xB9, 0xAF },
	0xF7B8, { 0xEF, 0xA8, 0x83 },
	0xF7B9, { 0xE8, 0x95, 0xA9 },
	0xF7BA, { 0xE5, 0x85, 0x8C },
	0xF7BB, { 0xE5, 0x8F, 0xB0 },
	0xF7BC, { 0xE5, 0xA4, 0xAA },
	0xF7BD, { 0xE6, 0x80, 0xA0 },
	0xF7BE, { 0xE6, 0x85, 0x8B },
	0xF7BF, { 0xE6, 0xAE, 0x86 },
	0xF7C0, { 0xE6, 0xB1, 0xB0 },
	0xF7C1, { 0xE6, 0xB3, 0xB0 },
	0xF7C2, { 0xE7, 0xAC, 0x9E },
	0xF7C3, { 0xE8, 0x83, 0x8E },
	0xF7C4, { 0xE8, 0x8B, 0x94 },
	0xF7C5, { 0xE8, 0xB7, 0x86 },
	0xF7C6, { 0xE9, 0x82, 0xB0 },
	0xF7C7, { 0xE9, 0xA2, 0xB1 },
	0xF7C8, { 0xEF, 0xA8, 0x84 },
	0xF7C9, { 0xE6, 0x93, 0x87 },
	0xF7CA, { 0xE6, 0xBE, 0xA4 },
	0xF7CB, { 0xE6, 0x92, 0x91 },
	0xF7CC, { 0xE6, 0x94, 0x84 },
	0xF7CD, { 0xE5, 0x85, 0x8E },
	0xF7CE, { 0xE5, 0x90, 0x90 },
	0xF7CF, { 0xE5, 0x9C, 0x9F },
	0xF7D0, { 0xE8, 0xA8, 0x8E },
	0xF7D1, { 0xE6, 0x85, 0x9F },
	0xF7D2, { 0xE6, 0xA1, 0xB6 },
	0xF7D3, { 0xEF, 0xA8, 0x85 },
	0xF7D4, { 0xE7, 0x97, 0x9B },
	0xF7D5, { 0xE7, 0xAD, 0x92 },
	0xF7D6, { 0xE7, 0xB5, 0xB1 },
	0xF7D7, { 0xE9, 0x80, 0x9A },
	0xF7D8, { 0xE5, 0xA0, 0x86 },
	0xF7D9, { 0xE6, 0xA7, 0x8C },
	0xF7DA, { 0xE8, 0x85, 0xBF },
	0xF7DB, { 0xE8, 0xA4, 0xAA },
	0xF7DC, { 0xE9, 0x80, 0x80 },
	0xF7DD, { 0xE9, 0xA0, 0xB9 },
	0xF7DE, { 0xE5, 0x81, 0xB8 },
	0xF7DF, { 0xE5, 0xA5, 0x97 },
	0xF7E0, { 0xE5, 0xA6, 0xAC },
	0xF7E1, { 0xE6, 0x8A, 0x95 },
	0xF7E2, { 0xE9, 0x80, 0x8F },
	0xF7E3, { 0xE9, 0xAC, 0xAA },
	0xF7E4, { 0xE6, 0x85, 0x9D },
	0xF7E5, { 0xE7, 0x89, 0xB9 },
	0xF7E6, { 0xE9, 0x97, 0x96 },
	0xF7E7, { 0xE5, 0x9D, 0xA1 },
	0xF7E8, { 0xE5, 0xA9, 0x86 },
	0xF7E9, { 0xE5, 0xB7, 0xB4 },
	0xF7EA, { 0xE6, 0x8A, 0x8A },
	0xF7EB, { 0xE6, 0x92, 0xAD },
	0xF7EC, { 0xE6, 0x93, 0xBA },
	0xF7ED, { 0xE6, 0x9D, 0xB7 },
	0xF7EE, { 0xE6, 0xB3, 0xA2 },
	0xF7EF, { 0xE6, 0xB4, 0xBE },
	0xF7F0, { 0xE7, 0x88, 0xAC },
	0xF7F1, { 0xE7, 0x90, 0xB6 },
	0xF7F2, { 0xE7, 0xA0, 0xB4 },
	0xF7F3, { 0xE7, 0xBD, 0xB7 },
	0xF7F4, { 0xE8, 0x8A, 0xAD },
	0xF7F5, { 0xE8, 0xB7, 0x9B },
	0xF7F6, { 0xE9, 0xA0, 0x97 },
	0xF7F7, { 0xE5, 0x88, 0xA4 },
	0xF7F8, { 0xE5, 0x9D, 0x82 },
	0xF7F9, { 0xE6, 0x9D, 0xBF },
	0xF7FA, { 0xE7, 0x89, 0x88 },
	0xF7FB, { 0xE7, 0x93, 0xA3 },
	0xF7FC, { 0xE8, 0xB2, 0xA9 },
	0xF7FD, { 0xE8, 0xBE, 0xA6 },
	0xF7FE, { 0xE9, 0x88, 0x91 },
	0xF8A1, { 0xE9, 0x98, 0xAA },
	0xF8A2, { 0xE5, 0x85, 0xAB },
	0xF8A3, { 0xE5, 0x8F, 0xAD },
	0xF8A4, { 0xE6, 0x8D, 0x8C },
	0xF8A5, { 0xE4, 0xBD, 0xA9 },
	0xF8A6, { 0xE5, 0x94, 0x84 },
	0xF8A7, { 0xE6, 0x82, 0x96 },
	0xF8A8, { 0xE6, 0x95, 0x97 },
	0xF8A9, { 0xE6, 0xB2, 0x9B },
	0xF8AA, { 0xE6, 0xB5, 0xBF },
	0xF8AB, { 0xE7, 0x89, 0x8C },
	0xF8AC, { 0xE7, 0x8B, 0xBD },
	0xF8AD, { 0xE7, 0xA8, 0x97 },
	0xF8AE, { 0xE8, 0xA6, 0x87 },
	0xF8AF, { 0xE8, 0xB2, 0x9D },
	0xF8B0, { 0xE5, 0xBD, 0xAD },
	0xF8B1, { 0xE6, 0xBE, 0x8E },
	0xF8B2, { 0xE7, 0x83, 0xB9 },
	0xF8B3, { 0xE8, 0x86, 0xA8 },
	0xF8B4, { 0xE6, 0x84, 0x8E },
	0xF8B5, { 0xE4, 0xBE, 0xBF },
	0xF8B6, { 0xE5, 0x81, 0x8F },
	0xF8B7, { 0xE6, 0x89, 0x81 },
	0xF8B8, { 0xE7, 0x89, 0x87 },
	0xF8B9, { 0xE7, 0xAF, 0x87 },
	0xF8BA, { 0xE7, 0xB7, 0xA8 },
	0xF8BB, { 0xE7, 0xBF, 0xA9 },
	0xF8BC, { 0xE9, 0x81, 0x8D },
	0xF8BD, { 0xE9, 0x9E, 0xAD },
	0xF8BE, { 0xE9, 0xA8, 0x99 },
	0xF8BF, { 0xE8, 0xB2, 0xB6 },
	0xF8C0, { 0xE5, 0x9D, 0xAA },
	0xF8C1, { 0xE5, 0xB9, 0xB3 },
	0xF8C2, { 0xE6, 0x9E, 0xB0 },
	0xF8C3, { 0xE8, 0x90, 0x8D },
	0xF8C4, { 0xE8, 0xA9, 0x95 },
	0xF8C5, { 0xE5, 0x90, 0xA0 },
	0xF8C6, { 0xE5, 0xAC, 0x96 },
	0xF8C7, { 0xE5, 0xB9, 0xA3 },
	0xF8C8, { 0xE5, 0xBB, 0xA2 },
	0xF8C9, { 0xE5, 0xBC, 0x8A },
	0xF8CA, { 0xE6, 0x96, 0x83 },
	0xF8CB, { 0xE8, 0x82, 0xBA },
	0xF8CC, { 0xE8, 0x94, 0xBD },
	0xF8CD, { 0xE9, 0x96, 0x89 },
	0xF8CE, { 0xE9, 0x99, 0x9B },
	0xF8CF, { 0xE4, 0xBD, 0x88 },
	0xF8D0, { 0xE5, 0x8C, 0x85 },
	0xF8D1, { 0xE5, 0x8C, 0x8D },
	0xF8D2, { 0xE5, 0x8C, 0x8F },
	0xF8D3, { 0xE5, 0x92, 0x86 },
	0xF8D4, { 0xE5, 0x93, 0xBA },
	0xF8D5, { 0xE5, 0x9C, 0x83 },
	0xF8D6, { 0xE5, 0xB8, 0x83 },
	0xF8D7, { 0xE6, 0x80, 0x96 },
	0xF8D8, { 0xE6, 0x8A, 0x9B },
	0xF8D9, { 0xE6, 0x8A, 0xB1 },
	0xF8DA, { 0xE6, 0x8D, 0x95 },
	0xF8DB, { 0xEF, 0xA8, 0x86 },
	0xF8DC, { 0xE6, 0xB3, 0xA1 },
	0xF8DD, { 0xE6, 0xB5, 0xA6 },
	0xF8DE, { 0xE7, 0x96, 0xB1 },
	0xF8DF, { 0xE7, 0xA0, 0xB2 },
	0xF8E0, { 0xE8, 0x83, 0x9E },
	0xF8E1, { 0xE8, 0x84, 0xAF },
	0xF8E2, { 0xE8, 0x8B, 0x9E },
	0xF8E3, { 0xE8, 0x91, 0xA1 },
	0xF8E4, { 0xE8, 0x92, 0xB2 },
	0xF8E5, { 0xE8, 0xA2, 0x8D },
	0xF8E6, { 0xE8, 0xA4, 0x92 },
	0xF8E7, { 0xE9, 0x80, 0x8B },
	0xF8E8, { 0xE9, 0x8B, 0xAA },
	0xF8E9, { 0xE9, 0xA3, 0xBD },
	0xF8EA, { 0xE9, 0xAE, 0x91 },
	0xF8EB, { 0xE5, 0xB9, 0x85 },
	0xF8EC, { 0xE6, 0x9A, 0xB4 },
	0xF8ED, { 0xE6, 0x9B, 0x9D },
	0xF8EE, { 0xE7, 0x80, 0x91 },
	0xF8EF, { 0xE7, 0x88, 0x86 },
	0xF8F0, { 0xEF, 0xA8, 0x87 },
	0xF8F1, { 0xE4, 0xBF, 0xB5 },
	0xF8F2, { 0xE5, 0x89, 0xBD },
	0xF8F3, { 0xE5, 0xBD, 0xAA },
	0xF8F4, { 0xE6, 0x85, 0x93 },
	0xF8F5, { 0xE6, 0x9D, 0x93 },
	0xF8F6, { 0xE6, 0xA8, 0x99 },
	0xF8F7, { 0xE6, 0xBC, 0x82 },
	0xF8F8, { 0xE7, 0x93, 0xA2 },
	0xF8F9, { 0xE7, 0xA5, 0xA8 },
	0xF8FA, { 0xE8, 0xA1, 0xA8 },
	0xF8FB, { 0xE8, 0xB1, 0xB9 },
	0xF8FC, { 0xE9, 0xA3, 0x87 },
	0xF8FD, { 0xE9, 0xA3, 0x84 },
	0xF8FE, { 0xE9, 0xA9, 0x83 },
	0xF9A1, { 0xE5, 0x93, 0x81 },
	0xF9A2, { 0xE7, 0xA8, 0x9F },
	0xF9A3, { 0xE6, 0xA5, 0x93 },
	0xF9A4, { 0xE8, 0xAB, 0xB7 },
	0xF9A5, { 0xE8, 0xB1, 0x8A },
	0xF9A6, { 0xE9, 0xA2, 0xA8 },
	0xF9A7, { 0xE9, 0xA6, 0xAE },
	0xF9A8, { 0xE5, 0xBD, 0xBC },
	0xF9A9, { 0xE6, 0x8A, 0xAB },
	0xF9AA, { 0xE7, 0x96, 0xB2 },
	0xF9AB, { 0xE7, 0x9A, 0xAE },
	0xF9AC, { 0xE8, 0xA2, 0xAB },
	0xF9AD, { 0xE9, 0x81, 0xBF },
	0xF9AE, { 0xE9, 0x99, 0x82 },
	0xF9AF, { 0xE5, 0x8C, 0xB9 },
	0xF9B0, { 0xE5, 0xBC, 0xBC },
	0xF9B1, { 0xE5, 0xBF, 0x85 },
	0xF9B2, { 0xE6, 0xB3, 0x8C },
	0xF9B3, { 0xE7, 0x8F, 0x8C },
	0xF9B4, { 0xE7, 0x95, 0xA2 },
	0xF9B5, { 0xE7, 0x96, 0x8B },
	0xF9B6, { 0xE7, 0xAD, 0x86 },
	0xF9B7, { 0xE8, 0x8B, 0xBE },
	0xF9B8, { 0xE9, 0xA6, 0x9D },
	0xF9B9, { 0xE4, 0xB9, 0x8F },
	0xF9BA, { 0xE9, 0x80, 0xBC },
	0xF9BB, { 0xE4, 0xB8, 0x8B },
	0xF9BC, { 0xE4, 0xBD, 0x95 },
	0xF9BD, { 0xE5, 0x8E, 0xA6 },
	0xF9BE, { 0xE5, 0xA4, 0x8F },
	0xF9BF, { 0xE5, 0xBB, 0x88 },
	0xF9C0, { 0xE6, 0x98, 0xB0 },
	0xF9C1, { 0xE6, 0xB2, 0xB3 },
	0xF9C2, { 0xE7, 0x91, 0x95 },
	0xF9C3, { 0xE8, 0x8D, 0xB7 },
	0xF9C4, { 0xE8, 0x9D, 0xA6 },
	0xF9C5, { 0xE8, 0xB3, 0x80 },
	0xF9C6, { 0xE9, 0x81, 0x90 },
	0xF9C7, { 0xE9, 0x9C, 0x9E },
	0xF9C8, { 0xE9, 0xB0, 0x95 },
	0xF9C9, { 0xE5, 0xA3, 0x91 },
	0xF9CA, { 0xE5, 0xAD, 0xB8 },
	0xF9CB, { 0xE8, 0x99, 0x90 },
	0xF9CC, { 0xE8, 0xAC, 0x94 },
	0xF9CD, { 0xE9, 0xB6, 0xB4 },
	0xF9CE, { 0xE5, 0xAF, 0x92 },
	0xF9CF, { 0xE6, 0x81, 0xA8 },
	0xF9D0, { 0xE6, 0x82, 0x8D },
	0xF9D1, { 0xE6, 0x97, 0xB1 },
	0xF9D2, { 0xE6, 0xB1, 0x97 },
	0xF9D3, { 0xE6, 0xBC, 0xA2 },
	0xF9D4, { 0xE6, 0xBE, 0xA3 },
	0xF9D5, { 0xE7, 0x80, 0x9A },
	0xF9D6, { 0xE7, 0xBD, 0x95 },
	0xF9D7, { 0xE7, 0xBF, 0xB0 },
	0xF9D8, { 0xE9, 0x96, 0x91 },
	0xF9D9, { 0xE9, 0x96, 0x92 },
	0xF9DA, { 0xE9, 0x99, 0x90 },
	0xF9DB, { 0xE9, 0x9F, 0x93 },
	0xF9DC, { 0xE5, 0x89, 0xB2 },
	0xF9DD, { 0xE8, 0xBD, 0x84 },
	0xF9DE, { 0xE5, 0x87, 0xBD },
	0xF9DF, { 0xE5, 0x90, 0xAB },
	0xF9E0, { 0xE5, 0x92, 0xB8 },
	0xF9E1, { 0xE5, 0x95, 0xA3 },
	0xF9E2, { 0xE5, 0x96, 0x8A },
	0xF9E3, { 0xE6, 0xAA, 0xBB },
	0xF9E4, { 0xE6, 0xB6, 0xB5 },
	0xF9E5, { 0xE7, 0xB7, 0x98 },
	0xF9E6, { 0xE8, 0x89, 0xA6 },
	0xF9E7, { 0xE9, 0x8A, 0x9C },
	0xF9E8, { 0xE9, 0x99, 0xB7 },
	0xF9E9, { 0xE9, 0xB9, 0xB9 },
	0xF9EA, { 0xE5, 0x90, 0x88 },
	0xF9EB, { 0xE5, 0x93, 0x88 },
	0xF9EC, { 0xE7, 0x9B, 0x92 },
	0xF9ED, { 0xE8, 0x9B, 0xA4 },
	0xF9EE, { 0xE9, 0x96, 0xA4 },
	0xF9EF, { 0xE9, 0x97, 0x94 },
	0xF9F0, { 0xE9, 0x99, 0x9C },
	0xF9F1, { 0xE4, 0xBA, 0xA2 },
	0xF9F2, { 0xE4, 0xBC, 0x89 },
	0xF9F3, { 0xE5, 0xA7, 0xAE },
	0xF9F4, { 0xE5, 0xAB, 0xA6 },
	0xF9F5, { 0xE5, 0xB7, 0xB7 },
	0xF9F6, { 0xE6, 0x81, 0x92 },
	0xF9F7, { 0xE6, 0x8A, 0x97 },
	0xF9F8, { 0xE6, 0x9D, 0xAD },
	0xF9F9, { 0xE6, 0xA1, 0x81 },
	0xF9FA, { 0xE6, 0xB2, 0x86 },
	0xF9FB, { 0xE6, 0xB8, 0xAF },
	0xF9FC, { 0xE7, 0xBC, 0xB8 },
	0xF9FD, { 0xE8, 0x82, 0x9B },
	0xF9FE, { 0xE8, 0x88, 0xAA },
	0xFAA1, { 0xEF, 0xA8, 0x88 },
	0xFAA2, { 0xEF, 0xA8, 0x89 },
	0xFAA3, { 0xE9, 0xA0, 0x85 },
	0xFAA4, { 0xE4, 0xBA, 0xA5 },
	0xFAA5, { 0xE5, 0x81, 0x95 },
	0xFAA6, { 0xE5, 0x92, 0xB3 },
	0xFAA7, { 0xE5, 0x9E, 0x93 },
	0xFAA8, { 0xE5, 0xA5, 0x9A },
	0xFAA9, { 0xE5, 0xAD, 0xA9 },
	0xFAAA, { 0xE5, 0xAE, 0xB3 },
	0xFAAB, { 0xE6, 0x87, 0x88 },
	0xFAAC, { 0xE6, 0xA5, 0xB7 },
	0xFAAD, { 0xE6, 0xB5, 0xB7 },
	0xFAAE, { 0xE7, 0x80, 0xA3 },
	0xFAAF, { 0xE8, 0x9F, 0xB9 },
	0xFAB0, { 0xE8, 0xA7, 0xA3 },
	0xFAB1, { 0xE8, 0xA9, 0xB2 },
	0xFAB2, { 0xE8, 0xAB, 0xA7 },
	0xFAB3, { 0xE9, 0x82, 0x82 },
	0xFAB4, { 0xE9, 0xA7, 0xAD },
	0xFAB5, { 0xE9, 0xAA, 0xB8 },
	0xFAB6, { 0xE5, 0x8A, 0xBE },
	0xFAB7, { 0xE6, 0xA0, 0xB8 },
	0xFAB8, { 0xE5, 0x80, 0x96 },
	0xFAB9, { 0xE5, 0xB9, 0xB8 },
	0xFABA, { 0xE6, 0x9D, 0x8F },
	0xFABB, { 0xE8, 0x8D, 0x87 },
	0xFABC, { 0xE8, 0xA1, 0x8C },
	0xFABD, { 0xE4, 0xBA, 0xAB },
	0xFABE, { 0xE5, 0x90, 0x91 },
	0xFABF, { 0xE5, 0x9A, 0xAE },
	0xFAC0, { 0xE7, 0x8F, 0xA6 },
	0xFAC1, { 0xE9, 0x84, 0x95 },
	0xFAC2, { 0xE9, 0x9F, 0xBF },
	0xFAC3, { 0xE9, 0xA4, 0x89 },
	0xFAC4, { 0xE9, 0xA5, 0x97 },
	0xFAC5, { 0xE9, 0xA6, 0x99 },
	0xFAC6, { 0xE5, 0x99, 0x93 },
	0xFAC7, { 0xE5, 0xA2, 0x9F },
	0xFAC8, { 0xE8, 0x99, 0x9B },
	0xFAC9, { 0xE8, 0xA8, 0xB1 },
	0xFACA, { 0xE6, 0x86, 0xB2 },
	0xFACB, { 0xE6, 0xAB, 0xB6 },
	0xFACC, { 0xE7, 0x8D, 0xBB },
	0xFACD, { 0xE8, 0xBB, 0x92 },
	0xFACE, { 0xE6, 0xAD, 0x87 },
	0xFACF, { 0xE9, 0x9A, 0xAA },
	0xFAD0, { 0xE9, 0xA9, 0x97 },
	0xFAD1, { 0xE5, 0xA5, 0x95 },
	0xFAD2, { 0xE7, 0x88, 0x80 },
	0xFAD3, { 0xE8, 0xB5, 0xAB },
	0xFAD4, { 0xE9, 0x9D, 0xA9 },
	0xFAD5, { 0xE4, 0xBF, 0x94 },
	0xFAD6, { 0xE5, 0xB3, 0xB4 },
	0xFAD7, { 0xE5, 0xBC, 0xA6 },
	0xFAD8, { 0xE6, 0x87, 0xB8 },
	0xFAD9, { 0xE6, 0x99, 0x9B },
	0xFADA, { 0xE6, 0xB3, 0xAB },
	0xFADB, { 0xE7, 0x82, 0xAB },
	0xFADC, { 0xE7, 0x8E, 0x84 },
	0xFADD, { 0xE7, 0x8E, 0xB9 },
	0xFADE, { 0xE7, 0x8F, 0xBE },
	0xFADF, { 0xE7, 0x9C, 0xA9 },
	0xFAE0, { 0xE7, 0x9D, 0x8D },
	0xFAE1, { 0xE7, 0xB5, 0x83 },
	0xFAE2, { 0xE7, 0xB5, 0xA2 },
	0xFAE3, { 0xE7, 0xB8, 0xA3 },
	0xFAE4, { 0xE8, 0x88, 0xB7 },
	0xFAE5, { 0xE8, 0xA1, 0x92 },
	0xFAE6, { 0xEF, 0xA8, 0x8A },
	0xFAE7, { 0xE8, 0xB3, 0xA2 },
	0xFAE8, { 0xE9, 0x89, 0x89 },
	0xFAE9, { 0xE9, 0xA1, 0xAF },
	0xFAEA, { 0xE5, 0xAD, 0x91 },
	0xFAEB, { 0xE7, 0xA9, 0xB4 },
	0xFAEC, { 0xE8, 0xA1, 0x80 },
	0xFAED, { 0xE9, 0xA0, 0x81 },
	0xFAEE, { 0xE5, 0xAB, 0x8C },
	0xFAEF, { 0xE4, 0xBF, 0xA0 },
	0xFAF0, { 0xE5, 0x8D, 0x94 },
	0xFAF1, { 0xE5, 0xA4, 0xBE },
	0xFAF2, { 0xE5, 0xB3, 0xBD },
	0xFAF3, { 0xE6, 0x8C, 0xBE },
	0xFAF4, { 0xE6, 0xB5, 0xB9 },
	0xFAF5, { 0xE7, 0x8B, 0xB9 },
	0xFAF6, { 0xE8, 0x84, 0x85 },
	0xFAF7, { 0xE8, 0x84, 0x87 },
	0xFAF8, { 0xE8, 0x8E, 0xA2 },
	0xFAF9, { 0xE9, 0x8B, 0x8F },
	0xFAFA, { 0xE9, 0xA0, 0xB0 },
	0xFAFB, { 0xE4, 0xBA, 0xA8 },
	0xFAFC, { 0xE5, 0x85, 0x84 },
	0xFAFD, { 0xE5, 0x88, 0x91 },
	0xFAFE, { 0xE5, 0x9E, 0x8B },
	0xFBA1, { 0xE5, 0xBD, 0xA2 },
	0xFBA2, { 0xE6, 0xB3, 0x82 },
	0xFBA3, { 0xE6, 0xBB, 0x8E },
	0xFBA4, { 0xE7, 0x80, 0x85 },
	0xFBA5, { 0xE7, 0x81, 0x90 },
	0xFBA6, { 0xE7, 0x82, 0xAF },
	0xFBA7, { 0xE7, 0x86, 0x92 },
	0xFBA8, { 0xE7, 0x8F, 0xA9 },
	0xFBA9, { 0xE7, 0x91, 0xA9 },
	0xFBAA, { 0xE8, 0x8D, 0x8A },
	0xFBAB, { 0xE8, 0x9E, 0xA2 },
	0xFBAC, { 0xE8, 0xA1, 0xA1 },
	0xFBAD, { 0xE9, 0x80, 0x88 },
	0xFBAE, { 0xE9, 0x82, 0xA2 },
	0xFBAF, { 0xE9, 0x8E, 0xA3 },
	0xFBB0, { 0xE9, 0xA6, 0xA8 },
	0xFBB1, { 0xE5, 0x85, 0xAE },
	0xFBB2, { 0xE5, 0xBD, 0x97 },
	0xFBB3, { 0xE6, 0x83, 0xA0 },
	0xFBB4, { 0xE6, 0x85, 0xA7 },
	0xFBB5, { 0xE6, 0x9A, 0xB3 },
	0xFBB6, { 0xE8, 0x95, 0x99 },
	0xFBB7, { 0xE8, 0xB9, 0x8A },
	0xFBB8, { 0xE9, 0x86, 0xAF },
	0xFBB9, { 0xE9, 0x9E, 0x8B },
	0xFBBA, { 0xE4, 0xB9, 0x8E },
	0xFBBB, { 0xE4, 0xBA, 0x92 },
	0xFBBC, { 0xE5, 0x91, 0xBC },
	0xFBBD, { 0xE5, 0xA3, 0x95 },
	0xFBBE, { 0xE5, 0xA3, 0xBA },
	0xFBBF, { 0xE5, 0xA5, 0xBD },
	0xFBC0, { 0xE5, 0xB2, 0xB5 },
	0xFBC1, { 0xE5, 0xBC, 0xA7 },
	0xFBC2, { 0xE6, 0x88, 0xB6 },
	0xFBC3, { 0xE6, 0x89, 0x88 },
	0xFBC4, { 0xE6, 0x98, 0x8A },
	0xFBC5, { 0xE6, 0x99, 0xA7 },
	0xFBC6, { 0xE6, 0xAF, 0xAB },
	0xFBC7, { 0xE6, 0xB5, 0xA9 },
	0xFBC8, { 0xE6, 0xB7, 0x8F },
	0xFBC9, { 0xE6, 0xB9, 0x96 },
	0xFBCA, { 0xE6, 0xBB, 0xB8 },
	0xFBCB, { 0xE6, 0xBE, 0x94 },
	0xFBCC, { 0xE6, 0xBF, 0xA0 },
	0xFBCD, { 0xE6, 0xBF, 0xA9 },
	0xFBCE, { 0xE7, 0x81, 0x9D },
	0xFBCF, { 0xE7, 0x8B, 0x90 },
	0xFBD0, { 0xE7, 0x90, 0xA5 },
	0xFBD1, { 0xE7, 0x91, 0x9A },
	0xFBD2, { 0xE7, 0x93, 0xA0 },
	0xFBD3, { 0xE7, 0x9A, 0x93 },
	0xFBD4, { 0xE7, 0xA5, 0x9C },
	0xFBD5, { 0xE7, 0xB3, 0x8A },
	0xFBD6, { 0xE7, 0xB8, 0x9E },
	0xFBD7, { 0xE8, 0x83, 0xA1 },
	0xFBD8, { 0xE8, 0x8A, 0xA6 },
	0xFBD9, { 0xE8, 0x91, 0xAB },
	0xFBDA, { 0xE8, 0x92, 0xBF },
	0xFBDB, { 0xE8, 0x99, 0x8E },
	0xFBDC, { 0xE8, 0x99, 0x9F },
	0xFBDD, { 0xE8, 0x9D, 0xB4 },
	0xFBDE, { 0xE8, 0xAD, 0xB7 },
	0xFBDF, { 0xE8, 0xB1, 0xAA },
	0xFBE0, { 0xE9, 0x8E, 0xAC },
	0xFBE1, { 0xE9, 0xA0, 0x80 },
	0xFBE2, { 0xE9, 0xA1, 0xA5 },
	0xFBE3, { 0xE6, 0x83, 0x91 },
	0xFBE4, { 0xE6, 0x88, 0x96 },
	0xFBE5, { 0xE9, 0x85, 0xB7 },
	0xFBE6, { 0xE5, 0xA9, 0x9A },
	0xFBE7, { 0xE6, 0x98, 0x8F },
	0xFBE8, { 0xE6, 0xB7, 0xB7 },
	0xFBE9, { 0xE6, 0xB8, 0xBE },
	0xFBEA, { 0xE7, 0x90, 0xBF },
	0xFBEB, { 0xE9, 0xAD, 0x82 },
	0xFBEC, { 0xE5, 0xBF, 0xBD },
	0xFBED, { 0xE6, 0x83, 0x9A },
	0xFBEE, { 0xE7, 0xAC, 0x8F },
	0xFBEF, { 0xE5, 0x93, 0x84 },
	0xFBF0, { 0xE5, 0xBC, 0x98 },
	0xFBF1, { 0xE6, 0xB1, 0x9E },
	0xFBF2, { 0xE6, 0xB3, 0x93 },
	0xFBF3, { 0xE6, 0xB4, 0xAA },
	0xFBF4, { 0xE7, 0x83, 0x98 },
	0xFBF5, { 0xE7, 0xB4, 0x85 },
	0xFBF6, { 0xE8, 0x99, 0xB9 },
	0xFBF7, { 0xE8, 0xA8, 0x8C },
	0xFBF8, { 0xE9, 0xB4, 0xBB },
	0xFBF9, { 0xE5, 0x8C, 0x96 },
	0xFBFA, { 0xE5, 0x92, 0x8C },
	0xFBFB, { 0xE5, 0xAC, 0x85 },
	0xFBFC, { 0xE6, 0xA8, 0xBA },
	0xFBFD, { 0xE7, 0x81, 0xAB },
	0xFBFE, { 0xE7, 0x95, 0xB5 },
	0xFCA1, { 0xE7, 0xA6, 0x8D },
	0xFCA2, { 0xE7, 0xA6, 0xBE },
	0xFCA3, { 0xE8, 0x8A, 0xB1 },
	0xFCA4, { 0xE8, 0x8F, 0xAF },
	0xFCA5, { 0xE8, 0xA9, 0xB1 },
	0xFCA6, { 0xE8, 0xAD, 0x81 },
	0xFCA7, { 0xE8, 0xB2, 0xA8 },
	0xFCA8, { 0xE9, 0x9D, 0xB4 },
	0xFCA9, { 0xEF, 0xA8, 0x8B },
	0xFCAA, { 0xE6, 0x93, 0xB4 },
	0xFCAB, { 0xE6, 0x94, 0xAB },
	0xFCAC, { 0xE7, 0xA2, 0xBA },
	0xFCAD, { 0xE7, 0xA2, 0xBB },
	0xFCAE, { 0xE7, 0xA9, 0xAB },
	0xFCAF, { 0xE4, 0xB8, 0xB8 },
	0xFCB0, { 0xE5, 0x96, 0x9A },
	0xFCB1, { 0xE5, 0xA5, 0x90 },
	0xFCB2, { 0xE5, 0xAE, 0xA6 },
	0xFCB3, { 0xE5, 0xB9, 0xBB },
	0xFCB4, { 0xE6, 0x82, 0xA3 },
	0xFCB5, { 0xE6, 0x8F, 0x9B },
	0xFCB6, { 0xE6, 0xAD, 0xA1 },
	0xFCB7, { 0xE6, 0x99, 0xA5 },
	0xFCB8, { 0xE6, 0xA1, 0x93 },
	0xFCB9, { 0xE6, 0xB8, 0x99 },
	0xFCBA, { 0xE7, 0x85, 0xA5 },
	0xFCBB, { 0xE7, 0x92, 0xB0 },
	0xFCBC, { 0xE7, 0xB4, 0x88 },
	0xFCBD, { 0xE9, 0x82, 0x84 },
	0xFCBE, { 0xE9, 0xA9, 0xA9 },
	0xFCBF, { 0xE9, 0xB0, 0xA5 },
	0xFCC0, { 0xE6, 0xB4, 0xBB },
	0xFCC1, { 0xE6, 0xBB, 0x91 },
	0xFCC2, { 0xE7, 0x8C, 0xBE },
	0xFCC3, { 0xE8, 0xB1, 0x81 },
	0xFCC4, { 0xE9, 0x97, 0x8A },
	0xFCC5, { 0xE5, 0x87, 0xB0 },
	0xFCC6, { 0xE5, 0xB9, 0x8C },
	0xFCC7, { 0xE5, 0xBE, 0xA8 },
	0xFCC8, { 0xE6, 0x81, 0x8D },
	0xFCC9, { 0xE6, 0x83, 0xB6 },
	0xFCCA, { 0xE6, 0x84, 0xB0 },
	0xFCCB, { 0xE6, 0x85, 0x8C },
	0xFCCC, { 0xE6, 0x99, 0x83 },
	0xFCCD, { 0xE6, 0x99, 0x84 },
	0xFCCE, { 0xE6, 0xA6, 0xA5 },
	0xFCCF, { 0xE6, 0xB3, 0x81 },
	0xFCD0, { 0xE6, 0xB9, 0x9F },
	0xFCD1, { 0xE6, 0xBB, 0x89 },
	0xFCD2, { 0xE6, 0xBD, 0xA2 },
	0xFCD3, { 0xE7, 0x85, 0x8C },
	0xFCD4, { 0xE7, 0x92, 0x9C },
	0xFCD5, { 0xE7, 0x9A, 0x87 },
	0xFCD6, { 0xE7, 0xAF, 0x81 },
	0xFCD7, { 0xE7, 0xB0, 0xA7 },
	0xFCD8, { 0xE8, 0x8D, 0x92 },
	0xFCD9, { 0xE8, 0x9D, 0x97 },
	0xFCDA, { 0xE9, 0x81, 0x91 },
	0xFCDB, { 0xE9, 0x9A, 0x8D },
	0xFCDC, { 0xE9, 0xBB, 0x83 },
	0xFCDD, { 0xE5, 0x8C, 0xAF },
	0xFCDE, { 0xE5, 0x9B, 0x9E },
	0xFCDF, { 0xE5, 0xBB, 0xBB },
	0xFCE0, { 0xE5, 0xBE, 0x8A },
	0xFCE1, { 0xE6, 0x81, 0xA2 },
	0xFCE2, { 0xE6, 0x82, 0x94 },
	0xFCE3, { 0xE6, 0x87, 0xB7 },
	0xFCE4, { 0xE6, 0x99, 0xA6 },
	0xFCE5, { 0xE6, 0x9C, 0x83 },
	0xFCE6, { 0xE6, 0xAA, 0x9C },
	0xFCE7, { 0xE6, 0xB7, 0xAE },
	0xFCE8, { 0xE6, 0xBE, 0xAE },
	0xFCE9, { 0xE7, 0x81, 0xB0 },
	0xFCEA, { 0xE7, 0x8D, 0xAA },
	0xFCEB, { 0xE7, 0xB9, 0xAA },
	0xFCEC, { 0xE8, 0x86, 0xBE },
	0xFCED, { 0xE8, 0x8C, 0xB4 },
	0xFCEE, { 0xE8, 0x9B, 0x94 },
	0xFCEF, { 0xE8, 0xAA, 0xA8 },
	0xFCF0, { 0xE8, 0xB3, 0x84 },
	0xFCF1, { 0xE5, 0x8A, 0x83 },
	0xFCF2, { 0xE7, 0x8D, 0xB2 },
	0xFCF3, { 0xE5, 0xAE, 0x96 },
	0xFCF4, { 0xE6, 0xA9, 0xAB },
	0xFCF5, { 0xE9, 0x90, 0x84 },
	0xFCF6, { 0xE5, 0x93, 0xAE },
	0xFCF7, { 0xE5, 0x9A, 0x86 },
	0xFCF8, { 0xE5, 0xAD, 0x9D },
	0xFCF9, { 0xE6, 0x95, 0x88 },
	0xFCFA, { 0xE6, 0x96, 0x85 },
	0xFCFB, { 0xE6, 0x9B, 0x89 },
	0xFCFC, { 0xE6, 0xA2, 0x9F },
	0xFCFD, { 0xE6, 0xB6, 0x8D },
	0xFCFE, { 0xE6, 0xB7, 0x86 },
	0xFDA1, { 0xE7, 0x88, 0xBB },
	0xFDA2, { 0xE8, 0x82, 0xB4 },
	0xFDA3, { 0xE9, 0x85, 0xB5 },
	0xFDA4, { 0xE9, 0xA9, 0x8D },
	0xFDA5, { 0xE4, 0xBE, 0xAF },
	0xFDA6, { 0xE5, 0x80, 0x99 },
	0xFDA7, { 0xE5, 0x8E, 0x9A },
	0xFDA8, { 0xE5, 0x90, 0x8E },
	0xFDA9, { 0xE5, 0x90, 0xBC },
	0xFDAA, { 0xE5, 0x96, 0x89 },
	0xFDAB, { 0xE5, 0x97, 0x85 },
	0xFDAC, { 0xE5, 0xB8, 0xBF },
	0xFDAD, { 0xE5, 0xBE, 0x8C },
	0xFDAE, { 0xE6, 0x9C, 0xBD },
	0xFDAF, { 0xE7, 0x85, 0xA6 },
	0xFDB0, { 0xE7, 0x8F, 0x9D },
	0xFDB1, { 0xE9, 0x80, 0x85 },
	0xFDB2, { 0xE5, 0x8B, 0x9B },
	0xFDB3, { 0xE5, 0x8B, 0xB3 },
	0xFDB4, { 0xE5, 0xA1, 0xA4 },
	0xFDB5, { 0xE5, 0xA3, 0x8E },
	0xFDB6, { 0xE7, 0x84, 0x84 },
	0xFDB7, { 0xE7, 0x86, 0x8F },
	0xFDB8, { 0xE7, 0x87, 0xBB },
	0xFDB9, { 0xE8, 0x96, 0xB0 },
	0xFDBA, { 0xE8, 0xA8, 0x93 },
	0xFDBB, { 0xE6, 0x9A, 0x88 },
	0xFDBC, { 0xE8, 0x96, 0xA8 },
	0xFDBD, { 0xE5, 0x96, 0xA7 },
	0xFDBE, { 0xE6, 0x9A, 0x84 },
	0xFDBF, { 0xE7, 0x85, 0x8A },
	0xFDC0, { 0xE8, 0x90, 0xB1 },
	0xFDC1, { 0xE5, 0x8D, 0x89 },
	0xFDC2, { 0xE5, 0x96, 0x99 },
	0xFDC3, { 0xE6, 0xAF, 0x81 },
	0xFDC4, { 0xE5, 0xBD, 0x99 },
	0xFDC5, { 0xE5, 0xBE, 0xBD },
	0xFDC6, { 0xE6, 0x8F, 0xAE },
	0xFDC7, { 0xE6, 0x9A, 0x89 },
	0xFDC8, { 0xE7, 0x85, 0x87 },
	0xFDC9, { 0xE8, 0xAB, 0xB1 },
	0xFDCA, { 0xE8, 0xBC, 0x9D },
	0xFDCB, { 0xE9, 0xBA, 0xBE },
	0xFDCC, { 0xE4, 0xBC, 0x91 },
	0xFDCD, { 0xE6, 0x90, 0xBA },
	0xFDCE, { 0xE7, 0x83, 0x8B },
	0xFDCF, { 0xE7, 0x95, 0xA6 },
	0xFDD0, { 0xE8, 0x99, 0xA7 },
	0xFDD1, { 0xE6, 0x81, 0xA4 },
	0xFDD2, { 0xE8, 0xAD, 0x8E },
	0xFDD3, { 0xE9, 0xB7, 0xB8 },
	0xFDD4, { 0xE5, 0x85, 0x87 },
	0xFDD5, { 0xE5, 0x87, 0xB6 },
	0xFDD6, { 0xE5, 0x8C, 0x88 },
	0xFDD7, { 0xE6, 0xB4, 0xB6 },
	0xFDD8, { 0xE8, 0x83, 0xB8 },
	0xFDD9, { 0xE9, 0xBB, 0x91 },
	0xFDDA, { 0xE6, 0x98, 0x95 },
	0xFDDB, { 0xE6, 0xAC, 0xA3 },
	0xFDDC, { 0xE7, 0x82, 0x98 },
	0xFDDD, { 0xE7, 0x97, 0x95 },
	0xFDDE, { 0xE5, 0x90, 0x83 },
	0xFDDF, { 0xE5, 0xB1, 0xB9 },
	0xFDE0, { 0xE7, 0xB4, 0x87 },
	0xFDE1, { 0xE8, 0xA8, 0x96 },
	0xFDE2, { 0xE6, 0xAC, 0xA0 },
	0xFDE3, { 0xE6, 0xAC, 0xBD },
	0xFDE4, { 0xE6, 0xAD, 0x86 },
	0xFDE5, { 0xE5, 0x90, 0xB8 },
	0xFDE6, { 0xE6, 0x81, 0xB0 },
	0xFDE7, { 0xE6, 0xB4, 0xBD },
	0xFDE8, { 0xE7, 0xBF, 0x95 },
	0xFDE9, { 0xE8, 0x88, 0x88 },
	0xFDEA, { 0xE5, 0x83, 0x96 },
	0xFDEB, { 0xE5, 0x87, 0x9E },
	0xFDEC, { 0xE5, 0x96, 0x9C },
	0xFDED, { 0xE5, 0x99, 0xAB },
	0xFDEE, { 0xE5, 0x9B, 0x8D },
	0xFDEF, { 0xE5, 0xA7, 0xAC },
	0xFDF0, { 0xE5, 0xAC, 0x89 },
	0xFDF1, { 0xE5, 0xB8, 0x8C },
	0xFDF2, { 0xE6, 0x86, 0x99 },
	0xFDF3, { 0xE6, 0x86, 0x98 },
	0xFDF4, { 0xE6, 0x88, 0xB1 },
	0xFDF5, { 0xE6, 0x99, 0x9E },
	0xFDF6, { 0xE6, 0x9B, 0xA6 },
	0xFDF7, { 0xE7, 0x86, 0x99 },
	0xFDF8, { 0xE7, 0x86, 0xB9 },
	0xFDF9, { 0xE7, 0x86, 0xBA },
	0xFDFA, { 0xE7, 0x8A, 0xA7 },
	0xFDFB, { 0xE7, 0xA6, 0xA7 },
	0xFDFC, { 0xE7, 0xA8, 0x80 },
	0xFDFD, { 0xE7, 0xBE, 0xB2 },
	0xFDFE, { 0xE8, 0xA9, 0xB0 }
};

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_KICONV_EUCKR_UTF8_H */
