/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_KICONV_CP950HKSCS_UTF8_H
#define	_SYS_KICONV_CP950HKSCS_UTF8_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/* Maximum mapping number from CP950HKSCS to UTF-8. */
#define	KICONV_CP950HKSCS_UTF8_MAX		(18322)

/* CP950HKSCS(for Windows) to UTF-8 mapping table. */
static kiconv_table_array_t kiconv_cp950hkscs_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },
	0x8840, { 0xEF, 0x8C, 0x83 },
	0x8841, { 0xEF, 0x8C, 0x84 },
	0x8842, { 0xEF, 0x8C, 0x85 },
	0x8843, { 0xEF, 0x8C, 0x86 },
	0x8844, { 0xEF, 0x8C, 0x87 },
	0x8845, { 0xEF, 0x8C, 0x88 },
	0x8846, { 0xEF, 0x8C, 0x89 },
	0x8847, { 0xEF, 0x8C, 0x8A },
	0x8848, { 0xEF, 0x8C, 0x8B },
	0x8849, { 0xEF, 0x8C, 0x8C },
	0x884a, { 0xEF, 0x8C, 0x8D },
	0x884b, { 0xEF, 0x8C, 0x8E },
	0x884c, { 0xEF, 0x8C, 0x8F },
	0x884d, { 0xEF, 0x8C, 0x90 },
	0x884e, { 0xEF, 0x8C, 0x91 },
	0x884f, { 0xEF, 0x8C, 0x92 },
	0x8850, { 0xEF, 0x8C, 0x93 },
	0x8851, { 0xEF, 0x8C, 0x94 },
	0x8852, { 0xEF, 0x8C, 0x95 },
	0x8853, { 0xEF, 0x8C, 0x96 },
	0x8854, { 0xEF, 0x8C, 0x97 },
	0x8855, { 0xEF, 0x8C, 0x98 },
	0x8856, { 0xC4, 0x80 },
	0x8857, { 0xC3, 0x81 },
	0x8858, { 0xC7, 0x8D },
	0x8859, { 0xC3, 0x80 },
	0x885a, { 0xC4, 0x92 },
	0x885b, { 0xC3, 0x89 },
	0x885c, { 0xC4, 0x9A },
	0x885d, { 0xC3, 0x88 },
	0x885e, { 0xC5, 0x8C },
	0x885f, { 0xC3, 0x93 },
	0x8860, { 0xC7, 0x91 },
	0x8861, { 0xC3, 0x92 },
	0x8862, { 0xEF, 0x8C, 0xA5 },
	0x8863, { 0xE1, 0xBA, 0xBE },
	0x8864, { 0xEF, 0x8C, 0xA7 },
	0x8865, { 0xE1, 0xBB, 0x80 },
	0x8866, { 0xC3, 0x8A },
	0x8867, { 0xC4, 0x81 },
	0x8868, { 0xC3, 0xA1 },
	0x8869, { 0xC7, 0x8E },
	0x886a, { 0xC3, 0xA0 },
	0x886b, { 0xC9, 0x91 },
	0x886c, { 0xC4, 0x93 },
	0x886d, { 0xC3, 0xA9 },
	0x886e, { 0xC4, 0x9B },
	0x886f, { 0xC3, 0xA8 },
	0x8870, { 0xC4, 0xAB },
	0x8871, { 0xC3, 0xAD },
	0x8872, { 0xC7, 0x90 },
	0x8873, { 0xC3, 0xAC },
	0x8874, { 0xC5, 0x8D },
	0x8875, { 0xC3, 0xB3 },
	0x8876, { 0xC7, 0x92 },
	0x8877, { 0xC3, 0xB2 },
	0x8878, { 0xC5, 0xAB },
	0x8879, { 0xC3, 0xBA },
	0x887a, { 0xC7, 0x94 },
	0x887b, { 0xC3, 0xB9 },
	0x887c, { 0xC7, 0x96 },
	0x887d, { 0xC7, 0x98 },
	0x887e, { 0xC7, 0x9A },
	0x88a1, { 0xC7, 0x9C },
	0x88a2, { 0xC3, 0xBC },
	0x88a3, { 0xEF, 0x8D, 0x84 },
	0x88a4, { 0xE1, 0xBA, 0xBF },
	0x88a5, { 0xEF, 0x8D, 0x86 },
	0x88a6, { 0xE1, 0xBB, 0x81 },
	0x88a7, { 0xC3, 0xAA },
	0x88a8, { 0xC9, 0xA1 },
	0x88a9, { 0xEF, 0x8D, 0x8A },
	0x88aa, { 0xEF, 0x8D, 0x8B },
	0x8940, { 0xEF, 0x8E, 0xA0 },
	0x8941, { 0xEF, 0x8E, 0xA1 },
	0x8943, { 0xE6, 0x94, 0x8A },
	0x8946, { 0xE4, 0xB8, 0xBD },
	0x8947, { 0xE6, 0xBB, 0x9D },
	0x8948, { 0xE9, 0xB5, 0x8E },
	0x8949, { 0xE9, 0x87, 0x9F },
	0x894c, { 0xEF, 0x8E, 0xAC },
	0x894d, { 0xE6, 0x92, 0x91 },
	0x894e, { 0xE4, 0xBC, 0x9A },
	0x894f, { 0xE4, 0xBC, 0xA8 },
	0x8950, { 0xE4, 0xBE, 0xA8 },
	0x8951, { 0xE5, 0x85, 0x96 },
	0x8952, { 0xE5, 0x85, 0xB4 },
	0x8953, { 0xE5, 0x86, 0x9C },
	0x8954, { 0xE5, 0x87, 0xA4 },
	0x8955, { 0xE5, 0x8A, 0xA1 },
	0x8956, { 0xE5, 0x8A, 0xA8 },
	0x8957, { 0xE5, 0x8C, 0xBB },
	0x8958, { 0xE5, 0x8D, 0x8E },
	0x8959, { 0xE5, 0x8F, 0x91 },
	0x895a, { 0xE5, 0x8F, 0x98 },
	0x895b, { 0xE5, 0x9B, 0xA2 },
	0x895c, { 0xE5, 0xA3, 0xB0 },
	0x895d, { 0xE5, 0xA4, 0x84 },
	0x895e, { 0xE5, 0xA4, 0x87 },
	0x895f, { 0xE5, 0xA4, 0xB2 },
	0x8960, { 0xE5, 0xA4, 0xB4 },
	0x8961, { 0xE5, 0xAD, 0xA6 },
	0x8962, { 0xE5, 0xAE, 0x9E },
	0x8963, { 0xE5, 0xAE, 0x9F },
	0x8964, { 0xE5, 0xB2, 0x9A },
	0x8965, { 0xE5, 0xBA, 0x86 },
	0x8966, { 0xE6, 0x80, 0xBB },
	0x8967, { 0xE6, 0x96, 0x89 },
	0x8968, { 0xE6, 0x9F, 0xBE },
	0x8969, { 0xE6, 0xA0, 0x84 },
	0x896a, { 0xE6, 0xA1, 0xA5 },
	0x896b, { 0xE6, 0xB5, 0x8E },
	0x896c, { 0xE7, 0x82, 0xBC },
	0x896d, { 0xE7, 0x94, 0xB5 },
	0x896e, { 0xE7, 0xBA, 0xA4 },
	0x896f, { 0xE7, 0xBA, 0xAC },
	0x8970, { 0xE7, 0xBA, 0xBA },
	0x8971, { 0xE7, 0xBB, 0x87 },
	0x8972, { 0xE7, 0xBB, 0x8F },
	0x8973, { 0xE7, 0xBB, 0x9F },
	0x8974, { 0xE7, 0xBC, 0x86 },
	0x8975, { 0xE7, 0xBC, 0xB7 },
	0x8976, { 0xE8, 0x89, 0xBA },
	0x8977, { 0xE8, 0x8B, 0x8F },
	0x8978, { 0xE8, 0x8D, 0xAF },
	0x8979, { 0xE8, 0xA7, 0x86 },
	0x897a, { 0xE8, 0xAE, 0xBE },
	0x897b, { 0xE8, 0xAF, 0xA2 },
	0x897c, { 0xE8, 0xBD, 0xA6 },
	0x897d, { 0xE8, 0xBD, 0xA7 },
	0x897e, { 0xE8, 0xBD, 0xAE },
	0x89a1, { 0xE7, 0x90, 0x91 },
	0x89a2, { 0xE7, 0xB3, 0xBC },
	0x89a3, { 0xE7, 0xB7, 0x8D },
	0x89a4, { 0xE6, 0xA5, 0x86 },
	0x89a5, { 0xE7, 0xAB, 0x89 },
	0x89a6, { 0xE5, 0x88, 0xA7 },
	0x89ab, { 0xE9, 0x86, 0x8C },
	0x89ac, { 0xE7, 0xA2, 0xB8 },
	0x89ad, { 0xE9, 0x85, 0x9E },
	0x89ae, { 0xE8, 0x82, 0xBC },
	0x89b0, { 0xE8, 0xB4, 0x8B },
	0x89b1, { 0xE8, 0x83, 0xB6 },
	0x89b2, { 0xEF, 0x8F, 0xB0 },
	0x89b5, { 0xE8, 0x82, 0x9F },
	0x89b6, { 0xE9, 0xBB, 0x87 },
	0x89b7, { 0xE4, 0xB3, 0x8D },
	0x89b8, { 0xE9, 0xB7, 0x89 },
	0x89b9, { 0xE9, 0xB8, 0x8C },
	0x89ba, { 0xE4, 0xB0, 0xBE },
	0x89bb, { 0xEF, 0x8F, 0xB9 },
	0x89bc, { 0xEF, 0x8F, 0xBA },
	0x89bd, { 0xE9, 0xB8, 0x8A },
	0x89be, { 0xEF, 0x8F, 0xBC },
	0x89bf, { 0xE3, 0x97, 0x81 },
	0x89c1, { 0xE6, 0xBA, 0x9A },
	0x89c2, { 0xE8, 0x88, 0xBE },
	0x89c3, { 0xE7, 0x94, 0x99 },
	0x89c5, { 0xE4, 0xA4, 0x91 },
	0x89c6, { 0xE9, 0xA9, 0xAC },
	0x89c7, { 0xE9, 0xAA, 0x8F },
	0x89c8, { 0xE9, 0xBE, 0x99 },
	0x89c9, { 0xE7, 0xA6, 0x87 },
	0x89ca, { 0xEF, 0x90, 0x88 },
	0x89cb, { 0xEF, 0x90, 0x89 },
	0x89cc, { 0xEF, 0x90, 0x8A },
	0x89cd, { 0xEF, 0x90, 0x8B },
	0x89ce, { 0xE4, 0xB8, 0xA4 },
	0x89cf, { 0xE4, 0xBA, 0x81 },
	0x89d0, { 0xE4, 0xBA, 0x80 },
	0x89d1, { 0xE4, 0xBA, 0x87 },
	0x89d2, { 0xE4, 0xBA, 0xBF },
	0x89d3, { 0xE4, 0xBB, 0xAB },
	0x89d4, { 0xE4, 0xBC, 0xB7 },
	0x89d5, { 0xE3, 0x91, 0x8C },
	0x89d6, { 0xE4, 0xBE, 0xBD },
	0x89d7, { 0xE3, 0xB9, 0x88 },
	0x89d8, { 0xE5, 0x80, 0x83 },
	0x89d9, { 0xE5, 0x82, 0x88 },
	0x89da, { 0xE3, 0x91, 0xBD },
	0x89db, { 0xE3, 0x92, 0x93 },
	0x89dc, { 0xE3, 0x92, 0xA5 },
	0x89dd, { 0xE5, 0x86, 0x86 },
	0x89de, { 0xE5, 0xA4, 0x85 },
	0x89df, { 0xE5, 0x87, 0x9B },
	0x89e0, { 0xE5, 0x87, 0xBC },
	0x89e1, { 0xE5, 0x88, 0x85 },
	0x89e2, { 0xE4, 0xBA, 0x89 },
	0x89e3, { 0xE5, 0x89, 0xB9 },
	0x89e4, { 0xE5, 0x8A, 0x90 },
	0x89e5, { 0xE5, 0x8C, 0xA7 },
	0x89e6, { 0xE3, 0x97, 0x87 },
	0x89e7, { 0xE5, 0x8E, 0xA9 },
	0x89e8, { 0xE3, 0x95, 0x91 },
	0x89e9, { 0xE5, 0x8E, 0xB0 },
	0x89ea, { 0xE3, 0x95, 0x93 },
	0x89eb, { 0xE5, 0x8F, 0x82 },
	0x89ec, { 0xE5, 0x90, 0xA3 },
	0x89ed, { 0xE3, 0x95, 0xAD },
	0x89ee, { 0xE3, 0x95, 0xB2 },
	0x89ef, { 0xE3, 0x9A, 0x81 },
	0x89f0, { 0xE5, 0x92, 0x93 },
	0x89f1, { 0xE5, 0x92, 0xA3 },
	0x89f2, { 0xE5, 0x92, 0xB4 },
	0x89f3, { 0xE5, 0x92, 0xB9 },
	0x89f4, { 0xE5, 0x93, 0x90 },
	0x89f5, { 0xE5, 0x93, 0xAF },
	0x89f6, { 0xE5, 0x94, 0x98 },
	0x89f7, { 0xE5, 0x94, 0xA3 },
	0x89f8, { 0xE5, 0x94, 0xA8 },
	0x89f9, { 0xE3, 0x96, 0x98 },
	0x89fa, { 0xE5, 0x94, 0xBF },
	0x89fb, { 0xE3, 0x96, 0xA5 },
	0x89fc, { 0xE3, 0x96, 0xBF },
	0x89fd, { 0xE5, 0x97, 0x97 },
	0x89fe, { 0xE3, 0x97, 0x85 },
	0x8a40, { 0xEF, 0x90, 0xBD },
	0x8a41, { 0xE5, 0x94, 0xA5 },
	0x8a43, { 0xEF, 0x91, 0x80 },
	0x8a44, { 0xEF, 0x91, 0x81 },
	0x8a45, { 0xEF, 0x91, 0x82 },
	0x8a46, { 0xE5, 0x96, 0x90 },
	0x8a47, { 0xEF, 0x91, 0x84 },
	0x8a48, { 0xE3, 0xA7, 0xAC },
	0x8a49, { 0xEF, 0x91, 0x86 },
	0x8a4a, { 0xE8, 0xB9, 0x86 },
	0x8a4b, { 0xEF, 0x91, 0x88 },
	0x8a4c, { 0xEF, 0x91, 0x89 },
	0x8a4d, { 0xE4, 0x81, 0x93 },
	0x8a4e, { 0xEF, 0x91, 0x8B },
	0x8a4f, { 0xE7, 0x9D, 0xBA },
	0x8a50, { 0xEF, 0x91, 0x8D },
	0x8a51, { 0xE3, 0xA8, 0xB4 },
	0x8a52, { 0xE4, 0x9F, 0x95 },
	0x8a53, { 0xEF, 0x91, 0x90 },
	0x8a54, { 0xEF, 0x91, 0x91 },
	0x8a55, { 0xEF, 0x91, 0x92 },
	0x8a56, { 0xE6, 0x93, 0x9D },
	0x8a57, { 0xEF, 0x91, 0x94 },
	0x8a58, { 0xEF, 0x91, 0x95 },
	0x8a59, { 0xEF, 0x91, 0x96 },
	0x8a5a, { 0xEF, 0x91, 0x97 },
	0x8a5b, { 0xE6, 0x92, 0x8D },
	0x8a5c, { 0xE8, 0xB9, 0xBE },
	0x8a5d, { 0xEF, 0x91, 0x9A },
	0x8a5e, { 0xEF, 0x91, 0x9B },
	0x8a5f, { 0xEF, 0x91, 0x9C },
	0x8a60, { 0xEF, 0x91, 0x9D },
	0x8a61, { 0xEF, 0x91, 0x9E },
	0x8a62, { 0xEF, 0x91, 0x9F },
	0x8a64, { 0xEF, 0x91, 0xA1 },
	0x8a65, { 0xEF, 0x91, 0xA2 },
	0x8a66, { 0xEF, 0x91, 0xA3 },
	0x8a67, { 0xE4, 0x9F, 0xB4 },
	0x8a68, { 0xEF, 0x91, 0xA5 },
	0x8a69, { 0xEF, 0x91, 0xA6 },
	0x8a6a, { 0xE9, 0xAA, 0xB2 },
	0x8a6b, { 0xE3, 0xA9, 0xA7 },
	0x8a6c, { 0xEF, 0x91, 0xA9 },
	0x8a6d, { 0xE3, 0xBF, 0xAD },
	0x8a6e, { 0xE3, 0x94, 0x86 },
	0x8a6f, { 0xEF, 0x91, 0xAC },
	0x8a70, { 0xEF, 0x91, 0xAD },
	0x8a71, { 0xEF, 0x91, 0xAE },
	0x8a72, { 0xEF, 0x91, 0xAF },
	0x8a73, { 0xE9, 0xB5, 0xAE },
	0x8a74, { 0xE9, 0xA0, 0x95 },
	0x8a76, { 0xE4, 0x8F, 0x99 },
	0x8a77, { 0xEF, 0x91, 0xB4 },
	0x8a78, { 0xE6, 0x92, 0xB4 },
	0x8a79, { 0xE5, 0x93, 0xA3 },
	0x8a7a, { 0xEF, 0x91, 0xB7 },
	0x8a7b, { 0xEF, 0x91, 0xB8 },
	0x8a7c, { 0xEF, 0x91, 0xB9 },
	0x8a7d, { 0xE3, 0xA7, 0xBB },
	0x8a7e, { 0xEF, 0x91, 0xBB },
	0x8aa1, { 0xEF, 0x91, 0xBC },
	0x8aa2, { 0xEF, 0x91, 0xBD },
	0x8aa3, { 0xEF, 0x91, 0xBE },
	0x8aa4, { 0xE6, 0x93, 0xAA },
	0x8aa5, { 0xEF, 0x92, 0x80 },
	0x8aa6, { 0xEF, 0x92, 0x81 },
	0x8aa7, { 0xE8, 0xB9, 0xA8 },
	0x8aa8, { 0xEF, 0x92, 0x83 },
	0x8aa9, { 0xEF, 0x92, 0x84 },
	0x8aaa, { 0xEF, 0x92, 0x85 },
	0x8aac, { 0xE4, 0xA0, 0x8B },
	0x8aad, { 0xEF, 0x92, 0x88 },
	0x8aae, { 0xE3, 0xBF, 0xBA },
	0x8aaf, { 0xE5, 0xA1, 0xB3 },
	0x8ab0, { 0xEF, 0x92, 0x8B },
	0x8ab2, { 0xEF, 0x92, 0x8D },
	0x8ab3, { 0xEF, 0x92, 0x8E },
	0x8ab4, { 0xEF, 0x92, 0x8F },
	0x8ab5, { 0xEF, 0x92, 0x90 },
	0x8ab6, { 0xEF, 0x92, 0x91 },
	0x8ab7, { 0xE5, 0x95, 0xB9 },
	0x8ab8, { 0xE4, 0x82, 0xBB },
	0x8ab9, { 0xE4, 0x8E, 0xBA },
	0x8abb, { 0xE4, 0xAA, 0xB4 },
	0x8abc, { 0xEF, 0x92, 0x97 },
	0x8abd, { 0xEF, 0x92, 0x98 },
	0x8abe, { 0xE8, 0x86, 0xAA },
	0x8abf, { 0xE9, 0xA3, 0xB5 },
	0x8ac0, { 0xEF, 0x92, 0x9B },
	0x8ac1, { 0xE6, 0x8D, 0xB9 },
	0x8ac2, { 0xE3, 0xA7, 0xBE },
	0x8ac3, { 0xEF, 0x92, 0x9E },
	0x8ac4, { 0xE8, 0xB7, 0x80 },
	0x8ac5, { 0xE5, 0x9A, 0xA1 },
	0x8ac6, { 0xE6, 0x91, 0xBC },
	0x8ac7, { 0xE3, 0xB9, 0x83 },
	0x8ac9, { 0xEF, 0x92, 0xA4 },
	0x8aca, { 0xEF, 0x92, 0xA5 },
	0x8acb, { 0xEF, 0x92, 0xA6 },
	0x8acc, { 0xEF, 0x92, 0xA7 },
	0x8ace, { 0xEF, 0x92, 0xA9 },
	0x8acf, { 0xEF, 0x92, 0xAA },
	0x8ad0, { 0xE3, 0xA6, 0x92 },
	0x8ad1, { 0xE3, 0xA8, 0x86 },
	0x8ad2, { 0xEF, 0x92, 0xAD },
	0x8ad3, { 0xE3, 0x95, 0xB8 },
	0x8ad4, { 0xEF, 0x92, 0xAF },
	0x8ad5, { 0xEF, 0x92, 0xB0 },
	0x8ad6, { 0xE5, 0x99, 0x92 },
	0x8ad7, { 0xEF, 0x92, 0xB2 },
	0x8ad8, { 0xEF, 0x92, 0xB3 },
	0x8ad9, { 0xEF, 0x92, 0xB4 },
	0x8ada, { 0xE3, 0x92, 0xBC },
	0x8adb, { 0xE6, 0xB0, 0xBD },
	0x8adc, { 0xEF, 0x92, 0xB7 },
	0x8adf, { 0xEF, 0x92, 0xBA },
	0x8ae0, { 0xEF, 0x92, 0xBB },
	0x8ae1, { 0xEF, 0x92, 0xBC },
	0x8ae2, { 0xEF, 0x92, 0xBD },
	0x8ae3, { 0xEF, 0x92, 0xBE },
	0x8ae4, { 0xEF, 0x92, 0xBF },
	0x8ae5, { 0xEF, 0x93, 0x80 },
	0x8ae6, { 0xEF, 0x93, 0x81 },
	0x8ae7, { 0xE7, 0xBE, 0x93 },
	0x8ae8, { 0xEF, 0x93, 0x83 },
	0x8ae9, { 0xEF, 0x93, 0x84 },
	0x8aea, { 0xEF, 0x93, 0x85 },
	0x8aeb, { 0xE3, 0x97, 0xBB },
	0x8aec, { 0xEF, 0x93, 0x87 },
	0x8aed, { 0xEF, 0x93, 0x88 },
	0x8aee, { 0xEF, 0x93, 0x89 },
	0x8aef, { 0xEF, 0x93, 0x8A },
	0x8af0, { 0xE3, 0xBE, 0x93 },
	0x8af1, { 0xEF, 0x93, 0x8C },
	0x8af2, { 0xEF, 0x93, 0x8D },
	0x8af3, { 0xEF, 0x93, 0x8E },
	0x8af4, { 0xEF, 0x93, 0x8F },
	0x8af6, { 0xEF, 0x93, 0x91 },
	0x8af7, { 0xEF, 0x93, 0x92 },
	0x8af8, { 0xEF, 0x93, 0x93 },
	0x8af9, { 0xEF, 0x93, 0x94 },
	0x8afa, { 0xEF, 0x93, 0x95 },
	0x8afb, { 0xE3, 0xBF, 0xB9 },
	0x8afc, { 0xEF, 0x93, 0x97 },
	0x8afd, { 0xE6, 0x90, 0xB2 },
	0x8afe, { 0xEF, 0x93, 0x99 },
	0x8b40, { 0xEF, 0x93, 0x9A },
	0x8b41, { 0xEF, 0x93, 0x9B },
	0x8b42, { 0xEF, 0x93, 0x9C },
	0x8b43, { 0xEF, 0x93, 0x9D },
	0x8b44, { 0xEF, 0x93, 0x9E },
	0x8b45, { 0xEF, 0x93, 0x9F },
	0x8b46, { 0xEF, 0x93, 0xA0 },
	0x8b47, { 0xE3, 0xA8, 0x98 },
	0x8b48, { 0xEF, 0x93, 0xA2 },
	0x8b49, { 0xEF, 0x93, 0xA3 },
	0x8b4a, { 0xEF, 0x93, 0xA4 },
	0x8b4b, { 0xEF, 0x93, 0xA5 },
	0x8b4c, { 0xEF, 0x93, 0xA6 },
	0x8b4d, { 0xEF, 0x93, 0xA7 },
	0x8b4e, { 0xEF, 0x93, 0xA8 },
	0x8b4f, { 0xEF, 0x93, 0xA9 },
	0x8b50, { 0xE9, 0x96, 0xAA },
	0x8b51, { 0xE5, 0x93, 0x8C },
	0x8b52, { 0xE8, 0x8B, 0x84 },
	0x8b53, { 0xE5, 0x96, 0xB9 },
	0x8b55, { 0xEF, 0x93, 0xAF },
	0x8b56, { 0xE9, 0xB0, 0xA6 },
	0x8b57, { 0xE9, 0xAA, 0xB6 },
	0x8b58, { 0xEF, 0x93, 0xB2 },
	0x8b59, { 0xEF, 0x93, 0xB3 },
	0x8b5a, { 0xE7, 0x85, 0x80 },
	0x8b5b, { 0xE8, 0x85, 0xAD },
	0x8b5c, { 0xE8, 0x83, 0xAC },
	0x8b5d, { 0xE5, 0xB0, 0x9C },
	0x8b5e, { 0xEF, 0x93, 0xB8 },
	0x8b5f, { 0xE8, 0x84, 0xB4 },
	0x8b60, { 0xE3, 0x9E, 0x97 },
	0x8b61, { 0xE5, 0x8D, 0x9F },
	0x8b62, { 0xEF, 0x93, 0xBC },
	0x8b63, { 0xE9, 0x86, 0xB6 },
	0x8b64, { 0xEF, 0x93, 0xBE },
	0x8b65, { 0xEF, 0x93, 0xBF },
	0x8b66, { 0xEF, 0x94, 0x80 },
	0x8b67, { 0xEF, 0x94, 0x81 },
	0x8b68, { 0xE3, 0x97, 0x9D },
	0x8b69, { 0xEF, 0x94, 0x83 },
	0x8b6a, { 0xE3, 0x98, 0x89 },
	0x8b6b, { 0xEF, 0x94, 0x85 },
	0x8b6c, { 0xE5, 0x9A, 0xAF },
	0x8b6d, { 0xEF, 0x94, 0x87 },
	0x8b6e, { 0xEF, 0x94, 0x88 },
	0x8b6f, { 0xEF, 0x94, 0x89 },
	0x8b70, { 0xEF, 0x94, 0x8A },
	0x8b71, { 0xEF, 0x94, 0x8B },
	0x8b72, { 0xEF, 0x94, 0x8C },
	0x8b73, { 0xEF, 0x94, 0x8D },
	0x8b74, { 0xEF, 0x94, 0x8E },
	0x8b75, { 0xEF, 0x94, 0x8F },
	0x8b76, { 0xEF, 0x94, 0x90 },
	0x8b77, { 0xEF, 0x94, 0x91 },
	0x8b78, { 0xE5, 0xA9, 0x94 },
	0x8b79, { 0xEF, 0x94, 0x93 },
	0x8b7a, { 0xEF, 0x94, 0x94 },
	0x8b7b, { 0xEF, 0x94, 0x95 },
	0x8b7c, { 0xEF, 0x94, 0x96 },
	0x8b7d, { 0xE5, 0x9E, 0x9C },
	0x8b7e, { 0xEF, 0x94, 0x98 },
	0x8ba1, { 0xEF, 0x94, 0x99 },
	0x8ba2, { 0xEF, 0x94, 0x9A },
	0x8ba3, { 0xEF, 0x94, 0x9B },
	0x8ba4, { 0xEF, 0x94, 0x9C },
	0x8ba5, { 0xEF, 0x94, 0x9D },
	0x8ba6, { 0xE3, 0x9C, 0x83 },
	0x8ba7, { 0xEF, 0x94, 0x9F },
	0x8ba8, { 0xEF, 0x94, 0xA0 },
	0x8ba9, { 0xEF, 0x94, 0xA1 },
	0x8baa, { 0xEF, 0x94, 0xA2 },
	0x8bab, { 0xEF, 0x94, 0xA3 },
	0x8bac, { 0xEF, 0x94, 0xA4 },
	0x8bad, { 0xEF, 0x94, 0xA5 },
	0x8bae, { 0xEF, 0x94, 0xA6 },
	0x8baf, { 0xE5, 0xA2, 0x99 },
	0x8bb0, { 0xE5, 0x89, 0xA8 },
	0x8bb1, { 0xE3, 0x98, 0x9A },
	0x8bb2, { 0xEF, 0x94, 0xAA },
	0x8bb3, { 0xE7, 0xAE, 0xB2 },
	0x8bb4, { 0xE5, 0xAD, 0xA8 },
	0x8bb5, { 0xE4, 0xA0, 0x80 },
	0x8bb6, { 0xE4, 0xAC, 0xAC },
	0x8bb7, { 0xE9, 0xBC, 0xA7 },
	0x8bb8, { 0xE4, 0xA7, 0xA7 },
	0x8bb9, { 0xE9, 0xB0, 0x9F },
	0x8bba, { 0xE9, 0xAE, 0x8D },
	0x8bbb, { 0xEF, 0x94, 0xB3 },
	0x8bbc, { 0xEF, 0x94, 0xB4 },
	0x8bbd, { 0xE5, 0x97, 0xBB },
	0x8bbe, { 0xE3, 0x97, 0xB2 },
	0x8bbf, { 0xE5, 0x9A, 0x89 },
	0x8bc0, { 0xE4, 0xB8, 0xA8 },
	0x8bc1, { 0xE5, 0xA4, 0x82 },
	0x8bc2, { 0xE5, 0xB0, 0xA2 },
	0x8bc3, { 0xEF, 0x94, 0xBB },
	0x8bc4, { 0xE9, 0x9D, 0x91 },
	0x8bc5, { 0xEF, 0x94, 0xBD },
	0x8bc6, { 0xE4, 0xB9, 0x9B },
	0x8bc7, { 0xE4, 0xBA, 0xBB },
	0x8bc8, { 0xE3, 0x94, 0xBE },
	0x8bc9, { 0xE5, 0xB0, 0xA3 },
	0x8bca, { 0xE5, 0xBD, 0x91 },
	0x8bcb, { 0xE5, 0xBF, 0x84 },
	0x8bcc, { 0xE3, 0xA3, 0xBA },
	0x8bcd, { 0xE6, 0x89, 0x8C },
	0x8bce, { 0xE6, 0x94, 0xB5 },
	0x8bcf, { 0xE6, 0xAD, 0xBA },
	0x8bd0, { 0xE6, 0xB0, 0xB5 },
	0x8bd1, { 0xE6, 0xB0, 0xBA },
	0x8bd2, { 0xE7, 0x81, 0xAC },
	0x8bd3, { 0xE7, 0x88, 0xAB },
	0x8bd4, { 0xE4, 0xB8, 0xAC },
	0x8bd5, { 0xE7, 0x8A, 0xAD },
	0x8bd6, { 0xEF, 0x95, 0x8E },
	0x8bd7, { 0xE7, 0xBD, 0x92 },
	0x8bd8, { 0xE7, 0xA4, 0xBB },
	0x8bd9, { 0xE7, 0xB3, 0xB9 },
	0x8bda, { 0xE7, 0xBD, 0x93 },
	0x8bdb, { 0xEF, 0x95, 0x93 },
	0x8bdc, { 0xE3, 0x93, 0x81 },
	0x8bde, { 0xEF, 0x95, 0x96 },
	0x8bdf, { 0xE8, 0x80, 0x82 },
	0x8be0, { 0xE8, 0x82, 0x80 },
	0x8be1, { 0xEF, 0x95, 0x99 },
	0x8be2, { 0xEF, 0x95, 0x9A },
	0x8be3, { 0xE5, 0x8D, 0x9D },
	0x8be4, { 0xE8, 0xA1, 0xA4 },
	0x8be5, { 0xE8, 0xA7, 0x81 },
	0x8be6, { 0xEF, 0x95, 0x9E },
	0x8be7, { 0xE8, 0xAE, 0xA0 },
	0x8be8, { 0xE8, 0xB4, 0x9D },
	0x8be9, { 0xE9, 0x92, 0x85 },
	0x8bea, { 0xE9, 0x95, 0xB8 },
	0x8beb, { 0xE9, 0x95, 0xBF },
	0x8bec, { 0xE9, 0x97, 0xA8 },
	0x8bed, { 0xEF, 0x95, 0xA5 },
	0x8bee, { 0xE9, 0x9F, 0xA6 },
	0x8bef, { 0xE9, 0xA1, 0xB5 },
	0x8bf0, { 0xE9, 0xA3, 0x8E },
	0x8bf1, { 0xE9, 0xA3, 0x9E },
	0x8bf2, { 0xE9, 0xA5, 0xA3 },
	0x8bf3, { 0xEF, 0x95, 0xAB },
	0x8bf4, { 0xE9, 0xB1, 0xBC },
	0x8bf5, { 0xE9, 0xB8, 0x9F },
	0x8bf6, { 0xE9, 0xBB, 0x84 },
	0x8bf7, { 0xE6, 0xAD, 0xAF },
	0x8bf8, { 0xE9, 0xBE, 0x9C },
	0x8bf9, { 0xE4, 0xB8, 0xB7 },
	0x8bfa, { 0xEF, 0x95, 0xB2 },
	0x8bfb, { 0xE9, 0x98, 0x9D },
	0x8bfc, { 0xE6, 0x88, 0xB7 },
	0x8bfd, { 0xE9, 0x92, 0xA2 },
	0x8c40, { 0xE5, 0x80, 0xBB },
	0x8c41, { 0xE6, 0xB7, 0xBE },
	0x8c42, { 0xEF, 0x95, 0xB9 },
	0x8c43, { 0xEF, 0x95, 0xBA },
	0x8c44, { 0xE3, 0xB7, 0x89 },
	0x8c45, { 0xE8, 0xA2, 0x8F },
	0x8c46, { 0xEF, 0x95, 0xBD },
	0x8c47, { 0xE7, 0x81, 0xB7 },
	0x8c48, { 0xE5, 0xB3, 0xB5 },
	0x8c49, { 0xE4, 0xAC, 0xA0 },
	0x8c4a, { 0xEF, 0x96, 0x81 },
	0x8c4b, { 0xE3, 0x95, 0x99 },
	0x8c4c, { 0xEF, 0x96, 0x83 },
	0x8c4d, { 0xE6, 0x84, 0xA2 },
	0x8c4e, { 0xEF, 0x96, 0x85 },
	0x8c4f, { 0xE8, 0xBE, 0xA7 },
	0x8c50, { 0xE9, 0x87, 0xB6 },
	0x8c51, { 0xE7, 0x86, 0x91 },
	0x8c52, { 0xE6, 0x9C, 0x99 },
	0x8c53, { 0xE7, 0x8E, 0xBA },
	0x8c54, { 0xEF, 0x96, 0x8B },
	0x8c55, { 0xEF, 0x96, 0x8C },
	0x8c56, { 0xE3, 0xB2, 0x8B },
	0x8c57, { 0xEF, 0x96, 0x8E },
	0x8c58, { 0xE4, 0xAC, 0x90 },
	0x8c59, { 0xE7, 0xA3, 0xA4 },
	0x8c5a, { 0xE7, 0x90, 0x82 },
	0x8c5b, { 0xE5, 0x86, 0xAE },
	0x8c5c, { 0xEF, 0x96, 0x93 },
	0x8c5d, { 0xE4, 0x80, 0x89 },
	0x8c5e, { 0xE6, 0xA9, 0xA3 },
	0x8c5f, { 0xEF, 0x96, 0x96 },
	0x8c60, { 0xE4, 0x88, 0xA3 },
	0x8c61, { 0xE8, 0x98, 0x8F },
	0x8c62, { 0xEF, 0x96, 0x99 },
	0x8c63, { 0xE7, 0xA8, 0xAA },
	0x8c64, { 0xEF, 0x96, 0x9B },
	0x8c65, { 0xEF, 0x96, 0x9C },
	0x8c66, { 0xE9, 0x9D, 0x95 },
	0x8c67, { 0xE7, 0x81, 0x8D },
	0x8c68, { 0xE5, 0x8C, 0xA4 },
	0x8c69, { 0xEF, 0x96, 0xA0 },
	0x8c6a, { 0xE9, 0x8F, 0xB4 },
	0x8c6b, { 0xE7, 0x9B, 0x99 },
	0x8c6c, { 0xEF, 0x96, 0xA3 },
	0x8c6d, { 0xEF, 0x96, 0xA4 },
	0x8c6e, { 0xE7, 0x9F, 0x9D },
	0x8c6f, { 0xE4, 0xBA, 0xA3 },
	0x8c70, { 0xE4, 0xBF, 0xB0 },
	0x8c71, { 0xE5, 0x82, 0xBC },
	0x8c72, { 0xE4, 0xB8, 0xAF },
	0x8c73, { 0xE4, 0xBC, 0x97 },
	0x8c74, { 0xEF, 0x96, 0xAB },
	0x8c75, { 0xE5, 0x90, 0xB4 },
	0x8c76, { 0xE7, 0xB6, 0x8B },
	0x8c77, { 0xE5, 0xA2, 0x92 },
	0x8c78, { 0xE5, 0xA3, 0x90 },
	0x8c79, { 0xEF, 0x96, 0xB0 },
	0x8c7a, { 0xE5, 0xBA, 0x92 },
	0x8c7b, { 0xE5, 0xBA, 0x99 },
	0x8c7c, { 0xE5, 0xBF, 0x82 },
	0x8c7d, { 0xEF, 0x96, 0xB4 },
	0x8c7e, { 0xE6, 0x96, 0x8B },
	0x8ca1, { 0xEF, 0x96, 0xB6 },
	0x8ca2, { 0xE6, 0xA4, 0x99 },
	0x8ca3, { 0xE6, 0xA9, 0x83 },
	0x8ca4, { 0xEF, 0x96, 0xB9 },
	0x8ca5, { 0xE6, 0xB3, 0xBF },
	0x8ca6, { 0xEF, 0x96, 0xBB },
	0x8ca7, { 0xE7, 0x88, 0x80 },
	0x8ca8, { 0xEF, 0x96, 0xBD },
	0x8ca9, { 0xE7, 0x8E, 0x8C },
	0x8caa, { 0xE3, 0xBB, 0x9B },
	0x8cab, { 0xEF, 0x97, 0x80 },
	0x8cac, { 0xE5, 0xAC, 0x95 },
	0x8cad, { 0xE7, 0x92, 0xB9 },
	0x8cae, { 0xE8, 0xAE, 0x83 },
	0x8caf, { 0xEF, 0x97, 0x84 },
	0x8cb0, { 0xEF, 0x97, 0x85 },
	0x8cb1, { 0xE7, 0xAA, 0x93 },
	0x8cb2, { 0xE7, 0xAF, 0xAC },
	0x8cb3, { 0xE7, 0xB3, 0x83 },
	0x8cb4, { 0xE7, 0xB9, 0xAC },
	0x8cb5, { 0xE8, 0x8B, 0xB8 },
	0x8cb6, { 0xE8, 0x96, 0x97 },
	0x8cb7, { 0xEF, 0x97, 0x8C },
	0x8cb8, { 0xE8, 0xA2, 0x90 },
	0x8cb9, { 0xEF, 0x97, 0x8E },
	0x8cba, { 0xE8, 0xBA, 0xB9 },
	0x8cbb, { 0xEF, 0x97, 0x90 },
	0x8cbc, { 0xE8, 0xBF, 0x8F },
	0x8cbd, { 0xE8, 0x95, 0x9F },
	0x8cbe, { 0xE9, 0xA7, 0xA0 },
	0x8cbf, { 0xE9, 0x88, 0xA1 },
	0x8cc0, { 0xEF, 0x97, 0x95 },
	0x8cc1, { 0xEF, 0x97, 0x96 },
	0x8cc2, { 0xEF, 0x97, 0x97 },
	0x8cc3, { 0xE4, 0x81, 0xB1 },
	0x8cc4, { 0xE4, 0x8A, 0xA2 },
	0x8cc5, { 0xE5, 0xA8, 0x9A },
	0x8cc6, { 0xEF, 0x97, 0x9B },
	0x8cc7, { 0xEF, 0x97, 0x9C },
	0x8cc8, { 0xEF, 0x97, 0x9D },
	0x8cc9, { 0xE9, 0xA1, 0xA8 },
	0x8cca, { 0xE6, 0x9D, 0xAB },
	0x8ccb, { 0xE4, 0x89, 0xB6 },
	0x8ccc, { 0xE5, 0x9C, 0xBD },
	0x8ccd, { 0xEF, 0x97, 0xA2 },
	0x8cce, { 0xE8, 0x97, 0x96 },
	0x8ccf, { 0xEF, 0x97, 0xA4 },
	0x8cd0, { 0xE8, 0x8A, 0xBF },
	0x8cd1, { 0xEF, 0x97, 0xA6 },
	0x8cd2, { 0xE4, 0xB2, 0x81 },
	0x8cd3, { 0xEF, 0x97, 0xA8 },
	0x8cd4, { 0xE5, 0xB5, 0xBB },
	0x8cd5, { 0xEF, 0x97, 0xAA },
	0x8cd6, { 0xEF, 0x97, 0xAB },
	0x8cd7, { 0xEF, 0x97, 0xAC },
	0x8cd8, { 0xEF, 0x97, 0xAD },
	0x8cd9, { 0xE5, 0xAE, 0x96 },
	0x8cda, { 0xEF, 0x97, 0xAF },
	0x8cdb, { 0xEF, 0x97, 0xB0 },
	0x8cdc, { 0xE7, 0xB9, 0x9B },
	0x8cdd, { 0xEF, 0x97, 0xB2 },
	0x8cde, { 0xEF, 0x97, 0xB3 },
	0x8cdf, { 0xEF, 0x97, 0xB4 },
	0x8ce0, { 0xEF, 0x97, 0xB5 },
	0x8ce1, { 0xEF, 0x97, 0xB6 },
	0x8ce2, { 0xEF, 0x97, 0xB7 },
	0x8ce3, { 0xEF, 0x97, 0xB8 },
	0x8ce4, { 0xEF, 0x97, 0xB9 },
	0x8ce5, { 0xEF, 0x97, 0xBA },
	0x8ce6, { 0xEF, 0x97, 0xBB },
	0x8ce7, { 0xEF, 0x97, 0xBC },
	0x8ce8, { 0xEF, 0x97, 0xBD },
	0x8ce9, { 0xEF, 0x97, 0xBE },
	0x8cea, { 0xEF, 0x97, 0xBF },
	0x8ceb, { 0xEF, 0x98, 0x80 },
	0x8cec, { 0xEF, 0x98, 0x81 },
	0x8ced, { 0xEF, 0x98, 0x82 },
	0x8cee, { 0xEF, 0x98, 0x83 },
	0x8cef, { 0xEF, 0x98, 0x84 },
	0x8cf0, { 0xEF, 0x98, 0x85 },
	0x8cf1, { 0xEF, 0x98, 0x86 },
	0x8cf2, { 0xEF, 0x98, 0x87 },
	0x8cf3, { 0xEF, 0x98, 0x88 },
	0x8cf4, { 0xEF, 0x98, 0x89 },
	0x8cf5, { 0xEF, 0x98, 0x8A },
	0x8cf6, { 0xEF, 0x98, 0x8B },
	0x8cf7, { 0xEF, 0x98, 0x8C },
	0x8cf8, { 0xEF, 0x98, 0x8D },
	0x8cf9, { 0xEF, 0x98, 0x8E },
	0x8cfa, { 0xEF, 0x98, 0x8F },
	0x8cfb, { 0xEF, 0x98, 0x90 },
	0x8cfc, { 0xEF, 0x98, 0x91 },
	0x8cfd, { 0xEF, 0x98, 0x92 },
	0x8cfe, { 0xEF, 0x98, 0x93 },
	0x8d60, { 0xE5, 0xB4, 0xBE },
	0x8d61, { 0xE5, 0xB5, 0x88 },
	0x8d62, { 0xE5, 0xB5, 0x96 },
	0x8d63, { 0xE3, 0xB7, 0xBC },
	0x8d64, { 0xE3, 0xA0, 0x8F },
	0x8d65, { 0xE5, 0xB6, 0xA4 },
	0x8d66, { 0xE5, 0xB6, 0xB9 },
	0x8d67, { 0xE3, 0xA0, 0xA0 },
	0x8d68, { 0xE3, 0xA0, 0xB8 },
	0x8d69, { 0xE5, 0xB9, 0x82 },
	0x8d6a, { 0xE5, 0xBA, 0xBD },
	0x8d6b, { 0xE5, 0xBC, 0xA5 },
	0x8d6c, { 0xE5, 0xBE, 0x83 },
	0x8d6d, { 0xE3, 0xA4, 0x88 },
	0x8d6e, { 0xE3, 0xA4, 0x94 },
	0x8d6f, { 0xE3, 0xA4, 0xBF },
	0x8d70, { 0xE3, 0xA5, 0x8D },
	0x8d71, { 0xE6, 0x83, 0x97 },
	0x8d72, { 0xE6, 0x84, 0xBD },
	0x8d73, { 0xE5, 0xB3, 0xA5 },
	0x8d74, { 0xE3, 0xA6, 0x89 },
	0x8d75, { 0xE6, 0x86, 0xB7 },
	0x8d76, { 0xE6, 0x86, 0xB9 },
	0x8d77, { 0xE6, 0x87, 0x8F },
	0x8d78, { 0xE3, 0xA6, 0xB8 },
	0x8d79, { 0xE6, 0x88, 0xAC },
	0x8d7a, { 0xE6, 0x8A, 0x90 },
	0x8d7b, { 0xE6, 0x8B, 0xA5 },
	0x8d7c, { 0xE6, 0x8C, 0x98 },
	0x8d7d, { 0xE3, 0xA7, 0xB8 },
	0x8d7e, { 0xE5, 0x9A, 0xB1 },
	0x8da1, { 0xE3, 0xA8, 0x83 },
	0x8da2, { 0xE6, 0x8F, 0xA2 },
	0x8da3, { 0xE6, 0x8F, 0xBB },
	0x8da4, { 0xE6, 0x90, 0x87 },
	0x8da5, { 0xE6, 0x91, 0x9A },
	0x8da6, { 0xE3, 0xA9, 0x8B },
	0x8da7, { 0xE6, 0x93, 0x80 },
	0x8da8, { 0xE5, 0xB4, 0x95 },
	0x8da9, { 0xE5, 0x98, 0xA1 },
	0x8daa, { 0xE9, 0xBE, 0x9F },
	0x8dab, { 0xE3, 0xAA, 0x97 },
	0x8dac, { 0xE6, 0x96, 0x86 },
	0x8dad, { 0xE3, 0xAA, 0xBD },
	0x8dae, { 0xE6, 0x97, 0xBF },
	0x8daf, { 0xE6, 0x99, 0x93 },
	0x8db0, { 0xE3, 0xAB, 0xB2 },
	0x8db1, { 0xE6, 0x9A, 0x92 },
	0x8db2, { 0xE3, 0xAC, 0xA2 },
	0x8db3, { 0xE6, 0x9C, 0x96 },
	0x8db4, { 0xE3, 0xAD, 0x82 },
	0x8db5, { 0xE6, 0x9E, 0xA4 },
	0x8db6, { 0xE6, 0xA0, 0x80 },
	0x8db7, { 0xE3, 0xAD, 0x98 },
	0x8db8, { 0xE6, 0xA1, 0x8A },
	0x8db9, { 0xE6, 0xA2, 0x84 },
	0x8dba, { 0xE3, 0xAD, 0xB2 },
	0x8dbb, { 0xE3, 0xAD, 0xB1 },
	0x8dbc, { 0xE3, 0xAD, 0xBB },
	0x8dbd, { 0xE6, 0xA4, 0x89 },
	0x8dbe, { 0xE6, 0xA5, 0x83 },
	0x8dbf, { 0xE7, 0x89, 0x9C },
	0x8dc0, { 0xE6, 0xA5, 0xA4 },
	0x8dc1, { 0xE6, 0xA6, 0x9F },
	0x8dc2, { 0xE6, 0xA6, 0x85 },
	0x8dc3, { 0xE3, 0xAE, 0xBC },
	0x8dc4, { 0xE6, 0xA7, 0x96 },
	0x8dc5, { 0xE3, 0xAF, 0x9D },
	0x8dc6, { 0xE6, 0xA9, 0xA5 },
	0x8dc7, { 0xE6, 0xA9, 0xB4 },
	0x8dc8, { 0xE6, 0xA9, 0xB1 },
	0x8dc9, { 0xE6, 0xAA, 0x82 },
	0x8dca, { 0xE3, 0xAF, 0xAC },
	0x8dcb, { 0xE6, 0xAA, 0x99 },
	0x8dcc, { 0xE3, 0xAF, 0xB2 },
	0x8dcd, { 0xE6, 0xAA, 0xAB },
	0x8dce, { 0xE6, 0xAA, 0xB5 },
	0x8dcf, { 0xE6, 0xAB, 0x94 },
	0x8dd0, { 0xE6, 0xAB, 0xB6 },
	0x8dd1, { 0xE6, 0xAE, 0x81 },
	0x8dd2, { 0xE6, 0xAF, 0x81 },
	0x8dd3, { 0xE6, 0xAF, 0xAA },
	0x8dd4, { 0xE6, 0xB1, 0xB5 },
	0x8dd5, { 0xE6, 0xB2, 0xAA },
	0x8dd6, { 0xE3, 0xB3, 0x8B },
	0x8dd7, { 0xE6, 0xB4, 0x82 },
	0x8dd8, { 0xE6, 0xB4, 0x86 },
	0x8dd9, { 0xE6, 0xB4, 0xA6 },
	0x8dda, { 0xE6, 0xB6, 0x81 },
	0x8ddb, { 0xE3, 0xB3, 0xAF },
	0x8ddc, { 0xE6, 0xB6, 0xA4 },
	0x8ddd, { 0xE6, 0xB6, 0xB1 },
	0x8dde, { 0xE6, 0xB8, 0x95 },
	0x8ddf, { 0xE6, 0xB8, 0x98 },
	0x8de0, { 0xE6, 0xB8, 0xA9 },
	0x8de1, { 0xE6, 0xBA, 0x86 },
	0x8de2, { 0xEF, 0x9A, 0x94 },
	0x8de3, { 0xE6, 0xBA, 0xBB },
	0x8de4, { 0xE6, 0xBB, 0xA2 },
	0x8de5, { 0xE6, 0xBB, 0x9A },
	0x8de6, { 0xE9, 0xBD, 0xBF },
	0x8de7, { 0xE6, 0xBB, 0xA8 },
	0x8de8, { 0xE6, 0xBB, 0xA9 },
	0x8de9, { 0xE6, 0xBC, 0xA4 },
	0x8dea, { 0xE6, 0xBC, 0xB4 },
	0x8deb, { 0xE3, 0xB5, 0x86 },
	0x8dec, { 0xEF, 0x9A, 0x9E },
	0x8ded, { 0xE6, 0xBE, 0x81 },
	0x8dee, { 0xE6, 0xBE, 0xBE },
	0x8def, { 0xE3, 0xB5, 0xAA },
	0x8df0, { 0xE3, 0xB5, 0xB5 },
	0x8df1, { 0xE7, 0x86, 0xB7 },
	0x8df2, { 0xE5, 0xB2, 0x99 },
	0x8df3, { 0xE3, 0xB6, 0x8A },
	0x8df4, { 0xE7, 0x80, 0xAC },
	0x8df5, { 0xE3, 0xB6, 0x91 },
	0x8df6, { 0xE7, 0x81, 0x90 },
	0x8df7, { 0xE7, 0x81, 0x94 },
	0x8df8, { 0xE7, 0x81, 0xAF },
	0x8df9, { 0xE7, 0x81, 0xBF },
	0x8dfa, { 0xE7, 0x82, 0x89 },
	0x8dfb, { 0xEF, 0x9A, 0xAD },
	0x8dfc, { 0xE4, 0x8F, 0x81 },
	0x8dfd, { 0xE3, 0x97, 0xB1 },
	0x8dfe, { 0xEF, 0x9A, 0xB0 },
	0x8e40, { 0xEE, 0x8C, 0x91 },
	0x8e41, { 0xE5, 0x9E, 0xBE },
	0x8e42, { 0xEE, 0x8C, 0x93 },
	0x8e43, { 0xE7, 0x84, 0xBE },
	0x8e44, { 0xEE, 0x8C, 0x95 },
	0x8e45, { 0xE3, 0x99, 0x8E },
	0x8e46, { 0xE6, 0xA6, 0xA2 },
	0x8e47, { 0xEE, 0x8C, 0x98 },
	0x8e48, { 0xE5, 0xAD, 0xB4 },
	0x8e49, { 0xE7, 0xA9, 0x89 },
	0x8e4a, { 0xEE, 0x8C, 0x9B },
	0x8e4b, { 0xEE, 0x8C, 0x9C },
	0x8e4c, { 0xE7, 0xA9, 0xA5 },
	0x8e4d, { 0xE7, 0xA9, 0xBD },
	0x8e4e, { 0xEE, 0x8C, 0x9F },
	0x8e4f, { 0xE7, 0xAA, 0xBB },
	0x8e50, { 0xE7, 0xAA, 0xB0 },
	0x8e51, { 0xE7, 0xAB, 0x82 },
	0x8e52, { 0xE7, 0xAB, 0x83 },
	0x8e53, { 0xE7, 0x87, 0x91 },
	0x8e54, { 0xEE, 0x8C, 0xA5 },
	0x8e55, { 0xE4, 0x87, 0x8A },
	0x8e56, { 0xE7, 0xAB, 0x9A },
	0x8e57, { 0xE7, 0xAB, 0x9D },
	0x8e58, { 0xE7, 0xAB, 0xAA },
	0x8e59, { 0xE4, 0x87, 0xAF },
	0x8e5a, { 0xE5, 0x92, 0xB2 },
	0x8e5b, { 0xEE, 0x8C, 0xAC },
	0x8e5c, { 0xE7, 0xAC, 0x8B },
	0x8e5d, { 0xE7, 0xAD, 0x95 },
	0x8e5e, { 0xE7, 0xAC, 0xA9 },
	0x8e5f, { 0xEE, 0x8C, 0xB0 },
	0x8e60, { 0xEE, 0x8C, 0xB1 },
	0x8e61, { 0xE7, 0xAE, 0xA2 },
	0x8e62, { 0xE7, 0xAD, 0xAF },
	0x8e63, { 0xE8, 0x8E, 0x9C },
	0x8e64, { 0xEE, 0x8C, 0xB5 },
	0x8e65, { 0xEE, 0x8C, 0xB6 },
	0x8e66, { 0xE7, 0xAF, 0x90 },
	0x8e67, { 0xE8, 0x90, 0xA1 },
	0x8e68, { 0xE7, 0xAE, 0x92 },
	0x8e6a, { 0xEE, 0x8C, 0xBB },
	0x8e6b, { 0xE3, 0xB6, 0xAD },
	0x8e6c, { 0xEE, 0x8C, 0xBD },
	0x8e6d, { 0xE8, 0x92, 0x92 },
	0x8e6e, { 0xE7, 0xAF, 0xBA },
	0x8e70, { 0xE7, 0xB0, 0xB5 },
	0x8e71, { 0xEE, 0x8D, 0x82 },
	0x8e72, { 0xE7, 0xB1, 0x84 },
	0x8e73, { 0xE7, 0xB2, 0x83 },
	0x8e74, { 0xEE, 0x8D, 0x85 },
	0x8e75, { 0xE7, 0xB2, 0xA6 },
	0x8e76, { 0xE6, 0x99, 0xBD },
	0x8e77, { 0xEE, 0x8D, 0x88 },
	0x8e78, { 0xE7, 0xB3, 0x89 },
	0x8e79, { 0xE7, 0xB3, 0x87 },
	0x8e7a, { 0xE7, 0xB3, 0xA6 },
	0x8e7b, { 0xE7, 0xB1, 0xB4 },
	0x8e7c, { 0xE7, 0xB3, 0xB3 },
	0x8e7d, { 0xE7, 0xB3, 0xB5 },
	0x8ea1, { 0xE7, 0xB9, 0xA7 },
	0x8ea2, { 0xE4, 0x94, 0x9D },
	0x8ea3, { 0xEE, 0x8D, 0x92 },
	0x8ea4, { 0xE7, 0xB5, 0x9D },
	0x8ea5, { 0xEE, 0x8D, 0x94 },
	0x8ea6, { 0xE7, 0x92, 0x8D },
	0x8ea7, { 0xE7, 0xB6, 0x89 },
	0x8ea8, { 0xE7, 0xB6, 0xAB },
	0x8ea9, { 0xE7, 0x84, 0xB5 },
	0x8eaa, { 0xE7, 0xB6, 0xB3 },
	0x8eac, { 0xEE, 0x8D, 0x9B },
	0x8ead, { 0xEE, 0x8D, 0x9C },
	0x8eae, { 0xE7, 0xB7, 0xA4 },
	0x8eaf, { 0xE3, 0xB4, 0x93 },
	0x8eb0, { 0xE7, 0xB7, 0xB5 },
	0x8eb1, { 0xEE, 0x8D, 0xA0 },
	0x8eb2, { 0xE7, 0xB7, 0xA5 },
	0x8eb3, { 0xEE, 0x8D, 0xA2 },
	0x8eb5, { 0xEE, 0x8D, 0xA4 },
	0x8eb6, { 0xEE, 0x8D, 0xA5 },
	0x8eb7, { 0xE7, 0xB9, 0xAE },
	0x8eb8, { 0xE7, 0xBA, 0x92 },
	0x8eb9, { 0xE4, 0x8C, 0xAB },
	0x8eba, { 0xE9, 0x91, 0xAC },
	0x8ebb, { 0xE7, 0xB8, 0xA7 },
	0x8ebc, { 0xE7, 0xBD, 0x80 },
	0x8ebd, { 0xE7, 0xBD, 0x81 },
	0x8ebe, { 0xE7, 0xBD, 0x87 },
	0x8ebf, { 0xE7, 0xA4, 0xB6 },
	0x8ec0, { 0xEE, 0x8D, 0xAF },
	0x8ec1, { 0xE9, 0xA7, 0xA1 },
	0x8ec2, { 0xE7, 0xBE, 0x97 },
	0x8ec3, { 0xEE, 0x8D, 0xB2 },
	0x8ec4, { 0xE7, 0xBE, 0xA3 },
	0x8ec5, { 0xEE, 0x8D, 0xB4 },
	0x8ec6, { 0xEE, 0x8D, 0xB5 },
	0x8ec7, { 0xE4, 0x95, 0x9C },
	0x8ec8, { 0xEE, 0x8D, 0xB7 },
	0x8ec9, { 0xE4, 0x94, 0x83 },
	0x8eca, { 0xEE, 0x8D, 0xB9 },
	0x8ecb, { 0xE7, 0xBF, 0xBA },
	0x8ecc, { 0xEE, 0x8D, 0xBB },
	0x8ece, { 0xE8, 0x80, 0x88 },
	0x8ecf, { 0xE8, 0x80, 0x9D },
	0x8ed1, { 0xE8, 0x80, 0xAF },
	0x8ed2, { 0xEE, 0x8E, 0x81 },
	0x8ed3, { 0xEE, 0x8E, 0x82 },
	0x8ed4, { 0xE8, 0x80, 0xBB },
	0x8ed5, { 0xE8, 0x80, 0xBC },
	0x8ed6, { 0xE8, 0x81, 0xA1 },
	0x8ed7, { 0xEE, 0x8E, 0x86 },
	0x8ed8, { 0xE4, 0xA6, 0x89 },
	0x8ed9, { 0xEE, 0x8E, 0x88 },
	0x8eda, { 0xEE, 0x8E, 0x89 },
	0x8edb, { 0xEE, 0x8E, 0x8A },
	0x8edc, { 0xE6, 0x9C, 0xA5 },
	0x8edd, { 0xE8, 0x82, 0xA7 },
	0x8ede, { 0xEE, 0x8E, 0x8D },
	0x8edf, { 0xE8, 0x84, 0x87 },
	0x8ee0, { 0xE8, 0x84, 0x9A },
	0x8ee1, { 0xE5, 0xA2, 0xB0 },
	0x8ee2, { 0xEE, 0x8E, 0x91 },
	0x8ee3, { 0xE6, 0xB1, 0xBF },
	0x8ee4, { 0xEE, 0x8E, 0x93 },
	0x8ee5, { 0xEE, 0x8E, 0x94 },
	0x8ee6, { 0xE6, 0x93, 0xA7 },
	0x8ee7, { 0xEE, 0x8E, 0x96 },
	0x8ee8, { 0xE8, 0x88, 0x98 },
	0x8ee9, { 0xEE, 0x8E, 0x98 },
	0x8eea, { 0xE6, 0xA9, 0x93 },
	0x8eeb, { 0xEE, 0x8E, 0x9A },
	0x8eec, { 0xEE, 0x8E, 0x9B },
	0x8eed, { 0xE4, 0x91, 0xBA },
	0x8eee, { 0xE8, 0x88, 0xA9 },
	0x8eef, { 0xEE, 0x8E, 0x9E },
	0x8ef0, { 0xEE, 0x8E, 0x9F },
	0x8ef1, { 0xEE, 0x8E, 0xA0 },
	0x8ef2, { 0xE4, 0xBF, 0xB9 },
	0x8ef3, { 0xEE, 0x8E, 0xA2 },
	0x8ef4, { 0xE8, 0x93, 0xA2 },
	0x8ef5, { 0xE8, 0x8D, 0xA2 },
	0x8ef6, { 0xEE, 0x8E, 0xA5 },
	0x8ef7, { 0xEE, 0x8E, 0xA6 },
	0x8ef8, { 0xEE, 0x8E, 0xA7 },
	0x8ef9, { 0xEE, 0x8E, 0xA8 },
	0x8efa, { 0xEE, 0x8E, 0xA9 },
	0x8efb, { 0xE8, 0x8A, 0xAA },
	0x8efc, { 0xE6, 0xA4, 0x9B },
	0x8efd, { 0xEE, 0x8E, 0xAC },
	0x8efe, { 0xE4, 0x87, 0x9B },
	0x8f40, { 0xE8, 0x95, 0x8B },
	0x8f41, { 0xE8, 0x8B, 0x90 },
	0x8f42, { 0xE8, 0x8C, 0x9A },
	0x8f43, { 0xEE, 0x8E, 0xB1 },
	0x8f44, { 0xEE, 0x8E, 0xB2 },
	0x8f45, { 0xE3, 0x9B, 0x81 },
	0x8f46, { 0xEE, 0x8E, 0xB4 },
	0x8f47, { 0xEE, 0x8E, 0xB5 },
	0x8f48, { 0xE8, 0x89, 0xBB },
	0x8f49, { 0xE8, 0x8B, 0xA2 },
	0x8f4a, { 0xE8, 0x8C, 0x98 },
	0x8f4b, { 0xEE, 0x8E, 0xB9 },
	0x8f4c, { 0xEE, 0x8E, 0xBA },
	0x8f4d, { 0xEE, 0x8E, 0xBB },
	0x8f4e, { 0xEE, 0x8E, 0xBC },
	0x8f4f, { 0xEE, 0x8E, 0xBD },
	0x8f50, { 0xE3, 0xB6, 0xBF },
	0x8f51, { 0xE8, 0x8C, 0x9D },
	0x8f52, { 0xE5, 0x97, 0xAC },
	0x8f53, { 0xE8, 0x8E, 0x85 },
	0x8f54, { 0xE4, 0x94, 0x8B },
	0x8f55, { 0xEE, 0x8F, 0x83 },
	0x8f56, { 0xE8, 0x8E, 0xAC },
	0x8f58, { 0xE8, 0x8F, 0x93 },
	0x8f59, { 0xE3, 0x91, 0xBE },
	0x8f5a, { 0xEE, 0x8F, 0x88 },
	0x8f5b, { 0xE6, 0xA9, 0x97 },
	0x8f5c, { 0xE8, 0x95, 0x9A },
	0x8f5d, { 0xE3, 0x92, 0x96 },
	0x8f5e, { 0xEE, 0x8F, 0x8C },
	0x8f5f, { 0xEE, 0x8F, 0x8D },
	0x8f60, { 0xE8, 0x91, 0x98 },
	0x8f61, { 0xEE, 0x8F, 0x8F },
	0x8f62, { 0xE8, 0x91, 0xB1 },
	0x8f63, { 0xE3, 0xB7, 0x93 },
	0x8f64, { 0xE4, 0x93, 0xA4 },
	0x8f65, { 0xE6, 0xAA, 0xA7 },
	0x8f66, { 0xE8, 0x91, 0x8A },
	0x8f67, { 0xEE, 0x8F, 0x95 },
	0x8f68, { 0xE7, 0xA5, 0x98 },
	0x8f6a, { 0xEE, 0x8F, 0x98 },
	0x8f6b, { 0xEE, 0x8F, 0x99 },
	0x8f6c, { 0xEE, 0x8F, 0x9A },
	0x8f6d, { 0xE8, 0x93, 0x9E },
	0x8f6f, { 0xE8, 0x8E, 0x91 },
	0x8f70, { 0xE4, 0x92, 0xA0 },
	0x8f71, { 0xE8, 0x92, 0x93 },
	0x8f72, { 0xE8, 0x93, 0xA4 },
	0x8f73, { 0xEE, 0x8F, 0xA1 },
	0x8f74, { 0xE4, 0x89, 0x80 },
	0x8f75, { 0xEE, 0x8F, 0xA3 },
	0x8f76, { 0xE4, 0x95, 0x83 },
	0x8f77, { 0xE8, 0x94, 0xB4 },
	0x8f78, { 0xE5, 0xAB, 0xB2 },
	0x8f79, { 0xEE, 0x8F, 0xA7 },
	0x8f7a, { 0xE4, 0x94, 0xA7 },
	0x8f7b, { 0xE8, 0x95, 0xB3 },
	0x8f7c, { 0xE4, 0x94, 0x96 },
	0x8f7d, { 0xE6, 0x9E, 0xBF },
	0x8f7e, { 0xE8, 0x98, 0x96 },
	0x8fa1, { 0xEE, 0x8F, 0xAD },
	0x8fa2, { 0xEE, 0x8F, 0xAE },
	0x8fa3, { 0xE8, 0x97, 0x81 },
	0x8fa4, { 0xEE, 0x8F, 0xB0 },
	0x8fa5, { 0xE8, 0x98, 0x82 },
	0x8fa6, { 0xEE, 0x8F, 0xB2 },
	0x8fa7, { 0xEE, 0x8F, 0xB3 },
	0x8fa8, { 0xEE, 0x8F, 0xB4 },
	0x8fa9, { 0xE4, 0x95, 0xAA },
	0x8faa, { 0xE8, 0x98, 0xA8 },
	0x8fab, { 0xE3, 0x99, 0x88 },
	0x8fac, { 0xEE, 0x8F, 0xB8 },
	0x8fad, { 0xE5, 0x8F, 0xB7 },
	0x8fae, { 0xEE, 0x8F, 0xBA },
	0x8faf, { 0xE8, 0x99, 0xBE },
	0x8fb0, { 0xE8, 0x9D, 0xB1 },
	0x8fb1, { 0xEE, 0x8F, 0xBD },
	0x8fb2, { 0xE8, 0x9F, 0xAE },
	0x8fb3, { 0xEE, 0x8F, 0xBF },
	0x8fb4, { 0xE8, 0x9E, 0xB1 },
	0x8fb5, { 0xE8, 0x9F, 0x9A },
	0x8fb6, { 0xE8, 0xA0, 0x8F },
	0x8fb7, { 0xE5, 0x99, 0xA1 },
	0x8fb8, { 0xE8, 0x99, 0xAC },
	0x8fb9, { 0xE6, 0xA1, 0x96 },
	0x8fba, { 0xE4, 0x98, 0x8F },
	0x8fbb, { 0xE8, 0xA1, 0x85 },
	0x8fbc, { 0xE8, 0xA1, 0x86 },
	0x8fbd, { 0xEE, 0x90, 0x89 },
	0x8fbe, { 0xEE, 0x90, 0x8A },
	0x8fbf, { 0xEE, 0x90, 0x8B },
	0x8fc0, { 0xE8, 0xA1, 0x9E },
	0x8fc1, { 0xE8, 0xA2, 0x9C },
	0x8fc2, { 0xE4, 0x99, 0x9B },
	0x8fc3, { 0xE8, 0xA2, 0xB4 },
	0x8fc4, { 0xE8, 0xA2, 0xB5 },
	0x8fc5, { 0xE6, 0x8F, 0x81 },
	0x8fc6, { 0xE8, 0xA3, 0x85 },
	0x8fc7, { 0xE7, 0x9D, 0xB7 },
	0x8fc8, { 0xEE, 0x90, 0x94 },
	0x8fc9, { 0xE8, 0xA6, 0x87 },
	0x8fca, { 0xE8, 0xA6, 0x8A },
	0x8fcd, { 0xE8, 0xA6, 0xA7 },
	0x8fce, { 0xE8, 0xA6, 0xBC },
	0x8fcf, { 0xEE, 0x90, 0x9B },
	0x8fd0, { 0xE8, 0xA7, 0xA7 },
	0x8fd1, { 0xEE, 0x90, 0x9D },
	0x8fd2, { 0xEE, 0x90, 0x9E },
	0x8fd3, { 0xE8, 0xAA, 0x9C },
	0x8fd4, { 0xE7, 0x9E, 0x93 },
	0x8fd5, { 0xE9, 0x87, 0xBE },
	0x8fd6, { 0xE8, 0xAA, 0x90 },
	0x8fd7, { 0xEE, 0x90, 0xA3 },
	0x8fd8, { 0xE7, 0xAB, 0xA9 },
	0x8fd9, { 0xEE, 0x90, 0xA5 },
	0x8fda, { 0xEE, 0x90, 0xA6 },
	0x8fdb, { 0xE4, 0x9C, 0x93 },
	0x8fdc, { 0xEE, 0x90, 0xA8 },
	0x8fdd, { 0xE7, 0x85, 0xBC },
	0x8fde, { 0xE8, 0xAC, 0x8C },
	0x8fdf, { 0xE8, 0xAC, 0x9F },
	0x8fe0, { 0xEE, 0x90, 0xAC },
	0x8fe1, { 0xEE, 0x90, 0xAD },
	0x8fe2, { 0xE8, 0xAC, 0xBF },
	0x8fe3, { 0xE8, 0xAD, 0x8C },
	0x8fe4, { 0xE8, 0xAD, 0x8D },
	0x8fe5, { 0xE8, 0xAA, 0xA9 },
	0x8fe6, { 0xEE, 0x90, 0xB2 },
	0x8fe7, { 0xE8, 0xAE, 0x90 },
	0x8fe8, { 0xE8, 0xAE, 0x9B },
	0x8fe9, { 0xE8, 0xAA, 0xAF },
	0x8fea, { 0xEE, 0x90, 0xB6 },
	0x8feb, { 0xE4, 0x98, 0x95 },
	0x8fec, { 0xE8, 0xA1, 0x8F },
	0x8fed, { 0xE8, 0xB2, 0x9B },
	0x8fee, { 0xEE, 0x90, 0xBA },
	0x8fef, { 0xEE, 0x90, 0xBB },
	0x8ff0, { 0xEE, 0x90, 0xBC },
	0x8ff1, { 0xE3, 0x9C, 0xA5 },
	0x8ff2, { 0xEE, 0x90, 0xBE },
	0x8ff3, { 0xE8, 0xB3, 0x96 },
	0x8ff4, { 0xEE, 0x91, 0x80 },
	0x8ff5, { 0xEE, 0x91, 0x81 },
	0x8ff6, { 0xE8, 0xB4, 0x92 },
	0x8ff7, { 0xE8, 0xB4, 0x83 },
	0x8ff8, { 0xEE, 0x91, 0x84 },
	0x8ff9, { 0xE8, 0xB3, 0x9B },
	0x8ffa, { 0xE7, 0x81, 0x9C },
	0x8ffb, { 0xE8, 0xB4, 0x91 },
	0x8ffc, { 0xEE, 0x91, 0x88 },
	0x8ffd, { 0xE3, 0xBB, 0x90 },
	0x9040, { 0xE8, 0xB6, 0xA9 },
	0x9041, { 0xEE, 0x91, 0x8C },
	0x9042, { 0xEE, 0x91, 0x8D },
	0x9043, { 0xEE, 0x91, 0x8E },
	0x9044, { 0xE3, 0xAD, 0xBC },
	0x9045, { 0xEE, 0x91, 0x90 },
	0x9046, { 0xEE, 0x91, 0x91 },
	0x9047, { 0xE7, 0xAB, 0xA7 },
	0x9048, { 0xE8, 0xBA, 0xAD },
	0x9049, { 0xE8, 0xBA, 0xB6 },
	0x904a, { 0xE8, 0xBB, 0x83 },
	0x904b, { 0xE9, 0x8B, 0x94 },
	0x904c, { 0xE8, 0xBC, 0x99 },
	0x904d, { 0xE8, 0xBC, 0xAD },
	0x904e, { 0xEE, 0x91, 0x99 },
	0x904f, { 0xEE, 0x91, 0x9A },
	0x9050, { 0xE8, 0xBE, 0xA5 },
	0x9051, { 0xE9, 0x8C, 0x83 },
	0x9052, { 0xEE, 0x91, 0x9D },
	0x9053, { 0xEE, 0x91, 0x9E },
	0x9054, { 0xE8, 0xBE, 0xB3 },
	0x9055, { 0xE4, 0xA4, 0xAA },
	0x9056, { 0xEE, 0x91, 0xA1 },
	0x9057, { 0xEE, 0x91, 0xA2 },
	0x9058, { 0xEE, 0x91, 0xA3 },
	0x9059, { 0xE5, 0xBB, 0xB8 },
	0x905a, { 0xEE, 0x91, 0xA5 },
	0x905b, { 0xE8, 0xBF, 0xB9 },
	0x905c, { 0xEE, 0x91, 0xA7 },
	0x905d, { 0xEE, 0x91, 0xA8 },
	0x905e, { 0xEE, 0x91, 0xA9 },
	0x905f, { 0xEE, 0x91, 0xAA },
	0x9060, { 0xE3, 0xA6, 0x80 },
	0x9061, { 0xEE, 0x91, 0xAC },
	0x9062, { 0xE9, 0x80, 0xB7 },
	0x9063, { 0xEE, 0x91, 0xAE },
	0x9064, { 0xEE, 0x91, 0xAF },
	0x9065, { 0xE9, 0x81, 0xA1 },
	0x9066, { 0xEE, 0x91, 0xB1 },
	0x9067, { 0xEE, 0x91, 0xB2 },
	0x9068, { 0xE9, 0x82, 0xA8 },
	0x9069, { 0xEE, 0x91, 0xB4 },
	0x906a, { 0xE9, 0x83, 0x84 },
	0x906b, { 0xEE, 0x91, 0xB6 },
	0x906c, { 0xE9, 0x82, 0xAE },
	0x906e, { 0xE9, 0x85, 0xA7 },
	0x906f, { 0xE3, 0xAB, 0xB0 },
	0x9070, { 0xE9, 0x86, 0xA9 },
	0x9071, { 0xE9, 0x87, 0x84 },
	0x9072, { 0xE7, 0xB2, 0xAC },
	0x9073, { 0xEE, 0x91, 0xBE },
	0x9074, { 0xEE, 0x91, 0xBF },
	0x9075, { 0xE9, 0x88, 0x8E },
	0x9076, { 0xE6, 0xB2, 0x9F },
	0x9077, { 0xE9, 0x89, 0x81 },
	0x9078, { 0xE9, 0x89, 0xA2 },
	0x9079, { 0xEE, 0x92, 0x84 },
	0x907b, { 0xEE, 0x92, 0x86 },
	0x907c, { 0xEE, 0x92, 0x87 },
	0x907d, { 0xEE, 0x92, 0x88 },
	0x907e, { 0xEE, 0x92, 0x89 },
	0x90a1, { 0xEE, 0x92, 0x8A },
	0x90a2, { 0xE9, 0x8C, 0xAC },
	0x90a3, { 0xE9, 0x8D, 0xAB },
	0x90a4, { 0xEE, 0x92, 0x8D },
	0x90a5, { 0xEE, 0x92, 0x8E },
	0x90a6, { 0xE7, 0x82, 0x8F },
	0x90a7, { 0xE5, 0xAB, 0x83 },
	0x90a8, { 0xEE, 0x92, 0x91 },
	0x90a9, { 0xEE, 0x92, 0x92 },
	0x90aa, { 0xE4, 0xA5, 0xA5 },
	0x90ab, { 0xE9, 0x89, 0x84 },
	0x90ac, { 0xEE, 0x92, 0x95 },
	0x90ad, { 0xEE, 0x92, 0x96 },
	0x90ae, { 0xEE, 0x92, 0x97 },
	0x90af, { 0xE9, 0x8D, 0xB3 },
	0x90b0, { 0xE9, 0x91, 0x9B },
	0x90b1, { 0xE8, 0xBA, 0xBC },
	0x90b2, { 0xE9, 0x96, 0x85 },
	0x90b3, { 0xE9, 0x96, 0xA6 },
	0x90b4, { 0xE9, 0x90, 0xA6 },
	0x90b5, { 0xE9, 0x96, 0xA0 },
	0x90b6, { 0xE6, 0xBF, 0xB6 },
	0x90b7, { 0xE4, 0x8A, 0xB9 },
	0x90b8, { 0xEE, 0x92, 0xA1 },
	0x90b9, { 0xEE, 0x92, 0xA2 },
	0x90ba, { 0xEE, 0x92, 0xA3 },
	0x90bb, { 0xEE, 0x92, 0xA4 },
	0x90bc, { 0xE4, 0xA7, 0x9F },
	0x90bd, { 0xE6, 0xB0, 0x9C },
	0x90be, { 0xE9, 0x99, 0xBB },
	0x90bf, { 0xE9, 0x9A, 0x96 },
	0x90c0, { 0xE4, 0x85, 0xAC },
	0x90c1, { 0xE9, 0x9A, 0xA3 },
	0x90c2, { 0xEE, 0x92, 0xAB },
	0x90c3, { 0xE6, 0x87, 0x9A },
	0x90c4, { 0xE9, 0x9A, 0xB6 },
	0x90c5, { 0xE7, 0xA3, 0xB5 },
	0x90c6, { 0xEE, 0x92, 0xAF },
	0x90c7, { 0xE9, 0x9A, 0xBD },
	0x90c8, { 0xE5, 0x8F, 0x8C },
	0x90c9, { 0xE4, 0xA6, 0xA1 },
	0x90ca, { 0xEE, 0x92, 0xB3 },
	0x90cb, { 0xEE, 0x92, 0xB4 },
	0x90cc, { 0xEE, 0x92, 0xB5 },
	0x90cd, { 0xEE, 0x92, 0xB6 },
	0x90ce, { 0xEE, 0x92, 0xB7 },
	0x90cf, { 0xEE, 0x92, 0xB8 },
	0x90d0, { 0xEE, 0x92, 0xB9 },
	0x90d1, { 0xEE, 0x92, 0xBA },
	0x90d2, { 0xE9, 0x9C, 0xB1 },
	0x90d3, { 0xE8, 0x99, 0x82 },
	0x90d4, { 0xE9, 0x9C, 0xB6 },
	0x90d5, { 0xE4, 0xA8, 0x8F },
	0x90d6, { 0xE4, 0x94, 0xBD },
	0x90d7, { 0xE4, 0x96, 0x85 },
	0x90d8, { 0xEE, 0x93, 0x81 },
	0x90d9, { 0xE7, 0x81, 0xB5 },
	0x90da, { 0xE5, 0xAD, 0x81 },
	0x90db, { 0xE9, 0x9C, 0x9B },
	0x90dd, { 0xEE, 0x93, 0x86 },
	0x90de, { 0xE9, 0x9D, 0x97 },
	0x90df, { 0xE5, 0xAD, 0x8A },
	0x90e0, { 0xEE, 0x93, 0x89 },
	0x90e1, { 0xE9, 0x9D, 0x9F },
	0x90e2, { 0xE9, 0x90, 0xA5 },
	0x90e3, { 0xE5, 0x83, 0x90 },
	0x90e4, { 0xEE, 0x93, 0x8D },
	0x90e5, { 0xEE, 0x93, 0x8E },
	0x90e6, { 0xE9, 0x9E, 0x89 },
	0x90e7, { 0xE9, 0x9E, 0x9F },
	0x90e8, { 0xE9, 0x9E, 0xB1 },
	0x90e9, { 0xE9, 0x9E, 0xBE },
	0x90ea, { 0xE9, 0x9F, 0x80 },
	0x90eb, { 0xE9, 0x9F, 0x92 },
	0x90ec, { 0xE9, 0x9F, 0xA0 },
	0x90ed, { 0xEE, 0x93, 0x96 },
	0x90ee, { 0xE9, 0x9F, 0xAE },
	0x90ef, { 0xE7, 0x90, 0x9C },
	0x90f0, { 0xEE, 0x93, 0x99 },
	0x90f2, { 0xE9, 0x9F, 0xB5 },
	0x90f3, { 0xEE, 0x93, 0x9C },
	0x90f4, { 0xEE, 0x93, 0x9D },
	0x90f5, { 0xE4, 0xAB, 0x91 },
	0x90f6, { 0xE9, 0xA0, 0xB4 },
	0x90f7, { 0xE9, 0xA0, 0xB3 },
	0x90f8, { 0xE9, 0xA1, 0x8B },
	0x90f9, { 0xE9, 0xA1, 0xA6 },
	0x90fa, { 0xE3, 0xAC, 0x8E },
	0x90fb, { 0xEE, 0x93, 0xA4 },
	0x90fc, { 0xE3, 0xB5, 0x91 },
	0x90fd, { 0xEE, 0x93, 0xA6 },
	0x90fe, { 0xEE, 0x93, 0xA7 },
	0x9140, { 0xEE, 0x93, 0xA8 },
	0x9141, { 0xE9, 0xA3, 0x8A },
	0x9142, { 0xE9, 0xA2, 0xB7 },
	0x9143, { 0xE9, 0xA3, 0x88 },
	0x9144, { 0xE9, 0xA3, 0x87 },
	0x9145, { 0xE4, 0xAB, 0xBF },
	0x9146, { 0xEE, 0x93, 0xAE },
	0x9147, { 0xEE, 0x93, 0xAF },
	0x9148, { 0xE5, 0x96, 0xB0 },
	0x9149, { 0xE9, 0xA3, 0xA1 },
	0x914a, { 0xE9, 0xA3, 0xA6 },
	0x914b, { 0xE9, 0xA3, 0xAC },
	0x914c, { 0xE9, 0x8D, 0xB8 },
	0x914d, { 0xE9, 0xA4, 0xB9 },
	0x914e, { 0xEE, 0x93, 0xB6 },
	0x914f, { 0xE4, 0xAD, 0xB2 },
	0x9150, { 0xEE, 0x93, 0xB8 },
	0x9151, { 0xEE, 0x93, 0xB9 },
	0x9152, { 0xE9, 0xA7, 0xB5 },
	0x9153, { 0xE9, 0xA8, 0x8C },
	0x9154, { 0xE9, 0xA8, 0xBB },
	0x9155, { 0xE9, 0xA8, 0x90 },
	0x9156, { 0xE9, 0xA9, 0x98 },
	0x9157, { 0xEE, 0x93, 0xBF },
	0x9158, { 0xE3, 0x9B, 0x84 },
	0x9159, { 0xEE, 0x94, 0x81 },
	0x915a, { 0xEE, 0x94, 0x82 },
	0x915b, { 0xE9, 0xAB, 0xA0 },
	0x915c, { 0xE9, 0xAB, 0xA2 },
	0x915d, { 0xEE, 0x94, 0x85 },
	0x915e, { 0xE9, 0xAB, 0xB4 },
	0x915f, { 0xE4, 0xB0, 0x8E },
	0x9160, { 0xE9, 0xAC, 0x94 },
	0x9161, { 0xE9, 0xAC, 0xAD },
	0x9162, { 0xEE, 0x94, 0x8A },
	0x9163, { 0xE5, 0x80, 0xB4 },
	0x9164, { 0xE9, 0xAC, 0xB4 },
	0x9165, { 0xEE, 0x94, 0x8D },
	0x9166, { 0xE3, 0xA3, 0x83 },
	0x9167, { 0xEE, 0x94, 0x8F },
	0x9168, { 0xE9, 0xAD, 0x90 },
	0x9169, { 0xE9, 0xAD, 0x80 },
	0x916a, { 0xEE, 0x94, 0x92 },
	0x916b, { 0xE5, 0xA9, 0x85 },
	0x916c, { 0xEE, 0x94, 0x94 },
	0x916d, { 0xE9, 0xAE, 0x8E },
	0x916e, { 0xEE, 0x94, 0x96 },
	0x916f, { 0xE9, 0xB0, 0x82 },
	0x9170, { 0xE9, 0xAF, 0xBF },
	0x9171, { 0xE9, 0xB0, 0x8C },
	0x9172, { 0xEE, 0x94, 0x9A },
	0x9173, { 0xE9, 0xB7, 0x94 },
	0x9174, { 0xEE, 0x94, 0x9C },
	0x9175, { 0xEE, 0x94, 0x9D },
	0x9176, { 0xEE, 0x94, 0x9E },
	0x9177, { 0xEE, 0x94, 0x9F },
	0x9178, { 0xEE, 0x94, 0xA0 },
	0x9179, { 0xEE, 0x94, 0xA1 },
	0x917a, { 0xE9, 0xB5, 0xBE },
	0x917b, { 0xE9, 0xB6, 0x83 },
	0x917c, { 0xEE, 0x94, 0xA4 },
	0x917d, { 0xE9, 0xB8, 0x8E },
	0x917e, { 0xE6, 0xA2, 0x88 },
	0x91a1, { 0xE9, 0xB7, 0x84 },
	0x91a2, { 0xEE, 0x94, 0xA8 },
	0x91a3, { 0xEE, 0x94, 0xA9 },
	0x91a4, { 0xEE, 0x94, 0xAA },
	0x91a5, { 0xEE, 0x94, 0xAB },
	0x91a6, { 0xEE, 0x94, 0xAC },
	0x91a7, { 0xE9, 0xB4, 0xB9 },
	0x91a8, { 0xEE, 0x94, 0xAE },
	0x91a9, { 0xEE, 0x94, 0xAF },
	0x91aa, { 0xE9, 0xBA, 0x90 },
	0x91ab, { 0xE9, 0xBA, 0x95 },
	0x91ac, { 0xE9, 0xBA, 0x9E },
	0x91ad, { 0xE9, 0xBA, 0xA2 },
	0x91ae, { 0xE4, 0xB4, 0xB4 },
	0x91af, { 0xE9, 0xBA, 0xAA },
	0x91b0, { 0xE9, 0xBA, 0xAF },
	0x91b1, { 0xEE, 0x94, 0xB7 },
	0x91b2, { 0xE9, 0xBB, 0x81 },
	0x91b3, { 0xE3, 0xAD, 0xA0 },
	0x91b4, { 0xE3, 0xA7, 0xA5 },
	0x91b5, { 0xE3, 0xB4, 0x9D },
	0x91b6, { 0xE4, 0xBC, 0xB2 },
	0x91b7, { 0xE3, 0x9E, 0xBE },
	0x91b8, { 0xEE, 0x94, 0xBE },
	0x91b9, { 0xE9, 0xBC, 0x82 },
	0x91ba, { 0xE9, 0xBC, 0x88 },
	0x91bb, { 0xE4, 0xAE, 0x96 },
	0x91bc, { 0xE9, 0x90, 0xA4 },
	0x91bd, { 0xEE, 0x95, 0x83 },
	0x91be, { 0xE9, 0xBC, 0x97 },
	0x91c0, { 0xE9, 0xBC, 0xB9 },
	0x91c1, { 0xE5, 0x9A, 0x9F },
	0x91c2, { 0xE5, 0x9A, 0x8A },
	0x91c3, { 0xE9, 0xBD, 0x85 },
	0x91c4, { 0xE9, 0xA6, 0xB8 },
	0x91c5, { 0xEE, 0x95, 0x8B },
	0x91c6, { 0xE9, 0x9F, 0xB2 },
	0x91c7, { 0xE8, 0x91, 0xBF },
	0x91c8, { 0xE9, 0xBD, 0xA2 },
	0x91c9, { 0xE9, 0xBD, 0xA9 },
	0x91ca, { 0xE7, 0xAB, 0x9C },
	0x91cb, { 0xE9, 0xBE, 0x8E },
	0x91cc, { 0xE7, 0x88, 0x96 },
	0x91cd, { 0xE4, 0xAE, 0xBE },
	0x91ce, { 0xEE, 0x95, 0x94 },
	0x91cf, { 0xEE, 0x95, 0x95 },
	0x91d0, { 0xE7, 0x85, 0xB7 },
	0x91d1, { 0xEE, 0x95, 0x97 },
	0x91d2, { 0xEE, 0x95, 0x98 },
	0x91d3, { 0xEE, 0x95, 0x99 },
	0x91d4, { 0xE7, 0x8E, 0x9E },
	0x91d5, { 0xEE, 0x95, 0x9B },
	0x91d6, { 0xEE, 0x95, 0x9C },
	0x91d7, { 0xE7, 0xA6, 0x9F },
	0x91d8, { 0xEE, 0x95, 0x9E },
	0x91d9, { 0xEE, 0x95, 0x9F },
	0x91da, { 0xE9, 0x8D, 0xA9 },
	0x91db, { 0xE9, 0x8F, 0xB3 },
	0x91dc, { 0xEE, 0x95, 0xA2 },
	0x91dd, { 0xE9, 0x8B, 0xAC },
	0x91de, { 0xE9, 0x8E, 0x81 },
	0x91df, { 0xE9, 0x8F, 0x8B },
	0x91e0, { 0xEE, 0x95, 0xA6 },
	0x91e1, { 0xEE, 0x95, 0xA7 },
	0x91e2, { 0xE7, 0x88, 0x97 },
	0x91e3, { 0xE3, 0xBB, 0xAB },
	0x91e4, { 0xE7, 0x9D, 0xB2 },
	0x91e5, { 0xE7, 0xA9, 0x83 },
	0x91e6, { 0xE7, 0x83, 0x90 },
	0x91e7, { 0xEE, 0x95, 0xAD },
	0x91e8, { 0xEE, 0x95, 0xAE },
	0x91e9, { 0xE7, 0x85, 0xBE },
	0x91ea, { 0xEE, 0x95, 0xB0 },
	0x91eb, { 0xE7, 0x82, 0xA3 },
	0x91ec, { 0xEE, 0x95, 0xB2 },
	0x91ed, { 0xEE, 0x95, 0xB3 },
	0x91ee, { 0xE3, 0xBB, 0x87 },
	0x91ef, { 0xEE, 0x95, 0xB5 },
	0x91f0, { 0xEE, 0x95, 0xB6 },
	0x91f1, { 0xEE, 0x95, 0xB7 },
	0x91f2, { 0xE3, 0x9C, 0xA2 },
	0x91f3, { 0xEE, 0x95, 0xB9 },
	0x91f4, { 0xEE, 0x95, 0xBA },
	0x91f5, { 0xE3, 0x9B, 0xA1 },
	0x91f6, { 0xEE, 0x95, 0xBC },
	0x91f7, { 0xEE, 0x95, 0xBD },
	0x91f8, { 0xEE, 0x95, 0xBE },
	0x91f9, { 0xE3, 0x9C, 0xA3 },
	0x91fa, { 0xEE, 0x96, 0x80 },
	0x91fb, { 0xE5, 0x9D, 0x9B },
	0x91fc, { 0xEE, 0x96, 0x82 },
	0x91fd, { 0xEE, 0x96, 0x83 },
	0x91fe, { 0xEE, 0x96, 0x84 },
	0x9240, { 0xEE, 0x96, 0x85 },
	0x9241, { 0xEE, 0x96, 0x86 },
	0x9242, { 0xE8, 0x94, 0x83 },
	0x9243, { 0xEE, 0x96, 0x88 },
	0x9245, { 0xE8, 0x91, 0x95 },
	0x9246, { 0xEE, 0x96, 0x8B },
	0x9247, { 0xEE, 0x96, 0x8C },
	0x9248, { 0xEE, 0x96, 0x8D },
	0x9249, { 0xEE, 0x96, 0x8E },
	0x924a, { 0xEE, 0x96, 0x8F },
	0x924b, { 0xEE, 0x96, 0x90 },
	0x924c, { 0xE4, 0x93, 0xB4 },
	0x924d, { 0xEE, 0x96, 0x92 },
	0x924e, { 0xEE, 0x96, 0x93 },
	0x924f, { 0xEE, 0x96, 0x94 },
	0x9250, { 0xE6, 0x9F, 0xB9 },
	0x9251, { 0xE3, 0x9C, 0xB3 },
	0x9252, { 0xE3, 0xB0, 0x95 },
	0x9253, { 0xE3, 0xB7, 0xA7 },
	0x9254, { 0xE5, 0xA1, 0xAC },
	0x9255, { 0xEE, 0x96, 0x9A },
	0x9256, { 0xE6, 0xA0, 0x90 },
	0x9257, { 0xE4, 0x81, 0x97 },
	0x9258, { 0xEE, 0x96, 0x9D },
	0x9259, { 0xEE, 0x96, 0x9E },
	0x925a, { 0xEE, 0x96, 0x9F },
	0x925b, { 0xEE, 0x96, 0xA0 },
	0x925c, { 0xEE, 0x96, 0xA1 },
	0x925d, { 0xE5, 0x93, 0x8B },
	0x925e, { 0xE5, 0x9A, 0x9E },
	0x925f, { 0xEE, 0x96, 0xA4 },
	0x9260, { 0xE5, 0x9A, 0x92 },
	0x9261, { 0xEE, 0x96, 0xA6 },
	0x9262, { 0xEE, 0x96, 0xA7 },
	0x9263, { 0xEE, 0x96, 0xA8 },
	0x9264, { 0xE9, 0x8F, 0x86 },
	0x9265, { 0xEE, 0x96, 0xAA },
	0x9266, { 0xE9, 0x8E, 0x9C },
	0x9267, { 0xE4, 0xBB, 0xB8 },
	0x9268, { 0xE5, 0x84, 0xAB },
	0x9269, { 0xE3, 0xA0, 0x99 },
	0x926a, { 0xEE, 0x96, 0xAF },
	0x926b, { 0xE4, 0xBA, 0xBC },
	0x926c, { 0xEE, 0x96, 0xB1 },
	0x926d, { 0xEE, 0x96, 0xB2 },
	0x926e, { 0xE4, 0xBD, 0x8B },
	0x926f, { 0xE4, 0xBE, 0x8A },
	0x9270, { 0xEE, 0x96, 0xB5 },
	0x9271, { 0xE5, 0xA9, 0xA8 },
	0x9272, { 0xEE, 0x96, 0xB7 },
	0x9273, { 0xEE, 0x96, 0xB8 },
	0x9274, { 0xE3, 0xA6, 0x99 },
	0x9275, { 0xEE, 0x96, 0xBA },
	0x9276, { 0xEE, 0x96, 0xBB },
	0x9277, { 0xE3, 0x90, 0xB5 },
	0x9278, { 0xE4, 0xBC, 0xA9 },
	0x9279, { 0xEE, 0x96, 0xBE },
	0x927a, { 0xEE, 0x96, 0xBF },
	0x927b, { 0xEE, 0x97, 0x80 },
	0x927c, { 0xE8, 0xAB, 0x9A },
	0x927d, { 0xEE, 0x97, 0x82 },
	0x927e, { 0xE4, 0xBA, 0x98 },
	0x92a1, { 0xE5, 0x83, 0x8D },
	0x92a2, { 0xE5, 0x84, 0x8D },
	0x92a3, { 0xE4, 0xBE, 0xA2 },
	0x92a4, { 0xE4, 0xBC, 0x83 },
	0x92a5, { 0xEE, 0x97, 0x88 },
	0x92a6, { 0xEE, 0x97, 0x89 },
	0x92a7, { 0xE4, 0xBD, 0x82 },
	0x92a8, { 0xE5, 0x80, 0xAE },
	0x92a9, { 0xE5, 0x81, 0xAC },
	0x92aa, { 0xE5, 0x82, 0x81 },
	0x92ab, { 0xE4, 0xBF, 0x8C },
	0x92ac, { 0xE4, 0xBF, 0xA5 },
	0x92ad, { 0xE5, 0x81, 0x98 },
	0x92ae, { 0xE5, 0x83, 0xBC },
	0x92b3, { 0xE6, 0xB9, 0xB6 },
	0x92b4, { 0xEE, 0x97, 0x97 },
	0x92b5, { 0xEE, 0x97, 0x98 },
	0x92b6, { 0xEE, 0x97, 0x99 },
	0x92b7, { 0xE6, 0xB5, 0xB2 },
	0x92b8, { 0xEE, 0x97, 0x9B },
	0x92b9, { 0xEE, 0x97, 0x9C },
	0x92ba, { 0xE5, 0x86, 0xA8 },
	0x92bb, { 0xE5, 0x87, 0x83 },
	0x92bc, { 0xEE, 0x97, 0x9F },
	0x92bd, { 0xE4, 0x93, 0x9D },
	0x92be, { 0xEE, 0x97, 0xA1 },
	0x92bf, { 0xEE, 0x97, 0xA2 },
	0x92c0, { 0xEE, 0x97, 0xA3 },
	0x92c1, { 0xE8, 0xB5, 0xBA },
	0x92c2, { 0xEE, 0x97, 0xA5 },
	0x92c3, { 0xEE, 0x97, 0xA6 },
	0x92c4, { 0xE5, 0x89, 0x99 },
	0x92c5, { 0xE5, 0x8A, 0xA4 },
	0x92c6, { 0xEE, 0x97, 0xA9 },
	0x92c7, { 0xE5, 0x8B, 0xA1 },
	0x92c9, { 0xE4, 0x99, 0xBA },
	0x92ca, { 0xE7, 0x86, 0x8C },
	0x92cb, { 0xEE, 0x97, 0xAE },
	0x92cc, { 0xEE, 0x97, 0xAF },
	0x92cd, { 0xEE, 0x97, 0xB0 },
	0x92ce, { 0xEE, 0x97, 0xB1 },
	0x92cf, { 0xE6, 0xA7, 0x91 },
	0x92d0, { 0xEE, 0x97, 0xB3 },
	0x92d2, { 0xE3, 0xBB, 0x9E },
	0x92d3, { 0xE7, 0x92, 0x99 },
	0x92d4, { 0xE7, 0x90, 0x94 },
	0x92d5, { 0xE7, 0x91, 0x96 },
	0x92d6, { 0xE7, 0x8E, 0x98 },
	0x92d7, { 0xE4, 0xAE, 0x8E },
	0x92d8, { 0xEE, 0x97, 0xBB },
	0x92d9, { 0xEE, 0x97, 0xBC },
	0x92da, { 0xE5, 0x8F, 0x90 },
	0x92db, { 0xE3, 0x96, 0x84 },
	0x92dc, { 0xE7, 0x88, 0x8F },
	0x92dd, { 0xEE, 0x98, 0x80 },
	0x92de, { 0xE5, 0x96, 0xB4 },
	0x92df, { 0xEE, 0x98, 0x82 },
	0x92e0, { 0xE5, 0x93, 0x8D },
	0x92e1, { 0xEE, 0x98, 0x84 },
	0x92e2, { 0xE5, 0x9C, 0x9D },
	0x92e3, { 0xE9, 0x89, 0x9D },
	0x92e4, { 0xE9, 0x9B, 0xB4 },
	0x92e5, { 0xE9, 0x8D, 0xA6 },
	0x92e6, { 0xE5, 0x9F, 0x9D },
	0x92e7, { 0xE5, 0x9E, 0x8D },
	0x92e8, { 0xE5, 0x9D, 0xBF },
	0x92e9, { 0xE3, 0x98, 0xBE },
	0x92ea, { 0xE5, 0xA3, 0x8B },
	0x92eb, { 0xE5, 0xAA, 0x99 },
	0x92ec, { 0xEE, 0x98, 0x8F },
	0x92ed, { 0xEE, 0x98, 0x90 },
	0x92ee, { 0xEE, 0x98, 0x91 },
	0x92ef, { 0xEE, 0x98, 0x92 },
	0x92f0, { 0xE5, 0xA8, 0xAC },
	0x92f1, { 0xE5, 0xA6, 0xB8 },
	0x92f2, { 0xE9, 0x8A, 0x8F },
	0x92f3, { 0xE5, 0xA9, 0xBE },
	0x92f4, { 0xE5, 0xAB, 0x8F },
	0x92f5, { 0xE5, 0xA8, 0x92 },
	0x92f6, { 0xEE, 0x98, 0x99 },
	0x92f7, { 0xEE, 0x98, 0x9A },
	0x92f8, { 0xEE, 0x98, 0x9B },
	0x92f9, { 0xEE, 0x98, 0x9C },
	0x92fa, { 0xE3, 0x9B, 0xB5 },
	0x92fb, { 0xE6, 0xB4, 0x85 },
	0x92fc, { 0xE7, 0x91, 0x83 },
	0x92fd, { 0xE5, 0xA8, 0xA1 },
	0x92fe, { 0xEE, 0x98, 0xA1 },
	0x9340, { 0xE5, 0xAA, 0x81 },
	0x9341, { 0xEE, 0x98, 0xA3 },
	0x9342, { 0xEE, 0x98, 0xA4 },
	0x9343, { 0xE9, 0x8F, 0xA0 },
	0x9344, { 0xE7, 0x92, 0x8C },
	0x9345, { 0xEE, 0x98, 0xA7 },
	0x9346, { 0xE7, 0x84, 0x85 },
	0x9347, { 0xE4, 0xA5, 0xB2 },
	0x9348, { 0xE9, 0x90, 0x88 },
	0x9349, { 0xEE, 0x98, 0xAB },
	0x934a, { 0xE9, 0x8E, 0xBD },
	0x934b, { 0xE3, 0x9E, 0xA0 },
	0x934c, { 0xE5, 0xB0, 0x9E },
	0x934d, { 0xE5, 0xB2, 0x9E },
	0x934e, { 0xE5, 0xB9, 0x9E },
	0x934f, { 0xE5, 0xB9, 0x88 },
	0x9350, { 0xEE, 0x98, 0xB2 },
	0x9351, { 0xEE, 0x98, 0xB3 },
	0x9352, { 0xEE, 0x98, 0xB4 },
	0x9353, { 0xE5, 0xBB, 0x8D },
	0x9354, { 0xE5, 0xAD, 0x8F },
	0x9355, { 0xEE, 0x98, 0xB7 },
	0x9356, { 0xEE, 0x98, 0xB8 },
	0x9357, { 0xE3, 0x9C, 0x81 },
	0x9358, { 0xEE, 0x98, 0xBA },
	0x9359, { 0xE3, 0x9B, 0x9D },
	0x935a, { 0xEE, 0x98, 0xBC },
	0x935b, { 0xE3, 0x9B, 0x93 },
	0x935c, { 0xE8, 0x84, 0xAA },
	0x935d, { 0xEE, 0x98, 0xBF },
	0x935e, { 0xEE, 0x99, 0x80 },
	0x935f, { 0xEE, 0x99, 0x81 },
	0x9360, { 0xEE, 0x99, 0x82 },
	0x9361, { 0xE5, 0xBC, 0x8C },
	0x9362, { 0xE5, 0xBC, 0x8E },
	0x9363, { 0xEE, 0x99, 0x85 },
	0x9364, { 0xEE, 0x99, 0x86 },
	0x9365, { 0xE5, 0xA9, 0xAB },
	0x9366, { 0xEE, 0x99, 0x88 },
	0x9367, { 0xE5, 0xAD, 0x84 },
	0x9368, { 0xE8, 0x98, 0x94 },
	0x9369, { 0xEE, 0x99, 0x8B },
	0x936a, { 0xE8, 0xA1, 0xA0 },
	0x936b, { 0xE6, 0x81, 0xBE },
	0x936c, { 0xEE, 0x99, 0x8E },
	0x936d, { 0xEE, 0x99, 0x8F },
	0x936e, { 0xE5, 0xBF, 0x9B },
	0x936f, { 0xE3, 0xBA, 0xB8 },
	0x9370, { 0xEE, 0x99, 0x92 },
	0x9371, { 0xEE, 0x99, 0x93 },
	0x9372, { 0xEE, 0x99, 0x94 },
	0x9373, { 0xEE, 0x99, 0x95 },
	0x9374, { 0xE6, 0x87, 0x80 },
	0x9375, { 0xEE, 0x99, 0x97 },
	0x9376, { 0xEE, 0x99, 0x98 },
	0x9377, { 0xEE, 0x99, 0x99 },
	0x9378, { 0xE6, 0x86, 0x99 },
	0x9379, { 0xE6, 0x86, 0x98 },
	0x937a, { 0xE6, 0x81, 0xB5 },
	0x937b, { 0xEE, 0x99, 0x9D },
	0x937c, { 0xEE, 0x99, 0x9E },
	0x937d, { 0xEE, 0x99, 0x9F },
	0x937e, { 0xEE, 0x99, 0xA0 },
	0x93a1, { 0xE6, 0x91, 0xB1 },
	0x93a2, { 0xEE, 0x99, 0xA2 },
	0x93a3, { 0xEE, 0x99, 0xA3 },
	0x93a4, { 0xE3, 0xA8, 0xA9 },
	0x93a5, { 0xEE, 0x99, 0xA5 },
	0x93a6, { 0xEE, 0x99, 0xA6 },
	0x93a7, { 0xEE, 0x99, 0xA7 },
	0x93a8, { 0xEE, 0x99, 0xA8 },
	0x93a9, { 0xE6, 0x8C, 0xB7 },
	0x93aa, { 0xEE, 0x99, 0xAA },
	0x93ab, { 0xE6, 0x92, 0xB6 },
	0x93ac, { 0xE6, 0x8C, 0xB1 },
	0x93ad, { 0xE6, 0x8F, 0x91 },
	0x93ae, { 0xEE, 0x99, 0xAE },
	0x93af, { 0xEE, 0x99, 0xAF },
	0x93b0, { 0xE6, 0x8A, 0xA4 },
	0x93b1, { 0xEE, 0x99, 0xB1 },
	0x93b2, { 0xE6, 0x90, 0xBB },
	0x93b3, { 0xE6, 0x95, 0xAB },
	0x93b4, { 0xE6, 0xA5, 0xB2 },
	0x93b5, { 0xE3, 0xAF, 0xB4 },
	0x93b6, { 0xEE, 0x99, 0xB6 },
	0x93b7, { 0xEE, 0x99, 0xB7 },
	0x93b8, { 0xEE, 0x99, 0xB8 },
	0x93b9, { 0xEE, 0x99, 0xB9 },
	0x93ba, { 0xE5, 0x94, 0x8D },
	0x93bb, { 0xEE, 0x99, 0xBB },
	0x93bc, { 0xEE, 0x99, 0xBC },
	0x93bd, { 0xEE, 0x99, 0xBD },
	0x93be, { 0xE6, 0x9B, 0x8E },
	0x93bf, { 0xEE, 0x99, 0xBF },
	0x93c0, { 0xEE, 0x9A, 0x80 },
	0x93c1, { 0xE3, 0xAB, 0xA0 },
	0x93c2, { 0xE4, 0x86, 0x90 },
	0x93c3, { 0xEE, 0x9A, 0x83 },
	0x93c4, { 0xEE, 0x9A, 0x84 },
	0x93c5, { 0xEE, 0x9A, 0x85 },
	0x93c6, { 0xEE, 0x9A, 0x86 },
	0x93c7, { 0xEE, 0x9A, 0x87 },
	0x93c8, { 0xEE, 0x9A, 0x88 },
	0x93c9, { 0xE7, 0xA3, 0xAE },
	0x93ca, { 0xEE, 0x9A, 0x8A },
	0x93cb, { 0xEE, 0x9A, 0x8B },
	0x93cc, { 0xEE, 0x9A, 0x8C },
	0x93cd, { 0xE3, 0x91, 0xA4 },
	0x93ce, { 0xEE, 0x9A, 0x8E },
	0x93cf, { 0xEE, 0x9A, 0x8F },
	0x93d0, { 0xEE, 0x9A, 0x90 },
	0x93d1, { 0xE6, 0x9A, 0x8E },
	0x93d2, { 0xEE, 0x9A, 0x92 },
	0x93d3, { 0xE6, 0x99, 0xAB },
	0x93d4, { 0xE4, 0xAE, 0x93 },
	0x93d5, { 0xE6, 0x98, 0xB0 },
	0x93d6, { 0xEE, 0x9A, 0x96 },
	0x93d7, { 0xEE, 0x9A, 0x97 },
	0x93d8, { 0xE6, 0x99, 0xA3 },
	0x93d9, { 0xEE, 0x9A, 0x99 },
	0x93da, { 0xEE, 0x9A, 0x9A },
	0x93db, { 0xE6, 0x98, 0x9E },
	0x93dc, { 0xEE, 0x9A, 0x9C },
	0x93dd, { 0xE3, 0xA3, 0x91 },
	0x93de, { 0xEE, 0x9A, 0x9E },
	0x93df, { 0xEE, 0x9A, 0x9F },
	0x93e0, { 0xE3, 0xAE, 0x99 },
	0x93e1, { 0xEE, 0x9A, 0xA1 },
	0x93e2, { 0xEE, 0x9A, 0xA2 },
	0x93e3, { 0xE7, 0x93, 0x90 },
	0x93e4, { 0xE3, 0xAE, 0x96 },
	0x93e5, { 0xE6, 0x9E, 0x8F },
	0x93e6, { 0xEE, 0x9A, 0xA6 },
	0x93e7, { 0xE6, 0xA2, 0xB6 },
	0x93e8, { 0xE6, 0xA0, 0x9E },
	0x93e9, { 0xE3, 0xAF, 0x84 },
	0x93ea, { 0xE6, 0xAA, 0xBE },
	0x93eb, { 0xE3, 0xA1, 0xA3 },
	0x93ec, { 0xEE, 0x9A, 0xAC },
	0x93ed, { 0xEE, 0x9A, 0xAD },
	0x93ee, { 0xE6, 0xA8, 0xB3 },
	0x93ef, { 0xE6, 0xA9, 0x92 },
	0x93f0, { 0xE6, 0xAB, 0x89 },
	0x93f1, { 0xE6, 0xAC, 0x85 },
	0x93f2, { 0xEE, 0x9A, 0xB2 },
	0x93f3, { 0xE6, 0x94, 0x91 },
	0x93f4, { 0xE6, 0xA2, 0x98 },
	0x93f5, { 0xE6, 0xA9, 0x8C },
	0x93f6, { 0xE3, 0xAF, 0x97 },
	0x93f7, { 0xE6, 0xA9, 0xBA },
	0x93f8, { 0xE6, 0xAD, 0x97 },
	0x93f9, { 0xEE, 0x9A, 0xB9 },
	0x93fa, { 0xEE, 0x9A, 0xBA },
	0x93fb, { 0xE9, 0x8E, 0xA0 },
	0x93fc, { 0xE9, 0x8B, 0xB2 },
	0x93fd, { 0xEE, 0x9A, 0xBD },
	0x93fe, { 0xEE, 0x9A, 0xBE },
	0x9440, { 0xE9, 0x8A, 0x89 },
	0x9441, { 0xEE, 0x9B, 0x80 },
	0x9442, { 0xEE, 0x9B, 0x81 },
	0x9443, { 0xE9, 0x91, 0xA7 },
	0x9444, { 0xE6, 0xB6, 0xA5 },
	0x9445, { 0xE6, 0xBC, 0x8B },
	0x9446, { 0xEE, 0x9B, 0x85 },
	0x9448, { 0xEE, 0x9B, 0x87 },
	0x9449, { 0xE3, 0xB6, 0x8F },
	0x944a, { 0xE6, 0xB8, 0x84 },
	0x944b, { 0xEE, 0x9B, 0x8A },
	0x944c, { 0xE5, 0xA8, 0xBD },
	0x944d, { 0xE6, 0xB8, 0x8A },
	0x944e, { 0xE5, 0xA1, 0x87 },
	0x944f, { 0xE6, 0xB4, 0xA4 },
	0x9450, { 0xE7, 0xA1, 0x82 },
	0x9451, { 0xE7, 0x84, 0xBB },
	0x9452, { 0xEE, 0x9B, 0x91 },
	0x9453, { 0xEE, 0x9B, 0x92 },
	0x9454, { 0xE7, 0x83, 0xB1 },
	0x9455, { 0xE7, 0x89, 0x90 },
	0x9456, { 0xE7, 0x8A, 0x87 },
	0x9457, { 0xE7, 0x8A, 0x94 },
	0x9458, { 0xEE, 0x9B, 0x97 },
	0x9459, { 0xEE, 0x9B, 0x98 },
	0x945a, { 0xE5, 0x85, 0xB9 },
	0x945b, { 0xEE, 0x9B, 0x9A },
	0x945c, { 0xEE, 0x9B, 0x9B },
	0x945d, { 0xE7, 0x91, 0xBA },
	0x945e, { 0xEE, 0x9B, 0x9D },
	0x945f, { 0xEE, 0x9B, 0x9E },
	0x9460, { 0xEE, 0x9B, 0x9F },
	0x9461, { 0xEE, 0x9B, 0xA0 },
	0x9462, { 0xEE, 0x9B, 0xA1 },
	0x9463, { 0xE3, 0xBC, 0x86 },
	0x9464, { 0xE3, 0xBA, 0xB1 },
	0x9465, { 0xEE, 0x9B, 0xA4 },
	0x9466, { 0xEE, 0x9B, 0xA5 },
	0x9467, { 0xEE, 0x9B, 0xA6 },
	0x9468, { 0xE6, 0x82, 0xA7 },
	0x9469, { 0xE3, 0xBB, 0xB3 },
	0x946a, { 0xE7, 0x93, 0x8C },
	0x946b, { 0xE7, 0x90, 0xBC },
	0x946c, { 0xE9, 0x8E, 0x87 },
	0x946d, { 0xE7, 0x90, 0xB7 },
	0x946e, { 0xE4, 0x92, 0x9F },
	0x946f, { 0xEE, 0x9B, 0xAE },
	0x9470, { 0xE4, 0x95, 0x91 },
	0x9471, { 0xE7, 0x96, 0x83 },
	0x9472, { 0xE3, 0xBD, 0xA3 },
	0x9473, { 0xEE, 0x9B, 0xB2 },
	0x9474, { 0xEE, 0x9B, 0xB3 },
	0x9475, { 0xE3, 0xBD, 0x98 },
	0x9476, { 0xE7, 0x95, 0x95 },
	0x9477, { 0xE7, 0x99, 0xB3 },
	0x9478, { 0xEE, 0x9B, 0xB7 },
	0x9479, { 0xE3, 0xAC, 0x99 },
	0x947a, { 0xE7, 0x91, 0xA8 },
	0x947b, { 0xEE, 0x9B, 0xBA },
	0x947c, { 0xEE, 0x9B, 0xBB },
	0x947d, { 0xEE, 0x9B, 0xBC },
	0x947e, { 0xE3, 0xAB, 0xBB },
	0x94a1, { 0xE3, 0xB7, 0x8D },
	0x94a2, { 0xEE, 0x9B, 0xBF },
	0x94a3, { 0xE3, 0xBB, 0xBF },
	0x94a4, { 0xEE, 0x9C, 0x81 },
	0x94a5, { 0xEE, 0x9C, 0x82 },
	0x94a6, { 0xE9, 0x87, 0xBA },
	0x94a7, { 0xE5, 0x9C, 0xB2 },
	0x94a8, { 0xE9, 0x8D, 0x82 },
	0x94a9, { 0xEE, 0x9C, 0x86 },
	0x94aa, { 0xEE, 0x9C, 0x87 },
	0x94ab, { 0xE5, 0x83, 0x9F },
	0x94ac, { 0xEE, 0x9C, 0x89 },
	0x94ad, { 0xEE, 0x9C, 0x8A },
	0x94ae, { 0xE7, 0x9D, 0xB8 },
	0x94af, { 0xEE, 0x9C, 0x8C },
	0x94b0, { 0xE7, 0x9C, 0x8E },
	0x94b1, { 0xE7, 0x9C, 0x8F },
	0x94b2, { 0xE7, 0x9D, 0xBB },
	0x94b3, { 0xEE, 0x9C, 0x90 },
	0x94b4, { 0xEE, 0x9C, 0x91 },
	0x94b5, { 0xE3, 0xA9, 0x9E },
	0x94b6, { 0xEE, 0x9C, 0x93 },
	0x94b7, { 0xE7, 0x90, 0xB8 },
	0x94b8, { 0xE7, 0x92, 0x9B },
	0x94b9, { 0xE3, 0xBA, 0xBF },
	0x94ba, { 0xEE, 0x9C, 0x97 },
	0x94bb, { 0xEE, 0x9C, 0x98 },
	0x94bc, { 0xE4, 0x83, 0x88 },
	0x94bd, { 0xEE, 0x9C, 0x9A },
	0x94be, { 0xEE, 0x9C, 0x9B },
	0x94bf, { 0xE9, 0x8C, 0x87 },
	0x94c0, { 0xEE, 0x9C, 0x9D },
	0x94c1, { 0xE7, 0xA0, 0x9E },
	0x94c2, { 0xE7, 0xA2, 0x8D },
	0x94c3, { 0xE7, 0xA2, 0x88 },
	0x94c4, { 0xE7, 0xA3, 0x92 },
	0x94c5, { 0xE7, 0x8F, 0x90 },
	0x94c6, { 0xE7, 0xA5, 0x99 },
	0x94c7, { 0xEE, 0x9C, 0xA4 },
	0x94c8, { 0xEE, 0x9C, 0xA5 },
	0x94c9, { 0xE4, 0x84, 0x8E },
	0x94cb, { 0xE8, 0x92, 0x96 },
	0x94cc, { 0xE7, 0xA6, 0xA5 },
	0x94cd, { 0xE6, 0xA8, 0xAD },
	0x94ce, { 0xEE, 0x9C, 0xAB },
	0x94cf, { 0xE7, 0xA8, 0xBA },
	0x94d0, { 0xE7, 0xA7, 0xB4 },
	0x94d1, { 0xE4, 0x85, 0xAE },
	0x94d2, { 0xEE, 0x9C, 0xAF },
	0x94d3, { 0xE4, 0x84, 0xB2 },
	0x94d4, { 0xE9, 0x88, 0xB5 },
	0x94d5, { 0xE7, 0xA7, 0xB1 },
	0x94d6, { 0xEE, 0x9C, 0xB3 },
	0x94d7, { 0xEE, 0x9C, 0xB4 },
	0x94d8, { 0xEE, 0x9C, 0xB5 },
	0x94d9, { 0xEE, 0x9C, 0xB6 },
	0x94da, { 0xEE, 0x9C, 0xB7 },
	0x94db, { 0xE3, 0x96, 0x97 },
	0x94dc, { 0xE5, 0x95, 0xAB },
	0x94dd, { 0xE3, 0x95, 0xB0 },
	0x94de, { 0xE3, 0x9A, 0xAA },
	0x94df, { 0xEE, 0x9C, 0xBC },
	0x94e0, { 0xEE, 0x9C, 0xBD },
	0x94e1, { 0xE7, 0xAB, 0xA2 },
	0x94e2, { 0xE5, 0xA9, 0x99 },
	0x94e3, { 0xEE, 0x9D, 0x80 },
	0x94e4, { 0xEE, 0x9D, 0x81 },
	0x94e5, { 0xEE, 0x9D, 0x82 },
	0x94e6, { 0xE5, 0xA8, 0x8D },
	0x94e7, { 0xEE, 0x9D, 0x84 },
	0x94e8, { 0xE7, 0xA3, 0xB0 },
	0x94e9, { 0xE5, 0xA8, 0xAA },
	0x94ea, { 0xEE, 0x9D, 0x87 },
	0x94eb, { 0xE7, 0xAB, 0xBE },
	0x94ec, { 0xE4, 0x87, 0xB9 },
	0x94ed, { 0xE7, 0xB1, 0x9D },
	0x94ee, { 0xE7, 0xB1, 0xAD },
	0x94ef, { 0xE4, 0x88, 0x91 },
	0x94f0, { 0xEE, 0x9D, 0x8D },
	0x94f1, { 0xEE, 0x9D, 0x8E },
	0x94f2, { 0xEE, 0x9D, 0x8F },
	0x94f3, { 0xE7, 0xB3, 0x8D },
	0x94f4, { 0xEE, 0x9D, 0x91 },
	0x94f5, { 0xEE, 0x9D, 0x92 },
	0x94f6, { 0xE7, 0xB2, 0x8E },
	0x94f7, { 0xE7, 0xB1, 0xBC },
	0x94f8, { 0xE7, 0xB2, 0xAE },
	0x94f9, { 0xE6, 0xAA, 0xB2 },
	0x94fa, { 0xE7, 0xB7, 0x9C },
	0x94fb, { 0xE7, 0xB8, 0x87 },
	0x94fc, { 0xE7, 0xB7, 0x93 },
	0x94fd, { 0xE7, 0xBD, 0x8E },
	0x94fe, { 0xEE, 0x9D, 0x9B },
	0x9540, { 0xEE, 0x9D, 0x9C },
	0x9541, { 0xEE, 0x9D, 0x9D },
	0x9542, { 0xE7, 0xB6, 0x97 },
	0x9543, { 0xEE, 0x9D, 0x9F },
	0x9544, { 0xE4, 0x89, 0xAA },
	0x9545, { 0xEE, 0x9D, 0xA1 },
	0x9546, { 0xEE, 0x9D, 0xA2 },
	0x9547, { 0xE6, 0x9F, 0x96 },
	0x9548, { 0xEE, 0x9D, 0xA4 },
	0x9549, { 0xEE, 0x9D, 0xA5 },
	0x954a, { 0xE5, 0x9F, 0x84 },
	0x954b, { 0xEE, 0x9D, 0xA7 },
	0x954c, { 0xEE, 0x9D, 0xA8 },
	0x954d, { 0xEE, 0x9D, 0xA9 },
	0x954e, { 0xE7, 0xBF, 0x9D },
	0x954f, { 0xE7, 0xAC, 0xA7 },
	0x9550, { 0xEE, 0x9D, 0xAC },
	0x9551, { 0xEE, 0x9D, 0xAD },
	0x9552, { 0xEE, 0x9D, 0xAE },
	0x9553, { 0xE7, 0xAC, 0x8C },
	0x9554, { 0xEE, 0x9D, 0xB0 },
	0x9555, { 0xE9, 0xA7, 0xA6 },
	0x9556, { 0xE8, 0x99, 0x85 },
	0x9557, { 0xE9, 0xA9, 0xA3 },
	0x9558, { 0xE6, 0xA8, 0x9C },
	0x9559, { 0xEE, 0x9D, 0xB5 },
	0x955a, { 0xE3, 0xA7, 0xA2 },
	0x955b, { 0xEE, 0x9D, 0xB7 },
	0x955c, { 0xEE, 0x9D, 0xB8 },
	0x955d, { 0xE9, 0xA8, 0x9F },
	0x955e, { 0xEE, 0x9D, 0xBA },
	0x955f, { 0xE8, 0x92, 0x80 },
	0x9560, { 0xEE, 0x9D, 0xBC },
	0x9561, { 0xEE, 0x9D, 0xBD },
	0x9562, { 0xE4, 0x93, 0xAA },
	0x9563, { 0xE8, 0x84, 0xB7 },
	0x9564, { 0xE4, 0x90, 0x82 },
	0x9565, { 0xE8, 0x83, 0x86 },
	0x9566, { 0xE8, 0x84, 0x89 },
	0x9567, { 0xE8, 0x85, 0x82 },
	0x9568, { 0xEE, 0x9E, 0x84 },
	0x9569, { 0xE9, 0xA3, 0x83 },
	0x956a, { 0xEE, 0x9E, 0x86 },
	0x956b, { 0xE8, 0x89, 0xA2 },
	0x956c, { 0xE8, 0x89, 0xA5 },
	0x956d, { 0xEE, 0x9E, 0x89 },
	0x956e, { 0xE8, 0x91, 0x93 },
	0x956f, { 0xEE, 0x9E, 0x8B },
	0x9570, { 0xE8, 0x98, 0x90 },
	0x9571, { 0xEE, 0x9E, 0x8D },
	0x9572, { 0xE5, 0xAA, 0x86 },
	0x9573, { 0xE4, 0x85, 0xBF },
	0x9574, { 0xEE, 0x9E, 0x90 },
	0x9575, { 0xE5, 0xAC, 0xAB },
	0x9576, { 0xEE, 0x9E, 0x92 },
	0x9577, { 0xE5, 0xAB, 0xA4 },
	0x9578, { 0xEE, 0x9E, 0x94 },
	0x9579, { 0xE8, 0x9A, 0xA0 },
	0x957a, { 0xEE, 0x9E, 0x96 },
	0x957b, { 0xEE, 0x9E, 0x97 },
	0x957c, { 0xE8, 0xA0, 0xAD },
	0x957d, { 0xEE, 0x9E, 0x99 },
	0x957e, { 0xE5, 0xA8, 0x82 },
	0x95a1, { 0xE8, 0xA1, 0xAE },
	0x95a2, { 0xE4, 0xBD, 0x85 },
	0x95a3, { 0xE8, 0xA2, 0x87 },
	0x95a4, { 0xE8, 0xA2, 0xBF },
	0x95a5, { 0xE8, 0xA3, 0xA6 },
	0x95a6, { 0xE8, 0xA5, 0xA5 },
	0x95a7, { 0xE8, 0xA5, 0x8D },
	0x95a8, { 0xEE, 0x9E, 0xA2 },
	0x95a9, { 0xE8, 0xA5, 0x94 },
	0x95aa, { 0xEE, 0x9E, 0xA4 },
	0x95ab, { 0xEE, 0x9E, 0xA5 },
	0x95ac, { 0xEE, 0x9E, 0xA6 },
	0x95ad, { 0xEE, 0x9E, 0xA7 },
	0x95ae, { 0xEE, 0x9E, 0xA8 },
	0x95af, { 0xEE, 0x9E, 0xA9 },
	0x95b0, { 0xE3, 0xBA, 0xAD },
	0x95b1, { 0xE8, 0x92, 0xA3 },
	0x95b2, { 0xE4, 0x9B, 0xB5 },
	0x95b3, { 0xE4, 0x9B, 0x8F },
	0x95b4, { 0xE3, 0x9F, 0xB2 },
	0x95b5, { 0xE8, 0xA8, 0xBD },
	0x95b6, { 0xE8, 0xA8, 0x9C },
	0x95b7, { 0xEE, 0x9E, 0xB1 },
	0x95b8, { 0xE5, 0xBD, 0x8D },
	0x95b9, { 0xE9, 0x88, 0xAB },
	0x95ba, { 0xEE, 0x9E, 0xB4 },
	0x95bb, { 0xE6, 0x97, 0x94 },
	0x95bc, { 0xE7, 0x84, 0xA9 },
	0x95bd, { 0xE7, 0x83, 0x84 },
	0x95be, { 0xEE, 0x9E, 0xB8 },
	0x95bf, { 0xE9, 0xB5, 0xAD },
	0x95c0, { 0xE8, 0xB2, 0x9F },
	0x95c1, { 0xE8, 0xB3, 0xA9 },
	0x95c2, { 0xEE, 0x9E, 0xBC },
	0x95c3, { 0xE5, 0xA6, 0x9A },
	0x95c4, { 0xE7, 0x9F, 0x83 },
	0x95c5, { 0xE5, 0xA7, 0xB0 },
	0x95c6, { 0xE4, 0x8D, 0xAE },
	0x95c7, { 0xE3, 0x9B, 0x94 },
	0x95c8, { 0xE8, 0xB8, 0xAA },
	0x95c9, { 0xE8, 0xBA, 0xA7 },
	0x95ca, { 0xEE, 0x9F, 0x84 },
	0x95cb, { 0xE8, 0xBC, 0xB0 },
	0x95cc, { 0xE8, 0xBD, 0x8A },
	0x95cd, { 0xE4, 0x8B, 0xB4 },
	0x95ce, { 0xE6, 0xB1, 0x98 },
	0x95cf, { 0xE6, 0xBE, 0xBB },
	0x95d0, { 0xEE, 0x9F, 0x8A },
	0x95d1, { 0xE4, 0xA2, 0x9B },
	0x95d2, { 0xE6, 0xBD, 0xB9 },
	0x95d3, { 0xE6, 0xBA, 0x8B },
	0x95d4, { 0xEE, 0x9F, 0x8E },
	0x95d5, { 0xE9, 0xAF, 0xA9 },
	0x95d6, { 0xE3, 0x9A, 0xB5 },
	0x95d7, { 0xEE, 0x9F, 0x91 },
	0x95d8, { 0xE9, 0x82, 0xBB },
	0x95da, { 0xE5, 0x95, 0xB1 },
	0x95db, { 0xE4, 0xA4, 0x86 },
	0x95dc, { 0xE9, 0x86, 0xBB },
	0x95dd, { 0xE9, 0x90, 0x84 },
	0x95de, { 0xEE, 0x9F, 0x98 },
	0x95df, { 0xE4, 0x81, 0xA2 },
	0x95e0, { 0xEE, 0x9F, 0x9A },
	0x95e1, { 0xE9, 0x90, 0xA7 },
	0x95e2, { 0xEE, 0x9F, 0x9C },
	0x95e3, { 0xEE, 0x9F, 0x9D },
	0x95e4, { 0xE8, 0x93, 0xA5 },
	0x95e5, { 0xE8, 0xA8, 0xAB },
	0x95e6, { 0xE9, 0x96, 0x99 },
	0x95e7, { 0xE9, 0x96, 0xA7 },
	0x95e8, { 0xE9, 0x96, 0x97 },
	0x95e9, { 0xE9, 0x96, 0x96 },
	0x95ea, { 0xEE, 0x9F, 0xA4 },
	0x95eb, { 0xE7, 0x91, 0x85 },
	0x95ec, { 0xE3, 0xBB, 0x82 },
	0x95ed, { 0xEE, 0x9F, 0xA7 },
	0x95ee, { 0xEE, 0x9F, 0xA8 },
	0x95ef, { 0xEE, 0x9F, 0xA9 },
	0x95f0, { 0xE3, 0xBB, 0xA7 },
	0x95f1, { 0xEE, 0x9F, 0xAB },
	0x95f2, { 0xE9, 0x9A, 0x8F },
	0x95f3, { 0xEE, 0x9F, 0xAD },
	0x95f4, { 0xEE, 0x9F, 0xAE },
	0x95f5, { 0xEE, 0x9F, 0xAF },
	0x95f6, { 0xE3, 0xBB, 0x8C },
	0x95f7, { 0xEE, 0x9F, 0xB1 },
	0x95f8, { 0xEE, 0x9F, 0xB2 },
	0x95f9, { 0xEE, 0x9F, 0xB3 },
	0x95fa, { 0xE7, 0x90, 0x92 },
	0x95fb, { 0xE7, 0x91, 0xAB },
	0x95fc, { 0xE3, 0xBB, 0xBC },
	0x95fd, { 0xE9, 0x9D, 0x81 },
	0x95fe, { 0xEE, 0x9F, 0xB8 },
	0x9640, { 0xE6, 0xA1, 0x87 },
	0x9641, { 0xE4, 0xA8, 0x9D },
	0x9642, { 0xEE, 0x9F, 0xBB },
	0x9643, { 0xEE, 0x9F, 0xBC },
	0x9645, { 0xE9, 0x8D, 0xA8 },
	0x9646, { 0xEE, 0x9F, 0xBF },
	0x9647, { 0xEE, 0xA0, 0x80 },
	0x9648, { 0xEE, 0xA0, 0x81 },
	0x9649, { 0xEE, 0xA0, 0x82 },
	0x964a, { 0xE9, 0x8A, 0xBA },
	0x964b, { 0xE5, 0xAC, 0x91 },
	0x964c, { 0xE8, 0xAD, 0xA9 },
	0x964d, { 0xE4, 0xA4, 0xBC },
	0x964e, { 0xE7, 0x8F, 0xB9 },
	0x964f, { 0xEE, 0xA0, 0x88 },
	0x9650, { 0xE9, 0x9E, 0x9B },
	0x9651, { 0xE9, 0x9D, 0xB1 },
	0x9652, { 0xE9, 0xA4, 0xB8 },
	0x9653, { 0xEE, 0xA0, 0x8C },
	0x9654, { 0xE5, 0xB7, 0x81 },
	0x9655, { 0xEE, 0xA0, 0x8E },
	0x9656, { 0xEE, 0xA0, 0x8F },
	0x9657, { 0xE9, 0xA0, 0x9F },
	0x9658, { 0xEE, 0xA0, 0x91 },
	0x9659, { 0xE9, 0x8B, 0xB6 },
	0x965a, { 0xEE, 0xA0, 0x93 },
	0x965b, { 0xE9, 0x87, 0xA5 },
	0x965c, { 0xE4, 0x93, 0x80 },
	0x965d, { 0xEE, 0xA0, 0x96 },
	0x965e, { 0xEE, 0xA0, 0x97 },
	0x965f, { 0xEE, 0xA0, 0x98 },
	0x9660, { 0xE9, 0xA3, 0x9C },
	0x9661, { 0xEE, 0xA0, 0x9A },
	0x9662, { 0xE3, 0xBC, 0x80 },
	0x9663, { 0xE9, 0x88, 0xAA },
	0x9664, { 0xE4, 0xA4, 0xA5 },
	0x9665, { 0xE8, 0x90, 0x94 },
	0x9666, { 0xE9, 0xA4, 0xBB },
	0x9667, { 0xE9, 0xA5, 0x8D },
	0x9668, { 0xEE, 0xA0, 0xA1 },
	0x9669, { 0xE3, 0xB7, 0xBD },
	0x966a, { 0xE9, 0xA6, 0x9B },
	0x966b, { 0xE4, 0xAD, 0xAF },
	0x966c, { 0xE9, 0xA6, 0xAA },
	0x966d, { 0xE9, 0xA9, 0x9C },
	0x966e, { 0xEE, 0xA0, 0xA7 },
	0x966f, { 0xEE, 0xA0, 0xA8 },
	0x9670, { 0xE6, 0xAA, 0x8F },
	0x9671, { 0xE9, 0xA8, 0xA1 },
	0x9672, { 0xE5, 0xAB, 0xBE },
	0x9673, { 0xE9, 0xA8, 0xAF },
	0x9674, { 0xEE, 0xA0, 0xAD },
	0x9675, { 0xE4, 0xAE, 0x90 },
	0x9676, { 0xEE, 0xA0, 0xAF },
	0x9677, { 0xE9, 0xA6, 0xBC },
	0x9678, { 0xE4, 0xAE, 0xBD },
	0x9679, { 0xE4, 0xAE, 0x97 },
	0x967a, { 0xE9, 0x8D, 0xBD },
	0x967b, { 0xE5, 0xA1, 0xB2 },
	0x967c, { 0xEE, 0xA0, 0xB5 },
	0x967d, { 0xE5, 0xA0, 0xA2 },
	0x967e, { 0xEE, 0xA0, 0xB7 },
	0x96a1, { 0xEE, 0xA0, 0xB8 },
	0x96a2, { 0xE7, 0xA1, 0x84 },
	0x96a3, { 0xEE, 0xA0, 0xBA },
	0x96a4, { 0xEE, 0xA0, 0xBB },
	0x96a5, { 0xE6, 0xA3, 0x85 },
	0x96a6, { 0xE3, 0xB5, 0xBD },
	0x96a7, { 0xE9, 0x91, 0x98 },
	0x96a8, { 0xE3, 0xA4, 0xA7 },
	0x96a9, { 0xE6, 0x85, 0x90 },
	0x96aa, { 0xEE, 0xA1, 0x81 },
	0x96ab, { 0xEE, 0xA1, 0x82 },
	0x96ac, { 0xE6, 0x84, 0x87 },
	0x96ad, { 0xE9, 0xB1, 0x8F },
	0x96ae, { 0xE9, 0xB1, 0x93 },
	0x96af, { 0xE9, 0xB1, 0xBB },
	0x96b0, { 0xE9, 0xB0, 0xB5 },
	0x96b1, { 0xE9, 0xB0, 0x90 },
	0x96b2, { 0xE9, 0xAD, 0xBF },
	0x96b3, { 0xE9, 0xAF, 0x8F },
	0x96b4, { 0xEE, 0xA1, 0x8B },
	0x96b5, { 0xE9, 0xAE, 0x9F },
	0x96b6, { 0xEE, 0xA1, 0x8D },
	0x96b7, { 0xEE, 0xA1, 0x8E },
	0x96b8, { 0xE9, 0xB4, 0xA1 },
	0x96b9, { 0xE4, 0xB2, 0xAE },
	0x96ba, { 0xEE, 0xA1, 0x91 },
	0x96bb, { 0xE9, 0xB8, 0x98 },
	0x96bc, { 0xE4, 0xB2, 0xB0 },
	0x96bd, { 0xE9, 0xB4, 0x8C },
	0x96be, { 0xEE, 0xA1, 0x95 },
	0x96bf, { 0xEE, 0xA1, 0x96 },
	0x96c0, { 0xEE, 0xA1, 0x97 },
	0x96c1, { 0xEE, 0xA1, 0x98 },
	0x96c2, { 0xE9, 0xB6, 0xA5 },
	0x96c3, { 0xE8, 0x92, 0xBD },
	0x96c4, { 0xEE, 0xA1, 0x9B },
	0x96c5, { 0xEE, 0xA1, 0x9C },
	0x96c6, { 0xEE, 0xA1, 0x9D },
	0x96c7, { 0xE8, 0x97, 0xBC },
	0x96c8, { 0xE4, 0x94, 0xB3 },
	0x96c9, { 0xEE, 0xA1, 0xA0 },
	0x96ca, { 0xEE, 0xA1, 0xA1 },
	0x96cb, { 0xEE, 0xA1, 0xA2 },
	0x96cc, { 0xE8, 0x90, 0xA0 },
	0x96cd, { 0xE8, 0x97, 0xAE },
	0x96ce, { 0xEE, 0xA1, 0xA5 },
	0x96cf, { 0xEE, 0xA1, 0xA6 },
	0x96d0, { 0xEE, 0xA1, 0xA7 },
	0x96d1, { 0xE7, 0xA7, 0xA2 },
	0x96d2, { 0xEE, 0xA1, 0xA9 },
	0x96d3, { 0xEE, 0xA1, 0xAA },
	0x96d4, { 0xE4, 0xA4, 0xAD },
	0x96d5, { 0xEE, 0xA1, 0xAC },
	0x96d6, { 0xE3, 0xB5, 0xA2 },
	0x96d7, { 0xE9, 0x8F, 0x9B },
	0x96d8, { 0xE9, 0x8A, 0xBE },
	0x96d9, { 0xE9, 0x8D, 0x88 },
	0x96da, { 0xEE, 0xA1, 0xB1 },
	0x96db, { 0xE7, 0xA2, 0xB9 },
	0x96dc, { 0xE9, 0x89, 0xB7 },
	0x96dd, { 0xE9, 0x91, 0x8D },
	0x96de, { 0xE4, 0xBF, 0xA4 },
	0x96df, { 0xE3, 0x91, 0x80 },
	0x96e0, { 0xE9, 0x81, 0xA4 },
	0x96e1, { 0xEE, 0xA1, 0xB8 },
	0x96e2, { 0xE7, 0xA0, 0xBD },
	0x96e3, { 0xE7, 0xA1, 0x94 },
	0x96e4, { 0xE7, 0xA2, 0xB6 },
	0x96e5, { 0xE7, 0xA1, 0x8B },
	0x96e6, { 0xEE, 0xA1, 0xBD },
	0x96e7, { 0xEE, 0xA1, 0xBE },
	0x96e8, { 0xEE, 0xA1, 0xBF },
	0x96e9, { 0xE3, 0x9A, 0x9A },
	0x96ea, { 0xE4, 0xBD, 0xB2 },
	0x96eb, { 0xE6, 0xBF, 0x9A },
	0x96ec, { 0xE6, 0xBF, 0x99 },
	0x96ee, { 0xE7, 0x80, 0x9E },
	0x96ef, { 0xE5, 0x90, 0x94 },
	0x96f0, { 0xEE, 0xA2, 0x87 },
	0x96f1, { 0xE5, 0x9E, 0xBB },
	0x96f2, { 0xE5, 0xA3, 0xB3 },
	0x96f3, { 0xE5, 0x9E, 0x8A },
	0x96f4, { 0xE9, 0xB4, 0x96 },
	0x96f5, { 0xE5, 0x9F, 0x97 },
	0x96f6, { 0xE7, 0x84, 0xB4 },
	0x96f7, { 0xE3, 0x92, 0xAF },
	0x96f8, { 0xEE, 0xA2, 0x8F },
	0x96f9, { 0xE7, 0x87, 0xAB },
	0x96fa, { 0xEE, 0xA2, 0x91 },
	0x96fb, { 0xEE, 0xA2, 0x92 },
	0x96fd, { 0xEE, 0xA2, 0x94 },
	0x96fe, { 0xEE, 0xA2, 0x95 },
	0x9740, { 0xE6, 0x84, 0x8C },
	0x9741, { 0xE5, 0xAB, 0x8E },
	0x9742, { 0xE5, 0xA8, 0x8B },
	0x9743, { 0xE4, 0x8A, 0xBC },
	0x9744, { 0xEE, 0xA2, 0x9A },
	0x9745, { 0xE3, 0x9C, 0xAC },
	0x9746, { 0xE4, 0xAD, 0xBB },
	0x9747, { 0xEE, 0xA2, 0x9D },
	0x9748, { 0xE9, 0x8E, 0xBB },
	0x9749, { 0xE9, 0x8E, 0xB8 },
	0x974a, { 0xEE, 0xA2, 0xA0 },
	0x974b, { 0xEE, 0xA2, 0xA1 },
	0x974c, { 0xE8, 0x91, 0xB2 },
	0x974d, { 0xEE, 0xA2, 0xA3 },
	0x974e, { 0xEE, 0xA2, 0xA4 },
	0x974f, { 0xEE, 0xA2, 0xA5 },
	0x9750, { 0xEE, 0xA2, 0xA6 },
	0x9751, { 0xEE, 0xA2, 0xA7 },
	0x9752, { 0xE5, 0xA6, 0x94 },
	0x9753, { 0xEE, 0xA2, 0xA9 },
	0x9754, { 0xEE, 0xA2, 0xAA },
	0x9755, { 0xE7, 0xB6, 0xA8 },
	0x9756, { 0xEE, 0xA2, 0xAC },
	0x9757, { 0xEE, 0xA2, 0xAD },
	0x9758, { 0xEE, 0xA2, 0xAE },
	0x9759, { 0xEE, 0xA2, 0xAF },
	0x975a, { 0xEE, 0xA2, 0xB0 },
	0x975b, { 0xE9, 0x8B, 0xA5 },
	0x975c, { 0xE7, 0x8F, 0xA2 },
	0x975d, { 0xE3, 0xBB, 0xA9 },
	0x975e, { 0xE7, 0x92, 0xB4 },
	0x975f, { 0xEE, 0xA2, 0xB5 },
	0x9760, { 0xEE, 0xA2, 0xB6 },
	0x9761, { 0xE3, 0xBB, 0xA1 },
	0x9762, { 0xEE, 0xA2, 0xB8 },
	0x9763, { 0xE6, 0xAB, 0x98 },
	0x9764, { 0xE7, 0x8F, 0xB3 },
	0x9765, { 0xE7, 0x8F, 0xBB },
	0x9766, { 0xE3, 0xBB, 0x96 },
	0x9767, { 0xEE, 0xA2, 0xBD },
	0x9768, { 0xEE, 0xA2, 0xBE },
	0x9769, { 0xEE, 0xA2, 0xBF },
	0x976a, { 0xEE, 0xA3, 0x80 },
	0x976b, { 0xEE, 0xA3, 0x81 },
	0x976c, { 0xEE, 0xA3, 0x82 },
	0x976d, { 0xEE, 0xA3, 0x83 },
	0x976e, { 0xE7, 0x91, 0x88 },
	0x976f, { 0xEE, 0xA3, 0x85 },
	0x9770, { 0xE7, 0x82, 0xA5 },
	0x9771, { 0xEE, 0xA3, 0x87 },
	0x9772, { 0xE9, 0x8A, 0x84 },
	0x9773, { 0xE7, 0x8F, 0xA6 },
	0x9774, { 0xE9, 0x8D, 0x9F },
	0x9775, { 0xEE, 0xA3, 0x8B },
	0x9776, { 0xE9, 0x8C, 0xB1 },
	0x9777, { 0xEE, 0xA3, 0x8D },
	0x9778, { 0xEE, 0xA3, 0x8E },
	0x9779, { 0xE9, 0x8E, 0x86 },
	0x977a, { 0xEE, 0xA3, 0x90 },
	0x977b, { 0xEE, 0xA3, 0x91 },
	0x977c, { 0xE4, 0xA4, 0xB5 },
	0x977d, { 0xEE, 0xA3, 0x93 },
	0x977e, { 0xE7, 0x85, 0xAB },
	0x97a1, { 0xEE, 0xA3, 0x95 },
	0x97a2, { 0xEE, 0xA3, 0x96 },
	0x97a3, { 0xE5, 0x9A, 0xA4 },
	0x97a4, { 0xEE, 0xA3, 0x98 },
	0x97a5, { 0xEE, 0xA3, 0x99 },
	0x97a6, { 0xEE, 0xA3, 0x9A },
	0x97a7, { 0xE5, 0x94, 0x82 },
	0x97a8, { 0xE7, 0xA7, 0x84 },
	0x97a9, { 0xEE, 0xA3, 0x9D },
	0x97aa, { 0xE7, 0xB7, 0xBE },
	0x97ab, { 0xEE, 0xA3, 0x9F },
	0x97ac, { 0xEE, 0xA3, 0xA0 },
	0x97ad, { 0xEE, 0xA3, 0xA1 },
	0x97ae, { 0xE4, 0x94, 0xAE },
	0x97af, { 0xE9, 0x90, 0x81 },
	0x97b0, { 0xE3, 0x9C, 0x8A },
	0x97b1, { 0xEE, 0xA3, 0xA5 },
	0x97b2, { 0xEE, 0xA3, 0xA6 },
	0x97b3, { 0xE5, 0xA6, 0xB0 },
	0x97b4, { 0xEE, 0xA3, 0xA8 },
	0x97b5, { 0xEE, 0xA3, 0xA9 },
	0x97b6, { 0xEE, 0xA3, 0xAA },
	0x97b7, { 0xE5, 0xAA, 0xA1 },
	0x97b8, { 0xE3, 0x9B, 0xA2 },
	0x97b9, { 0xEE, 0xA3, 0xAD },
	0x97ba, { 0xE3, 0x9A, 0xB0 },
	0x97bb, { 0xE9, 0x89, 0x9F },
	0x97bc, { 0xE5, 0xA9, 0xB9 },
	0x97bd, { 0xEE, 0xA3, 0xB1 },
	0x97be, { 0xEE, 0xA3, 0xB2 },
	0x97bf, { 0xE9, 0x8D, 0xB4 },
	0x97c0, { 0xE3, 0xB3, 0x8D },
	0x97c1, { 0xEE, 0xA3, 0xB5 },
	0x97c2, { 0xE4, 0xAA, 0x96 },
	0x97c3, { 0xE3, 0xA6, 0x8A },
	0x97c4, { 0xE5, 0x83, 0xB4 },
	0x97c5, { 0xE3, 0xB5, 0xA9 },
	0x97c6, { 0xE3, 0xB5, 0x8C },
	0x97c7, { 0xEE, 0xA3, 0xBB },
	0x97c8, { 0xE7, 0x85, 0xB5 },
	0x97c9, { 0xE4, 0x8B, 0xBB },
	0x97ca, { 0xEE, 0xA3, 0xBE },
	0x97cb, { 0xE6, 0xB8, 0x8F },
	0x97cc, { 0xEE, 0xA4, 0x80 },
	0x97cd, { 0xE4, 0x93, 0xAB },
	0x97ce, { 0xE6, 0xB5, 0x97 },
	0x97cf, { 0xEE, 0xA4, 0x83 },
	0x97d0, { 0xE7, 0x81, 0xA7 },
	0x97d1, { 0xE6, 0xB2, 0xAF },
	0x97d2, { 0xE3, 0xB3, 0x96 },
	0x97d3, { 0xEE, 0xA4, 0x87 },
	0x97d4, { 0xEE, 0xA4, 0x88 },
	0x97d5, { 0xE6, 0xB8, 0x82 },
	0x97d6, { 0xE6, 0xBC, 0x8C },
	0x97d7, { 0xE3, 0xB5, 0xAF },
	0x97d8, { 0xEE, 0xA4, 0x8C },
	0x97d9, { 0xE7, 0x95, 0x91 },
	0x97da, { 0xE3, 0x9A, 0xBC },
	0x97db, { 0xE3, 0x93, 0x88 },
	0x97dc, { 0xE4, 0x9A, 0x80 },
	0x97dd, { 0xE3, 0xBB, 0x9A },
	0x97de, { 0xE4, 0xA1, 0xB1 },
	0x97df, { 0xE5, 0xA7, 0x84 },
	0x97e0, { 0xE9, 0x89, 0xAE },
	0x97e1, { 0xE4, 0xA4, 0xBE },
	0x97e2, { 0xE8, 0xBD, 0x81 },
	0x97e3, { 0xEE, 0xA4, 0x97 },
	0x97e4, { 0xEE, 0xA4, 0x98 },
	0x97e5, { 0xE5, 0xA0, 0x92 },
	0x97e6, { 0xE5, 0x9F, 0x88 },
	0x97e7, { 0xE3, 0x9B, 0x96 },
	0x97e8, { 0xEE, 0xA4, 0x9C },
	0x97e9, { 0xE7, 0x83, 0xBE },
	0x97ea, { 0xEE, 0xA4, 0x9E },
	0x97eb, { 0xEE, 0xA4, 0x9F },
	0x97ec, { 0xEE, 0xA4, 0xA0 },
	0x97ed, { 0xEE, 0xA4, 0xA1 },
	0x97ee, { 0xEE, 0xA4, 0xA2 },
	0x97ef, { 0xE6, 0xA2, 0xB9 },
	0x97f0, { 0xE6, 0xA5, 0xA7 },
	0x97f1, { 0xEE, 0xA4, 0xA5 },
	0x97f2, { 0xEE, 0xA4, 0xA6 },
	0x97f3, { 0xEE, 0xA4, 0xA7 },
	0x97f4, { 0xEE, 0xA4, 0xA8 },
	0x97f5, { 0xEE, 0xA4, 0xA9 },
	0x97f6, { 0xEE, 0xA4, 0xAA },
	0x97f7, { 0xEE, 0xA4, 0xAB },
	0x97f8, { 0xEE, 0xA4, 0xAC },
	0x97f9, { 0xE6, 0xA8, 0x9A },
	0x97fa, { 0xEE, 0xA4, 0xAE },
	0x97fb, { 0xEE, 0xA4, 0xAF },
	0x97fc, { 0xE8, 0x90, 0xBE },
	0x97fd, { 0xE4, 0x93, 0x9F },
	0x97fe, { 0xE4, 0x93, 0x8E },
	0x9840, { 0xEE, 0xA4, 0xB3 },
	0x9841, { 0xEE, 0xA4, 0xB4 },
	0x9842, { 0xEE, 0xA4, 0xB5 },
	0x9843, { 0xEE, 0xA4, 0xB6 },
	0x9844, { 0xE6, 0xBC, 0x97 },
	0x9845, { 0xEE, 0xA4, 0xB8 },
	0x9846, { 0xE8, 0x8C, 0xBD },
	0x9847, { 0xEE, 0xA4, 0xBA },
	0x9848, { 0xE8, 0x8F, 0xAD },
	0x9849, { 0xEE, 0xA4, 0xBC },
	0x984a, { 0xEE, 0xA4, 0xBD },
	0x984b, { 0xEE, 0xA4, 0xBE },
	0x984c, { 0xE5, 0xA6, 0x89 },
	0x984d, { 0xE5, 0xAA, 0x82 },
	0x984e, { 0xEE, 0xA5, 0x81 },
	0x984f, { 0xE5, 0xA9, 0xA1 },
	0x9850, { 0xE5, 0xA9, 0xB1 },
	0x9851, { 0xEE, 0xA5, 0x84 },
	0x9852, { 0xEE, 0xA5, 0x85 },
	0x9853, { 0xE3, 0x9C, 0xAD },
	0x9854, { 0xE5, 0xA7, 0xAF },
	0x9855, { 0xEE, 0xA5, 0x88 },
	0x9856, { 0xE3, 0x9B, 0x87 },
	0x9857, { 0xE7, 0x86, 0x8E },
	0x9858, { 0xE9, 0x8E, 0x90 },
	0x9859, { 0xE6, 0x9A, 0x9A },
	0x985a, { 0xEE, 0xA5, 0x8D },
	0x985b, { 0xE5, 0xA9, 0xAE },
	0x985c, { 0xE5, 0xA8, 0xAB },
	0x985d, { 0xEE, 0xA5, 0x90 },
	0x985e, { 0xE6, 0xA8, 0xAB },
	0x985f, { 0xEE, 0xA5, 0x92 },
	0x9860, { 0xEE, 0xA5, 0x93 },
	0x9861, { 0xEE, 0xA5, 0x94 },
	0x9862, { 0xEE, 0xA5, 0x95 },
	0x9863, { 0xE7, 0x84, 0x9D },
	0x9864, { 0xEE, 0xA5, 0x97 },
	0x9865, { 0xEE, 0xA5, 0x98 },
	0x9866, { 0xE4, 0xBE, 0xB0 },
	0x9867, { 0xEE, 0xA5, 0x9A },
	0x9868, { 0xE5, 0xB3, 0x82 },
	0x9869, { 0xEE, 0xA5, 0x9C },
	0x986a, { 0xEE, 0xA5, 0x9D },
	0x986b, { 0xEE, 0xA5, 0x9E },
	0x986c, { 0xE6, 0xA8, 0x8C },
	0x986d, { 0xEE, 0xA5, 0xA0 },
	0x986e, { 0xEE, 0xA5, 0xA1 },
	0x986f, { 0xE7, 0x82, 0xA6 },
	0x9870, { 0xE7, 0x84, 0xB3 },
	0x9871, { 0xEE, 0xA5, 0xA4 },
	0x9872, { 0xE3, 0xB6, 0xA5 },
	0x9873, { 0xE6, 0xB3, 0x9F },
	0x9874, { 0xEE, 0xA5, 0xA7 },
	0x9875, { 0xEE, 0xA5, 0xA8 },
	0x9876, { 0xE7, 0xB9, 0xA5 },
	0x9877, { 0xE5, 0xA7, 0xAB },
	0x9878, { 0xE5, 0xB4, 0xAF },
	0x9879, { 0xE3, 0xB7, 0xB3 },
	0x987a, { 0xE5, 0xBD, 0x9C },
	0x987b, { 0xEE, 0xA5, 0xAE },
	0x987c, { 0xEE, 0xA5, 0xAF },
	0x987d, { 0xE7, 0xB6, 0xA4 },
	0x987e, { 0xE8, 0x90, 0xA6 },
	0x98a1, { 0xE5, 0x92, 0x85 },
	0x98a2, { 0xEE, 0xA5, 0xB3 },
	0x98a3, { 0xEE, 0xA5, 0xB4 },
	0x98a4, { 0xEE, 0xA5, 0xB5 },
	0x98a5, { 0xE5, 0x9D, 0xBE },
	0x98a6, { 0xEE, 0xA5, 0xB7 },
	0x98a7, { 0xEE, 0xA5, 0xB8 },
	0x98a8, { 0xE3, 0xBF, 0xA5 },
	0x98a9, { 0xEE, 0xA5, 0xBA },
	0x98aa, { 0xEE, 0xA5, 0xBB },
	0x98ab, { 0xE7, 0x80, 0x83 },
	0x98ac, { 0xEE, 0xA5, 0xBD },
	0x98ad, { 0xE5, 0xB5, 0xB0 },
	0x98ae, { 0xE7, 0x8E, 0x8F },
	0x98af, { 0xE7, 0xB3, 0x93 },
	0x98b0, { 0xEE, 0xA6, 0x81 },
	0x98b1, { 0xEE, 0xA6, 0x82 },
	0x98b2, { 0xE4, 0xBF, 0x88 },
	0x98b3, { 0xE7, 0xBF, 0xA7 },
	0x98b4, { 0xE7, 0x8B, 0x8D },
	0x98b5, { 0xE7, 0x8C, 0x90 },
	0x98b6, { 0xEE, 0xA6, 0x87 },
	0x98b7, { 0xE7, 0x8C, 0xB8 },
	0x98b8, { 0xE7, 0x8C, 0xB9 },
	0x98b9, { 0xEE, 0xA6, 0x8A },
	0x98ba, { 0xE7, 0x8D, 0x81 },
	0x98bb, { 0xE7, 0x8D, 0x88 },
	0x98bc, { 0xE3, 0xBA, 0xA9 },
	0x98bd, { 0xEE, 0xA6, 0x8E },
	0x98be, { 0xE9, 0x81, 0xAC },
	0x98bf, { 0xE7, 0x87, 0xB5 },
	0x98c0, { 0xEE, 0xA6, 0x91 },
	0x98c1, { 0xE7, 0x8F, 0xA1 },
	0x98c2, { 0xE8, 0x87, 0xB6 },
	0x98c3, { 0xE3, 0xBB, 0x8A },
	0x98c4, { 0xE7, 0x9C, 0x8C },
	0x98c5, { 0xE3, 0xBB, 0x91 },
	0x98c6, { 0xE6, 0xB2, 0xA2 },
	0x98c7, { 0xE5, 0x9B, 0xBD },
	0x98c8, { 0xE7, 0x90, 0x99 },
	0x98c9, { 0xE7, 0x90, 0x9E },
	0x98ca, { 0xE7, 0x90, 0x9F },
	0x98cb, { 0xE3, 0xBB, 0xA2 },
	0x98cc, { 0xE3, 0xBB, 0xB0 },
	0x98cd, { 0xE3, 0xBB, 0xB4 },
	0x98ce, { 0xE3, 0xBB, 0xBA },
	0x98cf, { 0xE7, 0x93, 0x93 },
	0x98d0, { 0xE3, 0xBC, 0x8E },
	0x98d1, { 0xE3, 0xBD, 0x93 },
	0x98d2, { 0xE7, 0x95, 0x82 },
	0x98d3, { 0xE7, 0x95, 0xAD },
	0x98d4, { 0xE7, 0x95, 0xB2 },
	0x98d5, { 0xE7, 0x96, 0x8D },
	0x98d6, { 0xE3, 0xBD, 0xBC },
	0x98d7, { 0xE7, 0x97, 0x88 },
	0x98d8, { 0xE7, 0x97, 0x9C },
	0x98d9, { 0xE3, 0xBF, 0x80 },
	0x98da, { 0xE7, 0x99, 0x8D },
	0x98db, { 0xE3, 0xBF, 0x97 },
	0x98dc, { 0xE7, 0x99, 0xB4 },
	0x98dd, { 0xE3, 0xBF, 0x9C },
	0x98de, { 0xE7, 0x99, 0xBA },
	0x98df, { 0xEE, 0xA6, 0xB0 },
	0x98e0, { 0xE7, 0x86, 0x88 },
	0x98e1, { 0xE5, 0x98, 0xA3 },
	0x98e2, { 0xE8, 0xA6, 0x80 },
	0x98e3, { 0xE5, 0xA1, 0xA9 },
	0x98e4, { 0xE4, 0x80, 0x9D },
	0x98e5, { 0xE7, 0x9D, 0x83 },
	0x98e6, { 0xE4, 0x80, 0xB9 },
	0x98e7, { 0xE6, 0x9D, 0xA1 },
	0x98e8, { 0xE4, 0x81, 0x85 },
	0x98e9, { 0xE3, 0x97, 0x9B },
	0x98ea, { 0xE7, 0x9E, 0x98 },
	0x98eb, { 0xE4, 0x81, 0xAA },
	0x98ec, { 0xE4, 0x81, 0xAF },
	0x98ed, { 0xE5, 0xB1, 0x9E },
	0x98ee, { 0xE7, 0x9E, 0xBE },
	0x98ef, { 0xE7, 0x9F, 0x8B },
	0x98f0, { 0xE5, 0xA3, 0xB2 },
	0x98f1, { 0xE7, 0xA0, 0x98 },
	0x98f2, { 0xE7, 0x82, 0xB9 },
	0x98f3, { 0xE7, 0xA0, 0x9C },
	0x98f4, { 0xE4, 0x82, 0xA8 },
	0x98f5, { 0xE7, 0xA0, 0xB9 },
	0x98f6, { 0xE7, 0xA1, 0x87 },
	0x98f7, { 0xE7, 0xA1, 0x91 },
	0x98f8, { 0xE7, 0xA1, 0xA6 },
	0x98f9, { 0xE8, 0x91, 0x88 },
	0x98fa, { 0xEE, 0xA7, 0x8B },
	0x98fb, { 0xE7, 0xA4, 0xB3 },
	0x98fc, { 0xE6, 0xA0, 0x83 },
	0x98fd, { 0xE7, 0xA4, 0xB2 },
	0x98fe, { 0xE4, 0x84, 0x83 },
	0x9940, { 0xE4, 0x84, 0x89 },
	0x9941, { 0xE7, 0xA6, 0x91 },
	0x9942, { 0xE7, 0xA6, 0x99 },
	0x9943, { 0xE8, 0xBE, 0xBB },
	0x9944, { 0xE7, 0xA8, 0x86 },
	0x9945, { 0xE8, 0xBE, 0xBC },
	0x9946, { 0xE4, 0x85, 0xA7 },
	0x9947, { 0xE7, 0xAA, 0x91 },
	0x9948, { 0xE4, 0x86, 0xB2 },
	0x9949, { 0xE7, 0xAA, 0xBC },
	0x994a, { 0xE8, 0x89, 0xB9 },
	0x994b, { 0xE4, 0x87, 0x84 },
	0x994c, { 0xE7, 0xAB, 0x8F },
	0x994d, { 0xE7, 0xAB, 0x9B },
	0x994e, { 0xE4, 0x87, 0x8F },
	0x994f, { 0xE4, 0xB8, 0xA1 },
	0x9950, { 0xE7, 0xAD, 0xA2 },
	0x9951, { 0xE7, 0xAD, 0xAC },
	0x9952, { 0xE7, 0xAD, 0xBB },
	0x9953, { 0xE7, 0xB0, 0x92 },
	0x9954, { 0xE7, 0xB0, 0x9B },
	0x9955, { 0xE4, 0x89, 0xA0 },
	0x9956, { 0xE4, 0x89, 0xBA },
	0x9957, { 0xE7, 0xB1, 0xBB },
	0x9958, { 0xE7, 0xB2, 0x9C },
	0x9959, { 0xE4, 0x8A, 0x8C },
	0x995a, { 0xE7, 0xB2, 0xB8 },
	0x995b, { 0xE4, 0x8A, 0x94 },
	0x995c, { 0xE7, 0xB3, 0xAD },
	0x995d, { 0xE8, 0xBE, 0x93 },
	0x995e, { 0xE7, 0x83, 0x80 },
	0x995f, { 0xEE, 0xA7, 0xAF },
	0x9960, { 0xE7, 0xB7, 0x8F },
	0x9961, { 0xE7, 0xB7, 0x94 },
	0x9962, { 0xE7, 0xB7, 0x90 },
	0x9963, { 0xE7, 0xB7, 0xBD },
	0x9964, { 0xE7, 0xBE, 0xAE },
	0x9965, { 0xE7, 0xBE, 0xB4 },
	0x9966, { 0xE7, 0x8A, 0x9F },
	0x9967, { 0xE4, 0x8E, 0x97 },
	0x9968, { 0xE8, 0x80, 0xA0 },
	0x9969, { 0xE8, 0x80, 0xA5 },
	0x996a, { 0xE7, 0xAC, 0xB9 },
	0x996b, { 0xE8, 0x80, 0xAE },
	0x996c, { 0xE8, 0x80, 0xB1 },
	0x996d, { 0xE8, 0x81, 0x94 },
	0x996e, { 0xE3, 0xB7, 0x8C },
	0x996f, { 0xE5, 0x9E, 0xB4 },
	0x9970, { 0xE7, 0x82, 0xA0 },
	0x9971, { 0xE8, 0x82, 0xB7 },
	0x9972, { 0xE8, 0x83, 0xA9 },
	0x9973, { 0xE4, 0x8F, 0xAD },
	0x9974, { 0xE8, 0x84, 0x8C },
	0x9975, { 0xE7, 0x8C, 0xAA },
	0x9976, { 0xE8, 0x84, 0x8E },
	0x9977, { 0xE8, 0x84, 0x92 },
	0x9978, { 0xE7, 0x95, 0xA0 },
	0x9979, { 0xE8, 0x84, 0x94 },
	0x997a, { 0xE4, 0x90, 0x81 },
	0x997b, { 0xE3, 0xAC, 0xB9 },
	0x997c, { 0xE8, 0x85, 0x96 },
	0x997d, { 0xE8, 0x85, 0x99 },
	0x997e, { 0xE8, 0x85, 0x9A },
	0x99a1, { 0xE4, 0x90, 0x93 },
	0x99a2, { 0xE5, 0xA0, 0xBA },
	0x99a3, { 0xE8, 0x85, 0xBC },
	0x99a4, { 0xE8, 0x86, 0x84 },
	0x99a5, { 0xE4, 0x90, 0xA5 },
	0x99a6, { 0xE8, 0x86, 0x93 },
	0x99a7, { 0xE4, 0x90, 0xAD },
	0x99a8, { 0xE8, 0x86, 0xA5 },
	0x99a9, { 0xE5, 0x9F, 0xAF },
	0x99aa, { 0xE8, 0x87, 0x81 },
	0x99ab, { 0xE8, 0x87, 0xA4 },
	0x99ac, { 0xE8, 0x89, 0x94 },
	0x99ad, { 0xE4, 0x92, 0x8F },
	0x99ae, { 0xE8, 0x8A, 0xA6 },
	0x99af, { 0xE8, 0x89, 0xB6 },
	0x99b0, { 0xE8, 0x8B, 0x8A },
	0x99b1, { 0xE8, 0x8B, 0x98 },
	0x99b2, { 0xE8, 0x8B, 0xBF },
	0x99b3, { 0xE4, 0x92, 0xB0 },
	0x99b4, { 0xE8, 0x8D, 0x97 },
	0x99b5, { 0xE9, 0x99, 0xA9 },
	0x99b6, { 0xE6, 0xA6, 0x8A },
	0x99b7, { 0xE8, 0x90, 0x85 },
	0x99b8, { 0xE7, 0x83, 0xB5 },
	0x99b9, { 0xE8, 0x91, 0xA4 },
	0x99ba, { 0xE6, 0x83, 0xA3 },
	0x99bb, { 0xE8, 0x92, 0x88 },
	0x99bc, { 0xE4, 0x94, 0x84 },
	0x99bd, { 0xE8, 0x92, 0xBE },
	0x99be, { 0xE8, 0x93, 0xA1 },
	0x99bf, { 0xE8, 0x93, 0xB8 },
	0x99c0, { 0xE8, 0x94, 0x90 },
	0x99c1, { 0xE8, 0x94, 0xB8 },
	0x99c2, { 0xE8, 0x95, 0x92 },
	0x99c3, { 0xE4, 0x94, 0xBB },
	0x99c4, { 0xE8, 0x95, 0xAF },
	0x99c5, { 0xE8, 0x95, 0xB0 },
	0x99c6, { 0xE8, 0x97, 0xA0 },
	0x99c7, { 0xE4, 0x95, 0xB7 },
	0x99c8, { 0xE8, 0x99, 0xB2 },
	0x99c9, { 0xE8, 0x9A, 0x92 },
	0x99ca, { 0xE8, 0x9A, 0xB2 },
	0x99cb, { 0xE8, 0x9B, 0xAF },
	0x99cc, { 0xE9, 0x99, 0x85 },
	0x99cd, { 0xE8, 0x9E, 0x8B },
	0x99ce, { 0xE4, 0x98, 0x86 },
	0x99cf, { 0xE4, 0x98, 0x97 },
	0x99d0, { 0xE8, 0xA2, 0xAE },
	0x99d1, { 0xE8, 0xA3, 0xBF },
	0x99d2, { 0xE8, 0xA4, 0xA4 },
	0x99d3, { 0xE8, 0xA5, 0x87 },
	0x99d4, { 0xE8, 0xA6, 0x91 },
	0x99d5, { 0xEE, 0xA9, 0x83 },
	0x99d6, { 0xE8, 0xA8, 0xA9 },
	0x99d7, { 0xE8, 0xA8, 0xB8 },
	0x99d8, { 0xE8, 0xAA, 0x94 },
	0x99d9, { 0xE8, 0xAA, 0xB4 },
	0x99da, { 0xE8, 0xB1, 0x91 },
	0x99db, { 0xE8, 0xB3, 0x94 },
	0x99dc, { 0xE8, 0xB3, 0xB2 },
	0x99dd, { 0xE8, 0xB4, 0x9C },
	0x99de, { 0xE4, 0x9E, 0x98 },
	0x99df, { 0xE5, 0xA1, 0x9F },
	0x99e0, { 0xE8, 0xB7, 0x83 },
	0x99e1, { 0xE4, 0x9F, 0xAD },
	0x99e2, { 0xE4, 0xBB, 0xAE },
	0x99e3, { 0xE8, 0xB8, 0xBA },
	0x99e4, { 0xE5, 0x97, 0x98 },
	0x99e5, { 0xE5, 0x9D, 0x94 },
	0x99e6, { 0xE8, 0xB9, 0xB1 },
	0x99e7, { 0xE5, 0x97, 0xB5 },
	0x99e8, { 0xE8, 0xBA, 0xB0 },
	0x99e9, { 0xE4, 0xA0, 0xB7 },
	0x99ea, { 0xE8, 0xBB, 0x8E },
	0x99eb, { 0xE8, 0xBB, 0xA2 },
	0x99ec, { 0xE8, 0xBB, 0xA4 },
	0x99ed, { 0xE8, 0xBB, 0xAD },
	0x99ee, { 0xE8, 0xBB, 0xB2 },
	0x99ef, { 0xE8, 0xBE, 0xB7 },
	0x99f0, { 0xE8, 0xBF, 0x81 },
	0x99f1, { 0xE8, 0xBF, 0x8A },
	0x99f2, { 0xE8, 0xBF, 0x8C },
	0x99f3, { 0xE9, 0x80, 0xB3 },
	0x99f4, { 0xE9, 0xA7, 0x84 },
	0x99f5, { 0xE4, 0xA2, 0xAD },
	0x99f6, { 0xE9, 0xA3, 0xA0 },
	0x99f7, { 0xE9, 0x88, 0x93 },
	0x99f8, { 0xE4, 0xA4, 0x9E },
	0x99f9, { 0xE9, 0x88, 0xA8 },
	0x99fa, { 0xE9, 0x89, 0x98 },
	0x99fb, { 0xE9, 0x89, 0xAB },
	0x99fc, { 0xE9, 0x8A, 0xB1 },
	0x99fd, { 0xE9, 0x8A, 0xAE },
	0x99fe, { 0xE9, 0x8A, 0xBF },
	0x9a40, { 0xE9, 0x8B, 0xA3 },
	0x9a41, { 0xE9, 0x8B, 0xAB },
	0x9a42, { 0xE9, 0x8B, 0xB3 },
	0x9a43, { 0xE9, 0x8B, 0xB4 },
	0x9a44, { 0xE9, 0x8B, 0xBD },
	0x9a45, { 0xE9, 0x8D, 0x83 },
	0x9a46, { 0xE9, 0x8E, 0x84 },
	0x9a47, { 0xE9, 0x8E, 0xAD },
	0x9a48, { 0xE4, 0xA5, 0x85 },
	0x9a49, { 0xE4, 0xA5, 0x91 },
	0x9a4a, { 0xE9, 0xBA, 0xBF },
	0x9a4b, { 0xE9, 0x90, 0x97 },
	0x9a4c, { 0xE5, 0x8C, 0x81 },
	0x9a4d, { 0xE9, 0x90, 0x9D },
	0x9a4e, { 0xE9, 0x90, 0xAD },
	0x9a4f, { 0xE9, 0x90, 0xBE },
	0x9a50, { 0xE4, 0xA5, 0xAA },
	0x9a51, { 0xE9, 0x91, 0x94 },
	0x9a52, { 0xE9, 0x91, 0xB9 },
	0x9a53, { 0xE9, 0x94, 0xAD },
	0x9a54, { 0xE9, 0x96, 0xA2 },
	0x9a55, { 0xE4, 0xA6, 0xA7 },
	0x9a56, { 0xE9, 0x97, 0xB4 },
	0x9a57, { 0xE9, 0x98, 0xB3 },
	0x9a58, { 0xE4, 0xA7, 0xA5 },
	0x9a59, { 0xE6, 0x9E, 0xA0 },
	0x9a5a, { 0xE4, 0xA8, 0xA4 },
	0x9a5b, { 0xE9, 0x9D, 0x80 },
	0x9a5c, { 0xE4, 0xA8, 0xB5 },
	0x9a5d, { 0xE9, 0x9E, 0xB2 },
	0x9a5e, { 0xE9, 0x9F, 0x82 },
	0x9a5f, { 0xE5, 0x99, 0x94 },
	0x9a60, { 0xE4, 0xAB, 0xA4 },
	0x9a61, { 0xE6, 0x83, 0xA8 },
	0x9a62, { 0xE9, 0xA2, 0xB9 },
	0x9a63, { 0xE4, 0xAC, 0x99 },
	0x9a64, { 0xE9, 0xA3, 0xB1 },
	0x9a65, { 0xE5, 0xA1, 0x84 },
	0x9a66, { 0xE9, 0xA4, 0x8E },
	0x9a67, { 0xE9, 0xA4, 0x99 },
	0x9a68, { 0xE5, 0x86, 0xB4 },
	0x9a69, { 0xE9, 0xA4, 0x9C },
	0x9a6a, { 0xE9, 0xA4, 0xB7 },
	0x9a6b, { 0xE9, 0xA5, 0x82 },
	0x9a6c, { 0xE9, 0xA5, 0x9D },
	0x9a6d, { 0xE9, 0xA5, 0xA2 },
	0x9a6e, { 0xE4, 0xAD, 0xB0 },
	0x9a6f, { 0xE9, 0xA7, 0x85 },
	0x9a70, { 0xE4, 0xAE, 0x9D },
	0x9a71, { 0xE9, 0xA8, 0xBC },
	0x9a72, { 0xE9, 0xAC, 0x8F },
	0x9a73, { 0xE7, 0xAA, 0x83 },
	0x9a74, { 0xE9, 0xAD, 0xA9 },
	0x9a75, { 0xE9, 0xAE, 0x81 },
	0x9a76, { 0xE9, 0xAF, 0x9D },
	0x9a77, { 0xE9, 0xAF, 0xB1 },
	0x9a78, { 0xE9, 0xAF, 0xB4 },
	0x9a79, { 0xE4, 0xB1, 0xAD },
	0x9a7a, { 0xE9, 0xB0, 0xA0 },
	0x9a7b, { 0xE3, 0x9D, 0xAF },
	0x9a7c, { 0xEE, 0xAA, 0xA9 },
	0x9a7d, { 0xE9, 0xB5, 0x89 },
	0x9a7e, { 0xE9, 0xB0, 0xBA },
	0x9aa1, { 0xE9, 0xBB, 0xBE },
	0x9aa2, { 0xE5, 0x99, 0x90 },
	0x9aa3, { 0xE9, 0xB6, 0x93 },
	0x9aa4, { 0xE9, 0xB6, 0xBD },
	0x9aa5, { 0xE9, 0xB7, 0x80 },
	0x9aa6, { 0xE9, 0xB7, 0xBC },
	0x9aa7, { 0xE9, 0x93, 0xB6 },
	0x9aa8, { 0xE8, 0xBE, 0xB6 },
	0x9aa9, { 0xE9, 0xB9, 0xBB },
	0x9aaa, { 0xE9, 0xBA, 0xAC },
	0x9aab, { 0xE9, 0xBA, 0xB1 },
	0x9aac, { 0xE9, 0xBA, 0xBD },
	0x9aad, { 0xE9, 0xBB, 0x86 },
	0x9aae, { 0xE9, 0x93, 0x9C },
	0x9aaf, { 0xE9, 0xBB, 0xA2 },
	0x9ab0, { 0xE9, 0xBB, 0xB1 },
	0x9ab1, { 0xE9, 0xBB, 0xB8 },
	0x9ab2, { 0xE7, 0xAB, 0x88 },
	0x9ab3, { 0xE9, 0xBD, 0x84 },
	0x9ab4, { 0xEE, 0xAA, 0xBF },
	0x9ab5, { 0xEE, 0xAB, 0x80 },
	0x9ab6, { 0xEE, 0xAB, 0x81 },
	0x9ab7, { 0xE6, 0xA4, 0x9A },
	0x9ab8, { 0xE9, 0x93, 0x83 },
	0x9ab9, { 0xE5, 0xA6, 0xAC },
	0x9aba, { 0xEE, 0xAB, 0x85 },
	0x9abb, { 0xE5, 0xA1, 0x80 },
	0x9abc, { 0xE9, 0x93, 0x81 },
	0x9abd, { 0xE3, 0x9E, 0xB9 },
	0x9abe, { 0xEE, 0xAB, 0x89 },
	0x9abf, { 0xEE, 0xAB, 0x8A },
	0x9ac0, { 0xEE, 0xAB, 0x8B },
	0x9ac1, { 0xEE, 0xAB, 0x8C },
	0x9ac2, { 0xE5, 0x9D, 0x97 },
	0x9ac3, { 0xE7, 0x85, 0xB3 },
	0x9ac4, { 0xEE, 0xAB, 0x8F },
	0x9ac5, { 0xEE, 0xAB, 0x90 },
	0x9ac6, { 0xEE, 0xAB, 0x91 },
	0x9ac7, { 0xE5, 0x91, 0xAA },
	0x9ac8, { 0xEE, 0xAB, 0x93 },
	0x9ac9, { 0xEE, 0xAB, 0x94 },
	0x9aca, { 0xE5, 0x92, 0x9E },
	0x9acb, { 0xEE, 0xAB, 0x96 },
	0x9acc, { 0xEE, 0xAB, 0x97 },
	0x9acd, { 0xEE, 0xAB, 0x98 },
	0x9ace, { 0xEE, 0xAB, 0x99 },
	0x9acf, { 0xEE, 0xAB, 0x9A },
	0x9ad0, { 0xE6, 0x83, 0xA7 },
	0x9ad1, { 0xEE, 0xAB, 0x9C },
	0x9ad2, { 0xE5, 0x99, 0xBA },
	0x9ad3, { 0xEE, 0xAB, 0x9E },
	0x9ad4, { 0xEE, 0xAB, 0x9F },
	0x9ad5, { 0xEE, 0xAB, 0xA0 },
	0x9ad6, { 0xEE, 0xAB, 0xA1 },
	0x9ad7, { 0xEE, 0xAB, 0xA2 },
	0x9ad8, { 0xEE, 0xAB, 0xA3 },
	0x9ad9, { 0xE6, 0xA5, 0x95 },
	0x9ada, { 0xE9, 0xB0, 0xAF },
	0x9adb, { 0xE8, 0x9E, 0xA5 },
	0x9adc, { 0xEE, 0xAB, 0xA7 },
	0x9add, { 0xEE, 0xAB, 0xA8 },
	0x9ade, { 0xEE, 0xAB, 0xA9 },
	0x9adf, { 0xEE, 0xAB, 0xAA },
	0x9ae0, { 0xEE, 0xAB, 0xAB },
	0x9ae1, { 0xEE, 0xAB, 0xAC },
	0x9ae2, { 0xE5, 0xB0, 0xA0 },
	0x9ae3, { 0xEE, 0xAB, 0xAE },
	0x9ae4, { 0xE5, 0xB8, 0x8B },
	0x9ae5, { 0xEE, 0xAB, 0xB0 },
	0x9ae6, { 0xEE, 0xAB, 0xB1 },
	0x9ae7, { 0xEE, 0xAB, 0xB2 },
	0x9ae8, { 0xE6, 0x9C, 0x9E },
	0x9ae9, { 0xEE, 0xAB, 0xB4 },
	0x9aea, { 0xEE, 0xAB, 0xB5 },
	0x9aeb, { 0xEE, 0xAB, 0xB6 },
	0x9aec, { 0xE3, 0x99, 0x87 },
	0x9aed, { 0xEE, 0xAB, 0xB8 },
	0x9aee, { 0xEE, 0xAB, 0xB9 },
	0x9aef, { 0xEE, 0xAB, 0xBA },
	0x9af0, { 0xEE, 0xAB, 0xBB },
	0x9af1, { 0xE5, 0x8D, 0xA4 },
	0x9af2, { 0xE8, 0x92, 0xAD },
	0x9af3, { 0xEE, 0xAB, 0xBE },
	0x9af4, { 0xEE, 0xAB, 0xBF },
	0x9af5, { 0xEE, 0xAC, 0x80 },
	0x9af6, { 0xE8, 0xAE, 0x81 },
	0x9af7, { 0xEE, 0xAC, 0x82 },
	0x9af8, { 0xEE, 0xAC, 0x83 },
	0x9af9, { 0xEE, 0xAC, 0x84 },
	0x9afa, { 0xEE, 0xAC, 0x85 },
	0x9afb, { 0xE4, 0xB9, 0xB8 },
	0x9afc, { 0xE7, 0x82, 0xBB },
	0x9afd, { 0xEE, 0xAC, 0x88 },
	0x9afe, { 0xEE, 0xAC, 0x89 },
	0x9b40, { 0xEE, 0xAC, 0x8A },
	0x9b41, { 0xEE, 0xAC, 0x8B },
	0x9b42, { 0xEE, 0xAC, 0x8C },
	0x9b43, { 0xEE, 0xAC, 0x8D },
	0x9b44, { 0xEE, 0xAC, 0x8E },
	0x9b45, { 0xEE, 0xAC, 0x8F },
	0x9b46, { 0xE6, 0x8B, 0x83 },
	0x9b47, { 0xEE, 0xAC, 0x91 },
	0x9b48, { 0xEE, 0xAC, 0x92 },
	0x9b49, { 0xE7, 0x86, 0x98 },
	0x9b4a, { 0xE6, 0xA1, 0x95 },
	0x9b4b, { 0xEE, 0xAC, 0x95 },
	0x9b4c, { 0xE6, 0xA7, 0xA9 },
	0x9b4d, { 0xE3, 0x9B, 0x88 },
	0x9b4e, { 0xEE, 0xAC, 0x98 },
	0x9b4f, { 0xEE, 0xAC, 0x99 },
	0x9b50, { 0xEE, 0xAC, 0x9A },
	0x9b51, { 0xEE, 0xAC, 0x9B },
	0x9b52, { 0xEE, 0xAC, 0x9C },
	0x9b53, { 0xEE, 0xAC, 0x9D },
	0x9b54, { 0xE8, 0x8B, 0xBD },
	0x9b55, { 0xEE, 0xAC, 0x9F },
	0x9b56, { 0xEE, 0xAC, 0xA0 },
	0x9b57, { 0xEE, 0xAC, 0xA1 },
	0x9b58, { 0xE8, 0xA6, 0xA5 },
	0x9b59, { 0xEE, 0xAC, 0xA3 },
	0x9b5a, { 0xE8, 0xBE, 0xA0 },
	0x9b5b, { 0xEE, 0xAC, 0xA5 },
	0x9b5c, { 0xE9, 0x9E, 0xB8 },
	0x9b5d, { 0xEE, 0xAC, 0xA7 },
	0x9b5e, { 0xE9, 0xA1, 0x87 },
	0x9b5f, { 0xE9, 0xAA, 0xBD },
	0x9b60, { 0xEE, 0xAC, 0xAA },
	0x9b62, { 0xEE, 0xAC, 0xAC },
	0x9b63, { 0xEE, 0xAC, 0xAD },
	0x9b64, { 0xEE, 0xAC, 0xAE },
	0x9b65, { 0xEE, 0xAC, 0xAF },
	0x9b66, { 0xEE, 0xAC, 0xB0 },
	0x9b67, { 0xEE, 0xAC, 0xB1 },
	0x9b68, { 0xEE, 0xAC, 0xB2 },
	0x9b69, { 0xEE, 0xAC, 0xB3 },
	0x9b6a, { 0xEE, 0xAC, 0xB4 },
	0x9b6b, { 0xEE, 0xAC, 0xB5 },
	0x9b6c, { 0xEE, 0xAC, 0xB6 },
	0x9b6d, { 0xEE, 0xAC, 0xB7 },
	0x9b6e, { 0xEE, 0xAC, 0xB8 },
	0x9b6f, { 0xEE, 0xAC, 0xB9 },
	0x9b70, { 0xE5, 0xBE, 0xB1 },
	0x9b71, { 0xE6, 0x99, 0x88 },
	0x9b72, { 0xE6, 0x9A, 0xBF },
	0x9b73, { 0xEE, 0xAC, 0xBD },
	0x9b74, { 0xEE, 0xAC, 0xBE },
	0x9b75, { 0xEE, 0xAC, 0xBF },
	0x9b77, { 0xEE, 0xAD, 0x81 },
	0x9b79, { 0xEE, 0xAD, 0x83 },
	0x9b7a, { 0xEE, 0xAD, 0x84 },
	0x9b7c, { 0xEE, 0xAD, 0x86 },
	0x9b7d, { 0xE5, 0xA2, 0xB5 },
	0x9b7e, { 0xE6, 0x9C, 0x8E },
	0x9ba1, { 0xE6, 0xA4, 0x98 },
	0x9ba2, { 0xEE, 0xAD, 0x8A },
	0x9ba3, { 0xEE, 0xAD, 0x8B },
	0x9ba4, { 0xEE, 0xAD, 0x8C },
	0x9ba5, { 0xEE, 0xAD, 0x8D },
	0x9ba6, { 0xEE, 0xAD, 0x8E },
	0x9ba7, { 0xEE, 0xAD, 0x8F },
	0x9ba8, { 0xEE, 0xAD, 0x90 },
	0x9ba9, { 0xE4, 0xA3, 0x90 },
	0x9baa, { 0xE4, 0xAA, 0xB8 },
	0x9bab, { 0xEE, 0xAD, 0x93 },
	0x9bac, { 0xEE, 0xAD, 0x94 },
	0x9bad, { 0xEE, 0xAD, 0x95 },
	0x9bae, { 0xEE, 0xAD, 0x96 },
	0x9baf, { 0xEE, 0xAD, 0x97 },
	0x9bb0, { 0xEE, 0xAD, 0x98 },
	0x9bb1, { 0xEE, 0xAD, 0x99 },
	0x9bb2, { 0xEE, 0xAD, 0x9A },
	0x9bb3, { 0xEE, 0xAD, 0x9B },
	0x9bb4, { 0xE5, 0x87, 0x92 },
	0x9bb5, { 0xEE, 0xAD, 0x9D },
	0x9bb6, { 0xE5, 0xA6, 0x9F },
	0x9bb7, { 0xEE, 0xAD, 0x9F },
	0x9bb8, { 0xE3, 0xAE, 0xBE },
	0x9bb9, { 0xEE, 0xAD, 0xA1 },
	0x9bba, { 0xEE, 0xAD, 0xA2 },
	0x9bbb, { 0xEE, 0xAD, 0xA3 },
	0x9bbc, { 0xE5, 0x9E, 0x88 },
	0x9bbd, { 0xEE, 0xAD, 0xA5 },
	0x9bbe, { 0xE3, 0xA6, 0x9B },
	0x9bbf, { 0xEE, 0xAD, 0xA7 },
	0x9bc0, { 0xEE, 0xAD, 0xA8 },
	0x9bc1, { 0xEE, 0xAD, 0xA9 },
	0x9bc2, { 0xE3, 0x9D, 0xA2 },
	0x9bc3, { 0xEE, 0xAD, 0xAB },
	0x9bc4, { 0xE8, 0xAD, 0x9E },
	0x9bc5, { 0xEE, 0xAD, 0xAD },
	0x9bc7, { 0xEE, 0xAD, 0xAF },
	0x9bc8, { 0xEE, 0xAD, 0xB0 },
	0x9bc9, { 0xEE, 0xAD, 0xB1 },
	0x9bca, { 0xE7, 0x88, 0x89 },
	0x9bcb, { 0xEE, 0xAD, 0xB3 },
	0x9bcc, { 0xEE, 0xAD, 0xB4 },
	0x9bcd, { 0xE5, 0xA5, 0xA5 },
	0x9bce, { 0xEE, 0xAD, 0xB6 },
	0x9bcf, { 0xEE, 0xAD, 0xB7 },
	0x9bd0, { 0xEE, 0xAD, 0xB8 },
	0x9bd1, { 0xE8, 0xBB, 0x9A },
	0x9bd2, { 0xEE, 0xAD, 0xBA },
	0x9bd3, { 0xE5, 0x8A, 0x8F },
	0x9bd4, { 0xE5, 0x9C, 0xBF },
	0x9bd5, { 0xE7, 0x85, 0xB1 },
	0x9bd6, { 0xEE, 0xAD, 0xBE },
	0x9bd7, { 0xEE, 0xAD, 0xBF },
	0x9bd8, { 0xEE, 0xAE, 0x80 },
	0x9bd9, { 0xEE, 0xAE, 0x81 },
	0x9bda, { 0xE5, 0x96, 0xBC },
	0x9bdb, { 0xEE, 0xAE, 0x83 },
	0x9bdc, { 0xEE, 0xAE, 0x84 },
	0x9bdd, { 0xEE, 0xAE, 0x85 },
	0x9bdf, { 0xE3, 0x91, 0xB3 },
	0x9be0, { 0xEE, 0xAE, 0x88 },
	0x9be1, { 0xEE, 0xAE, 0x89 },
	0x9be2, { 0xEE, 0xAE, 0x8A },
	0x9be3, { 0xE4, 0x9C, 0x98 },
	0x9be4, { 0xEE, 0xAE, 0x8C },
	0x9be5, { 0xEE, 0xAE, 0x8D },
	0x9be6, { 0xEE, 0xAE, 0x8E },
	0x9be7, { 0xEE, 0xAE, 0x8F },
	0x9be8, { 0xEE, 0xAE, 0x90 },
	0x9be9, { 0xE5, 0x81, 0xA6 },
	0x9bea, { 0xE3, 0x93, 0xBB },
	0x9beb, { 0xEE, 0xAE, 0x93 },
	0x9bed, { 0xEE, 0xAE, 0x95 },
	0x9bee, { 0xE4, 0x9D, 0xBC },
	0x9bef, { 0xEE, 0xAE, 0x97 },
	0x9bf0, { 0xEE, 0xAE, 0x98 },
	0x9bf1, { 0xEE, 0xAE, 0x99 },
	0x9bf2, { 0xEE, 0xAE, 0x9A },
	0x9bf3, { 0xEE, 0xAE, 0x9B },
	0x9bf4, { 0xE5, 0x9E, 0xA1 },
	0x9bf5, { 0xE7, 0x85, 0x91 },
	0x9bf7, { 0xEE, 0xAE, 0x9F },
	0x9bf8, { 0xEE, 0xAE, 0xA0 },
	0x9bf9, { 0xE9, 0x81, 0x96 },
	0x9bfa, { 0xEE, 0xAE, 0xA2 },
	0x9bfb, { 0xEE, 0xAE, 0xA3 },
	0x9bfc, { 0xE8, 0xAD, 0xA2 },
	0x9bfd, { 0xEE, 0xAE, 0xA5 },
	0x9bfe, { 0xEE, 0xAE, 0xA6 },
	0x9c40, { 0xE5, 0xB5, 0x9B },
	0x9c41, { 0xEE, 0xAE, 0xA8 },
	0x9c43, { 0xEE, 0xAE, 0xAA },
	0x9c44, { 0xEE, 0xAE, 0xAB },
	0x9c45, { 0xE8, 0xAB, 0xAA },
	0x9c46, { 0xEE, 0xAE, 0xAD },
	0x9c47, { 0xEE, 0xAE, 0xAE },
	0x9c48, { 0xEE, 0xAE, 0xAF },
	0x9c49, { 0xEE, 0xAE, 0xB0 },
	0x9c4a, { 0xE4, 0xAF, 0x80 },
	0x9c4b, { 0xEE, 0xAE, 0xB2 },
	0x9c4c, { 0xEE, 0xAE, 0xB3 },
	0x9c4d, { 0xEE, 0xAE, 0xB4 },
	0x9c4e, { 0xE9, 0x91, 0xA5 },
	0x9c4f, { 0xEE, 0xAE, 0xB6 },
	0x9c50, { 0xE6, 0x86, 0x95 },
	0x9c51, { 0xE5, 0xA8, 0xA7 },
	0x9c52, { 0xEE, 0xAE, 0xB9 },
	0x9c54, { 0xE5, 0x9A, 0xB9 },
	0x9c55, { 0xEE, 0xAE, 0xBC },
	0x9c56, { 0xEE, 0xAE, 0xBD },
	0x9c57, { 0xE4, 0xB9, 0xAA },
	0x9c58, { 0xEE, 0xAE, 0xBF },
	0x9c59, { 0xE9, 0x99, 0x96 },
	0x9c5a, { 0xE6, 0xB6, 0x8F },
	0x9c5b, { 0xEE, 0xAF, 0x82 },
	0x9c5c, { 0xE3, 0x98, 0x98 },
	0x9c5d, { 0xE8, 0xA5, 0xB7 },
	0x9c5e, { 0xEE, 0xAF, 0x85 },
	0x9c5f, { 0xEE, 0xAF, 0x86 },
	0x9c60, { 0xEE, 0xAF, 0x87 },
	0x9c61, { 0xEE, 0xAF, 0x88 },
	0x9c63, { 0xEE, 0xAF, 0x8A },
	0x9c64, { 0xE7, 0xAD, 0x82 },
	0x9c65, { 0xEE, 0xAF, 0x8C },
	0x9c66, { 0xEE, 0xAF, 0x8D },
	0x9c67, { 0xEE, 0xAF, 0x8E },
	0x9c69, { 0xEE, 0xAF, 0x90 },
	0x9c6a, { 0xE7, 0xA9, 0x85 },
	0x9c6c, { 0xEE, 0xAF, 0x93 },
	0x9c6d, { 0xE9, 0xA8, 0xA6 },
	0x9c6e, { 0xEE, 0xAF, 0x95 },
	0x9c6f, { 0xE3, 0x99, 0x9F },
	0x9c70, { 0xEE, 0xAF, 0x97 },
	0x9c71, { 0xEE, 0xAF, 0x98 },
	0x9c72, { 0xE7, 0xA6, 0x83 },
	0x9c73, { 0xEE, 0xAF, 0x9A },
	0x9c74, { 0xEE, 0xAF, 0x9B },
	0x9c75, { 0xE5, 0xB4, 0xAC },
	0x9c76, { 0xEE, 0xAF, 0x9D },
	0x9c78, { 0xEE, 0xAF, 0x9F },
	0x9c79, { 0xE4, 0x9B, 0x90 },
	0x9c7a, { 0xEE, 0xAF, 0xA1 },
	0x9c7b, { 0xE7, 0x94, 0xBB },
	0x9c7c, { 0xE8, 0xA1, 0xA5 },
	0x9c7d, { 0xEE, 0xAF, 0xA4 },
	0x9c7e, { 0xE5, 0xA2, 0xB6 },
	0x9ca1, { 0xE3, 0x9C, 0x9C },
	0x9ca2, { 0xEE, 0xAF, 0xA7 },
	0x9ca3, { 0xEE, 0xAF, 0xA8 },
	0x9ca4, { 0xEE, 0xAF, 0xA9 },
	0x9ca5, { 0xE3, 0xB1, 0x94 },
	0x9ca6, { 0xEE, 0xAF, 0xAB },
	0x9ca7, { 0xEE, 0xAF, 0xAC },
	0x9ca8, { 0xE9, 0x8A, 0x81 },
	0x9ca9, { 0xEE, 0xAF, 0xAE },
	0x9caa, { 0xEE, 0xAF, 0xAF },
	0x9cab, { 0xE9, 0x8C, 0xB0 },
	0x9cac, { 0xEE, 0xAF, 0xB1 },
	0x9cad, { 0xEE, 0xAF, 0xB2 },
	0x9cae, { 0xE6, 0xB0, 0xB9 },
	0x9caf, { 0xE9, 0x92, 0x9F },
	0x9cb0, { 0xEE, 0xAF, 0xB5 },
	0x9cb1, { 0xEE, 0xAF, 0xB6 },
	0x9cb2, { 0xE8, 0xA0, 0xA7 },
	0x9cb3, { 0xE8, 0xA3, 0xB5 },
	0x9cb4, { 0xEE, 0xAF, 0xB9 },
	0x9cb5, { 0xEE, 0xAF, 0xBA },
	0x9cb6, { 0xEE, 0xAF, 0xBB },
	0x9cb7, { 0xE6, 0xBA, 0xB8 },
	0x9cb8, { 0xEE, 0xAF, 0xBD },
	0x9cb9, { 0xEE, 0xAF, 0xBE },
	0x9cba, { 0xE3, 0xA6, 0xA4 },
	0x9cbb, { 0xE3, 0x9A, 0xB9 },
	0x9cbe, { 0xE4, 0x94, 0xBF },
	0x9cbf, { 0xE6, 0x9A, 0xB6 },
	0x9cc0, { 0xEE, 0xB0, 0x85 },
	0x9cc1, { 0xEE, 0xB0, 0x86 },
	0x9cc2, { 0xE8, 0xA5, 0x83 },
	0x9cc3, { 0xEE, 0xB0, 0x88 },
	0x9cc4, { 0xEE, 0xB0, 0x89 },
	0x9cc5, { 0xE5, 0x9B, 0x96 },
	0x9cc6, { 0xE4, 0x83, 0x9F },
	0x9cc7, { 0xEE, 0xB0, 0x8C },
	0x9cc8, { 0xE3, 0xA6, 0xA1 },
	0x9cc9, { 0xEE, 0xB0, 0x8E },
	0x9cca, { 0xEE, 0xB0, 0x8F },
	0x9ccb, { 0xEE, 0xB0, 0x90 },
	0x9ccc, { 0xE7, 0x86, 0xAD },
	0x9ccd, { 0xE8, 0x8D, 0xA6 },
	0x9cce, { 0xEE, 0xB0, 0x93 },
	0x9ccf, { 0xEE, 0xB0, 0x94 },
	0x9cd1, { 0xE4, 0xB2, 0xB7 },
	0x9cd2, { 0xEE, 0xB0, 0x97 },
	0x9cd3, { 0xEE, 0xB0, 0x98 },
	0x9cd4, { 0xEE, 0xB0, 0x99 },
	0x9cd5, { 0xEE, 0xB0, 0x9A },
	0x9cd6, { 0xEE, 0xB0, 0x9B },
	0x9cd7, { 0xEE, 0xB0, 0x9C },
	0x9cd8, { 0xEE, 0xB0, 0x9D },
	0x9cd9, { 0xE7, 0xAD, 0x83 },
	0x9cda, { 0xE7, 0xA5, 0xBE },
	0x9cdb, { 0xEE, 0xB0, 0xA0 },
	0x9cdc, { 0xE6, 0xBE, 0xB5 },
	0x9cdd, { 0xEE, 0xB0, 0xA2 },
	0x9cde, { 0xE6, 0xA8, 0x83 },
	0x9cdf, { 0xEE, 0xB0, 0xA4 },
	0x9ce0, { 0xE5, 0x8E, 0xA2 },
	0x9ce1, { 0xEE, 0xB0, 0xA6 },
	0x9ce2, { 0xE9, 0x8E, 0xBF },
	0x9ce3, { 0xE6, 0xA0, 0xB6 },
	0x9ce4, { 0xE9, 0x9D, 0x9D },
	0x9ce5, { 0xEE, 0xB0, 0xAA },
	0x9ce6, { 0xEE, 0xB0, 0xAB },
	0x9ce7, { 0xEE, 0xB0, 0xAC },
	0x9ce8, { 0xEE, 0xB0, 0xAD },
	0x9ce9, { 0xEE, 0xB0, 0xAE },
	0x9cea, { 0xEE, 0xB0, 0xAF },
	0x9ceb, { 0xE5, 0xB6, 0x85 },
	0x9cec, { 0xEE, 0xB0, 0xB1 },
	0x9ced, { 0xEE, 0xB0, 0xB2 },
	0x9cee, { 0xE5, 0x9C, 0x95 },
	0x9cef, { 0xE9, 0xA0, 0xA3 },
	0x9cf0, { 0xEE, 0xB0, 0xB5 },
	0x9cf1, { 0xE5, 0xB6, 0xAB },
	0x9cf2, { 0xEE, 0xB0, 0xB7 },
	0x9cf3, { 0xE6, 0x96, 0xBE },
	0x9cf4, { 0xE6, 0xA7, 0x95 },
	0x9cf5, { 0xE5, 0x8F, 0x92 },
	0x9cf6, { 0xEE, 0xB0, 0xBB },
	0x9cf7, { 0xEE, 0xB0, 0xBC },
	0x9cf8, { 0xE3, 0xB0, 0x91 },
	0x9cf9, { 0xE6, 0x9C, 0xB6 },
	0x9cfa, { 0xEE, 0xB0, 0xBF },
	0x9cfb, { 0xEE, 0xB1, 0x80 },
	0x9cfc, { 0xEE, 0xB1, 0x81 },
	0x9cfd, { 0xEE, 0xB1, 0x82 },
	0x9cfe, { 0xEE, 0xB1, 0x83 },
	0x9d40, { 0xEE, 0xB1, 0x84 },
	0x9d41, { 0xEE, 0xB1, 0x85 },
	0x9d42, { 0xEE, 0xB1, 0x86 },
	0x9d43, { 0xEE, 0xB1, 0x87 },
	0x9d44, { 0xEE, 0xB1, 0x88 },
	0x9d45, { 0xEE, 0xB1, 0x89 },
	0x9d46, { 0xE3, 0x97, 0x8A },
	0x9d47, { 0xEE, 0xB1, 0x8B },
	0x9d48, { 0xEE, 0xB1, 0x8C },
	0x9d49, { 0xE4, 0xA3, 0xBA },
	0x9d4a, { 0xE6, 0x8F, 0xA6 },
	0x9d4b, { 0xEE, 0xB1, 0x8F },
	0x9d4c, { 0xE7, 0xA0, 0x88 },
	0x9d4d, { 0xE9, 0x89, 0x95 },
	0x9d4e, { 0xEE, 0xB1, 0x92 },
	0x9d4f, { 0xE4, 0x8F, 0xB2 },
	0x9d50, { 0xEE, 0xB1, 0x94 },
	0x9d51, { 0xE4, 0x8F, 0x9F },
	0x9d52, { 0xEE, 0xB1, 0x96 },
	0x9d53, { 0xEE, 0xB1, 0x97 },
	0x9d54, { 0xEE, 0xB1, 0x98 },
	0x9d55, { 0xE5, 0xA7, 0xB8 },
	0x9d56, { 0xEE, 0xB1, 0x9A },
	0x9d58, { 0xEE, 0xB1, 0x9C },
	0x9d59, { 0xEE, 0xB1, 0x9D },
	0x9d5b, { 0xEE, 0xB1, 0x9F },
	0x9d5c, { 0xEE, 0xB1, 0xA0 },
	0x9d5d, { 0xE3, 0xB7, 0xB7 },
	0x9d5e, { 0xEE, 0xB1, 0xA2 },
	0x9d5f, { 0xEE, 0xB1, 0xA3 },
	0x9d60, { 0xE8, 0xBF, 0x90 },
	0x9d61, { 0xE7, 0x8A, 0x8F },
	0x9d62, { 0xE5, 0x9A, 0x8B },
	0x9d63, { 0xEE, 0xB1, 0xA7 },
	0x9d64, { 0xEE, 0xB1, 0xA8 },
	0x9d65, { 0xEE, 0xB1, 0xA9 },
	0x9d66, { 0xEE, 0xB1, 0xAA },
	0x9d67, { 0xEE, 0xB1, 0xAB },
	0x9d68, { 0xEE, 0xB1, 0xAC },
	0x9d69, { 0xEE, 0xB1, 0xAD },
	0x9d6a, { 0xEE, 0xB1, 0xAE },
	0x9d6b, { 0xEE, 0xB1, 0xAF },
	0x9d6c, { 0xEE, 0xB1, 0xB0 },
	0x9d6d, { 0xEE, 0xB1, 0xB1 },
	0x9d6e, { 0xEE, 0xB1, 0xB2 },
	0x9d6f, { 0xEE, 0xB1, 0xB3 },
	0x9d70, { 0xE7, 0xBA, 0x9F },
	0x9d71, { 0xEE, 0xB1, 0xB5 },
	0x9d72, { 0xEE, 0xB1, 0xB6 },
	0x9d73, { 0xE4, 0xB2, 0xA4 },
	0x9d74, { 0xE9, 0x95, 0x87 },
	0x9d75, { 0xEE, 0xB1, 0xB9 },
	0x9d76, { 0xE7, 0x86, 0xA2 },
	0x9d77, { 0xEE, 0xB1, 0xBB },
	0x9d78, { 0xE4, 0xB6, 0x91 },
	0x9d79, { 0xE9, 0x80, 0x92 },
	0x9d7a, { 0xEE, 0xB1, 0xBE },
	0x9d7b, { 0xE4, 0xB6, 0x9C },
	0x9d7c, { 0xEE, 0xB2, 0x80 },
	0x9d7d, { 0xE8, 0xBE, 0xBE },
	0x9d7e, { 0xE5, 0x97, 0x81 },
	0x9da1, { 0xE8, 0xBE, 0xBA },
	0x9da2, { 0xEE, 0xB2, 0x84 },
	0x9da3, { 0xE8, 0xBE, 0xB9 },
	0x9da4, { 0xEE, 0xB2, 0x86 },
	0x9da5, { 0xE4, 0x94, 0x89 },
	0x9da6, { 0xE7, 0xB9, 0xBF },
	0x9da7, { 0xE6, 0xBD, 0x96 },
	0x9da8, { 0xE6, 0xAA, 0xB1 },
	0x9da9, { 0xE4, 0xBB, 0xAA },
	0x9daa, { 0xE3, 0x93, 0xA4 },
	0x9dab, { 0xEE, 0xB2, 0x8D },
	0x9dac, { 0xEE, 0xB2, 0x8E },
	0x9dad, { 0xE3, 0x9C, 0xBA },
	0x9dae, { 0xE8, 0xBA, 0x80 },
	0x9daf, { 0xEE, 0xB2, 0x91 },
	0x9db0, { 0xEE, 0xB2, 0x92 },
	0x9db1, { 0xEE, 0xB2, 0x93 },
	0x9db2, { 0xEE, 0xB2, 0x94 },
	0x9db3, { 0xEE, 0xB2, 0x95 },
	0x9db4, { 0xEE, 0xB2, 0x96 },
	0x9db5, { 0xE3, 0xB7, 0xAB },
	0x9db6, { 0xEE, 0xB2, 0x98 },
	0x9db7, { 0xEE, 0xB2, 0x99 },
	0x9db8, { 0xEE, 0xB2, 0x9A },
	0x9db9, { 0xEE, 0xB2, 0x9B },
	0x9dba, { 0xE4, 0xBA, 0x9A },
	0x9dbb, { 0xEE, 0xB2, 0x9D },
	0x9dbc, { 0xEE, 0xB2, 0x9E },
	0x9dbd, { 0xE5, 0x9A, 0xBF },
	0x9dbe, { 0xEE, 0xB2, 0xA0 },
	0x9dbf, { 0xE8, 0xB8, 0x8E },
	0x9dc0, { 0xE5, 0xAD, 0xAD },
	0x9dc1, { 0xEE, 0xB2, 0xA3 },
	0x9dc2, { 0xEE, 0xB2, 0xA4 },
	0x9dc3, { 0xE6, 0x8F, 0x9E },
	0x9dc5, { 0xEE, 0xB2, 0xA7 },
	0x9dc6, { 0xEE, 0xB2, 0xA8 },
	0x9dc7, { 0xE6, 0x94, 0xB0 },
	0x9dc8, { 0xE5, 0x98, 0xAD },
	0x9dc9, { 0xEE, 0xB2, 0xAB },
	0x9dca, { 0xE5, 0x90, 0x9A },
	0x9dcb, { 0xEE, 0xB2, 0xAD },
	0x9dcc, { 0xE3, 0xB7, 0x86 },
	0x9dcd, { 0xEE, 0xB2, 0xAF },
	0x9dce, { 0xE4, 0xB1, 0xBD },
	0x9dcf, { 0xE5, 0x98, 0xA2 },
	0x9dd0, { 0xE5, 0x98, 0x9E },
	0x9dd1, { 0xE7, 0xBD, 0x89 },
	0x9dd2, { 0xEE, 0xB2, 0xB4 },
	0x9dd3, { 0xE5, 0xA5, 0xB5 },
	0x9dd4, { 0xEE, 0xB2, 0xB6 },
	0x9dd5, { 0xE8, 0x9D, 0xB0 },
	0x9dd6, { 0xE4, 0xB8, 0x9C },
	0x9dd7, { 0xEE, 0xB2, 0xB9 },
	0x9dd8, { 0xEE, 0xB2, 0xBA },
	0x9dd9, { 0xEE, 0xB2, 0xBB },
	0x9dda, { 0xE8, 0x84, 0x97 },
	0x9ddb, { 0xE9, 0xB5, 0x9E },
	0x9ddc, { 0xE8, 0xB4, 0x98 },
	0x9ddd, { 0xE7, 0x98, 0xBB },
	0x9dde, { 0xE9, 0xB1, 0x85 },
	0x9ddf, { 0xE7, 0x99, 0x8E },
	0x9de0, { 0xE7, 0x9E, 0xB9 },
	0x9de1, { 0xE9, 0x8D, 0x85 },
	0x9de2, { 0xE5, 0x90, 0xB2 },
	0x9de3, { 0xE8, 0x85, 0x88 },
	0x9de4, { 0xE8, 0x8B, 0xB7 },
	0x9de5, { 0xE5, 0x98, 0xA5 },
	0x9de6, { 0xE8, 0x84, 0xB2 },
	0x9de7, { 0xE8, 0x90, 0x98 },
	0x9de8, { 0xE8, 0x82, 0xBD },
	0x9de9, { 0xE5, 0x97, 0xAA },
	0x9dea, { 0xE7, 0xA5, 0xA2 },
	0x9deb, { 0xE5, 0x99, 0x83 },
	0x9dec, { 0xE5, 0x90, 0x96 },
	0x9ded, { 0xEE, 0xB3, 0x8F },
	0x9dee, { 0xE3, 0x97, 0x8E },
	0x9def, { 0xE5, 0x98, 0x85 },
	0x9df0, { 0xE5, 0x97, 0xB1 },
	0x9df1, { 0xE6, 0x9B, 0xB1 },
	0x9df2, { 0xEE, 0xB3, 0x94 },
	0x9df3, { 0xE3, 0x98, 0xAD },
	0x9df4, { 0xE7, 0x94, 0xB4 },
	0x9df5, { 0xE5, 0x97, 0xB0 },
	0x9df6, { 0xE5, 0x96, 0xBA },
	0x9df7, { 0xE5, 0x92, 0x97 },
	0x9df8, { 0xE5, 0x95, 0xB2 },
	0x9df9, { 0xEE, 0xB3, 0x9B },
	0x9dfa, { 0xEE, 0xB3, 0x9C },
	0x9dfb, { 0xE5, 0xBB, 0x90 },
	0x9dfc, { 0xEE, 0xB3, 0x9E },
	0x9dfd, { 0xEE, 0xB3, 0x9F },
	0x9dfe, { 0xEE, 0xB3, 0xA0 },
	0x9e40, { 0xEE, 0xB3, 0xA1 },
	0x9e41, { 0xE9, 0xBA, 0xAB },
	0x9e42, { 0xE7, 0xB5, 0x9A },
	0x9e43, { 0xE5, 0x97, 0x9E },
	0x9e44, { 0xEE, 0xB3, 0xA5 },
	0x9e45, { 0xE6, 0x8A, 0x9D },
	0x9e46, { 0xE9, 0x9D, 0xAD },
	0x9e47, { 0xE5, 0x92, 0x94 },
	0x9e48, { 0xE8, 0xB3, 0x8D },
	0x9e49, { 0xE7, 0x87, 0xB6 },
	0x9e4a, { 0xE9, 0x85, 0xB6 },
	0x9e4b, { 0xE6, 0x8F, 0xBC },
	0x9e4c, { 0xE6, 0x8E, 0xB9 },
	0x9e4d, { 0xE6, 0x8F, 0xBE },
	0x9e4e, { 0xE5, 0x95, 0xA9 },
	0x9e4f, { 0xEE, 0xB3, 0xB0 },
	0x9e50, { 0xE9, 0xB1, 0xB2 },
	0x9e51, { 0xEE, 0xB3, 0xB2 },
	0x9e52, { 0xE5, 0x86, 0x9A },
	0x9e53, { 0xE3, 0x93, 0x9F },
	0x9e54, { 0xEE, 0xB3, 0xB5 },
	0x9e55, { 0xE5, 0x86, 0xA7 },
	0x9e56, { 0xE5, 0x91, 0x8D },
	0x9e57, { 0xE5, 0x94, 0x9E },
	0x9e58, { 0xE5, 0x94, 0x93 },
	0x9e59, { 0xE7, 0x99, 0xA6 },
	0x9e5a, { 0xE8, 0xB8, 0xAD },
	0x9e5b, { 0xEE, 0xB3, 0xBC },
	0x9e5c, { 0xE7, 0x96, 0xB1 },
	0x9e5d, { 0xE8, 0x82, 0xB6 },
	0x9e5e, { 0xE8, 0xA0, 0x84 },
	0x9e5f, { 0xE8, 0x9E, 0x86 },
	0x9e60, { 0xE8, 0xA3, 0x87 },
	0x9e61, { 0xE8, 0x86, 0xB6 },
	0x9e62, { 0xE8, 0x90, 0x9C },
	0x9e63, { 0xEE, 0xB4, 0x84 },
	0x9e64, { 0xE4, 0x93, 0xAC },
	0x9e65, { 0xE7, 0x8C, 0x84 },
	0x9e66, { 0xEE, 0xB4, 0x87 },
	0x9e67, { 0xE5, 0xAE, 0x90 },
	0x9e68, { 0xE8, 0x8C, 0x8B },
	0x9e69, { 0xEE, 0xB4, 0x8A },
	0x9e6a, { 0xE5, 0x99, 0xBB },
	0x9e6b, { 0xEE, 0xB4, 0x8C },
	0x9e6c, { 0xEE, 0xB4, 0x8D },
	0x9e6d, { 0xEE, 0xB4, 0x8E },
	0x9e6e, { 0xEE, 0xB4, 0x8F },
	0x9e6f, { 0xEE, 0xB4, 0x90 },
	0x9e70, { 0xEE, 0xB4, 0x91 },
	0x9e71, { 0xE9, 0x85, 0xB0 },
	0x9e72, { 0xEE, 0xB4, 0x93 },
	0x9e73, { 0xE9, 0x88, 0x88 },
	0x9e74, { 0xEE, 0xB4, 0x95 },
	0x9e75, { 0xEE, 0xB4, 0x96 },
	0x9e76, { 0xEE, 0xB4, 0x97 },
	0x9e77, { 0xEE, 0xB4, 0x98 },
	0x9e78, { 0xE7, 0x89, 0xA6 },
	0x9e79, { 0xEE, 0xB4, 0x9A },
	0x9e7a, { 0xE4, 0x9D, 0x8E },
	0x9e7b, { 0xEE, 0xB4, 0x9C },
	0x9e7c, { 0xEE, 0xB4, 0x9D },
	0x9e7d, { 0xEE, 0xB4, 0x9E },
	0x9e7e, { 0xE4, 0x83, 0xBA },
	0x9ea1, { 0xE9, 0xB1, 0x9D },
	0x9ea2, { 0xE6, 0x94, 0x9F },
	0x9ea3, { 0xEE, 0xB4, 0xA2 },
	0x9ea4, { 0xE4, 0xA3, 0xB3 },
	0x9ea5, { 0xEE, 0xB4, 0xA4 },
	0x9ea6, { 0xEE, 0xB4, 0xA5 },
	0x9ea7, { 0xEE, 0xB4, 0xA6 },
	0x9ea8, { 0xEE, 0xB4, 0xA7 },
	0x9eaa, { 0xEE, 0xB4, 0xA9 },
	0x9eab, { 0xEE, 0xB4, 0xAA },
	0x9ead, { 0xEE, 0xB4, 0xAC },
	0x9eae, { 0xEE, 0xB4, 0xAD },
	0x9eaf, { 0xE7, 0x86, 0xA3 },
	0x9eb0, { 0xE7, 0xBA, 0x8E },
	0x9eb1, { 0xE9, 0xB5, 0x90 },
	0x9eb2, { 0xE4, 0xB8, 0x9A },
	0x9eb3, { 0xE4, 0xB8, 0x84 },
	0x9eb4, { 0xE3, 0x95, 0xB7 },
	0x9eb5, { 0xE5, 0xAC, 0x8D },
	0x9eb6, { 0xE6, 0xB2, 0xB2 },
	0x9eb7, { 0xE5, 0x8D, 0xA7 },
	0x9eb8, { 0xE3, 0x9A, 0xAC },
	0x9eb9, { 0xE3, 0xA7, 0x9C },
	0x9eba, { 0xE5, 0x8D, 0xBD },
	0x9ebb, { 0xE3, 0x9A, 0xA5 },
	0x9ebc, { 0xEE, 0xB4, 0xBB },
	0x9ebd, { 0xE5, 0xA2, 0x9A },
	0x9ebe, { 0xEE, 0xB4, 0xBD },
	0x9ebf, { 0xE8, 0x88, 0xAD },
	0x9ec0, { 0xE5, 0x91, 0x8B },
	0x9ec1, { 0xE5, 0x9E, 0xAA },
	0x9ec2, { 0xEE, 0xB5, 0x81 },
	0x9ec3, { 0xEE, 0xB5, 0x82 },
	0x9ec5, { 0xE3, 0xA9, 0x92 },
	0x9ec6, { 0xEE, 0xB5, 0x85 },
	0x9ec7, { 0xE7, 0x8D, 0xB4 },
	0x9ec8, { 0xEE, 0xB5, 0x87 },
	0x9ec9, { 0xE4, 0xB4, 0x89 },
	0x9eca, { 0xE9, 0xAF, 0xAD },
	0x9ecb, { 0xEE, 0xB5, 0x8A },
	0x9ecc, { 0xEE, 0xB5, 0x8B },
	0x9ecd, { 0xE4, 0xB1, 0x9B },
	0x9ece, { 0xEE, 0xB5, 0x8D },
	0x9ecf, { 0xEE, 0xB5, 0x8E },
	0x9ed0, { 0xEE, 0xB5, 0x8F },
	0x9ed1, { 0xE8, 0x91, 0x9C },
	0x9ed2, { 0xEE, 0xB5, 0x91 },
	0x9ed3, { 0xEE, 0xB5, 0x92 },
	0x9ed4, { 0xEE, 0xB5, 0x93 },
	0x9ed5, { 0xEE, 0xB5, 0x94 },
	0x9ed6, { 0xE6, 0x8C, 0xAE },
	0x9ed7, { 0xE7, 0xB4, 0xA5 },
	0x9ed8, { 0xEE, 0xB5, 0x97 },
	0x9ed9, { 0xEE, 0xB5, 0x98 },
	0x9eda, { 0xE3, 0xA8, 0xAA },
	0x9edb, { 0xE9, 0x80, 0x88 },
	0x9edc, { 0xE5, 0x8B, 0x8C },
	0x9edd, { 0xE3, 0xB9, 0xB4 },
	0x9ede, { 0xE3, 0x99, 0xBA },
	0x9edf, { 0xE4, 0x97, 0xA9 },
	0x9ee0, { 0xEE, 0xB5, 0x9F },
	0x9ee1, { 0xE7, 0x99, 0x80 },
	0x9ee2, { 0xE5, 0xAB, 0xB0 },
	0x9ee3, { 0xEE, 0xB5, 0xA2 },
	0x9ee4, { 0xE7, 0xA1, 0xBA },
	0x9ee5, { 0xE4, 0x9E, 0xB6 },
	0x9ee6, { 0xE5, 0xA2, 0xA7 },
	0x9ee7, { 0xE4, 0x82, 0xBF },
	0x9ee8, { 0xE5, 0x99, 0xBC },
	0x9ee9, { 0xE9, 0xAE, 0x8B },
	0x9eea, { 0xE5, 0xB5, 0xB4 },
	0x9eeb, { 0xE7, 0x99, 0x94 },
	0x9eec, { 0xEE, 0xB5, 0xAB },
	0x9eed, { 0xE9, 0xBA, 0x85 },
	0x9eee, { 0xE4, 0xB3, 0xA1 },
	0x9ef0, { 0xE3, 0x9F, 0xBB },
	0x9ef1, { 0xE6, 0x84, 0x99 },
	0x9ef2, { 0xEE, 0xB5, 0xB1 },
	0x9ef3, { 0xEE, 0xB5, 0xB2 },
	0x9ef5, { 0xE5, 0x99, 0x9D },
	0x9ef6, { 0xEE, 0xB5, 0xB5 },
	0x9ef7, { 0xE5, 0x9E, 0xA7 },
	0x9ef8, { 0xEE, 0xB5, 0xB7 },
	0x9ef9, { 0xEE, 0xB5, 0xB8 },
	0x9efa, { 0xE5, 0x88, 0xB4 },
	0x9efb, { 0xEE, 0xB5, 0xBA },
	0x9efc, { 0xE3, 0x96, 0xAD },
	0x9efe, { 0xE9, 0xB5, 0xBC },
	0x9f40, { 0xE7, 0xB1, 0x96 },
	0x9f41, { 0xE9, 0xAC, 0xB9 },
	0x9f42, { 0xE5, 0x9F, 0x9E },
	0x9f43, { 0xEE, 0xB6, 0x81 },
	0x9f44, { 0xE5, 0xB1, 0x93 },
	0x9f45, { 0xE6, 0x93, 0x93 },
	0x9f46, { 0xEE, 0xB6, 0x84 },
	0x9f47, { 0xEE, 0xB6, 0x85 },
	0x9f48, { 0xEE, 0xB6, 0x86 },
	0x9f49, { 0xE8, 0x9A, 0xAD },
	0x9f4a, { 0xEE, 0xB6, 0x88 },
	0x9f4b, { 0xEE, 0xB6, 0x89 },
	0x9f4c, { 0xEE, 0xB6, 0x8A },
	0x9f4d, { 0xEE, 0xB6, 0x8B },
	0x9f4f, { 0xE5, 0x87, 0xBE },
	0x9f50, { 0xEE, 0xB6, 0x8E },
	0x9f51, { 0xE5, 0xB6, 0x8E },
	0x9f52, { 0xE9, 0x9C, 0x83 },
	0x9f53, { 0xEE, 0xB6, 0x91 },
	0x9f54, { 0xE9, 0xBA, 0x81 },
	0x9f55, { 0xE9, 0x81, 0x8C },
	0x9f56, { 0xE7, 0xAC, 0x9F },
	0x9f57, { 0xE9, 0xAC, 0x82 },
	0x9f58, { 0xE5, 0xB3, 0x91 },
	0x9f59, { 0xE7, 0xAE, 0xA3 },
	0x9f5a, { 0xE6, 0x89, 0xA8 },
	0x9f5b, { 0xE6, 0x8C, 0xB5 },
	0x9f5c, { 0xE9, 0xAB, 0xBF },
	0x9f5d, { 0xE7, 0xAF, 0x8F },
	0x9f5e, { 0xE9, 0xAC, 0xAA },
	0x9f5f, { 0xE7, 0xB1, 0xBE },
	0x9f61, { 0xE7, 0xB1, 0x82 },
	0x9f62, { 0xE7, 0xB2, 0x86 },
	0x9f63, { 0xE9, 0xB0, 0x95 },
	0x9f64, { 0xE7, 0xAF, 0xBC },
	0x9f65, { 0xE9, 0xAC, 0x89 },
	0x9f67, { 0xE9, 0xB0, 0x9B },
	0x9f68, { 0xEE, 0xB6, 0xA6 },
	0x9f69, { 0xE9, 0xBD, 0x9A },
	0x9f6a, { 0xE5, 0x95, 0xB3 },
	0x9f6b, { 0xE5, 0xAF, 0x83 },
	0x9f6c, { 0xE4, 0xBF, 0xBD },
	0x9f6d, { 0xE9, 0xBA, 0x98 },
	0x9f6e, { 0xE4, 0xBF, 0xB2 },
	0x9f6f, { 0xE5, 0x89, 0xA0 },
	0x9f70, { 0xE3, 0xB8, 0x86 },
	0x9f71, { 0xE5, 0x8B, 0x91 },
	0x9f72, { 0xE5, 0x9D, 0xA7 },
	0x9f73, { 0xE5, 0x81, 0x96 },
	0x9f74, { 0xE5, 0xA6, 0xB7 },
	0x9f75, { 0xE5, 0xB8, 0x92 },
	0x9f76, { 0xE9, 0x9F, 0x88 },
	0x9f77, { 0xE9, 0xB6, 0xAB },
	0x9f78, { 0xE8, 0xBD, 0x9C },
	0x9f79, { 0xE5, 0x91, 0xA9 },
	0x9f7a, { 0xE9, 0x9E, 0xB4 },
	0x9f7b, { 0xE9, 0xA5, 0x80 },
	0x9f7c, { 0xE9, 0x9E, 0xBA },
	0x9f7d, { 0xE5, 0x8C, 0xAC },
	0x9f7e, { 0xE6, 0x84, 0xB0 },
	0x9fa1, { 0xE6, 0xA4, 0xAC },
	0x9fa2, { 0xE5, 0x8F, 0x9A },
	0x9fa3, { 0xE9, 0xB0, 0x8A },
	0x9fa4, { 0xE9, 0xB4, 0x82 },
	0x9fa5, { 0xE4, 0xB0, 0xBB },
	0x9fa6, { 0xE9, 0x99, 0x81 },
	0x9fa7, { 0xE6, 0xA6, 0x80 },
	0x9fa8, { 0xE5, 0x82, 0xA6 },
	0x9fa9, { 0xE7, 0x95, 0x86 },
	0x9faa, { 0xEE, 0xB7, 0x86 },
	0x9fab, { 0xE9, 0xA7, 0x9A },
	0x9fac, { 0xE5, 0x89, 0xB3 },
	0x9fae, { 0xE9, 0x85, 0x99 },
	0x9faf, { 0xE9, 0x9A, 0x81 },
	0x9fb0, { 0xE9, 0x85, 0x9C },
	0x9fb2, { 0xE9, 0x85, 0x91 },
	0x9fb3, { 0xEE, 0xB7, 0x8F },
	0x9fb4, { 0xE6, 0x8D, 0xBF },
	0x9fb5, { 0xEE, 0xB7, 0x91 },
	0x9fb6, { 0xE6, 0xAB, 0x8A },
	0x9fb7, { 0xE5, 0x98, 0x91 },
	0x9fb8, { 0xE9, 0x86, 0x8E },
	0x9fb9, { 0xE7, 0x95, 0xBA },
	0x9fba, { 0xE6, 0x8A, 0x85 },
	0x9fbb, { 0xEE, 0xB7, 0x97 },
	0x9fbc, { 0xE7, 0x8D, 0x8F },
	0x9fbd, { 0xE7, 0xB1, 0xB0 },
	0x9fbe, { 0xEE, 0xB7, 0x9A },
	0x9fbf, { 0xEE, 0xB7, 0x9B },
	0x9fc1, { 0xEE, 0xB7, 0x9D },
	0x9fc2, { 0xE7, 0x9B, 0x96 },
	0x9fc3, { 0xE9, 0xAE, 0x9D },
	0x9fc4, { 0xE4, 0xB8, 0xAA },
	0x9fc5, { 0xEE, 0xB7, 0xA1 },
	0x9fc6, { 0xE8, 0x8E, 0xBE },
	0x9fc7, { 0xE8, 0xA1, 0x82 },
	0x9fc9, { 0xE5, 0xB1, 0x8A },
	0x9fca, { 0xE6, 0xA7, 0x80 },
	0x9fcc, { 0xE5, 0x9D, 0xBA },
	0x9fcd, { 0xE5, 0x88, 0x9F },
	0x9fce, { 0xE5, 0xB7, 0xB5 },
	0x9fcf, { 0xE4, 0xBB, 0x8E },
	0x9fd0, { 0xE6, 0xB0, 0xB1 },
	0x9fd1, { 0xEE, 0xB7, 0xAD },
	0x9fd2, { 0xE4, 0xBC, 0xB9 },
	0x9fd3, { 0xE5, 0x92, 0x9C },
	0x9fd4, { 0xE5, 0x93, 0x9A },
	0x9fd5, { 0xE5, 0x8A, 0x9A },
	0x9fd6, { 0xE8, 0xB6, 0x82 },
	0x9fd7, { 0xE3, 0x97, 0xBE },
	0x9fd9, { 0xE3, 0x97, 0xB3 },
	0x9fdb, { 0xE6, 0xAD, 0x92 },
	0x9fdc, { 0xE9, 0x85, 0xBC },
	0x9fdd, { 0xE9, 0xBE, 0xA5 },
	0x9fde, { 0xE9, 0xAE, 0x97 },
	0x9fdf, { 0xE9, 0xA0, 0xAE },
	0x9fe0, { 0xE9, 0xA2, 0xB4 },
	0x9fe1, { 0xE9, 0xAA, 0xBA },
	0x9fe2, { 0xE9, 0xBA, 0xA8 },
	0x9fe3, { 0xE9, 0xBA, 0x84 },
	0x9fe4, { 0xE7, 0x85, 0xBA },
	0x9fe5, { 0xE7, 0xAC, 0x94 },
	0x9fe7, { 0xE6, 0xAF, 0xBA },
	0x9fe8, { 0xE8, 0xA0, 0x98 },
	0x9fe9, { 0xE7, 0xBD, 0xB8 },
	0x9feb, { 0xE5, 0x98, 0xA0 },
	0x9fec, { 0xEE, 0xB8, 0x88 },
	0x9fed, { 0xE8, 0xB9, 0xB7 },
	0x9fee, { 0xE9, 0xBD, 0x93 },
	0x9ff0, { 0xE8, 0xB7, 0x94 },
	0x9ff1, { 0xE8, 0xB9, 0x8F },
	0x9ff2, { 0xE9, 0xB8, 0x9C },
	0x9ff3, { 0xE8, 0xB8, 0x81 },
	0x9ff4, { 0xE6, 0x8A, 0x82 },
	0x9ff5, { 0xEE, 0xB8, 0x91 },
	0x9ff6, { 0xE8, 0xB8, 0xA8 },
	0x9ff7, { 0xE8, 0xB9, 0xB5 },
	0x9ff8, { 0xE7, 0xAB, 0x93 },
	0x9ff9, { 0xEE, 0xB8, 0x95 },
	0x9ffa, { 0xE7, 0xA8, 0xBE },
	0x9ffb, { 0xE7, 0xA3, 0x98 },
	0x9ffc, { 0xE6, 0xB3, 0xAA },
	0x9ffd, { 0xE8, 0xA9, 0xA7 },
	0x9ffe, { 0xE7, 0x98, 0x87 },
	0xa040, { 0xEE, 0xB8, 0x9B },
	0xa041, { 0xE9, 0xBC, 0xA6 },
	0xa042, { 0xE6, 0xB3, 0x8E },
	0xa043, { 0xE8, 0x9F, 0x96 },
	0xa044, { 0xE7, 0x97, 0x83 },
	0xa045, { 0xEE, 0xB8, 0xA0 },
	0xa046, { 0xE7, 0xA1, 0x93 },
	0xa047, { 0xEE, 0xB8, 0xA2 },
	0xa048, { 0xE8, 0xB4, 0x8C },
	0xa049, { 0xE7, 0x8B, 0xA2 },
	0xa04a, { 0xE7, 0x8D, 0xB1 },
	0xa04b, { 0xE8, 0xAC, 0xAD },
	0xa04c, { 0xE7, 0x8C, 0x82 },
	0xa04d, { 0xE7, 0x93, 0xB1 },
	0xa04e, { 0xE8, 0xB3, 0xAB },
	0xa04f, { 0xEE, 0xB8, 0xAA },
	0xa050, { 0xE8, 0x98, 0xAF },
	0xa051, { 0xE5, 0xBE, 0xBA },
	0xa052, { 0xE8, 0xA2, 0xA0 },
	0xa053, { 0xE4, 0x92, 0xB7 },
	0xa055, { 0xEE, 0xB8, 0xB0 },
	0xa056, { 0xEE, 0xB8, 0xB1 },
	0xa058, { 0xE8, 0xA9, 0xBE },
	0xa059, { 0xEE, 0xB8, 0xB4 },
	0xa05b, { 0xE6, 0x83, 0xBD },
	0xa05c, { 0xE7, 0x99, 0xA7 },
	0xa05d, { 0xE9, 0xAB, 0x97 },
	0xa05e, { 0xE9, 0xB5, 0x84 },
	0xa05f, { 0xE9, 0x8D, 0xAE },
	0xa060, { 0xE9, 0xAE, 0x8F },
	0xa061, { 0xE8, 0x9F, 0xB5 },
	0xa064, { 0xE8, 0xB3, 0xB7 },
	0xa065, { 0xE7, 0x8C, 0xAC },
	0xa066, { 0xE9, 0x9C, 0xA1 },
	0xa067, { 0xE9, 0xAE, 0xB0 },
	0xa068, { 0xE3, 0x97, 0x96 },
	0xa069, { 0xE7, 0x8A, 0xB2 },
	0xa06a, { 0xE4, 0xB0, 0x87 },
	0xa06b, { 0xE7, 0xB1, 0x91 },
	0xa06c, { 0xE9, 0xA5, 0x8A },
	0xa06d, { 0xEE, 0xB9, 0x88 },
	0xa06e, { 0xE6, 0x85, 0x99 },
	0xa06f, { 0xE4, 0xB0, 0x84 },
	0xa070, { 0xE9, 0xBA, 0x96 },
	0xa071, { 0xE6, 0x85, 0xBD },
	0xa073, { 0xE5, 0x9D, 0x9F },
	0xa074, { 0xE6, 0x85, 0xAF },
	0xa075, { 0xE6, 0x8A, 0xA6 },
	0xa076, { 0xE6, 0x88, 0xB9 },
	0xa078, { 0xE3, 0xA9, 0x9C },
	0xa079, { 0xE6, 0x87, 0xA2 },
	0xa07a, { 0xE5, 0x8E, 0xAA },
	0xa07b, { 0xEE, 0xB9, 0x96 },
	0xa07c, { 0xE6, 0x8D, 0xA4 },
	0xa07d, { 0xE6, 0xA0, 0x82 },
	0xa07e, { 0xE3, 0x97, 0x92 },
	0xa0a1, { 0xE5, 0xB5, 0x97 },
	0xa0a2, { 0xEE, 0xB9, 0x9B },
	0xa0a3, { 0xE8, 0xBF, 0x9A },
	0xa0a4, { 0xEE, 0xB9, 0x9D },
	0xa0a6, { 0xE5, 0x83, 0x99 },
	0xa0a7, { 0xEE, 0xB9, 0xA0 },
	0xa0a8, { 0xE7, 0xA4, 0x86 },
	0xa0a9, { 0xE5, 0x8C, 0xB2 },
	0xa0aa, { 0xE9, 0x98, 0xB8 },
	0xa0ab, { 0xEE, 0xB9, 0xA4 },
	0xa0ac, { 0xE4, 0x81, 0xA5 },
	0xa0ae, { 0xE7, 0x9F, 0xBE },
	0xa0b0, { 0xE7, 0xB3, 0x82 },
	0xa0b1, { 0xEE, 0xB9, 0xAA },
	0xa0b2, { 0xE7, 0xB3, 0x9A },
	0xa0b3, { 0xE7, 0xA8, 0xAD },
	0xa0b4, { 0xE8, 0x81, 0xA6 },
	0xa0b5, { 0xE8, 0x81, 0xA3 },
	0xa0b6, { 0xE7, 0xB5, 0x8D },
	0xa0b7, { 0xE7, 0x94, 0x85 },
	0xa0b8, { 0xE7, 0x93, 0xB2 },
	0xa0b9, { 0xE8, 0xA6, 0x94 },
	0xa0ba, { 0xE8, 0x88, 0x9A },
	0xa0bb, { 0xE6, 0x9C, 0x8C },
	0xa0bc, { 0xE8, 0x81, 0xA2 },
	0xa0bd, { 0xEE, 0xB9, 0xB6 },
	0xa0be, { 0xE8, 0x81, 0x9B },
	0xa0bf, { 0xE7, 0x93, 0xB0 },
	0xa0c0, { 0xE8, 0x84, 0x83 },
	0xa0c1, { 0xE7, 0x9C, 0xA4 },
	0xa0c2, { 0xE8, 0xA6, 0x89 },
	0xa0c3, { 0xEE, 0xB9, 0xBC },
	0xa0c4, { 0xE7, 0x95, 0x93 },
	0xa0c5, { 0xEE, 0xB9, 0xBE },
	0xa0c6, { 0xE8, 0x9E, 0xA9 },
	0xa0c7, { 0xE8, 0x9F, 0x8E },
	0xa0c8, { 0xE8, 0x87, 0x88 },
	0xa0c9, { 0xE8, 0x9E, 0x8C },
	0xa0ca, { 0xE8, 0xA9, 0x89 },
	0xa0cb, { 0xE8, 0xB2, 0xAD },
	0xa0cc, { 0xE8, 0xAD, 0x83 },
	0xa0cd, { 0xE7, 0x9C, 0xAB },
	0xa0ce, { 0xE7, 0x93, 0xB8 },
	0xa0cf, { 0xE8, 0x93, 0x9A },
	0xa0d0, { 0xE3, 0x98, 0xB5 },
	0xa0d1, { 0xE6, 0xA6, 0xB2 },
	0xa0d2, { 0xE8, 0xB6, 0xA6 },
	0xa0d4, { 0xE8, 0xA6, 0xA9 },
	0xa0d6, { 0xE6, 0xB6, 0xB9 },
	0xa0d7, { 0xE8, 0x9F, 0x81 },
	0xa0d8, { 0xEE, 0xBA, 0x91 },
	0xa0d9, { 0xE7, 0x93, 0xA7 },
	0xa0da, { 0xE3, 0xB7, 0x9B },
	0xa0db, { 0xE7, 0x85, 0xB6 },
	0xa0dc, { 0xE6, 0x82, 0xA4 },
	0xa0dd, { 0xE6, 0x86, 0x9C },
	0xa0de, { 0xE3, 0xB3, 0x91 },
	0xa0e0, { 0xE6, 0x81, 0xB7 },
	0xa0e2, { 0xE7, 0xBD, 0xB1 },
	0xa0e3, { 0xEE, 0xBA, 0x9C },
	0xa0e5, { 0xE6, 0x83, 0xA9 },
	0xa0e6, { 0xE4, 0xAD, 0xBE },
	0xa0e7, { 0xE5, 0x88, 0xA0 },
	0xa0e8, { 0xEE, 0xBA, 0xA1 },
	0xa0e9, { 0xEE, 0xBA, 0xA2 },
	0xa0ea, { 0xEE, 0xBA, 0xA3 },
	0xa0eb, { 0xEE, 0xBA, 0xA4 },
	0xa0ec, { 0xEE, 0xBA, 0xA5 },
	0xa0ed, { 0xEE, 0xBA, 0xA6 },
	0xa0ee, { 0xEE, 0xBA, 0xA7 },
	0xa0ef, { 0xEE, 0xBA, 0xA8 },
	0xa0f0, { 0xEE, 0xBA, 0xA9 },
	0xa0f1, { 0xEE, 0xBA, 0xAA },
	0xa0f2, { 0xE5, 0xB3, 0x81 },
	0xa0f3, { 0xEE, 0xBA, 0xAC },
	0xa0f4, { 0xEE, 0xBA, 0xAD },
	0xa0f5, { 0xEE, 0xBA, 0xAE },
	0xa0f6, { 0xEE, 0xBA, 0xAF },
	0xa0f7, { 0xEE, 0xBA, 0xB0 },
	0xa0f8, { 0xEE, 0xBA, 0xB1 },
	0xa0f9, { 0xE4, 0x95, 0xA2 },
	0xa0fa, { 0xE5, 0xAC, 0x9F },
	0xa0fb, { 0xEE, 0xBA, 0xB4 },
	0xa0fc, { 0xE9, 0xBD, 0x90 },
	0xa0fd, { 0xE9, 0xBA, 0xA6 },
	0xa0fe, { 0xEE, 0xBA, 0xB7 },
	0xa140, { 0xE3, 0x80, 0x80 },
	0xa141, { 0xEF, 0xBC, 0x8C },
	0xa142, { 0xE3, 0x80, 0x81 },
	0xa143, { 0xE3, 0x80, 0x82 },
	0xa144, { 0xEF, 0xBC, 0x8E },
	0xa145, { 0xE2, 0x80, 0xA7 },
	0xa146, { 0xEF, 0xBC, 0x9B },
	0xa147, { 0xEF, 0xBC, 0x9A },
	0xa148, { 0xEF, 0xBC, 0x9F },
	0xa149, { 0xEF, 0xBC, 0x81 },
	0xa14a, { 0xEF, 0xB8, 0xB0 },
	0xa14b, { 0xE2, 0x80, 0xA6 },
	0xa14c, { 0xE2, 0x80, 0xA5 },
	0xa14d, { 0xEF, 0xB9, 0x90 },
	0xa14e, { 0xEF, 0xB9, 0x91 },
	0xa14f, { 0xEF, 0xB9, 0x92 },
	0xa150, { 0xC2, 0xB7 },
	0xa151, { 0xEF, 0xB9, 0x94 },
	0xa152, { 0xEF, 0xB9, 0x95 },
	0xa153, { 0xEF, 0xB9, 0x96 },
	0xa154, { 0xEF, 0xB9, 0x97 },
	0xa155, { 0xEF, 0xBD, 0x9C },
	0xa156, { 0xE2, 0x80, 0x93 },
	0xa157, { 0xEF, 0xB8, 0xB1 },
	0xa158, { 0xE2, 0x80, 0x94 },
	0xa159, { 0xEF, 0xB8, 0xB3 },
	0xa15a, { 0xE2, 0x95, 0xB4 },
	0xa15b, { 0xEF, 0xB8, 0xB4 },
	0xa15c, { 0xEF, 0xB9, 0x8F },
	0xa15d, { 0xEF, 0xBC, 0x88 },
	0xa15e, { 0xEF, 0xBC, 0x89 },
	0xa15f, { 0xEF, 0xB8, 0xB5 },
	0xa160, { 0xEF, 0xB8, 0xB6 },
	0xa161, { 0xEF, 0xBD, 0x9B },
	0xa162, { 0xEF, 0xBD, 0x9D },
	0xa163, { 0xEF, 0xB8, 0xB7 },
	0xa164, { 0xEF, 0xB8, 0xB8 },
	0xa165, { 0xE3, 0x80, 0x94 },
	0xa166, { 0xE3, 0x80, 0x95 },
	0xa167, { 0xEF, 0xB8, 0xB9 },
	0xa168, { 0xEF, 0xB8, 0xBA },
	0xa169, { 0xE3, 0x80, 0x90 },
	0xa16a, { 0xE3, 0x80, 0x91 },
	0xa16b, { 0xEF, 0xB8, 0xBB },
	0xa16c, { 0xEF, 0xB8, 0xBC },
	0xa16d, { 0xE3, 0x80, 0x8A },
	0xa16e, { 0xE3, 0x80, 0x8B },
	0xa16f, { 0xEF, 0xB8, 0xBD },
	0xa170, { 0xEF, 0xB8, 0xBE },
	0xa171, { 0xE3, 0x80, 0x88 },
	0xa172, { 0xE3, 0x80, 0x89 },
	0xa173, { 0xEF, 0xB8, 0xBF },
	0xa174, { 0xEF, 0xB9, 0x80 },
	0xa175, { 0xE3, 0x80, 0x8C },
	0xa176, { 0xE3, 0x80, 0x8D },
	0xa177, { 0xEF, 0xB9, 0x81 },
	0xa178, { 0xEF, 0xB9, 0x82 },
	0xa179, { 0xE3, 0x80, 0x8E },
	0xa17a, { 0xE3, 0x80, 0x8F },
	0xa17b, { 0xEF, 0xB9, 0x83 },
	0xa17c, { 0xEF, 0xB9, 0x84 },
	0xa17d, { 0xEF, 0xB9, 0x99 },
	0xa17e, { 0xEF, 0xB9, 0x9A },
	0xa1a1, { 0xEF, 0xB9, 0x9B },
	0xa1a2, { 0xEF, 0xB9, 0x9C },
	0xa1a3, { 0xEF, 0xB9, 0x9D },
	0xa1a4, { 0xEF, 0xB9, 0x9E },
	0xa1a5, { 0xE2, 0x80, 0x98 },
	0xa1a6, { 0xE2, 0x80, 0x99 },
	0xa1a7, { 0xE2, 0x80, 0x9C },
	0xa1a8, { 0xE2, 0x80, 0x9D },
	0xa1a9, { 0xE3, 0x80, 0x9D },
	0xa1aa, { 0xE3, 0x80, 0x9E },
	0xa1ab, { 0xE2, 0x80, 0xB5 },
	0xa1ac, { 0xE2, 0x80, 0xB2 },
	0xa1ad, { 0xEF, 0xBC, 0x83 },
	0xa1ae, { 0xEF, 0xBC, 0x86 },
	0xa1af, { 0xEF, 0xBC, 0x8A },
	0xa1b0, { 0xE2, 0x80, 0xBB },
	0xa1b1, { 0xC2, 0xA7 },
	0xa1b2, { 0xE3, 0x80, 0x83 },
	0xa1b3, { 0xE2, 0x97, 0x8B },
	0xa1b4, { 0xE2, 0x97, 0x8F },
	0xa1b5, { 0xE2, 0x96, 0xB3 },
	0xa1b6, { 0xE2, 0x96, 0xB2 },
	0xa1b7, { 0xE2, 0x97, 0x8E },
	0xa1b8, { 0xE2, 0x98, 0x86 },
	0xa1b9, { 0xE2, 0x98, 0x85 },
	0xa1ba, { 0xE2, 0x97, 0x87 },
	0xa1bb, { 0xE2, 0x97, 0x86 },
	0xa1bc, { 0xE2, 0x96, 0xA1 },
	0xa1bd, { 0xE2, 0x96, 0xA0 },
	0xa1be, { 0xE2, 0x96, 0xBD },
	0xa1bf, { 0xE2, 0x96, 0xBC },
	0xa1c0, { 0xE3, 0x8A, 0xA3 },
	0xa1c1, { 0xE2, 0x84, 0x85 },
	0xa1c2, { 0xC2, 0xAF },
	0xa1c3, { 0xEF, 0xBF, 0xA3 },
	0xa1c4, { 0xEF, 0xBC, 0xBF },
	0xa1c5, { 0xCB, 0x8D },
	0xa1c6, { 0xEF, 0xB9, 0x89 },
	0xa1c7, { 0xEF, 0xB9, 0x8A },
	0xa1c8, { 0xEF, 0xB9, 0x8D },
	0xa1c9, { 0xEF, 0xB9, 0x8E },
	0xa1ca, { 0xEF, 0xB9, 0x8B },
	0xa1cb, { 0xEF, 0xB9, 0x8C },
	0xa1cc, { 0xEF, 0xB9, 0x9F },
	0xa1cd, { 0xEF, 0xB9, 0xA0 },
	0xa1ce, { 0xEF, 0xB9, 0xA1 },
	0xa1cf, { 0xEF, 0xBC, 0x8B },
	0xa1d0, { 0xEF, 0xBC, 0x8D },
	0xa1d1, { 0xC3, 0x97 },
	0xa1d2, { 0xC3, 0xB7 },
	0xa1d3, { 0xC2, 0xB1 },
	0xa1d4, { 0xE2, 0x88, 0x9A },
	0xa1d5, { 0xEF, 0xBC, 0x9C },
	0xa1d6, { 0xEF, 0xBC, 0x9E },
	0xa1d7, { 0xEF, 0xBC, 0x9D },
	0xa1d8, { 0xE2, 0x89, 0xA6 },
	0xa1d9, { 0xE2, 0x89, 0xA7 },
	0xa1da, { 0xE2, 0x89, 0xA0 },
	0xa1db, { 0xE2, 0x88, 0x9E },
	0xa1dc, { 0xE2, 0x89, 0x92 },
	0xa1dd, { 0xE2, 0x89, 0xA1 },
	0xa1de, { 0xEF, 0xB9, 0xA2 },
	0xa1df, { 0xEF, 0xB9, 0xA3 },
	0xa1e0, { 0xEF, 0xB9, 0xA4 },
	0xa1e1, { 0xEF, 0xB9, 0xA5 },
	0xa1e2, { 0xEF, 0xB9, 0xA6 },
	0xa1e3, { 0xEF, 0xBD, 0x9E },
	0xa1e4, { 0xE2, 0x88, 0xA9 },
	0xa1e5, { 0xE2, 0x88, 0xAA },
	0xa1e6, { 0xE2, 0x8A, 0xA5 },
	0xa1e7, { 0xE2, 0x88, 0xA0 },
	0xa1e8, { 0xE2, 0x88, 0x9F },
	0xa1e9, { 0xE2, 0x8A, 0xBF },
	0xa1ea, { 0xE3, 0x8F, 0x92 },
	0xa1eb, { 0xE3, 0x8F, 0x91 },
	0xa1ec, { 0xE2, 0x88, 0xAB },
	0xa1ed, { 0xE2, 0x88, 0xAE },
	0xa1ee, { 0xE2, 0x88, 0xB5 },
	0xa1ef, { 0xE2, 0x88, 0xB4 },
	0xa1f0, { 0xE2, 0x99, 0x80 },
	0xa1f1, { 0xE2, 0x99, 0x82 },
	0xa1f2, { 0xE2, 0x8A, 0x95 },
	0xa1f3, { 0xE2, 0x8A, 0x99 },
	0xa1f4, { 0xE2, 0x86, 0x91 },
	0xa1f5, { 0xE2, 0x86, 0x93 },
	0xa1f6, { 0xE2, 0x86, 0x90 },
	0xa1f7, { 0xE2, 0x86, 0x92 },
	0xa1f8, { 0xE2, 0x86, 0x96 },
	0xa1f9, { 0xE2, 0x86, 0x97 },
	0xa1fa, { 0xE2, 0x86, 0x99 },
	0xa1fb, { 0xE2, 0x86, 0x98 },
	0xa1fc, { 0xE2, 0x88, 0xA5 },
	0xa1fd, { 0xE2, 0x88, 0xA3 },
	0xa1fe, { 0xEF, 0xBC, 0x8F },
	0xa240, { 0xEF, 0xBC, 0xBC },
	0xa241, { 0xE2, 0x88, 0x95 },
	0xa242, { 0xEF, 0xB9, 0xA8 },
	0xa243, { 0xEF, 0xBC, 0x84 },
	0xa244, { 0xEF, 0xBF, 0xA5 },
	0xa245, { 0xE3, 0x80, 0x92 },
	0xa246, { 0xEF, 0xBF, 0xA0 },
	0xa247, { 0xEF, 0xBF, 0xA1 },
	0xa248, { 0xEF, 0xBC, 0x85 },
	0xa249, { 0xEF, 0xBC, 0xA0 },
	0xa24a, { 0xE2, 0x84, 0x83 },
	0xa24b, { 0xE2, 0x84, 0x89 },
	0xa24c, { 0xEF, 0xB9, 0xA9 },
	0xa24d, { 0xEF, 0xB9, 0xAA },
	0xa24e, { 0xEF, 0xB9, 0xAB },
	0xa24f, { 0xE3, 0x8F, 0x95 },
	0xa250, { 0xE3, 0x8E, 0x9C },
	0xa251, { 0xE3, 0x8E, 0x9D },
	0xa252, { 0xE3, 0x8E, 0x9E },
	0xa253, { 0xE3, 0x8F, 0x8E },
	0xa254, { 0xE3, 0x8E, 0xA1 },
	0xa255, { 0xE3, 0x8E, 0x8E },
	0xa256, { 0xE3, 0x8E, 0x8F },
	0xa257, { 0xE3, 0x8F, 0x84 },
	0xa258, { 0xC2, 0xB0 },
	0xa259, { 0xE5, 0x85, 0x99 },
	0xa25a, { 0xE5, 0x85, 0x9B },
	0xa25b, { 0xE5, 0x85, 0x9E },
	0xa25c, { 0xE5, 0x85, 0x9D },
	0xa25d, { 0xE5, 0x85, 0xA1 },
	0xa25e, { 0xE5, 0x85, 0xA3 },
	0xa25f, { 0xE5, 0x97, 0xA7 },
	0xa260, { 0xE7, 0x93, 0xA9 },
	0xa261, { 0xE7, 0xB3, 0x8E },
	0xa262, { 0xE2, 0x96, 0x81 },
	0xa263, { 0xE2, 0x96, 0x82 },
	0xa264, { 0xE2, 0x96, 0x83 },
	0xa265, { 0xE2, 0x96, 0x84 },
	0xa266, { 0xE2, 0x96, 0x85 },
	0xa267, { 0xE2, 0x96, 0x86 },
	0xa268, { 0xE2, 0x96, 0x87 },
	0xa269, { 0xE2, 0x96, 0x88 },
	0xa26a, { 0xE2, 0x96, 0x8F },
	0xa26b, { 0xE2, 0x96, 0x8E },
	0xa26c, { 0xE2, 0x96, 0x8D },
	0xa26d, { 0xE2, 0x96, 0x8C },
	0xa26e, { 0xE2, 0x96, 0x8B },
	0xa26f, { 0xE2, 0x96, 0x8A },
	0xa270, { 0xE2, 0x96, 0x89 },
	0xa271, { 0xE2, 0x94, 0xBC },
	0xa272, { 0xE2, 0x94, 0xB4 },
	0xa273, { 0xE2, 0x94, 0xAC },
	0xa274, { 0xE2, 0x94, 0xA4 },
	0xa275, { 0xE2, 0x94, 0x9C },
	0xa276, { 0xE2, 0x96, 0x94 },
	0xa277, { 0xE2, 0x94, 0x80 },
	0xa278, { 0xE2, 0x94, 0x82 },
	0xa279, { 0xE2, 0x96, 0x95 },
	0xa27a, { 0xE2, 0x94, 0x8C },
	0xa27b, { 0xE2, 0x94, 0x90 },
	0xa27c, { 0xE2, 0x94, 0x94 },
	0xa27d, { 0xE2, 0x94, 0x98 },
	0xa27e, { 0xE2, 0x95, 0xAD },
	0xa2a1, { 0xE2, 0x95, 0xAE },
	0xa2a2, { 0xE2, 0x95, 0xB0 },
	0xa2a3, { 0xE2, 0x95, 0xAF },
	0xa2a4, { 0xE2, 0x95, 0x90 },
	0xa2a5, { 0xE2, 0x95, 0x9E },
	0xa2a6, { 0xE2, 0x95, 0xAA },
	0xa2a7, { 0xE2, 0x95, 0xA1 },
	0xa2a8, { 0xE2, 0x97, 0xA2 },
	0xa2a9, { 0xE2, 0x97, 0xA3 },
	0xa2aa, { 0xE2, 0x97, 0xA5 },
	0xa2ab, { 0xE2, 0x97, 0xA4 },
	0xa2ac, { 0xE2, 0x95, 0xB1 },
	0xa2ad, { 0xE2, 0x95, 0xB2 },
	0xa2ae, { 0xE2, 0x95, 0xB3 },
	0xa2af, { 0xEF, 0xBC, 0x90 },
	0xa2b0, { 0xEF, 0xBC, 0x91 },
	0xa2b1, { 0xEF, 0xBC, 0x92 },
	0xa2b2, { 0xEF, 0xBC, 0x93 },
	0xa2b3, { 0xEF, 0xBC, 0x94 },
	0xa2b4, { 0xEF, 0xBC, 0x95 },
	0xa2b5, { 0xEF, 0xBC, 0x96 },
	0xa2b6, { 0xEF, 0xBC, 0x97 },
	0xa2b7, { 0xEF, 0xBC, 0x98 },
	0xa2b8, { 0xEF, 0xBC, 0x99 },
	0xa2b9, { 0xE2, 0x85, 0xA0 },
	0xa2ba, { 0xE2, 0x85, 0xA1 },
	0xa2bb, { 0xE2, 0x85, 0xA2 },
	0xa2bc, { 0xE2, 0x85, 0xA3 },
	0xa2bd, { 0xE2, 0x85, 0xA4 },
	0xa2be, { 0xE2, 0x85, 0xA5 },
	0xa2bf, { 0xE2, 0x85, 0xA6 },
	0xa2c0, { 0xE2, 0x85, 0xA7 },
	0xa2c1, { 0xE2, 0x85, 0xA8 },
	0xa2c2, { 0xE2, 0x85, 0xA9 },
	0xa2c3, { 0xE3, 0x80, 0xA1 },
	0xa2c4, { 0xE3, 0x80, 0xA2 },
	0xa2c5, { 0xE3, 0x80, 0xA3 },
	0xa2c6, { 0xE3, 0x80, 0xA4 },
	0xa2c7, { 0xE3, 0x80, 0xA5 },
	0xa2c8, { 0xE3, 0x80, 0xA6 },
	0xa2c9, { 0xE3, 0x80, 0xA7 },
	0xa2ca, { 0xE3, 0x80, 0xA8 },
	0xa2cb, { 0xE3, 0x80, 0xA9 },
	0xa2cc, { 0xE5, 0x8D, 0x81 },
	0xa2cd, { 0xE5, 0x8D, 0x84 },
	0xa2ce, { 0xE5, 0x8D, 0x85 },
	0xa2cf, { 0xEF, 0xBC, 0xA1 },
	0xa2d0, { 0xEF, 0xBC, 0xA2 },
	0xa2d1, { 0xEF, 0xBC, 0xA3 },
	0xa2d2, { 0xEF, 0xBC, 0xA4 },
	0xa2d3, { 0xEF, 0xBC, 0xA5 },
	0xa2d4, { 0xEF, 0xBC, 0xA6 },
	0xa2d5, { 0xEF, 0xBC, 0xA7 },
	0xa2d6, { 0xEF, 0xBC, 0xA8 },
	0xa2d7, { 0xEF, 0xBC, 0xA9 },
	0xa2d8, { 0xEF, 0xBC, 0xAA },
	0xa2d9, { 0xEF, 0xBC, 0xAB },
	0xa2da, { 0xEF, 0xBC, 0xAC },
	0xa2db, { 0xEF, 0xBC, 0xAD },
	0xa2dc, { 0xEF, 0xBC, 0xAE },
	0xa2dd, { 0xEF, 0xBC, 0xAF },
	0xa2de, { 0xEF, 0xBC, 0xB0 },
	0xa2df, { 0xEF, 0xBC, 0xB1 },
	0xa2e0, { 0xEF, 0xBC, 0xB2 },
	0xa2e1, { 0xEF, 0xBC, 0xB3 },
	0xa2e2, { 0xEF, 0xBC, 0xB4 },
	0xa2e3, { 0xEF, 0xBC, 0xB5 },
	0xa2e4, { 0xEF, 0xBC, 0xB6 },
	0xa2e5, { 0xEF, 0xBC, 0xB7 },
	0xa2e6, { 0xEF, 0xBC, 0xB8 },
	0xa2e7, { 0xEF, 0xBC, 0xB9 },
	0xa2e8, { 0xEF, 0xBC, 0xBA },
	0xa2e9, { 0xEF, 0xBD, 0x81 },
	0xa2ea, { 0xEF, 0xBD, 0x82 },
	0xa2eb, { 0xEF, 0xBD, 0x83 },
	0xa2ec, { 0xEF, 0xBD, 0x84 },
	0xa2ed, { 0xEF, 0xBD, 0x85 },
	0xa2ee, { 0xEF, 0xBD, 0x86 },
	0xa2ef, { 0xEF, 0xBD, 0x87 },
	0xa2f0, { 0xEF, 0xBD, 0x88 },
	0xa2f1, { 0xEF, 0xBD, 0x89 },
	0xa2f2, { 0xEF, 0xBD, 0x8A },
	0xa2f3, { 0xEF, 0xBD, 0x8B },
	0xa2f4, { 0xEF, 0xBD, 0x8C },
	0xa2f5, { 0xEF, 0xBD, 0x8D },
	0xa2f6, { 0xEF, 0xBD, 0x8E },
	0xa2f7, { 0xEF, 0xBD, 0x8F },
	0xa2f8, { 0xEF, 0xBD, 0x90 },
	0xa2f9, { 0xEF, 0xBD, 0x91 },
	0xa2fa, { 0xEF, 0xBD, 0x92 },
	0xa2fb, { 0xEF, 0xBD, 0x93 },
	0xa2fc, { 0xEF, 0xBD, 0x94 },
	0xa2fd, { 0xEF, 0xBD, 0x95 },
	0xa2fe, { 0xEF, 0xBD, 0x96 },
	0xa340, { 0xEF, 0xBD, 0x97 },
	0xa341, { 0xEF, 0xBD, 0x98 },
	0xa342, { 0xEF, 0xBD, 0x99 },
	0xa343, { 0xEF, 0xBD, 0x9A },
	0xa344, { 0xCE, 0x91 },
	0xa345, { 0xCE, 0x92 },
	0xa346, { 0xCE, 0x93 },
	0xa347, { 0xCE, 0x94 },
	0xa348, { 0xCE, 0x95 },
	0xa349, { 0xCE, 0x96 },
	0xa34a, { 0xCE, 0x97 },
	0xa34b, { 0xCE, 0x98 },
	0xa34c, { 0xCE, 0x99 },
	0xa34d, { 0xCE, 0x9A },
	0xa34e, { 0xCE, 0x9B },
	0xa34f, { 0xCE, 0x9C },
	0xa350, { 0xCE, 0x9D },
	0xa351, { 0xCE, 0x9E },
	0xa352, { 0xCE, 0x9F },
	0xa353, { 0xCE, 0xA0 },
	0xa354, { 0xCE, 0xA1 },
	0xa355, { 0xCE, 0xA3 },
	0xa356, { 0xCE, 0xA4 },
	0xa357, { 0xCE, 0xA5 },
	0xa358, { 0xCE, 0xA6 },
	0xa359, { 0xCE, 0xA7 },
	0xa35a, { 0xCE, 0xA8 },
	0xa35b, { 0xCE, 0xA9 },
	0xa35c, { 0xCE, 0xB1 },
	0xa35d, { 0xCE, 0xB2 },
	0xa35e, { 0xCE, 0xB3 },
	0xa35f, { 0xCE, 0xB4 },
	0xa360, { 0xCE, 0xB5 },
	0xa361, { 0xCE, 0xB6 },
	0xa362, { 0xCE, 0xB7 },
	0xa363, { 0xCE, 0xB8 },
	0xa364, { 0xCE, 0xB9 },
	0xa365, { 0xCE, 0xBA },
	0xa366, { 0xCE, 0xBB },
	0xa367, { 0xCE, 0xBC },
	0xa368, { 0xCE, 0xBD },
	0xa369, { 0xCE, 0xBE },
	0xa36a, { 0xCE, 0xBF },
	0xa36b, { 0xCF, 0x80 },
	0xa36c, { 0xCF, 0x81 },
	0xa36d, { 0xCF, 0x83 },
	0xa36e, { 0xCF, 0x84 },
	0xa36f, { 0xCF, 0x85 },
	0xa370, { 0xCF, 0x86 },
	0xa371, { 0xCF, 0x87 },
	0xa372, { 0xCF, 0x88 },
	0xa373, { 0xCF, 0x89 },
	0xa374, { 0xE3, 0x84, 0x85 },
	0xa375, { 0xE3, 0x84, 0x86 },
	0xa376, { 0xE3, 0x84, 0x87 },
	0xa377, { 0xE3, 0x84, 0x88 },
	0xa378, { 0xE3, 0x84, 0x89 },
	0xa379, { 0xE3, 0x84, 0x8A },
	0xa37a, { 0xE3, 0x84, 0x8B },
	0xa37b, { 0xE3, 0x84, 0x8C },
	0xa37c, { 0xE3, 0x84, 0x8D },
	0xa37d, { 0xE3, 0x84, 0x8E },
	0xa37e, { 0xE3, 0x84, 0x8F },
	0xa3a1, { 0xE3, 0x84, 0x90 },
	0xa3a2, { 0xE3, 0x84, 0x91 },
	0xa3a3, { 0xE3, 0x84, 0x92 },
	0xa3a4, { 0xE3, 0x84, 0x93 },
	0xa3a5, { 0xE3, 0x84, 0x94 },
	0xa3a6, { 0xE3, 0x84, 0x95 },
	0xa3a7, { 0xE3, 0x84, 0x96 },
	0xa3a8, { 0xE3, 0x84, 0x97 },
	0xa3a9, { 0xE3, 0x84, 0x98 },
	0xa3aa, { 0xE3, 0x84, 0x99 },
	0xa3ab, { 0xE3, 0x84, 0x9A },
	0xa3ac, { 0xE3, 0x84, 0x9B },
	0xa3ad, { 0xE3, 0x84, 0x9C },
	0xa3ae, { 0xE3, 0x84, 0x9D },
	0xa3af, { 0xE3, 0x84, 0x9E },
	0xa3b0, { 0xE3, 0x84, 0x9F },
	0xa3b1, { 0xE3, 0x84, 0xA0 },
	0xa3b2, { 0xE3, 0x84, 0xA1 },
	0xa3b3, { 0xE3, 0x84, 0xA2 },
	0xa3b4, { 0xE3, 0x84, 0xA3 },
	0xa3b5, { 0xE3, 0x84, 0xA4 },
	0xa3b6, { 0xE3, 0x84, 0xA5 },
	0xa3b7, { 0xE3, 0x84, 0xA6 },
	0xa3b8, { 0xE3, 0x84, 0xA7 },
	0xa3b9, { 0xE3, 0x84, 0xA8 },
	0xa3ba, { 0xE3, 0x84, 0xA9 },
	0xa3bb, { 0xCB, 0x99 },
	0xa3bc, { 0xCB, 0x89 },
	0xa3bd, { 0xCB, 0x8A },
	0xa3be, { 0xCB, 0x87 },
	0xa3bf, { 0xCB, 0x8B },
	0xa3e1, { 0xE2, 0x82, 0xAC },
	0xa440, { 0xE4, 0xB8, 0x80 },
	0xa441, { 0xE4, 0xB9, 0x99 },
	0xa442, { 0xE4, 0xB8, 0x81 },
	0xa443, { 0xE4, 0xB8, 0x83 },
	0xa444, { 0xE4, 0xB9, 0x83 },
	0xa445, { 0xE4, 0xB9, 0x9D },
	0xa446, { 0xE4, 0xBA, 0x86 },
	0xa447, { 0xE4, 0xBA, 0x8C },
	0xa448, { 0xE4, 0xBA, 0xBA },
	0xa449, { 0xE5, 0x84, 0xBF },
	0xa44a, { 0xE5, 0x85, 0xA5 },
	0xa44b, { 0xE5, 0x85, 0xAB },
	0xa44c, { 0xE5, 0x87, 0xA0 },
	0xa44d, { 0xE5, 0x88, 0x80 },
	0xa44e, { 0xE5, 0x88, 0x81 },
	0xa44f, { 0xE5, 0x8A, 0x9B },
	0xa450, { 0xE5, 0x8C, 0x95 },
	0xa451, { 0xE5, 0x8D, 0x81 },
	0xa452, { 0xE5, 0x8D, 0x9C },
	0xa453, { 0xE5, 0x8F, 0x88 },
	0xa454, { 0xE4, 0xB8, 0x89 },
	0xa455, { 0xE4, 0xB8, 0x8B },
	0xa456, { 0xE4, 0xB8, 0x88 },
	0xa457, { 0xE4, 0xB8, 0x8A },
	0xa458, { 0xE4, 0xB8, 0xAB },
	0xa459, { 0xE4, 0xB8, 0xB8 },
	0xa45a, { 0xE5, 0x87, 0xA1 },
	0xa45b, { 0xE4, 0xB9, 0x85 },
	0xa45c, { 0xE4, 0xB9, 0x88 },
	0xa45d, { 0xE4, 0xB9, 0x9F },
	0xa45e, { 0xE4, 0xB9, 0x9E },
	0xa45f, { 0xE4, 0xBA, 0x8E },
	0xa460, { 0xE4, 0xBA, 0xA1 },
	0xa461, { 0xE5, 0x85, 0x80 },
	0xa462, { 0xE5, 0x88, 0x83 },
	0xa463, { 0xE5, 0x8B, 0xBA },
	0xa464, { 0xE5, 0x8D, 0x83 },
	0xa465, { 0xE5, 0x8F, 0x89 },
	0xa466, { 0xE5, 0x8F, 0xA3 },
	0xa467, { 0xE5, 0x9C, 0x9F },
	0xa468, { 0xE5, 0xA3, 0xAB },
	0xa469, { 0xE5, 0xA4, 0x95 },
	0xa46a, { 0xE5, 0xA4, 0xA7 },
	0xa46b, { 0xE5, 0xA5, 0xB3 },
	0xa46c, { 0xE5, 0xAD, 0x90 },
	0xa46d, { 0xE5, 0xAD, 0x91 },
	0xa46e, { 0xE5, 0xAD, 0x93 },
	0xa46f, { 0xE5, 0xAF, 0xB8 },
	0xa470, { 0xE5, 0xB0, 0x8F },
	0xa471, { 0xE5, 0xB0, 0xA2 },
	0xa472, { 0xE5, 0xB0, 0xB8 },
	0xa473, { 0xE5, 0xB1, 0xB1 },
	0xa474, { 0xE5, 0xB7, 0x9D },
	0xa475, { 0xE5, 0xB7, 0xA5 },
	0xa476, { 0xE5, 0xB7, 0xB1 },
	0xa477, { 0xE5, 0xB7, 0xB2 },
	0xa478, { 0xE5, 0xB7, 0xB3 },
	0xa479, { 0xE5, 0xB7, 0xBE },
	0xa47a, { 0xE5, 0xB9, 0xB2 },
	0xa47b, { 0xE5, 0xBB, 0xBE },
	0xa47c, { 0xE5, 0xBC, 0x8B },
	0xa47d, { 0xE5, 0xBC, 0x93 },
	0xa47e, { 0xE6, 0x89, 0x8D },
	0xa4a1, { 0xE4, 0xB8, 0x91 },
	0xa4a2, { 0xE4, 0xB8, 0x90 },
	0xa4a3, { 0xE4, 0xB8, 0x8D },
	0xa4a4, { 0xE4, 0xB8, 0xAD },
	0xa4a5, { 0xE4, 0xB8, 0xB0 },
	0xa4a6, { 0xE4, 0xB8, 0xB9 },
	0xa4a7, { 0xE4, 0xB9, 0x8B },
	0xa4a8, { 0xE5, 0xB0, 0xB9 },
	0xa4a9, { 0xE4, 0xBA, 0x88 },
	0xa4aa, { 0xE4, 0xBA, 0x91 },
	0xa4ab, { 0xE4, 0xBA, 0x95 },
	0xa4ac, { 0xE4, 0xBA, 0x92 },
	0xa4ad, { 0xE4, 0xBA, 0x94 },
	0xa4ae, { 0xE4, 0xBA, 0xA2 },
	0xa4af, { 0xE4, 0xBB, 0x81 },
	0xa4b0, { 0xE4, 0xBB, 0x80 },
	0xa4b1, { 0xE4, 0xBB, 0x83 },
	0xa4b2, { 0xE4, 0xBB, 0x86 },
	0xa4b3, { 0xE4, 0xBB, 0x87 },
	0xa4b4, { 0xE4, 0xBB, 0x8D },
	0xa4b5, { 0xE4, 0xBB, 0x8A },
	0xa4b6, { 0xE4, 0xBB, 0x8B },
	0xa4b7, { 0xE4, 0xBB, 0x84 },
	0xa4b8, { 0xE5, 0x85, 0x83 },
	0xa4b9, { 0xE5, 0x85, 0x81 },
	0xa4ba, { 0xE5, 0x85, 0xA7 },
	0xa4bb, { 0xE5, 0x85, 0xAD },
	0xa4bc, { 0xE5, 0x85, 0xAE },
	0xa4bd, { 0xE5, 0x85, 0xAC },
	0xa4be, { 0xE5, 0x86, 0x97 },
	0xa4bf, { 0xE5, 0x87, 0xB6 },
	0xa4c0, { 0xE5, 0x88, 0x86 },
	0xa4c1, { 0xE5, 0x88, 0x87 },
	0xa4c2, { 0xE5, 0x88, 0x88 },
	0xa4c3, { 0xE5, 0x8B, 0xBB },
	0xa4c4, { 0xE5, 0x8B, 0xBE },
	0xa4c5, { 0xE5, 0x8B, 0xBF },
	0xa4c6, { 0xE5, 0x8C, 0x96 },
	0xa4c7, { 0xE5, 0x8C, 0xB9 },
	0xa4c8, { 0xE5, 0x8D, 0x88 },
	0xa4c9, { 0xE5, 0x8D, 0x87 },
	0xa4ca, { 0xE5, 0x8D, 0x85 },
	0xa4cb, { 0xE5, 0x8D, 0x9E },
	0xa4cc, { 0xE5, 0x8E, 0x84 },
	0xa4cd, { 0xE5, 0x8F, 0x8B },
	0xa4ce, { 0xE5, 0x8F, 0x8A },
	0xa4cf, { 0xE5, 0x8F, 0x8D },
	0xa4d0, { 0xE5, 0xA3, 0xAC },
	0xa4d1, { 0xE5, 0xA4, 0xA9 },
	0xa4d2, { 0xE5, 0xA4, 0xAB },
	0xa4d3, { 0xE5, 0xA4, 0xAA },
	0xa4d4, { 0xE5, 0xA4, 0xAD },
	0xa4d5, { 0xE5, 0xAD, 0x94 },
	0xa4d6, { 0xE5, 0xB0, 0x91 },
	0xa4d7, { 0xE5, 0xB0, 0xA4 },
	0xa4d8, { 0xE5, 0xB0, 0xBA },
	0xa4d9, { 0xE5, 0xB1, 0xAF },
	0xa4da, { 0xE5, 0xB7, 0xB4 },
	0xa4db, { 0xE5, 0xB9, 0xBB },
	0xa4dc, { 0xE5, 0xBB, 0xBF },
	0xa4dd, { 0xE5, 0xBC, 0x94 },
	0xa4de, { 0xE5, 0xBC, 0x95 },
	0xa4df, { 0xE5, 0xBF, 0x83 },
	0xa4e0, { 0xE6, 0x88, 0x88 },
	0xa4e1, { 0xE6, 0x88, 0xB6 },
	0xa4e2, { 0xE6, 0x89, 0x8B },
	0xa4e3, { 0xE6, 0x89, 0x8E },
	0xa4e4, { 0xE6, 0x94, 0xAF },
	0xa4e5, { 0xE6, 0x96, 0x87 },
	0xa4e6, { 0xE6, 0x96, 0x97 },
	0xa4e7, { 0xE6, 0x96, 0xA4 },
	0xa4e8, { 0xE6, 0x96, 0xB9 },
	0xa4e9, { 0xE6, 0x97, 0xA5 },
	0xa4ea, { 0xE6, 0x9B, 0xB0 },
	0xa4eb, { 0xE6, 0x9C, 0x88 },
	0xa4ec, { 0xE6, 0x9C, 0xA8 },
	0xa4ed, { 0xE6, 0xAC, 0xA0 },
	0xa4ee, { 0xE6, 0xAD, 0xA2 },
	0xa4ef, { 0xE6, 0xAD, 0xB9 },
	0xa4f0, { 0xE6, 0xAF, 0x8B },
	0xa4f1, { 0xE6, 0xAF, 0x94 },
	0xa4f2, { 0xE6, 0xAF, 0x9B },
	0xa4f3, { 0xE6, 0xB0, 0x8F },
	0xa4f4, { 0xE6, 0xB0, 0xB4 },
	0xa4f5, { 0xE7, 0x81, 0xAB },
	0xa4f6, { 0xE7, 0x88, 0xAA },
	0xa4f7, { 0xE7, 0x88, 0xB6 },
	0xa4f8, { 0xE7, 0x88, 0xBB },
	0xa4f9, { 0xE7, 0x89, 0x87 },
	0xa4fa, { 0xE7, 0x89, 0x99 },
	0xa4fb, { 0xE7, 0x89, 0x9B },
	0xa4fc, { 0xE7, 0x8A, 0xAC },
	0xa4fd, { 0xE7, 0x8E, 0x8B },
	0xa4fe, { 0xE4, 0xB8, 0x99 },
	0xa540, { 0xE4, 0xB8, 0x96 },
	0xa541, { 0xE4, 0xB8, 0x95 },
	0xa542, { 0xE4, 0xB8, 0x94 },
	0xa543, { 0xE4, 0xB8, 0x98 },
	0xa544, { 0xE4, 0xB8, 0xBB },
	0xa545, { 0xE4, 0xB9, 0x8D },
	0xa546, { 0xE4, 0xB9, 0x8F },
	0xa547, { 0xE4, 0xB9, 0x8E },
	0xa548, { 0xE4, 0xBB, 0xA5 },
	0xa549, { 0xE4, 0xBB, 0x98 },
	0xa54a, { 0xE4, 0xBB, 0x94 },
	0xa54b, { 0xE4, 0xBB, 0x95 },
	0xa54c, { 0xE4, 0xBB, 0x96 },
	0xa54d, { 0xE4, 0xBB, 0x97 },
	0xa54e, { 0xE4, 0xBB, 0xA3 },
	0xa54f, { 0xE4, 0xBB, 0xA4 },
	0xa550, { 0xE4, 0xBB, 0x99 },
	0xa551, { 0xE4, 0xBB, 0x9E },
	0xa552, { 0xE5, 0x85, 0x85 },
	0xa553, { 0xE5, 0x85, 0x84 },
	0xa554, { 0xE5, 0x86, 0x89 },
	0xa555, { 0xE5, 0x86, 0x8A },
	0xa556, { 0xE5, 0x86, 0xAC },
	0xa557, { 0xE5, 0x87, 0xB9 },
	0xa558, { 0xE5, 0x87, 0xBA },
	0xa559, { 0xE5, 0x87, 0xB8 },
	0xa55a, { 0xE5, 0x88, 0x8A },
	0xa55b, { 0xE5, 0x8A, 0xA0 },
	0xa55c, { 0xE5, 0x8A, 0x9F },
	0xa55d, { 0xE5, 0x8C, 0x85 },
	0xa55e, { 0xE5, 0x8C, 0x86 },
	0xa55f, { 0xE5, 0x8C, 0x97 },
	0xa560, { 0xE5, 0x8C, 0x9D },
	0xa561, { 0xE4, 0xBB, 0x9F },
	0xa562, { 0xE5, 0x8D, 0x8A },
	0xa563, { 0xE5, 0x8D, 0x89 },
	0xa564, { 0xE5, 0x8D, 0xA1 },
	0xa565, { 0xE5, 0x8D, 0xA0 },
	0xa566, { 0xE5, 0x8D, 0xAF },
	0xa567, { 0xE5, 0x8D, 0xAE },
	0xa568, { 0xE5, 0x8E, 0xBB },
	0xa569, { 0xE5, 0x8F, 0xAF },
	0xa56a, { 0xE5, 0x8F, 0xA4 },
	0xa56b, { 0xE5, 0x8F, 0xB3 },
	0xa56c, { 0xE5, 0x8F, 0xAC },
	0xa56d, { 0xE5, 0x8F, 0xAE },
	0xa56e, { 0xE5, 0x8F, 0xA9 },
	0xa56f, { 0xE5, 0x8F, 0xA8 },
	0xa570, { 0xE5, 0x8F, 0xBC },
	0xa571, { 0xE5, 0x8F, 0xB8 },
	0xa572, { 0xE5, 0x8F, 0xB5 },
	0xa573, { 0xE5, 0x8F, 0xAB },
	0xa574, { 0xE5, 0x8F, 0xA6 },
	0xa575, { 0xE5, 0x8F, 0xAA },
	0xa576, { 0xE5, 0x8F, 0xB2 },
	0xa577, { 0xE5, 0x8F, 0xB1 },
	0xa578, { 0xE5, 0x8F, 0xB0 },
	0xa579, { 0xE5, 0x8F, 0xA5 },
	0xa57a, { 0xE5, 0x8F, 0xAD },
	0xa57b, { 0xE5, 0x8F, 0xBB },
	0xa57c, { 0xE5, 0x9B, 0x9B },
	0xa57d, { 0xE5, 0x9B, 0x9A },
	0xa57e, { 0xE5, 0xA4, 0x96 },
	0xa5a1, { 0xE5, 0xA4, 0xAE },
	0xa5a2, { 0xE5, 0xA4, 0xB1 },
	0xa5a3, { 0xE5, 0xA5, 0xB4 },
	0xa5a4, { 0xE5, 0xA5, 0xB6 },
	0xa5a5, { 0xE5, 0xAD, 0x95 },
	0xa5a6, { 0xE5, 0xAE, 0x83 },
	0xa5a7, { 0xE5, 0xB0, 0xBC },
	0xa5a8, { 0xE5, 0xB7, 0xA8 },
	0xa5a9, { 0xE5, 0xB7, 0xA7 },
	0xa5aa, { 0xE5, 0xB7, 0xA6 },
	0xa5ab, { 0xE5, 0xB8, 0x82 },
	0xa5ac, { 0xE5, 0xB8, 0x83 },
	0xa5ad, { 0xE5, 0xB9, 0xB3 },
	0xa5ae, { 0xE5, 0xB9, 0xBC },
	0xa5af, { 0xE5, 0xBC, 0x81 },
	0xa5b0, { 0xE5, 0xBC, 0x98 },
	0xa5b1, { 0xE5, 0xBC, 0x97 },
	0xa5b2, { 0xE5, 0xBF, 0x85 },
	0xa5b3, { 0xE6, 0x88, 0x8A },
	0xa5b4, { 0xE6, 0x89, 0x93 },
	0xa5b5, { 0xE6, 0x89, 0x94 },
	0xa5b6, { 0xE6, 0x89, 0x92 },
	0xa5b7, { 0xE6, 0x89, 0x91 },
	0xa5b8, { 0xE6, 0x96, 0xA5 },
	0xa5b9, { 0xE6, 0x97, 0xA6 },
	0xa5ba, { 0xE6, 0x9C, 0xAE },
	0xa5bb, { 0xE6, 0x9C, 0xAC },
	0xa5bc, { 0xE6, 0x9C, 0xAA },
	0xa5bd, { 0xE6, 0x9C, 0xAB },
	0xa5be, { 0xE6, 0x9C, 0xAD },
	0xa5bf, { 0xE6, 0xAD, 0xA3 },
	0xa5c0, { 0xE6, 0xAF, 0x8D },
	0xa5c1, { 0xE6, 0xB0, 0x91 },
	0xa5c2, { 0xE6, 0xB0, 0x90 },
	0xa5c3, { 0xE6, 0xB0, 0xB8 },
	0xa5c4, { 0xE6, 0xB1, 0x81 },
	0xa5c5, { 0xE6, 0xB1, 0x80 },
	0xa5c6, { 0xE6, 0xB0, 0xBE },
	0xa5c7, { 0xE7, 0x8A, 0xAF },
	0xa5c8, { 0xE7, 0x8E, 0x84 },
	0xa5c9, { 0xE7, 0x8E, 0x89 },
	0xa5ca, { 0xE7, 0x93, 0x9C },
	0xa5cb, { 0xE7, 0x93, 0xA6 },
	0xa5cc, { 0xE7, 0x94, 0x98 },
	0xa5cd, { 0xE7, 0x94, 0x9F },
	0xa5ce, { 0xE7, 0x94, 0xA8 },
	0xa5cf, { 0xE7, 0x94, 0xA9 },
	0xa5d0, { 0xE7, 0x94, 0xB0 },
	0xa5d1, { 0xE7, 0x94, 0xB1 },
	0xa5d2, { 0xE7, 0x94, 0xB2 },
	0xa5d3, { 0xE7, 0x94, 0xB3 },
	0xa5d4, { 0xE7, 0x96, 0x8B },
	0xa5d5, { 0xE7, 0x99, 0xBD },
	0xa5d6, { 0xE7, 0x9A, 0xAE },
	0xa5d7, { 0xE7, 0x9A, 0xBF },
	0xa5d8, { 0xE7, 0x9B, 0xAE },
	0xa5d9, { 0xE7, 0x9F, 0x9B },
	0xa5da, { 0xE7, 0x9F, 0xA2 },
	0xa5db, { 0xE7, 0x9F, 0xB3 },
	0xa5dc, { 0xE7, 0xA4, 0xBA },
	0xa5dd, { 0xE7, 0xA6, 0xBE },
	0xa5de, { 0xE7, 0xA9, 0xB4 },
	0xa5df, { 0xE7, 0xAB, 0x8B },
	0xa5e0, { 0xE4, 0xB8, 0x9E },
	0xa5e1, { 0xE4, 0xB8, 0x9F },
	0xa5e2, { 0xE4, 0xB9, 0x92 },
	0xa5e3, { 0xE4, 0xB9, 0x93 },
	0xa5e4, { 0xE4, 0xB9, 0xA9 },
	0xa5e5, { 0xE4, 0xBA, 0x99 },
	0xa5e6, { 0xE4, 0xBA, 0xA4 },
	0xa5e7, { 0xE4, 0xBA, 0xA6 },
	0xa5e8, { 0xE4, 0xBA, 0xA5 },
	0xa5e9, { 0xE4, 0xBB, 0xBF },
	0xa5ea, { 0xE4, 0xBC, 0x89 },
	0xa5eb, { 0xE4, 0xBC, 0x99 },
	0xa5ec, { 0xE4, 0xBC, 0x8A },
	0xa5ed, { 0xE4, 0xBC, 0x95 },
	0xa5ee, { 0xE4, 0xBC, 0x8D },
	0xa5ef, { 0xE4, 0xBC, 0x90 },
	0xa5f0, { 0xE4, 0xBC, 0x91 },
	0xa5f1, { 0xE4, 0xBC, 0x8F },
	0xa5f2, { 0xE4, 0xBB, 0xB2 },
	0xa5f3, { 0xE4, 0xBB, 0xB6 },
	0xa5f4, { 0xE4, 0xBB, 0xBB },
	0xa5f5, { 0xE4, 0xBB, 0xB0 },
	0xa5f6, { 0xE4, 0xBB, 0xB3 },
	0xa5f7, { 0xE4, 0xBB, 0xBD },
	0xa5f8, { 0xE4, 0xBC, 0x81 },
	0xa5f9, { 0xE4, 0xBC, 0x8B },
	0xa5fa, { 0xE5, 0x85, 0x89 },
	0xa5fb, { 0xE5, 0x85, 0x87 },
	0xa5fc, { 0xE5, 0x85, 0x86 },
	0xa5fd, { 0xE5, 0x85, 0x88 },
	0xa5fe, { 0xE5, 0x85, 0xA8 },
	0xa640, { 0xE5, 0x85, 0xB1 },
	0xa641, { 0xE5, 0x86, 0x8D },
	0xa642, { 0xE5, 0x86, 0xB0 },
	0xa643, { 0xE5, 0x88, 0x97 },
	0xa644, { 0xE5, 0x88, 0x91 },
	0xa645, { 0xE5, 0x88, 0x92 },
	0xa646, { 0xE5, 0x88, 0x8E },
	0xa647, { 0xE5, 0x88, 0x96 },
	0xa648, { 0xE5, 0x8A, 0xA3 },
	0xa649, { 0xE5, 0x8C, 0x88 },
	0xa64a, { 0xE5, 0x8C, 0xA1 },
	0xa64b, { 0xE5, 0x8C, 0xA0 },
	0xa64c, { 0xE5, 0x8D, 0xB0 },
	0xa64d, { 0xE5, 0x8D, 0xB1 },
	0xa64e, { 0xE5, 0x90, 0x89 },
	0xa64f, { 0xE5, 0x90, 0x8F },
	0xa650, { 0xE5, 0x90, 0x8C },
	0xa651, { 0xE5, 0x90, 0x8A },
	0xa652, { 0xE5, 0x90, 0x90 },
	0xa653, { 0xE5, 0x90, 0x81 },
	0xa654, { 0xE5, 0x90, 0x8B },
	0xa655, { 0xE5, 0x90, 0x84 },
	0xa656, { 0xE5, 0x90, 0x91 },
	0xa657, { 0xE5, 0x90, 0x8D },
	0xa658, { 0xE5, 0x90, 0x88 },
	0xa659, { 0xE5, 0x90, 0x83 },
	0xa65a, { 0xE5, 0x90, 0x8E },
	0xa65b, { 0xE5, 0x90, 0x86 },
	0xa65c, { 0xE5, 0x90, 0x92 },
	0xa65d, { 0xE5, 0x9B, 0xA0 },
	0xa65e, { 0xE5, 0x9B, 0x9E },
	0xa65f, { 0xE5, 0x9B, 0x9D },
	0xa660, { 0xE5, 0x9C, 0xB3 },
	0xa661, { 0xE5, 0x9C, 0xB0 },
	0xa662, { 0xE5, 0x9C, 0xA8 },
	0xa663, { 0xE5, 0x9C, 0xAD },
	0xa664, { 0xE5, 0x9C, 0xAC },
	0xa665, { 0xE5, 0x9C, 0xAF },
	0xa666, { 0xE5, 0x9C, 0xA9 },
	0xa667, { 0xE5, 0xA4, 0x99 },
	0xa668, { 0xE5, 0xA4, 0x9A },
	0xa669, { 0xE5, 0xA4, 0xB7 },
	0xa66a, { 0xE5, 0xA4, 0xB8 },
	0xa66b, { 0xE5, 0xA6, 0x84 },
	0xa66c, { 0xE5, 0xA5, 0xB8 },
	0xa66d, { 0xE5, 0xA6, 0x83 },
	0xa66e, { 0xE5, 0xA5, 0xBD },
	0xa66f, { 0xE5, 0xA5, 0xB9 },
	0xa670, { 0xE5, 0xA6, 0x82 },
	0xa671, { 0xE5, 0xA6, 0x81 },
	0xa672, { 0xE5, 0xAD, 0x97 },
	0xa673, { 0xE5, 0xAD, 0x98 },
	0xa674, { 0xE5, 0xAE, 0x87 },
	0xa675, { 0xE5, 0xAE, 0x88 },
	0xa676, { 0xE5, 0xAE, 0x85 },
	0xa677, { 0xE5, 0xAE, 0x89 },
	0xa678, { 0xE5, 0xAF, 0xBA },
	0xa679, { 0xE5, 0xB0, 0x96 },
	0xa67a, { 0xE5, 0xB1, 0xB9 },
	0xa67b, { 0xE5, 0xB7, 0x9E },
	0xa67c, { 0xE5, 0xB8, 0x86 },
	0xa67d, { 0xE5, 0xB9, 0xB6 },
	0xa67e, { 0xE5, 0xB9, 0xB4 },
	0xa6a1, { 0xE5, 0xBC, 0x8F },
	0xa6a2, { 0xE5, 0xBC, 0x9B },
	0xa6a3, { 0xE5, 0xBF, 0x99 },
	0xa6a4, { 0xE5, 0xBF, 0x96 },
	0xa6a5, { 0xE6, 0x88, 0x8E },
	0xa6a6, { 0xE6, 0x88, 0x8C },
	0xa6a7, { 0xE6, 0x88, 0x8D },
	0xa6a8, { 0xE6, 0x88, 0x90 },
	0xa6a9, { 0xE6, 0x89, 0xA3 },
	0xa6aa, { 0xE6, 0x89, 0x9B },
	0xa6ab, { 0xE6, 0x89, 0x98 },
	0xa6ac, { 0xE6, 0x94, 0xB6 },
	0xa6ad, { 0xE6, 0x97, 0xA9 },
	0xa6ae, { 0xE6, 0x97, 0xA8 },
	0xa6af, { 0xE6, 0x97, 0xAC },
	0xa6b0, { 0xE6, 0x97, 0xAD },
	0xa6b1, { 0xE6, 0x9B, 0xB2 },
	0xa6b2, { 0xE6, 0x9B, 0xB3 },
	0xa6b3, { 0xE6, 0x9C, 0x89 },
	0xa6b4, { 0xE6, 0x9C, 0xBD },
	0xa6b5, { 0xE6, 0x9C, 0xB4 },
	0xa6b6, { 0xE6, 0x9C, 0xB1 },
	0xa6b7, { 0xE6, 0x9C, 0xB5 },
	0xa6b8, { 0xE6, 0xAC, 0xA1 },
	0xa6b9, { 0xE6, 0xAD, 0xA4 },
	0xa6ba, { 0xE6, 0xAD, 0xBB },
	0xa6bb, { 0xE6, 0xB0, 0x96 },
	0xa6bc, { 0xE6, 0xB1, 0x9D },
	0xa6bd, { 0xE6, 0xB1, 0x97 },
	0xa6be, { 0xE6, 0xB1, 0x99 },
	0xa6bf, { 0xE6, 0xB1, 0x9F },
	0xa6c0, { 0xE6, 0xB1, 0xA0 },
	0xa6c1, { 0xE6, 0xB1, 0x90 },
	0xa6c2, { 0xE6, 0xB1, 0x95 },
	0xa6c3, { 0xE6, 0xB1, 0xA1 },
	0xa6c4, { 0xE6, 0xB1, 0x9B },
	0xa6c5, { 0xE6, 0xB1, 0x8D },
	0xa6c6, { 0xE6, 0xB1, 0x8E },
	0xa6c7, { 0xE7, 0x81, 0xB0 },
	0xa6c8, { 0xE7, 0x89, 0x9F },
	0xa6c9, { 0xE7, 0x89, 0x9D },
	0xa6ca, { 0xE7, 0x99, 0xBE },
	0xa6cb, { 0xE7, 0xAB, 0xB9 },
	0xa6cc, { 0xE7, 0xB1, 0xB3 },
	0xa6cd, { 0xE7, 0xB3, 0xB8 },
	0xa6ce, { 0xE7, 0xBC, 0xB6 },
	0xa6cf, { 0xE7, 0xBE, 0x8A },
	0xa6d0, { 0xE7, 0xBE, 0xBD },
	0xa6d1, { 0xE8, 0x80, 0x81 },
	0xa6d2, { 0xE8, 0x80, 0x83 },
	0xa6d3, { 0xE8, 0x80, 0x8C },
	0xa6d4, { 0xE8, 0x80, 0x92 },
	0xa6d5, { 0xE8, 0x80, 0xB3 },
	0xa6d6, { 0xE8, 0x81, 0xBF },
	0xa6d7, { 0xE8, 0x82, 0x89 },
	0xa6d8, { 0xE8, 0x82, 0x8B },
	0xa6d9, { 0xE8, 0x82, 0x8C },
	0xa6da, { 0xE8, 0x87, 0xA3 },
	0xa6db, { 0xE8, 0x87, 0xAA },
	0xa6dc, { 0xE8, 0x87, 0xB3 },
	0xa6dd, { 0xE8, 0x87, 0xBC },
	0xa6de, { 0xE8, 0x88, 0x8C },
	0xa6df, { 0xE8, 0x88, 0x9B },
	0xa6e0, { 0xE8, 0x88, 0x9F },
	0xa6e1, { 0xE8, 0x89, 0xAE },
	0xa6e2, { 0xE8, 0x89, 0xB2 },
	0xa6e3, { 0xE8, 0x89, 0xBE },
	0xa6e4, { 0xE8, 0x99, 0xAB },
	0xa6e5, { 0xE8, 0xA1, 0x80 },
	0xa6e6, { 0xE8, 0xA1, 0x8C },
	0xa6e7, { 0xE8, 0xA1, 0xA3 },
	0xa6e8, { 0xE8, 0xA5, 0xBF },
	0xa6e9, { 0xE9, 0x98, 0xA1 },
	0xa6ea, { 0xE4, 0xB8, 0xB2 },
	0xa6eb, { 0xE4, 0xBA, 0xA8 },
	0xa6ec, { 0xE4, 0xBD, 0x8D },
	0xa6ed, { 0xE4, 0xBD, 0x8F },
	0xa6ee, { 0xE4, 0xBD, 0x87 },
	0xa6ef, { 0xE4, 0xBD, 0x97 },
	0xa6f0, { 0xE4, 0xBD, 0x9E },
	0xa6f1, { 0xE4, 0xBC, 0xB4 },
	0xa6f2, { 0xE4, 0xBD, 0x9B },
	0xa6f3, { 0xE4, 0xBD, 0x95 },
	0xa6f4, { 0xE4, 0xBC, 0xB0 },
	0xa6f5, { 0xE4, 0xBD, 0x90 },
	0xa6f6, { 0xE4, 0xBD, 0x91 },
	0xa6f7, { 0xE4, 0xBC, 0xBD },
	0xa6f8, { 0xE4, 0xBC, 0xBA },
	0xa6f9, { 0xE4, 0xBC, 0xB8 },
	0xa6fa, { 0xE4, 0xBD, 0x83 },
	0xa6fb, { 0xE4, 0xBD, 0x94 },
	0xa6fc, { 0xE4, 0xBC, 0xBC },
	0xa6fd, { 0xE4, 0xBD, 0x86 },
	0xa6fe, { 0xE4, 0xBD, 0xA3 },
	0xa740, { 0xE4, 0xBD, 0x9C },
	0xa741, { 0xE4, 0xBD, 0xA0 },
	0xa742, { 0xE4, 0xBC, 0xAF },
	0xa743, { 0xE4, 0xBD, 0x8E },
	0xa744, { 0xE4, 0xBC, 0xB6 },
	0xa745, { 0xE4, 0xBD, 0x99 },
	0xa746, { 0xE4, 0xBD, 0x9D },
	0xa747, { 0xE4, 0xBD, 0x88 },
	0xa748, { 0xE4, 0xBD, 0x9A },
	0xa749, { 0xE5, 0x85, 0x8C },
	0xa74a, { 0xE5, 0x85, 0x8B },
	0xa74b, { 0xE5, 0x85, 0x8D },
	0xa74c, { 0xE5, 0x85, 0xB5 },
	0xa74d, { 0xE5, 0x86, 0xB6 },
	0xa74e, { 0xE5, 0x86, 0xB7 },
	0xa74f, { 0xE5, 0x88, 0xA5 },
	0xa750, { 0xE5, 0x88, 0xA4 },
	0xa751, { 0xE5, 0x88, 0xA9 },
	0xa752, { 0xE5, 0x88, 0xAA },
	0xa753, { 0xE5, 0x88, 0xA8 },
	0xa754, { 0xE5, 0x8A, 0xAB },
	0xa755, { 0xE5, 0x8A, 0xA9 },
	0xa756, { 0xE5, 0x8A, 0xAA },
	0xa757, { 0xE5, 0x8A, 0xAC },
	0xa758, { 0xE5, 0x8C, 0xA3 },
	0xa759, { 0xE5, 0x8D, 0xB3 },
	0xa75a, { 0xE5, 0x8D, 0xB5 },
	0xa75b, { 0xE5, 0x90, 0x9D },
	0xa75c, { 0xE5, 0x90, 0xAD },
	0xa75d, { 0xE5, 0x90, 0x9E },
	0xa75e, { 0xE5, 0x90, 0xBE },
	0xa75f, { 0xE5, 0x90, 0xA6 },
	0xa760, { 0xE5, 0x91, 0x8E },
	0xa761, { 0xE5, 0x90, 0xA7 },
	0xa762, { 0xE5, 0x91, 0x86 },
	0xa763, { 0xE5, 0x91, 0x83 },
	0xa764, { 0xE5, 0x90, 0xB3 },
	0xa765, { 0xE5, 0x91, 0x88 },
	0xa766, { 0xE5, 0x91, 0x82 },
	0xa767, { 0xE5, 0x90, 0x9B },
	0xa768, { 0xE5, 0x90, 0xA9 },
	0xa769, { 0xE5, 0x91, 0x8A },
	0xa76a, { 0xE5, 0x90, 0xB9 },
	0xa76b, { 0xE5, 0x90, 0xBB },
	0xa76c, { 0xE5, 0x90, 0xB8 },
	0xa76d, { 0xE5, 0x90, 0xAE },
	0xa76e, { 0xE5, 0x90, 0xB5 },
	0xa76f, { 0xE5, 0x90, 0xB6 },
	0xa770, { 0xE5, 0x90, 0xA0 },
	0xa771, { 0xE5, 0x90, 0xBC },
	0xa772, { 0xE5, 0x91, 0x80 },
	0xa773, { 0xE5, 0x90, 0xB1 },
	0xa774, { 0xE5, 0x90, 0xAB },
	0xa775, { 0xE5, 0x90, 0x9F },
	0xa776, { 0xE5, 0x90, 0xAC },
	0xa777, { 0xE5, 0x9B, 0xAA },
	0xa778, { 0xE5, 0x9B, 0xB0 },
	0xa779, { 0xE5, 0x9B, 0xA4 },
	0xa77a, { 0xE5, 0x9B, 0xAB },
	0xa77b, { 0xE5, 0x9D, 0x8A },
	0xa77c, { 0xE5, 0x9D, 0x91 },
	0xa77d, { 0xE5, 0x9D, 0x80 },
	0xa77e, { 0xE5, 0x9D, 0x8D },
	0xa7a1, { 0xE5, 0x9D, 0x87 },
	0xa7a2, { 0xE5, 0x9D, 0x8E },
	0xa7a3, { 0xE5, 0x9C, 0xBE },
	0xa7a4, { 0xE5, 0x9D, 0x90 },
	0xa7a5, { 0xE5, 0x9D, 0x8F },
	0xa7a6, { 0xE5, 0x9C, 0xBB },
	0xa7a7, { 0xE5, 0xA3, 0xAF },
	0xa7a8, { 0xE5, 0xA4, 0xBE },
	0xa7a9, { 0xE5, 0xA6, 0x9D },
	0xa7aa, { 0xE5, 0xA6, 0x92 },
	0xa7ab, { 0xE5, 0xA6, 0xA8 },
	0xa7ac, { 0xE5, 0xA6, 0x9E },
	0xa7ad, { 0xE5, 0xA6, 0xA3 },
	0xa7ae, { 0xE5, 0xA6, 0x99 },
	0xa7af, { 0xE5, 0xA6, 0x96 },
	0xa7b0, { 0xE5, 0xA6, 0x8D },
	0xa7b1, { 0xE5, 0xA6, 0xA4 },
	0xa7b2, { 0xE5, 0xA6, 0x93 },
	0xa7b3, { 0xE5, 0xA6, 0x8A },
	0xa7b4, { 0xE5, 0xA6, 0xA5 },
	0xa7b5, { 0xE5, 0xAD, 0x9D },
	0xa7b6, { 0xE5, 0xAD, 0x9C },
	0xa7b7, { 0xE5, 0xAD, 0x9A },
	0xa7b8, { 0xE5, 0xAD, 0x9B },
	0xa7b9, { 0xE5, 0xAE, 0x8C },
	0xa7ba, { 0xE5, 0xAE, 0x8B },
	0xa7bb, { 0xE5, 0xAE, 0x8F },
	0xa7bc, { 0xE5, 0xB0, 0xAC },
	0xa7bd, { 0xE5, 0xB1, 0x80 },
	0xa7be, { 0xE5, 0xB1, 0x81 },
	0xa7bf, { 0xE5, 0xB0, 0xBF },
	0xa7c0, { 0xE5, 0xB0, 0xBE },
	0xa7c1, { 0xE5, 0xB2, 0x90 },
	0xa7c2, { 0xE5, 0xB2, 0x91 },
	0xa7c3, { 0xE5, 0xB2, 0x94 },
	0xa7c4, { 0xE5, 0xB2, 0x8C },
	0xa7c5, { 0xE5, 0xB7, 0xAB },
	0xa7c6, { 0xE5, 0xB8, 0x8C },
	0xa7c7, { 0xE5, 0xBA, 0x8F },
	0xa7c8, { 0xE5, 0xBA, 0x87 },
	0xa7c9, { 0xE5, 0xBA, 0x8A },
	0xa7ca, { 0xE5, 0xBB, 0xB7 },
	0xa7cb, { 0xE5, 0xBC, 0x84 },
	0xa7cc, { 0xE5, 0xBC, 0x9F },
	0xa7cd, { 0xE5, 0xBD, 0xA4 },
	0xa7ce, { 0xE5, 0xBD, 0xA2 },
	0xa7cf, { 0xE5, 0xBD, 0xB7 },
	0xa7d0, { 0xE5, 0xBD, 0xB9 },
	0xa7d1, { 0xE5, 0xBF, 0x98 },
	0xa7d2, { 0xE5, 0xBF, 0x8C },
	0xa7d3, { 0xE5, 0xBF, 0x97 },
	0xa7d4, { 0xE5, 0xBF, 0x8D },
	0xa7d5, { 0xE5, 0xBF, 0xB1 },
	0xa7d6, { 0xE5, 0xBF, 0xAB },
	0xa7d7, { 0xE5, 0xBF, 0xB8 },
	0xa7d8, { 0xE5, 0xBF, 0xAA },
	0xa7d9, { 0xE6, 0x88, 0x92 },
	0xa7da, { 0xE6, 0x88, 0x91 },
	0xa7db, { 0xE6, 0x8A, 0x84 },
	0xa7dc, { 0xE6, 0x8A, 0x97 },
	0xa7dd, { 0xE6, 0x8A, 0x96 },
	0xa7de, { 0xE6, 0x8A, 0x80 },
	0xa7df, { 0xE6, 0x89, 0xB6 },
	0xa7e0, { 0xE6, 0x8A, 0x89 },
	0xa7e1, { 0xE6, 0x89, 0xAD },
	0xa7e2, { 0xE6, 0x8A, 0x8A },
	0xa7e3, { 0xE6, 0x89, 0xBC },
	0xa7e4, { 0xE6, 0x89, 0xBE },
	0xa7e5, { 0xE6, 0x89, 0xB9 },
	0xa7e6, { 0xE6, 0x89, 0xB3 },
	0xa7e7, { 0xE6, 0x8A, 0x92 },
	0xa7e8, { 0xE6, 0x89, 0xAF },
	0xa7e9, { 0xE6, 0x8A, 0x98 },
	0xa7ea, { 0xE6, 0x89, 0xAE },
	0xa7eb, { 0xE6, 0x8A, 0x95 },
	0xa7ec, { 0xE6, 0x8A, 0x93 },
	0xa7ed, { 0xE6, 0x8A, 0x91 },
	0xa7ee, { 0xE6, 0x8A, 0x86 },
	0xa7ef, { 0xE6, 0x94, 0xB9 },
	0xa7f0, { 0xE6, 0x94, 0xBB },
	0xa7f1, { 0xE6, 0x94, 0xB8 },
	0xa7f2, { 0xE6, 0x97, 0xB1 },
	0xa7f3, { 0xE6, 0x9B, 0xB4 },
	0xa7f4, { 0xE6, 0x9D, 0x9F },
	0xa7f5, { 0xE6, 0x9D, 0x8E },
	0xa7f6, { 0xE6, 0x9D, 0x8F },
	0xa7f7, { 0xE6, 0x9D, 0x90 },
	0xa7f8, { 0xE6, 0x9D, 0x91 },
	0xa7f9, { 0xE6, 0x9D, 0x9C },
	0xa7fa, { 0xE6, 0x9D, 0x96 },
	0xa7fb, { 0xE6, 0x9D, 0x9E },
	0xa7fc, { 0xE6, 0x9D, 0x89 },
	0xa7fd, { 0xE6, 0x9D, 0x86 },
	0xa7fe, { 0xE6, 0x9D, 0xA0 },
	0xa840, { 0xE6, 0x9D, 0x93 },
	0xa841, { 0xE6, 0x9D, 0x97 },
	0xa842, { 0xE6, 0xAD, 0xA5 },
	0xa843, { 0xE6, 0xAF, 0x8F },
	0xa844, { 0xE6, 0xB1, 0x82 },
	0xa845, { 0xE6, 0xB1, 0x9E },
	0xa846, { 0xE6, 0xB2, 0x99 },
	0xa847, { 0xE6, 0xB2, 0x81 },
	0xa848, { 0xE6, 0xB2, 0x88 },
	0xa849, { 0xE6, 0xB2, 0x89 },
	0xa84a, { 0xE6, 0xB2, 0x85 },
	0xa84b, { 0xE6, 0xB2, 0x9B },
	0xa84c, { 0xE6, 0xB1, 0xAA },
	0xa84d, { 0xE6, 0xB1, 0xBA },
	0xa84e, { 0xE6, 0xB2, 0x90 },
	0xa84f, { 0xE6, 0xB1, 0xB0 },
	0xa850, { 0xE6, 0xB2, 0x8C },
	0xa851, { 0xE6, 0xB1, 0xA8 },
	0xa852, { 0xE6, 0xB2, 0x96 },
	0xa853, { 0xE6, 0xB2, 0x92 },
	0xa854, { 0xE6, 0xB1, 0xBD },
	0xa855, { 0xE6, 0xB2, 0x83 },
	0xa856, { 0xE6, 0xB1, 0xB2 },
	0xa857, { 0xE6, 0xB1, 0xBE },
	0xa858, { 0xE6, 0xB1, 0xB4 },
	0xa859, { 0xE6, 0xB2, 0x86 },
	0xa85a, { 0xE6, 0xB1, 0xB6 },
	0xa85b, { 0xE6, 0xB2, 0x8D },
	0xa85c, { 0xE6, 0xB2, 0x94 },
	0xa85d, { 0xE6, 0xB2, 0x98 },
	0xa85e, { 0xE6, 0xB2, 0x82 },
	0xa85f, { 0xE7, 0x81, 0xB6 },
	0xa860, { 0xE7, 0x81, 0xBC },
	0xa861, { 0xE7, 0x81, 0xBD },
	0xa862, { 0xE7, 0x81, 0xB8 },
	0xa863, { 0xE7, 0x89, 0xA2 },
	0xa864, { 0xE7, 0x89, 0xA1 },
	0xa865, { 0xE7, 0x89, 0xA0 },
	0xa866, { 0xE7, 0x8B, 0x84 },
	0xa867, { 0xE7, 0x8B, 0x82 },
	0xa868, { 0xE7, 0x8E, 0x96 },
	0xa869, { 0xE7, 0x94, 0xAC },
	0xa86a, { 0xE7, 0x94, 0xAB },
	0xa86b, { 0xE7, 0x94, 0xB7 },
	0xa86c, { 0xE7, 0x94, 0xB8 },
	0xa86d, { 0xE7, 0x9A, 0x82 },
	0xa86e, { 0xE7, 0x9B, 0xAF },
	0xa86f, { 0xE7, 0x9F, 0xA3 },
	0xa870, { 0xE7, 0xA7, 0x81 },
	0xa871, { 0xE7, 0xA7, 0x80 },
	0xa872, { 0xE7, 0xA6, 0xBF },
	0xa873, { 0xE7, 0xA9, 0xB6 },
	0xa874, { 0xE7, 0xB3, 0xBB },
	0xa875, { 0xE7, 0xBD, 0x95 },
	0xa876, { 0xE8, 0x82, 0x96 },
	0xa877, { 0xE8, 0x82, 0x93 },
	0xa878, { 0xE8, 0x82, 0x9D },
	0xa879, { 0xE8, 0x82, 0x98 },
	0xa87a, { 0xE8, 0x82, 0x9B },
	0xa87b, { 0xE8, 0x82, 0x9A },
	0xa87c, { 0xE8, 0x82, 0xB2 },
	0xa87d, { 0xE8, 0x89, 0xAF },
	0xa87e, { 0xE8, 0x8A, 0x92 },
	0xa8a1, { 0xE8, 0x8A, 0x8B },
	0xa8a2, { 0xE8, 0x8A, 0x8D },
	0xa8a3, { 0xE8, 0xA6, 0x8B },
	0xa8a4, { 0xE8, 0xA7, 0x92 },
	0xa8a5, { 0xE8, 0xA8, 0x80 },
	0xa8a6, { 0xE8, 0xB0, 0xB7 },
	0xa8a7, { 0xE8, 0xB1, 0x86 },
	0xa8a8, { 0xE8, 0xB1, 0x95 },
	0xa8a9, { 0xE8, 0xB2, 0x9D },
	0xa8aa, { 0xE8, 0xB5, 0xA4 },
	0xa8ab, { 0xE8, 0xB5, 0xB0 },
	0xa8ac, { 0xE8, 0xB6, 0xB3 },
	0xa8ad, { 0xE8, 0xBA, 0xAB },
	0xa8ae, { 0xE8, 0xBB, 0x8A },
	0xa8af, { 0xE8, 0xBE, 0x9B },
	0xa8b0, { 0xE8, 0xBE, 0xB0 },
	0xa8b1, { 0xE8, 0xBF, 0x82 },
	0xa8b2, { 0xE8, 0xBF, 0x86 },
	0xa8b3, { 0xE8, 0xBF, 0x85 },
	0xa8b4, { 0xE8, 0xBF, 0x84 },
	0xa8b5, { 0xE5, 0xB7, 0xA1 },
	0xa8b6, { 0xE9, 0x82, 0x91 },
	0xa8b7, { 0xE9, 0x82, 0xA2 },
	0xa8b8, { 0xE9, 0x82, 0xAA },
	0xa8b9, { 0xE9, 0x82, 0xA6 },
	0xa8ba, { 0xE9, 0x82, 0xA3 },
	0xa8bb, { 0xE9, 0x85, 0x89 },
	0xa8bc, { 0xE9, 0x87, 0x86 },
	0xa8bd, { 0xE9, 0x87, 0x8C },
	0xa8be, { 0xE9, 0x98, 0xB2 },
	0xa8bf, { 0xE9, 0x98, 0xAE },
	0xa8c0, { 0xE9, 0x98, 0xB1 },
	0xa8c1, { 0xE9, 0x98, 0xAA },
	0xa8c2, { 0xE9, 0x98, 0xAC },
	0xa8c3, { 0xE4, 0xB8, 0xA6 },
	0xa8c4, { 0xE4, 0xB9, 0x96 },
	0xa8c5, { 0xE4, 0xB9, 0xB3 },
	0xa8c6, { 0xE4, 0xBA, 0x8B },
	0xa8c7, { 0xE4, 0xBA, 0x9B },
	0xa8c8, { 0xE4, 0xBA, 0x9E },
	0xa8c9, { 0xE4, 0xBA, 0xAB },
	0xa8ca, { 0xE4, 0xBA, 0xAC },
	0xa8cb, { 0xE4, 0xBD, 0xAF },
	0xa8cc, { 0xE4, 0xBE, 0x9D },
	0xa8cd, { 0xE4, 0xBE, 0x8D },
	0xa8ce, { 0xE4, 0xBD, 0xB3 },
	0xa8cf, { 0xE4, 0xBD, 0xBF },
	0xa8d0, { 0xE4, 0xBD, 0xAC },
	0xa8d1, { 0xE4, 0xBE, 0x9B },
	0xa8d2, { 0xE4, 0xBE, 0x8B },
	0xa8d3, { 0xE4, 0xBE, 0x86 },
	0xa8d4, { 0xE4, 0xBE, 0x83 },
	0xa8d5, { 0xE4, 0xBD, 0xB0 },
	0xa8d6, { 0xE4, 0xBD, 0xB5 },
	0xa8d7, { 0xE4, 0xBE, 0x88 },
	0xa8d8, { 0xE4, 0xBD, 0xA9 },
	0xa8d9, { 0xE4, 0xBD, 0xBB },
	0xa8da, { 0xE4, 0xBE, 0x96 },
	0xa8db, { 0xE4, 0xBD, 0xBE },
	0xa8dc, { 0xE4, 0xBE, 0x8F },
	0xa8dd, { 0xE4, 0xBE, 0x91 },
	0xa8de, { 0xE4, 0xBD, 0xBA },
	0xa8df, { 0xE5, 0x85, 0x94 },
	0xa8e0, { 0xE5, 0x85, 0x92 },
	0xa8e1, { 0xE5, 0x85, 0x95 },
	0xa8e2, { 0xE5, 0x85, 0xA9 },
	0xa8e3, { 0xE5, 0x85, 0xB7 },
	0xa8e4, { 0xE5, 0x85, 0xB6 },
	0xa8e5, { 0xE5, 0x85, 0xB8 },
	0xa8e6, { 0xE5, 0x86, 0xBD },
	0xa8e7, { 0xE5, 0x87, 0xBD },
	0xa8e8, { 0xE5, 0x88, 0xBB },
	0xa8e9, { 0xE5, 0x88, 0xB8 },
	0xa8ea, { 0xE5, 0x88, 0xB7 },
	0xa8eb, { 0xE5, 0x88, 0xBA },
	0xa8ec, { 0xE5, 0x88, 0xB0 },
	0xa8ed, { 0xE5, 0x88, 0xAE },
	0xa8ee, { 0xE5, 0x88, 0xB6 },
	0xa8ef, { 0xE5, 0x89, 0x81 },
	0xa8f0, { 0xE5, 0x8A, 0xBE },
	0xa8f1, { 0xE5, 0x8A, 0xBB },
	0xa8f2, { 0xE5, 0x8D, 0x92 },
	0xa8f3, { 0xE5, 0x8D, 0x94 },
	0xa8f4, { 0xE5, 0x8D, 0x93 },
	0xa8f5, { 0xE5, 0x8D, 0x91 },
	0xa8f6, { 0xE5, 0x8D, 0xA6 },
	0xa8f7, { 0xE5, 0x8D, 0xB7 },
	0xa8f8, { 0xE5, 0x8D, 0xB8 },
	0xa8f9, { 0xE5, 0x8D, 0xB9 },
	0xa8fa, { 0xE5, 0x8F, 0x96 },
	0xa8fb, { 0xE5, 0x8F, 0x94 },
	0xa8fc, { 0xE5, 0x8F, 0x97 },
	0xa8fd, { 0xE5, 0x91, 0xB3 },
	0xa8fe, { 0xE5, 0x91, 0xB5 },
	0xa940, { 0xE5, 0x92, 0x96 },
	0xa941, { 0xE5, 0x91, 0xB8 },
	0xa942, { 0xE5, 0x92, 0x95 },
	0xa943, { 0xE5, 0x92, 0x80 },
	0xa944, { 0xE5, 0x91, 0xBB },
	0xa945, { 0xE5, 0x91, 0xB7 },
	0xa946, { 0xE5, 0x92, 0x84 },
	0xa947, { 0xE5, 0x92, 0x92 },
	0xa948, { 0xE5, 0x92, 0x86 },
	0xa949, { 0xE5, 0x91, 0xBC },
	0xa94a, { 0xE5, 0x92, 0x90 },
	0xa94b, { 0xE5, 0x91, 0xB1 },
	0xa94c, { 0xE5, 0x91, 0xB6 },
	0xa94d, { 0xE5, 0x92, 0x8C },
	0xa94e, { 0xE5, 0x92, 0x9A },
	0xa94f, { 0xE5, 0x91, 0xA2 },
	0xa950, { 0xE5, 0x91, 0xA8 },
	0xa951, { 0xE5, 0x92, 0x8B },
	0xa952, { 0xE5, 0x91, 0xBD },
	0xa953, { 0xE5, 0x92, 0x8E },
	0xa954, { 0xE5, 0x9B, 0xBA },
	0xa955, { 0xE5, 0x9E, 0x83 },
	0xa956, { 0xE5, 0x9D, 0xB7 },
	0xa957, { 0xE5, 0x9D, 0xAA },
	0xa958, { 0xE5, 0x9D, 0xA9 },
	0xa959, { 0xE5, 0x9D, 0xA1 },
	0xa95a, { 0xE5, 0x9D, 0xA6 },
	0xa95b, { 0xE5, 0x9D, 0xA4 },
	0xa95c, { 0xE5, 0x9D, 0xBC },
	0xa95d, { 0xE5, 0xA4, 0x9C },
	0xa95e, { 0xE5, 0xA5, 0x89 },
	0xa95f, { 0xE5, 0xA5, 0x87 },
	0xa960, { 0xE5, 0xA5, 0x88 },
	0xa961, { 0xE5, 0xA5, 0x84 },
	0xa962, { 0xE5, 0xA5, 0x94 },
	0xa963, { 0xE5, 0xA6, 0xBE },
	0xa964, { 0xE5, 0xA6, 0xBB },
	0xa965, { 0xE5, 0xA7, 0x94 },
	0xa966, { 0xE5, 0xA6, 0xB9 },
	0xa967, { 0xE5, 0xA6, 0xAE },
	0xa968, { 0xE5, 0xA7, 0x91 },
	0xa969, { 0xE5, 0xA7, 0x86 },
	0xa96a, { 0xE5, 0xA7, 0x90 },
	0xa96b, { 0xE5, 0xA7, 0x8D },
	0xa96c, { 0xE5, 0xA7, 0x8B },
	0xa96d, { 0xE5, 0xA7, 0x93 },
	0xa96e, { 0xE5, 0xA7, 0x8A },
	0xa96f, { 0xE5, 0xA6, 0xAF },
	0xa970, { 0xE5, 0xA6, 0xB3 },
	0xa971, { 0xE5, 0xA7, 0x92 },
	0xa972, { 0xE5, 0xA7, 0x85 },
	0xa973, { 0xE5, 0xAD, 0x9F },
	0xa974, { 0xE5, 0xAD, 0xA4 },
	0xa975, { 0xE5, 0xAD, 0xA3 },
	0xa976, { 0xE5, 0xAE, 0x97 },
	0xa977, { 0xE5, 0xAE, 0x9A },
	0xa978, { 0xE5, 0xAE, 0x98 },
	0xa979, { 0xE5, 0xAE, 0x9C },
	0xa97a, { 0xE5, 0xAE, 0x99 },
	0xa97b, { 0xE5, 0xAE, 0x9B },
	0xa97c, { 0xE5, 0xB0, 0x9A },
	0xa97d, { 0xE5, 0xB1, 0x88 },
	0xa97e, { 0xE5, 0xB1, 0x85 },
	0xa9a1, { 0xE5, 0xB1, 0x86 },
	0xa9a2, { 0xE5, 0xB2, 0xB7 },
	0xa9a3, { 0xE5, 0xB2, 0xA1 },
	0xa9a4, { 0xE5, 0xB2, 0xB8 },
	0xa9a5, { 0xE5, 0xB2, 0xA9 },
	0xa9a6, { 0xE5, 0xB2, 0xAB },
	0xa9a7, { 0xE5, 0xB2, 0xB1 },
	0xa9a8, { 0xE5, 0xB2, 0xB3 },
	0xa9a9, { 0xE5, 0xB8, 0x98 },
	0xa9aa, { 0xE5, 0xB8, 0x9A },
	0xa9ab, { 0xE5, 0xB8, 0x96 },
	0xa9ac, { 0xE5, 0xB8, 0x95 },
	0xa9ad, { 0xE5, 0xB8, 0x9B },
	0xa9ae, { 0xE5, 0xB8, 0x91 },
	0xa9af, { 0xE5, 0xB9, 0xB8 },
	0xa9b0, { 0xE5, 0xBA, 0x9A },
	0xa9b1, { 0xE5, 0xBA, 0x97 },
	0xa9b2, { 0xE5, 0xBA, 0x9C },
	0xa9b3, { 0xE5, 0xBA, 0x95 },
	0xa9b4, { 0xE5, 0xBA, 0x96 },
	0xa9b5, { 0xE5, 0xBB, 0xB6 },
	0xa9b6, { 0xE5, 0xBC, 0xA6 },
	0xa9b7, { 0xE5, 0xBC, 0xA7 },
	0xa9b8, { 0xE5, 0xBC, 0xA9 },
	0xa9b9, { 0xE5, 0xBE, 0x80 },
	0xa9ba, { 0xE5, 0xBE, 0x81 },
	0xa9bb, { 0xE5, 0xBD, 0xBF },
	0xa9bc, { 0xE5, 0xBD, 0xBC },
	0xa9bd, { 0xE5, 0xBF, 0x9D },
	0xa9be, { 0xE5, 0xBF, 0xA0 },
	0xa9bf, { 0xE5, 0xBF, 0xBD },
	0xa9c0, { 0xE5, 0xBF, 0xB5 },
	0xa9c1, { 0xE5, 0xBF, 0xBF },
	0xa9c2, { 0xE6, 0x80, 0x8F },
	0xa9c3, { 0xE6, 0x80, 0x94 },
	0xa9c4, { 0xE6, 0x80, 0xAF },
	0xa9c5, { 0xE6, 0x80, 0xB5 },
	0xa9c6, { 0xE6, 0x80, 0x96 },
	0xa9c7, { 0xE6, 0x80, 0xAA },
	0xa9c8, { 0xE6, 0x80, 0x95 },
	0xa9c9, { 0xE6, 0x80, 0xA1 },
	0xa9ca, { 0xE6, 0x80, 0xA7 },
	0xa9cb, { 0xE6, 0x80, 0xA9 },
	0xa9cc, { 0xE6, 0x80, 0xAB },
	0xa9cd, { 0xE6, 0x80, 0x9B },
	0xa9ce, { 0xE6, 0x88, 0x96 },
	0xa9cf, { 0xE6, 0x88, 0x95 },
	0xa9d0, { 0xE6, 0x88, 0xBF },
	0xa9d1, { 0xE6, 0x88, 0xBE },
	0xa9d2, { 0xE6, 0x89, 0x80 },
	0xa9d3, { 0xE6, 0x89, 0xBF },
	0xa9d4, { 0xE6, 0x8B, 0x89 },
	0xa9d5, { 0xE6, 0x8B, 0x8C },
	0xa9d6, { 0xE6, 0x8B, 0x84 },
	0xa9d7, { 0xE6, 0x8A, 0xBF },
	0xa9d8, { 0xE6, 0x8B, 0x82 },
	0xa9d9, { 0xE6, 0x8A, 0xB9 },
	0xa9da, { 0xE6, 0x8B, 0x92 },
	0xa9db, { 0xE6, 0x8B, 0x9B },
	0xa9dc, { 0xE6, 0x8A, 0xAB },
	0xa9dd, { 0xE6, 0x8B, 0x93 },
	0xa9de, { 0xE6, 0x8B, 0x94 },
	0xa9df, { 0xE6, 0x8B, 0x8B },
	0xa9e0, { 0xE6, 0x8B, 0x88 },
	0xa9e1, { 0xE6, 0x8A, 0xA8 },
	0xa9e2, { 0xE6, 0x8A, 0xBD },
	0xa9e3, { 0xE6, 0x8A, 0xBC },
	0xa9e4, { 0xE6, 0x8B, 0x90 },
	0xa9e5, { 0xE6, 0x8B, 0x99 },
	0xa9e6, { 0xE6, 0x8B, 0x87 },
	0xa9e7, { 0xE6, 0x8B, 0x8D },
	0xa9e8, { 0xE6, 0x8A, 0xB5 },
	0xa9e9, { 0xE6, 0x8B, 0x9A },
	0xa9ea, { 0xE6, 0x8A, 0xB1 },
	0xa9eb, { 0xE6, 0x8B, 0x98 },
	0xa9ec, { 0xE6, 0x8B, 0x96 },
	0xa9ed, { 0xE6, 0x8B, 0x97 },
	0xa9ee, { 0xE6, 0x8B, 0x86 },
	0xa9ef, { 0xE6, 0x8A, 0xAC },
	0xa9f0, { 0xE6, 0x8B, 0x8E },
	0xa9f1, { 0xE6, 0x94, 0xBE },
	0xa9f2, { 0xE6, 0x96, 0xA7 },
	0xa9f3, { 0xE6, 0x96, 0xBC },
	0xa9f4, { 0xE6, 0x97, 0xBA },
	0xa9f5, { 0xE6, 0x98, 0x94 },
	0xa9f6, { 0xE6, 0x98, 0x93 },
	0xa9f7, { 0xE6, 0x98, 0x8C },
	0xa9f8, { 0xE6, 0x98, 0x86 },
	0xa9f9, { 0xE6, 0x98, 0x82 },
	0xa9fa, { 0xE6, 0x98, 0x8E },
	0xa9fb, { 0xE6, 0x98, 0x80 },
	0xa9fc, { 0xE6, 0x98, 0x8F },
	0xa9fd, { 0xE6, 0x98, 0x95 },
	0xa9fe, { 0xE6, 0x98, 0x8A },
	0xaa40, { 0xE6, 0x98, 0x87 },
	0xaa41, { 0xE6, 0x9C, 0x8D },
	0xaa42, { 0xE6, 0x9C, 0x8B },
	0xaa43, { 0xE6, 0x9D, 0xAD },
	0xaa44, { 0xE6, 0x9E, 0x8B },
	0xaa45, { 0xE6, 0x9E, 0x95 },
	0xaa46, { 0xE6, 0x9D, 0xB1 },
	0xaa47, { 0xE6, 0x9E, 0x9C },
	0xaa48, { 0xE6, 0x9D, 0xB3 },
	0xaa49, { 0xE6, 0x9D, 0xB7 },
	0xaa4a, { 0xE6, 0x9E, 0x87 },
	0xaa4b, { 0xE6, 0x9E, 0x9D },
	0xaa4c, { 0xE6, 0x9E, 0x97 },
	0xaa4d, { 0xE6, 0x9D, 0xAF },
	0xaa4e, { 0xE6, 0x9D, 0xB0 },
	0xaa4f, { 0xE6, 0x9D, 0xBF },
	0xaa50, { 0xE6, 0x9E, 0x89 },
	0xaa51, { 0xE6, 0x9D, 0xBE },
	0xaa52, { 0xE6, 0x9E, 0x90 },
	0xaa53, { 0xE6, 0x9D, 0xB5 },
	0xaa54, { 0xE6, 0x9E, 0x9A },
	0xaa55, { 0xE6, 0x9E, 0x93 },
	0xaa56, { 0xE6, 0x9D, 0xBC },
	0xaa57, { 0xE6, 0x9D, 0xAA },
	0xaa58, { 0xE6, 0x9D, 0xB2 },
	0xaa59, { 0xE6, 0xAC, 0xA3 },
	0xaa5a, { 0xE6, 0xAD, 0xA6 },
	0xaa5b, { 0xE6, 0xAD, 0xA7 },
	0xaa5c, { 0xE6, 0xAD, 0xBF },
	0xaa5d, { 0xE6, 0xB0, 0x93 },
	0xaa5e, { 0xE6, 0xB0, 0x9B },
	0xaa5f, { 0xE6, 0xB3, 0xA3 },
	0xaa60, { 0xE6, 0xB3, 0xA8 },
	0xaa61, { 0xE6, 0xB3, 0xB3 },
	0xaa62, { 0xE6, 0xB2, 0xB1 },
	0xaa63, { 0xE6, 0xB3, 0x8C },
	0xaa64, { 0xE6, 0xB3, 0xA5 },
	0xaa65, { 0xE6, 0xB2, 0xB3 },
	0xaa66, { 0xE6, 0xB2, 0xBD },
	0xaa67, { 0xE6, 0xB2, 0xBE },
	0xaa68, { 0xE6, 0xB2, 0xBC },
	0xaa69, { 0xE6, 0xB3, 0xA2 },
	0xaa6a, { 0xE6, 0xB2, 0xAB },
	0xaa6b, { 0xE6, 0xB3, 0x95 },
	0xaa6c, { 0xE6, 0xB3, 0x93 },
	0xaa6d, { 0xE6, 0xB2, 0xB8 },
	0xaa6e, { 0xE6, 0xB3, 0x84 },
	0xaa6f, { 0xE6, 0xB2, 0xB9 },
	0xaa70, { 0xE6, 0xB3, 0x81 },
	0xaa71, { 0xE6, 0xB2, 0xAE },
	0xaa72, { 0xE6, 0xB3, 0x97 },
	0xaa73, { 0xE6, 0xB3, 0x85 },
	0xaa74, { 0xE6, 0xB3, 0xB1 },
	0xaa75, { 0xE6, 0xB2, 0xBF },
	0xaa76, { 0xE6, 0xB2, 0xBB },
	0xaa77, { 0xE6, 0xB3, 0xA1 },
	0xaa78, { 0xE6, 0xB3, 0x9B },
	0xaa79, { 0xE6, 0xB3, 0x8A },
	0xaa7a, { 0xE6, 0xB2, 0xAC },
	0xaa7b, { 0xE6, 0xB3, 0xAF },
	0xaa7c, { 0xE6, 0xB3, 0x9C },
	0xaa7d, { 0xE6, 0xB3, 0x96 },
	0xaa7e, { 0xE6, 0xB3, 0xA0 },
	0xaaa1, { 0xE7, 0x82, 0x95 },
	0xaaa2, { 0xE7, 0x82, 0x8E },
	0xaaa3, { 0xE7, 0x82, 0x92 },
	0xaaa4, { 0xE7, 0x82, 0x8A },
	0xaaa5, { 0xE7, 0x82, 0x99 },
	0xaaa6, { 0xE7, 0x88, 0xAC },
	0xaaa7, { 0xE7, 0x88, 0xAD },
	0xaaa8, { 0xE7, 0x88, 0xB8 },
	0xaaa9, { 0xE7, 0x89, 0x88 },
	0xaaaa, { 0xE7, 0x89, 0xA7 },
	0xaaab, { 0xE7, 0x89, 0xA9 },
	0xaaac, { 0xE7, 0x8B, 0x80 },
	0xaaad, { 0xE7, 0x8B, 0x8E },
	0xaaae, { 0xE7, 0x8B, 0x99 },
	0xaaaf, { 0xE7, 0x8B, 0x97 },
	0xaab0, { 0xE7, 0x8B, 0x90 },
	0xaab1, { 0xE7, 0x8E, 0xA9 },
	0xaab2, { 0xE7, 0x8E, 0xA8 },
	0xaab3, { 0xE7, 0x8E, 0x9F },
	0xaab4, { 0xE7, 0x8E, 0xAB },
	0xaab5, { 0xE7, 0x8E, 0xA5 },
	0xaab6, { 0xE7, 0x94, 0xBD },
	0xaab7, { 0xE7, 0x96, 0x9D },
	0xaab8, { 0xE7, 0x96, 0x99 },
	0xaab9, { 0xE7, 0x96, 0x9A },
	0xaaba, { 0xE7, 0x9A, 0x84 },
	0xaabb, { 0xE7, 0x9B, 0x82 },
	0xaabc, { 0xE7, 0x9B, 0xB2 },
	0xaabd, { 0xE7, 0x9B, 0xB4 },
	0xaabe, { 0xE7, 0x9F, 0xA5 },
	0xaabf, { 0xE7, 0x9F, 0xBD },
	0xaac0, { 0xE7, 0xA4, 0xBE },
	0xaac1, { 0xE7, 0xA5, 0x80 },
	0xaac2, { 0xE7, 0xA5, 0x81 },
	0xaac3, { 0xE7, 0xA7, 0x89 },
	0xaac4, { 0xE7, 0xA7, 0x88 },
	0xaac5, { 0xE7, 0xA9, 0xBA },
	0xaac6, { 0xE7, 0xA9, 0xB9 },
	0xaac7, { 0xE7, 0xAB, 0xBA },
	0xaac8, { 0xE7, 0xB3, 0xBE },
	0xaac9, { 0xE7, 0xBD, 0x94 },
	0xaaca, { 0xE7, 0xBE, 0x8C },
	0xaacb, { 0xE7, 0xBE, 0x8B },
	0xaacc, { 0xE8, 0x80, 0x85 },
	0xaacd, { 0xE8, 0x82, 0xBA },
	0xaace, { 0xE8, 0x82, 0xA5 },
	0xaacf, { 0xE8, 0x82, 0xA2 },
	0xaad0, { 0xE8, 0x82, 0xB1 },
	0xaad1, { 0xE8, 0x82, 0xA1 },
	0xaad2, { 0xE8, 0x82, 0xAB },
	0xaad3, { 0xE8, 0x82, 0xA9 },
	0xaad4, { 0xE8, 0x82, 0xB4 },
	0xaad5, { 0xE8, 0x82, 0xAA },
	0xaad6, { 0xE8, 0x82, 0xAF },
	0xaad7, { 0xE8, 0x87, 0xA5 },
	0xaad8, { 0xE8, 0x87, 0xBE },
	0xaad9, { 0xE8, 0x88, 0x8D },
	0xaada, { 0xE8, 0x8A, 0xB3 },
	0xaadb, { 0xE8, 0x8A, 0x9D },
	0xaadc, { 0xE8, 0x8A, 0x99 },
	0xaadd, { 0xE8, 0x8A, 0xAD },
	0xaade, { 0xE8, 0x8A, 0xBD },
	0xaadf, { 0xE8, 0x8A, 0x9F },
	0xaae0, { 0xE8, 0x8A, 0xB9 },
	0xaae1, { 0xE8, 0x8A, 0xB1 },
	0xaae2, { 0xE8, 0x8A, 0xAC },
	0xaae3, { 0xE8, 0x8A, 0xA5 },
	0xaae4, { 0xE8, 0x8A, 0xAF },
	0xaae5, { 0xE8, 0x8A, 0xB8 },
	0xaae6, { 0xE8, 0x8A, 0xA3 },
	0xaae7, { 0xE8, 0x8A, 0xB0 },
	0xaae8, { 0xE8, 0x8A, 0xBE },
	0xaae9, { 0xE8, 0x8A, 0xB7 },
	0xaaea, { 0xE8, 0x99, 0x8E },
	0xaaeb, { 0xE8, 0x99, 0xB1 },
	0xaaec, { 0xE5, 0x88, 0x9D },
	0xaaed, { 0xE8, 0xA1, 0xA8 },
	0xaaee, { 0xE8, 0xBB, 0x8B },
	0xaaef, { 0xE8, 0xBF, 0x8E },
	0xaaf0, { 0xE8, 0xBF, 0x94 },
	0xaaf1, { 0xE8, 0xBF, 0x91 },
	0xaaf2, { 0xE9, 0x82, 0xB5 },
	0xaaf3, { 0xE9, 0x82, 0xB8 },
	0xaaf4, { 0xE9, 0x82, 0xB1 },
	0xaaf5, { 0xE9, 0x82, 0xB6 },
	0xaaf6, { 0xE9, 0x87, 0x87 },
	0xaaf7, { 0xE9, 0x87, 0x91 },
	0xaaf8, { 0xE9, 0x95, 0xB7 },
	0xaaf9, { 0xE9, 0x96, 0x80 },
	0xaafa, { 0xE9, 0x98, 0x9C },
	0xaafb, { 0xE9, 0x99, 0x80 },
	0xaafc, { 0xE9, 0x98, 0xBF },
	0xaafd, { 0xE9, 0x98, 0xBB },
	0xaafe, { 0xE9, 0x99, 0x84 },
	0xab40, { 0xE9, 0x99, 0x82 },
	0xab41, { 0xE9, 0x9A, 0xB9 },
	0xab42, { 0xE9, 0x9B, 0xA8 },
	0xab43, { 0xE9, 0x9D, 0x92 },
	0xab44, { 0xE9, 0x9D, 0x9E },
	0xab45, { 0xE4, 0xBA, 0x9F },
	0xab46, { 0xE4, 0xBA, 0xAD },
	0xab47, { 0xE4, 0xBA, 0xAE },
	0xab48, { 0xE4, 0xBF, 0xA1 },
	0xab49, { 0xE4, 0xBE, 0xB5 },
	0xab4a, { 0xE4, 0xBE, 0xAF },
	0xab4b, { 0xE4, 0xBE, 0xBF },
	0xab4c, { 0xE4, 0xBF, 0xA0 },
	0xab4d, { 0xE4, 0xBF, 0x91 },
	0xab4e, { 0xE4, 0xBF, 0x8F },
	0xab4f, { 0xE4, 0xBF, 0x9D },
	0xab50, { 0xE4, 0xBF, 0x83 },
	0xab51, { 0xE4, 0xBE, 0xB6 },
	0xab52, { 0xE4, 0xBF, 0x98 },
	0xab53, { 0xE4, 0xBF, 0x9F },
	0xab54, { 0xE4, 0xBF, 0x8A },
	0xab55, { 0xE4, 0xBF, 0x97 },
	0xab56, { 0xE4, 0xBE, 0xAE },
	0xab57, { 0xE4, 0xBF, 0x90 },
	0xab58, { 0xE4, 0xBF, 0x84 },
	0xab59, { 0xE4, 0xBF, 0x82 },
	0xab5a, { 0xE4, 0xBF, 0x9A },
	0xab5b, { 0xE4, 0xBF, 0x8E },
	0xab5c, { 0xE4, 0xBF, 0x9E },
	0xab5d, { 0xE4, 0xBE, 0xB7 },
	0xab5e, { 0xE5, 0x85, 0x97 },
	0xab5f, { 0xE5, 0x86, 0x92 },
	0xab60, { 0xE5, 0x86, 0x91 },
	0xab61, { 0xE5, 0x86, 0xA0 },
	0xab62, { 0xE5, 0x89, 0x8E },
	0xab63, { 0xE5, 0x89, 0x83 },
	0xab64, { 0xE5, 0x89, 0x8A },
	0xab65, { 0xE5, 0x89, 0x8D },
	0xab66, { 0xE5, 0x89, 0x8C },
	0xab67, { 0xE5, 0x89, 0x8B },
	0xab68, { 0xE5, 0x89, 0x87 },
	0xab69, { 0xE5, 0x8B, 0x87 },
	0xab6a, { 0xE5, 0x8B, 0x89 },
	0xab6b, { 0xE5, 0x8B, 0x83 },
	0xab6c, { 0xE5, 0x8B, 0x81 },
	0xab6d, { 0xE5, 0x8C, 0x8D },
	0xab6e, { 0xE5, 0x8D, 0x97 },
	0xab6f, { 0xE5, 0x8D, 0xBB },
	0xab70, { 0xE5, 0x8E, 0x9A },
	0xab71, { 0xE5, 0x8F, 0x9B },
	0xab72, { 0xE5, 0x92, 0xAC },
	0xab73, { 0xE5, 0x93, 0x80 },
	0xab74, { 0xE5, 0x92, 0xA8 },
	0xab75, { 0xE5, 0x93, 0x8E },
	0xab76, { 0xE5, 0x93, 0x89 },
	0xab77, { 0xE5, 0x92, 0xB8 },
	0xab78, { 0xE5, 0x92, 0xA6 },
	0xab79, { 0xE5, 0x92, 0xB3 },
	0xab7a, { 0xE5, 0x93, 0x87 },
	0xab7b, { 0xE5, 0x93, 0x82 },
	0xab7c, { 0xE5, 0x92, 0xBD },
	0xab7d, { 0xE5, 0x92, 0xAA },
	0xab7e, { 0xE5, 0x93, 0x81 },
	0xaba1, { 0xE5, 0x93, 0x84 },
	0xaba2, { 0xE5, 0x93, 0x88 },
	0xaba3, { 0xE5, 0x92, 0xAF },
	0xaba4, { 0xE5, 0x92, 0xAB },
	0xaba5, { 0xE5, 0x92, 0xB1 },
	0xaba6, { 0xE5, 0x92, 0xBB },
	0xaba7, { 0xE5, 0x92, 0xA9 },
	0xaba8, { 0xE5, 0x92, 0xA7 },
	0xaba9, { 0xE5, 0x92, 0xBF },
	0xabaa, { 0xE5, 0x9B, 0xBF },
	0xabab, { 0xE5, 0x9E, 0x82 },
	0xabac, { 0xE5, 0x9E, 0x8B },
	0xabad, { 0xE5, 0x9E, 0xA0 },
	0xabae, { 0xE5, 0x9E, 0xA3 },
	0xabaf, { 0xE5, 0x9E, 0xA2 },
	0xabb0, { 0xE5, 0x9F, 0x8E },
	0xabb1, { 0xE5, 0x9E, 0xAE },
	0xabb2, { 0xE5, 0x9E, 0x93 },
	0xabb3, { 0xE5, 0xA5, 0x95 },
	0xabb4, { 0xE5, 0xA5, 0x91 },
	0xabb5, { 0xE5, 0xA5, 0x8F },
	0xabb6, { 0xE5, 0xA5, 0x8E },
	0xabb7, { 0xE5, 0xA5, 0x90 },
	0xabb8, { 0xE5, 0xA7, 0x9C },
	0xabb9, { 0xE5, 0xA7, 0x98 },
	0xabba, { 0xE5, 0xA7, 0xBF },
	0xabbb, { 0xE5, 0xA7, 0xA3 },
	0xabbc, { 0xE5, 0xA7, 0xA8 },
	0xabbd, { 0xE5, 0xA8, 0x83 },
	0xabbe, { 0xE5, 0xA7, 0xA5 },
	0xabbf, { 0xE5, 0xA7, 0xAA },
	0xabc0, { 0xE5, 0xA7, 0x9A },
	0xabc1, { 0xE5, 0xA7, 0xA6 },
	0xabc2, { 0xE5, 0xA8, 0x81 },
	0xabc3, { 0xE5, 0xA7, 0xBB },
	0xabc4, { 0xE5, 0xAD, 0xA9 },
	0xabc5, { 0xE5, 0xAE, 0xA3 },
	0xabc6, { 0xE5, 0xAE, 0xA6 },
	0xabc7, { 0xE5, 0xAE, 0xA4 },
	0xabc8, { 0xE5, 0xAE, 0xA2 },
	0xabc9, { 0xE5, 0xAE, 0xA5 },
	0xabca, { 0xE5, 0xB0, 0x81 },
	0xabcb, { 0xE5, 0xB1, 0x8E },
	0xabcc, { 0xE5, 0xB1, 0x8F },
	0xabcd, { 0xE5, 0xB1, 0x8D },
	0xabce, { 0xE5, 0xB1, 0x8B },
	0xabcf, { 0xE5, 0xB3, 0x99 },
	0xabd0, { 0xE5, 0xB3, 0x92 },
	0xabd1, { 0xE5, 0xB7, 0xB7 },
	0xabd2, { 0xE5, 0xB8, 0x9D },
	0xabd3, { 0xE5, 0xB8, 0xA5 },
	0xabd4, { 0xE5, 0xB8, 0x9F },
	0xabd5, { 0xE5, 0xB9, 0xBD },
	0xabd6, { 0xE5, 0xBA, 0xA0 },
	0xabd7, { 0xE5, 0xBA, 0xA6 },
	0xabd8, { 0xE5, 0xBB, 0xBA },
	0xabd9, { 0xE5, 0xBC, 0x88 },
	0xabda, { 0xE5, 0xBC, 0xAD },
	0xabdb, { 0xE5, 0xBD, 0xA5 },
	0xabdc, { 0xE5, 0xBE, 0x88 },
	0xabdd, { 0xE5, 0xBE, 0x85 },
	0xabde, { 0xE5, 0xBE, 0x8A },
	0xabdf, { 0xE5, 0xBE, 0x8B },
	0xabe0, { 0xE5, 0xBE, 0x87 },
	0xabe1, { 0xE5, 0xBE, 0x8C },
	0xabe2, { 0xE5, 0xBE, 0x89 },
	0xabe3, { 0xE6, 0x80, 0x92 },
	0xabe4, { 0xE6, 0x80, 0x9D },
	0xabe5, { 0xE6, 0x80, 0xA0 },
	0xabe6, { 0xE6, 0x80, 0xA5 },
	0xabe7, { 0xE6, 0x80, 0x8E },
	0xabe8, { 0xE6, 0x80, 0xA8 },
	0xabe9, { 0xE6, 0x81, 0x8D },
	0xabea, { 0xE6, 0x81, 0xB0 },
	0xabeb, { 0xE6, 0x81, 0xA8 },
	0xabec, { 0xE6, 0x81, 0xA2 },
	0xabed, { 0xE6, 0x81, 0x86 },
	0xabee, { 0xE6, 0x81, 0x83 },
	0xabef, { 0xE6, 0x81, 0xAC },
	0xabf0, { 0xE6, 0x81, 0xAB },
	0xabf1, { 0xE6, 0x81, 0xAA },
	0xabf2, { 0xE6, 0x81, 0xA4 },
	0xabf3, { 0xE6, 0x89, 0x81 },
	0xabf4, { 0xE6, 0x8B, 0x9C },
	0xabf5, { 0xE6, 0x8C, 0x96 },
	0xabf6, { 0xE6, 0x8C, 0x89 },
	0xabf7, { 0xE6, 0x8B, 0xBC },
	0xabf8, { 0xE6, 0x8B, 0xAD },
	0xabf9, { 0xE6, 0x8C, 0x81 },
	0xabfa, { 0xE6, 0x8B, 0xAE },
	0xabfb, { 0xE6, 0x8B, 0xBD },
	0xabfc, { 0xE6, 0x8C, 0x87 },
	0xabfd, { 0xE6, 0x8B, 0xB1 },
	0xabfe, { 0xE6, 0x8B, 0xB7 },
	0xac40, { 0xE6, 0x8B, 0xAF },
	0xac41, { 0xE6, 0x8B, 0xAC },
	0xac42, { 0xE6, 0x8B, 0xBE },
	0xac43, { 0xE6, 0x8B, 0xB4 },
	0xac44, { 0xE6, 0x8C, 0x91 },
	0xac45, { 0xE6, 0x8C, 0x82 },
	0xac46, { 0xE6, 0x94, 0xBF },
	0xac47, { 0xE6, 0x95, 0x85 },
	0xac48, { 0xE6, 0x96, 0xAB },
	0xac49, { 0xE6, 0x96, 0xBD },
	0xac4a, { 0xE6, 0x97, 0xA2 },
	0xac4b, { 0xE6, 0x98, 0xA5 },
	0xac4c, { 0xE6, 0x98, 0xAD },
	0xac4d, { 0xE6, 0x98, 0xA0 },
	0xac4e, { 0xE6, 0x98, 0xA7 },
	0xac4f, { 0xE6, 0x98, 0xAF },
	0xac50, { 0xE6, 0x98, 0x9F },
	0xac51, { 0xE6, 0x98, 0xA8 },
	0xac52, { 0xE6, 0x98, 0xB1 },
	0xac53, { 0xE6, 0x98, 0xA4 },
	0xac54, { 0xE6, 0x9B, 0xB7 },
	0xac55, { 0xE6, 0x9F, 0xBF },
	0xac56, { 0xE6, 0x9F, 0x93 },
	0xac57, { 0xE6, 0x9F, 0xB1 },
	0xac58, { 0xE6, 0x9F, 0x94 },
	0xac59, { 0xE6, 0x9F, 0x90 },
	0xac5a, { 0xE6, 0x9F, 0xAC },
	0xac5b, { 0xE6, 0x9E, 0xB6 },
	0xac5c, { 0xE6, 0x9E, 0xAF },
	0xac5d, { 0xE6, 0x9F, 0xB5 },
	0xac5e, { 0xE6, 0x9F, 0xA9 },
	0xac5f, { 0xE6, 0x9F, 0xAF },
	0xac60, { 0xE6, 0x9F, 0x84 },
	0xac61, { 0xE6, 0x9F, 0x91 },
	0xac62, { 0xE6, 0x9E, 0xB4 },
	0xac63, { 0xE6, 0x9F, 0x9A },
	0xac64, { 0xE6, 0x9F, 0xA5 },
	0xac65, { 0xE6, 0x9E, 0xB8 },
	0xac66, { 0xE6, 0x9F, 0x8F },
	0xac67, { 0xE6, 0x9F, 0x9E },
	0xac68, { 0xE6, 0x9F, 0xB3 },
	0xac69, { 0xE6, 0x9E, 0xB0 },
	0xac6a, { 0xE6, 0x9F, 0x99 },
	0xac6b, { 0xE6, 0x9F, 0xA2 },
	0xac6c, { 0xE6, 0x9F, 0x9D },
	0xac6d, { 0xE6, 0x9F, 0x92 },
	0xac6e, { 0xE6, 0xAD, 0xAA },
	0xac6f, { 0xE6, 0xAE, 0x83 },
	0xac70, { 0xE6, 0xAE, 0x86 },
	0xac71, { 0xE6, 0xAE, 0xB5 },
	0xac72, { 0xE6, 0xAF, 0x92 },
	0xac73, { 0xE6, 0xAF, 0x97 },
	0xac74, { 0xE6, 0xB0, 0x9F },
	0xac75, { 0xE6, 0xB3, 0x89 },
	0xac76, { 0xE6, 0xB4, 0x8B },
	0xac77, { 0xE6, 0xB4, 0xB2 },
	0xac78, { 0xE6, 0xB4, 0xAA },
	0xac79, { 0xE6, 0xB5, 0x81 },
	0xac7a, { 0xE6, 0xB4, 0xA5 },
	0xac7b, { 0xE6, 0xB4, 0x8C },
	0xac7c, { 0xE6, 0xB4, 0xB1 },
	0xac7d, { 0xE6, 0xB4, 0x9E },
	0xac7e, { 0xE6, 0xB4, 0x97 },
	0xaca1, { 0xE6, 0xB4, 0xBB },
	0xaca2, { 0xE6, 0xB4, 0xBD },
	0xaca3, { 0xE6, 0xB4, 0xBE },
	0xaca4, { 0xE6, 0xB4, 0xB6 },
	0xaca5, { 0xE6, 0xB4, 0x9B },
	0xaca6, { 0xE6, 0xB3, 0xB5 },
	0xaca7, { 0xE6, 0xB4, 0xB9 },
	0xaca8, { 0xE6, 0xB4, 0xA7 },
	0xaca9, { 0xE6, 0xB4, 0xB8 },
	0xacaa, { 0xE6, 0xB4, 0xA9 },
	0xacab, { 0xE6, 0xB4, 0xAE },
	0xacac, { 0xE6, 0xB4, 0xB5 },
	0xacad, { 0xE6, 0xB4, 0x8E },
	0xacae, { 0xE6, 0xB4, 0xAB },
	0xacaf, { 0xE7, 0x82, 0xAB },
	0xacb0, { 0xE7, 0x82, 0xBA },
	0xacb1, { 0xE7, 0x82, 0xB3 },
	0xacb2, { 0xE7, 0x82, 0xAC },
	0xacb3, { 0xE7, 0x82, 0xAF },
	0xacb4, { 0xE7, 0x82, 0xAD },
	0xacb5, { 0xE7, 0x82, 0xB8 },
	0xacb6, { 0xE7, 0x82, 0xAE },
	0xacb7, { 0xE7, 0x82, 0xA4 },
	0xacb8, { 0xE7, 0x88, 0xB0 },
	0xacb9, { 0xE7, 0x89, 0xB2 },
	0xacba, { 0xE7, 0x89, 0xAF },
	0xacbb, { 0xE7, 0x89, 0xB4 },
	0xacbc, { 0xE7, 0x8B, 0xA9 },
	0xacbd, { 0xE7, 0x8B, 0xA0 },
	0xacbe, { 0xE7, 0x8B, 0xA1 },
	0xacbf, { 0xE7, 0x8E, 0xB7 },
	0xacc0, { 0xE7, 0x8F, 0x8A },
	0xacc1, { 0xE7, 0x8E, 0xBB },
	0xacc2, { 0xE7, 0x8E, 0xB2 },
	0xacc3, { 0xE7, 0x8F, 0x8D },
	0xacc4, { 0xE7, 0x8F, 0x80 },
	0xacc5, { 0xE7, 0x8E, 0xB3 },
	0xacc6, { 0xE7, 0x94, 0x9A },
	0xacc7, { 0xE7, 0x94, 0xAD },
	0xacc8, { 0xE7, 0x95, 0x8F },
	0xacc9, { 0xE7, 0x95, 0x8C },
	0xacca, { 0xE7, 0x95, 0x8E },
	0xaccb, { 0xE7, 0x95, 0x8B },
	0xaccc, { 0xE7, 0x96, 0xAB },
	0xaccd, { 0xE7, 0x96, 0xA4 },
	0xacce, { 0xE7, 0x96, 0xA5 },
	0xaccf, { 0xE7, 0x96, 0xA2 },
	0xacd0, { 0xE7, 0x96, 0xA3 },
	0xacd1, { 0xE7, 0x99, 0xB8 },
	0xacd2, { 0xE7, 0x9A, 0x86 },
	0xacd3, { 0xE7, 0x9A, 0x87 },
	0xacd4, { 0xE7, 0x9A, 0x88 },
	0xacd5, { 0xE7, 0x9B, 0x88 },
	0xacd6, { 0xE7, 0x9B, 0x86 },
	0xacd7, { 0xE7, 0x9B, 0x83 },
	0xacd8, { 0xE7, 0x9B, 0x85 },
	0xacd9, { 0xE7, 0x9C, 0x81 },
	0xacda, { 0xE7, 0x9B, 0xB9 },
	0xacdb, { 0xE7, 0x9B, 0xB8 },
	0xacdc, { 0xE7, 0x9C, 0x89 },
	0xacdd, { 0xE7, 0x9C, 0x8B },
	0xacde, { 0xE7, 0x9B, 0xBE },
	0xacdf, { 0xE7, 0x9B, 0xBC },
	0xace0, { 0xE7, 0x9C, 0x87 },
	0xace1, { 0xE7, 0x9F, 0x9C },
	0xace2, { 0xE7, 0xA0, 0x82 },
	0xace3, { 0xE7, 0xA0, 0x94 },
	0xace4, { 0xE7, 0xA0, 0x8C },
	0xace5, { 0xE7, 0xA0, 0x8D },
	0xace6, { 0xE7, 0xA5, 0x86 },
	0xace7, { 0xE7, 0xA5, 0x89 },
	0xace8, { 0xE7, 0xA5, 0x88 },
	0xace9, { 0xE7, 0xA5, 0x87 },
	0xacea, { 0xE7, 0xA6, 0xB9 },
	0xaceb, { 0xE7, 0xA6, 0xBA },
	0xacec, { 0xE7, 0xA7, 0x91 },
	0xaced, { 0xE7, 0xA7, 0x92 },
	0xacee, { 0xE7, 0xA7, 0x8B },
	0xacef, { 0xE7, 0xA9, 0xBF },
	0xacf0, { 0xE7, 0xAA, 0x81 },
	0xacf1, { 0xE7, 0xAB, 0xBF },
	0xacf2, { 0xE7, 0xAB, 0xBD },
	0xacf3, { 0xE7, 0xB1, 0xBD },
	0xacf4, { 0xE7, 0xB4, 0x82 },
	0xacf5, { 0xE7, 0xB4, 0x85 },
	0xacf6, { 0xE7, 0xB4, 0x80 },
	0xacf7, { 0xE7, 0xB4, 0x89 },
	0xacf8, { 0xE7, 0xB4, 0x87 },
	0xacf9, { 0xE7, 0xB4, 0x84 },
	0xacfa, { 0xE7, 0xB4, 0x86 },
	0xacfb, { 0xE7, 0xBC, 0xB8 },
	0xacfc, { 0xE7, 0xBE, 0x8E },
	0xacfd, { 0xE7, 0xBE, 0xBF },
	0xacfe, { 0xE8, 0x80, 0x84 },
	0xad40, { 0xE8, 0x80, 0x90 },
	0xad41, { 0xE8, 0x80, 0x8D },
	0xad42, { 0xE8, 0x80, 0x91 },
	0xad43, { 0xE8, 0x80, 0xB6 },
	0xad44, { 0xE8, 0x83, 0x96 },
	0xad45, { 0xE8, 0x83, 0xA5 },
	0xad46, { 0xE8, 0x83, 0x9A },
	0xad47, { 0xE8, 0x83, 0x83 },
	0xad48, { 0xE8, 0x83, 0x84 },
	0xad49, { 0xE8, 0x83, 0x8C },
	0xad4a, { 0xE8, 0x83, 0xA1 },
	0xad4b, { 0xE8, 0x83, 0x9B },
	0xad4c, { 0xE8, 0x83, 0x8E },
	0xad4d, { 0xE8, 0x83, 0x9E },
	0xad4e, { 0xE8, 0x83, 0xA4 },
	0xad4f, { 0xE8, 0x83, 0x9D },
	0xad50, { 0xE8, 0x87, 0xB4 },
	0xad51, { 0xE8, 0x88, 0xA2 },
	0xad52, { 0xE8, 0x8B, 0xA7 },
	0xad53, { 0xE8, 0x8C, 0x83 },
	0xad54, { 0xE8, 0x8C, 0x85 },
	0xad55, { 0xE8, 0x8B, 0xA3 },
	0xad56, { 0xE8, 0x8B, 0x9B },
	0xad57, { 0xE8, 0x8B, 0xA6 },
	0xad58, { 0xE8, 0x8C, 0x84 },
	0xad59, { 0xE8, 0x8B, 0xA5 },
	0xad5a, { 0xE8, 0x8C, 0x82 },
	0xad5b, { 0xE8, 0x8C, 0x89 },
	0xad5c, { 0xE8, 0x8B, 0x92 },
	0xad5d, { 0xE8, 0x8B, 0x97 },
	0xad5e, { 0xE8, 0x8B, 0xB1 },
	0xad5f, { 0xE8, 0x8C, 0x81 },
	0xad60, { 0xE8, 0x8B, 0x9C },
	0xad61, { 0xE8, 0x8B, 0x94 },
	0xad62, { 0xE8, 0x8B, 0x91 },
	0xad63, { 0xE8, 0x8B, 0x9E },
	0xad64, { 0xE8, 0x8B, 0x93 },
	0xad65, { 0xE8, 0x8B, 0x9F },
	0xad66, { 0xE8, 0x8B, 0xAF },
	0xad67, { 0xE8, 0x8C, 0x86 },
	0xad68, { 0xE8, 0x99, 0x90 },
	0xad69, { 0xE8, 0x99, 0xB9 },
	0xad6a, { 0xE8, 0x99, 0xBB },
	0xad6b, { 0xE8, 0x99, 0xBA },
	0xad6c, { 0xE8, 0xA1, 0x8D },
	0xad6d, { 0xE8, 0xA1, 0xAB },
	0xad6e, { 0xE8, 0xA6, 0x81 },
	0xad6f, { 0xE8, 0xA7, 0x94 },
	0xad70, { 0xE8, 0xA8, 0x88 },
	0xad71, { 0xE8, 0xA8, 0x82 },
	0xad72, { 0xE8, 0xA8, 0x83 },
	0xad73, { 0xE8, 0xB2, 0x9E },
	0xad74, { 0xE8, 0xB2, 0xA0 },
	0xad75, { 0xE8, 0xB5, 0xB4 },
	0xad76, { 0xE8, 0xB5, 0xB3 },
	0xad77, { 0xE8, 0xB6, 0xB4 },
	0xad78, { 0xE8, 0xBB, 0x8D },
	0xad79, { 0xE8, 0xBB, 0x8C },
	0xad7a, { 0xE8, 0xBF, 0xB0 },
	0xad7b, { 0xE8, 0xBF, 0xA6 },
	0xad7c, { 0xE8, 0xBF, 0xA2 },
	0xad7d, { 0xE8, 0xBF, 0xAA },
	0xad7e, { 0xE8, 0xBF, 0xA5 },
	0xada1, { 0xE8, 0xBF, 0xAD },
	0xada2, { 0xE8, 0xBF, 0xAB },
	0xada3, { 0xE8, 0xBF, 0xA4 },
	0xada4, { 0xE8, 0xBF, 0xA8 },
	0xada5, { 0xE9, 0x83, 0x8A },
	0xada6, { 0xE9, 0x83, 0x8E },
	0xada7, { 0xE9, 0x83, 0x81 },
	0xada8, { 0xE9, 0x83, 0x83 },
	0xada9, { 0xE9, 0x85, 0x8B },
	0xadaa, { 0xE9, 0x85, 0x8A },
	0xadab, { 0xE9, 0x87, 0x8D },
	0xadac, { 0xE9, 0x96, 0x82 },
	0xadad, { 0xE9, 0x99, 0x90 },
	0xadae, { 0xE9, 0x99, 0x8B },
	0xadaf, { 0xE9, 0x99, 0x8C },
	0xadb0, { 0xE9, 0x99, 0x8D },
	0xadb1, { 0xE9, 0x9D, 0xA2 },
	0xadb2, { 0xE9, 0x9D, 0xA9 },
	0xadb3, { 0xE9, 0x9F, 0x8B },
	0xadb4, { 0xE9, 0x9F, 0xAD },
	0xadb5, { 0xE9, 0x9F, 0xB3 },
	0xadb6, { 0xE9, 0xA0, 0x81 },
	0xadb7, { 0xE9, 0xA2, 0xA8 },
	0xadb8, { 0xE9, 0xA3, 0x9B },
	0xadb9, { 0xE9, 0xA3, 0x9F },
	0xadba, { 0xE9, 0xA6, 0x96 },
	0xadbb, { 0xE9, 0xA6, 0x99 },
	0xadbc, { 0xE4, 0xB9, 0x98 },
	0xadbd, { 0xE4, 0xBA, 0xB3 },
	0xadbe, { 0xE5, 0x80, 0x8C },
	0xadbf, { 0xE5, 0x80, 0x8D },
	0xadc0, { 0xE5, 0x80, 0xA3 },
	0xadc1, { 0xE4, 0xBF, 0xAF },
	0xadc2, { 0xE5, 0x80, 0xA6 },
	0xadc3, { 0xE5, 0x80, 0xA5 },
	0xadc4, { 0xE4, 0xBF, 0xB8 },
	0xadc5, { 0xE5, 0x80, 0xA9 },
	0xadc6, { 0xE5, 0x80, 0x96 },
	0xadc7, { 0xE5, 0x80, 0x86 },
	0xadc8, { 0xE5, 0x80, 0xBC },
	0xadc9, { 0xE5, 0x80, 0x9F },
	0xadca, { 0xE5, 0x80, 0x9A },
	0xadcb, { 0xE5, 0x80, 0x92 },
	0xadcc, { 0xE5, 0x80, 0x91 },
	0xadcd, { 0xE4, 0xBF, 0xBA },
	0xadce, { 0xE5, 0x80, 0x80 },
	0xadcf, { 0xE5, 0x80, 0x94 },
	0xadd0, { 0xE5, 0x80, 0xA8 },
	0xadd1, { 0xE4, 0xBF, 0xB1 },
	0xadd2, { 0xE5, 0x80, 0xA1 },
	0xadd3, { 0xE5, 0x80, 0x8B },
	0xadd4, { 0xE5, 0x80, 0x99 },
	0xadd5, { 0xE5, 0x80, 0x98 },
	0xadd6, { 0xE4, 0xBF, 0xB3 },
	0xadd7, { 0xE4, 0xBF, 0xAE },
	0xadd8, { 0xE5, 0x80, 0xAD },
	0xadd9, { 0xE5, 0x80, 0xAA },
	0xadda, { 0xE4, 0xBF, 0xBE },
	0xaddb, { 0xE5, 0x80, 0xAB },
	0xaddc, { 0xE5, 0x80, 0x89 },
	0xaddd, { 0xE5, 0x85, 0xBC },
	0xadde, { 0xE5, 0x86, 0xA4 },
	0xaddf, { 0xE5, 0x86, 0xA5 },
	0xade0, { 0xE5, 0x86, 0xA2 },
	0xade1, { 0xE5, 0x87, 0x8D },
	0xade2, { 0xE5, 0x87, 0x8C },
	0xade3, { 0xE5, 0x87, 0x86 },
	0xade4, { 0xE5, 0x87, 0x8B },
	0xade5, { 0xE5, 0x89, 0x96 },
	0xade6, { 0xE5, 0x89, 0x9C },
	0xade7, { 0xE5, 0x89, 0x94 },
	0xade8, { 0xE5, 0x89, 0x9B },
	0xade9, { 0xE5, 0x89, 0x9D },
	0xadea, { 0xE5, 0x8C, 0xAA },
	0xadeb, { 0xE5, 0x8D, 0xBF },
	0xadec, { 0xE5, 0x8E, 0x9F },
	0xaded, { 0xE5, 0x8E, 0x9D },
	0xadee, { 0xE5, 0x8F, 0x9F },
	0xadef, { 0xE5, 0x93, 0xA8 },
	0xadf0, { 0xE5, 0x94, 0x90 },
	0xadf1, { 0xE5, 0x94, 0x81 },
	0xadf2, { 0xE5, 0x94, 0xB7 },
	0xadf3, { 0xE5, 0x93, 0xBC },
	0xadf4, { 0xE5, 0x93, 0xA5 },
	0xadf5, { 0xE5, 0x93, 0xB2 },
	0xadf6, { 0xE5, 0x94, 0x86 },
	0xadf7, { 0xE5, 0x93, 0xBA },
	0xadf8, { 0xE5, 0x94, 0x94 },
	0xadf9, { 0xE5, 0x93, 0xA9 },
	0xadfa, { 0xE5, 0x93, 0xAD },
	0xadfb, { 0xE5, 0x93, 0xA1 },
	0xadfc, { 0xE5, 0x94, 0x89 },
	0xadfd, { 0xE5, 0x93, 0xAE },
	0xadfe, { 0xE5, 0x93, 0xAA },
	0xae40, { 0xE5, 0x93, 0xA6 },
	0xae41, { 0xE5, 0x94, 0xA7 },
	0xae42, { 0xE5, 0x94, 0x87 },
	0xae43, { 0xE5, 0x93, 0xBD },
	0xae44, { 0xE5, 0x94, 0x8F },
	0xae45, { 0xE5, 0x9C, 0x83 },
	0xae46, { 0xE5, 0x9C, 0x84 },
	0xae47, { 0xE5, 0x9F, 0x82 },
	0xae48, { 0xE5, 0x9F, 0x94 },
	0xae49, { 0xE5, 0x9F, 0x8B },
	0xae4a, { 0xE5, 0x9F, 0x83 },
	0xae4b, { 0xE5, 0xA0, 0x89 },
	0xae4c, { 0xE5, 0xA4, 0x8F },
	0xae4d, { 0xE5, 0xA5, 0x97 },
	0xae4e, { 0xE5, 0xA5, 0x98 },
	0xae4f, { 0xE5, 0xA5, 0x9A },
	0xae50, { 0xE5, 0xA8, 0x91 },
	0xae51, { 0xE5, 0xA8, 0x98 },
	0xae52, { 0xE5, 0xA8, 0x9C },
	0xae53, { 0xE5, 0xA8, 0x9F },
	0xae54, { 0xE5, 0xA8, 0x9B },
	0xae55, { 0xE5, 0xA8, 0x93 },
	0xae56, { 0xE5, 0xA7, 0xAC },
	0xae57, { 0xE5, 0xA8, 0xA0 },
	0xae58, { 0xE5, 0xA8, 0xA3 },
	0xae59, { 0xE5, 0xA8, 0xA9 },
	0xae5a, { 0xE5, 0xA8, 0xA5 },
	0xae5b, { 0xE5, 0xA8, 0x8C },
	0xae5c, { 0xE5, 0xA8, 0x89 },
	0xae5d, { 0xE5, 0xAD, 0xAB },
	0xae5e, { 0xE5, 0xB1, 0x98 },
	0xae5f, { 0xE5, 0xAE, 0xB0 },
	0xae60, { 0xE5, 0xAE, 0xB3 },
	0xae61, { 0xE5, 0xAE, 0xB6 },
	0xae62, { 0xE5, 0xAE, 0xB4 },
	0xae63, { 0xE5, 0xAE, 0xAE },
	0xae64, { 0xE5, 0xAE, 0xB5 },
	0xae65, { 0xE5, 0xAE, 0xB9 },
	0xae66, { 0xE5, 0xAE, 0xB8 },
	0xae67, { 0xE5, 0xB0, 0x84 },
	0xae68, { 0xE5, 0xB1, 0x91 },
	0xae69, { 0xE5, 0xB1, 0x95 },
	0xae6a, { 0xE5, 0xB1, 0x90 },
	0xae6b, { 0xE5, 0xB3, 0xAD },
	0xae6c, { 0xE5, 0xB3, 0xBD },
	0xae6d, { 0xE5, 0xB3, 0xBB },
	0xae6e, { 0xE5, 0xB3, 0xAA },
	0xae6f, { 0xE5, 0xB3, 0xA8 },
	0xae70, { 0xE5, 0xB3, 0xB0 },
	0xae71, { 0xE5, 0xB3, 0xB6 },
	0xae72, { 0xE5, 0xB4, 0x81 },
	0xae73, { 0xE5, 0xB3, 0xB4 },
	0xae74, { 0xE5, 0xB7, 0xAE },
	0xae75, { 0xE5, 0xB8, 0xAD },
	0xae76, { 0xE5, 0xB8, 0xAB },
	0xae77, { 0xE5, 0xBA, 0xAB },
	0xae78, { 0xE5, 0xBA, 0xAD },
	0xae79, { 0xE5, 0xBA, 0xA7 },
	0xae7a, { 0xE5, 0xBC, 0xB1 },
	0xae7b, { 0xE5, 0xBE, 0x92 },
	0xae7c, { 0xE5, 0xBE, 0x91 },
	0xae7d, { 0xE5, 0xBE, 0x90 },
	0xae7e, { 0xE6, 0x81, 0x99 },
	0xaea1, { 0xE6, 0x81, 0xA3 },
	0xaea2, { 0xE6, 0x81, 0xA5 },
	0xaea3, { 0xE6, 0x81, 0x90 },
	0xaea4, { 0xE6, 0x81, 0x95 },
	0xaea5, { 0xE6, 0x81, 0xAD },
	0xaea6, { 0xE6, 0x81, 0xA9 },
	0xaea7, { 0xE6, 0x81, 0xAF },
	0xaea8, { 0xE6, 0x82, 0x84 },
	0xaea9, { 0xE6, 0x82, 0x9F },
	0xaeaa, { 0xE6, 0x82, 0x9A },
	0xaeab, { 0xE6, 0x82, 0x8D },
	0xaeac, { 0xE6, 0x82, 0x94 },
	0xaead, { 0xE6, 0x82, 0x8C },
	0xaeae, { 0xE6, 0x82, 0x85 },
	0xaeaf, { 0xE6, 0x82, 0x96 },
	0xaeb0, { 0xE6, 0x89, 0x87 },
	0xaeb1, { 0xE6, 0x8B, 0xB3 },
	0xaeb2, { 0xE6, 0x8C, 0x88 },
	0xaeb3, { 0xE6, 0x8B, 0xBF },
	0xaeb4, { 0xE6, 0x8D, 0x8E },
	0xaeb5, { 0xE6, 0x8C, 0xBE },
	0xaeb6, { 0xE6, 0x8C, 0xAF },
	0xaeb7, { 0xE6, 0x8D, 0x95 },
	0xaeb8, { 0xE6, 0x8D, 0x82 },
	0xaeb9, { 0xE6, 0x8D, 0x86 },
	0xaeba, { 0xE6, 0x8D, 0x8F },
	0xaebb, { 0xE6, 0x8D, 0x89 },
	0xaebc, { 0xE6, 0x8C, 0xBA },
	0xaebd, { 0xE6, 0x8D, 0x90 },
	0xaebe, { 0xE6, 0x8C, 0xBD },
	0xaebf, { 0xE6, 0x8C, 0xAA },
	0xaec0, { 0xE6, 0x8C, 0xAB },
	0xaec1, { 0xE6, 0x8C, 0xA8 },
	0xaec2, { 0xE6, 0x8D, 0x8D },
	0xaec3, { 0xE6, 0x8D, 0x8C },
	0xaec4, { 0xE6, 0x95, 0x88 },
	0xaec5, { 0xE6, 0x95, 0x89 },
	0xaec6, { 0xE6, 0x96, 0x99 },
	0xaec7, { 0xE6, 0x97, 0x81 },
	0xaec8, { 0xE6, 0x97, 0x85 },
	0xaec9, { 0xE6, 0x99, 0x82 },
	0xaeca, { 0xE6, 0x99, 0x89 },
	0xaecb, { 0xE6, 0x99, 0x8F },
	0xaecc, { 0xE6, 0x99, 0x83 },
	0xaecd, { 0xE6, 0x99, 0x92 },
	0xaece, { 0xE6, 0x99, 0x8C },
	0xaecf, { 0xE6, 0x99, 0x85 },
	0xaed0, { 0xE6, 0x99, 0x81 },
	0xaed1, { 0xE6, 0x9B, 0xB8 },
	0xaed2, { 0xE6, 0x9C, 0x94 },
	0xaed3, { 0xE6, 0x9C, 0x95 },
	0xaed4, { 0xE6, 0x9C, 0x97 },
	0xaed5, { 0xE6, 0xA0, 0xA1 },
	0xaed6, { 0xE6, 0xA0, 0xB8 },
	0xaed7, { 0xE6, 0xA1, 0x88 },
	0xaed8, { 0xE6, 0xA1, 0x86 },
	0xaed9, { 0xE6, 0xA1, 0x93 },
	0xaeda, { 0xE6, 0xA0, 0xB9 },
	0xaedb, { 0xE6, 0xA1, 0x82 },
	0xaedc, { 0xE6, 0xA1, 0x94 },
	0xaedd, { 0xE6, 0xA0, 0xA9 },
	0xaede, { 0xE6, 0xA2, 0xB3 },
	0xaedf, { 0xE6, 0xA0, 0x97 },
	0xaee0, { 0xE6, 0xA1, 0x8C },
	0xaee1, { 0xE6, 0xA1, 0x91 },
	0xaee2, { 0xE6, 0xA0, 0xBD },
	0xaee3, { 0xE6, 0x9F, 0xB4 },
	0xaee4, { 0xE6, 0xA1, 0x90 },
	0xaee5, { 0xE6, 0xA1, 0x80 },
	0xaee6, { 0xE6, 0xA0, 0xBC },
	0xaee7, { 0xE6, 0xA1, 0x83 },
	0xaee8, { 0xE6, 0xA0, 0xAA },
	0xaee9, { 0xE6, 0xA1, 0x85 },
	0xaeea, { 0xE6, 0xA0, 0x93 },
	0xaeeb, { 0xE6, 0xA0, 0x98 },
	0xaeec, { 0xE6, 0xA1, 0x81 },
	0xaeed, { 0xE6, 0xAE, 0x8A },
	0xaeee, { 0xE6, 0xAE, 0x89 },
	0xaeef, { 0xE6, 0xAE, 0xB7 },
	0xaef0, { 0xE6, 0xB0, 0xA3 },
	0xaef1, { 0xE6, 0xB0, 0xA7 },
	0xaef2, { 0xE6, 0xB0, 0xA8 },
	0xaef3, { 0xE6, 0xB0, 0xA6 },
	0xaef4, { 0xE6, 0xB0, 0xA4 },
	0xaef5, { 0xE6, 0xB3, 0xB0 },
	0xaef6, { 0xE6, 0xB5, 0xAA },
	0xaef7, { 0xE6, 0xB6, 0x95 },
	0xaef8, { 0xE6, 0xB6, 0x88 },
	0xaef9, { 0xE6, 0xB6, 0x87 },
	0xaefa, { 0xE6, 0xB5, 0xA6 },
	0xaefb, { 0xE6, 0xB5, 0xB8 },
	0xaefc, { 0xE6, 0xB5, 0xB7 },
	0xaefd, { 0xE6, 0xB5, 0x99 },
	0xaefe, { 0xE6, 0xB6, 0x93 },
	0xaf40, { 0xE6, 0xB5, 0xAC },
	0xaf41, { 0xE6, 0xB6, 0x89 },
	0xaf42, { 0xE6, 0xB5, 0xAE },
	0xaf43, { 0xE6, 0xB5, 0x9A },
	0xaf44, { 0xE6, 0xB5, 0xB4 },
	0xaf45, { 0xE6, 0xB5, 0xA9 },
	0xaf46, { 0xE6, 0xB6, 0x8C },
	0xaf47, { 0xE6, 0xB6, 0x8A },
	0xaf48, { 0xE6, 0xB5, 0xB9 },
	0xaf49, { 0xE6, 0xB6, 0x85 },
	0xaf4a, { 0xE6, 0xB5, 0xA5 },
	0xaf4b, { 0xE6, 0xB6, 0x94 },
	0xaf4c, { 0xE7, 0x83, 0x8A },
	0xaf4d, { 0xE7, 0x83, 0x98 },
	0xaf4e, { 0xE7, 0x83, 0xA4 },
	0xaf4f, { 0xE7, 0x83, 0x99 },
	0xaf50, { 0xE7, 0x83, 0x88 },
	0xaf51, { 0xE7, 0x83, 0x8F },
	0xaf52, { 0xE7, 0x88, 0xB9 },
	0xaf53, { 0xE7, 0x89, 0xB9 },
	0xaf54, { 0xE7, 0x8B, 0xBC },
	0xaf55, { 0xE7, 0x8B, 0xB9 },
	0xaf56, { 0xE7, 0x8B, 0xBD },
	0xaf57, { 0xE7, 0x8B, 0xB8 },
	0xaf58, { 0xE7, 0x8B, 0xB7 },
	0xaf59, { 0xE7, 0x8E, 0x86 },
	0xaf5a, { 0xE7, 0x8F, 0xAD },
	0xaf5b, { 0xE7, 0x90, 0x89 },
	0xaf5c, { 0xE7, 0x8F, 0xAE },
	0xaf5d, { 0xE7, 0x8F, 0xA0 },
	0xaf5e, { 0xE7, 0x8F, 0xAA },
	0xaf5f, { 0xE7, 0x8F, 0x9E },
	0xaf60, { 0xE7, 0x95, 0x94 },
	0xaf61, { 0xE7, 0x95, 0x9D },
	0xaf62, { 0xE7, 0x95, 0x9C },
	0xaf63, { 0xE7, 0x95, 0x9A },
	0xaf64, { 0xE7, 0x95, 0x99 },
	0xaf65, { 0xE7, 0x96, 0xBE },
	0xaf66, { 0xE7, 0x97, 0x85 },
	0xaf67, { 0xE7, 0x97, 0x87 },
	0xaf68, { 0xE7, 0x96, 0xB2 },
	0xaf69, { 0xE7, 0x96, 0xB3 },
	0xaf6a, { 0xE7, 0x96, 0xBD },
	0xaf6b, { 0xE7, 0x96, 0xBC },
	0xaf6c, { 0xE7, 0x96, 0xB9 },
	0xaf6d, { 0xE7, 0x97, 0x82 },
	0xaf6e, { 0xE7, 0x96, 0xB8 },
	0xaf6f, { 0xE7, 0x9A, 0x8B },
	0xaf70, { 0xE7, 0x9A, 0xB0 },
	0xaf71, { 0xE7, 0x9B, 0x8A },
	0xaf72, { 0xE7, 0x9B, 0x8D },
	0xaf73, { 0xE7, 0x9B, 0x8E },
	0xaf74, { 0xE7, 0x9C, 0xA9 },
	0xaf75, { 0xE7, 0x9C, 0x9F },
	0xaf76, { 0xE7, 0x9C, 0xA0 },
	0xaf77, { 0xE7, 0x9C, 0xA8 },
	0xaf78, { 0xE7, 0x9F, 0xA9 },
	0xaf79, { 0xE7, 0xA0, 0xB0 },
	0xaf7a, { 0xE7, 0xA0, 0xA7 },
	0xaf7b, { 0xE7, 0xA0, 0xB8 },
	0xaf7c, { 0xE7, 0xA0, 0x9D },
	0xaf7d, { 0xE7, 0xA0, 0xB4 },
	0xaf7e, { 0xE7, 0xA0, 0xB7 },
	0xafa1, { 0xE7, 0xA0, 0xA5 },
	0xafa2, { 0xE7, 0xA0, 0xAD },
	0xafa3, { 0xE7, 0xA0, 0xA0 },
	0xafa4, { 0xE7, 0xA0, 0x9F },
	0xafa5, { 0xE7, 0xA0, 0xB2 },
	0xafa6, { 0xE7, 0xA5, 0x95 },
	0xafa7, { 0xE7, 0xA5, 0x90 },
	0xafa8, { 0xE7, 0xA5, 0xA0 },
	0xafa9, { 0xE7, 0xA5, 0x9F },
	0xafaa, { 0xE7, 0xA5, 0x96 },
	0xafab, { 0xE7, 0xA5, 0x9E },
	0xafac, { 0xE7, 0xA5, 0x9D },
	0xafad, { 0xE7, 0xA5, 0x97 },
	0xafae, { 0xE7, 0xA5, 0x9A },
	0xafaf, { 0xE7, 0xA7, 0xA4 },
	0xafb0, { 0xE7, 0xA7, 0xA3 },
	0xafb1, { 0xE7, 0xA7, 0xA7 },
	0xafb2, { 0xE7, 0xA7, 0x9F },
	0xafb3, { 0xE7, 0xA7, 0xA6 },
	0xafb4, { 0xE7, 0xA7, 0xA9 },
	0xafb5, { 0xE7, 0xA7, 0x98 },
	0xafb6, { 0xE7, 0xAA, 0x84 },
	0xafb7, { 0xE7, 0xAA, 0x88 },
	0xafb8, { 0xE7, 0xAB, 0x99 },
	0xafb9, { 0xE7, 0xAC, 0x86 },
	0xafba, { 0xE7, 0xAC, 0x91 },
	0xafbb, { 0xE7, 0xB2, 0x89 },
	0xafbc, { 0xE7, 0xB4, 0xA1 },
	0xafbd, { 0xE7, 0xB4, 0x97 },
	0xafbe, { 0xE7, 0xB4, 0x8B },
	0xafbf, { 0xE7, 0xB4, 0x8A },
	0xafc0, { 0xE7, 0xB4, 0xA0 },
	0xafc1, { 0xE7, 0xB4, 0xA2 },
	0xafc2, { 0xE7, 0xB4, 0x94 },
	0xafc3, { 0xE7, 0xB4, 0x90 },
	0xafc4, { 0xE7, 0xB4, 0x95 },
	0xafc5, { 0xE7, 0xB4, 0x9A },
	0xafc6, { 0xE7, 0xB4, 0x9C },
	0xafc7, { 0xE7, 0xB4, 0x8D },
	0xafc8, { 0xE7, 0xB4, 0x99 },
	0xafc9, { 0xE7, 0xB4, 0x9B },
	0xafca, { 0xE7, 0xBC, 0xBA },
	0xafcb, { 0xE7, 0xBD, 0x9F },
	0xafcc, { 0xE7, 0xBE, 0x94 },
	0xafcd, { 0xE7, 0xBF, 0x85 },
	0xafce, { 0xE7, 0xBF, 0x81 },
	0xafcf, { 0xE8, 0x80, 0x86 },
	0xafd0, { 0xE8, 0x80, 0x98 },
	0xafd1, { 0xE8, 0x80, 0x95 },
	0xafd2, { 0xE8, 0x80, 0x99 },
	0xafd3, { 0xE8, 0x80, 0x97 },
	0xafd4, { 0xE8, 0x80, 0xBD },
	0xafd5, { 0xE8, 0x80, 0xBF },
	0xafd6, { 0xE8, 0x83, 0xB1 },
	0xafd7, { 0xE8, 0x84, 0x82 },
	0xafd8, { 0xE8, 0x83, 0xB0 },
	0xafd9, { 0xE8, 0x84, 0x85 },
	0xafda, { 0xE8, 0x83, 0xAD },
	0xafdb, { 0xE8, 0x83, 0xB4 },
	0xafdc, { 0xE8, 0x84, 0x86 },
	0xafdd, { 0xE8, 0x83, 0xB8 },
	0xafde, { 0xE8, 0x83, 0xB3 },
	0xafdf, { 0xE8, 0x84, 0x88 },
	0xafe0, { 0xE8, 0x83, 0xBD },
	0xafe1, { 0xE8, 0x84, 0x8A },
	0xafe2, { 0xE8, 0x83, 0xBC },
	0xafe3, { 0xE8, 0x83, 0xAF },
	0xafe4, { 0xE8, 0x87, 0xAD },
	0xafe5, { 0xE8, 0x87, 0xAC },
	0xafe6, { 0xE8, 0x88, 0x80 },
	0xafe7, { 0xE8, 0x88, 0x90 },
	0xafe8, { 0xE8, 0x88, 0xAA },
	0xafe9, { 0xE8, 0x88, 0xAB },
	0xafea, { 0xE8, 0x88, 0xA8 },
	0xafeb, { 0xE8, 0x88, 0xAC },
	0xafec, { 0xE8, 0x8A, 0xBB },
	0xafed, { 0xE8, 0x8C, 0xAB },
	0xafee, { 0xE8, 0x8D, 0x92 },
	0xafef, { 0xE8, 0x8D, 0x94 },
	0xaff0, { 0xE8, 0x8D, 0x8A },
	0xaff1, { 0xE8, 0x8C, 0xB8 },
	0xaff2, { 0xE8, 0x8D, 0x90 },
	0xaff3, { 0xE8, 0x8D, 0x89 },
	0xaff4, { 0xE8, 0x8C, 0xB5 },
	0xaff5, { 0xE8, 0x8C, 0xB4 },
	0xaff6, { 0xE8, 0x8D, 0x8F },
	0xaff7, { 0xE8, 0x8C, 0xB2 },
	0xaff8, { 0xE8, 0x8C, 0xB9 },
	0xaff9, { 0xE8, 0x8C, 0xB6 },
	0xaffa, { 0xE8, 0x8C, 0x97 },
	0xaffb, { 0xE8, 0x8D, 0x80 },
	0xaffc, { 0xE8, 0x8C, 0xB1 },
	0xaffd, { 0xE8, 0x8C, 0xA8 },
	0xaffe, { 0xE8, 0x8D, 0x83 },
	0xb040, { 0xE8, 0x99, 0x94 },
	0xb041, { 0xE8, 0x9A, 0x8A },
	0xb042, { 0xE8, 0x9A, 0xAA },
	0xb043, { 0xE8, 0x9A, 0x93 },
	0xb044, { 0xE8, 0x9A, 0xA4 },
	0xb045, { 0xE8, 0x9A, 0xA9 },
	0xb046, { 0xE8, 0x9A, 0x8C },
	0xb047, { 0xE8, 0x9A, 0xA3 },
	0xb048, { 0xE8, 0x9A, 0x9C },
	0xb049, { 0xE8, 0xA1, 0xB0 },
	0xb04a, { 0xE8, 0xA1, 0xB7 },
	0xb04b, { 0xE8, 0xA2, 0x81 },
	0xb04c, { 0xE8, 0xA2, 0x82 },
	0xb04d, { 0xE8, 0xA1, 0xBD },
	0xb04e, { 0xE8, 0xA1, 0xB9 },
	0xb04f, { 0xE8, 0xA8, 0x98 },
	0xb050, { 0xE8, 0xA8, 0x90 },
	0xb051, { 0xE8, 0xA8, 0x8E },
	0xb052, { 0xE8, 0xA8, 0x8C },
	0xb053, { 0xE8, 0xA8, 0x95 },
	0xb054, { 0xE8, 0xA8, 0x8A },
	0xb055, { 0xE8, 0xA8, 0x97 },
	0xb056, { 0xE8, 0xA8, 0x93 },
	0xb057, { 0xE8, 0xA8, 0x96 },
	0xb058, { 0xE8, 0xA8, 0x8F },
	0xb059, { 0xE8, 0xA8, 0x91 },
	0xb05a, { 0xE8, 0xB1, 0x88 },
	0xb05b, { 0xE8, 0xB1, 0xBA },
	0xb05c, { 0xE8, 0xB1, 0xB9 },
	0xb05d, { 0xE8, 0xB2, 0xA1 },
	0xb05e, { 0xE8, 0xB2, 0xA2 },
	0xb05f, { 0xE8, 0xB5, 0xB7 },
	0xb060, { 0xE8, 0xBA, 0xAC },
	0xb061, { 0xE8, 0xBB, 0x92 },
	0xb062, { 0xE8, 0xBB, 0x94 },
	0xb063, { 0xE8, 0xBB, 0x8F },
	0xb064, { 0xE8, 0xBE, 0xB1 },
	0xb065, { 0xE9, 0x80, 0x81 },
	0xb066, { 0xE9, 0x80, 0x86 },
	0xb067, { 0xE8, 0xBF, 0xB7 },
	0xb068, { 0xE9, 0x80, 0x80 },
	0xb069, { 0xE8, 0xBF, 0xBA },
	0xb06a, { 0xE8, 0xBF, 0xB4 },
	0xb06b, { 0xE9, 0x80, 0x83 },
	0xb06c, { 0xE8, 0xBF, 0xBD },
	0xb06d, { 0xE9, 0x80, 0x85 },
	0xb06e, { 0xE8, 0xBF, 0xB8 },
	0xb06f, { 0xE9, 0x82, 0x95 },
	0xb070, { 0xE9, 0x83, 0xA1 },
	0xb071, { 0xE9, 0x83, 0x9D },
	0xb072, { 0xE9, 0x83, 0xA2 },
	0xb073, { 0xE9, 0x85, 0x92 },
	0xb074, { 0xE9, 0x85, 0x8D },
	0xb075, { 0xE9, 0x85, 0x8C },
	0xb076, { 0xE9, 0x87, 0x98 },
	0xb077, { 0xE9, 0x87, 0x9D },
	0xb078, { 0xE9, 0x87, 0x97 },
	0xb079, { 0xE9, 0x87, 0x9C },
	0xb07a, { 0xE9, 0x87, 0x99 },
	0xb07b, { 0xE9, 0x96, 0x83 },
	0xb07c, { 0xE9, 0x99, 0xA2 },
	0xb07d, { 0xE9, 0x99, 0xA3 },
	0xb07e, { 0xE9, 0x99, 0xA1 },
	0xb0a1, { 0xE9, 0x99, 0x9B },
	0xb0a2, { 0xE9, 0x99, 0x9D },
	0xb0a3, { 0xE9, 0x99, 0xA4 },
	0xb0a4, { 0xE9, 0x99, 0x98 },
	0xb0a5, { 0xE9, 0x99, 0x9E },
	0xb0a6, { 0xE9, 0x9A, 0xBB },
	0xb0a7, { 0xE9, 0xA3, 0xA2 },
	0xb0a8, { 0xE9, 0xA6, 0xAC },
	0xb0a9, { 0xE9, 0xAA, 0xA8 },
	0xb0aa, { 0xE9, 0xAB, 0x98 },
	0xb0ab, { 0xE9, 0xAC, 0xA5 },
	0xb0ac, { 0xE9, 0xAC, 0xB2 },
	0xb0ad, { 0xE9, 0xAC, 0xBC },
	0xb0ae, { 0xE4, 0xB9, 0xBE },
	0xb0af, { 0xE5, 0x81, 0xBA },
	0xb0b0, { 0xE5, 0x81, 0xBD },
	0xb0b1, { 0xE5, 0x81, 0x9C },
	0xb0b2, { 0xE5, 0x81, 0x87 },
	0xb0b3, { 0xE5, 0x81, 0x83 },
	0xb0b4, { 0xE5, 0x81, 0x8C },
	0xb0b5, { 0xE5, 0x81, 0x9A },
	0xb0b6, { 0xE5, 0x81, 0x89 },
	0xb0b7, { 0xE5, 0x81, 0xA5 },
	0xb0b8, { 0xE5, 0x81, 0xB6 },
	0xb0b9, { 0xE5, 0x81, 0x8E },
	0xb0ba, { 0xE5, 0x81, 0x95 },
	0xb0bb, { 0xE5, 0x81, 0xB5 },
	0xb0bc, { 0xE5, 0x81, 0xB4 },
	0xb0bd, { 0xE5, 0x81, 0xB7 },
	0xb0be, { 0xE5, 0x81, 0x8F },
	0xb0bf, { 0xE5, 0x80, 0x8F },
	0xb0c0, { 0xE5, 0x81, 0xAF },
	0xb0c1, { 0xE5, 0x81, 0xAD },
	0xb0c2, { 0xE5, 0x85, 0x9C },
	0xb0c3, { 0xE5, 0x86, 0x95 },
	0xb0c4, { 0xE5, 0x87, 0xB0 },
	0xb0c5, { 0xE5, 0x89, 0xAA },
	0xb0c6, { 0xE5, 0x89, 0xAF },
	0xb0c7, { 0xE5, 0x8B, 0x92 },
	0xb0c8, { 0xE5, 0x8B, 0x99 },
	0xb0c9, { 0xE5, 0x8B, 0x98 },
	0xb0ca, { 0xE5, 0x8B, 0x95 },
	0xb0cb, { 0xE5, 0x8C, 0x90 },
	0xb0cc, { 0xE5, 0x8C, 0x8F },
	0xb0cd, { 0xE5, 0x8C, 0x99 },
	0xb0ce, { 0xE5, 0x8C, 0xBF },
	0xb0cf, { 0xE5, 0x8D, 0x80 },
	0xb0d0, { 0xE5, 0x8C, 0xBE },
	0xb0d1, { 0xE5, 0x8F, 0x83 },
	0xb0d2, { 0xE6, 0x9B, 0xBC },
	0xb0d3, { 0xE5, 0x95, 0x86 },
	0xb0d4, { 0xE5, 0x95, 0xAA },
	0xb0d5, { 0xE5, 0x95, 0xA6 },
	0xb0d6, { 0xE5, 0x95, 0x84 },
	0xb0d7, { 0xE5, 0x95, 0x9E },
	0xb0d8, { 0xE5, 0x95, 0xA1 },
	0xb0d9, { 0xE5, 0x95, 0x83 },
	0xb0da, { 0xE5, 0x95, 0x8A },
	0xb0db, { 0xE5, 0x94, 0xB1 },
	0xb0dc, { 0xE5, 0x95, 0x96 },
	0xb0dd, { 0xE5, 0x95, 0x8F },
	0xb0de, { 0xE5, 0x95, 0x95 },
	0xb0df, { 0xE5, 0x94, 0xAF },
	0xb0e0, { 0xE5, 0x95, 0xA4 },
	0xb0e1, { 0xE5, 0x94, 0xB8 },
	0xb0e2, { 0xE5, 0x94, 0xAE },
	0xb0e3, { 0xE5, 0x95, 0x9C },
	0xb0e4, { 0xE5, 0x94, 0xAC },
	0xb0e5, { 0xE5, 0x95, 0xA3 },
	0xb0e6, { 0xE5, 0x94, 0xB3 },
	0xb0e7, { 0xE5, 0x95, 0x81 },
	0xb0e8, { 0xE5, 0x95, 0x97 },
	0xb0e9, { 0xE5, 0x9C, 0x88 },
	0xb0ea, { 0xE5, 0x9C, 0x8B },
	0xb0eb, { 0xE5, 0x9C, 0x89 },
	0xb0ec, { 0xE5, 0x9F, 0x9F },
	0xb0ed, { 0xE5, 0xA0, 0x85 },
	0xb0ee, { 0xE5, 0xA0, 0x8A },
	0xb0ef, { 0xE5, 0xA0, 0x86 },
	0xb0f0, { 0xE5, 0x9F, 0xA0 },
	0xb0f1, { 0xE5, 0x9F, 0xA4 },
	0xb0f2, { 0xE5, 0x9F, 0xBA },
	0xb0f3, { 0xE5, 0xA0, 0x82 },
	0xb0f4, { 0xE5, 0xA0, 0xB5 },
	0xb0f5, { 0xE5, 0x9F, 0xB7 },
	0xb0f6, { 0xE5, 0x9F, 0xB9 },
	0xb0f7, { 0xE5, 0xA4, 0xA0 },
	0xb0f8, { 0xE5, 0xA5, 0xA2 },
	0xb0f9, { 0xE5, 0xA8, 0xB6 },
	0xb0fa, { 0xE5, 0xA9, 0x81 },
	0xb0fb, { 0xE5, 0xA9, 0x89 },
	0xb0fc, { 0xE5, 0xA9, 0xA6 },
	0xb0fd, { 0xE5, 0xA9, 0xAA },
	0xb0fe, { 0xE5, 0xA9, 0x80 },
	0xb140, { 0xE5, 0xA8, 0xBC },
	0xb141, { 0xE5, 0xA9, 0xA2 },
	0xb142, { 0xE5, 0xA9, 0x9A },
	0xb143, { 0xE5, 0xA9, 0x86 },
	0xb144, { 0xE5, 0xA9, 0x8A },
	0xb145, { 0xE5, 0xAD, 0xB0 },
	0xb146, { 0xE5, 0xAF, 0x87 },
	0xb147, { 0xE5, 0xAF, 0x85 },
	0xb148, { 0xE5, 0xAF, 0x84 },
	0xb149, { 0xE5, 0xAF, 0x82 },
	0xb14a, { 0xE5, 0xAE, 0xBF },
	0xb14b, { 0xE5, 0xAF, 0x86 },
	0xb14c, { 0xE5, 0xB0, 0x89 },
	0xb14d, { 0xE5, 0xB0, 0x88 },
	0xb14e, { 0xE5, 0xB0, 0x87 },
	0xb14f, { 0xE5, 0xB1, 0xA0 },
	0xb150, { 0xE5, 0xB1, 0x9C },
	0xb151, { 0xE5, 0xB1, 0x9D },
	0xb152, { 0xE5, 0xB4, 0x87 },
	0xb153, { 0xE5, 0xB4, 0x86 },
	0xb154, { 0xE5, 0xB4, 0x8E },
	0xb155, { 0xE5, 0xB4, 0x9B },
	0xb156, { 0xE5, 0xB4, 0x96 },
	0xb157, { 0xE5, 0xB4, 0xA2 },
	0xb158, { 0xE5, 0xB4, 0x91 },
	0xb159, { 0xE5, 0xB4, 0xA9 },
	0xb15a, { 0xE5, 0xB4, 0x94 },
	0xb15b, { 0xE5, 0xB4, 0x99 },
	0xb15c, { 0xE5, 0xB4, 0xA4 },
	0xb15d, { 0xE5, 0xB4, 0xA7 },
	0xb15e, { 0xE5, 0xB4, 0x97 },
	0xb15f, { 0xE5, 0xB7, 0xA2 },
	0xb160, { 0xE5, 0xB8, 0xB8 },
	0xb161, { 0xE5, 0xB8, 0xB6 },
	0xb162, { 0xE5, 0xB8, 0xB3 },
	0xb163, { 0xE5, 0xB8, 0xB7 },
	0xb164, { 0xE5, 0xBA, 0xB7 },
	0xb165, { 0xE5, 0xBA, 0xB8 },
	0xb166, { 0xE5, 0xBA, 0xB6 },
	0xb167, { 0xE5, 0xBA, 0xB5 },
	0xb168, { 0xE5, 0xBA, 0xBE },
	0xb169, { 0xE5, 0xBC, 0xB5 },
	0xb16a, { 0xE5, 0xBC, 0xB7 },
	0xb16b, { 0xE5, 0xBD, 0x97 },
	0xb16c, { 0xE5, 0xBD, 0xAC },
	0xb16d, { 0xE5, 0xBD, 0xA9 },
	0xb16e, { 0xE5, 0xBD, 0xAB },
	0xb16f, { 0xE5, 0xBE, 0x97 },
	0xb170, { 0xE5, 0xBE, 0x99 },
	0xb171, { 0xE5, 0xBE, 0x9E },
	0xb172, { 0xE5, 0xBE, 0x98 },
	0xb173, { 0xE5, 0xBE, 0xA1 },
	0xb174, { 0xE5, 0xBE, 0xA0 },
	0xb175, { 0xE5, 0xBE, 0x9C },
	0xb176, { 0xE6, 0x81, 0xBF },
	0xb177, { 0xE6, 0x82, 0xA3 },
	0xb178, { 0xE6, 0x82, 0x89 },
	0xb179, { 0xE6, 0x82, 0xA0 },
	0xb17a, { 0xE6, 0x82, 0xA8 },
	0xb17b, { 0xE6, 0x83, 0x8B },
	0xb17c, { 0xE6, 0x82, 0xB4 },
	0xb17d, { 0xE6, 0x83, 0xA6 },
	0xb17e, { 0xE6, 0x82, 0xBD },
	0xb1a1, { 0xE6, 0x83, 0x85 },
	0xb1a2, { 0xE6, 0x82, 0xBB },
	0xb1a3, { 0xE6, 0x82, 0xB5 },
	0xb1a4, { 0xE6, 0x83, 0x9C },
	0xb1a5, { 0xE6, 0x82, 0xBC },
	0xb1a6, { 0xE6, 0x83, 0x98 },
	0xb1a7, { 0xE6, 0x83, 0x95 },
	0xb1a8, { 0xE6, 0x83, 0x86 },
	0xb1a9, { 0xE6, 0x83, 0x9F },
	0xb1aa, { 0xE6, 0x82, 0xB8 },
	0xb1ab, { 0xE6, 0x83, 0x9A },
	0xb1ac, { 0xE6, 0x83, 0x87 },
	0xb1ad, { 0xE6, 0x88, 0x9A },
	0xb1ae, { 0xE6, 0x88, 0x9B },
	0xb1af, { 0xE6, 0x89, 0x88 },
	0xb1b0, { 0xE6, 0x8E, 0xA0 },
	0xb1b1, { 0xE6, 0x8E, 0xA7 },
	0xb1b2, { 0xE6, 0x8D, 0xB2 },
	0xb1b3, { 0xE6, 0x8E, 0x96 },
	0xb1b4, { 0xE6, 0x8E, 0xA2 },
	0xb1b5, { 0xE6, 0x8E, 0xA5 },
	0xb1b6, { 0xE6, 0x8D, 0xB7 },
	0xb1b7, { 0xE6, 0x8D, 0xA7 },
	0xb1b8, { 0xE6, 0x8E, 0x98 },
	0xb1b9, { 0xE6, 0x8E, 0xAA },
	0xb1ba, { 0xE6, 0x8D, 0xB1 },
	0xb1bb, { 0xE6, 0x8E, 0xA9 },
	0xb1bc, { 0xE6, 0x8E, 0x89 },
	0xb1bd, { 0xE6, 0x8E, 0x83 },
	0xb1be, { 0xE6, 0x8E, 0x9B },
	0xb1bf, { 0xE6, 0x8D, 0xAB },
	0xb1c0, { 0xE6, 0x8E, 0xA8 },
	0xb1c1, { 0xE6, 0x8E, 0x84 },
	0xb1c2, { 0xE6, 0x8E, 0x88 },
	0xb1c3, { 0xE6, 0x8E, 0x99 },
	0xb1c4, { 0xE6, 0x8E, 0xA1 },
	0xb1c5, { 0xE6, 0x8E, 0xAC },
	0xb1c6, { 0xE6, 0x8E, 0x92 },
	0xb1c7, { 0xE6, 0x8E, 0x8F },
	0xb1c8, { 0xE6, 0x8E, 0x80 },
	0xb1c9, { 0xE6, 0x8D, 0xBB },
	0xb1ca, { 0xE6, 0x8D, 0xA9 },
	0xb1cb, { 0xE6, 0x8D, 0xA8 },
	0xb1cc, { 0xE6, 0x8D, 0xBA },
	0xb1cd, { 0xE6, 0x95, 0x9D },
	0xb1ce, { 0xE6, 0x95, 0x96 },
	0xb1cf, { 0xE6, 0x95, 0x91 },
	0xb1d0, { 0xE6, 0x95, 0x99 },
	0xb1d1, { 0xE6, 0x95, 0x97 },
	0xb1d2, { 0xE5, 0x95, 0x9F },
	0xb1d3, { 0xE6, 0x95, 0x8F },
	0xb1d4, { 0xE6, 0x95, 0x98 },
	0xb1d5, { 0xE6, 0x95, 0x95 },
	0xb1d6, { 0xE6, 0x95, 0x94 },
	0xb1d7, { 0xE6, 0x96, 0x9C },
	0xb1d8, { 0xE6, 0x96, 0x9B },
	0xb1d9, { 0xE6, 0x96, 0xAC },
	0xb1da, { 0xE6, 0x97, 0x8F },
	0xb1db, { 0xE6, 0x97, 0x8B },
	0xb1dc, { 0xE6, 0x97, 0x8C },
	0xb1dd, { 0xE6, 0x97, 0x8E },
	0xb1de, { 0xE6, 0x99, 0x9D },
	0xb1df, { 0xE6, 0x99, 0x9A },
	0xb1e0, { 0xE6, 0x99, 0xA4 },
	0xb1e1, { 0xE6, 0x99, 0xA8 },
	0xb1e2, { 0xE6, 0x99, 0xA6 },
	0xb1e3, { 0xE6, 0x99, 0x9E },
	0xb1e4, { 0xE6, 0x9B, 0xB9 },
	0xb1e5, { 0xE5, 0x8B, 0x97 },
	0xb1e6, { 0xE6, 0x9C, 0x9B },
	0xb1e7, { 0xE6, 0xA2, 0x81 },
	0xb1e8, { 0xE6, 0xA2, 0xAF },
	0xb1e9, { 0xE6, 0xA2, 0xA2 },
	0xb1ea, { 0xE6, 0xA2, 0x93 },
	0xb1eb, { 0xE6, 0xA2, 0xB5 },
	0xb1ec, { 0xE6, 0xA1, 0xBF },
	0xb1ed, { 0xE6, 0xA1, 0xB6 },
	0xb1ee, { 0xE6, 0xA2, 0xB1 },
	0xb1ef, { 0xE6, 0xA2, 0xA7 },
	0xb1f0, { 0xE6, 0xA2, 0x97 },
	0xb1f1, { 0xE6, 0xA2, 0xB0 },
	0xb1f2, { 0xE6, 0xA2, 0x83 },
	0xb1f3, { 0xE6, 0xA3, 0x84 },
	0xb1f4, { 0xE6, 0xA2, 0xAD },
	0xb1f5, { 0xE6, 0xA2, 0x86 },
	0xb1f6, { 0xE6, 0xA2, 0x85 },
	0xb1f7, { 0xE6, 0xA2, 0x94 },
	0xb1f8, { 0xE6, 0xA2, 0x9D },
	0xb1f9, { 0xE6, 0xA2, 0xA8 },
	0xb1fa, { 0xE6, 0xA2, 0x9F },
	0xb1fb, { 0xE6, 0xA2, 0xA1 },
	0xb1fc, { 0xE6, 0xA2, 0x82 },
	0xb1fd, { 0xE6, 0xAC, 0xB2 },
	0xb1fe, { 0xE6, 0xAE, 0xBA },
	0xb240, { 0xE6, 0xAF, 0xAB },
	0xb241, { 0xE6, 0xAF, 0xAC },
	0xb242, { 0xE6, 0xB0, 0xAB },
	0xb243, { 0xE6, 0xB6, 0x8E },
	0xb244, { 0xE6, 0xB6, 0xBC },
	0xb245, { 0xE6, 0xB7, 0xB3 },
	0xb246, { 0xE6, 0xB7, 0x99 },
	0xb247, { 0xE6, 0xB6, 0xB2 },
	0xb248, { 0xE6, 0xB7, 0xA1 },
	0xb249, { 0xE6, 0xB7, 0x8C },
	0xb24a, { 0xE6, 0xB7, 0xA4 },
	0xb24b, { 0xE6, 0xB7, 0xBB },
	0xb24c, { 0xE6, 0xB7, 0xBA },
	0xb24d, { 0xE6, 0xB8, 0x85 },
	0xb24e, { 0xE6, 0xB7, 0x87 },
	0xb24f, { 0xE6, 0xB7, 0x8B },
	0xb250, { 0xE6, 0xB6, 0xAF },
	0xb251, { 0xE6, 0xB7, 0x91 },
	0xb252, { 0xE6, 0xB6, 0xAE },
	0xb253, { 0xE6, 0xB7, 0x9E },
	0xb254, { 0xE6, 0xB7, 0xB9 },
	0xb255, { 0xE6, 0xB6, 0xB8 },
	0xb256, { 0xE6, 0xB7, 0xB7 },
	0xb257, { 0xE6, 0xB7, 0xB5 },
	0xb258, { 0xE6, 0xB7, 0x85 },
	0xb259, { 0xE6, 0xB7, 0x92 },
	0xb25a, { 0xE6, 0xB8, 0x9A },
	0xb25b, { 0xE6, 0xB6, 0xB5 },
	0xb25c, { 0xE6, 0xB7, 0x9A },
	0xb25d, { 0xE6, 0xB7, 0xAB },
	0xb25e, { 0xE6, 0xB7, 0x98 },
	0xb25f, { 0xE6, 0xB7, 0xAA },
	0xb260, { 0xE6, 0xB7, 0xB1 },
	0xb261, { 0xE6, 0xB7, 0xAE },
	0xb262, { 0xE6, 0xB7, 0xA8 },
	0xb263, { 0xE6, 0xB7, 0x86 },
	0xb264, { 0xE6, 0xB7, 0x84 },
	0xb265, { 0xE6, 0xB6, 0xAA },
	0xb266, { 0xE6, 0xB7, 0xAC },
	0xb267, { 0xE6, 0xB6, 0xBF },
	0xb268, { 0xE6, 0xB7, 0xA6 },
	0xb269, { 0xE7, 0x83, 0xB9 },
	0xb26a, { 0xE7, 0x84, 0x89 },
	0xb26b, { 0xE7, 0x84, 0x8A },
	0xb26c, { 0xE7, 0x83, 0xBD },
	0xb26d, { 0xE7, 0x83, 0xAF },
	0xb26e, { 0xE7, 0x88, 0xBD },
	0xb26f, { 0xE7, 0x89, 0xBD },
	0xb270, { 0xE7, 0x8A, 0x81 },
	0xb271, { 0xE7, 0x8C, 0x9C },
	0xb272, { 0xE7, 0x8C, 0x9B },
	0xb273, { 0xE7, 0x8C, 0x96 },
	0xb274, { 0xE7, 0x8C, 0x93 },
	0xb275, { 0xE7, 0x8C, 0x99 },
	0xb276, { 0xE7, 0x8E, 0x87 },
	0xb277, { 0xE7, 0x90, 0x85 },
	0xb278, { 0xE7, 0x90, 0x8A },
	0xb279, { 0xE7, 0x90, 0x83 },
	0xb27a, { 0xE7, 0x90, 0x86 },
	0xb27b, { 0xE7, 0x8F, 0xBE },
	0xb27c, { 0xE7, 0x90, 0x8D },
	0xb27d, { 0xE7, 0x93, 0xA0 },
	0xb27e, { 0xE7, 0x93, 0xB6 },
	0xb2a1, { 0xE7, 0x93, 0xB7 },
	0xb2a2, { 0xE7, 0x94, 0x9C },
	0xb2a3, { 0xE7, 0x94, 0xA2 },
	0xb2a4, { 0xE7, 0x95, 0xA5 },
	0xb2a5, { 0xE7, 0x95, 0xA6 },
	0xb2a6, { 0xE7, 0x95, 0xA2 },
	0xb2a7, { 0xE7, 0x95, 0xB0 },
	0xb2a8, { 0xE7, 0x96, 0x8F },
	0xb2a9, { 0xE7, 0x97, 0x94 },
	0xb2aa, { 0xE7, 0x97, 0x95 },
	0xb2ab, { 0xE7, 0x96, 0xB5 },
	0xb2ac, { 0xE7, 0x97, 0x8A },
	0xb2ad, { 0xE7, 0x97, 0x8D },
	0xb2ae, { 0xE7, 0x9A, 0x8E },
	0xb2af, { 0xE7, 0x9B, 0x94 },
	0xb2b0, { 0xE7, 0x9B, 0x92 },
	0xb2b1, { 0xE7, 0x9B, 0x9B },
	0xb2b2, { 0xE7, 0x9C, 0xB7 },
	0xb2b3, { 0xE7, 0x9C, 0xBE },
	0xb2b4, { 0xE7, 0x9C, 0xBC },
	0xb2b5, { 0xE7, 0x9C, 0xB6 },
	0xb2b6, { 0xE7, 0x9C, 0xB8 },
	0xb2b7, { 0xE7, 0x9C, 0xBA },
	0xb2b8, { 0xE7, 0xA1, 0xAB },
	0xb2b9, { 0xE7, 0xA1, 0x83 },
	0xb2ba, { 0xE7, 0xA1, 0x8E },
	0xb2bb, { 0xE7, 0xA5, 0xA5 },
	0xb2bc, { 0xE7, 0xA5, 0xA8 },
	0xb2bd, { 0xE7, 0xA5, 0xAD },
	0xb2be, { 0xE7, 0xA7, 0xBB },
	0xb2bf, { 0xE7, 0xAA, 0x92 },
	0xb2c0, { 0xE7, 0xAA, 0x95 },
	0xb2c1, { 0xE7, 0xAC, 0xA0 },
	0xb2c2, { 0xE7, 0xAC, 0xA8 },
	0xb2c3, { 0xE7, 0xAC, 0x9B },
	0xb2c4, { 0xE7, 0xAC, 0xAC },
	0xb2c5, { 0xE7, 0xAC, 0xA6 },
	0xb2c6, { 0xE7, 0xAC, 0x99 },
	0xb2c7, { 0xE7, 0xAC, 0x9E },
	0xb2c8, { 0xE7, 0xAC, 0xAE },
	0xb2c9, { 0xE7, 0xB2, 0x92 },
	0xb2ca, { 0xE7, 0xB2, 0x97 },
	0xb2cb, { 0xE7, 0xB2, 0x95 },
	0xb2cc, { 0xE7, 0xB5, 0x86 },
	0xb2cd, { 0xE7, 0xB5, 0x83 },
	0xb2ce, { 0xE7, 0xB5, 0xB1 },
	0xb2cf, { 0xE7, 0xB4, 0xAE },
	0xb2d0, { 0xE7, 0xB4, 0xB9 },
	0xb2d1, { 0xE7, 0xB4, 0xBC },
	0xb2d2, { 0xE7, 0xB5, 0x80 },
	0xb2d3, { 0xE7, 0xB4, 0xB0 },
	0xb2d4, { 0xE7, 0xB4, 0xB3 },
	0xb2d5, { 0xE7, 0xB5, 0x84 },
	0xb2d6, { 0xE7, 0xB4, 0xAF },
	0xb2d7, { 0xE7, 0xB5, 0x82 },
	0xb2d8, { 0xE7, 0xB4, 0xB2 },
	0xb2d9, { 0xE7, 0xB4, 0xB1 },
	0xb2da, { 0xE7, 0xBC, 0xBD },
	0xb2db, { 0xE7, 0xBE, 0x9E },
	0xb2dc, { 0xE7, 0xBE, 0x9A },
	0xb2dd, { 0xE7, 0xBF, 0x8C },
	0xb2de, { 0xE7, 0xBF, 0x8E },
	0xb2df, { 0xE7, 0xBF, 0x92 },
	0xb2e0, { 0xE8, 0x80, 0x9C },
	0xb2e1, { 0xE8, 0x81, 0x8A },
	0xb2e2, { 0xE8, 0x81, 0x86 },
	0xb2e3, { 0xE8, 0x84, 0xAF },
	0xb2e4, { 0xE8, 0x84, 0x96 },
	0xb2e5, { 0xE8, 0x84, 0xA3 },
	0xb2e6, { 0xE8, 0x84, 0xAB },
	0xb2e7, { 0xE8, 0x84, 0xA9 },
	0xb2e8, { 0xE8, 0x84, 0xB0 },
	0xb2e9, { 0xE8, 0x84, 0xA4 },
	0xb2ea, { 0xE8, 0x88, 0x82 },
	0xb2eb, { 0xE8, 0x88, 0xB5 },
	0xb2ec, { 0xE8, 0x88, 0xB7 },
	0xb2ed, { 0xE8, 0x88, 0xB6 },
	0xb2ee, { 0xE8, 0x88, 0xB9 },
	0xb2ef, { 0xE8, 0x8E, 0x8E },
	0xb2f0, { 0xE8, 0x8E, 0x9E },
	0xb2f1, { 0xE8, 0x8E, 0x98 },
	0xb2f2, { 0xE8, 0x8D, 0xB8 },
	0xb2f3, { 0xE8, 0x8E, 0xA2 },
	0xb2f4, { 0xE8, 0x8E, 0x96 },
	0xb2f5, { 0xE8, 0x8E, 0xBD },
	0xb2f6, { 0xE8, 0x8E, 0xAB },
	0xb2f7, { 0xE8, 0x8E, 0x92 },
	0xb2f8, { 0xE8, 0x8E, 0x8A },
	0xb2f9, { 0xE8, 0x8E, 0x93 },
	0xb2fa, { 0xE8, 0x8E, 0x89 },
	0xb2fb, { 0xE8, 0x8E, 0xA0 },
	0xb2fc, { 0xE8, 0x8D, 0xB7 },
	0xb2fd, { 0xE8, 0x8D, 0xBB },
	0xb2fe, { 0xE8, 0x8D, 0xBC },
	0xb340, { 0xE8, 0x8E, 0x86 },
	0xb341, { 0xE8, 0x8E, 0xA7 },
	0xb342, { 0xE8, 0x99, 0x95 },
	0xb343, { 0xE5, 0xBD, 0xAA },
	0xb344, { 0xE8, 0x9B, 0x87 },
	0xb345, { 0xE8, 0x9B, 0x80 },
	0xb346, { 0xE8, 0x9A, 0xB6 },
	0xb347, { 0xE8, 0x9B, 0x84 },
	0xb348, { 0xE8, 0x9A, 0xB5 },
	0xb349, { 0xE8, 0x9B, 0x86 },
	0xb34a, { 0xE8, 0x9B, 0x8B },
	0xb34b, { 0xE8, 0x9A, 0xB1 },
	0xb34c, { 0xE8, 0x9A, 0xAF },
	0xb34d, { 0xE8, 0x9B, 0x89 },
	0xb34e, { 0xE8, 0xA1, 0x93 },
	0xb34f, { 0xE8, 0xA2, 0x9E },
	0xb350, { 0xE8, 0xA2, 0x88 },
	0xb351, { 0xE8, 0xA2, 0xAB },
	0xb352, { 0xE8, 0xA2, 0x92 },
	0xb353, { 0xE8, 0xA2, 0x96 },
	0xb354, { 0xE8, 0xA2, 0x8D },
	0xb355, { 0xE8, 0xA2, 0x8B },
	0xb356, { 0xE8, 0xA6, 0x93 },
	0xb357, { 0xE8, 0xA6, 0x8F },
	0xb358, { 0xE8, 0xA8, 0xAA },
	0xb359, { 0xE8, 0xA8, 0x9D },
	0xb35a, { 0xE8, 0xA8, 0xA3 },
	0xb35b, { 0xE8, 0xA8, 0xA5 },
	0xb35c, { 0xE8, 0xA8, 0xB1 },
	0xb35d, { 0xE8, 0xA8, 0xAD },
	0xb35e, { 0xE8, 0xA8, 0x9F },
	0xb35f, { 0xE8, 0xA8, 0x9B },
	0xb360, { 0xE8, 0xA8, 0xA2 },
	0xb361, { 0xE8, 0xB1, 0x89 },
	0xb362, { 0xE8, 0xB1, 0x9A },
	0xb363, { 0xE8, 0xB2, 0xA9 },
	0xb364, { 0xE8, 0xB2, 0xAC },
	0xb365, { 0xE8, 0xB2, 0xAB },
	0xb366, { 0xE8, 0xB2, 0xA8 },
	0xb367, { 0xE8, 0xB2, 0xAA },
	0xb368, { 0xE8, 0xB2, 0xA7 },
	0xb369, { 0xE8, 0xB5, 0xA7 },
	0xb36a, { 0xE8, 0xB5, 0xA6 },
	0xb36b, { 0xE8, 0xB6, 0xBE },
	0xb36c, { 0xE8, 0xB6, 0xBA },
	0xb36d, { 0xE8, 0xBB, 0x9B },
	0xb36e, { 0xE8, 0xBB, 0x9F },
	0xb36f, { 0xE9, 0x80, 0x99 },
	0xb370, { 0xE9, 0x80, 0x8D },
	0xb371, { 0xE9, 0x80, 0x9A },
	0xb372, { 0xE9, 0x80, 0x97 },
	0xb373, { 0xE9, 0x80, 0xA3 },
	0xb374, { 0xE9, 0x80, 0x9F },
	0xb375, { 0xE9, 0x80, 0x9D },
	0xb376, { 0xE9, 0x80, 0x90 },
	0xb377, { 0xE9, 0x80, 0x95 },
	0xb378, { 0xE9, 0x80, 0x9E },
	0xb379, { 0xE9, 0x80, 0xA0 },
	0xb37a, { 0xE9, 0x80, 0x8F },
	0xb37b, { 0xE9, 0x80, 0xA2 },
	0xb37c, { 0xE9, 0x80, 0x96 },
	0xb37d, { 0xE9, 0x80, 0x9B },
	0xb37e, { 0xE9, 0x80, 0x94 },
	0xb3a1, { 0xE9, 0x83, 0xA8 },
	0xb3a2, { 0xE9, 0x83, 0xAD },
	0xb3a3, { 0xE9, 0x83, 0xBD },
	0xb3a4, { 0xE9, 0x85, 0x97 },
	0xb3a5, { 0xE9, 0x87, 0x8E },
	0xb3a6, { 0xE9, 0x87, 0xB5 },
	0xb3a7, { 0xE9, 0x87, 0xA6 },
	0xb3a8, { 0xE9, 0x87, 0xA3 },
	0xb3a9, { 0xE9, 0x87, 0xA7 },
	0xb3aa, { 0xE9, 0x87, 0xAD },
	0xb3ab, { 0xE9, 0x87, 0xA9 },
	0xb3ac, { 0xE9, 0x96, 0x89 },
	0xb3ad, { 0xE9, 0x99, 0xAA },
	0xb3ae, { 0xE9, 0x99, 0xB5 },
	0xb3af, { 0xE9, 0x99, 0xB3 },
	0xb3b0, { 0xE9, 0x99, 0xB8 },
	0xb3b1, { 0xE9, 0x99, 0xB0 },
	0xb3b2, { 0xE9, 0x99, 0xB4 },
	0xb3b3, { 0xE9, 0x99, 0xB6 },
	0xb3b4, { 0xE9, 0x99, 0xB7 },
	0xb3b5, { 0xE9, 0x99, 0xAC },
	0xb3b6, { 0xE9, 0x9B, 0x80 },
	0xb3b7, { 0xE9, 0x9B, 0xAA },
	0xb3b8, { 0xE9, 0x9B, 0xA9 },
	0xb3b9, { 0xE7, 0xAB, 0xA0 },
	0xb3ba, { 0xE7, 0xAB, 0x9F },
	0xb3bb, { 0xE9, 0xA0, 0x82 },
	0xb3bc, { 0xE9, 0xA0, 0x83 },
	0xb3bd, { 0xE9, 0xAD, 0x9A },
	0xb3be, { 0xE9, 0xB3, 0xA5 },
	0xb3bf, { 0xE9, 0xB9, 0xB5 },
	0xb3c0, { 0xE9, 0xB9, 0xBF },
	0xb3c1, { 0xE9, 0xBA, 0xA5 },
	0xb3c2, { 0xE9, 0xBA, 0xBB },
	0xb3c3, { 0xE5, 0x82, 0xA2 },
	0xb3c4, { 0xE5, 0x82, 0x8D },
	0xb3c5, { 0xE5, 0x82, 0x85 },
	0xb3c6, { 0xE5, 0x82, 0x99 },
	0xb3c7, { 0xE5, 0x82, 0x91 },
	0xb3c8, { 0xE5, 0x82, 0x80 },
	0xb3c9, { 0xE5, 0x82, 0x96 },
	0xb3ca, { 0xE5, 0x82, 0x98 },
	0xb3cb, { 0xE5, 0x82, 0x9A },
	0xb3cc, { 0xE6, 0x9C, 0x80 },
	0xb3cd, { 0xE5, 0x87, 0xB1 },
	0xb3ce, { 0xE5, 0x89, 0xB2 },
	0xb3cf, { 0xE5, 0x89, 0xB4 },
	0xb3d0, { 0xE5, 0x89, 0xB5 },
	0xb3d1, { 0xE5, 0x89, 0xA9 },
	0xb3d2, { 0xE5, 0x8B, 0x9E },
	0xb3d3, { 0xE5, 0x8B, 0x9D },
	0xb3d4, { 0xE5, 0x8B, 0x9B },
	0xb3d5, { 0xE5, 0x8D, 0x9A },
	0xb3d6, { 0xE5, 0x8E, 0xA5 },
	0xb3d7, { 0xE5, 0x95, 0xBB },
	0xb3d8, { 0xE5, 0x96, 0x80 },
	0xb3d9, { 0xE5, 0x96, 0xA7 },
	0xb3da, { 0xE5, 0x95, 0xBC },
	0xb3db, { 0xE5, 0x96, 0x8A },
	0xb3dc, { 0xE5, 0x96, 0x9D },
	0xb3dd, { 0xE5, 0x96, 0x98 },
	0xb3de, { 0xE5, 0x96, 0x82 },
	0xb3df, { 0xE5, 0x96, 0x9C },
	0xb3e0, { 0xE5, 0x96, 0xAA },
	0xb3e1, { 0xE5, 0x96, 0x94 },
	0xb3e2, { 0xE5, 0x96, 0x87 },
	0xb3e3, { 0xE5, 0x96, 0x8B },
	0xb3e4, { 0xE5, 0x96, 0x83 },
	0xb3e5, { 0xE5, 0x96, 0xB3 },
	0xb3e6, { 0xE5, 0x96, 0xAE },
	0xb3e7, { 0xE5, 0x96, 0x9F },
	0xb3e8, { 0xE5, 0x94, 0xBE },
	0xb3e9, { 0xE5, 0x96, 0xB2 },
	0xb3ea, { 0xE5, 0x96, 0x9A },
	0xb3eb, { 0xE5, 0x96, 0xBB },
	0xb3ec, { 0xE5, 0x96, 0xAC },
	0xb3ed, { 0xE5, 0x96, 0xB1 },
	0xb3ee, { 0xE5, 0x95, 0xBE },
	0xb3ef, { 0xE5, 0x96, 0x89 },
	0xb3f0, { 0xE5, 0x96, 0xAB },
	0xb3f1, { 0xE5, 0x96, 0x99 },
	0xb3f2, { 0xE5, 0x9C, 0x8D },
	0xb3f3, { 0xE5, 0xA0, 0xAF },
	0xb3f4, { 0xE5, 0xA0, 0xAA },
	0xb3f5, { 0xE5, 0xA0, 0xB4 },
	0xb3f6, { 0xE5, 0xA0, 0xA4 },
	0xb3f7, { 0xE5, 0xA0, 0xB0 },
	0xb3f8, { 0xE5, 0xA0, 0xB1 },
	0xb3f9, { 0xE5, 0xA0, 0xA1 },
	0xb3fa, { 0xE5, 0xA0, 0x9D },
	0xb3fb, { 0xE5, 0xA0, 0xA0 },
	0xb3fc, { 0xE5, 0xA3, 0xB9 },
	0xb3fd, { 0xE5, 0xA3, 0xBA },
	0xb3fe, { 0xE5, 0xA5, 0xA0 },
	0xb440, { 0xE5, 0xA9, 0xB7 },
	0xb441, { 0xE5, 0xAA, 0x9A },
	0xb442, { 0xE5, 0xA9, 0xBF },
	0xb443, { 0xE5, 0xAA, 0x92 },
	0xb444, { 0xE5, 0xAA, 0x9B },
	0xb445, { 0xE5, 0xAA, 0xA7 },
	0xb446, { 0xE5, 0xAD, 0xB3 },
	0xb447, { 0xE5, 0xAD, 0xB1 },
	0xb448, { 0xE5, 0xAF, 0x92 },
	0xb449, { 0xE5, 0xAF, 0x8C },
	0xb44a, { 0xE5, 0xAF, 0x93 },
	0xb44b, { 0xE5, 0xAF, 0x90 },
	0xb44c, { 0xE5, 0xB0, 0x8A },
	0xb44d, { 0xE5, 0xB0, 0x8B },
	0xb44e, { 0xE5, 0xB0, 0xB1 },
	0xb44f, { 0xE5, 0xB5, 0x8C },
	0xb450, { 0xE5, 0xB5, 0x90 },
	0xb451, { 0xE5, 0xB4, 0xB4 },
	0xb452, { 0xE5, 0xB5, 0x87 },
	0xb453, { 0xE5, 0xB7, 0xBD },
	0xb454, { 0xE5, 0xB9, 0x85 },
	0xb455, { 0xE5, 0xB8, 0xBD },
	0xb456, { 0xE5, 0xB9, 0x80 },
	0xb457, { 0xE5, 0xB9, 0x83 },
	0xb458, { 0xE5, 0xB9, 0xBE },
	0xb459, { 0xE5, 0xBB, 0x8A },
	0xb45a, { 0xE5, 0xBB, 0x81 },
	0xb45b, { 0xE5, 0xBB, 0x82 },
	0xb45c, { 0xE5, 0xBB, 0x84 },
	0xb45d, { 0xE5, 0xBC, 0xBC },
	0xb45e, { 0xE5, 0xBD, 0xAD },
	0xb45f, { 0xE5, 0xBE, 0xA9 },
	0xb460, { 0xE5, 0xBE, 0xAA },
	0xb461, { 0xE5, 0xBE, 0xA8 },
	0xb462, { 0xE6, 0x83, 0x91 },
	0xb463, { 0xE6, 0x83, 0xA1 },
	0xb464, { 0xE6, 0x82, 0xB2 },
	0xb465, { 0xE6, 0x82, 0xB6 },
	0xb466, { 0xE6, 0x83, 0xA0 },
	0xb467, { 0xE6, 0x84, 0x9C },
	0xb468, { 0xE6, 0x84, 0xA3 },
	0xb469, { 0xE6, 0x83, 0xBA },
	0xb46a, { 0xE6, 0x84, 0x95 },
	0xb46b, { 0xE6, 0x83, 0xB0 },
	0xb46c, { 0xE6, 0x83, 0xBB },
	0xb46d, { 0xE6, 0x83, 0xB4 },
	0xb46e, { 0xE6, 0x85, 0xA8 },
	0xb46f, { 0xE6, 0x83, 0xB1 },
	0xb470, { 0xE6, 0x84, 0x8E },
	0xb471, { 0xE6, 0x83, 0xB6 },
	0xb472, { 0xE6, 0x84, 0x89 },
	0xb473, { 0xE6, 0x84, 0x80 },
	0xb474, { 0xE6, 0x84, 0x92 },
	0xb475, { 0xE6, 0x88, 0x9F },
	0xb476, { 0xE6, 0x89, 0x89 },
	0xb477, { 0xE6, 0x8E, 0xA3 },
	0xb478, { 0xE6, 0x8E, 0x8C },
	0xb479, { 0xE6, 0x8F, 0x8F },
	0xb47a, { 0xE6, 0x8F, 0x80 },
	0xb47b, { 0xE6, 0x8F, 0xA9 },
	0xb47c, { 0xE6, 0x8F, 0x89 },
	0xb47d, { 0xE6, 0x8F, 0x86 },
	0xb47e, { 0xE6, 0x8F, 0x8D },
	0xb4a1, { 0xE6, 0x8F, 0x92 },
	0xb4a2, { 0xE6, 0x8F, 0xA3 },
	0xb4a3, { 0xE6, 0x8F, 0x90 },
	0xb4a4, { 0xE6, 0x8F, 0xA1 },
	0xb4a5, { 0xE6, 0x8F, 0x96 },
	0xb4a6, { 0xE6, 0x8F, 0xAD },
	0xb4a7, { 0xE6, 0x8F, 0xAE },
	0xb4a8, { 0xE6, 0x8D, 0xB6 },
	0xb4a9, { 0xE6, 0x8F, 0xB4 },
	0xb4aa, { 0xE6, 0x8F, 0xAA },
	0xb4ab, { 0xE6, 0x8F, 0x9B },
	0xb4ac, { 0xE6, 0x91, 0x92 },
	0xb4ad, { 0xE6, 0x8F, 0x9A },
	0xb4ae, { 0xE6, 0x8F, 0xB9 },
	0xb4af, { 0xE6, 0x95, 0x9E },
	0xb4b0, { 0xE6, 0x95, 0xA6 },
	0xb4b1, { 0xE6, 0x95, 0xA2 },
	0xb4b2, { 0xE6, 0x95, 0xA3 },
	0xb4b3, { 0xE6, 0x96, 0x91 },
	0xb4b4, { 0xE6, 0x96, 0x90 },
	0xb4b5, { 0xE6, 0x96, 0xAF },
	0xb4b6, { 0xE6, 0x99, 0xAE },
	0xb4b7, { 0xE6, 0x99, 0xB0 },
	0xb4b8, { 0xE6, 0x99, 0xB4 },
	0xb4b9, { 0xE6, 0x99, 0xB6 },
	0xb4ba, { 0xE6, 0x99, 0xAF },
	0xb4bb, { 0xE6, 0x9A, 0x91 },
	0xb4bc, { 0xE6, 0x99, 0xBA },
	0xb4bd, { 0xE6, 0x99, 0xBE },
	0xb4be, { 0xE6, 0x99, 0xB7 },
	0xb4bf, { 0xE6, 0x9B, 0xBE },
	0xb4c0, { 0xE6, 0x9B, 0xBF },
	0xb4c1, { 0xE6, 0x9C, 0x9F },
	0xb4c2, { 0xE6, 0x9C, 0x9D },
	0xb4c3, { 0xE6, 0xA3, 0xBA },
	0xb4c4, { 0xE6, 0xA3, 0x95 },
	0xb4c5, { 0xE6, 0xA3, 0xA0 },
	0xb4c6, { 0xE6, 0xA3, 0x98 },
	0xb4c7, { 0xE6, 0xA3, 0x97 },
	0xb4c8, { 0xE6, 0xA4, 0x85 },
	0xb4c9, { 0xE6, 0xA3, 0x9F },
	0xb4ca, { 0xE6, 0xA3, 0xB5 },
	0xb4cb, { 0xE6, 0xA3, 0xAE },
	0xb4cc, { 0xE6, 0xA3, 0xA7 },
	0xb4cd, { 0xE6, 0xA3, 0xB9 },
	0xb4ce, { 0xE6, 0xA3, 0x92 },
	0xb4cf, { 0xE6, 0xA3, 0xB2 },
	0xb4d0, { 0xE6, 0xA3, 0xA3 },
	0xb4d1, { 0xE6, 0xA3, 0x8B },
	0xb4d2, { 0xE6, 0xA3, 0x8D },
	0xb4d3, { 0xE6, 0xA4, 0x8D },
	0xb4d4, { 0xE6, 0xA4, 0x92 },
	0xb4d5, { 0xE6, 0xA4, 0x8E },
	0xb4d6, { 0xE6, 0xA3, 0x89 },
	0xb4d7, { 0xE6, 0xA3, 0x9A },
	0xb4d8, { 0xE6, 0xA5, 0xAE },
	0xb4d9, { 0xE6, 0xA3, 0xBB },
	0xb4da, { 0xE6, 0xAC, 0xBE },
	0xb4db, { 0xE6, 0xAC, 0xBA },
	0xb4dc, { 0xE6, 0xAC, 0xBD },
	0xb4dd, { 0xE6, 0xAE, 0x98 },
	0xb4de, { 0xE6, 0xAE, 0x96 },
	0xb4df, { 0xE6, 0xAE, 0xBC },
	0xb4e0, { 0xE6, 0xAF, 0xAF },
	0xb4e1, { 0xE6, 0xB0, 0xAE },
	0xb4e2, { 0xE6, 0xB0, 0xAF },
	0xb4e3, { 0xE6, 0xB0, 0xAC },
	0xb4e4, { 0xE6, 0xB8, 0xAF },
	0xb4e5, { 0xE6, 0xB8, 0xB8 },
	0xb4e6, { 0xE6, 0xB9, 0x94 },
	0xb4e7, { 0xE6, 0xB8, 0xA1 },
	0xb4e8, { 0xE6, 0xB8, 0xB2 },
	0xb4e9, { 0xE6, 0xB9, 0xA7 },
	0xb4ea, { 0xE6, 0xB9, 0x8A },
	0xb4eb, { 0xE6, 0xB8, 0xA0 },
	0xb4ec, { 0xE6, 0xB8, 0xA5 },
	0xb4ed, { 0xE6, 0xB8, 0xA3 },
	0xb4ee, { 0xE6, 0xB8, 0x9B },
	0xb4ef, { 0xE6, 0xB9, 0x9B },
	0xb4f0, { 0xE6, 0xB9, 0x98 },
	0xb4f1, { 0xE6, 0xB8, 0xA4 },
	0xb4f2, { 0xE6, 0xB9, 0x96 },
	0xb4f3, { 0xE6, 0xB9, 0xAE },
	0xb4f4, { 0xE6, 0xB8, 0xAD },
	0xb4f5, { 0xE6, 0xB8, 0xA6 },
	0xb4f6, { 0xE6, 0xB9, 0xAF },
	0xb4f7, { 0xE6, 0xB8, 0xB4 },
	0xb4f8, { 0xE6, 0xB9, 0x8D },
	0xb4f9, { 0xE6, 0xB8, 0xBA },
	0xb4fa, { 0xE6, 0xB8, 0xAC },
	0xb4fb, { 0xE6, 0xB9, 0x83 },
	0xb4fc, { 0xE6, 0xB8, 0x9D },
	0xb4fd, { 0xE6, 0xB8, 0xBE },
	0xb4fe, { 0xE6, 0xBB, 0x8B },
	0xb540, { 0xE6, 0xBA, 0x89 },
	0xb541, { 0xE6, 0xB8, 0x99 },
	0xb542, { 0xE6, 0xB9, 0x8E },
	0xb543, { 0xE6, 0xB9, 0xA3 },
	0xb544, { 0xE6, 0xB9, 0x84 },
	0xb545, { 0xE6, 0xB9, 0xB2 },
	0xb546, { 0xE6, 0xB9, 0xA9 },
	0xb547, { 0xE6, 0xB9, 0x9F },
	0xb548, { 0xE7, 0x84, 0x99 },
	0xb549, { 0xE7, 0x84, 0x9A },
	0xb54a, { 0xE7, 0x84, 0xA6 },
	0xb54b, { 0xE7, 0x84, 0xB0 },
	0xb54c, { 0xE7, 0x84, 0xA1 },
	0xb54d, { 0xE7, 0x84, 0xB6 },
	0xb54e, { 0xE7, 0x85, 0xAE },
	0xb54f, { 0xE7, 0x84, 0x9C },
	0xb550, { 0xE7, 0x89, 0x8C },
	0xb551, { 0xE7, 0x8A, 0x84 },
	0xb552, { 0xE7, 0x8A, 0x80 },
	0xb553, { 0xE7, 0x8C, 0xB6 },
	0xb554, { 0xE7, 0x8C, 0xA5 },
	0xb555, { 0xE7, 0x8C, 0xB4 },
	0xb556, { 0xE7, 0x8C, 0xA9 },
	0xb557, { 0xE7, 0x90, 0xBA },
	0xb558, { 0xE7, 0x90, 0xAA },
	0xb559, { 0xE7, 0x90, 0xB3 },
	0xb55a, { 0xE7, 0x90, 0xA2 },
	0xb55b, { 0xE7, 0x90, 0xA5 },
	0xb55c, { 0xE7, 0x90, 0xB5 },
	0xb55d, { 0xE7, 0x90, 0xB6 },
	0xb55e, { 0xE7, 0x90, 0xB4 },
	0xb55f, { 0xE7, 0x90, 0xAF },
	0xb560, { 0xE7, 0x90, 0x9B },
	0xb561, { 0xE7, 0x90, 0xA6 },
	0xb562, { 0xE7, 0x90, 0xA8 },
	0xb563, { 0xE7, 0x94, 0xA5 },
	0xb564, { 0xE7, 0x94, 0xA6 },
	0xb565, { 0xE7, 0x95, 0xAB },
	0xb566, { 0xE7, 0x95, 0xAA },
	0xb567, { 0xE7, 0x97, 0xA2 },
	0xb568, { 0xE7, 0x97, 0x9B },
	0xb569, { 0xE7, 0x97, 0xA3 },
	0xb56a, { 0xE7, 0x97, 0x99 },
	0xb56b, { 0xE7, 0x97, 0x98 },
	0xb56c, { 0xE7, 0x97, 0x9E },
	0xb56d, { 0xE7, 0x97, 0xA0 },
	0xb56e, { 0xE7, 0x99, 0xBB },
	0xb56f, { 0xE7, 0x99, 0xBC },
	0xb570, { 0xE7, 0x9A, 0x96 },
	0xb571, { 0xE7, 0x9A, 0x93 },
	0xb572, { 0xE7, 0x9A, 0xB4 },
	0xb573, { 0xE7, 0x9B, 0x9C },
	0xb574, { 0xE7, 0x9D, 0x8F },
	0xb575, { 0xE7, 0x9F, 0xAD },
	0xb576, { 0xE7, 0xA1, 0x9D },
	0xb577, { 0xE7, 0xA1, 0xAC },
	0xb578, { 0xE7, 0xA1, 0xAF },
	0xb579, { 0xE7, 0xA8, 0x8D },
	0xb57a, { 0xE7, 0xA8, 0x88 },
	0xb57b, { 0xE7, 0xA8, 0x8B },
	0xb57c, { 0xE7, 0xA8, 0x85 },
	0xb57d, { 0xE7, 0xA8, 0x80 },
	0xb57e, { 0xE7, 0xAA, 0x98 },
	0xb5a1, { 0xE7, 0xAA, 0x97 },
	0xb5a2, { 0xE7, 0xAA, 0x96 },
	0xb5a3, { 0xE7, 0xAB, 0xA5 },
	0xb5a4, { 0xE7, 0xAB, 0xA3 },
	0xb5a5, { 0xE7, 0xAD, 0x89 },
	0xb5a6, { 0xE7, 0xAD, 0x96 },
	0xb5a7, { 0xE7, 0xAD, 0x86 },
	0xb5a8, { 0xE7, 0xAD, 0x90 },
	0xb5a9, { 0xE7, 0xAD, 0x92 },
	0xb5aa, { 0xE7, 0xAD, 0x94 },
	0xb5ab, { 0xE7, 0xAD, 0x8D },
	0xb5ac, { 0xE7, 0xAD, 0x8B },
	0xb5ad, { 0xE7, 0xAD, 0x8F },
	0xb5ae, { 0xE7, 0xAD, 0x91 },
	0xb5af, { 0xE7, 0xB2, 0x9F },
	0xb5b0, { 0xE7, 0xB2, 0xA5 },
	0xb5b1, { 0xE7, 0xB5, 0x9E },
	0xb5b2, { 0xE7, 0xB5, 0x90 },
	0xb5b3, { 0xE7, 0xB5, 0xA8 },
	0xb5b4, { 0xE7, 0xB5, 0x95 },
	0xb5b5, { 0xE7, 0xB4, 0xAB },
	0xb5b6, { 0xE7, 0xB5, 0xAE },
	0xb5b7, { 0xE7, 0xB5, 0xB2 },
	0xb5b8, { 0xE7, 0xB5, 0xA1 },
	0xb5b9, { 0xE7, 0xB5, 0xA6 },
	0xb5ba, { 0xE7, 0xB5, 0xA2 },
	0xb5bb, { 0xE7, 0xB5, 0xB0 },
	0xb5bc, { 0xE7, 0xB5, 0xB3 },
	0xb5bd, { 0xE5, 0x96, 0x84 },
	0xb5be, { 0xE7, 0xBF, 0x94 },
	0xb5bf, { 0xE7, 0xBF, 0x95 },
	0xb5c0, { 0xE8, 0x80, 0x8B },
	0xb5c1, { 0xE8, 0x81, 0x92 },
	0xb5c2, { 0xE8, 0x82, 0x85 },
	0xb5c3, { 0xE8, 0x85, 0x95 },
	0xb5c4, { 0xE8, 0x85, 0x94 },
	0xb5c5, { 0xE8, 0x85, 0x8B },
	0xb5c6, { 0xE8, 0x85, 0x91 },
	0xb5c7, { 0xE8, 0x85, 0x8E },
	0xb5c8, { 0xE8, 0x84, 0xB9 },
	0xb5c9, { 0xE8, 0x85, 0x86 },
	0xb5ca, { 0xE8, 0x84, 0xBE },
	0xb5cb, { 0xE8, 0x85, 0x8C },
	0xb5cc, { 0xE8, 0x85, 0x93 },
	0xb5cd, { 0xE8, 0x85, 0xB4 },
	0xb5ce, { 0xE8, 0x88, 0x92 },
	0xb5cf, { 0xE8, 0x88, 0x9C },
	0xb5d0, { 0xE8, 0x8F, 0xA9 },
	0xb5d1, { 0xE8, 0x90, 0x83 },
	0xb5d2, { 0xE8, 0x8F, 0xB8 },
	0xb5d3, { 0xE8, 0x90, 0x8D },
	0xb5d4, { 0xE8, 0x8F, 0xA0 },
	0xb5d5, { 0xE8, 0x8F, 0x85 },
	0xb5d6, { 0xE8, 0x90, 0x8B },
	0xb5d7, { 0xE8, 0x8F, 0x81 },
	0xb5d8, { 0xE8, 0x8F, 0xAF },
	0xb5d9, { 0xE8, 0x8F, 0xB1 },
	0xb5da, { 0xE8, 0x8F, 0xB4 },
	0xb5db, { 0xE8, 0x91, 0x97 },
	0xb5dc, { 0xE8, 0x90, 0x8A },
	0xb5dd, { 0xE8, 0x8F, 0xB0 },
	0xb5de, { 0xE8, 0x90, 0x8C },
	0xb5df, { 0xE8, 0x8F, 0x8C },
	0xb5e0, { 0xE8, 0x8F, 0xBD },
	0xb5e1, { 0xE8, 0x8F, 0xB2 },
	0xb5e2, { 0xE8, 0x8F, 0x8A },
	0xb5e3, { 0xE8, 0x90, 0xB8 },
	0xb5e4, { 0xE8, 0x90, 0x8E },
	0xb5e5, { 0xE8, 0x90, 0x84 },
	0xb5e6, { 0xE8, 0x8F, 0x9C },
	0xb5e7, { 0xE8, 0x90, 0x87 },
	0xb5e8, { 0xE8, 0x8F, 0x94 },
	0xb5e9, { 0xE8, 0x8F, 0x9F },
	0xb5ea, { 0xE8, 0x99, 0x9B },
	0xb5eb, { 0xE8, 0x9B, 0x9F },
	0xb5ec, { 0xE8, 0x9B, 0x99 },
	0xb5ed, { 0xE8, 0x9B, 0xAD },
	0xb5ee, { 0xE8, 0x9B, 0x94 },
	0xb5ef, { 0xE8, 0x9B, 0x9B },
	0xb5f0, { 0xE8, 0x9B, 0xA4 },
	0xb5f1, { 0xE8, 0x9B, 0x90 },
	0xb5f2, { 0xE8, 0x9B, 0x9E },
	0xb5f3, { 0xE8, 0xA1, 0x97 },
	0xb5f4, { 0xE8, 0xA3, 0x81 },
	0xb5f5, { 0xE8, 0xA3, 0x82 },
	0xb5f6, { 0xE8, 0xA2, 0xB1 },
	0xb5f7, { 0xE8, 0xA6, 0x83 },
	0xb5f8, { 0xE8, 0xA6, 0x96 },
	0xb5f9, { 0xE8, 0xA8, 0xBB },
	0xb5fa, { 0xE8, 0xA9, 0xA0 },
	0xb5fb, { 0xE8, 0xA9, 0x95 },
	0xb5fc, { 0xE8, 0xA9, 0x9E },
	0xb5fd, { 0xE8, 0xA8, 0xBC },
	0xb5fe, { 0xE8, 0xA9, 0x81 },
	0xb640, { 0xE8, 0xA9, 0x94 },
	0xb641, { 0xE8, 0xA9, 0x9B },
	0xb642, { 0xE8, 0xA9, 0x90 },
	0xb643, { 0xE8, 0xA9, 0x86 },
	0xb644, { 0xE8, 0xA8, 0xB4 },
	0xb645, { 0xE8, 0xA8, 0xBA },
	0xb646, { 0xE8, 0xA8, 0xB6 },
	0xb647, { 0xE8, 0xA9, 0x96 },
	0xb648, { 0xE8, 0xB1, 0xA1 },
	0xb649, { 0xE8, 0xB2, 0x82 },
	0xb64a, { 0xE8, 0xB2, 0xAF },
	0xb64b, { 0xE8, 0xB2, 0xBC },
	0xb64c, { 0xE8, 0xB2, 0xB3 },
	0xb64d, { 0xE8, 0xB2, 0xBD },
	0xb64e, { 0xE8, 0xB3, 0x81 },
	0xb64f, { 0xE8, 0xB2, 0xBB },
	0xb650, { 0xE8, 0xB3, 0x80 },
	0xb651, { 0xE8, 0xB2, 0xB4 },
	0xb652, { 0xE8, 0xB2, 0xB7 },
	0xb653, { 0xE8, 0xB2, 0xB6 },
	0xb654, { 0xE8, 0xB2, 0xBF },
	0xb655, { 0xE8, 0xB2, 0xB8 },
	0xb656, { 0xE8, 0xB6, 0x8A },
	0xb657, { 0xE8, 0xB6, 0x85 },
	0xb658, { 0xE8, 0xB6, 0x81 },
	0xb659, { 0xE8, 0xB7, 0x8E },
	0xb65a, { 0xE8, 0xB7, 0x9D },
	0xb65b, { 0xE8, 0xB7, 0x8B },
	0xb65c, { 0xE8, 0xB7, 0x9A },
	0xb65d, { 0xE8, 0xB7, 0x91 },
	0xb65e, { 0xE8, 0xB7, 0x8C },
	0xb65f, { 0xE8, 0xB7, 0x9B },
	0xb660, { 0xE8, 0xB7, 0x86 },
	0xb661, { 0xE8, 0xBB, 0xBB },
	0xb662, { 0xE8, 0xBB, 0xB8 },
	0xb663, { 0xE8, 0xBB, 0xBC },
	0xb664, { 0xE8, 0xBE, 0x9C },
	0xb665, { 0xE9, 0x80, 0xAE },
	0xb666, { 0xE9, 0x80, 0xB5 },
	0xb667, { 0xE9, 0x80, 0xB1 },
	0xb668, { 0xE9, 0x80, 0xB8 },
	0xb669, { 0xE9, 0x80, 0xB2 },
	0xb66a, { 0xE9, 0x80, 0xB6 },
	0xb66b, { 0xE9, 0x84, 0x82 },
	0xb66c, { 0xE9, 0x83, 0xB5 },
	0xb66d, { 0xE9, 0x84, 0x89 },
	0xb66e, { 0xE9, 0x83, 0xBE },
	0xb66f, { 0xE9, 0x85, 0xA3 },
	0xb670, { 0xE9, 0x85, 0xA5 },
	0xb671, { 0xE9, 0x87, 0x8F },
	0xb672, { 0xE9, 0x88, 0x94 },
	0xb673, { 0xE9, 0x88, 0x95 },
	0xb674, { 0xE9, 0x88, 0xA3 },
	0xb675, { 0xE9, 0x88, 0x89 },
	0xb676, { 0xE9, 0x88, 0x9E },
	0xb677, { 0xE9, 0x88, 0x8D },
	0xb678, { 0xE9, 0x88, 0x90 },
	0xb679, { 0xE9, 0x88, 0x87 },
	0xb67a, { 0xE9, 0x88, 0x91 },
	0xb67b, { 0xE9, 0x96, 0x94 },
	0xb67c, { 0xE9, 0x96, 0x8F },
	0xb67d, { 0xE9, 0x96, 0x8B },
	0xb67e, { 0xE9, 0x96, 0x91 },
	0xb6a1, { 0xE9, 0x96, 0x93 },
	0xb6a2, { 0xE9, 0x96, 0x92 },
	0xb6a3, { 0xE9, 0x96, 0x8E },
	0xb6a4, { 0xE9, 0x9A, 0x8A },
	0xb6a5, { 0xE9, 0x9A, 0x8E },
	0xb6a6, { 0xE9, 0x9A, 0x8B },
	0xb6a7, { 0xE9, 0x99, 0xBD },
	0xb6a8, { 0xE9, 0x9A, 0x85 },
	0xb6a9, { 0xE9, 0x9A, 0x86 },
	0xb6aa, { 0xE9, 0x9A, 0x8D },
	0xb6ab, { 0xE9, 0x99, 0xB2 },
	0xb6ac, { 0xE9, 0x9A, 0x84 },
	0xb6ad, { 0xE9, 0x9B, 0x81 },
	0xb6ae, { 0xE9, 0x9B, 0x85 },
	0xb6af, { 0xE9, 0x9B, 0x84 },
	0xb6b0, { 0xE9, 0x9B, 0x86 },
	0xb6b1, { 0xE9, 0x9B, 0x87 },
	0xb6b2, { 0xE9, 0x9B, 0xAF },
	0xb6b3, { 0xE9, 0x9B, 0xB2 },
	0xb6b4, { 0xE9, 0x9F, 0x8C },
	0xb6b5, { 0xE9, 0xA0, 0x85 },
	0xb6b6, { 0xE9, 0xA0, 0x86 },
	0xb6b7, { 0xE9, 0xA0, 0x88 },
	0xb6b8, { 0xE9, 0xA3, 0xA7 },
	0xb6b9, { 0xE9, 0xA3, 0xAA },
	0xb6ba, { 0xE9, 0xA3, 0xAF },
	0xb6bb, { 0xE9, 0xA3, 0xA9 },
	0xb6bc, { 0xE9, 0xA3, 0xB2 },
	0xb6bd, { 0xE9, 0xA3, 0xAD },
	0xb6be, { 0xE9, 0xA6, 0xAE },
	0xb6bf, { 0xE9, 0xA6, 0xAD },
	0xb6c0, { 0xE9, 0xBB, 0x83 },
	0xb6c1, { 0xE9, 0xBB, 0x8D },
	0xb6c2, { 0xE9, 0xBB, 0x91 },
	0xb6c3, { 0xE4, 0xBA, 0x82 },
	0xb6c4, { 0xE5, 0x82, 0xAD },
	0xb6c5, { 0xE5, 0x82, 0xB5 },
	0xb6c6, { 0xE5, 0x82, 0xB2 },
	0xb6c7, { 0xE5, 0x82, 0xB3 },
	0xb6c8, { 0xE5, 0x83, 0x85 },
	0xb6c9, { 0xE5, 0x82, 0xBE },
	0xb6ca, { 0xE5, 0x82, 0xAC },
	0xb6cb, { 0xE5, 0x82, 0xB7 },
	0xb6cc, { 0xE5, 0x82, 0xBB },
	0xb6cd, { 0xE5, 0x82, 0xAF },
	0xb6ce, { 0xE5, 0x83, 0x87 },
	0xb6cf, { 0xE5, 0x89, 0xBF },
	0xb6d0, { 0xE5, 0x89, 0xB7 },
	0xb6d1, { 0xE5, 0x89, 0xBD },
	0xb6d2, { 0xE5, 0x8B, 0x9F },
	0xb6d3, { 0xE5, 0x8B, 0xA6 },
	0xb6d4, { 0xE5, 0x8B, 0xA4 },
	0xb6d5, { 0xE5, 0x8B, 0xA2 },
	0xb6d6, { 0xE5, 0x8B, 0xA3 },
	0xb6d7, { 0xE5, 0x8C, 0xAF },
	0xb6d8, { 0xE5, 0x97, 0x9F },
	0xb6d9, { 0xE5, 0x97, 0xA8 },
	0xb6da, { 0xE5, 0x97, 0x93 },
	0xb6db, { 0xE5, 0x97, 0xA6 },
	0xb6dc, { 0xE5, 0x97, 0x8E },
	0xb6dd, { 0xE5, 0x97, 0x9C },
	0xb6de, { 0xE5, 0x97, 0x87 },
	0xb6df, { 0xE5, 0x97, 0x91 },
	0xb6e0, { 0xE5, 0x97, 0xA3 },
	0xb6e1, { 0xE5, 0x97, 0xA4 },
	0xb6e2, { 0xE5, 0x97, 0xAF },
	0xb6e3, { 0xE5, 0x97, 0x9A },
	0xb6e4, { 0xE5, 0x97, 0xA1 },
	0xb6e5, { 0xE5, 0x97, 0x85 },
	0xb6e6, { 0xE5, 0x97, 0x86 },
	0xb6e7, { 0xE5, 0x97, 0xA5 },
	0xb6e8, { 0xE5, 0x97, 0x89 },
	0xb6e9, { 0xE5, 0x9C, 0x92 },
	0xb6ea, { 0xE5, 0x9C, 0x93 },
	0xb6eb, { 0xE5, 0xA1, 0x9E },
	0xb6ec, { 0xE5, 0xA1, 0x91 },
	0xb6ed, { 0xE5, 0xA1, 0x98 },
	0xb6ee, { 0xE5, 0xA1, 0x97 },
	0xb6ef, { 0xE5, 0xA1, 0x9A },
	0xb6f0, { 0xE5, 0xA1, 0x94 },
	0xb6f1, { 0xE5, 0xA1, 0xAB },
	0xb6f2, { 0xE5, 0xA1, 0x8C },
	0xb6f3, { 0xE5, 0xA1, 0xAD },
	0xb6f4, { 0xE5, 0xA1, 0x8A },
	0xb6f5, { 0xE5, 0xA1, 0xA2 },
	0xb6f6, { 0xE5, 0xA1, 0x92 },
	0xb6f7, { 0xE5, 0xA1, 0x8B },
	0xb6f8, { 0xE5, 0xA5, 0xA7 },
	0xb6f9, { 0xE5, 0xAB, 0x81 },
	0xb6fa, { 0xE5, 0xAB, 0x89 },
	0xb6fb, { 0xE5, 0xAB, 0x8C },
	0xb6fc, { 0xE5, 0xAA, 0xBE },
	0xb6fd, { 0xE5, 0xAA, 0xBD },
	0xb6fe, { 0xE5, 0xAA, 0xBC },
	0xb740, { 0xE5, 0xAA, 0xB3 },
	0xb741, { 0xE5, 0xAB, 0x82 },
	0xb742, { 0xE5, 0xAA, 0xB2 },
	0xb743, { 0xE5, 0xB5, 0xA9 },
	0xb744, { 0xE5, 0xB5, 0xAF },
	0xb745, { 0xE5, 0xB9, 0x8C },
	0xb746, { 0xE5, 0xB9, 0xB9 },
	0xb747, { 0xE5, 0xBB, 0x89 },
	0xb748, { 0xE5, 0xBB, 0x88 },
	0xb749, { 0xE5, 0xBC, 0x92 },
	0xb74a, { 0xE5, 0xBD, 0x99 },
	0xb74b, { 0xE5, 0xBE, 0xAC },
	0xb74c, { 0xE5, 0xBE, 0xAE },
	0xb74d, { 0xE6, 0x84, 0x9A },
	0xb74e, { 0xE6, 0x84, 0x8F },
	0xb74f, { 0xE6, 0x85, 0x88 },
	0xb750, { 0xE6, 0x84, 0x9F },
	0xb751, { 0xE6, 0x83, 0xB3 },
	0xb752, { 0xE6, 0x84, 0x9B },
	0xb753, { 0xE6, 0x83, 0xB9 },
	0xb754, { 0xE6, 0x84, 0x81 },
	0xb755, { 0xE6, 0x84, 0x88 },
	0xb756, { 0xE6, 0x85, 0x8E },
	0xb757, { 0xE6, 0x85, 0x8C },
	0xb758, { 0xE6, 0x85, 0x84 },
	0xb759, { 0xE6, 0x85, 0x8D },
	0xb75a, { 0xE6, 0x84, 0xBE },
	0xb75b, { 0xE6, 0x84, 0xB4 },
	0xb75c, { 0xE6, 0x84, 0xA7 },
	0xb75d, { 0xE6, 0x84, 0x8D },
	0xb75e, { 0xE6, 0x84, 0x86 },
	0xb75f, { 0xE6, 0x84, 0xB7 },
	0xb760, { 0xE6, 0x88, 0xA1 },
	0xb761, { 0xE6, 0x88, 0xA2 },
	0xb762, { 0xE6, 0x90, 0x93 },
	0xb763, { 0xE6, 0x90, 0xBE },
	0xb764, { 0xE6, 0x90, 0x9E },
	0xb765, { 0xE6, 0x90, 0xAA },
	0xb766, { 0xE6, 0x90, 0xAD },
	0xb767, { 0xE6, 0x90, 0xBD },
	0xb768, { 0xE6, 0x90, 0xAC },
	0xb769, { 0xE6, 0x90, 0x8F },
	0xb76a, { 0xE6, 0x90, 0x9C },
	0xb76b, { 0xE6, 0x90, 0x94 },
	0xb76c, { 0xE6, 0x90, 0x8D },
	0xb76d, { 0xE6, 0x90, 0xB6 },
	0xb76e, { 0xE6, 0x90, 0x96 },
	0xb76f, { 0xE6, 0x90, 0x97 },
	0xb770, { 0xE6, 0x90, 0x86 },
	0xb771, { 0xE6, 0x95, 0xAC },
	0xb772, { 0xE6, 0x96, 0x9F },
	0xb773, { 0xE6, 0x96, 0xB0 },
	0xb774, { 0xE6, 0x9A, 0x97 },
	0xb775, { 0xE6, 0x9A, 0x89 },
	0xb776, { 0xE6, 0x9A, 0x87 },
	0xb777, { 0xE6, 0x9A, 0x88 },
	0xb778, { 0xE6, 0x9A, 0x96 },
	0xb779, { 0xE6, 0x9A, 0x84 },
	0xb77a, { 0xE6, 0x9A, 0x98 },
	0xb77b, { 0xE6, 0x9A, 0x8D },
	0xb77c, { 0xE6, 0x9C, 0x83 },
	0xb77d, { 0xE6, 0xA6, 0x94 },
	0xb77e, { 0xE6, 0xA5, 0xAD },
	0xb7a1, { 0xE6, 0xA5, 0x9A },
	0xb7a2, { 0xE6, 0xA5, 0xB7 },
	0xb7a3, { 0xE6, 0xA5, 0xA0 },
	0xb7a4, { 0xE6, 0xA5, 0x94 },
	0xb7a5, { 0xE6, 0xA5, 0xB5 },
	0xb7a6, { 0xE6, 0xA4, 0xB0 },
	0xb7a7, { 0xE6, 0xA6, 0x82 },
	0xb7a8, { 0xE6, 0xA5, 0x8A },
	0xb7a9, { 0xE6, 0xA5, 0xA8 },
	0xb7aa, { 0xE6, 0xA5, 0xAB },
	0xb7ab, { 0xE6, 0xA5, 0x9E },
	0xb7ac, { 0xE6, 0xA5, 0x93 },
	0xb7ad, { 0xE6, 0xA5, 0xB9 },
	0xb7ae, { 0xE6, 0xA6, 0x86 },
	0xb7af, { 0xE6, 0xA5, 0x9D },
	0xb7b0, { 0xE6, 0xA5, 0xA3 },
	0xb7b1, { 0xE6, 0xA5, 0x9B },
	0xb7b2, { 0xE6, 0xAD, 0x87 },
	0xb7b3, { 0xE6, 0xAD, 0xB2 },
	0xb7b4, { 0xE6, 0xAF, 0x80 },
	0xb7b5, { 0xE6, 0xAE, 0xBF },
	0xb7b6, { 0xE6, 0xAF, 0x93 },
	0xb7b7, { 0xE6, 0xAF, 0xBD },
	0xb7b8, { 0xE6, 0xBA, 0xA2 },
	0xb7b9, { 0xE6, 0xBA, 0xAF },
	0xb7ba, { 0xE6, 0xBB, 0x93 },
	0xb7bb, { 0xE6, 0xBA, 0xB6 },
	0xb7bc, { 0xE6, 0xBB, 0x82 },
	0xb7bd, { 0xE6, 0xBA, 0x90 },
	0xb7be, { 0xE6, 0xBA, 0x9D },
	0xb7bf, { 0xE6, 0xBB, 0x87 },
	0xb7c0, { 0xE6, 0xBB, 0x85 },
	0xb7c1, { 0xE6, 0xBA, 0xA5 },
	0xb7c2, { 0xE6, 0xBA, 0x98 },
	0xb7c3, { 0xE6, 0xBA, 0xBC },
	0xb7c4, { 0xE6, 0xBA, 0xBA },
	0xb7c5, { 0xE6, 0xBA, 0xAB },
	0xb7c6, { 0xE6, 0xBB, 0x91 },
	0xb7c7, { 0xE6, 0xBA, 0x96 },
	0xb7c8, { 0xE6, 0xBA, 0x9C },
	0xb7c9, { 0xE6, 0xBB, 0x84 },
	0xb7ca, { 0xE6, 0xBB, 0x94 },
	0xb7cb, { 0xE6, 0xBA, 0xAA },
	0xb7cc, { 0xE6, 0xBA, 0xA7 },
	0xb7cd, { 0xE6, 0xBA, 0xB4 },
	0xb7ce, { 0xE7, 0x85, 0x8E },
	0xb7cf, { 0xE7, 0x85, 0x99 },
	0xb7d0, { 0xE7, 0x85, 0xA9 },
	0xb7d1, { 0xE7, 0x85, 0xA4 },
	0xb7d2, { 0xE7, 0x85, 0x89 },
	0xb7d3, { 0xE7, 0x85, 0xA7 },
	0xb7d4, { 0xE7, 0x85, 0x9C },
	0xb7d5, { 0xE7, 0x85, 0xAC },
	0xb7d6, { 0xE7, 0x85, 0xA6 },
	0xb7d7, { 0xE7, 0x85, 0x8C },
	0xb7d8, { 0xE7, 0x85, 0xA5 },
	0xb7d9, { 0xE7, 0x85, 0x9E },
	0xb7da, { 0xE7, 0x85, 0x86 },
	0xb7db, { 0xE7, 0x85, 0xA8 },
	0xb7dc, { 0xE7, 0x85, 0x96 },
	0xb7dd, { 0xE7, 0x88, 0xBA },
	0xb7de, { 0xE7, 0x89, 0x92 },
	0xb7df, { 0xE7, 0x8C, 0xB7 },
	0xb7e0, { 0xE7, 0x8D, 0x85 },
	0xb7e1, { 0xE7, 0x8C, 0xBF },
	0xb7e2, { 0xE7, 0x8C, 0xBE },
	0xb7e3, { 0xE7, 0x91, 0xAF },
	0xb7e4, { 0xE7, 0x91, 0x9A },
	0xb7e5, { 0xE7, 0x91, 0x95 },
	0xb7e6, { 0xE7, 0x91, 0x9F },
	0xb7e7, { 0xE7, 0x91, 0x9E },
	0xb7e8, { 0xE7, 0x91, 0x81 },
	0xb7e9, { 0xE7, 0x90, 0xBF },
	0xb7ea, { 0xE7, 0x91, 0x99 },
	0xb7eb, { 0xE7, 0x91, 0x9B },
	0xb7ec, { 0xE7, 0x91, 0x9C },
	0xb7ed, { 0xE7, 0x95, 0xB6 },
	0xb7ee, { 0xE7, 0x95, 0xB8 },
	0xb7ef, { 0xE7, 0x98, 0x80 },
	0xb7f0, { 0xE7, 0x97, 0xB0 },
	0xb7f1, { 0xE7, 0x98, 0x81 },
	0xb7f2, { 0xE7, 0x97, 0xB2 },
	0xb7f3, { 0xE7, 0x97, 0xB1 },
	0xb7f4, { 0xE7, 0x97, 0xBA },
	0xb7f5, { 0xE7, 0x97, 0xBF },
	0xb7f6, { 0xE7, 0x97, 0xB4 },
	0xb7f7, { 0xE7, 0x97, 0xB3 },
	0xb7f8, { 0xE7, 0x9B, 0x9E },
	0xb7f9, { 0xE7, 0x9B, 0x9F },
	0xb7fa, { 0xE7, 0x9D, 0x9B },
	0xb7fb, { 0xE7, 0x9D, 0xAB },
	0xb7fc, { 0xE7, 0x9D, 0xA6 },
	0xb7fd, { 0xE7, 0x9D, 0x9E },
	0xb7fe, { 0xE7, 0x9D, 0xA3 },
	0xb840, { 0xE7, 0x9D, 0xB9 },
	0xb841, { 0xE7, 0x9D, 0xAA },
	0xb842, { 0xE7, 0x9D, 0xAC },
	0xb843, { 0xE7, 0x9D, 0x9C },
	0xb844, { 0xE7, 0x9D, 0xA5 },
	0xb845, { 0xE7, 0x9D, 0xA8 },
	0xb846, { 0xE7, 0x9D, 0xA2 },
	0xb847, { 0xE7, 0x9F, 0xAE },
	0xb848, { 0xE7, 0xA2, 0x8E },
	0xb849, { 0xE7, 0xA2, 0xB0 },
	0xb84a, { 0xE7, 0xA2, 0x97 },
	0xb84b, { 0xE7, 0xA2, 0x98 },
	0xb84c, { 0xE7, 0xA2, 0x8C },
	0xb84d, { 0xE7, 0xA2, 0x89 },
	0xb84e, { 0xE7, 0xA1, 0xBC },
	0xb84f, { 0xE7, 0xA2, 0x91 },
	0xb850, { 0xE7, 0xA2, 0x93 },
	0xb851, { 0xE7, 0xA1, 0xBF },
	0xb852, { 0xE7, 0xA5, 0xBA },
	0xb853, { 0xE7, 0xA5, 0xBF },
	0xb854, { 0xE7, 0xA6, 0x81 },
	0xb855, { 0xE8, 0x90, 0xAC },
	0xb856, { 0xE7, 0xA6, 0xBD },
	0xb857, { 0xE7, 0xA8, 0x9C },
	0xb858, { 0xE7, 0xA8, 0x9A },
	0xb859, { 0xE7, 0xA8, 0xA0 },
	0xb85a, { 0xE7, 0xA8, 0x94 },
	0xb85b, { 0xE7, 0xA8, 0x9F },
	0xb85c, { 0xE7, 0xA8, 0x9E },
	0xb85d, { 0xE7, 0xAA, 0x9F },
	0xb85e, { 0xE7, 0xAA, 0xA0 },
	0xb85f, { 0xE7, 0xAD, 0xB7 },
	0xb860, { 0xE7, 0xAF, 0x80 },
	0xb861, { 0xE7, 0xAD, 0xA0 },
	0xb862, { 0xE7, 0xAD, 0xAE },
	0xb863, { 0xE7, 0xAD, 0xA7 },
	0xb864, { 0xE7, 0xB2, 0xB1 },
	0xb865, { 0xE7, 0xB2, 0xB3 },
	0xb866, { 0xE7, 0xB2, 0xB5 },
	0xb867, { 0xE7, 0xB6, 0x93 },
	0xb868, { 0xE7, 0xB5, 0xB9 },
	0xb869, { 0xE7, 0xB6, 0x91 },
	0xb86a, { 0xE7, 0xB6, 0x81 },
	0xb86b, { 0xE7, 0xB6, 0x8F },
	0xb86c, { 0xE7, 0xB5, 0x9B },
	0xb86d, { 0xE7, 0xBD, 0xAE },
	0xb86e, { 0xE7, 0xBD, 0xA9 },
	0xb86f, { 0xE7, 0xBD, 0xAA },
	0xb870, { 0xE7, 0xBD, 0xB2 },
	0xb871, { 0xE7, 0xBE, 0xA9 },
	0xb872, { 0xE7, 0xBE, 0xA8 },
	0xb873, { 0xE7, 0xBE, 0xA4 },
	0xb874, { 0xE8, 0x81, 0x96 },
	0xb875, { 0xE8, 0x81, 0x98 },
	0xb876, { 0xE8, 0x82, 0x86 },
	0xb877, { 0xE8, 0x82, 0x84 },
	0xb878, { 0xE8, 0x85, 0xB1 },
	0xb879, { 0xE8, 0x85, 0xB0 },
	0xb87a, { 0xE8, 0x85, 0xB8 },
	0xb87b, { 0xE8, 0x85, 0xA5 },
	0xb87c, { 0xE8, 0x85, 0xAE },
	0xb87d, { 0xE8, 0x85, 0xB3 },
	0xb87e, { 0xE8, 0x85, 0xAB },
	0xb8a1, { 0xE8, 0x85, 0xB9 },
	0xb8a2, { 0xE8, 0x85, 0xBA },
	0xb8a3, { 0xE8, 0x85, 0xA6 },
	0xb8a4, { 0xE8, 0x88, 0x85 },
	0xb8a5, { 0xE8, 0x89, 0x87 },
	0xb8a6, { 0xE8, 0x92, 0x82 },
	0xb8a7, { 0xE8, 0x91, 0xB7 },
	0xb8a8, { 0xE8, 0x90, 0xBD },
	0xb8a9, { 0xE8, 0x90, 0xB1 },
	0xb8aa, { 0xE8, 0x91, 0xB5 },
	0xb8ab, { 0xE8, 0x91, 0xA6 },
	0xb8ac, { 0xE8, 0x91, 0xAB },
	0xb8ad, { 0xE8, 0x91, 0x89 },
	0xb8ae, { 0xE8, 0x91, 0xAC },
	0xb8af, { 0xE8, 0x91, 0x9B },
	0xb8b0, { 0xE8, 0x90, 0xBC },
	0xb8b1, { 0xE8, 0x90, 0xB5 },
	0xb8b2, { 0xE8, 0x91, 0xA1 },
	0xb8b3, { 0xE8, 0x91, 0xA3 },
	0xb8b4, { 0xE8, 0x91, 0xA9 },
	0xb8b5, { 0xE8, 0x91, 0xAD },
	0xb8b6, { 0xE8, 0x91, 0x86 },
	0xb8b7, { 0xE8, 0x99, 0x9E },
	0xb8b8, { 0xE8, 0x99, 0x9C },
	0xb8b9, { 0xE8, 0x99, 0x9F },
	0xb8ba, { 0xE8, 0x9B, 0xB9 },
	0xb8bb, { 0xE8, 0x9C, 0x93 },
	0xb8bc, { 0xE8, 0x9C, 0x88 },
	0xb8bd, { 0xE8, 0x9C, 0x87 },
	0xb8be, { 0xE8, 0x9C, 0x80 },
	0xb8bf, { 0xE8, 0x9B, 0xBE },
	0xb8c0, { 0xE8, 0x9B, 0xBB },
	0xb8c1, { 0xE8, 0x9C, 0x82 },
	0xb8c2, { 0xE8, 0x9C, 0x83 },
	0xb8c3, { 0xE8, 0x9C, 0x86 },
	0xb8c4, { 0xE8, 0x9C, 0x8A },
	0xb8c5, { 0xE8, 0xA1, 0x99 },
	0xb8c6, { 0xE8, 0xA3, 0x9F },
	0xb8c7, { 0xE8, 0xA3, 0x94 },
	0xb8c8, { 0xE8, 0xA3, 0x99 },
	0xb8c9, { 0xE8, 0xA3, 0x9C },
	0xb8ca, { 0xE8, 0xA3, 0x98 },
	0xb8cb, { 0xE8, 0xA3, 0x9D },
	0xb8cc, { 0xE8, 0xA3, 0xA1 },
	0xb8cd, { 0xE8, 0xA3, 0x8A },
	0xb8ce, { 0xE8, 0xA3, 0x95 },
	0xb8cf, { 0xE8, 0xA3, 0x92 },
	0xb8d0, { 0xE8, 0xA6, 0x9C },
	0xb8d1, { 0xE8, 0xA7, 0xA3 },
	0xb8d2, { 0xE8, 0xA9, 0xAB },
	0xb8d3, { 0xE8, 0xA9, 0xB2 },
	0xb8d4, { 0xE8, 0xA9, 0xB3 },
	0xb8d5, { 0xE8, 0xA9, 0xA6 },
	0xb8d6, { 0xE8, 0xA9, 0xA9 },
	0xb8d7, { 0xE8, 0xA9, 0xB0 },
	0xb8d8, { 0xE8, 0xAA, 0x87 },
	0xb8d9, { 0xE8, 0xA9, 0xBC },
	0xb8da, { 0xE8, 0xA9, 0xA3 },
	0xb8db, { 0xE8, 0xAA, 0xA0 },
	0xb8dc, { 0xE8, 0xA9, 0xB1 },
	0xb8dd, { 0xE8, 0xAA, 0x85 },
	0xb8de, { 0xE8, 0xA9, 0xAD },
	0xb8df, { 0xE8, 0xA9, 0xA2 },
	0xb8e0, { 0xE8, 0xA9, 0xAE },
	0xb8e1, { 0xE8, 0xA9, 0xAC },
	0xb8e2, { 0xE8, 0xA9, 0xB9 },
	0xb8e3, { 0xE8, 0xA9, 0xBB },
	0xb8e4, { 0xE8, 0xA8, 0xBE },
	0xb8e5, { 0xE8, 0xA9, 0xA8 },
	0xb8e6, { 0xE8, 0xB1, 0xA2 },
	0xb8e7, { 0xE8, 0xB2, 0x8A },
	0xb8e8, { 0xE8, 0xB2, 0x89 },
	0xb8e9, { 0xE8, 0xB3, 0x8A },
	0xb8ea, { 0xE8, 0xB3, 0x87 },
	0xb8eb, { 0xE8, 0xB3, 0x88 },
	0xb8ec, { 0xE8, 0xB3, 0x84 },
	0xb8ed, { 0xE8, 0xB2, 0xB2 },
	0xb8ee, { 0xE8, 0xB3, 0x83 },
	0xb8ef, { 0xE8, 0xB3, 0x82 },
	0xb8f0, { 0xE8, 0xB3, 0x85 },
	0xb8f1, { 0xE8, 0xB7, 0xA1 },
	0xb8f2, { 0xE8, 0xB7, 0x9F },
	0xb8f3, { 0xE8, 0xB7, 0xA8 },
	0xb8f4, { 0xE8, 0xB7, 0xAF },
	0xb8f5, { 0xE8, 0xB7, 0xB3 },
	0xb8f6, { 0xE8, 0xB7, 0xBA },
	0xb8f7, { 0xE8, 0xB7, 0xAA },
	0xb8f8, { 0xE8, 0xB7, 0xA4 },
	0xb8f9, { 0xE8, 0xB7, 0xA6 },
	0xb8fa, { 0xE8, 0xBA, 0xB2 },
	0xb8fb, { 0xE8, 0xBC, 0x83 },
	0xb8fc, { 0xE8, 0xBC, 0x89 },
	0xb8fd, { 0xE8, 0xBB, 0xBE },
	0xb8fe, { 0xE8, 0xBC, 0x8A },
	0xb940, { 0xE8, 0xBE, 0x9F },
	0xb941, { 0xE8, 0xBE, 0xB2 },
	0xb942, { 0xE9, 0x81, 0x8B },
	0xb943, { 0xE9, 0x81, 0x8A },
	0xb944, { 0xE9, 0x81, 0x93 },
	0xb945, { 0xE9, 0x81, 0x82 },
	0xb946, { 0xE9, 0x81, 0x94 },
	0xb947, { 0xE9, 0x80, 0xBC },
	0xb948, { 0xE9, 0x81, 0x95 },
	0xb949, { 0xE9, 0x81, 0x90 },
	0xb94a, { 0xE9, 0x81, 0x87 },
	0xb94b, { 0xE9, 0x81, 0x8F },
	0xb94c, { 0xE9, 0x81, 0x8E },
	0xb94d, { 0xE9, 0x81, 0x8D },
	0xb94e, { 0xE9, 0x81, 0x91 },
	0xb94f, { 0xE9, 0x80, 0xBE },
	0xb950, { 0xE9, 0x81, 0x81 },
	0xb951, { 0xE9, 0x84, 0x92 },
	0xb952, { 0xE9, 0x84, 0x97 },
	0xb953, { 0xE9, 0x85, 0xAC },
	0xb954, { 0xE9, 0x85, 0xAA },
	0xb955, { 0xE9, 0x85, 0xA9 },
	0xb956, { 0xE9, 0x87, 0x89 },
	0xb957, { 0xE9, 0x88, 0xB7 },
	0xb958, { 0xE9, 0x89, 0x97 },
	0xb959, { 0xE9, 0x88, 0xB8 },
	0xb95a, { 0xE9, 0x88, 0xBD },
	0xb95b, { 0xE9, 0x89, 0x80 },
	0xb95c, { 0xE9, 0x88, 0xBE },
	0xb95d, { 0xE9, 0x89, 0x9B },
	0xb95e, { 0xE9, 0x89, 0x8B },
	0xb95f, { 0xE9, 0x89, 0xA4 },
	0xb960, { 0xE9, 0x89, 0x91 },
	0xb961, { 0xE9, 0x88, 0xB4 },
	0xb962, { 0xE9, 0x89, 0x89 },
	0xb963, { 0xE9, 0x89, 0x8D },
	0xb964, { 0xE9, 0x89, 0x85 },
	0xb965, { 0xE9, 0x88, 0xB9 },
	0xb966, { 0xE9, 0x88, 0xBF },
	0xb967, { 0xE9, 0x89, 0x9A },
	0xb968, { 0xE9, 0x96, 0x98 },
	0xb969, { 0xE9, 0x9A, 0x98 },
	0xb96a, { 0xE9, 0x9A, 0x94 },
	0xb96b, { 0xE9, 0x9A, 0x95 },
	0xb96c, { 0xE9, 0x9B, 0x8D },
	0xb96d, { 0xE9, 0x9B, 0x8B },
	0xb96e, { 0xE9, 0x9B, 0x89 },
	0xb96f, { 0xE9, 0x9B, 0x8A },
	0xb970, { 0xE9, 0x9B, 0xB7 },
	0xb971, { 0xE9, 0x9B, 0xBB },
	0xb972, { 0xE9, 0x9B, 0xB9 },
	0xb973, { 0xE9, 0x9B, 0xB6 },
	0xb974, { 0xE9, 0x9D, 0x96 },
	0xb975, { 0xE9, 0x9D, 0xB4 },
	0xb976, { 0xE9, 0x9D, 0xB6 },
	0xb977, { 0xE9, 0xA0, 0x90 },
	0xb978, { 0xE9, 0xA0, 0x91 },
	0xb979, { 0xE9, 0xA0, 0x93 },
	0xb97a, { 0xE9, 0xA0, 0x8A },
	0xb97b, { 0xE9, 0xA0, 0x92 },
	0xb97c, { 0xE9, 0xA0, 0x8C },
	0xb97d, { 0xE9, 0xA3, 0xBC },
	0xb97e, { 0xE9, 0xA3, 0xB4 },
	0xb9a1, { 0xE9, 0xA3, 0xBD },
	0xb9a2, { 0xE9, 0xA3, 0xBE },
	0xb9a3, { 0xE9, 0xA6, 0xB3 },
	0xb9a4, { 0xE9, 0xA6, 0xB1 },
	0xb9a5, { 0xE9, 0xA6, 0xB4 },
	0xb9a6, { 0xE9, 0xAB, 0xA1 },
	0xb9a7, { 0xE9, 0xB3, 0xA9 },
	0xb9a8, { 0xE9, 0xBA, 0x82 },
	0xb9a9, { 0xE9, 0xBC, 0x8E },
	0xb9aa, { 0xE9, 0xBC, 0x93 },
	0xb9ab, { 0xE9, 0xBC, 0xA0 },
	0xb9ac, { 0xE5, 0x83, 0xA7 },
	0xb9ad, { 0xE5, 0x83, 0xAE },
	0xb9ae, { 0xE5, 0x83, 0xA5 },
	0xb9af, { 0xE5, 0x83, 0x96 },
	0xb9b0, { 0xE5, 0x83, 0xAD },
	0xb9b1, { 0xE5, 0x83, 0x9A },
	0xb9b2, { 0xE5, 0x83, 0x95 },
	0xb9b3, { 0xE5, 0x83, 0x8F },
	0xb9b4, { 0xE5, 0x83, 0x91 },
	0xb9b5, { 0xE5, 0x83, 0xB1 },
	0xb9b6, { 0xE5, 0x83, 0x8E },
	0xb9b7, { 0xE5, 0x83, 0xA9 },
	0xb9b8, { 0xE5, 0x85, 0xA2 },
	0xb9b9, { 0xE5, 0x87, 0xB3 },
	0xb9ba, { 0xE5, 0x8A, 0x83 },
	0xb9bb, { 0xE5, 0x8A, 0x82 },
	0xb9bc, { 0xE5, 0x8C, 0xB1 },
	0xb9bd, { 0xE5, 0x8E, 0xAD },
	0xb9be, { 0xE5, 0x97, 0xBE },
	0xb9bf, { 0xE5, 0x98, 0x80 },
	0xb9c0, { 0xE5, 0x98, 0x9B },
	0xb9c1, { 0xE5, 0x98, 0x97 },
	0xb9c2, { 0xE5, 0x97, 0xBD },
	0xb9c3, { 0xE5, 0x98, 0x94 },
	0xb9c4, { 0xE5, 0x98, 0x86 },
	0xb9c5, { 0xE5, 0x98, 0x89 },
	0xb9c6, { 0xE5, 0x98, 0x8D },
	0xb9c7, { 0xE5, 0x98, 0x8E },
	0xb9c8, { 0xE5, 0x97, 0xB7 },
	0xb9c9, { 0xE5, 0x98, 0x96 },
	0xb9ca, { 0xE5, 0x98, 0x9F },
	0xb9cb, { 0xE5, 0x98, 0x88 },
	0xb9cc, { 0xE5, 0x98, 0x90 },
	0xb9cd, { 0xE5, 0x97, 0xB6 },
	0xb9ce, { 0xE5, 0x9C, 0x98 },
	0xb9cf, { 0xE5, 0x9C, 0x96 },
	0xb9d0, { 0xE5, 0xA1, 0xB5 },
	0xb9d1, { 0xE5, 0xA1, 0xBE },
	0xb9d2, { 0xE5, 0xA2, 0x83 },
	0xb9d3, { 0xE5, 0xA2, 0x93 },
	0xb9d4, { 0xE5, 0xA2, 0x8A },
	0xb9d5, { 0xE5, 0xA1, 0xB9 },
	0xb9d6, { 0xE5, 0xA2, 0x85 },
	0xb9d7, { 0xE5, 0xA1, 0xBD },
	0xb9d8, { 0xE5, 0xA3, 0xBD },
	0xb9d9, { 0xE5, 0xA4, 0xA5 },
	0xb9da, { 0xE5, 0xA4, 0xA2 },
	0xb9db, { 0xE5, 0xA4, 0xA4 },
	0xb9dc, { 0xE5, 0xA5, 0xAA },
	0xb9dd, { 0xE5, 0xA5, 0xA9 },
	0xb9de, { 0xE5, 0xAB, 0xA1 },
	0xb9df, { 0xE5, 0xAB, 0xA6 },
	0xb9e0, { 0xE5, 0xAB, 0xA9 },
	0xb9e1, { 0xE5, 0xAB, 0x97 },
	0xb9e2, { 0xE5, 0xAB, 0x96 },
	0xb9e3, { 0xE5, 0xAB, 0x98 },
	0xb9e4, { 0xE5, 0xAB, 0xA3 },
	0xb9e5, { 0xE5, 0xAD, 0xB5 },
	0xb9e6, { 0xE5, 0xAF, 0x9E },
	0xb9e7, { 0xE5, 0xAF, 0xA7 },
	0xb9e8, { 0xE5, 0xAF, 0xA1 },
	0xb9e9, { 0xE5, 0xAF, 0xA5 },
	0xb9ea, { 0xE5, 0xAF, 0xA6 },
	0xb9eb, { 0xE5, 0xAF, 0xA8 },
	0xb9ec, { 0xE5, 0xAF, 0xA2 },
	0xb9ed, { 0xE5, 0xAF, 0xA4 },
	0xb9ee, { 0xE5, 0xAF, 0x9F },
	0xb9ef, { 0xE5, 0xB0, 0x8D },
	0xb9f0, { 0xE5, 0xB1, 0xA2 },
	0xb9f1, { 0xE5, 0xB6, 0x84 },
	0xb9f2, { 0xE5, 0xB6, 0x87 },
	0xb9f3, { 0xE5, 0xB9, 0x9B },
	0xb9f4, { 0xE5, 0xB9, 0xA3 },
	0xb9f5, { 0xE5, 0xB9, 0x95 },
	0xb9f6, { 0xE5, 0xB9, 0x97 },
	0xb9f7, { 0xE5, 0xB9, 0x94 },
	0xb9f8, { 0xE5, 0xBB, 0x93 },
	0xb9f9, { 0xE5, 0xBB, 0x96 },
	0xb9fa, { 0xE5, 0xBC, 0x8A },
	0xb9fb, { 0xE5, 0xBD, 0x86 },
	0xb9fc, { 0xE5, 0xBD, 0xB0 },
	0xb9fd, { 0xE5, 0xBE, 0xB9 },
	0xb9fe, { 0xE6, 0x85, 0x87 },
	0xba40, { 0xE6, 0x84, 0xBF },
	0xba41, { 0xE6, 0x85, 0x8B },
	0xba42, { 0xE6, 0x85, 0xB7 },
	0xba43, { 0xE6, 0x85, 0xA2 },
	0xba44, { 0xE6, 0x85, 0xA3 },
	0xba45, { 0xE6, 0x85, 0x9F },
	0xba46, { 0xE6, 0x85, 0x9A },
	0xba47, { 0xE6, 0x85, 0x98 },
	0xba48, { 0xE6, 0x85, 0xB5 },
	0xba49, { 0xE6, 0x88, 0xAA },
	0xba4a, { 0xE6, 0x92, 0x87 },
	0xba4b, { 0xE6, 0x91, 0x98 },
	0xba4c, { 0xE6, 0x91, 0x94 },
	0xba4d, { 0xE6, 0x92, 0xA4 },
	0xba4e, { 0xE6, 0x91, 0xB8 },
	0xba4f, { 0xE6, 0x91, 0x9F },
	0xba50, { 0xE6, 0x91, 0xBA },
	0xba51, { 0xE6, 0x91, 0x91 },
	0xba52, { 0xE6, 0x91, 0xA7 },
	0xba53, { 0xE6, 0x90, 0xB4 },
	0xba54, { 0xE6, 0x91, 0xAD },
	0xba55, { 0xE6, 0x91, 0xBB },
	0xba56, { 0xE6, 0x95, 0xB2 },
	0xba57, { 0xE6, 0x96, 0xA1 },
	0xba58, { 0xE6, 0x97, 0x97 },
	0xba59, { 0xE6, 0x97, 0x96 },
	0xba5a, { 0xE6, 0x9A, 0xA2 },
	0xba5b, { 0xE6, 0x9A, 0xA8 },
	0xba5c, { 0xE6, 0x9A, 0x9D },
	0xba5d, { 0xE6, 0xA6, 0x9C },
	0xba5e, { 0xE6, 0xA6, 0xA8 },
	0xba5f, { 0xE6, 0xA6, 0x95 },
	0xba60, { 0xE6, 0xA7, 0x81 },
	0xba61, { 0xE6, 0xA6, 0xAE },
	0xba62, { 0xE6, 0xA7, 0x93 },
	0xba63, { 0xE6, 0xA7, 0x8B },
	0xba64, { 0xE6, 0xA6, 0x9B },
	0xba65, { 0xE6, 0xA6, 0xB7 },
	0xba66, { 0xE6, 0xA6, 0xBB },
	0xba67, { 0xE6, 0xA6, 0xAB },
	0xba68, { 0xE6, 0xA6, 0xB4 },
	0xba69, { 0xE6, 0xA7, 0x90 },
	0xba6a, { 0xE6, 0xA7, 0x8D },
	0xba6b, { 0xE6, 0xA6, 0xAD },
	0xba6c, { 0xE6, 0xA7, 0x8C },
	0xba6d, { 0xE6, 0xA6, 0xA6 },
	0xba6e, { 0xE6, 0xA7, 0x83 },
	0xba6f, { 0xE6, 0xA6, 0xA3 },
	0xba70, { 0xE6, 0xAD, 0x89 },
	0xba71, { 0xE6, 0xAD, 0x8C },
	0xba72, { 0xE6, 0xB0, 0xB3 },
	0xba73, { 0xE6, 0xBC, 0xB3 },
	0xba74, { 0xE6, 0xBC, 0x94 },
	0xba75, { 0xE6, 0xBB, 0xBE },
	0xba76, { 0xE6, 0xBC, 0x93 },
	0xba77, { 0xE6, 0xBB, 0xB4 },
	0xba78, { 0xE6, 0xBC, 0xA9 },
	0xba79, { 0xE6, 0xBC, 0xBE },
	0xba7a, { 0xE6, 0xBC, 0xA0 },
	0xba7b, { 0xE6, 0xBC, 0xAC },
	0xba7c, { 0xE6, 0xBC, 0x8F },
	0xba7d, { 0xE6, 0xBC, 0x82 },
	0xba7e, { 0xE6, 0xBC, 0xA2 },
	0xbaa1, { 0xE6, 0xBB, 0xBF },
	0xbaa2, { 0xE6, 0xBB, 0xAF },
	0xbaa3, { 0xE6, 0xBC, 0x86 },
	0xbaa4, { 0xE6, 0xBC, 0xB1 },
	0xbaa5, { 0xE6, 0xBC, 0xB8 },
	0xbaa6, { 0xE6, 0xBC, 0xB2 },
	0xbaa7, { 0xE6, 0xBC, 0xA3 },
	0xbaa8, { 0xE6, 0xBC, 0x95 },
	0xbaa9, { 0xE6, 0xBC, 0xAB },
	0xbaaa, { 0xE6, 0xBC, 0xAF },
	0xbaab, { 0xE6, 0xBE, 0x88 },
	0xbaac, { 0xE6, 0xBC, 0xAA },
	0xbaad, { 0xE6, 0xBB, 0xAC },
	0xbaae, { 0xE6, 0xBC, 0x81 },
	0xbaaf, { 0xE6, 0xBB, 0xB2 },
	0xbab0, { 0xE6, 0xBB, 0x8C },
	0xbab1, { 0xE6, 0xBB, 0xB7 },
	0xbab2, { 0xE7, 0x86, 0x94 },
	0xbab3, { 0xE7, 0x86, 0x99 },
	0xbab4, { 0xE7, 0x85, 0xBD },
	0xbab5, { 0xE7, 0x86, 0x8A },
	0xbab6, { 0xE7, 0x86, 0x84 },
	0xbab7, { 0xE7, 0x86, 0x92 },
	0xbab8, { 0xE7, 0x88, 0xBE },
	0xbab9, { 0xE7, 0x8A, 0x92 },
	0xbaba, { 0xE7, 0x8A, 0x96 },
	0xbabb, { 0xE7, 0x8D, 0x84 },
	0xbabc, { 0xE7, 0x8D, 0x90 },
	0xbabd, { 0xE7, 0x91, 0xA4 },
	0xbabe, { 0xE7, 0x91, 0xA3 },
	0xbabf, { 0xE7, 0x91, 0xAA },
	0xbac0, { 0xE7, 0x91, 0xB0 },
	0xbac1, { 0xE7, 0x91, 0xAD },
	0xbac2, { 0xE7, 0x94, 0x84 },
	0xbac3, { 0xE7, 0x96, 0x91 },
	0xbac4, { 0xE7, 0x98, 0xA7 },
	0xbac5, { 0xE7, 0x98, 0x8D },
	0xbac6, { 0xE7, 0x98, 0x8B },
	0xbac7, { 0xE7, 0x98, 0x89 },
	0xbac8, { 0xE7, 0x98, 0x93 },
	0xbac9, { 0xE7, 0x9B, 0xA1 },
	0xbaca, { 0xE7, 0x9B, 0xA3 },
	0xbacb, { 0xE7, 0x9E, 0x84 },
	0xbacc, { 0xE7, 0x9D, 0xBD },
	0xbacd, { 0xE7, 0x9D, 0xBF },
	0xbace, { 0xE7, 0x9D, 0xA1 },
	0xbacf, { 0xE7, 0xA3, 0x81 },
	0xbad0, { 0xE7, 0xA2, 0x9F },
	0xbad1, { 0xE7, 0xA2, 0xA7 },
	0xbad2, { 0xE7, 0xA2, 0xB3 },
	0xbad3, { 0xE7, 0xA2, 0xA9 },
	0xbad4, { 0xE7, 0xA2, 0xA3 },
	0xbad5, { 0xE7, 0xA6, 0x8E },
	0xbad6, { 0xE7, 0xA6, 0x8F },
	0xbad7, { 0xE7, 0xA6, 0x8D },
	0xbad8, { 0xE7, 0xA8, 0xAE },
	0xbad9, { 0xE7, 0xA8, 0xB1 },
	0xbada, { 0xE7, 0xAA, 0xAA },
	0xbadb, { 0xE7, 0xAA, 0xA9 },
	0xbadc, { 0xE7, 0xAB, 0xAD },
	0xbadd, { 0xE7, 0xAB, 0xAF },
	0xbade, { 0xE7, 0xAE, 0xA1 },
	0xbadf, { 0xE7, 0xAE, 0x95 },
	0xbae0, { 0xE7, 0xAE, 0x8B },
	0xbae1, { 0xE7, 0xAD, 0xB5 },
	0xbae2, { 0xE7, 0xAE, 0x97 },
	0xbae3, { 0xE7, 0xAE, 0x9D },
	0xbae4, { 0xE7, 0xAE, 0x94 },
	0xbae5, { 0xE7, 0xAE, 0x8F },
	0xbae6, { 0xE7, 0xAE, 0xB8 },
	0xbae7, { 0xE7, 0xAE, 0x87 },
	0xbae8, { 0xE7, 0xAE, 0x84 },
	0xbae9, { 0xE7, 0xB2, 0xB9 },
	0xbaea, { 0xE7, 0xB2, 0xBD },
	0xbaeb, { 0xE7, 0xB2, 0xBE },
	0xbaec, { 0xE7, 0xB6, 0xBB },
	0xbaed, { 0xE7, 0xB6, 0xB0 },
	0xbaee, { 0xE7, 0xB6, 0x9C },
	0xbaef, { 0xE7, 0xB6, 0xBD },
	0xbaf0, { 0xE7, 0xB6, 0xBE },
	0xbaf1, { 0xE7, 0xB6, 0xA0 },
	0xbaf2, { 0xE7, 0xB7, 0x8A },
	0xbaf3, { 0xE7, 0xB6, 0xB4 },
	0xbaf4, { 0xE7, 0xB6, 0xB2 },
	0xbaf5, { 0xE7, 0xB6, 0xB1 },
	0xbaf6, { 0xE7, 0xB6, 0xBA },
	0xbaf7, { 0xE7, 0xB6, 0xA2 },
	0xbaf8, { 0xE7, 0xB6, 0xBF },
	0xbaf9, { 0xE7, 0xB6, 0xB5 },
	0xbafa, { 0xE7, 0xB6, 0xB8 },
	0xbafb, { 0xE7, 0xB6, 0xAD },
	0xbafc, { 0xE7, 0xB7, 0x92 },
	0xbafd, { 0xE7, 0xB7, 0x87 },
	0xbafe, { 0xE7, 0xB6, 0xAC },
	0xbb40, { 0xE7, 0xBD, 0xB0 },
	0xbb41, { 0xE7, 0xBF, 0xA0 },
	0xbb42, { 0xE7, 0xBF, 0xA1 },
	0xbb43, { 0xE7, 0xBF, 0x9F },
	0xbb44, { 0xE8, 0x81, 0x9E },
	0xbb45, { 0xE8, 0x81, 0x9A },
	0xbb46, { 0xE8, 0x82, 0x87 },
	0xbb47, { 0xE8, 0x85, 0x90 },
	0xbb48, { 0xE8, 0x86, 0x80 },
	0xbb49, { 0xE8, 0x86, 0x8F },
	0xbb4a, { 0xE8, 0x86, 0x88 },
	0xbb4b, { 0xE8, 0x86, 0x8A },
	0xbb4c, { 0xE8, 0x85, 0xBF },
	0xbb4d, { 0xE8, 0x86, 0x82 },
	0xbb4e, { 0xE8, 0x87, 0xA7 },
	0xbb4f, { 0xE8, 0x87, 0xBA },
	0xbb50, { 0xE8, 0x88, 0x87 },
	0xbb51, { 0xE8, 0x88, 0x94 },
	0xbb52, { 0xE8, 0x88, 0x9E },
	0xbb53, { 0xE8, 0x89, 0x8B },
	0xbb54, { 0xE8, 0x93, 0x89 },
	0xbb55, { 0xE8, 0x92, 0xBF },
	0xbb56, { 0xE8, 0x93, 0x86 },
	0xbb57, { 0xE8, 0x93, 0x84 },
	0xbb58, { 0xE8, 0x92, 0x99 },
	0xbb59, { 0xE8, 0x92, 0x9E },
	0xbb5a, { 0xE8, 0x92, 0xB2 },
	0xbb5b, { 0xE8, 0x92, 0x9C },
	0xbb5c, { 0xE8, 0x93, 0x8B },
	0xbb5d, { 0xE8, 0x92, 0xB8 },
	0xbb5e, { 0xE8, 0x93, 0x80 },
	0xbb5f, { 0xE8, 0x93, 0x93 },
	0xbb60, { 0xE8, 0x92, 0x90 },
	0xbb61, { 0xE8, 0x92, 0xBC },
	0xbb62, { 0xE8, 0x93, 0x91 },
	0xbb63, { 0xE8, 0x93, 0x8A },
	0xbb64, { 0xE8, 0x9C, 0xBF },
	0xbb65, { 0xE8, 0x9C, 0x9C },
	0xbb66, { 0xE8, 0x9C, 0xBB },
	0xbb67, { 0xE8, 0x9C, 0xA2 },
	0xbb68, { 0xE8, 0x9C, 0xA5 },
	0xbb69, { 0xE8, 0x9C, 0xB4 },
	0xbb6a, { 0xE8, 0x9C, 0x98 },
	0xbb6b, { 0xE8, 0x9D, 0x95 },
	0xbb6c, { 0xE8, 0x9C, 0xB7 },
	0xbb6d, { 0xE8, 0x9C, 0xA9 },
	0xbb6e, { 0xE8, 0xA3, 0xB3 },
	0xbb6f, { 0xE8, 0xA4, 0x82 },
	0xbb70, { 0xE8, 0xA3, 0xB4 },
	0xbb71, { 0xE8, 0xA3, 0xB9 },
	0xbb72, { 0xE8, 0xA3, 0xB8 },
	0xbb73, { 0xE8, 0xA3, 0xBD },
	0xbb74, { 0xE8, 0xA3, 0xA8 },
	0xbb75, { 0xE8, 0xA4, 0x9A },
	0xbb76, { 0xE8, 0xA3, 0xAF },
	0xbb77, { 0xE8, 0xAA, 0xA6 },
	0xbb78, { 0xE8, 0xAA, 0x8C },
	0xbb79, { 0xE8, 0xAA, 0x9E },
	0xbb7a, { 0xE8, 0xAA, 0xA3 },
	0xbb7b, { 0xE8, 0xAA, 0x8D },
	0xbb7c, { 0xE8, 0xAA, 0xA1 },
	0xbb7d, { 0xE8, 0xAA, 0x93 },
	0xbb7e, { 0xE8, 0xAA, 0xA4 },
	0xbba1, { 0xE8, 0xAA, 0xAA },
	0xbba2, { 0xE8, 0xAA, 0xA5 },
	0xbba3, { 0xE8, 0xAA, 0xA8 },
	0xbba4, { 0xE8, 0xAA, 0x98 },
	0xbba5, { 0xE8, 0xAA, 0x91 },
	0xbba6, { 0xE8, 0xAA, 0x9A },
	0xbba7, { 0xE8, 0xAA, 0xA7 },
	0xbba8, { 0xE8, 0xB1, 0xAA },
	0xbba9, { 0xE8, 0xB2, 0x8D },
	0xbbaa, { 0xE8, 0xB2, 0x8C },
	0xbbab, { 0xE8, 0xB3, 0x93 },
	0xbbac, { 0xE8, 0xB3, 0x91 },
	0xbbad, { 0xE8, 0xB3, 0x92 },
	0xbbae, { 0xE8, 0xB5, 0xAB },
	0xbbaf, { 0xE8, 0xB6, 0x99 },
	0xbbb0, { 0xE8, 0xB6, 0x95 },
	0xbbb1, { 0xE8, 0xB7, 0xBC },
	0xbbb2, { 0xE8, 0xBC, 0x94 },
	0xbbb3, { 0xE8, 0xBC, 0x92 },
	0xbbb4, { 0xE8, 0xBC, 0x95 },
	0xbbb5, { 0xE8, 0xBC, 0x93 },
	0xbbb6, { 0xE8, 0xBE, 0xA3 },
	0xbbb7, { 0xE9, 0x81, 0xA0 },
	0xbbb8, { 0xE9, 0x81, 0x98 },
	0xbbb9, { 0xE9, 0x81, 0x9C },
	0xbbba, { 0xE9, 0x81, 0xA3 },
	0xbbbb, { 0xE9, 0x81, 0x99 },
	0xbbbc, { 0xE9, 0x81, 0x9E },
	0xbbbd, { 0xE9, 0x81, 0xA2 },
	0xbbbe, { 0xE9, 0x81, 0x9D },
	0xbbbf, { 0xE9, 0x81, 0x9B },
	0xbbc0, { 0xE9, 0x84, 0x99 },
	0xbbc1, { 0xE9, 0x84, 0x98 },
	0xbbc2, { 0xE9, 0x84, 0x9E },
	0xbbc3, { 0xE9, 0x85, 0xB5 },
	0xbbc4, { 0xE9, 0x85, 0xB8 },
	0xbbc5, { 0xE9, 0x85, 0xB7 },
	0xbbc6, { 0xE9, 0x85, 0xB4 },
	0xbbc7, { 0xE9, 0x89, 0xB8 },
	0xbbc8, { 0xE9, 0x8A, 0x80 },
	0xbbc9, { 0xE9, 0x8A, 0x85 },
	0xbbca, { 0xE9, 0x8A, 0x98 },
	0xbbcb, { 0xE9, 0x8A, 0x96 },
	0xbbcc, { 0xE9, 0x89, 0xBB },
	0xbbcd, { 0xE9, 0x8A, 0x93 },
	0xbbce, { 0xE9, 0x8A, 0x9C },
	0xbbcf, { 0xE9, 0x8A, 0xA8 },
	0xbbd0, { 0xE9, 0x89, 0xBC },
	0xbbd1, { 0xE9, 0x8A, 0x91 },
	0xbbd2, { 0xE9, 0x96, 0xA1 },
	0xbbd3, { 0xE9, 0x96, 0xA8 },
	0xbbd4, { 0xE9, 0x96, 0xA9 },
	0xbbd5, { 0xE9, 0x96, 0xA3 },
	0xbbd6, { 0xE9, 0x96, 0xA5 },
	0xbbd7, { 0xE9, 0x96, 0xA4 },
	0xbbd8, { 0xE9, 0x9A, 0x99 },
	0xbbd9, { 0xE9, 0x9A, 0x9C },
	0xbbda, { 0xE9, 0x9A, 0x9B },
	0xbbdb, { 0xE9, 0x9B, 0x8C },
	0xbbdc, { 0xE9, 0x9B, 0x92 },
	0xbbdd, { 0xE9, 0x9C, 0x80 },
	0xbbde, { 0xE9, 0x9D, 0xBC },
	0xbbdf, { 0xE9, 0x9E, 0x85 },
	0xbbe0, { 0xE9, 0x9F, 0xB6 },
	0xbbe1, { 0xE9, 0xA0, 0x97 },
	0xbbe2, { 0xE9, 0xA0, 0x98 },
	0xbbe3, { 0xE9, 0xA2, 0xAF },
	0xbbe4, { 0xE9, 0xA2, 0xB1 },
	0xbbe5, { 0xE9, 0xA4, 0x83 },
	0xbbe6, { 0xE9, 0xA4, 0x85 },
	0xbbe7, { 0xE9, 0xA4, 0x8C },
	0xbbe8, { 0xE9, 0xA4, 0x89 },
	0xbbe9, { 0xE9, 0xA7, 0x81 },
	0xbbea, { 0xE9, 0xAA, 0xAF },
	0xbbeb, { 0xE9, 0xAA, 0xB0 },
	0xbbec, { 0xE9, 0xAB, 0xA6 },
	0xbbed, { 0xE9, 0xAD, 0x81 },
	0xbbee, { 0xE9, 0xAD, 0x82 },
	0xbbef, { 0xE9, 0xB3, 0xB4 },
	0xbbf0, { 0xE9, 0xB3, 0xB6 },
	0xbbf1, { 0xE9, 0xB3, 0xB3 },
	0xbbf2, { 0xE9, 0xBA, 0xBC },
	0xbbf3, { 0xE9, 0xBC, 0xBB },
	0xbbf4, { 0xE9, 0xBD, 0x8A },
	0xbbf5, { 0xE5, 0x84, 0x84 },
	0xbbf6, { 0xE5, 0x84, 0x80 },
	0xbbf7, { 0xE5, 0x83, 0xBB },
	0xbbf8, { 0xE5, 0x83, 0xB5 },
	0xbbf9, { 0xE5, 0x83, 0xB9 },
	0xbbfa, { 0xE5, 0x84, 0x82 },
	0xbbfb, { 0xE5, 0x84, 0x88 },
	0xbbfc, { 0xE5, 0x84, 0x89 },
	0xbbfd, { 0xE5, 0x84, 0x85 },
	0xbbfe, { 0xE5, 0x87, 0x9C },
	0xbc40, { 0xE5, 0x8A, 0x87 },
	0xbc41, { 0xE5, 0x8A, 0x88 },
	0xbc42, { 0xE5, 0x8A, 0x89 },
	0xbc43, { 0xE5, 0x8A, 0x8D },
	0xbc44, { 0xE5, 0x8A, 0x8A },
	0xbc45, { 0xE5, 0x8B, 0xB0 },
	0xbc46, { 0xE5, 0x8E, 0xB2 },
	0xbc47, { 0xE5, 0x98, 0xAE },
	0xbc48, { 0xE5, 0x98, 0xBB },
	0xbc49, { 0xE5, 0x98, 0xB9 },
	0xbc4a, { 0xE5, 0x98, 0xB2 },
	0xbc4b, { 0xE5, 0x98, 0xBF },
	0xbc4c, { 0xE5, 0x98, 0xB4 },
	0xbc4d, { 0xE5, 0x98, 0xA9 },
	0xbc4e, { 0xE5, 0x99, 0x93 },
	0xbc4f, { 0xE5, 0x99, 0x8E },
	0xbc50, { 0xE5, 0x99, 0x97 },
	0xbc51, { 0xE5, 0x99, 0xB4 },
	0xbc52, { 0xE5, 0x98, 0xB6 },
	0xbc53, { 0xE5, 0x98, 0xAF },
	0xbc54, { 0xE5, 0x98, 0xB0 },
	0xbc55, { 0xE5, 0xA2, 0x80 },
	0xbc56, { 0xE5, 0xA2, 0x9F },
	0xbc57, { 0xE5, 0xA2, 0x9E },
	0xbc58, { 0xE5, 0xA2, 0xB3 },
	0xbc59, { 0xE5, 0xA2, 0x9C },
	0xbc5a, { 0xE5, 0xA2, 0xAE },
	0xbc5b, { 0xE5, 0xA2, 0xA9 },
	0xbc5c, { 0xE5, 0xA2, 0xA6 },
	0xbc5d, { 0xE5, 0xA5, 0xAD },
	0xbc5e, { 0xE5, 0xAC, 0x89 },
	0xbc5f, { 0xE5, 0xAB, 0xBB },
	0xbc60, { 0xE5, 0xAC, 0x8B },
	0xbc61, { 0xE5, 0xAB, 0xB5 },
	0xbc62, { 0xE5, 0xAC, 0x8C },
	0xbc63, { 0xE5, 0xAC, 0x88 },
	0xbc64, { 0xE5, 0xAF, 0xAE },
	0xbc65, { 0xE5, 0xAF, 0xAC },
	0xbc66, { 0xE5, 0xAF, 0xA9 },
	0xbc67, { 0xE5, 0xAF, 0xAB },
	0xbc68, { 0xE5, 0xB1, 0xA4 },
	0xbc69, { 0xE5, 0xB1, 0xA5 },
	0xbc6a, { 0xE5, 0xB6, 0x9D },
	0xbc6b, { 0xE5, 0xB6, 0x94 },
	0xbc6c, { 0xE5, 0xB9, 0xA2 },
	0xbc6d, { 0xE5, 0xB9, 0x9F },
	0xbc6e, { 0xE5, 0xB9, 0xA1 },
	0xbc6f, { 0xE5, 0xBB, 0xA2 },
	0xbc70, { 0xE5, 0xBB, 0x9A },
	0xbc71, { 0xE5, 0xBB, 0x9F },
	0xbc72, { 0xE5, 0xBB, 0x9D },
	0xbc73, { 0xE5, 0xBB, 0xA3 },
	0xbc74, { 0xE5, 0xBB, 0xA0 },
	0xbc75, { 0xE5, 0xBD, 0x88 },
	0xbc76, { 0xE5, 0xBD, 0xB1 },
	0xbc77, { 0xE5, 0xBE, 0xB7 },
	0xbc78, { 0xE5, 0xBE, 0xB5 },
	0xbc79, { 0xE6, 0x85, 0xB6 },
	0xbc7a, { 0xE6, 0x85, 0xA7 },
	0xbc7b, { 0xE6, 0x85, 0xAE },
	0xbc7c, { 0xE6, 0x85, 0x9D },
	0xbc7d, { 0xE6, 0x85, 0x95 },
	0xbc7e, { 0xE6, 0x86, 0x82 },
	0xbca1, { 0xE6, 0x85, 0xBC },
	0xbca2, { 0xE6, 0x85, 0xB0 },
	0xbca3, { 0xE6, 0x85, 0xAB },
	0xbca4, { 0xE6, 0x85, 0xBE },
	0xbca5, { 0xE6, 0x86, 0xA7 },
	0xbca6, { 0xE6, 0x86, 0x90 },
	0xbca7, { 0xE6, 0x86, 0xAB },
	0xbca8, { 0xE6, 0x86, 0x8E },
	0xbca9, { 0xE6, 0x86, 0xAC },
	0xbcaa, { 0xE6, 0x86, 0x9A },
	0xbcab, { 0xE6, 0x86, 0xA4 },
	0xbcac, { 0xE6, 0x86, 0x94 },
	0xbcad, { 0xE6, 0x86, 0xAE },
	0xbcae, { 0xE6, 0x88, 0xAE },
	0xbcaf, { 0xE6, 0x91, 0xA9 },
	0xbcb0, { 0xE6, 0x91, 0xAF },
	0xbcb1, { 0xE6, 0x91, 0xB9 },
	0xbcb2, { 0xE6, 0x92, 0x9E },
	0xbcb3, { 0xE6, 0x92, 0xB2 },
	0xbcb4, { 0xE6, 0x92, 0x88 },
	0xbcb5, { 0xE6, 0x92, 0x90 },
	0xbcb6, { 0xE6, 0x92, 0xB0 },
	0xbcb7, { 0xE6, 0x92, 0xA5 },
	0xbcb8, { 0xE6, 0x92, 0x93 },
	0xbcb9, { 0xE6, 0x92, 0x95 },
	0xbcba, { 0xE6, 0x92, 0xA9 },
	0xbcbb, { 0xE6, 0x92, 0x92 },
	0xbcbc, { 0xE6, 0x92, 0xAE },
	0xbcbd, { 0xE6, 0x92, 0xAD },
	0xbcbe, { 0xE6, 0x92, 0xAB },
	0xbcbf, { 0xE6, 0x92, 0x9A },
	0xbcc0, { 0xE6, 0x92, 0xAC },
	0xbcc1, { 0xE6, 0x92, 0x99 },
	0xbcc2, { 0xE6, 0x92, 0xA2 },
	0xbcc3, { 0xE6, 0x92, 0xB3 },
	0xbcc4, { 0xE6, 0x95, 0xB5 },
	0xbcc5, { 0xE6, 0x95, 0xB7 },
	0xbcc6, { 0xE6, 0x95, 0xB8 },
	0xbcc7, { 0xE6, 0x9A, 0xAE },
	0xbcc8, { 0xE6, 0x9A, 0xAB },
	0xbcc9, { 0xE6, 0x9A, 0xB4 },
	0xbcca, { 0xE6, 0x9A, 0xB1 },
	0xbccb, { 0xE6, 0xA8, 0xA3 },
	0xbccc, { 0xE6, 0xA8, 0x9F },
	0xbccd, { 0xE6, 0xA7, 0xA8 },
	0xbcce, { 0xE6, 0xA8, 0x81 },
	0xbccf, { 0xE6, 0xA8, 0x9E },
	0xbcd0, { 0xE6, 0xA8, 0x99 },
	0xbcd1, { 0xE6, 0xA7, 0xBD },
	0xbcd2, { 0xE6, 0xA8, 0xA1 },
	0xbcd3, { 0xE6, 0xA8, 0x93 },
	0xbcd4, { 0xE6, 0xA8, 0x8A },
	0xbcd5, { 0xE6, 0xA7, 0xB3 },
	0xbcd6, { 0xE6, 0xA8, 0x82 },
	0xbcd7, { 0xE6, 0xA8, 0x85 },
	0xbcd8, { 0xE6, 0xA7, 0xAD },
	0xbcd9, { 0xE6, 0xA8, 0x91 },
	0xbcda, { 0xE6, 0xAD, 0x90 },
	0xbcdb, { 0xE6, 0xAD, 0x8E },
	0xbcdc, { 0xE6, 0xAE, 0xA4 },
	0xbcdd, { 0xE6, 0xAF, 0x85 },
	0xbcde, { 0xE6, 0xAF, 0x86 },
	0xbcdf, { 0xE6, 0xBC, 0xBF },
	0xbce0, { 0xE6, 0xBD, 0xBC },
	0xbce1, { 0xE6, 0xBE, 0x84 },
	0xbce2, { 0xE6, 0xBD, 0x91 },
	0xbce3, { 0xE6, 0xBD, 0xA6 },
	0xbce4, { 0xE6, 0xBD, 0x94 },
	0xbce5, { 0xE6, 0xBE, 0x86 },
	0xbce6, { 0xE6, 0xBD, 0xAD },
	0xbce7, { 0xE6, 0xBD, 0x9B },
	0xbce8, { 0xE6, 0xBD, 0xB8 },
	0xbce9, { 0xE6, 0xBD, 0xAE },
	0xbcea, { 0xE6, 0xBE, 0x8E },
	0xbceb, { 0xE6, 0xBD, 0xBA },
	0xbcec, { 0xE6, 0xBD, 0xB0 },
	0xbced, { 0xE6, 0xBD, 0xA4 },
	0xbcee, { 0xE6, 0xBE, 0x97 },
	0xbcef, { 0xE6, 0xBD, 0x98 },
	0xbcf0, { 0xE6, 0xBB, 0x95 },
	0xbcf1, { 0xE6, 0xBD, 0xAF },
	0xbcf2, { 0xE6, 0xBD, 0xA0 },
	0xbcf3, { 0xE6, 0xBD, 0x9F },
	0xbcf4, { 0xE7, 0x86, 0x9F },
	0xbcf5, { 0xE7, 0x86, 0xAC },
	0xbcf6, { 0xE7, 0x86, 0xB1 },
	0xbcf7, { 0xE7, 0x86, 0xA8 },
	0xbcf8, { 0xE7, 0x89, 0x96 },
	0xbcf9, { 0xE7, 0x8A, 0x9B },
	0xbcfa, { 0xE7, 0x8D, 0x8E },
	0xbcfb, { 0xE7, 0x8D, 0x97 },
	0xbcfc, { 0xE7, 0x91, 0xA9 },
	0xbcfd, { 0xE7, 0x92, 0x8B },
	0xbcfe, { 0xE7, 0x92, 0x83 },
	0xbd40, { 0xE7, 0x91, 0xBE },
	0xbd41, { 0xE7, 0x92, 0x80 },
	0xbd42, { 0xE7, 0x95, 0xBF },
	0xbd43, { 0xE7, 0x98, 0xA0 },
	0xbd44, { 0xE7, 0x98, 0xA9 },
	0xbd45, { 0xE7, 0x98, 0x9F },
	0xbd46, { 0xE7, 0x98, 0xA4 },
	0xbd47, { 0xE7, 0x98, 0xA6 },
	0xbd48, { 0xE7, 0x98, 0xA1 },
	0xbd49, { 0xE7, 0x98, 0xA2 },
	0xbd4a, { 0xE7, 0x9A, 0x9A },
	0xbd4b, { 0xE7, 0x9A, 0xBA },
	0xbd4c, { 0xE7, 0x9B, 0xA4 },
	0xbd4d, { 0xE7, 0x9E, 0x8E },
	0xbd4e, { 0xE7, 0x9E, 0x87 },
	0xbd4f, { 0xE7, 0x9E, 0x8C },
	0xbd50, { 0xE7, 0x9E, 0x91 },
	0xbd51, { 0xE7, 0x9E, 0x8B },
	0xbd52, { 0xE7, 0xA3, 0x8B },
	0xbd53, { 0xE7, 0xA3, 0x85 },
	0xbd54, { 0xE7, 0xA2, 0xBA },
	0xbd55, { 0xE7, 0xA3, 0x8A },
	0xbd56, { 0xE7, 0xA2, 0xBE },
	0xbd57, { 0xE7, 0xA3, 0x95 },
	0xbd58, { 0xE7, 0xA2, 0xBC },
	0xbd59, { 0xE7, 0xA3, 0x90 },
	0xbd5a, { 0xE7, 0xA8, 0xBF },
	0xbd5b, { 0xE7, 0xA8, 0xBC },
	0xbd5c, { 0xE7, 0xA9, 0x80 },
	0xbd5d, { 0xE7, 0xA8, 0xBD },
	0xbd5e, { 0xE7, 0xA8, 0xB7 },
	0xbd5f, { 0xE7, 0xA8, 0xBB },
	0xbd60, { 0xE7, 0xAA, 0xAF },
	0xbd61, { 0xE7, 0xAA, 0xAE },
	0xbd62, { 0xE7, 0xAE, 0xAD },
	0xbd63, { 0xE7, 0xAE, 0xB1 },
	0xbd64, { 0xE7, 0xAF, 0x84 },
	0xbd65, { 0xE7, 0xAE, 0xB4 },
	0xbd66, { 0xE7, 0xAF, 0x86 },
	0xbd67, { 0xE7, 0xAF, 0x87 },
	0xbd68, { 0xE7, 0xAF, 0x81 },
	0xbd69, { 0xE7, 0xAE, 0xA0 },
	0xbd6a, { 0xE7, 0xAF, 0x8C },
	0xbd6b, { 0xE7, 0xB3, 0x8A },
	0xbd6c, { 0xE7, 0xB7, 0xA0 },
	0xbd6d, { 0xE7, 0xB7, 0xB4 },
	0xbd6e, { 0xE7, 0xB7, 0xAF },
	0xbd6f, { 0xE7, 0xB7, 0xBB },
	0xbd70, { 0xE7, 0xB7, 0x98 },
	0xbd71, { 0xE7, 0xB7, 0xAC },
	0xbd72, { 0xE7, 0xB7, 0x9D },
	0xbd73, { 0xE7, 0xB7, 0xA8 },
	0xbd74, { 0xE7, 0xB7, 0xA3 },
	0xbd75, { 0xE7, 0xB7, 0x9A },
	0xbd76, { 0xE7, 0xB7, 0x9E },
	0xbd77, { 0xE7, 0xB7, 0xA9 },
	0xbd78, { 0xE7, 0xB6, 0x9E },
	0xbd79, { 0xE7, 0xB7, 0x99 },
	0xbd7a, { 0xE7, 0xB7, 0xB2 },
	0xbd7b, { 0xE7, 0xB7, 0xB9 },
	0xbd7c, { 0xE7, 0xBD, 0xB5 },
	0xbd7d, { 0xE7, 0xBD, 0xB7 },
	0xbd7e, { 0xE7, 0xBE, 0xAF },
	0xbda1, { 0xE7, 0xBF, 0xA9 },
	0xbda2, { 0xE8, 0x80, 0xA6 },
	0xbda3, { 0xE8, 0x86, 0x9B },
	0xbda4, { 0xE8, 0x86, 0x9C },
	0xbda5, { 0xE8, 0x86, 0x9D },
	0xbda6, { 0xE8, 0x86, 0xA0 },
	0xbda7, { 0xE8, 0x86, 0x9A },
	0xbda8, { 0xE8, 0x86, 0x98 },
	0xbda9, { 0xE8, 0x94, 0x97 },
	0xbdaa, { 0xE8, 0x94, 0xBD },
	0xbdab, { 0xE8, 0x94, 0x9A },
	0xbdac, { 0xE8, 0x93, 0xAE },
	0xbdad, { 0xE8, 0x94, 0xAC },
	0xbdae, { 0xE8, 0x94, 0xAD },
	0xbdaf, { 0xE8, 0x94, 0x93 },
	0xbdb0, { 0xE8, 0x94, 0x91 },
	0xbdb1, { 0xE8, 0x94, 0xA3 },
	0xbdb2, { 0xE8, 0x94, 0xA1 },
	0xbdb3, { 0xE8, 0x94, 0x94 },
	0xbdb4, { 0xE8, 0x93, 0xAC },
	0xbdb5, { 0xE8, 0x94, 0xA5 },
	0xbdb6, { 0xE8, 0x93, 0xBF },
	0xbdb7, { 0xE8, 0x94, 0x86 },
	0xbdb8, { 0xE8, 0x9E, 0x82 },
	0xbdb9, { 0xE8, 0x9D, 0xB4 },
	0xbdba, { 0xE8, 0x9D, 0xB6 },
	0xbdbb, { 0xE8, 0x9D, 0xA0 },
	0xbdbc, { 0xE8, 0x9D, 0xA6 },
	0xbdbd, { 0xE8, 0x9D, 0xB8 },
	0xbdbe, { 0xE8, 0x9D, 0xA8 },
	0xbdbf, { 0xE8, 0x9D, 0x99 },
	0xbdc0, { 0xE8, 0x9D, 0x97 },
	0xbdc1, { 0xE8, 0x9D, 0x8C },
	0xbdc2, { 0xE8, 0x9D, 0x93 },
	0xbdc3, { 0xE8, 0xA1, 0x9B },
	0xbdc4, { 0xE8, 0xA1, 0x9D },
	0xbdc5, { 0xE8, 0xA4, 0x90 },
	0xbdc6, { 0xE8, 0xA4, 0x87 },
	0xbdc7, { 0xE8, 0xA4, 0x92 },
	0xbdc8, { 0xE8, 0xA4, 0x93 },
	0xbdc9, { 0xE8, 0xA4, 0x95 },
	0xbdca, { 0xE8, 0xA4, 0x8A },
	0xbdcb, { 0xE8, 0xAA, 0xBC },
	0xbdcc, { 0xE8, 0xAB, 0x92 },
	0xbdcd, { 0xE8, 0xAB, 0x87 },
	0xbdce, { 0xE8, 0xAB, 0x84 },
	0xbdcf, { 0xE8, 0xAA, 0x95 },
	0xbdd0, { 0xE8, 0xAB, 0x8B },
	0xbdd1, { 0xE8, 0xAB, 0xB8 },
	0xbdd2, { 0xE8, 0xAA, 0xB2 },
	0xbdd3, { 0xE8, 0xAB, 0x89 },
	0xbdd4, { 0xE8, 0xAB, 0x82 },
	0xbdd5, { 0xE8, 0xAA, 0xBF },
	0xbdd6, { 0xE8, 0xAA, 0xB0 },
	0xbdd7, { 0xE8, 0xAB, 0x96 },
	0xbdd8, { 0xE8, 0xAB, 0x8D },
	0xbdd9, { 0xE8, 0xAA, 0xB6 },
	0xbdda, { 0xE8, 0xAA, 0xB9 },
	0xbddb, { 0xE8, 0xAB, 0x9B },
	0xbddc, { 0xE8, 0xB1, 0x8C },
	0xbddd, { 0xE8, 0xB1, 0x8E },
	0xbdde, { 0xE8, 0xB1, 0xAC },
	0xbddf, { 0xE8, 0xB3, 0xA0 },
	0xbde0, { 0xE8, 0xB3, 0x9E },
	0xbde1, { 0xE8, 0xB3, 0xA6 },
	0xbde2, { 0xE8, 0xB3, 0xA4 },
	0xbde3, { 0xE8, 0xB3, 0xAC },
	0xbde4, { 0xE8, 0xB3, 0xAD },
	0xbde5, { 0xE8, 0xB3, 0xA2 },
	0xbde6, { 0xE8, 0xB3, 0xA3 },
	0xbde7, { 0xE8, 0xB3, 0x9C },
	0xbde8, { 0xE8, 0xB3, 0xAA },
	0xbde9, { 0xE8, 0xB3, 0xA1 },
	0xbdea, { 0xE8, 0xB5, 0xAD },
	0xbdeb, { 0xE8, 0xB6, 0x9F },
	0xbdec, { 0xE8, 0xB6, 0xA3 },
	0xbded, { 0xE8, 0xB8, 0xAB },
	0xbdee, { 0xE8, 0xB8, 0x90 },
	0xbdef, { 0xE8, 0xB8, 0x9D },
	0xbdf0, { 0xE8, 0xB8, 0xA2 },
	0xbdf1, { 0xE8, 0xB8, 0x8F },
	0xbdf2, { 0xE8, 0xB8, 0xA9 },
	0xbdf3, { 0xE8, 0xB8, 0x9F },
	0xbdf4, { 0xE8, 0xB8, 0xA1 },
	0xbdf5, { 0xE8, 0xB8, 0x9E },
	0xbdf6, { 0xE8, 0xBA, 0xBA },
	0xbdf7, { 0xE8, 0xBC, 0x9D },
	0xbdf8, { 0xE8, 0xBC, 0x9B },
	0xbdf9, { 0xE8, 0xBC, 0x9F },
	0xbdfa, { 0xE8, 0xBC, 0xA9 },
	0xbdfb, { 0xE8, 0xBC, 0xA6 },
	0xbdfc, { 0xE8, 0xBC, 0xAA },
	0xbdfd, { 0xE8, 0xBC, 0x9C },
	0xbdfe, { 0xE8, 0xBC, 0x9E },
	0xbe40, { 0xE8, 0xBC, 0xA5 },
	0xbe41, { 0xE9, 0x81, 0xA9 },
	0xbe42, { 0xE9, 0x81, 0xAE },
	0xbe43, { 0xE9, 0x81, 0xA8 },
	0xbe44, { 0xE9, 0x81, 0xAD },
	0xbe45, { 0xE9, 0x81, 0xB7 },
	0xbe46, { 0xE9, 0x84, 0xB0 },
	0xbe47, { 0xE9, 0x84, 0xAD },
	0xbe48, { 0xE9, 0x84, 0xA7 },
	0xbe49, { 0xE9, 0x84, 0xB1 },
	0xbe4a, { 0xE9, 0x86, 0x87 },
	0xbe4b, { 0xE9, 0x86, 0x89 },
	0xbe4c, { 0xE9, 0x86, 0x8B },
	0xbe4d, { 0xE9, 0x86, 0x83 },
	0xbe4e, { 0xE9, 0x8B, 0x85 },
	0xbe4f, { 0xE9, 0x8A, 0xBB },
	0xbe50, { 0xE9, 0x8A, 0xB7 },
	0xbe51, { 0xE9, 0x8B, 0xAA },
	0xbe52, { 0xE9, 0x8A, 0xAC },
	0xbe53, { 0xE9, 0x8B, 0xA4 },
	0xbe54, { 0xE9, 0x8B, 0x81 },
	0xbe55, { 0xE9, 0x8A, 0xB3 },
	0xbe56, { 0xE9, 0x8A, 0xBC },
	0xbe57, { 0xE9, 0x8B, 0x92 },
	0xbe58, { 0xE9, 0x8B, 0x87 },
	0xbe59, { 0xE9, 0x8B, 0xB0 },
	0xbe5a, { 0xE9, 0x8A, 0xB2 },
	0xbe5b, { 0xE9, 0x96, 0xAD },
	0xbe5c, { 0xE9, 0x96, 0xB1 },
	0xbe5d, { 0xE9, 0x9C, 0x84 },
	0xbe5e, { 0xE9, 0x9C, 0x86 },
	0xbe5f, { 0xE9, 0x9C, 0x87 },
	0xbe60, { 0xE9, 0x9C, 0x89 },
	0xbe61, { 0xE9, 0x9D, 0xA0 },
	0xbe62, { 0xE9, 0x9E, 0x8D },
	0xbe63, { 0xE9, 0x9E, 0x8B },
	0xbe64, { 0xE9, 0x9E, 0x8F },
	0xbe65, { 0xE9, 0xA0, 0xA1 },
	0xbe66, { 0xE9, 0xA0, 0xAB },
	0xbe67, { 0xE9, 0xA0, 0x9C },
	0xbe68, { 0xE9, 0xA2, 0xB3 },
	0xbe69, { 0xE9, 0xA4, 0x8A },
	0xbe6a, { 0xE9, 0xA4, 0x93 },
	0xbe6b, { 0xE9, 0xA4, 0x92 },
	0xbe6c, { 0xE9, 0xA4, 0x98 },
	0xbe6d, { 0xE9, 0xA7, 0x9D },
	0xbe6e, { 0xE9, 0xA7, 0x90 },
	0xbe6f, { 0xE9, 0xA7, 0x9F },
	0xbe70, { 0xE9, 0xA7, 0x9B },
	0xbe71, { 0xE9, 0xA7, 0x91 },
	0xbe72, { 0xE9, 0xA7, 0x95 },
	0xbe73, { 0xE9, 0xA7, 0x92 },
	0xbe74, { 0xE9, 0xA7, 0x99 },
	0xbe75, { 0xE9, 0xAA, 0xB7 },
	0xbe76, { 0xE9, 0xAB, 0xAE },
	0xbe77, { 0xE9, 0xAB, 0xAF },
	0xbe78, { 0xE9, 0xAC, 0xA7 },
	0xbe79, { 0xE9, 0xAD, 0x85 },
	0xbe7a, { 0xE9, 0xAD, 0x84 },
	0xbe7b, { 0xE9, 0xAD, 0xB7 },
	0xbe7c, { 0xE9, 0xAD, 0xAF },
	0xbe7d, { 0xE9, 0xB4, 0x86 },
	0xbe7e, { 0xE9, 0xB4, 0x89 },
	0xbea1, { 0xE9, 0xB4, 0x83 },
	0xbea2, { 0xE9, 0xBA, 0xA9 },
	0xbea3, { 0xE9, 0xBA, 0xBE },
	0xbea4, { 0xE9, 0xBB, 0x8E },
	0xbea5, { 0xE5, 0xA2, 0xA8 },
	0xbea6, { 0xE9, 0xBD, 0x92 },
	0xbea7, { 0xE5, 0x84, 0x92 },
	0xbea8, { 0xE5, 0x84, 0x98 },
	0xbea9, { 0xE5, 0x84, 0x94 },
	0xbeaa, { 0xE5, 0x84, 0x90 },
	0xbeab, { 0xE5, 0x84, 0x95 },
	0xbeac, { 0xE5, 0x86, 0x80 },
	0xbead, { 0xE5, 0x86, 0xAA },
	0xbeae, { 0xE5, 0x87, 0x9D },
	0xbeaf, { 0xE5, 0x8A, 0x91 },
	0xbeb0, { 0xE5, 0x8A, 0x93 },
	0xbeb1, { 0xE5, 0x8B, 0xB3 },
	0xbeb2, { 0xE5, 0x99, 0x99 },
	0xbeb3, { 0xE5, 0x99, 0xAB },
	0xbeb4, { 0xE5, 0x99, 0xB9 },
	0xbeb5, { 0xE5, 0x99, 0xA9 },
	0xbeb6, { 0xE5, 0x99, 0xA4 },
	0xbeb7, { 0xE5, 0x99, 0xB8 },
	0xbeb8, { 0xE5, 0x99, 0xAA },
	0xbeb9, { 0xE5, 0x99, 0xA8 },
	0xbeba, { 0xE5, 0x99, 0xA5 },
	0xbebb, { 0xE5, 0x99, 0xB1 },
	0xbebc, { 0xE5, 0x99, 0xAF },
	0xbebd, { 0xE5, 0x99, 0xAC },
	0xbebe, { 0xE5, 0x99, 0xA2 },
	0xbebf, { 0xE5, 0x99, 0xB6 },
	0xbec0, { 0xE5, 0xA3, 0x81 },
	0xbec1, { 0xE5, 0xA2, 0xBE },
	0xbec2, { 0xE5, 0xA3, 0x87 },
	0xbec3, { 0xE5, 0xA3, 0x85 },
	0xbec4, { 0xE5, 0xA5, 0xAE },
	0xbec5, { 0xE5, 0xAC, 0x9D },
	0xbec6, { 0xE5, 0xAC, 0xB4 },
	0xbec7, { 0xE5, 0xAD, 0xB8 },
	0xbec8, { 0xE5, 0xAF, 0xB0 },
	0xbec9, { 0xE5, 0xB0, 0x8E },
	0xbeca, { 0xE5, 0xBD, 0x8A },
	0xbecb, { 0xE6, 0x86, 0xB2 },
	0xbecc, { 0xE6, 0x86, 0x91 },
	0xbecd, { 0xE6, 0x86, 0xA9 },
	0xbece, { 0xE6, 0x86, 0x8A },
	0xbecf, { 0xE6, 0x87, 0x8D },
	0xbed0, { 0xE6, 0x86, 0xB6 },
	0xbed1, { 0xE6, 0x86, 0xBE },
	0xbed2, { 0xE6, 0x87, 0x8A },
	0xbed3, { 0xE6, 0x87, 0x88 },
	0xbed4, { 0xE6, 0x88, 0xB0 },
	0xbed5, { 0xE6, 0x93, 0x85 },
	0xbed6, { 0xE6, 0x93, 0x81 },
	0xbed7, { 0xE6, 0x93, 0x8B },
	0xbed8, { 0xE6, 0x92, 0xBB },
	0xbed9, { 0xE6, 0x92, 0xBC },
	0xbeda, { 0xE6, 0x93, 0x9A },
	0xbedb, { 0xE6, 0x93, 0x84 },
	0xbedc, { 0xE6, 0x93, 0x87 },
	0xbedd, { 0xE6, 0x93, 0x82 },
	0xbede, { 0xE6, 0x93, 0x8D },
	0xbedf, { 0xE6, 0x92, 0xBF },
	0xbee0, { 0xE6, 0x93, 0x92 },
	0xbee1, { 0xE6, 0x93, 0x94 },
	0xbee2, { 0xE6, 0x92, 0xBE },
	0xbee3, { 0xE6, 0x95, 0xB4 },
	0xbee4, { 0xE6, 0x9B, 0x86 },
	0xbee5, { 0xE6, 0x9B, 0x89 },
	0xbee6, { 0xE6, 0x9A, 0xB9 },
	0xbee7, { 0xE6, 0x9B, 0x84 },
	0xbee8, { 0xE6, 0x9B, 0x87 },
	0xbee9, { 0xE6, 0x9A, 0xB8 },
	0xbeea, { 0xE6, 0xA8, 0xBD },
	0xbeeb, { 0xE6, 0xA8, 0xB8 },
	0xbeec, { 0xE6, 0xA8, 0xBA },
	0xbeed, { 0xE6, 0xA9, 0x99 },
	0xbeee, { 0xE6, 0xA9, 0xAB },
	0xbeef, { 0xE6, 0xA9, 0x98 },
	0xbef0, { 0xE6, 0xA8, 0xB9 },
	0xbef1, { 0xE6, 0xA9, 0x84 },
	0xbef2, { 0xE6, 0xA9, 0xA2 },
	0xbef3, { 0xE6, 0xA9, 0xA1 },
	0xbef4, { 0xE6, 0xA9, 0x8B },
	0xbef5, { 0xE6, 0xA9, 0x87 },
	0xbef6, { 0xE6, 0xA8, 0xB5 },
	0xbef7, { 0xE6, 0xA9, 0x9F },
	0xbef8, { 0xE6, 0xA9, 0x88 },
	0xbef9, { 0xE6, 0xAD, 0x99 },
	0xbefa, { 0xE6, 0xAD, 0xB7 },
	0xbefb, { 0xE6, 0xB0, 0x85 },
	0xbefc, { 0xE6, 0xBF, 0x82 },
	0xbefd, { 0xE6, 0xBE, 0xB1 },
	0xbefe, { 0xE6, 0xBE, 0xA1 },
	0xbf40, { 0xE6, 0xBF, 0x83 },
	0xbf41, { 0xE6, 0xBE, 0xA4 },
	0xbf42, { 0xE6, 0xBF, 0x81 },
	0xbf43, { 0xE6, 0xBE, 0xA7 },
	0xbf44, { 0xE6, 0xBE, 0xB3 },
	0xbf45, { 0xE6, 0xBF, 0x80 },
	0xbf46, { 0xE6, 0xBE, 0xB9 },
	0xbf47, { 0xE6, 0xBE, 0xB6 },
	0xbf48, { 0xE6, 0xBE, 0xA6 },
	0xbf49, { 0xE6, 0xBE, 0xA0 },
	0xbf4a, { 0xE6, 0xBE, 0xB4 },
	0xbf4b, { 0xE7, 0x86, 0xBE },
	0xbf4c, { 0xE7, 0x87, 0x89 },
	0xbf4d, { 0xE7, 0x87, 0x90 },
	0xbf4e, { 0xE7, 0x87, 0x92 },
	0xbf4f, { 0xE7, 0x87, 0x88 },
	0xbf50, { 0xE7, 0x87, 0x95 },
	0xbf51, { 0xE7, 0x86, 0xB9 },
	0xbf52, { 0xE7, 0x87, 0x8E },
	0xbf53, { 0xE7, 0x87, 0x99 },
	0xbf54, { 0xE7, 0x87, 0x9C },
	0xbf55, { 0xE7, 0x87, 0x83 },
	0xbf56, { 0xE7, 0x87, 0x84 },
	0xbf57, { 0xE7, 0x8D, 0xA8 },
	0xbf58, { 0xE7, 0x92, 0x9C },
	0xbf59, { 0xE7, 0x92, 0xA3 },
	0xbf5a, { 0xE7, 0x92, 0x98 },
	0xbf5b, { 0xE7, 0x92, 0x9F },
	0xbf5c, { 0xE7, 0x92, 0x9E },
	0xbf5d, { 0xE7, 0x93, 0xA2 },
	0xbf5e, { 0xE7, 0x94, 0x8C },
	0xbf5f, { 0xE7, 0x94, 0x8D },
	0xbf60, { 0xE7, 0x98, 0xB4 },
	0xbf61, { 0xE7, 0x98, 0xB8 },
	0xbf62, { 0xE7, 0x98, 0xBA },
	0xbf63, { 0xE7, 0x9B, 0xA7 },
	0xbf64, { 0xE7, 0x9B, 0xA5 },
	0xbf65, { 0xE7, 0x9E, 0xA0 },
	0xbf66, { 0xE7, 0x9E, 0x9E },
	0xbf67, { 0xE7, 0x9E, 0x9F },
	0xbf68, { 0xE7, 0x9E, 0xA5 },
	0xbf69, { 0xE7, 0xA3, 0xA8 },
	0xbf6a, { 0xE7, 0xA3, 0x9A },
	0xbf6b, { 0xE7, 0xA3, 0xAC },
	0xbf6c, { 0xE7, 0xA3, 0xA7 },
	0xbf6d, { 0xE7, 0xA6, 0xA6 },
	0xbf6e, { 0xE7, 0xA9, 0x8D },
	0xbf6f, { 0xE7, 0xA9, 0x8E },
	0xbf70, { 0xE7, 0xA9, 0x86 },
	0xbf71, { 0xE7, 0xA9, 0x8C },
	0xbf72, { 0xE7, 0xA9, 0x8B },
	0xbf73, { 0xE7, 0xAA, 0xBA },
	0xbf74, { 0xE7, 0xAF, 0x99 },
	0xbf75, { 0xE7, 0xB0, 0x91 },
	0xbf76, { 0xE7, 0xAF, 0x89 },
	0xbf77, { 0xE7, 0xAF, 0xA4 },
	0xbf78, { 0xE7, 0xAF, 0x9B },
	0xbf79, { 0xE7, 0xAF, 0xA1 },
	0xbf7a, { 0xE7, 0xAF, 0xA9 },
	0xbf7b, { 0xE7, 0xAF, 0xA6 },
	0xbf7c, { 0xE7, 0xB3, 0x95 },
	0xbf7d, { 0xE7, 0xB3, 0x96 },
	0xbf7e, { 0xE7, 0xB8, 0x8A },
	0xbfa1, { 0xE7, 0xB8, 0x91 },
	0xbfa2, { 0xE7, 0xB8, 0x88 },
	0xbfa3, { 0xE7, 0xB8, 0x9B },
	0xbfa4, { 0xE7, 0xB8, 0xA3 },
	0xbfa5, { 0xE7, 0xB8, 0x9E },
	0xbfa6, { 0xE7, 0xB8, 0x9D },
	0xbfa7, { 0xE7, 0xB8, 0x89 },
	0xbfa8, { 0xE7, 0xB8, 0x90 },
	0xbfa9, { 0xE7, 0xBD, 0xB9 },
	0xbfaa, { 0xE7, 0xBE, 0xB2 },
	0xbfab, { 0xE7, 0xBF, 0xB0 },
	0xbfac, { 0xE7, 0xBF, 0xB1 },
	0xbfad, { 0xE7, 0xBF, 0xAE },
	0xbfae, { 0xE8, 0x80, 0xA8 },
	0xbfaf, { 0xE8, 0x86, 0xB3 },
	0xbfb0, { 0xE8, 0x86, 0xA9 },
	0xbfb1, { 0xE8, 0x86, 0xA8 },
	0xbfb2, { 0xE8, 0x87, 0xBB },
	0xbfb3, { 0xE8, 0x88, 0x88 },
	0xbfb4, { 0xE8, 0x89, 0x98 },
	0xbfb5, { 0xE8, 0x89, 0x99 },
	0xbfb6, { 0xE8, 0x95, 0x8A },
	0xbfb7, { 0xE8, 0x95, 0x99 },
	0xbfb8, { 0xE8, 0x95, 0x88 },
	0xbfb9, { 0xE8, 0x95, 0xA8 },
	0xbfba, { 0xE8, 0x95, 0xA9 },
	0xbfbb, { 0xE8, 0x95, 0x83 },
	0xbfbc, { 0xE8, 0x95, 0x89 },
	0xbfbd, { 0xE8, 0x95, 0xAD },
	0xbfbe, { 0xE8, 0x95, 0xAA },
	0xbfbf, { 0xE8, 0x95, 0x9E },
	0xbfc0, { 0xE8, 0x9E, 0x83 },
	0xbfc1, { 0xE8, 0x9E, 0x9F },
	0xbfc2, { 0xE8, 0x9E, 0x9E },
	0xbfc3, { 0xE8, 0x9E, 0xA2 },
	0xbfc4, { 0xE8, 0x9E, 0x8D },
	0xbfc5, { 0xE8, 0xA1, 0xA1 },
	0xbfc6, { 0xE8, 0xA4, 0xAA },
	0xbfc7, { 0xE8, 0xA4, 0xB2 },
	0xbfc8, { 0xE8, 0xA4, 0xA5 },
	0xbfc9, { 0xE8, 0xA4, 0xAB },
	0xbfca, { 0xE8, 0xA4, 0xA1 },
	0xbfcb, { 0xE8, 0xA6, 0xAA },
	0xbfcc, { 0xE8, 0xA6, 0xA6 },
	0xbfcd, { 0xE8, 0xAB, 0xA6 },
	0xbfce, { 0xE8, 0xAB, 0xBA },
	0xbfcf, { 0xE8, 0xAB, 0xAB },
	0xbfd0, { 0xE8, 0xAB, 0xB1 },
	0xbfd1, { 0xE8, 0xAC, 0x80 },
	0xbfd2, { 0xE8, 0xAB, 0x9C },
	0xbfd3, { 0xE8, 0xAB, 0xA7 },
	0xbfd4, { 0xE8, 0xAB, 0xAE },
	0xbfd5, { 0xE8, 0xAB, 0xBE },
	0xbfd6, { 0xE8, 0xAC, 0x81 },
	0xbfd7, { 0xE8, 0xAC, 0x82 },
	0xbfd8, { 0xE8, 0xAB, 0xB7 },
	0xbfd9, { 0xE8, 0xAB, 0xAD },
	0xbfda, { 0xE8, 0xAB, 0xB3 },
	0xbfdb, { 0xE8, 0xAB, 0xB6 },
	0xbfdc, { 0xE8, 0xAB, 0xBC },
	0xbfdd, { 0xE8, 0xB1, 0xAB },
	0xbfde, { 0xE8, 0xB1, 0xAD },
	0xbfdf, { 0xE8, 0xB2, 0x93 },
	0xbfe0, { 0xE8, 0xB3, 0xB4 },
	0xbfe1, { 0xE8, 0xB9, 0x84 },
	0xbfe2, { 0xE8, 0xB8, 0xB1 },
	0xbfe3, { 0xE8, 0xB8, 0xB4 },
	0xbfe4, { 0xE8, 0xB9, 0x82 },
	0xbfe5, { 0xE8, 0xB8, 0xB9 },
	0xbfe6, { 0xE8, 0xB8, 0xB5 },
	0xbfe7, { 0xE8, 0xBC, 0xBB },
	0xbfe8, { 0xE8, 0xBC, 0xAF },
	0xbfe9, { 0xE8, 0xBC, 0xB8 },
	0xbfea, { 0xE8, 0xBC, 0xB3 },
	0xbfeb, { 0xE8, 0xBE, 0xA8 },
	0xbfec, { 0xE8, 0xBE, 0xA6 },
	0xbfed, { 0xE9, 0x81, 0xB5 },
	0xbfee, { 0xE9, 0x81, 0xB4 },
	0xbfef, { 0xE9, 0x81, 0xB8 },
	0xbff0, { 0xE9, 0x81, 0xB2 },
	0xbff1, { 0xE9, 0x81, 0xBC },
	0xbff2, { 0xE9, 0x81, 0xBA },
	0xbff3, { 0xE9, 0x84, 0xB4 },
	0xbff4, { 0xE9, 0x86, 0x92 },
	0xbff5, { 0xE9, 0x8C, 0xA0 },
	0xbff6, { 0xE9, 0x8C, 0xB6 },
	0xbff7, { 0xE9, 0x8B, 0xB8 },
	0xbff8, { 0xE9, 0x8C, 0xB3 },
	0xbff9, { 0xE9, 0x8C, 0xAF },
	0xbffa, { 0xE9, 0x8C, 0xA2 },
	0xbffb, { 0xE9, 0x8B, 0xBC },
	0xbffc, { 0xE9, 0x8C, 0xAB },
	0xbffd, { 0xE9, 0x8C, 0x84 },
	0xbffe, { 0xE9, 0x8C, 0x9A },
	0xc040, { 0xE9, 0x8C, 0x90 },
	0xc041, { 0xE9, 0x8C, 0xA6 },
	0xc042, { 0xE9, 0x8C, 0xA1 },
	0xc043, { 0xE9, 0x8C, 0x95 },
	0xc044, { 0xE9, 0x8C, 0xAE },
	0xc045, { 0xE9, 0x8C, 0x99 },
	0xc046, { 0xE9, 0x96, 0xBB },
	0xc047, { 0xE9, 0x9A, 0xA7 },
	0xc048, { 0xE9, 0x9A, 0xA8 },
	0xc049, { 0xE9, 0x9A, 0xAA },
	0xc04a, { 0xE9, 0x9B, 0x95 },
	0xc04b, { 0xE9, 0x9C, 0x8E },
	0xc04c, { 0xE9, 0x9C, 0x91 },
	0xc04d, { 0xE9, 0x9C, 0x96 },
	0xc04e, { 0xE9, 0x9C, 0x8D },
	0xc04f, { 0xE9, 0x9C, 0x93 },
	0xc050, { 0xE9, 0x9C, 0x8F },
	0xc051, { 0xE9, 0x9D, 0x9B },
	0xc052, { 0xE9, 0x9D, 0x9C },
	0xc053, { 0xE9, 0x9D, 0xA6 },
	0xc054, { 0xE9, 0x9E, 0x98 },
	0xc055, { 0xE9, 0xA0, 0xB0 },
	0xc056, { 0xE9, 0xA0, 0xB8 },
	0xc057, { 0xE9, 0xA0, 0xBB },
	0xc058, { 0xE9, 0xA0, 0xB7 },
	0xc059, { 0xE9, 0xA0, 0xAD },
	0xc05a, { 0xE9, 0xA0, 0xB9 },
	0xc05b, { 0xE9, 0xA0, 0xA4 },
	0xc05c, { 0xE9, 0xA4, 0x90 },
	0xc05d, { 0xE9, 0xA4, 0xA8 },
	0xc05e, { 0xE9, 0xA4, 0x9E },
	0xc05f, { 0xE9, 0xA4, 0x9B },
	0xc060, { 0xE9, 0xA4, 0xA1 },
	0xc061, { 0xE9, 0xA4, 0x9A },
	0xc062, { 0xE9, 0xA7, 0xAD },
	0xc063, { 0xE9, 0xA7, 0xA2 },
	0xc064, { 0xE9, 0xA7, 0xB1 },
	0xc065, { 0xE9, 0xAA, 0xB8 },
	0xc066, { 0xE9, 0xAA, 0xBC },
	0xc067, { 0xE9, 0xAB, 0xBB },
	0xc068, { 0xE9, 0xAB, 0xAD },
	0xc069, { 0xE9, 0xAC, 0xA8 },
	0xc06a, { 0xE9, 0xAE, 0x91 },
	0xc06b, { 0xE9, 0xB4, 0x95 },
	0xc06c, { 0xE9, 0xB4, 0xA3 },
	0xc06d, { 0xE9, 0xB4, 0xA6 },
	0xc06e, { 0xE9, 0xB4, 0xA8 },
	0xc06f, { 0xE9, 0xB4, 0x92 },
	0xc070, { 0xE9, 0xB4, 0x9B },
	0xc071, { 0xE9, 0xBB, 0x98 },
	0xc072, { 0xE9, 0xBB, 0x94 },
	0xc073, { 0xE9, 0xBE, 0x8D },
	0xc074, { 0xE9, 0xBE, 0x9C },
	0xc075, { 0xE5, 0x84, 0xAA },
	0xc076, { 0xE5, 0x84, 0x9F },
	0xc077, { 0xE5, 0x84, 0xA1 },
	0xc078, { 0xE5, 0x84, 0xB2 },
	0xc079, { 0xE5, 0x8B, 0xB5 },
	0xc07a, { 0xE5, 0x9A, 0x8E },
	0xc07b, { 0xE5, 0x9A, 0x80 },
	0xc07c, { 0xE5, 0x9A, 0x90 },
	0xc07d, { 0xE5, 0x9A, 0x85 },
	0xc07e, { 0xE5, 0x9A, 0x87 },
	0xc0a1, { 0xE5, 0x9A, 0x8F },
	0xc0a2, { 0xE5, 0xA3, 0x95 },
	0xc0a3, { 0xE5, 0xA3, 0x93 },
	0xc0a4, { 0xE5, 0xA3, 0x91 },
	0xc0a5, { 0xE5, 0xA3, 0x8E },
	0xc0a6, { 0xE5, 0xAC, 0xB0 },
	0xc0a7, { 0xE5, 0xAC, 0xAA },
	0xc0a8, { 0xE5, 0xAC, 0xA4 },
	0xc0a9, { 0xE5, 0xAD, 0xBA },
	0xc0aa, { 0xE5, 0xB0, 0xB7 },
	0xc0ab, { 0xE5, 0xB1, 0xA8 },
	0xc0ac, { 0xE5, 0xB6, 0xBC },
	0xc0ad, { 0xE5, 0xB6, 0xBA },
	0xc0ae, { 0xE5, 0xB6, 0xBD },
	0xc0af, { 0xE5, 0xB6, 0xB8 },
	0xc0b0, { 0xE5, 0xB9, 0xAB },
	0xc0b1, { 0xE5, 0xBD, 0x8C },
	0xc0b2, { 0xE5, 0xBE, 0xBD },
	0xc0b3, { 0xE6, 0x87, 0x89 },
	0xc0b4, { 0xE6, 0x87, 0x82 },
	0xc0b5, { 0xE6, 0x87, 0x87 },
	0xc0b6, { 0xE6, 0x87, 0xA6 },
	0xc0b7, { 0xE6, 0x87, 0x8B },
	0xc0b8, { 0xE6, 0x88, 0xB2 },
	0xc0b9, { 0xE6, 0x88, 0xB4 },
	0xc0ba, { 0xE6, 0x93, 0x8E },
	0xc0bb, { 0xE6, 0x93, 0x8A },
	0xc0bc, { 0xE6, 0x93, 0x98 },
	0xc0bd, { 0xE6, 0x93, 0xA0 },
	0xc0be, { 0xE6, 0x93, 0xB0 },
	0xc0bf, { 0xE6, 0x93, 0xA6 },
	0xc0c0, { 0xE6, 0x93, 0xAC },
	0xc0c1, { 0xE6, 0x93, 0xB1 },
	0xc0c2, { 0xE6, 0x93, 0xA2 },
	0xc0c3, { 0xE6, 0x93, 0xAD },
	0xc0c4, { 0xE6, 0x96, 0x82 },
	0xc0c5, { 0xE6, 0x96, 0x83 },
	0xc0c6, { 0xE6, 0x9B, 0x99 },
	0xc0c7, { 0xE6, 0x9B, 0x96 },
	0xc0c8, { 0xE6, 0xAA, 0x80 },
	0xc0c9, { 0xE6, 0xAA, 0x94 },
	0xc0ca, { 0xE6, 0xAA, 0x84 },
	0xc0cb, { 0xE6, 0xAA, 0xA2 },
	0xc0cc, { 0xE6, 0xAA, 0x9C },
	0xc0cd, { 0xE6, 0xAB, 0x9B },
	0xc0ce, { 0xE6, 0xAA, 0xA3 },
	0xc0cf, { 0xE6, 0xA9, 0xBE },
	0xc0d0, { 0xE6, 0xAA, 0x97 },
	0xc0d1, { 0xE6, 0xAA, 0x90 },
	0xc0d2, { 0xE6, 0xAA, 0xA0 },
	0xc0d3, { 0xE6, 0xAD, 0x9C },
	0xc0d4, { 0xE6, 0xAE, 0xAE },
	0xc0d5, { 0xE6, 0xAF, 0x9A },
	0xc0d6, { 0xE6, 0xB0, 0x88 },
	0xc0d7, { 0xE6, 0xBF, 0x98 },
	0xc0d8, { 0xE6, 0xBF, 0xB1 },
	0xc0d9, { 0xE6, 0xBF, 0x9F },
	0xc0da, { 0xE6, 0xBF, 0xA0 },
	0xc0db, { 0xE6, 0xBF, 0x9B },
	0xc0dc, { 0xE6, 0xBF, 0xA4 },
	0xc0dd, { 0xE6, 0xBF, 0xAB },
	0xc0de, { 0xE6, 0xBF, 0xAF },
	0xc0df, { 0xE6, 0xBE, 0x80 },
	0xc0e0, { 0xE6, 0xBF, 0xAC },
	0xc0e1, { 0xE6, 0xBF, 0xA1 },
	0xc0e2, { 0xE6, 0xBF, 0xA9 },
	0xc0e3, { 0xE6, 0xBF, 0x95 },
	0xc0e4, { 0xE6, 0xBF, 0xAE },
	0xc0e5, { 0xE6, 0xBF, 0xB0 },
	0xc0e6, { 0xE7, 0x87, 0xA7 },
	0xc0e7, { 0xE7, 0x87, 0x9F },
	0xc0e8, { 0xE7, 0x87, 0xAE },
	0xc0e9, { 0xE7, 0x87, 0xA6 },
	0xc0ea, { 0xE7, 0x87, 0xA5 },
	0xc0eb, { 0xE7, 0x87, 0xAD },
	0xc0ec, { 0xE7, 0x87, 0xAC },
	0xc0ed, { 0xE7, 0x87, 0xB4 },
	0xc0ee, { 0xE7, 0x87, 0xA0 },
	0xc0ef, { 0xE7, 0x88, 0xB5 },
	0xc0f0, { 0xE7, 0x89, 0x86 },
	0xc0f1, { 0xE7, 0x8D, 0xB0 },
	0xc0f2, { 0xE7, 0x8D, 0xB2 },
	0xc0f3, { 0xE7, 0x92, 0xA9 },
	0xc0f4, { 0xE7, 0x92, 0xB0 },
	0xc0f5, { 0xE7, 0x92, 0xA6 },
	0xc0f6, { 0xE7, 0x92, 0xA8 },
	0xc0f7, { 0xE7, 0x99, 0x86 },
	0xc0f8, { 0xE7, 0x99, 0x82 },
	0xc0f9, { 0xE7, 0x99, 0x8C },
	0xc0fa, { 0xE7, 0x9B, 0xAA },
	0xc0fb, { 0xE7, 0x9E, 0xB3 },
	0xc0fc, { 0xE7, 0x9E, 0xAA },
	0xc0fd, { 0xE7, 0x9E, 0xB0 },
	0xc0fe, { 0xE7, 0x9E, 0xAC },
	0xc140, { 0xE7, 0x9E, 0xA7 },
	0xc141, { 0xE7, 0x9E, 0xAD },
	0xc142, { 0xE7, 0x9F, 0xAF },
	0xc143, { 0xE7, 0xA3, 0xB7 },
	0xc144, { 0xE7, 0xA3, 0xBA },
	0xc145, { 0xE7, 0xA3, 0xB4 },
	0xc146, { 0xE7, 0xA3, 0xAF },
	0xc147, { 0xE7, 0xA4, 0x81 },
	0xc148, { 0xE7, 0xA6, 0xA7 },
	0xc149, { 0xE7, 0xA6, 0xAA },
	0xc14a, { 0xE7, 0xA9, 0x97 },
	0xc14b, { 0xE7, 0xAA, 0xBF },
	0xc14c, { 0xE7, 0xB0, 0x87 },
	0xc14d, { 0xE7, 0xB0, 0x8D },
	0xc14e, { 0xE7, 0xAF, 0xBE },
	0xc14f, { 0xE7, 0xAF, 0xB7 },
	0xc150, { 0xE7, 0xB0, 0x8C },
	0xc151, { 0xE7, 0xAF, 0xA0 },
	0xc152, { 0xE7, 0xB3, 0xA0 },
	0xc153, { 0xE7, 0xB3, 0x9C },
	0xc154, { 0xE7, 0xB3, 0x9E },
	0xc155, { 0xE7, 0xB3, 0xA2 },
	0xc156, { 0xE7, 0xB3, 0x9F },
	0xc157, { 0xE7, 0xB3, 0x99 },
	0xc158, { 0xE7, 0xB3, 0x9D },
	0xc159, { 0xE7, 0xB8, 0xAE },
	0xc15a, { 0xE7, 0xB8, 0xBE },
	0xc15b, { 0xE7, 0xB9, 0x86 },
	0xc15c, { 0xE7, 0xB8, 0xB7 },
	0xc15d, { 0xE7, 0xB8, 0xB2 },
	0xc15e, { 0xE7, 0xB9, 0x83 },
	0xc15f, { 0xE7, 0xB8, 0xAB },
	0xc160, { 0xE7, 0xB8, 0xBD },
	0xc161, { 0xE7, 0xB8, 0xB1 },
	0xc162, { 0xE7, 0xB9, 0x85 },
	0xc163, { 0xE7, 0xB9, 0x81 },
	0xc164, { 0xE7, 0xB8, 0xB4 },
	0xc165, { 0xE7, 0xB8, 0xB9 },
	0xc166, { 0xE7, 0xB9, 0x88 },
	0xc167, { 0xE7, 0xB8, 0xB5 },
	0xc168, { 0xE7, 0xB8, 0xBF },
	0xc169, { 0xE7, 0xB8, 0xAF },
	0xc16a, { 0xE7, 0xBD, 0x84 },
	0xc16b, { 0xE7, 0xBF, 0xB3 },
	0xc16c, { 0xE7, 0xBF, 0xBC },
	0xc16d, { 0xE8, 0x81, 0xB1 },
	0xc16e, { 0xE8, 0x81, 0xB2 },
	0xc16f, { 0xE8, 0x81, 0xB0 },
	0xc170, { 0xE8, 0x81, 0xAF },
	0xc171, { 0xE8, 0x81, 0xB3 },
	0xc172, { 0xE8, 0x87, 0x86 },
	0xc173, { 0xE8, 0x87, 0x83 },
	0xc174, { 0xE8, 0x86, 0xBA },
	0xc175, { 0xE8, 0x87, 0x82 },
	0xc176, { 0xE8, 0x87, 0x80 },
	0xc177, { 0xE8, 0x86, 0xBF },
	0xc178, { 0xE8, 0x86, 0xBD },
	0xc179, { 0xE8, 0x87, 0x89 },
	0xc17a, { 0xE8, 0x86, 0xBE },
	0xc17b, { 0xE8, 0x87, 0xA8 },
	0xc17c, { 0xE8, 0x88, 0x89 },
	0xc17d, { 0xE8, 0x89, 0xB1 },
	0xc17e, { 0xE8, 0x96, 0xAA },
	0xc1a1, { 0xE8, 0x96, 0x84 },
	0xc1a2, { 0xE8, 0x95, 0xBE },
	0xc1a3, { 0xE8, 0x96, 0x9C },
	0xc1a4, { 0xE8, 0x96, 0x91 },
	0xc1a5, { 0xE8, 0x96, 0x94 },
	0xc1a6, { 0xE8, 0x96, 0xAF },
	0xc1a7, { 0xE8, 0x96, 0x9B },
	0xc1a8, { 0xE8, 0x96, 0x87 },
	0xc1a9, { 0xE8, 0x96, 0xA8 },
	0xc1aa, { 0xE8, 0x96, 0x8A },
	0xc1ab, { 0xE8, 0x99, 0xA7 },
	0xc1ac, { 0xE8, 0x9F, 0x80 },
	0xc1ad, { 0xE8, 0x9F, 0x91 },
	0xc1ae, { 0xE8, 0x9E, 0xB3 },
	0xc1af, { 0xE8, 0x9F, 0x92 },
	0xc1b0, { 0xE8, 0x9F, 0x86 },
	0xc1b1, { 0xE8, 0x9E, 0xAB },
	0xc1b2, { 0xE8, 0x9E, 0xBB },
	0xc1b3, { 0xE8, 0x9E, 0xBA },
	0xc1b4, { 0xE8, 0x9F, 0x88 },
	0xc1b5, { 0xE8, 0x9F, 0x8B },
	0xc1b6, { 0xE8, 0xA4, 0xBB },
	0xc1b7, { 0xE8, 0xA4, 0xB6 },
	0xc1b8, { 0xE8, 0xA5, 0x84 },
	0xc1b9, { 0xE8, 0xA4, 0xB8 },
	0xc1ba, { 0xE8, 0xA4, 0xBD },
	0xc1bb, { 0xE8, 0xA6, 0xAC },
	0xc1bc, { 0xE8, 0xAC, 0x8E },
	0xc1bd, { 0xE8, 0xAC, 0x97 },
	0xc1be, { 0xE8, 0xAC, 0x99 },
	0xc1bf, { 0xE8, 0xAC, 0x9B },
	0xc1c0, { 0xE8, 0xAC, 0x8A },
	0xc1c1, { 0xE8, 0xAC, 0xA0 },
	0xc1c2, { 0xE8, 0xAC, 0x9D },
	0xc1c3, { 0xE8, 0xAC, 0x84 },
	0xc1c4, { 0xE8, 0xAC, 0x90 },
	0xc1c5, { 0xE8, 0xB1, 0x81 },
	0xc1c6, { 0xE8, 0xB0, 0xBF },
	0xc1c7, { 0xE8, 0xB1, 0xB3 },
	0xc1c8, { 0xE8, 0xB3, 0xBA },
	0xc1c9, { 0xE8, 0xB3, 0xBD },
	0xc1ca, { 0xE8, 0xB3, 0xBC },
	0xc1cb, { 0xE8, 0xB3, 0xB8 },
	0xc1cc, { 0xE8, 0xB3, 0xBB },
	0xc1cd, { 0xE8, 0xB6, 0xA8 },
	0xc1ce, { 0xE8, 0xB9, 0x89 },
	0xc1cf, { 0xE8, 0xB9, 0x8B },
	0xc1d0, { 0xE8, 0xB9, 0x88 },
	0xc1d1, { 0xE8, 0xB9, 0x8A },
	0xc1d2, { 0xE8, 0xBD, 0x84 },
	0xc1d3, { 0xE8, 0xBC, 0xBE },
	0xc1d4, { 0xE8, 0xBD, 0x82 },
	0xc1d5, { 0xE8, 0xBD, 0x85 },
	0xc1d6, { 0xE8, 0xBC, 0xBF },
	0xc1d7, { 0xE9, 0x81, 0xBF },
	0xc1d8, { 0xE9, 0x81, 0xBD },
	0xc1d9, { 0xE9, 0x82, 0x84 },
	0xc1da, { 0xE9, 0x82, 0x81 },
	0xc1db, { 0xE9, 0x82, 0x82 },
	0xc1dc, { 0xE9, 0x82, 0x80 },
	0xc1dd, { 0xE9, 0x84, 0xB9 },
	0xc1de, { 0xE9, 0x86, 0xA3 },
	0xc1df, { 0xE9, 0x86, 0x9E },
	0xc1e0, { 0xE9, 0x86, 0x9C },
	0xc1e1, { 0xE9, 0x8D, 0x8D },
	0xc1e2, { 0xE9, 0x8E, 0x82 },
	0xc1e3, { 0xE9, 0x8C, 0xA8 },
	0xc1e4, { 0xE9, 0x8D, 0xB5 },
	0xc1e5, { 0xE9, 0x8D, 0x8A },
	0xc1e6, { 0xE9, 0x8D, 0xA5 },
	0xc1e7, { 0xE9, 0x8D, 0x8B },
	0xc1e8, { 0xE9, 0x8C, 0x98 },
	0xc1e9, { 0xE9, 0x8D, 0xBE },
	0xc1ea, { 0xE9, 0x8D, 0xAC },
	0xc1eb, { 0xE9, 0x8D, 0x9B },
	0xc1ec, { 0xE9, 0x8D, 0xB0 },
	0xc1ed, { 0xE9, 0x8D, 0x9A },
	0xc1ee, { 0xE9, 0x8D, 0x94 },
	0xc1ef, { 0xE9, 0x97, 0x8A },
	0xc1f0, { 0xE9, 0x97, 0x8B },
	0xc1f1, { 0xE9, 0x97, 0x8C },
	0xc1f2, { 0xE9, 0x97, 0x88 },
	0xc1f3, { 0xE9, 0x97, 0x86 },
	0xc1f4, { 0xE9, 0x9A, 0xB1 },
	0xc1f5, { 0xE9, 0x9A, 0xB8 },
	0xc1f6, { 0xE9, 0x9B, 0x96 },
	0xc1f7, { 0xE9, 0x9C, 0x9C },
	0xc1f8, { 0xE9, 0x9C, 0x9E },
	0xc1f9, { 0xE9, 0x9E, 0xA0 },
	0xc1fa, { 0xE9, 0x9F, 0x93 },
	0xc1fb, { 0xE9, 0xA1, 0x86 },
	0xc1fc, { 0xE9, 0xA2, 0xB6 },
	0xc1fd, { 0xE9, 0xA4, 0xB5 },
	0xc1fe, { 0xE9, 0xA8, 0x81 },
	0xc240, { 0xE9, 0xA7, 0xBF },
	0xc241, { 0xE9, 0xAE, 0xAE },
	0xc242, { 0xE9, 0xAE, 0xAB },
	0xc243, { 0xE9, 0xAE, 0xAA },
	0xc244, { 0xE9, 0xAE, 0xAD },
	0xc245, { 0xE9, 0xB4, 0xBB },
	0xc246, { 0xE9, 0xB4, 0xBF },
	0xc247, { 0xE9, 0xBA, 0x8B },
	0xc248, { 0xE9, 0xBB, 0x8F },
	0xc249, { 0xE9, 0xBB, 0x9E },
	0xc24a, { 0xE9, 0xBB, 0x9C },
	0xc24b, { 0xE9, 0xBB, 0x9D },
	0xc24c, { 0xE9, 0xBB, 0x9B },
	0xc24d, { 0xE9, 0xBC, 0xBE },
	0xc24e, { 0xE9, 0xBD, 0x8B },
	0xc24f, { 0xE5, 0x8F, 0xA2 },
	0xc250, { 0xE5, 0x9A, 0x95 },
	0xc251, { 0xE5, 0x9A, 0xAE },
	0xc252, { 0xE5, 0xA3, 0x99 },
	0xc253, { 0xE5, 0xA3, 0x98 },
	0xc254, { 0xE5, 0xAC, 0xB8 },
	0xc255, { 0xE5, 0xBD, 0x9D },
	0xc256, { 0xE6, 0x87, 0xA3 },
	0xc257, { 0xE6, 0x88, 0xB3 },
	0xc258, { 0xE6, 0x93, 0xB4 },
	0xc259, { 0xE6, 0x93, 0xB2 },
	0xc25a, { 0xE6, 0x93, 0xBE },
	0xc25b, { 0xE6, 0x94, 0x86 },
	0xc25c, { 0xE6, 0x93, 0xBA },
	0xc25d, { 0xE6, 0x93, 0xBB },
	0xc25e, { 0xE6, 0x93, 0xB7 },
	0xc25f, { 0xE6, 0x96, 0xB7 },
	0xc260, { 0xE6, 0x9B, 0x9C },
	0xc261, { 0xE6, 0x9C, 0xA6 },
	0xc262, { 0xE6, 0xAA, 0xB3 },
	0xc263, { 0xE6, 0xAA, 0xAC },
	0xc264, { 0xE6, 0xAB, 0x83 },
	0xc265, { 0xE6, 0xAA, 0xBB },
	0xc266, { 0xE6, 0xAA, 0xB8 },
	0xc267, { 0xE6, 0xAB, 0x82 },
	0xc268, { 0xE6, 0xAA, 0xAE },
	0xc269, { 0xE6, 0xAA, 0xAF },
	0xc26a, { 0xE6, 0xAD, 0x9F },
	0xc26b, { 0xE6, 0xAD, 0xB8 },
	0xc26c, { 0xE6, 0xAE, 0xAF },
	0xc26d, { 0xE7, 0x80, 0x89 },
	0xc26e, { 0xE7, 0x80, 0x8B },
	0xc26f, { 0xE6, 0xBF, 0xBE },
	0xc270, { 0xE7, 0x80, 0x86 },
	0xc271, { 0xE6, 0xBF, 0xBA },
	0xc272, { 0xE7, 0x80, 0x91 },
	0xc273, { 0xE7, 0x80, 0x8F },
	0xc274, { 0xE7, 0x87, 0xBB },
	0xc275, { 0xE7, 0x87, 0xBC },
	0xc276, { 0xE7, 0x87, 0xBE },
	0xc277, { 0xE7, 0x87, 0xB8 },
	0xc278, { 0xE7, 0x8D, 0xB7 },
	0xc279, { 0xE7, 0x8D, 0xB5 },
	0xc27a, { 0xE7, 0x92, 0xA7 },
	0xc27b, { 0xE7, 0x92, 0xBF },
	0xc27c, { 0xE7, 0x94, 0x95 },
	0xc27d, { 0xE7, 0x99, 0x96 },
	0xc27e, { 0xE7, 0x99, 0x98 },
	0xc2a1, { 0xE7, 0x99, 0x92 },
	0xc2a2, { 0xE7, 0x9E, 0xBD },
	0xc2a3, { 0xE7, 0x9E, 0xBF },
	0xc2a4, { 0xE7, 0x9E, 0xBB },
	0xc2a5, { 0xE7, 0x9E, 0xBC },
	0xc2a6, { 0xE7, 0xA4, 0x8E },
	0xc2a7, { 0xE7, 0xA6, 0xAE },
	0xc2a8, { 0xE7, 0xA9, 0xA1 },
	0xc2a9, { 0xE7, 0xA9, 0xA2 },
	0xc2aa, { 0xE7, 0xA9, 0xA0 },
	0xc2ab, { 0xE7, 0xAB, 0x84 },
	0xc2ac, { 0xE7, 0xAB, 0x85 },
	0xc2ad, { 0xE7, 0xB0, 0xAB },
	0xc2ae, { 0xE7, 0xB0, 0xA7 },
	0xc2af, { 0xE7, 0xB0, 0xAA },
	0xc2b0, { 0xE7, 0xB0, 0x9E },
	0xc2b1, { 0xE7, 0xB0, 0xA3 },
	0xc2b2, { 0xE7, 0xB0, 0xA1 },
	0xc2b3, { 0xE7, 0xB3, 0xA7 },
	0xc2b4, { 0xE7, 0xB9, 0x94 },
	0xc2b5, { 0xE7, 0xB9, 0x95 },
	0xc2b6, { 0xE7, 0xB9, 0x9E },
	0xc2b7, { 0xE7, 0xB9, 0x9A },
	0xc2b8, { 0xE7, 0xB9, 0xA1 },
	0xc2b9, { 0xE7, 0xB9, 0x92 },
	0xc2ba, { 0xE7, 0xB9, 0x99 },
	0xc2bb, { 0xE7, 0xBD, 0x88 },
	0xc2bc, { 0xE7, 0xBF, 0xB9 },
	0xc2bd, { 0xE7, 0xBF, 0xBB },
	0xc2be, { 0xE8, 0x81, 0xB7 },
	0xc2bf, { 0xE8, 0x81, 0xB6 },
	0xc2c0, { 0xE8, 0x87, 0x8D },
	0xc2c1, { 0xE8, 0x87, 0x8F },
	0xc2c2, { 0xE8, 0x88, 0x8A },
	0xc2c3, { 0xE8, 0x97, 0x8F },
	0xc2c4, { 0xE8, 0x96, 0xA9 },
	0xc2c5, { 0xE8, 0x97, 0x8D },
	0xc2c6, { 0xE8, 0x97, 0x90 },
	0xc2c7, { 0xE8, 0x97, 0x89 },
	0xc2c8, { 0xE8, 0x96, 0xB0 },
	0xc2c9, { 0xE8, 0x96, 0xBA },
	0xc2ca, { 0xE8, 0x96, 0xB9 },
	0xc2cb, { 0xE8, 0x96, 0xA6 },
	0xc2cc, { 0xE8, 0x9F, 0xAF },
	0xc2cd, { 0xE8, 0x9F, 0xAC },
	0xc2ce, { 0xE8, 0x9F, 0xB2 },
	0xc2cf, { 0xE8, 0x9F, 0xA0 },
	0xc2d0, { 0xE8, 0xA6, 0x86 },
	0xc2d1, { 0xE8, 0xA6, 0xB2 },
	0xc2d2, { 0xE8, 0xA7, 0xB4 },
	0xc2d3, { 0xE8, 0xAC, 0xA8 },
	0xc2d4, { 0xE8, 0xAC, 0xB9 },
	0xc2d5, { 0xE8, 0xAC, 0xAC },
	0xc2d6, { 0xE8, 0xAC, 0xAB },
	0xc2d7, { 0xE8, 0xB1, 0x90 },
	0xc2d8, { 0xE8, 0xB4, 0x85 },
	0xc2d9, { 0xE8, 0xB9, 0x99 },
	0xc2da, { 0xE8, 0xB9, 0xA3 },
	0xc2db, { 0xE8, 0xB9, 0xA6 },
	0xc2dc, { 0xE8, 0xB9, 0xA4 },
	0xc2dd, { 0xE8, 0xB9, 0x9F },
	0xc2de, { 0xE8, 0xB9, 0x95 },
	0xc2df, { 0xE8, 0xBB, 0x80 },
	0xc2e0, { 0xE8, 0xBD, 0x89 },
	0xc2e1, { 0xE8, 0xBD, 0x8D },
	0xc2e2, { 0xE9, 0x82, 0x87 },
	0xc2e3, { 0xE9, 0x82, 0x83 },
	0xc2e4, { 0xE9, 0x82, 0x88 },
	0xc2e5, { 0xE9, 0x86, 0xAB },
	0xc2e6, { 0xE9, 0x86, 0xAC },
	0xc2e7, { 0xE9, 0x87, 0x90 },
	0xc2e8, { 0xE9, 0x8E, 0x94 },
	0xc2e9, { 0xE9, 0x8E, 0x8A },
	0xc2ea, { 0xE9, 0x8E, 0x96 },
	0xc2eb, { 0xE9, 0x8E, 0xA2 },
	0xc2ec, { 0xE9, 0x8E, 0xB3 },
	0xc2ed, { 0xE9, 0x8E, 0xAE },
	0xc2ee, { 0xE9, 0x8E, 0xAC },
	0xc2ef, { 0xE9, 0x8E, 0xB0 },
	0xc2f0, { 0xE9, 0x8E, 0x98 },
	0xc2f1, { 0xE9, 0x8E, 0x9A },
	0xc2f2, { 0xE9, 0x8E, 0x97 },
	0xc2f3, { 0xE9, 0x97, 0x94 },
	0xc2f4, { 0xE9, 0x97, 0x96 },
	0xc2f5, { 0xE9, 0x97, 0x90 },
	0xc2f6, { 0xE9, 0x97, 0x95 },
	0xc2f7, { 0xE9, 0x9B, 0xA2 },
	0xc2f8, { 0xE9, 0x9B, 0x9C },
	0xc2f9, { 0xE9, 0x9B, 0x99 },
	0xc2fa, { 0xE9, 0x9B, 0x9B },
	0xc2fb, { 0xE9, 0x9B, 0x9E },
	0xc2fc, { 0xE9, 0x9C, 0xA4 },
	0xc2fd, { 0xE9, 0x9E, 0xA3 },
	0xc2fe, { 0xE9, 0x9E, 0xA6 },
	0xc340, { 0xE9, 0x9E, 0xAD },
	0xc341, { 0xE9, 0x9F, 0xB9 },
	0xc342, { 0xE9, 0xA1, 0x8D },
	0xc343, { 0xE9, 0xA1, 0x8F },
	0xc344, { 0xE9, 0xA1, 0x8C },
	0xc345, { 0xE9, 0xA1, 0x8E },
	0xc346, { 0xE9, 0xA1, 0x93 },
	0xc347, { 0xE9, 0xA2, 0xBA },
	0xc348, { 0xE9, 0xA4, 0xBE },
	0xc349, { 0xE9, 0xA4, 0xBF },
	0xc34a, { 0xE9, 0xA4, 0xBD },
	0xc34b, { 0xE9, 0xA4, 0xAE },
	0xc34c, { 0xE9, 0xA6, 0xA5 },
	0xc34d, { 0xE9, 0xA8, 0x8E },
	0xc34e, { 0xE9, 0xAB, 0x81 },
	0xc34f, { 0xE9, 0xAC, 0x83 },
	0xc350, { 0xE9, 0xAC, 0x86 },
	0xc351, { 0xE9, 0xAD, 0x8F },
	0xc352, { 0xE9, 0xAD, 0x8E },
	0xc353, { 0xE9, 0xAD, 0x8D },
	0xc354, { 0xE9, 0xAF, 0x8A },
	0xc355, { 0xE9, 0xAF, 0x89 },
	0xc356, { 0xE9, 0xAF, 0xBD },
	0xc357, { 0xE9, 0xAF, 0x88 },
	0xc358, { 0xE9, 0xAF, 0x80 },
	0xc359, { 0xE9, 0xB5, 0x91 },
	0xc35a, { 0xE9, 0xB5, 0x9D },
	0xc35b, { 0xE9, 0xB5, 0xA0 },
	0xc35c, { 0xE9, 0xBB, 0xA0 },
	0xc35d, { 0xE9, 0xBC, 0x95 },
	0xc35e, { 0xE9, 0xBC, 0xAC },
	0xc35f, { 0xE5, 0x84, 0xB3 },
	0xc360, { 0xE5, 0x9A, 0xA5 },
	0xc361, { 0xE5, 0xA3, 0x9E },
	0xc362, { 0xE5, 0xA3, 0x9F },
	0xc363, { 0xE5, 0xA3, 0xA2 },
	0xc364, { 0xE5, 0xAF, 0xB5 },
	0xc365, { 0xE9, 0xBE, 0x90 },
	0xc366, { 0xE5, 0xBB, 0xAC },
	0xc367, { 0xE6, 0x87, 0xB2 },
	0xc368, { 0xE6, 0x87, 0xB7 },
	0xc369, { 0xE6, 0x87, 0xB6 },
	0xc36a, { 0xE6, 0x87, 0xB5 },
	0xc36b, { 0xE6, 0x94, 0x80 },
	0xc36c, { 0xE6, 0x94, 0x8F },
	0xc36d, { 0xE6, 0x9B, 0xA0 },
	0xc36e, { 0xE6, 0x9B, 0x9D },
	0xc36f, { 0xE6, 0xAB, 0xA5 },
	0xc370, { 0xE6, 0xAB, 0x9D },
	0xc371, { 0xE6, 0xAB, 0x9A },
	0xc372, { 0xE6, 0xAB, 0x93 },
	0xc373, { 0xE7, 0x80, 0x9B },
	0xc374, { 0xE7, 0x80, 0x9F },
	0xc375, { 0xE7, 0x80, 0xA8 },
	0xc376, { 0xE7, 0x80, 0x9A },
	0xc377, { 0xE7, 0x80, 0x9D },
	0xc378, { 0xE7, 0x80, 0x95 },
	0xc379, { 0xE7, 0x80, 0x98 },
	0xc37a, { 0xE7, 0x88, 0x86 },
	0xc37b, { 0xE7, 0x88, 0x8D },
	0xc37c, { 0xE7, 0x89, 0x98 },
	0xc37d, { 0xE7, 0x8A, 0xA2 },
	0xc37e, { 0xE7, 0x8D, 0xB8 },
	0xc3a1, { 0xE7, 0x8D, 0xBA },
	0xc3a2, { 0xE7, 0x92, 0xBD },
	0xc3a3, { 0xE7, 0x93, 0x8A },
	0xc3a4, { 0xE7, 0x93, 0xA3 },
	0xc3a5, { 0xE7, 0x96, 0x87 },
	0xc3a6, { 0xE7, 0x96, 0x86 },
	0xc3a7, { 0xE7, 0x99, 0x9F },
	0xc3a8, { 0xE7, 0x99, 0xA1 },
	0xc3a9, { 0xE7, 0x9F, 0x87 },
	0xc3aa, { 0xE7, 0xA4, 0x99 },
	0xc3ab, { 0xE7, 0xA6, 0xB1 },
	0xc3ac, { 0xE7, 0xA9, 0xAB },
	0xc3ad, { 0xE7, 0xA9, 0xA9 },
	0xc3ae, { 0xE7, 0xB0, 0xBE },
	0xc3af, { 0xE7, 0xB0, 0xBF },
	0xc3b0, { 0xE7, 0xB0, 0xB8 },
	0xc3b1, { 0xE7, 0xB0, 0xBD },
	0xc3b2, { 0xE7, 0xB0, 0xB7 },
	0xc3b3, { 0xE7, 0xB1, 0x80 },
	0xc3b4, { 0xE7, 0xB9, 0xAB },
	0xc3b5, { 0xE7, 0xB9, 0xAD },
	0xc3b6, { 0xE7, 0xB9, 0xB9 },
	0xc3b7, { 0xE7, 0xB9, 0xA9 },
	0xc3b8, { 0xE7, 0xB9, 0xAA },
	0xc3b9, { 0xE7, 0xBE, 0x85 },
	0xc3ba, { 0xE7, 0xB9, 0xB3 },
	0xc3bb, { 0xE7, 0xBE, 0xB6 },
	0xc3bc, { 0xE7, 0xBE, 0xB9 },
	0xc3bd, { 0xE7, 0xBE, 0xB8 },
	0xc3be, { 0xE8, 0x87, 0x98 },
	0xc3bf, { 0xE8, 0x97, 0xA9 },
	0xc3c0, { 0xE8, 0x97, 0x9D },
	0xc3c1, { 0xE8, 0x97, 0xAA },
	0xc3c2, { 0xE8, 0x97, 0x95 },
	0xc3c3, { 0xE8, 0x97, 0xA4 },
	0xc3c4, { 0xE8, 0x97, 0xA5 },
	0xc3c5, { 0xE8, 0x97, 0xB7 },
	0xc3c6, { 0xE8, 0x9F, 0xBB },
	0xc3c7, { 0xE8, 0xA0, 0x85 },
	0xc3c8, { 0xE8, 0xA0, 0x8D },
	0xc3c9, { 0xE8, 0x9F, 0xB9 },
	0xc3ca, { 0xE8, 0x9F, 0xBE },
	0xc3cb, { 0xE8, 0xA5, 0xA0 },
	0xc3cc, { 0xE8, 0xA5, 0x9F },
	0xc3cd, { 0xE8, 0xA5, 0x96 },
	0xc3ce, { 0xE8, 0xA5, 0x9E },
	0xc3cf, { 0xE8, 0xAD, 0x81 },
	0xc3d0, { 0xE8, 0xAD, 0x9C },
	0xc3d1, { 0xE8, 0xAD, 0x98 },
	0xc3d2, { 0xE8, 0xAD, 0x89 },
	0xc3d3, { 0xE8, 0xAD, 0x9A },
	0xc3d4, { 0xE8, 0xAD, 0x8E },
	0xc3d5, { 0xE8, 0xAD, 0x8F },
	0xc3d6, { 0xE8, 0xAD, 0x86 },
	0xc3d7, { 0xE8, 0xAD, 0x99 },
	0xc3d8, { 0xE8, 0xB4, 0x88 },
	0xc3d9, { 0xE8, 0xB4, 0x8A },
	0xc3da, { 0xE8, 0xB9, 0xBC },
	0xc3db, { 0xE8, 0xB9, 0xB2 },
	0xc3dc, { 0xE8, 0xBA, 0x87 },
	0xc3dd, { 0xE8, 0xB9, 0xB6 },
	0xc3de, { 0xE8, 0xB9, 0xAC },
	0xc3df, { 0xE8, 0xB9, 0xBA },
	0xc3e0, { 0xE8, 0xB9, 0xB4 },
	0xc3e1, { 0xE8, 0xBD, 0x94 },
	0xc3e2, { 0xE8, 0xBD, 0x8E },
	0xc3e3, { 0xE8, 0xBE, 0xAD },
	0xc3e4, { 0xE9, 0x82, 0x8A },
	0xc3e5, { 0xE9, 0x82, 0x8B },
	0xc3e6, { 0xE9, 0x86, 0xB1 },
	0xc3e7, { 0xE9, 0x86, 0xAE },
	0xc3e8, { 0xE9, 0x8F, 0xA1 },
	0xc3e9, { 0xE9, 0x8F, 0x91 },
	0xc3ea, { 0xE9, 0x8F, 0x9F },
	0xc3eb, { 0xE9, 0x8F, 0x83 },
	0xc3ec, { 0xE9, 0x8F, 0x88 },
	0xc3ed, { 0xE9, 0x8F, 0x9C },
	0xc3ee, { 0xE9, 0x8F, 0x9D },
	0xc3ef, { 0xE9, 0x8F, 0x96 },
	0xc3f0, { 0xE9, 0x8F, 0xA2 },
	0xc3f1, { 0xE9, 0x8F, 0x8D },
	0xc3f2, { 0xE9, 0x8F, 0x98 },
	0xc3f3, { 0xE9, 0x8F, 0xA4 },
	0xc3f4, { 0xE9, 0x8F, 0x97 },
	0xc3f5, { 0xE9, 0x8F, 0xA8 },
	0xc3f6, { 0xE9, 0x97, 0x9C },
	0xc3f7, { 0xE9, 0x9A, 0xB4 },
	0xc3f8, { 0xE9, 0x9B, 0xA3 },
	0xc3f9, { 0xE9, 0x9C, 0xAA },
	0xc3fa, { 0xE9, 0x9C, 0xA7 },
	0xc3fb, { 0xE9, 0x9D, 0xA1 },
	0xc3fc, { 0xE9, 0x9F, 0x9C },
	0xc3fd, { 0xE9, 0x9F, 0xBB },
	0xc3fe, { 0xE9, 0xA1, 0x9E },
	0xc440, { 0xE9, 0xA1, 0x98 },
	0xc441, { 0xE9, 0xA1, 0x9B },
	0xc442, { 0xE9, 0xA2, 0xBC },
	0xc443, { 0xE9, 0xA5, 0x85 },
	0xc444, { 0xE9, 0xA5, 0x89 },
	0xc445, { 0xE9, 0xA8, 0x96 },
	0xc446, { 0xE9, 0xA8, 0x99 },
	0xc447, { 0xE9, 0xAC, 0x8D },
	0xc448, { 0xE9, 0xAF, 0xA8 },
	0xc449, { 0xE9, 0xAF, 0xA7 },
	0xc44a, { 0xE9, 0xAF, 0x96 },
	0xc44b, { 0xE9, 0xAF, 0x9B },
	0xc44c, { 0xE9, 0xB6, 0x89 },
	0xc44d, { 0xE9, 0xB5, 0xA1 },
	0xc44e, { 0xE9, 0xB5, 0xB2 },
	0xc44f, { 0xE9, 0xB5, 0xAA },
	0xc450, { 0xE9, 0xB5, 0xAC },
	0xc451, { 0xE9, 0xBA, 0x92 },
	0xc452, { 0xE9, 0xBA, 0x97 },
	0xc453, { 0xE9, 0xBA, 0x93 },
	0xc454, { 0xE9, 0xBA, 0xB4 },
	0xc455, { 0xE5, 0x8B, 0xB8 },
	0xc456, { 0xE5, 0x9A, 0xA8 },
	0xc457, { 0xE5, 0x9A, 0xB7 },
	0xc458, { 0xE5, 0x9A, 0xB6 },
	0xc459, { 0xE5, 0x9A, 0xB4 },
	0xc45a, { 0xE5, 0x9A, 0xBC },
	0xc45b, { 0xE5, 0xA3, 0xA4 },
	0xc45c, { 0xE5, 0xAD, 0x80 },
	0xc45d, { 0xE5, 0xAD, 0x83 },
	0xc45e, { 0xE5, 0xAD, 0xBD },
	0xc45f, { 0xE5, 0xAF, 0xB6 },
	0xc460, { 0xE5, 0xB7, 0x89 },
	0xc461, { 0xE6, 0x87, 0xB8 },
	0xc462, { 0xE6, 0x87, 0xBA },
	0xc463, { 0xE6, 0x94, 0x98 },
	0xc464, { 0xE6, 0x94, 0x94 },
	0xc465, { 0xE6, 0x94, 0x99 },
	0xc466, { 0xE6, 0x9B, 0xA6 },
	0xc467, { 0xE6, 0x9C, 0xA7 },
	0xc468, { 0xE6, 0xAB, 0xAC },
	0xc469, { 0xE7, 0x80, 0xBE },
	0xc46a, { 0xE7, 0x80, 0xB0 },
	0xc46b, { 0xE7, 0x80, 0xB2 },
	0xc46c, { 0xE7, 0x88, 0x90 },
	0xc46d, { 0xE7, 0x8D, 0xBB },
	0xc46e, { 0xE7, 0x93, 0x8F },
	0xc46f, { 0xE7, 0x99, 0xA2 },
	0xc470, { 0xE7, 0x99, 0xA5 },
	0xc471, { 0xE7, 0xA4, 0xA6 },
	0xc472, { 0xE7, 0xA4, 0xAA },
	0xc473, { 0xE7, 0xA4, 0xAC },
	0xc474, { 0xE7, 0xA4, 0xAB },
	0xc475, { 0xE7, 0xAB, 0x87 },
	0xc476, { 0xE7, 0xAB, 0xB6 },
	0xc477, { 0xE7, 0xB1, 0x8C },
	0xc478, { 0xE7, 0xB1, 0x83 },
	0xc479, { 0xE7, 0xB1, 0x8D },
	0xc47a, { 0xE7, 0xB3, 0xAF },
	0xc47b, { 0xE7, 0xB3, 0xB0 },
	0xc47c, { 0xE8, 0xBE, 0xAE },
	0xc47d, { 0xE7, 0xB9, 0xBD },
	0xc47e, { 0xE7, 0xB9, 0xBC },
	0xc4a1, { 0xE7, 0xBA, 0x82 },
	0xc4a2, { 0xE7, 0xBD, 0x8C },
	0xc4a3, { 0xE8, 0x80, 0x80 },
	0xc4a4, { 0xE8, 0x87, 0x9A },
	0xc4a5, { 0xE8, 0x89, 0xA6 },
	0xc4a6, { 0xE8, 0x97, 0xBB },
	0xc4a7, { 0xE8, 0x97, 0xB9 },
	0xc4a8, { 0xE8, 0x98, 0x91 },
	0xc4a9, { 0xE8, 0x97, 0xBA },
	0xc4aa, { 0xE8, 0x98, 0x86 },
	0xc4ab, { 0xE8, 0x98, 0x8B },
	0xc4ac, { 0xE8, 0x98, 0x87 },
	0xc4ad, { 0xE8, 0x98, 0x8A },
	0xc4ae, { 0xE8, 0xA0, 0x94 },
	0xc4af, { 0xE8, 0xA0, 0x95 },
	0xc4b0, { 0xE8, 0xA5, 0xA4 },
	0xc4b1, { 0xE8, 0xA6, 0xBA },
	0xc4b2, { 0xE8, 0xA7, 0xB8 },
	0xc4b3, { 0xE8, 0xAD, 0xB0 },
	0xc4b4, { 0xE8, 0xAD, 0xAC },
	0xc4b5, { 0xE8, 0xAD, 0xA6 },
	0xc4b6, { 0xE8, 0xAD, 0xAF },
	0xc4b7, { 0xE8, 0xAD, 0x9F },
	0xc4b8, { 0xE8, 0xAD, 0xAB },
	0xc4b9, { 0xE8, 0xB4, 0x8F },
	0xc4ba, { 0xE8, 0xB4, 0x8D },
	0xc4bb, { 0xE8, 0xBA, 0x89 },
	0xc4bc, { 0xE8, 0xBA, 0x81 },
	0xc4bd, { 0xE8, 0xBA, 0x85 },
	0xc4be, { 0xE8, 0xBA, 0x82 },
	0xc4bf, { 0xE9, 0x86, 0xB4 },
	0xc4c0, { 0xE9, 0x87, 0x8B },
	0xc4c1, { 0xE9, 0x90, 0x98 },
	0xc4c2, { 0xE9, 0x90, 0x83 },
	0xc4c3, { 0xE9, 0x8F, 0xBD },
	0xc4c4, { 0xE9, 0x97, 0xA1 },
	0xc4c5, { 0xE9, 0x9C, 0xB0 },
	0xc4c6, { 0xE9, 0xA3, 0x84 },
	0xc4c7, { 0xE9, 0xA5, 0x92 },
	0xc4c8, { 0xE9, 0xA5, 0x91 },
	0xc4c9, { 0xE9, 0xA6, 0xA8 },
	0xc4ca, { 0xE9, 0xA8, 0xAB },
	0xc4cb, { 0xE9, 0xA8, 0xB0 },
	0xc4cc, { 0xE9, 0xA8, 0xB7 },
	0xc4cd, { 0xE9, 0xA8, 0xB5 },
	0xc4ce, { 0xE9, 0xB0, 0x93 },
	0xc4cf, { 0xE9, 0xB0, 0x8D },
	0xc4d0, { 0xE9, 0xB9, 0xB9 },
	0xc4d1, { 0xE9, 0xBA, 0xB5 },
	0xc4d2, { 0xE9, 0xBB, 0xA8 },
	0xc4d3, { 0xE9, 0xBC, 0xAF },
	0xc4d4, { 0xE9, 0xBD, 0x9F },
	0xc4d5, { 0xE9, 0xBD, 0xA3 },
	0xc4d6, { 0xE9, 0xBD, 0xA1 },
	0xc4d7, { 0xE5, 0x84, 0xB7 },
	0xc4d8, { 0xE5, 0x84, 0xB8 },
	0xc4d9, { 0xE5, 0x9B, 0x81 },
	0xc4da, { 0xE5, 0x9B, 0x80 },
	0xc4db, { 0xE5, 0x9B, 0x82 },
	0xc4dc, { 0xE5, 0xA4, 0x94 },
	0xc4dd, { 0xE5, 0xB1, 0xAC },
	0xc4de, { 0xE5, 0xB7, 0x8D },
	0xc4df, { 0xE6, 0x87, 0xBC },
	0xc4e0, { 0xE6, 0x87, 0xBE },
	0xc4e1, { 0xE6, 0x94, 0x9D },
	0xc4e2, { 0xE6, 0x94, 0x9C },
	0xc4e3, { 0xE6, 0x96, 0x95 },
	0xc4e4, { 0xE6, 0x9B, 0xA9 },
	0xc4e5, { 0xE6, 0xAB, 0xBB },
	0xc4e6, { 0xE6, 0xAC, 0x84 },
	0xc4e7, { 0xE6, 0xAB, 0xBA },
	0xc4e8, { 0xE6, 0xAE, 0xB2 },
	0xc4e9, { 0xE7, 0x81, 0x8C },
	0xc4ea, { 0xE7, 0x88, 0x9B },
	0xc4eb, { 0xE7, 0x8A, 0xA7 },
	0xc4ec, { 0xE7, 0x93, 0x96 },
	0xc4ed, { 0xE7, 0x93, 0x94 },
	0xc4ee, { 0xE7, 0x99, 0xA9 },
	0xc4ef, { 0xE7, 0x9F, 0x93 },
	0xc4f0, { 0xE7, 0xB1, 0x90 },
	0xc4f1, { 0xE7, 0xBA, 0x8F },
	0xc4f2, { 0xE7, 0xBA, 0x8C },
	0xc4f3, { 0xE7, 0xBE, 0xBC },
	0xc4f4, { 0xE8, 0x98, 0x97 },
	0xc4f5, { 0xE8, 0x98, 0xAD },
	0xc4f6, { 0xE8, 0x98, 0x9A },
	0xc4f7, { 0xE8, 0xA0, 0xA3 },
	0xc4f8, { 0xE8, 0xA0, 0xA2 },
	0xc4f9, { 0xE8, 0xA0, 0xA1 },
	0xc4fa, { 0xE8, 0xA0, 0x9F },
	0xc4fb, { 0xE8, 0xA5, 0xAA },
	0xc4fc, { 0xE8, 0xA5, 0xAC },
	0xc4fd, { 0xE8, 0xA6, 0xBD },
	0xc4fe, { 0xE8, 0xAD, 0xB4 },
	0xc540, { 0xE8, 0xAD, 0xB7 },
	0xc541, { 0xE8, 0xAD, 0xBD },
	0xc542, { 0xE8, 0xB4, 0x93 },
	0xc543, { 0xE8, 0xBA, 0x8A },
	0xc544, { 0xE8, 0xBA, 0x8D },
	0xc545, { 0xE8, 0xBA, 0x8B },
	0xc546, { 0xE8, 0xBD, 0x9F },
	0xc547, { 0xE8, 0xBE, 0xAF },
	0xc548, { 0xE9, 0x86, 0xBA },
	0xc549, { 0xE9, 0x90, 0xAE },
	0xc54a, { 0xE9, 0x90, 0xB3 },
	0xc54b, { 0xE9, 0x90, 0xB5 },
	0xc54c, { 0xE9, 0x90, 0xBA },
	0xc54d, { 0xE9, 0x90, 0xB8 },
	0xc54e, { 0xE9, 0x90, 0xB2 },
	0xc54f, { 0xE9, 0x90, 0xAB },
	0xc550, { 0xE9, 0x97, 0xA2 },
	0xc551, { 0xE9, 0x9C, 0xB8 },
	0xc552, { 0xE9, 0x9C, 0xB9 },
	0xc553, { 0xE9, 0x9C, 0xB2 },
	0xc554, { 0xE9, 0x9F, 0xBF },
	0xc555, { 0xE9, 0xA1, 0xA7 },
	0xc556, { 0xE9, 0xA1, 0xA5 },
	0xc557, { 0xE9, 0xA5, 0x97 },
	0xc558, { 0xE9, 0xA9, 0x85 },
	0xc559, { 0xE9, 0xA9, 0x83 },
	0xc55a, { 0xE9, 0xA9, 0x80 },
	0xc55b, { 0xE9, 0xA8, 0xBE },
	0xc55c, { 0xE9, 0xAB, 0x8F },
	0xc55d, { 0xE9, 0xAD, 0x94 },
	0xc55e, { 0xE9, 0xAD, 0x91 },
	0xc55f, { 0xE9, 0xB0, 0xAD },
	0xc560, { 0xE9, 0xB0, 0xA5 },
	0xc561, { 0xE9, 0xB6, 0xAF },
	0xc562, { 0xE9, 0xB6, 0xB4 },
	0xc563, { 0xE9, 0xB7, 0x82 },
	0xc564, { 0xE9, 0xB6, 0xB8 },
	0xc565, { 0xE9, 0xBA, 0x9D },
	0xc566, { 0xE9, 0xBB, 0xAF },
	0xc567, { 0xE9, 0xBC, 0x99 },
	0xc568, { 0xE9, 0xBD, 0x9C },
	0xc569, { 0xE9, 0xBD, 0xA6 },
	0xc56a, { 0xE9, 0xBD, 0xA7 },
	0xc56b, { 0xE5, 0x84, 0xBC },
	0xc56c, { 0xE5, 0x84, 0xBB },
	0xc56d, { 0xE5, 0x9B, 0x88 },
	0xc56e, { 0xE5, 0x9B, 0x8A },
	0xc56f, { 0xE5, 0x9B, 0x89 },
	0xc570, { 0xE5, 0xAD, 0xBF },
	0xc571, { 0xE5, 0xB7, 0x94 },
	0xc572, { 0xE5, 0xB7, 0x92 },
	0xc573, { 0xE5, 0xBD, 0x8E },
	0xc574, { 0xE6, 0x87, 0xBF },
	0xc575, { 0xE6, 0x94, 0xA4 },
	0xc576, { 0xE6, 0xAC, 0x8A },
	0xc577, { 0xE6, 0xAD, 0xA1 },
	0xc578, { 0xE7, 0x81, 0x91 },
	0xc579, { 0xE7, 0x81, 0x98 },
	0xc57a, { 0xE7, 0x8E, 0x80 },
	0xc57b, { 0xE7, 0x93, 0xA4 },
	0xc57c, { 0xE7, 0x96, 0x8A },
	0xc57d, { 0xE7, 0x99, 0xAE },
	0xc57e, { 0xE7, 0x99, 0xAC },
	0xc5a1, { 0xE7, 0xA6, 0xB3 },
	0xc5a2, { 0xE7, 0xB1, 0xA0 },
	0xc5a3, { 0xE7, 0xB1, 0x9F },
	0xc5a4, { 0xE8, 0x81, 0xBE },
	0xc5a5, { 0xE8, 0x81, 0xBD },
	0xc5a6, { 0xE8, 0x87, 0x9F },
	0xc5a7, { 0xE8, 0xA5, 0xB2 },
	0xc5a8, { 0xE8, 0xA5, 0xAF },
	0xc5a9, { 0xE8, 0xA7, 0xBC },
	0xc5aa, { 0xE8, 0xAE, 0x80 },
	0xc5ab, { 0xE8, 0xB4, 0x96 },
	0xc5ac, { 0xE8, 0xB4, 0x97 },
	0xc5ad, { 0xE8, 0xBA, 0x91 },
	0xc5ae, { 0xE8, 0xBA, 0x93 },
	0xc5af, { 0xE8, 0xBD, 0xA1 },
	0xc5b0, { 0xE9, 0x85, 0x88 },
	0xc5b1, { 0xE9, 0x91, 0x84 },
	0xc5b2, { 0xE9, 0x91, 0x91 },
	0xc5b3, { 0xE9, 0x91, 0x92 },
	0xc5b4, { 0xE9, 0x9C, 0xBD },
	0xc5b5, { 0xE9, 0x9C, 0xBE },
	0xc5b6, { 0xE9, 0x9F, 0x83 },
	0xc5b7, { 0xE9, 0x9F, 0x81 },
	0xc5b8, { 0xE9, 0xA1, 0xAB },
	0xc5b9, { 0xE9, 0xA5, 0x95 },
	0xc5ba, { 0xE9, 0xA9, 0x95 },
	0xc5bb, { 0xE9, 0xA9, 0x8D },
	0xc5bc, { 0xE9, 0xAB, 0x92 },
	0xc5bd, { 0xE9, 0xAC, 0x9A },
	0xc5be, { 0xE9, 0xB1, 0x89 },
	0xc5bf, { 0xE9, 0xB0, 0xB1 },
	0xc5c0, { 0xE9, 0xB0, 0xBE },
	0xc5c1, { 0xE9, 0xB0, 0xBB },
	0xc5c2, { 0xE9, 0xB7, 0x93 },
	0xc5c3, { 0xE9, 0xB7, 0x97 },
	0xc5c4, { 0xE9, 0xBC, 0xB4 },
	0xc5c5, { 0xE9, 0xBD, 0xAC },
	0xc5c6, { 0xE9, 0xBD, 0xAA },
	0xc5c7, { 0xE9, 0xBE, 0x94 },
	0xc5c8, { 0xE5, 0x9B, 0x8C },
	0xc5c9, { 0xE5, 0xB7, 0x96 },
	0xc5ca, { 0xE6, 0x88, 0x80 },
	0xc5cb, { 0xE6, 0x94, 0xA3 },
	0xc5cc, { 0xE6, 0x94, 0xAB },
	0xc5cd, { 0xE6, 0x94, 0xAA },
	0xc5ce, { 0xE6, 0x9B, 0xAC },
	0xc5cf, { 0xE6, 0xAC, 0x90 },
	0xc5d0, { 0xE7, 0x93, 0x9A },
	0xc5d1, { 0xE7, 0xAB, 0x8A },
	0xc5d2, { 0xE7, 0xB1, 0xA4 },
	0xc5d3, { 0xE7, 0xB1, 0xA3 },
	0xc5d4, { 0xE7, 0xB1, 0xA5 },
	0xc5d5, { 0xE7, 0xBA, 0x93 },
	0xc5d6, { 0xE7, 0xBA, 0x96 },
	0xc5d7, { 0xE7, 0xBA, 0x94 },
	0xc5d8, { 0xE8, 0x87, 0xA2 },
	0xc5d9, { 0xE8, 0x98, 0xB8 },
	0xc5da, { 0xE8, 0x98, 0xBF },
	0xc5db, { 0xE8, 0xA0, 0xB1 },
	0xc5dc, { 0xE8, 0xAE, 0x8A },
	0xc5dd, { 0xE9, 0x82, 0x90 },
	0xc5de, { 0xE9, 0x82, 0x8F },
	0xc5df, { 0xE9, 0x91, 0xA3 },
	0xc5e0, { 0xE9, 0x91, 0xA0 },
	0xc5e1, { 0xE9, 0x91, 0xA4 },
	0xc5e2, { 0xE9, 0x9D, 0xA8 },
	0xc5e3, { 0xE9, 0xA1, 0xAF },
	0xc5e4, { 0xE9, 0xA5, 0x9C },
	0xc5e5, { 0xE9, 0xA9, 0x9A },
	0xc5e6, { 0xE9, 0xA9, 0x9B },
	0xc5e7, { 0xE9, 0xA9, 0x97 },
	0xc5e8, { 0xE9, 0xAB, 0x93 },
	0xc5e9, { 0xE9, 0xAB, 0x94 },
	0xc5ea, { 0xE9, 0xAB, 0x91 },
	0xc5eb, { 0xE9, 0xB1, 0x94 },
	0xc5ec, { 0xE9, 0xB1, 0x97 },
	0xc5ed, { 0xE9, 0xB1, 0x96 },
	0xc5ee, { 0xE9, 0xB7, 0xA5 },
	0xc5ef, { 0xE9, 0xBA, 0x9F },
	0xc5f0, { 0xE9, 0xBB, 0xB4 },
	0xc5f1, { 0xE5, 0x9B, 0x91 },
	0xc5f2, { 0xE5, 0xA3, 0xA9 },
	0xc5f3, { 0xE6, 0x94, 0xAC },
	0xc5f4, { 0xE7, 0x81, 0x9E },
	0xc5f5, { 0xE7, 0x99, 0xB1 },
	0xc5f6, { 0xE7, 0x99, 0xB2 },
	0xc5f7, { 0xE7, 0x9F, 0x97 },
	0xc5f8, { 0xE7, 0xBD, 0x90 },
	0xc5f9, { 0xE7, 0xBE, 0x88 },
	0xc5fa, { 0xE8, 0xA0, 0xB6 },
	0xc5fb, { 0xE8, 0xA0, 0xB9 },
	0xc5fc, { 0xE8, 0xA1, 0xA2 },
	0xc5fd, { 0xE8, 0xAE, 0x93 },
	0xc5fe, { 0xE8, 0xAE, 0x92 },
	0xc640, { 0xE8, 0xAE, 0x96 },
	0xc641, { 0xE8, 0x89, 0xB7 },
	0xc642, { 0xE8, 0xB4, 0x9B },
	0xc643, { 0xE9, 0x87, 0x80 },
	0xc644, { 0xE9, 0x91, 0xAA },
	0xc645, { 0xE9, 0x9D, 0x82 },
	0xc646, { 0xE9, 0x9D, 0x88 },
	0xc647, { 0xE9, 0x9D, 0x84 },
	0xc648, { 0xE9, 0x9F, 0x86 },
	0xc649, { 0xE9, 0xA1, 0xB0 },
	0xc64a, { 0xE9, 0xA9, 0x9F },
	0xc64b, { 0xE9, 0xAC, 0xA2 },
	0xc64c, { 0xE9, 0xAD, 0x98 },
	0xc64d, { 0xE9, 0xB1, 0x9F },
	0xc64e, { 0xE9, 0xB7, 0xB9 },
	0xc64f, { 0xE9, 0xB7, 0xBA },
	0xc650, { 0xE9, 0xB9, 0xBC },
	0xc651, { 0xE9, 0xB9, 0xBD },
	0xc652, { 0xE9, 0xBC, 0x87 },
	0xc653, { 0xE9, 0xBD, 0xB7 },
	0xc654, { 0xE9, 0xBD, 0xB2 },
	0xc655, { 0xE5, 0xBB, 0xB3 },
	0xc656, { 0xE6, 0xAC, 0x96 },
	0xc657, { 0xE7, 0x81, 0xA3 },
	0xc658, { 0xE7, 0xB1, 0xAC },
	0xc659, { 0xE7, 0xB1, 0xAE },
	0xc65a, { 0xE8, 0xA0, 0xBB },
	0xc65b, { 0xE8, 0xA7, 0x80 },
	0xc65c, { 0xE8, 0xBA, 0xA1 },
	0xc65d, { 0xE9, 0x87, 0x81 },
	0xc65e, { 0xE9, 0x91, 0xB2 },
	0xc65f, { 0xE9, 0x91, 0xB0 },
	0xc660, { 0xE9, 0xA1, 0xB1 },
	0xc661, { 0xE9, 0xA5, 0x9E },
	0xc662, { 0xE9, 0xAB, 0x96 },
	0xc663, { 0xE9, 0xAC, 0xA3 },
	0xc664, { 0xE9, 0xBB, 0x8C },
	0xc665, { 0xE7, 0x81, 0xA4 },
	0xc666, { 0xE7, 0x9F, 0x9A },
	0xc667, { 0xE8, 0xAE, 0x9A },
	0xc668, { 0xE9, 0x91, 0xB7 },
	0xc669, { 0xE9, 0x9F, 0x89 },
	0xc66a, { 0xE9, 0xA9, 0xA2 },
	0xc66b, { 0xE9, 0xA9, 0xA5 },
	0xc66c, { 0xE7, 0xBA, 0x9C },
	0xc66d, { 0xE8, 0xAE, 0x9C },
	0xc66e, { 0xE8, 0xBA, 0xAA },
	0xc66f, { 0xE9, 0x87, 0x85 },
	0xc670, { 0xE9, 0x91, 0xBD },
	0xc671, { 0xE9, 0x91, 0xBE },
	0xc672, { 0xE9, 0x91, 0xBC },
	0xc673, { 0xE9, 0xB1, 0xB7 },
	0xc674, { 0xE9, 0xB1, 0xB8 },
	0xc675, { 0xE9, 0xBB, 0xB7 },
	0xc676, { 0xE8, 0xB1, 0x94 },
	0xc677, { 0xE9, 0x91, 0xBF },
	0xc678, { 0xE9, 0xB8, 0x9A },
	0xc679, { 0xE7, 0x88, 0xA8 },
	0xc67a, { 0xE9, 0xA9, 0xAA },
	0xc67b, { 0xE9, 0xAC, 0xB1 },
	0xc67c, { 0xE9, 0xB8, 0x9B },
	0xc67d, { 0xE9, 0xB8, 0x9E },
	0xc67e, { 0xE7, 0xB1, 0xB2 },
	0xc6a1, { 0xE2, 0x91, 0xA0 },
	0xc6a2, { 0xE2, 0x91, 0xA1 },
	0xc6a3, { 0xE2, 0x91, 0xA2 },
	0xc6a4, { 0xE2, 0x91, 0xA3 },
	0xc6a5, { 0xE2, 0x91, 0xA4 },
	0xc6a6, { 0xE2, 0x91, 0xA5 },
	0xc6a7, { 0xE2, 0x91, 0xA6 },
	0xc6a8, { 0xE2, 0x91, 0xA7 },
	0xc6a9, { 0xE2, 0x91, 0xA8 },
	0xc6aa, { 0xE2, 0x91, 0xA9 },
	0xc6ab, { 0xE2, 0x91, 0xB4 },
	0xc6ac, { 0xE2, 0x91, 0xB5 },
	0xc6ad, { 0xE2, 0x91, 0xB6 },
	0xc6ae, { 0xE2, 0x91, 0xB7 },
	0xc6af, { 0xE2, 0x91, 0xB8 },
	0xc6b0, { 0xE2, 0x91, 0xB9 },
	0xc6b1, { 0xE2, 0x91, 0xBA },
	0xc6b2, { 0xE2, 0x91, 0xBB },
	0xc6b3, { 0xE2, 0x91, 0xBC },
	0xc6b4, { 0xE2, 0x91, 0xBD },
	0xc6b5, { 0xE2, 0x85, 0xB0 },
	0xc6b6, { 0xE2, 0x85, 0xB1 },
	0xc6b7, { 0xE2, 0x85, 0xB2 },
	0xc6b8, { 0xE2, 0x85, 0xB3 },
	0xc6b9, { 0xE2, 0x85, 0xB4 },
	0xc6ba, { 0xE2, 0x85, 0xB5 },
	0xc6bb, { 0xE2, 0x85, 0xB6 },
	0xc6bc, { 0xE2, 0x85, 0xB7 },
	0xc6bd, { 0xE2, 0x85, 0xB8 },
	0xc6be, { 0xE2, 0x85, 0xB9 },
	0xc6bf, { 0xE4, 0xB8, 0xB6 },
	0xc6c0, { 0xE4, 0xB8, 0xBF },
	0xc6c1, { 0xE4, 0xBA, 0x85 },
	0xc6c2, { 0xE4, 0xBA, 0xA0 },
	0xc6c3, { 0xE5, 0x86, 0x82 },
	0xc6c4, { 0xE5, 0x86, 0x96 },
	0xc6c5, { 0xE5, 0x86, 0xAB },
	0xc6c6, { 0xE5, 0x8B, 0xB9 },
	0xc6c7, { 0xE5, 0x8C, 0xB8 },
	0xc6c8, { 0xE5, 0x8D, 0xA9 },
	0xc6c9, { 0xE5, 0x8E, 0xB6 },
	0xc6ca, { 0xE5, 0xA4, 0x8A },
	0xc6cb, { 0xE5, 0xAE, 0x80 },
	0xc6cc, { 0xE5, 0xB7, 0x9B },
	0xc6cd, { 0xE2, 0xBC, 0xB3 },
	0xc6ce, { 0xE5, 0xB9, 0xBF },
	0xc6d0, { 0xE5, 0xBD, 0x90 },
	0xc6d1, { 0xE5, 0xBD, 0xA1 },
	0xc6d2, { 0xE6, 0x94, 0xB4 },
	0xc6d4, { 0xE7, 0x96, 0x92 },
	0xc6d6, { 0xE8, 0xBE, 0xB5 },
	0xc6d8, { 0xC2, 0xA8 },
	0xc6d9, { 0xCB, 0x86 },
	0xc6da, { 0xE3, 0x83, 0xBD },
	0xc6db, { 0xE3, 0x83, 0xBE },
	0xc6dc, { 0xE3, 0x82, 0x9D },
	0xc6dd, { 0xE3, 0x82, 0x9E },
	0xc6e0, { 0xE3, 0x80, 0x85 },
	0xc6e1, { 0xE3, 0x80, 0x86 },
	0xc6e2, { 0xE3, 0x80, 0x87 },
	0xc6e3, { 0xE3, 0x83, 0xBC },
	0xc6e4, { 0xEF, 0xBC, 0xBB },
	0xc6e5, { 0xEF, 0xBC, 0xBD },
	0xc6e6, { 0xE2, 0x9C, 0xBD },
	0xc6e7, { 0xE3, 0x81, 0x81 },
	0xc6e8, { 0xE3, 0x81, 0x82 },
	0xc6e9, { 0xE3, 0x81, 0x83 },
	0xc6ea, { 0xE3, 0x81, 0x84 },
	0xc6eb, { 0xE3, 0x81, 0x85 },
	0xc6ec, { 0xE3, 0x81, 0x86 },
	0xc6ed, { 0xE3, 0x81, 0x87 },
	0xc6ee, { 0xE3, 0x81, 0x88 },
	0xc6ef, { 0xE3, 0x81, 0x89 },
	0xc6f0, { 0xE3, 0x81, 0x8A },
	0xc6f1, { 0xE3, 0x81, 0x8B },
	0xc6f2, { 0xE3, 0x81, 0x8C },
	0xc6f3, { 0xE3, 0x81, 0x8D },
	0xc6f4, { 0xE3, 0x81, 0x8E },
	0xc6f5, { 0xE3, 0x81, 0x8F },
	0xc6f6, { 0xE3, 0x81, 0x90 },
	0xc6f7, { 0xE3, 0x81, 0x91 },
	0xc6f8, { 0xE3, 0x81, 0x92 },
	0xc6f9, { 0xE3, 0x81, 0x93 },
	0xc6fa, { 0xE3, 0x81, 0x94 },
	0xc6fb, { 0xE3, 0x81, 0x95 },
	0xc6fc, { 0xE3, 0x81, 0x96 },
	0xc6fd, { 0xE3, 0x81, 0x97 },
	0xc6fe, { 0xE3, 0x81, 0x98 },
	0xc740, { 0xE3, 0x81, 0x99 },
	0xc741, { 0xE3, 0x81, 0x9A },
	0xc742, { 0xE3, 0x81, 0x9B },
	0xc743, { 0xE3, 0x81, 0x9C },
	0xc744, { 0xE3, 0x81, 0x9D },
	0xc745, { 0xE3, 0x81, 0x9E },
	0xc746, { 0xE3, 0x81, 0x9F },
	0xc747, { 0xE3, 0x81, 0xA0 },
	0xc748, { 0xE3, 0x81, 0xA1 },
	0xc749, { 0xE3, 0x81, 0xA2 },
	0xc74a, { 0xE3, 0x81, 0xA3 },
	0xc74b, { 0xE3, 0x81, 0xA4 },
	0xc74c, { 0xE3, 0x81, 0xA5 },
	0xc74d, { 0xE3, 0x81, 0xA6 },
	0xc74e, { 0xE3, 0x81, 0xA7 },
	0xc74f, { 0xE3, 0x81, 0xA8 },
	0xc750, { 0xE3, 0x81, 0xA9 },
	0xc751, { 0xE3, 0x81, 0xAA },
	0xc752, { 0xE3, 0x81, 0xAB },
	0xc753, { 0xE3, 0x81, 0xAC },
	0xc754, { 0xE3, 0x81, 0xAD },
	0xc755, { 0xE3, 0x81, 0xAE },
	0xc756, { 0xE3, 0x81, 0xAF },
	0xc757, { 0xE3, 0x81, 0xB0 },
	0xc758, { 0xE3, 0x81, 0xB1 },
	0xc759, { 0xE3, 0x81, 0xB2 },
	0xc75a, { 0xE3, 0x81, 0xB3 },
	0xc75b, { 0xE3, 0x81, 0xB4 },
	0xc75c, { 0xE3, 0x81, 0xB5 },
	0xc75d, { 0xE3, 0x81, 0xB6 },
	0xc75e, { 0xE3, 0x81, 0xB7 },
	0xc75f, { 0xE3, 0x81, 0xB8 },
	0xc760, { 0xE3, 0x81, 0xB9 },
	0xc761, { 0xE3, 0x81, 0xBA },
	0xc762, { 0xE3, 0x81, 0xBB },
	0xc763, { 0xE3, 0x81, 0xBC },
	0xc764, { 0xE3, 0x81, 0xBD },
	0xc765, { 0xE3, 0x81, 0xBE },
	0xc766, { 0xE3, 0x81, 0xBF },
	0xc767, { 0xE3, 0x82, 0x80 },
	0xc768, { 0xE3, 0x82, 0x81 },
	0xc769, { 0xE3, 0x82, 0x82 },
	0xc76a, { 0xE3, 0x82, 0x83 },
	0xc76b, { 0xE3, 0x82, 0x84 },
	0xc76c, { 0xE3, 0x82, 0x85 },
	0xc76d, { 0xE3, 0x82, 0x86 },
	0xc76e, { 0xE3, 0x82, 0x87 },
	0xc76f, { 0xE3, 0x82, 0x88 },
	0xc770, { 0xE3, 0x82, 0x89 },
	0xc771, { 0xE3, 0x82, 0x8A },
	0xc772, { 0xE3, 0x82, 0x8B },
	0xc773, { 0xE3, 0x82, 0x8C },
	0xc774, { 0xE3, 0x82, 0x8D },
	0xc775, { 0xE3, 0x82, 0x8E },
	0xc776, { 0xE3, 0x82, 0x8F },
	0xc777, { 0xE3, 0x82, 0x90 },
	0xc778, { 0xE3, 0x82, 0x91 },
	0xc779, { 0xE3, 0x82, 0x92 },
	0xc77a, { 0xE3, 0x82, 0x93 },
	0xc77b, { 0xE3, 0x82, 0xA1 },
	0xc77c, { 0xE3, 0x82, 0xA2 },
	0xc77d, { 0xE3, 0x82, 0xA3 },
	0xc77e, { 0xE3, 0x82, 0xA4 },
	0xc7a1, { 0xE3, 0x82, 0xA5 },
	0xc7a2, { 0xE3, 0x82, 0xA6 },
	0xc7a3, { 0xE3, 0x82, 0xA7 },
	0xc7a4, { 0xE3, 0x82, 0xA8 },
	0xc7a5, { 0xE3, 0x82, 0xA9 },
	0xc7a6, { 0xE3, 0x82, 0xAA },
	0xc7a7, { 0xE3, 0x82, 0xAB },
	0xc7a8, { 0xE3, 0x82, 0xAC },
	0xc7a9, { 0xE3, 0x82, 0xAD },
	0xc7aa, { 0xE3, 0x82, 0xAE },
	0xc7ab, { 0xE3, 0x82, 0xAF },
	0xc7ac, { 0xE3, 0x82, 0xB0 },
	0xc7ad, { 0xE3, 0x82, 0xB1 },
	0xc7ae, { 0xE3, 0x82, 0xB2 },
	0xc7af, { 0xE3, 0x82, 0xB3 },
	0xc7b0, { 0xE3, 0x82, 0xB4 },
	0xc7b1, { 0xE3, 0x82, 0xB5 },
	0xc7b2, { 0xE3, 0x82, 0xB6 },
	0xc7b3, { 0xE3, 0x82, 0xB7 },
	0xc7b4, { 0xE3, 0x82, 0xB8 },
	0xc7b5, { 0xE3, 0x82, 0xB9 },
	0xc7b6, { 0xE3, 0x82, 0xBA },
	0xc7b7, { 0xE3, 0x82, 0xBB },
	0xc7b8, { 0xE3, 0x82, 0xBC },
	0xc7b9, { 0xE3, 0x82, 0xBD },
	0xc7ba, { 0xE3, 0x82, 0xBE },
	0xc7bb, { 0xE3, 0x82, 0xBF },
	0xc7bc, { 0xE3, 0x83, 0x80 },
	0xc7bd, { 0xE3, 0x83, 0x81 },
	0xc7be, { 0xE3, 0x83, 0x82 },
	0xc7bf, { 0xE3, 0x83, 0x83 },
	0xc7c0, { 0xE3, 0x83, 0x84 },
	0xc7c1, { 0xE3, 0x83, 0x85 },
	0xc7c2, { 0xE3, 0x83, 0x86 },
	0xc7c3, { 0xE3, 0x83, 0x87 },
	0xc7c4, { 0xE3, 0x83, 0x88 },
	0xc7c5, { 0xE3, 0x83, 0x89 },
	0xc7c6, { 0xE3, 0x83, 0x8A },
	0xc7c7, { 0xE3, 0x83, 0x8B },
	0xc7c8, { 0xE3, 0x83, 0x8C },
	0xc7c9, { 0xE3, 0x83, 0x8D },
	0xc7ca, { 0xE3, 0x83, 0x8E },
	0xc7cb, { 0xE3, 0x83, 0x8F },
	0xc7cc, { 0xE3, 0x83, 0x90 },
	0xc7cd, { 0xE3, 0x83, 0x91 },
	0xc7ce, { 0xE3, 0x83, 0x92 },
	0xc7cf, { 0xE3, 0x83, 0x93 },
	0xc7d0, { 0xE3, 0x83, 0x94 },
	0xc7d1, { 0xE3, 0x83, 0x95 },
	0xc7d2, { 0xE3, 0x83, 0x96 },
	0xc7d3, { 0xE3, 0x83, 0x97 },
	0xc7d4, { 0xE3, 0x83, 0x98 },
	0xc7d5, { 0xE3, 0x83, 0x99 },
	0xc7d6, { 0xE3, 0x83, 0x9A },
	0xc7d7, { 0xE3, 0x83, 0x9B },
	0xc7d8, { 0xE3, 0x83, 0x9C },
	0xc7d9, { 0xE3, 0x83, 0x9D },
	0xc7da, { 0xE3, 0x83, 0x9E },
	0xc7db, { 0xE3, 0x83, 0x9F },
	0xc7dc, { 0xE3, 0x83, 0xA0 },
	0xc7dd, { 0xE3, 0x83, 0xA1 },
	0xc7de, { 0xE3, 0x83, 0xA2 },
	0xc7df, { 0xE3, 0x83, 0xA3 },
	0xc7e0, { 0xE3, 0x83, 0xA4 },
	0xc7e1, { 0xE3, 0x83, 0xA5 },
	0xc7e2, { 0xE3, 0x83, 0xA6 },
	0xc7e3, { 0xE3, 0x83, 0xA7 },
	0xc7e4, { 0xE3, 0x83, 0xA8 },
	0xc7e5, { 0xE3, 0x83, 0xA9 },
	0xc7e6, { 0xE3, 0x83, 0xAA },
	0xc7e7, { 0xE3, 0x83, 0xAB },
	0xc7e8, { 0xE3, 0x83, 0xAC },
	0xc7e9, { 0xE3, 0x83, 0xAD },
	0xc7ea, { 0xE3, 0x83, 0xAE },
	0xc7eb, { 0xE3, 0x83, 0xAF },
	0xc7ec, { 0xE3, 0x83, 0xB0 },
	0xc7ed, { 0xE3, 0x83, 0xB1 },
	0xc7ee, { 0xE3, 0x83, 0xB2 },
	0xc7ef, { 0xE3, 0x83, 0xB3 },
	0xc7f0, { 0xE3, 0x83, 0xB4 },
	0xc7f1, { 0xE3, 0x83, 0xB5 },
	0xc7f2, { 0xE3, 0x83, 0xB6 },
	0xc7f3, { 0xD0, 0x90 },
	0xc7f4, { 0xD0, 0x91 },
	0xc7f5, { 0xD0, 0x92 },
	0xc7f6, { 0xD0, 0x93 },
	0xc7f7, { 0xD0, 0x94 },
	0xc7f8, { 0xD0, 0x95 },
	0xc7f9, { 0xD0, 0x81 },
	0xc7fa, { 0xD0, 0x96 },
	0xc7fb, { 0xD0, 0x97 },
	0xc7fc, { 0xD0, 0x98 },
	0xc7fd, { 0xD0, 0x99 },
	0xc7fe, { 0xD0, 0x9A },
	0xc840, { 0xD0, 0x9B },
	0xc841, { 0xD0, 0x9C },
	0xc842, { 0xD0, 0x9D },
	0xc843, { 0xD0, 0x9E },
	0xc844, { 0xD0, 0x9F },
	0xc845, { 0xD0, 0xA0 },
	0xc846, { 0xD0, 0xA1 },
	0xc847, { 0xD0, 0xA2 },
	0xc848, { 0xD0, 0xA3 },
	0xc849, { 0xD0, 0xA4 },
	0xc84a, { 0xD0, 0xA5 },
	0xc84b, { 0xD0, 0xA6 },
	0xc84c, { 0xD0, 0xA7 },
	0xc84d, { 0xD0, 0xA8 },
	0xc84e, { 0xD0, 0xA9 },
	0xc84f, { 0xD0, 0xAA },
	0xc850, { 0xD0, 0xAB },
	0xc851, { 0xD0, 0xAC },
	0xc852, { 0xD0, 0xAD },
	0xc853, { 0xD0, 0xAE },
	0xc854, { 0xD0, 0xAF },
	0xc855, { 0xD0, 0xB0 },
	0xc856, { 0xD0, 0xB1 },
	0xc857, { 0xD0, 0xB2 },
	0xc858, { 0xD0, 0xB3 },
	0xc859, { 0xD0, 0xB4 },
	0xc85a, { 0xD0, 0xB5 },
	0xc85b, { 0xD1, 0x91 },
	0xc85c, { 0xD0, 0xB6 },
	0xc85d, { 0xD0, 0xB7 },
	0xc85e, { 0xD0, 0xB8 },
	0xc85f, { 0xD0, 0xB9 },
	0xc860, { 0xD0, 0xBA },
	0xc861, { 0xD0, 0xBB },
	0xc862, { 0xD0, 0xBC },
	0xc863, { 0xD0, 0xBD },
	0xc864, { 0xD0, 0xBE },
	0xc865, { 0xD0, 0xBF },
	0xc866, { 0xD1, 0x80 },
	0xc867, { 0xD1, 0x81 },
	0xc868, { 0xD1, 0x82 },
	0xc869, { 0xD1, 0x83 },
	0xc86a, { 0xD1, 0x84 },
	0xc86b, { 0xD1, 0x85 },
	0xc86c, { 0xD1, 0x86 },
	0xc86d, { 0xD1, 0x87 },
	0xc86e, { 0xD1, 0x88 },
	0xc86f, { 0xD1, 0x89 },
	0xc870, { 0xD1, 0x8A },
	0xc871, { 0xD1, 0x8B },
	0xc872, { 0xD1, 0x8C },
	0xc873, { 0xD1, 0x8D },
	0xc874, { 0xD1, 0x8E },
	0xc875, { 0xD1, 0x8F },
	0xc876, { 0xE2, 0x87, 0xA7 },
	0xc877, { 0xE2, 0x86, 0xB8 },
	0xc878, { 0xE2, 0x86, 0xB9 },
	0xc879, { 0xEF, 0x9F, 0xA5 },
	0xc87a, { 0xEF, 0x9F, 0xA6 },
	0xc87b, { 0xE4, 0xB9, 0x9A },
	0xc87c, { 0xEF, 0x9F, 0xA8 },
	0xc87d, { 0xE5, 0x88, 0x82 },
	0xc87e, { 0xEF, 0x9F, 0xAA },
	0xc8a1, { 0xEF, 0x9F, 0xAB },
	0xc8a2, { 0xE5, 0x86, 0x88 },
	0xc8a3, { 0xEF, 0x9F, 0xAD },
	0xc8a4, { 0xEF, 0x9F, 0xAE },
	0xc8cd, { 0xEF, 0xBF, 0xA2 },
	0xc8ce, { 0xEF, 0xBF, 0xA4 },
	0xc8cf, { 0xEF, 0xBC, 0x87 },
	0xc8d0, { 0xEF, 0xBC, 0x82 },
	0xc8d1, { 0xE3, 0x88, 0xB1 },
	0xc8d2, { 0xE2, 0x84, 0x96 },
	0xc8d3, { 0xE2, 0x84, 0xA1 },
	0xc8d4, { 0xE3, 0x82, 0x9B },
	0xc8d5, { 0xE3, 0x82, 0x9C },
	0xc8d6, { 0xE2, 0xBA, 0x80 },
	0xc8d7, { 0xE2, 0xBA, 0x84 },
	0xc8d8, { 0xE2, 0xBA, 0x86 },
	0xc8d9, { 0xE2, 0xBA, 0x87 },
	0xc8da, { 0xE2, 0xBA, 0x88 },
	0xc8db, { 0xE2, 0xBA, 0x8A },
	0xc8dc, { 0xE2, 0xBA, 0x8C },
	0xc8dd, { 0xE2, 0xBA, 0x8D },
	0xc8de, { 0xE2, 0xBA, 0x95 },
	0xc8df, { 0xE2, 0xBA, 0x9C },
	0xc8e0, { 0xE2, 0xBA, 0x9D },
	0xc8e1, { 0xE2, 0xBA, 0xA5 },
	0xc8e2, { 0xE2, 0xBA, 0xA7 },
	0xc8e3, { 0xE2, 0xBA, 0xAA },
	0xc8e4, { 0xE2, 0xBA, 0xAC },
	0xc8e5, { 0xE2, 0xBA, 0xAE },
	0xc8e6, { 0xE2, 0xBA, 0xB6 },
	0xc8e7, { 0xE2, 0xBA, 0xBC },
	0xc8e8, { 0xE2, 0xBA, 0xBE },
	0xc8e9, { 0xE2, 0xBB, 0x86 },
	0xc8ea, { 0xE2, 0xBB, 0x8A },
	0xc8eb, { 0xE2, 0xBB, 0x8C },
	0xc8ec, { 0xE2, 0xBB, 0x8D },
	0xc8ed, { 0xE2, 0xBB, 0x8F },
	0xc8ee, { 0xE2, 0xBB, 0x96 },
	0xc8ef, { 0xE2, 0xBB, 0x97 },
	0xc8f0, { 0xE2, 0xBB, 0x9E },
	0xc8f1, { 0xE2, 0xBB, 0xA3 },
	0xc8f5, { 0xCA, 0x83 },
	0xc8f6, { 0xC9, 0x90 },
	0xc8f7, { 0xC9, 0x9B },
	0xc8f8, { 0xC9, 0x94 },
	0xc8f9, { 0xC9, 0xB5 },
	0xc8fa, { 0xC5, 0x93 },
	0xc8fb, { 0xC3, 0xB8 },
	0xc8fc, { 0xC5, 0x8B },
	0xc8fd, { 0xCA, 0x8A },
	0xc8fe, { 0xC9, 0xAA },
	0xc940, { 0xE4, 0xB9, 0x82 },
	0xc941, { 0xE4, 0xB9, 0x9C },
	0xc942, { 0xE5, 0x87, 0xB5 },
	0xc943, { 0xE5, 0x8C, 0x9A },
	0xc944, { 0xE5, 0x8E, 0x82 },
	0xc945, { 0xE4, 0xB8, 0x87 },
	0xc946, { 0xE4, 0xB8, 0x8C },
	0xc947, { 0xE4, 0xB9, 0x87 },
	0xc948, { 0xE4, 0xBA, 0x8D },
	0xc949, { 0xE5, 0x9B, 0x97 },
	0xc94a, { 0xEF, 0xA8, 0x8C },
	0xc94b, { 0xE5, 0xB1, 0xAE },
	0xc94c, { 0xE5, 0xBD, 0xB3 },
	0xc94d, { 0xE4, 0xB8, 0x8F },
	0xc94e, { 0xE5, 0x86, 0x87 },
	0xc94f, { 0xE4, 0xB8, 0x8E },
	0xc950, { 0xE4, 0xB8, 0xAE },
	0xc951, { 0xE4, 0xBA, 0x93 },
	0xc952, { 0xE4, 0xBB, 0x82 },
	0xc953, { 0xE4, 0xBB, 0x89 },
	0xc954, { 0xE4, 0xBB, 0x88 },
	0xc955, { 0xE5, 0x86, 0x98 },
	0xc956, { 0xE5, 0x8B, 0xBC },
	0xc957, { 0xE5, 0x8D, 0xAC },
	0xc958, { 0xE5, 0x8E, 0xB9 },
	0xc959, { 0xE5, 0x9C, 0xA0 },
	0xc95a, { 0xE5, 0xA4, 0x83 },
	0xc95b, { 0xE5, 0xA4, 0xAC },
	0xc95c, { 0xE5, 0xB0, 0x90 },
	0xc95d, { 0xE5, 0xB7, 0xBF },
	0xc95e, { 0xE6, 0x97, 0xA1 },
	0xc95f, { 0xE6, 0xAE, 0xB3 },
	0xc960, { 0xE6, 0xAF, 0x8C },
	0xc961, { 0xE6, 0xB0, 0x94 },
	0xc962, { 0xE7, 0x88, 0xBF },
	0xc963, { 0xE4, 0xB8, 0xB1 },
	0xc964, { 0xE4, 0xB8, 0xBC },
	0xc965, { 0xE4, 0xBB, 0xA8 },
	0xc966, { 0xE4, 0xBB, 0x9C },
	0xc967, { 0xE4, 0xBB, 0xA9 },
	0xc968, { 0xE4, 0xBB, 0xA1 },
	0xc969, { 0xE4, 0xBB, 0x9D },
	0xc96a, { 0xE4, 0xBB, 0x9A },
	0xc96b, { 0xE5, 0x88, 0x8C },
	0xc96c, { 0xE5, 0x8C, 0x9C },
	0xc96d, { 0xE5, 0x8D, 0x8C },
	0xc96e, { 0xE5, 0x9C, 0xA2 },
	0xc96f, { 0xE5, 0x9C, 0xA3 },
	0xc970, { 0xE5, 0xA4, 0x97 },
	0xc971, { 0xE5, 0xA4, 0xAF },
	0xc972, { 0xE5, 0xAE, 0x81 },
	0xc973, { 0xE5, 0xAE, 0x84 },
	0xc974, { 0xE5, 0xB0, 0x92 },
	0xc975, { 0xE5, 0xB0, 0xBB },
	0xc976, { 0xE5, 0xB1, 0xB4 },
	0xc977, { 0xE5, 0xB1, 0xB3 },
	0xc978, { 0xE5, 0xB8, 0x84 },
	0xc979, { 0xE5, 0xBA, 0x80 },
	0xc97a, { 0xE5, 0xBA, 0x82 },
	0xc97b, { 0xE5, 0xBF, 0x89 },
	0xc97c, { 0xE6, 0x88, 0x89 },
	0xc97d, { 0xE6, 0x89, 0x90 },
	0xc97e, { 0xE6, 0xB0, 0x95 },
	0xc9a1, { 0xE6, 0xB0, 0xB6 },
	0xc9a2, { 0xE6, 0xB1, 0x83 },
	0xc9a3, { 0xE6, 0xB0, 0xBF },
	0xc9a4, { 0xE6, 0xB0, 0xBB },
	0xc9a5, { 0xE7, 0x8A, 0xAE },
	0xc9a6, { 0xE7, 0x8A, 0xB0 },
	0xc9a7, { 0xE7, 0x8E, 0x8A },
	0xc9a8, { 0xE7, 0xA6, 0xB8 },
	0xc9a9, { 0xE8, 0x82, 0x8A },
	0xc9aa, { 0xE9, 0x98, 0x9E },
	0xc9ab, { 0xE4, 0xBC, 0x8E },
	0xc9ac, { 0xE4, 0xBC, 0x98 },
	0xc9ad, { 0xE4, 0xBC, 0xAC },
	0xc9ae, { 0xE4, 0xBB, 0xB5 },
	0xc9af, { 0xE4, 0xBC, 0x94 },
	0xc9b0, { 0xE4, 0xBB, 0xB1 },
	0xc9b1, { 0xE4, 0xBC, 0x80 },
	0xc9b2, { 0xE4, 0xBB, 0xB7 },
	0xc9b3, { 0xE4, 0xBC, 0x88 },
	0xc9b4, { 0xE4, 0xBC, 0x9D },
	0xc9b5, { 0xE4, 0xBC, 0x82 },
	0xc9b6, { 0xE4, 0xBC, 0x85 },
	0xc9b7, { 0xE4, 0xBC, 0xA2 },
	0xc9b8, { 0xE4, 0xBC, 0x93 },
	0xc9b9, { 0xE4, 0xBC, 0x84 },
	0xc9ba, { 0xE4, 0xBB, 0xB4 },
	0xc9bb, { 0xE4, 0xBC, 0x92 },
	0xc9bc, { 0xE5, 0x86, 0xB1 },
	0xc9bd, { 0xE5, 0x88, 0x93 },
	0xc9be, { 0xE5, 0x88, 0x89 },
	0xc9bf, { 0xE5, 0x88, 0x90 },
	0xc9c0, { 0xE5, 0x8A, 0xA6 },
	0xc9c1, { 0xE5, 0x8C, 0xA2 },
	0xc9c2, { 0xE5, 0x8C, 0x9F },
	0xc9c3, { 0xE5, 0x8D, 0x8D },
	0xc9c4, { 0xE5, 0x8E, 0x8A },
	0xc9c5, { 0xE5, 0x90, 0x87 },
	0xc9c6, { 0xE5, 0x9B, 0xA1 },
	0xc9c7, { 0xE5, 0x9B, 0x9F },
	0xc9c8, { 0xE5, 0x9C, 0xAE },
	0xc9c9, { 0xE5, 0x9C, 0xAA },
	0xc9ca, { 0xE5, 0x9C, 0xB4 },
	0xc9cb, { 0xE5, 0xA4, 0xBC },
	0xc9cc, { 0xE5, 0xA6, 0x80 },
	0xc9cd, { 0xE5, 0xA5, 0xBC },
	0xc9ce, { 0xE5, 0xA6, 0x85 },
	0xc9cf, { 0xE5, 0xA5, 0xBB },
	0xc9d0, { 0xE5, 0xA5, 0xBE },
	0xc9d1, { 0xE5, 0xA5, 0xB7 },
	0xc9d2, { 0xE5, 0xA5, 0xBF },
	0xc9d3, { 0xE5, 0xAD, 0x96 },
	0xc9d4, { 0xE5, 0xB0, 0x95 },
	0xc9d5, { 0xE5, 0xB0, 0xA5 },
	0xc9d6, { 0xE5, 0xB1, 0xBC },
	0xc9d7, { 0xE5, 0xB1, 0xBA },
	0xc9d8, { 0xE5, 0xB1, 0xBB },
	0xc9d9, { 0xE5, 0xB1, 0xBE },
	0xc9da, { 0xE5, 0xB7, 0x9F },
	0xc9db, { 0xE5, 0xB9, 0xB5 },
	0xc9dc, { 0xE5, 0xBA, 0x84 },
	0xc9dd, { 0xE5, 0xBC, 0x82 },
	0xc9de, { 0xE5, 0xBC, 0x9A },
	0xc9df, { 0xE5, 0xBD, 0xB4 },
	0xc9e0, { 0xE5, 0xBF, 0x95 },
	0xc9e1, { 0xE5, 0xBF, 0x94 },
	0xc9e2, { 0xE5, 0xBF, 0x8F },
	0xc9e3, { 0xE6, 0x89, 0x9C },
	0xc9e4, { 0xE6, 0x89, 0x9E },
	0xc9e5, { 0xE6, 0x89, 0xA4 },
	0xc9e6, { 0xE6, 0x89, 0xA1 },
	0xc9e7, { 0xE6, 0x89, 0xA6 },
	0xc9e8, { 0xE6, 0x89, 0xA2 },
	0xc9e9, { 0xE6, 0x89, 0x99 },
	0xc9ea, { 0xE6, 0x89, 0xA0 },
	0xc9eb, { 0xE6, 0x89, 0x9A },
	0xc9ec, { 0xE6, 0x89, 0xA5 },
	0xc9ed, { 0xE6, 0x97, 0xAF },
	0xc9ee, { 0xE6, 0x97, 0xAE },
	0xc9ef, { 0xE6, 0x9C, 0xBE },
	0xc9f0, { 0xE6, 0x9C, 0xB9 },
	0xc9f1, { 0xE6, 0x9C, 0xB8 },
	0xc9f2, { 0xE6, 0x9C, 0xBB },
	0xc9f3, { 0xE6, 0x9C, 0xBA },
	0xc9f4, { 0xE6, 0x9C, 0xBF },
	0xc9f5, { 0xE6, 0x9C, 0xBC },
	0xc9f6, { 0xE6, 0x9C, 0xB3 },
	0xc9f7, { 0xE6, 0xB0, 0x98 },
	0xc9f8, { 0xE6, 0xB1, 0x86 },
	0xc9f9, { 0xE6, 0xB1, 0x92 },
	0xc9fa, { 0xE6, 0xB1, 0x9C },
	0xc9fb, { 0xE6, 0xB1, 0x8F },
	0xc9fc, { 0xE6, 0xB1, 0x8A },
	0xc9fd, { 0xE6, 0xB1, 0x94 },
	0xc9fe, { 0xE6, 0xB1, 0x8B },
	0xca40, { 0xE6, 0xB1, 0x8C },
	0xca41, { 0xE7, 0x81, 0xB1 },
	0xca42, { 0xE7, 0x89, 0x9E },
	0xca43, { 0xE7, 0x8A, 0xB4 },
	0xca44, { 0xE7, 0x8A, 0xB5 },
	0xca45, { 0xE7, 0x8E, 0x8E },
	0xca46, { 0xE7, 0x94, 0xAA },
	0xca47, { 0xE7, 0x99, 0xBF },
	0xca48, { 0xE7, 0xA9, 0xB5 },
	0xca49, { 0xE7, 0xBD, 0x91 },
	0xca4a, { 0xE8, 0x89, 0xB8 },
	0xca4b, { 0xE8, 0x89, 0xBC },
	0xca4c, { 0xE8, 0x8A, 0x80 },
	0xca4d, { 0xE8, 0x89, 0xBD },
	0xca4e, { 0xE8, 0x89, 0xBF },
	0xca4f, { 0xE8, 0x99, 0x8D },
	0xca50, { 0xE8, 0xA5, 0xBE },
	0xca51, { 0xE9, 0x82, 0x99 },
	0xca52, { 0xE9, 0x82, 0x97 },
	0xca53, { 0xE9, 0x82, 0x98 },
	0xca54, { 0xE9, 0x82, 0x9B },
	0xca55, { 0xE9, 0x82, 0x94 },
	0xca56, { 0xE9, 0x98, 0xA2 },
	0xca57, { 0xE9, 0x98, 0xA4 },
	0xca58, { 0xE9, 0x98, 0xA0 },
	0xca59, { 0xE9, 0x98, 0xA3 },
	0xca5a, { 0xE4, 0xBD, 0x96 },
	0xca5b, { 0xE4, 0xBC, 0xBB },
	0xca5c, { 0xE4, 0xBD, 0xA2 },
	0xca5d, { 0xE4, 0xBD, 0x89 },
	0xca5e, { 0xE4, 0xBD, 0x93 },
	0xca5f, { 0xE4, 0xBD, 0xA4 },
	0xca60, { 0xE4, 0xBC, 0xBE },
	0xca61, { 0xE4, 0xBD, 0xA7 },
	0xca62, { 0xE4, 0xBD, 0x92 },
	0xca63, { 0xE4, 0xBD, 0x9F },
	0xca64, { 0xE4, 0xBD, 0x81 },
	0xca65, { 0xE4, 0xBD, 0x98 },
	0xca66, { 0xE4, 0xBC, 0xAD },
	0xca67, { 0xE4, 0xBC, 0xB3 },
	0xca68, { 0xE4, 0xBC, 0xBF },
	0xca69, { 0xE4, 0xBD, 0xA1 },
	0xca6a, { 0xE5, 0x86, 0x8F },
	0xca6b, { 0xE5, 0x86, 0xB9 },
	0xca6c, { 0xE5, 0x88, 0x9C },
	0xca6d, { 0xE5, 0x88, 0x9E },
	0xca6e, { 0xE5, 0x88, 0xA1 },
	0xca6f, { 0xE5, 0x8A, 0xAD },
	0xca70, { 0xE5, 0x8A, 0xAE },
	0xca71, { 0xE5, 0x8C, 0x89 },
	0xca72, { 0xE5, 0x8D, 0xA3 },
	0xca73, { 0xE5, 0x8D, 0xB2 },
	0xca74, { 0xE5, 0x8E, 0x8E },
	0xca75, { 0xE5, 0x8E, 0x8F },
	0xca76, { 0xE5, 0x90, 0xB0 },
	0xca77, { 0xE5, 0x90, 0xB7 },
	0xca78, { 0xE5, 0x90, 0xAA },
	0xca79, { 0xE5, 0x91, 0x94 },
	0xca7a, { 0xE5, 0x91, 0x85 },
	0xca7b, { 0xE5, 0x90, 0x99 },
	0xca7c, { 0xE5, 0x90, 0x9C },
	0xca7d, { 0xE5, 0x90, 0xA5 },
	0xca7e, { 0xE5, 0x90, 0x98 },
	0xcaa1, { 0xE5, 0x90, 0xBD },
	0xcaa2, { 0xE5, 0x91, 0x8F },
	0xcaa3, { 0xE5, 0x91, 0x81 },
	0xcaa4, { 0xE5, 0x90, 0xA8 },
	0xcaa5, { 0xE5, 0x90, 0xA4 },
	0xcaa6, { 0xE5, 0x91, 0x87 },
	0xcaa7, { 0xE5, 0x9B, 0xAE },
	0xcaa8, { 0xE5, 0x9B, 0xA7 },
	0xcaa9, { 0xE5, 0x9B, 0xA5 },
	0xcaaa, { 0xE5, 0x9D, 0x81 },
	0xcaab, { 0xE5, 0x9D, 0x85 },
	0xcaac, { 0xE5, 0x9D, 0x8C },
	0xcaad, { 0xE5, 0x9D, 0x89 },
	0xcaae, { 0xE5, 0x9D, 0x8B },
	0xcaaf, { 0xE5, 0x9D, 0x92 },
	0xcab0, { 0xE5, 0xA4, 0x86 },
	0xcab1, { 0xE5, 0xA5, 0x80 },
	0xcab2, { 0xE5, 0xA6, 0xA6 },
	0xcab3, { 0xE5, 0xA6, 0x98 },
	0xcab4, { 0xE5, 0xA6, 0xA0 },
	0xcab5, { 0xE5, 0xA6, 0x97 },
	0xcab6, { 0xE5, 0xA6, 0x8E },
	0xcab7, { 0xE5, 0xA6, 0xA2 },
	0xcab8, { 0xE5, 0xA6, 0x90 },
	0xcab9, { 0xE5, 0xA6, 0x8F },
	0xcaba, { 0xE5, 0xA6, 0xA7 },
	0xcabb, { 0xE5, 0xA6, 0xA1 },
	0xcabc, { 0xE5, 0xAE, 0x8E },
	0xcabd, { 0xE5, 0xAE, 0x92 },
	0xcabe, { 0xE5, 0xB0, 0xA8 },
	0xcabf, { 0xE5, 0xB0, 0xAA },
	0xcac0, { 0xE5, 0xB2, 0x8D },
	0xcac1, { 0xE5, 0xB2, 0x8F },
	0xcac2, { 0xE5, 0xB2, 0x88 },
	0xcac3, { 0xE5, 0xB2, 0x8B },
	0xcac4, { 0xE5, 0xB2, 0x89 },
	0xcac5, { 0xE5, 0xB2, 0x92 },
	0xcac6, { 0xE5, 0xB2, 0x8A },
	0xcac7, { 0xE5, 0xB2, 0x86 },
	0xcac8, { 0xE5, 0xB2, 0x93 },
	0xcac9, { 0xE5, 0xB2, 0x95 },
	0xcaca, { 0xE5, 0xB7, 0xA0 },
	0xcacb, { 0xE5, 0xB8, 0x8A },
	0xcacc, { 0xE5, 0xB8, 0x8E },
	0xcacd, { 0xE5, 0xBA, 0x8B },
	0xcace, { 0xE5, 0xBA, 0x89 },
	0xcacf, { 0xE5, 0xBA, 0x8C },
	0xcad0, { 0xE5, 0xBA, 0x88 },
	0xcad1, { 0xE5, 0xBA, 0x8D },
	0xcad2, { 0xE5, 0xBC, 0x85 },
	0xcad3, { 0xE5, 0xBC, 0x9D },
	0xcad4, { 0xE5, 0xBD, 0xB8 },
	0xcad5, { 0xE5, 0xBD, 0xB6 },
	0xcad6, { 0xE5, 0xBF, 0x92 },
	0xcad7, { 0xE5, 0xBF, 0x91 },
	0xcad8, { 0xE5, 0xBF, 0x90 },
	0xcad9, { 0xE5, 0xBF, 0xAD },
	0xcada, { 0xE5, 0xBF, 0xA8 },
	0xcadb, { 0xE5, 0xBF, 0xAE },
	0xcadc, { 0xE5, 0xBF, 0xB3 },
	0xcadd, { 0xE5, 0xBF, 0xA1 },
	0xcade, { 0xE5, 0xBF, 0xA4 },
	0xcadf, { 0xE5, 0xBF, 0xA3 },
	0xcae0, { 0xE5, 0xBF, 0xBA },
	0xcae1, { 0xE5, 0xBF, 0xAF },
	0xcae2, { 0xE5, 0xBF, 0xB7 },
	0xcae3, { 0xE5, 0xBF, 0xBB },
	0xcae4, { 0xE6, 0x80, 0x80 },
	0xcae5, { 0xE5, 0xBF, 0xB4 },
	0xcae6, { 0xE6, 0x88, 0xBA },
	0xcae7, { 0xE6, 0x8A, 0x83 },
	0xcae8, { 0xE6, 0x8A, 0x8C },
	0xcae9, { 0xE6, 0x8A, 0x8E },
	0xcaea, { 0xE6, 0x8A, 0x8F },
	0xcaeb, { 0xE6, 0x8A, 0x94 },
	0xcaec, { 0xE6, 0x8A, 0x87 },
	0xcaed, { 0xE6, 0x89, 0xB1 },
	0xcaee, { 0xE6, 0x89, 0xBB },
	0xcaef, { 0xE6, 0x89, 0xBA },
	0xcaf0, { 0xE6, 0x89, 0xB0 },
	0xcaf1, { 0xE6, 0x8A, 0x81 },
	0xcaf2, { 0xE6, 0x8A, 0x88 },
	0xcaf3, { 0xE6, 0x89, 0xB7 },
	0xcaf4, { 0xE6, 0x89, 0xBD },
	0xcaf5, { 0xE6, 0x89, 0xB2 },
	0xcaf6, { 0xE6, 0x89, 0xB4 },
	0xcaf7, { 0xE6, 0x94, 0xB7 },
	0xcaf8, { 0xE6, 0x97, 0xB0 },
	0xcaf9, { 0xE6, 0x97, 0xB4 },
	0xcafa, { 0xE6, 0x97, 0xB3 },
	0xcafb, { 0xE6, 0x97, 0xB2 },
	0xcafc, { 0xE6, 0x97, 0xB5 },
	0xcafd, { 0xE6, 0x9D, 0x85 },
	0xcafe, { 0xE6, 0x9D, 0x87 },
	0xcb40, { 0xE6, 0x9D, 0x99 },
	0xcb41, { 0xE6, 0x9D, 0x95 },
	0xcb42, { 0xE6, 0x9D, 0x8C },
	0xcb43, { 0xE6, 0x9D, 0x88 },
	0xcb44, { 0xE6, 0x9D, 0x9D },
	0xcb45, { 0xE6, 0x9D, 0x8D },
	0xcb46, { 0xE6, 0x9D, 0x9A },
	0xcb47, { 0xE6, 0x9D, 0x8B },
	0xcb48, { 0xE6, 0xAF, 0x90 },
	0xcb49, { 0xE6, 0xB0, 0x99 },
	0xcb4a, { 0xE6, 0xB0, 0x9A },
	0xcb4b, { 0xE6, 0xB1, 0xB8 },
	0xcb4c, { 0xE6, 0xB1, 0xA7 },
	0xcb4d, { 0xE6, 0xB1, 0xAB },
	0xcb4e, { 0xE6, 0xB2, 0x84 },
	0xcb4f, { 0xE6, 0xB2, 0x8B },
	0xcb50, { 0xE6, 0xB2, 0x8F },
	0xcb51, { 0xE6, 0xB1, 0xB1 },
	0xcb52, { 0xE6, 0xB1, 0xAF },
	0xcb53, { 0xE6, 0xB1, 0xA9 },
	0xcb54, { 0xE6, 0xB2, 0x9A },
	0xcb55, { 0xE6, 0xB1, 0xAD },
	0xcb56, { 0xE6, 0xB2, 0x87 },
	0xcb57, { 0xE6, 0xB2, 0x95 },
	0xcb58, { 0xE6, 0xB2, 0x9C },
	0xcb59, { 0xE6, 0xB1, 0xA6 },
	0xcb5a, { 0xE6, 0xB1, 0xB3 },
	0xcb5b, { 0xE6, 0xB1, 0xA5 },
	0xcb5c, { 0xE6, 0xB1, 0xBB },
	0xcb5d, { 0xE6, 0xB2, 0x8E },
	0xcb5e, { 0xE7, 0x81, 0xB4 },
	0xcb5f, { 0xE7, 0x81, 0xBA },
	0xcb60, { 0xE7, 0x89, 0xA3 },
	0xcb61, { 0xE7, 0x8A, 0xBF },
	0xcb62, { 0xE7, 0x8A, 0xBD },
	0xcb63, { 0xE7, 0x8B, 0x83 },
	0xcb64, { 0xE7, 0x8B, 0x86 },
	0xcb65, { 0xE7, 0x8B, 0x81 },
	0xcb66, { 0xE7, 0x8A, 0xBA },
	0xcb67, { 0xE7, 0x8B, 0x85 },
	0xcb68, { 0xE7, 0x8E, 0x95 },
	0xcb69, { 0xE7, 0x8E, 0x97 },
	0xcb6a, { 0xE7, 0x8E, 0x93 },
	0xcb6b, { 0xE7, 0x8E, 0x94 },
	0xcb6c, { 0xE7, 0x8E, 0x92 },
	0xcb6d, { 0xE7, 0x94, 0xBA },
	0xcb6e, { 0xE7, 0x94, 0xB9 },
	0xcb6f, { 0xE7, 0x96, 0x94 },
	0xcb70, { 0xE7, 0x96, 0x95 },
	0xcb71, { 0xE7, 0x9A, 0x81 },
	0xcb72, { 0xE7, 0xA4, 0xBD },
	0xcb73, { 0xE8, 0x80, 0xB4 },
	0xcb74, { 0xE8, 0x82, 0x95 },
	0xcb75, { 0xE8, 0x82, 0x99 },
	0xcb76, { 0xE8, 0x82, 0x90 },
	0xcb77, { 0xE8, 0x82, 0x92 },
	0xcb78, { 0xE8, 0x82, 0x9C },
	0xcb79, { 0xE8, 0x8A, 0x90 },
	0xcb7a, { 0xE8, 0x8A, 0x8F },
	0xcb7b, { 0xE8, 0x8A, 0x85 },
	0xcb7c, { 0xE8, 0x8A, 0x8E },
	0xcb7d, { 0xE8, 0x8A, 0x91 },
	0xcb7e, { 0xE8, 0x8A, 0x93 },
	0xcba1, { 0xE8, 0x8A, 0x8A },
	0xcba2, { 0xE8, 0x8A, 0x83 },
	0xcba3, { 0xE8, 0x8A, 0x84 },
	0xcba4, { 0xE8, 0xB1, 0xB8 },
	0xcba5, { 0xE8, 0xBF, 0x89 },
	0xcba6, { 0xE8, 0xBE, 0xBF },
	0xcba7, { 0xE9, 0x82, 0x9F },
	0xcba8, { 0xE9, 0x82, 0xA1 },
	0xcba9, { 0xE9, 0x82, 0xA5 },
	0xcbaa, { 0xE9, 0x82, 0x9E },
	0xcbab, { 0xE9, 0x82, 0xA7 },
	0xcbac, { 0xE9, 0x82, 0xA0 },
	0xcbad, { 0xE9, 0x98, 0xB0 },
	0xcbae, { 0xE9, 0x98, 0xA8 },
	0xcbaf, { 0xE9, 0x98, 0xAF },
	0xcbb0, { 0xE9, 0x98, 0xAD },
	0xcbb1, { 0xE4, 0xB8, 0xB3 },
	0xcbb2, { 0xE4, 0xBE, 0x98 },
	0xcbb3, { 0xE4, 0xBD, 0xBC },
	0xcbb4, { 0xE4, 0xBE, 0x85 },
	0xcbb5, { 0xE4, 0xBD, 0xBD },
	0xcbb6, { 0xE4, 0xBE, 0x80 },
	0xcbb7, { 0xE4, 0xBE, 0x87 },
	0xcbb8, { 0xE4, 0xBD, 0xB6 },
	0xcbb9, { 0xE4, 0xBD, 0xB4 },
	0xcbba, { 0xE4, 0xBE, 0x89 },
	0xcbbb, { 0xE4, 0xBE, 0x84 },
	0xcbbc, { 0xE4, 0xBD, 0xB7 },
	0xcbbd, { 0xE4, 0xBD, 0x8C },
	0xcbbe, { 0xE4, 0xBE, 0x97 },
	0xcbbf, { 0xE4, 0xBD, 0xAA },
	0xcbc0, { 0xE4, 0xBE, 0x9A },
	0xcbc1, { 0xE4, 0xBD, 0xB9 },
	0xcbc2, { 0xE4, 0xBE, 0x81 },
	0xcbc3, { 0xE4, 0xBD, 0xB8 },
	0xcbc4, { 0xE4, 0xBE, 0x90 },
	0xcbc5, { 0xE4, 0xBE, 0x9C },
	0xcbc6, { 0xE4, 0xBE, 0x94 },
	0xcbc7, { 0xE4, 0xBE, 0x9E },
	0xcbc8, { 0xE4, 0xBE, 0x92 },
	0xcbc9, { 0xE4, 0xBE, 0x82 },
	0xcbca, { 0xE4, 0xBE, 0x95 },
	0xcbcb, { 0xE4, 0xBD, 0xAB },
	0xcbcc, { 0xE4, 0xBD, 0xAE },
	0xcbcd, { 0xE5, 0x86, 0x9E },
	0xcbce, { 0xE5, 0x86, 0xBC },
	0xcbcf, { 0xE5, 0x86, 0xBE },
	0xcbd0, { 0xE5, 0x88, 0xB5 },
	0xcbd1, { 0xE5, 0x88, 0xB2 },
	0xcbd2, { 0xE5, 0x88, 0xB3 },
	0xcbd3, { 0xE5, 0x89, 0x86 },
	0xcbd4, { 0xE5, 0x88, 0xB1 },
	0xcbd5, { 0xE5, 0x8A, 0xBC },
	0xcbd6, { 0xE5, 0x8C, 0x8A },
	0xcbd7, { 0xE5, 0x8C, 0x8B },
	0xcbd8, { 0xE5, 0x8C, 0xBC },
	0xcbd9, { 0xE5, 0x8E, 0x92 },
	0xcbda, { 0xE5, 0x8E, 0x94 },
	0xcbdb, { 0xE5, 0x92, 0x87 },
	0xcbdc, { 0xE5, 0x91, 0xBF },
	0xcbdd, { 0xE5, 0x92, 0x81 },
	0xcbde, { 0xE5, 0x92, 0x91 },
	0xcbdf, { 0xE5, 0x92, 0x82 },
	0xcbe0, { 0xE5, 0x92, 0x88 },
	0xcbe1, { 0xE5, 0x91, 0xAB },
	0xcbe2, { 0xE5, 0x91, 0xBA },
	0xcbe3, { 0xE5, 0x91, 0xBE },
	0xcbe4, { 0xE5, 0x91, 0xA5 },
	0xcbe5, { 0xE5, 0x91, 0xAC },
	0xcbe6, { 0xE5, 0x91, 0xB4 },
	0xcbe7, { 0xE5, 0x91, 0xA6 },
	0xcbe8, { 0xE5, 0x92, 0x8D },
	0xcbe9, { 0xE5, 0x91, 0xAF },
	0xcbea, { 0xE5, 0x91, 0xA1 },
	0xcbeb, { 0xE5, 0x91, 0xA0 },
	0xcbec, { 0xE5, 0x92, 0x98 },
	0xcbed, { 0xE5, 0x91, 0xA3 },
	0xcbee, { 0xE5, 0x91, 0xA7 },
	0xcbef, { 0xE5, 0x91, 0xA4 },
	0xcbf0, { 0xE5, 0x9B, 0xB7 },
	0xcbf1, { 0xE5, 0x9B, 0xB9 },
	0xcbf2, { 0xE5, 0x9D, 0xAF },
	0xcbf3, { 0xE5, 0x9D, 0xB2 },
	0xcbf4, { 0xE5, 0x9D, 0xAD },
	0xcbf5, { 0xE5, 0x9D, 0xAB },
	0xcbf6, { 0xE5, 0x9D, 0xB1 },
	0xcbf7, { 0xE5, 0x9D, 0xB0 },
	0xcbf8, { 0xE5, 0x9D, 0xB6 },
	0xcbf9, { 0xE5, 0x9E, 0x80 },
	0xcbfa, { 0xE5, 0x9D, 0xB5 },
	0xcbfb, { 0xE5, 0x9D, 0xBB },
	0xcbfc, { 0xE5, 0x9D, 0xB3 },
	0xcbfd, { 0xE5, 0x9D, 0xB4 },
	0xcbfe, { 0xE5, 0x9D, 0xA2 },
	0xcc40, { 0xE5, 0x9D, 0xA8 },
	0xcc41, { 0xE5, 0x9D, 0xBD },
	0xcc42, { 0xE5, 0xA4, 0x8C },
	0xcc43, { 0xE5, 0xA5, 0x85 },
	0xcc44, { 0xE5, 0xA6, 0xB5 },
	0xcc45, { 0xE5, 0xA6, 0xBA },
	0xcc46, { 0xE5, 0xA7, 0x8F },
	0xcc47, { 0xE5, 0xA7, 0x8E },
	0xcc48, { 0xE5, 0xA6, 0xB2 },
	0xcc49, { 0xE5, 0xA7, 0x8C },
	0xcc4a, { 0xE5, 0xA7, 0x81 },
	0xcc4b, { 0xE5, 0xA6, 0xB6 },
	0xcc4c, { 0xE5, 0xA6, 0xBC },
	0xcc4d, { 0xE5, 0xA7, 0x83 },
	0xcc4e, { 0xE5, 0xA7, 0x96 },
	0xcc4f, { 0xE5, 0xA6, 0xB1 },
	0xcc50, { 0xE5, 0xA6, 0xBD },
	0xcc51, { 0xE5, 0xA7, 0x80 },
	0xcc52, { 0xE5, 0xA7, 0x88 },
	0xcc53, { 0xE5, 0xA6, 0xB4 },
	0xcc54, { 0xE5, 0xA7, 0x87 },
	0xcc55, { 0xE5, 0xAD, 0xA2 },
	0xcc56, { 0xE5, 0xAD, 0xA5 },
	0xcc57, { 0xE5, 0xAE, 0x93 },
	0xcc58, { 0xE5, 0xAE, 0x95 },
	0xcc59, { 0xE5, 0xB1, 0x84 },
	0xcc5a, { 0xE5, 0xB1, 0x87 },
	0xcc5b, { 0xE5, 0xB2, 0xAE },
	0xcc5c, { 0xE5, 0xB2, 0xA4 },
	0xcc5d, { 0xE5, 0xB2, 0xA0 },
	0xcc5e, { 0xE5, 0xB2, 0xB5 },
	0xcc5f, { 0xE5, 0xB2, 0xAF },
	0xcc60, { 0xE5, 0xB2, 0xA8 },
	0xcc61, { 0xE5, 0xB2, 0xAC },
	0xcc62, { 0xE5, 0xB2, 0x9F },
	0xcc63, { 0xE5, 0xB2, 0xA3 },
	0xcc64, { 0xE5, 0xB2, 0xAD },
	0xcc65, { 0xE5, 0xB2, 0xA2 },
	0xcc66, { 0xE5, 0xB2, 0xAA },
	0xcc67, { 0xE5, 0xB2, 0xA7 },
	0xcc68, { 0xE5, 0xB2, 0x9D },
	0xcc69, { 0xE5, 0xB2, 0xA5 },
	0xcc6a, { 0xE5, 0xB2, 0xB6 },
	0xcc6b, { 0xE5, 0xB2, 0xB0 },
	0xcc6c, { 0xE5, 0xB2, 0xA6 },
	0xcc6d, { 0xE5, 0xB8, 0x97 },
	0xcc6e, { 0xE5, 0xB8, 0x94 },
	0xcc6f, { 0xE5, 0xB8, 0x99 },
	0xcc70, { 0xE5, 0xBC, 0xA8 },
	0xcc71, { 0xE5, 0xBC, 0xA2 },
	0xcc72, { 0xE5, 0xBC, 0xA3 },
	0xcc73, { 0xE5, 0xBC, 0xA4 },
	0xcc74, { 0xE5, 0xBD, 0x94 },
	0xcc75, { 0xE5, 0xBE, 0x82 },
	0xcc76, { 0xE5, 0xBD, 0xBE },
	0xcc77, { 0xE5, 0xBD, 0xBD },
	0xcc78, { 0xE5, 0xBF, 0x9E },
	0xcc79, { 0xE5, 0xBF, 0xA5 },
	0xcc7a, { 0xE6, 0x80, 0xAD },
	0xcc7b, { 0xE6, 0x80, 0xA6 },
	0xcc7c, { 0xE6, 0x80, 0x99 },
	0xcc7d, { 0xE6, 0x80, 0xB2 },
	0xcc7e, { 0xE6, 0x80, 0x8B },
	0xcca1, { 0xE6, 0x80, 0xB4 },
	0xcca2, { 0xE6, 0x80, 0x8A },
	0xcca3, { 0xE6, 0x80, 0x97 },
	0xcca4, { 0xE6, 0x80, 0xB3 },
	0xcca5, { 0xE6, 0x80, 0x9A },
	0xcca6, { 0xE6, 0x80, 0x9E },
	0xcca7, { 0xE6, 0x80, 0xAC },
	0xcca8, { 0xE6, 0x80, 0xA2 },
	0xcca9, { 0xE6, 0x80, 0x8D },
	0xccaa, { 0xE6, 0x80, 0x90 },
	0xccab, { 0xE6, 0x80, 0xAE },
	0xccac, { 0xE6, 0x80, 0x93 },
	0xccad, { 0xE6, 0x80, 0x91 },
	0xccae, { 0xE6, 0x80, 0x8C },
	0xccaf, { 0xE6, 0x80, 0x89 },
	0xccb0, { 0xE6, 0x80, 0x9C },
	0xccb1, { 0xE6, 0x88, 0x94 },
	0xccb2, { 0xE6, 0x88, 0xBD },
	0xccb3, { 0xE6, 0x8A, 0xAD },
	0xccb4, { 0xE6, 0x8A, 0xB4 },
	0xccb5, { 0xE6, 0x8B, 0x91 },
	0xccb6, { 0xE6, 0x8A, 0xBE },
	0xccb7, { 0xE6, 0x8A, 0xAA },
	0xccb8, { 0xE6, 0x8A, 0xB6 },
	0xccb9, { 0xE6, 0x8B, 0x8A },
	0xccba, { 0xE6, 0x8A, 0xAE },
	0xccbb, { 0xE6, 0x8A, 0xB3 },
	0xccbc, { 0xE6, 0x8A, 0xAF },
	0xccbd, { 0xE6, 0x8A, 0xBB },
	0xccbe, { 0xE6, 0x8A, 0xA9 },
	0xccbf, { 0xE6, 0x8A, 0xB0 },
	0xccc0, { 0xE6, 0x8A, 0xB8 },
	0xccc1, { 0xE6, 0x94, 0xBD },
	0xccc2, { 0xE6, 0x96, 0xA8 },
	0xccc3, { 0xE6, 0x96, 0xBB },
	0xccc4, { 0xE6, 0x98, 0x89 },
	0xccc5, { 0xE6, 0x97, 0xBC },
	0xccc6, { 0xE6, 0x98, 0x84 },
	0xccc7, { 0xE6, 0x98, 0x92 },
	0xccc8, { 0xE6, 0x98, 0x88 },
	0xccc9, { 0xE6, 0x97, 0xBB },
	0xccca, { 0xE6, 0x98, 0x83 },
	0xcccb, { 0xE6, 0x98, 0x8B },
	0xcccc, { 0xE6, 0x98, 0x8D },
	0xcccd, { 0xE6, 0x98, 0x85 },
	0xccce, { 0xE6, 0x97, 0xBD },
	0xcccf, { 0xE6, 0x98, 0x91 },
	0xccd0, { 0xE6, 0x98, 0x90 },
	0xccd1, { 0xE6, 0x9B, 0xB6 },
	0xccd2, { 0xE6, 0x9C, 0x8A },
	0xccd3, { 0xE6, 0x9E, 0x85 },
	0xccd4, { 0xE6, 0x9D, 0xAC },
	0xccd5, { 0xE6, 0x9E, 0x8E },
	0xccd6, { 0xE6, 0x9E, 0x92 },
	0xccd7, { 0xE6, 0x9D, 0xB6 },
	0xccd8, { 0xE6, 0x9D, 0xBB },
	0xccd9, { 0xE6, 0x9E, 0x98 },
	0xccda, { 0xE6, 0x9E, 0x86 },
	0xccdb, { 0xE6, 0x9E, 0x84 },
	0xccdc, { 0xE6, 0x9D, 0xB4 },
	0xccdd, { 0xE6, 0x9E, 0x8D },
	0xccde, { 0xE6, 0x9E, 0x8C },
	0xccdf, { 0xE6, 0x9D, 0xBA },
	0xcce0, { 0xE6, 0x9E, 0x9F },
	0xcce1, { 0xE6, 0x9E, 0x91 },
	0xcce2, { 0xE6, 0x9E, 0x99 },
	0xcce3, { 0xE6, 0x9E, 0x83 },
	0xcce4, { 0xE6, 0x9D, 0xBD },
	0xcce5, { 0xE6, 0x9E, 0x81 },
	0xcce6, { 0xE6, 0x9D, 0xB8 },
	0xcce7, { 0xE6, 0x9D, 0xB9 },
	0xcce8, { 0xE6, 0x9E, 0x94 },
	0xcce9, { 0xE6, 0xAC, 0xA5 },
	0xccea, { 0xE6, 0xAE, 0x80 },
	0xcceb, { 0xE6, 0xAD, 0xBE },
	0xccec, { 0xE6, 0xAF, 0x9E },
	0xcced, { 0xE6, 0xB0, 0x9D },
	0xccee, { 0xE6, 0xB2, 0x93 },
	0xccef, { 0xE6, 0xB3, 0xAC },
	0xccf0, { 0xE6, 0xB3, 0xAB },
	0xccf1, { 0xE6, 0xB3, 0xAE },
	0xccf2, { 0xE6, 0xB3, 0x99 },
	0xccf3, { 0xE6, 0xB2, 0xB6 },
	0xccf4, { 0xE6, 0xB3, 0x94 },
	0xccf5, { 0xE6, 0xB2, 0xAD },
	0xccf6, { 0xE6, 0xB3, 0xA7 },
	0xccf7, { 0xE6, 0xB2, 0xB7 },
	0xccf8, { 0xE6, 0xB3, 0x90 },
	0xccf9, { 0xE6, 0xB3, 0x82 },
	0xccfa, { 0xE6, 0xB2, 0xBA },
	0xccfb, { 0xE6, 0xB3, 0x83 },
	0xccfc, { 0xE6, 0xB3, 0x86 },
	0xccfd, { 0xE6, 0xB3, 0xAD },
	0xccfe, { 0xE6, 0xB3, 0xB2 },
	0xcd40, { 0xE6, 0xB3, 0x92 },
	0xcd41, { 0xE6, 0xB3, 0x9D },
	0xcd42, { 0xE6, 0xB2, 0xB4 },
	0xcd43, { 0xE6, 0xB2, 0x8A },
	0xcd44, { 0xE6, 0xB2, 0x9D },
	0xcd45, { 0xE6, 0xB2, 0x80 },
	0xcd46, { 0xE6, 0xB3, 0x9E },
	0xcd47, { 0xE6, 0xB3, 0x80 },
	0xcd48, { 0xE6, 0xB4, 0xB0 },
	0xcd49, { 0xE6, 0xB3, 0x8D },
	0xcd4a, { 0xE6, 0xB3, 0x87 },
	0xcd4b, { 0xE6, 0xB2, 0xB0 },
	0xcd4c, { 0xE6, 0xB3, 0xB9 },
	0xcd4d, { 0xE6, 0xB3, 0x8F },
	0xcd4e, { 0xE6, 0xB3, 0xA9 },
	0xcd4f, { 0xE6, 0xB3, 0x91 },
	0xcd50, { 0xE7, 0x82, 0x94 },
	0xcd51, { 0xE7, 0x82, 0x98 },
	0xcd52, { 0xE7, 0x82, 0x85 },
	0xcd53, { 0xE7, 0x82, 0x93 },
	0xcd54, { 0xE7, 0x82, 0x86 },
	0xcd55, { 0xE7, 0x82, 0x84 },
	0xcd56, { 0xE7, 0x82, 0x91 },
	0xcd57, { 0xE7, 0x82, 0x96 },
	0xcd58, { 0xE7, 0x82, 0x82 },
	0xcd59, { 0xE7, 0x82, 0x9A },
	0xcd5a, { 0xE7, 0x82, 0x83 },
	0xcd5b, { 0xE7, 0x89, 0xAA },
	0xcd5c, { 0xE7, 0x8B, 0x96 },
	0xcd5d, { 0xE7, 0x8B, 0x8B },
	0xcd5e, { 0xE7, 0x8B, 0x98 },
	0xcd5f, { 0xE7, 0x8B, 0x89 },
	0xcd60, { 0xE7, 0x8B, 0x9C },
	0xcd61, { 0xE7, 0x8B, 0x92 },
	0xcd62, { 0xE7, 0x8B, 0x94 },
	0xcd63, { 0xE7, 0x8B, 0x9A },
	0xcd64, { 0xE7, 0x8B, 0x8C },
	0xcd65, { 0xE7, 0x8B, 0x91 },
	0xcd66, { 0xE7, 0x8E, 0xA4 },
	0xcd67, { 0xE7, 0x8E, 0xA1 },
	0xcd68, { 0xE7, 0x8E, 0xAD },
	0xcd69, { 0xE7, 0x8E, 0xA6 },
	0xcd6a, { 0xE7, 0x8E, 0xA2 },
	0xcd6b, { 0xE7, 0x8E, 0xA0 },
	0xcd6c, { 0xE7, 0x8E, 0xAC },
	0xcd6d, { 0xE7, 0x8E, 0x9D },
	0xcd6e, { 0xE7, 0x93, 0x9D },
	0xcd6f, { 0xE7, 0x93, 0xA8 },
	0xcd70, { 0xE7, 0x94, 0xBF },
	0xcd71, { 0xE7, 0x95, 0x80 },
	0xcd72, { 0xE7, 0x94, 0xBE },
	0xcd73, { 0xE7, 0x96, 0x8C },
	0xcd74, { 0xE7, 0x96, 0x98 },
	0xcd75, { 0xE7, 0x9A, 0xAF },
	0xcd76, { 0xE7, 0x9B, 0xB3 },
	0xcd77, { 0xE7, 0x9B, 0xB1 },
	0xcd78, { 0xE7, 0x9B, 0xB0 },
	0xcd79, { 0xE7, 0x9B, 0xB5 },
	0xcd7a, { 0xE7, 0x9F, 0xB8 },
	0xcd7b, { 0xE7, 0x9F, 0xBC },
	0xcd7c, { 0xE7, 0x9F, 0xB9 },
	0xcd7d, { 0xE7, 0x9F, 0xBB },
	0xcd7e, { 0xE7, 0x9F, 0xBA },
	0xcda1, { 0xE7, 0x9F, 0xB7 },
	0xcda2, { 0xE7, 0xA5, 0x82 },
	0xcda3, { 0xE7, 0xA4, 0xBF },
	0xcda4, { 0xE7, 0xA7, 0x85 },
	0xcda5, { 0xE7, 0xA9, 0xB8 },
	0xcda6, { 0xE7, 0xA9, 0xBB },
	0xcda7, { 0xE7, 0xAB, 0xBB },
	0xcda8, { 0xE7, 0xB1, 0xB5 },
	0xcda9, { 0xE7, 0xB3, 0xBD },
	0xcdaa, { 0xE8, 0x80, 0xB5 },
	0xcdab, { 0xE8, 0x82, 0x8F },
	0xcdac, { 0xE8, 0x82, 0xAE },
	0xcdad, { 0xE8, 0x82, 0xA3 },
	0xcdae, { 0xE8, 0x82, 0xB8 },
	0xcdaf, { 0xE8, 0x82, 0xB5 },
	0xcdb0, { 0xE8, 0x82, 0xAD },
	0xcdb1, { 0xE8, 0x88, 0xA0 },
	0xcdb2, { 0xE8, 0x8A, 0xA0 },
	0xcdb3, { 0xE8, 0x8B, 0x80 },
	0xcdb4, { 0xE8, 0x8A, 0xAB },
	0xcdb5, { 0xE8, 0x8A, 0x9A },
	0xcdb6, { 0xE8, 0x8A, 0x98 },
	0xcdb7, { 0xE8, 0x8A, 0x9B },
	0xcdb8, { 0xE8, 0x8A, 0xB5 },
	0xcdb9, { 0xE8, 0x8A, 0xA7 },
	0xcdba, { 0xE8, 0x8A, 0xAE },
	0xcdbb, { 0xE8, 0x8A, 0xBC },
	0xcdbc, { 0xE8, 0x8A, 0x9E },
	0xcdbd, { 0xE8, 0x8A, 0xBA },
	0xcdbe, { 0xE8, 0x8A, 0xB4 },
	0xcdbf, { 0xE8, 0x8A, 0xA8 },
	0xcdc0, { 0xE8, 0x8A, 0xA1 },
	0xcdc1, { 0xE8, 0x8A, 0xA9 },
	0xcdc2, { 0xE8, 0x8B, 0x82 },
	0xcdc3, { 0xE8, 0x8A, 0xA4 },
	0xcdc4, { 0xE8, 0x8B, 0x83 },
	0xcdc5, { 0xE8, 0x8A, 0xB6 },
	0xcdc6, { 0xE8, 0x8A, 0xA2 },
	0xcdc7, { 0xE8, 0x99, 0xB0 },
	0xcdc8, { 0xE8, 0x99, 0xAF },
	0xcdc9, { 0xE8, 0x99, 0xAD },
	0xcdca, { 0xE8, 0x99, 0xAE },
	0xcdcb, { 0xE8, 0xB1, 0x96 },
	0xcdcc, { 0xE8, 0xBF, 0x92 },
	0xcdcd, { 0xE8, 0xBF, 0x8B },
	0xcdce, { 0xE8, 0xBF, 0x93 },
	0xcdcf, { 0xE8, 0xBF, 0x8D },
	0xcdd0, { 0xE8, 0xBF, 0x96 },
	0xcdd1, { 0xE8, 0xBF, 0x95 },
	0xcdd2, { 0xE8, 0xBF, 0x97 },
	0xcdd3, { 0xE9, 0x82, 0xB2 },
	0xcdd4, { 0xE9, 0x82, 0xB4 },
	0xcdd5, { 0xE9, 0x82, 0xAF },
	0xcdd6, { 0xE9, 0x82, 0xB3 },
	0xcdd7, { 0xE9, 0x82, 0xB0 },
	0xcdd8, { 0xE9, 0x98, 0xB9 },
	0xcdd9, { 0xE9, 0x98, 0xBD },
	0xcdda, { 0xE9, 0x98, 0xBC },
	0xcddb, { 0xE9, 0x98, 0xBA },
	0xcddc, { 0xE9, 0x99, 0x83 },
	0xcddd, { 0xE4, 0xBF, 0x8D },
	0xcdde, { 0xE4, 0xBF, 0x85 },
	0xcddf, { 0xE4, 0xBF, 0x93 },
	0xcde0, { 0xE4, 0xBE, 0xB2 },
	0xcde1, { 0xE4, 0xBF, 0x89 },
	0xcde2, { 0xE4, 0xBF, 0x8B },
	0xcde3, { 0xE4, 0xBF, 0x81 },
	0xcde4, { 0xE4, 0xBF, 0x94 },
	0xcde5, { 0xE4, 0xBF, 0x9C },
	0xcde6, { 0xE4, 0xBF, 0x99 },
	0xcde7, { 0xE4, 0xBE, 0xBB },
	0xcde8, { 0xE4, 0xBE, 0xB3 },
	0xcde9, { 0xE4, 0xBF, 0x9B },
	0xcdea, { 0xE4, 0xBF, 0x87 },
	0xcdeb, { 0xE4, 0xBF, 0x96 },
	0xcdec, { 0xE4, 0xBE, 0xBA },
	0xcded, { 0xE4, 0xBF, 0x80 },
	0xcdee, { 0xE4, 0xBE, 0xB9 },
	0xcdef, { 0xE4, 0xBF, 0xAC },
	0xcdf0, { 0xE5, 0x89, 0x84 },
	0xcdf1, { 0xE5, 0x89, 0x89 },
	0xcdf2, { 0xE5, 0x8B, 0x80 },
	0xcdf3, { 0xE5, 0x8B, 0x82 },
	0xcdf4, { 0xE5, 0x8C, 0xBD },
	0xcdf5, { 0xE5, 0x8D, 0xBC },
	0xcdf6, { 0xE5, 0x8E, 0x97 },
	0xcdf7, { 0xE5, 0x8E, 0x96 },
	0xcdf8, { 0xE5, 0x8E, 0x99 },
	0xcdf9, { 0xE5, 0x8E, 0x98 },
	0xcdfa, { 0xE5, 0x92, 0xBA },
	0xcdfb, { 0xE5, 0x92, 0xA1 },
	0xcdfc, { 0xE5, 0x92, 0xAD },
	0xcdfd, { 0xE5, 0x92, 0xA5 },
	0xcdfe, { 0xE5, 0x93, 0x8F },
	0xce40, { 0xE5, 0x93, 0x83 },
	0xce41, { 0xE8, 0x8C, 0x8D },
	0xce42, { 0xE5, 0x92, 0xB7 },
	0xce43, { 0xE5, 0x92, 0xAE },
	0xce44, { 0xE5, 0x93, 0x96 },
	0xce45, { 0xE5, 0x92, 0xB6 },
	0xce46, { 0xE5, 0x93, 0x85 },
	0xce47, { 0xE5, 0x93, 0x86 },
	0xce48, { 0xE5, 0x92, 0xA0 },
	0xce49, { 0xE5, 0x91, 0xB0 },
	0xce4a, { 0xE5, 0x92, 0xBC },
	0xce4b, { 0xE5, 0x92, 0xA2 },
	0xce4c, { 0xE5, 0x92, 0xBE },
	0xce4d, { 0xE5, 0x91, 0xB2 },
	0xce4e, { 0xE5, 0x93, 0x9E },
	0xce4f, { 0xE5, 0x92, 0xB0 },
	0xce50, { 0xE5, 0x9E, 0xB5 },
	0xce51, { 0xE5, 0x9E, 0x9E },
	0xce52, { 0xE5, 0x9E, 0x9F },
	0xce53, { 0xE5, 0x9E, 0xA4 },
	0xce54, { 0xE5, 0x9E, 0x8C },
	0xce55, { 0xE5, 0x9E, 0x97 },
	0xce56, { 0xE5, 0x9E, 0x9D },
	0xce57, { 0xE5, 0x9E, 0x9B },
	0xce58, { 0xE5, 0x9E, 0x94 },
	0xce59, { 0xE5, 0x9E, 0x98 },
	0xce5a, { 0xE5, 0x9E, 0x8F },
	0xce5b, { 0xE5, 0x9E, 0x99 },
	0xce5c, { 0xE5, 0x9E, 0xA5 },
	0xce5d, { 0xE5, 0x9E, 0x9A },
	0xce5e, { 0xE5, 0x9E, 0x95 },
	0xce5f, { 0xE5, 0xA3, 0xB4 },
	0xce60, { 0xE5, 0xA4, 0x8D },
	0xce61, { 0xE5, 0xA5, 0x93 },
	0xce62, { 0xE5, 0xA7, 0xA1 },
	0xce63, { 0xE5, 0xA7, 0x9E },
	0xce64, { 0xE5, 0xA7, 0xAE },
	0xce65, { 0xE5, 0xA8, 0x80 },
	0xce66, { 0xE5, 0xA7, 0xB1 },
	0xce67, { 0xE5, 0xA7, 0x9D },
	0xce68, { 0xE5, 0xA7, 0xBA },
	0xce69, { 0xE5, 0xA7, 0xBD },
	0xce6a, { 0xE5, 0xA7, 0xBC },
	0xce6b, { 0xE5, 0xA7, 0xB6 },
	0xce6c, { 0xE5, 0xA7, 0xA4 },
	0xce6d, { 0xE5, 0xA7, 0xB2 },
	0xce6e, { 0xE5, 0xA7, 0xB7 },
	0xce6f, { 0xE5, 0xA7, 0x9B },
	0xce70, { 0xE5, 0xA7, 0xA9 },
	0xce71, { 0xE5, 0xA7, 0xB3 },
	0xce72, { 0xE5, 0xA7, 0xB5 },
	0xce73, { 0xE5, 0xA7, 0xA0 },
	0xce74, { 0xE5, 0xA7, 0xBE },
	0xce75, { 0xE5, 0xA7, 0xB4 },
	0xce76, { 0xE5, 0xA7, 0xAD },
	0xce77, { 0xE5, 0xAE, 0xA8 },
	0xce78, { 0xE5, 0xB1, 0x8C },
	0xce79, { 0xE5, 0xB3, 0x90 },
	0xce7a, { 0xE5, 0xB3, 0x98 },
	0xce7b, { 0xE5, 0xB3, 0x8C },
	0xce7c, { 0xE5, 0xB3, 0x97 },
	0xce7d, { 0xE5, 0xB3, 0x8B },
	0xce7e, { 0xE5, 0xB3, 0x9B },
	0xcea1, { 0xE5, 0xB3, 0x9E },
	0xcea2, { 0xE5, 0xB3, 0x9A },
	0xcea3, { 0xE5, 0xB3, 0x89 },
	0xcea4, { 0xE5, 0xB3, 0x87 },
	0xcea5, { 0xE5, 0xB3, 0x8A },
	0xcea6, { 0xE5, 0xB3, 0x96 },
	0xcea7, { 0xE5, 0xB3, 0x93 },
	0xcea8, { 0xE5, 0xB3, 0x94 },
	0xcea9, { 0xE5, 0xB3, 0x8F },
	0xceaa, { 0xE5, 0xB3, 0x88 },
	0xceab, { 0xE5, 0xB3, 0x86 },
	0xceac, { 0xE5, 0xB3, 0x8E },
	0xcead, { 0xE5, 0xB3, 0x9F },
	0xceae, { 0xE5, 0xB3, 0xB8 },
	0xceaf, { 0xE5, 0xB7, 0xB9 },
	0xceb0, { 0xE5, 0xB8, 0xA1 },
	0xceb1, { 0xE5, 0xB8, 0xA2 },
	0xceb2, { 0xE5, 0xB8, 0xA3 },
	0xceb3, { 0xE5, 0xB8, 0xA0 },
	0xceb4, { 0xE5, 0xB8, 0xA4 },
	0xceb5, { 0xE5, 0xBA, 0xB0 },
	0xceb6, { 0xE5, 0xBA, 0xA4 },
	0xceb7, { 0xE5, 0xBA, 0xA2 },
	0xceb8, { 0xE5, 0xBA, 0x9B },
	0xceb9, { 0xE5, 0xBA, 0xA3 },
	0xceba, { 0xE5, 0xBA, 0xA5 },
	0xcebb, { 0xE5, 0xBC, 0x87 },
	0xcebc, { 0xE5, 0xBC, 0xAE },
	0xcebd, { 0xE5, 0xBD, 0x96 },
	0xcebe, { 0xE5, 0xBE, 0x86 },
	0xcebf, { 0xE6, 0x80, 0xB7 },
	0xcec0, { 0xE6, 0x80, 0xB9 },
	0xcec1, { 0xE6, 0x81, 0x94 },
	0xcec2, { 0xE6, 0x81, 0xB2 },
	0xcec3, { 0xE6, 0x81, 0x9E },
	0xcec4, { 0xE6, 0x81, 0x85 },
	0xcec5, { 0xE6, 0x81, 0x93 },
	0xcec6, { 0xE6, 0x81, 0x87 },
	0xcec7, { 0xE6, 0x81, 0x89 },
	0xcec8, { 0xE6, 0x81, 0x9B },
	0xcec9, { 0xE6, 0x81, 0x8C },
	0xceca, { 0xE6, 0x81, 0x80 },
	0xcecb, { 0xE6, 0x81, 0x82 },
	0xcecc, { 0xE6, 0x81, 0x9F },
	0xcecd, { 0xE6, 0x80, 0xA4 },
	0xcece, { 0xE6, 0x81, 0x84 },
	0xcecf, { 0xE6, 0x81, 0x98 },
	0xced0, { 0xE6, 0x81, 0xA6 },
	0xced1, { 0xE6, 0x81, 0xAE },
	0xced2, { 0xE6, 0x89, 0x82 },
	0xced3, { 0xE6, 0x89, 0x83 },
	0xced4, { 0xE6, 0x8B, 0x8F },
	0xced5, { 0xE6, 0x8C, 0x8D },
	0xced6, { 0xE6, 0x8C, 0x8B },
	0xced7, { 0xE6, 0x8B, 0xB5 },
	0xced8, { 0xE6, 0x8C, 0x8E },
	0xced9, { 0xE6, 0x8C, 0x83 },
	0xceda, { 0xE6, 0x8B, 0xAB },
	0xcedb, { 0xE6, 0x8B, 0xB9 },
	0xcedc, { 0xE6, 0x8C, 0x8F },
	0xcedd, { 0xE6, 0x8C, 0x8C },
	0xcede, { 0xE6, 0x8B, 0xB8 },
	0xcedf, { 0xE6, 0x8B, 0xB6 },
	0xcee0, { 0xE6, 0x8C, 0x80 },
	0xcee1, { 0xE6, 0x8C, 0x93 },
	0xcee2, { 0xE6, 0x8C, 0x94 },
	0xcee3, { 0xE6, 0x8B, 0xBA },
	0xcee4, { 0xE6, 0x8C, 0x95 },
	0xcee5, { 0xE6, 0x8B, 0xBB },
	0xcee6, { 0xE6, 0x8B, 0xB0 },
	0xcee7, { 0xE6, 0x95, 0x81 },
	0xcee8, { 0xE6, 0x95, 0x83 },
	0xcee9, { 0xE6, 0x96, 0xAA },
	0xceea, { 0xE6, 0x96, 0xBF },
	0xceeb, { 0xE6, 0x98, 0xB6 },
	0xceec, { 0xE6, 0x98, 0xA1 },
	0xceed, { 0xE6, 0x98, 0xB2 },
	0xceee, { 0xE6, 0x98, 0xB5 },
	0xceef, { 0xE6, 0x98, 0x9C },
	0xcef0, { 0xE6, 0x98, 0xA6 },
	0xcef1, { 0xE6, 0x98, 0xA2 },
	0xcef2, { 0xE6, 0x98, 0xB3 },
	0xcef3, { 0xE6, 0x98, 0xAB },
	0xcef4, { 0xE6, 0x98, 0xBA },
	0xcef5, { 0xE6, 0x98, 0x9D },
	0xcef6, { 0xE6, 0x98, 0xB4 },
	0xcef7, { 0xE6, 0x98, 0xB9 },
	0xcef8, { 0xE6, 0x98, 0xAE },
	0xcef9, { 0xE6, 0x9C, 0x8F },
	0xcefa, { 0xE6, 0x9C, 0x90 },
	0xcefb, { 0xE6, 0x9F, 0x81 },
	0xcefc, { 0xE6, 0x9F, 0xB2 },
	0xcefd, { 0xE6, 0x9F, 0x88 },
	0xcefe, { 0xE6, 0x9E, 0xBA },
	0xcf40, { 0xE6, 0x9F, 0x9C },
	0xcf41, { 0xE6, 0x9E, 0xBB },
	0xcf42, { 0xE6, 0x9F, 0xB8 },
	0xcf43, { 0xE6, 0x9F, 0x98 },
	0xcf44, { 0xE6, 0x9F, 0x80 },
	0xcf45, { 0xE6, 0x9E, 0xB7 },
	0xcf46, { 0xE6, 0x9F, 0x85 },
	0xcf47, { 0xE6, 0x9F, 0xAB },
	0xcf48, { 0xE6, 0x9F, 0xA4 },
	0xcf49, { 0xE6, 0x9F, 0x9F },
	0xcf4a, { 0xE6, 0x9E, 0xB5 },
	0xcf4b, { 0xE6, 0x9F, 0x8D },
	0xcf4c, { 0xE6, 0x9E, 0xB3 },
	0xcf4d, { 0xE6, 0x9F, 0xB7 },
	0xcf4e, { 0xE6, 0x9F, 0xB6 },
	0xcf4f, { 0xE6, 0x9F, 0xAE },
	0xcf50, { 0xE6, 0x9F, 0xA3 },
	0xcf51, { 0xE6, 0x9F, 0x82 },
	0xcf52, { 0xE6, 0x9E, 0xB9 },
	0xcf53, { 0xE6, 0x9F, 0x8E },
	0xcf54, { 0xE6, 0x9F, 0xA7 },
	0xcf55, { 0xE6, 0x9F, 0xB0 },
	0xcf56, { 0xE6, 0x9E, 0xB2 },
	0xcf57, { 0xE6, 0x9F, 0xBC },
	0xcf58, { 0xE6, 0x9F, 0x86 },
	0xcf59, { 0xE6, 0x9F, 0xAD },
	0xcf5a, { 0xE6, 0x9F, 0x8C },
	0xcf5b, { 0xE6, 0x9E, 0xAE },
	0xcf5c, { 0xE6, 0x9F, 0xA6 },
	0xcf5d, { 0xE6, 0x9F, 0x9B },
	0xcf5e, { 0xE6, 0x9F, 0xBA },
	0xcf5f, { 0xE6, 0x9F, 0x89 },
	0xcf60, { 0xE6, 0x9F, 0x8A },
	0xcf61, { 0xE6, 0x9F, 0x83 },
	0xcf62, { 0xE6, 0x9F, 0xAA },
	0xcf63, { 0xE6, 0x9F, 0x8B },
	0xcf64, { 0xE6, 0xAC, 0xA8 },
	0xcf65, { 0xE6, 0xAE, 0x82 },
	0xcf66, { 0xE6, 0xAE, 0x84 },
	0xcf67, { 0xE6, 0xAE, 0xB6 },
	0xcf68, { 0xE6, 0xAF, 0x96 },
	0xcf69, { 0xE6, 0xAF, 0x98 },
	0xcf6a, { 0xE6, 0xAF, 0xA0 },
	0xcf6b, { 0xE6, 0xB0, 0xA0 },
	0xcf6c, { 0xE6, 0xB0, 0xA1 },
	0xcf6d, { 0xE6, 0xB4, 0xA8 },
	0xcf6e, { 0xE6, 0xB4, 0xB4 },
	0xcf6f, { 0xE6, 0xB4, 0xAD },
	0xcf70, { 0xE6, 0xB4, 0x9F },
	0xcf71, { 0xE6, 0xB4, 0xBC },
	0xcf72, { 0xE6, 0xB4, 0xBF },
	0xcf73, { 0xE6, 0xB4, 0x92 },
	0xcf74, { 0xE6, 0xB4, 0x8A },
	0xcf75, { 0xE6, 0xB3, 0x9A },
	0xcf76, { 0xE6, 0xB4, 0xB3 },
	0xcf77, { 0xE6, 0xB4, 0x84 },
	0xcf78, { 0xE6, 0xB4, 0x99 },
	0xcf79, { 0xE6, 0xB4, 0xBA },
	0xcf7a, { 0xE6, 0xB4, 0x9A },
	0xcf7b, { 0xE6, 0xB4, 0x91 },
	0xcf7c, { 0xE6, 0xB4, 0x80 },
	0xcf7d, { 0xE6, 0xB4, 0x9D },
	0xcf7e, { 0xE6, 0xB5, 0x82 },
	0xcfa1, { 0xE6, 0xB4, 0x81 },
	0xcfa2, { 0xE6, 0xB4, 0x98 },
	0xcfa3, { 0xE6, 0xB4, 0xB7 },
	0xcfa4, { 0xE6, 0xB4, 0x83 },
	0xcfa5, { 0xE6, 0xB4, 0x8F },
	0xcfa6, { 0xE6, 0xB5, 0x80 },
	0xcfa7, { 0xE6, 0xB4, 0x87 },
	0xcfa8, { 0xE6, 0xB4, 0xA0 },
	0xcfa9, { 0xE6, 0xB4, 0xAC },
	0xcfaa, { 0xE6, 0xB4, 0x88 },
	0xcfab, { 0xE6, 0xB4, 0xA2 },
	0xcfac, { 0xE6, 0xB4, 0x89 },
	0xcfad, { 0xE6, 0xB4, 0x90 },
	0xcfae, { 0xE7, 0x82, 0xB7 },
	0xcfaf, { 0xE7, 0x82, 0x9F },
	0xcfb0, { 0xE7, 0x82, 0xBE },
	0xcfb1, { 0xE7, 0x82, 0xB1 },
	0xcfb2, { 0xE7, 0x82, 0xB0 },
	0xcfb3, { 0xE7, 0x82, 0xA1 },
	0xcfb4, { 0xE7, 0x82, 0xB4 },
	0xcfb5, { 0xE7, 0x82, 0xB5 },
	0xcfb6, { 0xE7, 0x82, 0xA9 },
	0xcfb7, { 0xE7, 0x89, 0x81 },
	0xcfb8, { 0xE7, 0x89, 0x89 },
	0xcfb9, { 0xE7, 0x89, 0x8A },
	0xcfba, { 0xE7, 0x89, 0xAC },
	0xcfbb, { 0xE7, 0x89, 0xB0 },
	0xcfbc, { 0xE7, 0x89, 0xB3 },
	0xcfbd, { 0xE7, 0x89, 0xAE },
	0xcfbe, { 0xE7, 0x8B, 0x8A },
	0xcfbf, { 0xE7, 0x8B, 0xA4 },
	0xcfc0, { 0xE7, 0x8B, 0xA8 },
	0xcfc1, { 0xE7, 0x8B, 0xAB },
	0xcfc2, { 0xE7, 0x8B, 0x9F },
	0xcfc3, { 0xE7, 0x8B, 0xAA },
	0xcfc4, { 0xE7, 0x8B, 0xA6 },
	0xcfc5, { 0xE7, 0x8B, 0xA3 },
	0xcfc6, { 0xE7, 0x8E, 0x85 },
	0xcfc7, { 0xE7, 0x8F, 0x8C },
	0xcfc8, { 0xE7, 0x8F, 0x82 },
	0xcfc9, { 0xE7, 0x8F, 0x88 },
	0xcfca, { 0xE7, 0x8F, 0x85 },
	0xcfcb, { 0xE7, 0x8E, 0xB9 },
	0xcfcc, { 0xE7, 0x8E, 0xB6 },
	0xcfcd, { 0xE7, 0x8E, 0xB5 },
	0xcfce, { 0xE7, 0x8E, 0xB4 },
	0xcfcf, { 0xE7, 0x8F, 0xAB },
	0xcfd0, { 0xE7, 0x8E, 0xBF },
	0xcfd1, { 0xE7, 0x8F, 0x87 },
	0xcfd2, { 0xE7, 0x8E, 0xBE },
	0xcfd3, { 0xE7, 0x8F, 0x83 },
	0xcfd4, { 0xE7, 0x8F, 0x86 },
	0xcfd5, { 0xE7, 0x8E, 0xB8 },
	0xcfd6, { 0xE7, 0x8F, 0x8B },
	0xcfd7, { 0xE7, 0x93, 0xAC },
	0xcfd8, { 0xE7, 0x93, 0xAE },
	0xcfd9, { 0xE7, 0x94, 0xAE },
	0xcfda, { 0xE7, 0x95, 0x87 },
	0xcfdb, { 0xE7, 0x95, 0x88 },
	0xcfdc, { 0xE7, 0x96, 0xA7 },
	0xcfdd, { 0xE7, 0x96, 0xAA },
	0xcfde, { 0xE7, 0x99, 0xB9 },
	0xcfdf, { 0xE7, 0x9B, 0x84 },
	0xcfe0, { 0xE7, 0x9C, 0x88 },
	0xcfe1, { 0xE7, 0x9C, 0x83 },
	0xcfe2, { 0xE7, 0x9C, 0x84 },
	0xcfe3, { 0xE7, 0x9C, 0x85 },
	0xcfe4, { 0xE7, 0x9C, 0x8A },
	0xcfe5, { 0xE7, 0x9B, 0xB7 },
	0xcfe6, { 0xE7, 0x9B, 0xBB },
	0xcfe7, { 0xE7, 0x9B, 0xBA },
	0xcfe8, { 0xE7, 0x9F, 0xA7 },
	0xcfe9, { 0xE7, 0x9F, 0xA8 },
	0xcfea, { 0xE7, 0xA0, 0x86 },
	0xcfeb, { 0xE7, 0xA0, 0x91 },
	0xcfec, { 0xE7, 0xA0, 0x92 },
	0xcfed, { 0xE7, 0xA0, 0x85 },
	0xcfee, { 0xE7, 0xA0, 0x90 },
	0xcfef, { 0xE7, 0xA0, 0x8F },
	0xcff0, { 0xE7, 0xA0, 0x8E },
	0xcff1, { 0xE7, 0xA0, 0x89 },
	0xcff2, { 0xE7, 0xA0, 0x83 },
	0xcff3, { 0xE7, 0xA0, 0x93 },
	0xcff4, { 0xE7, 0xA5, 0x8A },
	0xcff5, { 0xE7, 0xA5, 0x8C },
	0xcff6, { 0xE7, 0xA5, 0x8B },
	0xcff7, { 0xE7, 0xA5, 0x85 },
	0xcff8, { 0xE7, 0xA5, 0x84 },
	0xcff9, { 0xE7, 0xA7, 0x95 },
	0xcffa, { 0xE7, 0xA7, 0x8D },
	0xcffb, { 0xE7, 0xA7, 0x8F },
	0xcffc, { 0xE7, 0xA7, 0x96 },
	0xcffd, { 0xE7, 0xA7, 0x8E },
	0xcffe, { 0xE7, 0xAA, 0x80 },
	0xd040, { 0xE7, 0xA9, 0xBE },
	0xd041, { 0xE7, 0xAB, 0x91 },
	0xd042, { 0xE7, 0xAC, 0x80 },
	0xd043, { 0xE7, 0xAC, 0x81 },
	0xd044, { 0xE7, 0xB1, 0xBA },
	0xd045, { 0xE7, 0xB1, 0xB8 },
	0xd046, { 0xE7, 0xB1, 0xB9 },
	0xd047, { 0xE7, 0xB1, 0xBF },
	0xd048, { 0xE7, 0xB2, 0x80 },
	0xd049, { 0xE7, 0xB2, 0x81 },
	0xd04a, { 0xE7, 0xB4, 0x83 },
	0xd04b, { 0xE7, 0xB4, 0x88 },
	0xd04c, { 0xE7, 0xB4, 0x81 },
	0xd04d, { 0xE7, 0xBD, 0x98 },
	0xd04e, { 0xE7, 0xBE, 0x91 },
	0xd04f, { 0xE7, 0xBE, 0x8D },
	0xd050, { 0xE7, 0xBE, 0xBE },
	0xd051, { 0xE8, 0x80, 0x87 },
	0xd052, { 0xE8, 0x80, 0x8E },
	0xd053, { 0xE8, 0x80, 0x8F },
	0xd054, { 0xE8, 0x80, 0x94 },
	0xd055, { 0xE8, 0x80, 0xB7 },
	0xd056, { 0xE8, 0x83, 0x98 },
	0xd057, { 0xE8, 0x83, 0x87 },
	0xd058, { 0xE8, 0x83, 0xA0 },
	0xd059, { 0xE8, 0x83, 0x91 },
	0xd05a, { 0xE8, 0x83, 0x88 },
	0xd05b, { 0xE8, 0x83, 0x82 },
	0xd05c, { 0xE8, 0x83, 0x90 },
	0xd05d, { 0xE8, 0x83, 0x85 },
	0xd05e, { 0xE8, 0x83, 0xA3 },
	0xd05f, { 0xE8, 0x83, 0x99 },
	0xd060, { 0xE8, 0x83, 0x9C },
	0xd061, { 0xE8, 0x83, 0x8A },
	0xd062, { 0xE8, 0x83, 0x95 },
	0xd063, { 0xE8, 0x83, 0x89 },
	0xd064, { 0xE8, 0x83, 0x8F },
	0xd065, { 0xE8, 0x83, 0x97 },
	0xd066, { 0xE8, 0x83, 0xA6 },
	0xd067, { 0xE8, 0x83, 0x8D },
	0xd068, { 0xE8, 0x87, 0xBF },
	0xd069, { 0xE8, 0x88, 0xA1 },
	0xd06a, { 0xE8, 0x8A, 0x94 },
	0xd06b, { 0xE8, 0x8B, 0x99 },
	0xd06c, { 0xE8, 0x8B, 0xBE },
	0xd06d, { 0xE8, 0x8B, 0xB9 },
	0xd06e, { 0xE8, 0x8C, 0x87 },
	0xd06f, { 0xE8, 0x8B, 0xA8 },
	0xd070, { 0xE8, 0x8C, 0x80 },
	0xd071, { 0xE8, 0x8B, 0x95 },
	0xd072, { 0xE8, 0x8C, 0xBA },
	0xd073, { 0xE8, 0x8B, 0xAB },
	0xd074, { 0xE8, 0x8B, 0x96 },
	0xd075, { 0xE8, 0x8B, 0xB4 },
	0xd076, { 0xE8, 0x8B, 0xAC },
	0xd077, { 0xE8, 0x8B, 0xA1 },
	0xd078, { 0xE8, 0x8B, 0xB2 },
	0xd079, { 0xE8, 0x8B, 0xB5 },
	0xd07a, { 0xE8, 0x8C, 0x8C },
	0xd07b, { 0xE8, 0x8B, 0xBB },
	0xd07c, { 0xE8, 0x8B, 0xB6 },
	0xd07d, { 0xE8, 0x8B, 0xB0 },
	0xd07e, { 0xE8, 0x8B, 0xAA },
	0xd0a1, { 0xE8, 0x8B, 0xA4 },
	0xd0a2, { 0xE8, 0x8B, 0xA0 },
	0xd0a3, { 0xE8, 0x8B, 0xBA },
	0xd0a4, { 0xE8, 0x8B, 0xB3 },
	0xd0a5, { 0xE8, 0x8B, 0xAD },
	0xd0a6, { 0xE8, 0x99, 0xB7 },
	0xd0a7, { 0xE8, 0x99, 0xB4 },
	0xd0a8, { 0xE8, 0x99, 0xBC },
	0xd0a9, { 0xE8, 0x99, 0xB3 },
	0xd0aa, { 0xE8, 0xA1, 0x81 },
	0xd0ab, { 0xE8, 0xA1, 0x8E },
	0xd0ac, { 0xE8, 0xA1, 0xA7 },
	0xd0ad, { 0xE8, 0xA1, 0xAA },
	0xd0ae, { 0xE8, 0xA1, 0xA9 },
	0xd0af, { 0xE8, 0xA7, 0x93 },
	0xd0b0, { 0xE8, 0xA8, 0x84 },
	0xd0b1, { 0xE8, 0xA8, 0x87 },
	0xd0b2, { 0xE8, 0xB5, 0xB2 },
	0xd0b3, { 0xE8, 0xBF, 0xA3 },
	0xd0b4, { 0xE8, 0xBF, 0xA1 },
	0xd0b5, { 0xE8, 0xBF, 0xAE },
	0xd0b6, { 0xE8, 0xBF, 0xA0 },
	0xd0b7, { 0xE9, 0x83, 0xB1 },
	0xd0b8, { 0xE9, 0x82, 0xBD },
	0xd0b9, { 0xE9, 0x82, 0xBF },
	0xd0ba, { 0xE9, 0x83, 0x95 },
	0xd0bb, { 0xE9, 0x83, 0x85 },
	0xd0bc, { 0xE9, 0x82, 0xBE },
	0xd0bd, { 0xE9, 0x83, 0x87 },
	0xd0be, { 0xE9, 0x83, 0x8B },
	0xd0bf, { 0xE9, 0x83, 0x88 },
	0xd0c0, { 0xE9, 0x87, 0x94 },
	0xd0c1, { 0xE9, 0x87, 0x93 },
	0xd0c2, { 0xE9, 0x99, 0x94 },
	0xd0c3, { 0xE9, 0x99, 0x8F },
	0xd0c4, { 0xE9, 0x99, 0x91 },
	0xd0c5, { 0xE9, 0x99, 0x93 },
	0xd0c6, { 0xE9, 0x99, 0x8A },
	0xd0c7, { 0xE9, 0x99, 0x8E },
	0xd0c8, { 0xE5, 0x80, 0x9E },
	0xd0c9, { 0xE5, 0x80, 0x85 },
	0xd0ca, { 0xE5, 0x80, 0x87 },
	0xd0cb, { 0xE5, 0x80, 0x93 },
	0xd0cc, { 0xE5, 0x80, 0xA2 },
	0xd0cd, { 0xE5, 0x80, 0xB0 },
	0xd0ce, { 0xE5, 0x80, 0x9B },
	0xd0cf, { 0xE4, 0xBF, 0xB5 },
	0xd0d0, { 0xE4, 0xBF, 0xB4 },
	0xd0d1, { 0xE5, 0x80, 0xB3 },
	0xd0d2, { 0xE5, 0x80, 0xB7 },
	0xd0d3, { 0xE5, 0x80, 0xAC },
	0xd0d4, { 0xE4, 0xBF, 0xB6 },
	0xd0d5, { 0xE4, 0xBF, 0xB7 },
	0xd0d6, { 0xE5, 0x80, 0x97 },
	0xd0d7, { 0xE5, 0x80, 0x9C },
	0xd0d8, { 0xE5, 0x80, 0xA0 },
	0xd0d9, { 0xE5, 0x80, 0xA7 },
	0xd0da, { 0xE5, 0x80, 0xB5 },
	0xd0db, { 0xE5, 0x80, 0xAF },
	0xd0dc, { 0xE5, 0x80, 0xB1 },
	0xd0dd, { 0xE5, 0x80, 0x8E },
	0xd0de, { 0xE5, 0x85, 0x9A },
	0xd0df, { 0xE5, 0x86, 0x94 },
	0xd0e0, { 0xE5, 0x86, 0x93 },
	0xd0e1, { 0xE5, 0x87, 0x8A },
	0xd0e2, { 0xE5, 0x87, 0x84 },
	0xd0e3, { 0xE5, 0x87, 0x85 },
	0xd0e4, { 0xE5, 0x87, 0x88 },
	0xd0e5, { 0xE5, 0x87, 0x8E },
	0xd0e6, { 0xE5, 0x89, 0xA1 },
	0xd0e7, { 0xE5, 0x89, 0x9A },
	0xd0e8, { 0xE5, 0x89, 0x92 },
	0xd0e9, { 0xE5, 0x89, 0x9E },
	0xd0ea, { 0xE5, 0x89, 0x9F },
	0xd0eb, { 0xE5, 0x89, 0x95 },
	0xd0ec, { 0xE5, 0x89, 0xA2 },
	0xd0ed, { 0xE5, 0x8B, 0x8D },
	0xd0ee, { 0xE5, 0x8C, 0x8E },
	0xd0ef, { 0xE5, 0x8E, 0x9E },
	0xd0f0, { 0xE5, 0x94, 0xA6 },
	0xd0f1, { 0xE5, 0x93, 0xA2 },
	0xd0f2, { 0xE5, 0x94, 0x97 },
	0xd0f3, { 0xE5, 0x94, 0x92 },
	0xd0f4, { 0xE5, 0x93, 0xA7 },
	0xd0f5, { 0xE5, 0x93, 0xB3 },
	0xd0f6, { 0xE5, 0x93, 0xA4 },
	0xd0f7, { 0xE5, 0x94, 0x9A },
	0xd0f8, { 0xE5, 0x93, 0xBF },
	0xd0f9, { 0xE5, 0x94, 0x84 },
	0xd0fa, { 0xE5, 0x94, 0x88 },
	0xd0fb, { 0xE5, 0x93, 0xAB },
	0xd0fc, { 0xE5, 0x94, 0x91 },
	0xd0fd, { 0xE5, 0x94, 0x85 },
	0xd0fe, { 0xE5, 0x93, 0xB1 },
	0xd140, { 0xE5, 0x94, 0x8A },
	0xd141, { 0xE5, 0x93, 0xBB },
	0xd142, { 0xE5, 0x93, 0xB7 },
	0xd143, { 0xE5, 0x93, 0xB8 },
	0xd144, { 0xE5, 0x93, 0xA0 },
	0xd145, { 0xE5, 0x94, 0x8E },
	0xd146, { 0xE5, 0x94, 0x83 },
	0xd147, { 0xE5, 0x94, 0x8B },
	0xd148, { 0xE5, 0x9C, 0x81 },
	0xd149, { 0xE5, 0x9C, 0x82 },
	0xd14a, { 0xE5, 0x9F, 0x8C },
	0xd14b, { 0xE5, 0xA0, 0xB2 },
	0xd14c, { 0xE5, 0x9F, 0x95 },
	0xd14d, { 0xE5, 0x9F, 0x92 },
	0xd14e, { 0xE5, 0x9E, 0xBA },
	0xd14f, { 0xE5, 0x9F, 0x86 },
	0xd150, { 0xE5, 0x9E, 0xBD },
	0xd151, { 0xE5, 0x9E, 0xBC },
	0xd152, { 0xE5, 0x9E, 0xB8 },
	0xd153, { 0xE5, 0x9E, 0xB6 },
	0xd154, { 0xE5, 0x9E, 0xBF },
	0xd155, { 0xE5, 0x9F, 0x87 },
	0xd156, { 0xE5, 0x9F, 0x90 },
	0xd157, { 0xE5, 0x9E, 0xB9 },
	0xd158, { 0xE5, 0x9F, 0x81 },
	0xd159, { 0xE5, 0xA4, 0x8E },
	0xd15a, { 0xE5, 0xA5, 0x8A },
	0xd15b, { 0xE5, 0xA8, 0x99 },
	0xd15c, { 0xE5, 0xA8, 0x96 },
	0xd15d, { 0xE5, 0xA8, 0xAD },
	0xd15e, { 0xE5, 0xA8, 0xAE },
	0xd15f, { 0xE5, 0xA8, 0x95 },
	0xd160, { 0xE5, 0xA8, 0x8F },
	0xd161, { 0xE5, 0xA8, 0x97 },
	0xd162, { 0xE5, 0xA8, 0x8A },
	0xd163, { 0xE5, 0xA8, 0x9E },
	0xd164, { 0xE5, 0xA8, 0xB3 },
	0xd165, { 0xE5, 0xAD, 0xAC },
	0xd166, { 0xE5, 0xAE, 0xA7 },
	0xd167, { 0xE5, 0xAE, 0xAD },
	0xd168, { 0xE5, 0xAE, 0xAC },
	0xd169, { 0xE5, 0xB0, 0x83 },
	0xd16a, { 0xE5, 0xB1, 0x96 },
	0xd16b, { 0xE5, 0xB1, 0x94 },
	0xd16c, { 0xE5, 0xB3, 0xAC },
	0xd16d, { 0xE5, 0xB3, 0xBF },
	0xd16e, { 0xE5, 0xB3, 0xAE },
	0xd16f, { 0xE5, 0xB3, 0xB1 },
	0xd170, { 0xE5, 0xB3, 0xB7 },
	0xd171, { 0xE5, 0xB4, 0x80 },
	0xd172, { 0xE5, 0xB3, 0xB9 },
	0xd173, { 0xE5, 0xB8, 0xA9 },
	0xd174, { 0xE5, 0xB8, 0xA8 },
	0xd175, { 0xE5, 0xBA, 0xA8 },
	0xd176, { 0xE5, 0xBA, 0xAE },
	0xd177, { 0xE5, 0xBA, 0xAA },
	0xd178, { 0xE5, 0xBA, 0xAC },
	0xd179, { 0xE5, 0xBC, 0xB3 },
	0xd17a, { 0xE5, 0xBC, 0xB0 },
	0xd17b, { 0xE5, 0xBD, 0xA7 },
	0xd17c, { 0xE6, 0x81, 0x9D },
	0xd17d, { 0xE6, 0x81, 0x9A },
	0xd17e, { 0xE6, 0x81, 0xA7 },
	0xd1a1, { 0xE6, 0x81, 0x81 },
	0xd1a2, { 0xE6, 0x82, 0xA2 },
	0xd1a3, { 0xE6, 0x82, 0x88 },
	0xd1a4, { 0xE6, 0x82, 0x80 },
	0xd1a5, { 0xE6, 0x82, 0x92 },
	0xd1a6, { 0xE6, 0x82, 0x81 },
	0xd1a7, { 0xE6, 0x82, 0x9D },
	0xd1a8, { 0xE6, 0x82, 0x83 },
	0xd1a9, { 0xE6, 0x82, 0x95 },
	0xd1aa, { 0xE6, 0x82, 0x9B },
	0xd1ab, { 0xE6, 0x82, 0x97 },
	0xd1ac, { 0xE6, 0x82, 0x87 },
	0xd1ad, { 0xE6, 0x82, 0x9C },
	0xd1ae, { 0xE6, 0x82, 0x8E },
	0xd1af, { 0xE6, 0x88, 0x99 },
	0xd1b0, { 0xE6, 0x89, 0x86 },
	0xd1b1, { 0xE6, 0x8B, 0xB2 },
	0xd1b2, { 0xE6, 0x8C, 0x90 },
	0xd1b3, { 0xE6, 0x8D, 0x96 },
	0xd1b4, { 0xE6, 0x8C, 0xAC },
	0xd1b5, { 0xE6, 0x8D, 0x84 },
	0xd1b6, { 0xE6, 0x8D, 0x85 },
	0xd1b7, { 0xE6, 0x8C, 0xB6 },
	0xd1b8, { 0xE6, 0x8D, 0x83 },
	0xd1b9, { 0xE6, 0x8F, 0xA4 },
	0xd1ba, { 0xE6, 0x8C, 0xB9 },
	0xd1bb, { 0xE6, 0x8D, 0x8B },
	0xd1bc, { 0xE6, 0x8D, 0x8A },
	0xd1bd, { 0xE6, 0x8C, 0xBC },
	0xd1be, { 0xE6, 0x8C, 0xA9 },
	0xd1bf, { 0xE6, 0x8D, 0x81 },
	0xd1c0, { 0xE6, 0x8C, 0xB4 },
	0xd1c1, { 0xE6, 0x8D, 0x98 },
	0xd1c2, { 0xE6, 0x8D, 0x94 },
	0xd1c3, { 0xE6, 0x8D, 0x99 },
	0xd1c4, { 0xE6, 0x8C, 0xAD },
	0xd1c5, { 0xE6, 0x8D, 0x87 },
	0xd1c6, { 0xE6, 0x8C, 0xB3 },
	0xd1c7, { 0xE6, 0x8D, 0x9A },
	0xd1c8, { 0xE6, 0x8D, 0x91 },
	0xd1c9, { 0xE6, 0x8C, 0xB8 },
	0xd1ca, { 0xE6, 0x8D, 0x97 },
	0xd1cb, { 0xE6, 0x8D, 0x80 },
	0xd1cc, { 0xE6, 0x8D, 0x88 },
	0xd1cd, { 0xE6, 0x95, 0x8A },
	0xd1ce, { 0xE6, 0x95, 0x86 },
	0xd1cf, { 0xE6, 0x97, 0x86 },
	0xd1d0, { 0xE6, 0x97, 0x83 },
	0xd1d1, { 0xE6, 0x97, 0x84 },
	0xd1d2, { 0xE6, 0x97, 0x82 },
	0xd1d3, { 0xE6, 0x99, 0x8A },
	0xd1d4, { 0xE6, 0x99, 0x9F },
	0xd1d5, { 0xE6, 0x99, 0x87 },
	0xd1d6, { 0xE6, 0x99, 0x91 },
	0xd1d7, { 0xE6, 0x9C, 0x92 },
	0xd1d8, { 0xE6, 0x9C, 0x93 },
	0xd1d9, { 0xE6, 0xA0, 0x9F },
	0xd1da, { 0xE6, 0xA0, 0x9A },
	0xd1db, { 0xE6, 0xA1, 0x89 },
	0xd1dc, { 0xE6, 0xA0, 0xB2 },
	0xd1dd, { 0xE6, 0xA0, 0xB3 },
	0xd1de, { 0xE6, 0xA0, 0xBB },
	0xd1df, { 0xE6, 0xA1, 0x8B },
	0xd1e0, { 0xE6, 0xA1, 0x8F },
	0xd1e1, { 0xE6, 0xA0, 0x96 },
	0xd1e2, { 0xE6, 0xA0, 0xB1 },
	0xd1e3, { 0xE6, 0xA0, 0x9C },
	0xd1e4, { 0xE6, 0xA0, 0xB5 },
	0xd1e5, { 0xE6, 0xA0, 0xAB },
	0xd1e6, { 0xE6, 0xA0, 0xAD },
	0xd1e7, { 0xE6, 0xA0, 0xAF },
	0xd1e8, { 0xE6, 0xA1, 0x8E },
	0xd1e9, { 0xE6, 0xA1, 0x84 },
	0xd1ea, { 0xE6, 0xA0, 0xB4 },
	0xd1eb, { 0xE6, 0xA0, 0x9D },
	0xd1ec, { 0xE6, 0xA0, 0x92 },
	0xd1ed, { 0xE6, 0xA0, 0x94 },
	0xd1ee, { 0xE6, 0xA0, 0xA6 },
	0xd1ef, { 0xE6, 0xA0, 0xA8 },
	0xd1f0, { 0xE6, 0xA0, 0xAE },
	0xd1f1, { 0xE6, 0xA1, 0x8D },
	0xd1f2, { 0xE6, 0xA0, 0xBA },
	0xd1f3, { 0xE6, 0xA0, 0xA5 },
	0xd1f4, { 0xE6, 0xA0, 0xA0 },
	0xd1f5, { 0xE6, 0xAC, 0xAC },
	0xd1f6, { 0xE6, 0xAC, 0xAF },
	0xd1f7, { 0xE6, 0xAC, 0xAD },
	0xd1f8, { 0xE6, 0xAC, 0xB1 },
	0xd1f9, { 0xE6, 0xAC, 0xB4 },
	0xd1fa, { 0xE6, 0xAD, 0xAD },
	0xd1fb, { 0xE8, 0x82, 0x82 },
	0xd1fc, { 0xE6, 0xAE, 0x88 },
	0xd1fd, { 0xE6, 0xAF, 0xA6 },
	0xd1fe, { 0xE6, 0xAF, 0xA4 },
	0xd240, { 0xE6, 0xAF, 0xA8 },
	0xd241, { 0xE6, 0xAF, 0xA3 },
	0xd242, { 0xE6, 0xAF, 0xA2 },
	0xd243, { 0xE6, 0xAF, 0xA7 },
	0xd244, { 0xE6, 0xB0, 0xA5 },
	0xd245, { 0xE6, 0xB5, 0xBA },
	0xd246, { 0xE6, 0xB5, 0xA3 },
	0xd247, { 0xE6, 0xB5, 0xA4 },
	0xd248, { 0xE6, 0xB5, 0xB6 },
	0xd249, { 0xE6, 0xB4, 0x8D },
	0xd24a, { 0xE6, 0xB5, 0xA1 },
	0xd24b, { 0xE6, 0xB6, 0x92 },
	0xd24c, { 0xE6, 0xB5, 0x98 },
	0xd24d, { 0xE6, 0xB5, 0xA2 },
	0xd24e, { 0xE6, 0xB5, 0xAD },
	0xd24f, { 0xE6, 0xB5, 0xAF },
	0xd250, { 0xE6, 0xB6, 0x91 },
	0xd251, { 0xE6, 0xB6, 0x8D },
	0xd252, { 0xE6, 0xB7, 0xAF },
	0xd253, { 0xE6, 0xB5, 0xBF },
	0xd254, { 0xE6, 0xB6, 0x86 },
	0xd255, { 0xE6, 0xB5, 0x9E },
	0xd256, { 0xE6, 0xB5, 0xA7 },
	0xd257, { 0xE6, 0xB5, 0xA0 },
	0xd258, { 0xE6, 0xB6, 0x97 },
	0xd259, { 0xE6, 0xB5, 0xB0 },
	0xd25a, { 0xE6, 0xB5, 0xBC },
	0xd25b, { 0xE6, 0xB5, 0x9F },
	0xd25c, { 0xE6, 0xB6, 0x82 },
	0xd25d, { 0xE6, 0xB6, 0x98 },
	0xd25e, { 0xE6, 0xB4, 0xAF },
	0xd25f, { 0xE6, 0xB5, 0xA8 },
	0xd260, { 0xE6, 0xB6, 0x8B },
	0xd261, { 0xE6, 0xB5, 0xBE },
	0xd262, { 0xE6, 0xB6, 0x80 },
	0xd263, { 0xE6, 0xB6, 0x84 },
	0xd264, { 0xE6, 0xB4, 0x96 },
	0xd265, { 0xE6, 0xB6, 0x83 },
	0xd266, { 0xE6, 0xB5, 0xBB },
	0xd267, { 0xE6, 0xB5, 0xBD },
	0xd268, { 0xE6, 0xB5, 0xB5 },
	0xd269, { 0xE6, 0xB6, 0x90 },
	0xd26a, { 0xE7, 0x83, 0x9C },
	0xd26b, { 0xE7, 0x83, 0x93 },
	0xd26c, { 0xE7, 0x83, 0x91 },
	0xd26d, { 0xE7, 0x83, 0x9D },
	0xd26e, { 0xE7, 0x83, 0x8B },
	0xd26f, { 0xE7, 0xBC, 0xB9 },
	0xd270, { 0xE7, 0x83, 0xA2 },
	0xd271, { 0xE7, 0x83, 0x97 },
	0xd272, { 0xE7, 0x83, 0x92 },
	0xd273, { 0xE7, 0x83, 0x9E },
	0xd274, { 0xE7, 0x83, 0xA0 },
	0xd275, { 0xE7, 0x83, 0x94 },
	0xd276, { 0xE7, 0x83, 0x8D },
	0xd277, { 0xE7, 0x83, 0x85 },
	0xd278, { 0xE7, 0x83, 0x86 },
	0xd279, { 0xE7, 0x83, 0x87 },
	0xd27a, { 0xE7, 0x83, 0x9A },
	0xd27b, { 0xE7, 0x83, 0x8E },
	0xd27c, { 0xE7, 0x83, 0xA1 },
	0xd27d, { 0xE7, 0x89, 0x82 },
	0xd27e, { 0xE7, 0x89, 0xB8 },
	0xd2a1, { 0xE7, 0x89, 0xB7 },
	0xd2a2, { 0xE7, 0x89, 0xB6 },
	0xd2a3, { 0xE7, 0x8C, 0x80 },
	0xd2a4, { 0xE7, 0x8B, 0xBA },
	0xd2a5, { 0xE7, 0x8B, 0xB4 },
	0xd2a6, { 0xE7, 0x8B, 0xBE },
	0xd2a7, { 0xE7, 0x8B, 0xB6 },
	0xd2a8, { 0xE7, 0x8B, 0xB3 },
	0xd2a9, { 0xE7, 0x8B, 0xBB },
	0xd2aa, { 0xE7, 0x8C, 0x81 },
	0xd2ab, { 0xE7, 0x8F, 0x93 },
	0xd2ac, { 0xE7, 0x8F, 0x99 },
	0xd2ad, { 0xE7, 0x8F, 0xA5 },
	0xd2ae, { 0xE7, 0x8F, 0x96 },
	0xd2af, { 0xE7, 0x8E, 0xBC },
	0xd2b0, { 0xE7, 0x8F, 0xA7 },
	0xd2b1, { 0xE7, 0x8F, 0xA3 },
	0xd2b2, { 0xE7, 0x8F, 0xA9 },
	0xd2b3, { 0xE7, 0x8F, 0x9C },
	0xd2b4, { 0xE7, 0x8F, 0x92 },
	0xd2b5, { 0xE7, 0x8F, 0x9B },
	0xd2b6, { 0xE7, 0x8F, 0x94 },
	0xd2b7, { 0xE7, 0x8F, 0x9D },
	0xd2b8, { 0xE7, 0x8F, 0x9A },
	0xd2b9, { 0xE7, 0x8F, 0x97 },
	0xd2ba, { 0xE7, 0x8F, 0x98 },
	0xd2bb, { 0xE7, 0x8F, 0xA8 },
	0xd2bc, { 0xE7, 0x93, 0x9E },
	0xd2bd, { 0xE7, 0x93, 0x9F },
	0xd2be, { 0xE7, 0x93, 0xB4 },
	0xd2bf, { 0xE7, 0x93, 0xB5 },
	0xd2c0, { 0xE7, 0x94, 0xA1 },
	0xd2c1, { 0xE7, 0x95, 0x9B },
	0xd2c2, { 0xE7, 0x95, 0x9F },
	0xd2c3, { 0xE7, 0x96, 0xB0 },
	0xd2c4, { 0xE7, 0x97, 0x81 },
	0xd2c5, { 0xE7, 0x96, 0xBB },
	0xd2c6, { 0xE7, 0x97, 0x84 },
	0xd2c7, { 0xE7, 0x97, 0x80 },
	0xd2c8, { 0xE7, 0x96, 0xBF },
	0xd2c9, { 0xE7, 0x96, 0xB6 },
	0xd2ca, { 0xE7, 0x96, 0xBA },
	0xd2cb, { 0xE7, 0x9A, 0x8A },
	0xd2cc, { 0xE7, 0x9B, 0x89 },
	0xd2cd, { 0xE7, 0x9C, 0x9D },
	0xd2ce, { 0xE7, 0x9C, 0x9B },
	0xd2cf, { 0xE7, 0x9C, 0x90 },
	0xd2d0, { 0xE7, 0x9C, 0x93 },
	0xd2d1, { 0xE7, 0x9C, 0x92 },
	0xd2d2, { 0xE7, 0x9C, 0xA3 },
	0xd2d3, { 0xE7, 0x9C, 0x91 },
	0xd2d4, { 0xE7, 0x9C, 0x95 },
	0xd2d5, { 0xE7, 0x9C, 0x99 },
	0xd2d6, { 0xE7, 0x9C, 0x9A },
	0xd2d7, { 0xE7, 0x9C, 0xA2 },
	0xd2d8, { 0xE7, 0x9C, 0xA7 },
	0xd2d9, { 0xE7, 0xA0, 0xA3 },
	0xd2da, { 0xE7, 0xA0, 0xAC },
	0xd2db, { 0xE7, 0xA0, 0xA2 },
	0xd2dc, { 0xE7, 0xA0, 0xB5 },
	0xd2dd, { 0xE7, 0xA0, 0xAF },
	0xd2de, { 0xE7, 0xA0, 0xA8 },
	0xd2df, { 0xE7, 0xA0, 0xAE },
	0xd2e0, { 0xE7, 0xA0, 0xAB },
	0xd2e1, { 0xE7, 0xA0, 0xA1 },
	0xd2e2, { 0xE7, 0xA0, 0xA9 },
	0xd2e3, { 0xE7, 0xA0, 0xB3 },
	0xd2e4, { 0xE7, 0xA0, 0xAA },
	0xd2e5, { 0xE7, 0xA0, 0xB1 },
	0xd2e6, { 0xE7, 0xA5, 0x94 },
	0xd2e7, { 0xE7, 0xA5, 0x9B },
	0xd2e8, { 0xE7, 0xA5, 0x8F },
	0xd2e9, { 0xE7, 0xA5, 0x9C },
	0xd2ea, { 0xE7, 0xA5, 0x93 },
	0xd2eb, { 0xE7, 0xA5, 0x92 },
	0xd2ec, { 0xE7, 0xA5, 0x91 },
	0xd2ed, { 0xE7, 0xA7, 0xAB },
	0xd2ee, { 0xE7, 0xA7, 0xAC },
	0xd2ef, { 0xE7, 0xA7, 0xA0 },
	0xd2f0, { 0xE7, 0xA7, 0xAE },
	0xd2f1, { 0xE7, 0xA7, 0xAD },
	0xd2f2, { 0xE7, 0xA7, 0xAA },
	0xd2f3, { 0xE7, 0xA7, 0x9C },
	0xd2f4, { 0xE7, 0xA7, 0x9E },
	0xd2f5, { 0xE7, 0xA7, 0x9D },
	0xd2f6, { 0xE7, 0xAA, 0x86 },
	0xd2f7, { 0xE7, 0xAA, 0x89 },
	0xd2f8, { 0xE7, 0xAA, 0x85 },
	0xd2f9, { 0xE7, 0xAA, 0x8B },
	0xd2fa, { 0xE7, 0xAA, 0x8C },
	0xd2fb, { 0xE7, 0xAA, 0x8A },
	0xd2fc, { 0xE7, 0xAA, 0x87 },
	0xd2fd, { 0xE7, 0xAB, 0x98 },
	0xd2fe, { 0xE7, 0xAC, 0x90 },
	0xd340, { 0xE7, 0xAC, 0x84 },
	0xd341, { 0xE7, 0xAC, 0x93 },
	0xd342, { 0xE7, 0xAC, 0x85 },
	0xd343, { 0xE7, 0xAC, 0x8F },
	0xd344, { 0xE7, 0xAC, 0x88 },
	0xd345, { 0xE7, 0xAC, 0x8A },
	0xd346, { 0xE7, 0xAC, 0x8E },
	0xd347, { 0xE7, 0xAC, 0x89 },
	0xd348, { 0xE7, 0xAC, 0x92 },
	0xd349, { 0xE7, 0xB2, 0x84 },
	0xd34a, { 0xE7, 0xB2, 0x91 },
	0xd34b, { 0xE7, 0xB2, 0x8A },
	0xd34c, { 0xE7, 0xB2, 0x8C },
	0xd34d, { 0xE7, 0xB2, 0x88 },
	0xd34e, { 0xE7, 0xB2, 0x8D },
	0xd34f, { 0xE7, 0xB2, 0x85 },
	0xd350, { 0xE7, 0xB4, 0x9E },
	0xd351, { 0xE7, 0xB4, 0x9D },
	0xd352, { 0xE7, 0xB4, 0x91 },
	0xd353, { 0xE7, 0xB4, 0x8E },
	0xd354, { 0xE7, 0xB4, 0x98 },
	0xd355, { 0xE7, 0xB4, 0x96 },
	0xd356, { 0xE7, 0xB4, 0x93 },
	0xd357, { 0xE7, 0xB4, 0x9F },
	0xd358, { 0xE7, 0xB4, 0x92 },
	0xd359, { 0xE7, 0xB4, 0x8F },
	0xd35a, { 0xE7, 0xB4, 0x8C },
	0xd35b, { 0xE7, 0xBD, 0x9C },
	0xd35c, { 0xE7, 0xBD, 0xA1 },
	0xd35d, { 0xE7, 0xBD, 0x9E },
	0xd35e, { 0xE7, 0xBD, 0xA0 },
	0xd35f, { 0xE7, 0xBD, 0x9D },
	0xd360, { 0xE7, 0xBD, 0x9B },
	0xd361, { 0xE7, 0xBE, 0x96 },
	0xd362, { 0xE7, 0xBE, 0x92 },
	0xd363, { 0xE7, 0xBF, 0x83 },
	0xd364, { 0xE7, 0xBF, 0x82 },
	0xd365, { 0xE7, 0xBF, 0x80 },
	0xd366, { 0xE8, 0x80, 0x96 },
	0xd367, { 0xE8, 0x80, 0xBE },
	0xd368, { 0xE8, 0x80, 0xB9 },
	0xd369, { 0xE8, 0x83, 0xBA },
	0xd36a, { 0xE8, 0x83, 0xB2 },
	0xd36b, { 0xE8, 0x83, 0xB9 },
	0xd36c, { 0xE8, 0x83, 0xB5 },
	0xd36d, { 0xE8, 0x84, 0x81 },
	0xd36e, { 0xE8, 0x83, 0xBB },
	0xd36f, { 0xE8, 0x84, 0x80 },
	0xd370, { 0xE8, 0x88, 0x81 },
	0xd371, { 0xE8, 0x88, 0xAF },
	0xd372, { 0xE8, 0x88, 0xA5 },
	0xd373, { 0xE8, 0x8C, 0xB3 },
	0xd374, { 0xE8, 0x8C, 0xAD },
	0xd375, { 0xE8, 0x8D, 0x84 },
	0xd376, { 0xE8, 0x8C, 0x99 },
	0xd377, { 0xE8, 0x8D, 0x91 },
	0xd378, { 0xE8, 0x8C, 0xA5 },
	0xd379, { 0xE8, 0x8D, 0x96 },
	0xd37a, { 0xE8, 0x8C, 0xBF },
	0xd37b, { 0xE8, 0x8D, 0x81 },
	0xd37c, { 0xE8, 0x8C, 0xA6 },
	0xd37d, { 0xE8, 0x8C, 0x9C },
	0xd37e, { 0xE8, 0x8C, 0xA2 },
	0xd3a1, { 0xE8, 0x8D, 0x82 },
	0xd3a2, { 0xE8, 0x8D, 0x8E },
	0xd3a3, { 0xE8, 0x8C, 0x9B },
	0xd3a4, { 0xE8, 0x8C, 0xAA },
	0xd3a5, { 0xE8, 0x8C, 0x88 },
	0xd3a6, { 0xE8, 0x8C, 0xBC },
	0xd3a7, { 0xE8, 0x8D, 0x8D },
	0xd3a8, { 0xE8, 0x8C, 0x96 },
	0xd3a9, { 0xE8, 0x8C, 0xA4 },
	0xd3aa, { 0xE8, 0x8C, 0xA0 },
	0xd3ab, { 0xE8, 0x8C, 0xB7 },
	0xd3ac, { 0xE8, 0x8C, 0xAF },
	0xd3ad, { 0xE8, 0x8C, 0xA9 },
	0xd3ae, { 0xE8, 0x8D, 0x87 },
	0xd3af, { 0xE8, 0x8D, 0x85 },
	0xd3b0, { 0xE8, 0x8D, 0x8C },
	0xd3b1, { 0xE8, 0x8D, 0x93 },
	0xd3b2, { 0xE8, 0x8C, 0x9E },
	0xd3b3, { 0xE8, 0x8C, 0xAC },
	0xd3b4, { 0xE8, 0x8D, 0x8B },
	0xd3b5, { 0xE8, 0x8C, 0xA7 },
	0xd3b6, { 0xE8, 0x8D, 0x88 },
	0xd3b7, { 0xE8, 0x99, 0x93 },
	0xd3b8, { 0xE8, 0x99, 0x92 },
	0xd3b9, { 0xE8, 0x9A, 0xA2 },
	0xd3ba, { 0xE8, 0x9A, 0xA8 },
	0xd3bb, { 0xE8, 0x9A, 0x96 },
	0xd3bc, { 0xE8, 0x9A, 0x8D },
	0xd3bd, { 0xE8, 0x9A, 0x91 },
	0xd3be, { 0xE8, 0x9A, 0x9E },
	0xd3bf, { 0xE8, 0x9A, 0x87 },
	0xd3c0, { 0xE8, 0x9A, 0x97 },
	0xd3c1, { 0xE8, 0x9A, 0x86 },
	0xd3c2, { 0xE8, 0x9A, 0x8B },
	0xd3c3, { 0xE8, 0x9A, 0x9A },
	0xd3c4, { 0xE8, 0x9A, 0x85 },
	0xd3c5, { 0xE8, 0x9A, 0xA5 },
	0xd3c6, { 0xE8, 0x9A, 0x99 },
	0xd3c7, { 0xE8, 0x9A, 0xA1 },
	0xd3c8, { 0xE8, 0x9A, 0xA7 },
	0xd3c9, { 0xE8, 0x9A, 0x95 },
	0xd3ca, { 0xE8, 0x9A, 0x98 },
	0xd3cb, { 0xE8, 0x9A, 0x8E },
	0xd3cc, { 0xE8, 0x9A, 0x9D },
	0xd3cd, { 0xE8, 0x9A, 0x90 },
	0xd3ce, { 0xE8, 0x9A, 0x94 },
	0xd3cf, { 0xE8, 0xA1, 0x83 },
	0xd3d0, { 0xE8, 0xA1, 0x84 },
	0xd3d1, { 0xE8, 0xA1, 0xAD },
	0xd3d2, { 0xE8, 0xA1, 0xB5 },
	0xd3d3, { 0xE8, 0xA1, 0xB6 },
	0xd3d4, { 0xE8, 0xA1, 0xB2 },
	0xd3d5, { 0xE8, 0xA2, 0x80 },
	0xd3d6, { 0xE8, 0xA1, 0xB1 },
	0xd3d7, { 0xE8, 0xA1, 0xBF },
	0xd3d8, { 0xE8, 0xA1, 0xAF },
	0xd3d9, { 0xE8, 0xA2, 0x83 },
	0xd3da, { 0xE8, 0xA1, 0xBE },
	0xd3db, { 0xE8, 0xA1, 0xB4 },
	0xd3dc, { 0xE8, 0xA1, 0xBC },
	0xd3dd, { 0xE8, 0xA8, 0x92 },
	0xd3de, { 0xE8, 0xB1, 0x87 },
	0xd3df, { 0xE8, 0xB1, 0x97 },
	0xd3e0, { 0xE8, 0xB1, 0xBB },
	0xd3e1, { 0xE8, 0xB2, 0xA4 },
	0xd3e2, { 0xE8, 0xB2, 0xA3 },
	0xd3e3, { 0xE8, 0xB5, 0xB6 },
	0xd3e4, { 0xE8, 0xB5, 0xB8 },
	0xd3e5, { 0xE8, 0xB6, 0xB5 },
	0xd3e6, { 0xE8, 0xB6, 0xB7 },
	0xd3e7, { 0xE8, 0xB6, 0xB6 },
	0xd3e8, { 0xE8, 0xBB, 0x91 },
	0xd3e9, { 0xE8, 0xBB, 0x93 },
	0xd3ea, { 0xE8, 0xBF, 0xBE },
	0xd3eb, { 0xE8, 0xBF, 0xB5 },
	0xd3ec, { 0xE9, 0x80, 0x82 },
	0xd3ed, { 0xE8, 0xBF, 0xBF },
	0xd3ee, { 0xE8, 0xBF, 0xBB },
	0xd3ef, { 0xE9, 0x80, 0x84 },
	0xd3f0, { 0xE8, 0xBF, 0xBC },
	0xd3f1, { 0xE8, 0xBF, 0xB6 },
	0xd3f2, { 0xE9, 0x83, 0x96 },
	0xd3f3, { 0xE9, 0x83, 0xA0 },
	0xd3f4, { 0xE9, 0x83, 0x99 },
	0xd3f5, { 0xE9, 0x83, 0x9A },
	0xd3f6, { 0xE9, 0x83, 0xA3 },
	0xd3f7, { 0xE9, 0x83, 0x9F },
	0xd3f8, { 0xE9, 0x83, 0xA5 },
	0xd3f9, { 0xE9, 0x83, 0x98 },
	0xd3fa, { 0xE9, 0x83, 0x9B },
	0xd3fb, { 0xE9, 0x83, 0x97 },
	0xd3fc, { 0xE9, 0x83, 0x9C },
	0xd3fd, { 0xE9, 0x83, 0xA4 },
	0xd3fe, { 0xE9, 0x85, 0x90 },
	0xd440, { 0xE9, 0x85, 0x8E },
	0xd441, { 0xE9, 0x85, 0x8F },
	0xd442, { 0xE9, 0x87, 0x95 },
	0xd443, { 0xE9, 0x87, 0xA2 },
	0xd444, { 0xE9, 0x87, 0x9A },
	0xd445, { 0xE9, 0x99, 0x9C },
	0xd446, { 0xE9, 0x99, 0x9F },
	0xd447, { 0xE9, 0x9A, 0xBC },
	0xd448, { 0xE9, 0xA3, 0xA3 },
	0xd449, { 0xE9, 0xAB, 0x9F },
	0xd44a, { 0xE9, 0xAC, 0xAF },
	0xd44b, { 0xE4, 0xB9, 0xBF },
	0xd44c, { 0xE5, 0x81, 0xB0 },
	0xd44d, { 0xE5, 0x81, 0xAA },
	0xd44e, { 0xE5, 0x81, 0xA1 },
	0xd44f, { 0xE5, 0x81, 0x9E },
	0xd450, { 0xE5, 0x81, 0xA0 },
	0xd451, { 0xE5, 0x81, 0x93 },
	0xd452, { 0xE5, 0x81, 0x8B },
	0xd453, { 0xE5, 0x81, 0x9D },
	0xd454, { 0xE5, 0x81, 0xB2 },
	0xd455, { 0xE5, 0x81, 0x88 },
	0xd456, { 0xE5, 0x81, 0x8D },
	0xd457, { 0xE5, 0x81, 0x81 },
	0xd458, { 0xE5, 0x81, 0x9B },
	0xd459, { 0xE5, 0x81, 0x8A },
	0xd45a, { 0xE5, 0x81, 0xA2 },
	0xd45b, { 0xE5, 0x80, 0x95 },
	0xd45c, { 0xE5, 0x81, 0x85 },
	0xd45d, { 0xE5, 0x81, 0x9F },
	0xd45e, { 0xE5, 0x81, 0xA9 },
	0xd45f, { 0xE5, 0x81, 0xAB },
	0xd460, { 0xE5, 0x81, 0xA3 },
	0xd461, { 0xE5, 0x81, 0xA4 },
	0xd462, { 0xE5, 0x81, 0x86 },
	0xd463, { 0xE5, 0x81, 0x80 },
	0xd464, { 0xE5, 0x81, 0xAE },
	0xd465, { 0xE5, 0x81, 0xB3 },
	0xd466, { 0xE5, 0x81, 0x97 },
	0xd467, { 0xE5, 0x81, 0x91 },
	0xd468, { 0xE5, 0x87, 0x90 },
	0xd469, { 0xE5, 0x89, 0xAB },
	0xd46a, { 0xE5, 0x89, 0xAD },
	0xd46b, { 0xE5, 0x89, 0xAC },
	0xd46c, { 0xE5, 0x89, 0xAE },
	0xd46d, { 0xE5, 0x8B, 0x96 },
	0xd46e, { 0xE5, 0x8B, 0x93 },
	0xd46f, { 0xE5, 0x8C, 0xAD },
	0xd470, { 0xE5, 0x8E, 0x9C },
	0xd471, { 0xE5, 0x95, 0xB5 },
	0xd472, { 0xE5, 0x95, 0xB6 },
	0xd473, { 0xE5, 0x94, 0xBC },
	0xd474, { 0xE5, 0x95, 0x8D },
	0xd475, { 0xE5, 0x95, 0x90 },
	0xd476, { 0xE5, 0x94, 0xB4 },
	0xd477, { 0xE5, 0x94, 0xAA },
	0xd478, { 0xE5, 0x95, 0x91 },
	0xd479, { 0xE5, 0x95, 0xA2 },
	0xd47a, { 0xE5, 0x94, 0xB6 },
	0xd47b, { 0xE5, 0x94, 0xB5 },
	0xd47c, { 0xE5, 0x94, 0xB0 },
	0xd47d, { 0xE5, 0x95, 0x92 },
	0xd47e, { 0xE5, 0x95, 0x85 },
	0xd4a1, { 0xE5, 0x94, 0x8C },
	0xd4a2, { 0xE5, 0x94, 0xB2 },
	0xd4a3, { 0xE5, 0x95, 0xA5 },
	0xd4a4, { 0xE5, 0x95, 0x8E },
	0xd4a5, { 0xE5, 0x94, 0xB9 },
	0xd4a6, { 0xE5, 0x95, 0x88 },
	0xd4a7, { 0xE5, 0x94, 0xAD },
	0xd4a8, { 0xE5, 0x94, 0xBB },
	0xd4a9, { 0xE5, 0x95, 0x80 },
	0xd4aa, { 0xE5, 0x95, 0x8B },
	0xd4ab, { 0xE5, 0x9C, 0x8A },
	0xd4ac, { 0xE5, 0x9C, 0x87 },
	0xd4ad, { 0xE5, 0x9F, 0xBB },
	0xd4ae, { 0xE5, 0xA0, 0x94 },
	0xd4af, { 0xE5, 0x9F, 0xA2 },
	0xd4b0, { 0xE5, 0x9F, 0xB6 },
	0xd4b1, { 0xE5, 0x9F, 0x9C },
	0xd4b2, { 0xE5, 0x9F, 0xB4 },
	0xd4b3, { 0xE5, 0xA0, 0x80 },
	0xd4b4, { 0xE5, 0x9F, 0xAD },
	0xd4b5, { 0xE5, 0x9F, 0xBD },
	0xd4b6, { 0xE5, 0xA0, 0x88 },
	0xd4b7, { 0xE5, 0x9F, 0xB8 },
	0xd4b8, { 0xE5, 0xA0, 0x8B },
	0xd4b9, { 0xE5, 0x9F, 0xB3 },
	0xd4ba, { 0xE5, 0x9F, 0x8F },
	0xd4bb, { 0xE5, 0xA0, 0x87 },
	0xd4bc, { 0xE5, 0x9F, 0xAE },
	0xd4bd, { 0xE5, 0x9F, 0xA3 },
	0xd4be, { 0xE5, 0x9F, 0xB2 },
	0xd4bf, { 0xE5, 0x9F, 0xA5 },
	0xd4c0, { 0xE5, 0x9F, 0xAC },
	0xd4c1, { 0xE5, 0x9F, 0xA1 },
	0xd4c2, { 0xE5, 0xA0, 0x8E },
	0xd4c3, { 0xE5, 0x9F, 0xBC },
	0xd4c4, { 0xE5, 0xA0, 0x90 },
	0xd4c5, { 0xE5, 0x9F, 0xA7 },
	0xd4c6, { 0xE5, 0xA0, 0x81 },
	0xd4c7, { 0xE5, 0xA0, 0x8C },
	0xd4c8, { 0xE5, 0x9F, 0xB1 },
	0xd4c9, { 0xE5, 0x9F, 0xA9 },
	0xd4ca, { 0xE5, 0x9F, 0xB0 },
	0xd4cb, { 0xE5, 0xA0, 0x8D },
	0xd4cc, { 0xE5, 0xA0, 0x84 },
	0xd4cd, { 0xE5, 0xA5, 0x9C },
	0xd4ce, { 0xE5, 0xA9, 0xA0 },
	0xd4cf, { 0xE5, 0xA9, 0x98 },
	0xd4d0, { 0xE5, 0xA9, 0x95 },
	0xd4d1, { 0xE5, 0xA9, 0xA7 },
	0xd4d2, { 0xE5, 0xA9, 0x9E },
	0xd4d3, { 0xE5, 0xA8, 0xB8 },
	0xd4d4, { 0xE5, 0xA8, 0xB5 },
	0xd4d5, { 0xE5, 0xA9, 0xAD },
	0xd4d6, { 0xE5, 0xA9, 0x90 },
	0xd4d7, { 0xE5, 0xA9, 0x9F },
	0xd4d8, { 0xE5, 0xA9, 0xA5 },
	0xd4d9, { 0xE5, 0xA9, 0xAC },
	0xd4da, { 0xE5, 0xA9, 0x93 },
	0xd4db, { 0xE5, 0xA9, 0xA4 },
	0xd4dc, { 0xE5, 0xA9, 0x97 },
	0xd4dd, { 0xE5, 0xA9, 0x83 },
	0xd4de, { 0xE5, 0xA9, 0x9D },
	0xd4df, { 0xE5, 0xA9, 0x92 },
	0xd4e0, { 0xE5, 0xA9, 0x84 },
	0xd4e1, { 0xE5, 0xA9, 0x9B },
	0xd4e2, { 0xE5, 0xA9, 0x88 },
	0xd4e3, { 0xE5, 0xAA, 0x8E },
	0xd4e4, { 0xE5, 0xA8, 0xBE },
	0xd4e5, { 0xE5, 0xA9, 0x8D },
	0xd4e6, { 0xE5, 0xA8, 0xB9 },
	0xd4e7, { 0xE5, 0xA9, 0x8C },
	0xd4e8, { 0xE5, 0xA9, 0xB0 },
	0xd4e9, { 0xE5, 0xA9, 0xA9 },
	0xd4ea, { 0xE5, 0xA9, 0x87 },
	0xd4eb, { 0xE5, 0xA9, 0x91 },
	0xd4ec, { 0xE5, 0xA9, 0x96 },
	0xd4ed, { 0xE5, 0xA9, 0x82 },
	0xd4ee, { 0xE5, 0xA9, 0x9C },
	0xd4ef, { 0xE5, 0xAD, 0xB2 },
	0xd4f0, { 0xE5, 0xAD, 0xAE },
	0xd4f1, { 0xE5, 0xAF, 0x81 },
	0xd4f2, { 0xE5, 0xAF, 0x80 },
	0xd4f3, { 0xE5, 0xB1, 0x99 },
	0xd4f4, { 0xE5, 0xB4, 0x9E },
	0xd4f5, { 0xE5, 0xB4, 0x8B },
	0xd4f6, { 0xE5, 0xB4, 0x9D },
	0xd4f7, { 0xE5, 0xB4, 0x9A },
	0xd4f8, { 0xE5, 0xB4, 0xA0 },
	0xd4f9, { 0xE5, 0xB4, 0x8C },
	0xd4fa, { 0xE5, 0xB4, 0xA8 },
	0xd4fb, { 0xE5, 0xB4, 0x8D },
	0xd4fc, { 0xE5, 0xB4, 0xA6 },
	0xd4fd, { 0xE5, 0xB4, 0xA5 },
	0xd4fe, { 0xE5, 0xB4, 0x8F },
	0xd540, { 0xE5, 0xB4, 0xB0 },
	0xd541, { 0xE5, 0xB4, 0x92 },
	0xd542, { 0xE5, 0xB4, 0xA3 },
	0xd543, { 0xE5, 0xB4, 0x9F },
	0xd544, { 0xE5, 0xB4, 0xAE },
	0xd545, { 0xE5, 0xB8, 0xBE },
	0xd546, { 0xE5, 0xB8, 0xB4 },
	0xd547, { 0xE5, 0xBA, 0xB1 },
	0xd548, { 0xE5, 0xBA, 0xB4 },
	0xd549, { 0xE5, 0xBA, 0xB9 },
	0xd54a, { 0xE5, 0xBA, 0xB2 },
	0xd54b, { 0xE5, 0xBA, 0xB3 },
	0xd54c, { 0xE5, 0xBC, 0xB6 },
	0xd54d, { 0xE5, 0xBC, 0xB8 },
	0xd54e, { 0xE5, 0xBE, 0x9B },
	0xd54f, { 0xE5, 0xBE, 0x96 },
	0xd550, { 0xE5, 0xBE, 0x9F },
	0xd551, { 0xE6, 0x82, 0x8A },
	0xd552, { 0xE6, 0x82, 0x90 },
	0xd553, { 0xE6, 0x82, 0x86 },
	0xd554, { 0xE6, 0x82, 0xBE },
	0xd555, { 0xE6, 0x82, 0xB0 },
	0xd556, { 0xE6, 0x82, 0xBA },
	0xd557, { 0xE6, 0x83, 0x93 },
	0xd558, { 0xE6, 0x83, 0x94 },
	0xd559, { 0xE6, 0x83, 0x8F },
	0xd55a, { 0xE6, 0x83, 0xA4 },
	0xd55b, { 0xE6, 0x83, 0x99 },
	0xd55c, { 0xE6, 0x83, 0x9D },
	0xd55d, { 0xE6, 0x83, 0x88 },
	0xd55e, { 0xE6, 0x82, 0xB1 },
	0xd55f, { 0xE6, 0x83, 0x9B },
	0xd560, { 0xE6, 0x82, 0xB7 },
	0xd561, { 0xE6, 0x83, 0x8A },
	0xd562, { 0xE6, 0x82, 0xBF },
	0xd563, { 0xE6, 0x83, 0x83 },
	0xd564, { 0xE6, 0x83, 0x8D },
	0xd565, { 0xE6, 0x83, 0x80 },
	0xd566, { 0xE6, 0x8C, 0xB2 },
	0xd567, { 0xE6, 0x8D, 0xA5 },
	0xd568, { 0xE6, 0x8E, 0x8A },
	0xd569, { 0xE6, 0x8E, 0x82 },
	0xd56a, { 0xE6, 0x8D, 0xBD },
	0xd56b, { 0xE6, 0x8E, 0xBD },
	0xd56c, { 0xE6, 0x8E, 0x9E },
	0xd56d, { 0xE6, 0x8E, 0xAD },
	0xd56e, { 0xE6, 0x8E, 0x9D },
	0xd56f, { 0xE6, 0x8E, 0x97 },
	0xd570, { 0xE6, 0x8E, 0xAB },
	0xd571, { 0xE6, 0x8E, 0x8E },
	0xd572, { 0xE6, 0x8D, 0xAF },
	0xd573, { 0xE6, 0x8E, 0x87 },
	0xd574, { 0xE6, 0x8E, 0x90 },
	0xd575, { 0xE6, 0x8D, 0xAE },
	0xd576, { 0xE6, 0x8E, 0xAF },
	0xd577, { 0xE6, 0x8D, 0xB5 },
	0xd578, { 0xE6, 0x8E, 0x9C },
	0xd579, { 0xE6, 0x8D, 0xAD },
	0xd57a, { 0xE6, 0x8E, 0xAE },
	0xd57b, { 0xE6, 0x8D, 0xBC },
	0xd57c, { 0xE6, 0x8E, 0xA4 },
	0xd57d, { 0xE6, 0x8C, 0xBB },
	0xd57e, { 0xE6, 0x8E, 0x9F },
	0xd5a1, { 0xE6, 0x8D, 0xB8 },
	0xd5a2, { 0xE6, 0x8E, 0x85 },
	0xd5a3, { 0xE6, 0x8E, 0x81 },
	0xd5a4, { 0xE6, 0x8E, 0x91 },
	0xd5a5, { 0xE6, 0x8E, 0x8D },
	0xd5a6, { 0xE6, 0x8D, 0xB0 },
	0xd5a7, { 0xE6, 0x95, 0x93 },
	0xd5a8, { 0xE6, 0x97, 0x8D },
	0xd5a9, { 0xE6, 0x99, 0xA5 },
	0xd5aa, { 0xE6, 0x99, 0xA1 },
	0xd5ab, { 0xE6, 0x99, 0x9B },
	0xd5ac, { 0xE6, 0x99, 0x99 },
	0xd5ad, { 0xE6, 0x99, 0x9C },
	0xd5ae, { 0xE6, 0x99, 0xA2 },
	0xd5af, { 0xE6, 0x9C, 0x98 },
	0xd5b0, { 0xE6, 0xA1, 0xB9 },
	0xd5b1, { 0xE6, 0xA2, 0x87 },
	0xd5b2, { 0xE6, 0xA2, 0x90 },
	0xd5b3, { 0xE6, 0xA2, 0x9C },
	0xd5b4, { 0xE6, 0xA1, 0xAD },
	0xd5b5, { 0xE6, 0xA1, 0xAE },
	0xd5b6, { 0xE6, 0xA2, 0xAE },
	0xd5b7, { 0xE6, 0xA2, 0xAB },
	0xd5b8, { 0xE6, 0xA5, 0x96 },
	0xd5b9, { 0xE6, 0xA1, 0xAF },
	0xd5ba, { 0xE6, 0xA2, 0xA3 },
	0xd5bb, { 0xE6, 0xA2, 0xAC },
	0xd5bc, { 0xE6, 0xA2, 0xA9 },
	0xd5bd, { 0xE6, 0xA1, 0xB5 },
	0xd5be, { 0xE6, 0xA1, 0xB4 },
	0xd5bf, { 0xE6, 0xA2, 0xB2 },
	0xd5c0, { 0xE6, 0xA2, 0x8F },
	0xd5c1, { 0xE6, 0xA1, 0xB7 },
	0xd5c2, { 0xE6, 0xA2, 0x92 },
	0xd5c3, { 0xE6, 0xA1, 0xBC },
	0xd5c4, { 0xE6, 0xA1, 0xAB },
	0xd5c5, { 0xE6, 0xA1, 0xB2 },
	0xd5c6, { 0xE6, 0xA2, 0xAA },
	0xd5c7, { 0xE6, 0xA2, 0x80 },
	0xd5c8, { 0xE6, 0xA1, 0xB1 },
	0xd5c9, { 0xE6, 0xA1, 0xBE },
	0xd5ca, { 0xE6, 0xA2, 0x9B },
	0xd5cb, { 0xE6, 0xA2, 0x96 },
	0xd5cc, { 0xE6, 0xA2, 0x8B },
	0xd5cd, { 0xE6, 0xA2, 0xA0 },
	0xd5ce, { 0xE6, 0xA2, 0x89 },
	0xd5cf, { 0xE6, 0xA2, 0xA4 },
	0xd5d0, { 0xE6, 0xA1, 0xB8 },
	0xd5d1, { 0xE6, 0xA1, 0xBB },
	0xd5d2, { 0xE6, 0xA2, 0x91 },
	0xd5d3, { 0xE6, 0xA2, 0x8C },
	0xd5d4, { 0xE6, 0xA2, 0x8A },
	0xd5d5, { 0xE6, 0xA1, 0xBD },
	0xd5d6, { 0xE6, 0xAC, 0xB6 },
	0xd5d7, { 0xE6, 0xAC, 0xB3 },
	0xd5d8, { 0xE6, 0xAC, 0xB7 },
	0xd5d9, { 0xE6, 0xAC, 0xB8 },
	0xd5da, { 0xE6, 0xAE, 0x91 },
	0xd5db, { 0xE6, 0xAE, 0x8F },
	0xd5dc, { 0xE6, 0xAE, 0x8D },
	0xd5dd, { 0xE6, 0xAE, 0x8E },
	0xd5de, { 0xE6, 0xAE, 0x8C },
	0xd5df, { 0xE6, 0xB0, 0xAA },
	0xd5e0, { 0xE6, 0xB7, 0x80 },
	0xd5e1, { 0xE6, 0xB6, 0xAB },
	0xd5e2, { 0xE6, 0xB6, 0xB4 },
	0xd5e3, { 0xE6, 0xB6, 0xB3 },
	0xd5e4, { 0xE6, 0xB9, 0xB4 },
	0xd5e5, { 0xE6, 0xB6, 0xAC },
	0xd5e6, { 0xE6, 0xB7, 0xA9 },
	0xd5e7, { 0xE6, 0xB7, 0xA2 },
	0xd5e8, { 0xE6, 0xB6, 0xB7 },
	0xd5e9, { 0xE6, 0xB7, 0xB6 },
	0xd5ea, { 0xE6, 0xB7, 0x94 },
	0xd5eb, { 0xE6, 0xB8, 0x80 },
	0xd5ec, { 0xE6, 0xB7, 0x88 },
	0xd5ed, { 0xE6, 0xB7, 0xA0 },
	0xd5ee, { 0xE6, 0xB7, 0x9F },
	0xd5ef, { 0xE6, 0xB7, 0x96 },
	0xd5f0, { 0xE6, 0xB6, 0xBE },
	0xd5f1, { 0xE6, 0xB7, 0xA5 },
	0xd5f2, { 0xE6, 0xB7, 0x9C },
	0xd5f3, { 0xE6, 0xB7, 0x9D },
	0xd5f4, { 0xE6, 0xB7, 0x9B },
	0xd5f5, { 0xE6, 0xB7, 0xB4 },
	0xd5f6, { 0xE6, 0xB7, 0x8A },
	0xd5f7, { 0xE6, 0xB6, 0xBD },
	0xd5f8, { 0xE6, 0xB7, 0xAD },
	0xd5f9, { 0xE6, 0xB7, 0xB0 },
	0xd5fa, { 0xE6, 0xB6, 0xBA },
	0xd5fb, { 0xE6, 0xB7, 0x95 },
	0xd5fc, { 0xE6, 0xB7, 0x82 },
	0xd5fd, { 0xE6, 0xB7, 0x8F },
	0xd5fe, { 0xE6, 0xB7, 0x89 },
	0xd640, { 0xE6, 0xB7, 0x90 },
	0xd641, { 0xE6, 0xB7, 0xB2 },
	0xd642, { 0xE6, 0xB7, 0x93 },
	0xd643, { 0xE6, 0xB7, 0xBD },
	0xd644, { 0xE6, 0xB7, 0x97 },
	0xd645, { 0xE6, 0xB7, 0x8D },
	0xd646, { 0xE6, 0xB7, 0xA3 },
	0xd647, { 0xE6, 0xB6, 0xBB },
	0xd648, { 0xE7, 0x83, 0xBA },
	0xd649, { 0xE7, 0x84, 0x8D },
	0xd64a, { 0xE7, 0x83, 0xB7 },
	0xd64b, { 0xE7, 0x84, 0x97 },
	0xd64c, { 0xE7, 0x83, 0xB4 },
	0xd64d, { 0xE7, 0x84, 0x8C },
	0xd64e, { 0xE7, 0x83, 0xB0 },
	0xd64f, { 0xE7, 0x84, 0x84 },
	0xd650, { 0xE7, 0x83, 0xB3 },
	0xd651, { 0xE7, 0x84, 0x90 },
	0xd652, { 0xE7, 0x83, 0xBC },
	0xd653, { 0xE7, 0x83, 0xBF },
	0xd654, { 0xE7, 0x84, 0x86 },
	0xd655, { 0xE7, 0x84, 0x93 },
	0xd656, { 0xE7, 0x84, 0x80 },
	0xd657, { 0xE7, 0x83, 0xB8 },
	0xd658, { 0xE7, 0x83, 0xB6 },
	0xd659, { 0xE7, 0x84, 0x8B },
	0xd65a, { 0xE7, 0x84, 0x82 },
	0xd65b, { 0xE7, 0x84, 0x8E },
	0xd65c, { 0xE7, 0x89, 0xBE },
	0xd65d, { 0xE7, 0x89, 0xBB },
	0xd65e, { 0xE7, 0x89, 0xBC },
	0xd65f, { 0xE7, 0x89, 0xBF },
	0xd660, { 0xE7, 0x8C, 0x9D },
	0xd661, { 0xE7, 0x8C, 0x97 },
	0xd662, { 0xE7, 0x8C, 0x87 },
	0xd663, { 0xE7, 0x8C, 0x91 },
	0xd664, { 0xE7, 0x8C, 0x98 },
	0xd665, { 0xE7, 0x8C, 0x8A },
	0xd666, { 0xE7, 0x8C, 0x88 },
	0xd667, { 0xE7, 0x8B, 0xBF },
	0xd668, { 0xE7, 0x8C, 0x8F },
	0xd669, { 0xE7, 0x8C, 0x9E },
	0xd66a, { 0xE7, 0x8E, 0x88 },
	0xd66b, { 0xE7, 0x8F, 0xB6 },
	0xd66c, { 0xE7, 0x8F, 0xB8 },
	0xd66d, { 0xE7, 0x8F, 0xB5 },
	0xd66e, { 0xE7, 0x90, 0x84 },
	0xd66f, { 0xE7, 0x90, 0x81 },
	0xd670, { 0xE7, 0x8F, 0xBD },
	0xd671, { 0xE7, 0x90, 0x87 },
	0xd672, { 0xE7, 0x90, 0x80 },
	0xd673, { 0xE7, 0x8F, 0xBA },
	0xd674, { 0xE7, 0x8F, 0xBC },
	0xd675, { 0xE7, 0x8F, 0xBF },
	0xd676, { 0xE7, 0x90, 0x8C },
	0xd677, { 0xE7, 0x90, 0x8B },
	0xd678, { 0xE7, 0x8F, 0xB4 },
	0xd679, { 0xE7, 0x90, 0x88 },
	0xd67a, { 0xE7, 0x95, 0xA4 },
	0xd67b, { 0xE7, 0x95, 0xA3 },
	0xd67c, { 0xE7, 0x97, 0x8E },
	0xd67d, { 0xE7, 0x97, 0x92 },
	0xd67e, { 0xE7, 0x97, 0x8F },
	0xd6a1, { 0xE7, 0x97, 0x8B },
	0xd6a2, { 0xE7, 0x97, 0x8C },
	0xd6a3, { 0xE7, 0x97, 0x91 },
	0xd6a4, { 0xE7, 0x97, 0x90 },
	0xd6a5, { 0xE7, 0x9A, 0x8F },
	0xd6a6, { 0xE7, 0x9A, 0x89 },
	0xd6a7, { 0xE7, 0x9B, 0x93 },
	0xd6a8, { 0xE7, 0x9C, 0xB9 },
	0xd6a9, { 0xE7, 0x9C, 0xAF },
	0xd6aa, { 0xE7, 0x9C, 0xAD },
	0xd6ab, { 0xE7, 0x9C, 0xB1 },
	0xd6ac, { 0xE7, 0x9C, 0xB2 },
	0xd6ad, { 0xE7, 0x9C, 0xB4 },
	0xd6ae, { 0xE7, 0x9C, 0xB3 },
	0xd6af, { 0xE7, 0x9C, 0xBD },
	0xd6b0, { 0xE7, 0x9C, 0xA5 },
	0xd6b1, { 0xE7, 0x9C, 0xBB },
	0xd6b2, { 0xE7, 0x9C, 0xB5 },
	0xd6b3, { 0xE7, 0xA1, 0x88 },
	0xd6b4, { 0xE7, 0xA1, 0x92 },
	0xd6b5, { 0xE7, 0xA1, 0x89 },
	0xd6b6, { 0xE7, 0xA1, 0x8D },
	0xd6b7, { 0xE7, 0xA1, 0x8A },
	0xd6b8, { 0xE7, 0xA1, 0x8C },
	0xd6b9, { 0xE7, 0xA0, 0xA6 },
	0xd6ba, { 0xE7, 0xA1, 0x85 },
	0xd6bb, { 0xE7, 0xA1, 0x90 },
	0xd6bc, { 0xE7, 0xA5, 0xA4 },
	0xd6bd, { 0xE7, 0xA5, 0xA7 },
	0xd6be, { 0xE7, 0xA5, 0xA9 },
	0xd6bf, { 0xE7, 0xA5, 0xAA },
	0xd6c0, { 0xE7, 0xA5, 0xA3 },
	0xd6c1, { 0xE7, 0xA5, 0xAB },
	0xd6c2, { 0xE7, 0xA5, 0xA1 },
	0xd6c3, { 0xE7, 0xA6, 0xBB },
	0xd6c4, { 0xE7, 0xA7, 0xBA },
	0xd6c5, { 0xE7, 0xA7, 0xB8 },
	0xd6c6, { 0xE7, 0xA7, 0xB6 },
	0xd6c7, { 0xE7, 0xA7, 0xB7 },
	0xd6c8, { 0xE7, 0xAA, 0x8F },
	0xd6c9, { 0xE7, 0xAA, 0x94 },
	0xd6ca, { 0xE7, 0xAA, 0x90 },
	0xd6cb, { 0xE7, 0xAC, 0xB5 },
	0xd6cc, { 0xE7, 0xAD, 0x87 },
	0xd6cd, { 0xE7, 0xAC, 0xB4 },
	0xd6ce, { 0xE7, 0xAC, 0xA5 },
	0xd6cf, { 0xE7, 0xAC, 0xB0 },
	0xd6d0, { 0xE7, 0xAC, 0xA2 },
	0xd6d1, { 0xE7, 0xAC, 0xA4 },
	0xd6d2, { 0xE7, 0xAC, 0xB3 },
	0xd6d3, { 0xE7, 0xAC, 0x98 },
	0xd6d4, { 0xE7, 0xAC, 0xAA },
	0xd6d5, { 0xE7, 0xAC, 0x9D },
	0xd6d6, { 0xE7, 0xAC, 0xB1 },
	0xd6d7, { 0xE7, 0xAC, 0xAB },
	0xd6d8, { 0xE7, 0xAC, 0xAD },
	0xd6d9, { 0xE7, 0xAC, 0xAF },
	0xd6da, { 0xE7, 0xAC, 0xB2 },
	0xd6db, { 0xE7, 0xAC, 0xB8 },
	0xd6dc, { 0xE7, 0xAC, 0x9A },
	0xd6dd, { 0xE7, 0xAC, 0xA3 },
	0xd6de, { 0xE7, 0xB2, 0x94 },
	0xd6df, { 0xE7, 0xB2, 0x98 },
	0xd6e0, { 0xE7, 0xB2, 0x96 },
	0xd6e1, { 0xE7, 0xB2, 0xA3 },
	0xd6e2, { 0xE7, 0xB4, 0xB5 },
	0xd6e3, { 0xE7, 0xB4, 0xBD },
	0xd6e4, { 0xE7, 0xB4, 0xB8 },
	0xd6e5, { 0xE7, 0xB4, 0xB6 },
	0xd6e6, { 0xE7, 0xB4, 0xBA },
	0xd6e7, { 0xE7, 0xB5, 0x85 },
	0xd6e8, { 0xE7, 0xB4, 0xAC },
	0xd6e9, { 0xE7, 0xB4, 0xA9 },
	0xd6ea, { 0xE7, 0xB5, 0x81 },
	0xd6eb, { 0xE7, 0xB5, 0x87 },
	0xd6ec, { 0xE7, 0xB4, 0xBE },
	0xd6ed, { 0xE7, 0xB4, 0xBF },
	0xd6ee, { 0xE7, 0xB5, 0x8A },
	0xd6ef, { 0xE7, 0xB4, 0xBB },
	0xd6f0, { 0xE7, 0xB4, 0xA8 },
	0xd6f1, { 0xE7, 0xBD, 0xA3 },
	0xd6f2, { 0xE7, 0xBE, 0x95 },
	0xd6f3, { 0xE7, 0xBE, 0x9C },
	0xd6f4, { 0xE7, 0xBE, 0x9D },
	0xd6f5, { 0xE7, 0xBE, 0x9B },
	0xd6f6, { 0xE7, 0xBF, 0x8A },
	0xd6f7, { 0xE7, 0xBF, 0x8B },
	0xd6f8, { 0xE7, 0xBF, 0x8D },
	0xd6f9, { 0xE7, 0xBF, 0x90 },
	0xd6fa, { 0xE7, 0xBF, 0x91 },
	0xd6fb, { 0xE7, 0xBF, 0x87 },
	0xd6fc, { 0xE7, 0xBF, 0x8F },
	0xd6fd, { 0xE7, 0xBF, 0x89 },
	0xd6fe, { 0xE8, 0x80, 0x9F },
	0xd740, { 0xE8, 0x80, 0x9E },
	0xd741, { 0xE8, 0x80, 0x9B },
	0xd742, { 0xE8, 0x81, 0x87 },
	0xd743, { 0xE8, 0x81, 0x83 },
	0xd744, { 0xE8, 0x81, 0x88 },
	0xd745, { 0xE8, 0x84, 0x98 },
	0xd746, { 0xE8, 0x84, 0xA5 },
	0xd747, { 0xE8, 0x84, 0x99 },
	0xd748, { 0xE8, 0x84, 0x9B },
	0xd749, { 0xE8, 0x84, 0xAD },
	0xd74a, { 0xE8, 0x84, 0x9F },
	0xd74b, { 0xE8, 0x84, 0xAC },
	0xd74c, { 0xE8, 0x84, 0x9E },
	0xd74d, { 0xE8, 0x84, 0xA1 },
	0xd74e, { 0xE8, 0x84, 0x95 },
	0xd74f, { 0xE8, 0x84, 0xA7 },
	0xd750, { 0xE8, 0x84, 0x9D },
	0xd751, { 0xE8, 0x84, 0xA2 },
	0xd752, { 0xE8, 0x88, 0x91 },
	0xd753, { 0xE8, 0x88, 0xB8 },
	0xd754, { 0xE8, 0x88, 0xB3 },
	0xd755, { 0xE8, 0x88, 0xBA },
	0xd756, { 0xE8, 0x88, 0xB4 },
	0xd757, { 0xE8, 0x88, 0xB2 },
	0xd758, { 0xE8, 0x89, 0xB4 },
	0xd759, { 0xE8, 0x8E, 0x90 },
	0xd75a, { 0xE8, 0x8E, 0xA3 },
	0xd75b, { 0xE8, 0x8E, 0xA8 },
	0xd75c, { 0xE8, 0x8E, 0x8D },
	0xd75d, { 0xE8, 0x8D, 0xBA },
	0xd75e, { 0xE8, 0x8D, 0xB3 },
	0xd75f, { 0xE8, 0x8E, 0xA4 },
	0xd760, { 0xE8, 0x8D, 0xB4 },
	0xd761, { 0xE8, 0x8E, 0x8F },
	0xd762, { 0xE8, 0x8E, 0x81 },
	0xd763, { 0xE8, 0x8E, 0x95 },
	0xd764, { 0xE8, 0x8E, 0x99 },
	0xd765, { 0xE8, 0x8D, 0xB5 },
	0xd766, { 0xE8, 0x8E, 0x94 },
	0xd767, { 0xE8, 0x8E, 0xA9 },
	0xd768, { 0xE8, 0x8D, 0xBD },
	0xd769, { 0xE8, 0x8E, 0x83 },
	0xd76a, { 0xE8, 0x8E, 0x8C },
	0xd76b, { 0xE8, 0x8E, 0x9D },
	0xd76c, { 0xE8, 0x8E, 0x9B },
	0xd76d, { 0xE8, 0x8E, 0xAA },
	0xd76e, { 0xE8, 0x8E, 0x8B },
	0xd76f, { 0xE8, 0x8D, 0xBE },
	0xd770, { 0xE8, 0x8E, 0xA5 },
	0xd771, { 0xE8, 0x8E, 0xAF },
	0xd772, { 0xE8, 0x8E, 0x88 },
	0xd773, { 0xE8, 0x8E, 0x97 },
	0xd774, { 0xE8, 0x8E, 0xB0 },
	0xd775, { 0xE8, 0x8D, 0xBF },
	0xd776, { 0xE8, 0x8E, 0xA6 },
	0xd777, { 0xE8, 0x8E, 0x87 },
	0xd778, { 0xE8, 0x8E, 0xAE },
	0xd779, { 0xE8, 0x8D, 0xB6 },
	0xd77a, { 0xE8, 0x8E, 0x9A },
	0xd77b, { 0xE8, 0x99, 0x99 },
	0xd77c, { 0xE8, 0x99, 0x96 },
	0xd77d, { 0xE8, 0x9A, 0xBF },
	0xd77e, { 0xE8, 0x9A, 0xB7 },
	0xd7a1, { 0xE8, 0x9B, 0x82 },
	0xd7a2, { 0xE8, 0x9B, 0x81 },
	0xd7a3, { 0xE8, 0x9B, 0x85 },
	0xd7a4, { 0xE8, 0x9A, 0xBA },
	0xd7a5, { 0xE8, 0x9A, 0xB0 },
	0xd7a6, { 0xE8, 0x9B, 0x88 },
	0xd7a7, { 0xE8, 0x9A, 0xB9 },
	0xd7a8, { 0xE8, 0x9A, 0xB3 },
	0xd7a9, { 0xE8, 0x9A, 0xB8 },
	0xd7aa, { 0xE8, 0x9B, 0x8C },
	0xd7ab, { 0xE8, 0x9A, 0xB4 },
	0xd7ac, { 0xE8, 0x9A, 0xBB },
	0xd7ad, { 0xE8, 0x9A, 0xBC },
	0xd7ae, { 0xE8, 0x9B, 0x83 },
	0xd7af, { 0xE8, 0x9A, 0xBD },
	0xd7b0, { 0xE8, 0x9A, 0xBE },
	0xd7b1, { 0xE8, 0xA1, 0x92 },
	0xd7b2, { 0xE8, 0xA2, 0x89 },
	0xd7b3, { 0xE8, 0xA2, 0x95 },
	0xd7b4, { 0xE8, 0xA2, 0xA8 },
	0xd7b5, { 0xE8, 0xA2, 0xA2 },
	0xd7b6, { 0xE8, 0xA2, 0xAA },
	0xd7b7, { 0xE8, 0xA2, 0x9A },
	0xd7b8, { 0xE8, 0xA2, 0x91 },
	0xd7b9, { 0xE8, 0xA2, 0xA1 },
	0xd7ba, { 0xE8, 0xA2, 0x9F },
	0xd7bb, { 0xE8, 0xA2, 0x98 },
	0xd7bc, { 0xE8, 0xA2, 0xA7 },
	0xd7bd, { 0xE8, 0xA2, 0x99 },
	0xd7be, { 0xE8, 0xA2, 0x9B },
	0xd7bf, { 0xE8, 0xA2, 0x97 },
	0xd7c0, { 0xE8, 0xA2, 0xA4 },
	0xd7c1, { 0xE8, 0xA2, 0xAC },
	0xd7c2, { 0xE8, 0xA2, 0x8C },
	0xd7c3, { 0xE8, 0xA2, 0x93 },
	0xd7c4, { 0xE8, 0xA2, 0x8E },
	0xd7c5, { 0xE8, 0xA6, 0x82 },
	0xd7c6, { 0xE8, 0xA7, 0x96 },
	0xd7c7, { 0xE8, 0xA7, 0x99 },
	0xd7c8, { 0xE8, 0xA7, 0x95 },
	0xd7c9, { 0xE8, 0xA8, 0xB0 },
	0xd7ca, { 0xE8, 0xA8, 0xA7 },
	0xd7cb, { 0xE8, 0xA8, 0xAC },
	0xd7cc, { 0xE8, 0xA8, 0x9E },
	0xd7cd, { 0xE8, 0xB0, 0xB9 },
	0xd7ce, { 0xE8, 0xB0, 0xBB },
	0xd7cf, { 0xE8, 0xB1, 0x9C },
	0xd7d0, { 0xE8, 0xB1, 0x9D },
	0xd7d1, { 0xE8, 0xB1, 0xBD },
	0xd7d2, { 0xE8, 0xB2, 0xA5 },
	0xd7d3, { 0xE8, 0xB5, 0xBD },
	0xd7d4, { 0xE8, 0xB5, 0xBB },
	0xd7d5, { 0xE8, 0xB5, 0xB9 },
	0xd7d6, { 0xE8, 0xB6, 0xBC },
	0xd7d7, { 0xE8, 0xB7, 0x82 },
	0xd7d8, { 0xE8, 0xB6, 0xB9 },
	0xd7d9, { 0xE8, 0xB6, 0xBF },
	0xd7da, { 0xE8, 0xB7, 0x81 },
	0xd7db, { 0xE8, 0xBB, 0x98 },
	0xd7dc, { 0xE8, 0xBB, 0x9E },
	0xd7dd, { 0xE8, 0xBB, 0x9D },
	0xd7de, { 0xE8, 0xBB, 0x9C },
	0xd7df, { 0xE8, 0xBB, 0x97 },
	0xd7e0, { 0xE8, 0xBB, 0xA0 },
	0xd7e1, { 0xE8, 0xBB, 0xA1 },
	0xd7e2, { 0xE9, 0x80, 0xA4 },
	0xd7e3, { 0xE9, 0x80, 0x8B },
	0xd7e4, { 0xE9, 0x80, 0x91 },
	0xd7e5, { 0xE9, 0x80, 0x9C },
	0xd7e6, { 0xE9, 0x80, 0x8C },
	0xd7e7, { 0xE9, 0x80, 0xA1 },
	0xd7e8, { 0xE9, 0x83, 0xAF },
	0xd7e9, { 0xE9, 0x83, 0xAA },
	0xd7ea, { 0xE9, 0x83, 0xB0 },
	0xd7eb, { 0xE9, 0x83, 0xB4 },
	0xd7ec, { 0xE9, 0x83, 0xB2 },
	0xd7ed, { 0xE9, 0x83, 0xB3 },
	0xd7ee, { 0xE9, 0x83, 0x94 },
	0xd7ef, { 0xE9, 0x83, 0xAB },
	0xd7f0, { 0xE9, 0x83, 0xAC },
	0xd7f1, { 0xE9, 0x83, 0xA9 },
	0xd7f2, { 0xE9, 0x85, 0x96 },
	0xd7f3, { 0xE9, 0x85, 0x98 },
	0xd7f4, { 0xE9, 0x85, 0x9A },
	0xd7f5, { 0xE9, 0x85, 0x93 },
	0xd7f6, { 0xE9, 0x85, 0x95 },
	0xd7f7, { 0xE9, 0x87, 0xAC },
	0xd7f8, { 0xE9, 0x87, 0xB4 },
	0xd7f9, { 0xE9, 0x87, 0xB1 },
	0xd7fa, { 0xE9, 0x87, 0xB3 },
	0xd7fb, { 0xE9, 0x87, 0xB8 },
	0xd7fc, { 0xE9, 0x87, 0xA4 },
	0xd7fd, { 0xE9, 0x87, 0xB9 },
	0xd7fe, { 0xE9, 0x87, 0xAA },
	0xd840, { 0xE9, 0x87, 0xAB },
	0xd841, { 0xE9, 0x87, 0xB7 },
	0xd842, { 0xE9, 0x87, 0xA8 },
	0xd843, { 0xE9, 0x87, 0xAE },
	0xd844, { 0xE9, 0x95, 0xBA },
	0xd845, { 0xE9, 0x96, 0x86 },
	0xd846, { 0xE9, 0x96, 0x88 },
	0xd847, { 0xE9, 0x99, 0xBC },
	0xd848, { 0xE9, 0x99, 0xAD },
	0xd849, { 0xE9, 0x99, 0xAB },
	0xd84a, { 0xE9, 0x99, 0xB1 },
	0xd84b, { 0xE9, 0x99, 0xAF },
	0xd84c, { 0xE9, 0x9A, 0xBF },
	0xd84d, { 0xE9, 0x9D, 0xAA },
	0xd84e, { 0xE9, 0xA0, 0x84 },
	0xd84f, { 0xE9, 0xA3, 0xA5 },
	0xd850, { 0xE9, 0xA6, 0x97 },
	0xd851, { 0xE5, 0x82, 0x9B },
	0xd852, { 0xE5, 0x82, 0x95 },
	0xd853, { 0xE5, 0x82, 0x94 },
	0xd854, { 0xE5, 0x82, 0x9E },
	0xd855, { 0xE5, 0x82, 0x8B },
	0xd856, { 0xE5, 0x82, 0xA3 },
	0xd857, { 0xE5, 0x82, 0x83 },
	0xd858, { 0xE5, 0x82, 0x8C },
	0xd859, { 0xE5, 0x82, 0x8E },
	0xd85a, { 0xE5, 0x82, 0x9D },
	0xd85b, { 0xE5, 0x81, 0xA8 },
	0xd85c, { 0xE5, 0x82, 0x9C },
	0xd85d, { 0xE5, 0x82, 0x92 },
	0xd85e, { 0xE5, 0x82, 0x82 },
	0xd85f, { 0xE5, 0x82, 0x87 },
	0xd860, { 0xE5, 0x85, 0x9F },
	0xd861, { 0xE5, 0x87, 0x94 },
	0xd862, { 0xE5, 0x8C, 0x92 },
	0xd863, { 0xE5, 0x8C, 0x91 },
	0xd864, { 0xE5, 0x8E, 0xA4 },
	0xd865, { 0xE5, 0x8E, 0xA7 },
	0xd866, { 0xE5, 0x96, 0x91 },
	0xd867, { 0xE5, 0x96, 0xA8 },
	0xd868, { 0xE5, 0x96, 0xA5 },
	0xd869, { 0xE5, 0x96, 0xAD },
	0xd86a, { 0xE5, 0x95, 0xB7 },
	0xd86b, { 0xE5, 0x99, 0x85 },
	0xd86c, { 0xE5, 0x96, 0xA2 },
	0xd86d, { 0xE5, 0x96, 0x93 },
	0xd86e, { 0xE5, 0x96, 0x88 },
	0xd86f, { 0xE5, 0x96, 0x8F },
	0xd870, { 0xE5, 0x96, 0xB5 },
	0xd871, { 0xE5, 0x96, 0x81 },
	0xd872, { 0xE5, 0x96, 0xA3 },
	0xd873, { 0xE5, 0x96, 0x92 },
	0xd874, { 0xE5, 0x96, 0xA4 },
	0xd875, { 0xE5, 0x95, 0xBD },
	0xd876, { 0xE5, 0x96, 0x8C },
	0xd877, { 0xE5, 0x96, 0xA6 },
	0xd878, { 0xE5, 0x95, 0xBF },
	0xd879, { 0xE5, 0x96, 0x95 },
	0xd87a, { 0xE5, 0x96, 0xA1 },
	0xd87b, { 0xE5, 0x96, 0x8E },
	0xd87c, { 0xE5, 0x9C, 0x8C },
	0xd87d, { 0xE5, 0xA0, 0xA9 },
	0xd87e, { 0xE5, 0xA0, 0xB7 },
	0xd8a1, { 0xE5, 0xA0, 0x99 },
	0xd8a2, { 0xE5, 0xA0, 0x9E },
	0xd8a3, { 0xE5, 0xA0, 0xA7 },
	0xd8a4, { 0xE5, 0xA0, 0xA3 },
	0xd8a5, { 0xE5, 0xA0, 0xA8 },
	0xd8a6, { 0xE5, 0x9F, 0xB5 },
	0xd8a7, { 0xE5, 0xA1, 0x88 },
	0xd8a8, { 0xE5, 0xA0, 0xA5 },
	0xd8a9, { 0xE5, 0xA0, 0x9C },
	0xd8aa, { 0xE5, 0xA0, 0x9B },
	0xd8ab, { 0xE5, 0xA0, 0xB3 },
	0xd8ac, { 0xE5, 0xA0, 0xBF },
	0xd8ad, { 0xE5, 0xA0, 0xB6 },
	0xd8ae, { 0xE5, 0xA0, 0xAE },
	0xd8af, { 0xE5, 0xA0, 0xB9 },
	0xd8b0, { 0xE5, 0xA0, 0xB8 },
	0xd8b1, { 0xE5, 0xA0, 0xAD },
	0xd8b2, { 0xE5, 0xA0, 0xAC },
	0xd8b3, { 0xE5, 0xA0, 0xBB },
	0xd8b4, { 0xE5, 0xA5, 0xA1 },
	0xd8b5, { 0xE5, 0xAA, 0xAF },
	0xd8b6, { 0xE5, 0xAA, 0x94 },
	0xd8b7, { 0xE5, 0xAA, 0x9F },
	0xd8b8, { 0xE5, 0xA9, 0xBA },
	0xd8b9, { 0xE5, 0xAA, 0xA2 },
	0xd8ba, { 0xE5, 0xAA, 0x9E },
	0xd8bb, { 0xE5, 0xA9, 0xB8 },
	0xd8bc, { 0xE5, 0xAA, 0xA6 },
	0xd8bd, { 0xE5, 0xA9, 0xBC },
	0xd8be, { 0xE5, 0xAA, 0xA5 },
	0xd8bf, { 0xE5, 0xAA, 0xAC },
	0xd8c0, { 0xE5, 0xAA, 0x95 },
	0xd8c1, { 0xE5, 0xAA, 0xAE },
	0xd8c2, { 0xE5, 0xA8, 0xB7 },
	0xd8c3, { 0xE5, 0xAA, 0x84 },
	0xd8c4, { 0xE5, 0xAA, 0x8A },
	0xd8c5, { 0xE5, 0xAA, 0x97 },
	0xd8c6, { 0xE5, 0xAA, 0x83 },
	0xd8c7, { 0xE5, 0xAA, 0x8B },
	0xd8c8, { 0xE5, 0xAA, 0xA9 },
	0xd8c9, { 0xE5, 0xA9, 0xBB },
	0xd8ca, { 0xE5, 0xA9, 0xBD },
	0xd8cb, { 0xE5, 0xAA, 0x8C },
	0xd8cc, { 0xE5, 0xAA, 0x9C },
	0xd8cd, { 0xE5, 0xAA, 0x8F },
	0xd8ce, { 0xE5, 0xAA, 0x93 },
	0xd8cf, { 0xE5, 0xAA, 0x9D },
	0xd8d0, { 0xE5, 0xAF, 0xAA },
	0xd8d1, { 0xE5, 0xAF, 0x8D },
	0xd8d2, { 0xE5, 0xAF, 0x8B },
	0xd8d3, { 0xE5, 0xAF, 0x94 },
	0xd8d4, { 0xE5, 0xAF, 0x91 },
	0xd8d5, { 0xE5, 0xAF, 0x8A },
	0xd8d6, { 0xE5, 0xAF, 0x8E },
	0xd8d7, { 0xE5, 0xB0, 0x8C },
	0xd8d8, { 0xE5, 0xB0, 0xB0 },
	0xd8d9, { 0xE5, 0xB4, 0xB7 },
	0xd8da, { 0xE5, 0xB5, 0x83 },
	0xd8db, { 0xE5, 0xB5, 0xAB },
	0xd8dc, { 0xE5, 0xB5, 0x81 },
	0xd8dd, { 0xE5, 0xB5, 0x8B },
	0xd8de, { 0xE5, 0xB4, 0xBF },
	0xd8df, { 0xE5, 0xB4, 0xB5 },
	0xd8e0, { 0xE5, 0xB5, 0x91 },
	0xd8e1, { 0xE5, 0xB5, 0x8E },
	0xd8e2, { 0xE5, 0xB5, 0x95 },
	0xd8e3, { 0xE5, 0xB4, 0xB3 },
	0xd8e4, { 0xE5, 0xB4, 0xBA },
	0xd8e5, { 0xE5, 0xB5, 0x92 },
	0xd8e6, { 0xE5, 0xB4, 0xBD },
	0xd8e7, { 0xE5, 0xB4, 0xB1 },
	0xd8e8, { 0xE5, 0xB5, 0x99 },
	0xd8e9, { 0xE5, 0xB5, 0x82 },
	0xd8ea, { 0xE5, 0xB4, 0xB9 },
	0xd8eb, { 0xE5, 0xB5, 0x89 },
	0xd8ec, { 0xE5, 0xB4, 0xB8 },
	0xd8ed, { 0xE5, 0xB4, 0xBC },
	0xd8ee, { 0xE5, 0xB4, 0xB2 },
	0xd8ef, { 0xE5, 0xB4, 0xB6 },
	0xd8f0, { 0xE5, 0xB5, 0x80 },
	0xd8f1, { 0xE5, 0xB5, 0x85 },
	0xd8f2, { 0xE5, 0xB9, 0x84 },
	0xd8f3, { 0xE5, 0xB9, 0x81 },
	0xd8f4, { 0xE5, 0xBD, 0x98 },
	0xd8f5, { 0xE5, 0xBE, 0xA6 },
	0xd8f6, { 0xE5, 0xBE, 0xA5 },
	0xd8f7, { 0xE5, 0xBE, 0xAB },
	0xd8f8, { 0xE6, 0x83, 0x89 },
	0xd8f9, { 0xE6, 0x82, 0xB9 },
	0xd8fa, { 0xE6, 0x83, 0x8C },
	0xd8fb, { 0xE6, 0x83, 0xA2 },
	0xd8fc, { 0xE6, 0x83, 0x8E },
	0xd8fd, { 0xE6, 0x83, 0x84 },
	0xd8fe, { 0xE6, 0x84, 0x94 },
	0xd940, { 0xE6, 0x83, 0xB2 },
	0xd941, { 0xE6, 0x84, 0x8A },
	0xd942, { 0xE6, 0x84, 0x96 },
	0xd943, { 0xE6, 0x84, 0x85 },
	0xd944, { 0xE6, 0x83, 0xB5 },
	0xd945, { 0xE6, 0x84, 0x93 },
	0xd946, { 0xE6, 0x83, 0xB8 },
	0xd947, { 0xE6, 0x83, 0xBC },
	0xd948, { 0xE6, 0x83, 0xBE },
	0xd949, { 0xE6, 0x83, 0x81 },
	0xd94a, { 0xE6, 0x84, 0x83 },
	0xd94b, { 0xE6, 0x84, 0x98 },
	0xd94c, { 0xE6, 0x84, 0x9D },
	0xd94d, { 0xE6, 0x84, 0x90 },
	0xd94e, { 0xE6, 0x83, 0xBF },
	0xd94f, { 0xE6, 0x84, 0x84 },
	0xd950, { 0xE6, 0x84, 0x8B },
	0xd951, { 0xE6, 0x89, 0x8A },
	0xd952, { 0xE6, 0x8E, 0x94 },
	0xd953, { 0xE6, 0x8E, 0xB1 },
	0xd954, { 0xE6, 0x8E, 0xB0 },
	0xd955, { 0xE6, 0x8F, 0x8E },
	0xd956, { 0xE6, 0x8F, 0xA5 },
	0xd957, { 0xE6, 0x8F, 0xA8 },
	0xd958, { 0xE6, 0x8F, 0xAF },
	0xd959, { 0xE6, 0x8F, 0x83 },
	0xd95a, { 0xE6, 0x92, 0x9D },
	0xd95b, { 0xE6, 0x8F, 0xB3 },
	0xd95c, { 0xE6, 0x8F, 0x8A },
	0xd95d, { 0xE6, 0x8F, 0xA0 },
	0xd95e, { 0xE6, 0x8F, 0xB6 },
	0xd95f, { 0xE6, 0x8F, 0x95 },
	0xd960, { 0xE6, 0x8F, 0xB2 },
	0xd961, { 0xE6, 0x8F, 0xB5 },
	0xd962, { 0xE6, 0x91, 0xA1 },
	0xd963, { 0xE6, 0x8F, 0x9F },
	0xd964, { 0xE6, 0x8E, 0xBE },
	0xd965, { 0xE6, 0x8F, 0x9D },
	0xd966, { 0xE6, 0x8F, 0x9C },
	0xd967, { 0xE6, 0x8F, 0x84 },
	0xd968, { 0xE6, 0x8F, 0x98 },
	0xd969, { 0xE6, 0x8F, 0x93 },
	0xd96a, { 0xE6, 0x8F, 0x82 },
	0xd96b, { 0xE6, 0x8F, 0x87 },
	0xd96c, { 0xE6, 0x8F, 0x8C },
	0xd96d, { 0xE6, 0x8F, 0x8B },
	0xd96e, { 0xE6, 0x8F, 0x88 },
	0xd96f, { 0xE6, 0x8F, 0xB0 },
	0xd970, { 0xE6, 0x8F, 0x97 },
	0xd971, { 0xE6, 0x8F, 0x99 },
	0xd972, { 0xE6, 0x94, 0xB2 },
	0xd973, { 0xE6, 0x95, 0xA7 },
	0xd974, { 0xE6, 0x95, 0xAA },
	0xd975, { 0xE6, 0x95, 0xA4 },
	0xd976, { 0xE6, 0x95, 0x9C },
	0xd977, { 0xE6, 0x95, 0xA8 },
	0xd978, { 0xE6, 0x95, 0xA5 },
	0xd979, { 0xE6, 0x96, 0x8C },
	0xd97a, { 0xE6, 0x96, 0x9D },
	0xd97b, { 0xE6, 0x96, 0x9E },
	0xd97c, { 0xE6, 0x96, 0xAE },
	0xd97d, { 0xE6, 0x97, 0x90 },
	0xd97e, { 0xE6, 0x97, 0x92 },
	0xd9a1, { 0xE6, 0x99, 0xBC },
	0xd9a2, { 0xE6, 0x99, 0xAC },
	0xd9a3, { 0xE6, 0x99, 0xBB },
	0xd9a4, { 0xE6, 0x9A, 0x80 },
	0xd9a5, { 0xE6, 0x99, 0xB1 },
	0xd9a6, { 0xE6, 0x99, 0xB9 },
	0xd9a7, { 0xE6, 0x99, 0xAA },
	0xd9a8, { 0xE6, 0x99, 0xB2 },
	0xd9a9, { 0xE6, 0x9C, 0x81 },
	0xd9aa, { 0xE6, 0xA4, 0x8C },
	0xd9ab, { 0xE6, 0xA3, 0x93 },
	0xd9ac, { 0xE6, 0xA4, 0x84 },
	0xd9ad, { 0xE6, 0xA3, 0x9C },
	0xd9ae, { 0xE6, 0xA4, 0xAA },
	0xd9af, { 0xE6, 0xA3, 0xAC },
	0xd9b0, { 0xE6, 0xA3, 0xAA },
	0xd9b1, { 0xE6, 0xA3, 0xB1 },
	0xd9b2, { 0xE6, 0xA4, 0x8F },
	0xd9b3, { 0xE6, 0xA3, 0x96 },
	0xd9b4, { 0xE6, 0xA3, 0xB7 },
	0xd9b5, { 0xE6, 0xA3, 0xAB },
	0xd9b6, { 0xE6, 0xA3, 0xA4 },
	0xd9b7, { 0xE6, 0xA3, 0xB6 },
	0xd9b8, { 0xE6, 0xA4, 0x93 },
	0xd9b9, { 0xE6, 0xA4, 0x90 },
	0xd9ba, { 0xE6, 0xA3, 0xB3 },
	0xd9bb, { 0xE6, 0xA3, 0xA1 },
	0xd9bc, { 0xE6, 0xA4, 0x87 },
	0xd9bd, { 0xE6, 0xA3, 0x8C },
	0xd9be, { 0xE6, 0xA4, 0x88 },
	0xd9bf, { 0xE6, 0xA5, 0xB0 },
	0xd9c0, { 0xE6, 0xA2, 0xB4 },
	0xd9c1, { 0xE6, 0xA4, 0x91 },
	0xd9c2, { 0xE6, 0xA3, 0xAF },
	0xd9c3, { 0xE6, 0xA3, 0x86 },
	0xd9c4, { 0xE6, 0xA4, 0x94 },
	0xd9c5, { 0xE6, 0xA3, 0xB8 },
	0xd9c6, { 0xE6, 0xA3, 0x90 },
	0xd9c7, { 0xE6, 0xA3, 0xBD },
	0xd9c8, { 0xE6, 0xA3, 0xBC },
	0xd9c9, { 0xE6, 0xA3, 0xA8 },
	0xd9ca, { 0xE6, 0xA4, 0x8B },
	0xd9cb, { 0xE6, 0xA4, 0x8A },
	0xd9cc, { 0xE6, 0xA4, 0x97 },
	0xd9cd, { 0xE6, 0xA3, 0x8E },
	0xd9ce, { 0xE6, 0xA3, 0x88 },
	0xd9cf, { 0xE6, 0xA3, 0x9D },
	0xd9d0, { 0xE6, 0xA3, 0x9E },
	0xd9d1, { 0xE6, 0xA3, 0xA6 },
	0xd9d2, { 0xE6, 0xA3, 0xB4 },
	0xd9d3, { 0xE6, 0xA3, 0x91 },
	0xd9d4, { 0xE6, 0xA4, 0x86 },
	0xd9d5, { 0xE6, 0xA3, 0x94 },
	0xd9d6, { 0xE6, 0xA3, 0xA9 },
	0xd9d7, { 0xE6, 0xA4, 0x95 },
	0xd9d8, { 0xE6, 0xA4, 0xA5 },
	0xd9d9, { 0xE6, 0xA3, 0x87 },
	0xd9da, { 0xE6, 0xAC, 0xB9 },
	0xd9db, { 0xE6, 0xAC, 0xBB },
	0xd9dc, { 0xE6, 0xAC, 0xBF },
	0xd9dd, { 0xE6, 0xAC, 0xBC },
	0xd9de, { 0xE6, 0xAE, 0x94 },
	0xd9df, { 0xE6, 0xAE, 0x97 },
	0xd9e0, { 0xE6, 0xAE, 0x99 },
	0xd9e1, { 0xE6, 0xAE, 0x95 },
	0xd9e2, { 0xE6, 0xAE, 0xBD },
	0xd9e3, { 0xE6, 0xAF, 0xB0 },
	0xd9e4, { 0xE6, 0xAF, 0xB2 },
	0xd9e5, { 0xE6, 0xAF, 0xB3 },
	0xd9e6, { 0xE6, 0xB0, 0xB0 },
	0xd9e7, { 0xE6, 0xB7, 0xBC },
	0xd9e8, { 0xE6, 0xB9, 0x86 },
	0xd9e9, { 0xE6, 0xB9, 0x87 },
	0xd9ea, { 0xE6, 0xB8, 0x9F },
	0xd9eb, { 0xE6, 0xB9, 0x89 },
	0xd9ec, { 0xE6, 0xBA, 0x88 },
	0xd9ed, { 0xE6, 0xB8, 0xBC },
	0xd9ee, { 0xE6, 0xB8, 0xBD },
	0xd9ef, { 0xE6, 0xB9, 0x85 },
	0xd9f0, { 0xE6, 0xB9, 0xA2 },
	0xd9f1, { 0xE6, 0xB8, 0xAB },
	0xd9f2, { 0xE6, 0xB8, 0xBF },
	0xd9f3, { 0xE6, 0xB9, 0x81 },
	0xd9f4, { 0xE6, 0xB9, 0x9D },
	0xd9f5, { 0xE6, 0xB9, 0xB3 },
	0xd9f6, { 0xE6, 0xB8, 0x9C },
	0xd9f7, { 0xE6, 0xB8, 0xB3 },
	0xd9f8, { 0xE6, 0xB9, 0x8B },
	0xd9f9, { 0xE6, 0xB9, 0x80 },
	0xd9fa, { 0xE6, 0xB9, 0x91 },
	0xd9fb, { 0xE6, 0xB8, 0xBB },
	0xd9fc, { 0xE6, 0xB8, 0x83 },
	0xd9fd, { 0xE6, 0xB8, 0xAE },
	0xd9fe, { 0xE6, 0xB9, 0x9E },
	0xda40, { 0xE6, 0xB9, 0xA8 },
	0xda41, { 0xE6, 0xB9, 0x9C },
	0xda42, { 0xE6, 0xB9, 0xA1 },
	0xda43, { 0xE6, 0xB8, 0xB1 },
	0xda44, { 0xE6, 0xB8, 0xA8 },
	0xda45, { 0xE6, 0xB9, 0xA0 },
	0xda46, { 0xE6, 0xB9, 0xB1 },
	0xda47, { 0xE6, 0xB9, 0xAB },
	0xda48, { 0xE6, 0xB8, 0xB9 },
	0xda49, { 0xE6, 0xB8, 0xA2 },
	0xda4a, { 0xE6, 0xB8, 0xB0 },
	0xda4b, { 0xE6, 0xB9, 0x93 },
	0xda4c, { 0xE6, 0xB9, 0xA5 },
	0xda4d, { 0xE6, 0xB8, 0xA7 },
	0xda4e, { 0xE6, 0xB9, 0xB8 },
	0xda4f, { 0xE6, 0xB9, 0xA4 },
	0xda50, { 0xE6, 0xB9, 0xB7 },
	0xda51, { 0xE6, 0xB9, 0x95 },
	0xda52, { 0xE6, 0xB9, 0xB9 },
	0xda53, { 0xE6, 0xB9, 0x92 },
	0xda54, { 0xE6, 0xB9, 0xA6 },
	0xda55, { 0xE6, 0xB8, 0xB5 },
	0xda56, { 0xE6, 0xB8, 0xB6 },
	0xda57, { 0xE6, 0xB9, 0x9A },
	0xda58, { 0xE7, 0x84, 0xA0 },
	0xda59, { 0xE7, 0x84, 0x9E },
	0xda5a, { 0xE7, 0x84, 0xAF },
	0xda5b, { 0xE7, 0x83, 0xBB },
	0xda5c, { 0xE7, 0x84, 0xAE },
	0xda5d, { 0xE7, 0x84, 0xB1 },
	0xda5e, { 0xE7, 0x84, 0xA3 },
	0xda5f, { 0xE7, 0x84, 0xA5 },
	0xda60, { 0xE7, 0x84, 0xA2 },
	0xda61, { 0xE7, 0x84, 0xB2 },
	0xda62, { 0xE7, 0x84, 0x9F },
	0xda63, { 0xE7, 0x84, 0xA8 },
	0xda64, { 0xE7, 0x84, 0xBA },
	0xda65, { 0xE7, 0x84, 0x9B },
	0xda66, { 0xE7, 0x89, 0x8B },
	0xda67, { 0xE7, 0x89, 0x9A },
	0xda68, { 0xE7, 0x8A, 0x88 },
	0xda69, { 0xE7, 0x8A, 0x89 },
	0xda6a, { 0xE7, 0x8A, 0x86 },
	0xda6b, { 0xE7, 0x8A, 0x85 },
	0xda6c, { 0xE7, 0x8A, 0x8B },
	0xda6d, { 0xE7, 0x8C, 0x92 },
	0xda6e, { 0xE7, 0x8C, 0x8B },
	0xda6f, { 0xE7, 0x8C, 0xB0 },
	0xda70, { 0xE7, 0x8C, 0xA2 },
	0xda71, { 0xE7, 0x8C, 0xB1 },
	0xda72, { 0xE7, 0x8C, 0xB3 },
	0xda73, { 0xE7, 0x8C, 0xA7 },
	0xda74, { 0xE7, 0x8C, 0xB2 },
	0xda75, { 0xE7, 0x8C, 0xAD },
	0xda76, { 0xE7, 0x8C, 0xA6 },
	0xda77, { 0xE7, 0x8C, 0xA3 },
	0xda78, { 0xE7, 0x8C, 0xB5 },
	0xda79, { 0xE7, 0x8C, 0x8C },
	0xda7a, { 0xE7, 0x90, 0xAE },
	0xda7b, { 0xE7, 0x90, 0xAC },
	0xda7c, { 0xE7, 0x90, 0xB0 },
	0xda7d, { 0xE7, 0x90, 0xAB },
	0xda7e, { 0xE7, 0x90, 0x96 },
	0xdaa1, { 0xE7, 0x90, 0x9A },
	0xdaa2, { 0xE7, 0x90, 0xA1 },
	0xdaa3, { 0xE7, 0x90, 0xAD },
	0xdaa4, { 0xE7, 0x90, 0xB1 },
	0xdaa5, { 0xE7, 0x90, 0xA4 },
	0xdaa6, { 0xE7, 0x90, 0xA3 },
	0xdaa7, { 0xE7, 0x90, 0x9D },
	0xdaa8, { 0xE7, 0x90, 0xA9 },
	0xdaa9, { 0xE7, 0x90, 0xA0 },
	0xdaaa, { 0xE7, 0x90, 0xB2 },
	0xdaab, { 0xE7, 0x93, 0xBB },
	0xdaac, { 0xE7, 0x94, 0xAF },
	0xdaad, { 0xE7, 0x95, 0xAF },
	0xdaae, { 0xE7, 0x95, 0xAC },
	0xdaaf, { 0xE7, 0x97, 0xA7 },
	0xdab0, { 0xE7, 0x97, 0x9A },
	0xdab1, { 0xE7, 0x97, 0xA1 },
	0xdab2, { 0xE7, 0x97, 0xA6 },
	0xdab3, { 0xE7, 0x97, 0x9D },
	0xdab4, { 0xE7, 0x97, 0x9F },
	0xdab5, { 0xE7, 0x97, 0xA4 },
	0xdab6, { 0xE7, 0x97, 0x97 },
	0xdab7, { 0xE7, 0x9A, 0x95 },
	0xdab8, { 0xE7, 0x9A, 0x92 },
	0xdab9, { 0xE7, 0x9B, 0x9A },
	0xdaba, { 0xE7, 0x9D, 0x86 },
	0xdabb, { 0xE7, 0x9D, 0x87 },
	0xdabc, { 0xE7, 0x9D, 0x84 },
	0xdabd, { 0xE7, 0x9D, 0x8D },
	0xdabe, { 0xE7, 0x9D, 0x85 },
	0xdabf, { 0xE7, 0x9D, 0x8A },
	0xdac0, { 0xE7, 0x9D, 0x8E },
	0xdac1, { 0xE7, 0x9D, 0x8B },
	0xdac2, { 0xE7, 0x9D, 0x8C },
	0xdac3, { 0xE7, 0x9F, 0x9E },
	0xdac4, { 0xE7, 0x9F, 0xAC },
	0xdac5, { 0xE7, 0xA1, 0xA0 },
	0xdac6, { 0xE7, 0xA1, 0xA4 },
	0xdac7, { 0xE7, 0xA1, 0xA5 },
	0xdac8, { 0xE7, 0xA1, 0x9C },
	0xdac9, { 0xE7, 0xA1, 0xAD },
	0xdaca, { 0xE7, 0xA1, 0xB1 },
	0xdacb, { 0xE7, 0xA1, 0xAA },
	0xdacc, { 0xE7, 0xA1, 0xAE },
	0xdacd, { 0xE7, 0xA1, 0xB0 },
	0xdace, { 0xE7, 0xA1, 0xA9 },
	0xdacf, { 0xE7, 0xA1, 0xA8 },
	0xdad0, { 0xE7, 0xA1, 0x9E },
	0xdad1, { 0xE7, 0xA1, 0xA2 },
	0xdad2, { 0xE7, 0xA5, 0xB4 },
	0xdad3, { 0xE7, 0xA5, 0xB3 },
	0xdad4, { 0xE7, 0xA5, 0xB2 },
	0xdad5, { 0xE7, 0xA5, 0xB0 },
	0xdad6, { 0xE7, 0xA8, 0x82 },
	0xdad7, { 0xE7, 0xA8, 0x8A },
	0xdad8, { 0xE7, 0xA8, 0x83 },
	0xdad9, { 0xE7, 0xA8, 0x8C },
	0xdada, { 0xE7, 0xA8, 0x84 },
	0xdadb, { 0xE7, 0xAA, 0x99 },
	0xdadc, { 0xE7, 0xAB, 0xA6 },
	0xdadd, { 0xE7, 0xAB, 0xA4 },
	0xdade, { 0xE7, 0xAD, 0x8A },
	0xdadf, { 0xE7, 0xAC, 0xBB },
	0xdae0, { 0xE7, 0xAD, 0x84 },
	0xdae1, { 0xE7, 0xAD, 0x88 },
	0xdae2, { 0xE7, 0xAD, 0x8C },
	0xdae3, { 0xE7, 0xAD, 0x8E },
	0xdae4, { 0xE7, 0xAD, 0x80 },
	0xdae5, { 0xE7, 0xAD, 0x98 },
	0xdae6, { 0xE7, 0xAD, 0x85 },
	0xdae7, { 0xE7, 0xB2, 0xA2 },
	0xdae8, { 0xE7, 0xB2, 0x9E },
	0xdae9, { 0xE7, 0xB2, 0xA8 },
	0xdaea, { 0xE7, 0xB2, 0xA1 },
	0xdaeb, { 0xE7, 0xB5, 0x98 },
	0xdaec, { 0xE7, 0xB5, 0xAF },
	0xdaed, { 0xE7, 0xB5, 0xA3 },
	0xdaee, { 0xE7, 0xB5, 0x93 },
	0xdaef, { 0xE7, 0xB5, 0x96 },
	0xdaf0, { 0xE7, 0xB5, 0xA7 },
	0xdaf1, { 0xE7, 0xB5, 0xAA },
	0xdaf2, { 0xE7, 0xB5, 0x8F },
	0xdaf3, { 0xE7, 0xB5, 0xAD },
	0xdaf4, { 0xE7, 0xB5, 0x9C },
	0xdaf5, { 0xE7, 0xB5, 0xAB },
	0xdaf6, { 0xE7, 0xB5, 0x92 },
	0xdaf7, { 0xE7, 0xB5, 0x94 },
	0xdaf8, { 0xE7, 0xB5, 0xA9 },
	0xdaf9, { 0xE7, 0xB5, 0x91 },
	0xdafa, { 0xE7, 0xB5, 0x9F },
	0xdafb, { 0xE7, 0xB5, 0x8E },
	0xdafc, { 0xE7, 0xBC, 0xBE },
	0xdafd, { 0xE7, 0xBC, 0xBF },
	0xdafe, { 0xE7, 0xBD, 0xA5 },
	0xdb40, { 0xE7, 0xBD, 0xA6 },
	0xdb41, { 0xE7, 0xBE, 0xA2 },
	0xdb42, { 0xE7, 0xBE, 0xA0 },
	0xdb43, { 0xE7, 0xBE, 0xA1 },
	0xdb44, { 0xE7, 0xBF, 0x97 },
	0xdb45, { 0xE8, 0x81, 0x91 },
	0xdb46, { 0xE8, 0x81, 0x8F },
	0xdb47, { 0xE8, 0x81, 0x90 },
	0xdb48, { 0xE8, 0x83, 0xBE },
	0xdb49, { 0xE8, 0x83, 0x94 },
	0xdb4a, { 0xE8, 0x85, 0x83 },
	0xdb4b, { 0xE8, 0x85, 0x8A },
	0xdb4c, { 0xE8, 0x85, 0x92 },
	0xdb4d, { 0xE8, 0x85, 0x8F },
	0xdb4e, { 0xE8, 0x85, 0x87 },
	0xdb4f, { 0xE8, 0x84, 0xBD },
	0xdb50, { 0xE8, 0x85, 0x8D },
	0xdb51, { 0xE8, 0x84, 0xBA },
	0xdb52, { 0xE8, 0x87, 0xA6 },
	0xdb53, { 0xE8, 0x87, 0xAE },
	0xdb54, { 0xE8, 0x87, 0xB7 },
	0xdb55, { 0xE8, 0x87, 0xB8 },
	0xdb56, { 0xE8, 0x87, 0xB9 },
	0xdb57, { 0xE8, 0x88, 0x84 },
	0xdb58, { 0xE8, 0x88, 0xBC },
	0xdb59, { 0xE8, 0x88, 0xBD },
	0xdb5a, { 0xE8, 0x88, 0xBF },
	0xdb5b, { 0xE8, 0x89, 0xB5 },
	0xdb5c, { 0xE8, 0x8C, 0xBB },
	0xdb5d, { 0xE8, 0x8F, 0x8F },
	0xdb5e, { 0xE8, 0x8F, 0xB9 },
	0xdb5f, { 0xE8, 0x90, 0xA3 },
	0xdb60, { 0xE8, 0x8F, 0x80 },
	0xdb61, { 0xE8, 0x8F, 0xA8 },
	0xdb62, { 0xE8, 0x90, 0x92 },
	0xdb63, { 0xE8, 0x8F, 0xA7 },
	0xdb64, { 0xE8, 0x8F, 0xA4 },
	0xdb65, { 0xE8, 0x8F, 0xBC },
	0xdb66, { 0xE8, 0x8F, 0xB6 },
	0xdb67, { 0xE8, 0x90, 0x90 },
	0xdb68, { 0xE8, 0x8F, 0x86 },
	0xdb69, { 0xE8, 0x8F, 0x88 },
	0xdb6a, { 0xE8, 0x8F, 0xAB },
	0xdb6b, { 0xE8, 0x8F, 0xA3 },
	0xdb6c, { 0xE8, 0x8E, 0xBF },
	0xdb6d, { 0xE8, 0x90, 0x81 },
	0xdb6e, { 0xE8, 0x8F, 0x9D },
	0xdb6f, { 0xE8, 0x8F, 0xA5 },
	0xdb70, { 0xE8, 0x8F, 0x98 },
	0xdb71, { 0xE8, 0x8F, 0xBF },
	0xdb72, { 0xE8, 0x8F, 0xA1 },
	0xdb73, { 0xE8, 0x8F, 0x8B },
	0xdb74, { 0xE8, 0x8F, 0x8E },
	0xdb75, { 0xE8, 0x8F, 0x96 },
	0xdb76, { 0xE8, 0x8F, 0xB5 },
	0xdb77, { 0xE8, 0x8F, 0x89 },
	0xdb78, { 0xE8, 0x90, 0x89 },
	0xdb79, { 0xE8, 0x90, 0x8F },
	0xdb7a, { 0xE8, 0x8F, 0x9E },
	0xdb7b, { 0xE8, 0x90, 0x91 },
	0xdb7c, { 0xE8, 0x90, 0x86 },
	0xdb7d, { 0xE8, 0x8F, 0x82 },
	0xdb7e, { 0xE8, 0x8F, 0xB3 },
	0xdba1, { 0xE8, 0x8F, 0x95 },
	0xdba2, { 0xE8, 0x8F, 0xBA },
	0xdba3, { 0xE8, 0x8F, 0x87 },
	0xdba4, { 0xE8, 0x8F, 0x91 },
	0xdba5, { 0xE8, 0x8F, 0xAA },
	0xdba6, { 0xE8, 0x90, 0x93 },
	0xdba7, { 0xE8, 0x8F, 0x83 },
	0xdba8, { 0xE8, 0x8F, 0xAC },
	0xdba9, { 0xE8, 0x8F, 0xAE },
	0xdbaa, { 0xE8, 0x8F, 0x84 },
	0xdbab, { 0xE8, 0x8F, 0xBB },
	0xdbac, { 0xE8, 0x8F, 0x97 },
	0xdbad, { 0xE8, 0x8F, 0xA2 },
	0xdbae, { 0xE8, 0x90, 0x9B },
	0xdbaf, { 0xE8, 0x8F, 0x9B },
	0xdbb0, { 0xE8, 0x8F, 0xBE },
	0xdbb1, { 0xE8, 0x9B, 0x98 },
	0xdbb2, { 0xE8, 0x9B, 0xA2 },
	0xdbb3, { 0xE8, 0x9B, 0xA6 },
	0xdbb4, { 0xE8, 0x9B, 0x93 },
	0xdbb5, { 0xE8, 0x9B, 0xA3 },
	0xdbb6, { 0xE8, 0x9B, 0x9A },
	0xdbb7, { 0xE8, 0x9B, 0xAA },
	0xdbb8, { 0xE8, 0x9B, 0x9D },
	0xdbb9, { 0xE8, 0x9B, 0xAB },
	0xdbba, { 0xE8, 0x9B, 0x9C },
	0xdbbb, { 0xE8, 0x9B, 0xAC },
	0xdbbc, { 0xE8, 0x9B, 0xA9 },
	0xdbbd, { 0xE8, 0x9B, 0x97 },
	0xdbbe, { 0xE8, 0x9B, 0xA8 },
	0xdbbf, { 0xE8, 0x9B, 0x91 },
	0xdbc0, { 0xE8, 0xA1, 0x88 },
	0xdbc1, { 0xE8, 0xA1, 0x96 },
	0xdbc2, { 0xE8, 0xA1, 0x95 },
	0xdbc3, { 0xE8, 0xA2, 0xBA },
	0xdbc4, { 0xE8, 0xA3, 0x97 },
	0xdbc5, { 0xE8, 0xA2, 0xB9 },
	0xdbc6, { 0xE8, 0xA2, 0xB8 },
	0xdbc7, { 0xE8, 0xA3, 0x80 },
	0xdbc8, { 0xE8, 0xA2, 0xBE },
	0xdbc9, { 0xE8, 0xA2, 0xB6 },
	0xdbca, { 0xE8, 0xA2, 0xBC },
	0xdbcb, { 0xE8, 0xA2, 0xB7 },
	0xdbcc, { 0xE8, 0xA2, 0xBD },
	0xdbcd, { 0xE8, 0xA2, 0xB2 },
	0xdbce, { 0xE8, 0xA4, 0x81 },
	0xdbcf, { 0xE8, 0xA3, 0x89 },
	0xdbd0, { 0xE8, 0xA6, 0x95 },
	0xdbd1, { 0xE8, 0xA6, 0x98 },
	0xdbd2, { 0xE8, 0xA6, 0x97 },
	0xdbd3, { 0xE8, 0xA7, 0x9D },
	0xdbd4, { 0xE8, 0xA7, 0x9A },
	0xdbd5, { 0xE8, 0xA7, 0x9B },
	0xdbd6, { 0xE8, 0xA9, 0x8E },
	0xdbd7, { 0xE8, 0xA9, 0x8D },
	0xdbd8, { 0xE8, 0xA8, 0xB9 },
	0xdbd9, { 0xE8, 0xA9, 0x99 },
	0xdbda, { 0xE8, 0xA9, 0x80 },
	0xdbdb, { 0xE8, 0xA9, 0x97 },
	0xdbdc, { 0xE8, 0xA9, 0x98 },
	0xdbdd, { 0xE8, 0xA9, 0x84 },
	0xdbde, { 0xE8, 0xA9, 0x85 },
	0xdbdf, { 0xE8, 0xA9, 0x92 },
	0xdbe0, { 0xE8, 0xA9, 0x88 },
	0xdbe1, { 0xE8, 0xA9, 0x91 },
	0xdbe2, { 0xE8, 0xA9, 0x8A },
	0xdbe3, { 0xE8, 0xA9, 0x8C },
	0xdbe4, { 0xE8, 0xA9, 0x8F },
	0xdbe5, { 0xE8, 0xB1, 0x9F },
	0xdbe6, { 0xE8, 0xB2, 0x81 },
	0xdbe7, { 0xE8, 0xB2, 0x80 },
	0xdbe8, { 0xE8, 0xB2, 0xBA },
	0xdbe9, { 0xE8, 0xB2, 0xBE },
	0xdbea, { 0xE8, 0xB2, 0xB0 },
	0xdbeb, { 0xE8, 0xB2, 0xB9 },
	0xdbec, { 0xE8, 0xB2, 0xB5 },
	0xdbed, { 0xE8, 0xB6, 0x84 },
	0xdbee, { 0xE8, 0xB6, 0x80 },
	0xdbef, { 0xE8, 0xB6, 0x89 },
	0xdbf0, { 0xE8, 0xB7, 0x98 },
	0xdbf1, { 0xE8, 0xB7, 0x93 },
	0xdbf2, { 0xE8, 0xB7, 0x8D },
	0xdbf3, { 0xE8, 0xB7, 0x87 },
	0xdbf4, { 0xE8, 0xB7, 0x96 },
	0xdbf5, { 0xE8, 0xB7, 0x9C },
	0xdbf6, { 0xE8, 0xB7, 0x8F },
	0xdbf7, { 0xE8, 0xB7, 0x95 },
	0xdbf8, { 0xE8, 0xB7, 0x99 },
	0xdbf9, { 0xE8, 0xB7, 0x88 },
	0xdbfa, { 0xE8, 0xB7, 0x97 },
	0xdbfb, { 0xE8, 0xB7, 0x85 },
	0xdbfc, { 0xE8, 0xBB, 0xAF },
	0xdbfd, { 0xE8, 0xBB, 0xB7 },
	0xdbfe, { 0xE8, 0xBB, 0xBA },
	0xdc40, { 0xE8, 0xBB, 0xB9 },
	0xdc41, { 0xE8, 0xBB, 0xA6 },
	0xdc42, { 0xE8, 0xBB, 0xAE },
	0xdc43, { 0xE8, 0xBB, 0xA5 },
	0xdc44, { 0xE8, 0xBB, 0xB5 },
	0xdc45, { 0xE8, 0xBB, 0xA7 },
	0xdc46, { 0xE8, 0xBB, 0xA8 },
	0xdc47, { 0xE8, 0xBB, 0xB6 },
	0xdc48, { 0xE8, 0xBB, 0xAB },
	0xdc49, { 0xE8, 0xBB, 0xB1 },
	0xdc4a, { 0xE8, 0xBB, 0xAC },
	0xdc4b, { 0xE8, 0xBB, 0xB4 },
	0xdc4c, { 0xE8, 0xBB, 0xA9 },
	0xdc4d, { 0xE9, 0x80, 0xAD },
	0xdc4e, { 0xE9, 0x80, 0xB4 },
	0xdc4f, { 0xE9, 0x80, 0xAF },
	0xdc50, { 0xE9, 0x84, 0x86 },
	0xdc51, { 0xE9, 0x84, 0xAC },
	0xdc52, { 0xE9, 0x84, 0x84 },
	0xdc53, { 0xE9, 0x83, 0xBF },
	0xdc54, { 0xE9, 0x83, 0xBC },
	0xdc55, { 0xE9, 0x84, 0x88 },
	0xdc56, { 0xE9, 0x83, 0xB9 },
	0xdc57, { 0xE9, 0x83, 0xBB },
	0xdc58, { 0xE9, 0x84, 0x81 },
	0xdc59, { 0xE9, 0x84, 0x80 },
	0xdc5a, { 0xE9, 0x84, 0x87 },
	0xdc5b, { 0xE9, 0x84, 0x85 },
	0xdc5c, { 0xE9, 0x84, 0x83 },
	0xdc5d, { 0xE9, 0x85, 0xA1 },
	0xdc5e, { 0xE9, 0x85, 0xA4 },
	0xdc5f, { 0xE9, 0x85, 0x9F },
	0xdc60, { 0xE9, 0x85, 0xA2 },
	0xdc61, { 0xE9, 0x85, 0xA0 },
	0xdc62, { 0xE9, 0x88, 0x81 },
	0xdc63, { 0xE9, 0x88, 0x8A },
	0xdc64, { 0xE9, 0x88, 0xA5 },
	0xdc65, { 0xE9, 0x88, 0x83 },
	0xdc66, { 0xE9, 0x88, 0x9A },
	0xdc67, { 0xE9, 0x88, 0xA6 },
	0xdc68, { 0xE9, 0x88, 0x8F },
	0xdc69, { 0xE9, 0x88, 0x8C },
	0xdc6a, { 0xE9, 0x88, 0x80 },
	0xdc6b, { 0xE9, 0x88, 0x92 },
	0xdc6c, { 0xE9, 0x87, 0xBF },
	0xdc6d, { 0xE9, 0x87, 0xBD },
	0xdc6e, { 0xE9, 0x88, 0x86 },
	0xdc6f, { 0xE9, 0x88, 0x84 },
	0xdc70, { 0xE9, 0x88, 0xA7 },
	0xdc71, { 0xE9, 0x88, 0x82 },
	0xdc72, { 0xE9, 0x88, 0x9C },
	0xdc73, { 0xE9, 0x88, 0xA4 },
	0xdc74, { 0xE9, 0x88, 0x99 },
	0xdc75, { 0xE9, 0x88, 0x97 },
	0xdc76, { 0xE9, 0x88, 0x85 },
	0xdc77, { 0xE9, 0x88, 0x96 },
	0xdc78, { 0xE9, 0x95, 0xBB },
	0xdc79, { 0xE9, 0x96, 0x8D },
	0xdc7a, { 0xE9, 0x96, 0x8C },
	0xdc7b, { 0xE9, 0x96, 0x90 },
	0xdc7c, { 0xE9, 0x9A, 0x87 },
	0xdc7d, { 0xE9, 0x99, 0xBE },
	0xdc7e, { 0xE9, 0x9A, 0x88 },
	0xdca1, { 0xE9, 0x9A, 0x89 },
	0xdca2, { 0xE9, 0x9A, 0x83 },
	0xdca3, { 0xE9, 0x9A, 0x80 },
	0xdca4, { 0xE9, 0x9B, 0x82 },
	0xdca5, { 0xE9, 0x9B, 0x88 },
	0xdca6, { 0xE9, 0x9B, 0x83 },
	0xdca7, { 0xE9, 0x9B, 0xB1 },
	0xdca8, { 0xE9, 0x9B, 0xB0 },
	0xdca9, { 0xE9, 0x9D, 0xAC },
	0xdcaa, { 0xE9, 0x9D, 0xB0 },
	0xdcab, { 0xE9, 0x9D, 0xAE },
	0xdcac, { 0xE9, 0xA0, 0x87 },
	0xdcad, { 0xE9, 0xA2, 0xA9 },
	0xdcae, { 0xE9, 0xA3, 0xAB },
	0xdcaf, { 0xE9, 0xB3, 0xA6 },
	0xdcb0, { 0xE9, 0xBB, 0xB9 },
	0xdcb1, { 0xE4, 0xBA, 0x83 },
	0xdcb2, { 0xE4, 0xBA, 0x84 },
	0xdcb3, { 0xE4, 0xBA, 0xB6 },
	0xdcb4, { 0xE5, 0x82, 0xBD },
	0xdcb5, { 0xE5, 0x82, 0xBF },
	0xdcb6, { 0xE5, 0x83, 0x86 },
	0xdcb7, { 0xE5, 0x82, 0xAE },
	0xdcb8, { 0xE5, 0x83, 0x84 },
	0xdcb9, { 0xE5, 0x83, 0x8A },
	0xdcba, { 0xE5, 0x82, 0xB4 },
	0xdcbb, { 0xE5, 0x83, 0x88 },
	0xdcbc, { 0xE5, 0x83, 0x82 },
	0xdcbd, { 0xE5, 0x82, 0xB0 },
	0xdcbe, { 0xE5, 0x83, 0x81 },
	0xdcbf, { 0xE5, 0x82, 0xBA },
	0xdcc0, { 0xE5, 0x82, 0xB1 },
	0xdcc1, { 0xE5, 0x83, 0x8B },
	0xdcc2, { 0xE5, 0x83, 0x89 },
	0xdcc3, { 0xE5, 0x82, 0xB6 },
	0xdcc4, { 0xE5, 0x82, 0xB8 },
	0xdcc5, { 0xE5, 0x87, 0x97 },
	0xdcc6, { 0xE5, 0x89, 0xBA },
	0xdcc7, { 0xE5, 0x89, 0xB8 },
	0xdcc8, { 0xE5, 0x89, 0xBB },
	0xdcc9, { 0xE5, 0x89, 0xBC },
	0xdcca, { 0xE5, 0x97, 0x83 },
	0xdccb, { 0xE5, 0x97, 0x9B },
	0xdccc, { 0xE5, 0x97, 0x8C },
	0xdccd, { 0xE5, 0x97, 0x90 },
	0xdcce, { 0xE5, 0x97, 0x8B },
	0xdccf, { 0xE5, 0x97, 0x8A },
	0xdcd0, { 0xE5, 0x97, 0x9D },
	0xdcd1, { 0xE5, 0x97, 0x80 },
	0xdcd2, { 0xE5, 0x97, 0x94 },
	0xdcd3, { 0xE5, 0x97, 0x84 },
	0xdcd4, { 0xE5, 0x97, 0xA9 },
	0xdcd5, { 0xE5, 0x96, 0xBF },
	0xdcd6, { 0xE5, 0x97, 0x92 },
	0xdcd7, { 0xE5, 0x96, 0x8D },
	0xdcd8, { 0xE5, 0x97, 0x8F },
	0xdcd9, { 0xE5, 0x97, 0x95 },
	0xdcda, { 0xE5, 0x97, 0xA2 },
	0xdcdb, { 0xE5, 0x97, 0x96 },
	0xdcdc, { 0xE5, 0x97, 0x88 },
	0xdcdd, { 0xE5, 0x97, 0xB2 },
	0xdcde, { 0xE5, 0x97, 0x8D },
	0xdcdf, { 0xE5, 0x97, 0x99 },
	0xdce0, { 0xE5, 0x97, 0x82 },
	0xdce1, { 0xE5, 0x9C, 0x94 },
	0xdce2, { 0xE5, 0xA1, 0x93 },
	0xdce3, { 0xE5, 0xA1, 0xA8 },
	0xdce4, { 0xE5, 0xA1, 0xA4 },
	0xdce5, { 0xE5, 0xA1, 0x8F },
	0xdce6, { 0xE5, 0xA1, 0x8D },
	0xdce7, { 0xE5, 0xA1, 0x89 },
	0xdce8, { 0xE5, 0xA1, 0xAF },
	0xdce9, { 0xE5, 0xA1, 0x95 },
	0xdcea, { 0xE5, 0xA1, 0x8E },
	0xdceb, { 0xE5, 0xA1, 0x9D },
	0xdcec, { 0xE5, 0xA1, 0x99 },
	0xdced, { 0xE5, 0xA1, 0xA5 },
	0xdcee, { 0xE5, 0xA1, 0x9B },
	0xdcef, { 0xE5, 0xA0, 0xBD },
	0xdcf0, { 0xE5, 0xA1, 0xA3 },
	0xdcf1, { 0xE5, 0xA1, 0xB1 },
	0xdcf2, { 0xE5, 0xA3, 0xBC },
	0xdcf3, { 0xE5, 0xAB, 0x87 },
	0xdcf4, { 0xE5, 0xAB, 0x84 },
	0xdcf5, { 0xE5, 0xAB, 0x8B },
	0xdcf6, { 0xE5, 0xAA, 0xBA },
	0xdcf7, { 0xE5, 0xAA, 0xB8 },
	0xdcf8, { 0xE5, 0xAA, 0xB1 },
	0xdcf9, { 0xE5, 0xAA, 0xB5 },
	0xdcfa, { 0xE5, 0xAA, 0xB0 },
	0xdcfb, { 0xE5, 0xAA, 0xBF },
	0xdcfc, { 0xE5, 0xAB, 0x88 },
	0xdcfd, { 0xE5, 0xAA, 0xBB },
	0xdcfe, { 0xE5, 0xAB, 0x86 },
	0xdd40, { 0xE5, 0xAA, 0xB7 },
	0xdd41, { 0xE5, 0xAB, 0x80 },
	0xdd42, { 0xE5, 0xAB, 0x8A },
	0xdd43, { 0xE5, 0xAA, 0xB4 },
	0xdd44, { 0xE5, 0xAA, 0xB6 },
	0xdd45, { 0xE5, 0xAB, 0x8D },
	0xdd46, { 0xE5, 0xAA, 0xB9 },
	0xdd47, { 0xE5, 0xAA, 0x90 },
	0xdd48, { 0xE5, 0xAF, 0x96 },
	0xdd49, { 0xE5, 0xAF, 0x98 },
	0xdd4a, { 0xE5, 0xAF, 0x99 },
	0xdd4b, { 0xE5, 0xB0, 0x9F },
	0xdd4c, { 0xE5, 0xB0, 0xB3 },
	0xdd4d, { 0xE5, 0xB5, 0xB1 },
	0xdd4e, { 0xE5, 0xB5, 0xA3 },
	0xdd4f, { 0xE5, 0xB5, 0x8A },
	0xdd50, { 0xE5, 0xB5, 0xA5 },
	0xdd51, { 0xE5, 0xB5, 0xB2 },
	0xdd52, { 0xE5, 0xB5, 0xAC },
	0xdd53, { 0xE5, 0xB5, 0x9E },
	0xdd54, { 0xE5, 0xB5, 0xA8 },
	0xdd55, { 0xE5, 0xB5, 0xA7 },
	0xdd56, { 0xE5, 0xB5, 0xA2 },
	0xdd57, { 0xE5, 0xB7, 0xB0 },
	0xdd58, { 0xE5, 0xB9, 0x8F },
	0xdd59, { 0xE5, 0xB9, 0x8E },
	0xdd5a, { 0xE5, 0xB9, 0x8A },
	0xdd5b, { 0xE5, 0xB9, 0x8D },
	0xdd5c, { 0xE5, 0xB9, 0x8B },
	0xdd5d, { 0xE5, 0xBB, 0x85 },
	0xdd5e, { 0xE5, 0xBB, 0x8C },
	0xdd5f, { 0xE5, 0xBB, 0x86 },
	0xdd60, { 0xE5, 0xBB, 0x8B },
	0xdd61, { 0xE5, 0xBB, 0x87 },
	0xdd62, { 0xE5, 0xBD, 0x80 },
	0xdd63, { 0xE5, 0xBE, 0xAF },
	0xdd64, { 0xE5, 0xBE, 0xAD },
	0xdd65, { 0xE6, 0x83, 0xB7 },
	0xdd66, { 0xE6, 0x85, 0x89 },
	0xdd67, { 0xE6, 0x85, 0x8A },
	0xdd68, { 0xE6, 0x84, 0xAB },
	0xdd69, { 0xE6, 0x85, 0x85 },
	0xdd6a, { 0xE6, 0x84, 0xB6 },
	0xdd6b, { 0xE6, 0x84, 0xB2 },
	0xdd6c, { 0xE6, 0x84, 0xAE },
	0xdd6d, { 0xE6, 0x85, 0x86 },
	0xdd6e, { 0xE6, 0x84, 0xAF },
	0xdd6f, { 0xE6, 0x85, 0x8F },
	0xdd70, { 0xE6, 0x84, 0xA9 },
	0xdd71, { 0xE6, 0x85, 0x80 },
	0xdd72, { 0xE6, 0x88, 0xA0 },
	0xdd73, { 0xE9, 0x85, 0xA8 },
	0xdd74, { 0xE6, 0x88, 0xA3 },
	0xdd75, { 0xE6, 0x88, 0xA5 },
	0xdd76, { 0xE6, 0x88, 0xA4 },
	0xdd77, { 0xE6, 0x8F, 0x85 },
	0xdd78, { 0xE6, 0x8F, 0xB1 },
	0xdd79, { 0xE6, 0x8F, 0xAB },
	0xdd7a, { 0xE6, 0x90, 0x90 },
	0xdd7b, { 0xE6, 0x90, 0x92 },
	0xdd7c, { 0xE6, 0x90, 0x89 },
	0xdd7d, { 0xE6, 0x90, 0xA0 },
	0xdd7e, { 0xE6, 0x90, 0xA4 },
	0xdda1, { 0xE6, 0x90, 0xB3 },
	0xdda2, { 0xE6, 0x91, 0x83 },
	0xdda3, { 0xE6, 0x90, 0x9F },
	0xdda4, { 0xE6, 0x90, 0x95 },
	0xdda5, { 0xE6, 0x90, 0x98 },
	0xdda6, { 0xE6, 0x90, 0xB9 },
	0xdda7, { 0xE6, 0x90, 0xB7 },
	0xdda8, { 0xE6, 0x90, 0xA2 },
	0xdda9, { 0xE6, 0x90, 0xA3 },
	0xddaa, { 0xE6, 0x90, 0x8C },
	0xddab, { 0xE6, 0x90, 0xA6 },
	0xddac, { 0xE6, 0x90, 0xB0 },
	0xddad, { 0xE6, 0x90, 0xA8 },
	0xddae, { 0xE6, 0x91, 0x81 },
	0xddaf, { 0xE6, 0x90, 0xB5 },
	0xddb0, { 0xE6, 0x90, 0xAF },
	0xddb1, { 0xE6, 0x90, 0x8A },
	0xddb2, { 0xE6, 0x90, 0x9A },
	0xddb3, { 0xE6, 0x91, 0x80 },
	0xddb4, { 0xE6, 0x90, 0xA5 },
	0xddb5, { 0xE6, 0x90, 0xA7 },
	0xddb6, { 0xE6, 0x90, 0x8B },
	0xddb7, { 0xE6, 0x8F, 0xA7 },
	0xddb8, { 0xE6, 0x90, 0x9B },
	0xddb9, { 0xE6, 0x90, 0xAE },
	0xddba, { 0xE6, 0x90, 0xA1 },
	0xddbb, { 0xE6, 0x90, 0x8E },
	0xddbc, { 0xE6, 0x95, 0xAF },
	0xddbd, { 0xE6, 0x96, 0x92 },
	0xddbe, { 0xE6, 0x97, 0x93 },
	0xddbf, { 0xE6, 0x9A, 0x86 },
	0xddc0, { 0xE6, 0x9A, 0x8C },
	0xddc1, { 0xE6, 0x9A, 0x95 },
	0xddc2, { 0xE6, 0x9A, 0x90 },
	0xddc3, { 0xE6, 0x9A, 0x8B },
	0xddc4, { 0xE6, 0x9A, 0x8A },
	0xddc5, { 0xE6, 0x9A, 0x99 },
	0xddc6, { 0xE6, 0x9A, 0x94 },
	0xddc7, { 0xE6, 0x99, 0xB8 },
	0xddc8, { 0xE6, 0x9C, 0xA0 },
	0xddc9, { 0xE6, 0xA5, 0xA6 },
	0xddca, { 0xE6, 0xA5, 0x9F },
	0xddcb, { 0xE6, 0xA4, 0xB8 },
	0xddcc, { 0xE6, 0xA5, 0x8E },
	0xddcd, { 0xE6, 0xA5, 0xA2 },
	0xddce, { 0xE6, 0xA5, 0xB1 },
	0xddcf, { 0xE6, 0xA4, 0xBF },
	0xddd0, { 0xE6, 0xA5, 0x85 },
	0xddd1, { 0xE6, 0xA5, 0xAA },
	0xddd2, { 0xE6, 0xA4, 0xB9 },
	0xddd3, { 0xE6, 0xA5, 0x82 },
	0xddd4, { 0xE6, 0xA5, 0x97 },
	0xddd5, { 0xE6, 0xA5, 0x99 },
	0xddd6, { 0xE6, 0xA5, 0xBA },
	0xddd7, { 0xE6, 0xA5, 0x88 },
	0xddd8, { 0xE6, 0xA5, 0x89 },
	0xddd9, { 0xE6, 0xA4, 0xB5 },
	0xddda, { 0xE6, 0xA5, 0xAC },
	0xdddb, { 0xE6, 0xA4, 0xB3 },
	0xdddc, { 0xE6, 0xA4, 0xBD },
	0xdddd, { 0xE6, 0xA5, 0xA5 },
	0xddde, { 0xE6, 0xA3, 0xB0 },
	0xdddf, { 0xE6, 0xA5, 0xB8 },
	0xdde0, { 0xE6, 0xA4, 0xB4 },
	0xdde1, { 0xE6, 0xA5, 0xA9 },
	0xdde2, { 0xE6, 0xA5, 0x80 },
	0xdde3, { 0xE6, 0xA5, 0xAF },
	0xdde4, { 0xE6, 0xA5, 0x84 },
	0xdde5, { 0xE6, 0xA5, 0xB6 },
	0xdde6, { 0xE6, 0xA5, 0x98 },
	0xdde7, { 0xE6, 0xA5, 0x81 },
	0xdde8, { 0xE6, 0xA5, 0xB4 },
	0xdde9, { 0xE6, 0xA5, 0x8C },
	0xddea, { 0xE6, 0xA4, 0xBB },
	0xddeb, { 0xE6, 0xA5, 0x8B },
	0xddec, { 0xE6, 0xA4, 0xB7 },
	0xdded, { 0xE6, 0xA5, 0x9C },
	0xddee, { 0xE6, 0xA5, 0x8F },
	0xddef, { 0xE6, 0xA5, 0x91 },
	0xddf0, { 0xE6, 0xA4, 0xB2 },
	0xddf1, { 0xE6, 0xA5, 0x92 },
	0xddf2, { 0xE6, 0xA4, 0xAF },
	0xddf3, { 0xE6, 0xA5, 0xBB },
	0xddf4, { 0xE6, 0xA4, 0xBC },
	0xddf5, { 0xE6, 0xAD, 0x86 },
	0xddf6, { 0xE6, 0xAD, 0x85 },
	0xddf7, { 0xE6, 0xAD, 0x83 },
	0xddf8, { 0xE6, 0xAD, 0x82 },
	0xddf9, { 0xE6, 0xAD, 0x88 },
	0xddfa, { 0xE6, 0xAD, 0x81 },
	0xddfb, { 0xE6, 0xAE, 0x9B },
	0xddfc, { 0xEF, 0xA8, 0x8D },
	0xddfd, { 0xE6, 0xAF, 0xBB },
	0xddfe, { 0xE6, 0xAF, 0xBC },
	0xde40, { 0xE6, 0xAF, 0xB9 },
	0xde41, { 0xE6, 0xAF, 0xB7 },
	0xde42, { 0xE6, 0xAF, 0xB8 },
	0xde43, { 0xE6, 0xBA, 0x9B },
	0xde44, { 0xE6, 0xBB, 0x96 },
	0xde45, { 0xE6, 0xBB, 0x88 },
	0xde46, { 0xE6, 0xBA, 0x8F },
	0xde47, { 0xE6, 0xBB, 0x80 },
	0xde48, { 0xE6, 0xBA, 0x9F },
	0xde49, { 0xE6, 0xBA, 0x93 },
	0xde4a, { 0xE6, 0xBA, 0x94 },
	0xde4b, { 0xE6, 0xBA, 0xA0 },
	0xde4c, { 0xE6, 0xBA, 0xB1 },
	0xde4d, { 0xE6, 0xBA, 0xB9 },
	0xde4e, { 0xE6, 0xBB, 0x86 },
	0xde4f, { 0xE6, 0xBB, 0x92 },
	0xde50, { 0xE6, 0xBA, 0xBD },
	0xde51, { 0xE6, 0xBB, 0x81 },
	0xde52, { 0xE6, 0xBA, 0x9E },
	0xde53, { 0xE6, 0xBB, 0x89 },
	0xde54, { 0xE6, 0xBA, 0xB7 },
	0xde55, { 0xE6, 0xBA, 0xB0 },
	0xde56, { 0xE6, 0xBB, 0x8D },
	0xde57, { 0xE6, 0xBA, 0xA6 },
	0xde58, { 0xE6, 0xBB, 0x8F },
	0xde59, { 0xE6, 0xBA, 0xB2 },
	0xde5a, { 0xE6, 0xBA, 0xBE },
	0xde5b, { 0xE6, 0xBB, 0x83 },
	0xde5c, { 0xE6, 0xBB, 0x9C },
	0xde5d, { 0xE6, 0xBB, 0x98 },
	0xde5e, { 0xE6, 0xBA, 0x99 },
	0xde5f, { 0xE6, 0xBA, 0x92 },
	0xde60, { 0xE6, 0xBA, 0x8E },
	0xde61, { 0xE6, 0xBA, 0x8D },
	0xde62, { 0xE6, 0xBA, 0xA4 },
	0xde63, { 0xE6, 0xBA, 0xA1 },
	0xde64, { 0xE6, 0xBA, 0xBF },
	0xde65, { 0xE6, 0xBA, 0xB3 },
	0xde66, { 0xE6, 0xBB, 0x90 },
	0xde67, { 0xE6, 0xBB, 0x8A },
	0xde68, { 0xE6, 0xBA, 0x97 },
	0xde69, { 0xE6, 0xBA, 0xAE },
	0xde6a, { 0xE6, 0xBA, 0xA3 },
	0xde6b, { 0xE7, 0x85, 0x87 },
	0xde6c, { 0xE7, 0x85, 0x94 },
	0xde6d, { 0xE7, 0x85, 0x92 },
	0xde6e, { 0xE7, 0x85, 0xA3 },
	0xde6f, { 0xE7, 0x85, 0xA0 },
	0xde70, { 0xE7, 0x85, 0x81 },
	0xde71, { 0xE7, 0x85, 0x9D },
	0xde72, { 0xE7, 0x85, 0xA2 },
	0xde73, { 0xE7, 0x85, 0xB2 },
	0xde74, { 0xE7, 0x85, 0xB8 },
	0xde75, { 0xE7, 0x85, 0xAA },
	0xde76, { 0xE7, 0x85, 0xA1 },
	0xde77, { 0xE7, 0x85, 0x82 },
	0xde78, { 0xE7, 0x85, 0x98 },
	0xde79, { 0xE7, 0x85, 0x83 },
	0xde7a, { 0xE7, 0x85, 0x8B },
	0xde7b, { 0xE7, 0x85, 0xB0 },
	0xde7c, { 0xE7, 0x85, 0x9F },
	0xde7d, { 0xE7, 0x85, 0x90 },
	0xde7e, { 0xE7, 0x85, 0x93 },
	0xdea1, { 0xE7, 0x85, 0x84 },
	0xdea2, { 0xE7, 0x85, 0x8D },
	0xdea3, { 0xE7, 0x85, 0x9A },
	0xdea4, { 0xE7, 0x89, 0x8F },
	0xdea5, { 0xE7, 0x8A, 0x8D },
	0xdea6, { 0xE7, 0x8A, 0x8C },
	0xdea7, { 0xE7, 0x8A, 0x91 },
	0xdea8, { 0xE7, 0x8A, 0x90 },
	0xdea9, { 0xE7, 0x8A, 0x8E },
	0xdeaa, { 0xE7, 0x8C, 0xBC },
	0xdeab, { 0xE7, 0x8D, 0x82 },
	0xdeac, { 0xE7, 0x8C, 0xBB },
	0xdead, { 0xE7, 0x8C, 0xBA },
	0xdeae, { 0xE7, 0x8D, 0x80 },
	0xdeaf, { 0xE7, 0x8D, 0x8A },
	0xdeb0, { 0xE7, 0x8D, 0x89 },
	0xdeb1, { 0xE7, 0x91, 0x84 },
	0xdeb2, { 0xE7, 0x91, 0x8A },
	0xdeb3, { 0xE7, 0x91, 0x8B },
	0xdeb4, { 0xE7, 0x91, 0x92 },
	0xdeb5, { 0xE7, 0x91, 0x91 },
	0xdeb6, { 0xE7, 0x91, 0x97 },
	0xdeb7, { 0xE7, 0x91, 0x80 },
	0xdeb8, { 0xE7, 0x91, 0x8F },
	0xdeb9, { 0xE7, 0x91, 0x90 },
	0xdeba, { 0xE7, 0x91, 0x8E },
	0xdebb, { 0xE7, 0x91, 0x82 },
	0xdebc, { 0xE7, 0x91, 0x86 },
	0xdebd, { 0xE7, 0x91, 0x8D },
	0xdebe, { 0xE7, 0x91, 0x94 },
	0xdebf, { 0xE7, 0x93, 0xA1 },
	0xdec0, { 0xE7, 0x93, 0xBF },
	0xdec1, { 0xE7, 0x93, 0xBE },
	0xdec2, { 0xE7, 0x93, 0xBD },
	0xdec3, { 0xE7, 0x94, 0x9D },
	0xdec4, { 0xE7, 0x95, 0xB9 },
	0xdec5, { 0xE7, 0x95, 0xB7 },
	0xdec6, { 0xE6, 0xA6, 0x83 },
	0xdec7, { 0xE7, 0x97, 0xAF },
	0xdec8, { 0xE7, 0x98, 0x8F },
	0xdec9, { 0xE7, 0x98, 0x83 },
	0xdeca, { 0xE7, 0x97, 0xB7 },
	0xdecb, { 0xE7, 0x97, 0xBE },
	0xdecc, { 0xE7, 0x97, 0xBC },
	0xdecd, { 0xE7, 0x97, 0xB9 },
	0xdece, { 0xE7, 0x97, 0xB8 },
	0xdecf, { 0xE7, 0x98, 0x90 },
	0xded0, { 0xE7, 0x97, 0xBB },
	0xded1, { 0xE7, 0x97, 0xB6 },
	0xded2, { 0xE7, 0x97, 0xAD },
	0xded3, { 0xE7, 0x97, 0xB5 },
	0xded4, { 0xE7, 0x97, 0xBD },
	0xded5, { 0xE7, 0x9A, 0x99 },
	0xded6, { 0xE7, 0x9A, 0xB5 },
	0xded7, { 0xE7, 0x9B, 0x9D },
	0xded8, { 0xE7, 0x9D, 0x95 },
	0xded9, { 0xE7, 0x9D, 0x9F },
	0xdeda, { 0xE7, 0x9D, 0xA0 },
	0xdedb, { 0xE7, 0x9D, 0x92 },
	0xdedc, { 0xE7, 0x9D, 0x96 },
	0xdedd, { 0xE7, 0x9D, 0x9A },
	0xdede, { 0xE7, 0x9D, 0xA9 },
	0xdedf, { 0xE7, 0x9D, 0xA7 },
	0xdee0, { 0xE7, 0x9D, 0x94 },
	0xdee1, { 0xE7, 0x9D, 0x99 },
	0xdee2, { 0xE7, 0x9D, 0xAD },
	0xdee3, { 0xE7, 0x9F, 0xA0 },
	0xdee4, { 0xE7, 0xA2, 0x87 },
	0xdee5, { 0xE7, 0xA2, 0x9A },
	0xdee6, { 0xE7, 0xA2, 0x94 },
	0xdee7, { 0xE7, 0xA2, 0x8F },
	0xdee8, { 0xE7, 0xA2, 0x84 },
	0xdee9, { 0xE7, 0xA2, 0x95 },
	0xdeea, { 0xE7, 0xA2, 0x85 },
	0xdeeb, { 0xE7, 0xA2, 0x86 },
	0xdeec, { 0xE7, 0xA2, 0xA1 },
	0xdeed, { 0xE7, 0xA2, 0x83 },
	0xdeee, { 0xE7, 0xA1, 0xB9 },
	0xdeef, { 0xE7, 0xA2, 0x99 },
	0xdef0, { 0xE7, 0xA2, 0x80 },
	0xdef1, { 0xE7, 0xA2, 0x96 },
	0xdef2, { 0xE7, 0xA1, 0xBB },
	0xdef3, { 0xE7, 0xA5, 0xBC },
	0xdef4, { 0xE7, 0xA6, 0x82 },
	0xdef5, { 0xE7, 0xA5, 0xBD },
	0xdef6, { 0xE7, 0xA5, 0xB9 },
	0xdef7, { 0xE7, 0xA8, 0x91 },
	0xdef8, { 0xE7, 0xA8, 0x98 },
	0xdef9, { 0xE7, 0xA8, 0x99 },
	0xdefa, { 0xE7, 0xA8, 0x92 },
	0xdefb, { 0xE7, 0xA8, 0x97 },
	0xdefc, { 0xE7, 0xA8, 0x95 },
	0xdefd, { 0xE7, 0xA8, 0xA2 },
	0xdefe, { 0xE7, 0xA8, 0x93 },
	0xdf40, { 0xE7, 0xA8, 0x9B },
	0xdf41, { 0xE7, 0xA8, 0x90 },
	0xdf42, { 0xE7, 0xAA, 0xA3 },
	0xdf43, { 0xE7, 0xAA, 0xA2 },
	0xdf44, { 0xE7, 0xAA, 0x9E },
	0xdf45, { 0xE7, 0xAB, 0xAB },
	0xdf46, { 0xE7, 0xAD, 0xA6 },
	0xdf47, { 0xE7, 0xAD, 0xA4 },
	0xdf48, { 0xE7, 0xAD, 0xAD },
	0xdf49, { 0xE7, 0xAD, 0xB4 },
	0xdf4a, { 0xE7, 0xAD, 0xA9 },
	0xdf4b, { 0xE7, 0xAD, 0xB2 },
	0xdf4c, { 0xE7, 0xAD, 0xA5 },
	0xdf4d, { 0xE7, 0xAD, 0xB3 },
	0xdf4e, { 0xE7, 0xAD, 0xB1 },
	0xdf4f, { 0xE7, 0xAD, 0xB0 },
	0xdf50, { 0xE7, 0xAD, 0xA1 },
	0xdf51, { 0xE7, 0xAD, 0xB8 },
	0xdf52, { 0xE7, 0xAD, 0xB6 },
	0xdf53, { 0xE7, 0xAD, 0xA3 },
	0xdf54, { 0xE7, 0xB2, 0xB2 },
	0xdf55, { 0xE7, 0xB2, 0xB4 },
	0xdf56, { 0xE7, 0xB2, 0xAF },
	0xdf57, { 0xE7, 0xB6, 0x88 },
	0xdf58, { 0xE7, 0xB6, 0x86 },
	0xdf59, { 0xE7, 0xB6, 0x80 },
	0xdf5a, { 0xE7, 0xB6, 0x8D },
	0xdf5b, { 0xE7, 0xB5, 0xBF },
	0xdf5c, { 0xE7, 0xB6, 0x85 },
	0xdf5d, { 0xE7, 0xB5, 0xBA },
	0xdf5e, { 0xE7, 0xB6, 0x8E },
	0xdf5f, { 0xE7, 0xB5, 0xBB },
	0xdf60, { 0xE7, 0xB6, 0x83 },
	0xdf61, { 0xE7, 0xB5, 0xBC },
	0xdf62, { 0xE7, 0xB6, 0x8C },
	0xdf63, { 0xE7, 0xB6, 0x94 },
	0xdf64, { 0xE7, 0xB6, 0x84 },
	0xdf65, { 0xE7, 0xB5, 0xBD },
	0xdf66, { 0xE7, 0xB6, 0x92 },
	0xdf67, { 0xE7, 0xBD, 0xAD },
	0xdf68, { 0xE7, 0xBD, 0xAB },
	0xdf69, { 0xE7, 0xBD, 0xA7 },
	0xdf6a, { 0xE7, 0xBD, 0xA8 },
	0xdf6b, { 0xE7, 0xBD, 0xAC },
	0xdf6c, { 0xE7, 0xBE, 0xA6 },
	0xdf6d, { 0xE7, 0xBE, 0xA5 },
	0xdf6e, { 0xE7, 0xBE, 0xA7 },
	0xdf6f, { 0xE7, 0xBF, 0x9B },
	0xdf70, { 0xE7, 0xBF, 0x9C },
	0xdf71, { 0xE8, 0x80, 0xA1 },
	0xdf72, { 0xE8, 0x85, 0xA4 },
	0xdf73, { 0xE8, 0x85, 0xA0 },
	0xdf74, { 0xE8, 0x85, 0xB7 },
	0xdf75, { 0xE8, 0x85, 0x9C },
	0xdf76, { 0xE8, 0x85, 0xA9 },
	0xdf77, { 0xE8, 0x85, 0x9B },
	0xdf78, { 0xE8, 0x85, 0xA2 },
	0xdf79, { 0xE8, 0x85, 0xB2 },
	0xdf7a, { 0xE6, 0x9C, 0xA1 },
	0xdf7b, { 0xE8, 0x85, 0x9E },
	0xdf7c, { 0xE8, 0x85, 0xB6 },
	0xdf7d, { 0xE8, 0x85, 0xA7 },
	0xdf7e, { 0xE8, 0x85, 0xAF },
	0xdfa1, { 0xE8, 0x85, 0x84 },
	0xdfa2, { 0xE8, 0x85, 0xA1 },
	0xdfa3, { 0xE8, 0x88, 0x9D },
	0xdfa4, { 0xE8, 0x89, 0x89 },
	0xdfa5, { 0xE8, 0x89, 0x84 },
	0xdfa6, { 0xE8, 0x89, 0x80 },
	0xdfa7, { 0xE8, 0x89, 0x82 },
	0xdfa8, { 0xE8, 0x89, 0x85 },
	0xdfa9, { 0xE8, 0x93, 0xB1 },
	0xdfaa, { 0xE8, 0x90, 0xBF },
	0xdfab, { 0xE8, 0x91, 0x96 },
	0xdfac, { 0xE8, 0x91, 0xB6 },
	0xdfad, { 0xE8, 0x91, 0xB9 },
	0xdfae, { 0xE8, 0x92, 0x8F },
	0xdfaf, { 0xE8, 0x92, 0x8D },
	0xdfb0, { 0xE8, 0x91, 0xA5 },
	0xdfb1, { 0xE8, 0x91, 0x91 },
	0xdfb2, { 0xE8, 0x91, 0x80 },
	0xdfb3, { 0xE8, 0x92, 0x86 },
	0xdfb4, { 0xE8, 0x91, 0xA7 },
	0xdfb5, { 0xE8, 0x90, 0xB0 },
	0xdfb6, { 0xE8, 0x91, 0x8D },
	0xdfb7, { 0xE8, 0x91, 0xBD },
	0xdfb8, { 0xE8, 0x91, 0x9A },
	0xdfb9, { 0xE8, 0x91, 0x99 },
	0xdfba, { 0xE8, 0x91, 0xB4 },
	0xdfbb, { 0xE8, 0x91, 0xB3 },
	0xdfbc, { 0xE8, 0x91, 0x9D },
	0xdfbd, { 0xE8, 0x94, 0x87 },
	0xdfbe, { 0xE8, 0x91, 0x9E },
	0xdfbf, { 0xE8, 0x90, 0xB7 },
	0xdfc0, { 0xE8, 0x90, 0xBA },
	0xdfc1, { 0xE8, 0x90, 0xB4 },
	0xdfc2, { 0xE8, 0x91, 0xBA },
	0xdfc3, { 0xE8, 0x91, 0x83 },
	0xdfc4, { 0xE8, 0x91, 0xB8 },
	0xdfc5, { 0xE8, 0x90, 0xB2 },
	0xdfc6, { 0xE8, 0x91, 0x85 },
	0xdfc7, { 0xE8, 0x90, 0xA9 },
	0xdfc8, { 0xE8, 0x8F, 0x99 },
	0xdfc9, { 0xE8, 0x91, 0x8B },
	0xdfca, { 0xE8, 0x90, 0xAF },
	0xdfcb, { 0xE8, 0x91, 0x82 },
	0xdfcc, { 0xE8, 0x90, 0xAD },
	0xdfcd, { 0xE8, 0x91, 0x9F },
	0xdfce, { 0xE8, 0x91, 0xB0 },
	0xdfcf, { 0xE8, 0x90, 0xB9 },
	0xdfd0, { 0xE8, 0x91, 0x8E },
	0xdfd1, { 0xE8, 0x91, 0x8C },
	0xdfd2, { 0xE8, 0x91, 0x92 },
	0xdfd3, { 0xE8, 0x91, 0xAF },
	0xdfd4, { 0xE8, 0x93, 0x85 },
	0xdfd5, { 0xE8, 0x92, 0x8E },
	0xdfd6, { 0xE8, 0x90, 0xBB },
	0xdfd7, { 0xE8, 0x91, 0x87 },
	0xdfd8, { 0xE8, 0x90, 0xB6 },
	0xdfd9, { 0xE8, 0x90, 0xB3 },
	0xdfda, { 0xE8, 0x91, 0xA8 },
	0xdfdb, { 0xE8, 0x91, 0xBE },
	0xdfdc, { 0xE8, 0x91, 0x84 },
	0xdfdd, { 0xE8, 0x90, 0xAB },
	0xdfde, { 0xE8, 0x91, 0xA0 },
	0xdfdf, { 0xE8, 0x91, 0x94 },
	0xdfe0, { 0xE8, 0x91, 0xAE },
	0xdfe1, { 0xE8, 0x91, 0x90 },
	0xdfe2, { 0xE8, 0x9C, 0x8B },
	0xdfe3, { 0xE8, 0x9C, 0x84 },
	0xdfe4, { 0xE8, 0x9B, 0xB7 },
	0xdfe5, { 0xE8, 0x9C, 0x8C },
	0xdfe6, { 0xE8, 0x9B, 0xBA },
	0xdfe7, { 0xE8, 0x9B, 0x96 },
	0xdfe8, { 0xE8, 0x9B, 0xB5 },
	0xdfe9, { 0xE8, 0x9D, 0x8D },
	0xdfea, { 0xE8, 0x9B, 0xB8 },
	0xdfeb, { 0xE8, 0x9C, 0x8E },
	0xdfec, { 0xE8, 0x9C, 0x89 },
	0xdfed, { 0xE8, 0x9C, 0x81 },
	0xdfee, { 0xE8, 0x9B, 0xB6 },
	0xdfef, { 0xE8, 0x9C, 0x8D },
	0xdff0, { 0xE8, 0x9C, 0x85 },
	0xdff1, { 0xE8, 0xA3, 0x96 },
	0xdff2, { 0xE8, 0xA3, 0x8B },
	0xdff3, { 0xE8, 0xA3, 0x8D },
	0xdff4, { 0xE8, 0xA3, 0x8E },
	0xdff5, { 0xE8, 0xA3, 0x9E },
	0xdff6, { 0xE8, 0xA3, 0x9B },
	0xdff7, { 0xE8, 0xA3, 0x9A },
	0xdff8, { 0xE8, 0xA3, 0x8C },
	0xdff9, { 0xE8, 0xA3, 0x90 },
	0xdffa, { 0xE8, 0xA6, 0x85 },
	0xdffb, { 0xE8, 0xA6, 0x9B },
	0xdffc, { 0xE8, 0xA7, 0x9F },
	0xdffd, { 0xE8, 0xA7, 0xA5 },
	0xdffe, { 0xE8, 0xA7, 0xA4 },
	0xe040, { 0xE8, 0xA7, 0xA1 },
	0xe041, { 0xE8, 0xA7, 0xA0 },
	0xe042, { 0xE8, 0xA7, 0xA2 },
	0xe043, { 0xE8, 0xA7, 0x9C },
	0xe044, { 0xE8, 0xA7, 0xA6 },
	0xe045, { 0xE8, 0xA9, 0xB6 },
	0xe046, { 0xE8, 0xAA, 0x86 },
	0xe047, { 0xE8, 0xA9, 0xBF },
	0xe048, { 0xE8, 0xA9, 0xA1 },
	0xe049, { 0xE8, 0xA8, 0xBF },
	0xe04a, { 0xE8, 0xA9, 0xB7 },
	0xe04b, { 0xE8, 0xAA, 0x82 },
	0xe04c, { 0xE8, 0xAA, 0x84 },
	0xe04d, { 0xE8, 0xA9, 0xB5 },
	0xe04e, { 0xE8, 0xAA, 0x83 },
	0xe04f, { 0xE8, 0xAA, 0x81 },
	0xe050, { 0xE8, 0xA9, 0xB4 },
	0xe051, { 0xE8, 0xA9, 0xBA },
	0xe052, { 0xE8, 0xB0, 0xBC },
	0xe053, { 0xE8, 0xB1, 0x8B },
	0xe054, { 0xE8, 0xB1, 0x8A },
	0xe055, { 0xE8, 0xB1, 0xA5 },
	0xe056, { 0xE8, 0xB1, 0xA4 },
	0xe057, { 0xE8, 0xB1, 0xA6 },
	0xe058, { 0xE8, 0xB2, 0x86 },
	0xe059, { 0xE8, 0xB2, 0x84 },
	0xe05a, { 0xE8, 0xB2, 0x85 },
	0xe05b, { 0xE8, 0xB3, 0x8C },
	0xe05c, { 0xE8, 0xB5, 0xA8 },
	0xe05d, { 0xE8, 0xB5, 0xA9 },
	0xe05e, { 0xE8, 0xB6, 0x91 },
	0xe05f, { 0xE8, 0xB6, 0x8C },
	0xe060, { 0xE8, 0xB6, 0x8E },
	0xe061, { 0xE8, 0xB6, 0x8F },
	0xe062, { 0xE8, 0xB6, 0x8D },
	0xe063, { 0xE8, 0xB6, 0x93 },
	0xe064, { 0xE8, 0xB6, 0x94 },
	0xe065, { 0xE8, 0xB6, 0x90 },
	0xe066, { 0xE8, 0xB6, 0x92 },
	0xe067, { 0xE8, 0xB7, 0xB0 },
	0xe068, { 0xE8, 0xB7, 0xA0 },
	0xe069, { 0xE8, 0xB7, 0xAC },
	0xe06a, { 0xE8, 0xB7, 0xB1 },
	0xe06b, { 0xE8, 0xB7, 0xAE },
	0xe06c, { 0xE8, 0xB7, 0x90 },
	0xe06d, { 0xE8, 0xB7, 0xA9 },
	0xe06e, { 0xE8, 0xB7, 0xA3 },
	0xe06f, { 0xE8, 0xB7, 0xA2 },
	0xe070, { 0xE8, 0xB7, 0xA7 },
	0xe071, { 0xE8, 0xB7, 0xB2 },
	0xe072, { 0xE8, 0xB7, 0xAB },
	0xe073, { 0xE8, 0xB7, 0xB4 },
	0xe074, { 0xE8, 0xBC, 0x86 },
	0xe075, { 0xE8, 0xBB, 0xBF },
	0xe076, { 0xE8, 0xBC, 0x81 },
	0xe077, { 0xE8, 0xBC, 0x80 },
	0xe078, { 0xE8, 0xBC, 0x85 },
	0xe079, { 0xE8, 0xBC, 0x87 },
	0xe07a, { 0xE8, 0xBC, 0x88 },
	0xe07b, { 0xE8, 0xBC, 0x82 },
	0xe07c, { 0xE8, 0xBC, 0x8B },
	0xe07d, { 0xE9, 0x81, 0x92 },
	0xe07e, { 0xE9, 0x80, 0xBF },
	0xe0a1, { 0xE9, 0x81, 0x84 },
	0xe0a2, { 0xE9, 0x81, 0x89 },
	0xe0a3, { 0xE9, 0x80, 0xBD },
	0xe0a4, { 0xE9, 0x84, 0x90 },
	0xe0a5, { 0xE9, 0x84, 0x8D },
	0xe0a6, { 0xE9, 0x84, 0x8F },
	0xe0a7, { 0xE9, 0x84, 0x91 },
	0xe0a8, { 0xE9, 0x84, 0x96 },
	0xe0a9, { 0xE9, 0x84, 0x94 },
	0xe0aa, { 0xE9, 0x84, 0x8B },
	0xe0ab, { 0xE9, 0x84, 0x8E },
	0xe0ac, { 0xE9, 0x85, 0xAE },
	0xe0ad, { 0xE9, 0x85, 0xAF },
	0xe0ae, { 0xE9, 0x89, 0x88 },
	0xe0af, { 0xE9, 0x89, 0x92 },
	0xe0b0, { 0xE9, 0x88, 0xB0 },
	0xe0b1, { 0xE9, 0x88, 0xBA },
	0xe0b2, { 0xE9, 0x89, 0xA6 },
	0xe0b3, { 0xE9, 0x88, 0xB3 },
	0xe0b4, { 0xE9, 0x89, 0xA5 },
	0xe0b5, { 0xE9, 0x89, 0x9E },
	0xe0b6, { 0xE9, 0x8A, 0x83 },
	0xe0b7, { 0xE9, 0x88, 0xAE },
	0xe0b8, { 0xE9, 0x89, 0x8A },
	0xe0b9, { 0xE9, 0x89, 0x86 },
	0xe0ba, { 0xE9, 0x89, 0xAD },
	0xe0bb, { 0xE9, 0x89, 0xAC },
	0xe0bc, { 0xE9, 0x89, 0x8F },
	0xe0bd, { 0xE9, 0x89, 0xA0 },
	0xe0be, { 0xE9, 0x89, 0xA7 },
	0xe0bf, { 0xE9, 0x89, 0xAF },
	0xe0c0, { 0xE9, 0x88, 0xB6 },
	0xe0c1, { 0xE9, 0x89, 0xA1 },
	0xe0c2, { 0xE9, 0x89, 0xB0 },
	0xe0c3, { 0xE9, 0x88, 0xB1 },
	0xe0c4, { 0xE9, 0x89, 0x94 },
	0xe0c5, { 0xE9, 0x89, 0xA3 },
	0xe0c6, { 0xE9, 0x89, 0x90 },
	0xe0c7, { 0xE9, 0x89, 0xB2 },
	0xe0c8, { 0xE9, 0x89, 0x8E },
	0xe0c9, { 0xE9, 0x89, 0x93 },
	0xe0ca, { 0xE9, 0x89, 0x8C },
	0xe0cb, { 0xE9, 0x89, 0x96 },
	0xe0cc, { 0xE9, 0x88, 0xB2 },
	0xe0cd, { 0xE9, 0x96, 0x9F },
	0xe0ce, { 0xE9, 0x96, 0x9C },
	0xe0cf, { 0xE9, 0x96, 0x9E },
	0xe0d0, { 0xE9, 0x96, 0x9B },
	0xe0d1, { 0xE9, 0x9A, 0x92 },
	0xe0d2, { 0xE9, 0x9A, 0x93 },
	0xe0d3, { 0xE9, 0x9A, 0x91 },
	0xe0d4, { 0xE9, 0x9A, 0x97 },
	0xe0d5, { 0xE9, 0x9B, 0x8E },
	0xe0d6, { 0xE9, 0x9B, 0xBA },
	0xe0d7, { 0xE9, 0x9B, 0xBD },
	0xe0d8, { 0xE9, 0x9B, 0xB8 },
	0xe0d9, { 0xE9, 0x9B, 0xB5 },
	0xe0da, { 0xE9, 0x9D, 0xB3 },
	0xe0db, { 0xE9, 0x9D, 0xB7 },
	0xe0dc, { 0xE9, 0x9D, 0xB8 },
	0xe0dd, { 0xE9, 0x9D, 0xB2 },
	0xe0de, { 0xE9, 0xA0, 0x8F },
	0xe0df, { 0xE9, 0xA0, 0x8D },
	0xe0e0, { 0xE9, 0xA0, 0x8E },
	0xe0e1, { 0xE9, 0xA2, 0xAC },
	0xe0e2, { 0xE9, 0xA3, 0xB6 },
	0xe0e3, { 0xE9, 0xA3, 0xB9 },
	0xe0e4, { 0xE9, 0xA6, 0xAF },
	0xe0e5, { 0xE9, 0xA6, 0xB2 },
	0xe0e6, { 0xE9, 0xA6, 0xB0 },
	0xe0e7, { 0xE9, 0xA6, 0xB5 },
	0xe0e8, { 0xE9, 0xAA, 0xAD },
	0xe0e9, { 0xE9, 0xAA, 0xAB },
	0xe0ea, { 0xE9, 0xAD, 0x9B },
	0xe0eb, { 0xE9, 0xB3, 0xAA },
	0xe0ec, { 0xE9, 0xB3, 0xAD },
	0xe0ed, { 0xE9, 0xB3, 0xA7 },
	0xe0ee, { 0xE9, 0xBA, 0x80 },
	0xe0ef, { 0xE9, 0xBB, 0xBD },
	0xe0f0, { 0xE5, 0x83, 0xA6 },
	0xe0f1, { 0xE5, 0x83, 0x94 },
	0xe0f2, { 0xE5, 0x83, 0x97 },
	0xe0f3, { 0xE5, 0x83, 0xA8 },
	0xe0f4, { 0xE5, 0x83, 0xB3 },
	0xe0f5, { 0xE5, 0x83, 0x9B },
	0xe0f6, { 0xE5, 0x83, 0xAA },
	0xe0f7, { 0xE5, 0x83, 0x9D },
	0xe0f8, { 0xE5, 0x83, 0xA4 },
	0xe0f9, { 0xE5, 0x83, 0x93 },
	0xe0fa, { 0xE5, 0x83, 0xAC },
	0xe0fb, { 0xE5, 0x83, 0xB0 },
	0xe0fc, { 0xE5, 0x83, 0xAF },
	0xe0fd, { 0xE5, 0x83, 0xA3 },
	0xe0fe, { 0xE5, 0x83, 0xA0 },
	0xe140, { 0xE5, 0x87, 0x98 },
	0xe141, { 0xE5, 0x8A, 0x80 },
	0xe142, { 0xE5, 0x8A, 0x81 },
	0xe143, { 0xE5, 0x8B, 0xA9 },
	0xe144, { 0xE5, 0x8B, 0xAB },
	0xe145, { 0xE5, 0x8C, 0xB0 },
	0xe146, { 0xE5, 0x8E, 0xAC },
	0xe147, { 0xE5, 0x98, 0xA7 },
	0xe148, { 0xE5, 0x98, 0x95 },
	0xe149, { 0xE5, 0x98, 0x8C },
	0xe14a, { 0xE5, 0x98, 0x92 },
	0xe14b, { 0xE5, 0x97, 0xBC },
	0xe14c, { 0xE5, 0x98, 0x8F },
	0xe14d, { 0xE5, 0x98, 0x9C },
	0xe14e, { 0xE5, 0x98, 0x81 },
	0xe14f, { 0xE5, 0x98, 0x93 },
	0xe150, { 0xE5, 0x98, 0x82 },
	0xe151, { 0xE5, 0x97, 0xBA },
	0xe152, { 0xE5, 0x98, 0x9D },
	0xe153, { 0xE5, 0x98, 0x84 },
	0xe154, { 0xE5, 0x97, 0xBF },
	0xe155, { 0xE5, 0x97, 0xB9 },
	0xe156, { 0xE5, 0xA2, 0x89 },
	0xe157, { 0xE5, 0xA1, 0xBC },
	0xe158, { 0xE5, 0xA2, 0x90 },
	0xe159, { 0xE5, 0xA2, 0x98 },
	0xe15a, { 0xE5, 0xA2, 0x86 },
	0xe15b, { 0xE5, 0xA2, 0x81 },
	0xe15c, { 0xE5, 0xA1, 0xBF },
	0xe15d, { 0xE5, 0xA1, 0xB4 },
	0xe15e, { 0xE5, 0xA2, 0x8B },
	0xe15f, { 0xE5, 0xA1, 0xBA },
	0xe160, { 0xE5, 0xA2, 0x87 },
	0xe161, { 0xE5, 0xA2, 0x91 },
	0xe162, { 0xE5, 0xA2, 0x8E },
	0xe163, { 0xE5, 0xA1, 0xB6 },
	0xe164, { 0xE5, 0xA2, 0x82 },
	0xe165, { 0xE5, 0xA2, 0x88 },
	0xe166, { 0xE5, 0xA1, 0xBB },
	0xe167, { 0xE5, 0xA2, 0x94 },
	0xe168, { 0xE5, 0xA2, 0x8F },
	0xe169, { 0xE5, 0xA3, 0xBE },
	0xe16a, { 0xE5, 0xA5, 0xAB },
	0xe16b, { 0xE5, 0xAB, 0x9C },
	0xe16c, { 0xE5, 0xAB, 0xAE },
	0xe16d, { 0xE5, 0xAB, 0xA5 },
	0xe16e, { 0xE5, 0xAB, 0x95 },
	0xe16f, { 0xE5, 0xAB, 0xAA },
	0xe170, { 0xE5, 0xAB, 0x9A },
	0xe171, { 0xE5, 0xAB, 0xAD },
	0xe172, { 0xE5, 0xAB, 0xAB },
	0xe173, { 0xE5, 0xAB, 0xB3 },
	0xe174, { 0xE5, 0xAB, 0xA2 },
	0xe175, { 0xE5, 0xAB, 0xA0 },
	0xe176, { 0xE5, 0xAB, 0x9B },
	0xe177, { 0xE5, 0xAB, 0xAC },
	0xe178, { 0xE5, 0xAB, 0x9E },
	0xe179, { 0xE5, 0xAB, 0x9D },
	0xe17a, { 0xE5, 0xAB, 0x99 },
	0xe17b, { 0xE5, 0xAB, 0xA8 },
	0xe17c, { 0xE5, 0xAB, 0x9F },
	0xe17d, { 0xE5, 0xAD, 0xB7 },
	0xe17e, { 0xE5, 0xAF, 0xA0 },
	0xe1a1, { 0xE5, 0xAF, 0xA3 },
	0xe1a2, { 0xE5, 0xB1, 0xA3 },
	0xe1a3, { 0xE5, 0xB6, 0x82 },
	0xe1a4, { 0xE5, 0xB6, 0x80 },
	0xe1a5, { 0xE5, 0xB5, 0xBD },
	0xe1a6, { 0xE5, 0xB6, 0x86 },
	0xe1a7, { 0xE5, 0xB5, 0xBA },
	0xe1a8, { 0xE5, 0xB6, 0x81 },
	0xe1a9, { 0xE5, 0xB5, 0xB7 },
	0xe1aa, { 0xE5, 0xB6, 0x8A },
	0xe1ab, { 0xE5, 0xB6, 0x89 },
	0xe1ac, { 0xE5, 0xB6, 0x88 },
	0xe1ad, { 0xE5, 0xB5, 0xBE },
	0xe1ae, { 0xE5, 0xB5, 0xBC },
	0xe1af, { 0xE5, 0xB6, 0x8D },
	0xe1b0, { 0xE5, 0xB5, 0xB9 },
	0xe1b1, { 0xE5, 0xB5, 0xBF },
	0xe1b2, { 0xE5, 0xB9, 0x98 },
	0xe1b3, { 0xE5, 0xB9, 0x99 },
	0xe1b4, { 0xE5, 0xB9, 0x93 },
	0xe1b5, { 0xE5, 0xBB, 0x98 },
	0xe1b6, { 0xE5, 0xBB, 0x91 },
	0xe1b7, { 0xE5, 0xBB, 0x97 },
	0xe1b8, { 0xE5, 0xBB, 0x8E },
	0xe1b9, { 0xE5, 0xBB, 0x9C },
	0xe1ba, { 0xE5, 0xBB, 0x95 },
	0xe1bb, { 0xE5, 0xBB, 0x99 },
	0xe1bc, { 0xE5, 0xBB, 0x92 },
	0xe1bd, { 0xE5, 0xBB, 0x94 },
	0xe1be, { 0xE5, 0xBD, 0x84 },
	0xe1bf, { 0xE5, 0xBD, 0x83 },
	0xe1c0, { 0xE5, 0xBD, 0xAF },
	0xe1c1, { 0xE5, 0xBE, 0xB6 },
	0xe1c2, { 0xE6, 0x84, 0xAC },
	0xe1c3, { 0xE6, 0x84, 0xA8 },
	0xe1c4, { 0xE6, 0x85, 0x81 },
	0xe1c5, { 0xE6, 0x85, 0x9E },
	0xe1c6, { 0xE6, 0x85, 0xB1 },
	0xe1c7, { 0xE6, 0x85, 0xB3 },
	0xe1c8, { 0xE6, 0x85, 0x92 },
	0xe1c9, { 0xE6, 0x85, 0x93 },
	0xe1ca, { 0xE6, 0x85, 0xB2 },
	0xe1cb, { 0xE6, 0x85, 0xAC },
	0xe1cc, { 0xE6, 0x86, 0x80 },
	0xe1cd, { 0xE6, 0x85, 0xB4 },
	0xe1ce, { 0xE6, 0x85, 0x94 },
	0xe1cf, { 0xE6, 0x85, 0xBA },
	0xe1d0, { 0xE6, 0x85, 0x9B },
	0xe1d1, { 0xE6, 0x85, 0xA5 },
	0xe1d2, { 0xE6, 0x84, 0xBB },
	0xe1d3, { 0xE6, 0x85, 0xAA },
	0xe1d4, { 0xE6, 0x85, 0xA1 },
	0xe1d5, { 0xE6, 0x85, 0x96 },
	0xe1d6, { 0xE6, 0x88, 0xA9 },
	0xe1d7, { 0xE6, 0x88, 0xA7 },
	0xe1d8, { 0xE6, 0x88, 0xAB },
	0xe1d9, { 0xE6, 0x90, 0xAB },
	0xe1da, { 0xE6, 0x91, 0x8D },
	0xe1db, { 0xE6, 0x91, 0x9B },
	0xe1dc, { 0xE6, 0x91, 0x9D },
	0xe1dd, { 0xE6, 0x91, 0xB4 },
	0xe1de, { 0xE6, 0x91, 0xB6 },
	0xe1df, { 0xE6, 0x91, 0xB2 },
	0xe1e0, { 0xE6, 0x91, 0xB3 },
	0xe1e1, { 0xE6, 0x91, 0xBD },
	0xe1e2, { 0xE6, 0x91, 0xB5 },
	0xe1e3, { 0xE6, 0x91, 0xA6 },
	0xe1e4, { 0xE6, 0x92, 0xA6 },
	0xe1e5, { 0xE6, 0x91, 0x8E },
	0xe1e6, { 0xE6, 0x92, 0x82 },
	0xe1e7, { 0xE6, 0x91, 0x9E },
	0xe1e8, { 0xE6, 0x91, 0x9C },
	0xe1e9, { 0xE6, 0x91, 0x8B },
	0xe1ea, { 0xE6, 0x91, 0x93 },
	0xe1eb, { 0xE6, 0x91, 0xA0 },
	0xe1ec, { 0xE6, 0x91, 0x90 },
	0xe1ed, { 0xE6, 0x91, 0xBF },
	0xe1ee, { 0xE6, 0x90, 0xBF },
	0xe1ef, { 0xE6, 0x91, 0xAC },
	0xe1f0, { 0xE6, 0x91, 0xAB },
	0xe1f1, { 0xE6, 0x91, 0x99 },
	0xe1f2, { 0xE6, 0x91, 0xA5 },
	0xe1f3, { 0xE6, 0x91, 0xB7 },
	0xe1f4, { 0xE6, 0x95, 0xB3 },
	0xe1f5, { 0xE6, 0x96, 0xA0 },
	0xe1f6, { 0xE6, 0x9A, 0xA1 },
	0xe1f7, { 0xE6, 0x9A, 0xA0 },
	0xe1f8, { 0xE6, 0x9A, 0x9F },
	0xe1f9, { 0xE6, 0x9C, 0x85 },
	0xe1fa, { 0xE6, 0x9C, 0x84 },
	0xe1fb, { 0xE6, 0x9C, 0xA2 },
	0xe1fc, { 0xE6, 0xA6, 0xB1 },
	0xe1fd, { 0xE6, 0xA6, 0xB6 },
	0xe1fe, { 0xE6, 0xA7, 0x89 },
	0xe240, { 0xE6, 0xA6, 0xA0 },
	0xe241, { 0xE6, 0xA7, 0x8E },
	0xe242, { 0xE6, 0xA6, 0x96 },
	0xe243, { 0xE6, 0xA6, 0xB0 },
	0xe244, { 0xE6, 0xA6, 0xAC },
	0xe245, { 0xE6, 0xA6, 0xBC },
	0xe246, { 0xE6, 0xA6, 0x91 },
	0xe247, { 0xE6, 0xA6, 0x99 },
	0xe248, { 0xE6, 0xA6, 0x8E },
	0xe249, { 0xE6, 0xA6, 0xA7 },
	0xe24a, { 0xE6, 0xA6, 0x8D },
	0xe24b, { 0xE6, 0xA6, 0xA9 },
	0xe24c, { 0xE6, 0xA6, 0xBE },
	0xe24d, { 0xE6, 0xA6, 0xAF },
	0xe24e, { 0xE6, 0xA6, 0xBF },
	0xe24f, { 0xE6, 0xA7, 0x84 },
	0xe250, { 0xE6, 0xA6, 0xBD },
	0xe251, { 0xE6, 0xA6, 0xA4 },
	0xe252, { 0xE6, 0xA7, 0x94 },
	0xe253, { 0xE6, 0xA6, 0xB9 },
	0xe254, { 0xE6, 0xA7, 0x8A },
	0xe255, { 0xE6, 0xA6, 0x9A },
	0xe256, { 0xE6, 0xA7, 0x8F },
	0xe257, { 0xE6, 0xA6, 0xB3 },
	0xe258, { 0xE6, 0xA6, 0x93 },
	0xe259, { 0xE6, 0xA6, 0xAA },
	0xe25a, { 0xE6, 0xA6, 0xA1 },
	0xe25b, { 0xE6, 0xA6, 0x9E },
	0xe25c, { 0xE6, 0xA7, 0x99 },
	0xe25d, { 0xE6, 0xA6, 0x97 },
	0xe25e, { 0xE6, 0xA6, 0x90 },
	0xe25f, { 0xE6, 0xA7, 0x82 },
	0xe260, { 0xE6, 0xA6, 0xB5 },
	0xe261, { 0xE6, 0xA6, 0xA5 },
	0xe262, { 0xE6, 0xA7, 0x86 },
	0xe263, { 0xE6, 0xAD, 0x8A },
	0xe264, { 0xE6, 0xAD, 0x8D },
	0xe265, { 0xE6, 0xAD, 0x8B },
	0xe266, { 0xE6, 0xAE, 0x9E },
	0xe267, { 0xE6, 0xAE, 0x9F },
	0xe268, { 0xE6, 0xAE, 0xA0 },
	0xe269, { 0xE6, 0xAF, 0x83 },
	0xe26a, { 0xE6, 0xAF, 0x84 },
	0xe26b, { 0xE6, 0xAF, 0xBE },
	0xe26c, { 0xE6, 0xBB, 0x8E },
	0xe26d, { 0xE6, 0xBB, 0xB5 },
	0xe26e, { 0xE6, 0xBB, 0xB1 },
	0xe26f, { 0xE6, 0xBC, 0x83 },
	0xe270, { 0xE6, 0xBC, 0xA5 },
	0xe271, { 0xE6, 0xBB, 0xB8 },
	0xe272, { 0xE6, 0xBC, 0xB7 },
	0xe273, { 0xE6, 0xBB, 0xBB },
	0xe274, { 0xE6, 0xBC, 0xAE },
	0xe275, { 0xE6, 0xBC, 0x89 },
	0xe276, { 0xE6, 0xBD, 0x8E },
	0xe277, { 0xE6, 0xBC, 0x99 },
	0xe278, { 0xE6, 0xBC, 0x9A },
	0xe279, { 0xE6, 0xBC, 0xA7 },
	0xe27a, { 0xE6, 0xBC, 0x98 },
	0xe27b, { 0xE6, 0xBC, 0xBB },
	0xe27c, { 0xE6, 0xBC, 0x92 },
	0xe27d, { 0xE6, 0xBB, 0xAD },
	0xe27e, { 0xE6, 0xBC, 0x8A },
	0xe2a1, { 0xE6, 0xBC, 0xB6 },
	0xe2a2, { 0xE6, 0xBD, 0xB3 },
	0xe2a3, { 0xE6, 0xBB, 0xB9 },
	0xe2a4, { 0xE6, 0xBB, 0xAE },
	0xe2a5, { 0xE6, 0xBC, 0xAD },
	0xe2a6, { 0xE6, 0xBD, 0x80 },
	0xe2a7, { 0xE6, 0xBC, 0xB0 },
	0xe2a8, { 0xE6, 0xBC, 0xBC },
	0xe2a9, { 0xE6, 0xBC, 0xB5 },
	0xe2aa, { 0xE6, 0xBB, 0xAB },
	0xe2ab, { 0xE6, 0xBC, 0x87 },
	0xe2ac, { 0xE6, 0xBC, 0x8E },
	0xe2ad, { 0xE6, 0xBD, 0x83 },
	0xe2ae, { 0xE6, 0xBC, 0x85 },
	0xe2af, { 0xE6, 0xBB, 0xBD },
	0xe2b0, { 0xE6, 0xBB, 0xB6 },
	0xe2b1, { 0xE6, 0xBC, 0xB9 },
	0xe2b2, { 0xE6, 0xBC, 0x9C },
	0xe2b3, { 0xE6, 0xBB, 0xBC },
	0xe2b4, { 0xE6, 0xBC, 0xBA },
	0xe2b5, { 0xE6, 0xBC, 0x9F },
	0xe2b6, { 0xE6, 0xBC, 0x8D },
	0xe2b7, { 0xE6, 0xBC, 0x9E },
	0xe2b8, { 0xE6, 0xBC, 0x88 },
	0xe2b9, { 0xE6, 0xBC, 0xA1 },
	0xe2ba, { 0xE7, 0x86, 0x87 },
	0xe2bb, { 0xE7, 0x86, 0x90 },
	0xe2bc, { 0xE7, 0x86, 0x89 },
	0xe2bd, { 0xE7, 0x86, 0x80 },
	0xe2be, { 0xE7, 0x86, 0x85 },
	0xe2bf, { 0xE7, 0x86, 0x82 },
	0xe2c0, { 0xE7, 0x86, 0x8F },
	0xe2c1, { 0xE7, 0x85, 0xBB },
	0xe2c2, { 0xE7, 0x86, 0x86 },
	0xe2c3, { 0xE7, 0x86, 0x81 },
	0xe2c4, { 0xE7, 0x86, 0x97 },
	0xe2c5, { 0xE7, 0x89, 0x84 },
	0xe2c6, { 0xE7, 0x89, 0x93 },
	0xe2c7, { 0xE7, 0x8A, 0x97 },
	0xe2c8, { 0xE7, 0x8A, 0x95 },
	0xe2c9, { 0xE7, 0x8A, 0x93 },
	0xe2ca, { 0xE7, 0x8D, 0x83 },
	0xe2cb, { 0xE7, 0x8D, 0x8D },
	0xe2cc, { 0xE7, 0x8D, 0x91 },
	0xe2cd, { 0xE7, 0x8D, 0x8C },
	0xe2ce, { 0xE7, 0x91, 0xA2 },
	0xe2cf, { 0xE7, 0x91, 0xB3 },
	0xe2d0, { 0xE7, 0x91, 0xB1 },
	0xe2d1, { 0xE7, 0x91, 0xB5 },
	0xe2d2, { 0xE7, 0x91, 0xB2 },
	0xe2d3, { 0xE7, 0x91, 0xA7 },
	0xe2d4, { 0xE7, 0x91, 0xAE },
	0xe2d5, { 0xE7, 0x94, 0x80 },
	0xe2d6, { 0xE7, 0x94, 0x82 },
	0xe2d7, { 0xE7, 0x94, 0x83 },
	0xe2d8, { 0xE7, 0x95, 0xBD },
	0xe2d9, { 0xE7, 0x96, 0x90 },
	0xe2da, { 0xE7, 0x98, 0x96 },
	0xe2db, { 0xE7, 0x98, 0x88 },
	0xe2dc, { 0xE7, 0x98, 0x8C },
	0xe2dd, { 0xE7, 0x98, 0x95 },
	0xe2de, { 0xE7, 0x98, 0x91 },
	0xe2df, { 0xE7, 0x98, 0x8A },
	0xe2e0, { 0xE7, 0x98, 0x94 },
	0xe2e1, { 0xE7, 0x9A, 0xB8 },
	0xe2e2, { 0xE7, 0x9E, 0x81 },
	0xe2e3, { 0xE7, 0x9D, 0xBC },
	0xe2e4, { 0xE7, 0x9E, 0x85 },
	0xe2e5, { 0xE7, 0x9E, 0x82 },
	0xe2e6, { 0xE7, 0x9D, 0xAE },
	0xe2e7, { 0xE7, 0x9E, 0x80 },
	0xe2e8, { 0xE7, 0x9D, 0xAF },
	0xe2e9, { 0xE7, 0x9D, 0xBE },
	0xe2ea, { 0xE7, 0x9E, 0x83 },
	0xe2eb, { 0xE7, 0xA2, 0xB2 },
	0xe2ec, { 0xE7, 0xA2, 0xAA },
	0xe2ed, { 0xE7, 0xA2, 0xB4 },
	0xe2ee, { 0xE7, 0xA2, 0xAD },
	0xe2ef, { 0xE7, 0xA2, 0xA8 },
	0xe2f0, { 0xE7, 0xA1, 0xBE },
	0xe2f1, { 0xE7, 0xA2, 0xAB },
	0xe2f2, { 0xE7, 0xA2, 0x9E },
	0xe2f3, { 0xE7, 0xA2, 0xA5 },
	0xe2f4, { 0xE7, 0xA2, 0xA0 },
	0xe2f5, { 0xE7, 0xA2, 0xAC },
	0xe2f6, { 0xE7, 0xA2, 0xA2 },
	0xe2f7, { 0xE7, 0xA2, 0xA4 },
	0xe2f8, { 0xE7, 0xA6, 0x98 },
	0xe2f9, { 0xE7, 0xA6, 0x8A },
	0xe2fa, { 0xE7, 0xA6, 0x8B },
	0xe2fb, { 0xE7, 0xA6, 0x96 },
	0xe2fc, { 0xE7, 0xA6, 0x95 },
	0xe2fd, { 0xE7, 0xA6, 0x94 },
	0xe2fe, { 0xE7, 0xA6, 0x93 },
	0xe340, { 0xE7, 0xA6, 0x97 },
	0xe341, { 0xE7, 0xA6, 0x88 },
	0xe342, { 0xE7, 0xA6, 0x92 },
	0xe343, { 0xE7, 0xA6, 0x90 },
	0xe344, { 0xE7, 0xA8, 0xAB },
	0xe345, { 0xE7, 0xA9, 0x8A },
	0xe346, { 0xE7, 0xA8, 0xB0 },
	0xe347, { 0xE7, 0xA8, 0xAF },
	0xe348, { 0xE7, 0xA8, 0xA8 },
	0xe349, { 0xE7, 0xA8, 0xA6 },
	0xe34a, { 0xE7, 0xAA, 0xA8 },
	0xe34b, { 0xE7, 0xAA, 0xAB },
	0xe34c, { 0xE7, 0xAA, 0xAC },
	0xe34d, { 0xE7, 0xAB, 0xAE },
	0xe34e, { 0xE7, 0xAE, 0x88 },
	0xe34f, { 0xE7, 0xAE, 0x9C },
	0xe350, { 0xE7, 0xAE, 0x8A },
	0xe351, { 0xE7, 0xAE, 0x91 },
	0xe352, { 0xE7, 0xAE, 0x90 },
	0xe353, { 0xE7, 0xAE, 0x96 },
	0xe354, { 0xE7, 0xAE, 0x8D },
	0xe355, { 0xE7, 0xAE, 0x8C },
	0xe356, { 0xE7, 0xAE, 0x9B },
	0xe357, { 0xE7, 0xAE, 0x8E },
	0xe358, { 0xE7, 0xAE, 0x85 },
	0xe359, { 0xE7, 0xAE, 0x98 },
	0xe35a, { 0xE5, 0x8A, 0x84 },
	0xe35b, { 0xE7, 0xAE, 0x99 },
	0xe35c, { 0xE7, 0xAE, 0xA4 },
	0xe35d, { 0xE7, 0xAE, 0x82 },
	0xe35e, { 0xE7, 0xB2, 0xBB },
	0xe35f, { 0xE7, 0xB2, 0xBF },
	0xe360, { 0xE7, 0xB2, 0xBC },
	0xe361, { 0xE7, 0xB2, 0xBA },
	0xe362, { 0xE7, 0xB6, 0xA7 },
	0xe363, { 0xE7, 0xB6, 0xB7 },
	0xe364, { 0xE7, 0xB7, 0x82 },
	0xe365, { 0xE7, 0xB6, 0xA3 },
	0xe366, { 0xE7, 0xB6, 0xAA },
	0xe367, { 0xE7, 0xB7, 0x81 },
	0xe368, { 0xE7, 0xB7, 0x80 },
	0xe369, { 0xE7, 0xB7, 0x85 },
	0xe36a, { 0xE7, 0xB6, 0x9D },
	0xe36b, { 0xE7, 0xB7, 0x8E },
	0xe36c, { 0xE7, 0xB7, 0x84 },
	0xe36d, { 0xE7, 0xB7, 0x86 },
	0xe36e, { 0xE7, 0xB7, 0x8B },
	0xe36f, { 0xE7, 0xB7, 0x8C },
	0xe370, { 0xE7, 0xB6, 0xAF },
	0xe371, { 0xE7, 0xB6, 0xB9 },
	0xe372, { 0xE7, 0xB6, 0x96 },
	0xe373, { 0xE7, 0xB6, 0xBC },
	0xe374, { 0xE7, 0xB6, 0x9F },
	0xe375, { 0xE7, 0xB6, 0xA6 },
	0xe376, { 0xE7, 0xB6, 0xAE },
	0xe377, { 0xE7, 0xB6, 0xA9 },
	0xe378, { 0xE7, 0xB6, 0xA1 },
	0xe379, { 0xE7, 0xB7, 0x89 },
	0xe37a, { 0xE7, 0xBD, 0xB3 },
	0xe37b, { 0xE7, 0xBF, 0xA2 },
	0xe37c, { 0xE7, 0xBF, 0xA3 },
	0xe37d, { 0xE7, 0xBF, 0xA5 },
	0xe37e, { 0xE7, 0xBF, 0x9E },
	0xe3a1, { 0xE8, 0x80, 0xA4 },
	0xe3a2, { 0xE8, 0x81, 0x9D },
	0xe3a3, { 0xE8, 0x81, 0x9C },
	0xe3a4, { 0xE8, 0x86, 0x89 },
	0xe3a5, { 0xE8, 0x86, 0x86 },
	0xe3a6, { 0xE8, 0x86, 0x83 },
	0xe3a7, { 0xE8, 0x86, 0x87 },
	0xe3a8, { 0xE8, 0x86, 0x8D },
	0xe3a9, { 0xE8, 0x86, 0x8C },
	0xe3aa, { 0xE8, 0x86, 0x8B },
	0xe3ab, { 0xE8, 0x88, 0x95 },
	0xe3ac, { 0xE8, 0x92, 0x97 },
	0xe3ad, { 0xE8, 0x92, 0xA4 },
	0xe3ae, { 0xE8, 0x92, 0xA1 },
	0xe3af, { 0xE8, 0x92, 0x9F },
	0xe3b0, { 0xE8, 0x92, 0xBA },
	0xe3b1, { 0xE8, 0x93, 0x8E },
	0xe3b2, { 0xE8, 0x93, 0x82 },
	0xe3b3, { 0xE8, 0x92, 0xAC },
	0xe3b4, { 0xE8, 0x92, 0xAE },
	0xe3b5, { 0xE8, 0x92, 0xAB },
	0xe3b6, { 0xE8, 0x92, 0xB9 },
	0xe3b7, { 0xE8, 0x92, 0xB4 },
	0xe3b8, { 0xE8, 0x93, 0x81 },
	0xe3b9, { 0xE8, 0x93, 0x8D },
	0xe3ba, { 0xE8, 0x92, 0xAA },
	0xe3bb, { 0xE8, 0x92, 0x9A },
	0xe3bc, { 0xE8, 0x92, 0xB1 },
	0xe3bd, { 0xE8, 0x93, 0x90 },
	0xe3be, { 0xE8, 0x92, 0x9D },
	0xe3bf, { 0xE8, 0x92, 0xA7 },
	0xe3c0, { 0xE8, 0x92, 0xBB },
	0xe3c1, { 0xE8, 0x92, 0xA2 },
	0xe3c2, { 0xE8, 0x92, 0x94 },
	0xe3c3, { 0xE8, 0x93, 0x87 },
	0xe3c4, { 0xE8, 0x93, 0x8C },
	0xe3c5, { 0xE8, 0x92, 0x9B },
	0xe3c6, { 0xE8, 0x92, 0xA9 },
	0xe3c7, { 0xE8, 0x92, 0xAF },
	0xe3c8, { 0xE8, 0x92, 0xA8 },
	0xe3c9, { 0xE8, 0x93, 0x96 },
	0xe3ca, { 0xE8, 0x92, 0x98 },
	0xe3cb, { 0xE8, 0x92, 0xB6 },
	0xe3cc, { 0xE8, 0x93, 0x8F },
	0xe3cd, { 0xE8, 0x92, 0xA0 },
	0xe3ce, { 0xE8, 0x93, 0x97 },
	0xe3cf, { 0xE8, 0x93, 0x94 },
	0xe3d0, { 0xE8, 0x93, 0x92 },
	0xe3d1, { 0xE8, 0x93, 0x9B },
	0xe3d2, { 0xE8, 0x92, 0xB0 },
	0xe3d3, { 0xE8, 0x92, 0x91 },
	0xe3d4, { 0xE8, 0x99, 0xA1 },
	0xe3d5, { 0xE8, 0x9C, 0xB3 },
	0xe3d6, { 0xE8, 0x9C, 0xA3 },
	0xe3d7, { 0xE8, 0x9C, 0xA8 },
	0xe3d8, { 0xE8, 0x9D, 0xAB },
	0xe3d9, { 0xE8, 0x9D, 0x80 },
	0xe3da, { 0xE8, 0x9C, 0xAE },
	0xe3db, { 0xE8, 0x9C, 0x9E },
	0xe3dc, { 0xE8, 0x9C, 0xA1 },
	0xe3dd, { 0xE8, 0x9C, 0x99 },
	0xe3de, { 0xE8, 0x9C, 0x9B },
	0xe3df, { 0xE8, 0x9D, 0x83 },
	0xe3e0, { 0xE8, 0x9C, 0xAC },
	0xe3e1, { 0xE8, 0x9D, 0x81 },
	0xe3e2, { 0xE8, 0x9C, 0xBE },
	0xe3e3, { 0xE8, 0x9D, 0x86 },
	0xe3e4, { 0xE8, 0x9C, 0xA0 },
	0xe3e5, { 0xE8, 0x9C, 0xB2 },
	0xe3e6, { 0xE8, 0x9C, 0xAA },
	0xe3e7, { 0xE8, 0x9C, 0xAD },
	0xe3e8, { 0xE8, 0x9C, 0xBC },
	0xe3e9, { 0xE8, 0x9C, 0x92 },
	0xe3ea, { 0xE8, 0x9C, 0xBA },
	0xe3eb, { 0xE8, 0x9C, 0xB1 },
	0xe3ec, { 0xE8, 0x9C, 0xB5 },
	0xe3ed, { 0xE8, 0x9D, 0x82 },
	0xe3ee, { 0xE8, 0x9C, 0xA6 },
	0xe3ef, { 0xE8, 0x9C, 0xA7 },
	0xe3f0, { 0xE8, 0x9C, 0xB8 },
	0xe3f1, { 0xE8, 0x9C, 0xA4 },
	0xe3f2, { 0xE8, 0x9C, 0x9A },
	0xe3f3, { 0xE8, 0x9C, 0xB0 },
	0xe3f4, { 0xE8, 0x9C, 0x91 },
	0xe3f5, { 0xE8, 0xA3, 0xB7 },
	0xe3f6, { 0xE8, 0xA3, 0xA7 },
	0xe3f7, { 0xE8, 0xA3, 0xB1 },
	0xe3f8, { 0xE8, 0xA3, 0xB2 },
	0xe3f9, { 0xE8, 0xA3, 0xBA },
	0xe3fa, { 0xE8, 0xA3, 0xBE },
	0xe3fb, { 0xE8, 0xA3, 0xAE },
	0xe3fc, { 0xE8, 0xA3, 0xBC },
	0xe3fd, { 0xE8, 0xA3, 0xB6 },
	0xe3fe, { 0xE8, 0xA3, 0xBB },
	0xe440, { 0xE8, 0xA3, 0xB0 },
	0xe441, { 0xE8, 0xA3, 0xAC },
	0xe442, { 0xE8, 0xA3, 0xAB },
	0xe443, { 0xE8, 0xA6, 0x9D },
	0xe444, { 0xE8, 0xA6, 0xA1 },
	0xe445, { 0xE8, 0xA6, 0x9F },
	0xe446, { 0xE8, 0xA6, 0x9E },
	0xe447, { 0xE8, 0xA7, 0xA9 },
	0xe448, { 0xE8, 0xA7, 0xAB },
	0xe449, { 0xE8, 0xA7, 0xA8 },
	0xe44a, { 0xE8, 0xAA, 0xAB },
	0xe44b, { 0xE8, 0xAA, 0x99 },
	0xe44c, { 0xE8, 0xAA, 0x8B },
	0xe44d, { 0xE8, 0xAA, 0x92 },
	0xe44e, { 0xE8, 0xAA, 0x8F },
	0xe44f, { 0xE8, 0xAA, 0x96 },
	0xe450, { 0xE8, 0xB0, 0xBD },
	0xe451, { 0xE8, 0xB1, 0xA8 },
	0xe452, { 0xE8, 0xB1, 0xA9 },
	0xe453, { 0xE8, 0xB3, 0x95 },
	0xe454, { 0xE8, 0xB3, 0x8F },
	0xe455, { 0xE8, 0xB3, 0x97 },
	0xe456, { 0xE8, 0xB6, 0x96 },
	0xe457, { 0xE8, 0xB8, 0x89 },
	0xe458, { 0xE8, 0xB8, 0x82 },
	0xe459, { 0xE8, 0xB7, 0xBF },
	0xe45a, { 0xE8, 0xB8, 0x8D },
	0xe45b, { 0xE8, 0xB7, 0xBD },
	0xe45c, { 0xE8, 0xB8, 0x8A },
	0xe45d, { 0xE8, 0xB8, 0x83 },
	0xe45e, { 0xE8, 0xB8, 0x87 },
	0xe45f, { 0xE8, 0xB8, 0x86 },
	0xe460, { 0xE8, 0xB8, 0x85 },
	0xe461, { 0xE8, 0xB7, 0xBE },
	0xe462, { 0xE8, 0xB8, 0x80 },
	0xe463, { 0xE8, 0xB8, 0x84 },
	0xe464, { 0xE8, 0xBC, 0x90 },
	0xe465, { 0xE8, 0xBC, 0x91 },
	0xe466, { 0xE8, 0xBC, 0x8E },
	0xe467, { 0xE8, 0xBC, 0x8D },
	0xe468, { 0xE9, 0x84, 0xA3 },
	0xe469, { 0xE9, 0x84, 0x9C },
	0xe46a, { 0xE9, 0x84, 0xA0 },
	0xe46b, { 0xE9, 0x84, 0xA2 },
	0xe46c, { 0xE9, 0x84, 0x9F },
	0xe46d, { 0xE9, 0x84, 0x9D },
	0xe46e, { 0xE9, 0x84, 0x9A },
	0xe46f, { 0xE9, 0x84, 0xA4 },
	0xe470, { 0xE9, 0x84, 0xA1 },
	0xe471, { 0xE9, 0x84, 0x9B },
	0xe472, { 0xE9, 0x85, 0xBA },
	0xe473, { 0xE9, 0x85, 0xB2 },
	0xe474, { 0xE9, 0x85, 0xB9 },
	0xe475, { 0xE9, 0x85, 0xB3 },
	0xe476, { 0xE9, 0x8A, 0xA5 },
	0xe477, { 0xE9, 0x8A, 0xA4 },
	0xe478, { 0xE9, 0x89, 0xB6 },
	0xe479, { 0xE9, 0x8A, 0x9B },
	0xe47a, { 0xE9, 0x89, 0xBA },
	0xe47b, { 0xE9, 0x8A, 0xA0 },
	0xe47c, { 0xE9, 0x8A, 0x94 },
	0xe47d, { 0xE9, 0x8A, 0xAA },
	0xe47e, { 0xE9, 0x8A, 0x8D },
	0xe4a1, { 0xE9, 0x8A, 0xA6 },
	0xe4a2, { 0xE9, 0x8A, 0x9A },
	0xe4a3, { 0xE9, 0x8A, 0xAB },
	0xe4a4, { 0xE9, 0x89, 0xB9 },
	0xe4a5, { 0xE9, 0x8A, 0x97 },
	0xe4a6, { 0xE9, 0x89, 0xBF },
	0xe4a7, { 0xE9, 0x8A, 0xA3 },
	0xe4a8, { 0xE9, 0x8B, 0xAE },
	0xe4a9, { 0xE9, 0x8A, 0x8E },
	0xe4aa, { 0xE9, 0x8A, 0x82 },
	0xe4ab, { 0xE9, 0x8A, 0x95 },
	0xe4ac, { 0xE9, 0x8A, 0xA2 },
	0xe4ad, { 0xE9, 0x89, 0xBD },
	0xe4ae, { 0xE9, 0x8A, 0x88 },
	0xe4af, { 0xE9, 0x8A, 0xA1 },
	0xe4b0, { 0xE9, 0x8A, 0x8A },
	0xe4b1, { 0xE9, 0x8A, 0x86 },
	0xe4b2, { 0xE9, 0x8A, 0x8C },
	0xe4b3, { 0xE9, 0x8A, 0x99 },
	0xe4b4, { 0xE9, 0x8A, 0xA7 },
	0xe4b5, { 0xE9, 0x89, 0xBE },
	0xe4b6, { 0xE9, 0x8A, 0x87 },
	0xe4b7, { 0xE9, 0x8A, 0xA9 },
	0xe4b8, { 0xE9, 0x8A, 0x9D },
	0xe4b9, { 0xE9, 0x8A, 0x8B },
	0xe4ba, { 0xE9, 0x88, 0xAD },
	0xe4bb, { 0xE9, 0x9A, 0x9E },
	0xe4bc, { 0xE9, 0x9A, 0xA1 },
	0xe4bd, { 0xE9, 0x9B, 0xBF },
	0xe4be, { 0xE9, 0x9D, 0x98 },
	0xe4bf, { 0xE9, 0x9D, 0xBD },
	0xe4c0, { 0xE9, 0x9D, 0xBA },
	0xe4c1, { 0xE9, 0x9D, 0xBE },
	0xe4c2, { 0xE9, 0x9E, 0x83 },
	0xe4c3, { 0xE9, 0x9E, 0x80 },
	0xe4c4, { 0xE9, 0x9E, 0x82 },
	0xe4c5, { 0xE9, 0x9D, 0xBB },
	0xe4c6, { 0xE9, 0x9E, 0x84 },
	0xe4c7, { 0xE9, 0x9E, 0x81 },
	0xe4c8, { 0xE9, 0x9D, 0xBF },
	0xe4c9, { 0xE9, 0x9F, 0x8E },
	0xe4ca, { 0xE9, 0x9F, 0x8D },
	0xe4cb, { 0xE9, 0xA0, 0x96 },
	0xe4cc, { 0xE9, 0xA2, 0xAD },
	0xe4cd, { 0xE9, 0xA2, 0xAE },
	0xe4ce, { 0xE9, 0xA4, 0x82 },
	0xe4cf, { 0xE9, 0xA4, 0x80 },
	0xe4d0, { 0xE9, 0xA4, 0x87 },
	0xe4d1, { 0xE9, 0xA6, 0x9D },
	0xe4d2, { 0xE9, 0xA6, 0x9C },
	0xe4d3, { 0xE9, 0xA7, 0x83 },
	0xe4d4, { 0xE9, 0xA6, 0xB9 },
	0xe4d5, { 0xE9, 0xA6, 0xBB },
	0xe4d6, { 0xE9, 0xA6, 0xBA },
	0xe4d7, { 0xE9, 0xA7, 0x82 },
	0xe4d8, { 0xE9, 0xA6, 0xBD },
	0xe4d9, { 0xE9, 0xA7, 0x87 },
	0xe4da, { 0xE9, 0xAA, 0xB1 },
	0xe4db, { 0xE9, 0xAB, 0xA3 },
	0xe4dc, { 0xE9, 0xAB, 0xA7 },
	0xe4dd, { 0xE9, 0xAC, 0xBE },
	0xe4de, { 0xE9, 0xAC, 0xBF },
	0xe4df, { 0xE9, 0xAD, 0xA0 },
	0xe4e0, { 0xE9, 0xAD, 0xA1 },
	0xe4e1, { 0xE9, 0xAD, 0x9F },
	0xe4e2, { 0xE9, 0xB3, 0xB1 },
	0xe4e3, { 0xE9, 0xB3, 0xB2 },
	0xe4e4, { 0xE9, 0xB3, 0xB5 },
	0xe4e5, { 0xE9, 0xBA, 0xA7 },
	0xe4e6, { 0xE5, 0x83, 0xBF },
	0xe4e7, { 0xE5, 0x84, 0x83 },
	0xe4e8, { 0xE5, 0x84, 0xB0 },
	0xe4e9, { 0xE5, 0x83, 0xB8 },
	0xe4ea, { 0xE5, 0x84, 0x86 },
	0xe4eb, { 0xE5, 0x84, 0x87 },
	0xe4ec, { 0xE5, 0x83, 0xB6 },
	0xe4ed, { 0xE5, 0x83, 0xBE },
	0xe4ee, { 0xE5, 0x84, 0x8B },
	0xe4ef, { 0xE5, 0x84, 0x8C },
	0xe4f0, { 0xE5, 0x83, 0xBD },
	0xe4f1, { 0xE5, 0x84, 0x8A },
	0xe4f2, { 0xE5, 0x8A, 0x8B },
	0xe4f3, { 0xE5, 0x8A, 0x8C },
	0xe4f4, { 0xE5, 0x8B, 0xB1 },
	0xe4f5, { 0xE5, 0x8B, 0xAF },
	0xe4f6, { 0xE5, 0x99, 0x88 },
	0xe4f7, { 0xE5, 0x99, 0x82 },
	0xe4f8, { 0xE5, 0x99, 0x8C },
	0xe4f9, { 0xE5, 0x98, 0xB5 },
	0xe4fa, { 0xE5, 0x99, 0x81 },
	0xe4fb, { 0xE5, 0x99, 0x8A },
	0xe4fc, { 0xE5, 0x99, 0x89 },
	0xe4fd, { 0xE5, 0x99, 0x86 },
	0xe4fe, { 0xE5, 0x99, 0x98 },
	0xe540, { 0xE5, 0x99, 0x9A },
	0xe541, { 0xE5, 0x99, 0x80 },
	0xe542, { 0xE5, 0x98, 0xB3 },
	0xe543, { 0xE5, 0x98, 0xBD },
	0xe544, { 0xE5, 0x98, 0xAC },
	0xe545, { 0xE5, 0x98, 0xBE },
	0xe546, { 0xE5, 0x98, 0xB8 },
	0xe547, { 0xE5, 0x98, 0xAA },
	0xe548, { 0xE5, 0x98, 0xBA },
	0xe549, { 0xE5, 0x9C, 0x9A },
	0xe54a, { 0xE5, 0xA2, 0xAB },
	0xe54b, { 0xE5, 0xA2, 0x9D },
	0xe54c, { 0xE5, 0xA2, 0xB1 },
	0xe54d, { 0xE5, 0xA2, 0xA0 },
	0xe54e, { 0xE5, 0xA2, 0xA3 },
	0xe54f, { 0xE5, 0xA2, 0xAF },
	0xe550, { 0xE5, 0xA2, 0xAC },
	0xe551, { 0xE5, 0xA2, 0xA5 },
	0xe552, { 0xE5, 0xA2, 0xA1 },
	0xe553, { 0xE5, 0xA3, 0xBF },
	0xe554, { 0xE5, 0xAB, 0xBF },
	0xe555, { 0xE5, 0xAB, 0xB4 },
	0xe556, { 0xE5, 0xAB, 0xBD },
	0xe557, { 0xE5, 0xAB, 0xB7 },
	0xe558, { 0xE5, 0xAB, 0xB6 },
	0xe559, { 0xE5, 0xAC, 0x83 },
	0xe55a, { 0xE5, 0xAB, 0xB8 },
	0xe55b, { 0xE5, 0xAC, 0x82 },
	0xe55c, { 0xE5, 0xAB, 0xB9 },
	0xe55d, { 0xE5, 0xAC, 0x81 },
	0xe55e, { 0xE5, 0xAC, 0x87 },
	0xe55f, { 0xE5, 0xAC, 0x85 },
	0xe560, { 0xE5, 0xAC, 0x8F },
	0xe561, { 0xE5, 0xB1, 0xA7 },
	0xe562, { 0xE5, 0xB6, 0x99 },
	0xe563, { 0xE5, 0xB6, 0x97 },
	0xe564, { 0xE5, 0xB6, 0x9F },
	0xe565, { 0xE5, 0xB6, 0x92 },
	0xe566, { 0xE5, 0xB6, 0xA2 },
	0xe567, { 0xE5, 0xB6, 0x93 },
	0xe568, { 0xE5, 0xB6, 0x95 },
	0xe569, { 0xE5, 0xB6, 0xA0 },
	0xe56a, { 0xE5, 0xB6, 0x9C },
	0xe56b, { 0xE5, 0xB6, 0xA1 },
	0xe56c, { 0xE5, 0xB6, 0x9A },
	0xe56d, { 0xE5, 0xB6, 0x9E },
	0xe56e, { 0xE5, 0xB9, 0xA9 },
	0xe56f, { 0xE5, 0xB9, 0x9D },
	0xe570, { 0xE5, 0xB9, 0xA0 },
	0xe571, { 0xE5, 0xB9, 0x9C },
	0xe572, { 0xE7, 0xB7, 0xB3 },
	0xe573, { 0xE5, 0xBB, 0x9B },
	0xe574, { 0xE5, 0xBB, 0x9E },
	0xe575, { 0xE5, 0xBB, 0xA1 },
	0xe576, { 0xE5, 0xBD, 0x89 },
	0xe577, { 0xE5, 0xBE, 0xB2 },
	0xe578, { 0xE6, 0x86, 0x8B },
	0xe579, { 0xE6, 0x86, 0x83 },
	0xe57a, { 0xE6, 0x85, 0xB9 },
	0xe57b, { 0xE6, 0x86, 0xB1 },
	0xe57c, { 0xE6, 0x86, 0xB0 },
	0xe57d, { 0xE6, 0x86, 0xA2 },
	0xe57e, { 0xE6, 0x86, 0x89 },
	0xe5a1, { 0xE6, 0x86, 0x9B },
	0xe5a2, { 0xE6, 0x86, 0x93 },
	0xe5a3, { 0xE6, 0x86, 0xAF },
	0xe5a4, { 0xE6, 0x86, 0xAD },
	0xe5a5, { 0xE6, 0x86, 0x9F },
	0xe5a6, { 0xE6, 0x86, 0x92 },
	0xe5a7, { 0xE6, 0x86, 0xAA },
	0xe5a8, { 0xE6, 0x86, 0xA1 },
	0xe5a9, { 0xE6, 0x86, 0x8D },
	0xe5aa, { 0xE6, 0x85, 0xA6 },
	0xe5ab, { 0xE6, 0x86, 0xB3 },
	0xe5ac, { 0xE6, 0x88, 0xAD },
	0xe5ad, { 0xE6, 0x91, 0xAE },
	0xe5ae, { 0xE6, 0x91, 0xB0 },
	0xe5af, { 0xE6, 0x92, 0x96 },
	0xe5b0, { 0xE6, 0x92, 0xA0 },
	0xe5b1, { 0xE6, 0x92, 0x85 },
	0xe5b2, { 0xE6, 0x92, 0x97 },
	0xe5b3, { 0xE6, 0x92, 0x9C },
	0xe5b4, { 0xE6, 0x92, 0x8F },
	0xe5b5, { 0xE6, 0x92, 0x8B },
	0xe5b6, { 0xE6, 0x92, 0x8A },
	0xe5b7, { 0xE6, 0x92, 0x8C },
	0xe5b8, { 0xE6, 0x92, 0xA3 },
	0xe5b9, { 0xE6, 0x92, 0x9F },
	0xe5ba, { 0xE6, 0x91, 0xA8 },
	0xe5bb, { 0xE6, 0x92, 0xB1 },
	0xe5bc, { 0xE6, 0x92, 0x98 },
	0xe5bd, { 0xE6, 0x95, 0xB6 },
	0xe5be, { 0xE6, 0x95, 0xBA },
	0xe5bf, { 0xE6, 0x95, 0xB9 },
	0xe5c0, { 0xE6, 0x95, 0xBB },
	0xe5c1, { 0xE6, 0x96, 0xB2 },
	0xe5c2, { 0xE6, 0x96, 0xB3 },
	0xe5c3, { 0xE6, 0x9A, 0xB5 },
	0xe5c4, { 0xE6, 0x9A, 0xB0 },
	0xe5c5, { 0xE6, 0x9A, 0xA9 },
	0xe5c6, { 0xE6, 0x9A, 0xB2 },
	0xe5c7, { 0xE6, 0x9A, 0xB7 },
	0xe5c8, { 0xE6, 0x9A, 0xAA },
	0xe5c9, { 0xE6, 0x9A, 0xAF },
	0xe5ca, { 0xE6, 0xA8, 0x80 },
	0xe5cb, { 0xE6, 0xA8, 0x86 },
	0xe5cc, { 0xE6, 0xA8, 0x97 },
	0xe5cd, { 0xE6, 0xA7, 0xA5 },
	0xe5ce, { 0xE6, 0xA7, 0xB8 },
	0xe5cf, { 0xE6, 0xA8, 0x95 },
	0xe5d0, { 0xE6, 0xA7, 0xB1 },
	0xe5d1, { 0xE6, 0xA7, 0xA4 },
	0xe5d2, { 0xE6, 0xA8, 0xA0 },
	0xe5d3, { 0xE6, 0xA7, 0xBF },
	0xe5d4, { 0xE6, 0xA7, 0xAC },
	0xe5d5, { 0xE6, 0xA7, 0xA2 },
	0xe5d6, { 0xE6, 0xA8, 0x9B },
	0xe5d7, { 0xE6, 0xA8, 0x9D },
	0xe5d8, { 0xE6, 0xA7, 0xBE },
	0xe5d9, { 0xE6, 0xA8, 0xA7 },
	0xe5da, { 0xE6, 0xA7, 0xB2 },
	0xe5db, { 0xE6, 0xA7, 0xAE },
	0xe5dc, { 0xE6, 0xA8, 0x94 },
	0xe5dd, { 0xE6, 0xA7, 0xB7 },
	0xe5de, { 0xE6, 0xA7, 0xA7 },
	0xe5df, { 0xE6, 0xA9, 0x80 },
	0xe5e0, { 0xE6, 0xA8, 0x88 },
	0xe5e1, { 0xE6, 0xA7, 0xA6 },
	0xe5e2, { 0xE6, 0xA7, 0xBB },
	0xe5e3, { 0xE6, 0xA8, 0x8D },
	0xe5e4, { 0xE6, 0xA7, 0xBC },
	0xe5e5, { 0xE6, 0xA7, 0xAB },
	0xe5e6, { 0xE6, 0xA8, 0x89 },
	0xe5e7, { 0xE6, 0xA8, 0x84 },
	0xe5e8, { 0xE6, 0xA8, 0x98 },
	0xe5e9, { 0xE6, 0xA8, 0xA5 },
	0xe5ea, { 0xE6, 0xA8, 0x8F },
	0xe5eb, { 0xE6, 0xA7, 0xB6 },
	0xe5ec, { 0xE6, 0xA8, 0xA6 },
	0xe5ed, { 0xE6, 0xA8, 0x87 },
	0xe5ee, { 0xE6, 0xA7, 0xB4 },
	0xe5ef, { 0xE6, 0xA8, 0x96 },
	0xe5f0, { 0xE6, 0xAD, 0x91 },
	0xe5f1, { 0xE6, 0xAE, 0xA5 },
	0xe5f2, { 0xE6, 0xAE, 0xA3 },
	0xe5f3, { 0xE6, 0xAE, 0xA2 },
	0xe5f4, { 0xE6, 0xAE, 0xA6 },
	0xe5f5, { 0xE6, 0xB0, 0x81 },
	0xe5f6, { 0xE6, 0xB0, 0x80 },
	0xe5f7, { 0xE6, 0xAF, 0xBF },
	0xe5f8, { 0xE6, 0xB0, 0x82 },
	0xe5f9, { 0xE6, 0xBD, 0x81 },
	0xe5fa, { 0xE6, 0xBC, 0xA6 },
	0xe5fb, { 0xE6, 0xBD, 0xBE },
	0xe5fc, { 0xE6, 0xBE, 0x87 },
	0xe5fd, { 0xE6, 0xBF, 0x86 },
	0xe5fe, { 0xE6, 0xBE, 0x92 },
	0xe640, { 0xE6, 0xBE, 0x8D },
	0xe641, { 0xE6, 0xBE, 0x89 },
	0xe642, { 0xE6, 0xBE, 0x8C },
	0xe643, { 0xE6, 0xBD, 0xA2 },
	0xe644, { 0xE6, 0xBD, 0x8F },
	0xe645, { 0xE6, 0xBE, 0x85 },
	0xe646, { 0xE6, 0xBD, 0x9A },
	0xe647, { 0xE6, 0xBE, 0x96 },
	0xe648, { 0xE6, 0xBD, 0xB6 },
	0xe649, { 0xE6, 0xBD, 0xAC },
	0xe64a, { 0xE6, 0xBE, 0x82 },
	0xe64b, { 0xE6, 0xBD, 0x95 },
	0xe64c, { 0xE6, 0xBD, 0xB2 },
	0xe64d, { 0xE6, 0xBD, 0x92 },
	0xe64e, { 0xE6, 0xBD, 0x90 },
	0xe64f, { 0xE6, 0xBD, 0x97 },
	0xe650, { 0xE6, 0xBE, 0x94 },
	0xe651, { 0xE6, 0xBE, 0x93 },
	0xe652, { 0xE6, 0xBD, 0x9D },
	0xe653, { 0xE6, 0xBC, 0x80 },
	0xe654, { 0xE6, 0xBD, 0xA1 },
	0xe655, { 0xE6, 0xBD, 0xAB },
	0xe656, { 0xE6, 0xBD, 0xBD },
	0xe657, { 0xE6, 0xBD, 0xA7 },
	0xe658, { 0xE6, 0xBE, 0x90 },
	0xe659, { 0xE6, 0xBD, 0x93 },
	0xe65a, { 0xE6, 0xBE, 0x8B },
	0xe65b, { 0xE6, 0xBD, 0xA9 },
	0xe65c, { 0xE6, 0xBD, 0xBF },
	0xe65d, { 0xE6, 0xBE, 0x95 },
	0xe65e, { 0xE6, 0xBD, 0xA3 },
	0xe65f, { 0xE6, 0xBD, 0xB7 },
	0xe660, { 0xE6, 0xBD, 0xAA },
	0xe661, { 0xE6, 0xBD, 0xBB },
	0xe662, { 0xE7, 0x86, 0xB2 },
	0xe663, { 0xE7, 0x86, 0xAF },
	0xe664, { 0xE7, 0x86, 0x9B },
	0xe665, { 0xE7, 0x86, 0xB0 },
	0xe666, { 0xE7, 0x86, 0xA0 },
	0xe667, { 0xE7, 0x86, 0x9A },
	0xe668, { 0xE7, 0x86, 0xA9 },
	0xe669, { 0xE7, 0x86, 0xB5 },
	0xe66a, { 0xE7, 0x86, 0x9D },
	0xe66b, { 0xE7, 0x86, 0xA5 },
	0xe66c, { 0xE7, 0x86, 0x9E },
	0xe66d, { 0xE7, 0x86, 0xA4 },
	0xe66e, { 0xE7, 0x86, 0xA1 },
	0xe66f, { 0xE7, 0x86, 0xAA },
	0xe670, { 0xE7, 0x86, 0x9C },
	0xe671, { 0xE7, 0x86, 0xA7 },
	0xe672, { 0xE7, 0x86, 0xB3 },
	0xe673, { 0xE7, 0x8A, 0x98 },
	0xe674, { 0xE7, 0x8A, 0x9A },
	0xe675, { 0xE7, 0x8D, 0x98 },
	0xe676, { 0xE7, 0x8D, 0x92 },
	0xe677, { 0xE7, 0x8D, 0x9E },
	0xe678, { 0xE7, 0x8D, 0x9F },
	0xe679, { 0xE7, 0x8D, 0xA0 },
	0xe67a, { 0xE7, 0x8D, 0x9D },
	0xe67b, { 0xE7, 0x8D, 0x9B },
	0xe67c, { 0xE7, 0x8D, 0xA1 },
	0xe67d, { 0xE7, 0x8D, 0x9A },
	0xe67e, { 0xE7, 0x8D, 0x99 },
	0xe6a1, { 0xE7, 0x8D, 0xA2 },
	0xe6a2, { 0xE7, 0x92, 0x87 },
	0xe6a3, { 0xE7, 0x92, 0x89 },
	0xe6a4, { 0xE7, 0x92, 0x8A },
	0xe6a5, { 0xE7, 0x92, 0x86 },
	0xe6a6, { 0xE7, 0x92, 0x81 },
	0xe6a7, { 0xE7, 0x91, 0xBD },
	0xe6a8, { 0xE7, 0x92, 0x85 },
	0xe6a9, { 0xE7, 0x92, 0x88 },
	0xe6aa, { 0xE7, 0x91, 0xBC },
	0xe6ab, { 0xE7, 0x91, 0xB9 },
	0xe6ac, { 0xE7, 0x94, 0x88 },
	0xe6ad, { 0xE7, 0x94, 0x87 },
	0xe6ae, { 0xE7, 0x95, 0xBE },
	0xe6af, { 0xE7, 0x98, 0xA5 },
	0xe6b0, { 0xE7, 0x98, 0x9E },
	0xe6b1, { 0xE7, 0x98, 0x99 },
	0xe6b2, { 0xE7, 0x98, 0x9D },
	0xe6b3, { 0xE7, 0x98, 0x9C },
	0xe6b4, { 0xE7, 0x98, 0xA3 },
	0xe6b5, { 0xE7, 0x98, 0x9A },
	0xe6b6, { 0xE7, 0x98, 0xA8 },
	0xe6b7, { 0xE7, 0x98, 0x9B },
	0xe6b8, { 0xE7, 0x9A, 0x9C },
	0xe6b9, { 0xE7, 0x9A, 0x9D },
	0xe6ba, { 0xE7, 0x9A, 0x9E },
	0xe6bb, { 0xE7, 0x9A, 0x9B },
	0xe6bc, { 0xE7, 0x9E, 0x8D },
	0xe6bd, { 0xE7, 0x9E, 0x8F },
	0xe6be, { 0xE7, 0x9E, 0x89 },
	0xe6bf, { 0xE7, 0x9E, 0x88 },
	0xe6c0, { 0xE7, 0xA3, 0x8D },
	0xe6c1, { 0xE7, 0xA2, 0xBB },
	0xe6c2, { 0xE7, 0xA3, 0x8F },
	0xe6c3, { 0xE7, 0xA3, 0x8C },
	0xe6c4, { 0xE7, 0xA3, 0x91 },
	0xe6c5, { 0xE7, 0xA3, 0x8E },
	0xe6c6, { 0xE7, 0xA3, 0x94 },
	0xe6c7, { 0xE7, 0xA3, 0x88 },
	0xe6c8, { 0xE7, 0xA3, 0x83 },
	0xe6c9, { 0xE7, 0xA3, 0x84 },
	0xe6ca, { 0xE7, 0xA3, 0x89 },
	0xe6cb, { 0xE7, 0xA6, 0x9A },
	0xe6cc, { 0xE7, 0xA6, 0xA1 },
	0xe6cd, { 0xE7, 0xA6, 0xA0 },
	0xe6ce, { 0xE7, 0xA6, 0x9C },
	0xe6cf, { 0xE7, 0xA6, 0xA2 },
	0xe6d0, { 0xE7, 0xA6, 0x9B },
	0xe6d1, { 0xE6, 0xAD, 0xB6 },
	0xe6d2, { 0xE7, 0xA8, 0xB9 },
	0xe6d3, { 0xE7, 0xAA, 0xB2 },
	0xe6d4, { 0xE7, 0xAA, 0xB4 },
	0xe6d5, { 0xE7, 0xAA, 0xB3 },
	0xe6d6, { 0xE7, 0xAE, 0xB7 },
	0xe6d7, { 0xE7, 0xAF, 0x8B },
	0xe6d8, { 0xE7, 0xAE, 0xBE },
	0xe6d9, { 0xE7, 0xAE, 0xAC },
	0xe6da, { 0xE7, 0xAF, 0x8E },
	0xe6db, { 0xE7, 0xAE, 0xAF },
	0xe6dc, { 0xE7, 0xAE, 0xB9 },
	0xe6dd, { 0xE7, 0xAF, 0x8A },
	0xe6de, { 0xE7, 0xAE, 0xB5 },
	0xe6df, { 0xE7, 0xB3, 0x85 },
	0xe6e0, { 0xE7, 0xB3, 0x88 },
	0xe6e1, { 0xE7, 0xB3, 0x8C },
	0xe6e2, { 0xE7, 0xB3, 0x8B },
	0xe6e3, { 0xE7, 0xB7, 0xB7 },
	0xe6e4, { 0xE7, 0xB7, 0x9B },
	0xe6e5, { 0xE7, 0xB7, 0xAA },
	0xe6e6, { 0xE7, 0xB7, 0xA7 },
	0xe6e7, { 0xE7, 0xB7, 0x97 },
	0xe6e8, { 0xE7, 0xB7, 0xA1 },
	0xe6e9, { 0xE7, 0xB8, 0x83 },
	0xe6ea, { 0xE7, 0xB7, 0xBA },
	0xe6eb, { 0xE7, 0xB7, 0xA6 },
	0xe6ec, { 0xE7, 0xB7, 0xB6 },
	0xe6ed, { 0xE7, 0xB7, 0xB1 },
	0xe6ee, { 0xE7, 0xB7, 0xB0 },
	0xe6ef, { 0xE7, 0xB7, 0xAE },
	0xe6f0, { 0xE7, 0xB7, 0x9F },
	0xe6f1, { 0xE7, 0xBD, 0xB6 },
	0xe6f2, { 0xE7, 0xBE, 0xAC },
	0xe6f3, { 0xE7, 0xBE, 0xB0 },
	0xe6f4, { 0xE7, 0xBE, 0xAD },
	0xe6f5, { 0xE7, 0xBF, 0xAD },
	0xe6f6, { 0xE7, 0xBF, 0xAB },
	0xe6f7, { 0xE7, 0xBF, 0xAA },
	0xe6f8, { 0xE7, 0xBF, 0xAC },
	0xe6f9, { 0xE7, 0xBF, 0xA6 },
	0xe6fa, { 0xE7, 0xBF, 0xA8 },
	0xe6fb, { 0xE8, 0x81, 0xA4 },
	0xe6fc, { 0xE8, 0x81, 0xA7 },
	0xe6fd, { 0xE8, 0x86, 0xA3 },
	0xe6fe, { 0xE8, 0x86, 0x9F },
	0xe740, { 0xE8, 0x86, 0x9E },
	0xe741, { 0xE8, 0x86, 0x95 },
	0xe742, { 0xE8, 0x86, 0xA2 },
	0xe743, { 0xE8, 0x86, 0x99 },
	0xe744, { 0xE8, 0x86, 0x97 },
	0xe745, { 0xE8, 0x88, 0x96 },
	0xe746, { 0xE8, 0x89, 0x8F },
	0xe747, { 0xE8, 0x89, 0x93 },
	0xe748, { 0xE8, 0x89, 0x92 },
	0xe749, { 0xE8, 0x89, 0x90 },
	0xe74a, { 0xE8, 0x89, 0x8E },
	0xe74b, { 0xE8, 0x89, 0x91 },
	0xe74c, { 0xE8, 0x94, 0xA4 },
	0xe74d, { 0xE8, 0x94, 0xBB },
	0xe74e, { 0xE8, 0x94, 0x8F },
	0xe74f, { 0xE8, 0x94, 0x80 },
	0xe750, { 0xE8, 0x94, 0xA9 },
	0xe751, { 0xE8, 0x94, 0x8E },
	0xe752, { 0xE8, 0x94, 0x89 },
	0xe753, { 0xE8, 0x94, 0x8D },
	0xe754, { 0xE8, 0x94, 0x9F },
	0xe755, { 0xE8, 0x94, 0x8A },
	0xe756, { 0xE8, 0x94, 0xA7 },
	0xe757, { 0xE8, 0x94, 0x9C },
	0xe758, { 0xE8, 0x93, 0xBB },
	0xe759, { 0xE8, 0x94, 0xAB },
	0xe75a, { 0xE8, 0x93, 0xBA },
	0xe75b, { 0xE8, 0x94, 0x88 },
	0xe75c, { 0xE8, 0x94, 0x8C },
	0xe75d, { 0xE8, 0x93, 0xB4 },
	0xe75e, { 0xE8, 0x94, 0xAA },
	0xe75f, { 0xE8, 0x93, 0xB2 },
	0xe760, { 0xE8, 0x94, 0x95 },
	0xe761, { 0xE8, 0x93, 0xB7 },
	0xe762, { 0xE8, 0x93, 0xAB },
	0xe763, { 0xE8, 0x93, 0xB3 },
	0xe764, { 0xE8, 0x93, 0xBC },
	0xe765, { 0xE8, 0x94, 0x92 },
	0xe766, { 0xE8, 0x93, 0xAA },
	0xe767, { 0xE8, 0x93, 0xA9 },
	0xe768, { 0xE8, 0x94, 0x96 },
	0xe769, { 0xE8, 0x93, 0xBE },
	0xe76a, { 0xE8, 0x94, 0xA8 },
	0xe76b, { 0xE8, 0x94, 0x9D },
	0xe76c, { 0xE8, 0x94, 0xAE },
	0xe76d, { 0xE8, 0x94, 0x82 },
	0xe76e, { 0xE8, 0x93, 0xBD },
	0xe76f, { 0xE8, 0x94, 0x9E },
	0xe770, { 0xE8, 0x93, 0xB6 },
	0xe771, { 0xE8, 0x94, 0xB1 },
	0xe772, { 0xE8, 0x94, 0xA6 },
	0xe773, { 0xE8, 0x93, 0xA7 },
	0xe774, { 0xE8, 0x93, 0xA8 },
	0xe775, { 0xE8, 0x93, 0xB0 },
	0xe776, { 0xE8, 0x93, 0xAF },
	0xe777, { 0xE8, 0x93, 0xB9 },
	0xe778, { 0xE8, 0x94, 0x98 },
	0xe779, { 0xE8, 0x94, 0xA0 },
	0xe77a, { 0xE8, 0x94, 0xB0 },
	0xe77b, { 0xE8, 0x94, 0x8B },
	0xe77c, { 0xE8, 0x94, 0x99 },
	0xe77d, { 0xE8, 0x94, 0xAF },
	0xe77e, { 0xE8, 0x99, 0xA2 },
	0xe7a1, { 0xE8, 0x9D, 0x96 },
	0xe7a2, { 0xE8, 0x9D, 0xA3 },
	0xe7a3, { 0xE8, 0x9D, 0xA4 },
	0xe7a4, { 0xE8, 0x9D, 0xB7 },
	0xe7a5, { 0xE8, 0x9F, 0xA1 },
	0xe7a6, { 0xE8, 0x9D, 0xB3 },
	0xe7a7, { 0xE8, 0x9D, 0x98 },
	0xe7a8, { 0xE8, 0x9D, 0x94 },
	0xe7a9, { 0xE8, 0x9D, 0x9B },
	0xe7aa, { 0xE8, 0x9D, 0x92 },
	0xe7ab, { 0xE8, 0x9D, 0xA1 },
	0xe7ac, { 0xE8, 0x9D, 0x9A },
	0xe7ad, { 0xE8, 0x9D, 0x91 },
	0xe7ae, { 0xE8, 0x9D, 0x9E },
	0xe7af, { 0xE8, 0x9D, 0xAD },
	0xe7b0, { 0xE8, 0x9D, 0xAA },
	0xe7b1, { 0xE8, 0x9D, 0x90 },
	0xe7b2, { 0xE8, 0x9D, 0x8E },
	0xe7b3, { 0xE8, 0x9D, 0x9F },
	0xe7b4, { 0xE8, 0x9D, 0x9D },
	0xe7b5, { 0xE8, 0x9D, 0xAF },
	0xe7b6, { 0xE8, 0x9D, 0xAC },
	0xe7b7, { 0xE8, 0x9D, 0xBA },
	0xe7b8, { 0xE8, 0x9D, 0xAE },
	0xe7b9, { 0xE8, 0x9D, 0x9C },
	0xe7ba, { 0xE8, 0x9D, 0xA5 },
	0xe7bb, { 0xE8, 0x9D, 0x8F },
	0xe7bc, { 0xE8, 0x9D, 0xBB },
	0xe7bd, { 0xE8, 0x9D, 0xB5 },
	0xe7be, { 0xE8, 0x9D, 0xA2 },
	0xe7bf, { 0xE8, 0x9D, 0xA7 },
	0xe7c0, { 0xE8, 0x9D, 0xA9 },
	0xe7c1, { 0xE8, 0xA1, 0x9A },
	0xe7c2, { 0xE8, 0xA4, 0x85 },
	0xe7c3, { 0xE8, 0xA4, 0x8C },
	0xe7c4, { 0xE8, 0xA4, 0x94 },
	0xe7c5, { 0xE8, 0xA4, 0x8B },
	0xe7c6, { 0xE8, 0xA4, 0x97 },
	0xe7c7, { 0xE8, 0xA4, 0x98 },
	0xe7c8, { 0xE8, 0xA4, 0x99 },
	0xe7c9, { 0xE8, 0xA4, 0x86 },
	0xe7ca, { 0xE8, 0xA4, 0x96 },
	0xe7cb, { 0xE8, 0xA4, 0x91 },
	0xe7cc, { 0xE8, 0xA4, 0x8E },
	0xe7cd, { 0xE8, 0xA4, 0x89 },
	0xe7ce, { 0xE8, 0xA6, 0xA2 },
	0xe7cf, { 0xE8, 0xA6, 0xA4 },
	0xe7d0, { 0xE8, 0xA6, 0xA3 },
	0xe7d1, { 0xE8, 0xA7, 0xAD },
	0xe7d2, { 0xE8, 0xA7, 0xB0 },
	0xe7d3, { 0xE8, 0xA7, 0xAC },
	0xe7d4, { 0xE8, 0xAB, 0x8F },
	0xe7d5, { 0xE8, 0xAB, 0x86 },
	0xe7d6, { 0xE8, 0xAA, 0xB8 },
	0xe7d7, { 0xE8, 0xAB, 0x93 },
	0xe7d8, { 0xE8, 0xAB, 0x91 },
	0xe7d9, { 0xE8, 0xAB, 0x94 },
	0xe7da, { 0xE8, 0xAB, 0x95 },
	0xe7db, { 0xE8, 0xAA, 0xBB },
	0xe7dc, { 0xE8, 0xAB, 0x97 },
	0xe7dd, { 0xE8, 0xAA, 0xBE },
	0xe7de, { 0xE8, 0xAB, 0x80 },
	0xe7df, { 0xE8, 0xAB, 0x85 },
	0xe7e0, { 0xE8, 0xAB, 0x98 },
	0xe7e1, { 0xE8, 0xAB, 0x83 },
	0xe7e2, { 0xE8, 0xAA, 0xBA },
	0xe7e3, { 0xE8, 0xAA, 0xBD },
	0xe7e4, { 0xE8, 0xAB, 0x99 },
	0xe7e5, { 0xE8, 0xB0, 0xBE },
	0xe7e6, { 0xE8, 0xB1, 0x8D },
	0xe7e7, { 0xE8, 0xB2, 0x8F },
	0xe7e8, { 0xE8, 0xB3, 0xA5 },
	0xe7e9, { 0xE8, 0xB3, 0x9F },
	0xe7ea, { 0xE8, 0xB3, 0x99 },
	0xe7eb, { 0xE8, 0xB3, 0xA8 },
	0xe7ec, { 0xE8, 0xB3, 0x9A },
	0xe7ed, { 0xE8, 0xB3, 0x9D },
	0xe7ee, { 0xE8, 0xB3, 0xA7 },
	0xe7ef, { 0xE8, 0xB6, 0xA0 },
	0xe7f0, { 0xE8, 0xB6, 0x9C },
	0xe7f1, { 0xE8, 0xB6, 0xA1 },
	0xe7f2, { 0xE8, 0xB6, 0x9B },
	0xe7f3, { 0xE8, 0xB8, 0xA0 },
	0xe7f4, { 0xE8, 0xB8, 0xA3 },
	0xe7f5, { 0xE8, 0xB8, 0xA5 },
	0xe7f6, { 0xE8, 0xB8, 0xA4 },
	0xe7f7, { 0xE8, 0xB8, 0xAE },
	0xe7f8, { 0xE8, 0xB8, 0x95 },
	0xe7f9, { 0xE8, 0xB8, 0x9B },
	0xe7fa, { 0xE8, 0xB8, 0x96 },
	0xe7fb, { 0xE8, 0xB8, 0x91 },
	0xe7fc, { 0xE8, 0xB8, 0x99 },
	0xe7fd, { 0xE8, 0xB8, 0xA6 },
	0xe7fe, { 0xE8, 0xB8, 0xA7 },
	0xe840, { 0xE8, 0xB8, 0x94 },
	0xe841, { 0xE8, 0xB8, 0x92 },
	0xe842, { 0xE8, 0xB8, 0x98 },
	0xe843, { 0xE8, 0xB8, 0x93 },
	0xe844, { 0xE8, 0xB8, 0x9C },
	0xe845, { 0xE8, 0xB8, 0x97 },
	0xe846, { 0xE8, 0xB8, 0x9A },
	0xe847, { 0xE8, 0xBC, 0xAC },
	0xe848, { 0xE8, 0xBC, 0xA4 },
	0xe849, { 0xE8, 0xBC, 0x98 },
	0xe84a, { 0xE8, 0xBC, 0x9A },
	0xe84b, { 0xE8, 0xBC, 0xA0 },
	0xe84c, { 0xE8, 0xBC, 0xA3 },
	0xe84d, { 0xE8, 0xBC, 0x96 },
	0xe84e, { 0xE8, 0xBC, 0x97 },
	0xe84f, { 0xE9, 0x81, 0xB3 },
	0xe850, { 0xE9, 0x81, 0xB0 },
	0xe851, { 0xE9, 0x81, 0xAF },
	0xe852, { 0xE9, 0x81, 0xA7 },
	0xe853, { 0xE9, 0x81, 0xAB },
	0xe854, { 0xE9, 0x84, 0xAF },
	0xe855, { 0xE9, 0x84, 0xAB },
	0xe856, { 0xE9, 0x84, 0xA9 },
	0xe857, { 0xE9, 0x84, 0xAA },
	0xe858, { 0xE9, 0x84, 0xB2 },
	0xe859, { 0xE9, 0x84, 0xA6 },
	0xe85a, { 0xE9, 0x84, 0xAE },
	0xe85b, { 0xE9, 0x86, 0x85 },
	0xe85c, { 0xE9, 0x86, 0x86 },
	0xe85d, { 0xE9, 0x86, 0x8A },
	0xe85e, { 0xE9, 0x86, 0x81 },
	0xe85f, { 0xE9, 0x86, 0x82 },
	0xe860, { 0xE9, 0x86, 0x84 },
	0xe861, { 0xE9, 0x86, 0x80 },
	0xe862, { 0xE9, 0x8B, 0x90 },
	0xe863, { 0xE9, 0x8B, 0x83 },
	0xe864, { 0xE9, 0x8B, 0x84 },
	0xe865, { 0xE9, 0x8B, 0x80 },
	0xe866, { 0xE9, 0x8B, 0x99 },
	0xe867, { 0xE9, 0x8A, 0xB6 },
	0xe868, { 0xE9, 0x8B, 0x8F },
	0xe869, { 0xE9, 0x8B, 0xB1 },
	0xe86a, { 0xE9, 0x8B, 0x9F },
	0xe86b, { 0xE9, 0x8B, 0x98 },
	0xe86c, { 0xE9, 0x8B, 0xA9 },
	0xe86d, { 0xE9, 0x8B, 0x97 },
	0xe86e, { 0xE9, 0x8B, 0x9D },
	0xe86f, { 0xE9, 0x8B, 0x8C },
	0xe870, { 0xE9, 0x8B, 0xAF },
	0xe871, { 0xE9, 0x8B, 0x82 },
	0xe872, { 0xE9, 0x8B, 0xA8 },
	0xe873, { 0xE9, 0x8B, 0x8A },
	0xe874, { 0xE9, 0x8B, 0x88 },
	0xe875, { 0xE9, 0x8B, 0x8E },
	0xe876, { 0xE9, 0x8B, 0xA6 },
	0xe877, { 0xE9, 0x8B, 0x8D },
	0xe878, { 0xE9, 0x8B, 0x95 },
	0xe879, { 0xE9, 0x8B, 0x89 },
	0xe87a, { 0xE9, 0x8B, 0xA0 },
	0xe87b, { 0xE9, 0x8B, 0x9E },
	0xe87c, { 0xE9, 0x8B, 0xA7 },
	0xe87d, { 0xE9, 0x8B, 0x91 },
	0xe87e, { 0xE9, 0x8B, 0x93 },
	0xe8a1, { 0xE9, 0x8A, 0xB5 },
	0xe8a2, { 0xE9, 0x8B, 0xA1 },
	0xe8a3, { 0xE9, 0x8B, 0x86 },
	0xe8a4, { 0xE9, 0x8A, 0xB4 },
	0xe8a5, { 0xE9, 0x95, 0xBC },
	0xe8a6, { 0xE9, 0x96, 0xAC },
	0xe8a7, { 0xE9, 0x96, 0xAB },
	0xe8a8, { 0xE9, 0x96, 0xAE },
	0xe8a9, { 0xE9, 0x96, 0xB0 },
	0xe8aa, { 0xE9, 0x9A, 0xA4 },
	0xe8ab, { 0xE9, 0x9A, 0xA2 },
	0xe8ac, { 0xE9, 0x9B, 0x93 },
	0xe8ad, { 0xE9, 0x9C, 0x85 },
	0xe8ae, { 0xE9, 0x9C, 0x88 },
	0xe8af, { 0xE9, 0x9C, 0x82 },
	0xe8b0, { 0xE9, 0x9D, 0x9A },
	0xe8b1, { 0xE9, 0x9E, 0x8A },
	0xe8b2, { 0xE9, 0x9E, 0x8E },
	0xe8b3, { 0xE9, 0x9E, 0x88 },
	0xe8b4, { 0xE9, 0x9F, 0x90 },
	0xe8b5, { 0xE9, 0x9F, 0x8F },
	0xe8b6, { 0xE9, 0xA0, 0x9E },
	0xe8b7, { 0xE9, 0xA0, 0x9D },
	0xe8b8, { 0xE9, 0xA0, 0xA6 },
	0xe8b9, { 0xE9, 0xA0, 0xA9 },
	0xe8ba, { 0xE9, 0xA0, 0xA8 },
	0xe8bb, { 0xE9, 0xA0, 0xA0 },
	0xe8bc, { 0xE9, 0xA0, 0x9B },
	0xe8bd, { 0xE9, 0xA0, 0xA7 },
	0xe8be, { 0xE9, 0xA2, 0xB2 },
	0xe8bf, { 0xE9, 0xA4, 0x88 },
	0xe8c0, { 0xE9, 0xA3, 0xBA },
	0xe8c1, { 0xE9, 0xA4, 0x91 },
	0xe8c2, { 0xE9, 0xA4, 0x94 },
	0xe8c3, { 0xE9, 0xA4, 0x96 },
	0xe8c4, { 0xE9, 0xA4, 0x97 },
	0xe8c5, { 0xE9, 0xA4, 0x95 },
	0xe8c6, { 0xE9, 0xA7, 0x9C },
	0xe8c7, { 0xE9, 0xA7, 0x8D },
	0xe8c8, { 0xE9, 0xA7, 0x8F },
	0xe8c9, { 0xE9, 0xA7, 0x93 },
	0xe8ca, { 0xE9, 0xA7, 0x94 },
	0xe8cb, { 0xE9, 0xA7, 0x8E },
	0xe8cc, { 0xE9, 0xA7, 0x89 },
	0xe8cd, { 0xE9, 0xA7, 0x96 },
	0xe8ce, { 0xE9, 0xA7, 0x98 },
	0xe8cf, { 0xE9, 0xA7, 0x8B },
	0xe8d0, { 0xE9, 0xA7, 0x97 },
	0xe8d1, { 0xE9, 0xA7, 0x8C },
	0xe8d2, { 0xE9, 0xAA, 0xB3 },
	0xe8d3, { 0xE9, 0xAB, 0xAC },
	0xe8d4, { 0xE9, 0xAB, 0xAB },
	0xe8d5, { 0xE9, 0xAB, 0xB3 },
	0xe8d6, { 0xE9, 0xAB, 0xB2 },
	0xe8d7, { 0xE9, 0xAB, 0xB1 },
	0xe8d8, { 0xE9, 0xAD, 0x86 },
	0xe8d9, { 0xE9, 0xAD, 0x83 },
	0xe8da, { 0xE9, 0xAD, 0xA7 },
	0xe8db, { 0xE9, 0xAD, 0xB4 },
	0xe8dc, { 0xE9, 0xAD, 0xB1 },
	0xe8dd, { 0xE9, 0xAD, 0xA6 },
	0xe8de, { 0xE9, 0xAD, 0xB6 },
	0xe8df, { 0xE9, 0xAD, 0xB5 },
	0xe8e0, { 0xE9, 0xAD, 0xB0 },
	0xe8e1, { 0xE9, 0xAD, 0xA8 },
	0xe8e2, { 0xE9, 0xAD, 0xA4 },
	0xe8e3, { 0xE9, 0xAD, 0xAC },
	0xe8e4, { 0xE9, 0xB3, 0xBC },
	0xe8e5, { 0xE9, 0xB3, 0xBA },
	0xe8e6, { 0xE9, 0xB3, 0xBD },
	0xe8e7, { 0xE9, 0xB3, 0xBF },
	0xe8e8, { 0xE9, 0xB3, 0xB7 },
	0xe8e9, { 0xE9, 0xB4, 0x87 },
	0xe8ea, { 0xE9, 0xB4, 0x80 },
	0xe8eb, { 0xE9, 0xB3, 0xB9 },
	0xe8ec, { 0xE9, 0xB3, 0xBB },
	0xe8ed, { 0xE9, 0xB4, 0x88 },
	0xe8ee, { 0xE9, 0xB4, 0x85 },
	0xe8ef, { 0xE9, 0xB4, 0x84 },
	0xe8f0, { 0xE9, 0xBA, 0x83 },
	0xe8f1, { 0xE9, 0xBB, 0x93 },
	0xe8f2, { 0xE9, 0xBC, 0x8F },
	0xe8f3, { 0xE9, 0xBC, 0x90 },
	0xe8f4, { 0xE5, 0x84, 0x9C },
	0xe8f5, { 0xE5, 0x84, 0x93 },
	0xe8f6, { 0xE5, 0x84, 0x97 },
	0xe8f7, { 0xE5, 0x84, 0x9A },
	0xe8f8, { 0xE5, 0x84, 0x91 },
	0xe8f9, { 0xE5, 0x87, 0x9E },
	0xe8fa, { 0xE5, 0x8C, 0xB4 },
	0xe8fb, { 0xE5, 0x8F, 0xA1 },
	0xe8fc, { 0xE5, 0x99, 0xB0 },
	0xe8fd, { 0xE5, 0x99, 0xA0 },
	0xe8fe, { 0xE5, 0x99, 0xAE },
	0xe940, { 0xE5, 0x99, 0xB3 },
	0xe941, { 0xE5, 0x99, 0xA6 },
	0xe942, { 0xE5, 0x99, 0xA3 },
	0xe943, { 0xE5, 0x99, 0xAD },
	0xe944, { 0xE5, 0x99, 0xB2 },
	0xe945, { 0xE5, 0x99, 0x9E },
	0xe946, { 0xE5, 0x99, 0xB7 },
	0xe947, { 0xE5, 0x9C, 0x9C },
	0xe948, { 0xE5, 0x9C, 0x9B },
	0xe949, { 0xE5, 0xA3, 0x88 },
	0xe94a, { 0xE5, 0xA2, 0xBD },
	0xe94b, { 0xE5, 0xA3, 0x89 },
	0xe94c, { 0xE5, 0xA2, 0xBF },
	0xe94d, { 0xE5, 0xA2, 0xBA },
	0xe94e, { 0xE5, 0xA3, 0x82 },
	0xe94f, { 0xE5, 0xA2, 0xBC },
	0xe950, { 0xE5, 0xA3, 0x86 },
	0xe951, { 0xE5, 0xAC, 0x97 },
	0xe952, { 0xE5, 0xAC, 0x99 },
	0xe953, { 0xE5, 0xAC, 0x9B },
	0xe954, { 0xE5, 0xAC, 0xA1 },
	0xe955, { 0xE5, 0xAC, 0x94 },
	0xe956, { 0xE5, 0xAC, 0x93 },
	0xe957, { 0xE5, 0xAC, 0x90 },
	0xe958, { 0xE5, 0xAC, 0x96 },
	0xe959, { 0xE5, 0xAC, 0xA8 },
	0xe95a, { 0xE5, 0xAC, 0x9A },
	0xe95b, { 0xE5, 0xAC, 0xA0 },
	0xe95c, { 0xE5, 0xAC, 0x9E },
	0xe95d, { 0xE5, 0xAF, 0xAF },
	0xe95e, { 0xE5, 0xB6, 0xAC },
	0xe95f, { 0xE5, 0xB6, 0xB1 },
	0xe960, { 0xE5, 0xB6, 0xA9 },
	0xe961, { 0xE5, 0xB6, 0xA7 },
	0xe962, { 0xE5, 0xB6, 0xB5 },
	0xe963, { 0xE5, 0xB6, 0xB0 },
	0xe964, { 0xE5, 0xB6, 0xAE },
	0xe965, { 0xE5, 0xB6, 0xAA },
	0xe966, { 0xE5, 0xB6, 0xA8 },
	0xe967, { 0xE5, 0xB6, 0xB2 },
	0xe968, { 0xE5, 0xB6, 0xAD },
	0xe969, { 0xE5, 0xB6, 0xAF },
	0xe96a, { 0xE5, 0xB6, 0xB4 },
	0xe96b, { 0xE5, 0xB9, 0xA7 },
	0xe96c, { 0xE5, 0xB9, 0xA8 },
	0xe96d, { 0xE5, 0xB9, 0xA6 },
	0xe96e, { 0xE5, 0xB9, 0xAF },
	0xe96f, { 0xE5, 0xBB, 0xA9 },
	0xe970, { 0xE5, 0xBB, 0xA7 },
	0xe971, { 0xE5, 0xBB, 0xA6 },
	0xe972, { 0xE5, 0xBB, 0xA8 },
	0xe973, { 0xE5, 0xBB, 0xA5 },
	0xe974, { 0xE5, 0xBD, 0x8B },
	0xe975, { 0xE5, 0xBE, 0xBC },
	0xe976, { 0xE6, 0x86, 0x9D },
	0xe977, { 0xE6, 0x86, 0xA8 },
	0xe978, { 0xE6, 0x86, 0x96 },
	0xe979, { 0xE6, 0x87, 0x85 },
	0xe97a, { 0xE6, 0x86, 0xB4 },
	0xe97b, { 0xE6, 0x87, 0x86 },
	0xe97c, { 0xE6, 0x87, 0x81 },
	0xe97d, { 0xE6, 0x87, 0x8C },
	0xe97e, { 0xE6, 0x86, 0xBA },
	0xe9a1, { 0xE6, 0x86, 0xBF },
	0xe9a2, { 0xE6, 0x86, 0xB8 },
	0xe9a3, { 0xE6, 0x86, 0x8C },
	0xe9a4, { 0xE6, 0x93, 0x97 },
	0xe9a5, { 0xE6, 0x93, 0x96 },
	0xe9a6, { 0xE6, 0x93, 0x90 },
	0xe9a7, { 0xE6, 0x93, 0x8F },
	0xe9a8, { 0xE6, 0x93, 0x89 },
	0xe9a9, { 0xE6, 0x92, 0xBD },
	0xe9aa, { 0xE6, 0x92, 0x89 },
	0xe9ab, { 0xE6, 0x93, 0x83 },
	0xe9ac, { 0xE6, 0x93, 0x9B },
	0xe9ad, { 0xE6, 0x93, 0xB3 },
	0xe9ae, { 0xE6, 0x93, 0x99 },
	0xe9af, { 0xE6, 0x94, 0xB3 },
	0xe9b0, { 0xE6, 0x95, 0xBF },
	0xe9b1, { 0xE6, 0x95, 0xBC },
	0xe9b2, { 0xE6, 0x96, 0xA2 },
	0xe9b3, { 0xE6, 0x9B, 0x88 },
	0xe9b4, { 0xE6, 0x9A, 0xBE },
	0xe9b5, { 0xE6, 0x9B, 0x80 },
	0xe9b6, { 0xE6, 0x9B, 0x8A },
	0xe9b7, { 0xE6, 0x9B, 0x8B },
	0xe9b8, { 0xE6, 0x9B, 0x8F },
	0xe9b9, { 0xE6, 0x9A, 0xBD },
	0xe9ba, { 0xE6, 0x9A, 0xBB },
	0xe9bb, { 0xE6, 0x9A, 0xBA },
	0xe9bc, { 0xE6, 0x9B, 0x8C },
	0xe9bd, { 0xE6, 0x9C, 0xA3 },
	0xe9be, { 0xE6, 0xA8, 0xB4 },
	0xe9bf, { 0xE6, 0xA9, 0xA6 },
	0xe9c0, { 0xE6, 0xA9, 0x89 },
	0xe9c1, { 0xE6, 0xA9, 0xA7 },
	0xe9c2, { 0xE6, 0xA8, 0xB2 },
	0xe9c3, { 0xE6, 0xA9, 0xA8 },
	0xe9c4, { 0xE6, 0xA8, 0xBE },
	0xe9c5, { 0xE6, 0xA9, 0x9D },
	0xe9c6, { 0xE6, 0xA9, 0xAD },
	0xe9c7, { 0xE6, 0xA9, 0xB6 },
	0xe9c8, { 0xE6, 0xA9, 0x9B },
	0xe9c9, { 0xE6, 0xA9, 0x91 },
	0xe9ca, { 0xE6, 0xA8, 0xA8 },
	0xe9cb, { 0xE6, 0xA9, 0x9A },
	0xe9cc, { 0xE6, 0xA8, 0xBB },
	0xe9cd, { 0xE6, 0xA8, 0xBF },
	0xe9ce, { 0xE6, 0xA9, 0x81 },
	0xe9cf, { 0xE6, 0xA9, 0xAA },
	0xe9d0, { 0xE6, 0xA9, 0xA4 },
	0xe9d1, { 0xE6, 0xA9, 0x90 },
	0xe9d2, { 0xE6, 0xA9, 0x8F },
	0xe9d3, { 0xE6, 0xA9, 0x94 },
	0xe9d4, { 0xE6, 0xA9, 0xAF },
	0xe9d5, { 0xE6, 0xA9, 0xA9 },
	0xe9d6, { 0xE6, 0xA9, 0xA0 },
	0xe9d7, { 0xE6, 0xA8, 0xBC },
	0xe9d8, { 0xE6, 0xA9, 0x9E },
	0xe9d9, { 0xE6, 0xA9, 0x96 },
	0xe9da, { 0xE6, 0xA9, 0x95 },
	0xe9db, { 0xE6, 0xA9, 0x8D },
	0xe9dc, { 0xE6, 0xA9, 0x8E },
	0xe9dd, { 0xE6, 0xA9, 0x86 },
	0xe9de, { 0xE6, 0xAD, 0x95 },
	0xe9df, { 0xE6, 0xAD, 0x94 },
	0xe9e0, { 0xE6, 0xAD, 0x96 },
	0xe9e1, { 0xE6, 0xAE, 0xA7 },
	0xe9e2, { 0xE6, 0xAE, 0xAA },
	0xe9e3, { 0xE6, 0xAE, 0xAB },
	0xe9e4, { 0xE6, 0xAF, 0x88 },
	0xe9e5, { 0xE6, 0xAF, 0x87 },
	0xe9e6, { 0xE6, 0xB0, 0x84 },
	0xe9e7, { 0xE6, 0xB0, 0x83 },
	0xe9e8, { 0xE6, 0xB0, 0x86 },
	0xe9e9, { 0xE6, 0xBE, 0xAD },
	0xe9ea, { 0xE6, 0xBF, 0x8B },
	0xe9eb, { 0xE6, 0xBE, 0xA3 },
	0xe9ec, { 0xE6, 0xBF, 0x87 },
	0xe9ed, { 0xE6, 0xBE, 0xBC },
	0xe9ee, { 0xE6, 0xBF, 0x8E },
	0xe9ef, { 0xE6, 0xBF, 0x88 },
	0xe9f0, { 0xE6, 0xBD, 0x9E },
	0xe9f1, { 0xE6, 0xBF, 0x84 },
	0xe9f2, { 0xE6, 0xBE, 0xBD },
	0xe9f3, { 0xE6, 0xBE, 0x9E },
	0xe9f4, { 0xE6, 0xBF, 0x8A },
	0xe9f5, { 0xE6, 0xBE, 0xA8 },
	0xe9f6, { 0xE7, 0x80, 0x84 },
	0xe9f7, { 0xE6, 0xBE, 0xA5 },
	0xe9f8, { 0xE6, 0xBE, 0xAE },
	0xe9f9, { 0xE6, 0xBE, 0xBA },
	0xe9fa, { 0xE6, 0xBE, 0xAC },
	0xe9fb, { 0xE6, 0xBE, 0xAA },
	0xe9fc, { 0xE6, 0xBF, 0x8F },
	0xe9fd, { 0xE6, 0xBE, 0xBF },
	0xe9fe, { 0xE6, 0xBE, 0xB8 },
	0xea40, { 0xE6, 0xBE, 0xA2 },
	0xea41, { 0xE6, 0xBF, 0x89 },
	0xea42, { 0xE6, 0xBE, 0xAB },
	0xea43, { 0xE6, 0xBF, 0x8D },
	0xea44, { 0xE6, 0xBE, 0xAF },
	0xea45, { 0xE6, 0xBE, 0xB2 },
	0xea46, { 0xE6, 0xBE, 0xB0 },
	0xea47, { 0xE7, 0x87, 0x85 },
	0xea48, { 0xE7, 0x87, 0x82 },
	0xea49, { 0xE7, 0x86, 0xBF },
	0xea4a, { 0xE7, 0x86, 0xB8 },
	0xea4b, { 0xE7, 0x87, 0x96 },
	0xea4c, { 0xE7, 0x87, 0x80 },
	0xea4d, { 0xE7, 0x87, 0x81 },
	0xea4e, { 0xE7, 0x87, 0x8B },
	0xea4f, { 0xE7, 0x87, 0x94 },
	0xea50, { 0xE7, 0x87, 0x8A },
	0xea51, { 0xE7, 0x87, 0x87 },
	0xea52, { 0xE7, 0x87, 0x8F },
	0xea53, { 0xE7, 0x86, 0xBD },
	0xea54, { 0xE7, 0x87, 0x98 },
	0xea55, { 0xE7, 0x86, 0xBC },
	0xea56, { 0xE7, 0x87, 0x86 },
	0xea57, { 0xE7, 0x87, 0x9A },
	0xea58, { 0xE7, 0x87, 0x9B },
	0xea59, { 0xE7, 0x8A, 0x9D },
	0xea5a, { 0xE7, 0x8A, 0x9E },
	0xea5b, { 0xE7, 0x8D, 0xA9 },
	0xea5c, { 0xE7, 0x8D, 0xA6 },
	0xea5d, { 0xE7, 0x8D, 0xA7 },
	0xea5e, { 0xE7, 0x8D, 0xAC },
	0xea5f, { 0xE7, 0x8D, 0xA5 },
	0xea60, { 0xE7, 0x8D, 0xAB },
	0xea61, { 0xE7, 0x8D, 0xAA },
	0xea62, { 0xE7, 0x91, 0xBF },
	0xea63, { 0xE7, 0x92, 0x9A },
	0xea64, { 0xE7, 0x92, 0xA0 },
	0xea65, { 0xE7, 0x92, 0x94 },
	0xea66, { 0xE7, 0x92, 0x92 },
	0xea67, { 0xE7, 0x92, 0x95 },
	0xea68, { 0xE7, 0x92, 0xA1 },
	0xea69, { 0xE7, 0x94, 0x8B },
	0xea6a, { 0xE7, 0x96, 0x80 },
	0xea6b, { 0xE7, 0x98, 0xAF },
	0xea6c, { 0xE7, 0x98, 0xAD },
	0xea6d, { 0xE7, 0x98, 0xB1 },
	0xea6e, { 0xE7, 0x98, 0xBD },
	0xea6f, { 0xE7, 0x98, 0xB3 },
	0xea70, { 0xE7, 0x98, 0xBC },
	0xea71, { 0xE7, 0x98, 0xB5 },
	0xea72, { 0xE7, 0x98, 0xB2 },
	0xea73, { 0xE7, 0x98, 0xB0 },
	0xea74, { 0xE7, 0x9A, 0xBB },
	0xea75, { 0xE7, 0x9B, 0xA6 },
	0xea76, { 0xE7, 0x9E, 0x9A },
	0xea77, { 0xE7, 0x9E, 0x9D },
	0xea78, { 0xE7, 0x9E, 0xA1 },
	0xea79, { 0xE7, 0x9E, 0x9C },
	0xea7a, { 0xE7, 0x9E, 0x9B },
	0xea7b, { 0xE7, 0x9E, 0xA2 },
	0xea7c, { 0xE7, 0x9E, 0xA3 },
	0xea7d, { 0xE7, 0x9E, 0x95 },
	0xea7e, { 0xE7, 0x9E, 0x99 },
	0xeaa1, { 0xE7, 0x9E, 0x97 },
	0xeaa2, { 0xE7, 0xA3, 0x9D },
	0xeaa3, { 0xE7, 0xA3, 0xA9 },
	0xeaa4, { 0xE7, 0xA3, 0xA5 },
	0xeaa5, { 0xE7, 0xA3, 0xAA },
	0xeaa6, { 0xE7, 0xA3, 0x9E },
	0xeaa7, { 0xE7, 0xA3, 0xA3 },
	0xeaa8, { 0xE7, 0xA3, 0x9B },
	0xeaa9, { 0xE7, 0xA3, 0xA1 },
	0xeaaa, { 0xE7, 0xA3, 0xA2 },
	0xeaab, { 0xE7, 0xA3, 0xAD },
	0xeaac, { 0xE7, 0xA3, 0x9F },
	0xeaad, { 0xE7, 0xA3, 0xA0 },
	0xeaae, { 0xE7, 0xA6, 0xA4 },
	0xeaaf, { 0xE7, 0xA9, 0x84 },
	0xeab0, { 0xE7, 0xA9, 0x88 },
	0xeab1, { 0xE7, 0xA9, 0x87 },
	0xeab2, { 0xE7, 0xAA, 0xB6 },
	0xeab3, { 0xE7, 0xAA, 0xB8 },
	0xeab4, { 0xE7, 0xAA, 0xB5 },
	0xeab5, { 0xE7, 0xAA, 0xB1 },
	0xeab6, { 0xE7, 0xAA, 0xB7 },
	0xeab7, { 0xE7, 0xAF, 0x9E },
	0xeab8, { 0xE7, 0xAF, 0xA3 },
	0xeab9, { 0xE7, 0xAF, 0xA7 },
	0xeaba, { 0xE7, 0xAF, 0x9D },
	0xeabb, { 0xE7, 0xAF, 0x95 },
	0xeabc, { 0xE7, 0xAF, 0xA5 },
	0xeabd, { 0xE7, 0xAF, 0x9A },
	0xeabe, { 0xE7, 0xAF, 0xA8 },
	0xeabf, { 0xE7, 0xAF, 0xB9 },
	0xeac0, { 0xE7, 0xAF, 0x94 },
	0xeac1, { 0xE7, 0xAF, 0xAA },
	0xeac2, { 0xE7, 0xAF, 0xA2 },
	0xeac3, { 0xE7, 0xAF, 0x9C },
	0xeac4, { 0xE7, 0xAF, 0xAB },
	0xeac5, { 0xE7, 0xAF, 0x98 },
	0xeac6, { 0xE7, 0xAF, 0x9F },
	0xeac7, { 0xE7, 0xB3, 0x92 },
	0xeac8, { 0xE7, 0xB3, 0x94 },
	0xeac9, { 0xE7, 0xB3, 0x97 },
	0xeaca, { 0xE7, 0xB3, 0x90 },
	0xeacb, { 0xE7, 0xB3, 0x91 },
	0xeacc, { 0xE7, 0xB8, 0x92 },
	0xeacd, { 0xE7, 0xB8, 0xA1 },
	0xeace, { 0xE7, 0xB8, 0x97 },
	0xeacf, { 0xE7, 0xB8, 0x8C },
	0xead0, { 0xE7, 0xB8, 0x9F },
	0xead1, { 0xE7, 0xB8, 0xA0 },
	0xead2, { 0xE7, 0xB8, 0x93 },
	0xead3, { 0xE7, 0xB8, 0x8E },
	0xead4, { 0xE7, 0xB8, 0x9C },
	0xead5, { 0xE7, 0xB8, 0x95 },
	0xead6, { 0xE7, 0xB8, 0x9A },
	0xead7, { 0xE7, 0xB8, 0xA2 },
	0xead8, { 0xE7, 0xB8, 0x8B },
	0xead9, { 0xE7, 0xB8, 0x8F },
	0xeada, { 0xE7, 0xB8, 0x96 },
	0xeadb, { 0xE7, 0xB8, 0x8D },
	0xeadc, { 0xE7, 0xB8, 0x94 },
	0xeadd, { 0xE7, 0xB8, 0xA5 },
	0xeade, { 0xE7, 0xB8, 0xA4 },
	0xeadf, { 0xE7, 0xBD, 0x83 },
	0xeae0, { 0xE7, 0xBD, 0xBB },
	0xeae1, { 0xE7, 0xBD, 0xBC },
	0xeae2, { 0xE7, 0xBD, 0xBA },
	0xeae3, { 0xE7, 0xBE, 0xB1 },
	0xeae4, { 0xE7, 0xBF, 0xAF },
	0xeae5, { 0xE8, 0x80, 0xAA },
	0xeae6, { 0xE8, 0x80, 0xA9 },
	0xeae7, { 0xE8, 0x81, 0xAC },
	0xeae8, { 0xE8, 0x86, 0xB1 },
	0xeae9, { 0xE8, 0x86, 0xA6 },
	0xeaea, { 0xE8, 0x86, 0xAE },
	0xeaeb, { 0xE8, 0x86, 0xB9 },
	0xeaec, { 0xE8, 0x86, 0xB5 },
	0xeaed, { 0xE8, 0x86, 0xAB },
	0xeaee, { 0xE8, 0x86, 0xB0 },
	0xeaef, { 0xE8, 0x86, 0xAC },
	0xeaf0, { 0xE8, 0x86, 0xB4 },
	0xeaf1, { 0xE8, 0x86, 0xB2 },
	0xeaf2, { 0xE8, 0x86, 0xB7 },
	0xeaf3, { 0xE8, 0x86, 0xA7 },
	0xeaf4, { 0xE8, 0x87, 0xB2 },
	0xeaf5, { 0xE8, 0x89, 0x95 },
	0xeaf6, { 0xE8, 0x89, 0x96 },
	0xeaf7, { 0xE8, 0x89, 0x97 },
	0xeaf8, { 0xE8, 0x95, 0x96 },
	0xeaf9, { 0xE8, 0x95, 0x85 },
	0xeafa, { 0xE8, 0x95, 0xAB },
	0xeafb, { 0xE8, 0x95, 0x8D },
	0xeafc, { 0xE8, 0x95, 0x93 },
	0xeafd, { 0xE8, 0x95, 0xA1 },
	0xeafe, { 0xE8, 0x95, 0x98 },
	0xeb40, { 0xE8, 0x95, 0x80 },
	0xeb41, { 0xE8, 0x95, 0x86 },
	0xeb42, { 0xE8, 0x95, 0xA4 },
	0xeb43, { 0xE8, 0x95, 0x81 },
	0xeb44, { 0xE8, 0x95, 0xA2 },
	0xeb45, { 0xE8, 0x95, 0x84 },
	0xeb46, { 0xE8, 0x95, 0x91 },
	0xeb47, { 0xE8, 0x95, 0x87 },
	0xeb48, { 0xE8, 0x95, 0xA3 },
	0xeb49, { 0xE8, 0x94, 0xBE },
	0xeb4a, { 0xE8, 0x95, 0x9B },
	0xeb4b, { 0xE8, 0x95, 0xB1 },
	0xeb4c, { 0xE8, 0x95, 0x8E },
	0xeb4d, { 0xE8, 0x95, 0xAE },
	0xeb4e, { 0xE8, 0x95, 0xB5 },
	0xeb4f, { 0xE8, 0x95, 0x95 },
	0xeb50, { 0xE8, 0x95, 0xA7 },
	0xeb51, { 0xE8, 0x95, 0xA0 },
	0xeb52, { 0xE8, 0x96, 0x8C },
	0xeb53, { 0xE8, 0x95, 0xA6 },
	0xeb54, { 0xE8, 0x95, 0x9D },
	0xeb55, { 0xE8, 0x95, 0x94 },
	0xeb56, { 0xE8, 0x95, 0xA5 },
	0xeb57, { 0xE8, 0x95, 0xAC },
	0xeb58, { 0xE8, 0x99, 0xA3 },
	0xeb59, { 0xE8, 0x99, 0xA5 },
	0xeb5a, { 0xE8, 0x99, 0xA4 },
	0xeb5b, { 0xE8, 0x9E, 0x9B },
	0xeb5c, { 0xE8, 0x9E, 0x8F },
	0xeb5d, { 0xE8, 0x9E, 0x97 },
	0xeb5e, { 0xE8, 0x9E, 0x93 },
	0xeb5f, { 0xE8, 0x9E, 0x92 },
	0xeb60, { 0xE8, 0x9E, 0x88 },
	0xeb61, { 0xE8, 0x9E, 0x81 },
	0xeb62, { 0xE8, 0x9E, 0x96 },
	0xeb63, { 0xE8, 0x9E, 0x98 },
	0xeb64, { 0xE8, 0x9D, 0xB9 },
	0xeb65, { 0xE8, 0x9E, 0x87 },
	0xeb66, { 0xE8, 0x9E, 0xA3 },
	0xeb67, { 0xE8, 0x9E, 0x85 },
	0xeb68, { 0xE8, 0x9E, 0x90 },
	0xeb69, { 0xE8, 0x9E, 0x91 },
	0xeb6a, { 0xE8, 0x9E, 0x9D },
	0xeb6b, { 0xE8, 0x9E, 0x84 },
	0xeb6c, { 0xE8, 0x9E, 0x94 },
	0xeb6d, { 0xE8, 0x9E, 0x9C },
	0xeb6e, { 0xE8, 0x9E, 0x9A },
	0xeb6f, { 0xE8, 0x9E, 0x89 },
	0xeb70, { 0xE8, 0xA4, 0x9E },
	0xeb71, { 0xE8, 0xA4, 0xA6 },
	0xeb72, { 0xE8, 0xA4, 0xB0 },
	0xeb73, { 0xE8, 0xA4, 0xAD },
	0xeb74, { 0xE8, 0xA4, 0xAE },
	0xeb75, { 0xE8, 0xA4, 0xA7 },
	0xeb76, { 0xE8, 0xA4, 0xB1 },
	0xeb77, { 0xE8, 0xA4, 0xA2 },
	0xeb78, { 0xE8, 0xA4, 0xA9 },
	0xeb79, { 0xE8, 0xA4, 0xA3 },
	0xeb7a, { 0xE8, 0xA4, 0xAF },
	0xeb7b, { 0xE8, 0xA4, 0xAC },
	0xeb7c, { 0xE8, 0xA4, 0x9F },
	0xeb7d, { 0xE8, 0xA7, 0xB1 },
	0xeb7e, { 0xE8, 0xAB, 0xA0 },
	0xeba1, { 0xE8, 0xAB, 0xA2 },
	0xeba2, { 0xE8, 0xAB, 0xB2 },
	0xeba3, { 0xE8, 0xAB, 0xB4 },
	0xeba4, { 0xE8, 0xAB, 0xB5 },
	0xeba5, { 0xE8, 0xAB, 0x9D },
	0xeba6, { 0xE8, 0xAC, 0x94 },
	0xeba7, { 0xE8, 0xAB, 0xA4 },
	0xeba8, { 0xE8, 0xAB, 0x9F },
	0xeba9, { 0xE8, 0xAB, 0xB0 },
	0xebaa, { 0xE8, 0xAB, 0x88 },
	0xebab, { 0xE8, 0xAB, 0x9E },
	0xebac, { 0xE8, 0xAB, 0xA1 },
	0xebad, { 0xE8, 0xAB, 0xA8 },
	0xebae, { 0xE8, 0xAB, 0xBF },
	0xebaf, { 0xE8, 0xAB, 0xAF },
	0xebb0, { 0xE8, 0xAB, 0xBB },
	0xebb1, { 0xE8, 0xB2, 0x91 },
	0xebb2, { 0xE8, 0xB2, 0x92 },
	0xebb3, { 0xE8, 0xB2, 0x90 },
	0xebb4, { 0xE8, 0xB3, 0xB5 },
	0xebb5, { 0xE8, 0xB3, 0xAE },
	0xebb6, { 0xE8, 0xB3, 0xB1 },
	0xebb7, { 0xE8, 0xB3, 0xB0 },
	0xebb8, { 0xE8, 0xB3, 0xB3 },
	0xebb9, { 0xE8, 0xB5, 0xAC },
	0xebba, { 0xE8, 0xB5, 0xAE },
	0xebbb, { 0xE8, 0xB6, 0xA5 },
	0xebbc, { 0xE8, 0xB6, 0xA7 },
	0xebbd, { 0xE8, 0xB8, 0xB3 },
	0xebbe, { 0xE8, 0xB8, 0xBE },
	0xebbf, { 0xE8, 0xB8, 0xB8 },
	0xebc0, { 0xE8, 0xB9, 0x80 },
	0xebc1, { 0xE8, 0xB9, 0x85 },
	0xebc2, { 0xE8, 0xB8, 0xB6 },
	0xebc3, { 0xE8, 0xB8, 0xBC },
	0xebc4, { 0xE8, 0xB8, 0xBD },
	0xebc5, { 0xE8, 0xB9, 0x81 },
	0xebc6, { 0xE8, 0xB8, 0xB0 },
	0xebc7, { 0xE8, 0xB8, 0xBF },
	0xebc8, { 0xE8, 0xBA, 0xBD },
	0xebc9, { 0xE8, 0xBC, 0xB6 },
	0xebca, { 0xE8, 0xBC, 0xAE },
	0xebcb, { 0xE8, 0xBC, 0xB5 },
	0xebcc, { 0xE8, 0xBC, 0xB2 },
	0xebcd, { 0xE8, 0xBC, 0xB9 },
	0xebce, { 0xE8, 0xBC, 0xB7 },
	0xebcf, { 0xE8, 0xBC, 0xB4 },
	0xebd0, { 0xE9, 0x81, 0xB6 },
	0xebd1, { 0xE9, 0x81, 0xB9 },
	0xebd2, { 0xE9, 0x81, 0xBB },
	0xebd3, { 0xE9, 0x82, 0x86 },
	0xebd4, { 0xE9, 0x83, 0xBA },
	0xebd5, { 0xE9, 0x84, 0xB3 },
	0xebd6, { 0xE9, 0x84, 0xB5 },
	0xebd7, { 0xE9, 0x84, 0xB6 },
	0xebd8, { 0xE9, 0x86, 0x93 },
	0xebd9, { 0xE9, 0x86, 0x90 },
	0xebda, { 0xE9, 0x86, 0x91 },
	0xebdb, { 0xE9, 0x86, 0x8D },
	0xebdc, { 0xE9, 0x86, 0x8F },
	0xebdd, { 0xE9, 0x8C, 0xA7 },
	0xebde, { 0xE9, 0x8C, 0x9E },
	0xebdf, { 0xE9, 0x8C, 0x88 },
	0xebe0, { 0xE9, 0x8C, 0x9F },
	0xebe1, { 0xE9, 0x8C, 0x86 },
	0xebe2, { 0xE9, 0x8C, 0x8F },
	0xebe3, { 0xE9, 0x8D, 0xBA },
	0xebe4, { 0xE9, 0x8C, 0xB8 },
	0xebe5, { 0xE9, 0x8C, 0xBC },
	0xebe6, { 0xE9, 0x8C, 0x9B },
	0xebe7, { 0xE9, 0x8C, 0xA3 },
	0xebe8, { 0xE9, 0x8C, 0x92 },
	0xebe9, { 0xE9, 0x8C, 0x81 },
	0xebea, { 0xE9, 0x8D, 0x86 },
	0xebeb, { 0xE9, 0x8C, 0xAD },
	0xebec, { 0xE9, 0x8C, 0x8E },
	0xebed, { 0xE9, 0x8C, 0x8D },
	0xebee, { 0xE9, 0x8B, 0x8B },
	0xebef, { 0xE9, 0x8C, 0x9D },
	0xebf0, { 0xE9, 0x8B, 0xBA },
	0xebf1, { 0xE9, 0x8C, 0xA5 },
	0xebf2, { 0xE9, 0x8C, 0x93 },
	0xebf3, { 0xE9, 0x8B, 0xB9 },
	0xebf4, { 0xE9, 0x8B, 0xB7 },
	0xebf5, { 0xE9, 0x8C, 0xB4 },
	0xebf6, { 0xE9, 0x8C, 0x82 },
	0xebf7, { 0xE9, 0x8C, 0xA4 },
	0xebf8, { 0xE9, 0x8B, 0xBF },
	0xebf9, { 0xE9, 0x8C, 0xA9 },
	0xebfa, { 0xE9, 0x8C, 0xB9 },
	0xebfb, { 0xE9, 0x8C, 0xB5 },
	0xebfc, { 0xE9, 0x8C, 0xAA },
	0xebfd, { 0xE9, 0x8C, 0x94 },
	0xebfe, { 0xE9, 0x8C, 0x8C },
	0xec40, { 0xE9, 0x8C, 0x8B },
	0xec41, { 0xE9, 0x8B, 0xBE },
	0xec42, { 0xE9, 0x8C, 0x89 },
	0xec43, { 0xE9, 0x8C, 0x80 },
	0xec44, { 0xE9, 0x8B, 0xBB },
	0xec45, { 0xE9, 0x8C, 0x96 },
	0xec46, { 0xE9, 0x96, 0xBC },
	0xec47, { 0xE9, 0x97, 0x8D },
	0xec48, { 0xE9, 0x96, 0xBE },
	0xec49, { 0xE9, 0x96, 0xB9 },
	0xec4a, { 0xE9, 0x96, 0xBA },
	0xec4b, { 0xE9, 0x96, 0xB6 },
	0xec4c, { 0xE9, 0x96, 0xBF },
	0xec4d, { 0xE9, 0x96, 0xB5 },
	0xec4e, { 0xE9, 0x96, 0xBD },
	0xec4f, { 0xE9, 0x9A, 0xA9 },
	0xec50, { 0xE9, 0x9B, 0x94 },
	0xec51, { 0xE9, 0x9C, 0x8B },
	0xec52, { 0xE9, 0x9C, 0x92 },
	0xec53, { 0xE9, 0x9C, 0x90 },
	0xec54, { 0xE9, 0x9E, 0x99 },
	0xec55, { 0xE9, 0x9E, 0x97 },
	0xec56, { 0xE9, 0x9E, 0x94 },
	0xec57, { 0xE9, 0x9F, 0xB0 },
	0xec58, { 0xE9, 0x9F, 0xB8 },
	0xec59, { 0xE9, 0xA0, 0xB5 },
	0xec5a, { 0xE9, 0xA0, 0xAF },
	0xec5b, { 0xE9, 0xA0, 0xB2 },
	0xec5c, { 0xE9, 0xA4, 0xA4 },
	0xec5d, { 0xE9, 0xA4, 0x9F },
	0xec5e, { 0xE9, 0xA4, 0xA7 },
	0xec5f, { 0xE9, 0xA4, 0xA9 },
	0xec60, { 0xE9, 0xA6, 0x9E },
	0xec61, { 0xE9, 0xA7, 0xAE },
	0xec62, { 0xE9, 0xA7, 0xAC },
	0xec63, { 0xE9, 0xA7, 0xA5 },
	0xec64, { 0xE9, 0xA7, 0xA4 },
	0xec65, { 0xE9, 0xA7, 0xB0 },
	0xec66, { 0xE9, 0xA7, 0xA3 },
	0xec67, { 0xE9, 0xA7, 0xAA },
	0xec68, { 0xE9, 0xA7, 0xA9 },
	0xec69, { 0xE9, 0xA7, 0xA7 },
	0xec6a, { 0xE9, 0xAA, 0xB9 },
	0xec6b, { 0xE9, 0xAA, 0xBF },
	0xec6c, { 0xE9, 0xAA, 0xB4 },
	0xec6d, { 0xE9, 0xAA, 0xBB },
	0xec6e, { 0xE9, 0xAB, 0xB6 },
	0xec6f, { 0xE9, 0xAB, 0xBA },
	0xec70, { 0xE9, 0xAB, 0xB9 },
	0xec71, { 0xE9, 0xAB, 0xB7 },
	0xec72, { 0xE9, 0xAC, 0xB3 },
	0xec73, { 0xE9, 0xAE, 0x80 },
	0xec74, { 0xE9, 0xAE, 0x85 },
	0xec75, { 0xE9, 0xAE, 0x87 },
	0xec76, { 0xE9, 0xAD, 0xBC },
	0xec77, { 0xE9, 0xAD, 0xBE },
	0xec78, { 0xE9, 0xAD, 0xBB },
	0xec79, { 0xE9, 0xAE, 0x82 },
	0xec7a, { 0xE9, 0xAE, 0x93 },
	0xec7b, { 0xE9, 0xAE, 0x92 },
	0xec7c, { 0xE9, 0xAE, 0x90 },
	0xec7d, { 0xE9, 0xAD, 0xBA },
	0xec7e, { 0xE9, 0xAE, 0x95 },
	0xeca1, { 0xE9, 0xAD, 0xBD },
	0xeca2, { 0xE9, 0xAE, 0x88 },
	0xeca3, { 0xE9, 0xB4, 0xA5 },
	0xeca4, { 0xE9, 0xB4, 0x97 },
	0xeca5, { 0xE9, 0xB4, 0xA0 },
	0xeca6, { 0xE9, 0xB4, 0x9E },
	0xeca7, { 0xE9, 0xB4, 0x94 },
	0xeca8, { 0xE9, 0xB4, 0xA9 },
	0xeca9, { 0xE9, 0xB4, 0x9D },
	0xecaa, { 0xE9, 0xB4, 0x98 },
	0xecab, { 0xE9, 0xB4, 0xA2 },
	0xecac, { 0xE9, 0xB4, 0x90 },
	0xecad, { 0xE9, 0xB4, 0x99 },
	0xecae, { 0xE9, 0xB4, 0x9F },
	0xecaf, { 0xE9, 0xBA, 0x88 },
	0xecb0, { 0xE9, 0xBA, 0x86 },
	0xecb1, { 0xE9, 0xBA, 0x87 },
	0xecb2, { 0xE9, 0xBA, 0xAE },
	0xecb3, { 0xE9, 0xBA, 0xAD },
	0xecb4, { 0xE9, 0xBB, 0x95 },
	0xecb5, { 0xE9, 0xBB, 0x96 },
	0xecb6, { 0xE9, 0xBB, 0xBA },
	0xecb7, { 0xE9, 0xBC, 0x92 },
	0xecb8, { 0xE9, 0xBC, 0xBD },
	0xecb9, { 0xE5, 0x84, 0xA6 },
	0xecba, { 0xE5, 0x84, 0xA5 },
	0xecbb, { 0xE5, 0x84, 0xA2 },
	0xecbc, { 0xE5, 0x84, 0xA4 },
	0xecbd, { 0xE5, 0x84, 0xA0 },
	0xecbe, { 0xE5, 0x84, 0xA9 },
	0xecbf, { 0xE5, 0x8B, 0xB4 },
	0xecc0, { 0xE5, 0x9A, 0x93 },
	0xecc1, { 0xE5, 0x9A, 0x8C },
	0xecc2, { 0xE5, 0x9A, 0x8D },
	0xecc3, { 0xE5, 0x9A, 0x86 },
	0xecc4, { 0xE5, 0x9A, 0x84 },
	0xecc5, { 0xE5, 0x9A, 0x83 },
	0xecc6, { 0xE5, 0x99, 0xBE },
	0xecc7, { 0xE5, 0x9A, 0x82 },
	0xecc8, { 0xE5, 0x99, 0xBF },
	0xecc9, { 0xE5, 0x9A, 0x81 },
	0xecca, { 0xE5, 0xA3, 0x96 },
	0xeccb, { 0xE5, 0xA3, 0x94 },
	0xeccc, { 0xE5, 0xA3, 0x8F },
	0xeccd, { 0xE5, 0xA3, 0x92 },
	0xecce, { 0xE5, 0xAC, 0xAD },
	0xeccf, { 0xE5, 0xAC, 0xA5 },
	0xecd0, { 0xE5, 0xAC, 0xB2 },
	0xecd1, { 0xE5, 0xAC, 0xA3 },
	0xecd2, { 0xE5, 0xAC, 0xAC },
	0xecd3, { 0xE5, 0xAC, 0xA7 },
	0xecd4, { 0xE5, 0xAC, 0xA6 },
	0xecd5, { 0xE5, 0xAC, 0xAF },
	0xecd6, { 0xE5, 0xAC, 0xAE },
	0xecd7, { 0xE5, 0xAD, 0xBB },
	0xecd8, { 0xE5, 0xAF, 0xB1 },
	0xecd9, { 0xE5, 0xAF, 0xB2 },
	0xecda, { 0xE5, 0xB6, 0xB7 },
	0xecdb, { 0xE5, 0xB9, 0xAC },
	0xecdc, { 0xE5, 0xB9, 0xAA },
	0xecdd, { 0xE5, 0xBE, 0xBE },
	0xecde, { 0xE5, 0xBE, 0xBB },
	0xecdf, { 0xE6, 0x87, 0x83 },
	0xece0, { 0xE6, 0x86, 0xB5 },
	0xece1, { 0xE6, 0x86, 0xBC },
	0xece2, { 0xE6, 0x87, 0xA7 },
	0xece3, { 0xE6, 0x87, 0xA0 },
	0xece4, { 0xE6, 0x87, 0xA5 },
	0xece5, { 0xE6, 0x87, 0xA4 },
	0xece6, { 0xE6, 0x87, 0xA8 },
	0xece7, { 0xE6, 0x87, 0x9E },
	0xece8, { 0xE6, 0x93, 0xAF },
	0xece9, { 0xE6, 0x93, 0xA9 },
	0xecea, { 0xE6, 0x93, 0xA3 },
	0xeceb, { 0xE6, 0x93, 0xAB },
	0xecec, { 0xE6, 0x93, 0xA4 },
	0xeced, { 0xE6, 0x93, 0xA8 },
	0xecee, { 0xE6, 0x96, 0x81 },
	0xecef, { 0xE6, 0x96, 0x80 },
	0xecf0, { 0xE6, 0x96, 0xB6 },
	0xecf1, { 0xE6, 0x97, 0x9A },
	0xecf2, { 0xE6, 0x9B, 0x92 },
	0xecf3, { 0xE6, 0xAA, 0x8D },
	0xecf4, { 0xE6, 0xAA, 0x96 },
	0xecf5, { 0xE6, 0xAA, 0x81 },
	0xecf6, { 0xE6, 0xAA, 0xA5 },
	0xecf7, { 0xE6, 0xAA, 0x89 },
	0xecf8, { 0xE6, 0xAA, 0x9F },
	0xecf9, { 0xE6, 0xAA, 0x9B },
	0xecfa, { 0xE6, 0xAA, 0xA1 },
	0xecfb, { 0xE6, 0xAA, 0x9E },
	0xecfc, { 0xE6, 0xAA, 0x87 },
	0xecfd, { 0xE6, 0xAA, 0x93 },
	0xecfe, { 0xE6, 0xAA, 0x8E },
	0xed40, { 0xE6, 0xAA, 0x95 },
	0xed41, { 0xE6, 0xAA, 0x83 },
	0xed42, { 0xE6, 0xAA, 0xA8 },
	0xed43, { 0xE6, 0xAA, 0xA4 },
	0xed44, { 0xE6, 0xAA, 0x91 },
	0xed45, { 0xE6, 0xA9, 0xBF },
	0xed46, { 0xE6, 0xAA, 0xA6 },
	0xed47, { 0xE6, 0xAA, 0x9A },
	0xed48, { 0xE6, 0xAA, 0x85 },
	0xed49, { 0xE6, 0xAA, 0x8C },
	0xed4a, { 0xE6, 0xAA, 0x92 },
	0xed4b, { 0xE6, 0xAD, 0x9B },
	0xed4c, { 0xE6, 0xAE, 0xAD },
	0xed4d, { 0xE6, 0xB0, 0x89 },
	0xed4e, { 0xE6, 0xBF, 0x8C },
	0xed4f, { 0xE6, 0xBE, 0xA9 },
	0xed50, { 0xE6, 0xBF, 0xB4 },
	0xed51, { 0xE6, 0xBF, 0x94 },
	0xed52, { 0xE6, 0xBF, 0xA3 },
	0xed53, { 0xE6, 0xBF, 0x9C },
	0xed54, { 0xE6, 0xBF, 0xAD },
	0xed55, { 0xE6, 0xBF, 0xA7 },
	0xed56, { 0xE6, 0xBF, 0xA6 },
	0xed57, { 0xE6, 0xBF, 0x9E },
	0xed58, { 0xE6, 0xBF, 0xB2 },
	0xed59, { 0xE6, 0xBF, 0x9D },
	0xed5a, { 0xE6, 0xBF, 0xA2 },
	0xed5b, { 0xE6, 0xBF, 0xA8 },
	0xed5c, { 0xE7, 0x87, 0xA1 },
	0xed5d, { 0xE7, 0x87, 0xB1 },
	0xed5e, { 0xE7, 0x87, 0xA8 },
	0xed5f, { 0xE7, 0x87, 0xB2 },
	0xed60, { 0xE7, 0x87, 0xA4 },
	0xed61, { 0xE7, 0x87, 0xB0 },
	0xed62, { 0xE7, 0x87, 0xA2 },
	0xed63, { 0xE7, 0x8D, 0xB3 },
	0xed64, { 0xE7, 0x8D, 0xAE },
	0xed65, { 0xE7, 0x8D, 0xAF },
	0xed66, { 0xE7, 0x92, 0x97 },
	0xed67, { 0xE7, 0x92, 0xB2 },
	0xed68, { 0xE7, 0x92, 0xAB },
	0xed69, { 0xE7, 0x92, 0x90 },
	0xed6a, { 0xE7, 0x92, 0xAA },
	0xed6b, { 0xE7, 0x92, 0xAD },
	0xed6c, { 0xE7, 0x92, 0xB1 },
	0xed6d, { 0xE7, 0x92, 0xA5 },
	0xed6e, { 0xE7, 0x92, 0xAF },
	0xed6f, { 0xE7, 0x94, 0x90 },
	0xed70, { 0xE7, 0x94, 0x91 },
	0xed71, { 0xE7, 0x94, 0x92 },
	0xed72, { 0xE7, 0x94, 0x8F },
	0xed73, { 0xE7, 0x96, 0x84 },
	0xed74, { 0xE7, 0x99, 0x83 },
	0xed75, { 0xE7, 0x99, 0x88 },
	0xed76, { 0xE7, 0x99, 0x89 },
	0xed77, { 0xE7, 0x99, 0x87 },
	0xed78, { 0xE7, 0x9A, 0xA4 },
	0xed79, { 0xE7, 0x9B, 0xA9 },
	0xed7a, { 0xE7, 0x9E, 0xB5 },
	0xed7b, { 0xE7, 0x9E, 0xAB },
	0xed7c, { 0xE7, 0x9E, 0xB2 },
	0xed7d, { 0xE7, 0x9E, 0xB7 },
	0xed7e, { 0xE7, 0x9E, 0xB6 },
	0xeda1, { 0xE7, 0x9E, 0xB4 },
	0xeda2, { 0xE7, 0x9E, 0xB1 },
	0xeda3, { 0xE7, 0x9E, 0xA8 },
	0xeda4, { 0xE7, 0x9F, 0xB0 },
	0xeda5, { 0xE7, 0xA3, 0xB3 },
	0xeda6, { 0xE7, 0xA3, 0xBD },
	0xeda7, { 0xE7, 0xA4, 0x82 },
	0xeda8, { 0xE7, 0xA3, 0xBB },
	0xeda9, { 0xE7, 0xA3, 0xBC },
	0xedaa, { 0xE7, 0xA3, 0xB2 },
	0xedab, { 0xE7, 0xA4, 0x85 },
	0xedac, { 0xE7, 0xA3, 0xB9 },
	0xedad, { 0xE7, 0xA3, 0xBE },
	0xedae, { 0xE7, 0xA4, 0x84 },
	0xedaf, { 0xE7, 0xA6, 0xAB },
	0xedb0, { 0xE7, 0xA6, 0xA8 },
	0xedb1, { 0xE7, 0xA9, 0x9C },
	0xedb2, { 0xE7, 0xA9, 0x9B },
	0xedb3, { 0xE7, 0xA9, 0x96 },
	0xedb4, { 0xE7, 0xA9, 0x98 },
	0xedb5, { 0xE7, 0xA9, 0x94 },
	0xedb6, { 0xE7, 0xA9, 0x9A },
	0xedb7, { 0xE7, 0xAA, 0xBE },
	0xedb8, { 0xE7, 0xAB, 0x80 },
	0xedb9, { 0xE7, 0xAB, 0x81 },
	0xedba, { 0xE7, 0xB0, 0x85 },
	0xedbb, { 0xE7, 0xB0, 0x8F },
	0xedbc, { 0xE7, 0xAF, 0xB2 },
	0xedbd, { 0xE7, 0xB0, 0x80 },
	0xedbe, { 0xE7, 0xAF, 0xBF },
	0xedbf, { 0xE7, 0xAF, 0xBB },
	0xedc0, { 0xE7, 0xB0, 0x8E },
	0xedc1, { 0xE7, 0xAF, 0xB4 },
	0xedc2, { 0xE7, 0xB0, 0x8B },
	0xedc3, { 0xE7, 0xAF, 0xB3 },
	0xedc4, { 0xE7, 0xB0, 0x82 },
	0xedc5, { 0xE7, 0xB0, 0x89 },
	0xedc6, { 0xE7, 0xB0, 0x83 },
	0xedc7, { 0xE7, 0xB0, 0x81 },
	0xedc8, { 0xE7, 0xAF, 0xB8 },
	0xedc9, { 0xE7, 0xAF, 0xBD },
	0xedca, { 0xE7, 0xB0, 0x86 },
	0xedcb, { 0xE7, 0xAF, 0xB0 },
	0xedcc, { 0xE7, 0xAF, 0xB1 },
	0xedcd, { 0xE7, 0xB0, 0x90 },
	0xedce, { 0xE7, 0xB0, 0x8A },
	0xedcf, { 0xE7, 0xB3, 0xA8 },
	0xedd0, { 0xE7, 0xB8, 0xAD },
	0xedd1, { 0xE7, 0xB8, 0xBC },
	0xedd2, { 0xE7, 0xB9, 0x82 },
	0xedd3, { 0xE7, 0xB8, 0xB3 },
	0xedd4, { 0xE9, 0xA1, 0x88 },
	0xedd5, { 0xE7, 0xB8, 0xB8 },
	0xedd6, { 0xE7, 0xB8, 0xAA },
	0xedd7, { 0xE7, 0xB9, 0x89 },
	0xedd8, { 0xE7, 0xB9, 0x80 },
	0xedd9, { 0xE7, 0xB9, 0x87 },
	0xedda, { 0xE7, 0xB8, 0xA9 },
	0xeddb, { 0xE7, 0xB9, 0x8C },
	0xeddc, { 0xE7, 0xB8, 0xB0 },
	0xeddd, { 0xE7, 0xB8, 0xBB },
	0xedde, { 0xE7, 0xB8, 0xB6 },
	0xeddf, { 0xE7, 0xB9, 0x84 },
	0xede0, { 0xE7, 0xB8, 0xBA },
	0xede1, { 0xE7, 0xBD, 0x85 },
	0xede2, { 0xE7, 0xBD, 0xBF },
	0xede3, { 0xE7, 0xBD, 0xBE },
	0xede4, { 0xE7, 0xBD, 0xBD },
	0xede5, { 0xE7, 0xBF, 0xB4 },
	0xede6, { 0xE7, 0xBF, 0xB2 },
	0xede7, { 0xE8, 0x80, 0xAC },
	0xede8, { 0xE8, 0x86, 0xBB },
	0xede9, { 0xE8, 0x87, 0x84 },
	0xedea, { 0xE8, 0x87, 0x8C },
	0xedeb, { 0xE8, 0x87, 0x8A },
	0xedec, { 0xE8, 0x87, 0x85 },
	0xeded, { 0xE8, 0x87, 0x87 },
	0xedee, { 0xE8, 0x86, 0xBC },
	0xedef, { 0xE8, 0x87, 0xA9 },
	0xedf0, { 0xE8, 0x89, 0x9B },
	0xedf1, { 0xE8, 0x89, 0x9A },
	0xedf2, { 0xE8, 0x89, 0x9C },
	0xedf3, { 0xE8, 0x96, 0x83 },
	0xedf4, { 0xE8, 0x96, 0x80 },
	0xedf5, { 0xE8, 0x96, 0x8F },
	0xedf6, { 0xE8, 0x96, 0xA7 },
	0xedf7, { 0xE8, 0x96, 0x95 },
	0xedf8, { 0xE8, 0x96, 0xA0 },
	0xedf9, { 0xE8, 0x96, 0x8B },
	0xedfa, { 0xE8, 0x96, 0xA3 },
	0xedfb, { 0xE8, 0x95, 0xBB },
	0xedfc, { 0xE8, 0x96, 0xA4 },
	0xedfd, { 0xE8, 0x96, 0x9A },
	0xedfe, { 0xE8, 0x96, 0x9E },
	0xee40, { 0xE8, 0x95, 0xB7 },
	0xee41, { 0xE8, 0x95, 0xBC },
	0xee42, { 0xE8, 0x96, 0x89 },
	0xee43, { 0xE8, 0x96, 0xA1 },
	0xee44, { 0xE8, 0x95, 0xBA },
	0xee45, { 0xE8, 0x95, 0xB8 },
	0xee46, { 0xE8, 0x95, 0x97 },
	0xee47, { 0xE8, 0x96, 0x8E },
	0xee48, { 0xE8, 0x96, 0x96 },
	0xee49, { 0xE8, 0x96, 0x86 },
	0xee4a, { 0xE8, 0x96, 0x8D },
	0xee4b, { 0xE8, 0x96, 0x99 },
	0xee4c, { 0xE8, 0x96, 0x9D },
	0xee4d, { 0xE8, 0x96, 0x81 },
	0xee4e, { 0xE8, 0x96, 0xA2 },
	0xee4f, { 0xE8, 0x96, 0x82 },
	0xee50, { 0xE8, 0x96, 0x88 },
	0xee51, { 0xE8, 0x96, 0x85 },
	0xee52, { 0xE8, 0x95, 0xB9 },
	0xee53, { 0xE8, 0x95, 0xB6 },
	0xee54, { 0xE8, 0x96, 0x98 },
	0xee55, { 0xE8, 0x96, 0x90 },
	0xee56, { 0xE8, 0x96, 0x9F },
	0xee57, { 0xE8, 0x99, 0xA8 },
	0xee58, { 0xE8, 0x9E, 0xBE },
	0xee59, { 0xE8, 0x9E, 0xAA },
	0xee5a, { 0xE8, 0x9E, 0xAD },
	0xee5b, { 0xE8, 0x9F, 0x85 },
	0xee5c, { 0xE8, 0x9E, 0xB0 },
	0xee5d, { 0xE8, 0x9E, 0xAC },
	0xee5e, { 0xE8, 0x9E, 0xB9 },
	0xee5f, { 0xE8, 0x9E, 0xB5 },
	0xee60, { 0xE8, 0x9E, 0xBC },
	0xee61, { 0xE8, 0x9E, 0xAE },
	0xee62, { 0xE8, 0x9F, 0x89 },
	0xee63, { 0xE8, 0x9F, 0x83 },
	0xee64, { 0xE8, 0x9F, 0x82 },
	0xee65, { 0xE8, 0x9F, 0x8C },
	0xee66, { 0xE8, 0x9E, 0xB7 },
	0xee67, { 0xE8, 0x9E, 0xAF },
	0xee68, { 0xE8, 0x9F, 0x84 },
	0xee69, { 0xE8, 0x9F, 0x8A },
	0xee6a, { 0xE8, 0x9E, 0xB4 },
	0xee6b, { 0xE8, 0x9E, 0xB6 },
	0xee6c, { 0xE8, 0x9E, 0xBF },
	0xee6d, { 0xE8, 0x9E, 0xB8 },
	0xee6e, { 0xE8, 0x9E, 0xBD },
	0xee6f, { 0xE8, 0x9F, 0x9E },
	0xee70, { 0xE8, 0x9E, 0xB2 },
	0xee71, { 0xE8, 0xA4, 0xB5 },
	0xee72, { 0xE8, 0xA4, 0xB3 },
	0xee73, { 0xE8, 0xA4, 0xBC },
	0xee74, { 0xE8, 0xA4, 0xBE },
	0xee75, { 0xE8, 0xA5, 0x81 },
	0xee76, { 0xE8, 0xA5, 0x92 },
	0xee77, { 0xE8, 0xA4, 0xB7 },
	0xee78, { 0xE8, 0xA5, 0x82 },
	0xee79, { 0xE8, 0xA6, 0xAD },
	0xee7a, { 0xE8, 0xA6, 0xAF },
	0xee7b, { 0xE8, 0xA6, 0xAE },
	0xee7c, { 0xE8, 0xA7, 0xB2 },
	0xee7d, { 0xE8, 0xA7, 0xB3 },
	0xee7e, { 0xE8, 0xAC, 0x9E },
	0xeea1, { 0xE8, 0xAC, 0x98 },
	0xeea2, { 0xE8, 0xAC, 0x96 },
	0xeea3, { 0xE8, 0xAC, 0x91 },
	0xeea4, { 0xE8, 0xAC, 0x85 },
	0xeea5, { 0xE8, 0xAC, 0x8B },
	0xeea6, { 0xE8, 0xAC, 0xA2 },
	0xeea7, { 0xE8, 0xAC, 0x8F },
	0xeea8, { 0xE8, 0xAC, 0x92 },
	0xeea9, { 0xE8, 0xAC, 0x95 },
	0xeeaa, { 0xE8, 0xAC, 0x87 },
	0xeeab, { 0xE8, 0xAC, 0x8D },
	0xeeac, { 0xE8, 0xAC, 0x88 },
	0xeead, { 0xE8, 0xAC, 0x86 },
	0xeeae, { 0xE8, 0xAC, 0x9C },
	0xeeaf, { 0xE8, 0xAC, 0x93 },
	0xeeb0, { 0xE8, 0xAC, 0x9A },
	0xeeb1, { 0xE8, 0xB1, 0x8F },
	0xeeb2, { 0xE8, 0xB1, 0xB0 },
	0xeeb3, { 0xE8, 0xB1, 0xB2 },
	0xeeb4, { 0xE8, 0xB1, 0xB1 },
	0xeeb5, { 0xE8, 0xB1, 0xAF },
	0xeeb6, { 0xE8, 0xB2, 0x95 },
	0xeeb7, { 0xE8, 0xB2, 0x94 },
	0xeeb8, { 0xE8, 0xB3, 0xB9 },
	0xeeb9, { 0xE8, 0xB5, 0xAF },
	0xeeba, { 0xE8, 0xB9, 0x8E },
	0xeebb, { 0xE8, 0xB9, 0x8D },
	0xeebc, { 0xE8, 0xB9, 0x93 },
	0xeebd, { 0xE8, 0xB9, 0x90 },
	0xeebe, { 0xE8, 0xB9, 0x8C },
	0xeebf, { 0xE8, 0xB9, 0x87 },
	0xeec0, { 0xE8, 0xBD, 0x83 },
	0xeec1, { 0xE8, 0xBD, 0x80 },
	0xeec2, { 0xE9, 0x82, 0x85 },
	0xeec3, { 0xE9, 0x81, 0xBE },
	0xeec4, { 0xE9, 0x84, 0xB8 },
	0xeec5, { 0xE9, 0x86, 0x9A },
	0xeec6, { 0xE9, 0x86, 0xA2 },
	0xeec7, { 0xE9, 0x86, 0x9B },
	0xeec8, { 0xE9, 0x86, 0x99 },
	0xeec9, { 0xE9, 0x86, 0x9F },
	0xeeca, { 0xE9, 0x86, 0xA1 },
	0xeecb, { 0xE9, 0x86, 0x9D },
	0xeecc, { 0xE9, 0x86, 0xA0 },
	0xeecd, { 0xE9, 0x8E, 0xA1 },
	0xeece, { 0xE9, 0x8E, 0x83 },
	0xeecf, { 0xE9, 0x8E, 0xAF },
	0xeed0, { 0xE9, 0x8D, 0xA4 },
	0xeed1, { 0xE9, 0x8D, 0x96 },
	0xeed2, { 0xE9, 0x8D, 0x87 },
	0xeed3, { 0xE9, 0x8D, 0xBC },
	0xeed4, { 0xE9, 0x8D, 0x98 },
	0xeed5, { 0xE9, 0x8D, 0x9C },
	0xeed6, { 0xE9, 0x8D, 0xB6 },
	0xeed7, { 0xE9, 0x8D, 0x89 },
	0xeed8, { 0xE9, 0x8D, 0x90 },
	0xeed9, { 0xE9, 0x8D, 0x91 },
	0xeeda, { 0xE9, 0x8D, 0xA0 },
	0xeedb, { 0xE9, 0x8D, 0xAD },
	0xeedc, { 0xE9, 0x8E, 0x8F },
	0xeedd, { 0xE9, 0x8D, 0x8C },
	0xeede, { 0xE9, 0x8D, 0xAA },
	0xeedf, { 0xE9, 0x8D, 0xB9 },
	0xeee0, { 0xE9, 0x8D, 0x97 },
	0xeee1, { 0xE9, 0x8D, 0x95 },
	0xeee2, { 0xE9, 0x8D, 0x92 },
	0xeee3, { 0xE9, 0x8D, 0x8F },
	0xeee4, { 0xE9, 0x8D, 0xB1 },
	0xeee5, { 0xE9, 0x8D, 0xB7 },
	0xeee6, { 0xE9, 0x8D, 0xBB },
	0xeee7, { 0xE9, 0x8D, 0xA1 },
	0xeee8, { 0xE9, 0x8D, 0x9E },
	0xeee9, { 0xE9, 0x8D, 0xA3 },
	0xeeea, { 0xE9, 0x8D, 0xA7 },
	0xeeeb, { 0xE9, 0x8E, 0x80 },
	0xeeec, { 0xE9, 0x8D, 0x8E },
	0xeeed, { 0xE9, 0x8D, 0x99 },
	0xeeee, { 0xE9, 0x97, 0x87 },
	0xeeef, { 0xE9, 0x97, 0x80 },
	0xeef0, { 0xE9, 0x97, 0x89 },
	0xeef1, { 0xE9, 0x97, 0x83 },
	0xeef2, { 0xE9, 0x97, 0x85 },
	0xeef3, { 0xE9, 0x96, 0xB7 },
	0xeef4, { 0xE9, 0x9A, 0xAE },
	0xeef5, { 0xE9, 0x9A, 0xB0 },
	0xeef6, { 0xE9, 0x9A, 0xAC },
	0xeef7, { 0xE9, 0x9C, 0xA0 },
	0xeef8, { 0xE9, 0x9C, 0x9F },
	0xeef9, { 0xE9, 0x9C, 0x98 },
	0xeefa, { 0xE9, 0x9C, 0x9D },
	0xeefb, { 0xE9, 0x9C, 0x99 },
	0xeefc, { 0xE9, 0x9E, 0x9A },
	0xeefd, { 0xE9, 0x9E, 0xA1 },
	0xeefe, { 0xE9, 0x9E, 0x9C },
	0xef40, { 0xE9, 0x9E, 0x9E },
	0xef41, { 0xE9, 0x9E, 0x9D },
	0xef42, { 0xE9, 0x9F, 0x95 },
	0xef43, { 0xE9, 0x9F, 0x94 },
	0xef44, { 0xE9, 0x9F, 0xB1 },
	0xef45, { 0xE9, 0xA1, 0x81 },
	0xef46, { 0xE9, 0xA1, 0x84 },
	0xef47, { 0xE9, 0xA1, 0x8A },
	0xef48, { 0xE9, 0xA1, 0x89 },
	0xef49, { 0xE9, 0xA1, 0x85 },
	0xef4a, { 0xE9, 0xA1, 0x83 },
	0xef4b, { 0xE9, 0xA4, 0xA5 },
	0xef4c, { 0xE9, 0xA4, 0xAB },
	0xef4d, { 0xE9, 0xA4, 0xAC },
	0xef4e, { 0xE9, 0xA4, 0xAA },
	0xef4f, { 0xE9, 0xA4, 0xB3 },
	0xef50, { 0xE9, 0xA4, 0xB2 },
	0xef51, { 0xE9, 0xA4, 0xAF },
	0xef52, { 0xE9, 0xA4, 0xAD },
	0xef53, { 0xE9, 0xA4, 0xB1 },
	0xef54, { 0xE9, 0xA4, 0xB0 },
	0xef55, { 0xE9, 0xA6, 0x98 },
	0xef56, { 0xE9, 0xA6, 0xA3 },
	0xef57, { 0xE9, 0xA6, 0xA1 },
	0xef58, { 0xE9, 0xA8, 0x82 },
	0xef59, { 0xE9, 0xA7, 0xBA },
	0xef5a, { 0xE9, 0xA7, 0xB4 },
	0xef5b, { 0xE9, 0xA7, 0xB7 },
	0xef5c, { 0xE9, 0xA7, 0xB9 },
	0xef5d, { 0xE9, 0xA7, 0xB8 },
	0xef5e, { 0xE9, 0xA7, 0xB6 },
	0xef5f, { 0xE9, 0xA7, 0xBB },
	0xef60, { 0xE9, 0xA7, 0xBD },
	0xef61, { 0xE9, 0xA7, 0xBE },
	0xef62, { 0xE9, 0xA7, 0xBC },
	0xef63, { 0xE9, 0xA8, 0x83 },
	0xef64, { 0xE9, 0xAA, 0xBE },
	0xef65, { 0xE9, 0xAB, 0xBE },
	0xef66, { 0xE9, 0xAB, 0xBD },
	0xef67, { 0xE9, 0xAC, 0x81 },
	0xef68, { 0xE9, 0xAB, 0xBC },
	0xef69, { 0xE9, 0xAD, 0x88 },
	0xef6a, { 0xE9, 0xAE, 0x9A },
	0xef6b, { 0xE9, 0xAE, 0xA8 },
	0xef6c, { 0xE9, 0xAE, 0x9E },
	0xef6d, { 0xE9, 0xAE, 0x9B },
	0xef6e, { 0xE9, 0xAE, 0xA6 },
	0xef6f, { 0xE9, 0xAE, 0xA1 },
	0xef70, { 0xE9, 0xAE, 0xA5 },
	0xef71, { 0xE9, 0xAE, 0xA4 },
	0xef72, { 0xE9, 0xAE, 0x86 },
	0xef73, { 0xE9, 0xAE, 0xA2 },
	0xef74, { 0xE9, 0xAE, 0xA0 },
	0xef75, { 0xE9, 0xAE, 0xAF },
	0xef76, { 0xE9, 0xB4, 0xB3 },
	0xef77, { 0xE9, 0xB5, 0x81 },
	0xef78, { 0xE9, 0xB5, 0xA7 },
	0xef79, { 0xE9, 0xB4, 0xB6 },
	0xef7a, { 0xE9, 0xB4, 0xAE },
	0xef7b, { 0xE9, 0xB4, 0xAF },
	0xef7c, { 0xE9, 0xB4, 0xB1 },
	0xef7d, { 0xE9, 0xB4, 0xB8 },
	0xef7e, { 0xE9, 0xB4, 0xB0 },
	0xefa1, { 0xE9, 0xB5, 0x85 },
	0xefa2, { 0xE9, 0xB5, 0x82 },
	0xefa3, { 0xE9, 0xB5, 0x83 },
	0xefa4, { 0xE9, 0xB4, 0xBE },
	0xefa5, { 0xE9, 0xB4, 0xB7 },
	0xefa6, { 0xE9, 0xB5, 0x80 },
	0xefa7, { 0xE9, 0xB4, 0xBD },
	0xefa8, { 0xE7, 0xBF, 0xB5 },
	0xefa9, { 0xE9, 0xB4, 0xAD },
	0xefaa, { 0xE9, 0xBA, 0x8A },
	0xefab, { 0xE9, 0xBA, 0x89 },
	0xefac, { 0xE9, 0xBA, 0x8D },
	0xefad, { 0xE9, 0xBA, 0xB0 },
	0xefae, { 0xE9, 0xBB, 0x88 },
	0xefaf, { 0xE9, 0xBB, 0x9A },
	0xefb0, { 0xE9, 0xBB, 0xBB },
	0xefb1, { 0xE9, 0xBB, 0xBF },
	0xefb2, { 0xE9, 0xBC, 0xA4 },
	0xefb3, { 0xE9, 0xBC, 0xA3 },
	0xefb4, { 0xE9, 0xBC, 0xA2 },
	0xefb5, { 0xE9, 0xBD, 0x94 },
	0xefb6, { 0xE9, 0xBE, 0xA0 },
	0xefb7, { 0xE5, 0x84, 0xB1 },
	0xefb8, { 0xE5, 0x84, 0xAD },
	0xefb9, { 0xE5, 0x84, 0xAE },
	0xefba, { 0xE5, 0x9A, 0x98 },
	0xefbb, { 0xE5, 0x9A, 0x9C },
	0xefbc, { 0xE5, 0x9A, 0x97 },
	0xefbd, { 0xE5, 0x9A, 0x9A },
	0xefbe, { 0xE5, 0x9A, 0x9D },
	0xefbf, { 0xE5, 0x9A, 0x99 },
	0xefc0, { 0xE5, 0xA5, 0xB0 },
	0xefc1, { 0xE5, 0xAC, 0xBC },
	0xefc2, { 0xE5, 0xB1, 0xA9 },
	0xefc3, { 0xE5, 0xB1, 0xAA },
	0xefc4, { 0xE5, 0xB7, 0x80 },
	0xefc5, { 0xE5, 0xB9, 0xAD },
	0xefc6, { 0xE5, 0xB9, 0xAE },
	0xefc7, { 0xE6, 0x87, 0x98 },
	0xefc8, { 0xE6, 0x87, 0x9F },
	0xefc9, { 0xE6, 0x87, 0xAD },
	0xefca, { 0xE6, 0x87, 0xAE },
	0xefcb, { 0xE6, 0x87, 0xB1 },
	0xefcc, { 0xE6, 0x87, 0xAA },
	0xefcd, { 0xE6, 0x87, 0xB0 },
	0xefce, { 0xE6, 0x87, 0xAB },
	0xefcf, { 0xE6, 0x87, 0x96 },
	0xefd0, { 0xE6, 0x87, 0xA9 },
	0xefd1, { 0xE6, 0x93, 0xBF },
	0xefd2, { 0xE6, 0x94, 0x84 },
	0xefd3, { 0xE6, 0x93, 0xBD },
	0xefd4, { 0xE6, 0x93, 0xB8 },
	0xefd5, { 0xE6, 0x94, 0x81 },
	0xefd6, { 0xE6, 0x94, 0x83 },
	0xefd7, { 0xE6, 0x93, 0xBC },
	0xefd8, { 0xE6, 0x96, 0x94 },
	0xefd9, { 0xE6, 0x97, 0x9B },
	0xefda, { 0xE6, 0x9B, 0x9A },
	0xefdb, { 0xE6, 0x9B, 0x9B },
	0xefdc, { 0xE6, 0x9B, 0x98 },
	0xefdd, { 0xE6, 0xAB, 0x85 },
	0xefde, { 0xE6, 0xAA, 0xB9 },
	0xefdf, { 0xE6, 0xAA, 0xBD },
	0xefe0, { 0xE6, 0xAB, 0xA1 },
	0xefe1, { 0xE6, 0xAB, 0x86 },
	0xefe2, { 0xE6, 0xAA, 0xBA },
	0xefe3, { 0xE6, 0xAA, 0xB6 },
	0xefe4, { 0xE6, 0xAA, 0xB7 },
	0xefe5, { 0xE6, 0xAB, 0x87 },
	0xefe6, { 0xE6, 0xAA, 0xB4 },
	0xefe7, { 0xE6, 0xAA, 0xAD },
	0xefe8, { 0xE6, 0xAD, 0x9E },
	0xefe9, { 0xE6, 0xAF, 0x89 },
	0xefea, { 0xE6, 0xB0, 0x8B },
	0xefeb, { 0xE7, 0x80, 0x87 },
	0xefec, { 0xE7, 0x80, 0x8C },
	0xefed, { 0xE7, 0x80, 0x8D },
	0xefee, { 0xE7, 0x80, 0x81 },
	0xefef, { 0xE7, 0x80, 0x85 },
	0xeff0, { 0xE7, 0x80, 0x94 },
	0xeff1, { 0xE7, 0x80, 0x8E },
	0xeff2, { 0xE6, 0xBF, 0xBF },
	0xeff3, { 0xE7, 0x80, 0x80 },
	0xeff4, { 0xE6, 0xBF, 0xBB },
	0xeff5, { 0xE7, 0x80, 0xA6 },
	0xeff6, { 0xE6, 0xBF, 0xBC },
	0xeff7, { 0xE6, 0xBF, 0xB7 },
	0xeff8, { 0xE7, 0x80, 0x8A },
	0xeff9, { 0xE7, 0x88, 0x81 },
	0xeffa, { 0xE7, 0x87, 0xBF },
	0xeffb, { 0xE7, 0x87, 0xB9 },
	0xeffc, { 0xE7, 0x88, 0x83 },
	0xeffd, { 0xE7, 0x87, 0xBD },
	0xeffe, { 0xE7, 0x8D, 0xB6 },
	0xf040, { 0xE7, 0x92, 0xB8 },
	0xf041, { 0xE7, 0x93, 0x80 },
	0xf042, { 0xE7, 0x92, 0xB5 },
	0xf043, { 0xE7, 0x93, 0x81 },
	0xf044, { 0xE7, 0x92, 0xBE },
	0xf045, { 0xE7, 0x92, 0xB6 },
	0xf046, { 0xE7, 0x92, 0xBB },
	0xf047, { 0xE7, 0x93, 0x82 },
	0xf048, { 0xE7, 0x94, 0x94 },
	0xf049, { 0xE7, 0x94, 0x93 },
	0xf04a, { 0xE7, 0x99, 0x9C },
	0xf04b, { 0xE7, 0x99, 0xA4 },
	0xf04c, { 0xE7, 0x99, 0x99 },
	0xf04d, { 0xE7, 0x99, 0x90 },
	0xf04e, { 0xE7, 0x99, 0x93 },
	0xf04f, { 0xE7, 0x99, 0x97 },
	0xf050, { 0xE7, 0x99, 0x9A },
	0xf051, { 0xE7, 0x9A, 0xA6 },
	0xf052, { 0xE7, 0x9A, 0xBD },
	0xf053, { 0xE7, 0x9B, 0xAC },
	0xf054, { 0xE7, 0x9F, 0x82 },
	0xf055, { 0xE7, 0x9E, 0xBA },
	0xf056, { 0xE7, 0xA3, 0xBF },
	0xf057, { 0xE7, 0xA4, 0x8C },
	0xf058, { 0xE7, 0xA4, 0x93 },
	0xf059, { 0xE7, 0xA4, 0x94 },
	0xf05a, { 0xE7, 0xA4, 0x89 },
	0xf05b, { 0xE7, 0xA4, 0x90 },
	0xf05c, { 0xE7, 0xA4, 0x92 },
	0xf05d, { 0xE7, 0xA4, 0x91 },
	0xf05e, { 0xE7, 0xA6, 0xAD },
	0xf05f, { 0xE7, 0xA6, 0xAC },
	0xf060, { 0xE7, 0xA9, 0x9F },
	0xf061, { 0xE7, 0xB0, 0x9C },
	0xf062, { 0xE7, 0xB0, 0xA9 },
	0xf063, { 0xE7, 0xB0, 0x99 },
	0xf064, { 0xE7, 0xB0, 0xA0 },
	0xf065, { 0xE7, 0xB0, 0x9F },
	0xf066, { 0xE7, 0xB0, 0xAD },
	0xf067, { 0xE7, 0xB0, 0x9D },
	0xf068, { 0xE7, 0xB0, 0xA6 },
	0xf069, { 0xE7, 0xB0, 0xA8 },
	0xf06a, { 0xE7, 0xB0, 0xA2 },
	0xf06b, { 0xE7, 0xB0, 0xA5 },
	0xf06c, { 0xE7, 0xB0, 0xB0 },
	0xf06d, { 0xE7, 0xB9, 0x9C },
	0xf06e, { 0xE7, 0xB9, 0x90 },
	0xf06f, { 0xE7, 0xB9, 0x96 },
	0xf070, { 0xE7, 0xB9, 0xA3 },
	0xf071, { 0xE7, 0xB9, 0x98 },
	0xf072, { 0xE7, 0xB9, 0xA2 },
	0xf073, { 0xE7, 0xB9, 0x9F },
	0xf074, { 0xE7, 0xB9, 0x91 },
	0xf075, { 0xE7, 0xB9, 0xA0 },
	0xf076, { 0xE7, 0xB9, 0x97 },
	0xf077, { 0xE7, 0xB9, 0x93 },
	0xf078, { 0xE7, 0xBE, 0xB5 },
	0xf079, { 0xE7, 0xBE, 0xB3 },
	0xf07a, { 0xE7, 0xBF, 0xB7 },
	0xf07b, { 0xE7, 0xBF, 0xB8 },
	0xf07c, { 0xE8, 0x81, 0xB5 },
	0xf07d, { 0xE8, 0x87, 0x91 },
	0xf07e, { 0xE8, 0x87, 0x92 },
	0xf0a1, { 0xE8, 0x87, 0x90 },
	0xf0a2, { 0xE8, 0x89, 0x9F },
	0xf0a3, { 0xE8, 0x89, 0x9E },
	0xf0a4, { 0xE8, 0x96, 0xB4 },
	0xf0a5, { 0xE8, 0x97, 0x86 },
	0xf0a6, { 0xE8, 0x97, 0x80 },
	0xf0a7, { 0xE8, 0x97, 0x83 },
	0xf0a8, { 0xE8, 0x97, 0x82 },
	0xf0a9, { 0xE8, 0x96, 0xB3 },
	0xf0aa, { 0xE8, 0x96, 0xB5 },
	0xf0ab, { 0xE8, 0x96, 0xBD },
	0xf0ac, { 0xE8, 0x97, 0x87 },
	0xf0ad, { 0xE8, 0x97, 0x84 },
	0xf0ae, { 0xE8, 0x96, 0xBF },
	0xf0af, { 0xE8, 0x97, 0x8B },
	0xf0b0, { 0xE8, 0x97, 0x8E },
	0xf0b1, { 0xE8, 0x97, 0x88 },
	0xf0b2, { 0xE8, 0x97, 0x85 },
	0xf0b3, { 0xE8, 0x96, 0xB1 },
	0xf0b4, { 0xE8, 0x96, 0xB6 },
	0xf0b5, { 0xE8, 0x97, 0x92 },
	0xf0b6, { 0xE8, 0x98, 0xA4 },
	0xf0b7, { 0xE8, 0x96, 0xB8 },
	0xf0b8, { 0xE8, 0x96, 0xB7 },
	0xf0b9, { 0xE8, 0x96, 0xBE },
	0xf0ba, { 0xE8, 0x99, 0xA9 },
	0xf0bb, { 0xE8, 0x9F, 0xA7 },
	0xf0bc, { 0xE8, 0x9F, 0xA6 },
	0xf0bd, { 0xE8, 0x9F, 0xA2 },
	0xf0be, { 0xE8, 0x9F, 0x9B },
	0xf0bf, { 0xE8, 0x9F, 0xAB },
	0xf0c0, { 0xE8, 0x9F, 0xAA },
	0xf0c1, { 0xE8, 0x9F, 0xA5 },
	0xf0c2, { 0xE8, 0x9F, 0x9F },
	0xf0c3, { 0xE8, 0x9F, 0xB3 },
	0xf0c4, { 0xE8, 0x9F, 0xA4 },
	0xf0c5, { 0xE8, 0x9F, 0x94 },
	0xf0c6, { 0xE8, 0x9F, 0x9C },
	0xf0c7, { 0xE8, 0x9F, 0x93 },
	0xf0c8, { 0xE8, 0x9F, 0xAD },
	0xf0c9, { 0xE8, 0x9F, 0x98 },
	0xf0ca, { 0xE8, 0x9F, 0xA3 },
	0xf0cb, { 0xE8, 0x9E, 0xA4 },
	0xf0cc, { 0xE8, 0x9F, 0x97 },
	0xf0cd, { 0xE8, 0x9F, 0x99 },
	0xf0ce, { 0xE8, 0xA0, 0x81 },
	0xf0cf, { 0xE8, 0x9F, 0xB4 },
	0xf0d0, { 0xE8, 0x9F, 0xA8 },
	0xf0d1, { 0xE8, 0x9F, 0x9D },
	0xf0d2, { 0xE8, 0xA5, 0x93 },
	0xf0d3, { 0xE8, 0xA5, 0x8B },
	0xf0d4, { 0xE8, 0xA5, 0x8F },
	0xf0d5, { 0xE8, 0xA5, 0x8C },
	0xf0d6, { 0xE8, 0xA5, 0x86 },
	0xf0d7, { 0xE8, 0xA5, 0x90 },
	0xf0d8, { 0xE8, 0xA5, 0x91 },
	0xf0d9, { 0xE8, 0xA5, 0x89 },
	0xf0da, { 0xE8, 0xAC, 0xAA },
	0xf0db, { 0xE8, 0xAC, 0xA7 },
	0xf0dc, { 0xE8, 0xAC, 0xA3 },
	0xf0dd, { 0xE8, 0xAC, 0xB3 },
	0xf0de, { 0xE8, 0xAC, 0xB0 },
	0xf0df, { 0xE8, 0xAC, 0xB5 },
	0xf0e0, { 0xE8, 0xAD, 0x87 },
	0xf0e1, { 0xE8, 0xAC, 0xAF },
	0xf0e2, { 0xE8, 0xAC, 0xBC },
	0xf0e3, { 0xE8, 0xAC, 0xBE },
	0xf0e4, { 0xE8, 0xAC, 0xB1 },
	0xf0e5, { 0xE8, 0xAC, 0xA5 },
	0xf0e6, { 0xE8, 0xAC, 0xB7 },
	0xf0e7, { 0xE8, 0xAC, 0xA6 },
	0xf0e8, { 0xE8, 0xAC, 0xB6 },
	0xf0e9, { 0xE8, 0xAC, 0xAE },
	0xf0ea, { 0xE8, 0xAC, 0xA4 },
	0xf0eb, { 0xE8, 0xAC, 0xBB },
	0xf0ec, { 0xE8, 0xAC, 0xBD },
	0xf0ed, { 0xE8, 0xAC, 0xBA },
	0xf0ee, { 0xE8, 0xB1, 0x82 },
	0xf0ef, { 0xE8, 0xB1, 0xB5 },
	0xf0f0, { 0xE8, 0xB2, 0x99 },
	0xf0f1, { 0xE8, 0xB2, 0x98 },
	0xf0f2, { 0xE8, 0xB2, 0x97 },
	0xf0f3, { 0xE8, 0xB3, 0xBE },
	0xf0f4, { 0xE8, 0xB4, 0x84 },
	0xf0f5, { 0xE8, 0xB4, 0x82 },
	0xf0f6, { 0xE8, 0xB4, 0x80 },
	0xf0f7, { 0xE8, 0xB9, 0x9C },
	0xf0f8, { 0xE8, 0xB9, 0xA2 },
	0xf0f9, { 0xE8, 0xB9, 0xA0 },
	0xf0fa, { 0xE8, 0xB9, 0x97 },
	0xf0fb, { 0xE8, 0xB9, 0x96 },
	0xf0fc, { 0xE8, 0xB9, 0x9E },
	0xf0fd, { 0xE8, 0xB9, 0xA5 },
	0xf0fe, { 0xE8, 0xB9, 0xA7 },
	0xf140, { 0xE8, 0xB9, 0x9B },
	0xf141, { 0xE8, 0xB9, 0x9A },
	0xf142, { 0xE8, 0xB9, 0xA1 },
	0xf143, { 0xE8, 0xB9, 0x9D },
	0xf144, { 0xE8, 0xB9, 0xA9 },
	0xf145, { 0xE8, 0xB9, 0x94 },
	0xf146, { 0xE8, 0xBD, 0x86 },
	0xf147, { 0xE8, 0xBD, 0x87 },
	0xf148, { 0xE8, 0xBD, 0x88 },
	0xf149, { 0xE8, 0xBD, 0x8B },
	0xf14a, { 0xE9, 0x84, 0xA8 },
	0xf14b, { 0xE9, 0x84, 0xBA },
	0xf14c, { 0xE9, 0x84, 0xBB },
	0xf14d, { 0xE9, 0x84, 0xBE },
	0xf14e, { 0xE9, 0x86, 0xA8 },
	0xf14f, { 0xE9, 0x86, 0xA5 },
	0xf150, { 0xE9, 0x86, 0xA7 },
	0xf151, { 0xE9, 0x86, 0xAF },
	0xf152, { 0xE9, 0x86, 0xAA },
	0xf153, { 0xE9, 0x8E, 0xB5 },
	0xf154, { 0xE9, 0x8E, 0x8C },
	0xf155, { 0xE9, 0x8E, 0x92 },
	0xf156, { 0xE9, 0x8E, 0xB7 },
	0xf157, { 0xE9, 0x8E, 0x9B },
	0xf158, { 0xE9, 0x8E, 0x9D },
	0xf159, { 0xE9, 0x8E, 0x89 },
	0xf15a, { 0xE9, 0x8E, 0xA7 },
	0xf15b, { 0xE9, 0x8E, 0x8E },
	0xf15c, { 0xE9, 0x8E, 0xAA },
	0xf15d, { 0xE9, 0x8E, 0x9E },
	0xf15e, { 0xE9, 0x8E, 0xA6 },
	0xf15f, { 0xE9, 0x8E, 0x95 },
	0xf160, { 0xE9, 0x8E, 0x88 },
	0xf161, { 0xE9, 0x8E, 0x99 },
	0xf162, { 0xE9, 0x8E, 0x9F },
	0xf163, { 0xE9, 0x8E, 0x8D },
	0xf164, { 0xE9, 0x8E, 0xB1 },
	0xf165, { 0xE9, 0x8E, 0x91 },
	0xf166, { 0xE9, 0x8E, 0xB2 },
	0xf167, { 0xE9, 0x8E, 0xA4 },
	0xf168, { 0xE9, 0x8E, 0xA8 },
	0xf169, { 0xE9, 0x8E, 0xB4 },
	0xf16a, { 0xE9, 0x8E, 0xA3 },
	0xf16b, { 0xE9, 0x8E, 0xA5 },
	0xf16c, { 0xE9, 0x97, 0x92 },
	0xf16d, { 0xE9, 0x97, 0x93 },
	0xf16e, { 0xE9, 0x97, 0x91 },
	0xf16f, { 0xE9, 0x9A, 0xB3 },
	0xf170, { 0xE9, 0x9B, 0x97 },
	0xf171, { 0xE9, 0x9B, 0x9A },
	0xf172, { 0xE5, 0xB7, 0x82 },
	0xf173, { 0xE9, 0x9B, 0x9F },
	0xf174, { 0xE9, 0x9B, 0x98 },
	0xf175, { 0xE9, 0x9B, 0x9D },
	0xf176, { 0xE9, 0x9C, 0xA3 },
	0xf177, { 0xE9, 0x9C, 0xA2 },
	0xf178, { 0xE9, 0x9C, 0xA5 },
	0xf179, { 0xE9, 0x9E, 0xAC },
	0xf17a, { 0xE9, 0x9E, 0xAE },
	0xf17b, { 0xE9, 0x9E, 0xA8 },
	0xf17c, { 0xE9, 0x9E, 0xAB },
	0xf17d, { 0xE9, 0x9E, 0xA4 },
	0xf17e, { 0xE9, 0x9E, 0xAA },
	0xf1a1, { 0xE9, 0x9E, 0xA2 },
	0xf1a2, { 0xE9, 0x9E, 0xA5 },
	0xf1a3, { 0xE9, 0x9F, 0x97 },
	0xf1a4, { 0xE9, 0x9F, 0x99 },
	0xf1a5, { 0xE9, 0x9F, 0x96 },
	0xf1a6, { 0xE9, 0x9F, 0x98 },
	0xf1a7, { 0xE9, 0x9F, 0xBA },
	0xf1a8, { 0xE9, 0xA1, 0x90 },
	0xf1a9, { 0xE9, 0xA1, 0x91 },
	0xf1aa, { 0xE9, 0xA1, 0x92 },
	0xf1ab, { 0xE9, 0xA2, 0xB8 },
	0xf1ac, { 0xE9, 0xA5, 0x81 },
	0xf1ad, { 0xE9, 0xA4, 0xBC },
	0xf1ae, { 0xE9, 0xA4, 0xBA },
	0xf1af, { 0xE9, 0xA8, 0x8F },
	0xf1b0, { 0xE9, 0xA8, 0x8B },
	0xf1b1, { 0xE9, 0xA8, 0x89 },
	0xf1b2, { 0xE9, 0xA8, 0x8D },
	0xf1b3, { 0xE9, 0xA8, 0x84 },
	0xf1b4, { 0xE9, 0xA8, 0x91 },
	0xf1b5, { 0xE9, 0xA8, 0x8A },
	0xf1b6, { 0xE9, 0xA8, 0x85 },
	0xf1b7, { 0xE9, 0xA8, 0x87 },
	0xf1b8, { 0xE9, 0xA8, 0x86 },
	0xf1b9, { 0xE9, 0xAB, 0x80 },
	0xf1ba, { 0xE9, 0xAB, 0x9C },
	0xf1bb, { 0xE9, 0xAC, 0x88 },
	0xf1bc, { 0xE9, 0xAC, 0x84 },
	0xf1bd, { 0xE9, 0xAC, 0x85 },
	0xf1be, { 0xE9, 0xAC, 0xA9 },
	0xf1bf, { 0xE9, 0xAC, 0xB5 },
	0xf1c0, { 0xE9, 0xAD, 0x8A },
	0xf1c1, { 0xE9, 0xAD, 0x8C },
	0xf1c2, { 0xE9, 0xAD, 0x8B },
	0xf1c3, { 0xE9, 0xAF, 0x87 },
	0xf1c4, { 0xE9, 0xAF, 0x86 },
	0xf1c5, { 0xE9, 0xAF, 0x83 },
	0xf1c6, { 0xE9, 0xAE, 0xBF },
	0xf1c7, { 0xE9, 0xAF, 0x81 },
	0xf1c8, { 0xE9, 0xAE, 0xB5 },
	0xf1c9, { 0xE9, 0xAE, 0xB8 },
	0xf1ca, { 0xE9, 0xAF, 0x93 },
	0xf1cb, { 0xE9, 0xAE, 0xB6 },
	0xf1cc, { 0xE9, 0xAF, 0x84 },
	0xf1cd, { 0xE9, 0xAE, 0xB9 },
	0xf1ce, { 0xE9, 0xAE, 0xBD },
	0xf1cf, { 0xE9, 0xB5, 0x9C },
	0xf1d0, { 0xE9, 0xB5, 0x93 },
	0xf1d1, { 0xE9, 0xB5, 0x8F },
	0xf1d2, { 0xE9, 0xB5, 0x8A },
	0xf1d3, { 0xE9, 0xB5, 0x9B },
	0xf1d4, { 0xE9, 0xB5, 0x8B },
	0xf1d5, { 0xE9, 0xB5, 0x99 },
	0xf1d6, { 0xE9, 0xB5, 0x96 },
	0xf1d7, { 0xE9, 0xB5, 0x8C },
	0xf1d8, { 0xE9, 0xB5, 0x97 },
	0xf1d9, { 0xE9, 0xB5, 0x92 },
	0xf1da, { 0xE9, 0xB5, 0x94 },
	0xf1db, { 0xE9, 0xB5, 0x9F },
	0xf1dc, { 0xE9, 0xB5, 0x98 },
	0xf1dd, { 0xE9, 0xB5, 0x9A },
	0xf1de, { 0xE9, 0xBA, 0x8E },
	0xf1df, { 0xE9, 0xBA, 0x8C },
	0xf1e0, { 0xE9, 0xBB, 0x9F },
	0xf1e1, { 0xE9, 0xBC, 0x81 },
	0xf1e2, { 0xE9, 0xBC, 0x80 },
	0xf1e3, { 0xE9, 0xBC, 0x96 },
	0xf1e4, { 0xE9, 0xBC, 0xA5 },
	0xf1e5, { 0xE9, 0xBC, 0xAB },
	0xf1e6, { 0xE9, 0xBC, 0xAA },
	0xf1e7, { 0xE9, 0xBC, 0xA9 },
	0xf1e8, { 0xE9, 0xBC, 0xA8 },
	0xf1e9, { 0xE9, 0xBD, 0x8C },
	0xf1ea, { 0xE9, 0xBD, 0x95 },
	0xf1eb, { 0xE5, 0x84, 0xB4 },
	0xf1ec, { 0xE5, 0x84, 0xB5 },
	0xf1ed, { 0xE5, 0x8A, 0x96 },
	0xf1ee, { 0xE5, 0x8B, 0xB7 },
	0xf1ef, { 0xE5, 0x8E, 0xB4 },
	0xf1f0, { 0xE5, 0x9A, 0xAB },
	0xf1f1, { 0xE5, 0x9A, 0xAD },
	0xf1f2, { 0xE5, 0x9A, 0xA6 },
	0xf1f3, { 0xE5, 0x9A, 0xA7 },
	0xf1f4, { 0xE5, 0x9A, 0xAA },
	0xf1f5, { 0xE5, 0x9A, 0xAC },
	0xf1f6, { 0xE5, 0xA3, 0x9A },
	0xf1f7, { 0xE5, 0xA3, 0x9D },
	0xf1f8, { 0xE5, 0xA3, 0x9B },
	0xf1f9, { 0xE5, 0xA4, 0x92 },
	0xf1fa, { 0xE5, 0xAC, 0xBD },
	0xf1fb, { 0xE5, 0xAC, 0xBE },
	0xf1fc, { 0xE5, 0xAC, 0xBF },
	0xf1fd, { 0xE5, 0xB7, 0x83 },
	0xf1fe, { 0xE5, 0xB9, 0xB0 },
	0xf240, { 0xE5, 0xBE, 0xBF },
	0xf241, { 0xE6, 0x87, 0xBB },
	0xf242, { 0xE6, 0x94, 0x87 },
	0xf243, { 0xE6, 0x94, 0x90 },
	0xf244, { 0xE6, 0x94, 0x8D },
	0xf245, { 0xE6, 0x94, 0x89 },
	0xf246, { 0xE6, 0x94, 0x8C },
	0xf247, { 0xE6, 0x94, 0x8E },
	0xf248, { 0xE6, 0x96, 0x84 },
	0xf249, { 0xE6, 0x97, 0x9E },
	0xf24a, { 0xE6, 0x97, 0x9D },
	0xf24b, { 0xE6, 0x9B, 0x9E },
	0xf24c, { 0xE6, 0xAB, 0xA7 },
	0xf24d, { 0xE6, 0xAB, 0xA0 },
	0xf24e, { 0xE6, 0xAB, 0x8C },
	0xf24f, { 0xE6, 0xAB, 0x91 },
	0xf250, { 0xE6, 0xAB, 0x99 },
	0xf251, { 0xE6, 0xAB, 0x8B },
	0xf252, { 0xE6, 0xAB, 0x9F },
	0xf253, { 0xE6, 0xAB, 0x9C },
	0xf254, { 0xE6, 0xAB, 0x90 },
	0xf255, { 0xE6, 0xAB, 0xAB },
	0xf256, { 0xE6, 0xAB, 0x8F },
	0xf257, { 0xE6, 0xAB, 0x8D },
	0xf258, { 0xE6, 0xAB, 0x9E },
	0xf259, { 0xE6, 0xAD, 0xA0 },
	0xf25a, { 0xE6, 0xAE, 0xB0 },
	0xf25b, { 0xE6, 0xB0, 0x8C },
	0xf25c, { 0xE7, 0x80, 0x99 },
	0xf25d, { 0xE7, 0x80, 0xA7 },
	0xf25e, { 0xE7, 0x80, 0xA0 },
	0xf25f, { 0xE7, 0x80, 0x96 },
	0xf260, { 0xE7, 0x80, 0xAB },
	0xf261, { 0xE7, 0x80, 0xA1 },
	0xf262, { 0xE7, 0x80, 0xA2 },
	0xf263, { 0xE7, 0x80, 0xA3 },
	0xf264, { 0xE7, 0x80, 0xA9 },
	0xf265, { 0xE7, 0x80, 0x97 },
	0xf266, { 0xE7, 0x80, 0xA4 },
	0xf267, { 0xE7, 0x80, 0x9C },
	0xf268, { 0xE7, 0x80, 0xAA },
	0xf269, { 0xE7, 0x88, 0x8C },
	0xf26a, { 0xE7, 0x88, 0x8A },
	0xf26b, { 0xE7, 0x88, 0x87 },
	0xf26c, { 0xE7, 0x88, 0x82 },
	0xf26d, { 0xE7, 0x88, 0x85 },
	0xf26e, { 0xE7, 0x8A, 0xA5 },
	0xf26f, { 0xE7, 0x8A, 0xA6 },
	0xf270, { 0xE7, 0x8A, 0xA4 },
	0xf271, { 0xE7, 0x8A, 0xA3 },
	0xf272, { 0xE7, 0x8A, 0xA1 },
	0xf273, { 0xE7, 0x93, 0x8B },
	0xf274, { 0xE7, 0x93, 0x85 },
	0xf275, { 0xE7, 0x92, 0xB7 },
	0xf276, { 0xE7, 0x93, 0x83 },
	0xf277, { 0xE7, 0x94, 0x96 },
	0xf278, { 0xE7, 0x99, 0xA0 },
	0xf279, { 0xE7, 0x9F, 0x89 },
	0xf27a, { 0xE7, 0x9F, 0x8A },
	0xf27b, { 0xE7, 0x9F, 0x84 },
	0xf27c, { 0xE7, 0x9F, 0xB1 },
	0xf27d, { 0xE7, 0xA4, 0x9D },
	0xf27e, { 0xE7, 0xA4, 0x9B },
	0xf2a1, { 0xE7, 0xA4, 0xA1 },
	0xf2a2, { 0xE7, 0xA4, 0x9C },
	0xf2a3, { 0xE7, 0xA4, 0x97 },
	0xf2a4, { 0xE7, 0xA4, 0x9E },
	0xf2a5, { 0xE7, 0xA6, 0xB0 },
	0xf2a6, { 0xE7, 0xA9, 0xA7 },
	0xf2a7, { 0xE7, 0xA9, 0xA8 },
	0xf2a8, { 0xE7, 0xB0, 0xB3 },
	0xf2a9, { 0xE7, 0xB0, 0xBC },
	0xf2aa, { 0xE7, 0xB0, 0xB9 },
	0xf2ab, { 0xE7, 0xB0, 0xAC },
	0xf2ac, { 0xE7, 0xB0, 0xBB },
	0xf2ad, { 0xE7, 0xB3, 0xAC },
	0xf2ae, { 0xE7, 0xB3, 0xAA },
	0xf2af, { 0xE7, 0xB9, 0xB6 },
	0xf2b0, { 0xE7, 0xB9, 0xB5 },
	0xf2b1, { 0xE7, 0xB9, 0xB8 },
	0xf2b2, { 0xE7, 0xB9, 0xB0 },
	0xf2b3, { 0xE7, 0xB9, 0xB7 },
	0xf2b4, { 0xE7, 0xB9, 0xAF },
	0xf2b5, { 0xE7, 0xB9, 0xBA },
	0xf2b6, { 0xE7, 0xB9, 0xB2 },
	0xf2b7, { 0xE7, 0xB9, 0xB4 },
	0xf2b8, { 0xE7, 0xB9, 0xA8 },
	0xf2b9, { 0xE7, 0xBD, 0x8B },
	0xf2ba, { 0xE7, 0xBD, 0x8A },
	0xf2bb, { 0xE7, 0xBE, 0x83 },
	0xf2bc, { 0xE7, 0xBE, 0x86 },
	0xf2bd, { 0xE7, 0xBE, 0xB7 },
	0xf2be, { 0xE7, 0xBF, 0xBD },
	0xf2bf, { 0xE7, 0xBF, 0xBE },
	0xf2c0, { 0xE8, 0x81, 0xB8 },
	0xf2c1, { 0xE8, 0x87, 0x97 },
	0xf2c2, { 0xE8, 0x87, 0x95 },
	0xf2c3, { 0xE8, 0x89, 0xA4 },
	0xf2c4, { 0xE8, 0x89, 0xA1 },
	0xf2c5, { 0xE8, 0x89, 0xA3 },
	0xf2c6, { 0xE8, 0x97, 0xAB },
	0xf2c7, { 0xE8, 0x97, 0xB1 },
	0xf2c8, { 0xE8, 0x97, 0xAD },
	0xf2c9, { 0xE8, 0x97, 0x99 },
	0xf2ca, { 0xE8, 0x97, 0xA1 },
	0xf2cb, { 0xE8, 0x97, 0xA8 },
	0xf2cc, { 0xE8, 0x97, 0x9A },
	0xf2cd, { 0xE8, 0x97, 0x97 },
	0xf2ce, { 0xE8, 0x97, 0xAC },
	0xf2cf, { 0xE8, 0x97, 0xB2 },
	0xf2d0, { 0xE8, 0x97, 0xB8 },
	0xf2d1, { 0xE8, 0x97, 0x98 },
	0xf2d2, { 0xE8, 0x97, 0x9F },
	0xf2d3, { 0xE8, 0x97, 0xA3 },
	0xf2d4, { 0xE8, 0x97, 0x9C },
	0xf2d5, { 0xE8, 0x97, 0x91 },
	0xf2d6, { 0xE8, 0x97, 0xB0 },
	0xf2d7, { 0xE8, 0x97, 0xA6 },
	0xf2d8, { 0xE8, 0x97, 0xAF },
	0xf2d9, { 0xE8, 0x97, 0x9E },
	0xf2da, { 0xE8, 0x97, 0xA2 },
	0xf2db, { 0xE8, 0xA0, 0x80 },
	0xf2dc, { 0xE8, 0x9F, 0xBA },
	0xf2dd, { 0xE8, 0xA0, 0x83 },
	0xf2de, { 0xE8, 0x9F, 0xB6 },
	0xf2df, { 0xE8, 0x9F, 0xB7 },
	0xf2e0, { 0xE8, 0xA0, 0x89 },
	0xf2e1, { 0xE8, 0xA0, 0x8C },
	0xf2e2, { 0xE8, 0xA0, 0x8B },
	0xf2e3, { 0xE8, 0xA0, 0x86 },
	0xf2e4, { 0xE8, 0x9F, 0xBC },
	0xf2e5, { 0xE8, 0xA0, 0x88 },
	0xf2e6, { 0xE8, 0x9F, 0xBF },
	0xf2e7, { 0xE8, 0xA0, 0x8A },
	0xf2e8, { 0xE8, 0xA0, 0x82 },
	0xf2e9, { 0xE8, 0xA5, 0xA2 },
	0xf2ea, { 0xE8, 0xA5, 0x9A },
	0xf2eb, { 0xE8, 0xA5, 0x9B },
	0xf2ec, { 0xE8, 0xA5, 0x97 },
	0xf2ed, { 0xE8, 0xA5, 0xA1 },
	0xf2ee, { 0xE8, 0xA5, 0x9C },
	0xf2ef, { 0xE8, 0xA5, 0x98 },
	0xf2f0, { 0xE8, 0xA5, 0x9D },
	0xf2f1, { 0xE8, 0xA5, 0x99 },
	0xf2f2, { 0xE8, 0xA6, 0x88 },
	0xf2f3, { 0xE8, 0xA6, 0xB7 },
	0xf2f4, { 0xE8, 0xA6, 0xB6 },
	0xf2f5, { 0xE8, 0xA7, 0xB6 },
	0xf2f6, { 0xE8, 0xAD, 0x90 },
	0xf2f7, { 0xE8, 0xAD, 0x88 },
	0xf2f8, { 0xE8, 0xAD, 0x8A },
	0xf2f9, { 0xE8, 0xAD, 0x80 },
	0xf2fa, { 0xE8, 0xAD, 0x93 },
	0xf2fb, { 0xE8, 0xAD, 0x96 },
	0xf2fc, { 0xE8, 0xAD, 0x94 },
	0xf2fd, { 0xE8, 0xAD, 0x8B },
	0xf2fe, { 0xE8, 0xAD, 0x95 },
	0xf340, { 0xE8, 0xAD, 0x91 },
	0xf341, { 0xE8, 0xAD, 0x82 },
	0xf342, { 0xE8, 0xAD, 0x92 },
	0xf343, { 0xE8, 0xAD, 0x97 },
	0xf344, { 0xE8, 0xB1, 0x83 },
	0xf345, { 0xE8, 0xB1, 0xB7 },
	0xf346, { 0xE8, 0xB1, 0xB6 },
	0xf347, { 0xE8, 0xB2, 0x9A },
	0xf348, { 0xE8, 0xB4, 0x86 },
	0xf349, { 0xE8, 0xB4, 0x87 },
	0xf34a, { 0xE8, 0xB4, 0x89 },
	0xf34b, { 0xE8, 0xB6, 0xAC },
	0xf34c, { 0xE8, 0xB6, 0xAA },
	0xf34d, { 0xE8, 0xB6, 0xAD },
	0xf34e, { 0xE8, 0xB6, 0xAB },
	0xf34f, { 0xE8, 0xB9, 0xAD },
	0xf350, { 0xE8, 0xB9, 0xB8 },
	0xf351, { 0xE8, 0xB9, 0xB3 },
	0xf352, { 0xE8, 0xB9, 0xAA },
	0xf353, { 0xE8, 0xB9, 0xAF },
	0xf354, { 0xE8, 0xB9, 0xBB },
	0xf355, { 0xE8, 0xBB, 0x82 },
	0xf356, { 0xE8, 0xBD, 0x92 },
	0xf357, { 0xE8, 0xBD, 0x91 },
	0xf358, { 0xE8, 0xBD, 0x8F },
	0xf359, { 0xE8, 0xBD, 0x90 },
	0xf35a, { 0xE8, 0xBD, 0x93 },
	0xf35b, { 0xE8, 0xBE, 0xB4 },
	0xf35c, { 0xE9, 0x85, 0x80 },
	0xf35d, { 0xE9, 0x84, 0xBF },
	0xf35e, { 0xE9, 0x86, 0xB0 },
	0xf35f, { 0xE9, 0x86, 0xAD },
	0xf360, { 0xE9, 0x8F, 0x9E },
	0xf361, { 0xE9, 0x8F, 0x87 },
	0xf362, { 0xE9, 0x8F, 0x8F },
	0xf363, { 0xE9, 0x8F, 0x82 },
	0xf364, { 0xE9, 0x8F, 0x9A },
	0xf365, { 0xE9, 0x8F, 0x90 },
	0xf366, { 0xE9, 0x8F, 0xB9 },
	0xf367, { 0xE9, 0x8F, 0xAC },
	0xf368, { 0xE9, 0x8F, 0x8C },
	0xf369, { 0xE9, 0x8F, 0x99 },
	0xf36a, { 0xE9, 0x8E, 0xA9 },
	0xf36b, { 0xE9, 0x8F, 0xA6 },
	0xf36c, { 0xE9, 0x8F, 0x8A },
	0xf36d, { 0xE9, 0x8F, 0x94 },
	0xf36e, { 0xE9, 0x8F, 0xAE },
	0xf36f, { 0xE9, 0x8F, 0xA3 },
	0xf370, { 0xE9, 0x8F, 0x95 },
	0xf371, { 0xE9, 0x8F, 0x84 },
	0xf372, { 0xE9, 0x8F, 0x8E },
	0xf373, { 0xE9, 0x8F, 0x80 },
	0xf374, { 0xE9, 0x8F, 0x92 },
	0xf375, { 0xE9, 0x8F, 0xA7 },
	0xf376, { 0xE9, 0x95, 0xBD },
	0xf377, { 0xE9, 0x97, 0x9A },
	0xf378, { 0xE9, 0x97, 0x9B },
	0xf379, { 0xE9, 0x9B, 0xA1 },
	0xf37a, { 0xE9, 0x9C, 0xA9 },
	0xf37b, { 0xE9, 0x9C, 0xAB },
	0xf37c, { 0xE9, 0x9C, 0xAC },
	0xf37d, { 0xE9, 0x9C, 0xA8 },
	0xf37e, { 0xE9, 0x9C, 0xA6 },
	0xf3a1, { 0xE9, 0x9E, 0xB3 },
	0xf3a2, { 0xE9, 0x9E, 0xB7 },
	0xf3a3, { 0xE9, 0x9E, 0xB6 },
	0xf3a4, { 0xE9, 0x9F, 0x9D },
	0xf3a5, { 0xE9, 0x9F, 0x9E },
	0xf3a6, { 0xE9, 0x9F, 0x9F },
	0xf3a7, { 0xE9, 0xA1, 0x9C },
	0xf3a8, { 0xE9, 0xA1, 0x99 },
	0xf3a9, { 0xE9, 0xA1, 0x9D },
	0xf3aa, { 0xE9, 0xA1, 0x97 },
	0xf3ab, { 0xE9, 0xA2, 0xBF },
	0xf3ac, { 0xE9, 0xA2, 0xBD },
	0xf3ad, { 0xE9, 0xA2, 0xBB },
	0xf3ae, { 0xE9, 0xA2, 0xBE },
	0xf3af, { 0xE9, 0xA5, 0x88 },
	0xf3b0, { 0xE9, 0xA5, 0x87 },
	0xf3b1, { 0xE9, 0xA5, 0x83 },
	0xf3b2, { 0xE9, 0xA6, 0xA6 },
	0xf3b3, { 0xE9, 0xA6, 0xA7 },
	0xf3b4, { 0xE9, 0xA8, 0x9A },
	0xf3b5, { 0xE9, 0xA8, 0x95 },
	0xf3b6, { 0xE9, 0xA8, 0xA5 },
	0xf3b7, { 0xE9, 0xA8, 0x9D },
	0xf3b8, { 0xE9, 0xA8, 0xA4 },
	0xf3b9, { 0xE9, 0xA8, 0x9B },
	0xf3ba, { 0xE9, 0xA8, 0xA2 },
	0xf3bb, { 0xE9, 0xA8, 0xA0 },
	0xf3bc, { 0xE9, 0xA8, 0xA7 },
	0xf3bd, { 0xE9, 0xA8, 0xA3 },
	0xf3be, { 0xE9, 0xA8, 0x9E },
	0xf3bf, { 0xE9, 0xA8, 0x9C },
	0xf3c0, { 0xE9, 0xA8, 0x94 },
	0xf3c1, { 0xE9, 0xAB, 0x82 },
	0xf3c2, { 0xE9, 0xAC, 0x8B },
	0xf3c3, { 0xE9, 0xAC, 0x8A },
	0xf3c4, { 0xE9, 0xAC, 0x8E },
	0xf3c5, { 0xE9, 0xAC, 0x8C },
	0xf3c6, { 0xE9, 0xAC, 0xB7 },
	0xf3c7, { 0xE9, 0xAF, 0xAA },
	0xf3c8, { 0xE9, 0xAF, 0xAB },
	0xf3c9, { 0xE9, 0xAF, 0xA0 },
	0xf3ca, { 0xE9, 0xAF, 0x9E },
	0xf3cb, { 0xE9, 0xAF, 0xA4 },
	0xf3cc, { 0xE9, 0xAF, 0xA6 },
	0xf3cd, { 0xE9, 0xAF, 0xA2 },
	0xf3ce, { 0xE9, 0xAF, 0xB0 },
	0xf3cf, { 0xE9, 0xAF, 0x94 },
	0xf3d0, { 0xE9, 0xAF, 0x97 },
	0xf3d1, { 0xE9, 0xAF, 0xAC },
	0xf3d2, { 0xE9, 0xAF, 0x9C },
	0xf3d3, { 0xE9, 0xAF, 0x99 },
	0xf3d4, { 0xE9, 0xAF, 0xA5 },
	0xf3d5, { 0xE9, 0xAF, 0x95 },
	0xf3d6, { 0xE9, 0xAF, 0xA1 },
	0xf3d7, { 0xE9, 0xAF, 0x9A },
	0xf3d8, { 0xE9, 0xB5, 0xB7 },
	0xf3d9, { 0xE9, 0xB6, 0x81 },
	0xf3da, { 0xE9, 0xB6, 0x8A },
	0xf3db, { 0xE9, 0xB6, 0x84 },
	0xf3dc, { 0xE9, 0xB6, 0x88 },
	0xf3dd, { 0xE9, 0xB5, 0xB1 },
	0xf3de, { 0xE9, 0xB6, 0x80 },
	0xf3df, { 0xE9, 0xB5, 0xB8 },
	0xf3e0, { 0xE9, 0xB6, 0x86 },
	0xf3e1, { 0xE9, 0xB6, 0x8B },
	0xf3e2, { 0xE9, 0xB6, 0x8C },
	0xf3e3, { 0xE9, 0xB5, 0xBD },
	0xf3e4, { 0xE9, 0xB5, 0xAB },
	0xf3e5, { 0xE9, 0xB5, 0xB4 },
	0xf3e6, { 0xE9, 0xB5, 0xB5 },
	0xf3e7, { 0xE9, 0xB5, 0xB0 },
	0xf3e8, { 0xE9, 0xB5, 0xA9 },
	0xf3e9, { 0xE9, 0xB6, 0x85 },
	0xf3ea, { 0xE9, 0xB5, 0xB3 },
	0xf3eb, { 0xE9, 0xB5, 0xBB },
	0xf3ec, { 0xE9, 0xB6, 0x82 },
	0xf3ed, { 0xE9, 0xB5, 0xAF },
	0xf3ee, { 0xE9, 0xB5, 0xB9 },
	0xf3ef, { 0xE9, 0xB5, 0xBF },
	0xf3f0, { 0xE9, 0xB6, 0x87 },
	0xf3f1, { 0xE9, 0xB5, 0xA8 },
	0xf3f2, { 0xE9, 0xBA, 0x94 },
	0xf3f3, { 0xE9, 0xBA, 0x91 },
	0xf3f4, { 0xE9, 0xBB, 0x80 },
	0xf3f5, { 0xE9, 0xBB, 0xBC },
	0xf3f6, { 0xE9, 0xBC, 0xAD },
	0xf3f7, { 0xE9, 0xBD, 0x80 },
	0xf3f8, { 0xE9, 0xBD, 0x81 },
	0xf3f9, { 0xE9, 0xBD, 0x8D },
	0xf3fa, { 0xE9, 0xBD, 0x96 },
	0xf3fb, { 0xE9, 0xBD, 0x97 },
	0xf3fc, { 0xE9, 0xBD, 0x98 },
	0xf3fd, { 0xE5, 0x8C, 0xB7 },
	0xf3fe, { 0xE5, 0x9A, 0xB2 },
	0xf440, { 0xE5, 0x9A, 0xB5 },
	0xf441, { 0xE5, 0x9A, 0xB3 },
	0xf442, { 0xE5, 0xA3, 0xA3 },
	0xf443, { 0xE5, 0xAD, 0x85 },
	0xf444, { 0xE5, 0xB7, 0x86 },
	0xf445, { 0xE5, 0xB7, 0x87 },
	0xf446, { 0xE5, 0xBB, 0xAE },
	0xf447, { 0xE5, 0xBB, 0xAF },
	0xf448, { 0xE5, 0xBF, 0x80 },
	0xf449, { 0xE5, 0xBF, 0x81 },
	0xf44a, { 0xE6, 0x87, 0xB9 },
	0xf44b, { 0xE6, 0x94, 0x97 },
	0xf44c, { 0xE6, 0x94, 0x96 },
	0xf44d, { 0xE6, 0x94, 0x95 },
	0xf44e, { 0xE6, 0x94, 0x93 },
	0xf44f, { 0xE6, 0x97, 0x9F },
	0xf450, { 0xE6, 0x9B, 0xA8 },
	0xf451, { 0xE6, 0x9B, 0xA3 },
	0xf452, { 0xE6, 0x9B, 0xA4 },
	0xf453, { 0xE6, 0xAB, 0xB3 },
	0xf454, { 0xE6, 0xAB, 0xB0 },
	0xf455, { 0xE6, 0xAB, 0xAA },
	0xf456, { 0xE6, 0xAB, 0xA8 },
	0xf457, { 0xE6, 0xAB, 0xB9 },
	0xf458, { 0xE6, 0xAB, 0xB1 },
	0xf459, { 0xE6, 0xAB, 0xAE },
	0xf45a, { 0xE6, 0xAB, 0xAF },
	0xf45b, { 0xE7, 0x80, 0xBC },
	0xf45c, { 0xE7, 0x80, 0xB5 },
	0xf45d, { 0xE7, 0x80, 0xAF },
	0xf45e, { 0xE7, 0x80, 0xB7 },
	0xf45f, { 0xE7, 0x80, 0xB4 },
	0xf460, { 0xE7, 0x80, 0xB1 },
	0xf461, { 0xE7, 0x81, 0x82 },
	0xf462, { 0xE7, 0x80, 0xB8 },
	0xf463, { 0xE7, 0x80, 0xBF },
	0xf464, { 0xE7, 0x80, 0xBA },
	0xf465, { 0xE7, 0x80, 0xB9 },
	0xf466, { 0xE7, 0x81, 0x80 },
	0xf467, { 0xE7, 0x80, 0xBB },
	0xf468, { 0xE7, 0x80, 0xB3 },
	0xf469, { 0xE7, 0x81, 0x81 },
	0xf46a, { 0xE7, 0x88, 0x93 },
	0xf46b, { 0xE7, 0x88, 0x94 },
	0xf46c, { 0xE7, 0x8A, 0xA8 },
	0xf46d, { 0xE7, 0x8D, 0xBD },
	0xf46e, { 0xE7, 0x8D, 0xBC },
	0xf46f, { 0xE7, 0x92, 0xBA },
	0xf470, { 0xE7, 0x9A, 0xAB },
	0xf471, { 0xE7, 0x9A, 0xAA },
	0xf472, { 0xE7, 0x9A, 0xBE },
	0xf473, { 0xE7, 0x9B, 0xAD },
	0xf474, { 0xE7, 0x9F, 0x8C },
	0xf475, { 0xE7, 0x9F, 0x8E },
	0xf476, { 0xE7, 0x9F, 0x8F },
	0xf477, { 0xE7, 0x9F, 0x8D },
	0xf478, { 0xE7, 0x9F, 0xB2 },
	0xf479, { 0xE7, 0xA4, 0xA5 },
	0xf47a, { 0xE7, 0xA4, 0xA3 },
	0xf47b, { 0xE7, 0xA4, 0xA7 },
	0xf47c, { 0xE7, 0xA4, 0xA8 },
	0xf47d, { 0xE7, 0xA4, 0xA4 },
	0xf47e, { 0xE7, 0xA4, 0xA9 },
	0xf4a1, { 0xE7, 0xA6, 0xB2 },
	0xf4a2, { 0xE7, 0xA9, 0xAE },
	0xf4a3, { 0xE7, 0xA9, 0xAC },
	0xf4a4, { 0xE7, 0xA9, 0xAD },
	0xf4a5, { 0xE7, 0xAB, 0xB7 },
	0xf4a6, { 0xE7, 0xB1, 0x89 },
	0xf4a7, { 0xE7, 0xB1, 0x88 },
	0xf4a8, { 0xE7, 0xB1, 0x8A },
	0xf4a9, { 0xE7, 0xB1, 0x87 },
	0xf4aa, { 0xE7, 0xB1, 0x85 },
	0xf4ab, { 0xE7, 0xB3, 0xAE },
	0xf4ac, { 0xE7, 0xB9, 0xBB },
	0xf4ad, { 0xE7, 0xB9, 0xBE },
	0xf4ae, { 0xE7, 0xBA, 0x81 },
	0xf4af, { 0xE7, 0xBA, 0x80 },
	0xf4b0, { 0xE7, 0xBE, 0xBA },
	0xf4b1, { 0xE7, 0xBF, 0xBF },
	0xf4b2, { 0xE8, 0x81, 0xB9 },
	0xf4b3, { 0xE8, 0x87, 0x9B },
	0xf4b4, { 0xE8, 0x87, 0x99 },
	0xf4b5, { 0xE8, 0x88, 0x8B },
	0xf4b6, { 0xE8, 0x89, 0xA8 },
	0xf4b7, { 0xE8, 0x89, 0xA9 },
	0xf4b8, { 0xE8, 0x98, 0xA2 },
	0xf4b9, { 0xE8, 0x97, 0xBF },
	0xf4ba, { 0xE8, 0x98, 0x81 },
	0xf4bb, { 0xE8, 0x97, 0xBE },
	0xf4bc, { 0xE8, 0x98, 0x9B },
	0xf4bd, { 0xE8, 0x98, 0x80 },
	0xf4be, { 0xE8, 0x97, 0xB6 },
	0xf4bf, { 0xE8, 0x98, 0x84 },
	0xf4c0, { 0xE8, 0x98, 0x89 },
	0xf4c1, { 0xE8, 0x98, 0x85 },
	0xf4c2, { 0xE8, 0x98, 0x8C },
	0xf4c3, { 0xE8, 0x97, 0xBD },
	0xf4c4, { 0xE8, 0xA0, 0x99 },
	0xf4c5, { 0xE8, 0xA0, 0x90 },
	0xf4c6, { 0xE8, 0xA0, 0x91 },
	0xf4c7, { 0xE8, 0xA0, 0x97 },
	0xf4c8, { 0xE8, 0xA0, 0x93 },
	0xf4c9, { 0xE8, 0xA0, 0x96 },
	0xf4ca, { 0xE8, 0xA5, 0xA3 },
	0xf4cb, { 0xE8, 0xA5, 0xA6 },
	0xf4cc, { 0xE8, 0xA6, 0xB9 },
	0xf4cd, { 0xE8, 0xA7, 0xB7 },
	0xf4ce, { 0xE8, 0xAD, 0xA0 },
	0xf4cf, { 0xE8, 0xAD, 0xAA },
	0xf4d0, { 0xE8, 0xAD, 0x9D },
	0xf4d1, { 0xE8, 0xAD, 0xA8 },
	0xf4d2, { 0xE8, 0xAD, 0xA3 },
	0xf4d3, { 0xE8, 0xAD, 0xA5 },
	0xf4d4, { 0xE8, 0xAD, 0xA7 },
	0xf4d5, { 0xE8, 0xAD, 0xAD },
	0xf4d6, { 0xE8, 0xB6, 0xAE },
	0xf4d7, { 0xE8, 0xBA, 0x86 },
	0xf4d8, { 0xE8, 0xBA, 0x88 },
	0xf4d9, { 0xE8, 0xBA, 0x84 },
	0xf4da, { 0xE8, 0xBD, 0x99 },
	0xf4db, { 0xE8, 0xBD, 0x96 },
	0xf4dc, { 0xE8, 0xBD, 0x97 },
	0xf4dd, { 0xE8, 0xBD, 0x95 },
	0xf4de, { 0xE8, 0xBD, 0x98 },
	0xf4df, { 0xE8, 0xBD, 0x9A },
	0xf4e0, { 0xE9, 0x82, 0x8D },
	0xf4e1, { 0xE9, 0x85, 0x83 },
	0xf4e2, { 0xE9, 0x85, 0x81 },
	0xf4e3, { 0xE9, 0x86, 0xB7 },
	0xf4e4, { 0xE9, 0x86, 0xB5 },
	0xf4e5, { 0xE9, 0x86, 0xB2 },
	0xf4e6, { 0xE9, 0x86, 0xB3 },
	0xf4e7, { 0xE9, 0x90, 0x8B },
	0xf4e8, { 0xE9, 0x90, 0x93 },
	0xf4e9, { 0xE9, 0x8F, 0xBB },
	0xf4ea, { 0xE9, 0x90, 0xA0 },
	0xf4eb, { 0xE9, 0x90, 0x8F },
	0xf4ec, { 0xE9, 0x90, 0x94 },
	0xf4ed, { 0xE9, 0x8F, 0xBE },
	0xf4ee, { 0xE9, 0x90, 0x95 },
	0xf4ef, { 0xE9, 0x90, 0x90 },
	0xf4f0, { 0xE9, 0x90, 0xA8 },
	0xf4f1, { 0xE9, 0x90, 0x99 },
	0xf4f2, { 0xE9, 0x90, 0x8D },
	0xf4f3, { 0xE9, 0x8F, 0xB5 },
	0xf4f4, { 0xE9, 0x90, 0x80 },
	0xf4f5, { 0xE9, 0x8F, 0xB7 },
	0xf4f6, { 0xE9, 0x90, 0x87 },
	0xf4f7, { 0xE9, 0x90, 0x8E },
	0xf4f8, { 0xE9, 0x90, 0x96 },
	0xf4f9, { 0xE9, 0x90, 0x92 },
	0xf4fa, { 0xE9, 0x8F, 0xBA },
	0xf4fb, { 0xE9, 0x90, 0x89 },
	0xf4fc, { 0xE9, 0x8F, 0xB8 },
	0xf4fd, { 0xE9, 0x90, 0x8A },
	0xf4fe, { 0xE9, 0x8F, 0xBF },
	0xf540, { 0xE9, 0x8F, 0xBC },
	0xf541, { 0xE9, 0x90, 0x8C },
	0xf542, { 0xE9, 0x8F, 0xB6 },
	0xf543, { 0xE9, 0x90, 0x91 },
	0xf544, { 0xE9, 0x90, 0x86 },
	0xf545, { 0xE9, 0x97, 0x9E },
	0xf546, { 0xE9, 0x97, 0xA0 },
	0xf547, { 0xE9, 0x97, 0x9F },
	0xf548, { 0xE9, 0x9C, 0xAE },
	0xf549, { 0xE9, 0x9C, 0xAF },
	0xf54a, { 0xE9, 0x9E, 0xB9 },
	0xf54b, { 0xE9, 0x9E, 0xBB },
	0xf54c, { 0xE9, 0x9F, 0xBD },
	0xf54d, { 0xE9, 0x9F, 0xBE },
	0xf54e, { 0xE9, 0xA1, 0xA0 },
	0xf54f, { 0xE9, 0xA1, 0xA2 },
	0xf550, { 0xE9, 0xA1, 0xA3 },
	0xf551, { 0xE9, 0xA1, 0x9F },
	0xf552, { 0xE9, 0xA3, 0x81 },
	0xf553, { 0xE9, 0xA3, 0x82 },
	0xf554, { 0xE9, 0xA5, 0x90 },
	0xf555, { 0xE9, 0xA5, 0x8E },
	0xf556, { 0xE9, 0xA5, 0x99 },
	0xf557, { 0xE9, 0xA5, 0x8C },
	0xf558, { 0xE9, 0xA5, 0x8B },
	0xf559, { 0xE9, 0xA5, 0x93 },
	0xf55a, { 0xE9, 0xA8, 0xB2 },
	0xf55b, { 0xE9, 0xA8, 0xB4 },
	0xf55c, { 0xE9, 0xA8, 0xB1 },
	0xf55d, { 0xE9, 0xA8, 0xAC },
	0xf55e, { 0xE9, 0xA8, 0xAA },
	0xf55f, { 0xE9, 0xA8, 0xB6 },
	0xf560, { 0xE9, 0xA8, 0xA9 },
	0xf561, { 0xE9, 0xA8, 0xAE },
	0xf562, { 0xE9, 0xA8, 0xB8 },
	0xf563, { 0xE9, 0xA8, 0xAD },
	0xf564, { 0xE9, 0xAB, 0x87 },
	0xf565, { 0xE9, 0xAB, 0x8A },
	0xf566, { 0xE9, 0xAB, 0x86 },
	0xf567, { 0xE9, 0xAC, 0x90 },
	0xf568, { 0xE9, 0xAC, 0x92 },
	0xf569, { 0xE9, 0xAC, 0x91 },
	0xf56a, { 0xE9, 0xB0, 0x8B },
	0xf56b, { 0xE9, 0xB0, 0x88 },
	0xf56c, { 0xE9, 0xAF, 0xB7 },
	0xf56d, { 0xE9, 0xB0, 0x85 },
	0xf56e, { 0xE9, 0xB0, 0x92 },
	0xf56f, { 0xE9, 0xAF, 0xB8 },
	0xf570, { 0xE9, 0xB1, 0x80 },
	0xf571, { 0xE9, 0xB0, 0x87 },
	0xf572, { 0xE9, 0xB0, 0x8E },
	0xf573, { 0xE9, 0xB0, 0x86 },
	0xf574, { 0xE9, 0xB0, 0x97 },
	0xf575, { 0xE9, 0xB0, 0x94 },
	0xf576, { 0xE9, 0xB0, 0x89 },
	0xf577, { 0xE9, 0xB6, 0x9F },
	0xf578, { 0xE9, 0xB6, 0x99 },
	0xf579, { 0xE9, 0xB6, 0xA4 },
	0xf57a, { 0xE9, 0xB6, 0x9D },
	0xf57b, { 0xE9, 0xB6, 0x92 },
	0xf57c, { 0xE9, 0xB6, 0x98 },
	0xf57d, { 0xE9, 0xB6, 0x90 },
	0xf57e, { 0xE9, 0xB6, 0x9B },
	0xf5a1, { 0xE9, 0xB6, 0xA0 },
	0xf5a2, { 0xE9, 0xB6, 0x94 },
	0xf5a3, { 0xE9, 0xB6, 0x9C },
	0xf5a4, { 0xE9, 0xB6, 0xAA },
	0xf5a5, { 0xE9, 0xB6, 0x97 },
	0xf5a6, { 0xE9, 0xB6, 0xA1 },
	0xf5a7, { 0xE9, 0xB6, 0x9A },
	0xf5a8, { 0xE9, 0xB6, 0xA2 },
	0xf5a9, { 0xE9, 0xB6, 0xA8 },
	0xf5aa, { 0xE9, 0xB6, 0x9E },
	0xf5ab, { 0xE9, 0xB6, 0xA3 },
	0xf5ac, { 0xE9, 0xB6, 0xBF },
	0xf5ad, { 0xE9, 0xB6, 0xA9 },
	0xf5ae, { 0xE9, 0xB6, 0x96 },
	0xf5af, { 0xE9, 0xB6, 0xA6 },
	0xf5b0, { 0xE9, 0xB6, 0xA7 },
	0xf5b1, { 0xE9, 0xBA, 0x99 },
	0xf5b2, { 0xE9, 0xBA, 0x9B },
	0xf5b3, { 0xE9, 0xBA, 0x9A },
	0xf5b4, { 0xE9, 0xBB, 0xA5 },
	0xf5b5, { 0xE9, 0xBB, 0xA4 },
	0xf5b6, { 0xE9, 0xBB, 0xA7 },
	0xf5b7, { 0xE9, 0xBB, 0xA6 },
	0xf5b8, { 0xE9, 0xBC, 0xB0 },
	0xf5b9, { 0xE9, 0xBC, 0xAE },
	0xf5ba, { 0xE9, 0xBD, 0x9B },
	0xf5bb, { 0xE9, 0xBD, 0xA0 },
	0xf5bc, { 0xE9, 0xBD, 0x9E },
	0xf5bd, { 0xE9, 0xBD, 0x9D },
	0xf5be, { 0xE9, 0xBD, 0x99 },
	0xf5bf, { 0xE9, 0xBE, 0x91 },
	0xf5c0, { 0xE5, 0x84, 0xBA },
	0xf5c1, { 0xE5, 0x84, 0xB9 },
	0xf5c2, { 0xE5, 0x8A, 0x98 },
	0xf5c3, { 0xE5, 0x8A, 0x97 },
	0xf5c4, { 0xE5, 0x9B, 0x83 },
	0xf5c5, { 0xE5, 0x9A, 0xBD },
	0xf5c6, { 0xE5, 0x9A, 0xBE },
	0xf5c7, { 0xE5, 0xAD, 0x88 },
	0xf5c8, { 0xE5, 0xAD, 0x87 },
	0xf5c9, { 0xE5, 0xB7, 0x8B },
	0xf5ca, { 0xE5, 0xB7, 0x8F },
	0xf5cb, { 0xE5, 0xBB, 0xB1 },
	0xf5cc, { 0xE6, 0x87, 0xBD },
	0xf5cd, { 0xE6, 0x94, 0x9B },
	0xf5ce, { 0xE6, 0xAC, 0x82 },
	0xf5cf, { 0xE6, 0xAB, 0xBC },
	0xf5d0, { 0xE6, 0xAC, 0x83 },
	0xf5d1, { 0xE6, 0xAB, 0xB8 },
	0xf5d2, { 0xE6, 0xAC, 0x80 },
	0xf5d3, { 0xE7, 0x81, 0x83 },
	0xf5d4, { 0xE7, 0x81, 0x84 },
	0xf5d5, { 0xE7, 0x81, 0x8A },
	0xf5d6, { 0xE7, 0x81, 0x88 },
	0xf5d7, { 0xE7, 0x81, 0x89 },
	0xf5d8, { 0xE7, 0x81, 0x85 },
	0xf5d9, { 0xE7, 0x81, 0x86 },
	0xf5da, { 0xE7, 0x88, 0x9D },
	0xf5db, { 0xE7, 0x88, 0x9A },
	0xf5dc, { 0xE7, 0x88, 0x99 },
	0xf5dd, { 0xE7, 0x8D, 0xBE },
	0xf5de, { 0xE7, 0x94, 0x97 },
	0xf5df, { 0xE7, 0x99, 0xAA },
	0xf5e0, { 0xE7, 0x9F, 0x90 },
	0xf5e1, { 0xE7, 0xA4, 0xAD },
	0xf5e2, { 0xE7, 0xA4, 0xB1 },
	0xf5e3, { 0xE7, 0xA4, 0xAF },
	0xf5e4, { 0xE7, 0xB1, 0x94 },
	0xf5e5, { 0xE7, 0xB1, 0x93 },
	0xf5e6, { 0xE7, 0xB3, 0xB2 },
	0xf5e7, { 0xE7, 0xBA, 0x8A },
	0xf5e8, { 0xE7, 0xBA, 0x87 },
	0xf5e9, { 0xE7, 0xBA, 0x88 },
	0xf5ea, { 0xE7, 0xBA, 0x8B },
	0xf5eb, { 0xE7, 0xBA, 0x86 },
	0xf5ec, { 0xE7, 0xBA, 0x8D },
	0xf5ed, { 0xE7, 0xBD, 0x8D },
	0xf5ee, { 0xE7, 0xBE, 0xBB },
	0xf5ef, { 0xE8, 0x80, 0xB0 },
	0xf5f0, { 0xE8, 0x87, 0x9D },
	0xf5f1, { 0xE8, 0x98, 0x98 },
	0xf5f2, { 0xE8, 0x98, 0xAA },
	0xf5f3, { 0xE8, 0x98, 0xA6 },
	0xf5f4, { 0xE8, 0x98, 0x9F },
	0xf5f5, { 0xE8, 0x98, 0xA3 },
	0xf5f6, { 0xE8, 0x98, 0x9C },
	0xf5f7, { 0xE8, 0x98, 0x99 },
	0xf5f8, { 0xE8, 0x98, 0xA7 },
	0xf5f9, { 0xE8, 0x98, 0xAE },
	0xf5fa, { 0xE8, 0x98, 0xA1 },
	0xf5fb, { 0xE8, 0x98, 0xA0 },
	0xf5fc, { 0xE8, 0x98, 0xA9 },
	0xf5fd, { 0xE8, 0x98, 0x9E },
	0xf5fe, { 0xE8, 0x98, 0xA5 },
	0xf640, { 0xE8, 0xA0, 0xA9 },
	0xf641, { 0xE8, 0xA0, 0x9D },
	0xf642, { 0xE8, 0xA0, 0x9B },
	0xf643, { 0xE8, 0xA0, 0xA0 },
	0xf644, { 0xE8, 0xA0, 0xA4 },
	0xf645, { 0xE8, 0xA0, 0x9C },
	0xf646, { 0xE8, 0xA0, 0xAB },
	0xf647, { 0xE8, 0xA1, 0x8A },
	0xf648, { 0xE8, 0xA5, 0xAD },
	0xf649, { 0xE8, 0xA5, 0xA9 },
	0xf64a, { 0xE8, 0xA5, 0xAE },
	0xf64b, { 0xE8, 0xA5, 0xAB },
	0xf64c, { 0xE8, 0xA7, 0xBA },
	0xf64d, { 0xE8, 0xAD, 0xB9 },
	0xf64e, { 0xE8, 0xAD, 0xB8 },
	0xf64f, { 0xE8, 0xAD, 0x85 },
	0xf650, { 0xE8, 0xAD, 0xBA },
	0xf651, { 0xE8, 0xAD, 0xBB },
	0xf652, { 0xE8, 0xB4, 0x90 },
	0xf653, { 0xE8, 0xB4, 0x94 },
	0xf654, { 0xE8, 0xB6, 0xAF },
	0xf655, { 0xE8, 0xBA, 0x8E },
	0xf656, { 0xE8, 0xBA, 0x8C },
	0xf657, { 0xE8, 0xBD, 0x9E },
	0xf658, { 0xE8, 0xBD, 0x9B },
	0xf659, { 0xE8, 0xBD, 0x9D },
	0xf65a, { 0xE9, 0x85, 0x86 },
	0xf65b, { 0xE9, 0x85, 0x84 },
	0xf65c, { 0xE9, 0x85, 0x85 },
	0xf65d, { 0xE9, 0x86, 0xB9 },
	0xf65e, { 0xE9, 0x90, 0xBF },
	0xf65f, { 0xE9, 0x90, 0xBB },
	0xf660, { 0xE9, 0x90, 0xB6 },
	0xf661, { 0xE9, 0x90, 0xA9 },
	0xf662, { 0xE9, 0x90, 0xBD },
	0xf663, { 0xE9, 0x90, 0xBC },
	0xf664, { 0xE9, 0x90, 0xB0 },
	0xf665, { 0xE9, 0x90, 0xB9 },
	0xf666, { 0xE9, 0x90, 0xAA },
	0xf667, { 0xE9, 0x90, 0xB7 },
	0xf668, { 0xE9, 0x90, 0xAC },
	0xf669, { 0xE9, 0x91, 0x80 },
	0xf66a, { 0xE9, 0x90, 0xB1 },
	0xf66b, { 0xE9, 0x97, 0xA5 },
	0xf66c, { 0xE9, 0x97, 0xA4 },
	0xf66d, { 0xE9, 0x97, 0xA3 },
	0xf66e, { 0xE9, 0x9C, 0xB5 },
	0xf66f, { 0xE9, 0x9C, 0xBA },
	0xf670, { 0xE9, 0x9E, 0xBF },
	0xf671, { 0xE9, 0x9F, 0xA1 },
	0xf672, { 0xE9, 0xA1, 0xA4 },
	0xf673, { 0xE9, 0xA3, 0x89 },
	0xf674, { 0xE9, 0xA3, 0x86 },
	0xf675, { 0xE9, 0xA3, 0x80 },
	0xf676, { 0xE9, 0xA5, 0x98 },
	0xf677, { 0xE9, 0xA5, 0x96 },
	0xf678, { 0xE9, 0xA8, 0xB9 },
	0xf679, { 0xE9, 0xA8, 0xBD },
	0xf67a, { 0xE9, 0xA9, 0x86 },
	0xf67b, { 0xE9, 0xA9, 0x84 },
	0xf67c, { 0xE9, 0xA9, 0x82 },
	0xf67d, { 0xE9, 0xA9, 0x81 },
	0xf67e, { 0xE9, 0xA8, 0xBA },
	0xf6a1, { 0xE9, 0xA8, 0xBF },
	0xf6a2, { 0xE9, 0xAB, 0x8D },
	0xf6a3, { 0xE9, 0xAC, 0x95 },
	0xf6a4, { 0xE9, 0xAC, 0x97 },
	0xf6a5, { 0xE9, 0xAC, 0x98 },
	0xf6a6, { 0xE9, 0xAC, 0x96 },
	0xf6a7, { 0xE9, 0xAC, 0xBA },
	0xf6a8, { 0xE9, 0xAD, 0x92 },
	0xf6a9, { 0xE9, 0xB0, 0xAB },
	0xf6aa, { 0xE9, 0xB0, 0x9D },
	0xf6ab, { 0xE9, 0xB0, 0x9C },
	0xf6ac, { 0xE9, 0xB0, 0xAC },
	0xf6ad, { 0xE9, 0xB0, 0xA3 },
	0xf6ae, { 0xE9, 0xB0, 0xA8 },
	0xf6af, { 0xE9, 0xB0, 0xA9 },
	0xf6b0, { 0xE9, 0xB0, 0xA4 },
	0xf6b1, { 0xE9, 0xB0, 0xA1 },
	0xf6b2, { 0xE9, 0xB6, 0xB7 },
	0xf6b3, { 0xE9, 0xB6, 0xB6 },
	0xf6b4, { 0xE9, 0xB6, 0xBC },
	0xf6b5, { 0xE9, 0xB7, 0x81 },
	0xf6b6, { 0xE9, 0xB7, 0x87 },
	0xf6b7, { 0xE9, 0xB7, 0x8A },
	0xf6b8, { 0xE9, 0xB7, 0x8F },
	0xf6b9, { 0xE9, 0xB6, 0xBE },
	0xf6ba, { 0xE9, 0xB7, 0x85 },
	0xf6bb, { 0xE9, 0xB7, 0x83 },
	0xf6bc, { 0xE9, 0xB6, 0xBB },
	0xf6bd, { 0xE9, 0xB6, 0xB5 },
	0xf6be, { 0xE9, 0xB7, 0x8E },
	0xf6bf, { 0xE9, 0xB6, 0xB9 },
	0xf6c0, { 0xE9, 0xB6, 0xBA },
	0xf6c1, { 0xE9, 0xB6, 0xAC },
	0xf6c2, { 0xE9, 0xB7, 0x88 },
	0xf6c3, { 0xE9, 0xB6, 0xB1 },
	0xf6c4, { 0xE9, 0xB6, 0xAD },
	0xf6c5, { 0xE9, 0xB7, 0x8C },
	0xf6c6, { 0xE9, 0xB6, 0xB3 },
	0xf6c7, { 0xE9, 0xB7, 0x8D },
	0xf6c8, { 0xE9, 0xB6, 0xB2 },
	0xf6c9, { 0xE9, 0xB9, 0xBA },
	0xf6ca, { 0xE9, 0xBA, 0x9C },
	0xf6cb, { 0xE9, 0xBB, 0xAB },
	0xf6cc, { 0xE9, 0xBB, 0xAE },
	0xf6cd, { 0xE9, 0xBB, 0xAD },
	0xf6ce, { 0xE9, 0xBC, 0x9B },
	0xf6cf, { 0xE9, 0xBC, 0x98 },
	0xf6d0, { 0xE9, 0xBC, 0x9A },
	0xf6d1, { 0xE9, 0xBC, 0xB1 },
	0xf6d2, { 0xE9, 0xBD, 0x8E },
	0xf6d3, { 0xE9, 0xBD, 0xA5 },
	0xf6d4, { 0xE9, 0xBD, 0xA4 },
	0xf6d5, { 0xE9, 0xBE, 0x92 },
	0xf6d6, { 0xE4, 0xBA, 0xB9 },
	0xf6d7, { 0xE5, 0x9B, 0x86 },
	0xf6d8, { 0xE5, 0x9B, 0x85 },
	0xf6d9, { 0xE5, 0x9B, 0x8B },
	0xf6da, { 0xE5, 0xA5, 0xB1 },
	0xf6db, { 0xE5, 0xAD, 0x8B },
	0xf6dc, { 0xE5, 0xAD, 0x8C },
	0xf6dd, { 0xE5, 0xB7, 0x95 },
	0xf6de, { 0xE5, 0xB7, 0x91 },
	0xf6df, { 0xE5, 0xBB, 0xB2 },
	0xf6e0, { 0xE6, 0x94, 0xA1 },
	0xf6e1, { 0xE6, 0x94, 0xA0 },
	0xf6e2, { 0xE6, 0x94, 0xA6 },
	0xf6e3, { 0xE6, 0x94, 0xA2 },
	0xf6e4, { 0xE6, 0xAC, 0x8B },
	0xf6e5, { 0xE6, 0xAC, 0x88 },
	0xf6e6, { 0xE6, 0xAC, 0x89 },
	0xf6e7, { 0xE6, 0xB0, 0x8D },
	0xf6e8, { 0xE7, 0x81, 0x95 },
	0xf6e9, { 0xE7, 0x81, 0x96 },
	0xf6ea, { 0xE7, 0x81, 0x97 },
	0xf6eb, { 0xE7, 0x81, 0x92 },
	0xf6ec, { 0xE7, 0x88, 0x9E },
	0xf6ed, { 0xE7, 0x88, 0x9F },
	0xf6ee, { 0xE7, 0x8A, 0xA9 },
	0xf6ef, { 0xE7, 0x8D, 0xBF },
	0xf6f0, { 0xE7, 0x93, 0x98 },
	0xf6f1, { 0xE7, 0x93, 0x95 },
	0xf6f2, { 0xE7, 0x93, 0x99 },
	0xf6f3, { 0xE7, 0x93, 0x97 },
	0xf6f4, { 0xE7, 0x99, 0xAD },
	0xf6f5, { 0xE7, 0x9A, 0xAD },
	0xf6f6, { 0xE7, 0xA4, 0xB5 },
	0xf6f7, { 0xE7, 0xA6, 0xB4 },
	0xf6f8, { 0xE7, 0xA9, 0xB0 },
	0xf6f9, { 0xE7, 0xA9, 0xB1 },
	0xf6fa, { 0xE7, 0xB1, 0x97 },
	0xf6fb, { 0xE7, 0xB1, 0x9C },
	0xf6fc, { 0xE7, 0xB1, 0x99 },
	0xf6fd, { 0xE7, 0xB1, 0x9B },
	0xf6fe, { 0xE7, 0xB1, 0x9A },
	0xf740, { 0xE7, 0xB3, 0xB4 },
	0xf741, { 0xE7, 0xB3, 0xB1 },
	0xf742, { 0xE7, 0xBA, 0x91 },
	0xf743, { 0xE7, 0xBD, 0x8F },
	0xf744, { 0xE7, 0xBE, 0x87 },
	0xf745, { 0xE8, 0x87, 0x9E },
	0xf746, { 0xE8, 0x89, 0xAB },
	0xf747, { 0xE8, 0x98, 0xB4 },
	0xf748, { 0xE8, 0x98, 0xB5 },
	0xf749, { 0xE8, 0x98, 0xB3 },
	0xf74a, { 0xE8, 0x98, 0xAC },
	0xf74b, { 0xE8, 0x98, 0xB2 },
	0xf74c, { 0xE8, 0x98, 0xB6 },
	0xf74d, { 0xE8, 0xA0, 0xAC },
	0xf74e, { 0xE8, 0xA0, 0xA8 },
	0xf74f, { 0xE8, 0xA0, 0xA6 },
	0xf750, { 0xE8, 0xA0, 0xAA },
	0xf751, { 0xE8, 0xA0, 0xA5 },
	0xf752, { 0xE8, 0xA5, 0xB1 },
	0xf753, { 0xE8, 0xA6, 0xBF },
	0xf754, { 0xE8, 0xA6, 0xBE },
	0xf755, { 0xE8, 0xA7, 0xBB },
	0xf756, { 0xE8, 0xAD, 0xBE },
	0xf757, { 0xE8, 0xAE, 0x84 },
	0xf758, { 0xE8, 0xAE, 0x82 },
	0xf759, { 0xE8, 0xAE, 0x86 },
	0xf75a, { 0xE8, 0xAE, 0x85 },
	0xf75b, { 0xE8, 0xAD, 0xBF },
	0xf75c, { 0xE8, 0xB4, 0x95 },
	0xf75d, { 0xE8, 0xBA, 0x95 },
	0xf75e, { 0xE8, 0xBA, 0x94 },
	0xf75f, { 0xE8, 0xBA, 0x9A },
	0xf760, { 0xE8, 0xBA, 0x92 },
	0xf761, { 0xE8, 0xBA, 0x90 },
	0xf762, { 0xE8, 0xBA, 0x96 },
	0xf763, { 0xE8, 0xBA, 0x97 },
	0xf764, { 0xE8, 0xBD, 0xA0 },
	0xf765, { 0xE8, 0xBD, 0xA2 },
	0xf766, { 0xE9, 0x85, 0x87 },
	0xf767, { 0xE9, 0x91, 0x8C },
	0xf768, { 0xE9, 0x91, 0x90 },
	0xf769, { 0xE9, 0x91, 0x8A },
	0xf76a, { 0xE9, 0x91, 0x8B },
	0xf76b, { 0xE9, 0x91, 0x8F },
	0xf76c, { 0xE9, 0x91, 0x87 },
	0xf76d, { 0xE9, 0x91, 0x85 },
	0xf76e, { 0xE9, 0x91, 0x88 },
	0xf76f, { 0xE9, 0x91, 0x89 },
	0xf770, { 0xE9, 0x91, 0x86 },
	0xf771, { 0xE9, 0x9C, 0xBF },
	0xf772, { 0xE9, 0x9F, 0xA3 },
	0xf773, { 0xE9, 0xA1, 0xAA },
	0xf774, { 0xE9, 0xA1, 0xA9 },
	0xf775, { 0xE9, 0xA3, 0x8B },
	0xf776, { 0xE9, 0xA5, 0x94 },
	0xf777, { 0xE9, 0xA5, 0x9B },
	0xf778, { 0xE9, 0xA9, 0x8E },
	0xf779, { 0xE9, 0xA9, 0x93 },
	0xf77a, { 0xE9, 0xA9, 0x94 },
	0xf77b, { 0xE9, 0xA9, 0x8C },
	0xf77c, { 0xE9, 0xA9, 0x8F },
	0xf77d, { 0xE9, 0xA9, 0x88 },
	0xf77e, { 0xE9, 0xA9, 0x8A },
	0xf7a1, { 0xE9, 0xA9, 0x89 },
	0xf7a2, { 0xE9, 0xA9, 0x92 },
	0xf7a3, { 0xE9, 0xA9, 0x90 },
	0xf7a4, { 0xE9, 0xAB, 0x90 },
	0xf7a5, { 0xE9, 0xAC, 0x99 },
	0xf7a6, { 0xE9, 0xAC, 0xAB },
	0xf7a7, { 0xE9, 0xAC, 0xBB },
	0xf7a8, { 0xE9, 0xAD, 0x96 },
	0xf7a9, { 0xE9, 0xAD, 0x95 },
	0xf7aa, { 0xE9, 0xB1, 0x86 },
	0xf7ab, { 0xE9, 0xB1, 0x88 },
	0xf7ac, { 0xE9, 0xB0, 0xBF },
	0xf7ad, { 0xE9, 0xB1, 0x84 },
	0xf7ae, { 0xE9, 0xB0, 0xB9 },
	0xf7af, { 0xE9, 0xB0, 0xB3 },
	0xf7b0, { 0xE9, 0xB1, 0x81 },
	0xf7b1, { 0xE9, 0xB0, 0xBC },
	0xf7b2, { 0xE9, 0xB0, 0xB7 },
	0xf7b3, { 0xE9, 0xB0, 0xB4 },
	0xf7b4, { 0xE9, 0xB0, 0xB2 },
	0xf7b5, { 0xE9, 0xB0, 0xBD },
	0xf7b6, { 0xE9, 0xB0, 0xB6 },
	0xf7b7, { 0xE9, 0xB7, 0x9B },
	0xf7b8, { 0xE9, 0xB7, 0x92 },
	0xf7b9, { 0xE9, 0xB7, 0x9E },
	0xf7ba, { 0xE9, 0xB7, 0x9A },
	0xf7bb, { 0xE9, 0xB7, 0x8B },
	0xf7bc, { 0xE9, 0xB7, 0x90 },
	0xf7bd, { 0xE9, 0xB7, 0x9C },
	0xf7be, { 0xE9, 0xB7, 0x91 },
	0xf7bf, { 0xE9, 0xB7, 0x9F },
	0xf7c0, { 0xE9, 0xB7, 0xA9 },
	0xf7c1, { 0xE9, 0xB7, 0x99 },
	0xf7c2, { 0xE9, 0xB7, 0x98 },
	0xf7c3, { 0xE9, 0xB7, 0x96 },
	0xf7c4, { 0xE9, 0xB7, 0xB5 },
	0xf7c5, { 0xE9, 0xB7, 0x95 },
	0xf7c6, { 0xE9, 0xB7, 0x9D },
	0xf7c7, { 0xE9, 0xBA, 0xB6 },
	0xf7c8, { 0xE9, 0xBB, 0xB0 },
	0xf7c9, { 0xE9, 0xBC, 0xB5 },
	0xf7ca, { 0xE9, 0xBC, 0xB3 },
	0xf7cb, { 0xE9, 0xBC, 0xB2 },
	0xf7cc, { 0xE9, 0xBD, 0x82 },
	0xf7cd, { 0xE9, 0xBD, 0xAB },
	0xf7ce, { 0xE9, 0xBE, 0x95 },
	0xf7cf, { 0xE9, 0xBE, 0xA2 },
	0xf7d0, { 0xE5, 0x84, 0xBD },
	0xf7d1, { 0xE5, 0x8A, 0x99 },
	0xf7d2, { 0xE5, 0xA3, 0xA8 },
	0xf7d3, { 0xE5, 0xA3, 0xA7 },
	0xf7d4, { 0xE5, 0xA5, 0xB2 },
	0xf7d5, { 0xE5, 0xAD, 0x8D },
	0xf7d6, { 0xE5, 0xB7, 0x98 },
	0xf7d7, { 0xE8, 0xA0, 0xAF },
	0xf7d8, { 0xE5, 0xBD, 0x8F },
	0xf7d9, { 0xE6, 0x88, 0x81 },
	0xf7da, { 0xE6, 0x88, 0x83 },
	0xf7db, { 0xE6, 0x88, 0x84 },
	0xf7dc, { 0xE6, 0x94, 0xA9 },
	0xf7dd, { 0xE6, 0x94, 0xA5 },
	0xf7de, { 0xE6, 0x96, 0x96 },
	0xf7df, { 0xE6, 0x9B, 0xAB },
	0xf7e0, { 0xE6, 0xAC, 0x91 },
	0xf7e1, { 0xE6, 0xAC, 0x92 },
	0xf7e2, { 0xE6, 0xAC, 0x8F },
	0xf7e3, { 0xE6, 0xAF, 0x8A },
	0xf7e4, { 0xE7, 0x81, 0x9B },
	0xf7e5, { 0xE7, 0x81, 0x9A },
	0xf7e6, { 0xE7, 0x88, 0xA2 },
	0xf7e7, { 0xE7, 0x8E, 0x82 },
	0xf7e8, { 0xE7, 0x8E, 0x81 },
	0xf7e9, { 0xE7, 0x8E, 0x83 },
	0xf7ea, { 0xE7, 0x99, 0xB0 },
	0xf7eb, { 0xE7, 0x9F, 0x94 },
	0xf7ec, { 0xE7, 0xB1, 0xA7 },
	0xf7ed, { 0xE7, 0xB1, 0xA6 },
	0xf7ee, { 0xE7, 0xBA, 0x95 },
	0xf7ef, { 0xE8, 0x89, 0xAC },
	0xf7f0, { 0xE8, 0x98, 0xBA },
	0xf7f1, { 0xE8, 0x99, 0x80 },
	0xf7f2, { 0xE8, 0x98, 0xB9 },
	0xf7f3, { 0xE8, 0x98, 0xBC },
	0xf7f4, { 0xE8, 0x98, 0xB1 },
	0xf7f5, { 0xE8, 0x98, 0xBB },
	0xf7f6, { 0xE8, 0x98, 0xBE },
	0xf7f7, { 0xE8, 0xA0, 0xB0 },
	0xf7f8, { 0xE8, 0xA0, 0xB2 },
	0xf7f9, { 0xE8, 0xA0, 0xAE },
	0xf7fa, { 0xE8, 0xA0, 0xB3 },
	0xf7fb, { 0xE8, 0xA5, 0xB6 },
	0xf7fc, { 0xE8, 0xA5, 0xB4 },
	0xf7fd, { 0xE8, 0xA5, 0xB3 },
	0xf7fe, { 0xE8, 0xA7, 0xBE },
	0xf840, { 0xE8, 0xAE, 0x8C },
	0xf841, { 0xE8, 0xAE, 0x8E },
	0xf842, { 0xE8, 0xAE, 0x8B },
	0xf843, { 0xE8, 0xAE, 0x88 },
	0xf844, { 0xE8, 0xB1, 0x85 },
	0xf845, { 0xE8, 0xB4, 0x99 },
	0xf846, { 0xE8, 0xBA, 0x98 },
	0xf847, { 0xE8, 0xBD, 0xA4 },
	0xf848, { 0xE8, 0xBD, 0xA3 },
	0xf849, { 0xE9, 0x86, 0xBC },
	0xf84a, { 0xE9, 0x91, 0xA2 },
	0xf84b, { 0xE9, 0x91, 0x95 },
	0xf84c, { 0xE9, 0x91, 0x9D },
	0xf84d, { 0xE9, 0x91, 0x97 },
	0xf84e, { 0xE9, 0x91, 0x9E },
	0xf84f, { 0xE9, 0x9F, 0x84 },
	0xf850, { 0xE9, 0x9F, 0x85 },
	0xf851, { 0xE9, 0xA0, 0x80 },
	0xf852, { 0xE9, 0xA9, 0x96 },
	0xf853, { 0xE9, 0xA9, 0x99 },
	0xf854, { 0xE9, 0xAC, 0x9E },
	0xf855, { 0xE9, 0xAC, 0x9F },
	0xf856, { 0xE9, 0xAC, 0xA0 },
	0xf857, { 0xE9, 0xB1, 0x92 },
	0xf858, { 0xE9, 0xB1, 0x98 },
	0xf859, { 0xE9, 0xB1, 0x90 },
	0xf85a, { 0xE9, 0xB1, 0x8A },
	0xf85b, { 0xE9, 0xB1, 0x8D },
	0xf85c, { 0xE9, 0xB1, 0x8B },
	0xf85d, { 0xE9, 0xB1, 0x95 },
	0xf85e, { 0xE9, 0xB1, 0x99 },
	0xf85f, { 0xE9, 0xB1, 0x8C },
	0xf860, { 0xE9, 0xB1, 0x8E },
	0xf861, { 0xE9, 0xB7, 0xBB },
	0xf862, { 0xE9, 0xB7, 0xB7 },
	0xf863, { 0xE9, 0xB7, 0xAF },
	0xf864, { 0xE9, 0xB7, 0xA3 },
	0xf865, { 0xE9, 0xB7, 0xAB },
	0xf866, { 0xE9, 0xB7, 0xB8 },
	0xf867, { 0xE9, 0xB7, 0xA4 },
	0xf868, { 0xE9, 0xB7, 0xB6 },
	0xf869, { 0xE9, 0xB7, 0xA1 },
	0xf86a, { 0xE9, 0xB7, 0xAE },
	0xf86b, { 0xE9, 0xB7, 0xA6 },
	0xf86c, { 0xE9, 0xB7, 0xB2 },
	0xf86d, { 0xE9, 0xB7, 0xB0 },
	0xf86e, { 0xE9, 0xB7, 0xA2 },
	0xf86f, { 0xE9, 0xB7, 0xAC },
	0xf870, { 0xE9, 0xB7, 0xB4 },
	0xf871, { 0xE9, 0xB7, 0xB3 },
	0xf872, { 0xE9, 0xB7, 0xA8 },
	0xf873, { 0xE9, 0xB7, 0xAD },
	0xf874, { 0xE9, 0xBB, 0x82 },
	0xf875, { 0xE9, 0xBB, 0x90 },
	0xf876, { 0xE9, 0xBB, 0xB2 },
	0xf877, { 0xE9, 0xBB, 0xB3 },
	0xf878, { 0xE9, 0xBC, 0x86 },
	0xf879, { 0xE9, 0xBC, 0x9C },
	0xf87a, { 0xE9, 0xBC, 0xB8 },
	0xf87b, { 0xE9, 0xBC, 0xB7 },
	0xf87c, { 0xE9, 0xBC, 0xB6 },
	0xf87d, { 0xE9, 0xBD, 0x83 },
	0xf87e, { 0xE9, 0xBD, 0x8F },
	0xf8a1, { 0xE9, 0xBD, 0xB1 },
	0xf8a2, { 0xE9, 0xBD, 0xB0 },
	0xf8a3, { 0xE9, 0xBD, 0xAE },
	0xf8a4, { 0xE9, 0xBD, 0xAF },
	0xf8a5, { 0xE5, 0x9B, 0x93 },
	0xf8a6, { 0xE5, 0x9B, 0x8D },
	0xf8a7, { 0xE5, 0xAD, 0x8E },
	0xf8a8, { 0xE5, 0xB1, 0xAD },
	0xf8a9, { 0xE6, 0x94, 0xAD },
	0xf8aa, { 0xE6, 0x9B, 0xAD },
	0xf8ab, { 0xE6, 0x9B, 0xAE },
	0xf8ac, { 0xE6, 0xAC, 0x93 },
	0xf8ad, { 0xE7, 0x81, 0x9F },
	0xf8ae, { 0xE7, 0x81, 0xA1 },
	0xf8af, { 0xE7, 0x81, 0x9D },
	0xf8b0, { 0xE7, 0x81, 0xA0 },
	0xf8b1, { 0xE7, 0x88, 0xA3 },
	0xf8b2, { 0xE7, 0x93, 0x9B },
	0xf8b3, { 0xE7, 0x93, 0xA5 },
	0xf8b4, { 0xE7, 0x9F, 0x95 },
	0xf8b5, { 0xE7, 0xA4, 0xB8 },
	0xf8b6, { 0xE7, 0xA6, 0xB7 },
	0xf8b7, { 0xE7, 0xA6, 0xB6 },
	0xf8b8, { 0xE7, 0xB1, 0xAA },
	0xf8b9, { 0xE7, 0xBA, 0x97 },
	0xf8ba, { 0xE7, 0xBE, 0x89 },
	0xf8bb, { 0xE8, 0x89, 0xAD },
	0xf8bc, { 0xE8, 0x99, 0x83 },
	0xf8bd, { 0xE8, 0xA0, 0xB8 },
	0xf8be, { 0xE8, 0xA0, 0xB7 },
	0xf8bf, { 0xE8, 0xA0, 0xB5 },
	0xf8c0, { 0xE8, 0xA1, 0x8B },
	0xf8c1, { 0xE8, 0xAE, 0x94 },
	0xf8c2, { 0xE8, 0xAE, 0x95 },
	0xf8c3, { 0xE8, 0xBA, 0x9E },
	0xf8c4, { 0xE8, 0xBA, 0x9F },
	0xf8c5, { 0xE8, 0xBA, 0xA0 },
	0xf8c6, { 0xE8, 0xBA, 0x9D },
	0xf8c7, { 0xE9, 0x86, 0xBE },
	0xf8c8, { 0xE9, 0x86, 0xBD },
	0xf8c9, { 0xE9, 0x87, 0x82 },
	0xf8ca, { 0xE9, 0x91, 0xAB },
	0xf8cb, { 0xE9, 0x91, 0xA8 },
	0xf8cc, { 0xE9, 0x91, 0xA9 },
	0xf8cd, { 0xE9, 0x9B, 0xA5 },
	0xf8ce, { 0xE9, 0x9D, 0x86 },
	0xf8cf, { 0xE9, 0x9D, 0x83 },
	0xf8d0, { 0xE9, 0x9D, 0x87 },
	0xf8d1, { 0xE9, 0x9F, 0x87 },
	0xf8d2, { 0xE9, 0x9F, 0xA5 },
	0xf8d3, { 0xE9, 0xA9, 0x9E },
	0xf8d4, { 0xE9, 0xAB, 0x95 },
	0xf8d5, { 0xE9, 0xAD, 0x99 },
	0xf8d6, { 0xE9, 0xB1, 0xA3 },
	0xf8d7, { 0xE9, 0xB1, 0xA7 },
	0xf8d8, { 0xE9, 0xB1, 0xA6 },
	0xf8d9, { 0xE9, 0xB1, 0xA2 },
	0xf8da, { 0xE9, 0xB1, 0x9E },
	0xf8db, { 0xE9, 0xB1, 0xA0 },
	0xf8dc, { 0xE9, 0xB8, 0x82 },
	0xf8dd, { 0xE9, 0xB7, 0xBE },
	0xf8de, { 0xE9, 0xB8, 0x87 },
	0xf8df, { 0xE9, 0xB8, 0x83 },
	0xf8e0, { 0xE9, 0xB8, 0x86 },
	0xf8e1, { 0xE9, 0xB8, 0x85 },
	0xf8e2, { 0xE9, 0xB8, 0x80 },
	0xf8e3, { 0xE9, 0xB8, 0x81 },
	0xf8e4, { 0xE9, 0xB8, 0x89 },
	0xf8e5, { 0xE9, 0xB7, 0xBF },
	0xf8e6, { 0xE9, 0xB7, 0xBD },
	0xf8e7, { 0xE9, 0xB8, 0x84 },
	0xf8e8, { 0xE9, 0xBA, 0xA0 },
	0xf8e9, { 0xE9, 0xBC, 0x9E },
	0xf8ea, { 0xE9, 0xBD, 0x86 },
	0xf8eb, { 0xE9, 0xBD, 0xB4 },
	0xf8ec, { 0xE9, 0xBD, 0xB5 },
	0xf8ed, { 0xE9, 0xBD, 0xB6 },
	0xf8ee, { 0xE5, 0x9B, 0x94 },
	0xf8ef, { 0xE6, 0x94, 0xAE },
	0xf8f0, { 0xE6, 0x96, 0xB8 },
	0xf8f1, { 0xE6, 0xAC, 0x98 },
	0xf8f2, { 0xE6, 0xAC, 0x99 },
	0xf8f3, { 0xE6, 0xAC, 0x97 },
	0xf8f4, { 0xE6, 0xAC, 0x9A },
	0xf8f5, { 0xE7, 0x81, 0xA2 },
	0xf8f6, { 0xE7, 0x88, 0xA6 },
	0xf8f7, { 0xE7, 0x8A, 0xAA },
	0xf8f8, { 0xE7, 0x9F, 0x98 },
	0xf8f9, { 0xE7, 0x9F, 0x99 },
	0xf8fa, { 0xE7, 0xA4, 0xB9 },
	0xf8fb, { 0xE7, 0xB1, 0xA9 },
	0xf8fc, { 0xE7, 0xB1, 0xAB },
	0xf8fd, { 0xE7, 0xB3, 0xB6 },
	0xf8fe, { 0xE7, 0xBA, 0x9A },
	0xf940, { 0xE7, 0xBA, 0x98 },
	0xf941, { 0xE7, 0xBA, 0x9B },
	0xf942, { 0xE7, 0xBA, 0x99 },
	0xf943, { 0xE8, 0x87, 0xA0 },
	0xf944, { 0xE8, 0x87, 0xA1 },
	0xf945, { 0xE8, 0x99, 0x86 },
	0xf946, { 0xE8, 0x99, 0x87 },
	0xf947, { 0xE8, 0x99, 0x88 },
	0xf948, { 0xE8, 0xA5, 0xB9 },
	0xf949, { 0xE8, 0xA5, 0xBA },
	0xf94a, { 0xE8, 0xA5, 0xBC },
	0xf94b, { 0xE8, 0xA5, 0xBB },
	0xf94c, { 0xE8, 0xA7, 0xBF },
	0xf94d, { 0xE8, 0xAE, 0x98 },
	0xf94e, { 0xE8, 0xAE, 0x99 },
	0xf94f, { 0xE8, 0xBA, 0xA5 },
	0xf950, { 0xE8, 0xBA, 0xA4 },
	0xf951, { 0xE8, 0xBA, 0xA3 },
	0xf952, { 0xE9, 0x91, 0xAE },
	0xf953, { 0xE9, 0x91, 0xAD },
	0xf954, { 0xE9, 0x91, 0xAF },
	0xf955, { 0xE9, 0x91, 0xB1 },
	0xf956, { 0xE9, 0x91, 0xB3 },
	0xf957, { 0xE9, 0x9D, 0x89 },
	0xf958, { 0xE9, 0xA1, 0xB2 },
	0xf959, { 0xE9, 0xA5, 0x9F },
	0xf95a, { 0xE9, 0xB1, 0xA8 },
	0xf95b, { 0xE9, 0xB1, 0xAE },
	0xf95c, { 0xE9, 0xB1, 0xAD },
	0xf95d, { 0xE9, 0xB8, 0x8B },
	0xf95e, { 0xE9, 0xB8, 0x8D },
	0xf95f, { 0xE9, 0xB8, 0x90 },
	0xf960, { 0xE9, 0xB8, 0x8F },
	0xf961, { 0xE9, 0xB8, 0x92 },
	0xf962, { 0xE9, 0xB8, 0x91 },
	0xf963, { 0xE9, 0xBA, 0xA1 },
	0xf964, { 0xE9, 0xBB, 0xB5 },
	0xf965, { 0xE9, 0xBC, 0x89 },
	0xf966, { 0xE9, 0xBD, 0x87 },
	0xf967, { 0xE9, 0xBD, 0xB8 },
	0xf968, { 0xE9, 0xBD, 0xBB },
	0xf969, { 0xE9, 0xBD, 0xBA },
	0xf96a, { 0xE9, 0xBD, 0xB9 },
	0xf96b, { 0xE5, 0x9C, 0x9E },
	0xf96c, { 0xE7, 0x81, 0xA6 },
	0xf96d, { 0xE7, 0xB1, 0xAF },
	0xf96e, { 0xE8, 0xA0, 0xBC },
	0xf96f, { 0xE8, 0xB6, 0xB2 },
	0xf970, { 0xE8, 0xBA, 0xA6 },
	0xf971, { 0xE9, 0x87, 0x83 },
	0xf972, { 0xE9, 0x91, 0xB4 },
	0xf973, { 0xE9, 0x91, 0xB8 },
	0xf974, { 0xE9, 0x91, 0xB6 },
	0xf975, { 0xE9, 0x91, 0xB5 },
	0xf976, { 0xE9, 0xA9, 0xA0 },
	0xf977, { 0xE9, 0xB1, 0xB4 },
	0xf978, { 0xE9, 0xB1, 0xB3 },
	0xf979, { 0xE9, 0xB1, 0xB1 },
	0xf97a, { 0xE9, 0xB1, 0xB5 },
	0xf97b, { 0xE9, 0xB8, 0x94 },
	0xf97c, { 0xE9, 0xB8, 0x93 },
	0xf97d, { 0xE9, 0xBB, 0xB6 },
	0xf97e, { 0xE9, 0xBC, 0x8A },
	0xf9a1, { 0xE9, 0xBE, 0xA4 },
	0xf9a2, { 0xE7, 0x81, 0xA8 },
	0xf9a3, { 0xE7, 0x81, 0xA5 },
	0xf9a4, { 0xE7, 0xB3, 0xB7 },
	0xf9a5, { 0xE8, 0x99, 0xAA },
	0xf9a6, { 0xE8, 0xA0, 0xBE },
	0xf9a7, { 0xE8, 0xA0, 0xBD },
	0xf9a8, { 0xE8, 0xA0, 0xBF },
	0xf9a9, { 0xE8, 0xAE, 0x9E },
	0xf9aa, { 0xE8, 0xB2, 0x9C },
	0xf9ab, { 0xE8, 0xBA, 0xA9 },
	0xf9ac, { 0xE8, 0xBB, 0x89 },
	0xf9ad, { 0xE9, 0x9D, 0x8B },
	0xf9ae, { 0xE9, 0xA1, 0xB3 },
	0xf9af, { 0xE9, 0xA1, 0xB4 },
	0xf9b0, { 0xE9, 0xA3, 0x8C },
	0xf9b1, { 0xE9, 0xA5, 0xA1 },
	0xf9b2, { 0xE9, 0xA6, 0xAB },
	0xf9b3, { 0xE9, 0xA9, 0xA4 },
	0xf9b4, { 0xE9, 0xA9, 0xA6 },
	0xf9b5, { 0xE9, 0xA9, 0xA7 },
	0xf9b6, { 0xE9, 0xAC, 0xA4 },
	0xf9b7, { 0xE9, 0xB8, 0x95 },
	0xf9b8, { 0xE9, 0xB8, 0x97 },
	0xf9b9, { 0xE9, 0xBD, 0x88 },
	0xf9ba, { 0xE6, 0x88, 0x87 },
	0xf9bb, { 0xE6, 0xAC, 0x9E },
	0xf9bc, { 0xE7, 0x88, 0xA7 },
	0xf9bd, { 0xE8, 0x99, 0x8C },
	0xf9be, { 0xE8, 0xBA, 0xA8 },
	0xf9bf, { 0xE9, 0x92, 0x82 },
	0xf9c0, { 0xE9, 0x92, 0x80 },
	0xf9c1, { 0xE9, 0x92, 0x81 },
	0xf9c2, { 0xE9, 0xA9, 0xA9 },
	0xf9c3, { 0xE9, 0xA9, 0xA8 },
	0xf9c4, { 0xE9, 0xAC, 0xAE },
	0xf9c5, { 0xE9, 0xB8, 0x99 },
	0xf9c6, { 0xE7, 0x88, 0xA9 },
	0xf9c7, { 0xE8, 0x99, 0x8B },
	0xf9c8, { 0xE8, 0xAE, 0x9F },
	0xf9c9, { 0xE9, 0x92, 0x83 },
	0xf9ca, { 0xE9, 0xB1, 0xB9 },
	0xf9cb, { 0xE9, 0xBA, 0xB7 },
	0xf9cc, { 0xE7, 0x99, 0xB5 },
	0xf9cd, { 0xE9, 0xA9, 0xAB },
	0xf9ce, { 0xE9, 0xB1, 0xBA },
	0xf9cf, { 0xE9, 0xB8, 0x9D },
	0xf9d0, { 0xE7, 0x81, 0xA9 },
	0xf9d1, { 0xE7, 0x81, 0xAA },
	0xf9d2, { 0xE9, 0xBA, 0xA4 },
	0xf9d3, { 0xE9, 0xBD, 0xBE },
	0xf9d4, { 0xE9, 0xBD, 0x89 },
	0xf9d5, { 0xE9, 0xBE, 0x98 },
	0xf9d6, { 0xE7, 0xA2, 0x81 },
	0xf9d7, { 0xE9, 0x8A, 0xB9 },
	0xf9d8, { 0xE8, 0xA3, 0x8F },
	0xf9d9, { 0xE5, 0xA2, 0xBB },
	0xf9da, { 0xE6, 0x81, 0x92 },
	0xf9db, { 0xE7, 0xB2, 0xA7 },
	0xf9dc, { 0xE5, 0xAB, 0xBA },
	0xf9dd, { 0xE2, 0x95, 0x94 },
	0xf9de, { 0xE2, 0x95, 0xA6 },
	0xf9df, { 0xE2, 0x95, 0x97 },
	0xf9e0, { 0xE2, 0x95, 0xA0 },
	0xf9e1, { 0xE2, 0x95, 0xAC },
	0xf9e2, { 0xE2, 0x95, 0xA3 },
	0xf9e3, { 0xE2, 0x95, 0x9A },
	0xf9e4, { 0xE2, 0x95, 0xA9 },
	0xf9e5, { 0xE2, 0x95, 0x9D },
	0xf9e6, { 0xE2, 0x95, 0x92 },
	0xf9e7, { 0xE2, 0x95, 0xA4 },
	0xf9e8, { 0xE2, 0x95, 0x95 },
	0xf9e9, { 0xE2, 0x95, 0x9E },
	0xf9ea, { 0xE2, 0x95, 0xAA },
	0xf9eb, { 0xE2, 0x95, 0xA1 },
	0xf9ec, { 0xE2, 0x95, 0x98 },
	0xf9ed, { 0xE2, 0x95, 0xA7 },
	0xf9ee, { 0xE2, 0x95, 0x9B },
	0xf9ef, { 0xE2, 0x95, 0x93 },
	0xf9f0, { 0xE2, 0x95, 0xA5 },
	0xf9f1, { 0xE2, 0x95, 0x96 },
	0xf9f2, { 0xE2, 0x95, 0x9F },
	0xf9f3, { 0xE2, 0x95, 0xAB },
	0xf9f4, { 0xE2, 0x95, 0xA2 },
	0xf9f5, { 0xE2, 0x95, 0x99 },
	0xf9f6, { 0xE2, 0x95, 0xA8 },
	0xf9f7, { 0xE2, 0x95, 0x9C },
	0xf9f8, { 0xE2, 0x95, 0x91 },
	0xf9f9, { 0xE2, 0x95, 0x90 },
	0xf9fa, { 0xE2, 0x95, 0xAD },
	0xf9fb, { 0xE2, 0x95, 0xAE },
	0xf9fc, { 0xE2, 0x95, 0xB0 },
	0xf9fd, { 0xE2, 0x95, 0xAF },
	0xf9fe, { 0xE2, 0x96, 0x93 },
	0xfa40, { 0xEE, 0x80, 0x80 },
	0xfa41, { 0xE9, 0x8B, 0x9B },
	0xfa42, { 0xEE, 0x80, 0x82 },
	0xfa43, { 0xEE, 0x80, 0x83 },
	0xfa44, { 0xE8, 0x95, 0x8C },
	0xfa45, { 0xE4, 0x8A, 0xB5 },
	0xfa46, { 0xE7, 0x8F, 0xAF },
	0xfa47, { 0xE5, 0x86, 0xB5 },
	0xfa48, { 0xE3, 0x99, 0x89 },
	0xfa49, { 0xEE, 0x80, 0x89 },
	0xfa4a, { 0xEE, 0x80, 0x8A },
	0xfa4b, { 0xE9, 0x8D, 0x84 },
	0xfa4c, { 0xEE, 0x80, 0x8C },
	0xfa4d, { 0xE8, 0x8B, 0xAE },
	0xfa4e, { 0xEE, 0x80, 0x8E },
	0xfa4f, { 0xE7, 0xA0, 0xBC },
	0xfa50, { 0xE6, 0x9D, 0x84 },
	0xfa51, { 0xE6, 0x8B, 0x9F },
	0xfa52, { 0xEE, 0x80, 0x92 },
	0xfa53, { 0xEE, 0x80, 0x93 },
	0xfa54, { 0xEE, 0x80, 0x94 },
	0xfa55, { 0xEE, 0x80, 0x95 },
	0xfa56, { 0xEE, 0x80, 0x96 },
	0xfa57, { 0xE4, 0xBE, 0xAB },
	0xfa58, { 0xEE, 0x80, 0x98 },
	0xfa59, { 0xE5, 0x80, 0x88 },
	0xfa5a, { 0xEE, 0x80, 0x9A },
	0xfa5b, { 0xEE, 0x80, 0x9B },
	0xfa5c, { 0xEE, 0x80, 0x9C },
	0xfa5d, { 0xEE, 0x80, 0x9D },
	0xfa5e, { 0xEE, 0x80, 0x9E },
	0xfa60, { 0xEE, 0x80, 0xA0 },
	0xfa61, { 0xE5, 0xBE, 0xA4 },
	0xfa62, { 0xEE, 0x80, 0xA2 },
	0xfa63, { 0xEE, 0x80, 0xA3 },
	0xfa64, { 0xE6, 0xBB, 0x9B },
	0xfa65, { 0xEE, 0x80, 0xA5 },
	0xfa67, { 0xE5, 0x84, 0x81 },
	0xfa68, { 0xE3, 0x91, 0xBA },
	0xfa69, { 0xE5, 0x84, 0x8E },
	0xfa6a, { 0xE9, 0xA1, 0xAC },
	0xfa6b, { 0xE3, 0x9D, 0x83 },
	0xfa6c, { 0xE8, 0x90, 0x96 },
	0xfa6d, { 0xEE, 0x80, 0xAD },
	0xfa6e, { 0xEE, 0x80, 0xAE },
	0xfa6f, { 0xE5, 0x85, 0xA0 },
	0xfa70, { 0xEE, 0x80, 0xB0 },
	0xfa71, { 0xE5, 0x85, 0xAA },
	0xfa72, { 0xEE, 0x80, 0xB2 },
	0xfa73, { 0xEE, 0x80, 0xB3 },
	0xfa74, { 0xEE, 0x80, 0xB4 },
	0xfa75, { 0xEE, 0x80, 0xB5 },
	0xfa76, { 0xEE, 0x80, 0xB6 },
	0xfa77, { 0xEE, 0x80, 0xB7 },
	0xfa78, { 0xEE, 0x80, 0xB8 },
	0xfa79, { 0xE5, 0xAE, 0x82 },
	0xfa7a, { 0xE8, 0x9D, 0xBD },
	0xfa7b, { 0xEE, 0x80, 0xBB },
	0xfa7c, { 0xEE, 0x80, 0xBC },
	0xfa7d, { 0xE5, 0x86, 0xB2 },
	0xfa7e, { 0xE5, 0x86, 0xB8 },
	0xfaa1, { 0xE9, 0xB4, 0xB4 },
	0xfaa2, { 0xE5, 0x87, 0x89 },
	0xfaa3, { 0xE5, 0x87, 0x8F },
	0xfaa4, { 0xE5, 0x87, 0x91 },
	0xfaa5, { 0xE3, 0xB3, 0x9C },
	0xfaa6, { 0xE5, 0x87, 0x93 },
	0xfaa7, { 0xEE, 0x81, 0x85 },
	0xfaa8, { 0xE5, 0x86, 0xB3 },
	0xfaa9, { 0xE5, 0x87, 0xA2 },
	0xfaaa, { 0xE5, 0x8D, 0x82 },
	0xfaab, { 0xE5, 0x87, 0xAD },
	0xfaac, { 0xE8, 0x8F, 0x8D },
	0xfaad, { 0xE6, 0xA4, 0xBE },
	0xfaae, { 0xEE, 0x81, 0x8C },
	0xfaaf, { 0xE5, 0xBD, 0xBB },
	0xfab0, { 0xE5, 0x88, 0x8B },
	0xfab1, { 0xE5, 0x88, 0xA6 },
	0xfab2, { 0xE5, 0x88, 0xBC },
	0xfab3, { 0xE5, 0x8A, 0xB5 },
	0xfab4, { 0xE5, 0x89, 0x97 },
	0xfab5, { 0xE5, 0x8A, 0x94 },
	0xfab6, { 0xE5, 0x8A, 0xB9 },
	0xfab7, { 0xE5, 0x8B, 0x85 },
	0xfab8, { 0xE7, 0xB0, 0x95 },
	0xfab9, { 0xE8, 0x95, 0x82 },
	0xfaba, { 0xE5, 0x8B, 0xA0 },
	0xfabb, { 0xE8, 0x98, 0x8D },
	0xfabc, { 0xEE, 0x81, 0x9A },
	0xfabe, { 0xEE, 0x81, 0x9C },
	0xfabf, { 0xE5, 0x95, 0x89 },
	0xfac0, { 0xE6, 0xBB, 0x99 },
	0xfac1, { 0xEE, 0x81, 0x9F },
	0xfac2, { 0xEE, 0x81, 0xA0 },
	0xfac3, { 0xEE, 0x81, 0xA1 },
	0xfac4, { 0xE5, 0x8C, 0xB3 },
	0xfac6, { 0xEE, 0x81, 0xA4 },
	0xfac7, { 0xE6, 0xB3, 0x8B },
	0xfac8, { 0xEE, 0x81, 0xA6 },
	0xfac9, { 0xE6, 0xA0, 0x9B },
	0xfaca, { 0xE7, 0x8F, 0x95 },
	0xfacb, { 0xE6, 0x81, 0x8A },
	0xfacc, { 0xE3, 0xBA, 0xAA },
	0xfacd, { 0xE3, 0xA3, 0x8C },
	0xface, { 0xEE, 0x81, 0xAC },
	0xfacf, { 0xE7, 0x87, 0x9D },
	0xfad0, { 0xE4, 0x92, 0xA2 },
	0xfad1, { 0xE5, 0x8D, 0xAD },
	0xfad2, { 0xE5, 0x8D, 0xB4 },
	0xfad3, { 0xEE, 0x81, 0xB1 },
	0xfad4, { 0xE5, 0x8D, 0xBE },
	0xfad6, { 0xEE, 0x81, 0xB4 },
	0xfad7, { 0xEE, 0x81, 0xB5 },
	0xfad8, { 0xE7, 0x9F, 0xA6 },
	0xfad9, { 0xE5, 0x8E, 0x93 },
	0xfada, { 0xEE, 0x81, 0xB8 },
	0xfadb, { 0xE5, 0x8E, 0xA0 },
	0xfadc, { 0xE5, 0x8E, 0xAB },
	0xfadd, { 0xE5, 0x8E, 0xAE },
	0xfade, { 0xE7, 0x8E, 0xA7 },
	0xfadf, { 0xEE, 0x81, 0xBD },
	0xfae0, { 0xE3, 0xBD, 0x99 },
	0xfae1, { 0xE7, 0x8E, 0x9C },
	0xfae2, { 0xE5, 0x8F, 0x81 },
	0xfae3, { 0xE5, 0x8F, 0x85 },
	0xfae4, { 0xE6, 0xB1, 0x89 },
	0xfae5, { 0xE4, 0xB9, 0x89 },
	0xfae6, { 0xE5, 0x9F, 0xBE },
	0xfae7, { 0xE5, 0x8F, 0x99 },
	0xfae8, { 0xE3, 0xAA, 0xAB },
	0xfae9, { 0xEE, 0x82, 0x87 },
	0xfaea, { 0xE5, 0x8F, 0xA0 },
	0xfaeb, { 0xEE, 0x82, 0x89 },
	0xfaec, { 0xEE, 0x82, 0x8A },
	0xfaed, { 0xE5, 0x8F, 0xB6 },
	0xfaee, { 0xEE, 0x82, 0x8C },
	0xfaef, { 0xE5, 0x90, 0x93 },
	0xfaf0, { 0xE7, 0x81, 0xB9 },
	0xfaf1, { 0xE5, 0x94, 0xAB },
	0xfaf2, { 0xE6, 0x99, 0x97 },
	0xfaf3, { 0xE6, 0xB5, 0x9B },
	0xfaf4, { 0xE5, 0x91, 0xAD },
	0xfaf5, { 0xEE, 0x82, 0x93 },
	0xfaf6, { 0xEE, 0x82, 0x94 },
	0xfaf7, { 0xE5, 0x95, 0x9D },
	0xfaf8, { 0xE5, 0x92, 0x8F },
	0xfaf9, { 0xE5, 0x92, 0xA4 },
	0xfafa, { 0xE4, 0x9E, 0xA6 },
	0xfafb, { 0xEE, 0x82, 0x99 },
	0xfafc, { 0xEE, 0x82, 0x9A },
	0xfafd, { 0xE3, 0xB6, 0xB4 },
	0xfafe, { 0xEE, 0x82, 0x9C },
	0xfb40, { 0xEE, 0x82, 0x9D },
	0xfb41, { 0xEE, 0x82, 0x9E },
	0xfb42, { 0xE5, 0x95, 0x87 },
	0xfb43, { 0xE4, 0xB3, 0xAD },
	0xfb44, { 0xE5, 0x90, 0xAF },
	0xfb45, { 0xE7, 0x90, 0x97 },
	0xfb46, { 0xE5, 0x96, 0x86 },
	0xfb47, { 0xE5, 0x96, 0xA9 },
	0xfb49, { 0xEE, 0x82, 0xA6 },
	0xfb4a, { 0xEE, 0x82, 0xA7 },
	0xfb4b, { 0xE4, 0x95, 0x92 },
	0xfb4c, { 0xEE, 0x82, 0xA9 },
	0xfb4d, { 0xE6, 0x9A, 0xB3 },
	0xfb4e, { 0xEE, 0x82, 0xAB },
	0xfb4f, { 0xE5, 0x98, 0xB7 },
	0xfb50, { 0xE6, 0x9B, 0x8D },
	0xfb51, { 0xEE, 0x82, 0xAE },
	0xfb52, { 0xE6, 0x9A, 0xA4 },
	0xfb53, { 0xE6, 0x9A, 0xAD },
	0xfb54, { 0xE5, 0x99, 0x8D },
	0xfb55, { 0xE5, 0x99, 0x8F },
	0xfb56, { 0xE7, 0xA3, 0xB1 },
	0xfb57, { 0xE5, 0x9B, 0xB1 },
	0xfb58, { 0xE9, 0x9E, 0x87 },
	0xfb59, { 0xE5, 0x8F, 0xBE },
	0xfb5a, { 0xE5, 0x9C, 0x80 },
	0xfb5b, { 0xE5, 0x9B, 0xAF },
	0xfb5c, { 0xE5, 0x9B, 0xAD },
	0xfb5d, { 0xEE, 0x82, 0xBA },
	0xfb5e, { 0xE3, 0x98, 0xA3 },
	0xfb5f, { 0xEE, 0x82, 0xBC },
	0xfb60, { 0xE5, 0x9D, 0x86 },
	0xfb61, { 0xEE, 0x82, 0xBE },
	0xfb62, { 0xE6, 0xB1, 0xAE },
	0xfb63, { 0xE7, 0x82, 0x8B },
	0xfb64, { 0xE5, 0x9D, 0x82 },
	0xfb65, { 0xE3, 0x9A, 0xB1 },
	0xfb66, { 0xEE, 0x83, 0x83 },
	0xfb67, { 0xE5, 0x9F, 0xA6 },
	0xfb68, { 0xEE, 0x83, 0x85 },
	0xfb69, { 0xE5, 0xA0, 0x83 },
	0xfb6a, { 0xEE, 0x83, 0x87 },
	0xfb6b, { 0xEE, 0x83, 0x88 },
	0xfb6c, { 0xE5, 0xA0, 0xA6 },
	0xfb6d, { 0xEE, 0x83, 0x8A },
	0xfb6e, { 0xE5, 0xA1, 0x9C },
	0xfb6f, { 0xE5, 0xA2, 0xAA },
	0xfb70, { 0xE3, 0x95, 0xA1 },
	0xfb71, { 0xE5, 0xA3, 0xA0 },
	0xfb72, { 0xE5, 0xA3, 0x9C },
	0xfb73, { 0xEE, 0x83, 0x90 },
	0xfb74, { 0xE5, 0xA3, 0xBB },
	0xfb75, { 0xE5, 0xAF, 0xBF },
	0xfb76, { 0xE5, 0x9D, 0x83 },
	0xfb77, { 0xEE, 0x83, 0x94 },
	0xfb78, { 0xEE, 0x83, 0x95 },
	0xfb79, { 0xE9, 0x8F, 0x93 },
	0xfb7a, { 0xE3, 0x96, 0xA1 },
	0xfb7b, { 0xE5, 0xA4, 0x9F },
	0xfb7c, { 0xE6, 0xA2, 0xA6 },
	0xfb7d, { 0xE3, 0x9B, 0x83 },
	0xfb7e, { 0xE6, 0xB9, 0x99 },
	0xfba1, { 0xEE, 0x83, 0x9C },
	0xfba2, { 0xE5, 0xA8, 0xA4 },
	0xfba3, { 0xE5, 0x95, 0x93 },
	0xfba4, { 0xEE, 0x83, 0x9F },
	0xfba5, { 0xE8, 0x94, 0x85 },
	0xfba6, { 0xE5, 0xA7, 0x89 },
	0xfba7, { 0xEE, 0x83, 0xA2 },
	0xfba8, { 0xEE, 0x83, 0xA3 },
	0xfba9, { 0xEE, 0x83, 0xA4 },
	0xfbaa, { 0xEE, 0x83, 0xA5 },
	0xfbab, { 0xE5, 0xA7, 0x99 },
	0xfbac, { 0xEE, 0x83, 0xA7 },
	0xfbad, { 0xEE, 0x83, 0xA8 },
	0xfbae, { 0xEE, 0x83, 0xA9 },
	0xfbaf, { 0xE6, 0xB5, 0xB1 },
	0xfbb0, { 0xEE, 0x83, 0xAB },
	0xfbb1, { 0xEE, 0x83, 0xAC },
	0xfbb2, { 0xE5, 0xA7, 0xB9 },
	0xfbb3, { 0xEE, 0x83, 0xAE },
	0xfbb4, { 0xE5, 0xAA, 0xAB },
	0xfbb5, { 0xE5, 0xA9, 0xA3 },
	0xfbb6, { 0xE3, 0x9B, 0xA6 },
	0xfbb7, { 0xEE, 0x83, 0xB2 },
	0xfbb9, { 0xE3, 0x9C, 0x88 },
	0xfbba, { 0xE5, 0xAA, 0x96 },
	0xfbbb, { 0xE7, 0x91, 0xA5 },
	0xfbbc, { 0xE5, 0xAB, 0x93 },
	0xfbbd, { 0xEE, 0x83, 0xB8 },
	0xfbbe, { 0xEE, 0x83, 0xB9 },
	0xfbbf, { 0xE3, 0xB6, 0x85 },
	0xfbc0, { 0xEE, 0x83, 0xBB },
	0xfbc1, { 0xE3, 0x9C, 0xB2 },
	0xfbc2, { 0xEE, 0x83, 0xBD },
	0xfbc3, { 0xE5, 0xBA, 0x83 },
	0xfbc4, { 0xE5, 0x8B, 0x90 },
	0xfbc5, { 0xE5, 0xAD, 0xB6 },
	0xfbc6, { 0xE6, 0x96, 0x88 },
	0xfbc7, { 0xE5, 0xAD, 0xBC },
	0xfbc8, { 0xEE, 0x84, 0x83 },
	0xfbc9, { 0xE4, 0x80, 0x84 },
	0xfbca, { 0xE4, 0xA1, 0x9D },
	0xfbcb, { 0xEE, 0x84, 0x86 },
	0xfbcc, { 0xE5, 0xAF, 0x95 },
	0xfbcd, { 0xE6, 0x85, 0xA0 },
	0xfbce, { 0xEE, 0x84, 0x89 },
	0xfbcf, { 0xEE, 0x84, 0x8A },
	0xfbd0, { 0xEE, 0x84, 0x8B },
	0xfbd1, { 0xE5, 0xAF, 0xB3 },
	0xfbd2, { 0xE5, 0xAE, 0x9D },
	0xfbd3, { 0xE4, 0xB4, 0x90 },
	0xfbd4, { 0xE5, 0xB0, 0x85 },
	0xfbd5, { 0xEE, 0x84, 0x90 },
	0xfbd6, { 0xE5, 0xB0, 0x93 },
	0xfbd7, { 0xE7, 0x8F, 0x8E },
	0xfbd8, { 0xE5, 0xB0, 0x94 },
	0xfbd9, { 0xEE, 0x84, 0x94 },
	0xfbda, { 0xEE, 0x84, 0x95 },
	0xfbdb, { 0xE5, 0xB1, 0x89 },
	0xfbdc, { 0xE4, 0xA3, 0x9D },
	0xfbdd, { 0xE5, 0xB2, 0x85 },
	0xfbde, { 0xE5, 0xB3, 0xA9 },
	0xfbdf, { 0xE5, 0xB3, 0xAF },
	0xfbe0, { 0xE5, 0xB6, 0x8B },
	0xfbe1, { 0xEE, 0x84, 0x9C },
	0xfbe2, { 0xEE, 0x84, 0x9D },
	0xfbe3, { 0xE5, 0xB4, 0x90 },
	0xfbe4, { 0xE5, 0xB4, 0x98 },
	0xfbe5, { 0xE5, 0xB5, 0x86 },
	0xfbe6, { 0xEE, 0x84, 0xA1 },
	0xfbe7, { 0xE5, 0xB2, 0xBA },
	0xfbe8, { 0xE5, 0xB7, 0x97 },
	0xfbe9, { 0xE8, 0x8B, 0xBC },
	0xfbea, { 0xE3, 0xA0, 0xAD },
	0xfbeb, { 0xEE, 0x84, 0xA6 },
	0xfbec, { 0xEE, 0x84, 0xA7 },
	0xfbed, { 0xEE, 0x84, 0xA8 },
	0xfbee, { 0xE8, 0x8A, 0x87 },
	0xfbef, { 0xE3, 0xA0, 0xB6 },
	0xfbf0, { 0xE3, 0xAF, 0x82 },
	0xfbf1, { 0xE5, 0xB8, 0xAE },
	0xfbf2, { 0xE6, 0xAA, 0x8A },
	0xfbf4, { 0xE5, 0xB9, 0xBA },
	0xfbf5, { 0xEE, 0x84, 0xB0 },
	0xfbf6, { 0xEE, 0x84, 0xB1 },
	0xfbf7, { 0xE5, 0x8E, 0xA6 },
	0xfbf8, { 0xE4, 0xBA, 0xB7 },
	0xfbfa, { 0xE5, 0x8E, 0xA8 },
	0xfbfb, { 0xEE, 0x84, 0xB6 },
	0xfbfc, { 0xE5, 0xB8, 0x89 },
	0xfbfd, { 0xE5, 0xBB, 0xB4 },
	0xfbfe, { 0xEE, 0x84, 0xB9 },
	0xfc40, { 0xE5, 0xBB, 0xB9 },
	0xfc41, { 0xE5, 0xBB, 0xBB },
	0xfc42, { 0xE3, 0xA2, 0xA0 },
	0xfc43, { 0xE5, 0xBB, 0xBC },
	0xfc44, { 0xE6, 0xA0, 0xBE },
	0xfc45, { 0xE9, 0x90, 0x9B },
	0xfc46, { 0xE5, 0xBC, 0x8D },
	0xfc47, { 0xEE, 0x85, 0x81 },
	0xfc48, { 0xEE, 0x85, 0x82 },
	0xfc49, { 0xE3, 0xAB, 0x9E },
	0xfc4a, { 0xE4, 0xA2, 0xAE },
	0xfc4b, { 0xEE, 0x85, 0x85 },
	0xfc4c, { 0xE5, 0xBC, 0xBA },
	0xfc4d, { 0xEE, 0x85, 0x87 },
	0xfc4e, { 0xEE, 0x85, 0x88 },
	0xfc50, { 0xEE, 0x85, 0x8A },
	0xfc51, { 0xE5, 0xBD, 0xA3 },
	0xfc52, { 0xE9, 0x9E, 0xBD },
	0xfc53, { 0xEE, 0x85, 0x8D },
	0xfc54, { 0xE5, 0xBD, 0xB2 },
	0xfc55, { 0xE9, 0x8D, 0x80 },
	0xfc56, { 0xEE, 0x85, 0x90 },
	0xfc57, { 0xE5, 0xBE, 0xA7 },
	0xfc58, { 0xE5, 0xB6, 0xB6 },
	0xfc59, { 0xE3, 0xB5, 0x9F },
	0xfc5a, { 0xEE, 0x85, 0x94 },
	0xfc5b, { 0xEE, 0x85, 0x95 },
	0xfc5c, { 0xEE, 0x85, 0x96 },
	0xfc5d, { 0xEE, 0x85, 0x97 },
	0xfc5e, { 0xE9, 0x87, 0x96 },
	0xfc5f, { 0xEE, 0x85, 0x99 },
	0xfc60, { 0xEE, 0x85, 0x9A },
	0xfc61, { 0xE6, 0x80, 0xB1 },
	0xfc62, { 0xE6, 0x9A, 0x85 },
	0xfc63, { 0xEE, 0x85, 0x9D },
	0xfc64, { 0xE3, 0xA5, 0xA3 },
	0xfc65, { 0xE3, 0xB7, 0x87 },
	0xfc66, { 0xE3, 0x98, 0xB9 },
	0xfc67, { 0xE5, 0x9E, 0x90 },
	0xfc68, { 0xEE, 0x85, 0xA2 },
	0xfc69, { 0xE7, 0xA5, 0xB1 },
	0xfc6a, { 0xE3, 0xB9, 0x80 },
	0xfc6b, { 0xE6, 0x82, 0x9E },
	0xfc6d, { 0xE6, 0x82, 0xB3 },
	0xfc6e, { 0xEE, 0x85, 0xA8 },
	0xfc6f, { 0xEE, 0x85, 0xA9 },
	0xfc70, { 0xEE, 0x85, 0xAA },
	0xfc71, { 0xE7, 0x92, 0xA4 },
	0xfc72, { 0xE5, 0x83, 0xA1 },
	0xfc73, { 0xE5, 0xAA, 0xA0 },
	0xfc74, { 0xE6, 0x85, 0xA4 },
	0xfc75, { 0xE8, 0x90, 0xA4 },
	0xfc76, { 0xE6, 0x85, 0x82 },
	0xfc77, { 0xEE, 0x85, 0xB1 },
	0xfc78, { 0xEE, 0x85, 0xB2 },
	0xfc79, { 0xE6, 0x86, 0x81 },
	0xfc7a, { 0xE5, 0x87, 0xB4 },
	0xfc7b, { 0xEE, 0x85, 0xB5 },
	0xfc7c, { 0xE6, 0x86, 0x87 },
	0xfc7d, { 0xE5, 0xAE, 0xAA },
	0xfc7e, { 0xEE, 0x85, 0xB8 },
	0xfca1, { 0xEE, 0x85, 0xB9 },
	0xfca2, { 0xE6, 0x87, 0x93 },
	0xfca3, { 0xEE, 0x85, 0xBB },
	0xfca4, { 0xEE, 0x85, 0xBC },
	0xfca5, { 0xE6, 0x87, 0x90 },
	0xfca6, { 0xE3, 0xA4, 0xB2 },
	0xfca7, { 0xEE, 0x85, 0xBF },
	0xfca8, { 0xEE, 0x86, 0x80 },
	0xfca9, { 0xE6, 0x80, 0xA3 },
	0xfcaa, { 0xE6, 0x85, 0x9C },
	0xfcab, { 0xE6, 0x94, 0x9E },
	0xfcac, { 0xE6, 0x8E, 0x8B },
	0xfcad, { 0xEE, 0x86, 0x85 },
	0xfcae, { 0xE6, 0x8B, 0x85 },
	0xfcaf, { 0xEE, 0x86, 0x87 },
	0xfcb0, { 0xE6, 0x8B, 0x95 },
	0xfcb1, { 0xEE, 0x86, 0x89 },
	0xfcb2, { 0xE6, 0x8D, 0xAC },
	0xfcb3, { 0xEE, 0x86, 0x8B },
	0xfcb4, { 0xE3, 0xA8, 0x97 },
	0xfcb5, { 0xE6, 0x90, 0xB8 },
	0xfcb6, { 0xE6, 0x8F, 0xB8 },
	0xfcb7, { 0xEE, 0x86, 0x8F },
	0xfcb8, { 0xEE, 0x86, 0x90 },
	0xfcba, { 0xE6, 0xBE, 0x8A },
	0xfcbb, { 0xEE, 0x86, 0x93 },
	0xfcbc, { 0xE9, 0xA0, 0x94 },
	0xfcbd, { 0xEE, 0x86, 0x95 },
	0xfcbe, { 0xEE, 0x86, 0x96 },
	0xfcbf, { 0xE6, 0x93, 0xA1 },
	0xfcc0, { 0xE6, 0x93, 0xA5 },
	0xfcc1, { 0xE9, 0x91, 0xBB },
	0xfcc2, { 0xE3, 0xA9, 0xA6 },
	0xfcc3, { 0xE6, 0x90, 0xBA },
	0xfcc4, { 0xE3, 0xA9, 0x97 },
	0xfcc5, { 0xE6, 0x95, 0x8D },
	0xfcc6, { 0xE6, 0xBC, 0x96 },
	0xfcc7, { 0xEE, 0x86, 0x9F },
	0xfcc8, { 0xEE, 0x86, 0xA0 },
	0xfcc9, { 0xE6, 0x96, 0x85 },
	0xfcca, { 0xE6, 0x95, 0xAD },
	0xfccb, { 0xE6, 0x95, 0x9F },
	0xfccc, { 0xEE, 0x86, 0xA4 },
	0xfccd, { 0xE6, 0x96, 0xB5 },
	0xfcce, { 0xEE, 0x86, 0xA6 },
	0xfccf, { 0xE4, 0xAC, 0xB7 },
	0xfcd0, { 0xE6, 0x97, 0x91 },
	0xfcd1, { 0xE4, 0x83, 0x98 },
	0xfcd2, { 0xEE, 0x86, 0xAA },
	0xfcd3, { 0xE6, 0x97, 0xA0 },
	0xfcd4, { 0xE6, 0x97, 0xA3 },
	0xfcd5, { 0xE5, 0xBF, 0x9F },
	0xfcd6, { 0xEE, 0x86, 0xAE },
	0xfcd7, { 0xE6, 0x98, 0x98 },
	0xfcd8, { 0xEE, 0x86, 0xB0 },
	0xfcd9, { 0xEE, 0x86, 0xB1 },
	0xfcda, { 0xE6, 0x99, 0x84 },
	0xfcdb, { 0xEE, 0x86, 0xB3 },
	0xfcdc, { 0xEE, 0x86, 0xB4 },
	0xfcdd, { 0xE6, 0x99, 0x8B },
	0xfcde, { 0xEE, 0x86, 0xB6 },
	0xfcdf, { 0xE6, 0x99, 0xA7 },
	0xfce0, { 0xEE, 0x86, 0xB8 },
	0xfce1, { 0xE6, 0x99, 0xB3 },
	0xfce3, { 0xEE, 0x86, 0xBB },
	0xfce4, { 0xEE, 0x86, 0xBC },
	0xfce5, { 0xEE, 0x86, 0xBD },
	0xfce6, { 0xEE, 0x86, 0xBE },
	0xfce7, { 0xEE, 0x86, 0xBF },
	0xfce8, { 0xE7, 0x9F, 0x85 },
	0xfce9, { 0xEE, 0x87, 0x81 },
	0xfcea, { 0xE9, 0xA6, 0xA4 },
	0xfceb, { 0xE6, 0x9C, 0x82 },
	0xfcec, { 0xEE, 0x87, 0x84 },
	0xfced, { 0xEE, 0x87, 0x85 },
	0xfcee, { 0xE3, 0xAC, 0xAB },
	0xfcef, { 0xE6, 0xA7, 0xBA },
	0xfcf0, { 0xEE, 0x87, 0x88 },
	0xfcf2, { 0xE6, 0x9D, 0xA7 },
	0xfcf3, { 0xE6, 0x9D, 0xA2 },
	0xfcf4, { 0xEE, 0x87, 0x8C },
	0xfcf5, { 0xEE, 0x87, 0x8D },
	0xfcf6, { 0xE6, 0x9F, 0x97 },
	0xfcf7, { 0xE4, 0x93, 0xA9 },
	0xfcf8, { 0xE6, 0xA0, 0xA2 },
	0xfcf9, { 0xE6, 0xB9, 0x90 },
	0xfcfa, { 0xE9, 0x88, 0xBC },
	0xfcfb, { 0xE6, 0xA0, 0x81 },
	0xfcfc, { 0xEE, 0x87, 0x94 },
	0xfcfd, { 0xEE, 0x87, 0x95 },
	0xfcfe, { 0xE6, 0xA1, 0x9D },
	0xfd40, { 0xEE, 0x87, 0x97 },
	0xfd41, { 0xE6, 0xA7, 0xA1 },
	0xfd42, { 0xE6, 0xA8, 0x8B },
	0xfd43, { 0xEE, 0x87, 0x9A },
	0xfd44, { 0xE6, 0xA5, 0xB3 },
	0xfd45, { 0xE6, 0xA3, 0x83 },
	0xfd46, { 0xEE, 0x87, 0x9D },
	0xfd47, { 0xE6, 0xA4, 0x81 },
	0xfd48, { 0xE6, 0xA4, 0x80 },
	0xfd49, { 0xE3, 0xB4, 0xB2 },
	0xfd4a, { 0xE3, 0xA8, 0x81 },
	0xfd4b, { 0xEE, 0x87, 0xA2 },
	0xfd4c, { 0xE3, 0xAE, 0x80 },
	0xfd4d, { 0xE6, 0x9E, 0xAC },
	0xfd4e, { 0xE6, 0xA5, 0xA1 },
	0xfd4f, { 0xEE, 0x87, 0xA6 },
	0xfd50, { 0xE4, 0x8B, 0xBC },
	0xfd51, { 0xE6, 0xA4, 0xB6 },
	0xfd52, { 0xE6, 0xA6, 0x98 },
	0xfd53, { 0xE3, 0xAE, 0xA1 },
	0xfd54, { 0xEE, 0x87, 0xAB },
	0xfd55, { 0xE8, 0x8D, 0xA3 },
	0xfd56, { 0xE5, 0x82, 0x90 },
	0xfd57, { 0xE6, 0xA7, 0xB9 },
	0xfd58, { 0xEE, 0x87, 0xAF },
	0xfd59, { 0xEE, 0x87, 0xB0 },
	0xfd5a, { 0xE6, 0xA9, 0x85 },
	0xfd5b, { 0xEE, 0x87, 0xB2 },
	0xfd5c, { 0xE6, 0xAA, 0x9D },
	0xfd5d, { 0xE3, 0xAF, 0xB3 },
	0xfd5e, { 0xE6, 0x9E, 0xB1 },
	0xfd5f, { 0xE6, 0xAB, 0x88 },
	0xfd60, { 0xEE, 0x87, 0xB7 },
	0xfd61, { 0xE3, 0xB0, 0x8D },
	0xfd62, { 0xE6, 0xAC, 0x9D },
	0xfd63, { 0xEE, 0x87, 0xBA },
	0xfd64, { 0xE6, 0x83, 0x9E },
	0xfd65, { 0xE6, 0xAC, 0xB5 },
	0xfd66, { 0xE6, 0xAD, 0xB4 },
	0xfd67, { 0xEE, 0x87, 0xBE },
	0xfd68, { 0xE6, 0xBA, 0xB5 },
	0xfd69, { 0xEE, 0x88, 0x80 },
	0xfd6a, { 0xEE, 0x88, 0x81 },
	0xfd6b, { 0xEE, 0x88, 0x82 },
	0xfd6c, { 0xE3, 0x9D, 0x80 },
	0xfd6d, { 0xE5, 0x90, 0xA1 },
	0xfd6e, { 0xEE, 0x88, 0x85 },
	0xfd6f, { 0xE6, 0xAF, 0xA1 },
	0xfd70, { 0xEE, 0x88, 0x87 },
	0xfd71, { 0xE6, 0xAF, 0x9C },
	0xfd72, { 0xE6, 0xB0, 0xB7 },
	0xfd73, { 0xEE, 0x88, 0x8A },
	0xfd74, { 0xEE, 0x88, 0x8B },
	0xfd75, { 0xEE, 0x88, 0x8C },
	0xfd76, { 0xE6, 0xB1, 0x9A },
	0xfd77, { 0xE8, 0x88, 0xA6 },
	0xfd78, { 0xE6, 0xB1, 0xB9 },
	0xfd79, { 0xEE, 0x88, 0x90 },
	0xfd7a, { 0xE4, 0x93, 0x85 },
	0xfd7b, { 0xEE, 0x88, 0x92 },
	0xfd7c, { 0xEE, 0x88, 0x93 },
	0xfd7d, { 0xEE, 0x88, 0x94 },
	0xfd7e, { 0xEE, 0x88, 0x95 },
	0xfda1, { 0xEE, 0x88, 0x96 },
	0xfda2, { 0xE3, 0x9B, 0xA5 },
	0xfda3, { 0xE3, 0xB3, 0xAB },
	0xfda4, { 0xEE, 0x88, 0x99 },
	0xfda5, { 0xE9, 0xAE, 0x83 },
	0xfda6, { 0xEE, 0x88, 0x9B },
	0xfda7, { 0xEE, 0x88, 0x9C },
	0xfda8, { 0xE7, 0xBE, 0x8F },
	0xfda9, { 0xE6, 0xA0, 0xB7 },
	0xfdaa, { 0xEE, 0x88, 0x9F },
	0xfdab, { 0xEE, 0x88, 0xA0 },
	0xfdac, { 0xEE, 0x88, 0xA1 },
	0xfdad, { 0xE6, 0xB6, 0x96 },
	0xfdae, { 0xE6, 0xB5, 0x9C },
	0xfdaf, { 0xE6, 0xB9, 0xBC },
	0xfdb0, { 0xE6, 0xBC, 0x84 },
	0xfdb1, { 0xEE, 0x88, 0xA6 },
	0xfdb2, { 0xEE, 0x88, 0xA7 },
	0xfdb3, { 0xEE, 0x88, 0xA8 },
	0xfdb4, { 0xE8, 0x94, 0xB3 },
	0xfdb5, { 0xEE, 0x88, 0xAA },
	0xfdb6, { 0xE5, 0x87, 0x87 },
	0xfdb9, { 0xE8, 0x90, 0xAE },
	0xfdba, { 0xEE, 0x88, 0xAF },
	0xfdbc, { 0xEE, 0x88, 0xB1 },
	0xfdbd, { 0xE7, 0x91, 0x93 },
	0xfdbe, { 0xEE, 0x88, 0xB3 },
	0xfdbf, { 0xE7, 0xA7, 0x8C },
	0xfdc0, { 0xE6, 0xB9, 0x8F },
	0xfdc1, { 0xE5, 0xAA, 0x91 },
	0xfdc2, { 0xEE, 0x88, 0xB7 },
	0xfdc3, { 0xE6, 0xBF, 0xB8 },
	0xfdc4, { 0xE3, 0x9C, 0x8D },
	0xfdc5, { 0xE6, 0xBE, 0x9D },
	0xfdc6, { 0xEE, 0x88, 0xBB },
	0xfdc7, { 0xE6, 0xBB, 0xBA },
	0xfdc8, { 0xEE, 0x88, 0xBD },
	0xfdc9, { 0xEE, 0x88, 0xBE },
	0xfdca, { 0xE4, 0x95, 0x95 },
	0xfdcb, { 0xE9, 0x8F, 0xB0 },
	0xfdcc, { 0xE6, 0xBD, 0x84 },
	0xfdcd, { 0xE6, 0xBD, 0x9C },
	0xfdce, { 0xE3, 0xB5, 0x8E },
	0xfdcf, { 0xE6, 0xBD, 0xB4 },
	0xfdd0, { 0xEE, 0x89, 0x85 },
	0xfdd1, { 0xE3, 0xB4, 0xBB },
	0xfdd2, { 0xE6, 0xBE, 0x9F },
	0xfdd3, { 0xEE, 0x89, 0x88 },
	0xfdd4, { 0xE6, 0xBF, 0x93 },
	0xfdd5, { 0xEE, 0x89, 0x8A },
	0xfdd6, { 0xEE, 0x89, 0x8B },
	0xfdd7, { 0xEE, 0x89, 0x8C },
	0xfdd8, { 0xEE, 0x89, 0x8D },
	0xfdd9, { 0xEE, 0x89, 0x8E },
	0xfdda, { 0xEE, 0x89, 0x8F },
	0xfddb, { 0xE5, 0x87, 0x9F },
	0xfddc, { 0xEE, 0x89, 0x91 },
	0xfddd, { 0xEE, 0x89, 0x92 },
	0xfdde, { 0xEE, 0x89, 0x93 },
	0xfddf, { 0xEE, 0x89, 0x94 },
	0xfde0, { 0xE7, 0x81, 0x8B },
	0xfde1, { 0xE7, 0x81, 0xBE },
	0xfde2, { 0xE7, 0x82, 0xA7 },
	0xfde3, { 0xE7, 0x82, 0x81 },
	0xfde4, { 0xE7, 0x83, 0x8C },
	0xfde5, { 0xE7, 0x83, 0x95 },
	0xfde6, { 0xE7, 0x83, 0x96 },
	0xfde7, { 0xE7, 0x83, 0x9F },
	0xfde8, { 0xE4, 0x84, 0x84 },
	0xfde9, { 0xE3, 0xB7, 0xA8 },
	0xfdea, { 0xE7, 0x86, 0xB4 },
	0xfdeb, { 0xE7, 0x86, 0x96 },
	0xfdec, { 0xEE, 0x89, 0xA1 },
	0xfded, { 0xE7, 0x84, 0xAB },
	0xfdee, { 0xE7, 0x85, 0x85 },
	0xfdef, { 0xE5, 0xAA, 0x88 },
	0xfdf0, { 0xE7, 0x85, 0x8A },
	0xfdf2, { 0xE5, 0xB2, 0x9C },
	0xfdf3, { 0xEE, 0x89, 0xA8 },
	0xfdf4, { 0xE7, 0x85, 0x8F },
	0xfdf5, { 0xE9, 0x8D, 0xA2 },
	0xfdf6, { 0xEE, 0x89, 0xAB },
	0xfdf7, { 0xE7, 0x84, 0xAC },
	0xfdf8, { 0xEE, 0x89, 0xAD },
	0xfdf9, { 0xEE, 0x89, 0xAE },
	0xfdfa, { 0xEE, 0x89, 0xAF },
	0xfdfb, { 0xE7, 0x86, 0xBA },
	0xfdfc, { 0xEE, 0x89, 0xB1 },
	0xfdfd, { 0xE7, 0x82, 0xBD },
	0xfdfe, { 0xE7, 0x88, 0x8E },
	0xfe40, { 0xE9, 0x91, 0x82 },
	0xfe41, { 0xE7, 0x88, 0x95 },
	0xfe42, { 0xE5, 0xA4, 0x91 },
	0xfe43, { 0xE9, 0x91, 0x83 },
	0xfe44, { 0xE7, 0x88, 0xA4 },
	0xfe45, { 0xE9, 0x8D, 0x81 },
	0xfe46, { 0xEE, 0x89, 0xBA },
	0xfe47, { 0xE7, 0x88, 0xAE },
	0xfe48, { 0xE7, 0x89, 0x80 },
	0xfe49, { 0xEE, 0x89, 0xBD },
	0xfe4a, { 0xE6, 0xA2, 0xBD },
	0xfe4b, { 0xE7, 0x89, 0x95 },
	0xfe4c, { 0xE7, 0x89, 0x97 },
	0xfe4d, { 0xE3, 0xB9, 0x95 },
	0xfe4e, { 0xEE, 0x8A, 0x82 },
	0xfe4f, { 0xE6, 0xA0, 0x8D },
	0xfe50, { 0xE6, 0xBC, 0xBD },
	0xfe51, { 0xE7, 0x8A, 0x82 },
	0xfe53, { 0xE7, 0x8C, 0xAB },
	0xfe54, { 0xEE, 0x8A, 0x88 },
	0xfe55, { 0xEE, 0x8A, 0x89 },
	0xfe56, { 0xE4, 0xA3, 0xAD },
	0xfe57, { 0xEE, 0x8A, 0x8B },
	0xfe58, { 0xE7, 0x8C, 0xA8 },
	0xfe59, { 0xE7, 0x8C, 0xAE },
	0xfe5a, { 0xE7, 0x8F, 0x8F },
	0xfe5b, { 0xE7, 0x8E, 0xAA },
	0xfe5c, { 0xEE, 0x8A, 0x90 },
	0xfe5d, { 0xEE, 0x8A, 0x91 },
	0xfe5e, { 0xE7, 0x8F, 0x89 },
	0xfe5f, { 0xE7, 0x91, 0x89 },
	0xfe60, { 0xEE, 0x8A, 0x94 },
	0xfe61, { 0xEE, 0x8A, 0x95 },
	0xfe62, { 0xEE, 0x8A, 0x96 },
	0xfe63, { 0xE6, 0x98, 0xA3 },
	0xfe64, { 0xE3, 0x9B, 0x85 },
	0xfe65, { 0xEE, 0x8A, 0x99 },
	0xfe66, { 0xEE, 0x8A, 0x9A },
	0xfe67, { 0xEE, 0x8A, 0x9B },
	0xfe68, { 0xE7, 0x8F, 0xB7 },
	0xfe69, { 0xE7, 0x90, 0x95 },
	0xfe6a, { 0xE6, 0xA4, 0x83 },
	0xfe6b, { 0xEE, 0x8A, 0x9F },
	0xfe6c, { 0xE7, 0x90, 0xB9 },
	0xfe6d, { 0xEE, 0x8A, 0xA1 },
	0xfe6e, { 0xE3, 0xBB, 0x97 },
	0xfe70, { 0xEE, 0x8A, 0xA4 },
	0xfe71, { 0xE7, 0x91, 0xA0 },
	0xfe72, { 0xEE, 0x8A, 0xA6 },
	0xfe73, { 0xE7, 0x91, 0x87 },
	0xfe74, { 0xE7, 0x8F, 0xA4 },
	0xfe75, { 0xE7, 0x91, 0xB6 },
	0xfe76, { 0xE8, 0x8E, 0xB9 },
	0xfe77, { 0xE7, 0x91, 0xAC },
	0xfe78, { 0xE3, 0x9C, 0xB0 },
	0xfe79, { 0xE7, 0x91, 0xB4 },
	0xfe7a, { 0xE9, 0x8F, 0xB1 },
	0xfe7b, { 0xE6, 0xA8, 0xAC },
	0xfe7c, { 0xE7, 0x92, 0x82 },
	0xfe7d, { 0xE4, 0xA5, 0x93 },
	0xfe7e, { 0xEE, 0x8A, 0xB2 },
	0xfea1, { 0xEE, 0x8A, 0xB3 },
	0xfea2, { 0xEE, 0x8A, 0xB4 },
	0xfea3, { 0xEE, 0x8A, 0xB5 },
	0xfea4, { 0xE5, 0xAD, 0x86 },
	0xfea5, { 0xEE, 0x8A, 0xB7 },
	0xfea6, { 0xEE, 0x8A, 0xB8 },
	0xfea7, { 0xE7, 0x93, 0x88 },
	0xfea8, { 0xEE, 0x8A, 0xBA },
	0xfea9, { 0xE7, 0x94, 0x8E },
	0xfeab, { 0xE7, 0x94, 0x9E },
	0xfeac, { 0xEE, 0x8A, 0xBE },
	0xfead, { 0xEE, 0x8A, 0xBF },
	0xfeae, { 0xE5, 0xAF, 0x97 },
	0xfeaf, { 0xEE, 0x8B, 0x81 },
	0xfeb0, { 0xE9, 0x8E, 0x85 },
	0xfeb1, { 0xE7, 0x95, 0x8D },
	0xfeb2, { 0xE7, 0x95, 0x8A },
	0xfeb3, { 0xE7, 0x95, 0xA7 },
	0xfeb4, { 0xE7, 0x95, 0xAE },
	0xfeb5, { 0xEE, 0x8B, 0x87 },
	0xfeb6, { 0xE3, 0xBC, 0x84 },
	0xfeb7, { 0xEE, 0x8B, 0x89 },
	0xfeb8, { 0xE7, 0x96, 0x8E },
	0xfeb9, { 0xE7, 0x91, 0x9D },
	0xfeba, { 0xE7, 0x96, 0x9E },
	0xfebb, { 0xE7, 0x96, 0xB4 },
	0xfebc, { 0xE7, 0x98, 0x82 },
	0xfebd, { 0xE7, 0x98, 0xAC },
	0xfebe, { 0xE7, 0x99, 0x91 },
	0xfebf, { 0xE7, 0x99, 0x8F },
	0xfec0, { 0xE7, 0x99, 0xAF },
	0xfec1, { 0xE7, 0x99, 0xB6 },
	0xfec2, { 0xEE, 0x8B, 0x94 },
	0xfec3, { 0xE7, 0x9A, 0x90 },
	0xfec4, { 0xE8, 0x87, 0xAF },
	0xfec5, { 0xE3, 0x9F, 0xB8 },
	0xfec6, { 0xEE, 0x8B, 0x98 },
	0xfec7, { 0xEE, 0x8B, 0x99 },
	0xfec8, { 0xE7, 0x9A, 0xA1 },
	0xfec9, { 0xE7, 0x9A, 0xA5 },
	0xfeca, { 0xE7, 0x9A, 0xB7 },
	0xfecb, { 0xE7, 0x9B, 0x8C },
	0xfecc, { 0xEE, 0x8B, 0x9E },
	0xfecd, { 0xE8, 0x91, 0xA2 },
	0xfece, { 0xEE, 0x8B, 0xA0 },
	0xfecf, { 0xEE, 0x8B, 0xA1 },
	0xfed0, { 0xEE, 0x8B, 0xA2 },
	0xfed1, { 0xE7, 0x9C, 0x9E },
	0xfed2, { 0xE7, 0x9C, 0xA6 },
	0xfed3, { 0xE7, 0x9D, 0x80 },
	0xfed4, { 0xE6, 0x92, 0xAF },
	0xfed5, { 0xEE, 0x8B, 0xA7 },
	0xfed6, { 0xE7, 0x9D, 0x98 },
	0xfed7, { 0xEE, 0x8B, 0xA9 },
	0xfed8, { 0xE7, 0x9E, 0xAF },
	0xfed9, { 0xEE, 0x8B, 0xAB },
	0xfeda, { 0xEE, 0x8B, 0xAC },
	0xfedb, { 0xEE, 0x8B, 0xAD },
	0xfedc, { 0xE7, 0x9F, 0xB4 },
	0xfede, { 0xEE, 0x8B, 0xB0 },
	0xfedf, { 0xEE, 0x8B, 0xB1 },
	0xfee0, { 0xE6, 0xA3, 0x8A },
	0xfee1, { 0xE7, 0xA2, 0xAF },
	0xfee2, { 0xE7, 0xA3, 0x87 },
	0xfee3, { 0xE7, 0xA3, 0x93 },
	0xfee4, { 0xE9, 0x9A, 0xA5 },
	0xfee5, { 0xE7, 0xA4, 0xAE },
	0xfee6, { 0xEE, 0x8B, 0xB8 },
	0xfee7, { 0xE7, 0xA3, 0x97 },
	0xfee8, { 0xE7, 0xA4, 0xB4 },
	0xfee9, { 0xE7, 0xA2, 0xB1 },
	0xfeea, { 0xEE, 0x8B, 0xBC },
	0xfeeb, { 0xE8, 0xBE, 0xB8 },
	0xfeec, { 0xE8, 0xA2, 0x84 },
	0xfeed, { 0xEE, 0x8B, 0xBF },
	0xfeee, { 0xEE, 0x8C, 0x80 },
	0xfeef, { 0xEE, 0x8C, 0x81 },
	0xfef0, { 0xE7, 0xA6, 0x86 },
	0xfef1, { 0xE8, 0xA4, 0x80 },
	0xfef2, { 0xE6, 0xA4, 0x82 },
	0xfef3, { 0xE7, 0xA6, 0x80 },
	0xfef4, { 0xEE, 0x8C, 0x86 },
	0xfef5, { 0xE7, 0xA6, 0x9D },
	0xfef6, { 0xEE, 0x8C, 0x88 },
	0xfef7, { 0xE7, 0xA4, 0xBC },
	0xfef8, { 0xE7, 0xA6, 0xA9 },
	0xfef9, { 0xE6, 0xB8, 0xAA },
	0xfefa, { 0xEE, 0x8C, 0x8C },
	0xfefb, { 0xE3, 0xBA, 0xA8 },
	0xfefc, { 0xE7, 0xA7, 0x86 },
	0xfefd, { 0xEE, 0x8C, 0x8F },
	0xfefe, { 0xE7, 0xA7, 0x94 }
};

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_KICONV_CP950HKSCS_UTF8_H */
