/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 * Copyright 2016 Nexenta Systems, Inc.  All rights reserved.
 */

#ifndef	_SYS_FM_IO_SCSI_H
#define	_SYS_FM_IO_SCSI_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * The following ereports are generated by the userland disk-transport module in
 * response to errors reported by the disks.
 */
#define	SCSI_ERROR_CLASS		"io.scsi"

#define	SCSI_DISK_CLASS			"disk"

#define	FM_EREPORT_SCSI_PREDFAIL	"predictive-failure"
#define	FM_EREPORT_PAYLOAD_SCSI_ASC	"additional-sense-code"
#define	FM_EREPORT_PAYLOAD_SCSI_ASCQ	"additional-sense-code-qualifier"

#define	FM_EREPORT_SCSI_OVERTEMP		"over-temperature"
#define	FM_EREPORT_PAYLOAD_SCSI_CURTEMP		"current-temperature"
#define	FM_EREPORT_PAYLOAD_SCSI_THRESHTEMP	"threshold-temperature"

#define	FM_EREPORT_SCSI_SSMWEAROUT		"ssm-wearout"
#define	FM_EREPORT_PAYLOAD_SCSI_CURSSMWEAROUT	"current-ssm-wearout"
#define	FM_EREPORT_PAYLOAD_SCSI_THRSHSSMWEAROUT	"threshold-ssm-wearout"

#define	FM_EREPORT_SCSI_TESTFAIL		"self-test-failure"
#define	FM_EREPORT_PAYLOAD_SCSI_RESULTCODE	"result-code"
#define	FM_EREPORT_PAYLOAD_SCSI_ADDRESS		"address"
#define	FM_EREPORT_PAYLOAD_SCSI_TIMESTAMP	"timestamp"
#define	FM_EREPORT_PAYLOAD_SCSI_SEGMENT		"segment"

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_FM_IO_SCSI_H */
