/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_1394_IEEE1394_H
#define	_SYS_1394_IEEE1394_H

/*
 * ieee1394.h
 *    This file contains various defines that go with IEEE 1394
 */

#ifdef	__cplusplus
extern "C" {
#endif


/*
 * IEEE1394_MAX_NODES defines the maximum number of nodes
 * that can be addressed on a single 1394 bus.  There are
 * a 63 physical nodes that can be present and 1 broadcast
 * node id.  The range of 1394 nodeid's are
 * 0 ... (IEEE1394_MAX_NODES - 1)
 */
#define	IEEE1394_MAX_NODES		64

/* The node id for broadcast writes */
#define	IEEE1394_BROADCAST_NODEID	63

/* Maximum number of ports per node */
#define	IEEE1394_MAX_NUM_PORTS		16

#define	IEEE1394_BUS_NUM_MASK		0x0000FFC0
#define	IEEE1394_LOCAL_BUS		0x3FF

#define	IEEE1394_NODE_NUM_MASK		0x0000003F
#define	IEEE1394_NODE_NUM(DATA)		((DATA) & IEEE1394_NODE_NUM_MASK)

#define	IEEE1394_BUS_CYCLES_PER_SEC	8000

/* IEEE 1394 Bus related definitions */
#define	IEEE1394_ADDR_NODE_ID_MASK	0xFFFF000000000000
#define	IEEE1394_ADDR_NODE_ID_SHIFT	48
#define	IEEE1394_ADDR_NODE_ID(ADDR)				\
	(((ADDR) & IEEE1394_ADDR_NODE_ID_MASK) >>		\
	    IEEE1394_ADDR_NODE_ID_SHIFT)

#define	IEEE1394_ADDR_BUS_ID_MASK	0xFFC0000000000000
#define	IEEE1394_ADDR_BUS_ID_SHIFT	54
#define	IEEE1394_ADDR_BUS_ID(ADDR)				\
	(((ADDR) & IEEE1394_ADDR_BUS_ID_MASK) >>		\
	    IEEE1394_ADDR_BUS_ID_SHIFT)

#define	IEEE1394_ADDR_PHY_ID_MASK	0x003F000000000000
#define	IEEE1394_ADDR_PHY_ID_SHIFT	48
#define	IEEE1394_ADDR_PHY_ID(ADDR)				\
	(((ADDR) & IEEE1394_ADDR_PHY_ID_MASK) >>		\
	    IEEE1394_ADDR_PHY_ID_SHIFT)

#define	IEEE1394_ADDR_OFFSET_MASK	0x0000FFFFFFFFFFFF

/* IEEE 1394 data sizes */
#define	IEEE1394_QUADLET		(sizeof (uint32_t))
#define	IEEE1394_OCTLET			(sizeof (uint64_t))

/* Still need to look at these */
/* TCODES - packet transaction codes (as defined in 1394-1995 6.2.4.5) */
#define	IEEE1394_TCODE_WRITE_QUADLET		0x0
#define	IEEE1394_TCODE_WRITE_BLOCK		0x1
#define	IEEE1394_TCODE_WRITE_RESP		0x2
#define	IEEE1394_TCODE_RES1			0x3
#define	IEEE1394_TCODE_READ_QUADLET		0x4
#define	IEEE1394_TCODE_READ_BLOCK		0x5
#define	IEEE1394_TCODE_READ_QUADLET_RESP	0x6
#define	IEEE1394_TCODE_READ_BLOCK_RESP		0x7
#define	IEEE1394_TCODE_CYCLE_START		0x8
#define	IEEE1394_TCODE_LOCK			0x9
#define	IEEE1394_TCODE_ISOCH			0xA
#define	IEEE1394_TCODE_LOCK_RESP		0xB
#define	IEEE1394_TCODE_RES2			0xC
#define	IEEE1394_TCODE_RES3			0xD
#define	IEEE1394_TCODE_PHY			0xE
#define	IEEE1394_TCODE_RES4			0xF

#define	IEEE1394_RESP_COMPLETE			0x0
#define	IEEE1394_RESP_CONFLICT_ERROR		0x4
#define	IEEE1394_RESP_DATA_ERROR		0x5
#define	IEEE1394_RESP_TYPE_ERROR		0x6
#define	IEEE1394_RESP_ADDRESS_ERROR		0x7

#define	IEEE1394_ISOCH_HDR_QUAD_SZ	3

/* Self ID packet definitions */
#define	IEEE1394_SELFID_PCKT_ID_MASK	0xC0000000
#define	IEEE1394_SELFID_PCKT_ID_SHIFT	30
#define	IEEE1394_SELFID_PCKT_ID_VALID	0x2
#define	IEEE1394_SELFID_ISVALID(S_PKT)				\
	(~((S_PKT)->spkt_data ^ (S_PKT)->spkt_inverse) ? 0 : 1)

#define	IEEE1394_SELFID_PHYID_MASK	0x3F000000
#define	IEEE1394_SELFID_PHYID_SHIFT	24
#define	IEEE1394_SELFID_PHYID(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_PHYID_MASK) >>	\
	    IEEE1394_SELFID_PHYID_SHIFT)

/* SelfID PKT #0 */
#define	IEEE1394_SELFID_L_MASK		0x00400000
#define	IEEE1394_SELFID_L_SHIFT		22
#define	IEEE1394_SELFID_ISLINKON(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_L_MASK) >>	\
	    IEEE1394_SELFID_L_SHIFT)

#define	IEEE1394_SELFID_GAP_CNT_MASK	0x003F0000
#define	IEEE1394_SELFID_GAP_CNT_SHIFT	16
#define	IEEE1394_SELFID_GAP_CNT(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_GAP_CNT_MASK) >>	\
	    IEEE1394_SELFID_GAP_CNT_SHIFT)

#define	IEEE1394_SELFID_SP_MASK		0x0000C000
#define	IEEE1394_SELFID_SP_SHIFT	14

#define	IEEE1394_SELFID_DEL_MASK	(0x00003000)
#define	IEEE1394_SELFID_DEL_SHIFT	12
#define	IEEE1394_SELFID_DELAY(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_DEL_MASK) >>	\
	    IEEE1394_SELFID_DEL_SHIFT)

#define	IEEE1394_SELFID_C_MASK		0x00000800
#define	IEEE1394_SELFID_C_SHIFT		11
#define	IEEE1394_SELFID_ISCONTENDER(S_PKT)			\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_C_MASK) >>	\
	    IEEE1394_SELFID_C_SHIFT)

#define	IEEE1394_SELFID_PWR_MASK	0x00000700
#define	IEEE1394_SELFID_PWR_SHIFT	8
#define	IEEE1394_SELFID_POWER(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_PWR_MASK) >>	\
	    IEEE1394_SELFID_PWR_SHIFT)

#define	IEEE1394_SELFID_PORT_TO_CHILD		0x3
#define	IEEE1394_SELFID_PORT_TO_PARENT		0x2
#define	IEEE1394_SELFID_PORT_NOT_CONNECTED	0x1
#define	IEEE1394_SELFID_PORT_NO_PORT		0x0

#define	IEEE1394_SELFID_I_MASK		0x00000002
#define	IEEE1394_SELFID_I_SHIFT		1
#define	IEEE1394_SELFID_INITIATED_RESET(S_PKT)			\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_I_MASK) >>	\
	    IEEE1394_SELFID_I_SHIFT)

#define	IEEE1394_SELFID_M_MASK		0x00000001
#define	IEEE1394_SELFID_M_SHIFT		0
#define	IEEE1394_SELFID_ISMORE(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_M_MASK) >>	\
	    IEEE1394_SELFID_M_SHIFT)

#define	IEEE1394_SELFID_PORT_OFFSET_FIRST	6

/* SelfID PKT #1 (n=0) */
#define	IEEE1394_SELFID_N_MASK		0x00700000
#define	IEEE1394_SELFID_N_SHIFT		20
#define	IEEE1394_SELFID_PKT_NUM(S_PKT)				\
	(((S_PKT)->spkt_data & IEEE1394_SELFID_N_MASK) >>	\
	    IEEE1394_SELFID_N_SHIFT)

#define	IEEE1394_SELFID_PORT_OFFSET_OTHERS	16

/* PHY Config Packet definitions */
#define	IEEE1394_PHY_CONFIG_T_BIT_MASK		0x00400000
#define	IEEE1394_PHY_CONFIG_T_BIT_SHIFT		22
#define	IEEE1394_PHY_CONFIG_GAP_CNT_MASK	0x003F0000
#define	IEEE1394_PHY_CONFIG_GAP_CNT_SHIFT	16

#define	IEEE1394_PHY_CONFIG_R_BIT_MASK		0x00800000
#define	IEEE1394_PHY_CONFIG_R_BIT_SHIFT		23
#define	IEEE1394_PHY_CONFIG_ROOT_HOLD_MASK	0x3F000000
#define	IEEE1394_PHY_CONFIG_ROOT_HOLD_SHIFT	24


/*
 * CSR Registers and register fields.
 */
/* CSR Register Addresses (IEEE1394-1995 8.3.2.2) */
#define	IEEE1394_CSR_STATE_CLEAR	0xFFFFF0000000
#define	IEEE1394_CSR_STATE_SET		0xFFFFF0000004
#define	IEEE1394_CSR_NODE_IDS		0xFFFFF0000008
#define	IEEE1394_CSR_RESET_START	0xFFFFF000000C
#define	IEEE1394_CSR_SPLIT_TIMEOUT_HI	0xFFFFF0000018
#define	IEEE1394_CSR_SPLIT_TIMEOUT_LO	0xFFFFF000001C
#define	IEEE1394_CSR_ARG_HI		0xFFFFF0000020
#define	IEEE1394_CSR_ARG_LO		0xFFFFF0000024
#define	IEEE1394_CSR_TEST_START		0xFFFFF0000028
#define	IEEE1394_CSR_TEST_STATUS	0xFFFFF000002C

/* Optional Register Addresses */
#define	IEEE1394_CSR_INTERRUPT_TARGET	0xFFFFF0000050
#define	IEEE1394_CSR_INTERRUPT_MASK	0xFFFFF0000054
#define	IEEE1394_CSR_CLOCK_VALUE	0xFFFFF0000058
#define	IEEE1394_CSR_CLOCK_VALUE_SZ	0x28
#define	IEEE1394_CSR_MESSAGE_REQUEST	0xFFFFF0000080
#define	IEEE1394_CSR_MESSAGE_REQUEST_SZ	0x80

/* Serial Bus CSR Register Addresss (IEEE1394-1995 8.3.2.3) */
#define	IEEE1394_SCSR_CYCLE_TIME	0xFFFFF0000200
#define	IEEE1394_SCSR_BUS_TIME		0xFFFFF0000204
#define	IEEE1394_SCSR_PWRFAIL_IMMINENT	0xFFFFF0000208
#define	IEEE1394_SCSR_PWRSRC		0xFFFFF000020C
#define	IEEE1394_SCSR_BUSY_TIMEOUT	0xFFFFF0000210
#define	IEEE1394_SCSR_BUSMGR_ID		0xFFFFF000021C
#define	IEEE1394_SCSR_BANDWIDTH_AVAIL	0xFFFFF0000220
#define	IEEE1394_SCSR_CHANS_AVAIL_HI	0xFFFFF0000224
#define	IEEE1394_SCSR_CHANS_AVAIL_LO	0xFFFFF0000228

/* Config ROM Address */
#define	IEEE1394_CONFIG_ROM_ADDR	0xFFFFF0000400
#define	IEEE1394_CONFIG_ROM_SZ		0x400
#define	IEEE1394_CONFIG_ROM_QUAD_SZ	0x100

/*  Unit CSR Register Addresses */
#define	IEEE1394_UCSR_TOPOLOGY_MAP	0xFFFFF0001000
#define	IEEE1394_UCSR_TOPOLOGY_MAP_SZ	0x400
#define	IEEE1394_UCSR_SPEED_MAP		0xFFFFF0002000
#define	IEEE1394_UCSR_SPEED_MAP_SZ	0x1000

/* Boundary for "reserved" CSR registers */
#define	IEEE1394_UCSR_RESERVED_BOUNDARY	0xFFFFF0010000

#define	IEEE1394_CSR_OFFSET_MASK	0x00000000FFFF

/* 1394 Bus Speeds */
#define	IEEE1394_S100			0
#define	IEEE1394_S200			1
#define	IEEE1394_S400			2
#define	IEEE1394_S800			3
#define	IEEE1394_S1600			4
#define	IEEE1394_S3200			5

/* IEEE 1394 Bandwidth bounds */
#define	IEEE1394_BANDWIDTH_MIN		0
#define	IEEE1394_BANDWIDTH_MAX		0x1333

/* Speed Map specific defines */
#define	IEEE1394_SPEED_MAP_CRC_LEN	0x03F1
#define	IEEE1394_SPEED_MAP_LEN_MASK	0x0000FFFF
#define	IEEE1394_SPEED_MAP_LEN_SHIFT	16
#define	IEEE1394_SPEED_MAP_DATA_LEN	0x0FBE

/* Topology Map specific defines */
#define	IEEE1394_TOP_MAP_LEN_MASK	0x0000FFFF
#define	IEEE1394_TOP_MAP_LEN_SHIFT	16

/* Config ROM specific defines */
#define	IEEE1394_CFG_ROM_CRC_VALUE_MASK	0x0000FFFF
#define	IEEE1394_CFG_ROM_CRC_LEN_SHIFT	16
#define	IEEE1394_CFG_ROM_CRC_LEN_MASK	0xFF
#define	IEEE1394_CFG_ROM_LEN_SHIFT	16

/* CRC16 defines */
#define	IEEE1394_CRC16_MASK		0xFFFF

/* Bit positions in the STATE register */
#define	IEEE1394_CSR_STATE_CMSTR	0x00000100
#define	IEEE1394_CSR_STATE_DREQ		0x00000040
#define	IEEE1394_CSR_STATE_ABDICATE	0x00000400

/* Positions in the BUS_INFO_BLOCK */
#define	IEEE1394_BIB_LNK_SPD_MASK	0x00000007
#define	IEEE1394_BIB_LNK_SPD_SHIFT	0
#define	IEEE1394_BIB_GEN_MASK		0x000000F0
#define	IEEE1394_BIB_GEN_SHIFT		4
#define	IEEE1394_BIB_MROM_MASK		0x00000300
#define	IEEE1394_BIB_MROM_SHIFT		8
#define	IEEE1394_BIB_IRMC_MASK		0x80000000
#define	IEEE1394_BIB_IRMC_SHIFT		31
#define	IEEE1394_BIB_BMC_MASK		0x10000000
#define	IEEE1394_BIB_BMC_SHIFT		28
#define	IEEE1394_BIB_CMC_MASK		0x40000000
#define	IEEE1394_BIB_CMC_SHIFT		30
#define	IEEE1394_BIB_MAXREC_MASK	0x0000F000
#define	IEEE1394_BIB_MAXREC_SHIFT	12

#define	IEEE1394_BIB_QUAD_SZ		5
#define	IEEE1394_BIB_SZ			0x14

/* Bus Manager specific defines */
#define	IEEE1394_BM_IRM_TIMEOUT		625000
#define	IEEE1394_BM_INCUMBENT_TIMEOUT	125000
#ifdef __cplusplus
}
#endif

#endif	/* _SYS_1394_IEEE1394_H */
