/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2011 Nexenta Systems, Inc.  All rights reserved.
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SMBSRV_CP_UNICODE_H
#define	_SMBSRV_CP_UNICODE_H

#include <smbsrv/string.h>

#ifdef __cplusplus
extern "C" {
#endif

struct unicode_cp {
	smb_wchar_t val;
	smb_wchar_t ctype;
	smb_wchar_t lower;
	smb_wchar_t upper;
};

const struct unicode_cp a_unicode[] = {
	{ 0x0000, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0001, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0002, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0003, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0004, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0005, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0006, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0007, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0008, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0009, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x000A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x000B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x000C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x000D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x000E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x000F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0010, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0011, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0012, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0013, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0014, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0015, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0016, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0017, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0018, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0019, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x001A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x001B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x001C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x001D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x001E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x001F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0020, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0021, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0022, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0023, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0024, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0025, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0026, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0027, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0028, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0029, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x002A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x002B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x002C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x002D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x002E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x002F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0030, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0031, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0032, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0033, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0034, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0035, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0036, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0037, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0038, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0039, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x003A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x003B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x003C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x003D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x003E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x003F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0040, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0041, CODEPAGE_ISUPPER, 0x0061, 0xFFFF },
	{ 0x0042, CODEPAGE_ISUPPER, 0x0062, 0xFFFF },
	{ 0x0043, CODEPAGE_ISUPPER, 0x0063, 0xFFFF },
	{ 0x0044, CODEPAGE_ISUPPER, 0x0064, 0xFFFF },
	{ 0x0045, CODEPAGE_ISUPPER, 0x0065, 0xFFFF },
	{ 0x0046, CODEPAGE_ISUPPER, 0x0066, 0xFFFF },
	{ 0x0047, CODEPAGE_ISUPPER, 0x0067, 0xFFFF },
	{ 0x0048, CODEPAGE_ISUPPER, 0x0068, 0xFFFF },
	{ 0x0049, CODEPAGE_ISUPPER, 0x0069, 0xFFFF },
	{ 0x004A, CODEPAGE_ISUPPER, 0x006A, 0xFFFF },
	{ 0x004B, CODEPAGE_ISUPPER, 0x006B, 0xFFFF },
	{ 0x004C, CODEPAGE_ISUPPER, 0x006C, 0xFFFF },
	{ 0x004D, CODEPAGE_ISUPPER, 0x006D, 0xFFFF },
	{ 0x004E, CODEPAGE_ISUPPER, 0x006E, 0xFFFF },
	{ 0x004F, CODEPAGE_ISUPPER, 0x006F, 0xFFFF },
	{ 0x0050, CODEPAGE_ISUPPER, 0x0070, 0xFFFF },
	{ 0x0051, CODEPAGE_ISUPPER, 0x0071, 0xFFFF },
	{ 0x0052, CODEPAGE_ISUPPER, 0x0072, 0xFFFF },
	{ 0x0053, CODEPAGE_ISUPPER, 0x0073, 0xFFFF },
	{ 0x0054, CODEPAGE_ISUPPER, 0x0074, 0xFFFF },
	{ 0x0055, CODEPAGE_ISUPPER, 0x0075, 0xFFFF },
	{ 0x0056, CODEPAGE_ISUPPER, 0x0076, 0xFFFF },
	{ 0x0057, CODEPAGE_ISUPPER, 0x0077, 0xFFFF },
	{ 0x0058, CODEPAGE_ISUPPER, 0x0078, 0xFFFF },
	{ 0x0059, CODEPAGE_ISUPPER, 0x0079, 0xFFFF },
	{ 0x005A, CODEPAGE_ISUPPER, 0x007A, 0xFFFF },
	{ 0x005B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x005C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x005D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x005E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x005F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0060, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0061, CODEPAGE_ISLOWER, 0xFFFF, 0x0041 },
	{ 0x0062, CODEPAGE_ISLOWER, 0xFFFF, 0x0042 },
	{ 0x0063, CODEPAGE_ISLOWER, 0xFFFF, 0x0043 },
	{ 0x0064, CODEPAGE_ISLOWER, 0xFFFF, 0x0044 },
	{ 0x0065, CODEPAGE_ISLOWER, 0xFFFF, 0x0045 },
	{ 0x0066, CODEPAGE_ISLOWER, 0xFFFF, 0x0046 },
	{ 0x0067, CODEPAGE_ISLOWER, 0xFFFF, 0x0047 },
	{ 0x0068, CODEPAGE_ISLOWER, 0xFFFF, 0x0048 },
	{ 0x0069, CODEPAGE_ISLOWER, 0xFFFF, 0x0049 },
	{ 0x006A, CODEPAGE_ISLOWER, 0xFFFF, 0x004A },
	{ 0x006B, CODEPAGE_ISLOWER, 0xFFFF, 0x004B },
	{ 0x006C, CODEPAGE_ISLOWER, 0xFFFF, 0x004C },
	{ 0x006D, CODEPAGE_ISLOWER, 0xFFFF, 0x004D },
	{ 0x006E, CODEPAGE_ISLOWER, 0xFFFF, 0x004E },
	{ 0x006F, CODEPAGE_ISLOWER, 0xFFFF, 0x004F },
	{ 0x0070, CODEPAGE_ISLOWER, 0xFFFF, 0x0050 },
	{ 0x0071, CODEPAGE_ISLOWER, 0xFFFF, 0x0051 },
	{ 0x0072, CODEPAGE_ISLOWER, 0xFFFF, 0x0052 },
	{ 0x0073, CODEPAGE_ISLOWER, 0xFFFF, 0x0053 },
	{ 0x0074, CODEPAGE_ISLOWER, 0xFFFF, 0x0054 },
	{ 0x0075, CODEPAGE_ISLOWER, 0xFFFF, 0x0055 },
	{ 0x0076, CODEPAGE_ISLOWER, 0xFFFF, 0x0056 },
	{ 0x0077, CODEPAGE_ISLOWER, 0xFFFF, 0x0057 },
	{ 0x0078, CODEPAGE_ISLOWER, 0xFFFF, 0x0058 },
	{ 0x0079, CODEPAGE_ISLOWER, 0xFFFF, 0x0059 },
	{ 0x007A, CODEPAGE_ISLOWER, 0xFFFF, 0x005A },
	{ 0x007B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x007C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x007D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x007E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x007F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0080, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0081, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0082, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0083, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0084, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0085, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0086, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0087, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0088, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0089, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x008A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x008B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x008C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x008D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x008E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x008F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0090, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0091, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0092, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0093, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0094, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0095, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0096, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0097, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0098, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0099, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x009A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x009B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x009C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x009D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x009E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x009F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00AA, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x00AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x00B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00BA, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x00BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00C0, CODEPAGE_ISUPPER, 0x00E0, 0xFFFF },
	{ 0x00C1, CODEPAGE_ISUPPER, 0x00E1, 0xFFFF },
	{ 0x00C2, CODEPAGE_ISUPPER, 0x00E2, 0xFFFF },
	{ 0x00C3, CODEPAGE_ISUPPER, 0x00E3, 0xFFFF },
	{ 0x00C4, CODEPAGE_ISUPPER, 0x00E4, 0xFFFF },
	{ 0x00C5, CODEPAGE_ISUPPER, 0x00E5, 0xFFFF },
	{ 0x00C6, CODEPAGE_ISUPPER, 0x00E6, 0xFFFF },
	{ 0x00C7, CODEPAGE_ISUPPER, 0x00E7, 0xFFFF },
	{ 0x00C8, CODEPAGE_ISUPPER, 0x00E8, 0xFFFF },
	{ 0x00C9, CODEPAGE_ISUPPER, 0x00E9, 0xFFFF },
	{ 0x00CA, CODEPAGE_ISUPPER, 0x00EA, 0xFFFF },
	{ 0x00CB, CODEPAGE_ISUPPER, 0x00EB, 0xFFFF },
	{ 0x00CC, CODEPAGE_ISUPPER, 0x00EC, 0xFFFF },
	{ 0x00CD, CODEPAGE_ISUPPER, 0x00ED, 0xFFFF },
	{ 0x00CE, CODEPAGE_ISUPPER, 0x00EE, 0xFFFF },
	{ 0x00CF, CODEPAGE_ISUPPER, 0x00EF, 0xFFFF },
	{ 0x00D0, CODEPAGE_ISUPPER, 0x00F0, 0xFFFF },
	{ 0x00D1, CODEPAGE_ISUPPER, 0x00F1, 0xFFFF },
	{ 0x00D2, CODEPAGE_ISUPPER, 0x00F2, 0xFFFF },
	{ 0x00D3, CODEPAGE_ISUPPER, 0x00F3, 0xFFFF },
	{ 0x00D4, CODEPAGE_ISUPPER, 0x00F4, 0xFFFF },
	{ 0x00D5, CODEPAGE_ISUPPER, 0x00F5, 0xFFFF },
	{ 0x00D6, CODEPAGE_ISUPPER, 0x00F6, 0xFFFF },
	{ 0x00D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00D8, CODEPAGE_ISUPPER, 0x00F8, 0xFFFF },
	{ 0x00D9, CODEPAGE_ISUPPER, 0x00F9, 0xFFFF },
	{ 0x00DA, CODEPAGE_ISUPPER, 0x00FA, 0xFFFF },
	{ 0x00DB, CODEPAGE_ISUPPER, 0x00FB, 0xFFFF },
	{ 0x00DC, CODEPAGE_ISUPPER, 0x00FC, 0xFFFF },
	{ 0x00DD, CODEPAGE_ISUPPER, 0x00FD, 0xFFFF },
	{ 0x00DE, CODEPAGE_ISUPPER, 0x00FE, 0xFFFF },
	{ 0x00DF, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x00E0, CODEPAGE_ISLOWER, 0xFFFF, 0x00C0 },
	{ 0x00E1, CODEPAGE_ISLOWER, 0xFFFF, 0x00C1 },
	{ 0x00E2, CODEPAGE_ISLOWER, 0xFFFF, 0x00C2 },
	{ 0x00E3, CODEPAGE_ISLOWER, 0xFFFF, 0x00C3 },
	{ 0x00E4, CODEPAGE_ISLOWER, 0xFFFF, 0x00C4 },
	{ 0x00E5, CODEPAGE_ISLOWER, 0xFFFF, 0x00C5 },
	{ 0x00E6, CODEPAGE_ISLOWER, 0xFFFF, 0x00C6 },
	{ 0x00E7, CODEPAGE_ISLOWER, 0xFFFF, 0x00C7 },
	{ 0x00E8, CODEPAGE_ISLOWER, 0xFFFF, 0x00C8 },
	{ 0x00E9, CODEPAGE_ISLOWER, 0xFFFF, 0x00C9 },
	{ 0x00EA, CODEPAGE_ISLOWER, 0xFFFF, 0x00CA },
	{ 0x00EB, CODEPAGE_ISLOWER, 0xFFFF, 0x00CB },
	{ 0x00EC, CODEPAGE_ISLOWER, 0xFFFF, 0x00CC },
	{ 0x00ED, CODEPAGE_ISLOWER, 0xFFFF, 0x00CD },
	{ 0x00EE, CODEPAGE_ISLOWER, 0xFFFF, 0x00CE },
	{ 0x00EF, CODEPAGE_ISLOWER, 0xFFFF, 0x00CF },
	{ 0x00F0, CODEPAGE_ISLOWER, 0xFFFF, 0x00D0 },
	{ 0x00F1, CODEPAGE_ISLOWER, 0xFFFF, 0x00D1 },
	{ 0x00F2, CODEPAGE_ISLOWER, 0xFFFF, 0x00D2 },
	{ 0x00F3, CODEPAGE_ISLOWER, 0xFFFF, 0x00D3 },
	{ 0x00F4, CODEPAGE_ISLOWER, 0xFFFF, 0x00D4 },
	{ 0x00F5, CODEPAGE_ISLOWER, 0xFFFF, 0x00D5 },
	{ 0x00F6, CODEPAGE_ISLOWER, 0xFFFF, 0x00D6 },
	{ 0x00F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x00F8, CODEPAGE_ISLOWER, 0xFFFF, 0x00D8 },
	{ 0x00F9, CODEPAGE_ISLOWER, 0xFFFF, 0x00D9 },
	{ 0x00FA, CODEPAGE_ISLOWER, 0xFFFF, 0x00DA },
	{ 0x00FB, CODEPAGE_ISLOWER, 0xFFFF, 0x00DB },
	{ 0x00FC, CODEPAGE_ISLOWER, 0xFFFF, 0x00DC },
	{ 0x00FD, CODEPAGE_ISLOWER, 0xFFFF, 0x00DD },
	{ 0x00FE, CODEPAGE_ISLOWER, 0xFFFF, 0x00DE },
	{ 0x00FF, CODEPAGE_ISLOWER, 0xFFFF, 0x0178 },
	{ 0x0100, CODEPAGE_ISUPPER, 0x0101, 0xFFFF },
	{ 0x0101, CODEPAGE_ISLOWER, 0xFFFF, 0x0100 },
	{ 0x0102, CODEPAGE_ISUPPER, 0x0103, 0xFFFF },
	{ 0x0103, CODEPAGE_ISLOWER, 0xFFFF, 0x0102 },
	{ 0x0104, CODEPAGE_ISUPPER, 0x0105, 0xFFFF },
	{ 0x0105, CODEPAGE_ISLOWER, 0xFFFF, 0x0104 },
	{ 0x0106, CODEPAGE_ISUPPER, 0x0107, 0xFFFF },
	{ 0x0107, CODEPAGE_ISLOWER, 0xFFFF, 0x0106 },
	{ 0x0108, CODEPAGE_ISUPPER, 0x0109, 0xFFFF },
	{ 0x0109, CODEPAGE_ISLOWER, 0xFFFF, 0x0108 },
	{ 0x010A, CODEPAGE_ISUPPER, 0x010B, 0xFFFF },
	{ 0x010B, CODEPAGE_ISLOWER, 0xFFFF, 0x010A },
	{ 0x010C, CODEPAGE_ISUPPER, 0x010D, 0xFFFF },
	{ 0x010D, CODEPAGE_ISLOWER, 0xFFFF, 0x010C },
	{ 0x010E, CODEPAGE_ISUPPER, 0x010F, 0xFFFF },
	{ 0x010F, CODEPAGE_ISLOWER, 0xFFFF, 0x010E },
	{ 0x0110, CODEPAGE_ISUPPER, 0x0111, 0xFFFF },
	{ 0x0111, CODEPAGE_ISLOWER, 0xFFFF, 0x0110 },
	{ 0x0112, CODEPAGE_ISUPPER, 0x0113, 0xFFFF },
	{ 0x0113, CODEPAGE_ISLOWER, 0xFFFF, 0x0112 },
	{ 0x0114, CODEPAGE_ISUPPER, 0x0115, 0xFFFF },
	{ 0x0115, CODEPAGE_ISLOWER, 0xFFFF, 0x0114 },
	{ 0x0116, CODEPAGE_ISUPPER, 0x0117, 0xFFFF },
	{ 0x0117, CODEPAGE_ISLOWER, 0xFFFF, 0x0116 },
	{ 0x0118, CODEPAGE_ISUPPER, 0x0119, 0xFFFF },
	{ 0x0119, CODEPAGE_ISLOWER, 0xFFFF, 0x0118 },
	{ 0x011A, CODEPAGE_ISUPPER, 0x011B, 0xFFFF },
	{ 0x011B, CODEPAGE_ISLOWER, 0xFFFF, 0x011A },
	{ 0x011C, CODEPAGE_ISUPPER, 0x011D, 0xFFFF },
	{ 0x011D, CODEPAGE_ISLOWER, 0xFFFF, 0x011C },
	{ 0x011E, CODEPAGE_ISUPPER, 0x011F, 0xFFFF },
	{ 0x011F, CODEPAGE_ISLOWER, 0xFFFF, 0x011E },
	{ 0x0120, CODEPAGE_ISUPPER, 0x0121, 0xFFFF },
	{ 0x0121, CODEPAGE_ISLOWER, 0xFFFF, 0x0120 },
	{ 0x0122, CODEPAGE_ISUPPER, 0x0123, 0xFFFF },
	{ 0x0123, CODEPAGE_ISLOWER, 0xFFFF, 0x0122 },
	{ 0x0124, CODEPAGE_ISUPPER, 0x0125, 0xFFFF },
	{ 0x0125, CODEPAGE_ISLOWER, 0xFFFF, 0x0124 },
	{ 0x0126, CODEPAGE_ISUPPER, 0x0127, 0xFFFF },
	{ 0x0127, CODEPAGE_ISLOWER, 0xFFFF, 0x0126 },
	{ 0x0128, CODEPAGE_ISUPPER, 0x0129, 0xFFFF },
	{ 0x0129, CODEPAGE_ISLOWER, 0xFFFF, 0x0128 },
	{ 0x012A, CODEPAGE_ISUPPER, 0x012B, 0xFFFF },
	{ 0x012B, CODEPAGE_ISLOWER, 0xFFFF, 0x012A },
	{ 0x012C, CODEPAGE_ISUPPER, 0x012D, 0xFFFF },
	{ 0x012D, CODEPAGE_ISLOWER, 0xFFFF, 0x012C },
	{ 0x012E, CODEPAGE_ISUPPER, 0x012F, 0xFFFF },
	{ 0x012F, CODEPAGE_ISLOWER, 0xFFFF, 0x012E },
	{ 0x0130, CODEPAGE_ISUPPER, 0x0069, 0xFFFF },
	{ 0x0131, CODEPAGE_ISLOWER, 0xFFFF, 0x0049 },
	{ 0x0132, CODEPAGE_ISUPPER, 0x0133, 0xFFFF },
	{ 0x0133, CODEPAGE_ISLOWER, 0xFFFF, 0x0132 },
	{ 0x0134, CODEPAGE_ISUPPER, 0x0135, 0xFFFF },
	{ 0x0135, CODEPAGE_ISLOWER, 0xFFFF, 0x0134 },
	{ 0x0136, CODEPAGE_ISUPPER, 0x0137, 0xFFFF },
	{ 0x0137, CODEPAGE_ISLOWER, 0xFFFF, 0x0136 },
	{ 0x0138, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0139, CODEPAGE_ISUPPER, 0x013A, 0xFFFF },
	{ 0x013A, CODEPAGE_ISLOWER, 0xFFFF, 0x0139 },
	{ 0x013B, CODEPAGE_ISUPPER, 0x013C, 0xFFFF },
	{ 0x013C, CODEPAGE_ISLOWER, 0xFFFF, 0x013B },
	{ 0x013D, CODEPAGE_ISUPPER, 0x013E, 0xFFFF },
	{ 0x013E, CODEPAGE_ISLOWER, 0xFFFF, 0x013D },
	{ 0x013F, CODEPAGE_ISUPPER, 0x0140, 0xFFFF },
	{ 0x0140, CODEPAGE_ISLOWER, 0xFFFF, 0x013F },
	{ 0x0141, CODEPAGE_ISUPPER, 0x0142, 0xFFFF },
	{ 0x0142, CODEPAGE_ISLOWER, 0xFFFF, 0x0141 },
	{ 0x0143, CODEPAGE_ISUPPER, 0x0144, 0xFFFF },
	{ 0x0144, CODEPAGE_ISLOWER, 0xFFFF, 0x0143 },
	{ 0x0145, CODEPAGE_ISUPPER, 0x0146, 0xFFFF },
	{ 0x0146, CODEPAGE_ISLOWER, 0xFFFF, 0x0145 },
	{ 0x0147, CODEPAGE_ISUPPER, 0x0148, 0xFFFF },
	{ 0x0148, CODEPAGE_ISLOWER, 0xFFFF, 0x0147 },
	{ 0x0149, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x014A, CODEPAGE_ISUPPER, 0x014B, 0xFFFF },
	{ 0x014B, CODEPAGE_ISLOWER, 0xFFFF, 0x014A },
	{ 0x014C, CODEPAGE_ISUPPER, 0x014D, 0xFFFF },
	{ 0x014D, CODEPAGE_ISLOWER, 0xFFFF, 0x014C },
	{ 0x014E, CODEPAGE_ISUPPER, 0x014F, 0xFFFF },
	{ 0x014F, CODEPAGE_ISLOWER, 0xFFFF, 0x014E },
	{ 0x0150, CODEPAGE_ISUPPER, 0x0151, 0xFFFF },
	{ 0x0151, CODEPAGE_ISLOWER, 0xFFFF, 0x0150 },
	{ 0x0152, CODEPAGE_ISUPPER, 0x0153, 0xFFFF },
	{ 0x0153, CODEPAGE_ISLOWER, 0xFFFF, 0x0152 },
	{ 0x0154, CODEPAGE_ISUPPER, 0x0155, 0xFFFF },
	{ 0x0155, CODEPAGE_ISLOWER, 0xFFFF, 0x0154 },
	{ 0x0156, CODEPAGE_ISUPPER, 0x0157, 0xFFFF },
	{ 0x0157, CODEPAGE_ISLOWER, 0xFFFF, 0x0156 },
	{ 0x0158, CODEPAGE_ISUPPER, 0x0159, 0xFFFF },
	{ 0x0159, CODEPAGE_ISLOWER, 0xFFFF, 0x0158 },
	{ 0x015A, CODEPAGE_ISUPPER, 0x015B, 0xFFFF },
	{ 0x015B, CODEPAGE_ISLOWER, 0xFFFF, 0x015A },
	{ 0x015C, CODEPAGE_ISUPPER, 0x015D, 0xFFFF },
	{ 0x015D, CODEPAGE_ISLOWER, 0xFFFF, 0x015C },
	{ 0x015E, CODEPAGE_ISUPPER, 0x015F, 0xFFFF },
	{ 0x015F, CODEPAGE_ISLOWER, 0xFFFF, 0x015E },
	{ 0x0160, CODEPAGE_ISUPPER, 0x0161, 0xFFFF },
	{ 0x0161, CODEPAGE_ISLOWER, 0xFFFF, 0x0160 },
	{ 0x0162, CODEPAGE_ISUPPER, 0x0163, 0xFFFF },
	{ 0x0163, CODEPAGE_ISLOWER, 0xFFFF, 0x0162 },
	{ 0x0164, CODEPAGE_ISUPPER, 0x0165, 0xFFFF },
	{ 0x0165, CODEPAGE_ISLOWER, 0xFFFF, 0x0164 },
	{ 0x0166, CODEPAGE_ISUPPER, 0x0167, 0xFFFF },
	{ 0x0167, CODEPAGE_ISLOWER, 0xFFFF, 0x0166 },
	{ 0x0168, CODEPAGE_ISUPPER, 0x0169, 0xFFFF },
	{ 0x0169, CODEPAGE_ISLOWER, 0xFFFF, 0x0168 },
	{ 0x016A, CODEPAGE_ISUPPER, 0x016B, 0xFFFF },
	{ 0x016B, CODEPAGE_ISLOWER, 0xFFFF, 0x016A },
	{ 0x016C, CODEPAGE_ISUPPER, 0x016D, 0xFFFF },
	{ 0x016D, CODEPAGE_ISLOWER, 0xFFFF, 0x016C },
	{ 0x016E, CODEPAGE_ISUPPER, 0x016F, 0xFFFF },
	{ 0x016F, CODEPAGE_ISLOWER, 0xFFFF, 0x016E },
	{ 0x0170, CODEPAGE_ISUPPER, 0x0171, 0xFFFF },
	{ 0x0171, CODEPAGE_ISLOWER, 0xFFFF, 0x0170 },
	{ 0x0172, CODEPAGE_ISUPPER, 0x0173, 0xFFFF },
	{ 0x0173, CODEPAGE_ISLOWER, 0xFFFF, 0x0172 },
	{ 0x0174, CODEPAGE_ISUPPER, 0x0175, 0xFFFF },
	{ 0x0175, CODEPAGE_ISLOWER, 0xFFFF, 0x0174 },
	{ 0x0176, CODEPAGE_ISUPPER, 0x0177, 0xFFFF },
	{ 0x0177, CODEPAGE_ISLOWER, 0xFFFF, 0x0176 },
	{ 0x0178, CODEPAGE_ISUPPER, 0x00FF, 0xFFFF },
	{ 0x0179, CODEPAGE_ISUPPER, 0x017A, 0xFFFF },
	{ 0x017A, CODEPAGE_ISLOWER, 0xFFFF, 0x0179 },
	{ 0x017B, CODEPAGE_ISUPPER, 0x017C, 0xFFFF },
	{ 0x017C, CODEPAGE_ISLOWER, 0xFFFF, 0x017B },
	{ 0x017D, CODEPAGE_ISUPPER, 0x017E, 0xFFFF },
	{ 0x017E, CODEPAGE_ISLOWER, 0xFFFF, 0x017D },
	{ 0x017F, CODEPAGE_ISLOWER, 0xFFFF, 0x0053 },
	{ 0x0180, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0181, CODEPAGE_ISUPPER, 0x0253, 0xFFFF },
	{ 0x0182, CODEPAGE_ISUPPER, 0x0183, 0xFFFF },
	{ 0x0183, CODEPAGE_ISLOWER, 0xFFFF, 0x0182 },
	{ 0x0184, CODEPAGE_ISUPPER, 0x0185, 0xFFFF },
	{ 0x0185, CODEPAGE_ISLOWER, 0xFFFF, 0x0184 },
	{ 0x0186, CODEPAGE_ISUPPER, 0x0254, 0xFFFF },
	{ 0x0187, CODEPAGE_ISUPPER, 0x0188, 0xFFFF },
	{ 0x0188, CODEPAGE_ISLOWER, 0xFFFF, 0x0187 },
	{ 0x0189, CODEPAGE_ISUPPER, 0x0256, 0xFFFF },
	{ 0x018A, CODEPAGE_ISUPPER, 0x0257, 0xFFFF },
	{ 0x018B, CODEPAGE_ISUPPER, 0x018C, 0xFFFF },
	{ 0x018C, CODEPAGE_ISLOWER, 0xFFFF, 0x018B },
	{ 0x018D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x018E, CODEPAGE_ISUPPER, 0x0258, 0xFFFF },
	{ 0x018F, CODEPAGE_ISUPPER, 0x0259, 0xFFFF },
	{ 0x0190, CODEPAGE_ISUPPER, 0x025B, 0xFFFF },
	{ 0x0191, CODEPAGE_ISUPPER, 0x0192, 0xFFFF },
	{ 0x0192, CODEPAGE_ISLOWER, 0xFFFF, 0x0191 },
	{ 0x0193, CODEPAGE_ISUPPER, 0x0260, 0xFFFF },
	{ 0x0194, CODEPAGE_ISUPPER, 0x0263, 0xFFFF },
	{ 0x0195, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0196, CODEPAGE_ISUPPER, 0x0269, 0xFFFF },
	{ 0x0197, CODEPAGE_ISUPPER, 0x0268, 0xFFFF },
	{ 0x0198, CODEPAGE_ISUPPER, 0x0199, 0xFFFF },
	{ 0x0199, CODEPAGE_ISLOWER, 0xFFFF, 0x0198 },
	{ 0x019A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x019B, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x019C, CODEPAGE_ISUPPER, 0x026F, 0xFFFF },
	{ 0x019D, CODEPAGE_ISUPPER, 0x0272, 0xFFFF },
	{ 0x019E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x019F, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x01A0, CODEPAGE_ISUPPER, 0x01A1, 0xFFFF },
	{ 0x01A1, CODEPAGE_ISLOWER, 0xFFFF, 0x01A0 },
	{ 0x01A2, CODEPAGE_ISUPPER, 0x01A3, 0xFFFF },
	{ 0x01A3, CODEPAGE_ISLOWER, 0xFFFF, 0x01A2 },
	{ 0x01A4, CODEPAGE_ISUPPER, 0x01A5, 0xFFFF },
	{ 0x01A5, CODEPAGE_ISLOWER, 0xFFFF, 0x01A4 },
	{ 0x01A6, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x01A7, CODEPAGE_ISUPPER, 0x01A8, 0xFFFF },
	{ 0x01A8, CODEPAGE_ISLOWER, 0xFFFF, 0x01A7 },
	{ 0x01A9, CODEPAGE_ISUPPER, 0x0283, 0xFFFF },
	{ 0x01AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01AB, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x01AC, CODEPAGE_ISUPPER, 0x01AD, 0xFFFF },
	{ 0x01AD, CODEPAGE_ISLOWER, 0xFFFF, 0x01AC },
	{ 0x01AE, CODEPAGE_ISUPPER, 0x0288, 0xFFFF },
	{ 0x01AF, CODEPAGE_ISUPPER, 0x01B0, 0xFFFF },
	{ 0x01B0, CODEPAGE_ISLOWER, 0xFFFF, 0x01AF },
	{ 0x01B1, CODEPAGE_ISUPPER, 0x028A, 0xFFFF },
	{ 0x01B2, CODEPAGE_ISUPPER, 0x028B, 0xFFFF },
	{ 0x01B3, CODEPAGE_ISUPPER, 0x01B4, 0xFFFF },
	{ 0x01B4, CODEPAGE_ISLOWER, 0xFFFF, 0x01B3 },
	{ 0x01B5, CODEPAGE_ISUPPER, 0x01B6, 0xFFFF },
	{ 0x01B6, CODEPAGE_ISLOWER, 0xFFFF, 0x01B5 },
	{ 0x01B7, CODEPAGE_ISUPPER, 0x0292, 0xFFFF },
	{ 0x01B8, CODEPAGE_ISUPPER, 0x01B9, 0xFFFF },
	{ 0x01B9, CODEPAGE_ISLOWER, 0xFFFF, 0x01B8 },
	{ 0x01BA, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x01BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01BC, CODEPAGE_ISUPPER, 0x01BD, 0xFFFF },
	{ 0x01BD, CODEPAGE_ISLOWER, 0xFFFF, 0x01BC },
	{ 0x01BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x01C4, CODEPAGE_ISUPPER, 0x01C6, 0x01C5 },
	{ 0x01C5, CODEPAGE_ISNONE, 0x01C6, 0xFFFF },
	{ 0x01C6, CODEPAGE_ISLOWER, 0xFFFF, 0x01C5 },
	{ 0x01C7, CODEPAGE_ISUPPER, 0x01C9, 0x01C8 },
	{ 0x01C8, CODEPAGE_ISNONE, 0x01C9, 0xFFFF },
	{ 0x01C9, CODEPAGE_ISLOWER, 0xFFFF, 0x01C8 },
	{ 0x01CA, CODEPAGE_ISUPPER, 0x01CC, 0x01CB },
	{ 0x01CB, CODEPAGE_ISNONE, 0x01CC, 0xFFFF },
	{ 0x01CC, CODEPAGE_ISLOWER, 0xFFFF, 0x01CB },
	{ 0x01CD, CODEPAGE_ISUPPER, 0x01CE, 0xFFFF },
	{ 0x01CE, CODEPAGE_ISLOWER, 0xFFFF, 0x01CD },
	{ 0x01CF, CODEPAGE_ISUPPER, 0x01D0, 0xFFFF },
	{ 0x01D0, CODEPAGE_ISLOWER, 0xFFFF, 0x01CF },
	{ 0x01D1, CODEPAGE_ISUPPER, 0x01D2, 0xFFFF },
	{ 0x01D2, CODEPAGE_ISLOWER, 0xFFFF, 0x01D1 },
	{ 0x01D3, CODEPAGE_ISUPPER, 0x01D4, 0xFFFF },
	{ 0x01D4, CODEPAGE_ISLOWER, 0xFFFF, 0x01D3 },
	{ 0x01D5, CODEPAGE_ISUPPER, 0x01D6, 0xFFFF },
	{ 0x01D6, CODEPAGE_ISLOWER, 0xFFFF, 0x01D5 },
	{ 0x01D7, CODEPAGE_ISUPPER, 0x01D8, 0xFFFF },
	{ 0x01D8, CODEPAGE_ISLOWER, 0xFFFF, 0x01D7 },
	{ 0x01D9, CODEPAGE_ISUPPER, 0x01DA, 0xFFFF },
	{ 0x01DA, CODEPAGE_ISLOWER, 0xFFFF, 0x01D9 },
	{ 0x01DB, CODEPAGE_ISUPPER, 0x01DC, 0xFFFF },
	{ 0x01DC, CODEPAGE_ISLOWER, 0xFFFF, 0x01DB },
	{ 0x01DD, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x01DE, CODEPAGE_ISUPPER, 0x01DF, 0xFFFF },
	{ 0x01DF, CODEPAGE_ISLOWER, 0xFFFF, 0x01DE },
	{ 0x01E0, CODEPAGE_ISUPPER, 0x01E1, 0xFFFF },
	{ 0x01E1, CODEPAGE_ISLOWER, 0xFFFF, 0x01E0 },
	{ 0x01E2, CODEPAGE_ISUPPER, 0x01E3, 0xFFFF },
	{ 0x01E3, CODEPAGE_ISLOWER, 0xFFFF, 0x01E2 },
	{ 0x01E4, CODEPAGE_ISUPPER, 0x01E5, 0xFFFF },
	{ 0x01E5, CODEPAGE_ISLOWER, 0xFFFF, 0x01E4 },
	{ 0x01E6, CODEPAGE_ISUPPER, 0x01E7, 0xFFFF },
	{ 0x01E7, CODEPAGE_ISLOWER, 0xFFFF, 0x01E6 },
	{ 0x01E8, CODEPAGE_ISUPPER, 0x01E9, 0xFFFF },
	{ 0x01E9, CODEPAGE_ISLOWER, 0xFFFF, 0x01E8 },
	{ 0x01EA, CODEPAGE_ISUPPER, 0x01EB, 0xFFFF },
	{ 0x01EB, CODEPAGE_ISLOWER, 0xFFFF, 0x01EA },
	{ 0x01EC, CODEPAGE_ISUPPER, 0x01ED, 0xFFFF },
	{ 0x01ED, CODEPAGE_ISLOWER, 0xFFFF, 0x01EC },
	{ 0x01EE, CODEPAGE_ISUPPER, 0x01EF, 0xFFFF },
	{ 0x01EF, CODEPAGE_ISLOWER, 0xFFFF, 0x01EE },
	{ 0x01F0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x01F1, CODEPAGE_ISUPPER, 0x01F3, 0x01F2 },
	{ 0x01F2, CODEPAGE_ISNONE, 0x01F3, 0xFFFF },
	{ 0x01F3, CODEPAGE_ISLOWER, 0xFFFF, 0x01F2 },
	{ 0x01F4, CODEPAGE_ISUPPER, 0x01F5, 0xFFFF },
	{ 0x01F5, CODEPAGE_ISLOWER, 0xFFFF, 0x01F4 },
	{ 0x01FA, CODEPAGE_ISUPPER, 0x01FB, 0xFFFF },
	{ 0x01FB, CODEPAGE_ISLOWER, 0xFFFF, 0x01FA },
	{ 0x01FC, CODEPAGE_ISUPPER, 0x01FD, 0xFFFF },
	{ 0x01FD, CODEPAGE_ISLOWER, 0xFFFF, 0x01FC },
	{ 0x01FE, CODEPAGE_ISUPPER, 0x01FF, 0xFFFF },
	{ 0x01FF, CODEPAGE_ISLOWER, 0xFFFF, 0x01FE },
	{ 0x0200, CODEPAGE_ISUPPER, 0x0201, 0xFFFF },
	{ 0x0201, CODEPAGE_ISLOWER, 0xFFFF, 0x0200 },
	{ 0x0202, CODEPAGE_ISUPPER, 0x0203, 0xFFFF },
	{ 0x0203, CODEPAGE_ISLOWER, 0xFFFF, 0x0202 },
	{ 0x0204, CODEPAGE_ISUPPER, 0x0205, 0xFFFF },
	{ 0x0205, CODEPAGE_ISLOWER, 0xFFFF, 0x0204 },
	{ 0x0206, CODEPAGE_ISUPPER, 0x0207, 0xFFFF },
	{ 0x0207, CODEPAGE_ISLOWER, 0xFFFF, 0x0206 },
	{ 0x0208, CODEPAGE_ISUPPER, 0x0209, 0xFFFF },
	{ 0x0209, CODEPAGE_ISLOWER, 0xFFFF, 0x0208 },
	{ 0x020A, CODEPAGE_ISUPPER, 0x020B, 0xFFFF },
	{ 0x020B, CODEPAGE_ISLOWER, 0xFFFF, 0x020A },
	{ 0x020C, CODEPAGE_ISUPPER, 0x020D, 0xFFFF },
	{ 0x020D, CODEPAGE_ISLOWER, 0xFFFF, 0x020C },
	{ 0x020E, CODEPAGE_ISUPPER, 0x020F, 0xFFFF },
	{ 0x020F, CODEPAGE_ISLOWER, 0xFFFF, 0x020E },
	{ 0x0210, CODEPAGE_ISUPPER, 0x0211, 0xFFFF },
	{ 0x0211, CODEPAGE_ISLOWER, 0xFFFF, 0x0210 },
	{ 0x0212, CODEPAGE_ISUPPER, 0x0213, 0xFFFF },
	{ 0x0213, CODEPAGE_ISLOWER, 0xFFFF, 0x0212 },
	{ 0x0214, CODEPAGE_ISUPPER, 0x0215, 0xFFFF },
	{ 0x0215, CODEPAGE_ISLOWER, 0xFFFF, 0x0214 },
	{ 0x0216, CODEPAGE_ISUPPER, 0x0217, 0xFFFF },
	{ 0x0217, CODEPAGE_ISLOWER, 0xFFFF, 0x0216 },
	{ 0x0250, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0251, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0252, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0253, CODEPAGE_ISLOWER, 0xFFFF, 0x0181 },
	{ 0x0254, CODEPAGE_ISLOWER, 0xFFFF, 0x0186 },
	{ 0x0255, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0256, CODEPAGE_ISLOWER, 0xFFFF, 0x0189 },
	{ 0x0257, CODEPAGE_ISLOWER, 0xFFFF, 0x018A },
	{ 0x0258, CODEPAGE_ISLOWER, 0xFFFF, 0x018E },
	{ 0x0259, CODEPAGE_ISLOWER, 0xFFFF, 0x018F },
	{ 0x025A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x025B, CODEPAGE_ISLOWER, 0xFFFF, 0x0190 },
	{ 0x025C, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x025D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x025E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x025F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0260, CODEPAGE_ISLOWER, 0xFFFF, 0x0193 },
	{ 0x0261, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0262, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0263, CODEPAGE_ISLOWER, 0xFFFF, 0x0194 },
	{ 0x0264, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0265, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0266, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0267, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0268, CODEPAGE_ISLOWER, 0xFFFF, 0x0197 },
	{ 0x0269, CODEPAGE_ISLOWER, 0xFFFF, 0x0196 },
	{ 0x026A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x026B, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x026C, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x026D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x026E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x026F, CODEPAGE_ISLOWER, 0xFFFF, 0x019C },
	{ 0x0270, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0271, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0272, CODEPAGE_ISLOWER, 0xFFFF, 0x019D },
	{ 0x0273, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0274, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0275, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0276, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0277, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0278, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0279, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x027A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x027B, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x027C, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x027D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x027E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x027F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0280, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0281, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0282, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0283, CODEPAGE_ISLOWER, 0xFFFF, 0x01A9 },
	{ 0x0284, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0285, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0286, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0287, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0288, CODEPAGE_ISLOWER, 0xFFFF, 0x01AE },
	{ 0x0289, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x028A, CODEPAGE_ISLOWER, 0xFFFF, 0x01B1 },
	{ 0x028B, CODEPAGE_ISLOWER, 0xFFFF, 0x01B2 },
	{ 0x028C, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x028D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x028E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x028F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0290, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0291, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0292, CODEPAGE_ISLOWER, 0xFFFF, 0x01B7 },
	{ 0x0293, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0294, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0295, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0296, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0297, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0298, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0299, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x029A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x029B, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x029C, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x029D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x029E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x029F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02A8, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x02B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02CF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x02E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0300, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0301, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0302, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0303, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0304, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0305, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0306, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0307, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0308, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0309, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x030A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x030B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x030C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x030D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x030E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x030F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0310, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0311, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0312, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0313, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0314, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0315, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0316, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0317, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0318, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0319, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x031A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x031B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x031C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x031D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x031E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x031F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0320, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0321, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0322, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0323, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0324, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0325, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0326, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0327, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0328, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0329, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x032A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x032B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x032C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x032D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x032E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x032F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0330, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0331, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0332, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0333, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0334, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0335, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0336, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0337, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0338, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0339, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x033A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x033B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x033C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x033D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x033E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x033F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0340, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0341, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0342, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0343, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0344, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0345, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0360, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0361, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0374, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0375, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x037A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x037E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0384, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0385, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0386, CODEPAGE_ISUPPER, 0x03AC, 0xFFFF },
	{ 0x0387, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0388, CODEPAGE_ISUPPER, 0x03AD, 0xFFFF },
	{ 0x0389, CODEPAGE_ISUPPER, 0x03AE, 0xFFFF },
	{ 0x038A, CODEPAGE_ISUPPER, 0x03AF, 0xFFFF },
	{ 0x038C, CODEPAGE_ISUPPER, 0x03CC, 0xFFFF },
	{ 0x038E, CODEPAGE_ISUPPER, 0x03CD, 0xFFFF },
	{ 0x038F, CODEPAGE_ISUPPER, 0x03CE, 0xFFFF },
	{ 0x0390, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0391, CODEPAGE_ISUPPER, 0x03B1, 0xFFFF },
	{ 0x0392, CODEPAGE_ISUPPER, 0x03B2, 0xFFFF },
	{ 0x0393, CODEPAGE_ISUPPER, 0x03B3, 0xFFFF },
	{ 0x0394, CODEPAGE_ISUPPER, 0x03B4, 0xFFFF },
	{ 0x0395, CODEPAGE_ISUPPER, 0x03B5, 0xFFFF },
	{ 0x0396, CODEPAGE_ISUPPER, 0x03B6, 0xFFFF },
	{ 0x0397, CODEPAGE_ISUPPER, 0x03B7, 0xFFFF },
	{ 0x0398, CODEPAGE_ISUPPER, 0x03B8, 0xFFFF },
	{ 0x0399, CODEPAGE_ISUPPER, 0x03B9, 0xFFFF },
	{ 0x039A, CODEPAGE_ISUPPER, 0x03BA, 0xFFFF },
	{ 0x039B, CODEPAGE_ISUPPER, 0x03BB, 0xFFFF },
	{ 0x039C, CODEPAGE_ISUPPER, 0x03BC, 0xFFFF },
	{ 0x039D, CODEPAGE_ISUPPER, 0x03BD, 0xFFFF },
	{ 0x039E, CODEPAGE_ISUPPER, 0x03BE, 0xFFFF },
	{ 0x039F, CODEPAGE_ISUPPER, 0x03BF, 0xFFFF },
	{ 0x03A0, CODEPAGE_ISUPPER, 0x03C0, 0xFFFF },
	{ 0x03A1, CODEPAGE_ISUPPER, 0x03C1, 0xFFFF },
	{ 0x03A3, CODEPAGE_ISUPPER, 0x03C3, 0xFFFF },
	{ 0x03A4, CODEPAGE_ISUPPER, 0x03C4, 0xFFFF },
	{ 0x03A5, CODEPAGE_ISUPPER, 0x03C5, 0xFFFF },
	{ 0x03A6, CODEPAGE_ISUPPER, 0x03C6, 0xFFFF },
	{ 0x03A7, CODEPAGE_ISUPPER, 0x03C7, 0xFFFF },
	{ 0x03A8, CODEPAGE_ISUPPER, 0x03C8, 0xFFFF },
	{ 0x03A9, CODEPAGE_ISUPPER, 0x03C9, 0xFFFF },
	{ 0x03AA, CODEPAGE_ISUPPER, 0x03CA, 0xFFFF },
	{ 0x03AB, CODEPAGE_ISUPPER, 0x03CB, 0xFFFF },
	{ 0x03AC, CODEPAGE_ISLOWER, 0xFFFF, 0x0386 },
	{ 0x03AD, CODEPAGE_ISLOWER, 0xFFFF, 0x0388 },
	{ 0x03AE, CODEPAGE_ISLOWER, 0xFFFF, 0x0389 },
	{ 0x03AF, CODEPAGE_ISLOWER, 0xFFFF, 0x038A },
	{ 0x03B0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03B1, CODEPAGE_ISLOWER, 0xFFFF, 0x0391 },
	{ 0x03B2, CODEPAGE_ISLOWER, 0xFFFF, 0x0392 },
	{ 0x03B3, CODEPAGE_ISLOWER, 0xFFFF, 0x0393 },
	{ 0x03B4, CODEPAGE_ISLOWER, 0xFFFF, 0x0394 },
	{ 0x03B5, CODEPAGE_ISLOWER, 0xFFFF, 0x0395 },
	{ 0x03B6, CODEPAGE_ISLOWER, 0xFFFF, 0x0396 },
	{ 0x03B7, CODEPAGE_ISLOWER, 0xFFFF, 0x0397 },
	{ 0x03B8, CODEPAGE_ISLOWER, 0xFFFF, 0x0398 },
	{ 0x03B9, CODEPAGE_ISLOWER, 0xFFFF, 0x0399 },
	{ 0x03BA, CODEPAGE_ISLOWER, 0xFFFF, 0x039A },
	{ 0x03BB, CODEPAGE_ISLOWER, 0xFFFF, 0x039B },
	{ 0x03BC, CODEPAGE_ISLOWER, 0xFFFF, 0x039C },
	{ 0x03BD, CODEPAGE_ISLOWER, 0xFFFF, 0x039D },
	{ 0x03BE, CODEPAGE_ISLOWER, 0xFFFF, 0x039E },
	{ 0x03BF, CODEPAGE_ISLOWER, 0xFFFF, 0x039F },
	{ 0x03C0, CODEPAGE_ISLOWER, 0xFFFF, 0x03A0 },
	{ 0x03C1, CODEPAGE_ISLOWER, 0xFFFF, 0x03A1 },
	{ 0x03C2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03C3, CODEPAGE_ISLOWER, 0xFFFF, 0x03A3 },
	{ 0x03C4, CODEPAGE_ISLOWER, 0xFFFF, 0x03A4 },
	{ 0x03C5, CODEPAGE_ISLOWER, 0xFFFF, 0x03A5 },
	{ 0x03C6, CODEPAGE_ISLOWER, 0xFFFF, 0x03A6 },
	{ 0x03C7, CODEPAGE_ISLOWER, 0xFFFF, 0x03A7 },
	{ 0x03C8, CODEPAGE_ISLOWER, 0xFFFF, 0x03A8 },
	{ 0x03C9, CODEPAGE_ISLOWER, 0xFFFF, 0x03A9 },
	{ 0x03CA, CODEPAGE_ISLOWER, 0xFFFF, 0x03AA },
	{ 0x03CB, CODEPAGE_ISLOWER, 0xFFFF, 0x03AB },
	{ 0x03CC, CODEPAGE_ISLOWER, 0xFFFF, 0x038C },
	{ 0x03CD, CODEPAGE_ISLOWER, 0xFFFF, 0x038E },
	{ 0x03CE, CODEPAGE_ISLOWER, 0xFFFF, 0x038F },
	{ 0x03D0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03D1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03D2, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03D3, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03D4, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03D5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03D6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03DA, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03DC, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03DE, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03E0, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x03E2, CODEPAGE_ISUPPER, 0x03E3, 0xFFFF },
	{ 0x03E3, CODEPAGE_ISLOWER, 0xFFFF, 0x03E2 },
	{ 0x03E4, CODEPAGE_ISUPPER, 0x03E5, 0xFFFF },
	{ 0x03E5, CODEPAGE_ISLOWER, 0xFFFF, 0x03E4 },
	{ 0x03E6, CODEPAGE_ISUPPER, 0x03E7, 0xFFFF },
	{ 0x03E7, CODEPAGE_ISLOWER, 0xFFFF, 0x03E6 },
	{ 0x03E8, CODEPAGE_ISUPPER, 0x03E9, 0xFFFF },
	{ 0x03E9, CODEPAGE_ISLOWER, 0xFFFF, 0x03E8 },
	{ 0x03EA, CODEPAGE_ISUPPER, 0x03EB, 0xFFFF },
	{ 0x03EB, CODEPAGE_ISLOWER, 0xFFFF, 0x03EA },
	{ 0x03EC, CODEPAGE_ISUPPER, 0x03ED, 0xFFFF },
	{ 0x03ED, CODEPAGE_ISLOWER, 0xFFFF, 0x03EC },
	{ 0x03EE, CODEPAGE_ISUPPER, 0x03EF, 0xFFFF },
	{ 0x03EF, CODEPAGE_ISLOWER, 0xFFFF, 0x03EE },
	{ 0x03F0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03F1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03F2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x03F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0401, CODEPAGE_ISUPPER, 0x0451, 0xFFFF },
	{ 0x0402, CODEPAGE_ISUPPER, 0x0452, 0xFFFF },
	{ 0x0403, CODEPAGE_ISUPPER, 0x0453, 0xFFFF },
	{ 0x0404, CODEPAGE_ISUPPER, 0x0454, 0xFFFF },
	{ 0x0405, CODEPAGE_ISUPPER, 0x0455, 0xFFFF },
	{ 0x0406, CODEPAGE_ISUPPER, 0x0456, 0xFFFF },
	{ 0x0407, CODEPAGE_ISUPPER, 0x0457, 0xFFFF },
	{ 0x0408, CODEPAGE_ISUPPER, 0x0458, 0xFFFF },
	{ 0x0409, CODEPAGE_ISUPPER, 0x0459, 0xFFFF },
	{ 0x040A, CODEPAGE_ISUPPER, 0x045A, 0xFFFF },
	{ 0x040B, CODEPAGE_ISUPPER, 0x045B, 0xFFFF },
	{ 0x040C, CODEPAGE_ISUPPER, 0x045C, 0xFFFF },
	{ 0x040E, CODEPAGE_ISUPPER, 0x045E, 0xFFFF },
	{ 0x040F, CODEPAGE_ISUPPER, 0x045F, 0xFFFF },
	{ 0x0410, CODEPAGE_ISUPPER, 0x0430, 0xFFFF },
	{ 0x0411, CODEPAGE_ISUPPER, 0x0431, 0xFFFF },
	{ 0x0412, CODEPAGE_ISUPPER, 0x0432, 0xFFFF },
	{ 0x0413, CODEPAGE_ISUPPER, 0x0433, 0xFFFF },
	{ 0x0414, CODEPAGE_ISUPPER, 0x0434, 0xFFFF },
	{ 0x0415, CODEPAGE_ISUPPER, 0x0435, 0xFFFF },
	{ 0x0416, CODEPAGE_ISUPPER, 0x0436, 0xFFFF },
	{ 0x0417, CODEPAGE_ISUPPER, 0x0437, 0xFFFF },
	{ 0x0418, CODEPAGE_ISUPPER, 0x0438, 0xFFFF },
	{ 0x0419, CODEPAGE_ISUPPER, 0x0439, 0xFFFF },
	{ 0x041A, CODEPAGE_ISUPPER, 0x043A, 0xFFFF },
	{ 0x041B, CODEPAGE_ISUPPER, 0x043B, 0xFFFF },
	{ 0x041C, CODEPAGE_ISUPPER, 0x043C, 0xFFFF },
	{ 0x041D, CODEPAGE_ISUPPER, 0x043D, 0xFFFF },
	{ 0x041E, CODEPAGE_ISUPPER, 0x043E, 0xFFFF },
	{ 0x041F, CODEPAGE_ISUPPER, 0x043F, 0xFFFF },
	{ 0x0420, CODEPAGE_ISUPPER, 0x0440, 0xFFFF },
	{ 0x0421, CODEPAGE_ISUPPER, 0x0441, 0xFFFF },
	{ 0x0422, CODEPAGE_ISUPPER, 0x0442, 0xFFFF },
	{ 0x0423, CODEPAGE_ISUPPER, 0x0443, 0xFFFF },
	{ 0x0424, CODEPAGE_ISUPPER, 0x0444, 0xFFFF },
	{ 0x0425, CODEPAGE_ISUPPER, 0x0445, 0xFFFF },
	{ 0x0426, CODEPAGE_ISUPPER, 0x0446, 0xFFFF },
	{ 0x0427, CODEPAGE_ISUPPER, 0x0447, 0xFFFF },
	{ 0x0428, CODEPAGE_ISUPPER, 0x0448, 0xFFFF },
	{ 0x0429, CODEPAGE_ISUPPER, 0x0449, 0xFFFF },
	{ 0x042A, CODEPAGE_ISUPPER, 0x044A, 0xFFFF },
	{ 0x042B, CODEPAGE_ISUPPER, 0x044B, 0xFFFF },
	{ 0x042C, CODEPAGE_ISUPPER, 0x044C, 0xFFFF },
	{ 0x042D, CODEPAGE_ISUPPER, 0x044D, 0xFFFF },
	{ 0x042E, CODEPAGE_ISUPPER, 0x044E, 0xFFFF },
	{ 0x042F, CODEPAGE_ISUPPER, 0x044F, 0xFFFF },
	{ 0x0430, CODEPAGE_ISLOWER, 0xFFFF, 0x0410 },
	{ 0x0431, CODEPAGE_ISLOWER, 0xFFFF, 0x0411 },
	{ 0x0432, CODEPAGE_ISLOWER, 0xFFFF, 0x0412 },
	{ 0x0433, CODEPAGE_ISLOWER, 0xFFFF, 0x0413 },
	{ 0x0434, CODEPAGE_ISLOWER, 0xFFFF, 0x0414 },
	{ 0x0435, CODEPAGE_ISLOWER, 0xFFFF, 0x0415 },
	{ 0x0436, CODEPAGE_ISLOWER, 0xFFFF, 0x0416 },
	{ 0x0437, CODEPAGE_ISLOWER, 0xFFFF, 0x0417 },
	{ 0x0438, CODEPAGE_ISLOWER, 0xFFFF, 0x0418 },
	{ 0x0439, CODEPAGE_ISLOWER, 0xFFFF, 0x0419 },
	{ 0x043A, CODEPAGE_ISLOWER, 0xFFFF, 0x041A },
	{ 0x043B, CODEPAGE_ISLOWER, 0xFFFF, 0x041B },
	{ 0x043C, CODEPAGE_ISLOWER, 0xFFFF, 0x041C },
	{ 0x043D, CODEPAGE_ISLOWER, 0xFFFF, 0x041D },
	{ 0x043E, CODEPAGE_ISLOWER, 0xFFFF, 0x041E },
	{ 0x043F, CODEPAGE_ISLOWER, 0xFFFF, 0x041F },
	{ 0x0440, CODEPAGE_ISLOWER, 0xFFFF, 0x0420 },
	{ 0x0441, CODEPAGE_ISLOWER, 0xFFFF, 0x0421 },
	{ 0x0442, CODEPAGE_ISLOWER, 0xFFFF, 0x0422 },
	{ 0x0443, CODEPAGE_ISLOWER, 0xFFFF, 0x0423 },
	{ 0x0444, CODEPAGE_ISLOWER, 0xFFFF, 0x0424 },
	{ 0x0445, CODEPAGE_ISLOWER, 0xFFFF, 0x0425 },
	{ 0x0446, CODEPAGE_ISLOWER, 0xFFFF, 0x0426 },
	{ 0x0447, CODEPAGE_ISLOWER, 0xFFFF, 0x0427 },
	{ 0x0448, CODEPAGE_ISLOWER, 0xFFFF, 0x0428 },
	{ 0x0449, CODEPAGE_ISLOWER, 0xFFFF, 0x0429 },
	{ 0x044A, CODEPAGE_ISLOWER, 0xFFFF, 0x042A },
	{ 0x044B, CODEPAGE_ISLOWER, 0xFFFF, 0x042B },
	{ 0x044C, CODEPAGE_ISLOWER, 0xFFFF, 0x042C },
	{ 0x044D, CODEPAGE_ISLOWER, 0xFFFF, 0x042D },
	{ 0x044E, CODEPAGE_ISLOWER, 0xFFFF, 0x042E },
	{ 0x044F, CODEPAGE_ISLOWER, 0xFFFF, 0x042F },
	{ 0x0451, CODEPAGE_ISLOWER, 0xFFFF, 0x0401 },
	{ 0x0452, CODEPAGE_ISLOWER, 0xFFFF, 0x0402 },
	{ 0x0453, CODEPAGE_ISLOWER, 0xFFFF, 0x0403 },
	{ 0x0454, CODEPAGE_ISLOWER, 0xFFFF, 0x0404 },
	{ 0x0455, CODEPAGE_ISLOWER, 0xFFFF, 0x0405 },
	{ 0x0456, CODEPAGE_ISLOWER, 0xFFFF, 0x0406 },
	{ 0x0457, CODEPAGE_ISLOWER, 0xFFFF, 0x0407 },
	{ 0x0458, CODEPAGE_ISLOWER, 0xFFFF, 0x0408 },
	{ 0x0459, CODEPAGE_ISLOWER, 0xFFFF, 0x0409 },
	{ 0x045A, CODEPAGE_ISLOWER, 0xFFFF, 0x040A },
	{ 0x045B, CODEPAGE_ISLOWER, 0xFFFF, 0x040B },
	{ 0x045C, CODEPAGE_ISLOWER, 0xFFFF, 0x040C },
	{ 0x045E, CODEPAGE_ISLOWER, 0xFFFF, 0x040E },
	{ 0x045F, CODEPAGE_ISLOWER, 0xFFFF, 0x040F },
	{ 0x0460, CODEPAGE_ISUPPER, 0x0461, 0xFFFF },
	{ 0x0461, CODEPAGE_ISLOWER, 0xFFFF, 0x0460 },
	{ 0x0462, CODEPAGE_ISUPPER, 0x0463, 0xFFFF },
	{ 0x0463, CODEPAGE_ISLOWER, 0xFFFF, 0x0462 },
	{ 0x0464, CODEPAGE_ISUPPER, 0x0465, 0xFFFF },
	{ 0x0465, CODEPAGE_ISLOWER, 0xFFFF, 0x0464 },
	{ 0x0466, CODEPAGE_ISUPPER, 0x0467, 0xFFFF },
	{ 0x0467, CODEPAGE_ISLOWER, 0xFFFF, 0x0466 },
	{ 0x0468, CODEPAGE_ISUPPER, 0x0469, 0xFFFF },
	{ 0x0469, CODEPAGE_ISLOWER, 0xFFFF, 0x0468 },
	{ 0x046A, CODEPAGE_ISUPPER, 0x046B, 0xFFFF },
	{ 0x046B, CODEPAGE_ISLOWER, 0xFFFF, 0x046A },
	{ 0x046C, CODEPAGE_ISUPPER, 0x046D, 0xFFFF },
	{ 0x046D, CODEPAGE_ISLOWER, 0xFFFF, 0x046C },
	{ 0x046E, CODEPAGE_ISUPPER, 0x046F, 0xFFFF },
	{ 0x046F, CODEPAGE_ISLOWER, 0xFFFF, 0x046E },
	{ 0x0470, CODEPAGE_ISUPPER, 0x0471, 0xFFFF },
	{ 0x0471, CODEPAGE_ISLOWER, 0xFFFF, 0x0470 },
	{ 0x0472, CODEPAGE_ISUPPER, 0x0473, 0xFFFF },
	{ 0x0473, CODEPAGE_ISLOWER, 0xFFFF, 0x0472 },
	{ 0x0474, CODEPAGE_ISUPPER, 0x0475, 0xFFFF },
	{ 0x0475, CODEPAGE_ISLOWER, 0xFFFF, 0x0474 },
	{ 0x0476, CODEPAGE_ISUPPER, 0x0477, 0xFFFF },
	{ 0x0477, CODEPAGE_ISLOWER, 0xFFFF, 0x0476 },
	{ 0x0478, CODEPAGE_ISUPPER, 0x0479, 0xFFFF },
	{ 0x0479, CODEPAGE_ISLOWER, 0xFFFF, 0x0478 },
	{ 0x047A, CODEPAGE_ISUPPER, 0x047B, 0xFFFF },
	{ 0x047B, CODEPAGE_ISLOWER, 0xFFFF, 0x047A },
	{ 0x047C, CODEPAGE_ISUPPER, 0x047D, 0xFFFF },
	{ 0x047D, CODEPAGE_ISLOWER, 0xFFFF, 0x047C },
	{ 0x047E, CODEPAGE_ISUPPER, 0x047F, 0xFFFF },
	{ 0x047F, CODEPAGE_ISLOWER, 0xFFFF, 0x047E },
	{ 0x0480, CODEPAGE_ISUPPER, 0x0481, 0xFFFF },
	{ 0x0481, CODEPAGE_ISLOWER, 0xFFFF, 0x0480 },
	{ 0x0482, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0483, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0484, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0485, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0486, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0490, CODEPAGE_ISUPPER, 0x0491, 0xFFFF },
	{ 0x0491, CODEPAGE_ISLOWER, 0xFFFF, 0x0490 },
	{ 0x0492, CODEPAGE_ISUPPER, 0x0493, 0xFFFF },
	{ 0x0493, CODEPAGE_ISLOWER, 0xFFFF, 0x0492 },
	{ 0x0494, CODEPAGE_ISUPPER, 0x0495, 0xFFFF },
	{ 0x0495, CODEPAGE_ISLOWER, 0xFFFF, 0x0494 },
	{ 0x0496, CODEPAGE_ISUPPER, 0x0497, 0xFFFF },
	{ 0x0497, CODEPAGE_ISLOWER, 0xFFFF, 0x0496 },
	{ 0x0498, CODEPAGE_ISUPPER, 0x0499, 0xFFFF },
	{ 0x0499, CODEPAGE_ISLOWER, 0xFFFF, 0x0498 },
	{ 0x049A, CODEPAGE_ISUPPER, 0x049B, 0xFFFF },
	{ 0x049B, CODEPAGE_ISLOWER, 0xFFFF, 0x049A },
	{ 0x049C, CODEPAGE_ISUPPER, 0x049D, 0xFFFF },
	{ 0x049D, CODEPAGE_ISLOWER, 0xFFFF, 0x049C },
	{ 0x049E, CODEPAGE_ISUPPER, 0x049F, 0xFFFF },
	{ 0x049F, CODEPAGE_ISLOWER, 0xFFFF, 0x049E },
	{ 0x04A0, CODEPAGE_ISUPPER, 0x04A1, 0xFFFF },
	{ 0x04A1, CODEPAGE_ISLOWER, 0xFFFF, 0x04A0 },
	{ 0x04A2, CODEPAGE_ISUPPER, 0x04A3, 0xFFFF },
	{ 0x04A3, CODEPAGE_ISLOWER, 0xFFFF, 0x04A2 },
	{ 0x04A4, CODEPAGE_ISUPPER, 0x04A5, 0xFFFF },
	{ 0x04A5, CODEPAGE_ISLOWER, 0xFFFF, 0x04A4 },
	{ 0x04A6, CODEPAGE_ISUPPER, 0x04A7, 0xFFFF },
	{ 0x04A7, CODEPAGE_ISLOWER, 0xFFFF, 0x04A6 },
	{ 0x04A8, CODEPAGE_ISUPPER, 0x04A9, 0xFFFF },
	{ 0x04A9, CODEPAGE_ISLOWER, 0xFFFF, 0x04A8 },
	{ 0x04AA, CODEPAGE_ISUPPER, 0x04AB, 0xFFFF },
	{ 0x04AB, CODEPAGE_ISLOWER, 0xFFFF, 0x04AA },
	{ 0x04AC, CODEPAGE_ISUPPER, 0x04AD, 0xFFFF },
	{ 0x04AD, CODEPAGE_ISLOWER, 0xFFFF, 0x04AC },
	{ 0x04AE, CODEPAGE_ISUPPER, 0x04AF, 0xFFFF },
	{ 0x04AF, CODEPAGE_ISLOWER, 0xFFFF, 0x04AE },
	{ 0x04B0, CODEPAGE_ISUPPER, 0x04B1, 0xFFFF },
	{ 0x04B1, CODEPAGE_ISLOWER, 0xFFFF, 0x04B0 },
	{ 0x04B2, CODEPAGE_ISUPPER, 0x04B3, 0xFFFF },
	{ 0x04B3, CODEPAGE_ISLOWER, 0xFFFF, 0x04B2 },
	{ 0x04B4, CODEPAGE_ISUPPER, 0x04B5, 0xFFFF },
	{ 0x04B5, CODEPAGE_ISLOWER, 0xFFFF, 0x04B4 },
	{ 0x04B6, CODEPAGE_ISUPPER, 0x04B7, 0xFFFF },
	{ 0x04B7, CODEPAGE_ISLOWER, 0xFFFF, 0x04B6 },
	{ 0x04B8, CODEPAGE_ISUPPER, 0x04B9, 0xFFFF },
	{ 0x04B9, CODEPAGE_ISLOWER, 0xFFFF, 0x04B8 },
	{ 0x04BA, CODEPAGE_ISUPPER, 0x04BB, 0xFFFF },
	{ 0x04BB, CODEPAGE_ISLOWER, 0xFFFF, 0x04BA },
	{ 0x04BC, CODEPAGE_ISUPPER, 0x04BD, 0xFFFF },
	{ 0x04BD, CODEPAGE_ISLOWER, 0xFFFF, 0x04BC },
	{ 0x04BE, CODEPAGE_ISUPPER, 0x04BF, 0xFFFF },
	{ 0x04BF, CODEPAGE_ISLOWER, 0xFFFF, 0x04BE },
	{ 0x04C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x04C1, CODEPAGE_ISUPPER, 0x04C2, 0xFFFF },
	{ 0x04C2, CODEPAGE_ISLOWER, 0xFFFF, 0x04C1 },
	{ 0x04C3, CODEPAGE_ISUPPER, 0x04C4, 0xFFFF },
	{ 0x04C4, CODEPAGE_ISLOWER, 0xFFFF, 0x04C3 },
	{ 0x04C7, CODEPAGE_ISUPPER, 0x04C8, 0xFFFF },
	{ 0x04C8, CODEPAGE_ISLOWER, 0xFFFF, 0x04C7 },
	{ 0x04CB, CODEPAGE_ISUPPER, 0x04CC, 0xFFFF },
	{ 0x04CC, CODEPAGE_ISLOWER, 0xFFFF, 0x04CB },
	{ 0x04D0, CODEPAGE_ISUPPER, 0x04D1, 0xFFFF },
	{ 0x04D1, CODEPAGE_ISLOWER, 0xFFFF, 0x04D0 },
	{ 0x04D2, CODEPAGE_ISUPPER, 0x04D3, 0xFFFF },
	{ 0x04D3, CODEPAGE_ISLOWER, 0xFFFF, 0x04D2 },
	{ 0x04D4, CODEPAGE_ISUPPER, 0x04D5, 0xFFFF },
	{ 0x04D5, CODEPAGE_ISLOWER, 0xFFFF, 0x04D4 },
	{ 0x04D6, CODEPAGE_ISUPPER, 0x04D7, 0xFFFF },
	{ 0x04D7, CODEPAGE_ISLOWER, 0xFFFF, 0x04D6 },
	{ 0x04D8, CODEPAGE_ISUPPER, 0x04D9, 0xFFFF },
	{ 0x04D9, CODEPAGE_ISLOWER, 0xFFFF, 0x04D8 },
	{ 0x04DA, CODEPAGE_ISUPPER, 0x04DB, 0xFFFF },
	{ 0x04DB, CODEPAGE_ISLOWER, 0xFFFF, 0x04DA },
	{ 0x04DC, CODEPAGE_ISUPPER, 0x04DD, 0xFFFF },
	{ 0x04DD, CODEPAGE_ISLOWER, 0xFFFF, 0x04DC },
	{ 0x04DE, CODEPAGE_ISUPPER, 0x04DF, 0xFFFF },
	{ 0x04DF, CODEPAGE_ISLOWER, 0xFFFF, 0x04DE },
	{ 0x04E0, CODEPAGE_ISUPPER, 0x04E1, 0xFFFF },
	{ 0x04E1, CODEPAGE_ISLOWER, 0xFFFF, 0x04E0 },
	{ 0x04E2, CODEPAGE_ISUPPER, 0x04E3, 0xFFFF },
	{ 0x04E3, CODEPAGE_ISLOWER, 0xFFFF, 0x04E2 },
	{ 0x04E4, CODEPAGE_ISUPPER, 0x04E5, 0xFFFF },
	{ 0x04E5, CODEPAGE_ISLOWER, 0xFFFF, 0x04E4 },
	{ 0x04E6, CODEPAGE_ISUPPER, 0x04E7, 0xFFFF },
	{ 0x04E7, CODEPAGE_ISLOWER, 0xFFFF, 0x04E6 },
	{ 0x04E8, CODEPAGE_ISUPPER, 0x04E9, 0xFFFF },
	{ 0x04E9, CODEPAGE_ISLOWER, 0xFFFF, 0x04E8 },
	{ 0x04EA, CODEPAGE_ISUPPER, 0x04EB, 0xFFFF },
	{ 0x04EB, CODEPAGE_ISLOWER, 0xFFFF, 0x04EA },
	{ 0x04EE, CODEPAGE_ISUPPER, 0x04EF, 0xFFFF },
	{ 0x04EF, CODEPAGE_ISLOWER, 0xFFFF, 0x04EE },
	{ 0x04F0, CODEPAGE_ISUPPER, 0x04F1, 0xFFFF },
	{ 0x04F1, CODEPAGE_ISLOWER, 0xFFFF, 0x04F0 },
	{ 0x04F2, CODEPAGE_ISUPPER, 0x04F3, 0xFFFF },
	{ 0x04F3, CODEPAGE_ISLOWER, 0xFFFF, 0x04F2 },
	{ 0x04F4, CODEPAGE_ISUPPER, 0x04F5, 0xFFFF },
	{ 0x04F5, CODEPAGE_ISLOWER, 0xFFFF, 0x04F4 },
	{ 0x04F8, CODEPAGE_ISUPPER, 0x04F9, 0xFFFF },
	{ 0x04F9, CODEPAGE_ISLOWER, 0xFFFF, 0x04F8 },
	{ 0x0531, CODEPAGE_ISUPPER, 0x0561, 0xFFFF },
	{ 0x0532, CODEPAGE_ISUPPER, 0x0562, 0xFFFF },
	{ 0x0533, CODEPAGE_ISUPPER, 0x0563, 0xFFFF },
	{ 0x0534, CODEPAGE_ISUPPER, 0x0564, 0xFFFF },
	{ 0x0535, CODEPAGE_ISUPPER, 0x0565, 0xFFFF },
	{ 0x0536, CODEPAGE_ISUPPER, 0x0566, 0xFFFF },
	{ 0x0537, CODEPAGE_ISUPPER, 0x0567, 0xFFFF },
	{ 0x0538, CODEPAGE_ISUPPER, 0x0568, 0xFFFF },
	{ 0x0539, CODEPAGE_ISUPPER, 0x0569, 0xFFFF },
	{ 0x053A, CODEPAGE_ISUPPER, 0x056A, 0xFFFF },
	{ 0x053B, CODEPAGE_ISUPPER, 0x056B, 0xFFFF },
	{ 0x053C, CODEPAGE_ISUPPER, 0x056C, 0xFFFF },
	{ 0x053D, CODEPAGE_ISUPPER, 0x056D, 0xFFFF },
	{ 0x053E, CODEPAGE_ISUPPER, 0x056E, 0xFFFF },
	{ 0x053F, CODEPAGE_ISUPPER, 0x056F, 0xFFFF },
	{ 0x0540, CODEPAGE_ISUPPER, 0x0570, 0xFFFF },
	{ 0x0541, CODEPAGE_ISUPPER, 0x0571, 0xFFFF },
	{ 0x0542, CODEPAGE_ISUPPER, 0x0572, 0xFFFF },
	{ 0x0543, CODEPAGE_ISUPPER, 0x0573, 0xFFFF },
	{ 0x0544, CODEPAGE_ISUPPER, 0x0574, 0xFFFF },
	{ 0x0545, CODEPAGE_ISUPPER, 0x0575, 0xFFFF },
	{ 0x0546, CODEPAGE_ISUPPER, 0x0576, 0xFFFF },
	{ 0x0547, CODEPAGE_ISUPPER, 0x0577, 0xFFFF },
	{ 0x0548, CODEPAGE_ISUPPER, 0x0578, 0xFFFF },
	{ 0x0549, CODEPAGE_ISUPPER, 0x0579, 0xFFFF },
	{ 0x054A, CODEPAGE_ISUPPER, 0x057A, 0xFFFF },
	{ 0x054B, CODEPAGE_ISUPPER, 0x057B, 0xFFFF },
	{ 0x054C, CODEPAGE_ISUPPER, 0x057C, 0xFFFF },
	{ 0x054D, CODEPAGE_ISUPPER, 0x057D, 0xFFFF },
	{ 0x054E, CODEPAGE_ISUPPER, 0x057E, 0xFFFF },
	{ 0x054F, CODEPAGE_ISUPPER, 0x057F, 0xFFFF },
	{ 0x0550, CODEPAGE_ISUPPER, 0x0580, 0xFFFF },
	{ 0x0551, CODEPAGE_ISUPPER, 0x0581, 0xFFFF },
	{ 0x0552, CODEPAGE_ISUPPER, 0x0582, 0xFFFF },
	{ 0x0553, CODEPAGE_ISUPPER, 0x0583, 0xFFFF },
	{ 0x0554, CODEPAGE_ISUPPER, 0x0584, 0xFFFF },
	{ 0x0555, CODEPAGE_ISUPPER, 0x0585, 0xFFFF },
	{ 0x0556, CODEPAGE_ISUPPER, 0x0586, 0xFFFF },
	{ 0x0559, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x055A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x055B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x055C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x055D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x055E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x055F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0561, CODEPAGE_ISLOWER, 0xFFFF, 0x0531 },
	{ 0x0562, CODEPAGE_ISLOWER, 0xFFFF, 0x0532 },
	{ 0x0563, CODEPAGE_ISLOWER, 0xFFFF, 0x0533 },
	{ 0x0564, CODEPAGE_ISLOWER, 0xFFFF, 0x0534 },
	{ 0x0565, CODEPAGE_ISLOWER, 0xFFFF, 0x0535 },
	{ 0x0566, CODEPAGE_ISLOWER, 0xFFFF, 0x0536 },
	{ 0x0567, CODEPAGE_ISLOWER, 0xFFFF, 0x0537 },
	{ 0x0568, CODEPAGE_ISLOWER, 0xFFFF, 0x0538 },
	{ 0x0569, CODEPAGE_ISLOWER, 0xFFFF, 0x0539 },
	{ 0x056A, CODEPAGE_ISLOWER, 0xFFFF, 0x053A },
	{ 0x056B, CODEPAGE_ISLOWER, 0xFFFF, 0x053B },
	{ 0x056C, CODEPAGE_ISLOWER, 0xFFFF, 0x053C },
	{ 0x056D, CODEPAGE_ISLOWER, 0xFFFF, 0x053D },
	{ 0x056E, CODEPAGE_ISLOWER, 0xFFFF, 0x053E },
	{ 0x056F, CODEPAGE_ISLOWER, 0xFFFF, 0x053F },
	{ 0x0570, CODEPAGE_ISLOWER, 0xFFFF, 0x0540 },
	{ 0x0571, CODEPAGE_ISLOWER, 0xFFFF, 0x0541 },
	{ 0x0572, CODEPAGE_ISLOWER, 0xFFFF, 0x0542 },
	{ 0x0573, CODEPAGE_ISLOWER, 0xFFFF, 0x0543 },
	{ 0x0574, CODEPAGE_ISLOWER, 0xFFFF, 0x0544 },
	{ 0x0575, CODEPAGE_ISLOWER, 0xFFFF, 0x0545 },
	{ 0x0576, CODEPAGE_ISLOWER, 0xFFFF, 0x0546 },
	{ 0x0577, CODEPAGE_ISLOWER, 0xFFFF, 0x0547 },
	{ 0x0578, CODEPAGE_ISLOWER, 0xFFFF, 0x0548 },
	{ 0x0579, CODEPAGE_ISLOWER, 0xFFFF, 0x0549 },
	{ 0x057A, CODEPAGE_ISLOWER, 0xFFFF, 0x054A },
	{ 0x057B, CODEPAGE_ISLOWER, 0xFFFF, 0x054B },
	{ 0x057C, CODEPAGE_ISLOWER, 0xFFFF, 0x054C },
	{ 0x057D, CODEPAGE_ISLOWER, 0xFFFF, 0x054D },
	{ 0x057E, CODEPAGE_ISLOWER, 0xFFFF, 0x054E },
	{ 0x057F, CODEPAGE_ISLOWER, 0xFFFF, 0x054F },
	{ 0x0580, CODEPAGE_ISLOWER, 0xFFFF, 0x0550 },
	{ 0x0581, CODEPAGE_ISLOWER, 0xFFFF, 0x0551 },
	{ 0x0582, CODEPAGE_ISLOWER, 0xFFFF, 0x0552 },
	{ 0x0583, CODEPAGE_ISLOWER, 0xFFFF, 0x0553 },
	{ 0x0584, CODEPAGE_ISLOWER, 0xFFFF, 0x0554 },
	{ 0x0585, CODEPAGE_ISLOWER, 0xFFFF, 0x0555 },
	{ 0x0586, CODEPAGE_ISLOWER, 0xFFFF, 0x0556 },
	{ 0x0587, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x0589, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0591, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0592, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0593, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0594, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0595, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0596, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0597, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0598, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0599, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x059A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x059B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x059C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x059D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x059E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x059F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x05F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x060C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x061B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x061F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0621, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0622, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0623, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0624, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0625, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0626, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0627, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0628, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0629, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x062A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x062B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x062C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x062D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x062E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x062F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0630, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0631, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0632, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0633, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0634, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0635, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0636, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0637, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0638, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0639, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x063A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0640, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0641, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0642, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0643, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0644, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0645, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0646, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0647, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0648, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0649, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x064A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x064B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x064C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x064D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x064E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x064F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0650, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0651, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0652, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0660, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0661, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0662, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0663, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0664, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0665, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0666, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0667, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0668, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0669, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x066A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x066B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x066C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x066D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0670, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0671, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0672, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0673, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0674, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0675, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0676, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0677, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0678, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0679, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x067A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x067B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x067C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x067D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x067E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x067F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0680, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0681, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0682, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0683, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0684, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0685, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0686, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0687, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0688, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0689, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x068A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x068B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x068C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x068D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x068E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x068F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0690, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0691, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0692, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0693, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0694, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0695, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0696, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0697, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0698, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0699, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x069A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x069B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x069C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x069D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x069E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x069F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x06F9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0901, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0902, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0903, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0905, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0906, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0907, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0908, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0909, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x090A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x090B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x090C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x090D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x090E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x090F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0910, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0911, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0912, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0913, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0914, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0915, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0916, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0917, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0918, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0919, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x091A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x091B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x091C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x091D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x091E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x091F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0920, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0921, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0922, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0923, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0924, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0925, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0926, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0927, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0928, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0929, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x092A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x092B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x092C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x092D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x092E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x092F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0930, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0931, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0932, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0933, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0934, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0935, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0936, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0937, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0938, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0939, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x093C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x093D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x093E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x093F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0940, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0941, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0942, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0943, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0944, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0945, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0946, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0947, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0948, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0949, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x094A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x094B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x094C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x094D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0950, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0951, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0952, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0953, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0954, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0958, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0959, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x095A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x095B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x095C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x095D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x095E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x095F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0960, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0961, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0962, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0963, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0964, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0965, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0966, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0967, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0968, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0969, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x096A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x096B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x096C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x096D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x096E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x096F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0970, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0981, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0982, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0983, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0985, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0986, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0987, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0988, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0989, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x098A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x098B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x098C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x098F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0990, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0993, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0994, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0995, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0996, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0997, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0998, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0999, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x099A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x099B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x099C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x099D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x099E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x099F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09F9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x09FA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A73, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A91, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0A9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ABC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ABD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ABE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ABF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AC9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ACB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ACC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ACD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AD0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AE0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AE6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AE7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0AEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B3D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B5F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0B9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BBE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BBF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BC8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BCA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BCB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BCC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BCD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BD7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BE7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BF0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BF1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0BF2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C44, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C46, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C8C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0C9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CBE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CBF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CC8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CCA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CCB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CCC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CCD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CD5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CD6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CDE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CE0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CE1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CE6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CE7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0CEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D46, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0D6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E04, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E0D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E11, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E29, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E3A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E44, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E45, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E46, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E49, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E4E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E4F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E50, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E51, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E52, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E53, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E54, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E58, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0E9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EBB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EBC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EBD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EC9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ECA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ECB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ECC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ECD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0ED9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EDC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0EDD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F00, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F04, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F0D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F11, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F29, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F3A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F3B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F3D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F44, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F45, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F46, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F49, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F4E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F4F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F50, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F51, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F52, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F53, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F54, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F58, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F5F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F62, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F63, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F64, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F65, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F73, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F75, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F76, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F77, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F78, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F79, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F7A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F7B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F7C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F7D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F7E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F91, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0F9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x0FB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x10A0, CODEPAGE_ISUPPER, 0x10D0, 0xFFFF },
	{ 0x10A1, CODEPAGE_ISUPPER, 0x10D1, 0xFFFF },
	{ 0x10A2, CODEPAGE_ISUPPER, 0x10D2, 0xFFFF },
	{ 0x10A3, CODEPAGE_ISUPPER, 0x10D3, 0xFFFF },
	{ 0x10A4, CODEPAGE_ISUPPER, 0x10D4, 0xFFFF },
	{ 0x10A5, CODEPAGE_ISUPPER, 0x10D5, 0xFFFF },
	{ 0x10A6, CODEPAGE_ISUPPER, 0x10D6, 0xFFFF },
	{ 0x10A7, CODEPAGE_ISUPPER, 0x10D7, 0xFFFF },
	{ 0x10A8, CODEPAGE_ISUPPER, 0x10D8, 0xFFFF },
	{ 0x10A9, CODEPAGE_ISUPPER, 0x10D9, 0xFFFF },
	{ 0x10AA, CODEPAGE_ISUPPER, 0x10DA, 0xFFFF },
	{ 0x10AB, CODEPAGE_ISUPPER, 0x10DB, 0xFFFF },
	{ 0x10AC, CODEPAGE_ISUPPER, 0x10DC, 0xFFFF },
	{ 0x10AD, CODEPAGE_ISUPPER, 0x10DD, 0xFFFF },
	{ 0x10AE, CODEPAGE_ISUPPER, 0x10DE, 0xFFFF },
	{ 0x10AF, CODEPAGE_ISUPPER, 0x10DF, 0xFFFF },
	{ 0x10B0, CODEPAGE_ISUPPER, 0x10E0, 0xFFFF },
	{ 0x10B1, CODEPAGE_ISUPPER, 0x10E1, 0xFFFF },
	{ 0x10B2, CODEPAGE_ISUPPER, 0x10E2, 0xFFFF },
	{ 0x10B3, CODEPAGE_ISUPPER, 0x10E3, 0xFFFF },
	{ 0x10B4, CODEPAGE_ISUPPER, 0x10E4, 0xFFFF },
	{ 0x10B5, CODEPAGE_ISUPPER, 0x10E5, 0xFFFF },
	{ 0x10B6, CODEPAGE_ISUPPER, 0x10E6, 0xFFFF },
	{ 0x10B7, CODEPAGE_ISUPPER, 0x10E7, 0xFFFF },
	{ 0x10B8, CODEPAGE_ISUPPER, 0x10E8, 0xFFFF },
	{ 0x10B9, CODEPAGE_ISUPPER, 0x10E9, 0xFFFF },
	{ 0x10BA, CODEPAGE_ISUPPER, 0x10EA, 0xFFFF },
	{ 0x10BB, CODEPAGE_ISUPPER, 0x10EB, 0xFFFF },
	{ 0x10BC, CODEPAGE_ISUPPER, 0x10EC, 0xFFFF },
	{ 0x10BD, CODEPAGE_ISUPPER, 0x10ED, 0xFFFF },
	{ 0x10BE, CODEPAGE_ISUPPER, 0x10EE, 0xFFFF },
	{ 0x10BF, CODEPAGE_ISUPPER, 0x10EF, 0xFFFF },
	{ 0x10C0, CODEPAGE_ISUPPER, 0x10F0, 0xFFFF },
	{ 0x10C1, CODEPAGE_ISUPPER, 0x10F1, 0xFFFF },
	{ 0x10C2, CODEPAGE_ISUPPER, 0x10F2, 0xFFFF },
	{ 0x10C3, CODEPAGE_ISUPPER, 0x10F3, 0xFFFF },
	{ 0x10C4, CODEPAGE_ISUPPER, 0x10F4, 0xFFFF },
	{ 0x10C5, CODEPAGE_ISUPPER, 0x10F5, 0xFFFF },
	{ 0x10D0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D8, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10D9, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10DA, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10DB, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10DC, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10DD, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10DE, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10DF, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E8, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10E9, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10EA, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10EB, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10EC, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10ED, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10EE, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10EF, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10F6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x10FB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1100, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1101, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1102, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1103, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1104, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1105, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1106, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1107, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1108, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1109, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x110A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x110B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x110C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x110D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x110E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x110F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1110, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1111, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1112, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1113, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1114, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1115, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1116, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1117, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1118, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1119, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x111A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x111B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x111C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x111D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x111E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x111F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1120, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1121, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1122, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1123, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1124, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1125, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1126, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1127, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1128, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1129, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x112A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x112B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x112C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x112D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x112E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x112F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1130, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1131, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1132, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1133, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1134, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1135, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1136, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1137, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1138, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1139, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x113A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x113B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x113C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x113D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x113E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x113F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1140, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1141, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1142, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1143, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1144, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1145, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1146, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1147, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1148, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1149, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x114A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x114B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x114C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x114D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x114E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x114F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1150, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1151, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1152, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1153, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1154, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1155, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1156, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1157, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1158, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1159, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x115F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1160, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1161, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1162, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1163, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1164, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1165, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1166, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1167, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1168, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1169, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x116A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x116B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x116C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x116D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x116E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x116F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1170, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1171, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1172, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1173, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1174, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1175, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1176, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1177, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1178, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1179, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x117A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x117B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x117C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x117D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x117E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x117F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1180, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1181, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1182, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1183, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1184, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1185, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1186, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1187, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1188, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1189, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x118A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x118B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x118C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x118D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x118E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x118F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1190, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1191, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1192, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1193, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1194, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1195, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1196, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1197, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1198, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1199, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x119A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x119B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x119C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x119D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x119E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x119F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11CF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x11F9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1E00, CODEPAGE_ISUPPER, 0x1E01, 0xFFFF },
	{ 0x1E01, CODEPAGE_ISLOWER, 0xFFFF, 0x1E00 },
	{ 0x1E02, CODEPAGE_ISUPPER, 0x1E03, 0xFFFF },
	{ 0x1E03, CODEPAGE_ISLOWER, 0xFFFF, 0x1E02 },
	{ 0x1E04, CODEPAGE_ISUPPER, 0x1E05, 0xFFFF },
	{ 0x1E05, CODEPAGE_ISLOWER, 0xFFFF, 0x1E04 },
	{ 0x1E06, CODEPAGE_ISUPPER, 0x1E07, 0xFFFF },
	{ 0x1E07, CODEPAGE_ISLOWER, 0xFFFF, 0x1E06 },
	{ 0x1E08, CODEPAGE_ISUPPER, 0x1E09, 0xFFFF },
	{ 0x1E09, CODEPAGE_ISLOWER, 0xFFFF, 0x1E08 },
	{ 0x1E0A, CODEPAGE_ISUPPER, 0x1E0B, 0xFFFF },
	{ 0x1E0B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E0A },
	{ 0x1E0C, CODEPAGE_ISUPPER, 0x1E0D, 0xFFFF },
	{ 0x1E0D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E0C },
	{ 0x1E0E, CODEPAGE_ISUPPER, 0x1E0F, 0xFFFF },
	{ 0x1E0F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E0E },
	{ 0x1E10, CODEPAGE_ISUPPER, 0x1E11, 0xFFFF },
	{ 0x1E11, CODEPAGE_ISLOWER, 0xFFFF, 0x1E10 },
	{ 0x1E12, CODEPAGE_ISUPPER, 0x1E13, 0xFFFF },
	{ 0x1E13, CODEPAGE_ISLOWER, 0xFFFF, 0x1E12 },
	{ 0x1E14, CODEPAGE_ISUPPER, 0x1E15, 0xFFFF },
	{ 0x1E15, CODEPAGE_ISLOWER, 0xFFFF, 0x1E14 },
	{ 0x1E16, CODEPAGE_ISUPPER, 0x1E17, 0xFFFF },
	{ 0x1E17, CODEPAGE_ISLOWER, 0xFFFF, 0x1E16 },
	{ 0x1E18, CODEPAGE_ISUPPER, 0x1E19, 0xFFFF },
	{ 0x1E19, CODEPAGE_ISLOWER, 0xFFFF, 0x1E18 },
	{ 0x1E1A, CODEPAGE_ISUPPER, 0x1E1B, 0xFFFF },
	{ 0x1E1B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E1A },
	{ 0x1E1C, CODEPAGE_ISUPPER, 0x1E1D, 0xFFFF },
	{ 0x1E1D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E1C },
	{ 0x1E1E, CODEPAGE_ISUPPER, 0x1E1F, 0xFFFF },
	{ 0x1E1F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E1E },
	{ 0x1E20, CODEPAGE_ISUPPER, 0x1E21, 0xFFFF },
	{ 0x1E21, CODEPAGE_ISLOWER, 0xFFFF, 0x1E20 },
	{ 0x1E22, CODEPAGE_ISUPPER, 0x1E23, 0xFFFF },
	{ 0x1E23, CODEPAGE_ISLOWER, 0xFFFF, 0x1E22 },
	{ 0x1E24, CODEPAGE_ISUPPER, 0x1E25, 0xFFFF },
	{ 0x1E25, CODEPAGE_ISLOWER, 0xFFFF, 0x1E24 },
	{ 0x1E26, CODEPAGE_ISUPPER, 0x1E27, 0xFFFF },
	{ 0x1E27, CODEPAGE_ISLOWER, 0xFFFF, 0x1E26 },
	{ 0x1E28, CODEPAGE_ISUPPER, 0x1E29, 0xFFFF },
	{ 0x1E29, CODEPAGE_ISLOWER, 0xFFFF, 0x1E28 },
	{ 0x1E2A, CODEPAGE_ISUPPER, 0x1E2B, 0xFFFF },
	{ 0x1E2B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E2A },
	{ 0x1E2C, CODEPAGE_ISUPPER, 0x1E2D, 0xFFFF },
	{ 0x1E2D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E2C },
	{ 0x1E2E, CODEPAGE_ISUPPER, 0x1E2F, 0xFFFF },
	{ 0x1E2F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E2E },
	{ 0x1E30, CODEPAGE_ISUPPER, 0x1E31, 0xFFFF },
	{ 0x1E31, CODEPAGE_ISLOWER, 0xFFFF, 0x1E30 },
	{ 0x1E32, CODEPAGE_ISUPPER, 0x1E33, 0xFFFF },
	{ 0x1E33, CODEPAGE_ISLOWER, 0xFFFF, 0x1E32 },
	{ 0x1E34, CODEPAGE_ISUPPER, 0x1E35, 0xFFFF },
	{ 0x1E35, CODEPAGE_ISLOWER, 0xFFFF, 0x1E34 },
	{ 0x1E36, CODEPAGE_ISUPPER, 0x1E37, 0xFFFF },
	{ 0x1E37, CODEPAGE_ISLOWER, 0xFFFF, 0x1E36 },
	{ 0x1E38, CODEPAGE_ISUPPER, 0x1E39, 0xFFFF },
	{ 0x1E39, CODEPAGE_ISLOWER, 0xFFFF, 0x1E38 },
	{ 0x1E3A, CODEPAGE_ISUPPER, 0x1E3B, 0xFFFF },
	{ 0x1E3B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E3A },
	{ 0x1E3C, CODEPAGE_ISUPPER, 0x1E3D, 0xFFFF },
	{ 0x1E3D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E3C },
	{ 0x1E3E, CODEPAGE_ISUPPER, 0x1E3F, 0xFFFF },
	{ 0x1E3F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E3E },
	{ 0x1E40, CODEPAGE_ISUPPER, 0x1E41, 0xFFFF },
	{ 0x1E41, CODEPAGE_ISLOWER, 0xFFFF, 0x1E40 },
	{ 0x1E42, CODEPAGE_ISUPPER, 0x1E43, 0xFFFF },
	{ 0x1E43, CODEPAGE_ISLOWER, 0xFFFF, 0x1E42 },
	{ 0x1E44, CODEPAGE_ISUPPER, 0x1E45, 0xFFFF },
	{ 0x1E45, CODEPAGE_ISLOWER, 0xFFFF, 0x1E44 },
	{ 0x1E46, CODEPAGE_ISUPPER, 0x1E47, 0xFFFF },
	{ 0x1E47, CODEPAGE_ISLOWER, 0xFFFF, 0x1E46 },
	{ 0x1E48, CODEPAGE_ISUPPER, 0x1E49, 0xFFFF },
	{ 0x1E49, CODEPAGE_ISLOWER, 0xFFFF, 0x1E48 },
	{ 0x1E4A, CODEPAGE_ISUPPER, 0x1E4B, 0xFFFF },
	{ 0x1E4B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E4A },
	{ 0x1E4C, CODEPAGE_ISUPPER, 0x1E4D, 0xFFFF },
	{ 0x1E4D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E4C },
	{ 0x1E4E, CODEPAGE_ISUPPER, 0x1E4F, 0xFFFF },
	{ 0x1E4F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E4E },
	{ 0x1E50, CODEPAGE_ISUPPER, 0x1E51, 0xFFFF },
	{ 0x1E51, CODEPAGE_ISLOWER, 0xFFFF, 0x1E50 },
	{ 0x1E52, CODEPAGE_ISUPPER, 0x1E53, 0xFFFF },
	{ 0x1E53, CODEPAGE_ISLOWER, 0xFFFF, 0x1E52 },
	{ 0x1E54, CODEPAGE_ISUPPER, 0x1E55, 0xFFFF },
	{ 0x1E55, CODEPAGE_ISLOWER, 0xFFFF, 0x1E54 },
	{ 0x1E56, CODEPAGE_ISUPPER, 0x1E57, 0xFFFF },
	{ 0x1E57, CODEPAGE_ISLOWER, 0xFFFF, 0x1E56 },
	{ 0x1E58, CODEPAGE_ISUPPER, 0x1E59, 0xFFFF },
	{ 0x1E59, CODEPAGE_ISLOWER, 0xFFFF, 0x1E58 },
	{ 0x1E5A, CODEPAGE_ISUPPER, 0x1E5B, 0xFFFF },
	{ 0x1E5B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E5A },
	{ 0x1E5C, CODEPAGE_ISUPPER, 0x1E5D, 0xFFFF },
	{ 0x1E5D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E5C },
	{ 0x1E5E, CODEPAGE_ISUPPER, 0x1E5F, 0xFFFF },
	{ 0x1E5F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E5E },
	{ 0x1E60, CODEPAGE_ISUPPER, 0x1E61, 0xFFFF },
	{ 0x1E61, CODEPAGE_ISLOWER, 0xFFFF, 0x1E60 },
	{ 0x1E62, CODEPAGE_ISUPPER, 0x1E63, 0xFFFF },
	{ 0x1E63, CODEPAGE_ISLOWER, 0xFFFF, 0x1E62 },
	{ 0x1E64, CODEPAGE_ISUPPER, 0x1E65, 0xFFFF },
	{ 0x1E65, CODEPAGE_ISLOWER, 0xFFFF, 0x1E64 },
	{ 0x1E66, CODEPAGE_ISUPPER, 0x1E67, 0xFFFF },
	{ 0x1E67, CODEPAGE_ISLOWER, 0xFFFF, 0x1E66 },
	{ 0x1E68, CODEPAGE_ISUPPER, 0x1E69, 0xFFFF },
	{ 0x1E69, CODEPAGE_ISLOWER, 0xFFFF, 0x1E68 },
	{ 0x1E6A, CODEPAGE_ISUPPER, 0x1E6B, 0xFFFF },
	{ 0x1E6B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E6A },
	{ 0x1E6C, CODEPAGE_ISUPPER, 0x1E6D, 0xFFFF },
	{ 0x1E6D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E6C },
	{ 0x1E6E, CODEPAGE_ISUPPER, 0x1E6F, 0xFFFF },
	{ 0x1E6F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E6E },
	{ 0x1E70, CODEPAGE_ISUPPER, 0x1E71, 0xFFFF },
	{ 0x1E71, CODEPAGE_ISLOWER, 0xFFFF, 0x1E70 },
	{ 0x1E72, CODEPAGE_ISUPPER, 0x1E73, 0xFFFF },
	{ 0x1E73, CODEPAGE_ISLOWER, 0xFFFF, 0x1E72 },
	{ 0x1E74, CODEPAGE_ISUPPER, 0x1E75, 0xFFFF },
	{ 0x1E75, CODEPAGE_ISLOWER, 0xFFFF, 0x1E74 },
	{ 0x1E76, CODEPAGE_ISUPPER, 0x1E77, 0xFFFF },
	{ 0x1E77, CODEPAGE_ISLOWER, 0xFFFF, 0x1E76 },
	{ 0x1E78, CODEPAGE_ISUPPER, 0x1E79, 0xFFFF },
	{ 0x1E79, CODEPAGE_ISLOWER, 0xFFFF, 0x1E78 },
	{ 0x1E7A, CODEPAGE_ISUPPER, 0x1E7B, 0xFFFF },
	{ 0x1E7B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E7A },
	{ 0x1E7C, CODEPAGE_ISUPPER, 0x1E7D, 0xFFFF },
	{ 0x1E7D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E7C },
	{ 0x1E7E, CODEPAGE_ISUPPER, 0x1E7F, 0xFFFF },
	{ 0x1E7F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E7E },
	{ 0x1E80, CODEPAGE_ISUPPER, 0x1E81, 0xFFFF },
	{ 0x1E81, CODEPAGE_ISLOWER, 0xFFFF, 0x1E80 },
	{ 0x1E82, CODEPAGE_ISUPPER, 0x1E83, 0xFFFF },
	{ 0x1E83, CODEPAGE_ISLOWER, 0xFFFF, 0x1E82 },
	{ 0x1E84, CODEPAGE_ISUPPER, 0x1E85, 0xFFFF },
	{ 0x1E85, CODEPAGE_ISLOWER, 0xFFFF, 0x1E84 },
	{ 0x1E86, CODEPAGE_ISUPPER, 0x1E87, 0xFFFF },
	{ 0x1E87, CODEPAGE_ISLOWER, 0xFFFF, 0x1E86 },
	{ 0x1E88, CODEPAGE_ISUPPER, 0x1E89, 0xFFFF },
	{ 0x1E89, CODEPAGE_ISLOWER, 0xFFFF, 0x1E88 },
	{ 0x1E8A, CODEPAGE_ISUPPER, 0x1E8B, 0xFFFF },
	{ 0x1E8B, CODEPAGE_ISLOWER, 0xFFFF, 0x1E8A },
	{ 0x1E8C, CODEPAGE_ISUPPER, 0x1E8D, 0xFFFF },
	{ 0x1E8D, CODEPAGE_ISLOWER, 0xFFFF, 0x1E8C },
	{ 0x1E8E, CODEPAGE_ISUPPER, 0x1E8F, 0xFFFF },
	{ 0x1E8F, CODEPAGE_ISLOWER, 0xFFFF, 0x1E8E },
	{ 0x1E90, CODEPAGE_ISUPPER, 0x1E91, 0xFFFF },
	{ 0x1E91, CODEPAGE_ISLOWER, 0xFFFF, 0x1E90 },
	{ 0x1E92, CODEPAGE_ISUPPER, 0x1E93, 0xFFFF },
	{ 0x1E93, CODEPAGE_ISLOWER, 0xFFFF, 0x1E92 },
	{ 0x1E94, CODEPAGE_ISUPPER, 0x1E95, 0xFFFF },
	{ 0x1E95, CODEPAGE_ISLOWER, 0xFFFF, 0x1E94 },
	{ 0x1E96, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1E97, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1E98, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1E99, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1E9A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1E9B, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1EA0, CODEPAGE_ISUPPER, 0x1EA1, 0xFFFF },
	{ 0x1EA1, CODEPAGE_ISLOWER, 0xFFFF, 0x1EA0 },
	{ 0x1EA2, CODEPAGE_ISUPPER, 0x1EA3, 0xFFFF },
	{ 0x1EA3, CODEPAGE_ISLOWER, 0xFFFF, 0x1EA2 },
	{ 0x1EA4, CODEPAGE_ISUPPER, 0x1EA5, 0xFFFF },
	{ 0x1EA5, CODEPAGE_ISLOWER, 0xFFFF, 0x1EA4 },
	{ 0x1EA6, CODEPAGE_ISUPPER, 0x1EA7, 0xFFFF },
	{ 0x1EA7, CODEPAGE_ISLOWER, 0xFFFF, 0x1EA6 },
	{ 0x1EA8, CODEPAGE_ISUPPER, 0x1EA9, 0xFFFF },
	{ 0x1EA9, CODEPAGE_ISLOWER, 0xFFFF, 0x1EA8 },
	{ 0x1EAA, CODEPAGE_ISUPPER, 0x1EAB, 0xFFFF },
	{ 0x1EAB, CODEPAGE_ISLOWER, 0xFFFF, 0x1EAA },
	{ 0x1EAC, CODEPAGE_ISUPPER, 0x1EAD, 0xFFFF },
	{ 0x1EAD, CODEPAGE_ISLOWER, 0xFFFF, 0x1EAC },
	{ 0x1EAE, CODEPAGE_ISUPPER, 0x1EAF, 0xFFFF },
	{ 0x1EAF, CODEPAGE_ISLOWER, 0xFFFF, 0x1EAE },
	{ 0x1EB0, CODEPAGE_ISUPPER, 0x1EB1, 0xFFFF },
	{ 0x1EB1, CODEPAGE_ISLOWER, 0xFFFF, 0x1EB0 },
	{ 0x1EB2, CODEPAGE_ISUPPER, 0x1EB3, 0xFFFF },
	{ 0x1EB3, CODEPAGE_ISLOWER, 0xFFFF, 0x1EB2 },
	{ 0x1EB4, CODEPAGE_ISUPPER, 0x1EB5, 0xFFFF },
	{ 0x1EB5, CODEPAGE_ISLOWER, 0xFFFF, 0x1EB4 },
	{ 0x1EB6, CODEPAGE_ISUPPER, 0x1EB7, 0xFFFF },
	{ 0x1EB7, CODEPAGE_ISLOWER, 0xFFFF, 0x1EB6 },
	{ 0x1EB8, CODEPAGE_ISUPPER, 0x1EB9, 0xFFFF },
	{ 0x1EB9, CODEPAGE_ISLOWER, 0xFFFF, 0x1EB8 },
	{ 0x1EBA, CODEPAGE_ISUPPER, 0x1EBB, 0xFFFF },
	{ 0x1EBB, CODEPAGE_ISLOWER, 0xFFFF, 0x1EBA },
	{ 0x1EBC, CODEPAGE_ISUPPER, 0x1EBD, 0xFFFF },
	{ 0x1EBD, CODEPAGE_ISLOWER, 0xFFFF, 0x1EBC },
	{ 0x1EBE, CODEPAGE_ISUPPER, 0x1EBF, 0xFFFF },
	{ 0x1EBF, CODEPAGE_ISLOWER, 0xFFFF, 0x1EBE },
	{ 0x1EC0, CODEPAGE_ISUPPER, 0x1EC1, 0xFFFF },
	{ 0x1EC1, CODEPAGE_ISLOWER, 0xFFFF, 0x1EC0 },
	{ 0x1EC2, CODEPAGE_ISUPPER, 0x1EC3, 0xFFFF },
	{ 0x1EC3, CODEPAGE_ISLOWER, 0xFFFF, 0x1EC2 },
	{ 0x1EC4, CODEPAGE_ISUPPER, 0x1EC5, 0xFFFF },
	{ 0x1EC5, CODEPAGE_ISLOWER, 0xFFFF, 0x1EC4 },
	{ 0x1EC6, CODEPAGE_ISUPPER, 0x1EC7, 0xFFFF },
	{ 0x1EC7, CODEPAGE_ISLOWER, 0xFFFF, 0x1EC6 },
	{ 0x1EC8, CODEPAGE_ISUPPER, 0x1EC9, 0xFFFF },
	{ 0x1EC9, CODEPAGE_ISLOWER, 0xFFFF, 0x1EC8 },
	{ 0x1ECA, CODEPAGE_ISUPPER, 0x1ECB, 0xFFFF },
	{ 0x1ECB, CODEPAGE_ISLOWER, 0xFFFF, 0x1ECA },
	{ 0x1ECC, CODEPAGE_ISUPPER, 0x1ECD, 0xFFFF },
	{ 0x1ECD, CODEPAGE_ISLOWER, 0xFFFF, 0x1ECC },
	{ 0x1ECE, CODEPAGE_ISUPPER, 0x1ECF, 0xFFFF },
	{ 0x1ECF, CODEPAGE_ISLOWER, 0xFFFF, 0x1ECE },
	{ 0x1ED0, CODEPAGE_ISUPPER, 0x1ED1, 0xFFFF },
	{ 0x1ED1, CODEPAGE_ISLOWER, 0xFFFF, 0x1ED0 },
	{ 0x1ED2, CODEPAGE_ISUPPER, 0x1ED3, 0xFFFF },
	{ 0x1ED3, CODEPAGE_ISLOWER, 0xFFFF, 0x1ED2 },
	{ 0x1ED4, CODEPAGE_ISUPPER, 0x1ED5, 0xFFFF },
	{ 0x1ED5, CODEPAGE_ISLOWER, 0xFFFF, 0x1ED4 },
	{ 0x1ED6, CODEPAGE_ISUPPER, 0x1ED7, 0xFFFF },
	{ 0x1ED7, CODEPAGE_ISLOWER, 0xFFFF, 0x1ED6 },
	{ 0x1ED8, CODEPAGE_ISUPPER, 0x1ED9, 0xFFFF },
	{ 0x1ED9, CODEPAGE_ISLOWER, 0xFFFF, 0x1ED8 },
	{ 0x1EDA, CODEPAGE_ISUPPER, 0x1EDB, 0xFFFF },
	{ 0x1EDB, CODEPAGE_ISLOWER, 0xFFFF, 0x1EDA },
	{ 0x1EDC, CODEPAGE_ISUPPER, 0x1EDD, 0xFFFF },
	{ 0x1EDD, CODEPAGE_ISLOWER, 0xFFFF, 0x1EDC },
	{ 0x1EDE, CODEPAGE_ISUPPER, 0x1EDF, 0xFFFF },
	{ 0x1EDF, CODEPAGE_ISLOWER, 0xFFFF, 0x1EDE },
	{ 0x1EE0, CODEPAGE_ISUPPER, 0x1EE1, 0xFFFF },
	{ 0x1EE1, CODEPAGE_ISLOWER, 0xFFFF, 0x1EE0 },
	{ 0x1EE2, CODEPAGE_ISUPPER, 0x1EE3, 0xFFFF },
	{ 0x1EE3, CODEPAGE_ISLOWER, 0xFFFF, 0x1EE2 },
	{ 0x1EE4, CODEPAGE_ISUPPER, 0x1EE5, 0xFFFF },
	{ 0x1EE5, CODEPAGE_ISLOWER, 0xFFFF, 0x1EE4 },
	{ 0x1EE6, CODEPAGE_ISUPPER, 0x1EE7, 0xFFFF },
	{ 0x1EE7, CODEPAGE_ISLOWER, 0xFFFF, 0x1EE6 },
	{ 0x1EE8, CODEPAGE_ISUPPER, 0x1EE9, 0xFFFF },
	{ 0x1EE9, CODEPAGE_ISLOWER, 0xFFFF, 0x1EE8 },
	{ 0x1EEA, CODEPAGE_ISUPPER, 0x1EEB, 0xFFFF },
	{ 0x1EEB, CODEPAGE_ISLOWER, 0xFFFF, 0x1EEA },
	{ 0x1EEC, CODEPAGE_ISUPPER, 0x1EED, 0xFFFF },
	{ 0x1EED, CODEPAGE_ISLOWER, 0xFFFF, 0x1EEC },
	{ 0x1EEE, CODEPAGE_ISUPPER, 0x1EEF, 0xFFFF },
	{ 0x1EEF, CODEPAGE_ISLOWER, 0xFFFF, 0x1EEE },
	{ 0x1EF0, CODEPAGE_ISUPPER, 0x1EF1, 0xFFFF },
	{ 0x1EF1, CODEPAGE_ISLOWER, 0xFFFF, 0x1EF0 },
	{ 0x1EF2, CODEPAGE_ISUPPER, 0x1EF3, 0xFFFF },
	{ 0x1EF3, CODEPAGE_ISLOWER, 0xFFFF, 0x1EF2 },
	{ 0x1EF4, CODEPAGE_ISUPPER, 0x1EF5, 0xFFFF },
	{ 0x1EF5, CODEPAGE_ISLOWER, 0xFFFF, 0x1EF4 },
	{ 0x1EF6, CODEPAGE_ISUPPER, 0x1EF7, 0xFFFF },
	{ 0x1EF7, CODEPAGE_ISLOWER, 0xFFFF, 0x1EF6 },
	{ 0x1EF8, CODEPAGE_ISUPPER, 0x1EF9, 0xFFFF },
	{ 0x1EF9, CODEPAGE_ISLOWER, 0xFFFF, 0x1EF8 },
	{ 0x1F00, CODEPAGE_ISLOWER, 0xFFFF, 0x1F08 },
	{ 0x1F01, CODEPAGE_ISLOWER, 0xFFFF, 0x1F09 },
	{ 0x1F02, CODEPAGE_ISLOWER, 0xFFFF, 0x1F0A },
	{ 0x1F03, CODEPAGE_ISLOWER, 0xFFFF, 0x1F0B },
	{ 0x1F04, CODEPAGE_ISLOWER, 0xFFFF, 0x1F0C },
	{ 0x1F05, CODEPAGE_ISLOWER, 0xFFFF, 0x1F0D },
	{ 0x1F06, CODEPAGE_ISLOWER, 0xFFFF, 0x1F0E },
	{ 0x1F07, CODEPAGE_ISLOWER, 0xFFFF, 0x1F0F },
	{ 0x1F08, CODEPAGE_ISUPPER, 0x1F00, 0xFFFF },
	{ 0x1F09, CODEPAGE_ISUPPER, 0x1F01, 0xFFFF },
	{ 0x1F0A, CODEPAGE_ISUPPER, 0x1F02, 0xFFFF },
	{ 0x1F0B, CODEPAGE_ISUPPER, 0x1F03, 0xFFFF },
	{ 0x1F0C, CODEPAGE_ISUPPER, 0x1F04, 0xFFFF },
	{ 0x1F0D, CODEPAGE_ISUPPER, 0x1F05, 0xFFFF },
	{ 0x1F0E, CODEPAGE_ISUPPER, 0x1F06, 0xFFFF },
	{ 0x1F0F, CODEPAGE_ISUPPER, 0x1F07, 0xFFFF },
	{ 0x1F10, CODEPAGE_ISLOWER, 0xFFFF, 0x1F18 },
	{ 0x1F11, CODEPAGE_ISLOWER, 0xFFFF, 0x1F19 },
	{ 0x1F12, CODEPAGE_ISLOWER, 0xFFFF, 0x1F1A },
	{ 0x1F13, CODEPAGE_ISLOWER, 0xFFFF, 0x1F1B },
	{ 0x1F14, CODEPAGE_ISLOWER, 0xFFFF, 0x1F1C },
	{ 0x1F15, CODEPAGE_ISLOWER, 0xFFFF, 0x1F1D },
	{ 0x1F18, CODEPAGE_ISUPPER, 0x1F10, 0xFFFF },
	{ 0x1F19, CODEPAGE_ISUPPER, 0x1F11, 0xFFFF },
	{ 0x1F1A, CODEPAGE_ISUPPER, 0x1F12, 0xFFFF },
	{ 0x1F1B, CODEPAGE_ISUPPER, 0x1F13, 0xFFFF },
	{ 0x1F1C, CODEPAGE_ISUPPER, 0x1F14, 0xFFFF },
	{ 0x1F1D, CODEPAGE_ISUPPER, 0x1F15, 0xFFFF },
	{ 0x1F20, CODEPAGE_ISLOWER, 0xFFFF, 0x1F28 },
	{ 0x1F21, CODEPAGE_ISLOWER, 0xFFFF, 0x1F29 },
	{ 0x1F22, CODEPAGE_ISLOWER, 0xFFFF, 0x1F2A },
	{ 0x1F23, CODEPAGE_ISLOWER, 0xFFFF, 0x1F2B },
	{ 0x1F24, CODEPAGE_ISLOWER, 0xFFFF, 0x1F2C },
	{ 0x1F25, CODEPAGE_ISLOWER, 0xFFFF, 0x1F2D },
	{ 0x1F26, CODEPAGE_ISLOWER, 0xFFFF, 0x1F2E },
	{ 0x1F27, CODEPAGE_ISLOWER, 0xFFFF, 0x1F2F },
	{ 0x1F28, CODEPAGE_ISUPPER, 0x1F20, 0xFFFF },
	{ 0x1F29, CODEPAGE_ISUPPER, 0x1F21, 0xFFFF },
	{ 0x1F2A, CODEPAGE_ISUPPER, 0x1F22, 0xFFFF },
	{ 0x1F2B, CODEPAGE_ISUPPER, 0x1F23, 0xFFFF },
	{ 0x1F2C, CODEPAGE_ISUPPER, 0x1F24, 0xFFFF },
	{ 0x1F2D, CODEPAGE_ISUPPER, 0x1F25, 0xFFFF },
	{ 0x1F2E, CODEPAGE_ISUPPER, 0x1F26, 0xFFFF },
	{ 0x1F2F, CODEPAGE_ISUPPER, 0x1F27, 0xFFFF },
	{ 0x1F30, CODEPAGE_ISLOWER, 0xFFFF, 0x1F38 },
	{ 0x1F31, CODEPAGE_ISLOWER, 0xFFFF, 0x1F39 },
	{ 0x1F32, CODEPAGE_ISLOWER, 0xFFFF, 0x1F3A },
	{ 0x1F33, CODEPAGE_ISLOWER, 0xFFFF, 0x1F3B },
	{ 0x1F34, CODEPAGE_ISLOWER, 0xFFFF, 0x1F3C },
	{ 0x1F35, CODEPAGE_ISLOWER, 0xFFFF, 0x1F3D },
	{ 0x1F36, CODEPAGE_ISLOWER, 0xFFFF, 0x1F3E },
	{ 0x1F37, CODEPAGE_ISLOWER, 0xFFFF, 0x1F3F },
	{ 0x1F38, CODEPAGE_ISUPPER, 0x1F30, 0xFFFF },
	{ 0x1F39, CODEPAGE_ISUPPER, 0x1F31, 0xFFFF },
	{ 0x1F3A, CODEPAGE_ISUPPER, 0x1F32, 0xFFFF },
	{ 0x1F3B, CODEPAGE_ISUPPER, 0x1F33, 0xFFFF },
	{ 0x1F3C, CODEPAGE_ISUPPER, 0x1F34, 0xFFFF },
	{ 0x1F3D, CODEPAGE_ISUPPER, 0x1F35, 0xFFFF },
	{ 0x1F3E, CODEPAGE_ISUPPER, 0x1F36, 0xFFFF },
	{ 0x1F3F, CODEPAGE_ISUPPER, 0x1F37, 0xFFFF },
	{ 0x1F40, CODEPAGE_ISLOWER, 0xFFFF, 0x1F48 },
	{ 0x1F41, CODEPAGE_ISLOWER, 0xFFFF, 0x1F49 },
	{ 0x1F42, CODEPAGE_ISLOWER, 0xFFFF, 0x1F4A },
	{ 0x1F43, CODEPAGE_ISLOWER, 0xFFFF, 0x1F4B },
	{ 0x1F44, CODEPAGE_ISLOWER, 0xFFFF, 0x1F4C },
	{ 0x1F45, CODEPAGE_ISLOWER, 0xFFFF, 0x1F4D },
	{ 0x1F48, CODEPAGE_ISUPPER, 0x1F40, 0xFFFF },
	{ 0x1F49, CODEPAGE_ISUPPER, 0x1F41, 0xFFFF },
	{ 0x1F4A, CODEPAGE_ISUPPER, 0x1F42, 0xFFFF },
	{ 0x1F4B, CODEPAGE_ISUPPER, 0x1F43, 0xFFFF },
	{ 0x1F4C, CODEPAGE_ISUPPER, 0x1F44, 0xFFFF },
	{ 0x1F4D, CODEPAGE_ISUPPER, 0x1F45, 0xFFFF },
	{ 0x1F50, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1F51, CODEPAGE_ISLOWER, 0xFFFF, 0x1F59 },
	{ 0x1F52, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1F53, CODEPAGE_ISLOWER, 0xFFFF, 0x1F5B },
	{ 0x1F54, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1F55, CODEPAGE_ISLOWER, 0xFFFF, 0x1F5D },
	{ 0x1F56, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1F57, CODEPAGE_ISLOWER, 0xFFFF, 0x1F5F },
	{ 0x1F59, CODEPAGE_ISUPPER, 0x1F51, 0xFFFF },
	{ 0x1F5B, CODEPAGE_ISUPPER, 0x1F53, 0xFFFF },
	{ 0x1F5D, CODEPAGE_ISUPPER, 0x1F55, 0xFFFF },
	{ 0x1F5F, CODEPAGE_ISUPPER, 0x1F57, 0xFFFF },
	{ 0x1F60, CODEPAGE_ISLOWER, 0xFFFF, 0x1F68 },
	{ 0x1F61, CODEPAGE_ISLOWER, 0xFFFF, 0x1F69 },
	{ 0x1F62, CODEPAGE_ISLOWER, 0xFFFF, 0x1F6A },
	{ 0x1F63, CODEPAGE_ISLOWER, 0xFFFF, 0x1F6B },
	{ 0x1F64, CODEPAGE_ISLOWER, 0xFFFF, 0x1F6C },
	{ 0x1F65, CODEPAGE_ISLOWER, 0xFFFF, 0x1F6D },
	{ 0x1F66, CODEPAGE_ISLOWER, 0xFFFF, 0x1F6E },
	{ 0x1F67, CODEPAGE_ISLOWER, 0xFFFF, 0x1F6F },
	{ 0x1F68, CODEPAGE_ISUPPER, 0x1F60, 0xFFFF },
	{ 0x1F69, CODEPAGE_ISUPPER, 0x1F61, 0xFFFF },
	{ 0x1F6A, CODEPAGE_ISUPPER, 0x1F62, 0xFFFF },
	{ 0x1F6B, CODEPAGE_ISUPPER, 0x1F63, 0xFFFF },
	{ 0x1F6C, CODEPAGE_ISUPPER, 0x1F64, 0xFFFF },
	{ 0x1F6D, CODEPAGE_ISUPPER, 0x1F65, 0xFFFF },
	{ 0x1F6E, CODEPAGE_ISUPPER, 0x1F66, 0xFFFF },
	{ 0x1F6F, CODEPAGE_ISUPPER, 0x1F67, 0xFFFF },
	{ 0x1F70, CODEPAGE_ISLOWER, 0xFFFF, 0x1FBA },
	{ 0x1F71, CODEPAGE_ISLOWER, 0xFFFF, 0x1FBB },
	{ 0x1F72, CODEPAGE_ISLOWER, 0xFFFF, 0x1FC8 },
	{ 0x1F73, CODEPAGE_ISLOWER, 0xFFFF, 0x1FC9 },
	{ 0x1F74, CODEPAGE_ISLOWER, 0xFFFF, 0x1FCA },
	{ 0x1F75, CODEPAGE_ISLOWER, 0xFFFF, 0x1FCB },
	{ 0x1F76, CODEPAGE_ISLOWER, 0xFFFF, 0x1FDA },
	{ 0x1F77, CODEPAGE_ISLOWER, 0xFFFF, 0x1FDB },
	{ 0x1F78, CODEPAGE_ISLOWER, 0xFFFF, 0x1FF8 },
	{ 0x1F79, CODEPAGE_ISLOWER, 0xFFFF, 0x1FF9 },
	{ 0x1F7A, CODEPAGE_ISLOWER, 0xFFFF, 0x1FEA },
	{ 0x1F7B, CODEPAGE_ISLOWER, 0xFFFF, 0x1FEB },
	{ 0x1F7C, CODEPAGE_ISLOWER, 0xFFFF, 0x1FFA },
	{ 0x1F7D, CODEPAGE_ISLOWER, 0xFFFF, 0x1FFB },
	{ 0x1F80, CODEPAGE_ISLOWER, 0xFFFF, 0x1F88 },
	{ 0x1F81, CODEPAGE_ISLOWER, 0xFFFF, 0x1F89 },
	{ 0x1F82, CODEPAGE_ISLOWER, 0xFFFF, 0x1F8A },
	{ 0x1F83, CODEPAGE_ISLOWER, 0xFFFF, 0x1F8B },
	{ 0x1F84, CODEPAGE_ISLOWER, 0xFFFF, 0x1F8C },
	{ 0x1F85, CODEPAGE_ISLOWER, 0xFFFF, 0x1F8D },
	{ 0x1F86, CODEPAGE_ISLOWER, 0xFFFF, 0x1F8E },
	{ 0x1F87, CODEPAGE_ISLOWER, 0xFFFF, 0x1F8F },
	{ 0x1F88, CODEPAGE_ISUPPER, 0x1F80, 0xFFFF },
	{ 0x1F89, CODEPAGE_ISUPPER, 0x1F81, 0xFFFF },
	{ 0x1F8A, CODEPAGE_ISUPPER, 0x1F82, 0xFFFF },
	{ 0x1F8B, CODEPAGE_ISUPPER, 0x1F83, 0xFFFF },
	{ 0x1F8C, CODEPAGE_ISUPPER, 0x1F84, 0xFFFF },
	{ 0x1F8D, CODEPAGE_ISUPPER, 0x1F85, 0xFFFF },
	{ 0x1F8E, CODEPAGE_ISUPPER, 0x1F86, 0xFFFF },
	{ 0x1F8F, CODEPAGE_ISUPPER, 0x1F87, 0xFFFF },
	{ 0x1F90, CODEPAGE_ISLOWER, 0xFFFF, 0x1F98 },
	{ 0x1F91, CODEPAGE_ISLOWER, 0xFFFF, 0x1F99 },
	{ 0x1F92, CODEPAGE_ISLOWER, 0xFFFF, 0x1F9A },
	{ 0x1F93, CODEPAGE_ISLOWER, 0xFFFF, 0x1F9B },
	{ 0x1F94, CODEPAGE_ISLOWER, 0xFFFF, 0x1F9C },
	{ 0x1F95, CODEPAGE_ISLOWER, 0xFFFF, 0x1F9D },
	{ 0x1F96, CODEPAGE_ISLOWER, 0xFFFF, 0x1F9E },
	{ 0x1F97, CODEPAGE_ISLOWER, 0xFFFF, 0x1F9F },
	{ 0x1F98, CODEPAGE_ISUPPER, 0x1F90, 0xFFFF },
	{ 0x1F99, CODEPAGE_ISUPPER, 0x1F91, 0xFFFF },
	{ 0x1F9A, CODEPAGE_ISUPPER, 0x1F92, 0xFFFF },
	{ 0x1F9B, CODEPAGE_ISUPPER, 0x1F93, 0xFFFF },
	{ 0x1F9C, CODEPAGE_ISUPPER, 0x1F94, 0xFFFF },
	{ 0x1F9D, CODEPAGE_ISUPPER, 0x1F95, 0xFFFF },
	{ 0x1F9E, CODEPAGE_ISUPPER, 0x1F96, 0xFFFF },
	{ 0x1F9F, CODEPAGE_ISUPPER, 0x1F97, 0xFFFF },
	{ 0x1FA0, CODEPAGE_ISLOWER, 0xFFFF, 0x1FA8 },
	{ 0x1FA1, CODEPAGE_ISLOWER, 0xFFFF, 0x1FA9 },
	{ 0x1FA2, CODEPAGE_ISLOWER, 0xFFFF, 0x1FAA },
	{ 0x1FA3, CODEPAGE_ISLOWER, 0xFFFF, 0x1FAB },
	{ 0x1FA4, CODEPAGE_ISLOWER, 0xFFFF, 0x1FAC },
	{ 0x1FA5, CODEPAGE_ISLOWER, 0xFFFF, 0x1FAD },
	{ 0x1FA6, CODEPAGE_ISLOWER, 0xFFFF, 0x1FAE },
	{ 0x1FA7, CODEPAGE_ISLOWER, 0xFFFF, 0x1FAF },
	{ 0x1FA8, CODEPAGE_ISUPPER, 0x1FA0, 0xFFFF },
	{ 0x1FA9, CODEPAGE_ISUPPER, 0x1FA1, 0xFFFF },
	{ 0x1FAA, CODEPAGE_ISUPPER, 0x1FA2, 0xFFFF },
	{ 0x1FAB, CODEPAGE_ISUPPER, 0x1FA3, 0xFFFF },
	{ 0x1FAC, CODEPAGE_ISUPPER, 0x1FA4, 0xFFFF },
	{ 0x1FAD, CODEPAGE_ISUPPER, 0x1FA5, 0xFFFF },
	{ 0x1FAE, CODEPAGE_ISUPPER, 0x1FA6, 0xFFFF },
	{ 0x1FAF, CODEPAGE_ISUPPER, 0x1FA7, 0xFFFF },
	{ 0x1FB0, CODEPAGE_ISLOWER, 0xFFFF, 0x1FB8 },
	{ 0x1FB1, CODEPAGE_ISLOWER, 0xFFFF, 0x1FB9 },
	{ 0x1FB2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FB3, CODEPAGE_ISLOWER, 0xFFFF, 0x1FBC },
	{ 0x1FB4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FB6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FB7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FB8, CODEPAGE_ISUPPER, 0x1FB0, 0xFFFF },
	{ 0x1FB9, CODEPAGE_ISUPPER, 0x1FB1, 0xFFFF },
	{ 0x1FBA, CODEPAGE_ISUPPER, 0x1F70, 0xFFFF },
	{ 0x1FBB, CODEPAGE_ISUPPER, 0x1F71, 0xFFFF },
	{ 0x1FBC, CODEPAGE_ISUPPER, 0x1FB3, 0xFFFF },
	{ 0x1FBD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FBE, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x1FBF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FC2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FC3, CODEPAGE_ISLOWER, 0xFFFF, 0x1FCC },
	{ 0x1FC4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FC6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FC7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FC8, CODEPAGE_ISUPPER, 0x1F72, 0xFFFF },
	{ 0x1FC9, CODEPAGE_ISUPPER, 0x1F73, 0xFFFF },
	{ 0x1FCA, CODEPAGE_ISUPPER, 0x1F74, 0xFFFF },
	{ 0x1FCB, CODEPAGE_ISUPPER, 0x1F75, 0xFFFF },
	{ 0x1FCC, CODEPAGE_ISUPPER, 0x1FC3, 0xFFFF },
	{ 0x1FCD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FCE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FCF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FD0, CODEPAGE_ISLOWER, 0xFFFF, 0x1FD8 },
	{ 0x1FD1, CODEPAGE_ISLOWER, 0xFFFF, 0x1FD9 },
	{ 0x1FD2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FD3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FD6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FD7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FD8, CODEPAGE_ISUPPER, 0x1FD0, 0xFFFF },
	{ 0x1FD9, CODEPAGE_ISUPPER, 0x1FD1, 0xFFFF },
	{ 0x1FDA, CODEPAGE_ISUPPER, 0x1F76, 0xFFFF },
	{ 0x1FDB, CODEPAGE_ISUPPER, 0x1F77, 0xFFFF },
	{ 0x1FDD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FDE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FDF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FE0, CODEPAGE_ISLOWER, 0xFFFF, 0x1FE8 },
	{ 0x1FE1, CODEPAGE_ISLOWER, 0xFFFF, 0x1FE9 },
	{ 0x1FE2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FE3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FE4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FE5, CODEPAGE_ISLOWER, 0xFFFF, 0x1FEC },
	{ 0x1FE6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FE7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FE8, CODEPAGE_ISUPPER, 0x1FE0, 0xFFFF },
	{ 0x1FE9, CODEPAGE_ISUPPER, 0x1FE1, 0xFFFF },
	{ 0x1FEA, CODEPAGE_ISUPPER, 0x1F7A, 0xFFFF },
	{ 0x1FEB, CODEPAGE_ISUPPER, 0x1F7B, 0xFFFF },
	{ 0x1FEC, CODEPAGE_ISUPPER, 0x1FE5, 0xFFFF },
	{ 0x1FED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FF2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FF3, CODEPAGE_ISLOWER, 0xFFFF, 0x1FFC },
	{ 0x1FF4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FF6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FF7, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x1FF8, CODEPAGE_ISUPPER, 0x1F78, 0xFFFF },
	{ 0x1FF9, CODEPAGE_ISUPPER, 0x1F79, 0xFFFF },
	{ 0x1FFA, CODEPAGE_ISUPPER, 0x1F7C, 0xFFFF },
	{ 0x1FFB, CODEPAGE_ISUPPER, 0x1F7D, 0xFFFF },
	{ 0x1FFC, CODEPAGE_ISUPPER, 0x1FF3, 0xFFFF },
	{ 0x1FFD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x1FFE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2000, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2001, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2002, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2003, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2004, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2005, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2006, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2007, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2008, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2009, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x200A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x200B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x200C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x200D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x200E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x200F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2010, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2011, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2012, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2013, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2014, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2015, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2016, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2017, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2018, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2019, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x201A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x201B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x201C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x201D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x201E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x201F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2020, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2021, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2022, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2023, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2024, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2025, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2026, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2027, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2028, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2029, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x202A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x202B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x202C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x202D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x202E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2030, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2031, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2032, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2033, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2034, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2035, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2036, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2037, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2038, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2039, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x203A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x203B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x203C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x203D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x203E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x203F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2040, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2041, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2042, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2043, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2044, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2045, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2046, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x206A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x206B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x206C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x206D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x206E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x206F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2070, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2074, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2075, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2076, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2077, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2078, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2079, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x207A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x207B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x207C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x207D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x207E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x207F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x2080, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2081, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2082, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2083, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2084, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2085, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2086, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2087, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2088, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2089, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x208A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x208B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x208C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x208D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x208E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x20E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2100, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2101, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2102, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2103, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2104, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2105, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2106, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2107, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2108, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2109, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x210A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x210B, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x210C, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x210D, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x210E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x210F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x2110, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2111, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2112, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2113, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x2114, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2115, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2116, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2117, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2118, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2119, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x211A, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x211B, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x211C, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x211D, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x211E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x211F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2120, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2121, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2122, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2123, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2124, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2125, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2126, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2127, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2128, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2129, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x212A, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x212B, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x212C, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x212D, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x212E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x212F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x2130, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2131, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2132, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2133, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x2134, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x2135, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2136, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2137, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2138, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2153, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2154, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2155, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2156, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2157, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2158, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2159, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x215A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x215B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x215C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x215D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x215E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x215F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2160, CODEPAGE_ISNONE, 0x2170, 0xFFFF },
	{ 0x2161, CODEPAGE_ISNONE, 0x2171, 0xFFFF },
	{ 0x2162, CODEPAGE_ISNONE, 0x2172, 0xFFFF },
	{ 0x2163, CODEPAGE_ISNONE, 0x2173, 0xFFFF },
	{ 0x2164, CODEPAGE_ISNONE, 0x2174, 0xFFFF },
	{ 0x2165, CODEPAGE_ISNONE, 0x2175, 0xFFFF },
	{ 0x2166, CODEPAGE_ISNONE, 0x2176, 0xFFFF },
	{ 0x2167, CODEPAGE_ISNONE, 0x2177, 0xFFFF },
	{ 0x2168, CODEPAGE_ISNONE, 0x2178, 0xFFFF },
	{ 0x2169, CODEPAGE_ISNONE, 0x2179, 0xFFFF },
	{ 0x216A, CODEPAGE_ISNONE, 0x217A, 0xFFFF },
	{ 0x216B, CODEPAGE_ISNONE, 0x217B, 0xFFFF },
	{ 0x216C, CODEPAGE_ISNONE, 0x217C, 0xFFFF },
	{ 0x216D, CODEPAGE_ISNONE, 0x217D, 0xFFFF },
	{ 0x216E, CODEPAGE_ISNONE, 0x217E, 0xFFFF },
	{ 0x216F, CODEPAGE_ISNONE, 0x217F, 0xFFFF },
	{ 0x2170, CODEPAGE_ISNONE, 0xFFFF, 0x2160 },
	{ 0x2171, CODEPAGE_ISNONE, 0xFFFF, 0x2161 },
	{ 0x2172, CODEPAGE_ISNONE, 0xFFFF, 0x2162 },
	{ 0x2173, CODEPAGE_ISNONE, 0xFFFF, 0x2163 },
	{ 0x2174, CODEPAGE_ISNONE, 0xFFFF, 0x2164 },
	{ 0x2175, CODEPAGE_ISNONE, 0xFFFF, 0x2165 },
	{ 0x2176, CODEPAGE_ISNONE, 0xFFFF, 0x2166 },
	{ 0x2177, CODEPAGE_ISNONE, 0xFFFF, 0x2167 },
	{ 0x2178, CODEPAGE_ISNONE, 0xFFFF, 0x2168 },
	{ 0x2179, CODEPAGE_ISNONE, 0xFFFF, 0x2169 },
	{ 0x217A, CODEPAGE_ISNONE, 0xFFFF, 0x216A },
	{ 0x217B, CODEPAGE_ISNONE, 0xFFFF, 0x216B },
	{ 0x217C, CODEPAGE_ISNONE, 0xFFFF, 0x216C },
	{ 0x217D, CODEPAGE_ISNONE, 0xFFFF, 0x216D },
	{ 0x217E, CODEPAGE_ISNONE, 0xFFFF, 0x216E },
	{ 0x217F, CODEPAGE_ISNONE, 0xFFFF, 0x216F },
	{ 0x2180, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2181, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2182, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2190, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2191, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2192, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2193, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2194, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2195, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2196, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2197, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2198, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2199, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x219A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x219B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x219C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x219D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x219E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x219F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21CF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x21EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2200, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2201, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2202, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2203, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2204, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2205, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2206, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2207, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2208, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2209, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x220A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x220B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x220C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x220D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x220E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x220F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2210, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2211, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2212, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2213, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2214, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2215, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2216, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2217, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2218, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2219, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x221A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x221B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x221C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x221D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x221E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x221F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2220, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2221, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2222, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2223, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2224, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2225, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2226, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2227, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2228, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2229, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x222A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x222B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x222C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x222D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x222E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x222F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2230, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2231, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2232, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2233, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2234, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2235, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2236, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2237, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2238, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2239, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x223A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x223B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x223C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x223D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x223E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x223F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2240, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2241, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2242, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2243, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2244, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2245, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2246, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2247, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2248, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2249, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x224A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x224B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x224C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x224D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x224E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x224F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2250, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2251, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2252, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2253, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2254, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2255, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2256, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2257, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2258, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2259, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x225A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x225B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x225C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x225D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x225E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x225F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2260, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2261, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2262, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2263, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2264, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2265, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2266, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2267, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2268, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2269, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x226A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x226B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x226C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x226D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x226E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x226F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2270, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2271, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2272, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2273, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2274, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2275, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2276, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2277, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2278, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2279, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x227A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x227B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x227C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x227D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x227E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x227F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2280, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2281, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2282, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2283, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2284, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2285, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2286, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2287, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2288, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2289, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x228A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x228B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x228C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x228D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x228E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x228F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2290, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2291, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2292, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2293, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2294, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2295, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2296, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2297, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2298, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2299, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x229A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x229B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x229C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x229D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x229E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x229F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22CF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x22F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2300, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2302, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2303, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2304, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2305, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2306, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2307, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2308, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2309, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x230A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x230B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x230C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x230D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x230E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x230F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2310, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2311, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2312, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2313, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2314, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2315, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2316, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2317, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2318, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2319, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x231A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x231B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x231C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x231D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x231E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x231F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2320, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2321, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2322, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2323, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2324, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2325, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2326, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2327, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2328, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2329, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x232A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x232B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x232C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x232D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x232E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x232F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2330, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2331, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2332, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2333, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2334, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2335, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2336, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2337, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2338, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2339, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x233A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x233B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x233C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x233D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x233E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x233F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2340, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2341, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2342, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2343, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2344, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2345, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2346, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2347, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2348, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2349, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x234A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x234B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x234C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x234D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x234E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x234F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2350, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2351, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2352, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2353, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2354, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2355, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2356, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2357, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2358, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2359, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x235A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x235B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x235C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x235D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x235E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x235F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2360, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2361, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2362, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2363, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2364, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2365, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2366, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2367, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2368, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2369, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x236A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x236B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x236C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x236D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x236E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x236F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2370, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2371, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2372, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2373, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2374, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2375, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2376, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2377, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2378, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2379, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x237A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2400, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2401, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2402, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2403, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2404, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2405, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2406, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2407, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2408, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2409, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x240A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x240B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x240C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x240D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x240E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x240F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2410, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2411, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2412, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2413, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2414, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2415, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2416, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2417, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2418, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2419, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x241A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x241B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x241C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x241D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x241E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x241F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2420, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2421, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2422, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2423, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2424, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2440, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2441, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2442, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2443, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2444, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2445, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2446, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2447, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2448, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2449, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x244A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2460, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2461, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2462, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2463, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2464, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2465, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2466, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2467, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2468, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2469, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x246A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x246B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x246C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x246D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x246E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x246F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2470, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2471, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2472, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2473, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2474, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2475, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2476, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2477, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2478, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2479, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x247A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x247B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x247C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x247D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x247E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x247F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2480, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2481, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2482, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2483, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2484, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2485, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2486, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2487, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2488, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2489, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x248A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x248B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x248C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x248D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x248E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x248F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2490, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2491, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2492, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2493, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2494, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2495, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2496, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2497, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2498, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2499, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x249A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x249B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x249C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x249D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x249E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x249F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x24B6, CODEPAGE_ISUPPER, 0x24D0, 0xFFFF },
	{ 0x24B7, CODEPAGE_ISUPPER, 0x24D1, 0xFFFF },
	{ 0x24B8, CODEPAGE_ISUPPER, 0x24D2, 0xFFFF },
	{ 0x24B9, CODEPAGE_ISUPPER, 0x24D3, 0xFFFF },
	{ 0x24BA, CODEPAGE_ISUPPER, 0x24D4, 0xFFFF },
	{ 0x24BB, CODEPAGE_ISUPPER, 0x24D5, 0xFFFF },
	{ 0x24BC, CODEPAGE_ISUPPER, 0x24D6, 0xFFFF },
	{ 0x24BD, CODEPAGE_ISUPPER, 0x24D7, 0xFFFF },
	{ 0x24BE, CODEPAGE_ISUPPER, 0x24D8, 0xFFFF },
	{ 0x24BF, CODEPAGE_ISUPPER, 0x24D9, 0xFFFF },
	{ 0x24C0, CODEPAGE_ISUPPER, 0x24DA, 0xFFFF },
	{ 0x24C1, CODEPAGE_ISUPPER, 0x24DB, 0xFFFF },
	{ 0x24C2, CODEPAGE_ISUPPER, 0x24DC, 0xFFFF },
	{ 0x24C3, CODEPAGE_ISUPPER, 0x24DD, 0xFFFF },
	{ 0x24C4, CODEPAGE_ISUPPER, 0x24DE, 0xFFFF },
	{ 0x24C5, CODEPAGE_ISUPPER, 0x24DF, 0xFFFF },
	{ 0x24C6, CODEPAGE_ISUPPER, 0x24E0, 0xFFFF },
	{ 0x24C7, CODEPAGE_ISUPPER, 0x24E1, 0xFFFF },
	{ 0x24C8, CODEPAGE_ISUPPER, 0x24E2, 0xFFFF },
	{ 0x24C9, CODEPAGE_ISUPPER, 0x24E3, 0xFFFF },
	{ 0x24CA, CODEPAGE_ISUPPER, 0x24E4, 0xFFFF },
	{ 0x24CB, CODEPAGE_ISUPPER, 0x24E5, 0xFFFF },
	{ 0x24CC, CODEPAGE_ISUPPER, 0x24E6, 0xFFFF },
	{ 0x24CD, CODEPAGE_ISUPPER, 0x24E7, 0xFFFF },
	{ 0x24CE, CODEPAGE_ISUPPER, 0x24E8, 0xFFFF },
	{ 0x24CF, CODEPAGE_ISUPPER, 0x24E9, 0xFFFF },
	{ 0x24D0, CODEPAGE_ISLOWER, 0xFFFF, 0x24B6 },
	{ 0x24D1, CODEPAGE_ISLOWER, 0xFFFF, 0x24B7 },
	{ 0x24D2, CODEPAGE_ISLOWER, 0xFFFF, 0x24B8 },
	{ 0x24D3, CODEPAGE_ISLOWER, 0xFFFF, 0x24B9 },
	{ 0x24D4, CODEPAGE_ISLOWER, 0xFFFF, 0x24BA },
	{ 0x24D5, CODEPAGE_ISLOWER, 0xFFFF, 0x24BB },
	{ 0x24D6, CODEPAGE_ISLOWER, 0xFFFF, 0x24BC },
	{ 0x24D7, CODEPAGE_ISLOWER, 0xFFFF, 0x24BD },
	{ 0x24D8, CODEPAGE_ISLOWER, 0xFFFF, 0x24BE },
	{ 0x24D9, CODEPAGE_ISLOWER, 0xFFFF, 0x24BF },
	{ 0x24DA, CODEPAGE_ISLOWER, 0xFFFF, 0x24C0 },
	{ 0x24DB, CODEPAGE_ISLOWER, 0xFFFF, 0x24C1 },
	{ 0x24DC, CODEPAGE_ISLOWER, 0xFFFF, 0x24C2 },
	{ 0x24DD, CODEPAGE_ISLOWER, 0xFFFF, 0x24C3 },
	{ 0x24DE, CODEPAGE_ISLOWER, 0xFFFF, 0x24C4 },
	{ 0x24DF, CODEPAGE_ISLOWER, 0xFFFF, 0x24C5 },
	{ 0x24E0, CODEPAGE_ISLOWER, 0xFFFF, 0x24C6 },
	{ 0x24E1, CODEPAGE_ISLOWER, 0xFFFF, 0x24C7 },
	{ 0x24E2, CODEPAGE_ISLOWER, 0xFFFF, 0x24C8 },
	{ 0x24E3, CODEPAGE_ISLOWER, 0xFFFF, 0x24C9 },
	{ 0x24E4, CODEPAGE_ISLOWER, 0xFFFF, 0x24CA },
	{ 0x24E5, CODEPAGE_ISLOWER, 0xFFFF, 0x24CB },
	{ 0x24E6, CODEPAGE_ISLOWER, 0xFFFF, 0x24CC },
	{ 0x24E7, CODEPAGE_ISLOWER, 0xFFFF, 0x24CD },
	{ 0x24E8, CODEPAGE_ISLOWER, 0xFFFF, 0x24CE },
	{ 0x24E9, CODEPAGE_ISLOWER, 0xFFFF, 0x24CF },
	{ 0x24EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2500, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2501, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2502, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2503, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2504, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2505, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2506, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2507, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2508, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2509, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x250A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x250B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x250C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x250D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x250E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x250F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2510, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2511, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2512, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2513, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2514, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2515, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2516, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2517, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2518, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2519, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x251A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x251B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x251C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x251D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x251E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x251F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2520, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2521, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2522, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2523, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2524, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2525, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2526, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2527, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2528, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2529, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x252A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x252B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x252C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x252D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x252E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x252F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2530, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2531, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2532, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2533, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2534, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2535, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2536, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2537, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2538, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2539, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x253A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x253B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x253C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x253D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x253E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x253F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2540, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2541, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2542, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2543, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2544, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2545, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2546, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2547, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2548, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2549, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x254A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x254B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x254C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x254D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x254E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x254F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2550, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2551, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2552, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2553, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2554, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2555, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2556, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2557, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2558, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2559, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x255A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x255B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x255C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x255D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x255E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x255F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2560, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2561, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2562, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2563, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2564, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2565, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2566, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2567, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2568, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2569, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x256A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x256B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x256C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x256D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x256E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x256F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2570, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2571, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2572, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2573, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2574, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2575, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2576, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2577, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2578, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2579, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x257A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x257B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x257C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x257D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x257E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x257F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2580, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2581, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2582, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2583, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2584, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2585, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2586, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2587, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2588, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2589, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x258A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x258B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x258C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x258D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x258E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x258F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2590, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2591, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2592, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2593, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2594, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2595, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25CF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x25EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2600, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2601, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2602, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2603, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2604, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2605, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2606, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2607, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2608, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2609, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x260A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x260B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x260C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x260D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x260E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x260F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2610, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2611, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2612, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2613, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x261A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x261B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x261C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x261D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x261E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x261F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2620, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2621, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2622, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2623, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2624, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2625, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2626, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2627, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2628, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2629, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x262A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x262B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x262C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x262D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x262E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x262F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2630, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2631, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2632, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2633, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2634, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2635, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2636, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2637, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2638, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2639, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x263A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x263B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x263C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x263D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x263E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x263F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2640, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2641, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2642, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2643, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2644, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2645, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2646, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2647, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2648, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2649, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x264A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x264B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x264C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x264D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x264E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x264F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2650, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2651, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2652, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2653, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2654, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2655, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2656, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2657, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2658, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2659, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x265A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x265B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x265C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x265D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x265E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x265F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2660, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2661, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2662, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2663, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2664, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2665, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2666, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2667, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2668, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2669, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x266A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x266B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x266C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x266D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x266E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x266F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2701, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2702, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2703, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2704, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2706, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2707, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2708, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2709, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x270C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x270D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x270E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x270F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2710, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2711, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2712, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2713, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2714, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2715, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2716, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2717, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2718, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2719, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x271A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x271B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x271C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x271D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x271E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x271F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2720, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2721, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2722, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2723, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2724, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2725, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2726, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2727, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2729, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x272A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x272B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x272C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x272D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x272E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x272F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2730, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2731, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2732, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2733, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2734, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2735, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2736, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2737, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2738, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2739, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x273A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x273B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x273C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x273D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x273E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x273F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2740, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2741, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2742, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2743, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2744, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2745, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2746, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2747, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2748, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2749, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x274A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x274B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x274D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x274F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2750, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2751, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2752, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2756, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2758, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2759, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x275A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x275B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x275C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x275D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x275E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2761, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2762, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2763, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2764, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2765, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2766, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2767, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2776, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2777, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2778, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2779, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x277A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x277B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x277C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x277D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x277E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x277F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2780, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2781, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2782, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2783, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2784, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2785, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2786, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2787, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2788, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2789, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x278A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x278B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x278C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x278D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x278E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x278F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2790, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2791, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2792, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2793, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2794, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2798, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x2799, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x279A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x279B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x279C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x279D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x279E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x279F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x27BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3000, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3001, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3002, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3003, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3004, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3005, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3006, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3007, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3008, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3009, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x300A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x300B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x300C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x300D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x300E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x300F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3010, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3011, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3012, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3013, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3014, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3015, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3016, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3017, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3018, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3019, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x301A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x301B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x301C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x301D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x301E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x301F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3020, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3021, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3022, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3023, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3024, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3025, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3026, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3027, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3028, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3029, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x302A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x302B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x302C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x302D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x302E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x302F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3030, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3031, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3032, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3033, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3034, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3035, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3036, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3037, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x303F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3041, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3042, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3043, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3044, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3045, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3046, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3047, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3048, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3049, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x304A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x304B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x304C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x304D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x304E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x304F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3050, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3051, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3052, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3053, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3054, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3055, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3056, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3057, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3058, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3059, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x305A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x305B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x305C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x305D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x305E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x305F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3060, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3061, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3062, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3063, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3064, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3065, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3066, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3067, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3068, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3069, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x306A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x306B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x306C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x306D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x306E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x306F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3070, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3071, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3072, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3073, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3074, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3075, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3076, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3077, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3078, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3079, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x307A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x307B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x307C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x307D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x307E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x307F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3080, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3081, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3082, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3083, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3084, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3085, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3086, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3087, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3088, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3089, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x308A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x308B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x308C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x308D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x308E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x308F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3090, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3091, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3092, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3093, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3094, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3099, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x309A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x309B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x309C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x309D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x309E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30B9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30BF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30CC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30CD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30CE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30CF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30F9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30FA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30FB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30FC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30FD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x30FE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3105, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3106, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3107, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3108, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3109, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x310A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x310B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x310C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x310D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x310E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x310F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3110, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3111, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3112, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3113, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3114, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3115, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3116, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3117, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3118, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3119, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x311A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x311B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x311C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x311D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x311E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x311F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3120, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3121, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3122, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3123, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3124, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3125, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3126, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3127, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3128, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3129, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x312A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x312B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x312C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3131, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3132, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3133, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3134, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3135, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3136, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3137, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3138, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3139, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x313A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x313B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x313C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x313D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x313E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x313F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3140, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3141, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3142, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3143, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3144, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3145, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3146, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3147, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3148, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3149, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x314A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x314B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x314C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x314D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x314E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x314F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3150, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3151, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3152, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3153, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3154, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3155, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3156, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3157, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3158, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3159, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x315A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x315B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x315C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x315D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x315E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x315F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3160, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3161, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3162, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3163, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3164, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3165, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3166, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3167, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3168, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3169, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x316A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x316B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x316C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x316D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x316E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x316F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3170, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3171, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3172, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3173, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3174, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3175, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3176, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3177, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3178, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3179, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x317A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x317B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x317C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x317D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x317E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x317F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3180, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3181, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3182, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3183, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3184, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3185, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3186, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3187, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3188, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3189, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x318A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x318B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x318C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x318D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x318E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3190, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3191, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3192, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3193, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3194, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3195, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3196, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3197, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3198, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3199, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x319A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x319B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x319C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x319D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x319E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x319F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3200, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3201, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3202, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3203, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3204, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3205, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3206, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3207, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3208, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3209, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x320A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x320B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x320C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x320D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x320E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x320F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3210, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3211, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3212, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3213, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3214, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3215, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3216, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3217, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3218, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3219, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x321A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x321B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x321C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3220, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3221, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3222, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3223, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3224, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3225, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3226, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3227, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3228, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3229, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x322A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x322B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x322C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x322D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x322E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x322F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3230, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3231, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3232, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3233, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3234, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3235, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3236, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3237, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3238, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3239, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x323A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x323B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x323C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x323D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x323E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x323F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3240, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3241, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3242, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3243, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3260, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3261, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3262, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3263, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3264, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3265, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3266, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3267, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3268, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3269, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x326A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x326B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x326C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x326D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x326E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x326F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3270, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3271, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3272, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3273, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3274, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3275, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3276, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3277, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3278, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3279, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x327A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x327B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x327F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3280, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3281, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3282, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3283, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3284, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3285, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3286, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3287, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3288, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3289, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x328A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x328B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x328C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x328D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x328E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x328F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3290, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3291, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3292, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3293, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3294, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3295, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3296, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3297, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3298, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3299, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x329A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x329B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x329C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x329D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x329E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x329F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32AD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32B0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32CA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32CB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32D9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32DA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32DB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32DE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32DF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32F9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32FA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32FB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32FC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32FD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x32FE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3300, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3301, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3302, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3303, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3304, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3305, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3306, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3307, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3308, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3309, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x330A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x330B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x330C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x330D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x330E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x330F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3310, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3311, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3312, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3313, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3314, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3315, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3316, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3317, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3318, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3319, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x331A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x331B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x331C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x331D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x331E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x331F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3320, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3321, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3322, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3323, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3324, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3325, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3326, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3327, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3328, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3329, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x332A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x332B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x332C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x332D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x332E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x332F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3330, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3331, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3332, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3333, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3334, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3335, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3336, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3337, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3338, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3339, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x333A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x333B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x333C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x333D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x333E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x333F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3340, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3341, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3342, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3343, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3344, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3345, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3346, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3347, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3348, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3349, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x334A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x334B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x334C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x334D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x334E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x334F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3350, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3351, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3352, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3353, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3354, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3355, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3356, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3357, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3358, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3359, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x335A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x335B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x335C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x335D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x335E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x335F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3360, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3361, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3362, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3363, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3364, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3365, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3366, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3367, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3368, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3369, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x336A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x336B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x336C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x336D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x336E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x336F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3370, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3371, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3372, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x3373, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x3374, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x3375, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3376, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x337B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x337C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x337D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x337E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x337F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3380, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3381, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3382, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3383, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3384, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3385, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x3386, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x3387, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x3388, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x3389, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x338A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x338B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x338C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x338D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x338E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x338F, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x3390, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3391, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3392, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3393, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3394, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3395, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3396, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3397, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3398, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x3399, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x339A, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x339B, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x339C, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x339D, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x339E, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x339F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33A9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33AA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33AB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33AC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33AD, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33AE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33AF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33B0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33B1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33B2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33B3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33B4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33B5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33B6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33B7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33B8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33B9, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33BA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33BB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33BC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33BD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33BE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33BF, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33C0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33C1, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33C2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33C3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33C4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33C5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33C6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33C7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33C8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33C9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33CA, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33CB, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33CC, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33CD, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33CE, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33CF, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D0, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D1, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D2, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D3, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D4, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D5, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D6, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33D7, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33D8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33D9, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33DA, CODEPAGE_ISUPPER, 0xFFFF, 0xFFFF },
	{ 0x33DB, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0x33DC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33DD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33E9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33EA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33EB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33EC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33ED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33EE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33EF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33F9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33FA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33FB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33FC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33FD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x33FE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x4E00, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0x9FA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xAC00, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xD7A3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xD800, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xDB7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xDB80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xDBFF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xDC00, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xDFFF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xE000, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xF8FF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xF900, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFA2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB00, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB01, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB02, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB03, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB04, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB05, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB06, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB13, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB14, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB15, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB16, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB17, CODEPAGE_ISLOWER, 0xFFFF, 0xFFFF },
	{ 0xFB1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB29, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB3A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB3B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB44, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB46, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB49, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB4E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB4F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB50, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB51, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB52, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB53, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB54, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB58, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB5F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB62, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB63, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB64, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB65, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB73, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB75, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB76, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB77, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB78, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB79, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB7A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB7B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB7C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB7D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB7E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB8C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB91, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFB9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBD9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBDA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBDB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBDC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBDD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBDE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBDF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBF9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBFA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBFB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBFC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBFD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBFE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFBFF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC00, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC04, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC0D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC11, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC29, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC3A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC3B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC3D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC44, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC45, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC46, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC47, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC48, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC49, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC4E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC4F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC50, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC51, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC52, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC53, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC54, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC58, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC5F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC62, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC63, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC64, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC65, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC73, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC75, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC76, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC77, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC78, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC79, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC7A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC7B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC7C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC7D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC7E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC8C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC91, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFC9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCBA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCBB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCBC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCBD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCBE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCBF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCC9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCCA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCCB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCCC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCCD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCCE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCCF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCD9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCDA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCDB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCDC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCDD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCDE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCDF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCF9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCFA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCFB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCFC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCFD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCFE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFCFF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD00, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD04, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD0D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD11, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD24, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD25, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD26, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD27, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD28, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD29, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD2A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD2B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD2C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD2D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD2E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD2F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD3A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD3B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD3D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD50, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD51, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD52, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD53, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD54, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD58, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD5F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD62, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD63, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD64, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD65, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD73, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD75, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD76, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD77, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD78, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD79, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD7A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD7B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD7C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD7D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD7E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD8C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFD9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDBA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDBB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDBC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDBD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDBE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDBF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDF9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDFA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFDFB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE21, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE22, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE23, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE30, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE31, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE32, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE33, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE34, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE35, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE36, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE37, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE38, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE39, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE3A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE3B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE3D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE41, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE42, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE43, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE44, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE49, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE4A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE4B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE4C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE4D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE4E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE4F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE50, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE51, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE52, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE54, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE55, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE56, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE57, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE58, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE59, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE5A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE5F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE60, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE62, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE63, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE64, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE65, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE76, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE77, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE78, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE79, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE7A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE7B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE7C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE7D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE7E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE8C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE91, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFE9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEBA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEBB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEBC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEBD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEBE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEBF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEC9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFECA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFECB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFECC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFECD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFECE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFECF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFED9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEDA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEDB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEDC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEDD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEDE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEDF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEEF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEF9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEFA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEFB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEFC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFEFF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF01, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF02, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF03, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF04, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF05, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF06, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF07, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF08, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF09, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF0A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF0B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF0C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF0D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF0E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF0F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF10, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF11, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF12, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF13, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF14, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF15, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF16, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF17, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF18, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF19, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF1A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF1B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF1C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF1D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF1E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF1F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF20, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF21, CODEPAGE_ISUPPER, 0xFF41, 0xFFFF },
	{ 0xFF22, CODEPAGE_ISUPPER, 0xFF42, 0xFFFF },
	{ 0xFF23, CODEPAGE_ISUPPER, 0xFF43, 0xFFFF },
	{ 0xFF24, CODEPAGE_ISUPPER, 0xFF44, 0xFFFF },
	{ 0xFF25, CODEPAGE_ISUPPER, 0xFF45, 0xFFFF },
	{ 0xFF26, CODEPAGE_ISUPPER, 0xFF46, 0xFFFF },
	{ 0xFF27, CODEPAGE_ISUPPER, 0xFF47, 0xFFFF },
	{ 0xFF28, CODEPAGE_ISUPPER, 0xFF48, 0xFFFF },
	{ 0xFF29, CODEPAGE_ISUPPER, 0xFF49, 0xFFFF },
	{ 0xFF2A, CODEPAGE_ISUPPER, 0xFF4A, 0xFFFF },
	{ 0xFF2B, CODEPAGE_ISUPPER, 0xFF4B, 0xFFFF },
	{ 0xFF2C, CODEPAGE_ISUPPER, 0xFF4C, 0xFFFF },
	{ 0xFF2D, CODEPAGE_ISUPPER, 0xFF4D, 0xFFFF },
	{ 0xFF2E, CODEPAGE_ISUPPER, 0xFF4E, 0xFFFF },
	{ 0xFF2F, CODEPAGE_ISUPPER, 0xFF4F, 0xFFFF },
	{ 0xFF30, CODEPAGE_ISUPPER, 0xFF50, 0xFFFF },
	{ 0xFF31, CODEPAGE_ISUPPER, 0xFF51, 0xFFFF },
	{ 0xFF32, CODEPAGE_ISUPPER, 0xFF52, 0xFFFF },
	{ 0xFF33, CODEPAGE_ISUPPER, 0xFF53, 0xFFFF },
	{ 0xFF34, CODEPAGE_ISUPPER, 0xFF54, 0xFFFF },
	{ 0xFF35, CODEPAGE_ISUPPER, 0xFF55, 0xFFFF },
	{ 0xFF36, CODEPAGE_ISUPPER, 0xFF56, 0xFFFF },
	{ 0xFF37, CODEPAGE_ISUPPER, 0xFF57, 0xFFFF },
	{ 0xFF38, CODEPAGE_ISUPPER, 0xFF58, 0xFFFF },
	{ 0xFF39, CODEPAGE_ISUPPER, 0xFF59, 0xFFFF },
	{ 0xFF3A, CODEPAGE_ISUPPER, 0xFF5A, 0xFFFF },
	{ 0xFF3B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF3C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF3D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF3E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF3F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF40, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF41, CODEPAGE_ISLOWER, 0xFFFF, 0xFF21 },
	{ 0xFF42, CODEPAGE_ISLOWER, 0xFFFF, 0xFF22 },
	{ 0xFF43, CODEPAGE_ISLOWER, 0xFFFF, 0xFF23 },
	{ 0xFF44, CODEPAGE_ISLOWER, 0xFFFF, 0xFF24 },
	{ 0xFF45, CODEPAGE_ISLOWER, 0xFFFF, 0xFF25 },
	{ 0xFF46, CODEPAGE_ISLOWER, 0xFFFF, 0xFF26 },
	{ 0xFF47, CODEPAGE_ISLOWER, 0xFFFF, 0xFF27 },
	{ 0xFF48, CODEPAGE_ISLOWER, 0xFFFF, 0xFF28 },
	{ 0xFF49, CODEPAGE_ISLOWER, 0xFFFF, 0xFF29 },
	{ 0xFF4A, CODEPAGE_ISLOWER, 0xFFFF, 0xFF2A },
	{ 0xFF4B, CODEPAGE_ISLOWER, 0xFFFF, 0xFF2B },
	{ 0xFF4C, CODEPAGE_ISLOWER, 0xFFFF, 0xFF2C },
	{ 0xFF4D, CODEPAGE_ISLOWER, 0xFFFF, 0xFF2D },
	{ 0xFF4E, CODEPAGE_ISLOWER, 0xFFFF, 0xFF2E },
	{ 0xFF4F, CODEPAGE_ISLOWER, 0xFFFF, 0xFF2F },
	{ 0xFF50, CODEPAGE_ISLOWER, 0xFFFF, 0xFF30 },
	{ 0xFF51, CODEPAGE_ISLOWER, 0xFFFF, 0xFF31 },
	{ 0xFF52, CODEPAGE_ISLOWER, 0xFFFF, 0xFF32 },
	{ 0xFF53, CODEPAGE_ISLOWER, 0xFFFF, 0xFF33 },
	{ 0xFF54, CODEPAGE_ISLOWER, 0xFFFF, 0xFF34 },
	{ 0xFF55, CODEPAGE_ISLOWER, 0xFFFF, 0xFF35 },
	{ 0xFF56, CODEPAGE_ISLOWER, 0xFFFF, 0xFF36 },
	{ 0xFF57, CODEPAGE_ISLOWER, 0xFFFF, 0xFF37 },
	{ 0xFF58, CODEPAGE_ISLOWER, 0xFFFF, 0xFF38 },
	{ 0xFF59, CODEPAGE_ISLOWER, 0xFFFF, 0xFF39 },
	{ 0xFF5A, CODEPAGE_ISLOWER, 0xFFFF, 0xFF3A },
	{ 0xFF5B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF5C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF5D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF5E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF61, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF62, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF63, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF64, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF65, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF66, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF67, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF68, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF69, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF6A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF6B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF6C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF6D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF6E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF6F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF70, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF71, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF72, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF73, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF74, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF75, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF76, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF77, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF78, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF79, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF7A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF7B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF7C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF7D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF7E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF7F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF80, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF81, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF82, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF83, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF84, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF85, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF86, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF87, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF88, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF89, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF8A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF8B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF8C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF8D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF8E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF8F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF90, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF91, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF92, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF93, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF94, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF95, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF96, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF97, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF98, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF99, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF9A, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF9B, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF9C, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF9D, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF9E, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFF9F, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFA9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFAA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFAB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFAC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFAD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFAE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFAF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFB9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFBA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFBB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFBC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFBD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFBE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFC2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFC3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFC4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFC5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFC6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFC7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFCA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFCB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFCC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFCD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFCE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFCF, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFD2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFD3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFD4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFD5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFD6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFD7, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFDA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFDB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFDC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE0, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE1, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE2, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE3, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE4, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE5, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE6, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE8, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFE9, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFEA, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFEB, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFEC, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFED, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFEE, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF },
	{ 0xFFFD, CODEPAGE_ISNONE, 0xFFFF, 0xFFFF }
};

#ifdef __cplusplus
}
#endif

#endif /* _SMBSRV_CP_UNICODE_H */
