/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2017 Nexenta Systems, Inc.  All rights reserved.
 */

#ifndef _SMB_NTSTATUS_H
#define	_SMB_NTSTATUS_H

/*
 * This file defines the list of Win32 status codes. If you need
 * a status code that is defined in the [MS-ERREF] document but
 * is not listed here, please add it to the file.
 *
 * Be careful not to confuse error codes with status codes. The error
 * codes are listed in nterror.h.  Some mappings between NT status
 * codes and Win32 error codes is provided in the Microsoft knowledge
 * base article Q113996.
 *
 * Also note that this file is used as the input to a small AWK program
 * to generate an error name lookup table.  If you modify this file,
 * please check that a make in libsmb is successful.  At present, the
 * AWK program checks that the NTSTATUS constants are in this format:
 * 0x0123CDEF  Please keep that format.
 *
 * Win32 error codes are 32-bit values with the following format
 * (ntstatus.h):
 *
 *   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
 *   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
 *  +---+-+-+-----------------------+-------------------------------+
 *  |Sev|C|R|     Facility          |               Code            |
 *  +---+-+-+-----------------------+-------------------------------+
 *
 *  Sev     severity code
 *          00 - Success
 *          01 - Informational
 *          10 - Warning
 *          11 - Error
 *
 *  C - is the Customer code flag
 *  R - is a reserved bit
 *  Facility - is the facility code
 *  Code - is the facility's status code
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * One non-NT macro added for getting the severity value
 * from a given NT status code.  Evaluates to one of the
 * SEVERITY values defined below.
 */
#define	NT_SC_SEVERITY(S)	(((S) >> 30) & 3)

/*
 * All NT-compatible from here on.
 * (modulo the "NT_" prefix)
 */

/*
 * Define the severity codes (same as in the NT DDK).
 * These are the top two bits, so shift left 30 bits.
 */
#define	NT_STATUS_SEVERITY_SUCCESS		0
#define	NT_STATUS_SEVERITY_INFORMATIONAL	1	/* 0x40000000 */
#define	NT_STATUS_SEVERITY_WARNING		2	/* 0x80000000 */
#define	NT_STATUS_SEVERITY_ERROR		3	/* 0xC0000000 */

/*
 * Please keep the following defines sorted by number.
 */

#define	NT_STATUS_SUCCESS				0x00000000

/* Facility OS (0x..00....) */
/* All severity zero (success) */
#define	NT_STATUS_ABANDONED				0x00000080
#define	NT_STATUS_USER_APC				0x000000C0
#define	NT_STATUS_KERNEL_APC				0x00000100
#define	NT_STATUS_ALERTED				0x00000101
#define	NT_STATUS_TIMEOUT				0x00000102
#define	NT_STATUS_PENDING				0x00000103
#define	NT_STATUS_REPARSE				0x00000104
#define	NT_STATUS_MORE_ENTRIES				0x00000105
#define	NT_STATUS_NOT_ALL_ASSIGNED			0x00000106
#define	NT_STATUS_SOME_NOT_MAPPED			0x00000107
#define	NT_STATUS_OPLOCK_BREAK_IN_PROGRESS		0x00000108
#define	NT_STATUS_VOLUME_MOUNTED			0x00000109
#define	NT_STATUS_RXACT_COMMITTED			0x0000010A
#define	NT_STATUS_NOTIFY_CLEANUP			0x0000010B
#define	NT_STATUS_NOTIFY_ENUM_DIR			0x0000010C
#define	NT_STATUS_NO_QUOTAS_FOR_ACCOUNT			0x0000010D
#define	NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED	0x0000010E
#define	NT_STATUS_PAGE_FAULT_TRANSITION			0x00000110
#define	NT_STATUS_PAGE_FAULT_DEMAND_ZERO		0x00000111
#define	NT_STATUS_PAGE_FAULT_COPY_ON_WRITE		0x00000112
#define	NT_STATUS_PAGE_FAULT_GUARD_PAGE			0x00000113
#define	NT_STATUS_PAGE_FAULT_PAGING_FILE		0x00000114
#define	NT_STATUS_CACHE_PAGE_LOCKED			0x00000115
#define	NT_STATUS_CRASH_DUMP				0x00000116
#define	NT_STATUS_BUFFER_ALL_ZEROS			0x00000117
#define	NT_STATUS_REPARSE_OBJECT			0x00000118
#define	NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED		0x00000119
#define	NT_STATUS_TRANSLATION_COMPLETE			0x00000120
#define	NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY	0x00000121
#define	NT_STATUS_NOTHING_TO_TERMINATE			0x00000122
#define	NT_STATUS_PROCESS_NOT_IN_JOB			0x00000123
#define	NT_STATUS_PROCESS_IN_JOB			0x00000124
#define	NT_STATUS_VOLSNAP_HIBERNATE_READY		0x00000125
#define	NT_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY	0x00000126
#define	NT_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED	0x00000127
#define	NT_STATUS_INTERRUPT_STILL_CONNECTED		0x00000128
#define	NT_STATUS_PROCESS_CLONED			0x00000129
#define	NT_STATUS_FILE_LOCKED_WITH_ONLY_READERS		0x0000012A
#define	NT_STATUS_FILE_LOCKED_WITH_WRITERS		0x0000012B
#define	NT_STATUS_RESOURCEMANAGER_READ_ONLY		0x00000202
#define	NT_STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE		0x00000215
#define	NT_STATUS_OPLOCK_HANDLE_CLOSED			0x00000216
#define	NT_STATUS_WAIT_FOR_OPLOCK			0x00000367

/* All severity 1 (informational) */
#define	NT_STATUS_OBJECT_NAME_EXISTS			0x40000000
#define	NT_STATUS_THREAD_WAS_SUSPENDED			0x40000001
#define	NT_STATUS_WORKING_SET_LIMIT_RANGE		0x40000002
#define	NT_STATUS_IMAGE_NOT_AT_BASE			0x40000003
#define	NT_STATUS_RXACT_STATE_CREATED			0x40000004
#define	NT_STATUS_SEGMENT_NOTIFICATION			0x40000005
#define	NT_STATUS_LOCAL_USER_SESSION_KEY		0x40000006
#define	NT_STATUS_BAD_CURRENT_DIRECTORY			0x40000007
#define	NT_STATUS_SERIAL_MORE_WRITES			0x40000008
#define	NT_STATUS_REGISTRY_RECOVERED			0x40000009
#define	NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP		0x4000000A
#define	NT_STATUS_FT_WRITE_RECOVERY			0x4000000B
#define	NT_STATUS_SERIAL_COUNTER_TIMEOUT		0x4000000C
#define	NT_STATUS_NULL_LM_PASSWORD			0x4000000D
#define	NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH		0x4000000E
#define	NT_STATUS_RECEIVE_PARTIAL			0x4000000F
#define	NT_STATUS_RECEIVE_EXPEDITED			0x40000010
#define	NT_STATUS_RECEIVE_PARTIAL_EXPEDITED		0x40000011
#define	NT_STATUS_EVENT_DONE				0x40000012
#define	NT_STATUS_EVENT_PENDING				0x40000013
#define	NT_STATUS_CHECKING_FILE_SYSTEM			0x40000014
#define	NT_STATUS_FATAL_APP_EXIT			0x40000015
#define	NT_STATUS_PREDEFINED_HANDLE			0x40000016
#define	NT_STATUS_WAS_UNLOCKED				0x40000017
#define	NT_STATUS_SERVICE_NOTIFICATION			0x40000018
#define	NT_STATUS_WAS_LOCKED				0x40000019
#define	NT_STATUS_LOG_HARD_ERROR			0x4000001A
#define	NT_STATUS_ALREADY_WIN32				0x4000001B
#define	NT_STATUS_WX86_UNSIMULATE			0x4000001C
#define	NT_STATUS_WX86_CONTINUE				0x4000001D
#define	NT_STATUS_WX86_SINGLE_STEP			0x4000001E
#define	NT_STATUS_WX86_BREAKPOINT			0x4000001F
#define	NT_STATUS_WX86_EXCEPTION_CONTINUE		0x40000020
#define	NT_STATUS_WX86_EXCEPTION_LASTCHANCE		0x40000021
#define	NT_STATUS_WX86_EXCEPTION_CHAIN			0x40000022
#define	NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE	0x40000023
#define	NT_STATUS_NO_YIELD_PERFORMED			0x40000024
#define	NT_STATUS_TIMER_RESUME_IGNORED			0x40000025
#define	NT_STATUS_ARBITRATION_UNHANDLED			0x40000026
#define	NT_STATUS_CARDBUS_NOT_SUPPORTED			0x40000027
#define	NT_STATUS_WX86_CREATEWX86TIB			0x40000028
#define	NT_STATUS_MP_PROCESSOR_MISMATCH			0x40000029
#define	NT_STATUS_HIBERNATED				0x4000002A
#define	NT_STATUS_RESUME_HIBERNATION			0x4000002B
#define	NT_STATUS_FIRMWARE_UPDATED			0x4000002C
#define	NT_STATUS_DRIVERS_LEAKING_LOCKED_PAGES		0x4000002D
#define	NT_STATUS_MESSAGE_RETRIEVED			0x4000002E
#define	NT_STATUS_SYSTEM_POWERSTATE_TRANSITION		0x4000002F
#define	NT_STATUS_ALPC_CHECK_COMPLETION_LIST		0x40000030
#define	NT_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION	0x40000031
#define	NT_STATUS_ACCESS_AUDIT_BY_POLICY		0x40000032
#define	NT_STATUS_ABANDON_HIBERFILE			0x40000033
#define	NT_STATUS_BIZRULES_NOT_ENABLED			0x40000034
#define	NT_STATUS_WAKE_SYSTEM				0x40000294
#define	NT_STATUS_DS_SHUTTING_DOWN			0x40000370

/* Facility RPC Runtime (0x..02....) */
#define	RPC_NT_UUID_LOCAL_ONLY				0x40020056
#define	RPC_NT_SEND_INCOMPLETE				0x400200AF

/* All severity 2 (warning) */
#define	NT_STATUS_GUARD_PAGE_VIOLATION			0x80000001
#define	NT_STATUS_DATATYPE_MISALIGNMENT			0x80000002
#define	NT_STATUS_BREAKPOINT				0x80000003
#define	NT_STATUS_SINGLE_STEP				0x80000004
#define	NT_STATUS_BUFFER_OVERFLOW			0x80000005
#define	NT_STATUS_NO_MORE_FILES				0x80000006
#define	NT_STATUS_WAKE_SYSTEM_DEBUGGER			0x80000007
#define	NT_STATUS_HANDLES_CLOSED			0x8000000A
#define	NT_STATUS_NO_INHERITANCE			0x8000000B
#define	NT_STATUS_GUID_SUBSTITUTION_MADE		0x8000000C
#define	NT_STATUS_PARTIAL_COPY				0x8000000D
#define	NT_STATUS_DEVICE_PAPER_EMPTY			0x8000000E
#define	NT_STATUS_DEVICE_POWERED_OFF			0x8000000F
#define	NT_STATUS_DEVICE_OFF_LINE			0x80000010
#define	NT_STATUS_DEVICE_BUSY				0x80000011
#define	NT_STATUS_NO_MORE_EAS				0x80000012
#define	NT_STATUS_INVALID_EA_NAME			0x80000013
#define	NT_STATUS_EA_LIST_INCONSISTENT			0x80000014
#define	NT_STATUS_INVALID_EA_FLAG			0x80000015
#define	NT_STATUS_VERIFY_REQUIRED			0x80000016
#define	NT_STATUS_EXTRANEOUS_INFORMATION		0x80000017
#define	NT_STATUS_RXACT_COMMIT_NECESSARY		0x80000018
#define	NT_STATUS_NO_MORE_ENTRIES			0x8000001A
#define	NT_STATUS_FILEMARK_DETECTED			0x8000001B
#define	NT_STATUS_MEDIA_CHANGED				0x8000001C
#define	NT_STATUS_BUS_RESET				0x8000001D
#define	NT_STATUS_END_OF_MEDIA				0x8000001E
#define	NT_STATUS_BEGINNING_OF_MEDIA			0x8000001F
#define	NT_STATUS_MEDIA_CHECK				0x80000020
#define	NT_STATUS_SETMARK_DETECTED			0x80000021
#define	NT_STATUS_NO_DATA_DETECTED			0x80000022
#define	NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES		0x80000023
#define	NT_STATUS_SERVER_HAS_OPEN_HANDLES		0x80000024
#define	NT_STATUS_ALREADY_DISCONNECTED			0x80000025
#define	NT_STATUS_LONGJUMP				0x80000026
#define	NT_STATUS_CLEANER_CARTRIDGE_INSTALLED		0x80000027
#define	NT_STATUS_PLUGPLAY_QUERY_VETOED			0x80000028
#define	NT_STATUS_UNWIND_CONSOLIDATE			0x80000029
#define	NT_STATUS_REGISTRY_HIVE_RECOVERED		0x8000002A
#define	NT_STATUS_DLL_MIGHT_BE_INSECURE			0x8000002B
#define	NT_STATUS_DLL_MIGHT_BE_INCOMPATIBLE		0x8000002C
#define	NT_STATUS_STOPPED_ON_SYMLINK			0x8000002D
#define	NT_STATUS_CANNOT_GRANT_REQUESTED_OPLOCK		0x8000002E
#define	NT_STATUS_DEVICE_REQUIRES_CLEANING		0x80000288
#define	NT_STATUS_DEVICE_DOOR_OPEN			0x80000289
#define	NT_STATUS_DATA_LOST_REPAIR			0x80000803

/* facility cluster (0x8013....) etc, not used */

/* All severity 3 (error) */
#define	NT_STATUS_UNSUCCESSFUL				0xC0000001
#define	NT_STATUS_NOT_IMPLEMENTED			0xC0000002
#define	NT_STATUS_INVALID_INFO_CLASS			0xC0000003
#define	NT_STATUS_INFO_LENGTH_MISMATCH			0xC0000004
#define	NT_STATUS_ACCESS_VIOLATION			0xC0000005
#define	NT_STATUS_IN_PAGE_ERROR				0xC0000006
#define	NT_STATUS_PAGEFILE_QUOTA			0xC0000007
#define	NT_STATUS_INVALID_HANDLE			0xC0000008
#define	NT_STATUS_BAD_INITIAL_STACK			0xC0000009
#define	NT_STATUS_BAD_INITIAL_PC			0xC000000A
#define	NT_STATUS_INVALID_CID				0xC000000B
#define	NT_STATUS_TIMER_NOT_CANCELED			0xC000000C
#define	NT_STATUS_INVALID_PARAMETER			0xC000000D
#define	NT_STATUS_NO_SUCH_DEVICE			0xC000000E
#define	NT_STATUS_NO_SUCH_FILE				0xC000000F
#define	NT_STATUS_INVALID_DEVICE_REQUEST		0xC0000010
#define	NT_STATUS_END_OF_FILE				0xC0000011
#define	NT_STATUS_WRONG_VOLUME				0xC0000012
#define	NT_STATUS_NO_MEDIA_IN_DEVICE			0xC0000013
#define	NT_STATUS_UNRECOGNIZED_MEDIA			0xC0000014
#define	NT_STATUS_NONEXISTENT_SECTOR			0xC0000015
#define	NT_STATUS_MORE_PROCESSING_REQUIRED		0xC0000016
#define	NT_STATUS_NO_MEMORY				0xC0000017
#define	NT_STATUS_CONFLICTING_ADDRESSES			0xC0000018
#define	NT_STATUS_NOT_MAPPED_VIEW			0xC0000019
#define	NT_STATUS_UNABLE_TO_FREE_VM			0xC000001A
#define	NT_STATUS_UNABLE_TO_DELETE_SECTION		0xC000001B
#define	NT_STATUS_INVALID_SYSTEM_SERVICE		0xC000001C
#define	NT_STATUS_ILLEGAL_INSTRUCTION			0xC000001D
#define	NT_STATUS_INVALID_LOCK_SEQUENCE			0xC000001E
#define	NT_STATUS_INVALID_VIEW_SIZE			0xC000001F
#define	NT_STATUS_INVALID_FILE_FOR_SECTION		0xC0000020
#define	NT_STATUS_ALREADY_COMMITTED			0xC0000021
#define	NT_STATUS_ACCESS_DENIED				0xC0000022
#define	NT_STATUS_BUFFER_TOO_SMALL			0xC0000023
#define	NT_STATUS_OBJECT_TYPE_MISMATCH			0xC0000024
#define	NT_STATUS_NONCONTINUABLE_EXCEPTION		0xC0000025
#define	NT_STATUS_INVALID_DISPOSITION			0xC0000026
#define	NT_STATUS_UNWIND				0xC0000027
#define	NT_STATUS_BAD_STACK				0xC0000028
#define	NT_STATUS_INVALID_UNWIND_TARGET			0xC0000029
#define	NT_STATUS_NOT_LOCKED				0xC000002A
#define	NT_STATUS_PARITY_ERROR				0xC000002B
#define	NT_STATUS_UNABLE_TO_DECOMMIT_VM			0xC000002C
#define	NT_STATUS_NOT_COMMITTED				0xC000002D
#define	NT_STATUS_INVALID_PORT_ATTRIBUTES		0xC000002E
#define	NT_STATUS_PORT_MESSAGE_TOO_LONG			0xC000002F
#define	NT_STATUS_INVALID_PARAMETER_MIX			0xC0000030
#define	NT_STATUS_INVALID_QUOTA_LOWER			0xC0000031
#define	NT_STATUS_DISK_CORRUPT_ERROR			0xC0000032
#define	NT_STATUS_OBJECT_NAME_INVALID			0xC0000033
#define	NT_STATUS_OBJECT_NAME_NOT_FOUND			0xC0000034
#define	NT_STATUS_OBJECT_NAME_COLLISION			0xC0000035
#define	NT_STATUS_PORT_DISCONNECTED			0xC0000037
#define	NT_STATUS_DEVICE_ALREADY_ATTACHED		0xC0000038
#define	NT_STATUS_OBJECT_PATH_INVALID			0xC0000039
#define	NT_STATUS_OBJECT_PATH_NOT_FOUND			0xC000003A
#define	NT_STATUS_OBJECT_PATH_SYNTAX_BAD		0xC000003B
#define	NT_STATUS_DATA_OVERRUN				0xC000003C
#define	NT_STATUS_DATA_LATE_ERROR			0xC000003D
#define	NT_STATUS_DATA_ERROR				0xC000003E
#define	NT_STATUS_CRC_ERROR				0xC000003F
#define	NT_STATUS_SECTION_TOO_BIG			0xC0000040
#define	NT_STATUS_PORT_CONNECTION_REFUSED		0xC0000041
#define	NT_STATUS_INVALID_PORT_HANDLE			0xC0000042
#define	NT_STATUS_SHARING_VIOLATION			0xC0000043
#define	NT_STATUS_QUOTA_EXCEEDED			0xC0000044
#define	NT_STATUS_INVALID_PAGE_PROTECTION		0xC0000045
#define	NT_STATUS_MUTANT_NOT_OWNED			0xC0000046
#define	NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED		0xC0000047
#define	NT_STATUS_PORT_ALREADY_SET			0xC0000048
#define	NT_STATUS_SECTION_NOT_IMAGE			0xC0000049
#define	NT_STATUS_SUSPEND_COUNT_EXCEEDED		0xC000004A
#define	NT_STATUS_THREAD_IS_TERMINATING			0xC000004B
#define	NT_STATUS_BAD_WORKING_SET_LIMIT			0xC000004C
#define	NT_STATUS_INCOMPATIBLE_FILE_MAP			0xC000004D
#define	NT_STATUS_SECTION_PROTECTION			0xC000004E
#define	NT_STATUS_EAS_NOT_SUPPORTED			0xC000004F
#define	NT_STATUS_EA_TOO_LARGE				0xC0000050
#define	NT_STATUS_NONEXISTENT_EA_ENTRY			0xC0000051
#define	NT_STATUS_NO_EAS_ON_FILE			0xC0000052
#define	NT_STATUS_EA_CORRUPT_ERROR			0xC0000053
#define	NT_STATUS_FILE_LOCK_CONFLICT			0xC0000054
#define	NT_STATUS_LOCK_NOT_GRANTED			0xC0000055
#define	NT_STATUS_DELETE_PENDING			0xC0000056
#define	NT_STATUS_CTL_FILE_NOT_SUPPORTED		0xC0000057
#define	NT_STATUS_UNKNOWN_REVISION			0xC0000058
#define	NT_STATUS_REVISION_MISMATCH			0xC0000059
#define	NT_STATUS_INVALID_OWNER				0xC000005A
#define	NT_STATUS_INVALID_PRIMARY_GROUP			0xC000005B
#define	NT_STATUS_NO_IMPERSONATION_TOKEN		0xC000005C
#define	NT_STATUS_CANT_DISABLE_MANDATORY		0xC000005D
#define	NT_STATUS_NO_LOGON_SERVERS			0xC000005E
#define	NT_STATUS_NO_SUCH_LOGON_SESSION			0xC000005F
#define	NT_STATUS_NO_SUCH_PRIVILEGE			0xC0000060
#define	NT_STATUS_PRIVILEGE_NOT_HELD			0xC0000061
#define	NT_STATUS_INVALID_ACCOUNT_NAME			0xC0000062
#define	NT_STATUS_USER_EXISTS				0xC0000063
#define	NT_STATUS_NO_SUCH_USER				0xC0000064
#define	NT_STATUS_GROUP_EXISTS				0xC0000065
#define	NT_STATUS_NO_SUCH_GROUP				0xC0000066
#define	NT_STATUS_MEMBER_IN_GROUP			0xC0000067
#define	NT_STATUS_MEMBER_NOT_IN_GROUP			0xC0000068
#define	NT_STATUS_LAST_ADMIN				0xC0000069
#define	NT_STATUS_WRONG_PASSWORD			0xC000006A
#define	NT_STATUS_ILL_FORMED_PASSWORD			0xC000006B
#define	NT_STATUS_PASSWORD_RESTRICTION			0xC000006C
#define	NT_STATUS_LOGON_FAILURE				0xC000006D
#define	NT_STATUS_ACCOUNT_RESTRICTION			0xC000006E
#define	NT_STATUS_INVALID_LOGON_HOURS			0xC000006F
#define	NT_STATUS_INVALID_WORKSTATION			0xC0000070
#define	NT_STATUS_PASSWORD_EXPIRED			0xC0000071
#define	NT_STATUS_ACCOUNT_DISABLED			0xC0000072
#define	NT_STATUS_NONE_MAPPED				0xC0000073
#define	NT_STATUS_TOO_MANY_LUIDS_REQUESTED		0xC0000074
#define	NT_STATUS_LUIDS_EXHAUSTED			0xC0000075
#define	NT_STATUS_INVALID_SUB_AUTHORITY			0xC0000076
#define	NT_STATUS_INVALID_ACL				0xC0000077
#define	NT_STATUS_INVALID_SID				0xC0000078
#define	NT_STATUS_INVALID_SECURITY_DESCR		0xC0000079
#define	NT_STATUS_PROCEDURE_NOT_FOUND			0xC000007A
#define	NT_STATUS_INVALID_IMAGE_FORMAT			0xC000007B
#define	NT_STATUS_NO_TOKEN				0xC000007C
#define	NT_STATUS_BAD_INHERITANCE_ACL			0xC000007D
#define	NT_STATUS_RANGE_NOT_LOCKED			0xC000007E
#define	NT_STATUS_DISK_FULL				0xC000007F
#define	NT_STATUS_SERVER_DISABLED			0xC0000080
#define	NT_STATUS_SERVER_NOT_DISABLED			0xC0000081
#define	NT_STATUS_TOO_MANY_GUIDS_REQUESTED		0xC0000082
#define	NT_STATUS_GUIDS_EXHAUSTED			0xC0000083
#define	NT_STATUS_INVALID_ID_AUTHORITY			0xC0000084
#define	NT_STATUS_AGENTS_EXHAUSTED			0xC0000085
#define	NT_STATUS_INVALID_VOLUME_LABEL			0xC0000086
#define	NT_STATUS_SECTION_NOT_EXTENDED			0xC0000087
#define	NT_STATUS_NOT_MAPPED_DATA			0xC0000088
#define	NT_STATUS_RESOURCE_DATA_NOT_FOUND		0xC0000089
#define	NT_STATUS_RESOURCE_TYPE_NOT_FOUND		0xC000008A
#define	NT_STATUS_RESOURCE_NAME_NOT_FOUND		0xC000008B
#define	NT_STATUS_ARRAY_BOUNDS_EXCEEDED			0xC000008C
#define	NT_STATUS_FLOAT_DENORMAL_OPERAND		0xC000008D
#define	NT_STATUS_FLOAT_DIVIDE_BY_ZERO			0xC000008E
#define	NT_STATUS_FLOAT_INEXACT_RESULT			0xC000008F
#define	NT_STATUS_FLOAT_INVALID_OPERATION		0xC0000090
#define	NT_STATUS_FLOAT_OVERFLOW			0xC0000091
#define	NT_STATUS_FLOAT_STACK_CHECK			0xC0000092
#define	NT_STATUS_FLOAT_UNDERFLOW			0xC0000093
#define	NT_STATUS_INTEGER_DIVIDE_BY_ZERO		0xC0000094
#define	NT_STATUS_INTEGER_OVERFLOW			0xC0000095
#define	NT_STATUS_PRIVILEGED_INSTRUCTION		0xC0000096
#define	NT_STATUS_TOO_MANY_PAGING_FILES			0xC0000097
#define	NT_STATUS_FILE_INVALID				0xC0000098
#define	NT_STATUS_ALLOTTED_SPACE_EXCEEDED		0xC0000099
#define	NT_STATUS_INSUFFICIENT_RESOURCES		0xC000009A
#define	NT_STATUS_DFS_EXIT_PATH_FOUND			0xC000009B
#define	NT_STATUS_DEVICE_DATA_ERROR			0xC000009C
#define	NT_STATUS_DEVICE_NOT_CONNECTED			0xC000009D
#define	NT_STATUS_DEVICE_POWER_FAILURE			0xC000009E
#define	NT_STATUS_FREE_VM_NOT_AT_BASE			0xC000009F
#define	NT_STATUS_MEMORY_NOT_ALLOCATED			0xC00000A0
#define	NT_STATUS_WORKING_SET_QUOTA			0xC00000A1
#define	NT_STATUS_MEDIA_WRITE_PROTECTED			0xC00000A2
#define	NT_STATUS_DEVICE_NOT_READY			0xC00000A3
#define	NT_STATUS_INVALID_GROUP_ATTRIBUTES		0xC00000A4
#define	NT_STATUS_BAD_IMPERSONATION_LEVEL		0xC00000A5
#define	NT_STATUS_CANT_OPEN_ANONYMOUS			0xC00000A6
#define	NT_STATUS_BAD_VALIDATION_CLASS			0xC00000A7
#define	NT_STATUS_BAD_TOKEN_TYPE			0xC00000A8
#define	NT_STATUS_BAD_MASTER_BOOT_RECORD		0xC00000A9
#define	NT_STATUS_INSTRUCTION_MISALIGNMENT		0xC00000AA
#define	NT_STATUS_INSTANCE_NOT_AVAILABLE		0xC00000AB
#define	NT_STATUS_PIPE_NOT_AVAILABLE			0xC00000AC
#define	NT_STATUS_INVALID_PIPE_STATE			0xC00000AD
#define	NT_STATUS_PIPE_BUSY				0xC00000AE
#define	NT_STATUS_ILLEGAL_FUNCTION			0xC00000AF
#define	NT_STATUS_PIPE_DISCONNECTED			0xC00000B0
#define	NT_STATUS_PIPE_CLOSING				0xC00000B1
#define	NT_STATUS_PIPE_CONNECTED			0xC00000B2
#define	NT_STATUS_PIPE_LISTENING			0xC00000B3
#define	NT_STATUS_INVALID_READ_MODE			0xC00000B4
#define	NT_STATUS_IO_TIMEOUT				0xC00000B5
#define	NT_STATUS_FILE_FORCED_CLOSED			0xC00000B6
#define	NT_STATUS_PROFILING_NOT_STARTED			0xC00000B7
#define	NT_STATUS_PROFILING_NOT_STOPPED			0xC00000B8
#define	NT_STATUS_COULD_NOT_INTERPRET			0xC00000B9
#define	NT_STATUS_FILE_IS_A_DIRECTORY			0xC00000BA
#define	NT_STATUS_NOT_SUPPORTED				0xC00000BB
#define	NT_STATUS_REMOTE_NOT_LISTENING			0xC00000BC
#define	NT_STATUS_DUPLICATE_NAME			0xC00000BD
#define	NT_STATUS_BAD_NETWORK_PATH			0xC00000BE
#define	NT_STATUS_NETWORK_BUSY				0xC00000BF
#define	NT_STATUS_DEVICE_DOES_NOT_EXIST			0xC00000C0
#define	NT_STATUS_TOO_MANY_COMMANDS			0xC00000C1
#define	NT_STATUS_ADAPTER_HARDWARE_ERROR		0xC00000C2
#define	NT_STATUS_INVALID_NETWORK_RESPONSE		0xC00000C3
#define	NT_STATUS_UNEXPECTED_NETWORK_ERROR		0xC00000C4
#define	NT_STATUS_BAD_REMOTE_ADAPTER			0xC00000C5
#define	NT_STATUS_PRINT_QUEUE_FULL			0xC00000C6
#define	NT_STATUS_NO_SPOOL_SPACE			0xC00000C7
#define	NT_STATUS_PRINT_CANCELLED			0xC00000C8
#define	NT_STATUS_NETWORK_NAME_DELETED			0xC00000C9
#define	NT_STATUS_NETWORK_ACCESS_DENIED			0xC00000CA
#define	NT_STATUS_BAD_DEVICE_TYPE			0xC00000CB
#define	NT_STATUS_BAD_NETWORK_NAME			0xC00000CC
#define	NT_STATUS_TOO_MANY_NAMES			0xC00000CD
#define	NT_STATUS_TOO_MANY_SESSIONS			0xC00000CE
#define	NT_STATUS_SHARING_PAUSED			0xC00000CF
#define	NT_STATUS_REQUEST_NOT_ACCEPTED			0xC00000D0
#define	NT_STATUS_REDIRECTOR_PAUSED			0xC00000D1
#define	NT_STATUS_NET_WRITE_FAULT			0xC00000D2
#define	NT_STATUS_PROFILING_AT_LIMIT			0xC00000D3
#define	NT_STATUS_NOT_SAME_DEVICE			0xC00000D4
#define	NT_STATUS_FILE_RENAMED				0xC00000D5
#define	NT_STATUS_VIRTUAL_CIRCUIT_CLOSED		0xC00000D6
#define	NT_STATUS_NO_SECURITY_ON_OBJECT			0xC00000D7
#define	NT_STATUS_CANT_WAIT				0xC00000D8
#define	NT_STATUS_PIPE_EMPTY				0xC00000D9
#define	NT_STATUS_CANT_ACCESS_DOMAIN_INFO		0xC00000DA
#define	NT_STATUS_CANT_TERMINATE_SELF			0xC00000DB
#define	NT_STATUS_INVALID_SERVER_STATE			0xC00000DC
#define	NT_STATUS_INVALID_DOMAIN_STATE			0xC00000DD
#define	NT_STATUS_INVALID_DOMAIN_ROLE			0xC00000DE
#define	NT_STATUS_NO_SUCH_DOMAIN			0xC00000DF
#define	NT_STATUS_DOMAIN_EXISTS				0xC00000E0
#define	NT_STATUS_DOMAIN_LIMIT_EXCEEDED			0xC00000E1
#define	NT_STATUS_OPLOCK_NOT_GRANTED			0xC00000E2
#define	NT_STATUS_INVALID_OPLOCK_PROTOCOL		0xC00000E3
#define	NT_STATUS_INTERNAL_DB_CORRUPTION		0xC00000E4
#define	NT_STATUS_INTERNAL_ERROR			0xC00000E5
#define	NT_STATUS_GENERIC_NOT_MAPPED			0xC00000E6
#define	NT_STATUS_BAD_DESCRIPTOR_FORMAT			0xC00000E7
#define	NT_STATUS_INVALID_USER_BUFFER			0xC00000E8
#define	NT_STATUS_UNEXPECTED_IO_ERROR			0xC00000E9
#define	NT_STATUS_UNEXPECTED_MM_CREATE_ERR		0xC00000EA
#define	NT_STATUS_UNEXPECTED_MM_MAP_ERROR		0xC00000EB
#define	NT_STATUS_UNEXPECTED_MM_EXTEND_ERR		0xC00000EC
#define	NT_STATUS_NOT_LOGON_PROCESS			0xC00000ED
#define	NT_STATUS_LOGON_SESSION_EXISTS			0xC00000EE
#define	NT_STATUS_INVALID_PARAMETER_1			0xC00000EF
#define	NT_STATUS_INVALID_PARAMETER_2			0xC00000F0
#define	NT_STATUS_INVALID_PARAMETER_3			0xC00000F1
#define	NT_STATUS_INVALID_PARAMETER_4			0xC00000F2
#define	NT_STATUS_INVALID_PARAMETER_5			0xC00000F3
#define	NT_STATUS_INVALID_PARAMETER_6			0xC00000F4
#define	NT_STATUS_INVALID_PARAMETER_7			0xC00000F5
#define	NT_STATUS_INVALID_PARAMETER_8			0xC00000F6
#define	NT_STATUS_INVALID_PARAMETER_9			0xC00000F7
#define	NT_STATUS_INVALID_PARAMETER_10			0xC00000F8
#define	NT_STATUS_INVALID_PARAMETER_11			0xC00000F9
#define	NT_STATUS_INVALID_PARAMETER_12			0xC00000FA
#define	NT_STATUS_REDIRECTOR_NOT_STARTED		0xC00000FB
#define	NT_STATUS_REDIRECTOR_STARTED			0xC00000FC
#define	NT_STATUS_STACK_OVERFLOW			0xC00000FD
#define	NT_STATUS_NO_SUCH_PACKAGE			0xC00000FE
#define	NT_STATUS_BAD_FUNCTION_TABLE			0xC00000FF
#define	NT_STATUS_VARIABLE_NOT_FOUND			0xC0000100
#define	NT_STATUS_DIRECTORY_NOT_EMPTY			0xC0000101
#define	NT_STATUS_FILE_CORRUPT_ERROR			0xC0000102
#define	NT_STATUS_NOT_A_DIRECTORY			0xC0000103
#define	NT_STATUS_BAD_LOGON_SESSION_STATE		0xC0000104
#define	NT_STATUS_LOGON_SESSION_COLLISION		0xC0000105
#define	NT_STATUS_NAME_TOO_LONG				0xC0000106
#define	NT_STATUS_FILES_OPEN				0xC0000107
#define	NT_STATUS_CONNECTION_IN_USE			0xC0000108
#define	NT_STATUS_MESSAGE_NOT_FOUND			0xC0000109
#define	NT_STATUS_PROCESS_IS_TERMINATING		0xC000010A
#define	NT_STATUS_INVALID_LOGON_TYPE			0xC000010B
#define	NT_STATUS_NO_GUID_TRANSLATION			0xC000010C
#define	NT_STATUS_CANNOT_IMPERSONATE			0xC000010D
#define	NT_STATUS_IMAGE_ALREADY_LOADED			0xC000010E
/* Old: NT_STATUS_ABIOS_... 0xC000010F - 0xC0000116 */
#define	NT_STATUS_NO_LDT				0xC0000117
#define	NT_STATUS_INVALID_LDT_SIZE			0xC0000118
#define	NT_STATUS_INVALID_LDT_OFFSET			0xC0000119
#define	NT_STATUS_INVALID_LDT_DESCRIPTOR		0xC000011A
#define	NT_STATUS_INVALID_IMAGE_NE_FORMAT		0xC000011B
#define	NT_STATUS_RXACT_INVALID_STATE			0xC000011C
#define	NT_STATUS_RXACT_COMMIT_FAILURE			0xC000011D
#define	NT_STATUS_MAPPED_FILE_SIZE_ZERO			0xC000011E
#define	NT_STATUS_TOO_MANY_OPENED_FILES			0xC000011F
#define	NT_STATUS_CANCELLED				0xC0000120
#define	NT_STATUS_CANNOT_DELETE				0xC0000121
#define	NT_STATUS_INVALID_COMPUTER_NAME			0xC0000122
#define	NT_STATUS_FILE_DELETED				0xC0000123
#define	NT_STATUS_SPECIAL_ACCOUNT			0xC0000124
#define	NT_STATUS_SPECIAL_GROUP				0xC0000125
#define	NT_STATUS_SPECIAL_USER				0xC0000126
#define	NT_STATUS_MEMBERS_PRIMARY_GROUP			0xC0000127
#define	NT_STATUS_FILE_CLOSED				0xC0000128
#define	NT_STATUS_TOO_MANY_THREADS			0xC0000129
#define	NT_STATUS_THREAD_NOT_IN_PROCESS			0xC000012A
#define	NT_STATUS_TOKEN_ALREADY_IN_USE			0xC000012B
#define	NT_STATUS_PAGEFILE_QUOTA_EXCEEDED		0xC000012C
#define	NT_STATUS_COMMITMENT_LIMIT			0xC000012D
#define	NT_STATUS_INVALID_IMAGE_LE_FORMAT		0xC000012E
#define	NT_STATUS_INVALID_IMAGE_NOT_MZ			0xC000012F
#define	NT_STATUS_INVALID_IMAGE_PROTECT			0xC0000130
#define	NT_STATUS_INVALID_IMAGE_WIN_16			0xC0000131
#define	NT_STATUS_LOGON_SERVER_CONFLICT			0xC0000132
#define	NT_STATUS_TIME_DIFFERENCE_AT_DC			0xC0000133
#define	NT_STATUS_SYNCHRONIZATION_REQUIRED		0xC0000134
#define	NT_STATUS_DLL_NOT_FOUND				0xC0000135
#define	NT_STATUS_OPEN_FAILED				0xC0000136
#define	NT_STATUS_IO_PRIVILEGE_FAILED			0xC0000137
#define	NT_STATUS_ORDINAL_NOT_FOUND			0xC0000138
#define	NT_STATUS_ENTRYPOINT_NOT_FOUND			0xC0000139
#define	NT_STATUS_CONTROL_C_EXIT			0xC000013A
#define	NT_STATUS_LOCAL_DISCONNECT			0xC000013B
#define	NT_STATUS_REMOTE_DISCONNECT			0xC000013C
#define	NT_STATUS_REMOTE_RESOURCES			0xC000013D
#define	NT_STATUS_LINK_FAILED				0xC000013E
#define	NT_STATUS_LINK_TIMEOUT				0xC000013F
#define	NT_STATUS_INVALID_CONNECTION			0xC0000140
#define	NT_STATUS_INVALID_ADDRESS			0xC0000141
#define	NT_STATUS_DLL_INIT_FAILED			0xC0000142
#define	NT_STATUS_MISSING_SYSTEMFILE			0xC0000143
#define	NT_STATUS_UNHANDLED_EXCEPTION			0xC0000144
#define	NT_STATUS_APP_INIT_FAILURE			0xC0000145
#define	NT_STATUS_PAGEFILE_CREATE_FAILED		0xC0000146
#define	NT_STATUS_NO_PAGEFILE				0xC0000147
#define	NT_STATUS_INVALID_LEVEL				0xC0000148
#define	NT_STATUS_WRONG_PASSWORD_CORE			0xC0000149
#define	NT_STATUS_ILLEGAL_FLOAT_CONTEXT			0xC000014A
#define	NT_STATUS_PIPE_BROKEN				0xC000014B
#define	NT_STATUS_REGISTRY_CORRUPT			0xC000014C
#define	NT_STATUS_REGISTRY_IO_FAILED			0xC000014D
#define	NT_STATUS_NO_EVENT_PAIR				0xC000014E
#define	NT_STATUS_UNRECOGNIZED_VOLUME			0xC000014F
#define	NT_STATUS_SERIAL_NO_DEVICE_INITED		0xC0000150
#define	NT_STATUS_NO_SUCH_ALIAS				0xC0000151
#define	NT_STATUS_MEMBER_NOT_IN_ALIAS			0xC0000152
#define	NT_STATUS_MEMBER_IN_ALIAS			0xC0000153
#define	NT_STATUS_ALIAS_EXISTS				0xC0000154
#define	NT_STATUS_LOGON_NOT_GRANTED			0xC0000155
#define	NT_STATUS_TOO_MANY_SECRETS			0xC0000156
#define	NT_STATUS_SECRET_TOO_LONG			0xC0000157
#define	NT_STATUS_INTERNAL_DB_ERROR			0xC0000158
#define	NT_STATUS_FULLSCREEN_MODE			0xC0000159
#define	NT_STATUS_TOO_MANY_CONTEXT_IDS			0xC000015A
#define	NT_STATUS_LOGON_TYPE_NOT_GRANTED		0xC000015B
#define	NT_STATUS_NOT_REGISTRY_FILE			0xC000015C
#define	NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED		0xC000015D
#define	NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR		0xC000015E
#define	NT_STATUS_FT_MISSING_MEMBER			0xC000015F
#define	NT_STATUS_ILL_FORMED_SERVICE_ENTRY		0xC0000160
#define	NT_STATUS_ILLEGAL_CHARACTER			0xC0000161
#define	NT_STATUS_UNMAPPABLE_CHARACTER			0xC0000162
#define	NT_STATUS_UNDEFINED_CHARACTER			0xC0000163
#define	NT_STATUS_FLOPPY_VOLUME				0xC0000164
#define	NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND		0xC0000165
#define	NT_STATUS_FLOPPY_WRONG_CYLINDER			0xC0000166
#define	NT_STATUS_FLOPPY_UNKNOWN_ERROR			0xC0000167
#define	NT_STATUS_FLOPPY_BAD_REGISTERS			0xC0000168
#define	NT_STATUS_DISK_RECALIBRATE_FAILED		0xC0000169
#define	NT_STATUS_DISK_OPERATION_FAILED			0xC000016A
#define	NT_STATUS_DISK_RESET_FAILED			0xC000016B
#define	NT_STATUS_SHARED_IRQ_BUSY			0xC000016C
#define	NT_STATUS_FT_ORPHANING				0xC000016D
#define	NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT	0xC000016E
#define	NT_STATUS_PARTITION_FAILURE			0xC0000172
#define	NT_STATUS_INVALID_BLOCK_LENGTH			0xC0000173
#define	NT_STATUS_DEVICE_NOT_PARTITIONED		0xC0000174
#define	NT_STATUS_UNABLE_TO_LOCK_MEDIA			0xC0000175
#define	NT_STATUS_UNABLE_TO_UNLOAD_MEDIA		0xC0000176
#define	NT_STATUS_EOM_OVERFLOW				0xC0000177
#define	NT_STATUS_NO_MEDIA				0xC0000178
#define	NT_STATUS_NO_SUCH_MEMBER			0xC000017A
#define	NT_STATUS_INVALID_MEMBER			0xC000017B
#define	NT_STATUS_KEY_DELETED				0xC000017C
#define	NT_STATUS_NO_LOG_SPACE				0xC000017D
#define	NT_STATUS_TOO_MANY_SIDS				0xC000017E
#define	NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED		0xC000017F
#define	NT_STATUS_KEY_HAS_CHILDREN			0xC0000180
#define	NT_STATUS_CHILD_MUST_BE_VOLATILE		0xC0000181
#define	NT_STATUS_DEVICE_CONFIGURATION_ERROR		0xC0000182
#define	NT_STATUS_DRIVER_INTERNAL_ERROR			0xC0000183
#define	NT_STATUS_INVALID_DEVICE_STATE			0xC0000184
#define	NT_STATUS_IO_DEVICE_ERROR			0xC0000185
#define	NT_STATUS_DEVICE_PROTOCOL_ERROR			0xC0000186
#define	NT_STATUS_BACKUP_CONTROLLER			0xC0000187
#define	NT_STATUS_LOG_FILE_FULL				0xC0000188
#define	NT_STATUS_TOO_LATE				0xC0000189
#define	NT_STATUS_NO_TRUST_LSA_SECRET			0xC000018A
#define	NT_STATUS_NO_TRUST_SAM_ACCOUNT			0xC000018B
#define	NT_STATUS_TRUSTED_DOMAIN_FAILURE		0xC000018C
#define	NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE		0xC000018D
#define	NT_STATUS_EVENTLOG_FILE_CORRUPT			0xC000018E
#define	NT_STATUS_EVENTLOG_CANT_START			0xC000018F
#define	NT_STATUS_TRUST_FAILURE				0xC0000190
#define	NT_STATUS_MUTANT_LIMIT_EXCEEDED			0xC0000191
#define	NT_STATUS_NETLOGON_NOT_STARTED			0xC0000192
#define	NT_STATUS_ACCOUNT_EXPIRED			0xC0000193
#define	NT_STATUS_POSSIBLE_DEADLOCK			0xC0000194
#define	NT_STATUS_NETWORK_CREDENTIAL_CONFLICT		0xC0000195
#define	NT_STATUS_REMOTE_SESSION_LIMIT			0xC0000196
#define	NT_STATUS_EVENTLOG_FILE_CHANGED			0xC0000197
#define	NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT	0xC0000198
#define	NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT	0xC0000199
#define	NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT		0xC000019A
#define	NT_STATUS_DOMAIN_TRUST_INCONSISTENT		0xC000019B
#define	NT_STATUS_FS_DRIVER_REQUIRED			0xC000019C
#define	NT_STATUS_IMAGE_ALREADY_LOADED_AS_DLL		0xC000019D
/* Was: NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING */
#define	NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_SETTING	0xC000019E
#define	NT_STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME	0xC000019F
#define	NT_STATUS_SECURITY_STREAM_IS_INCONSISTENT	0xC00001A0
#define	NT_STATUS_INVALID_LOCK_RANGE			0xC00001A1
#define	NT_STATUS_INVALID_ACE_CONDITION			0xC00001A2
#define	NT_STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT		0xC00001A3
#define	NT_STATUS_NOTIFICATION_GUID_ALREADY_DEFINED	0xC00001A4
#define	NT_STATUS_NETWORK_OPEN_RESTRICTION		0xC0000201
#define	NT_STATUS_NO_USER_SESSION_KEY			0xC0000202
#define	NT_STATUS_USER_SESSION_DELETED			0xC0000203
#define	NT_STATUS_RESOURCE_LANG_NOT_FOUND		0xC0000204
#define	NT_STATUS_INSUFF_SERVER_RESOURCES		0xC0000205
#define	NT_STATUS_INVALID_BUFFER_SIZE			0xC0000206
#define	NT_STATUS_INVALID_ADDRESS_COMPONENT		0xC0000207
#define	NT_STATUS_INVALID_ADDRESS_WILDCARD		0xC0000208
#define	NT_STATUS_TOO_MANY_ADDRESSES			0xC0000209
#define	NT_STATUS_ADDRESS_ALREADY_EXISTS		0xC000020A
#define	NT_STATUS_ADDRESS_CLOSED			0xC000020B
#define	NT_STATUS_CONNECTION_DISCONNECTED		0xC000020C
#define	NT_STATUS_CONNECTION_RESET			0xC000020D
#define	NT_STATUS_TOO_MANY_NODES			0xC000020E
#define	NT_STATUS_TRANSACTION_ABORTED			0xC000020F
#define	NT_STATUS_TRANSACTION_TIMED_OUT			0xC0000210
#define	NT_STATUS_TRANSACTION_NO_RELEASE		0xC0000211
#define	NT_STATUS_TRANSACTION_NO_MATCH			0xC0000212
#define	NT_STATUS_TRANSACTION_RESPONDED			0xC0000213
#define	NT_STATUS_TRANSACTION_INVALID_ID		0xC0000214
#define	NT_STATUS_TRANSACTION_INVALID_TYPE		0xC0000215
#define	NT_STATUS_NOT_SERVER_SESSION			0xC0000216
#define	NT_STATUS_NOT_CLIENT_SESSION			0xC0000217
#define	NT_STATUS_CANNOT_LOAD_REGISTRY_FILE		0xC0000218
#define	NT_STATUS_DEBUG_ATTACH_FAILED			0xC0000219
#define	NT_STATUS_SYSTEM_PROCESS_TERMINATED		0xC000021A
#define	NT_STATUS_DATA_NOT_ACCEPTED			0xC000021B
#define	NT_STATUS_NO_BROWSER_SERVERS_FOUND		0xC000021C
#define	NT_STATUS_VDM_HARD_ERROR			0xC000021D
#define	NT_STATUS_DRIVER_CANCEL_TIMEOUT			0xC000021E
#define	NT_STATUS_REPLY_MESSAGE_MISMATCH		0xC000021F
#define	NT_STATUS_MAPPED_ALIGNMENT			0xC0000220
#define	NT_STATUS_IMAGE_CHECKSUM_MISMATCH		0xC0000221
#define	NT_STATUS_LOST_WRITEBEHIND_DATA			0xC0000222
#define	NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID	0xC0000223
#define	NT_STATUS_PASSWORD_MUST_CHANGE			0xC0000224
#define	NT_STATUS_NOT_FOUND				0xC0000225
#define	NT_STATUS_NOT_TINY_STREAM			0xC0000226
#define	NT_STATUS_RECOVERY_FAILURE			0xC0000227
#define	NT_STATUS_STACK_OVERFLOW_READ			0xC0000228
#define	NT_STATUS_FAIL_CHECK				0xC0000229
#define	NT_STATUS_DUPLICATE_OBJECTID			0xC000022A
#define	NT_STATUS_OBJECTID_EXISTS			0xC000022B
#define	NT_STATUS_CONVERT_TO_LARGE			0xC000022C
#define	NT_STATUS_RETRY					0xC000022D
#define	NT_STATUS_FOUND_OUT_OF_SCOPE			0xC000022E
#define	NT_STATUS_ALLOCATE_BUCKET			0xC000022F
#define	NT_STATUS_PROPSET_NOT_FOUND			0xC0000230
#define	NT_STATUS_MARSHALL_OVERFLOW			0xC0000231
#define	NT_STATUS_INVALID_VARIANT			0xC0000232
#define	NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND		0xC0000233
#define	NT_STATUS_ACCOUNT_LOCKED_OUT			0xC0000234
#define	NT_STATUS_HANDLE_NOT_CLOSABLE			0xC0000235
#define	NT_STATUS_CONNECTION_REFUSED			0xC0000236
#define	NT_STATUS_GRACEFUL_DISCONNECT			0xC0000237
#define	NT_STATUS_ADDRESS_ALREADY_ASSOCIATED		0xC0000238
#define	NT_STATUS_ADDRESS_NOT_ASSOCIATED		0xC0000239
#define	NT_STATUS_CONNECTION_INVALID			0xC000023A
#define	NT_STATUS_CONNECTION_ACTIVE			0xC000023B
#define	NT_STATUS_NETWORK_UNREACHABLE			0xC000023C
#define	NT_STATUS_HOST_UNREACHABLE			0xC000023D
#define	NT_STATUS_PROTOCOL_UNREACHABLE			0xC000023E
#define	NT_STATUS_PORT_UNREACHABLE			0xC000023F
#define	NT_STATUS_REQUEST_ABORTED			0xC0000240
#define	NT_STATUS_CONNECTION_ABORTED			0xC0000241
#define	NT_STATUS_BAD_COMPRESSION_BUFFER		0xC0000242
#define	NT_STATUS_USER_MAPPED_FILE			0xC0000243
#define	NT_STATUS_AUDIT_FAILED				0xC0000244
#define	NT_STATUS_TIMER_RESOLUTION_NOT_SET		0xC0000245
#define	NT_STATUS_CONNECTION_COUNT_LIMIT		0xC0000246
#define	NT_STATUS_LOGIN_TIME_RESTRICTION		0xC0000247
#define	NT_STATUS_LOGIN_WKSTA_RESTRICTION		0xC0000248
#define	NT_STATUS_IMAGE_MP_UP_MISMATCH			0xC0000249
#define	NT_STATUS_INSUFFICIENT_LOGON_INFO		0xC0000250
#define	NT_STATUS_BAD_DLL_ENTRYPOINT			0xC0000251
#define	NT_STATUS_BAD_SERVICE_ENTRYPOINT		0xC0000252
#define	NT_STATUS_LPC_REPLY_LOST			0xC0000253
#define	NT_STATUS_IP_ADDRESS_CONFLICT1			0xC0000254
#define	NT_STATUS_IP_ADDRESS_CONFLICT2			0xC0000255
#define	NT_STATUS_REGISTRY_QUOTA_LIMIT			0xC0000256
#define	NT_STATUS_PATH_NOT_COVERED			0xC0000257
#define	NT_STATUS_NO_CALLBACK_ACTIVE			0xC0000258
#define	NT_STATUS_LICENSE_QUOTA_EXCEEDED		0xC0000259
#define	NT_STATUS_PWD_TOO_SHORT				0xC000025A
#define	NT_STATUS_PWD_TOO_RECENT			0xC000025B
#define	NT_STATUS_PWD_HISTORY_CONFLICT			0xC000025C
#define	NT_STATUS_PLUGPLAY_NO_DEVICE			0xC000025E
#define	NT_STATUS_UNSUPPORTED_COMPRESSION		0xC000025F
#define	NT_STATUS_INVALID_HW_PROFILE			0xC0000260
#define	NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH		0xC0000261
#define	NT_STATUS_DRIVER_ORDINAL_NOT_FOUND		0xC0000262
#define	NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND		0xC0000263
#define	NT_STATUS_RESOURCE_NOT_OWNED			0xC0000264
#define	NT_STATUS_TOO_MANY_LINKS			0xC0000265
#define	NT_STATUS_QUOTA_LIST_INCONSISTENT		0xC0000266
#define	NT_STATUS_FILE_IS_OFFLINE			0xC0000267
#define	NT_STATUS_EVALUATION_EXPIRATION			0xC0000268
#define	NT_STATUS_ILLEGAL_DLL_RELOCATION		0xC0000269
#define	NT_STATUS_LICENSE_VIOLATION			0xC000026A
#define	NT_STATUS_DLL_INIT_FAILED_LOGOFF		0xC000026B
#define	NT_STATUS_DRIVER_UNABLE_TO_LOAD			0xC000026C
#define	NT_STATUS_DFS_UNAVAILABLE			0xC000026D
#define	NT_STATUS_VOLUME_DISMOUNTED			0xC000026E
#define	NT_STATUS_WX86_INTERNAL_ERROR			0xC000026F
#define	NT_STATUS_WX86_FLOAT_STACK_CHECK		0xC0000270
#define	NT_STATUS_VALIDATE_CONTINUE			0xC0000271
#define	NT_STATUS_NO_MATCH				0xC0000272
#define	NT_STATUS_NO_MORE_MATCHES			0xC0000273
#define	NT_STATUS_NOT_A_REPARSE_POINT			0xC0000275
#define	NT_STATUS_IO_REPARSE_TAG_INVALID		0xC0000276
#define	NT_STATUS_IO_REPARSE_TAG_MISMATCH		0xC0000277
#define	NT_STATUS_IO_REPARSE_DATA_INVALID		0xC0000278
#define	NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED		0xC0000279
#define	NT_STATUS_REPARSE_POINT_NOT_RESOLVED		0xC0000280
#define	NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT		0xC0000281
#define	NT_STATUS_RANGE_LIST_CONFLICT			0xC0000282
#define	NT_STATUS_SOURCE_ELEMENT_EMPTY			0xC0000283
#define	NT_STATUS_DESTINATION_ELEMENT_FULL		0xC0000284
#define	NT_STATUS_ILLEGAL_ELEMENT_ADDRESS		0xC0000285
#define	NT_STATUS_MAGAZINE_NOT_PRESENT			0xC0000286
#define	NT_STATUS_REINITIALIZATION_NEEDED		0xC0000287
/*	NT_STATUS_DEVICE_REQUIRES_CLEANING		0x80000288 */
/*	NT_STATUS_DEVICE_DOOR_OPEN			0x80000289 */
#define	NT_STATUS_ENCRYPTION_FAILED			0xC000028A
#define	NT_STATUS_DECRYPTION_FAILED			0xC000028B
#define	NT_STATUS_RANGE_NOT_FOUND			0xC000028C
#define	NT_STATUS_NO_RECOVERY_POLICY			0xC000028D
#define	NT_STATUS_NO_EFS				0xC000028E
#define	NT_STATUS_WRONG_EFS				0xC000028F
#define	NT_STATUS_NO_USER_KEYS				0xC0000290
#define	NT_STATUS_FILE_NOT_ENCRYPTED			0xC0000291
#define	NT_STATUS_NOT_EXPORT_FORMAT			0xC0000292
#define	NT_STATUS_FILE_ENCRYPTED			0xC0000293
/*	NT_STATUS_WAKE_SYSTEM				0x40000294 */
#define	NT_STATUS_WMI_GUID_NOT_FOUND			0xC0000295
#define	NT_STATUS_WMI_INSTANCE_NOT_FOUND		0xC0000296
#define	NT_STATUS_WMI_ITEMID_NOT_FOUND			0xC0000297
#define	NT_STATUS_WMI_TRY_AGAIN				0xC0000298
#define	NT_STATUS_SHARED_POLICY				0xC0000299
#define	NT_STATUS_POLICY_OBJECT_NOT_FOUND		0xC000029A
#define	NT_STATUS_POLICY_ONLY_IN_DS			0xC000029B
#define	NT_STATUS_VOLUME_NOT_UPGRADED			0xC000029C
#define	NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE		0xC000029D
#define	NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR		0xC000029E
#define	NT_STATUS_NO_TRACKING_SERVICE			0xC000029F
#define	NT_STATUS_SERVER_SID_MISMATCH			0xC00002A0
#define	NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE		0xC00002A1
#define	NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX		0xC00002A2
#define	NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED		0xC00002A3
#define	NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS		0xC00002A4
#define	NT_STATUS_DS_BUSY				0xC00002A5
#define	NT_STATUS_DS_UNAVAILABLE			0xC00002A6
#define	NT_STATUS_DS_NO_RIDS_ALLOCATED			0xC00002A7
#define	NT_STATUS_DS_NO_MORE_RIDS			0xC00002A8
#define	NT_STATUS_DS_INCORRECT_ROLE_OWNER		0xC00002A9
#define	NT_STATUS_DS_RIDMGR_INIT_ERROR			0xC00002AA
#define	NT_STATUS_DS_OBJ_CLASS_VIOLATION		0xC00002AB
#define	NT_STATUS_DS_CANT_ON_NON_LEAF			0xC00002AC
#define	NT_STATUS_DS_CANT_ON_RDN			0xC00002AD
#define	NT_STATUS_DS_CANT_MOD_OBJ_CLASS			0xC00002AE
#define	NT_STATUS_DS_CROSS_DOM_MOVE_FAILED		0xC00002AF
#define	NT_STATUS_DS_GC_NOT_AVAILABLE			0xC00002B0
#define	NT_STATUS_DIRECTORY_SERVICE_REQUIRED		0xC00002B1
#define	NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT		0xC00002B2
#define	NT_STATUS_CANT_ENABLE_DENY_ONLY			0xC00002B3
#define	NT_STATUS_FLOAT_MULTIPLE_FAULTS			0xC00002B4
#define	NT_STATUS_FLOAT_MULTIPLE_TRAPS			0xC00002B5
#define	NT_STATUS_DEVICE_REMOVED			0xC00002B6
#define	NT_STATUS_JOURNAL_DELETE_IN_PROGRESS		0xC00002B7
#define	NT_STATUS_JOURNAL_NOT_ACTIVE			0xC00002B8
#define	NT_STATUS_NOINTERFACE				0xC00002B9
#define	NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED		0xC00002C1
#define	NT_STATUS_DRIVER_FAILED_SLEEP			0xC00002C2
#define	NT_STATUS_MUTUAL_AUTHENTICATION_FAILED		0xC00002C3
#define	NT_STATUS_CORRUPT_SYSTEM_FILE			0xC00002C4
#define	NT_STATUS_DATATYPE_MISALIGNMENT_ERROR		0xC00002C5
#define	NT_STATUS_WMI_READ_ONLY				0xC00002C6
#define	NT_STATUS_WMI_SET_FAILURE			0xC00002C7
#define	NT_STATUS_COMMITMENT_MINIMUM			0xC00002C8
#define	NT_STATUS_REG_NAT_CONSUMPTION			0xC00002C9
#define	NT_STATUS_TRANSPORT_FULL			0xC00002CA
#define	NT_STATUS_DS_SAM_INIT_FAILURE			0xC00002CB
#define	NT_STATUS_ONLY_IF_CONNECTED			0xC00002CC
#define	NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION		0xC00002CD
#define	NT_STATUS_PNP_RESTART_ENUMERATION		0xC00002CE
#define	NT_STATUS_JOURNAL_ENTRY_DELETED			0xC00002CF
#define	NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID		0xC00002D0
#define	NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE		0xC00002D1
#define	NT_STATUS_PNP_REBOOT_REQUIRED			0xC00002D2
#define	NT_STATUS_POWER_STATE_INVALID			0xC00002D3
#define	NT_STATUS_DS_INVALID_GROUP_TYPE			0xC00002D4
#define	NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN	0xC00002D5
#define	NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN	0xC00002D6
#define	NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER	0xC00002D7
#define	NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER	0xC00002D8
#define	NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER	0xC00002D9
#define	NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER 0xC00002DA
#define	NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER 0xC00002DB
#define	NT_STATUS_DS_HAVE_PRIMARY_MEMBERS		0xC00002DC
#define	NT_STATUS_WMI_NOT_SUPPORTED			0xC00002DD
#define	NT_STATUS_INSUFFICIENT_POWER			0xC00002DE
#define	NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD		0xC00002DF
#define	NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY		0xC00002E0
#define	NT_STATUS_DS_CANT_START				0xC00002E1
#define	NT_STATUS_DS_INIT_FAILURE			0xC00002E2
#define	NT_STATUS_SAM_INIT_FAILURE			0xC00002E3
#define	NT_STATUS_DS_GC_REQUIRED			0xC00002E4
#define	NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY		0xC00002E5
#define	NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS		0xC00002E6
#define	NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED	0xC00002E7
#define	NT_STATUS_MULTIPLE_FAULT_VIOLATION		0xC00002E8
#define	NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED		0xC00002E9
#define	NT_STATUS_CANNOT_MAKE				0xC00002EA
#define	NT_STATUS_SYSTEM_SHUTDOWN			0xC00002EB
#define	NT_STATUS_DS_INIT_FAILURE_CONSOLE		0xC00002EC
#define	NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE		0xC00002ED
#define	NT_STATUS_UNFINISHED_CONTEXT_DELETED		0xC00002EE
#define	NT_STATUS_NO_TGT_REPLY				0xC00002EF
#define	NT_STATUS_OBJECTID_NOT_FOUND			0xC00002F0
#define	NT_STATUS_NO_IP_ADDRESSES			0xC00002F1
#define	NT_STATUS_WRONG_CREDENTIAL_HANDLE		0xC00002F2
#define	NT_STATUS_CRYPTO_SYSTEM_INVALID			0xC00002F3
#define	NT_STATUS_MAX_REFERRALS_EXCEEDED		0xC00002F4
#define	NT_STATUS_MUST_BE_KDC				0xC00002F5
#define	NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED		0xC00002F6
#define	NT_STATUS_TOO_MANY_PRINCIPALS			0xC00002F7
#define	NT_STATUS_NO_PA_DATA				0xC00002F8
#define	NT_STATUS_PKINIT_NAME_MISMATCH			0xC00002F9
#define	NT_STATUS_SMARTCARD_LOGON_REQUIRED		0xC00002FA
#define	NT_STATUS_KDC_INVALID_REQUEST			0xC00002FB
#define	NT_STATUS_KDC_UNABLE_TO_REFER			0xC00002FC
#define	NT_STATUS_KDC_UNKNOWN_ETYPE			0xC00002FD
#define	NT_STATUS_SHUTDOWN_IN_PROGRESS			0xC00002FE
#define	NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS		0xC00002FF
#define	NT_STATUS_NOT_SUPPORTED_ON_SBS			0xC0000300
#define	NT_STATUS_WMI_GUID_DISCONNECTED			0xC0000301
#define	NT_STATUS_WMI_ALREADY_DISABLED			0xC0000302
#define	NT_STATUS_WMI_ALREADY_ENABLED			0xC0000303
#define	NT_STATUS_MFT_TOO_FRAGMENTED			0xC0000304
#define	NT_STATUS_COPY_PROTECTION_FAILURE		0xC0000305
#define	NT_STATUS_CSS_AUTHENTICATION_FAILURE		0xC0000306
#define	NT_STATUS_CSS_KEY_NOT_PRESENT			0xC0000307
#define	NT_STATUS_CSS_KEY_NOT_ESTABLISHED		0xC0000308
#define	NT_STATUS_CSS_SCRAMBLED_SECTOR			0xC0000309
#define	NT_STATUS_CSS_REGION_MISMATCH			0xC000030A
#define	NT_STATUS_CSS_RESETS_EXHAUSTED			0xC000030B
#define	NT_STATUS_PKINIT_FAILURE			0xC0000320
#define	NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE		0xC0000321
#define	NT_STATUS_NO_KERB_KEY				0xC0000322
#define	NT_STATUS_HOST_DOWN				0xC0000350
#define	NT_STATUS_UNSUPPORTED_PREAUTH			0xC0000351
#define	NT_STATUS_EFS_ALG_BLOB_TOO_BIG			0xC0000352
#define	NT_STATUS_PORT_NOT_SET				0xC0000353
#define	NT_STATUS_DEBUGGER_INACTIVE			0xC0000354
#define	NT_STATUS_DS_VERSION_CHECK_FAILURE		0xC0000355
#define	NT_STATUS_AUDITING_DISABLED			0xC0000356
#define	NT_STATUS_PRENT4_MACHINE_ACCOUNT		0xC0000357
#define	NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER	0xC0000358
#define	NT_STATUS_INVALID_IMAGE_WIN_32			0xC0000359
#define	NT_STATUS_INVALID_IMAGE_WIN_64			0xC000035A
#define	NT_STATUS_BAD_BINDINGS				0xC000035B
#define	NT_STATUS_NETWORK_SESSION_EXPIRED		0xC000035C
#define	NT_STATUS_APPHELP_BLOCK				0xC000035D
#define	NT_STATUS_ALL_SIDS_FILTERED			0xC000035E
#define	NT_STATUS_NOT_SAFE_MODE_DRIVER			0xC000035F
#define	NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT	0xC0000361
#define	NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH	0xC0000362
#define	NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER	0xC0000363
#define	NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER	0xC0000364
#define	NT_STATUS_FAILED_DRIVER_ENTRY			0xC0000365
#define	NT_STATUS_DEVICE_ENUMERATION_ERROR		0xC0000366
/*	NT_STATUS_WAIT_FOR_OPLOCK			0x00000367 */
#define	NT_STATUS_MOUNT_POINT_NOT_RESOLVED		0xC0000368
#define	NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER	0xC0000369
#define	NT_STATUS_MCA_OCCURED				0xC000036A
#define	NT_STATUS_DRIVER_BLOCKED_CRITICAL		0xC000036B
#define	NT_STATUS_DRIVER_BLOCKED			0xC000036C
#define	NT_STATUS_DRIVER_DATABASE_ERROR			0xC000036D
#define	NT_STATUS_SYSTEM_HIVE_TOO_LARGE			0xC000036E
#define	NT_STATUS_INVALID_IMPORT_OF_NON_DLL		0xC000036F
/*	NT_STATUS_DS_SHUTTING_DOWN			0x40000370 */
#define	NT_STATUS_NO_SECRETS				0xC0000371
#define	NT_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY	0xC0000372
#define	NT_STATUS_FAILED_STACK_SWITCH			0xC0000373
#define	NT_STATUS_HEAP_CORRUPTION			0xC0000374
#define	NT_STATUS_SMARTCARD_WRONG_PIN			0xC0000380
#define	NT_STATUS_SMARTCARD_CARD_BLOCKED		0xC0000381
#define	NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED	0xC0000382
#define	NT_STATUS_SMARTCARD_NO_CARD			0xC0000383
#define	NT_STATUS_SMARTCARD_NO_KEY_CONTAINER		0xC0000384
#define	NT_STATUS_SMARTCARD_NO_CERTIFICATE		0xC0000385
#define	NT_STATUS_SMARTCARD_NO_KEYSET			0xC0000386
#define	NT_STATUS_SMARTCARD_IO_ERROR			0xC0000387
#define	NT_STATUS_DOWNGRADE_DETECTED			0xC0000388
#define	NT_STATUS_SMARTCARD_CERT_REVOKED		0xC0000389
#define	NT_STATUS_ISSUING_CA_UNTRUSTED			0xC000038A
#define	NT_STATUS_REVOCATION_OFFLINE_C			0xC000038B
#define	NT_STATUS_PKINIT_CLIENT_FAILURE			0xC000038C
#define	NT_STATUS_SMARTCARD_CERT_EXPIRED		0xC000038D
#define	NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD		0xC000038E
#define	NT_STATUS_SMARTCARD_SILENT_CONTEXT		0xC000038F
#define	NT_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED		0xC0000401
#define	NT_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED		0xC0000402
#define	NT_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED	0xC0000403
#define	NT_STATUS_DS_NAME_NOT_UNIQUE			0xC0000404
#define	NT_STATUS_DS_DUPLICATE_ID_FOUND			0xC0000405
#define	NT_STATUS_DS_GROUP_CONVERSION_ERROR		0xC0000406
#define	NT_STATUS_VOLSNAP_PREPARE_HIBERNATE		0xC0000407
#define	NT_STATUS_USER2USER_REQUIRED			0xC0000408
#define	NT_STATUS_STACK_BUFFER_OVERRUN			0xC0000409
#define	NT_STATUS_NO_S4U_PROT_SUPPORT			0xC000040A
#define	NT_STATUS_CROSSREALM_DELEGATION_FAILURE		0xC000040B
#define	NT_STATUS_REVOCATION_OFFLINE_KDC		0xC000040C
#define	NT_STATUS_ISSUING_CA_UNTRUSTED_KDC		0xC000040D
#define	NT_STATUS_KDC_CERT_EXPIRED			0xC000040E
#define	NT_STATUS_KDC_CERT_REVOKED			0xC000040F
#define	NT_STATUS_PARAMETER_QUOTA_EXCEEDED		0xC0000410
#define	NT_STATUS_HIBERNATION_FAILURE			0xC0000411
#define	NT_STATUS_DELAY_LOAD_FAILED			0xC0000412
#define	NT_STATUS_AUTHENTICATION_FIREWALL_FAILED	0xC0000413
#define	NT_STATUS_VDM_DISALLOWED			0xC0000414
#define	NT_STATUS_HUNG_DISPLAY_DRIVER_THREAD		0xC0000415
/* Was: NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE */
#define	NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SHARED_SECTION_SIZE 0xC0000416
#define	NT_STATUS_INVALID_CRUNTIME_PARAMETER		0xC0000417
#define	NT_STATUS_NTLM_BLOCKED				0xC0000418
#define	NT_STATUS_DS_SRC_SID_EXISTS_IN_FOREST		0xC0000419
#define	NT_STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST	0xC000041A
#define	NT_STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST		0xC000041B
#define	NT_STATUS_INVALID_USER_PRINCIPAL_NAME		0xC000041C
#define	NT_STATUS_ASSERTION_FAILURE			0xC0000420
#define	NT_STATUS_VERIFIER_STOP				0xC0000421
#define	NT_STATUS_CALLBACK_POP_STACK			0xC0000423
#define	NT_STATUS_INCOMPATIBLE_DRIVER_BLOCKED		0xC0000424
#define	NT_STATUS_HIVE_UNLOADED				0xC0000425
#define	NT_STATUS_COMPRESSION_DISABLED			0xC0000426
#define	NT_STATUS_FILE_SYSTEM_LIMITATION		0xC0000427
#define	NT_STATUS_INVALID_IMAGE_HASH			0xC0000428
#define	NT_STATUS_NOT_CAPABLE				0xC0000429
#define	NT_STATUS_REQUEST_OUT_OF_SEQUENCE		0xC000042A
#define	NT_STATUS_IMPLEMENTATION_LIMIT			0xC000042B
#define	NT_STATUS_ELEVATION_REQUIRED			0xC000042C
#define	NT_STATUS_NO_SECURITY_CONTEXT			0xC000042D
#define	NT_STATUS_PKU2U_CERT_FAILURE			0xC000042E
#define	NT_STATUS_BEYOND_VDL				0xC0000432
#define	NT_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS		0xC0000433
#define	NT_STATUS_PTE_CHANGED				0xC0000434
#define	NT_STATUS_PURGE_FAILED				0xC0000435
#define	NT_STATUS_CRED_REQUIRES_CONFIRMATION		0xC0000440
#define	NT_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE	0xC0000441
#define	NT_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER	0xC0000442
#define	NT_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE	0xC0000443
#define	NT_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE	0xC0000444
#define	NT_STATUS_CS_ENCRYPTION_FILE_NOT_CSE		0xC0000445
#define	NT_STATUS_INVALID_LABEL				0xC0000446
#define	NT_STATUS_DRIVER_PROCESS_TERMINATED		0xC0000450
#define	NT_STATUS_AMBIGUOUS_SYSTEM_DEVICE		0xC0000451
#define	NT_STATUS_SYSTEM_DEVICE_NOT_FOUND		0xC0000452
#define	NT_STATUS_RESTART_BOOT_APPLICATION		0xC0000453
#define	NT_STATUS_INSUFFICIENT_NVRAM_RESOURCES		0xC0000454
#define	NT_STATUS_NO_RANGES_PROCESSED			0xC0000460
#define	NT_STATUS_DEVICE_FEATURE_NOT_SUPPORTED		0xC0000463
#define	NT_STATUS_DEVICE_UNREACHABLE			0xC0000464
#define	NT_STATUS_INVALID_TOKEN				0xC0000465
#define	NT_STATUS_SERVER_UNAVAILABLE			0xC0000466
#define	NT_STATUS_FILE_NOT_AVAILABLE			0xC0000467

#define	NT_STATUS_INVALID_TASK_NAME			0xC0000500
#define	NT_STATUS_INVALID_TASK_INDEX			0xC0000501
#define	NT_STATUS_THREAD_ALREADY_IN_TASK		0xC0000502
#define	NT_STATUS_CALLBACK_BYPASS			0xC0000503
#define	NT_STATUS_FAIL_FAST_EXCEPTION			0xC0000602
#define	NT_STATUS_IMAGE_CERT_REVOKED			0xC0000603
#define	NT_STATUS_PORT_CLOSED				0xC0000700
#define	NT_STATUS_MESSAGE_LOST				0xC0000701
#define	NT_STATUS_INVALID_MESSAGE			0xC0000702
#define	NT_STATUS_REQUEST_CANCELED			0xC0000703
#define	NT_STATUS_RECURSIVE_DISPATCH			0xC0000704
#define	NT_STATUS_LPC_RECEIVE_BUFFER_EXPECTED		0xC0000705
#define	NT_STATUS_LPC_INVALID_CONNECTION_USAGE		0xC0000706
#define	NT_STATUS_LPC_REQUESTS_NOT_ALLOWED		0xC0000707
#define	NT_STATUS_RESOURCE_IN_USE			0xC0000708
#define	NT_STATUS_HARDWARE_MEMORY_ERROR			0xC0000709
#define	NT_STATUS_THREADPOOL_HANDLE_EXCEPTION		0xC000070A
#define	NT_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED	0xC000070B
#define	NT_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED 0xC000070C
#define	NT_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED 0xC000070D
#define	NT_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED  0xC000070E
#define	NT_STATUS_THREADPOOL_RELEASED_DURING_OPERATION	0xC000070F
#define	NT_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING	0xC0000710
#define	NT_STATUS_APC_RETURNED_WHILE_IMPERSONATING	0xC0000711
#define	NT_STATUS_PROCESS_IS_PROTECTED			0xC0000712
#define	NT_STATUS_MCA_EXCEPTION				0xC0000713
#define	NT_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE	0xC0000714
#define	NT_STATUS_SYMLINK_CLASS_DISABLED		0xC0000715
#define	NT_STATUS_INVALID_IDN_NORMALIZATION		0xC0000716
#define	NT_STATUS_NO_UNICODE_TRANSLATION		0xC0000717
#define	NT_STATUS_ALREADY_REGISTERED			0xC0000718
#define	NT_STATUS_CONTEXT_MISMATCH			0xC0000719
#define	NT_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST	0xC000071A
#define	NT_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY	0xC000071B
#define	NT_STATUS_INVALID_THREAD			0xC000071C
#define	NT_STATUS_CALLBACK_RETURNED_TRANSACTION		0xC000071D
#define	NT_STATUS_CALLBACK_RETURNED_LDR_LOCK		0xC000071E
#define	NT_STATUS_CALLBACK_RETURNED_LANG		0xC000071F
#define	NT_STATUS_CALLBACK_RETURNED_PRI_BACK		0xC0000720
#define	NT_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY	0xC0000721
#define	NT_STATUS_DISK_REPAIR_DISABLED			0xC0000800
#define	NT_STATUS_DS_DOMAIN_RENAME_IN_PROGRESS		0xC0000801
#define	NT_STATUS_DISK_QUOTA_EXCEEDED			0xC0000802
#define	NT_STATUS_CONTENT_BLOCKED			0xC0000804
#define	NT_STATUS_BAD_CLUSTERS				0xC0000805
#define	NT_STATUS_VOLUME_DIRTY				0xC0000806
#define	NT_STATUS_FILE_CHECKED_OUT			0xC0000901
#define	NT_STATUS_CHECKOUT_REQUIRED			0xC0000902
#define	NT_STATUS_BAD_FILE_TYPE				0xC0000903
#define	NT_STATUS_FILE_TOO_LARGE			0xC0000904
#define	NT_STATUS_FORMS_AUTH_REQUIRED			0xC0000905
#define	NT_STATUS_VIRUS_INFECTED			0xC0000906
#define	NT_STATUS_VIRUS_DELETED				0xC0000907
#define	NT_STATUS_BAD_MCFG_TABLE			0xC0000908
#define	NT_STATUS_CANNOT_BREAK_OPLOCK			0xC0000909

#define	NT_STATUS_WOW_ASSERTION				0xC0009898

#define	NT_STATUS_INVALID_SIGNATURE			0xC000A000
#define	NT_STATUS_HMAC_NOT_SUPPORTED			0xC000A001
#define	NT_STATUS_IPSEC_QUEUE_OVERFLOW			0xC000A010
#define	NT_STATUS_ND_QUEUE_OVERFLOW			0xC000A011
#define	NT_STATUS_HOPLIMIT_EXCEEDED			0xC000A012
#define	NT_STATUS_PROTOCOL_NOT_SUPPORTED		0xC000A013
#define	NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED	0xC000A080
#define	NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR	0xC000A081
#define	NT_STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR	0xC000A082
#define	NT_STATUS_XML_PARSE_ERROR			0xC000A083
#define	NT_STATUS_XMLDSIG_ERROR				0xC000A084
#define	NT_STATUS_WRONG_COMPARTMENT			0xC000A085
#define	NT_STATUS_AUTHIP_FAILURE			0xC000A086
#define	NT_STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS	0xC000A087
#define	NT_STATUS_DS_OID_NOT_FOUND			0xC000A088
#define	NT_STATUS_HASH_NOT_SUPPORTED			0xC000A100
#define	NT_STATUS_HASH_NOT_PRESENT			0xC000A101
#define	NT_STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED	0xC000A2A1
#define	NT_STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED	0xC000A2A2
#define	NT_STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED	0xC000A2A3
#define	NT_STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED	0xC000A2A4

/* Facility Debugger (0x..01....) not used */

/* Facility RPC Runtime (0x..02....) */
#define	RPC_NT_INVALID_STRING_BINDING			0xC0020001
#define	RPC_NT_WRONG_KIND_OF_BINDING			0xC0020002
#define	RPC_NT_INVALID_BINDING				0xC0020003
#define	RPC_NT_PROTSEQ_NOT_SUPPORTED			0xC0020004
#define	RPC_NT_INVALID_RPC_PROTSEQ			0xC0020005
#define	RPC_NT_INVALID_STRING_UUID			0xC0020006
#define	RPC_NT_INVALID_ENDPOINT_FORMAT			0xC0020007
#define	RPC_NT_INVALID_NET_ADDR				0xC0020008
#define	RPC_NT_NO_ENDPOINT_FOUND			0xC0020009
#define	RPC_NT_INVALID_TIMEOUT				0xC002000A
#define	RPC_NT_OBJECT_NOT_FOUND				0xC002000B
#define	RPC_NT_ALREADY_REGISTERED			0xC002000C
#define	RPC_NT_TYPE_ALREADY_REGISTERED			0xC002000D
#define	RPC_NT_ALREADY_LISTENING			0xC002000E
#define	RPC_NT_NO_PROTSEQS_REGISTERED			0xC002000F
#define	RPC_NT_NOT_LISTENING				0xC0020010
#define	RPC_NT_UNKNOWN_MGR_TYPE				0xC0020011
#define	RPC_NT_UNKNOWN_IF				0xC0020012
#define	RPC_NT_NO_BINDINGS				0xC0020013
#define	RPC_NT_NO_PROTSEQS				0xC0020014
#define	RPC_NT_CANT_CREATE_ENDPOINT			0xC0020015
#define	RPC_NT_OUT_OF_RESOURCES				0xC0020016
#define	RPC_NT_SERVER_UNAVAILABLE			0xC0020017
#define	RPC_NT_SERVER_TOO_BUSY				0xC0020018
#define	RPC_NT_INVALID_NETWORK_OPTIONS			0xC0020019
#define	RPC_NT_NO_CALL_ACTIVE				0xC002001A
#define	RPC_NT_CALL_FAILED				0xC002001B
#define	RPC_NT_CALL_FAILED_DNE				0xC002001C
#define	RPC_NT_PROTOCOL_ERROR				0xC002001D
#define	RPC_NT_UNSUPPORTED_TRANS_SYN			0xC002001F
#define	RPC_NT_UNSUPPORTED_TYPE				0xC0020021
#define	RPC_NT_INVALID_TAG				0xC0020022
#define	RPC_NT_INVALID_BOUND				0xC0020023
#define	RPC_NT_NO_ENTRY_NAME				0xC0020024
#define	RPC_NT_INVALID_NAME_SYNTAX			0xC0020025
#define	RPC_NT_UNSUPPORTED_NAME_SYNTAX			0xC0020026
#define	RPC_NT_UUID_NO_ADDRESS				0xC0020028
#define	RPC_NT_DUPLICATE_ENDPOINT			0xC0020029
#define	RPC_NT_UNKNOWN_AUTHN_TYPE			0xC002002A
#define	RPC_NT_MAX_CALLS_TOO_SMALL			0xC002002B
#define	RPC_NT_STRING_TOO_LONG				0xC002002C
#define	RPC_NT_PROTSEQ_NOT_FOUND			0xC002002D
#define	RPC_NT_PROCNUM_OUT_OF_RANGE			0xC002002E
#define	RPC_NT_BINDING_HAS_NO_AUTH			0xC002002F
#define	RPC_NT_UNKNOWN_AUTHN_SERVICE			0xC0020030
#define	RPC_NT_UNKNOWN_AUTHN_LEVEL			0xC0020031
#define	RPC_NT_INVALID_AUTH_IDENTITY			0xC0020032
#define	RPC_NT_UNKNOWN_AUTHZ_SERVICE			0xC0020033
#define	EPT_NT_INVALID_ENTRY				0xC0020034
#define	EPT_NT_CANT_PERFORM_OP				0xC0020035
#define	EPT_NT_NOT_REGISTERED				0xC0020036
#define	RPC_NT_NOTHING_TO_EXPORT			0xC0020037
#define	RPC_NT_INCOMPLETE_NAME				0xC0020038
#define	RPC_NT_INVALID_VERS_OPTION			0xC0020039
#define	RPC_NT_NO_MORE_MEMBERS				0xC002003A
#define	RPC_NT_NOT_ALL_OBJS_UNEXPORTED			0xC002003B
#define	RPC_NT_INTERFACE_NOT_FOUND			0xC002003C
#define	RPC_NT_ENTRY_ALREADY_EXISTS			0xC002003D
#define	RPC_NT_ENTRY_NOT_FOUND				0xC002003E
#define	RPC_NT_NAME_SERVICE_UNAVAILABLE			0xC002003F
#define	RPC_NT_INVALID_NAF_ID				0xC0020040
#define	RPC_NT_CANNOT_SUPPORT				0xC0020041
#define	RPC_NT_NO_CONTEXT_AVAILABLE			0xC0020042
#define	RPC_NT_INTERNAL_ERROR				0xC0020043
#define	RPC_NT_ZERO_DIVIDE				0xC0020044
#define	RPC_NT_ADDRESS_ERROR				0xC0020045
#define	RPC_NT_FP_DIV_ZERO				0xC0020046
#define	RPC_NT_FP_UNDERFLOW				0xC0020047
#define	RPC_NT_FP_OVERFLOW				0xC0020048
#define	RPC_NT_CALL_IN_PROGRESS				0xC0020049
#define	RPC_NT_NO_MORE_BINDINGS				0xC002004A
#define	RPC_NT_GROUP_MEMBER_NOT_FOUND			0xC002004B
#define	EPT_NT_CANT_CREATE				0xC002004C
#define	RPC_NT_INVALID_OBJECT				0xC002004D
#define	RPC_NT_NO_INTERFACES				0xC002004F
#define	RPC_NT_CALL_CANCELLED				0xC0020050
#define	RPC_NT_BINDING_INCOMPLETE			0xC0020051
#define	RPC_NT_COMM_FAILURE				0xC0020052
#define	RPC_NT_UNSUPPORTED_AUTHN_LEVEL			0xC0020053
#define	RPC_NT_NO_PRINC_NAME				0xC0020054
#define	RPC_NT_NOT_RPC_ERROR				0xC0020055
/*	RPC_NT_UUID_LOCAL_ONLY				0x40020056 */
#define	RPC_NT_SEC_PKG_ERROR				0xC0020057
#define	RPC_NT_NOT_CANCELLED				0xC0020058
#define	RPC_NT_INVALID_ASYNC_HANDLE			0xC0020062
#define	RPC_NT_INVALID_ASYNC_CALL			0xC0020063
#define	RPC_NT_PROXY_ACCESS_DENIED			0xC0020064
/*	RPC_NT_SEND_INCOMPLETE				0x400200AF */

/* Facility RPC Stubs (0x..03....) */
#define	RPC_NT_NO_MORE_ENTRIES				0xC0030001
#define	RPC_NT_SS_CHAR_TRANS_OPEN_FAIL			0xC0030002
#define	RPC_NT_SS_CHAR_TRANS_SHORT_FILE			0xC0030003
#define	RPC_NT_SS_IN_NULL_CONTEXT			0xC0030004
#define	RPC_NT_SS_CONTEXT_MISMATCH			0xC0030005
#define	RPC_NT_SS_CONTEXT_DAMAGED			0xC0030006
#define	RPC_NT_SS_HANDLES_MISMATCH			0xC0030007
#define	RPC_NT_SS_CANNOT_GET_CALL_HANDLE		0xC0030008
#define	RPC_NT_NULL_REF_POINTER				0xC0030009
#define	RPC_NT_ENUM_VALUE_OUT_OF_RANGE			0xC003000A
#define	RPC_NT_BYTE_COUNT_TOO_SMALL			0xC003000B
#define	RPC_NT_BAD_STUB_DATA				0xC003000C
#define	RPC_NT_INVALID_ES_ACTION			0xC0030059
#define	RPC_NT_WRONG_ES_VERSION				0xC003005A
#define	RPC_NT_WRONG_STUB_VERSION			0xC003005B
#define	RPC_NT_INVALID_PIPE_OBJECT			0xC003005C
#define	RPC_NT_INVALID_PIPE_OPERATION			0xC003005D
#define	RPC_NT_WRONG_PIPE_VERSION			0xC003005E
#define	RPC_NT_PIPE_CLOSED				0xC003005F
#define	RPC_NT_PIPE_DISCIPLINE_ERROR			0xC0030060
#define	RPC_NT_PIPE_EMPTY				0xC0030061

/*
 * Status codes from higher numbered facilities are not used.
 */

#ifdef	__cplusplus
}
#endif

#endif	/* _SMB_NTSTATUS_H */
