/*
* CDDL HEADER START
*
* The contents of this file are subject to the terms of the
* Common Development and Distribution License, v.1,  (the "License").
* You may not use this file except in compliance with the License.
*
* You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
* or http://opensource.org/licenses/CDDL-1.0.
* See the License for the specific language governing permissions
* and limitations under the License.
*
* When distributing Covered Code, include this CDDL HEADER in each
* file and include the License file at usr/src/OPENSOLARIS.LICENSE.
* If applicable, add the following below this CDDL HEADER, with the
* fields enclosed by brackets "[]" replaced with your own identifying
* information: Portions Copyright [yyyy] [name of copyright owner]
*
* CDDL HEADER END
*/

/*
* Copyright 2014-2017 Cavium, Inc. 
* The contents of this file are subject to the terms of the Common Development 
* and Distribution License, v.1,  (the "License").

* You may not use this file except in compliance with the License.

* You can obtain a copy of the License at available 
* at http://opensource.org/licenses/CDDL-1.0

* See the License for the specific language governing permissions and 
* limitations under the License.
*/

#ifndef REG_ADDR_H
#define REG_ADDR_H

#define PGLCS_REG_INT_STS                                                                                    0x001d00UL //Access:R    DataWidth:0x2    // Multi Field Register.
  #define PGLCS_REG_INT_STS_ADDRESS_ERROR                                                                    (0x1<<0) // Signals an unknown address to the rf module.
  #define PGLCS_REG_INT_STS_ADDRESS_ERROR_SHIFT                                                              0
  #define PGLCS_REG_INT_STS_RASDP_ERROR_K2_E5                                                                (0x1<<1) // It indicates rasdp error
  #define PGLCS_REG_INT_STS_RASDP_ERROR_K2_E5_SHIFT                                                          1
#define PGLCS_REG_INT_MASK                                                                                   0x001d04UL //Access:RW   DataWidth:0x2    // Multi Field Register.
  #define PGLCS_REG_INT_MASK_ADDRESS_ERROR                                                                   (0x1<<0) // This bit masks, when set, the Interrupt bit: PGLCS_REG_INT_STS.ADDRESS_ERROR .
  #define PGLCS_REG_INT_MASK_ADDRESS_ERROR_SHIFT                                                             0
  #define PGLCS_REG_INT_MASK_RASDP_ERROR_K2_E5                                                               (0x1<<1) // This bit masks, when set, the Interrupt bit: PGLCS_REG_INT_STS.RASDP_ERROR .
  #define PGLCS_REG_INT_MASK_RASDP_ERROR_K2_E5_SHIFT                                                         1
#define PGLCS_REG_INT_STS_WR                                                                                 0x001d08UL //Access:WR   DataWidth:0x2    // Multi Field Register.
  #define PGLCS_REG_INT_STS_WR_ADDRESS_ERROR                                                                 (0x1<<0) // Signals an unknown address to the rf module.
  #define PGLCS_REG_INT_STS_WR_ADDRESS_ERROR_SHIFT                                                           0
  #define PGLCS_REG_INT_STS_WR_RASDP_ERROR_K2_E5                                                             (0x1<<1) // It indicates rasdp error
  #define PGLCS_REG_INT_STS_WR_RASDP_ERROR_K2_E5_SHIFT                                                       1
#define PGLCS_REG_INT_STS_CLR                                                                                0x001d0cUL //Access:RC   DataWidth:0x2    // Multi Field Register.
  #define PGLCS_REG_INT_STS_CLR_ADDRESS_ERROR                                                                (0x1<<0) // Signals an unknown address to the rf module.
  #define PGLCS_REG_INT_STS_CLR_ADDRESS_ERROR_SHIFT                                                          0
  #define PGLCS_REG_INT_STS_CLR_RASDP_ERROR_K2_E5                                                            (0x1<<1) // It indicates rasdp error
  #define PGLCS_REG_INT_STS_CLR_RASDP_ERROR_K2_E5_SHIFT                                                      1
#define PGLCS_REG_RASDP_ERROR_MODE_EN_OFF_K2_E5                                                              0x001d10UL //Access:RW   DataWidth:0x1    // Disable rasdp error mode check
#define PGLCS_REG_DBG_SELECT_K2_E5                                                                           0x001d14UL //Access:RW   DataWidth:0x8    // DBMUX register for selecting a line to output
#define PGLCS_REG_DBG_DWORD_ENABLE_K2_E5                                                                     0x001d18UL //Access:RW   DataWidth:0x4    // DBMUX register. Bit mask for enabling dword (128bit line) / qword (256bit line)                           in the selected line (before shift).for selecting a line to output
#define PGLCS_REG_DBG_SHIFT_K2_E5                                                                            0x001d1cUL //Access:RW   DataWidth:0x2    // DBMUX register. Circular dword (128bit line) / qword (256bit line)                           right shifting of the selected line (after the masking).
#define PGLCS_REG_DBG_FORCE_VALID_K2_E5                                                                      0x001d20UL //Access:RW   DataWidth:0x4    // DBMUX register. Bit mask  for forcing the valid signal per dword (128bit line) / qword (256bit line)                           (before shift).
#define PGLCS_REG_DBG_FORCE_FRAME_K2_E5                                                                      0x001d24UL //Access:RW   DataWidth:0x4    // DBMUX register. bit mask for forcing the frame signal per dword (128bit line) / qword (256bit line)                           (before shift).
#define PGLCS_REG_PGL_CS                                                                                     0x002000UL //Access:RW   DataWidth:0x20   // Control and status interface for PCIE IP.
#define PGLCS_REG_PGL_CS_SIZE_BB                                                                             2048
#define PGLCS_REG_PGL_CS_SIZE_K2_E5                                                                          1024
#define PGLCS_REG_PGL_CS_VF_1_K2_E5                                                                          0x003000UL //Access:RW   DataWidth:0x20   // 
#define PGLCS_REG_PGL_CS_VF_1_SIZE                                                                           256
#define PGLCS_REG_PGL_CS_SHADOW_K2_E5                                                                        0x003400UL //Access:RW   DataWidth:0x20   // 
#define PGLCS_REG_PGL_CS_SHADOW_SIZE                                                                         128
#define PGLCS_REG_PGL_CS_SHADOW_VF_K2_E5                                                                     0x003600UL //Access:RW   DataWidth:0x20   // 
#define PGLCS_REG_PGL_CS_SHADOW_VF_SIZE                                                                      128
#define PGLCS_REG_FIRST_VF_K2_E5                                                                             0x003800UL //Access:RW   DataWidth:0x8    // First VF
#define PGLCS_REG_DISCARD_POISONED_MCTP_TGTWR_K2_E5                                                          0x003804UL //Access:RW   DataWidth:0x2    // Discard when poisoned
#define PGLCS_REG_RX_HDR_ALMOST_FULL_THR_HIGH_K2_E5                                                          0x003808UL //Access:RW   DataWidth:0x8    // rx_hdr_almost_full_thr_high
#define PGLCS_REG_RX_HDR_ALMOST_FULL_THR_LOW_K2_E5                                                           0x00380cUL //Access:RW   DataWidth:0x8    // rx_hdr_almost_full_thr_low
#define PGLCS_REG_RX_DATA_ALMOST_FULL_THR_HIGH_K2_E5                                                         0x003810UL //Access:RW   DataWidth:0x8    // rx_data_almost_full_thr_high
#define PGLCS_REG_RX_DATA_ALMOST_FULL_THR_LOW_K2_E5                                                          0x003814UL //Access:RW   DataWidth:0x8    // rx_data_almost_full_thr_low
#define PGLCS_REG_STATISTIC_MASK_K2_E5                                                                       0x003818UL //Access:RW   DataWidth:0x6    // Statistic mask enable Bit5 :  Mask Message VDM Bit4 :  Mask memory read Bit3 :  Mask memory write Bit2 :  Mask Completion Bit1 :  Mask TX Bit0 :  Mask RX
#define PGLCS_REG_RX_TLP_NUM_K2_E5                                                                           0x00381cUL //Access:R    DataWidth:0x20   // Number of RX tlp  are received
#define PGLCS_REG_RX_TLP_BYTE_NUM_K2_E5                                                                      0x003820UL //Access:R    DataWidth:0x20   // Byte number of RX are received
#define PGLCS_REG_TX_TLP_NUM_K2_E5                                                                           0x003824UL //Access:R    DataWidth:0x20   // tx number of tlp  sent
#define PGLCS_REG_TX_TLP_BYTE_NUM_K2_E5                                                                      0x003828UL //Access:R    DataWidth:0x20   // byte number of tlp sent
#define PGLCS_REG_ECO_RESERVED_K2_E5                                                                         0x00382cUL //Access:RW   DataWidth:0x20   // Debug only: Reserved bits for ECO. Bit 0 - For ending "endless completion". 0 - When receiving a completion timeout while receiving a completion on the same tag, terminate the received completion. 1 - don't terminate (ignore this case). Bit 1 - For CQ83850. 0 - Add the fix for CQ83850 - continue 1cycle delay when we have a new 'hv'. 1 - Do not add the fix. Bit 2 - For CQ84726 - RW ordering. Should be the same as bit 1 in PGLUE_B eco_reserved. 0 - Add the fix. 1 - Do not add the fix.
#define PGLCS_REG_SYNCFIFO_POP_UNDERFLOW_K2_E5                                                               0x003830UL //Access:R    DataWidth:0x4    // 0 - TXCPL sync fifo pop underflow 1 - TXR sync fifo pop underflow 2 - TXW header sync fifo pop underflow 3 - TXW data sync fifo pop underflow
#define PGLCS_REG_SYNCFIFO_PUSH_OVERFLOW_K2_E5                                                               0x003834UL //Access:R    DataWidth:0x6    // 0 - RX target read and config sync fifo push overflow 1 - RX header sync fifo push overflow 5:2 - RX data sync fifo push overflow (1 bit per each 128b instance)
#define PGLCS_REG_TX_SYNCFIFO_POP_STATUS_K2_E5                                                               0x003838UL //Access:R    DataWidth:0x14   // 4:0 - TXCPL sync fifo pop status 9:5 - TXR sync fifo pop status 14:10 - TXW header sync fifo pop status 19:15 - TXW data sync fifo pop status
#define PCIEIP_REG_DEVICE_ID_VENDOR_ID_REG_K2_E5                                                             0x000000UL //Access:RW   DataWidth:0x20   // Device ID and Vendor ID Register.
  #define PCIEIP_REG_DEVICE_ID_VENDOR_ID_REG_PCI_TYPE0_VENDOR_ID_K2_E5                                       (0xffff<<0) // Vendor ID. PCI-SIG assigned Manufacturer Identifier.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_DEVICE_ID_VENDOR_ID_REG_PCI_TYPE0_VENDOR_ID_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_DEVICE_ID_VENDOR_ID_REG_PCI_TYPE0_DEVICE_ID_K2_E5                                       (0xffff<<16) // Device ID. Vendor Assigned Device Identifier.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_DEVICE_ID_VENDOR_ID_REG_PCI_TYPE0_DEVICE_ID_K2_E5_SHIFT                                 16
#define PCIEIP_REG_DEVICE_VENDOR_ID_BB                                                                       0x000000UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_DEVICE_VENDOR_ID_VENDOR_ID_BB                                                           (0xffff<<0) // This register identifies the PCI adapter. This value can be written by firmware through the PCIE private register space VENDOR_ID to modify this read value to the host. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_VENDOR_ID_VENDOR_ID_BB_SHIFT                                                     0
  #define PCIEIP_REG_DEVICE_VENDOR_ID_DEVICE_ID_BB                                                           (0xffff<<16) // This register identifies the device on the PCIE adapter. This value can be written by firmware through the PCIE private register space DEVICE_ID, which modifes the value read by host. The default value reflects the value of DEVICE_ID in version.v or strap pins user_device_id depending on build options chosen by user. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_VENDOR_ID_DEVICE_ID_BB_SHIFT                                                     16
#define PCIEIP_REG_STATUS_COMMAND_REG_K2_E5                                                                  0x000004UL //Access:RW   DataWidth:0x20   // Command and Status Register.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_IO_EN_K2_E5                                                (0x1<<0) // Enables IO Access Response.   You cannot write to this register if your configuration has no IO bars; that is, the internal signal has_io_bar=0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_IO_EN_K2_E5_SHIFT                                          0
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_MEM_SPACE_EN_K2_E5                                         (0x1<<1) // Enables Memory Access Response.   You cannot write to this register if your configuration has no MEM bars; that is, the internal signal has_mem_bar=0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_MEM_SPACE_EN_K2_E5_SHIFT                                   1
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_BUS_MASTER_EN_K2_E5                                        (0x1<<2) // Bus Master Enable. Controls Issuing of Memory and I/O Requests.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_BUS_MASTER_EN_K2_E5_SHIFT                                  2
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_SPECIAL_CYCLE_OPERATION_K2_E5                              (0x1<<3) // Special Cycle Enable.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_SPECIAL_CYCLE_OPERATION_K2_E5_SHIFT                        3
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_MWI_ENABLE_K2_E5                                            (0x1<<4) // Memory Write and Invalidate.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_MWI_ENABLE_K2_E5_SHIFT                                      4
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_VGA_PALETTE_SNOOP_K2_E5                                     (0x1<<5) // VGA Palette Snoop.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_VGA_PALETTE_SNOOP_K2_E5_SHIFT                               5
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_PARITY_ERR_EN_K2_E5                                        (0x1<<6) // Controls Logging of Poisoned TLPs.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_PARITY_ERR_EN_K2_E5_SHIFT                                  6
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_IDSEL_STEPPING_K2_E5                                        (0x1<<7) // IDSEL Stepping.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_IDSEL_STEPPING_K2_E5_SHIFT                                  7
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_SERREN_K2_E5                                               (0x1<<8) // Enables Error Reporting.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_SERREN_K2_E5_SHIFT                                         8
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_INT_EN_K2_E5                                               (0x1<<10) // Controls generation of interrupts by a function.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE0_INT_EN_K2_E5_SHIFT                                         10
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_RESERV_K2_E5                                                (0x1f<<11) // Reserved.
  #define PCIEIP_REG_STATUS_COMMAND_REG_PCI_TYPE_RESERV_K2_E5_SHIFT                                          11
  #define PCIEIP_REG_STATUS_COMMAND_REG_INT_STATUS_K2_E5                                                     (0x1<<19) // Emulation interrupt pending.
  #define PCIEIP_REG_STATUS_COMMAND_REG_INT_STATUS_K2_E5_SHIFT                                               19
  #define PCIEIP_REG_STATUS_COMMAND_REG_CAP_LIST_K2_E5                                                       (0x1<<20) // Extended Capability.
  #define PCIEIP_REG_STATUS_COMMAND_REG_CAP_LIST_K2_E5_SHIFT                                                 20
  #define PCIEIP_REG_STATUS_COMMAND_REG_FAST_66MHZ_CAP_K2_E5                                                 (0x1<<21) // PCI 66MHz Capability.
  #define PCIEIP_REG_STATUS_COMMAND_REG_FAST_66MHZ_CAP_K2_E5_SHIFT                                           21
  #define PCIEIP_REG_STATUS_COMMAND_REG_FAST_B2B_CAP_K2_E5                                                   (0x1<<23) // Fast Back to Back Transaction Capable and Enable.
  #define PCIEIP_REG_STATUS_COMMAND_REG_FAST_B2B_CAP_K2_E5_SHIFT                                             23
  #define PCIEIP_REG_STATUS_COMMAND_REG_MASTER_DPE_K2_E5                                                     (0x1<<24) // Controls poisoned Completion and Request error reporting.
  #define PCIEIP_REG_STATUS_COMMAND_REG_MASTER_DPE_K2_E5_SHIFT                                               24
  #define PCIEIP_REG_STATUS_COMMAND_REG_DEV_SEL_TIMING_K2_E5                                                 (0x3<<25) // Device Select Timing.
  #define PCIEIP_REG_STATUS_COMMAND_REG_DEV_SEL_TIMING_K2_E5_SHIFT                                           25
  #define PCIEIP_REG_STATUS_COMMAND_REG_SIGNALED_TARGET_ABORT_K2_E5                                          (0x1<<27) // Completer Abort Error.
  #define PCIEIP_REG_STATUS_COMMAND_REG_SIGNALED_TARGET_ABORT_K2_E5_SHIFT                                    27
  #define PCIEIP_REG_STATUS_COMMAND_REG_RCVD_TARGET_ABORT_K2_E5                                              (0x1<<28) // Completer Abort received.
  #define PCIEIP_REG_STATUS_COMMAND_REG_RCVD_TARGET_ABORT_K2_E5_SHIFT                                        28
  #define PCIEIP_REG_STATUS_COMMAND_REG_RCVD_MASTER_ABORT_K2_E5                                              (0x1<<29) // Unsupported request completion status received.
  #define PCIEIP_REG_STATUS_COMMAND_REG_RCVD_MASTER_ABORT_K2_E5_SHIFT                                        29
  #define PCIEIP_REG_STATUS_COMMAND_REG_SIGNALED_SYS_ERR_K2_E5                                               (0x1<<30) // Fatal or Non-Fatal Error Message sent by function.
  #define PCIEIP_REG_STATUS_COMMAND_REG_SIGNALED_SYS_ERR_K2_E5_SHIFT                                         30
  #define PCIEIP_REG_STATUS_COMMAND_REG_DETECTED_PARITY_ERR_K2_E5                                            (0x1<<31) // Poisoned TLP received by function.
  #define PCIEIP_REG_STATUS_COMMAND_REG_DETECTED_PARITY_ERR_K2_E5_SHIFT                                      31
#define PCIEIP_REG_STATUS_COMMAND_BB                                                                         0x000004UL //Access:RW   DataWidth:0x20   // This is the PCIE compliant status/command register (bits 31-16: status, bits 15-0: command)
  #define PCIEIP_REG_STATUS_COMMAND_IO_SPACE_BB                                                              (0x1<<0) // This bit indicates that the device does not support I/O space access because it is zero and can not be modified. IO transactions targeting this device return completion with UR status . Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_IO_SPACE_BB_SHIFT                                                        0
  #define PCIEIP_REG_STATUS_COMMAND_MEM_SPACE_BB                                                             (0x1<<1) // This bit controls the enabling of the memory space. When disabled, memory transactions targeting this device return completion with UR status Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_MEM_SPACE_BB_SHIFT                                                       1
  #define PCIEIP_REG_STATUS_COMMAND_BUS_MASTER_BB                                                            (0x1<<2) // This bit controls the enabling of the bus master activity by this device. When low, it disables an Endpoint function from issuing memory or IO requests. Also disables the ability to issue MSI messages. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_BUS_MASTER_BB_SHIFT                                                      2
  #define PCIEIP_REG_STATUS_COMMAND_SPECIAL_CYCLES_BB                                                        (0x1<<3) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_SPECIAL_CYCLES_BB_SHIFT                                                  3
  #define PCIEIP_REG_STATUS_COMMAND_MWI_CYCLES_BB                                                            (0x1<<4) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_MWI_CYCLES_BB_SHIFT                                                      4
  #define PCIEIP_REG_STATUS_COMMAND_VGA_SNOOP_BB                                                             (0x1<<5) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_VGA_SNOOP_BB_SHIFT                                                       5
  #define PCIEIP_REG_STATUS_COMMAND_PERR_ENA_BB                                                              (0x1<<6) // This bit enables the write to the Master data parity error status bit. If this bit is cleared , the master data parity error status bit will never be set. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_PERR_ENA_BB_SHIFT                                                        6
  #define PCIEIP_REG_STATUS_COMMAND_STEPPING_BB                                                              (0x1<<7) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_STEPPING_BB_SHIFT                                                        7
  #define PCIEIP_REG_STATUS_COMMAND_SERR_ENA_BB                                                              (0x1<<8) // When set, this bit enables the non fatal and fatal errors detected by the function to be reported to the Root Complex. The function reports such errors to the Root Complex if it is enabled to do so either through this bit or though PCI express specific bits in DCR Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_SERR_ENA_BB_SHIFT                                                        8
  #define PCIEIP_REG_STATUS_COMMAND_FAST_B2B_BB                                                              (0x1<<9) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_FAST_B2B_BB_SHIFT                                                        9
  #define PCIEIP_REG_STATUS_COMMAND_INT_DISABLE_BB                                                           (0x1<<10) // When this bit is set, function is not permitted to generate IntX interrupt messages (de-asserted) regardless of any internal chip logic. Setting this bit has no effect on the INT_STATUS bit below. Writing this bit to '0' will un-mask the interrupt and let it run normally. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_INT_DISABLE_BB_SHIFT                                                     10
  #define PCIEIP_REG_STATUS_COMMAND_RESERVED_BB                                                              (0x1f<<11) // These bits are reserved and tied low per the PCIE specification. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_STATUS_COMMAND_RESERVED_BB_SHIFT                                                        11
  #define PCIEIP_REG_STATUS_COMMAND_RESERVED1_BB                                                             (0x7<<16) // These bits are reserved and tied low per the PCIE specification. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_RESERVED1_BB_SHIFT                                                       16
  #define PCIEIP_REG_STATUS_COMMAND_INT_STATUS_BB                                                            (0x1<<19) // This bit indicates the internal interrupt request state (before being masked by INT_DISABLE. A '0' indicates that no interrupt is pending. A '1' indicates that there is an interrupt pending. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_INT_STATUS_BB_SHIFT                                                      19
  #define PCIEIP_REG_STATUS_COMMAND_CAP_LIST_BB                                                              (0x1<<20) // This bit is tied high to indicate that the device supports a capability list. The list starts at address 0x40. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_CAP_LIST_BB_SHIFT                                                        20
  #define PCIEIP_REG_STATUS_COMMAND_CAP_66MHZ_BB                                                             (0x1<<21) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_CAP_66MHZ_BB_SHIFT                                                       21
  #define PCIEIP_REG_STATUS_COMMAND_RESERVED2_BB                                                             (0x1<<22) // These bits are reserved and tied low per the PCI specification. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_RESERVED2_BB_SHIFT                                                       22
  #define PCIEIP_REG_STATUS_COMMAND_FAST_B2B_CAP_BB                                                          (0x1<<23) // Does not apply to PCIE. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_FAST_B2B_CAP_BB_SHIFT                                                    23
  #define PCIEIP_REG_STATUS_COMMAND_PRI_MSTR_PERR_BB                                                         (0x1<<24) // The master data parity error bit is set by a requester if the parity error enable bit is set in its command register and either of the following 2 conditions occur. If the requester receives a poisoned completion if the requester poisons a write request If the parity Error enable bit is cleared , the master data parity error status bit is never set Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_PRI_MSTR_PERR_BB_SHIFT                                                   24
  #define PCIEIP_REG_STATUS_COMMAND_DEVSEL_TIMING_BB                                                         (0x3<<25) // Does not apply to PCIE Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_DEVSEL_TIMING_BB_SHIFT                                                   25
  #define PCIEIP_REG_STATUS_COMMAND_PRI_SIG_TGT_ABT_BB                                                       (0x1<<27) // This bit is set when a function acting as a completer terminates a request by issuing Completer abort completion status to the requester Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_PRI_SIG_TGT_ABT_BB_SHIFT                                                 27
  #define PCIEIP_REG_STATUS_COMMAND_PRI_RCV_TGT_ABT_BB                                                       (0x1<<28) // This bit is set when a requester receives a completion with completer abort completion status. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_PRI_RCV_TGT_ABT_BB_SHIFT                                                 28
  #define PCIEIP_REG_STATUS_COMMAND_PRI_RCV_MSTR_ABT_BB                                                      (0x1<<29) // This bit is set when a requester receives a completion with UR completion status Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_PRI_RCV_MSTR_ABT_BB_SHIFT                                                29
  #define PCIEIP_REG_STATUS_COMMAND_PRI_SIG_SERR_BB                                                          (0x1<<30) // This bit is set when a function sends an ERR_FATAL or ERR_NONFATAL message and the SERR enable bit in the command register is set Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_PRI_SIG_SERR_BB_SHIFT                                                    30
  #define PCIEIP_REG_STATUS_COMMAND_PRI_PAR_ERR_BB                                                           (0x1<<31) // When this bit is set, it indicates that the function has received a poisoned TLP Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_STATUS_COMMAND_PRI_PAR_ERR_BB_SHIFT                                                     31
#define PCIEIP_REG_CLASS_CODE_REVISION_ID_K2_E5                                                              0x000008UL //Access:RW   DataWidth:0x20   // Class Code and Revision ID Register.
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_REVISION_ID_K2_E5                                                (0xff<<0) // Vendor chosen Revision ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_REVISION_ID_K2_E5_SHIFT                                          0
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_PROGRAM_INTERFACE_K2_E5                                          (0xff<<8) // Class Code Programming Interface.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_PROGRAM_INTERFACE_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_SUBCLASS_CODE_K2_E5                                              (0xff<<16) // Subclass Code to represent Device Type.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_SUBCLASS_CODE_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_BASE_CLASS_CODE_K2_E5                                            (0xff<<24) // Base Class Code to represent Device Type.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_CLASS_CODE_REVISION_ID_BASE_CLASS_CODE_K2_E5_SHIFT                                      24
#define PCIEIP_REG_REV_ID_CLASS_CODE_BB                                                                      0x000008UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REV_ID_CLASS_CODE_REV_ID_BB                                                             (0xff<<0) // This register identifies the revision of the PCI adapter. This value is written by firmware through the PCI register space REVISION_ID value to modify the read value to the host. The default value is provided by user_revision_id strap pins.
  #define PCIEIP_REG_REV_ID_CLASS_CODE_REV_ID_BB_SHIFT                                                       0
  #define PCIEIP_REG_REV_ID_CLASS_CODE_CLASS_CODE_BB                                                         (0xffffff<<8) // The 24-bit Class Code register identifies the generic function of the device. All of the legal values are specified in the PCI specification. This read value is controlled by the CLASS_CODE valid value in the PCI register space. The default value reflects the value of CLASS_CODE in version.v defined by user. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_REV_ID_CLASS_CODE_CLASS_CODE_BB_SHIFT                                                   8
#define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_K2_E5                                        0x00000cUL //Access:RW   DataWidth:0x20   // BIST, Header Type, Cache Line Size, and Latency Timer Registers.
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_CACHE_LINE_SIZE_K2_E5                      (0xff<<0) // Cache Line Size. Has no effect on PCIe device behavior.
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_CACHE_LINE_SIZE_K2_E5_SHIFT                0
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_LATENCY_MASTER_TIMER_K2_E5                 (0xff<<8) // Does not apply to PCI Express.
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_LATENCY_MASTER_TIMER_K2_E5_SHIFT           8
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_HEADER_TYPE_K2_E5                          (0x7f<<16) // Specifies Header Type.
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_HEADER_TYPE_K2_E5_SHIFT                    16
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_MULTI_FUNC_K2_E5                           (0x1<<23) // Specifies whether device is multifunction.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_MULTI_FUNC_K2_E5_SHIFT                     23
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_BIST_K2_E5                                 (0xff<<24) // Optional for BIST support.
  #define PCIEIP_REG_BIST_HEADER_TYPE_LATENCY_CACHE_LINE_SIZE_REG_BIST_K2_E5_SHIFT                           24
#define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_BB                                                           0x00000cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_CACHE_LINE_SIZE_BB                                         (0xff<<0) // This field is implemented by PCIE device as a read/write field for legacy compatibility purposes. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_CACHE_LINE_SIZE_BB_SHIFT                                   0
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_LATENCY_TIMER_BB                                           (0xff<<8) // This register does not apply to PCI express and must be hardwired to zero Path = i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_LATENCY_TIMER_BB_SHIFT                                     8
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_HEADER_TYPE_BB                                             (0xff<<16) // The 8-bit Header Type register identifies both the layout of bytes 10h through 3Fh of the Configuration space, as well as whether this adapter contains multiple functions. A value of 0x80 indicates a multi function device (Type 0) using the format specified in the PCI specification, while a value of 0x0 indicates a single function Type 0 device. Path = i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_HEADER_TYPE_BB_SHIFT                                       16
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_BIST_BB                                                    (0xff<<24) // The 8-bit BIST register is used to initiate and report the results of any Built-In-Self-Test. This value can be written by firmware through the PCI register space BIST register to modify the read value to the host. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_HEADERTYPE_LAT_CACHELINESIZE_BIST_BB_SHIFT                                              24
#define PCIEIP_REG_BAR0_REG_K2_E5                                                                            0x000010UL //Access:RW   DataWidth:0x20   // BAR0 and BAR Mask.  The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_BAR0_REG_BAR0_MEM_IO_K2_E5                                                              (0x1<<0) // BAR0 Memory Space Indicator.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR0_REG_BAR0_MEM_IO_K2_E5_SHIFT                                                        0
  #define PCIEIP_REG_BAR0_REG_BAR0_TYPE_K2_E5                                                                (0x3<<1) // BAR0 32-bit or 64-bit.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR0_REG_BAR0_TYPE_K2_E5_SHIFT                                                          1
  #define PCIEIP_REG_BAR0_REG_BAR0_PREFETCH_K2_E5                                                            (0x1<<3) // BAR0 Prefetchable.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR0_REG_BAR0_PREFETCH_K2_E5_SHIFT                                                      3
  #define PCIEIP_REG_BAR0_REG_BAR0_START_K2_E5                                                               (0xfffffff<<4) // BAR0 Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W if enabled else R
  #define PCIEIP_REG_BAR0_REG_BAR0_START_K2_E5_SHIFT                                                         4
#define PCIEIP_REG_BAR_1_BB                                                                                  0x000010UL //Access:RW   DataWidth:0x20   // The 32-bit BAR_1 register programs the base address for the memory space mapped by the card onto the PCI bus. This register can be combined with BAR_2 to make a 64-bit address for supporting Dual Address cycles systems. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_BAR_1_MEM_SPACE_BB                                                                      (0x1<<0) // This bit indicates that BAR_1 maps a memory space and is always read as 0. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_1_MEM_SPACE_BB_SHIFT                                                                0
  #define PCIEIP_REG_BAR_1_SPACE_TYPE_BB                                                                     (0x3<<1) // These bits indicate that BAR_1 may be programmed to map this adapter to anywhere in the 64-bit address space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_1_SPACE_TYPE_BB_SHIFT                                                               1
  #define PCIEIP_REG_BAR_1_PREFETCH_BB                                                                       (0x1<<3) // This bit indicates that the area mapped by BAR_1 may be pre-fetched or cached by the system without side effects. Bit can be programmed from shadow register. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_1_PREFETCH_BB_SHIFT                                                                 3
  #define PCIEIP_REG_BAR_1_ADDRESS_BB                                                                        (0xfffffff<<4) // These bits set the address within a 32-bit address space that will be card will respond in. These bits may be combined with the bits in BAR_2 to create a full 64 bit address decode. Only the bits that address blocks bigger than the setting in the BAR1_SIZE value are RW. All lower bits are RO with a value of zero. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_BAR_1_ADDRESS_BB_SHIFT                                                                  4
#define PCIEIP_REG_BAR1_REG_K2_E5                                                                            0x000014UL //Access:RW   DataWidth:0x20   // BAR1 and BAR Mask.  The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_BAR1_REG_BAR1_MEM_IO_K2_E5                                                              (0x1<<0) // BAR1 Memory Space Indicator.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR1_REG_BAR1_MEM_IO_K2_E5_SHIFT                                                        0
  #define PCIEIP_REG_BAR1_REG_BAR1_TYPE_K2_E5                                                                (0x3<<1) // BAR1 32-bit or 64-bit.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR1_REG_BAR1_TYPE_K2_E5_SHIFT                                                          1
  #define PCIEIP_REG_BAR1_REG_BAR1_PREFETCH_K2_E5                                                            (0x1<<3) // BAR1 Prefetchable.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR1_REG_BAR1_PREFETCH_K2_E5_SHIFT                                                      3
  #define PCIEIP_REG_BAR1_REG_BAR1_START_K2_E5                                                               (0xfffffff<<4) // BAR1 Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W if enabled else R
  #define PCIEIP_REG_BAR1_REG_BAR1_START_K2_E5_SHIFT                                                         4
#define PCIEIP_REG_BAR_2_BB                                                                                  0x000014UL //Access:RW   DataWidth:0x20   // The 32-bit BAR_2 register programs the upper half of the base address for the memory space mapped by the card onto the PCI bus. Path = i_cfg_func.i_cfg_public.i_cfg_dec
#define PCIEIP_REG_BAR2_REG_K2_E5                                                                            0x000018UL //Access:RW   DataWidth:0x20   // BAR2 and BAR Mask.  The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_BAR2_REG_BAR2_MEM_IO_K2_E5                                                              (0x1<<0) // BAR2 Memory Space Indicator.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR2_REG_BAR2_MEM_IO_K2_E5_SHIFT                                                        0
  #define PCIEIP_REG_BAR2_REG_BAR2_TYPE_K2_E5                                                                (0x3<<1) // BAR2 32-bit or 64-bit.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR2_REG_BAR2_TYPE_K2_E5_SHIFT                                                          1
  #define PCIEIP_REG_BAR2_REG_BAR2_PREFETCH_K2_E5                                                            (0x1<<3) // BAR2 Prefetchable.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR2_REG_BAR2_PREFETCH_K2_E5_SHIFT                                                      3
  #define PCIEIP_REG_BAR2_REG_BAR2_START_K2_E5                                                               (0xfffffff<<4) // BAR2 Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W if enabled else R
  #define PCIEIP_REG_BAR2_REG_BAR2_START_K2_E5_SHIFT                                                         4
#define PCIEIP_REG_BAR_3_BB                                                                                  0x000018UL //Access:RW   DataWidth:0x20   // The 32-bit BAR_3 register programs the 2nd base address for the memory space mapped by the card onto the PCI bus. This register can be combined with BAR_4 to make a 64-bit address for supporting Dual Address cycles systems.
  #define PCIEIP_REG_BAR_3_MEM_SPACE_BB                                                                      (0x1<<0) // This bit indicates that BAR_2 maps a memory space and is always read as 0. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_3_MEM_SPACE_BB_SHIFT                                                                0
  #define PCIEIP_REG_BAR_3_SPACE_TYPE_BB                                                                     (0x3<<1) // These bits indicate that BAR_2 may be programmed to map this adapter to anywhere in the 64-bit address space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_3_SPACE_TYPE_BB_SHIFT                                                               1
  #define PCIEIP_REG_BAR_3_PREFETCH_BB                                                                       (0x1<<3) // This bit indicates that the area mapped by BAR_2 may be pre-fetched or cached by the system without side effects. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_3_PREFETCH_BB_SHIFT                                                                 3
  #define PCIEIP_REG_BAR_3_ADDRESS_BB                                                                        (0xfffffff<<4) // These bits set the address within a 32-bit address space that will be card will respond in. These bits may be combined with the bits in BAR_4 to create a full 64 bit address decode. Only the bits that address blocks bigger than the setting in the BAR2_SIZE value are RW. All lower bits are RO with a value of zero. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_BAR_3_ADDRESS_BB_SHIFT                                                                  4
#define PCIEIP_REG_BAR3_REG_K2_E5                                                                            0x00001cUL //Access:RW   DataWidth:0x20   // BAR3 and BAR Mask.  The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_BAR3_REG_BAR3_MEM_IO_K2_E5                                                              (0x1<<0) // BAR3 Memory Space Indicator.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR3_REG_BAR3_MEM_IO_K2_E5_SHIFT                                                        0
  #define PCIEIP_REG_BAR3_REG_BAR3_TYPE_K2_E5                                                                (0x3<<1) // BAR3 32-bit or 64-bit.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR3_REG_BAR3_TYPE_K2_E5_SHIFT                                                          1
  #define PCIEIP_REG_BAR3_REG_BAR3_PREFETCH_K2_E5                                                            (0x1<<3) // BAR3 Prefetchable.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR3_REG_BAR3_PREFETCH_K2_E5_SHIFT                                                      3
  #define PCIEIP_REG_BAR3_REG_BAR3_START_K2_E5                                                               (0xfffffff<<4) // BAR3 Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W if enabled else R
  #define PCIEIP_REG_BAR3_REG_BAR3_START_K2_E5_SHIFT                                                         4
#define PCIEIP_REG_BAR_4_BB                                                                                  0x00001cUL //Access:RW   DataWidth:0x20   // The 32-bit BAR_4 register programs the upper half of the 2nd base address for the memory space mapped by the card onto the PCI bus. Path = i_cfg_func.i_cfg_public.i_cfg_dec
#define PCIEIP_REG_BAR4_REG_K2_E5                                                                            0x000020UL //Access:RW   DataWidth:0x20   // BAR4 and BAR Mask.  The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_BAR4_REG_BAR4_MEM_IO_K2_E5                                                              (0x1<<0) // BAR4 Memory Space Indicator.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR4_REG_BAR4_MEM_IO_K2_E5_SHIFT                                                        0
  #define PCIEIP_REG_BAR4_REG_BAR4_TYPE_K2_E5                                                                (0x3<<1) // BAR4 32-bit or 64-bit.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR4_REG_BAR4_TYPE_K2_E5_SHIFT                                                          1
  #define PCIEIP_REG_BAR4_REG_BAR4_PREFETCH_K2_E5                                                            (0x1<<3) // BAR4 Prefetchable.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR4_REG_BAR4_PREFETCH_K2_E5_SHIFT                                                      3
  #define PCIEIP_REG_BAR4_REG_BAR4_START_K2_E5                                                               (0xfffffff<<4) // BAR4 Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W if enabled else R
  #define PCIEIP_REG_BAR4_REG_BAR4_START_K2_E5_SHIFT                                                         4
#define PCIEIP_REG_BAR_5_BB                                                                                  0x000020UL //Access:RW   DataWidth:0x20   // The 32-bit BAR_5 register programs the 3rd base address for the memory space mapped by the card onto the PCI bus. This register can be combined with BAR_4 to make a 64-bit address for supporting Dual Address cycles systems. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_BAR_5_MEM_SPACE_BB                                                                      (0x1<<0) // This bit indicates that BAR_3 maps a memory space and is always read as 0. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_5_MEM_SPACE_BB_SHIFT                                                                0
  #define PCIEIP_REG_BAR_5_SPACE_TYPE_BB                                                                     (0x3<<1) // These bits indicate that BAR_3 may be programmed to map this adapter to anywhere in the 64-bit address space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_5_SPACE_TYPE_BB_SHIFT                                                               1
  #define PCIEIP_REG_BAR_5_PREFETCH_BB                                                                       (0x1<<3) // This bit indicates that the area mapped by BAR_3 may be pre-fetched or cached by the system without side effects. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_BAR_5_PREFETCH_BB_SHIFT                                                                 3
  #define PCIEIP_REG_BAR_5_ADDRESS_BB                                                                        (0xfffffff<<4) // These bits set the address within a 32-bit address space that will be card will respond in. These bits may be combined with the bits in BAR_6 to create a full 64 bit address decode. Only the bits that address blocks bigger than the setting in the BAR3_SIZE value are RW. All lower bits are RO with a value of zero. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_BAR_5_ADDRESS_BB_SHIFT                                                                  4
#define PCIEIP_REG_BAR5_REG_K2_E5                                                                            0x000024UL //Access:RW   DataWidth:0x20   // BAR5 and BAR Mask.  The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_BAR5_REG_BAR5_MEM_IO_K2_E5                                                              (0x1<<0) // BAR5 Memory Space Indicator.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR5_REG_BAR5_MEM_IO_K2_E5_SHIFT                                                        0
  #define PCIEIP_REG_BAR5_REG_BAR5_TYPE_K2_E5                                                                (0x3<<1) // BAR5 32-bit or 64-bit.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR5_REG_BAR5_TYPE_K2_E5_SHIFT                                                          1
  #define PCIEIP_REG_BAR5_REG_BAR5_PREFETCH_K2_E5                                                            (0x1<<3) // BAR5 Prefetchable.   Note: The access attributes of this field are as follows:  - Dbi: if (BAR_ENABLED == 1) then (if [DBI_RO_WR_EN == 1] then R/W else R) else RO
  #define PCIEIP_REG_BAR5_REG_BAR5_PREFETCH_K2_E5_SHIFT                                                      3
  #define PCIEIP_REG_BAR5_REG_BAR5_START_K2_E5                                                               (0xfffffff<<4) // BAR5 Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W if enabled else R
  #define PCIEIP_REG_BAR5_REG_BAR5_START_K2_E5_SHIFT                                                         4
#define PCIEIP_REG_BAR_6_BB                                                                                  0x000024UL //Access:RW   DataWidth:0x20   // The 32-bit BAR_4 register programs the upper half of the 3nd base address for the memory space mapped by the card onto the PCI bus.
#define PCIEIP_REG_CARDBUS_CIS_PTR_REG_K2_E5                                                                 0x000028UL //Access:RW   DataWidth:0x20   // CardBus CIS Pointer Register.
#define PCIEIP_REG_CARDBUS_CIS_BB                                                                            0x000028UL //Access:R    DataWidth:0x20   // This register is not supported. Path = i_cfg_func.i_cfg_public.i_cfg_rd_mux
#define PCIEIP_REG_SUBSYSTEM_ID_SUBSYSTEM_VENDOR_ID_REG_K2_E5                                                0x00002cUL //Access:RW   DataWidth:0x20   // Subsystem ID and Subsystem Vendor ID Register.
  #define PCIEIP_REG_SUBSYSTEM_ID_SUBSYSTEM_VENDOR_ID_REG_SUBSYS_VENDOR_ID_K2_E5                             (0xffff<<0) // Subsystem Vendor ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SUBSYSTEM_ID_SUBSYSTEM_VENDOR_ID_REG_SUBSYS_VENDOR_ID_K2_E5_SHIFT                       0
  #define PCIEIP_REG_SUBSYSTEM_ID_SUBSYSTEM_VENDOR_ID_REG_SUBSYS_DEV_ID_K2_E5                                (0xffff<<16) // Subsystem Device ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SUBSYSTEM_ID_SUBSYSTEM_VENDOR_ID_REG_SUBSYS_DEV_ID_K2_E5_SHIFT                          16
#define PCIEIP_REG_SUBSYSTEM_ID_VENDOR_ID_BB                                                                 0x00002cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SUBSYSTEM_ID_VENDOR_ID_SUBSYSTEM_VENDOR_ID_BB                                           (0xffff<<0) // The 16-bit Subsystem Vendor ID register is used by the adapter manufacturer for identification. This value can be written by firmware through the PCI register space SUBSYSTEM_VENDOR_ID value to modify the read value to the host. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_SUBSYSTEM_ID_VENDOR_ID_SUBSYSTEM_VENDOR_ID_BB_SHIFT                                     0
  #define PCIEIP_REG_SUBSYSTEM_ID_VENDOR_ID_SUBSYSTEM_ID_BB                                                  (0xffff<<16) // The 16-bit Subsystem ID register is used by the adapter manufacturer for identification. This value can be written by firmware through the PCI register space SUBSYSTEM_ID value to modify the read value to the host. Default values are the same as the DEVICE_ID register. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_SUBSYSTEM_ID_VENDOR_ID_SUBSYSTEM_ID_BB_SHIFT                                            16
#define PCIEIP_REG_EXP_ROM_BASE_ADDR_REG_K2_E5                                                               0x000030UL //Access:RW   DataWidth:0x20   // Expansion ROM BAR and Mask Register.  The mask for this ROM BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_EXP_ROM_BASE_ADDR_REG_ROM_BAR_ENABLE_K2_E5                                              (0x1<<0) // Expansion ROM Enable.   Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_EXP_ROM_BASE_ADDR_REG_ROM_BAR_ENABLE_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_EXP_ROM_BASE_ADDR_REG_EXP_ROM_BASE_ADDRESS_K2_E5                                        (0x1fffff<<11) // Expansion ROM Base Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_EXP_ROM_BASE_ADDR_REG_EXP_ROM_BASE_ADDRESS_K2_E5_SHIFT                                  11
#define PCIEIP_REG_EXP_ROM_BAR_BB                                                                            0x000030UL //Access:RW   DataWidth:0x20   // The 32-bit Expansion ROM BAR register programs the base address for the memory space mapped by the chip for use as the expansion ROM. For more information on the operation of Expansion ROM, see the Theory of Ops specification. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_EXP_ROM_BAR_BAR_ENA_BB                                                                  (0x1<<0) // This bit indicates that the Expansion ROM BAR is valid when set to one. If it is zero, the expansion BAR should not be programmed or used. This bit will only be RW if it is enabled by the EXP_ROM_ENA bit which defaults to 0. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_EXP_ROM_BAR_BAR_ENA_BB_SHIFT                                                            0
  #define PCIEIP_REG_EXP_ROM_BAR_LOW_BB                                                                      (0x3ff<<1) // These bits indicate that the Expansion ROM area is at least 2k bytes. They always read as zero. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_EXP_ROM_BAR_LOW_BB_SHIFT                                                                1
  #define PCIEIP_REG_EXP_ROM_BAR_SIZE_BB                                                                     (0x1fff<<11) // These bits indicate the size of the Expansion ROM area or the address of it. The boundary form RO bits to RW bits is controlled by the EXP_ROM_SIZE bits. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_EXP_ROM_BAR_SIZE_BB_SHIFT                                                               11
  #define PCIEIP_REG_EXP_ROM_BAR_ADDRESS_BB                                                                  (0xff<<24) // These bits indicate the address of the Expansion ROM area.
  #define PCIEIP_REG_EXP_ROM_BAR_ADDRESS_BB_SHIFT                                                            24
#define PCIEIP_REG_PCI_CAP_PTR_REG_K2_E5                                                                     0x000034UL //Access:RW   DataWidth:0x20   // Capability Pointer Register.
  #define PCIEIP_REG_PCI_CAP_PTR_REG_CAP_POINTER_K2_E5                                                       (0xff<<0) // Pointer to first item in the PCI Capability Structure.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PCI_CAP_PTR_REG_CAP_POINTER_K2_E5_SHIFT                                                 0
#define PCIEIP_REG_CAP_POINTER_BB                                                                            0x000034UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_CAP_POINTER_CAP_POINTER_BB                                                              (0xff<<0) // The 8-bit Capabilities Pointer register specifies an offset in the PCI address space of a linked list of new capabilities. The capabilities are PCI-X, PCI Power Management, Vital Product Data (VPD), and Message Signaled Interrupts (MSI) is supported. The read-only value of this register is controlled by the CAP_ENA register in the PCI register space. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_CAP_POINTER_CAP_POINTER_BB_SHIFT                                                        0
#define PCIEIP_REG_MAX_LATENCY_MIN_GRANT_INTERRUPT_PIN_INTERRUPT_LINE_REG_K2_E5                              0x00003cUL //Access:RW   DataWidth:0x20   // Interrupt Line and Pin Register.
  #define PCIEIP_REG_MAX_LATENCY_MIN_GRANT_INTERRUPT_PIN_INTERRUPT_LINE_REG_INT_LINE_K2_E5                   (0xff<<0) // PCI Compatible Interrupt Line Routing Register Field.
  #define PCIEIP_REG_MAX_LATENCY_MIN_GRANT_INTERRUPT_PIN_INTERRUPT_LINE_REG_INT_LINE_K2_E5_SHIFT             0
  #define PCIEIP_REG_MAX_LATENCY_MIN_GRANT_INTERRUPT_PIN_INTERRUPT_LINE_REG_INT_PIN_K2_E5                    (0xff<<8) // PCI Compatible Interrupt Pin Register Field.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_MAX_LATENCY_MIN_GRANT_INTERRUPT_PIN_INTERRUPT_LINE_REG_INT_PIN_K2_E5_SHIFT              8
#define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_BB                                                         0x00003cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_INT_LINE_BB                                              (0xff<<0) // The 8-bit Interrupt Line register is used to communicate interrupt line routing information. This field is set by the host and later used by any driver which needs to know which physical interrupt on the system interrupt controller is assigned to this device. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_INT_LINE_BB_SHIFT                                        0
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_INT_PIN_BB                                               (0xff<<8) // The 8-bit Interrupt Pin register is used to indicate which interrupt pin the device uses. Path = i_cfg_multi
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_INT_PIN_BB_SHIFT                                         8
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_MIN_GRANT_BB                                             (0xff<<16) // Hardwired to zero Path = i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_MIN_GRANT_BB_SHIFT                                       16
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_MAXIMUM_LATENCY_BB                                       (0xff<<24) // Hardwired to zero Path = i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_LAT_MIN_GRANT_INT_PIN_INT_LINE_MAXIMUM_LATENCY_BB_SHIFT                                 24
#define PCIEIP_REG_CAP_ID_NXT_PTR_REG_K2_E5                                                                  0x000040UL //Access:RW   DataWidth:0x20   // Power Management Capabilities Register.
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PM_CAP_ID_K2_E5                                                      (0xff<<0) // Power Management Capability ID.
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PM_CAP_ID_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PM_NEXT_POINTER_K2_E5                                                (0xff<<8) // Next Capability Pointer.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PM_NEXT_POINTER_K2_E5_SHIFT                                          8
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PM_SPEC_VER_K2_E5                                                    (0x7<<16) // Power Management Spec Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PM_SPEC_VER_K2_E5_SHIFT                                              16
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PME_CLK_K2_E5                                                        (0x1<<19) // PCI Clock Requirement.
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PME_CLK_K2_E5_SHIFT                                                  19
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PME_IMM_READI_RETURN_DO_K2_E5                                        (0x1<<20) // Immediate Readiness on Return to D0.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PME_IMM_READI_RETURN_DO_K2_E5_SHIFT                                  20
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_DSI_K2_E5                                                            (0x1<<21) // Device Specific Initialization Bit.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_DSI_K2_E5_SHIFT                                                      21
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_AUX_CURR_K2_E5                                                       (0x7<<22) // Auxiliary Current Requirements.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_AUX_CURR_K2_E5_SHIFT                                                 22
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_D1_SUPPORT_K2_E5                                                     (0x1<<25) // D1 State Support.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_D1_SUPPORT_K2_E5_SHIFT                                               25
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_D2_SUPPORT_K2_E5                                                     (0x1<<26) // D2 State Support.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_D2_SUPPORT_K2_E5_SHIFT                                               26
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PME_SUPPORT_K2_E5                                                    (0x1f<<27) // Power Management Event Support.   The read value from this field is the write value && {sys_aux_pwr_det, 1'b1, D2_SUPPORT, D1_SUPPORT, 1'b1}, where D1_SUPPORT and D2_SUPPORT are fields in this register.  The reset value PME_SUPPORT_n && {sys_aux_pwr_det, 1'b1, D2_SUPPORT, D1_SUPPORT, 1'b1}, where PME_SUPPORT_n is a configuration parameter.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_ID_NXT_PTR_REG_PME_SUPPORT_K2_E5_SHIFT                                              27
#define PCIEIP_REG_CON_STATUS_REG_K2_E5                                                                      0x000044UL //Access:RW   DataWidth:0x20   // Power Management Control and Status Register.
  #define PCIEIP_REG_CON_STATUS_REG_POWER_STATE_K2_E5                                                        (0x3<<0) // Power State.   You can write to this register. However, the read-back value is the actual power state, not the write value.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_CON_STATUS_REG_POWER_STATE_K2_E5_SHIFT                                                  0
  #define PCIEIP_REG_CON_STATUS_REG_NO_SOFT_RST_K2_E5                                                        (0x1<<3) // No soft Reset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CON_STATUS_REG_NO_SOFT_RST_K2_E5_SHIFT                                                  3
  #define PCIEIP_REG_CON_STATUS_REG_PME_ENABLE_K2_E5                                                         (0x1<<8) // PME Enable.   The PMC registers this value under aux power. Sometimes it might remember the old value, even if you try to clear it by writing '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_CON_STATUS_REG_PME_ENABLE_K2_E5_SHIFT                                                   8
  #define PCIEIP_REG_CON_STATUS_REG_DATA_SELECT_K2_E5                                                        (0xf<<9) // Data Select.
  #define PCIEIP_REG_CON_STATUS_REG_DATA_SELECT_K2_E5_SHIFT                                                  9
  #define PCIEIP_REG_CON_STATUS_REG_DATA_SCALE_K2_E5                                                         (0x3<<13) // Data Scaling Factor.
  #define PCIEIP_REG_CON_STATUS_REG_DATA_SCALE_K2_E5_SHIFT                                                   13
  #define PCIEIP_REG_CON_STATUS_REG_PME_STATUS_K2_E5                                                         (0x1<<15) // PME Status.
  #define PCIEIP_REG_CON_STATUS_REG_PME_STATUS_K2_E5_SHIFT                                                   15
  #define PCIEIP_REG_CON_STATUS_REG_B2_B3_SUPPORT_K2_E5                                                      (0x1<<22) // B2B3 Support for D3hot.
  #define PCIEIP_REG_CON_STATUS_REG_B2_B3_SUPPORT_K2_E5_SHIFT                                                22
  #define PCIEIP_REG_CON_STATUS_REG_BUS_PWR_CLK_CON_EN_K2_E5                                                 (0x1<<23) // Bus Power/Clock Control Enable.
  #define PCIEIP_REG_CON_STATUS_REG_BUS_PWR_CLK_CON_EN_K2_E5_SHIFT                                           23
  #define PCIEIP_REG_CON_STATUS_REG_DATA_REG_ADD_INFO_K2_E5                                                  (0xff<<24) // Power Data Information Register.
  #define PCIEIP_REG_CON_STATUS_REG_DATA_REG_ADD_INFO_K2_E5_SHIFT                                            24
#define PCIEIP_REG_PM_CAP_BB                                                                                 0x000048UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PM_CAP_PM_CAP_ID_BB                                                                     (0xff<<0) // The 8-bit Power Management Capability ID is set to 1 to indicate that the next 8 bytes are a Power Management capability block. Hardwired to 1. Path = cfg_defs
  #define PCIEIP_REG_PM_CAP_PM_CAP_ID_BB_SHIFT                                                               0
  #define PCIEIP_REG_PM_CAP_PM_NEXT_CAP_PTR_BB                                                               (0xff<<8) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. The read-only value of this register is controlled by the CAP_ENA register in the PCI register space. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_PM_CAP_PM_NEXT_CAP_PTR_BB_SHIFT                                                         8
  #define PCIEIP_REG_PM_CAP_VERSION_BB                                                                       (0x3<<16) // These bits indicate that this device complies with revision 1.2 of the PCI Power Management Interface Specification. Bit is programmable through register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_VERSION_BB_SHIFT                                                                 16
  #define PCIEIP_REG_PM_CAP_UNUSED0_BB                                                                       (0x1<<18) // 
  #define PCIEIP_REG_PM_CAP_UNUSED0_BB_SHIFT                                                                 18
  #define PCIEIP_REG_PM_CAP_CLOCK_BB                                                                         (0x1<<19) // This bit indicates that the device relies on the presence of the PCI clock for PME# operation. This chip does not require the PCI clock to generate PME#, therefore this bit is hardwired to '0'. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CAP_CLOCK_BB_SHIFT                                                                   19
  #define PCIEIP_REG_PM_CAP_RESERVED_BB                                                                      (0x1<<20) // Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CAP_RESERVED_BB_SHIFT                                                                20
  #define PCIEIP_REG_PM_CAP_DSI_BB                                                                           (0x1<<21) // This bit indicates that the device requires a specific initialization (DSI) sequence following a transition to the D0 un-initialized state. This device does not need this support, so the bit is hardwired to '0'. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CAP_DSI_BB_SHIFT                                                                     21
  #define PCIEIP_REG_PM_CAP_AUX_CURRENT_BB                                                                   (0x7<<22) // These bits report the 3.3Vaux auxiliary current requirements for the device. This chip uses the Data Register feature for this so this field is hardwired to '0'. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CAP_AUX_CURRENT_BB_SHIFT                                                             22
  #define PCIEIP_REG_PM_CAP_D1_SUPPORT_BB                                                                    (0x1<<25) // This bit indicates whether the device supports the D1 power management state. This bit is controlled by the D1_SUPPORT bit in the PCI register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_D1_SUPPORT_BB_SHIFT                                                              25
  #define PCIEIP_REG_PM_CAP_D2_SUPPORT_BB                                                                    (0x1<<26) // This bit indicates whether the device supports the D2 power management state. This bit is controlled by the D2_SUPPORT bit in the PCI register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_D2_SUPPORT_BB_SHIFT                                                              26
  #define PCIEIP_REG_PM_CAP_PME_IN_D0_BB                                                                     (0x1<<27) // This bit indicates whether the device supports transmiting PME message from the D0 power state. This bit is controlled by the PME_IN_D0 bit in the PCI register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_PME_IN_D0_BB_SHIFT                                                               27
  #define PCIEIP_REG_PM_CAP_PME_IN_D1_BB                                                                     (0x1<<28) // This bit indicates whether the device supports transmiting PME message from the D1 power state. This bit is controlled by the PME_IN_D1 bit in the PCI register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_PME_IN_D1_BB_SHIFT                                                               28
  #define PCIEIP_REG_PM_CAP_PME_IN_D2_BB                                                                     (0x1<<29) // This bit indicates whether the device supports transmiting PME message from the D2 power state. This bit is controlled by the PME_IN_D2 bit in the PCI register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_PME_IN_D2_BB_SHIFT                                                               29
  #define PCIEIP_REG_PM_CAP_PME_IN_D3_HOT_BB                                                                 (0x1<<30) // This bit indicates whether the device supports transmiting PME message from the D3hot power state. This bit is controlled by the PME_IN_D3_HOT bit in the PCI register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CAP_PME_IN_D3_HOT_BB_SHIFT                                                           30
  #define PCIEIP_REG_PM_CAP_PME_IN_D3_COLD_BB                                                                (0x1<<31) // This bit indicates whether the device supports transmiting PME message from the D3cold power state. This is supported if the VAUX_PRESENT input pin is high. This bit reflects the input value of the VAUX_PRESENT input pin. Path = input pins to pcie_vaux
  #define PCIEIP_REG_PM_CAP_PME_IN_D3_COLD_BB_SHIFT                                                          31
#define PCIEIP_REG_PM_CSR_BB                                                                                 0x00004cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PM_CSR_STATE_BB                                                                         (0x3<<0) // These bits may be used by the system to set the power state. The register is implemented as two banks of two bits each. Can be written from both configuration space and from the PCI register space as the PM_STATE bits. When written from the PCI bus, only values of 0 and 3 will be accepted. This is the register returned on reads of this register from configuration space. The second bank catches all writes values. The value of the second register is returned when the PM_STATE bits are read from register space. The idea of these registers is to a) Provide compatible operation to 5701 b) Allow implementation of other power states though firmware. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CSR_STATE_BB_SHIFT                                                                   0
  #define PCIEIP_REG_PM_CSR_RESERVED0_BB                                                                     (0x1<<2) // Reserved Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CSR_RESERVED0_BB_SHIFT                                                               2
  #define PCIEIP_REG_PM_CSR_NO_SOFT_RESET_BB                                                                 (0x1<<3) // When device transitions from D3 to D0, device does not perform an internal reset. This bit can be programmed through reg space Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CSR_NO_SOFT_RESET_BB_SHIFT                                                           3
  #define PCIEIP_REG_PM_CSR_RESERVED1_BB                                                                     (0xf<<4) // Reserved Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CSR_RESERVED1_BB_SHIFT                                                               4
  #define PCIEIP_REG_PM_CSR_PME_ENABLE_BB                                                                    (0x1<<8) // This bit enables the device to transmit PME messages. On HARD reset, this bit resets to '1'. this bit is sticky and is not modified by PERST_B. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CSR_PME_ENABLE_BB_SHIFT                                                              8
  #define PCIEIP_REG_PM_CSR_DATA_SEL_BB                                                                      (0xf<<9) // These bits select which data is to be reported through the pm_data register. (Offset 0x4f) Select values other than those listed cause the pm_data register to return zero. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CSR_DATA_SEL_BB_SHIFT                                                                9
  #define PCIEIP_REG_PM_CSR_DATA_SCALE_BB                                                                    (0x3<<13) // These bits indicate the scaling factor to be used when interpreting the values in the PM data register. The hardware default value for this field is 0x1, but this value can be written by firmware through the PCI register space (SCALE_PRG) to modify the read value to the host. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PM_CSR_DATA_SCALE_BB_SHIFT                                                              13
  #define PCIEIP_REG_PM_CSR_PME_STATUS_BB                                                                    (0x1<<15) // This bit is set when a PME is asserted from the MAC or RX Parser blocks, regardless of the state of the PME_ENABLE bit. If both this bit and the PME_ENABLE bit are high, then the PME output will be asserted low. This bit is cleared by writing a 1 in this bit position. At power-up, the chip must clear this bit, but on assertions of PCI_RST# after that, this bit is sticky and not modified. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap
  #define PCIEIP_REG_PM_CSR_PME_STATUS_BB_SHIFT                                                              15
  #define PCIEIP_REG_PM_CSR_PM_CSR_BSE_BB                                                                    (0xff<<16) // This register (PMCSR PCI to PCI Bridge Support Extensions) is not supported and always reads as zero. Path = i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_PM_CSR_PM_CSR_BSE_BB_SHIFT                                                              16
  #define PCIEIP_REG_PM_CSR_PM_DATA_BB                                                                       (0xff<<24) // The value for this register is selected from one of eight values by the DATA_SEL bits of the PM_CSR register. The reset value of all 9 of the register values is zero. These values can be written by firmware through the PCI register space (PM_Data_0_prg to PM_Data_8_prg) to modify the read values to the host. Path = i_cfg_func.i_cfg_public.i_cfg_pw_cap (for pm_data_select) Path = i_cfg_func.i_cfg_private (pm_data)
  #define PCIEIP_REG_PM_CSR_PM_DATA_BB_SHIFT                                                                 24
#define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_K2_E5                                                        0x000050UL //Access:RW   DataWidth:0x20   // MSI Capability ID, Next Pointer, Capability/Control Registers.
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_CAP_ID_K2_E5                                       (0xff<<0) // MSI Capability ID.
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_CAP_ID_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_CAP_NEXT_OFFSET_K2_E5                              (0xff<<8) // MSI Capability Next Pointer.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_CAP_NEXT_OFFSET_K2_E5_SHIFT                        8
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_ENABLE_K2_E5                                       (0x1<<16) // MSI Enable.
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_ENABLE_K2_E5_SHIFT                                 16
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_MULTIPLE_MSG_CAP_K2_E5                             (0x7<<17) // MSI Multiple Message Capable.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_MULTIPLE_MSG_CAP_K2_E5_SHIFT                       17
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_MULTIPLE_MSG_EN_K2_E5                              (0x7<<20) // MSI Multiple Message Enable.
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_MULTIPLE_MSG_EN_K2_E5_SHIFT                        20
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_64_BIT_ADDR_CAP_K2_E5                              (0x1<<23) // MSI 64-bit Address Capable.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_MSI_64_BIT_ADDR_CAP_K2_E5_SHIFT                        23
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_PVM_SUPPORT_K2_E5                                      (0x1<<24) // MSI Per Vector Masking Capable.
  #define PCIEIP_REG_PCI_MSI_CAP_ID_NEXT_CTRL_REG_PCI_PVM_SUPPORT_K2_E5_SHIFT                                24
#define PCIEIP_REG_VPD_CAP_BB                                                                                0x000050UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_VPD_CAP_VPD_CAP_ID_BB                                                                   (0xff<<0) // The 8-bit VPD Capability ID is set to 3 to indicate that the next 8 bytes are a Vital Product Data capability block. Path = cfg_defs
  #define PCIEIP_REG_VPD_CAP_VPD_CAP_ID_BB_SHIFT                                                             0
  #define PCIEIP_REG_VPD_CAP_VPD_NEXT_CAP_PTR_BB                                                             (0xff<<8) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. The read-only value of this register is controlled by the CAP_ENA register in the PCI register space. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_VPD_CAP_VPD_NEXT_CAP_PTR_BB_SHIFT                                                       8
  #define PCIEIP_REG_VPD_CAP_UNUSED0_BB                                                                      (0x3<<16) // 
  #define PCIEIP_REG_VPD_CAP_UNUSED0_BB_SHIFT                                                                16
  #define PCIEIP_REG_VPD_CAP_ADDRESS_BB                                                                      (0x1fff<<18) // This value is the 32-bit word address of the VPD value being accessed in the vpd_data register. Since the data register is 32-bits wide. Path = i_cfg_func.i_cfg_public.i_cfg_vpd_cap
  #define PCIEIP_REG_VPD_CAP_ADDRESS_BB_SHIFT                                                                18
  #define PCIEIP_REG_VPD_CAP_FLAG_BB                                                                         (0x1<<31) // This bit is used to control passing of data between the vpd_data register and Non-Volatile memory. To read a value, this bit is written as zero when the address is written. When the data is available to read, this bit will read as a one. To write data, this bit must written as a one when the address is written. When the bit reads as a zero the write has completed. Path = i_cfg_func.i_cfg_public.i_cfg_vpd_cap
  #define PCIEIP_REG_VPD_CAP_FLAG_BB_SHIFT                                                                   31
#define PCIEIP_REG_MSI_CAP_OFF_04H_REG_K2_E5                                                                 0x000054UL //Access:RW   DataWidth:0x20   // MSI Message Lower Address Register.
  #define PCIEIP_REG_MSI_CAP_OFF_04H_REG_PCI_MSI_CAP_OFF_04H_K2_E5                                           (0x3fffffff<<2) // MSI Message Lower Address Field.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_MSI_CAP_OFF_04H_REG_PCI_MSI_CAP_OFF_04H_K2_E5_SHIFT                                     2
#define PCIEIP_REG_VPD_DATA_BB                                                                               0x000054UL //Access:RW   DataWidth:0x20   // This is the VPD data transfer register. See the instructions for the FLAG bit above for usage of this register. Path = i_cfg_func.i_cfg_public.i_cfg_vpd_cap
#define PCIEIP_REG_MSI_CAP_OFF_08H_REG_K2_E5                                                                 0x000058UL //Access:RW   DataWidth:0x20   // For a 32 bit MSI Message, this register contains Data. For 64 bit it contains the Upper Address.
  #define PCIEIP_REG_MSI_CAP_OFF_08H_REG_PCI_MSI_CAP_OFF_08H_K2_E5                                           (0xffff<<0) // For a 32-bit MSI Message, this field contains Data. For 64-bit it contains lower 16 bits of the Upper Address.   Note: The access attributes of this field are as follows:  - Dbi: PCI_MSI_64_BIT_ADDR_CAP ? R/W : R
  #define PCIEIP_REG_MSI_CAP_OFF_08H_REG_PCI_MSI_CAP_OFF_08H_K2_E5_SHIFT                                     0
  #define PCIEIP_REG_MSI_CAP_OFF_08H_REG_PCI_MSI_CAP_OFF_0AH_K2_E5                                           (0xffff<<16) // For a 32 bit MSI Message, this is reserved. For 64-bit it contains upper 16 bits of the Upper Address.  Note: The access attributes of this field are as follows:  - Dbi: PCI_MSI_64_BIT_ADDR_CAP ? R/W : R
  #define PCIEIP_REG_MSI_CAP_OFF_08H_REG_PCI_MSI_CAP_OFF_0AH_K2_E5_SHIFT                                     16
#define PCIEIP_REG_MSI_CAP_BB                                                                                0x000058UL //Access:RW   DataWidth:0x20   // The device driver is prohibited from writing to this register.
  #define PCIEIP_REG_MSI_CAP_MSI_CAP_ID_BB                                                                   (0xff<<0) // The 8-bit MSI Capability ID is set to 5 to indicate that the next 8 bytes are a Message Signaled Interrupt capability block. Path = cfg_defs
  #define PCIEIP_REG_MSI_CAP_MSI_CAP_ID_BB_SHIFT                                                             0
  #define PCIEIP_REG_MSI_CAP_MSI_NEXT_CAP_PTR_BB                                                             (0xff<<8) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. The read-only value of this register is controlled by the CAP_ENA register in the PCI register space. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_MSI_CAP_MSI_NEXT_CAP_PTR_BB_SHIFT                                                       8
  #define PCIEIP_REG_MSI_CAP_MSI_ENABLE_BB                                                                   (0x1<<16) // When this bit is set, the chip will generate MSI cycles to indicate interrupts instead of asserting the INTA# pin. When this bit is zero, the INTA# pin will be used. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSI_CAP_MSI_ENABLE_BB_SHIFT                                                             16
  #define PCIEIP_REG_MSI_CAP_MULTI_MSG_CAP_BB                                                                (0x7<<17) // These bits indicate the number of messages that the chip is capable of generating. This value comes from the Path = i_cfg_func.i_cfg_private MULTI_MSG_CAP bit in the register space.
  #define PCIEIP_REG_MSI_CAP_MULTI_MSG_CAP_BB_SHIFT                                                          17
  #define PCIEIP_REG_MSI_CAP_MULTI_MSG_EN_BB                                                                 (0x7<<20) // These bits indicate the number of message that the chip is configured (allowed) to generate. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSI_CAP_MULTI_MSG_EN_BB_SHIFT                                                           20
  #define PCIEIP_REG_MSI_CAP_CAP_64BIT_BB                                                                    (0x1<<23) // This bit indicates that the chip is capable of generating 64 bit MSI messages. Path = cfg_defs
  #define PCIEIP_REG_MSI_CAP_CAP_64BIT_BB_SHIFT                                                              23
  #define PCIEIP_REG_MSI_CAP_MSI_PVMASK_CAPABLE_BB                                                           (0x1<<24) // This bit indicates if the function supports per vector masking. This value comes from the MSI_PV_MASK_CAP bit in the register space. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSI_CAP_MSI_PVMASK_CAPABLE_BB_SHIFT                                                     24
#define PCIEIP_REG_MSI_CAP_OFF_0CH_REG_K2_E5                                                                 0x00005cUL //Access:RW   DataWidth:0x20   // For a 64 bit MSI Message, this register contains Data. For 32 bit, it contains Mask Bits if PVM enabled.
  #define PCIEIP_REG_MSI_CAP_OFF_0CH_REG_PCI_MSI_CAP_OFF_0CH_K2_E5                                           (0xffff<<0) // For a 64-bit MSI Message, this field contains Data. For 32-bit, it contains the lower Mask Bits if PVM is enabled.  Note: The access attributes of this field are as follows:  - Dbi: PCI_MSI_64_BIT_ADDR_CAP || MSI_PVM_EN ? R/W : R
  #define PCIEIP_REG_MSI_CAP_OFF_0CH_REG_PCI_MSI_CAP_OFF_0CH_K2_E5_SHIFT                                     0
  #define PCIEIP_REG_MSI_CAP_OFF_0CH_REG_PCI_MSI_CAP_OFF_0EH_K2_E5                                           (0xffff<<16) // For a 64-bit MSI Message, this field contains Data. For 32-bit, it contains the upper Mask Bits if PVM is enabled.  Note: The access attributes of this field are as follows:  - Dbi: !PCI_MSI_64_BIT_ADDR_CAP && MSI_PVM_EN ? R/W : R
  #define PCIEIP_REG_MSI_CAP_OFF_0CH_REG_PCI_MSI_CAP_OFF_0EH_K2_E5_SHIFT                                     16
#define PCIEIP_REG_MSI_ADDR_L_BB                                                                             0x00005cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_MSI_ADDR_L_UNUSED0_BB                                                                   (0x3<<0) // 
  #define PCIEIP_REG_MSI_ADDR_L_UNUSED0_BB_SHIFT                                                             0
  #define PCIEIP_REG_MSI_ADDR_L_VAL_BB                                                                       (0x3fffffff<<2) // This register controls the lower half of the address of the MSI message that are generated. This register is readable in the pci register space. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSI_ADDR_L_VAL_BB_SHIFT                                                                 2
#define PCIEIP_REG_MSI_CAP_OFF_10H_REG_K2_E5                                                                 0x000060UL //Access:RW   DataWidth:0x20   // Used for MSI when Vector Masking Capable. For 32 bit contains Pending Bits. For 64 bit, contains Mask Bits.
#define PCIEIP_REG_MSI_ADDR_H_BB                                                                             0x000060UL //Access:RW   DataWidth:0x20   // This register controls the upper half of the address of the MSI message that are generated. This register is readable in the pci register space. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
#define PCIEIP_REG_MSI_CAP_OFF_14H_REG_K2_E5                                                                 0x000064UL //Access:R    DataWidth:0x20   // Used for MSI 64 bit messaging when Vector Masking Capable. Contains Pending Bits.
#define PCIEIP_REG_MSI_DATA_BB                                                                               0x000064UL //Access:RW   DataWidth:0x20   // This register controls the data value that will be presented on the lower 16 bits of the data bus during MSI messages. The MENA value from the MSI Control register allows a specific number of the lower bits (up to 6) to be modified to indicate different interrupt conditions. This register is readable in the pci register space. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSI_DATA_MSI_DATA_BB                                                                    (0xffff<<0) // 
  #define PCIEIP_REG_MSI_DATA_MSI_DATA_BB_SHIFT                                                              0
#define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_K2_E5                                          0x000070UL //Access:RW   DataWidth:0x20   // PCI Express Capabilities, ID, Next Pointer Register.
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_CAP_ID_K2_E5                            (0xff<<0) // PCIE Capability ID.
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_CAP_ID_K2_E5_SHIFT                      0
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_CAP_NEXT_PTR_K2_E5                      (0xff<<8) // PCIE Next Capability Pointer.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_CAP_NEXT_PTR_K2_E5_SHIFT                8
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_CAP_REG_K2_E5                           (0xf<<16) // PCIE Capability Version Number.
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_CAP_REG_K2_E5_SHIFT                     16
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_DEV_PORT_TYPE_K2_E5                     (0xf<<20) // PCIE Device/PortType.
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_DEV_PORT_TYPE_K2_E5_SHIFT               20
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_SLOT_IMP_K2_E5                          (0x1<<24) // PCIe Slot Implemented Valid.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_SLOT_IMP_K2_E5_SHIFT                    24
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_INT_MSG_NUM_K2_E5                       (0x1f<<25) // PCIE Interrupt Message Number.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_PCIE_INT_MSG_NUM_K2_E5_SHIFT                 25
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_RSVD_K2_E5                                   (0x1<<30) // Reserved.
  #define PCIEIP_REG_PCIE_CAP_ID_PCIE_NEXT_CAP_PTR_PCIE_CAP_REG_RSVD_K2_E5_SHIFT                             30
#define PCIEIP_REG_DEVICE_CAPABILITIES_REG_K2_E5                                                             0x000074UL //Access:RW   DataWidth:0x20   // Device Capabilities Register.
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_MAX_PAYLOAD_SIZE_K2_E5                                 (0x7<<0) // Max Payload Size Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_MAX_PAYLOAD_SIZE_K2_E5_SHIFT                           0
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_PHANTOM_FUNC_SUPPORT_K2_E5                             (0x3<<3) // Phantom Functions Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_PHANTOM_FUNC_SUPPORT_K2_E5_SHIFT                       3
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_EXT_TAG_SUPP_K2_E5                                     (0x1<<5) // Extended Tag Field Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_EXT_TAG_SUPP_K2_E5_SHIFT                               5
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_EP_L0S_ACCPT_LATENCY_K2_E5                             (0x7<<6) // Applies to endpoints only L0s acceptable latency.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_EP_L0S_ACCPT_LATENCY_K2_E5_SHIFT                       6
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_EP_L1_ACCPT_LATENCY_K2_E5                              (0x7<<9) // Applies to endpoints only L1 acceptable latency.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_EP_L1_ACCPT_LATENCY_K2_E5_SHIFT                        9
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_ROLE_BASED_ERR_REPORT_K2_E5                            (0x1<<15) // Role-based Error Reporting Implemented.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_ROLE_BASED_ERR_REPORT_K2_E5_SHIFT                      15
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_CAP_SLOT_PWR_LMT_VALUE_K2_E5                           (0xff<<18) // Captured Slot Power Limit Value.
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_CAP_SLOT_PWR_LMT_VALUE_K2_E5_SHIFT                     18
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_CAP_SLOT_PWR_LMT_SCALE_K2_E5                           (0x3<<26) // Captured Slot Power Limit Scale.
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_CAP_SLOT_PWR_LMT_SCALE_K2_E5_SHIFT                     26
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_FLR_CAP_K2_E5                                          (0x1<<28) // Function Level Reset Capability (endpoints only).   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_DEVICE_CAPABILITIES_REG_PCIE_CAP_FLR_CAP_K2_E5_SHIFT                                    28
#define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_K2_E5                                                        0x000078UL //Access:RW   DataWidth:0x20   // Device Control and Status Register.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_CORR_ERR_REPORT_EN_K2_E5                          (0x1<<0) // Correctable Error Reporting Enable.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_CORR_ERR_REPORT_EN_K2_E5_SHIFT                    0
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_NON_FATAL_ERR_REPORT_EN_K2_E5                     (0x1<<1) // Non-fatal Error Reporting Enable.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_NON_FATAL_ERR_REPORT_EN_K2_E5_SHIFT               1
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_FATAL_ERR_REPORT_EN_K2_E5                         (0x1<<2) // Fatal Error Reporting Enable.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_FATAL_ERR_REPORT_EN_K2_E5_SHIFT                   2
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_UNSUPPORT_REQ_REP_EN_K2_E5                        (0x1<<3) // Unsupported Request Reporting Enable.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_UNSUPPORT_REQ_REP_EN_K2_E5_SHIFT                  3
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_EN_REL_ORDER_K2_E5                                (0x1<<4) // Enable Relaxed Ordering.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_EN_REL_ORDER_K2_E5_SHIFT                          4
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_K2_E5                         (0x7<<5) // Max Payload Size. Max_Payload_Size . This field sets maximum TLP payload size for the Function. Permissible values that can be programmed are indicated by the Max_Payload_Size Supported field (PCIE_CAP_MAX_PAYLOAD_SIZE) in the Device Capabilities register (DEVICE_CAPABILITIES_REG).
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_MAX_PAYLOAD_SIZE_CS_K2_E5_SHIFT                   5
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_EXT_TAG_EN_K2_E5                                  (0x1<<8) // Extended Tag Field Enable.   The write value is gated with the PCIE_CAP_EXT_TAG_SUPP field of DEVICE_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: DEVICE_CAPABILITIES_REG.PCIE_CAP_EXT_TAG_SUPP ? RW : RO
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_EXT_TAG_EN_K2_E5_SHIFT                            8
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_PHANTOM_FUNC_EN_K2_E5                             (0x1<<9) // Phantom Functions Enable.   The write value is gated with the PCIE_CAP_PHANTOM_FUNC_SUPPORT field of DEVICE_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: DEVICE_CAPABILITIES_REG.PCIE_CAP_PHANTOM_FUNC_SUPPORT ? RW : RO
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_PHANTOM_FUNC_EN_K2_E5_SHIFT                       9
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_AUX_POWER_PM_EN_K2_E5                             (0x1<<10) // Aux Power PM Enable.   This bit is derived by sampling the sys_aux_pwr_det input.  Note: This register field is sticky.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_AUX_POWER_PM_EN_K2_E5_SHIFT                       10
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_EN_NO_SNOOP_K2_E5                                 (0x1<<11) // Enable No Snoop.   Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_EN_NO_SNOOP_K2_E5_SHIFT                           11
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_MAX_READ_REQ_SIZE_K2_E5                           (0x7<<12) // Max Read Request Size.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_MAX_READ_REQ_SIZE_K2_E5_SHIFT                     12
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_INITIATE_FLR_K2_E5                                (0x1<<15) // Initiate Function Level Reset (for endpoints).
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_INITIATE_FLR_K2_E5_SHIFT                          15
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_CORR_ERR_DETECTED_K2_E5                           (0x1<<16) // Correctable Error Detected Status.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_CORR_ERR_DETECTED_K2_E5_SHIFT                     16
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_NON_FATAL_ERR_DETECTED_K2_E5                      (0x1<<17) // Non-Fatal Error Detected Status.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_NON_FATAL_ERR_DETECTED_K2_E5_SHIFT                17
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_FATAL_ERR_DETECTED_K2_E5                          (0x1<<18) // Fatal Error Detected Status.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_FATAL_ERR_DETECTED_K2_E5_SHIFT                    18
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_UNSUPPORTED_REQ_DETECTED_K2_E5                    (0x1<<19) // Unsupported Request Detected Status.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_UNSUPPORTED_REQ_DETECTED_K2_E5_SHIFT              19
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_AUX_POWER_DETECTED_K2_E5                          (0x1<<20) // Aux Power Detected Status.   This bit is derived by sampling the sys_aux_pwr_det input.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_AUX_POWER_DETECTED_K2_E5_SHIFT                    20
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_TRANS_PENDING_K2_E5                               (0x1<<21) // Transactions Pending Status.
  #define PCIEIP_REG_DEVICE_CONTROL_DEVICE_STATUS_PCIE_CAP_TRANS_PENDING_K2_E5_SHIFT                         21
#define PCIEIP_REG_LINK_CAPABILITIES_REG_K2_E5                                                               0x00007cUL //Access:RW   DataWidth:0x20   // Link Capabilities Register.
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_MAX_LINK_SPEED_K2_E5                                     (0xf<<0) // Maximum Link Speed.   In M-PCIe mode, the reset and dynamic values of this field are calculated by the core.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_MAX_LINK_SPEED_K2_E5_SHIFT                               0
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_MAX_LINK_WIDTH_K2_E5                                     (0x3f<<4) // Maximum Link Width.   In M-PCIe mode, the reset and dynamic values of this field are calculated by the core.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_MAX_LINK_WIDTH_K2_E5_SHIFT                               4
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_ACTIVE_STATE_LINK_PM_SUPPORT_K2_E5                       (0x3<<10) // Level of ASPM (Active State Power Management) Support.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_ACTIVE_STATE_LINK_PM_SUPPORT_K2_E5_SHIFT                 10
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_L0S_EXIT_LATENCY_K2_E5                                   (0x7<<12) // LOs Exit Latency.  There are two each of these register fields, this one and a shadow one at the same address. The Common Clock bit (PCIE_CAP_COMMON_CLK_CONFIG) of the Link Control Register (LINK_CONTROL_LINK_STATUS_REG) determines which one is used by the core and which one is accessed by a read request. Common Clock operation is supported (possible) in the core when one or more of the following expressions is true:  - CX_NFTS !=CX_COMM_NFTS  - DEFAULT_L0S_EXIT_LATENCY !=DEFAULT_COMM_L0S_EXIT_LATENCY  - DEFAULT_L1_EXIT_LATENCY !=DEFAULT_COMM_L1_EXIT_LATENCY Common Clock operation is enabled in the core when you set the Common Clock bit (PCIE_CAP_COMMON_CLK_CONFIG) of the Link Control Register (LINK_CONTROL_LINK_STATUS_REG). The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the shadow field at this location.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_L0S_EXIT_LATENCY_K2_E5_SHIFT                             12
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_L1_EXIT_LATENCY_K2_E5                                    (0x7<<15) // L1 Exit Latency.  There are two each of these register fields, this one and a shadow one at the same address. The Common Clock bit (PCIE_CAP_COMMON_CLK_CONFIG) of the Link Control Register (LINK_CONTROL_LINK_STATUS_REG) determines which one is used by the core and which one is accessed by a read request. Common Clock operation is supported (possible) in the core when one or more of the following expressions is true:  - CX_NFTS !=CX_COMM_NFTS  - DEFAULT_L0S_EXIT_LATENCY !=DEFAULT_COMM_L0S_EXIT_LATENCY  - DEFAULT_L1_EXIT_LATENCY !=DEFAULT_COMM_L1_EXIT_LATENCY Common Clock operation is enabled in the core when you set the Common Clock bit (PCIE_CAP_COMMON_CLK_CONFIG) of the Link Control Register (LINK_CONTROL_LINK_STATUS_REG). The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the shadow field at this location.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_L1_EXIT_LATENCY_K2_E5_SHIFT                              15
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_CLOCK_POWER_MAN_K2_E5                                    (0x1<<18) // Clock Power Management.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_CLOCK_POWER_MAN_K2_E5_SHIFT                              18
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_SURPRISE_DOWN_ERR_REP_CAP_K2_E5                          (0x1<<19) // Surprise Down Error Reporting Capable.
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_SURPRISE_DOWN_ERR_REP_CAP_K2_E5_SHIFT                    19
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_DLL_ACTIVE_REP_CAP_K2_E5                                 (0x1<<20) // Data Link Layer Link Active Reporting Capable.
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_DLL_ACTIVE_REP_CAP_K2_E5_SHIFT                           20
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_LINK_BW_NOT_CAP_K2_E5                                    (0x1<<21) // Link Bandwidth Notification Capable.
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_LINK_BW_NOT_CAP_K2_E5_SHIFT                              21
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_ASPM_OPT_COMPLIANCE_K2_E5                                (0x1<<22) // ASPM Optionality Compliance.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_ASPM_OPT_COMPLIANCE_K2_E5_SHIFT                          22
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_PORT_NUM_K2_E5                                           (0xff<<24) // Port Number.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES_REG_PCIE_CAP_PORT_NUM_K2_E5_SHIFT                                     24
#define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_K2_E5                                                        0x000080UL //Access:RW   DataWidth:0x20   // Link Control and Status Register.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_K2_E5                (0x3<<0) // Active State Power Management (ASPM) Control.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_ACTIVE_STATE_LINK_PM_CONTROL_K2_E5_SHIFT          0
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_RCB_K2_E5                                         (0x1<<3) // Read Completion Boundary (RCB).  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_RCB_K2_E5_SHIFT                                   3
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_DISABLE_K2_E5                                (0x1<<4) // Initiate Link Disable.   In a DSP that supports crosslink, the core gates the write value with the CROSS_LINK_EN field in PORT_LINK_CTRL_OFF.  Note: The access attributes of this field are as follows:  - Dbi: CX_CROSSLINK_ENABLE=1 && PORT_LINK_CTRL_OFF.CROSS_LINK_EN=1||CX_CROSSLINK_ENABLE=0 && dsp=1? RW : RO
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_DISABLE_K2_E5_SHIFT                          4
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_RETRAIN_LINK_K2_E5                                (0x1<<5) // Initiate Link Retrain.   Note: The access attributes of this field are as follows:  - Dbi: see description
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_RETRAIN_LINK_K2_E5_SHIFT                          5
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_COMMON_CLK_CONFIG_K2_E5                           (0x1<<6) // Common Clock Configuration.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_COMMON_CLK_CONFIG_K2_E5_SHIFT                     6
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_EXTENDED_SYNCH_K2_E5                              (0x1<<7) // Extended Synch.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_EXTENDED_SYNCH_K2_E5_SHIFT                        7
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_EN_CLK_POWER_MAN_K2_E5                            (0x1<<8) // Enable Clock Power Management.   The write value is gated with the PCIE_CAP_CLOCK_POWER_MAN field in LINK_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: LINK_CAPABILITIES_REG.PCIE_CAP_CLOCK_POWER_MAN ? RW : RO
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_EN_CLK_POWER_MAN_K2_E5_SHIFT                      8
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_HW_AUTO_WIDTH_DISABLE_K2_E5                       (0x1<<9) // Hardware Autonomous Width Disable.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_HW_AUTO_WIDTH_DISABLE_K2_E5_SHIFT                 9
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_BW_MAN_INT_EN_K2_E5                          (0x1<<10) // Link Bandwidth Management Interrupt Enable.   The write value is gated with the PCIE_CAP_LINK_BW_NOT_CAP field in LINK_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: LINK_CAPABILITIES_REG.PCIE_CAP_LINK_BW_NOT_CAP ? RW : RO
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_BW_MAN_INT_EN_K2_E5_SHIFT                    10
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_AUTO_BW_INT_EN_K2_E5                         (0x1<<11) // Link Autonomous Bandwidth Management Interrupt Enable.   The write value is gated with the PCIE_CAP_LINK_BW_NOT_CAP field in LINK_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: LINK_CAPABILITIES_REG.PCIE_CAP_LINK_BW_NOT_CAP ? RW : RO
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_AUTO_BW_INT_EN_K2_E5_SHIFT                   11
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_DRS_SIGNALING_CONTROL_K2_E5                       (0x3<<14) // DRS Signaling Control.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_DRS_SIGNALING_CONTROL_K2_E5_SHIFT                 14
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_SPEED_K2_E5                                  (0xf<<16) // Current Link Speed.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_SPEED_K2_E5_SHIFT                            16
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_NEGO_LINK_WIDTH_K2_E5                             (0x3f<<20) // Negotiated Link Width.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_NEGO_LINK_WIDTH_K2_E5_SHIFT                       20
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_TRAINING_K2_E5                               (0x1<<27) // LTSSM is in Configuration or Recovery State.   Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_TRAINING_K2_E5_SHIFT                         27
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_SLOT_CLK_CONFIG_K2_E5                             (0x1<<28) // Slot Clock Configuration.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_SLOT_CLK_CONFIG_K2_E5_SHIFT                       28
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_DLL_ACTIVE_K2_E5                                  (0x1<<29) // Data Link Layer Active.
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_DLL_ACTIVE_K2_E5_SHIFT                            29
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_BW_MAN_STATUS_K2_E5                          (0x1<<30) // Link Bandwidth Management Status.   The write value is gated with the PCIE_CAP_LINK_BW_NOT_CAP field in LINK_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: LINK_CAPABILITIES_REG.PCIE_CAP_LINK_BW_NOT_CAP ? RW1C : RO
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_BW_MAN_STATUS_K2_E5_SHIFT                    30
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_AUTO_BW_STATUS_K2_E5                         (0x1<<31) // Link Autonomous Bandwidth Status.   The write value is gated with the PCIE_CAP_LINK_BW_NOT_CAP field in LINK_CAPABILITIES_REG.  Note: The access attributes of this field are as follows:  - Dbi: LINK_CAPABILITIES_REG.PCIE_CAP_LINK_BW_NOT_CAP ? RW1C : RO
  #define PCIEIP_REG_LINK_CONTROL_LINK_STATUS_REG_PCIE_CAP_LINK_AUTO_BW_STATUS_K2_E5_SHIFT                   31
#define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_K2_E5                                                            0x000094UL //Access:R    DataWidth:0x20   // Device Capabilities 2 Register.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_CPL_TIMEOUT_RANGE_K2_E5                               (0xf<<0) // Completion Timeout Ranges Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_CPL_TIMEOUT_RANGE_K2_E5_SHIFT                         0
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_CPL_TIMEOUT_DISABLE_SUPPORT_K2_E5                     (0x1<<4) // Completion Timeout Disable Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_CPL_TIMEOUT_DISABLE_SUPPORT_K2_E5_SHIFT               4
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_ARI_FORWARD_SUPPORT_K2_E5                             (0x1<<5) // ARI Forwarding Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_ARI_FORWARD_SUPPORT_K2_E5_SHIFT                       5
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_ATOMIC_ROUTING_SUPP_K2_E5                             (0x1<<6) // Atomic Operation Routing Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_ATOMIC_ROUTING_SUPP_K2_E5_SHIFT                       6
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_32_ATOMIC_CPL_SUPP_K2_E5                              (0x1<<7) // 32 Bit AtomicOp Completer Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_32_ATOMIC_CPL_SUPP_K2_E5_SHIFT                        7
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_64_ATOMIC_CPL_SUPP_K2_E5                              (0x1<<8) // 64 Bit AtomicOp Completer Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_64_ATOMIC_CPL_SUPP_K2_E5_SHIFT                        8
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_128_CAS_CPL_SUPP_K2_E5                                (0x1<<9) // 128 Bit CAS Completer Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_128_CAS_CPL_SUPP_K2_E5_SHIFT                          9
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_NO_RO_EN_PR2PR_PAR_K2_E5                              (0x1<<10) // No Relaxed Ordering Enabled PR-PR Passing.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_NO_RO_EN_PR2PR_PAR_K2_E5_SHIFT                        10
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_LTR_SUPP_K2_E5                                        (0x1<<11) // LTR Mechanism Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_LTR_SUPP_K2_E5_SHIFT                                  11
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_TPH_CMPLT_SUPPORT_0_K2_E5                             (0x1<<12) // TPH Completer Supported Bit 0.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_TPH_CMPLT_SUPPORT_0_K2_E5_SHIFT                       12
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_TPH_CMPLT_SUPPORT_1_K2_E5                             (0x1<<13) // TPH Completer Supported Bit 1.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_TPH_CMPLT_SUPPORT_1_K2_E5_SHIFT                       13
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_OBFF_SUPPORT_K2_E5                                    (0x3<<18) // (OBFF) Optimized Buffer Flush/fill Supported.
  #define PCIEIP_REG_DEVICE_CAPABILITIES2_REG_PCIE_CAP_OBFF_SUPPORT_K2_E5_SHIFT                              18
#define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_K2_E5                                                  0x000098UL //Access:RW   DataWidth:0x20   // Device Control 2 and Status 2 Register.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_CPL_TIMEOUT_VALUE_K2_E5                     (0xf<<0) // Completion Timeout Value.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_CPL_TIMEOUT_VALUE_K2_E5_SHIFT               0
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_CPL_TIMEOUT_DISABLE_K2_E5                   (0x1<<4) // Completion Timeout Disable.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_CPL_TIMEOUT_DISABLE_K2_E5_SHIFT             4
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_ARI_FORWARD_SUPPORT_CS_K2_E5                (0x1<<5) // ARI Forwarding Enable.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_ARI_FORWARD_SUPPORT_CS_K2_E5_SHIFT          5
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_ATOMIC_REQ_EN_K2_E5                         (0x1<<6) // AtomicOp Requester Enable.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_ATOMIC_REQ_EN_K2_E5_SHIFT                   6
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_ATOMIC_EGRESS_BLK_K2_E5                     (0x1<<7) // AtomicOp Egress Blocking.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_ATOMIC_EGRESS_BLK_K2_E5_SHIFT               7
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_IDO_REQ_EN_K2_E5                            (0x1<<8) // IDO Request Enable.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_IDO_REQ_EN_K2_E5_SHIFT                      8
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_IDO_CPL_EN_K2_E5                            (0x1<<9) // IDO Completion Enable.
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_IDO_CPL_EN_K2_E5_SHIFT                      9
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_LTR_EN_K2_E5                                (0x1<<10) // LTR Mechanism Enable.   The write value is gated with the PCIE_CAP_LTR_SUPP field of DEVICE_CAPABILITIES2_REG.  Note: RW for function #0 and RsdvP for all other functions
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_LTR_EN_K2_E5_SHIFT                          10
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_OBFF_EN_K2_E5                               (0x3<<13) // OBFF Enable.   Note: RW for function #0 and RsdvP for all other functions
  #define PCIEIP_REG_DEVICE_CONTROL2_DEVICE_STATUS2_REG_PCIE_CAP_OBFF_EN_K2_E5_SHIFT                         13
#define PCIEIP_REG_LINK_CAPABILITIES2_REG_K2_E5                                                              0x00009cUL //Access:RW   DataWidth:0x20   // Link Capabilities 2 Register.
  #define PCIEIP_REG_LINK_CAPABILITIES2_REG_PCIE_CAP_SUPPORT_LINK_SPEED_VECTOR_K2_E5                         (0x7f<<1) // Supported Link Speeds Vector.   This field has a default of (PCIE_CAP_MAX_LINK_SPEED == 0100) ? 0001111 : (PCIE_CAP_MAX_LINK_SPEED == 0011) ? 0000111 : (PCIE_CAP_MAX_LINK_SPEED == 0010) ? 0000011 : 0000001 where PCIE_CAP_MAX_LINK_SPEED is a field in the LINK_CAPABILITIES_REG register.
  #define PCIEIP_REG_LINK_CAPABILITIES2_REG_PCIE_CAP_SUPPORT_LINK_SPEED_VECTOR_K2_E5_SHIFT                   1
  #define PCIEIP_REG_LINK_CAPABILITIES2_REG_PCIE_CAP_CROSS_LINK_SUPPORT_K2_E5                                (0x1<<8) // Cross Link Supported.
  #define PCIEIP_REG_LINK_CAPABILITIES2_REG_PCIE_CAP_CROSS_LINK_SUPPORT_K2_E5_SHIFT                          8
  #define PCIEIP_REG_LINK_CAPABILITIES2_REG_DRS_SUPPORTED_K2_E5                                              (0x1<<31) // DRS Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_LINK_CAPABILITIES2_REG_DRS_SUPPORTED_K2_E5_SHIFT                                        31
#define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_K2_E5                                                      0x0000a0UL //Access:RW   DataWidth:0x20   // Link Control 2 and Status 2 Register.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_TARGET_LINK_SPEED_K2_E5                         (0xf<<0) // Target Link Speed.    In M-PCIe mode, the contents of this field are derived from other registers.  Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_TARGET_LINK_SPEED_K2_E5_SHIFT                   0
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_ENTER_COMPLIANCE_K2_E5                          (0x1<<4) // Enter Compliance Mode.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_ENTER_COMPLIANCE_K2_E5_SHIFT                    4
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_HW_AUTO_SPEED_DISABLE_K2_E5                     (0x1<<5) // Hardware Autonomous Speed Disable.   Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_HW_AUTO_SPEED_DISABLE_K2_E5_SHIFT               5
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_SEL_DEEMPHASIS_K2_E5                            (0x1<<6) // Controls Selectable De-emphasis for 5 GT/s.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_SEL_DEEMPHASIS_K2_E5_SHIFT                      6
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_TX_MARGIN_K2_E5                                 (0x7<<7) // Controls Transmit Margin for Debug or Compliance.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_TX_MARGIN_K2_E5_SHIFT                           7
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_ENTER_MODIFIED_COMPLIANCE_K2_E5                 (0x1<<10) // Enter Modified Compliance.   Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_ENTER_MODIFIED_COMPLIANCE_K2_E5_SHIFT           10
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_COMPLIANCE_SOS_K2_E5                            (0x1<<11) // Sets Compliance Skip Ordered Sets transmission.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_COMPLIANCE_SOS_K2_E5_SHIFT                      11
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_COMPLIANCE_PRESET_K2_E5                         (0xf<<12) // Sets Compliance Preset/De-emphasis for 5 GT/s and 8 GT/s.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_COMPLIANCE_PRESET_K2_E5_SHIFT                   12
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_CURR_DEEMPHASIS_K2_E5                           (0x1<<16) // Current De-emphasis Level.    In M-PCIe mode this register is always 0x0. In C-PCIe mode, its contents are derived by sampling the PIPE
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_CURR_DEEMPHASIS_K2_E5_SHIFT                     16
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_K2_E5                                    (0x1<<17) // Equalization 8.0GT/s Complete.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_K2_E5_SHIFT                              17
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_P1_K2_E5                                 (0x1<<18) // Equalization 8.0GT/s Phase 1 Successful.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_P1_K2_E5_SHIFT                           18
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_P2_K2_E5                                 (0x1<<19) // Equalization 8.0GT/s Phase 2 Successful.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_P2_K2_E5_SHIFT                           19
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_P3_K2_E5                                 (0x1<<20) // Equalization 8.0GT/s Phase 3 Successful.   Note: This register field is sticky.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_EQ_CPL_P3_K2_E5_SHIFT                           20
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_LINK_EQ_REQ_K2_E5                               (0x1<<21) // Link Equalization Request 8.0GT/s.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_PCIE_CAP_LINK_EQ_REQ_K2_E5_SHIFT                         21
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_DOWNSTREAM_COMPO_PRESENCE_K2_E5                          (0x7<<28) // Downstream Component Presence. For a description of this standard PCIe register field, see the PCI Express Base Specification 4.0.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_DOWNSTREAM_COMPO_PRESENCE_K2_E5_SHIFT                    28
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_DRS_MESSAGE_RECEIVED_K2_E5                               (0x1<<31) // DRS Message Received. For a description of this standard PCIe register field, see the PCI Express Base Specification 4.0.
  #define PCIEIP_REG_LINK_CONTROL2_LINK_STATUS2_REG_DRS_MESSAGE_RECEIVED_K2_E5_SHIFT                         31
#define PCIEIP_REG_MSIX_CAP_BB                                                                               0x0000a0UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_MSIX_CAP_MSIX_CAP_ID_BB                                                                 (0xff<<0) // Capability ID for MSIX Path = cfg_defs
  #define PCIEIP_REG_MSIX_CAP_MSIX_CAP_ID_BB_SHIFT                                                           0
  #define PCIEIP_REG_MSIX_CAP_MSIX_NEXT_CAP_PTR_BB                                                           (0xff<<8) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. The read-only value of this register is controlled by the CAP_ENA register in the PCI register space. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_MSIX_CAP_MSIX_NEXT_CAP_PTR_BB_SHIFT                                                     8
  #define PCIEIP_REG_MSIX_CAP_TABLE_SIZE_BB                                                                  (0x7ff<<16) // System sw reads this field to determine the MSI-X table size N, which is encoded as N-1 Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_MSIX_CAP_TABLE_SIZE_BB_SHIFT                                                            16
  #define PCIEIP_REG_MSIX_CAP_RESERVED_BB                                                                    (0x7<<27) // Reserved
  #define PCIEIP_REG_MSIX_CAP_RESERVED_BB_SHIFT                                                              27
  #define PCIEIP_REG_MSIX_CAP_FUNC_MASK_BB                                                                   (0x1<<30) // If 1, all of the vectors associated with the function are masked regardless of their per vector Mask bit. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSIX_CAP_FUNC_MASK_BB_SHIFT                                                             30
  #define PCIEIP_REG_MSIX_CAP_MSIX_ENABLE_BB                                                                 (0x1<<31) // If 1, and the MSI enable bit in the MSI message control register is 0, the function is permitted to use MSIX request service and profited from using INTx# messages. Path = i_cfg_func.i_cfg_public.i_cfg_msi_cap
  #define PCIEIP_REG_MSIX_CAP_MSIX_ENABLE_BB_SHIFT                                                           31
#define PCIEIP_REG_MSIX_TBL_OFF_BIR_BB                                                                       0x0000a4UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_MSIX_TBL_OFF_BIR_TABLE_BIR_BB                                                           (0x7<<0) // Indicates which one of functions BAR is used to map MSI-X table into memory space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_MSIX_TBL_OFF_BIR_TABLE_BIR_BB_SHIFT                                                     0
  #define PCIEIP_REG_MSIX_TBL_OFF_BIR_TABLE_OFFSET_BB                                                        (0x1fffffff<<3) // Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_MSIX_TBL_OFF_BIR_TABLE_OFFSET_BB_SHIFT                                                  3
#define PCIEIP_REG_MSIX_PBA_BIR_OFF_BB                                                                       0x0000a8UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_MSIX_PBA_BIR_OFF_PBA_BIR_BB                                                             (0x7<<0) // Indicates which one of functions BAR is used to map MSI-X PBA into memory space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_MSIX_PBA_BIR_OFF_PBA_BIR_BB_SHIFT                                                       0
  #define PCIEIP_REG_MSIX_PBA_BIR_OFF_PBA_OFFSET_BB                                                          (0x1fffffff<<3) // Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_MSIX_PBA_BIR_OFF_PBA_OFFSET_BB_SHIFT                                                    3
#define PCIEIP_REG_PCIE_CAPABILITY_BB                                                                        0x0000acUL //Access:R    DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_PCIE_CAPABILITY_PCIE_CAP_ID_BB                                                          (0xff<<0) // This register contains the PCIExpress Capability ID. Path= i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_PCIE_CAPABILITY_PCIE_CAP_ID_BB_SHIFT                                                    0
  #define PCIEIP_REG_PCIE_CAPABILITY_PCIE_NEXT_CAP_PTR_BB                                                    (0xff<<8) // This registers contains the pointer to the next PCI capability structure. Path= i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_PCIE_CAPABILITY_PCIE_NEXT_CAP_PTR_BB_SHIFT                                              8
  #define PCIEIP_REG_PCIE_CAPABILITY_VER_BB                                                                  (0xf<<16) // Capability Version. PCI Express Capability structure version number. These bits are hardwired to 2h. Path= cfg_defs
  #define PCIEIP_REG_PCIE_CAPABILITY_VER_BB_SHIFT                                                            16
  #define PCIEIP_REG_PCIE_CAPABILITY_TYPE_BB                                                                 (0xf<<20) // Device/Port Type. Device is an End Point. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_PCIE_CAPABILITY_TYPE_BB_SHIFT                                                           20
  #define PCIEIP_REG_PCIE_CAPABILITY_SLOT_IMPLEMENTED_BB                                                     (0x1<<24) // Slot Implemented. This register is not supported. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_PCIE_CAPABILITY_SLOT_IMPLEMENTED_BB_SHIFT                                               24
  #define PCIEIP_REG_PCIE_CAPABILITY_MSG_NUM_BB                                                              (0x1f<<25) // Interrupt Message Number:indicate which MSI/MSI-X vector is used for the interrupt message generated in association with any of the status bits of this capability structure. For MSI, the value in this register indicates the offset between the base Message Data and the interrupt message that is generated. For MSI-X, the value in this register indicates which MSI-X Table entry is used to generate the interrupt message. The entry must be one of the first 32 entries even if the function implements more than 32 entries. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_PCIE_CAPABILITY_MSG_NUM_BB_SHIFT                                                        25
#define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_K2_E5                                                       0x0000b0UL //Access:RW   DataWidth:0x20   // MSI-X Capability ID, Next Pointer, Control Registers.
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_CAP_ID_K2_E5                                     (0xff<<0) // MSI-X Capability ID.
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_CAP_ID_K2_E5_SHIFT                               0
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_CAP_NEXT_OFFSET_K2_E5                            (0xff<<8) // MSI-X Next Capability Pointer.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_CAP_NEXT_OFFSET_K2_E5_SHIFT                      8
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_TABLE_SIZE_K2_E5                                 (0x7ff<<16) // MSI-X Table Size.   SRIOV Note: All VFs in a single PF have the same value for "MSI-X Table Size" (PCI_MSIX_TABLE_SIZE field in VF_PCI_MSIX_CAP_ID_NEXT_CTRL_REG). To write this common value, you must perform a DBI_CS2 write (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) while accessing the PCI_MSIX_TABLE_SIZE field in the PF PCI_MSIX_CAP_ID_NEXT_CTRL_REG register.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_TABLE_SIZE_K2_E5_SHIFT                           16
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_FUNCTION_MASK_K2_E5                              (0x1<<30) // Function Mask.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_FUNCTION_MASK_K2_E5_SHIFT                        30
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_ENABLE_K2_E5                                     (0x1<<31) // MSI-X Enable.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PCI_MSIX_CAP_ID_NEXT_CTRL_REG_PCI_MSIX_ENABLE_K2_E5_SHIFT                               31
#define PCIEIP_REG_DEVICE_CAPABILITY_BB                                                                      0x0000b0UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_DEVICE_CAPABILITY_MAX_PL_SIZE_SUPPORTED_BB                                              (0x7<<0) // Max Payload Size Supported. These bits are programmable from the register space and default value is based on define in version.v file. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_MAX_PL_SIZE_SUPPORTED_BB_SHIFT                                        0
  #define PCIEIP_REG_DEVICE_CAPABILITY_UNUSED0_BB                                                            (0x3<<3) // 
  #define PCIEIP_REG_DEVICE_CAPABILITY_UNUSED0_BB_SHIFT                                                      3
  #define PCIEIP_REG_DEVICE_CAPABILITY_EXTENDED_TAG_SUPPORT_BB                                               (0x1<<5) // Extended Tag Field Support. This bit is programmable through register space. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_EXTENDED_TAG_SUPPORT_BB_SHIFT                                         5
  #define PCIEIP_REG_DEVICE_CAPABILITY_L0S_ACCEPTABLE_LATENCY_BB                                             (0x7<<6) // Endpoint L0s Acceptable Latency. These bits are programmable through register space. The value should be 0 for root ports. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_L0S_ACCEPTABLE_LATENCY_BB_SHIFT                                       6
  #define PCIEIP_REG_DEVICE_CAPABILITY_L1_ACCEPTABLE_LATENCY_BB                                              (0x7<<9) // Endpoint L1 Acceptable Latency. These bits are programmable through register space. The bits should be 0 for Root ports Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_L1_ACCEPTABLE_LATENCY_BB_SHIFT                                        9
  #define PCIEIP_REG_DEVICE_CAPABILITY_UNUSED1_BB                                                            (0x7<<12) // 
  #define PCIEIP_REG_DEVICE_CAPABILITY_UNUSED1_BB_SHIFT                                                      12
  #define PCIEIP_REG_DEVICE_CAPABILITY_ROLE_BASED_ERR_RPT_BB                                                 (0x1<<15) // Indicate device is conforming to the ECN, PCI Express Base Specification, Revision 1.1., or subsequent PCI Express Base Specification revisions Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_ROLE_BASED_ERR_RPT_BB_SHIFT                                           15
  #define PCIEIP_REG_DEVICE_CAPABILITY_UNUSED2_BB                                                            (0x3<<16) // 
  #define PCIEIP_REG_DEVICE_CAPABILITY_UNUSED2_BB_SHIFT                                                      16
  #define PCIEIP_REG_DEVICE_CAPABILITY_CAPTURED_SLOT_PWR_VAL_BB                                              (0xff<<18) // Specifies the upper limit on power supplied by slot. It is set by the Set_Slot_Power_Limit Message. This field is not set for Root ports. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_DEVICE_CAPABILITY_CAPTURED_SLOT_PWR_VAL_BB_SHIFT                                        18
  #define PCIEIP_REG_DEVICE_CAPABILITY_CAPTURED_SLOT_PWR_SCALE_BB                                            (0x3<<26) // Specifies the scale used for the Slot Power Limit Value. It is set by the Set_Slot_Power_Limit Message. This field is not set for Root ports Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_DEVICE_CAPABILITY_CAPTURED_SLOT_PWR_SCALE_BB_SHIFT                                      26
  #define PCIEIP_REG_DEVICE_CAPABILITY_FLR_CAP_SUPPORTED_BB                                                  (0x1<<28) // FLR capability is advertized when flr_supported bit in private device_capability register space is set.
  #define PCIEIP_REG_DEVICE_CAPABILITY_FLR_CAP_SUPPORTED_BB_SHIFT                                            28
#define PCIEIP_REG_MSIX_TABLE_OFFSET_REG_K2_E5                                                               0x0000b4UL //Access:RW   DataWidth:0x20   // MSI-X Table Offset and BIR Register.
  #define PCIEIP_REG_MSIX_TABLE_OFFSET_REG_PCI_MSIX_BIR_K2_E5                                                (0x7<<0) // MSI-X Table Bar Indicator Register Field.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_MSIX_TABLE_OFFSET_REG_PCI_MSIX_BIR_K2_E5_SHIFT                                          0
  #define PCIEIP_REG_MSIX_TABLE_OFFSET_REG_PCI_MSIX_TABLE_OFFSET_K2_E5                                       (0x1fffffff<<3) // MSI-X Table Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_MSIX_TABLE_OFFSET_REG_PCI_MSIX_TABLE_OFFSET_K2_E5_SHIFT                                 3
#define PCIEIP_REG_DEVICE_STATUS_CONTROL_BB                                                                  0x0000b4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_CORR_ERR_REPORT_EN_BB                                             (0x1<<0) // Correctable Error Reporting Enable. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_CORR_ERR_REPORT_EN_BB_SHIFT                                       0
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NFATAL_ERR_REPORT_EN_BB                                           (0x1<<1) // Non-Fatal Error Reporting Enable. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NFATAL_ERR_REPORT_EN_BB_SHIFT                                     1
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_FATAL_ERR_REPORT_EN_BB                                            (0x1<<2) // Fatal Error Reporting Enable. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_FATAL_ERR_REPORT_EN_BB_SHIFT                                      2
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_U_REQ_REPORT_EN_BB                                                (0x1<<3) // Unsupported Request Reporting Enable. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_U_REQ_REPORT_EN_BB_SHIFT                                          3
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_RELAX_ORDERING_ENABLE_BB                                          (0x1<<4) // Relax Ordering Enable. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_RELAX_ORDERING_ENABLE_BB_SHIFT                                    4
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_MAX_PAYLOAD_SIZE_BB                                               (0x7<<5) // Max Payload Size. Depending on the spec, internal logic uses either the min or the max of the value of the two functions. For ARI devices max payload size is determined solely by setting in Function 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_MAX_PAYLOAD_SIZE_BB_SHIFT                                         5
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_EXTENDED_TAG_EN_BB                                                (0x1<<8) // Extended Tag Field Enable. This capability when set allows DUT to generate more than 32 tags. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_EXTENDED_TAG_EN_BB_SHIFT                                          8
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_UNUSED0_BB                                                        (0x1<<9) // 
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_UNUSED0_BB_SHIFT                                                  9
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_AUX_PWR_PM_ENA_BB                                                 (0x1<<10) // This bit when set enables device to draw aux power independent of PME AUX power Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_AUX_PWR_PM_ENA_BB_SHIFT                                           10
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NO_SNOOP_ENABLE_BB                                                (0x1<<11) // Enable No Snoop. When this bit is set to 1, PCIE initiates a read request with the No Snoop bit in the attribute field set for the transactions that request the No Snoop attribute. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NO_SNOOP_ENABLE_BB_SHIFT                                          11
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_MAX_READ_REQ_SIZ_BB                                               (0x7<<12) // Maximum Read Request Size. Depending on the spec, internal logic uses either the min or the max of the value of the two functions. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_MAX_READ_REQ_SIZ_BB_SHIFT                                         12
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_FLR_INITIATED_BB                                                  (0x1<<15) // Initiate Function Level reset. This bit is writeable only if flr_supported bit in private device_capability register is set. A write of 1 to this bit initiates Function Level Reset. The value read by s/w from this bit is always 0.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_FLR_INITIATED_BB_SHIFT                                            15
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_CORR_ERR_DET_BB                                                   (0x1<<16) // Correctable Error Detected. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_CORR_ERR_DET_BB_SHIFT                                             16
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NON_FATAL_ERR_DET_BB                                              (0x1<<17) // Non-Fatal Error Detected. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NON_FATAL_ERR_DET_BB_SHIFT                                        17
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_FATAL_ERR_DET_BB                                                  (0x1<<18) // Fatal Error Detected. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_FATAL_ERR_DET_BB_SHIFT                                            18
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_UNSUP_REQ_DET_BB                                                  (0x1<<19) // UnSupported Request Detected. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_UNSUP_REQ_DET_BB_SHIFT                                            19
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_AUX_PWR_DET_BB                                                    (0x1<<20) // This bit is the current state of the VAUX_PRSNT pin of the device. When it is '1', it is indicating that part needs VAUX and detects the VAUX is present. Path= input to pcie_vaux_pipe
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_AUX_PWR_DET_BB_SHIFT                                              20
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NP_TRANSACTION_PEND_BB                                            (0x1<<21) // This is bit is read back a 1, whenever a non-posted request initiated by PCIE core is pending to be completed. Path= i_tl_top
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_NP_TRANSACTION_PEND_BB_SHIFT                                      21
#define PCIEIP_REG_MSIX_PBA_OFFSET_REG_K2_E5                                                                 0x0000b8UL //Access:RW   DataWidth:0x20   // MSI-X PBA Offset and BIR Register.
  #define PCIEIP_REG_MSIX_PBA_OFFSET_REG_PCI_MSIX_PBA_K2_E5                                                  (0x7<<0) // MSI-X PBA BIR.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_MSIX_PBA_OFFSET_REG_PCI_MSIX_PBA_K2_E5_SHIFT                                            0
  #define PCIEIP_REG_MSIX_PBA_OFFSET_REG_PCI_MSIX_PBA_OFFSET_K2_E5                                           (0x1fffffff<<3) // MSI-X PBA Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_MSIX_PBA_OFFSET_REG_PCI_MSIX_PBA_OFFSET_K2_E5_SHIFT                                     3
#define PCIEIP_REG_LINK_CAPABILITY_BB                                                                        0x0000b8UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LINK_CAPABILITY_MAX_LINK_SPEED_BB                                                       (0xf<<0) // Path= i_cfg_func.i_cfg_private Value used by internal logic is the smaller of the value programmed for each function
  #define PCIEIP_REG_LINK_CAPABILITY_MAX_LINK_SPEED_BB_SHIFT                                                 0
  #define PCIEIP_REG_LINK_CAPABILITY_MAX_LINK_WIDTH_BB                                                       (0x3f<<4) // Maximum Link Width. These are programmable through reg space.Bit 9 is always 0 and is not programmable. Default value is based on numLanes field in version.v Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LINK_CAPABILITY_MAX_LINK_WIDTH_BB_SHIFT                                                 4
  #define PCIEIP_REG_LINK_CAPABILITY_ASPM_SUPT_BB                                                            (0x3<<10) // ASPM Support. These bits are programmable through reg space. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LINK_CAPABILITY_ASPM_SUPT_BB_SHIFT                                                      10
  #define PCIEIP_REG_LINK_CAPABILITY_L0S_EXIT_LAT_BB                                                         (0x7<<12) // L0s Exit Latency. These bits are programmable through register space. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap Depending on whether device is in common clock mode or not, the value reflected by these bits is one of the following.
  #define PCIEIP_REG_LINK_CAPABILITY_L0S_EXIT_LAT_BB_SHIFT                                                   12
  #define PCIEIP_REG_LINK_CAPABILITY_L1_EXIT_LAT_BB                                                          (0x7<<15) // L1 Exit Latency. These bits are programmable through register space. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap Depending on whether device is in common clock mode or not, the value reflected by these bits is one of the following.
  #define PCIEIP_REG_LINK_CAPABILITY_L1_EXIT_LAT_BB_SHIFT                                                    15
  #define PCIEIP_REG_LINK_CAPABILITY_CLK_PWR_MGMT_BB                                                         (0x1<<18) // Clock Power Management. These bits are programmable through register. The feature itself has to be enabled in version.v Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LINK_CAPABILITY_CLK_PWR_MGMT_BB_SHIFT                                                   18
  #define PCIEIP_REG_LINK_CAPABILITY_SUR_DWN_ERR_REP_BB                                                      (0x1<<19) // Surprise Down Error Reporting Capable: RC: this bit must be set if the component supports the optional capability of detecting and reporting a Surprise Down error condition. RC: Not supported and hardwired to 0. EP: Not supported and hardwired to 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_CAPABILITY_SUR_DWN_ERR_REP_BB_SHIFT                                                19
  #define PCIEIP_REG_LINK_CAPABILITY_DL_ACTIVE_REP_BB                                                        (0x1<<20) // Data Link Layer Link Active Reporting Capable: RC: this bit must be hardwired to 1b if the component supports the optional capability of reporting the DL_Active state of the Data Link Control and Management State Machine. RC: Implemented (RW) for RC. Default to 0. EP: Not supported and hardwired to 0. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LINK_CAPABILITY_DL_ACTIVE_REP_BB_SHIFT                                                  20
  #define PCIEIP_REG_LINK_CAPABILITY_LINK_BW_NOTIFY_BB                                                       (0x1<<21) // Link Bandwidth Notification Capability: RC: A value of 1b indicates support for the Link Bandwidth Notification status and interrupt mechanisms. This capability is required for all Root Ports and Switch Downstream Ports supporting Links wider than x1 and/or multiple Link speeds. RC: Field is implemented. EP: Not supported and hardwired to 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_CAPABILITY_LINK_BW_NOTIFY_BB_SHIFT                                                 21
  #define PCIEIP_REG_LINK_CAPABILITY_UNUSED0_BB                                                              (0x3<<22) // 
  #define PCIEIP_REG_LINK_CAPABILITY_UNUSED0_BB_SHIFT                                                        22
  #define PCIEIP_REG_LINK_CAPABILITY_PORT_NUMBER_BB                                                          (0xff<<24) // PCIE Port Number. These bits are programmable through register. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LINK_CAPABILITY_PORT_NUMBER_BB_SHIFT                                                    24
#define PCIEIP_REG_LINK_STATUS_CONTROL_BB                                                                    0x0000bcUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LINK_STATUS_CONTROL_ASPM_CTRL_BB                                                        (0x3<<0) // ASPM Control. Value used by logic is dependent on the value of this bit for each enabled function and also on the programmed powerstate of each function. For ARI devices, ASPM setting is determined solely by the setting in Function 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_ASPM_CTRL_BB_SHIFT                                                  0
  #define PCIEIP_REG_LINK_STATUS_CONTROL_UNUSED0_BB                                                          (0x1<<2) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_UNUSED0_BB_SHIFT                                                    2
  #define PCIEIP_REG_LINK_STATUS_CONTROL_RCB_BB                                                              (0x1<<3) // Read Completion Boundary. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_RCB_BB_SHIFT                                                        3
  #define PCIEIP_REG_LINK_STATUS_CONTROL_CFG_PSM_LINK_DISABLE_BB                                             (0x1<<4) // Requesting PHY to disable the link. This bit is only applicable to RC. So for EP it is read only bit. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_CFG_PSM_LINK_DISABLE_BB_SHIFT                                       4
  #define PCIEIP_REG_LINK_STATUS_CONTROL_CFG_PSM_RETRAIN_LINK_BB                                             (0x1<<5) // Requesting PHY to retrain the link. This bit is only applicable to RC. So for EP it is read only bit. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_CFG_PSM_RETRAIN_LINK_BB_SHIFT                                       5
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_CR_COMMON_CLK_BB                                               (0x1<<6) // Common Clock Configuration. Value used by logic is resolved to 1 only if all functions (when enabled) have this bit set. For ARI devices, only Function 0 determines the value used. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_CR_COMMON_CLK_BB_SHIFT                                         6
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_CR_EXT_SYNC_BB                                                 (0x1<<7) // Extended Synch. This bit when set forces the transmission of 4096 FTS ordered sets in the L0s state followed by a single SKP ordered set prior to entering the L0 state, and the transmission of 1024 TS1 ordered sets in the L1 state prior to entering the Recovery state. Value used by logic is resolved to 1 if either function has this bit set. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_CR_EXT_SYNC_BB_SHIFT                                           7
  #define PCIEIP_REG_LINK_STATUS_CONTROL_EN_CLK_PW_MGMT_BB                                                   (0x1<<8) // Enable Clock Power Management: RC: N/A and hardwired to 0. EP: When this bit is set, the device is permitted to use CLKREQ# signal to power management. Feature is enabled through version.v define Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_EN_CLK_PW_MGMT_BB_SHIFT                                             8
  #define PCIEIP_REG_LINK_STATUS_CONTROL_HW_AUTO_WIDTH_DIS_BB                                                (0x1<<9) // Hardware Autonomous Width Disable: When Set, this bit disables hardware from changing the Link width for reasons other than attempting to correct unreliable Link operation by reducing Link width. Other functions are reserved. RC: Not applicable and hardwire to 0 EP: If supported, only apply to function0. Not implemented and hardwire to 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_HW_AUTO_WIDTH_DIS_BB_SHIFT                                          9
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_BW_MGMT_INT_EN_BB                                              (0x1<<10) // Link Bandwidth Management Interrupt Enable: when Set, this bit enables the generation of an interrupt to indicate that the Link Bandwidth Management Status bit has been Set. RC: N/A and hardwired to 0. EP: Not implemented and hardwired to 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_BW_MGMT_INT_EN_BB_SHIFT                                        10
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_BW_INT_EN_BB                                                   (0x1<<11) // Link Autonomous Bandwidth Interrupt Enable: When Set, this bit enables the generation of an interrupt to indicate that the Link Autonomous Bandwidth Status bit has been Set. RC: Not implemented and hardwired to 0. EP: N/A and hardwired to 0 Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_BW_INT_EN_BB_SHIFT                                             11
  #define PCIEIP_REG_LINK_STATUS_CONTROL_UNUSED1_BB                                                          (0xf<<12) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_UNUSED1_BB_SHIFT                                                    12
  #define PCIEIP_REG_LINK_STATUS_CONTROL_NEG_LINK_SPEED_BB                                                   (0xf<<16) // Link Speed. These bits indicate the negotiated link speed of the PCI Express link. These bits are undefined if the link is not up (L0, L0s, L1). Path= i_pl_top.i_pl_ltssm
  #define PCIEIP_REG_LINK_STATUS_CONTROL_NEG_LINK_SPEED_BB_SHIFT                                             16
  #define PCIEIP_REG_LINK_STATUS_CONTROL_NEG_LINK_WIDTH_BB                                                   (0x3f<<20) // Negotiated Link Width. These bits indicate the negotiated link width of the PCI Express link. Path= i_pl_top.i_pl_ltssm
  #define PCIEIP_REG_LINK_STATUS_CONTROL_NEG_LINK_WIDTH_BB_SHIFT                                             20
  #define PCIEIP_REG_LINK_STATUS_CONTROL_UNUSED2_BB                                                          (0x1<<26) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_UNUSED2_BB_SHIFT                                                    26
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_TRAINING_BB                                                    (0x1<<27) // EP: This bit is N/A and is hardwired to 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_LINK_TRAINING_BB_SHIFT                                              27
  #define PCIEIP_REG_LINK_STATUS_CONTROL_SLOT_CLK_CONFIG_BB                                                  (0x1<<28) // Slot Clock configuration. This bit is read-only by host, but read/write via backdoor CS bus. Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_LINK_STATUS_CONTROL_SLOT_CLK_CONFIG_BB_SHIFT                                            28
  #define PCIEIP_REG_LINK_STATUS_CONTROL_DL_ACTIVE_BB                                                        (0x1<<29) // Data Link Layer Link Active: returns a 1b to indicate the DL_Active state, 0b otherwise. Not implemented and hardwire to 0. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_DL_ACTIVE_BB_SHIFT                                                  29
#define PCIEIP_REG_SLOT_CAPABILITY_BB                                                                        0x0000c0UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SLOT_CAPABILITY_UNUSED_2_BB                                                             (0x7f<<0) // Not implemented
  #define PCIEIP_REG_SLOT_CAPABILITY_UNUSED_2_BB_SHIFT                                                       0
  #define PCIEIP_REG_SLOT_CAPABILITY_SLOT_POWER_LIMIT_VALUE_BB                                               (0xff<<7) // Not implemented
  #define PCIEIP_REG_SLOT_CAPABILITY_SLOT_POWER_LIMIT_VALUE_BB_SHIFT                                         7
  #define PCIEIP_REG_SLOT_CAPABILITY_SLOT_POWER_LIMIT_SCALE_BB                                               (0x3<<15) // Not implemented
  #define PCIEIP_REG_SLOT_CAPABILITY_SLOT_POWER_LIMIT_SCALE_BB_SHIFT                                         15
  #define PCIEIP_REG_SLOT_CAPABILITY_UNUSED_BB                                                               (0x3<<17) // Not implemented
  #define PCIEIP_REG_SLOT_CAPABILITY_UNUSED_BB_SHIFT                                                         17
  #define PCIEIP_REG_SLOT_CAPABILITY_PHYSICAL_SLOT_NUMBER_BB                                                 (0x1fff<<19) // Not implemented
  #define PCIEIP_REG_SLOT_CAPABILITY_PHYSICAL_SLOT_NUMBER_BB_SHIFT                                           19
#define PCIEIP_REG_SLOT_CONTROL_STATUS_BB                                                                    0x0000c4UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_SLOT_CONTROL_BB                                                     (0xffff<<0) // Not implemented
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_SLOT_CONTROL_BB_SHIFT                                               0
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_UNUSED_1_BB                                                         (0x3f<<16) // Not implemented
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_UNUSED_1_BB_SHIFT                                                   16
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_PRESENCE_DETECT_BB                                                  (0x1<<22) // Not implemented
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_PRESENCE_DETECT_BB_SHIFT                                            22
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_SLOT_STATUS_BB                                                      (0x1ff<<23) // Not implemented
  #define PCIEIP_REG_SLOT_CONTROL_STATUS_SLOT_STATUS_BB_SHIFT                                                23
#define PCIEIP_REG_ROOT_CAP_CONTROL_BB                                                                       0x0000c8UL //Access:R    DataWidth:0x20   // For EP this register is not applicable and hardwired to 0.
#define PCIEIP_REG_ROOT_STATUS_BB                                                                            0x0000ccUL //Access:R    DataWidth:0x20   // For EP this register is not applicable and hardwired to 0.
#define PCIEIP_REG_VPD_BASE_K2_E5                                                                            0x0000d0UL //Access:RW   DataWidth:0x20   // VPD Control and Capabilities Register.
  #define PCIEIP_REG_VPD_BASE_VPD_PCIE_EXTENDED_CAP_ID_K2_E5                                                 (0xff<<0) // VPD Extended Capability ID.
  #define PCIEIP_REG_VPD_BASE_VPD_PCIE_EXTENDED_CAP_ID_K2_E5_SHIFT                                           0
  #define PCIEIP_REG_VPD_BASE_VPD_NEXT_OFFSET_K2_E5                                                          (0xff<<8) // VPD Pointer to Next Capability.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_VPD_BASE_VPD_NEXT_OFFSET_K2_E5_SHIFT                                                    8
  #define PCIEIP_REG_VPD_BASE_VPD_ADDRESS_K2_E5                                                              (0x7fff<<16) // VPD Address.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_VPD_BASE_VPD_ADDRESS_K2_E5_SHIFT                                                        16
  #define PCIEIP_REG_VPD_BASE_VPD_FLAG_K2_E5                                                                 (0x1<<31) // VPD Flag.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_VPD_BASE_VPD_FLAG_K2_E5_SHIFT                                                           31
#define PCIEIP_REG_DEVICE_CAPABILITY_2_BB                                                                    0x0000d0UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_CMPL_TIMEOUT_RANGES_SUPPORTED_BB                                    (0xf<<0) // Completion Timeout Ranges Supported. Programmable through register space Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_CMPL_TIMEOUT_RANGES_SUPPORTED_BB_SHIFT                              0
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_CMPL_TIMEOUT_DISABL_SUPPORTED_BB                                    (0x1<<4) // Completion Timeout Disable Supported, Programmable through register space Path= i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_CMPL_TIMEOUT_DISABL_SUPPORTED_BB_SHIFT                              4
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_UNUSED0_BB                                                          (0x3f<<5) // 
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_UNUSED0_BB_SHIFT                                                    5
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_LTR_MECHANISM_SUPPORTED_BB                                          (0x1<<11) // Latency Tolerance Reporting Mechanism Supported, Programmable through register space. This field will read 1, when bit 5 of ext_cap_ena field in private register space is set.
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_LTR_MECHANISM_SUPPORTED_BB_SHIFT                                    11
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_TPH_COMPLETER_SUPPORTED_BB                                          (0x3<<12) // TPH and Extended TPH completer not supported.
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_TPH_COMPLETER_SUPPORTED_BB_SHIFT                                    12
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_UNUSED1_BB                                                          (0xf<<14) // 
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_UNUSED1_BB_SHIFT                                                    14
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_OBFF_SUPORTED_BB                                                    (0x3<<18) // OBFF Supported using WAKE# signaling only. Value is programmable through private register space in Device_cap2.
  #define PCIEIP_REG_DEVICE_CAPABILITY_2_OBFF_SUPORTED_BB_SHIFT                                              18
#define PCIEIP_REG_DATA_REG_K2_E5                                                                            0x0000d4UL //Access:RW   DataWidth:0x20   // VPD Data Register.
#define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_BB                                                                0x0000d4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_CMPL_TIMEOUT_VALUE_BB                                           (0xf<<0) // Completion timeout value. The spec specifies a range, the device uses the max value in the range. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_CMPL_TIMEOUT_VALUE_BB_SHIFT                                     0
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_CMPL_TIMEOUT_DISABLE_BB                                         (0x1<<4) // Completion Timeout Disable Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_CMPL_TIMEOUT_DISABLE_BB_SHIFT                                   4
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED0_BB                                                      (0x1<<5) // 
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED0_BB_SHIFT                                                5
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_ATOMIC_REQ_ENABLE_BB                                            (0x1<<6) // Atomic requester Enable. When this bit is set, function and associated VF's are enabled to make Atomic Op requests.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_ATOMIC_REQ_ENABLE_BB_SHIFT                                      6
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED1_BB                                                      (0x1<<7) // 
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED1_BB_SHIFT                                                7
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_IDO_REQ_ENABLE_BB                                               (0x1<<8) // IDO Request Enable, This field is writeable, when bit ido_supported bit of private device_capability_2 register is set. When this bit is set, function is permitted to set ID based Ordering Attribute of Requests it initiates.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_IDO_REQ_ENABLE_BB_SHIFT                                         8
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_IDO_CPL_ENABLE_BB                                               (0x1<<9) // IDO Completion Enable, This field is writeable, when bit ido_supported bit of private device_capability_2 register is set. When this bit is set, function is permitted to set ID based Ordering Attribute of Completions it returns.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_IDO_CPL_ENABLE_BB_SHIFT                                         9
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_LTR_MECHANISM_ENABLE_BB                                         (0x1<<10) // Latency Tolerance Reporting Mechanism Enable, This field is writeable, when bit 5 of ext_cap_ena field in private register space is set. This bit is RW only in function 0 and is RsvdP for all other functions.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_LTR_MECHANISM_ENABLE_BB_SHIFT                                   10
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED2_BB                                                      (0x3<<11) // 
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED2_BB_SHIFT                                                11
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_OBFF_ENABLE_BB                                                  (0x3<<13) // Enable OBFF mechanism and select signaling method. This field is writeable, when bit 5 of ext_cap_ena field in private register space is set. This bit is RW only in function 0 and is RsvdP for all other functions.
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_OBFF_ENABLE_BB_SHIFT                                            13
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED3_BB                                                      (0x1<<15) // 
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_UNUSED3_BB_SHIFT                                                15
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_DEVICE_STATUS_2_BB                                              (0xffff<<16) // Placeholder for Gen2 Path= i_cfg_func.i_cfg_public.i_cfg_rd_mux
  #define PCIEIP_REG_DEVICE_STATUS_CONTROL_2_DEVICE_STATUS_2_BB_SHIFT                                        16
#define PCIEIP_REG_LINK_CAPABILITY_2_BB                                                                      0x0000d8UL //Access:R    DataWidth:0x20   // Placeholder for Gen2 Path= i_cfg_func.i_cfg_private
#define PCIEIP_REG_LINK_STATUS_CONTROL_2_BB                                                                  0x0000dcUL //Access:RW   DataWidth:0x20   // This register will be Read only by default, and will read all 0's to allow compliance with PCIE spec 1.1. To enable this register, reset comply_pcie_1_1 bit in the register space to 0.
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_TARGET_LINK_SPEED_BB                                              (0xf<<0) // Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_TARGET_LINK_SPEED_BB_SHIFT                                        0
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_ENTER_COMPLIANCE_BB                                               (0x1<<4) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_ENTER_COMPLIANCE_BB_SHIFT                                         4
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_HW_AUTO_SPEED_DISABLE_BB                                          (0x1<<5) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_HW_AUTO_SPEED_DISABLE_BB_SHIFT                                    5
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_SEL_DEEMPHASIS_BB                                                 (0x1<<6) // When link is operating at Gen2 rates, this bit selects the level of de-emphasis. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap Value used by logic is resolved to 1 if either function has this bit set.
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_SEL_DEEMPHASIS_BB_SHIFT                                           6
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_TX_MARGIN_BB                                                  (0x7<<7) // Value used by logic is resolved to the smaller binary value, if two functions have different values.
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_TX_MARGIN_BB_SHIFT                                            7
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_ENTER_MOD_COMPLIANCE_BB                                       (0x1<<10) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_ENTER_MOD_COMPLIANCE_BB_SHIFT                                 10
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_COMPLIANCE_SOS_BB                                             (0x1<<11) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_COMPLIANCE_SOS_BB_SHIFT                                       11
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_COMPLIANCE_DEEMPH_BB                                          (0x1<<12) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_COMPLIANCE_DEEMPH_BB_SHIFT                                    12
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_UNUSED0_BB                                                        (0x7<<13) // 
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_UNUSED0_BB_SHIFT                                                  13
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CURR_DEEMPH_LEVEL_BB                                              (0x1<<16) // curr_deemph_level Path = pl_top
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CURR_DEEMPH_LEVEL_BB_SHIFT                                        16
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_COMPLETE_BB                                                (0x1<<17) // Equalization Complete - when set, this indicates that the Transmitter equalization procedure has completed. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_COMPLETE_BB_SHIFT                                          17
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_PHASE1_SUCCESS_BB                                          (0x1<<18) // Equalization Phase 1 Successful - when set, this indicates that Phase 1 of the Transmitter equalization procedure has successfully completed. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_PHASE1_SUCCESS_BB_SHIFT                                    18
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_PHASE2_SUCCESS_BB                                          (0x1<<19) // Equalization Phase 2 Successful - when set, this indicates that Phase 2 of the Transmitter equalization procedure has successfully completed. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_PHASE2_SUCCESS_BB_SHIFT                                    19
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_PHASE3_SUCCESS_BB                                          (0x1<<20) // Equalization Phase 3 Successful - when set, this indicates that Phase 3 of the Transmitter equalization procedure has successfully completed. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_EQ_PHASE3_SUCCESS_BB_SHIFT                                    20
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_LINK_EQ_REQUEST_BB                                            (0x1<<21) // This bit is set by hardware to request the link equalization process to be performed on the link. Path= i_cfg_func.i_cfg_public.i_cfg_exp_cap
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_CFG_LINK_EQ_REQUEST_BB_SHIFT                                      21
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_LINK_STATUS_2_UNUSED_BB                                           (0x3ff<<22) // Placeholder
  #define PCIEIP_REG_LINK_STATUS_CONTROL_2_LINK_STATUS_2_UNUSED_BB_SHIFT                                     22
#define PCIEIP_REG_SLOT_CAPABILITY_2_BB                                                                      0x0000e0UL //Access:R    DataWidth:0x20   // Not implemented
#define PCIEIP_REG_SLOT_STATUS_CONTROL_2_BB                                                                  0x0000e4UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SLOT_STATUS_CONTROL_2_SLOT_CONTROL_2_BB                                                 (0xffff<<0) // Not implemented
  #define PCIEIP_REG_SLOT_STATUS_CONTROL_2_SLOT_CONTROL_2_BB_SHIFT                                           0
  #define PCIEIP_REG_SLOT_STATUS_CONTROL_2_SLOT_STATUS_2_BB                                                  (0xffff<<16) // Not implemented
  #define PCIEIP_REG_SLOT_STATUS_CONTROL_2_SLOT_STATUS_2_BB_SHIFT                                            16
#define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_K2_E5                                                                 0x000100UL //Access:RW   DataWidth:0x20   // Advanced Error Reporting Extended Capability Header.
  #define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_CAP_ID_K2_E5                                                        (0xffff<<0) // AER Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_CAP_ID_K2_E5_SHIFT                                                  0
  #define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_CAP_VERSION_K2_E5                                                   (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_CAP_VERSION_K2_E5_SHIFT                                             16
  #define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_NEXT_OFFSET_K2_E5                                                   (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_AER_EXT_CAP_HDR_OFF_NEXT_OFFSET_K2_E5_SHIFT                                             20
#define PCIEIP_REG_ADV_ERR_CAP_BB                                                                            0x000100UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_ADV_ERR_CAP_ADV_ERR_CAP_ID_BB                                                           (0xffff<<0) // PCI Express Extended Capability ID. These bits are hardwired to 0001h indicating the presence of PCI Express Advanced Error Capability. Path= cfg_defs
  #define PCIEIP_REG_ADV_ERR_CAP_ADV_ERR_CAP_ID_BB_SHIFT                                                     0
  #define PCIEIP_REG_ADV_ERR_CAP_VER_BB                                                                      (0xf<<16) // Capability ID Version. These bits are hardwired to 1h indicating the version of the capability ID. Path= cfg_defs.v
  #define PCIEIP_REG_ADV_ERR_CAP_VER_BB_SHIFT                                                                16
  #define PCIEIP_REG_ADV_ERR_CAP_NEXT_BB                                                                     (0xfff<<20) // Next Capabilities Pointer is 0x13C which is Power Budget. Path= i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_ADV_ERR_CAP_NEXT_BB_SHIFT                                                               20
#define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_K2_E5                                                               0x000104UL //Access:RW   DataWidth:0x20   // Uncorrectable Error Status Register.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_DL_PROTOCOL_ERR_STATUS_K2_E5                                      (0x1<<4) // Data Link Protocol Error Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_DL_PROTOCOL_ERR_STATUS_K2_E5_SHIFT                                4
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_SUR_DWN_ERR_STATUS_K2_E5                                          (0x1<<5) // Surprise Down Error Status (Optional).   Note: Not supported.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_SUR_DWN_ERR_STATUS_K2_E5_SHIFT                                    5
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_POIS_TLP_ERR_STATUS_K2_E5                                         (0x1<<12) // Poisoned TLP Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_POIS_TLP_ERR_STATUS_K2_E5_SHIFT                                   12
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_FC_PROTOCOL_ERR_STATUS_K2_E5                                      (0x1<<13) // Flow Control Protocol Error Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_FC_PROTOCOL_ERR_STATUS_K2_E5_SHIFT                                13
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_CMPLT_TIMEOUT_ERR_STATUS_K2_E5                                    (0x1<<14) // Completion Timeout Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_CMPLT_TIMEOUT_ERR_STATUS_K2_E5_SHIFT                              14
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_CMPLT_ABORT_ERR_STATUS_K2_E5                                      (0x1<<15) // Completer Abort Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_CMPLT_ABORT_ERR_STATUS_K2_E5_SHIFT                                15
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_UNEXP_CMPLT_ERR_STATUS_K2_E5                                      (0x1<<16) // Unexpected Completion Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_UNEXP_CMPLT_ERR_STATUS_K2_E5_SHIFT                                16
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_REC_OVERFLOW_ERR_STATUS_K2_E5                                     (0x1<<17) // Receiver Overflow Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_REC_OVERFLOW_ERR_STATUS_K2_E5_SHIFT                               17
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_MALF_TLP_ERR_STATUS_K2_E5                                         (0x1<<18) // Malformed TLP Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_MALF_TLP_ERR_STATUS_K2_E5_SHIFT                                   18
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_ECRC_ERR_STATUS_K2_E5                                             (0x1<<19) // ECRC Error Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_ECRC_ERR_STATUS_K2_E5_SHIFT                                       19
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_UNSUPPORTED_REQ_ERR_STATUS_K2_E5                                  (0x1<<20) // Unsupported Request Error Status.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_UNSUPPORTED_REQ_ERR_STATUS_K2_E5_SHIFT                            20
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_INTERNAL_ERR_STATUS_K2_E5                                         (0x1<<22) // Uncorrectable Internal Error Status.    The core sets this bit when your application asserts app_err_bus[9]. It does not set this bit when it detects internal uncorrectable internal errors such as parity and ECC failures. You should use the outputs from these errors to drive the app_err_bus[9] input. For more details, see the "Data Integrity (Wire, Datapath, and RAM Protection)" section in the Databook.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_INTERNAL_ERR_STATUS_K2_E5_SHIFT                                   22
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_TLP_PRFX_BLOCKED_ERR_STATUS_K2_E5                                 (0x1<<25) // TLP Prefix Blocked Error Status.   Note: Not supported.
  #define PCIEIP_REG_UNCORR_ERR_STATUS_OFF_TLP_PRFX_BLOCKED_ERR_STATUS_K2_E5_SHIFT                           25
#define PCIEIP_REG_UC_ERR_STATUS_BB                                                                          0x000104UL //Access:RW   DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
  #define PCIEIP_REG_UC_ERR_STATUS_UNUSED0_BB                                                                (0xf<<0) // 
  #define PCIEIP_REG_UC_ERR_STATUS_UNUSED0_BB_SHIFT                                                          0
  #define PCIEIP_REG_UC_ERR_STATUS_DLPES_BB                                                                  (0x1<<4) // Data Link Protocol Error Status
  #define PCIEIP_REG_UC_ERR_STATUS_DLPES_BB_SHIFT                                                            4
  #define PCIEIP_REG_UC_ERR_STATUS_UNUSED1_BB                                                                (0x7f<<5) // 
  #define PCIEIP_REG_UC_ERR_STATUS_UNUSED1_BB_SHIFT                                                          5
  #define PCIEIP_REG_UC_ERR_STATUS_PTLPS_BB                                                                  (0x1<<12) // Poisoned TLP Status.
  #define PCIEIP_REG_UC_ERR_STATUS_PTLPS_BB_SHIFT                                                            12
  #define PCIEIP_REG_UC_ERR_STATUS_FCPES_BB                                                                  (0x1<<13) // Flow Control Protocol Error Status.
  #define PCIEIP_REG_UC_ERR_STATUS_FCPES_BB_SHIFT                                                            13
  #define PCIEIP_REG_UC_ERR_STATUS_CTS_BB                                                                    (0x1<<14) // Completer Timeout Status.
  #define PCIEIP_REG_UC_ERR_STATUS_CTS_BB_SHIFT                                                              14
  #define PCIEIP_REG_UC_ERR_STATUS_CAS_BB                                                                    (0x1<<15) // Completer Abort Status.
  #define PCIEIP_REG_UC_ERR_STATUS_CAS_BB_SHIFT                                                              15
  #define PCIEIP_REG_UC_ERR_STATUS_UCS_BB                                                                    (0x1<<16) // Unexpected Completion Status.
  #define PCIEIP_REG_UC_ERR_STATUS_UCS_BB_SHIFT                                                              16
  #define PCIEIP_REG_UC_ERR_STATUS_ROS_BB                                                                    (0x1<<17) // Receiver Overflow Status.
  #define PCIEIP_REG_UC_ERR_STATUS_ROS_BB_SHIFT                                                              17
  #define PCIEIP_REG_UC_ERR_STATUS_MTLPS_BB                                                                  (0x1<<18) // Malformed TLP Status.
  #define PCIEIP_REG_UC_ERR_STATUS_MTLPS_BB_SHIFT                                                            18
  #define PCIEIP_REG_UC_ERR_STATUS_ECRCS_BB                                                                  (0x1<<19) // ECRC Error Status
  #define PCIEIP_REG_UC_ERR_STATUS_ECRCS_BB_SHIFT                                                            19
  #define PCIEIP_REG_UC_ERR_STATUS_URES_BB                                                                   (0x1<<20) // Unsupported Request Error Status.
  #define PCIEIP_REG_UC_ERR_STATUS_URES_BB_SHIFT                                                             20
#define PCIEIP_REG_UNCORR_ERR_MASK_OFF_K2_E5                                                                 0x000108UL //Access:RW   DataWidth:0x20   // Uncorrectable Error Mask Register.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_DL_PROTOCOL_ERR_MASK_K2_E5                                          (0x1<<4) // Data Link Protocol Error Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_DL_PROTOCOL_ERR_MASK_K2_E5_SHIFT                                    4
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_SUR_DWN_ERR_MASK_K2_E5                                              (0x1<<5) // Surprise Down Error Mask.   Note: Not supported.  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_SUR_DWN_ERR_MASK_K2_E5_SHIFT                                        5
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_POIS_TLP_ERR_MASK_K2_E5                                             (0x1<<12) // Poisoned TLP Error Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_POIS_TLP_ERR_MASK_K2_E5_SHIFT                                       12
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_FC_PROTOCOL_ERR_MASK_K2_E5                                          (0x1<<13) // Flow Control Protocol Error Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_FC_PROTOCOL_ERR_MASK_K2_E5_SHIFT                                    13
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_CMPLT_TIMEOUT_ERR_MASK_K2_E5                                        (0x1<<14) // Completion Timeout Error Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_CMPLT_TIMEOUT_ERR_MASK_K2_E5_SHIFT                                  14
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_CMPLT_ABORT_ERR_MASK_K2_E5                                          (0x1<<15) // Completer Abort Error Mask (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_CMPLT_ABORT_ERR_MASK_K2_E5_SHIFT                                    15
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_UNEXP_CMPLT_ERR_MASK_K2_E5                                          (0x1<<16) // Unexpected Completion Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_UNEXP_CMPLT_ERR_MASK_K2_E5_SHIFT                                    16
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_REC_OVERFLOW_ERR_MASK_K2_E5                                         (0x1<<17) // Receiver Overflow Mask (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_REC_OVERFLOW_ERR_MASK_K2_E5_SHIFT                                   17
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_MALF_TLP_ERR_MASK_K2_E5                                             (0x1<<18) // Malformed TLP Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_MALF_TLP_ERR_MASK_K2_E5_SHIFT                                       18
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_ECRC_ERR_MASK_K2_E5                                                 (0x1<<19) // ECRC Error Mask (Optional).   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_ECRC_ERR_MASK_K2_E5_SHIFT                                           19
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_UNSUPPORTED_REQ_ERR_MASK_K2_E5                                      (0x1<<20) // Unsupported Request Error Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_UNSUPPORTED_REQ_ERR_MASK_K2_E5_SHIFT                                20
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_INTERNAL_ERR_MASK_K2_E5                                             (0x1<<22) // Uncorrectable Internal Error Mask (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_INTERNAL_ERR_MASK_K2_E5_SHIFT                                       22
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_ATOMIC_EGRESS_BLOCKED_ERR_MASK_K2_E5                                (0x1<<24) // AtomicOp Egress Block Mask (Optional).   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_ATOMIC_EGRESS_BLOCKED_ERR_MASK_K2_E5_SHIFT                          24
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_TLP_PRFX_BLOCKED_ERR_MASK_K2_E5                                     (0x1<<25) // TLP Prefix Blocked Error Mask.   Note: Not supported.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_MASK_OFF_TLP_PRFX_BLOCKED_ERR_MASK_K2_E5_SHIFT                               25
#define PCIEIP_REG_UCORR_ERR_MASK_BB                                                                         0x000108UL //Access:RW   DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
  #define PCIEIP_REG_UCORR_ERR_MASK_UNUSED0_BB                                                               (0xf<<0) // 
  #define PCIEIP_REG_UCORR_ERR_MASK_UNUSED0_BB_SHIFT                                                         0
  #define PCIEIP_REG_UCORR_ERR_MASK_DLPEM_BB                                                                 (0x1<<4) // Data Link Protocol Error Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_DLPEM_BB_SHIFT                                                           4
  #define PCIEIP_REG_UCORR_ERR_MASK_SDEM_BB                                                                  (0x1<<5) // Surprise Down Error Mask
  #define PCIEIP_REG_UCORR_ERR_MASK_SDEM_BB_SHIFT                                                            5
  #define PCIEIP_REG_UCORR_ERR_MASK_UNUSED1_BB                                                               (0x3f<<6) // 
  #define PCIEIP_REG_UCORR_ERR_MASK_UNUSED1_BB_SHIFT                                                         6
  #define PCIEIP_REG_UCORR_ERR_MASK_PTLPM_BB                                                                 (0x1<<12) // Poisoned TLP Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_PTLPM_BB_SHIFT                                                           12
  #define PCIEIP_REG_UCORR_ERR_MASK_FCPEM_BB                                                                 (0x1<<13) // Flow Control Protocol Error Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_FCPEM_BB_SHIFT                                                           13
  #define PCIEIP_REG_UCORR_ERR_MASK_CTM_BB                                                                   (0x1<<14) // Completer Timeout Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_CTM_BB_SHIFT                                                             14
  #define PCIEIP_REG_UCORR_ERR_MASK_CAM_BB                                                                   (0x1<<15) // Completer Abort Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_CAM_BB_SHIFT                                                             15
  #define PCIEIP_REG_UCORR_ERR_MASK_UCM_BB                                                                   (0x1<<16) // Unexpected Completion Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_UCM_BB_SHIFT                                                             16
  #define PCIEIP_REG_UCORR_ERR_MASK_ROM_BB                                                                   (0x1<<17) // Receiver Overflow Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_ROM_BB_SHIFT                                                             17
  #define PCIEIP_REG_UCORR_ERR_MASK_MTLPM_BB                                                                 (0x1<<18) // Malformed TLP Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_MTLPM_BB_SHIFT                                                           18
  #define PCIEIP_REG_UCORR_ERR_MASK_ECRCEM_BB                                                                (0x1<<19) // ECRC Error Mask
  #define PCIEIP_REG_UCORR_ERR_MASK_ECRCEM_BB_SHIFT                                                          19
  #define PCIEIP_REG_UCORR_ERR_MASK_UREM_BB                                                                  (0x1<<20) // Unsupported Request Error Mask.
  #define PCIEIP_REG_UCORR_ERR_MASK_UREM_BB_SHIFT                                                            20
#define PCIEIP_REG_UNCORR_ERR_SEV_OFF_K2_E5                                                                  0x00010cUL //Access:RW   DataWidth:0x20   // Uncorrectable Error Severity Register.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_DL_PROTOCOL_ERR_SEVERITY_K2_E5                                       (0x1<<4) // Data Link Protocol Error Severity.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_DL_PROTOCOL_ERR_SEVERITY_K2_E5_SHIFT                                 4
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_SUR_DWN_ERR_SEVERITY_K2_E5                                           (0x1<<5) // Surprise Down Error Severity (Optional).   Note: Not supported.  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_SUR_DWN_ERR_SEVERITY_K2_E5_SHIFT                                     5
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_POIS_TLP_ERR_SEVERITY_K2_E5                                          (0x1<<12) // Poisoned TLP Severity.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_POIS_TLP_ERR_SEVERITY_K2_E5_SHIFT                                    12
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_FC_PROTOCOL_ERR_SEVERITY_K2_E5                                       (0x1<<13) // Flow Control Protocol Error Severity (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_FC_PROTOCOL_ERR_SEVERITY_K2_E5_SHIFT                                 13
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_CMPLT_TIMEOUT_ERR_SEVERITY_K2_E5                                     (0x1<<14) // Completion Timeout Error Severity.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_CMPLT_TIMEOUT_ERR_SEVERITY_K2_E5_SHIFT                               14
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_CMPLT_ABORT_ERR_SEVERITY_K2_E5                                       (0x1<<15) // Completer Abort Error Severity (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_CMPLT_ABORT_ERR_SEVERITY_K2_E5_SHIFT                                 15
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_UNEXP_CMPLT_ERR_SEVERITY_K2_E5                                       (0x1<<16) // Unexpected Completion Error Severity.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_UNEXP_CMPLT_ERR_SEVERITY_K2_E5_SHIFT                                 16
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_REC_OVERFLOW_ERR_SEVERITY_K2_E5                                      (0x1<<17) // Receiver Overflow Error Severity (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_REC_OVERFLOW_ERR_SEVERITY_K2_E5_SHIFT                                17
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_MALF_TLP_ERR_SEVERITY_K2_E5                                          (0x1<<18) // Malformed TLP Severity.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_MALF_TLP_ERR_SEVERITY_K2_E5_SHIFT                                    18
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_ECRC_ERR_SEVERITY_K2_E5                                              (0x1<<19) // ECRC Error Severity (Optional).   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_ECRC_ERR_SEVERITY_K2_E5_SHIFT                                        19
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_UNSUPPORTED_REQ_ERR_SEVERITY_K2_E5                                   (0x1<<20) // Unsupported Request Error Severity.   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_UNSUPPORTED_REQ_ERR_SEVERITY_K2_E5_SHIFT                             20
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_INTERNAL_ERR_SEVERITY_K2_E5                                          (0x1<<22) // Uncorrectable Internal Error Severity (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_INTERNAL_ERR_SEVERITY_K2_E5_SHIFT                                    22
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_ATOMIC_EGRESS_BLOCKED_ERR_SEVERITY_K2_E5                             (0x1<<24) // AtomicOp Egress Blocked Severity (Optional).   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_ATOMIC_EGRESS_BLOCKED_ERR_SEVERITY_K2_E5_SHIFT                       24
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_TLP_PRFX_BLOCKED_ERR_SEVERITY_K2_E5                                  (0x1<<25) // TLP Prefix Blocked Error Severity (Optional).   Note: Not supported.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_UNCORR_ERR_SEV_OFF_TLP_PRFX_BLOCKED_ERR_SEVERITY_K2_E5_SHIFT                            25
#define PCIEIP_REG_UCORR_ERR_SEVR_BB                                                                         0x00010cUL //Access:RW   DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
  #define PCIEIP_REG_UCORR_ERR_SEVR_UNUSED0_BB                                                               (0xf<<0) // 
  #define PCIEIP_REG_UCORR_ERR_SEVR_UNUSED0_BB_SHIFT                                                         0
  #define PCIEIP_REG_UCORR_ERR_SEVR_DLPES_BB                                                                 (0x1<<4) // Data Link Protocol Error Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_DLPES_BB_SHIFT                                                           4
  #define PCIEIP_REG_UCORR_ERR_SEVR_SDES_BB                                                                  (0x1<<5) // Surprise Down Error Severity. Hardwire to 1'b1.
  #define PCIEIP_REG_UCORR_ERR_SEVR_SDES_BB_SHIFT                                                            5
  #define PCIEIP_REG_UCORR_ERR_SEVR_UNUSED1_BB                                                               (0x3f<<6) // 
  #define PCIEIP_REG_UCORR_ERR_SEVR_UNUSED1_BB_SHIFT                                                         6
  #define PCIEIP_REG_UCORR_ERR_SEVR_PTLPS_BB                                                                 (0x1<<12) // Poisoned TLP Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_PTLPS_BB_SHIFT                                                           12
  #define PCIEIP_REG_UCORR_ERR_SEVR_FCPES_BB                                                                 (0x1<<13) // Flow Control Protocol Error Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_FCPES_BB_SHIFT                                                           13
  #define PCIEIP_REG_UCORR_ERR_SEVR_CTS_BB                                                                   (0x1<<14) // Completer Timeout Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_CTS_BB_SHIFT                                                             14
  #define PCIEIP_REG_UCORR_ERR_SEVR_CAS_BB                                                                   (0x1<<15) // Completer Abort Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_CAS_BB_SHIFT                                                             15
  #define PCIEIP_REG_UCORR_ERR_SEVR_UCS_BB                                                                   (0x1<<16) // Unexpected Completion Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_UCS_BB_SHIFT                                                             16
  #define PCIEIP_REG_UCORR_ERR_SEVR_ROS_BB                                                                   (0x1<<17) // Receiver Overflow Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_ROS_BB_SHIFT                                                             17
  #define PCIEIP_REG_UCORR_ERR_SEVR_MTLPS_BB                                                                 (0x1<<18) // Malformed TLP Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_MTLPS_BB_SHIFT                                                           18
  #define PCIEIP_REG_UCORR_ERR_SEVR_ECRCES_BB                                                                (0x1<<19) // Ecrc error Severity
  #define PCIEIP_REG_UCORR_ERR_SEVR_ECRCES_BB_SHIFT                                                          19
  #define PCIEIP_REG_UCORR_ERR_SEVR_URES_BB                                                                  (0x1<<20) // Unsupported Request Error Severity.
  #define PCIEIP_REG_UCORR_ERR_SEVR_URES_BB_SHIFT                                                            20
#define PCIEIP_REG_CORR_ERR_STATUS_OFF_K2_E5                                                                 0x000110UL //Access:RW   DataWidth:0x20   // Correctable Error Status Register.
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_RX_ERR_STATUS_K2_E5                                                 (0x1<<0) // Receiver Error Status (Optional).
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_RX_ERR_STATUS_K2_E5_SHIFT                                           0
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_BAD_TLP_STATUS_K2_E5                                                (0x1<<6) // Bad TLP Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_BAD_TLP_STATUS_K2_E5_SHIFT                                          6
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_BAD_DLLP_STATUS_K2_E5                                               (0x1<<7) // Bad DLLP Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_BAD_DLLP_STATUS_K2_E5_SHIFT                                         7
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_REPLAY_NO_ROLEOVER_STATUS_K2_E5                                     (0x1<<8) // REPLAY_NUM Rollover Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_REPLAY_NO_ROLEOVER_STATUS_K2_E5_SHIFT                               8
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_RPL_TIMER_TIMEOUT_STATUS_K2_E5                                      (0x1<<12) // Replay Timer Timeout Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_RPL_TIMER_TIMEOUT_STATUS_K2_E5_SHIFT                                12
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_ADVISORY_NON_FATAL_ERR_STATUS_K2_E5                                 (0x1<<13) // Advisory Non-Fatal Error Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_ADVISORY_NON_FATAL_ERR_STATUS_K2_E5_SHIFT                           13
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_CORRECTED_INT_ERR_STATUS_K2_E5                                      (0x1<<14) // Corrected Internal Error Status (Optional).
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_CORRECTED_INT_ERR_STATUS_K2_E5_SHIFT                                14
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_HEADER_LOG_OVERFLOW_STATUS_K2_E5                                    (0x1<<15) // Header Log Overflow Error Status (Optional).
  #define PCIEIP_REG_CORR_ERR_STATUS_OFF_HEADER_LOG_OVERFLOW_STATUS_K2_E5_SHIFT                              15
#define PCIEIP_REG_CORR_ERR_STATUS_BB                                                                        0x000110UL //Access:RW   DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
  #define PCIEIP_REG_CORR_ERR_STATUS_RX_ERR_STATUS_BB                                                        (0x1<<0) // Receiver Error Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_RX_ERR_STATUS_BB_SHIFT                                                  0
  #define PCIEIP_REG_CORR_ERR_STATUS_UNUSED0_BB                                                              (0x1f<<1) // 
  #define PCIEIP_REG_CORR_ERR_STATUS_UNUSED0_BB_SHIFT                                                        1
  #define PCIEIP_REG_CORR_ERR_STATUS_BAD_TLP_STATUS_BB                                                       (0x1<<6) // Bad TLP Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_BAD_TLP_STATUS_BB_SHIFT                                                 6
  #define PCIEIP_REG_CORR_ERR_STATUS_BAD_DLLP_STATUS_BB                                                      (0x1<<7) // Bad DLLP Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_BAD_DLLP_STATUS_BB_SHIFT                                                7
  #define PCIEIP_REG_CORR_ERR_STATUS_RPLAY_NUM_RO_STATUS_BB                                                  (0x1<<8) // REPLAY_NUM Rollover Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_RPLAY_NUM_RO_STATUS_BB_SHIFT                                            8
  #define PCIEIP_REG_CORR_ERR_STATUS_UNUSED1_BB                                                              (0x7<<9) // 
  #define PCIEIP_REG_CORR_ERR_STATUS_UNUSED1_BB_SHIFT                                                        9
  #define PCIEIP_REG_CORR_ERR_STATUS_RPLAY_TMR_TO_STATUS_BB                                                  (0x1<<12) // Replay Timer Timeout Status.
  #define PCIEIP_REG_CORR_ERR_STATUS_RPLAY_TMR_TO_STATUS_BB_SHIFT                                            12
  #define PCIEIP_REG_CORR_ERR_STATUS_ADVSRY_ERR_STATUS_BB                                                    (0x1<<13) // Advisory Non fatal Error Status. Only set if role_based_err_rpt is asserted.
  #define PCIEIP_REG_CORR_ERR_STATUS_ADVSRY_ERR_STATUS_BB_SHIFT                                              13
#define PCIEIP_REG_CORR_ERR_MASK_OFF_K2_E5                                                                   0x000114UL //Access:RW   DataWidth:0x20   // Correctable Error Mask Register.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_RX_ERR_MASK_K2_E5                                                     (0x1<<0) // Receiver Error Mask (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_RX_ERR_MASK_K2_E5_SHIFT                                               0
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_BAD_TLP_MASK_K2_E5                                                    (0x1<<6) // Bad TLP Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_BAD_TLP_MASK_K2_E5_SHIFT                                              6
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_BAD_DLLP_MASK_K2_E5                                                   (0x1<<7) // Bad DLLP Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_BAD_DLLP_MASK_K2_E5_SHIFT                                             7
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_REPLAY_NO_ROLEOVER_MASK_K2_E5                                         (0x1<<8) // REPLAY_NUM Rollover Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_REPLAY_NO_ROLEOVER_MASK_K2_E5_SHIFT                                   8
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_RPL_TIMER_TIMEOUT_MASK_K2_E5                                          (0x1<<12) // Replay Timer Timeout Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_RPL_TIMER_TIMEOUT_MASK_K2_E5_SHIFT                                    12
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_ADVISORY_NON_FATAL_ERR_MASK_K2_E5                                     (0x1<<13) // Advisory Non-Fatal Error Mask.   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_ADVISORY_NON_FATAL_ERR_MASK_K2_E5_SHIFT                               13
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_CORRECTED_INT_ERR_MASK_K2_E5                                          (0x1<<14) // Corrected Internal Error Mask (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_CORRECTED_INT_ERR_MASK_K2_E5_SHIFT                                    14
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_HEADER_LOG_OVERFLOW_MASK_K2_E5                                        (0x1<<15) // Header Log Overflow Error Mask (Optional).   Note: This register field is sticky.
  #define PCIEIP_REG_CORR_ERR_MASK_OFF_HEADER_LOG_OVERFLOW_MASK_K2_E5_SHIFT                                  15
#define PCIEIP_REG_CORR_ERR_MASK_BB                                                                          0x000114UL //Access:RW   DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
  #define PCIEIP_REG_CORR_ERR_MASK_RES_BB                                                                    (0x1<<0) // Receiver Error Mask.
  #define PCIEIP_REG_CORR_ERR_MASK_RES_BB_SHIFT                                                              0
  #define PCIEIP_REG_CORR_ERR_MASK_UNUSED0_BB                                                                (0x1f<<1) // 
  #define PCIEIP_REG_CORR_ERR_MASK_UNUSED0_BB_SHIFT                                                          1
  #define PCIEIP_REG_CORR_ERR_MASK_BTLPS_BB                                                                  (0x1<<6) // Bad TLP Mask.
  #define PCIEIP_REG_CORR_ERR_MASK_BTLPS_BB_SHIFT                                                            6
  #define PCIEIP_REG_CORR_ERR_MASK_BDLLPS_BB                                                                 (0x1<<7) // Bad DLLP Mask.
  #define PCIEIP_REG_CORR_ERR_MASK_BDLLPS_BB_SHIFT                                                           7
  #define PCIEIP_REG_CORR_ERR_MASK_RNRS_BB                                                                   (0x1<<8) // REPLAY_NUM Rollover Mask.
  #define PCIEIP_REG_CORR_ERR_MASK_RNRS_BB_SHIFT                                                             8
  #define PCIEIP_REG_CORR_ERR_MASK_UNUSED1_BB                                                                (0x7<<9) // 
  #define PCIEIP_REG_CORR_ERR_MASK_UNUSED1_BB_SHIFT                                                          9
  #define PCIEIP_REG_CORR_ERR_MASK_RTTS_BB                                                                   (0x1<<12) // Replay Timer Timeout Mask.
  #define PCIEIP_REG_CORR_ERR_MASK_RTTS_BB_SHIFT                                                             12
  #define PCIEIP_REG_CORR_ERR_MASK_ANFM_BB                                                                   (0x1<<13) // Advisory Non fatal Error Mask
  #define PCIEIP_REG_CORR_ERR_MASK_ANFM_BB_SHIFT                                                             13
#define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_K2_E5                                                                0x000118UL //Access:RW   DataWidth:0x20   // Advanced Error Capabilities and Control Register.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_FIRST_ERR_POINTER_K2_E5                                            (0x1f<<0) // First Error Pointer.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_FIRST_ERR_POINTER_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_GEN_CAP_K2_E5                                                 (0x1<<5) // ECRC Generation Capable.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_GEN_CAP_K2_E5_SHIFT                                           5
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_GEN_EN_K2_E5                                                  (0x1<<6) // ECRC Generation Enable.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_GEN_EN_K2_E5_SHIFT                                            6
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_CHECK_CAP_K2_E5                                               (0x1<<7) // ECRC Check Capable.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_CHECK_CAP_K2_E5_SHIFT                                         7
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_CHECK_EN_K2_E5                                                (0x1<<8) // ECRC Check Enable.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_ECRC_CHECK_EN_K2_E5_SHIFT                                          8
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_MULTIPLE_HEADER_CAP_K2_E5                                          (0x1<<9) // Multiple Header Recording Capable.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_MULTIPLE_HEADER_CAP_K2_E5_SHIFT                                    9
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_MULTIPLE_HEADER_EN_K2_E5                                           (0x1<<10) // Multiple Header Recording Enable.   Note: This register field is sticky.
  #define PCIEIP_REG_ADV_ERR_CAP_CTRL_OFF_MULTIPLE_HEADER_EN_K2_E5_SHIFT                                     10
#define PCIEIP_REG_ADV_ERR_CAP_CONTROL_BB                                                                    0x000118UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_FIRST_UERR_PTR_BB                                                   (0x1f<<0) // First Error Pointer - These bits correspond to the bit position in which the first error occurred.
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_FIRST_UERR_PTR_BB_SHIFT                                             0
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCGCAP_BB                                                         (0x1<<5) // ECRC generation capable, programmable through register space
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCGCAP_BB_SHIFT                                                   5
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCGEN_BB                                                          (0x1<<6) // ECRC generate Enable
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCGEN_BB_SHIFT                                                    6
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCCAP_BB                                                          (0x1<<7) // ECRC Check Capable, programmable through register space
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCCAP_BB_SHIFT                                                    7
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCEN_BB                                                           (0x1<<8) // ECRC Check Enable
  #define PCIEIP_REG_ADV_ERR_CAP_CONTROL_ECRCEN_BB_SHIFT                                                     8
#define PCIEIP_REG_HDR_LOG_0_OFF_K2_E5                                                                       0x00011cUL //Access:R    DataWidth:0x20   // Header Log Register 0.
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_FIRST_BYTE_K2_E5                                              (0xff<<0) // Byte 0 of Header log register of First 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_FIRST_BYTE_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_SECOND_BYTE_K2_E5                                             (0xff<<8) // Byte 1 of Header log register of First 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_SECOND_BYTE_K2_E5_SHIFT                                       8
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_THIRD_BYTE_K2_E5                                              (0xff<<16) // Byte 2 of Header log register of First 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_THIRD_BYTE_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_FOURTH_BYTE_K2_E5                                             (0xff<<24) // Byte 3 of Header log register of First 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_0_OFF_FIRST_DWORD_FOURTH_BYTE_K2_E5_SHIFT                                       24
#define PCIEIP_REG_HEADER_LOG1_BB                                                                            0x00011cUL //Access:R    DataWidth:0x20   // Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
#define PCIEIP_REG_HDR_LOG_1_OFF_K2_E5                                                                       0x000120UL //Access:R    DataWidth:0x20   // Header Log Register 1.
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_FIRST_BYTE_K2_E5                                             (0xff<<0) // Byte 0 of Header log register of Second 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_FIRST_BYTE_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_SECOND_BYTE_K2_E5                                            (0xff<<8) // Byte 1 of Header log register of Second 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_SECOND_BYTE_K2_E5_SHIFT                                      8
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_THIRD_BYTE_K2_E5                                             (0xff<<16) // Byte 2 of Header log register of Second 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_THIRD_BYTE_K2_E5_SHIFT                                       16
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_FOURTH_BYTE_K2_E5                                            (0xff<<24) // Byte 3 of Header log register of Second 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_1_OFF_SECOND_DWORD_FOURTH_BYTE_K2_E5_SHIFT                                      24
#define PCIEIP_REG_HEADER_LOG2_BB                                                                            0x000120UL //Access:R    DataWidth:0x20   // Second DW of TLP header associated with Error. Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
#define PCIEIP_REG_HDR_LOG_2_OFF_K2_E5                                                                       0x000124UL //Access:R    DataWidth:0x20   // Header Log Register 2.
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_FIRST_BYTE_K2_E5                                              (0xff<<0) // Byte 0 of Header log register of Third 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_FIRST_BYTE_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_SECOND_BYTE_K2_E5                                             (0xff<<8) // Byte 1 of Header log register of Third 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_SECOND_BYTE_K2_E5_SHIFT                                       8
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_THIRD_BYTE_K2_E5                                              (0xff<<16) // Byte 2 of Header log register of Third 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_THIRD_BYTE_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_FOURTH_BYTE_K2_E5                                             (0xff<<24) // Byte 3 of Header log register of Third 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_2_OFF_THIRD_DWORD_FOURTH_BYTE_K2_E5_SHIFT                                       24
#define PCIEIP_REG_HEADER_LOG3_BB                                                                            0x000124UL //Access:R    DataWidth:0x20   // Third DW of TLP header associated with Error. Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
#define PCIEIP_REG_HDR_LOG_3_OFF_K2_E5                                                                       0x000128UL //Access:R    DataWidth:0x20   // Header Log Register 3.
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_FIRST_BYTE_K2_E5                                             (0xff<<0) // Byte 0 of Header log register of Fourth 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_FIRST_BYTE_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_SECOND_BYTE_K2_E5                                            (0xff<<8) // Byte 1 of Header log register of Fourth 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_SECOND_BYTE_K2_E5_SHIFT                                      8
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_THIRD_BYTE_K2_E5                                             (0xff<<16) // Byte 2 of Header log register of Fourth 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_THIRD_BYTE_K2_E5_SHIFT                                       16
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_FOURTH_BYTE_K2_E5                                            (0xff<<24) // Byte 3 of Header log register of Fourth 32 bit Data Word.   Note: This register field is sticky.
  #define PCIEIP_REG_HDR_LOG_3_OFF_FOURTH_DWORD_FOURTH_BYTE_K2_E5_SHIFT                                      24
#define PCIEIP_REG_HEADER_LOG4_BB                                                                            0x000128UL //Access:R    DataWidth:0x20   // Fourth DW of TLP header associated with Error. Path= i_cfg_func.i_cfg_public.i_cfg_adv_err_cap
#define PCIEIP_REG_ROOT_ERROR_COMMAND_BB                                                                     0x00012cUL //Access:R    DataWidth:0x20   // For EP this register is not applicable and hardwired to 0.
#define PCIEIP_REG_ROOT_ERROR_STATUS_BB                                                                      0x000130UL //Access:R    DataWidth:0x20   // For EP this register is not applicable and hardwired to 0.
#define PCIEIP_REG_ROOT_ERR_ID_BB                                                                            0x000134UL //Access:R    DataWidth:0x20   // For EP this register is not applicable and hardwired to 0.
#define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_K2_E5                                                                0x000138UL //Access:R    DataWidth:0x20   // TLP Prefix Log Register 1.
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_FIRST_BYTE_K2_E5                                 (0xff<<0) // Byte 0 of Error TLP Prefix Log 1.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_FIRST_BYTE_K2_E5_SHIFT                           0
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_SECOND_BYTE_K2_E5                                (0xff<<8) // Byte 1 of Error TLP Prefix Log 1.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_SECOND_BYTE_K2_E5_SHIFT                          8
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_THIRD_BYTE_K2_E5                                 (0xff<<16) // Byte 2 of Error TLP Prefix Log 1.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_THIRD_BYTE_K2_E5_SHIFT                           16
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_FOURTH_BYTE_K2_E5                                (0xff<<24) // Byte 3 of Error TLP Prefix Log 1.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_1_OFF_CFG_TLP_PFX_LOG_1_FOURTH_BYTE_K2_E5_SHIFT                          24
#define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_K2_E5                                                                0x00013cUL //Access:R    DataWidth:0x20   // TLP Prefix Log Register 2.
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_FIRST_BYTE_K2_E5                                 (0xff<<0) // Byte 0 Error TLP Prefix Log 2.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_FIRST_BYTE_K2_E5_SHIFT                           0
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_SECOND_BYTE_K2_E5                                (0xff<<8) // Byte 1 Error TLP Prefix Log 2.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_SECOND_BYTE_K2_E5_SHIFT                          8
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_THIRD_BYTE_K2_E5                                 (0xff<<16) // Byte 2 Error TLP Prefix Log 2.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_THIRD_BYTE_K2_E5_SHIFT                           16
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_FOURTH_BYTE_K2_E5                                (0xff<<24) // Byte 3 Error TLP Prefix Log 2.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_2_OFF_CFG_TLP_PFX_LOG_2_FOURTH_BYTE_K2_E5_SHIFT                          24
#define PCIEIP_REG_DEVICE_SER_NUM_CAP_BB                                                                     0x00013cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_DEVICE_SER_NUM_CAP_DEVICE_SER_NUM_CAP_ID_BB                                             (0xffff<<0) // Device Serial Number Extended Capability ID. These bits are programmable through register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_SER_NUM_CAP_DEVICE_SER_NUM_CAP_ID_BB_SHIFT                                       0
  #define PCIEIP_REG_DEVICE_SER_NUM_CAP_VER_BB                                                               (0xf<<16) // Capability ID Version. These bits are programmable through register space. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_DEVICE_SER_NUM_CAP_VER_BB_SHIFT                                                         16
  #define PCIEIP_REG_DEVICE_SER_NUM_CAP_NEXT_BB                                                              (0xfff<<20) // Next Capabilities Pointer. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_DEVICE_SER_NUM_CAP_NEXT_BB_SHIFT                                                        20
#define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_K2_E5                                                                0x000140UL //Access:R    DataWidth:0x20   // TLP Prefix Log Register 3.
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_FIRST_BYTE_K2_E5                                 (0xff<<0) // Byte 0 Error TLP Prefix Log 3.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_FIRST_BYTE_K2_E5_SHIFT                           0
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_SECOND_BYTE_K2_E5                                (0xff<<8) // Byte 1 Error TLP Prefix Log 3.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_SECOND_BYTE_K2_E5_SHIFT                          8
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_THIRD_BYTE_K2_E5                                 (0xff<<16) // Byte 2 Error TLP Prefix Log 3.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_THIRD_BYTE_K2_E5_SHIFT                           16
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_FOURTH_BYTE_K2_E5                                (0xff<<24) // Byte 3 Error TLP Prefix Log 3.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_3_OFF_CFG_TLP_PFX_LOG_3_FOURTH_BYTE_K2_E5_SHIFT                          24
#define PCIEIP_REG_LOWER_SER_NUM_BB                                                                          0x000140UL //Access:R    DataWidth:0x20   // This register has the PCIE Device Serial Number bits [31:0]. This register will contain the data written in the Device Serial Number Access Lower Register (Offset 504h). Path = i_cfg_func.i_cfg_private
#define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_K2_E5                                                                0x000144UL //Access:R    DataWidth:0x20   // TLP Prefix Log Register 4.
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_FIRST_BYTE_K2_E5                                 (0xff<<0) // Byte 0 Error TLP Prefix Log 4.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_FIRST_BYTE_K2_E5_SHIFT                           0
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_SECOND_BYTE_K2_E5                                (0xff<<8) // Byte 1 Error TLP Prefix Log 4.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_SECOND_BYTE_K2_E5_SHIFT                          8
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_THIRD_BYTE_K2_E5                                 (0xff<<16) // Byte 2 Error TLP Prefix Log 4.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_THIRD_BYTE_K2_E5_SHIFT                           16
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_FOURTH_BYTE_K2_E5                                (0xff<<24) // Byte 3 Error TLP Prefix Log 4.   Note: This register field is sticky.
  #define PCIEIP_REG_TLP_PREFIX_LOG_4_OFF_CFG_TLP_PFX_LOG_4_FOURTH_BYTE_K2_E5_SHIFT                          24
#define PCIEIP_REG_UPPER_SER_NUM_BB                                                                          0x000144UL //Access:R    DataWidth:0x20   // This register has the PCIE Device Serial Number bits [63:32]. This register will contain the data written in the Device Serial Number Access Upper Register (Offset 508h). Path = i_cfg_func.i_cfg_private
#define PCIEIP_REG_VC_BASE_K2_E5                                                                             0x000148UL //Access:RW   DataWidth:0x20   // VC Extended Capability Header.
  #define PCIEIP_REG_VC_BASE_VC_PCIE_EXTENDED_CAP_ID_K2_E5                                                   (0xffff<<0) // VC Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC_BASE_VC_PCIE_EXTENDED_CAP_ID_K2_E5_SHIFT                                             0
  #define PCIEIP_REG_VC_BASE_VC_CAP_VERSION_K2_E5                                                            (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC_BASE_VC_CAP_VERSION_K2_E5_SHIFT                                                      16
  #define PCIEIP_REG_VC_BASE_VC_NEXT_OFFSET_K2_E5                                                            (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC_BASE_VC_NEXT_OFFSET_K2_E5_SHIFT                                                      20
#define PCIEIP_REG_VC_CAPABILITIES_REG_1_K2_E5                                                               0x00014cUL //Access:RW   DataWidth:0x20   // Port VC Capability Register 1.
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_EXT_VC_CNT_K2_E5                                               (0x7<<0) // Extended VC Count.
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_EXT_VC_CNT_K2_E5_SHIFT                                         0
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_LOW_PRI_EXT_VC_CNT_K2_E5                                       (0x7<<4) // Low Priority Extended VC Count.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_LOW_PRI_EXT_VC_CNT_K2_E5_SHIFT                                 4
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_REFERENCE_CLOCK_K2_E5                                          (0x3<<8) // Reference Clock.
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_REFERENCE_CLOCK_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_PORT_ARBI_TBL_ENTRY_SIZE_K2_E5                                 (0x3<<10) // Port Arbitration Table Entry Size.
  #define PCIEIP_REG_VC_CAPABILITIES_REG_1_VC_PORT_ARBI_TBL_ENTRY_SIZE_K2_E5_SHIFT                           10
#define PCIEIP_REG_VC_CAPABILITIES_REG_2_K2_E5                                                               0x000150UL //Access:RW   DataWidth:0x20   // Port VC Capability Register 2.
  #define PCIEIP_REG_VC_CAPABILITIES_REG_2_VC_ARBI_CAP_K2_E5                                                 (0xf<<0) // VC Arbitration Capability.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_VC_CAPABILITIES_REG_2_VC_ARBI_CAP_K2_E5_SHIFT                                           0
  #define PCIEIP_REG_VC_CAPABILITIES_REG_2_VC_ARBI_TABLE_OFFSET_K2_E5                                        (0xff<<24) // VC Arbitration Table Offset.
  #define PCIEIP_REG_VC_CAPABILITIES_REG_2_VC_ARBI_TABLE_OFFSET_K2_E5_SHIFT                                  24
#define PCIEIP_REG_PWR_BDGT_CAP_BB                                                                           0x000150UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PWR_BDGT_CAP_PWR_BDGT_CAP_ID_BB                                                         (0xffff<<0) // Power Budgeting Extended Capability ID. Hardwired to 4. Path = cfg_defs
  #define PCIEIP_REG_PWR_BDGT_CAP_PWR_BDGT_CAP_ID_BB_SHIFT                                                   0
  #define PCIEIP_REG_PWR_BDGT_CAP_VER_BB                                                                     (0xf<<16) // Capability ID Version. These bits are hardwired to 1h indicating the version of the capability ID. Hardwire to 1. Path = cfg_defs
  #define PCIEIP_REG_PWR_BDGT_CAP_VER_BB_SHIFT                                                               16
  #define PCIEIP_REG_PWR_BDGT_CAP_NEXT_BB                                                                    (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. The read-only value of this register is controlled by the EXT_CAP_ENA register in the PCI register space. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_PWR_BDGT_CAP_NEXT_BB_SHIFT                                                              20
#define PCIEIP_REG_VC_STATUS_CONTROL_REG_K2_E5                                                               0x000154UL //Access:RW   DataWidth:0x20   // Port VC Control and Status Register.
  #define PCIEIP_REG_VC_STATUS_CONTROL_REG_VC_LOAD_VC_ARBI_TABLE_K2_E5                                       (0x1<<0) // Requests Hardware to Load VC Arbitration Table.
  #define PCIEIP_REG_VC_STATUS_CONTROL_REG_VC_LOAD_VC_ARBI_TABLE_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_VC_STATUS_CONTROL_REG_VC_ARBI_SELECT_K2_E5                                              (0x7<<1) // VC Arbitration Select.
  #define PCIEIP_REG_VC_STATUS_CONTROL_REG_VC_ARBI_SELECT_K2_E5_SHIFT                                        1
  #define PCIEIP_REG_VC_STATUS_CONTROL_REG_VC_ARBI_TABLE_STATUS_K2_E5                                        (0x1<<16) // VC Arbitration Table Status.
  #define PCIEIP_REG_VC_STATUS_CONTROL_REG_VC_ARBI_TABLE_STATUS_K2_E5_SHIFT                                  16
#define PCIEIP_REG_PWR_BDGT_DATA_SEL_BB                                                                      0x000154UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PWR_BDGT_DATA_SEL_DS_VALUE_BB                                                           (0xff<<0) // This value selects the value visible in the pb_dr. Path = i_cfg_func.i_cfg_public.i_cfg_pw_budget_cap
  #define PCIEIP_REG_PWR_BDGT_DATA_SEL_DS_VALUE_BB_SHIFT                                                     0
#define PCIEIP_REG_RESOURCE_CAP_REG_VC0_K2_E5                                                                0x000158UL //Access:R    DataWidth:0x20   // VC Resource Capability Register (0).
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_PORT_ARBI_CAP_VC0_K2_E5                                         (0xff<<0) // Port Arbitration Capability.
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_PORT_ARBI_CAP_VC0_K2_E5_SHIFT                                   0
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_REJECT_SNOOP_TRANS_VC0_K2_E5                                    (0x1<<15) // Reject Snoop Transactions.   Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_REJECT_SNOOP_TRANS_VC0_K2_E5_SHIFT                              15
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_MAX_TIME_SLOT_VC0_K2_E5                                         (0x3f<<16) // Maximum Time Slots-1 supported.   Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_MAX_TIME_SLOT_VC0_K2_E5_SHIFT                                   16
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_PORT_ARBI_TABLE_VC0_K2_E5                                       (0xff<<24) // Port Arbitration Table Offset.
  #define PCIEIP_REG_RESOURCE_CAP_REG_VC0_VC_PORT_ARBI_TABLE_VC0_K2_E5_SHIFT                                 24
#define PCIEIP_REG_PWR_BDGT_DATA_BB                                                                          0x000158UL //Access:R    DataWidth:0x20   // This register provides the power budgeting data for the entry number specified by the pwr_bdgt_data_sel register. The data present in this register is selected from one of the POWER BUDGET DATA ACCESS Registers from offset 510h through 52Ch, based on the value written in Power Budget Data Select register. The field definitions for each selected value are the same. Path = i_cfg_func.i_cfg_public.i_cfg_pw_budget_cap
  #define PCIEIP_REG_PWR_BDGT_DATA_BASE_PWR_BB                                                               (0xff<<0) // Base Power
  #define PCIEIP_REG_PWR_BDGT_DATA_BASE_PWR_BB_SHIFT                                                         0
  #define PCIEIP_REG_PWR_BDGT_DATA_DSCALE_BB                                                                 (0x3<<8) // Data Scale
  #define PCIEIP_REG_PWR_BDGT_DATA_DSCALE_BB_SHIFT                                                           8
  #define PCIEIP_REG_PWR_BDGT_DATA_UNUSED0_BB                                                                (0x7<<10) // 
  #define PCIEIP_REG_PWR_BDGT_DATA_UNUSED0_BB_SHIFT                                                          10
  #define PCIEIP_REG_PWR_BDGT_DATA_PM_STATE_BB                                                               (0x3<<13) // PM State
  #define PCIEIP_REG_PWR_BDGT_DATA_PM_STATE_BB_SHIFT                                                         13
  #define PCIEIP_REG_PWR_BDGT_DATA_TYPE_BB                                                                   (0x7<<15) // Type
  #define PCIEIP_REG_PWR_BDGT_DATA_TYPE_BB_SHIFT                                                             15
  #define PCIEIP_REG_PWR_BDGT_DATA_RAIL_BB                                                                   (0x7<<18) // Power rail
  #define PCIEIP_REG_PWR_BDGT_DATA_RAIL_BB_SHIFT                                                             18
#define PCIEIP_REG_RESOURCE_CON_REG_VC0_K2_E5                                                                0x00015cUL //Access:RW   DataWidth:0x20   // VC Resource Control Register (0).
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_TC_MAP_VC0_K2_E5                                                (0x1<<0) // Bit 0 of TC to VC Mapping.
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_TC_MAP_VC0_K2_E5_SHIFT                                          0
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_TC_MAP_VC0_BIT1_K2_E5                                           (0x7f<<1) // Bits 7:1 of TC to VC Mapping.
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_TC_MAP_VC0_BIT1_K2_E5_SHIFT                                     1
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_LOAD_PORT_ARBI_TABLE_VC0_K2_E5                                  (0x1<<16) // Load Port Arbitration Table.
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_LOAD_PORT_ARBI_TABLE_VC0_K2_E5_SHIFT                            16
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_PORT_ARBI_SELECT_VC0_K2_E5                                      (0x1<<17) // Port Arbitration Select.
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_PORT_ARBI_SELECT_VC0_K2_E5_SHIFT                                17
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_ID_VC_K2_E5                                                     (0x7<<24) // VC ID.
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_ID_VC_K2_E5_SHIFT                                               24
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_ENABLE_VC0_K2_E5                                                (0x1<<31) // VC Enable.
  #define PCIEIP_REG_RESOURCE_CON_REG_VC0_VC_ENABLE_VC0_K2_E5_SHIFT                                          31
#define PCIEIP_REG_PWR_BDGT_CAPABILITY_BB                                                                    0x00015cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PWR_BDGT_CAPABILITY_PCIE_CFG_PB_CAP_SYS_ALLOC_BB                                        (0x1<<0) // The "System Allocated" bit when set indicates that the power budget for the device is included within the system power budget. Reported Power Budgeting Data for this device should be ignored by software for power budgeting decisions if this bit is set. This register is Read Only. The value can be written indirectly by writing into Power Budget Capability Register (0x550[0]) Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_PWR_BDGT_CAPABILITY_PCIE_CFG_PB_CAP_SYS_ALLOC_BB_SHIFT                                  0
#define PCIEIP_REG_RESOURCE_STATUS_REG_VC0_K2_E5                                                             0x000160UL //Access:R    DataWidth:0x20   // VC Resource Status Register (0).
  #define PCIEIP_REG_RESOURCE_STATUS_REG_VC0_VC_PORT_ARBI_TABLE_STATUS_VC0_K2_E5                             (0x1<<16) // Port Arbitration Table Status.
  #define PCIEIP_REG_RESOURCE_STATUS_REG_VC0_VC_PORT_ARBI_TABLE_STATUS_VC0_K2_E5_SHIFT                       16
  #define PCIEIP_REG_RESOURCE_STATUS_REG_VC0_VC_NEGO_PENDING_VC0_K2_E5                                       (0x1<<17) // VC Negotiation Pending.
  #define PCIEIP_REG_RESOURCE_STATUS_REG_VC0_VC_NEGO_PENDING_VC0_K2_E5_SHIFT                                 17
#define PCIEIP_REG_VC_CAP_BB                                                                                 0x000160UL //Access:R    DataWidth:0x20   // The read-back value of this register is controlled by the EXT_CAP_ENA register in the PCI register space.
  #define PCIEIP_REG_VC_CAP_VC_CAP_ID_BB                                                                     (0xffff<<0) // Virtual channel Capability ID. Hardwired to 2. Path = cfg_defs
  #define PCIEIP_REG_VC_CAP_VC_CAP_ID_BB_SHIFT                                                               0
  #define PCIEIP_REG_VC_CAP_VC_CAP_VER_BB                                                                    (0xf<<16) // Capability ID Version. These bits are hardwired to 1h indicating the version of the capability ID. Hardwire to 1. Path = cfg_defs
  #define PCIEIP_REG_VC_CAP_VC_CAP_VER_BB_SHIFT                                                              16
  #define PCIEIP_REG_VC_CAP_VC_NEXT_CAP_OFF_BB                                                               (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_VC_CAP_VC_NEXT_CAP_OFF_BB_SHIFT                                                         20
#define PCIEIP_REG_PORT_VC_CAPABILITY_BB                                                                     0x000164UL //Access:R    DataWidth:0x20   // Not implemented.
#define PCIEIP_REG_SN_BASE_K2_E5                                                                             0x000168UL //Access:RW   DataWidth:0x20   // Device Serial Number Extended Capability Header.
  #define PCIEIP_REG_SN_BASE_SN_PCIE_EXTENDED_CAP_ID_K2_E5                                                   (0xffff<<0) // Serial Number Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SN_BASE_SN_PCIE_EXTENDED_CAP_ID_K2_E5_SHIFT                                             0
  #define PCIEIP_REG_SN_BASE_SN_CAP_VERSION_K2_E5                                                            (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SN_BASE_SN_CAP_VERSION_K2_E5_SHIFT                                                      16
  #define PCIEIP_REG_SN_BASE_SN_NEXT_OFFSET_K2_E5                                                            (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SN_BASE_SN_NEXT_OFFSET_K2_E5_SHIFT                                                      20
#define PCIEIP_REG_PORT_VC_CAPABILITY2_BB                                                                    0x000168UL //Access:R    DataWidth:0x20   // Not implemented.
#define PCIEIP_REG_SER_NUM_REG_DW_1_K2_E5                                                                    0x00016cUL //Access:RW   DataWidth:0x20   // Serial Number 1 Register.
#define PCIEIP_REG_PORT_VC_STATUS_CONTROL_BB                                                                 0x00016cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PORT_VC_STATUS_CONTROL_PORT_VC_CONTROL_BB                                               (0xffff<<0) // Not implemented.
  #define PCIEIP_REG_PORT_VC_STATUS_CONTROL_PORT_VC_CONTROL_BB_SHIFT                                         0
  #define PCIEIP_REG_PORT_VC_STATUS_CONTROL_PORT_VC_STATUS_BB                                                (0xffff<<16) // Not implemented.
  #define PCIEIP_REG_PORT_VC_STATUS_CONTROL_PORT_VC_STATUS_BB_SHIFT                                          16
#define PCIEIP_REG_SER_NUM_REG_DW_2_K2_E5                                                                    0x000170UL //Access:RW   DataWidth:0x20   // Serial Number 2 Register.
#define PCIEIP_REG_PORT_ARB_TABLE_BB                                                                         0x000170UL //Access:R    DataWidth:0x20   // Not implemented.
#define PCIEIP_REG_VC_RSRC_CONTROL_BB                                                                        0x000174UL //Access:RW   DataWidth:0x20   // The read-back value of this register is controlled by the EXT_CAP_ENA register in the PCI register space.
  #define PCIEIP_REG_VC_RSRC_CONTROL_DEFAULT_VC0_BB                                                          (0x1<<0) // This bit is hardwired to one because DUT is only support VC0. Path = i_cfg_func.i_cfg_public.i_cfg_vc_cap
  #define PCIEIP_REG_VC_RSRC_CONTROL_DEFAULT_VC0_BB_SHIFT                                                    0
  #define PCIEIP_REG_VC_RSRC_CONTROL_TC_VC_MAP_BB                                                            (0x7f<<1) // This field indicates the TCs that are mapped to the VC resource. This field is valid for all devices. Note: Bit 0 of this field is read only. It is set to 1 for the default VC0. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_VC_RSRC_CONTROL_TC_VC_MAP_BB_SHIFT                                                      1
  #define PCIEIP_REG_VC_RSRC_CONTROL_UNUSED0_BB                                                              (0x7fffff<<8) // 
  #define PCIEIP_REG_VC_RSRC_CONTROL_UNUSED0_BB_SHIFT                                                        8
  #define PCIEIP_REG_VC_RSRC_CONTROL_VC_ENABLE_BB                                                            (0x1<<31) // Enables virtual channel. This bit is hardwired to 1 for the default VC0 and writing to this filed has no effect. Path = i_cfg_func.i_cfg_public.i_cfg_vc_cap
  #define PCIEIP_REG_VC_RSRC_CONTROL_VC_ENABLE_BB_SHIFT                                                      31
#define PCIEIP_REG_PB_BASE_K2_E5                                                                             0x000178UL //Access:RW   DataWidth:0x20   // Power Budgeting Extended Capability Header.
  #define PCIEIP_REG_PB_BASE_PB_PCIE_EXTENDED_CAP_ID_K2_E5                                                   (0xffff<<0) // PB Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PB_BASE_PB_PCIE_EXTENDED_CAP_ID_K2_E5_SHIFT                                             0
  #define PCIEIP_REG_PB_BASE_PB_CAP_VERSION_K2_E5                                                            (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PB_BASE_PB_CAP_VERSION_K2_E5_SHIFT                                                      16
  #define PCIEIP_REG_PB_BASE_PB_NEXT_OFFSET_K2_E5                                                            (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PB_BASE_PB_NEXT_OFFSET_K2_E5_SHIFT                                                      20
#define PCIEIP_REG_VC_RSRC_STATUS_BB                                                                         0x000178UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_VC_RSRC_STATUS_UNUSED0_BB                                                               (0xffff<<0) // 
  #define PCIEIP_REG_VC_RSRC_STATUS_UNUSED0_BB_SHIFT                                                         0
  #define PCIEIP_REG_VC_RSRC_STATUS_VC_RSRC_STATUS_BB                                                        (0xffff<<16) // Not implemented.
  #define PCIEIP_REG_VC_RSRC_STATUS_VC_RSRC_STATUS_BB_SHIFT                                                  16
#define PCIEIP_REG_PB_DATA_SELECT_K2_E5                                                                      0x00017cUL //Access:RW   DataWidth:0x20   // Data select Register.
  #define PCIEIP_REG_PB_DATA_SELECT_PB_DATA_SEL_K2_E5                                                        (0xff<<0) // Data Select Register.
  #define PCIEIP_REG_PB_DATA_SELECT_PB_DATA_SEL_K2_E5_SHIFT                                                  0
#define PCIEIP_REG_DATA_REG_PB_K2_E5                                                                         0x000180UL //Access:R    DataWidth:0x20   // Data Register.
  #define PCIEIP_REG_DATA_REG_PB_PB_BASE_POWER_K2_E5                                                         (0xff<<0) // Base Power.
  #define PCIEIP_REG_DATA_REG_PB_PB_BASE_POWER_K2_E5_SHIFT                                                   0
  #define PCIEIP_REG_DATA_REG_PB_PB_DATA_SCALE_K2_E5                                                         (0x3<<8) // Data Scale.
  #define PCIEIP_REG_DATA_REG_PB_PB_DATA_SCALE_K2_E5_SHIFT                                                   8
  #define PCIEIP_REG_DATA_REG_PB_PB_PM_SUB_STATE_K2_E5                                                       (0x7<<10) // PM Sub State.
  #define PCIEIP_REG_DATA_REG_PB_PB_PM_SUB_STATE_K2_E5_SHIFT                                                 10
  #define PCIEIP_REG_DATA_REG_PB_PB_PM_STATE_K2_E5                                                           (0x3<<13) // PM State.
  #define PCIEIP_REG_DATA_REG_PB_PB_PM_STATE_K2_E5_SHIFT                                                     13
  #define PCIEIP_REG_DATA_REG_PB_PB_TYPE_K2_E5                                                               (0x7<<15) // Type of Operating Condition.
  #define PCIEIP_REG_DATA_REG_PB_PB_TYPE_K2_E5_SHIFT                                                         15
  #define PCIEIP_REG_DATA_REG_PB_PB_POWER_RAIL_STATE_K2_E5                                                   (0x7<<18) // Power Rail State.
  #define PCIEIP_REG_DATA_REG_PB_PB_POWER_RAIL_STATE_K2_E5_SHIFT                                             18
#define PCIEIP_REG_VENDOR_CAP_BB                                                                             0x000180UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 0 of the EXT_CAP_ENA for EP, or setting bit 0 of RC_EXT_CAP_ENA for RC. By default, this capability is disabled (i.e. reading this register will return zeroes). The capability can be enabled by default by defining VendorCapOn in version.v. When supporting SRIOV, this capability is enabled if PCIE_VF_BAR_STRIDE is defined in version.v
  #define PCIEIP_REG_VENDOR_CAP_VENDOR_SPEC_CAP_ID_BB                                                        (0xffff<<0) // Vendor Specific Extended Capability ID. Hardwired to 0xB. Path = cfg_defs
  #define PCIEIP_REG_VENDOR_CAP_VENDOR_SPEC_CAP_ID_BB_SHIFT                                                  0
  #define PCIEIP_REG_VENDOR_CAP_CAP_VER_BB                                                                   (0xf<<16) // Vendor Specific Extended Capability version. Hardwired to 0x1. Path = cfg_defs
  #define PCIEIP_REG_VENDOR_CAP_CAP_VER_BB_SHIFT                                                             16
  #define PCIEIP_REG_VENDOR_CAP_NEXT_BB                                                                      (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability. Path = i_cfg_func.i_cfg_public.i_cfg_ep_reg
  #define PCIEIP_REG_VENDOR_CAP_NEXT_BB_SHIFT                                                                20
#define PCIEIP_REG_CAP_REG_PB_K2_E5                                                                          0x000184UL //Access:RW   DataWidth:0x20   // Power Budget Capability Register.
  #define PCIEIP_REG_CAP_REG_PB_PB_SYS_ALLOC_K2_E5                                                           (0x1<<0) // System Allocated PB.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAP_REG_PB_PB_SYS_ALLOC_K2_E5_SHIFT                                                     0
#define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_BB                                                                 0x000184UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 0 of the EXT_CAP_ENA for EP, or setting bit 0 of RC_EXT_CAP_ENA for RC. By default, this capability is disabled (i.e. reading this register will return zeroes). The capability can be enabled by default by defining VendorCapOn in version.v
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_VSEC_ID_BB                                                       (0xffff<<0) // VSEC ID. This field is a vendor-defined ID number that indicates the nature and format of the VSEC structure. Software must qualify the Vendor ID before interpreting this field. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_VSEC_ID_BB_SHIFT                                                 0
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_VSEC_REV_BB                                                      (0xf<<16) // VSEC Rev. This field is a vendor-defined version number that indicates the version of the VSEC structure. Software must qualify the Vendor ID and VSEC ID before interpreting this field. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_VSEC_REV_BB_SHIFT                                                16
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_VSEC_LENGTH_BB                                                   (0xfff<<20) // VSEC Length. This field indicates the number of bytes in the entire VSEC structure, including the PCI Express Enhanced Capability header, the Vendor-Specific header, and the Vendor-Specific Registers. Path = i_cfg_func.i_cfg_private
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_VSEC_LENGTH_BB_SHIFT                                             20
#define PCIEIP_REG_ARI_BASE_K2_E5                                                                            0x000188UL //Access:RW   DataWidth:0x20   // ARI Capability Header.
  #define PCIEIP_REG_ARI_BASE_ARI_PCIE_EXTENDED_CAP_ID_K2_E5                                                 (0xffff<<0) // ARI Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_ARI_BASE_ARI_PCIE_EXTENDED_CAP_ID_K2_E5_SHIFT                                           0
  #define PCIEIP_REG_ARI_BASE_ARI_CAP_VERSION_K2_E5                                                          (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_ARI_BASE_ARI_CAP_VERSION_K2_E5_SHIFT                                                    16
  #define PCIEIP_REG_ARI_BASE_ARI_NEXT_OFFSET_K2_E5                                                          (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_ARI_BASE_ARI_NEXT_OFFSET_K2_E5_SHIFT                                                    20
#define PCIEIP_REG_VENDOR_SPECIFIC_REG1_BB                                                                   0x000188UL //Access:RW   DataWidth:0x20   // If bit 0 of the EXT_CAP_ENA for EP or bit 0 of RC_EXT_CAP_ENA for RC is reset to '0', reading this register will return all 0's. By default, this capability is disabled (i.e. reading this register will return zeroes). The capability can be enabled by default by defining VendorCapOn or PCIE_VF_BAR_STRIDE in version.v
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG1_VF_BAR0_STRIDE_BITS_BB                                             (0x7fffffff<<0) // This field defines alignment and stride of VF BAR0 address space. The bits are a power of 2 value that multiplies the PF VF Bar0 value to compute the starting address and alignment of the BAR0 for each VF. This field may only have 1 bit set.This field is ignored when bit 31 is 0.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG1_VF_BAR0_STRIDE_BITS_BB_SHIFT                                       0
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG1_VF_BAR0_STRIDE_EN_BB                                               (0x1<<31) // Enable VF Bar0 Stride. When this bit bit is clear, computation of the VF BAR0 offset from the PF SRIOV capability structure is unchanged.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG1_VF_BAR0_STRIDE_EN_BB_SHIFT                                         31
#define PCIEIP_REG_CAP_REG_K2_E5                                                                             0x00018cUL //Access:R    DataWidth:0x20   // ARI Capability and Control Register.
  #define PCIEIP_REG_CAP_REG_ARI_MFVC_FUN_GRP_CAP_K2_E5                                                      (0x1<<0) // Multi Functional Virtual Channel (MFVC) Function Groups Capability.
  #define PCIEIP_REG_CAP_REG_ARI_MFVC_FUN_GRP_CAP_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_CAP_REG_ARI_ACS_FUN_GRP_CAP_K2_E5                                                       (0x1<<1) // ACS Function Groups Capability.
  #define PCIEIP_REG_CAP_REG_ARI_ACS_FUN_GRP_CAP_K2_E5_SHIFT                                                 1
  #define PCIEIP_REG_CAP_REG_ARI_NEXT_FUN_NUM_K2_E5                                                          (0xff<<8) // Next Function Number.
  #define PCIEIP_REG_CAP_REG_ARI_NEXT_FUN_NUM_K2_E5_SHIFT                                                    8
  #define PCIEIP_REG_CAP_REG_ARI_MFVC_FUN_GRP_EN_K2_E5                                                       (0x1<<16) // MFVC Function Groups Enable.
  #define PCIEIP_REG_CAP_REG_ARI_MFVC_FUN_GRP_EN_K2_E5_SHIFT                                                 16
  #define PCIEIP_REG_CAP_REG_ARI_ACS_FUN_GRP_EN_K2_E5                                                        (0x1<<17) // ACS Function Groups Enable.
  #define PCIEIP_REG_CAP_REG_ARI_ACS_FUN_GRP_EN_K2_E5_SHIFT                                                  17
  #define PCIEIP_REG_CAP_REG_ARI_FUN_GRP_K2_E5                                                               (0x7<<20) // Function Group.
  #define PCIEIP_REG_CAP_REG_ARI_FUN_GRP_K2_E5_SHIFT                                                         20
#define PCIEIP_REG_VENDOR_SPECIFIC_REG2_BB                                                                   0x00018cUL //Access:R    DataWidth:0x20   // 
#define PCIEIP_REG_VENDOR_SPECIFIC_REG3_BB                                                                   0x000190UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG3_VF_BAR2_STRIDE_BITS_BB                                             (0x7fffffff<<0) // This field defines alignment and stride of VF BAR2 address space. The bits are a power of 2 value that multiplies the PF VF Bar2 value to compute the starting address and alignment of the BAR2 for each VF. This field may only have 1 bit set.This field is ignored when bit 31 is 0.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG3_VF_BAR2_STRIDE_BITS_BB_SHIFT                                       0
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG3_VF_BAR2_STRIDE_EN_BB                                               (0x1<<31) // Enable VF Bar2 Stride. When this bit bit is clear, computation of the VF BAR2 offset from the PF SRIOV capability structure is unchanged.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG3_VF_BAR2_STRIDE_EN_BB_SHIFT                                         31
#define PCIEIP_REG_VENDOR_SPECIFIC_REG4_BB                                                                   0x000194UL //Access:R    DataWidth:0x20   // 
#define PCIEIP_REG_SPCIE_CAP_HEADER_REG_K2_E5                                                                0x000198UL //Access:RW   DataWidth:0x20   // SPCIE Capability Header.
  #define PCIEIP_REG_SPCIE_CAP_HEADER_REG_EXTENDED_CAP_ID_K2_E5                                              (0xffff<<0) // Secondary PCI Express Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SPCIE_CAP_HEADER_REG_EXTENDED_CAP_ID_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_SPCIE_CAP_HEADER_REG_CAP_VERSION_K2_E5                                                  (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SPCIE_CAP_HEADER_REG_CAP_VERSION_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_SPCIE_CAP_HEADER_REG_NEXT_OFFSET_K2_E5                                                  (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SPCIE_CAP_HEADER_REG_NEXT_OFFSET_K2_E5_SHIFT                                            20
#define PCIEIP_REG_VENDOR_SPECIFIC_REG5_BB                                                                   0x000198UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG5_VF_BAR4_STRIDE_BITS_BB                                             (0x7fffffff<<0) // This field defines alignment and stride of VF BAR4 address space. The bits are a power of 2 value that multiplies the PF VF Bar4 value to compute the starting address and alignment of the BAR4 for each VF. This field may only have 1 bit set.This field is ignored when bit 31 is 0.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG5_VF_BAR4_STRIDE_BITS_BB_SHIFT                                       0
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG5_VF_BAR4_STRIDE_EN_BB                                               (0x1<<31) // Enable VF Bar4 Stride. When this bit bit is clear, computation of the VF BAR4 offset from the PF SRIOV capability structure is unchanged.
  #define PCIEIP_REG_VENDOR_SPECIFIC_REG5_VF_BAR4_STRIDE_EN_BB_SHIFT                                         31
#define PCIEIP_REG_LINK_CONTROL3_REG_K2_E5                                                                   0x00019cUL //Access:R    DataWidth:0x20   // Link Control 3 Register.
  #define PCIEIP_REG_LINK_CONTROL3_REG_PERFORM_EQ_K2_E5                                                      (0x1<<0) // Perform Equalization.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_LINK_CONTROL3_REG_PERFORM_EQ_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_LINK_CONTROL3_REG_EQ_REQ_INT_EN_K2_E5                                                   (0x1<<1) // Link Equalization Request Interrupt Enable.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_LINK_CONTROL3_REG_EQ_REQ_INT_EN_K2_E5_SHIFT                                             1
#define PCIEIP_REG_LANE_ERR_STATUS_REG_K2_E5                                                                 0x0001a0UL //Access:RW   DataWidth:0x20   // Lane Error Status Register.
  #define PCIEIP_REG_LANE_ERR_STATUS_REG_LANE_ERR_STATUS_K2_E5                                               (0xff<<0) // Lane Error Status Bits per Lane.
  #define PCIEIP_REG_LANE_ERR_STATUS_REG_LANE_ERR_STATUS_K2_E5_SHIFT                                         0
#define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_K2_E5                                                               0x0001a4UL //Access:R    DataWidth:0x20   // Lane Equalization Control Register for lanes 1 and 0.
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_TX_PRESET0_K2_E5                                              (0xf<<0) // Downstream Port 8.0 GT/s Transmitter Preset 0.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_TX_PRESET0_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_RX_PRESET_HINT0_K2_E5                                         (0x7<<4) // Downstream Port 8.0 GT/s Receiver Preset Hint 0.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_RX_PRESET_HINT0_K2_E5_SHIFT                                   4
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_TX_PRESET0_K2_E5                                              (0xf<<8) // Upstream Port 8.0 GT/s Transmitter Preset 0.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_TX_PRESET0_K2_E5_SHIFT                                        8
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_RX_PRESET_HINT0_K2_E5                                         (0x7<<12) // Upstream Port 8.0 GT/s Receiver Preset Hint 0.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_RX_PRESET_HINT0_K2_E5_SHIFT                                   12
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_TX_PRESET1_K2_E5                                              (0xf<<16) // Downstream Port 8.0 GT/s Transmitter Preset 1.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_TX_PRESET1_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_RX_PRESET_HINT1_K2_E5                                         (0x7<<20) // Downstream Port 8.0 GT/s Receiver Preset Hint 1.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_DSP_RX_PRESET_HINT1_K2_E5_SHIFT                                   20
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_TX_PRESET1_K2_E5                                              (0xf<<24) // Upstream Port 8.0 GT/s Transmitter Preset 1.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_TX_PRESET1_K2_E5_SHIFT                                        24
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_RX_PRESET_HINT1_K2_E5                                         (0x7<<28) // Upstream Port 8.0 GT/s Receiver Preset Hint 1.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_0CH_REG_USP_RX_PRESET_HINT1_K2_E5_SHIFT                                   28
#define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_K2_E5                                                               0x0001a8UL //Access:R    DataWidth:0x20   // Lane Equalization Control Register (LEC) or Lane Equalization Control Register 2 (LEC2) #2. The function of this register is dependent on your actual configuration.  - Gen3: LEC or RSVD depending on the value of CX_NL.  - Gen4: LEC or LEC2 or RSVD depending on the value of CX_NL.
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_TX_PRESET2_K2_E5                                              (0xf<<0) // Downstream Port 8.0 GT/s Transmitter Preset2.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_TX_PRESET2_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_RX_PRESET_HINT2_K2_E5                                         (0x7<<4) // Downstream Port 8.0 GT/s Receiver Preset Hint2.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_RX_PRESET_HINT2_K2_E5_SHIFT                                   4
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_TX_PRESET2_K2_E5                                              (0xf<<8) // Upstream Port 8.0 GT/s Transmitter Preset2.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_TX_PRESET2_K2_E5_SHIFT                                        8
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_RX_PRESET_HINT2_K2_E5                                         (0x7<<12) // Upstream Port 8.0 GT/s Receiver Preset Hint2.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_RX_PRESET_HINT2_K2_E5_SHIFT                                   12
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_TX_PRESET3_K2_E5                                              (0xf<<16) // Downstream Port 8.0 GT/s Transmitter Preset3.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_TX_PRESET3_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_RX_PRESET_HINT3_K2_E5                                         (0x7<<20) // Downstream Port 8.0 GT/s Receiver Preset Hint3.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_DSP_RX_PRESET_HINT3_K2_E5_SHIFT                                   20
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_TX_PRESET3_K2_E5                                              (0xf<<24) // Upstream Port 8.0 GT/s Transmitter Preset3.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_TX_PRESET3_K2_E5_SHIFT                                        24
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_RX_PRESET_HINT3_K2_E5                                         (0x7<<28) // Upstream Port 8.0 GT/s Receiver Preset Hint3.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_10H_REG_USP_RX_PRESET_HINT3_K2_E5_SHIFT                                   28
#define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_K2_E5                                                               0x0001acUL //Access:R    DataWidth:0x20   // Lane Equalization Control Register (LEC) or Lane Equalization Control Register 2 (LEC2) #4. The function of this register is dependent on your actual configuration.  - Gen3: LEC or RSVD depending on the value of CX_NL.  - Gen4: LEC or LEC2 or RSVD depending on the value of CX_NL.
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_TX_PRESET4_K2_E5                                              (0xf<<0) // Downstream Port 8.0 GT/s Transmitter Preset4.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_TX_PRESET4_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_RX_PRESET_HINT4_K2_E5                                         (0x7<<4) // Downstream Port 8.0 GT/s Receiver Preset Hint4.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_RX_PRESET_HINT4_K2_E5_SHIFT                                   4
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_TX_PRESET4_K2_E5                                              (0xf<<8) // Upstream Port 8.0 GT/s Transmitter Preset4.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_TX_PRESET4_K2_E5_SHIFT                                        8
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_RX_PRESET_HINT4_K2_E5                                         (0x7<<12) // Upstream Port 8.0 GT/s Receiver Preset Hint4.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_RX_PRESET_HINT4_K2_E5_SHIFT                                   12
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_TX_PRESET5_K2_E5                                              (0xf<<16) // Downstream Port 8.0 GT/s Transmitter Preset5.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_TX_PRESET5_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_RX_PRESET_HINT5_K2_E5                                         (0x7<<20) // Downstream Port 8.0 GT/s Receiver Preset Hint5.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_DSP_RX_PRESET_HINT5_K2_E5_SHIFT                                   20
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_TX_PRESET5_K2_E5                                              (0xf<<24) // Upstream Port 8.0 GT/s Transmitter Preset5.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_TX_PRESET5_K2_E5_SHIFT                                        24
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_RX_PRESET_HINT5_K2_E5                                         (0x7<<28) // Upstream Port 8.0 GT/s Receiver Preset Hint5.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_14H_REG_USP_RX_PRESET_HINT5_K2_E5_SHIFT                                   28
#define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_K2_E5                                                               0x0001b0UL //Access:R    DataWidth:0x20   // Lane Equalization Control Register (LEC) or Lane Equalization Control Register 2 (LEC2) #6. The function of this register is dependent on your actual configuration.  - Gen3: LEC or RSVD depending on the value of CX_NL.  - Gen4: LEC or LEC2 or RSVD depending on the value of CX_NL.
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_TX_PRESET6_K2_E5                                              (0xf<<0) // Downstream Port 8.0 GT/s Transmitter Preset6.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_TX_PRESET6_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_RX_PRESET_HINT6_K2_E5                                         (0x7<<4) // Downstream Port 8.0 GT/s Receiver Preset Hint6.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_RX_PRESET_HINT6_K2_E5_SHIFT                                   4
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_TX_PRESET6_K2_E5                                              (0xf<<8) // Upstream Port 8.0 GT/s Transmitter Preset6.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_TX_PRESET6_K2_E5_SHIFT                                        8
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_RX_PRESET_HINT6_K2_E5                                         (0x7<<12) // Upstream Port 8.0 GT/s Receiver Preset Hint6.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_RX_PRESET_HINT6_K2_E5_SHIFT                                   12
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_TX_PRESET7_K2_E5                                              (0xf<<16) // Downstream Port 8.0 GT/s Transmitter Preset7.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_TX_PRESET7_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_RX_PRESET_HINT7_K2_E5                                         (0x7<<20) // Downstream Port 8.0 GT/s Receiver Preset Hint7.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_DSP_RX_PRESET_HINT7_K2_E5_SHIFT                                   20
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_TX_PRESET7_K2_E5                                              (0xf<<24) // Upstream Port 8.0 GT/s Transmitter Preset7.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_TX_PRESET7_K2_E5_SHIFT                                        24
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_RX_PRESET_HINT7_K2_E5                                         (0x7<<28) // Upstream Port 8.0 GT/s Receiver Preset Hint7.  The write value is gated with the PCIE_CAP_CROSS_LINK_SUPPORT field of LINK_CAPABILITIES2_REG.   Note: The access attributes of this field are as follows:  - Dbi: DSP || USP && PCIE_CAP_CROSS_LINK_SUPPORT ? (if (DBI_RO_WR_EN == 1) then R/W (sticky) else R) : ROS
  #define PCIEIP_REG_SPCIE_CAP_OFF_18H_REG_USP_RX_PRESET_HINT7_K2_E5_SHIFT                                   28
#define PCIEIP_REG_LTR_CAP_BB                                                                                0x0001b0UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 5 of the EXT_CAP_ENA for EP, By default, this capability is disabled (i.e. reading this register will return zeroes). The capability can be enabled by default by defining LTR_ENABLED in version.v and setting bit 5 of EXT_CAP_ENA. This capability when present , will only exist in function 0 of a multi-function device.
  #define PCIEIP_REG_LTR_CAP_LTR_EXT_CAP_ID_BB                                                               (0xffff<<0) // Vendor Specific Extended Capability ID.
  #define PCIEIP_REG_LTR_CAP_LTR_EXT_CAP_ID_BB_SHIFT                                                         0
  #define PCIEIP_REG_LTR_CAP_CAP_VER_BB                                                                      (0xf<<16) // LTR Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_LTR_CAP_CAP_VER_BB_SHIFT                                                                16
  #define PCIEIP_REG_LTR_CAP_NEXT_BB                                                                         (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_LTR_CAP_NEXT_BB_SHIFT                                                                   20
#define PCIEIP_REG_LATENCY_REGISTER_BB                                                                       0x0001b4UL //Access:RW   DataWidth:0x20   // The RW value of this register is controlled by setting bit 5 of the EXT_CAP_ENA for EP. By default, this capability is disabled (i.e. reading this register will return zeroes).
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_SNOOP_LATE_VALUE_BB                                                (0x3ff<<0) // Max Snoop Latency Value. Along with Max snoop latency scale field, this register specifies the maximum no-snoop latency that a device is premitted to request. Software should set this to the platforms max supported latency or less.
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_SNOOP_LATE_VALUE_BB_SHIFT                                          0
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_SNOOP_LATE_SCALE_BB                                                (0x7<<10) // Max Snoop Latency Scale. This register provides a scale for the value contained within the max_snoop_late_value field.
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_SNOOP_LATE_SCALE_BB_SHIFT                                          10
  #define PCIEIP_REG_LATENCY_REGISTER_UNUSED0_BB                                                             (0x7<<13) // 
  #define PCIEIP_REG_LATENCY_REGISTER_UNUSED0_BB_SHIFT                                                       13
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_NO_SNOOP_LATE_VALUE_BB                                             (0x3ff<<16) // Max No Snoop Latency Value. Along with Max No snoop latency scale field, this register specifies the maximum no-snoop latency that a device is premitted to request. Software should set this to the platforms max supported latency or less.
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_NO_SNOOP_LATE_VALUE_BB_SHIFT                                       16
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_NO_SNOOP_LATE_SCALE_BB                                             (0x7<<26) // Max No Snoop Latency Scale. This register provides a scale for the value contained within the max_no_snoop_late_value field.
  #define PCIEIP_REG_LATENCY_REGISTER_MAX_NO_SNOOP_LATE_SCALE_BB_SHIFT                                       26
#define PCIEIP_REG_SRIOV_BASE_REG_K2_E5                                                                      0x0001b8UL //Access:RW   DataWidth:0x20   // SR-IOV Capability Header. For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_SRIOV_BASE_REG_SRIOV_PCIE_EXTENDED_CAP_ID_K2_E5                                         (0xffff<<0) // SRIOV Extended Capability ID. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SRIOV_BASE_REG_SRIOV_PCIE_EXTENDED_CAP_ID_K2_E5_SHIFT                                   0
  #define PCIEIP_REG_SRIOV_BASE_REG_SRIOV_CAP_VERSION_K2_E5                                                  (0xf<<16) // Capability Version. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SRIOV_BASE_REG_SRIOV_CAP_VERSION_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_SRIOV_BASE_REG_SRIOV_NEXT_OFFSET_K2_E5                                                  (0xfff<<20) // Next Capability Offset. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SRIOV_BASE_REG_SRIOV_NEXT_OFFSET_K2_E5_SHIFT                                            20
#define PCIEIP_REG_ARI_CAP_BB                                                                                0x0001b8UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 6 of the EXT_CAP_ENA for EP, The capability can be enabled by default by defining SRIOV in version.v .
  #define PCIEIP_REG_ARI_CAP_ARI_EXT_CAP_ID_BB                                                               (0xffff<<0) // ARI Extended Capability ID. Hardwired to 0xE.
  #define PCIEIP_REG_ARI_CAP_ARI_EXT_CAP_ID_BB_SHIFT                                                         0
  #define PCIEIP_REG_ARI_CAP_CAP_VER_BB                                                                      (0xf<<16) // ARI Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_ARI_CAP_CAP_VER_BB_SHIFT                                                                16
  #define PCIEIP_REG_ARI_CAP_NEXT_BB                                                                         (0xfff<<20) // 
  #define PCIEIP_REG_ARI_CAP_NEXT_BB_SHIFT                                                                   20
#define PCIEIP_REG_CAPABILITIES_REG_K2_E5                                                                    0x0001bcUL //Access:RW   DataWidth:0x20   // SR-IOV Capability Register. For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_CAPABILITIES_REG_SRIOV_VF_MIGRATION_CAP_K2_E5                                           (0x1<<0) // VF Migration Capable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_CAPABILITIES_REG_SRIOV_VF_MIGRATION_CAP_K2_E5_SHIFT                                     0
  #define PCIEIP_REG_CAPABILITIES_REG_SRIOV_ARI_CAP_HIER_PRESERVED_K2_E5                                     (0x1<<1) // ARI Capable Hierarchy Preserved. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_CAPABILITIES_REG_SRIOV_ARI_CAP_HIER_PRESERVED_K2_E5_SHIFT                               1
  #define PCIEIP_REG_CAPABILITIES_REG_SRIOV_VF_MIGRATION_INT_MSG_NUM_K2_E5                                   (0x3ff<<21) // VF Migration Interrupt Message Number. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_CAPABILITIES_REG_SRIOV_VF_MIGRATION_INT_MSG_NUM_K2_E5_SHIFT                             21
#define PCIEIP_REG_ARI_CONTROL_REGISTER_BB                                                                   0x0001bcUL //Access:R    DataWidth:0x20   // The RW value of this register is controlled by setting bit 6 of the EXT_CAP_ENA for EP. By default, this capability is disabled (i.e. reading this register will return zeroes).
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_MFVC_FUNC_GROUP_CAP_BB                                             (0x1<<0) // Hardwired to 0
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_MFVC_FUNC_GROUP_CAP_BB_SHIFT                                       0
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_ACS_FUNC_GROUP_CAP_BB                                              (0x1<<1) // Hardwired to 0
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_ACS_FUNC_GROUP_CAP_BB_SHIFT                                        1
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_UNUSED0_BB                                                         (0x3f<<2) // 
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_UNUSED0_BB_SHIFT                                                   2
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_NEXT_FUNCTION_NUMBER_BB                                            (0xff<<8) // Next Function Number. This field indicates the function number of the next higher numbered function in device. Value reflects programming in ARI_CAP(0x5FC) private register.
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_NEXT_FUNCTION_NUMBER_BB_SHIFT                                      8
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_ARI_CTRL_BB                                                        (0xffff<<16) // Field is unused and is hardwired to 0.
  #define PCIEIP_REG_ARI_CONTROL_REGISTER_ARI_CTRL_BB_SHIFT                                                  16
#define PCIEIP_REG_STATUS_CONTROL_REG_K2_E5                                                                  0x0001c0UL //Access:RW   DataWidth:0x20   // SR-IOV Control and Status Register. For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_ENABLE_K2_E5                                                (0x1<<0) // VF Enable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_ENABLE_K2_E5_SHIFT                                          0
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_MIGRATION_ENABLE_K2_E5                                      (0x1<<1) // VF Migration Enable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_MIGRATION_ENABLE_K2_E5_SHIFT                                1
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_MIGRATION_INT_ENABLE_K2_E5                                  (0x1<<2) // VF Migration Interrupt Enable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_MIGRATION_INT_ENABLE_K2_E5_SHIFT                            2
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_MSE_K2_E5                                                   (0x1<<3) // VF Memory Space Enable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_VF_MSE_K2_E5_SHIFT                                             3
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_ARI_CAPABLE_HIER_K2_E5                                         (0x1<<4) // ARI Capable Hierarchy (Applies to endpoint only). For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W but read-value is not always same as write-value
  #define PCIEIP_REG_STATUS_CONTROL_REG_SRIOV_ARI_CAPABLE_HIER_K2_E5_SHIFT                                   4
#define PCIEIP_REG_SRIOV_CAP_BB                                                                              0x0001c0UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 7 of the EXT_CAP_ENA for EP, The capability can be enabled by default by defining SRIOV in version.v .
  #define PCIEIP_REG_SRIOV_CAP_SRIOV_EXT_CAP_ID_BB                                                           (0xffff<<0) // SRIOV Extended Capability ID. Hardwired to 0xE.
  #define PCIEIP_REG_SRIOV_CAP_SRIOV_EXT_CAP_ID_BB_SHIFT                                                     0
  #define PCIEIP_REG_SRIOV_CAP_SRCAP_VER_BB                                                                  (0xf<<16) // SRIOV Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_SRIOV_CAP_SRCAP_VER_BB_SHIFT                                                            16
  #define PCIEIP_REG_SRIOV_CAP_NEXT_BB                                                                       (0xfff<<20) // 
  #define PCIEIP_REG_SRIOV_CAP_NEXT_BB_SHIFT                                                                 20
#define PCIEIP_REG_SRIOV_INITIAL_VFS_K2_E5                                                                   0x0001c4UL //Access:RW   DataWidth:0x20   // TotalVFs InitialVFs Register. For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_SRIOV_INITIAL_VFS_SRIOV_INITIAL_VFS_K2_E5                                               (0xffff<<0) // InitialVFs. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. There are two InitialVFs registers; one each for ARI Capable and non-ARI Capable Hierarchies. The "ARI Capable Hierarchy" bit (SRIOV_ARI_CAPABLE_HIER) of the PF0 "SR-IOV Control Register" (STATUS_CONTROL_REG) determines which one is used by the core when SR-IOV is being used, and which one is accessed by a read request. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SRIOV_INITIAL_VFS_SRIOV_INITIAL_VFS_K2_E5_SHIFT                                         0
  #define PCIEIP_REG_SRIOV_INITIAL_VFS_SRIOV_TOTAL_VFS_K2_E5                                                 (0xffff<<16) // Total VFs (Max Number of VFs). For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)
  #define PCIEIP_REG_SRIOV_INITIAL_VFS_SRIOV_TOTAL_VFS_K2_E5_SHIFT                                           16
#define PCIEIP_REG_SRIOV_CAPABILITIES_BB                                                                     0x0001c4UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SRIOV_CAPABILITIES_UNUSED_1A_BB                                                         (0x1<<0) // The capability is hardwired to 0.
  #define PCIEIP_REG_SRIOV_CAPABILITIES_UNUSED_1A_BB_SHIFT                                                   0
  #define PCIEIP_REG_SRIOV_CAPABILITIES_ARI_CAP_HIER_PRESERVED_BB                                            (0x1<<1) // This field is only present in PF0. This bet when set indicates that the ARI capable hierarchy is preserved across certain power state transitions.
  #define PCIEIP_REG_SRIOV_CAPABILITIES_ARI_CAP_HIER_PRESERVED_BB_SHIFT                                      1
  #define PCIEIP_REG_SRIOV_CAPABILITIES_UNUSED_1_BB                                                          (0x3fffffff<<2) // The capability is hardwired to 0.
  #define PCIEIP_REG_SRIOV_CAPABILITIES_UNUSED_1_BB_SHIFT                                                    2
#define PCIEIP_REG_SRIOV_NUM_VFS_K2_E5                                                                       0x0001c8UL //Access:RW   DataWidth:0x20   // NumVFs and Function Dependency Link Register. For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. There are two of these registers; one each for ARI Capable and non-ARI Capable Hierarchies. The "ARI Capable Hierarchy" bit (SRIOV_ARI_CAPABLE_HIER) of the PF0 "SR-IOV Control Register" (STATUS_CONTROL_REG) determines which one is used by the core when SR-IOV is being used, and which one is accessed by a read request. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address.
  #define PCIEIP_REG_SRIOV_NUM_VFS_SRIOV_NUM_VFS_K2_E5                                                       (0xffff<<0) // Number of Visible VFs. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: STATUS_CONTROL_REG.SRIOV_VF_ENABLE ? RW : RO
  #define PCIEIP_REG_SRIOV_NUM_VFS_SRIOV_NUM_VFS_K2_E5_SHIFT                                                 0
  #define PCIEIP_REG_SRIOV_NUM_VFS_SRIOV_FDL_K2_E5                                                           (0xff<<16) // Functional Dependency Link. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_SRIOV_NUM_VFS_SRIOV_FDL_K2_E5_SHIFT                                                     16
#define PCIEIP_REG_SRIOV_CONTROL_BB                                                                          0x0001c8UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SRIOV_CONTROL_VF_ENABLE_BB                                                              (0x1<<0) // Enables/Disables VFs.
  #define PCIEIP_REG_SRIOV_CONTROL_VF_ENABLE_BB_SHIFT                                                        0
  #define PCIEIP_REG_SRIOV_CONTROL_VF_MIG_EN_BB                                                              (0x1<<1) // 
  #define PCIEIP_REG_SRIOV_CONTROL_VF_MIG_EN_BB_SHIFT                                                        1
  #define PCIEIP_REG_SRIOV_CONTROL_VF_MIG_INTERR_EN_BB                                                       (0x1<<2) // This bit has no effect in IP. However spec has defined it to be RW.
  #define PCIEIP_REG_SRIOV_CONTROL_VF_MIG_INTERR_EN_BB_SHIFT                                                 2
  #define PCIEIP_REG_SRIOV_CONTROL_VF_MSE_BB                                                                 (0x1<<3) // When set, memory space is enabled for VFs.
  #define PCIEIP_REG_SRIOV_CONTROL_VF_MSE_BB_SHIFT                                                           3
  #define PCIEIP_REG_SRIOV_CONTROL_ARI_CAPABLE_HIER_BB                                                       (0x1<<4) // When set, the device is permitted to locate VF in Func Number 8 to 255. This field is RW only in PF0 and is RO in all other PFs.
  #define PCIEIP_REG_SRIOV_CONTROL_ARI_CAPABLE_HIER_BB_SHIFT                                                 4
  #define PCIEIP_REG_SRIOV_CONTROL_UNUSED_2_BB                                                               (0x7ff<<5) // The Status is hardwired to 0.
  #define PCIEIP_REG_SRIOV_CONTROL_UNUSED_2_BB_SHIFT                                                         5
  #define PCIEIP_REG_SRIOV_CONTROL_SRIOV_STATUS_BB                                                           (0xffff<<16) // The Status is hardwired to 0.
  #define PCIEIP_REG_SRIOV_CONTROL_SRIOV_STATUS_BB_SHIFT                                                     16
#define PCIEIP_REG_SRIOV_VF_OFFSET_POSITION_K2_E5                                                            0x0001ccUL //Access:RW   DataWidth:0x20   // VF Stride and Offset Register. For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_SRIOV_VF_OFFSET_POSITION_SRIOV_VF_OFFSET_K2_E5                                          (0xffff<<0) // First VF Offset. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. There are two First VF Offset registers at this address location; one each for ARI Capable and non-ARI Capable Hierarchies. The "ARI Capable Hierarchy" bit of the PF0 "SR-IOV Control Register" determines which one is used by the core when SR-IOV is being used, and which one is accessed by a read request. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SRIOV_VF_OFFSET_POSITION_SRIOV_VF_OFFSET_K2_E5_SHIFT                                    0
  #define PCIEIP_REG_SRIOV_VF_OFFSET_POSITION_SRIOV_VF_STRIDE_K2_E5                                          (0xffff<<16) // VF Stride. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. There are two VF Stride registers; one each for ARI Capable and non-ARI Capable Hierarchies. The "ARI Capable Hierarchy" bit of the PF0 "SR-IOV Control Register". determines which one is used by the core when SR-IOV is being used, and which one is accessed by a read request. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_SRIOV_VF_OFFSET_POSITION_SRIOV_VF_STRIDE_K2_E5_SHIFT                                    16
#define PCIEIP_REG_SRIOV_INITIALVF_BB                                                                        0x0001ccUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SRIOV_INITIALVF_INITIALVF_BB                                                            (0xffff<<0) // The Value in this register is based on programming in the private space at 0x600. This field indicates the number of VFs that are initially associated with the PF.
  #define PCIEIP_REG_SRIOV_INITIALVF_INITIALVF_BB_SHIFT                                                      0
  #define PCIEIP_REG_SRIOV_INITIALVF_TOTALVF_BB                                                              (0xffff<<16) // The Value in this register is based on programming in the private space at 0x600. This field indicates the maximum number of VFs that could be associated with PF.
  #define PCIEIP_REG_SRIOV_INITIALVF_TOTALVF_BB_SHIFT                                                        16
#define PCIEIP_REG_VF_DEVICE_ID_REG_K2_E5                                                                    0x0001d0UL //Access:RW   DataWidth:0x20   // VF Device ID For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_VF_DEVICE_ID_REG_SRIOV_VF_DEVICE_ID_K2_E5                                               (0xffff<<16) // VF Device ID. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VF_DEVICE_ID_REG_SRIOV_VF_DEVICE_ID_K2_E5_SHIFT                                         16
#define PCIEIP_REG_SRIOV_NUMVF_BB                                                                            0x0001d0UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SRIOV_NUMVF_NUMVF_BB                                                                    (0xffff<<0) // This field controls the number of VFs that are available. S/W sets this as part of creating VF.
  #define PCIEIP_REG_SRIOV_NUMVF_NUMVF_BB_SHIFT                                                              0
  #define PCIEIP_REG_SRIOV_NUMVF_FUNC_DEPENDENCY_LINK_BB                                                     (0xff<<16) // The Value in this register is based on programming in the private space at 0x608.
  #define PCIEIP_REG_SRIOV_NUMVF_FUNC_DEPENDENCY_LINK_BB_SHIFT                                               16
  #define PCIEIP_REG_SRIOV_NUMVF_RSVD_1_BB                                                                   (0xff<<24) // 
  #define PCIEIP_REG_SRIOV_NUMVF_RSVD_1_BB_SHIFT                                                             24
#define PCIEIP_REG_SUP_PAGE_SIZES_REG_K2_E5                                                                  0x0001d4UL //Access:RW   DataWidth:0x20   // Supported Page Sizes.
#define PCIEIP_REG_SRIOV_VFOFFSET_BB                                                                         0x0001d4UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SRIOV_VFOFFSET_VF_OFFSET_BB                                                             (0xffff<<0) // The value in this register is based on programming in private space at 0x604. This field defines the Routing ID offset of the first VF associated with the PF. The First VFs RID is calculated by adding this field to the RID of the PF.
  #define PCIEIP_REG_SRIOV_VFOFFSET_VF_OFFSET_BB_SHIFT                                                       0
  #define PCIEIP_REG_SRIOV_VFOFFSET_VF_STRIDE_BB                                                             (0xffff<<16) // This field is hardwired to 1.
  #define PCIEIP_REG_SRIOV_VFOFFSET_VF_STRIDE_BB_SHIFT                                                       16
#define PCIEIP_REG_SYSTEM_PAGE_SIZE_REG_K2_E5                                                                0x0001d8UL //Access:RW   DataWidth:0x20   // System Page Size.
#define PCIEIP_REG_SRIOV_VF_DEVICEID_BB                                                                      0x0001d8UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SRIOV_VF_DEVICEID_RESERVED_BB                                                           (0xffff<<0) // 
  #define PCIEIP_REG_SRIOV_VF_DEVICEID_RESERVED_BB_SHIFT                                                     0
  #define PCIEIP_REG_SRIOV_VF_DEVICEID_VF_DEVICEID_BB                                                        (0xffff<<16) // The value in this register is based on programming in private space at 0x604. This field contains Device ID for every VF belonging to this PF.
  #define PCIEIP_REG_SRIOV_VF_DEVICEID_VF_DEVICEID_BB_SHIFT                                                  16
#define PCIEIP_REG_SRIOV_BAR0_REG_K2_E5                                                                      0x0001dcUL //Access:RW   DataWidth:0x20   // VF BAR0. This register is used to define the BAR contents (in VF's Type-1 header) for all VFs in this PF. The actual BARs in the VF's Type-1 header are RO and are derived by the core from the SRIOV_VF_BAR*_START field in this register in conjunction with SRIOV_VF_OFFSET and SRIOV_VF_STRIDE. For a fuller description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_SRIOV_BAR0_REG_SRIOV_VF_BAR0_TYPE_K2_E5                                                 (0x3<<1) // VF BAR0 32 or 64 bit. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR0_REG_SRIOV_VF_BAR0_TYPE_K2_E5_SHIFT                                           1
  #define PCIEIP_REG_SRIOV_BAR0_REG_SRIOV_VF_BAR0_PREFETCH_K2_E5                                             (0x1<<3) // VF BAR0 Prefetchable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR0_REG_SRIOV_VF_BAR0_PREFETCH_K2_E5_SHIFT                                       3
  #define PCIEIP_REG_SRIOV_BAR0_REG_SRIOV_VF_BAR0_START_K2_E5                                                (0xfffffff<<4) // VF BAR0 Base Address. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_SRIOV_BAR0_REG_SRIOV_VF_BAR0_START_K2_E5_SHIFT                                          4
#define PCIEIP_REG_SRIOV_SUPPORTEDPAGESIZE_BB                                                                0x0001dcUL //Access:R    DataWidth:0x20   // This value in this register is based on programming in private space at 0x60C. Default indicates support from 4K to 4M.
#define PCIEIP_REG_SRIOV_BAR1_REG_K2_E5                                                                      0x0001e0UL //Access:RW   DataWidth:0x20   // VF BAR1. This register is used to define the BAR contents (in VF's Type-1 header) for all VFs in this PF. The actual BARs in the VF's Type-1 header are RO and are derived by the core from the SRIOV_VF_BAR*_START field in this register in conjunction with SRIOV_VF_OFFSET and SRIOV_VF_STRIDE. For a fuller description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_SRIOV_BAR1_REG_SRIOV_VF_BAR1_TYPE_K2_E5                                                 (0x3<<1) // VF BAR1 32 or 64 bit. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR1_REG_SRIOV_VF_BAR1_TYPE_K2_E5_SHIFT                                           1
  #define PCIEIP_REG_SRIOV_BAR1_REG_SRIOV_VF_BAR1_PREFETCH_K2_E5                                             (0x1<<3) // VF BAR1 Prefetchable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR1_REG_SRIOV_VF_BAR1_PREFETCH_K2_E5_SHIFT                                       3
  #define PCIEIP_REG_SRIOV_BAR1_REG_SRIOV_VF_BAR1_START_K2_E5                                                (0xfffffff<<4) // VF BAR1 Base Address. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_SRIOV_BAR1_REG_SRIOV_VF_BAR1_START_K2_E5_SHIFT                                          4
#define PCIEIP_REG_SRIOV_SYSTEMPAGESIZE_BB                                                                   0x0001e0UL //Access:RW   DataWidth:0x20   // Default value is 4K . This field defines the page size system will use to map VFs mem address.
#define PCIEIP_REG_SRIOV_BAR2_REG_K2_E5                                                                      0x0001e4UL //Access:RW   DataWidth:0x20   // VF BAR2. This register is used to define the BAR contents (in VF's Type-1 header) for all VFs in this PF. The actual BARs in the VF's Type-1 header are RO and are derived by the core from the SRIOV_VF_BAR*_START field in this register in conjunction with SRIOV_VF_OFFSET and SRIOV_VF_STRIDE. For a fuller description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_SRIOV_BAR2_REG_SRIOV_VF_BAR2_TYPE_K2_E5                                                 (0x3<<1) // VF BAR2 32 or 64 bit. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR2_REG_SRIOV_VF_BAR2_TYPE_K2_E5_SHIFT                                           1
  #define PCIEIP_REG_SRIOV_BAR2_REG_SRIOV_VF_BAR2_PREFETCH_K2_E5                                             (0x1<<3) // VF BAR2 Prefetchable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR2_REG_SRIOV_VF_BAR2_PREFETCH_K2_E5_SHIFT                                       3
  #define PCIEIP_REG_SRIOV_BAR2_REG_SRIOV_VF_BAR2_START_K2_E5                                                (0xfffffff<<4) // VF BAR2 Base Address. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_SRIOV_BAR2_REG_SRIOV_VF_BAR2_START_K2_E5_SHIFT                                          4
#define PCIEIP_REG_VF_BAR0_BB                                                                                0x0001e4UL //Access:RW   DataWidth:0x20   // The 32-bit VF_BAR0 register programs the base address for the memory space mapped by the VFs belonging to this PF. This register can be combined with VF_BAR2 to make a 64-bit address. Each VF BAR describes the amount of address space consumed by a single VF. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_VF_BAR0_MEM_SPACE_BB                                                                    (0x1<<0) // This bit indicates that VF_BAR0 maps a memory space and is always read as 0.
  #define PCIEIP_REG_VF_BAR0_MEM_SPACE_BB_SHIFT                                                              0
  #define PCIEIP_REG_VF_BAR0_SPACE_TYPE_BB                                                                   (0x3<<1) // These bits indicate that VF_BAR0 may be programmed to map this adapter to anywhere in the 64-bit address space. Bit can be programmed from shadow register(reg 0x608).
  #define PCIEIP_REG_VF_BAR0_SPACE_TYPE_BB_SHIFT                                                             1
  #define PCIEIP_REG_VF_BAR0_VF_PREFETCH_BB                                                                  (0x1<<3) // This bit indicates that the area mapped by VF_BAR0 may be pre-fetched or cached by the system without side effects. Bit can be programmed from shadow register(reg 0x608).
  #define PCIEIP_REG_VF_BAR0_VF_PREFETCH_BB_SHIFT                                                            3
  #define PCIEIP_REG_VF_BAR0_UNUSED0_BB                                                                      (0xff<<4) // 
  #define PCIEIP_REG_VF_BAR0_UNUSED0_BB_SHIFT                                                                4
  #define PCIEIP_REG_VF_BAR0_ADDRESS_BB                                                                      (0xfffff<<12) // These bits set the address within a 32-bit address space that device will respond in. These bits may be combined with the bits in VF_BAR1 to create a full 64 bit address decode. Only the bits that addresses blocks bigger than the setting in the VFBAR0_SIZE(reg 0x608) value are RW. All lower bits are RO with a value of zero. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_VF_BAR0_ADDRESS_BB_SHIFT                                                                12
#define PCIEIP_REG_SRIOV_BAR3_REG_K2_E5                                                                      0x0001e8UL //Access:RW   DataWidth:0x20   // VF BAR3. This register is used to define the BAR contents (in VF's Type-1 header) for all VFs in this PF. The actual BARs in the VF's Type-1 header are RO and are derived by the core from the SRIOV_VF_BAR*_START field in this register in conjunction with SRIOV_VF_OFFSET and SRIOV_VF_STRIDE. For a fuller description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_SRIOV_BAR3_REG_SRIOV_VF_BAR3_TYPE_K2_E5                                                 (0x3<<1) // VF BAR3 32 or 64 bit. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR3_REG_SRIOV_VF_BAR3_TYPE_K2_E5_SHIFT                                           1
  #define PCIEIP_REG_SRIOV_BAR3_REG_SRIOV_VF_BAR3_PREFETCH_K2_E5                                             (0x1<<3) // VF BAR3 Prefetchable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR3_REG_SRIOV_VF_BAR3_PREFETCH_K2_E5_SHIFT                                       3
  #define PCIEIP_REG_SRIOV_BAR3_REG_SRIOV_VF_BAR3_START_K2_E5                                                (0xfffffff<<4) // VF BAR3 Base Address. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_SRIOV_BAR3_REG_SRIOV_VF_BAR3_START_K2_E5_SHIFT                                          4
#define PCIEIP_REG_VF_BAR1_BB                                                                                0x0001e8UL //Access:RW   DataWidth:0x20   // The 32-bit VF_BAR1 register programs the upper half of the base address for the memory space mapped by the card onto the PCI bus.
#define PCIEIP_REG_SRIOV_BAR4_REG_K2_E5                                                                      0x0001ecUL //Access:RW   DataWidth:0x20   // VF BAR4. This register is used to define the BAR contents (in VF's Type-1 header) for all VFs in this PF. The actual BARs in the VF's Type-1 header are RO and are derived by the core from the SRIOV_VF_BAR*_START field in this register in conjunction with SRIOV_VF_OFFSET and SRIOV_VF_STRIDE. For a fuller description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_SRIOV_BAR4_REG_SRIOV_VF_BAR4_TYPE_K2_E5                                                 (0x3<<1) // VF BAR4 32 or 64 bit. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR4_REG_SRIOV_VF_BAR4_TYPE_K2_E5_SHIFT                                           1
  #define PCIEIP_REG_SRIOV_BAR4_REG_SRIOV_VF_BAR4_PREFETCH_K2_E5                                             (0x1<<3) // VF BAR4 Prefetchable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR4_REG_SRIOV_VF_BAR4_PREFETCH_K2_E5_SHIFT                                       3
  #define PCIEIP_REG_SRIOV_BAR4_REG_SRIOV_VF_BAR4_START_K2_E5                                                (0xfffff<<4) // VF BAR4 Base Address. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_SRIOV_BAR4_REG_SRIOV_VF_BAR4_START_K2_E5_SHIFT                                          4
#define PCIEIP_REG_VF_BAR2_BB                                                                                0x0001ecUL //Access:RW   DataWidth:0x20   // The 32-bit VF_BAR2 register programs the base address for the memory space mapped by the VFs belonging to this PF. This register can be combined with VF_BAR3 to make a 64-bit address. Each VF BAR describes the amount of address space consumed by a single VF. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_VF_BAR2_MEM_SPACE_BB                                                                    (0x1<<0) // This bit indicates that VF_BAR2 maps a memory space and is always read as 0.
  #define PCIEIP_REG_VF_BAR2_MEM_SPACE_BB_SHIFT                                                              0
  #define PCIEIP_REG_VF_BAR2_SPACE_TYPE_BB                                                                   (0x3<<1) // These bits indicate that VF_BAR2 may be programmed to map this adapter to anywhere in the 64-bit address space(reg 0x608).
  #define PCIEIP_REG_VF_BAR2_SPACE_TYPE_BB_SHIFT                                                             1
  #define PCIEIP_REG_VF_BAR2_VF_PREFETCH_BB                                                                  (0x1<<3) // This bit indicates that the area mapped by VF_BAR2 may be pre-fetched or cached by the system without side effects. Bit can be programmed from shadow register(reg 0x608).
  #define PCIEIP_REG_VF_BAR2_VF_PREFETCH_BB_SHIFT                                                            3
  #define PCIEIP_REG_VF_BAR2_UNUSED0_BB                                                                      (0xff<<4) // 
  #define PCIEIP_REG_VF_BAR2_UNUSED0_BB_SHIFT                                                                4
  #define PCIEIP_REG_VF_BAR2_ADDRESS_BB                                                                      (0xfffff<<12) // These bits set the address within a 32-bit address space that device will respond in. These bits may be combined with the bits in VF_BAR3 to create a full 64 bit address decode. Only the bits that addresses blocks bigger than the setting in the VFBAR2_SIZE(reg 0x608) value are RW. All lower bits are RO with a value of zero. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_VF_BAR2_ADDRESS_BB_SHIFT                                                                12
#define PCIEIP_REG_SRIOV_BAR5_REG_K2_E5                                                                      0x0001f0UL //Access:RW   DataWidth:0x20   // VF BAR5. This register is used to define the BAR contents (in VF's Type-1 header) for all VFs in this PF. The actual BARs in the VF's Type-1 header are RO and are derived by the core from the SRIOV_VF_BAR*_START field in this register in conjunction with SRIOV_VF_OFFSET and SRIOV_VF_STRIDE. For a fuller description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1. The mask for this BAR exists (if implemented) as a shadow register at this address. The assertion of CS2 (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) is required to write to the second register at this address. For more details, see "Accessing Configuration Registers".
  #define PCIEIP_REG_SRIOV_BAR5_REG_SRIOV_VF_BAR5_TYPE_K2_E5                                                 (0x3<<1) // VF BAR5 32 or 64 bit. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR5_REG_SRIOV_VF_BAR5_TYPE_K2_E5_SHIFT                                           1
  #define PCIEIP_REG_SRIOV_BAR5_REG_SRIOV_VF_BAR5_PREFETCH_K2_E5                                             (0x1<<3) // VF BAR5 Prefetchable. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: If enabled and (DBI_RO_WR_EN == 1) then R/W else R
  #define PCIEIP_REG_SRIOV_BAR5_REG_SRIOV_VF_BAR5_PREFETCH_K2_E5_SHIFT                                       3
  #define PCIEIP_REG_SRIOV_BAR5_REG_SRIOV_VF_BAR5_START_K2_E5                                                (0xfffffff<<4) // VF BAR5 Base Address. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_SRIOV_BAR5_REG_SRIOV_VF_BAR5_START_K2_E5_SHIFT                                          4
#define PCIEIP_REG_VF_BAR3_BB                                                                                0x0001f0UL //Access:RW   DataWidth:0x20   // The 32-bit VF_BAR3 register programs the upper half of the base address for the memory space mapped by the card onto the PCI bus.
#define PCIEIP_REG_VF_MIGRATION_STATE_ARRAY_REG_K2_E5                                                        0x0001f4UL //Access:R    DataWidth:0x20   // VF Migration State Array Offset For a description of this standard PCIe register, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_VF_MIGRATION_STATE_ARRAY_REG_SRIOV_VF_MIGRATION_STATE_BIR_K2_E5                         (0x7<<0) // VF Migration State BIR. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_VF_MIGRATION_STATE_ARRAY_REG_SRIOV_VF_MIGRATION_STATE_BIR_K2_E5_SHIFT                   0
  #define PCIEIP_REG_VF_MIGRATION_STATE_ARRAY_REG_SRIOV_VF_MIGRATION_STATE_OFFSET_K2_E5                      (0x1fffffff<<3) // VF Migration State Offset. For a description of this standard PCIe register field, see the Single Root I/O Virtualization and Sharing Specification Revision 1.1.
  #define PCIEIP_REG_VF_MIGRATION_STATE_ARRAY_REG_SRIOV_VF_MIGRATION_STATE_OFFSET_K2_E5_SHIFT                3
#define PCIEIP_REG_VF_BAR4_BB                                                                                0x0001f4UL //Access:RW   DataWidth:0x20   // The 32-bit VF_BAR4 register programs the base address for the memory space mapped by the VFs belonging to this PF. This register can be combined with VF_BAR5 to make a 64-bit address. Each VF BAR describes the amount of address space consumed by a single VF. Path = i_cfg_func.i_cfg_public.i_cfg_dec
  #define PCIEIP_REG_VF_BAR4_MEM_SPACE_BB                                                                    (0x1<<0) // This bit indicates that VF_BAR4 maps a memory space and is always read as 0.
  #define PCIEIP_REG_VF_BAR4_MEM_SPACE_BB_SHIFT                                                              0
  #define PCIEIP_REG_VF_BAR4_SPACE_TYPE_BB                                                                   (0x3<<1) // These bits indicate that VF_BAR4 may be programmed to map this adapter to anywhere in the 64-bit address space(reg 0x620).
  #define PCIEIP_REG_VF_BAR4_SPACE_TYPE_BB_SHIFT                                                             1
  #define PCIEIP_REG_VF_BAR4_VF_PREFETCH_BB                                                                  (0x1<<3) // This bit indicates that the area mapped by VF_BAR4 may be pre-fetched or cached by the system without side effects. Bit can be programmed from shadow register(reg 0x620).
  #define PCIEIP_REG_VF_BAR4_VF_PREFETCH_BB_SHIFT                                                            3
  #define PCIEIP_REG_VF_BAR4_UNUSED0_BB                                                                      (0xff<<4) // 
  #define PCIEIP_REG_VF_BAR4_UNUSED0_BB_SHIFT                                                                4
  #define PCIEIP_REG_VF_BAR4_ADDRESS_BB                                                                      (0xfffff<<12) // These bits set the address within a 32-bit address space that device will respond in. These bits may be combined with the bits in VF_BAR5 to create a full 64 bit address decode. Only the bits that addresses blocks bigger than the setting in the VFBAR4_SIZE(reg 0x620) value are RW. All lower bits are RO with a value of zero. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_VF_BAR4_ADDRESS_BB_SHIFT                                                                12
#define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_K2_E5                                                                 0x0001f8UL //Access:RW   DataWidth:0x20   // TPH Extended Capability Header.
  #define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_PCIE_EXT_CAP_ID_K2_E5                                               (0xffff<<0) // TPH Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_PCIE_EXT_CAP_ID_K2_E5_SHIFT                                         0
  #define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_TPH_REQ_CAP_VER_K2_E5                                               (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_TPH_REQ_CAP_VER_K2_E5_SHIFT                                         16
  #define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_TPH_REQ_NEXT_PTR_K2_E5                                              (0xfff<<20) // Next Capability Pointer.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_EXT_CAP_HDR_REG_TPH_REQ_NEXT_PTR_K2_E5_SHIFT                                        20
#define PCIEIP_REG_VF_BAR5_BB                                                                                0x0001f8UL //Access:RW   DataWidth:0x20   // The 32-bit VF_BAR5 register programs the upper half of the base address for the memory space mapped by the card onto the PCI bus.
#define PCIEIP_REG_TPH_REQ_CAP_REG_REG_K2_E5                                                                 0x0001fcUL //Access:RW   DataWidth:0x20   // TPH Requestor Capability Register.   SRIOV Note: All VFs in a single PF have the same values for VF_TPH_REQ_CAP_REG_REG. To write this common register, you must perform a DBI_CS2 write (that is, assert the dbi_cs2 input, or the CS2 address bit for the AXI bridge) while accessing the PF TPH_REQ_CAP_REG_REG register.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_NO_ST_MODE_K2_E5                                            (0x1<<0) // No ST Mode Supported.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_NO_ST_MODE_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_INT_VEC_K2_E5                                           (0x1<<1) // Interrupt Vector Mode Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_INT_VEC_K2_E5_SHIFT                                     1
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_DEVICE_SPEC_K2_E5                                           (0x1<<2) // Device Specific Mode Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_DEVICE_SPEC_K2_E5_SHIFT                                     2
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_EXTENDED_TPH_K2_E5                                          (0x1<<8) // Extended TPH Requester Supported.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_EXTENDED_TPH_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_ST_TABLE_LOC_0_K2_E5                                    (0x1<<9) // ST Table Location Bit 0.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_ST_TABLE_LOC_0_K2_E5_SHIFT                              9
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_ST_TABLE_LOC_1_K2_E5                                    (0x1<<10) // ST Table Location Bit 1.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_ST_TABLE_LOC_1_K2_E5_SHIFT                              10
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_ST_TABLE_SIZE_K2_E5                                     (0x7ff<<16) // ST Table Size.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W else R  Note: This register field is sticky.
  #define PCIEIP_REG_TPH_REQ_CAP_REG_REG_TPH_REQ_CAP_ST_TABLE_SIZE_K2_E5_SHIFT                               16
#define PCIEIP_REG_TPH_REQ_CONTROL_REG_REG_K2_E5                                                             0x000200UL //Access:RW   DataWidth:0x20   // TPH Requestor Control Register.
  #define PCIEIP_REG_TPH_REQ_CONTROL_REG_REG_TPH_REQ_ST_MODE_SELECT_K2_E5                                    (0x7<<0) // ST Mode Select.   Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_TPH_REQ_CONTROL_REG_REG_TPH_REQ_ST_MODE_SELECT_K2_E5_SHIFT                              0
  #define PCIEIP_REG_TPH_REQ_CONTROL_REG_REG_TPH_REQ_CTRL_REQ_EN_K2_E5                                       (0x3<<8) // TPH Requester Enable Bit.
  #define PCIEIP_REG_TPH_REQ_CONTROL_REG_REG_TPH_REQ_CTRL_REQ_EN_K2_E5_SHIFT                                 8
#define PCIEIP_REG_PTM_EXTENDED_CAP_BB                                                                       0x000200UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 0 of the EXT3_CAP_ENA for EP, The capability can be enabled by default by defining PCIE_PTM_SUPP in version.v and setting bit 0 of EXT3_CAP_ENA.
  #define PCIEIP_REG_PTM_EXTENDED_CAP_PTM_EXT_CAP_ID_BB                                                      (0xffff<<0) // Vendor Specific Extended Capability ID.
  #define PCIEIP_REG_PTM_EXTENDED_CAP_PTM_EXT_CAP_ID_BB_SHIFT                                                0
  #define PCIEIP_REG_PTM_EXTENDED_CAP_CAP_VER_BB                                                             (0xf<<16) // PTM Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_PTM_EXTENDED_CAP_CAP_VER_BB_SHIFT                                                       16
  #define PCIEIP_REG_PTM_EXTENDED_CAP_NEXT_BB                                                                (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_PTM_EXTENDED_CAP_NEXT_BB_SHIFT                                                          20
#define PCIEIP_REG_TPH_ST_TABLE_REG_0_K2_E5                                                                  0x000204UL //Access:RW   DataWidth:0x20   // TPH ST Table Register 0.
  #define PCIEIP_REG_TPH_ST_TABLE_REG_0_TPH_REQ_ST_TABLE_LOWER_0_K2_E5                                       (0xff<<0) // ST Table 0 Lower Byte.   Note: The access attributes of this field are as follows:  - Dbi: this field is RW or Tie to 0 by table size configure
  #define PCIEIP_REG_TPH_ST_TABLE_REG_0_TPH_REQ_ST_TABLE_LOWER_0_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_TPH_ST_TABLE_REG_0_TPH_REQ_ST_TABLE_HIGHER_0_K2_E5                                      (0xff<<8) // ST Table 0 Upper Byte.   Note: The access attributes of this field are as follows:  - Dbi: this field is RW or Tie to 0 by table size configure
  #define PCIEIP_REG_TPH_ST_TABLE_REG_0_TPH_REQ_ST_TABLE_HIGHER_0_K2_E5_SHIFT                                8
#define PCIEIP_REG_PTM_CAP_REG_BB                                                                            0x000204UL //Access:R    DataWidth:0x20   // The RW value of this register is controlled by setting bit 0 of the EXT3_CAP_ENA for EP.
  #define PCIEIP_REG_PTM_CAP_REG_PTM_REQUESTER_CAPABLE_BB                                                    (0x1<<0) // Device implements the PTM Requester role.
  #define PCIEIP_REG_PTM_CAP_REG_PTM_REQUESTER_CAPABLE_BB_SHIFT                                              0
#define PCIEIP_REG_PTM_CTRL_REG_BB                                                                           0x000208UL //Access:RW   DataWidth:0x20   // The RW value of this register is controlled by setting bit 0 of the EXT3_CAP_ENA for EP.
  #define PCIEIP_REG_PTM_CTRL_REG_PTM_ENABLED_BB                                                             (0x1<<0) // When Set, Function is permitted to participate in PTM mechanism
  #define PCIEIP_REG_PTM_CTRL_REG_PTM_ENABLED_BB_SHIFT                                                       0
  #define PCIEIP_REG_PTM_CTRL_REG_ROOT_SELECT_BB                                                             (0x1<<1) // If Set, device is the PTM Root.
  #define PCIEIP_REG_PTM_CTRL_REG_ROOT_SELECT_BB_SHIFT                                                       1
  #define PCIEIP_REG_PTM_CTRL_REG_UNUSED0_BB                                                                 (0x3f<<2) // 
  #define PCIEIP_REG_PTM_CTRL_REG_UNUSED0_BB_SHIFT                                                           2
  #define PCIEIP_REG_PTM_CTRL_REG_PTM_EFFECTIVE_GRANULARITY_BB                                               (0xff<<8) // Field provides information on the expected accuracy of the PTM clock. For endpoints, system software programs this field to the value representing the max Local Clock granularity reported by the PTM Root.
  #define PCIEIP_REG_PTM_CTRL_REG_PTM_EFFECTIVE_GRANULARITY_BB_SHIFT                                         8
#define PCIEIP_REG_ATS_CAP_BB                                                                                0x000210UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 9 of the EXT_CAP_ENA for EP, The capability can be enabled by default by defining ATS_ON in version.v .
  #define PCIEIP_REG_ATS_CAP_ATS_EXT_CAP_ID_BB                                                               (0xffff<<0) // ATS Extended Capability ID. Hardwired to 0xF.
  #define PCIEIP_REG_ATS_CAP_ATS_EXT_CAP_ID_BB_SHIFT                                                         0
  #define PCIEIP_REG_ATS_CAP_ATSCAP_VER_BB                                                                   (0xf<<16) // ATS Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_ATS_CAP_ATSCAP_VER_BB_SHIFT                                                             16
  #define PCIEIP_REG_ATS_CAP_ATS_NEXT_BB                                                                     (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_ATS_CAP_ATS_NEXT_BB_SHIFT                                                               20
#define PCIEIP_REG_ATS_CONTROL_BB                                                                            0x000214UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_ATS_CONTROL_ATS_INVLD_QDEPTH_BB                                                         (0x1f<<0) // The number of Invalidate Requests that the function can accept before putting backpressure on the upstream request. the value in this field is controlled by programming in private register at 0x630
  #define PCIEIP_REG_ATS_CONTROL_ATS_INVLD_QDEPTH_BB_SHIFT                                                   0
  #define PCIEIP_REG_ATS_CONTROL_ATS_PAGE_ALIGNED_REQ_BB                                                     (0x1<<5) // This bit when set indicates Untranslated Address is always aligned to 4K boundary. the value in this field is controlled by programming in private register at 0x630
  #define PCIEIP_REG_ATS_CONTROL_ATS_PAGE_ALIGNED_REQ_BB_SHIFT                                               5
  #define PCIEIP_REG_ATS_CONTROL_RSVD_Z_BB                                                                   (0x3ff<<6) // 
  #define PCIEIP_REG_ATS_CONTROL_RSVD_Z_BB_SHIFT                                                             6
  #define PCIEIP_REG_ATS_CONTROL_ATS_STU_BB                                                                  (0x1f<<16) // The value indicates to the Function, the minimum of 4K byte blocks that is indicated in a Translation Completion or Invalidate Requests. A value of 0 indicates 1 block and a value of 31 indicates 2^31 blocks.
  #define PCIEIP_REG_ATS_CONTROL_ATS_STU_BB_SHIFT                                                            16
  #define PCIEIP_REG_ATS_CONTROL_RESERVED_Z_BB                                                               (0x3ff<<21) // 
  #define PCIEIP_REG_ATS_CONTROL_RESERVED_Z_BB_SHIFT                                                         21
  #define PCIEIP_REG_ATS_CONTROL_ATS_ENABLE_BB                                                               (0x1<<31) // When set, function is enabled to cache translations.
  #define PCIEIP_REG_ATS_CONTROL_ATS_ENABLE_BB_SHIFT                                                         31
#define PCIEIP_REG_RBAR_EXT_CAP_BB                                                                           0x000220UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 8 of the EXT_CAP_ENA for EP, The capability can be enabled by default by defining RESIZE_BAR in version.v .
  #define PCIEIP_REG_RBAR_EXT_CAP_RBAR_EXT_CAP_ID_BB                                                         (0xffff<<0) // RBAR Extended Capability ID. Hardwired to 0x15.
  #define PCIEIP_REG_RBAR_EXT_CAP_RBAR_EXT_CAP_ID_BB_SHIFT                                                   0
  #define PCIEIP_REG_RBAR_EXT_CAP_RBARCAP_VER_BB                                                             (0xf<<16) // RBAR Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_RBAR_EXT_CAP_RBARCAP_VER_BB_SHIFT                                                       16
  #define PCIEIP_REG_RBAR_EXT_CAP_RBAR_NEXT_BB                                                               (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_RBAR_EXT_CAP_RBAR_NEXT_BB_SHIFT                                                         20
#define PCIEIP_REG_RBAR_CAP_BB                                                                               0x000224UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_CAPABILITY_BB                                                             (0xf<<0) // unused
  #define PCIEIP_REG_RBAR_CAP_SIZE_CAPABILITY_BB_SHIFT                                                       0
  #define PCIEIP_REG_RBAR_CAP_SIZE_1M_CAPABILITY_BB                                                          (0x1<<4) // when Set, it indicates function will operate with Bar sized to 1M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_1M_CAPABILITY_BB_SHIFT                                                    4
  #define PCIEIP_REG_RBAR_CAP_SIZE_2M_CAPABILITY_BB                                                          (0x1<<5) // when Set, it indicates function will operate with Bar sized to 2M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_2M_CAPABILITY_BB_SHIFT                                                    5
  #define PCIEIP_REG_RBAR_CAP_SIZE_4M_CAPABILITY_BB                                                          (0x1<<6) // when Set, it indicates function will operate with Bar sized to 4M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_4M_CAPABILITY_BB_SHIFT                                                    6
  #define PCIEIP_REG_RBAR_CAP_SIZE_8M_CAPABILITY_BB                                                          (0x1<<7) // when Set, it indicates function will operate with Bar sized to 8M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_8M_CAPABILITY_BB_SHIFT                                                    7
  #define PCIEIP_REG_RBAR_CAP_SIZE_16M_CAPABILITY_BB                                                         (0x1<<8) // when Set, it indicates function will operate with Bar sized to 16M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_16M_CAPABILITY_BB_SHIFT                                                   8
  #define PCIEIP_REG_RBAR_CAP_SIZE_32M_CAPABILITY_BB                                                         (0x1<<9) // when Set, it indicates function will operate with Bar sized to 32M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_32M_CAPABILITY_BB_SHIFT                                                   9
  #define PCIEIP_REG_RBAR_CAP_SIZE_64M_CAPABILITY_BB                                                         (0x1<<10) // when Set, it indicates function will operate with Bar sized to 64M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_64M_CAPABILITY_BB_SHIFT                                                   10
  #define PCIEIP_REG_RBAR_CAP_SIZE_128M_CAPABILITY_BB                                                        (0x1<<11) // when Set, it indicates function will operate with Bar sized to 128M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_128M_CAPABILITY_BB_SHIFT                                                  11
  #define PCIEIP_REG_RBAR_CAP_SIZE_256M_CAPABILITY_BB                                                        (0x1<<12) // when Set, it indicates function will operate with Bar sized to 256M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_256M_CAPABILITY_BB_SHIFT                                                  12
  #define PCIEIP_REG_RBAR_CAP_SIZE_512M_CAPABILITY_BB                                                        (0x1<<13) // when Set, it indicates function will operate with Bar sized to 512M. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_512M_CAPABILITY_BB_SHIFT                                                  13
  #define PCIEIP_REG_RBAR_CAP_SIZE_1G_CAPABILITY_BB                                                          (0x1<<14) // when Set, it indicates function will operate with Bar sized to 1G. Value reflected here is from corresponding bit in private register.
  #define PCIEIP_REG_RBAR_CAP_SIZE_1G_CAPABILITY_BB_SHIFT                                                    14
  #define PCIEIP_REG_RBAR_CAP_SIZE_512G_TO_2G_CAPABILITY_BB                                                  (0x1ff<<15) // unsupported.
  #define PCIEIP_REG_RBAR_CAP_SIZE_512G_TO_2G_CAPABILITY_BB_SHIFT                                            15
#define PCIEIP_REG_RBAR_CTRL_BB                                                                              0x000228UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_RBAR_CTRL_RBAR_INDX_BB                                                                  (0x7<<0) // Indicates which BAR supports a negotiable size.
  #define PCIEIP_REG_RBAR_CTRL_RBAR_INDX_BB_SHIFT                                                            0
  #define PCIEIP_REG_RBAR_CTRL_RSVD_BB                                                                       (0x3<<3) // Unused
  #define PCIEIP_REG_RBAR_CTRL_RSVD_BB_SHIFT                                                                 3
  #define PCIEIP_REG_RBAR_CTRL_NUM_RBAR_BB                                                                   (0x7<<5) // Indicates number of resizeable BARs in capability.
  #define PCIEIP_REG_RBAR_CTRL_NUM_RBAR_BB_SHIFT                                                             5
  #define PCIEIP_REG_RBAR_CTRL_BAR_SIZE_BB                                                                   (0x1f<<8) // When this reg is programmed, value is immediately reflected in the size of the resource, as encoded in the number of RO bits in BAR.
  #define PCIEIP_REG_RBAR_CTRL_BAR_SIZE_BB_SHIFT                                                             8
#define PCIEIP_REG_TPH_EXTENDED_CAP_BB                                                                       0x000230UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 0 of the EXT2_CAP_ENA for EP, By default, this capability is enabled The capability can be enabled by default by defining TPH_ON in version.v and setting bit 0 of EXT2_CAP_ENA.
  #define PCIEIP_REG_TPH_EXTENDED_CAP_TPH_EXT_CAP_ID_BB                                                      (0xffff<<0) // Vendor Specific Extended Capability ID.
  #define PCIEIP_REG_TPH_EXTENDED_CAP_TPH_EXT_CAP_ID_BB_SHIFT                                                0
  #define PCIEIP_REG_TPH_EXTENDED_CAP_CAP_VER_BB                                                             (0xf<<16) // LTR Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_TPH_EXTENDED_CAP_CAP_VER_BB_SHIFT                                                       16
  #define PCIEIP_REG_TPH_EXTENDED_CAP_NEXT_BB                                                                (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_TPH_EXTENDED_CAP_NEXT_BB_SHIFT                                                          20
#define PCIEIP_REG_TPH_REQ_CAPABILITY_BB                                                                     0x000234UL //Access:R    DataWidth:0x20   // The RW value of this register is controlled by setting bit 0 of the EXT2_CAP_ENA for EP. By default, this capability is disabled (i.e. reading this register will return zeroes).
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_NO_ST_MODE_SUPPORTED_BB                                              (0x1<<0) // Function supports NO ST mode of operation. This mode is required to be supported.
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_NO_ST_MODE_SUPPORTED_BB_SHIFT                                        0
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_INT_VECTOR_MODE_SUPPORTED_BB                                         (0x1<<1) // If Set function supports Interrupt Vector mode of operation. Value in this field can be programmed through TPH_CAP register in private space.
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_INT_VECTOR_MODE_SUPPORTED_BB_SHIFT                                   1
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_DEVICE_MODE_SUPPORTED_BB                                             (0x1<<2) // If Set function supports device mode of operation.
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_DEVICE_MODE_SUPPORTED_BB_SHIFT                                       2
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_UNUSED0_BB                                                           (0x1f<<3) // 
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_UNUSED0_BB_SHIFT                                                     3
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_EXTENDED_TPH_REQ_SUPP_BB                                             (0x1<<8) // If Set function is capable of generating Req's with TPH TLP prefix.
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_EXTENDED_TPH_REQ_SUPP_BB_SHIFT                                       8
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_ST_TABLE_LOCATION_BB                                                 (0x3<<9) // Value indicates if and where the ST table is located. Value in this field can be programmed through TPH_CAP register in private space.
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_ST_TABLE_LOCATION_BB_SHIFT                                           9
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_UNUSED1_BB                                                           (0x1f<<11) // 
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_UNUSED1_BB_SHIFT                                                     11
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_ST_TABLE_SIZE_BB                                                     (0x7ff<<16) // Software reads this field to determine the STTable Size N, whihc is encoded as N-1. So a returned value of 16, indicates a table size of 17. The value in this field can be programmed by programming the TPH_CAP register in the private space.
  #define PCIEIP_REG_TPH_REQ_CAPABILITY_ST_TABLE_SIZE_BB_SHIFT                                               16
#define PCIEIP_REG_TPH_REQ_CONTROL_BB                                                                        0x000238UL //Access:RW   DataWidth:0x20   // The RW value of this register is controlled by setting bit 0 of the EXT2_CAP_ENA for EP.
  #define PCIEIP_REG_TPH_REQ_CONTROL_ST_MODE_SELECT_BB                                                       (0x7<<0) // Value indicates ST mode of operation
  #define PCIEIP_REG_TPH_REQ_CONTROL_ST_MODE_SELECT_BB_SHIFT                                                 0
  #define PCIEIP_REG_TPH_REQ_CONTROL_UNUSED0_BB                                                              (0x1f<<3) // 
  #define PCIEIP_REG_TPH_REQ_CONTROL_UNUSED0_BB_SHIFT                                                        3
  #define PCIEIP_REG_TPH_REQ_CONTROL_TPH_REQUESTER_ENABLE_BB                                                 (0x3<<8) // Value indicates if and how TPH is enabled
  #define PCIEIP_REG_TPH_REQ_CONTROL_TPH_REQUESTER_ENABLE_BB_SHIFT                                           8
#define PCIEIP_REG_PML1SUB_CAPID_BB                                                                          0x000240UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 2 of the EXT2_CAP_ENA for EP, By default, this capability is disabled (i.e. reading this register will return zeroes). The capability can be enabled by default by defining PMCR_L1_SUBSTATES_ENA in version.v and setting bit 2 of EXT2_CAP_ENA. This capability when present , will only exist in function 0 of a multi-function device.
  #define PCIEIP_REG_PML1SUB_CAPID_L1SUB_EXT_CAP_ID_BB                                                       (0xffff<<0) // Vendor Specific Extended Capability ID. Value is from corresponding field in private register.
  #define PCIEIP_REG_PML1SUB_CAPID_L1SUB_EXT_CAP_ID_BB_SHIFT                                                 0
  #define PCIEIP_REG_PML1SUB_CAPID_CAP_VER_BB                                                                (0xf<<16) // PM L1 substates Capability version. Value is from corresponding field in private register.
  #define PCIEIP_REG_PML1SUB_CAPID_CAP_VER_BB_SHIFT                                                          16
  #define PCIEIP_REG_PML1SUB_CAPID_NEXT_BB                                                                   (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_PML1SUB_CAPID_NEXT_BB_SHIFT                                                             20
#define PCIEIP_REG_PML1_SUB_CAP_REG_BB                                                                       0x000244UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PML1_SUB_CAP_REG_PM_L1_2_SUPP_BB                                                        (0x1<<0) // Advertize L1_2 capability support for PM
  #define PCIEIP_REG_PML1_SUB_CAP_REG_PM_L1_2_SUPP_BB_SHIFT                                                  0
  #define PCIEIP_REG_PML1_SUB_CAP_REG_PM_L1_1_SUPP_BB                                                        (0x1<<1) // Advertize L1_1 capability support for PM
  #define PCIEIP_REG_PML1_SUB_CAP_REG_PM_L1_1_SUPP_BB_SHIFT                                                  1
  #define PCIEIP_REG_PML1_SUB_CAP_REG_ASPM_L1_2_SUPP_BB                                                      (0x1<<2) // Advertize L1_2 capability support for ASPM
  #define PCIEIP_REG_PML1_SUB_CAP_REG_ASPM_L1_2_SUPP_BB_SHIFT                                                2
  #define PCIEIP_REG_PML1_SUB_CAP_REG_ASPM_L1_1_SUPP_BB                                                      (0x1<<3) // Advertize L1_1 capability support for ASPM
  #define PCIEIP_REG_PML1_SUB_CAP_REG_ASPM_L1_1_SUPP_BB_SHIFT                                                3
  #define PCIEIP_REG_PML1_SUB_CAP_REG_CLKREQ_L1SUB_SUPP_BB                                                   (0x1<<4) // Clkreq based L1 substates is supported.
  #define PCIEIP_REG_PML1_SUB_CAP_REG_CLKREQ_L1SUB_SUPP_BB_SHIFT                                             4
  #define PCIEIP_REG_PML1_SUB_CAP_REG_RESERVED_1_BB                                                          (0x7<<5) // 
  #define PCIEIP_REG_PML1_SUB_CAP_REG_RESERVED_1_BB_SHIFT                                                    5
  #define PCIEIP_REG_PML1_SUB_CAP_REG_L1SUB_CMN_MODE_UP_TIME_BB                                              (0xff<<8) // Time in us that device advertizes that it requires to re-establish common mode.
  #define PCIEIP_REG_PML1_SUB_CAP_REG_L1SUB_CMN_MODE_UP_TIME_BB_SHIFT                                        8
  #define PCIEIP_REG_PML1_SUB_CAP_REG_L1SUB_PWR_ON_SCALE_BB                                                  (0x3<<16) // Along with the value field, this field advertizes the tpower_on time in us, that the link partner must wait when exiting from L1_2 state due to driving CLKREQ#, before actively driving the interface.
  #define PCIEIP_REG_PML1_SUB_CAP_REG_L1SUB_PWR_ON_SCALE_BB_SHIFT                                            16
  #define PCIEIP_REG_PML1_SUB_CAP_REG_RESERVED_0_BB                                                          (0x1<<18) // 
  #define PCIEIP_REG_PML1_SUB_CAP_REG_RESERVED_0_BB_SHIFT                                                    18
  #define PCIEIP_REG_PML1_SUB_CAP_REG_L1SUB_PWR_ON_VALUE_BB                                                  (0x1f<<19) // Along with the scale field, this field advertizes the tpower_on time in us, that the link partner must wait when exiting from L1_2 state due to driving CLKREQ#, before actively driving the interface.
  #define PCIEIP_REG_PML1_SUB_CAP_REG_L1SUB_PWR_ON_VALUE_BB_SHIFT                                            19
  #define PCIEIP_REG_PML1_SUB_CAP_REG_RESERVED_BB                                                            (0xff<<24) // 
  #define PCIEIP_REG_PML1_SUB_CAP_REG_RESERVED_BB_SHIFT                                                      24
#define PCIEIP_REG_PML1_SUB_CONTROL1_BB                                                                      0x000248UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_PM_L1_2_ENABLE_BB                                                     (0x1<<0) // When set, PM L1.2 is enabled.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_PM_L1_2_ENABLE_BB_SHIFT                                               0
  #define PCIEIP_REG_PML1_SUB_CONTROL1_PM_L1_1_ENABLE_BB                                                     (0x1<<1) // When set, PM L1.1 is enabled.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_PM_L1_1_ENABLE_BB_SHIFT                                               1
  #define PCIEIP_REG_PML1_SUB_CONTROL1_ASPM_L1_2_ENABLE_BB                                                   (0x1<<2) // When set, ASPM L1.2 is enabled.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_ASPM_L1_2_ENABLE_BB_SHIFT                                             2
  #define PCIEIP_REG_PML1_SUB_CONTROL1_ASPM_L1_1_ENABLE_BB                                                   (0x1<<3) // When set, ASPM L1.1 is enabled.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_ASPM_L1_1_ENABLE_BB_SHIFT                                             3
  #define PCIEIP_REG_PML1_SUB_CONTROL1_L1PM_SUB_MECH_BB                                                      (0x1<<4) // Value of 0 is hardwired indicating support for only CLKREQ based PM mechanism.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_L1PM_SUB_MECH_BB_SHIFT                                                4
  #define PCIEIP_REG_PML1_SUB_CONTROL1_RESERVED_1_BB                                                         (0x7<<5) // 
  #define PCIEIP_REG_PML1_SUB_CONTROL1_RESERVED_1_BB_SHIFT                                                   5
  #define PCIEIP_REG_PML1_SUB_CONTROL1_COMMON_MODE_RESTORE_TIME_BB                                           (0xff<<8) // For downstream port only.
  #define PCIEIP_REG_PML1_SUB_CONTROL1_COMMON_MODE_RESTORE_TIME_BB_SHIFT                                     8
  #define PCIEIP_REG_PML1_SUB_CONTROL1_LTR_L1_2_THRESHOLD_VALUE_BB                                           (0x3ff<<16) // Provides a value for the L1_2 LTR threshold
  #define PCIEIP_REG_PML1_SUB_CONTROL1_LTR_L1_2_THRESHOLD_VALUE_BB_SHIFT                                     16
  #define PCIEIP_REG_PML1_SUB_CONTROL1_RESERVED_BB                                                           (0x7<<26) // Reserved
  #define PCIEIP_REG_PML1_SUB_CONTROL1_RESERVED_BB_SHIFT                                                     26
  #define PCIEIP_REG_PML1_SUB_CONTROL1_LTR_L1_2_THRESHOLD_SCALE_BB                                           (0x7<<29) // Provides a scale for the L1_2 LTR threshold value
  #define PCIEIP_REG_PML1_SUB_CONTROL1_LTR_L1_2_THRESHOLD_SCALE_BB_SHIFT                                     29
#define PCIEIP_REG_PML1_SUB_CONTROL2_BB                                                                      0x00024cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PML1_SUB_CONTROL2_T_POWER_ON_SCALE_BB                                                   (0x3<<0) // This field along with value sets the min amount of time that the Port must wait in L1.2 exit after sampling CLKREQ# asserted before actively driving the interface. This field specifies the scale used
  #define PCIEIP_REG_PML1_SUB_CONTROL2_T_POWER_ON_SCALE_BB_SHIFT                                             0
  #define PCIEIP_REG_PML1_SUB_CONTROL2_RSVD_A_BB                                                             (0x1<<2) // 
  #define PCIEIP_REG_PML1_SUB_CONTROL2_RSVD_A_BB_SHIFT                                                       2
  #define PCIEIP_REG_PML1_SUB_CONTROL2_T_POWER_ON_VALUE_BB                                                   (0x1f<<3) // This field along with scale sets the min amount of time that the Port must wait in L1.2 exit after sampling CLKREQ# asserted before actively driving the interface.
  #define PCIEIP_REG_PML1_SUB_CONTROL2_T_POWER_ON_VALUE_BB_SHIFT                                             3
  #define PCIEIP_REG_PML1_SUB_CONTROL2_RSVD_BB                                                               (0xffffff<<8) // 
  #define PCIEIP_REG_PML1_SUB_CONTROL2_RSVD_BB_SHIFT                                                         8
#define PCIEIP_REG_LTR_CAP_HDR_REG_K2_E5                                                                     0x000284UL //Access:RW   DataWidth:0x20   // LTR Extended Capability Header.
  #define PCIEIP_REG_LTR_CAP_HDR_REG_CAP_ID_K2_E5                                                            (0xffff<<0) // LTR Extended Capacity ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LTR_CAP_HDR_REG_CAP_ID_K2_E5_SHIFT                                                      0
  #define PCIEIP_REG_LTR_CAP_HDR_REG_CAP_VERSION_K2_E5                                                       (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LTR_CAP_HDR_REG_CAP_VERSION_K2_E5_SHIFT                                                 16
  #define PCIEIP_REG_LTR_CAP_HDR_REG_NEXT_OFFSET_K2_E5                                                       (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_LTR_CAP_HDR_REG_NEXT_OFFSET_K2_E5_SHIFT                                                 20
#define PCIEIP_REG_LTR_LATENCY_REG_K2_E5                                                                     0x000288UL //Access:RW   DataWidth:0x20   // LTR Max Snoop and No-Snoop Latency Register.
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_SNOOP_LAT_K2_E5                                                     (0x3ff<<0) // Max Snoop Latency Value.
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_SNOOP_LAT_K2_E5_SHIFT                                               0
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_SNOOP_LAT_SCALE_K2_E5                                               (0x7<<10) // Max Snoop Latency Scale.
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_SNOOP_LAT_SCALE_K2_E5_SHIFT                                         10
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_NO_SNOOP_LAT_K2_E5                                                  (0x3ff<<16) // Max No-Snoop Latency Value.
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_NO_SNOOP_LAT_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_NO_SNOOP_LAT_SCALE_K2_E5                                            (0x7<<26) // Max No-Snoop Latency Scale.
  #define PCIEIP_REG_LTR_LATENCY_REG_MAX_NO_SNOOP_LAT_SCALE_K2_E5_SHIFT                                      26
#define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_K2_E5                                                              0x00028cUL //Access:RW   DataWidth:0x20   // Vendor-Specific Extended Capability Header.
  #define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_EXTENDED_CAP_ID_K2_E5                                            (0xffff<<0) // PCI Express Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_EXTENDED_CAP_ID_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_CAP_VERSION_K2_E5                                                (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_CAP_VERSION_K2_E5_SHIFT                                          16
  #define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_NEXT_OFFSET_K2_E5                                                (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RAS_DES_CAP_HEADER_REG_NEXT_OFFSET_K2_E5_SHIFT                                          20
#define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_K2_E5                                                          0x000290UL //Access:R    DataWidth:0x20   // Vendor-Specific Header.
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_VSEC_ID_K2_E5                                                (0xffff<<0) // VSEC ID.
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_VSEC_ID_K2_E5_SHIFT                                          0
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_VSEC_REV_K2_E5                                               (0xf<<16) // VSEC Rev.
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_VSEC_REV_K2_E5_SHIFT                                         16
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_VSEC_LENGTH_K2_E5                                            (0xfff<<20) // VSEC Length.
  #define PCIEIP_REG_VENDOR_SPECIFIC_HEADER_REG_VSEC_LENGTH_K2_E5_SHIFT                                      20
#define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_K2_E5                                                           0x000294UL //Access:RW   DataWidth:0x20   // Event Counter Control. This is a viewport control register.  - Setting the EVENT_COUNTER_EVENT_SELECT and EVENT_COUNTER_LANE_SELECT fields in this register determine the Event Counter data returned by the EVENT_COUNTER_DATA_REG viewport register.  - Setting the EVENT_COUNTER_ENABLE field in this register enables the Event Counter selected by the EVENT_COUNTER_EVENT_SELECT and EVENT_COUNTER_LANE_SELECT fields in this register.  - Setting the EVENT_COUNTER_CLEAR field in this register clears the Event Counter selected by the EVENT_COUNTER_EVENT_SELECT and EVENT_COUNTER_LANE_SELECT fields in this register.  - Reading the EVENT_COUNTER_STATUS field in this register returns the Enable status of the Event Counter selected by the EVENT_COUNTER_EVENT_SELECT and EVENT_COUNTER_LANE_SELECT fields in this register.
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_CLEAR_K2_E5                                     (0x3<<0) // Event Counter Clear. Clears the Event Counter selected by the EVENT_COUNTER_EVENT_SELECT and EVENT_COUNTER_LANE_SELECT fields in this register. You can clear the value of a specific Event Counter by writing the 'per clear' code and you can clear all event counters at once by writing the 'all clear' code. The read value is always '0'.  - 00: no change  - 01: per clear  - 10: no change  - 11: all clear  - Other: reserved
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_CLEAR_K2_E5_SHIFT                               0
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_ENABLE_K2_E5                                    (0x7<<2) // Event Counter Enable. Enables/disables the Event Counter selected by the EVENT_COUNTER_EVENT_SELECT and EVENT_COUNTER_LANE_SELECT fields in this register. By default, all event counters are disabled. You can enable/disable a specific Event Counter by writing the 'per event off' or 'per event on' codes. You can enable/disable all event counters by writing the 'all on' or 'all off' codes. The read value is always '0'.  - 000: no change  - 001: per event off  - 010: no change  - 011: per event on  - 100: no change  - 101: all off  - 110: no change  - 111: all on
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_ENABLE_K2_E5_SHIFT                              2
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_STATUS_K2_E5                                    (0x1<<7) // Event Counter Status. This register returns the current value of the Event Counter selected by the following fields:  - EVENT_COUNTER_EVENT_SELECT  - EVENT_COUNTER_LANE_SELECT Note: This register field is sticky.
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_STATUS_K2_E5_SHIFT                              7
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_LANE_SELECT_K2_E5                               (0xf<<8) // Event Counter Lane Select. This field in conjunction with EVENT_COUNTER_EVENT_SELECT indexes the Event Counter data returned by the EVENT_COUNTER_DATA_REG register.  - 0x0: Lane0  - 0x1: Lane1  - 0x2: Lane2  - ..  - 0xF: Lane15 Note: This register field is sticky.
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_LANE_SELECT_K2_E5_SHIFT                         8
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_EVENT_SELECT_K2_E5                              (0xfff<<16) // Event Counter Data Select. This field in conjunction with the EVENT_COUNTER_LANE_SELECT field indexes the Event Counter data returned by the EVENT_COUNTER_DATA_REG register.  - 27-24: Group number(4-bit: 0..0x7)  - 23-16: Event number(8-bit: 0..0x13) within the Group For example:  - 0x000: Ebuf Overflow  - 0x001: Ebuf Underrun  - ..  - 0x700: Tx Memory Write  - 0x713: Rx Message TLP For detailed definitions of Group number and Event number, see the RAS DES chapter in the Databook.  Note: This register field is sticky.
  #define PCIEIP_REG_EVENT_COUNTER_CONTROL_REG_EVENT_COUNTER_EVENT_SELECT_K2_E5_SHIFT                        16
#define PCIEIP_REG_EVENT_COUNTER_DATA_REG_K2_E5                                                              0x000298UL //Access:R    DataWidth:0x20   // Event Counter Data. This viewport register returns the data selected by the following fields:  - EVENT_COUNTER_EVENT_SELECT in EVENT_COUNTER_CONTROL_REG  - EVENT_COUNTER_LANE_SELECT in EVENT_COUNTER_CONTROL_REG For more details, see the RAS DES section in the Core Operations chapter of the Databook.
#define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_K2_E5                                                     0x00029cUL //Access:RW   DataWidth:0x20   // Time-based Analysis Control. Used for controlling the measurement of RX/TX data throughput and time spent in each low-power LTSSM state. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_TIMER_START_K2_E5                                       (0x1<<0) // Timer Start.  - 0: Start/Restart  - 1: Stop This bit will be cleared automatically when the measurement is finished. Note: The app_ras_des_tba_ctrl input also sets the contents of this field and controls the measurement start/stop.  Note: This register field is sticky.
  #define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_TIMER_START_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_TIME_BASED_DURATION_SELECT_K2_E5                        (0xff<<8) // Time-based Duration Select. Selects the duration of time-based analysis. When "manual control" is selected and TIMER_START is set to '1', this analysis never stops until TIMER_STOP is set to '0'.  - 0x0: Manual control  - 0x1: 1ms  - 0x2: 10ms  - 0x3: 100ms  - 0x4: 1s  - 0x5: 2s  - 0x6: 4s  - Else: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_TIME_BASED_DURATION_SELECT_K2_E5_SHIFT                  8
  #define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_TIME_BASED_REPORT_SELECT_K2_E5                          (0xff<<24) // Time-based Report Select. Selects what type of data is measured for the selected duration (TIME_BASED_DURATION_SELECT), and returned in TIME_BASED_ANALYSIS_DATA. Each type of data is measured using one of three types of units:  - Core_clk Cycles. Total time in ps is [Value of TIME_BASED_ANALYSIS_DATA returned when TIME_BASED_REPORT_SELECT=0x00] * TIME_BASED_ANALYSIS_DATA  - Aux_clk Cycles. Total time in ps is [Period of platform specific clock] * TIME_BASED_ANALYSIS_DATA  - Data Bytes. Actual amount of bytes is 16 * TIME_BASED_ANALYSIS_DATA Core_clk Cycles  - 0x00: Duration of 1 cycle  - 0x01: TxL0s  - 0x02: RxL0s  - 0x03: L0  - 0x04: L1 (Rsvd when aux_clk is supplied from the platform specific clock during L1, L1.1 or L1.2)  - 0x07: Configuration/Recovery Aux_clk Cycles  - 0x05: L1.1  - 0x06: L1.2 Data Bytes  - 0x20: Tx TLP Bytes  - 0x21: Rx TLP Bytes  - Else: Rsvd Note: This register field is sticky.
  #define PCIEIP_REG_TIME_BASED_ANALYSIS_CONTROL_REG_TIME_BASED_REPORT_SELECT_K2_E5_SHIFT                    24
#define PCIEIP_REG_TIME_BASED_ANALYSIS_DATA_REG_K2_E5                                                        0x0002a0UL //Access:R    DataWidth:0x20   // Time-based Analysis Data. Contains the measurement results of RX/TX data throughput and time spent in each low-power LTSSM state. This viewport register returns the data selected by the TIME_BASED_REPORT_SELECT field in TIME_BASED_ANALYSIS_CONTROL_REG For more details, see the RAS DES section in the Core Operations chapter of the Databook.
#define PCIEIP_REG_EINJ_ENABLE_REG_K2_E5                                                                     0x0002bcUL //Access:RW   DataWidth:0x20   // Error Injection Enable. Each type of error insertion is enabled by the corresponding bit in this register. The specific injection controls for each type of error are defined in the following registers:  - 0: CRC Error: EINJ0_CRC_REG  - 1: Sequence Number Error: EINJ1_SEQNUM_REG  - 2: DLLP Error: EINJ2_DLLP_REG   - 3: Symbol DataK Mask Error or Sync Header Error: EINJ3_SYMBOL_REG  - 4: FC Credit Update Error: EINJ4_FC_REG  - 5: TLP Duplicate/Nullify Error: EINJ5_SP_TLP_REG  - 6: Specific TLP Error: EINJ6_COMPARE_*_REG/EINJ6_CHANGE_*_REG/EINJ6_TLP_REG After the errors have been inserted by core, it will clear each bit here. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION0_ENABLE_K2_E5                                           (0x1<<0) // Error Injection0 Enable (CRC Error).  Enables insertion of errors into various CRC.  For more details, see the EINJ0_CRC_REG register.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION0_ENABLE_K2_E5_SHIFT                                     0
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION1_ENABLE_K2_E5                                           (0x1<<1) // Error Injection1 Enable (Sequence Number Error).  Enables insertion of errors into sequence numbers.  For more details, see the EINJ1_SEQNUM_REG register.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION1_ENABLE_K2_E5_SHIFT                                     1
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION2_ENABLE_K2_E5                                           (0x1<<2) // Error Injection2 Enable (DLLP Error).  Enables insertion of DLLP errors.  For more details, see the EINJ2_DLLP_REG register.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION2_ENABLE_K2_E5_SHIFT                                     2
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION3_ENABLE_K2_E5                                           (0x1<<3) // Error Injection3 Enable (Symbol DataK Mask Error or Sync Header Error).  Enables DataK masking of special symbols or the breaking of the sync header.  For more details, see the EINJ3_SYMBOL_REG register.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION3_ENABLE_K2_E5_SHIFT                                     3
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION4_ENABLE_K2_E5                                           (0x1<<4) // Error Injection4 Enable (FC Credit Update Error).  Enables insertion of errors into UpdateFCs.  For more details, see the EINJ4_FC_REG register.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION4_ENABLE_K2_E5_SHIFT                                     4
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION5_ENABLE_K2_E5                                           (0x1<<5) // Error Injection5 Enable (TLP Duplicate/Nullify Error).  Enables insertion of duplicate/nullified TLPs.  For more details, see the EINJ5_SP_TLP_REG register.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION5_ENABLE_K2_E5_SHIFT                                     5
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION6_ENABLE_K2_E5                                           (0x1<<6) // Error Injection6 Enable (Specific TLP Error). Enables insertion of errors into the packets that you select.  You can set this bit to '1' when you have disabled RAS datapath protection (DP) by setting CX_RASDP = CX_RASDP_RAM_PROT =0.  You can set this bit to '1' when you have disabled the address translation by setting ADDR_TRANSLATION_SUPPORT_EN=0. For more details, see the EINJ6_COMPARE_*_REG/EINJ6_CHANGE_*_REG/EINJ6_TLP_REG registers.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ_ENABLE_REG_ERROR_INJECTION6_ENABLE_K2_E5_SHIFT                                     6
#define PCIEIP_REG_EINJ0_CRC_REG_K2_E5                                                                       0x0002c0UL //Access:RW   DataWidth:0x20   // Error Injection Control 0 (CRC Error). Controls the insertion of errors into the CRC, and parity of ordered sets for the selected type of the packets as follows:  - LCRC. Bad TLP will be detected at the receiver side; receiver responds with NAK DLLP; Data Link Retry starts.  - 16-bit CRC of ACK/NAK DLLPs. Bad DLLP occurs at the receiver side; Replay NUM Rollover occurs.  - 16-bit CRC of UpdateFC DLLPs. Error insertion continues for the specific time; LTSSM transitions to the Recovery state because of the UpdateFC timeout (if the timeout is implemented at the receiver of the UpdateFCs).  - ECRC. If ECRC check is enabled, ECRC error is detected at the receiver side.  - FCRC. Framing error will be detected, TLP is discarded, and the LTSSM transitions to Recovery state.  - Parity of TSOS. Error insertion continues for the specific time; LTSSM Recovery/Configuration timeout will occur.  - Parity of SKPOS. Lane error will be detected at the receiver side.
  #define PCIEIP_REG_EINJ0_CRC_REG_EINJ0_COUNT_K2_E5                                                         (0xff<<0) // Error injection count. Indicates the number of errors. This register is decremented when the errors have been inserted.  - If the counter value is 0x01 and error is inserted, ERROR_INJECTION0_ENABLE in EINJ_ENABLE_REG returns 0b.  - If the counter value is 0x00 and ERROR_INJECTION0_ENABLE=1, the errors are inserted until ERROR_INJECTION0_ENABLE is set to '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ0_CRC_REG_EINJ0_COUNT_K2_E5_SHIFT                                                   0
  #define PCIEIP_REG_EINJ0_CRC_REG_EINJ0_CRC_TYPE_K2_E5                                                      (0xf<<8) // Error injection type. Selects the type of CRC error to be inserted.  Tx Path  - 0000b: New TLP's LCRC error injection  - 0001b: 16bCRC error injection of ACK/NAK DLLP  - 0010b: 16bCRC error injection of Update-FC DLLP  - 0011b: New TLP's ECRC error injection  - 0100b: TLP's FCRC error injection (128b/130b)  - 0101b: Parity error of TSOS (128b/130b)  - 0110b: Parity error of SKPOS (128b/130b) Rx Path  - 1000b: LCRC error injection  - 1011b: ECRC error injection  - Others: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_EINJ0_CRC_REG_EINJ0_CRC_TYPE_K2_E5_SHIFT                                                8
#define PCIEIP_REG_EINJ1_SEQNUM_REG_K2_E5                                                                    0x0002c4UL //Access:RW   DataWidth:0x20   // Error Injection Control 1 (Sequence Number Error).  Controls the sequence number of the specific TLPs and ACK/NAK DLLPs. Data Link Protocol Error will be detected at the Rx side of ACK/NAL DLLPs when one of these conditions is true:  - ((NEXT_TRANSMIT_SEQ -1) - AckNak_Seq_Num) mod 4096 > 2048  - (AckNak_Seq_Num - ACKD_SEQ) mod 4096 >= 2048 TLP is treated as Duplicate TLP at the Rx side when all these conditions are true:  - Sequence Number != NEXT_RCV_SEQ  - (NEXT_RCV_SEQ - Sequence Number) mod 4096 <= 2048 TLP is treated as Bad TLP at the Rx side when all these conditions are true:  - Sequence Number != NEXT_RCV_SEQ and  - (NEXT_RCV_SEQ - Sequence Number) mod 4096 > 2048
  #define PCIEIP_REG_EINJ1_SEQNUM_REG_EINJ1_COUNT_K2_E5                                                      (0xff<<0) // Error injection count. Indicates the number of errors. This register is decremented as the errors are being inserted.  - If the counter value is 0x01 and error is inserted, ERROR_INJECTION1_ENABLE in EINJ_ENABLE_REG returns '0'.  - If the counter value is 0x00 and ERROR_INJECTION1_ENABLE=1, the errors are inserted until ERROR_INJECTION1_ENABLE is set to '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ1_SEQNUM_REG_EINJ1_COUNT_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_EINJ1_SEQNUM_REG_EINJ1_SEQNUM_TYPE_K2_E5                                                (0x1<<8) // Sequence number type. Selects the type of sequence number.  - 0b: Insertion of New TLP's SEQ# error  - 1b: Insertion of ACK/NAK DLLP's SEQ# Error Note: This register field is sticky.
  #define PCIEIP_REG_EINJ1_SEQNUM_REG_EINJ1_SEQNUM_TYPE_K2_E5_SHIFT                                          8
  #define PCIEIP_REG_EINJ1_SEQNUM_REG_EINJ1_BAD_SEQNUM_K2_E5                                                 (0x1fff<<16) // Bad sequence number. Indicates the value to add/subtract from the naturally-assigned sequence numbers. This value is represented by two's complement.  - 0x0FFF: +4095  - ..  - 0x0002: +2  - 0x0001: +1  - 0x0000: 0  - 0x1FFF: -1  - 0x1FFE: -2  - ..  - 0x1001: -4095 For example:  - Set Type, SEQ# and Count  -- EINJ1_SEQNUM_TYPE =0 (Insert errors into new TLPs)  -- EINJ1_BAD_SEQNUM =0x1FFD (represents -3)  -- EINJ1_COUNT =1  - Enable Error Injection  -- ERROR_INJECTION1_ENABLE =1  - Send a TLP From the Core's Application Interface  -- Assume SEQ#5 is given to the TLP.  - The SEQ# is Changed to #2 by the Error Injection Function in Layer2.  -- 5 + (-3) = 2  - The TLP with SEQ#2 is Transmitted to PCIe Link. Note: This register field is sticky.
  #define PCIEIP_REG_EINJ1_SEQNUM_REG_EINJ1_BAD_SEQNUM_K2_E5_SHIFT                                           16
#define PCIEIP_REG_EINJ2_DLLP_REG_K2_E5                                                                      0x0002c8UL //Access:RW   DataWidth:0x20   // Error Injection Control 2 (DLLP Error). Controls the transmission of DLLPs and inserts the following errors:  - If "ACK/NAK DLLP's transmission block" is selected, replay timeout error will occur at the transmitter of the TLPs and then Data Link Retry will occur.  - If "Update FC DLLP's transmission block" is selected, LTSSM will transition to the Recovery state because of the UpdateFC timeout (if the timeout is implemented at the receiver of the UpdateFCs).  - If "Always Transmission for NAK DLLP" is selected, Data Link Retry will occur at the transmitter of the TLPs. Furthermore, Replay NUM Rollover will occur when the transmitter has been requested four times to send the TLP with the same sequence number.
  #define PCIEIP_REG_EINJ2_DLLP_REG_EINJ2_COUNT_K2_E5                                                        (0xff<<0) // Error injection count. Indicates the number of errors. This register is decremented as the errors are being inserted.  - If the counter value is 0x01 and the error is inserted, ERROR_INJECTION2_ENABLE in EINJ_ENABLE_REG returns '0'.  - If the counter value is 0x00 and ERROR_INJECTION2_ENABLE =1, the errors are inserted until ERROR_INJECTION2_ENABLE is set to '0'. This register is affected only when EINJ2_DLLP_TYPE =2'10b.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ2_DLLP_REG_EINJ2_COUNT_K2_E5_SHIFT                                                  0
  #define PCIEIP_REG_EINJ2_DLLP_REG_EINJ2_DLLP_TYPE_K2_E5                                                    (0x3<<8) // DLLP Type. Selects the type of DLLP errors to be inserted.  - 00b: ACK/NAK DLLP's transmission block  - 01b: Update FC DLLP's transmission block  - 10b: Always Transmission for NAK DLLP  - 11b: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_EINJ2_DLLP_REG_EINJ2_DLLP_TYPE_K2_E5_SHIFT                                              8
#define PCIEIP_REG_EINJ3_SYMBOL_REG_K2_E5                                                                    0x0002ccUL //Access:RW   DataWidth:0x20   // Error Injection Control 3 (Symbol Error). When 8b/10b encoding is used, this register controls error insertion into the special (K code) symbols.  - If TS1/TS2/FTS/E-Idle/SKP is selected, it affects whole of the ordered set. It might cause timeout of the LTSSM.  - If END/EDB/STP/SDP is selected, TLP/DLLP will be discarded at the receiver side. When 128b/130b encoding is used, this register controls error insertion into the sync-header.
  #define PCIEIP_REG_EINJ3_SYMBOL_REG_EINJ3_COUNT_K2_E5                                                      (0xff<<0) // Error injection count. Indicates the number of errors. This register is decremented as the errors are being inserted.  - If the counter value is 0x01 and error is inserted, ERROR_INJECTION3_ENABLE in EINJ_ENABLE_REG returns '0'.  - If the counter value is 0x00 and ERROR_INJECTION3_ENABLE =1, the errors are inserted until ERROR_INJECTION3_ENABLE is set to '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ3_SYMBOL_REG_EINJ3_COUNT_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_EINJ3_SYMBOL_REG_EINJ3_SYMBOL_TYPE_K2_E5                                                (0x7<<8) // Error Type. 8b/10b encoding - Mask K symbol.  - 000b: Reserved  - 001b: COM/PAD(TS1 Order set)  - 010b: COM/PAD(TS2 Order set)  - 011b: COM/FTS(FTS Order set)  - 100b: COM/IDL(E-Idle Order set)  - 101b: END/EDB Symbol  - 110b: STP/SDP Symbol  - 111b: COM/SKP(SKP Order set) 128b/130b encoding - Change sync header.  - 000b: Invert sync header  - Others: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_EINJ3_SYMBOL_REG_EINJ3_SYMBOL_TYPE_K2_E5_SHIFT                                          8
#define PCIEIP_REG_EINJ4_FC_REG_K2_E5                                                                        0x0002d0UL //Access:RW   DataWidth:0x20   // Error Injection Control 4 (FC Credit Error). Controls error insertion into the credit value in the UpdateFCs. It is possible to insert errors for any of the following types:  - Posted TLP Header credit  - Non-Posted TLP Header credit  - Completion TLP Header credit  - Posted TLP Data credit  - Non-Posted TLP Data credit  - Completion TLP Data credit These errors are not correctable while error insertion is enabled. Receiver buffer overflow error might occur.
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_COUNT_K2_E5                                                          (0xff<<0) // Error injection count. Indicates the number of errors. This register is decremented as the errors are being inserted.  - If the counter value is 0x01 and error is inserted, ERROR_INJECTION4_ENABLE in EINJ_ENABLE_REG returns '0'.  - If the counter value is 0x00 and ERROR_INJECTION4_ENABLE =1, the errors are inserted until ERROR_INJECTION4_ENABLE is set to '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_COUNT_K2_E5_SHIFT                                                    0
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_UPDFC_TYPE_K2_E5                                                     (0x7<<8) // Update-FC type. Selects the credit type.  - 000b: Posted TLP Header Credit value control  - 001b: Non-Posted TLP Header Credit value control  - 010b: Completion TLP Header Credit value control  - 011b: Reserved  - 100b: Posted TLP Data Credit value control  - 101b: Non-Posted TLP Data Credit value control  - 110b: Completion TLP Data Credit value control  - 111b: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_UPDFC_TYPE_K2_E5_SHIFT                                               8
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_VC_NUMBER_K2_E5                                                      (0x7<<12) // VC Number. Indicates target VC Number.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_VC_NUMBER_K2_E5_SHIFT                                                12
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_BAD_UPDFC_VALUE_K2_E5                                                (0x1fff<<16) // Bad update-FC credit value. Indicates the value to add/subtract from the UpdateFC credit. This value is represented by two's complement.  - 0x0FFF: +4095  - ..  - 0x0002: +2  - 0x0001: +1  - 0x0000: 0  - 0x1FFF: -1  - 0x1FFE: -2  - ..  - 0x1001: -4095 Note: This register field is sticky.
  #define PCIEIP_REG_EINJ4_FC_REG_EINJ4_BAD_UPDFC_VALUE_K2_E5_SHIFT                                          16
#define PCIEIP_REG_EINJ5_SP_TLP_REG_K2_E5                                                                    0x0002d4UL //Access:RW   DataWidth:0x20   // Error Injection Control 5 (Specific TLP Error). Controls the generation of specified TLPs. Correctable errors will occur which will be fixed by the PCIe protocol.  - For Duplicate TLP, the core initiates Data Link Retry by handling ACK DLLP as NAK DLLP. These TLPs will be duplicate TLPs at the receiver side.  - For Nullified TLP, the TLPs that the core transmits are changed into nullified TLPs and the original TLPs are stored in the retry buffer. The receiver of these TLPs will detect the lack of seq# and send NAK DLLP at the next TLP. Then the original TLPs are sent from retry buffer and the data controls are recovered. For 128 bit core or more than 128 bit, the core inserts errors the number of times of EINJ5_COUNT but doesn't ensure that the errors are continuously inserted into TLPs.
  #define PCIEIP_REG_EINJ5_SP_TLP_REG_EINJ5_COUNT_K2_E5                                                      (0xff<<0) // Error injection count. Indicates the number of errors. This register is decremented as the errors are being inserted.  - If the counter value is 0x01 and error is inserted, ERROR_INJECTION5_ENABLE in EINJ_ENABLE_REG returns '0'.  - If the counter value is 0x00 and ERROR_INJECTION5_ENABLE =1, the errors are inserted until ERROR_INJECTION5_ENABLE is set to '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ5_SP_TLP_REG_EINJ5_COUNT_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_EINJ5_SP_TLP_REG_EINJ5_SPECIFIED_TLP_K2_E5                                              (0x1<<8) // Specified TLP. Selects the specified TLP to be inserted.  - 0: Generates duplicate TLPs by handling ACK DLLP as NAK DLLP.  - 1: Generates Nullified TLP (Original TLP will be stored in retry buffer). Note: This register field is sticky.
  #define PCIEIP_REG_EINJ5_SP_TLP_REG_EINJ5_SPECIFIED_TLP_K2_E5_SHIFT                                        8
#define PCIEIP_REG_EINJ6_COMPARE_POINT_H0_REG_K2_E5                                                          0x0002d8UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Point Header DWORD #0). Program this register for the 1st DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW0[7:0], TLP_DW0[15:8], TLP_DW0[23:16], TLP_DW0[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_POINT_H1_REG_K2_E5                                                          0x0002dcUL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Point Header DWORD #1). Program this register for the 2nd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW1[7:0], TLP_DW1[15:8], TLP_DW1[23:16], TLP_DW1[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_POINT_H2_REG_K2_E5                                                          0x0002e0UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Point Header DWORD #2). Program this register for the 3rd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW2[7:0], TLP_DW2[15:8], TLP_DW2[23:16], TLP_DW2[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_POINT_H3_REG_K2_E5                                                          0x0002e4UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Point Header DWORD #3). Program this register for the 4th DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW3[7:0], TLP_DW3[15:8], TLP_DW3[23:16], TLP_DW3[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_VALUE_H0_REG_K2_E5                                                          0x0002e8UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Value Header DWORD #0). Program this register for the 1st DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW0[7:0], TLP_DW0[15:8], TLP_DW0[23:16], TLP_DW0[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_VALUE_H1_REG_K2_E5                                                          0x0002ecUL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Value Header DWORD #1). Program this register for the 2nd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW1[7:0], TLP_DW1[15:8], TLP_DW1[23:16], TLP_DW1[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_VALUE_H2_REG_K2_E5                                                          0x0002f0UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Value Header DWORD #2). Program this register for the 3rd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW2[7:0], TLP_DW2[15:8], TLP_DW2[23:16], TLP_DW2[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_COMPARE_VALUE_H3_REG_K2_E5                                                          0x0002f4UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Compare Value Header DWORD #3). Program this register for the 4th DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW3[7:0], TLP_DW3[15:8], TLP_DW3[23:16], TLP_DW3[31:24]  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the EINJ6_TLP_REG register.
#define PCIEIP_REG_EINJ6_CHANGE_POINT_H0_REG_K2_E5                                                           0x0002f8UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Point Header DWORD #0). Program this register for the 1st DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW0[7:0], TLP_DW0[15:8], TLP_DW0[23:16], TLP_DW0[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_EINJ6_CHANGE_POINT_H1_REG_K2_E5                                                           0x0002fcUL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Point Header DWORD #1). Program this register for the 2nd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW1[7:0], TLP_DW1[15:8], TLP_DW1[23:16], TLP_DW1[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_EINJ6_CHANGE_POINT_H2_REG_K2_E5                                                           0x000300UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Point Header DWORD #2). Program this register for the 3rd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW2[7:0], TLP_DW2[15:8], TLP_DW2[23:16], TLP_DW2[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_BB                                                            0x000300UL //Access:R    DataWidth:0x20   // The read-only value of this register is controlled by setting bit 1 of the EXT2_CAP_ENA for EP, The capability can be enabled by default by defining pcieGen3Rate in version.v and setting bit 1 of EXT2_CAP_ENA.
  #define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_SECPCIE_EXT_CAP_ID_BB                                       (0xffff<<0) // Secondary PCIE Extended Capability ID.
  #define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_SECPCIE_EXT_CAP_ID_BB_SHIFT                                 0
  #define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_CAP_VER_BB                                                  (0xf<<16) // Capability version. Hardwired to 0x1.
  #define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_CAP_VER_BB_SHIFT                                            16
  #define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_NEXT_BB                                                     (0xfff<<20) // This value continues the PCI capability chain. It's value specified an offset in the PCI address space of the next capability.
  #define PCIEIP_REG_SECONDARY_PCIE_EXTENDED_CAP_NEXT_BB_SHIFT                                               20
#define PCIEIP_REG_EINJ6_CHANGE_POINT_H3_REG_K2_E5                                                           0x000304UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Point Header DWORD #3). Program this register for the 4th DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW3[7:0], TLP_DW3[15:8], TLP_DW3[23:16], TLP_DW3[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_LINK_CONTROL3_BB                                                                          0x000304UL //Access:R    DataWidth:0x20   // The RW value of this register is controlled by setting bit 1 of the EXT2_CAP_ENA for EP.
  #define PCIEIP_REG_LINK_CONTROL3_PERFORM_EQ_BB                                                             (0x1<<0) // N/A to endpoints
  #define PCIEIP_REG_LINK_CONTROL3_PERFORM_EQ_BB_SHIFT                                                       0
  #define PCIEIP_REG_LINK_CONTROL3_LINK_EQ_REQ_INT_EN_BB                                                     (0x1<<1) // N/A to endpoints
  #define PCIEIP_REG_LINK_CONTROL3_LINK_EQ_REQ_INT_EN_BB_SHIFT                                               1
#define PCIEIP_REG_EINJ6_CHANGE_VALUE_H0_REG_K2_E5                                                           0x000308UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Value Header DWORD #0). Program this register for the 1st DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW0[7:0], TLP_DW0[15:8], TLP_DW0[23:16], TLP_DW0[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_LANE_ERROR_STATUS_BB                                                                      0x000308UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE_ERROR_STATUS_LANE_ERR_STATUS_BITS_BB                                               (0xffff<<0) // Each bit indicates if corresponding PCIE lane detected a lane based error.
  #define PCIEIP_REG_LANE_ERROR_STATUS_LANE_ERR_STATUS_BITS_BB_SHIFT                                         0
#define PCIEIP_REG_EINJ6_CHANGE_VALUE_H1_REG_K2_E5                                                           0x00030cUL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Value Header DWORD #1). Program this register for the 2nd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW1[7:0], TLP_DW1[15:8], TLP_DW1[23:16], TLP_DW1[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_BB                                                              0x00030cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS0_BB                                     (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS0_BB_SHIFT                               0
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS0_BB                                  (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane0
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS0_BB_SHIFT                            8
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS0_BB                                  (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane0
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS0_BB_SHIFT                            12
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_RESERVED0_BB                                                  (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_RESERVED0_BB_SHIFT                                            15
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS1_BB                                     (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS1_BB_SHIFT                               16
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS1_BB                                  (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane1
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS1_BB_SHIFT                            24
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS1_BB                                  (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane1
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS1_BB_SHIFT                            28
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_RESERVED1_BB                                                  (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE0_1_EQUALIZATION_CTRL_RESERVED1_BB_SHIFT                                            31
#define PCIEIP_REG_EINJ6_CHANGE_VALUE_H2_REG_K2_E5                                                           0x000310UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Value Header DWORD #2). Program this register for the 3rd DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW2[7:0], TLP_DW2[15:8], TLP_DW2[23:16], TLP_DW2[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_BB                                                              0x000310UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS2_BB                                     (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS2_BB_SHIFT                               0
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS2_BB                                  (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane2
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS2_BB_SHIFT                            8
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS2_BB                                  (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane2
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS2_BB_SHIFT                            12
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_RESERVED2_BB                                                  (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_RESERVED2_BB_SHIFT                                            15
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS3_BB                                     (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS3_BB_SHIFT                               16
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS3_BB                                  (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane3
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS3_BB_SHIFT                            24
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS3_BB                                  (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane3
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS3_BB_SHIFT                            28
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_RESERVED3_BB                                                  (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE2_3_EQUALIZATION_CTRL_RESERVED3_BB_SHIFT                                            31
#define PCIEIP_REG_EINJ6_CHANGE_VALUE_H3_REG_K2_E5                                                           0x000314UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Change Value Header DWORD #3). Program this register for the 4th DWORD of TLP header/prefix. It is necessary to carefully consider the endianness when you program this register.  Bits [31:0] = TLP_DW3[7:0], TLP_DW3[15:8], TLP_DW3[23:16], TLP_DW3[31:24]  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the EINJ6_TLP_REG register. Only applies when EINJ6_INVERTED_CONTROL in EINJ6_TLP_REG =0.
#define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_BB                                                              0x000314UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS4_BB                                     (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS4_BB_SHIFT                               0
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS4_BB                                  (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane4
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS4_BB_SHIFT                            8
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS4_BB                                  (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane4
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS4_BB_SHIFT                            12
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_RESERVED4_BB                                                  (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_RESERVED4_BB_SHIFT                                            15
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS5_BB                                     (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS5_BB_SHIFT                               16
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS5_BB                                  (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane5
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS5_BB_SHIFT                            24
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS5_BB                                  (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane5
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS5_BB_SHIFT                            28
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_RESERVED5_BB                                                  (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE4_5_EQUALIZATION_CTRL_RESERVED5_BB_SHIFT                                            31
#define PCIEIP_REG_EINJ6_TLP_REG_K2_E5                                                                       0x000318UL //Access:RW   DataWidth:0x20   // Error Injection Control 6 (Packet Error).  The Packet Compare Point registers (EINJ6_COMPARE_POINT*) specify which Tx TLP header bits to compare with the corresponding bits in the Packet Compare Value registers (EINJ6_COMPARE_VALUE*).  When all specified bits (in the Tx TLP header and EINJ6_COMPARE_VALUE*) match, the core inserts errors into the TLP. The type and number of errors are specified by the this register.  The Packet Change Point registers (EINJ6_CHANGE_POINT*) specify which Tx TLP header bits to replace with the corresponding bits in the Packet Change Value registers (EINJ6_CHANGE_VALUE*).  The type and number of errors are specified by the this register. Only applies when EINJ6_INVERTED_CONTROL in this register =0. The TLP into that errors are injected will not arrive at the transaction layer of the remote device when all of the following conditions are true.  - Using 128b/130b encoding  - Injecting errors into TLP Length field / TLP digest bit
  #define PCIEIP_REG_EINJ6_TLP_REG_EINJ6_COUNT_K2_E5                                                         (0xff<<0) // Error Injection Count.  Indicates the number of errors to insert. This counter is decremented while errors are been inserted.  - If the counter value is 0x01 and error is inserted, ERROR_INJECTION6_ENABLE in EINJ_ENABLE_REG returns '0'.  - If the counter value is 0x00 and ERROR_INJECTION6_ENABLE=1, errors are inserted until ERROR_INJECTION6_ENABLE is set to '0'.  Note: This register field is sticky.
  #define PCIEIP_REG_EINJ6_TLP_REG_EINJ6_COUNT_K2_E5_SHIFT                                                   0
  #define PCIEIP_REG_EINJ6_TLP_REG_EINJ6_INVERTED_CONTROL_K2_E5                                              (0x1<<8) // Inverted Error Injection Control.  - 0: EINJ6_CHANGE_VALUE_H[0/1/2/3] is used to replace bits specified by EINJ6_CHANGE_POINT_H[0/1/2/3].  - 1: EINJ6_CHANGE_VALUE_H[0/1/2/3] is ignored and inverts bits specified by EINJ6_CHANGE_POINT_H[0/1/2/3]. Note: This register field is sticky.
  #define PCIEIP_REG_EINJ6_TLP_REG_EINJ6_INVERTED_CONTROL_K2_E5_SHIFT                                        8
  #define PCIEIP_REG_EINJ6_TLP_REG_EINJ6_PACKET_TYPE_K2_E5                                                   (0x7<<9) // Packet type.  Selects the TLP packets to inject errors into.  - 0: TLP Header  - 1: TLP Prefix 1st 4-DWORDs  - 2: TLP Prefix 2nd -DWORDs  - Else: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_EINJ6_TLP_REG_EINJ6_PACKET_TYPE_K2_E5_SHIFT                                             9
#define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_BB                                                              0x000318UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS6_BB                                     (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS6_BB_SHIFT                               0
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS6_BB                                  (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane6
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS6_BB_SHIFT                            8
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS6_BB                                  (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane6
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS6_BB_SHIFT                            12
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_RESERVED6_BB                                                  (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_RESERVED6_BB_SHIFT                                            15
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS7_BB                                     (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS7_BB_SHIFT                               16
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS7_BB                                  (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane7
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS7_BB_SHIFT                            24
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS7_BB                                  (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane7
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS7_BB_SHIFT                            28
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_RESERVED7_BB                                                  (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE6_7_EQUALIZATION_CTRL_RESERVED7_BB_SHIFT                                            31
#define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_BB                                                              0x00031cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS8_BB                                     (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS8_BB_SHIFT                               0
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS8_BB                                  (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane8
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS8_BB_SHIFT                            8
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS8_BB                                  (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane8
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS8_BB_SHIFT                            12
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_RESERVED6_BB                                                  (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_RESERVED6_BB_SHIFT                                            15
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS9_BB                                     (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS9_BB_SHIFT                               16
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS9_BB                                  (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane9
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS9_BB_SHIFT                            24
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS9_BB                                  (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane9
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS9_BB_SHIFT                            28
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_RESERVED7_BB                                                  (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE8_9_EQUALIZATION_CTRL_RESERVED7_BB_SHIFT                                            31
#define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_BB                                                            0x000320UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS10_BB                                  (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS10_BB_SHIFT                            0
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS10_BB                               (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane10
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS10_BB_SHIFT                         8
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS10_BB                               (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane10
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS10_BB_SHIFT                         12
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_RESERVED10_BB                                               (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_RESERVED10_BB_SHIFT                                         15
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS11_BB                                  (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS11_BB_SHIFT                            16
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS11_BB                               (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane11
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS11_BB_SHIFT                         24
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS11_BB                               (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane11
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS11_BB_SHIFT                         28
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_RESERVED11_BB                                               (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE10_11_EQUALIZATION_CTRL_RESERVED11_BB_SHIFT                                         31
#define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_BB                                                            0x000324UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS12_BB                                  (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS12_BB_SHIFT                            0
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS12_BB                               (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane12
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS12_BB_SHIFT                         8
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS12_BB                               (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane12
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS12_BB_SHIFT                         12
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_RESERVED12_BB                                               (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_RESERVED12_BB_SHIFT                                         15
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS13_BB                                  (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS13_BB_SHIFT                            16
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS13_BB                               (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane13
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS13_BB_SHIFT                         24
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS13_BB                               (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane13
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS13_BB_SHIFT                         28
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_RESERVED13_BB                                               (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE12_13_EQUALIZATION_CTRL_RESERVED13_BB_SHIFT                                         31
#define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_BB                                                            0x000328UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS14_BB                                  (0xff<<0) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS14_BB_SHIFT                            0
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS14_BB                               (0xf<<8) // Latest Transmitter Preset Requested from Upstream Component on Lane14
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS14_BB_SHIFT                         8
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS14_BB                               (0x7<<12) // Latest Receiver Preset Requested from Upstream Component on Lane14
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS14_BB_SHIFT                         12
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_RESERVED14_BB                                               (0x1<<15) // Reserved
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_RESERVED14_BB_SHIFT                                         15
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS15_BB                                  (0xff<<16) // Applicable only to Upstream component.
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_UPSTREAM_COMP_PRESETS15_BB_SHIFT                            16
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS15_BB                               (0xf<<24) // Latest Transmitter Preset Requested from Upstream Component on Lane15
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_TX_PRESETS15_BB_SHIFT                         24
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS15_BB                               (0x7<<28) // Latest Receiver Preset Requested from Upstream Component on Lane15
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_DNSTREAM_COMP_RX_PRESETS15_BB_SHIFT                         28
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_RESERVED15_BB                                               (0x1<<31) // Reserved
  #define PCIEIP_REG_LANE14_15_EQUALIZATION_CTRL_RESERVED15_BB_SHIFT                                         31
#define PCIEIP_REG_SD_CONTROL1_REG_K2_E5                                                                     0x00032cUL //Access:RW   DataWidth:0x20   // Silicon Debug Control 1. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_CONTROL1_REG_FORCE_DETECT_LANE_K2_E5                                                 (0xffff<<0) // Force Detect Lane.  When the FORCE_DETECT_LANE_EN field is set, the core ignores receiver detection from PHY during LTSSM Detect state and uses this value instead.  - 0: Lane0  - 1: Lane1  - 2: Lane2  - ..  - 15: Lane15 Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL1_REG_FORCE_DETECT_LANE_K2_E5_SHIFT                                           0
  #define PCIEIP_REG_SD_CONTROL1_REG_FORCE_DETECT_LANE_EN_K2_E5                                              (0x1<<16) // Force Detect Lane Enable.  When this bit is set, the core ignores receiver detection from PHY during LTSSM Detect state and uses FORCE_DETECT_LANE.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL1_REG_FORCE_DETECT_LANE_EN_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_SD_CONTROL1_REG_TX_EIOS_NUM_K2_E5                                                       (0x3<<20) // Number of Tx EIOS.  This register sets the number of transmit EIOS for L0s/L1 entry and Disable/Loopback/Hot-reset exit. The core selects the greater value between this register and the value defined by the PCI-SIG specification.  2.5GT/s, 8.0GT/s or higher:  - 0x0: 1  - 0x1: 4  - 0x2: 8  - 0x3: 16 5.0GT/s:  - 0x0: 2  - 0x1: 8  - 0x2: 16  - 0x3: 32 Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL1_REG_TX_EIOS_NUM_K2_E5_SHIFT                                                 20
  #define PCIEIP_REG_SD_CONTROL1_REG_LOW_POWER_INTERVAL_K2_E5                                                (0x3<<22) // Low Power Entry Interval Time.  Interval Time that the core starts monitoring RXELECIDLE signal after L0s/L1/L2 entry. You should set the value according to the latency from receiving EIOS to, RXELECIDLE assertion at the PHY.  - 0x0: 40ns  - 0x1: 160ns  - 0x2: 320ns  - 0x3: 640ns Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL1_REG_LOW_POWER_INTERVAL_K2_E5_SHIFT                                          22
#define PCIEIP_REG_SD_CONTROL2_REG_K2_E5                                                                     0x000330UL //Access:RW   DataWidth:0x20   // Silicon Debug Control 2. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_CONTROL2_REG_HOLD_LTSSM_K2_E5                                                        (0x1<<0) // Hold and Release LTSSM.  For as long as this register is '1', the core stays in the current LTSSM.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL2_REG_HOLD_LTSSM_K2_E5_SHIFT                                                  0
  #define PCIEIP_REG_SD_CONTROL2_REG_RECOVERY_REQUEST_K2_E5                                                  (0x1<<1) // Recovery Request.  When this bit is set to '1' in L0 or L0s, the LTSSM starts transitioning to Recovery State. This request does not cause a speed change or re-equalization.
  #define PCIEIP_REG_SD_CONTROL2_REG_RECOVERY_REQUEST_K2_E5_SHIFT                                            1
  #define PCIEIP_REG_SD_CONTROL2_REG_NOACK_FORCE_LINKDOWN_K2_E5                                              (0x1<<2) // Force LinkDown.  When this bit is set and the core detects REPLY_NUM rolling over 4 times, the LTSSM transitions to Detect State.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL2_REG_NOACK_FORCE_LINKDOWN_K2_E5_SHIFT                                        2
  #define PCIEIP_REG_SD_CONTROL2_REG_DIRECT_RECIDLE_TO_CONFIG_K2_E5                                          (0x1<<8) // Direct Recovery.Idle to Configuration.  When this bit is set and the LTSSM is in Recovery Idle State, the LTSSM transitions to Configuration state.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL2_REG_DIRECT_RECIDLE_TO_CONFIG_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_SD_CONTROL2_REG_DIRECT_POLCOMP_TO_DETECT_K2_E5                                          (0x1<<9) // Direct Polling.Compliance to Detect.  When this bit is set and the LTSSM is in Polling Compliance State, the LTSSM transitions to Detect state.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL2_REG_DIRECT_POLCOMP_TO_DETECT_K2_E5_SHIFT                                    9
  #define PCIEIP_REG_SD_CONTROL2_REG_DETECT_LPBKSLV_TO_EXIT_K2_E5                                            (0x1<<10) // Detect Loopback Slave To Exit.  When this bit is set and the LTSSM is in Loopback Slave Active State, the LTSSM transitions to Loopback Slave Exit state.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL2_REG_DETECT_LPBKSLV_TO_EXIT_K2_E5_SHIFT                                      10
  #define PCIEIP_REG_SD_CONTROL2_REG_FRAMING_ERR_RECOVERY_DISABLE_K2_E5                                      (0x1<<16) // Framing Error Recovery Disable.  This bit forces a transition to Recovery state when a Framing Error is occurred.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_CONTROL2_REG_FRAMING_ERR_RECOVERY_DISABLE_K2_E5_SHIFT                                16
#define PCIEIP_REG_SD_STATUS_L1LANE_REG_K2_E5                                                                0x00033cUL //Access:RW   DataWidth:0x20   // Silicon Debug Status(Layer1 Per-lane). This viewport register returns the data selected by the following field:  - LANE_SELECT in SD_CONTROL1_REG For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_LANE_SELECT_K2_E5                                                  (0xf<<0) // Lane Select.  Lane Select register for Silicon Debug Status Register of Layer1-PerLane.  - 0x0: Lane0  - 0x1: Lane1  - 0x2: Lane2  - ..  - 0xF: Lane15 Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_LANE_SELECT_K2_E5_SHIFT                                            0
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_RXPOLARITY_K2_E5                                              (0x1<<16) // PIPE:RxPolarity.  Indicates PIPE RXPOLARITY signal of selected lane number(LANE_SELECT).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_RXPOLARITY_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_DETECT_LANE_K2_E5                                             (0x1<<17) // PIPE:Detect Lane.  Indicates whether PHY indicates receiver detection or not on selected lane number(LANE_SELECT).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_DETECT_LANE_K2_E5_SHIFT                                       17
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_RXVALID_K2_E5                                                 (0x1<<18) // PIPE:RxValid.  Indicates PIPE RXVALID signal of selected lane number(LANE_SELECT).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_RXVALID_K2_E5_SHIFT                                           18
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_RXELECIDLE_K2_E5                                              (0x1<<19) // PIPE:RxElecIdle.  Indicates PIPE RXELECIDLE signal of selected lane number(LANE_SELECT).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_RXELECIDLE_K2_E5_SHIFT                                        19
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_TXELECIDLE_K2_E5                                              (0x1<<20) // PIPE:TxElecIdle.  Indicates PIPE TXELECIDLE signal of selected lane number(LANE_SELECT).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_PIPE_TXELECIDLE_K2_E5_SHIFT                                        20
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_DESKEW_POINTER_K2_E5                                               (0xff<<24) // Deskew Pointer.  Indicates Deskew pointer of internal Deskew buffer of selected lane number(LANE_SELECT).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LANE_REG_DESKEW_POINTER_K2_E5_SHIFT                                         24
#define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_K2_E5                                                               0x000340UL //Access:RW   DataWidth:0x20   // Silicon Debug Status(Layer1 LTSSM). For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_FRAMING_ERR_PTR_K2_E5                                             (0x7f<<0) // First Framing Error Pointer.  Identifies the first Framing Error using the following encoding. The field contents are only valid value when FRAMING_ERR =1.  Received Unexpected Framing Token  - 01h: When non- STP/SDP/IDL Token was received and it was not in TLP/DLLP reception  - 02h: When current token was not a valid EDB token and previous token was an EDB. (128/256 bit core only)  - 03h: When SDP token was received but not expected. (128 bit & (x8 | x16) core only)  - 04h: When STP token was received but not expected. (128 bit & (x8 | x16) core only)  - 05h: When EDS token was expected but not received or whenever an EDS token was received but not expected.  - 06h: When a framing error was detected in the deskew block while a packet has been in progress in token_finder. Received Unexpected STP Token  - 11h: When Framing CRC in STP token did not match  - 12h: When Framing Parity in STP token did not match.  - 13h: When Framing TLP Length in STP token was smaller than 5 DWORDs. Received Unexpected Block  - 21h: When Receiving an OS Block following SDS in Datastream state  - 22h: When Data Block followed by OS Block different from SKP, EI, EIE in Datastream state  - 23h: When Block with an undefined Block Type in Datastream state  - 24h: When Data Stream without data over three cycles in Datastream state  - 25h: When OS Block during Data Stream in Datastream state  - 26h: When RxStatus Error was detected in Datastream state  - 27h: When Not all active lanes receiving SKP OS starting at same cycle time in SKPOS state  - 28h: When a 2-Block timeout occurs for SKP OS in SKPOS state  - 29h: When Receiving consecutive OS Blocks within a Data Stream in SKPOS state  - 2Ah: When Phy status error was detected in SKPOS state  - 2Bh: When Not all active lanes receiving EIOS starting at same cycle time in EIOS state  - 2Ch: When At least one Symbol from the first 4 Symbols is not EIOS Symbol in EIOS state (CX_NB=2 only)  - 2Dh: When Not all active lanes receiving EIEOS starting at same cycle time in EIEOS state  - 2Eh: When Not full 16 eieos symbols are received in EIEOS state All other values not listed above are Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_FRAMING_ERR_PTR_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_FRAMING_ERR_K2_E5                                                 (0x1<<7) // Framing Error.  Indicates Framing Error detection status.
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_FRAMING_ERR_K2_E5_SHIFT                                           7
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_PIPE_POWER_DOWN_K2_E5                                             (0x7<<8) // PIPE:PowerDown.  Indicates PIPE PowerDown signal.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_PIPE_POWER_DOWN_K2_E5_SHIFT                                       8
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_LANE_REVERSAL_K2_E5                                               (0x1<<15) // Lane Reversal Operation.  Receiver detected lane reversal.  This field is only valid in the L0 LTSSM state.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_LANE_REVERSAL_K2_E5_SHIFT                                         15
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_LTSSM_VARIABLE_K2_E5                                              (0xffff<<16) // LTSSM Variable.  Indicates internal LTSSM variables defined in the PCI Express base specification.  C-PCIe Mode:  - 0: directed_speed_change  - 1: changed_speed_recovery  - 2: successful_speed_negotiation  - 3: upconfigure_capable; Set to '1' if both ports advertised the UpConfigure capability in the last Config.Complete.  - 4: select_deemphasis  - 5: start_equalization_w_preset  - 6: equalization_done_8GT_data_rate  - 7: equalization_done_16GT_data_rate  - 15:8: idle_to_rlock_transitioned M-PCIe Mode:  - 0: idle_to_recovery  - 1: recovery_to_configuration Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L1LTSSM_REG_LTSSM_VARIABLE_K2_E5_SHIFT                                        16
#define PCIEIP_REG_SD_STATUS_PM_REG_K2_E5                                                                    0x000344UL //Access:RW   DataWidth:0x20   // Silicon Debug Status(PM). For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_STATUS_PM_REG_INTERNAL_PM_MSTATE_K2_E5                                               (0x1f<<0) // Internal PM State(Master).  Indicates internal state machine of Power Management Master controller.  - 0h: S_IDLE  - 1h: S_RESPOND_NAK  - 2h: S_BLOCK_TLP  - 3h: S_WAIT_LAST_TLP_ACK  - 4h: S_WAIT_EIDLE  - 5h: S_LINK_ENTR_L1  - 6h: S_L1  - 7h: S_L1_EXIT  - 8h: S_L23RDY  - 9h: S_LINK_ENTR_L23  - Ah: S_L23RDY_WAIT4ALIVE  - Bh: S_ACK_WAIT4IDLE Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_PM_REG_INTERNAL_PM_MSTATE_K2_E5_SHIFT                                         0
  #define PCIEIP_REG_SD_STATUS_PM_REG_INTERNAL_PM_SSTATE_K2_E5                                               (0xf<<8) // Internal PM State(Slave).  Indicates internal state machine of Power Management Slave controller.  - 00h: IDLE  - 01h: L0  - 02h: L0S  - 03h: ENTER_L0S  - 04h: L0S_EXIT  - 08h: L1  - 09h: L1_BLOCK_TLP  - 0Ah: L1_WAIT_LAST_TLP_ACK  - 0Bh: L1_WAIT_PMDLLP_ACK  - 0Ch: L1_LINK_ENTR_L1  - 0Dh: L1_EXIT  - 0Fh: PREP_4L1  - 10h: L23_BLOCK_TLP  - 11h: L23_WAIT_LAST_TLP_ACK  - 12h: L23_WAIT_PMDLLP_ACK  - 13h: L23_ENTR_L23  - 14h: L23RDY  - 15h: PREP_4L23  - 16h: L23RDY_WAIT4ALIVE  - 17h: L0S_BLOCK_TLP Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_PM_REG_INTERNAL_PM_SSTATE_K2_E5_SHIFT                                         8
  #define PCIEIP_REG_SD_STATUS_PM_REG_PME_RESEND_FLAG_K2_E5                                                  (0x1<<12) // PME Re-send flag.  When the DUT sends a PM_PME message TLP, the DUT sets PME_Status bit. If host software does not clear PME_Status bit for 100ms(+50%/-5%), the DUT resends the PM_PME Message. This bit indicates that a PM_PME was resent.
  #define PCIEIP_REG_SD_STATUS_PM_REG_PME_RESEND_FLAG_K2_E5_SHIFT                                            12
  #define PCIEIP_REG_SD_STATUS_PM_REG_LATCHED_NFTS_K2_E5                                                     (0xff<<16) // Latched N_FTS.  Indicates the value of N_FTS in the received TS Ordered Sets from the Link Partner  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_PM_REG_LATCHED_NFTS_K2_E5_SHIFT                                               16
#define PCIEIP_REG_SD_STATUS_L2_REG_K2_E5                                                                    0x000348UL //Access:R    DataWidth:0x20   // Silicon Debug Status(Layer2). For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_STATUS_L2_REG_TX_TLP_SEQ_NO_K2_E5                                                    (0xfff<<0) // Tx Tlp Sequence Number.  Indicates next transmit sequence number for transmit TLP.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L2_REG_TX_TLP_SEQ_NO_K2_E5_SHIFT                                              0
  #define PCIEIP_REG_SD_STATUS_L2_REG_RX_ACK_SEQ_NO_K2_E5                                                    (0xfff<<12) // Tx Ack Sequence Number.  Indicates ACKD_SEQ which is updated by receiving ACK/NAK DLLP.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L2_REG_RX_ACK_SEQ_NO_K2_E5_SHIFT                                              12
  #define PCIEIP_REG_SD_STATUS_L2_REG_DLCMSM_K2_E5                                                           (0x3<<24) // DLCMSM.  Indicates the current DLCMSM.  - 00b: DL_INACTIVE  - 01b: DL_FC_INIT  - 11b: DL_ACTIVE Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L2_REG_DLCMSM_K2_E5_SHIFT                                                     24
  #define PCIEIP_REG_SD_STATUS_L2_REG_FC_INIT1_K2_E5                                                         (0x1<<26) // FC_INIT1.  Indicates the core is in FC_INIT1(VC0) state.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L2_REG_FC_INIT1_K2_E5_SHIFT                                                   26
  #define PCIEIP_REG_SD_STATUS_L2_REG_FC_INIT2_K2_E5                                                         (0x1<<27) // FC_INIT2. Indicates the core is in FC_INIT2(VC0) state.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L2_REG_FC_INIT2_K2_E5_SHIFT                                                   27
#define PCIEIP_REG_SD_STATUS_L3FC_REG_K2_E5                                                                  0x00034cUL //Access:RW   DataWidth:0x20   // Silicon Debug Status(Layer3 FC). The CREDIT_DATA[0/1] fields in this viewport register return the data for the VC and TLP Type selected by the following fields:  - CREDIT_SEL_VC  - CREDIT_SEL_CREDIT_TYPE  - CREDIT_SEL_TLP_TYPE  - CREDIT_SEL_HD For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_VC_K2_E5                                                  (0x7<<0) // Credit Select(VC).  This field in conjunction with the CREDIT_SEL_CREDIT_TYPE, CREDIT_SEL_TLP_TYPE, and CREDIT_SEL_HD viewport-select fields determines that data that is returned by the CREDIT_DATA0 and CREDIT_DATA1 data fields.  - 0x0: VC0  - 0x1: VC1  - 0x2: VC2  - ..  - 0x7: VC7 Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_VC_K2_E5_SHIFT                                            0
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_CREDIT_TYPE_K2_E5                                         (0x1<<3) // Credit Select(Credit Type).  This field in conjunction with the CREDIT_SEL_VC, CREDIT_SEL_TLP_TYPE, and CREDIT_SEL_HD viewport-select fields determines that data that is returned by the CREDIT_DATA0 and CREDIT_DATA1 data fields.  - 0x0: Rx  - 0x1: Tx Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_CREDIT_TYPE_K2_E5_SHIFT                                   3
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_TLP_TYPE_K2_E5                                            (0x3<<4) // Credit Select(TLP Type).  This field in conjunction with the CREDIT_SEL_VC, CREDIT_SEL_CREDIT_TYPE, and CREDIT_SEL_HD viewport-select fields determines that data that is returned by the CREDIT_DATA0 and CREDIT_DATA1 data fields.  - 0x0: Posted  - 0x1: Non-Posted  - 0x2: Completion Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_TLP_TYPE_K2_E5_SHIFT                                      4
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_HD_K2_E5                                                  (0x1<<6) // Credit Select(HeaderData).  This field in conjunction with the CREDIT_SEL_VC, CREDIT_SEL_CREDIT_TYPE, and CREDIT_SEL_TLP_TYPE viewport-select fields determines that data that is returned by the CREDIT_DATA0 and CREDIT_DATA1 data fields.  - 0x0: Header Credit  - 0x1: Data Credit Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_SEL_HD_K2_E5_SHIFT                                            6
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_DATA0_K2_E5                                                   (0xfff<<8) // Credit Data0.  Current FC credit data selected by the CREDIT_SEL_VC, CREDIT_SEL_CREDIT_TYPE, CREDIT_SEL_TLP_TYPE, and CREDIT_SEL_HD viewport-select fields.  - Rx: Credit Received Value  - Tx: Credit Consumed Value Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_DATA0_K2_E5_SHIFT                                             8
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_DATA1_K2_E5                                                   (0xfff<<20) // Credit Data1.  Current FC credit data selected by the CREDIT_SEL_VC, CREDIT_SEL_CREDIT_TYPE, CREDIT_SEL_TLP_TYPE, and CREDIT_SEL_HD viewport-select fields.  - Rx: Credit Allocated Value  - Tx: Credit Limit Value. This value is valid when DLCMSM=0x3(DL_ACTIVE). Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3FC_REG_CREDIT_DATA1_K2_E5_SHIFT                                             20
#define PCIEIP_REG_SD_STATUS_L3_REG_K2_E5                                                                    0x000350UL //Access:RW   DataWidth:0x20   // Silicon Debug Status(Layer3). For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_STATUS_L3_REG_MFTLP_POINTER_K2_E5                                                    (0x7f<<0) // First Malformed TLP Error Pointer.  Indicates the element of the received first malformed TLP. This pointer is validated by MFTLP_STATUS.  - 01h: AtomicOp address alignment  - 02h: AtomicOp operand  - 03h: AtomicOp  byte enable  - 04h: TLP length miss match  - 05h: Max payload size  - 06h: Message TLP without TC0  - 07h: Invalid TC  - 08h: Unexpected route bit in Message TLP  - 09h: Unexpected CRS status in Completion TLP  - 0Ah: Byte enable  - 0Bh: Memory Address 4KB boundary  - 0Ch: TLP prefix rules  - 0Dh: Translation request rules  - 0Eh: Invalid TLP type  - 0Fh: Completion rules  - 7Fh: Application  - Else: Reserved Note: This register field is sticky.
  #define PCIEIP_REG_SD_STATUS_L3_REG_MFTLP_POINTER_K2_E5_SHIFT                                              0
  #define PCIEIP_REG_SD_STATUS_L3_REG_MFTLP_STATUS_K2_E5                                                     (0x1<<7) // Malformed TLP Status.  Indicates malformed TLP has occurred.
  #define PCIEIP_REG_SD_STATUS_L3_REG_MFTLP_STATUS_K2_E5_SHIFT                                               7
#define PCIEIP_REG_SD_EQ_CONTROL1_REG_K2_E5                                                                  0x00035cUL //Access:RW   DataWidth:0x20   // Silicon Debug EQ Control 1. This is a viewport control register. Setting the EQ_RATE_SEL and EQ_LANE_SEL fields in this register determine the per-lane Silicon Debug EQ Status data returned by the SD_EQ_STATUS[1/2/3] viewport registers. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_EQ_LANE_SEL_K2_E5                                                    (0xf<<0) // EQ Status Lane Select.  Setting this field in conjunction with the EQ_RATE_SEL field determines the per-lane Silicon Debug EQ Status data returned by the SD_EQ_CONTROL[2/3] and SD_EQ_STATUS[1/2/3] viewport registers.  - 0x0: Lane0  - 0x1: Lane1  - 0x2: Lane2  - ..  - 0xF: Lane15 Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_EQ_LANE_SEL_K2_E5_SHIFT                                              0
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_EQ_RATE_SEL_K2_E5                                                    (0x1<<4) // EQ Status Rate Select.  Setting this field in conjunction with the EQ_LANE_SEL field determines the per-lane Silicon Debug EQ Status data returned by the SD_EQ_CONTROL[2/3] and SD_EQ_STATUS[1/2/3] viewport registers.  - 0x0: 8.0GT/s Speed  - 0x1: 16.0GT/s Speed Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_EQ_RATE_SEL_K2_E5_SHIFT                                              4
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_EVAL_INTERVAL_TIME_K2_E5                                             (0x3<<16) // Eval Interval Time.  Indicates interval time of RxEqEval assertion.  - 00: 500ns  - 01: 1us  - 10: 2us  - 11: 4us This field is used for EQ Master(DSP in EQ Phase3/USP in EQ Phase2).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_EVAL_INTERVAL_TIME_K2_E5_SHIFT                                       16
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_FOM_TARGET_ENABLE_K2_E5                                              (0x1<<23) // FOM Target Enable.  Enables the FOM_TARGET fields.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_FOM_TARGET_ENABLE_K2_E5_SHIFT                                        23
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_FOM_TARGET_K2_E5                                                     (0xff<<24) // FOM Target.  Indicates figure of merit target criteria value of EQ Master(DSP in EQ Phase3/USP in EQ Phase2).  This field is only valid when GEN3_EQ_FB_MODE is 0001b(Figure Of Merit).  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL1_REG_FOM_TARGET_K2_E5_SHIFT                                               24
#define PCIEIP_REG_SD_EQ_CONTROL2_REG_K2_E5                                                                  0x000360UL //Access:RW   DataWidth:0x20   // Silicon Debug EQ Control 2. This viewport register returns the value for the rate and lane selected by the EQ_RATE_SEL and EQ_LANE_SEL fields in the SD_EQ_CONTROL1_REG register. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_PRE_CURSOR_K2_E5                                      (0x3f<<0) // Force Local Transmitter Pre-cursor.  Indicates the coefficient value of EQ Slave(DSP in EQ Phase2/USP in EQ Phase3), instead of the value instructed from link partner.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_PRE_CURSOR_K2_E5_SHIFT                                0
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_CURSOR_K2_E5                                          (0x3f<<6) // Force Local Transmitter Cursor.  Indicates the coefficient value of EQ Slave(DSP in EQ Phase2/USP in EQ Phase3), instead of the value instructed from link partner.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_CURSOR_K2_E5_SHIFT                                    6
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_POST_CURSOR_K2_E5                                     (0x3f<<12) // Force Local Transmitter Post-Cursor.  Indicates the coefficient value of EQ Slave(DSP in EQ Phase2/USP in EQ Phase3), instead of the value instructed from link partner.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_POST_CURSOR_K2_E5_SHIFT                               12
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_RX_HINT_K2_E5                                            (0x7<<18) // Force Local Receiver Preset Hint.  Indicates the RxPresetHint value of EQ Slave(DSP in EQ Phase2/USP in EQ Phase3), instead of received or set value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_RX_HINT_K2_E5_SHIFT                                      18
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_PRESET_K2_E5                                          (0xf<<24) // Force Local Transmitter Preset.  Indicates initial preset value of USP in EQ Slave(EQ Phase2) instead of receiving EQ TS2.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_PRESET_K2_E5_SHIFT                                    24
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_COEF_ENABLE_K2_E5                                     (0x1<<28) // Force Local Transmitter Coefficient Enable.  Enables the following fields:  - FORCE_LOCAL_TX_PRE_CURSOR  - FORCE_LOCAL_TX_CURSOR  - FORCE_LOCAL_TX_POST_CURSOR Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_COEF_ENABLE_K2_E5_SHIFT                               28
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_RX_HINT_ENABLE_K2_E5                                     (0x1<<29) // Force Local Receiver Preset Hint Enable.  Enables the FORCE_LOCAL_RX_HINT field.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_RX_HINT_ENABLE_K2_E5_SHIFT                               29
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_PRESET_ENABLE_K2_E5                                   (0x1<<30) // Force Local Transmitter Preset Enable.  Enables the FORCE_LOCAL_TX_PRESET field.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL2_REG_FORCE_LOCAL_TX_PRESET_ENABLE_K2_E5_SHIFT                             30
#define PCIEIP_REG_SD_EQ_CONTROL3_REG_K2_E5                                                                  0x000364UL //Access:RW   DataWidth:0x20   // Silicon Debug EQ Control 3. This viewport register returns the value for the rate and lane selected by the EQ_RATE_SEL and EQ_LANE_SEL fields in the SD_EQ_CONTROL1_REG register. For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_PRE_CURSOR_K2_E5                                     (0x3f<<0) // Force Remote Transmitter Pre-Cursor.  Indicates the coefficient value of EQ Master(DSP in EQ Phase3/USP in EQ Phase2), instead of the value instructed from link partner.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_PRE_CURSOR_K2_E5_SHIFT                               0
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_CURSOR_K2_E5                                         (0x3f<<6) // Force Remote Transmitter Cursor.  Indicates the coefficient value of EQ Master(DSP in EQ Phase3/USP in EQ Phase2), instead of the value instructed from link partner.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_CURSOR_K2_E5_SHIFT                                   6
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_POST_CURSOR_K2_E5                                    (0x3f<<12) // Force Remote Transmitter Post-Cursor.  Indicates the coefficient value of EQ Master(DSP in EQ Phase3/USP in EQ Phase2), instead of the value instructed from link partner.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_POST_CURSOR_K2_E5_SHIFT                              12
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_COEF_ENABLE_K2_E5                                    (0x1<<28) // Force Remote Transmitter Coefficient Enable.  Enables the following fields:  - FORCE_REMOTE_TX_PRE_CURSOR  - FORCE_REMOTE_TX_CURSOR  - FORCE_REMOTE_TX_POST_CURSOR Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_CONTROL3_REG_FORCE_REMOTE_TX_COEF_ENABLE_K2_E5_SHIFT                              28
#define PCIEIP_REG_SD_EQ_STATUS1_REG_K2_E5                                                                   0x00036cUL //Access:R    DataWidth:0x20   // Silicon Debug EQ Status 1. This viewport register returns the first of three words of Silicon Debug EQ Status data for the rate and lane selected by the EQ_RATE_SEL and EQ_LANE_SEL fields in the SD_EQ_CONTROL1_REG register. The following fields are available when Equalization finished unsuccessfully(EQ_CONVERGENCE_INFO=2).  - EQ_RULEA_VIOLATION  - EQ_RULEB_VIOLATION  - EQ_RULEC_VIOLATION  - EQ_REJECT_EVENT For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_SEQUENCE_K2_E5                                                     (0x1<<0) // EQ Sequence.  Indicates that the core is starting the equalization sequence.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_SEQUENCE_K2_E5_SHIFT                                               0
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_CONVERGENCE_INFO_K2_E5                                             (0x3<<1) // EQ Convergence Info.  Indicates equalization convergence information.  - 0x0: Equalization is not attempted  - 0x1: Equalization finished successfully  - 0x2: Equalization finished unsuccessfully  - 0x3: Reserved This bit is automatically cleared when the core starts EQ Master phase again.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_CONVERGENCE_INFO_K2_E5_SHIFT                                       1
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_RULEA_VIOLATION_K2_E5                                              (0x1<<4) // EQ Rule A Violation.  Indicates that coefficient rule A violation is detected in the values provided by PHY using direction change method during EQ Master phase(DSP in EQ Phase3/USP in EQ Phase2).  This bit is automatically cleared when the core starts EQ Master phase again.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_RULEA_VIOLATION_K2_E5_SHIFT                                        4
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_RULEB_VIOLATION_K2_E5                                              (0x1<<5) // EQ Rule B Violation.  Indicates that coefficient rule B violation is detected in the values provided by PHY using direction change method during EQ Master phase(DSP in EQ Phase3/USP in EQ Phase2).  This bit is automatically cleared when the core starts EQ Master phase again.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_RULEB_VIOLATION_K2_E5_SHIFT                                        5
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_RULEC_VIOLATION_K2_E5                                              (0x1<<6) // EQ Rule C Violation.  Indicates that coefficient rule C violation is detected in the values provided by PHY using direction change method during EQ Master phase(DSP in EQ Phase3/USP in EQ Phase2).  This bit is automatically cleared when the core starts EQ Master phase again.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_RULEC_VIOLATION_K2_E5_SHIFT                                        6
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_REJECT_EVENT_K2_E5                                                 (0x1<<7) // EQ Reject Event.  Indicates that the core receives two consecutive TS1 OS w/Reject=1b during EQ Master phase(DSP in EQ Phase3/USP in EQ Phase2). This bit is automatically cleared when the core starts EQ Master phase again.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS1_REG_EQ_REJECT_EVENT_K2_E5_SHIFT                                           7
#define PCIEIP_REG_SD_EQ_STATUS2_REG_K2_E5                                                                   0x000370UL //Access:R    DataWidth:0x20   // Silicon Debug EQ Status 2. This viewport register returns the second of three words of Silicon Debug EQ Status data for the rate and lane selected by the EQ_RATE_SEL and EQ_LANE_SEL fields in the SD_EQ_CONTROL1_REG register. Each field is available when Equalization finished successfully(EQ_CONVERGENCE_INFO=1). For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_PRE_CURSOR_K2_E5                                             (0x3f<<0) // EQ Local Pre-Cursor.  Indicates Local pre cursor coefficient value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_PRE_CURSOR_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_CURSOR_K2_E5                                                 (0x3f<<6) // EQ Local Cursor.  Indicates Local cursor coefficient value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_CURSOR_K2_E5_SHIFT                                           6
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_POST_CURSOR_K2_E5                                            (0x3f<<12) // EQ Local Post-Cursor.  Indicates Local post cursor coefficient value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_POST_CURSOR_K2_E5_SHIFT                                      12
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_RX_HINT_K2_E5                                                (0x7<<18) // EQ Local Receiver Preset Hint.  Indicates Local Receiver Preset Hint value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_RX_HINT_K2_E5_SHIFT                                          18
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_FOM_VALUE_K2_E5                                              (0xff<<24) // EQ Local Figure of Merit.  Indicates Local maximum Figure of Merit value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS2_REG_EQ_LOCAL_FOM_VALUE_K2_E5_SHIFT                                        24
#define PCIEIP_REG_SD_EQ_STATUS3_REG_K2_E5                                                                   0x000374UL //Access:R    DataWidth:0x20   // Silicon Debug EQ Status 3. This viewport register returns the third of three words of Silicon Debug EQ Status data for the rate and lane selected by the EQ_RATE_SEL and EQ_LANE_SEL fields in the SD_EQ_CONTROL1_REG register. Each field is available when Equalization finished successfully(EQ_CONVERGENCE_INFO=1). For more details, see the RAS DES section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_PRE_CURSOR_K2_E5                                            (0x3f<<0) // EQ Remote Pre-Cursor.  Indicates Remote pre cursor coefficient value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_PRE_CURSOR_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_CURSOR_K2_E5                                                (0x3f<<6) // EQ Remote Cursor.  Indicates Remote cursor coefficient value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_CURSOR_K2_E5_SHIFT                                          6
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_POST_CURSOR_K2_E5                                           (0x3f<<12) // EQ Remote Post-Cursor.  Indicates Remote post cursor coefficient value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_POST_CURSOR_K2_E5_SHIFT                                     12
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_LF_K2_E5                                                    (0x3f<<18) // EQ Remote LF.  Indicates Remote LF value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_LF_K2_E5_SHIFT                                              18
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_FS_K2_E5                                                    (0x3f<<24) // EQ Remote FS.  Indicates Remote FS value.  Note: This register field is sticky.
  #define PCIEIP_REG_SD_EQ_STATUS3_REG_EQ_REMOTE_FS_K2_E5_SHIFT                                              24
#define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_K2_E5                                                               0x00038cUL //Access:RW   DataWidth:0x20   // PCIe Extended capability ID, Capability version and Next capability offset.
  #define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_ID_K2_E5                                                          (0xffff<<0) // PCI Express Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_ID_K2_E5_SHIFT                                                    0
  #define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_CAP_K2_E5                                                         (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_CAP_K2_E5_SHIFT                                                   16
  #define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_NEXT_OFFSET_K2_E5                                                 (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_EXT_CAP_HDR_OFF_NEXT_OFFSET_K2_E5_SHIFT                                           20
#define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_K2_E5                                                       0x000390UL //Access:R    DataWidth:0x20   // Vendor Specific Header.
  #define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_VSEC_ID_K2_E5                                             (0xffff<<0) // VSEC ID.   Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_VSEC_ID_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_VSEC_REV_K2_E5                                            (0xf<<16) // VSEC Rev.   Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_VSEC_REV_K2_E5_SHIFT                                      16
  #define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_VSEC_LENGTH_K2_E5                                         (0xfff<<20) // VSEC Length.   Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_VENDOR_SPECIFIC_HDR_OFF_VSEC_LENGTH_K2_E5_SHIFT                                   20
#define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_K2_E5                                                           0x000394UL //Access:RW   DataWidth:0x20   // ECC error correction control. Allows you to disable ECC error correction for RAMs and datapath.  When the AXI Bridge Module is implemented and the master / slave clocks are asynchronous to the PCIe native core clock (core_clk), you must not write this register while operations are in progress in the AXI master / slave interface.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_TX_K2_E5                                   (0x1<<0) // Global error correction disable for all Tx layers. Does not disable the error detection reporting for 1-bit and 2-bit ECC errors.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_TX_K2_E5_SHIFT                             0
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_MASTER_K2_E5                    (0x1<<1) // Error correction disable for AXI bridge master completion buffer.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_MASTER_K2_E5_SHIFT              1
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_OUTBOUND_K2_E5                  (0x1<<2) // Error correction disable for AXI bridge outbound request path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_OUTBOUND_K2_E5_SHIFT            2
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_DMA_WRITE_K2_E5                            (0x1<<3) // Error correction disable for DMA write engine.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_DMA_WRITE_K2_E5_SHIFT                      3
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER2_TX_K2_E5                            (0x1<<4) // Error correction disable for layer 2 Tx path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER2_TX_K2_E5_SHIFT                      4
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER3_TX_K2_E5                            (0x1<<5) // Error correction disable for layer 3 Tx path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER3_TX_K2_E5_SHIFT                      5
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_ADM_TX_K2_E5                               (0x1<<6) // Error correction disable for Adm Tx path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_ADM_TX_K2_E5_SHIFT                         6
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_RX_K2_E5                                   (0x1<<16) // Global error correction disable for all Rx layers.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_RX_K2_E5_SHIFT                             16
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_INBOUND_COMPLETION_K2_E5        (0x1<<17) // Error correction disable for AXI bridge inbound completion composer. Does not disable the error detection reporting for 1-bit and 2-bit ECC errors.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_INBOUND_COMPLETION_K2_E5_SHIFT  17
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_INBOUND_REQUEST_K2_E5           (0x1<<18) // Error correction disable for AXI bridge inbound request path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_AXI_BRIDGE_INBOUND_REQUEST_K2_E5_SHIFT     18
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_DMA_READ_K2_E5                             (0x1<<19) // Error correction disable for DMA read engine.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_DMA_READ_K2_E5_SHIFT                       19
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER2_RX_K2_E5                            (0x1<<20) // Error correction disable for layer 2 Rx path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER2_RX_K2_E5_SHIFT                      20
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER3_RX_K2_E5                            (0x1<<21) // Error correction disable for layer 3 Rx path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_LAYER3_RX_K2_E5_SHIFT                      21
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_ADM_RX_K2_E5                               (0x1<<22) // Error correction disable for ADM Rx path.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_PROT_CTRL_OFF_ERROR_PROT_DISABLE_ADM_RX_K2_E5_SHIFT                         22
#define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_K2_E5                                                         0x000398UL //Access:RW   DataWidth:0x20   // Corrected error (1-bit ECC) counter selection and control. This is a viewport control register. Setting the CORR_COUNTER_SELECTION_REGION and CORR_COUNTER_SELECTION fields in this register determine the counter data returned by the RASDP_CORR_COUNT_REPORT_OFF viewport data register.
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_CLEAR_COUNTERS_K2_E5                                   (0x1<<0) // Clear all correctable error counters.
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_CLEAR_COUNTERS_K2_E5_SHIFT                             0
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_EN_COUNTERS_K2_E5                                      (0x1<<4) // Enable correctable errors counters.  - 1: counters increment when the core detects a correctable error  - 0: counters are frozen The counters are enabled by default.
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_EN_COUNTERS_K2_E5_SHIFT                                4
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_COUNTER_SELECTION_REGION_K2_E5                         (0xf<<20) // Select correctable counter region:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_COUNTER_SELECTION_REGION_K2_E5_SHIFT                   20
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_COUNTER_SELECTION_K2_E5                                (0xff<<24) // Counter selection. This field selects the counter ID (within the region defined by CORR_COUNTER_SELECTION_REGION) whose contents can be read from the RASDP_CORR_COUNT_REPORT_OFF register. You can cycle this field value from 0 to 255 to access all counters according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_CORR_COUNTER_CTRL_OFF_CORR_COUNTER_SELECTION_K2_E5_SHIFT                          24
#define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_K2_E5                                                         0x00039cUL //Access:R    DataWidth:0x20   // Corrected error (1-bit ECC) counter data. This viewport register returns the counter data selected by the CORR_COUNTER_SELECTION_REGION and CORR_COUNTER_SELECTION fields in the RASDP_CORR_COUNTER_CTRL_OFF register.
  #define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_CORR_COUNTER_K2_E5                                          (0xff<<0) // Current corrected error count for the selected counter.
  #define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_CORR_COUNTER_K2_E5_SHIFT                                    0
  #define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_CORR_COUNTER_SELECTED_REGION_K2_E5                          (0xf<<20) // Selected correctable counter region:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_CORR_COUNTER_SELECTED_REGION_K2_E5_SHIFT                    20
  #define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_CORR_COUNTER_SELECTED_K2_E5                                 (0xff<<24) // Counter selection. Returns the value set in the CORR_COUNTER_SELECTION field of the RASDP_CORR_COUNTER_CTRL_OFF register.
  #define PCIEIP_REG_RASDP_CORR_COUNT_REPORT_OFF_CORR_COUNTER_SELECTED_K2_E5_SHIFT                           24
#define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_K2_E5                                                       0x0003a0UL //Access:RW   DataWidth:0x20   // Uncorrected error (2-bit ECC and parity) counter selection and control. This is a viewport control register. Setting the UNCORR_COUNTER_SELECTION_REGION and UNCORR_COUNTER_SELECTION fields in this register determine the counter data returned by the RASDP_UNCORR_COUNT_REPORT_OFF viewport data register.
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_CLEAR_COUNTERS_K2_E5                               (0x1<<0) // Clear uncorrectable errors counters. When asserted causes all counters tracking the uncorrectable errors to be cleared.
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_CLEAR_COUNTERS_K2_E5_SHIFT                         0
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_EN_COUNTERS_K2_E5                                  (0x1<<4) // Enable uncorrectable errors counters.  - 1: enables the counters to increment on detected correctable errors  - 0: counters are frozen The counters are enabled by default.
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_EN_COUNTERS_K2_E5_SHIFT                            4
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_COUNTER_SELECTION_REGION_K2_E5                     (0xf<<20) // Select uncorrectable counter region:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_COUNTER_SELECTION_REGION_K2_E5_SHIFT               20
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_COUNTER_SELECTION_K2_E5                            (0xff<<24) // Counter selection. This field selects the counter ID (within the region defined by UNCORR_COUNTER_SELECTION_REGION) whose contents can be read from the RASDP_UNCORR_COUNT_REPORT_OFF register. You can cycle this field value from 0 to 255 to access all counters according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_UNCORR_COUNTER_CTRL_OFF_UNCORR_COUNTER_SELECTION_K2_E5_SHIFT                      24
#define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_K2_E5                                                       0x0003a4UL //Access:R    DataWidth:0x20   // Uncorrected error (2-bit ECC and parity) counter data. This viewport register returns the counter data selected by the UNCORR_COUNTER_SELECTION_REGION and UNCORR_COUNTER_SELECTION fields in the RASDP_UNCORR_COUNTER_CTRL_OFF register.
  #define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_UNCORR_COUNTER_K2_E5                                      (0xff<<0) // Current uncorrected error count for the selected counter
  #define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_UNCORR_COUNTER_K2_E5_SHIFT                                0
  #define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_UNCORR_COUNTER_SELECTED_REGION_K2_E5                      (0xf<<20) // Selected uncorrectable counter region:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_UNCORR_COUNTER_SELECTED_REGION_K2_E5_SHIFT                20
  #define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_UNCORR_COUNTER_SELECTED_K2_E5                             (0xff<<24) // Counter selection. Returns the value set in the UNCORR_COUNTER_SELECTION field of the RASDP_UNCORR_COUNTER_CTRL_OFF register.
  #define PCIEIP_REG_RASDP_UNCORR_COUNT_REPORT_OFF_UNCORR_COUNTER_SELECTED_K2_E5_SHIFT                       24
#define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_K2_E5                                                            0x0003a8UL //Access:RW   DataWidth:0x20   // Error injection control for the following features:  - 1-bit or 2-bit injection  - Continuous or fixed-number (n) injection modes  - Global enable/disable  - Selectable location where injection occurs
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_EN_K2_E5                                             (0x1<<0) // Error injection global enable. When set enables the error insertion logic.
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_EN_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_TYPE_K2_E5                                           (0x3<<4) // Error injection type:  - 0: none  - 1: 1-bit  - 2: 2-bit
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_TYPE_K2_E5_SHIFT                                     4
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_COUNT_K2_E5                                          (0xff<<8) // Error injection count.  - 0: errors are inserted in every TLP until you clear ERROR_INJ_EN.  - 1: one errors injected
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_COUNT_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_LOC_K2_E5                                            (0xff<<16) // Error injection location. Selects where error injection takes place. You can cycle this field value from 0 to 255 to access all locations according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_ERROR_INJ_CTRL_OFF_ERROR_INJ_LOC_K2_E5_SHIFT                                      16
#define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_K2_E5                                                       0x0003acUL //Access:R    DataWidth:0x20   // Corrected errors locations. For more details, see the RAS Data Protection (DP) section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_REG_FIRST_CORR_ERROR_K2_E5                                (0xf<<4) // Region of the first corrected error:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_REG_FIRST_CORR_ERROR_K2_E5_SHIFT                          4
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_LOC_FIRST_CORR_ERROR_K2_E5                                (0xff<<8) // Location/ID of the first corrected error within the region defined by REG_FIRST_CORR_ERROR.  You can cycle this field value from 0 to 255 to access all counters according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_LOC_FIRST_CORR_ERROR_K2_E5_SHIFT                          8
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_REG_LAST_CORR_ERROR_K2_E5                                 (0xf<<20) // Region of the last corrected error:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_REG_LAST_CORR_ERROR_K2_E5_SHIFT                           20
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_LOC_LAST_CORR_ERROR_K2_E5                                 (0xff<<24) // Location/ID of the last corrected error within the region defined by REG_LAST_CORR_ERROR.  You can cycle this field value from 0 to 255 to access all counters according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_CORR_ERROR_LOCATION_OFF_LOC_LAST_CORR_ERROR_K2_E5_SHIFT                           24
#define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_K2_E5                                                     0x0003b0UL //Access:R    DataWidth:0x20   // Uncorrected errors locations. For more details, see the RAS Data Protection (DP) section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_REG_FIRST_UNCORR_ERROR_K2_E5                            (0xf<<4) // Region of the first uncorrected error:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_REG_FIRST_UNCORR_ERROR_K2_E5_SHIFT                      4
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_LOC_FIRST_UNCORR_ERROR_K2_E5                            (0xff<<8) // Location/ID of the first uncorrected error within the region defined by REG_FIRST_UNCORR_ERROR.  You can cycle this field value from 0 to 255 to access all counters according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_LOC_FIRST_UNCORR_ERROR_K2_E5_SHIFT                      8
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_REG_LAST_UNCORR_ERROR_K2_E5                             (0xf<<20) // Region of the last uncorrected error:  - 0x0: Region select for Adm Rx path  - 0x1: Region select for layer 3 Rx path  - 0x2: Region select for layer 2 Rx path  - 0x3: Region select for DMA inbound path  - 0x4: Region select for AXI bridge inbound request path  - 0x5: Region select for AXI bridge inbound completion composer path  - 0x6: Region select for Adm Tx path  - 0x7: Region select for layer 3 Tx path  - 0x8: Region select for layer 2 Tx path  - 0x9: Region select for DMA outbound path  - 0xa: Region select for AXI bridge outbound request path  - 0xb: Region select for AXI bridge outbound master completion buffer path  - 0xc: Reserved  - 0xf: Reserved
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_REG_LAST_UNCORR_ERROR_K2_E5_SHIFT                       20
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_LOC_LAST_UNCORR_ERROR_K2_E5                             (0xff<<24) // Location/ID of the last uncorrected error within the region defined by REG_LAST_UNCORR_ERROR.  You can cycle this field value from 0 to 255 to access all counters according to the detailed report of check points at http://www.synopsys.com/dw/doc.php/iip/DWC_pcie/latest/doc/RASDP_CheckPoints.pdf
  #define PCIEIP_REG_RASDP_UNCORR_ERROR_LOCATION_OFF_LOC_LAST_UNCORR_ERROR_K2_E5_SHIFT                       24
#define PCIEIP_REG_RASDP_ERROR_MODE_EN_OFF_K2_E5                                                             0x0003b4UL //Access:RW   DataWidth:0x20   // RASDP error mode enable. The core enters RASDP error mode (if ERROR_MODE_EN =1) upon detection of the first uncorrectable error. During this mode:  - Rx TLPs that are forwarded to your application are not guaranteed to be correct; you must discard them. For more details, see the RAS Data Protection (DP) section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_RASDP_ERROR_MODE_EN_OFF_ERROR_MODE_EN_K2_E5                                             (0x1<<0) // Write '1' to enable the core enter RASDP error mode when it detects an uncorrectable error.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_MODE_EN_OFF_ERROR_MODE_EN_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_RASDP_ERROR_MODE_EN_OFF_AUTO_LINK_DOWN_EN_K2_E5                                         (0x1<<1) // Write '1' to enable the core to bring the link down when the core enters RASDP error mode.  Note: This register field is sticky.
  #define PCIEIP_REG_RASDP_ERROR_MODE_EN_OFF_AUTO_LINK_DOWN_EN_K2_E5_SHIFT                                   1
#define PCIEIP_REG_RASDP_ERROR_MODE_CLEAR_OFF_K2_E5                                                          0x0003b8UL //Access:RW   DataWidth:0x20   // Exit RASDP error mode. For more details, see the RAS Data Protection (DP) section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_RASDP_ERROR_MODE_CLEAR_OFF_ERROR_MODE_CLEAR_K2_E5                                       (0x1<<0) // Write '1' to take the core out of RASDP error mode. The core will then report uncorrectable errors (through AER internal error reporting) and also stop nullifying/discarding TLPs.
  #define PCIEIP_REG_RASDP_ERROR_MODE_CLEAR_OFF_ERROR_MODE_CLEAR_K2_E5_SHIFT                                 0
#define PCIEIP_REG_RASDP_RAM_ADDR_CORR_ERROR_OFF_K2_E5                                                       0x0003bcUL //Access:R    DataWidth:0x20   // RAM Address where a corrected error (1-bit ECC) has been detected. For more details, see the RAS Data Protection (DP) section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_RASDP_RAM_ADDR_CORR_ERROR_OFF_RAM_ADDR_CORR_ERROR_K2_E5                                 (0x7ffffff<<0) // RAM Address where a corrected error (1-bit ECC) has been detected.
  #define PCIEIP_REG_RASDP_RAM_ADDR_CORR_ERROR_OFF_RAM_ADDR_CORR_ERROR_K2_E5_SHIFT                           0
  #define PCIEIP_REG_RASDP_RAM_ADDR_CORR_ERROR_OFF_RAM_INDEX_CORR_ERROR_K2_E5                                (0xf<<28) // RAM index where a corrected error (1-bit ECC) has been detected.
  #define PCIEIP_REG_RASDP_RAM_ADDR_CORR_ERROR_OFF_RAM_INDEX_CORR_ERROR_K2_E5_SHIFT                          28
#define PCIEIP_REG_RASDP_RAM_ADDR_UNCORR_ERROR_OFF_K2_E5                                                     0x0003c0UL //Access:R    DataWidth:0x20   // RAM Address where an uncorrected error (2-bit ECC) has been detected. For more details, see the RAS Data Protection (DP) section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_RASDP_RAM_ADDR_UNCORR_ERROR_OFF_RAM_ADDR_UNCORR_ERROR_K2_E5                             (0x7ffffff<<0) // RAM Address where an uncorrected error (2-bit ECC) has been detected.
  #define PCIEIP_REG_RASDP_RAM_ADDR_UNCORR_ERROR_OFF_RAM_ADDR_UNCORR_ERROR_K2_E5_SHIFT                       0
  #define PCIEIP_REG_RASDP_RAM_ADDR_UNCORR_ERROR_OFF_RAM_INDEX_UNCORR_ERROR_K2_E5                            (0xf<<28) // RAM index where an uncorrected error (2-bit ECC) has been detected.
  #define PCIEIP_REG_RASDP_RAM_ADDR_UNCORR_ERROR_OFF_RAM_INDEX_UNCORR_ERROR_K2_E5_SHIFT                      28
#define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_K2_E5                                                                 0x0003c4UL //Access:RW   DataWidth:0x20   // Precision Time Measurement Capability Header. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.
  #define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_PTM_CAP_ID_K2_E5                                                    (0xffff<<0) // Precision Time Measurement PCI Express Extended Capability ID. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_PTM_CAP_ID_K2_E5_SHIFT                                              0
  #define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_PTM_CAP_VERSION_K2_E5                                               (0xf<<16) // Precision Time Measurement PCI Express Extended Capability Version. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_PTM_CAP_VERSION_K2_E5_SHIFT                                         16
  #define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_PTM_NEXT_OFFSET_K2_E5                                               (0xfff<<20) // Precision Time Measurement PCI Express Extended Capability Next Offset. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_EXT_CAP_HDR_OFF_PTM_NEXT_OFFSET_K2_E5_SHIFT                                         20
#define PCIEIP_REG_PTM_CAP_OFF_K2_E5                                                                         0x0003c8UL //Access:RW   DataWidth:0x20   // PTM Capability Register. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_REQ_CAPABLE_K2_E5                                                       (0x1<<0) // PTM Requester Capable. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_REQ_CAPABLE_K2_E5_SHIFT                                                 0
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_RES_CAPABLE_K2_E5                                                       (0x1<<1) // PTM Responder Capable. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_RES_CAPABLE_K2_E5_SHIFT                                                 1
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_ROOT_CAPABLE_K2_E5                                                      (0x1<<2) // PTM Root Capable. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_ROOT_CAPABLE_K2_E5_SHIFT                                                2
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_CLK_GRAN_K2_E5                                                          (0xff<<8) // PTM Local Clock Granularity. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)
  #define PCIEIP_REG_PTM_CAP_OFF_PTM_CLK_GRAN_K2_E5_SHIFT                                                    8
#define PCIEIP_REG_PTM_CONTROL_OFF_K2_E5                                                                     0x0003ccUL //Access:RW   DataWidth:0x20   // PTM Control Register. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.
  #define PCIEIP_REG_PTM_CONTROL_OFF_PTM_ENABLE_K2_E5                                                        (0x1<<0) // PTM Enable. When set, this function is permitted to participate in the PTM mechanism. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.
  #define PCIEIP_REG_PTM_CONTROL_OFF_PTM_ENABLE_K2_E5_SHIFT                                                  0
  #define PCIEIP_REG_PTM_CONTROL_OFF_ROOT_SELECT_K2_E5                                                       (0x1<<1) // PTM Root Select. When set this Time Source is the PTM Root. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: HWINIT
  #define PCIEIP_REG_PTM_CONTROL_OFF_ROOT_SELECT_K2_E5_SHIFT                                                 1
  #define PCIEIP_REG_PTM_CONTROL_OFF_EFF_GRAN_K2_E5                                                          (0xff<<8) // PTM Effective Granularity. For a description of this standard PCIe register, see the PCI Express Base Specification 3.0.  Note: The access attributes of this field are as follows:  - Dbi: HWINIT
  #define PCIEIP_REG_PTM_CONTROL_OFF_EFF_GRAN_K2_E5_SHIFT                                                    8
#define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_K2_E5                                                                 0x0003d0UL //Access:RW   DataWidth:0x20   // Precision Time Measurement Requester Capability Header (VSEC). For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_PTM_REQ_EXT_CAP_ID_K2_E5                                            (0xffff<<0) // Precision Time Measurement Requester VSEC ID. For more details, see the PTM section in the Databook.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_PTM_REQ_EXT_CAP_ID_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_PTM_REQ_EXT_CAP_VER_K2_E5                                           (0xf<<16) // Precision Time Measurement Requester VSEC Version. For more details, see the PTM section in the Databook.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_PTM_REQ_EXT_CAP_VER_K2_E5_SHIFT                                     16
  #define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_PTM_REQ_EXT_CAP_NEXT_OFFS_K2_E5                                     (0xfff<<20) // Precision Time Measurement Requester VSEC Next Pointer. For more details, see the PTM section in the Databook.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_CAP_HDR_OFF_PTM_REQ_EXT_CAP_NEXT_OFFS_K2_E5_SHIFT                               20
#define PCIEIP_REG_PTM_REQ_HDR_OFF_K2_E5                                                                     0x0003d4UL //Access:RW   DataWidth:0x20   // Precision Time Measurement Requester Vendor Specific Header. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_HDR_OFF_PTM_REQ_VSEC_ID_K2_E5                                                   (0xffff<<0) // PTM Requester VSEC ID. For more details, see the PTM section in the Databook.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_HDR_OFF_PTM_REQ_VSEC_ID_K2_E5_SHIFT                                             0
  #define PCIEIP_REG_PTM_REQ_HDR_OFF_PTM_REQ_VSEC_REV_K2_E5                                                  (0xf<<16) // PTM Requester VSEC Revision. For more details, see the PTM section in the Databook.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_HDR_OFF_PTM_REQ_VSEC_REV_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_PTM_REQ_HDR_OFF_PTM_REQ_VSEC_LENGTH_K2_E5                                               (0xfff<<20) // PTM Requester VSEC Length. For more details, see the PTM section in the Databook.  Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_HDR_OFF_PTM_REQ_VSEC_LENGTH_K2_E5_SHIFT                                         20
#define PCIEIP_REG_PTM_REQ_CONTROL_OFF_K2_E5                                                                 0x0003d8UL //Access:RW   DataWidth:0x20   // PTM Requester Vendor Specific Control Register. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_AUTO_UPDATE_ENABLED_K2_E5                                   (0x1<<0) // PTM Requester Auto Update Enabled - When enabled PTM Requester will automatically atempt to update it's context every 10ms. For more details, see the PTM section in the Databook.  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_AUTO_UPDATE_ENABLED_K2_E5_SHIFT                             0
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_START_UPDATE_K2_E5                                          (0x1<<1) // PTM Requester Start Update - When set the PTM Requester will attempt a PTM Dialogue to update it's context; This bit is self clearing. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_START_UPDATE_K2_E5_SHIFT                                    1
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_FAST_TIMERS_K2_E5                                           (0x1<<2) // PTM Fast Timers - Debug mode for PTM Timers. The 100us timer output will go high at 30us and the 10ms timer output will go high at 100us (The Long Timer Value is ignored). There is no change to the 1us timer. The requester operation will otherwise remain the same. For more details, see the PTM section in the Databook.  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_FAST_TIMERS_K2_E5_SHIFT                                     2
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_LONG_TIMER_K2_E5                                            (0xff<<8) // PTM Requester Long Timer - Determines the period between each auto update PTM Dialogue in miliseconds. Update period is the register value +1 milisecond. For the Switch product this value must not be set larger than 0x9 for spec compliance. For more details, see the PTM section in the Databook.  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_CONTROL_OFF_PTM_REQ_LONG_TIMER_K2_E5_SHIFT                                      8
#define PCIEIP_REG_PTM_REQ_STATUS_OFF_K2_E5                                                                  0x0003dcUL //Access:R    DataWidth:0x20   // PTM Requester Vendor Specific Status Register. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_STATUS_OFF_PTM_REQ_CONTEXT_VALID_K2_E5                                          (0x1<<0) // PTM Requester Context Valid - Indicate that the Timing Context is valid. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_STATUS_OFF_PTM_REQ_CONTEXT_VALID_K2_E5_SHIFT                                    0
  #define PCIEIP_REG_PTM_REQ_STATUS_OFF_PTM_REQ_MANUAL_UPDATE_ALLOWED_K2_E5                                  (0x1<<1) // PTM Requester Manual Update Allowed - Indicates whether or not a Manual Update can be signalled. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_STATUS_OFF_PTM_REQ_MANUAL_UPDATE_ALLOWED_K2_E5_SHIFT                            1
#define PCIEIP_REG_PTM_REQ_LOCAL_LSB_OFF_K2_E5                                                               0x0003e0UL //Access:RW   DataWidth:0x20   // PTM Requester Local Clock LSB  For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_LOCAL_MSB_OFF_K2_E5                                                               0x0003e4UL //Access:RW   DataWidth:0x20   // PTM Requester Local Clock MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T1_LSB_OFF_K2_E5                                                                  0x0003e8UL //Access:R    DataWidth:0x20   // PTM Requester T1 Timestamp LSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T1_MSB_OFF_K2_E5                                                                  0x0003ecUL //Access:R    DataWidth:0x20   // PTM Requester T1 Timestamp MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T1P_LSB_OFF_K2_E5                                                                 0x0003f0UL //Access:R    DataWidth:0x20   // PTM Requester T1 Previous Timestamp LSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T1P_MSB_OFF_K2_E5                                                                 0x0003f4UL //Access:R    DataWidth:0x20   // PTM Requester T1 Previous Timestamp MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T4_LSB_OFF_K2_E5                                                                  0x0003f8UL //Access:R    DataWidth:0x20   // PTM Requester T4 Timestamp LSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T4_MSB_OFF_K2_E5                                                                  0x0003fcUL //Access:R    DataWidth:0x20   // PTM Requester T4 Timestamp MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T4P_LSB_OFF_K2_E5                                                                 0x000400UL //Access:R    DataWidth:0x20   // PTM Requester T4 Previous Timestamp LSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_T4P_MSB_OFF_K2_E5                                                                 0x000404UL //Access:R    DataWidth:0x20   // PTM Requester T4 Previous Timestamp MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PTM_REQ_MASTER_LSB_OFF_K2_E5                                                              0x000408UL //Access:R    DataWidth:0x20   // PTM Requester Master Time LSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_CONFIG_2_BB                                                                               0x000408UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_CONFIG_2_BAR1_SIZE_BB                                                                   (0xf<<0) // These bits control the size of the BAR1 area advertised in the bar_1 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. Default is 64K
  #define PCIEIP_REG_CONFIG_2_BAR1_SIZE_BB_SHIFT                                                             0
  #define PCIEIP_REG_CONFIG_2_BAR1_64ENA_BB                                                                  (0x1<<4) // This bit enables the advertisement of bar_1 as a 32-bit address. The value of this bit maps directly to bit 2 of bar_1. This value is sticky and only reset by HARD Reset. If set it is 64bit addressing.
  #define PCIEIP_REG_CONFIG_2_BAR1_64ENA_BB_SHIFT                                                            4
  #define PCIEIP_REG_CONFIG_2_EXP_ROM_RETRY_BB                                                               (0x1<<5) // This bit will force the PCI bus to re-try all cycles to the current Expansion ROM BAR area. When this bit is set, then no Expansion ROM interrupt will be generated. This bit must be cleared to allow the interrupt to be generated.
  #define PCIEIP_REG_CONFIG_2_EXP_ROM_RETRY_BB_SHIFT                                                         5
  #define PCIEIP_REG_CONFIG_2_CFG_CYCLE_RETRY_BB                                                             (0x1<<6) // This bit will force the PCI bus to re-try all cycles to the configuration space until it is cleared. This is used to block the host from accessing context if needed to prevent reading of false data. This bit may be used in combination with the FIRST_CFG_DONE bit below to prevent changing of the configuration space values after they have be read by the system. Normally this bit will be set by the firmware while the configuration space is programmed. This bit also exists in each VF and can be used to control individual VF.
  #define PCIEIP_REG_CONFIG_2_CFG_CYCLE_RETRY_BB_SHIFT                                                       6
  #define PCIEIP_REG_CONFIG_2_FIRST_CFG_DONE_BB                                                              (0x1<<7) // This bit will be set the first time since PCI reset that a configuration cycle hass been done by the PCI block. This may be used by firmware to detect if the host already has the reset values of the configuration space. this may happen if the NVM system is much slower than expected. Tn this case, the firmware can choose to not exist or show an error on LEDs, etc. instead of changing the configuratio space values that the host ahas already read.
  #define PCIEIP_REG_CONFIG_2_FIRST_CFG_DONE_BB_SHIFT                                                        7
  #define PCIEIP_REG_CONFIG_2_ROM_BAR_SIZE_BB                                                                (0xff<<8) // These bits control the size of the Expansion ROM area advertised in the Exp_ROM_BAR register of the PCI configuration space. When this value is non-zero, the Expansion ROM attention must be handled by an internal processor to move data between the Serial Non-Volatile Memory and the Expansion ROM interface. When the value is zero, the expansion ROM BAR will not advertize the presence of an expansion ROM.
  #define PCIEIP_REG_CONFIG_2_ROM_BAR_SIZE_BB_SHIFT                                                          8
  #define PCIEIP_REG_CONFIG_2_BAR_PREFETCH_BB                                                                (0x1<<16) // This bit when set is reflected in bit 3 of bar_1 and indicates that the BAR is pre-fetchable
  #define PCIEIP_REG_CONFIG_2_BAR_PREFETCH_BB_SHIFT                                                          16
  #define PCIEIP_REG_CONFIG_2_RESERVED0_BB                                                                   (0x7fff<<17) // 
  #define PCIEIP_REG_CONFIG_2_RESERVED0_BB_SHIFT                                                             17
#define PCIEIP_REG_PTM_REQ_MASTER_MSB_OFF_K2_E5                                                              0x00040cUL //Access:R    DataWidth:0x20   // PTM Requester Master Time MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_CONFIG_3_BB                                                                               0x00040cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_CONFIG_3_STICKY_BYTE_BB                                                                 (0xff<<0) // This value is reset only reset by HARD Reset such that it can be used to detect initial power up if a non-zero value is written by the firmware after initialization. It has not hardware function other than reset type detection. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_CONFIG_3_STICKY_BYTE_BB_SHIFT                                                           0
  #define PCIEIP_REG_CONFIG_3_REG_STICKY_BYTE_BB                                                             (0xff<<8) // This value is reset only by REG_HARD_RST.
  #define PCIEIP_REG_CONFIG_3_REG_STICKY_BYTE_BB_SHIFT                                                       8
  #define PCIEIP_REG_CONFIG_3_VF_MEM_DSICARD_BB                                                              (0x1<<16) // This bits exists in VF only Setting this bit to '1' forces the VF to drop any mem request that it receives. UR completion will be returned for mem read requests. This bit along with the CRS bit can be used by software to control when VF is up.
  #define PCIEIP_REG_CONFIG_3_VF_MEM_DSICARD_BB_SHIFT                                                        16
  #define PCIEIP_REG_CONFIG_3_UNUSED0_BB                                                                     (0x7f<<17) // 
  #define PCIEIP_REG_CONFIG_3_UNUSED0_BB_SHIFT                                                               17
  #define PCIEIP_REG_CONFIG_3_FORCE_PME_BB                                                                   (0x1<<24) // Setting this bit to '1' forces the PME message to be send This simulates the PME event. The PME control bits in the configuration space still control the output normally. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_CONFIG_3_FORCE_PME_BB_SHIFT                                                             24
  #define PCIEIP_REG_CONFIG_3_PME_STATUS_BB                                                                  (0x1<<25) // This bit indicates the current state of the PME_STATUS bit in configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_CONFIG_3_PME_STATUS_BB_SHIFT                                                            25
  #define PCIEIP_REG_CONFIG_3_PME_ENABLE_BB                                                                  (0x1<<26) // This is the current state of the PME_ENABLE bit in configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_CONFIG_3_PME_ENABLE_BB_SHIFT                                                            26
  #define PCIEIP_REG_CONFIG_3_PM_STATE_BB                                                                    (0x3<<27) // This value interfaces to the PM_STATE value in the Power Management configuration space. Reads of this register return the last value written to the PM_STATE value in configuration space.
  #define PCIEIP_REG_CONFIG_3_PM_STATE_BB_SHIFT                                                              27
  #define PCIEIP_REG_CONFIG_3_UNUSED1_BB                                                                     (0x1<<29) // 
  #define PCIEIP_REG_CONFIG_3_UNUSED1_BB_SHIFT                                                               29
  #define PCIEIP_REG_CONFIG_3_VAUX_PRESENT_BB                                                                (0x1<<30) // This bit indicates the input level on the VAUX_PRESENT pin. This indicates if the VAUX supply is available in the current configuration. The value also controls the value of the Power Management PME_SUPPORT register in configuration space. Field is local in each PF
  #define PCIEIP_REG_CONFIG_3_VAUX_PRESENT_BB_SHIFT                                                          30
  #define PCIEIP_REG_CONFIG_3_PCI_POWER_BB                                                                   (0x1<<31) // PCI_POWER This bit indicates the current state of power on the PCI bus. If this bit is '1', it indicates that the PCI padring has power. If this bit is '0', it indicates that the PCI padring does not have power (D3 Cold).
  #define PCIEIP_REG_CONFIG_3_PCI_POWER_BB_SHIFT                                                             31
#define PCIEIP_REG_PTM_REQ_PROP_DELAY_OFF_K2_E5                                                              0x000410UL //Access:R    DataWidth:0x20   // PTM Requester Propagation Delay. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PM_DATA_A_BB                                                                              0x000410UL //Access:RW   DataWidth:0x20   // This register controls the first 4 power management PM_Data read values
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_0_PRG_BB                                                              (0xff<<0) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 0. This is the power consumed in D0 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_0_PRG_BB_SHIFT                                                        0
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_1_PRG_BB                                                              (0xff<<8) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 1. This is the power consumed in D1 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_1_PRG_BB_SHIFT                                                        8
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_2_PRG_BB                                                              (0xff<<16) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 2. This is the power consumed in D2 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_2_PRG_BB_SHIFT                                                        16
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_3_PRG_BB                                                              (0xff<<24) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 3. This is the power consumed in D3 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_A_PM_DATA_3_PRG_BB_SHIFT                                                        24
#define PCIEIP_REG_PTM_REQ_MASTERT1_LSB_OFF_K2_E5                                                            0x000414UL //Access:R    DataWidth:0x20   // PTM Requester Master Time at T1 LSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PM_DATA_B_BB                                                                              0x000414UL //Access:RW   DataWidth:0x20   // This register controls the second 4 power management PM_Data read values
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_4_PRG_BB                                                              (0xff<<0) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 4. This is the power dissipated in D0 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_4_PRG_BB_SHIFT                                                        0
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_5_PRG_BB                                                              (0xff<<8) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 5. This is the power dissipated in D1 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_5_PRG_BB_SHIFT                                                        8
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_6_PRG_BB                                                              (0xff<<16) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 6. This is the power dissipated in D2 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_6_PRG_BB_SHIFT                                                        16
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_7_PRG_BB                                                              (0xff<<24) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 7. This is the power dissipated in D3 state. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_PM_DATA_B_PM_DATA_7_PRG_BB_SHIFT                                                        24
#define PCIEIP_REG_PTM_REQ_MASTERT1_MSB_OFF_K2_E5                                                            0x000418UL //Access:R    DataWidth:0x20   // PTM Requester Master Time at T1 MSB. For more details, see the PTM section in the Databook.
#define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BB                                                                   0x000418UL //Access:RW   DataWidth:0x20   // This register controls the higher bar size advertizements, when a bar size greater than 1G is desired.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR1_SIZE_HIEXT_BB                                                 (0xf<<0) // These bits control the size of the BAR1 area advertised in the bar_1 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. These bits are programmed when a BAR size greater than 1GB is desired. When requiring a BAR size greater than 1 GB, the corresponding bar1_size bits should be programmed to 0xF.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR1_SIZE_HIEXT_BB_SHIFT                                           0
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR2_SIZE_HIEXT_BB                                                 (0xf<<4) // These bits control the size of the BAR2 area advertised in the bar_3 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. These bits are programmed when a BAR size greater than 1GB is desired. When requiring a BAR size greater than 1 GB, the corresponding bar2_size bits should be programmed to 0xF.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR2_SIZE_HIEXT_BB_SHIFT                                           4
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR3_SIZE_HIEXT_BB                                                 (0xf<<8) // These bits control the size of the BAR3 area advertised in the bar_5 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. These bits are programmed when a BAR size greater than 1GB is desired. When requiring a BAR size greater than 1 GB, the corresponding bar3_size bits should be programmed to 0xF.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR3_SIZE_HIEXT_BB_SHIFT                                           8
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR1_SIZE_LOEXT_BB                                                 (0x7<<12) // These bits control the size of the BAR1 area advertised in the bar_1 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. These bits are programmed when a BAR size lower than 64K is desired. When requiring a BAR size smaller than 64K , the corresponding bar_size bits should be programmed to 0x0, as also the bar1_size_hiext bits. If desiring a bar size greater than 32K, then the bar1_size_loext bits need to be 0.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR1_SIZE_LOEXT_BB_SHIFT                                           12
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_UNUSED0_BB                                                         (0x1<<15) // 
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_UNUSED0_BB_SHIFT                                                   15
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR2_SIZE_LOEXT_BB                                                 (0x7<<16) // These bits control the size of the BAR2 area advertised in the bar_3 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. These bits are programmed when a BAR size lower than 64K is desired. When requiring a BAR size smaller than 64K , the corresponding bar2_size bits should be programmed to 0x0, as also the bar1_size_hiext bits. If desiring a bar size greater than 32K, then the bar1_size_loext bits need to be 0.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR2_SIZE_LOEXT_BB_SHIFT                                           16
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR3_SIZE_LOEXT_BB                                                 (0x7<<19) // These bits control the size of the BAR3 area advertised in the bar_5 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. These bits are programmed when a BAR size lower than 64K is desired. When requiring a BAR size smaller than 64K , the corresponding bar3_size bits should be programmed to 0x0, as also the bar1_size_hiext bits. If desiring a bar size greater than 32K, then the bar1_size_loext bits need to be 0.
  #define PCIEIP_REG_PCI_EXTENDED_BAR_SIZ_BAR3_SIZE_LOEXT_BB_SHIFT                                           19
#define PCIEIP_REG_PTM_REQ_TX_LATENCY_OFF_K2_E5                                                              0x00041cUL //Access:RW   DataWidth:0x20   // PTM Requester TX Latency. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_TX_LATENCY_OFF_PTM_REQ_TX_LATENCY_K2_E5                                         (0xfff<<0) // PTM Requester TX Latency - Requester Transmit path latency (12 bit wide). For more details, see the PTM section in the Databook.  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_TX_LATENCY_OFF_PTM_REQ_TX_LATENCY_K2_E5_SHIFT                                   0
#define PCIEIP_REG_PTM_REQ_RX_LATENCY_OFF_K2_E5                                                              0x000420UL //Access:RW   DataWidth:0x20   // PTM Requester RX Latency. For more details, see the PTM section in the Databook.
  #define PCIEIP_REG_PTM_REQ_RX_LATENCY_OFF_PTM_REQ_RX_LATENCY_K2_E5                                         (0xfff<<0) // PTM Requester RX Latency - Requester Receive path latency (12 bit wide). For more details, see the PTM section in the Databook.  Note: This register field is sticky.
  #define PCIEIP_REG_PTM_REQ_RX_LATENCY_OFF_PTM_REQ_RX_LATENCY_K2_E5_SHIFT                                   0
#define PCIEIP_REG_RESBAR_CAP_HDR_REG_K2_E5                                                                  0x000424UL //Access:RW   DataWidth:0x20   // Resizable BAR Capability Header.
  #define PCIEIP_REG_RESBAR_CAP_HDR_REG_RESBAR_EXT_CAP_ID_K2_E5                                              (0xffff<<0) // Resizable BAR Extended Capability ID.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_HDR_REG_RESBAR_EXT_CAP_ID_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_RESBAR_CAP_HDR_REG_RESBAR_CAP_VERSION_K2_E5                                             (0xf<<16) // Capability Version.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_HDR_REG_RESBAR_CAP_VERSION_K2_E5_SHIFT                                       16
  #define PCIEIP_REG_RESBAR_CAP_HDR_REG_RESBAR_CAP_NEXT_OFFSET_K2_E5                                         (0xfff<<20) // Next Capability Offset.   Note: The access attributes of this field are as follows:  - Dbi: if (DBI_RO_WR_EN == 1) then R/W(sticky) else R(sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_HDR_REG_RESBAR_CAP_NEXT_OFFSET_K2_E5_SHIFT                                   20
#define PCIEIP_REG_RESBAR_CAP_REG_0_REG_K2_E5                                                                0x000428UL //Access:RW   DataWidth:0x20   // Resizable BAR0 Capability Register.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_1MB_K2_E5                                         (0x1<<4) // Up to 1MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_1MB_K2_E5_SHIFT                                   4
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_2MB_K2_E5                                         (0x1<<5) // Up to 2MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_2MB_K2_E5_SHIFT                                   5
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_4MB_K2_E5                                         (0x1<<6) // Up to 4MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_4MB_K2_E5_SHIFT                                   6
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_8MB_K2_E5                                         (0x1<<7) // Up to 8MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_8MB_K2_E5_SHIFT                                   7
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_16MB_K2_E5                                        (0x1<<8) // Up to 16MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_16MB_K2_E5_SHIFT                                  8
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_32MB_K2_E5                                        (0x1<<9) // Up to 32MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_32MB_K2_E5_SHIFT                                  9
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_64MB_K2_E5                                        (0x1<<10) // Up to 64MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_64MB_K2_E5_SHIFT                                  10
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_128MB_K2_E5                                       (0x1<<11) // Up to 128MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_128MB_K2_E5_SHIFT                                 11
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_256MB_K2_E5                                       (0x1<<12) // Up to 256MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_256MB_K2_E5_SHIFT                                 12
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_512MB_K2_E5                                       (0x1<<13) // Up to 512MB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_512MB_K2_E5_SHIFT                                 13
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_1GB_K2_E5                                         (0x1<<14) // Up to 1GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_1GB_K2_E5_SHIFT                                   14
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_2GB_K2_E5                                         (0x1<<15) // Up to 2GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_2GB_K2_E5_SHIFT                                   15
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_4GB_K2_E5                                         (0x1<<16) // Up to 4GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_4GB_K2_E5_SHIFT                                   16
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_8GB_K2_E5                                         (0x1<<17) // Up to 8GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_8GB_K2_E5_SHIFT                                   17
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_16GB_K2_E5                                        (0x1<<18) // Up to 16GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_16GB_K2_E5_SHIFT                                  18
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_32GB_K2_E5                                        (0x1<<19) // Up to 32GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_32GB_K2_E5_SHIFT                                  19
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_64GB_K2_E5                                        (0x1<<20) // Up to 64GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_64GB_K2_E5_SHIFT                                  20
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_128GB_K2_E5                                       (0x1<<21) // Up to 128GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_128GB_K2_E5_SHIFT                                 21
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_256GB_K2_E5                                       (0x1<<22) // Up to 256GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_256GB_K2_E5_SHIFT                                 22
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_512GB_K2_E5                                       (0x1<<23) // Up to 512GB BAR Supported.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CAP_REG_0_REG_RESBAR_CAP_REG_0_512GB_K2_E5_SHIFT                                 23
#define PCIEIP_REG_REG_VPD_INTF_BB                                                                           0x000428UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VPD_INTF_INTF_REQ_BB                                                                (0x1<<0) // This bit will be set if there is a pending request for action by the firmware to handle a Vital Product Data interface. This bit is set when the vpd_flag_addr register in configuation space is written. This bit is cleared when the vpd_data register below is written.
  #define PCIEIP_REG_REG_VPD_INTF_INTF_REQ_BB_SHIFT                                                          0
#define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_K2_E5                                                               0x00042cUL //Access:RW   DataWidth:0x20   // Resizable BAR0 Control Register.
  #define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_RESBAR_CTRL_REG_IDX_0_K2_E5                                       (0x7<<0) // BAR Index.   Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_RESBAR_CTRL_REG_IDX_0_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_RESBAR_CTRL_REG_NUM_BARS_K2_E5                                    (0x7<<5) // Number of Resizeable BARs.   Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_RESBAR_CTRL_REG_NUM_BARS_K2_E5_SHIFT                              5
  #define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_RESBAR_CTRL_REG_BAR_SIZE_K2_E5                                    (0x1f<<8) // BAR Size.   Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_RESBAR_CTRL_REG_0_REG_RESBAR_CTRL_REG_BAR_SIZE_K2_E5_SHIFT                              8
#define PCIEIP_REG_REG_VPD_ADDR_FLAG_BB                                                                      0x00042cUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VPD_ADDR_FLAG_UNUSED0_BB                                                            (0x3ffff<<0) // 
  #define PCIEIP_REG_REG_VPD_ADDR_FLAG_UNUSED0_BB_SHIFT                                                      0
  #define PCIEIP_REG_REG_VPD_ADDR_FLAG_ADDRESS_BB                                                            (0x1fff<<18) // This value is the byte address of the VPD value being requested by the host in the vpd_flag_addr register of the configuration space.
  #define PCIEIP_REG_REG_VPD_ADDR_FLAG_ADDRESS_BB_SHIFT                                                      18
  #define PCIEIP_REG_REG_VPD_ADDR_FLAG_WR_BB                                                                 (0x1<<31) // This bit indicates if the host is requesting a read or a write cycle. If this bit is set, then the host has requested the data in the vpd_data register to be passed to the NVM interface. If the value is clear, then the host has requested the data to be passed from the NVM interface to the vpd_data register. The value of this bit is only valid if the INTF_REQ bit is set. This bit is a RO copy of the flag bit in the vpd_flag_addr register in configuration space.
  #define PCIEIP_REG_REG_VPD_ADDR_FLAG_WR_BB_SHIFT                                                           31
#define PCIEIP_REG_REG_VPD_DATA_BB                                                                           0x000430UL //Access:RW   DataWidth:0x20   // This is the data register for passing values between the NVM interface and the vpd_data register in the configuration space. When INTF_REQ is '1' and the WR bit is clear, this word should be written with the NVM data requested in the ADDRESS value to clear the INTF_REQ bit. When INTF_REQ is '1' and the WR bit is set, this word should be read and written to the NVM interface. After the NVM interface write is complete, this value should be written with the same value to clear the INTF_REQ bit. When this value is written and the INTF_REQ bit is set, the FLAG bit in the vpd_flag_addr register in configurationspace will be complemented.
#define PCIEIP_REG_REG_ID_VAL1_BB                                                                            0x000434UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ID_VAL1_DEVICE_ID_BB                                                                (0xffff<<0) // This register programs the read value of the device_id register of the configuration space. The hardware default value is the Broadcom vendor ID. This value is sticky and only reset by HARD Reset. The default value reflects the value of DEVICE_ID in version.v defined by user or the strap pins user_device_id if user relies on straps.
  #define PCIEIP_REG_REG_ID_VAL1_DEVICE_ID_BB_SHIFT                                                          0
  #define PCIEIP_REG_REG_ID_VAL1_VENDOR_ID_BB                                                                (0xffff<<16) // This register programs the read value of the vendor_id register of the configuration space. The hardware default value is the Broadcom vendor ID. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL1_VENDOR_ID_BB_SHIFT                                                          16
#define PCIEIP_REG_REG_ID_VAL2_BB                                                                            0x000438UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ID_VAL2_SUBSYSTEM_VENDOR_ID_BB                                                      (0xffff<<0) // This value controls the read value of the subsystem_vendor_id value in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL2_SUBSYSTEM_VENDOR_ID_BB_SHIFT                                                0
  #define PCIEIP_REG_REG_ID_VAL2_SUBSYSTEM_ID_BB                                                             (0xffff<<16) // This value controls the read value of the subsystem_id value in the configuration space. This value is sticky and only reset by HARD Reset. The default value reflects the value of DEVICE_ID in version.v defined by user or the strap pins user_device_id if user relies on straps.
  #define PCIEIP_REG_REG_ID_VAL2_SUBSYSTEM_ID_BB_SHIFT                                                       16
#define PCIEIP_REG_REG_ID_VAL3_BB                                                                            0x00043cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ID_VAL3_CLASS_CODE_BB                                                               (0xffffff<<0) // This register programs the read value of the class_code register of the configuration space. The 24-bit Class Code register identifies the generic function of the device. All of the legal values are specific in the PCI specification. The default value for this register is the class code for an Ethernet interface (0x020000). This value is sticky and only reset by HARD Reset. The default value reflects the value of CLASS_CODE in version.v defined by user.
  #define PCIEIP_REG_REG_ID_VAL3_CLASS_CODE_BB_SHIFT                                                         0
  #define PCIEIP_REG_REG_ID_VAL3_REVISION_ID_BB                                                              (0xff<<24) // This register programs the read value of the revision_id register of the configuration space. The default value is provided by user_revision_id strap pins. This field also exists in VF register space
  #define PCIEIP_REG_REG_ID_VAL3_REVISION_ID_BB_SHIFT                                                        24
#define PCIEIP_REG_REG_ID_VAL4_BB                                                                            0x000440UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ID_VAL4_CAP_ENA_BB                                                                  (0xf<<0) // This value controls the read value of the next capability pointers in the PCIE configuration space and allows each extra capability to be independently disabled by manipulation of the next pointer values. The read values for each enable combination is shown below. PCIE capability is always enabled. Bit 0 enables the Power Management capability. Bit 1 enables the VPD capability, and Bit 2 enables the MSI capability and Bit3 is MSIX capability This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL4_CAP_ENA_BB_SHIFT                                                            0
  #define PCIEIP_REG_REG_ID_VAL4_UNUSED0_BB                                                                  (0x3<<4) // 
  #define PCIEIP_REG_REG_ID_VAL4_UNUSED0_BB_SHIFT                                                            4
  #define PCIEIP_REG_REG_ID_VAL4_PM_DATA_SCALE_BB                                                            (0x3<<6) // This value is read as the DATA_SCALE value in the Power Management CSR register in the PCI Configuration address space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL4_PM_DATA_SCALE_BB_SHIFT                                                      6
  #define PCIEIP_REG_REG_ID_VAL4_MSI_PV_MASK_CAPABLE_BB                                                      (0x1<<8) // This value controls the per vector masking capability in the MSI control field
  #define PCIEIP_REG_REG_ID_VAL4_MSI_PV_MASK_CAPABLE_BB_SHIFT                                                8
  #define PCIEIP_REG_REG_ID_VAL4_MSI_LIMIT_BB                                                                (0x7<<9) // This value reports the MSI value that is programmed in the PCI configuration space. This value will always be equal or less than what was advertised. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL4_MSI_LIMIT_BB_SHIFT                                                          9
  #define PCIEIP_REG_REG_ID_VAL4_MULTI_MSG_CAP_BB                                                            (0x7<<12) // This value controls the read value of the MSI_CTRL_MCAP value in the PCI configuration space. The default is 0, which is one MSI. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL4_MULTI_MSG_CAP_BB_SHIFT                                                      12
  #define PCIEIP_REG_REG_ID_VAL4_MSI_ENABLE_BB                                                               (0x1<<15) // This bit indicates the programming of the MSI Enable bit in PCI configuration space. If this bit is set, it means that the interrupt output is masked and all interrupts must be indicated with MSI cycles.
  #define PCIEIP_REG_REG_ID_VAL4_MSI_ENABLE_BB_SHIFT                                                         15
  #define PCIEIP_REG_REG_ID_VAL4_RESERVED3_BB                                                                (0xffff<<16) // 
  #define PCIEIP_REG_REG_ID_VAL4_RESERVED3_BB_SHIFT                                                          16
#define PCIEIP_REG_REG_ID_VAL5_BB                                                                            0x000444UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ID_VAL5_D1_SUPPORT_BB                                                               (0x1<<0) // This bit indicates whether the device supports the D1 power management state. It is reflected in the D1_SUPPORT bit in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL5_D1_SUPPORT_BB_SHIFT                                                         0
  #define PCIEIP_REG_REG_ID_VAL5_D2_SUPPORT_BB                                                               (0x1<<1) // This bit indicates whether the device supports the D2 power management state. It is reflected in the D2_SUPPORT bit in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL5_D2_SUPPORT_BB_SHIFT                                                         1
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D0_BB                                                                (0x1<<2) // This bit indicates whether the device supports transmiting PME message from the D0 power state. It is reflected in the PME_IN_D0 bit in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D0_BB_SHIFT                                                          2
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D1_BB                                                                (0x1<<3) // This bit indicates whether the device supports transmiting PME message from the D1 power state. It is reflected in the PME_IN_D1 bit in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D1_BB_SHIFT                                                          3
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D2_BB                                                                (0x1<<4) // This bit indicates whether the device supports transmiting PME message from the D2 power state. It is reflected in the PME_IN_D2 bit in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D2_BB_SHIFT                                                          4
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D3_HOT_BB                                                            (0x1<<5) // This bit indicates whether the device supports transmiting PME message from the D3hot power state. It is reflected in the PME_IN_D3_HOT bit in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL5_PME_IN_D3_HOT_BB_SHIFT                                                      5
  #define PCIEIP_REG_REG_ID_VAL5_PM_VERSION_BB                                                               (0x7<<6) // The value indicates the function complies with which revision of PCI PM spec. This value is reflected in corresponding field in PM capabilities register
  #define PCIEIP_REG_REG_ID_VAL5_PM_VERSION_BB_SHIFT                                                         6
  #define PCIEIP_REG_REG_ID_VAL5_NO_SOFT_RESET_BB                                                            (0x1<<9) // This indicates function does not perform an internal reset when transitioning from D3 to D0. the value is reflected in corresponding field in PM CSR.
  #define PCIEIP_REG_REG_ID_VAL5_NO_SOFT_RESET_BB_SHIFT                                                      9
  #define PCIEIP_REG_REG_ID_VAL5_RESERVED0_BB                                                                (0x3fffff<<10) // 
  #define PCIEIP_REG_REG_ID_VAL5_RESERVED0_BB_SHIFT                                                          10
#define PCIEIP_REG_REG_ID_VAL6_BB                                                                            0x00044cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ID_VAL6_UNUSED0_BB                                                                  (0xffff<<0) // 
  #define PCIEIP_REG_REG_ID_VAL6_UNUSED0_BB_SHIFT                                                            0
  #define PCIEIP_REG_REG_ID_VAL6_BIST_BB                                                                     (0xff<<16) // This register controls the read value of the bist register in the configuration space. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_ID_VAL6_BIST_BB_SHIFT                                                               16
#define PCIEIP_REG_REG_MSI_DATA_BB                                                                           0x000450UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_MSI_DATA_MSI_DATA_BB                                                                (0xffff<<0) // This register reflects the MSI data register value in the configuration space. This value may be used by the completion processor to determine the data value it will use for vectored MSI cycles.
  #define PCIEIP_REG_REG_MSI_DATA_MSI_DATA_BB_SHIFT                                                          0
#define PCIEIP_REG_REG_MSI_ADDR_H_BB                                                                         0x000454UL //Access:R    DataWidth:0x20   // This register reflects the upper half of the MSI address register value in the configuration space. This value may be used by the completion processor to determine the address value it will use for vectored MSI cycles.
#define PCIEIP_REG_REG_MSI_ADDR_L_BB                                                                         0x000458UL //Access:R    DataWidth:0x20   // This register reflects the lower half of the MSI address bit[31:2] value in the configuration space. The lower two bits [1:0] are hard wired to zero. This value may be used by the completion processor to determine the address value it will use for vectored MSI cycles.
#define PCIEIP_REG_REG_MSI_MASK_BB                                                                           0x000464UL //Access:R    DataWidth:0x20   // This register reflects the MSI mask register value in the configuration space
#define PCIEIP_REG_REG_MSI_PEND_BB                                                                           0x000468UL //Access:RW   DataWidth:0x20   // Each pending bit that is set , the function has a pending associated message. This register gets reflected in the configuration space.
#define PCIEIP_REG_REG_PM_DATA_C_BB                                                                          0x00046cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PM_DATA_C_PM_DATA_8_PRG_BB                                                          (0xff<<0) // This is the value read from the pm_data register when the DATA_SEL value in the PM_CSR register is 8. This is the power dissipated by common logic in case of multi function devices. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PM_DATA_C_PM_DATA_8_PRG_BB_SHIFT                                                    0
  #define PCIEIP_REG_REG_PM_DATA_C_RESERVED0_BB                                                              (0xffffff<<8) // 
  #define PCIEIP_REG_REG_PM_DATA_C_RESERVED0_BB_SHIFT                                                        8
#define PCIEIP_REG_REG_MSIX_CONTROL_BB                                                                       0x0004c0UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_MSIX_CONTROL_MSIX_TBL_SIZ_BB                                                        (0x7ff<<0) // This register controls the read value of the MSIX_CONTROL[10:0] register in the configuration space. A value of "00000000011" indicates a table size of 4 Lower 6 bits of this field also exists in VF register space
  #define PCIEIP_REG_REG_MSIX_CONTROL_MSIX_TBL_SIZ_BB_SHIFT                                                  0
  #define PCIEIP_REG_REG_MSIX_CONTROL_RESERVED0_BB                                                           (0x1fffff<<11) // 
  #define PCIEIP_REG_REG_MSIX_CONTROL_RESERVED0_BB_SHIFT                                                     11
#define PCIEIP_REG_REG_MSIX_TBL_OFF_BIR_BB                                                                   0x0004c4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_MSIX_TBL_OFF_BIR_MSIX_TBL_BIR_BB                                                    (0x7<<0) // This register controls the read value of the MSIX_TBL_OFF_BIR[2:0] register. This indicates which one of the function's Base address registers located at 10h in configuration space is used to map the function's MSI-X table into memory space. Value is controlled by PCIE_MSIX_TBL_OFF field in version.v
  #define PCIEIP_REG_REG_MSIX_TBL_OFF_BIR_MSIX_TBL_BIR_BB_SHIFT                                              0
  #define PCIEIP_REG_REG_MSIX_TBL_OFF_BIR_MSIX_TBL_OFF_BB                                                    (0x1fffffff<<3) // This register controls the read value of the MSIX_TBL_OFF_BIR[31:3] register. This is used as an offset from the address contained by one of the functions Base address registers to point to the base of the MSI-X table. Value is controlled by PCIE_MSIX_TBL_OFF field in version.v
  #define PCIEIP_REG_REG_MSIX_TBL_OFF_BIR_MSIX_TBL_OFF_BB_SHIFT                                              3
#define PCIEIP_REG_REG_MSIX_PBA_OFF_BIR_BB                                                                   0x0004c8UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_MSIX_PBA_OFF_BIR_MSIX_PBA_BIR_BB                                                    (0x7<<0) // This register controls the read value of the MSIX_PBA_OFF_BIR[2:0] register. This indicates which one of the function's Base address registers located at 10h in configuration space is used to map the function's MSI-X PBA into memory space. Value is controlled by PCIE_MSIX_PBA_OFF field in version.v
  #define PCIEIP_REG_REG_MSIX_PBA_OFF_BIR_MSIX_PBA_BIR_BB_SHIFT                                              0
  #define PCIEIP_REG_REG_MSIX_PBA_OFF_BIR_MSIX_PBA_OFF_BB                                                    (0x1fffffff<<3) // This register controls the read value of the MSIX_PBA_OFF_BIR[31:3] register. This is used as an offset from the address contained by one of the functions Base address registers to point to the base of the MSI-X PBA Value is controlled by PCIE_MSIX_PBA_OFF field in version.v
  #define PCIEIP_REG_REG_MSIX_PBA_OFF_BIR_MSIX_PBA_OFF_BB_SHIFT                                              3
#define PCIEIP_REG_REG_PCIE_CAPABILITY_BB                                                                    0x0004d0UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PCIE_CAPABILITY_INTERRUPT_MSG_NUM_BB                                                (0x1f<<0) // This controls the value in configuration space
  #define PCIEIP_REG_REG_PCIE_CAPABILITY_INTERRUPT_MSG_NUM_BB_SHIFT                                          0
  #define PCIEIP_REG_REG_PCIE_CAPABILITY_COMPLY_PCIE_1_1_BB                                                  (0x1<<5) // This bit when set, hides any PCIE spec 2.0 defined registers (bits) and enables design to be 1.1 compliant
  #define PCIEIP_REG_REG_PCIE_CAPABILITY_COMPLY_PCIE_1_1_BB_SHIFT                                            5
  #define PCIEIP_REG_REG_PCIE_CAPABILITY_ASPM_OPTIONALITY_BB                                                 (0x1<<6) // This bit when set, sets the ASPM optionality bit in the Link cap register. This bit is recommended to be set for newer PCIe devices and required for 3.0 compliant devices
  #define PCIEIP_REG_REG_PCIE_CAPABILITY_ASPM_OPTIONALITY_BB_SHIFT                                           6
#define PCIEIP_REG_REG_DEVICE_CAPABILITY_BB                                                                  0x0004d4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_MAX_PL_SIZE_SUPPORTED_BB                                          (0x7<<0) // This controls the value of this field in the DEVICE_CAP register in the configuration space
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_MAX_PL_SIZE_SUPPORTED_BB_SHIFT                                    0
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_UNUSED0_BB                                                        (0x3<<3) // 
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_UNUSED0_BB_SHIFT                                                  3
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_EXTENDED_TAG_SUPPORT_BB                                           (0x1<<5) // This controls the value of this field in the DEVICE_CAP register in the configuration field
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_EXTENDED_TAG_SUPPORT_BB_SHIFT                                     5
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_L0S_ACCEPTABLE_LATENCY_BB                                         (0x7<<6) // This controls the value of this field in the configuration space
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_L0S_ACCEPTABLE_LATENCY_BB_SHIFT                                   6
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_L1_ACCEPTABLE_LATENCY_BB                                          (0x7<<9) // This controls the value in the configuration space
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_L1_ACCEPTABLE_LATENCY_BB_SHIFT                                    9
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_UNUSED1_BB                                                        (0x7<<12) // 
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_UNUSED1_BB_SHIFT                                                  12
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_ROLE_BASED_ERR_RPT_BB                                             (0x1<<15) // This controls value in configuration space
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_ROLE_BASED_ERR_RPT_BB_SHIFT                                       15
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_UNUSED2_BB                                                        (0xfff<<16) // 
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_UNUSED2_BB_SHIFT                                                  16
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_FLR_SUPPORTED_BB                                                  (0x1<<28) // This controls value in configuration space and allows FLR capability to be advertized by DUT.
  #define PCIEIP_REG_REG_DEVICE_CAPABILITY_FLR_SUPPORTED_BB_SHIFT                                            28
#define PCIEIP_REG_REG_DEVICE_CONTROL_BB                                                                     0x0004d8UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_DEVICE_CONTROL_UNUSED0_BB                                                           (0x7ffffff<<0) // 
  #define PCIEIP_REG_REG_DEVICE_CONTROL_UNUSED0_BB_SHIFT                                                     0
  #define PCIEIP_REG_REG_DEVICE_CONTROL_FLR_IN_PROGRESS_BB                                                   (0x1<<27) // When FLR is initiated, this register will read a value of 1 indicating that the Function is in FLR state. Func can be brought out of FLR state either by writing 1 to this register (at least 50 ms after FLR was initiated), or it can also be cleared automatically after 55 ms if auto_clear bit in private reg space is set. This bit also exists in VF register space
  #define PCIEIP_REG_REG_DEVICE_CONTROL_FLR_IN_PROGRESS_BB_SHIFT                                             27
  #define PCIEIP_REG_REG_DEVICE_CONTROL_UNUSED1_BB                                                           (0x1<<28) // 
  #define PCIEIP_REG_REG_DEVICE_CONTROL_UNUSED1_BB_SHIFT                                                     28
  #define PCIEIP_REG_REG_DEVICE_CONTROL_SRIOV_DISABLE_IN_PROGRESS_BB                                         (0x1<<29) // When VF Enable is cleared(after it was previously set), this register will read a value of 1, indicating that all the VFs that belong to this PF should be flushed. Software should clear this bit within 1 second of VF Enable being set by writing a 1 to it, so that VFs are visible to the system again.
  #define PCIEIP_REG_REG_DEVICE_CONTROL_SRIOV_DISABLE_IN_PROGRESS_BB_SHIFT                                   29
#define PCIEIP_REG_REG_LINK_CAPABILITY_BB                                                                    0x0004dcUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_LINK_CAPABILITY_MAX_LINK_SPEED_BB                                                   (0xf<<0) // This controls the value of the same field in the link_capability register in configuration space.This also controls the variables advertised by the PHY such as FTS ordered sets etc.
  #define PCIEIP_REG_REG_LINK_CAPABILITY_MAX_LINK_SPEED_BB_SHIFT                                             0
  #define PCIEIP_REG_REG_LINK_CAPABILITY_MAX_LINK_WIDTH_BB                                                   (0x1f<<4) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_MAX_LINK_WIDTH_BB_SHIFT                                             4
  #define PCIEIP_REG_REG_LINK_CAPABILITY_CLK_POWER_MGMT_BB                                                   (0x1<<9) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_CLK_POWER_MGMT_BB_SHIFT                                             9
  #define PCIEIP_REG_REG_LINK_CAPABILITY_ASPM_SUPPORT_BB                                                     (0x3<<10) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_ASPM_SUPPORT_BB_SHIFT                                               10
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L0S_EXIT_LAT_BB                                                     (0x7<<12) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L0S_EXIT_LAT_BB_SHIFT                                               12
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L1_EXIT_LAT_BB                                                      (0x7<<15) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L1_EXIT_LAT_BB_SHIFT                                                15
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L0S_EXIT_COMM_LAT_BB                                                (0x7<<18) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L0S_EXIT_COMM_LAT_BB_SHIFT                                          18
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L1_EXIT_COMM_LAT_BB                                                 (0x7<<21) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_L1_EXIT_COMM_LAT_BB_SHIFT                                           21
  #define PCIEIP_REG_REG_LINK_CAPABILITY_PORT_NUM_BB                                                         (0xff<<24) // This controls the value of the same field in the link_capability register in configuration space
  #define PCIEIP_REG_REG_LINK_CAPABILITY_PORT_NUM_BB_SHIFT                                                   24
#define PCIEIP_REG_REG_BAR2_CONFIG_BB                                                                        0x0004e0UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_BAR2_CONFIG_BAR2_SIZE_BB                                                            (0xf<<0) // These bits control the size of the BAR2 area advertised in the bar_3 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. Default is 64K bytes.
  #define PCIEIP_REG_REG_BAR2_CONFIG_BAR2_SIZE_BB_SHIFT                                                      0
  #define PCIEIP_REG_REG_BAR2_CONFIG_BAR2_64ENA_BB                                                           (0x1<<4) // This bit enables the advertisement of bar_3 as a 32-bit address. The value of this bit maps directly to bit 2 of bar_3. This value is sticky and only reset by HARD Reset. Default is 64bit addressing.
  #define PCIEIP_REG_REG_BAR2_CONFIG_BAR2_64ENA_BB_SHIFT                                                     4
  #define PCIEIP_REG_REG_BAR2_CONFIG_BAR2_PREFETCH_BB                                                        (0x1<<5) // This bit when set is reflected in bit 3 of bar_3 and indicates that the BAR is pre-fetchable
  #define PCIEIP_REG_REG_BAR2_CONFIG_BAR2_PREFETCH_BB_SHIFT                                                  5
  #define PCIEIP_REG_REG_BAR2_CONFIG_RESERVED_BB                                                             (0x3ffffff<<6) // 
  #define PCIEIP_REG_REG_BAR2_CONFIG_RESERVED_BB_SHIFT                                                       6
#define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_BB                                                           0x0004e4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_CMPL_TO_RANGE_SUPP_BB                                      (0xf<<0) // Completion Timeout Ranges Supported. Controls value in same field in the config space 0xF- Ranges A,B,C and D
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_CMPL_TO_RANGE_SUPP_BB_SHIFT                                0
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_CMPL_TO_DISABL_SUPP_BB                                     (0x1<<4) // Completion Timeout Disable Supported, Controls value in same field in the config space
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_CMPL_TO_DISABL_SUPP_BB_SHIFT                               4
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_RESERVED1_BB                                               (0x1f<<5) // unused
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_RESERVED1_BB_SHIFT                                         5
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_IDO_SUPPORTED_BB                                           (0x1<<10) // This bit is valid only if IDO_Enabled is defined in version.v. When this bit is set, IDO feature is made visible to external config access.
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_IDO_SUPPORTED_BB_SHIFT                                     10
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_UNUSED0_BB                                                 (0x7f<<11) // 
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_UNUSED0_BB_SHIFT                                           11
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_OBFF_SUPPORTED_BB                                          (0x3<<18) // This indicates that OBFF is supported using WAKE# signalling only. It is recommended to set this value to 2 or 3(also supported using Messages) This bit is valid only if PCIE_OBFF_SUPP is defined in version.v. When this bit is set, OBFF feature is made visible to external config access.
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_OBFF_SUPPORTED_BB_SHIFT                                    18
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_RESERVED_BB                                                (0xfff<<20) // unused
  #define PCIEIP_REG_REG_PCIE_DEVICE_CAPABILITY_2_RESERVED_BB_SHIFT                                          20
#define PCIEIP_REG_REG_PCIE_LINK_CAPABILITY_2_BB                                                             0x0004e8UL //Access:RW   DataWidth:0x20   // Place holder for now
#define PCIEIP_REG_REG_PCIE_LINK_CONTROL_BB                                                                  0x0004ecUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PCIE_LINK_CONTROL_RC_RCB_BB                                                         (0x1<<0) // Not supported for EP
  #define PCIEIP_REG_REG_PCIE_LINK_CONTROL_RC_RCB_BB_SHIFT                                                   0
#define PCIEIP_REG_REG_PCIE_LINK_CAPABILITY_RC_BB                                                            0x0004f0UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PCIE_LINK_CAPABILITY_RC_RC_DL_ACTIVE_CAP_BB                                         (0x1<<0) // RC only. If set, indicates dl_active capability at bit 20 of link_capability register. For EP, this field will not has any effect in link_capability register.
  #define PCIEIP_REG_REG_PCIE_LINK_CAPABILITY_RC_RC_DL_ACTIVE_CAP_BB_SHIFT                                   0
  #define PCIEIP_REG_REG_PCIE_LINK_CAPABILITY_RC_SLOT_CLK_CONFIG_BB                                          (0x1<<1) // If set, indicates device use the same reference clock that the platform provides on the connector.
  #define PCIEIP_REG_REG_PCIE_LINK_CAPABILITY_RC_SLOT_CLK_CONFIG_BB_SHIFT                                    1
#define PCIEIP_REG_REG_BAR3_CONFIG_BB                                                                        0x0004f4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_BAR3_CONFIG_BAR3_SIZE_BB                                                            (0xf<<0) // These bits control the size of the BAR3 area advertised in the bar_5 register of the PCI configuration space. This value is sticky and only reset by HARD Reset. This register is only applicable for EP.
  #define PCIEIP_REG_REG_BAR3_CONFIG_BAR3_SIZE_BB_SHIFT                                                      0
  #define PCIEIP_REG_REG_BAR3_CONFIG_BAR3_64ENA_BB                                                           (0x1<<4) // This bit enables the advertisement of bar_5 as a 32-bit address. The value of this bit maps directly to bit 2 of bar_5. This value is sticky and only reset by HARD Reset. This register is only applicable for EP.
  #define PCIEIP_REG_REG_BAR3_CONFIG_BAR3_64ENA_BB_SHIFT                                                     4
  #define PCIEIP_REG_REG_BAR3_CONFIG_BAR3_PREFETCH_BB                                                        (0x1<<5) // This bit when set is reflected in bit 3 of bar_5 and indicates that the BAR is pre-fetchable. This register is only applicable for EP.
  #define PCIEIP_REG_REG_BAR3_CONFIG_BAR3_PREFETCH_BB_SHIFT                                                  5
  #define PCIEIP_REG_REG_BAR3_CONFIG_RESERVED_BB                                                             (0x3ffffff<<6) // 
  #define PCIEIP_REG_REG_BAR3_CONFIG_RESERVED_BB_SHIFT                                                       6
#define PCIEIP_REG_REG_ROOT_CAP_BB                                                                           0x0004f8UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ROOT_CAP_RC_CRS_CAP_BB                                                              (0x1<<0) // This register is reserved for RC only. It is not applicable for EP.
  #define PCIEIP_REG_REG_ROOT_CAP_RC_CRS_CAP_BB_SHIFT                                                        0
  #define PCIEIP_REG_REG_ROOT_CAP_RC_LTR_SUPPORTED_BB                                                        (0x1<<1) // This register is reserved for RC only. It is not applicable for EP.
  #define PCIEIP_REG_REG_ROOT_CAP_RC_LTR_SUPPORTED_BB_SHIFT                                                  1
  #define PCIEIP_REG_REG_ROOT_CAP_RC_CLKREQ_SUPPORTED_BB                                                     (0x1<<2) // This register is reserved for RC only. It is not applicable for EP.
  #define PCIEIP_REG_REG_ROOT_CAP_RC_CLKREQ_SUPPORTED_BB_SHIFT                                               2
  #define PCIEIP_REG_REG_ROOT_CAP_RC_EXT2_CAP_ENA_BB                                                         (0x1f<<3) // If it is set, indicates RC supports CLKREQ Enable for the RC extended capability structures. Basic extended capability structure is defined in bits 31:30 of RC_EXT_CAP_ENA field . AER in bits 31:30 is always enabled, so that extended capability structure will follow the requirement of starting at 0x100. L1Sub capability will be present only if PMCR_RC_L1_SUBSTATES_ENA is defined in version.v Secondary PCIE extended capability will be present only if pcieGen3Rate is defined in version.v
  #define PCIEIP_REG_REG_ROOT_CAP_RC_EXT2_CAP_ENA_BB_SHIFT                                                   3
#define PCIEIP_REG_REG_ROOT_CONTROL_BB                                                                       0x0004fcUL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ROOT_CONTROL_RC_CLKREQ_ENABLED_BB                                                   (0x1<<0) // This register is reserved for RC only. It is not applicable for EP.
  #define PCIEIP_REG_REG_ROOT_CONTROL_RC_CLKREQ_ENABLED_BB_SHIFT                                             0
#define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_BB                                                                 0x000500UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_DEV_SER_NUM_CAP_ID_BB                                            (0xffff<<0) // This register controls the value of CAP_ID in the DEV_SER_NUM_CAP_ID (0x13C) register in the configuration space.
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_DEV_SER_NUM_CAP_ID_BB_SHIFT                                      0
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_DEV_SER_NUM_CAP_VER_BB                                           (0xf<<16) // This register controls the value of CAP_VER in the DEV_SER_NUM_CAP_ID (0x13C) register in the configuration space.
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_DEV_SER_NUM_CAP_VER_BB_SHIFT                                     16
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_EXT_CAP_ENA_BB                                                   (0x3f<<20) // Enable for the EP extended capability structures. Default the link list is adv err, dev serial, pwr budget, virtual channel LTR capability will be present only if LTR_ENABLED is defined in version.v
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_EXT_CAP_ENA_BB_SHIFT                                             20
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_EXT_REG_CAP_ENA_BB                                               (0xf<<26) // Reserved Enable for the EP extended capability structures. Basic extended capability structure is defined in bits 25:20. AER in bits 25:20 should always be enabled, so that extended capability structure will follow the requirement of starting at 0x100. ARI, SRIOV capability will be present only if SRIOV is defined in version.v SRIOV capability should not be enabled without enabling ARI capability. ATS capability will be present only if ATS_ON is defined in version.v
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_EXT_REG_CAP_ENA_BB_SHIFT                                         26
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_RC_EXT_CAP_ENA_BB                                                (0x3<<30) // Enable for the RC extended capability structures
  #define PCIEIP_REG_REG_DEV_SER_NUM_CAP_ID_RC_EXT_CAP_ENA_BB_SHIFT                                          30
#define PCIEIP_REG_REG_LOWER_SER_NUM_BB                                                                      0x000504UL //Access:RW   DataWidth:0x20   // This register controls the value in the LOWER_SER_NUM (0x104) in the configuration space.
#define PCIEIP_REG_REG_UPPER_SER_NUM_BB                                                                      0x000508UL //Access:RW   DataWidth:0x20   // This register controls the value in the UPPER_SER_NUM (0x108) in the configuration space.
#define PCIEIP_REG_REG_ADV_ERR_CAP_BB                                                                        0x00050cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ADV_ERR_CAP_ECRC_CHK_CAP_BB                                                         (0x1<<0) // This value controls the corresponding bit in the ADV_ERR_CAP _CONTROL (0x128)
  #define PCIEIP_REG_REG_ADV_ERR_CAP_ECRC_CHK_CAP_BB_SHIFT                                                   0
  #define PCIEIP_REG_REG_ADV_ERR_CAP_ECRC_GEN_CAP_BB                                                         (0x1<<1) // This value controls the corresponding bit in the ADV_ERR_CAP _CONTROL (0x128)
  #define PCIEIP_REG_REG_ADV_ERR_CAP_ECRC_GEN_CAP_BB_SHIFT                                                   1
#define PCIEIP_REG_REG_PWR_BDGT_DATA_0_BB                                                                    0x000510UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_0_PWR_BDGT_DATA_0_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 0. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_0_PWR_BDGT_DATA_0_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_0_RESERVED_BB                                                         (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_0_RESERVED_BB_SHIFT                                                   21
#define PCIEIP_REG_REG_PWR_BDGT_DATA_1_BB                                                                    0x000514UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_1_PWR_BDGT_DATA_1_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 1. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_1_PWR_BDGT_DATA_1_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_1_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_1_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_PWR_BDGT_DATA_2_BB                                                                    0x000518UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_2_PWR_BDGT_DATA_2_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 2. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_2_PWR_BDGT_DATA_2_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_2_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_2_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_PWD_BDGT_DATA_3_BB                                                                    0x00051cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWD_BDGT_DATA_3_PWR_BDGT_DATA_3_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 3. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWD_BDGT_DATA_3_PWR_BDGT_DATA_3_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWD_BDGT_DATA_3_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWD_BDGT_DATA_3_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_PWR_BDGT_DATA_4_BB                                                                    0x000520UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_4_PWR_BDGT_DATA_4_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 4. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_4_PWR_BDGT_DATA_4_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_4_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_4_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_PWR_BDGT_DATA_5_BB                                                                    0x000524UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_5_PWR_BDGT_DATA_5_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 5. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_5_PWR_BDGT_DATA_5_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_5_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_5_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_PWR_BDGT_DATA_6_BB                                                                    0x000528UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_6_PWR_BDGT_DATA_6_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 6. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_6_PWR_BDGT_DATA_6_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_6_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_6_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_PWR_BDGT_DATA_7_BB                                                                    0x00052cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_7_PWR_BDGT_DATA_7_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 7. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_7_PWR_BDGT_DATA_7_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_7_RW_BB                                                               (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_7_RW_BB_SHIFT                                                         21
#define PCIEIP_REG_REG_EXT2_CAP_ADDR_BB                                                                      0x000530UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_EXT2_CAP_ADDR_EXT2_CAP_ENA_BB                                                       (0xf<<0) // Enable for the EP extended capability structures. Basic extended capability structure is defined in bits 25:20 and additional extended capability is in 29:26 in dev_ser_num_cap_id register. AER in bits 25:20 should always be enabled, so that extended capability structure will follow the requirement of starting at 0x100. TPH capability will be present only if TPH_ON is defined in version.v SRIOV capability should not be enabled without enabling ARI capability. Secondary PCIE extended capability will be present only if pcieGen3Rate is defined in version.v
  #define PCIEIP_REG_REG_EXT2_CAP_ADDR_EXT2_CAP_ENA_BB_SHIFT                                                 0
  #define PCIEIP_REG_REG_EXT2_CAP_ADDR_EXT3_CAP_ENA_BB                                                       (0xf<<4) // Enable for the EP extended capability structures. Basic extended capability structure is defined in bits 25:20 and additional extended capability is in 29:26 in dev_ser_num_cap_id register. The next set of capabilities are defined in etx2_cap_ena in bits 3:0 of this register. This register enables the PTM capability which will be present PCIE_PTM_SUPP is defined in version.v
  #define PCIEIP_REG_REG_EXT2_CAP_ADDR_EXT3_CAP_ENA_BB_SHIFT                                                 4
  #define PCIEIP_REG_REG_EXT2_CAP_ADDR_RW_BB                                                                 (0xffffff<<8) // 
  #define PCIEIP_REG_REG_EXT2_CAP_ADDR_RW_BB_SHIFT                                                           8
#define PCIEIP_REG_REG_PWR_BDGT_DATA_8_BB                                                                    0x000534UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_8_PWR_BDGT_DATA_8_BB                                                  (0x1fffff<<0) // This is the value read from the pwr_bdgt_data register (0x158) when the pwr_bdgt_data_sel register (0x154) value is 7. This value is sticky and only reset by HARD Reset.
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_8_PWR_BDGT_DATA_8_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_8_RESERVED_BB                                                         (0x7ff<<21) // 
  #define PCIEIP_REG_REG_PWR_BDGT_DATA_8_RESERVED_BB_SHIFT                                                   21
#define PCIEIP_REG_REG_L1SUB_CAP_BB                                                                          0x000540UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_L1SUB_CAP_PM_L1_2_SUPP_BB                                                           (0x1<<0) // Advertize L1_2 capability support for PM
  #define PCIEIP_REG_REG_L1SUB_CAP_PM_L1_2_SUPP_BB_SHIFT                                                     0
  #define PCIEIP_REG_REG_L1SUB_CAP_PM_L1_1_SUPP_BB                                                           (0x1<<1) // Advertize L1_1 capability support for PM
  #define PCIEIP_REG_REG_L1SUB_CAP_PM_L1_1_SUPP_BB_SHIFT                                                     1
  #define PCIEIP_REG_REG_L1SUB_CAP_ASPM_L1_2_SUPP_BB                                                         (0x1<<2) // Advertize L1_2 capability support for ASPM
  #define PCIEIP_REG_REG_L1SUB_CAP_ASPM_L1_2_SUPP_BB_SHIFT                                                   2
  #define PCIEIP_REG_REG_L1SUB_CAP_ASPM_L1_1_SUPP_BB                                                         (0x1<<3) // Advertize L1_1 capability support for ASPM
  #define PCIEIP_REG_REG_L1SUB_CAP_ASPM_L1_1_SUPP_BB_SHIFT                                                   3
  #define PCIEIP_REG_REG_L1SUB_CAP_CLKREQ_L1SUB_SUPP_BB                                                      (0x1<<4) // Clkreq based L1 substates is supported.
  #define PCIEIP_REG_REG_L1SUB_CAP_CLKREQ_L1SUB_SUPP_BB_SHIFT                                                4
  #define PCIEIP_REG_REG_L1SUB_CAP_RESERVED_1_BB                                                             (0x7<<5) // 
  #define PCIEIP_REG_REG_L1SUB_CAP_RESERVED_1_BB_SHIFT                                                       5
  #define PCIEIP_REG_REG_L1SUB_CAP_L1SUB_CMN_MODE_UP_TIME_BB                                                 (0xff<<8) // Time in us that device advertizes that it requires to re-establish common mode.
  #define PCIEIP_REG_REG_L1SUB_CAP_L1SUB_CMN_MODE_UP_TIME_BB_SHIFT                                           8
  #define PCIEIP_REG_REG_L1SUB_CAP_L1SUB_PWR_ON_SCALE_BB                                                     (0x3<<16) // Along with the value field, this field advertizes the tpower_on time in us, that the link partner must wait when exiting from L1_2 state due to driving CLKREQ#, before actively driving the interface.
  #define PCIEIP_REG_REG_L1SUB_CAP_L1SUB_PWR_ON_SCALE_BB_SHIFT                                               16
  #define PCIEIP_REG_REG_L1SUB_CAP_RESERVED_0_BB                                                             (0x1<<18) // 
  #define PCIEIP_REG_REG_L1SUB_CAP_RESERVED_0_BB_SHIFT                                                       18
  #define PCIEIP_REG_REG_L1SUB_CAP_L1SUB_PWR_ON_VALUE_BB                                                     (0x1f<<19) // Along with the scale field, this field advertizes the tpower_on time in us, that the link partner must wait when exiting from L1_2 state due to driving CLKREQ#, before actively driving the interface.
  #define PCIEIP_REG_REG_L1SUB_CAP_L1SUB_PWR_ON_VALUE_BB_SHIFT                                               19
  #define PCIEIP_REG_REG_L1SUB_CAP_RESERVED_BB                                                               (0xff<<24) // 
  #define PCIEIP_REG_REG_L1SUB_CAP_RESERVED_BB_SHIFT                                                         24
#define PCIEIP_REG_REG_L1SUB_EXT_CAP_BB                                                                      0x000544UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_L1SUB_EXT_CAP_L1SUB_VERSION_CAPID_BB                                                (0xfffff<<0) // This field is provided to program the cap ID and version number for L1 substates capability structure. The field was not finalized as of time of implementation and so is programmable.
  #define PCIEIP_REG_REG_L1SUB_EXT_CAP_L1SUB_VERSION_CAPID_BB_SHIFT                                          0
  #define PCIEIP_REG_REG_L1SUB_EXT_CAP_RESERVED_BB                                                           (0xfff<<20) // 
  #define PCIEIP_REG_REG_L1SUB_EXT_CAP_RESERVED_BB_SHIFT                                                     20
#define PCIEIP_REG_REG_PWR_BDGT_CAPABILITY_BB                                                                0x000550UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_PWR_BDGT_CAPABILITY_PWR_SYSTEM_ALLOC_BB                                             (0x1<<0) // This bit controls the system alloc bit in the PWR_BDGT_CAP (0x15c) in the configuration space
  #define PCIEIP_REG_REG_PWR_BDGT_CAPABILITY_PWR_SYSTEM_ALLOC_BB_SHIFT                                       0
  #define PCIEIP_REG_REG_PWR_BDGT_CAPABILITY_RESERVED_BB                                                     (0x7fffffff<<1) // 
  #define PCIEIP_REG_REG_PWR_BDGT_CAPABILITY_RESERVED_BB_SHIFT                                               1
#define PCIEIP_REG_REG_VSEC_HDR_BB                                                                           0x000554UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VSEC_HDR_VSEC_ID_BB                                                                 (0xffff<<0) // Vendor defined ID of VSEC structure. Software must qualify the Vendor ID and VSEC ID before interpreting this field.
  #define PCIEIP_REG_REG_VSEC_HDR_VSEC_ID_BB_SHIFT                                                           0
  #define PCIEIP_REG_REG_VSEC_HDR_VSEC_REV_BB                                                                (0xf<<16) // Vendor defined version number of VSEC structure.
  #define PCIEIP_REG_REG_VSEC_HDR_VSEC_REV_BB_SHIFT                                                          16
  #define PCIEIP_REG_REG_VSEC_HDR_VSEC_LENGTH_BB                                                             (0xfff<<20) // VSEC Length: Indicates the number of bytes in the entire VSEC structure, including the PCI Express Enhanced Capacbility Header, Vendor Specific Header, and the Vendor Specific Registers.
  #define PCIEIP_REG_REG_VSEC_HDR_VSEC_LENGTH_BB_SHIFT                                                       20
#define PCIEIP_REG_REG_RC_USER_MEM_LO1_BB                                                                    0x000558UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_RC_USER_SIZE1_BB                                                    (0xf<<0) // These bits control the size of the user BAR1 area. This value is sticky and only reset by HARD Reset. This register is only applicable for RC.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_RC_USER_SIZE1_BB_SHIFT                                              0
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_UNUSED_2_BB                                                         (0x7<<4) // 
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_UNUSED_2_BB_SHIFT                                                   4
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_RC_USER_MEM_EN1_BB                                                  (0x1<<7) // Enable User Defined Mem area in RC mode. If this bit is set, then memory transactions received in Rx direction are compared against the user defined address range before it is forwarded to user. If requests do not fall in this USer BAR area, the request is target aborted.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_RC_USER_MEM_EN1_BB_SHIFT                                            7
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_UNUSED_1_BB                                                         (0xff<<8) // 
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_UNUSED_1_BB_SHIFT                                                   8
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_RC_USER_MEM_ADDR_LO1_BB                                             (0xffff<<16) // USER_BAR_LOWER_ADDRESS: Lower 16 bits of BAR for user in RC mode. This is not the PCI standard compliant BAR, but is instead a mechanism for user to provide a mem range restriction over and above that specified by the PCI Base and Limit registers.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO1_RC_USER_MEM_ADDR_LO1_BB_SHIFT                                       16
#define PCIEIP_REG_REG_RC_USER_MEM_HI1_BB                                                                    0x00055cUL //Access:R    DataWidth:0x20   // USER_BAR_HIGHER_ADDRESS: Higher 32 bits of BAR for user in RC mode. This is not the PCI standard compliant BAR, but is instead a mechanism for user to provide a mem range restriction over and above that specified by the PCI Base and Limit registers.
#define PCIEIP_REG_REG_RC_USER_MEM_LO2_BB                                                                    0x000560UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_RC_USER_SIZE2_BB                                                    (0xf<<0) // These bits control the size of the user BAR1 area. This value is sticky and only reset by HARD Reset. This register is only applicable for RC.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_RC_USER_SIZE2_BB_SHIFT                                              0
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_UNUSED_2_BB                                                         (0x7<<4) // 
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_UNUSED_2_BB_SHIFT                                                   4
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_RC_USER_MEM_EN2_BB                                                  (0x1<<7) // Enable User Defined Mem area in RC mode. If this bit is set, then memory transactions received in Rx direction are compared against the user defined address range before it is forwarded to user. If requests do not fall in this USer BAR area, the request is target aborted.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_RC_USER_MEM_EN2_BB_SHIFT                                            7
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_UNUSED_1_BB                                                         (0xff<<8) // 
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_UNUSED_1_BB_SHIFT                                                   8
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_RC_USER_MEM_ADDR_LO2_BB                                             (0xffff<<16) // USER_BAR_LOWER_ADDRESS: Lower 16 bits of BAR for user in RC mode. This is not the PCI standard compliant BAR, but is instead a mechanism for user to provide a mem range restriction over and above that specified by the PCI Base and Limit registers.
  #define PCIEIP_REG_REG_RC_USER_MEM_LO2_RC_USER_MEM_ADDR_LO2_BB_SHIFT                                       16
#define PCIEIP_REG_REG_RC_USER_MEM_HI2_BB                                                                    0x000564UL //Access:R    DataWidth:0x20   // USER_BAR_HIGHER_ADDRESS: Higher 32 bits of BAR for user in RC mode. This is not the PCI standard compliant BAR, but is instead a mechanism for user to provide a mem range restriction over and above that specified by the PCI Base and Limit registers.
#define PCIEIP_REG_REG_PCIER_MC_WINDOW_SIZE_REQ_BB                                                           0x0005ecUL //Access:RW   DataWidth:0x20   // This register is visible only if PCIE_EP_MC_SUPP is defined in version.v
  #define PCIEIP_REG_REG_PCIER_MC_WINDOW_SIZE_REQ_MC_WINDOW_SIZE_REQ_BB                                      (0x3f<<0) // Default value of this field is 64KB. This field will be reflected in the MC Capability register.
  #define PCIEIP_REG_REG_PCIER_MC_WINDOW_SIZE_REQ_MC_WINDOW_SIZE_REQ_BB_SHIFT                                0
#define PCIEIP_REG_REG_PTM_CAP_BB                                                                            0x0005f0UL //Access:RW   DataWidth:0x20   // This register is visible only if PCIE_PTM_SUPP is defined in version.v
  #define PCIEIP_REG_REG_PTM_CAP_PTM_REQ_CAPABLE_BB                                                          (0x1<<0) // This field will be reflected in the PTM capability register.
  #define PCIEIP_REG_REG_PTM_CAP_PTM_REQ_CAPABLE_BB_SHIFT                                                    0
  #define PCIEIP_REG_REG_PTM_CAP_PTM_CAP_SUPP_BB                                                             (0x1<<1) // This field will be reflected in the PTM capability register. Field indicates device is capable of generating PTM requests.
  #define PCIEIP_REG_REG_PTM_CAP_PTM_CAP_SUPP_BB_SHIFT                                                       1
#define PCIEIP_REG_REG_TPH_CAP_BB                                                                            0x0005f4UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_TPH_CAP_TPH_INT_VEC_MODE_SUPP_BB                                                    (0x1<<0) // when Set, it indicates function supports Interrupt vector mode of op. Value programmed here is reflected in the corresponding bits in the TPH CAP register.
  #define PCIEIP_REG_REG_TPH_CAP_TPH_INT_VEC_MODE_SUPP_BB_SHIFT                                              0
  #define PCIEIP_REG_REG_TPH_CAP_TPH_DEV_SPEC_MODE_BB                                                        (0x1<<1) // When Set, it indicates function suports device specific mode of operation. Value programmed here is reflected in the corresponding bits in the TPH CAP register.
  #define PCIEIP_REG_REG_TPH_CAP_TPH_DEV_SPEC_MODE_BB_SHIFT                                                  1
  #define PCIEIP_REG_REG_TPH_CAP_TPH_ST_TABLE_LOCATION_BB                                                    (0x3<<2) // The IP supports only a value of 0, which would indicate ST Table is not present, or a value of 2, which indicates ST table is located in MSI-X Table structure. All other values should not be programmed. The value programmed here is reflected in the corresponding field of the PCIE defined TPH Capability register.
  #define PCIEIP_REG_REG_TPH_CAP_TPH_ST_TABLE_LOCATION_BB_SHIFT                                              2
  #define PCIEIP_REG_REG_TPH_CAP_TPH_ST_TABLE_SIZE_BB                                                        (0x7ff<<4) // This field will be reflected in the ST Table Size field of the PCIE defined TPH capability register. The value programmed here indicates a table size of value + 1.
  #define PCIEIP_REG_REG_TPH_CAP_TPH_ST_TABLE_SIZE_BB_SHIFT                                                  4
#define PCIEIP_REG_REG_RESIZEBAR_CAP_BB                                                                      0x0005f8UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_CAPABILITY_BB                                                    (0xf<<0) // unused
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_CAPABILITY_BB_SHIFT                                              0
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_1M_CAPABILITY_BB                                                 (0x1<<4) // when Set, it indicates function will operate with Bar sized to 1M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_1M_CAPABILITY_BB_SHIFT                                           4
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_2M_CAPABILITY_BB                                                 (0x1<<5) // when Set, it indicates function will operate with Bar sized to 2M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_2M_CAPABILITY_BB_SHIFT                                           5
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_4M_CAPABILITY_BB                                                 (0x1<<6) // when Set, it indicates function will operate with Bar sized to 4M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_4M_CAPABILITY_BB_SHIFT                                           6
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_8M_CAPABILITY_BB                                                 (0x1<<7) // when Set, it indicates function will operate with Bar sized to 8M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_8M_CAPABILITY_BB_SHIFT                                           7
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_16M_CAPABILITY_BB                                                (0x1<<8) // when Set, it indicates function will operate with Bar sized to 16M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_16M_CAPABILITY_BB_SHIFT                                          8
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_32M_CAPABILITY_BB                                                (0x1<<9) // when Set, it indicates function will operate with Bar sized to 32M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_32M_CAPABILITY_BB_SHIFT                                          9
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_64M_CAPABILITY_BB                                                (0x1<<10) // when Set, it indicates function will operate with Bar sized to 64M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_64M_CAPABILITY_BB_SHIFT                                          10
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_128M_CAPABILITY_BB                                               (0x1<<11) // when Set, it indicates function will operate with Bar sized to 128M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_128M_CAPABILITY_BB_SHIFT                                         11
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_256M_CAPABILITY_BB                                               (0x1<<12) // when Set, it indicates function will operate with Bar sized to 256M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_256M_CAPABILITY_BB_SHIFT                                         12
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_512M_CAPABILITY_BB                                               (0x1<<13) // when Set, it indicates function will operate with Bar sized to 512M. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_512M_CAPABILITY_BB_SHIFT                                         13
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_1G_CAPABILITY_BB                                                 (0x1<<14) // when Set, it indicates function will operate with Bar sized to 1G. Value programmed here is reflected in the corresponding bits in the RBAR_CAP register.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_1G_CAPABILITY_BB_SHIFT                                           14
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_512G_TO_2G_CAPABILITY_BB                                         (0x1ff<<15) // unsupported.
  #define PCIEIP_REG_REG_RESIZEBAR_CAP_SIZE_512G_TO_2G_CAPABILITY_BB_SHIFT                                   15
#define PCIEIP_REG_REG_ARI_CAP_BB                                                                            0x0005fcUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ARI_CAP_NEXT_FUNCTION_NUMBER_BB                                                     (0xff<<0) // Value programmed here is reflected in the corresponding bits in the ari_control_register. This field should be programmed to indicate the next function number of the next higher numbered function in the device or 00h, if there are no higher numbered functions.
  #define PCIEIP_REG_REG_ARI_CAP_NEXT_FUNCTION_NUMBER_BB_SHIFT                                               0
#define PCIEIP_REG_REG_INITVF_BB                                                                             0x000600UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_INITVF_INITIALVF_BB                                                                 (0xffff<<0) // Value programmed here is reflected in the corresponding bits in the SRIOV_InitialVF register. This field indicates maximum number of VFs initially associated with the PF. This value should be the same as TotalVF field.
  #define PCIEIP_REG_REG_INITVF_INITIALVF_BB_SHIFT                                                           0
  #define PCIEIP_REG_REG_INITVF_TOTALVF_BB                                                                   (0xffff<<16) // Value programmed here is reflected in the corresponding bits in the SRIOV_TotalVF Cfg register. This field indicates maximum number of VFs associated with the PF.
  #define PCIEIP_REG_REG_INITVF_TOTALVF_BB_SHIFT                                                             16
#define PCIEIP_REG_REG_VF_OFFSET_BB                                                                          0x000604UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_OFFSET_VF_OFFSET_BB                                                              (0xffff<<0) // Value programmed here is reflected in the corresponding bits in the SRIOV_VFOffset cfg register. This field defines the Routing ID of the first VF that is associated with the PF. The first VF's routing ID is calculated by adding the RID of the PF with the contents of this field. This field should be programmed based on the programming in the FIRST_VF_NUM register in the tl_reg private register space. Each PF is expected to have a multiple of 8 VFs and so this field should be programmed accordingly.
  #define PCIEIP_REG_REG_VF_OFFSET_VF_OFFSET_BB_SHIFT                                                        0
  #define PCIEIP_REG_REG_VF_OFFSET_DEVICEID_BB                                                               (0xffff<<16) // Value programmed here is reflected in the corresponding bits in the SRIOV_VFOffset Cfg register. This field indicates device ID for all VFs associated with this PF. Reset value is based on VFDEVICE_ID field in version.v
  #define PCIEIP_REG_REG_VF_OFFSET_DEVICEID_BB_SHIFT                                                         16
#define PCIEIP_REG_REG_VF_BAR_REG_BB                                                                         0x000608UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_BAR_REG_BAR0_SIZE_OF_VF_BB                                                       (0xf<<0) // This field influences the size of the VFs BAR register, advertized in the VF BAR0 register in the PCIE config space. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR_REG_BAR0_SIZE_OF_VF_BB_SHIFT                                                 0
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR0_64ENA_BB                                                          (0x1<<4) // This bit enables the advertisement of VF BAR0 as a 64-bit address. The value of this bit maps directly to bit 2 of VF BAR0. This value is sticky and only reset by HARD Reset. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR0_64ENA_BB_SHIFT                                                    4
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR0_PREFETCH_BB                                                       (0x1<<5) // This bit when set is reflected in bit 3 of VF BAR0 and indicates that the BAR is pre-fetchable. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR0_PREFETCH_BB_SHIFT                                                 5
  #define PCIEIP_REG_REG_VF_BAR_REG_UNUSED0_BB                                                               (0x3<<6) // 
  #define PCIEIP_REG_REG_VF_BAR_REG_UNUSED0_BB_SHIFT                                                         6
  #define PCIEIP_REG_REG_VF_BAR_REG_BAR2_SIZE_OF_VF_BB                                                       (0xf<<8) // This field influences the size of the VFs BAR register, advertized in the VF BAR2 register in the PCIE config space. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR_REG_BAR2_SIZE_OF_VF_BB_SHIFT                                                 8
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR2_64ENA_BB                                                          (0x1<<12) // This bit enables the advertisement of VF BAR2 as a 64-bit address. The value of this bit maps directly to bit 2 of VF BAR2. This value is sticky and only reset by HARD Reset. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR2_64ENA_BB_SHIFT                                                    12
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR2_PREFETCH_BB                                                       (0x1<<13) // This bit when set is reflected in bit 3 of VF BAR2 and indicates that the BAR is pre-fetchable. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR_REG_VFBAR2_PREFETCH_BB_SHIFT                                                 13
  #define PCIEIP_REG_REG_VF_BAR_REG_UNUSED1_BB                                                               (0x3<<14) // 
  #define PCIEIP_REG_REG_VF_BAR_REG_UNUSED1_BB_SHIFT                                                         14
  #define PCIEIP_REG_REG_VF_BAR_REG_SRIOV_CAP_VERSION_BB                                                     (0xf<<16) // Value programmed here is reflected in the corresponding bits in the SRIOV Capability Cfg register. This field is PCI_SIG defined version number that indicates version of capability structure present .
  #define PCIEIP_REG_REG_VF_BAR_REG_SRIOV_CAP_VERSION_BB_SHIFT                                               16
  #define PCIEIP_REG_REG_VF_BAR_REG_UNUSED2_BB                                                               (0xf<<20) // 
  #define PCIEIP_REG_REG_VF_BAR_REG_UNUSED2_BB_SHIFT                                                         20
  #define PCIEIP_REG_REG_VF_BAR_REG_FUNC_DEPENDENCY_LINK_BB                                                  (0xff<<24) // Value programmed here is reflected in the corresponding bits in the SRIOV Extended Capability Cfg register. This field is used to describe vendor specific dependencies between sets of functions.
  #define PCIEIP_REG_REG_VF_BAR_REG_FUNC_DEPENDENCY_LINK_BB_SHIFT                                            24
#define PCIEIP_REG_REG_VF_SUPP_PAGE_SIZE_BB                                                                  0x00060cUL //Access:RW   DataWidth:0x20   // Value programmed here is reflected in the corresponding bits in the SRIOV_SupportedPageSize Cfg register. This field indicates page sizes supported by the PF. PFs are required to support 4k, 8K, 64K, 256K, 1MB and 4MB page sizes. This PF supports a page size of 2^n+12 if bit n is set. For eg, if bit 0 is set, PF supports 4K page sizes.
#define PCIEIP_REG_REG_VF_CAP_EN_BB                                                                          0x000610UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_CAP_EN_VF_CAP_EN_BB                                                              (0x1<<0) // This value controls the read value of the next capability pointers in the VF configuration space and allows each extra capability to be independently disabled by manipulation of the next pointer values. The read values for each enable combination is shown below. PCIE capability is always enabled. Bit 0 enables the MSIX capability. This value is sticky and only reset by HARD Reset. Value affects only the VF's that belong to the PF.
  #define PCIEIP_REG_REG_VF_CAP_EN_VF_CAP_EN_BB_SHIFT                                                        0
  #define PCIEIP_REG_REG_VF_CAP_EN_UNUSED0_BB                                                                (0x7f<<1) // 
  #define PCIEIP_REG_REG_VF_CAP_EN_UNUSED0_BB_SHIFT                                                          1
  #define PCIEIP_REG_REG_VF_CAP_EN_VF_EXT_CAP_EN_BB                                                          (0x3f<<8) // Enable for the VF extended capability structures in the VF config space. Value programmed here only affects the VF cfg space belonging to the PF Default value of the link list is adv err, which has to be present always to allow extended config space to start at 0x100. Also ARI cap needs to always be present.
  #define PCIEIP_REG_REG_VF_CAP_EN_VF_EXT_CAP_EN_BB_SHIFT                                                    8
#define PCIEIP_REG_REG_VF_MSIX_TBL_BIR_OFF_BB                                                                0x000614UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_MSIX_TBL_BIR_OFF_VF_MSIX_TBL_BIR_BB                                              (0x7<<0) // This register controls the read value of the MSIX_TBL_OFF_BIR[2:0] register in the VF Cfg space. This indicates which one of the function's Base address registers located in SRIOV capability structure of PF configuration space is used to map the function's MSI-X table into memory space. All the VFs that belong to this PF use the same BIR value.
  #define PCIEIP_REG_REG_VF_MSIX_TBL_BIR_OFF_VF_MSIX_TBL_BIR_BB_SHIFT                                        0
  #define PCIEIP_REG_REG_VF_MSIX_TBL_BIR_OFF_VF_MSIX_TBL_BIR_OFF_BB                                          (0x1fffffff<<3) // This register controls the read value of the MSIX_TBL_OFF_BIR[31:3] register in the VF cfg space. This is used as an offset from the address contained by one of the functions Base address registers to point to the base of the MSI-X table . All the VF's that belong to this PF use the same offset value.
  #define PCIEIP_REG_REG_VF_MSIX_TBL_BIR_OFF_VF_MSIX_TBL_BIR_OFF_BB_SHIFT                                    3
#define PCIEIP_REG_REG_VF_MSIX_PBA_OFF_BIT_BB                                                                0x000618UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_MSIX_PBA_OFF_BIT_VF_MSIX_PBA_BIR_BB                                              (0x7<<0) // This register controls the read value of the MSIX_PBA_OFF_BIR[2:0] register in the VF Cfg space. This indicates which one of the function's Base address registers located in SRIOV capability structure in PF configuration space is used to map the VF's's MSI-X PBA into memory space. All the VF's that belong to the PF use the same BIT value. The value is controlled by IOV_MSIX_PBA_OFF define in version.v
  #define PCIEIP_REG_REG_VF_MSIX_PBA_OFF_BIT_VF_MSIX_PBA_BIR_BB_SHIFT                                        0
  #define PCIEIP_REG_REG_VF_MSIX_PBA_OFF_BIT_VF_MSIX_PBA_OFF_BB                                              (0x1fffffff<<3) // This register controls the read value of the MSIX_PBA_OFF_BIR[31:3] registern the VF Cfg space. This is used as an offset from the address contained by one of the functions Base address registers to point to the base of the MSI-X PBA
  #define PCIEIP_REG_REG_VF_MSIX_PBA_OFF_BIT_VF_MSIX_PBA_OFF_BB_SHIFT                                        3
#define PCIEIP_REG_REG_VF_MSIX_CONTROL_BB                                                                    0x00061cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_MSIX_CONTROL_VF_MSIX_TBL_SIZ_BB                                                  (0x3f<<0) // This field resides in VF only and does not exist in PF. This register controls the read value of the MSIX_CONTROL[10:0] register in the VF configuration space. A value of "00000000011" indicates a table size of 4. The value is controlled by IOV_MSIX_TBL_SIZ define in version.v
  #define PCIEIP_REG_REG_VF_MSIX_CONTROL_VF_MSIX_TBL_SIZ_BB_SHIFT                                            0
  #define PCIEIP_REG_REG_VF_MSIX_CONTROL_RESERVEDVF_0_BB                                                     (0x3ffffff<<6) // 
  #define PCIEIP_REG_REG_VF_MSIX_CONTROL_RESERVEDVF_0_BB_SHIFT                                               6
#define PCIEIP_REG_REG_VF_BAR4_REG_BB                                                                        0x000620UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_BAR4_REG_BAR4_SIZE_OF_VF_BB                                                      (0xf<<0) // This field influences the size of the VFs BAR register, advertized in the VF BAR4 register in the PCIE config space. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR4_REG_BAR4_SIZE_OF_VF_BB_SHIFT                                                0
  #define PCIEIP_REG_REG_VF_BAR4_REG_VFBAR4_64ENA_BB                                                         (0x1<<4) // This bit enables the advertisement of VF BAR4 as a 64-bit address. The value of this bit maps directly to bit 2 of VF BAR4. This value is sticky and only reset by HARD Reset. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR4_REG_VFBAR4_64ENA_BB_SHIFT                                                   4
  #define PCIEIP_REG_REG_VF_BAR4_REG_VFBAR4_PREFETCH_BB                                                      (0x1<<5) // This bit when set is reflected in bit 3 of VF BAR4 and indicates that the BAR is pre-fetchable. This register is only applicable for EP.
  #define PCIEIP_REG_REG_VF_BAR4_REG_VFBAR4_PREFETCH_BB_SHIFT                                                5
#define PCIEIP_REG_REG_PF_INITVF_BB                                                                          0x000624UL //Access:RW   DataWidth:0x20   // Register programs the first VF allocation for a PF. All the VFs within IP are assumed to reside in a contiguous space starting at VFNUM =0. This register identifies the first VFNUM location for a PF. This register exists only in a PF
  #define PCIEIP_REG_REG_PF_INITVF_PF_FIRST_VF_NUM_BB                                                        (0x1f<<0) // First VF_NUM for PF is encoded in this register. The number of VFs assigned to a PF is assumed to be a multiple of 8. Software should program these bits based on Total Number of VFs programmed for each PF.
  #define PCIEIP_REG_REG_PF_INITVF_PF_FIRST_VF_NUM_BB_SHIFT                                                  0
#define PCIEIP_REG_REG_VF_NSP_BB                                                                             0x000628UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VF_NSP_PF_VFBAR0_NSP_BB                                                             (0xf<<0) // This field describes the number of System pages needed by VF BAR0 belonging to PF. User Page Size(UPS) is determined by UABS &gt;&gt; NSP, where UABS is the User Advertized Bar Size and NSP is this field. BAR Size advertized is changed if SPS &gt; UPS, where SPS is System Page Size. Programming should ensure that resulting BAR size will not be bigger than 2G, so value of this field should be kept small if SPS is large.
  #define PCIEIP_REG_REG_VF_NSP_PF_VFBAR0_NSP_BB_SHIFT                                                       0
  #define PCIEIP_REG_REG_VF_NSP_PF_VFBAR2_NSP_BB                                                             (0xf<<4) // This field describes the number of System pages needed by VF BAR2 belonging to PF. User Page Size(UPS) is determined by UABS &gt;&gt; NSP, where UABS is the User Advertized Bar Size and NSP is this field. BAR Size advertized is changed if SPS &gt; UPS, where SPS is System Page Size. Programming should ensure that resulting BAR size will not be bigger than 2G, so value of this field should be kept small if SPS is large.
  #define PCIEIP_REG_REG_VF_NSP_PF_VFBAR2_NSP_BB_SHIFT                                                       4
  #define PCIEIP_REG_REG_VF_NSP_PF_VFBAR4_NSP_BB                                                             (0xf<<8) // This field describes the number of System pages needed by VF BAR4 belonging to PF. User Page Size(UPS) is determined by UABS &gt;&gt; NSP, where UABS is the User Advertized Bar Size and NSP is this field. BAR Size advertized is changed if SPS &gt; UPS, where SPS is System Page Size. Programming should ensure that resulting BAR size will not be bigger than 2G, so value of this field should be kept small if SPS is large.
  #define PCIEIP_REG_REG_VF_NSP_PF_VFBAR4_NSP_BB_SHIFT                                                       8
#define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_BB                                                               0x000630UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_ATS_INVLD_QDEPTH_BB                                            (0x1f<<0) // This register controls the corresponding value in the ATS capability register. This field advertizes the number of Invalidate requests the Function can accept before putting backpressure on the upstream connection.
  #define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_ATS_INVLD_QDEPTH_BB_SHIFT                                      0
  #define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_ATS_PAGE_ALIGNED_REQ_BB                                        (0x1<<5) // This register controls the corresponding value in the ATS capability register. This field qhen Set, indicates the Untranslated Address always aligns to a 4K byte boundary. Setting this bit is recommended.
  #define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_ATS_PAGE_ALIGNED_REQ_BB_SHIFT                                  5
  #define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_RESERVEDVF_0_BB                                                (0x3ffffff<<6) // 
  #define PCIEIP_REG_REG_ATS_INLD_QUEUE_DEPTH_RESERVEDVF_0_BB_SHIFT                                          6
#define PCIEIP_REG_REG_VFTPH_CAP_BB                                                                          0x000634UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_INT_VEC_MODE_SUPP_BB                                                (0x1<<0) // when Set, it indicates function supports Interrupt vector mode of op. Value programmed here is reflected in the corresponding bits in the TPH CAP register.
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_INT_VEC_MODE_SUPP_BB_SHIFT                                          0
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_DEV_SPEC_MODE_BB                                                    (0x1<<1) // When Set, it indicates function suports device specific mode of operation. Value programmed here is reflected in the corresponding bits in the TPH CAP register.
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_DEV_SPEC_MODE_BB_SHIFT                                              1
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_ST_TABLE_LOCATION_BB                                                (0x3<<2) // The IP supports only a value of 0, which would indicate ST Table is not present, or a value of 2, which indicates ST table is located in MSI-X Table structure. All other values should not be programmed. The value programmed here is reflected in the corresponding field of the PCIE defined TPH Capability register in VF.
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_ST_TABLE_LOCATION_BB_SHIFT                                          2
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_ST_TABLE_SIZE_BB                                                    (0x7ff<<4) // This field will be reflected in the ST Table Size field of the PCIE defined TPH capability register in the VF. The value programmed here indicates a table size of value + 1.
  #define PCIEIP_REG_REG_VFTPH_CAP_VFTPH_ST_TABLE_SIZE_BB_SHIFT                                              4
  #define PCIEIP_REG_REG_VFTPH_CAP_UNUSED0_BB                                                                (0xffff<<15) // 
  #define PCIEIP_REG_REG_VFTPH_CAP_UNUSED0_BB_SHIFT                                                          15
  #define PCIEIP_REG_REG_VFTPH_CAP_TPH_SUPP_INVF_BB                                                          (0x1<<31) // This field when set enables TPH capability in all the VF's.
  #define PCIEIP_REG_REG_VFTPH_CAP_TPH_SUPP_INVF_BB_SHIFT                                                    31
#define PCIEIP_REG_ACK_LATENCY_TIMER_OFF_K2_E5                                                               0x000700UL //Access:RW   DataWidth:0x20   // Ack Latency Timer and Replay Timer Register.
  #define PCIEIP_REG_ACK_LATENCY_TIMER_OFF_ROUND_TRIP_LATENCY_TIME_LIMIT_K2_E5                               (0xffff<<0) // Ack Latency Timer Limit. The Ack latency timer expires when it reaches this limit. For more details, see "Ack Scheduling". You can modify the effective timer limit with the TIMER_MOD_ACK_NAK field of the TIMER_CTRL_MAX_FUNC_NUM_OFF register. After reset, the core updates the default according to the Negotiated Link Width, Max_Payload_Size, and speed. The value is determined from Tables 3-7, 3-8, and 3-9 of the PCIe 3.0 specification. The limit must reflect the round trip latency from requester to completer. If there is a change in the payload size or link width, the core will override any value that you have written to this register field, and reset the field back to the specification-defined value. It will not change the value in the TIMER_MOD_ACK_NAK field of the TIMER_CTRL_MAX_FUNC_NUM_OFF register.
  #define PCIEIP_REG_ACK_LATENCY_TIMER_OFF_ROUND_TRIP_LATENCY_TIME_LIMIT_K2_E5_SHIFT                         0
  #define PCIEIP_REG_ACK_LATENCY_TIMER_OFF_REPLAY_TIME_LIMIT_K2_E5                                           (0xffff<<16) // Replay Timer Limit. The replay timer expires when it reaches this limit. The core initiates a replay upon reception of a NAK or when the replay timer expires. For more details, see "Transmit Replay". You can modify the effective timer limit with the TIMER_MOD_REPLAY_TIMER field of the TIMER_CTRL_MAX_FUNC_NUM_OFF register. After reset, the core updates the default according to the Negotiated Link Width, Max_Payload_Size, and speed. The value is determined from Tables 3-4, 3-5, and 3-6 of the PCIe 3.0 specification. If there is a change in the payload size or link speed, the core will override any value that you have written to this register field, and reset the field back to the specification-defined value. It will not change the value in the TIMER_MOD_REPLAY_TIMER field of the TIMER_CTRL_MAX_FUNC_NUM_OFF register.
  #define PCIEIP_REG_ACK_LATENCY_TIMER_OFF_REPLAY_TIME_LIMIT_K2_E5_SHIFT                                     16
#define PCIEIP_REG_VENDOR_SPEC_DLLP_OFF_K2_E5                                                                0x000704UL //Access:RW   DataWidth:0x20   // Vendor Specific DLLP Register.
#define PCIEIP_REG_PORT_FORCE_OFF_K2_E5                                                                      0x000708UL //Access:RW   DataWidth:0x20   // Port Force Link Register.
  #define PCIEIP_REG_PORT_FORCE_OFF_LINK_NUM_K2_E5                                                           (0xff<<0) // Link Number. Not used for endpoint. Not used for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_FORCE_OFF_LINK_NUM_K2_E5_SHIFT                                                     0
  #define PCIEIP_REG_PORT_FORCE_OFF_FORCED_LTSSM_K2_E5                                                       (0xf<<8) // Forced Link Command. The link command that the core is forced to transmit when you set FORCE_EN bit (Force Link). Link command encoding is defined by the ltssm_cmd variable in workspace/src/Layer1/smlh_ltssm.v.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_FORCE_OFF_FORCED_LTSSM_K2_E5_SHIFT                                                 8
  #define PCIEIP_REG_PORT_FORCE_OFF_FORCE_EN_K2_E5                                                           (0x1<<15) // Force Link. The core supports a testing and debug capability to allow your software to force the LTSSM state machine into a specific state, and to force the core to transmit a specific Link Command. Asserting this bit triggers the following actions:  - Forces the LTSSM to the state specified by the Forced LTSSM State field.  - Forces the core to transmit the command specified by the Forced Link Command field. This is a self-clearing register field. Reading from this register field always returns a "0".
  #define PCIEIP_REG_PORT_FORCE_OFF_FORCE_EN_K2_E5_SHIFT                                                     15
  #define PCIEIP_REG_PORT_FORCE_OFF_LINK_STATE_K2_E5                                                         (0x3f<<16) // Forced LTSSM State. The LTSSM state that the core is forced to when you set the FORCE_EN bit (Force Link). LTSSM state encoding is defined by the lts_state variable in workspace/src/Layer1/smlh_ltssm.v.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_FORCE_OFF_LINK_STATE_K2_E5_SHIFT                                                   16
  #define PCIEIP_REG_PORT_FORCE_OFF_CPL_SENT_COUNT_K2_E5                                                     (0xff<<24) // Low Power Entrance Count. The Power Management state waits for this many clock cycles for the associated completion of a CfgWr to D-state register to go low-power. This register is intended for applications that do not let the core handle a completion for configuration request to the PMCSCR register. Not used in downstream ports.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_FORCE_OFF_CPL_SENT_COUNT_K2_E5_SHIFT                                               24
#define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_K2_E5                                                                 0x00070cUL //Access:RW   DataWidth:0x20   // Ack Frequency and L0-L1 ASPM Control Register.
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_ACK_FREQ_K2_E5                                                      (0xff<<0) // Ack Frequency. The core accumulates the number of pending ACKs specified here (up to 255) before sending an ACK DLLP.  - 0: Indicates that this Ack frequency control feature is turned off. The core schedules a low-priority ACK DLLP for every TLP that it receives.  - 1-255: Indicates that the core will schedule a high-priority ACK after receiving this number of TLPs. It might schedule the ACK before receiving this number of TLPs, but never later. For a typical system, you do not have to modify the default setting. For more details, see "ACK/NAK Scheduling".  Note: This register field is sticky.
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_ACK_FREQ_K2_E5_SHIFT                                                0
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_ACK_N_FTS_K2_E5                                                     (0xff<<8) // N_FTS. The number of Fast Training Sequence ordered sets to be transmitted when transitioning from L0s to L0. The maximum number of FTS ordered-sets that a component can request is 255. The core does not support a value of zero; a value of zero can cause the LTSSM to go into the recovery state when exiting from L0s. This field is reserved (fixed to '0') for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_ACK_N_FTS_K2_E5_SHIFT                                               8
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_COMMON_CLK_N_FTS_K2_E5                                              (0xff<<16) // Common Clock N_FTS. This is the N_FTS when common clock is used. The number of Fast Training Sequence ordered sets to be transmitted when transitioning from L0s to L0. The maximum number of FTS ordered-sets that a component can request is 255. This field is only writable (sticky) when all of the following configuration parameter equations are true:  - CX_NFTS !=CX_COMM_NFTS  - DEFAULT_L0S_EXIT_LATENCY !=DEFAULT_COMM_L0S_EXIT_LATENCY  - DEFAULT_L1_EXIT_LATENCY !=DEFAULT_COMM_L1_EXIT_LATENCY The core does not support a value of zero; a value of zero can cause the LTSSM to go into the recovery state when exiting from L0s. This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_COMMON_CLK_N_FTS_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_L0S_ENTRANCE_LATENCY_K2_E5                                          (0x7<<24) // L0s Entrance Latency. Values correspond to:  - 000: 1 us  - 001: 2 us  - 010: 3 us  - 011: 4 us  - 100: 5 us  - 101: 6 us  - 110 or 111: 7 us This field is applicable to STALL while in L0 for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_L0S_ENTRANCE_LATENCY_K2_E5_SHIFT                                    24
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_L1_ENTRANCE_LATENCY_K2_E5                                           (0x7<<27) // L1 Entrance Latency. Value range is:  - 000: 1 us  - 001: 2 us  - 010: 4 us  - 011: 8 us  - 100: 16 us  - 101: 32 us  - 110 or 111: 64 us Note: Programming this timer with a value greater that 32us has no effect unless extended sync is used, or all of the credits are infinite.  Note: This register field is sticky.
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_L1_ENTRANCE_LATENCY_K2_E5_SHIFT                                     27
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_ENTER_ASPM_K2_E5                                                    (0x1<<30) // ASPM L1 Entry Control.  - 1: Core enters ASPM L1 after a period in which it has been idle.  - 0: Core enters ASPM L1 only after idle period during which both receive and transmit are in L0s. Note: This register field is sticky.
  #define PCIEIP_REG_ACK_F_ASPM_CTRL_OFF_ENTER_ASPM_K2_E5_SHIFT                                              30
#define PCIEIP_REG_PORT_LINK_CTRL_OFF_K2_E5                                                                  0x000710UL //Access:RW   DataWidth:0x20   // Port Link Control Register.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_VENDOR_SPECIFIC_DLLP_REQ_K2_E5                                       (0x1<<0) // Vendor Specific DLLP Request. When software writes a '1' to this bit, the core transmits the DLLP contained in the VENDOR_SPEC_DLLP field of VENDOR_SPEC_DLLP_OFF.  Reading from this self-clearing register field always returns a '0'.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_VENDOR_SPECIFIC_DLLP_REQ_K2_E5_SHIFT                                 0
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_SCRAMBLE_DISABLE_K2_E5                                               (0x1<<1) // Scramble Disable. Turns off data scrambling.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_SCRAMBLE_DISABLE_K2_E5_SHIFT                                         1
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LOOPBACK_ENABLE_K2_E5                                                (0x1<<2) // Loopback Enable. Turns on loopback. For more details, see "Loopback". For M-PCIe, to force the master to enter Digital Loopback mode, you must set this field to "1" during Configuration.start state(initial discovery/configuration). M-PCIe doesn't support loopback mode from L0 state - only from Configuration.start.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LOOPBACK_ENABLE_K2_E5_SHIFT                                          2
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_RESET_ASSERT_K2_E5                                                   (0x1<<3) // Reset Assert. Triggers a recovery and forces the LTSSM to the hot reset state (downstream port only).  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_RESET_ASSERT_K2_E5_SHIFT                                             3
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_DLL_LINK_EN_K2_E5                                                    (0x1<<5) // DLL Link Enable. Enables link initialization. When DLL Link Enable =0, the core does not transmit InitFC DLLPs and does not establish a link.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_DLL_LINK_EN_K2_E5_SHIFT                                              5
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LINK_DISABLE_K2_E5                                                   (0x1<<6) // LINK_DISABLE is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LINK_DISABLE_K2_E5_SHIFT                                             6
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_FAST_LINK_MODE_K2_E5                                                 (0x1<<7) // Fast Link Mode. Sets all internal timers to Fast Mode for speeding up simulation. Forces the LTSSM training (link initialization) to use shorter time-outs and to link up faster. The scaling factor is selected in FAST_LINK_SCALING_FACTOR(default : 1024) for all internal timers. Fast Link Mode can also be activated by setting the diag_ctrl_bus[2] pin to "1". For more details, see "SII Signals: Diagnostic Control". For M-PCIe, this field also affects Remain Hibern8 Time, Minimum Activate Time, and RRAP timeout. If this bit is set to '1', tRRAPInitiatorResponse is set to 1.88 ms(60 ms/32).  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_FAST_LINK_MODE_K2_E5_SHIFT                                           7
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LINK_RATE_K2_E5                                                      (0xf<<8) // LINK_RATE is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LINK_RATE_K2_E5_SHIFT                                                8
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LINK_CAPABLE_K2_E5                                                   (0x3f<<16) // Link Mode Enable. Sets the number of lanes in the link that you want to connect to the link partner. When you have unused lanes in your system, then you must change the value in this register to reflect the number of lanes. You must also change the value in the "Predetermined Number of Lanes" field of the "Link Width and Speed Change Control Register". For more information, see "How to Tie Off Unused Lanes". For information on upsizing and downsizing the link width, see "Link Establishment".  - 000001: x1  - 000011: x2  - 000111: x4  - 001111: x8  - 011111: x16  - 111111: x32 (not supported) This field is reserved (fixed to '0') for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_LINK_CAPABLE_K2_E5_SHIFT                                             16
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_BEACON_ENABLE_K2_E5                                                  (0x1<<24) // BEACON_ENABLE is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_BEACON_ENABLE_K2_E5_SHIFT                                            24
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_CORRUPT_LCRC_ENABLE_K2_E5                                            (0x1<<25) // CORRUPT_LCRC_ENABLE is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_CORRUPT_LCRC_ENABLE_K2_E5_SHIFT                                      25
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_EXTENDED_SYNCH_K2_E5                                                 (0x1<<26) // EXTENDED_SYNCH is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_EXTENDED_SYNCH_K2_E5_SHIFT                                           26
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_TRANSMIT_LANE_REVERSALE_ENABLE_K2_E5                                 (0x1<<27) // TRANSMIT_LANE_REVERSALE_ENABLE is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PORT_LINK_CTRL_OFF_TRANSMIT_LANE_REVERSALE_ENABLE_K2_E5_SHIFT                           27
#define PCIEIP_REG_LANE_SKEW_OFF_K2_E5                                                                       0x000714UL //Access:RW   DataWidth:0x20   // Lane Skew Register.
  #define PCIEIP_REG_LANE_SKEW_OFF_INSERT_LANE_SKEW_K2_E5                                                    (0xffffff<<0) // Insert Lane Skew for Transmit (not supported for x16). Optional feature that causes the core to insert skew between Lanes for test purposes. There are three bits per Lane. The value is in units of one symbol time. For example, the value 010b for a Lane forces a skew of two symbol times for that Lane. The maximum skew value for any Lane is 5 symbol times.  Note: This register field is sticky.
  #define PCIEIP_REG_LANE_SKEW_OFF_INSERT_LANE_SKEW_K2_E5_SHIFT                                              0
  #define PCIEIP_REG_LANE_SKEW_OFF_FLOW_CTRL_DISABLE_K2_E5                                                   (0x1<<24) // Flow Control Disable. Prevents the core from sending FC DLLPs.  Note: This register field is sticky.
  #define PCIEIP_REG_LANE_SKEW_OFF_FLOW_CTRL_DISABLE_K2_E5_SHIFT                                             24
  #define PCIEIP_REG_LANE_SKEW_OFF_ACK_NAK_DISABLE_K2_E5                                                     (0x1<<25) // Ack/Nak Disable. Prevents the core from sending ACK and NAK DLLPs.  Note: This register field is sticky.
  #define PCIEIP_REG_LANE_SKEW_OFF_ACK_NAK_DISABLE_K2_E5_SHIFT                                               25
  #define PCIEIP_REG_LANE_SKEW_OFF_DISABLE_LANE_TO_LANE_DESKEW_K2_E5                                         (0x1<<31) // Disable Lane-to-Lane Deskew. Causes the core to disable the internal Lane-to-Lane deskew logic.  Note: This register field is sticky.
  #define PCIEIP_REG_LANE_SKEW_OFF_DISABLE_LANE_TO_LANE_DESKEW_K2_E5_SHIFT                                   31
#define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_K2_E5                                                         0x000718UL //Access:RW   DataWidth:0x20   // Timer Control and Max Function Number Register.
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_MAX_FUNC_NUM_K2_E5                                          (0xff<<0) // Maximum function number that can be used in a request. Configuration requests targeted at function numbers above this value are returned with UR (unsupported request).  Note: This register field is sticky.
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_MAX_FUNC_NUM_K2_E5_SHIFT                                    0
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_TIMER_MOD_REPLAY_TIMER_K2_E5                                (0x1f<<14) // Replay Timer Limit Modifier. Increases the time-out value for the replay timer in increments of 64 clock cycles at Gen1 or Gen2 speed, and in increments of 256 clock cycles at Gen3 speed. A value of "0" represents no modification to the timer limit. For more details, see the REPLAY_TIME_LIMIT field of the ACK_LATENCY_TIMER_OFF register. At Gen3 speed, the core automatically changes the value of this field to DEFAULT_GEN3_REPLAY_ADJ. For M-PCIe, this field increases the time-out value for the replay timer in increments of 64 clock cycles at HS-Gear1, HS-Gear2, or HS-Gear3 speed.  Note: This register field is sticky.
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_TIMER_MOD_REPLAY_TIMER_K2_E5_SHIFT                          14
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_TIMER_MOD_ACK_NAK_K2_E5                                     (0x1f<<19) // Ack Latency Timer Modifier. Increases the timer value for the Ack latency timer in increments of 64 clock cycles. A value of "0" represents no modification to the timer value. For more details, see the ROUND_TRIP_LATENCY_TIME_LIMIT field of the ACK_LATENCY_TIMER_OFF register.  Note: This register field is sticky.
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_TIMER_MOD_ACK_NAK_K2_E5_SHIFT                               19
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_UPDATE_FREQ_TIMER_K2_E5                                     (0x1f<<24) // UPDATE_FREQ_TIMER is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_UPDATE_FREQ_TIMER_K2_E5_SHIFT                               24
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_FAST_LINK_SCALING_FACTOR_K2_E5                              (0x3<<29) // Fast Link Timer Scaling Factor. Sets the scaling factor of LTSSM timer when FAST_LINK_MODE is set to 1b.  - 0: Scaling Factor is 1024 (1ms is 1us)  - 1: Scaling Factor is 256 (1ms is 4us)  - 2: Scaling Factor is 64 (1ms is 16us)  - 3: Scaling Factor is 16 (1ms is 64us) Not used for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_TIMER_CTRL_MAX_FUNC_NUM_OFF_FAST_LINK_SCALING_FACTOR_K2_E5_SHIFT                        29
#define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_K2_E5                                                           0x00071cUL //Access:RW   DataWidth:0x20   // Symbol Timer Register and Filter Mask 1 Register. The Filter Mask 1 Register modifies the RADM filtering and error handling rules. For more details, see the "Receive Filtering" section. In each case, '0' applies the associated filtering rule and '1' masks the associated filtering rule.
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_SKP_INT_VAL_K2_E5                                             (0x7ff<<0) // SKP Interval Value. The number of symbol times to wait between transmitting SKP ordered sets. Note that the core actually waits the number of symbol times in this register plus 1 between transmitting SKP ordered sets. Your application must program this register accordingly. For example, if 1536 were programmed into this register (in a 250 MHz core), then the core actually transmits SKP ordered sets once every 1537 symbol times. The value programmed to this register is actually clock ticks and not symbol times. In a 125 MHz core, programming the value programmed to this register should be scaled down by a factor of 2 (because one clock tick = two symbol times in this case).  Note: This value is not used at Gen3 speed; the skip interval is hardcoded to 370 blocks.  Note: This register field is sticky.
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_SKP_INT_VAL_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_EIDLE_TIMER_K2_E5                                             (0xf<<11) // EIDLE_TIMER is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_EIDLE_TIMER_K2_E5_SHIFT                                       11
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_DISABLE_FC_WD_TIMER_K2_E5                                     (0x1<<15) // Disable FC Watchdog Timer.  Note: This register field is sticky.
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_DISABLE_FC_WD_TIMER_K2_E5_SHIFT                               15
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_MASK_RADM_1_K2_E5                                             (0xffff<<16) // Filter Mask 1. The Filter Mask 1 Register modifies the RADM filtering and error handling rules. For more details, see the "Receive Filtering" section. In each case, '0' applies the associated filtering rule and '1' masks the associated filtering rule.  [31]: CX_FLT_MASK_RC_CFG_DISCARD  - 0: For RADM RC filter to not allow CFG transaction being received  - 1: For RADM RC filter to allow CFG transaction being received [30]: CX_FLT_MASK_RC_IO_DISCARD  - 0: For RADM RC filter to not allow IO transaction being received  - 1: For RADM RC filter to allow IO transaction being received [29]: CX_FLT_MASK_MSG_DROP  - 0: Drop MSG TLP (except for Vendor MSG). Send decoded message on the SII.  - 1: Do not Drop MSG (except for Vendor MSG). Send message TLPs to your application on TRGT1 and send decoded message on the SII.  - The default for this bit is the inverse of FLT_DROP_MSG. That is, if FLT_DROP_MSG =1, then the default of this bit is "0" (drop message TLPs). This bit only controls message TLPs other than Vendor MSGs. Vendor MSGs are controlled by Filter Mask Register 2, bits [1:0].  The core never passes ATS Invalidate messages to the SII interface regardless of this filter rule setting. The core passes all ATS Invalidate messages to TRGT1 (or AXI bridge master), as they are too big for the SII. [28]: CX_FLT_MASK_CPL_ECRC_DISCARD  - Only used when completion queue is advertised with infinite credits and is in store-and-forward mode.  - 0: Discard completions with ECRC errors  - 1: Allow completions with ECRC errors to be passed up  - Reserved field for SW. [27]: CX_FLT_MASK_ECRC_DISCARD  - 0: Discard TLPs with ECRC errors  - 1: Allow TLPs with ECRC errors to be passed up [26]: CX_FLT_MASK_CPL_LEN_MATCH  - 0: Enforce length match for completions; a violation results in cpl_abort, and possibly AER of unexp_cpl_err  - 1: MASK length match for completions [25]: CX_FLT_MASK_CPL_ATTR_MATCH  - 0: Enforce attribute match for completions; a violation results in a malformed TLP error, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca  - 1: Mask attribute match for completions [24]: CX_FLT_MASK_CPL_TC_MATCH  - 0: Enforce Traffic Class match for completions; a violation results in a malformed TLP error, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca  - 1: Mask Traffic Class match for completions [23]: CX_FLT_MASK_CPL_FUNC_MATCH  - 0: Enforce function match for completions; a violation results in cpl_abort, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca  - 1: Mask function match for completions [22]: CX_FLT_MASK_CPL_REQID_MATCH  - 0: Enforce Req. Id match for completions; a violation result in cpl_abort, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca  - 1: Mask Req. Id match for completions [21]: CX_FLT_MASK_CPL_TAGERR_MATCH  - 0: Enforce Tag Error Rules for completions; a violation result in cpl_abort, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca  - 1: Mask Tag Error Rules for completions [20]: CX_FLT_MASK_LOCKED_RD_AS_UR  - 0: Treat locked Read TLPs as UR for EP; Supported for RC  - 1: Treat locked Read TLPs as Supported for EP; UR for RC [19]: CX_FLT_MASK_CFG_TYPE1_RE_AS_UR  - 0: Treat CFG type1 TLPs as UR for EP; Supported for RC  - 1: Treat CFG type1 TLPs as Supported for EP; UR for RC  - When CX_SRIOV_ENABLE is set then this bit is set to allow the filter to process Type 1 Config requests if the EP consumes more than one bus number. [18]: CX_FLT_MASK_UR_OUTSIDE_BAR  - 0: Treat out-of-bar TLPs as UR  - 1: Do not treat out-of-bar TLPs as UR [17]: CX_FLT_MASK_UR_POIS  - 0: Treat poisoned request TLPs as UR  - 1: Do not treat poisoned request TLPs as UR  - The native core always passes poisoned completions to your application except when you are using the DMA read channel. [16]: CX_FLT_MASK_UR_FUNC_MISMATCH  - 0: Treat Function MisMatched TLPs as UR  - 1: Do not treat Function MisMatched TLPs as UR Note: This register field is sticky.
  #define PCIEIP_REG_SYMBOL_TIMER_FILTER_1_OFF_MASK_RADM_1_K2_E5_SHIFT                                       16
#define PCIEIP_REG_FILTER_MASK_2_OFF_K2_E5                                                                   0x000720UL //Access:RW   DataWidth:0x20   // Filter Mask 2 Register. This register modifies the RADM filtering and error handling rules. For more details, see the "Receive Filtering" section. In each case, '0' applies the associated filtering rule and '1' masks the associated filtering rule.
#define PCIEIP_REG_PL_DEBUG0_OFF_K2_E5                                                                       0x000728UL //Access:R    DataWidth:0x20   // Debug Register 0
#define PCIEIP_REG_PL_DEBUG1_OFF_K2_E5                                                                       0x00072cUL //Access:R    DataWidth:0x20   // Debug Register 1
#define PCIEIP_REG_TX_P_FC_CREDIT_STATUS_OFF_K2_E5                                                           0x000730UL //Access:R    DataWidth:0x20   // Transmit Posted FC Credit Status
  #define PCIEIP_REG_TX_P_FC_CREDIT_STATUS_OFF_TX_P_DATA_FC_CREDIT_K2_E5                                     (0xfff<<0) // Transmit Posted Data FC Credits. The posted Data credits advertised by the receiver at the other end of the link, updated with each UpdateFC DLLP. Default value depends on the number of advertised credits for header and data [12'b0, xtlh_xadm_ph_cdts, xtlh_xadm_pd_cdts]; When the number of advertised completion credits (both header and data) are infinite, then the default would be [12'b0, 8'hFF, 12'hFFF].
  #define PCIEIP_REG_TX_P_FC_CREDIT_STATUS_OFF_TX_P_DATA_FC_CREDIT_K2_E5_SHIFT                               0
  #define PCIEIP_REG_TX_P_FC_CREDIT_STATUS_OFF_TX_P_HEADER_FC_CREDIT_K2_E5                                   (0xff<<12) // Transmit Posted Header FC Credits. The posted Header credits advertised by the receiver at the other end of the link, updated with each UpdateFC DLLP. Default value depends on the number of advertised credits for header and data [12'b0, xtlh_xadm_ph_cdts, xtlh_xadm_pd_cdts]; When the number of advertised completion credits (both header and data) are infinite, then the default would be [12'b0, 8'hFF, 12'hFFF].
  #define PCIEIP_REG_TX_P_FC_CREDIT_STATUS_OFF_TX_P_HEADER_FC_CREDIT_K2_E5_SHIFT                             12
#define PCIEIP_REG_TX_NP_FC_CREDIT_STATUS_OFF_K2_E5                                                          0x000734UL //Access:R    DataWidth:0x20   // Transmit Non-Posted FC Credit Status
  #define PCIEIP_REG_TX_NP_FC_CREDIT_STATUS_OFF_TX_NP_DATA_FC_CREDIT_K2_E5                                   (0xfff<<0) // Transmit Non-Posted Data FC Credits. The non-posted Data credits advertised by the receiver at the other end of the link, updated with each UpdateFC DLLP. Default value depends on the number of advertised credits for header and data [12'b0, xtlh_xadm_nph_cdts, xtlh_xadm_npd_cdts]; When the number of advertised completion credits (both header and data) are infinite, then the default would be [12'b0, 8'hFF, 12'hFFF].
  #define PCIEIP_REG_TX_NP_FC_CREDIT_STATUS_OFF_TX_NP_DATA_FC_CREDIT_K2_E5_SHIFT                             0
  #define PCIEIP_REG_TX_NP_FC_CREDIT_STATUS_OFF_TX_NP_HEADER_FC_CREDIT_K2_E5                                 (0xff<<12) // Transmit Non-Posted Header FC Credits. The non-posted Header credits advertised by the receiver at the other end of the link, updated with each UpdateFC DLLP. Default value depends on the number of advertised credits for header and data [12'b0, xtlh_xadm_nph_cdts, xtlh_xadm_npd_cdts]; When the number of advertised completion credits (both header and data) are infinite, then the default would be [12'b0, 8'hFF, 12'hFFF].
  #define PCIEIP_REG_TX_NP_FC_CREDIT_STATUS_OFF_TX_NP_HEADER_FC_CREDIT_K2_E5_SHIFT                           12
#define PCIEIP_REG_TX_CPL_FC_CREDIT_STATUS_OFF_K2_E5                                                         0x000738UL //Access:R    DataWidth:0x20   // Transmit Completion FC Credit Status
  #define PCIEIP_REG_TX_CPL_FC_CREDIT_STATUS_OFF_TX_CPL_DATA_FC_CREDIT_K2_E5                                 (0xfff<<0) // Transmit Completion Data FC Credits. The Completion Data credits advertised by the receiver at the other end of the link, updated with each UpdateFC DLLP. Default value depends on the number of advertised credits for header and data [12'b0, xtlh_xadm_cplh_cdts, xtlh_xadm_cpld_cdts]; When the number of advertised completion credits (both header and data) are infinite, then the default would be [12'b0, 8'hFF, 12'hFFF].
  #define PCIEIP_REG_TX_CPL_FC_CREDIT_STATUS_OFF_TX_CPL_DATA_FC_CREDIT_K2_E5_SHIFT                           0
  #define PCIEIP_REG_TX_CPL_FC_CREDIT_STATUS_OFF_TX_CPL_HEADER_FC_CREDIT_K2_E5                               (0xff<<12) // Transmit Completion Header FC Credits. The Completion Header credits advertised by the receiver at the other end of the link, updated with each UpdateFC DLLP. Default value depends on the number of advertised credits for header and data [12'b0, xtlh_xadm_cplh_cdts, xtlh_xadm_cpld_cdts]; When the number of advertised completion credits (both header and data) are infinite, then the default would be [12'b0, 8'hFF, 12'hFFF].
  #define PCIEIP_REG_TX_CPL_FC_CREDIT_STATUS_OFF_TX_CPL_HEADER_FC_CREDIT_K2_E5_SHIFT                         12
#define PCIEIP_REG_QUEUE_STATUS_OFF_K2_E5                                                                    0x00073cUL //Access:RW   DataWidth:0x20   // Queue Status
  #define PCIEIP_REG_QUEUE_STATUS_OFF_RX_TLP_FC_CREDIT_NON_RETURN_K2_E5                                      (0x1<<0) // Received TLP FC Credits Not Returned. Indicates that the core has sent a TLP but has not yet received an UpdateFC DLLP indicating that the credits for that TLP have been restored by the receiver at the other end of the link.
  #define PCIEIP_REG_QUEUE_STATUS_OFF_RX_TLP_FC_CREDIT_NON_RETURN_K2_E5_SHIFT                                0
  #define PCIEIP_REG_QUEUE_STATUS_OFF_TX_RETRY_BUFFER_NE_K2_E5                                               (0x1<<1) // Transmit Retry Buffer Not Empty. Indicates that there is data in the transmit retry buffer.
  #define PCIEIP_REG_QUEUE_STATUS_OFF_TX_RETRY_BUFFER_NE_K2_E5_SHIFT                                         1
  #define PCIEIP_REG_QUEUE_STATUS_OFF_RX_QUEUE_NON_EMPTY_K2_E5                                               (0x1<<2) // Received Queue Not Empty. Indicates there is data in one or more of the receive buffers.
  #define PCIEIP_REG_QUEUE_STATUS_OFF_RX_QUEUE_NON_EMPTY_K2_E5_SHIFT                                         2
  #define PCIEIP_REG_QUEUE_STATUS_OFF_TIMER_MOD_FLOW_CONTROL_K2_E5                                           (0x1fff<<16) // FC Latency Timer Override Value. When you set the "FC Latency Timer Override Enable" in this register, the value in this field will override the FC latency timer value that the core calculates according to the PCIe specification. For more details, see "Flow Control".  Note: This register field is sticky.
  #define PCIEIP_REG_QUEUE_STATUS_OFF_TIMER_MOD_FLOW_CONTROL_K2_E5_SHIFT                                     16
  #define PCIEIP_REG_QUEUE_STATUS_OFF_TIMER_MOD_FLOW_CONTROL_EN_K2_E5                                        (0x1<<31) // FC Latency Timer Override Enable. When this bit is set, the value from the "FC Latency Timer Override Value" field in this register will override the FC latency timer value that the core calculates according to the PCIe specification.  Note: This register field is sticky.
  #define PCIEIP_REG_QUEUE_STATUS_OFF_TIMER_MOD_FLOW_CONTROL_EN_K2_E5_SHIFT                                  31
#define PCIEIP_REG_VC_TX_ARBI_1_OFF_K2_E5                                                                    0x000740UL //Access:R    DataWidth:0x20   // VC Transmit Arbitration Register 1
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_0_K2_E5                                                  (0xff<<0) // WRR Weight for VC0.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_0_K2_E5_SHIFT                                            0
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_1_K2_E5                                                  (0xff<<8) // WRR Weight for VC1.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_1_K2_E5_SHIFT                                            8
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_2_K2_E5                                                  (0xff<<16) // WRR Weight for VC2.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_2_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_3_K2_E5                                                  (0xff<<24) // WRR Weight for VC3.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_1_OFF_WRR_WEIGHT_VC_3_K2_E5_SHIFT                                            24
#define PCIEIP_REG_VC_TX_ARBI_2_OFF_K2_E5                                                                    0x000744UL //Access:R    DataWidth:0x20   // VC Transmit Arbitration Register 2
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_4_K2_E5                                                  (0xff<<0) // WRR Weight for VC4.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_4_K2_E5_SHIFT                                            0
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_5_K2_E5                                                  (0xff<<8) // WRR Weight for VC5.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_5_K2_E5_SHIFT                                            8
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_6_K2_E5                                                  (0xff<<16) // WRR Weight for VC6.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_6_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_7_K2_E5                                                  (0xff<<24) // WRR Weight for VC7.  Note: The access attributes of this field are as follows:  - Dbi: R
  #define PCIEIP_REG_VC_TX_ARBI_2_OFF_WRR_WEIGHT_VC_7_K2_E5_SHIFT                                            24
#define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_K2_E5                                                                 0x000748UL //Access:RW   DataWidth:0x20   // Segmented-Buffer VC0 Posted Receive Queue Control.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC0_P_DATA_CREDIT_K2_E5                                             (0xfff<<0) // VC0 Posted Data Credits. The number of initial posted data credits for VC0, used only in the segmented-buffer configuration.  Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC0_P_DATA_CREDIT_K2_E5_SHIFT                                       0
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC0_P_HEADER_CREDIT_K2_E5                                           (0xff<<12) // VC0 Posted Header Credits. The number of initial posted header credits for VC0, used only in the segmented-buffer configuration.  Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC0_P_HEADER_CREDIT_K2_E5_SHIFT                                     12
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_RESERVED4_K2_E5                                                     (0x1<<20) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_RESERVED4_K2_E5_SHIFT                                               20
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC0_P_TLP_Q_MODE_K2_E5                                              (0x7<<21) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC0_P_TLP_Q_MODE_K2_E5_SHIFT                                        21
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_RESERVED5_K2_E5                                                     (0x3f<<24) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_RESERVED5_K2_E5_SHIFT                                               24
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_TLP_TYPE_ORDERING_VC0_K2_E5                                         (0x1<<30) // TLP Type Ordering for VC0. Determines the TLP type ordering rule for VC0 receive queues, used only in the segmented-buffer configuration:  - 1: PCIe ordering rules (recommended)  - 0: Strict ordering: posted, completion, then non-posted Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_TLP_TYPE_ORDERING_VC0_K2_E5_SHIFT                                   30
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC_ORDERING_RX_Q_K2_E5                                              (0x1<<31) // VC Ordering for Receive Queues. Determines the VC ordering rule for the receive queues, used only in the segmented-buffer configuration:  - 1: Strict ordering, higher numbered VCs have higher priority  - 0: Round robin Note: This register field is sticky.
  #define PCIEIP_REG_VC0_P_RX_Q_CTRL_OFF_VC_ORDERING_RX_Q_K2_E5_SHIFT                                        31
#define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_K2_E5                                                                0x00074cUL //Access:RW   DataWidth:0x20   // Segmented-Buffer VC0 Non-Posted Receive Queue Control.
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_VC0_NP_DATA_CREDIT_K2_E5                                           (0xfff<<0) // VC0 Non-Posted Data Credits. The number of initial non-posted data credits for VC0, used only in the segmented-buffer configuration.  Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_VC0_NP_DATA_CREDIT_K2_E5_SHIFT                                     0
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_VC0_NP_HEADER_CREDIT_K2_E5                                         (0xff<<12) // VC0 Non-Posted Header Credits. The number of initial non-posted header credits for VC0, used only in the segmented-buffer configuration.  Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_VC0_NP_HEADER_CREDIT_K2_E5_SHIFT                                   12
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_RESERVED6_K2_E5                                                    (0x1<<20) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_RESERVED6_K2_E5_SHIFT                                              20
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_VC0_NP_TLP_Q_MODE_K2_E5                                            (0x7<<21) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_VC0_NP_TLP_Q_MODE_K2_E5_SHIFT                                      21
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_RESERVED7_K2_E5                                                    (0xff<<24) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_NP_RX_Q_CTRL_OFF_RESERVED7_K2_E5_SHIFT                                              24
#define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_K2_E5                                                               0x000750UL //Access:RW   DataWidth:0x20   // Segmented-Buffer VC0 Completion Receive Queue Control.
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_VC0_CPL_DATA_CREDIT_K2_E5                                         (0xfff<<0) // VC0 Completion Data Credits. The number of initial Completion data credits for VC0, used only in the segmented-buffer configuration.  Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_VC0_CPL_DATA_CREDIT_K2_E5_SHIFT                                   0
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_VC0_CPL_HEADER_CREDIT_K2_E5                                       (0xff<<12) // VC0 Completion Header Credits. The number of initial Completion header credits for VC0, used only in the segmented-buffer configuration.  Note: The access attributes of this field are as follows:  - Dbi: R (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_VC0_CPL_HEADER_CREDIT_K2_E5_SHIFT                                 12
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_RESERVED8_K2_E5                                                   (0x1<<20) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_RESERVED8_K2_E5_SHIFT                                             20
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_VC0_CPL_TLP_Q_MODE_K2_E5                                          (0x7<<21) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_VC0_CPL_TLP_Q_MODE_K2_E5_SHIFT                                    21
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_RESERVED9_K2_E5                                                   (0xff<<24) // Reserved.  Note: This register field is sticky.
  #define PCIEIP_REG_VC0_CPL_RX_Q_CTRL_OFF_RESERVED9_K2_E5_SHIFT                                             24
#define PCIEIP_REG_TL_CONTROL_0_BB                                                                           0x000800UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CONTROL_0_PM_TL_IGNORE_REQS_BB                                                       (0x1<<0) // When set the TL TX does not send out pending requests if PM requests to block TLPS. By default TL will send all pending dma requests and completions when PM requests it to prepare for leaving L0 before asserting tlp blocked. When this bit is set , if min credits are available, TL indicates to PM that TLP is blocked and does not send out any pending dma requests or completions.
  #define PCIEIP_REG_TL_CONTROL_0_PM_TL_IGNORE_REQS_BB_SHIFT                                                 0
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_1DW_CHK_BB                                                           (0x1<<1) // Target mem Rd should not be greater than 1 DW if set.
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_1DW_CHK_BB_SHIFT                                                     1
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_3DW_CHK_BB                                                           (0x1<<2) // Target mem Rd should not be greater than 3 DW if set.
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_3DW_CHK_BB_SHIFT                                                     2
  #define PCIEIP_REG_TL_CONTROL_0_MEMWR_1DW_CHK_BB                                                           (0x1<<3) // Target mem Wr should not be greater than 1 DW if set.
  #define PCIEIP_REG_TL_CONTROL_0_MEMWR_1DW_CHK_BB_SHIFT                                                     3
  #define PCIEIP_REG_TL_CONTROL_0_EXPROM_3DW_CHK_BB                                                          (0x1<<4) // Target Expansion ROM should not be greater than 3 DW if set.
  #define PCIEIP_REG_TL_CONTROL_0_EXPROM_3DW_CHK_BB_SHIFT                                                    4
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_16DW_CHK_BB                                                          (0x1<<5) // Target mem Rd should not be greater than 16 DW if set .
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_16DW_CHK_BB_SHIFT                                                    5
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_4DW_CHK_BB                                                           (0x1<<6) // Target mem Rd should not be greater than 4 DW if set .
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_4DW_CHK_BB_SHIFT                                                     6
  #define PCIEIP_REG_TL_CONTROL_0_MEMWR_4DW_CHK_BB                                                           (0x1<<7) // Target mem Wr should not be greater than 4 DW if set .
  #define PCIEIP_REG_TL_CONTROL_0_MEMWR_4DW_CHK_BB_SHIFT                                                     7
  #define PCIEIP_REG_TL_CONTROL_0_MEMWR_32DW_CHK_BB                                                          (0x1<<8) // Target mem Wr should not be greater than 32 DW if set .
  #define PCIEIP_REG_TL_CONTROL_0_MEMWR_32DW_CHK_BB_SHIFT                                                    8
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_32DW_CHK_BB                                                          (0x1<<9) // Target mem Rd should not be greater than 32 DW if set .
  #define PCIEIP_REG_TL_CONTROL_0_MEMRD_32DW_CHK_BB_SHIFT                                                    9
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_3_BB                                                                (0x3<<10) // 
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_3_BB_SHIFT                                                          10
  #define PCIEIP_REG_TL_CONTROL_0_RETAIN_RID_BB                                                              (0x1<<12) // This bit if set will force DUT to not reset its RID after an FLR.
  #define PCIEIP_REG_TL_CONTROL_0_RETAIN_RID_BB_SHIFT                                                        12
  #define PCIEIP_REG_TL_CONTROL_0_AUTO_CLR_FLR_AFTER_55MS_BB                                                 (0x1<<13) // If set, DUT will automatically exit FLR state after a 55ms timer expires.
  #define PCIEIP_REG_TL_CONTROL_0_AUTO_CLR_FLR_AFTER_55MS_BB_SHIFT                                           13
  #define PCIEIP_REG_TL_CONTROL_0_AUTO_CLR_CRS_POST_FLR_BB                                                   (0x1<<14) // If set, DUT will automatically return Successful completion when it has completed FLR.
  #define PCIEIP_REG_TL_CONTROL_0_AUTO_CLR_CRS_POST_FLR_BB_SHIFT                                             14
  #define PCIEIP_REG_TL_CONTROL_0_NO_CMPL_IN_FLR_BB                                                          (0x1<<15) // If set, completions received for a function which is in FLR will not be directed to user.
  #define PCIEIP_REG_TL_CONTROL_0_NO_CMPL_IN_FLR_BB_SHIFT                                                    15
  #define PCIEIP_REG_TL_CONTROL_0_CFG_FUNC_EN0_BB                                                            (0x1<<16) // If set, this causes func0 to be hidden
  #define PCIEIP_REG_TL_CONTROL_0_CFG_FUNC_EN0_BB_SHIFT                                                      16
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_2_BB                                                                (0x1<<17) // 
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_2_BB_SHIFT                                                          17
  #define PCIEIP_REG_TL_CONTROL_0_CFG_MSI_LOW_MODE_BB                                                        (0x1<<18) // when set, forces MSI_En to low.
  #define PCIEIP_REG_TL_CONTROL_0_CFG_MSI_LOW_MODE_BB_SHIFT                                                  18
  #define PCIEIP_REG_TL_CONTROL_0_BEACON_MULTI_EN_BB                                                         (0x1<<19) // When set Beacon is enabled for all lanes
  #define PCIEIP_REG_TL_CONTROL_0_BEACON_MULTI_EN_BB_SHIFT                                                   19
  #define PCIEIP_REG_TL_CONTROL_0_BEACON_DIS_BB                                                              (0x1<<20) // When set, Beacon generation is disabled
  #define PCIEIP_REG_TL_CONTROL_0_BEACON_DIS_BB_SHIFT                                                        20
  #define PCIEIP_REG_TL_CONTROL_0_WAKE_L0_L1_EN_BB                                                           (0x1<<21) // When set, it enables WAKE generation in any L-state, when PME_EN bit is set and corresponding status is enabled
  #define PCIEIP_REG_TL_CONTROL_0_WAKE_L0_L1_EN_BB_SHIFT                                                     21
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_4_BB                                                                (0x1<<22) // 
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_4_BB_SHIFT                                                          22
  #define PCIEIP_REG_TL_CONTROL_0_RST_IGNORE_DLPDOWN_BB                                                      (0x1<<23) // When set, TL does not get reset on DLPDOWN and Pcie_rst_b does not get asserted on DLPDOWN
  #define PCIEIP_REG_TL_CONTROL_0_RST_IGNORE_DLPDOWN_BB_SHIFT                                                23
  #define PCIEIP_REG_TL_CONTROL_0_PM_DIS_L1_REENTRY_BB                                                       (0x1<<24) // When set, it prevents PM from re-entering L1 when programmed to non-D0 power state
  #define PCIEIP_REG_TL_CONTROL_0_PM_DIS_L1_REENTRY_BB_SHIFT                                                 24
  #define PCIEIP_REG_TL_CONTROL_0_PCIE_PHY_TX_SWING_BB                                                       (0x1<<25) // This bit is used by PCIE SERDES to determine source of tx margin signals
  #define PCIEIP_REG_TL_CONTROL_0_PCIE_PHY_TX_SWING_BB_SHIFT                                                 25
  #define PCIEIP_REG_TL_CONTROL_0_PERST_B_80USSEL_BB                                                         (0x1<<26) // Select the 150us delayed perst_b instead of the raw perst_b
  #define PCIEIP_REG_TL_CONTROL_0_PERST_B_80USSEL_BB_SHIFT                                                   26
  #define PCIEIP_REG_TL_CONTROL_0_REG_PERST_B_10MSSEL_BB                                                     (0x1<<27) // Select the 10ms delayed perst_b instead of the raw perst_b
  #define PCIEIP_REG_TL_CONTROL_0_REG_PERST_B_10MSSEL_BB_SHIFT                                               27
  #define PCIEIP_REG_TL_CONTROL_0_REG_SCND_RST_ON_HOT_BB                                                     (0x1<<28) // In RC mode, when set, it enables pcie_scnd_rst_b to be asserted when Secondary reset bit in BridgeControl register is set.
  #define PCIEIP_REG_TL_CONTROL_0_REG_SCND_RST_ON_HOT_BB_SHIFT                                               28
  #define PCIEIP_REG_TL_CONTROL_0_REG_FORCE_SCND_RST_BB                                                      (0x1<<29) // In RC mode, when set, it forces pcie_scnd_rst_b to be asserted
  #define PCIEIP_REG_TL_CONTROL_0_REG_FORCE_SCND_RST_BB_SHIFT                                                29
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_1_BB                                                                (0x3<<30) // 
  #define PCIEIP_REG_TL_CONTROL_0_UNUSED_1_BB_SHIFT                                                          30
#define PCIEIP_REG_TL_CONTROL_1_BB                                                                           0x000804UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CONTROL_1_EN_4G_CHK_BB                                                               (0x1<<0) // Enable check to determine if mem requests do not have upper 32 bits of address to be all 0
  #define PCIEIP_REG_TL_CONTROL_1_EN_4G_CHK_BB_SHIFT                                                         0
  #define PCIEIP_REG_TL_CONTROL_1_EN_4K_CHK_BB                                                               (0x1<<1) // Enable checks to determine TLP doesn not cross 4k boundary
  #define PCIEIP_REG_TL_CONTROL_1_EN_4K_CHK_BB_SHIFT                                                         1
  #define PCIEIP_REG_TL_CONTROL_1_EN_BC_CHK_BB                                                               (0x1<<2) // Enable check to determine if the length field and bytecount field are in sync
  #define PCIEIP_REG_TL_CONTROL_1_EN_BC_CHK_BB_SHIFT                                                         2
  #define PCIEIP_REG_TL_CONTROL_1_EN_BE_CHK_BB                                                               (0x1<<3) // Enable check to determine if received TLP follows all the Byte enable rules
  #define PCIEIP_REG_TL_CONTROL_1_EN_BE_CHK_BB_SHIFT                                                         3
  #define PCIEIP_REG_TL_CONTROL_1_EN_EP_CHK_BB                                                               (0x1<<4) // Enable check for Poisoned TLP
  #define PCIEIP_REG_TL_CONTROL_1_EN_EP_CHK_BB_SHIFT                                                         4
  #define PCIEIP_REG_TL_CONTROL_1_EN_MPS_CHECK_BB                                                            (0x1<<5) // Enable Check for max payload size Violation
  #define PCIEIP_REG_TL_CONTROL_1_EN_MPS_CHECK_BB_SHIFT                                                      5
  #define PCIEIP_REG_TL_CONTROL_1_EN_RCB_CHK_BB                                                              (0x1<<6) // Enable checks to determine completion TLPs do not violate RCB
  #define PCIEIP_REG_TL_CONTROL_1_EN_RCB_CHK_BB_SHIFT                                                        6
  #define PCIEIP_REG_TL_CONTROL_1_EN_RTE_CHK_BB                                                              (0x1<<7) // Enable Check to determine if the routing type is correct when receiving message TLP
  #define PCIEIP_REG_TL_CONTROL_1_EN_RTE_CHK_BB_SHIFT                                                        7
  #define PCIEIP_REG_TL_CONTROL_1_EN_TAC_CHK_BB                                                              (0x1<<8) // Enable Configuration attribute and class check
  #define PCIEIP_REG_TL_CONTROL_1_EN_TAC_CHK_BB_SHIFT                                                        8
  #define PCIEIP_REG_TL_CONTROL_1_EN_FC_CHK_BB                                                               (0x1<<9) // Enable Flow Control Check
  #define PCIEIP_REG_TL_CONTROL_1_EN_FC_CHK_BB_SHIFT                                                         9
  #define PCIEIP_REG_TL_CONTROL_1_EN_TO_CHK_BB                                                               (0x1<<10) // Enable Completion Timeout Check( This bit is no longer used, instead bit defined by ECN 1.1 is used)
  #define PCIEIP_REG_TL_CONTROL_1_EN_TO_CHK_BB_SHIFT                                                         10
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_1_BB                                                             (0x1<<11) // This bit is used to disable function 1. Bit 17 of 800 can also be used. That bit is retained for software compatibility purpose.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_1_BB_SHIFT                                                       11
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_2_BB                                                             (0x1<<12) // This bit is used to disable function 2.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_2_BB_SHIFT                                                       12
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_3_BB                                                             (0x1<<13) // This bit is used to disable function 3.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_3_BB_SHIFT                                                       13
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_4_BB                                                             (0x1<<14) // This bit is used to disable function 4.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_4_BB_SHIFT                                                       14
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_5_BB                                                             (0x1<<15) // This bit is used to disable function 5.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_5_BB_SHIFT                                                       15
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_6_BB                                                             (0x1<<16) // This bit is used to disable function 6.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_6_BB_SHIFT                                                       16
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_7_BB                                                             (0x1<<17) // This bit is used to disable function 7.
  #define PCIEIP_REG_TL_CONTROL_1_HIDE_FUNC_7_BB_SHIFT                                                       17
  #define PCIEIP_REG_TL_CONTROL_1_RESERVED_BB                                                                (0x1<<18) // 
  #define PCIEIP_REG_TL_CONTROL_1_RESERVED_BB_SHIFT                                                          18
  #define PCIEIP_REG_TL_CONTROL_1_REG_IGNORE_LTRWT_REQMT_BB                                                  (0x1<<19) // When set, hardware will return completions and not wait for LTR message to be sent first even though device state may have changed to non-D0.
  #define PCIEIP_REG_TL_CONTROL_1_REG_IGNORE_LTRWT_REQMT_BB_SHIFT                                            19
  #define PCIEIP_REG_TL_CONTROL_1_REG_REL_NPHCRDT_ECRCERR_BB                                                 (0x1<<20) // Release NPH credit even if ECRC error is detected on NPH TLP.
  #define PCIEIP_REG_TL_CONTROL_1_REG_REL_NPHCRDT_ECRCERR_BB_SHIFT                                           20
  #define PCIEIP_REG_TL_CONTROL_1_REG_UCOR_INT_ERR_EN_BB                                                     (0x1<<21) // Enables uncorrectable Internal Error Reporting if feature is implemented in h/w
  #define PCIEIP_REG_TL_CONTROL_1_REG_UCOR_INT_ERR_EN_BB_SHIFT                                               21
  #define PCIEIP_REG_TL_CONTROL_1_REG_EN_BYTCNT_CHK_BB                                                       (0x1<<22) // When enabled, hardware checks the bytecount field in completion headers.
  #define PCIEIP_REG_TL_CONTROL_1_REG_EN_BYTCNT_CHK_BB_SHIFT                                                 22
  #define PCIEIP_REG_TL_CONTROL_1_REG_EN_LTR1_BB                                                             (0x1<<23) // This bit instructs h/w to send an LTR message with LTR values programmed in 'h848 whenever the h/w asserts the user_send_ltr1 port. This bit is used only if LTR_ENABLED is defined in version.v and if h/w supports 3 LTR states.
  #define PCIEIP_REG_TL_CONTROL_1_REG_EN_LTR1_BB_SHIFT                                                       23
  #define PCIEIP_REG_TL_CONTROL_1_EN_AUTOCRSCLR_BB                                                           (0x1<<24) // This bit enables CRS status to be automatically cleared when internal timer is equal to either 1 second or a programmable value(which ever is smaller). This bit is used only if AutoCRSClrOn is defined in version.v
  #define PCIEIP_REG_TL_CONTROL_1_EN_AUTOCRSCLR_BB_SHIFT                                                     24
  #define PCIEIP_REG_TL_CONTROL_1_EN_LTR2_BB                                                                 (0x1<<25) // This bit instructs h/w to send an LTR message with LTR values programmed in 'h84c whenever the h/w asserts the user_send_ltr2 port. This bit is used only if LTR_ENABLED is defined in version.v
  #define PCIEIP_REG_TL_CONTROL_1_EN_LTR2_BB_SHIFT                                                           25
  #define PCIEIP_REG_TL_CONTROL_1_WT_LTR_ASPM_VAL_BB                                                         (0xf<<26) // This programs a timer which indicates the amount of time DUT will wait before requesting entry to ASPM L1 when ASPM LTR is enabled. The unit of this timer is us. This time is in addition to the time that DL waits for bus to be idle. This timer is required to allow DUT to send ASPM LTR message and wait for FC to be returned before entering L1. This bit is used only if LTR_ENABLED is defined in version.v
  #define PCIEIP_REG_TL_CONTROL_1_WT_LTR_ASPM_VAL_BB_SHIFT                                                   26
  #define PCIEIP_REG_TL_CONTROL_1_EN_ASPM_LTR_BB                                                             (0x1<<30) // This bit instructs h/w to send an LTR message with LTR values programmed in 'h844 and 'h848 whenever the DUT enters or leaves ASPM L1. This bit is used only if LTR_ENABLED is defined in version.v
  #define PCIEIP_REG_TL_CONTROL_1_EN_ASPM_LTR_BB_SHIFT                                                       30
  #define PCIEIP_REG_TL_CONTROL_1_SEND_IMMED_LTR_BB                                                          (0x1<<31) // This bit instructs h/w to immediately send an LTR message with LTR values programmed in 'h840. This state has highest priority and when this bit is set, no other LTR message (other than those required by PCIE spec) will be sent. This bit is used only if LTR_ENABLED is defined in version.v
  #define PCIEIP_REG_TL_CONTROL_1_SEND_IMMED_LTR_BB_SHIFT                                                    31
#define PCIEIP_REG_TL_CONTROL_2_BB                                                                           0x000808UL //Access:RW   DataWidth:0x20   // This register masks the generation of pcie_err_attn signal when errors are detected by hardware.
  #define PCIEIP_REG_TL_CONTROL_2_PES0_MASK_BB                                                               (0x1<<0) // Poisoned Error Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_PES0_MASK_BB_SHIFT                                                         0
  #define PCIEIP_REG_TL_CONTROL_2_FCPES0_MASK_BB                                                             (0x1<<1) // Flow Control Protocol Error Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_FCPES0_MASK_BB_SHIFT                                                       1
  #define PCIEIP_REG_TL_CONTROL_2_CTS0_MASK_BB                                                               (0x1<<2) // Completer Timeout Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_CTS0_MASK_BB_SHIFT                                                         2
  #define PCIEIP_REG_TL_CONTROL_2_RX_UR0_MASK_BB                                                             (0x1<<3) // Received UR Status, Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_RX_UR0_MASK_BB_SHIFT                                                       3
  #define PCIEIP_REG_TL_CONTROL_2_UCS0_MASK_BB                                                               (0x1<<4) // Unexpected Completion Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_UCS0_MASK_BB_SHIFT                                                         4
  #define PCIEIP_REG_TL_CONTROL_2_ROS0_MASK_BB                                                               (0x1<<5) // Receiver Overflow Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_ROS0_MASK_BB_SHIFT                                                         5
  #define PCIEIP_REG_TL_CONTROL_2_MTLPS0_MASK_BB                                                             (0x1<<6) // Malformed TLP Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_MTLPS0_MASK_BB_SHIFT                                                       6
  #define PCIEIP_REG_TL_CONTROL_2_ECRCS0_MASK_BB                                                             (0x1<<7) // ECRC Error TLP Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_ECRCS0_MASK_BB_SHIFT                                                       7
  #define PCIEIP_REG_TL_CONTROL_2_URES0_MASK_BB                                                              (0x1<<8) // Unsupported Request Error Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_URES0_MASK_BB_SHIFT                                                        8
  #define PCIEIP_REG_TL_CONTROL_2_RXTABRT0_MASK_BB                                                           (0x1<<9) // Received target Abort Error Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_RXTABRT0_MASK_BB_SHIFT                                                     9
  #define PCIEIP_REG_TL_CONTROL_2_PES1_MASK_BB                                                               (0x1<<10) // Poisoned Error Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_PES1_MASK_BB_SHIFT                                                         10
  #define PCIEIP_REG_TL_CONTROL_2_FCPES1_MASK_BB                                                             (0x1<<11) // Flow Control Protocol Error Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_FCPES1_MASK_BB_SHIFT                                                       11
  #define PCIEIP_REG_TL_CONTROL_2_CTS1_MASK_BB                                                               (0x1<<12) // Completer Timeout Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_CTS1_MASK_BB_SHIFT                                                         12
  #define PCIEIP_REG_TL_CONTROL_2_RX_UR1_MASK_BB                                                             (0x1<<13) // Received UR Status, Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_RX_UR1_MASK_BB_SHIFT                                                       13
  #define PCIEIP_REG_TL_CONTROL_2_UCS1_MASK_BB                                                               (0x1<<14) // Unexpected Completion Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_UCS1_MASK_BB_SHIFT                                                         14
  #define PCIEIP_REG_TL_CONTROL_2_ROS1_MASK_BB                                                               (0x1<<15) // Receiver Overflow Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_ROS1_MASK_BB_SHIFT                                                         15
  #define PCIEIP_REG_TL_CONTROL_2_MTLPS1_MASK_BB                                                             (0x1<<16) // Malformed TLP Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_MTLPS1_MASK_BB_SHIFT                                                       16
  #define PCIEIP_REG_TL_CONTROL_2_ECRCS1_MASK_BB                                                             (0x1<<17) // ECRC Error TLP Status Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_CONTROL_2_ECRCS1_MASK_BB_SHIFT                                                       17
  #define PCIEIP_REG_TL_CONTROL_2_URES1_MASK_BB                                                              (0x1<<18) // Unsupported Request Error Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_URES1_MASK_BB_SHIFT                                                        18
  #define PCIEIP_REG_TL_CONTROL_2_RXTABRT1_MASK_BB                                                           (0x1<<19) // Received target Abort Error Status Mask for Function1, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_RXTABRT1_MASK_BB_SHIFT                                                     19
  #define PCIEIP_REG_TL_CONTROL_2_RTAG_VAL_UNEXP_ATTN_MASK_BB                                                (0x1<<20) // rtag_val_unexp_attn Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_RTAG_VAL_UNEXP_ATTN_MASK_BB_SHIFT                                          20
  #define PCIEIP_REG_TL_CONTROL_2_TX_TAG_IN_USE_ATTN_MASK_BB                                                 (0x1<<21) // tx_tag_in_use_attn Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_TX_TAG_IN_USE_ATTN_MASK_BB_SHIFT                                           21
  #define PCIEIP_REG_TL_CONTROL_2_DL_ERR_ATTN_MASK_BB                                                        (0x1<<22) // DL Error Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_DL_ERR_ATTN_MASK_BB_SHIFT                                                  22
  #define PCIEIP_REG_TL_CONTROL_2_PHY_ERR_ATTN_MASK_BB                                                       (0x1<<23) // PHY Error Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CONTROL_2_PHY_ERR_ATTN_MASK_BB_SHIFT                                                 23
  #define PCIEIP_REG_TL_CONTROL_2_TXINTF_OVERFLOW_ATTN_MASK_BB                                               (0x1<<24) // 
  #define PCIEIP_REG_TL_CONTROL_2_TXINTF_OVERFLOW_ATTN_MASK_BB_SHIFT                                         24
  #define PCIEIP_REG_TL_CONTROL_2_BRIDGE_FORWARD_ERR_ATTN_MASK_BB                                            (0x1<<25) // If set, TX reports user interface violation
  #define PCIEIP_REG_TL_CONTROL_2_BRIDGE_FORWARD_ERR_ATTN_MASK_BB_SHIFT                                      25
  #define PCIEIP_REG_TL_CONTROL_2_TTX_MPS_ERR_MASK_BB                                                        (0x1<<26) // 
  #define PCIEIP_REG_TL_CONTROL_2_TTX_MPS_ERR_MASK_BB_SHIFT                                                  26
  #define PCIEIP_REG_TL_CONTROL_2_TTX_MRRS_ERR_MASK_BB                                                       (0x1<<27) // 
  #define PCIEIP_REG_TL_CONTROL_2_TTX_MRRS_ERR_MASK_BB_SHIFT                                                 27
  #define PCIEIP_REG_TL_CONTROL_2_TTX_4KBOUND_ERR_MASK_BB                                                    (0x1<<28) // 
  #define PCIEIP_REG_TL_CONTROL_2_TTX_4KBOUND_ERR_MASK_BB_SHIFT                                              28
  #define PCIEIP_REG_TL_CONTROL_2_TTX_UNKNOWNTYPE_ERR_MASK_BB                                                (0x1<<29) // 
  #define PCIEIP_REG_TL_CONTROL_2_TTX_UNKNOWNTYPE_ERR_MASK_BB_SHIFT                                          29
  #define PCIEIP_REG_TL_CONTROL_2_UNUSED_1_BB                                                                (0x3<<30) // 
  #define PCIEIP_REG_TL_CONTROL_2_UNUSED_1_BB_SHIFT                                                          30
#define PCIEIP_REG_GEN2_CTRL_OFF_K2_E5                                                                       0x00080cUL //Access:RW   DataWidth:0x20   // Link Width and Speed Change Control Register.
  #define PCIEIP_REG_GEN2_CTRL_OFF_FAST_TRAINING_SEQ_K2_E5                                                   (0xff<<0) // Sets the Number of Fast Training Sequences (N_FTS) that the core advertises as its N_FTS during Gen2 or Gen3 link training. This value is used to inform the link partner about the PHY's ability to recover synchronization after a low power state. The number should be provided by the PHY vendor. Do not set N_FTS to zero; doing so can cause the LTSSM to go into the recovery state when exiting from L0s. This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_FAST_TRAINING_SEQ_K2_E5_SHIFT                                             0
  #define PCIEIP_REG_GEN2_CTRL_OFF_NUM_OF_LANES_K2_E5                                                        (0x1f<<8) // Predetermined Number of Lanes. Defines the number of lanes which are connected and not bad. Used to limit the effective link width to ignore 'broken" or "unused" lanes that detect a receiver. Indicates the number of lanes to check for exit from Electrical Idle in Polling.Active and L2.Idle. It is possible that the LTSSM might detect a receiver on a bad or broken lane during the Detect Substate. However, it is also possible that such a lane might also fail to exit Electrical Idle and therefore prevent a valid link from being configured. This value is referred to as the "Predetermined Number of Lanes" in section 4.2.6.2.1 of the PCI Express Base 3.0 Specification, revision 1.0. Encoding is as follows:  - 0x01: 1 lane  - 0x02: 2 lanes  - 0x03: 3 lanes  - .. When you have unused lanes in your system, then you must change the value in this register to reflect the number of lanes. You must also change the value in the "Link Mode Enable" field of PORT_LINK_CTRL_OFF. The value in this register is normally the same as the encoded value in PORT_LINK_CTRL_OFF. If you find that one of your used lanes is bad then you must reduce the value in this register. For more information, see "How to Tie Off Unused Lanes." For information on upsizing and downsizing the link width, see "Link Establishment." This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_NUM_OF_LANES_K2_E5_SHIFT                                                  8
  #define PCIEIP_REG_GEN2_CTRL_OFF_PRE_DET_LANE_K2_E5                                                        (0x7<<13) // Predetermined Lane for Auto Flip. This field defines which physical lane is connected to logical Lane0 by the flip operation performed in Detect. Allowed values are:  - 3'b000: Connect logical Lane0 to physical lane 0 or CX_NL-1 or CX_NL/2-1 or CX_NL/4-1 or CX_NL/8-1, depending on which lane is detected  - 3'b001: Connect logical Lane0 to physical lane 1  - 3'b010: Connect logical Lane0 to physical lane 3  - 3'b011: Connect logical Lane0 to physical lane 7  - 3'b100: Connect logical Lane0 to physical lane 15 This field is used to restrict the receiver detect procedure to a particular lane when the default detect and polling procedure performed on all lanes cannot be successful. A notable example of when it is useful to program this field to a value different from the default, is when a lane is asymmetrically broken, that is, it is detected in Detect LTSSM state but it cannot exit Electrical Idle in Polling LTSSM state.  Note: This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_PRE_DET_LANE_K2_E5_SHIFT                                                  13
  #define PCIEIP_REG_GEN2_CTRL_OFF_AUTO_LANE_FLIP_CTRL_EN_K2_E5                                              (0x1<<16) // Enable Auto flipping of the lanes. You must set the CX_AUTO_LANE_FLIP_CTRL_EN configuration parameter to include the hardware for this feature in the core. For more details, see the 'Lane Reversal' appendix in the Databook. This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_AUTO_LANE_FLIP_CTRL_EN_K2_E5_SHIFT                                        16
  #define PCIEIP_REG_GEN2_CTRL_OFF_DIRECT_SPEED_CHANGE_K2_E5                                                 (0x1<<17) // Directed Speed Change. Writing "1" to this field instructs the LTSSM to initiate a speed change to Gen2 or Gen3 after the link is initialized at Gen1 speed. When the speed change occurs, the core will clear the contents of this field; and a read to this field by your software will return a "0". To manually initiate the speed change:  - Write to LINK_CONTROL2_LINK_STATUS2_REG . PCIE_CAP_TARGET_LINK_SPEED in the local device  - Deassert this field  - Assert this field If you set the default of this field using the DEFAULT_GEN2_SPEED_CHANGE configuration parameter to "1", then the speed change is initiated automatically after link up, and the core clears the contents of this field. If you want to prevent this automatic speed change, then write a lower speed value to the Target Link Speed field of the Link Control 2 register (LINK_CONTROL2_LINK_STATUS2_OFF . PCIE_CAP_TARGET_LINK_SPEED) through the DBI before link up. This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_GEN2_CTRL_OFF_DIRECT_SPEED_CHANGE_K2_E5_SHIFT                                           17
  #define PCIEIP_REG_GEN2_CTRL_OFF_CONFIG_PHY_TX_CHANGE_K2_E5                                                (0x1<<18) // Config PHY Tx Swing. Controls the PHY transmitter voltage swing level. The core drives the mac_phy_txswing output from this register bit field.  - 0: Full Swing  - 1: Low Swing This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_CONFIG_PHY_TX_CHANGE_K2_E5_SHIFT                                          18
  #define PCIEIP_REG_GEN2_CTRL_OFF_CONFIG_TX_COMP_RX_K2_E5                                                   (0x1<<19) // Config Tx Compliance Receive Bit. When set to 1, signals LTSSM to transmit TS ordered sets with the compliance receive bit assert (equal to "1"). This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_CONFIG_TX_COMP_RX_K2_E5_SHIFT                                             19
  #define PCIEIP_REG_GEN2_CTRL_OFF_SEL_DEEMPHASIS_K2_E5                                                      (0x1<<20) // Used to set the de-emphasis level for upstream ports. This bit selects the level of de-emphasis the link operates at.  - 0: -6 dB  - 1: -3.5 dB This field is reserved (fixed to '0') for M-PCIe.  Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_SEL_DEEMPHASIS_K2_E5_SHIFT                                                20
  #define PCIEIP_REG_GEN2_CTRL_OFF_GEN1_EI_INFERENCE_K2_E5                                                   (0x1<<21) // Electrical Idle Inference Mode at Gen1 Rate. Programmable mode to determine inferred electrical idle (EI) in Recovery.Speed or Loopback.Active (as slave) state at Gen1 speed by looking for a "1" value on RxElecIdle instead of looking for a "0" on RxValid. If the PHY fails to deassert the RxValid signal in Recovery.Speed or Loopback.Active (because of corrupted EIOS for example), then EI cannot be inferred successfully in the core by just detecting the condition RxValid=0.  - 0: Use RxElecIdle signal to infer Electrical Idle  - 1: Use RxValid signal to infer Electrical Idle Note: This register field is sticky.
  #define PCIEIP_REG_GEN2_CTRL_OFF_GEN1_EI_INFERENCE_K2_E5_SHIFT                                             21
#define PCIEIP_REG_TL_CONTROL_3_BB                                                                           0x00080cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CONTROL_3_EN_CMPL_RETRY_BB                                                           (0x1<<0) // Enable Completion retry upon completion timeout. (feature is not supported, but bit is defined for posterity.)
  #define PCIEIP_REG_TL_CONTROL_3_EN_CMPL_RETRY_BB_SHIFT                                                     0
  #define PCIEIP_REG_TL_CONTROL_3_EN_PSND_RETRY_BB                                                           (0x1<<1) // Enable Poisoned completions retry. (feature is not supported but bit is defined for posterity.)
  #define PCIEIP_REG_TL_CONTROL_3_EN_PSND_RETRY_BB_SHIFT                                                     1
  #define PCIEIP_REG_TL_CONTROL_3_EN_HOLD_PHCRDT_BB                                                          (0x1<<2) // Hold releasing of Posted header credit. When this bit is set, PH credits are not released by IP if FIFO at the DL-TL boundary reaches a critical threshold. This feature allows the FIFO to unload without overflowing
  #define PCIEIP_REG_TL_CONTROL_3_EN_HOLD_PHCRDT_BB_SHIFT                                                    2
  #define PCIEIP_REG_TL_CONTROL_3_EN_HOLD_DMACRDT_BB                                                         (0x1<<3) // Indicates no non-posted credit is available to user when bit is set. The credits to user are artificially reduced to 0, when FIFO at DL_TL boundary has reached a critical threshold and is in danger of overflowing. This feature allows the FIFO to unload without overflowing
  #define PCIEIP_REG_TL_CONTROL_3_EN_HOLD_DMACRDT_BB_SHIFT                                                   3
  #define PCIEIP_REG_TL_CONTROL_3_REG_EN_ADVERR_RX_ERR_BB                                                    (0x1<<4) // Enable the reporting of receiver errors in the advanced error reporting structure.
  #define PCIEIP_REG_TL_CONTROL_3_REG_EN_ADVERR_RX_ERR_BB_SHIFT                                              4
  #define PCIEIP_REG_TL_CONTROL_3_REG_DIS_D0STATE_L1_BB                                                      (0x1<<5) // When set , disables entry into L1, due to function being in D0unint state. When set, it would require all enabled functions to be in D3hot to request L1 entry.
  #define PCIEIP_REG_TL_CONTROL_3_REG_DIS_D0STATE_L1_BB_SHIFT                                                5
  #define PCIEIP_REG_TL_CONTROL_3_REG_EN_ASPM_L0L1_BB                                                        (0x3<<6) // When clear, field overrides the values in the ASPm Control field and disables it.
  #define PCIEIP_REG_TL_CONTROL_3_REG_EN_ASPM_L0L1_BB_SHIFT                                                  6
  #define PCIEIP_REG_TL_CONTROL_3_TL_REG_TXCTRL_BB                                                           (0xff<<8) // 
  #define PCIEIP_REG_TL_CONTROL_3_TL_REG_TXCTRL_BB_SHIFT                                                     8
  #define PCIEIP_REG_TL_CONTROL_3_OVERRIDE_L1_ENTRY_BB                                                       (0x1<<16) // This bit when set prevents DUT from entering L1 due to being in non-d0 state.
  #define PCIEIP_REG_TL_CONTROL_3_OVERRIDE_L1_ENTRY_BB_SHIFT                                                 16
  #define PCIEIP_REG_TL_CONTROL_3_MAX_INTER_L1_GAP_BB                                                        (0x7fff<<17) // Programmable delay to prevent link from re-entering L1, when link comes out of L1 into L0 due to PM_PME. The default value corresponds to 8 us and uses pulse_1us signal to count this value
  #define PCIEIP_REG_TL_CONTROL_3_MAX_INTER_L1_GAP_BB_SHIFT                                                  17
#define PCIEIP_REG_PHY_STATUS_OFF_K2_E5                                                                      0x000810UL //Access:R    DataWidth:0x20   // PHY Status Register. Memory mapped register from phy_cfg_status GPIO input pins.
#define PCIEIP_REG_TL_CONTROL_4_BB                                                                           0x000810UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CONTROL_4_RESERVED2_BB                                                               (0xffff<<0) // For ECO/CTRL bits are reset o hard_reset
  #define PCIEIP_REG_TL_CONTROL_4_RESERVED2_BB_SHIFT                                                         0
  #define PCIEIP_REG_TL_CONTROL_4_RESERVED1_BB                                                               (0xffff<<16) // For ECO/Control bits are reset on perst_b
  #define PCIEIP_REG_TL_CONTROL_4_RESERVED1_BB_SHIFT                                                         16
#define PCIEIP_REG_PHY_CONTROL_OFF_K2_E5                                                                     0x000814UL //Access:RW   DataWidth:0x20   // PHY Control Register. Memory mapped register to cfg_phy_control GPIO output pins.
#define PCIEIP_REG_TL_CTRLSTAT_5_BB                                                                          0x000814UL //Access:RW   DataWidth:0x20   // This register stores the status of errors to generate pcie_err_attn.
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_PSND_TLP_BB                                                           (0x1<<0) // This bit is set when h/w detects Poisoned Error Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_PSND_TLP_BB_SHIFT                                                     0
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_FC_PRTL_BB                                                            (0x1<<1) // This bit is set when h/w detects Flow Control Protocol Error Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_FC_PRTL_BB_SHIFT                                                      1
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_CPL_TIMEOUT_BB                                                        (0x1<<2) // This bit is set when h/w detects Completer Timeout Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_CPL_TIMEOUT_BB_SHIFT                                                  2
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MASTER_ABRT_BB                                                        (0x1<<3) // This bit is set when h/w detects Receive UR Status. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MASTER_ABRT_BB_SHIFT                                                  3
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNEXP_CPL_BB                                                          (0x1<<4) // This bit is set when h/w detects Unexpected Completion Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNEXP_CPL_BB_SHIFT                                                    4
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_RX_OFLOW_BB                                                           (0x1<<5) // This bit is set when h/w detects Receiver Overflow Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_RX_OFLOW_BB_SHIFT                                                     5
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MALF_TLP_BB                                                           (0x1<<6) // This bit is set when h/w detects Malformed TLP Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MALF_TLP_BB_SHIFT                                                     6
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_ECRC_BB                                                               (0x1<<7) // This bit is set when h/w detects ECRC Error TLP Status , If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_ECRC_BB_SHIFT                                                         7
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNSPPORT_BB                                                           (0x1<<8) // This bit is set when h/w detects Unsupported Request Error Status . If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNSPPORT_BB_SHIFT                                                     8
  #define PCIEIP_REG_TL_CTRLSTAT_5_PRI_SIG_TARGET_ABORT_BB                                                   (0x1<<9) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_PRI_SIG_TARGET_ABORT_BB_SHIFT                                             9
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_PSND_TLP1_BB                                                          (0x1<<10) // This bit is set when h/w detects Poisoned Error Status in function 1. If set, h/w generates pcie_err_attn output.
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_PSND_TLP1_BB_SHIFT                                                    10
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_FC_PRTL1_BB                                                           (0x1<<11) // This bit is set when h/w detects Flow Control Protocol Error Status in function 1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_FC_PRTL1_BB_SHIFT                                                     11
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_CPL_TIMEOUT1_BB                                                       (0x1<<12) // This bit is set when h/w detects Completer Timeout Status in function 1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_CPL_TIMEOUT1_BB_SHIFT                                                 12
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MASTER_ABRT1_BB                                                       (0x1<<13) // This bits is set when h/w detects Receive UR Status in function 1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MASTER_ABRT1_BB_SHIFT                                                 13
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNEXP_CPL1_BB                                                         (0x1<<14) // This bit is set when h/w detects Unexpected Completion Status in function 1. If set, h/w generates pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNEXP_CPL1_BB_SHIFT                                                   14
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_RX_OFLOW1_BB                                                          (0x1<<15) // This bit is set when h/w detects Receiver Overflow Status in function 1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_RX_OFLOW1_BB_SHIFT                                                    15
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MALF_TLP1_BB                                                          (0x1<<16) // This bit is set when h/w detects Malformed TLP Status in function 1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_MALF_TLP1_BB_SHIFT                                                    16
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_ECRC1_BB                                                              (0x1<<17) // This bit is set when h/w detects ECRC Error TLP Status in function 1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_ECRC1_BB_SHIFT                                                        17
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNSPPORT1_BB                                                          (0x1<<18) // This bit is set when h/w detects Unsupported Request Error Status in function1. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_CTRLSTAT_5_ERR_UNSPPORT1_BB_SHIFT                                                    18
  #define PCIEIP_REG_TL_CTRLSTAT_5_PRI_SIG_TARGET_ABORT1_BB                                                  (0x1<<19) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_PRI_SIG_TARGET_ABORT1_BB_SHIFT                                            19
  #define PCIEIP_REG_TL_CTRLSTAT_5_TRX_ERR_UNEXP_RTAG_BB                                                     (0x1<<20) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_TRX_ERR_UNEXP_RTAG_BB_SHIFT                                               20
  #define PCIEIP_REG_TL_CTRLSTAT_5_TTX_ERR_NP_TAG_IN_USE_BB                                                  (0x1<<21) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_TTX_ERR_NP_TAG_IN_USE_BB_SHIFT                                            21
  #define PCIEIP_REG_TL_CTRLSTAT_5_DL_ERR_ATTN_BB                                                            (0x1<<22) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_DL_ERR_ATTN_BB_SHIFT                                                      22
  #define PCIEIP_REG_TL_CTRLSTAT_5_PHY_ERR_ATTN_BB                                                           (0x1<<23) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_PHY_ERR_ATTN_BB_SHIFT                                                     23
  #define PCIEIP_REG_TL_CTRLSTAT_5_TTX_TXINTF_OVERFLOW_BB                                                    (0x1<<24) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_TTX_TXINTF_OVERFLOW_BB_SHIFT                                              24
  #define PCIEIP_REG_TL_CTRLSTAT_5_TTX_BRIDGE_FORWARD_ERR_BB                                                 (0x1<<25) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_TTX_BRIDGE_FORWARD_ERR_BB_SHIFT                                           25
  #define PCIEIP_REG_TL_CTRLSTAT_5_MPS_ERR_ATTN_BB                                                           (0x1<<26) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_MPS_ERR_ATTN_BB_SHIFT                                                     26
  #define PCIEIP_REG_TL_CTRLSTAT_5_MRRS_ERR_ATTN_BB                                                          (0x1<<27) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_MRRS_ERR_ATTN_BB_SHIFT                                                    27
  #define PCIEIP_REG_TL_CTRLSTAT_5_BOUNDARY4K_ERR_ATTN_BB                                                    (0x1<<28) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_BOUNDARY4K_ERR_ATTN_BB_SHIFT                                              28
  #define PCIEIP_REG_TL_CTRLSTAT_5_UNKNOWNTYPE_ERR_ATTN_BB                                                   (0x1<<29) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_UNKNOWNTYPE_ERR_ATTN_BB_SHIFT                                             29
  #define PCIEIP_REG_TL_CTRLSTAT_5_UNUSED_1_BB                                                               (0x3<<30) // 
  #define PCIEIP_REG_TL_CTRLSTAT_5_UNUSED_1_BB_SHIFT                                                         30
#define PCIEIP_REG_USER_CONTROL_1_BB                                                                         0x000818UL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_2_BB                                                                         0x00081cUL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_3_BB                                                                         0x000820UL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_4_BB                                                                         0x000824UL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_5_BB                                                                         0x000828UL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_6_BB                                                                         0x00082cUL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_7_BB                                                                         0x000830UL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_USER_CONTROL_8_BB                                                                         0x000834UL //Access:RW   DataWidth:0x20   // This register is for use by the user. User can snoop these registers and use it for their own control.
#define PCIEIP_REG_TL_CONTROL_6_BB                                                                           0x00083cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_8_BB                                                             (0x1<<0) // This bit is used to disable function 8.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_8_BB_SHIFT                                                       0
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_9_BB                                                             (0x1<<1) // This bit is used to disable function 9.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_9_BB_SHIFT                                                       1
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_10_BB                                                            (0x1<<2) // This bit is used to disable function 10.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_10_BB_SHIFT                                                      2
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_11_BB                                                            (0x1<<3) // This bit is used to disable function 11.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_11_BB_SHIFT                                                      3
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_12_BB                                                            (0x1<<4) // This bit is used to disable function 12.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_12_BB_SHIFT                                                      4
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_13_BB                                                            (0x1<<5) // This bit is used to disable function 13.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_13_BB_SHIFT                                                      5
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_14_BB                                                            (0x1<<6) // This bit is used to disable function 14.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_14_BB_SHIFT                                                      6
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_15_BB                                                            (0x1<<7) // This bit is used to disable function 15.
  #define PCIEIP_REG_TL_CONTROL_6_HIDE_FUNC_15_BB_SHIFT                                                      7
  #define PCIEIP_REG_TL_CONTROL_6_UNUSED_BB                                                                  (0xffffff<<8) // 
  #define PCIEIP_REG_TL_CONTROL_6_UNUSED_BB_SHIFT                                                            8
#define PCIEIP_REG_SW_LTR_VAL_BB                                                                             0x000840UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_SW_LTR_VAL_SW_SNOOP_LAT_VALUE_BB                                                        (0x3ff<<0) // Snoop latency Value.
  #define PCIEIP_REG_SW_LTR_VAL_SW_SNOOP_LAT_VALUE_BB_SHIFT                                                  0
  #define PCIEIP_REG_SW_LTR_VAL_SW_SNOOP_LAT_SCALE_BB                                                        (0x7<<10) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_SW_LTR_VAL_SW_SNOOP_LAT_SCALE_BB_SHIFT                                                  10
  #define PCIEIP_REG_SW_LTR_VAL_RESERVED_0_BB                                                                (0x3<<13) // 
  #define PCIEIP_REG_SW_LTR_VAL_RESERVED_0_BB_SHIFT                                                          13
  #define PCIEIP_REG_SW_LTR_VAL_SW_SNOOP_REQ_BB                                                              (0x1<<15) // Requirement bit indicates if device has a latency requirement for a snoop request.
  #define PCIEIP_REG_SW_LTR_VAL_SW_SNOOP_REQ_BB_SHIFT                                                        15
  #define PCIEIP_REG_SW_LTR_VAL_SW_NO_SNOOP_LAT_VALUE_BB                                                     (0x3ff<<16) // No_Snoop latency Value.
  #define PCIEIP_REG_SW_LTR_VAL_SW_NO_SNOOP_LAT_VALUE_BB_SHIFT                                               16
  #define PCIEIP_REG_SW_LTR_VAL_SW_NO_SNOOP_LAT_SCALE_BB                                                     (0x7<<26) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_SW_LTR_VAL_SW_NO_SNOOP_LAT_SCALE_BB_SHIFT                                               26
  #define PCIEIP_REG_SW_LTR_VAL_RESERVED_BB                                                                  (0x3<<29) // 
  #define PCIEIP_REG_SW_LTR_VAL_RESERVED_BB_SHIFT                                                            29
  #define PCIEIP_REG_SW_LTR_VAL_SW_NO_SNOOP_REQ_BB                                                           (0x1<<31) // Requirement bit indicates if device has a latency requirement for a no snoop request.
  #define PCIEIP_REG_SW_LTR_VAL_SW_NO_SNOOP_REQ_BB_SHIFT                                                     31
#define PCIEIP_REG_LTR0_REG_BB                                                                               0x000844UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LTR0_REG_LTR0_SNOOP_LAT_VALUE_BB                                                        (0x3ff<<0) // Snoop latency Value.
  #define PCIEIP_REG_LTR0_REG_LTR0_SNOOP_LAT_VALUE_BB_SHIFT                                                  0
  #define PCIEIP_REG_LTR0_REG_LTR0_SNOOP_LAT_SCALE_BB                                                        (0x7<<10) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_LTR0_REG_LTR0_SNOOP_LAT_SCALE_BB_SHIFT                                                  10
  #define PCIEIP_REG_LTR0_REG_RESERVED_1_BB                                                                  (0x3<<13) // 
  #define PCIEIP_REG_LTR0_REG_RESERVED_1_BB_SHIFT                                                            13
  #define PCIEIP_REG_LTR0_REG_LTR0_SNOOP_REQ_BB                                                              (0x1<<15) // Requirement bit indicates if device has a latency requirement for a snoop request.
  #define PCIEIP_REG_LTR0_REG_LTR0_SNOOP_REQ_BB_SHIFT                                                        15
  #define PCIEIP_REG_LTR0_REG_LTR0_NO_SNOOP_LAT_VALUE_BB                                                     (0x3ff<<16) // No_Snoop latency Value.
  #define PCIEIP_REG_LTR0_REG_LTR0_NO_SNOOP_LAT_VALUE_BB_SHIFT                                               16
  #define PCIEIP_REG_LTR0_REG_LTR0_NO_SNOOP_LAT_SCALE_BB                                                     (0x7<<26) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_LTR0_REG_LTR0_NO_SNOOP_LAT_SCALE_BB_SHIFT                                               26
  #define PCIEIP_REG_LTR0_REG_RESERVED_BB                                                                    (0x3<<29) // 
  #define PCIEIP_REG_LTR0_REG_RESERVED_BB_SHIFT                                                              29
  #define PCIEIP_REG_LTR0_REG_LTR0_NO_SNOOP_REQ_BB                                                           (0x1<<31) // Requirement bit indicates if device has a latency requirement for a no snoop request.
  #define PCIEIP_REG_LTR0_REG_LTR0_NO_SNOOP_REQ_BB_SHIFT                                                     31
#define PCIEIP_REG_LTR1_REG_BB                                                                               0x000848UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LTR1_REG_LTR1_SNOOP_LAT_VALUE_BB                                                        (0x3ff<<0) // Snoop latency Value.
  #define PCIEIP_REG_LTR1_REG_LTR1_SNOOP_LAT_VALUE_BB_SHIFT                                                  0
  #define PCIEIP_REG_LTR1_REG_LTR1_SNOOP_LAT_SCALE_BB                                                        (0x7<<10) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_LTR1_REG_LTR1_SNOOP_LAT_SCALE_BB_SHIFT                                                  10
  #define PCIEIP_REG_LTR1_REG_RESERVED_2_BB                                                                  (0x3<<13) // 
  #define PCIEIP_REG_LTR1_REG_RESERVED_2_BB_SHIFT                                                            13
  #define PCIEIP_REG_LTR1_REG_LTR1_SNOOP_REQ_BB                                                              (0x1<<15) // Requirement bit indicates if device has a latency requirement for a snoop request.
  #define PCIEIP_REG_LTR1_REG_LTR1_SNOOP_REQ_BB_SHIFT                                                        15
  #define PCIEIP_REG_LTR1_REG_LTR1_NO_SNOOP_LAT_VALUE_BB                                                     (0x3ff<<16) // No_Snoop latency Value.
  #define PCIEIP_REG_LTR1_REG_LTR1_NO_SNOOP_LAT_VALUE_BB_SHIFT                                               16
  #define PCIEIP_REG_LTR1_REG_LTR1_NO_SNOOP_LAT_SCALE_BB                                                     (0x7<<26) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_LTR1_REG_LTR1_NO_SNOOP_LAT_SCALE_BB_SHIFT                                               26
  #define PCIEIP_REG_LTR1_REG_RESERVED_BB                                                                    (0x3<<29) // 
  #define PCIEIP_REG_LTR1_REG_RESERVED_BB_SHIFT                                                              29
  #define PCIEIP_REG_LTR1_REG_LTR1_NO_SNOOP_REQ_BB                                                           (0x1<<31) // Requirement bit indicates if device has a latency requirement for a no snoop request.
  #define PCIEIP_REG_LTR1_REG_LTR1_NO_SNOOP_REQ_BB_SHIFT                                                     31
#define PCIEIP_REG_LTR2_REG_BB                                                                               0x00084cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_LTR2_REG_LTR2_SNOOP_LAT_VALUE_BB                                                        (0x3ff<<0) // Snoop latency Value.
  #define PCIEIP_REG_LTR2_REG_LTR2_SNOOP_LAT_VALUE_BB_SHIFT                                                  0
  #define PCIEIP_REG_LTR2_REG_LTR2_SNOOP_LAT_SCALE_BB                                                        (0x7<<10) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_LTR2_REG_LTR2_SNOOP_LAT_SCALE_BB_SHIFT                                                  10
  #define PCIEIP_REG_LTR2_REG_RESERVED_3_BB                                                                  (0x3<<13) // 
  #define PCIEIP_REG_LTR2_REG_RESERVED_3_BB_SHIFT                                                            13
  #define PCIEIP_REG_LTR2_REG_LTR2_SNOOP_REQ_BB                                                              (0x1<<15) // Requirement bit indicates if device has a latency requirement for a snoop request.
  #define PCIEIP_REG_LTR2_REG_LTR2_SNOOP_REQ_BB_SHIFT                                                        15
  #define PCIEIP_REG_LTR2_REG_LTR2_NO_SNOOP_LAT_VALUE_BB                                                     (0x3ff<<16) // No_Snoop latency Value.
  #define PCIEIP_REG_LTR2_REG_LTR2_NO_SNOOP_LAT_VALUE_BB_SHIFT                                               16
  #define PCIEIP_REG_LTR2_REG_LTR2_NO_SNOOP_LAT_SCALE_BB                                                     (0x7<<26) // Each LTR message has a value and scale field. Values are multiplied by this scale field to yield an absolute time value expressable in a range from 1ns to 34,326,183,936ns
  #define PCIEIP_REG_LTR2_REG_LTR2_NO_SNOOP_LAT_SCALE_BB_SHIFT                                               26
  #define PCIEIP_REG_LTR2_REG_RESERVED_BB                                                                    (0x3<<29) // 
  #define PCIEIP_REG_LTR2_REG_RESERVED_BB_SHIFT                                                              29
  #define PCIEIP_REG_LTR2_REG_LTR2_NO_SNOOP_REQ_BB                                                           (0x1<<31) // Requirement bit indicates if device has a latency requirement for a no snoop request.
  #define PCIEIP_REG_LTR2_REG_LTR2_NO_SNOOP_REQ_BB_SHIFT                                                     31
#define PCIEIP_REG_TL_FUNC345_MASK_BB                                                                        0x000850UL //Access:RW   DataWidth:0x20   // This register masks specific errors from setting pcie_err_attn.
  #define PCIEIP_REG_TL_FUNC345_MASK_PES2_MASK_BB                                                            (0x1<<0) // Poisoned Error Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_PES2_MASK_BB_SHIFT                                                      0
  #define PCIEIP_REG_TL_FUNC345_MASK_FCPES2_MASK_BB                                                          (0x1<<1) // Flow Control Protocol Error Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_FCPES2_MASK_BB_SHIFT                                                    1
  #define PCIEIP_REG_TL_FUNC345_MASK_CTS2_MASK_BB                                                            (0x1<<2) // Completer Timeout Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_CTS2_MASK_BB_SHIFT                                                      2
  #define PCIEIP_REG_TL_FUNC345_MASK_RX_UR2_MASK_BB                                                          (0x1<<3) // Received UR Status, Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_RX_UR2_MASK_BB_SHIFT                                                    3
  #define PCIEIP_REG_TL_FUNC345_MASK_UCS2_MASK_BB                                                            (0x1<<4) // Unexpected Completion Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_UCS2_MASK_BB_SHIFT                                                      4
  #define PCIEIP_REG_TL_FUNC345_MASK_ROS2_MASK_BB                                                            (0x1<<5) // Receiver Overflow Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_ROS2_MASK_BB_SHIFT                                                      5
  #define PCIEIP_REG_TL_FUNC345_MASK_MTLPS2_MASK_BB                                                          (0x1<<6) // Malformed TLP Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_MTLPS2_MASK_BB_SHIFT                                                    6
  #define PCIEIP_REG_TL_FUNC345_MASK_ECRCS2_MASK_BB                                                          (0x1<<7) // ECRC Error TLP Status Status Mask, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_ECRCS2_MASK_BB_SHIFT                                                    7
  #define PCIEIP_REG_TL_FUNC345_MASK_URES2_MASK_BB                                                           (0x1<<8) // Unsupported Request Error Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_URES2_MASK_BB_SHIFT                                                     8
  #define PCIEIP_REG_TL_FUNC345_MASK_RXTABRT2_MASK_BB                                                        (0x1<<9) // Received target Abort Error Status Mask, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_RXTABRT2_MASK_BB_SHIFT                                                  9
  #define PCIEIP_REG_TL_FUNC345_MASK_PES3_MASK_BB                                                            (0x1<<10) // Poisoned Error Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_PES3_MASK_BB_SHIFT                                                      10
  #define PCIEIP_REG_TL_FUNC345_MASK_FCPES3_MASK_BB                                                          (0x1<<11) // Flow Control Protocol Error Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_FCPES3_MASK_BB_SHIFT                                                    11
  #define PCIEIP_REG_TL_FUNC345_MASK_CTS3_MASK_BB                                                            (0x1<<12) // Completer Timeout Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_CTS3_MASK_BB_SHIFT                                                      12
  #define PCIEIP_REG_TL_FUNC345_MASK_RX_UR3_MASK_BB                                                          (0x1<<13) // Received UR Status, Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_RX_UR3_MASK_BB_SHIFT                                                    13
  #define PCIEIP_REG_TL_FUNC345_MASK_UCS3_MASK_BB                                                            (0x1<<14) // Unexpected Completion Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_UCS3_MASK_BB_SHIFT                                                      14
  #define PCIEIP_REG_TL_FUNC345_MASK_ROS3_MASK_BB                                                            (0x1<<15) // Receiver Overflow Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_ROS3_MASK_BB_SHIFT                                                      15
  #define PCIEIP_REG_TL_FUNC345_MASK_MTLPS3_MASK_BB                                                          (0x1<<16) // Malformed TLP Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_MTLPS3_MASK_BB_SHIFT                                                    16
  #define PCIEIP_REG_TL_FUNC345_MASK_ECRCS3_MASK_BB                                                          (0x1<<17) // ECRC Error TLP Status Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_ECRCS3_MASK_BB_SHIFT                                                    17
  #define PCIEIP_REG_TL_FUNC345_MASK_URES3_MASK_BB                                                           (0x1<<18) // Unsupported Request Error Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_URES3_MASK_BB_SHIFT                                                     18
  #define PCIEIP_REG_TL_FUNC345_MASK_RXTABRT3_MASK_BB                                                        (0x1<<19) // Received target Abort Error Status Mask for Function3, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_RXTABRT3_MASK_BB_SHIFT                                                  19
  #define PCIEIP_REG_TL_FUNC345_MASK_PES4_MASK_BB                                                            (0x1<<20) // Poisoned Error Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_PES4_MASK_BB_SHIFT                                                      20
  #define PCIEIP_REG_TL_FUNC345_MASK_FCPES4_MASK_BB                                                          (0x1<<21) // Flow Control Protocol Error Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_FCPES4_MASK_BB_SHIFT                                                    21
  #define PCIEIP_REG_TL_FUNC345_MASK_CTS4_MASK_BB                                                            (0x1<<22) // Completer Timeout Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_CTS4_MASK_BB_SHIFT                                                      22
  #define PCIEIP_REG_TL_FUNC345_MASK_RX_UR4_MASK_BB                                                          (0x1<<23) // Received UR Status, Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_RX_UR4_MASK_BB_SHIFT                                                    23
  #define PCIEIP_REG_TL_FUNC345_MASK_UCS4_MASK_BB                                                            (0x1<<24) // Unexpected Completion Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_UCS4_MASK_BB_SHIFT                                                      24
  #define PCIEIP_REG_TL_FUNC345_MASK_ROS4_MASK_BB                                                            (0x1<<25) // Receiver Overflow Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_ROS4_MASK_BB_SHIFT                                                      25
  #define PCIEIP_REG_TL_FUNC345_MASK_MTLPS4_MASK_BB                                                          (0x1<<26) // Malformed TLP Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_MTLPS4_MASK_BB_SHIFT                                                    26
  #define PCIEIP_REG_TL_FUNC345_MASK_ECRCS4_MASK_BB                                                          (0x1<<27) // ECRC Error TLP Status Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC345_MASK_ECRCS4_MASK_BB_SHIFT                                                    27
  #define PCIEIP_REG_TL_FUNC345_MASK_URES4_MASK_BB                                                           (0x1<<28) // Unsupported Request Error Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_URES4_MASK_BB_SHIFT                                                     28
  #define PCIEIP_REG_TL_FUNC345_MASK_RXTABRT4_MASK_BB                                                        (0x1<<29) // Received target Abort Error Status Mask for Function4, if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_MASK_RXTABRT4_MASK_BB_SHIFT                                                  29
  #define PCIEIP_REG_TL_FUNC345_MASK_UNUSED_1_BB                                                             (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC345_MASK_UNUSED_1_BB_SHIFT                                                       30
#define PCIEIP_REG_TL_FUNC345_STAT_BB                                                                        0x000854UL //Access:RW   DataWidth:0x20   // This register stores the status of errors to generate pcie_err_attn.
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_PSND_TLP2_BB                                                        (0x1<<0) // This bit is set when h/w detects Poisoned Error Status for Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_PSND_TLP2_BB_SHIFT                                                  0
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_FC_PRTL2_BB                                                         (0x1<<1) // This bit is set when h/w detects Flow Control Protocol Error Status for Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_FC_PRTL2_BB_SHIFT                                                   1
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_CPL_TIMEOUT2_BB                                                     (0x1<<2) // This bit is set when h/w detects Completer Timeout Status for Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_CPL_TIMEOUT2_BB_SHIFT                                               2
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MASTER_ABRT2_BB                                                     (0x1<<3) // This bit is set when h/w detects Receive UR Status in Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MASTER_ABRT2_BB_SHIFT                                               3
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNEXP_CPL2_BB                                                       (0x1<<4) // This bit is set when h/w detects Unexpected Completion Status for Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNEXP_CPL2_BB_SHIFT                                                 4
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_RX_OFLOW2_BB                                                        (0x1<<5) // This bit is set when h/w detects Receiver Overflow Status for Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_RX_OFLOW2_BB_SHIFT                                                  5
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MALF_TLP2_BB                                                        (0x1<<6) // This bit is set when h/w detects Malformed TLP Status for Function 2. If set, h/w generates pcie_err_attn output
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MALF_TLP2_BB_SHIFT                                                  6
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_ECRC2_BB                                                            (0x1<<7) // This bit is set when h/w detects ECRC Error TLP Status for Function 2. If set, h/w generates pcie_err_attn output
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_ECRC2_BB_SHIFT                                                      7
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNSPPORT2_BB                                                        (0x1<<8) // This bit is set when h/w detects Unsupported Request Error Status for Function 2. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNSPPORT2_BB_SHIFT                                                  8
  #define PCIEIP_REG_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT2_BB                                                (0x1<<9) // 
  #define PCIEIP_REG_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT2_BB_SHIFT                                          9
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_PSND_TLP3_BB                                                        (0x1<<10) // This bit is set when h/w detects Poisoned Error Status in function 3. If set, h/w generates pcie_err_attn output
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_PSND_TLP3_BB_SHIFT                                                  10
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_FC_PRTL3_BB                                                         (0x1<<11) // This bit is set when h/w detects Flow Control Protocol Error Status in function 3. If set, h/w generates pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_FC_PRTL3_BB_SHIFT                                                   11
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_CPL_TIMEOUT3_BB                                                     (0x1<<12) // This bit is set when h/w detects Completer Timeout Status in function 3. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_CPL_TIMEOUT3_BB_SHIFT                                               12
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MASTER_ABRT3_BB                                                     (0x1<<13) // This bit is set when h/w detects Receive UR Status in function 3. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MASTER_ABRT3_BB_SHIFT                                               13
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNEXP_CPL3_BB                                                       (0x1<<14) // This bit is set when h/w detects Unexpected Completion Status in function 3. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNEXP_CPL3_BB_SHIFT                                                 14
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_RX_OFLOW3_BB                                                        (0x1<<15) // This bit is set when h/w detects Receiver Overflow Status in function 3. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_RX_OFLOW3_BB_SHIFT                                                  15
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MALF_TLP3_BB                                                        (0x1<<16) // s bit is set when h/w detects Malformed TLP Status Status in function 3. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MALF_TLP3_BB_SHIFT                                                  16
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_ECRC3_BB                                                            (0x1<<17) // This bit is set when h/w detects ECRC Error TLP Status in function 3. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_ECRC3_BB_SHIFT                                                      17
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNSPPORT3_BB                                                        (0x1<<18) // This bit is set when h/w detects Unsupported Request Error Status in function3. If set, h/w generates pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNSPPORT3_BB_SHIFT                                                  18
  #define PCIEIP_REG_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT3_BB                                                (0x1<<19) // 
  #define PCIEIP_REG_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT3_BB_SHIFT                                          19
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_PSND_TLP4_BB                                                        (0x1<<20) // This bit is set when h/w detects Poisoned Error Status Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_PSND_TLP4_BB_SHIFT                                                  20
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_FC_PRTL4_BB                                                         (0x1<<21) // This bit is set when h/w detects Flow Control Protocol Error Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_FC_PRTL4_BB_SHIFT                                                   21
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_CPL_TIMEOUT4_BB                                                     (0x1<<22) // This bit is set when h/w detects Completer Timeout Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_CPL_TIMEOUT4_BB_SHIFT                                               22
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MASTER_ABRT4_BB                                                     (0x1<<23) // This bit is set when h/w detects Receive UR Statusin function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MASTER_ABRT4_BB_SHIFT                                               23
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNEXP_CPL4_BB                                                       (0x1<<24) // This bit is set when h/w detects Unexpected Completion Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNEXP_CPL4_BB_SHIFT                                                 24
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_RX_OFLOW4_BB                                                        (0x1<<25) // This bit is set when h/w detects Receiver Overflow Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_RX_OFLOW4_BB_SHIFT                                                  25
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MALF_TLP4_BB                                                        (0x1<<26) // This bit is set when h/w detects Malformed TLP Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_MALF_TLP4_BB_SHIFT                                                  26
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_ECRC4_BB                                                            (0x1<<27) // This bit is set when h/w detects ECRC Error TLP Status in function 4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_ECRC4_BB_SHIFT                                                      27
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNSPPORT4_BB                                                        (0x1<<28) // This bit is set when h/w detects Unsupported Request Error Status in function4. If set, h/w generates pcie_err_attn output .
  #define PCIEIP_REG_TL_FUNC345_STAT_ERR_UNSPPORT4_BB_SHIFT                                                  28
  #define PCIEIP_REG_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT4_BB                                                (0x1<<29) // 
  #define PCIEIP_REG_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT4_BB_SHIFT                                          29
  #define PCIEIP_REG_TL_FUNC345_STAT_UNUSED_1_BB                                                             (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC345_STAT_UNUSED_1_BB_SHIFT                                                       30
#define PCIEIP_REG_TL_FUNC678_MASK_BB                                                                        0x000858UL //Access:RW   DataWidth:0x20   // This register masks specific errors from setting pcie_err_attn.
  #define PCIEIP_REG_TL_FUNC678_MASK_PES5_MASK_BB                                                            (0x1<<0) // Poisoned Error Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_PES5_MASK_BB_SHIFT                                                      0
  #define PCIEIP_REG_TL_FUNC678_MASK_FCPES5_MASK_BB                                                          (0x1<<1) // Flow Control Protocol Error Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_FCPES5_MASK_BB_SHIFT                                                    1
  #define PCIEIP_REG_TL_FUNC678_MASK_CTS5_MASK_BB                                                            (0x1<<2) // Completer Timeout Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_CTS5_MASK_BB_SHIFT                                                      2
  #define PCIEIP_REG_TL_FUNC678_MASK_RX_UR5_MASK_BB                                                          (0x1<<3) // Received UR Status, Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_RX_UR5_MASK_BB_SHIFT                                                    3
  #define PCIEIP_REG_TL_FUNC678_MASK_UCS5_MASK_BB                                                            (0x1<<4) // Unexpected Completion Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_UCS5_MASK_BB_SHIFT                                                      4
  #define PCIEIP_REG_TL_FUNC678_MASK_ROS5_MASK_BB                                                            (0x1<<5) // Receiver Overflow Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_ROS5_MASK_BB_SHIFT                                                      5
  #define PCIEIP_REG_TL_FUNC678_MASK_MTLPS5_MASK_BB                                                          (0x1<<6) // Malformed TLP Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_MTLPS5_MASK_BB_SHIFT                                                    6
  #define PCIEIP_REG_TL_FUNC678_MASK_ECRCS5_MASK_BB                                                          (0x1<<7) // ECRC Error TLP Status Status Mask. If set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_ECRCS5_MASK_BB_SHIFT                                                    7
  #define PCIEIP_REG_TL_FUNC678_MASK_URES5_MASK_BB                                                           (0x1<<8) // Unsupported Request Error Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_URES5_MASK_BB_SHIFT                                                     8
  #define PCIEIP_REG_TL_FUNC678_MASK_RXTABRT5_MASK_BB                                                        (0x1<<9) // Received target Abort Error Status Mask. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_RXTABRT5_MASK_BB_SHIFT                                                  9
  #define PCIEIP_REG_TL_FUNC678_MASK_PES6_MASK_BB                                                            (0x1<<10) // Poisoned Error Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_PES6_MASK_BB_SHIFT                                                      10
  #define PCIEIP_REG_TL_FUNC678_MASK_FCPES6_MASK_BB                                                          (0x1<<11) // Flow Control Protocol Error Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_FCPES6_MASK_BB_SHIFT                                                    11
  #define PCIEIP_REG_TL_FUNC678_MASK_CTS6_MASK_BB                                                            (0x1<<12) // Completer Timeout Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_CTS6_MASK_BB_SHIFT                                                      12
  #define PCIEIP_REG_TL_FUNC678_MASK_RX_UR6_MASK_BB                                                          (0x1<<13) // Received UR Status, Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_RX_UR6_MASK_BB_SHIFT                                                    13
  #define PCIEIP_REG_TL_FUNC678_MASK_UCS6_MASK_BB                                                            (0x1<<14) // Unexpected Completion Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_UCS6_MASK_BB_SHIFT                                                      14
  #define PCIEIP_REG_TL_FUNC678_MASK_ROS6_MASK_BB                                                            (0x1<<15) // Receiver Overflow Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_ROS6_MASK_BB_SHIFT                                                      15
  #define PCIEIP_REG_TL_FUNC678_MASK_MTLPS6_MASK_BB                                                          (0x1<<16) // Malformed TLP Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_MTLPS6_MASK_BB_SHIFT                                                    16
  #define PCIEIP_REG_TL_FUNC678_MASK_ECRCS6_MASK_BB                                                          (0x1<<17) // ECRC Error TLP Status Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_ECRCS6_MASK_BB_SHIFT                                                    17
  #define PCIEIP_REG_TL_FUNC678_MASK_URES6_MASK_BB                                                           (0x1<<18) // Unsupported Request Error Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_URES6_MASK_BB_SHIFT                                                     18
  #define PCIEIP_REG_TL_FUNC678_MASK_RXTABRT6_MASK_BB                                                        (0x1<<19) // Received target Abort Error Status Mask for Function6. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_RXTABRT6_MASK_BB_SHIFT                                                  19
  #define PCIEIP_REG_TL_FUNC678_MASK_PES7_MASK_BB                                                            (0x1<<20) // Poisoned Error Status Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_PES7_MASK_BB_SHIFT                                                      20
  #define PCIEIP_REG_TL_FUNC678_MASK_FCPES7_MASK_BB                                                          (0x1<<21) // Flow Control Protocol Error Status Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_FCPES7_MASK_BB_SHIFT                                                    21
  #define PCIEIP_REG_TL_FUNC678_MASK_CTS7_MASK_BB                                                            (0x1<<22) // Completer Timeout Status Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_CTS7_MASK_BB_SHIFT                                                      22
  #define PCIEIP_REG_TL_FUNC678_MASK_RX_UR7_MASK_BB                                                          (0x1<<23) // Received UR Status, Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_RX_UR7_MASK_BB_SHIFT                                                    23
  #define PCIEIP_REG_TL_FUNC678_MASK_UCS7_MASK_BB                                                            (0x1<<24) // Unexpected Completion Status Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_UCS7_MASK_BB_SHIFT                                                      24
  #define PCIEIP_REG_TL_FUNC678_MASK_ROS7_MASK_BB                                                            (0x1<<25) // Receiver Overflow Status Status Mask for Function7, if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_ROS7_MASK_BB_SHIFT                                                      25
  #define PCIEIP_REG_TL_FUNC678_MASK_MTLPS7_MASK_BB                                                          (0x1<<26) // Malformed TLP Status Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_MTLPS7_MASK_BB_SHIFT                                                    26
  #define PCIEIP_REG_TL_FUNC678_MASK_ECRCS7_MASK_BB                                                          (0x1<<27) // ECRC Error TLP Status Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen..
  #define PCIEIP_REG_TL_FUNC678_MASK_ECRCS7_MASK_BB_SHIFT                                                    27
  #define PCIEIP_REG_TL_FUNC678_MASK_URES7_MASK_BB                                                           (0x1<<28) // Unsupported Request Error Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_URES7_MASK_BB_SHIFT                                                     28
  #define PCIEIP_REG_TL_FUNC678_MASK_RXTABRT7_MASK_BB                                                        (0x1<<29) // Received target Abort Error Status Mask for Function7. if set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC678_MASK_RXTABRT7_MASK_BB_SHIFT                                                  29
  #define PCIEIP_REG_TL_FUNC678_MASK_UNUSED_1_BB                                                             (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC678_MASK_UNUSED_1_BB_SHIFT                                                       30
#define PCIEIP_REG_TL_FUNC678_STAT_BB                                                                        0x00085cUL //Access:RW   DataWidth:0x20   // This register stores the status of errors to generate pcie_err_attn.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_PSND_TLP5_BB                                                        (0x1<<0) // Poisoned Error Status detected for Function 5. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_PSND_TLP5_BB_SHIFT                                                  0
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_FC_PRTL5_BB                                                         (0x1<<1) // Flow Control Protocol Error Status detected for Function 5, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_FC_PRTL5_BB_SHIFT                                                   1
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_CPL_TIMEOUT5_BB                                                     (0x1<<2) // Completer Timeout Status detected for Function 5. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_CPL_TIMEOUT5_BB_SHIFT                                               2
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MASTER_ABRT5_BB                                                     (0x1<<3) // Receive UR Status detectedfor Function 5. If set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MASTER_ABRT5_BB_SHIFT                                               3
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNEXP_CPL5_BB                                                       (0x1<<4) // Unexpected Completion Status detected for Function 5, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNEXP_CPL5_BB_SHIFT                                                 4
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_RX_OFLOW5_BB                                                        (0x1<<5) // Receiver Overflow Status detected for Function 5. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_RX_OFLOW5_BB_SHIFT                                                  5
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MALF_TLP5_BB                                                        (0x1<<6) // Malformed TLP Status detected for Function 5. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MALF_TLP5_BB_SHIFT                                                  6
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_ECRC5_BB                                                            (0x1<<7) // ECRC Error TLP Status detected for Function 5. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_ECRC5_BB_SHIFT                                                      7
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNSPPORT5_BB                                                        (0x1<<8) // Unsupported Request Error Status detected for Function 5. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNSPPORT5_BB_SHIFT                                                  8
  #define PCIEIP_REG_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT5_BB                                                (0x1<<9) // 
  #define PCIEIP_REG_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT5_BB_SHIFT                                          9
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_PSND_TLP6_BB                                                        (0x1<<10) // Poisoned Error Status detected in function 6. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_PSND_TLP6_BB_SHIFT                                                  10
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_FC_PRTL6_BB                                                         (0x1<<11) // Flow Control Protocol Error Status detected in function 6, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_FC_PRTL6_BB_SHIFT                                                   11
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_CPL_TIMEOUT6_BB                                                     (0x1<<12) // Completer Timeout Status detected in function 6. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_CPL_TIMEOUT6_BB_SHIFT                                               12
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MASTER_ABRT6_BB                                                     (0x1<<13) // Receive UR Status detectedin function 6. If set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MASTER_ABRT6_BB_SHIFT                                               13
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNEXP_CPL6_BB                                                       (0x1<<14) // Unexpected Completion Status detected in function 6, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNEXP_CPL6_BB_SHIFT                                                 14
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_RX_OFLOW6_BB                                                        (0x1<<15) // Receiver Overflow Status detected in function 6. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_RX_OFLOW6_BB_SHIFT                                                  15
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MALF_TLP6_BB                                                        (0x1<<16) // Malformed TLP Status detected in function 6. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MALF_TLP6_BB_SHIFT                                                  16
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_ECRC6_BB                                                            (0x1<<17) // ECRC Error TLP Status detected in function 6. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_ECRC6_BB_SHIFT                                                      17
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNSPPORT6_BB                                                        (0x1<<18) // Unsupported Request Error Status detected in function6. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNSPPORT6_BB_SHIFT                                                  18
  #define PCIEIP_REG_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT6_BB                                                (0x1<<19) // 
  #define PCIEIP_REG_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT6_BB_SHIFT                                          19
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_PSND_TLP7_BB                                                        (0x1<<20) // Poisoned Error Status detected in function 7. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_PSND_TLP7_BB_SHIFT                                                  20
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_FC_PRTL7_BB                                                         (0x1<<21) // Flow Control Protocol Error Status detected in function 7, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_FC_PRTL7_BB_SHIFT                                                   21
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_CPL_TIMEOUT7_BB                                                     (0x1<<22) // Completer Timeout Status detected in function 7. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_CPL_TIMEOUT7_BB_SHIFT                                               22
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MASTER_ABRT7_BB                                                     (0x1<<23) // Receive UR Status detectedin function 7. If set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MASTER_ABRT7_BB_SHIFT                                               23
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNEXP_CPL7_BB                                                       (0x1<<24) // Unexpected Completion Status detected in function 7, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNEXP_CPL7_BB_SHIFT                                                 24
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_RX_OFLOW7_BB                                                        (0x1<<25) // Receiver Overflow Status detected in function 7. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_RX_OFLOW7_BB_SHIFT                                                  25
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MALF_TLP7_BB                                                        (0x1<<26) // Malformed TLP Status detected in function 7. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_MALF_TLP7_BB_SHIFT                                                  26
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_ECRC7_BB                                                            (0x1<<27) // ECRC Error TLP Status detected in function 7. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_ECRC7_BB_SHIFT                                                      27
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNSPPORT7_BB                                                        (0x1<<28) // Unsupported Request Error Status detected in function7. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC678_STAT_ERR_UNSPPORT7_BB_SHIFT                                                  28
  #define PCIEIP_REG_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT7_BB                                                (0x1<<29) // 
  #define PCIEIP_REG_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT7_BB_SHIFT                                          29
  #define PCIEIP_REG_TL_FUNC678_STAT_UNUSED_1_BB                                                             (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC678_STAT_UNUSED_1_BB_SHIFT                                                       30
#define PCIEIP_REG_FUNC_INT_SEL_BB                                                                           0x000860UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC0_INT_SEL_BB                                                           (0x7<<0) // Route the interrupt pin for Function 0 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC0_INT_SEL_BB_SHIFT                                                     0
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC1_INT_SEL_BB                                                           (0x7<<3) // Route the interrupt pin for Function 1 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC1_INT_SEL_BB_SHIFT                                                     3
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC2_INT_SEL_BB                                                           (0x7<<6) // Route the interrupt pin for Function 2 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC2_INT_SEL_BB_SHIFT                                                     6
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC3_INT_SEL_BB                                                           (0x7<<9) // Route the interrupt pin for Function 3 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC3_INT_SEL_BB_SHIFT                                                     9
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC4_INT_SEL_BB                                                           (0x7<<12) // Route the interrupt pin for Function 4 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC4_INT_SEL_BB_SHIFT                                                     12
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC5_INT_SEL_BB                                                           (0x7<<15) // Route the interrupt pin for Function 5 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC5_INT_SEL_BB_SHIFT                                                     15
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC6_INT_SEL_BB                                                           (0x7<<18) // Route the interrupt pin for Function 6 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC6_INT_SEL_BB_SHIFT                                                     18
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC7_INT_SEL_BB                                                           (0x7<<21) // Route the interrupt pin for Function 7 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL_FUNC7_INT_SEL_BB_SHIFT                                                     21
  #define PCIEIP_REG_FUNC_INT_SEL_UNUSED0_BB                                                                 (0xff<<24) // 
  #define PCIEIP_REG_FUNC_INT_SEL_UNUSED0_BB_SHIFT                                                           24
#define PCIEIP_REG_FUNC_INT_SEL2_BB                                                                          0x000864UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC8_INT_SEL_BB                                                          (0x7<<0) // Route the interrupt pin for Function 0 8o any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC8_INT_SEL_BB_SHIFT                                                    0
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC9_INT_SEL_BB                                                          (0x7<<3) // Route the interrupt pin for Function 9 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC9_INT_SEL_BB_SHIFT                                                    3
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC10_INT_SEL_BB                                                         (0x7<<6) // Route the interrupt pin for Function 10 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC10_INT_SEL_BB_SHIFT                                                   6
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC11_INT_SEL_BB                                                         (0x7<<9) // Route the interrupt pin for Function 11 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC11_INT_SEL_BB_SHIFT                                                   9
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC12_INT_SEL_BB                                                         (0x7<<12) // Route the interrupt pin for Function 12 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC12_INT_SEL_BB_SHIFT                                                   12
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC13_INT_SEL_BB                                                         (0x7<<15) // Route the interrupt pin for Function 13 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC13_INT_SEL_BB_SHIFT                                                   15
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC14_INT_SEL_BB                                                         (0x7<<18) // Route the interrupt pin for Function 14 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC14_INT_SEL_BB_SHIFT                                                   18
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC15_INT_SEL_BB                                                         (0x7<<21) // Route the interrupt pin for Function 15 to any of INTA to INTD or no interrupt.
  #define PCIEIP_REG_FUNC_INT_SEL2_FUNC15_INT_SEL_BB_SHIFT                                                   21
  #define PCIEIP_REG_FUNC_INT_SEL2_UNUSED0_BB                                                                (0xff<<24) // 
  #define PCIEIP_REG_FUNC_INT_SEL2_UNUSED0_BB_SHIFT                                                          24
#define PCIEIP_REG_TL_RST_CTRL_BB                                                                            0x000868UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_RST_CTRL_SEL_DIS_MDIO_PERST_BB                                                       (0x1<<0) // This bit when cleared will keep the Serdes MDIO regs in reset till PERST_N is released. Default behavior is to release Serdes MDIO from reset on Vaux power being present.
  #define PCIEIP_REG_TL_RST_CTRL_SEL_DIS_MDIO_PERST_BB_SHIFT                                                 0
  #define PCIEIP_REG_TL_RST_CTRL_SEL_DIS_UC_PERST_BB                                                         (0x1<<1) // This bit when cleared will keep the micro in reset till PERST_N is released. Default behavior is to release micro from reset on Vaux power being present.
  #define PCIEIP_REG_TL_RST_CTRL_SEL_DIS_UC_PERST_BB_SHIFT                                                   1
  #define PCIEIP_REG_TL_RST_CTRL_SOFT_MDIO_RST_BB                                                            (0x1<<2) // This bit when set will reset the Serdes register space, provided bit 3 is also set.
  #define PCIEIP_REG_TL_RST_CTRL_SOFT_MDIO_RST_BB_SHIFT                                                      2
  #define PCIEIP_REG_TL_RST_CTRL_SEL_SOFT_MDIO_RST_BB                                                        (0x1<<3) // Tthis bit when set will allow bit 2 value to propogate to Serdes. This bit acts as the mux sel for a soft MDIO reset.
  #define PCIEIP_REG_TL_RST_CTRL_SEL_SOFT_MDIO_RST_BB_SHIFT                                                  3
  #define PCIEIP_REG_TL_RST_CTRL_SOFT_UC_RST_BB                                                              (0x1<<4) // This bit when set will reset the micro, provided bit 5 is also set.
  #define PCIEIP_REG_TL_RST_CTRL_SOFT_UC_RST_BB_SHIFT                                                        4
  #define PCIEIP_REG_TL_RST_CTRL_SEL_SOFT_UC_RST_BB                                                          (0x1<<5) // For gen3 serdes, this bit when set will allow bit 4 value to propogate to uc reset. This bit acts as the mux sel for a soft micro reset.
  #define PCIEIP_REG_TL_RST_CTRL_SEL_SOFT_UC_RST_BB_SHIFT                                                    5
  #define PCIEIP_REG_TL_RST_CTRL_UNUSED0_BB                                                                  (0x3<<6) // 
  #define PCIEIP_REG_TL_RST_CTRL_UNUSED0_BB_SHIFT                                                            6
  #define PCIEIP_REG_TL_RST_CTRL_ENABLE_ALT_MSG_ERROR_BB                                                     (0x1<<8) // Based on 3.0 errata, allows interpreting Rx messages with routing errors or hdr type errors to be UR instead of malformed.
  #define PCIEIP_REG_TL_RST_CTRL_ENABLE_ALT_MSG_ERROR_BB_SHIFT                                               8
  #define PCIEIP_REG_TL_RST_CTRL_RESERVED_BB                                                                 (0x7fffff<<9) // 
  #define PCIEIP_REG_TL_RST_CTRL_RESERVED_BB_SHIFT                                                           9
#define PCIEIP_REG_TL_OBFF_CTRL_BB                                                                           0x000870UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_OBFF_CTRL_MIN_OBFF_PULSE_BB                                                          (0x7f<<0) // Min number of PM clocks to wait after WAKE# signal transition, so that it is throughly debounced.
  #define PCIEIP_REG_TL_OBFF_CTRL_MIN_OBFF_PULSE_BB_SHIFT                                                    0
  #define PCIEIP_REG_TL_OBFF_CTRL_UNUSED0_BB                                                                 (0x1<<7) // 
  #define PCIEIP_REG_TL_OBFF_CTRL_UNUSED0_BB_SHIFT                                                           7
  #define PCIEIP_REG_TL_OBFF_CTRL_MAX_OBFF_PULSE_BB                                                          (0x7f<<8) // Max number of PM clocks to wait after WAKE# signal transition to declare OBFF state
  #define PCIEIP_REG_TL_OBFF_CTRL_MAX_OBFF_PULSE_BB_SHIFT                                                    8
  #define PCIEIP_REG_TL_OBFF_CTRL_UNUSED1_BB                                                                 (0x1<<15) // 
  #define PCIEIP_REG_TL_OBFF_CTRL_UNUSED1_BB_SHIFT                                                           15
  #define PCIEIP_REG_TL_OBFF_CTRL_RESERVED_BB                                                                (0xffff<<16) // 
  #define PCIEIP_REG_TL_OBFF_CTRL_RESERVED_BB_SHIFT                                                          16
#define PCIEIP_REG_TL_CTLSTAT_0_BB                                                                           0x000874UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_1_HIDDEN_BB                                                      (0x1<<0) // Set if func1 is hidden either due to hide_func_1 pad being driven high or due to programming bit in TL reg This bit is tied to 0, if IP does not support multiple functions.
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_1_HIDDEN_BB_SHIFT                                                0
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_2_HIDDEN_BB                                                      (0x1<<1) // Set if func2 is hidden either due to hide_func_2 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_2_HIDDEN_BB_SHIFT                                                1
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_3_HIDDEN_BB                                                      (0x1<<2) // Set if func3 is hidden either due to hide_func_3 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_3_HIDDEN_BB_SHIFT                                                2
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_4_HIDDEN_BB                                                      (0x1<<3) // Set if func4 is hidden either due to hide_func_4 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_4_HIDDEN_BB_SHIFT                                                3
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_5_HIDDEN_BB                                                      (0x1<<4) // Set if func5 is hidden either due to hide_func_5 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_5_HIDDEN_BB_SHIFT                                                4
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_6_HIDDEN_BB                                                      (0x1<<5) // Set if func6 is hidden either due to hide_func_6 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_6_HIDDEN_BB_SHIFT                                                5
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_7_HIDDEN_BB                                                      (0x1<<6) // Set if func7 is hidden either due to hide_func_7 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_7_HIDDEN_BB_SHIFT                                                6
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_8_HIDDEN_BB                                                      (0x1<<7) // Set if func8 is hidden either due to hide_func_8 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_8_HIDDEN_BB_SHIFT                                                7
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_9_HIDDEN_BB                                                      (0x1<<8) // Set if func9 is hidden either due to hide_func_9 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_9_HIDDEN_BB_SHIFT                                                8
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_10_HIDDEN_BB                                                     (0x1<<9) // Set if func10 is hidden either due to hide_func_10 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_10_HIDDEN_BB_SHIFT                                               9
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_11_HIDDEN_BB                                                     (0x1<<10) // Set if func11 is hidden either due to hide_func_11 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_11_HIDDEN_BB_SHIFT                                               10
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_12_HIDDEN_BB                                                     (0x1<<11) // Set if func12 is hidden either due to hide_func_12 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_12_HIDDEN_BB_SHIFT                                               11
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_13_HIDDEN_BB                                                     (0x1<<12) // Set if func13 is hidden either due to hide_func_13 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_13_HIDDEN_BB_SHIFT                                               12
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_14_HIDDEN_BB                                                     (0x1<<13) // Set if func14 is hidden either due to hide_func_14 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_14_HIDDEN_BB_SHIFT                                               13
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_15_HIDDEN_BB                                                     (0x1<<14) // Set if func15 is hidden either due to hide_func_15 pad being driven high or due to programming bit in TL reg
  #define PCIEIP_REG_TL_CTLSTAT_0_PCIE_FUNC_15_HIDDEN_BB_SHIFT                                               14
  #define PCIEIP_REG_TL_CTLSTAT_0_UNUSED0_BB                                                                 (0x7<<15) // 
  #define PCIEIP_REG_TL_CTLSTAT_0_UNUSED0_BB_SHIFT                                                           15
  #define PCIEIP_REG_TL_CTLSTAT_0_TL_DBG_MALF_ERR_BB                                                         (0x3fff<<18) // debug status for sources of malformed TLP error.
  #define PCIEIP_REG_TL_CTLSTAT_0_TL_DBG_MALF_ERR_BB_SHIFT                                                   18
#define PCIEIP_REG_PM_STATUS_0_BB                                                                            0x000878UL //Access:R    DataWidth:0x20   // For Debug.
  #define PCIEIP_REG_PM_STATUS_0_PME_SENT_SM0_BB                                                             (0x1f<<0) // State machine that handles PME for Function
  #define PCIEIP_REG_PM_STATUS_0_PME_SENT_SM0_BB_SHIFT                                                       0
  #define PCIEIP_REG_PM_STATUS_0_UNUSED0_BB                                                                  (0x7ff<<5) // 
  #define PCIEIP_REG_PM_STATUS_0_UNUSED0_BB_SHIFT                                                            5
  #define PCIEIP_REG_PM_STATUS_0_OBFF_CURR_STATE_BB                                                          (0xf<<16) // State machine that handles OBFF for Function
  #define PCIEIP_REG_PM_STATUS_0_OBFF_CURR_STATE_BB_SHIFT                                                    16
  #define PCIEIP_REG_PM_STATUS_0_PCIE_OBFF_STATE_BB                                                          (0xf<<20) // Current OBFF state Indication from DUT.
  #define PCIEIP_REG_PM_STATUS_0_PCIE_OBFF_STATE_BB_SHIFT                                                    20
  #define PCIEIP_REG_PM_STATUS_0_PM_LINK_STATE_SM_BB                                                         (0xff<<24) // State machine that controls current PM Link state.
  #define PCIEIP_REG_PM_STATUS_0_PM_LINK_STATE_SM_BB_SHIFT                                                   24
#define PCIEIP_REG_PM_STATUS_1_BB                                                                            0x00087cUL //Access:R    DataWidth:0x20   // For Debug.
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_ENABLE0_BB                                                          (0x1<<0) // Direct reflection of Config PM PME enable bit for function 0.
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_ENABLE0_BB_SHIFT                                                    0
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_STATUS0_BB                                                          (0x1<<1) // Direct reflection of config PM PME status bit for function 0.
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_STATUS0_BB_SHIFT                                                    1
  #define PCIEIP_REG_PM_STATUS_1_CFG_AUX_PWR_PM_EN0_BB                                                       (0x1<<2) // Direct reflection of CFG link control, Aux power PM enabled.
  #define PCIEIP_REG_PM_STATUS_1_CFG_AUX_PWR_PM_EN0_BB_SHIFT                                                 2
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_ENABLE1_BB                                                          (0x1<<3) // Direct reflection of Config PM PME enable bit for function 1.
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_ENABLE1_BB_SHIFT                                                    3
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_STATUS1_BB                                                          (0x1<<4) // Direct reflection of config PM PME status bit for function 1.
  #define PCIEIP_REG_PM_STATUS_1_CFG_PME_STATUS1_BB_SHIFT                                                    4
  #define PCIEIP_REG_PM_STATUS_1_CFG_AUX_PWR_PM_EN1_BB                                                       (0x1<<5) // Direct reflection of CFG link control, Aux power PM enabled.
  #define PCIEIP_REG_PM_STATUS_1_CFG_AUX_PWR_PM_EN1_BB_SHIFT                                                 5
  #define PCIEIP_REG_PM_STATUS_1_UNUSED0_BB                                                                  (0x3ffff<<6) // 
  #define PCIEIP_REG_PM_STATUS_1_UNUSED0_BB_SHIFT                                                            6
  #define PCIEIP_REG_PM_STATUS_1_REG_BUS_NUM_BB                                                              (0xff<<24) // Current Bus Number Latched by device.
  #define PCIEIP_REG_PM_STATUS_1_REG_BUS_NUM_BB_SHIFT                                                        24
#define PCIEIP_REG_TL_FUNC8TO10_MASK_BB                                                                      0x000880UL //Access:RW   DataWidth:0x20   // This register masks specific errors from setting pcie_err_attn for functions 8, 9, and 10.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_PES8_MASK_BB                                                          (0x1<<0) // Poisoned Error Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_PES8_MASK_BB_SHIFT                                                    0
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_FCPES8_MASK_BB                                                        (0x1<<1) // Flow Control Protocol Error Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_FCPES8_MASK_BB_SHIFT                                                  1
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_CTS8_MASK_BB                                                          (0x1<<2) // Completer Timeout Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_CTS8_MASK_BB_SHIFT                                                    2
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RX_UR8_MASK_BB                                                        (0x1<<3) // Received UR Status, Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RX_UR8_MASK_BB_SHIFT                                                  3
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UCS8_MASK_BB                                                          (0x1<<4) // Unexpected Completion Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UCS8_MASK_BB_SHIFT                                                    4
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ROS8_MASK_BB                                                          (0x1<<5) // Receiver Overflow Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ROS8_MASK_BB_SHIFT                                                    5
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_MTLPS8_MASK_BB                                                        (0x1<<6) // Malformed TLP Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_MTLPS8_MASK_BB_SHIFT                                                  6
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ECRCS8_MASK_BB                                                        (0x1<<7) // ECRC Error TLP Status Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ECRCS8_MASK_BB_SHIFT                                                  7
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_URES8_MASK_BB                                                         (0x1<<8) // Unsupported Request Error Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_URES8_MASK_BB_SHIFT                                                   8
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RXTABRT8_MASK_BB                                                      (0x1<<9) // Received target Abort Error Status Mask for Function8. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RXTABRT8_MASK_BB_SHIFT                                                9
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_PES9_MASK_BB                                                          (0x1<<10) // Poisoned Error Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_PES9_MASK_BB_SHIFT                                                    10
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_FCPES9_MASK_BB                                                        (0x1<<11) // Flow Control Protocol Error Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_FCPES9_MASK_BB_SHIFT                                                  11
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_CTS9_MASK_BB                                                          (0x1<<12) // Completer Timeout Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_CTS9_MASK_BB_SHIFT                                                    12
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RX_UR9_MASK_BB                                                        (0x1<<13) // Received UR Status, Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RX_UR9_MASK_BB_SHIFT                                                  13
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UCS9_MASK_BB                                                          (0x1<<14) // Unexpected Completion Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UCS9_MASK_BB_SHIFT                                                    14
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ROS9_MASK_BB                                                          (0x1<<15) // Receiver Overflow Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ROS9_MASK_BB_SHIFT                                                    15
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_MTLPS9_MASK_BB                                                        (0x1<<16) // Malformed TLP Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_MTLPS9_MASK_BB_SHIFT                                                  16
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ECRCS9_MASK_BB                                                        (0x1<<17) // ECRC Error TLP Status Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ECRCS9_MASK_BB_SHIFT                                                  17
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_URES9_MASK_BB                                                         (0x1<<18) // Unsupported Request Error Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_URES9_MASK_BB_SHIFT                                                   18
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RXTABRT9_MASK_BB                                                      (0x1<<19) // Received target Abort Error Status Mask for Function9. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RXTABRT9_MASK_BB_SHIFT                                                19
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_PES10_MASK_BB                                                         (0x1<<20) // Poisoned Error Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_PES10_MASK_BB_SHIFT                                                   20
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_FCPES10_MASK_BB                                                       (0x1<<21) // Flow Control Protocol Error Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_FCPES10_MASK_BB_SHIFT                                                 21
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_CTS10_MASK_BB                                                         (0x1<<22) // Completer Timeout Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_CTS10_MASK_BB_SHIFT                                                   22
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RX_UR10_MASK_BB                                                       (0x1<<23) // Received UR Status, Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RX_UR10_MASK_BB_SHIFT                                                 23
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UCS10_MASK_BB                                                         (0x1<<24) // Unexpected Completion Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UCS10_MASK_BB_SHIFT                                                   24
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ROS10_MASK_BB                                                         (0x1<<25) // Receiver Overflow Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ROS10_MASK_BB_SHIFT                                                   25
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_MTLPS10_MASK_BB                                                       (0x1<<26) // Malformed TLP Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_MTLPS10_MASK_BB_SHIFT                                                 26
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ECRCS10_MASK_BB                                                       (0x1<<27) // ECRC Error TLP Status Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_ECRCS10_MASK_BB_SHIFT                                                 27
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_URES10_MASK_BB                                                        (0x1<<28) // Unsupported Request Error Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_URES10_MASK_BB_SHIFT                                                  28
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RXTABRT10_MASK_BB                                                     (0x1<<29) // Received target Abort Error Status Mask for Function10. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_RXTABRT10_MASK_BB_SHIFT                                               29
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UNUSED_1_BB                                                           (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC8TO10_MASK_UNUSED_1_BB_SHIFT                                                     30
#define PCIEIP_REG_TL_FUNC8TO10_STAT_BB                                                                      0x000884UL //Access:RW   DataWidth:0x20   // This register stores the status of errors to generate pcie_err_attn for functions 8, 9, and 10.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_PSND_TLP8_BB                                                      (0x1<<0) // Poisoned Error Status detected for Function 8. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_PSND_TLP8_BB_SHIFT                                                0
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_FC_PRTL8_BB                                                       (0x1<<1) // Flow Control Protocol Error Status detected for Function 8, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_FC_PRTL8_BB_SHIFT                                                 1
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_CPL_TIMEOUT8_BB                                                   (0x1<<2) // Completer Timeout Status detected for Function 8. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_CPL_TIMEOUT8_BB_SHIFT                                             2
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MASTER_ABRT8_BB                                                   (0x1<<3) // Receive UR Status detectedfor Function 8. If set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MASTER_ABRT8_BB_SHIFT                                             3
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNEXP_CPL8_BB                                                     (0x1<<4) // Unexpected Completion Status detected for Function 8, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNEXP_CPL8_BB_SHIFT                                               4
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_RX_OFLOW8_BB                                                      (0x1<<5) // Receiver Overflow Status detected for Function 8. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_RX_OFLOW8_BB_SHIFT                                                5
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MALF_TLP8_BB                                                      (0x1<<6) // Malformed TLP Status detected for Function 8. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MALF_TLP8_BB_SHIFT                                                6
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_ECRC8_BB                                                          (0x1<<7) // ECRC Error TLP Status detected for Function 8. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_ECRC8_BB_SHIFT                                                    7
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNSPPORT8_BB                                                      (0x1<<8) // Unsupported Request Error Status detected for Function 8. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNSPPORT8_BB_SHIFT                                                8
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_PRI_SIG_TARGET_ABORT8_BB                                              (0x1<<9) // 
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_PRI_SIG_TARGET_ABORT8_BB_SHIFT                                        9
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_PSND_TLP9_BB                                                      (0x1<<10) // Poisoned Error Status detected in function 9. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_PSND_TLP9_BB_SHIFT                                                10
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_FC_PRTL9_BB                                                       (0x1<<11) // Flow Control Protocol Error Status detected in function 9, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_FC_PRTL9_BB_SHIFT                                                 11
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_CPL_TIMEOUT9_BB                                                   (0x1<<12) // Completer Timeout Status detected in function 9. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_CPL_TIMEOUT9_BB_SHIFT                                             12
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MASTER_ABRT9_BB                                                   (0x1<<13) // Receive UR Status detectedin function 9. If set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MASTER_ABRT9_BB_SHIFT                                             13
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNEXP_CPL9_BB                                                     (0x1<<14) // Unexpected Completion Status detected in function 9, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNEXP_CPL9_BB_SHIFT                                               14
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_RX_OFLOW9_BB                                                      (0x1<<15) // Receiver Overflow Status detected in function 9. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_RX_OFLOW9_BB_SHIFT                                                15
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MALF_TLP9_BB                                                      (0x1<<16) // Malformed TLP Status detected in function 9. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MALF_TLP9_BB_SHIFT                                                16
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_ECRC9_BB                                                          (0x1<<17) // ECRC Error TLP Status detected in function 9. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_ECRC9_BB_SHIFT                                                    17
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNSPPORT9_BB                                                      (0x1<<18) // Unsupported Request Error Status detected in function9. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNSPPORT9_BB_SHIFT                                                18
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_PRI_SIG_TARGET_ABORT9_BB                                              (0x1<<19) // 
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_PRI_SIG_TARGET_ABORT9_BB_SHIFT                                        19
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_PSND_TLP10_BB                                                     (0x1<<20) // Poisoned Error Status detected in function 10. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_PSND_TLP10_BB_SHIFT                                               20
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_FC_PRTL10_BB                                                      (0x1<<21) // Flow Control Protocol Error Status detected in function 10, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_FC_PRTL10_BB_SHIFT                                                21
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_CPL_TIMEOUT10_BB                                                  (0x1<<22) // Completer Timeout Status detected in function 10. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_CPL_TIMEOUT10_BB_SHIFT                                            22
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MASTER_ABRT10_BB                                                  (0x1<<23) // Receive UR Status detectedin function 10. If set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MASTER_ABRT10_BB_SHIFT                                            23
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNEXP_CPL10_BB                                                    (0x1<<24) // Unexpected Completion Status detected in function 10, if set, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNEXP_CPL10_BB_SHIFT                                              24
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_RX_OFLOW10_BB                                                     (0x1<<25) // Receiver Overflow Status detected in function 10. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_RX_OFLOW10_BB_SHIFT                                               25
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MALF_TLP10_BB                                                     (0x1<<26) // Malformed TLP Status detected in function 10. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_MALF_TLP10_BB_SHIFT                                               26
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_ECRC10_BB                                                         (0x1<<27) // ECRC Error TLP Status detected in function 10. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_ECRC10_BB_SHIFT                                                   27
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNSPPORT10_BB                                                     (0x1<<28) // Unsupported Request Error Status detected in function10. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_ERR_UNSPPORT10_BB_SHIFT                                               28
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_PRI_SIG_TARGET_ABORT10_BB                                             (0x1<<29) // 
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_PRI_SIG_TARGET_ABORT10_BB_SHIFT                                       29
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_UNUSED_1_BB                                                           (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC8TO10_STAT_UNUSED_1_BB_SHIFT                                                     30
#define PCIEIP_REG_TL_FUNC11TO13_MASK_BB                                                                     0x000888UL //Access:RW   DataWidth:0x20   // This register masks specific errors from setting pcie_err_attn for functions 11, 12, and 13.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_PES11_MASK_BB                                                        (0x1<<0) // Poisoned Error Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_PES11_MASK_BB_SHIFT                                                  0
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_FCPES11_MASK_BB                                                      (0x1<<1) // Flow Control Protocol Error Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_FCPES11_MASK_BB_SHIFT                                                1
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_CTS11_MASK_BB                                                        (0x1<<2) // Completer Timeout Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_CTS11_MASK_BB_SHIFT                                                  2
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RX_UR11_MASK_BB                                                      (0x1<<3) // Received UR Status, Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RX_UR11_MASK_BB_SHIFT                                                3
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UCS11_MASK_BB                                                        (0x1<<4) // Unexpected Completion Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UCS11_MASK_BB_SHIFT                                                  4
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ROS11_MASK_BB                                                        (0x1<<5) // Receiver Overflow Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ROS11_MASK_BB_SHIFT                                                  5
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_MTLPS11_MASK_BB                                                      (0x1<<6) // Malformed TLP Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_MTLPS11_MASK_BB_SHIFT                                                6
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ECRCS11_MASK_BB                                                      (0x1<<7) // ECRC Error TLP Status Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ECRCS11_MASK_BB_SHIFT                                                7
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_URES11_MASK_BB                                                       (0x1<<8) // Unsupported Request Error Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_URES11_MASK_BB_SHIFT                                                 8
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RXTABRT11_MASK_BB                                                    (0x1<<9) // Received target Abort Error Status Mask for Function11. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RXTABRT11_MASK_BB_SHIFT                                              9
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_PES12_MASK_BB                                                        (0x1<<10) // Poisoned Error Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_PES12_MASK_BB_SHIFT                                                  10
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_FCPES12_MASK_BB                                                      (0x1<<11) // Flow Control Protocol Error Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_FCPES12_MASK_BB_SHIFT                                                11
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_CTS12_MASK_BB                                                        (0x1<<12) // Completer Timeout Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_CTS12_MASK_BB_SHIFT                                                  12
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RX_UR12_MASK_BB                                                      (0x1<<13) // Received UR Status, Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RX_UR12_MASK_BB_SHIFT                                                13
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UCS12_MASK_BB                                                        (0x1<<14) // Unexpected Completion Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UCS12_MASK_BB_SHIFT                                                  14
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ROS12_MASK_BB                                                        (0x1<<15) // Receiver Overflow Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ROS12_MASK_BB_SHIFT                                                  15
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_MTLPS12_MASK_BB                                                      (0x1<<16) // Malformed TLP Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_MTLPS12_MASK_BB_SHIFT                                                16
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ECRCS12_MASK_BB                                                      (0x1<<17) // ECRC Error TLP Status Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ECRCS12_MASK_BB_SHIFT                                                17
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_URES12_MASK_BB                                                       (0x1<<18) // Unsupported Request Error Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_URES12_MASK_BB_SHIFT                                                 18
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RXTABRT12_MASK_BB                                                    (0x1<<19) // Received target Abort Error Status Mask for Function12. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RXTABRT12_MASK_BB_SHIFT                                              19
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_PES13_MASK_BB                                                        (0x1<<20) // Poisoned Error Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_PES13_MASK_BB_SHIFT                                                  20
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_FCPES13_MASK_BB                                                      (0x1<<21) // Flow Control Protocol Error Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_FCPES13_MASK_BB_SHIFT                                                21
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_CTS13_MASK_BB                                                        (0x1<<22) // Completer Timeout Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_CTS13_MASK_BB_SHIFT                                                  22
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RX_UR13_MASK_BB                                                      (0x1<<23) // Received UR Status, Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RX_UR13_MASK_BB_SHIFT                                                23
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UCS13_MASK_BB                                                        (0x1<<24) // Unexpected Completion Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UCS13_MASK_BB_SHIFT                                                  24
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ROS13_MASK_BB                                                        (0x1<<25) // Receiver Overflow Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ROS13_MASK_BB_SHIFT                                                  25
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_MTLPS13_MASK_BB                                                      (0x1<<26) // Malformed TLP Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_MTLPS13_MASK_BB_SHIFT                                                26
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ECRCS13_MASK_BB                                                      (0x1<<27) // ECRC Error TLP Status Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_ECRCS13_MASK_BB_SHIFT                                                27
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_URES13_MASK_BB                                                       (0x1<<28) // Unsupported Request Error Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_URES13_MASK_BB_SHIFT                                                 28
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RXTABRT13_MASK_BB                                                    (0x1<<29) // Received target Abort Error Status Mask for Function13. If set, hw does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_RXTABRT13_MASK_BB_SHIFT                                              29
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UNUSED_1_BB                                                          (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC11TO13_MASK_UNUSED_1_BB_SHIFT                                                    30
#define PCIEIP_REG_TL_FUNC11TO13_STAT_BB                                                                     0x00088cUL //Access:RW   DataWidth:0x20   // This register stores the status of errors to generate pcie_err_attn for functions 11, 12, and 13.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_PSND_TLP11_BB                                                    (0x1<<0) // Poisoned Error Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_PSND_TLP11_BB_SHIFT                                              0
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_FC_PRTL11_BB                                                     (0x1<<1) // Flow Control Protocol Error Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_FC_PRTL11_BB_SHIFT                                               1
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_CPL_TIMEOUT11_BB                                                 (0x1<<2) // Completer Timeout Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_CPL_TIMEOUT11_BB_SHIFT                                           2
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MASTER_ABRT11_BB                                                 (0x1<<3) // Receive UR Status detectedfor Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MASTER_ABRT11_BB_SHIFT                                           3
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNEXP_CPL11_BB                                                   (0x1<<4) // Unexpected Completion Status detected for Function 11. If set, hw generates, generate pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNEXP_CPL11_BB_SHIFT                                             4
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_RX_OFLOW11_BB                                                    (0x1<<5) // Receiver Overflow Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_RX_OFLOW11_BB_SHIFT                                              5
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MALF_TLP11_BB                                                    (0x1<<6) // Malformed TLP Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MALF_TLP11_BB_SHIFT                                              6
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_ECRC11_BB                                                        (0x1<<7) // ECRC Error TLP Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_ECRC11_BB_SHIFT                                                  7
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNSPPORT11_BB                                                    (0x1<<8) // Unsupported Request Error Status detected for Function 11. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNSPPORT11_BB_SHIFT                                              8
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_PRI_SIG_TARGET_ABORT11_BB                                            (0x1<<9) // 
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_PRI_SIG_TARGET_ABORT11_BB_SHIFT                                      9
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_PSND_TLP12_BB                                                    (0x1<<10) // Poisoned Error Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_PSND_TLP12_BB_SHIFT                                              10
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_FC_PRTL12_BB                                                     (0x1<<11) // Flow Control Protocol Error Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_FC_PRTL12_BB_SHIFT                                               11
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_CPL_TIMEOUT12_BB                                                 (0x1<<12) // Completer Timeout Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_CPL_TIMEOUT12_BB_SHIFT                                           12
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MASTER_ABRT12_BB                                                 (0x1<<13) // Receive UR Status detectedin function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MASTER_ABRT12_BB_SHIFT                                           13
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNEXP_CPL12_BB                                                   (0x1<<14) // Unexpected Completion Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNEXP_CPL12_BB_SHIFT                                             14
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_RX_OFLOW12_BB                                                    (0x1<<15) // Receiver Overflow Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_RX_OFLOW12_BB_SHIFT                                              15
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MALF_TLP12_BB                                                    (0x1<<16) // Malformed TLP Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MALF_TLP12_BB_SHIFT                                              16
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_ECRC12_BB                                                        (0x1<<17) // ECRC Error TLP Status detected in function 12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_ECRC12_BB_SHIFT                                                  17
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNSPPORT12_BB                                                    (0x1<<18) // Unsupported Request Error Status detected in function12. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNSPPORT12_BB_SHIFT                                              18
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_PRI_SIG_TARGET_ABORT12_BB                                            (0x1<<19) // 
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_PRI_SIG_TARGET_ABORT12_BB_SHIFT                                      19
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_PSND_TLP13_BB                                                    (0x1<<20) // Poisoned Error Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_PSND_TLP13_BB_SHIFT                                              20
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_FC_PRTL13_BB                                                     (0x1<<21) // Flow Control Protocol Error Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_FC_PRTL13_BB_SHIFT                                               21
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_CPL_TIMEOUT13_BB                                                 (0x1<<22) // Completer Timeout Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_CPL_TIMEOUT13_BB_SHIFT                                           22
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MASTER_ABRT13_BB                                                 (0x1<<23) // Receive UR Status detectedin function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MASTER_ABRT13_BB_SHIFT                                           23
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNEXP_CPL13_BB                                                   (0x1<<24) // Unexpected Completion Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNEXP_CPL13_BB_SHIFT                                             24
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_RX_OFLOW13_BB                                                    (0x1<<25) // Receiver Overflow Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_RX_OFLOW13_BB_SHIFT                                              25
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MALF_TLP13_BB                                                    (0x1<<26) // Malformed TLP Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_MALF_TLP13_BB_SHIFT                                              26
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_ECRC13_BB                                                        (0x1<<27) // ECRC Error TLP Status detected in function 13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_ECRC13_BB_SHIFT                                                  27
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNSPPORT13_BB                                                    (0x1<<28) // Unsupported Request Error Status detected in function13. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_ERR_UNSPPORT13_BB_SHIFT                                              28
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_PRI_SIG_TARGET_ABORT13_BB                                            (0x1<<29) // 
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_PRI_SIG_TARGET_ABORT13_BB_SHIFT                                      29
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_UNUSED_1_BB                                                          (0x3<<30) // 
  #define PCIEIP_REG_TL_FUNC11TO13_STAT_UNUSED_1_BB_SHIFT                                                    30
#define PCIEIP_REG_GEN3_RELATED_OFF_K2_E5                                                                    0x000890UL //Access:RW   DataWidth:0x20   // Gen3 Control Register. There is no Gen3-specific N_FTS field. The N_FTS field in the "Link Width and Speed Change Control Register" is used for both Gen2 and Gen3 speed modes. There is no Gen3-specific "Directed Speed Change" field. The "Directed Speed Change" field in the "Link Width and Speed Change Control Register" is used to change to Gen2 or Gen3 speed. A speed change to Gen3 occurs if (1) the "Directed Speed Change" field is set to "1" and (2) the "Target Link Speed" field in the Link Control 2 Register is set to Gen3. Gen3 support is advertised by both sides of the link during link training. M-PCIe doesn't have Conventional PCIe Gen3 feature. The registers of this section do not exist.
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_ZRXDC_NONCOMPL_K2_E5                                              (0x1<<0) // Gen3 Receiver Impedance ZRX-DC Not Compliant. Receivers that operate at 8.0 GT/s with an impedance other than the range defined by the ZRX-DC parameter for 2.5 GT/s (40-60 Ohms) must meet additional behavior requirements in the following LTSSM states: Polling, Rx_L0s, L1, L2, and Disabled.  - 0: The receiver complies with the ZRX-DC parameter for 2.5 GT/s when operating at 8 GT/s or higher.  - 1: The receiver does not comply with the ZRX-DC parameter for 2.5 GT/s when operating at 8 GT/s or higher. Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rates.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_ZRXDC_NONCOMPL_K2_E5_SHIFT                                        0
  #define PCIEIP_REG_GEN3_RELATED_OFF_DISABLE_SCRAMBLER_GEN_3_K2_E5                                          (0x1<<8) // Disable Scrambler for Gen3 and Gen4 Data Rate. The Gen3 and Gen4 scrambler/descrambler within the core needs to be disabled when the scrambling function is implemented outside of the core (for example within the PHY).  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_DISABLE_SCRAMBLER_GEN_3_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_GEN3_RELATED_OFF_EQ_PHASE_2_3_K2_E5                                                     (0x1<<9) // Equalization Phase 2 and Phase 3 Disable. This applies to downstream ports only.  Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: The access attributes of this field are as follows:  - Dbi: see description  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_EQ_PHASE_2_3_K2_E5_SHIFT                                               9
  #define PCIEIP_REG_GEN3_RELATED_OFF_EQ_EIEOS_CNT_K2_E5                                                     (0x1<<10) // Equalization EIEOS Count Reset Disable. Disable requesting reset of EIEOS count during equalization.  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_EQ_EIEOS_CNT_K2_E5_SHIFT                                               10
  #define PCIEIP_REG_GEN3_RELATED_OFF_EQ_REDO_K2_E5                                                          (0x1<<11) // Equalization Redo Disable. Disable autonomous mechanism for requesting to redo the equalization process.  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_EQ_REDO_K2_E5_SHIFT                                                    11
  #define PCIEIP_REG_GEN3_RELATED_OFF_RXEQ_PH01_EN_K2_E5                                                     (0x1<<12) // Rx Equalization Phase 0/Phase 1 Hold Enable. When this bit is set the upstream port holds phase 0 (the downstream port holds phase 1) for 10ms. Holding phase 0 or phase 1 can be used to allow sufficient time for Rx Equalization to be performed by the PHY. This bit is used during Virtex-7 Gen3 equalization. The programmable bits [RXEQ_PH01_EN, EQ_PHASE_2_3] can be used to obtain the following variations of the equalization procedure:  - 00: Tx equalization only in phase 2/3  - 01: No Tx equalization, no Rx equalization  - 10: Tx equalization in phase 2/3, Rx equalization in phase 0/1  - 11: No Tx equalization, Rx equalization in phase 0/1 Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: The access attributes of this field are as follows:  - Dbi: see description  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_RXEQ_PH01_EN_K2_E5_SHIFT                                               12
  #define PCIEIP_REG_GEN3_RELATED_OFF_RXEQ_RGRDLESS_RXTS_K2_E5                                               (0x1<<13) // When set to '1', the core as Gen3 EQ master asserts RxEqEval to instruct the PHY to do Rx adaptation and evaluation after a 500ns timeout from a new preset request.  - 0: mac_phy_rxeqeval asserts after 1us and 2 TS1 received from remote partner.  - 1: mac_phy_rxeqeval asserts after 500ns regardless of TS's received or not. Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: The access attributes of this field are as follows:  - Dbi: see description  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_RXEQ_RGRDLESS_RXTS_K2_E5_SHIFT                                         13
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_EQUALIZATION_DISABLE_K2_E5                                        (0x1<<16) // Equalization Disable. Disable equalization feature.  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_EQUALIZATION_DISABLE_K2_E5_SHIFT                                  16
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_DLLP_XMT_DELAY_DISABLE_K2_E5                                      (0x1<<17) // DLLP Transmission Delay Disable. Disable delay transmission of DLLPs before equalization.  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_DLLP_XMT_DELAY_DISABLE_K2_E5_SHIFT                                17
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_DC_BALANCE_DISABLE_K2_E5                                          (0x1<<18) // DC Balance Disable. Disable DC Balance feature.  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_DC_BALANCE_DISABLE_K2_E5_SHIFT                                    18
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_EQ_INVREQ_EVAL_DIFF_DISABLE_K2_E5                                 (0x1<<23) // Eq InvalidRequest and RxEqEval Different Time Assertion Disable. Disable the assertion of Eq InvalidRequest and RxEqEval at different time.  Note: When CX_GEN4_SPEED, this register is shared for Gen3 and Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_RELATED_OFF_GEN3_EQ_INVREQ_EVAL_DIFF_DISABLE_K2_E5_SHIFT                           23
#define PCIEIP_REG_TL_FUNC14TO15_MASK_BB                                                                     0x000890UL //Access:RW   DataWidth:0x20   // This register masks specific errors from setting pcie_err_attn for functions 14 and 15.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_PES14_MASK_BB                                                        (0x1<<0) // Poisoned Error Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_PES14_MASK_BB_SHIFT                                                  0
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_FCPES14_MASK_BB                                                      (0x1<<1) // Flow Control Protocol Error Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_FCPES14_MASK_BB_SHIFT                                                1
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_CTS14_MASK_BB                                                        (0x1<<2) // Completer Timeout Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_CTS14_MASK_BB_SHIFT                                                  2
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RX_UR14_MASK_BB                                                      (0x1<<3) // Received UR Status, Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RX_UR14_MASK_BB_SHIFT                                                3
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_UCS14_MASK_BB                                                        (0x1<<4) // Unexpected Completion Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_UCS14_MASK_BB_SHIFT                                                  4
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ROS14_MASK_BB                                                        (0x1<<5) // Receiver Overflow Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ROS14_MASK_BB_SHIFT                                                  5
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_MTLPS14_MASK_BB                                                      (0x1<<6) // Malformed TLP Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_MTLPS14_MASK_BB_SHIFT                                                6
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ECRCS14_MASK_BB                                                      (0x1<<7) // ECRC Error TLP Status Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ECRCS14_MASK_BB_SHIFT                                                7
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_URES14_MASK_BB                                                       (0x1<<8) // Unsupported Request Error Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_URES14_MASK_BB_SHIFT                                                 8
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RXTABRT14_MASK_BB                                                    (0x1<<9) // Received target Abort Error Status Mask for Function14. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RXTABRT14_MASK_BB_SHIFT                                              9
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_PES15_MASK_BB                                                        (0x1<<10) // Poisoned Error Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_PES15_MASK_BB_SHIFT                                                  10
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_FCPES15_MASK_BB                                                      (0x1<<11) // Flow Control Protocol Error Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_FCPES15_MASK_BB_SHIFT                                                11
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_CTS15_MASK_BB                                                        (0x1<<12) // Completer Timeout Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_CTS15_MASK_BB_SHIFT                                                  12
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RX_UR15_MASK_BB                                                      (0x1<<13) // Received UR Status, Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RX_UR15_MASK_BB_SHIFT                                                13
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_UCS15_MASK_BB                                                        (0x1<<14) // Unexpected Completion Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_UCS15_MASK_BB_SHIFT                                                  14
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ROS15_MASK_BB                                                        (0x1<<15) // Receiver Overflow Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ROS15_MASK_BB_SHIFT                                                  15
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_MTLPS15_MASK_BB                                                      (0x1<<16) // Malformed TLP Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_MTLPS15_MASK_BB_SHIFT                                                16
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ECRCS15_MASK_BB                                                      (0x1<<17) // ECRC Error TLP Status Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_ECRCS15_MASK_BB_SHIFT                                                17
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_URES15_MASK_BB                                                       (0x1<<18) // Unsupported Request Error Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_URES15_MASK_BB_SHIFT                                                 18
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RXTABRT15_MASK_BB                                                    (0x1<<19) // Received target Abort Error Status Mask for Function15. If set, does not generate pcie_err_attn output when this error is seen.
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_RXTABRT15_MASK_BB_SHIFT                                              19
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_UNUSED_1_BB                                                          (0xfff<<20) // 
  #define PCIEIP_REG_TL_FUNC14TO15_MASK_UNUSED_1_BB_SHIFT                                                    20
#define PCIEIP_REG_TL_FUNC14TO15_STAT_BB                                                                     0x000894UL //Access:RW   DataWidth:0x20   // This register stores the status of errors to generate pcie_err_attn for functions 14 and 15.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_PSND_TLP14_BB                                                    (0x1<<0) // Poisoned Error Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_PSND_TLP14_BB_SHIFT                                              0
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_FC_PRTL14_BB                                                     (0x1<<1) // Flow Control Protocol Error Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_FC_PRTL14_BB_SHIFT                                               1
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_CPL_TIMEOUT14_BB                                                 (0x1<<2) // Completer Timeout Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_CPL_TIMEOUT14_BB_SHIFT                                           2
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MASTER_ABRT14_BB                                                 (0x1<<3) // Receive UR Status detectedfor Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MASTER_ABRT14_BB_SHIFT                                           3
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNEXP_CPL14_BB                                                   (0x1<<4) // Unexpected Completion Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNEXP_CPL14_BB_SHIFT                                             4
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_RX_OFLOW14_BB                                                    (0x1<<5) // Receiver Overflow Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_RX_OFLOW14_BB_SHIFT                                              5
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MALF_TLP14_BB                                                    (0x1<<6) // Malformed TLP Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MALF_TLP14_BB_SHIFT                                              6
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_ECRC14_BB                                                        (0x1<<7) // ECRC Error TLP Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_ECRC14_BB_SHIFT                                                  7
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNSPPORT14_BB                                                    (0x1<<8) // Unsupported Request Error Status detected for Function 14. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNSPPORT14_BB_SHIFT                                              8
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_PRI_SIG_TARGET_ABORT14_BB                                            (0x1<<9) // 
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_PRI_SIG_TARGET_ABORT14_BB_SHIFT                                      9
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_PSND_TLP15_BB                                                    (0x1<<10) // Poisoned Error Status detected in function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_PSND_TLP15_BB_SHIFT                                              10
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_FC_PRTL15_BB                                                     (0x1<<11) // Flow Control Protocol Error Status detected in function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_FC_PRTL15_BB_SHIFT                                               11
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_CPL_TIMEOUT15_BB                                                 (0x1<<12) // Completer Timeout Status detected in function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_CPL_TIMEOUT15_BB_SHIFT                                           12
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MASTER_ABRT15_BB                                                 (0x1<<13) // Receive UR Status detectedin function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MASTER_ABRT15_BB_SHIFT                                           13
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNEXP_CPL15_BB                                                   (0x1<<14) // Unexpected Completion Status detected in function 15. If set, hw geneartes pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNEXP_CPL15_BB_SHIFT                                             14
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_RX_OFLOW15_BB                                                    (0x1<<15) // Receiver Overflow Status detected in function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_RX_OFLOW15_BB_SHIFT                                              15
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MALF_TLP15_BB                                                    (0x1<<16) // Malformed TLP Status detected in function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_MALF_TLP15_BB_SHIFT                                              16
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_ECRC15_BB                                                        (0x1<<17) // ECRC Error TLP Status detected in function 15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_ECRC15_BB_SHIFT                                                  17
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNSPPORT15_BB                                                    (0x1<<18) // Unsupported Request Error Status detected in function15. If set, hw generates pcie_err_attn output.
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_ERR_UNSPPORT15_BB_SHIFT                                              18
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_PRI_SIG_TARGET_ABORT15_BB                                            (0x1<<19) // 
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_PRI_SIG_TARGET_ABORT15_BB_SHIFT                                      19
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_UNUSED_1_BB                                                          (0xfff<<20) // 
  #define PCIEIP_REG_TL_FUNC14TO15_STAT_UNUSED_1_BB_SHIFT                                                    20
#define PCIEIP_REG_PF_HIDE_CONTROL_K2_E5                                                                     0x0008a0UL //Access:RW   DataWidth:0x20   // The core supports the hiding of implemented physical functions. To enable this feature, you must set the CX_HIDE_PF_EN hidden configuration parameter.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF0_HIDE_CONTROL_K2_E5                                                  (0x3<<0) // 0x00: PF is Visible, 0x01:Reserved, 0x10:PF is hidden. All CFG accesses to this function will receive UR. 0x11: PF is Partially Hidden. CfgWr accesses to this funciton will receive UR. CfgRd accesses to this function will receive SC, with a data payload of 0xFFFFFFFF.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF0_HIDE_CONTROL_K2_E5_SHIFT                                            0
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF1_HIDE_CONTROL_K2_E5                                                  (0x3<<2) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF1_HIDE_CONTROL_K2_E5_SHIFT                                            2
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF2_HIDE_CONTROL_K2_E5                                                  (0x3<<4) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF2_HIDE_CONTROL_K2_E5_SHIFT                                            4
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF3_HIDE_CONTROL_K2_E5                                                  (0x3<<6) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF3_HIDE_CONTROL_K2_E5_SHIFT                                            6
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF4_HIDE_CONTROL_K2_E5                                                  (0x3<<8) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF4_HIDE_CONTROL_K2_E5_SHIFT                                            8
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF5_HIDE_CONTROL_K2_E5                                                  (0x3<<10) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF5_HIDE_CONTROL_K2_E5_SHIFT                                            10
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF6_HIDE_CONTROL_K2_E5                                                  (0x3<<12) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF6_HIDE_CONTROL_K2_E5_SHIFT                                            12
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF7_HIDE_CONTROL_K2_E5                                                  (0x3<<14) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF7_HIDE_CONTROL_K2_E5_SHIFT                                            14
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF8_HIDE_CONTROL_K2_E5                                                  (0x3<<16) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF8_HIDE_CONTROL_K2_E5_SHIFT                                            16
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF9_HIDE_CONTROL_K2_E5                                                  (0x3<<18) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF9_HIDE_CONTROL_K2_E5_SHIFT                                            18
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF10_HIDE_CONTROL_K2_E5                                                 (0x3<<20) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF10_HIDE_CONTROL_K2_E5_SHIFT                                           20
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF11_HIDE_CONTROL_K2_E5                                                 (0x3<<22) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF11_HIDE_CONTROL_K2_E5_SHIFT                                           22
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF12_HIDE_CONTROL_K2_E5                                                 (0x3<<24) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF12_HIDE_CONTROL_K2_E5_SHIFT                                           24
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF13_HIDE_CONTROL_K2_E5                                                 (0x3<<26) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF13_HIDE_CONTROL_K2_E5_SHIFT                                           26
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF14_HIDE_CONTROL_K2_E5                                                 (0x3<<28) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF14_HIDE_CONTROL_K2_E5_SHIFT                                           28
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF15_HIDE_CONTROL_K2_E5                                                 (0x3<<30) // Operates in the same way as PF0.
  #define PCIEIP_REG_PF_HIDE_CONTROL_PF15_HIDE_CONTROL_K2_E5_SHIFT                                           30
#define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_K2_E5                                                                 0x0008a8UL //Access:RW   DataWidth:0x20   // Gen3 EQ Control Register. This register controls equalization for Phase2 in an upstream port (USP), or Phase3 in a downstream port (DSP). M-PCIe doesn't have Conventional PCIe Gen3 feature. The registers of this section do not exist.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_FB_MODE_K2_E5                                               (0xf<<0) // Feedback Mode.  - 0000b: Direction Change  - 0001b: Figure Of Merit  - 0010b: Reserved  - .....: Reserved  - 1111b: Reserved Note: When CX_GEN4_SPEED, this register is a shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_FB_MODE_K2_E5_SHIFT                                         0
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_PHASE23_EXIT_MODE_K2_E5                                     (0x1<<4) // Behavior After 24 ms Timeout (when optimal settings are not found).   For a USP: Determine next LTSSM state from Phase2 after 24ms Timeout  - 0: Recovery.Speed  - 1: Recovery.Equalization.Phase3 When optimal settings are not found then:  - Equalization Phase 2 Successful status bit is not set in the "Link Status Register 2"  - Equalization Phase 2 Complete status bit is set in the "Link Status Register 2" For a DSP: Determine next LTSSM state from Phase3 after 24ms Timeout  - 0: Recovery.Speed  - 1: Recovery.Equalization.RcvrLock When optimal settings are not found then:  - Equalization Phase 3 Successful status bit is not set in the "Link Status Register 2"  - Equalization Phase 3 Complete status bit is set in the "Link Status Register 2" Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_PHASE23_EXIT_MODE_K2_E5_SHIFT                               4
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_EVAL_2MS_DISABLE_K2_E5                                      (0x1<<5) // Phase2_3 2 ms Timeout Disable. Determine behavior in Phase2 for USP (Phase3 if DSP) when the PHY does not respond within 2ms to the assertion of RxEqEval:  - 0: abort the current evaluation, stop any attempt to modify the remote transmitter settings, Phase2 is terminated by the 24ms timeout  - 1: ignore the 2ms timeout and continue as normal. This is used to support PHYs that require more than 2ms to respond to the assertion of RxEqEval. Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_EVAL_2MS_DISABLE_K2_E5_SHIFT                                5
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_PSET_REQ_VEC_K2_E5                                          (0xffff<<8) // Preset Request Vector. Requesting of Presets during the initial part of the EQ Master Phase. Encoding scheme is as follows:   Bit [15:0] =0x0: No preset is requested and evaluated in EQ Master Phase.   Bit [i] =1: "Preset=i" is requested and evaluated in EQ Master Phase.  - 0000000000000000: No preset be requested and evaluated in EQ Master Phase  - 000000xxxxxxxxx1: Preset 0 is requested and evaluated in EQ Master Phase  - 000000xxxxxxxx1x: Preset 1 is requested and evaluated in EQ Master Phase  - 000000xxxxxxx1xx: Preset 2 is requested and evaluated in EQ Master Phase  - 000000xxxxxx1xxx: Preset 3 is requested and evaluated in EQ Master Phase  - 000000xxxxx1xxxx: Preset 4 is requested and evaluated in EQ Master Phase  - 000000xxxx1xxxxx: Preset 5 is requested and evaluated in EQ Master Phase  - 000000xxx1xxxxxx: Preset 6 is requested and evaluated in EQ Master Phase  - 000000xx1xxxxxxx: Preset 7 is requested and evaluated in EQ Master Phase  - 000000x1xxxxxxxx: Preset 8 is requested and evaluated in EQ Master Phase  - 00000x1xxxxxxxxx: Preset 9 is requested and evaluated in EQ Master Phase  - 000001xxxxxxxxxx: Preset 10 is requested and evaluated in EQ Master Phase  - All other encodings: Reserved Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_PSET_REQ_VEC_K2_E5_SHIFT                                    8
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_FOM_INC_INITIAL_EVAL_K2_E5                                  (0x1<<24) // Include Initial FOM. Include or not the FOM feedback from the initial preset evaluation performed in the EQ Master, when finding the highest FOM among all preset evaluations.  - 0: Do not include  - 1: Include Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_FOM_INC_INITIAL_EVAL_K2_E5_SHIFT                            24
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_PSET_REQ_AS_COEF_K2_E5                                      (0x1<<25) // GEN3_EQ_PSET_REQ_AS_COEF is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_EQ_PSET_REQ_AS_COEF_K2_E5_SHIFT                                25
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_REQ_SEND_CONSEC_EIEOS_FOR_PSET_MAP_K2_E5                       (0x1<<26) // Request core to send back-to-back EIEOS in Recovery.RcvrLock state until presets to coefficients mapping is complete.  - 0: Do not request  - 1: request Note: Gen3 and Gen4 share the same register bit and have the same feature.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_CONTROL_OFF_GEN3_REQ_SEND_CONSEC_EIEOS_FOR_PSET_MAP_K2_E5_SHIFT                 26
#define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_K2_E5                                                      0x0008acUL //Access:RW   DataWidth:0x20   // Gen3 EQ Direction Change Feedback Mode Control Register. Equalization controls to be used in Phase2 (USP) or Phase 3 (DSP), when you set the Feedback Mode in "Gen3 EQ Control Register" to "Direction Change." These fields allow control over the initial starting point for the search of optimal coefficient settings, and allow control over the criteria used to determine when the optimal settings have been achieved. The values are applied to all the lanes.
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_T_MIN_PHASE23_K2_E5                         (0x1f<<0) // Minimum Time (in ms) To Remain in EQ Master Phase. The LTSSM stays in EQ Master phase for at least this amount of time, before starting to check for convergence of the coefficients. Allowed values 0,1,...,24.  Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_T_MIN_PHASE23_K2_E5_SHIFT                   0
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_N_EVALS_K2_E5                               (0x1f<<5) // Convergence Window Depth. Number of consecutive evaluations considered in Phase 2/3 when determining if optimal coefficients have been found. Allowed range: 0,1,2,..16 up to a maximum of CX_GEN3_EQ_COEFQ_DEPTH.  When set to 0, EQ Master is performed without sending any requests to the remote partner in Phase 2 for USP and Phase 3 for DSP. Therefore, the remote partner will not change its transmitter coefficients and will move to the next state.  Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_N_EVALS_K2_E5_SHIFT                         5
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_MAX_PRE_CUSROR_DELTA_K2_E5                  (0xf<<10) // Convergence Window Aperture for C-1. Pre-cursor coefficients maximum delta within the convergence window depth. Allowed range: 0,1,2,..15.  Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_MAX_PRE_CUSROR_DELTA_K2_E5_SHIFT            10
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_MAX_POST_CUSROR_DELTA_K2_E5                 (0xf<<14) // Convergence Window Aperture for C+1. Post-cursor coefficients maximum delta within the convergence window depth. Allowed range: 0,1,2,..15.  Note: When CX_GEN4_SPEED, this register is shadow register for Gen3 and Gen4 data rate. If RATE_SHADOW_SEL==00b, this register is for Gen3 data rate. If RATE_SHADOW_SEL==01b, this register is for Gen4 data rate.  Note: This register field is sticky.
  #define PCIEIP_REG_GEN3_EQ_FB_MODE_DIR_CHANGE_OFF_GEN3_EQ_FMDC_MAX_POST_CUSROR_DELTA_K2_E5_SHIFT           14
#define PCIEIP_REG_ORDER_RULE_CTRL_OFF_K2_E5                                                                 0x0008b4UL //Access:RW   DataWidth:0x20   // Order Rule Control Register.
  #define PCIEIP_REG_ORDER_RULE_CTRL_OFF_NP_PASS_P_K2_E5                                                     (0xff<<0) // Non-Posted Passing Posted Ordering Rule Control.   Determines if NP can pass halted P queue.  - 0 : NP can not pass P (recommended).  - 1 : NP can pass P
  #define PCIEIP_REG_ORDER_RULE_CTRL_OFF_NP_PASS_P_K2_E5_SHIFT                                               0
  #define PCIEIP_REG_ORDER_RULE_CTRL_OFF_CPL_PASS_P_K2_E5                                                    (0xff<<8) // Completion Passing Posted Ordering Rule Control.   Determines if CPL can pass halted P queue.  - 0: CPL can not pass P (recommended)  - 1: CPL can pass P
  #define PCIEIP_REG_ORDER_RULE_CTRL_OFF_CPL_PASS_P_K2_E5_SHIFT                                              8
#define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_K2_E5                                                           0x0008b8UL //Access:RW   DataWidth:0x20   // PIPE Loopback Control Register.
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_LPBK_RXVALID_K2_E5                                            (0xffff<<0) // LPBK_RXVALID is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_LPBK_RXVALID_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_RXSTATUS_LANE_K2_E5                                           (0x3f<<16) // RXSTATUS_LANE is an internally reserved field. Do not use.  Note: This register field is sticky.
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_RXSTATUS_LANE_K2_E5_SHIFT                                     16
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_RXSTATUS_VALUE_K2_E5                                          (0x7<<24) // RXSTATUS_VALUE is an internally reserved field. Do not use.
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_RXSTATUS_VALUE_K2_E5_SHIFT                                    24
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_PIPE_LOOPBACK_K2_E5                                           (0x1<<31) // PIPE Loopback Enable. Indicates RMMI Loopback if M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_PIPE_LOOPBACK_CONTROL_OFF_PIPE_LOOPBACK_K2_E5_SHIFT                                     31
#define PCIEIP_REG_MISC_CONTROL_1_OFF_K2_E5                                                                  0x0008bcUL //Access:RW   DataWidth:0x20   // DBI Read-Only Write Enable Register.
  #define PCIEIP_REG_MISC_CONTROL_1_OFF_DBI_RO_WR_EN_K2_E5                                                   (0x1<<0) // Write to RO Registers Using DBI. When you set this field to "1", then some RO and HwInit bits are writable from the local application through the DBI. For more details, see "Writing to Read-Only Registers."  Note: This register field is sticky.
  #define PCIEIP_REG_MISC_CONTROL_1_OFF_DBI_RO_WR_EN_K2_E5_SHIFT                                             0
#define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_K2_E5                                                              0x0008c0UL //Access:RW   DataWidth:0x20   // UpConfigure Multi-lane Control Register.  Used when upsizing or downsizing the link width through Configuration state without bringing the link down. For more details, see the "Link Establishment" section in the Core Operations chapter of the Databook.
  #define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_TARGET_LINK_WIDTH_K2_E5                                          (0x3f<<0) // Target Link Width.  Values correspond to:  - 6'b000000: Core does not start upconfigure or autonomous width downsizing in the Configuration state.  - 6'b000001: x1  - 6'b000010: x2  - 6'b000100: x4  - 6'b001000: x8  - 6'b010000: x16  - 6'b100000: x32 This field is reserved (fixed to '0') for M-PCIe.
  #define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_TARGET_LINK_WIDTH_K2_E5_SHIFT                                    0
  #define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_DIRECT_LINK_WIDTH_CHANGE_K2_E5                                   (0x1<<6) // Directed Link Width Change.  The core always moves to Configuration state through Recovery state when this bit is set to '1'.  - If the upconfigure_capable variable is '1' and the PCIE_CAP_HW_AUTO_WIDTH_DISABLE bit in LINK_CONTROL_LINK_STATUS_REG is '0', the core starts upconfigure or autonomous width downsizing (to the TARGET_LINK_WIDTH value) in the Configuration state.  - If TARGET_LINK_WIDTH value is 0x0, the core does not start upconfigure or autonomous width downsizing in the Configuration state. The core self-clears this field when the core accepts this request.  This field is reserved (fixed to '0') for M-PCIe.
  #define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_DIRECT_LINK_WIDTH_CHANGE_K2_E5_SHIFT                             6
  #define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_UPCONFIGURE_SUPPORT_K2_E5                                        (0x1<<7) // Upconfigure Support.  The core sends this value as the Link Upconfigure Capability in TS2 Ordered Sets in Configuration.Complete state.  This field is reserved (fixed to '0') for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_MULTI_LANE_CONTROL_OFF_UPCONFIGURE_SUPPORT_K2_E5_SHIFT                                  7
#define PCIEIP_REG_PHY_INTEROP_CTRL_OFF_K2_E5                                                                0x0008c4UL //Access:RW   DataWidth:0x20   // PHY Interoperability Control Register.   This register is reserved for internal use.  You should not write to this register and change the default unless specifically instructed by Synopsys support.
  #define PCIEIP_REG_PHY_INTEROP_CTRL_OFF_RXSTANDBY_CONTROL_K2_E5                                            (0x7f<<0) // Rxstandby Control. Bits 0..5 determine if the core asserts the RxStandby signal (mac_phy_rxstandby) in the indicated condition. Bit 6 enables the controller to perform the RxStandby/RxStandbyStatus handshake.  - [0]: Rx EIOS and subsequent T TX-IDLE-MIN  - [1]: Rate Change  - [2]: Inactive lane for upconfigure/downconfigure  - [3]: PowerDown=P1orP2  - [4]: RxL0s.Idle  - [5]: EI Infer in L0  - [6]: Execute RxStandby/RxStandbyStatus Handshake This field is reserved (fixed to '0') for M-PCIe.  Note: This register field is sticky.
  #define PCIEIP_REG_PHY_INTEROP_CTRL_OFF_RXSTANDBY_CONTROL_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_PHY_INTEROP_CTRL_OFF_L1_NOWAIT_P1_K2_E5                                                 (0x1<<9) // L1 entry control bit.  - 1: Core does not wait for PHY to acknowledge transition to P1 before entering L1.  - 0: Core waits for the PHY to acknowledge transition to P1 before entering L1. Note: The access attributes of this field are as follows:  - Dbi: R/W (sticky)  Note: This register field is sticky.
  #define PCIEIP_REG_PHY_INTEROP_CTRL_OFF_L1_NOWAIT_P1_K2_E5_SHIFT                                           9
#define PCIEIP_REG_TRGT_CPL_LUT_DELETE_ENTRY_OFF_K2_E5                                                       0x0008c8UL //Access:RW   DataWidth:0x20   // TRGT_CPL_LUT Delete Entry Control register.   Using this register you can delete one entry in the target completion LUT.  Note:: The target completion LUT (and associated target completion timeout event) is watching for received application completions (on XALI0/1/2) corresponding to previously received non-posted requests from the PCIe wire.
  #define PCIEIP_REG_TRGT_CPL_LUT_DELETE_ENTRY_OFF_LOOK_UP_ID_K2_E5                                          (0x7fffffff<<0) // This number selects one entry to delete of the TRGT_CPL_LUT.
  #define PCIEIP_REG_TRGT_CPL_LUT_DELETE_ENTRY_OFF_LOOK_UP_ID_K2_E5_SHIFT                                    0
  #define PCIEIP_REG_TRGT_CPL_LUT_DELETE_ENTRY_OFF_DELETE_EN_K2_E5                                           (0x1<<31) // This is a one shot bit. A '1' write to this bit triggers the deletion of the target completion LUT entry that is specified in the LOOK_UP_ID field. This is a self-clearing register field. Reading from this register field always returns a '0'.
  #define PCIEIP_REG_TRGT_CPL_LUT_DELETE_ENTRY_OFF_DELETE_EN_K2_E5_SHIFT                                     31
#define PCIEIP_REG_PL_LAST_OFF_K2_E5                                                                         0x0008fcUL //Access:R    DataWidth:0x20   // PL_LAST_OFF is an internally reserved register. Do not use.
  #define PCIEIP_REG_PL_LAST_OFF_PL_LAST_K2_E5                                                               (0x1<<0) // PL_LAST is an internally reserved field. Do not use.
  #define PCIEIP_REG_PL_LAST_OFF_PL_LAST_K2_E5_SHIFT                                                         0
#define PCIEIP_REG_TL_STATUS_0_BB                                                                            0x000900UL //Access:R    DataWidth:0x20   // Split completion table entry. For Debug.
  #define PCIEIP_REG_TL_STATUS_0_DEVICE_NO_BB                                                                (0xf<<0) // Split table contents for tag0. this corresponds to Device_no[4:1] of PCIE header.
  #define PCIEIP_REG_TL_STATUS_0_DEVICE_NO_BB_SHIFT                                                          0
  #define PCIEIP_REG_TL_STATUS_0_FUNC_NO_BB                                                                  (0x7<<4) // Split table contents for tag0. This is the Function number of the request made.
  #define PCIEIP_REG_TL_STATUS_0_FUNC_NO_BB_SHIFT                                                            4
  #define PCIEIP_REG_TL_STATUS_0_TC_BB                                                                       (0x7<<7) // Split table contents for tag0. This is the Traffic class field.
  #define PCIEIP_REG_TL_STATUS_0_TC_BB_SHIFT                                                                 7
  #define PCIEIP_REG_TL_STATUS_0_ATTR_BB                                                                     (0x3<<10) // Split table Contents for tag0. This corresponds to attr field in PCIE header.
  #define PCIEIP_REG_TL_STATUS_0_ATTR_BB_SHIFT                                                               10
  #define PCIEIP_REG_TL_STATUS_0_BYTE_COUNT_BB                                                               (0x1fff<<12) // Split table contents for tag0. This corresponds to the Byte count field.
  #define PCIEIP_REG_TL_STATUS_0_BYTE_COUNT_BB_SHIFT                                                         12
  #define PCIEIP_REG_TL_STATUS_0_LWR_ADDR_BB                                                                 (0x7f<<25) // Split table contents for tag0. This corresponds to the Lower address field.
  #define PCIEIP_REG_TL_STATUS_0_LWR_ADDR_BB_SHIFT                                                           25
#define PCIEIP_REG_TL_STATUS_1_BB                                                                            0x000904UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 01.
#define PCIEIP_REG_TL_STATUS_2_BB                                                                            0x000908UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 02.
#define PCIEIP_REG_TL_STATUS_3_BB                                                                            0x00090cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 03.
#define PCIEIP_REG_TL_STATUS_4_BB                                                                            0x000910UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 04.
#define PCIEIP_REG_TL_STATUS_5_BB                                                                            0x000914UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 05.
#define PCIEIP_REG_TL_STATUS_6_BB                                                                            0x000918UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 06.
#define PCIEIP_REG_TL_STATUS_7_BB                                                                            0x00091cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 07.
#define PCIEIP_REG_TL_STATUS_8_BB                                                                            0x000920UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 08.
#define PCIEIP_REG_TL_STATUS_9_BB                                                                            0x000924UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 09.
#define PCIEIP_REG_TL_STATUS_10_BB                                                                           0x000928UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 10.
#define PCIEIP_REG_TL_STATUS_11_BB                                                                           0x00092cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 11.
#define PCIEIP_REG_TL_STATUS_12_BB                                                                           0x000930UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 12.
#define PCIEIP_REG_TL_STATUS_13_BB                                                                           0x000934UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 13.
#define PCIEIP_REG_TL_STATUS_14_BB                                                                           0x000938UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 14.
#define PCIEIP_REG_TL_STATUS_15_BB                                                                           0x00093cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 15.
#define PCIEIP_REG_TL_STATUS_16_BB                                                                           0x000940UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 16.
#define PCIEIP_REG_TL_STATUS_17_BB                                                                           0x000944UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 17.
#define PCIEIP_REG_TL_STATUS_18_BB                                                                           0x000948UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 18.
#define PCIEIP_REG_TL_STATUS_19_BB                                                                           0x00094cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 19.
#define PCIEIP_REG_TL_STATUS_20_BB                                                                           0x000950UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 20.
#define PCIEIP_REG_TL_STATUS_21_BB                                                                           0x000954UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 21.
#define PCIEIP_REG_TL_STATUS_22_BB                                                                           0x000958UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 22.
#define PCIEIP_REG_TL_STATUS_23_BB                                                                           0x00095cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 23.
#define PCIEIP_REG_TL_STATUS_24_BB                                                                           0x000960UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 24.
#define PCIEIP_REG_TL_STATUS_25_BB                                                                           0x000964UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 25.
#define PCIEIP_REG_TL_STATUS_26_BB                                                                           0x000968UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 26.
#define PCIEIP_REG_TL_STATUS_27_BB                                                                           0x00096cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 27.
#define PCIEIP_REG_TL_STATUS_28_BB                                                                           0x000970UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 28.
#define PCIEIP_REG_TL_STATUS_29_BB                                                                           0x000974UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 29.
#define PCIEIP_REG_TL_STATUS_30_BB                                                                           0x000978UL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 30.
#define PCIEIP_REG_TL_STATUS_31_BB                                                                           0x00097cUL //Access:R    DataWidth:0x20   // This register is same as tl_status_0, except that it corresponds to split completion table entry for tag 31.
#define PCIEIP_REG_TL_HDR_FC_ST_BB                                                                           0x000980UL //Access:R    DataWidth:0x20   // Header Flow Control. For Debug.
  #define PCIEIP_REG_TL_HDR_FC_ST_NPH_AVAIL_BB                                                               (0xff<<0) // Non Posted Header credits available.
  #define PCIEIP_REG_TL_HDR_FC_ST_NPH_AVAIL_BB_SHIFT                                                         0
  #define PCIEIP_REG_TL_HDR_FC_ST_PH_AVAIL_BB                                                                (0xff<<8) // Posted Header Credits Available.
  #define PCIEIP_REG_TL_HDR_FC_ST_PH_AVAIL_BB_SHIFT                                                          8
  #define PCIEIP_REG_TL_HDR_FC_ST_CPLH_AVAIL_BB                                                              (0xff<<16) // Completion Header credits available.
  #define PCIEIP_REG_TL_HDR_FC_ST_CPLH_AVAIL_BB_SHIFT                                                        16
  #define PCIEIP_REG_TL_HDR_FC_ST_NPD_AVAIL_7_0_BB                                                           (0xff<<24) // Non-Posted Data credits available: bit[7:0].
  #define PCIEIP_REG_TL_HDR_FC_ST_NPD_AVAIL_7_0_BB_SHIFT                                                     24
#define PCIEIP_REG_TL_DAT_FC_ST_BB                                                                           0x000984UL //Access:R    DataWidth:0x20   // Data Flow Control. For Debug.
  #define PCIEIP_REG_TL_DAT_FC_ST_PD_AVAIL_BB                                                                (0xfff<<0) // Posted Data credits available.
  #define PCIEIP_REG_TL_DAT_FC_ST_PD_AVAIL_BB_SHIFT                                                          0
  #define PCIEIP_REG_TL_DAT_FC_ST_UNUSED0_BB                                                                 (0xf<<12) // 
  #define PCIEIP_REG_TL_DAT_FC_ST_UNUSED0_BB_SHIFT                                                           12
  #define PCIEIP_REG_TL_DAT_FC_ST_CPLD_AVAIL_BB                                                              (0xfff<<16) // Completion Data credits available.
  #define PCIEIP_REG_TL_DAT_FC_ST_CPLD_AVAIL_BB_SHIFT                                                        16
  #define PCIEIP_REG_TL_DAT_FC_ST_NPD_AVAIL_11_8_BB                                                          (0xf<<28) // Non-Posted Data credits available: bit[11:8].
  #define PCIEIP_REG_TL_DAT_FC_ST_NPD_AVAIL_11_8_BB_SHIFT                                                    28
#define PCIEIP_REG_TL_HDR_FCCON_ST_BB                                                                        0x000988UL //Access:R    DataWidth:0x20   // Header Flow Control. For Debug.
  #define PCIEIP_REG_TL_HDR_FCCON_ST_NPH_CC_BB                                                               (0xff<<0) // Non Posted Header credits consumed.
  #define PCIEIP_REG_TL_HDR_FCCON_ST_NPH_CC_BB_SHIFT                                                         0
  #define PCIEIP_REG_TL_HDR_FCCON_ST_PH_CC_BB                                                                (0xff<<8) // Posted Header Credits consumed.
  #define PCIEIP_REG_TL_HDR_FCCON_ST_PH_CC_BB_SHIFT                                                          8
  #define PCIEIP_REG_TL_HDR_FCCON_ST_CPLH_CC_BB                                                              (0xff<<16) // Completion Header credits consumed.
  #define PCIEIP_REG_TL_HDR_FCCON_ST_CPLH_CC_BB_SHIFT                                                        16
  #define PCIEIP_REG_TL_HDR_FCCON_ST_NPD_CC_7_0_BB                                                           (0xff<<24) // Non-Posted Data credits consumed: bit[7:0].
  #define PCIEIP_REG_TL_HDR_FCCON_ST_NPD_CC_7_0_BB_SHIFT                                                     24
#define PCIEIP_REG_TL_DAT_FCCON_ST_BB                                                                        0x00098cUL //Access:R    DataWidth:0x20   // Data Flow Control. For Debug.
  #define PCIEIP_REG_TL_DAT_FCCON_ST_PD_CC_BB                                                                (0xfff<<0) // Posted Data credits consumed.
  #define PCIEIP_REG_TL_DAT_FCCON_ST_PD_CC_BB_SHIFT                                                          0
  #define PCIEIP_REG_TL_DAT_FCCON_ST_UNUSED0_BB                                                              (0xf<<12) // 
  #define PCIEIP_REG_TL_DAT_FCCON_ST_UNUSED0_BB_SHIFT                                                        12
  #define PCIEIP_REG_TL_DAT_FCCON_ST_CPLD_CC_BB                                                              (0xfff<<16) // Completion Data credits consumed.
  #define PCIEIP_REG_TL_DAT_FCCON_ST_CPLD_CC_BB_SHIFT                                                        16
  #define PCIEIP_REG_TL_DAT_FCCON_ST_NPD_CC_11_8_BB                                                          (0xf<<28) // Non-Posted Data credits consumed: bit[11:8].
  #define PCIEIP_REG_TL_DAT_FCCON_ST_NPD_CC_11_8_BB_SHIFT                                                    28
#define PCIEIP_REG_TL_TGT_CRDT_ST_BB                                                                         0x000990UL //Access:R    DataWidth:0x20   // Target Flow Control. For Debug.
  #define PCIEIP_REG_TL_TGT_CRDT_ST_PH_CRDT_CNTR_BB                                                          (0x7f<<0) // Available Posted header credits for target writes.
  #define PCIEIP_REG_TL_TGT_CRDT_ST_PH_CRDT_CNTR_BB_SHIFT                                                    0
  #define PCIEIP_REG_TL_TGT_CRDT_ST_UNUSED0_BB                                                               (0x1<<7) // 
  #define PCIEIP_REG_TL_TGT_CRDT_ST_UNUSED0_BB_SHIFT                                                         7
  #define PCIEIP_REG_TL_TGT_CRDT_ST_PD_CRDT_CNTR_BB                                                          (0x7f<<8) // Available Posted data credits for target writes.
  #define PCIEIP_REG_TL_TGT_CRDT_ST_PD_CRDT_CNTR_BB_SHIFT                                                    8
  #define PCIEIP_REG_TL_TGT_CRDT_ST_UNUSED1_BB                                                               (0x1<<15) // 
  #define PCIEIP_REG_TL_TGT_CRDT_ST_UNUSED1_BB_SHIFT                                                         15
  #define PCIEIP_REG_TL_TGT_CRDT_ST_NP_CRDT_CNTR_BB                                                          (0x1<<16) // Available Non-posted credit for target reads or config.
  #define PCIEIP_REG_TL_TGT_CRDT_ST_NP_CRDT_CNTR_BB_SHIFT                                                    16
#define PCIEIP_REG_TL_CRDT_ALLOC_ST_BB                                                                       0x000994UL //Access:R    DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_NPH_ALLOC_BB                                                           (0xff<<0) // Non-Posted header credits allocated.
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_NPH_ALLOC_BB_SHIFT                                                     0
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_NPD_ALLOC_BB                                                           (0xff<<8) // Non-Posted data credits allocated.
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_NPD_ALLOC_BB_SHIFT                                                     8
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_PH_ALLOC_BB                                                            (0xff<<16) // Posted header credits allocated.
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_PH_ALLOC_BB_SHIFT                                                      16
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_PD_ALLOC_BB                                                            (0xff<<24) // Posted Data credits allocated.
  #define PCIEIP_REG_TL_CRDT_ALLOC_ST_PD_ALLOC_BB_SHIFT                                                      24
#define PCIEIP_REG_TL_SMLOGIC_ST_BB                                                                          0x000998UL //Access:R    DataWidth:0x20   // State machines in TL status for debug.
  #define PCIEIP_REG_TL_SMLOGIC_ST_NP_CURR_STATE_BB                                                          (0xf<<0) // Target Non-Posted request State machine.
  #define PCIEIP_REG_TL_SMLOGIC_ST_NP_CURR_STATE_BB_SHIFT                                                    0
  #define PCIEIP_REG_TL_SMLOGIC_ST_PH_CURR_STATE_BB                                                          (0xf<<4) // Target posted request state machine.
  #define PCIEIP_REG_TL_SMLOGIC_ST_PH_CURR_STATE_BB_SHIFT                                                    4
  #define PCIEIP_REG_TL_SMLOGIC_ST_CPL_CURR_STATE_BB                                                         (0x3<<8) // CPL_CURR_STATE Read Completions State machine.
  #define PCIEIP_REG_TL_SMLOGIC_ST_CPL_CURR_STATE_BB_SHIFT                                                   8
  #define PCIEIP_REG_TL_SMLOGIC_ST_UNUSED0_BB                                                                (0x3f<<10) // 
  #define PCIEIP_REG_TL_SMLOGIC_ST_UNUSED0_BB_SHIFT                                                          10
  #define PCIEIP_REG_TL_SMLOGIC_ST_TX_SM_BB                                                                  (0x7<<16) // Transmit State machine.
  #define PCIEIP_REG_TL_SMLOGIC_ST_TX_SM_BB_SHIFT                                                            16
#define PCIEIP_REG_TL_PM_DEBUG_BB                                                                            0x00099cUL //Access:R    DataWidth:0x20   // Different OBFF Related Debug Signals.
#define PCIEIP_REG_TL_RST_DEBUG_BB                                                                           0x0009a0UL //Access:R    DataWidth:0x20   // Different Reset Related Debug Signals.
  #define PCIEIP_REG_TL_RST_DEBUG_AUX_DBG_SIGS_0_BB                                                          (0x7ff<<0) // 
  #define PCIEIP_REG_TL_RST_DEBUG_AUX_DBG_SIGS_0_BB_SHIFT                                                    0
  #define PCIEIP_REG_TL_RST_DEBUG_PCIE_LNK_PHY_RESET_MDIO_N_BB                                               (0x1<<11) // 
  #define PCIEIP_REG_TL_RST_DEBUG_PCIE_LNK_PHY_RESET_MDIO_N_BB_SHIFT                                         11
  #define PCIEIP_REG_TL_RST_DEBUG_PCIE_LNK_PHY_RESET_UC_N_BB                                                 (0x1<<12) // 
  #define PCIEIP_REG_TL_RST_DEBUG_PCIE_LNK_PHY_RESET_UC_N_BB_SHIFT                                           12
  #define PCIEIP_REG_TL_RST_DEBUG_HARD_RST_CFG_B_BB                                                          (0x1<<13) // 
  #define PCIEIP_REG_TL_RST_DEBUG_HARD_RST_CFG_B_BB_SHIFT                                                    13
  #define PCIEIP_REG_TL_RST_DEBUG_PERST_CFG_B_BB                                                             (0x1<<14) // 
  #define PCIEIP_REG_TL_RST_DEBUG_PERST_CFG_B_BB_SHIFT                                                       14
  #define PCIEIP_REG_TL_RST_DEBUG_RESERVED_BB                                                                (0x1<<15) // 
  #define PCIEIP_REG_TL_RST_DEBUG_RESERVED_BB_SHIFT                                                          15
  #define PCIEIP_REG_TL_RST_DEBUG_AUX_DBG_SIGS_1_BB                                                          (0x7ff<<16) // 
  #define PCIEIP_REG_TL_RST_DEBUG_AUX_DBG_SIGS_1_BB_SHIFT                                                    16
  #define PCIEIP_REG_TL_RST_DEBUG_RESERVED_1_BB                                                              (0x1f<<27) // 
  #define PCIEIP_REG_TL_RST_DEBUG_RESERVED_1_BB_SHIFT                                                        27
#define PCIEIP_REG_TL_IOV_VFCTL_0_BB                                                                         0x000a04UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_IOV_VFCTL_0_VF_NEXTBUS_BB                                                            (0x1<<0) // This bit when set enables the DUT to assume that VFs are residing on a bus number that is different than the one on which the PFs reside. When this bit is enabled, VF_offset is automatically set to be greater than 256. So VFs reside on the next bus number and PCIE IP will consume multiple bus numbers. In this case VFs are accessed using Cfg Type 1 Transactions. This bit should be set if ARI is not supported in the hierarchy.
  #define PCIEIP_REG_TL_IOV_VFCTL_0_VF_NEXTBUS_BB_SHIFT                                                      0
  #define PCIEIP_REG_TL_IOV_VFCTL_0_VF_OFFSET_VETO_BB                                                        (0x1<<1) // This bit when set, prevents DUT from automatically setting VF offset to be greater than 256(when vf_nextbus, bit 0 is set). User would have to set the offset bit on their own in this case.
  #define PCIEIP_REG_TL_IOV_VFCTL_0_VF_OFFSET_VETO_BB_SHIFT                                                  1
  #define PCIEIP_REG_TL_IOV_VFCTL_0_VF_EN_BAR_ADJUST_BB                                                      (0x1<<2) // This bit when set, enables DUT to automatically adjust the VF BAR size based on the System Page Size programming. When system Page size is programmed to be greater than User Page Size, DUT will change the VF BAR size advertized to be the new Effective system Page Size.
  #define PCIEIP_REG_TL_IOV_VFCTL_0_VF_EN_BAR_ADJUST_BB_SHIFT                                                2
#define PCIEIP_REG_TL_FCIMM_NP_LIMIT_BB                                                                      0x000a10UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_FC_NPD_IMM_LIMIT_BB                                               (0xfff<<0) // The number of accumulated non-posted data credits since the last request for immediate update that are needed to force an immediate update. The default is 0 since infinite non-posted data credits are advertised.
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_FC_NPD_IMM_LIMIT_BB_SHIFT                                         0
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_FC_NPH_IMM_LIMIT_BB                                               (0xff<<12) // The number of accumulated non-posted header credits since the last request for immediate update that are needed to force an immediate update. The default is (NPH_INIT_CREDIT &gt;&gt; 1). A value of 0 means always force an update (if infinite credits are not advertised).
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_FC_NPH_IMM_LIMIT_BB_SHIFT                                         12
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_ENA_FC_NP_IMMEDIATE_BB                                            (0x1<<20) // When set, released non-posted credits are flagged for immediate update. When clear, the credits may or not be updated until one or more of the accumulated credit thresholds for non-posted header or non-posted data is reached. (If clear and infinite credits are advertised, the thresholds are not used to force immediate updates.)
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_ENA_FC_NP_IMMEDIATE_BB_SHIFT                                      20
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_FC_NP_USCNT_BB                                                    (0xf<<21) // The number of microseconds between the last update and the forced update if there are outstanding non-posted credits to update. The resolution on the timer is +/- 1 us.
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_FC_NP_USCNT_BB_SHIFT                                              21
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_ENA_FC_NP_UPD_10US_BB                                             (0x1<<25) // When set, outstanding non-posted credit updates are forwarded to the DLL as immediate updates after a given number of microseconds (see below) elapses since the last update. This is typically used with non-immediate (threshold-based) updates.
  #define PCIEIP_REG_TL_FCIMM_NP_LIMIT_REG_ENA_FC_NP_UPD_10US_BB_SHIFT                                       25
#define PCIEIP_REG_TL_FCIMM_P_LIMIT_BB                                                                       0x000a14UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_FC_PD_IMM_LIMIT_BB                                                 (0xfff<<0) // The number of accumulated posted data credits since the last request for immediate update that are needed to force an immediate update. The default is (PD_INIT_CREDIT &gt;&gt; 1). A value of 0 means always force an update (if infinite credits are not advertised).
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_FC_PD_IMM_LIMIT_BB_SHIFT                                           0
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_FC_PH_IMM_LIMIT_BB                                                 (0xff<<12) // The number of accumulated posted header credits since the last request for immediate update that are needed to force an immediate update. The default is (PH_INIT_CREDIT &gt;&gt; 1). A value of 0 means always force an update (if infinite credits are not advertised).
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_FC_PH_IMM_LIMIT_BB_SHIFT                                           12
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_ENA_FC_P_IMMEDIATE_BB                                              (0x1<<20) // When set, released posted credits are flagged for immediate update. When clear, the credits may or not be updated until one or more of the accumulated credit thresholds for posted header or posted data is reached. (If clear and infinite credits are advertised, the thresholds are not used to force immediate updates.)
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_ENA_FC_P_IMMEDIATE_BB_SHIFT                                        20
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_FC_P_USCNT_BB                                                      (0xf<<21) // The number of microseconds between the last update and the forced update if there are outstanding posted credits to update. The resolution on the timer is +/- 1 us.
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_FC_P_USCNT_BB_SHIFT                                                21
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_ENA_FC_P_UPD_10US_BB                                               (0x1<<25) // When set, outstanding posted credit updates are forwarded to the DLL as immediate updates after a given number of microseconds (see below) elapses since the last update. This is typically used with non-immediate (threshold-based) updates.
  #define PCIEIP_REG_TL_FCIMM_P_LIMIT_REG_ENA_FC_P_UPD_10US_BB_SHIFT                                         25
#define PCIEIP_REG_REG_CAPENA_FN0_MASK_BB                                                                    0x000a1cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_CAP_ENA_FN0_MASK_BB                                                 (0xf<<0) // Each bit, when set, indicates that the corresponding capability available in cap_ena is valid only for function 0 and the the corresponding capability for other physical functions are disabled.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_CAP_ENA_FN0_MASK_BB_SHIFT                                           0
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_EXT_CAP_ENA_FN0_MASK_BB                                             (0x3ff<<4) // Each bit, when set, indicates that the corresponding capability available in ext_cap_ena is valid only for function 0 and the the corresponding capability for other physical functions are disabled.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_EXT_CAP_ENA_FN0_MASK_BB_SHIFT                                       4
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_RC_EXT_CAP_ENA_FN0_MASK_BB                                          (0x3<<14) // Each bit, when set, indicates that the corresponding capability available in rc_ext_cap_ena is valid only for function 0 and the the corresponding capability for other physical functions are disabled.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_RC_EXT_CAP_ENA_FN0_MASK_BB_SHIFT                                    14
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_EXT2_CAP_ENA_FN0_MASK_BB                                            (0xf<<16) // Each bit, when set, indicates that the corresponding capability available in ext2_cap_ena is valid only for function 0 and the the corresponding capability for other physical functions are disabled.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_EXT2_CAP_ENA_FN0_MASK_BB_SHIFT                                      16
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_EXT3_CAP_ENA_FN0_MASK_BB                                            (0xf<<20) // Each bit, when set, indicates that the corresponding capability available in ext3_cap_ena is valid only for function 0 and the the corresponding capability for other physical functions are disabled.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_EXT3_CAP_ENA_FN0_MASK_BB_SHIFT                                      20
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_UNUSED0_BB                                                          (0x3<<24) // 
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_UNUSED0_BB_SHIFT                                                    24
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_RC_EXT2_CAP_ENA_FN0_MASK_BB                                         (0x1f<<26) // Each bit, when set, indicates that the corresponding capability available in rc_ext2_cap_ena is valid only for function 0 and the the corresponding capability for other physical functions are disabled.
  #define PCIEIP_REG_REG_CAPENA_FN0_MASK_RC_EXT2_CAP_ENA_FN0_MASK_BB_SHIFT                                   26
#define PCIEIP_REG_VDM_CTL0_BB                                                                               0x000a20UL //Access:RW   DataWidth:0x20   // This register is present if PCIE_VDM_SUPP is defined in version.v
  #define PCIEIP_REG_VDM_CTL0_REG_VDM_LENGTH_BB                                                              (0x3ff<<0) // Length in bytes to which VDM messages are restricted to
  #define PCIEIP_REG_VDM_CTL0_REG_VDM_LENGTH_BB_SHIFT                                                        0
  #define PCIEIP_REG_VDM_CTL0_UNUSED0_BB                                                                     (0x3f<<10) // 
  #define PCIEIP_REG_VDM_CTL0_UNUSED0_BB_SHIFT                                                               10
  #define PCIEIP_REG_VDM_CTL0_REG_VDM_ENABLED_BB                                                             (0x1<<16) // VDM is enabled when this bit is set. PCIe will pass VDM messgaes to user interface when this bit is enabled, else it will be silently dropped.
  #define PCIEIP_REG_VDM_CTL0_REG_VDM_ENABLED_BB_SHIFT                                                       16
#define PCIEIP_REG_PTM_CTL0_BB                                                                               0x000a24UL //Access:RW   DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_REQ_START_BB                                                           (0x1<<0) // This bit when set, forces hardware to generate a PTM Request message. Hardware automatically clears this bit, when the PTM response is received.
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_REQ_START_BB_SHIFT                                                     0
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_ATTN_MASK_BB                                                           (0x1<<1) // This field when set will prevent hardware from generating attention when PTM req- response handshake has completed.
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_ATTN_MASK_BB_SHIFT                                                     1
  #define PCIEIP_REG_PTM_CTL0_UNUSED0_BB                                                                     (0xfffffff<<2) // 
  #define PCIEIP_REG_PTM_CTL0_UNUSED0_BB_SHIFT                                                               2
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_ATTN_STAT_BB                                                           (0x1<<30) // This field when set inidcates that the PTM req-response handshake initiated by software has completed. This bit is cleared by writing to it.
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_ATTN_STAT_BB_SHIFT                                                     30
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_REQ_STATUS_BB                                                          (0x1<<31) // This field when set inidcates that the PTM req-response handshake completed successfully. This field is valid only when bit 30 is set.
  #define PCIEIP_REG_PTM_CTL0_REG_PTM_REQ_STATUS_BB_SHIFT                                                    31
#define PCIEIP_REG_PTM_PMSTR_HI_BB                                                                           0x000a28UL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PTM_PMSTR_LO_BB                                                                           0x000a2cUL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PTM_LOCAL_HI_BB                                                                           0x000a30UL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PTM_LOCAL_LO_BB                                                                           0x000a34UL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PTM_RES_LOCAL_HI_BB                                                                       0x000a38UL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PTM_RES_LOCAL_LO_BB                                                                       0x000a3cUL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PTM_MSTR_PROP_DLY_BB                                                                      0x000a40UL //Access:R    DataWidth:0x20   // This register is present if PCIE_PTM_SUPP is defined in version.v
#define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_BB                                                                   0x000a50UL //Access:RW   DataWidth:0x20   // Control register for tx tlp statistics
  #define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_REG_TTX_TLP_STAT_EN_BB                                             (0x1<<0) // TLP Statistics Enable. Setting this bit to '1' enables the tx TLP statistics collection. Hardware will count various types of TLPs in the TX direction, as programmed in the reg_ttx_det_tlp_type register. When this bit is reset to '0', the counting stops and software can read the results. This bit is automatically cleared after the specified time if reg_ttx_tlp_stat_len is non-zero. All statistic read-back registers are cleared when this transitions from '0' to '1'.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_REG_TTX_TLP_STAT_EN_BB_SHIFT                                       0
  #define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_UNUSED0_BB                                                         (0x7f<<1) // 
  #define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_UNUSED0_BB_SHIFT                                                   1
  #define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_REG_TTX_TLP_STAT_LEN_BB                                            (0xffffff<<8) // TLP Statistics Length. This field specifies the TLP statistics collection time in microseconds. When it is set to '0', software has to clear the reg_ttx_tlp_stat_en bit to stop the operation. When it is set to a non-zero value, hardware automatically clears the enable bit after the specified time.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_CTL_REG_TTX_TLP_STAT_LEN_BB_SHIFT                                      8
#define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_BB                                                                  0x000a54UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_0_BB                                         (0xff<<0) // This register contains Enable bit and the TLP type that hardware can detect. Bit[7] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[6:0] Bits[6:0] indicate TLP type. TLP type can be masked using reg_ttx_det_tlp_type_mask[6:0].
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_0_BB_SHIFT                                   0
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_1_BB                                         (0xff<<8) // This register contains Enable bit and the TLP type that hardware can detect. Bit[15] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[14:8] Bits[14:8] indicate TLP type. TLP type can be masked using reg_ttx_det_tlp_type_mask[14:8].
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_1_BB_SHIFT                                   8
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_2_BB                                         (0xff<<16) // This register contains Enable bit and the TLP type that hardware can detect. Bit[23] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[22:16] Bits[22:16] indicate TLP type. TLP type can be masked using reg_ttx_det_tlp_type_mask[22:16].
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_2_BB_SHIFT                                   16
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_3_BB                                         (0xff<<24) // This register contains Enable bit and the TLP type that hardware can detect. Bit[31] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[30:24] Bits[30:24] indicate TLP type. TLP type can be masked using reg_ttx_det_tlp_type_mask[30:24].
  #define PCIEIP_REG_PCIER_TL_STAT_TX_TYPE_REG_TTX_DET_TLP_TYPE_3_BB_SHIFT                                   24
#define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_BB                                                                  0x000a58UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_0_BB                                    (0x7f<<0) // This register contains the mask bits for reg_ttx_det_tlp_type_0. Bits[7:0] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_ttx_det_tlp_type_0 will be masked. Masking works only if Enable bit (bit [7] of reg_ttx_det_tlp_type_0) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_0_BB_SHIFT                              0
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_UNUSED0_BB                                                        (0x1<<7) // 
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_UNUSED0_BB_SHIFT                                                  7
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_1_BB                                    (0x7f<<8) // This register contains the mask bits for reg_ttx_det_tlp_type_1. Bits[14:8] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_ttx_det_tlp_type_1 will be masked. Masking works only if Enable bit (bit [15] of reg_ttx_det_tlp_type_1) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_1_BB_SHIFT                              8
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_UNUSED1_BB                                                        (0x1<<15) // 
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_UNUSED1_BB_SHIFT                                                  15
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_2_BB                                    (0x7f<<16) // This register contains the mask bits for reg_ttx_det_tlp_type_2. Bits[22:16] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_ttx_det_tlp_type_2 will be masked. Masking works only if Enable bit (bit [7] of reg_ttx_det_tlp_type_2) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_2_BB_SHIFT                              16
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_UNUSED2_BB                                                        (0x1<<23) // 
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_UNUSED2_BB_SHIFT                                                  23
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_3_BB                                    (0x7f<<24) // This register contains the mask bits for reg_ttx_det_tlp_type_3. Bits[30:24] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_ttx_det_tlp_type_3 will be masked. Masking works only if Enable bit (bit [7] of reg_ttx_det_tlp_type_3) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_TX_MASK_REG_TTX_DET_TLP_TYPE_MASK_3_BB_SHIFT                              24
#define PCIEIP_REG_PCIER_TL_STAT_TX_CTR_LO_BB                                                                0x000a5cUL //Access:R    DataWidth:0x20   // TX TLP Statistics Low 32 bits. This register indicates the number of TLPs that have been trasmitted. It is cleared when reg_ttx_tlp_stat_en goes from '0' to '1'.
#define PCIEIP_REG_PCIER_TL_STAT_TX_CTR_HI_BB                                                                0x000a60UL //Access:R    DataWidth:0x20   // TX TLP Statistics High 32 bits. This register indicates the number of TLPs that have been trasmitted. It is cleared when reg_ttx_tlp_stat_en goes from '0' to '1'.
#define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_BB                                                                   0x000a64UL //Access:RW   DataWidth:0x20   // Control register for rx tlp statistics
  #define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_REG_TRX_TLP_STAT_EN_BB                                             (0x1<<0) // TLP Statistics Enable. Setting this bit to '1' enables the rx TLP statistics collection. Hardware will count various types of TLPs programmed in the reg_trx_det_tlp_type register in RX direction. When this bit is reset to '0', the counting stops and software can read the results. This bit is automatically cleared after the specified time if reg_trx_tlp_stat_len is non-zero. All statistic read-back registers are cleared when this transitions from '0' to '1'.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_REG_TRX_TLP_STAT_EN_BB_SHIFT                                       0
  #define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_UNUSED0_BB                                                         (0x7f<<1) // 
  #define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_UNUSED0_BB_SHIFT                                                   1
  #define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_REG_TRX_TLP_STAT_LEN_BB                                            (0xffffff<<8) // TLP Statistics Length. This field specifies the TLP statistics collection time in microseconds. When it is set to '0', software has to clear the reg_trx_tlp_stat_en bit to stop the operation. When it is set to a non-zero value, hardware automatically clears the enable bit after the specified time.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_CTL_REG_TRX_TLP_STAT_LEN_BB_SHIFT                                      8
#define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_BB                                                                  0x000a68UL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_0_BB                                         (0xff<<0) // This register contains Enable bit and the TLP type that hardware can detect. Bit[7] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[6:0] Bits[6:0] indicate TLP type. TLP type can be masked using reg_trx_det_tlp_type_mask[6:0].
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_0_BB_SHIFT                                   0
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_1_BB                                         (0xff<<8) // This register contains Enable bit and the TLP type that hardware can detect. Bit[15] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[14:8] Bits[14:8] indicate TLP type. TLP type can be masked using reg_trx_det_tlp_type_mask[14:8].
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_1_BB_SHIFT                                   8
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_2_BB                                         (0xff<<16) // This register contains Enable bit and the TLP type that hardware can detect. Bit[23] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[22:16] Bits[22:16] indicate TLP type. TLP type can be masked using reg_trx_det_tlp_type_mask[22:16].
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_2_BB_SHIFT                                   16
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_3_BB                                         (0xff<<24) // This register contains Enable bit and the TLP type that hardware can detect. Bit[31] is enable bit. If this bit is set to 1, then hardware will detect the TLP type indicated by bits[30:24] Bits[30:24] indicate TLP type. TLP type can be masked using reg_trx_det_tlp_type_mask[30:24].
  #define PCIEIP_REG_PCIER_TL_STAT_RX_TYPE_REG_TRX_DET_TLP_TYPE_3_BB_SHIFT                                   24
#define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_BB                                                                  0x000a6cUL //Access:RW   DataWidth:0x20   // Multi Field Register.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_0_BB                                    (0x7f<<0) // This register contains the mask bits for reg_trx_det_tlp_type_0. Bits[7:0] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_trx_det_tlp_type_0 will be masked. Masking works only if Enable bit (bit [7] of reg_trx_det_tlp_type_0) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_0_BB_SHIFT                              0
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_UNUSED0_BB                                                        (0x1<<7) // 
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_UNUSED0_BB_SHIFT                                                  7
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_1_BB                                    (0x7f<<8) // This register contains the mask bits for reg_trx_det_tlp_type_1. Bits[14:8] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_trx_det_tlp_type_1 will be masked. Masking works only if Enable bit (bit [15] of reg_trx_det_tlp_type_1) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_1_BB_SHIFT                              8
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_UNUSED1_BB                                                        (0x1<<15) // 
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_UNUSED1_BB_SHIFT                                                  15
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_2_BB                                    (0x7f<<16) // This register contains the mask bits for reg_trx_det_tlp_type_2. Bits[22:16] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_trx_det_tlp_type_2 will be masked. Masking works only if Enable bit (bit [7] of reg_trx_det_tlp_type_2) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_2_BB_SHIFT                              16
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_UNUSED2_BB                                                        (0x1<<23) // 
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_UNUSED2_BB_SHIFT                                                  23
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_3_BB                                    (0x7f<<24) // This register contains the mask bits for reg_trx_det_tlp_type_3. Bits[30:24] are the mask bits. Default value is 0. If a bit is set to 1 then corresponding bit of reg_trx_det_tlp_type_3 will be masked. Masking works only if Enable bit (bit [7] of reg_trx_det_tlp_type_3) is true.
  #define PCIEIP_REG_PCIER_TL_STAT_RX_MASK_REG_TRX_DET_TLP_TYPE_MASK_3_BB_SHIFT                              24
#define PCIEIP_REG_PCIER_TL_STAT_RX_CTR_LO_BB                                                                0x000a70UL //Access:R    DataWidth:0x20   // RX TLP Statistics Low 32 bits. This register indicates the number of TLPs that have been trasmitted. It is cleared when reg_trx_tlp_stat_en goes from '0' to '1'.
#define PCIEIP_REG_PCIER_TL_STAT_RX_CTR_HI_BB                                                                0x000a74UL //Access:R    DataWidth:0x20   // RX TLP Statistics High 32 bits. This register indicates the number of TLPs that have been trasmitted. It is cleared when reg_trx_tlp_stat_en goes from '0' to '1'.
#define PCIEIP_REG_PL_LTR_LATENCY_OFF_K2_E5                                                                  0x000b30UL //Access:RW   DataWidth:0x20   // LTR Latency Register. The function of this register field (and all other fields in this register) differs between an upstream port and a downstream port. For an upstream port, the register fields capture the corresponding fields in the LTR messages that are transmitted by the port. For a downstream port, the register fields capture the corresponding fields in the LTR messages that are received by the port. The full content of the register is reflected on the app_ltr_latency[31:0] output.
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_SNOOP_LATENCY_VALUE_K2_E5                                            (0x3ff<<0) // Snoop Latency Value.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_SNOOP_LATENCY_VALUE_K2_E5_SHIFT                                      0
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_SNOOP_LATENCY_SCALE_K2_E5                                            (0x7<<10) // Snoop Latency Scale.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_SNOOP_LATENCY_SCALE_K2_E5_SHIFT                                      10
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_SNOOP_LATENCY_REQUIRE_K2_E5                                          (0x1<<15) // Snoop Latency Requirement.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_SNOOP_LATENCY_REQUIRE_K2_E5_SHIFT                                    15
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_NO_SNOOP_LATENCY_VALUE_K2_E5                                         (0x3ff<<16) // No Snoop Latency Value.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_NO_SNOOP_LATENCY_VALUE_K2_E5_SHIFT                                   16
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_NO_SNOOP_LATENCY_SCALE_K2_E5                                         (0x7<<26) // No Snoop Latency Scale.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_NO_SNOOP_LATENCY_SCALE_K2_E5_SHIFT                                   26
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_NO_SNOOP_LATENCY_REQUIRE_K2_E5                                       (0x1<<31) // No Snoop Latency Requirement.  Note: The access attributes of this field are as follows:  - Dbi: R/W
  #define PCIEIP_REG_PL_LTR_LATENCY_OFF_NO_SNOOP_LATENCY_REQUIRE_K2_E5_SHIFT                                 31
#define PCIEIP_REG_AUX_CLK_FREQ_OFF_K2_E5                                                                    0x000b40UL //Access:RW   DataWidth:0x20   // Auxiliary Clock Frequency Control Register.
  #define PCIEIP_REG_AUX_CLK_FREQ_OFF_AUX_CLK_FREQ_K2_E5                                                     (0x3ff<<0) // The aux_clk frequency in MHz. This value is used to provide a 1 us reference for counting time during low-power states with aux_clk when the PHY has removed the pipe_clk. Frequencies lower than 1 MHz are possible but with a loss of accuracy in the time counted. If the actual frequency (f) of aux_clk does not exactly match the programmed frequency (f_prog), then there is an error in the time counted by the core that can be expressed in percentage as: err% = (f_prog/f-1)*100. For example if f=2.5 MHz and f_prog=3 MHz, then err% =(3/2.5-1)*100 =20%, meaning that the time counted by the core on aux_clk will be 20% greater than the time in us programmed in the corresponding time register (for example T_POWER_ON).  Note: This register field is sticky.
  #define PCIEIP_REG_AUX_CLK_FREQ_OFF_AUX_CLK_FREQ_K2_E5_SHIFT                                               0
#define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_BB                                                                 0x000c00UL //Access:RW   DataWidth:0x20   // Main status and control register for the PL DL Debug FIFO. Trigger and status shown in this register. For the above two bits, 0b10 is ready but not triggered, 0b11 is actively collecting and triggered, and 0b01 is that the DBG FIFO has collected all needed data.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_PRETRIG_CNT_BB                                          (0xff<<0) // When non-zero, indicates the maximum number of entries collected and saved prior to the trigger.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_PRETRIG_CNT_BB_SHIFT                                    0
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_FIFO_RD_CTRL_CSRD_USER_B_BB                                      (0x1<<8) // When cleared, indicates that the DBG FIFO is read by user interface. When set, indicates that the DBG FIFO is read by CS registers only.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_FIFO_RD_CTRL_CSRD_USER_B_BB_SHIFT                                8
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_TRIG_ADDR_BB                                            (0x1ff<<9) // When DBG FIFO is triggered, this indicates the FIFO address of the trigger location (where data corresponding to the trigger cycle is collected). Bit 17 is a wrap condition in the FIFO
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_TRIG_ADDR_BB_SHIFT                                      9
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_RADDR_BB                                                (0xff<<18) // Current dbg fifo read pointer on write side.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_RADDR_BB_SHIFT                                          18
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_ATTN_ST_BB                                              (0x1<<26) // Asserted when attn signal is generated and active. Write 1 to clear the attn.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_ATTN_ST_BB_SHIFT                                        26
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_ATTN_BB                                                 (0x1<<27) // Enables to generate attention to trigger external logic analyzers.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_ATTN_BB_SHIFT                                           27
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_RESERVED_28_BB                                                   (0x1<<28) // 
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_RESERVED_28_BB_SHIFT                                             28
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_FIFO_PRETRIG_FULL_BB                                             (0x1<<29) // Indicates that DBG FIFO has filled the pretrigger buffer before the trigger occurred. If the trigger occurs before the pretrigger buffer is filled, the trig_addr field is used to determine the amount of pre-trigger data collected
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_FIFO_PRETRIG_FULL_BB_SHIFT                                       29
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_TRIGGERED_BB                                            (0x1<<30) // Indicates that the DBG FIFO is triggered.
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_TRIGGERED_BB_SHIFT                                      30
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_ACTIVE_BB                                               (0x1<<31) // When set by write, activates the DBG FIFO logic. To retrigger, this must be cleared then set again.  When read, this indicates that the DBG FIFO is active (waiting for a trigger).
  #define PCIEIP_REG_PCIER_DBG_FIFO_CTLSTAT_DBG_FIFO_ACTIVE_BB_SHIFT                                         31
#define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_BB                                                             0x000c04UL //Access:RW   DataWidth:0x20   // Control and Status for accesses to DBG FIFO indirect registers.
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_WADDR_REG_BB                                             (0x1ff<<0) // The indirect write address register.
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_WADDR_REG_BB_SHIFT                                       0
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_WADDR_AUTOINC_BB                                         (0x1<<9) // When set, the indirect write address register is incremented on writes and, if ind_no_rd_addr is set, it is also incremented on reads.
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_WADDR_AUTOINC_BB_SHIFT                                   9
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_RADDR_REG_BB                                             (0x1ff<<10) // The indirect read address register.
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_RADDR_REG_BB_SHIFT                                       10
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_RADDR_AUTOINC_BB                                         (0x1<<19) // When set, the indirect read address register is incremented on reads.
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_RADDR_AUTOINC_BB_SHIFT                                   19
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_NO_RADDR_BB                                              (0x1<<20) // When set, the indirect write address register is used for indirect reads as well.
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_IND_NO_RADDR_BB_SHIFT                                        20
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_RESERVED_22_BB                                               (0x3<<21) // 
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_RESERVED_22_BB_SHIFT                                         21
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_DBG_FIFO_WADDR_BB                                            (0x1ff<<23) // Current write address to the external FIFO. Bit 31 is a wrap condition in the FIFO
  #define PCIEIP_REG_PCIER_DBG_FIFO_IND_CTLSTAT_DBG_FIFO_WADDR_BB_SHIFT                                      23
#define PCIEIP_REG_PCIER_DBG_FIFO_IND_DATA_BB                                                                0x000c08UL //Access:RW   DataWidth:0x20   // Access to the currently referenced indirect register via ind_raddr_reg or ind_waddr_reg. The registers are:  Register 0 :: IND_PCIE_DBG_TRIG0_0TO1_MASK - mask bits [319:0] for 0to1 trigger0 Register 10 :: IND_PCIE_DBG_TRIG0_1TO0_MASK - mask bits [319:0] for 1to0 trigger0 Register 20 :: IND_PCIE_DBG_TRIG0_MATCH_MASK - mask bits [319:0] for match trigger0 Register 30 :: IND_PCIE_DBG_TRIG0_MATCH_VALUE - match value bits[319:0] for trigger0  Register 40 :: IND_PCIE_DBG_TRIG0_DATA_SELECT - [127:0] Trigger0 signals each group is selected with 8 bits among the 256 32 bit signals Register 50 :: IND_PCIE_DBG_TRIG1_0TO1_MASK - mask bits [319:0] for 0to1 trigger1 Register 60 :: IND_PCIE_DBG_TRIG1_1TO0_MASK - mask bits [319:0] for 1to0 trigger1 Register 70 :: IND_PCIE_DBG_TRIG1_MATCH_MASK - mask bits [319:0] for match trigger1 Register 80 :: IND_PCIE_DBG_TRIG1_MATCH_VALUE - match value bits[319:0] for trigger1  Register 90 :: IND_PCIE_DBG_TRIG1_DATA_SELECT - [127:0] Trigger1 signals each group is selected with 8 bits among the 256 32 bit signals Register 100 :: IND_PCIE_DBG_TRIG2_0TO1_MASK - mask bits [319:0] for 0to1 trigger2 Register 110 :: IND_PCIE_DBG_TRIG2_1TO0_MASK - mask bits [319:0] for 1to0 trigger2 Register 120 :: IND_PCIE_DBG_TRIG2_MATCH_MASK - mask bits [319:0] for match trigger2 Register 130 :: IND_PCIE_DBG_TRIG2_MATCH_VALUE - match value bits[319:0] for trigger2  Register 140 :: IND_PCIE_DBG_TRIG2_DATA_SELECT - [127:0] Trigger2 signals each group is selected with 8 bits among the 256 32 bit signals Register 150 :: IND_PCIE_DBG_TRIG_SELECT - Trigger condition selecta Register 151 :: IND_PCIE_DBG_TRIG_TIMEOUT - Timeout select for Trigger sm Register 160 :: IND_PCIE_DBG_FILTER_0TO1_MASK - mask bits [319:0] for 0to1 data filtering Register 170 :: IND_PCIE_DBG_FILTER_1TO0_MASK - mask bits [319:0] for 1to0 data filtering Register 180 :: IND_PCIE_DBG_FILTER_MATCH0_MASK - mask bits [319:0] for match0 data filtering Register 190 :: IND_PCIE_DBG_FILTER_MATCH0_VALUE - match0 value bits[319:0] for data filtering Register 200 :: IND_PCIE_DBG_FILTER_MATCH1_MASK - mask bits [319:0] for match1 data filtering Register 210 :: IND_PCIE_DBG_FILTER_MATCH1_VALUE - match1 value bits[319:0] for data filtering Register 220 :: IND_PCIE_DBG_FILTER_SELECT - select the advanced filtering mechanism Register 228 :: IND_PCIE_DBG_ATTN_CTRL - Controls the attention generating state machine Register 229 :: IND_PCIE_DBG_ATTN_SELECT - Select which attention to go out Register 230 :: IND_PCIE_DBG_ATTN_0TO1_MASK - mask bits [319:0] for 0to1 attention signal group Register 240 :: IND_PCIE_DBG_ATTN_1TO0_MASK - mask bits [319:0] for 1to0 attention signal group Register 250 :: IND_PCIE_DBG_ATTN_MATCH_MASK - mask bits [319:0] for match attention signal group Register 260 :: IND_PCIE_DBG_ATTN_MATCH_VALUE - match value bits [319:0] for attention signal group Register 270 :: IND_PCIE_DBG_FIFO_DATA_SELECT - bits [127:0] selects the group of signals to store in the fifo each group is selected with 8 bits among the 256 32 bit signals Register 274 :: IND_PCIE_DBG_FIFO_TIME_SELECT - not used in debug fifo mode  Register 275 :: IND_DBG_FIFO_EVENT_SELECT - select which events to count for each of the two event counters. In addition, either level or rising edge sensitivity is selectable Register 276 :: IND_DBG_FIFO_EVENT_CFG0 - event config0 Register 277 :: IND_DBG_FIFO_EVENT_CFG1 - event config1  If accessing an unimplemented register, the value 0xbadaddee will be returned.
#define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_BB                                                                 0x000c0cUL //Access:RW   DataWidth:0x20   // Debug Control for PL DL DEBUG FIFO
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_TRIGSM_BB                                                        (0xf<<0) // Debug fifo trigger state machine status
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_TRIGSM_BB_SHIFT                                                  0
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_TRIGGER_OUT_BB                                                   (0x7<<4) // Trigger_out[2:0] status
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_TRIGGER_OUT_BB_SHIFT                                             4
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RESERVED_7_BB                                                    (0x1<<7) // 
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RESERVED_7_BB_SHIFT                                              7
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_ATTNSM_BB                                                        (0x3<<8) // Debug fifo attn state machine status
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_ATTNSM_BB_SHIFT                                                  8
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_DBG_FIFO_ATTN_BB                                                 (0x1<<10) // Debug fifo attn signal status
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_DBG_FIFO_ATTN_BB_SHIFT                                           10
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RESERVED_23_BB                                                   (0x1fff<<11) // 
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RESERVED_23_BB_SHIFT                                             11
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_CTRL_ATTN_BB                                             (0x1<<24) // When set, asserts attn signal irrespective of attnsm state
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_CTRL_ATTN_BB_SHIFT                                       24
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RD_SIDE_SOFT_RST_25_BB                                           (0x1<<25) // When set, resets user side interface for tlda2 fifo
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RD_SIDE_SOFT_RST_25_BB_SHIFT                                     25
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RD_SIDE_SOFT_RST_26_BB                                           (0x1<<26) // When set, resets user side interface for tlda fifo
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RD_SIDE_SOFT_RST_26_BB_SHIFT                                     26
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RD_SIDE_SOFT_RST_27_BB                                           (0x1<<27) // When set, resets user side interface for dbg fifo
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_RD_SIDE_SOFT_RST_27_BB_SHIFT                                     27
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_28_BB                                           (0x1<<28) // When set, clears the debug fifo active also enables user side flush for debug fifo
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_28_BB_SHIFT                                     28
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_29_BB                                           (0x1<<29) // When set, activates debug fifo
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_29_BB_SHIFT                                     29
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_30_BB                                           (0x1<<30) // When set, resets notrig_cnt and trigsm
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_30_BB_SHIFT                                     30
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_31_BB                                           (0x1<<31) // When set, dbg_fifo_triggered will get asserted irrespective of trigsm state
  #define PCIEIP_REG_PCIER_DBG_FIFO_DBG_CTL_REG_DBG_FIFO_CTL_31_BB_SHIFT                                     31
#define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_BB                                                                0x000c10UL //Access:RW   DataWidth:0x20   // Control for TL PL/DL debug FIFO's
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_USER_RD_FIFO_SEL_BB                                             (0x7<<0) // 000 - no FIFO selected to read by user if  001 - PL/DL FIFO is selected to read by user if  010 - TLDA-0 FIFO is selected to read by user if  100 - TLDA-1 FIFO is selected to read by user if  All other encodings are reserved and un-expected results would come if selected.
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_USER_RD_FIFO_SEL_BB_SHIFT                                       0
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_UNUSED0_BB                                                      (0x1ff<<3) // 
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_UNUSED0_BB_SHIFT                                                3
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_DBG_FIFO_SEL_BB                                                 (0x7<<12) // 000 - generic lane is selected  001 - predefined lane 1  010 - predefined lane 2  .  .  .  111 - Serdes data seleted
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_DBG_FIFO_SEL_BB_SHIFT                                           12
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_RESERVED_15_BB                                                  (0x1<<15) // 
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_RESERVED_15_BB_SHIFT                                            15
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_TLDA_FIFO_MUX_SEL_BB                                            (0xf<<16) // TLDA mux will be selected
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_TLDA_FIFO_MUX_SEL_BB_SHIFT                                      16
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_TLDA_FIFO2_MUX_SEL_BB                                           (0xf<<20) // TLDA2 mux will be selected
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_TLDA_FIFO2_MUX_SEL_BB_SHIFT                                     20
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_RESERVED_31_BB                                                  (0xff<<24) // 
  #define PCIEIP_REG_PCIER_TLPL_DBG_FIFO_CTL_RESERVED_31_BB_SHIFT                                            24
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_9_BB                                                                    0x000c18UL //Access:R    DataWidth:0x20   // The ten read registers give a total of 320 bits of data from the DBG FIFO. The DBG FIFO is read when PCIER_DBG_FIFO_RD_0 is read every time.  If the DBG FIFO location is not used, each register will read 0xFFFFFFFF.
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_8_BB                                                                    0x000c1cUL //Access:R    DataWidth:0x20   // Bits [287:256] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_7_BB                                                                    0x000c20UL //Access:R    DataWidth:0x20   // Bits [255:224] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_6_BB                                                                    0x000c24UL //Access:R    DataWidth:0x20   // Bits [223:192] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_5_BB                                                                    0x000c28UL //Access:R    DataWidth:0x20   // Bits [191:160] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_4_BB                                                                    0x000c2cUL //Access:R    DataWidth:0x20   // Bits [159:128] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_3_BB                                                                    0x000c30UL //Access:R    DataWidth:0x20   // Bits [127:96] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_2_BB                                                                    0x000c34UL //Access:R    DataWidth:0x20   // Bits [95:64] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_1_BB                                                                    0x000c38UL //Access:R    DataWidth:0x20   // Bits [63:32] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_DBG_FIFO_RD_0_BB                                                                    0x000c3cUL //Access:R    DataWidth:0x20   // Bits [31:0] of the current DBG FIFO location
#define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_BB                                                                    0x000c40UL //Access:RW   DataWidth:0x20   // Main status and control register for the Transaction Layer Data Analyzer. Trigger and status shown in this register. If both of the above two bits are set, the results are undefined.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_TL_TLDAFIFO_RADDR_BB                                                (0x7f<<0) // The current read address for the external FIFO
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_TL_TLDAFIFO_RADDR_BB_SHIFT                                          0
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_FIFO_RADDR_DWSEL_BB                                                 (0x1<<7) // When set, indicates that the lower 160 bits from the current FIFO read address are in the RDFIFO registers.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_FIFO_RADDR_DWSEL_BB_SHIFT                                           7
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_FIFO_RDAUTOINC_BB                                                   (0x1<<8) // When set and in local mode, reads to PCIER_TLDA_RDFIFO_4 will automatically increment the read address.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_FIFO_RDAUTOINC_BB_SHIFT                                             8
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LINK_SERIES_BB                                                      (0x1<<9) // When set, the FIFOs are linked in series to increase the depth of the FIFO.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LINK_SERIES_BB_SHIFT                                                9
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LINK_PARA_BB                                                        (0x1<<10) // When set, the FIFOs are linked in parallel to increase the width of the FIFO.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LINK_PARA_BB_SHIFT                                                  10
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_UI_PRETRIG_ALL_BB                                                   (0x1<<11) // Valid only when reading FIFOs from the user interface. When set, all pretrigger data is considered valid and will be present on the interface. Note that there is a bug in earlier versions of the TLDA that make this a write-only bit.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_UI_PRETRIG_ALL_BB_SHIFT                                             11
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_UNUSED0_BB                                                          (0x1<<12) // 
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_UNUSED0_BB_SHIFT                                                    12
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_DATA_AT_TRIG_BB                                                     (0x1<<13) // When set after FIFO has triggered, indicates that data at the trigger has been collected (as opposed to filtered out based on indirect register settings).
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_DATA_AT_TRIG_BB_SHIFT                                               13
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LOCAL_MODE_BB                                                       (0x1<<14) // When set, indicates that the FIFO is operating in local mode - FIFO will be read from the registers. When cleared, indicates that the FIFO is operating through reads from the user interface.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LOCAL_MODE_BB_SHIFT                                                 14
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_PRETRIG_CNT_BB                                                      (0x7f<<15) // The number of pre-trigger samples to keep. pretrig_cnt[6] is only valid when if there are two TLDA blocks and they are linked serially (extending the FIFO depth).
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_PRETRIG_CNT_BB_SHIFT                                                15
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_TRIG_ADDR_BB                                                        (0x7f<<22) // The FIFO write address at the time of the trigger. Use bit 13 of this register to determine if there was data collected at the time of the trigger.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_TRIG_ADDR_BB_SHIFT                                                  22
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_PRETRIG_FULL_BB                                                     (0x1<<29) // Set if pretrigger data was expected and enough data samples were collected prior to the trigger
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_PRETRIG_FULL_BB_SHIFT                                               29
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LOCAL_TLDA_TRIGGERED_BB                                             (0x1<<30) // Indicates that the TLDA is triggered.   For the above two bits, 0b10 is ready but not triggered, 0b11 is actively collecting and triggered, and 0b01 is that the TLDA has collected all needed data.
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LOCAL_TLDA_TRIGGERED_BB_SHIFT                                       30
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LOCAL_TLDA_ACTIVE_BB                                                (0x1<<31) // When set by write, activates the TLDA logic. To retrigger, this must be cleared then set again.  When read, this indicates that the TLDA is active (waiting for a trigger).
  #define PCIEIP_REG_PCIER_TLDA0_CTLSTAT_LOCAL_TLDA_ACTIVE_BB_SHIFT                                          31
#define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_BB                                                                0x000c44UL //Access:RW   DataWidth:0x20   // Control and status register for indirect accesses.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_WADDR_REG_BB                                                (0xff<<0) // The indirect write address register.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_WADDR_REG_BB_SHIFT                                          0
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_WADDR_AUTOINC_BB                                            (0x1<<8) // When set, the indirect write address register is incremented on writes and, if ind_no_rd_addr is set, it is also incremented on reads.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_WADDR_AUTOINC_BB_SHIFT                                      8
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_RADDR_REG_BB                                                (0xff<<9) // The indirect read address register.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_RADDR_REG_BB_SHIFT                                          9
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_RADDR_AUTOINC_BB                                            (0x1<<17) // When set, the indirect read address register is incremented on reads.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_RADDR_AUTOINC_BB_SHIFT                                      17
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_NO_RD_ADDR_BB                                               (0x1<<18) // When set, the indirect write address register (below) is used for indirect reads as well.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_IND_NO_RD_ADDR_BB_SHIFT                                         18
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_UNUSED0_BB                                                      (0x1f<<19) // 
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_UNUSED0_BB_SHIFT                                                19
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_TL_TLDAFIFO_WADDR_BB                                            (0x7f<<24) // Current write address to the external FIFO.
  #define PCIEIP_REG_PCIER_TLDA0_IND_CTLSTAT_TL_TLDAFIFO_WADDR_BB_SHIFT                                      24
#define PCIEIP_REG_PCIER_TLDA0_IND_DATA_BB                                                                   0x000c48UL //Access:RW   DataWidth:0x20   // Access to the currently referenced indirect register via ind_raddr_reg or ind_waddr_reg. Registers are more fully described in the TLDA docs. The registers are:  -- First trigger configuration registers Register 0 :: IND_TLDA_TRIG0_0TO1_MASK0 -- Trigger 0 rising edge mask bits [31:0]  Register 1 :: IND_TLDA_TRIG0_0TO1_MASK1 -- Trigger 0 rising edge mask bits [63:32]  Register 2 :: IND_TLDA_TRIG0_0TO1_MASK2 -- Trigger 0 rising edge mask bits [95:64]  Register 3 :: IND_TLDA_TRIG0_0TO1_MASK3 -- Trigger 0 rising edge mask bits [127:96]  Register 4 :: IND_TLDA_TRIG0_0TO1_MASK4 -- Trigger 0 rising edge mask bits [159:128]  Register 5 :: IND_TLDA_TRIG0_0TO1_MASK5 -- Trigger 0 rising edge mask bits [191:160]  Register 6 :: IND_TLDA_TRIG0_1TO0_MASK0 -- Trigger 0 falling edge mask bits [31:0]  Register 7 :: IND_TLDA_TRIG0_1TO0_MASK1 -- Trigger 0 falling edge mask bits [63:32]  Register 8 :: IND_TLDA_TRIG0_1TO0_MASK2 -- Trigger 0 falling edge mask bits [95:64]  Register 9 :: IND_TLDA_TRIG0_1TO0_MASK3 -- Trigger 0 falling edge mask bits [127:96]  Register 10 :: IND_TLDA_TRIG0_1TO0_MASK4 -- Trigger 0 falling edge mask bits [159:128]  Register 11 :: IND_TLDA_TRIG0_1TO0_MASK5 -- Trigger 0 falling edge mask bits [191:160]  Register 12 :: IND_TLDA_TRIG0_MATCH_MASK0 -- Trigger 0 bit match mask bits [31:0]  Register 13 :: IND_TLDA_TRIG0_MATCH_MASK1 -- Trigger 0 bit match mask bits [63:32]  Register 14 :: IND_TLDA_TRIG0_MATCH_MASK2 -- Trigger 0 bit match mask bits [95:64]  Register 15 :: IND_TLDA_TRIG0_MATCH_MASK3 -- Trigger 0 bit match mask bits [127:96]  Register 16 :: IND_TLDA_TRIG0_MATCH_MASK4 -- Trigger 0 bit match mask bits [159:128]  Register 17 :: IND_TLDA_TRIG0_MATCH_MASK5 -- Trigger 0 bit match mask bits [191:160]  Register 18 :: IND_TLDA_TRIG0_MATCH_VALUE0 -- Trigger 0 bit match value bits [31:0]  Register 19 :: IND_TLDA_TRIG0_MATCH_VALUE1 -- Trigger 0 bit match value bits [63:32]  Register 20 :: IND_TLDA_TRIG0_MATCH_VALUE2 -- Trigger 0 bit match value bits [95:64