/*
* CDDL HEADER START
*
* The contents of this file are subject to the terms of the
* Common Development and Distribution License, v.1,  (the "License").
* You may not use this file except in compliance with the License.
*
* You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
* or http://opensource.org/licenses/CDDL-1.0.
* See the License for the specific language governing permissions
* and limitations under the License.
*
* When distributing Covered Code, include this CDDL HEADER in each
* file and include the License file at usr/src/OPENSOLARIS.LICENSE.
* If applicable, add the following below this CDDL HEADER, with the
* fields enclosed by brackets "[]" replaced with your own identifying
* information: Portions Copyright [yyyy] [name of copyright owner]
*
* CDDL HEADER END
*/

/*
* Copyright 2014-2017 Cavium, Inc. 
* The contents of this file are subject to the terms of the Common Development 
* and Distribution License, v.1,  (the "License").

* You may not use this file except in compliance with the License.

* You can obtain a copy of the License at available 
* at http://opensource.org/licenses/CDDL-1.0

* See the License for the specific language governing permissions and 
* limitations under the License.
*/

/****************************************************************************
 * Name:        aeu_inputs.h
 *
 * Description: This file contains the AEU inputs bits definitions which
 *              should be used to configure the MISC_REGISTERS_AEU_ENABLE
 *              registers.
 *              The file was based upon the AEU specification.
 *
 * Created:     5/17/2015 yrosner
 *
 ****************************************************************************/
#ifndef AEU_INPUTS_H
#define AEU_INPUTS_H

/* AEU INPUT REGISTER 1 */
#define AEU_INPUT1_BITS_GPIO0				(1<<0) 
#define AEU_INPUT1_BITS_GPIO1				(1<<1)
#define AEU_INPUT1_BITS_GPIO2				(1<<2)
#define AEU_INPUT1_BITS_GPIO3				(1<<3)
#define AEU_INPUT1_BITS_GPIO4				(1<<4)
#define AEU_INPUT1_BITS_GPIO5				(1<<5)
#define AEU_INPUT1_BITS_GPIO6				(1<<6)
#define AEU_INPUT1_BITS_GPIO7				(1<<7)
#define AEU_INPUT1_BITS_GPIO8				(1<<8)
#define AEU_INPUT1_BITS_GPIO9				(1<<9)
#define AEU_INPUT1_BITS_GPIO10				(1<<10)
#define AEU_INPUT1_BITS_GPIO11				(1<<11)
#define AEU_INPUT1_BITS_GPIO12				(1<<12)
#define AEU_INPUT1_BITS_GPIO13				(1<<13)
#define AEU_INPUT1_BITS_GPIO14				(1<<14)
#define AEU_INPUT1_BITS_GPIO15				(1<<15)
#define AEU_INPUT1_BITS_GPIO16				(1<<16)
#define AEU_INPUT1_BITS_GPIO17				(1<<17)
#define AEU_INPUT1_BITS_GPIO18				(1<<18)
#define AEU_INPUT1_BITS_GPIO19				(1<<19)
#define AEU_INPUT1_BITS_GPIO20				(1<<20)
#define AEU_INPUT1_BITS_GPIO21				(1<<21)
#define AEU_INPUT1_BITS_GPIO22				(1<<22)
#define AEU_INPUT1_BITS_GPIO23				(1<<23)
#define AEU_INPUT1_BITS_GPIO24				(1<<24)
#define AEU_INPUT1_BITS_GPIO25				(1<<25)
#define AEU_INPUT1_BITS_GPIO26				(1<<26)
#define AEU_INPUT1_BITS_GPIO27				(1<<27)
#define AEU_INPUT1_BITS_GPIO28				(1<<28)
#define AEU_INPUT1_BITS_GPIO29				(1<<29)
#define AEU_INPUT1_BITS_GPIO30				(1<<30)
#define AEU_INPUT1_BITS_GPIO31				(1<<31)

#define AEU_INPUT1_BITS_PARITY_ERROR (0)
#define AEU_INPUT1_BITS_PARITY_COMMON_BLOCKS (0)

/* AEU INPUT REGISTER 2 */
#define AEU_INPUT2_BITS_PGLUE_CONFIG_SPACE		(1<<0)
#define AEU_INPUT2_BITS_PGLUE_MISC_FLR			(1<<1)
#define AEU_INPUT2_BITS_PGLUE_B_RBC_PARITY_ERROR	(1<<2)
#define AEU_INPUT2_BITS_PGLUE_B_RBC_HW_INTERRUPT	(1<<3)
#define AEU_INPUT2_BITS_PGLUE_MISC_MCTP_ATTN		(1<<4)
#define AEU_INPUT2_BITS_FLASH_EVENT			(1<<5)
#define AEU_INPUT2_BITS_SMB_EVENT			(1<<6)
#define AEU_INPUT2_BITS_MAIN_POWER_INTERRUPT		(1<<7)
#define AEU_INPUT2_BITS_SW_TIMERS_1			(1<<8)
#define AEU_INPUT2_BITS_SW_TIMERS_2			(1<<9)
#define AEU_INPUT2_BITS_SW_TIMERS_3			(1<<10)
#define AEU_INPUT2_BITS_SW_TIMERS_4			(1<<11)
#define AEU_INPUT2_BITS_SW_TIMERS_5			(1<<12)
#define AEU_INPUT2_BITS_SW_TIMERS_6			(1<<13)
#define AEU_INPUT2_BITS_SW_TIMERS_7			(1<<14)
#define AEU_INPUT2_BITS_SW_TIMERS_8			(1<<15)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_0	(1<<16)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_1	(1<<17)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_2	(1<<18)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_3	(1<<19)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_4	(1<<20)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_5	(1<<21)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_6	(1<<22)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_7	(1<<23)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_8	(1<<24)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_9	(1<<25)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_10	(1<<26)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_11	(1<<27)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_12	(1<<28)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_13	(1<<29)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_14	(1<<30)
#define AEU_INPUT2_BITS_PCIE_GLUE_OR_PXP_VPD_EVENT_15	(1<<31)

#define AEU_INPUT2_BITS_GENERATE_SYSTEM_KILL \
	(AEU_INPUT2_BITS_PGLUE_B_RBC_PARITY_ERROR)

#define AEU_INPUT2_BITS_PARITY_ERROR \
	(AEU_INPUT2_BITS_PGLUE_B_RBC_PARITY_ERROR)

#define AEU_INPUT2_BITS_PARITY_COMMON_BLOCKS \
	(AEU_INPUT2_BITS_PGLUE_B_RBC_PARITY_ERROR)

/* AEU INPUT REGISTER 3 */
#define AEU_INPUT3_BITS_GENERAL_ATTN0			(1<<0)
#define AEU_INPUT3_BITS_GENERAL_ATTN1			(1<<1)
#define AEU_INPUT3_BITS_GENERAL_ATTN2			(1<<2)
#define AEU_INPUT3_BITS_GENERAL_ATTN3			(1<<3)
#define AEU_INPUT3_BITS_GENERAL_ATTN4			(1<<4)
#define AEU_INPUT3_BITS_GENERAL_ATTN5			(1<<5)
#define AEU_INPUT3_BITS_GENERAL_ATTN6			(1<<6)
#define AEU_INPUT3_BITS_GENERAL_ATTN7			(1<<7)
#define AEU_INPUT3_BITS_GENERAL_ATTN8			(1<<8)
#define AEU_INPUT3_BITS_GENERAL_ATTN9			(1<<9)
#define AEU_INPUT3_BITS_GENERAL_ATTN10			(1<<10)
#define AEU_INPUT3_BITS_GENERAL_ATTN11			(1<<11)
#define AEU_INPUT3_BITS_GENERAL_ATTN12			(1<<12)
#define AEU_INPUT3_BITS_GENERAL_ATTN13			(1<<13)
#define AEU_INPUT3_BITS_GENERAL_ATTN14			(1<<14)
#define AEU_INPUT3_BITS_GENERAL_ATTN15			(1<<15)
#define AEU_INPUT3_BITS_GENERAL_ATTN16			(1<<16)
#define AEU_INPUT3_BITS_GENERAL_ATTN17			(1<<17)
#define AEU_INPUT3_BITS_GENERAL_ATTN18			(1<<18)
#define AEU_INPUT3_BITS_GENERAL_ATTN19			(1<<19)
#define AEU_INPUT3_BITS_GENERAL_ATTN20			(1<<20)
#define AEU_INPUT3_BITS_GENERAL_ATTN21			(1<<21)
#define AEU_INPUT3_BITS_GENERAL_ATTN22			(1<<22)
#define AEU_INPUT3_BITS_GENERAL_ATTN23			(1<<23)
#define AEU_INPUT3_BITS_GENERAL_ATTN24			(1<<24)
#define AEU_INPUT3_BITS_GENERAL_ATTN25			(1<<25)
#define AEU_INPUT3_BITS_GENERAL_ATTN26			(1<<26)
#define AEU_INPUT3_BITS_GENERAL_ATTN27			(1<<27)
#define AEU_INPUT3_BITS_GENERAL_ATTN28			(1<<28)
#define AEU_INPUT3_BITS_GENERAL_ATTN29			(1<<29)
#define AEU_INPUT3_BITS_GENERAL_ATTN30			(1<<30)
#define AEU_INPUT3_BITS_GENERAL_ATTN31			(1<<31)

#define AEU_INPUT3_BITS_PARITY_ERROR (0)
#define AEU_INPUT3_BITS_PARITY_COMMON_BLOCKS (0)
	
/* AEU INPUT REGISTER 4 */
#define AEU_INPUT4_BITS_GENERAL_ATTN32			(1<<0)
#define AEU_INPUT4_BITS_GENERAL_ATTN33			(1<<1)
#define AEU_INPUT4_BITS_GENERAL_ATTN34			(1<<2)
#define AEU_INPUT4_BITS_GENERAL_ATTN35			(1<<3) /* Driver initiate recovery flow */
#define AEU_INPUT4_BITS_CNIG_ATTN_PORT_0		(1<<4)
#define AEU_INPUT4_BITS_CNIG_ATTN_PORT_1		(1<<5)
#define AEU_INPUT4_BITS_CNIG_ATTN_PORT_2		(1<<6)
#define AEU_INPUT4_BITS_CNIG_ATTN_PORT_3		(1<<7)
#define AEU_INPUT4_BITS_MCP_CPU_EVENT			(1<<8)
#define AEU_INPUT4_BITS_MCP_WATCHDOG_TIMER		(1<<9)
#define AEU_INPUT4_BITS_MCP_M2P_ATTN			(1<<10)
#define AEU_INPUT4_BITS_AVS_STOP_STATUS_READY		(1<<11)
#define AEU_INPUT4_BITS_MSTAT_PARITY_ERROR		(1<<12)
#define AEU_INPUT4_BITS_MSTAT_HW_INTERRUPT		(1<<13)
#define AEU_INPUT4_BITS_MSTAT_PER_PATH_PARITY_ERROR	(1<<14)
#define AEU_INPUT4_BITS_MSTAT_PER_PATH_HW_INTERRUPT	(1<<15)
#define AEU_INPUT4_BITS_OPTE_PARITY_ERROR		(1<<16)
#define AEU_INPUT4_BITS_MCP_PARITY_ERROR		(1<<17)
#define AEU_INPUT4_BITS_RSRV18				(1<<18)
#define AEU_INPUT4_BITS_RSRV19				(1<<19)
#define AEU_INPUT4_BITS_RSRV20				(1<<20)
#define AEU_INPUT4_BITS_BMBN_HW_INTERRUPT		(1<<21)
#define AEU_INPUT4_BITS_NIG_PARITY_ERROR		(1<<22)
#define AEU_INPUT4_BITS_NIG_HW_INTERRUPT		(1<<23)
#define AEU_INPUT4_BITS_BMB_PARITY_ERROR		(1<<24)
#define AEU_INPUT4_BITS_BMB_HW_INTERRUPT		(1<<25)
#define AEU_INPUT4_BITS_BTB_PARITY_ERROR		(1<<26)
#define AEU_INPUT4_BITS_BTB_HW_INTERRUPT		(1<<27)
#define AEU_INPUT4_BITS_BRB_PARITY_ERROR		(1<<28)
#define AEU_INPUT4_BITS_BRB_HW_INTERRUPT		(1<<29)
#define AEU_INPUT4_BITS_PRS_PARITY_ERROR		(1<<30)
#define AEU_INPUT4_BITS_PRS_HW_INTERRUPT		(1<<31)

#define AEU_INPUT4_BITS_GENERATE_SYSTEM_KILL \
	(AEU_INPUT4_BITS_OPTE_PARITY_ERROR | \
	 AEU_INPUT4_BITS_MSTAT_PARITY_ERROR | \
	 AEU_INPUT4_BITS_MSTAT_PER_PATH_PARITY_ERROR | \
	 AEU_INPUT4_BITS_MCP_PARITY_ERROR | \
	 AEU_INPUT4_BITS_NIG_PARITY_ERROR | \
	 AEU_INPUT4_BITS_BMB_PARITY_ERROR)

#define AEU_INPUT4_BITS_GENERATE_PROCESS_KILL \
	(AEU_INPUT4_BITS_GENERAL_ATTN35 | \
	 AEU_INPUT4_BITS_BTB_PARITY_ERROR | \
	 AEU_INPUT4_BITS_BRB_PARITY_ERROR | \
	 AEU_INPUT4_BITS_PRS_PARITY_ERROR)

/* General ATTN35 is for the driver to trigger recovery flow */
#define AEU_INPUT4_BITS_PARITY_ERROR \
	(AEU_INPUT4_BITS_GENERATE_SYSTEM_KILL | \
	 AEU_INPUT4_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT4_BITS_PARITY_COMMON_BLOCKS \
	 (AEU_INPUT4_BITS_OPTE_PARITY_ERROR | \
	  AEU_INPUT4_BITS_MSTAT_PARITY_ERROR | \
	  AEU_INPUT4_BITS_MSTAT_PER_PATH_PARITY_ERROR | \
	  AEU_INPUT4_BITS_MCP_PARITY_ERROR)

/* AEU INPUT REGISTER 5 */
#define AEU_INPUT5_BITS_SRC_PARITY_ERROR		(1<<0)
#define AEU_INPUT5_BITS_SRC_HW_INTERRUPT		(1<<1)
#define AEU_INPUT5_BITS_PB_CLIENT1_PARITY_ERROR		(1<<2)
#define AEU_INPUT5_BITS_PB_CLIENT1_HW_INTERRUPT		(1<<3)
#define AEU_INPUT5_BITS_PB_CLIENT2_PARITY_ERROR		(1<<4)
#define AEU_INPUT5_BITS_PB_CLIENT2_HW_INTERRUPT		(1<<5)
#define AEU_INPUT5_BITS_RPB_PARITY_ERROR		(1<<6)
#define AEU_INPUT5_BITS_RPB_HW_INTERRUPT		(1<<7)
#define AEU_INPUT5_BITS_PBF_PARITY_ERROR		(1<<8)
#define AEU_INPUT5_BITS_PBF_HW_INTERRUPT		(1<<9)
#define AEU_INPUT5_BITS_QM_PARITY_ERROR			(1<<10)
#define AEU_INPUT5_BITS_QM_HW_INTERRUPT			(1<<11)
#define AEU_INPUT5_BITS_TM_PARITY_ERROR			(1<<12)
#define AEU_INPUT5_BITS_TM_HW_INTERRUPT			(1<<13)
#define AEU_INPUT5_BITS_MCM_PARITY_ERROR		(1<<14)
#define AEU_INPUT5_BITS_MCM_HW_INTERRUPT		(1<<15)
#define AEU_INPUT5_BITS_MSDM_PARITY_ERROR		(1<<16)
#define AEU_INPUT5_BITS_MSDM_HW_INTERRUPT		(1<<17)
#define AEU_INPUT5_BITS_MSEM_PARITY_ERROR		(1<<18)
#define AEU_INPUT5_BITS_MSEM_HW_INTERRUPT		(1<<19)
#define AEU_INPUT5_BITS_PCM_PARITY_ERROR		(1<<20)
#define AEU_INPUT5_BITS_PCM_HW_INTERRUPT		(1<<21)
#define AEU_INPUT5_BITS_PSDM_PARITY_ERROR		(1<<22)
#define AEU_INPUT5_BITS_PSDM_HW_INTERRUPT		(1<<23)
#define AEU_INPUT5_BITS_PSEM_PARITY_ERROR		(1<<24)
#define AEU_INPUT5_BITS_PSEM_HW_INTERRUPT		(1<<25)
#define AEU_INPUT5_BITS_TCM_PARITY_ERROR		(1<<26)
#define AEU_INPUT5_BITS_TCM_HW_INTERRUPT		(1<<27)
#define AEU_INPUT5_BITS_TSDM_PARITY_ERROR		(1<<28)
#define AEU_INPUT5_BITS_TSDM_HW_INTERRUPT		(1<<29)
#define AEU_INPUT5_BITS_TSEM_PARITY_ERROR		(1<<30)
#define AEU_INPUT5_BITS_TSEM_HW_INTERRUPT		(1<<31)

#define AEU_INPUT5_BITS_GENERATE_SYSTEM_KILL (0x0)

#define AEU_INPUT5_BITS_GENERATE_PROCESS_KILL \
	(AEU_INPUT5_BITS_SRC_PARITY_ERROR | \
	 AEU_INPUT5_BITS_PB_CLIENT1_PARITY_ERROR | \
	 AEU_INPUT5_BITS_PB_CLIENT2_PARITY_ERROR | \
	 AEU_INPUT5_BITS_RPB_PARITY_ERROR | \
	 AEU_INPUT5_BITS_PBF_PARITY_ERROR | \
	 AEU_INPUT5_BITS_QM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_TM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_MCM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_MSDM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_MSEM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_PCM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_PSDM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_PSEM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_TCM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_TSDM_PARITY_ERROR | \
	 AEU_INPUT5_BITS_TSEM_PARITY_ERROR)

#define AEU_INPUT5_BITS_PARITY_ERROR \
	(AEU_INPUT5_BITS_GENERATE_SYSTEM_KILL | \
	 AEU_INPUT5_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT5_BITS_PARITY_COMMON_BLOCKS (0)

/* AEU INPUT REGISTER 6 */
#define AEU_INPUT6_BITS_UCM_PARITY_ERROR		(1<<0)
#define AEU_INPUT6_BITS_UCM_HW_INTERRUPT		(1<<1)
#define AEU_INPUT6_BITS_USDM_PARITY_ERROR		(1<<2)
#define AEU_INPUT6_BITS_USDM_HW_INTERRUPT		(1<<3)
#define AEU_INPUT6_BITS_USEM_PARITY_ERROR		(1<<4)
#define AEU_INPUT6_BITS_USEM_HW_INTERRUPT		(1<<5)
#define AEU_INPUT6_BITS_XCM_PARITY_ERROR		(1<<6)
#define AEU_INPUT6_BITS_XCM_HW_INTERRUPT		(1<<7)
#define AEU_INPUT6_BITS_XSDM_PARITY_ERROR		(1<<8)
#define AEU_INPUT6_BITS_XSDM_HW_INTERRUPT		(1<<9)
#define AEU_INPUT6_BITS_XSEM_PARITY_ERROR		(1<<10)
#define AEU_INPUT6_BITS_XSEM_HW_INTERRUPT		(1<<11)
#define AEU_INPUT6_BITS_YCM_PARITY_ERROR		(1<<12)
#define AEU_INPUT6_BITS_YCM_HW_INTERRUPT		(1<<13)
#define AEU_INPUT6_BITS_YSDM_PARITY_ERROR		(1<<14)
#define AEU_INPUT6_BITS_YSDM_HW_INTERRUPT		(1<<15)
#define AEU_INPUT6_BITS_YSEM_PARITY_ERROR		(1<<16)
#define AEU_INPUT6_BITS_YSEM_HW_INTERRUPT		(1<<17)
#define AEU_INPUT6_BITS_XYLD_PARITY_ERROR		(1<<18)
#define AEU_INPUT6_BITS_XYLD_HW_INTERRUPT		(1<<19)
#define AEU_INPUT6_BITS_TMLD_PARITY_ERROR		(1<<20)
#define AEU_INPUT6_BITS_TMLD_HW_INTERRUPT		(1<<21)
#define AEU_INPUT6_BITS_MULD_PARITY_ERROR		(1<<22)
#define AEU_INPUT6_BITS_MULD_HW_INTERRUPT		(1<<23)
#define AEU_INPUT6_BITS_YULD_PARITY_ERROR		(1<<24)
#define AEU_INPUT6_BITS_YULD_HW_INTERRUPT		(1<<25)
#define AEU_INPUT6_BITS_DORQ_PARITY_ERROR		(1<<26)
#define AEU_INPUT6_BITS_DORQ_HW_INTERRUPT		(1<<27)
#define AEU_INPUT6_BITS_DBG_PARITY_ERROR		(1<<28)
#define AEU_INPUT6_BITS_DBG_HW_INTERRUPT		(1<<29)
#define AEU_INPUT6_BITS_IPC_PARITY_ERROR		(1<<30)
#define AEU_INPUT6_BITS_IPC_HW_INTERRUPT		(1<<31)

#define AEU_INPUT6_BITS_GENERATE_SYSTEM_KILL \
	(AEU_INPUT6_BITS_IPC_PARITY_ERROR)

#define AEU_INPUT6_BITS_GENERATE_PROCESS_KILL \
	(AEU_INPUT6_BITS_UCM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_USDM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_USEM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_XCM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_XSDM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_XSEM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_YCM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_YSDM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_YSEM_PARITY_ERROR | \
	 AEU_INPUT6_BITS_XYLD_PARITY_ERROR | \
	 AEU_INPUT6_BITS_TMLD_PARITY_ERROR | \
	 AEU_INPUT6_BITS_MULD_PARITY_ERROR | \
	 AEU_INPUT6_BITS_YULD_PARITY_ERROR | \
	 AEU_INPUT6_BITS_DORQ_PARITY_ERROR)

#define AEU_INPUT6_BITS_PARITY_ERROR \
	(AEU_INPUT6_BITS_GENERATE_SYSTEM_KILL | \
	 AEU_INPUT6_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT6_BITS_PARITY_COMMON_BLOCKS \
	(AEU_INPUT6_BITS_IPC_PARITY_ERROR)

/* AEU INPUT REGISTER 7 */
#define AEU_INPUT7_BITS_CCFC_PARITY_ERROR		(1<<0)
#define AEU_INPUT7_BITS_CCFC_HW_INTERRUPT		(1<<1)
#define AEU_INPUT7_BITS_CDU_PARITY_ERROR		(1<<2)
#define AEU_INPUT7_BITS_CDU_HW_INTERRUPT		(1<<3)
#define AEU_INPUT7_BITS_DMAE_PARITY_ERROR		(1<<4)
#define AEU_INPUT7_BITS_DMAE_HW_INTERRUPT		(1<<5)
#define AEU_INPUT7_BITS_IGU_PARITY_ERROR		(1<<6)
#define AEU_INPUT7_BITS_IGU_HW_INTERRUPT		(1<<7)
#define AEU_INPUT7_BITS_ATC_PARITY_ERROR		(1<<8)
#define AEU_INPUT7_BITS_ATC_HW_INTERRUPT		(1<<9)
#define AEU_INPUT7_BITS_CAU_PARITY_ERROR		(1<<10)
#define AEU_INPUT7_BITS_CAU_HW_INTERRUPT		(1<<11)
#define AEU_INPUT7_BITS_PTU_PARITY_ERROR		(1<<12)
#define AEU_INPUT7_BITS_PTU_HW_INTERRUPT		(1<<13)
#define AEU_INPUT7_BITS_PRM_PARITY_ERROR		(1<<14)
#define AEU_INPUT7_BITS_PRM_HW_INTERRUPT		(1<<15)
#define AEU_INPUT7_BITS_TCFC_PARITY_ERROR		(1<<16)
#define AEU_INPUT7_BITS_TCFC_HW_INTERRUPT		(1<<17)
#define AEU_INPUT7_BITS_RDIF_PARITY_ERROR		(1<<18)
#define AEU_INPUT7_BITS_RDIF_HW_INTERRUPT		(1<<19)
#define AEU_INPUT7_BITS_TDIF_PARITY_ERROR		(1<<20)
#define AEU_INPUT7_BITS_TDIF_HW_INTERRUPT		(1<<21)
#define AEU_INPUT7_BITS_RSS_PARITY_ERROR		(1<<22)
#define AEU_INPUT7_BITS_RSS_HW_INTERRUPT		(1<<23)
#define AEU_INPUT7_BITS_MISC_PARITY_ERROR		(1<<24)
#define AEU_INPUT7_BITS_MISC_HW_INTERRUPT		(1<<25)
#define AEU_INPUT7_BITS_MISCS_PARITY_ERROR		(1<<26)
#define AEU_INPUT7_BITS_MISCS_HW_INTERRUPT		(1<<27)
#define AEU_INPUT7_BITS_VAUX_PCI_CORE_OR_PGLUE_PARITY_ERROR	(1<<28)
#define AEU_INPUT7_BITS_VAUX_PCI_CORE_HW_INTERRUPT	(1<<29)
#define AEU_INPUT7_BITS_PSWRQ_PARITY_ERROR		(1<<30)
#define AEU_INPUT7_BITS_PSWRQ_HW_INTERRUPT		(1<<31)

#define AEU_INPUT7_BITS_GENERATE_SYSTEM_KILL \
	 (AEU_INPUT7_BITS_IGU_PARITY_ERROR | \
	  AEU_INPUT7_BITS_ATC_PARITY_ERROR | \
	  AEU_INPUT7_BITS_CAU_PARITY_ERROR | \
	  AEU_INPUT7_BITS_MISC_PARITY_ERROR | \
	  AEU_INPUT7_BITS_MISCS_PARITY_ERROR | \
	  AEU_INPUT7_BITS_VAUX_PCI_CORE_OR_PGLUE_PARITY_ERROR | \
	  AEU_INPUT7_BITS_PSWRQ_PARITY_ERROR)

#define AEU_INPUT7_BITS_GENERATE_PROCESS_KILL \
	(AEU_INPUT7_BITS_CCFC_PARITY_ERROR | \
	 AEU_INPUT7_BITS_CDU_PARITY_ERROR | \
	 AEU_INPUT7_BITS_DMAE_PARITY_ERROR | \
	 AEU_INPUT7_BITS_PTU_PARITY_ERROR | \
	 AEU_INPUT7_BITS_PRM_PARITY_ERROR | \
	 AEU_INPUT7_BITS_TCFC_PARITY_ERROR | \
	 AEU_INPUT7_BITS_RDIF_PARITY_ERROR | \
	 AEU_INPUT7_BITS_TDIF_PARITY_ERROR | \
	 AEU_INPUT7_BITS_RSS_PARITY_ERROR)

#define AEU_INPUT7_BITS_PARITY_ERROR \
	(AEU_INPUT7_BITS_GENERATE_SYSTEM_KILL | \
	 AEU_INPUT7_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT7_BITS_PARITY_COMMON_BLOCKS \
	 (AEU_INPUT7_BITS_MISCS_PARITY_ERROR | \
	  AEU_INPUT7_BITS_VAUX_PCI_CORE_OR_PGLUE_PARITY_ERROR)

/* AEU INPUT REGISTER 8 */
#define AEU_INPUT8_BITS_PSWRQ_PCI_CLK_PARITY_ERROR	(1<<0)
#define AEU_INPUT8_BITS_PSWRQ_PCI_CLK_HW_INTERRUPT	(1<<1)
#define AEU_INPUT8_BITS_PSWWR_PARITY_ERROR		(1<<2)
#define AEU_INPUT8_BITS_PSWWR_HW_INTERRUPT		(1<<3)
#define AEU_INPUT8_BITS_PSWWR_PCI_CLK_PARITY_ERROR	(1<<4)
#define AEU_INPUT8_BITS_PSWWR_PCI_CLK_HW_INTERRUPT	(1<<5)
#define AEU_INPUT8_BITS_PSWRD_PARITY_ERROR		(1<<6)
#define AEU_INPUT8_BITS_PSWRD_HW_INTERRUPT		(1<<7)
#define AEU_INPUT8_BITS_PSWRD_PCI_CLK_PARITY_ERROR	(1<<8)
#define AEU_INPUT8_BITS_PSWRD_PCI_CLK_HW_INTERRUPT	(1<<9)
#define AEU_INPUT8_BITS_PSWHST_PARITY_ERROR		(1<<10)
#define AEU_INPUT8_BITS_PSWHST_HW_INTERRUPT		(1<<11)
#define AEU_INPUT8_BITS_PSWHST_PCI_CLK_PARITY_ERROR	(1<<12)
#define AEU_INPUT8_BITS_PSWHST_PCI_CLK_HW_INTERRUPT	(1<<13)
#define AEU_INPUT8_BITS_GRC_PARITY_ERROR		(1<<14)
#define AEU_INPUT8_BITS_GRC_HW_INTERRUPT		(1<<15)
#define AEU_INPUT8_BITS_CPMU_PARITY_ERROR		(1<<16)
#define AEU_INPUT8_BITS_CPMU_HW_INTERRUPT		(1<<17)
#define AEU_INPUT8_BITS_NCSI_PARITY_ERROR		(1<<18)
#define AEU_INPUT8_BITS_NCSI_HW_INTERRUPT		(1<<19)
#define AEU_INPUT8_BITS_YSEM_PRAM_PARITY_ERROR		(1<<20)
#define AEU_INPUT8_BITS_XSEM_PRAM_PARITY_ERROR		(1<<21)
#define AEU_INPUT8_BITS_USEM_PRAM_PARITY_ERROR		(1<<22)
#define AEU_INPUT8_BITS_TSEM_PRAM_PARITY_ERROR		(1<<23)
#define AEU_INPUT8_BITS_PSEM_PRAM_PARITY_ERROR		(1<<24)
#define AEU_INPUT8_BITS_MSEM_PRAM_PARITY_ERROR		(1<<25)
#define AEU_INPUT8_BITS_PXP_MISC_MPS_ATTN		(1<<26)
#define AEU_INPUT8_BITS_PCIE_GLUE_OR_PXP_EXPANSION_ROM_EVENT	(1<<27)
#define AEU_INPUT8_BITS_PERST_B_ASSERTION		(1<<28)
#define AEU_INPUT8_BITS_PERST_B_DE_ASSERTION		(1<<29)
#define AEU_INPUT8_BITS_WOL_PARITY_ERROR		(1<<30) /* Relevant only for AH */
#define AEU_INPUT8_BITS_WOL_HW_INTERRUPT		(1<<31) /* Relevant only for AH */

#define AEU_INPUT8_BITS_GENERATE_SYSTEM_KILL_K2 \
	(AEU_INPUT8_BITS_PSWRQ_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWWR_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWWR_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWRD_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWRD_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWHST_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWHST_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_CPMU_PARITY_ERROR | \
	 AEU_INPUT8_BITS_NCSI_PARITY_ERROR | \
	 AEU_INPUT8_BITS_WOL_PARITY_ERROR)

#define AEU_INPUT8_BITS_GENERATE_SYSTEM_KILL_BB \
	(AEU_INPUT8_BITS_PSWRQ_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWWR_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWWR_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWRD_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWRD_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWHST_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSWHST_PCI_CLK_PARITY_ERROR | \
	 AEU_INPUT8_BITS_CPMU_PARITY_ERROR | \
	 AEU_INPUT8_BITS_NCSI_PARITY_ERROR)

#define AEU_INPUT8_BITS_GENERATE_PROCESS_KILL \
	(AEU_INPUT8_BITS_GRC_PARITY_ERROR | \
	 AEU_INPUT8_BITS_XSEM_PRAM_PARITY_ERROR | \
	 AEU_INPUT8_BITS_USEM_PRAM_PARITY_ERROR | \
	 AEU_INPUT8_BITS_TSEM_PRAM_PARITY_ERROR | \
	 AEU_INPUT8_BITS_PSEM_PRAM_PARITY_ERROR | \
	 AEU_INPUT8_BITS_MSEM_PRAM_PARITY_ERROR)

#define AEU_INPUT8_BITS_PARITY_ERROR_BB \
	(AEU_INPUT8_BITS_GENERATE_SYSTEM_KILL_BB | \
	 AEU_INPUT8_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT8_BITS_PARITY_ERROR_K2 \
	(AEU_INPUT8_BITS_GENERATE_SYSTEM_KILL_K2 | \
	 AEU_INPUT8_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT8_BITS_PARITY_COMMON_BLOCKS_K2 \
	(AEU_INPUT8_BITS_NCSI_PARITY_ERROR | \
	 AEU_INPUT8_BITS_GRC_PARITY_ERROR | \
	 AEU_INPUT8_BITS_WOL_PARITY_ERROR)

#define AEU_INPUT8_BITS_PARITY_COMMON_BLOCKS_BB \
	(AEU_INPUT8_BITS_NCSI_PARITY_ERROR | \
	 AEU_INPUT8_BITS_GRC_PARITY_ERROR)

/* AEU INPUT REGISTER 9 */
#define AEU_INPUT9_BITS_MCP_LATCHED_MEMORY_PARITY	(1<<0)
#define AEU_INPUT9_BITS_MCP_LATCHED_SCRATCHPAD_CACHE	(1<<1)
#define AEU_INPUT9_BITS_AVS_PARITY			(1<<2)
#define AEU_INPUT9_BITS_AVS_HW_ATTN			(1<<3)
#define AEU_INPUT9_BITS_PCIE_CORE_HW_INTERRUPT		(1<<4)
#define AEU_INPUT9_BITS_PCIE_LINK_UP			(1<<5)
#define AEU_INPUT9_BITS_PCIE_HOT_RESET			(1<<6)
#define AEU_INPUT9_BITS_RSRV_7				(1<<7)
#define AEU_INPUT9_BITS_RSRV_8				(1<<8)
#define AEU_INPUT9_BITS_RSRV_9				(1<<9)
#define AEU_INPUT9_BITS_RSRV_10				(1<<10)
#define AEU_INPUT9_BITS_RSRV_11				(1<<11)
#define AEU_INPUT9_BITS_RSRV_12				(1<<12)
#define AEU_INPUT9_BITS_RSRV_13				(1<<13)
#define AEU_INPUT9_BITS_RSRV_14				(1<<14)
#define AEU_INPUT9_BITS_RSRV_15				(1<<15)
#define AEU_INPUT9_BITS_RSRV_16				(1<<16)
#define AEU_INPUT9_BITS_RSRV_17				(1<<17)
#define AEU_INPUT9_BITS_RSRV_18				(1<<18)
#define AEU_INPUT9_BITS_RSRV_19				(1<<19)
#define AEU_INPUT9_BITS_RSRV_20				(1<<20)
#define AEU_INPUT9_BITS_RSRV_21				(1<<21)
#define AEU_INPUT9_BITS_RSRV_22				(1<<22)
#define AEU_INPUT9_BITS_RSRV_23				(1<<23)
#define AEU_INPUT9_BITS_RSRV_24				(1<<24)
#define AEU_INPUT9_BITS_RSRV_25				(1<<25)
#define AEU_INPUT9_BITS_RSRV_26				(1<<26)
#define AEU_INPUT9_BITS_RSRV_27				(1<<27)
#define AEU_INPUT9_BITS_RSRV_28				(1<<28)
#define AEU_INPUT9_BITS_RSRV_29				(1<<29)
#define AEU_INPUT9_BITS_RSRV_30				(1<<30)
#define AEU_INPUT9_BITS_RSRV_31				(1<<31)

#define AEU_INPUT9_BITS_GENERATE_SYSTEM_KILL \
	(AEU_INPUT9_BITS_MCP_LATCHED_MEMORY_PARITY | \
	 AEU_INPUT9_BITS_AVS_PARITY)

#define AEU_INPUT9_BITS_GENERATE_PROCESS_KILL (0)

#define AEU_INPUT9_BITS_PARITY_ERROR \
	(AEU_INPUT9_BITS_GENERATE_SYSTEM_KILL | \
	 AEU_INPUT9_BITS_GENERATE_PROCESS_KILL)

#define AEU_INPUT9_BITS_PARITY_COMMON_BLOCKS \
	(AEU_INPUT9_BITS_MCP_LATCHED_MEMORY_PARITY | \
	 AEU_INPUT9_BITS_AVS_PARITY)
#endif /* AEU_INPUTS_H */
