/*
* CDDL HEADER START
*
* The contents of this file are subject to the terms of the
* Common Development and Distribution License, v.1,  (the "License").
* You may not use this file except in compliance with the License.
*
* You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
* or http://opensource.org/licenses/CDDL-1.0.
* See the License for the specific language governing permissions
* and limitations under the License.
*
* When distributing Covered Code, include this CDDL HEADER in each
* file and include the License file at usr/src/OPENSOLARIS.LICENSE.
* If applicable, add the following below this CDDL HEADER, with the
* fields enclosed by brackets "[]" replaced with your own identifying
* information: Portions Copyright [yyyy] [name of copyright owner]
*
* CDDL HEADER END
*/

/*
* Copyright 2014-2017 Cavium, Inc. 
* The contents of this file are subject to the terms of the Common Development 
* and Distribution License, v.1,  (the "License").

* You may not use this file except in compliance with the License.

* You can obtain a copy of the License at available 
* at http://opensource.org/licenses/CDDL-1.0

* See the License for the specific language governing permissions and 
* limitations under the License.
*/

#ifndef __INIT_VALUES_ZIPPED_H__
#define __INIT_VALUES_ZIPPED_H__

/* initialization commands array */
ARRAY_DECL u32 init_ops[] = {
	/* GRC */
	0x00030003, 0xffff0000, 	/* if phase != 'engine', skip 3 ops (no DMAE) */
	0x00020002, 0x00450000, 	/* if mode != '!asic', skip 2 ops */
	0x0280c201, 0x00000000, 	/* write 0x0 to address 0x50184 */
	0x02810201, 0x00000000, 	/* write 0x0 to address 0x50204 */
	/* MISCS */
	0x00060003, 0xffff0000, 	/* if phase != 'engine', skip 6 ops (no DMAE) */
	0x00030002, 0x00450000, 	/* if mode != '!asic', skip 3 ops */
	0x0048c201, 0x00000000, 	/* write 0x0 to address 0x9184 */
	0x0048d201, 0x00000000, 	/* write 0x0 to address 0x91a4 */
	0x004ba601, 0x00000001, 	/* write 0x1 to address 0x974c */
	0x00010002, 0x00ac0000, 	/* if mode != '(!asic)&bb', skip 1 ops */
	0x0048ca01, 0x00000000, 	/* write 0x0 to address 0x9194 */
	/* MISC */
	0x003b0003, 0xffff0000, 	/* if phase != 'engine', skip 59 ops (no DMAE) */
	0x0040c201, 0x00000000, 	/* write 0x0 to address 0x8184 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x28007201, 0x00000001, 	/* write 0x1 to address 0x5000e4 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x00460a01, 0x00000000, 	/* write 0x0 to address 0x8c14 */
	0x00403c01, 0x33bfbfbf, 	/* write 0x33bfbfbf to address 0x8078 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x00404401, 0x07fffff8, 	/* write 0x7fffff8 to address 0x8088 */
	0x00010002, 0x00b90000, 	/* if mode != '!k2', skip 1 ops */
	0x00404401, 0x003ffff8, 	/* write 0x3ffff8 to address 0x8088 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x00404c01, 0x000002c0, 	/* write 0x2c0 to address 0x8098 */
	0x00010002, 0x00b90000, 	/* if mode != '!k2', skip 1 ops */
	0x00404c01, 0x000000c0, 	/* write 0xc0 to address 0x8098 */
	0x00403a01, 0x1fffffff, 	/* write 0x1fffffff to address 0x8074 */
	0x00404201, 0xffffffff, 	/* write 0xffffffff to address 0x8084 */
	0x00404a01, 0xffffffff, 	/* write 0xffffffff to address 0x8094 */
	0x000c0002, 0x00010000, 	/* if mode != 'bb|k2', skip 12 ops */
	0xa2028601, 0x00000001, 	/* write 0x1 to address 0x144050c */
	0xa2031401, 0x0000000f, 	/* write 0xf to address 0x1440628 */
	0xaa028601, 0x00000001, 	/* write 0x1 to address 0x154050c */
	0xaa031401, 0x0000000f, 	/* write 0xf to address 0x1540628 */
	0xb2028601, 0x00000001, 	/* write 0x1 to address 0x164050c */
	0xb2031401, 0x0000000f, 	/* write 0xf to address 0x1640628 */
	0xba028601, 0x00000001, 	/* write 0x1 to address 0x174050c */
	0xba031401, 0x0000000f, 	/* write 0xf to address 0x1740628 */
	0xc2028601, 0x00000001, 	/* write 0x1 to address 0x184050c */
	0xc2031401, 0x0000000f, 	/* write 0xf to address 0x1840628 */
	0xca028601, 0x00000001, 	/* write 0x1 to address 0x194050c */
	0xca031401, 0x0000000f, 	/* write 0xf to address 0x1940628 */
	0x00060002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 6 ops */
	0xa2028021, 0x00000000, 	/* write array of size 3 from offset 0 to address 0x1440500 */
	0xaa028021, 0x00000000, 	/* write array of size 3 from offset 0 to address 0x1540500 */
	0xb2028021, 0x00000000, 	/* write array of size 3 from offset 0 to address 0x1640500 */
	0xba028021, 0x00000000, 	/* write array of size 3 from offset 0 to address 0x1740500 */
	0xc2028021, 0x00000000, 	/* write array of size 3 from offset 0 to address 0x1840500 */
	0xca028021, 0x00000000, 	/* write array of size 3 from offset 0 to address 0x1940500 */
	0x00060002, 0x00310000, 	/* if mode != '(bb|k2)&(asic|chipsim)', skip 6 ops */
	0xa2028021, 0x00000004, 	/* write array of size 3 from offset 4 to address 0x1440500 */
	0xaa028021, 0x00000004, 	/* write array of size 3 from offset 4 to address 0x1540500 */
	0xb2028021, 0x00000004, 	/* write array of size 3 from offset 4 to address 0x1640500 */
	0xba028021, 0x00000004, 	/* write array of size 3 from offset 4 to address 0x1740500 */
	0xc2028021, 0x00000004, 	/* write array of size 3 from offset 4 to address 0x1840500 */
	0xca028021, 0x00000004, 	/* write array of size 3 from offset 4 to address 0x1940500 */
	0x00060002, 0x00000000, 	/* if mode != '(bb|k2)&((emul_reduced|emul_full)&bb)', skip 6 ops */
	0xa2028021, 0x00000008, 	/* write array of size 3 from offset 8 to address 0x1440500 */
	0xaa028021, 0x00000008, 	/* write array of size 3 from offset 8 to address 0x1540500 */
	0xb2028021, 0x00000008, 	/* write array of size 3 from offset 8 to address 0x1640500 */
	0xba028021, 0x00000008, 	/* write array of size 3 from offset 8 to address 0x1740500 */
	0xc2028021, 0x00000008, 	/* write array of size 3 from offset 8 to address 0x1840500 */
	0xca028021, 0x00000008, 	/* write array of size 3 from offset 8 to address 0x1940500 */
	0x00060002, 0x00090000, 	/* if mode != '(bb|k2)&((emul_reduced|emul_full)&k2)', skip 6 ops */
	0xa2028021, 0x0000000c, 	/* write array of size 3 from offset 12 to address 0x1440500 */
	0xaa028021, 0x0000000c, 	/* write array of size 3 from offset 12 to address 0x1540500 */
	0xb2028021, 0x0000000c, 	/* write array of size 3 from offset 12 to address 0x1640500 */
	0xba028021, 0x0000000c, 	/* write array of size 3 from offset 12 to address 0x1740500 */
	0xc2028021, 0x0000000c, 	/* write array of size 3 from offset 12 to address 0x1840500 */
	0xca028021, 0x0000000c, 	/* write array of size 3 from offset 12 to address 0x1940500 */
	0x00403a01, 0xffffffff, 	/* write 0xffffffff to address 0x8074 */
	/* PGLUE_B */
	0x00140003, 0xffff0000, 	/* if phase != 'engine', skip 20 ops (no DMAE) */
	0x00020002, 0x00450000, 	/* if mode != '!asic', skip 2 ops */
	0x1540c201, 0x00080000, 	/* write 0x80000 to address 0x2a8184 */
	0x1540ca01, 0x00000000, 	/* write 0x0 to address 0x2a8194 */
	0x00010002, 0x00ac0000, 	/* if mode != '(!asic)&bb', skip 1 ops */
	0x15410201, 0x00000000, 	/* write 0x0 to address 0x2a8204 */
	0x00010002, 0x00b40000, 	/* if mode != '(!asic)&k2', skip 1 ops */
	0x15410201, 0x00000000, 	/* write 0x0 to address 0x2a8204 */
	0x15571a31, 0x70210001, 	/* write runtime array of size 1 from offset 28705 to address 0x2aae34 */
	0x00080002, 0x00010000, 	/* if mode != 'bb|k2', skip 8 ops */
	0x1550d421, 0x00000010, 	/* write array of size 4 from offset 16 to address 0x2aa1a8 */
	0x1550de21, 0x00000015, 	/* write array of size 4 from offset 21 to address 0x2aa1bc */
	0x1550e821, 0x0000001a, 	/* write array of size 4 from offset 26 to address 0x2aa1d0 */
	0x1550f221, 0x0000001f, 	/* write array of size 3 from offset 31 to address 0x2aa1e4 */
	0x1550fc21, 0x00000023, 	/* write array of size 3 from offset 35 to address 0x2aa1f8 */
	0x15510621, 0x00000027, 	/* write array of size 4 from offset 39 to address 0x2aa20c */
	0x15512001, 0x000001c7, 	/* write 0x1c7 to address 0x2aa240 */
	0x1552b221, 0x0000002c, 	/* write array of size 6 from offset 44 to address 0x2aa564 */
	0x15400001, 0x00000001, 	/* write 0x1 to address 0x2a8000 */
	0x15400801, 0x00000001, 	/* write 0x1 to address 0x2a8010 */
	0x1550e031, 0x701f0002, 	/* write runtime array of size 2 from offset 28703 to address 0x2aa1c0 */
	0x00020003, 0x00000000, 	/* if phase != 'engine0', skip 2 ops (no DMAE) */
	0x15400230, 0x00000001, 	/* wait until address 0x2a8004 reads 0x1 */
	0x15400a30, 0x00000001, 	/* wait until address 0x2a8014 reads 0x1 */
	0x00020003, 0x00010000, 	/* if phase != 'engine1', skip 2 ops (no DMAE) */
	0x15400230, 0x00000002, 	/* wait until address 0x2a8004 reads 0x2 */
	0x15400a30, 0x00000002, 	/* wait until address 0x2a8014 reads 0x2 */
	0x00040013, 0xffff0002, 	/* if phase != 'pf', skip 4 ops  */
	0x15427231, 0x701e0001, 	/* write runtime array of size 1 from offset 28702 to address 0x2a84e4 */
	0x1550b621, 0x00000033, 	/* write array of size 3 from offset 51 to address 0x2aa16c */
	0x1552ca01, 0x00000000, 	/* write 0x0 to address 0x2aa594 */
	0x15573031, 0x70220003, 	/* write runtime array of size 3 from offset 28706 to address 0x2aae60 */
	0x00020013, 0xffff0003, 	/* if phase != 'vf', skip 2 ops  */
	0x1550b401, 0x00000001, 	/* write 0x1 to address 0x2aa168 */
	0x1552cc01, 0x00000000, 	/* write 0x0 to address 0x2aa598 */
	/* CNIG */
	0x00060003, 0xffff0000, 	/* if phase != 'engine', skip 6 ops (no DMAE) */
	0x00020002, 0x00ac0000, 	/* if mode != '(!asic)&bb', skip 2 ops */
	0x10c17601, 0x00000000, 	/* write 0x0 to address 0x2182ec */
	0x10c1a601, 0x00000000, 	/* write 0x0 to address 0x21834c */
	0x00020002, 0x00900000, 	/* if mode != '(!asic)&(!bb)', skip 2 ops */
	0x10c10e01, 0x00000000, 	/* write 0x0 to address 0x21821c */
	0x10c11801, 0x00000000, 	/* write 0x0 to address 0x218230 */
	/* CPMU */
	0x00020003, 0xffff0000, 	/* if phase != 'engine', skip 2 ops (no DMAE) */
	0x00010002, 0x00450000, 	/* if mode != '!asic', skip 1 ops */
	0x0181f201, 0x00000000, 	/* write 0x0 to address 0x303e4 */
	/* PCIE */
	0x00040003, 0xffff0000, 	/* if phase != 'engine', skip 4 ops (no DMAE) */
	0x00010002, 0x00ac0000, 	/* if mode != '(!asic)&bb', skip 1 ops */
	0x02a00201, 0x00003f02, 	/* write 0x3f02 to address 0x54004 */
	0x00010002, 0x00900000, 	/* if mode != '(!asic)&(!bb)', skip 1 ops */
	0x02a00201, 0x00000000, 	/* write 0x0 to address 0x54004 */
	/* PSWHST */
	0x000a0003, 0xffff0000, 	/* if phase != 'engine', skip 10 ops (no DMAE) */
	0x1500c201, 0x00000200, 	/* write 0x200 to address 0x2a0184 */
	0x1500ca01, 0x00000000, 	/* write 0x0 to address 0x2a0194 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x15010201, 0x00000000, 	/* write 0x0 to address 0x2a0204 */
	0x15020011, 0x00000048, 	/* write 72 zeros to address 0x2a0400 */
	0x15000001, 0x00000001, 	/* write 0x1 to address 0x2a0000 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x15021401, 0x04000040, 	/* write 0x4000040 to address 0x2a0428 */
	0x15024001, 0x05050042, 	/* write 0x5050042 to address 0x2a0480 */
	0x15000210, 0x00000001, 	/* wait until address 0x2a0004 reads 0x1 */
	/* PSWHST2 */
	0x00020003, 0xffff0000, 	/* if phase != 'engine', skip 2 ops (no DMAE) */
	0x14f0c201, 0x00000000, 	/* write 0x0 to address 0x29e184 */
	0x14f0ca01, 0x00000000, 	/* write 0x0 to address 0x29e194 */
	/* PSWRD */
	0x00020003, 0xffff0000, 	/* if phase != 'engine', skip 2 ops (no DMAE) */
	0x14e0c201, 0x00000000, 	/* write 0x0 to address 0x29c184 */
	0x14e0ca01, 0x00000000, 	/* write 0x0 to address 0x29c194 */
	/* PSWRD2 */
	0x00070003, 0xffff0000, 	/* if phase != 'engine', skip 7 ops (no DMAE) */
	0x14e8c201, 0x00000000, 	/* write 0x0 to address 0x29d184 */
	0x14e8ca01, 0x00000000, 	/* write 0x0 to address 0x29d194 */
	0x14e90201, 0x00000000, 	/* write 0x0 to address 0x29d204 */
	0x14e90a01, 0x00000000, 	/* write 0x0 to address 0x29d214 */
	0x14e86601, 0x00000003, 	/* write 0x3 to address 0x29d0cc */
	0x14e80001, 0x00000001, 	/* write 0x1 to address 0x29d000 */
	0x14e80210, 0x00000001, 	/* wait until address 0x29d004 reads 0x1 */
	/* PSWWR */
	0x00020003, 0xffff0000, 	/* if phase != 'engine', skip 2 ops (no DMAE) */
	0x14d0c201, 0x00000000, 	/* write 0x0 to address 0x29a184 */
	0x14d0ca01, 0x00000000, 	/* write 0x0 to address 0x29a194 */
	/* PSWWR2 */
	0x00070003, 0xffff0000, 	/* if phase != 'engine', skip 7 ops (no DMAE) */
	0x14d8c201, 0x00000000, 	/* write 0x0 to address 0x29b184 */
	0x14d8ca01, 0x00000000, 	/* write 0x0 to address 0x29b194 */
	0x00040002, 0x00240000, 	/* if mode != '!e5', skip 4 ops */
	0x14d90201, 0x00000000, 	/* write 0x0 to address 0x29b204 */
	0x14d90a01, 0x00000000, 	/* write 0x0 to address 0x29b214 */
	0x14d91201, 0x00000000, 	/* write 0x0 to address 0x29b224 */
	0x14d91a01, 0x00000000, 	/* write 0x0 to address 0x29b234 */
	/* PSWRQ */
	0x00020003, 0xffff0000, 	/* if phase != 'engine', skip 2 ops (no DMAE) */
	0x1400c201, 0x00000000, 	/* write 0x0 to address 0x280184 */
	0x1400ca01, 0x00000000, 	/* write 0x0 to address 0x280194 */
	/* PSWRQ2 */
	0x00070003, 0xffff0000, 	/* if phase != 'engine', skip 7 ops (no DMAE) */
	0x1200c201, 0x00000000, 	/* write 0x0 to address 0x240184 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x12010201, 0x00000000, 	/* write 0x0 to address 0x240204 */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x12010201, 0x00000000, 	/* write 0x0 to address 0x240204 */
	0x12020831, 0x1a2c0002, 	/* write runtime array of size 2 from offset 6700 to address 0x240410 */
	0x1202be01, 0x00000003, 	/* write 0x3 to address 0x24057c */
	0x00060013, 0xffff0002, 	/* if phase != 'pf', skip 6 ops  */
	0x12000631, 0x1a0f0005, 	/* write runtime array of size 5 from offset 6671 to address 0x24000c */
	0x12001431, 0x1a140001, 	/* write runtime array of size 1 from offset 6676 to address 0x240028 */
	0x12001831, 0x1a15000a, 	/* write runtime array of size 10 from offset 6677 to address 0x240030 */
	0x12003031, 0x1a1f0002, 	/* write runtime array of size 2 from offset 6687 to address 0x240060 */
	0x12004831, 0x1a21000b, 	/* write runtime array of size 11 from offset 6689 to address 0x240090 */
	0x13000131, 0x1a2e55f0, 	/* write runtime array of size 22000 from offset 6702 to address 0x260000 (WB) */
	/* PGLCS */
	0x00020003, 0xffff0000, 	/* if phase != 'engine', skip 2 ops (no DMAE) */
	0x00010002, 0x00450000, 	/* if mode != '!asic', skip 1 ops */
	0x000e8201, 0x00000000, 	/* write 0x0 to address 0x1d04 */
	/* DMAE */
	0x00040003, 0xffff0000, 	/* if phase != 'engine', skip 4 ops (no DMAE) */
	0x0060c201, 0x00000000, 	/* write 0x0 to address 0xc184 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x00610201, 0x00000000, 	/* write 0x0 to address 0xc204 */
	0x00640011, 0x000001c0, 	/* write 448 zeros to address 0xc800 */
	/* PTU */
	0x00090013, 0xffff0000, 	/* if phase != 'engine', skip 9 ops  */
	0x2b002e01, 0x00000000, 	/* write 0x0 to address 0x56005c */
	0x2b00c201, 0x00000000, 	/* write 0x0 to address 0x560184 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x2b010201, 0x00000000, 	/* write 0x0 to address 0x560204 */
	0x2b000001, 0x00000001, 	/* write 0x1 to address 0x560000 */
	0x2b000210, 0x00000001, 	/* wait until address 0x560004 reads 0x1 */
	0x2b004601, 0x00000001, 	/* write 0x1 to address 0x56008c */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x2b004821, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x560090 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0x2b003e01, 0x00f00000, 	/* write 0xf00000 to address 0x56007c */
	0x00010013, 0x00000002, 	/* if phase != 'pf0', skip 1 ops  */
	0x2b003c01, 0x00000000, 	/* write 0x0 to address 0x560078 */
	0x00010013, 0x00010002, 	/* if phase != 'pf1', skip 1 ops  */
	0x2b003c01, 0x00100000, 	/* write 0x100000 to address 0x560078 */
	0x00010013, 0x00020002, 	/* if phase != 'pf2', skip 1 ops  */
	0x2b003c01, 0x00200000, 	/* write 0x200000 to address 0x560078 */
	0x00010013, 0x00030002, 	/* if phase != 'pf3', skip 1 ops  */
	0x2b003c01, 0x00300000, 	/* write 0x300000 to address 0x560078 */
	0x00010013, 0x00040002, 	/* if phase != 'pf4', skip 1 ops  */
	0x2b003c01, 0x00400000, 	/* write 0x400000 to address 0x560078 */
	0x00010013, 0x00050002, 	/* if phase != 'pf5', skip 1 ops  */
	0x2b003c01, 0x00500000, 	/* write 0x500000 to address 0x560078 */
	0x00010013, 0x00060002, 	/* if phase != 'pf6', skip 1 ops  */
	0x2b003c01, 0x00600000, 	/* write 0x600000 to address 0x560078 */
	0x00010013, 0x00070002, 	/* if phase != 'pf7', skip 1 ops  */
	0x2b003c01, 0x00700000, 	/* write 0x700000 to address 0x560078 */
	0x00020013, 0x00080002, 	/* if phase != 'pf8', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00800000, 	/* write 0x800000 to address 0x560078 */
	0x00020013, 0x00090002, 	/* if phase != 'pf9', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00900000, 	/* write 0x900000 to address 0x560078 */
	0x00020013, 0x000a0002, 	/* if phase != 'pf10', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00a00000, 	/* write 0xa00000 to address 0x560078 */
	0x00020013, 0x000b0002, 	/* if phase != 'pf11', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00b00000, 	/* write 0xb00000 to address 0x560078 */
	0x00020013, 0x000c0002, 	/* if phase != 'pf12', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00c00000, 	/* write 0xc00000 to address 0x560078 */
	0x00020013, 0x000d0002, 	/* if phase != 'pf13', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00d00000, 	/* write 0xd00000 to address 0x560078 */
	0x00020013, 0x000e0002, 	/* if phase != 'pf14', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00e00000, 	/* write 0xe00000 to address 0x560078 */
	0x00020013, 0x000f0002, 	/* if phase != 'pf15', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x2b003c01, 0x00f00000, 	/* write 0xf00000 to address 0x560078 */
	0x00030013, 0xffff0002, 	/* if phase != 'pf', skip 3 ops  */
	0x2b004001, 0x00000001, 	/* write 0x1 to address 0x560080 */
	0x2b004210, 0x00000001, 	/* wait until address 0x560084 reads 0x1 */
	0x2b004401, 0x00000001, 	/* write 0x1 to address 0x560088 */
	/* TCM */
	0x004b0013, 0xffff0000, 	/* if phase != 'engine', skip 75 ops  */
	0x8c00ca01, 0x00000000, 	/* write 0x0 to address 0x1180194 */
	0x8c00d201, 0x00000000, 	/* write 0x0 to address 0x11801a4 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x8c010201, 0x00000000, 	/* write 0x0 to address 0x1180204 */
	0x8c010a01, 0x00000000, 	/* write 0x0 to address 0x1180214 */
	0x00020002, 0x00030000, 	/* if mode != 'k2', skip 2 ops */
	0x8c010201, 0x00000000, 	/* write 0x0 to address 0x1180204 */
	0x8c010a01, 0x00000000, 	/* write 0x0 to address 0x1180214 */
	0x00310002, 0x00010000, 	/* if mode != 'bb|k2', skip 49 ops */
	0x8c00c201, 0x00000000, 	/* write 0x0 to address 0x1180184 */
	0x8c0a6001, 0x00000000, 	/* write 0x0 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000200, 	/* write 0x200 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000400, 	/* write 0x400 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000600, 	/* write 0x600 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000800, 	/* write 0x800 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000a00, 	/* write 0xa00 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000c00, 	/* write 0xc00 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000e00, 	/* write 0xe00 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001000, 	/* write 0x1000 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001200, 	/* write 0x1200 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001400, 	/* write 0x1400 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001600, 	/* write 0x1600 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001800, 	/* write 0x1800 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001a00, 	/* write 0x1a00 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001c00, 	/* write 0x1c00 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00001e00, 	/* write 0x1e00 to address 0x11814c0 */
	0x8c0a6801, 0x00000000, 	/* write 0x0 to address 0x11814d0 */
	0x8c0a6001, 0x00000000, 	/* write 0x0 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000200, 	/* write 0x200 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000400, 	/* write 0x400 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000600, 	/* write 0x600 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000800, 	/* write 0x800 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000a00, 	/* write 0xa00 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000c00, 	/* write 0xc00 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0a6001, 0x00000e00, 	/* write 0xe00 to address 0x11814c0 */
	0x8c0a6401, 0x00000000, 	/* write 0x0 to address 0x11814c8 */
	0x8c0c0021, 0x00000037, 	/* write array of size 64 from offset 55 to address 0x1181800 */
	0x000f0002, 0x00010000, 	/* if mode != 'bb|k2', skip 15 ops */
	0x8c020221, 0x0000004f, 	/* write array of size 3 from offset 79 to address 0x1180404 */
	0x8c020c21, 0x00000053, 	/* write array of size 2 from offset 83 to address 0x1180418 */
	0x8c021401, 0x00000068, 	/* write 0x68 to address 0x1180428 */
	0x8c022421, 0x00000056, 	/* write array of size 2 from offset 86 to address 0x1180448 */
	0x8c022c21, 0x00000059, 	/* write array of size 3 from offset 89 to address 0x1180458 */
	0x8c024401, 0x00000002, 	/* write 0x2 to address 0x1180488 */
	0x8c027411, 0x00000002, 	/* write 2 zeros to address 0x11804e8 */
	0x8c028401, 0x00000000, 	/* write 0x0 to address 0x1180508 */
	0x8c02b201, 0x00000006, 	/* write 0x6 to address 0x1180564 */
	0x8c040a01, 0x0000000a, 	/* write 0xa to address 0x1180814 */
	0x8c040e21, 0x0000005d, 	/* write array of size 8 from offset 93 to address 0x118081c */
	0x8c041e11, 0x00000006, 	/* write 6 zeros to address 0x118083c */
	0x8c045221, 0x00000066, 	/* write array of size 5 from offset 102 to address 0x11808a4 */
	0x8c045e21, 0x0000006c, 	/* write array of size 2 from offset 108 to address 0x11808bc */
	0x8c046411, 0x00000006, 	/* write 6 zeros to address 0x11808c8 */
	0x00050013, 0xffff0002, 	/* if phase != 'pf', skip 5 ops  */
	0x00020002, 0x00450000, 	/* if mode != '!asic', skip 2 ops */
	0x8c03aa01, 0x00000040, 	/* write 0x40 to address 0x1180754 */
	0x8c03c801, 0x00000000, 	/* write 0x0 to address 0x1180790 */
	0x00010002, 0x00440000, 	/* if mode != '(!asic)&(bb|k2)', skip 1 ops */
	0x8c03ba01, 0x00000008, 	/* write 0x8 to address 0x1180774 */
	0x00030013, 0x00000002, 	/* if phase != 'pf0', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000000, 	/* write 0x0 to address 0x1180904 */
	0x8c048601, 0x00000000, 	/* write 0x0 to address 0x118090c */
	0x00030013, 0x00010002, 	/* if phase != 'pf1', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000008, 	/* write 0x8 to address 0x1180904 */
	0x8c048601, 0x00000008, 	/* write 0x8 to address 0x118090c */
	0x00030013, 0x00020002, 	/* if phase != 'pf2', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000010, 	/* write 0x10 to address 0x1180904 */
	0x8c048601, 0x00000010, 	/* write 0x10 to address 0x118090c */
	0x00030013, 0x00030002, 	/* if phase != 'pf3', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000018, 	/* write 0x18 to address 0x1180904 */
	0x8c048601, 0x00000018, 	/* write 0x18 to address 0x118090c */
	0x00030013, 0x00040002, 	/* if phase != 'pf4', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000020, 	/* write 0x20 to address 0x1180904 */
	0x8c048601, 0x00000020, 	/* write 0x20 to address 0x118090c */
	0x00030013, 0x00050002, 	/* if phase != 'pf5', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000028, 	/* write 0x28 to address 0x1180904 */
	0x8c048601, 0x00000028, 	/* write 0x28 to address 0x118090c */
	0x00030013, 0x00060002, 	/* if phase != 'pf6', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000030, 	/* write 0x30 to address 0x1180904 */
	0x8c048601, 0x00000030, 	/* write 0x30 to address 0x118090c */
	0x00030013, 0x00070002, 	/* if phase != 'pf7', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x8c048201, 0x00000038, 	/* write 0x38 to address 0x1180904 */
	0x8c048601, 0x00000038, 	/* write 0x38 to address 0x118090c */
	0x00030013, 0x00080002, 	/* if phase != 'pf8', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000040, 	/* write 0x40 to address 0x1180904 */
	0x8c048601, 0x00000040, 	/* write 0x40 to address 0x118090c */
	0x00030013, 0x00090002, 	/* if phase != 'pf9', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000048, 	/* write 0x48 to address 0x1180904 */
	0x8c048601, 0x00000048, 	/* write 0x48 to address 0x118090c */
	0x00030013, 0x000a0002, 	/* if phase != 'pf10', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000050, 	/* write 0x50 to address 0x1180904 */
	0x8c048601, 0x00000050, 	/* write 0x50 to address 0x118090c */
	0x00030013, 0x000b0002, 	/* if phase != 'pf11', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000058, 	/* write 0x58 to address 0x1180904 */
	0x8c048601, 0x00000058, 	/* write 0x58 to address 0x118090c */
	0x00030013, 0x000c0002, 	/* if phase != 'pf12', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000060, 	/* write 0x60 to address 0x1180904 */
	0x8c048601, 0x00000060, 	/* write 0x60 to address 0x118090c */
	0x00030013, 0x000d0002, 	/* if phase != 'pf13', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000068, 	/* write 0x68 to address 0x1180904 */
	0x8c048601, 0x00000068, 	/* write 0x68 to address 0x118090c */
	0x00030013, 0x000e0002, 	/* if phase != 'pf14', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000070, 	/* write 0x70 to address 0x1180904 */
	0x8c048601, 0x00000070, 	/* write 0x70 to address 0x118090c */
	0x00030013, 0x000f0002, 	/* if phase != 'pf15', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x8c048201, 0x00000078, 	/* write 0x78 to address 0x1180904 */
	0x8c048601, 0x00000078, 	/* write 0x78 to address 0x118090c */
	/* MCM */
	0x00620013, 0xffff0000, 	/* if phase != 'engine', skip 98 ops  */
	0x9000ca01, 0x00000000, 	/* write 0x0 to address 0x1200194 */
	0x9000d201, 0x00000000, 	/* write 0x0 to address 0x12001a4 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x9000c201, 0x00000000, 	/* write 0x0 to address 0x1200184 */
	0x900c0001, 0x00000000, 	/* write 0x0 to address 0x1201800 */
	0x00020002, 0x00240000, 	/* if mode != '!e5', skip 2 ops */
	0x90010201, 0x00000000, 	/* write 0x0 to address 0x1200204 */
	0x90010a01, 0x00000000, 	/* write 0x0 to address 0x1200214 */
	0x00470002, 0x00010000, 	/* if mode != 'bb|k2', skip 71 ops */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000200, 	/* write 0x200 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000400, 	/* write 0x400 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000600, 	/* write 0x600 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000800, 	/* write 0x800 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000a00, 	/* write 0xa00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000c00, 	/* write 0xc00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000e00, 	/* write 0xe00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001000, 	/* write 0x1000 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001200, 	/* write 0x1200 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001400, 	/* write 0x1400 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001600, 	/* write 0x1600 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001800, 	/* write 0x1800 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001a00, 	/* write 0x1a00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001c00, 	/* write 0x1c00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00001e00, 	/* write 0x1e00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002000, 	/* write 0x2000 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002200, 	/* write 0x2200 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002400, 	/* write 0x2400 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002600, 	/* write 0x2600 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002800, 	/* write 0x2800 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002a00, 	/* write 0x2a00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002c00, 	/* write 0x2c00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00002e00, 	/* write 0x2e00 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00003000, 	/* write 0x3000 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00003200, 	/* write 0x3200 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00003400, 	/* write 0x3400 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00003600, 	/* write 0x3600 to address 0x1201800 */
	0x900c0801, 0x00000000, 	/* write 0x0 to address 0x1201810 */
	0x900c0001, 0x00000000, 	/* write 0x0 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000200, 	/* write 0x200 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000400, 	/* write 0x400 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000600, 	/* write 0x600 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000800, 	/* write 0x800 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000a00, 	/* write 0xa00 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000c00, 	/* write 0xc00 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900c0001, 0x00000e00, 	/* write 0xe00 to address 0x1201800 */
	0x900c0401, 0x00000000, 	/* write 0x0 to address 0x1201808 */
	0x900e0021, 0x00000037, 	/* write array of size 64 from offset 55 to address 0x1201c00 */
	0x00100002, 0x00010000, 	/* if mode != 'bb|k2', skip 16 ops */
	0x90020401, 0x0000006c, 	/* write 0x6c to address 0x1200408 */
	0x90021221, 0x0000006f, 	/* write array of size 2 from offset 111 to address 0x1200424 */
	0x90022401, 0x00000001, 	/* write 0x1 to address 0x1200448 */
	0x90024221, 0x00000072, 	/* write array of size 3 from offset 114 to address 0x1200484 */
	0x90025001, 0x00000002, 	/* write 0x2 to address 0x12004a0 */
	0x90026211, 0x00000002, 	/* write 2 zeros to address 0x12004c4 */
	0x90027211, 0x00000002, 	/* write 2 zeros to address 0x12004e4 */
	0x90029401, 0x00000000, 	/* write 0x0 to address 0x1200528 */
	0x9002a211, 0x00000002, 	/* write 2 zeros to address 0x1200544 */
	0x9002b201, 0x00000006, 	/* write 0x6 to address 0x1200564 */
	0x90040a21, 0x00000076, 	/* write array of size 4 from offset 118 to address 0x1200814 */
	0x90041421, 0x0000007b, 	/* write array of size 5 from offset 123 to address 0x1200828 */
	0x90042021, 0x00000081, 	/* write array of size 5 from offset 129 to address 0x1200840 */
	0x90045411, 0x00000006, 	/* write 6 zeros to address 0x12008a8 */
	0x90046001, 0x00000001, 	/* write 0x1 to address 0x12008c0 */
	0x90046611, 0x00000004, 	/* write 4 zeros to address 0x12008cc */
	0x00050013, 0xffff0002, 	/* if phase != 'pf', skip 5 ops  */
	0x00020002, 0x00450000, 	/* if mode != '!asic', skip 2 ops */
	0x9003aa01, 0x00000040, 	/* write 0x40 to address 0x1200754 */
	0x9003c801, 0x00000000, 	/* write 0x0 to address 0x1200790 */
	0x00010002, 0x00440000, 	/* if mode != '(!asic)&(bb|k2)', skip 1 ops */
	0x9003ba01, 0x00000008, 	/* write 0x8 to address 0x1200774 */
	0x00030013, 0x00000002, 	/* if phase != 'pf0', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000001, 	/* write 0x1 to address 0x1200904 */
	0x90048601, 0x00000001, 	/* write 0x1 to address 0x120090c */
	0x00030013, 0x00010002, 	/* if phase != 'pf1', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000009, 	/* write 0x9 to address 0x1200904 */
	0x90048601, 0x00000009, 	/* write 0x9 to address 0x120090c */
	0x00030013, 0x00020002, 	/* if phase != 'pf2', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000011, 	/* write 0x11 to address 0x1200904 */
	0x90048601, 0x00000011, 	/* write 0x11 to address 0x120090c */
	0x00030013, 0x00030002, 	/* if phase != 'pf3', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000019, 	/* write 0x19 to address 0x1200904 */
	0x90048601, 0x00000019, 	/* write 0x19 to address 0x120090c */
	0x00030013, 0x00040002, 	/* if phase != 'pf4', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000021, 	/* write 0x21 to address 0x1200904 */
	0x90048601, 0x00000021, 	/* write 0x21 to address 0x120090c */
	0x00030013, 0x00050002, 	/* if phase != 'pf5', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000029, 	/* write 0x29 to address 0x1200904 */
	0x90048601, 0x00000029, 	/* write 0x29 to address 0x120090c */
	0x00030013, 0x00060002, 	/* if phase != 'pf6', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000031, 	/* write 0x31 to address 0x1200904 */
	0x90048601, 0x00000031, 	/* write 0x31 to address 0x120090c */
	0x00030013, 0x00070002, 	/* if phase != 'pf7', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x90048201, 0x00000039, 	/* write 0x39 to address 0x1200904 */
	0x90048601, 0x00000039, 	/* write 0x39 to address 0x120090c */
	0x00030013, 0x00080002, 	/* if phase != 'pf8', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000041, 	/* write 0x41 to address 0x1200904 */
	0x90048601, 0x00000041, 	/* write 0x41 to address 0x120090c */
	0x00030013, 0x00090002, 	/* if phase != 'pf9', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000049, 	/* write 0x49 to address 0x1200904 */
	0x90048601, 0x00000049, 	/* write 0x49 to address 0x120090c */
	0x00030013, 0x000a0002, 	/* if phase != 'pf10', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000051, 	/* write 0x51 to address 0x1200904 */
	0x90048601, 0x00000051, 	/* write 0x51 to address 0x120090c */
	0x00030013, 0x000b0002, 	/* if phase != 'pf11', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000059, 	/* write 0x59 to address 0x1200904 */
	0x90048601, 0x00000059, 	/* write 0x59 to address 0x120090c */
	0x00030013, 0x000c0002, 	/* if phase != 'pf12', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000061, 	/* write 0x61 to address 0x1200904 */
	0x90048601, 0x00000061, 	/* write 0x61 to address 0x120090c */
	0x00030013, 0x000d0002, 	/* if phase != 'pf13', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000069, 	/* write 0x69 to address 0x1200904 */
	0x90048601, 0x00000069, 	/* write 0x69 to address 0x120090c */
	0x00030013, 0x000e0002, 	/* if phase != 'pf14', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000071, 	/* write 0x71 to address 0x1200904 */
	0x90048601, 0x00000071, 	/* write 0x71 to address 0x120090c */
	0x00030013, 0x000f0002, 	/* if phase != 'pf15', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x90048201, 0x00000079, 	/* write 0x79 to address 0x1200904 */
	0x90048601, 0x00000079, 	/* write 0x79 to address 0x120090c */
	/* UCM */
	0x004b0013, 0xffff0000, 	/* if phase != 'engine', skip 75 ops  */
	0x9400c201, 0x00000000, 	/* write 0x0 to address 0x1280184 */
	0x9400d201, 0x00000000, 	/* write 0x0 to address 0x12801a4 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x9400ca01, 0x00000000, 	/* write 0x0 to address 0x1280194 */
	0x940b8001, 0x00000000, 	/* write 0x0 to address 0x1281700 */
	0x00020002, 0x00240000, 	/* if mode != '!e5', skip 2 ops */
	0x94010201, 0x00000000, 	/* write 0x0 to address 0x1280204 */
	0x94010a01, 0x00000000, 	/* write 0x0 to address 0x1280214 */
	0x002f0002, 0x00010000, 	/* if mode != 'bb|k2', skip 47 ops */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000200, 	/* write 0x200 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000400, 	/* write 0x400 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000600, 	/* write 0x600 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000800, 	/* write 0x800 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000a00, 	/* write 0xa00 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000c00, 	/* write 0xc00 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000e00, 	/* write 0xe00 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00001000, 	/* write 0x1000 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00001200, 	/* write 0x1200 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00001400, 	/* write 0x1400 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00001600, 	/* write 0x1600 to address 0x1281700 */
	0x940b8801, 0x00000000, 	/* write 0x0 to address 0x1281710 */
	0x940b8001, 0x00000000, 	/* write 0x0 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000200, 	/* write 0x200 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000400, 	/* write 0x400 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000600, 	/* write 0x600 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000800, 	/* write 0x800 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000a00, 	/* write 0xa00 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000c00, 	/* write 0xc00 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00000e00, 	/* write 0xe00 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00001000, 	/* write 0x1000 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00001200, 	/* write 0x1200 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00001400, 	/* write 0x1400 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940b8001, 0x00001600, 	/* write 0x1600 to address 0x1281700 */
	0x940b8401, 0x00000000, 	/* write 0x0 to address 0x1281708 */
	0x940d8021, 0x00000037, 	/* write array of size 64 from offset 55 to address 0x1281b00 */
	0x00110002, 0x00010000, 	/* if mode != 'bb|k2', skip 17 ops */
	0x94020201, 0x00000041, 	/* write 0x41 to address 0x1280404 */
	0x94020601, 0x00000082, 	/* write 0x82 to address 0x128040c */
	0x94020a21, 0x00000087, 	/* write array of size 5 from offset 135 to address 0x1280414 */
	0x94021601, 0x00000083, 	/* write 0x83 to address 0x128042c */
	0x94022421, 0x0000008d, 	/* write array of size 2 from offset 141 to address 0x1280448 */
	0x94022a21, 0x0000008f, 	/* write array of size 4 from offset 143 to address 0x1280454 */
	0x94024221, 0x00000091, 	/* write array of size 3 from offset 145 to address 0x1280484 */
	0x94026a01, 0x00000000, 	/* write 0x0 to address 0x12804d4 */
	0x94027201, 0x00000000, 	/* write 0x0 to address 0x12804e4 */
	0x94027601, 0x00000000, 	/* write 0x0 to address 0x12804ec */
	0x94027c01, 0x00000000, 	/* write 0x0 to address 0x12804f8 */
	0x94028201, 0x00000000, 	/* write 0x0 to address 0x1280504 */
	0x94028601, 0x00000000, 	/* write 0x0 to address 0x128050c */
	0x9402b201, 0x00000007, 	/* write 0x7 to address 0x1280564 */
	0x94040a21, 0x00000095, 	/* write array of size 16 from offset 149 to address 0x1280814 */
	0x94045601, 0x00000000, 	/* write 0x0 to address 0x12808ac */
	0x94046221, 0x000000a6, 	/* write array of size 7 from offset 166 to address 0x12808c4 */
	0x00030013, 0x00000002, 	/* if phase != 'pf0', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x00000002, 	/* write 0x2 to address 0x1280904 */
	0x94048601, 0x00000002, 	/* write 0x2 to address 0x128090c */
	0x00030013, 0x00010002, 	/* if phase != 'pf1', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x0000000a, 	/* write 0xa to address 0x1280904 */
	0x94048601, 0x0000000a, 	/* write 0xa to address 0x128090c */
	0x00030013, 0x00020002, 	/* if phase != 'pf2', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x00000012, 	/* write 0x12 to address 0x1280904 */
	0x94048601, 0x00000012, 	/* write 0x12 to address 0x128090c */
	0x00030013, 0x00030002, 	/* if phase != 'pf3', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x0000001a, 	/* write 0x1a to address 0x1280904 */
	0x94048601, 0x0000001a, 	/* write 0x1a to address 0x128090c */
	0x00030013, 0x00040002, 	/* if phase != 'pf4', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x00000022, 	/* write 0x22 to address 0x1280904 */
	0x94048601, 0x00000022, 	/* write 0x22 to address 0x128090c */
	0x00030013, 0x00050002, 	/* if phase != 'pf5', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x0000002a, 	/* write 0x2a to address 0x1280904 */
	0x94048601, 0x0000002a, 	/* write 0x2a to address 0x128090c */
	0x00030013, 0x00060002, 	/* if phase != 'pf6', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x00000032, 	/* write 0x32 to address 0x1280904 */
	0x94048601, 0x00000032, 	/* write 0x32 to address 0x128090c */
	0x00030013, 0x00070002, 	/* if phase != 'pf7', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x94048201, 0x0000003a, 	/* write 0x3a to address 0x1280904 */
	0x94048601, 0x0000003a, 	/* write 0x3a to address 0x128090c */
	0x00030013, 0x00080002, 	/* if phase != 'pf8', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x00000042, 	/* write 0x42 to address 0x1280904 */
	0x94048601, 0x00000042, 	/* write 0x42 to address 0x128090c */
	0x00030013, 0x00090002, 	/* if phase != 'pf9', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x0000004a, 	/* write 0x4a to address 0x1280904 */
	0x94048601, 0x0000004a, 	/* write 0x4a to address 0x128090c */
	0x00030013, 0x000a0002, 	/* if phase != 'pf10', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x00000052, 	/* write 0x52 to address 0x1280904 */
	0x94048601, 0x00000052, 	/* write 0x52 to address 0x128090c */
	0x00030013, 0x000b0002, 	/* if phase != 'pf11', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x0000005a, 	/* write 0x5a to address 0x1280904 */
	0x94048601, 0x0000005a, 	/* write 0x5a to address 0x128090c */
	0x00030013, 0x000c0002, 	/* if phase != 'pf12', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x00000062, 	/* write 0x62 to address 0x1280904 */
	0x94048601, 0x00000062, 	/* write 0x62 to address 0x128090c */
	0x00030013, 0x000d0002, 	/* if phase != 'pf13', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x0000006a, 	/* write 0x6a to address 0x1280904 */
	0x94048601, 0x0000006a, 	/* write 0x6a to address 0x128090c */
	0x00030013, 0x000e0002, 	/* if phase != 'pf14', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x00000072, 	/* write 0x72 to address 0x1280904 */
	0x94048601, 0x00000072, 	/* write 0x72 to address 0x128090c */
	0x00030013, 0x000f0002, 	/* if phase != 'pf15', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x94048201, 0x0000007a, 	/* write 0x7a to address 0x1280904 */
	0x94048601, 0x0000007a, 	/* write 0x7a to address 0x128090c */
	/* XCM */
	0x00120013, 0xffff0000, 	/* if phase != 'engine', skip 18 ops  */
	0x8000c201, 0x00000000, 	/* write 0x0 to address 0x1000184 */
	0x8000ca01, 0x00000000, 	/* write 0x0 to address 0x1000194 */
	0x8000d201, 0x00000000, 	/* write 0x0 to address 0x10001a4 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x80010201, 0x00000000, 	/* write 0x0 to address 0x1000204 */
	0x80010a01, 0x00000000, 	/* write 0x0 to address 0x1000214 */
	0x00020002, 0x00030000, 	/* if mode != 'k2', skip 2 ops */
	0x80010201, 0x00000000, 	/* write 0x0 to address 0x1000204 */
	0x80010a01, 0x00000000, 	/* write 0x0 to address 0x1000214 */
	0x80000201, 0x00000001, 	/* write 0x1 to address 0x1000004 */
	0x800d8021, 0x000000ae, 	/* write array of size 64 from offset 174 to address 0x1001b00 */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0x80020221, 0x000000cc, 	/* write array of size 16 from offset 204 to address 0x1000404 */
	0x80026201, 0x0000000a, 	/* write 0xa to address 0x10004c4 */
	0x80040621, 0x000000dd, 	/* write array of size 8 from offset 221 to address 0x100080c */
	0x80042a21, 0x000000e6, 	/* write array of size 3 from offset 230 to address 0x1000854 */
	0x80043421, 0x000000ea, 	/* write array of size 3 from offset 234 to address 0x1000868 */
	0x80000410, 0x00000001, 	/* wait until address 0x1000008 reads 0x1 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0x80048231, 0x86040001, 	/* write runtime array of size 1 from offset 34308 to address 0x1000904 */
	/* YCM */
	0x008d0013, 0xffff0000, 	/* if phase != 'engine', skip 141 ops  */
	0x8400c201, 0x00000000, 	/* write 0x0 to address 0x1080184 */
	0x8400ca01, 0x00000000, 	/* write 0x0 to address 0x1080194 */
	0x8400d201, 0x00000000, 	/* write 0x0 to address 0x10801a4 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x84010201, 0x00000000, 	/* write 0x0 to address 0x1080204 */
	0x84010a01, 0x00000000, 	/* write 0x0 to address 0x1080214 */
	0x00020002, 0x00030000, 	/* if mode != 'k2', skip 2 ops */
	0x84010201, 0x00000000, 	/* write 0x0 to address 0x1080204 */
	0x84010a01, 0x00000000, 	/* write 0x0 to address 0x1080214 */
	0x00700002, 0x00010000, 	/* if mode != 'bb|k2', skip 112 ops */
	0x840c0001, 0x00000000, 	/* write 0x0 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000200, 	/* write 0x200 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000400, 	/* write 0x400 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000600, 	/* write 0x600 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000800, 	/* write 0x800 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000a00, 	/* write 0xa00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000c00, 	/* write 0xc00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000e00, 	/* write 0xe00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001000, 	/* write 0x1000 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001200, 	/* write 0x1200 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001400, 	/* write 0x1400 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001600, 	/* write 0x1600 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001800, 	/* write 0x1800 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001a00, 	/* write 0x1a00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001c00, 	/* write 0x1c00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00001e00, 	/* write 0x1e00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002000, 	/* write 0x2000 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002200, 	/* write 0x2200 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002400, 	/* write 0x2400 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002600, 	/* write 0x2600 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002800, 	/* write 0x2800 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002a00, 	/* write 0x2a00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002c00, 	/* write 0x2c00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00002e00, 	/* write 0x2e00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003000, 	/* write 0x3000 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003200, 	/* write 0x3200 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003400, 	/* write 0x3400 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003600, 	/* write 0x3600 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003800, 	/* write 0x3800 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003a00, 	/* write 0x3a00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003c00, 	/* write 0x3c00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00003e00, 	/* write 0x3e00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004000, 	/* write 0x4000 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004200, 	/* write 0x4200 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004400, 	/* write 0x4400 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004600, 	/* write 0x4600 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004800, 	/* write 0x4800 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004a00, 	/* write 0x4a00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004c00, 	/* write 0x4c00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00004e00, 	/* write 0x4e00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005000, 	/* write 0x5000 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005200, 	/* write 0x5200 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005400, 	/* write 0x5400 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005600, 	/* write 0x5600 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005800, 	/* write 0x5800 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005a00, 	/* write 0x5a00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005c00, 	/* write 0x5c00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00005e00, 	/* write 0x5e00 to address 0x1081800 */
	0x840c0801, 0x00000000, 	/* write 0x0 to address 0x1081810 */
	0x840c0001, 0x00000000, 	/* write 0x0 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000200, 	/* write 0x200 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000400, 	/* write 0x400 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000600, 	/* write 0x600 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000800, 	/* write 0x800 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000a00, 	/* write 0xa00 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000c00, 	/* write 0xc00 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840c0001, 0x00000e00, 	/* write 0xe00 to address 0x1081800 */
	0x840c0401, 0x00000000, 	/* write 0x0 to address 0x1081808 */
	0x840e0021, 0x00000037, 	/* write array of size 64 from offset 55 to address 0x1081c00 */
	0x00110002, 0x00010000, 	/* if mode != 'bb|k2', skip 17 ops */
	0x84020a01, 0x00000011, 	/* write 0x11 to address 0x1080414 */
	0x84020e01, 0x00000021, 	/* write 0x21 to address 0x108041c */
	0x84022a01, 0x00000002, 	/* write 0x2 to address 0x1080454 */
	0x84022e01, 0x00000002, 	/* write 0x2 to address 0x108045c */
	0x84024221, 0x00000072, 	/* write array of size 3 from offset 114 to address 0x1080484 */
	0x84025001, 0x00000002, 	/* write 0x2 to address 0x10804a0 */
	0x84028a01, 0x00000000, 	/* write 0x0 to address 0x1080514 */
	0x84028e01, 0x00000006, 	/* write 0x6 to address 0x108051c */
	0x8402b201, 0x00000006, 	/* write 0x6 to address 0x1080564 */
	0x84040e21, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x108081c */
	0x84041401, 0x00000001, 	/* write 0x1 to address 0x1080828 */
	0x84041a21, 0x000000ee, 	/* write array of size 2 from offset 238 to address 0x1080834 */
	0x84042021, 0x00000081, 	/* write array of size 5 from offset 129 to address 0x1080840 */
	0x84045801, 0x00000002, 	/* write 0x2 to address 0x10808b0 */
	0x84045c01, 0x00000002, 	/* write 0x2 to address 0x10808b8 */
	0x84046001, 0x00000001, 	/* write 0x1 to address 0x10808c0 */
	0x84046611, 0x00000004, 	/* write 4 zeros to address 0x10808cc */
	0x00030013, 0x00000002, 	/* if phase != 'pf0', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x00000003, 	/* write 0x3 to address 0x1080904 */
	0x84048601, 0x00000003, 	/* write 0x3 to address 0x108090c */
	0x00030013, 0x00010002, 	/* if phase != 'pf1', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x0000000b, 	/* write 0xb to address 0x1080904 */
	0x84048601, 0x0000000b, 	/* write 0xb to address 0x108090c */
	0x00030013, 0x00020002, 	/* if phase != 'pf2', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x00000013, 	/* write 0x13 to address 0x1080904 */
	0x84048601, 0x00000013, 	/* write 0x13 to address 0x108090c */
	0x00030013, 0x00030002, 	/* if phase != 'pf3', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x0000001b, 	/* write 0x1b to address 0x1080904 */
	0x84048601, 0x0000001b, 	/* write 0x1b to address 0x108090c */
	0x00030013, 0x00040002, 	/* if phase != 'pf4', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x00000023, 	/* write 0x23 to address 0x1080904 */
	0x84048601, 0x00000023, 	/* write 0x23 to address 0x108090c */
	0x00030013, 0x00050002, 	/* if phase != 'pf5', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x0000002b, 	/* write 0x2b to address 0x1080904 */
	0x84048601, 0x0000002b, 	/* write 0x2b to address 0x108090c */
	0x00030013, 0x00060002, 	/* if phase != 'pf6', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x00000033, 	/* write 0x33 to address 0x1080904 */
	0x84048601, 0x00000033, 	/* write 0x33 to address 0x108090c */
	0x00030013, 0x00070002, 	/* if phase != 'pf7', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x84048201, 0x0000003b, 	/* write 0x3b to address 0x1080904 */
	0x84048601, 0x0000003b, 	/* write 0x3b to address 0x108090c */
	0x00030013, 0x00080002, 	/* if phase != 'pf8', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x00000043, 	/* write 0x43 to address 0x1080904 */
	0x84048601, 0x00000043, 	/* write 0x43 to address 0x108090c */
	0x00030013, 0x00090002, 	/* if phase != 'pf9', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x0000004b, 	/* write 0x4b to address 0x1080904 */
	0x84048601, 0x0000004b, 	/* write 0x4b to address 0x108090c */
	0x00030013, 0x000a0002, 	/* if phase != 'pf10', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x00000053, 	/* write 0x53 to address 0x1080904 */
	0x84048601, 0x00000053, 	/* write 0x53 to address 0x108090c */
	0x00030013, 0x000b0002, 	/* if phase != 'pf11', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x0000005b, 	/* write 0x5b to address 0x1080904 */
	0x84048601, 0x0000005b, 	/* write 0x5b to address 0x108090c */
	0x00030013, 0x000c0002, 	/* if phase != 'pf12', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x00000063, 	/* write 0x63 to address 0x1080904 */
	0x84048601, 0x00000063, 	/* write 0x63 to address 0x108090c */
	0x00030013, 0x000d0002, 	/* if phase != 'pf13', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x0000006b, 	/* write 0x6b to address 0x1080904 */
	0x84048601, 0x0000006b, 	/* write 0x6b to address 0x108090c */
	0x00030013, 0x000e0002, 	/* if phase != 'pf14', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x00000073, 	/* write 0x73 to address 0x1080904 */
	0x84048601, 0x00000073, 	/* write 0x73 to address 0x108090c */
	0x00030013, 0x000f0002, 	/* if phase != 'pf15', skip 3 ops  */
	0x00020002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 2 ops */
	0x84048201, 0x0000007b, 	/* write 0x7b to address 0x1080904 */
	0x84048601, 0x0000007b, 	/* write 0x7b to address 0x108090c */
	/* PCM */
	0x000d0013, 0xffff0000, 	/* if phase != 'engine', skip 13 ops  */
	0x8800c201, 0x00000000, 	/* write 0x0 to address 0x1100184 */
	0x8800d201, 0x00000000, 	/* write 0x0 to address 0x11001a4 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x88010201, 0x00000000, 	/* write 0x0 to address 0x1100204 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x88010201, 0x00000000, 	/* write 0x0 to address 0x1100204 */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0x8800ca01, 0x00000000, 	/* write 0x0 to address 0x1100194 */
	0x880b8021, 0x000000f1, 	/* write array of size 4 from offset 241 to address 0x1101700 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0x88020201, 0x00000006, 	/* write 0x6 to address 0x1100404 */
	0x88040421, 0x000000f6, 	/* write array of size 4 from offset 246 to address 0x1100808 */
	0x88040e21, 0x000000fb, 	/* write array of size 3 from offset 251 to address 0x110081c */
	/* QM */
	0x00590013, 0xffff0000, 	/* if phase != 'engine', skip 89 ops  */
	0x1780c201, 0x00000000, 	/* write 0x0 to address 0x2f0184 */
	0x1780ca01, 0x00000000, 	/* write 0x0 to address 0x2f0194 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x17811201, 0x00000000, 	/* write 0x0 to address 0x2f0224 */
	0x17ae9c01, 0x00000001, 	/* write 0x1 to address 0x2f5d38 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x17811201, 0x00000000, 	/* write 0x0 to address 0x2f0224 */
	0x00020002, 0x00240000, 	/* if mode != '!e5', skip 2 ops */
	0x17810201, 0x00000000, 	/* write 0x0 to address 0x2f0204 */
	0x17810a01, 0x00000000, 	/* write 0x0 to address 0x2f0214 */
	0x17aebe01, 0x00000001, 	/* write 0x1 to address 0x2f5d7c */
	0x17aec010, 0x00000001, 	/* wait until address 0x2f5d80 reads 0x1 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x17c80011, 0x000001c0, 	/* write 448 zeros to address 0x2f9000 */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x17c80011, 0x00000200, 	/* write 512 zeros to address 0x2f9000 */
	0x17a60031, 0x78640001, 	/* write runtime array of size 1 from offset 30820 to address 0x2f4c00 */
	0x17a70031, 0x78970001, 	/* write runtime array of size 1 from offset 30871 to address 0x2f4e00 */
	0x17ae0031, 0x79b90001, 	/* write runtime array of size 1 from offset 31161 to address 0x2f5c00 */
	0x17ae0a31, 0x79ba0001, 	/* write runtime array of size 1 from offset 31162 to address 0x2f5c14 */
	0x178c8c31, 0x74ed0004, 	/* write runtime array of size 4 from offset 29933 to address 0x2f1918 */
	0x178ca231, 0x74f10001, 	/* write runtime array of size 1 from offset 29937 to address 0x2f1944 */
	0x178cb431, 0x74f20008, 	/* write runtime array of size 8 from offset 29938 to address 0x2f1968 */
	0x178cf431, 0x75020004, 	/* write runtime array of size 4 from offset 29954 to address 0x2f19e8 */
	0x178d0431, 0x75060002, 	/* write runtime array of size 2 from offset 29958 to address 0x2f1a08 */
	0x17976c31, 0x755c0008, 	/* write runtime array of size 8 from offset 30044 to address 0x2f2ed8 */
	0x179a0011, 0x00000100, 	/* write 256 zeros to address 0x2f3400 */
	0x17a70231, 0x78980001, 	/* write runtime array of size 1 from offset 30872 to address 0x2f4e04 */
	0x00050002, 0x00020000, 	/* if mode != 'bb', skip 5 ops */
	0x17860111, 0x00000080, 	/* write 128 zeros to address 0x2f0c00 (WB) */
	0x17a64011, 0x00000008, 	/* write 8 zeros to address 0x2f4c80 */
	0x17d00021, 0x000000ff, 	/* write array of size 448 from offset 255 to address 0x2fa000 */
	0x17d80021, 0x00000101, 	/* write array of size 448 from offset 257 to address 0x2fb000 */
	0x17f00111, 0x00000380, 	/* write 896 zeros to address 0x2fe000 (WB) */
	0x00060002, 0x002c0000, 	/* if mode != '!bb', skip 6 ops */
	0x17860111, 0x00000100, 	/* write 256 zeros to address 0x2f0c00 (WB) */
	0x178cc431, 0x74fa0008, 	/* write runtime array of size 8 from offset 29946 to address 0x2f1988 */
	0x17a64011, 0x00000010, 	/* write 16 zeros to address 0x2f4c80 */
	0x17d00021, 0x00000103, 	/* write array of size 512 from offset 259 to address 0x2fa000 */
	0x17d80021, 0x00000105, 	/* write array of size 512 from offset 261 to address 0x2fb000 */
	0x17f00111, 0x00000400, 	/* write 1024 zeros to address 0x2fe000 (WB) */
	0x001e0002, 0x00010000, 	/* if mode != 'bb|k2', skip 30 ops */
	0x17889021, 0x00000107, 	/* write array of size 2 from offset 263 to address 0x2f1120 */
	0x1788a001, 0x00000078, 	/* write 0x78 to address 0x2f1140 */
	0x1788a401, 0x00000070, 	/* write 0x70 to address 0x2f1148 */
	0x1788a821, 0x0000010a, 	/* write array of size 7 from offset 266 to address 0x2f1150 */
	0x1788ba21, 0x00000112, 	/* write array of size 2 from offset 274 to address 0x2f1174 */
	0x1788c801, 0x00000030, 	/* write 0x30 to address 0x2f1190 */
	0x1788cc01, 0x00000007, 	/* write 0x7 to address 0x2f1198 */
	0x1788d021, 0x00000114, 	/* write array of size 8 from offset 276 to address 0x2f11a0 */
	0x17891021, 0x0000011d, 	/* write array of size 2 from offset 285 to address 0x2f1220 */
	0x17892001, 0x00000007, 	/* write 0x7 to address 0x2f1240 */
	0x17892401, 0x00000007, 	/* write 0x7 to address 0x2f1248 */
	0x17893201, 0x0000000e, 	/* write 0xe to address 0x2f1264 */
	0x17899021, 0x0000011f, 	/* write array of size 2 from offset 287 to address 0x2f1320 */
	0x1789a001, 0x0000000a, 	/* write 0xa to address 0x2f1340 */
	0x1789a401, 0x0000000a, 	/* write 0xa to address 0x2f1348 */
	0x1789a821, 0x00000121, 	/* write array of size 7 from offset 289 to address 0x2f1350 */
	0x1789ba21, 0x0000011f, 	/* write array of size 2 from offset 287 to address 0x2f1374 */
	0x1789c801, 0x0000000a, 	/* write 0xa to address 0x2f1390 */
	0x1789cc01, 0x0000000a, 	/* write 0xa to address 0x2f1398 */
	0x1789d021, 0x00000123, 	/* write array of size 8 from offset 291 to address 0x2f13a0 */
	0x178a1021, 0x0000011f, 	/* write array of size 2 from offset 287 to address 0x2f1420 */
	0x178a2001, 0x00000001, 	/* write 0x1 to address 0x2f1440 */
	0x178a2401, 0x00000001, 	/* write 0x1 to address 0x2f1448 */
	0x178a3201, 0x0000000a, 	/* write 0xa to address 0x2f1464 */
	0x178b4031, 0x851f0024, 	/* write runtime array of size 36 from offset 34079 to address 0x2f1680 */
	0x178b8001, 0x00000054, 	/* write 0x54 to address 0x2f1700 */
	0x178c4021, 0x00000125, 	/* write array of size 18 from offset 293 to address 0x2f1880 */
	0x178c9601, 0x000080a8, 	/* write 0x80a8 to address 0x2f192c */
	0x178c9a21, 0x00000127, 	/* write array of size 2 from offset 295 to address 0x2f1934 */
	0x178ca421, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x2f1948 */
	0x00020002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 2 ops */
	0x17ae1e21, 0x00000129, 	/* write array of size 4 from offset 297 to address 0x2f5c3c */
	0x17ae5e21, 0x00000129, 	/* write array of size 4 from offset 297 to address 0x2f5cbc */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0x178c6421, 0x0000012e, 	/* write array of size 2 from offset 302 to address 0x2f18c8 */
	0x17976431, 0x75580002, 	/* write runtime array of size 2 from offset 30040 to address 0x2f2ec8 */
	0x17a60e31, 0x78650001, 	/* write runtime array of size 1 from offset 30821 to address 0x2f4c1c */
	0x17976831, 0x755a0002, 	/* write runtime array of size 2 from offset 30042 to address 0x2f2ed0 */
	0x17a61031, 0x78660001, 	/* write runtime array of size 1 from offset 30822 to address 0x2f4c20 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x178ac031, 0x84fb0024, 	/* write runtime array of size 36 from offset 34043 to address 0x2f1580 */
	0x178bc021, 0x00000125, 	/* write array of size 18 from offset 293 to address 0x2f1780 */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0x178be421, 0x0000012e, 	/* write array of size 2 from offset 302 to address 0x2f17c8 */
	0x17960001, 0x00000001, 	/* write 0x1 to address 0x2f2c00 */
	0x17973201, 0x00000001, 	/* write 0x1 to address 0x2f2e64 */
	0x17960001, 0x00000000, 	/* write 0x0 to address 0x2f2c00 */
	0x000c0013, 0xffff0002, 	/* if phase != 'pf', skip 12 ops  */
	0x17975201, 0x00000001, 	/* write 0x1 to address 0x2f2ea4 */
	0x17975611, 0x00000002, 	/* write 2 zeros to address 0x2f2eac */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0x178e1021, 0x00000130, 	/* write array of size 8 from offset 304 to address 0x2f1c20 */
	0x178e3021, 0x00000132, 	/* write array of size 8 from offset 306 to address 0x2f1c60 */
	0x178e5021, 0x00000134, 	/* write array of size 8 from offset 308 to address 0x2f1ca0 */
	0x178e7021, 0x00000136, 	/* write array of size 8 from offset 310 to address 0x2f1ce0 */
	0x00040002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 4 ops */
	0x17f81021, 0x00000130, 	/* write array of size 8 from offset 304 to address 0x2ff020 */
	0x17f83021, 0x00000132, 	/* write array of size 8 from offset 306 to address 0x2ff060 */
	0x17f85021, 0x00000134, 	/* write array of size 8 from offset 308 to address 0x2ff0a0 */
	0x17f87021, 0x00000136, 	/* write array of size 8 from offset 310 to address 0x2ff0e0 */
	0x00180013, 0xffff0004, 	/* if phase != 'qm_pf', skip 24 ops  */
	0x17821a31, 0x742a003b, 	/* write runtime array of size 59 from offset 29738 to address 0x2f0434 */
	0x17830031, 0x746d0080, 	/* write runtime array of size 128 from offset 29805 to address 0x2f0600 */
	0x17960231, 0x75080038, 	/* write runtime array of size 56 from offset 29960 to address 0x2f2c04 */
	0x17970231, 0x75480008, 	/* write runtime array of size 8 from offset 30024 to address 0x2f2e04 */
	0x179a0031, 0x75640100, 	/* write runtime array of size 256 from offset 30052 to address 0x2f3400 */
	0x179e0031, 0x76640100, 	/* write runtime array of size 256 from offset 30308 to address 0x2f3c00 */
	0x17a64031, 0x78670010, 	/* write runtime array of size 16 from offset 30823 to address 0x2f4c80 */
	0x17a68031, 0x78770010, 	/* write runtime array of size 16 from offset 30839 to address 0x2f4d00 */
	0x17a74031, 0x78990010, 	/* write runtime array of size 16 from offset 30873 to address 0x2f4e80 */
	0x17a78031, 0x78a90010, 	/* write runtime array of size 16 from offset 30889 to address 0x2f4f00 */
	0x17b00031, 0x79bb0200, 	/* write runtime array of size 512 from offset 31163 to address 0x2f6000 */
	0x17c80031, 0x7bbb0200, 	/* write runtime array of size 512 from offset 31675 to address 0x2f9000 */
	0x17d00031, 0x7dbb0200, 	/* write runtime array of size 512 from offset 32187 to address 0x2fa000 */
	0x17e80031, 0x81bb0200, 	/* write runtime array of size 512 from offset 33211 to address 0x2fd000 */
	0x00030002, 0x002c0000, 	/* if mode != '!bb', skip 3 ops */
	0x17829031, 0x74650008, 	/* write runtime array of size 8 from offset 29797 to address 0x2f0520 */
	0x17967231, 0x75400008, 	/* write runtime array of size 8 from offset 30016 to address 0x2f2ce4 */
	0x17971231, 0x75500008, 	/* write runtime array of size 8 from offset 30032 to address 0x2f2e24 */
	0x17a20031, 0x77640100, 	/* write runtime array of size 256 from offset 30564 to address 0x2f4400 */
	0x17a6c031, 0x78870010, 	/* write runtime array of size 16 from offset 30855 to address 0x2f4d80 */
	0x17aa0031, 0x78b90100, 	/* write runtime array of size 256 from offset 30905 to address 0x2f5400 */
	0x17e00031, 0x7fbb0200, 	/* write runtime array of size 512 from offset 32699 to address 0x2fc000 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x17fa0031, 0x83bb0140, 	/* write runtime array of size 320 from offset 33723 to address 0x2ff400 */
	0x00020013, 0xffff0003, 	/* if phase != 'vf', skip 2 ops  */
	0x17975401, 0x00000001, 	/* write 0x1 to address 0x2f2ea8 */
	0x17975a11, 0x00000002, 	/* write 2 zeros to address 0x2f2eb4 */
	/* TM */
	0x00170013, 0xffff0000, 	/* if phase != 'engine', skip 23 ops  */
	0x16000001, 0x00000008, 	/* write 0x8 to address 0x2c0000 */
	0x1600c201, 0x00000000, 	/* write 0x0 to address 0x2c0184 */
	0x1600ca01, 0x00000060, 	/* write 0x60 to address 0x2c0194 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0x16025601, 0x00001415, 	/* write 0x1415 to address 0x2c04ac */
	0x16025a01, 0x00002420, 	/* write 0x2420 to address 0x2c04b4 */
	0x16026201, 0x00002411, 	/* write 0x2411 to address 0x2c04c4 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x16010201, 0x00000000, 	/* write 0x0 to address 0x2c0204 */
	0x16000810, 0x00000001, 	/* wait until address 0x2c0010 reads 0x1 */
	0x16024231, 0x70280002, 	/* write runtime array of size 2 from offset 28712 to address 0x2c0484 */
	0x16024611, 0x00000002, 	/* write 2 zeros to address 0x2c048c */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0x16023021, 0x00000138, 	/* write array of size 2 from offset 312 to address 0x2c0460 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0x16022401, 0x00000085, 	/* write 0x85 to address 0x2c0448 */
	0x00010002, 0x00000000, 	/* if mode != '(bb|k2)&((emul_reduced|emul_full)&bb)', skip 1 ops */
	0x16022401, 0x00000004, 	/* write 0x4 to address 0x2c0448 */
	0x00010002, 0x00090000, 	/* if mode != '(bb|k2)&((emul_reduced|emul_full)&k2)', skip 1 ops */
	0x16022401, 0x0000000a, 	/* write 0xa to address 0x2c0448 */
	0x16022601, 0x00000001, 	/* write 0x1 to address 0x2c044c */
	0x16022a01, 0x00000001, 	/* write 0x1 to address 0x2c0454 */
	0x16022e01, 0x00000001, 	/* write 0x1 to address 0x2c045c */
	0x00040013, 0xffff0002, 	/* if phase != 'pf', skip 4 ops  */
	0x16080131, 0x702a01a0, 	/* write runtime array of size 416 from offset 28714 to address 0x2c1000 (WB) */
	0x16100131, 0x71ca0260, 	/* write runtime array of size 608 from offset 29130 to address 0x2c2000 (WB) */
	0x16021e31, 0x70260001, 	/* write runtime array of size 1 from offset 28710 to address 0x2c043c */
	0x16022231, 0x70270001, 	/* write runtime array of size 1 from offset 28711 to address 0x2c0444 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0x16021c31, 0x70250001, 	/* write runtime array of size 1 from offset 28709 to address 0x2c0438 */
	/* DORQ */
	0x001f0013, 0xffff0000, 	/* if phase != 'engine', skip 31 ops  */
	0x0800c201, 0x00000000, 	/* write 0x0 to address 0x100184 */
	0x0800ca01, 0x00000000, 	/* write 0x0 to address 0x100194 */
	0x08041221, 0x00000033, 	/* write array of size 3 from offset 51 to address 0x100824 */
	0x0804ee01, 0x00000600, 	/* write 0x600 to address 0x1009dc */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x08045a11, 0x00000002, 	/* write 2 zeros to address 0x1008b4 */
	0x08046601, 0x000012b7, 	/* write 0x12b7 to address 0x1008cc */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x08010201, 0x00000000, 	/* write 0x0 to address 0x100204 */
	0x08080011, 0x00000280, 	/* write 640 zeros to address 0x101000 */
	0x00140002, 0x00010000, 	/* if mode != 'bb|k2', skip 20 ops */
	0x08024401, 0x00000001, 	/* write 0x1 to address 0x100488 */
	0x08025401, 0x00000001, 	/* write 0x1 to address 0x1004a8 */
	0x08025e01, 0x00000000, 	/* write 0x0 to address 0x1004bc */
	0x08027401, 0x00000001, 	/* write 0x1 to address 0x1004e8 */
	0x08027801, 0x00000001, 	/* write 0x1 to address 0x1004f0 */
	0x08031621, 0x0000013b, 	/* write array of size 2 from offset 315 to address 0x10062c */
	0x08032401, 0x00000002, 	/* write 0x2 to address 0x100648 */
	0x08032801, 0x00000020, 	/* write 0x20 to address 0x100650 */
	0x08033201, 0x00000018, 	/* write 0x18 to address 0x100664 */
	0x08033621, 0x0000013e, 	/* write array of size 2 from offset 318 to address 0x10066c */
	0x08034621, 0x00000140, 	/* write array of size 2 from offset 320 to address 0x10068c */
	0x08034e01, 0x00000002, 	/* write 0x2 to address 0x10069c */
	0x08035401, 0x00000008, 	/* write 0x8 to address 0x1006a8 */
	0x08035801, 0x00000001, 	/* write 0x1 to address 0x1006b0 */
	0x08035e01, 0x00000014, 	/* write 0x14 to address 0x1006bc */
	0x08036221, 0x00000143, 	/* write array of size 2 from offset 323 to address 0x1006c4 */
	0x08036801, 0x00000010, 	/* write 0x10 to address 0x1006d0 */
	0x08036e21, 0x00000146, 	/* write array of size 3 from offset 326 to address 0x1006dc */
	0x08040221, 0x0000014a, 	/* write array of size 3 from offset 330 to address 0x100804 */
	0x08049001, 0x00000001, 	/* write 0x1 to address 0x100920 */
	0x00060013, 0xffff0002, 	/* if phase != 'pf', skip 6 ops  */
	0x08028231, 0x00100001, 	/* write runtime array of size 1 from offset 16 to address 0x100504 */
	0x08028821, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x100510 */
	0x00010002, 0x003d0000, 	/* if mode != 'ports_per_eng_1', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0x08020431, 0x00000010, 	/* write runtime array of size 16 from offset 0 to address 0x100408 */
	0x00040013, 0x00000002, 	/* if phase != 'pf0', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00040013, 0x00010002, 	/* if phase != 'pf1', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00040013, 0x00020002, 	/* if phase != 'pf2', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000002, 	/* write 0x2 to address 0x100500 */
	0x00040013, 0x00030002, 	/* if phase != 'pf3', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000003, 	/* write 0x3 to address 0x100500 */
	0x00040013, 0x00040002, 	/* if phase != 'pf4', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00040013, 0x00050002, 	/* if phase != 'pf5', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00040013, 0x00060002, 	/* if phase != 'pf6', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000002, 	/* write 0x2 to address 0x100500 */
	0x00040013, 0x00070002, 	/* if phase != 'pf7', skip 4 ops  */
	0x00010002, 0x004f0000, 	/* if mode != 'ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000003, 	/* write 0x3 to address 0x100500 */
	0x00040013, 0x00080002, 	/* if phase != 'pf8', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00040013, 0x00090002, 	/* if phase != 'pf9', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00040013, 0x000a0002, 	/* if phase != 'pf10', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000002, 	/* write 0x2 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00040013, 0x000b0002, 	/* if phase != 'pf11', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000003, 	/* write 0x3 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00040013, 0x000c0002, 	/* if phase != 'pf12', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00040013, 0x000d0002, 	/* if phase != 'pf13', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00040013, 0x000e0002, 	/* if phase != 'pf14', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000002, 	/* write 0x2 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000000, 	/* write 0x0 to address 0x100500 */
	0x00040013, 0x000f0002, 	/* if phase != 'pf15', skip 4 ops  */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x08028001, 0x00000003, 	/* write 0x3 to address 0x100500 */
	0x00010002, 0x00cf0000, 	/* if mode != 'k2&ports_per_eng_2', skip 1 ops */
	0x08028001, 0x00000001, 	/* write 0x1 to address 0x100500 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0x08028401, 0x00000001, 	/* write 0x1 to address 0x100508 */
	0x00010013, 0xffff0001, 	/* if phase != 'port', skip 1 ops  */
	0x08044231, 0x00110001, 	/* write runtime array of size 1 from offset 17 to address 0x100884 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0x08028601, 0x00000001, 	/* write 0x1 to address 0x10050c */
	/* BRB */
	0x012a0013, 0xffff0000, 	/* if phase != 'engine', skip 298 ops  */
	0x1a006201, 0x00000000, 	/* write 0x0 to address 0x3400c4 */
	0x1a006e01, 0x00000000, 	/* write 0x0 to address 0x3400dc */
	0x1a007a01, 0x00000000, 	/* write 0x0 to address 0x3400f4 */
	0x1a008601, 0x00000000, 	/* write 0x0 to address 0x34010c */
	0x1a009201, 0x00200000, 	/* write 0x200000 to address 0x340124 */
	0x1a009e01, 0x00000000, 	/* write 0x0 to address 0x34013c */
	0x1a00aa01, 0x00000000, 	/* write 0x0 to address 0x340154 */
	0x1a00b601, 0x00000000, 	/* write 0x0 to address 0x34016c */
	0x1a00c401, 0x00000000, 	/* write 0x0 to address 0x340188 */
	0x1a00d001, 0x00000000, 	/* write 0x0 to address 0x3401a0 */
	0x1a00e801, 0x00000000, 	/* write 0x0 to address 0x3401d0 */
	0x1a00f001, 0x00000000, 	/* write 0x0 to address 0x3401e0 */
	0x00090002, 0x00020000, 	/* if mode != 'bb', skip 9 ops */
	0x1a00dc01, 0x00000000, 	/* write 0x0 to address 0x3401b8 */
	0x1a020201, 0x00000000, 	/* write 0x0 to address 0x340404 */
	0x1a020a01, 0x00000000, 	/* write 0x0 to address 0x340414 */
	0x1a052a01, 0x00000000, 	/* write 0x0 to address 0x340a54 */
	0x1a055a01, 0x00000000, 	/* write 0x0 to address 0x340ab4 */
	0x1a059601, 0x00000000, 	/* write 0x0 to address 0x340b2c */
	0x1a05c601, 0x00000000, 	/* write 0x0 to address 0x340b8c */
	0x1a063401, 0x00000070, 	/* write 0x70 to address 0x340c68 */
	0x1a064001, 0x00000070, 	/* write 0x70 to address 0x340c80 */
	0x001e0002, 0x00030000, 	/* if mode != 'k2', skip 30 ops */
	0x1a020201, 0x00000000, 	/* write 0x0 to address 0x340404 */
	0x1a020a01, 0x00000000, 	/* write 0x0 to address 0x340414 */
	0x1a052a01, 0x00000000, 	/* write 0x0 to address 0x340a54 */
	0x1a052e01, 0x00000000, 	/* write 0x0 to address 0x340a5c */
	0x1a053201, 0x00000000, 	/* write 0x0 to address 0x340a64 */
	0x1a053601, 0x00000000, 	/* write 0x0 to address 0x340a6c */
	0x1a053a01, 0x00000000, 	/* write 0x0 to address 0x340a74 */
	0x1a053e01, 0x00000000, 	/* write 0x0 to address 0x340a7c */
	0x1a054201, 0x00000000, 	/* write 0x0 to address 0x340a84 */
	0x1a054601, 0x00000000, 	/* write 0x0 to address 0x340a8c */
	0x1a055a01, 0x00000000, 	/* write 0x0 to address 0x340ab4 */
	0x1a055e01, 0x00000000, 	/* write 0x0 to address 0x340abc */
	0x1a056401, 0x00000000, 	/* write 0x0 to address 0x340ac8 */
	0x1a057201, 0x00000000, 	/* write 0x0 to address 0x340ae4 */
	0x1a057801, 0x00000000, 	/* write 0x0 to address 0x340af0 */
	0x1a057c01, 0x00000000, 	/* write 0x0 to address 0x340af8 */
	0x1a059601, 0x00000000, 	/* write 0x0 to address 0x340b2c */
	0x1a059a01, 0x00000000, 	/* write 0x0 to address 0x340b34 */
	0x1a059e01, 0x00000000, 	/* write 0x0 to address 0x340b3c */
	0x1a05a201, 0x00000000, 	/* write 0x0 to address 0x340b44 */
	0x1a05a601, 0x00000000, 	/* write 0x0 to address 0x340b4c */
	0x1a05aa01, 0x00000000, 	/* write 0x0 to address 0x340b54 */
	0x1a05ae01, 0x00000000, 	/* write 0x0 to address 0x340b5c */
	0x1a05b201, 0x00000000, 	/* write 0x0 to address 0x340b64 */
	0x1a05c601, 0x00000000, 	/* write 0x0 to address 0x340b8c */
	0x1a05ca01, 0x00000000, 	/* write 0x0 to address 0x340b94 */
	0x1a05d001, 0x00000000, 	/* write 0x0 to address 0x340ba0 */
	0x1a05de01, 0x00000000, 	/* write 0x0 to address 0x340bbc */
	0x1a05e401, 0x00000000, 	/* write 0x0 to address 0x340bc8 */
	0x1a05e801, 0x00000000, 	/* write 0x0 to address 0x340bd0 */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x1a00dc01, 0x04000000, 	/* write 0x4000000 to address 0x3401b8 */
	0x003d0002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 61 ops */
	0x1a044021, 0x0000014e, 	/* write array of size 4 from offset 334 to address 0x340880 */
	0x1a048021, 0x00000150, 	/* write array of size 3 from offset 336 to address 0x340900 */
	0x1a048a21, 0x00000150, 	/* write array of size 3 from offset 336 to address 0x340914 */
	0x1a049421, 0x00000150, 	/* write array of size 3 from offset 336 to address 0x340928 */
	0x1a049e21, 0x00000150, 	/* write array of size 3 from offset 336 to address 0x34093c */
	0x1a04bc21, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x340978 */
	0x1a04c421, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x340988 */
	0x1a04cc21, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x340998 */
	0x1a04d421, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x3409a8 */
	0x1a04ec21, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x3409d8 */
	0x1a04f621, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x3409ec */
	0x1a050021, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x340a00 */
	0x1a050a21, 0x00000154, 	/* write array of size 3 from offset 340 to address 0x340a14 */
	0x1a052801, 0x00000360, 	/* write 0x360 to address 0x340a50 */
	0x1a052c01, 0x00000360, 	/* write 0x360 to address 0x340a58 */
	0x1a053001, 0x00000360, 	/* write 0x360 to address 0x340a60 */
	0x1a053401, 0x00000360, 	/* write 0x360 to address 0x340a68 */
	0x1a053801, 0x00000360, 	/* write 0x360 to address 0x340a70 */
	0x1a053c01, 0x00000360, 	/* write 0x360 to address 0x340a78 */
	0x1a054001, 0x00000360, 	/* write 0x360 to address 0x340a80 */
	0x1a054401, 0x00000360, 	/* write 0x360 to address 0x340a88 */
	0x1a055801, 0x00000360, 	/* write 0x360 to address 0x340ab0 */
	0x1a055c01, 0x00000360, 	/* write 0x360 to address 0x340ab8 */
	0x1a056021, 0x00000158, 	/* write array of size 2 from offset 344 to address 0x340ac0 */
	0x1a056621, 0x0000015a, 	/* write array of size 6 from offset 346 to address 0x340acc */
	0x1a057421, 0x00000158, 	/* write array of size 2 from offset 344 to address 0x340ae8 */
	0x1a057a01, 0x00000360, 	/* write 0x360 to address 0x340af4 */
	0x1a057e01, 0x00000360, 	/* write 0x360 to address 0x340afc */
	0x1a059401, 0x00000400, 	/* write 0x400 to address 0x340b28 */
	0x1a059801, 0x00000400, 	/* write 0x400 to address 0x340b30 */
	0x1a059c01, 0x00000400, 	/* write 0x400 to address 0x340b38 */
	0x1a05a001, 0x00000400, 	/* write 0x400 to address 0x340b40 */
	0x1a05a401, 0x00000400, 	/* write 0x400 to address 0x340b48 */
	0x1a05a801, 0x00000400, 	/* write 0x400 to address 0x340b50 */
	0x1a05ac01, 0x00000400, 	/* write 0x400 to address 0x340b58 */
	0x1a05b001, 0x00000400, 	/* write 0x400 to address 0x340b60 */
	0x1a05c401, 0x00000400, 	/* write 0x400 to address 0x340b88 */
	0x1a05c801, 0x00000400, 	/* write 0x400 to address 0x340b90 */
	0x1a05cc21, 0x00000161, 	/* write array of size 2 from offset 353 to address 0x340b98 */
	0x1a05d221, 0x00000163, 	/* write array of size 6 from offset 355 to address 0x340ba4 */
	0x1a05e021, 0x00000161, 	/* write array of size 2 from offset 353 to address 0x340bc0 */
	0x1a05e601, 0x00000400, 	/* write 0x400 to address 0x340bcc */
	0x1a05ea01, 0x00000400, 	/* write 0x400 to address 0x340bd4 */
	0x1a060021, 0x0000016a, 	/* write array of size 3 from offset 362 to address 0x340c00 */
	0x1a060821, 0x0000016a, 	/* write array of size 3 from offset 362 to address 0x340c10 */
	0x1a061021, 0x0000016a, 	/* write array of size 3 from offset 362 to address 0x340c20 */
	0x1a061821, 0x0000016a, 	/* write array of size 3 from offset 362 to address 0x340c30 */
	0x1a063021, 0x0000016e, 	/* write array of size 3 from offset 366 to address 0x340c60 */
	0x1a063821, 0x00000172, 	/* write array of size 4 from offset 370 to address 0x340c70 */
	0x1a064221, 0x00000172, 	/* write array of size 4 from offset 370 to address 0x340c84 */
	0x1a064c21, 0x00000172, 	/* write array of size 4 from offset 370 to address 0x340c98 */
	0x1a065601, 0x00000058, 	/* write 0x58 to address 0x340cac */
	0x1a066c21, 0x00000177, 	/* write array of size 3 from offset 375 to address 0x340cd8 */
	0x1a067421, 0x00000177, 	/* write array of size 3 from offset 375 to address 0x340ce8 */
	0x1a067c21, 0x00000177, 	/* write array of size 3 from offset 375 to address 0x340cf8 */
	0x1a068421, 0x00000177, 	/* write array of size 3 from offset 375 to address 0x340d08 */
	0x1a069c21, 0x0000017b, 	/* write array of size 3 from offset 379 to address 0x340d38 */
	0x1a06a421, 0x0000017f, 	/* write array of size 4 from offset 383 to address 0x340d48 */
	0x1a06ae21, 0x0000017f, 	/* write array of size 4 from offset 383 to address 0x340d5c */
	0x1a06b821, 0x0000017f, 	/* write array of size 4 from offset 383 to address 0x340d70 */
	0x1a06c201, 0x000000f8, 	/* write 0xf8 to address 0x340d84 */
	0x001e0002, 0x00560000, 	/* if mode != 'bb&(!100g)&ports_per_eng_1', skip 30 ops */
	0x1a044021, 0x00000184, 	/* write array of size 2 from offset 388 to address 0x340880 */
	0x1a046021, 0x00000187, 	/* write array of size 2 from offset 391 to address 0x3408c0 */
	0x1a048021, 0x0000018a, 	/* write array of size 3 from offset 394 to address 0x340900 */
	0x1a04a201, 0x00000000, 	/* write 0x0 to address 0x340944 */
	0x1a04c001, 0x000000a0, 	/* write 0xa0 to address 0x340980 */
	0x1a04f001, 0x000000a0, 	/* write 0xa0 to address 0x3409e0 */
	0x1a052801, 0x00000738, 	/* write 0x738 to address 0x340a50 */
	0x1a052c01, 0x00000738, 	/* write 0x738 to address 0x340a58 */
	0x1a053801, 0x000012c1, 	/* write 0x12c1 to address 0x340a70 */
	0x1a055801, 0x00000738, 	/* write 0x738 to address 0x340ab0 */
	0x1a055c01, 0x00000738, 	/* write 0x738 to address 0x340ab8 */
	0x1a056821, 0x0000018e, 	/* write array of size 2 from offset 398 to address 0x340ad0 */
	0x1a057a01, 0x000012c1, 	/* write 0x12c1 to address 0x340af4 */
	0x1a059401, 0x000007d8, 	/* write 0x7d8 to address 0x340b28 */
	0x1a059801, 0x000007d8, 	/* write 0x7d8 to address 0x340b30 */
	0x1a05a401, 0x000012c1, 	/* write 0x12c1 to address 0x340b48 */
	0x1a05c401, 0x000007d8, 	/* write 0x7d8 to address 0x340b88 */
	0x1a05c801, 0x000007d8, 	/* write 0x7d8 to address 0x340b90 */
	0x1a05d421, 0x00000191, 	/* write array of size 2 from offset 401 to address 0x340ba8 */
	0x1a05e601, 0x000012c1, 	/* write 0x12c1 to address 0x340bcc */
	0x1a060201, 0x00000738, 	/* write 0x738 to address 0x340c04 */
	0x1a061021, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340c20 */
	0x1a063201, 0x00000738, 	/* write 0x738 to address 0x340c64 */
	0x1a064221, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340c84 */
	0x1a065201, 0x000012c1, 	/* write 0x12c1 to address 0x340ca4 */
	0x1a066e01, 0x000007d8, 	/* write 0x7d8 to address 0x340cdc */
	0x1a067c21, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340cf8 */
	0x1a069e01, 0x000007d8, 	/* write 0x7d8 to address 0x340d3c */
	0x1a06ae21, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340d5c */
	0x1a06be01, 0x000012c1, 	/* write 0x12c1 to address 0x340d7c */
	0x00210002, 0x004a0000, 	/* if mode != 'bb&(!100g)&ports_per_eng_2', skip 33 ops */
	0x1a044021, 0x00000196, 	/* write array of size 2 from offset 406 to address 0x340880 */
	0x1a046021, 0x00000198, 	/* write array of size 2 from offset 408 to address 0x3408c0 */
	0x1a048021, 0x0000019a, 	/* write array of size 3 from offset 410 to address 0x340900 */
	0x1a049221, 0x0000019a, 	/* write array of size 3 from offset 410 to address 0x340924 */
	0x1a04c001, 0x00000050, 	/* write 0x50 to address 0x340980 */
	0x1a04cc21, 0x0000019e, 	/* write array of size 3 from offset 414 to address 0x340998 */
	0x1a04f001, 0x00000050, 	/* write 0x50 to address 0x3409e0 */
	0x1a04fe21, 0x0000019e, 	/* write array of size 3 from offset 414 to address 0x3409fc */
	0x1a050e01, 0x00000018, 	/* write 0x18 to address 0x340a1c */
	0x1a052801, 0x000003c8, 	/* write 0x3c8 to address 0x340a50 */
	0x1a052c01, 0x000003c8, 	/* write 0x3c8 to address 0x340a58 */
	0x1a053821, 0x000001a2, 	/* write array of size 3 from offset 418 to address 0x340a70 */
	0x1a055801, 0x000003c8, 	/* write 0x3c8 to address 0x340ab0 */
	0x1a055c01, 0x000003c8, 	/* write 0x3c8 to address 0x340ab8 */
	0x1a056821, 0x000001a6, 	/* write array of size 4 from offset 422 to address 0x340ad0 */
	0x1a057a01, 0x000003c8, 	/* write 0x3c8 to address 0x340af4 */
	0x1a059401, 0x00000468, 	/* write 0x468 to address 0x340b28 */
	0x1a059801, 0x00000468, 	/* write 0x468 to address 0x340b30 */
	0x1a05a421, 0x000001ab, 	/* write array of size 3 from offset 427 to address 0x340b48 */
	0x1a05c401, 0x00000468, 	/* write 0x468 to address 0x340b88 */
	0x1a05c801, 0x00000468, 	/* write 0x468 to address 0x340b90 */
	0x1a05d421, 0x000001af, 	/* write array of size 4 from offset 431 to address 0x340ba8 */
	0x1a05e601, 0x00000468, 	/* write 0x468 to address 0x340bcc */
	0x1a060201, 0x000003c8, 	/* write 0x3c8 to address 0x340c04 */
	0x1a061021, 0x000001b4, 	/* write array of size 3 from offset 436 to address 0x340c20 */
	0x1a063201, 0x000003c8, 	/* write 0x3c8 to address 0x340c64 */
	0x1a064221, 0x000001b8, 	/* write array of size 3 from offset 440 to address 0x340c84 */
	0x1a065201, 0x00000070, 	/* write 0x70 to address 0x340ca4 */
	0x1a066e01, 0x00000468, 	/* write 0x468 to address 0x340cdc */
	0x1a067c21, 0x000001bc, 	/* write array of size 3 from offset 444 to address 0x340cf8 */
	0x1a069e01, 0x00000468, 	/* write 0x468 to address 0x340d3c */
	0x1a06ae21, 0x000001c0, 	/* write array of size 3 from offset 448 to address 0x340d5c */
	0x1a06be01, 0x00000110, 	/* write 0x110 to address 0x340d7c */
	0x00200002, 0x00cc0000, 	/* if mode != 'bb&100g', skip 32 ops */
	0x1a044021, 0x000001c4, 	/* write array of size 2 from offset 452 to address 0x340880 */
	0x1a046021, 0x000001c7, 	/* write array of size 2 from offset 455 to address 0x3408c0 */
	0x1a048021, 0x000001ca, 	/* write array of size 3 from offset 458 to address 0x340900 */
	0x1a049001, 0x00000010, 	/* write 0x10 to address 0x340920 */
	0x1a04bc21, 0x000001ce, 	/* write array of size 3 from offset 462 to address 0x340978 */
	0x1a04ec21, 0x000001ce, 	/* write array of size 3 from offset 462 to address 0x3409d8 */
	0x1a04fc01, 0x0000000c, 	/* write 0xc to address 0x3409f8 */
	0x1a050e01, 0x00000000, 	/* write 0x0 to address 0x340a1c */
	0x1a052801, 0x000003f4, 	/* write 0x3f4 to address 0x340a50 */
	0x1a052c01, 0x000003f4, 	/* write 0x3f4 to address 0x340a58 */
	0x1a053801, 0x000012c1, 	/* write 0x12c1 to address 0x340a70 */
	0x1a055801, 0x000003f4, 	/* write 0x3f4 to address 0x340ab0 */
	0x1a055c01, 0x000003f4, 	/* write 0x3f4 to address 0x340ab8 */
	0x1a056821, 0x000001d0, 	/* write array of size 2 from offset 464 to address 0x340ad0 */
	0x1a057a01, 0x000012c1, 	/* write 0x12c1 to address 0x340af4 */
	0x1a059401, 0x00000444, 	/* write 0x444 to address 0x340b28 */
	0x1a059801, 0x00000444, 	/* write 0x444 to address 0x340b30 */
	0x1a05a401, 0x000012c1, 	/* write 0x12c1 to address 0x340b48 */
	0x1a05c401, 0x00000444, 	/* write 0x444 to address 0x340b88 */
	0x1a05c801, 0x00000444, 	/* write 0x444 to address 0x340b90 */
	0x1a05d421, 0x000001d3, 	/* write array of size 2 from offset 467 to address 0x340ba8 */
	0x1a05e601, 0x000012c1, 	/* write 0x12c1 to address 0x340bcc */
	0x1a060021, 0x000001d6, 	/* write array of size 3 from offset 470 to address 0x340c00 */
	0x1a061021, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340c20 */
	0x1a063021, 0x000001da, 	/* write array of size 2 from offset 474 to address 0x340c60 */
	0x1a064221, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340c84 */
	0x1a065201, 0x000012c1, 	/* write 0x12c1 to address 0x340ca4 */
	0x1a066c21, 0x000001dd, 	/* write array of size 3 from offset 477 to address 0x340cd8 */
	0x1a067c21, 0x00000194, 	/* write array of size 2 from offset 404 to address 0x340cf8 */
	0x1a069c21, 0x000001e1, 	/* write array of size 3 from offset 481 to address 0x340d38 */
	0x1a06ac21, 0x000001e5, 	/* write array of size 3 from offset 485 to address 0x340d58 */
	0x1a06be01, 0x000012c1, 	/* write 0x12c1 to address 0x340d7c */
	0x00400002, 0x00c40000, 	/* if mode != 'k2&(!ports_per_eng_4)', skip 64 ops */
	0x1a044021, 0x000001e9, 	/* write array of size 4 from offset 489 to address 0x340880 */
	0x1a046021, 0x000001ee, 	/* write array of size 4 from offset 494 to address 0x3408c0 */
	0x1a048021, 0x000001f3, 	/* write array of size 3 from offset 499 to address 0x340900 */
	0x1a048801, 0x00000000, 	/* write 0x0 to address 0x340910 */
	0x1a049021, 0x000001f7, 	/* write array of size 4 from offset 503 to address 0x340920 */
	0x1a049c01, 0x00000000, 	/* write 0x0 to address 0x340938 */
	0x1a04a201, 0x00000010, 	/* write 0x10 to address 0x340944 */
	0x1a04a601, 0x00000000, 	/* write 0x0 to address 0x34094c */
	0x1a04bc21, 0x000001fc, 	/* write array of size 3 from offset 508 to address 0x340978 */
	0x1a04cc21, 0x000001fc, 	/* write array of size 3 from offset 508 to address 0x340998 */
	0x1a04ec21, 0x000001fc, 	/* write array of size 3 from offset 508 to address 0x3409d8 */
	0x1a04f401, 0x00000000, 	/* write 0x0 to address 0x3409e8 */
	0x1a04fc21, 0x00000200, 	/* write array of size 4 from offset 512 to address 0x3409f8 */
	0x1a050801, 0x00000000, 	/* write 0x0 to address 0x340a10 */
	0x1a050e01, 0x00000008, 	/* write 0x8 to address 0x340a1c */
	0x1a051201, 0x00000000, 	/* write 0x0 to address 0x340a24 */
	0x1a052801, 0x0000029c, 	/* write 0x29c to address 0x340a50 */
	0x1a052c01, 0x0000029c, 	/* write 0x29c to address 0x340a58 */
	0x1a053001, 0x00000000, 	/* write 0x0 to address 0x340a60 */
	0x1a053401, 0x00000000, 	/* write 0x0 to address 0x340a68 */
	0x1a053801, 0x0000029c, 	/* write 0x29c to address 0x340a70 */
	0x1a053c01, 0x0000029c, 	/* write 0x29c to address 0x340a78 */
	0x1a054001, 0x00000000, 	/* write 0x0 to address 0x340a80 */
	0x1a054401, 0x00000000, 	/* write 0x0 to address 0x340a88 */
	0x1a055801, 0x0000029c, 	/* write 0x29c to address 0x340ab0 */
	0x1a055c01, 0x0000029c, 	/* write 0x29c to address 0x340ab8 */
	0x1a056011, 0x00000002, 	/* write 2 zeros to address 0x340ac0 */
	0x1a056621, 0x00000205, 	/* write array of size 6 from offset 517 to address 0x340acc */
	0x1a057411, 0x00000002, 	/* write 2 zeros to address 0x340ae8 */
	0x1a057a01, 0x0000029c, 	/* write 0x29c to address 0x340af4 */
	0x1a057e01, 0x00000000, 	/* write 0x0 to address 0x340afc */
	0x1a059401, 0x000002ec, 	/* write 0x2ec to address 0x340b28 */
	0x1a059801, 0x000002ec, 	/* write 0x2ec to address 0x340b30 */
	0x1a059c01, 0x00000000, 	/* write 0x0 to address 0x340b38 */
	0x1a05a001, 0x00000000, 	/* write 0x0 to address 0x340b40 */
	0x1a05a401, 0x000002ec, 	/* write 0x2ec to address 0x340b48 */
	0x1a05a801, 0x000002ec, 	/* write 0x2ec to address 0x340b50 */
	0x1a05ac01, 0x00000000, 	/* write 0x0 to address 0x340b58 */
	0x1a05b001, 0x00000000, 	/* write 0x0 to address 0x340b60 */
	0x1a05c401, 0x000002ec, 	/* write 0x2ec to address 0x340b88 */
	0x1a05c801, 0x000002ec, 	/* write 0x2ec to address 0x340b90 */
	0x1a05cc11, 0x00000002, 	/* write 2 zeros to address 0x340b98 */
	0x1a05d221, 0x0000020c, 	/* write array of size 6 from offset 524 to address 0x340ba4 */
	0x1a05e011, 0x00000002, 	/* write 2 zeros to address 0x340bc0 */
	0x1a05e601, 0x000002ec, 	/* write 0x2ec to address 0x340bcc */
	0x1a05ea01, 0x00000000, 	/* write 0x0 to address 0x340bd4 */
	0x1a060021, 0x00000213, 	/* write array of size 3 from offset 531 to address 0x340c00 */
	0x1a060821, 0x00000217, 	/* write array of size 2 from offset 535 to address 0x340c10 */
	0x1a061021, 0x00000213, 	/* write array of size 3 from offset 531 to address 0x340c20 */
	0x1a061821, 0x00000217, 	/* write array of size 2 from offset 535 to address 0x340c30 */
	0x1a063021, 0x00000219, 	/* write array of size 3 from offset 537 to address 0x340c60 */
	0x1a063821, 0x0000021d, 	/* write array of size 3 from offset 541 to address 0x340c70 */
	0x1a064021, 0x0000021f, 	/* write array of size 4 from offset 543 to address 0x340c80 */
	0x1a064c21, 0x00000224, 	/* write array of size 4 from offset 548 to address 0x340c98 */
	0x1a065601, 0x00001e01, 	/* write 0x1e01 to address 0x340cac */
	0x1a066c21, 0x00000229, 	/* write array of size 3 from offset 553 to address 0x340cd8 */
	0x1a067421, 0x00000217, 	/* write array of size 2 from offset 535 to address 0x340ce8 */
	0x1a067c21, 0x00000229, 	/* write array of size 3 from offset 553 to address 0x340cf8 */
	0x1a068421, 0x00000217, 	/* write array of size 2 from offset 535 to address 0x340d08 */
	0x1a069c21, 0x0000022d, 	/* write array of size 3 from offset 557 to address 0x340d38 */
	0x1a06a421, 0x0000021d, 	/* write array of size 3 from offset 541 to address 0x340d48 */
	0x1a06ac21, 0x00000231, 	/* write array of size 4 from offset 561 to address 0x340d58 */
	0x1a06b821, 0x00000236, 	/* write array of size 4 from offset 566 to address 0x340d70 */
	0x1a06c201, 0x00001e01, 	/* write 0x1e01 to address 0x340d84 */
	0x000b0002, 0x00bc0000, 	/* if mode != 'bb&(!100g)', skip 11 ops */
	0x1a04bc21, 0x0000023b, 	/* write array of size 2 from offset 571 to address 0x340978 */
	0x1a04ec21, 0x0000023b, 	/* write array of size 2 from offset 571 to address 0x3409d8 */
	0x1a04fc01, 0x00000018, 	/* write 0x18 to address 0x3409f8 */
	0x1a060001, 0x000000f8, 	/* write 0xf8 to address 0x340c00 */
	0x1a060401, 0x000000f8, 	/* write 0xf8 to address 0x340c08 */
	0x1a063001, 0x000000f8, 	/* write 0xf8 to address 0x340c60 */
	0x1a066c01, 0x00000198, 	/* write 0x198 to address 0x340cd8 */
	0x1a067001, 0x00000198, 	/* write 0x198 to address 0x340ce0 */
	0x1a069c01, 0x00000198, 	/* write 0x198 to address 0x340d38 */
	0x1a06a001, 0x00000110, 	/* write 0x110 to address 0x340d40 */
	0x1a06ac01, 0x00000110, 	/* write 0x110 to address 0x340d58 */
	0x1a000201, 0x00000003, 	/* write 0x3 to address 0x340004 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x1a040201, 0x00000014, 	/* write 0x14 to address 0x340804 */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0x1a042001, 0x000000e1, 	/* write 0xe1 to address 0x340840 */
	0x1a000410, 0x00000003, 	/* wait until address 0x340008 reads 0x3 */
	/* SRC */
	0x00010013, 0xffff0000, 	/* if phase != 'engine', skip 1 ops  */
	0x11c0f201, 0x00000000, 	/* write 0x0 to address 0x2381e4 */
	0x00040013, 0xffff0002, 	/* if phase != 'pf', skip 4 ops  */
	0x11c28131, 0x1a090002, 	/* write runtime array of size 2 from offset 6665 to address 0x238500 (WB) */
	0x11c29131, 0x1a0b0002, 	/* write runtime array of size 2 from offset 6667 to address 0x238520 (WB) */
	0x11c2a031, 0x1a0d0001, 	/* write runtime array of size 1 from offset 6669 to address 0x238540 */
	0x11c30231, 0x1a0e0001, 	/* write runtime array of size 1 from offset 6670 to address 0x238604 */
	/* PRS */
	0x00270013, 0xffff0000, 	/* if phase != 'engine', skip 39 ops  */
	0x0f800201, 0x00000001, 	/* write 0x1 to address 0x1f0004 */
	0x0f800621, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x1f000c */
	0x0f802201, 0x00000000, 	/* write 0x0 to address 0x1f0044 */
	0x0f802a01, 0x00000000, 	/* write 0x0 to address 0x1f0054 */
	0x0f80b201, 0x00000001, 	/* write 0x1 to address 0x1f0164 */
	0x0f83a631, 0x1a070001, 	/* write runtime array of size 1 from offset 6663 to address 0x1f074c */
	0x0f84a801, 0x00008915, 	/* write 0x8915 to address 0x1f0950 */
	0x0f84ba21, 0x0000023d, 	/* write array of size 2 from offset 573 to address 0x1f0974 */
	0x0f84e421, 0x0000023f, 	/* write array of size 2 from offset 575 to address 0x1f09c8 */
	0x0f888011, 0x0000001f, 	/* write 31 zeros to address 0x1f1100 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x0f810401, 0x00000000, 	/* write 0x0 to address 0x1f0208 */
	0x0f810c01, 0x00000000, 	/* write 0x0 to address 0x1f0218 */
	0x00020002, 0x00030000, 	/* if mode != 'k2', skip 2 ops */
	0x0f810401, 0x00000000, 	/* write 0x0 to address 0x1f0208 */
	0x0f810c01, 0x00000000, 	/* write 0x0 to address 0x1f0218 */
	0x00010002, 0x002e0000, 	/* if mode != 'mf_sd', skip 1 ops */
	0x0f83b201, 0x00000001, 	/* write 0x1 to address 0x1f0764 */
	0x00120002, 0x00010000, 	/* if mode != 'bb|k2', skip 18 ops */
	0x0f808021, 0x00000242, 	/* write array of size 3 from offset 578 to address 0x1f0100 */
	0x0f808821, 0x00000246, 	/* write array of size 5 from offset 582 to address 0x1f0110 */
	0x0f809a21, 0x0000024c, 	/* write array of size 2 from offset 588 to address 0x1f0134 */
	0x0f80a021, 0x0000024f, 	/* write array of size 4 from offset 591 to address 0x1f0140 */
	0x0f80aa21, 0x00000254, 	/* write array of size 4 from offset 596 to address 0x1f0154 */
	0x0f80bc21, 0x00000259, 	/* write array of size 5 from offset 601 to address 0x1f0178 */
	0x0f843801, 0x000012b7, 	/* write 0x12b7 to address 0x1f0870 */
	0x0f848021, 0x0000025f, 	/* write array of size 8 from offset 607 to address 0x1f0900 */
	0x0f849221, 0x00000268, 	/* write array of size 7 from offset 616 to address 0x1f0924 */
	0x0f84be01, 0xfffff810, 	/* write 0xfffff810 to address 0x1f097c */
	0x0f84c201, 0xfffffe50, 	/* write 0xfffffe50 to address 0x1f0984 */
	0x0f84c601, 0xfffff690, 	/* write 0xfffff690 to address 0x1f098c */
	0x0f84ce01, 0xffff4910, 	/* write 0xffff4910 to address 0x1f099c */
	0x0f84d201, 0xfffff810, 	/* write 0xfffff810 to address 0x1f09a4 */
	0x0f84d601, 0xffffff10, 	/* write 0xffffff10 to address 0x1f09ac */
	0x0f84da01, 0xfffff690, 	/* write 0xfffff690 to address 0x1f09b4 */
	0x0f84e001, 0x0000304a, 	/* write 0x304a to address 0x1f09c0 */
	0x0f88e201, 0x00000004, 	/* write 0x4 to address 0x1f11c4 */
	0x0f80b231, 0x19f90001, 	/* write runtime array of size 1 from offset 6649 to address 0x1f0164 */
	0x0f800410, 0x00000001, 	/* wait until address 0x1f0008 reads 0x1 */
	0x000a0013, 0xffff0002, 	/* if phase != 'pf', skip 10 ops  */
	0x0f80b431, 0x19fa0004, 	/* write runtime array of size 4 from offset 6650 to address 0x1f0168 */
	0x0f80c801, 0x00000001, 	/* write 0x1 to address 0x1f0190 */
	0x0f820031, 0x19fe0001, 	/* write runtime array of size 1 from offset 6654 to address 0x1f0400 */
	0x0f820201, 0x00000000, 	/* write 0x0 to address 0x1f0404 */
	0x0f820431, 0x19ff0002, 	/* write runtime array of size 2 from offset 6655 to address 0x1f0408 */
	0x0f821631, 0x1a010006, 	/* write runtime array of size 6 from offset 6657 to address 0x1f042c */
	0x0f84b431, 0x1a080001, 	/* write runtime array of size 1 from offset 6664 to address 0x1f0968 */
	0x0f84b601, 0x00000000, 	/* write 0x0 to address 0x1f096c */
	0x0f84fe01, 0x00000000, 	/* write 0x0 to address 0x1f09fc */
	0x0f88de01, 0x00000000, 	/* write 0x0 to address 0x1f11bc */
	0x00010013, 0x00000002, 	/* if phase != 'pf0', skip 1 ops  */
	0x0f84a401, 0xff000000, 	/* write 0xff000000 to address 0x1f0948 */
	0x00010013, 0x00010002, 	/* if phase != 'pf1', skip 1 ops  */
	0x0f84a401, 0xff100000, 	/* write 0xff100000 to address 0x1f0948 */
	0x00010013, 0x00020002, 	/* if phase != 'pf2', skip 1 ops  */
	0x0f84a401, 0xff200000, 	/* write 0xff200000 to address 0x1f0948 */
	0x00010013, 0x00030002, 	/* if phase != 'pf3', skip 1 ops  */
	0x0f84a401, 0xff300000, 	/* write 0xff300000 to address 0x1f0948 */
	0x00010013, 0x00040002, 	/* if phase != 'pf4', skip 1 ops  */
	0x0f84a401, 0xff400000, 	/* write 0xff400000 to address 0x1f0948 */
	0x00010013, 0x00050002, 	/* if phase != 'pf5', skip 1 ops  */
	0x0f84a401, 0xff500000, 	/* write 0xff500000 to address 0x1f0948 */
	0x00010013, 0x00060002, 	/* if phase != 'pf6', skip 1 ops  */
	0x0f84a401, 0xff600000, 	/* write 0xff600000 to address 0x1f0948 */
	0x00010013, 0x00070002, 	/* if phase != 'pf7', skip 1 ops  */
	0x0f84a401, 0xff700000, 	/* write 0xff700000 to address 0x1f0948 */
	0x00020013, 0x00080002, 	/* if phase != 'pf8', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xff800000, 	/* write 0xff800000 to address 0x1f0948 */
	0x00020013, 0x00090002, 	/* if phase != 'pf9', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xff900000, 	/* write 0xff900000 to address 0x1f0948 */
	0x00020013, 0x000a0002, 	/* if phase != 'pf10', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xffa00000, 	/* write 0xffa00000 to address 0x1f0948 */
	0x00020013, 0x000b0002, 	/* if phase != 'pf11', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xffb00000, 	/* write 0xffb00000 to address 0x1f0948 */
	0x00020013, 0x000c0002, 	/* if phase != 'pf12', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xffc00000, 	/* write 0xffc00000 to address 0x1f0948 */
	0x00020013, 0x000d0002, 	/* if phase != 'pf13', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xffd00000, 	/* write 0xffd00000 to address 0x1f0948 */
	0x00020013, 0x000e0002, 	/* if phase != 'pf14', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xffe00000, 	/* write 0xffe00000 to address 0x1f0948 */
	0x00020013, 0x000f0002, 	/* if phase != 'pf15', skip 2 ops  */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0f84a401, 0xfff00000, 	/* write 0xfff00000 to address 0x1f0948 */
	0x00110013, 0xffff0001, 	/* if phase != 'port', skip 17 ops  */
	0x0f839801, 0x00000000, 	/* write 0x0 to address 0x1f0730 */
	0x0f839c01, 0x000012b5, 	/* write 0x12b5 to address 0x1f0738 */
	0x0f83c201, 0x00000080, 	/* write 0x80 to address 0x1f0784 */
	0x0f83ce21, 0x00000270, 	/* write array of size 3 from offset 624 to address 0x1f079c */
	0x0f83dc01, 0x00000000, 	/* write 0x0 to address 0x1f07b8 */
	0x0f843601, 0x000017c1, 	/* write 0x17c1 to address 0x1f086c */
	0x0f843a21, 0x00000274, 	/* write array of size 2 from offset 628 to address 0x1f0874 */
	0x00020002, 0x002e0000, 	/* if mode != 'mf_sd', skip 2 ops */
	0x0f83be21, 0x00000277, 	/* write array of size 2 from offset 631 to address 0x1f077c */
	0x0f83cc01, 0x00000001, 	/* write 0x1 to address 0x1f0798 */
	0x00010002, 0x00d40000, 	/* if mode != 'mf_si', skip 1 ops */
	0x0f851001, 0x00000001, 	/* write 0x1 to address 0x1f0a20 */
	0x00020002, 0x00d20000, 	/* if mode != 'sf|mf_si', skip 2 ops */
	0x0f83be21, 0x0000027a, 	/* write array of size 2 from offset 634 to address 0x1f077c */
	0x0f83cc01, 0x00000000, 	/* write 0x0 to address 0x1f0798 */
	0x00010002, 0x00d80000, 	/* if mode != '!mf_si', skip 1 ops */
	0x0f851001, 0x00000003, 	/* write 0x3 to address 0x1f0a20 */
	/* TSDM */
	0x00070013, 0xffff0000, 	/* if phase != 'engine', skip 7 ops  */
	0x7d802201, 0x00000000, 	/* write 0x0 to address 0xfb0044 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0x7d820001, 0x00000018, 	/* write 0x18 to address 0xfb0400 */
	0x7d840001, 0x0000030c, 	/* write 0x30c to address 0xfb0800 */
	0x7d840c01, 0x00000305, 	/* write 0x305 to address 0xfb0818 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x7d810201, 0x00000000, 	/* write 0x0 to address 0xfb0204 */
	/* MSDM */
	0x00060013, 0xffff0000, 	/* if phase != 'engine', skip 6 ops  */
	0x7e002201, 0x00000000, 	/* write 0x0 to address 0xfc0044 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x7e020001, 0x00000018, 	/* write 0x18 to address 0xfc0400 */
	0x7e041021, 0x0000027d, 	/* write array of size 2 from offset 637 to address 0xfc0820 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x7e010201, 0x00000000, 	/* write 0x0 to address 0xfc0204 */
	/* USDM */
	0x00070013, 0xffff0000, 	/* if phase != 'engine', skip 7 ops  */
	0x7e802201, 0x00000000, 	/* write 0x0 to address 0xfd0044 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0x7e820001, 0x00000018, 	/* write 0x18 to address 0xfd0400 */
	0x7e840401, 0x00000305, 	/* write 0x305 to address 0xfd0808 */
	0x7e840c21, 0x00000280, 	/* write array of size 2 from offset 640 to address 0xfd0818 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x7e810201, 0x00000000, 	/* write 0x0 to address 0xfd0204 */
	/* XSDM */
	0x00070013, 0xffff0000, 	/* if phase != 'engine', skip 7 ops  */
	0x7c002201, 0x00000000, 	/* write 0x0 to address 0xf80044 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0x7c020001, 0x00000018, 	/* write 0x18 to address 0xf80400 */
	0x7c040021, 0x00000283, 	/* write array of size 3 from offset 643 to address 0xf80800 */
	0x7c041c01, 0x00000309, 	/* write 0x309 to address 0xf80838 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x7c010201, 0x00000000, 	/* write 0x0 to address 0xf80204 */
	/* YSDM */
	0x00060013, 0xffff0000, 	/* if phase != 'engine', skip 6 ops  */
	0x7c802201, 0x00000000, 	/* write 0x0 to address 0xf90044 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x7c820001, 0x00000018, 	/* write 0x18 to address 0xf90400 */
	0x7c840821, 0x00000287, 	/* write array of size 5 from offset 647 to address 0xf90810 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x7c810201, 0x00000000, 	/* write 0x0 to address 0xf90204 */
	/* PSDM */
	0x00060013, 0xffff0000, 	/* if phase != 'engine', skip 6 ops  */
	0x7d002201, 0x00000000, 	/* write 0x0 to address 0xfa0044 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x7d020001, 0x00000018, 	/* write 0x18 to address 0xfa0400 */
	0x7d040801, 0x00000305, 	/* write 0x305 to address 0xfa0810 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x7d010201, 0x00000000, 	/* write 0x0 to address 0xfa0204 */
	/* TSEM */
	0x005d0013, 0xffff0000, 	/* if phase != 'engine', skip 93 ops  */
	0xb8002a01, 0x00000000, 	/* write 0x0 to address 0x1700054 */
	0xb8006601, 0x00000000, 	/* write 0x0 to address 0x17000cc */
	0xba002201, 0x00000000, 	/* write 0x0 to address 0x1740044 */
	0xba032c01, 0x00000001, 	/* write 0x1 to address 0x1740658 */
	0xba03a421, 0x0000028d, 	/* write array of size 3 from offset 653 to address 0x1740748 */
	0xba052401, 0x00001fff, 	/* write 0x1fff to address 0x1740a48 */
	0xba501e01, 0x00000007, 	/* write 0x7 to address 0x174a03c */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0xba010201, 0x00000000, 	/* write 0x0 to address 0x1740204 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xb8002201, 0x00000000, 	/* write 0x0 to address 0x1700044 */
	0xb9000111, 0x000010e0, 	/* write 4320 zeros to address 0x1720000 (WB) */
	0xba025001, 0x00000007, 	/* write 0x7 to address 0x17404a0 */
	0xbb000011, 0x00005000, 	/* write 20480 zeros to address 0x1760000 */
	0x00020002, 0x00240000, 	/* if mode != '!e5', skip 2 ops */
	0xb8010201, 0x00000000, 	/* write 0x0 to address 0x1700204 */
	0xba510201, 0x00000000, 	/* write 0x0 to address 0x174a204 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xba025c01, 0x00000000, 	/* write 0x0 to address 0x17404b8 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xba025c01, 0x00000002, 	/* write 0x2 to address 0x17404b8 */
	0x000b0002, 0x00010000, 	/* if mode != 'bb|k2', skip 11 ops */
	0xbb050021, 0x00000291, 	/* write array of size 6 from offset 657 to address 0x1760a00 */
	0xbb5f8021, 0x00000298, 	/* write array of size 2 from offset 664 to address 0x176bf00 */
	0xbb5f8c21, 0x0000029b, 	/* write array of size 1022 from offset 667 to address 0x176bf18 */
	0xbb6ed421, 0x0000069a, 	/* write array of size 1 from offset 1690 to address 0x176dda8 */
	0xbb6ed611, 0x00000019, 	/* write 25 zeros to address 0x176ddac */
	0xbb738021, 0x0000069c, 	/* write array of size 65 from offset 1692 to address 0x176e700 */
	0xbb740221, 0x000006de, 	/* write array of size 6 from offset 1758 to address 0x176e804 */
	0xbb740e21, 0x000006e0, 	/* write array of size 9 from offset 1760 to address 0x176e81c */
	0xbb85c821, 0x000006ea, 	/* write array of size 4 from offset 1770 to address 0x1770b90 */
	0xbb9f1021, 0x000006ef, 	/* write array of size 26 from offset 1775 to address 0x1773e20 */
	0xbb9ffc21, 0x0000070a, 	/* write array of size 2 from offset 1802 to address 0x1773ff8 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0xbb25c801, 0x00000002, 	/* write 0x2 to address 0x1764b90 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xbb25ca01, 0x00000000, 	/* write 0x0 to address 0x1764b94 */
	0x00010002, 0x006d0000, 	/* if mode != 'ports_per_eng_2&(bb|k2)', skip 1 ops */
	0xbb25ca01, 0x00000001, 	/* write 0x1 to address 0x1764b94 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xbb25ca01, 0x00000002, 	/* write 0x2 to address 0x1764b94 */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0xbb25c601, 0x00000003, 	/* write 0x3 to address 0x1764b8c */
	0x00010002, 0x00860000, 	/* if mode != 'bb&(bb|k2)', skip 1 ops */
	0xbb25c601, 0x00000002, 	/* write 0x2 to address 0x1764b8c */
	0x00010002, 0x00120000, 	/* if mode != '(bb|k2)&(asic|chipsim|emul_full)', skip 1 ops */
	0xbb25c801, 0x00000003, 	/* write 0x3 to address 0x1764b90 */
	0xba032e10, 0x00000000, 	/* wait until address 0x174065c reads 0x0 */
	0xba501e10, 0x00000007, 	/* wait until address 0x174a03c reads 0x7 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0xba500021, 0x0000070d, 	/* write array of size 2 from offset 1805 to address 0x174a000 */
	0xba500601, 0xc000ffff, 	/* write 0xc000ffff to address 0x174a00c */
	0xba502001, 0x00000001, 	/* write 0x1 to address 0x174a040 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0xb8022401, 0x000020f6, 	/* write 0x20f6 to address 0x1700448 */
	0xb8028121, 0x00000710, 	/* write array of size 14 from offset 1808 to address 0x1700500 (WB) */
	0xb8800021, 0x0000071f, 	/* write array of size 256 from offset 1823 to address 0x1710000 */
	0x00090002, 0x005c0000, 	/* if mode != '(bb|k2)&(!chipsim)', skip 9 ops */
	0xbc000121, 0x00000721, 	/* write array of size 8192 from offset 1825 to address 0x1780000 (WB) */
	0xbc400121, 0x000015fd, 	/* write array of size 8192 from offset 5629 to address 0x1788000 (WB) */
	0xbc800121, 0x000024bc, 	/* write array of size 8192 from offset 9404 to address 0x1790000 (WB) */
	0xbcc00121, 0x000031fc, 	/* write array of size 8192 from offset 12796 to address 0x1798000 (WB) */
	0xbd000121, 0x0000403a, 	/* write array of size 8192 from offset 16442 to address 0x17a0000 (WB) */
	0xbd400121, 0x00004ddf, 	/* write array of size 8192 from offset 19935 to address 0x17a8000 (WB) */
	0xbd800121, 0x0000590e, 	/* write array of size 8192 from offset 22798 to address 0x17b0000 (WB) */
	0xbdc00121, 0x000066b4, 	/* write array of size 8184 from offset 26292 to address 0x17b8000 (WB) */
	0xbdfff121, 0x00007477, 	/* write array of size 8200 from offset 29815 to address 0x17bffe0 (WB) */
	0x00180002, 0x00010000, 	/* if mode != 'bb|k2', skip 24 ops */
	0xb8800021, 0x0000747a, 	/* write array of size 13 from offset 29818 to address 0x1710000 */
	0xb8802221, 0x00007488, 	/* write array of size 9 from offset 29832 to address 0x1710044 */
	0xb8804221, 0x00007492, 	/* write array of size 2 from offset 29842 to address 0x1710084 */
	0xb8804a21, 0x00007495, 	/* write array of size 2 from offset 29845 to address 0x1710094 */
	0xb8805001, 0x00128671, 	/* write 0x128671 to address 0x17100a0 */
	0xb8807a01, 0x0004842e, 	/* write 0x4842e to address 0x17100f4 */
	0xb8808201, 0x00060043, 	/* write 0x60043 to address 0x1710104 */
	0xb8808821, 0x00007498, 	/* write array of size 2 from offset 29848 to address 0x1710110 */
	0xb8809021, 0x0000749b, 	/* write array of size 2 from offset 29851 to address 0x1710120 */
	0xb8809a01, 0x0006001e, 	/* write 0x6001e to address 0x1710134 */
	0xb880a201, 0x00060618, 	/* write 0x60618 to address 0x1710144 */
	0xb880aa01, 0x000607a5, 	/* write 0x607a5 to address 0x1710154 */
	0xb880ba01, 0x00060074, 	/* write 0x60074 to address 0x1710174 */
	0xb880c201, 0x00080ed4, 	/* write 0x80ed4 to address 0x1710184 */
	0xb880c821, 0x0000749e, 	/* write array of size 2 from offset 29854 to address 0x1710190 */
	0xb880d001, 0x001e0c35, 	/* write 0x1e0c35 to address 0x17101a0 */
	0xb8810221, 0x000074a1, 	/* write array of size 2 from offset 29857 to address 0x1710204 */
	0xb8811221, 0x000074a4, 	/* write array of size 2 from offset 29860 to address 0x1710224 */
	0xb8814201, 0x0012800e, 	/* write 0x12800e to address 0x1710284 */
	0xb8818221, 0x000074a7, 	/* write array of size 6 from offset 29863 to address 0x1710304 */
	0xb8819221, 0x000074ae, 	/* write array of size 2 from offset 29870 to address 0x1710324 */
	0xb8819a21, 0x000074b1, 	/* write array of size 2 from offset 29873 to address 0x1710334 */
	0xb881a201, 0x000c679b, 	/* write 0xc679b to address 0x1710344 */
	0xb881aa01, 0x000c79bc, 	/* write 0xc79bc to address 0x1710354 */
	0xba502411, 0x00000002, 	/* write 2 zeros to address 0x174a048 */
	0x00050013, 0x00000002, 	/* if phase != 'pf0', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb224411, 0x00000002, 	/* write 2 zeros to address 0x1764488 */
	0xbb228411, 0x00000002, 	/* write 2 zeros to address 0x1764508 */
	0xbb2e9001, 0x00000000, 	/* write 0x0 to address 0x1765d20 */
	0xbb788821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f110 */
	0x00050013, 0x00010002, 	/* if phase != 'pf1', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb224811, 0x00000002, 	/* write 2 zeros to address 0x1764490 */
	0xbb228811, 0x00000002, 	/* write 2 zeros to address 0x1764510 */
	0xbb2e9201, 0x00000000, 	/* write 0x0 to address 0x1765d24 */
	0xbb788c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f118 */
	0x00050013, 0x00020002, 	/* if phase != 'pf2', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb224c11, 0x00000002, 	/* write 2 zeros to address 0x1764498 */
	0xbb228c11, 0x00000002, 	/* write 2 zeros to address 0x1764518 */
	0xbb2e9401, 0x00000000, 	/* write 0x0 to address 0x1765d28 */
	0xbb789021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f120 */
	0x00050013, 0x00030002, 	/* if phase != 'pf3', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb225011, 0x00000002, 	/* write 2 zeros to address 0x17644a0 */
	0xbb229011, 0x00000002, 	/* write 2 zeros to address 0x1764520 */
	0xbb2e9601, 0x00000000, 	/* write 0x0 to address 0x1765d2c */
	0xbb789421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f128 */
	0x00050013, 0x00040002, 	/* if phase != 'pf4', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb225411, 0x00000002, 	/* write 2 zeros to address 0x17644a8 */
	0xbb229411, 0x00000002, 	/* write 2 zeros to address 0x1764528 */
	0xbb2e9801, 0x00000000, 	/* write 0x0 to address 0x1765d30 */
	0xbb789821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f130 */
	0x00050013, 0x00050002, 	/* if phase != 'pf5', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb225811, 0x00000002, 	/* write 2 zeros to address 0x17644b0 */
	0xbb229811, 0x00000002, 	/* write 2 zeros to address 0x1764530 */
	0xbb2e9a01, 0x00000000, 	/* write 0x0 to address 0x1765d34 */
	0xbb789c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f138 */
	0x00050013, 0x00060002, 	/* if phase != 'pf6', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb225c11, 0x00000002, 	/* write 2 zeros to address 0x17644b8 */
	0xbb229c11, 0x00000002, 	/* write 2 zeros to address 0x1764538 */
	0xbb2e9c01, 0x00000000, 	/* write 0x0 to address 0x1765d38 */
	0xbb78a021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f140 */
	0x00050013, 0x00070002, 	/* if phase != 'pf7', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb226011, 0x00000002, 	/* write 2 zeros to address 0x17644c0 */
	0xbb22a011, 0x00000002, 	/* write 2 zeros to address 0x1764540 */
	0xbb2e9e01, 0x00000000, 	/* write 0x0 to address 0x1765d3c */
	0xbb78a421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f148 */
	0x00050013, 0x00080002, 	/* if phase != 'pf8', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb226411, 0x00000002, 	/* write 2 zeros to address 0x17644c8 */
	0xbb22a411, 0x00000002, 	/* write 2 zeros to address 0x1764548 */
	0xbb2ea001, 0x00000000, 	/* write 0x0 to address 0x1765d40 */
	0xbb78a821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f150 */
	0x00050013, 0x00090002, 	/* if phase != 'pf9', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb226811, 0x00000002, 	/* write 2 zeros to address 0x17644d0 */
	0xbb22a811, 0x00000002, 	/* write 2 zeros to address 0x1764550 */
	0xbb2ea201, 0x00000000, 	/* write 0x0 to address 0x1765d44 */
	0xbb78ac21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f158 */
	0x00050013, 0x000a0002, 	/* if phase != 'pf10', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb226c11, 0x00000002, 	/* write 2 zeros to address 0x17644d8 */
	0xbb22ac11, 0x00000002, 	/* write 2 zeros to address 0x1764558 */
	0xbb2ea401, 0x00000000, 	/* write 0x0 to address 0x1765d48 */
	0xbb78b021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f160 */
	0x00050013, 0x000b0002, 	/* if phase != 'pf11', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb227011, 0x00000002, 	/* write 2 zeros to address 0x17644e0 */
	0xbb22b011, 0x00000002, 	/* write 2 zeros to address 0x1764560 */
	0xbb2ea601, 0x00000000, 	/* write 0x0 to address 0x1765d4c */
	0xbb78b421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f168 */
	0x00050013, 0x000c0002, 	/* if phase != 'pf12', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb227411, 0x00000002, 	/* write 2 zeros to address 0x17644e8 */
	0xbb22b411, 0x00000002, 	/* write 2 zeros to address 0x1764568 */
	0xbb2ea801, 0x00000000, 	/* write 0x0 to address 0x1765d50 */
	0xbb78b821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f170 */
	0x00050013, 0x000d0002, 	/* if phase != 'pf13', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb227811, 0x00000002, 	/* write 2 zeros to address 0x17644f0 */
	0xbb22b811, 0x00000002, 	/* write 2 zeros to address 0x1764570 */
	0xbb2eaa01, 0x00000000, 	/* write 0x0 to address 0x1765d54 */
	0xbb78bc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f178 */
	0x00050013, 0x000e0002, 	/* if phase != 'pf14', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb227c11, 0x00000002, 	/* write 2 zeros to address 0x17644f8 */
	0xbb22bc11, 0x00000002, 	/* write 2 zeros to address 0x1764578 */
	0xbb2eac01, 0x00000000, 	/* write 0x0 to address 0x1765d58 */
	0xbb78c021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f180 */
	0x00050013, 0x000f0002, 	/* if phase != 'pf15', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xbb228011, 0x00000002, 	/* write 2 zeros to address 0x1764500 */
	0xbb22c011, 0x00000002, 	/* write 2 zeros to address 0x1764580 */
	0xbb2eae01, 0x00000000, 	/* write 0x0 to address 0x1765d5c */
	0xbb78c421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x176f188 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0xb8020601, 0x00000001, 	/* write 0x1 to address 0x170040c */
	0x00060013, 0x00000001, 	/* if phase != 'port0', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xbb25cc11, 0x00000002, 	/* write 2 zeros to address 0x1764b98 */
	0xbb265811, 0x00000020, 	/* write 32 zeros to address 0x1764cb0 */
	0xbb5a4411, 0x00000002, 	/* write 2 zeros to address 0x176b488 */
	0xbb5a5411, 0x00000002, 	/* write 2 zeros to address 0x176b4a8 */
	0xbb5a6411, 0x00000002, 	/* write 2 zeros to address 0x176b4c8 */
	0x00060013, 0x00010001, 	/* if phase != 'port1', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xbb25d011, 0x00000002, 	/* write 2 zeros to address 0x1764ba0 */
	0xbb269811, 0x00000020, 	/* write 32 zeros to address 0x1764d30 */
	0xbb5a4811, 0x00000002, 	/* write 2 zeros to address 0x176b490 */
	0xbb5a5811, 0x00000002, 	/* write 2 zeros to address 0x176b4b0 */
	0xbb5a6811, 0x00000002, 	/* write 2 zeros to address 0x176b4d0 */
	0x00060013, 0x00020001, 	/* if phase != 'port2', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xbb25d411, 0x00000002, 	/* write 2 zeros to address 0x1764ba8 */
	0xbb26d811, 0x00000020, 	/* write 32 zeros to address 0x1764db0 */
	0xbb5a4c11, 0x00000002, 	/* write 2 zeros to address 0x176b498 */
	0xbb5a5c11, 0x00000002, 	/* write 2 zeros to address 0x176b4b8 */
	0xbb5a6c11, 0x00000002, 	/* write 2 zeros to address 0x176b4d8 */
	0x00060013, 0x00030001, 	/* if phase != 'port3', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xbb25d811, 0x00000002, 	/* write 2 zeros to address 0x1764bb0 */
	0xbb271811, 0x00000020, 	/* write 32 zeros to address 0x1764e30 */
	0xbb5a5011, 0x00000002, 	/* write 2 zeros to address 0x176b4a0 */
	0xbb5a6011, 0x00000002, 	/* write 2 zeros to address 0x176b4c0 */
	0xbb5a7011, 0x00000002, 	/* write 2 zeros to address 0x176b4e0 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0xb8020401, 0x00000001, 	/* write 0x1 to address 0x1700408 */
	/* MSEM */
	0x004e0013, 0xffff0000, 	/* if phase != 'engine', skip 78 ops  */
	0xc0002a01, 0x00000000, 	/* write 0x0 to address 0x1800054 */
	0xc0006601, 0x00000000, 	/* write 0x0 to address 0x18000cc */
	0xc2002201, 0x00000000, 	/* write 0x0 to address 0x1840044 */
	0xc2032c01, 0x00000001, 	/* write 0x1 to address 0x1840658 */
	0xc203a421, 0x0000028d, 	/* write array of size 3 from offset 653 to address 0x1840748 */
	0xc2052401, 0x00001fff, 	/* write 0x1fff to address 0x1840a48 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0xc0036001, 0x00000000, 	/* write 0x0 to address 0x18006c0 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0xc2010201, 0x00000000, 	/* write 0x0 to address 0x1840204 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xc0002201, 0x00000000, 	/* write 0x0 to address 0x1800044 */
	0xc1000111, 0x000010e0, 	/* write 4320 zeros to address 0x1820000 (WB) */
	0xc2025001, 0x00000007, 	/* write 0x7 to address 0x18404a0 */
	0xc3000011, 0x00005000, 	/* write 20480 zeros to address 0x1860000 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0xc0010201, 0x00000000, 	/* write 0x0 to address 0x1800204 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xc2025c01, 0x00000000, 	/* write 0x0 to address 0x18404b8 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xc2025c01, 0x00000002, 	/* write 0x2 to address 0x18404b8 */
	0x000a0002, 0x00010000, 	/* if mode != 'bb|k2', skip 10 ops */
	0xc3000021, 0x000074b7, 	/* write array of size 6 from offset 29879 to address 0x1860000 */
	0xc324c821, 0x000074be, 	/* write array of size 7 from offset 29886 to address 0x1864990 */
	0xc324d611, 0x00000017, 	/* write 23 zeros to address 0x18649ac */
	0xc363dc21, 0x000074c6, 	/* write array of size 5 from offset 29894 to address 0x186c7b8 */
	0xc363e611, 0x00000009, 	/* write 9 zeros to address 0x186c7cc */
	0xc3956021, 0x0000069a, 	/* write array of size 1 from offset 1690 to address 0x1872ac0 */
	0xc3956211, 0x00000019, 	/* write 25 zeros to address 0x1872ac4 */
	0xc3985421, 0x000074cc, 	/* write array of size 640 from offset 29900 to address 0x18730a8 */
	0xc39d6021, 0x0000774d, 	/* write array of size 320 from offset 30541 to address 0x1873ac0 */
	0xc39ffc21, 0x0000774f, 	/* write array of size 2 from offset 30543 to address 0x1873ff8 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0xc3247401, 0x00000002, 	/* write 0x2 to address 0x18648e8 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xc3247601, 0x00000000, 	/* write 0x0 to address 0x18648ec */
	0x00010002, 0x006d0000, 	/* if mode != 'ports_per_eng_2&(bb|k2)', skip 1 ops */
	0xc3247601, 0x00000001, 	/* write 0x1 to address 0x18648ec */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xc3247601, 0x00000002, 	/* write 0x2 to address 0x18648ec */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0xc3247201, 0x00000003, 	/* write 0x3 to address 0x18648e4 */
	0x00010002, 0x00860000, 	/* if mode != 'bb&(bb|k2)', skip 1 ops */
	0xc3247201, 0x00000002, 	/* write 0x2 to address 0x18648e4 */
	0x00010002, 0x00120000, 	/* if mode != '(bb|k2)&(asic|chipsim|emul_full)', skip 1 ops */
	0xc3247401, 0x00000003, 	/* write 0x3 to address 0x18648e8 */
	0xc2032e10, 0x00000000, 	/* wait until address 0x184065c reads 0x0 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xc0022401, 0x000010e4, 	/* write 0x10e4 to address 0x1800448 */
	0xc0028121, 0x00007752, 	/* write array of size 10 from offset 30546 to address 0x1800500 (WB) */
	0xc0029921, 0x0000775d, 	/* write array of size 2 from offset 30557 to address 0x1800530 (WB) */
	0xc0800021, 0x00007760, 	/* write array of size 256 from offset 30560 to address 0x1810000 */
	0x00060002, 0x005c0000, 	/* if mode != '(bb|k2)&(!chipsim)', skip 6 ops */
	0xc4000121, 0x00007762, 	/* write array of size 8192 from offset 30562 to address 0x1880000 (WB) */
	0xc4400121, 0x000085ea, 	/* write array of size 8192 from offset 34282 to address 0x1888000 (WB) */
	0xc4800121, 0x0000953f, 	/* write array of size 8192 from offset 38207 to address 0x1890000 (WB) */
	0xc4c00121, 0x0000a39a, 	/* write array of size 8192 from offset 41882 to address 0x1898000 (WB) */
	0xc5000121, 0x0000b150, 	/* write array of size 6836 from offset 45392 to address 0x18a0000 (WB) */
	0xc5356921, 0x0000bbf6, 	/* write array of size 9548 from offset 48118 to address 0x18a6ad0 (WB) */
	0x00120002, 0x00010000, 	/* if mode != 'bb|k2', skip 18 ops */
	0xc0800021, 0x0000bbf9, 	/* write array of size 9 from offset 48121 to address 0x1810000 */
	0xc0801421, 0x0000bc03, 	/* write array of size 2 from offset 48131 to address 0x1810028 */
	0xc0802221, 0x0000bc06, 	/* write array of size 5 from offset 48134 to address 0x1810044 */
	0xc0804201, 0x000250ab, 	/* write 0x250ab to address 0x1810084 */
	0xc0804a21, 0x0000bc0c, 	/* write array of size 2 from offset 48140 to address 0x1810094 */
	0xc0805021, 0x0000bc0f, 	/* write array of size 2 from offset 48143 to address 0x18100a0 */
	0xc0808201, 0x001e01f9, 	/* write 0x1e01f9 to address 0x1810104 */
	0xc0808801, 0x001e0366, 	/* write 0x1e0366 to address 0x1810110 */
	0xc0808e21, 0x0000bc12, 	/* write array of size 6 from offset 48146 to address 0x181011c */
	0xc080c421, 0x0000bc19, 	/* write array of size 11 from offset 48153 to address 0x1810188 */
	0xc0810221, 0x0000bc25, 	/* write array of size 2 from offset 48165 to address 0x1810204 */
	0xc0810a21, 0x0000bc28, 	/* write array of size 2 from offset 48168 to address 0x1810214 */
	0xc0811221, 0x0000bc2b, 	/* write array of size 2 from offset 48171 to address 0x1810224 */
	0xc0814201, 0x001e4ecc, 	/* write 0x1e4ecc to address 0x1810284 */
	0xc0814a21, 0x0000bc2e, 	/* write array of size 2 from offset 48174 to address 0x1810294 */
	0xc0818421, 0x0000bc31, 	/* write array of size 7 from offset 48177 to address 0x1810308 */
	0xc0819421, 0x0000bc39, 	/* write array of size 5 from offset 48185 to address 0x1810328 */
	0xc081a021, 0x0000bc3f, 	/* write array of size 2 from offset 48191 to address 0x1810340 */
	0x00060013, 0x00000002, 	/* if phase != 'pf0', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc320f011, 0x00000002, 	/* write 2 zeros to address 0x18641e0 */
	0xc3213011, 0x00000002, 	/* write 2 zeros to address 0x1864260 */
	0xc359b001, 0x00000000, 	/* write 0x0 to address 0x186b360 */
	0xc38ab821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871570 */
	0xc3981421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873028 */
	0x00060013, 0x00010002, 	/* if phase != 'pf1', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc320f411, 0x00000002, 	/* write 2 zeros to address 0x18641e8 */
	0xc3213411, 0x00000002, 	/* write 2 zeros to address 0x1864268 */
	0xc359b201, 0x00000000, 	/* write 0x0 to address 0x186b364 */
	0xc38ac021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871580 */
	0xc3981821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873030 */
	0x00060013, 0x00020002, 	/* if phase != 'pf2', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc320f811, 0x00000002, 	/* write 2 zeros to address 0x18641f0 */
	0xc3213811, 0x00000002, 	/* write 2 zeros to address 0x1864270 */
	0xc359b401, 0x00000000, 	/* write 0x0 to address 0x186b368 */
	0xc38ac821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871590 */
	0xc3981c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873038 */
	0x00060013, 0x00030002, 	/* if phase != 'pf3', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc320fc11, 0x00000002, 	/* write 2 zeros to address 0x18641f8 */
	0xc3213c11, 0x00000002, 	/* write 2 zeros to address 0x1864278 */
	0xc359b601, 0x00000000, 	/* write 0x0 to address 0x186b36c */
	0xc38ad021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x18715a0 */
	0xc3982021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873040 */
	0x00060013, 0x00040002, 	/* if phase != 'pf4', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3210011, 0x00000002, 	/* write 2 zeros to address 0x1864200 */
	0xc3214011, 0x00000002, 	/* write 2 zeros to address 0x1864280 */
	0xc359b801, 0x00000000, 	/* write 0x0 to address 0x186b370 */
	0xc38ad821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x18715b0 */
	0xc3982421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873048 */
	0x00060013, 0x00050002, 	/* if phase != 'pf5', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3210411, 0x00000002, 	/* write 2 zeros to address 0x1864208 */
	0xc3214411, 0x00000002, 	/* write 2 zeros to address 0x1864288 */
	0xc359ba01, 0x00000000, 	/* write 0x0 to address 0x186b374 */
	0xc38ae021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x18715c0 */
	0xc3982821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873050 */
	0x00060013, 0x00060002, 	/* if phase != 'pf6', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3210811, 0x00000002, 	/* write 2 zeros to address 0x1864210 */
	0xc3214811, 0x00000002, 	/* write 2 zeros to address 0x1864290 */
	0xc359bc01, 0x00000000, 	/* write 0x0 to address 0x186b378 */
	0xc38ae821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x18715d0 */
	0xc3982c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873058 */
	0x00060013, 0x00070002, 	/* if phase != 'pf7', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3210c11, 0x00000002, 	/* write 2 zeros to address 0x1864218 */
	0xc3214c11, 0x00000002, 	/* write 2 zeros to address 0x1864298 */
	0xc359be01, 0x00000000, 	/* write 0x0 to address 0x186b37c */
	0xc38af021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x18715e0 */
	0xc3983021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873060 */
	0x00060013, 0x00080002, 	/* if phase != 'pf8', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3211011, 0x00000002, 	/* write 2 zeros to address 0x1864220 */
	0xc3215011, 0x00000002, 	/* write 2 zeros to address 0x18642a0 */
	0xc359c001, 0x00000000, 	/* write 0x0 to address 0x186b380 */
	0xc38af821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x18715f0 */
	0xc3983421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873068 */
	0x00060013, 0x00090002, 	/* if phase != 'pf9', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3211411, 0x00000002, 	/* write 2 zeros to address 0x1864228 */
	0xc3215411, 0x00000002, 	/* write 2 zeros to address 0x18642a8 */
	0xc359c201, 0x00000000, 	/* write 0x0 to address 0x186b384 */
	0xc38b0021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871600 */
	0xc3983821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873070 */
	0x00060013, 0x000a0002, 	/* if phase != 'pf10', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3211811, 0x00000002, 	/* write 2 zeros to address 0x1864230 */
	0xc3215811, 0x00000002, 	/* write 2 zeros to address 0x18642b0 */
	0xc359c401, 0x00000000, 	/* write 0x0 to address 0x186b388 */
	0xc38b0821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871610 */
	0xc3983c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873078 */
	0x00060013, 0x000b0002, 	/* if phase != 'pf11', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3211c11, 0x00000002, 	/* write 2 zeros to address 0x1864238 */
	0xc3215c11, 0x00000002, 	/* write 2 zeros to address 0x18642b8 */
	0xc359c601, 0x00000000, 	/* write 0x0 to address 0x186b38c */
	0xc38b1021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871620 */
	0xc3984021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873080 */
	0x00060013, 0x000c0002, 	/* if phase != 'pf12', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3212011, 0x00000002, 	/* write 2 zeros to address 0x1864240 */
	0xc3216011, 0x00000002, 	/* write 2 zeros to address 0x18642c0 */
	0xc359c801, 0x00000000, 	/* write 0x0 to address 0x186b390 */
	0xc38b1821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871630 */
	0xc3984421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873088 */
	0x00060013, 0x000d0002, 	/* if phase != 'pf13', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3212411, 0x00000002, 	/* write 2 zeros to address 0x1864248 */
	0xc3216411, 0x00000002, 	/* write 2 zeros to address 0x18642c8 */
	0xc359ca01, 0x00000000, 	/* write 0x0 to address 0x186b394 */
	0xc38b2021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871640 */
	0xc3984821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873090 */
	0x00060013, 0x000e0002, 	/* if phase != 'pf14', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3212811, 0x00000002, 	/* write 2 zeros to address 0x1864250 */
	0xc3216811, 0x00000002, 	/* write 2 zeros to address 0x18642d0 */
	0xc359cc01, 0x00000000, 	/* write 0x0 to address 0x186b398 */
	0xc38b2821, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871650 */
	0xc3984c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1873098 */
	0x00060013, 0x000f0002, 	/* if phase != 'pf15', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xc3212c11, 0x00000002, 	/* write 2 zeros to address 0x1864258 */
	0xc3216c11, 0x00000002, 	/* write 2 zeros to address 0x18642d8 */
	0xc359ce01, 0x00000000, 	/* write 0x0 to address 0x186b39c */
	0xc38b3021, 0x0000bc42, 	/* write array of size 4 from offset 48194 to address 0x1871660 */
	0xc3985021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x18730a0 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0xc0020601, 0x00000001, 	/* write 0x1 to address 0x180040c */
	0x00020013, 0x00000001, 	/* if phase != 'port0', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xc3247811, 0x00000002, 	/* write 2 zeros to address 0x18648f0 */
	0x00020013, 0x00010001, 	/* if phase != 'port1', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xc3247c11, 0x00000002, 	/* write 2 zeros to address 0x18648f8 */
	0x00020013, 0x00020001, 	/* if phase != 'port2', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xc3248011, 0x00000002, 	/* write 2 zeros to address 0x1864900 */
	0x00020013, 0x00030001, 	/* if phase != 'port3', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xc3248411, 0x00000002, 	/* write 2 zeros to address 0x1864908 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0xc0020401, 0x00000001, 	/* write 0x1 to address 0x1800408 */
	/* USEM */
	0x00440013, 0xffff0000, 	/* if phase != 'engine', skip 68 ops  */
	0xc8002a01, 0x00000000, 	/* write 0x0 to address 0x1900054 */
	0xc8006601, 0x00000000, 	/* write 0x0 to address 0x19000cc */
	0xca002201, 0x00000000, 	/* write 0x0 to address 0x1940044 */
	0xca032c01, 0x00000001, 	/* write 0x1 to address 0x1940658 */
	0xca03a421, 0x0000028d, 	/* write array of size 3 from offset 653 to address 0x1940748 */
	0xca052401, 0x00001fff, 	/* write 0x1fff to address 0x1940a48 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0xca010201, 0x00000000, 	/* write 0x0 to address 0x1940204 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xc8002201, 0x00000000, 	/* write 0x0 to address 0x1900044 */
	0xc9000111, 0x00000b40, 	/* write 2880 zeros to address 0x1920000 (WB) */
	0xca025001, 0x00000007, 	/* write 0x7 to address 0x19404a0 */
	0xcb000011, 0x00005000, 	/* write 20480 zeros to address 0x1960000 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0xc8010201, 0x00000000, 	/* write 0x0 to address 0x1900204 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xca025c01, 0x00000000, 	/* write 0x0 to address 0x19404b8 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xca025c01, 0x00000002, 	/* write 0x2 to address 0x19404b8 */
	0x00070002, 0x00010000, 	/* if mode != 'bb|k2', skip 7 ops */
	0xcb088021, 0x0000bc47, 	/* write array of size 6 from offset 48199 to address 0x1961100 */
	0xcb3fa421, 0x000074be, 	/* write array of size 7 from offset 29886 to address 0x1967f48 */
	0xcb3fb211, 0x00000017, 	/* write 23 zeros to address 0x1967f64 */
	0xcb962821, 0x0000069a, 	/* write array of size 1 from offset 1690 to address 0x1972c50 */
	0xcb962a11, 0x00000019, 	/* write 25 zeros to address 0x1972c54 */
	0xcb9a2821, 0x0000774d, 	/* write array of size 320 from offset 30541 to address 0x1973450 */
	0xcb9ffc21, 0x0000bc4e, 	/* write array of size 2 from offset 48206 to address 0x1973ff8 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0xcb3f5001, 0x00000002, 	/* write 0x2 to address 0x1967ea0 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xcb3f5201, 0x00000000, 	/* write 0x0 to address 0x1967ea4 */
	0x00010002, 0x006d0000, 	/* if mode != 'ports_per_eng_2&(bb|k2)', skip 1 ops */
	0xcb3f5201, 0x00000001, 	/* write 0x1 to address 0x1967ea4 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xcb3f5201, 0x00000002, 	/* write 0x2 to address 0x1967ea4 */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0xcb3f4e01, 0x00000003, 	/* write 0x3 to address 0x1967e9c */
	0x00010002, 0x00860000, 	/* if mode != 'bb&(bb|k2)', skip 1 ops */
	0xcb3f4e01, 0x00000002, 	/* write 0x2 to address 0x1967e9c */
	0x00010002, 0x00120000, 	/* if mode != '(bb|k2)&(asic|chipsim|emul_full)', skip 1 ops */
	0xcb3f5001, 0x00000003, 	/* write 0x3 to address 0x1967ea0 */
	0xca032e10, 0x00000000, 	/* wait until address 0x194065c reads 0x0 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xc8022401, 0x00001ca1, 	/* write 0x1ca1 to address 0x1900448 */
	0xc8028921, 0x0000bc51, 	/* write array of size 2 from offset 48209 to address 0x1900510 (WB) */
	0xc8029121, 0x0000bc54, 	/* write array of size 6 from offset 48212 to address 0x1900520 (WB) */
	0xc8800021, 0x0000bc5b, 	/* write array of size 256 from offset 48219 to address 0x1910000 */
	0x00050002, 0x005c0000, 	/* if mode != '(bb|k2)&(!chipsim)', skip 5 ops */
	0xcc000121, 0x0000bc5d, 	/* write array of size 8192 from offset 48221 to address 0x1980000 (WB) */
	0xcc400121, 0x0000ca7a, 	/* write array of size 8192 from offset 51834 to address 0x1988000 (WB) */
	0xcc800121, 0x0000d8af, 	/* write array of size 8192 from offset 55471 to address 0x1990000 (WB) */
	0xccc00121, 0x0000e753, 	/* write array of size 6744 from offset 59219 to address 0x1998000 (WB) */
	0xccf4b121, 0x0000f2bb, 	/* write array of size 17832 from offset 62139 to address 0x199e960 (WB) */
	0x000e0002, 0x00010000, 	/* if mode != 'bb|k2', skip 14 ops */
	0xc8800021, 0x0000f2be, 	/* write array of size 12 from offset 62142 to address 0x1910000 */
	0xc8802221, 0x0000f2cb, 	/* write array of size 9 from offset 62155 to address 0x1910044 */
	0xc8803601, 0x0012302c, 	/* write 0x12302c to address 0x191006c */
	0xc8804221, 0x0000f2d5, 	/* write array of size 2 from offset 62165 to address 0x1910084 */
	0xc8804a21, 0x0000f2d8, 	/* write array of size 2 from offset 62168 to address 0x1910094 */
	0xc8805021, 0x0000f2db, 	/* write array of size 3 from offset 62171 to address 0x19100a0 */
	0xc8808201, 0x001e0d8e, 	/* write 0x1e0d8e to address 0x1910104 */
	0xc8808801, 0x001e0a9b, 	/* write 0x1e0a9b to address 0x1910110 */
	0xc8809021, 0x0000f2df, 	/* write array of size 5 from offset 62175 to address 0x1910120 */
	0xc880c421, 0x0000f2e5, 	/* write array of size 7 from offset 62181 to address 0x1910188 */
	0xc8810221, 0x0000f2ed, 	/* write array of size 6 from offset 62189 to address 0x1910204 */
	0xc8811221, 0x0000f2f4, 	/* write array of size 3 from offset 62196 to address 0x1910224 */
	0xc8814221, 0x0000f2f8, 	/* write array of size 2 from offset 62200 to address 0x1910284 */
	0xc8818221, 0x0000f2fb, 	/* write array of size 5 from offset 62203 to address 0x1910304 */
	0x00060013, 0x00000002, 	/* if phase != 'pf0', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb000011, 0x00000002, 	/* write 2 zeros to address 0x1960000 */
	0xcb3bcc11, 0x00000002, 	/* write 2 zeros to address 0x1967798 */
	0xcb3c0c11, 0x00000002, 	/* write 2 zeros to address 0x1967818 */
	0xcb5aac01, 0x00000000, 	/* write 0x0 to address 0x196b558 */
	0xcb9cb021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973960 */
	0x00060013, 0x00010002, 	/* if phase != 'pf1', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb000411, 0x00000002, 	/* write 2 zeros to address 0x1960008 */
	0xcb3bd011, 0x00000002, 	/* write 2 zeros to address 0x19677a0 */
	0xcb3c1011, 0x00000002, 	/* write 2 zeros to address 0x1967820 */
	0xcb5aae01, 0x00000000, 	/* write 0x0 to address 0x196b55c */
	0xcb9cb421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973968 */
	0x00060013, 0x00020002, 	/* if phase != 'pf2', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb000811, 0x00000002, 	/* write 2 zeros to address 0x1960010 */
	0xcb3bd411, 0x00000002, 	/* write 2 zeros to address 0x19677a8 */
	0xcb3c1411, 0x00000002, 	/* write 2 zeros to address 0x1967828 */
	0xcb5ab001, 0x00000000, 	/* write 0x0 to address 0x196b560 */
	0xcb9cb821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973970 */
	0x00060013, 0x00030002, 	/* if phase != 'pf3', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb000c11, 0x00000002, 	/* write 2 zeros to address 0x1960018 */
	0xcb3bd811, 0x00000002, 	/* write 2 zeros to address 0x19677b0 */
	0xcb3c1811, 0x00000002, 	/* write 2 zeros to address 0x1967830 */
	0xcb5ab201, 0x00000000, 	/* write 0x0 to address 0x196b564 */
	0xcb9cbc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973978 */
	0x00060013, 0x00040002, 	/* if phase != 'pf4', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb001011, 0x00000002, 	/* write 2 zeros to address 0x1960020 */
	0xcb3bdc11, 0x00000002, 	/* write 2 zeros to address 0x19677b8 */
	0xcb3c1c11, 0x00000002, 	/* write 2 zeros to address 0x1967838 */
	0xcb5ab401, 0x00000000, 	/* write 0x0 to address 0x196b568 */
	0xcb9cc021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973980 */
	0x00060013, 0x00050002, 	/* if phase != 'pf5', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb001411, 0x00000002, 	/* write 2 zeros to address 0x1960028 */
	0xcb3be011, 0x00000002, 	/* write 2 zeros to address 0x19677c0 */
	0xcb3c2011, 0x00000002, 	/* write 2 zeros to address 0x1967840 */
	0xcb5ab601, 0x00000000, 	/* write 0x0 to address 0x196b56c */
	0xcb9cc421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973988 */
	0x00060013, 0x00060002, 	/* if phase != 'pf6', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb001811, 0x00000002, 	/* write 2 zeros to address 0x1960030 */
	0xcb3be411, 0x00000002, 	/* write 2 zeros to address 0x19677c8 */
	0xcb3c2411, 0x00000002, 	/* write 2 zeros to address 0x1967848 */
	0xcb5ab801, 0x00000000, 	/* write 0x0 to address 0x196b570 */
	0xcb9cc821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973990 */
	0x00060013, 0x00070002, 	/* if phase != 'pf7', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb001c11, 0x00000002, 	/* write 2 zeros to address 0x1960038 */
	0xcb3be811, 0x00000002, 	/* write 2 zeros to address 0x19677d0 */
	0xcb3c2811, 0x00000002, 	/* write 2 zeros to address 0x1967850 */
	0xcb5aba01, 0x00000000, 	/* write 0x0 to address 0x196b574 */
	0xcb9ccc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1973998 */
	0x00060013, 0x00080002, 	/* if phase != 'pf8', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb002011, 0x00000002, 	/* write 2 zeros to address 0x1960040 */
	0xcb3bec11, 0x00000002, 	/* write 2 zeros to address 0x19677d8 */
	0xcb3c2c11, 0x00000002, 	/* write 2 zeros to address 0x1967858 */
	0xcb5abc01, 0x00000000, 	/* write 0x0 to address 0x196b578 */
	0xcb9cd021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739a0 */
	0x00060013, 0x00090002, 	/* if phase != 'pf9', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb002411, 0x00000002, 	/* write 2 zeros to address 0x1960048 */
	0xcb3bf011, 0x00000002, 	/* write 2 zeros to address 0x19677e0 */
	0xcb3c3011, 0x00000002, 	/* write 2 zeros to address 0x1967860 */
	0xcb5abe01, 0x00000000, 	/* write 0x0 to address 0x196b57c */
	0xcb9cd421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739a8 */
	0x00060013, 0x000a0002, 	/* if phase != 'pf10', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb002811, 0x00000002, 	/* write 2 zeros to address 0x1960050 */
	0xcb3bf411, 0x00000002, 	/* write 2 zeros to address 0x19677e8 */
	0xcb3c3411, 0x00000002, 	/* write 2 zeros to address 0x1967868 */
	0xcb5ac001, 0x00000000, 	/* write 0x0 to address 0x196b580 */
	0xcb9cd821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739b0 */
	0x00060013, 0x000b0002, 	/* if phase != 'pf11', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb002c11, 0x00000002, 	/* write 2 zeros to address 0x1960058 */
	0xcb3bf811, 0x00000002, 	/* write 2 zeros to address 0x19677f0 */
	0xcb3c3811, 0x00000002, 	/* write 2 zeros to address 0x1967870 */
	0xcb5ac201, 0x00000000, 	/* write 0x0 to address 0x196b584 */
	0xcb9cdc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739b8 */
	0x00060013, 0x000c0002, 	/* if phase != 'pf12', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb003011, 0x00000002, 	/* write 2 zeros to address 0x1960060 */
	0xcb3bfc11, 0x00000002, 	/* write 2 zeros to address 0x19677f8 */
	0xcb3c3c11, 0x00000002, 	/* write 2 zeros to address 0x1967878 */
	0xcb5ac401, 0x00000000, 	/* write 0x0 to address 0x196b588 */
	0xcb9ce021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739c0 */
	0x00060013, 0x000d0002, 	/* if phase != 'pf13', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb003411, 0x00000002, 	/* write 2 zeros to address 0x1960068 */
	0xcb3c0011, 0x00000002, 	/* write 2 zeros to address 0x1967800 */
	0xcb3c4011, 0x00000002, 	/* write 2 zeros to address 0x1967880 */
	0xcb5ac601, 0x00000000, 	/* write 0x0 to address 0x196b58c */
	0xcb9ce421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739c8 */
	0x00060013, 0x000e0002, 	/* if phase != 'pf14', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb003811, 0x00000002, 	/* write 2 zeros to address 0x1960070 */
	0xcb3c0411, 0x00000002, 	/* write 2 zeros to address 0x1967808 */
	0xcb3c4411, 0x00000002, 	/* write 2 zeros to address 0x1967888 */
	0xcb5ac801, 0x00000000, 	/* write 0x0 to address 0x196b590 */
	0xcb9ce821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739d0 */
	0x00060013, 0x000f0002, 	/* if phase != 'pf15', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xcb003c11, 0x00000002, 	/* write 2 zeros to address 0x1960078 */
	0xcb3c0811, 0x00000002, 	/* write 2 zeros to address 0x1967810 */
	0xcb3c4811, 0x00000002, 	/* write 2 zeros to address 0x1967890 */
	0xcb5aca01, 0x00000000, 	/* write 0x0 to address 0x196b594 */
	0xcb9cec21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x19739d8 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0xc8020601, 0x00000001, 	/* write 0x1 to address 0x190040c */
	0x00020013, 0x00000001, 	/* if phase != 'port0', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xcb3f5411, 0x00000002, 	/* write 2 zeros to address 0x1967ea8 */
	0x00020013, 0x00010001, 	/* if phase != 'port1', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xcb3f5811, 0x00000002, 	/* write 2 zeros to address 0x1967eb0 */
	0x00020013, 0x00020001, 	/* if phase != 'port2', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xcb3f5c11, 0x00000002, 	/* write 2 zeros to address 0x1967eb8 */
	0x00020013, 0x00030001, 	/* if phase != 'port3', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xcb3f6011, 0x00000002, 	/* write 2 zeros to address 0x1967ec0 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0xc8020401, 0x00000001, 	/* write 0x1 to address 0x1900408 */
	/* XSEM */
	0x00580013, 0xffff0000, 	/* if phase != 'engine', skip 88 ops  */
	0xa0002a01, 0x00000000, 	/* write 0x0 to address 0x1400054 */
	0xa0006601, 0x00000000, 	/* write 0x0 to address 0x14000cc */
	0xa2002201, 0x00000000, 	/* write 0x0 to address 0x1440044 */
	0xa2032c01, 0x00000001, 	/* write 0x1 to address 0x1440658 */
	0xa203a421, 0x0000028d, 	/* write array of size 3 from offset 653 to address 0x1440748 */
	0xa2052401, 0x00001fff, 	/* write 0x1fff to address 0x1440a48 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0xa2010201, 0x00000000, 	/* write 0x0 to address 0x1440204 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xa0002201, 0x00000000, 	/* write 0x0 to address 0x1400044 */
	0xa1000111, 0x000010e0, 	/* write 4320 zeros to address 0x1420000 (WB) */
	0xa2025001, 0x00000007, 	/* write 0x7 to address 0x14404a0 */
	0xa3000011, 0x00005000, 	/* write 20480 zeros to address 0x1460000 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0xa0010201, 0x00000000, 	/* write 0x0 to address 0x1400204 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xa2025c01, 0x00000000, 	/* write 0x0 to address 0x14404b8 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xa2025c01, 0x00000002, 	/* write 0x2 to address 0x14404b8 */
	0x000a0002, 0x00010000, 	/* if mode != 'bb|k2', skip 10 ops */
	0xa3000021, 0x0000f301, 	/* write array of size 6 from offset 62209 to address 0x1460000 */
	0xa3262021, 0x000074be, 	/* write array of size 7 from offset 29886 to address 0x1464c40 */
	0xa3262e11, 0x00000017, 	/* write 23 zeros to address 0x1464c5c */
	0xa33a8021, 0x0000f308, 	/* write array of size 2 from offset 62216 to address 0x1467500 */
	0xa356c021, 0x0000069a, 	/* write array of size 1 from offset 1690 to address 0x146ad80 */
	0xa356c211, 0x00000019, 	/* write 25 zeros to address 0x146ad84 */
	0xa364a021, 0x0000f30b, 	/* write array of size 15 from offset 62219 to address 0x146c940 */
	0xa364be21, 0x0000f31b, 	/* write array of size 7 from offset 62235 to address 0x146c97c */
	0xa364cc21, 0x0000f31d, 	/* write array of size 6 from offset 62237 to address 0x146c998 */
	0xa39ffc21, 0x0000f324, 	/* write array of size 2 from offset 62244 to address 0x1473ff8 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0xa325cc01, 0x00000002, 	/* write 0x2 to address 0x1464b98 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xa325ce01, 0x00000000, 	/* write 0x0 to address 0x1464b9c */
	0x00010002, 0x006d0000, 	/* if mode != 'ports_per_eng_2&(bb|k2)', skip 1 ops */
	0xa325ce01, 0x00000001, 	/* write 0x1 to address 0x1464b9c */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xa325ce01, 0x00000002, 	/* write 0x2 to address 0x1464b9c */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0xa325ca01, 0x00000003, 	/* write 0x3 to address 0x1464b94 */
	0x00010002, 0x00860000, 	/* if mode != 'bb&(bb|k2)', skip 1 ops */
	0xa325ca01, 0x00000002, 	/* write 0x2 to address 0x1464b94 */
	0x00010002, 0x00120000, 	/* if mode != '(bb|k2)&(asic|chipsim|emul_full)', skip 1 ops */
	0xa325cc01, 0x00000003, 	/* write 0x3 to address 0x1464b98 */
	0xa2032e10, 0x00000000, 	/* wait until address 0x144065c reads 0x0 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0xa0022401, 0x00001bfc, 	/* write 0x1bfc to address 0x1400448 */
	0xa0028121, 0x0000f327, 	/* write array of size 14 from offset 62247 to address 0x1400500 (WB) */
	0xa0800021, 0x0000f336, 	/* write array of size 256 from offset 62262 to address 0x1410000 */
	0x00090002, 0x005c0000, 	/* if mode != '(bb|k2)&(!chipsim)', skip 9 ops */
	0xa4000121, 0x0000f338, 	/* write array of size 8192 from offset 62264 to address 0x1480000 (WB) */
	0xa4400121, 0x00010277, 	/* write array of size 8192 from offset 66167 to address 0x1488000 (WB) */
	0xa4800121, 0x0001116b, 	/* write array of size 8192 from offset 69995 to address 0x1490000 (WB) */
	0xa4c00121, 0x00011e51, 	/* write array of size 8192 from offset 73297 to address 0x1498000 (WB) */
	0xa5000121, 0x00012a72, 	/* write array of size 8192 from offset 76402 to address 0x14a0000 (WB) */
	0xa5400121, 0x000138b4, 	/* write array of size 8192 from offset 80052 to address 0x14a8000 (WB) */
	0xa5800121, 0x00014125, 	/* write array of size 8192 from offset 82213 to address 0x14b0000 (WB) */
	0xa5c00121, 0x00014f2f, 	/* write array of size 5608 from offset 85807 to address 0x14b8000 (WB) */
	0xa5ebd121, 0x000158c8, 	/* write array of size 10776 from offset 88264 to address 0x14bd7a0 (WB) */
	0x001c0002, 0x00010000, 	/* if mode != 'bb|k2', skip 28 ops */
	0xa0800021, 0x000158cb, 	/* write array of size 2 from offset 88267 to address 0x1410000 */
	0xa0800621, 0x000158ce, 	/* write array of size 3 from offset 88270 to address 0x141000c */
	0xa0801021, 0x000158d2, 	/* write array of size 7 from offset 88274 to address 0x1410020 */
	0xa0802021, 0x000158da, 	/* write array of size 2 from offset 88282 to address 0x1410040 */
	0xa0802821, 0x000158dd, 	/* write array of size 2 from offset 88285 to address 0x1410050 */
	0xa0803001, 0x001e3725, 	/* write 0x1e3725 to address 0x1410060 */
	0xa0804221, 0x000158e0, 	/* write array of size 6 from offset 88288 to address 0x1410084 */
	0xa0805001, 0x00127e49, 	/* write 0x127e49 to address 0x14100a0 */
	0xa0807221, 0x000158e7, 	/* write array of size 2 from offset 88295 to address 0x14100e4 */
	0xa0808221, 0x000158ea, 	/* write array of size 2 from offset 88298 to address 0x1410104 */
	0xa0808821, 0x000158ed, 	/* write array of size 3 from offset 88301 to address 0x1410110 */
	0xa0809021, 0x000158f1, 	/* write array of size 3 from offset 88305 to address 0x1410120 */
	0xa0809821, 0x000158f5, 	/* write array of size 3 from offset 88309 to address 0x1410130 */
	0xa080a001, 0x00040f60, 	/* write 0x40f60 to address 0x1410140 */
	0xa080c201, 0x0006108e, 	/* write 0x6108e to address 0x1410184 */
	0xa080c821, 0x000158f9, 	/* write array of size 2 from offset 88313 to address 0x1410190 */
	0xa080d001, 0x000616b6, 	/* write 0x616b6 to address 0x14101a0 */
	0xa0810201, 0x000849e2, 	/* write 0x849e2 to address 0x1410204 */
	0xa0810621, 0x000158fc, 	/* write array of size 3 from offset 88316 to address 0x141020c */
	0xa0811021, 0x00015900, 	/* write array of size 2 from offset 88320 to address 0x1410220 */
	0xa0814221, 0x00015903, 	/* write array of size 3 from offset 88323 to address 0x1410284 */
	0xa0814a01, 0x00127e0f, 	/* write 0x127e0f to address 0x1410294 */
	0xa0818201, 0x000c794c, 	/* write 0xc794c to address 0x1410304 */
	0xa0818821, 0x00015907, 	/* write array of size 3 from offset 88327 to address 0x1410310 */
	0xa0819021, 0x0001590b, 	/* write array of size 3 from offset 88331 to address 0x1410320 */
	0xa0819821, 0x0001590f, 	/* write array of size 3 from offset 88335 to address 0x1410330 */
	0xa081a021, 0x00015913, 	/* write array of size 3 from offset 88339 to address 0x1410340 */
	0xa081a821, 0x00015917, 	/* write array of size 3 from offset 88343 to address 0x1410350 */
	0x00060013, 0x00000002, 	/* if phase != 'pf0', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31a6811, 0x00000038, 	/* write 56 zeros to address 0x14634d0 */
	0xa3228811, 0x00000002, 	/* write 2 zeros to address 0x1464510 */
	0xa3270c01, 0x00000000, 	/* write 0x0 to address 0x1464e18 */
	0xa352c011, 0x0000000e, 	/* write 14 zeros to address 0x146a580 */
	0xa363a021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c740 */
	0x00060013, 0x00010002, 	/* if phase != 'pf1', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31ad811, 0x00000038, 	/* write 56 zeros to address 0x14635b0 */
	0xa3228c11, 0x00000002, 	/* write 2 zeros to address 0x1464518 */
	0xa3270e01, 0x00000000, 	/* write 0x0 to address 0x1464e1c */
	0xa352dc11, 0x0000000e, 	/* write 14 zeros to address 0x146a5b8 */
	0xa363a421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c748 */
	0x00060013, 0x00020002, 	/* if phase != 'pf2', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31b4811, 0x00000038, 	/* write 56 zeros to address 0x1463690 */
	0xa3229011, 0x00000002, 	/* write 2 zeros to address 0x1464520 */
	0xa3271001, 0x00000000, 	/* write 0x0 to address 0x1464e20 */
	0xa352f811, 0x0000000e, 	/* write 14 zeros to address 0x146a5f0 */
	0xa363a821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c750 */
	0x00060013, 0x00030002, 	/* if phase != 'pf3', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31bb811, 0x00000038, 	/* write 56 zeros to address 0x1463770 */
	0xa3229411, 0x00000002, 	/* write 2 zeros to address 0x1464528 */
	0xa3271201, 0x00000000, 	/* write 0x0 to address 0x1464e24 */
	0xa3531411, 0x0000000e, 	/* write 14 zeros to address 0x146a628 */
	0xa363ac21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c758 */
	0x00060013, 0x00040002, 	/* if phase != 'pf4', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31c2811, 0x00000038, 	/* write 56 zeros to address 0x1463850 */
	0xa3229811, 0x00000002, 	/* write 2 zeros to address 0x1464530 */
	0xa3271401, 0x00000000, 	/* write 0x0 to address 0x1464e28 */
	0xa3533011, 0x0000000e, 	/* write 14 zeros to address 0x146a660 */
	0xa363b021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c760 */
	0x00060013, 0x00050002, 	/* if phase != 'pf5', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31c9811, 0x00000038, 	/* write 56 zeros to address 0x1463930 */
	0xa3229c11, 0x00000002, 	/* write 2 zeros to address 0x1464538 */
	0xa3271601, 0x00000000, 	/* write 0x0 to address 0x1464e2c */
	0xa3534c11, 0x0000000e, 	/* write 14 zeros to address 0x146a698 */
	0xa363b421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c768 */
	0x00060013, 0x00060002, 	/* if phase != 'pf6', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31d0811, 0x00000038, 	/* write 56 zeros to address 0x1463a10 */
	0xa322a011, 0x00000002, 	/* write 2 zeros to address 0x1464540 */
	0xa3271801, 0x00000000, 	/* write 0x0 to address 0x1464e30 */
	0xa3536811, 0x0000000e, 	/* write 14 zeros to address 0x146a6d0 */
	0xa363b821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c770 */
	0x00060013, 0x00070002, 	/* if phase != 'pf7', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31d7811, 0x00000038, 	/* write 56 zeros to address 0x1463af0 */
	0xa322a411, 0x00000002, 	/* write 2 zeros to address 0x1464548 */
	0xa3271a01, 0x00000000, 	/* write 0x0 to address 0x1464e34 */
	0xa3538411, 0x0000000e, 	/* write 14 zeros to address 0x146a708 */
	0xa363bc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c778 */
	0x00060013, 0x00080002, 	/* if phase != 'pf8', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31de811, 0x00000038, 	/* write 56 zeros to address 0x1463bd0 */
	0xa322a811, 0x00000002, 	/* write 2 zeros to address 0x1464550 */
	0xa3271c01, 0x00000000, 	/* write 0x0 to address 0x1464e38 */
	0xa353a011, 0x0000000e, 	/* write 14 zeros to address 0x146a740 */
	0xa363c021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c780 */
	0x00060013, 0x00090002, 	/* if phase != 'pf9', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31e5811, 0x00000038, 	/* write 56 zeros to address 0x1463cb0 */
	0xa322ac11, 0x00000002, 	/* write 2 zeros to address 0x1464558 */
	0xa3271e01, 0x00000000, 	/* write 0x0 to address 0x1464e3c */
	0xa353bc11, 0x0000000e, 	/* write 14 zeros to address 0x146a778 */
	0xa363c421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c788 */
	0x00060013, 0x000a0002, 	/* if phase != 'pf10', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31ec811, 0x00000038, 	/* write 56 zeros to address 0x1463d90 */
	0xa322b011, 0x00000002, 	/* write 2 zeros to address 0x1464560 */
	0xa3272001, 0x00000000, 	/* write 0x0 to address 0x1464e40 */
	0xa353d811, 0x0000000e, 	/* write 14 zeros to address 0x146a7b0 */
	0xa363c821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c790 */
	0x00060013, 0x000b0002, 	/* if phase != 'pf11', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31f3811, 0x00000038, 	/* write 56 zeros to address 0x1463e70 */
	0xa322b411, 0x00000002, 	/* write 2 zeros to address 0x1464568 */
	0xa3272201, 0x00000000, 	/* write 0x0 to address 0x1464e44 */
	0xa353f411, 0x0000000e, 	/* write 14 zeros to address 0x146a7e8 */
	0xa363cc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c798 */
	0x00060013, 0x000c0002, 	/* if phase != 'pf12', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa31fa811, 0x00000038, 	/* write 56 zeros to address 0x1463f50 */
	0xa322b811, 0x00000002, 	/* write 2 zeros to address 0x1464570 */
	0xa3272401, 0x00000000, 	/* write 0x0 to address 0x1464e48 */
	0xa3541011, 0x0000000e, 	/* write 14 zeros to address 0x146a820 */
	0xa363d021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c7a0 */
	0x00060013, 0x000d0002, 	/* if phase != 'pf13', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa3201811, 0x00000038, 	/* write 56 zeros to address 0x1464030 */
	0xa322bc11, 0x00000002, 	/* write 2 zeros to address 0x1464578 */
	0xa3272601, 0x00000000, 	/* write 0x0 to address 0x1464e4c */
	0xa3542c11, 0x0000000e, 	/* write 14 zeros to address 0x146a858 */
	0xa363d421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c7a8 */
	0x00060013, 0x000e0002, 	/* if phase != 'pf14', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa3208811, 0x00000038, 	/* write 56 zeros to address 0x1464110 */
	0xa322c011, 0x00000002, 	/* write 2 zeros to address 0x1464580 */
	0xa3272801, 0x00000000, 	/* write 0x0 to address 0x1464e50 */
	0xa3544811, 0x0000000e, 	/* write 14 zeros to address 0x146a890 */
	0xa363d821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c7b0 */
	0x00060013, 0x000f0002, 	/* if phase != 'pf15', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xa320f811, 0x00000038, 	/* write 56 zeros to address 0x14641f0 */
	0xa322c411, 0x00000002, 	/* write 2 zeros to address 0x1464588 */
	0xa3272a01, 0x00000000, 	/* write 0x0 to address 0x1464e54 */
	0xa3546411, 0x0000000e, 	/* write 14 zeros to address 0x146a8c8 */
	0xa363dc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x146c7b8 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0xa0020601, 0x00000001, 	/* write 0x1 to address 0x140040c */
	0x00020013, 0x00000001, 	/* if phase != 'port0', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xa325d011, 0x00000002, 	/* write 2 zeros to address 0x1464ba0 */
	0x00020013, 0x00010001, 	/* if phase != 'port1', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xa325d411, 0x00000002, 	/* write 2 zeros to address 0x1464ba8 */
	0x00020013, 0x00020001, 	/* if phase != 'port2', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xa325d811, 0x00000002, 	/* write 2 zeros to address 0x1464bb0 */
	0x00020013, 0x00030001, 	/* if phase != 'port3', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xa325dc11, 0x00000002, 	/* write 2 zeros to address 0x1464bb8 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0xa0020401, 0x00000001, 	/* write 0x1 to address 0x1400408 */
	/* YSEM */
	0x00450013, 0xffff0000, 	/* if phase != 'engine', skip 69 ops  */
	0xa8002a01, 0x00000000, 	/* write 0x0 to address 0x1500054 */
	0xa8006601, 0x00000000, 	/* write 0x0 to address 0x15000cc */
	0xaa002201, 0x00000000, 	/* write 0x0 to address 0x1540044 */
	0xaa032c01, 0x00000001, 	/* write 0x1 to address 0x1540658 */
	0xaa03a421, 0x0000028d, 	/* write array of size 3 from offset 653 to address 0x1540748 */
	0xaa052401, 0x00001fff, 	/* write 0x1fff to address 0x1540a48 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0xaa010201, 0x00000000, 	/* write 0x0 to address 0x1540204 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xa8002201, 0x00000000, 	/* write 0x0 to address 0x1500044 */
	0xa9000111, 0x000009d8, 	/* write 2520 zeros to address 0x1520000 (WB) */
	0xaa025001, 0x00000007, 	/* write 0x7 to address 0x15404a0 */
	0xab000011, 0x00005000, 	/* write 20480 zeros to address 0x1560000 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0xa8010201, 0x00000000, 	/* write 0x0 to address 0x1500204 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xaa025c01, 0x00000000, 	/* write 0x0 to address 0x15404b8 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xaa025c01, 0x00000002, 	/* write 0x2 to address 0x15404b8 */
	0x00070002, 0x00010000, 	/* if mode != 'bb|k2', skip 7 ops */
	0xab000421, 0x0001591b, 	/* write array of size 6 from offset 88347 to address 0x1560008 */
	0xab1ef821, 0x000074be, 	/* write array of size 7 from offset 29886 to address 0x1563df0 */
	0xab1f0611, 0x00000017, 	/* write 23 zeros to address 0x1563e0c */
	0xab457c21, 0x0000069a, 	/* write array of size 1 from offset 1690 to address 0x1568af8 */
	0xab457e11, 0x00000019, 	/* write 25 zeros to address 0x1568afc */
	0xab4b7c21, 0x000074cc, 	/* write array of size 640 from offset 29900 to address 0x15696f8 */
	0xab9ffc21, 0x00015922, 	/* write array of size 2 from offset 88354 to address 0x1573ff8 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0xab1e4401, 0x00000002, 	/* write 0x2 to address 0x1563c88 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xab1e4601, 0x00000000, 	/* write 0x0 to address 0x1563c8c */
	0x00010002, 0x006d0000, 	/* if mode != 'ports_per_eng_2&(bb|k2)', skip 1 ops */
	0xab1e4601, 0x00000001, 	/* write 0x1 to address 0x1563c8c */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xab1e4601, 0x00000002, 	/* write 0x2 to address 0x1563c8c */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0xab1e4201, 0x00000003, 	/* write 0x3 to address 0x1563c84 */
	0x00010002, 0x00860000, 	/* if mode != 'bb&(bb|k2)', skip 1 ops */
	0xab1e4201, 0x00000002, 	/* write 0x2 to address 0x1563c84 */
	0x00010002, 0x00120000, 	/* if mode != '(bb|k2)&(asic|chipsim|emul_full)', skip 1 ops */
	0xab1e4401, 0x00000003, 	/* write 0x3 to address 0x1563c88 */
	0xaa032e10, 0x00000000, 	/* wait until address 0x154065c reads 0x0 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0xa8022401, 0x00001ec9, 	/* write 0x1ec9 to address 0x1500448 */
	0xa8028121, 0x00015925, 	/* write array of size 14 from offset 88357 to address 0x1500500 (WB) */
	0xa8800021, 0x00015934, 	/* write array of size 256 from offset 88372 to address 0x1510000 */
	0x00070002, 0x005c0000, 	/* if mode != '(bb|k2)&(!chipsim)', skip 7 ops */
	0xac000121, 0x00015936, 	/* write array of size 8192 from offset 88374 to address 0x1580000 (WB) */
	0xac400121, 0x0001686f, 	/* write array of size 8192 from offset 92271 to address 0x1588000 (WB) */
	0xac800121, 0x0001751b, 	/* write array of size 8192 from offset 95515 to address 0x1590000 (WB) */
	0xacc00121, 0x00018283, 	/* write array of size 8192 from offset 98947 to address 0x1598000 (WB) */
	0xad000121, 0x00018fe2, 	/* write array of size 8192 from offset 102370 to address 0x15a0000 (WB) */
	0xad400121, 0x00019d27, 	/* write array of size 1000 from offset 105767 to address 0x15a8000 (WB) */
	0xad47d121, 0x00019e63, 	/* write array of size 7192 from offset 106083 to address 0x15a8fa0 (WB) */
	0x000e0002, 0x00010000, 	/* if mode != 'bb|k2', skip 14 ops */
	0xa8800021, 0x00019e66, 	/* write array of size 22 from offset 106086 to address 0x1510000 */
	0xa8804221, 0x00019e7d, 	/* write array of size 2 from offset 106109 to address 0x1510084 */
	0xa8804a21, 0x00019e80, 	/* write array of size 2 from offset 106112 to address 0x1510094 */
	0xa8805001, 0x001256a9, 	/* write 0x1256a9 to address 0x15100a0 */
	0xa8807201, 0x001e54c4, 	/* write 0x1e54c4 to address 0x15100e4 */
	0xa8808201, 0x00040cf6, 	/* write 0x40cf6 to address 0x1510104 */
	0xa8808621, 0x00019e83, 	/* write array of size 3 from offset 106115 to address 0x151010c */
	0xa8809001, 0x001e012c, 	/* write 0x1e012c to address 0x1510120 */
	0xa880c221, 0x00019e87, 	/* write array of size 12 from offset 106119 to address 0x1510184 */
	0xa8810221, 0x00019e94, 	/* write array of size 6 from offset 106132 to address 0x1510204 */
	0xa8811221, 0x00019e9b, 	/* write array of size 3 from offset 106139 to address 0x1510224 */
	0xa8811a01, 0x001235ca, 	/* write 0x1235ca to address 0x1510234 */
	0xa8814221, 0x00019e9f, 	/* write array of size 5 from offset 106143 to address 0x1510284 */
	0xa8818421, 0x00019ea5, 	/* write array of size 10 from offset 106149 to address 0x1510308 */
	0x00050013, 0x00000002, 	/* if phase != 'pf0', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ac011, 0x00000002, 	/* write 2 zeros to address 0x1563580 */
	0xab1b0011, 0x00000002, 	/* write 2 zeros to address 0x1563600 */
	0xab1ffc01, 0x00000000, 	/* write 0x0 to address 0x1563ff8 */
	0xab508821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a110 */
	0x00050013, 0x00010002, 	/* if phase != 'pf1', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ac411, 0x00000002, 	/* write 2 zeros to address 0x1563588 */
	0xab1b0411, 0x00000002, 	/* write 2 zeros to address 0x1563608 */
	0xab1ffe01, 0x00000000, 	/* write 0x0 to address 0x1563ffc */
	0xab508c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a118 */
	0x00050013, 0x00020002, 	/* if phase != 'pf2', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ac811, 0x00000002, 	/* write 2 zeros to address 0x1563590 */
	0xab1b0811, 0x00000002, 	/* write 2 zeros to address 0x1563610 */
	0xab200001, 0x00000000, 	/* write 0x0 to address 0x1564000 */
	0xab509021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a120 */
	0x00050013, 0x00030002, 	/* if phase != 'pf3', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1acc11, 0x00000002, 	/* write 2 zeros to address 0x1563598 */
	0xab1b0c11, 0x00000002, 	/* write 2 zeros to address 0x1563618 */
	0xab200201, 0x00000000, 	/* write 0x0 to address 0x1564004 */
	0xab509421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a128 */
	0x00050013, 0x00040002, 	/* if phase != 'pf4', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ad011, 0x00000002, 	/* write 2 zeros to address 0x15635a0 */
	0xab1b1011, 0x00000002, 	/* write 2 zeros to address 0x1563620 */
	0xab200401, 0x00000000, 	/* write 0x0 to address 0x1564008 */
	0xab509821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a130 */
	0x00050013, 0x00050002, 	/* if phase != 'pf5', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ad411, 0x00000002, 	/* write 2 zeros to address 0x15635a8 */
	0xab1b1411, 0x00000002, 	/* write 2 zeros to address 0x1563628 */
	0xab200601, 0x00000000, 	/* write 0x0 to address 0x156400c */
	0xab509c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a138 */
	0x00050013, 0x00060002, 	/* if phase != 'pf6', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ad811, 0x00000002, 	/* write 2 zeros to address 0x15635b0 */
	0xab1b1811, 0x00000002, 	/* write 2 zeros to address 0x1563630 */
	0xab200801, 0x00000000, 	/* write 0x0 to address 0x1564010 */
	0xab50a021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a140 */
	0x00050013, 0x00070002, 	/* if phase != 'pf7', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1adc11, 0x00000002, 	/* write 2 zeros to address 0x15635b8 */
	0xab1b1c11, 0x00000002, 	/* write 2 zeros to address 0x1563638 */
	0xab200a01, 0x00000000, 	/* write 0x0 to address 0x1564014 */
	0xab50a421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a148 */
	0x00050013, 0x00080002, 	/* if phase != 'pf8', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ae011, 0x00000002, 	/* write 2 zeros to address 0x15635c0 */
	0xab1b2011, 0x00000002, 	/* write 2 zeros to address 0x1563640 */
	0xab200c01, 0x00000000, 	/* write 0x0 to address 0x1564018 */
	0xab50a821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a150 */
	0x00050013, 0x00090002, 	/* if phase != 'pf9', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ae411, 0x00000002, 	/* write 2 zeros to address 0x15635c8 */
	0xab1b2411, 0x00000002, 	/* write 2 zeros to address 0x1563648 */
	0xab200e01, 0x00000000, 	/* write 0x0 to address 0x156401c */
	0xab50ac21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a158 */
	0x00050013, 0x000a0002, 	/* if phase != 'pf10', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1ae811, 0x00000002, 	/* write 2 zeros to address 0x15635d0 */
	0xab1b2811, 0x00000002, 	/* write 2 zeros to address 0x1563650 */
	0xab201001, 0x00000000, 	/* write 0x0 to address 0x1564020 */
	0xab50b021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a160 */
	0x00050013, 0x000b0002, 	/* if phase != 'pf11', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1aec11, 0x00000002, 	/* write 2 zeros to address 0x15635d8 */
	0xab1b2c11, 0x00000002, 	/* write 2 zeros to address 0x1563658 */
	0xab201201, 0x00000000, 	/* write 0x0 to address 0x1564024 */
	0xab50b421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a168 */
	0x00050013, 0x000c0002, 	/* if phase != 'pf12', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1af011, 0x00000002, 	/* write 2 zeros to address 0x15635e0 */
	0xab1b3011, 0x00000002, 	/* write 2 zeros to address 0x1563660 */
	0xab201401, 0x00000000, 	/* write 0x0 to address 0x1564028 */
	0xab50b821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a170 */
	0x00050013, 0x000d0002, 	/* if phase != 'pf13', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1af411, 0x00000002, 	/* write 2 zeros to address 0x15635e8 */
	0xab1b3411, 0x00000002, 	/* write 2 zeros to address 0x1563668 */
	0xab201601, 0x00000000, 	/* write 0x0 to address 0x156402c */
	0xab50bc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a178 */
	0x00050013, 0x000e0002, 	/* if phase != 'pf14', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1af811, 0x00000002, 	/* write 2 zeros to address 0x15635f0 */
	0xab1b3811, 0x00000002, 	/* write 2 zeros to address 0x1563670 */
	0xab201801, 0x00000000, 	/* write 0x0 to address 0x1564030 */
	0xab50c021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a180 */
	0x00050013, 0x000f0002, 	/* if phase != 'pf15', skip 5 ops  */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xab1afc11, 0x00000002, 	/* write 2 zeros to address 0x15635f8 */
	0xab1b3c11, 0x00000002, 	/* write 2 zeros to address 0x1563678 */
	0xab201a01, 0x00000000, 	/* write 0x0 to address 0x1564034 */
	0xab50c421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x156a188 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0xa8020601, 0x00000001, 	/* write 0x1 to address 0x150040c */
	0x00020013, 0x00000001, 	/* if phase != 'port0', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xab1e4811, 0x00000002, 	/* write 2 zeros to address 0x1563c90 */
	0x00020013, 0x00010001, 	/* if phase != 'port1', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xab1e4c11, 0x00000002, 	/* write 2 zeros to address 0x1563c98 */
	0x00020013, 0x00020001, 	/* if phase != 'port2', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xab1e5011, 0x00000002, 	/* write 2 zeros to address 0x1563ca0 */
	0x00020013, 0x00030001, 	/* if phase != 'port3', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xab1e5411, 0x00000002, 	/* write 2 zeros to address 0x1563ca8 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0xa8020401, 0x00000001, 	/* write 0x1 to address 0x1500408 */
	/* PSEM */
	0x004f0013, 0xffff0000, 	/* if phase != 'engine', skip 79 ops  */
	0xb0002a01, 0x00000000, 	/* write 0x0 to address 0x1600054 */
	0xb0006601, 0x00000000, 	/* write 0x0 to address 0x16000cc */
	0xb2002201, 0x00000000, 	/* write 0x0 to address 0x1640044 */
	0xb2032c01, 0x00000001, 	/* write 0x1 to address 0x1640658 */
	0xb203a421, 0x0000028d, 	/* write array of size 3 from offset 653 to address 0x1640748 */
	0xb2052401, 0x00001fff, 	/* write 0x1fff to address 0x1640a48 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0xb2010201, 0x00000000, 	/* write 0x0 to address 0x1640204 */
	0x00040002, 0x00010000, 	/* if mode != 'bb|k2', skip 4 ops */
	0xb0002201, 0x00000000, 	/* write 0x0 to address 0x1600044 */
	0xb1000111, 0x000002d0, 	/* write 720 zeros to address 0x1620000 (WB) */
	0xb2025001, 0x00000007, 	/* write 0x7 to address 0x16404a0 */
	0xb3000011, 0x00005000, 	/* write 20480 zeros to address 0x1660000 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0xb0010201, 0x00000000, 	/* write 0x0 to address 0x1600204 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xb2025c01, 0x00000000, 	/* write 0x0 to address 0x16404b8 */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xb2025c01, 0x00000002, 	/* write 0x2 to address 0x16404b8 */
	0x00010002, 0x001f0000, 	/* if mode != '!(emul_reduced|fpga)', skip 1 ops */
	0xb2501e01, 0x00000007, 	/* write 0x7 to address 0x164a03c */
	0x00010002, 0x00230000, 	/* if mode != '(!e5)&(!(emul_reduced|fpga))', skip 1 ops */
	0xb2510201, 0x00000000, 	/* write 0x0 to address 0x164a204 */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb3000021, 0x00000291, 	/* write array of size 6 from offset 657 to address 0x1660000 */
	0xb300fc21, 0x00019eb0, 	/* write array of size 4 from offset 106160 to address 0x16601f8 */
	0xb382fc21, 0x0000069a, 	/* write array of size 1 from offset 1690 to address 0x16705f8 */
	0xb382fe11, 0x00000019, 	/* write 25 zeros to address 0x16705fc */
	0xb39ffc21, 0x00019eb5, 	/* write array of size 2 from offset 106165 to address 0x1673ff8 */
	0x00010002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 1 ops */
	0xb3142401, 0x00000002, 	/* write 0x2 to address 0x1662848 */
	0x00010002, 0x00720000, 	/* if mode != 'ports_per_eng_1&(bb|k2)', skip 1 ops */
	0xb3142601, 0x00000000, 	/* write 0x0 to address 0x166284c */
	0x00010002, 0x006d0000, 	/* if mode != 'ports_per_eng_2&(bb|k2)', skip 1 ops */
	0xb3142601, 0x00000001, 	/* write 0x1 to address 0x166284c */
	0x00010002, 0x009f0000, 	/* if mode != 'ports_per_eng_4&(bb|k2)', skip 1 ops */
	0xb3142601, 0x00000002, 	/* write 0x2 to address 0x166284c */
	0x00010002, 0x008b0000, 	/* if mode != 'k2&(bb|k2)', skip 1 ops */
	0xb3142201, 0x00000003, 	/* write 0x3 to address 0x1662844 */
	0x00010002, 0x00860000, 	/* if mode != 'bb&(bb|k2)', skip 1 ops */
	0xb3142201, 0x00000002, 	/* write 0x2 to address 0x1662844 */
	0x00010002, 0x00120000, 	/* if mode != '(bb|k2)&(asic|chipsim|emul_full)', skip 1 ops */
	0xb3142401, 0x00000003, 	/* write 0x3 to address 0x1662848 */
	0xb2032e10, 0x00000000, 	/* wait until address 0x164065c reads 0x0 */
	0x00010002, 0x001f0000, 	/* if mode != '!(emul_reduced|fpga)', skip 1 ops */
	0xb2501e10, 0x00000007, 	/* wait until address 0x164a03c reads 0x7 */
	0x00020002, 0x001b0000, 	/* if mode != '(bb|k2)&(!(emul_reduced|fpga))', skip 2 ops */
	0xb2500021, 0x0000070d, 	/* write array of size 2 from offset 1805 to address 0x164a000 */
	0xb2500601, 0xc000ffff, 	/* write 0xc000ffff to address 0x164a00c */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0xb0022401, 0x0000102e, 	/* write 0x102e to address 0x1600448 */
	0xb0028121, 0x00019eb8, 	/* write array of size 14 from offset 106168 to address 0x1600500 (WB) */
	0xb0800021, 0x00019ec7, 	/* write array of size 256 from offset 106183 to address 0x1610000 */
	0x00070002, 0x005c0000, 	/* if mode != '(bb|k2)&(!chipsim)', skip 7 ops */
	0xb4000121, 0x00019ec9, 	/* write array of size 8192 from offset 106185 to address 0x1680000 (WB) */
	0xb4400121, 0x0001acaf, 	/* write array of size 8192 from offset 109743 to address 0x1688000 (WB) */
	0xb4800121, 0x0001ba5b, 	/* write array of size 8192 from offset 113243 to address 0x1690000 (WB) */
	0xb4c00121, 0x0001c4df, 	/* write array of size 8192 from offset 115935 to address 0x1698000 (WB) */
	0xb5000121, 0x0001d328, 	/* write array of size 8192 from offset 119592 to address 0x16a0000 (WB) */
	0xb5400121, 0x0001e301, 	/* write array of size 992 from offset 123649 to address 0x16a8000 (WB) */
	0xb547c121, 0x0001e510, 	/* write array of size 7200 from offset 124176 to address 0x16a8f80 (WB) */
	0x00010002, 0x001f0000, 	/* if mode != '!(emul_reduced|fpga)', skip 1 ops */
	0xb2502001, 0x00000001, 	/* write 0x1 to address 0x164a040 */
	0x000d0002, 0x00010000, 	/* if mode != 'bb|k2', skip 13 ops */
	0xb0800021, 0x0001e513, 	/* write array of size 13 from offset 124179 to address 0x1610000 */
	0xb0802221, 0x0001e521, 	/* write array of size 9 from offset 124193 to address 0x1610044 */
	0xb0804221, 0x0001e52b, 	/* write array of size 2 from offset 124203 to address 0x1610084 */
	0xb0804801, 0x001e53a8, 	/* write 0x1e53a8 to address 0x1610090 */
	0xb0808221, 0x0001e52e, 	/* write array of size 2 from offset 124206 to address 0x1610104 */
	0xb0808801, 0x001e0337, 	/* write 0x1e0337 to address 0x1610110 */
	0xb0809021, 0x0001e531, 	/* write array of size 2 from offset 124209 to address 0x1610120 */
	0xb080c221, 0x0001e534, 	/* write array of size 2 from offset 124212 to address 0x1610184 */
	0xb080c821, 0x0001e537, 	/* write array of size 10 from offset 124215 to address 0x1610190 */
	0xb0810221, 0x0001e542, 	/* write array of size 3 from offset 124226 to address 0x1610204 */
	0xb0811221, 0x0001e546, 	/* write array of size 2 from offset 124230 to address 0x1610224 */
	0xb0814221, 0x0001e549, 	/* write array of size 2 from offset 124233 to address 0x1610284 */
	0xb0818421, 0x0001e54c, 	/* write array of size 6 from offset 124236 to address 0x1610308 */
	0x00010002, 0x001f0000, 	/* if mode != '!(emul_reduced|fpga)', skip 1 ops */
	0xb2502411, 0x00000002, 	/* write 2 zeros to address 0x164a048 */
	0x00060013, 0x00000002, 	/* if phase != 'pf0', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310a011, 0x00000002, 	/* write 2 zeros to address 0x1662140 */
	0xb310e011, 0x00000002, 	/* write 2 zeros to address 0x16621c0 */
	0xb349a401, 0x00000000, 	/* write 0x0 to address 0x1669348 */
	0xb37d3c21, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fa78 */
	0xb386fc21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670df8 */
	0x00060013, 0x00010002, 	/* if phase != 'pf1', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310a411, 0x00000002, 	/* write 2 zeros to address 0x1662148 */
	0xb310e411, 0x00000002, 	/* write 2 zeros to address 0x16621c8 */
	0xb349a601, 0x00000000, 	/* write 0x0 to address 0x166934c */
	0xb37d4021, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fa80 */
	0xb3870021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e00 */
	0x00060013, 0x00020002, 	/* if phase != 'pf2', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310a811, 0x00000002, 	/* write 2 zeros to address 0x1662150 */
	0xb310e811, 0x00000002, 	/* write 2 zeros to address 0x16621d0 */
	0xb349a801, 0x00000000, 	/* write 0x0 to address 0x1669350 */
	0xb37d4421, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fa88 */
	0xb3870421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e08 */
	0x00060013, 0x00030002, 	/* if phase != 'pf3', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310ac11, 0x00000002, 	/* write 2 zeros to address 0x1662158 */
	0xb310ec11, 0x00000002, 	/* write 2 zeros to address 0x16621d8 */
	0xb349aa01, 0x00000000, 	/* write 0x0 to address 0x1669354 */
	0xb37d4821, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fa90 */
	0xb3870821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e10 */
	0x00060013, 0x00040002, 	/* if phase != 'pf4', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310b011, 0x00000002, 	/* write 2 zeros to address 0x1662160 */
	0xb310f011, 0x00000002, 	/* write 2 zeros to address 0x16621e0 */
	0xb349ac01, 0x00000000, 	/* write 0x0 to address 0x1669358 */
	0xb37d4c21, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fa98 */
	0xb3870c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e18 */
	0x00060013, 0x00050002, 	/* if phase != 'pf5', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310b411, 0x00000002, 	/* write 2 zeros to address 0x1662168 */
	0xb310f411, 0x00000002, 	/* write 2 zeros to address 0x16621e8 */
	0xb349ae01, 0x00000000, 	/* write 0x0 to address 0x166935c */
	0xb37d5021, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166faa0 */
	0xb3871021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e20 */
	0x00060013, 0x00060002, 	/* if phase != 'pf6', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310b811, 0x00000002, 	/* write 2 zeros to address 0x1662170 */
	0xb310f811, 0x00000002, 	/* write 2 zeros to address 0x16621f0 */
	0xb349b001, 0x00000000, 	/* write 0x0 to address 0x1669360 */
	0xb37d5421, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166faa8 */
	0xb3871421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e28 */
	0x00060013, 0x00070002, 	/* if phase != 'pf7', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310bc11, 0x00000002, 	/* write 2 zeros to address 0x1662178 */
	0xb310fc11, 0x00000002, 	/* write 2 zeros to address 0x16621f8 */
	0xb349b201, 0x00000000, 	/* write 0x0 to address 0x1669364 */
	0xb37d5821, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fab0 */
	0xb3871821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e30 */
	0x00060013, 0x00080002, 	/* if phase != 'pf8', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310c011, 0x00000002, 	/* write 2 zeros to address 0x1662180 */
	0xb3110011, 0x00000002, 	/* write 2 zeros to address 0x1662200 */
	0xb349b401, 0x00000000, 	/* write 0x0 to address 0x1669368 */
	0xb37d5c21, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fab8 */
	0xb3871c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e38 */
	0x00060013, 0x00090002, 	/* if phase != 'pf9', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310c411, 0x00000002, 	/* write 2 zeros to address 0x1662188 */
	0xb3110411, 0x00000002, 	/* write 2 zeros to address 0x1662208 */
	0xb349b601, 0x00000000, 	/* write 0x0 to address 0x166936c */
	0xb37d6021, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fac0 */
	0xb3872021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e40 */
	0x00060013, 0x000a0002, 	/* if phase != 'pf10', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310c811, 0x00000002, 	/* write 2 zeros to address 0x1662190 */
	0xb3110811, 0x00000002, 	/* write 2 zeros to address 0x1662210 */
	0xb349b801, 0x00000000, 	/* write 0x0 to address 0x1669370 */
	0xb37d6421, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fac8 */
	0xb3872421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e48 */
	0x00060013, 0x000b0002, 	/* if phase != 'pf11', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310cc11, 0x00000002, 	/* write 2 zeros to address 0x1662198 */
	0xb3110c11, 0x00000002, 	/* write 2 zeros to address 0x1662218 */
	0xb349ba01, 0x00000000, 	/* write 0x0 to address 0x1669374 */
	0xb37d6821, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fad0 */
	0xb3872821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e50 */
	0x00060013, 0x000c0002, 	/* if phase != 'pf12', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310d011, 0x00000002, 	/* write 2 zeros to address 0x16621a0 */
	0xb3111011, 0x00000002, 	/* write 2 zeros to address 0x1662220 */
	0xb349bc01, 0x00000000, 	/* write 0x0 to address 0x1669378 */
	0xb37d6c21, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fad8 */
	0xb3872c21, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e58 */
	0x00060013, 0x000d0002, 	/* if phase != 'pf13', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310d411, 0x00000002, 	/* write 2 zeros to address 0x16621a8 */
	0xb3111411, 0x00000002, 	/* write 2 zeros to address 0x1662228 */
	0xb349be01, 0x00000000, 	/* write 0x0 to address 0x166937c */
	0xb37d7021, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fae0 */
	0xb3873021, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e60 */
	0x00060013, 0x000e0002, 	/* if phase != 'pf14', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310d811, 0x00000002, 	/* write 2 zeros to address 0x16621b0 */
	0xb3111811, 0x00000002, 	/* write 2 zeros to address 0x1662230 */
	0xb349c001, 0x00000000, 	/* write 0x0 to address 0x1669380 */
	0xb37d7421, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166fae8 */
	0xb3873421, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e68 */
	0x00060013, 0x000f0002, 	/* if phase != 'pf15', skip 6 ops  */
	0x00050002, 0x00010000, 	/* if mode != 'bb|k2', skip 5 ops */
	0xb310dc11, 0x00000002, 	/* write 2 zeros to address 0x16621b8 */
	0xb3111c11, 0x00000002, 	/* write 2 zeros to address 0x1662238 */
	0xb349c201, 0x00000000, 	/* write 0x0 to address 0x1669384 */
	0xb37d7821, 0x0001e553, 	/* write array of size 2 from offset 124243 to address 0x166faf0 */
	0xb3873821, 0x000074b4, 	/* write array of size 2 from offset 29876 to address 0x1670e70 */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0xb0020601, 0x00000001, 	/* write 0x1 to address 0x160040c */
	0x00020013, 0x00000001, 	/* if phase != 'port0', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xb3142811, 0x00000002, 	/* write 2 zeros to address 0x1662850 */
	0x00020013, 0x00010001, 	/* if phase != 'port1', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xb3142c11, 0x00000002, 	/* write 2 zeros to address 0x1662858 */
	0x00020013, 0x00020001, 	/* if phase != 'port2', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xb3143011, 0x00000002, 	/* write 2 zeros to address 0x1662860 */
	0x00020013, 0x00030001, 	/* if phase != 'port3', skip 2 ops  */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0xb3143411, 0x00000002, 	/* write 2 zeros to address 0x1662868 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0xb0020401, 0x00000001, 	/* write 0x1 to address 0x1600408 */
	/* RSS */
	0x00050013, 0xffff0000, 	/* if phase != 'engine', skip 5 ops  */
	0x11c4c201, 0x00000000, 	/* write 0x0 to address 0x238984 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x11c50201, 0x00000000, 	/* write 0x0 to address 0x238a04 */
	0x11c40201, 0x00000001, 	/* write 0x1 to address 0x238804 */
	0x11c40210, 0x00000000, 	/* wait until address 0x238804 reads 0x0 */
	/* TMLD */
	0x00030013, 0xffff0000, 	/* if phase != 'engine', skip 3 ops  */
	0x2680c201, 0x00000000, 	/* write 0x0 to address 0x4d0184 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x26810201, 0x00000000, 	/* write 0x0 to address 0x4d0204 */
	/* MULD */
	0x00090013, 0xffff0000, 	/* if phase != 'engine', skip 9 ops  */
	0x2700c201, 0x00000000, 	/* write 0x0 to address 0x4e0184 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x27200111, 0x00000800, 	/* write 2048 zeros to address 0x4e4000 (WB) */
	0x27400111, 0x00000800, 	/* write 2048 zeros to address 0x4e8000 (WB) */
	0x00020002, 0x002c0000, 	/* if mode != '!bb', skip 2 ops */
	0x27200111, 0x00000a00, 	/* write 2560 zeros to address 0x4e4000 (WB) */
	0x27400111, 0x00000a00, 	/* write 2560 zeros to address 0x4e8000 (WB) */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x27010201, 0x00000000, 	/* write 0x0 to address 0x4e0204 */
	/* YULD */
	0x00030013, 0xffff0000, 	/* if phase != 'engine', skip 3 ops  */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x2640c201, 0x00000000, 	/* write 0x0 to address 0x4c8184 */
	0x26410201, 0x00000000, 	/* write 0x0 to address 0x4c8204 */
	/* XYLD */
	0x00030013, 0xffff0000, 	/* if phase != 'engine', skip 3 ops  */
	0x2600c201, 0x00000000, 	/* write 0x0 to address 0x4c0184 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x26010201, 0x00000000, 	/* write 0x0 to address 0x4c0204 */
	/* PRM */
	0x000d0013, 0xffff0000, 	/* if phase != 'engine', skip 13 ops  */
	0x11802201, 0x00000000, 	/* write 0x0 to address 0x230044 */
	0x11802a01, 0x00000000, 	/* write 0x0 to address 0x230054 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x11810201, 0x00100000, 	/* write 0x100000 to address 0x230204 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x11810201, 0x00000000, 	/* write 0x0 to address 0x230204 */
	0x11821201, 0x00000001, 	/* write 0x1 to address 0x230424 */
	0x00010002, 0x002e0000, 	/* if mode != 'mf_sd', skip 1 ops */
	0x11820001, 0x00000001, 	/* write 0x1 to address 0x230400 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x11821401, 0x00000001, 	/* write 0x1 to address 0x230428 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x11821401, 0x00000002, 	/* write 0x2 to address 0x230428 */
	/* PBF_PB1 */
	0x00020013, 0xffff0000, 	/* if phase != 'engine', skip 2 ops  */
	0x6d002201, 0x00000000, 	/* write 0x0 to address 0xda0044 */
	0x6d002a01, 0x00000000, 	/* write 0x0 to address 0xda0054 */
	/* PBF_PB2 */
	0x00020013, 0xffff0000, 	/* if phase != 'engine', skip 2 ops  */
	0x6d202201, 0x00000000, 	/* write 0x0 to address 0xda4044 */
	0x6d202a01, 0x00000000, 	/* write 0x0 to address 0xda4054 */
	/* RPB */
	0x00020013, 0xffff0000, 	/* if phase != 'engine', skip 2 ops  */
	0x11e02201, 0x00000000, 	/* write 0x0 to address 0x23c044 */
	0x11e02a01, 0x00000000, 	/* write 0x0 to address 0x23c054 */
	/* BTB */
	0x00160013, 0xffff0000, 	/* if phase != 'engine', skip 22 ops  */
	0x6d806201, 0x00000000, 	/* write 0x0 to address 0xdb00c4 */
	0x6d806e01, 0x00000000, 	/* write 0x0 to address 0xdb00dc */
	0x6d807a01, 0x00000000, 	/* write 0x0 to address 0xdb00f4 */
	0x6d808601, 0x00000000, 	/* write 0x0 to address 0xdb010c */
	0x6d809201, 0x00000000, 	/* write 0x0 to address 0xdb0124 */
	0x6d809e01, 0x00000000, 	/* write 0x0 to address 0xdb013c */
	0x6d80aa01, 0x00000000, 	/* write 0x0 to address 0xdb0154 */
	0x6d80c401, 0x00000000, 	/* write 0x0 to address 0xdb0188 */
	0x6d80d001, 0x00000000, 	/* write 0x0 to address 0xdb01a0 */
	0x6d80dc01, 0x00000000, 	/* write 0x0 to address 0xdb01b8 */
	0x6d80e801, 0x00000000, 	/* write 0x0 to address 0xdb01d0 */
	0x6d80f001, 0x00000000, 	/* write 0x0 to address 0xdb01e0 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x6d820201, 0x00000000, 	/* write 0x0 to address 0xdb0404 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x6d820201, 0x00000000, 	/* write 0x0 to address 0xdb0404 */
	0x6d800201, 0x00000003, 	/* write 0x3 to address 0xdb0004 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x6d842601, 0x00000005, 	/* write 0x5 to address 0xdb084c */
	0x00010002, 0x004e0000, 	/* if mode != '100g', skip 1 ops */
	0x6d842401, 0x00000567, 	/* write 0x567 to address 0xdb0848 */
	0x6d800410, 0x00000003, 	/* wait until address 0xdb0008 reads 0x3 */
	/* PBF */
	0x00360013, 0xffff0000, 	/* if phase != 'engine', skip 54 ops  */
	0x6c00c201, 0x00000000, 	/* write 0x0 to address 0xd80184 */
	0x6c00ca01, 0x00000000, 	/* write 0x0 to address 0xd80194 */
	0x6c024031, 0x85c60001, 	/* write runtime array of size 1 from offset 34246 to address 0xd80480 */
	0x6c035031, 0x85c80001, 	/* write runtime array of size 1 from offset 34248 to address 0xd806a0 */
	0x6c035e31, 0x85c90002, 	/* write runtime array of size 2 from offset 34249 to address 0xd806bc */
	0x6c037031, 0x85cb0001, 	/* write runtime array of size 1 from offset 34251 to address 0xd806e0 */
	0x6c037e31, 0x85cc0002, 	/* write runtime array of size 2 from offset 34252 to address 0xd806fc */
	0x6c039031, 0x85ce0001, 	/* write runtime array of size 1 from offset 34254 to address 0xd80720 */
	0x6c039e31, 0x85cf0002, 	/* write runtime array of size 2 from offset 34255 to address 0xd8073c */
	0x6c03b031, 0x85d10001, 	/* write runtime array of size 1 from offset 34257 to address 0xd80760 */
	0x6c03be31, 0x85d20002, 	/* write runtime array of size 2 from offset 34258 to address 0xd8077c */
	0x6c03d031, 0x85d40001, 	/* write runtime array of size 1 from offset 34260 to address 0xd807a0 */
	0x6c03de31, 0x85d50002, 	/* write runtime array of size 2 from offset 34261 to address 0xd807bc */
	0x6c03f031, 0x85d70001, 	/* write runtime array of size 1 from offset 34263 to address 0xd807e0 */
	0x6c03fe31, 0x85d80002, 	/* write runtime array of size 2 from offset 34264 to address 0xd807fc */
	0x6c041031, 0x85da0001, 	/* write runtime array of size 1 from offset 34266 to address 0xd80820 */
	0x6c041e31, 0x85db0002, 	/* write runtime array of size 2 from offset 34267 to address 0xd8083c */
	0x6c043031, 0x85dd0001, 	/* write runtime array of size 1 from offset 34269 to address 0xd80860 */
	0x6c043e31, 0x85de0002, 	/* write runtime array of size 2 from offset 34270 to address 0xd8087c */
	0x6c045031, 0x85e00001, 	/* write runtime array of size 1 from offset 34272 to address 0xd808a0 */
	0x6c045e31, 0x85e10002, 	/* write runtime array of size 2 from offset 34273 to address 0xd808bc */
	0x6c047031, 0x85e30001, 	/* write runtime array of size 1 from offset 34275 to address 0xd808e0 */
	0x6c047e31, 0x85e40002, 	/* write runtime array of size 2 from offset 34276 to address 0xd808fc */
	0x6c049031, 0x85e60001, 	/* write runtime array of size 1 from offset 34278 to address 0xd80920 */
	0x6c049e31, 0x85e70002, 	/* write runtime array of size 2 from offset 34279 to address 0xd8093c */
	0x6c04b031, 0x85e90001, 	/* write runtime array of size 1 from offset 34281 to address 0xd80960 */
	0x6c04be31, 0x85ea0002, 	/* write runtime array of size 2 from offset 34282 to address 0xd8097c */
	0x6c04d031, 0x85ec0001, 	/* write runtime array of size 1 from offset 34284 to address 0xd809a0 */
	0x6c04de31, 0x85ed0002, 	/* write runtime array of size 2 from offset 34285 to address 0xd809bc */
	0x6c04f031, 0x85ef0001, 	/* write runtime array of size 1 from offset 34287 to address 0xd809e0 */
	0x6c04fe31, 0x85f00002, 	/* write runtime array of size 2 from offset 34288 to address 0xd809fc */
	0x6c051031, 0x85f20001, 	/* write runtime array of size 1 from offset 34290 to address 0xd80a20 */
	0x6c051e31, 0x85f30002, 	/* write runtime array of size 2 from offset 34291 to address 0xd80a3c */
	0x6c053031, 0x85f50001, 	/* write runtime array of size 1 from offset 34293 to address 0xd80a60 */
	0x6c053e31, 0x85f60002, 	/* write runtime array of size 2 from offset 34294 to address 0xd80a7c */
	0x6c055031, 0x85f80001, 	/* write runtime array of size 1 from offset 34296 to address 0xd80aa0 */
	0x6c055e31, 0x85f90002, 	/* write runtime array of size 2 from offset 34297 to address 0xd80abc */
	0x6c057031, 0x85fb0001, 	/* write runtime array of size 1 from offset 34299 to address 0xd80ae0 */
	0x6c057e31, 0x85fc0002, 	/* write runtime array of size 2 from offset 34300 to address 0xd80afc */
	0x6c059031, 0x85fe0001, 	/* write runtime array of size 1 from offset 34302 to address 0xd80b20 */
	0x6c059e31, 0x85ff0002, 	/* write runtime array of size 2 from offset 34303 to address 0xd80b3c */
	0x6c05b031, 0x86010001, 	/* write runtime array of size 1 from offset 34305 to address 0xd80b60 */
	0x6c05be31, 0x86020002, 	/* write runtime array of size 2 from offset 34306 to address 0xd80b7c */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x6c020001, 0x00000001, 	/* write 0x1 to address 0xd80400 */
	0x00010002, 0x002e0000, 	/* if mode != 'mf_sd', skip 1 ops */
	0x6c024c01, 0x00000001, 	/* write 0x1 to address 0xd80498 */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x6c022801, 0x00000018, 	/* write 0x18 to address 0xd80450 */
	0x00020002, 0x00240000, 	/* if mode != '!e5', skip 2 ops */
	0x6c010201, 0x00000000, 	/* write 0x0 to address 0xd80204 */
	0x6c010a01, 0x00000000, 	/* write 0x0 to address 0xd80214 */
	0x6c000001, 0x00000001, 	/* write 0x1 to address 0xd80000 */
	0x6c000001, 0x00000000, 	/* write 0x0 to address 0xd80000 */
	0x000c0013, 0xffff0001, 	/* if phase != 'port', skip 12 ops  */
	0x6c025801, 0x00000082, 	/* write 0x82 to address 0xd804b0 */
	0x6c025e01, 0x00000080, 	/* write 0x80 to address 0xd804bc */
	0x6c026821, 0x0001e556, 	/* write array of size 2 from offset 124246 to address 0xd804d0 */
	0x6c026e21, 0x0001e559, 	/* write array of size 2 from offset 124249 to address 0xd804dc */
	0x6c027a01, 0x00000000, 	/* write 0x0 to address 0xd804f4 */
	0x6c028c21, 0x0001e55c, 	/* write array of size 2 from offset 124252 to address 0xd80518 */
	0x6c029201, 0x00000000, 	/* write 0x0 to address 0xd80524 */
	0x6c02e031, 0x85c70001, 	/* write runtime array of size 1 from offset 34247 to address 0xd805c0 */
	0x00010002, 0x002e0000, 	/* if mode != 'mf_sd', skip 1 ops */
	0x6c025c01, 0x00000082, 	/* write 0x82 to address 0xd804b8 */
	0x00010002, 0x00d20000, 	/* if mode != 'sf|mf_si', skip 1 ops */
	0x6c025c01, 0x00000000, 	/* write 0x0 to address 0xd804b8 */
	/* RDIF */
	0x00040013, 0xffff0000, 	/* if phase != 'engine', skip 4 ops  */
	0x18002201, 0x00000000, 	/* write 0x0 to address 0x300044 */
	0x1800c201, 0x00000000, 	/* write 0x0 to address 0x300184 */
	0x1800ca01, 0x00000000, 	/* write 0x0 to address 0x300194 */
	0x18000001, 0x00000001, 	/* write 0x1 to address 0x300000 */
	/* TDIF */
	0x00070013, 0xffff0000, 	/* if phase != 'engine', skip 7 ops  */
	0x1880c201, 0x00000000, 	/* write 0x0 to address 0x310184 */
	0x1880ca01, 0x00000000, 	/* write 0x0 to address 0x310194 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x18810201, 0x00000020, 	/* write 0x20 to address 0x310204 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x18810201, 0x00000000, 	/* write 0x0 to address 0x310204 */
	0x18800001, 0x00000001, 	/* write 0x1 to address 0x310000 */
	/* CDU */
	0x00990013, 0xffff0000, 	/* if phase != 'engine', skip 153 ops  */
	0x2c00e601, 0x00000000, 	/* write 0x0 to address 0x5801cc */
	0x2c048031, 0x85b90003, 	/* write runtime array of size 3 from offset 34233 to address 0x580900 */
	0x007e0002, 0x00010000, 	/* if mode != 'bb|k2', skip 126 ops */
	0x2c080121, 0x0001e55f, 	/* write array of size 9 from offset 124255 to address 0x581000 (WB) */
	0x2c082121, 0x0001e569, 	/* write array of size 9 from offset 124265 to address 0x581040 (WB) */
	0x2c084121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581080 (WB) */
	0x2c086121, 0x0001e57d, 	/* write array of size 9 from offset 124285 to address 0x5810c0 (WB) */
	0x2c088121, 0x0001e587, 	/* write array of size 9 from offset 124295 to address 0x581100 (WB) */
	0x2c08a121, 0x0001e591, 	/* write array of size 9 from offset 124305 to address 0x581140 (WB) */
	0x2c08c121, 0x0001e59b, 	/* write array of size 9 from offset 124315 to address 0x581180 (WB) */
	0x2c08e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5811c0 (WB) */
	0x2c090121, 0x0001e5a5, 	/* write array of size 9 from offset 124325 to address 0x581200 (WB) */
	0x2c092121, 0x0001e5af, 	/* write array of size 9 from offset 124335 to address 0x581240 (WB) */
	0x2c094121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581280 (WB) */
	0x2c096121, 0x0001e5b9, 	/* write array of size 9 from offset 124345 to address 0x5812c0 (WB) */
	0x2c098121, 0x0001e5c3, 	/* write array of size 9 from offset 124355 to address 0x581300 (WB) */
	0x2c09a121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581340 (WB) */
	0x2c09c121, 0x0001e5d7, 	/* write array of size 9 from offset 124375 to address 0x581380 (WB) */
	0x2c09e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5813c0 (WB) */
	0x2c0a0121, 0x0001e5e1, 	/* write array of size 9 from offset 124385 to address 0x581400 (WB) */
	0x2c0a2121, 0x0001e569, 	/* write array of size 9 from offset 124265 to address 0x581440 (WB) */
	0x2c0a4121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581480 (WB) */
	0x2c0a6121, 0x0001e5eb, 	/* write array of size 9 from offset 124395 to address 0x5814c0 (WB) */
	0x2c0a8121, 0x0001e587, 	/* write array of size 9 from offset 124295 to address 0x581500 (WB) */
	0x2c0aa121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581540 (WB) */
	0x2c0ac121, 0x0001e5f5, 	/* write array of size 9 from offset 124405 to address 0x581580 (WB) */
	0x2c0ae121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5815c0 (WB) */
	0x2c0b0121, 0x0001e5ff, 	/* write array of size 9 from offset 124415 to address 0x581600 (WB) */
	0x2c0b2121, 0x0001e5af, 	/* write array of size 9 from offset 124335 to address 0x581640 (WB) */
	0x2c0b4121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581680 (WB) */
	0x2c0b6121, 0x0001e609, 	/* write array of size 9 from offset 124425 to address 0x5816c0 (WB) */
	0x2c0b8121, 0x0001e613, 	/* write array of size 9 from offset 124435 to address 0x581700 (WB) */
	0x2c0ba121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581740 (WB) */
	0x2c0bc121, 0x0001e61d, 	/* write array of size 9 from offset 124445 to address 0x581780 (WB) */
	0x2c0be121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5817c0 (WB) */
	0x2c0c0121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581800 (WB) */
	0x2c0c2121, 0x0001e627, 	/* write array of size 9 from offset 124455 to address 0x581840 (WB) */
	0x2c0c4121, 0x0001e631, 	/* write array of size 9 from offset 124465 to address 0x581880 (WB) */
	0x2c0c6121, 0x0001e609, 	/* write array of size 9 from offset 124425 to address 0x5818c0 (WB) */
	0x2c0c8121, 0x0001e63b, 	/* write array of size 9 from offset 124475 to address 0x581900 (WB) */
	0x2c0ca121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581940 (WB) */
	0x2c0cc121, 0x0001e645, 	/* write array of size 9 from offset 124485 to address 0x581980 (WB) */
	0x2c0ce121, 0x0001e64f, 	/* write array of size 9 from offset 124495 to address 0x5819c0 (WB) */
	0x2c0d0121, 0x0001e659, 	/* write array of size 9 from offset 124505 to address 0x581a00 (WB) */
	0x2c0d2121, 0x0001e569, 	/* write array of size 9 from offset 124265 to address 0x581a40 (WB) */
	0x2c0d4121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581a80 (WB) */
	0x2c0d6121, 0x0001e57d, 	/* write array of size 9 from offset 124285 to address 0x581ac0 (WB) */
	0x2c0d8121, 0x0001e587, 	/* write array of size 9 from offset 124295 to address 0x581b00 (WB) */
	0x2c0da121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581b40 (WB) */
	0x2c0dc121, 0x0001e663, 	/* write array of size 9 from offset 124515 to address 0x581b80 (WB) */
	0x2c0de121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581bc0 (WB) */
	0x2c0e0121, 0x0001e659, 	/* write array of size 9 from offset 124505 to address 0x581c00 (WB) */
	0x2c0e2121, 0x0001e569, 	/* write array of size 9 from offset 124265 to address 0x581c40 (WB) */
	0x2c0e4121, 0x0001e66d, 	/* write array of size 9 from offset 124525 to address 0x581c80 (WB) */
	0x2c0e6121, 0x0001e57d, 	/* write array of size 9 from offset 124285 to address 0x581cc0 (WB) */
	0x2c0e8121, 0x0001e587, 	/* write array of size 9 from offset 124295 to address 0x581d00 (WB) */
	0x2c0ea121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581d40 (WB) */
	0x2c0ec121, 0x0001e677, 	/* write array of size 9 from offset 124535 to address 0x581d80 (WB) */
	0x2c0ee121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581dc0 (WB) */
	0x2c0f0121, 0x0001e659, 	/* write array of size 9 from offset 124505 to address 0x581e00 (WB) */
	0x2c0f2121, 0x0001e681, 	/* write array of size 9 from offset 124545 to address 0x581e40 (WB) */
	0x2c0f4121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581e80 (WB) */
	0x2c0f6121, 0x0001e57d, 	/* write array of size 9 from offset 124285 to address 0x581ec0 (WB) */
	0x2c0f8121, 0x0001e587, 	/* write array of size 9 from offset 124295 to address 0x581f00 (WB) */
	0x2c0fa121, 0x0001e5cd, 	/* write array of size 9 from offset 124365 to address 0x581f40 (WB) */
	0x2c0fc121, 0x0001e68b, 	/* write array of size 9 from offset 124555 to address 0x581f80 (WB) */
	0x2c0fe121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x581fc0 (WB) */
	0x2c110121, 0x0001e695, 	/* write array of size 9 from offset 124565 to address 0x582200 (WB) */
	0x2c112121, 0x0001e69f, 	/* write array of size 9 from offset 124575 to address 0x582240 (WB) */
	0x2c114121, 0x0001e6a9, 	/* write array of size 9 from offset 124585 to address 0x582280 (WB) */
	0x2c116121, 0x0001e6b3, 	/* write array of size 9 from offset 124595 to address 0x5822c0 (WB) */
	0x2c118121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582300 (WB) */
	0x2c11a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582340 (WB) */
	0x2c11c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582380 (WB) */
	0x2c11e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5823c0 (WB) */
	0x2c120121, 0x0001e6bd, 	/* write array of size 9 from offset 124605 to address 0x582400 (WB) */
	0x2c122121, 0x0001e6c7, 	/* write array of size 9 from offset 124615 to address 0x582440 (WB) */
	0x2c124121, 0x0001e6d1, 	/* write array of size 9 from offset 124625 to address 0x582480 (WB) */
	0x2c126121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5824c0 (WB) */
	0x2c128121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582500 (WB) */
	0x2c12a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582540 (WB) */
	0x2c12c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582580 (WB) */
	0x2c12e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5825c0 (WB) */
	0x2c130121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582600 (WB) */
	0x2c132121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582640 (WB) */
	0x2c134121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582680 (WB) */
	0x2c136121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5826c0 (WB) */
	0x2c138121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582700 (WB) */
	0x2c13a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582740 (WB) */
	0x2c13c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582780 (WB) */
	0x2c13e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5827c0 (WB) */
	0x2c140121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582800 (WB) */
	0x2c142121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582840 (WB) */
	0x2c144121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582880 (WB) */
	0x2c146121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5828c0 (WB) */
	0x2c148121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582900 (WB) */
	0x2c14a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582940 (WB) */
	0x2c14c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582980 (WB) */
	0x2c14e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5829c0 (WB) */
	0x2c150121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582a00 (WB) */
	0x2c152121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582a40 (WB) */
	0x2c154121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582a80 (WB) */
	0x2c156121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582ac0 (WB) */
	0x2c158121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582b00 (WB) */
	0x2c15a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582b40 (WB) */
	0x2c15c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582b80 (WB) */
	0x2c15e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582bc0 (WB) */
	0x2c160121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582c00 (WB) */
	0x2c162121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582c40 (WB) */
	0x2c164121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582c80 (WB) */
	0x2c166121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582cc0 (WB) */
	0x2c168121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582d00 (WB) */
	0x2c16a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582d40 (WB) */
	0x2c16c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582d80 (WB) */
	0x2c16e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582dc0 (WB) */
	0x2c170121, 0x0001e6db, 	/* write array of size 9 from offset 124635 to address 0x582e00 (WB) */
	0x2c172121, 0x0001e6c7, 	/* write array of size 9 from offset 124615 to address 0x582e40 (WB) */
	0x2c174121, 0x0001e6e5, 	/* write array of size 9 from offset 124645 to address 0x582e80 (WB) */
	0x2c176121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582ec0 (WB) */
	0x2c178121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582f00 (WB) */
	0x2c17a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582f40 (WB) */
	0x2c17c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582f80 (WB) */
	0x2c17e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582fc0 (WB) */
	0x2c180121, 0x0001e6ef, 	/* write array of size 64 from offset 124655 to address 0x583000 (WB) */
	0x2c189121, 0x0001e730, 	/* write array of size 16 from offset 124720 to address 0x583120 (WB) */
	0x2c18b111, 0x00000020, 	/* write 32 zeros to address 0x583160 (WB) */
	0x2c18f121, 0x0001e741, 	/* write array of size 8 from offset 124737 to address 0x5831e0 (WB) */
	0x2c191121, 0x0001e730, 	/* write array of size 16 from offset 124720 to address 0x583220 (WB) */
	0x2c193111, 0x00000008, 	/* write 8 zeros to address 0x583260 (WB) */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x2c010201, 0x00000000, 	/* write 0x0 to address 0x580204 */
	0x000a0002, 0x00620000, 	/* if mode != '(bb|k2)&(!fpga)', skip 10 ops */
	0x2c100121, 0x0001e74a, 	/* write array of size 9 from offset 124746 to address 0x582000 (WB) */
	0x2c102121, 0x0001e754, 	/* write array of size 9 from offset 124756 to address 0x582040 (WB) */
	0x2c104121, 0x0001e75e, 	/* write array of size 9 from offset 124766 to address 0x582080 (WB) */
	0x2c106121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5820c0 (WB) */
	0x2c108121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582100 (WB) */
	0x2c10a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582140 (WB) */
	0x2c10c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582180 (WB) */
	0x2c10e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5821c0 (WB) */
	0x2c188121, 0x0001e768, 	/* write array of size 8 from offset 124776 to address 0x583100 (WB) */
	0x2c190121, 0x0001e768, 	/* write array of size 8 from offset 124776 to address 0x583200 (WB) */
	0x000a0002, 0x00680000, 	/* if mode != 'fpga&(bb|k2)', skip 10 ops */
	0x2c100121, 0x0001e771, 	/* write array of size 9 from offset 124785 to address 0x582000 (WB) */
	0x2c102121, 0x0001e754, 	/* write array of size 9 from offset 124756 to address 0x582040 (WB) */
	0x2c104121, 0x0001e77b, 	/* write array of size 9 from offset 124795 to address 0x582080 (WB) */
	0x2c106121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5820c0 (WB) */
	0x2c108121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582100 (WB) */
	0x2c10a121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582140 (WB) */
	0x2c10c121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x582180 (WB) */
	0x2c10e121, 0x0001e573, 	/* write array of size 9 from offset 124275 to address 0x5821c0 (WB) */
	0x2c188121, 0x0001e768, 	/* write array of size 8 from offset 124776 to address 0x583100 (WB) */
	0x2c190121, 0x0001e768, 	/* write array of size 8 from offset 124776 to address 0x583200 (WB) */
	0x00010013, 0xffff0002, 	/* if phase != 'pf', skip 1 ops  */
	0x2c048631, 0x85bc000a, 	/* write runtime array of size 10 from offset 34236 to address 0x58090c */
	/* CCFC */
	0x00150013, 0xffff0000, 	/* if phase != 'engine', skip 21 ops  */
	0x1700c201, 0x00000000, 	/* write 0x0 to address 0x2e0184 */
	0x1702a821, 0x0001e785, 	/* write array of size 2 from offset 124805 to address 0x2e0550 */
	0x1702ea01, 0x00000001, 	/* write 0x1 to address 0x2e05d4 */
	0x1702f401, 0x00000000, 	/* write 0x0 to address 0x2e05e8 */
	0x17048021, 0x0001e788, 	/* write array of size 14 from offset 124808 to address 0x2e0900 */
	0x17500001, 0x00000000, 	/* write 0x0 to address 0x2ea000 */
	0x17527e01, 0x00000000, 	/* write 0x0 to address 0x2ea4fc */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x1702e001, 0x000e0000, 	/* write 0xe0000 to address 0x2e05c0 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x17010201, 0x00000000, 	/* write 0x0 to address 0x2e0204 */
	0x00020002, 0x00200000, 	/* if mode != 'emul_reduced|fpga', skip 2 ops */
	0x1703c201, 0x00000004, 	/* write 0x4 to address 0x2e0784 */
	0x17000001, 0x00001c5f, 	/* write 0x1c5f to address 0x2e0000 */
	0x00010002, 0x00950000, 	/* if mode != 'asic|emul_full|chipsim', skip 1 ops */
	0x17000001, 0x00001e7f, 	/* write 0x1e7f to address 0x2e0000 */
	0x17000210, 0x00000001, 	/* wait until address 0x2e0004 reads 0x1 */
	0x17000410, 0x00000001, 	/* wait until address 0x2e0008 reads 0x1 */
	0x17000610, 0x00000001, 	/* wait until address 0x2e000c reads 0x1 */
	0x17000810, 0x00000001, 	/* wait until address 0x2e0010 reads 0x1 */
	0x17038e01, 0x0000f820, 	/* write 0xf820 to address 0x2e071c */
	0x00020013, 0xffff0002, 	/* if phase != 'pf', skip 2 ops  */
	0x17038001, 0x00000001, 	/* write 0x1 to address 0x2e0700 */
	0x17038401, 0x00000001, 	/* write 0x1 to address 0x2e0708 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0x17038201, 0x00000001, 	/* write 0x1 to address 0x2e0704 */
	/* TCFC */
	0x00160013, 0xffff0000, 	/* if phase != 'engine', skip 22 ops  */
	0x1680c201, 0x00000000, 	/* write 0x0 to address 0x2d0184 */
	0x1682aa01, 0x0001ffff, 	/* write 0x1ffff to address 0x2d0554 */
	0x1682ea01, 0x00000001, 	/* write 0x1 to address 0x2d05d4 */
	0x1682f401, 0x00000000, 	/* write 0x0 to address 0x2d05e8 */
	0x16848021, 0x0001e797, 	/* write array of size 14 from offset 124823 to address 0x2d0900 */
	0x16d00001, 0x00000000, 	/* write 0x0 to address 0x2da000 */
	0x16d27e01, 0x00000000, 	/* write 0x0 to address 0x2da4fc */
	0x00030002, 0x00020000, 	/* if mode != 'bb', skip 3 ops */
	0x1682e001, 0x000e0000, 	/* write 0xe0000 to address 0x2d05c0 */
	0x16838801, 0x0000ffff, 	/* write 0xffff to address 0x2d0710 */
	0x1683c001, 0x00000002, 	/* write 0x2 to address 0x2d0780 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x16810201, 0x00000000, 	/* write 0x0 to address 0x2d0204 */
	0x00010002, 0x00200000, 	/* if mode != 'emul_reduced|fpga', skip 1 ops */
	0x16800001, 0x00001c5f, 	/* write 0x1c5f to address 0x2d0000 */
	0x00010002, 0x00950000, 	/* if mode != 'asic|emul_full|chipsim', skip 1 ops */
	0x16800001, 0x00001e7f, 	/* write 0x1e7f to address 0x2d0000 */
	0x16800210, 0x00000001, 	/* wait until address 0x2d0004 reads 0x1 */
	0x16800410, 0x00000001, 	/* wait until address 0x2d0008 reads 0x1 */
	0x16800610, 0x00000001, 	/* wait until address 0x2d000c reads 0x1 */
	0x16800810, 0x00000001, 	/* wait until address 0x2d0010 reads 0x1 */
	0x16838e01, 0x0000f820, 	/* write 0xf820 to address 0x2d071c */
	0x00020013, 0xffff0002, 	/* if phase != 'pf', skip 2 ops  */
	0x16838001, 0x00000001, 	/* write 0x1 to address 0x2d0700 */
	0x16838401, 0x00000001, 	/* write 0x1 to address 0x2d0708 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0x16838201, 0x00000001, 	/* write 0x1 to address 0x2d0704 */
	/* IGU */
	0x00070013, 0xffff0000, 	/* if phase != 'engine', skip 7 ops  */
	0x0c00c201, 0x000001d0, 	/* write 0x1d0 to address 0x180184 */
	0x0c00ca01, 0x00000000, 	/* write 0x0 to address 0x180194 */
	0x00020002, 0x00020000, 	/* if mode != 'bb', skip 2 ops */
	0x0c010201, 0x00000000, 	/* write 0x0 to address 0x180204 */
	0x0c010a01, 0x00000000, 	/* write 0x0 to address 0x180214 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x0c010201, 0x00000000, 	/* write 0x0 to address 0x180204 */
	0x00050013, 0xffff0002, 	/* if phase != 'pf', skip 5 ops  */
	0x0c041031, 0x00140002, 	/* write runtime array of size 2 from offset 20 to address 0x180820 */
	0x0c041831, 0x00170001, 	/* write runtime array of size 1 from offset 23 to address 0x180830 */
	0x0c090801, 0x00000001, 	/* write 0x1 to address 0x181210 */
	0x0c041631, 0x00160001, 	/* write runtime array of size 1 from offset 22 to address 0x18082c */
	0x0c040031, 0x00120001, 	/* write runtime array of size 1 from offset 18 to address 0x180800 */
	0x00010013, 0xffff0003, 	/* if phase != 'vf', skip 1 ops  */
	0x0c040231, 0x00130001, 	/* write runtime array of size 1 from offset 19 to address 0x180804 */
	/* CAU */
	0x00160013, 0xffff0000, 	/* if phase != 'engine', skip 22 ops  */
	0x0e007001, 0x00000000, 	/* write 0x0 to address 0x1c00e0 */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x0e010201, 0x00000000, 	/* write 0x0 to address 0x1c0204 */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x0e010201, 0x00000000, 	/* write 0x0 to address 0x1c0204 */
	0x0e020801, 0x0000001f, 	/* write 0x1f to address 0x1c0410 */
	0x0e030231, 0x00180001, 	/* write runtime array of size 1 from offset 24 to address 0x1c0604 */
	0x0e020810, 0x00000000, 	/* wait until address 0x1c0410 reads 0x0 */
	0x000c0002, 0x00010000, 	/* if mode != 'bb|k2', skip 12 ops */
	0x0e220021, 0x0001e7a6, 	/* write array of size 5 from offset 124838 to address 0x1c4400 */
	0x0e220a11, 0x0000000a, 	/* write 10 zeros to address 0x1c4414 */
	0x0e221e21, 0x0001e7ac, 	/* write array of size 6 from offset 124844 to address 0x1c443c */
	0x0e222a11, 0x0000000a, 	/* write 10 zeros to address 0x1c4454 */
	0x0e223e21, 0x0001e7b3, 	/* write array of size 6 from offset 124851 to address 0x1c447c */
	0x0e224a11, 0x0000000a, 	/* write 10 zeros to address 0x1c4494 */
	0x0e225e21, 0x0001e7ba, 	/* write array of size 5 from offset 124858 to address 0x1c44bc */
	0x0e226811, 0x0000000b, 	/* write 11 zeros to address 0x1c44d0 */
	0x0e227e21, 0x0001e7c0, 	/* write array of size 6 from offset 124864 to address 0x1c44fc */
	0x0e228a11, 0x0000000a, 	/* write 10 zeros to address 0x1c4514 */
	0x0e229e01, 0x00008004, 	/* write 0x8004 to address 0x1c453c */
	0x0e22a011, 0x000000b0, 	/* write 176 zeros to address 0x1c4540 */
	0x0e300131, 0x02f902e0, 	/* write runtime array of size 736 from offset 761 to address 0x1c6000 (WB) */
	0x00030013, 0xffff0002, 	/* if phase != 'pf', skip 3 ops  */
	0x0e300131, 0x02f902e0, 	/* write runtime array of size 736 from offset 761 to address 0x1c6000 (WB) */
	0x0e400131, 0x05d902e0, 	/* write runtime array of size 736 from offset 1497 to address 0x1c8000 (WB) */
	0x0e800031, 0x08b91140, 	/* write runtime array of size 4416 from offset 2233 to address 0x1d0000 */
	/* DBG */
	0x00010013, 0xffff0000, 	/* if phase != 'engine', skip 1 ops  */
	0x0080c201, 0x00000000, 	/* write 0x0 to address 0x10184 */
	/* NIG */
	0x00210013, 0xffff0000, 	/* if phase != 'engine', skip 33 ops  */
	0x28002a01, 0x00000000, 	/* write 0x0 to address 0x500054 */
	0x28003201, 0x00000000, 	/* write 0x0 to address 0x500064 */
	0x28004201, 0x00000000, 	/* write 0x0 to address 0x500084 */
	0x28040231, 0x85430001, 	/* write runtime array of size 1 from offset 34115 to address 0x500804 */
	0x00070002, 0x00020000, 	/* if mode != 'bb', skip 7 ops */
	0x28002201, 0x00000040, 	/* write 0x40 to address 0x500044 */
	0x28005201, 0x00000000, 	/* write 0x0 to address 0x5000a4 */
	0x28010201, 0x00000000, 	/* write 0x0 to address 0x500204 */
	0x28011201, 0x00000000, 	/* write 0x0 to address 0x500224 */
	0x28011a01, 0x00000000, 	/* write 0x0 to address 0x500234 */
	0x28041e01, 0x00000002, 	/* write 0x2 to address 0x50083c */
	0x2845ae01, 0x00000001, 	/* write 0x1 to address 0x508b5c */
	0x00050002, 0x00030000, 	/* if mode != 'k2', skip 5 ops */
	0x28007401, 0x00000001, 	/* write 0x1 to address 0x5000e8 */
	0x28010201, 0x00000000, 	/* write 0x0 to address 0x500204 */
	0x28011201, 0x00000000, 	/* write 0x0 to address 0x500224 */
	0x28011a01, 0x00000000, 	/* write 0x0 to address 0x500234 */
	0x28483401, 0x00000000, 	/* write 0x0 to address 0x509068 */
	0x00010002, 0x002e0000, 	/* if mode != 'mf_sd', skip 1 ops */
	0x28040e01, 0x00000001, 	/* write 0x1 to address 0x50081c */
	0x00020002, 0x002c0000, 	/* if mode != '!bb', skip 2 ops */
	0x28005201, 0x00000000, 	/* write 0x0 to address 0x5000a4 */
	0x28006201, 0x00000000, 	/* write 0x0 to address 0x5000c4 */
	0x00030002, 0x00010000, 	/* if mode != 'bb|k2', skip 3 ops */
	0x28041c01, 0x00000001, 	/* write 0x1 to address 0x500838 */
	0x28042001, 0x0000070c, 	/* write 0x70c to address 0x500840 */
	0x2845a001, 0x00000081, 	/* write 0x81 to address 0x508b40 */
	0x00010002, 0x00240000, 	/* if mode != '!e5', skip 1 ops */
	0x28010a01, 0x00000000, 	/* write 0x0 to address 0x500214 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x28007201, 0x00000000, 	/* write 0x0 to address 0x5000e4 */
	0x00010002, 0x00d50000, 	/* if mode != 'k2&ports_per_eng_4', skip 1 ops */
	0x28480021, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x509000 */
	0x00080013, 0xffff0002, 	/* if phase != 'pf', skip 8 ops  */
	0x2808fa01, 0x00000000, 	/* write 0x0 to address 0x5011f4 */
	0x280b3201, 0x00000000, 	/* write 0x0 to address 0x501664 */
	0x280cd231, 0x85490001, 	/* write runtime array of size 1 from offset 34121 to address 0x5019a4 */
	0x280cd831, 0x854a000d, 	/* write runtime array of size 13 from offset 34122 to address 0x5019b0 */
	0x28447c01, 0x00000000, 	/* write 0x0 to address 0x5088f8 */
	0x00020002, 0x00010000, 	/* if mode != 'bb|k2', skip 2 ops */
	0x280d0131, 0x85570020, 	/* write runtime array of size 32 from offset 34135 to address 0x501a00 (WB) */
	0x280d4031, 0x85770040, 	/* write runtime array of size 64 from offset 34167 to address 0x501a80 */
	0x00210013, 0xffff0001, 	/* if phase != 'port', skip 33 ops  */
	0x28081201, 0x00000080, 	/* write 0x80 to address 0x501024 */
	0x28081c01, 0x00000082, 	/* write 0x82 to address 0x501038 */
	0x28082021, 0x0001e559, 	/* write array of size 2 from offset 124249 to address 0x501040 */
	0x28082c21, 0x0001e7c7, 	/* write array of size 2 from offset 124871 to address 0x501058 */
	0x2808f411, 0x00000002, 	/* write 2 zeros to address 0x5011e8 */
	0x280af001, 0x00000001, 	/* write 0x1 to address 0x5015e0 */
	0x280b2e01, 0x00000000, 	/* write 0x0 to address 0x50165c */
	0x280c8401, 0x00000001, 	/* write 0x1 to address 0x501908 */
	0x280cc831, 0x85440005, 	/* write runtime array of size 5 from offset 34116 to address 0x501990 */
	0x280ddc21, 0x0001e7ca, 	/* write array of size 2 from offset 124874 to address 0x501bb8 */
	0x280e0601, 0x1954fc40, 	/* write 0x1954fc40 to address 0x501c0c */
	0x280f8631, 0x85b70001, 	/* write runtime array of size 1 from offset 34231 to address 0x501f0c */
	0x280fa801, 0x00000001, 	/* write 0x1 to address 0x501f50 */
	0x28442801, 0x00000001, 	/* write 0x1 to address 0x508850 */
	0x28447831, 0x85b80001, 	/* write runtime array of size 1 from offset 34232 to address 0x5088f0 */
	0x28459411, 0x00000002, 	/* write 2 zeros to address 0x508b28 */
	0x28459c01, 0x000017c1, 	/* write 0x17c1 to address 0x508b38 */
	0x00010002, 0x00030000, 	/* if mode != 'k2', skip 1 ops */
	0x28459001, 0x00000001, 	/* write 0x1 to address 0x508b20 */
	0x00010002, 0x003c0000, 	/* if mode != 'sf', skip 1 ops */
	0x280cae01, 0x00000000, 	/* write 0x0 to address 0x50195c */
	0x00020002, 0x002e0000, 	/* if mode != 'mf_sd', skip 2 ops */
	0x28080c01, 0x00000083, 	/* write 0x83 to address 0x501018 */
	0x28081001, 0x00000082, 	/* write 0x82 to address 0x501020 */
	0x00010002, 0x004e0000, 	/* if mode != '100g', skip 1 ops */
	0x28448021, 0x00000136, 	/* write array of size 8 from offset 310 to address 0x508900 */
	0x00010002, 0x00010000, 	/* if mode != 'bb|k2', skip 1 ops */
	0x28458601, 0x000012b7, 	/* write 0x12b7 to address 0x508b0c */
	0x00020002, 0x00d20000, 	/* if mode != 'sf|mf_si', skip 2 ops */
	0x28080c01, 0x00000082, 	/* write 0x82 to address 0x501018 */
	0x28081001, 0x00000000, 	/* write 0x0 to address 0x501020 */
	0x00010002, 0x003b0000, 	/* if mode != '!sf', skip 1 ops */
	0x280cae01, 0x00000001, 	/* write 0x1 to address 0x50195c */
	0x000c0013, 0x00000001, 	/* if phase != 'port0', skip 12 ops  */
	0x00010002, 0x00810000, 	/* if mode != 'k2&sf&ports_per_eng_1', skip 1 ops */
	0x280cb821, 0x0001e7cd, 	/* write array of size 8 from offset 124877 to address 0x501970 */
	0x00010002, 0x007c0000, 	/* if mode != 'k2&sf&ports_per_eng_2', skip 1 ops */
	0x280cb821, 0x0001e7cd, 	/* write array of size 8 from offset 124877 to address 0x501970 */
	0x00010002, 0x00770000, 	/* if mode != 'k2&sf&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x00000129, 	/* write array of size 4 from offset 297 to address 0x501970 */
	0x00010002, 0x00380000, 	/* if mode != 'k2&(!sf)&ports_per_eng_1', skip 1 ops */
	0x280cb821, 0x0001e7d6, 	/* write array of size 8 from offset 124886 to address 0x501970 */
	0x00010002, 0x00500000, 	/* if mode != 'k2&(!sf)&ports_per_eng_2', skip 1 ops */
	0x280cb821, 0x0001e7d6, 	/* write array of size 8 from offset 124886 to address 0x501970 */
	0x00010002, 0x003e0000, 	/* if mode != 'k2&(!sf)&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x0001e7df, 	/* write array of size 4 from offset 124895 to address 0x501970 */
	0x000a0013, 0x00010001, 	/* if phase != 'port1', skip 10 ops  */
	0x00010002, 0x00b80000, 	/* if mode != '(!k2)&ports_per_eng_2', skip 1 ops */
	0x280cb801, 0x00000001, 	/* write 0x1 to address 0x501970 */
	0x00010002, 0x007c0000, 	/* if mode != 'k2&sf&ports_per_eng_2', skip 1 ops */
	0x280cb821, 0x0001e7cd, 	/* write array of size 8 from offset 124877 to address 0x501970 */
	0x00010002, 0x00770000, 	/* if mode != 'k2&sf&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x00000129, 	/* write array of size 4 from offset 297 to address 0x501970 */
	0x00010002, 0x00500000, 	/* if mode != 'k2&(!sf)&ports_per_eng_2', skip 1 ops */
	0x280cb821, 0x0001e7e4, 	/* write array of size 8 from offset 124900 to address 0x501970 */
	0x00010002, 0x003e0000, 	/* if mode != 'k2&(!sf)&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x0001e7ed, 	/* write array of size 4 from offset 124909 to address 0x501970 */
	0x00040013, 0x00020001, 	/* if phase != 'port2', skip 4 ops  */
	0x00010002, 0x00770000, 	/* if mode != 'k2&sf&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x00000129, 	/* write array of size 4 from offset 297 to address 0x501970 */
	0x00010002, 0x003e0000, 	/* if mode != 'k2&(!sf)&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x0001e7f2, 	/* write array of size 4 from offset 124914 to address 0x501970 */
	0x00040013, 0x00030001, 	/* if phase != 'port3', skip 4 ops  */
	0x00010002, 0x00770000, 	/* if mode != 'k2&sf&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x00000129, 	/* write array of size 4 from offset 297 to address 0x501970 */
	0x00010002, 0x003e0000, 	/* if mode != 'k2&(!sf)&ports_per_eng_4', skip 1 ops */
	0x280cb821, 0x0001e7f7, 	/* write array of size 4 from offset 124919 to address 0x501970 */
	0x00010013, 0xffff0001, 	/* if phase != 'port', skip 1 ops  */
	0x28070821, 0x00000035, 	/* write array of size 2 from offset 53 to address 0x500e10 */
	/* WOL */
	0x00060013, 0xffff0000, 	/* if phase != 'engine', skip 6 ops  */
	0x00010002, 0x009a0000, 	/* if mode != '(!bb)&(!fpga)', skip 1 ops */
	0x30002201, 0x00000000, 	/* write 0x0 to address 0x600044 */
	0x00010002, 0x00c00000, 	/* if mode != 'k2&(!fpga)', skip 1 ops */
	0x30010201, 0x00000000, 	/* write 0x0 to address 0x600204 */
	0x00010002, 0x002a0000, 	/* if mode != '((!bb)&mf_sd)&(!fpga)', skip 1 ops */
	0x3040ce01, 0x00000001, 	/* write 0x1 to address 0x60819c */
	/* BMBN */
	0x00040013, 0xffff0000, 	/* if phase != 'engine', skip 4 ops  */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x30802201, 0x00000000, 	/* write 0x0 to address 0x610044 */
	0x00010002, 0x002b0000, 	/* if mode != '(!bb)&mf_sd', skip 1 ops */
	0x3080fc01, 0x00000001, 	/* write 0x1 to address 0x6101f8 */
	/* NWM */
	0x00050013, 0xffff0000, 	/* if phase != 'engine', skip 5 ops  */
	0x00040002, 0x00900000, 	/* if mode != '(!asic)&(!bb)', skip 4 ops */
	0x40000401, 0x00000000, 	/* write 0x0 to address 0x800008 */
	0x40010201, 0x00000000, 	/* write 0x0 to address 0x800204 */
	0x40010a01, 0x00000000, 	/* write 0x0 to address 0x800214 */
	0x40011201, 0x0000003c, 	/* write 0x3c to address 0x800224 */
	/* NWS */
	0x00030013, 0xffff0000, 	/* if phase != 'engine', skip 3 ops  */
	0x00020002, 0x00900000, 	/* if mode != '(!asic)&(!bb)', skip 2 ops */
	0x3800c201, 0x000003fe, 	/* write 0x3fe to address 0x700184 */
	0x38010201, 0x00000000, 	/* write 0x0 to address 0x700204 */
	/* MS */
	0x00020013, 0xffff0000, 	/* if phase != 'engine', skip 2 ops  */
	0x00010002, 0x009a0000, 	/* if mode != '(!bb)&(!fpga)', skip 1 ops */
	0x3500c201, 0x00000000, 	/* write 0x0 to address 0x6a0184 */
	/* MISC_AEU */
	0x00360013, 0xffff0000, 	/* if phase != 'engine', skip 54 ops  */
	0x00010002, 0x00020000, 	/* if mode != 'bb', skip 1 ops */
	0x13000111, 0x00003b60, 	/* write 15200 zeros to address 0x260000 (WB) */
	0x00010002, 0x002c0000, 	/* if mode != '!bb', skip 1 ops */
	0x13000111, 0x000055f0, 	/* write 22000 zeros to address 0x260000 (WB) */
	0x00300002, 0x00010000, 	/* if mode != 'bb|k2', skip 48 ops */
	0x80057e01, 0x01030012, 	/* write 0x1030012 to address 0x1000afc */
	0x84057201, 0x010a0012, 	/* write 0x10a0012 to address 0x1080ae4 */
	0x88056201, 0x010a0012, 	/* write 0x10a0012 to address 0x1100ac4 */
	0x8c057401, 0x010a0012, 	/* write 0x10a0012 to address 0x1180ae8 */
	0x90057601, 0x010a0012, 	/* write 0x10a0012 to address 0x1200aec */
	0x94058401, 0x010a0012, 	/* write 0x10a0012 to address 0x1280b08 */
	0x80057e01, 0x04000000, 	/* write 0x4000000 to address 0x1000afc */
	0x84057201, 0x04000000, 	/* write 0x4000000 to address 0x1080ae4 */
	0x88056201, 0x04000000, 	/* write 0x4000000 to address 0x1100ac4 */
	0x8c057401, 0x04000000, 	/* write 0x4000000 to address 0x1180ae8 */
	0x90057601, 0x04000000, 	/* write 0x4000000 to address 0x1200aec */
	0x94058401, 0x04000000, 	/* write 0x4000000 to address 0x1280b08 */
	0x80057e01, 0x00000000, 	/* write 0x0 to address 0x1000afc */
	0x84057201, 0x00000000, 	/* write 0x0 to address 0x1080ae4 */
	0x88056201, 0x00000000, 	/* write 0x0 to address 0x1100ac4 */
	0x8c057401, 0x00000000, 	/* write 0x0 to address 0x1180ae8 */
	0x90057601, 0x00000000, 	/* write 0x0 to address 0x1200aec */
	0x94058401, 0x00000000, 	/* write 0x0 to address 0x1280b08 */
	0x80057e01, 0x00000000, 	/* write 0x0 to address 0x1000afc */
	0x84057201, 0x00000000, 	/* write 0x0 to address 0x1080ae4 */
	0x88056201, 0x00000000, 	/* write 0x0 to address 0x1100ac4 */
	0x8c057401, 0x00000000, 	/* write 0x0 to address 0x1180ae8 */
	0x90057601, 0x00000000, 	/* write 0x0 to address 0x1200aec */
	0x94058401, 0x00000000, 	/* write 0x0 to address 0x1280b08 */
	0x80057e01, 0x01030012, 	/* write 0x1030012 to address 0x1000afc */
	0x84057201, 0x010a0012, 	/* write 0x10a0012 to address 0x1080ae4 */
	0x88056201, 0x010a0012, 	/* write 0x10a0012 to address 0x1100ac4 */
	0x8c057401, 0x010a0012, 	/* write 0x10a0012 to address 0x1180ae8 */
	0x90057601, 0x010a0012, 	/* write 0x10a0012 to address 0x1200aec */
	0x94058401, 0x010a0012, 	/* write 0x10a0012 to address 0x1280b08 */
	0x80057e01, 0x04000000, 	/* write 0x4000000 to address 0x1000afc */
	0x84057201, 0x04000000, 	/* write 0x4000000 to address 0x1080ae4 */
	0x88056201, 0x04000000, 	/* write 0x4000000 to address 0x1100ac4 */
	0x8c057401, 0x04000000, 	/* write 0x4000000 to address 0x1180ae8 */
	0x90057601, 0x04000000, 	/* write 0x4000000 to address 0x1200aec */
	0x94058401, 0x04000000, 	/* write 0x4000000 to address 0x1280b08 */
	0x80057e01, 0x00000000, 	/* write 0x0 to address 0x1000afc */
	0x84057201, 0x00000000, 	/* write 0x0 to address 0x1080ae4 */
	0x88056201, 0x00000000, 	/* write 0x0 to address 0x1100ac4 */
	0x8c057401, 0x00000000, 	/* write 0x0 to address 0x1180ae8 */
	0x90057601, 0x00000000, 	/* write 0x0 to address 0x1200aec */
	0x94058401, 0x00000000, 	/* write 0x0 to address 0x1280b08 */
	0x80057e01, 0x00000000, 	/* write 0x0 to address 0x1000afc */
	0x84057201, 0x00000000, 	/* write 0x0 to address 0x1080ae4 */
	0x88056201, 0x00000000, 	/* write 0x0 to address 0x1100ac4 */
	0x8c057401, 0x00000000, 	/* write 0x0 to address 0x1180ae8 */
	0x90057601, 0x00000000, 	/* write 0x0 to address 0x1200aec */
	0x94058401, 0x00000000, 	/* write 0x0 to address 0x1280b08 */
	0x00441401, 0x00000003, 	/* write 0x3 to address 0x8828 */
};
/* Data size: 28152 bytes */

ARRAY_DECL u16 init_ops_size = 0xdbf;

/* block command offsets array */
ARRAY_DECL u16 init_ops_offsets[] = {
	0x0000, 0x0004, 0x0004, 0x000b, 0x000b, 0x0047, 0x0000, 0x0000, 0x0047, 
	0x006a, 0x006a, 0x0071, 0x0071, 0x0074, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0074, 0x0079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0079, 
	0x0084, 0x0084, 0x0087, 0x0087, 0x008a, 0x008a, 0x0092, 0x0092, 0x0095, 
	0x0095, 0x009d, 0x009d, 0x00a0, 0x00a0, 0x00af, 0x00af, 0x00b2, 0x00b2, 
	0x00b7, 0x00b7, 0x00ef, 0x00ef, 0x0181, 0x0181, 0x022a, 0x022a, 0x02b6, 
	0x02b6, 0x02cb, 0x02cb, 0x0399, 0x0399, 0x03a7, 0x03a7, 0x042a, 0x042a, 
	0x0449, 0x0449, 0x04c6, 0x04c6, 0x05f1, 0x05f1, 0x05f8, 0x05f8, 0x0665, 
	0x0665, 0x066d, 0x066d, 0x0674, 0x0674, 0x067c, 0x067c, 0x0684, 0x0684, 
	0x068b, 0x068b, 0x0692, 0x0692, 0x0770, 0x0770, 0x083f, 0x083f, 0x0904, 
	0x0904, 0x09dd, 0x09dd, 0x0a93, 0x0a93, 0x0b63, 0x0b63, 0x0b69, 0x0b69, 
	0x0b6d, 0x0b6d, 0x0b77, 0x0b77, 0x0b7b, 0x0b7b, 0x0b7f, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0b7f, 0x0b8d, 0x0b8d, 0x0b90, 0x0b90, 0x0b93, 0x0b93, 
	0x0b96, 0x0b96, 0x0bad, 0x0bad, 0x0bf1, 0x0bf1, 0x0bf6, 0x0bf6, 0x0bfe, 
	0x0bfe, 0x0c9a, 0x0c9a, 0x0cb5, 0x0cb5, 0x0cd1, 0x0cd1, 0x0ce1, 0x0ce1, 
	0x0cfc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0cfc, 0x0cfe, 0x0cfe, 0x0d6f, 0x0d6f, 
	0x0d76, 0x0d76, 0x0d7b, 0x0000, 0x0000, 0x0d7b, 0x0d81, 0x0d81, 0x0d85, 
	0x0d85, 0x0d88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d88, 
	0x0dbf, 0x0000, 0x0000, 
};
/* Data size: 348 bytes */

/* Raw values array */
ARRAY_DECL u32 init_val[] = {
	0x00000030, 0x00000085, 0x00000000, 0x00000000, 0x00000030, 0x000061a8, 
	0x00000019, 0x000009c4, 0x00000030, 0x00000004, 0x00000000, 0x00000000, 
	0x00000030, 0x0000000a, 0x00000000, 0x00000000, 0x00000040, 0x00005120, 
	0x0000000f, 0x00000004, 0x00010168, 0x00000040, 0x00005360, 0x0000007f, 
	0x00000007, 0x00000080, 0x00000040, 0x00008550, 0x0000003f, 0x00000006, 
	0x000001f8, 0x00000030, 0x00004e58, 0x00000007, 0x00000003, 0x00000030, 
	0x00006268, 0x00000007, 0x00000003, 0x00000040, 0x00003348, 0x0000007f, 
	0x00000007, 0x000000e0, 0x00000060, 0x00000008, 0x00000010, 0x00000008, 
	0x00000008, 0x00000000, 0x00000000, 0x00000312, 0x00000001, 0x00000212, 
	0x00000001, 0x000005a1, 0xcf159c78, 0x000261b9, 0x4340c300, 0xadf093c2, 
	0xcd1e68c4, 0x571471a3, 0x49de54a8, 0x7921c8ca, 0x9a8e4653, 0x29a3f232, 
	0x329abf23, 0x9194d272, 0x5c8ca6b3, 0xaae46534, 0x9a7f2329, 0x29aff232, 
	0x194d3723, 0xc8ca6bb9, 0x9e465343, 0xd2f2329a, 0xc3bebd94, 0x34cc00f9, 
	0x0000e119, 0x00000030, 0x00000041, 0x00000068, 0x00000081, 0x00000020, 
	0x000000c1, 0x00000021, 0x00000020, 0x00000001, 0x00000004, 0x00000030, 
	0x00000004, 0x00000003, 0x00000004, 0x00000080, 0x0000000f, 0x00000000, 
	0x00000001, 0x0000000f, 0x00000004, 0x00000007, 0x00000000, 0x00000003, 
	0x00000050, 0x00000001, 0x00000004, 0x00000000, 0x00000000, 0x00000004, 
	0x00000020, 0x00000004, 0x00000000, 0x00000020, 0x00000041, 0x0000006c, 
	0x00000030, 0x00000001, 0x00000002, 0x00000002, 0x00000040, 0x00000007, 
	0x00000004, 0x00000003, 0x00000006, 0x00000050, 0x00000008, 0x00000006, 
	0x00000001, 0x00000007, 0x00000007, 0x00000050, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000003, 0x00000050, 0x00000011, 0x000000c1, 
	0x00000021, 0x000000a1, 0x00000041, 0x00000212, 0x00000002, 0x00000412, 
	0x00000002, 0x00000030, 0x00000003, 0x00000002, 0x00000002, 0x00000100, 
	0x0000000d, 0x00000001, 0x00000005, 0x00000001, 0x0000000a, 0x00000005, 
	0x0000000d, 0x00000001, 0x00000003, 0x00000000, 0x00000001, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000070, 0x00000002, 
	0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000741, 0xce159c78, 0x40830011, 0xcfc00000, 0xc30c30c2, 0x61861861, 
	0x61870c38, 0x18618618, 0x1861870e, 0x0c30c30e, 0x0bf38377, 0x21210871, 
	0x41e72325, 0x4d454941, 0x179693c3, 0x23033d1d, 0x6f0b3313, 0xec6cac3e, 
	0xb938397c, 0x085109b8, 0x19290931, 0x4a0a0f39, 0x9e1a6a2a, 0xe8e8bcb4, 
	0x98991819, 0x61f37859, 0xcbe76365, 0x1dc5c9c1, 0x07e103fd, 0x211f437b, 
	0x00000100, 0x00000041, 0x00000061, 0x00000081, 0x00000001, 0x00000011, 
	0x000000c1, 0x00000021, 0x000000a1, 0x00000008, 0x00000005, 0x00000004, 
	0x00000009, 0x00000009, 0x00000008, 0x00000008, 0x00000006, 0x00000080, 
	0x0000000b, 0x0000000f, 0x0000000c, 0x0000000f, 0x0000000f, 0x0000000b, 
	0x0000000b, 0x0000000a, 0x00000030, 0x00000008, 0x00000005, 0x00000004, 
	0x00000030, 0x00000008, 0x00000008, 0x00000006, 0x00000020, 0x0000000a, 
	0x0000000b, 0x00000040, 0x00008000, 0x00010000, 0x00018000, 0x00000000, 
	0x00000040, 0x00000009, 0x00000003, 0x00000008, 0x00000001, 0x00000030, 
	0x00000009, 0x00000009, 0x0000000a, 0x0001c012, 0x03b9aca0, 0x0001c012, 
	0x83b9aca0, 0x00020012, 0x03b9aca0, 0x00020012, 0x83b9aca0, 0x00000020, 
	0x00000078, 0x00000060, 0x00000070, 0x00000060, 0x00000070, 0x00000070, 
	0x00000070, 0x00000078, 0x00000078, 0x00000078, 0x00000212, 0x00000078, 
	0x00000080, 0x0000001f, 0x0000001f, 0x0000001f, 0x0000001f, 0x0000001c, 
	0x0000001f, 0x0000001f, 0x0000001f, 0x00000212, 0x00000006, 0x00000212, 
	0x0000000a, 0x00000712, 0x0000000a, 0x00000812, 0x000000ff, 0x00001212, 
	0x00818000, 0x00000212, 0x000025e4, 0x00000040, 0x00000000, 0x00000001, 
	0x00000002, 0x00000003, 0x00000212, 0x00818000, 0x00000812, 0x00000002, 
	0x00000812, 0x00000004, 0x00000812, 0x00000001, 0x00000812, 0x00000008, 
	0x00000020, 0x00000038, 0x00000002, 0x00000020, 0x00000021, 0x00000020, 
	0x00000212, 0x00000010, 0x00000020, 0x00000034, 0x00000004, 0x00000020, 
	0x0000000c, 0x00000014, 0x00000030, 0x00000083, 0x00000005, 0x00000011, 
	0x00000030, 0x0000001f, 0x00000010, 0x00000020, 0x00000412, 0x000005c0, 
	0x00000030, 0x000000a0, 0x000000a0, 0x00000060, 0x00000030, 0x00000080, 
	0x00000080, 0x00000050, 0x00000212, 0x00000360, 0x00000060, 0x00000360, 
	0x00000000, 0x00000360, 0x00000360, 0x00000000, 0x00000360, 0x00000212, 
	0x00000400, 0x00000060, 0x00000400, 0x00000000, 0x00000400, 0x00000400, 
	0x00000000, 0x00000400, 0x00000030, 0x000000e0, 0x00000360, 0x000000e0, 
	0x00000030, 0x000000e0, 0x00000360, 0x00000058, 0x00000040, 0x00000058, 
	0x000000e0, 0x00000360, 0x00000058, 0x00000030, 0x00000180, 0x00000400, 
	0x00000180, 0x00000030, 0x00000180, 0x00000400, 0x000000f8, 0x00000040, 
	0x000000f8, 0x00000180, 0x00000400, 0x000000f8, 0x00000020, 0x00000ad0, 
	0x00000000, 0x00000020, 0x000012c0, 0x00000000, 0x00000030, 0x00000320, 
	0x00000320, 0x00000190, 0x00000020, 0x00000738, 0x000012c1, 0x00000020, 
	0x000007d8, 0x000012c1, 0x00000212, 0x000012c1, 0x00000212, 0x000005b0, 
	0x00000212, 0x00000960, 0x00000030, 0x00000178, 0x00000178, 0x000000a0, 
	0x00000030, 0x000000a0, 0x000000a0, 0x00000050, 0x00000030, 0x000003c8, 
	0x00000000, 0x000003c8, 0x00000040, 0x000003c8, 0x000003c8, 0x00000000, 
	0x000003c8, 0x00000030, 0x00000468, 0x00000000, 0x00000468, 0x00000040, 
	0x00000468, 0x00000468, 0x00000000, 0x00000468, 0x00000030, 0x000000f8, 
	0x000003c8, 0x000000f8, 0x00000030, 0x000000f8, 0x000003c8, 0x00000070, 
	0x00000030, 0x00000198, 0x00000468, 0x00000198, 0x00000030, 0x00000198, 
	0x00000468, 0x00000110, 0x00000020, 0x000005b8, 0x00000000, 0x00000020, 
	0x00000960, 0x00000000, 0x00000030, 0x00000168, 0x00000168, 0x000000c8, 
	0x00000312, 0x00000050, 0x00000020, 0x000003f4, 0x000012c1, 0x00000020, 
	0x00000444, 0x000012c1, 0x00000030, 0x000000d4, 0x000003f4, 0x000000d4, 
	0x00000020, 0x000000d4, 0x000003f4, 0x00000030, 0x00000124, 0x00000444, 
	0x00000124, 0x00000030, 0x00000124, 0x00000444, 0x000000c0, 0x00000030, 
	0x000000c0, 0x000012c1, 0x000012c1, 0x00000040, 0x000003d8, 0x000003d8, 
	0x00000000, 0x00000000, 0x00000040, 0x00000780, 0x00000780, 0x00000000, 
	0x00000000, 0x00000030, 0x00000190, 0x00000190, 0x00000078, 0x00000040, 
	0x00000010, 0x00000190, 0x00000190, 0x00000078, 0x00000030, 0x00000050, 
	0x00000050, 0x00000028, 0x00000040, 0x00000008, 0x00000050, 0x00000050, 
	0x00000028, 0x00000060, 0x00000000, 0x0000029c, 0x0000029c, 0x00000000, 
	0x0000029c, 0x00000000, 0x00000060, 0x00000000, 0x000002ec, 0x000002ec, 
	0x00000000, 0x000002ec, 0x00000000, 0x00000030, 0x000000bc, 0x0000029c, 
	0x000000bc, 0x00000212, 0x00001e01, 0x00000030, 0x000000bc, 0x0000029c, 
	0x00000058, 0x00000312, 0x00001e01, 0x00000040, 0x00000058, 0x000000bc, 
	0x0000029c, 0x00000058, 0x00000040, 0x00001e01, 0x00001e01, 0x00001e01, 
	0x00000058, 0x00000030, 0x0000010c, 0x000002ec, 0x0000010c, 0x00000030, 
	0x0000010c, 0x000002ec, 0x000000a8, 0x00000040, 0x000000a8, 0x0000010c, 
	0x000002ec, 0x000000a8, 0x00000040, 0x00001e01, 0x00001e01, 0x00001e01, 
	0x000000a8, 0x00000212, 0x000000a0, 0x00000212, 0x00000007, 0x00000020, 
	0xffffffff, 0x0000ffff, 0x00000030, 0x00000070, 0x00000078, 0x00000078, 
	0x00000050, 0x00000002, 0x00000078, 0x0000007e, 0x00000078, 0x0000007e, 
	0x00000020, 0x00000078, 0x0000007e, 0x00000040, 0x0000000f, 0x00000002, 
	0x0000000f, 0x00000025, 0x00000040, 0x0000000f, 0x00000064, 0x0000000f, 
	0x0000001e, 0x00000050, 0x00000001, 0x0000000e, 0x0000000e, 0x00000001, 
	0x00000001, 0x00000080, 0x00000013, 0x00000011, 0x00000018, 0x00000012, 
	0x00000001, 0x00039351, 0x00011061, 0x00019482, 0x00000070, 0x00011016, 
	0x000394c2, 0x00039325, 0x000194a1, 0x00000011, 0x00000182, 0x00000004, 
	0x00000030, 0x00000082, 0x00000000, 0x00000080, 0x00000020, 0x00000001, 
	0x00000000, 0x00000020, 0x00000083, 0x00000082, 0x00000020, 0x00000082, 
	0x00000000, 0x00000020, 0x00000305, 0x00000314, 0x00000020, 0x00000306, 
	0x00000329, 0x00000030, 0x0000030b, 0x0000030c, 0x0000030e, 0x00000050, 
	0x00000305, 0x0000020b, 0x0000020d, 0x0000030f, 0x00000310, 0x00000030, 
	0x00000007, 0x00000003, 0x0000003f, 0x00000060, 0x0001000a, 0x00131208, 
	0x58cdb22b, 0x00000000, 0x010201ff, 0x00400804, 0x00000020, 0x00000010, 
	0x00000000, 0x00003fe0, 0x010017e4, 0x00000100, 0x000017e6, 0x00000000, 
	0x00000000, 0x00000000, 0x000017e8, 0x00000000, 0x00000000, 0x00000000, 
	0x000017ea, 0x00000000, 0x00000000, 0x00000000, 0x000017ec, 0x00000000, 
	0x00000000, 0x00000000, 0x000017ee, 0x00000000, 0x00000000, 0x00000000, 
	0x000017f0, 0x00000000, 0x00000000, 0x00000000, 0x000017f2, 0x00000000, 
	0x00000000, 0x00000000, 0x000017f4, 0x00000000, 0x00000000, 0x00000000, 
	0x000017f6, 0x00000000, 0x00000000, 0x00000000, 0x000017f8, 0x00000000, 
	0x00000000, 0x00000000, 0x000017fa, 0x00000000, 0x00000000, 0x00000000, 
	0x000017fc, 0x00000000, 0x00000000, 0x00000000, 0x000017fe, 0x00000000, 
	0x00000000, 0x00000000, 0x00001800, 0x00000000, 0x00000000, 0x00000000, 
	0x00001802, 0x00000000, 0x00000000, 0x00000000, 0x00001804, 0x00000000, 
	0x00000000, 0x00000000, 0x00001806, 0x00000000, 0x00000000, 0x00000000, 
	0x00001808, 0x00000000, 0x00000000, 0x00000000, 0x0000180a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000180c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000180e, 0x00000000, 0x00000000, 0x00000000, 0x00001810, 0x00000000, 
	0x00000000, 0x00000000, 0x00001812, 0x00000000, 0x00000000, 0x00000000, 
	0x00001814, 0x00000000, 0x00000000, 0x00000000, 0x00001816, 0x00000000, 
	0x00000000, 0x00000000, 0x00001818, 0x00000000, 0x00000000, 0x00000000, 
	0x0000181a, 0x00000000, 0x00000000, 0x00000000, 0x0000181c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000181e, 0x00000000, 0x00000000, 0x00000000, 
	0x00001820, 0x00000000, 0x00000000, 0x00000000, 0x00001822, 0x00000000, 
	0x00000000, 0x00000000, 0x00001824, 0x00000000, 0x00000000, 0x00000000, 
	0x00001826, 0x00000000, 0x00000000, 0x00000000, 0x00001828, 0x00000000, 
	0x00000000, 0x00000000, 0x0000182a, 0x00000000, 0x00000000, 0x00000000, 
	0x0000182c, 0x00000000, 0x00000000, 0x00000000, 0x0000182e, 0x00000000, 
	0x00000000, 0x00000000, 0x00001830, 0x00000000, 0x00000000, 0x00000000, 
	0x00001832, 0x00000000, 0x00000000, 0x00000000, 0x00001834, 0x00000000, 
	0x00000000, 0x00000000, 0x00001836, 0x00000000, 0x00000000, 0x00000000, 
	0x00001838, 0x00000000, 0x00000000, 0x00000000, 0x0000183a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000183c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000183e, 0x00000000, 0x00000000, 0x00000000, 0x00001840, 0x00000000, 
	0x00000000, 0x00000000, 0x00001842, 0x00000000, 0x00000000, 0x00000000, 
	0x00001844, 0x00000000, 0x00000000, 0x00000000, 0x00001846, 0x00000000, 
	0x00000000, 0x00000000, 0x00001848, 0x00000000, 0x00000000, 0x00000000, 
	0x0000184a, 0x00000000, 0x00000000, 0x00000000, 0x0000184c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000184e, 0x00000000, 0x00000000, 0x00000000, 
	0x00001850, 0x00000000, 0x00000000, 0x00000000, 0x00001852, 0x00000000, 
	0x00000000, 0x00000000, 0x00001854, 0x00000000, 0x00000000, 0x00000000, 
	0x00001856, 0x00000000, 0x00000000, 0x00000000, 0x00001858, 0x00000000, 
	0x00000000, 0x00000000, 0x0000185a, 0x00000000, 0x00000000, 0x00000000, 
	0x0000185c, 0x00000000, 0x00000000, 0x00000000, 0x0000185e, 0x00000000, 
	0x00000000, 0x00000000, 0x00001860, 0x00000000, 0x00000000, 0x00000000, 
	0x00001862, 0x00000000, 0x00000000, 0x00000000, 0x00001864, 0x00000000, 
	0x00000000, 0x00000000, 0x00001866, 0x00000000, 0x00000000, 0x00000000, 
	0x00001868, 0x00000000, 0x00000000, 0x00000000, 0x0000186a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000186c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000186e, 0x00000000, 0x00000000, 0x00000000, 0x00001870, 0x00000000, 
	0x00000000, 0x00000000, 0x00001872, 0x00000000, 0x00000000, 0x00000000, 
	0x00001874, 0x00000000, 0x00000000, 0x00000000, 0x00001876, 0x00000000, 
	0x00000000, 0x00000000, 0x00001878, 0x00000000, 0x00000000, 0x00000000, 
	0x0000187a, 0x00000000, 0x00000000, 0x00000000, 0x0000187c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000187e, 0x00000000, 0x00000000, 0x00000000, 
	0x00001880, 0x00000000, 0x00000000, 0x00000000, 0x00001882, 0x00000000, 
	0x00000000, 0x00000000, 0x00001884, 0x00000000, 0x00000000, 0x00000000, 
	0x00001886, 0x00000000, 0x00000000, 0x00000000, 0x00001888, 0x00000000, 
	0x00000000, 0x00000000, 0x0000188a, 0x00000000, 0x00000000, 0x00000000, 
	0x0000188c, 0x00000000, 0x00000000, 0x00000000, 0x0000188e, 0x00000000, 
	0x00000000, 0x00000000, 0x00001890, 0x00000000, 0x00000000, 0x00000000, 
	0x00001892, 0x00000000, 0x00000000, 0x00000000, 0x00001894, 0x00000000, 
	0x00000000, 0x00000000, 0x00001896, 0x00000000, 0x00000000, 0x00000000, 
	0x00001898, 0x00000000, 0x00000000, 0x00000000, 0x0000189a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000189c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000189e, 0x00000000, 0x00000000, 0x00000000, 0x000018a0, 0x00000000, 
	0x00000000, 0x00000000, 0x000018a2, 0x00000000, 0x00000000, 0x00000000, 
	0x000018a4, 0x00000000, 0x00000000, 0x00000000, 0x000018a6, 0x00000000, 
	0x00000000, 0x00000000, 0x000018a8, 0x00000000, 0x00000000, 0x00000000, 
	0x000018aa, 0x00000000, 0x00000000, 0x00000000, 0x000018ac, 0x00000000, 
	0x00000000, 0x00000000, 0x000018ae, 0x00000000, 0x00000000, 0x00000000, 
	0x000018b0, 0x00000000, 0x00000000, 0x00000000, 0x000018b2, 0x00000000, 
	0x00000000, 0x00000000, 0x000018b4, 0x00000000, 0x00000000, 0x00000000, 
	0x000018b6, 0x00000000, 0x00000000, 0x00000000, 0x000018b8, 0x00000000, 
	0x00000000, 0x00000000, 0x000018ba, 0x00000000, 0x00000000, 0x00000000, 
	0x000018bc, 0x00000000, 0x00000000, 0x00000000, 0x000018be, 0x00000000, 
	0x00000000, 0x00000000, 0x000018c0, 0x00000000, 0x00000000, 0x00000000, 
	0x000018c2, 0x00000000, 0x00000000, 0x00000000, 0x000018c4, 0x00000000, 
	0x00000000, 0x00000000, 0x000018c6, 0x00000000, 0x00000000, 0x00000000, 
	0x000018c8, 0x00000000, 0x00000000, 0x00000000, 0x000018ca, 0x00000000, 
	0x00000000, 0x00000000, 0x000018cc, 0x00000000, 0x00000000, 0x00000000, 
	0x000018ce, 0x00000000, 0x00000000, 0x00000000, 0x000018d0, 0x00000000, 
	0x00000000, 0x00000000, 0x000018d2, 0x00000000, 0x00000000, 0x00000000, 
	0x000018d4, 0x00000000, 0x00000000, 0x00000000, 0x000018d6, 0x00000000, 
	0x00000000, 0x00000000, 0x000018d8, 0x00000000, 0x00000000, 0x00000000, 
	0x000018da, 0x00000000, 0x00000000, 0x00000000, 0x000018dc, 0x00000000, 
	0x00000000, 0x00000000, 0x000018de, 0x00000000, 0x00000000, 0x00000000, 
	0x000018e0, 0x00000000, 0x00000000, 0x00000000, 0x000018e2, 0x00000000, 
	0x00000000, 0x00000000, 0x000018e4, 0x00000000, 0x00000000, 0x00000000, 
	0x000018e6, 0x00000000, 0x00000000, 0x00000000, 0x000018e8, 0x00000000, 
	0x00000000, 0x00000000, 0x000018ea, 0x00000000, 0x00000000, 0x00000000, 
	0x000018ec, 0x00000000, 0x00000000, 0x00000000, 0x000018ee, 0x00000000, 
	0x00000000, 0x00000000, 0x000018f0, 0x00000000, 0x00000000, 0x00000000, 
	0x000018f2, 0x00000000, 0x00000000, 0x00000000, 0x000018f4, 0x00000000, 
	0x00000000, 0x00000000, 0x000018f6, 0x00000000, 0x00000000, 0x00000000, 
	0x000018f8, 0x00000000, 0x00000000, 0x00000000, 0x000018fa, 0x00000000, 
	0x00000000, 0x00000000, 0x000018fc, 0x00000000, 0x00000000, 0x00000000, 
	0x000018fe, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 
	0x00000000, 0x00000000, 0x00001902, 0x00000000, 0x00000000, 0x00000000, 
	0x00001904, 0x00000000, 0x00000000, 0x00000000, 0x00001906, 0x00000000, 
	0x00000000, 0x00000000, 0x00001908, 0x00000000, 0x00000000, 0x00000000, 
	0x0000190a, 0x00000000, 0x00000000, 0x00000000, 0x0000190c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000190e, 0x00000000, 0x00000000, 0x00000000, 
	0x00001910, 0x00000000, 0x00000000, 0x00000000, 0x00001912, 0x00000000, 
	0x00000000, 0x00000000, 0x00001914, 0x00000000, 0x00000000, 0x00000000, 
	0x00001916, 0x00000000, 0x00000000, 0x00000000, 0x00001918, 0x00000000, 
	0x00000000, 0x00000000, 0x0000191a, 0x00000000, 0x00000000, 0x00000000, 
	0x0000191c, 0x00000000, 0x00000000, 0x00000000, 0x0000191e, 0x00000000, 
	0x00000000, 0x00000000, 0x00001920, 0x00000000, 0x00000000, 0x00000000, 
	0x00001922, 0x00000000, 0x00000000, 0x00000000, 0x00001924, 0x00000000, 
	0x00000000, 0x00000000, 0x00001926, 0x00000000, 0x00000000, 0x00000000, 
	0x00001928, 0x00000000, 0x00000000, 0x00000000, 0x0000192a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000192c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000192e, 0x00000000, 0x00000000, 0x00000000, 0x00001930, 0x00000000, 
	0x00000000, 0x00000000, 0x00001932, 0x00000000, 0x00000000, 0x00000000, 
	0x00001934, 0x00000000, 0x00000000, 0x00000000, 0x00001936, 0x00000000, 
	0x00000000, 0x00000000, 0x00001938, 0x00000000, 0x00000000, 0x00000000, 
	0x0000193a, 0x00000000, 0x00000000, 0x00000000, 0x0000193c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000193e, 0x00000000, 0x00000000, 0x00000000, 
	0x00001940, 0x00000000, 0x00000000, 0x00000000, 0x00001942, 0x00000000, 
	0x00000000, 0x00000000, 0x00001944, 0x00000000, 0x00000000, 0x00000000, 
	0x00001946, 0x00000000, 0x00000000, 0x00000000, 0x00001948, 0x00000000, 
	0x00000000, 0x00000000, 0x0000194a, 0x00000000, 0x00000000, 0x00000000, 
	0x0000194c, 0x00000000, 0x00000000, 0x00000000, 0x0000194e, 0x00000000, 
	0x00000000, 0x00000000, 0x00001950, 0x00000000, 0x00000000, 0x00000000, 
	0x00001952, 0x00000000, 0x00000000, 0x00000000, 0x00001954, 0x00000000, 
	0x00000000, 0x00000000, 0x00001956, 0x00000000, 0x00000000, 0x00000000, 
	0x00001958, 0x00000000, 0x00000000, 0x00000000, 0x0000195a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000195c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000195e, 0x00000000, 0x00000000, 0x00000000, 0x00001960, 0x00000000, 
	0x00000000, 0x00000000, 0x00001962, 0x00000000, 0x00000000, 0x00000000, 
	0x00001964, 0x00000000, 0x00000000, 0x00000000, 0x00001966, 0x00000000, 
	0x00000000, 0x00000000, 0x00001968, 0x00000000, 0x00000000, 0x00000000, 
	0x0000196a, 0x00000000, 0x00000000, 0x00000000, 0x0000196c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000196e, 0x00000000, 0x00000000, 0x00000000, 
	0x00001970, 0x00000000, 0x00000000, 0x00000000, 0x00001972, 0x00000000, 
	0x00000000, 0x00000000, 0x00001974, 0x00000000, 0x00000000, 0x00000000, 
	0x00001976, 0x00000000, 0x00000000, 0x00000000, 0x00001978, 0x00000000, 
	0x00000000, 0x00000000, 0x0000197a, 0x00000000, 0x00000000, 0x00000000, 
	0x0000197c, 0x00000000, 0x00000000, 0x00000000, 0x0000197e, 0x00000000, 
	0x00000000, 0x00000000, 0x00001980, 0x00000000, 0x00000000, 0x00000000, 
	0x00001982, 0x00000000, 0x00000000, 0x00000000, 0x00001984, 0x00000000, 
	0x00000000, 0x00000000, 0x00001986, 0x00000000, 0x00000000, 0x00000000, 
	0x00001988, 0x00000000, 0x00000000, 0x00000000, 0x0000198a, 0x00000000, 
	0x00000000, 0x00000000, 0x0000198c, 0x00000000, 0x00000000, 0x00000000, 
	0x0000198e, 0x00000000, 0x00000000, 0x00000000, 0x00001990, 0x00000000, 
	0x00000000, 0x00000000, 0x00001992, 0x00000000, 0x00000000, 0x00000000, 
	0x00001994, 0x00000000, 0x00000000, 0x00000000, 0x00001996, 0x00000000, 
	0x00000000, 0x00000000, 0x00001998, 0x00000000, 0x00000000, 0x00000000, 
	0x0000199a, 0x00000000, 0x00000000, 0x00000000, 0x0000199c, 0x00000000, 
	0x00000000, 0x00000000, 0x0000199e, 0x00000000, 0x00000000, 0x00000000, 
	0x000019a0, 0x00000000, 0x00000000, 0x00000000, 0x000019a2, 0x00000000, 
	0x00000000, 0x00000000, 0x000019a4, 0x00000000, 0x00000000, 0x00000000, 
	0x000019a6, 0x00000000, 0x00000000, 0x00000000, 0x000019a8, 0x00000000, 
	0x00000000, 0x00000000, 0x000019aa, 0x00000000, 0x00000000, 0x00000000, 
	0x000019ac, 0x00000000, 0x00000000, 0x00000000, 0x000019ae, 0x00000000, 
	0x00000000, 0x00000000, 0x000019b0, 0x00000000, 0x00000000, 0x00000000, 
	0x000019b2, 0x00000000, 0x00000000, 0x00000000, 0x000019b4, 0x00000000, 
	0x00000000, 0x00000000, 0x000019b6, 0x00000000, 0x00000000, 0x00000000, 
	0x000019b8, 0x00000000, 0x00000000, 0x00000000, 0x000019ba, 0x00000000, 
	0x00000000, 0x00000000, 0x000019bc, 0x00000000, 0x00000000, 0x00000000, 
	0x000019be, 0x00000000, 0x00000000, 0x00000000, 0x000019c0, 0x00000000, 
	0x00000000, 0x00000000, 0x000019c2, 0x00000000, 0x00000000, 0x00000000, 
	0x000019c4, 0x00000000, 0x00000000, 0x00000000, 0x000019c6, 0x00000000, 
	0x00000000, 0x00000000, 0x000019c8, 0x00000000, 0x00000000, 0x00000000, 
	0x000019ca, 0x00000000, 0x00000000, 0x00000000, 0x000019cc, 0x00000000, 
	0x00000000, 0x00000000, 0x000019ce, 0x00000000, 0x00000000, 0x00000000, 
	0x000019d0, 0x00000000, 0x00000000, 0x00000000, 0x000019d2, 0x00000000, 
	0x00000000, 0x00000000, 0x000019d4, 0x00000000, 0x00000000, 0x00000000, 
	0x000019d6, 0x00000000, 0x00000000, 0x00000000, 0x000019d8, 0x00000000, 
	0x00000000, 0x00000000, 0x000019da, 0x00000000, 0x00000000, 0x00000000, 
	0x000019dc, 0x00000000, 0x00000000, 0x00000000, 0x000019de, 0x00000000, 
	0x00000000, 0x00000000, 0x000019e0, 0x00000000, 0x00000000, 0x00000000, 
	0x000019e2, 0x00000000, 0x00000000, 0x00000000, 0x00000010, 0xffffffff, 
	0x00000410, 0x00000001, 0x00000000, 0x00000002, 0x00000000, 0x00000003, 
	0x00000000, 0x04010003, 0x00000000, 0x00000000, 0x00000000, 0x04010000, 
	0x00000000, 0x10000101, 0x00000000, 0x00000102, 0x00000000, 0x00000103, 
	0x00000000, 0x04010103, 0x00000000, 0x10000100, 0x00000000, 0x14010100, 
	0x00000000, 0x10000200, 0x00000000, 0x00030504, 0x000000ff, 0x00030504, 
	0x000000ff, 0x00030504, 0x000000ff, 0x00030504, 0x000000ff, 0x00030504, 
	0x000000ff, 0x00030504, 0x000000ff, 0x1c000300, 0x00000000, 0x1c000400, 
	0x00000000, 0x00030504, 0x000000ff, 0x04020003, 0x00000000, 0x04020000, 
	0x00000000, 0x00030504, 0x000000ff, 0x00030504, 0x000000ff, 0x00030504, 
	0x000000ff, 0x00030504, 0x000000ff, 0x00030504, 0x000000ff, 0x00030504, 
	0x000000ff, 0x00030504, 0x000000ff, 0x00030504, 0x000000ff, 0x00010290, 
	0x00000612, 0x00010001, 0x00000090, 0x00020002, 0x00040003, 0x00080006, 
	0x0010000b, 0x001f0015, 0x003e0029, 0x007b0052, 0x00f600a4, 0x01ec0148, 
	0x00000040, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x000001a0, 
	0x01000010, 0x00000000, 0x02000030, 0x00000000, 0x03000010, 0x00000000, 
	0x00000014, 0x00000000, 0x00020014, 0x00000000, 0x00000114, 0x00000000, 
	0x00020114, 0x00000000, 0x04000000, 0x00000000, 0x0001001c, 0x00000000, 
	0x0001011c, 0x00000000, 0x02000048, 0x00000000, 0x03000020, 0x00000000, 
	0x00000000, 0x00000000, 0x00000020, 0x01760a00, 0x00000018, 0x00000020, 
	0x00000000, 0xbfff0000, 0x000000e0, 0xfff9ff81, 0x00000fff, 0xfff9ff85, 
	0x00000fff, 0x00003dc1, 0x00000ffe, 0x000ffdc1, 0x00000ffe, 0xffffe3ef, 
	0x00000fff, 0xffffffe1, 0x00000fff, 0x01ffffc1, 0x00000ffe, 0x00010012, 
	0x001e2166, 0x0003b691, 0x7dcd9c78, 0xd5547c0b, 0x77b9f899, 0x3267bcee, 
	0x10c81093, 0x80610c02, 0x8d031480, 0x1b846024, 0x34101008, 0xa5ac0b50, 
	0x0828a275, 0x6b16a6b4, 0x99ded56c, 0x8f209804, 0xab830544, 0xaa54506d, 
	0x6dd11776, 0xf7ffe3e3, 0xab82b006, 0x96dd58db, 0x00eee96e, 0xba6ee351, 
	0x1b765d4b, 0xbffcba6d, 0x4799b9c7, 0xfbb6b040, 0x7b57e7fb, 0x7b9ef738, 
	0xfbfbdf1e, 0x9cce77ce, 0xdcee773b, 0xf109efe6, 0x684561df, 0x84b842f5, 
	0x08abbfb0, 0x27ec33f8, 0x19cc4262, 0xc0ee4f09, 0x6ef318ba, 0x335ffe02, 
	0xe92718c7, 0x98e318fd, 0xf7e4e710, 0xe344269a, 0x162ed47b, 0x28ec0b73, 
	0x82ed8ad6, 0xa866eef0, 0xfa0d6b86, 0xb19ba12e, 0x472cf085, 0x63378d18, 
	0x9a34d373, 0x73aef885, 0x05ff10a8, 0xc66112d5, 0x68dd3be8, 0xad45fe86, 
	0x870eb46e, 0x4f680ef6, 0xb0e79bfd, 0x24306f7d, 0xb3097e5a, 0x06109858, 
	0x8bb7b7cc, 0x424d7aeb, 0xbd56851c, 0x037e780e, 0xd10cabd4, 0x15421714, 
	0x9df884a3, 0x9947a710, 0xf38a2331, 0x879c1433, 0x31f7f0b3, 0x5d750751, 
	0xb7980dd8, 0xf3c77273, 0x671a614d, 0xe798f88c, 0x81a1cf8f, 0xc5c138fd, 
	0x480177b4, 0x89391b1e, 0x31f42be7, 0x936811c7, 0x27b1156a, 0x803e1e0d, 
	0x93822ec7, 0x2ff30cd2, 0xebb97f83, 0x22b5cf53, 0xcb9bd953, 0x819e27cf, 
	0xa6f3e571, 0xef4c4295, 0xba25d285, 0xc1a4374a, 0xe1d1c24d, 0x38467093, 
	0x192adc12, 0xfa93933f, 0xabc24361, 0x873f052e, 0x567efdc6, 0x0abfc178, 
	0xb8d4ba8d, 0xf0bd34d3, 0x3e7a66c0, 0x6b73e702, 0x4a8bf3a2, 0xdc42ea94, 
	0x4d0afd05, 0x5fe05e20, 0x4ab9fbd6, 0xc235e092, 0x8aed42dc, 0x5ea93a8e, 
	0x42c3ef84, 0x710b1429, 0xf9a25ffe, 0x71f15e8f, 0xaff40961, 0x2df36168, 
	0x90100f9c, 0xd37a02b1, 0x50104013, 0xfd720d2f, 0x692ba81a, 0x3a7808f4, 
	0x4e6f650e, 0xd45fcd33, 0x08a0ec00, 0xd894539d, 0xc7676a29, 0x02cf6979, 
	0x3c666e1c, 0xfb4d3e32, 0x4df7e871, 0x03709d4f, 0xc8b6845d, 0x27deb8f6, 
	0x6e26bfe0, 0x61141f9f, 0x1fbc1f75, 0xd0fde82d, 0x44f768a0, 0xe8d31e24, 
	0xe066b437, 0x8bdf147d, 0xa5c12d70, 0xf4c68e65, 0xa87ae923, 0xbaf3444b, 
	0xe308fbe1, 0xde46ea05, 0xf0cefa6a, 0x0f1f9d94, 0xf07e01c7, 0xc00f6769, 
	0xa2ae7c27, 0xd783b270, 0xc52c6ef5, 0xf237f0a7, 0x39b3825d, 0xed36f112, 
	0x230fa5fe, 0xfedc777c, 0x9748a3e0, 0x84e6d5e5, 0x5f007ddd, 0x1f2042fc, 
	0xc883e208, 0xd20f6aa1, 0xde5856bf, 0xde44838c, 0x06c14478, 0xf3fa6591, 
	0xbe34c7ea, 0x1abd61aa, 0xff5177ea, 0x7094900a, 0xd34ae9f4, 0x777a2943, 
	0x0aaa1ad4, 0x01948bb0, 0xdd03b4ff, 0x071a84ba, 0xf86bdbfc, 0xd77c277b, 
	0x36fd82d4, 0x2175af3c, 0x22682a9e, 0x483e474b, 0x86a9147c, 0x513200e7, 
	0x718b4151, 0x7155ab4c, 0xe4fcf6de, 0x94354490, 0x336944ab, 0xe66bb7b4, 
	0xa81bfb84, 0xf504d889, 0x91ecc68d, 0x39ffe708, 0x00185b37, 0xe2f8bdaf, 
	0x3757ac2c, 0xf04dc6fd, 0x4448f81e, 0x63b91e48, 0x258dceb0, 0x7980e161, 
	0x93b6776d, 0x0e4fb03c, 0xd4e195bb, 0xe67c429d, 0x356d4112, 0x37a89fd2, 
	0x4dd4417e, 0xf3ead2f0, 0xfdf02db5, 0x6b51419d, 0x37e14b2b, 0xefba4a68, 
	0xe7d2209b, 0xd272ebd1, 0xd7986af7, 0x6386d6a9, 0xc6b9416f, 0x77ad1cf9, 
	0x41524351, 0xa3aad57e, 0x617ad286, 0x1a17d77a, 0xe2c45fd4, 0xae7e5ae3, 
	0x9c0cc4c2, 0x446d5458, 0x0bfbd8f9, 0x0aa6e883, 0x0d9b7bf8, 0x8cde3bc0, 
	0x4e3d0235, 0x550cc9ff, 0xb6177a21, 0x6aab841e, 0xf893892a, 0x05d52efc, 
	0x9239fef3, 0x3725c83c, 0x7a05534c, 0x3764c1f6, 0x2678c13f, 0x68221ebe, 
	0x61558e7d, 0xe77c0c75, 0xcb62a84b, 0x9ebea43e, 0x078bd218, 0xf11272e1, 
	0x028773db, 0x00e9f1f0, 0x6f62585f, 0xfc5ea2b4, 0x554f8522, 0x8f631524, 
	0xf08dbfa4, 0x3aba57f9, 0x2b7ad791, 0x9472dda0, 0xe7270c5b, 0x8880b12b, 
	0x915c79ca, 0x05c69fea, 0x9dbb3bb8, 0x42dd8d93, 0xa6bc481c, 0x0f5e4128, 
	0xd9f4fbd2, 0xef815561, 0xa251d55d, 0xaecf5a1b, 0xe6b0ebc1, 0x92a9eb4d, 
	0xce50fef3, 0x7d3fd6fb, 0xac1dd3de, 0x64ffa6cf, 0xfc014daa, 0xa54df2f9, 
	0xdf7803f5, 0x0334a9d5, 0x4d43edfc, 0x64f58635, 0x03ca0775, 0x22a148fb, 
	0x76ef9c7e, 0xa869fa22, 0x59d1e018, 0x98506d19, 0xe056d50e, 0x89e81f5f, 
	0x84b1fbc6, 0xb5ded0f7, 0x5ce2a92a, 0x6d5d3ebc, 0xa9a5893e, 0x6283c334, 
	0x7a882ff8, 0x5061ea44, 0xe50c6a0b, 0x504e6387, 0xdfe798fb, 0x932bef8c, 
	0x408edbc5, 0xb2513e3f, 0xd7c98715, 0x5cbf918b, 0xf54c2245, 0x81263988, 
	0xd08b27ef, 0x99678456, 0x436b6731, 0xf3786e4a, 0x9ad63575, 0xb4ab7be2, 
	0x374ab1c6, 0xfb962fcc, 0x3658ebf9, 0x475e0eb6, 0x2b1778f6, 0xfd99d5dd, 
	0x84816558, 0xfb0fad1b, 0xca0a9b0d, 0x61915769, 0xf462818b, 0x09b12e4d, 
	0x6ace1790, 0xc118afa0, 0x09b58d49, 0x561e9ef1, 0xde894e91, 0x0f514ed0, 
	0x47afd429, 0xace961b7, 0x67486d30, 0x4dbab5ae, 0xa93c221c, 0xcea7408d, 
	0x5822a4fa, 0xde50da1f, 0x3e802bf8, 0x52b542e7, 0x5f2c6a0f, 0xa07e386d, 
	0xf8e39e06, 0x5f106607, 0x6b69970a, 0xb74abb25, 0x19d9a4b5, 0x9b510d81, 
	0x5efa01ed, 0x8295dfe4, 0x8bca404f, 0x4860f089, 0x6d7d6a7d, 0x78d5517e, 
	0x33c5c923, 0x6db8f802, 0x4fefd41c, 0x84b4f7f5, 0xd4b2c3c7, 0xc1eb995e, 
	0xbc5c93f5, 0x7207b904, 0xf7f519ae, 0x0a35e71a, 0xce4b75ea, 0xe7202245, 
	0xe72e2f72, 0x6f5be5b2, 0xfd358f50, 0xff0f6982, 0xdbd9e6b3, 0xc97fed05, 
	0x28d12ef2, 0x3080d6c4, 0x7eb6ff91, 0x814559f9, 0xfa5d6d79, 0xf58a1560, 
	0xebedd7ad, 0x277ef944, 0x0675c7ac, 0x96fe87c7, 0x7f435f23, 0xa507844d, 
	0xef2c18cb, 0xb124faed, 0xfee52939, 0xf20f7c54, 0x9e4a797c, 0xebea4ef7, 
	0x9943f634, 0x4553a67f, 0x9f2a567d, 0x89dfd2df, 0xbeb7a3a2, 0x074550f2, 
	0xb1287194, 0x8faca0fe, 0x59aef2e7, 0x0f5052df, 0xcdde96f4, 0x53b355cf, 
	0x687cd174, 0x8773b27c, 0x01d7ada7, 0x1617fdeb, 0xd06d3814, 0xd006cddf, 
	0x36f50461, 0x0f2475d0, 0x275fa8ea, 0x905b7a59, 0x9fefc69e, 0x2eedef82, 
	0x6da3895d, 0x0f49cf03, 0x387a924f, 0xffee72cc, 0x26ecb81f, 0xe153f9ba, 
	0xf7dc6b32, 0x60feae09, 0xc2f50d8d, 0x0d9a1d43, 0x763d53f9, 0x2e116357, 
	0x7c85d617, 0x2e142de7, 0x07b7da07, 0xced0d32e, 0x97ebceff, 0x56b5fb49, 
	0x59ee7a43, 0xfdda4935, 0x48c27686, 0x9c70abf1, 0x7f40a439, 0xd34fc207, 
	0x5f7e453c, 0x03df12bc, 0x66bce29d, 0xcf9bfb8d, 0x24d77e36, 0xfc606f1a, 
	0x4faa52f0, 0x22fe37da, 0xe344bfe3, 0x58bf8f64, 0x71ff0f84, 0xc4fbdb27, 
	0x9fbd9667, 0x91801f65, 0xce0ef6c7, 0x3c60e167, 0xf512e9df, 0xdf14eaca, 
	0x42a5c23b, 0xc476f685, 0x971773fb, 0x52a5bd03, 0xfe30968f, 0x5c926741, 
	0x013ca3b5, 0x9bb9e9b9, 0x326d15fd, 0xcd6685cb, 0x0732d598, 0x34f14eea, 
	0x69cd338a, 0x47dfdf34, 0xe583ed68, 0x514d7288, 0x3c216e50, 0x07404f18, 
	0x313cbf00, 0x1a9ce454, 0x8e50572c, 0x50d77bd2, 0x53be0c31, 0xed0d8683, 
	0xd60840dc, 0xdcb07272, 0xf60b19c9, 0x6f7a1af0, 0x2e91da3a, 0x8f5c3642, 
	0xd24dbf7e, 0x70754e85, 0x2e2f191b, 0xe684f09d, 0xe5b3d605, 0x37f40396, 
	0xce0e1f8d, 0xa99c3273, 0xa8615ede, 0xce8b37e8, 0xa5c754c3, 0x1a985d52, 
	0x78d919da, 0x6ffce35a, 0xc90b7c45, 0x0c6290f2, 0x67ffd14f, 0xfd59a396, 
	0xbb33c366, 0x04ae0b3f, 0x782969bf, 0x7e171c12, 0x6384fc2a, 0x1f87e7cc, 
	0xe12a21e1, 0x9e0a5cf7, 0x1285c704, 0x1c25278e, 0xd0fc3217, 0x7d54bc2f, 
	0x6cc5c961, 0x19c6b7b9, 0x51de0951, 0xca4bf786, 0x27fc5578, 0x4b984be8, 
	0x2fbe036c, 0xf1f1d351, 0x1767d297, 0x4a4bdf9a, 0x667cc645, 0x454abb8d, 
	0xd60be039, 0x82f27e33, 0x5fec6f24, 0xe9187b58, 0x1e85fedd, 0xd335f085, 
	0x1ae30978, 0x104ebf56, 0xd9438d46, 0x3f436a4f, 0xeda15c29, 0x715af781, 
	0xc886bfd7, 0xfcd92a4f, 0x03518c28, 0xfd829703, 0xc352aaf0, 0x4e8976eb, 
	0x258de3e4, 0x7fa3dfc9, 0x8fb906ef, 0x8fbf00fa, 0x8638c01d, 0x79f0c4a1, 
	0x737c4949, 0x04d9fb98, 0x4183b8fd, 0x60d317d6, 0x8768251e, 0xc5dc53b6, 
	0xa8b1c7ea, 0x47d225e1, 0xd6b4e525, 0xb4159557, 0xc38fcb2e, 0x39668979, 
	0x9b8e1efe, 0xedcec1c4, 0x53a87e2e, 0xfe24fd00, 0xe5072abe, 0x23ee624a, 
	0x98976c31, 0xda275d73, 0xced0355f, 0x4ef6fe0d, 0xf21cfd8d, 0x4fdec177, 
	0x05bae714, 0xbef29dc8, 0xfe51f83f, 0x5d0b725b, 0x692ef8c5, 0xe14aefcf, 
	0x67819fe7, 0x9f09a240, 0xf81176c6, 0xf002cd55, 0x3416991f, 0x7f00cfd0, 
	0xcc2a6aaa, 0x1fbc0ceb, 0x931def0e, 0x619f93f6, 0x4ecac2ff, 0xc7f24ea4, 
	0x147884f2, 0xbb84611c, 0x722befd5, 0xb8db1f5e, 0xbdb08f2c, 0xbb636ddf, 
	0x7d0fd1ed, 0xe067f46e, 0xe533f931, 0xdd2521da, 0xbe0fbb5e, 0x9b3b410f, 
	0xf00df6c6, 0x4d7c8ab5, 0xed0b81f6, 0x711b3b83, 0x1d99fe9d, 0x8f806bcf, 
	0xf6ff3962, 0xd7f52712, 0x07750eae, 0xcdae18eb, 0x545b2740, 0x2c45538e, 
	0x57a129ff, 0x2df7c1ed, 0xbc0f73a2, 0x35e60dbf, 0x6b77df1c, 0xb45af89e, 
	0x33b214eb, 0x0a6dca07, 0x1b7cd5d1, 0x285ae7cf, 0x83fda16b, 0x3eabafd0, 
	0x99323ef5, 0x187247cb, 0xf8435f2e, 0x3635fb42, 0x597cdf9e, 0x9d7a6c6e, 
	0xba876bd6, 0xbbd1e117, 0xaa21adfa, 0x7bd813c4, 0x3675c5bd, 0x4b95e385, 
	0x0ace499a, 0xe9e6027f, 0xf436122f, 0x8645fc97, 0x27a0fd1f, 0xff9f0955, 
	0xe825c3f3, 0x16ff955f, 0xe93c0ae0, 0x587e288b, 0x50d3d31b, 0xfc45e76e, 
	0x080e40a9, 0x9fc4716f, 0x30fa4d38, 0xb8c11b98, 0xb1f19044, 0xed01f01f, 
	0x697a78af, 0xc524e863, 0x814b1a2b, 0x302f16ef, 0xfebe713b, 0x41bfb575, 
	0xe61bb8fa, 0x76f30b9d, 0x19a23d3c, 0xff6cbde9, 0xe402ab5f, 0x18e0e444, 
	0x2bfaed03, 0x7ae08ff6, 0x1536cea4, 0xea17f2fd, 0xe18fc36c, 0x89f8aff3, 
	0xfb6b2f7f, 0x6473d20d, 0xe911b85d, 0x3a21bfc9, 0xdf79fd12, 0x0a8689c1, 
	0x437d3ff4, 0xcdfc9fbb, 0x54f761d5, 0x6eff83f4, 0xac387ba2, 0x5db6b3df, 
	0x8afbbc45, 0xfa1d124f, 0xd0c6f78a, 0x3b3ff009, 0x6ff491a2, 0x7ac54eb8, 
	0xd52d7564, 0x1ebbab23, 0xc7e48145, 0xf347bf75, 0xd1da2af9, 0x5dedc7d3, 
	0xac3d7e82, 0xc3eee45f, 0x69f8c6ef, 0xae98931e, 0x5a0f12dd, 0x2ab5888e, 
	0xe8b73a29, 0x6f4909f3, 0x125cab6f, 0x48ffd87c, 0x29bf1222, 0xe389dce9, 
	0x5f1d3c02, 0xdae8bd0c, 0xf8539293, 0xb219df77, 0x506f880b, 0x3ea4240f, 
	0x3d631c4d, 0x3d63a890, 0xc588f580, 0x86675a47, 0x3e98bb7e, 0x6cd5fd03, 
	0xf439f07c, 0x95bd9657, 0xf3b95fd2, 0x7cff539c, 0xd165e9fa, 0xfa1ff247, 
	0x505ec953, 0xbd7fb24d, 0xa6c1055d, 0x91deb461, 0xdd3dcb06, 0xbe583dd9, 
	0x7ef43f41, 0xae743431, 0x3c8d75a6, 0xd6a8fe81, 0x4477a5fe, 0xf2085e2a, 
	0xc700f6cf, 0x811a2ad9, 0xaff434be, 0x43761f80, 0xa0ce4307, 0x22ac5a5c, 
	0xf70e2c1d, 0x40f498fd, 0xa9fb1e7d, 0xe10778c2, 0x7e20fa05, 0x5005ea1d, 
	0x482f957f, 0x6bef813a, 0x013c7a02, 0x9d9c6bcf, 0xcff8026a, 0x89cd11eb, 
	0xf48bf710, 0x0b08a911, 0x7b94e403, 0x8c59f479, 0x1e1c2223, 0x7ea57d42, 
	0x31d711af, 0x7580470b, 0xdc8197f8, 0x78f07a05, 0x20f1f88c, 0x7e013fb7, 
	0x180750c7, 0xfb8fd0b2, 0x9bb3fa6b, 0xff9df4d3, 0xfa38dafa, 0x2c65ee49, 
	0xf57897af, 0xa2519277, 0x3edd70eb, 0xcded679a, 0x61df0460, 0x19ed6217, 
	0x47a88f9e, 0x96de3f7d, 0xedb3efa1, 0xcf8dcfea, 0x367fdc69, 0xff87db3e, 
	0x3359f145, 0xd614f99f, 0xef86ea5f, 0x2104b06a, 0x537058f8, 0xd5dff21e, 
	0x4fd79636, 0xd5c238c8, 0x1c52fe52, 0xd8f0e015, 0x044f538a, 0x7cbe008f, 
	0x810ef762, 0x0fa9fa72, 0x7486bd77, 0xe87c6e62, 0xbbf7e0bb, 0xe1833c8c, 
	0xf044aa5b, 0x770f84fd, 0xc6f7c3cd, 0x3ef05dc6, 0x85f52f92, 0xeb1a964f, 
	0xcf52d983, 0x01d7fca2, 0x7e49370f, 0xf51ff8b6, 0xbf387061, 0xe9253d27, 
	0xed13f50a, 0xabd01d37, 0x141ec95a, 0xb977dc6e, 0x00bf7e45, 0xf5f4814a, 
	0xfd3fd4a0, 0x2f85ae3c, 0x65595f4b, 0x2770bede, 0xe7c02fba, 0xf417ae0a, 
	0x58e10c64, 0xfa8682a1, 0xb9b9c61d, 0xfca49b9f, 0x5e90efc2, 0x51767af6, 
	0xe963d1fc, 0xfd4c96cf, 0x6a707a89, 0x0adfaa7d, 0x37e02415, 0xabecfe99, 
	0x24cb1e25, 0x747da11f, 0x0ec6ae95, 0x188a62c1, 0x9f294e0f, 0xf89b0237, 
	0xf9792922, 0xee6fd08f, 0x1c78b499, 0x4bd635fc, 0xbcf30e79, 0x78cc26c6, 
	0x247f7ada, 0x5243f1f5, 0x8c04d6cf, 0xf90be238, 0x2f9130d2, 0x842346f5, 
	0xa81829f1, 0x546ecd3d, 0xdca23767, 0x33d0f8b3, 0x8d34f80b, 0x99337ccf, 
	0x331e9d2f, 0xef897c86, 0xf8a4944f, 0xf00d73d2, 0xbe7f5a65, 0xd4715d45, 
	0xe799de53, 0xe07ecbe7, 0xbbe15bc7, 0xbd31873b, 0xf3f6046e, 0xf33e9f21, 
	0xd73f9215, 0x2ab0fedc, 0xc1b91340, 0x787d451d, 0x8d79edcd, 0xa8ef2fa8, 
	0x051f143f, 0xd61c790c, 0xf59eb4b7, 0xb3fc0297, 0x29de8051, 0xde8279c3, 
	0xdf7093ab, 0x88dff547, 0x45f92993, 0xf58eb77a, 0xdf0aac5a, 0x3d447e83, 
	0x4625aebf, 0xd82d7afa, 0x62bf5001, 0xeb1fad6d, 0xb23f9c6b, 0x6ca03c61, 
	0xa3f4906d, 0xe92d7d7d, 0xdc94bfc7, 0x3de3fb20, 0x0246a796, 0xe3b790ed, 
	0x8a448768, 0x1da38edf, 0x43b42772, 0x72f08079, 0xd7bd7ac0, 0x607ad2d7, 
	0x6ef6b5fd, 0x4b96e789, 0x22fbb3c7, 0xe1677678, 0x0b3cbdd9, 0x1d3ecbcf, 
	0x28b788cf, 0x2c6677f9, 0x15f27c09, 0x78ef8729, 0xc271d7e6, 0x0cdbaab3, 
	0xff7fa880, 0x1ebbb208, 0x5d5ebc05, 0xc4b5fd8f, 0x03e93e31, 0x98c4623d, 
	0x919171ae, 0xf5315d65, 0xde5b2c46, 0xb3c67111, 0xdbca037f, 0x3dbc9664, 
	0x13d6f24e, 0xb23c1d1c, 0xec9cb06b, 0xd62e749d, 0xeeca0534, 0xf18698fe, 
	0x7a4a9efe, 0xea167bd9, 0x2afa2028, 0xfda5be39, 0xaebbdf91, 0x7ff9f7e2, 
	0xaba1f7e4, 0xd6447df8, 0x4cbd644b, 0xf6e0afb6, 0x3bd05f96, 0xedb62fab, 
	0x26524449, 0x3b753b3f, 0xb4a37bad, 0xf0542b4f, 0x700ec018, 0xbd8d183e, 
	0x723dfd03, 0xe58d53ae, 0xee599c61, 0xb0f25b3b, 0x31e1e401, 0xb0ad3796, 
	0x01d5dbde, 0xeaec813f, 0xaf5ca59b, 0xf883c150, 0x962fca16, 0xf4fd9673, 
	0x1a98b9c8, 0xd7de6f83, 0xca479db8, 0xfa1fb121, 0xfb0d7295, 0x0dfa0eff, 
	0xca3d6fd0, 0xf2528fc1, 0x7f8ffa6d, 0xbcfec717, 0xa05e98d3, 0xeb9da2ae, 
	0x68aa4b28, 0x86287ee7, 0xd637c868, 0xa2abbd3a, 0xabea0a55, 0x63b7fb29, 
	0xc3f2c85c, 0x4f05ce50, 0xd83adc72, 0xb3a87a4d, 0x3eca7875, 0x6007bfc0, 
	0x32ff99fc, 0x18194263, 0xf1ff951b, 0x284a84e2, 0x519b9d67, 0x974079a2, 
	0x012a5e04, 0x4673111a, 0x0f989ccf, 0x27497ae5, 0x34bf97d5, 0x0bea08b1, 
	0x2933bfca, 0x915f41ec, 0xc4771afd, 0x93a3a278, 0xe069aee5, 0x09b9843e, 
	0xf9dc45f7, 0xe8027962, 0x6be5ef62, 0x875f727a, 0xb2de997a, 0x6f7fe815, 
	0x2f6af389, 0xef6aabc7, 0x7a9ea18b, 0xdffb4553, 0x58afd82b, 0xa6ecb76c, 
	0x60b7246d, 0xac04071d, 0x7ed823c3, 0x4dd6bf26, 0x030faa74, 0xb1afd6f9, 
	0x54acf37e, 0xe08bef09, 0xaf5011fb, 0x8c7199f1, 0xeb977afb, 0xe37da38f, 
	0xb8fa26bd, 0x070897c5, 0xf150dc4f, 0x63f54d7d, 0x8f77e471, 0x169adba1, 
	0xc99b5940, 0x2d65eedf, 0xed590f64, 0xe2a1863d, 0xd6bfae7e, 0xd4b9e950, 
	0xa1971eab, 0x6e3f4076, 0x30ef1e8f, 0x8057bc78, 0xd8d13fcf, 0x2d7ef3af, 
	0x2696b8fa, 0x832b3c17, 0x9e929fcc, 0xcfec7dcb, 0x5fe6117e, 0x2f5feb03, 
	0xec6bddfd, 0x026a7fac, 0x77a487c0, 0xf681aa62, 0x8cd84ba0, 0x2c75da24, 
	0x9f28dcd7, 0xe4f92982, 0x0e4a5afb, 0x6af85db1, 0x5d1f433c, 0xf5e674cf, 
	0x62176498, 0x384b947b, 0xeffa3d5e, 0xb3c7fa59, 0x7e41c248, 0xc6669fe7, 
	0xf00fc07b, 0x7bc4627f, 0xc3ef3fa0, 0x05af8cbf, 0xdcb70b7b, 0x12337e31, 
	0x7859d2e5, 0x475d730e, 0xf6937671, 0xb457bbcb, 0xde616ba8, 0xf52afefe, 
	0xfd7243c3, 0x78979f20, 0xbe5007f4, 0x4aae723f, 0x24453d6d, 0x61182077, 
	0xc5f9003b, 0xcc38e3ed, 0x7db1b7a3, 0x1ec1f16d, 0xcb09c33b, 0x171919d0, 
	0xf8567940, 0x1bea38fb, 0xf9e372ef, 0x86c8ed4d, 0x7fd0729b, 0x8c2dfb07, 
	0x8fb05af1, 0xf5f484be, 0x3db18168, 0xcfea9356, 0x0069fb83, 0xafee0f67, 
	0x3db4dd12, 0xe2e019bf, 0x8fe7e7c9, 0xb62a9816, 0x7c45ba27, 0x4b7f6aaf, 
	0x2bf45331, 0xe4954c4a, 0x3154d849, 0xbbf5604e, 0xcab86571, 0xb3fe83d1, 
	0x6bc65fb9, 0x7e81374b, 0xec047bcb, 0x07252327, 0x5faab5ca, 0x2ef7e0ed, 
	0x6e6253c4, 0x8dcfe911, 0x7e8d5aba, 0xb4cfa592, 0xb44faa05, 0xc4eafca7, 
	0x57e455dc, 0xcb11d9df, 0x63633f43, 0x4ad26d54, 0x97c1db07, 0xbf16f7ca, 
	0x733d9fcf, 0xf293c452, 0x682f17d3, 0x6ab6f2ff, 0xdfae97b2, 0x325ed02e, 
	0x067993df, 0xff966dae, 0xf8ba7c03, 0xe9039b29, 0xe607f51d, 0xdbb4d413, 
	0x6c499daa, 0x93a97005, 0x71da05f6, 0xdc4ef40b, 0xd9247ddf, 0x0fce8394, 
	0xc76869d9, 0x986b0caf, 0xefe8f337, 0x414a73fb, 0x79c0ffbf, 0x6402a04f, 
	0x3f82dee6, 0xe3037006, 0x04f709f1, 0x513e505d, 0xb060c7fe, 0x025ae589, 
	0xc16a7d3a, 0xe021b93d, 0xbcd61f9d, 0xd4f28b96, 0x85fe3825, 0x83bda2fd, 
	0x9bdfdd7a, 0xfed10f29, 0x742fc47b, 0x64612fa4, 0x8bb46bca, 0xe2a4cf73, 
	0x6ceddb4d, 0x3df15ac7, 0x91473392, 0x199ca44e, 0x6721975f, 0x8ce583dc, 
	0x60faf4da, 0x80b91339, 0x9ca3719c, 0x672c1dc9, 0xce519f22, 0x48997f20, 
	0x9f42a517, 0xb8b57c0f, 0x07550dee, 0x794b74f8, 0x3eefd163, 0x48dd7f29, 
	0xa7f249ff, 0xa5fa0ac2, 0x20fe41ab, 0x879e84fe, 0xdf37bc7e, 0x97e30b78, 
	0x93a388cf, 0xe983c38c, 0x07fd23da, 0x0f2bf80f, 0xd9a7bcc0, 0xa47b1f59, 
	0x2f50313f, 0x7ad976e2, 0x3c71a3d2, 0xfa25f508, 0x8f8a1f23, 0xca3aef48, 
	0x6f2bdea4, 0xa47bd0cf, 0x7a52eae7, 0xb420f48f, 0x7e58d42b, 0x42bbe366, 
	0xecfea7ed, 0xb9481768, 0xe251bb13, 0x1bd295d3, 0x3511dc96, 0xd47a8aba, 
	0x23d00dfb, 0x9d2788ed, 0x06b1b1e0, 0x374a1af8, 0xc48d75e2, 0xfc60f373, 
	0xb9bf11fa, 0x3f5f8e97, 0x3a5c57e2, 0x0dfa6b7e, 0x51f018f5, 0xc71e994d, 
	0xc83731fc, 0x79349ae3, 0xaf44fa8c, 0xe56c7967, 0xae3ca127, 0x7775e7e9, 
	0x455768af, 0xdcaf2522, 0x01eebcfd, 0x2a6158b9, 0xdb709ba1, 0xb6a5a85e, 
	0x07443b34, 0xd1e30e07, 0x54440f32, 0x78ed1508, 0x5c767057, 0x22e3cb5d, 
	0x81cef5d3, 0x09b9cbf7, 0x6c41f7c5, 0xd548bf1b, 0xf83578ad, 0xfe923fbf, 
	0xbf5df2ef, 0xefc3fe61, 0x218f26f3, 0x97f96939, 0x29a09ddb, 0x8eebc77f, 
	0x721b75c9, 0xdd6d22dd, 0x75a5ebd9, 0x0fbae546, 0x79d6f9fd, 0xea3df5b1, 
	0x3fdf768c, 0x547cf50f, 0xd2933b6c, 0xcb35d3f7, 0x0bcd054e, 0x4904ea76, 
	0xdbb7048f, 0x1dd12fc9, 0x48f383bd, 0x9decb52e, 0x7a6b17d9, 0xdb61ed92, 
	0xb93b34d9, 0x7943cf42, 0x70069fee, 0x50dc7a93, 0xd43f0e2f, 0xd46f08db, 
	0x042f48e3, 0x3fd8f7bf, 0xbfb1f651, 0xe58a7682, 0x6f1c125f, 0x49b57092, 
	0x3075a4ff, 0x2a75013c, 0x8fc07ba0, 0x2f26b821, 0xfeff570e, 0x88b07caf, 
	0x03b98ff5, 0xb069cdfd, 0xc8c3e00e, 0xb42eb027, 0x0f462e73, 0x3d10b6d7, 
	0x82ed29dc, 0xcb07e488, 0x47d6b5df, 0x3a7f12eb, 0xec9c507d, 0x33d7c5ec, 
	0xfbc1827d, 0xbeeac977, 0xaad3e718, 0x603c67a8, 0xe8dea176, 0xf909f45d, 
	0x6f191e59, 0xd1c83efa, 0x2a3ea22f, 0xde9abce4, 0x4f7a3eca, 0xb7e04179, 
	0xafb7167a, 0xa7c322f9, 0xb16a2c1d, 0x2322a1b1, 0xe920300f, 0xf0eedb2d, 
	0x6076e644, 0x59fa12fe, 0x9d79e34d, 0x6f07393f, 0xf31554f3, 0x51ba9c6f, 
	0x3b7ee5ea, 0x7a292a76, 0xff67653e, 0x906026a7, 0x5671ac7c, 0x41eabd91, 
	0x768a357b, 0xe8af94aa, 0x71530687, 0xc725df4c, 0x57b67531, 0xe638e1af, 
	0x1d5ecb29, 0xfa94c714, 0xd1fb1174, 0xd153b411, 0xef7a042e, 0xbe74c2d9, 
	0x5d14aef6, 0x13f403fc, 0xec7c8f3d, 0x794b515e, 0xc80b914d, 0x0a4bcc0b, 
	0xe912869d, 0x27cff1a1, 0x0056362f, 0x3d606fdf, 0xd4a6764d, 0x81a7a4c7, 
	0x0faf7b1e, 0x273f71bb, 0xbd106452, 0x86fcdf96, 0x73e8341a, 0x3df9c63f, 
	0x683f84ab, 0xe936f4a6, 0x9afbd471, 0x4d3ed6fe, 0xe89bedea, 0xadfa3f7b, 
	0xee10bed6, 0x5c72e4fb, 0x87484bf0, 0x0e8fe7a4, 0xb33fefd6, 0xf3a4f94b, 
	0xaefe493c, 0x7e38f291, 0xad923971, 0x433e2c77, 0x4fb1c4fb, 0x7f2d03fa, 
	0x58bc7939, 0x256c4e31, 0xbbdc6c79, 0x839413e3, 0xa6839486, 0xc82b1b94, 
	0xefe6b25f, 0xf9a7f9c6, 0x18fefe31, 0x821bc1cb, 0x3d323436, 0x01cc1c96, 
	0xe52221af, 0x27dfcc05, 0x9acbefe7, 0x5fe71bbf, 0xc53f9a9b, 0x75c94eed, 
	0x1fe4a734, 0x38caf1c5, 0xf22978fe, 0x702d42a3, 0x64d11ea0, 0xd79e83bc, 
	0xc8191c93, 0x1ae6a68f, 0xd3df6dc7, 0xf39fb284, 0xa59c47a4, 0x446375bc, 
	0xe8a2953f, 0x19dfe508, 0xf96e6f45, 0xf76a7cd4, 0x6d7f94bb, 0xc9504fb8, 
	0xd5e5d5f9, 0xc1eb4286, 0xcf586b3c, 0x8ef7078e, 0xf7f7c08c, 0xf3fc996b, 
	0x55c7077d, 0xa9aca17b, 0xc058fdc7, 0x2ddbac03, 0x853dadf3, 0xecdd9277, 
	0xed04e37e, 0x59d7ba5e, 0xa6c2d5f9, 0x0d565e21, 0x995455d4, 0x69433ece, 
	0x73d3482a, 0x8a9b756b, 0x3bf03bf1, 0x7c1acf30, 0x500efa28, 0x977e62a6, 
	0xa7cc9d7b, 0x8dfe728e, 0xebac957b, 0x4d72978c, 0x1e64db15, 0x0cd5fe35, 
	0xca775bd3, 0xb428cf3c, 0x3d8f487f, 0x22f98235, 0x347005b4, 0x68298f43, 
	0x1e6039cf, 0xa4a3cc06, 0xf9c149a3, 0x4eeadd93, 0x06f3a73d, 0x18f3d337, 
	0x374f773e, 0x9edddf9e, 0x8f0e5f92, 0x78c16b11, 0xf3c4f4e1, 0xd5ce41bb, 
	0x4b8275f8, 0x63a7bccd, 0x98e70fb8, 0x3d33e7a9, 0xc5970c1a, 0xb0f1cbe6, 
	0xf7969f7c, 0xb33eb8e5, 0xb96af39d, 0xf788b3bf, 0x44cbdd6d, 0x83f78dbc, 
	0xe59a07e3, 0xba9f6038, 0xa65f2667, 0x846d9cef, 0x677881e5, 0xbe8c5759, 
	0x397c969f, 0x5e75f306, 0x3496f50f, 0x4a2d3db9, 0x50bbae76, 0xc7ac5ff6, 
	0x5aeea0db, 0x3d0f1b54, 0x5064c422, 0x6f80a5f4, 0x7603ccbb, 0x84516a2f, 
	0xb00973d4, 0xd83b8eeb, 0xb2852adf, 0x76ee0d25, 0x461eaa7b, 0xd1e3093c, 
	0xe0f0d207, 0x757e31a8, 0x6de518f0, 0x8782edb6, 0xe8befe7b, 0x427b1214, 
	0xdf9b51d2, 0xd47a62a8, 0x6abd646f, 0x720fbf14, 0xf711dae7, 0xd80fd038, 
	0x10a715e3, 0x4703e1de, 0xf997adf6, 0xf00f48ff, 0xa50f33dd, 0xe9c79bd5, 
	0xc61c4abf, 0xdd61de12, 0x79897e2f, 0xface50c1, 0x79aa4011, 0x175a21a8, 
	0x88cf3940, 0x9a8f81ed, 0x7a9e32af, 0xdf5de79c, 0x79a1fa04, 0x8533f4a4, 
	0xf0fb455e, 0xe09f392b, 0x3bfb077e, 0x070eea15, 0x5f3473ee, 0x84addb21, 
	0xb40f6876, 0x0eedbb71, 0xaabc878e, 0x6eed403c, 0xa863d1cd, 0xd01f7777, 
	0x0f37e85c, 0x77a88973, 0x6f5bce35, 0xddc729df, 0xbcd97404, 0x7f57f644, 
	0xbf9afefe, 0x1e71efcc, 0x776dffe8, 0xf681c0fe, 0xa6de9835, 0x37f080d8, 
	0xceb02d92, 0xdae10ead, 0xeadceb0d, 0xc231fa84, 0xa0bbf5d3, 0xfecbd53e, 
	0xffa418d0, 0xef07c42a, 0x7e4e8c33, 0xdb99e48f, 0xacec95b8, 0xeb78c00d, 
	0x29fe51bb, 0xdb2f9445, 0x43e8a5b7, 0x2421bf78, 0x66103692, 0x539b542b, 
	0x8013f183, 0x4bafdc0f, 0x011e8178, 0x51d06e8e, 0x7a297d2d, 0xedebb668, 
	0x8ddbfe16, 0x456fbd14, 0x9675c2ba, 0x8e30a71a, 0x34f4931b, 0xeb838f90, 
	0xd27a26e9, 0xfcacfe91, 0x3cacd2de, 0x5ca5fb96, 0xfad4cab2, 0xf67d68aa, 
	0x55efac8b, 0xe6070de5, 0x9d685ce5, 0x9fd47708, 0xe9cb0362, 0x7aac6f5d, 
	0xedb5e902, 0xc4b79cbf, 0xfbcb3cf8, 0x7452cfa8, 0x9668f00b, 0xd7469bf4, 
	0x85f88ed7, 0x3157cf83, 0xf1d1a73d, 0x78626e0f, 0xb9dd21b5, 0xbfb4a917, 
	0xdaba5c25, 0x86f97006, 0x2c6ff383, 0xc7e34af9, 0x1da10e58, 0xc9d7e346, 
	0x7d01ccf9, 0x1b6ded0f, 0xa1955cf1, 0xed495da0, 0x23f3524a, 0x6f9f737e, 
	0x497aff7e, 0x1ab903f3, 0x9d1c7ce3, 0x9cb743ec, 0xdc57f417, 0xfdb1f24a, 
	0x0de50d79, 0x3c718bf4, 0x1cf83fec, 0x9cfb8b8f, 0xb7efa157, 0xd1a6e591, 
	0xfcc3db22, 0xad5cbcf6, 0xf70439e2, 0xa9df3acf, 0xf9f2023f, 0x6fc6ed55, 
	0xfa1f3ac0, 0xb5a9dd59, 0xd725ff40, 0x50df618a, 0xa19f7852, 0xb64abe73, 
	0xc9ca351f, 0x9f4401fb, 0x98dd13b7, 0x555f7ca8, 0xe7c1c6fe, 0xc4dca4e5, 
	0x1c7ca379, 0x08ef3c6f, 0xa59fbea7, 0x80369d78, 0x3c11e683, 0xe789f1bf, 
	0xb9bf381d, 0x7e70c76f, 0x53c145ce, 0x22e75eb8, 0xf2b337de, 0xa23f506a, 
	0xbb98987f, 0x7bf47dea, 0xfe502c67, 0xe88f3827, 0x4043dcf5, 0x0e922537, 
	0x1f94bc67, 0x33d86647, 0xc5f285b7, 0xfe85ccf6, 0xad399fb0, 0x9740b5b1, 
	0x8e768e33, 0x35cc7f43, 0xd218f833, 0x5bc603a3, 0x84eeb69b, 0x3eea78cd, 
	0xee061796, 0xa0fc59a7, 0x35de3938, 0xf5f028e6, 0xae07c949, 0x8adf7f14, 
	0xc91185fb, 0xfa297507, 0x946d3827, 0xf9275f74, 0x1f71be03, 0x3e207e65, 
	0xe1b3be00, 0xa97ab759, 0xc039e40f, 0x5f95bcf4, 0x7a45fe4b, 0x5e5676c5, 
	0xa0abe530, 0x49d47a9d, 0x399525f9, 0x527f9c45, 0xddfaa51a, 0x7992ae27, 
	0x1672a6c1, 0x7bf7990b, 0x82940c20, 0xc1f988f4, 0xc5f95327, 0x9b6933aa, 
	0x609e6062, 0x59f71395, 0x23ce41fc, 0xf25e50be, 0xd9c9f8c0, 0xc2fd1794, 
	0xbc782b81, 0x3d51af9e, 0x9a4ae4a7, 0xdf5c0ccf, 0xf0f3c1d9, 0x8c502ff4, 
	0x7ef7583c, 0xf63ee295, 0x6fe2951e, 0x4b9704f6, 0xb2b71c9d, 0xb272bfca, 
	0x9e33421c, 0xcfb396f2, 0xb504b55d, 0x3e0e1f2d, 0xf79d954f, 0x3c45f08d, 
	0x618e3ad1, 0xbe3872be, 0x80e12939, 0xf18937f9, 0xa6e8ff34, 0xcd4f5e5c, 
	0x8b9e0897, 0xe40d66f3, 0x57e7a4f7, 0x07d5795b, 0xae086bc2, 0x8686abea, 
	0x82947468, 0xb8798c9d, 0x18483f32, 0x191f0b36, 0xc70444f9, 0xb1be54ba, 
	0x88dc32b3, 0x82f2b178, 0x949ac672, 0x5e61ab2f, 0x4f97cb2b, 0xf2b22fcd, 
	0x382af387, 0x03f5189f, 0x7d02479e, 0x56757ec0, 0xe6c5ec1e, 0x677ca173, 
	0x97155733, 0xfcec9f34, 0xc55d52e6, 0xf30365f3, 0xe72aa612, 0x20cd7941, 
	0x67146247, 0x00e09905, 0xbc2f6e3d, 0xcaddcf93, 0x08f6bcf3, 0x079c15c8, 
	0xf9a6a7ee, 0xb2be74f1, 0x23abe64e, 0xccf2b25e, 0x6544ee49, 0xec18fa7e, 
	0xd80fe407, 0xe0f40295, 0xce79c6bb, 0xfafe602f, 0x3e3eb4ad, 0x7cf8299f, 
	0xbabe7666, 0x9b130e75, 0xfed41935, 0xf8cfd57f, 0x399c7394, 0xd03ec9bb, 
	0xe65ccf39, 0x417f82b3, 0x51bc75f0, 0xc6bca364, 0x026d533e, 0xf851cfbf, 
	0x73fbca13, 0x74e79d64, 0xb4e79d64, 0x3c9f5cec, 0xdf9d69c7, 0x4df9e2f4, 
	0xe9bf3a91, 0x79bf3ac8, 0x249bd163, 0xe7591d0f, 0x67274737, 0xf37afed3, 
	0x79b3a4bc, 0xaed2962e, 0x9b38691c, 0x4abcaed1, 0x0091066c, 0x9fd46576, 
	0xafca1d78, 0xfe789d47, 0x530ef9ac, 0xf2835e24, 0x6ecb7d66, 0xdc7cd780, 
	0xe748d8e8, 0x9e74ed70, 0xed8fba13, 0xe3e621a3, 0x9e85d2be, 0xc91c7497, 
	0xa7069759, 0xbb9bb74b, 0xa667e89d, 0xbfd6b9f4, 0x6edd21be, 0xa87c7f16, 
	0x166edd21, 0xbb0ce6ce, 0x666b5db9, 0x7f68b9bb, 0xb2a7d69c, 0xbed49cdd, 
	0x99b3764f, 0x23e918f3, 0x1c79843d, 0x7d793bef, 0x5377b217, 0x57e022f6, 
	0x6599fd21, 0x1e4f8a2f, 0xbdb0bbe8, 0xf3fd83d8, 0x648dfc7e, 0x78fda397, 
	0x475ecd2c, 0x35e01d3b, 0xcdfbc5c3, 0xba572aaf, 0x9f4ecd3e, 0x88a9db29, 
	0xb6173397, 0xcd76adbf, 0xb673365f, 0xa0f57cd2, 0xdddba5a1, 0xbbb61700, 
	0xd1c4b7c7, 0xeb45d6ee, 0x0d9fa86b, 0xe7931cd1, 0x2e784393, 0xfd17e819, 
	0x477641ce, 0xeedd2ba1, 0x63bb4870, 0x44e417aa, 0x4ed9ed12, 0x9c82f305, 
	0x75ae7ca5, 0x8555f274, 0x3f1ab1ce, 0x59edd254, 0x75ed05c7, 0xac65a5d5, 
	0x72a77273, 0xdf1b3b3e, 0xa4bf7046, 0xdac53ff7, 0x7e36f6c1, 0x954fac1f, 
	0x19286760, 0x658944fe, 0xbbf35b6f, 0x3357e795, 0x949f5b59, 0xd3b9e3e3, 
	0xc613cc0b, 0xf405fda4, 0x4c9f38bb, 0x776dfc25, 0xfc495256, 0x79da7b73, 
	0x27cc95e8, 0x3c0d5f16, 0x1be7e36f, 0x53630ad7, 0x479e79ef, 0x8b86f9e1, 
	0xceb21b9f, 0x179c0d09, 0xc8fdceb4, 0xf99fbc73, 0xcb2d50dc, 0x373c877f, 
	0x57f9c6b4, 0xae63b42e, 0x288573c6, 0xc4fecb86, 0xe7598573, 0x276e8061, 
	0x980f7dd1, 0xfdf183ce, 0x45263a1b, 0x82f9e2b6, 0xdf50c715, 0x42ddc7bb, 
	0x7194e0f4, 0xbfa3d39e, 0x777984d7, 0xd6c55bb9, 0xb710bb44, 0xb18ed8b9, 
	0xa56e68e4, 0x4e3e61ae, 0x30943e6e, 0xdfb95cbf, 0xe535f606, 0x6fda8871, 
	0x9fbae3e4, 0xe341503d, 0x91b31f2d, 0xa1b9e5d6, 0x48d23f22, 0x8e0e42f6, 
	0x7abdccfb, 0x3469cb29, 0x73fea034, 0xb8e52a51, 0x2adbea83, 0xee3f714a, 
	0x14a1a319, 0xaccfcde3, 0xa732a0ed, 0xfe727440, 0xf4149033, 0xc62dccff, 
	0xdf38f4d4, 0x537da533, 0x5049bbe9, 0xa3c2fb42, 0x01c79bb5, 0xfcc2f6dc, 
	0xe5d0605c, 0x298ea51a, 0x6bfc5420, 0x238e161b, 0x09b3bc7e, 0xedfb93e7, 
	0x409b33e8, 0xe8e4e6bf, 0x609fc84d, 0xa9bb3d4d, 0xf843e696, 0x7fee8dca, 
	0xe700f596, 0xaa38e5aa, 0xe7878c34, 0x8f7b647a, 0xf1f1f141, 0xe61d409f, 
	0xf01a7e37, 0xf1a8c82f, 0xc53731fd, 0x38b6774d, 0xca758830, 0x0c6c99e9, 
	0xf3de73c3, 0x930e309a, 0xa6f2c9fb, 0xf8ebb8f4, 0xe5338e7e, 0xf992d716, 
	0x71586b97, 0xb3eb414c, 0x61853ae2, 0x42ec7141, 0x71e96843, 0xc6435cec, 
	0xc7f9e529, 0xbca0809c, 0xee275c7d, 0x873ae2af, 0x706b9ea2, 0x171479f1, 
	0xeb03abdb, 0xeb99e876, 0x59e6a5be, 0xcc3bad07, 0x5bac0dfd, 0x0f9d7e50, 
	0xc6fa0bd7, 0xfd05eb87, 0x6c57ebee, 0xe52edebc, 0x93ebd652, 0xf581d871, 
	0xe7715836, 0xe53af5cc, 0xa60d9d7a, 0x0dbd632d, 0xad6cae32, 0x07d30277, 
	0xe84d65d8, 0x0216e4f7, 0xcbbfc17e, 0x9be7f555, 0xa5d6d2ba, 0x501dd565, 
	0x30b75f4f, 0x91aaeb32, 0xfdeb3ed5, 0x276c1d9b, 0xbdb21598, 0xd3d475ce, 
	0xa8cbc782, 0x575a78c3, 0x4bc61d5a, 0x78827faf, 0xfb963901, 0x7eefd04f, 
	0xfdfd2f1e, 0x8b0eb860, 0xfdbfc7a5, 0x3dd24f5f, 0xdaabfe02, 0x52fa7967, 
	0xfeb8c2f6, 0x38cfc22a, 0xb7cf849f, 0x7cc71e6b, 0xe3cf9819, 0x1e9f7819, 
	0x9dc69c7d, 0xf471f6be, 0x2e92fdcb, 0xdf03f5c7, 0xb0df88ab, 0xb8d6e50d, 
	0x0167e832, 0x7cc6e7f5, 0x6b74c19b, 0xe54a14a2, 0x28fe024b, 0x6b748ebe, 
	0x36dd0f3b, 0x55c6fc30, 0xd2f22b26, 0xfda17de6, 0x905fe252, 0x1b2ee3a3, 
	0x93da22fe, 0xf71525b9, 0xcf3fed34, 0x79c17e39, 0x39c6b304, 0x35be74dd, 
	0xae719354, 0xc938bdcc, 0x0f9e0ffe, 0x7fcb0656, 0xa0abf781, 0x48870fbc, 
	0x6df80fde, 0x433f7225, 0xf6e2bbde, 0x8f3122e9, 0xb414e9f2, 0xa35ceafb, 
	0x1b1f18dd, 0x9a58b68d, 0x4e703c3f, 0x2d32f4b6, 0xb68a5e5d, 0xe9ff5415, 
	0xfc068baf, 0x6ffbf395, 0xae1d69a3, 0xf4343b6b, 0xf8094573, 0x0d2fa421, 
	0xb84e3f5b, 0xee48d845, 0x9c645cff, 0x72b620f3, 0x9a1577e3, 0xd03e90a6, 
	0x43aa507c, 0xfae30eda, 0xb1b5477b, 0x9bef29ff, 0xcf41fbb1, 0xfbad5e01, 
	0x0e32ec63, 0xb30e4dae, 0xfa99a41b, 0x9ba485cf, 0x7803bf34, 0x0efcc15f, 
	0xf294a4a5, 0xc2bb2daf, 0x431e85fe, 0x60a1dbde, 0x0e12919e, 0x74fba66f, 
	0xb670fdb0, 0xf16762f7, 0xb2b77479, 0x0b0fbf16, 0x6a6ac3cc, 0xfbb129b2, 
	0x951afef1, 0x5f403bf3, 0x78649cb7, 0x9bde00b6, 0xcaabef17, 0xd11a7d45, 
	0xee49f902, 0xa8fa8127, 0xe3fc88a1, 0x8df00383, 0x9f43bd52, 0xa71fe198, 
	0x1c034dce, 0x3ef052eb, 0x4eec5e10, 0x58ed0f3f, 0x62b8afd0, 0x6eb54748, 
	0x6a844b8a, 0x79a8e833, 0x23a4b771, 0x2ec574a1, 0xb85a474c, 0xa48e9328, 
	0x3fe69fff, 0xdfb37615, 0x7ecbd855, 0x61faa7d7, 0x32bfc062, 0x10849cf8, 
	0x3eb9baa3, 0xa3eb97aa, 0x747d72cf, 0x47c3d73f, 0x23219ee8, 0x629526fc, 
	0xc3c1377c, 0xa54bdf18, 0xeb967098, 0x5eb9fa13, 0xd52b6472, 0x52a4de4b, 
	0xeb977c4c, 0x99404f13, 0x5c72b6b8, 0xbef5e03e, 0x42e3fd15, 0xb6573650, 
	0xa1ff272f, 0x28104d12, 0xf37e6223, 0xc4cb2811, 0x1fe8ede2, 0x19a29915, 
	0xf4eba3fd, 0xa85bdb21, 0x0e67bc5c, 0xa32c4fc2, 0xb1f4abf7, 0x20cd47c8, 
	0xc04312dd, 0xd77f76ee, 0xfc1f768d, 0xc469f5e5, 0xd79c8df7, 0xce7cfc2e, 
	0x39bca0d8, 0xf08561ba, 0xe99eed2c, 0xf9feff4c, 0xf48679df, 0x80f6d68a, 
	0xfdd67046, 0xcca91a27, 0x650921e9, 0x7ae19ce6, 0x01eb8fa0, 0x1e992493, 
	0x3d51aa3c, 0xdcf5c5d8, 0xedcf5ce3, 0xd791baa6, 0x219a81cb, 0x8734a967, 
	0x15417e10, 0xedb91da1, 0xc4157eb6, 0xbdf1d8a7, 0x40b0d5bb, 0x1bb76b7b, 
	0x9d96cafd, 0x06f928af, 0x49eeebc2, 0x33c96178, 0x851a0f98, 0x55e82672, 
	0xbb2fee78, 0x00e2b4a7, 0x52550fd4, 0x25053fe9, 0xb3fefcd8, 0x27d27f5c, 
	0xe0373c14, 0xefc55c77, 0x5fdedc83, 0xf3b50f7c, 0xcb92b9cd, 0xe7a4aeeb, 
	0xbd645bbe, 0xc65cbbfe, 0x1fcfcbbf, 0x6527f594, 0x5ccbc0fd, 0x77cb243f, 
	0xefe7e65f, 0x3f99facb, 0x73f6a970, 0xefcfdf99, 0x697acbc7, 0x5f1e54e5, 
	0x4941d796, 0x1ffd73e3, 0x7cd7acdc, 0xbd5377f5, 0xb789f0ed, 0x07af7e50, 
	0xc6aee4d8, 0xda4c497b, 0x04922737, 0xbde4f9dc, 0xd4bef060, 0xed707e46, 
	0xd3639258, 0xf599c904, 0xf9434225, 0x6d312891, 0xff8201ca, 0xd71f906f, 
	0x63ac3caf, 0xda63a23e, 0x810b47d1, 0x74375dde, 0xcb2f7184, 0x68df6d73, 
	0x692f3b0d, 0x13c467fb, 0xa461f3f8, 0xddea859f, 0xf56724c5, 0x73cb141f, 
	0x9f64c5eb, 0x985189e7, 0xf93a382f, 0x1ef851bd, 0xf80487fd, 0xf5e98efd, 
	0xa0fcf163, 0xe8e3e848, 0x6f94a97c, 0xfef04f28, 0x84cfbc32, 0xfa60e3f2, 
	0xc7629fdc, 0x5cbb1779, 0x759a8f4c, 0xf7499caf, 0x12f25978, 0x6fec0afd, 
	0xf8a143bd, 0x1a67bdfa, 0xbe07181d, 0x2173693b, 0xedc3f29c, 0x9ccfb875, 
	0xefeadedd, 0xa4ee976e, 0xb743439d, 0x612bfd13, 0x41a087e6, 0xc2cbed75, 
	0x9b617fba, 0x6cddfdc1, 0x257cfe83, 0x5fb818c2, 0xb3888c03, 0x780826d0, 
	0xb0e7a7ba, 0x8e35c713, 0x109175cf, 0x40bac10b, 0xb49bdccf, 0xa0a039f1, 
	0x1b3f436e, 0x7c5fa3db, 0xe01cf58f, 0xf527bcd0, 0x57bbcb7c, 0x67ef1b0a, 
	0xfb42f6d8, 0x5f6ee2a9, 0x5fab9e7a, 0x6b763bde, 0x2ed0d85c, 0xf88dfb01, 
	0xa64ded61, 0x991c8057, 0x666777da, 0xe272c2fb, 0x6d2ba9ff, 0xe101281a, 
	0xd973f793, 0x7e1e4d43, 0xf30f387e, 0xf9937d6d, 0xc0ac307c, 0xba9deb85, 
	0xef846e72, 0x095c317d, 0x22fe1faa, 0x4fc431da, 0x913e28a7, 0x07042354, 
	0x78efb51f, 0xefe28ea6, 0xd1974bd3, 0xfb52daf9, 0x2b47ca52, 0xdd23e689, 
	0x8516fb41, 0x0e9935ce, 0xe3ddff6c, 0x81ea0f36, 0x3dab82f8, 0x5f9e6133, 
	0xb1dfb0f0, 0xf7f5b9fe, 0xb65f2069, 0xa9f08c77, 0x65e7988d, 0x6de1d3c6, 
	0xa3b8c79d, 0x1bbca751, 0x8154d7e8, 0x0ebdbe1f, 0x4bd81954, 0xee844ac3, 
	0x42f9c7dc, 0xbac2de74, 0x0fe9a4df, 0xc95e8f5c, 0x9cf1bdf1, 0x993003ff, 
	0xc529fe8f, 0xeda70e91, 0xd1f586f7, 0xd8677f38, 0x83df8d18, 0xee9a3d5d, 
	0x4e9b0a01, 0x3b9e1efc, 0x678e8eb8, 0x72853eea, 0x9066fc03, 0x6c554f8b, 
	0x0af3c3ca, 0xe457964f, 0xfc429ae5, 0x7e42261d, 0x9f58c424, 0xbcf18ae9, 
	0xccaf31db, 0x8c095f8a, 0xdb7ee15b, 0x283c2bb8, 0xf0deb6f7, 0xe29ff90a, 
	0xed093111, 0x39df9495, 0x4efd11bb, 0x3bf03adf, 0x3cb35f01, 0xbfa77e99, 
	0xff50d852, 0xbf81f2fb, 0x00bd255a, 0xccf7819d, 0x7962677e, 0x5f9eba7e, 
	0xdcde063e, 0x6655e381, 0x15d59dfa, 0x132e4fec, 0x29d4ffd2, 0x5999e69b, 
	0x79f08d20, 0xea97e5a9, 0x90b8de64, 0xfca46e2e, 0x17be3088, 0x81af8b61, 
	0x9e618fbe, 0xd4f7bf31, 0xa7c8f18a, 0xe30dd9ee, 0xfe1632c1, 0x4b7c5e17, 
	0x9d76bd01, 0xaca1f787, 0xe3e9d7bc, 0x60aded8d, 0x399f954b, 0xede79197, 
	0x88e397ca, 0x6b670443, 0xdd6af29c, 0xe38af449, 0xaf33449d, 0xabe9072a, 
	0xf005e71c, 0x79985470, 0xdfeb3f98, 0x2ca25c90, 0x7bc0f894, 0xbdf89ae2, 
	0x73a0c4bd, 0xbf90d38f, 0xdbd14aef, 0x25aeb954, 0x0bf6f2eb, 0xdc36efd6, 
	0xbeb259c7, 0x2ffb07b0, 0xc428ce71, 0x19fb0ffc, 0xf8c20b61, 0x428cfba3, 
	0xbeb42fdc, 0x0b32ec2b, 0xd45f3bf1, 0x1b7e4228, 0xc08d57a3, 0x1ac4d4b8, 
	0x93ac16c5, 0xed931dfd, 0xb3516f11, 0xa4c8e508, 0x50bf785a, 0x9a93dfbe, 
	0xfba765af, 0xc62462a2, 0x45068783, 0x3ff406d2, 0x02a5600c, 0xed94ed7f, 
	0xb728be68, 0x6ed4ce80, 0x323ddf39, 0x63f2053e, 0x5347d22a, 0x137f0eaa, 
	0xdd9a0e30, 0xd4cfd59f, 0x44dfedb5, 0x83fec07e, 0x9d5c93b7, 0x07069ad0, 
	0x39d66f0b, 0x3b9e6b7a, 0xdaf71c3c, 0x422bf129, 0x149ece30, 0xf39f403f, 
	0xf8b5bed1, 0x01fba66f, 0x032fda0f, 0x24e7c2f3, 0xbe76a387, 0x93b0c3ff, 
	0xf693d09e, 0xedff6053, 0x0e36fd93, 0xbc8f6bff, 0x4c42629f, 0x1fb827fa, 
	0xad15f745, 0xe288fbe5, 0x89fba925, 0x47decc16, 0xf1abdf74, 0xc2ba42fd, 
	0x7df662fe, 0x1f3cd643, 0x1d7aaf99, 0xadf5536b, 0x1013d5b5, 0x3b27142e, 
	0xa57f1e7c, 0x9fb272f6, 0x0cf906ff, 0xfec97fe7, 0xbcd1dfca, 0x92bed712, 
	0x7ef0afe5, 0x1d17ed0e, 0x4183f3c3, 0xfe88273a, 0xd641da07, 0xbfb590fe, 
	0xe4d7e033, 0xcfdde76a, 0xefe2ede9, 0x884c2ce7, 0x60ffbca3, 0x53fb4f7d, 
	0x3d47dd13, 0x7bcbb764, 0x96bcd46a, 0x5573c446, 0xd9f696b8, 0x985a0fc8, 
	0x7749bb8a, 0xe14ef458, 0x1cd8b97d, 0x4a6d3443, 0x44bf3bcd, 0xa26eb504, 
	0xeeb8f1b3, 0x5d827981, 0xd687ef8c, 0xf778d12a, 0xcd6de7c5, 0x114fbf2f, 
	0x6e52658d, 0x764ff7c2, 0x4fa44e28, 0xadbf7f35, 0xbff1e082, 0xfbc817ee, 
	0x27318d48, 0xcddc5eb8, 0xae5ee2f5, 0xf5cb3d8f, 0xfa50fdb1, 0x38ee3e85, 
	0xdc7313c9, 0x4c4fe29f, 0xf87bf774, 0x22735e5e, 0x8a0d53c2, 0xf28f8871, 
	0x8fbf8797, 0x3987a974, 0x5f7d9b3e, 0x8a2bde10, 0x21bdd0f9, 0x2b1ab789, 
	0x7842da1e, 0x13787a43, 0xf8769fde, 0x35e4dc64, 0x81b4fa1b, 0xfb86d352, 
	0x10ffa349, 0x2cf289da, 0x011ce328, 0xe088d98f, 0xbfaedc0e, 0x7892e326, 
	0xdee88915, 0x014a5612, 0x8bd0411f, 0xf7699d6d, 0x7fbd82e2, 0x9fbc34e0, 
	0x02981420, 0xbc1cf5d4, 0xab5b467f, 0x788d42db, 0x2b6198af, 0x47da921d, 
	0x786bac0c, 0x812be30d, 0xc35e1bdb, 0xa01c8cbc, 0x5fa5778c, 0xcf52a491, 
	0x1e7ae1eb, 0x6c3e49e5, 0x29fd1d7c, 0x7730c3d7, 0x183aea78, 0x29fd15be, 
	0x85e24bd7, 0x9e3fa81d, 0x02cb4436, 0x3698e728, 0x2d70a7f8, 0xc83ebf12, 
	0xb66731fb, 0x179885da, 0x06da5d14, 0x667d67ea, 0x715bd13f, 0xe9fa075f, 
	0x7d69fab0, 0x6dd1fb1d, 0x45fbe34f, 0x80e7fac6, 0xc4cb5c3f, 0x817ef89b, 
	0x6079efa4, 0x03dda09f, 0xf28ad3fc, 0x5fa4817f, 0xadb79fe0, 0xdbd4367c, 
	0x1ba387ae, 0x0fd0f1ac, 0xaf09cd74, 0x9a11e1f9, 0xac7f4fdf, 0x7f9cbf62, 
	0x5dba7ae5, 0xa7f589d9, 0x9a42fde1, 0xe31f89cf, 0xdfd7e67c, 0x39fad0af, 
	0xae3b22bf, 0x72cbc733, 0x422f7ad2, 0x2e78fde6, 0x65d8217d, 0x5fde41c3, 
	0xe973e5e7, 0x136a35d5, 0xa545d1ea, 0xf0a413e8, 0x51983570, 0xfde0d728, 
	0xea94a283, 0xe9db83a6, 0x2e85bf74, 0x243e46de, 0xd71f21f8, 0x93b1adea, 
	0xeb583829, 0xd0c7801e, 0xe810dcf6, 0x1ef8859f, 0x9819ff9c, 0x6b7a0c00, 
	0x63258821, 0x50cbcd03, 0x44730f10, 0xba05c8cc, 0xbcff3bc8, 0xcf535d71, 
	0xa3718970, 0x923f2c62, 0x5c7801f3, 0x3083d566, 0x1f84e19f, 0x112a17ce, 
	0xf9cb376f, 0x77f356fa, 0xb576a798, 0x3e6067ec, 0xb7f81821, 0xaf64f9a9, 
	0xbbb656ab, 0xe606fad0, 0xdea1e303, 0x237ad8bb, 0x0e5cf295, 0xc3fe8174, 
	0x13ce5e5d, 0x5e829571, 0x797a0759, 0x7be4d06e, 0xfeca8436, 0x3bf3a093, 
	0x55166f43, 0xdd0ee7e8, 0xe6bed0a4, 0xc867182a, 0x73f7c1be, 0x10f0f3c3, 
	0xa5f5dbb0, 0xef816d42, 0x71410556, 0x48b67cc0, 0x6de618fa, 0x20fc72f4, 
	0x1dbd9eeb, 0x625fb42d, 0x11c433ce, 0x13608a20, 0xe61a6f9f, 0xf8a5eedd, 
	0x507fd59a, 0xb8c1e7b4, 0x5ee82eba, 0x8c217d16, 0x11d250b3, 0x09bd0dd8, 
	0x7ec187de, 0xc6869f70, 0x157ff807, 0x437b43be, 0x62a05beb, 0xc6bb88fe, 
	0xdc1f9034, 0x1ef09f20, 0xa4caf742, 0xdd90f703, 0xcc1d860d, 0x190ee124, 
	0xe8f5e70a, 0xcf593bf5, 0x88ee2978, 0xb691ba70, 0xebf615ff, 0x4704e768, 
	0xcbfbe1f7, 0xaac74c43, 0xf60ea930, 0xe2f6c09e, 0xed8bc840, 0x2b1587f5, 
	0x81f545de, 0x4ea087fc, 0xff95957e, 0xe9887970, 0xff459a7f, 0xa2fa0fd2, 
	0x43d013e4, 0x77ce0ade, 0x1cfee453, 0x08ae51c5, 0x57573187, 0xcc6f2f94, 
	0x3be94b51, 0xa78a71ff, 0x2a6e9c88, 0xae5e9c8d, 0x3d72ce07, 0xe0f5cfd0, 
	0x04a38e11, 0x323284df, 0x7825aee1, 0xd22b4c5e, 0xf8c9f77d, 0xbc01fe2f, 
	0x3dbf701a, 0x1fa8b705, 0x0dddd3f7, 0xdb849b49, 0xbbbe70ff, 0x0c1e03de, 
	0x1790efe0, 0xfdf5bbf7, 0x77c3cf82, 0xb9f43285, 0xbc8f08f0, 0xfec3cd77, 
	0x8f4f51f9, 0xb257a69a, 0x9cbbd9f0, 0x8d4aa2e3, 0x78c13795, 0xc53dfa21, 
	0x78d9c9f9, 0x8531b779, 0xae306997, 0x3f0a60e3, 0x1fa0bc16, 0x59f7e13f, 
	0xb2f9ee9d, 0xed0abfe0, 0x3b3e17db, 0x166f08fe, 0x47f0d2be, 0xe3a68978, 
	0xc7e2f3ef, 0x473e77f8, 0x9b6227aa, 0xf62763cf, 0xb13b250c, 0xcf287fa5, 
	0x764958d3, 0x729f4262, 0x3f1ffb91, 0xfeef9ef1, 0x27fd41c9, 0xcfbfa88b, 
	0x77c3bfde, 0x3f25fbbe, 0xe00d9f2f, 0xf906c80d, 0xede2f3fd, 0x37472847, 
	0x7a07f0a6, 0x77ce3ef6, 0x19df69d2, 0xa3dfecf4, 0x3bcc3add, 0x81fe87da, 
	0x2e74c6de, 0x4491fde4, 0xd3070bdf, 0x9e461831, 0xf23fce1e, 0xd1679d10, 
	0x32bf4475, 0x61e5fd07, 0xc43ec9de, 0x72727d83, 0xf4b9c63b, 0x5879410e, 
	0x90a25d85, 0xf8b209f6, 0x5f3975e9, 0x5ba79700, 0x18d3f14d, 0x62fe87df, 
	0xf24bdf80, 0x8e83f87d, 0x3ff42540, 0x2fac07b2, 0xccd173cc, 0x59740680, 
	0xf51e1119, 0x1f89e600, 0xedebcb1d, 0x87fba62a, 0x7de28385, 0x13478acb, 
	0xcf083f1c, 0x787db1f6, 0x107f3d13, 0xf3cf0ff1, 0x7d3cefdf, 0x07fdef19, 
	0x32ba7f70, 0x654df59f, 0x0078f0c4, 0xbfd0f92f, 0x3fd2e407, 0xe61f58fa, 
	0x36118f77, 0x6525538a, 0xa0a1a2fe, 0xd47a7abf, 0xc63715ef, 0xfa09c6fd, 
	0xfd8fb96e, 0x1cfe8b3c, 0x2e784f38, 0x77d10a42, 0x30260ffb, 0x236e3b7e, 
	0xb3bf7bfa, 0x959bf190, 0xdbd168af, 0xf482fccf, 0x41de5aa3, 0x3f620469, 
	0x5a369fd3, 0x61bcca74, 0x5c0ff497, 0xee4f19c7, 0xb753c124, 0x0ce793e4, 
	0x1f6f5fcb, 0x11bcbdd7, 0xa9476ba3, 0x77dc3534, 0x9c71f668, 0xbefda455, 
	0xb397bc83, 0xef56f508, 0x1e9e3364, 0xe7c7100f, 0x4ff9c08f, 0x959a6279, 
	0x5d2237f7, 0xc44bda4f, 0xef06bec0, 0x0321005f, 0xe63dbebc, 0x470f849b, 
	0xee8231a9, 0xb10b0995, 0x472a3df9, 0xb07e5fa0, 0x9f445be0, 0x8ef95b60, 
	0x4cd13ca0, 0x20f0ed13, 0xd800fefe, 0xa016e153, 0x58c4003b, 0xa06357c9, 
	0x5d1fbc7f, 0x38dc6b84, 0x1fb064ce, 0x506e5db0, 0xef84b144, 0x62e50d84, 
	0xcc5be650, 0x018b7ce1, 0x80fd0d7f, 0xfc47f518, 0x8e060638, 0x016a7f41, 
	0xbc46ed1e, 0x0015eff1, 0x9f90253f, 0x7c49f1de, 0x4a3b690c, 0x632509fb, 
	0xfb9d228f, 0xfce4afd7, 0xf7df0088, 0xda528800, 0xda0e98ea, 0xa27e4e88, 
	0xfbba870c, 0xbc4e8eda, 0x1f61ee97, 0x28b8939f, 0x37ef645d, 0x6fdccfed, 
	0x6063e8b2, 0x4fa0a9bf, 0xdcfe0171, 0xefa73e4e, 0xe30385d2, 0x0d15ee30, 
	0xee78128e, 0x28e7d35d, 0x3e47f285, 0xeffad78e, 0x4056706c, 0x5260d03d, 
	0xf83e16dc, 0x2d87c629, 0x5bd5e378, 0xf829e54d, 0xf8621ed5, 0x5ed8bae5, 
	0xd4497681, 0xd8496a3b, 0x876c7bc0, 0x714bd980, 0x9269a0bc, 0x0fe56d7f, 
	0xd49b9c02, 0xfc23a34b, 0xd38b8c9d, 0x97244bd1, 0xaf474c2f, 0x00551d30, 
	0x393c811d, 0x6276239d, 0x05e6949c, 0xf49657df, 0x2fef22bd, 0x19bf6170, 
	0x8d3ab5f4, 0xae804aae, 0x36f452ea, 0x64874740, 0x1d3a64be, 0xba3c25c5, 
	0x3c347453, 0xe314ffa0, 0xe15f449c, 0xc92aba34, 0x7a6caba4, 0xf4c65fb2, 
	0xf39f3bd4, 0x9b792c73, 0x679be96f, 0x26ed1f85, 0xf83fca2f, 0xc359f2ae, 
	0x4b26724f, 0x903e89fe, 0xe4a71f7b, 0x24e107de, 0xec9ecdc1, 0xf819753c, 
	0x758ff9df, 0x8a71c69d, 0xe282a3fe, 0x75cea377, 0x38667e50, 0x19446330, 
	0x5fa3c594, 0x6509511c, 0x4519f2e4, 0xf29c139a, 0x5c8b8ff2, 0xc8dfbc4e, 
	0x4350f951, 0x7b42deca, 0x9e76913d, 0x6566e867, 0x18555ce0, 0x79d43de6, 
	0xb29d9ae4, 0xe861a23d, 0x43ff512d, 0x1d0ec760, 0xbedb6e6d, 0xbae17719, 
	0x785f8e48, 0x4d8ef71d, 0x083e0fb7, 0x64724c7f, 0x475e49d8, 0xd6927224, 
	0x498af301, 0xf52058b9, 0x9d9f4168, 0x52605cf0, 0x3a1ea9de, 0xea19a54a, 
	0xfe437182, 0xfc37b901, 0x4e1f3f38, 0xc6700674, 0x160f92fb, 0x3fa4fc38, 
	0x923eea56, 0xea9861bb, 0x29d3b21e, 0xdbfa0ede, 0x58c1dfc4, 0x6162f7d7, 
	0x50d6fe7a, 0x2d57ce6d, 0x4a5c70f8, 0xfa1dfe04, 0xbe7c142f, 0x4171c473, 
	0xae75d0f1, 0x03be3357, 0x38240a72, 0x484ff7be, 0xfe49cf07, 0x14489afe, 
	0x76155f20, 0xfe29c399, 0xfc5052ba, 0x2eb25d69, 0xd0ea7e88, 0x0bdd045b, 
	0xaf870e06, 0x38fe6d25, 0x313f3c5f, 0x3b79cfcd, 0xf9460b07, 0xfe433cf1, 
	0x8fd906b3, 0x96476895, 0x6e08be12, 0x81856aab, 0xdf4133e7, 0xe2bf7005, 
	0x449f68ab, 0x75bd9c70, 0xbda20f68, 0xa274f282, 0x87e68fec, 0xa08d5d7e, 
	0xa4d087df, 0xf055fb7d, 0xc1ddb0ff, 0x3f042982, 0x86d1b56d, 0xdf82dcf2, 
	0x236efc3e, 0x70976bb5, 0xd20ed1d4, 0x9e73e39f, 0xe5bf5143, 0xfd8a3f49, 
	0x2a1e64a2, 0xb4a106c0, 0xe4f3d1d4, 0xd07e7810, 0x359afecf, 0x5c3c6c8f, 
	0x375cae94, 0x3fdd5d10, 0x7ed51fc0, 0xba6c8fe4, 0xa279861a, 0x5d3a5def, 
	0x3ef3f0ad, 0xc15d064e, 0x838d87ba, 0xbc31767e, 0x7ca97512, 0x5b3fb404, 
	0xa930aec8, 0x575c9cfe, 0x4bdf2587, 0x3cfa5ac3, 0x9d57a155, 0x1fe0d235, 
	0x767ff862, 0xffd1ba3e, 0xfba3e0e7, 0x6847c02e, 0x853b0f1f, 0x065b7074, 
	0x275c811f, 0xa9aa183a, 0x7c403fb4, 0x55f24fb4, 0xde3c60ef, 0xce11e12b, 
	0xe6719f3e, 0xa1bf4cca, 0x5f543be6, 0xf5a5edd6, 0x2fc169be, 0xc5867ceb, 
	0xc697c887, 0x7c21f025, 0x1d71885f, 0xf0f3dbe2, 0x3861f125, 0xa7c497c5, 
	0xa5f3070b, 0x3f5c0f05, 0xe50fe5f2, 0xb4160eba, 0xf0de31fa, 0x91f2f979, 
	0x30b87e2c, 0x3a25ee5f, 0x0bcbe6cf, 0xef30e3f1, 0x2c372413, 0xce2060ff, 
	0x1fd97ffd, 0x1d4f4030, 0xbe767d89, 0x8b73c6cd, 0x61c120f7, 0x467b9e10, 
	0xd1645d92, 0xdf3e367f, 0xbc1bd6b4, 0xbc67cf8e, 0x0dda8e38, 0xceb14f7d, 
	0x8e3169d7, 0xa59c1723, 0xd0518938, 0x1d08a54f, 0xe87878e1, 0xa0bb284d, 
	0x2c75209f, 0xcfcbbf86, 0x7cd89f87, 0xc860f99e, 0x3dd9c616, 0x4bde4fe0, 
	0xeb4b7774, 0x2e7bce17, 0x91e742e9, 0x68bb840e, 0xb338a9bd, 0xe671803d, 
	0xc01152ca, 0xd23e7338, 0x3dfa3b41, 0xf4ae671c, 0xdd031d80, 0x78694e55, 
	0xca97ed0d, 0xa35e3a8f, 0x3984abfb, 0x2cd5e996, 0x641f904e, 0xdc602714, 
	0xf83d72d3, 0x1f9817bb, 0x07eddf4e, 0xd211c8fe, 0x0f96cc5f, 0x583e4873, 
	0x70e2b2eb, 0xf7698744, 0xf8919f19, 0x5df712c3, 0x4772033d, 0xb31e9178, 
	0xaf181dfb, 0x74d8ee6f, 0xf30a55b8, 0xc3f07ed4, 0xf7324b7a, 0x38e23db7, 
	0x17f935d9, 0x32f3db94, 0xfc20f9fa, 0x052f9207, 0x9e281d4f, 0x32fe409d, 
	0x51fee98b, 0xe579a491, 0x9e74bda3, 0x76608979, 0xf90e5a3f, 0x171f05b1, 
	0xb47da097, 0x70f2c92f, 0x4e719293, 0x11b5547c, 0x6e67b0cf, 0x606dae16, 
	0x155fd8cf, 0xdd3894da, 0xabf7cb07, 0x7ef0fc02, 0xf873cba4, 0xc83d9d9c, 
	0xa38b0fe7, 0x0b7b7b6e, 0xcf889f3f, 0xf73d05db, 0x0f633388, 0xfc273d90, 
	0x4b7ce4d3, 0xed8be6d3, 0xe1341ef1, 0xa781905a, 0x7223c20f, 0xa72b9f90, 
	0x1f069df4, 0x63071448, 0x373764c5, 0xddc61a28, 0xf08be9b2, 0xb3a49efa, 
	0x68ae922d, 0x65695d3c, 0x5c60af79, 0xbc4ded18, 0x0e427a2f, 0xe3d879e3, 
	0xbce55341, 0xd147ba0c, 0x4f087a23, 0x74bb49f7, 0x1d7dffb0, 0xbf8453c1, 
	0xc877cf42, 0xe61d06f9, 0x15bbc469, 0x8877b5af, 0x3599738c, 0x585f4c39, 
	0x0a7c0096, 0x47985e00, 0x8069c16c, 0xbbfcfd2e, 0xef0ed83d, 0x8732bf7f, 
	0x1c9aeffd, 0x3efb2e8b, 0xd4961f5d, 0x9abfe164, 0xb57f68e0, 0xd95ff08f, 
	0x48b0facd, 0x5c40efd2, 0xba3450da, 0x68a12e07, 0x8e552fe8, 0xef0d786f, 
	0x4fcc1b05, 0x7bfd1975, 0x3e714f81, 0xc5261d05, 0x4625ec2b, 0x2e2ff931, 
	0xeca6d390, 0xe3ce3f67, 0x0b941ced, 0xb0b8e36f, 0x8edaca9e, 0x53da9ad7, 
	0xd2cae6f1, 0x18e3e20e, 0xe59d046e, 0xbf88a57b, 0x83c81db1, 0xc012873c, 
	0x3dfa1e7a, 0x26efc249, 0x77f306a3, 0x8b1f74c2, 0xa9ab5f95, 0xf7e9e3b3, 
	0xcf8e54b0, 0x55d4dfbc, 0xe0abf7cc, 0x97bc12f9, 0x3de3df05, 0xf0e5af82, 
	0xef95a6fd, 0x23dc6557, 0xbb953ae8, 0x54a9cf13, 0x2e7df316, 0x58889ff9, 
	0xfe4fd00f, 0xef13b134, 0xb87ca965, 0x3dfa6760, 0xbc7f3882, 0x66b2a597, 
	0x455b8f20, 0x213dd2c5, 0xf23fe748, 0xde3b15fb, 0x759f92cb, 0xa3568b2f, 
	0xa1a7a5ab, 0x4a1a85d4, 0xacaeefcb, 0xfaddf991, 0xc86f769f, 0x1ca6deed, 
	0xf30ccf3e, 0x7cbf1816, 0x2fc60e71, 0xb0563cad, 0x2fd23c0b, 0x20af881f, 
	0xaf404b3e, 0xf7c55e62, 0xc62ed873, 0x5b51cb38, 0xa937fe2a, 0xf03425de, 
	0x44d98707, 0x8c93f480, 0x3c715a13, 0xd2575ef8, 0xc3f880e2, 0xae1c7253, 
	0x782e321b, 0x527bf8a1, 0x612a7da1, 0xde30ffc5, 0xbcf5f408, 0x3881dba4, 
	0x6b635aee, 0x597e2d2c, 0xc816f929, 0xf149703a, 0x46e71c4b, 0xe3d05f39, 
	0xd5fdc093, 0xf31cf85e, 0xc1bed0be, 0x2f9a76d0, 0x9d9a7bd1, 0x4036e206, 
	0x442ab7e7, 0x1573ee80, 0xe61fbfba, 0x8c72457b, 0xe0befec0, 0x281c5d12, 
	0xa6d5e2b3, 0x49eb493f, 0xa59e6de5, 0x36d4e392, 0x6f8961ef, 0xba2b578e, 
	0xe9d713b9, 0xb40235a9, 0xef159faf, 0x2e9eaf3c, 0xf913f290, 0xffb5836f, 
	0x0c90f7cb, 0xfb8457dc, 0x483cf4f7, 0x7de1f5f0, 0xf41ed449, 0xbcabd231, 
	0xef76e49f, 0x7f32393b, 0x0897ee43, 0x73c5dfba, 0xbd1cf396, 0x01e505ff, 
	0x43e4c600, 0xe567943e, 0xc6975493, 0x4e28d3f0, 0xc902f684, 0x0f7c54b9, 
	0x28facf9f, 0x46f28e37, 0xe6276611, 0x76fefb5f, 0x56e5bfcc, 0x7291de63, 
	0xa9c01870, 0x006713fc, 0xc6ce53cf, 0x16ffc049, 0x69bf1b96, 0x4fdfe2ae, 
	0xe03d404b, 0x5f7d7f33, 0xc81fbf9a, 0x9e388717, 0x7cc01c6f, 0xe8a29c99, 
	0xbd3dfc6c, 0x3e638d9a, 0x59be007a, 0x1ee87051, 0xf6315fde, 0x57be00ef, 
	0xf29f851b, 0x2ea957ba, 0x55d5f79c, 0x5867ca41, 0xe772c95c, 0x7646876a, 
	0x07ed07ae, 0x63ea2790, 0x80f13655, 0x6536f310, 0x35db2efe, 0xab2fe601, 
	0xaa2af2b4, 0xf1fa4b2f, 0x2979591c, 0x9dfc57eb, 0xe67fb438, 0x76fe8bcd, 
	0xabd3ac17, 0x00ef9f89, 0x2dbb8fb8, 0x30e43bd9, 0x8aeb478d, 0xadffdaf8, 
	0xb7dd08f5, 0xef7c63f5, 0xa47fcdd3, 0x3ac2277b, 0x5e7aa1c1, 0x57876ffb, 
	0x48de1c13, 0x3546bac0, 0xa1bb7d45, 0x3e122a3e, 0x72f402d4, 0x7243f80d, 
	0x5b132b9d, 0x6dd7ef48, 0x6df4b865, 0x9bbb4275, 0xd73c4cf2, 0x433fea36, 
	0x570e31db, 0x603b601b, 0xceabcf54, 0x51ae7cf4, 0x3f44e186, 0xf8fc8022, 
	0x1e651098, 0xc7d275e3, 0x1f69b6d0, 0x4edc039d, 0x1d1b8c75, 0xfd356643, 
	0xf4e472e9, 0xefd36f93, 0x3bf90857, 0xfa7581ac, 0xe8f7e92b, 0x3a83ae04, 
	0x7b9f1fd1, 0xceee279d, 0xf45f1f4d, 0x7af48b95, 0x86dd3ae5, 0x8facd2f6, 
	0xf9cdbe96, 0xe62f2c5e, 0xe2a92cad, 0x103e5871, 0xbf461f3d, 0xa29ad853, 
	0x65ec5e52, 0x66e7847d, 0xbc8075a7, 0xaffec628, 0x845fe8cc, 0xd7ca4ecc, 
	0x322a7290, 0xb8a5aee1, 0xf986e06f, 0x97289935, 0x95443ee5, 0x56e77f21, 
	0x202f3ccf, 0x66505bf7, 0xf2905c93, 0xc895fcc7, 0xda173f90, 0x6bac093f, 
	0x5efd2578, 0x14796ca0, 0x23de0eb8, 0xbdf3ca5f, 0xbf825c96, 0x540bf8f6, 
	0x731e193a, 0x969c2296, 0x1696e628, 0xec679e83, 0x0bbed0bf, 0xd7ef71f0, 
	0x5f44af38, 0xa047109c, 0x2e501fdd, 0x17e92edf, 0xbcb174e8, 0x239dde9f, 
	0x2fecec32, 0xc99ed807, 0x143db009, 0x7008ad0b, 0x73a15c7c, 0x5fd0b18e, 
	0x3077e805, 0xa7d504ba, 0x9012be84, 0xf2777af7, 0x3d72affb, 0xe0f7ed0c, 
	0x7db81bfb, 0xa1f7bf0b, 0x9e4bba68, 0x2a3a0037, 0xf9134dd3, 0x7de64abc, 
	0x5dfc0389, 0x2c451e76, 0xfe8026b4, 0xadd094e0, 0xecd85fdc, 0xf3d7fee4, 
	0x7fee2178, 0x5cebe84a, 0xb1f7e0af, 0xbedc6dd0, 0x54bbe78d, 0x36ae1fb0, 
	0xe7bc7e9a, 0x41e1eaf8, 0x59e2cf9a, 0xd473f282, 0x0114aa97, 0xe5203e7a, 
	0x320277c2, 0x1fe80eef, 0xd23dedf7, 0x389a5ece, 0x6af3c7e4, 0xbef8076f, 
	0x8cf3799b, 0x411e0ff9, 0x36d70fbe, 0x2fef81db, 0xab05570f, 0xc215f7f1, 
	0x21360f85, 0x4cab47ff, 0xa8f0ebe2, 0x7fdd1a6d, 0x71f23776, 0xbfcb3155, 
	0x9e5c4d72, 0x5463bb00, 0x02e4da74, 0x97c7df1b, 0xc978de7e, 0xf1d72b27, 
	0xd8832939, 0xe45cf801, 0x1e07f9a5, 0xe8965c2d, 0xf185f5c4, 0x265895b8, 
	0x4f30b3a2, 0x84bfe966, 0x818de6f7, 0xef33d879, 0x321a5a3f, 0x4868eed7, 
	0xb44cb7f5, 0x6bed855f, 0xefb67636, 0x87d23efa, 0xb794837e, 0x295ddb25, 
	0xfa901079, 0x40f282fb, 0x8dc08fca, 0x749bff16, 0xdcb03d8e, 0x0f2c0f92, 
	0xa6f7f25c, 0x1e70f151, 0xfa3bf02e, 0x9b0a3767, 0x5bbbf16a, 0x644dfbf2, 
	0xcdb8aac7, 0xc5b9f16b, 0xcd72d9f7, 0x039273e2, 0x01cb06a7, 0xf8b0aecb, 
	0x60c3e2de, 0xbed3b450, 0x87df364d, 0x6c77f96a, 0xefe3214d, 0xddfc54c1, 
	0x62039296, 0xa3eda5f8, 0x7c946e06, 0xc5ed92be, 0x172972c0, 0xf65bdf24, 
	0x4bf7c599, 0x75fcfdd6, 0xe4a76691, 0x77ed0489, 0xa21c4b2c, 0xa752d7a8, 
	0x0e579e70, 0x1bc97aec, 0x392d8006, 0x186f30bb, 0xc82f11ea, 0xb94c96f7, 
	0xfa6314d0, 0xb2d2b8c6, 0x9a07be52, 0xde71fbf6, 0xf98fd32e, 0xceb6d5af, 
	0x540798ed, 0xf249ca7e, 0x02a4c962, 0x96afb3b2, 0x95ffa779, 0xb9e1fecb, 
	0x7f1b965c, 0xd77be5cc, 0xa4edd4be, 0xba97db38, 0x81dfa75f, 0x1ef8f252, 
	0xd37cf2a8, 0x5bc7bf8f, 0xc6f0d8b6, 0x36cabf81, 0xbe31f8f6, 0xc8377e54, 
	0x20475825, 0x0d7d720c, 0x476f0fe5, 0x97bb2cfe, 0x9b2dcdef, 0xfbadf7c2, 
	0x0b1aa67c, 0x6b0efda6, 0x836bbe1c, 0xa49caff6, 0x180895df, 0xd77bc142, 
	0x8ce10d03, 0xdfed72fb, 0x73c46ae9, 0x80fb5696, 0xbef0da61, 0xd041ad5c, 
	0xcada6afd, 0xf00b9d30, 0xd46aee4e, 0xf46e3883, 0x77e023f1, 0xfbe41ebc, 
	0xac9ecb8c, 0xb5727ba3, 0xb5dd6095, 0x02c7f2a6, 0xffa4b9ed, 0xb8fa16ff, 
	0xde9a4cfa, 0x9d7de7ac, 0x0a08be01, 0xc0f8ddfa, 0xff07cced, 0xe08f7e0f, 
	0x00000009, 0x0003af51, 0x7de59c78, 0xd554740b, 0x333ef0b9, 0x664e6667, 
	0x3de4c926, 0x12610c93, 0x87869d42, 0x519b4c13, 0x22609ca2, 0x47c6b451, 
	0x2756bd15, 0x5a5a201a, 0x6f46a223, 0x9892678b, 0x0826784c, 0x36d2f124, 
	0x05596a3e, 0x6bdaf531, 0x24f5ee54, 0xd8cf8082, 0x6f5a96da, 0xbd0a009b, 
	0xbd80314d, 0xfff54a8d, 0x93ef6fbe, 0xdb040479, 0x6bfff5ae, 0xee96b3fd, 
	0xbfbf677c, 0x03f7bdfd, 0xccb354c6, 0xa45d4b18, 0x0c7d34ed, 0x24cd307f, 
	0x978c906b, 0x67f00631, 0x5a63cf9f, 0xc6e7c213, 0x35cbe5c1, 0xe58429b3, 
	0x676b5d75, 0x69da192c, 0x5a499821, 0x450e6312, 0x430d3537, 0x6c12a4ae, 
	0xbe797687, 0x13b0803e, 0x84de6d3a, 0xef8dceed, 0xdd8ca987, 0x930758cf, 
	0x651b9619, 0xcf5da62e, 0x52b0e33f, 0x94ee3797, 0xfa8fe06b, 0x9ad67520, 
	0x056b98c6, 0xa77fbf8e, 0x6a1f043c, 0xf420bc82, 0x22a11917, 0xa8874dbd, 
	0x7006875f, 0xd6298059, 0x90e29003, 0x9412be71, 0x27795334, 0xd2c7dbe6, 
	0xec5ab6e4, 0xbf683597, 0xb9a96ea6, 0x598cdd73, 0xcc157be1, 0x98ca5ac1, 
	0x7e54e989, 0xb0c4af4e, 0x38a7d63d, 0xae5adc70, 0x350dc689, 0xa2bed81d, 
	0xa9761c49, 0x054fea4e, 0xaa35f018, 0x537da8d8, 0xd5479f0d, 0xf1039a15, 
	0xd6e8fd05, 0xc037683e, 0x77f41b54, 0x4b5b641e, 0x876ffc68, 0xbe2bbfa1, 
	0xbb276efd, 0x3538aa94, 0x77a537c8, 0x94d846ac, 0xeb1afdd1, 0xee6f7681, 
	0xa01fda60, 0xac23cb9b, 0x77b5e685, 0x8d5b961a, 0x6115bef3, 0xe71c34eb, 
	0x695385d5, 0x5ee1ac1c, 0x369f0782, 0xfb0f38d3, 0x7bb1712e, 0xb49f3f00, 
	0x8bf7e215, 0xd84dfe70, 0xe641d0cf, 0x576f3c01, 0xa0e01853, 0xd3a0e674, 
	0x0b72c014, 0x2ce5b1c2, 0xe6e65a2d, 0x2d2b4471, 0xbdc8b302, 0x617757ee, 
	0x11b2985a, 0x4aaabcd6, 0x11abb77f, 0x4fca55f3, 0x5777d595, 0x6abe138f, 
	0x5633b21e, 0xba2242bd, 0x62567ea8, 0x7631670f, 0x7260ea7d, 0x3ef1ac3b, 
	0x0d696317, 0x65939fd0, 0xdbc8d33c, 0xcf8ba0d7, 0x20fad7e1, 0xe9336b94, 
	0x559e50cd, 0xb89dc9eb, 0xb93d2eee, 0xdb32f01d, 0xc7cd0b7d, 0x73b65728, 
	0x3c024064, 0x2eb5dd85, 0xa1218276, 0xbe098455, 0x06eec5cd, 0x1ec02b78, 
	0xb8731784, 0xbf95c38f, 0x9650cdd3, 0x9387faa5, 0xb38e1a59, 0x20c36f20, 
	0xbe45f963, 0x705a3b77, 0x6d7e8fbc, 0xd7c12543, 0x4e7986ad, 0x6bc07bad, 
	0x5aba246f, 0xd8c236b4, 0x9ad32b42, 0x4fbe4317, 0x5dbd21b3, 0x9b13f4be, 
	0x2974e304, 0xf40f9f4c, 0x99a99f99, 0x7a40379a, 0xeb9b25e4, 0x5c3f28fe, 
	0xf62fc771, 0xf97c60b8, 0xbce2fdb7, 0x5e28c6f4, 0x9fe61af3, 0xe7831e97, 
	0x02c480b2, 0x2dff1fd4, 0xb39aeeb4, 0xb647944e, 0xc9a73ebb, 0x8a3c61b7, 
	0x2ffdfcb7, 0x2ef962d9, 0xe1b3efd5, 0xe31bf2bc, 0x88b3a7bf, 0xf346ddac, 
	0xe4af22b6, 0x1a3db43b, 0x25e161e0, 0x0e9cdc2c, 0x78fc7f70, 0xa48da193, 
	0x4ddf3106, 0xadec3e5c, 0xec633a45, 0x63e23af5, 0x972d5f7d, 0x31f77b13, 
	0x57583bf6, 0x85410c75, 0xa7483f51, 0xf4ca418f, 0x28aba464, 0xbd8eea7f, 
	0x1ca8ba94, 0x00a3e3f1, 0x209e41ba, 0x3e0bf61f, 0x0627904c, 0x0d5f129f, 
	0xcc2f964f, 0xdf11235d, 0x7dc38cea, 0xfd5be26e, 0xf98becb7, 0x9570e758, 
	0x8b1a60f6, 0xbc84ff99, 0xdc68d0aa, 0x1c931f06, 0xb7ca367a, 0xbfc8d7c4, 
	0x208ebd59, 0xf8e8bbd4, 0x80336f55, 0xb5b3e60f, 0x4fa4355a, 0x0b8cddbe, 
	0x5fc8b557, 0x1f017ac1, 0x3e42ab57, 0x539f24ab, 0x3f7c0197, 0xb84667b5, 
	0xaffb9ce8, 0x7e583c92, 0x23a655fe, 0xd6af9f20, 0xa758264c, 0xa3354564, 
	0x7a82495c, 0x9439d82d, 0xbe3a416f, 0xcbcb91ba, 0x532f2e6a, 0x1ab90997, 
	0x1cac70e2, 0x1f21a5d9, 0xd2fce1ed, 0xbf200fa0, 0xe3ef76cc, 0x601fb1fc, 
	0xf1afc20f, 0x87e7957c, 0xb8706fdd, 0xb7afe0d7, 0x6fc17978, 0x0e5f9f06, 
	0x2b29b2e2, 0x01bf9fca, 0x458d707a, 0x4e14a4d3, 0x3da83067, 0x9f77a811, 
	0xd857d38b, 0x7ede5bfd, 0xfafc1240, 0x2dfe38bb, 0x42dc421b, 0x6bd62e1b, 
	0x6ed8c65f, 0x6834cba0, 0xaf68a16f, 0x75a6558a, 0x0639041c, 0xf40d96f4, 
	0xbca92ff6, 0xd3c7ecdd, 0xdba09374, 0xb74e118e, 0xba710f1b, 0x44fae4ed, 
	0xf2b900ea, 0x694f680d, 0xe92dd288, 0xae17a217, 0x5f4e8847, 0x20ccf686, 
	0x78e86237, 0xf4e146b4, 0x7c8c6b01, 0xa215e868, 0xf4c99293, 0xd57a3a7b, 
	0xdf926da1, 0x0d5e925f, 0xb182a83e, 0x053d9f5b, 0xe0cc82bd, 0xabd3827a, 
	0xf42bd659, 0xc51f28e6, 0x15841be9, 0xfe00d766, 0xfb0bac19, 0x63b7fa88, 
	0x22bbdeb9, 0xb63a1df4, 0x97b39e6b, 0xfed27b07, 0xea0790df, 0x9c1e493f, 
	0x868fff2d, 0xfb09a6f4, 0x01c855ab, 0xe60cffe0, 0x1fbd0f63, 0xd5190795, 
	0xc69a662e, 0x97a5b7f9, 0x0f8b6df3, 0x4d56f768, 0x8e42c361, 0x5ea45d00, 
	0xdf0cfc06, 0x4a78eb53, 0x9e4620f2, 0xfe80bc90, 0x47d055f3, 0x10f90b2f, 
	0x37a3f212, 0x59d2372a, 0x36f88c87, 0xbd2246e4, 0x6239597c, 0xfeb85fd8, 
	0x2947602d, 0x837f4fb2, 0xd3a3e64d, 0x5f0667d9, 0xd08f969d, 0x14e67b1e, 
	0x82e8247c, 0xa9df7fd6, 0x096afdd6, 0x7abdffcb, 0x357c8ce0, 0x1c240e99, 
	0xec07418f, 0xce1cf654, 0x5fc89ed7, 0x4d23f6d5, 0xe432be51, 0x6f81f7e7, 
	0xcb261a32, 0xd728cdcb, 0x023e50c6, 0x147ca25d, 0x88eaf2f2, 0x08861929, 
	0x39224ff2, 0xa2acdcc9, 0x212f9447, 0xc692daf9, 0x95b4c2ee, 0x912adbd7, 
	0xe8ec36dc, 0x4e4f6154, 0x4ebe4be6, 0xc5d72764, 0x5f3f4bac, 0x0cff8317, 
	0x9bb0d77b, 0x80cf77f5, 0x1b376167, 0x25e43678, 0xfc31c3d9, 0x57eb34e4, 
	0x994c38e1, 0xd57aa35b, 0xc30e9933, 0xbcf947ee, 0xf7bd865c, 0x13e91a78, 
	0x1fabe866, 0xf9e15873, 0x255d7889, 0x9de205f4, 0xf1b77e11, 0x3e86fcf6, 
	0xd62d2a7a, 0x7eed9c7e, 0x97b7b79a, 0x52b2c7eb, 0x01cb59bd, 0xb3923dfc, 
	0x6567e716, 0xfd4b8e9c, 0x398ff630, 0x94ff207d, 0x0e481c9d, 0x6ea98adf, 
	0x05309b0e, 0xc8ec09bf, 0x9b0e0f43, 0x7a136c60, 0x9263e1d3, 0xc399f41b, 
	0xe6814aaf, 0x3f52f7e8, 0xd1f90620, 0x160cfdc7, 0xfa0c7f04, 0x35e6b8b7, 
	0x69f09da1, 0xd1aba72a, 0x35ffc862, 0x00e3822f, 0xc5a5c7ff, 0x1ef761c0, 
	0x297e9f3e, 0xfea2bf4e, 0xd7077d9c, 0x878005af, 0xa7373ed2, 0xcfe833a7, 
	0x4fbff4b4, 0xfabdfe7f, 0xa7fadb12, 0xdc8275f0, 0x65f57bf9, 0x42fb1a49, 
	0xff76197d, 0x6a8bd385, 0x395fcfd0, 0xfb0dbbfe, 0xbf9e63eb, 0xe53f80d5, 
	0x3d86bdf9, 0x5eb137f6, 0x2f39fc06, 0x979467df, 0xe75f29d2, 0x94b265f9, 
	0x2b3cc1ac, 0x066bbda7, 0x4152c065, 0x341d928e, 0x42740fa4, 0xbd041ffe, 
	0xd2db76cf, 0x934c31d9, 0x1abda9d2, 0x6f077da3, 0x7fd867cf, 0x35ee1cc9, 
	0x979521f8, 0x95fc1bf7, 0x971f61c6, 0xbd2cff2b, 0x81eb8ff0, 0x27ff4c7f, 
	0xe499cbd2, 0x4e0e947e, 0x76cfcfed, 0x29e39d7f, 0x6a6af1c8, 0xf685fe06, 
	0xfc80b74b, 0x34a17486, 0x79d7f244, 0x8c0e5a01, 0x333f657d, 0xdd4c3ca3, 
	0xc7a81cce, 0x3820c54d, 0x3bbf461f, 0xe04de7f4, 0xf6643a9f, 0xb780758b, 
	0x8f0ee7e9, 0x5d9255a6, 0x05a57ce6, 0x9fd0f0fd, 0xff42ef56, 0x659b2995, 
	0x93a6b3c4, 0xd1a858bf, 0x4d8216e0, 0xbfc631b2, 0x6e99952c, 0x862193f8, 
	0x8fe42bfe, 0x7ea7f347, 0xf64bc37b, 0x3f33ff18, 0x5c6b8bf4, 0x635d8c03, 
	0x680eb1f1, 0x9d65f2b2, 0xea016cfd, 0xb365bd2f, 0x76abe51d, 0x945dc6cb, 
	0xc649be5f, 0x4793f67c, 0x9855fc62, 0x0de93a5d, 0xe82d7990, 0xa930b72f, 
	0xded440f9, 0x55d31aa9, 0xeecae8ec, 0x6cb99462, 0x49fba7ea, 0xdf75542f, 
	0x3dda1571, 0x49f73ed7, 0xadda007a, 0xa2f1e74b, 0x8cd4da6f, 0xf9af807e, 
	0x5fba5341, 0x3586fb26, 0x69fc426d, 0xe7e82e19, 0xe8cf454a, 0x58f41668, 
	0x5308fdc7, 0x8031c629, 0xba58b52e, 0xc4aef1e4, 0xe599d8f8, 0xd437b092, 
	0x5b5e3b78, 0x718ae824, 0xfc46653a, 0x5a80ed0a, 0x51f62f21, 0x1351f6af, 
	0x4d93c7a7, 0x35767e9c, 0xdee73d53, 0x18fda8e6, 0xcbc5778d, 0xd727b051, 
	0x52ccfd22, 0x04fc90d8, 0xe1365fe4, 0x1e309a4f, 0x40f18658, 0xd03c7982, 
	0x9712abe0, 0xf7216ba0, 0x69f583ce, 0x97d81afd, 0x5f64a997, 0x0eb372ce, 
	0x87621173, 0xfc493d91, 0x03c68be0, 0xb34c824b, 0x078d113c, 0x1a3c1f12, 
	0x2b012f6f, 0x8da83e71, 0x65d94ff2, 0xb954aec2, 0x78c32b1e, 0xde22c21f, 
	0xbaff1137, 0xe7aa3bae, 0x3f339425, 0xc42872e4, 0x8b7e4ee5, 0xbc93352a, 
	0xcf1c4dd6, 0x0a7a4ccc, 0xf7f283c6, 0x136b183a, 0x5b65dbd8, 0x9da327e6, 
	0x98dc60cc, 0x3065ba9f, 0x3aebe919, 0x6d27e795, 0x94ca7419, 0x603a99af, 
	0x262d967c, 0xc9258b8a, 0x2f8329ec, 0x58409c68, 0x5c9640ab, 0x08b19d33, 
	0x932bca7c, 0x586ed724, 0xb1349fac, 0x3ba416ec, 0xc02c759d, 0x60ca8fef, 
	0x976bb3d6, 0x0abd2c6a, 0x2af26bcb, 0x0fffe386, 0x3e6afe3e, 0x324f187e, 
	0xb76816a6, 0xed1f8623, 0x67fef537, 0xa63f0c4a, 0x937fe426, 0x621b9db1, 
	0x0e54b1f8, 0xfc055a2d, 0x305ad59f, 0x91c616b6, 0x68bdad94, 0xdf908bc4, 
	0xfa69fbae, 0x7a982c5a, 0x01314993, 0x81074a4e, 0x53ed609e, 0x4b5b489f, 
	0xae616376, 0xc421fa46, 0x80d7c6ed, 0x0ec84aaf, 0x83f48d7a, 0x505537c1, 
	0x9ee505b6, 0xbf18e99f, 0x34bd7e24, 0xb7c43fca, 0x9fe667bd, 0x180bfb2b, 
	0x87c1abd2, 0xfa4fcb67, 0x92376e22, 0xfc12135f, 0x5a99e304, 0x0859d83f, 
	0xaee2bef3, 0xa114360b, 0x955ee81c, 0x9af807ee, 0x1e90bf9f, 0xac8940c0, 
	0x0c5a43ab, 0x3c3b0a1f, 0x88fefed6, 0xe8774ff8, 0x13aa77c4, 0x457fd1fd, 
	0xe705711b, 0x6bd7e443, 0x19d3077b, 0xe9f3abf0, 0x66403217, 0xb8c67e02, 
	0x7a188f3c, 0xdf5f38f0, 0x4fcf5c45, 0x6fbd175e, 0x36238f33, 0xf96125b4, 
	0xc6be5e71, 0x6f09ffa8, 0xcfc391af, 0xa9cbff61, 0x77ae64ff, 0xb58f4b3f, 
	0x706ec3fb, 0x54ece329, 0xd7d50653, 0xce583b0c, 0xec2f6d88, 0x0df2f2b6, 
	0xf3c2be46, 0xf6de85bb, 0xead64fcf, 0x683e0521, 0x2f53be82, 0xc0a52537, 
	0x6e5e953a, 0x1804a7b2, 0x1e0cdffb, 0x39854db7, 0x00f67c61, 0x4c4709e8, 
	0xc033707c, 0x5ea03717, 0x375acdd3, 0xfe800fa4, 0x9bdb187a, 0xac1757d0, 
	0x5f4dbc07, 0x5155f5ca, 0x177afb26, 0xad4e97c0, 0x29d560f8, 0xfe97c0e2, 
	0x6071e248, 0x876e4f55, 0xf06576f1, 0x8af54fb8, 0x48ab258a, 0xb1bef9bf, 
	0xfe5fea0e, 0xd8bef0f9, 0x17c2ea78, 0xc74f2d8e, 0x2fa66df8, 0xe2e90bbd, 
	0x1762c0e3, 0x58fcbf94, 0x9914bae0, 0x1d2955e2, 0x6adfc9bb, 0x3c456cdb, 
	0xe1e3957c, 0x19a78188, 0x785d7871, 0x29d910c3, 0x97ae72ce, 0x9413b0cb, 
	0x9b1b20a7, 0x1548082c, 0x982f509d, 0x7367f861, 0xcadfd032, 0xb4f9022f, 
	0x2389c781, 0x389c7907, 0x9879e909, 0x2802f951, 0x20f950af, 0x0af85f95, 
	0x8260ff23, 0xcdcc614f, 0xff2a9f20, 0x85993875, 0x9f800f51, 0xb651eb01, 
	0x1d26ec1f, 0x7c8add53, 0x4e1bda54, 0x7079bd43, 0x39f110e5, 0x6469abf3, 
	0xe84f155f, 0x40f48901, 0x7717168d, 0x12b1b8c4, 0xfc30df13, 0x2b6ec340, 
	0xf9037b07, 0x2d23f4ac, 0xa078c195, 0x7df6890d, 0x430ffec0, 0x93a4767f, 
	0xe6ffc161, 0xd8c1dc68, 0x162b2a47, 0x2bf85e72, 0xf1fd3565, 0x7f0485f1, 
	0x7e09d4b3, 0xc3e71d51, 0xaaa1ff58, 0x9c2ef871, 0x35571197, 0x4ec343ec, 
	0xfe067d20, 0x204dd543, 0xfea38617, 0x9edfa269, 0x788c8728, 0x1891d938, 
	0x136591ef, 0x27b213ea, 0x97214e93, 0x98fda4be, 0xf4488718, 0x8ffd1377, 
	0x6181f898, 0x8faeca5f, 0x2e263c71, 0xcaed1307, 0xf0e63cef, 0xec0becca, 
	0x529f6e09, 0x9de4887c, 0x28fd0b2a, 0xacbd9077, 0xf0a71dcb, 0x22df71a7, 
	0x1f974f16, 0xc5a66b77, 0xe902ff7c, 0x3bde312c, 0xa6f1d043, 0x35e71e0c, 
	0x1b3f44d2, 0x6f78f1cb, 0xbc7c4657, 0xdbf387b7, 0x537fce7e, 0xce3b1ca0, 
	0x6ce3f426, 0x1c840ff7, 0x5c89fee3, 0x3fe4526c, 0xfc099a42, 0x95cbed05, 
	0x90ccf88c, 0xf165771b, 0x298dbffe, 0x1d6297f4, 0x8e7dc648, 0x2d7d1494, 
	0x6f5d8ff1, 0xc3bcb8c2, 0x2f5a63e7, 0x6ed64fc0, 0xd61bf8c7, 0xb2fa82ef, 
	0x7df8c1e9, 0x34d2c7b0, 0x83ef83f4, 0xbf46eeff, 0xb3fa0ed8, 0x1f03d443, 
	0xbaa56cbf, 0xebc7d5bd, 0x5bea04ff, 0x043e001e, 0xeb0ca05f, 0x057e9e01, 
	0x14dbf172, 0xb4cd5507, 0x1dfc896f, 0x19b9bb22, 0xbbf43aed, 0x0fc085ad, 
	0xccbed42f, 0x27dd0446, 0xdd93bf11, 0xd2dfe867, 0xbfefbb44, 0x23eec8d2, 
	0xc831edfb, 0xdb8d51bf, 0x9c6d2df7, 0x7da607d8, 0x3d076061, 0x8074768c, 
	0xf71273c7, 0xd46fcb85, 0xfe18a64d, 0x5eff1aad, 0x9273fc5c, 0x23f1175e, 
	0xc680ffb2, 0xe29d1553, 0x0f18c98c, 0x83edc5f2, 0x49cf7df2, 0xffa27476, 
	0x316867a6, 0x8c0a4576, 0xf109e51b, 0xe7a7a3cb, 0x7488f647, 0xb898fc56, 
	0x637a5cff, 0x733edc63, 0x4f90a369, 0x455e5c0d, 0x1f9ccae3, 0xfb24fe0d, 
	0x2fe51023, 0xb71f8195, 0xd9fc54ef, 0xfe8208ef, 0x3c8fea91, 0x59f025ac, 
	0xafd7134b, 0x125f9856, 0xb42b57e8, 0x7ae4e497, 0xeaebf515, 0xea0fe84d, 
	0xafc60566, 0xa61d3806, 0x7197fa1a, 0xa5a5507b, 0xd340fdc5, 0xd3e87d84, 
	0x886e7f38, 0x6cbc5381, 0x25d01aed, 0xebdf6695, 0xbe910f1d, 0xedc6bcf6, 
	0x8ecd6a90, 0x65fd36b0, 0x2822470e, 0x75872fb7, 0x8ae9023b, 0x8b92c923, 
	0x1ab5deec, 0x4ae961ac, 0xf3a471f5, 0x8f439bd2, 0x6a4bf2c7, 0x65f7d713, 
	0xc99a473b, 0x4f40d55f, 0x487da02c, 0x2f832fe2, 0xcd43c51c, 0x4da917c8, 
	0x6f282f80, 0xa5a954d1, 0x0fcdf80b, 0xc0276d7e, 0x0e6dfb8c, 0x177ecfe0, 
	0x56e767ef, 0xdfc0f6c6, 0x4f77c835, 0xf18e3ed6, 0xf1d80b6f, 0x7fb4675a, 
	0xc51a6f47, 0xea4eca37, 0x78077da6, 0x1b6f6e3c, 0xc755c78f, 0x0ebee3c4, 
	0x4c36a87c, 0xba1dcb8e, 0x7a84d865, 0x8373e284, 0xe9b72e22, 0x9dc78f1f, 
	0xa8970e29, 0xd359c16f, 0xe04d4ec9, 0x0bf3c4cb, 0x893718a9, 0xbf02d38b, 
	0x3c65de02, 0x6a7230ef, 0x131bdd3e, 0xe1aaab6f, 0xce261ee7, 0x39c4f82d, 
	0xa7f0d38b, 0x52622e71, 0x3f1277bc, 0x8f13738a, 0x9d5f4248, 0xe0d7fc5d, 
	0x4cfe44af, 0xe741373c, 0x7f4e464f, 0x47e0c26e, 0x4df71ff2, 0xeed9b7e6, 
	0xcedc9925, 0xf55ce233, 0x8677a499, 0x4ce63c79, 0xd0b1657a, 0x5e86b52b, 
	0x9bf2e149, 0x7a8e8bf4, 0x2f89f045, 0xd365ee9e, 0x6f384de7, 0x7ea49f43, 
	0xf71db425, 0xa2f82679, 0x427a45d0, 0x7ef0b3b6, 0x0f7fcf17, 0xf43e7468, 
	0xa5fd00d3, 0x9c4557fe, 0xf0bc717e, 0x4bf23376, 0xb8c3d62a, 0xf37a27ed, 
	0xd29f5811, 0x23dafa39, 0x8f65f740, 0x7d6d66fc, 0x0b3fdd0c, 0xe7842372, 
	0xfee9122d, 0xd91321c1, 0xa225278f, 0xa4b3d2fb, 0xd033b2fb, 0x3677f63d, 
	0xe133e871, 0x8e4cedfb, 0x3932d7e7, 0x7a59ffde, 0x03ebd59c, 0x9ffd60c7, 
	0x30de7182, 0x35b07486, 0x7f41c793, 0xcdc3e9ca, 0xc7ea23e9, 0x650a9d80, 
	0x3234bfa7, 0xe789519a, 0x275d5862, 0x664b2b08, 0x3c66f76f, 0xdbe9530f, 
	0xd57209d0, 0xb2dea452, 0xeed1cb9e, 0xcf6855d6, 0x469f3d82, 0xb9d3eb29, 
	0x3c308e9c, 0xf38a6307, 0xa25e17e7, 0xf18fac97, 0xcbb727f7, 0x60179bcc, 
	0x5db39f39, 0x66be553a, 0xe507b8da, 0x43a388fe, 0xf40e7ec2, 0x4b15f9e0, 
	0xe5156fa6, 0xf36cea57, 0xebd72c6e, 0x651c5088, 0x6afba70f, 0xc7dafec3, 
	0xf86fdde7, 0x7cf1af3f, 0xd5e224b7, 0xc238706f, 0xbf7612f1, 0xbcebcbc5, 
	0xdbf76cfc, 0x7c180e1c, 0x5e5e4bf5, 0xbfc7e233, 0xfb9070e2, 0xc0398e99, 
	0x05214b27, 0xaa7f45ba, 0xd715e814, 0xc9d7a0c9, 0xf8a2ea74, 0x80e4e3a8, 
	0x21d4e909, 0x264d74e8, 0x7909b3a7, 0x54b5e82c, 0x51696bd0, 0x7e58ff14, 
	0x072587a1, 0xe62b8fd0, 0xacfe80f4, 0xd30af507, 0x14f146fe, 0x3ebd1f11, 
	0x47657067, 0x1a0b9d25, 0x4b31ff45, 0x5636cf9e, 0x6c3affa1, 0xec6360db, 
	0x99639c99, 0xd5890e78, 0x650f24a8, 0xdd039711, 0x15b8c4e4, 0xc99ea1c9, 
	0x5d565b72, 0x93eddb72, 0x2c966ee5, 0x61513f73, 0x9f1174a1, 0x3a367f4c, 
	0xe7f1fcaf, 0x5c8c4a6d, 0xc95ab2ce, 0x48fb2eae, 0x510f494b, 0x14a33d79, 
	0xdc9eb4f5, 0x034a7809, 0xa889fd38, 0xffdf98fd, 0x3b962d68, 0x37205ff8, 
	0xb148bcf0, 0xbf722761, 0x8b5ab530, 0xfc1a178b, 0x941ffe43, 0xf254524f, 
	0x63ffc8f3, 0x0818cf18, 0xe296bc63, 0x58bf5882, 0x1e4251d8, 0xc7f756a4, 
	0xc92ef7c5, 0xa543fbe2, 0x502fb967, 0x59e17e8a, 0xf9540bec, 0x6cf2fc78, 
	0x9e0009cf, 0xc621d334, 0x96affc16, 0x71a27e82, 0xf76cef3e, 0xe933d58f, 
	0xf33b44b5, 0xe4c5fb34, 0x73ecc547, 0xbbf9715e, 0xee403e69, 0x642f5d55, 
	0xcadc6394, 0xae3132c6, 0x5d7e05fe, 0xca2bde9c, 0xce8abfaa, 0x4bc4c41d, 
	0xccabbeb9, 0xe7abbe22, 0x5669587c, 0x9154750f, 0xd5fc77fd, 0xcbe3a451, 
	0x305fd8b2, 0x92f6a55f, 0x54923d84, 0xf858e82d, 0xeb0a691d, 0xb8cb3d35, 
	0xb04b5fdf, 0x598bae6e, 0x1556b737, 0x03eb124e, 0x261dd5f0, 0xa789fa1b, 
	0x810f9b8b, 0x4c784237, 0x4d72ff38, 0x8b1b7cf7, 0x755f9389, 0x8162ba65, 
	0x87215ef9, 0xef8cb594, 0x8d9921c7, 0xdfaf415a, 0xd2dbf1c2, 0x8d04f38c, 
	0x8651fb4c, 0x2b2db9fc, 0x9a555e56, 0xbb9dc343, 0xaf0dde69, 0x4bf981dd, 
	0xc0cd7979, 0x3a1ff0cb, 0x9dfa2f09, 0x7940eefb, 0xdf9e6df5, 0xefbfc861, 
	0x77b45870, 0x3415f8ba, 0x849237b8, 0x6b8eefe5, 0xefe5ccff, 0xcfebe5e7, 
	0xae45bcae, 0x7cc17920, 0x76148e3c, 0x7769596b, 0x0698de11, 0x3cea366b, 
	0x1c93ce9f, 0xf71d31b0, 0xa8a60f97, 0xeb301aed, 0x9de3f574, 0xe436e718, 
	0x1a8a414a, 0x2cf584e9, 0x51ab5648, 0x553814af, 0xbfa5e505, 0xfdb72dda, 
	0x698fd891, 0x7e7b442b, 0xeb4fdf51, 0x933f9128, 0x3e2cdf20, 0xf37cbc77, 
	0x724ffe73, 0xec8eef0e, 0x7b37d4c2, 0xa4cde81b, 0x6acd6d4c, 0xb0de9f3e, 
	0xabd98803, 0x520ffed2, 0x0e95c638, 0x92d997e6, 0x2975ee88, 0x58edf402, 
	0x002b16a4, 0x62b46bdb, 0x9b356005, 0xd34905db, 0x3192cd1f, 0x8acdda3e, 
	0x394aff89, 0xee64dabf, 0x3a9c1d47, 0xfc0155af, 0xaad907b8, 0xa7fbcc08, 
	0xe4337ec2, 0x599cbb9b, 0xdd4720c3, 0xbcc29099, 0x7affc2dd, 0x64cf0b3a, 
	0xbe8b7b42, 0x79f4899f, 0x4405c3c7, 0x4015d79f, 0xfb7dc80e, 0x22ccc12d, 
	0xb95b3ba0, 0x23cf052f, 0x060c1b6c, 0xd6d8fed0, 0x1c8406af, 0xdb211195, 
	0x340634e6, 0xf6db5190, 0x0fc2256b, 0x57f7d2b7, 0xfbf04bfb, 0x3ddb93b0, 
	0x1c78b33b, 0x7cf05ad5, 0x8d01c616, 0xf317a9f5, 0xcfcd9e98, 0xabae2483, 
	0x355acbd7, 0xbbbc2830, 0x1fa86d5c, 0xb5807a6d, 0xa67dbe52, 0x22fa7506, 
	0xf7945696, 0x62c3ceb4, 0xd77fa19d, 0xe3006c39, 0xbf80b65c, 0x4d7bcb09, 
	0x1a96ceea, 0xef909fc1, 0x2b601395, 0x303143c0, 0x9361e2d3, 0x013f5096, 
	0xd79626b6, 0x7b43e0e3, 0x3f1c241a, 0x5cc81fd1, 0x5b9b27f7, 0x80f6315c, 
	0xf5ce3fd7, 0x13d39049, 0xf516578e, 0xbc70ee91, 0x578c3071, 0x618189ae, 
	0x8c3071bc, 0x027ebe37, 0xaf2c4d6c, 0xa436c1c7, 0x7ca28fbf, 0x485afd61, 
	0xb4c61b4e, 0x5c6126de, 0x7651f214, 0x2039394e, 0xa7ae8185, 0xf21b5938, 
	0xfab5b79f, 0x34add6f1, 0x8a1fc7be, 0xa19bc7c5, 0xfefc65c7, 0xc8e3fd66, 
	0x2e71365f, 0x6649ca64, 0x872273c3, 0x68cb0f0e, 0x85294e18, 0x7b601676, 
	0xb00c2daa, 0x3bac0377, 0xf6180fd6, 0x3b2c8a92, 0x806427e1, 0x50f6841d, 
	0xb38b4046, 0x6101bddf, 0xfdb9fbbf, 0xb29f7c61, 0x60ccc7c6, 0xe2cf1d27, 
	0xd87c06f4, 0xdbc07a86, 0xc166da1a, 0x0c2bf6f1, 0x052b8fd5, 0xf34dd1c6, 
	0x8f371ed8, 0xb76f57df, 0xa3e43c22, 0x25597275, 0x5eebda1b, 0xe377943b, 
	0xc6b766ba, 0xcef18f9e, 0x61dac351, 0xc2d13f48, 0x8bba0768, 0x0748ad5d, 
	0xcd1293de, 0x9f8c1ddb, 0x2f38d797, 0x6e560653, 0x56c7ca24, 0x1de8279c, 
	0x0297506b, 0x701f2e66, 0x9798c6df, 0xdf3f183b, 0x06675f83, 0xfee1b47f, 
	0x71b8b797, 0x5037e1b7, 0xf9014efc, 0xfbbe21d6, 0xd376de89, 0xfaf847fa, 
	0xd2355a8f, 0xfb43f8b3, 0x3d059c27, 0x4051bea2, 0xfe88f57e, 0xf28a44c7, 
	0xfbbfc5c9, 0x1d5ff718, 0x5167a0b9, 0x64ca05be, 0x5f2187c4, 0x0403c758, 
	0x6cd7f27f, 0x78a0cec3, 0x0d8eb321, 0x33ffa84a, 0x61ca9bc7, 0x683e7d00, 
	0x72b6f419, 0xc5ecbf65, 0x23c07e62, 0x3e45affa, 0xb4039e2b, 0x2b58fb56, 
	0x4ce8c7d0, 0xfe2269bd, 0xc0efc56f, 0x175f80ef, 0xcfeb4f2c, 0xcbf6ad21, 
	0x0efc216d, 0x6bfc1b72, 0xa9560545, 0xd6beefc5, 0xf6c72836, 0xf287925f, 
	0xe78ff66f, 0xb7bd5c90, 0x946ccae0, 0xc773d67f, 0xe8ad82f3, 0xa43cb1cc, 
	0xae72678f, 0xa5fd46ca, 0x1b4e61ec, 0xf2699fed, 0x0dc661eb, 0xfc078c2a, 
	0xa1f31996, 0x9f5991f9, 0x5a0fe384, 0xa7942532, 0xa42f16fd, 0xd6833bce, 
	0x1e534822, 0x94ceb7ec, 0x45df8fc8, 0xe95fc0fb, 0x9abefae6, 0xa97e1be3, 
	0x527ef11f, 0x3f6a424f, 0xd2d240b9, 0xfcbcff51, 0xa40548cb, 0xb3f234ea, 
	0xa6e3ca2c, 0x1fc19755, 0xdb86d4b2, 0x71fe069b, 0xd7ffb47c, 0x23c69738, 
	0xedc7981f, 0x11effeb8, 0x41c6bf6c, 0x8e82bbf0, 0xb1d10f50, 0xd9e0170e, 
	0xcbf1e9c3, 0xffa83fe8, 0xe8379639, 0xd87e9131, 0x0e85fce9, 0x49e1e917, 
	0x2cd91a71, 0x6592dea1, 0xc377bf13, 0x0ed95fe6, 0x98572af3, 0xe88879cb, 
	0x2f842df0, 0x092d3b04, 0x2fa176e0, 0x80f98837, 0xed1eb8dd, 0x476879ac, 
	0x5bc978f3, 0xd0f3eeb8, 0xbb610e1e, 0x1e5fbe3c, 0xcec0f680, 0x830310bb, 
	0xbddb46cf, 0x0a4de408, 0xa28db5c8, 0x7d848bdd, 0x69c44f3b, 0xf5add520, 
	0x4187fd8c, 0x7aea8dff, 0x66c8af8a, 0x0eb867d2, 0x1d7cb51d, 0x80843ec4, 
	0x279e3355, 0xfb9b3bbb, 0x7d632f0b, 0xd1117c42, 0x72c2ced1, 0xebe6dec3, 
	0x3c2542b0, 0x3d705658, 0xa58be4c9, 0xc95f8076, 0x0b5271e6, 0x97be07e2, 
	0xee2a58bb, 0x62e85dbf, 0x2627ce43, 0x3129e7e3, 0x259f9f8f, 0x1f882c7e, 
	0xed04376c, 0x51f026de, 0x351f8718, 0x4417d215, 0x3f9784bb, 0x7e02f146, 
	0xfe717ae3, 0x562e9e32, 0x039d3846, 0xd868b401, 0xe1d6998f, 0xe142f84c, 
	0xc57b4118, 0x7894e33d, 0x8758d77a, 0xbe88abb1, 0x22f4fd9f, 0x44b28fce, 
	0x1fb607f6, 0x4447ed11, 0x7ed111fb, 0x8b87ac44, 0x5419a1ec, 0x827f68df, 
	0xd057823f, 0xcdbbc1f7, 0xefd15dbc, 0x9eab7e24, 0x559f5719, 0xbde3435f, 
	0x278c5d3c, 0x7cfacf81, 0x21bc91f7, 0x372317f9, 0xf361b64d, 0x7dcfc06c, 
	0xb386cf42, 0xb96cea78, 0x8b43d398, 0x849a17c1, 0x4d2e5dfb, 0x50fb5c97, 
	0xa5273d9f, 0xc25d6c01, 0x51433352, 0xb4e319bc, 0x284d7c46, 0x8d369937, 
	0xeecaf5c6, 0x057d8d0b, 0xeedc9c73, 0x3ff293bf, 0xf9e5c818, 0x1c26e196, 
	0x04ef9f4f, 0x6f34d78d, 0xe340acdc, 0x6975a7d6, 0xe198c693, 0x6598d4f7, 
	0xc5103ce3, 0xb05f256b, 0x1973fd09, 0x47dfcff7, 0xf52adfd8, 0xad75fce2, 
	0x361bf293, 0x1da8a14b, 0x8a985b2e, 0xa16750e5, 0x5ef20c9d, 0x318f7947, 
	0x2e3aecfa, 0x934cc647, 0xabfa08e5, 0xb90e1f14, 0x493c3e29, 0xfd29809e, 
	0x5a67f90e, 0xfcfc7bd2, 0x8710fd91, 0xb61ca3ed, 0xd826147d, 0xa6529276, 
	0x61f1e2ec, 0x69a42f65, 0x83b5955e, 0xa45694ff, 0x58d9d75a, 0x72f71ed4, 
	0x7a693c7b, 0x748c8e4e, 0x3c24d6e2, 0xff307237, 0xb3ea333e, 0x62c6ae8c, 
	0x7b38aaff, 0x758149bd, 0x7b73e657, 0x6f1397dd, 0xcce52baf, 0x64abeb84, 
	0x36778a42, 0x7a675c44, 0xbbd7b08e, 0xefaf6443, 0x7b2375c2, 0x3d60721d, 
	0x60947fd2, 0x1fd4dfaf, 0xdb674580, 0xbd84d3ae, 0xbd5792ae, 0x76e71d4d, 
	0x01e305fc, 0x6db2c73c, 0x9d878726, 0x20b92e3c, 0x67d3b0c7, 0x4eca9ce7, 
	0x69feca67, 0xb0b57f62, 0xd6d1e283, 0x6b7fb869, 0xfac3cfdc, 0xfb0ed728, 
	0xb171a02e, 0x10d3f9ee, 0x78c57b4f, 0x8543e94d, 0xd7f3f08c, 0x9fd7e883, 
	0x31cf2ec8, 0x87e40aec, 0x09a5bb18, 0x76114069, 0x0d57c80b, 0x278189e5, 
	0x84517ec3, 0xf618a2fd, 0xbf61874b, 0xcf533908, 0xec89cce5, 0xffb872cb, 
	0x43dc50ac, 0x76beb8d5, 0x3815662f, 0x6bbe656f, 0xd35ffa1f, 0x149acc83, 
	0x693b34a2, 0x20e2b198, 0x8c7dec93, 0xfc2396dd, 0xda8b85b1, 0x5ec9fc71, 
	0x85eda4d6, 0x84d5d2b4, 0x7f74eb76, 0xe033515f, 0x67e352db, 0x57c87f68, 
	0x006b5907, 0x5e6fce61, 0x7c61f317, 0x2828b2c1, 0xa07e51b7, 0xe10fb5a9, 
	0xcf1b6b40, 0x3fcc6667, 0x822f67c7, 0x1fd05295, 0xb4fb25e8, 0xe503ed09, 
	0x3db6bbba, 0x670fed04, 0x12fe48c3, 0xaccb175d, 0x3de197ad, 0x507649aa, 
	0xf284cfa9, 0xb4ea0924, 0x863b262e, 0x88a49eec, 0x8a4ffa9f, 0x0473fd80, 
	0x3cb5fbea, 0x7c472efc, 0x6aa4ee34, 0xde3077b0, 0xb8d3f117, 0xf7d708e5, 
	0x70934fb2, 0x7416f71c, 0x7689ff53, 0x93a03593, 0x029ee49d, 0x1efdc4f8, 
	0x7bfc8f28, 0x22deb926, 0x89d605e8, 0x3c84e6e4, 0xbc1256d2, 0xa2b387ea, 
	0x4636b6f2, 0x6479093e, 0xec66e972, 0x42d7cfb7, 0xfd9c3af4, 0xb9c60e50, 
	0x11b7644f, 0x9cdcf95d, 0x50fd70ae, 0xc7568f8e, 0xada4bfef, 0xf22af45e, 
	0xb8fd6b8b, 0xb0a766e4, 0x1a3cd55f, 0x676fc187, 0x6336bf6b, 0x6de8207f, 
	0x8a326ae7, 0x848fc069, 0xf3933cfd, 0x6ba1d108, 0x6091d801, 0x54d9a7c7, 
	0xef584ee7, 0x073f2f12, 0x27afd393, 0x66695c63, 0xcd4b8f07, 0xf3c4f582, 
	0x894ca38a, 0x75f1771b, 0xf8c0dec7, 0x4c271181, 0x61bf72f3, 0xf0b00b16, 
	0x11e7a38f, 0x51a7fd8d, 0xdf918310, 0xf72a6340, 0xf50f4c4b, 0xca33583b, 
	0x13a77e8d, 0x74f991c6, 0xd2133930, 0xc9fd3dec, 0xbf3d483e, 0x63f14c69, 
	0xed3fd25c, 0xde7bc435, 0xf9053d7e, 0x8d66f475, 0xe6aa4af8, 0x7f6a357c, 
	0xa216c5e0, 0xb0d6e7d3, 0x639cfe18, 0x887da74f, 0xee7e7639, 0xc1d7a0ce, 
	0x428e7e1c, 0x515eeb17, 0x40e5439c, 0x1c60765e, 0xfcf1f303, 0x1c8cc544, 
	0x421f7c5d, 0xd1df8979, 0xf11979de, 0xd15e7a8a, 0x0a9db83a, 0xfdb44f69, 
	0xf90c73f9, 0x941ad0f1, 0xdaec731f, 0x7313941a, 0x45e2a7fe, 0x1e3a1fce, 
	0xde73628f, 0x5dfb9801, 0x63cc3229, 0xac062bce, 0x5f7e5327, 0x93579458, 
	0x0331ff29, 0x9f049dd6, 0x5af28b0c, 0x092f962a, 0x8bf6a484, 0x6eb1f531, 
	0xfa9dcf0d, 0x945df6a4, 0x43d1ffee, 0x759d3290, 0x525b5f82, 0xdeb4dbd3, 
	0x67f0e98c, 0x8690957d, 0x2b48c17c, 0xa7f5aaa6, 0x8fd22f14, 0xac0077ac, 
	0x0be27df0, 0x115bea1d, 0x3754c798, 0xfa24cbc7, 0x7a4d98ec, 0x39bacd7a, 
	0x65f47ee2, 0x2f3c6f04, 0x26a7d04b, 0xa64da7bf, 0xb41f3ed3, 0x5e944f78, 
	0xc4a47b0d, 0x340dfbc7, 0xca26f55d, 0xeaedf3c3, 0x2709703a, 0x2ff237fa, 
	0xfaeb6bb0, 0xf3ae5842, 0xa61240cd, 0xa1ba6f69, 0xd6ced07c, 0x7cbceb75, 
	0x68a781a0, 0x46a894b7, 0x286f69bb, 0x497cfc23, 0x66aabb5c, 0x63ce867e, 
	0xe81addeb, 0xa37a92bc, 0x585be77c, 0xb6bb22fe, 0x70fcb63e, 0x02576f0e, 
	0xfb947433, 0x28872949, 0xde52ce8e, 0xe4f4f1e3, 0x7fa2cc77, 0xf93d5e7e, 
	0x8a7f18f5, 0x6c671fbe, 0x875f5dae, 0x81c061f4, 0x40dfb7a6, 0xebb329be, 
	0x5a3d356b, 0x039e3e7f, 0xeb9afe02, 0x7444dfd0, 0x7d7c5fbd, 0xd20b8e07, 
	0xb1a5d721, 0x40df3bf5, 0xbb75f9f9, 0xdf4fad16, 0x5fefa2af, 0xdf09abb3, 
	0xbf1d7edf, 0xd7d7679f, 0x8b7f7c24, 0xbebb73ec, 0xd84fbf1e, 0x7e6fc8cf, 
	0x5ffbe7a4, 0xffb77d24, 0x9cdc9a7c, 0xb8c60077, 0x49f3dec4, 0x4579cc40, 
	0xbf22fdc0, 0x7e5e79ef, 0xec37cf2b, 0x898f39ad, 0xdea2ddef, 0xbd79e7c9, 
	0xd26f5e31, 0xefeefbfd, 0x437e3c10, 0xbec3e090, 0x623a73af, 0xff6f7443, 
	0x4281812b, 0xcdb697dc, 0x79442feb, 0x34ead077, 0x7184b9f4, 0x74d683ba, 
	0xc8495701, 0x2680969f, 0xfda61cb7, 0x0da5a925, 0x13abd1e4, 0xe45634fb, 
	0x3c9ddb33, 0xc6fb880e, 0x67f4f788, 0x82d57c8d, 0x64fe977c, 0xfc27dd3f, 
	0x814de006, 0xa7bf9275, 0x0f3d8eee, 0xe4c056e4, 0x80768975, 0xb943969e, 
	0xd8fe40f3, 0xb670e3ee, 0x1f3059a2, 0x46b9e3eb, 0x9d181fdb, 0x2a28f4c7, 
	0x6f343bd5, 0x9af182dc, 0x7059854c, 0x155fd21d, 0xb73a3efb, 0xcd14532b, 
	0x4e6df68c, 0x3321e823, 0x6fe44f8e, 0x8d317ee5, 0xab8e2b6f, 0xb9ec7771, 
	0x87b09b1b, 0x3f8f3899, 0xce362fc9, 0x6f8d0039, 0x1ee0bb04, 0xc9f2df9c, 
	0xf649ad76, 0xc3c37fe9, 0xff786732, 0x14fb8ce2, 0x13675ec2, 0x73f04fef, 
	0x1e78c306, 0x7d3cec81, 0x6377fc80, 0xf2e5425f, 0x7a86f11f, 0xe39536d5, 
	0x09514b2d, 0x94e4939f, 0x52e494ab, 0x9ff08f7e, 0xae090794, 0xd738c579, 
	0x15393a74, 0x91bd9376, 0xd126a720, 0x69bee065, 0xf61fedb1, 0x273d53b5, 
	0x7b61a7d3, 0xd3ca5d06, 0x5e5d12b7, 0x514ef421, 0x0d6bb739, 0xe6e75afe, 
	0xe1e7c97a, 0xbd732ca9, 0x7dbcf0cc, 0xb4339d3b, 0x537b4125, 0x1b1cd72e, 
	0xe95e3442, 0x13380b48, 0x679db847, 0x892b75c1, 0x1b2afba5, 0xfae279d2, 
	0x36a8094e, 0x6bc07ba4, 0x1afbdc7a, 0xc5329e22, 0xb9d1b6ae, 0x10217038, 
	0x2bd2533f, 0x57ba0b76, 0xe3a22f90, 0x3bdf5462, 0xbca3a7ac, 0xe96b0ef6, 
	0x4fbc3eca, 0xe1587ee2, 0xee3a5676, 0x037fc9ab, 0xa8f80abf, 0x22f4fd0a, 
	0xa42ab3f4, 0x743fc86e, 0x8814bd4e, 0x0f4fea60, 0x067a7f50, 0xae743f96, 
	0x530f726a, 0xc6aeee9a, 0x25610f73, 0x93ee1b70, 0x736e2856, 0xdf3a7fb4, 
	0xef8e04fe, 0x2b7f6e7e, 0x4b7f0be7, 0xf708fb6f, 0x8e3c3cfb, 0x7b6bff6c, 
	0x301fde06, 0x354d89ce, 0x7bc489fc, 0x77a67e77, 0x7ba43a72, 0x9f767f77, 
	0xa4dddee6, 0x719a3ff3, 0xa1ec9a4f, 0x8b6ab36c, 0x40943f3b, 0xe57ec6ff, 
	0xf547f699, 0xcf29d98b, 0x73d97dd5, 0x55e89379, 0x22fc81b9, 0xc77f0f5f, 
	0xf891ce64, 0x34ec797b, 0xfb0ef2f7, 0x35bc910e, 0xf139e7ee, 0x7ef814bd, 
	0xb1fd12d1, 0x8d59b8ad, 0x9fe4a9fb, 0xbc54fd89, 0x771b579f, 0x31e28f5f, 
	0xc71860a3, 0x5f7127ce, 0xb9c24a75, 0x88f7c9ad, 0x014c3af8, 0x63edc634, 
	0x4e5d619f, 0xcc4afe7b, 0xddf7ccff, 0xfc4defe3, 0x9825d7d3, 0xf25f2eb0, 
	0x9f61f41e, 0x677283db, 0x0cdcfad2, 0xf81113eb, 0x7ee27ac7, 0x243ae246, 
	0x5c4e97de, 0xc36ef817, 0x7d6369fd, 0xd2e4ffb2, 0x89f2314d, 0xf38dba29, 
	0x06db970f, 0x7a5c929f, 0x9afcb274, 0xf7e1471c, 0x96790cd6, 0xb4bec728, 
	0x721bb2dc, 0x8fa8298b, 0x25b971ff, 0x32dc8599, 0x2a5adc91, 0xafca14e4, 
	0xddd3826a, 0x2fa73c21, 0xb997ee29, 0x7a700abc, 0x924cf1a5, 0xb721765b, 
	0xa8ef6198, 0xf63eb819, 0xf5032d1a, 0xef42f3c5, 0x8daadc92, 0xfffddb9e, 
	0xffaa3f96, 0x8fe41fe5, 0x294e79ef, 0xf9cbbebf, 0x280bd0c3, 0xc09c44c7, 
	0xba4ce3ce, 0xca04f51d, 0xb8238c31, 0x3c8fdc3d, 0xa407f682, 0xa7b01481, 
	0xe0cfdea0, 0x26b079fb, 0x475ed0b3, 0x79a5dbc7, 0xacc0fcf0, 0xd1d634e0, 
	0xdeb1f3cb, 0xcbfb9912, 0x079a9c4b, 0xc0b37dc3, 0xd98ce962, 0x55859dcf, 
	0x474bf663, 0x12b85c97, 0x0159dcfd, 0xb51f1758, 0xf6623acf, 0xc5761105, 
	0x152e9fec, 0xd7b606f7, 0x1856b1a7, 0x2ca107f7, 0xc1760ad6, 0x13fb0776, 
	0x8e341bfa, 0xadbda215, 0x747f7da2, 0xb82f4b5c, 0x00e307a6, 0xb5c6138b, 
	0x5ae334f8, 0x38c3f30a, 0xbe3162de, 0x5be309c5, 0xbdf1aa7c, 0x76ff9d1f, 
	0xc729c67f, 0xefc3c5b9, 0x184e2e9f, 0x943fe1a7, 0x8ce7df8c, 0x06b657a7, 
	0x2d748fcf, 0x68bf2f28, 0x1791631d, 0xeed1cb2b, 0xe768a40f, 0xf7c20e77, 
	0x66f705a5, 0xdfd61158, 0xbbfb867c, 0xd035baca, 0xe2933e8e, 0xfc5ccb68, 
	0x7ed18e1c, 0x41d945e4, 0xad150607, 0x48dfcf10, 0xfef7deae, 0xf66e7a04, 
	0x56f8b99c, 0x667ec4cf, 0xe74cc057, 0x8f3fa1a3, 0x29ede212, 0xa5b7aa3e, 
	0x6bb796bd, 0x75ec63af, 0x1ab78f0f, 0x9e2ecfed, 0x0b07368b, 0xbadef664, 
	0xf46fe80d, 0x2295b687, 0x2643300e, 0x8c675186, 0x3646c5e1, 0x4ac779ec, 
	0xed033afc, 0x1fc213e0, 0x1748f13c, 0xc009d3ad, 0x09d7d20f, 0xa3b3b687, 
	0x84f7b193, 0x81fc78fd, 0x4f33b22c, 0xeb587204, 0x3f5f311f, 0xf631a5a9, 
	0xb654f774, 0x7ebdf703, 0x39f08f38, 0x95c2f2ba, 0x744e3fb8, 0x03b2eb0c, 
	0xf206d8e6, 0x0fd2076e, 0x0830ff8c, 0x1d975c2c, 0x90758230, 0xf9f3147f, 
	0x309ec2bd, 0xf7b8f3e5, 0xe7cf1b92, 0x2e21c0fb, 0x5c3496cf, 0x3ce0e1c8, 
	0x952583a2, 0x8528cff7, 0xf4b19975, 0xedcbf3f9, 0xf879cf00, 0x2177f445, 
	0xb7f28d5d, 0xefc6deab, 0xe3aa2bd1, 0xca53cc18, 0x9806ec63, 0x2fd79fc7, 
	0x12b6a8bd, 0x9cecfdfa, 0x195aebcd, 0xf4b6563b, 0x2f81dbf6, 0xbd383d8f, 
	0xc256e6f8, 0x67c63973, 0xdfeb458f, 0xe3846c7a, 0x5f1d797d, 0x5a8f3c07, 
	0xfbcfcb9d, 0x991faf1e, 0xd5b60597, 0xfb47d92c, 0xeaad8b98, 0xffb81ba3, 
	0x0c9cd35f, 0x4ffb32f9, 0xacb6f701, 0x1efe7cc5, 0x0769f319, 0xcf160e90, 
	0x8c42f7fe, 0x681d3e6f, 0x3006572b, 0xc01479b5, 0x3cb913fb, 0xb5b47b4e, 
	0xde033344, 0x01d8036f, 0x42f07dfd, 0x379401e6, 0xec5a374f, 0x77405ef8, 
	0xfb83d6b6, 0xd54e2542, 0xff61a981, 0x75f2e467, 0x9ad1d233, 0x55571101, 
	0x7d5718ed, 0xc5176864, 0x25f99751, 0xe10eb9b5, 0x13fa3b4a, 0x1dbc4525, 
	0xe0b644a6, 0x1ab2d2be, 0xf6029c36, 0xfb9737ac, 0x3c952595, 0xaee2fdff, 
	0x1b5f782d, 0x450fb3f3, 0x30a65dfb, 0x7459799f, 0x922d97fd, 0x3f405a1a, 
	0x74ae3495, 0x794fdec6, 0x577aa6da, 0xaafb18db, 0xb2496798, 0x71e690ba, 
	0xec6741e4, 0x97c866bb, 0x47ac30b1, 0x2505da21, 0x172e5dda, 0x8151c7f0, 
	0x36a7a44f, 0xd028e7e8, 0x4115c909, 0x812ba327, 0x8e7f812e, 0xb923cf76, 
	0x3cce7472, 0x2f1a3f2e, 0x2ba3fca4, 0xd6542f16, 0x47217d43, 0xb9006a9e, 
	0xe3f90051, 0xfee22f6d, 0x1cc689e0, 0xd0e3dba2, 0x1fc5ee1e, 0xe963639f, 
	0x03367e3c, 0xd96b3fff, 0x41a62fa3, 0xbc0d87fe, 0x7c03f51c, 0xa6f963b0, 
	0x1f3f1117, 0xd14ff43a, 0xe301dedf, 0xd745f0ea, 0x26b3f01f, 0x716b020c, 
	0x886f18bd, 0x05f1678f, 0xeaf8f973, 0x7e8ff8f9, 0x9afba366, 0xabe00f34, 
	0xdf40c5c5, 0x89819f40, 0xd5d49d77, 0x03970f11, 0xfda263ed, 0x162fc84d, 
	0x40c49c63, 0x9e381fc8, 0x6d8c29a3, 0xe61843ae, 0x1e7471f1, 0x1dbd4547, 
	0xf149bfcb, 0xdd67c256, 0x7b39f029, 0xa3e9c92e, 0xcf946e30, 0xba7cf889, 
	0xa6639e6c, 0x3e1ce629, 0x7dfa05e2, 0xf032e50a, 0xfa8762fd, 0x86c7945b, 
	0xb676a2dc, 0x48fd768a, 0xa432ec07, 0xf30ae383, 0xd484dea0, 0xb27801de, 
	0x14c3fa09, 0xda3c74fd, 0xf8117a86, 0x879240e7, 0x2047c8a7, 0x2aa8ed67, 
	0xf717c74e, 0xf7b87e0a, 0x0f17c49f, 0x48be497e, 0x239403e4, 0x6da7ae3c, 
	0xfc47f941, 0xdff24752, 0xe46a768b, 0xa89dae8e, 0x91dd8e37, 0xb6910073, 
	0xd001e518, 0x3217f1e9, 0xcff8431f, 0x33a67bf5, 0xbcf017a1, 0x82da87ec, 
	0x31e718b9, 0x17d206f4, 0xfa51a397, 0xfa514362, 0xf437fa32, 0x8c23c911, 
	0x68f3688f, 0x31fe0d9d, 0xd681e1e2, 0x773c3473, 0xe999a1f4, 0x1dc7efb1, 
	0xc8f6e5cd, 0x2f5cb933, 0x16605e8d, 0x472b47fa, 0x6fd0d97b, 0x83dd154b, 
	0x3bf46feb, 0x95dcc17a, 0x98ea4f14, 0xe51e7247, 0x435dea2d, 0x72161dee, 
	0xcd03c0cf, 0xe60be8b3, 0x03f0e825, 0x972d57c4, 0xbf6728d7, 0xf086e82a, 
	0xd6f02b56, 0x6ab4728e, 0x895b9d2e, 0x32b9cbea, 0xa246f513, 0x6feaed78, 
	0x45eb1f39, 0x8335dc5e, 0xdb450c9c, 0x707b2616, 0xffda79e8, 0x94d47a13, 
	0x9463ffb1, 0x774fa0cb, 0xe13e9ca2, 0x54775750, 0x8f30da40, 0x417dfff8, 
	0xc81eb377, 0xd9dfd0d1, 0xcde5cf51, 0x11d514e2, 0xaa7b7586, 0xdac04723, 
	0xec6e788b, 0x8f870344, 0xfd22e86f, 0x02b77a46, 0xafb70df5, 0x8bfd443e, 
	0x31a7c8f9, 0x0bf8f1fa, 0x056f9ce5, 0x80b90c3e, 0xddf09a7a, 0x267df1c8, 
	0x2a7243f9, 0x394f7644, 0x01c757da, 0xc72eb80d, 0xc3339e37, 0xebe9423d, 
	0xcafff41e, 0xc2f4aee7, 0xf300fefc, 0x03ecc40b, 0x7b720f6f, 0x6da37466, 
	0xda6054e5, 0x98ca2be3, 0x8fe13179, 0x07419ff4, 0x8e7def47, 0x2dd120f4, 
	0xf2e8e1e0, 0xbf73922e, 0x57ba7cc2, 0xf688bdaf, 0x5027a18a, 0x4f40ba5f, 
	0xe3cb993e, 0x3ec5c7e8, 0x07c9d803, 0x7e39fef0, 0x4c167dc7, 0xa449b7d1, 
	0x7b7e8347, 0x39633f21, 0x3bcad7d6, 0x887edf80, 0xfd04c7e5, 0x37a51fbd, 
	0x11fc0dc9, 0x7184e311, 0x7a71e554, 0xe90ff437, 0x7964f0e5, 0x5c3f3139, 
	0x4939188f, 0xca89e4f4, 0xf8f22bf7, 0xc057757e, 0x1d38ef46, 0x9ebef7bd, 
	0xcbd7945a, 0x5d09efaf, 0x6764fa4a, 0xf3e48468, 0x5e3ed0b6, 0xaa21bebe, 
	0xfddc76b7, 0x3d213fad, 0x379b2e1f, 0xd58d6bc3, 0x239edc57, 0x7a111f3a, 
	0x73da1f6d, 0x6fe44e30, 0x430be70f, 0xba051d5f, 0xfaa354eb, 0x75fa8cea, 
	0xfdafd0b3, 0x0fa94ef3, 0xbd1df18c, 0x78e5aff7, 0x77f012de, 0x20839e2b, 
	0x078c6b3d, 0x7076bfd2, 0xcb62713d, 0x1e9f484f, 0xb8f4fa17, 0x7e893b43, 
	0xed14aaf8, 0xea3fa431, 0xcba0ab6f, 0xe4178e11, 0xeb7fea37, 0xcd34f5e9, 
	0x0f4127af, 0xfd7b3a6f, 0xa3dde86b, 0x1dbd2d9f, 0x958ec3f7, 0xbbf9b39d, 
	0x56363f68, 0xdb91beed, 0x9debddff, 0xde712e30, 0x5e80fc97, 0xce3e73a4, 
	0x65d91ca8, 0x1fc22367, 0x507aa3d0, 0xfef7b452, 0xaff2a147, 0x3f883e23, 
	0xf7a64df6, 0x7fbd058f, 0x826ae82c, 0xf74e15ee, 0xf826791f, 0xe8e51ca5, 
	0xc8301387, 0x678a1e97, 0xddafd07b, 0x78a64abe, 0xd6ad62f6, 0xc962fa83, 
	0x6113921d, 0x8f62ff9f, 0x9d147390, 0x370eb776, 0x6ef9826c, 0x92969d2f, 
	0xf73df303, 0x690d43dc, 0x940ecf00, 0x9d00e4a6, 0x0f6ab46d, 0x83fb8c3c, 
	0x17533e99, 0x74aa5dc0, 0x1fba0ee2, 0x0afe13a5, 0x2e1fcd82, 0x9f73818f, 
	0x3b78d43b, 0xee7cdf94, 0x509de734, 0x59ad9dde, 0x4bf262bb, 0x626b8700, 
	0x67755bee, 0xffce3c03, 0x23fe41f6, 0x6ec703d5, 0x0043e515, 0x61c3cc47, 
	0x3ba93f7c, 0xfd8e97d9, 0x6c0ebe03, 0x602f698e, 0xee770ded, 0x20ae3f42, 
	0xf6c365d7, 0x47aeeff4, 0xa37d3abc, 0xea27ff68, 0xc03da8fb, 0xac6b72ec, 
	0x53f667fe, 0xe7d47fe9, 0xb67df7b1, 0xd67b71e7, 0x7ac9d758, 0x6193ec1d, 
	0x1c35dfa1, 0xb60376b7, 0xc5b1791b, 0x68bd02e3, 0x5df5f2f1, 0x01f7f2a2, 
	0xfae3cb3f, 0x675876ef, 0x97689969, 0x3d72a9ce, 0xc9ec3019, 0x90799fd6, 
	0x856afcbf, 0x8b99f707, 0xd1fe5cbc, 0x3f50763a, 0x082b6bcd, 0x0817780f, 
	0x71bbaced, 0x3b9e975d, 0xf08fbd4d, 0xe933c516, 0xbfc5e085, 0x9ecd7413, 
	0xe1fcc64a, 0xc156d64f, 0x7db779f7, 0xee305bff, 0xa7e17ea5, 0xc401d83a, 
	0x6c5ff747, 0xeec1da4b, 0x1f1e4efb, 0xcd73d2ff, 0xba46ee2b, 0xbbbdf648, 
	0x0f6d1ace, 0x33aa05d7, 0xd6b54570, 0x2fc4c4ef, 0x4c7f1f4a, 0x769fb8a2, 
	0x9a39c62b, 0xc3ce3f3d, 0x6a5d1073, 0x31ecefc5, 0x223e0cf5, 0xad7fa07c, 
	0xa077bef5, 0x7ad9371d, 0x02288c0f, 0xf18f643f, 0x0c3b22f5, 0x621ff6f0, 
	0xbec2dd5c, 0x3b36e364, 0xdbc717c5, 0x47dcea6e, 0x7c17677c, 0x5fbe1377, 
	0x6e3cf3fd, 0x1f2bf8c7, 0xc99e4af5, 0xc76898eb, 0x587cfd45, 0xef6161d7, 
	0x06f58915, 0x12f052bd, 0x9782fba7, 0x8f905a8a, 0x2c23a9fc, 0x2fe2376d, 
	0xcccdfec4, 0xddcb1fd7, 0x71e5c792, 0x6001c601, 0x6e7fbbfd, 0x0079d25b, 
	0xae2fd060, 0x93f9e4f0, 0x4313d29d, 0x5a7ec217, 0xe477f2aa, 0xf4c0eafc, 
	0xff2f3045, 0x167b1b0b, 0x64b97f81, 0x8b63e67e, 0xce469e40, 0x08b038cb, 
	0xc793dbda, 0xe082d8fd, 0x91b9bfcb, 0x6b63a9fb, 0x5179e2d7, 0x880f9fb0, 
	0x2c1e607e, 0xef8adea0, 0xc7947dd1, 0x57e36ae9, 0xaacd7db8, 0x325fbe13, 
	0x107eb0dc, 0xef816968, 0x5dbe1740, 0xd0dc3296, 0x89ca3175, 0xa9877a02, 
	0xfb7a6bfb, 0xb3bb807a, 0x2d77047c, 0x57b72290, 0x70345e12, 0x70ae01b9, 
	0x4ace8038, 0x36cfdae4, 0x615ca0b5, 0x518d5d69, 0x305aee7e, 0xa7ca20d2, 
	0x4ae8fca0, 0x149d581d, 0xda2dd74b, 0x1e7ccdf1, 0xd20a536a, 0xba48c0cf, 
	0x3ad35798, 0x96ab4718, 0x08e1c5d1, 0x1d846bc2, 0x56f554c0, 0xcc20ff5a, 
	0x9f145f67, 0x349f7f30, 0xa3ae744a, 0xd275a31e, 0xcc78a4d8, 0xa8cdd699, 
	0x6e127c8f, 0x09a37ce2, 0xbd0760bd, 0xd3e8a5da, 0xdda2c323, 0xdd5da8f6, 
	0xd711d625, 0x88a5df09, 0xde5178e0, 0x6b38c0d7, 0xd5a4faf9, 0x2276f1f1, 
	0xf754bebd, 0xc26efd61, 0xdf425fc7, 0xa4f63a03, 0x0c8f9178, 0x56cee8be, 
	0x4e895d69, 0xd5f7f9da, 0x7927e40d, 0xd80d3d70, 0xa1e517e8, 0xc326ec9d, 
	0x2bb4aa3f, 0x1a3ade82, 0x9edeeda2, 0xa64cf5c7, 0xd1a6a98b, 0x9f135f28, 
	0x067e474f, 0xf50f70c9, 0xb0fa885b, 0xf13aa5c4, 0xfbf1207e, 0x4bffe088, 
	0x7b40fcb9, 0xce8388cd, 0x5679710c, 0x09efe5ea, 0x39790895, 0xe3d85173, 
	0x6d6c634a, 0xd6bff71e, 0x512ffc0a, 0xd0613bf8, 0xb9ee87ad, 0x1a6e3c29, 
	0xa92e37c3, 0x0b3e4634, 0x5584bf3b, 0xfe70f188, 0x45ab7d99, 0x69d067dc, 
	0xb17e8dbd, 0x8c71c71f, 0x849e8253, 0x76869776, 0xb45a587b, 0x1f42a5ff, 
	0xc1ecbd83, 0xf827f3f7, 0xd6ed07d2, 0x9baa7a0a, 0x3e31bfdc, 0x02bf7fa3, 
	0x77ea1a7a, 0x587b3909, 0x59f917e0, 0x68f99b39, 0x6e7cdc6a, 0x8e913f87, 
	0x5ff5324b, 0xcaf113af, 0x4f096b35, 0x7db5c612, 0x6b0c5de2, 0x47dd296f, 
	0x7c6efda0, 0xa1e7c407, 0x39a3edfd, 0xfa38f117, 0xdcfcf9fe, 0x18e7c3f2, 
	0x39f963e7, 0xb57389e0, 0xdf697b37, 0x8cdd4ee8, 0x01ad69e7, 0xd13d664d, 
	0xf7132df1, 0x180f0911, 0xf8c373f7, 0xec2adf20, 0x21da1b11, 0x50ec633f, 
	0xa83df5e1, 0x6aaddd77, 0x6b29ea27, 0xcd332fb9, 0x6547f686, 0x083fb0a7, 
	0x5ded68de, 0x60f209db, 0x277c6ff3, 0xdf406d5d, 0x7adf35d3, 0x29cdefc1, 
	0xf0d4c728, 0xa358e4a9, 0xc36390d7, 0x465ebaeb, 0xd1e5c5b9, 0x6cc3059a, 
	0x5b941efd, 0x61c3f0a1, 0xa8ca576a, 0x6d7576c2, 0x8ef2e30d, 0xf987079f, 
	0x07ca8f1c, 0xb1ed0f6c, 0x2a13c9d3, 0xfcdc51ff, 0x8b7e497b, 0x4dc897f9, 
	0x359bbe74, 0xf0ffa4a8, 0xebe309d7, 0x9ddefc11, 0xc6c455a5, 0xb9795631, 
	0xa446b19d, 0xbb0c78c6, 0x49abc3a0, 0xbad53ef8, 0x2863d927, 0xb14eacae, 
	0xf58b355f, 0xd626fde0, 0xbfd137ab, 0x340ea1d3, 0x89843ee1, 0x685d930d, 
	0x077b041d, 0x871bbfed, 0x90c7a8c2, 0x2bf9c48f, 0x2a2977fa, 0xd91f7c5d, 
	0x1847417a, 0xfb3ad8ed, 0x3b0d01fe, 0x78211cb0, 0xe745c055, 0x6ffea1f0, 
	0xd25f5fd1, 0x15b72990, 0x6f291ca0, 0x89b1d760, 0xff30617b, 0x77e8090e, 
	0xc8359b99, 0x15f9e2cf, 0xfc033216, 0x1869855d, 0xce0d1f37, 0x7303e5e5, 
	0x3d4f86f9, 0x7c2e9fe7, 0x54c555c7, 0x02bbe2f5, 0x5ce4fb9b, 0x55207bf4, 
	0x9361bde8, 0x8e8cfb4e, 0x2d69ddfa, 0x1bb7c19b, 0x7da7ebae, 0x187a59e4, 
	0x0edab9cf, 0x01820794, 0x690d243c, 0xb95f9e1f, 0xefaea790, 0xfbf0b4f3, 
	0x746acf94, 0x7368f109, 0x277352ea, 0x4f5a73a7, 0xcf07a87d, 0xa0d333d9, 
	0xc0f92649, 0xd40f510a, 0xdf120a2d, 0x340a2dd4, 0xea63d6b5, 0xfd20db97, 
	0x1b9f97b9, 0xcfc45ba8, 0x8ba2b2a9, 0x71e0325d, 0x6eef538b, 0x17d4c4af, 
	0xf1d029f8, 0x47decc96, 0xe2d8afd0, 0x44e81df5, 0xe41a8a78, 0x57752ef7, 
	0x3ce8bafb, 0xef783c70, 0x10b0e80e, 0xf0f487c7, 0xdb00e7dc, 0xb7683c61, 
	0x4c1e4dda, 0x616a9ddb, 0xa1cb8c33, 0x7b41fac2, 0xc26eba75, 0x164b607b, 
	0xe77c26e9, 0x2e3135ed, 0xe1731376, 0x2f7cea3c, 0xd97f109b, 0xdb9d1853, 
	0x7ca153aa, 0x12e38c0e, 0x83ef09bd, 0xa865b96d, 0x2d93ed07, 0x9027d5d3, 
	0x527e979e, 0xb40cf950, 0xf1822b6b, 0xcb7c7084, 0x6a4e89fa, 0xefd01ea0, 
	0x8e5cbdef, 0xb51314b3, 0x0250ef4f, 0xbe1bff1e, 0xcebc8067, 0x8df3c29d, 
	0xf43d0179, 0xf2dc5ca1, 0xfa216941, 0xb42f3687, 0x413ce2ab, 0xe344f78e, 
	0x54decc47, 0xe7c9e7c8, 0x7c3efb8b, 0xf783cc9e, 0xd39d572b, 0x63f3885c, 
	0xefd4cad7, 0x72e79c11, 0x15aa97bc, 0x81cfcec6, 0x3c42e8f8, 0x2dd97df3, 
	0x942b2fef, 0x876dae80, 0xc73c2546, 0xf34b25bf, 0xf8f9e0f4, 0xeefecae1, 
	0x4f675a11, 0x4f43ee0f, 0x3f01e7e1, 0x537d0af3, 0xd2237174, 0xea1bcd25, 
	0x4d07023b, 0x3187def8, 0xf3273aef, 0xaefec184, 0xfa9c7a2b, 0xbf88b55f, 
	0xea127cdf, 0xff3b442f, 0x4bec4d90, 0xdde136ef, 0x429bf680, 0x6f941285, 
	0x8887fb17, 0xb6838c1f, 0xcec2d57b, 0x00c61c6a, 0xaac98bbd, 0x4bce8cd9, 
	0x0e311e39, 0x222ea8e1, 0x5dc4643d, 0x8cfe7d98, 0x776d3c58, 0xa78819b2, 
	0xf09faaa7, 0xd3dd1b30, 0xee7c819d, 0xf6be01f0, 0x2643fd62, 0x6ff22965, 
	0xd3cf07b3, 0x78e14f26, 0xa266a563, 0x37815cd7, 0xa6f25e83, 0x957e7130, 
	0xf43c8479, 0x0f94bf10, 0xc76f39d3, 0xc7f3171c, 0x327513f8, 0x7616ac0b, 
	0x45934c1c, 0xfd97a856, 0xaed478fb, 0xefe02167, 0x63172111, 0x7113a6e2, 
	0xe78ce2e4, 0x0e862799, 0xfe8cd7e0, 0x9391654d, 0x91add1ee, 0x437e1de8, 
	0xeb2a45ce, 0x79f8911e, 0x24ed092c, 0x0e5daeeb, 0x7a5b4fdc, 0x908f35c1, 
	0xa3ea573f, 0x4e25f533, 0x68eee48d, 0xf1e26f50, 0xfc324d70, 0x82e38a3e, 
	0x8c30f85f, 0x3c2982e7, 0x8bf8676e, 0xe90d4e30, 0xc8d416d5, 0x817dbc3f, 
	0x6974f74a, 0xd92f249c, 0x402f28e5, 0x639b0fde, 0x7f68a3e6, 0x93f01894, 
	0xe8bc954d, 0x8c2fe197, 0xe09800fc, 0x5cd41fe7, 0xb239a3e4, 0x1001bb9a, 
	0xe0647b73, 0x4cc7a43c, 0xf1361b37, 0xd43ce97d, 0x62fdf0d7, 0x9ab3e489, 
	0x79fb4e37, 0x46de9e7a, 0x8daf77b0, 0x95f22f60, 0x18b9498f, 0xeff4349f, 
	0xce3febd4, 0x173ed3f5, 0x1a0f5093, 0x7a16577a, 0xa8ffdb17, 0x7790f095, 
	0xdde65292, 0xde6aed45, 0xe1fb79d7, 0xdcae3003, 0xdc0e7e21, 0x81da1add, 
	0x8b5a45ef, 0xb7a41f7c, 0xdbae7ea1, 0x41e1f781, 0xd1bc133f, 0xf0f8dfaa, 
	0x5efdac78, 0x41f843bb, 0x7d272c1f, 0xaba3bbdd, 0xff81fc92, 0x7a3af7c1, 
	0x1eb7eacc, 0xddf7b18e, 0x3c5c6b36, 0x7a90f360, 0xd4634673, 0xccf687ff, 
	0xd768ddf6, 0xffd19a84, 0xd064fc34, 0x76ba3bfb, 0x1df77ea1, 0xb8e380da, 
	0xfd63b424, 0x0e4bf27c, 0x531b3f61, 0x1f849bf4, 0x5d6abe30, 0xf8c78f54, 
	0x0dff24d7, 0xf25e81bc, 0x6995bda1, 0xf600afbc, 0xee7dd212, 0x78b9826f, 
	0xe5ec96d1, 0x2b2784c5, 0xe05c81ca, 0x426dd355, 0xab3ea1af, 0x2677f89e, 
	0xd872be88, 0x39034590, 0x2ae80ab5, 0x945de62d, 0x4f4e6aa4, 0x7dd2a7e0, 
	0x998fd40e, 0xa62f5c75, 0x19bb7297, 0xd414fdff, 0xa83e4883, 0xc83a3b07, 
	0x2f7ba24f, 0xe3c29a3f, 0x1fe33988, 0xb3f7625a, 0x98038f01, 0x512dc78f, 
	0x778894fe, 0xe8247e4c, 0x23b4531a, 0x13c84dfe, 0x0ef107e4, 0xe6978d31, 
	0xc333f5cd, 0xbcb16077, 0x836e3314, 0xfed0b20f, 0x22d3c58f, 0x7d2d53c0, 
	0xec6399f7, 0x562c9cde, 0xcc29e3c1, 0x7411e9d4, 0x1ce82b5f, 0x245a7bea, 
	0xce60677a, 0x411eab86, 0xf0f6c27e, 0x1f6c15bd, 0x17c310f1, 0xc18a9ef4, 
	0xc64fd80f, 0x63a667b3, 0xfc605ff2, 0xb983cfbe, 0x807f9133, 0x144e5051, 
	0xf17384d7, 0x886f8cbc, 0xe1f4f789, 0x77d1f03b, 0x9475ff10, 0x4e803286, 
	0x9a78105e, 0xfc083788, 0xbfb8de23, 0x14afefc4, 0x80a499fb, 0xf02ddbc0, 
	0x9f2f813b, 0xa4c5df68, 0x5f4e1191, 0xede21eb7, 0x21b9408d, 0x758d1fa1, 
	0x7c83f51a, 0xeeda3fba, 0xb0b2fcc1, 0x0bf6f00b, 0xbb467eb1, 0xfdf82fb2, 
	0x8aaaf7d8, 0x3e745e61, 0xc4dbfb19, 0x1636dfcb, 0x1ee2e743, 0x932eb1b4, 
	0xe2cdcfd6, 0x967e0fd6, 0x4784c277, 0xba617bcb, 0x50578c17, 0xecb05ef1, 
	0xa49f8894, 0xf5d024fd, 0x4afb9e08, 0xe2f7522a, 0x22a4827d, 0x83f3031f, 
	0xd7b26525, 0xca49eed0, 0xa5b65df4, 0xd89bde8d, 0xa4097ed9, 0xad6d3ea5, 
	0xba96530d, 0xa939f815, 0x2eb35f5c, 0x2669b199, 0x1d85dff5, 0x3d75a474, 
	0xd3fb4fde, 0x669fba14, 0xf6135bdc, 0xc4fae3a8, 0x360f69fb, 0x7c98dfa3, 
	0xf69fbf07, 0xfbf894d1, 0xaae5c969, 0x25a7ef19, 0x7a0a4267, 0x4fdc5933, 
	0xe5ca18fb, 0x11bbd18d, 0x7687bc66, 0xa17c015d, 0x998d427b, 0x8f06dfd8, 
	0x390fce85, 0x69ccb1e7, 0x46edbf90, 0x8d091de3, 0x2b934bdf, 0xf0a4980c, 
	0x809937b6, 0xbfcd3a75, 0x748dd7ed, 0x7571cd5f, 0xf808b87f, 0x2f3d27d2, 
	0xfe66a0f9, 0xf6849e98, 0x4faf75b3, 0xa6deba46, 0x34ddf71b, 0xeb41ca33, 
	0xa44cfade, 0x5050db6f, 0x654ec096, 0xe41103f5, 0xbedeeb17, 0xff943322, 
	0x6364b56a, 0xccab0704, 0x41a52e50, 0xac59f7a3, 0x318bbd8d, 0x2b46fc1f, 
	0x98adfd87, 0xbf9eadbf, 0x304e7177, 0x8d7aa56c, 0xf7e24f7d, 0x7cec828e, 
	0xdf1dd3f4, 0xa5a30f1a, 0xccc63f9e, 0x88a49dfc, 0xe789f509, 0x9e1331cd, 
	0xdcff3e67, 0xf9e72a3c, 0x59fcd8fe, 0xefd4be30, 0x11ea53f5, 0x63be4ff8, 
	0xa5aaec28, 0x9ef18779, 0x43ef07aa, 0xbb6ff7e2, 0xdf4677c5, 0x9d1741ed, 
	0xcf9ed927, 0xfbb29ec8, 0x7b6a3df8, 0x79466a8d, 0x9fdd3492, 0xf40deb8f, 
	0xe7845c55, 0xc5611e57, 0x6e9e5f68, 0xcff24b9d, 0x9ebf9d6e, 0xf0ceb89f, 
	0xeb79d705, 0x1bceb43d, 0x0ef9d713, 0xd7ce4758, 0x0daf1d7c, 0xd644bdd2, 
	0xbd891030, 0xddfc9c17, 0xf01f0af1, 0x71faf385, 0xe3e02973, 0xe12a05f7, 
	0xe3aff9c9, 0x9d913315, 0xfd9a0cee, 0xbae8a9da, 0x28fe5f2a, 0x5f3d9e66, 
	0xe46fcf3c, 0x17c9e547, 0x899af3cd, 0x8b9a3679, 0x6bcf38cc, 0xdff73cf8, 
	0x64cf3717, 0xe919a79c, 0xc1744839, 0x3d5e611a, 0xde36ef31, 0x3b461c34, 
	0x8fa2d1cb, 0xb731ffa3, 0x797c86f0, 0xb8f354ec, 0xe1efff25, 0x5cb3facf, 
	0xf3e6efb7, 0x79f6a3fb, 0xe2eb8ccc, 0x899825bc, 0xe0aebcf8, 0xb66784bb, 
	0x57ba5aff, 0xe80bcc6a, 0x77e90528, 0x1f0260db, 0x53d630ae, 0xb6dafe25, 
	0x91efc824, 0xe17ce22e, 0x0be7c5de, 0xfdf0c2fc, 0x1f0fe029, 0xf81d36a6, 
	0x6dc3fc07, 0x3ea355c7, 0xa1b5b9f1, 0x5dfd16b7, 0x047c0e9b, 0x1f62a9f9, 
	0x763f5ac8, 0x3589d217, 0xefe26be4, 0x98f704be, 0x583ee8fb, 0x7581f233, 
	0xb206c351, 0x1f7ac75b, 0xdec6fca3, 0x34cf98c3, 0xc647dfc1, 0xad76c19e, 
	0xd197fe0d, 0x37d6b55e, 0x1f8192fe, 0xa303edb9, 0x3fac9d7f, 0x41eb686b, 
	0x345d6efc, 0x31d2827e, 0x9a412cbf, 0xe847dff7, 0x48f5a4fe, 0xbc8fc923, 
	0xa7cd8fdf, 0x16f70d79, 0xfbc99ca1, 0x871378c3, 0x77245583, 0x5e633486, 
	0x758dfef4, 0x529be87f, 0x973bd23d, 0xb7f7de5b, 0xfb7b5136, 0x79462eb7, 
	0x6fa0fde1, 0x0fefea90, 0x7dc95c90, 0xe7907867, 0x72893ff7, 0xdbe43ac7, 
	0xc9fa8663, 0x5cba85d7, 0x3c6e515b, 0xfb94eb4e, 0xaa26adab, 0x30f5b437, 
	0xea1ef396, 0xaafb8f9d, 0x7fbf1b5e, 0xfdcbfb91, 0x4f23f271, 0x79efebe6, 
	0xf94a75d5, 0xbe372891, 0xf953ee7a, 0x91327f78, 0x7d857d3e, 0xb50f18f9, 
	0xfa055ea0, 0x4cfe5fda, 0x9a31c67e, 0x9d9274af, 0x98089de6, 0x539e2a4f, 
	0x0740b8c5, 0x67e23ff0, 0x37dc4d80, 0xe2f9f3a7, 0x73c48c9d, 0x469726c4, 
	0xe7cd19e3, 0x778d9fe7, 0x2bdd2631, 0x95efcbd9, 0x6ce5fa18, 0x572a67ef, 
	0xc357b26a, 0x841bdbb8, 0x8f4ba4d7, 0xef1b0848, 0x6b5e8c8c, 0xd93a71d8, 
	0x9effac0d, 0xe87ed8bc, 0xf918911d, 0x24d1af65, 0x6ab613d4, 0x56d68f7e, 
	0xdacfefcd, 0xfef18681, 0xdf9abda6, 0x3be1b5bb, 0x1c2fe024, 0x1adb7216, 
	0xed6ff7e0, 0x96091ef8, 0x2bcc179f, 0xeecbbb07, 0xa8fee7e6, 0xfad8bebd, 
	0xfa206ed0, 0x2f51898e, 0x79d67c71, 0x56e579fd, 0xbf7f171c, 0xbe02dee4, 
	0xd2dc467e, 0xe552c452, 0x913f7c61, 0x84567dfb, 0xb4f2ac61, 0x6f2c01ee, 
	0xc6e9c999, 0xfa8bde22, 0x679c5f24, 0x9bf6e7cc, 0x3b972a75, 0x909df65f, 
	0x264177c4, 0x1c91e7ad, 0x38cdcf5a, 0xf193a40f, 0x0fdb991a, 0xbde19ce7, 
	0x9e111818, 0xef132e2b, 0x7bf30cc5, 0xe7d32a42, 0x18777ce2, 0x3fed8fed, 
	0x698bdb1f, 0xfb7c6e7f, 0xd667951a, 0xf6f13fbe, 0x8395b7fb, 0xdf6ffdfc, 
	0xa6ff9271, 0x0119c6b2, 0xd3afb63b, 0x7f9a0ab9, 0x8587ad2d, 0xc04d63de, 
	0x6ab55243, 0xf83275c1, 0xd1f38981, 0xba162f40, 0x1f809b4f, 0x0b71d2c7, 
	0xfbe4c1ea, 0xb07ead1a, 0x8c17530b, 0xea63bfd3, 0xc317afbc, 0xe150ec1c, 
	0xefa8a9b4, 0x946caf92, 0x458ede70, 0xfb4fe28c, 0x22a68bcb, 0x9a6c9adf, 
	0x748c86bc, 0xa3d47846, 0x2ef716fc, 0xbf9b864d, 0xddf931d3, 0xc3d25519, 
	0xf341e793, 0x63ce891b, 0xd767fbd2, 0xd2dc5a37, 0x00afc7a9, 0x485f749c, 
	0x74fc79c6, 0x275a5cda, 0xe6e39dfb, 0x19d86822, 0x07affb02, 0xea7e5fc7, 
	0xdffe0ff1, 0xe7da3f1f, 0x93f7d749, 0xe1497ebd, 0x0e915335, 0xca0a6e52, 
	0x7ae4ff88, 0x389ff09d, 0xc725f66e, 0x817fbefd, 0xcbddee89, 0xfbe5f13a, 
	0xb1041b32, 0x919890cf, 0xa15226ff, 0xe54e57cf, 0x690f587c, 0x2ef2f810, 
	0x2c792b01, 0xeff82b63, 0xf0b534ca, 0xcab0d039, 0xfc2bec79, 0x5f6b2d1c, 
	0x4bf50a93, 0xf1e53b45, 0x33dee0ef, 0xcaf7f395, 0x35676cb3, 0x3db8c394, 
	0x78c1478c, 0x17f21272, 0x9f3935c8, 0xa76b160d, 0xf41feefa, 0xe324f9f3, 
	0x1f22e5fc, 0x0ce0d77f, 0xbaf398fd, 0x027de89b, 0x117c9ed1, 0x3a0b83b4, 
	0x7f103ef1, 0x02e927c7, 0xbc80a4a6, 0xf7ca9f69, 0x83778cb5, 0xac14ffb0, 
	0x9129933f, 0x1077ea3e, 0xfe6081f7, 0xd123d6c9, 0x15c74471, 0x71a2fc1a, 
	0x5abfc849, 0x9a6a5c4c, 0xef8457d8, 0xcb6f50ed, 0x0e5fbe54, 0x067ef9e5, 
	0xbe78a9f8, 0x9e7be264, 0x936e3ef8, 0x8942bf68, 0xbff9d3e6, 0x440fea93, 
	0xa3ec83bc, 0xcc06a3d1, 0x686e746c, 0x93e466bf, 0xaafa319d, 0x6393d301, 
	0xc027746c, 0x50b1ffdc, 0xa6030efe, 0x68d9c7a7, 0xabca2eb7, 0xfa4dc132, 
	0xbbed620f, 0xcc0665d1, 0x37a475ed, 0x298d77bc, 0x732663d1, 0xf6bbbbe2, 
	0x47457564, 0x3554d204, 0x0bc0b375, 0x3167b796, 0x18c6e6d7, 0xc5774738, 
	0xd2d74fe5, 0x51cff2e2, 0xabf2e3d3, 0xfe5c4658, 0x2e233d02, 0xbed521ff, 
	0x536ffb19, 0x902877b7, 0x7c0ca45a, 0x1b6ed7f7, 0x76875a49, 0x34fb326b, 
	0x3d8c5cf6, 0x7634ff55, 0xa59edc1f, 0xcfcb8c9d, 0x0716ff51, 0xc59f674f, 
	0x9fe8e7c1, 0xd2afd5c5, 0x5fcb8f3e, 0xf1f8b2a0, 0xcf8c4c69, 0x0cb1f845, 
	0xe1573758, 0xd6551ef8, 0xc95e3be2, 0xbf371cba, 0x8f12cd54, 0x8f1ad53f, 
	0xc78b663f, 0xc78b6e9f, 0xc1c4a69f, 0x3c526a55, 0x0e3d98fe, 0xc164287e, 
	0x7c619577, 0x15f1f337, 0xd5fc7124, 0x4103adb6, 0xebe08af4, 0x163f78a9, 
	0x5daa7ae8, 0x7df3c36f, 0x0afbf17b, 0x7f8e2f7c, 0xf0eef7c7, 0x7946abfb, 
	0xcb01af7c, 0xf83df43b, 0xddf175fd, 0x1d7bbe2b, 0x29bfbe8c, 0xf717c9da, 
	0x1aedf36f, 0xbe2433b5, 0x79ef89e7, 0xbf15bd76, 0x93b442ff, 0xf883de2f, 
	0xaba1373f, 0x000000dd, 0x00034fc1, 0x7ded9c78, 0xd555780b, 0xe73ef095, 
	0xee7bdc9e, 0x4b973733, 0xcdc08048, 0xd4426e0b, 0x0f0d52d0, 0x834120e5, 
	0x2ac706a2, 0x41b8f8e3, 0x6da1d1b4, 0x75036a44, 0x909bdcf4, 0x092a04dc, 
	0x4ed6810f, 0x569475a3, 0xfed22fdb, 0x7bfa7416, 0x99da2802, 0x533aa969, 
	0x784e98fa, 0x69dcea59, 0x48dfd1f1, 0x5ad7f96b, 0x4afb9d7b, 0x3bf9d028, 
	0x7ffff7e3, 0xfb374fbe, 0xebdaf6b5, 0x7bdad7b5, 0x78a77d9f, 0x417d03cd, 
	0x2a98de21, 0x884f7884, 0x58263349, 0xbd4878ea, 0x5e58cbd6, 0xc4c13b56, 
	0x1adba7bc, 0x790238ea, 0x67ddd18f, 0x84223e42, 0x1310a4f7, 0xa42b7eb1, 
	0xdb0bb31e, 0x05940a7b, 0x0221211d, 0xed06df58, 0xd7995e19, 0xae3c71a0, 
	0x8fac21a1, 0x714c7f71, 0x0ed889dc, 0x1a4d78e1, 0xcf88a7f7, 0x194a216a, 
	0x20c7a97e, 0xf2e73ff8, 0xf62f2e62, 0xfcb0eb98, 0x297f8c17, 0x1af529c3, 
	0x6ed86704, 0x5ec5e5cf, 0x3f2c25f3, 0x784bedc2, 0x411e257e, 0xf9718ff0, 
	0xde3f8678, 0x37fc1063, 0xcf094e19, 0x082bc4a7, 0x3dbb09fe, 0x35ef1fc3, 
	0x3c84fe08, 0x58f04dba, 0x336e90eb, 0xae612e99, 0xbac47b0f, 0x827dba6c, 
	0xc78132e9, 0x5eb5e099, 0x0b7463fa, 0x57b0bb73, 0x8c5dbb50, 0x7fc638cf, 
	0xc4eac79c, 0x7970eff2, 0xe85b8f21, 0xfcb03ab1, 0x38d79e39, 0xd79c7fc6, 
	0xbbe58fda, 0xbf0cf6ed, 0xc3ed6bd0, 0x7db9e7f2, 0xf229c311, 0xefff0418, 
	0xe3cfdcb9, 0xc1063dfa, 0xa70c9fff, 0x7914e188, 0x716f820d, 0xf5c79fb9, 
	0x1f820d7b, 0xdd36fee4, 0x89d11e82, 0x74c65b74, 0x3eb8f1f3, 0xa6c8e88f, 
	0x974c2ddb, 0x7a0bc320, 0xe8b1fec5, 0x7c3c63e6, 0xb9e3415e, 0x7dfa9f39, 
	0x334457fb, 0x41b274e0, 0xf52f1808, 0x430fce6b, 0x8752fe1e, 0x41fccb76, 
	0xf39f7fce, 0x7bffb716, 0xfc841fc8, 0x8b7fd720, 0xbf5c03f3, 0x4fb6447d, 
	0x25fe3cca, 0xc4a95e81, 0xced76c88, 0x3e7256ed, 0x6a9ef326, 0x4691f0b3, 
	0x231ba748, 0x77c0497d, 0xb92870dc, 0x6c43530f, 0x23b77a87, 0x801ff6a2, 
	0x3ca632b4, 0xacd4c71c, 0x813b46fa, 0x620ce96f, 0x8b662a62, 0x28611110, 
	0x3842abe6, 0x2ba2239b, 0x2898b406, 0xa84ce774, 0xe2690b6e, 0x63d7d003, 
	0x21ba6151, 0x7ca3123f, 0x611cd762, 0x2fa108f6, 0x2326561a, 0x89c305be, 
	0x1afd210b, 0xdd7a9dcb, 0xf1874388, 0x702d4f9c, 0xbc3c456c, 0x978c4ac2, 
	0x740cdaf3, 0x3fb8b5be, 0xf285ee22, 0x5be5b9b9, 0xf1f03fb1, 0x88fad72a, 
	0x75e60fb8, 0xa5114443, 0xf284deb2, 0x8896c60d, 0x63cb1778, 0x8501d88a, 
	0x38256d17, 0x22478ea9, 0xbb4cede2, 0x53b70b55, 0x9875e69e, 0xfc82d3e7, 
	0xd62684fb, 0x2aaaf900, 0xde0e7ce5, 0xfceff946, 0x03e698aa, 0x139fb5bd, 
	0xf6070dfd, 0x7b93ce13, 0x088ba015, 0x61e6248f, 0x9b88d079, 0xe460cf80, 
	0xaeae3909, 0xf2379bb5, 0xe01fc8b8, 0x55bbcc94, 0x21d29e6c, 0xf5592fff, 
	0x99de233e, 0x9793dedd, 0xf10c1a37, 0x8dfcace3, 0x01cd5323, 0x506d6f20, 
	0x869c3a45, 0xc10f6dbf, 0x6e2243fc, 0xc342176e, 0x0bd20fb4, 0x5c92a647, 
	0x6668fcb0, 0x89e48443, 0x19bb46e5, 0xc7df58f2, 0x6f9c79f9, 0xd1e8f295, 
	0x3c826285, 0x908a2368, 0xedd530fc, 0xaa6e582d, 0x4f109683, 0xc447f644, 
	0x5df8e56f, 0x515e310f, 0x4c0ebb48, 0x7b60d755, 0x62e116ab, 0x7f5053fd, 
	0x81be2432, 0x14c4edf8, 0xe0f9dbf0, 0x4f84a9e9, 0x7f1a7ceb, 0x397cc367, 
	0x32a5fb7e, 0xc652eabf, 0x67c252e7, 0x254b8ae7, 0xfdb26dfe, 0x22d45d49, 
	0x3f193b7e, 0x8c1bcfc8, 0xdb79d351, 0x01bf6f81, 0x456c75f6, 0x5e134e7c, 
	0x83f4540a, 0x290d3d3c, 0xdacdffb6, 0x87706a09, 0x8939ef2c, 0xf139f9f3, 
	0x49e6f30f, 0x03a5fba4, 0xbd21bb0d, 0x23fba65e, 0x73e22247, 0xe5c15f90, 
	0xed8a73f7, 0x3d5db9ea, 0xedcd5ff7, 0xa61db9ea, 0x131179c9, 0x43d8f964, 
	0x7b625555, 0x497d6f86, 0x7b454aad, 0x7db9ac23, 0xb62fdf40, 0x5c1d9fee, 
	0xac4a400c, 0xde40fa17, 0xe71ac436, 0x26e11e62, 0x06fe50db, 0xf2815dff, 
	0x1bf2d96f, 0xbcf4fdde, 0x95fe215e, 0xede36cf5, 0xf7a8cc0f, 0xdcdbd108, 
	0xc1f51739, 0xba209915, 0x18339da0, 0xbfa05d14, 0x75af512e, 0xa25f30c7, 
	0xd19b3f75, 0xe154d707, 0x8c030e77, 0xe7d214c8, 0x4b67db86, 0x4b3e307d, 
	0x38bc1ff9, 0xea41f59f, 0x587f5a41, 0xce2307cf, 0x75079472, 0x2039e83e, 
	0x14b42ceb, 0x7054f3d4, 0x9d12dff6, 0xd105202a, 0xfce2cd4a, 0xaa3d3215, 
	0xfc01d109, 0x62a1fa38, 0x28205a50, 0x6c1ca0bd, 0x0237cc09, 0x97a43d69, 
	0x6904da40, 0xa84956aa, 0xdd9f101f, 0x8fb6175a, 0x3fdda137, 0xc7a5a1fa, 
	0x0f8f5c55, 0x8844a2eb, 0x0dded069, 0x71232bed, 0x5c0be91d, 0x1f68e3d1, 
	0xdfef5374, 0x8adb9191, 0x6544f970, 0xcf59e307, 0xf1660e78, 0x5f971671, 
	0xf1fcd321, 0x67c05152, 0x7b1f064d, 0x3f1862fc, 0x4e333278, 0xd8f01465, 
	0x498f1a34, 0xc1d70ed0, 0xcf14f851, 0x893e744e, 0xc5d7def0, 0x189fc130, 
	0xcfc19c5f, 0x2832abc6, 0x97e367e7, 0x23e79bc6, 0x1fb13174, 0xc70844ec, 
	0x75e50559, 0x742bf4b9, 0x93bdbd80, 0xfcce35f4, 0x0bfed155, 0x2df78add, 
	0xfc8f7a96, 0xf882c2b7, 0x1d7e42ef, 0x8a203b07, 0x16611384, 0xd107889c, 
	0xf644342e, 0x4e126339, 0xeebe8b32, 0x5fbb9006, 0xd51eda41, 0x54809dd6, 
	0x729cf89c, 0xdcd1e037, 0x0ed026d0, 0xc1fdb136, 0x8d647771, 0xfe517d07, 
	0x5f941c70, 0x61247b77, 0xdc621f22, 0x53b4996f, 0xa2dd7cf6, 0x031eeb54, 
	0x7beb036e, 0xafe1b2ea, 0x34dd81f4, 0x7e40cf50, 0xcef72697, 0x61abd1ce, 
	0x7dda2e63, 0xc684b7ab, 0x70dfa175, 0x63d9eb27, 0x3d00f790, 0x43830f90, 
	0x081d202f, 0x3fe7145e, 0x2c9cf4f0, 0x4fbb53fd, 0xfa0598cd, 0xf61ff477, 
	0x70f50efc, 0xea2a7ad4, 0xd670d745, 0xe4faca7a, 0x9604d114, 0xf982fad3, 
	0xcb8fac29, 0x96ff48aa, 0xfa934d34, 0xf5a5ac67, 0x9d3f5be9, 0xd793f52b, 
	0xfdc8c1a1, 0xd49f68e5, 0x2b6d4c4b, 0x68b7a982, 0xe53a3c9d, 0x9d4c71bb, 
	0xe48f4473, 0x4e5389bb, 0xeb1765db, 0xbd4fb1df, 0x67b704ab, 0xdeaba1ec, 
	0x94bb6c54, 0xdd3ffc04, 0x0eb66fba, 0xfcb95af4, 0x16f417f5, 0x4cdc8769, 
	0xdfa43ebf, 0xfa26bfb2, 0x90e4ffe9, 0x7cec1678, 0xd8c9695a, 0x1f7bb529, 
	0xfe2da5d1, 0xc2fd3217, 0x9f53b242, 0xa64e335d, 0x346639f7, 0xdc748c3c, 
	0x33e47648, 0xdb9e6ef7, 0xf3f48010, 0x294efc2f, 0x49e5d8cd, 0x8e1f60d5, 
	0x2e1a7ca3, 0x0bc83f9a, 0x94e8f7d2, 0xeb495fcf, 0x3d284c72, 0xe0b2bf40, 
	0xe4157ae9, 0x47685bf1, 0x71d5ee40, 0x074813db, 0x7df30fea, 0x0127ca02, 
	0xcbc693de, 0x4a2dac3c, 0xded90ecf, 0x2c3e5d9d, 0x5e5c1d94, 0xb9fbe38a, 
	0xfdb729bc, 0xb0175137, 0x1ea027df, 0x7d426019, 0xbb3c1669, 0xd7ca10dc, 
	0xc20d5fb9, 0x19e194bb, 0x143c0e6a, 0xc62978ed, 0x6eae914d, 0x18b28390, 
	0x93ff20a4, 0x97205f90, 0x4e9ea747, 0xef0bd080, 0xb4bd0d5b, 0x7edb362e, 
	0x3ca2a5a2, 0x49729d1d, 0x7a4abc5c, 0x10b4f6ac, 0xfc09873c, 0xfee3e89a, 
	0x109bbe53, 0x8807e83d, 0xa667731e, 0xf8e40f9f, 0xdfe015e1, 0xa0af5fdd, 
	0x12ad7a1c, 0xa60b70f1, 0xe8236d41, 0xf6aee797, 0x1e9eb86d, 0xeef29728, 
	0x9b7dadb9, 0x11fb6288, 0xe1dfa055, 0xee81bc03, 0x4099a75a, 0xb133c57f, 
	0xf50e37b0, 0x8a80d55a, 0x196791eb, 0x70e802f0, 0x84e9c264, 0x8be982d1, 
	0xf4f00309, 0xcdb0d5de, 0xdbf7b182, 0xc36f7e76, 0xbd2f5c36, 0x136c35b7, 
	0x9c3eb7a0, 0x1df3f437, 0x061e248c, 0xeb82523b, 0xaf989dc4, 0x104636d7, 
	0xf307680f, 0x0384f9f0, 0x66fc9fc7, 0xf40dd3bd, 0xe1da19f9, 0x806f1077, 
	0x37a9f507, 0x60754d0f, 0x9221a87a, 0x3fe27480, 0x1d94bb47, 0xe2523b19, 
	0xfbc45717, 0xf7a87c78, 0xf97a4956, 0x9c0ecd3a, 0x436d604f, 0xcb65e22f, 
	0x216e3019, 0xc777d5d2, 0x65910eb2, 0xb0750af7, 0x6ba2293b, 0x5451f207, 
	0x3e302b00, 0xfc04b942, 0x4bad630b, 0x0f8609c5, 0x285ffaf3, 0xde0f208f, 
	0xf2dbccb0, 0xd9dcfd88, 0x588f2ce5, 0xf2740a5e, 0x29bcb8fa, 0xe469fdb7, 
	0x259bf60f, 0xc796dbf5, 0x9cbb3c34, 0x6bcb11e5, 0x863cde10, 0xb768f2c7, 
	0xb0b1e5b7, 0xe810e419, 0x79488feb, 0x3f487a44, 0x9063da4e, 0xe043a22b, 
	0xc81f287a, 0xdbe903d0, 0x04f5f401, 0x97d204cc, 0xde6e51ea, 0xac0cf491, 
	0x69da2615, 0xf29a2fdb, 0x12eed6db, 0x7bc08f90, 0x60c7e146, 0x22b7b2bc, 
	0xf079a5bd, 0xd33abcbe, 0x2967ccae, 0x9d20863b, 0x8a5bdf53, 0x625be87e, 
	0xb1923c5b, 0xc33e6573, 0xf2c22f15, 0xf7c86d92, 0x3758eac0, 0x5fb283da, 
	0x18e66d8b, 0xc33d5278, 0xcbdc238d, 0xd1c3c904, 0xf5a71180, 0xcdc6603f, 
	0x0d83306e, 0x0727cfed, 0x1acc1a64, 0x0a5ba5cf, 0x269817ae, 0xfe37094d, 
	0x728fb71e, 0xa2a7807b, 0xd23902fd, 0x50879a2a, 0x0af1355f, 0xe005c5e5, 
	0x7902bfc7, 0xe6bda1cf, 0xbdd3d930, 0xa0a9efa8, 0x09e29fb8, 0xb2d4f7d6, 
	0xe605fb86, 0xfd490a47, 0xcfeee441, 0x4b542f89, 0xfa86ff98, 0x2cea145b, 
	0x4a333006, 0x0371d8f6, 0x1d7f89e2, 0x9a63f7c0, 0xbea27650, 0x40afcc56, 
	0xea747bfb, 0x3d2f648b, 0xd683a6cd, 0xbd7f3b11, 0xf4d97e20, 0x70f905aa, 
	0xe8f5c7bc, 0xa03fec07, 0x3a42f7c4, 0x3cc1da07, 0xdf345f8f, 0x7a4e2b35, 
	0x5e61c4a2, 0x2edda3c7, 0x64c1679c, 0xed856729, 0x5e41d542, 0x76672c62, 
	0xa42b27f9, 0xa4f8143e, 0xf29bba9c, 0xb96585da, 0xfcb739a7, 0x87690ab6, 
	0x1c24ea0b, 0x3f5e6b7f, 0x84c5f72e, 0xe5952d1a, 0xb305f728, 0xccd07964, 
	0xbb6e3f6d, 0x3859c748, 0x45f41d5f, 0x12f8197c, 0xd6150975, 0xf5022d21, 
	0xa1a7883d, 0xf23c40f4, 0x8457e829, 0x5f59e6f0, 0xf2211dea, 0xe3f44e2e, 
	0x67c506b8, 0x13079705, 0x6be9da02, 0x2bef249d, 0x61c7fda1, 0x7e64651c, 
	0xd6b8a4c2, 0x6689bc4c, 0xff8bd4fb, 0x72e217a3, 0x22995407, 0x86dafc6b, 
	0xfadbfa1c, 0x284f3052, 0x9fa16fb8, 0x72e4f112, 0x93c4676c, 0xf4ebe02e, 
	0xb8c3a2a0, 0x4138c30f, 0x8fd78bc4, 0x079811e3, 0x6edb5bfc, 0xfbf43a69, 
	0xa61f4d9a, 0xe667d6b7, 0xb5bd3396, 0xce5b91a4, 0x2ddad2fc, 0x15794e47, 
	0xdc898fb7, 0xb6bfa672, 0xcbb352cc, 0xd83f4531, 0x0a6683e6, 0x44b3c71a, 
	0x4d933de6, 0xd2e5d9e5, 0x1e820d0e, 0xf18f2138, 0x68cc769e, 0xe210d678, 
	0x097fa16f, 0x2e239bae, 0xad48fd05, 0xc257e61e, 0xa192dcf3, 0x450d5097, 
	0x04e900fb, 0x0b8f40ed, 0x1c028622, 0x17e0f684, 0xdd307f21, 0x8966ed0c, 
	0x4326b6a0, 0x54cf8f6f, 0xe9a56ed1, 0x14b5b00d, 0xeb1e83d7, 0xb8c0911e, 
	0x5f004f56, 0x88b962b7, 0x7e204df7, 0xe396fa24, 0x14ac37fa, 0x56bc9c81, 
	0xc41ae321, 0x72fa0e24, 0x02a0caec, 0x7afc1bb6, 0xc4e403c0, 0x0e1118d5, 
	0x9643ffe8, 0xa4b27d7f, 0x8289e823, 0x42bfb972, 0xf97607fa, 0x8fd215f3, 
	0x081d79d1, 0xe3b5e5f5, 0x9928a375, 0x42afbe5b, 0x9d7a0fae, 0x965de384, 
	0x41cb8fd7, 0x13d4144f, 0x457f472c, 0xf40375e7, 0xe83da724, 0x369bf909, 
	0xea145afe, 0xaee86537, 0x93ae8045, 0x37a86f80, 0x0a7fa277, 0x9c687bed, 
	0x52d01f44, 0x202608af, 0x2379a544, 0x5db5f47d, 0xd492f9df, 0xfd5d1d9f, 
	0xbfa23f34, 0x33d3ebce, 0x5b5c6ed0, 0x3edc6f46, 0x3a9fd643, 0x234de5fd, 
	0xff41bd19, 0x94e9ed15, 0xbdc508e6, 0xfae49a53, 0xffdb2df5, 0x8d9bdfd6, 
	0xa5c9f5fe, 0xf5bf4917, 0x8fc8fb95, 0xc9d1bc6d, 0xeff4ac7e, 0xcc8e5fd5, 
	0xfe7e4598, 0x658fb251, 0x7c66555f, 0x29d3fc0f, 0xb38a4d27, 0x98f4ff6d, 
	0x828ff102, 0x5ab4ef76, 0x0531fd2f, 0x7a3c7cf9, 0x9f8043a5, 0x81be62e0, 
	0x68eb711d, 0xedfe5857, 0x9f98f7f2, 0xd827e62e, 0xcc76dcbd, 0x397bb04f, 
	0xddb21fe5, 0x0adf3173, 0xb8fd79a2, 0x8eeee81c, 0x68e590ee, 0x4fcc5cf7, 
	0xed3963b0, 0x6ceebf81, 0x122aa67f, 0x0bdda077, 0xb40bddb0, 0x49c63d41, 
	0xdda23eb0, 0xbb4a5673, 0xee679ae7, 0x89fb95ed, 0x708bba0b, 0x9eec8b5c, 
	0x1fa402ab, 0x56b553f8, 0x32b787ea, 0x647af76d, 0x7fba27dc, 0x3aab7400, 
	0xb191d0f5, 0x2ad55eec, 0x8bf1cbd1, 0xfb68c426, 0x74079817, 0xe6e8650e, 
	0x79b3fb02, 0x3b33c23c, 0xabcf40fa, 0x437e216a, 0x3ef9f87b, 0xf539c607, 
	0x327ebe30, 0x6f1ecf13, 0xfe0e7583, 0x73bb601d, 0x8dd32553, 0xbed805e1, 
	0x0f99cba5, 0xcd536681, 0x063e6729, 0xce5b910c, 0xec005e7e, 0xf3394e4b, 
	0x72351025, 0x7b4531ca, 0x0027f368, 0x27eb0c76, 0xc9f9912f, 0xb3d70d93, 
	0x0e1e8847, 0x906587b4, 0xb8187b47, 0x0343da45, 0xdfa097fa, 0x40edd236, 
	0xc04e06fa, 0x9e784afc, 0x4350f6b9, 0x0a75587b, 0x1e472dda, 0xc3da1a1a, 
	0x85c309c0, 0xd308b0f6, 0x9058e4cd, 0x9b750c3d, 0x99ffd0fb, 0xb8ae13ec, 
	0x7d1c32f4, 0x915f88a5, 0x83e20478, 0xa8afab3b, 0xf28bbe0c, 0xb882ba61, 
	0xda0130ef, 0x56ffde03, 0xee3954dc, 0x295fc85e, 0x7efdf9f3, 0x9535d976, 
	0x9fb0fbc1, 0xe9bf53a1, 0x13685db2, 0xbff00bf0, 0x65736177, 0x9fe8bdd1, 
	0xfb895f5c, 0xfd1555bd, 0x258e67e4, 0x04d7e817, 0x573ed282, 0xb9f692ad, 
	0x0e7103ca, 0xae425fca, 0xf6e0e8bb, 0x1c5cb0b7, 0x9e8bf9c0, 0xeb57b03e, 
	0x39fda52a, 0x81dfbd36, 0x82ad4ff3, 0x5e5da3f9, 0xfa0d7602, 0x7ea52a25, 
	0xd3dd79ba, 0x7681d30d, 0xd295f3f0, 0x9fe5da0e, 0xdbf694ae, 0x77edb3ed, 
	0xffb4bb5e, 0x7f7e5b92, 0x6ecbb4a5, 0xa20b275e, 0xdcb8fd79, 0xd03a6f59, 
	0xda39632e, 0x6ebdb765, 0x07db7246, 0xd9bfe94d, 0x641ca3f8, 0xf200e5db, 
	0x1172ec1b, 0x24a2e5db, 0x71c1efb4, 0xeecbb20c, 0xb41ec155, 0x97d609cb, 
	0x1c57b5aa, 0xefd492fe, 0x328a1b99, 0x4f3dd776, 0x6876e7ce, 0xaf4b2e37, 
	0x0d2cf9c7, 0xbd4eabeb, 0xfb536fb8, 0x1fecbb68, 0xbfd97696, 0x972ecf3d, 
	0xe5d923fc, 0xe54b1b69, 0x0b2bc73e, 0x7aef2ec9, 0xb79932f5, 0xb6edf2ed, 
	0x12a47e5d, 0x1b6fb2ed, 0xd187e5d8, 0x797693ef, 0xb86fef32, 0xd1ec96e6, 
	0x81ff4b0f, 0xa20ab5f6, 0x20556fb4, 0xaf7d2bb6, 0x68ae3ee2, 0xb9bf03eb, 
	0xe841bab1, 0x6dd1f926, 0xf0fb597d, 0x28438720, 0xf8e5f997, 0xfb293c97, 
	0x5d6e5fa3, 0x3c9020d2, 0xa1bbbf69, 0x88f9d42c, 0xbf2c7f1c, 0xb1fe6cfb, 
	0xd7259977, 0x7f5ccad9, 0xae654f6b, 0xcc945c7f, 0xe5b6176b, 0x2f7cb72e, 
	0x3fc657cb, 0xf697ebce, 0xeeb92d8f, 0xc7fbe657, 0x7d43edb9, 0x96c99f72, 
	0xbe435727, 0xd9296c7f, 0xe03ff1fe, 0xfc92713a, 0x3fd977e3, 0x458bfbbe, 
	0x9cf1fe59, 0x8ff47183, 0x1f1fec5d, 0xa713af4c, 0x063fd2e3, 0xf9e5003f, 
	0xfaff69d4, 0xd709d631, 0x03efa03d, 0x3f07d7a3, 0x3eb8c7f8, 0x00faf668, 
	0x65fa327e, 0xfb93f02e, 0x75c64fd8, 0xf3965de1, 0xfb327e51, 0x3caacec3, 
	0xe1fd993f, 0x27edb974, 0x2e917af3, 0xf664fdb7, 0xb6e5d37b, 0x48ebcc9f, 
	0x93f6dcba, 0x729c8c9b, 0x93f2c74c, 0x74175e75, 0x9c8f93f4, 0x54764fd9, 
	0xb9c2ebd9, 0x73aec9f9, 0x3fd193f5, 0x5f063d43, 0xf9827b59, 0xa6fb9510, 
	0xec5d7768, 0x23fee317, 0xfa175dda, 0x7c2257c7, 0xe3fd2e2b, 0xf8045298, 
	0x4b95525e, 0xc1f363ff, 0x7fa24e3f, 0x9c81f80c, 0xfb92aacc, 0xfd3cce70, 
	0x87d36e98, 0xa4aacbcb, 0xf4f3387e, 0x4f2edd23, 0x69f2ec3f, 0x728fd255, 
	0x57fed9d6, 0xdb3abf5e, 0x81fa92ff, 0xce1fa8e5, 0xdbb0fd3c, 0x3051fadb, 
	0x2ec5fa4b, 0x57e407d0, 0xd22c5f46, 0x0beb1717, 0xfd038fe8, 0x199d672a, 
	0x5cebfb47, 0xf68e307e, 0xc5d31677, 0xff65f6b5, 0xdfc9db97, 0xd05c7da4, 
	0xdfd0f783, 0x41ecd605, 0x4cfa76f9, 0x73aded05, 0x5e7a219e, 0x3f0d3e42, 
	0xb26fe534, 0xee4360fc, 0xd7fa8a27, 0x4d3da367, 0x2fa6d7db, 0xeb7d7d90, 
	0x7fcfb921, 0xc6a673e6, 0x9e67dc2a, 0xda769bfc, 0x873b15b7, 0x57fdc05e, 
	0xcd5f83f2, 0x7f28c1f8, 0x1433afd2, 0xb5396b8e, 0x7ef05cb8, 0x3d72a1bf, 
	0x0b9716a7, 0x0e1bcc87, 0xd4e0173e, 0x7d1072e2, 0xfee35fd9, 0x2e5c5a9c, 
	0x017fb80a, 0xe2d4e7f7, 0x7ae4e172, 0x6a73d727, 0x3170b971, 0xe7c3177c, 
	0x5872e2d4, 0xcebd6426, 0x5c5a9cf5, 0xdf0cdc2e, 0xb539f0cd, 0xb8785cb8, 
	0x9cf5c3de, 0xbc2e5c5a, 0xf0cbdf0c, 0x5cb8b539, 0x8fbfb8f8, 0x716a73fb, 
	0x7f73f0b9, 0xd4e7f73f, 0x757072e2, 0xeb807d65, 0x5cb8b539, 0x42fc3214, 
	0xc5a9cf86, 0xb2ea20e5, 0x73fb907f, 0x28b9716a, 0xdc45fee2, 0xcb8b539f, 
	0x43eb8845, 0xc5a9cf5c, 0xc31c62e5, 0x39f0c71f, 0x845cb8b5, 0xfb987fb9, 
	0xb9716a73, 0xc7fdcf18, 0x2d4e7f73, 0x5cc5172e, 0x9cf5cc5f, 0x262e5c5a, 
	0x0c09fc30, 0xcb8b539f, 0x97d70945, 0x16a73d70, 0x86528b97, 0x39f0ca5f, 
	0x4c5cb8b5, 0x5c89fae4, 0xe5c5a9cf, 0x9fc31262, 0xb539f0c4, 0xe64c5cb8, 
	0x3fb993fe, 0x8b9716a7, 0xc65fee32, 0xb8b539fd, 0xfae14c5c, 0xa9cf5c29, 
	0x2a62e5c5, 0xf0ca9fc3, 0x5cb8b539, 0xc23eb844, 0x5c5a9cf5, 0x7e19ca2e, 
	0xd4e7c339, 0xc15172e2, 0xcf5c15f5, 0xa2e5c5a9, 0x3257e192, 0x2e2d4e7c, 
	0xbfdc5517, 0x6a73fb8a, 0xe6a8b971, 0x9fdcd5fe, 0xc5cb8b53, 0xc69fae34, 
	0x5c5a9cf5, 0xfc33a62e, 0x539f0ce9, 0x9445cb8b, 0xcf5ca3eb, 0xa2e5c5a9, 
	0x30d7e186, 0x2e2d4e7c, 0x5f5cb517, 0x5a9cf5cb, 0x30662e5c, 0x9f0c19fc, 
	0x53ca8b53, 0x4bfc934e, 0xb914ebfc, 0x457fcefe, 0xb513ec3a, 0x071fb41d, 
	0x879e3771, 0x62697b5e, 0xaf3c34cb, 0x5836a4be, 0xb5573992, 0x3677bdf7, 
	0xf9d2d415, 0xfd296eb7, 0x6f5c2f3c, 0xbd7907f6, 0x84fc00b9, 0x69be2161, 
	0xfa270994, 0xa7d105e9, 0xe5d93f71, 0xd377f929, 0x97adf802, 0x773ed1b6, 
	0x2f3e52ec, 0xbb40fa06, 0xd1371563, 0xcf0db9be, 0xc67e373e, 0xf0d84ea8, 
	0xaa43def0, 0x173e52f9, 0xbc61fd96, 0x33fd606f, 0xf75a09c1, 0xd3f0d1e1, 
	0x1348fbfe, 0x56efeff9, 0x7ef1aa45, 0xcff699c8, 0x83f55ce9, 0x5f98f9ec, 
	0xc8b06334, 0xf9e52cec, 0x3e71c6b4, 0x0d967b17, 0xafc00699, 0x68ea73e7, 
	0x915bfcfa, 0x243099f3, 0xd9e06716, 0x59d829f3, 0xd1e1b09e, 0x4b66067c, 
	0xb9e41b7c, 0x029f3d8b, 0xf0793e7b, 0x6579f3d3, 0xbc039d31, 0x1aa7355b, 
	0x956943ef, 0x79ae3e72, 0x9a528a03, 0x79ed97f1, 0xe41adaa5, 0x0ecf95bd, 
	0x56f7d928, 0xf3996d9c, 0x0f3e3ee1, 0xb7baca2e, 0x45bfe782, 0xaf9d66af, 
	0xbf909f8b, 0xa5dbe531, 0x37233e92, 0xabcecdcd, 0xc8866b41, 0xf3ec37f2, 
	0xa4a7ff74, 0x906ae19f, 0x25c05cf1, 0xbf190eac, 0xf05c683b, 0x537e3007, 
	0x08ea1dc7, 0xf9737f42, 0xdf1885aa, 0xfd2d52dd, 0xb1f751a5, 0x89da1bda, 
	0x655e7c6e, 0x8432cfdf, 0x39d9afb0, 0xd0519fd0, 0xe32c58ef, 0xb14f3c3d, 
	0x4273edeb, 0xeb505b5f, 0xb6fe7686, 0x3f22a17a, 0x7e581b5a, 0x9ca7bd24, 
	0x4c871412, 0xe37a2399, 0xfc97c211, 0xa67f5b07, 0x88563efe, 0x1b5380e7, 
	0xbe067e21, 0xee1856b9, 0x0b2bf438, 0x0718dd59, 0x0ab36d4d, 0x4312bde5, 
	0x6a7ca0d7, 0x6d429ef1, 0xebbf6b20, 0x57cf193d, 0x1eae5a14, 0xaf1f8bf0, 
	0x54d57196, 0xfc103cfb, 0x57a04194, 0xcaf86a59, 0x75678099, 0xccd761dd, 
	0xf43b6557, 0xfc5d37ff, 0x47dc6a85, 0x85623a99, 0xe42bb484, 0x8a6d4cd7, 
	0xac56ae88, 0xcfd1ab37, 0x92227a9b, 0x5dba7cc0, 0x6c79a2d0, 0x1ab3b8ba, 
	0xf551ede3, 0x1c9f5dba, 0xd7623ebb, 0x7e1b186f, 0xd363c489, 0xf7637dc5, 
	0x96fd7617, 0xed47fbb1, 0xd763edfa, 0x8ff5dbd7, 0x5cbf098e, 0x94a71415, 
	0x1f69309d, 0x5fd9f5ea, 0xa77dc6ad, 0x2a4bdf00, 0x8a380d4b, 0x79e1fca0, 
	0x1979538f, 0xc3e843de, 0xf749d6c5, 0xf356564c, 0x7e9087fe, 0xc6447bb0, 
	0x2306ae4f, 0x8df0718c, 0xb8d34fe5, 0xc21a8bce, 0x77da0e55, 0x8cfbc80d, 
	0x4f7969d6, 0xb253fc04, 0xc1ec8267, 0x0e018c04, 0xcd43968f, 0x83f92128, 
	0x8f59cb7a, 0xa805117c, 0xde40d84f, 0x7f28308b, 0x7e91a1d0, 0xf51774a5, 
	0x3e522357, 0x8059a0d5, 0x4c2ea6e3, 0xd976f30a, 0x7d24d3af, 0xafff69d3, 
	0x1f51d4cd, 0xdd397a9d, 0x493884ff, 0xd4e5fb47, 0x0a9ee86b, 0x7d530fed, 
	0xdce1e129, 0x5584a238, 0x4cdfffa4, 0xfdb5bb42, 0x1b8d3f19, 0xf76eeafa, 
	0x7d772864, 0x7092646a, 0xf1fdf949, 0x6487bc69, 0x14a6f7d9, 0xa7b199cd, 
	0x7bb05105, 0xa22e8987, 0x73ed38eb, 0x3571c24d, 0x89f686bd, 0x9d7f2fee, 
	0xe5e9aaf8, 0xd4addd5d, 0xedf1126e, 0x16778806, 0xa980fa41, 0xee803b24, 
	0x35aa87d5, 0x87811fb0, 0x4156d776, 0x686d02dc, 0xbbefb55d, 0x3f3a9d1c, 
	0x5addfb8e, 0xf3c5e885, 0x99d5c3db, 0x5fa85afb, 0x105fbd9a, 0xb328b486, 
	0xb566f06f, 0x6d5d2b8c, 0x1ac0430d, 0x696afbf1, 0x35ec44a7, 0x83fde905, 
	0xbfa20ef9, 0x1abb50f6, 0x5d3e7a06, 0x768f50db, 0x31e42d00, 0x9cb1e7da, 
	0x9c2d2027, 0xf6d9fb26, 0xe22ea0a0, 0xaeebfb44, 0xb6b54dfe, 0x1ef1dcfa, 
	0x7ae796a9, 0xc3fbc367, 0xc0c5bc3c, 0xe4beb4eb, 0xf564fbe3, 0xa42eb487, 
	0x6f0056f1, 0x8f78ece5, 0x5cdb57ba, 0x43d365a8, 0x7ba5adf4, 0x2fdea74c, 
	0x9847b9ce, 0x30769f7f, 0x7f002302, 0x347b857d, 0x351c47ba, 0xd27f38e2, 
	0x43bfde0b, 0x07d7c8fd, 0x2f484f5b, 0xe9955ee8, 0x4b3c7dfa, 0xbd3ccc2f, 
	0x2f18d0e8, 0x1bf44a90, 0x5deba7f6, 0x1c4e2788, 0x205fa4f3, 0x1d315377, 
	0xc68f431c, 0x289576ef, 0xa47d47a8, 0xa482d647, 0xfaf90fd8, 0xfd0bab62, 
	0xb59f52a3, 0xdc124cd9, 0xeaffc422, 0xca0f02c4, 0x7c5a75f7, 0x0bc3df21, 
	0x608f7da1, 0x2b74047c, 0x276ea9f7, 0xd375d7e8, 0x05585f9e, 0xe3457d7a, 
	0xffef0050, 0xc86eb15d, 0x0cdf202b, 0x1357d7f4, 0xdd7da83f, 0x79e3a154, 
	0xdbe04b7b, 0x3d78c23f, 0x6daf57fa, 0xbfd04316, 0xfdc4d4b7, 0x2346f284, 
	0xea1d0269, 0xdc268917, 0x2fac8f4f, 0x37ebfba5, 0x9372934d, 0x40bae29d, 
	0x07de4ff6, 0x64ddc50c, 0x0f7843cf, 0x15f7e6c4, 0x158796cb, 0x3a66b758, 
	0x024d5e06, 0xe335eacd, 0x9f805b4b, 0x6f90c991, 0x67aaf704, 0xf72637e9, 
	0xd6c678e0, 0x9f72236d, 0x98ddd702, 0xa8cbfafa, 0x23c651a7, 0x1245d495, 
	0xc93735ef, 0xa72ff975, 0xdb23f3c9, 0x1c815e6e, 0xdef08958, 0x425e9316, 
	0x0b733178, 0x075e5f8c, 0xf987e9f3, 0xfdfdbcf5, 0xe71a7ed0, 0x38dc5b5b, 
	0x9d6c9faf, 0x0fa5f724, 0x710b37c7, 0x3be9ca25, 0x11174700, 0x7e606384, 
	0xf00bcf15, 0xe80cb5b8, 0xbaf97606, 0x757ee21b, 0xe797f100, 0x87edd740, 
	0xb9f013f8, 0xd5d151ae, 0xf703c498, 0x7be3afd6, 0xc2a71453, 0x667b5778, 
	0x8d8276b7, 0x93fbde3a, 0x0931facd, 0xe6fae517, 0x075d21b5, 0x7a7cdd7e, 
	0x43f78428, 0xd36d7e6f, 0x1c97e86b, 0x9c777c2b, 0x71c60578, 0xf586bff4, 
	0x1e5c8fb7, 0xeae0f5c2, 0x2ee08546, 0x05378189, 0x386e9770, 0x4c3ee452, 
	0x07a86ceb, 0x17a6fce4, 0x1d15154f, 0x87e87c96, 0x42a275fc, 0x3704f947, 
	0xfe002453, 0xd6f1ffad, 0x0bc64552, 0x45fd107a, 0xfb724c25, 0xffe934e0, 
	0x11bb622c, 0x0abaa989, 0xc7725df3, 0x84147f4f, 0x65a6fb71, 0x5f7853ad, 
	0xe6141934, 0x26b9904d, 0x97902c29, 0x12f174f0, 0x275d23ee, 0xaf74ebc6, 
	0xb25bc78f, 0xe11fb5fc, 0xf1fd88ba, 0x5e66e17c, 0x457a672f, 0xaeabf712, 
	0xb8e91472, 0xc795b55f, 0x820af9c7, 0xf009e9a3, 0xfd3dcbff, 0xb97fb09b, 
	0xb426c777, 0xfe596b63, 0x64b53896, 0x392fd407, 0x91d2bcad, 0xe3863fb5, 
	0x76c65da0, 0x5f065b7a, 0xa3f98fc2, 0xbfc68d54, 0xad0ff99b, 0xdca5335f, 
	0xb5f8442d, 0x07a38665, 0x7c07d2f4, 0xbfdf00f7, 0x67e772c6, 0x115be93b, 
	0x77fb8759, 0xbd4f1be1, 0x3bf5f68a, 0x32da8f3c, 0x5ebb3fd9, 0x1bea648f, 
	0xe4f19f79, 0xc8ddf934, 0x81c56ea2, 0xa9d7d876, 0xc5d4dc10, 0xe518456b, 
	0x98873a3d, 0x6cbe0295, 0xedf689b9, 0x210df984, 0x149c308e, 0xb42761c8, 
	0x44fb0b0b, 0x9f9070cb, 0xdc85378c, 0x23fbf999, 0x279bd56f, 0x868ffbf0, 
	0x4bed0688, 0xfda94b9b, 0x77de4255, 0x71e31afd, 0x205ab355, 0x0b7b60ee, 
	0xc7be13f2, 0xc11e3e7a, 0xb321adf1, 0x8ec9ca99, 0x128cf8b5, 0xf6387f3c, 
	0xb3207094, 0x183ed353, 0xf7da7ba2, 0xbdd10c8c, 0x7bd9fafe, 0xe5f6fee9, 
	0x2900de9c, 0x20d9bfd6, 0x65db27f3, 0xdee9700a, 0xbb45c03e, 0xefb2e6bc, 
	0xf8873d93, 0xd7dca723, 0x24e1089c, 0xcf117c6d, 0x478951e0, 0x23c490ff, 
	0xa3789318, 0xa635ff3f, 0x4ff099cf, 0x69e36be3, 0xf8de7de3, 0xff434f0e, 
	0x5af8ccec, 0x1116faa7, 0x0fbde3bf, 0x222e1c60, 0x67dfd99d, 0xf10e61fc, 
	0x4be74443, 0xf90c5f3e, 0x8ef9729b, 0xef998bed, 0x905fcbe7, 0xab9402ab, 
	0x0ae419f0, 0x7f181cfe, 0x7182fc61, 0xd4ba7451, 0x24345f1b, 0xc54895e3, 
	0xa620c701, 0xed12ff8f, 0x2a4fa438, 0x78411c72, 0x89443cf2, 0x47f577dc, 
	0x66373c8e, 0xa3de1e7d, 0xbe008df0, 0xfe47449d, 0xc9f2459e, 0x5d121f5f, 
	0x513a6377, 0x7d15feeb, 0x30d714bf, 0x09b8e54e, 0x87fdfef5, 0xf96a6932, 
	0x5a73bc48, 0x85f43fc6, 0x1d133ac5, 0x8d3a4398, 0xc3f1e61f, 0xc0ff98cf, 
	0x08689ddf, 0x9d88fc27, 0xc28b4837, 0x3bd765a6, 0xf20abf28, 0x903cf01f, 
	0xe20e9d6f, 0x48f193a3, 0xddf3c33d, 0x16e271ce, 0xf99d23c8, 0x27549a7b, 
	0x34f7f3d7, 0x9aba3b69, 0x32f8edcb, 0xe5bf13ac, 0x97f3cc15, 0x8f179117, 
	0xff1f379e, 0x7e14f99b, 0xb483e6d4, 0xed87e166, 0x6a7c90bc, 0x1260f9b7, 
	0x39bf401f, 0xc04f882f, 0x3e6c82e7, 0x7f64f9a7, 0xcf28f727, 0x4a63bf97, 
	0x993e606d, 0x3807ff4c, 0xbdfb96df, 0x364e9a40, 0x24f8f3bf, 0x4ff4988c, 
	0xe801bcf1, 0xcd1437ee, 0xb7ff0311, 0x83142951, 0xbf3a5f12, 0xc72a9436, 
	0x14e7e030, 0xfee3ae26, 0xd722c8f6, 0x9be7e400, 0x7ed87d1d, 0x074eefa0, 
	0xd0baa5fa, 0xe0217db0, 0x9e31fe4d, 0x3dd0b45b, 0x18f8ab61, 0xe48b4fad, 
	0xa1a99a7e, 0xf8fd111f, 0xf7185db3, 0x98fe1a4c, 0x55e00478, 0x197cd27c, 
	0xe9267ff7, 0xf9042d0e, 0x5f461f96, 0xbafb4072, 0xa7deef3b, 0x4bfadf90, 
	0x6a21b7f2, 0x0975fe97, 0x9103efd0, 0x02bf078e, 0x2ab82076, 0x3cf1e763, 
	0x2aed0924, 0xc14d9cf8, 0x17680c73, 0x044f1f15, 0x60d13e61, 0x27af4279, 
	0x97ef6d92, 0x963eb77e, 0x79e31ddf, 0x4295eb97, 0x04fd0c7d, 0xea47a7e9, 
	0x0a1f688b, 0xc402fed6, 0xf92fd8c3, 0x90788fd7, 0x70fd2aff, 0xf194463c, 
	0x5fb96ce9, 0xd8b36625, 0xb59c3c43, 0x229a925f, 0x5705d4e3, 0x49274525, 
	0x57efa992, 0xa9d01db9, 0xba225822, 0xefde8f0e, 0x6aaf9731, 0xe0d2fda2, 
	0xa3efb96c, 0xcefc96cf, 0x0519f7db, 0x40bbc6df, 0xd3d52fc6, 0xeb8e989e, 
	0x7ade3e58, 0x29312e3a, 0x27a7cf6e, 0x8670edd1, 0x23f4f9ae, 0xbd30b5ba, 
	0x9bd0cd9e, 0x4d1b1fe8, 0x38d39897, 0xb9fa5eba, 0xcfc01b3d, 0xbc665c9d, 
	0x97ac08ff, 0xe0430ad1, 0xf1fae33d, 0xc09bfbc6, 0x1ad5af0f, 0x847a496f, 
	0x8a6f1ca8, 0xfe000e47, 0x0b7248e1, 0x895757d4, 0xe7946c3f, 0xc71b45ee, 
	0xc215bf41, 0xa6bf4711, 0xbf2ffa51, 0x86fd2e9b, 0xa070b0ea, 0x79cc361f, 
	0xbd4a7fdb, 0x3ceb7239, 0x364f475c, 0xd70f36dc, 0x4cb6754f, 0xf96290c3, 
	0xafd7ce34, 0x9ce5e991, 0xd646b0de, 0xb6f9c5df, 0xd89f323d, 0x385bf323, 
	0x07e724ff, 0x5ee9903f, 0x40f8df4e, 0xf9c9bfd6, 0xc76fb393, 0x78c3f114, 
	0xb9cea528, 0x73c3ea9d, 0x17753ca8, 0x656b6da7, 0xeb2b589a, 0x49fe70b7, 
	0x2f3e0fce, 0x7d397bf3, 0xfe5979e3, 0x9e4fe726, 0xc77aa992, 0xe8945a6d, 
	0x61197447, 0x729d1cba, 0xa3ee0749, 0x6eb39ef8, 0x8f06f5e5, 0xb076d3ae, 
	0xdaf79558, 0x97c5f6ed, 0xe2e1d697, 0xc104983f, 0x3c793f02, 0xe1f33fdf, 
	0xba0ddb7a, 0x10e09d11, 0x0c7f6740, 0x1ce217f4, 0x038960df, 0xdf14adef, 
	0xc890fe01, 0xf40f83e8, 0xa906dcdb, 0xbf781c2e, 0xf5fb6cf8, 0x7e974cef, 
	0xaaff6db4, 0x931e727d, 0x810e6dc1, 0x76eace50, 0x73557f49, 0x9111be88, 
	0xbfc4fbfe, 0x9d13629a, 0x0c4a1b37, 0xfc3c27e5, 0x908b23fe, 0x3d43e60e, 
	0xffcd660f, 0xede7919e, 0x6f38c97b, 0xe41dc73f, 0xa77b49cf, 0xf3fae1f4, 
	0x08a556e9, 0xb1ef8afc, 0x05aa925f, 0x39e76d3f, 0xf36773f8, 0x235f1ee3, 
	0x91acefd3, 0x7a732ff5, 0x3f2c8f70, 0xdfe647b2, 0x79f3bce3, 0xa29e0f99, 
	0x9165cd74, 0x6a7e58e8, 0xab587fbe, 0x01c50aa9, 0xa6fa2837, 0x740f1413, 
	0xad34fde0, 0x4bd688be, 0xbad4af4d, 0xf6e2e04f, 0x9b4c2ef1, 0x74a36bab, 
	0xbd33492f, 0x87e6b25b, 0xfbd2b4f7, 0x2e76d97e, 0x4d275cef, 0x05f198df, 
	0x7d6b3cb3, 0x8d4378e5, 0xf5a67eb2, 0x77ba7638, 0x78c9f23f, 0x68cf5b70, 
	0x5e0b1f7d, 0x9f193df6, 0xa26df2cf, 0x099146f6, 0xe31faefe, 0xaa2ff463, 
	0xcf5c0ecc, 0x07451303, 0x1efa77ee, 0xbcb07630, 0xe07f6c3b, 0xc5eefa29, 
	0x50402472, 0x49de50fd, 0x6477daed, 0xdb6c577f, 0xd531df11, 0xf8461a17, 
	0x58417c0b, 0x2a2aff4f, 0xdf1f49e3, 0x46ad10cb, 0xbcf01247, 0x796dcb9e, 
	0x0746ed12, 0x41b42f9d, 0xfe0ce2fd, 0x1dcd55fe, 0x57fa6718, 0xff4978db, 
	0x501f7d21, 0x202f0937, 0x5fe5e11b, 0xfaf178cd, 0x7d257c0f, 0x015f23f0, 
	0x73f21f2f, 0xc657e426, 0x989ef03a, 0xe58af90f, 0xe456d7c8, 0x2f249deb, 
	0xc1ebe47e, 0xb17d5f0c, 0x0b6be373, 0x5aa727ef, 0x3bfb6155, 0xa9e04b9a, 
	0x85eff92a, 0xffd80788, 0x9ea5442f, 0x4b96dd10, 0x12bae37a, 0x01355568, 
	0x547bfef5, 0x859e005d, 0x466c0c0f, 0xc3ca017f, 0xd0145fb8, 0xdafb4e3f, 
	0x6d22a681, 0xb56ff81b, 0xe0f3df23, 0xd387f67a, 0x0920c1f3, 0xddeaed71, 
	0xc339ad5e, 0xa2026b97, 0x0852f903, 0xbed082f0, 0xf95ee98b, 0xe8673c80, 
	0xfba33962, 0x84b7e811, 0x9366cdcc, 0xef4eb710, 0x76bef922, 0x79c2eeff, 
	0x9f6bc7c0, 0x9fd90b34, 0x6b8b73a3, 0xeddc258a, 0xd0dfb951, 0x1f1173e2, 
	0x46f68b2f, 0xf4676fbd, 0xe92f9ec9, 0x9f38b3d1, 0x21cf3a61, 0xf4658a7d, 
	0x7a0cf0a9, 0x25bd5cd4, 0x6773e78a, 0xe4e57ba3, 0x7ee1c6c7, 0xc951aa65, 
	0x390e61c4, 0x7bfa016f, 0x9ef203ed, 0x962f864e, 0x79cb75ae, 0x1d4e5f13, 
	0x5cbbe8e8, 0x2f983788, 0x03ab2185, 0x17f232fd, 0xcc2ffd61, 0xd3217f9b, 
	0x96c8fc85, 0xfb691f8c, 0x49fca38d, 0x19631ff4, 0xc7fc927f, 0x527f6cf2, 
	0x7f698ffa, 0x68ff9472, 0x05bbf668, 0xc63feda6, 0x3cc9fcb2, 0x4afc91ff, 
	0xf71fcea2, 0xa5478f1f, 0xe6fe48ff, 0x1723f661, 0xddfe5188, 0x5b47f939, 
	0xee67e0cf, 0xc46c7b40, 0xfa45ff3b, 0xe2c8a646, 0x67f80963, 0x19fe963f, 
	0x5eb62bc6, 0x2f7c84a7, 0x3a51f681, 0x9e308f99, 0xf522a26f, 0xde907962, 
	0x6af9b107, 0x9511dbc3, 0x47b84efb, 0xf9e2eb80, 0xfc66e1ca, 0x99f577f6, 
	0xffb471e5, 0x5cf44af8, 0x1057c7fc, 0x23e21b6e, 0x47b402fd, 0x7eac0189, 
	0xf9421f59, 0xc0e91959, 0xead4e1f3, 0x4276b7dd, 0x8846a079, 0xef8be026, 
	0xc76bd351, 0xd17728bb, 0x4091d10a, 0x2bafd079, 0x576271c1, 0xdc8fb428, 
	0x87a2a572, 0x52a2de50, 0x2aae6b1e, 0xaaf08eda, 0xadf28ddb, 0x1bdeb88d, 
	0xf90f5ee1, 0xb03de591, 0xd57e148e, 0x0bd438b8, 0x7861b37a, 0x00fd8791, 
	0xfc004be4, 0x2e6f3c0e, 0xa61d190a, 0xf055764e, 0xc713b1be, 0xd7dca3f3, 
	0xd4f07da3, 0xa3f07da0, 0xe8c9ac5e, 0xeec56a45, 0xc563415b, 0x1abee9ae, 
	0xec43d77c, 0x56fee856, 0x958757e1, 0xbc6097a2, 0x39e980e4, 0xec1fa90d, 
	0x8b29fa1e, 0x6ff36a64, 0xdfe48d5c, 0x7f0f596f, 0x1da8fccb, 0xcec72179, 
	0xbf70dd21, 0xa20df097, 0xf84499dd, 0x335bbe10, 0x3c9e1478, 0x37eec8ed, 
	0xa77e5dae, 0x24197a8a, 0x05e7967d, 0xebe9de53, 0x09cbfdc0, 0x6a3f7235, 
	0xcbb49972, 0x105d6768, 0xdd7ea4ff, 0x1e6f139e, 0xd858cbbd, 0x68eb9313, 
	0xa3690228, 0x4fbfb0b1, 0x71598048, 0x44f5b079, 0xfb4ad9bd, 0x1797140a, 
	0xbc033cb3, 0x30786ca2, 0x8a4a938f, 0xcbb22bca, 0xce28fc41, 0x51d88277, 
	0x4889a53c, 0xe22fee27, 0x840df6fa, 0x3c1df72b, 0x6aee40cb, 0x0944ff21, 
	0x750697d5, 0xd4f32305, 0x707db20d, 0xe3805ebb, 0x7a21530a, 0x190a8b14, 
	0xa6e1bf77, 0x1c63e3fe, 0xe7764f57, 0xc96c6bee, 0x52fd03ca, 0x8cf9019f, 
	0x7883f964, 0xef2a11bf, 0x435d5e8e, 0x386ea6eb, 0x6c1d3df0, 0x65bff487, 
	0xffa1a98a, 0x7ff5e219, 0x6eb065c9, 0x4b897e40, 0xae00efa5, 0x5cdf7e67, 
	0x4ed5f523, 0x92340b6b, 0x5561968b, 0xbe644f78, 0x72e25f5f, 0x0e7d43ee, 
	0xbd3d50ad, 0xee3db2ad, 0xce3886f3, 0xd3af76c1, 0x421c667a, 0xbadf43fd, 
	0xce7c4eeb, 0xdf86d945, 0x138706e5, 0xe62b450b, 0x7948dc17, 0xb6997b14, 
	0x8c2cda61, 0xe965379b, 0xd50de843, 0x087d0093, 0xb3a82e82, 0xf9e9b884, 
	0xb1181de5, 0xc5c61a7d, 0x6e4f8773, 0xb410ee1a, 0x13fe038f, 0xfae967f0, 
	0xf71e529f, 0xf815d5ca, 0x8ee5c11e, 0x782800d9, 0xd40ee2e2, 0x4682da83, 
	0x5366ab92, 0xc139e3f5, 0xfd6b6dd2, 0xfd4eb025, 0xfca753c5, 0x27c40160, 
	0x1036bbbf, 0x074dfc85, 0x21ea054e, 0xa32e97ff, 0x3c793770, 0xfc05a156, 
	0xcfb1aceb, 0x2be08c89, 0x415b2f14, 0x4450679a, 0x5cf02b42, 0x388db5e2, 
	0x3bfd087e, 0x52e47bc4, 0x43fe5b2d, 0x88fd61fb, 0xc4065d11, 0xbfefb813, 
	0xaf8487e9, 0xda24f431, 0x4a3bd091, 0x9fd8176b, 0x7f07b5c2, 0xe816f688, 
	0xfb961772, 0x796678ed, 0xad05f7f3, 0xa4e3a243, 0x94f97a8a, 0xad33e507, 
	0xf88fa097, 0xde2d74fd, 0x78415f46, 0x051ed17a, 0x56ae4756, 0x90051ec0, 
	0xed7e309e, 0x954244c1, 0x57d523eb, 0x539f86c5, 0xdfbf3186, 0x0cf2772b, 
	0xde722bdf, 0xe5bfac3e, 0x78bdf5c8, 0xcf9ae81f, 0x0035772f, 0x9bfdafb1, 
	0xe2f35de7, 0x3c269f80, 0xb5975edf, 0x8e627abf, 0x739e2677, 0x1ebcd03f, 
	0xbd8cc6fd, 0x8444078d, 0x61f02ded, 0xf8b8200e, 0xbd3db664, 0x21f504b2, 
	0xaffa9edf, 0xba2ed96e, 0xe7361d70, 0x7b246b6e, 0x07b36bba, 0x6e6469ed, 
	0xa7b262cf, 0xc87bd6bb, 0xde90079e, 0x67d6988d, 0x09d947ec, 0x75e908b3, 
	0xb4b12ef4, 0x4f9e5867, 0x7e8d3ae0, 0xb25f9d38, 0x7d3881fd, 0xed0c7f69, 
	0x9e3f7350, 0x72c3f917, 0x965161bf, 0xece5f1fd, 0xfd0e1a1f, 0x599d8c83, 
	0x28f52b58, 0x94701f7f, 0x8bfee1bd, 0x0d8dedf2, 0x6f66a3f7, 0xf6392362, 
	0x66f687c6, 0xc98f8cab, 0xda3d40ce, 0x3fa3bb99, 0x713f41a9, 0x359df4d7, 
	0xf445ff78, 0xeceeb4a9, 0xc93d3d44, 0x0dfe83f2, 0xf83771e8, 0x9c844b55, 
	0x4504a5a7, 0x9969c602, 0x978a1c60, 0x3bd9bda0, 0xe1f601dd, 0x2d67a631, 
	0x8768f3fb, 0x015d2216, 0x43b402de, 0x08f9d8c2, 0x483e839d, 0xedd5e8a7, 
	0xfbade2e6, 0xbedd9d69, 0x42e517a1, 0xcbdf966c, 0xb71bfd19, 0xf3c43d60, 
	0xbe5eb09b, 0xefcf5117, 0x71e12c50, 0x52b3d530, 0x6ffc7e5b, 0x92357424, 
	0xf3881f91, 0xc1fef81c, 0xbb4ad45f, 0xfb3f9f67, 0x503ac456, 0x45cbfc3f, 
	0x8aefbdab, 0xe158e1e6, 0xfbec8e7d, 0x827bbe5d, 0x6bae2a1d, 0x247f04f7, 
	0xf210de60, 0xc71eb63b, 0x3feb14d4, 0xe30fe521, 0x5d576ba2, 0x82ef8fdf, 
	0x3c633ca0, 0x787808d7, 0x38ddb106, 0x2fd4026d, 0x85690e1a, 0xa37ca533, 
	0x6b4d751f, 0xf18748a2, 0xdc1d7f7d, 0x1b01f787, 0x00ef52c3, 0x3ab9b2ae, 
	0xf9e3beb3, 0xbfd40f59, 0xfced2b5a, 0x50d1ce99, 0xf25983be, 0xe5d33f7d, 
	0xf17df28c, 0xfdeca2da, 0x5f7cb4f5, 0x6722b6bc, 0x59bffddf, 0x5df11bbe, 
	0xfa3ff41e, 0x7be076ee, 0x1f324f3a, 0xb07051fd, 0x8a7eb852, 0x6f3bc201, 
	0x3ad53fbf, 0xc636ab72, 0x6f5e9bba, 0x7a4c3ea1, 0xeded9600, 0xf357fb33, 
	0x655fee99, 0xbc53073f, 0xff2671f7, 0x46b4db6a, 0x7aae7782, 0xe5e18879, 
	0xe9aee7eb, 0x3f92d6d7, 0x72497ac8, 0xbe72cadd, 0xbf7cb469, 0xb3bf235f, 
	0xc520edb0, 0x97283d59, 0x5afad1af, 0xea5bebc4, 0x7c8b6b33, 0x3f35e759, 
	0xe8a27d60, 0x2b0fcb2f, 0x781c346a, 0xe510af1f, 0xe9e30aa2, 0xab472961, 
	0x99fce8f3, 0x87b221b5, 0x23fe0f0c, 0x39981e38, 0x6451b7f1, 0x1ef093ce, 
	0xe21ac1cf, 0x95ef987f, 0x92096ea4, 0xf3ed847c, 0xbda39807, 0xb2b9a16f, 
	0xc64537f8, 0x047bfecf, 0xf07ee5c5, 0x4f40fbb7, 0xf92b547f, 0x156e5fe2, 
	0x3a488bae, 0x91deb238, 0x4b10adf2, 0xf3931de9, 0x3dca6f3e, 0x8785c22f, 
	0x0a18f5ee, 0x57a4b7c5, 0x2304feb0, 0x77bc0915, 0xa91c8c16, 0x17c038c7, 
	0x896fc0a9, 0x3e96fad2, 0x37d3c957, 0x44ef47e8, 0xcacdde91, 0xaf3ecfc2, 
	0x7f7e1b39, 0xa0bcbd66, 0xd9e5ca56, 0x9aeaf3f4, 0xcfde49c7, 0x9f91cf66, 
	0x09513ef2, 0x193bebe1, 0x1f427da4, 0xafd747d8, 0x9b5bd6b2, 0xc0fc765e, 
	0x69d21f79, 0xcbfad665, 0x81a062e5, 0xf91930e8, 0x277a43d4, 0xe73b19e7, 
	0x1e604078, 0x3a21e13f, 0xd7aa7585, 0x9b222e90, 0x3fd9112e, 0xfbd91e9f, 
	0xdb338927, 0xcf4cd99d, 0x6db3fb7c, 0x7e89f7da, 0xbeae76f9, 0xa13bee56, 
	0xb838c3bd, 0x88e109e8, 0xa37ca507, 0xfe045d1f, 0x887fe60f, 0xbe40eff5, 
	0xfcb3ea13, 0xbc5e40b7, 0xd72d581c, 0xdd86d4bb, 0xee506ab7, 0x65e32198, 
	0xbc7613ff, 0xfeb8696c, 0x045dfed9, 0xfb3765e3, 0xe7ecc375, 0x0fc19e0d, 
	0xe7e26588, 0x7e80dfb4, 0x6653f401, 0x9e49f1d8, 0xfb6b505f, 0x441e1205, 
	0x06af74a4, 0x98fee3db, 0x9cefca88, 0xefaf716e, 0xbaa078c0, 0x9676e07d, 
	0x245f53af, 0xbdb81af9, 0xc0cbfc07, 0x18a44653, 0x2347f2e3, 0xf2e3b2fb, 
	0xea33a022, 0xd990b8e3, 0xfccef781, 0x4e389650, 0x3cb8a4f3, 0x3fcb8e90, 
	0x2c38c5ac, 0xaf971f90, 0xd9fc4ddc, 0x6d74fd35, 0x781e5c76, 0x5c52a22a, 
	0x3d32ddbe, 0xa7fca10f, 0x3e47bda4, 0x3af33c9c, 0x7e1d33a2, 0x67eaf6c6, 
	0x5a670f2c, 0x8a7f0847, 0x683383d3, 0xfbf040df, 0xe0578c6d, 0x71398be4, 
	0xc64db87a, 0x275801e9, 0x3f1fb842, 0xa307ae43, 0x3aef8bd7, 0x67ff30dc, 
	0xd27bc866, 0xdf630281, 0x67ed0d16, 0xe3d22b43, 0x73b7e158, 0xd2559ffd, 
	0xfaaff1ff, 0xf73ff933, 0x59ffcd9d, 0x3a01e8e0, 0xf9fa63ae, 0x7f19ffd1, 
	0xe6e7ff76, 0xfa77ff19, 0xce333d3f, 0x5fb9ffd1, 0xdf7a79ea, 0x70efbd3f, 
	0x9e13c933, 0x821d9003, 0xff9de176, 0x5f3c7d7f, 0x7c035dbe, 0xb3b67dc0, 
	0xb4db6ff1, 0xd96319ae, 0xe919e6f7, 0xdffec4f7, 0x28cf1758, 0x9fd9a08f, 
	0x818f2d1b, 0x720b1fb4, 0x12fb46e5, 0x8575c4ea, 0x5962e1ce, 0xc3cb2c7e, 
	0x7ed8670f, 0xa57845ac, 0x9a34f9ef, 0x105e0ef4, 0xf804f4e9, 0x72c36db3, 
	0x0fbed17f, 0xedbbcb63, 0xffbc32c7, 0x36db1fb4, 0xb01b1fb6, 0xb655d8fd, 
	0x1f926b1f, 0xabdb1afb, 0x63f02ac0, 0x763df007, 0x6d989ef9, 0xe42b0307, 
	0x35eb0f7a, 0x8f5801f9, 0x51bfbeeb, 0xed07b7fa, 0xe399a77c, 0x171bf807, 
	0xb9fdf1f8, 0xeafea10f, 0x37fbd1b6, 0xbdbbebf9, 0x39eb456f, 0x33d7f5f0, 
	0xa942fbe4, 0xb17e3295, 0xd7b60bbf, 0xd5715187, 0xa8bf194a, 0x49ce8361, 
	0xe1bbf7f3, 0xa7dd116f, 0x9ed7f5e3, 0x6104c55f, 0x90e1b8e1, 0xc0c78808, 
	0x71c9d48e, 0x6bfe9d6f, 0xddf39fd2, 0x19ddf88f, 0xcc5f8efc, 0xc0efdb18, 
	0xfd277c72, 0xd05f9aea, 0x63ff9878, 0x275ab9eb, 0xccc7ede5, 0xe6ba7cb7, 
	0xfbf9ebaf, 0x52df4464, 0x5f7d373a, 0xdc60ffbe, 0xa4ab71bb, 0xd89eb65f, 
	0x5a2cbdf4, 0x407e4754, 0x4f519d16, 0xef6cf9f2, 0xfc032dd7, 0xe2bc4b16, 
	0x8ce22389, 0x785975fb, 0x4fde6f74, 0xf78f75fb, 0x1acfd179, 0x2477e270, 
	0xc70de3f5, 0x63f69306, 0xf4684494, 0xa652cc7e, 0x567aa603, 0x63ff23aa, 
	0x4282bdf4, 0xd33ec6f7, 0xa01ce857, 0xbbe86def, 0x8af01716, 0x05057fee, 
	0x3a817f7d, 0x9466e7c3, 0xb04bbfb7, 0x7e1759e3, 0x97f20077, 0xfe7483d2, 
	0xf24cc7c5, 0xd3e8331e, 0x1fec758d, 0x6e447bf0, 0xc39350dd, 0x6e935e52, 
	0xf4124f89, 0xbdf195ac, 0x493cfa75, 0x7cc3964f, 0xde431d39, 0x678877e4, 
	0x7525b790, 0x4d7fef63, 0x6d05f281, 0xb6dc7fd4, 0x48affd9c, 0x8fb3fb2f, 
	0x9d13d727, 0x933ef2c3, 0x462f1e51, 0x0ea6bc39, 0xb746e7f7, 0x23cdee13, 
	0xf6d73f19, 0xb9eff34b, 0x555e9aec, 0xff0c7287, 0xb2e1f8a7, 0xf8044828, 
	0xec57bab1, 0x200b7bc5, 0x0ed00bd7, 0x6a535c81, 0xe795bbf7, 0x2d2ebe31, 
	0x73f239d7, 0x74eeb956, 0x8eac3c96, 0x0fb14f25, 0xf0061df1, 0xf8dc1fdb, 
	0x9e67be05, 0xcb664e75, 0x9eabbe0b, 0xcdcfb234, 0xeb1badee, 0x5babccdc, 
	0x3dc1e92a, 0x5a4beb63, 0xe3f9ee4f, 0xbabdf27a, 0x39f6bef4, 0xcb6449ea, 
	0xbdafb966, 0xf43cffb2, 0xeba639e4, 0xe7d74c73, 0xe4f49bfe, 0x93d47385, 
	0xc9eb4a7f, 0x4e747563, 0x4f487ff5, 0xdb1bad9e, 0xa5d4772e, 0xb6eb89f7, 
	0x89eb67b5, 0xffcb08f5, 0x7f921eca, 0x93d602f3, 0xf23df8c5, 0x58bb35d5, 
	0x19dbf24f, 0xcfdb9b15, 0xa87a4f45, 0xb49d4f7f, 0x414597f7, 0xbb3dde22, 
	0xfa65ec9e, 0xeb4ffdac, 0xfd3cbe49, 0x2ff27aa9, 0xd0674f92, 0x5555f013, 
	0xbf6517bc, 0x87bf685b, 0x7dc7cf68, 0x5bc79c81, 0x8cbbf675, 0x16c77d16, 
	0x5dbaf7e1, 0xdc3be593, 0x10ab02ae, 0x711177fd, 0x96d939d2, 0xbfc25caf, 
	0xce98b117, 0x5bfb6f71, 0xc7de59df, 0x59f48b7f, 0xefd10d75, 0x47f3a85f, 
	0x8c3dfc14, 0xed262d9a, 0xce38ea4f, 0xdc9bbe20, 0x3d61c6a1, 0x72ff6375, 
	0x7a32afa8, 0x74f09fd1, 0xf3c75f5a, 0xa3c3a078, 0x5f2f40bd, 0x786bec71, 
	0x180be4ce, 0xdf03f56f, 0xe26b32b5, 0xe0bf40c3, 0xde337322, 0x40f1adeb, 
	0x4d63e03f, 0xef83b19d, 0xf7d92917, 0x43740ab4, 0x6050fbc1, 0x6a4e941e, 
	0xde83bed7, 0x3f488df1, 0x21f78430, 0x909f8842, 0x368021f7, 0x66aa1f78, 
	0x906f4b49, 0x44b89fee, 0xbb480af7, 0x7ba16fc1, 0x700bae6e, 0xf779357e, 
	0x10fbeca1, 0x1c70f7f9, 0x5f100eeb, 0x8efc9dbc, 0x18bfcc1a, 0xce81d1c6, 
	0x3ef941e1, 0xfacbc624, 0x4317a15c, 0x69f3217a, 0x278677d4, 0x0fca3fb4, 
	0x414275d5, 0x2fbe67fa, 0xea78449c, 0xb36b77d3, 0xd0164148, 0x75ff52bb, 
	0x2f3baa74, 0xdfb0d53a, 0x00f944ef, 0xde78d3f9, 0x9df2399e, 0xa80f9234, 
	0x90b9dc9f, 0xe82dddde, 0xf7067e1c, 0xe3619c87, 0x55272807, 0x2853c6c5, 
	0x63015527, 0xf717b370, 0xdbbfac45, 0x8be476c8, 0xf3e9fc8f, 0x50cbefb6, 
	0xd1b7a03f, 0xd10def20, 0x88c399bd, 0x1a6fa2b7, 0x95c3a2cc, 0x57340ed2, 
	0xf9af392f, 0x67bf7e0b, 0x7450537c, 0x57a87c42, 0x67b1fec5, 0xf7f2a61f, 
	0xe45f746c, 0xeeaf9c45, 0xb9bf8a33, 0x14c3f51e, 0xdf50073d, 0xa0369b63, 
	0xa9159f5d, 0xf84bfafc, 0x69b1a86e, 0x7b8c1773, 0x28ef45b9, 0xa22a8f8c, 
	0x8e40effb, 0x6fe7b06e, 0x7b726dd0, 0x706768fe, 0xc7286efe, 0xe06f7bf9, 
	0x0aeff3f9, 0xdc3676a4, 0x99eeb227, 0xd347d68f, 0xb631f527, 0xc25c6361, 
	0x47733947, 0x559c3ce4, 0x42cf5603, 0x76dc0d4c, 0xf59f4e12, 0xcf9be213, 
	0xbd37e9f8, 0x24533fc8, 0x52bbe00f, 0x47dc04c6, 0x4c8ace76, 0xdf08b9df, 
	0xdb6c8a75, 0x87999bd2, 0x8d51e71b, 0xf1b9c371, 0xc7c79bd1, 0xcfbe4561, 
	0xf9826a94, 0x5d1bbd64, 0x62780cd0, 0xf86d1e1c, 0xd9f9765c, 0x62db49e4, 
	0xdecf90f8, 0xcf0f8a63, 0x96efd3ed, 0xbc095ab7, 0x02e1b9cf, 0x9b8bbfb9, 
	0xa73ef2ae, 0x39f79095, 0xc6717ea1, 0xfaaf7b2e, 0xfdf44251, 0x09aaf3e9, 
	0xbfdb57fd, 0xaf4fcea7, 0xdaaafc6d, 0x67d43477, 0x4174d2f0, 0xde396178, 
	0x5b3d234d, 0x1a14ef8e, 0x5c87d48a, 0xa3bc237d, 0x99c36fac, 0xf5a36b7b, 
	0x700b85ee, 0xfc673c9d, 0x7ef45b96, 0x0df078ca, 0x51cebe48, 0xfe00ee4f, 
	0xd9d0fee2, 0x2ddbc5f4, 0x047ed086, 0xf0870556, 0x8eefbb7e, 0xa3ee3892, 
	0xf727587e, 0xf9d94767, 0xebb278c8, 0xc9272b55, 0xd3feb675, 0x54dff764, 
	0xb5dd790b, 0x3f0cfc14, 0x221edeb3, 0xe5d3a87e, 0x5308d1ef, 0x7fd34efe, 
	0xd3fc5d76, 0x9fbfdeed, 0x666ffd1f, 0xe7fed53b, 0x9ccd7fa1, 0xebfc333f, 
	0x11b8fca5, 0x747ddffe, 0xd72d93ec, 0x51f907b8, 0x66542bc2, 0xed887f49, 
	0xeb955ea5, 0xff656ea7, 0xbff45307, 0xeb1fecbd, 0x20463fe8, 0xe04e1c6d, 
	0xbbded4f7, 0x0935783e, 0xca1739f9, 0x7132a1f6, 0x766bca39, 0x81903ebd, 
	0x6167ef63, 0xe2ef4018, 0xbe0f2eea, 0x48f584cf, 0x90d8baa3, 0xb94a8e2a, 
	0x7bcd38c0, 0xdfdfd8d5, 0x43c27d46, 0x2edf0fdf, 0xf87efa54, 0xfdf911ae, 
	0x7dfc55c6, 0xaf7f1b47, 0xdf906891, 0xfce16c5d, 0xcfeb4e34, 0xf5ee3df4, 
	0x5df58e17, 0xbc531e86, 0x8da55ef8, 0x95ef1477, 0xb2ebd167, 0x65bc650b, 
	0xf6acedd3, 0xbad728dc, 0x79edb387, 0x65e785cb, 0xffde59cf, 0x1574fa6c, 
	0xce388fc3, 0x57396fcb, 0x1ea7f0f8, 0x57763332, 0x3447b8e7, 0xb7764c5d, 
	0xe6bbb6c2, 0x996fca52, 0xbc4e4973, 0x3b024fa3, 0x0eb8eb8d, 0xb461f4fe, 
	0x5df27deb, 0x233dfe2e, 0x460f8edb, 0x6d5d13d6, 0x2579dc7f, 0x9f6041c4, 
	0xf3c63e6b, 0xcb3f8a0b, 0xbd792afc, 0x22b1f699, 0x2aaa6f5a, 0xf9bd694b, 
	0xfe47f627, 0xe4febb74, 0xd765e785, 0xe46e8f99, 0x6fc847e3, 0x8f9bd7b3, 
	0xf39ebd9c, 0x040bc4d1, 0x5df9cd5d, 0xbe5239af, 0x6cfe38ed, 0xf605d37a, 
	0xa7c1cf09, 0x487fac7d, 0xb94fe964, 0x1fa01630, 0x3b83eb63, 0x72523e28, 
	0x1cc679e2, 0xd200b1de, 0x4eda0c27, 0x5a6a3cf4, 0xfd2057c9, 0x077fa17b, 
	0x45f71ce2, 0xb463ce82, 0xbbf465ca, 0xb03e7663, 0xbf2e39aa, 0xf9ef928b, 
	0x87ca8200, 0x77e8c51b, 0xf941a2ad, 0x3bde79bd, 0xe47af93b, 0x4dc5689d, 
	0x0174bdf9, 0xc85b5efd, 0x74c6b77e, 0xd182eff2, 0xcb452ff7, 0x7d04c2cc, 
	0x0769615f, 0xf0561c65, 0x7be54a73, 0x261ae84c, 0xdf9471c9, 0x42251935, 
	0xd3ce75c3, 0x4ed13a6c, 0x17768f1c, 0x6bbd79e0, 0xf38efca2, 0x0140f478, 
	0xa799fefe, 0xfda272d9, 0xbb9befb0, 0x141df23c, 0xa7b17efb, 0x4ed13859, 
	0x0aba8f1c, 0x8ee677f0, 0x402caf47, 0xc3669e78, 0xf8fcf089, 0x2171e85d, 
	0x0e101c8e, 0xe6efb79c, 0x9efc5686, 0xc1cf7fc3, 0x305f7e04, 0xfacca2f3, 
	0x7f10f14c, 0xfceeaa47, 0xfca38a67, 0xa93bf90e, 0xb43ebffe, 0xbc3fbf17, 
	0x3e7922f8, 0x5572e5ee, 0x3c5ec3ff, 0x49f1b56f, 0x71c30bdf, 0x94ae5bf0, 
	0x2e5f11cb, 0xafe740e9, 0x1c4fb93e, 0x6e73fbc1, 0xf81c43f2, 0x91c015bb, 
	0xf5599397, 0xc24dba47, 0x06bbca17, 0x30458f01, 0xccb6ccee, 0xb10958ef, 
	0xf5c703bf, 0x4f7f07fe, 0xe3bcfdca, 0x933c5e01, 0x2f28712f, 0x255d3be3, 
	0xb835d2aa, 0x116b8859, 0x5bd1d00e, 0x0b8ff72d, 0xe48ea1d5, 0x3affc838, 
	0x84b14e0f, 0xbe08e253, 0xf19af78c, 0x7efc1a5d, 0xb21efecb, 0xd5760d44, 
	0xdf94c9af, 0x269dc36c, 0x50b40f7f, 0xdd91d83d, 0x971bfbcf, 0x86d26efc, 
	0x2be0013f, 0x8caa78d9, 0xde784aa7, 0x2e9bc361, 0x2f6f092c, 0xe549e9e1, 
	0xdb09e9e2, 0xcf084678, 0x233c28e0, 0xfe5da784, 0xa9eb8659, 0xd5a977e2, 
	0x7eec8ee1, 0x1749029e, 0xf9137efc, 0xd0dbdbed, 0x86f5c61a, 0x9c7a1fef, 
	0x2c017e72, 0x0794ce6f, 0x05ad222a, 0x635dfc11, 0x6f606f89, 0x5b3f4e7b, 
	0x3c78ec2e, 0x2d6b1150, 0xa80c3900, 0x964375a2, 0xdf79877f, 0x6419cc41, 
	0xd9fbf227, 0x8d501672, 0xb3070dd6, 0xbead19fb, 0xe73f4ce6, 0xea0a95c8, 
	0x7ec9bbad, 0x178bef0f, 0xcfa9fae1, 0x15e1ef97, 0xf0f7ed44, 0x8587ca62, 
	0x4143eda3, 0xcefe44a4, 0xa21f6da3, 0x6a3eee7c, 0x2e97e8df, 0x5d2d5dfa, 
	0x82dde8b8, 0x0b9e5d06, 0x36537bf0, 0x35d900be, 0x92f71902, 0x2efc6ee1, 
	0xf8b16850, 0xbdc0526b, 0x8ec825ef, 0xc09f7f78, 0xdc1aa8cf, 0xe79dbef8, 
	0x9d9ef976, 0x9e0db3ef, 0x69de952a, 0x77c9d4f3, 0xb2439408, 0x4d1efd1f, 
	0x96d12cf5, 0x8c69885c, 0x27aaa9f6, 0xbf81dc0f, 0x993d5cc3, 0x37eb3ef3, 
	0x1e9f79eb, 0x161d5627, 0x837bca17, 0x1375d2e6, 0x5feafbe9, 0x29bd52f5, 
	0xdf0cebeb, 0xfaac91fa, 0x0907b125, 0x378612de, 0xef8d58cf, 0xc637556f, 
	0x83f7e86e, 0xb307fc3f, 0xa648e36c, 0x335aaebf, 0x7bfecb37, 0xc62dffa8, 
	0xdf889dd6, 0x7e7d18ea, 0x4e69dd58, 0x7e359f59, 0x2d617b7e, 0x9b25dfa0, 
	0xd038af56, 0xfe539baf, 0x7a6df132, 0x2d07c403, 0x77c94eb8, 0x824ddd47, 
	0xdcac09de, 0x48cddf2e, 0xfc6a3bbf, 0x7d51df82, 0x9f3c22f5, 0xf327e5b3, 
	0x0943ddae, 0x7dc9577c, 0xeed77cbd, 0xe3728bf5, 0x433ccf13, 0x8772fd45, 
	0xb5df154d, 0x1d1eb0f3, 0x2f7f88ba, 0x10cd7ea7, 0x5838b988, 0x7c7be42f, 
	0xb8a8576d, 0x912aaede, 0xe60a4bf7, 0xa5dfa1ef, 0x1c3cefae, 0x74a5dfc7, 
	0x8a596c1e, 0xe0f39bfe, 0x3bf05bd7, 0x3dc1d75a, 0xefa054bf, 0x8b3dfc5c, 
	0xf6fe58e5, 0x39c0b8bd, 0xb024d50f, 0xf869ab9d, 0x6e77ac7d, 0x27ca3457, 
	0x48328495, 0x4ff530f9, 0xbeb89b2a, 0x738ff38a, 0xdfb7167e, 0xb91bedc5, 
	0x93d62f7e, 0xfca16dfd, 0xcb5df86b, 0x75c64d3c, 0x1ec7c925, 0xfee7f1c7, 
	0x07f9076c, 0xbbc34d25, 0x98bcce08, 0x3981ef8a, 0xd1365b87, 0x0d06c2ef, 
	0x5ff287b5, 0xe2e11c7f, 0x0efd987a, 0xedf873a4, 0xd25e585d, 0xf7e04914, 
	0x5c4ae026, 0x4b3fd72e, 0x7ee4037d, 0xd20f9f2e, 0x7ed0e9bb, 0xa54f9f26, 
	0xcbd5efef, 0x62987b7b, 0x01bff53c, 0xe4a31aff, 0x00038f41, 0x7dcd9c78, 
	0xd554780d, 0x77b9f099, 0xf9dcccee, 0x0900849f, 0x94424e20, 0xc90ea940, 
	0x9084984c, 0x01a084dc, 0x2b4b46b5, 0x4275ddb6, 0x6b75a02b, 0x5d0db4a4, 
	0x312677ab, 0x809df84c, 0xeba7c13f, 0x62b75c13, 0x6bf44fed, 0xf5bf4835, 
	0xd50d5026, 0x6ee8376f, 0x6eeebba5, 0x3b62d802, 0x6bb2d175, 0xef7eb4a0, 
	0xe7739efb, 0x6be7e12f, 0x9e5fbbbb, 0x9ee78e47, 0xcf79cf73, 0xe7befffb, 
	0xe98c33dc, 0x58c6de92, 0x7e926980, 0x5d163184, 0x8cb3b0a0, 0x662e2c6d, 
	0x99d40f7a, 0x7f819d21, 0x0ff0951d, 0xd8f04ffc, 0x3e095273, 0x7d316a8e, 
	0xad8b632f, 0x877ceb4c, 0x5f33e3b1, 0xefe8338e, 0x2c7b04fc, 0x3f768016, 
	0x338ef5b3, 0x2c7964b6, 0x3cf06bae, 0x6b277b7e, 0x8b7517c3, 0x7e32a0ee, 
	0xdd71875a, 0xc1fbe18c, 0x185792ce, 0x33762f3c, 0xa809cf5b, 0x5597743f, 
	0x3152fa82, 0x1fb989fe, 0x8f084b36, 0x5c71935f, 0x9ee4d416, 0x6d858c95, 
	0x93bcef4c, 0x0eb7dab1, 0xeaa67f50, 0x71b8eed4, 0x3d60914c, 0xb0333b61, 
	0xfb85fabd, 0x0fdfb33a, 0xecb37f7f, 0x056af680, 0x17f6c7e6, 0xf7c21f37, 
	0x8aa3ab1d, 0x14d7f304, 0x424c5219, 0x86393538, 0xb3f838eb, 0xc712b64e, 
	0x8647efe7, 0xf8621e8f, 0xef07c23e, 0xcfdff92f, 0xebe3e0ac, 0x53af9272, 
	0xd07b404e, 0xe2d6b218, 0x32eb573a, 0xfc977183, 0xfd82d4a8, 0xf2d88a6a, 
	0x4273f418, 0x58c13d7f, 0x8ca8eac1, 0x1eac16f3, 0xb059215b, 0x6996480c, 
	0x12c1fef0, 0xb1847e43, 0xfbafe08f, 0x825ac641, 0x633b4200, 0x431650f5, 
	0xa4c3c4b9, 0xca632f58, 0x4e758979, 0xeb8ecc67, 0x6fe99e99, 0xfcf7c3f6, 
	0x31163a50, 0xc22d73a9, 0x0e825cc7, 0xa99fd232, 0x23de86ec, 0x0f6f2708, 
	0x8c3ede76, 0xd60e08f4, 0x19c716b8, 0xfa18bc3b, 0x07b8026c, 0x8cd5f263, 
	0x05eb6ffa, 0x5add07fa, 0xf18a8f5c, 0x07fbfdf0, 0x50a32b97, 0x43d08f6b, 
	0x3d4497c7, 0xe39d750a, 0xf5a71f5f, 0xc396936d, 0xbd3a45fb, 0xe34bd0ef, 
	0xee8e34dd, 0x3b1c7842, 0x031b3725, 0x5f74d8fc, 0x81d128d7, 0x9fee77de, 
	0x405575f0, 0xfb9438f9, 0xe83c3ca1, 0x79a15a53, 0x7cef8f90, 0xced8ea01, 
	0xde229f0c, 0xb29d69c3, 0x3a89fbc1, 0xe10bb5f0, 0xdd6e1e28, 0x5ddd7486, 
	0xfb2085fd, 0x46bbe40f, 0xebd61057, 0x6148f978, 0x46f4e650, 0x4ef8273e, 
	0x82bbbf61, 0xdf082bec, 0xdd418b90, 0x321462d1, 0xfc816768, 0xf1a25f7e, 
	0x5d1b3b1c, 0xbf56436c, 0x9257e862, 0xa2cbefdd, 0x5e3b949f, 0x0ebf7e45, 
	0xce675e73, 0x7efcc178, 0x62fd10df, 0x7c82f339, 0x6ac77c13, 0x5d9d7c62, 
	0xef86716d, 0x8d3730b5, 0xf11598c3, 0x38635cee, 0x4f08c6ba, 0xffc063d6, 
	0xd4369f2e, 0x65f09c79, 0x0c107d25, 0xb0fd47cf, 0x5c0599ff, 0x32bf043f, 
	0xaece6d9f, 0xfeaf30ff, 0x9dfd391f, 0x82fd234c, 0xd074e5a8, 0xf463d795, 
	0x5493b63f, 0x9414b6ea, 0x20a662d1, 0xb0a9de7d, 0x5895d55b, 0xa9556f5e, 
	0x3feac5be, 0x56abe582, 0xf29fc03f, 0x9faeb16b, 0x3ff0b1f2, 0x8153ef93, 
	0x036fd324, 0xd82657a8, 0x34fe7888, 0xffd0673e, 0x2efe62d3, 0xfc8c9f5a, 
	0x3ca0f387, 0x83ed73bf, 0xb75862d6, 0xfe154583, 0xca2b55fc, 0x4f3b1fc1, 
	0x7a29aa81, 0x471f8ff2, 0x7bc58d95, 0x074f0826, 0xc5859a1e, 0xaba79272, 
	0x0035a083, 0x97d2dafe, 0x23f3fe89, 0x5bea3243, 0xb2a67f87, 0xace89c65, 
	0x9f5e7d62, 0x9f01d161, 0xfa60d929, 0x55fac1bf, 0x19aeb4db, 0x7ca6fd8c, 
	0xcfdec838, 0x91ea63c0, 0x1cbe5713, 0x9c3f8157, 0x44d6d8ab, 0x0baf633f, 
	0x1efd823d, 0x3a8e7e83, 0x42158e5d, 0xc9e8117b, 0xe1cfa102, 0x6fd0a3bd, 
	0x271869f6, 0xcd0879b8, 0xcbb64b01, 0xdac576d9, 0x039a4070, 0x7b5c4808, 
	0x760de694, 0x8024c78d, 0xc05c96cf, 0xc96dee50, 0xda58fcfb, 0xd2dd05f5, 
	0x040fd600, 0xf7eb1458, 0xbef54a3d, 0x3f6f20f1, 0x88292df0, 0xd48d05f5, 
	0x817f189e, 0x0b77dfb7, 0x95782faf, 0xa3681fb7, 0xdefb89fe, 0xf8ff7aa2, 
	0xc0fdbc7d, 0xa9bfb02f, 0x0bfd6c87, 0xff7f34e2, 0x7fa9bb7d, 0x6c43fc72, 
	0x8e291167, 0x3feb61f2, 0x67be24f0, 0x3cfe3fdb, 0xff6d97ca, 0xb7284382, 
	0x37b681b6, 0xccf03ea9, 0xff7f5e09, 0xe9acbc37, 0x3b39f096, 0xceb0921e, 
	0xbaa0ae16, 0xbc53f6ba, 0xf89df6fc, 0xf31459dc, 0xee499bc9, 0x98f50554, 
	0x161baccd, 0x3e1bb7aa, 0x5bb52cf9, 0x6b67d414, 0x6321bacd, 0xf07ea6dd, 
	0xb1671c15, 0x06ee359d, 0xaec090fe, 0xb62d8323, 0x77772bea, 0xf695ea64, 
	0x33648afe, 0x744a5563, 0x60edeeeb, 0x187eb0bf, 0x3e8d6fd6, 0x95ea07b5, 
	0xb5b5d656, 0xc8ebf883, 0xe32a62ae, 0xbaf65fc8, 0xf012e5fe, 0x169cf38d, 
	0x7a15af8f, 0x8d28e81a, 0x76c313be, 0xc48a6816, 0x603cff80, 0x674e0a27, 
	0x71c997f8, 0x08eb0297, 0xac4ec086, 0x733cf287, 0x1d9980c5, 0xc471adb5, 
	0x237cf063, 0x9897efaf, 0xe10baf58, 0xa86dc6bc, 0xae4e77a8, 0x04b1752f, 
	0x47eaa1c9, 0xa90e8ff9, 0x0be9336a, 0xfb0da257, 0x661bfd81, 0xb9e7e3ec, 
	0x0274e11f, 0x68b8d0bc, 0x7e0ae4bf, 0xc90eca1e, 0xf009dc55, 0xa4311997, 
	0xc02a35ef, 0x179e05bd, 0xc7827a37, 0x15721cb1, 0xa6cafcc3, 0x3da5cbfd, 
	0x630d4708, 0x6a3a3768, 0xaca71268, 0x0adb76fe, 0xfbfeb75c, 0x6e300f3d, 
	0xfcf472bf, 0xfe9316c7, 0xe6a4b9fe, 0x7649e5e8, 0x0dfa2823, 0x376e2ef9, 
	0xa35fa2c2, 0xa376e2ef, 0x77d79cd6, 0x60d1bb71, 0xb8bdebce, 0xb73df8dd, 
	0xe58f3f43, 0xc14f0bcc, 0x079da396, 0x383f02bc, 0x0b96c537, 0x5f21743e, 
	0xb9c2fa9a, 0xa86e7cce, 0xf6d58fc8, 0x2344c2e8, 0x5199be63, 0xb52b1f24, 
	0x7e7b598e, 0xd1fff80c, 0xf88f3cb8, 0x344caf50, 0x6da8f3e1, 0xd1f91b9b, 
	0xeef828d8, 0xa87deddd, 0xdef180e7, 0xa766be41, 0x57d072a5, 0x93b88c8b, 
	0x629267c6, 0x45aaec63, 0xf00724fb, 0x7f1f55c3, 0x7c01d1a6, 0x9df02779, 
	0x56cef81f, 0x4efa4251, 0xfdd3a505, 0x1533d043, 0x27c0fac0, 0x6502c56a, 
	0x12b3c80b, 0xed8624d0, 0x5bdda515, 0xdf581f80, 0x5ea36657, 0xd2f424da, 
	0x80e7e8bd, 0x24be5b9f, 0x1baea732, 0x707ebfde, 0xb3e61076, 0xf4329457, 
	0xc488944f, 0x8a50c3ba, 0x0b15ecf1, 0x1fa0dde2, 0x1cd203ca, 0xc0b9479c, 
	0xc186b6b8, 0x9c3675d9, 0xbc46cd9f, 0x7db4b57e, 0xf23dea31, 0x1db9c7bb, 
	0xfaccbd44, 0x4fda0ac3, 0xfc163df3, 0x6acbd932, 0xfc72c7cb, 0x18c3e071, 
	0x1085efd2, 0xd98cbf23, 0x304b0f4e, 0x53166b8e, 0x6c87006d, 0x035cb31f, 
	0x52f25e78, 0xf7ae08ef, 0x87e1269a, 0x8db054bf, 0xff1a5ef5, 0x8d671fa5, 
	0x24344fdc, 0xc6e627e1, 0xd431aa09, 0x11f5c6db, 0xc53f4bd6, 0x971e83fb, 
	0xf84f0fc8, 0xc55f1d68, 0xe07d6075, 0xc5475a06, 0x3ad1168f, 0xb77d1eaa, 
	0xef800af1, 0xbf0e2ade, 0x36327966, 0xd557050b, 0x13eff225, 0x0823beb0, 
	0x9bcff717, 0x6f687e10, 0x80ded6f4, 0xd16368fe, 0xc80896f1, 0x4f15d36d, 
	0xbe5042ba, 0x01537406, 0x73be8d31, 0xcb0f11cb, 0x312d1867, 0x61673fe0, 
	0x5357ad09, 0x7f407eb8, 0x27159637, 0x56c53f20, 0x7e03b7a2, 0x8e9674fc, 
	0xddeb340f, 0x18681f14, 0x9573e05f, 0x075eb849, 0xb7e0e9fa, 0x4c57186a, 
	0x7025e3e7, 0x57fbf41c, 0x4141e466, 0xf08f7f7f, 0xbdf18bef, 0x9e7d2480, 
	0xff416fde, 0x8c7ab1de, 0x0a6bfbfc, 0xcb39744b, 0x8075a75f, 0x6504bdbc, 
	0xcfb3f005, 0xe0157603, 0x0f7fa077, 0x013cc071, 0xfb1fd9a7, 0xefe69f15, 
	0x16565da1, 0xeff51769, 0x41eff415, 0xf1b35def, 0xcad78a16, 0xfa328d3c, 
	0x546fbebb, 0x9b7886bc, 0x63f01d37, 0x4f7fb4b0, 0xd17d46f4, 0x9e873d37, 
	0x33be4d6b, 0xeee7a5ee, 0xfe71679b, 0x30b8f24c, 0xd222e228, 0x1bd4091b, 
	0xb01c7807, 0xe9fb86a1, 0x98bd44eb, 0xc50fd9eb, 0xef8883ba, 0x0ebf8847, 
	0x90b970f5, 0xbe484793, 0xafffa85c, 0xfd9468aa, 0xa213e780, 0x7fc44fbf, 
	0x327daec1, 0x2f0855c6, 0x37e605da, 0x597ae10e, 0x944b168b, 0x9f88fef0, 
	0x5f49dc34, 0xadf59cae, 0x19dafaa7, 0x8a0f5465, 0x03ac4f71, 0x6a5f13fc, 
	0x81d718c3, 0x7184dcdf, 0xf447ea25, 0xc05dff3f, 0x97fabbb1, 0x3e933ca6, 
	0xbc3d7e3f, 0x7fdefe07, 0xea627d0a, 0xeeaf5359, 0x3160feae, 0xbcd0e9f9, 
	0x7a59d7e5, 0x6cbd7199, 0xbdf93fbe, 0x4a9e690f, 0x887e07c1, 0x7f305dcb, 
	0x5bc397a5, 0x83f7c3f6, 0x22ca1fac, 0xba38c55d, 0xed45b52c, 0x5b28f905, 
	0x82763461, 0xf829569f, 0x7c1fe4d9, 0x12c7e11f, 0xce4933f1, 0xe2e517db, 
	0xe09fe849, 0x8c54af40, 0x00791178, 0x7c9135a6, 0x94b1bdbf, 0x3e9e7bcb, 
	0xa2a9eb4a, 0xbc1d7889, 0x0aea0b67, 0xd62427ae, 0xfbd6fa11, 0x18bd8296, 
	0x2737f78f, 0x8eae3186, 0x7a0eda2e, 0x876152a9, 0xf77f72b6, 0x064958b9, 
	0x67abbbbf, 0xf2fe1255, 0xe22ee3f0, 0xb47427fe, 0xb0f8e0f4, 0x87c8072e, 
	0xaca5f85b, 0x64979e18, 0xe4245f3d, 0x308f6ccb, 0x932573cb, 0x9858f5e7, 
	0xe9ce9f11, 0xacbe4493, 0x72567180, 0xe310287e, 0x54583e71, 0x059cbec9, 
	0xd718b94f, 0x1ccf079f, 0xe79f38c6, 0xfd13af3d, 0x4ace1c83, 0xabbb87e1, 
	0x4fc99d38, 0x745c3b45, 0xaab3c780, 0xa89b2790, 0xb8388877, 0xbfc7827d, 
	0xee1c781b, 0x6bea2b5c, 0xbd6afd78, 0xc31f12d3, 0x232adbff, 0x0683e75d, 
	0x89cfb8c6, 0xc62942f1, 0x7e13d711, 0x5b4efbcb, 0xdb793ed0, 0x9e17c519, 
	0x166426db, 0x5a1f8acf, 0x3d75a70a, 0xaac3f18a, 0x54df764a, 0x1483c3f1, 
	0xe56e383f, 0xcaeac3f1, 0x59c1f8dc, 0xe0fc51a7, 0x7e29d228, 0xdc3a0a70, 
	0x4366fd0e, 0xc77b7b3f, 0x1ca00050, 0x6239720d, 0xd9caf71d, 0x77bd68fc, 
	0xe22f0c10, 0x6c21e785, 0x6914ca1b, 0x8bbbcb0c, 0xdd4e1fd0, 0xe50c791a, 
	0x5fe791c1, 0x6bfcf23b, 0xed7f9e47, 0x37aff7c8, 0xe38e5f3c, 0x18d768dd, 
	0xfa3731fa, 0x1e0efaa2, 0x3f208eb7, 0xde8b64de, 0x4df47e82, 0x47c6e8d6, 
	0x21370d60, 0xba7b70ff, 0xf104bbaf, 0x33fa18ca, 0x8411ef40, 0xac2f46fb, 
	0x5ded8a3b, 0x8bca00f2, 0x8df72dde, 0x123673e3, 0x157f30d3, 0x1c7f9195, 
	0xb59bb1b7, 0x8cfe34c3, 0xf8d3b647, 0x8e05726a, 0xb2ec751f, 0x8c3fe14e, 
	0xdd79242d, 0x2e6cf578, 0x78078987, 0xc2528efd, 0x47d08757, 0x69847ef9, 
	0x3f72d227, 0x079e31f6, 0x42d38f4c, 0xab2474e3, 0x6bf29c69, 0xdac05c6b, 
	0x8c1a7d69, 0x805e5b7e, 0x7d72b4c3, 0x99c2cef0, 0xec3bf456, 0xf41ba8f0, 
	0x11e44052, 0xa42cb0ec, 0xdf149407, 0x87219439, 0xe053fe0c, 0x2fffa04a, 
	0x058079e8, 0xa8da7ac4, 0x2784641e, 0x5001f283, 0xadf118d7, 0x56f51566, 
	0xfaf3aede, 0xdbca395a, 0xd867ca0d, 0x643daeef, 0xc6ddba83, 0x7ca29fba, 
	0x61fab31e, 0x0d47c61d, 0x1c7b0eb4, 0xafea4b42, 0x81dd70db, 0xf7270025, 
	0xaf946c7b, 0xf939a250, 0xe12f330a, 0x9045ac38, 0xb947df4e, 0xa7f508df, 
	0xd7d441b4, 0x30e7b8e9, 0x5fc42bf3, 0x7df846cc, 0xdc2bf74a, 0x17eab57f, 
	0x31f45bcd, 0xd0782dfd, 0x0bf5cf02, 0x426e01e7, 0xe3fa09bd, 0xa0ffd40d, 
	0x75f30237, 0x38e1e799, 0x1679981f, 0x02cf8c45, 0x19bf8a49, 0x0bf70ef0, 
	0xf88c650c, 0x929db357, 0xc4db7ac4, 0xd20f28fa, 0x618a2d60, 0x0e75b2f9, 
	0x5f81d3f6, 0xeb77062f, 0x01b76320, 0x45ea2d7c, 0x35b876e1, 0xe44db3b9, 
	0xd399e043, 0x6f11c7ab, 0x0a3ac0af, 0x486e49da, 0x8efa9a2f, 0x36297999, 
	0x42979394, 0x75a69efa, 0x1c27f368, 0xe782fe19, 0x3c90fff3, 0xe6575253, 
	0x37a99e63, 0x9d5f3cd1, 0xd494ef22, 0xde63e6bb, 0x787137a9, 0x4fedbfbe, 
	0x5c0a879f, 0xcef50f20, 0x41ade78b, 0xaf63cf58, 0xe23f3fde, 0xf6a5e4c8, 
	0xff9e1c8e, 0xc14bcb27, 0x0a93bb78, 0x69e7b78d, 0x7be60798, 0xbf8c3f64, 
	0xdf1f8ff7, 0xdd92e7cc, 0xede3f96a, 0x2db79996, 0xd0ba9775, 0x4a39f30f, 
	0x8f60955d, 0xde95a72a, 0x65407180, 0x42db33e1, 0x64f229f1, 0x2797969a, 
	0x78c2af2b, 0x64f3b2f7, 0x279112c1, 0xb5355f9b, 0x93cdcb9d, 0xf1e2ae2d, 
	0x64f2a5e8, 0x9e6655d5, 0x8070c0ec, 0xf539d965, 0xff5b395e, 0xccbe453a, 
	0x80b153cc, 0xcf392714, 0x2a5d0bcf, 0xd767948f, 0xfe86ef28, 0xcd1c6c8d, 
	0xad791bce, 0x2798ddda, 0xd7d1c8f2, 0xbd58051f, 0xfbd28096, 0x163e7c63, 
	0xdf7e004f, 0xc55959ac, 0x6fef037e, 0xbe291fe8, 0xe0f3799c, 0xdf718e5c, 
	0x31e19307, 0xbdbd90ed, 0x75825ba2, 0xadbbacee, 0xa710fd0a, 0xe637f10e, 
	0x0b755ac9, 0x7ed3ade6, 0x7eb91fd0, 0xa619e60f, 0x7fb8fae3, 0xe8fe15e7, 
	0xa7ee2aba, 0x2aa6e598, 0xf699dfee, 0xb409bbd6, 0x476211e7, 0x4c9b33d2, 
	0x0d66b93b, 0x17ff49d9, 0xdb07aa64, 0xe27f93f7, 0x23112fb9, 0x59a2397f, 
	0x4bcb11fe, 0x130dc7f9, 0xfc652a92, 0x03e01f1a, 0x3c8e0af3, 0xc9e471f9, 
	0x7e4f238f, 0x93f2791c, 0xb541172f, 0xa1837e5f, 0x9e13743c, 0x85c63e49, 
	0xeb65881f, 0x9b41e405, 0x9ebefc23, 0xc6f3a9aa, 0x9edf7eb9, 0xfbf3cbaa, 
	0xdf84aafa, 0xc70f2f97, 0x5f7ee26e, 0x8dac3cbe, 0xf341f6c5, 0x1b3f6de2, 
	0x963f9462, 0x06cb7f28, 0xa08f899a, 0xb5f29bbe, 0xca49e949, 0xca2526c7, 
	0xc8b5fedb, 0x587d403b, 0x9f037f3c, 0x0946aa3f, 0xfb5c8f1f, 0x24f9c914, 
	0xf2c4623d, 0x4877c8f4, 0xda7e108f, 0x9256f0f2, 0x2bf6af85, 0xfef8fe84, 
	0x038fe965, 0xfe3fa997, 0x63fa42f6, 0xf12996e2, 0xeb9d3955, 0x9e47ca8f, 
	0xfb9f2891, 0x41e42e80, 0x3881f927, 0x3bf711b7, 0xca1ac96d, 0xebb73acf, 
	0x42987e42, 0x94c1b5f2, 0xe4f2461f, 0x55fdf1f5, 0x6edb5f5b, 0x9f9cdbf4, 
	0x5d7f4431, 0x171076c6, 0xe3079bca, 0x9f708747, 0x47212ded, 0x60cdfc93, 
	0xaf0d9291, 0x43465fe9, 0xed953d7c, 0xbfc89bfb, 0xaafee76c, 0x719ac719, 
	0xb7cf8999, 0x45fede05, 0x6dd05bf0, 0xfca20e58, 0xb443b4b9, 0xe51ae9ee, 
	0x7c44aa23, 0xc49e44cf, 0x23ec5db1, 0x1e6e42ea, 0xece5f418, 0x72106e63, 
	0x1d31f624, 0xfde0999f, 0x26bec55b, 0xa0f3b9d8, 0x6fb60b17, 0xf1fda170, 
	0x8fb4abb7, 0xdd2aefe8, 0x0b5a08b6, 0xf89f7dae, 0x07b2f904, 0xcd8313f3, 
	0x35e52f72, 0x2fe7e462, 0xcc6e75c2, 0xd0ccfdf8, 0x767cb92c, 0x3ccf8736, 
	0x6e5867c8, 0x63b3e3c8, 0x3b3e0a57, 0x667c597f, 0x9f1e5d0b, 0xb21742b9, 
	0xd9c9f753, 0xb3e4cffa, 0xc79fa8c5, 0x99e4ff70, 0xcee3d472, 0xf67c073f, 
	0xaecbf867, 0x8d38a62f, 0x7f7c4ab5, 0x445cdf41, 0x73d1eefd, 0x7985cbf8, 
	0x101f3c36, 0xbe618def, 0xf1f6f16a, 0x85e44921, 0xa42f2212, 0xfa10bc8a, 
	0x3d62656b, 0xbc5e9ea6, 0x7c8c9f7d, 0x9b11f26e, 0xd7d5caa8, 0x47804fc8, 
	0x94831dd7, 0x4f71c1d7, 0x493d39c7, 0xd602f59e, 0xbf71f34d, 0xdf3773c3, 
	0xa9dcf62f, 0xb87f70b9, 0x858fdae0, 0xb6ae2e90, 0xea12ab80, 0xca0db7e5, 
	0x7fa1748b, 0x7c8f504a, 0x4874843c, 0x5fc98a05, 0x7cfafd32, 0x51aaa2bd, 
	0xa4754fcb, 0xcf1a12f3, 0x7439c3d4, 0x8f0f4a9e, 0xd77a0a34, 0xff672e86, 
	0xe932f9ae, 0xf482f2bd, 0xcaf495be, 0x3d7f1157, 0xf44de993, 0x5e853239, 
	0xcce93169, 0xa54ceee9, 0x62fd8af5, 0xa2f8857a, 0x82bd0a7f, 0x9171c179, 
	0x36f98417, 0x33ed7284, 0xe7d903f2, 0x98af5c53, 0xdf6e2ef0, 0x33d02f2f, 
	0xfe8d847a, 0x5c57b519, 0x7994cd79, 0x9b1ed32b, 0xcdd179f6, 0x73da0a83, 
	0x7e46ab67, 0xa05e2f88, 0xfd0a77cb, 0x683c4312, 0xf42f0784, 0xf01275d9, 
	0x657a1299, 0x8af4f2ec, 0xe9269769, 0xb54fc117, 0x290b5fb5, 0x3ca51740, 
	0x3bda55b0, 0x4cfc8f99, 0xf893ff93, 0x023e2748, 0x747c443b, 0xdfd6ff49, 
	0x33a8f82c, 0x637a3974, 0xd1f265c7, 0x51f10bee, 0x37a453e0, 0x86f4f23a, 
	0x8e5cb5d2, 0x2cedfc41, 0x5e053e67, 0x94c97470, 0xe7cdb7ff, 0x7ce41675, 
	0x67e7b954, 0xfaaa4f64, 0xf90f287a, 0xfc1fd234, 0x9e27aac9, 0xaa5e218b, 
	0x1c406f50, 0x2fdd5ce9, 0xd9e6bc61, 0x24e258cf, 0x3e7e0fe7, 0x5f3090c7, 
	0x1be0b4ff, 0xb254cea6, 0x725571e1, 0x03c8b03a, 0xb5f8bcf4, 0x332e7a22, 
	0xcc0cf1ad, 0x6a67b9e7, 0x97fc9bfc, 0x3c0d9fe6, 0xee6ed28f, 0x4ebf2483, 
	0xce1f73f5, 0xae54f910, 0x8eef89e7, 0xfcadf864, 0xf88298da, 0xbbc16ab8, 
	0xc1561784, 0x81032af3, 0x53ce4917, 0xc85c46cd, 0x6774a497, 0x7dcc9ff6, 
	0xda97da2a, 0xb2896580, 0xaf285de5, 0x7e8d989f, 0xcba82dba, 0x00b60fc8, 
	0x3f80cbcf, 0x26fc9b3d, 0x628acfdc, 0x05bdda59, 0xd4c37bde, 0xce2f8997, 
	0xe130f946, 0xfef905b7, 0xc8682d95, 0x34d9f3d9, 0x9b6eeb3f, 0x8e661fbc, 
	0xce635aeb, 0x4d8fe303, 0x64436e31, 0x7db7ee36, 0x5a4df4b5, 0x2451559f, 
	0x12ebcf1e, 0x5d0529e2, 0x29d29ff5, 0x5b071220, 0x72d958a0, 0x7585b817, 
	0x43f21cff, 0xed52921c, 0x45072ed4, 0x3e04989c, 0xd1217d27, 0x1fb156f8, 
	0x3c93fb81, 0x94a9a1ff, 0xaced110f, 0xbf68258f, 0xbd12c921, 0xc6bfb12b, 
	0x40a6cf30, 0x971e07b9, 0x49546caa, 0xee949951, 0xc297ec61, 0x56fd835e, 
	0x5fb21f11, 0x201e72a7, 0x952ef6d9, 0x98f00d86, 0xfa674eba, 0xe80b301d, 
	0x7c002efd, 0xefd30cd9, 0xff443cd0, 0xe1c3dd62, 0x607e0870, 0xea87e41e, 
	0xd90a0553, 0x63f730b9, 0x23cdec1a, 0xd86a9798, 0xc58be8d2, 0x7c717db1, 
	0xe7adf806, 0x026f3c43, 0xbf3047cf, 0xdd32ad5f, 0x61aa700b, 0x8978058c, 
	0xc5d65c74, 0x53bd87cf, 0xbda0f761, 0xe8dd3fac, 0xecb97b41, 0x02dfbe6a, 
	0xbc3731ef, 0xf7f1ad57, 0x0a9ef0ed, 0x1aecbb72, 0xcf9967ee, 0xaf9c3c71, 
	0xc02a031a, 0x2106ca43, 0x01b5da24, 0xbea48f1e, 0xb0541357, 0x75f7cfde, 
	0x83a35530, 0xb5bca51c, 0xe884f9fc, 0xefde9fd7, 0x442d9557, 0x9bf51567, 
	0x5c32ceb9, 0x53f4297f, 0xf985d60c, 0x6f78bf30, 0xf74f7cd0, 0xe3a87628, 
	0x376e01b9, 0xaa4e383c, 0x6eebaccf, 0xfba717aa, 0x597fd8ab, 0x5547fede, 
	0xd5ffcb98, 0x1acfae61, 0xf1ecda3f, 0x633e2277, 0xc0376c6a, 0xdead25d1, 
	0xb7b8f3c3, 0xde1c7d6f, 0xa5f7c59f, 0x17a47e71, 0xc42ee9d1, 0x8d99c003, 
	0xb8ceb307, 0xf43c47bd, 0x3cfc9a6d, 0xf486debf, 0x5c79e932, 0xc57e01c0, 
	0xed3e7872, 0x46fe0674, 0x82a3c9b5, 0x2b9c353c, 0x447481d8, 0x097da27e, 
	0x5fb8cd50, 0x56316c06, 0x9d664f70, 0xcc6909a1, 0x0f532a71, 0x30f7e8b3, 
	0xa3921d5f, 0x03bddf3f, 0x9f432dca, 0xb1eb8c7b, 0x629d6867, 0x3df3641e, 
	0x2866017f, 0x9475cfcc, 0x487df175, 0x7698cf18, 0xf3364a8a, 0x7c8ede5d, 
	0xed79021a, 0xd7f035fc, 0xdc791fb5, 0x079e979d, 0xfd79efe8, 0x1f30fd22, 
	0xef8133a1, 0xabfe0c92, 0x13f8fe4d, 0xa1597de1, 0x60fbd09e, 0xcd11b27d, 
	0xa6586f3e, 0x506dd5e4, 0x03aacd6f, 0xe1da72c9, 0x8673ecfd, 0xdd767ef8, 
	0x271c0794, 0x8e227cfb, 0xd26fdd93, 0x00f6ff3a, 0x0ce47253, 0xcae56fea, 
	0x09f3ad19, 0x9fc93cf1, 0x9979aea7, 0x40d157bf, 0x5f3af4f5, 0x12e1cb3a, 
	0xe77d95e3, 0x4f27872c, 0x109ecb6e, 0x6578c4fd, 0x4e1c0d15, 0x197d5e31, 
	0xf81eb78c, 0xfbbffe10, 0xafdfa82a, 0x977ed0fb, 0xa1357b9d, 0x6faa9e83, 
	0xf3f7fbe6, 0x20487fe4, 0xfb9de79e, 0x720e84b7, 0x37ab30d5, 0xdfc5df20, 
	0x7416f923, 0x96953868, 0x6bca1f67, 0x3cb4b1c3, 0xff5eb17b, 0x03af59e1, 
	0xe50860f8, 0x186be016, 0x3e93b74c, 0x239f4868, 0xe680fae2, 0x61fd7e07, 
	0xea15e798, 0xfebd79cb, 0x639f1ac3, 0x91c71f2f, 0x66bbfcf5, 0xdfb322bf, 
	0xfd395de6, 0xbeffcf32, 0x012f3c44, 0xa777a8b9, 0xdd9cdf9f, 0x9e42e7ff, 
	0x1fdc43eb, 0x99777982, 0x9f723bf0, 0x1b497dff, 0x3e2f3795, 0x9f17dbc2, 
	0xffbd25e6, 0x01dfb305, 0xe23c0e6f, 0xb984bff9, 0xdabf559f, 0x677677ec, 
	0xf3ccbf4e, 0xa7192bbf, 0x578b13f2, 0x47a9e666, 0x6b7e0779, 0xfdd03b00, 
	0xfc9d8c37, 0xe30f9f70, 0x38d3a27f, 0xf386a5d2, 0x97e718d1, 0x3ea26386, 
	0x3e4bebca, 0x7fc3ba38, 0x07cbec02, 0x00f0bbbd, 0xca67a990, 0xfa8df9c4, 
	0x50ee8e97, 0x86f3cce5, 0x7e1c9ac1, 0x7e4b7e46, 0xc9abf480, 0x2fd4ebe1, 
	0xf89e7ecf, 0x7a9bcc52, 0x3347d45b, 0xf97d91ef, 0xc59e785b, 0x35fda9cf, 
	0x18baa05f, 0x49937ea7, 0x733b039f, 0xfe799ff0, 0x5f020589, 0xf71f100b, 
	0x77fdf1a7, 0x7a2478d9, 0xf674407c, 0x5657ffa1, 0xd804fe08, 0x234e79fc, 
	0xe73be781, 0xa1f5e9cd, 0xc3e6656f, 0x19ff09e7, 0x273c18fd, 0x3013e742, 
	0x8dec2d4e, 0x35afa4a9, 0xfd69d60b, 0x4bb687e8, 0xfe548f14, 0x07f71a7a, 
	0x7f27effa, 0xc2543eb1, 0x637f14fd, 0xb4bfc72c, 0x9cf1c58e, 0x7ce040cf, 
	0x797dfd18, 0xf30584e6, 0x499fe086, 0x30049f18, 0x0d74023f, 0x4d7d8214, 
	0x9d4ebcc0, 0xedb32ce0, 0x84dc78a3, 0x9964e033, 0xc65815e7, 0x1902337c, 
	0x9d7c217a, 0xa4bf789b, 0x7c7bdb1f, 0xe8b22a33, 0x29dcf38c, 0xc2c891f0, 
	0x79dc8cc7, 0xf102fe68, 0xa9cb02bc, 0xc97ec1e7, 0xf3e76c5e, 0xd716be60, 
	0xe6ee74dd, 0xea987d5e, 0x2bdb8a3e, 0x373c150a, 0xd213f69a, 0xefba04fb, 
	0x33fa058c, 0x1757576d, 0x9ea687fa, 0x0bf26430, 0x4f5330d6, 0x0291ff90, 
	0x9ed39f1b, 0x2df34f57, 0x86cb0c93, 0x48a7dd4c, 0x3eea190e, 0xaa5f9fb1, 
	0x5748c90e, 0x67b92c97, 0x9bf5678c, 0xf5c0e5c3, 0x0fd95199, 0x57082c74, 
	0xccbd2355, 0x7d8ff076, 0x1ac35ef8, 0x0db332bf, 0x0ec779d7, 0x59f92d7d, 
	0x669b57a4, 0x7f56fc73, 0x1f71e41b, 0x37ad9e7f, 0xebd3fbab, 0xac1ea373, 
	0xb4eba64e, 0xa9bf6abe, 0x83f23517, 0xddba59aa, 0x79a6f582, 0xc6303c86, 
	0x7f9440fd, 0x1f11a157, 0x2eaff900, 0xbfe49c7c, 0x6bc85fba, 0xeaaf971f, 
	0xf38ba8a4, 0x80069f3b, 0x3ce1378a, 0x7e457e42, 0x7e899aba, 0x7aed3f22, 
	0x3119d852, 0x5161eb8e, 0x66b8e317, 0xdf78ba88, 0xa8da6ac5, 0x426fde2e, 
	0xb3fe48bb, 0x687946ee, 0xee013842, 0x6c0f934a, 0xf69baec2, 0xe76b96cf, 
	0x9e708cbf, 0xe03fb4b9, 0xbced7392, 0xdbabc94b, 0x1702fd72, 0xedd901fa, 
	0xc77dae72, 0xb6ea73f7, 0xdf00bf5c, 0xd7376ecf, 0xa9a3d269, 0xbd13e80c, 
	0xeaf3fd08, 0xa9703fa6, 0xd467487e, 0xebd5ff5f, 0xa5f4f535, 0x2d837dd6, 
	0x39e11f13, 0xefd2353d, 0xd558f8a5, 0x8b9e743c, 0x8fd45e19, 0xafef8c85, 
	0x4859aed4, 0x35d2d271, 0xc43a83c7, 0xcfdc379d, 0xff76ace5, 0x00520bf8, 
	0x804d45ed, 0x8bd851f8, 0xf5a35b94, 0xff5f124b, 0x76a7ca0d, 0x56b85e60, 
	0xf116b9e0, 0x6a6cfe0b, 0x43e42cb5, 0xd07d242b, 0x4af19b2c, 0xe71dc501, 
	0x8f8571d3, 0x796953da, 0xb6bd62f2, 0x7df396b5, 0xbae12d4b, 0x72e5ab56, 
	0xdb4da911, 0xed4fa42d, 0xd3979084, 0x4d6b5f9c, 0xd78c7b3b, 0xe207b86f, 
	0xe1b7d044, 0xd2076d42, 0x39eb7c29, 0x6e313f8e, 0xc71cf9b8, 0x88b8d673, 
	0x85eff0e7, 0x0dc626df, 0x7ee1aa9f, 0x36b7189b, 0x4f330f1d, 0xd04ee28c, 
	0xe66784cb, 0x56b7f8c1, 0x9c74f3e8, 0xb93d5a0a, 0x289e2b37, 0x765aa7da, 
	0x71a95e63, 0xccec1247, 0x3edcd56b, 0x183223fe, 0xbc08e194, 0x18738107, 
	0x87bb6ac8, 0x412658c2, 0xd956111c, 0x64710480, 0x4dc458b8, 0x17eb11df, 
	0xa1f388fc, 0x56642bbd, 0xd1e17fb2, 0x73c0bf7d, 0x35fb93f2, 0x660f907a, 
	0xfd808460, 0x1ca66b8a, 0xe937e52f, 0x987f91a2, 0xf57343b6, 0x65cbc604, 
	0x07ea9285, 0xe6aa9f7a, 0x66caafe7, 0x4c79d0d5, 0x78c34fac, 0xd5bf6326, 
	0xdf8e12de, 0x2bf7e85e, 0x8169e75c, 0x05c73c47, 0xe39e3ff1, 0xd39ef6c2, 
	0xd2248f68, 0xcdf03327, 0x07b1f138, 0x02d537f3, 0xe07eeace, 0xe19353cf, 
	0x0f20fd4b, 0xd271bcfe, 0xe4915bf1, 0xccaafdc6, 0xcdfe22fb, 0x3dd4efe3, 
	0x69b2df26, 0xb339fed4, 0xbebe73ae, 0x5673e4d1, 0x99d7f348, 0xeb1f9aed, 
	0x7c6d6eb5, 0xcbc021eb, 0x0838288c, 0x9012af30, 0x750abcf7, 0x4bb5deaf, 
	0x271bf5c5, 0x6dabfe44, 0xd7b06cdb, 0xf983cc65, 0xa790b0cf, 0xc3f3f0b0, 
	0x47ff041b, 0x11aedf05, 0x6f5156f5, 0x71a2f211, 0x44470e3e, 0xf3ebcabb, 
	0xfd6f6966, 0x2f871e2f, 0xa8d879c6, 0x0664f883, 0x0fcc01ea, 0x7004749d, 
	0xefe8f5dd, 0x0bce4f75, 0xcf0f7498, 0x5f981235, 0x525b7d08, 0x7d0cbed9, 
	0x2dd7dfd3, 0x2c0f79e1, 0x8b1fd05b, 0x2b3e27ec, 0x7426fa12, 0x87424b6e, 
	0xb53a5cb8, 0x1bce077a, 0x73a76f3a, 0xe07ed5c5, 0xd0537de7, 0xf442ddcf, 
	0x7a11e933, 0xfb813c6a, 0x1fd617ed, 0xbd49ee3c, 0xa4f71b9d, 0xe71b947e, 
	0x46f4f384, 0x0f3fcf38, 0xe1e7f9e7, 0x753b7f3c, 0xd99decee, 0x829521fa, 
	0xbd9f967a, 0x47efd60a, 0xa2aff93b, 0x073fa99f, 0xfb65d66b, 0x366fa4d9, 
	0xf1507e92, 0x8be9107c, 0xd66f9212, 0x0895720d, 0xfd04bcdf, 0xcf3f709c, 
	0xc7f7862b, 0xce97e87c, 0x6477f9b3, 0xb9bcc9f3, 0x3f08fe3c, 0x7a52fc09, 
	0xb7597e69, 0x4bf1db84, 0xc075cdf2, 0x8687e08f, 0xcfe9190a, 0x7f42ddd0, 
	0x9f43718a, 0x6e317513, 0x2ea213e8, 0x6a450bc6, 0xe314deb9, 0x1c037a99, 
	0x7f9d0f79, 0x9e9e662f, 0x9bbd1923, 0xed4f8fd6, 0x59cba553, 0xc7b5cb27, 
	0xe66df5f9, 0x6fd12f3a, 0xecf33ad2, 0x9ecf2879, 0x79ecf287, 0x879ecf28, 
	0x2879ecf2, 0xf2879ecf, 0xcf2878ec, 0x2308b38e, 0xbd5dd83e, 0x2b9e096b, 
	0xa62f1508, 0x7fa8747c, 0x911efcc8, 0xd0219cf2, 0x361798bf, 0xac2f65f9, 
	0xf995f317, 0x247f02fc, 0x98661a87, 0xffb0ee50, 0x6f1e385d, 0x2381844f, 
	0xe27f07de, 0x27ad4c73, 0x50bc7800, 0xc6e6d456, 0xf4d97abc, 0x773c61a1, 
	0x8fbc2a7f, 0x698cb1f8, 0xf9182789, 0x0db794dd, 0xce347d7c, 0x79dd41a6, 
	0xc2632e34, 0x1ea43357, 0x4be04fbe, 0x1f417df2, 0x4c681bee, 0x3bd23aa3, 
	0x22cbfb81, 0xc8f9c5be, 0x8c86aa8e, 0x3cea517c, 0x27f70bba, 0x9f7d0bde, 
	0xdfdc0be6, 0xe829b7e2, 0x42fff7df, 0x1f15953a, 0x2de35d3e, 0xc6ac64ef, 
	0xaf89c46b, 0xf826ef40, 0xf70fa37e, 0x5e3e7137, 0x27187dd7, 0x9e12fdfe, 
	0x342f7ca7, 0xa7dcc4b8, 0x2e6719c9, 0xf27bb38c, 0x38de7a38, 0x19c7a4af, 
	0x1bee625a, 0x0a8e394e, 0xd8c92878, 0x4cef1c35, 0xac1f58a7, 0x384fd973, 
	0xffc20afd, 0xe389d687, 0x741bde23, 0x9963dbb0, 0x5d228f75, 0x35304f49, 
	0x29e897b6, 0xed08c5f4, 0x38c4b87f, 0x10fc6501, 0x8cb84fee, 0x7816cac5, 
	0x63eae5ff, 0x43afae34, 0x04f3d2f7, 0xb5c6beff, 0xef7da0c6, 0xbfae72b2, 
	0x3f0975ff, 0x5bce9907, 0xb57ce229, 0x9cb890df, 0x088e3ac2, 0xcff980be, 
	0xa26d00a3, 0xd238cafd, 0xef86b5df, 0xef8997a3, 0x6f0acbc5, 0xf9c3a519, 
	0xef9d17e0, 0xf0dfa464, 0xb37990bb, 0xfc615d38, 0xf79fe416, 0x5dcebf42, 
	0x7baf9fb7, 0x93dbecde, 0xee0bf04c, 0x217a99b3, 0xa07904bf, 0xbcab6fef, 
	0x5df0825a, 0xfee27001, 0x7d12e3d6, 0x18f806ef, 0x3afdc029, 0xeef93751, 
	0x4bb3eae5, 0xda15fcf0, 0x32b39407, 0x1e793cf3, 0x747903dd, 0x4f3c2397, 
	0x46b6105b, 0xe57a9cf0, 0xe1765bee, 0x9b0c56fc, 0x64f833db, 0xdedbc041, 
	0x56a3bf8c, 0x986e7133, 0xca03e9e7, 0xf1e904be, 0x466e6d99, 0xf710e5fb, 
	0x78cdbca3, 0x54ede48e, 0xb94117d8, 0xd8203ca7, 0x3599b2cb, 0x682efc5e, 
	0x9f575d9e, 0x288cf900, 0x1038f7e6, 0xe164f7c7, 0xd31998af, 0xa1d7c0be, 
	0x0aefe167, 0x67f81b84, 0xf3e62271, 0x8b9ccdef, 0xbed0ba47, 0x185ff80d, 
	0x74e3a41f, 0x16abe97f, 0x0486b390, 0x2177ebb8, 0x7246e69d, 0xb7b365e5, 
	0xed41f402, 0x8a2ee405, 0xe0cb6b78, 0xdbc0a56d, 0x53f9a17b, 0x7299738f, 
	0x138f4917, 0xd838e8bc, 0xdbcffd0f, 0x234f9c22, 0x385b7ae6, 0xa03eb07f, 
	0xe7accacf, 0xad3fdcc5, 0xfd3cf08f, 0x7083f085, 0x9c12744d, 0x4f015f82, 
	0xc03fc151, 0xe0decbf7, 0xf841517e, 0x499fa27a, 0xe623c407, 0xb8ff1025, 
	0x622abc0f, 0xe421b3ca, 0xacf2e0d9, 0x0f89b8b6, 0x97941c70, 0xa3af6d39, 
	0x988d941c, 0x8d2b7cf2, 0x3c90e30b, 0x1fbe3197, 0xca1fe658, 0xe34c6791, 
	0xf4dff9e0, 0xbac55afa, 0xa6dd61fb, 0xcd9d3dbd, 0x3d97c047, 0x76449e38, 
	0xedec0ca1, 0xe4675fae, 0xf2a79d3c, 0x7e72394b, 0x2b2bfe21, 0x065bc5ba, 
	0x8452f8f4, 0xf07841fb, 0xfb82b0eb, 0xe37fc07a, 0x4b2cbe19, 0x0974af7f, 
	0xf9362c3e, 0xba1cdef0, 0x719fe467, 0xb70d62bf, 0xd7fca63b, 0xf9217ebc, 
	0x0bf24cdf, 0x9f517af3, 0xce7f964d, 0x953eb86f, 0xfc854cfc, 0xfcb4ced7, 
	0x2ec84777, 0x324a3ae1, 0xe91ba07a, 0x0f4b3a7a, 0x03d6a744, 0x380778f9, 
	0x6a5e5046, 0x409bd27e, 0x6b52e8fd, 0xa14ec1bc, 0xc98f516f, 0x79e27747, 
	0xa703df0c, 0x80f748e3, 0xec4eef65, 0xea3fbbe7, 0x7e5d92b5, 0xc9f1e098, 
	0x07ea3b6c, 0xa2d72ed3, 0xf983de5d, 0x60cbb005, 0xf052599f, 0x57a12c01, 
	0xeb4fcfac, 0x4cfad00b, 0x7d04f8fc, 0x8c5dde61, 0x02fe83e0, 0xccde782f, 
	0x08e89f84, 0xb7afbeed, 0x0d5c228e, 0x7f492781, 0x0b71bed7, 0x1f936fe9, 
	0xfb788bbe, 0x5c7bf300, 0xec6734ff, 0xb47bd90b, 0x7a593dfb, 0xe04d61be, 
	0x3613cc55, 0xdfdd018c, 0x2f7fba45, 0xcf676b92, 0x985cf1fa, 0xb8c5abcb, 
	0x5f6461fe, 0xa9867f96, 0x7ac9b6fe, 0xd31157e4, 0xba201f5e, 0xdbd15ea3, 
	0x3499eb32, 0x37185cee, 0xc6651f4b, 0xd1f47235, 0x0f71e95b, 0x689ed045, 
	0xf8b21f82, 0xf07482d3, 0x767015cd, 0xbefbfc70, 0x2933819e, 0x8bf6cce0, 
	0x1dfd0bde, 0x7a1519c1, 0xb67092e6, 0x7df7be73, 0xdf89347d, 0xcb3ef9f7, 
	0xc7372e28, 0x16fd5e9b, 0x807e07c1, 0x67277f9f, 0x39bef8f8, 0xcf49bba7, 
	0xe824ffa5, 0xa487e79d, 0xe7a09df5, 0x6bae42bb, 0x9525b68e, 0xaccfc02e, 
	0xfd21775b, 0xbe80c6eb, 0x8be8b247, 0x74136d74, 0x0b7d08be, 0xb924bfc2, 
	0xea37fb4e, 0xafbdf108, 0x45ce90b8, 0x461f1d80, 0x5715f27e, 0xbcbfe82a, 
	0xe21bfd5c, 0xd273e077, 0xd704be83, 0x5c8ebe83, 0x87e506bf, 0xae06d0ec, 
	0x515fd1ef, 0x05fb324b, 0xa1747ea6, 0xc98bfbbe, 0x6bf4cefa, 0x713cfacc, 
	0xe4210e9e, 0x3c5c9f79, 0xcfc8fc22, 0x7ed327a1, 0x016ff08e, 0xe7bf689f, 
	0x3cc6efbe, 0xbc03036b, 0xda28dda2, 0xec7296e7, 0xb2c521b6, 0x0874f6ec, 
	0xcf00fd13, 0x498d7dbc, 0xe7f7175b, 0x69027e51, 0x8e54c4fb, 0x1b37985f, 
	0xe394acbf, 0x3f29bf77, 0xf5726a33, 0x75c5e4a6, 0x426fd045, 0xff39d4be, 
	0xe2258604, 0x0a6faacb, 0x19ea29bd, 0x21a819bd, 0xdeb269bf, 0x5ea026f4, 
	0x07140ac3, 0xc358d7cc, 0x2f3a64f5, 0x5fe2223c, 0xc6f3c5db, 0x878475f9, 
	0xcc0fde81, 0x03cce7e2, 0x5a312c85, 0x88c97a8c, 0xbc5643fe, 0x47c30cd5, 
	0xb92f11da, 0x2f205a71, 0xc5e40b4e, 0x38bc8169, 0xa717902d, 0x0fc8b8e1, 
	0x2d78bc81, 0xa5af1790, 0xb5312df9, 0x80bcafbe, 0xe6faafbe, 0x738f04be, 
	0xfd31aa6e, 0xfc16f385, 0xee572bc4, 0x7a9a7ed1, 0x5fa231e5, 0xb7e91ba3, 
	0xd911ae78, 0xb976ed01, 0x9db6fb7d, 0x2e912f9c, 0xf3c48481, 0x0ebee679, 
	0xf48a7913, 0x6fb111b9, 0x1ef3c173, 0x1f933da2, 0x40f3b353, 0x01636481, 
	0x3eea7dc3, 0xd7fd00a9, 0x9f857615, 0x158be93b, 0x5bea1930, 0xff3c2486, 
	0xe786b5b1, 0xfce2ed35, 0x810b5e0c, 0xbb0ac97e, 0x4b7a423c, 0xa7d72a63, 
	0xb2cc9ab2, 0xacbf01fb, 0x62bed0ca, 0xe4091be1, 0x9942fb3f, 0xabae83f6, 
	0xed04637c, 0x8f5575f8, 0x1ccf5027, 0x4fe7e1ac, 0x1eadb5ec, 0x29950fee, 
	0x821207a8, 0x258af36e, 0xd74ff90f, 0x9df155c6, 0x9f7a8a9b, 0x5995a5fc, 
	0xc0553070, 0xc7094ca1, 0xdb98febc, 0xebcc5c7f, 0xf045c0c8, 0x9951c164, 
	0x6381cc6c, 0xe7e0fcd2, 0xe6277f90, 0x20e45dff, 0x8fbe25c9, 0x2d8ac37e, 
	0x71aedb12, 0xee19257c, 0x1eabf9bf, 0xe5cf0c39, 0x00f667e8, 0x7f599b7d, 
	0x6c3af7b8, 0xeb157e8f, 0xaf23014d, 0x73d96a3d, 0x8b17be3d, 0x3cf86327, 
	0x4eefc160, 0xbb7c79e0, 0xb931f584, 0xb5d60577, 0xd38936f8, 0xa179ce95, 
	0x9ebac038, 0xaafce1ae, 0xf2096529, 0x2a63fb3f, 0x3302c60c, 0x596ea80f, 
	0xa738d7f0, 0x9a9fee07, 0x5fb6edfd, 0x94712c26, 0x2b9e7e0b, 0x32dafd80, 
	0xefdbf2fd, 0x75a7ec88, 0x8fdf10af, 0xf130c334, 0xff783247, 0xabb70d6e, 
	0xd8575e26, 0x93a22587, 0xce8bf05f, 0xbb2fc02e, 0x951fc413, 0x0ed047bb, 
	0x8b35575e, 0x29eb84e8, 0xf1d3a2c8, 0xde490725, 0xf7a80e88, 0x19633e90, 
	0xb3f94cf8, 0xb87ee56f, 0x85ef9729, 0xe3b26b86, 0xdf53bb55, 0x6a581bae, 
	0x947f30bb, 0xf2b9afd1, 0x3fb72959, 0xa30bdbb5, 0x7e746914, 0x3cc029a4, 
	0x0798e3f1, 0xcc2d30d0, 0x7d67fd4a, 0xa3b4805d, 0x9e8f3c35, 0xefcdb7f6, 
	0xdc7e45aa, 0xddeb4f6c, 0x8e6f2640, 0x671a4479, 0xd16fbc3f, 0x7be006fd, 
	0xb45bcd65, 0x94bf80ce, 0xc028fe61, 0xc92b3f24, 0xb141fff8, 0x342c114f, 
	0x3231e02c, 0xac250a9f, 0xd18de7c3, 0x0d8fbc3e, 0x71f95c11, 0x2dd22977, 
	0x5aae5e8b, 0x505df79e, 0x178fce2b, 0x534f7699, 0x502a1f71, 0xa6aaea2e, 
	0xfb7838f6, 0x559f6e1e, 0x5d02271e, 0x73c15e81, 0xe80244f6, 0xf6e5a968, 
	0x47bc8d43, 0x8ba4c6f6, 0x24169e79, 0xd2a1ce9c, 0x7495d479, 0x3054817f, 
	0xc4ecf74e, 0xfbfea00a, 0x1b0f0e1a, 0x079ee7b1, 0xd52cfb18, 0xeceb7a7f, 
	0x39f8f7f4, 0x8d1201e7, 0x79517df4, 0xe61fd72d, 0xccdb00f9, 0x95cf0541, 
	0x4d7e9a96, 0x93bc2331, 0xebe12fbd, 0x798fd736, 0x97388080, 0x76807282, 
	0xda55d831, 0x4c20e782, 0x76aeecfc, 0x177fa2d4, 0x479f3c60, 0xcc7f81ef, 
	0x275e782a, 0xc2557a90, 0x7176c0f3, 0xc9d4a62e, 0xf7c4c4e5, 0xb07e04c7, 
	0x92bcf20c, 0x728e387a, 0xee96bd35, 0x3d773b27, 0x7f02139d, 0xba6f0f3b, 
	0x85e6fe84, 0x589576f0, 0xa61fdb07, 0x766b1373, 0xe13ffc17, 0x035f1f2d, 
	0xef111801, 0xfe9b7075, 0x84ade03e, 0xde0e680c, 0x7e25fe4c, 0x2c0dfe03, 
	0x2437e74a, 0xdf88b3f4, 0x4fc07f88, 0x6e41f9a1, 0xce5aff08, 0x3ddd9abe, 
	0x3c44592e, 0x886afb80, 0x99bd82f7, 0x47577679, 0xe53f396a, 0xf2283de1, 
	0x216c7d69, 0x990b73f9, 0x9197cef8, 0x3075763f, 0xafe310b6, 0xf1353593, 
	0xe0c82772, 0x02ad5a55, 0xd6f67ff8, 0x87ef5048, 0x78a46b5e, 0x0a767db6, 
	0x1adecfbf, 0x827ea450, 0xdbdbce97, 0xa114375b, 0x53acfd3f, 0x58a3278f, 
	0xdb13bc1f, 0x7e794bc3, 0x503adec6, 0x5d39076e, 0x03db94b2, 0xd224c807, 
	0x1231b9dd, 0xfbf1048c, 0xf614160e, 0x7cff82d9, 0x3dfb96a6, 0x57ef3f66, 
	0x6d1cc7f6, 0x59054a54, 0x1ed6d1fa, 0xa94576e8, 0xb306178c, 0xcb7c0f9f, 
	0x93e54635, 0xdef00385, 0x0b5f715c, 0x67a82c33, 0xa02d7e4f, 0x7f2423aa, 
	0x3dc6957e, 0x5d7bc165, 0xb7fc16ee, 0x2d6d66b2, 0xe9182b8f, 0xc7bc0095, 
	0x475bc9ef, 0x3bfd087c, 0x077f9ce9, 0x614f27bf, 0xf7e2120d, 0x78fdf8f7, 
	0x345def1c, 0xfb49df5e, 0xe25b465f, 0xd7bfa0af, 0x5c24fba0, 0xfd00bf26, 
	0xc7093ef1, 0xcc4e7e52, 0xbf7d233b, 0xbd55e509, 0x7b27d88b, 0x65196396, 
	0xde6fc07d, 0xc21fa822, 0xcdd0ea12, 0xcf5266eb, 0xd1ce50ab, 0x286e891c, 
	0x7b9bf5cb, 0x39b2815e, 0xd804f85a, 0xfb1d6f4b, 0x5f69b7e1, 0xcb6678cc, 
	0x51bf5015, 0x3bdf9e7b, 0x7844ac60, 0x58637232, 0x2f9e7e90, 0x5da38b1e, 
	0xdca03c41, 0x3d1eee78, 0x82edf584, 0xcf42bcbf, 0x0e8ed7b9, 0x53e51c63, 
	0x1ef3be99, 0x925f1ec6, 0x9c3d45a8, 0xc1d2cf3e, 0xaeb373e3, 0x387e2044, 
	0x4c3e0535, 0x007989bd, 0x06df47e0, 0x15dc4e7e, 0xd6317285, 0x04bbe98b, 
	0xb2857b57, 0x3fc44065, 0xe8cf146d, 0xf1c4fdf8, 0xbccd79bc, 0xf396a240, 
	0xa05e9657, 0xdd3bc5b8, 0x98239390, 0xfce237c7, 0xed4d7ebb, 0xd60c7585, 
	0x4de9bb72, 0x084b25cb, 0x6de7963f, 0xde63af40, 0x84f68dc6, 0x7812c3e8, 
	0x622b8c6f, 0x51fabaf8, 0x28aa966f, 0xe5afdf97, 0x8e7d9ffe, 0x8602bb88, 
	0x3f96676f, 0xb7296cbe, 0x73dea66f, 0x776ea7f9, 0x1f3a0ddb, 0x454afde9, 
	0x46a3d702, 0x3b72976a, 0x4e5b2927, 0x1305ec65, 0x5c19f0fe, 0x7f4c99ef, 
	0x8fc483b0, 0xfc70f599, 0x8c7f3fba, 0x8df407f0, 0x5c53bca3, 0x6abd4298, 
	0xbb47894c, 0x75edebf0, 0x67e63263, 0xf38f7d4d, 0xf3899c60, 0x3806fde2, 
	0x3595d61f, 0x8b39d353, 0x7f6ce4cf, 0xfe89e90c, 0x1bcf098c, 0x246a0e82, 
	0x4f977241, 0x39f03bcf, 0x83d715d8, 0x99afe483, 0xf6ee79f0, 0xef1f3027, 
	0xcf4033b9, 0xc484bc61, 0x482319f3, 0x7d2653b7, 0xfbbfbc43, 0x9e546bf3, 
	0xa7f9e7bf, 0xb69f8279, 0xf073c645, 0xe798af30, 0x40f1f237, 0x972f63fa, 
	0x066f757f, 0x1007a80f, 0x7808af0f, 0x0e10f9cd, 0x8bbff3d4, 0xc37a47bc, 
	0xc3bcdf6d, 0xc606fb4f, 0x0247df08, 0x54e579bf, 0x4a7986f8, 0x22bcf332, 
	0x6fa992f4, 0x93c0d58e, 0x01ef32fb, 0x4b94653e, 0x2a153dcf, 0x4dee2dc6, 
	0xf017aa63, 0xeb152f21, 0x6de713af, 0xe52dc261, 0x79e35fd8, 0xb9faf4d8, 
	0x035e613c, 0x7eb9bdf5, 0xfbe6ff13, 0x6824f599, 0x3f3b2e3d, 0x0f5e9f17, 
	0x324701c6, 0xbb2029ef, 0x17c32a7a, 0x3d57da12, 0x91387eeb, 0xc395738f, 
	0xae64c09b, 0x30f970ef, 0xe52da7db, 0xb2852eeb, 0xef8a7db5, 0xd91b5468, 
	0x3da6b5f3, 0xd502fe2f, 0x3bad75bf, 0xc2adbbe7, 0xd83e30f9, 0x1a3bf309, 
	0xd9a27b6f, 0x77847101, 0x973cde9d, 0x252f3da1, 0x351cf339, 0xbb408f62, 
	0xb3ad2efb, 0x58d5d89a, 0xf7fefe8a, 0x5e2af9cc, 0x6f9bc9a9, 0x037cee69, 
	0xbef9c2bf, 0x9ea1f38b, 0xb67c1a29, 0xd7ce2b6e, 0x9630c5f2, 0x562fb4eb, 
	0x97fd9d82, 0xe2297040, 0x7b1773cf, 0xdbe316b6, 0xae20e351, 0xf936bdcb, 
	0xb207945b, 0xca57c093, 0xbb1cd2c4, 0x7df950e2, 0x7e42ce10, 0x35a3a19f, 
	0xca5cf0c8, 0x1bef808d, 0x17967e50, 0x3af3301f, 0xfc08df74, 0xbe0bb675, 
	0x9fd67e22, 0xc0edcddb, 0x10ae87be, 0xcb91bafc, 0xc1e3dd03, 0x4b3d3ef4, 
	0x2c6ca52f, 0xa3b9f7cc, 0xed8cc90c, 0xaaa20f74, 0x9a64f389, 0xc335f78c, 
	0xa8cfd35f, 0x7f913ad4, 0x0c5a85dc, 0x677c83ef, 0x8c1c68ed, 0x7d39f223, 
	0xc55fa5d7, 0xa76e6f08, 0x1ffdc316, 0x8c319977, 0x58ef42e7, 0xbdc8e5ca, 
	0x8bee8fa8, 0x4d5916d9, 0xd1df70f4, 0x4ddc62a1, 0xdf86d97c, 0xddf41925, 
	0x977e966b, 0xecfadfd1, 0xe1bfbe52, 0x1862342e, 0x464ea87f, 0xdcfbc1f8, 
	0x2f775d70, 0x44bddf15, 0xdfe52c36, 0xeff176db, 0x723e847c, 0xdafcf0b4, 
	0xa9e7c8b6, 0xd0af3d3d, 0x1de69313, 0x5f22dc50, 0x1c3ff94a, 0x397fbf1f, 
	0x52db7356, 0xdbfa972e, 0x63289efc, 0x83d036df, 0xab0f178e, 0x227044df, 
	0xedf1a25f, 0xf7050115, 0x3d11edb1, 0x71c58fd7, 0x3d29bea1, 0xe8a5c6de, 
	0x603ad267, 0x1ea736fd, 0xf00cb8c3, 0x35fc4437, 0xe1ee9870, 0x74693773, 
	0x1b8c258f, 0xeee786ef, 0x6943a84a, 0x843a3b5d, 0xc97c7c6b, 0x9c5e7c03, 
	0xb79f1c6f, 0xb5b9f0c6, 0x5646f402, 0xc384d01e, 0x133ad4e3, 0x04bac67e, 
	0x3e229cde, 0xfbe52c48, 0xe73f0ea9, 0x2ccab743, 0xb8376788, 0xb5a7e849, 
	0xa3dfe52c, 0xd8205f20, 0x3cc134ef, 0x89be130f, 0x11a76e7e, 0x7d455fd3, 
	0x7678e49e, 0x2efc71eb, 0x87d6eec0, 0xe7167bf1, 0xe3dfa0cd, 0x37f03f38, 
	0x26ce4bf8, 0x8f0e0fe8, 0xd3df92b3, 0xf815bf69, 0x9872a349, 0x4fa00912, 
	0x7c98aed0, 0x18bffb45, 0x313fa397, 0x37c27e8e, 0xdba71e69, 0x8dbcc218, 
	0x1ed36f89, 0xbf01ef99, 0xc0bfe974, 0xbde00bfb, 0x4eae3e52, 0xb2764a78, 
	0xd32f6846, 0x553e210f, 0x6b1c31b7, 0x06e49d02, 0xacf91dff, 0xc9ec95a9, 
	0x3433c8b6, 0x888ef78f, 0x1ec5fa8a, 0xf13578e1, 0x4098fc89, 0x275938ba, 
	0x3f88c606, 0x4bf3efc4, 0xbee4dc79, 0x889dc795, 0xfcdf3c77, 0x56fbc0a2, 
	0x59bf2fe1, 0x94a583f3, 0x45be049f, 0x71d58af9, 0x63cb4db9, 0xa5d7cf07, 
	0xa1f60e16, 0xf73f4eb1, 0x777be96b, 0xa85f7fc8, 0xde2a4049, 0x9fde3f6f, 
	0xfa9bfbc9, 0xa4f6c542, 0x31da2e78, 0xaddb300e, 0x017fa0ad, 0x0e399b3e, 
	0x6c39d3b6, 0xf5a21dfe, 0x9defe4d6, 0x6f3d191d, 0xfda37415, 0x0b73b434, 
	0x5f22935b, 0x2b637945, 0x932c77d2, 0xf42f7e17, 0xd5bdc926, 0x77d28da9, 
	0x77470be2, 0x8a86ef61, 0x97ef3a7e, 0xe3204fb5, 0xb176b6f7, 0x51f7424f, 
	0xf8f86617, 0x7ef76103, 0x22cbf025, 0x165bd11a, 0x6b1cc2e7, 0x2ef48a82, 
	0xe48b739e, 0xe7e3ab9d, 0xbc752867, 0xeece7335, 0xfd632b51, 0x88a997c0, 
	0x733c3e79, 0xb1e11bfe, 0x7b0afd8b, 0xf89fdf2d, 0xf7f09d5a, 0x057c3f9e, 
	0x38cc4eff, 0xadf40bb0, 0xc78505eb, 0x8c474021, 0x7e143eef, 0xff359bdf, 
	0x97fe724e, 0x38d574f9, 0x39acdefd, 0xf5f694b3, 0xf527fd04, 0x5bfa720b, 
	0x9126af51, 0x141fad0e, 0xb7b64c76, 0xfdfa65f9, 0x673e7162, 0xfd47f43f, 
	0x9cea395d, 0xcdaf6597, 0xaf5361fd, 0x8f6ffed3, 0x265b5ba0, 0x45f20fcf, 
	0x1d5f7c79, 0xe7a8dbb7, 0x445e74e3, 0x7e73fbe3, 0x07d9ca4d, 0x7df008ad, 
	0xec5f88d0, 0x72ebfa83, 0xfc8df9f3, 0xd8af33be, 0xb2e88a0f, 0x8e866cff, 
	0x14a616ce, 0xaeafbe00, 0x6a4a71e3, 0xb9e845f5, 0xb67a0a70, 0x35f9e798, 
	0xa81cfb29, 0xd96bec43, 0xf18486fd, 0xd0157582, 0xdf631f75, 0x3eb57410, 
	0x3f257cdf, 0x749468df, 0xa9f4813d, 0xcfa6cba8, 0x116cf924, 0x03d669f2, 
	0x95ae799a, 0xd4dbb7df, 0xef8f9c5a, 0x8717fdec, 0xd40e6bb0, 0x3bf700ff, 
	0x4e2e40ab, 0xd1c8e466, 0xb5fdd1a2, 0xda7ec10d, 0x4ba7cad7, 0xd7df1d73, 
	0xfbe2ac72, 0x2d328e99, 0x392ef789, 0x6cbd385a, 0x21e79d6e, 0x49d05d55, 
	0x5053a5cf, 0x2fc5a9d0, 0xe4565df6, 0xbe8869d1, 0x757bb12b, 0x4f981fbe, 
	0x014b2027, 0x7fb3f7d0, 0x72d29d28, 0xc9d0e7a7, 0xbe27573e, 0xe908bf40, 
	0x03f94364, 0xc75dddfd, 0xf9eda7f5, 0x2798aca7, 0xbf473476, 0xe8e488b1, 
	0xf5b2eacf, 0xd3a436e8, 0xacba2ca6, 0xad4974e1, 0xcded7ae2, 0x50eb3b9a, 
	0x2bdba51f, 0xf7889c84, 0xd85a1553, 0x27e59fd6, 0xcceb7281, 0x9156b7d2, 
	0xfdf7c44f, 0x8c41bed8, 0xbb0d115f, 0xaa6eef41, 0x66ffbdcb, 0xd176ff52, 
	0xd66aea1f, 0x9336cd3e, 0xd7f064bf, 0xde81f6b2, 0xb39cd9ac, 0x11dc34be, 
	0xbdfa4e3e, 0x717d0385, 0x5383df5a, 0x9bcd6ff7, 0x8fef2d67, 0x8bf50bf6, 
	0x3ec932bb, 0xf6fff9c6, 0x271c5cd8, 0xe9ffc391, 0xbb19a271, 0xf334f884, 
	0x17352961, 0xb6916f6e, 0x787ced03, 0x2f3a6cec, 0x33adf48b, 0x233351cf, 
	0xd08a7986, 0x20530346, 0x83d28e78, 0x147faff9, 0xcf3de4fc, 0x3c57983c, 
	0x97a974f9, 0x187c8315, 0x3bf41e43, 0xc7b9e6ec, 0x135ec66f, 0x73a6e3fc, 
	0x3acd3b8c, 0xf7580bf8, 0x7e66bd0f, 0x86ff8307, 0x5baeb364, 0xd15abdb0, 
	0x0c39e91e, 0xb9fa3ba5, 0xd548b01e, 0x3da3da45, 0x89ce50cd, 0x83e3d3de, 
	0x8c7b5cb2, 0xef4517da, 0x2e90f6a7, 0x0a37ffbe, 0x443f41ba, 0xe60f24fa, 
	0x0df497f1, 0xe700fdb9, 0xafee3a91, 0x85f881be, 0x76849232, 0x1924be78, 
	0x213dba9b, 0x538d13da, 0xf68b17b7, 0xca7521e2, 0xdf98bf76, 0x5dba9b1f, 
	0xe36aed15, 0x8c4cedd4, 0xdba9a4cf, 0x6f6f19db, 0xfed82dd7, 0xd2ff6986, 
	0x1af03ff8, 0xfef883f1, 0xd453b426, 0x213df7c5, 0x175e59ff, 0x6484f7df, 
	0x61f71751, 0x4c6fd1d8, 0x4aa07ee2, 0x8eb7b1f2, 0x7e22839f, 0xaa85f902, 
	0xe08f7dde, 0xfe5bf01f, 0x3c2df059, 0xfc84bf26, 0x309624e6, 0xf62df80e, 
	0x9de51273, 0xcaee8a6d, 0xa7fd47de, 0xa3ddfe3a, 0x2a908fb9, 0xf6ca189b, 
	0xb1f2947f, 0x153fa8bd, 0x1f57beb7, 0xd35d6c61, 0x5fcc41c4, 0x250d5bae, 
	0x2bebbac4, 0xbdf122b5, 0x6697dd07, 0xadd54fea, 0x5317a849, 0x854318af, 
	0x28d8dedc, 0xc3651abe, 0x6d0f9c85, 0x2e5feff8, 0xfb6cfce3, 0xacbdb1e4, 
	0x478fda00, 0xd4fc7186, 0xfc712819, 0xae5f3c55, 0x2dd1175e, 0xc5727159, 
	0x8c53bc32, 0x7196abb1, 0x9bce67bf, 0xf5fde9a7, 0xddf4fcab, 0xfc659ac2, 
	0x9155503b, 0xe02bcf48, 0x85f8f3b7, 0x7c88677f, 0x3a15fb8e, 0x9e0b27fb, 
	0xe32c492b, 0x7eaa537e, 0x9fbc70da, 0x1d5c51fa, 0x1577f9d4, 0x865adfce, 
	0xbc311ed0, 0xade79187, 0x02cd9ee9, 0xd1ba8d95, 0x21eca92e, 0x8f4c07cc, 
	0xed087f2c, 0x23be2a91, 0x9d7de1b5, 0x99272718, 0xf2edcfc2, 0x983f52f1, 
	0xd675c218, 0xa760fc23, 0x4ae9b75c, 0xeae7c421, 0x233acd2a, 0x053b8196, 
	0xeb3279fe, 0x64161cbe, 0xfa5f7187, 0x1611f782, 0x99bdf827, 0x7bfc132b, 
	0x1251af0b, 0x2e9c7803, 0xadfb187d, 0xcb308e6f, 0xc59cf89d, 0x161cb463, 
	0x95fd21ef, 0xc9a15f7b, 0xd46f4867, 0x1d6f4863, 0x0ab6ccf8, 0xf0fe04e8, 
	0x3f8fb17a, 0x13bfc751, 0xf9acdf5e, 0xf5bffbf0, 0x5eb7df22, 0x5ebc1f7c, 
	0x15bf03c4, 0x042feb7a, 0xc43df0bd, 0x7c09d3b7, 0xeeba7c05, 0xc890e31a, 
	0x88f9a787, 0xa3f06ffc, 0xbfba7ee2, 0x7ea2ea53, 0x3fb88713, 0xc8df7e61, 
	0xfcee5ee8, 0xf84c317b, 0xdd3f5195, 0xa152918f, 0x1017d71d, 0x33cd56f7, 
	0x03fbf2f6, 0x6bee30d9, 0x27673fad, 0xa9e9037f, 0xca72853c, 0x943e7986, 
	0xcbcf18fd, 0xe2d63d12, 0xf1e11a7b, 0x44ba07ff, 0x59743306, 0xe4f86cdf, 
	0x9b7c1953, 0x7fe737f8, 0xb7fde041, 0x42f7b975, 0xe787dc51, 0x13e65a12, 
	0x147a167f, 0x9a31e79e, 0x79d89ea9, 0x45338f05, 0x0570a83e, 0xe5c82460, 
	0x5afbaa68, 0x61400206, 0x96950b88, 0x918ce284, 0xdf68c65c, 0xe9f834f5, 
	0xf979ec8e, 0x5b4cf97d, 0xf06f3b90, 0xf7cbaa26, 0xaf3d4dd7, 0xe79297d8, 
	0xc615161b, 0xbbd4adb7, 0x340b3e78, 0xb62df809, 0x9a1219df, 0xd727e74f, 
	0xf5f38a74, 0x4702f7b9, 0xe9d724bd, 0x4b3e5af9, 0x84d7d3f5, 0xcb0fdea7, 
	0x2040e75b, 0xeb98f341, 0x0ae94e55, 0x0b52cfe6, 0xbfce61b5, 0x54be44c5, 
	0x1e387fb5, 0xd49c3a00, 0x29fbf43d, 0x1b2f7527, 0x1b42bf40, 0xf2b9e096, 
	0x0cfefa52, 0xb525e207, 0xf3187069, 0xfd45a981, 0xff7fa8c3, 0xfc55e806, 
	0xa0e3c101, 0x1a42fbfb, 0x7c7e877d, 0xd80bc826, 0xb9697597, 0x3cb93f61, 
	0xe4fc89b9, 0xee37214f, 0x215f39b7, 0x3e3ec91c, 0x7cefd73f, 0xcf82c3fe, 
	0x7fddfed2, 0xcbce1c11, 0x3fce17d4, 0x6eb0be91, 0xae3ed3b1, 0xbe4858a2, 
	0x842febd2, 0x4b7be612, 0x6effb1d8, 0x601f787a, 0xc3e47f14, 0xc3a0aef3, 
	0xd63c377f, 0xfec93385, 0xce3f885e, 0x57fd3c09, 0x7ed787f3, 0xea797a71, 
	0xe3f067ff, 0xb87188fd, 0x402ca1ca, 0x4f232abf, 0xbe1cc57d, 0xb4af983e, 
	0xff37fb9e, 0xebd9f0dd, 0x0048944e, 0x4050fadf, 0xc2c9ecb2, 0x61282cdb, 
	0x10ffd09e, 0x5678aede, 0x974f5035, 0xc438bf41, 0xbed0a9c8, 0xfd3fbc61, 
	0xf71e7a8e, 0x8661615e, 0xfc75cf79, 0x7f3bb021, 0x8137b43d, 0xed1be0fe, 
	0x4d942a23, 0xaeef9cf5, 0xf53555f8, 0x96fd980b, 0xf44def0f, 0x5dddfa66, 
	0x40c0fc2f, 0xb5f930eb, 0xfc84a316, 0xf201ff56, 0x07655347, 0xed353fc8, 
	0x4fdafaea, 0x6ef7e826, 0xf02eb0e2, 0x46ebd78f, 0xf7133e89, 0x7e2a2d81, 
	0x4fe59547, 0x32c9475a, 0xa257ed4c, 0xd3758a7f, 0xf2bf247f, 0x7e82ec07, 
	0x09a5da23, 0xb257fdc6, 0x1e67e80f, 0xa691f8c9, 0x61b8ea3f, 0xc79843cd, 
	0x7f6baf57, 0x53c3bf08, 0xc8b37a6d, 0x03dfbdcf, 0xbb553386, 0xc7ee587c, 
	0x67046af5, 0x0fd73afe, 0xff98236b, 0x72fe454c, 0xeb469118, 0x01b87e04, 
	0x233964f0, 0x810bfbd6, 0xbacc9e87, 0x3f6bbb4d, 0x4fb5f7c5, 0xf911f95c, 
	0xdabb6901, 0xf8784252, 0xdb8d84de, 0xb4dde8dd, 0xb96cffce, 0xb8d79c5a, 
	0xb9b17f90, 0xd633f69e, 0xed2afbf0, 0xfba15d11, 0xc79e550d, 0x1865f883, 
	0x0854a2fd, 0xd49d604a, 0x8d6ca275, 0x2d72a21c, 0x49bed894, 0x3d45bbd4, 
	0x27cbc1d9, 0x1ff3f83b, 0xa22bfa88, 0xcfe41d1c, 0xfaf20f8f, 0x1db75119, 
	0x2cffa5e0, 0xdb75e395, 0xd954be09, 0xc42fde59, 0x415c139f, 0x8080d701, 
	0x35c0406b, 0x0a0ae020, 0x5c0406b8, 0x50570141, 0xe02035c0, 0x82b80a0a, 
	0x0101ae02, 0x35c05057, 0x101ae020, 0xdd640d70, 0x0570830f, 0xf8035c05, 
	0xa32cb3b1, 0x661f50fd, 0x1ff06eea, 0x1c40e6d5, 0x215771ef, 0x2b387c4e, 
	0x77313c4e, 0xa61f7d09, 0xa12f1936, 0x9fce929f, 0xe5137f0b, 0x8ce9f939, 
	0x64e79b3c, 0x0f7e8fe0, 0xfe4227e8, 0xdf2176d4, 0x5be5cecc, 0xbf8ee48b, 
	0x162978ca, 0x31987cc0, 0xb72fb394, 0xf11ef80e, 0xf4e11ed9, 0x2a71055c, 
	0x11e3ebe6, 0xc587ef4e, 0x1945abf3, 0x71e5e0ec, 0xe0e99e51, 0x799b6cfd, 
	0x111e7c89, 0x12744e7c, 0xd944ebf5, 0xcdca967a, 0x9e9c23f5, 0xf8130f00, 
	0xe4a5f5c0, 0xa74dbabc, 0x0ff123fb, 0x7c7674dc, 0x9ca38b3e, 0x04a10ba8, 
	0xd22ea87d, 0x7659caf6, 0x52fa42f0, 0x97b1d45d, 0x5f5a5eb5, 0xcd1e262a, 
	0x9e84fefb, 0xf50387cc, 0x8145ca0d, 0x7844ef53, 0x41d0f2bc, 0xc9dbaf11, 
	0x0e319d1e, 0xfe103c8a, 0x2eda4544, 0xc6efac07, 0x59ce9f68, 0xe31cf640, 
	0xbc878c65, 0xc7faa48a, 0xc68ffa32, 0x3da07a85, 0x6857bf40, 0x0163befe, 
	0x5bcc37e8, 0x07b3e578, 0x7c133d69, 0x1333de3d, 0xa76f0907, 0xd76fbc38, 
	0xafeefd8b, 0xa9603cf3, 0x9034bc6c, 0x0f5877c5, 0x8cf066b6, 0x7c07dc7c, 
	0x6d91ba54, 0xf4b93f45, 0xac6b6c97, 0x77b7033f, 0x20e29463, 0x2389ceef, 
	0xff27a7c8, 0xfca76a3d, 0xdf5829d8, 0x9f7059c3, 0x285c3d02, 0x25e7edfa, 
	0xff7c9feb, 0x87be014e, 0x7683defd, 0xfa8b8388, 0x7be91b75, 0x4794d7d4, 
	0x7a33d660, 0x5ee34f46, 0xa45fd0a5, 0xdc5d54df, 0xf7bf88ab, 0x35f42e3b, 
	0xefd067bd, 0x0018cc2d, 0x6bfa0dd5, 0xb61d1dfa, 0x0c1f6445, 0xeb079dfa, 
	0x7843ff42, 0x5b94d8ae, 0xff846d6b, 0x668b671e, 0x9b8e7ba5, 0xe5b23e40, 
	0xfee8cdd0, 0x38d2b512, 0x86dcfd98, 0x173a1879, 0x2ef7423d, 0xcc6512c1, 
	0xb2b89c7f, 0xc0e78e21, 0x72bc21ec, 0x378fb197, 0x4dfe7388, 0x9f1086c7, 
	0x541dce93, 0xae9eb448, 0x7d71555f, 0xea8bbfed, 0x4fa6db13, 0x40e77f79, 
	0x8ffc4600, 0x9f56de8c, 0xd5093886, 0x20e322f4, 0x8d1b99d9, 0x11bceca1, 
	0xff2638ab, 0x89f1c483, 0xf9156afc, 0x7234352b, 0x4b1fbe30, 0xd7009be0, 
	0x76efb427, 0xcbed396e, 0xdc1340a8, 0xf9c554bf, 0x1d436b1e, 0xea0b6bcd, 
	0xd3552784, 0x93a7ba24, 0x27645d19, 0x5c5edc83, 0xe9d74e38, 0xa7bc627e, 
	0xd53e7cd2, 0xf99839ef, 0x7ae8f1b2, 0xadd497ba, 0x3aa38369, 0xef1485f1, 
	0xf8bdefe5, 0xc8b27411, 0xc9fefe32, 0xfdfe06ca, 0xdb89bd87, 0x68a2eb27, 
	0x8fb77f04, 0x33c07cf2, 0x696e1a33, 0x7185fdc0, 0x75fa974d, 0x471c8f5a, 
	0x08b547bc, 0xf6d227e6, 0xff05e443, 0x6573c61c, 0xaec2df7d, 0x62b3bfe2, 
	0xf7ccfd17, 0xbe687c69, 0xfb4ffa1d, 0xcccfd320, 0xd142db4b, 0x8e05fa08, 
	0xbc25eb89, 0xaad9c967, 0xff1da115, 0x849de974, 0x4892fb47, 0x6d077e11, 
	0xfe5e60ad, 0xfa5479fd, 0x3eb26f9d, 0x487b8ab2, 0x82a8fad3, 0x3ebe7bcb, 
	0xefc63552, 0x30096d67, 0xb7b7b7dc, 0x56efd054, 0xfbf85bd9, 0xf0b308f6, 
	0xe95bbf7b, 0x3e3b0377, 0x4fcfc157, 0xe6d98d44, 0x910fbb39, 0x2e23211e, 
	0xfbdd16f4, 0xbc77e69a, 0x27e50bef, 0x0575efc0, 0x5bee80ff, 0x2854b6b5, 
	0x5ef0c65b, 0x65d69d55, 0xe374096d, 0x175832f9, 0x6b70eb8d, 0xca02b12c, 
	0x87624639, 0x3e85cf17, 0x7f80a0d4, 0x7063bce3, 0x9856f961, 0x42d8afe6, 
	0xfb7f6b3d, 0xc72f95c4, 0x6d929cf0, 0x7807bf21, 0xbede4367, 0x7e4e9d46, 
	0x2348adbe, 0xce2adf3f, 0xc0dc3f7f, 0x06ce65f3, 0xc444cf26, 0xfbe31e05, 
	0x405728f2, 0xa1102be7, 0x7ebc0f98, 0x5acaf890, 0xa07ed1a1, 0xf83efc4d, 
	0xa41f2b89, 0x7d9fbffb, 0x3ec50594, 0x3eff829e, 0xf3416bab, 0xa2122b1e, 
	0x8fd211b5, 0xe0ec6ecf, 0xbe455ae7, 0x7f26e012, 0x038069f0, 0xd02c0def, 
	0xc66334d7, 0x03ee2022, 0x4c0eb19e, 0xaa1218fa, 0xeb86c944, 0xce9fd0fb, 
	0x97bf9b51, 0xbff7cfd4, 0x744a0ffd, 0xdfbe30bf, 0x7d49f227, 0x9f7b7847, 
	0xfd60f3c8, 0xcf1e0685, 0xb8ee40b0, 0xde48f493, 0xd55fd3bd, 0x41efce58, 
	0xe9d018cc, 0x3efcd2f7, 0xd849ce9d, 0x98389eee, 0xb8f6af9d, 0x4f76eff9, 
	0x603c07bf, 0xf64b6ebe, 0x0b8472f9, 0x370f13cf, 0x38e47f70, 0xe6f30bae, 
	0x70395981, 0x817b8815, 0xb71e783c, 0xdf97d89c, 0x28091f37, 0xd254a25b, 
	0x086ef7f7, 0xe39fbb26, 0xd17ba6eb, 0x7942b43b, 0x194aca8c, 0xfef0edda, 
	0xcbc43f63, 0x3279f84c, 0xbc43714f, 0xe7e11fbb, 0xed3c04e7, 0x77e85bd1, 
	0x5d84eb76, 0x7cdcb8d4, 0x83e7e34d, 0x5f7c7d70, 0xdf4bdb89, 0x231fd1fd, 
	0xfdcc4e7e, 0x83ed0c5a, 0x0978d2b5, 0xdaeb38fd, 0x0f109789, 0xe7f51cf4, 
	0x1f934fb7, 0x880e7785, 0xc4a6baef, 0x0f02bbc3, 0xe882bb4c, 0x65d287f0, 
	0x12138bfa, 0x027ce3e6, 0xcf716e6f, 0x2fb989c7, 0xdcfe50c6, 0xe9ce847a, 
	0x20f99f1c, 0x780367c1, 0x5f1d3ef9, 0x47e084ef, 0xc3b73d6b, 0x517caf27, 
	0xbd6dbb42, 0xeb863d86, 0x454bfb48, 0x20ec8e5c, 0x19c42ae7, 0xf1e06dbf, 
	0xd0413bdf, 0xddf659f3, 0xa07a015e, 0x88bbf330, 0x188f6f34, 0x0e0b22bf, 
	0x0bffe781, 0x2a97e353, 0x000368e1, 0x7dbd9c78, 0xd554780b, 0x479ef0b5, 
	0x61079332, 0x426600f2, 0x74092180, 0x180e202e, 0x27288075, 0x20804824, 
	0xa3e0ab41, 0x26499275, 0x28a47c01, 0x99c1f112, 0x2884c224, 0xc1908784, 
	0x2f41523e, 0x46ffdb57, 0xb95cb5cb, 0xb0f0f5df, 0xfb9ab680, 0x2db157cb, 
	0x3404277f, 0x6ddf36f7, 0x62c62d6a, 0xfb1ebfeb, 0x0c932664, 0xef93f4a0, 
	0xce7bb76b, 0xbdacfb3e, 0xb5ed6bde, 0xee6e1277, 0x853aa93f, 0x762e9848, 
	0x12fda007, 0x06f3fdfe, 0xd10967e8, 0x8b084a38, 0x7758355b, 0xc0a49108, 
	0x3884eaff, 0x93b17d0f, 0xc0dc6dc7, 0x2176c5cf, 0xf173c1d6, 0xc76710a9, 
	0x0708086c, 0xcc037fbc, 0x267782eb, 0xf0cc548d, 0x077df27b, 0x866fe4a7, 
	0x45312131, 0x667bc10d, 0xc27bbf9e, 0xf42b019b, 0xcd88a713, 0xec2176c1, 
	0x8fad8f30, 0x708ddfe7, 0x4086aa14, 0x52cf3c06, 0xe874810c, 0xe37bf2a7, 
	0x8058dc61, 0x30ae7927, 0x5e61518e, 0xf1461bfb, 0x1fea10b9, 0x926a13ae, 
	0x0e0b2910, 0xf7e0721a, 0x84629704, 0x5cef0a6f, 0x424fe378, 0xe3deb2bc, 
	0x303be156, 0x0856a0d2, 0xb3542ed1, 0x68e090ba, 0x75f5b842, 0xa0ca7c8d, 
	0xb6c79e36, 0x59a198e3, 0x0c50a708, 0x9ef85d6d, 0x893b6866, 0x7ea262ad, 
	0xfec012bb, 0x0dc7804c, 0xa15b0b70, 0x610e1a39, 0xfefd495b, 0x85425196, 
	0x3c451e79, 0x4bff023d, 0x80623bec, 0x85b253f7, 0x30e01135, 0xe9a6c25a, 
	0x34c8ef00, 0xc1b6a035, 0x87fd35e3, 0x2ac4ce10, 0x7c119d68, 0x430aa5a4, 
	0x7efc76e3, 0x62ec1030, 0x190b82b8, 0x93cc209e, 0x5ab088f8, 0x47cc42bd, 
	0x847e023c, 0x78b326f3, 0x083c3e2c, 0xc7051abf, 0xe1097c00, 0x71278406, 
	0x10a1bf4c, 0xd7e3ddba, 0x6b375d31, 0xc31f186f, 0x40b309ef, 0xded14efc, 
	0xf847b408, 0xa774e466, 0xc78e7a6a, 0x4a5f095b, 0xf237c213, 0x2492baa9, 
	0x12bbff78, 0xfdcd84ae, 0x244e886f, 0x3b268783, 0x419d6137, 0x00ff25d8, 
	0x305de71c, 0x25f2097f, 0xfcd451f0, 0x5504f3fa, 0xd0238b31, 0xc33e616e, 
	0xdc39c271, 0x1e679838, 0x39e11bb4, 0x7c891b8c, 0xaa442d57, 0x0024decf, 
	0x6f7d691f, 0x7f1f109a, 0x50ae72ff, 0x13f9e01b, 0xf012735e, 0x69c02d4b, 
	0x2f533805, 0xa86e1f16, 0x039875a4, 0x62ab3f88, 0xa575866e, 0xaaa388a6, 
	0xe4bd4426, 0x4b97a27b, 0xd33f6bd2, 0xa2af1a25, 0x1d306b2f, 0x1d13d75a, 
	0x68d9fafe, 0x0fd003a6, 0x205f13c7, 0x37f5657f, 0xad7e0214, 0x739a0f4b, 
	0xe80bb1f0, 0x38757004, 0xc31f11d7, 0xf01526bf, 0x0d516c99, 0x1aaba93b, 
	0x9c139f91, 0x2ea6f376, 0xc04d5304, 0x36ab27f5, 0x5eda11b1, 0x5fd4ea21, 
	0x247057c3, 0x54a92ffc, 0xa741e7e1, 0x4bf01379, 0xcf42d5af, 0x47a62e8d, 
	0x8a4ddcc2, 0x8efccb58, 0x45ba2570, 0xdf893882, 0x08fb0c53, 0xc059aa0d, 
	0xdff099ef, 0x999f011b, 0xd625a176, 0x55e33cc2, 0x085efea1, 0x08022943, 
	0xccd5f3e3, 0x7253a036, 0xb1fcea96, 0x2d32da0d, 0x7d3d7b7f, 0xd0136ce2, 
	0x442ac135, 0xda73c803, 0x03d2729a, 0xf4cf513b, 0xbd683e11, 0xdfc34980, 
	0xdf850eb6, 0x3799b2ec, 0xdc1477fd, 0xe83d0f4e, 0x13efe44d, 0x27cf0482, 
	0xbcf8c0d6, 0x56bfc415, 0xbae0e445, 0xb14ea52d, 0xabad8c31, 0xb60f6361, 
	0xd095b780, 0xf509847a, 0x8e94f085, 0x9a2d7a45, 0x95e88530, 0xe2c6d5ea, 
	0x9f5fc8ef, 0x16f57f01, 0x072c0d68, 0x31bcc18a, 0x6e8977c2, 0xe77c40cd, 
	0x3c58bc64, 0x97ea58ea, 0xe09bccba, 0x7c4e8f7b, 0xc17f1155, 0xa6e373be, 
	0x824fd41e, 0xfa924de6, 0x5b9f2936, 0x911d0f5d, 0x43b7a87c, 0x4c99caf8, 
	0x79c3a47c, 0xe1d57ca5, 0xc470423c, 0xe7ae17f2, 0xdf14310b, 0x448d5f3a, 
	0x3bf1bb3a, 0x8346e482, 0xf85df487, 0x187c208e, 0x4fcb1fa8, 0x4d0705c6, 
	0x2d2448f0, 0xa15b37af, 0x99a1594d, 0xe3bd1e91, 0x1f7a855b, 0x7a65280c, 
	0x6fc404e1, 0x778fa041, 0x197bba18, 0xd020c48e, 0xfd2863ad, 0x22b0aa6d, 
	0x308313be, 0xfdaddb0e, 0xb5c83306, 0x163158e8, 0x42e1bde1, 0xe325e132, 
	0xa9ad0747, 0xbfc74046, 0xa0b2927a, 0xc1e6fd1d, 0xed681ca4, 0xf39279ef, 
	0xfdfecda1, 0xd069e4c1, 0x8ff5365a, 0xf4229b15, 0xd3a69de8, 0x89cc185d, 
	0x05d2f651, 0x32e01076, 0x23cfdd23, 0xcddd301f, 0xd7c91741, 0x08fb13a3, 
	0xd020e6df, 0x11c696bd, 0x950bd3dd, 0xa1876dc9, 0x3b4557cd, 0xa59e9fc0, 
	0x60960e4c, 0x01efe6ab, 0x554f4979, 0x6802f345, 0x6b6984cb, 0xe6edb603, 
	0xda0b797f, 0x5b0dab6f, 0x5f31be01, 0x67d4345a, 0xa02269dd, 0x9f29495a, 
	0xe893ba79, 0x8b30f841, 0x974f33f6, 0xea8df547, 0xcf41a699, 0xd96633d5, 
	0xd98efc47, 0x5ead0224, 0x037387b4, 0xd293c456, 0xc1bc406e, 0x8a8344a7, 
	0x9a18aef2, 0x9bcf92c2, 0x16a7bed1, 0xac891f99, 0xf03bec9f, 0xfadce259, 
	0xf7b02e29, 0x6e114caf, 0xfe217edd, 0x61091666, 0x57e514fa, 0xe8bb34ed, 
	0xf0d19dfb, 0x037cf98c, 0x48efef7d, 0xfac886ef, 0xfbe01412, 0x70f850e0, 
	0x09bfd43e, 0x6a0c0bfd, 0xb07bce26, 0x7de609b3, 0x08b337c2, 0x07e00efd, 
	0xf1063a83, 0x90e9fc0d, 0x7a8e41e3, 0x9127f9f1, 0x9eeffae7, 0x0d7df82a, 
	0xc1fe0efe, 0x36efc8ee, 0x18bb23e0, 0xe74efe46, 0xeaf9a398, 0x660fe5ca, 
	0xb96afd06, 0x273f3556, 0x881d3e24, 0x7a82cd0f, 0x416f561c, 0xcce404bf, 
	0xd7237642, 0xc167cfa0, 0x333975f9, 0x471db666, 0x59bdea3e, 0xf5d23925, 
	0xd10170ae, 0x7c395c61, 0xf91bdf13, 0x1472b093, 0xb95930e5, 0xbe3f576d, 
	0x8c2a8c2d, 0xaf09b64b, 0xb1d01cf1, 0x0f13785c, 0xde25ab50, 0x4817a11f, 
	0x4f0897f8, 0xc256f01e, 0x483928b9, 0x54f7d20c, 0x9b4d1545, 0x09b1e6a3, 
	0x442058c5, 0x524ba4b1, 0xf8d528f9, 0xa506b600, 0xbe4a37b1, 0xff49727b, 
	0x2d6f910e, 0x67b6e59b, 0xf746c34a, 0x25c6f950, 0xacd9fbf0, 0x619a2c07, 
	0xc75efe1f, 0xf0efbdf2, 0x548fa94c, 0x6efc2f63, 0x63aff8f9, 0xf7048301, 
	0xbf23aff1, 0x9bcc533d, 0xb5bf28c2, 0x3dbf2445, 0x75b7a4b9, 0xe00efdf9, 
	0x0b70a82a, 0xcef89b6e, 0x4195edbd, 0xaa77fb58, 0xdf0ad154, 0xb159bbcf, 
	0xf10b7d6f, 0x307efdee, 0xdd86fa87, 0x7cefb1f3, 0x30b199fe, 0x3bed09ee, 
	0x556c62c1, 0x6fdf1fb1, 0xfdcdb552, 0xc1cbdf04, 0xfc4e3889, 0x67f70b76, 
	0xddff70b7, 0xd73f6c2d, 0xe1189e6f, 0x431c84af, 0xe11c39aa, 0x4e6984cf, 
	0x39fe4083, 0xc77e419d, 0x081297c6, 0x63ce372f, 0xfbfa88ba, 0x2763f7e8, 
	0x085fa4b3, 0xeff81ffa, 0xdc737995, 0x7f9a0e9e, 0xf01dd131, 0xe6ba0011, 
	0x41374201, 0x463c0d3b, 0x2bc9f003, 0xf6ee3d2f, 0x49fbe9b8, 0xe53cbdf8, 
	0x4c298168, 0x4f7a14fd, 0x10da7c69, 0x0339f6a6, 0x4f34ebc8, 0x98064bfb, 
	0xa00691f7, 0x7f7e97bf, 0xc57f7f11, 0xa57bdfcf, 0x3b6e71ee, 0x447b710e, 
	0xd10ea7b6, 0x03c91e77, 0xf783eebd, 0x2dd7e13c, 0x99af824e, 0xb1a0bbbe, 
	0x2c77e04e, 0xe48dc3e6, 0xc84969a7, 0x7b7cafef, 0x4af7bd0e, 0xcaf9c303, 
	0x47ff394e, 0x8bbede72, 0xe0bf1adc, 0x1e0beb36, 0xddf65937, 0x0f183385, 
	0xe56fad2a, 0xa04e7be2, 0xcb7b53ff, 0x2f9127c3, 0x7b7cbed6, 0xbf7bf110, 
	0xc813f9ef, 0x6a280f37, 0xf7b20ab2, 0x8b5f41e0, 0xfdd6f415, 0x05505aa9, 
	0x9335eab8, 0x07fdc705, 0xf40d84f0, 0x3c1f63e4, 0xf080f16e, 0xa8fa7e3d, 
	0x53a9e705, 0x1758a71b, 0x403d1ea2, 0x27f4877a, 0x60bdf7cc, 0x9efc14f1, 
	0xd2bd271e, 0x93277060, 0x28a92bdc, 0x876caf07, 0x96b1f13e, 0x1effff8a, 
	0x09f6d5d0, 0x053477be, 0x37986efd, 0xa2b5e705, 0xf2939e3c, 0x27822079, 
	0xb8ddbdf8, 0x9aa9e88f, 0x2c5d6e50, 0xa156c9ff, 0xa82b78e1, 0x5a01cb0f, 
	0xc01ce9bf, 0xe59580fb, 0x966bc616, 0x25af1a7c, 0xa6f1e39e, 0x49c7a202, 
	0xe7bc3ba4, 0x77efc0b5, 0x19c37088, 0xb8b40a03, 0xea0027a5, 0xe30ef908, 
	0x21917b0a, 0xaa1ee300, 0x16daa537, 0xc5a91ca2, 0x734dbf88, 0xeb88ddee, 
	0xe74af9d5, 0x003f9d43, 0xa3eaa35e, 0xf98d79ef, 0xf3b2fc51, 0xd3a37cd2, 
	0x803be753, 0xe1b8414f, 0x8bc1125f, 0xf08aa878, 0xa2d81257, 0xb98bc006, 
	0x112234c4, 0x17ef27c6, 0xf180b561, 0x2a4dfec0, 0xa77cd3e9, 0x0de501b3, 
	0xfae277de, 0x7159a155, 0x0d2f783e, 0x7d014bdf, 0x7526f389, 0xf1b0dcbc, 
	0x816ff07a, 0x825e4dff, 0xdf27e49f, 0xde8d7e19, 0x181d7c47, 0xbe3a472a, 
	0xa6aa9f41, 0xf9f861fc, 0xf92c7c72, 0xfe13cd37, 0x4230e50c, 0xf867e627, 
	0x3c6166ae, 0x1035f724, 0x8d68a51f, 0x4c275fcc, 0xdc9d57cc, 0xfb9a711f, 
	0x2ad4c223, 0x4fdc3d69, 0x23e7e3eb, 0x523fb9fb, 0xb14e0723, 0xdf53309d, 
	0xf4fdc9d6, 0x0f4fdcd3, 0xf464ab53, 0x8fa33f70, 0x73f6679f, 0x9a7b533f, 
	0x122759fa, 0xc9d59fa8, 0xa9a751fd, 0x89f51e1f, 0xfff37d4a, 0x855f200b, 
	0x7f2177e7, 0xba9f80d9, 0x7248f222, 0x99a8f24a, 0x0ad813d4, 0x7efdd233, 
	0xe424d1ef, 0x1db707af, 0x3380160a, 0x7b9bf0f3, 0xeb4e5053, 0x29639bdf, 
	0xffd67980, 0x10a590fe, 0x49d152fd, 0xf284d67c, 0xb95c340b, 0xc6127564, 
	0x214566e9, 0x5a2b36f9, 0x59b5ca32, 0xe3e83bca, 0xe3c50340, 0xa17180c2, 
	0x36c309b0, 0xdf920bd4, 0x90997b75, 0xb61834ef, 0x19b3f445, 0xa877b5f5, 
	0x5ead167e, 0x92381fea, 0xd357e034, 0xcfa97cf8, 0xcd8e9ea5, 0x857ee81f, 
	0x219f4c79, 0x45fe8039, 0xbdf13ce1, 0xf9d23928, 0xd6df4627, 0xd6060d9a, 
	0xf21c629b, 0x77bbeaf5, 0xff91b09c, 0x3f438ca1, 0xc9af7eee, 0xd67c4362, 
	0x5e505b16, 0xb46bac1f, 0x8f7e48d8, 0x0fa86c5a, 0x5f7c849b, 0x22f0871d, 
	0x6d7df9fe, 0xb52ffa1c, 0x9c9144a3, 0x5ff4bc7f, 0x7f3e4bc6, 0xef4c3d3a, 
	0xd2e7fde9, 0x78def4bd, 0x5f471fb6, 0xd9ad7ec4, 0x0137c3a8, 0xf05dafe7, 
	0xe71b49f8, 0xfcd02615, 0x9fdf03a9, 0x463f7a40, 0x137cc3df, 0x778d2b34, 
	0x7356a09e, 0xb91f8276, 0x7d63e81a, 0x789f7e84, 0x489f7f9a, 0x7b9f05df, 
	0x87f49554, 0x72fa97ee, 0x8ccfeb3b, 0x0ceb962a, 0xaded5792, 0xab962ed6, 
	0x5fa3964c, 0x3f5886b4, 0x639fa325, 0x18021837, 0xcc3f494f, 0xa938c9a6, 
	0x4f48d35e, 0x79cd5c60, 0xad77f21b, 0x59371eaa, 0xcc01fa85, 0x342824be, 
	0x42fdfbe4, 0x01697d43, 0x6ce913e7, 0xd8af5d1e, 0xc15a0e51, 0x513e0385, 
	0x5efc4d72, 0xab163f8c, 0x41d8873f, 0xfa110fc9, 0x54ea7d31, 0x1fd837a6, 
	0x95fdf7a2, 0x5a6b0fcc, 0x70ffa91b, 0xc48b51db, 0x8fe478ff, 0xfc0192da, 
	0xffa18f8f, 0x88cfa278, 0xfd13fa01, 0x9a38af56, 0xe98bf924, 0xa65f4037, 
	0xf88bd21f, 0x3294c4bd, 0x3843f89a, 0x36fa8fb1, 0x2cc1f88b, 0x1e4e2bc7, 
	0xdea53aaf, 0xfccd1d4d, 0x5f87c723, 0x0359f1a3, 0xfc489beb, 0xdd0ddba1, 
	0xf1bb48ce, 0x01f8e1d3, 0xef8bcce4, 0xf93cc067, 0x55924f3c, 0x79f23338, 
	0x109f4a7c, 0x7d61aa23, 0x6da93cf0, 0x9516d183, 0x1ee5d247, 0xbd29abc6, 
	0x47b74f92, 0xecc80bf8, 0xfec03ccc, 0x51db0672, 0xe481466f, 0xfbd63ecb, 
	0xbd743f68, 0xc993ebad, 0x16f87dd7, 0xcfe037ea, 0x173c2270, 0x53d90356, 
	0x22abaff2, 0x8dfe2774, 0xa780fbb2, 0x848ddeec, 0x529fb187, 0x82fd8eab, 
	0x36c739fb, 0x97e73f51, 0x9c0f589b, 0xdfb8fee2, 0x39fc7f71, 0xe5ef8fee, 
	0xb94f84fe, 0xee0be13f, 0x99058f3b, 0x320cbf0e, 0xfb414f9e, 0x299fba3f, 
	0xc3bf89d4, 0xc105ebdf, 0xdaa9dd99, 0x29cd8f51, 0x14fd24ea, 0xe256abb1, 
	0xc24edd63, 0x5bae05fa, 0x4e244f5f, 0x1db27581, 0xebba46cb, 0x95e80df6, 
	0x51eb47dd, 0x5227f6c6, 0xf046ac7f, 0x2c273929, 0xe4e9cfd4, 0xdcd3b8fe, 
	0x30b6171f, 0x7f70f71f, 0x9f3f1f7c, 0x61fdcfd0, 0xbeac46f5, 0x81817b20, 
	0x79209d55, 0xb494e9d7, 0x5437b45f, 0x122cdf91, 0xfcefde00, 0xe3104f61, 
	0x4d97f83b, 0xaf7f0efa, 0x65b2f9a2, 0xa86e557c, 0xb4e8e6fa, 0x4c3e807a, 
	0xe9cf5c2f, 0xcaf820e0, 0xbe18e70d, 0x0e6fc49e, 0x06b811bf, 0xb890e1cb, 
	0xd92644fb, 0x771aafc9, 0xdff391cf, 0x0637c7fb, 0x2692bde5, 0x3cc62a4d, 
	0x53710406, 0xb276be28, 0xb3efbebe, 0xb0c794f5, 0x59b11780, 0x271b5dc6, 
	0xc5a9f8e2, 0xc4b85f98, 0x8f0647f8, 0x7e78319f, 0xed78ec5b, 0xdfc78387, 
	0xf77ff340, 0xdf7837cb, 0x171087e4, 0xd81e2838, 0x752e3d1a, 0x0f719083, 
	0xd3335ff0, 0x6fc6dcef, 0xfc228f8e, 0xfc1ce523, 0x9f406dd6, 0x2445e529, 
	0x753d3ae7, 0x7a75e87d, 0x9f880997, 0x01106f53, 0xf4b67709, 0x3e51be73, 
	0xdb98832b, 0x0067cd16, 0xe4976b77, 0x447b8037, 0x3ef48193, 0x05b8a38e, 
	0x392116f3, 0xd565f88e, 0xf644fa60, 0xf8c80eb5, 0xa1f1d25d, 0xffd4e338, 
	0x07ce3d13, 0xc3e8a73e, 0x6889793c, 0xf2798f9e, 0x8233ea63, 0x6f52e2f3, 
	0x34aff7d0, 0x1b794e0f, 0x66be7447, 0x2d7c5e70, 0x2f2a2bae, 0xb0fdc06e, 
	0x939df92e, 0xe3a07df2, 0x9b14612c, 0x6efd0fce, 0x184f33a2, 0xccba79e1, 
	0xca78c0f7, 0x33cb98cb, 0xeb137f29, 0x3972ccf7, 0x1a618dcd, 0xd7bd7a4f, 
	0xbf13a9ed, 0xfce26e46, 0x9201da30, 0x18e7e96f, 0xad4044f3, 0x1daa6211, 
	0xc798677d, 0x866c71ca, 0x043acf6e, 0x0d85f7ef, 0x8c6c9fba, 0xf362a3f6, 
	0x3d5cb3d1, 0xfbf007af, 0xbc60a16e, 0x91b36bd5, 0x0696a59f, 0xfa0689c5, 
	0xcf0896ae, 0xf9b69cd3, 0x43021996, 0xc473dcf3, 0x1f6e6a2f, 0x305f79b7, 
	0x631fe7bf, 0x97ff23bf, 0x4e936f2c, 0xefd27f71, 0x1cf93fb8, 0x36f727f7, 
	0xc5a61e53, 0x275d9300, 0x7ee2e44e, 0xc9458151, 0xffc950eb, 0x331af5a3, 
	0x4e501b5a, 0x376d3f8c, 0xfd253852, 0xab49aac3, 0x88c2c355, 0xd88a275f, 
	0x3d4833af, 0xb129d3a8, 0x12b3f780, 0x1e3f1e90, 0x9b8aa74a, 0xb0e6b695, 
	0xef3c0ba4, 0x815bba03, 0xc1aebdee, 0xfb944ff8, 0xc45eb862, 0xb7cc4cd7, 
	0x200bfe02, 0x893dc55e, 0x7cfc69c4, 0x3029dbb3, 0x679e8b9f, 0x5fe17e34, 
	0x08e62f6e, 0xe5f003ad, 0x3556efd1, 0xeb25c78f, 0xe16bf97a, 0x75e52c31, 
	0x6dcc68b3, 0xf8295905, 0xdc4ac2f1, 0x89704bbf, 0x35d6244a, 0x2cebfeab, 
	0x69dd77c6, 0x30bdcfa0, 0xfa29ec0e, 0xf54e094f, 0x246746cc, 0x78c667cf, 
	0x07bf86cd, 0xcfdaeccf, 0x68628b7c, 0x3ef783cc, 0xe3f7fc96, 0x1aeafe28, 
	0x925ebbc8, 0x93f2e2bf, 0x55e9f80b, 0xfa498f5a, 0x9ba426fd, 0xd1bb5471, 
	0x49fa0485, 0x0fba0378, 0xb152f2b1, 0x159e2bde, 0x709fe943, 0x4e995083, 
	0x2af7d49a, 0xaac2bfc5, 0x3899dc51, 0x6fb8285f, 0xef05718d, 0x6d86aa57, 
	0x408e525d, 0xe012127e, 0xf45173f9, 0x836d7a06, 0x837f8971, 0xd9f714f0, 
	0xf401ef71, 0xc73e0250, 0x81bf74c4, 0x7c04dae2, 0x87be4f3e, 0x5f3d4bbf, 
	0x068a74e8, 0x7c08f7c0, 0xbdea2eaf, 0xf2987898, 0x4c1e38cd, 0xbe3cf180, 
	0x04615ed7, 0x6f9158fc, 0x1e863f19, 0x45fe50eb, 0x2bd689fe, 0xedf00abd, 
	0xa5be119d, 0xda79d8fc, 0xa0a8377f, 0xdbb8b7f7, 0x707f425f, 0x9d8930b3, 
	0x092f9807, 0x294f98ef, 0xf09ee782, 0xdc7798eb, 0xd68b72ec, 0x9c63e60e, 
	0xedb179df, 0x5961eb05, 0xf29e705f, 0xbfb895bb, 0xa8249051, 0xc78b604e, 
	0x9da181fb, 0xd9db9ef0, 0x9509fb4c, 0xba1787e8, 0x7e435ffa, 0x77f0f66b, 
	0x384558b7, 0xf79bbf89, 0x7955fb29, 0xfe4ff31a, 0x2d1be209, 0x50d254ff, 
	0xa2539f3e, 0x6f521fc7, 0x949ae35c, 0x89d7c514, 0xc701eeb2, 0xa67d0265, 
	0xf40a5c62, 0x6c26de7a, 0x6f3e7f18, 0xf814b615, 0xff7704ee, 0x4524d74b, 
	0xd1eb35f3, 0xb1d7cbaf, 0x1f1e317a, 0x4094daf7, 0x6699afd3, 0xbb01bff8, 
	0xea156b63, 0x105c88f2, 0x578167dc, 0x1fc93e30, 0x3219f7ca, 0x7194cece, 
	0x05c62f76, 0xd5ff99cb, 0xe30df864, 0x356a2aeb, 0x3d469f8c, 0x457ed4e1, 
	0x5bc76960, 0x2714ae29, 0x2adf815a, 0x0d561ed2, 0x0028bfb8, 0xff793bae, 
	0x137ca54a, 0x8e6b35db, 0x6aeb8118, 0x7d4a8ed7, 0xec8bf605, 0xc021db1e, 
	0xe0ba9b5b, 0x6adee40a, 0x8b3eb41f, 0xbcc06ce2, 0xf88de10e, 0x95fc4acb, 
	0x5be73226, 0x7670c4ba, 0xfd87b72b, 0x8e3edc92, 0xadfaf22f, 0x274df3c3, 
	0xe69d27f7, 0xbf30a4fe, 0xfb87b93f, 0xac4e4993, 0x0c56fdba, 0x0bd305a7, 
	0xb88d73f7, 0x4aeb8f0b, 0x65541b56, 0x6b103fa8, 0xffee8657, 0x3927bdb2, 
	0x7ed4319c, 0xf0977ae8, 0xb7c710bb, 0xe272699f, 0x8f04c064, 0x2062e245, 
	0x0c33e527, 0xfcc04a62, 0x03578d11, 0xdcbd688e, 0x2ba7667e, 0xbc29ef4a, 
	0xd928159f, 0x22f1c255, 0x8efc8fd3, 0x1dc3cbaa, 0x3afa5fcb, 0xea5f71d2, 
	0xa5bbe0df, 0x7457a439, 0x95aa62bf, 0x1974b2e3, 0x53aec667, 0xcfb237e7, 
	0x59faa18e, 0x6ba80f87, 0xb08efce7, 0x1e32bc13, 0x957c1cbf, 0xc7ac1f08, 
	0xbd700e5b, 0x273ae12a, 0x4b3f42e1, 0xcbd283e6, 0x6bdeff39, 0x50fac39b, 
	0xe309a1cc, 0xb9a98dd9, 0xefbced25, 0xdc7039a5, 0xbb717754, 0xd813f791, 
	0x1c5404bb, 0x9bff100b, 0x936d097f, 0x086c4c55, 0x0e2cbd23, 0x33b533b4, 
	0xafa81d1b, 0xe47de06b, 0x4fb9a997, 0x8efd53b4, 0x3cbd0e67, 0x11cd66f5, 
	0x86aeb900, 0x4d79f0f9, 0xa981db3e, 0x05dbc7ee, 0x18bb3fee, 0xb6c7103e, 
	0x89ff8066, 0xb8d9c5ae, 0x42e6f13f, 0xa27a07ae, 0xc5e4f008, 0x5e607556, 
	0x7ce4d6b5, 0x2131fb6d, 0x31ba7c1e, 0x2136c777, 0xaf9d1936, 0xaefe82b5, 
	0xd0c01058, 0x05965449, 0xfe38f584, 0xe5b2d1de, 0x28476806, 0x2e395b55, 
	0x5c99edba, 0x336fa7f0, 0xb9589c50, 0x044d64ca, 0xe4e6563c, 0xdd0366bd, 
	0x02b7e8f9, 0x42e999b9, 0x2276bbac, 0xe46febf5, 0xb97363fe, 0x36e17ebf, 
	0x7cb7afea, 0x275db5eb, 0x77f25e49, 0x29f45f40, 0xab67686d, 0xff28994f, 
	0x08356feb, 0xeacfd823, 0x686ddd69, 0x73ad7c27, 0x876a6dde, 0xa5329cef, 
	0x803ac324, 0xf049ed54, 0x4616677f, 0x1f50d9ea, 0x78fdd9ae, 0xf7e1ca1b, 
	0x090c5c76, 0x766b37b0, 0x1e63b5ee, 0x47c326b7, 0x6506eafd, 0x5bdf0a8f, 
	0x51ff6e63, 0x26bfd610, 0xb33cf555, 0xe72cda1d, 0xf3c3353f, 0x1176c695, 
	0xbcae3c04, 0x3ae543ed, 0x6d161f8e, 0x110609fe, 0xafbce581, 0xa3aaa1ab, 
	0x8f8c29e7, 0xc179f04f, 0xea34e504, 0x811d685d, 0x50ee7c06, 0xe045cf8d, 
	0xe994a6ba, 0xea9dad80, 0xe5ffc06f, 0x97b72eb8, 0xcf6935fd, 0xac1faabe, 
	0x7681ee4d, 0x27de28cd, 0x49f716c5, 0x0b7824d7, 0x3b416f83, 0xfac38c42, 
	0xb49335a5, 0xf0cf3f9f, 0xbda6dffe, 0x2b480042, 0x53fd605b, 0x6f6faa47, 
	0x51d6474d, 0xd7877f3e, 0x3cd9fdbb, 0x61ebbf18, 0x4adfca07, 0x16cef3a3, 
	0x63a98be0, 0x9acbc254, 0xf21f6d34, 0x8de3d4cd, 0xc9d3db65, 0xabbc7cde, 
	0x88d1e49e, 0xe4c137fc, 0xf3495b38, 0xbd3c6fa8, 0xbf0bdf0f, 0x39e22cf8, 
	0xdcf13d4d, 0xdeef7a76, 0xa5bef8dd, 0x31b6cf69, 0xeb943e38, 0x0bdaf1a3, 
	0x56a1af5b, 0x843555da, 0xe59ae2fe, 0x0ce5c67f, 0xee692dc4, 0x7cf7f24c, 
	0x2c3cf095, 0x061380ed, 0xef49d874, 0xaeecf12b, 0x1a7aa14d, 0x5f78eb70, 
	0xa0ffee5f, 0xa23d471e, 0x7036eff4, 0xf526805d, 0xce1d8c7b, 0xb8764fda, 
	0x5ff786f2, 0x55d0fdc0, 0x8b38edb7, 0xca99597c, 0x916c7872, 0x08fb6310, 
	0x3ce1a2af, 0xc97c4fd6, 0xd439eb7c, 0xf3ab7c89, 0xd35b6c41, 0x1f1b026f, 
	0xe22f97e9, 0x2eb624fc, 0x7f0d97e0, 0x366a98bc, 0xa594f109, 0x3810b530, 
	0x57ee52af, 0x8399a5aa, 0x3167bbde, 0xf24841cb, 0xe68a75d9, 0xadc4bf40, 
	0x0e10f21a, 0xd93b4ff8, 0x04652355, 0x069bf007, 0x0be25c7e, 0x4306e740, 
	0xf12bd1aa, 0xdda8713b, 0xe1f4b19d, 0x47419bbc, 0x89fdf75e, 0xbade3167, 
	0x14fdf4b6, 0x4219a794, 0xf7826d49, 0x238552aa, 0x91f09010, 0xa43aac7f, 
	0x3f40ec7f, 0x5a2ad9b5, 0x9956ff31, 0x1149fd23, 0x8575454c, 0x873c77e3, 
	0x0f66a07e, 0x7d543e92, 0xe7cf7841, 0x3d61cf7a, 0x075efe4b, 0xcf0f47c6, 
	0x4b5575e7, 0x108b71ff, 0x7df8069d, 0x03f1b84b, 0xe59b0bf4, 0xc78d79be, 
	0xffe504b4, 0x4a94ae89, 0x5bbefb8c, 0x8d58f1ca, 0x49fc98a7, 0x006d43f4, 
	0x9da96f77, 0x229309e2, 0x92bd44ed, 0xd209fb4d, 0x25f6e89e, 0xd1789ed6, 
	0x3b49773e, 0xfb50eaf2, 0xce2072b0, 0xbafd7853, 0x4eb851fd, 0xc701e204, 
	0x3487f636, 0xe0a3f755, 0xc00b2b7b, 0x9598c0ee, 0xea2add65, 0xb7cb832b, 
	0x68e8fd0b, 0x01ac733b, 0x4dad00fd, 0xcdf05905, 0xe746743e, 0x6abb8c2b, 
	0x14155e60, 0xfc0a6fb7, 0x04ed1fbe, 0x3c73e1f0, 0x68fd99ee, 0x47cfb7df, 
	0x8b34eefb, 0x0a26ffd0, 0x695a3591, 0x5476ff43, 0x5b1d9153, 0xef8a8f9d, 
	0x5bd23e62, 0xf8819b7f, 0x67b2502c, 0xdf786afe, 0xafc3a3ff, 0x24011d25, 
	0xaca8d8dd, 0x55be3d46, 0xf241dea9, 0x667f6cab, 0x66eefc32, 0x44b5de7e, 
	0xaf40d588, 0xec5be651, 0xcec917a8, 0x93deb3e6, 0x713085fe, 0xfcaaf67e, 
	0xf096c7b3, 0x3f20ffbe, 0x0970842d, 0xeb64e50d, 0x0011d052, 0x7984b4c7, 
	0xb61f302b, 0x88cff46a, 0xbb6eabca, 0xb5c62cfd, 0x05f54afe, 0x4e381bcc, 
	0xd056d928, 0x9f25e777, 0xb4109c15, 0x8e6a500e, 0x0d37181e, 0xf05a8ee2, 
	0xffefae07, 0x98fb51d2, 0x1f7177f4, 0x45ebc802, 0xda8e793c, 0x5f51d805, 
	0x2dea91bd, 0x08ca17af, 0x0bfdd037, 0x0eb0cbf4, 0xf088b12e, 0x43613ddd, 
	0x541006c8, 0x6e6d36cf, 0x6b35bd05, 0xea1dd731, 0x8535c7f5, 0x27a03720, 
	0x715eb2fd, 0xf9c9c957, 0xa3778029, 0xbc23644d, 0xecd26e13, 0x279bf001, 
	0xfc98adfc, 0x45fd9a81, 0x2bc80523, 0xed03ba08, 0xec64afa7, 0x3e31446f, 
	0xc2a6da3f, 0x8d197cf7, 0x4a3aca37, 0x3a89063b, 0x4c2854bf, 0x394b4da7, 
	0xb8d871de, 0x6f3abd7f, 0x5df01f44, 0x86d69975, 0xdecdf0f4, 0xf1b3aa11, 
	0xceb815b8, 0x46fdfe8f, 0xbfbdf00f, 0x8d6e73ef, 0x33d1bd7f, 0x2bfde103, 
	0xbecb27f7, 0xfa87b67b, 0x6dfb64f3, 0xbf77f168, 0xa7add7ec, 0xa5075236, 
	0x0c7d469c, 0xf184337a, 0x4dea0d58, 0x16adcfc0, 0xc0da7fd3, 0x04dfacfe, 
	0xad4607f6, 0x0f7e1ddf, 0x87faf6ed, 0x06785fda, 0x4ebf5de0, 0xf6c2dcd9, 
	0xa75b37e6, 0x158e9d00, 0xfee6ecf5, 0x0aa6679a, 0xc048e4f1, 0x416c59d7, 
	0xf57e211e, 0xb4766965, 0x20a9d51b, 0x1dfc062f, 0xea3ce4f8, 0x7c1fa01b, 
	0xb63fc9e0, 0x7eb0dc38, 0x038b4f5f, 0xb7bf01f7, 0xfd8de417, 0x0d701492, 
	0xd634d944, 0x736b603f, 0xddfa8f51, 0x8ba43ca6, 0x34ef8a6f, 0x94df43ea, 
	0x83e421bd, 0xc50463a9, 0x07e97e8f, 0x7cce5b2c, 0x1fa2dd15, 0x7acdd4b0, 
	0x462ac0bc, 0xe983fea0, 0x847dd6c3, 0x50e6968f, 0xa2597c64, 0x961f9150, 
	0x0b6dbaac, 0x5ce6cff2, 0xc456dbe0, 0xf64fc307, 0xb3da492c, 0x16cf690a, 
	0xf0067b4a, 0xc98cabfb, 0xcd7f9836, 0x7e2fb652, 0xde82a7a9, 0xb7300723, 
	0x7cf2915e, 0x2a5aeb08, 0xd6a1ab16, 0xf8ba1105, 0x476fa1b3, 0x13aa0b7c, 
	0x1f3f27f4, 0xfd70ff42, 0x18eda126, 0xf30e7ac5, 0x86ded5ba, 0x5fcc2b24, 
	0x1ff38236, 0x9c59df30, 0x3bcae82f, 0xe832f68a, 0x3dac229d, 0x795bcf80, 
	0xa126153d, 0xf4d49ca1, 0xf2897e83, 0xcade5693, 0xb42770f2, 0xae73802e, 
	0x18faf402, 0x521695ed, 0xd05f802d, 0xec76d1cb, 0x1e409ea6, 0x0f4af5ea, 
	0xe7942dd8, 0x891a29ff, 0xbee6ec76, 0x0af764c3, 0x4fe50cbf, 0x69527d06, 
	0x3a40ea3b, 0x91d42cdd, 0x85ef204d, 0x4891ccee, 0x401bf5a7, 0xf98f406e, 
	0x768ffc65, 0xf1e70dab, 0x3e424bce, 0xba0ae1d0, 0x5a8bef7d, 0x1165d780, 
	0xb6fb18c6, 0x47f9842d, 0x00859f96, 0xfd0eafb7, 0xbd07f62a, 0x48aa68e2, 
	0x768fbd62, 0x29a4bab0, 0x06f306cd, 0x3e3fc0ad, 0x0b768718, 0xbfec1de8, 
	0x4eba3729, 0x39b89a7e, 0xf3ae3a25, 0xfa07528a, 0xded741ef, 0x18d7a40a, 
	0x61ac4997, 0x65fe8e7f, 0xf677b7c2, 0x0ad7fa47, 0x3d4b5765, 0x35e085e7, 
	0xc6daf331, 0x1c81d65f, 0x4db13f4d, 0x48ea7f60, 0x11396211, 0xd8f90d0d, 
	0xa6ec8ed7, 0xf06314f9, 0x9e17e45b, 0x82d7fd94, 0x48760cff, 0xf1c0dc3d, 
	0x75809a8c, 0x7ff6d77d, 0x59786769, 0xc8efe20f, 0x75471067, 0x765f9da0, 
	0x7ebca08b, 0xe334e8a6, 0x8846ab3a, 0xf03fd0bb, 0x045486a9, 0x01bd7460, 
	0x9ff00073, 0x5d697227, 0x017c94fb, 0x7dbd35f2, 0x0b208bd6, 0x76f96b02, 
	0xb36fad46, 0x41ddcd49, 0x5e8c51eb, 0x7b57f915, 0xfb9fa5b6, 0xbf608d2a, 
	0xf32a7571, 0xd18f9eb5, 0xfeb1fbf7, 0xfca35559, 0x3df80f1e, 0xf80cc710, 
	0xdcf2f18d, 0x40e37e31, 0xa1fa46be, 0x114979b1, 0x017e37e3, 0x69fac9f6, 
	0x3f247fc4, 0x49c69d29, 0xa4b9433f, 0xfba1519f, 0x7ec1d619, 0x45ff50c6, 
	0xf17fd1d8, 0x83ff457e, 0xc3806ce2, 0x510ffd2b, 0x3f94a9af, 0x447fe388, 
	0x210ddbfc, 0x3b6aaf94, 0xfe78e9eb, 0xdbfd0fad, 0x942ef928, 0xf4a16dfe, 
	0xb559af6f, 0xe5f9442c, 0x021d0fe4, 0xd6a6b3f8, 0x7ea7e341, 0xfea7f58b, 
	0xbc608fde, 0x4a25ef02, 0x1c66b97b, 0xe75819e8, 0x59e20506, 0xf50a87de, 
	0x9fa05f23, 0x3f4479fb, 0xc0e6ab08, 0x44336a3c, 0xe96aa6b5, 0x5f9256ef, 
	0x4c6eb029, 0xfd0157df, 0x82a8f942, 0xf9c1d524, 0x068dbcc6, 0x583f50e7, 
	0x60b6438f, 0xceeb1682, 0x42779cec, 0xf100d53f, 0x9ef5dfa8, 0xfafd9c5d, 
	0x5d2c4971, 0x729c6ebf, 0x42d2b24d, 0xc1fa3ef1, 0x5f0dddf0, 0x8edf91e4, 
	0x99e22ffe, 0x57e817e2, 0x31676b27, 0x67e4f55f, 0xd1b9e78f, 0x1e5a2ac0, 
	0x928aa7ce, 0x03876849, 0xe5270a63, 0xf68d5c00, 0x67a849a6, 0xfde17f89, 
	0xbe59f3b5, 0xef878fc9, 0x77e0ecf8, 0x076edfa3, 0xe7443b3f, 0xefb84293, 
	0x3a605d55, 0xfa07f3ab, 0x91b37e1d, 0xf417acf4, 0xbcc7c77a, 0xf321dcef, 
	0xcf941d7e, 0xb01d0256, 0xc817cfce, 0x7eb63938, 0xda1df82b, 0xedea7e87, 
	0x98cf8c71, 0xe70ead3a, 0x1d60b727, 0xbd1fbeb1, 0x748b83fe, 0xdae7c45e, 
	0xf494e74d, 0x7ee216b8, 0x1425f3df, 0x377dfe8f, 0x26c7b1c5, 0x9ddf073c, 
	0xada81090, 0x7bfd04c8, 0x4a9b78f1, 0x10c1a7fb, 0x9d9fc77e, 0xbfaa7df9, 
	0xec6c8b37, 0x8fd972fb, 0x63998b30, 0x7ebe2e91, 0xeb04d1cd, 0x3dae0911, 
	0xbd8f0788, 0xb78a81d1, 0x35acf456, 0xe59a1e80, 0xf3163a39, 0x1fff8096, 
	0x1d03ca08, 0x1c75c6cb, 0xef5212cb, 0xb57d5094, 0xcefb81b6, 0xfc16f68b, 
	0x2f2ff5de, 0x77ce01fb, 0xdd9718c3, 0x6eb77a0d, 0x6adba836, 0x1c6b0fac, 
	0xbbf5748b, 0x349d528f, 0xeb1a7bc0, 0x797974e4, 0x979f3169, 0xf2c6513b, 
	0x75cc2bd2, 0x638fe82a, 0x26b07325, 0xe7baf45f, 0x8eadde70, 0x73fa4bf3, 
	0x608e66ad, 0x7e3aabb5, 0x6bd57207, 0xcc794d3c, 0x5915cea4, 0x9f2932c7, 
	0xf6fd20a0, 0x0d5fb197, 0xbd40e2fc, 0x3bc9e053, 0xf87c016e, 0xcc921a72, 
	0x4153686e, 0xfabec08e, 0x20871ced, 0x6b7d231f, 0x984179e0, 0xe803b9f9, 
	0xfdd3d532, 0x97808dfa, 0x5ecf9812, 0x55c79117, 0x84850ebb, 0xecc47046, 
	0x7e9c825b, 0x087b7e4c, 0x9557f9f5, 0x6dfd01af, 0x75fdfd67, 0x8b95fee3, 
	0x7185fe20, 0x8dbcb605, 0x49e62f26, 0xbfe42e98, 0x546a77c2, 0x6f688bd6, 
	0x2e506b5a, 0x6019698c, 0x3d24726f, 0x4a7ab17c, 0x222b1e00, 0xcbec89fa, 
	0x6acf7a4a, 0xb2640d5c, 0xe5f51eb3, 0xd89d9de4, 0x98c27685, 0x8af804e7, 
	0x9cf2f3ac, 0xda2e3f18, 0x1f0270e1, 0xbd632f4e, 0xc919b7ea, 0x3b67994f, 
	0x01e10e32, 0xc0dcf378, 0x2f816bf7, 0x3c917d1c, 0x18e3c602, 0x94b4ff7f, 
	0x7d5880e3, 0xf6cef247, 0x13da1c62, 0x881fbe3d, 0x13fbe5df, 0xe83d9452, 
	0x41bee2bf, 0xb5f63e4a, 0x26cfe4e3, 0x3820968b, 0x38cab321, 0x316a9c9e, 
	0x04baa69f, 0x5e91f388, 0xa0bfa45b, 0x1e60afef, 0xacc9f500, 0x36498613, 
	0xceecdef8, 0xcf5849a2, 0x54c3efa6, 0x29f7f167, 0xb947cfde, 0x7d40eade, 
	0x7c03e7ab, 0x612516f7, 0x05e5307d, 0x43fea43a, 0x0778b7bd, 0x2d6bbde9, 
	0x0affc9de, 0xe62f772f, 0x1709a0fd, 0x7284bf4f, 0x12fc7e06, 0x377e77d4, 
	0x726a09e7, 0x25061dba, 0xe560df2a, 0x46416def, 0xcc157861, 0x63d93e3f, 
	0xee7e8c9a, 0xc3e2ce96, 0xf5f52f68, 0xd0ed1c11, 0xc1de3956, 0xe434ea84, 
	0xcd7ca88f, 0x0fd80b17, 0xed8ca87e, 0x433ef561, 0xc7f82252, 0x84f2d335, 
	0x26e2fd09, 0xc36ad1d5, 0x6cf14ab8, 0xc38c8b6b, 0x25fe7ff7, 0xdd836972, 
	0xc9b07e8c, 0xafad8d98, 0x5cc931ac, 0x90a7728b, 0xb94b55dc, 0xddd87583, 
	0xcc3f0740, 0x73c0037f, 0xbfa60ef8, 0xfcc79dcf, 0xbb7def04, 0xbb2ff716, 
	0xcb5e5f5f, 0x9d20f1df, 0xa34e9b8e, 0x94bd9dfd, 0x246af0eb, 0x061e60bf, 
	0xee9d7ee5, 0x1fb3d467, 0xc42ddbac, 0xbfa5ca19, 0x7a8d97d0, 0x0695d719, 
	0xca5d9072, 0xaf6017f4, 0x0babcf91, 0xb406edbb, 0xb7e04df7, 0x79857c20, 
	0x27c00c2b, 0x23d07605, 0xae8fa83d, 0xdbf44613, 0x97141da4, 0x853ccbc9, 
	0xcbd3e8f6, 0x59ae67e7, 0x7f586db5, 0x09e5ed03, 0x841ff32f, 0x2a7f94fe, 
	0x63a13f65, 0xe7e7f821, 0x31ffb017, 0x518776e5, 0x9854c374, 0x6f78816f, 
	0x0762d4ca, 0x3bca05ea, 0xadf84525, 0x2c54041a, 0x3e18edc0, 0xd9ef897f, 
	0xde0506b0, 0xbfbaf3c3, 0x30e7c058, 0x8a0ec1ab, 0xa5bdf8dd, 0xd111910e, 
	0x545fe47f, 0xe51ef447, 0xfa860acf, 0xdfb47e9b, 0x9327a961, 0x1f943e78, 
	0x7f7173f2, 0x47eeebed, 0x8c6dfeea, 0x43fe423f, 0x717df217, 0x29f7ae1e, 
	0x215e614b, 0x2c1b0df8, 0x18875262, 0xfba1775a, 0x58fefa09, 0x87d1abb5, 
	0x035afbbf, 0x5e500714, 0x85fd092e, 0xe0bf939f, 0x1d9d342f, 0x7f42d794, 
	0xbf88b9e1, 0x1b76baa0, 0x37e946dc, 0x01bf4974, 0x694c76e4, 0xfdc17f1c, 
	0x7e6ff514, 0x0e722f20, 0xceaa22a7, 0xeec39e4d, 0xf1c78270, 0x68b3cc17, 
	0xf7538426, 0x6373f417, 0x62418a17, 0x7b7f22d7, 0xb106ff0f, 0x8c3de055, 
	0xb7e213e6, 0x08fdcb0e, 0x0b6f76a7, 0x3cdfce1b, 0xc74237b3, 0x167fcb35, 
	0x30858ecf, 0x76d57b3f, 0x19dee30c, 0x9c4fdd5f, 0x25e580b3, 0x50bb7d9e, 
	0x97fb120c, 0x258d7ac8, 0xd3845eb0, 0xf35bf2c3, 0x86adc80c, 0xaf8ca171, 
	0x1c907f24, 0xd67d4857, 0x498e543e, 0x3ca42b7e, 0x91c7230f, 0xda4cb9fd, 
	0x913d239f, 0x58ef911e, 0x45f5d679, 0x5977aa75, 0x07da0973, 0xc99f7ff5, 
	0x450ffdc0, 0xbfa3e704, 0xfb6afca2, 0xcfafe45e, 0xd527e842, 0x2fe60ce4, 
	0xfd20d99f, 0x2971c551, 0x2cb3347f, 0x5c1d7f0e, 0x17e8fe4e, 0x7f70c6db, 
	0x525a3f88, 0x828fed1a, 0xb47f261d, 0xaf97f25a, 0x7dc564ca, 0x8b7beabf, 
	0x37e08c52, 0xfe80e755, 0x17e7f8c7, 0xd619a39a, 0xd73e6db1, 0xc894d48b, 
	0x30f50fba, 0x78616fc7, 0x1f6a30be, 0x1b6f70a1, 0x0b15b5fa, 0xcfa7f62a, 
	0x89bbfdc7, 0xa09f46a7, 0xf70d833c, 0x95879f71, 0xcebec098, 0x3bdb7b7a, 
	0x6f14dfc8, 0x77f1237b, 0xc9117b41, 0x47cbf033, 0x6f59df48, 0xf688bfa7, 
	0x70e34af0, 0xc6aad7c0, 0xf7fb11bd, 0x98101dbc, 0xda1f351f, 0xced293f3, 
	0xfcf6939f, 0x93bec440, 0xc9173d7d, 0xfb4b554b, 0x279ab019, 0x9da4badb, 
	0x9f99193d, 0xf63ef0ec, 0xf47e1033, 0xd8fb4c3b, 0x7b7550df, 0x96afef0c, 
	0xb46ae1f9, 0xef6961c3, 0xcc7a2293, 0xaa68fe0f, 0x7d9f6233, 0x6ba3b7c0, 
	0xeb0a5cf1, 0x87a4bf67, 0x7b2349bf, 0xd8f6835c, 0xbcf5cfce, 0xcc7b60ed, 
	0x78672fad, 0xd9cfec7b, 0x1ac5f94b, 0xddf0c7b4, 0x038f3079, 0x1e4f35fd, 
	0xbdf08fe5, 0xcfefcb6f, 0xa13c3b42, 0x817e8ddb, 0x1f518f6e, 0xd88f2eb7, 
	0x50af5159, 0x357e8b7c, 0xdeb7e3d6, 0x4b5570c5, 0xb6f64bfb, 0x75676239, 
	0xeab924b9, 0x7fddd88a, 0x3a7ac059, 0xf9755e56, 0x72e7881a, 0xbe73c706, 
	0xe8e73c48, 0x9faf89a8, 0x3eff75eb, 0xe6da7e56, 0xff93ff53, 0x7e8cb9ce, 
	0x6d750f06, 0xa0d73f44, 0xe8891cfc, 0x0177f267, 0x3ba5798e, 0xc27e746c, 
	0xbac38daa, 0x5b67f42b, 0x8ce5eca3, 0x773f187b, 0x34aef5cb, 0xa7186d1a, 
	0x4557fbe9, 0xb535b142, 0xbdff170e, 0xfc74ba1f, 0x6a9a3aa7, 0x67fc5444, 
	0x1eb941ca, 0x4e20ff88, 0x5fa3f3a3, 0x9fdbfe3b, 0x4d5ff183, 0xa757fc4c, 
	0x2dff1f0e, 0x1f4c1dbf, 0xdbfaf3ac, 0xaa7fc4e3, 0x8897a3d4, 0xd71ffeff, 
	0x5d50e723, 0x9e071eac, 0x6c7598de, 0x327ff807, 0x3bb3fa5f, 0x47fc3fd8, 
	0xee3b81c5, 0xf5c7f7d0, 0xd64d213a, 0xd53db109, 0xd2ab2df3, 0x79436fde, 
	0x577cf3d6, 0x157c1fbb, 0xeeafbffb, 0x49f7fd61, 0x27800bf3, 0x3e2a966d, 
	0x72a95d60, 0xf54a9dbd, 0x75e58255, 0x873ff2cd, 0x0fae5844, 0x3735d3f9, 
	0xc48d5e32, 0x1eb835b7, 0xad1ef911, 0xedc6227b, 0x99d65526, 0x08a6c5d8, 
	0x75518c5e, 0xd23f2449, 0x83c588cf, 0xbdd04d3f, 0xba78033b, 0x5e9cbc4a, 
	0xc755fac1, 0xf2579e8f, 0x971dec17, 0xdfe17204, 0xa3a9a629, 0x5be08c01, 
	0xcae4026d, 0x36ea6857, 0xb1f3d3b7, 0xbed45086, 0x3f47dc97, 0xb0efd967, 
	0xd366fee2, 0x0067ee9c, 0x390b45be, 0xd5c7d24e, 0xc43a8fb9, 0x4e679c0e, 
	0xd043de37, 0x2f88d46b, 0xb39aea53, 0x8f3be09a, 0x4576f7e2, 0xe13dd7be, 
	0x035bd24d, 0x6d36cddf, 0x17f5a356, 0x4465b7ee, 0x3874dbf6, 0xf3fa3974, 
	0x74bb8e0a, 0x981c1e38, 0xce10e9ff, 0x800fffef, 0xbb7089c3, 0x1d7ef072, 
	0xaa75ce1d, 0xf4e10729, 0x69c0c537, 0xb4d59cdf, 0x2007d64b, 0x4f000d5c, 
	0x04bdf93b, 0x0b3ac0df, 0x55c20e45, 0xdf1de597, 0xa961fb8c, 0xce6c8fed, 
	0x10beb418, 0x971095c6, 0xfeb19b75, 0x4c08aac7, 0x03983f3f, 0xf47203fc, 
	0xe37923e0, 0x57d9beb0, 0xbce168db, 0x7a8b18bd, 0xf43777c7, 0x36447f89, 
	0xf83c0e6e, 0x8338f748, 0xd5ddf223, 0x5038b577, 0xe2bfdcef, 0x47c63b1d, 
	0xf485253e, 0x1081ea2a, 0x7c062b8c, 0x078418cc, 0x410cd749, 0x6bdff5df, 
	0xe2fb464a, 0x8f28d54f, 0xbf50cbea, 0xdeabfb8f, 0xd0af20d9, 0x29af7b5f, 
	0x77cef909, 0xcde12143, 0x2ddcce77, 0x59a279f9, 0x2fe1c08d, 0xe70e37d8, 
	0xc73f747d, 0x4d3c9ba9, 0xd700a569, 0x5ed9b746, 0x7ef8f80a, 0x14ad24b8, 
	0x9013e7f8, 0xf1e0052d, 0x13e47d4a, 0x510bbbeb, 0x7b7064ef, 0x93eb0571, 
	0x76f9058d, 0x8046d75c, 0x9ad6fd0b, 0x307fb002, 0xde7b6aff, 0xab6fb446, 
	0xb0de0093, 0x6fe63f5c, 0x26ef473c, 0x71d42f7d, 0xd0c38581, 0x49def11d, 
	0x76f743f2, 0x611f91f8, 0xff10ebdd, 0xa9bcfc6d, 0x21a39f9c, 0xb21ed5f5, 
	0xae82ff88, 0x3456fd97, 0xdc6fe415, 0xc32fbf0d, 0x7d87ac61, 0x696c59ff, 
	0x09df3900, 0x427eb4df, 0x3c6ca1e9, 0xfb835067, 0x1ef163cb, 0x378a46a7, 
	0xaf5ced6b, 0xbf0dde7b, 0xb33d24ef, 0x3eb7f50e, 0x28fd8d4f, 0xc23593c5, 
	0xd61b6339, 0x4fd59965, 0xd47c81b6, 0x7c45aaa5, 0xf23b422e, 0xcefe3e4c, 
	0x057cfb78, 0x24ea7fe7, 0xc5de27ff, 0x0ad7be71, 0x1bfe9178, 0x39d891d5, 
	0x1b7e8fff, 0x84fbc9e2, 0x2cf578e6, 0x331da7c5, 0xdfff59f2, 0xdcfa9618, 
	0x1b8671cd, 0x8deeb1d6, 0x0aee7dcc, 0xa3b30fda, 0x154e195f, 0xf6b07754, 
	0x8a77993e, 0xbd0adf57, 0xcba9fd68, 0xe9dd6c6d, 0x3ecdf2e5, 0x46ce4bf4, 
	0x8d4ef7f9, 0x9fee8eec, 0x1c5f735c, 0xa5ad5eff, 0x1a6fb7fe, 0x70e93fde, 
	0xfc90b9be, 0xbcfb81fb, 0xcfd19a0e, 0x08689a9f, 0x608efae0, 0xf58750ec, 
	0xdf5ff013, 0xd267e88b, 0xf11fa84b, 0xb780169e, 0x561dacd7, 0xf7a5f8a3, 
	0x3d878b96, 0xe7cb681e, 0x841cf11c, 0x61ff4a76, 0xb7aaf7bc, 0xfbf8fa12, 
	0x44f7f223, 0xe71edad9, 0x7e71e1b6, 0x5ff653be, 0x438efd92, 0xdb223fdc, 
	0xf7f88753, 0xefbf648f, 0xdd8fb522, 0xe885dbfc, 0x423c2167, 0x03d237f2, 
	0x7ea0d7f4, 0x42cce4a0, 0x3f6470f1, 0x80f5ea8b, 0x797f466f, 0x7203d1d4, 
	0xe7dd7d3e, 0x97e05af6, 0x15af00bb, 0x70f4ef98, 0xe5fe12fe, 0x252039f2, 
	0xb188eb17, 0x8aeb8dfe, 0xa056dcb5, 0x587bb8c3, 0x999e52df, 0x39e559f6, 
	0x1758af87, 0x81bbb7f2, 0xd1fcf8ef, 0xe990baa0, 0x9868f73f, 0xa1dd1b5f, 
	0xcea358a6, 0xf8874cef, 0xaa6aeb0f, 0xa04afd65, 0xeae17fa4, 0xbbdd613f, 
	0x9454754a, 0xf547dca7, 0xfe744a75, 0x3f056fd1, 0x779e8bb0, 0x7cd8f3e2, 
	0x2d5d13c9, 0x37c7058b, 0x74df187d, 0x2ce7c3de, 0xdf548fa6, 0x1c657809, 
	0x2de79012, 0x851f68ba, 0x20c096ea, 0x49b8c24f, 0xde9987df, 0x1b24dd7d, 
	0x7d7073ad, 0x3cfc3fdc, 0x88fbcc85, 0x8fe87538, 0xf78e1c62, 0xa97ac868, 
	0x4aa3dd48, 0x37eb8f75, 0x73c36e1e, 0x63fd7ab8, 0x9bb622de, 0x2f9a6b7a, 
	0xbea40feb, 0x1aeeedd6, 0x3de26e79, 0x7d97bfb9, 0xb1db8f37, 0xc81bdf98, 
	0xfe265d0f, 0xefbf1788, 0xd47f1789, 0x9dfea06e, 0xece3b35d, 0xa22e1527, 
	0xe262da7b, 0xb8fe3d77, 0xc436b852, 0x8b1c8b89, 0xae15c0e3, 0xbb6cfea0, 
	0x1b8db7dc, 0xba2f9517, 0x00345c54, 0xf0c1b4df, 0xc3ecc755, 0x746f83c5, 
	0xc747bcbc, 0x3f0fd463, 0xe065ed75, 0xa9745aab, 0xf8f75abc, 0x8a0fd8cf, 
	0xc97a9f0b, 0x78eeccbc, 0x947d85f0, 0x92d15997, 0xb32f271e, 0xfaba586e, 
	0x9a577c25, 0x3a78848f, 0x1873a679, 0x4b83c6ba, 0xb2cbfde3, 0x832e7373, 
	0x744196b7, 0x3d56f1d5, 0x5d307bad, 0x5d7c26bf, 0xddf0e28b, 0x97ea72c1, 
	0x132e23df, 0x32e8ff8f, 0xdb7cc9f0, 0xe9f0c1b4, 0x87858d74, 0x74c159e8, 
	0xc5fd019a, 0xcf81c4f7, 0xa7f082be, 0xf8c3dafd, 0x3069e84b, 0xafc7b20c, 
	0xfd0f5c32, 0x74f784c9, 0x50f94c4c, 0x7f2f13c2, 0xfd22b861, 0x783c7b71, 
	0x78249eda, 0x8c6fdf26, 0x2d8e3fa3, 0x5a3f6e1a, 0x0982d397, 0x55fbd51a, 
	0x37573966, 0x52fcc3cf, 0xd0e7f6fb, 0x3d12cb6f, 0xb6a38f7c, 0xc4a7e5be, 
	0xa7c4769f, 0x2ced9eaf, 0x1cf307ae, 0x4a4e3578, 0x3b3dfb15, 0xe74bcf01, 
	0xf427ae0f, 0x6ba1e8c7, 0x9df9c8e3, 0x5f57d6f1, 0xf31cfd42, 0x5d33f2e5, 
	0x1743d497, 0x1e11cf8a, 0xe1ef6e0c, 0x3978a8df, 0xa9cfe718, 0xa91bdbbe, 
	0x78e3d35f, 0x879a93f2, 0xeaf19fc6, 0x8f7d7faf, 0x578ebfac, 0xdfd82d2f, 
	0xc67dedd6, 0x7f2bb612, 0xb8f7932f, 0x8e55d80e, 0x76e1ffbf, 0x7f37ee55, 
	0xc487ee57, 0x5b57afb3, 0x5df0f137, 0x94a8e871, 0xf2de9f13, 0x10fa7897, 
	0x3e94512c, 0xb89bad8c, 0x98b39c50, 0x0fdcb8f4, 0xfd309530, 0x4467eec8, 
	0xf5caf9ec, 0x92ac5387, 0x97c6419e, 0x45d1ef01, 0x9d61063a, 0x3ee4cb19, 
	0xc8fecc60, 0x75c19c9a, 0x9ff9515b, 0xf71c7a90, 0xe12e8049, 0x29df9faf, 
	0x31ba9d68, 0x2fd91c25, 0xea7d07c1, 0x9baafdd0, 0x3b917df4, 0xb0538c5a, 
	0xf03c706e, 0xd5c70d9b, 0x8c05bed1, 0x655d5076, 0x47da7ec2, 0x3df1b0ac, 
	0xf3cc7e98, 0x9abcc4ad, 0x8e33f691, 0x73a1cc15, 0x67fbbd34, 0xc7459d71, 
	0xe5ebf62c, 0x1ce46d73, 0xe546af51, 0x287bdc05, 0xfa5e717f, 0x8b875857, 
	0xc057dcf5, 0x5bd4970f, 0x638aeee7, 0x0fccac87, 0x253bd3ff, 0x33dc3f0e, 
	0x72e83f2c, 0xce0fe74d, 0x1003fd63, 0xf950df6a, 0xf9cc58aa, 0x4a47d447, 
	0x75f395dd, 0x5571fcbc, 0x827a7b3c, 0x5bffc7f3, 0xfd197292, 0x70f176b4, 
	0x4fd74af6, 0xb8476cf3, 0x0fd6578e, 0x6db8ccac, 0x009ff50f, 0x9cf156fe, 
	0x96ebf755, 0xfe1e48da, 0x25feb207, 0x6d6adc6e, 0x6a07a41b, 0x9e84dd64, 
	0x79ce1667, 0x85a73c1e, 0x9eb1c7e7, 0x12f306aa, 0x2969ddf0, 0x1e7d1de2, 
	0xda3057de, 0xcd82bee4, 0xb8d0f9fc, 0xb0038f57, 0x82f8c4be, 0xaf32a510, 
	0x7defd3ed, 0x2d25f591, 0x80bd4feb, 0xdf3f567a, 0xc577e031, 0xbd2e1ff5, 
	0x3c4ef61f, 0x53d6b47a, 0x8ca4d4ff, 0xd2f57c38, 0x87ed4be2, 0x52bb1e51, 
	0x53add588, 0x527e728f, 0xc7fcc1ec, 0xfcf9bb8c, 0x84aff5f3, 0x7d753f28, 
	0xf3c0e6b2, 0x642bbdc6, 0x3de65b1e, 0x566718fc, 0x90c27e63, 0xb7a1f686, 
	0xe9dfca53, 0x363cf459, 0x2ee5bdcf, 0x9f5cb3ce, 0xbde1b5a2, 0x174e73a7, 
	0xe35e61a5, 0x57e514fa, 0xcbed5f58, 0xf42e2956, 0x46ec1877, 0xf11bc790, 
	0x5efc1e7c, 0xd3c423db, 0x56adcf10, 0xc423ae54, 0xdd177fbc, 0x5bf74687, 
	0x2bd5c2c6, 0x3c95bd64, 0x2b5bd7cf, 0x907ccb9f, 0x79856f5e, 0xa9b7ac5d, 
	0x458e34f1, 0x9c15e47d, 0xbfc81fdf, 0xd521f8af, 0xc552f961, 0x9ef21df1, 
	0xd1eb7c51, 0x3f75ead9, 0x6df43ce3, 0x72be4f4f, 0xff41ab79, 0xbca87db0, 
	0xdf478dad, 0x37a4659e, 0x78ccfede, 0x7bb5ff19, 0x29ab7958, 0x6af0ff64, 
	0x3d753df3, 0x52784f9c, 0xfe82bef0, 0xb9bbaafe, 0xf45b1c6e, 0xb8c49e83, 
	0x6f6963fe, 0x4c5ce892, 0xdb15dd4c, 0xd1762d99, 0xe48aa96a, 0x0ab79fcd, 
	0xc45bd637, 0xcafa939e, 0xf5319cf5, 0x509d7a54, 0x46b2fce4, 0x2e49efe7, 
	0x0ff27da1, 0xcd9d2a73, 0x6c7a3c91, 0x551c3f5e, 0xfd9c3fd7, 0xbfca4a7a, 
	0xd7a16f5e, 0x4e75ea6b, 0x50b9beba, 0xdadd910c, 0x94663f88, 0x6285d8fe, 
	0xdbaefd07, 0xfd1284f9, 0xe8b29cf7, 0x815307fa, 0x86f807ac, 0xe31126fc, 
	0x77fbe92f, 0xd603befa, 0xd57ee2ff, 0xdc5de2e5, 0xf2f36e2f, 0x3c58f17e, 
	0x02576167, 0xbb5be421, 0xfc02145a, 0x76c65e3d, 0xacf142eb, 0x88e7f132, 
	0xee04fa9f, 0x7d70673b, 0xaa2fef0f, 0x6157cc3e, 0x1cfd285e, 0x81d283e7, 
	0x980b425f, 0x0e7cf4ef, 0x64aa85e5, 0x687d279e, 0xbabc489d, 0xf3d5bd69, 
	0xfecaaba4, 0x19527951, 0xd60c1597, 0xb8d8fefb, 0x0ba3f30c, 0x9afdea87, 
	0x36217a78, 0xef443a4f, 0xd28f0583, 0xbd9cbefb, 0x42e38466, 0xbe20cd71, 
	0x933ac8b2, 0x68abc50b, 0xeb2ec9bc, 0x121d244f, 0xc32eae27, 0xeebeaa3c, 
	0x2fdfe95a, 0xe5f8f692, 0xf8ca8792, 0xea8d7efe, 0xe7fb23e1, 0x956eef8d, 
	0x7f940b75, 0x85c3a18f, 0xe8b2fae2, 0xd664c4f8, 0x2cbc78e1, 0x51260eba, 
	0xf81d43ca, 0xf312a229, 0x71ab46e1, 0xf06de32f, 0x7ab1d5bd, 0x9bd216f3, 
	0xee5779ff, 0xdeadee65, 0x3f23df4c, 0x0f7232ab, 0x252f7eb8, 0x78a0179d, 
	0x99faf868, 0x99fa988a, 0x5b0373d8, 0xa7c65cf0, 0xa00fce71, 0xdc46b8be, 
	0x2e00e785, 0xb419ef14, 0xae81736e, 0x48307e07, 0x5d25986f, 0x1c4dec06, 
	0xdc88627f, 0x88ee4159, 0x60ee40af, 0x71961ffd, 0xe285f2bd, 0x579865fd, 
	0x28fde9d6, 0xfbc377ee, 0xebf3c2ef, 0x7ffed0fa, 0x6b38fb48, 0x961ffed1, 
	0xea506579, 0xc89a0eeb, 0x0f1d83de, 0xea1f1d61, 0x3ef00d03, 0xbf09ea4e, 
	0xfe8d38bb, 0x53ee00ee, 0x7d9d7da3, 0x3ee8affb, 0xf01b841b, 0x0ff5b539, 
	0xc3bc5baf, 0x7126cbd8, 0x47f67e45, 0xeda2e4f1, 0xed7ba211, 0xfc9c4f49, 
	0x724189c0, 0x387d34e1, 0x197ecfc8, 0xb7ca68fc, 0x21541fa2, 0xe230a2fd, 
	0x7241dde9, 0x31f52893, 0xdd63abee, 0xc259d809, 0x3aaa4d53, 0xa8f4f10e, 
	0x9ef3fd9d, 0x2ebbfe32, 0x9dcf953e, 0x98d83bad, 0x7545de56, 0xb0e569e4, 
	0x6ea6ba8e, 0xe310b2c7, 0xf3d61cad, 0xfba09972, 0xa6fe75d9, 0x61eee47a, 
	0xa32ae9d6, 0x773bbe75, 0x1efe20c6, 0x447c17ea, 0xfd2e35eb, 0x10bc69b3, 
	0xee83fe03, 0xdc5ebc1f, 0x2e17f443, 0x8bfbee95, 0x7ce70fa7, 0xb146fb43, 
	0x3de001f6, 0x50a17d4c, 0xce9f7ddf, 0xbd277fb7, 0xce71b573, 0xdab92d3f, 
	0x258c993a, 0x22b7ca97, 0xe2a21a8e, 0xe597b436, 0x0a788f32, 0x8b2ff6e4, 
	0x6077feb8, 0x1e263e5f, 0xb4f70788, 0x715f7078, 0x8f2b067c, 0x87ab17f2, 
	0x5b4e5fd4, 0xbe1e9c32, 0xa0ed7c50, 0x11fb75df, 0x657f2f3f, 0xc6efbef9, 
	0xf2e5c3a5, 0x5c96f37d, 0xf3a7df2a, 0x6f92d56f, 0x672f7f86, 0xade22bcf, 
	0xfcf6b2f3, 0xf3a24bbb, 0x5e7b1103, 0xc91e8831, 0xad1dba05, 0x3dbc325a, 
	0x9c325eaf, 0xa2592f3d, 0xf495f3db, 0xebaa583c, 0xb1ebb641, 0xb55fe6f5, 
	0x355c14ae, 0xea9b9fba, 0xafc40f77, 0x251e152f, 0x99cfef1b, 0xe7de2dfa, 
	0x269b73a2, 0xa419ef3c, 0x5d9b06fa, 0xf1ceb184, 0xca3a98ba, 0xef7c25c6, 
	0x73185040, 0x3903ac55, 0xf7c9e7c8, 0x33f173c8, 0xe0b76cdd, 0xeb81aafb, 
	0x5d7d4324, 0xf8283cf2, 0x8b5b338b, 0x3fa0eb52, 0x2db2cd7d, 0xff5f2075, 
	0x5fcf9f3a, 0x5d387f4f, 0xafa6f7c3, 0xbf117f49, 0xd70d7d33, 0x16ab0a73, 
	0x1d54fdc2, 0xcf8f418f, 0xae40f786, 0xcb75aadf, 0xcfcdccfa, 0x717c42e6, 
	0x31bfd82d, 0x1ffe7a91, 0x40fe7aca, 0xb3c22ec9, 0x032f035f, 0x8a9d73f7, 
	0x7fda01bd, 0xe8fb7843, 0xa73d3ffc, 0x11bc07fb, 0x43ee7d38, 0x3aff7067, 
	0xe75a0aa8, 0xeb19de40, 0x767e31e3, 0xfbe8f3c1, 0xaa7c6008, 0xaaf3d86b, 
	0xeaa25aab, 0x1ee1634a, 0x83a9fce6, 0x618ac7cf, 0x9ec69fcf, 0x73c1ad3b, 
	0xb9c8e1a7, 0xedf9d8d3, 0xf6bd3e92, 0x02dfbf1d, 0x84b4307a, 0x7c756eeb, 
	0x921552fa, 0x2f9253db, 0x7e873d7b, 0xfb3f75cf, 0xcae1781d, 0x4eb1bac0, 
	0xf1ef9323, 0xcf9038e1, 0x1539d3ff, 0xf9bbebcc, 0xde1daf79, 0x720bae8f, 
	0x41754bbf, 0xbf1deebd, 0xcf4fbe8f, 0xe9122a9f, 0x155991ef, 0x25e295bb, 
	0x0d63c933, 0x4ada61c8, 0x3cc90e21, 0xd3278576, 0x786ff86c, 0x4a8e793f, 
	0x959b0679, 0xa677a2e4, 0x01bc6549, 0x477f513c, 0x2536efc9, 0xe5dabca2, 
	0xb96365b9, 0xa071ec48, 0xa2fd763e, 0xe076da16, 0xb7e52f0b, 0x8e50f7c4, 
	0x5ef7c684, 0x51eddc12, 0xbca854fa, 0xe9e3854e, 0xbacc775e, 0xbaf1efac, 
	0x1d70be24, 0x7855f7fc, 0x27d47e1d, 0x370a8eb0, 0xcf12bfc0, 0xc573cb83, 
	0x06de326f, 0x759974f0, 0xec5fa519, 0x10e3bc73, 0x97eca30b, 0x5eb477b4, 
	0x3b99def8, 0x9e357e98, 0xd3d50746, 0x08f408dc, 0x9ea9f7f3, 0x47bf0ec6, 
	0x6558d3d7, 0xaf5b8d3d, 0x71d651a7, 0xd9eea0dc, 0xebd5d2fa, 0xf485546f, 
	0xe2a267f7, 0x6d3fba64, 0x986fc805, 0x29dff39e, 0x1f7be158, 0x787d47eb, 
	0x9f179aaf, 0x8c4275ef, 0x39d3bf8d, 0xd00af35d, 0x9f7a6e6f, 0xe30b43ee, 
	0x279c6bbd, 0x84196230, 0x115e4575, 0x62b497ce, 0x37064bef, 0x8fbdf78e, 
	0x7915e6fd, 0x949cf1c7, 0x7f479ec5, 0x9792216f, 0x463a7be0, 0xe38278e0, 
	0xe229ef6a, 0xd444f77b, 0x5e7869bd, 0x15ea3297, 0xc3b4def2, 0xe5244f74, 
	0x317f285b, 0x1fe4fe4c, 0xf1e8ff15, 0xf38b9a4e, 0xa1e2432e, 0x34235e48, 
	0xf17efdec, 0x695f8bce, 0x1f60635e, 0xa07df862, 0x3b5aa9d5, 0xce22abdf, 
	0x710c9d6e, 0x9bbfff53, 0xd003efa3, 0x28f1f7eb, 0xc7f5d639, 0x0fe99fda, 
	0xf9445e3b, 0xfbf5aafe, 0xaef3ab97, 0x32afff41, 0xa3f4dfbe, 0x41c4e35b, 
	0x6fa80ba5, 0xc71ddb7e, 0x6b79589f, 0xffa4dfb4, 0xd2b9b79d, 0x3aef3c0f, 
	0xd037f74e, 0xf1450d7d, 0x2d986bef, 0x07603be9, 0xd70dbde5, 0x581c568c, 
	0x725b5eff, 0xade2246c, 0x07915cfa, 0x662515fb, 0xfe4670ab, 0x3530917e, 
	0xeae7958c, 0xddbe62c6, 0x0776f33f, 0x8ebab1e2, 0xaf788df3, 0x05b1d605, 
	0xbf0d9f15, 0x09e6b417, 0x03d9d837, 0xf703dd72, 0xbe0ed45a, 0xd7bf49d7, 
	0xf2b7c7e2, 0xf007ccf9, 0x658fa67e, 0xea13717e, 0x5e507515, 0x46faa1f2, 
	0xe642d7be, 0x8febab05, 0xf27ac58e, 0x9fa05d07, 0xbfdc420c, 0xfe1e62ee, 
	0x21fbae7d, 0x97fbc39c, 0x57dfb81e, 0xd3477f89, 0x7d60530f, 0xd177dd38, 
	0xe2c7e34c, 0x29a4d73c, 0xe32acd2d, 0xe036db6f, 0x1e185b93, 0x78df3cbf, 
	0xabf068cd, 0xfa7c11ac, 0x144a3f10, 0x789ad65e, 0x44daa21f, 0xef8410fb, 
	0x0ef8f89e, 0xff4ac314, 0x4726fa0c, 0x7e3fb009, 0x72f53f69, 0x9717d57c, 
	0x7f5316af, 0x71e9dae6, 0xc303f1fc, 0xd203d5f2, 0x54e9d71f, 0x764c655d, 
	0xf03ddc02, 0xf3c27f9d, 0x57de6613, 0xd691707e, 0x1f77e786, 0xc87b735c, 
	0xf37bdf0a, 0xad3bfe56, 0xa77323be, 0x466ebd21, 0x5d62258c, 0x0baa7ce8, 
	0xd87186ad, 0xf0e7803e, 0xd08f586a, 0xbdcc76be, 0xb9ce2225, 0xdf1b34e6, 
	0xcf0c114b, 0xaf741dcd, 0xa7bdd7e3, 0xab4fe642, 0x82f43b1f, 0x9be11ac7, 
	0x0bca4c07, 0xf363e6a8, 0xdf79fac7, 0x857bfd01, 0x35fe5bfb, 0x9f3a423b, 
	0x3950c405, 0xac12bca2, 0xedea62b3, 0x637f91a7, 0xe03d60ed, 0xeafbfd15, 
	0xfed276db, 0x4d16983e, 0x1f5e5fe4, 0xc3887289, 0x0c573e29, 0x04fa4798, 
	0xfe8199e6, 0xcc70316a, 0x84fdb09f, 0xf90530f8, 0x099f3050, 0xb78467c9, 
	0xdc53f1cb, 0x1a58863c, 0xfceaaf1d, 0xc4b7c7a4, 0xfe230b67, 0xe213cc3a, 
	0x8425577d, 0xd43e8ff5, 0xf3f66143, 0x7ce91f91, 0x83ac39d6, 0xdd0c39f2, 
	0xfca3f7ec, 0xd07dfeea, 0xda03fba5, 0x8c8f1847, 0x7bd2a839, 0x9a701dba, 
	0xf7d82d42, 0xbfb07bca, 0xba2a3dea, 0x726e9ffe, 0xacde125c, 0x18d3eac9, 
	0xf9bc1107, 0xfef17811, 0x22fb51e3, 0xdfe4da70, 0x507318df, 0xa2ad3861, 
	0xf10e76dd, 0x078b72be, 0x17c265f8, 0x11d28fe1, 0x7b2d569f, 0x1f29fb1b, 
	0x78477de1, 0xc7de2cff, 0x7be56e99, 0x17afd1cc, 0xbeaf7e51, 0xf0db8c5e, 
	0xe9a737be, 0x3f38e3c3, 0xbf02ff9d, 0x90258c7f, 0xd438db3a, 0xe73d8fff, 
	0xe3ed75f6, 0x137bfa95, 0x7f188f10, 0x56dd3c5f, 0x79e7c5db, 0xbfb80d6a, 
	0x73d420b9, 0x6cf5cf16, 0xd8fac36b, 0xfdf3969b, 0x089c4261, 0xcf183e51, 
	0x7d9e6117, 0x9794fbca, 0x3045f3a4, 0xa1573aae, 0x67da74fa, 0x96af3e04, 
	0xf3f48de7, 0xc9971e45, 0xdca2f46e, 0xeb8b7fda, 0xce2ee59b, 0xf68e7f46, 
	0x5c5f490f, 0x7e91bcfa, 0x296568ae, 0x769a2b9f, 0x3ce832d1, 0xce72da51, 
	0x677dbd73, 0xf544f39c, 0x54b37f72, 0xcc334fde, 0xf453a279, 0x6eb806f7, 
	0xd33f6074, 0xcfda5bf5, 0xf9ed295c, 0x7f0e779b, 0x9e5aa89e, 0x398eaa27, 
	0x9cb3544f, 0xbce87eeb, 0xbce44f51, 0x873fac71, 0xff71dbe7, 0xe7cec6be, 
	0xe43f30c4, 0x9fa1f992, 0x5a295e80, 0xca8a3406, 0xa279e97b, 0xb9a5d9cb, 
	0x4fe4e2cb, 0x4f294bdc, 0xa6ff31b4, 0xd3697638, 0x89fce8d2, 0xa58a976e, 
	0x3ac3f11e, 0x5c71b71b, 0x410f7f83, 0xc69ed424, 0x2f96bf7b, 0x383ff1d3, 
	0xb788193e, 0xde295bd4, 0xceebfba2, 0x4876bdf3, 0x39cb97ff, 0xff1b10ef, 
	0x7c672cef, 0x827fdfc7, 0xe0f817b8, 0x63ae72d9, 0xfc223907, 0xb9eb275f, 
	0x2d79f5f3, 0x9d6f7c8d, 0xd76e9bc4, 0x5cde79f5, 0x44ff70ca, 0xd3563fde, 
	0x91564a6b, 0x5feaf91e, 0xe518fdfe, 0x64b40fa9, 0xd99deb61, 0xe0ea9879, 
	0x9ad1bee8, 0xb827a71c, 0xc755e100, 0x7c071ced, 0xcbf4a859, 0x3d16a97b, 
	0x3a92baeb, 0x31d74bc8, 0xf1c797d4, 0x70775c2b, 0x4667ab7d, 0x56157f1c, 
	0x3c57e514, 0x318bc7f9, 0x690d7ae7, 0x42be8fc8, 0x655ce759, 0x7ac166b0, 
	0xfd2a5adf, 0x573e0287, 0xbfc498fa, 0xf201f11f, 0xcce3035b, 0xe7bf981d, 
	0x0e7f287a, 0xac46adf8, 0xecff0693, 0xd913ae63, 0x77bf22a6, 0xe69dbd93, 
	0x615913c9, 0xf2062f79, 0x33af27ab, 0x81f0f015, 0x0e754efc, 0x1e3531fb, 
	0xf45a6753, 0xf191a9ef, 0x2aeca33b, 0xc4e2db8e, 0xbf3a8cfc, 0x53e652b1, 
	0xbfcd0df6, 0xd216f9e8, 0xcf5947b3, 0x3a8b6f36, 0xef20dc8f, 0x0a64f2f9, 
	0x8d8b1fdc, 0xed39824f, 0x3b7de05f, 0x9ab36fa0, 0x0fff4933, 0x1e977f7b, 
	0xbeea460f, 0x12fe2eae, 0xe3d2de32, 0xb85bc6be, 0xdfc87f1e, 0x27ff408b, 
	0xfdf1f574, 0xa18d07ff, 0x0000f395, 0x0002cb81, 0x7ded9c78, 0xe754540b, 
	0x0f37eff5, 0x11c41060, 0x41819930, 0xd1213411, 0xc54513a6, 0x06439a48, 
	0x2a26b513, 0xc1152f2a, 0x79881981, 0x4988be00, 0x1040339a, 0x57c16a62, 
	0xa24a6ac0, 0x03e98d49, 0x49b53493, 0x136a0eda, 0x7af724d3, 0x34b576ff, 
	0x6c516e6d, 0x574ff575, 0xd5fca249, 0xbddcdff4, 0xe61df7f7, 0xf830e3cc, 
	0xbff7bdb8, 0xb2b5dfd6, 0xce73be4e, 0xbdbfb39c, 0xbdbfb7f7, 0x0d9f6ff7, 
	0x1ecf4c63, 0xad3e4c67, 0x830b7263, 0x2e5e927f, 0xe854cc63, 0x1c5eb334, 
	0x9a7c9d33, 0xe742e8b1, 0x9d8c2329, 0xb23a3636, 0x4fefaf14, 0x7e745d65, 
	0xc6c60eb7, 0xb7a674c2, 0xf0d3efd3, 0x31ef5efe, 0xc71f3c9d, 0x8605fd5e, 
	0xe0e7a7f7, 0xf70ba2f3, 0xe3b3a2bf, 0x3853cefd, 0x7f4c296e, 0x89cf075f, 
	0xe3d7a4b2, 0xcc2c63f3, 0xef45d91b, 0x463a434d, 0x8744fde3, 0x4cdfd69c, 
	0xd02fd3e7, 0x07ff4e51, 0x4e3a4f1f, 0x3e93cb74, 0xfc9b23a2, 0xfc9e3e1b, 
	0xe5be3e47, 0xd2df1f2c, 0xeba7e7cf, 0x70ccd3a1, 0xe32c6649, 0xf5bff841, 
	0xdf01a744, 0xd7251fa7, 0x4c70ddcb, 0x3aca3f68, 0x46329b18, 0xc33869ea, 
	0x113b2958, 0x22707b2b, 0xcc336b5e, 0xc7192dcf, 0xcdde6198, 0x09d3a026, 
	0xa9d631f7, 0x4be3003b, 0xcbb1a777, 0xabf3fd8c, 0xcf5c987b, 0x8df654d8, 
	0x32afe418, 0x5fdace6e, 0x7633cec6, 0xdab03333, 0x2ff4363a, 0x3b631c61, 
	0x5fc6f92f, 0xb3dc5267, 0xa2a41d70, 0xa73a052f, 0xa2ffed45, 0xeec65ee6, 
	0xadb6d138, 0x2ae91134, 0xe677cbfd, 0xeef171d1, 0xe5fac608, 0x65fd7aee, 
	0x3184679a, 0xe97f7e12, 0x83a72b69, 0x3cf17bd1, 0x898a65ca, 0xe1cae975, 
	0x11a4ec7d, 0xcd1f2ee9, 0xaf303c8a, 0x0b17590a, 0xd5376493, 0x3d3e98e9, 
	0x94e4fbd4, 0x9c9f44dd, 0xf05070d7, 0x63e61e25, 0x7dcd6966, 0x31977d8c, 
	0x7fcc0c73, 0xcfce22df, 0xfb6ebfd9, 0xc78654d0, 0xb89b2fb1, 0x05a5fc1e, 
	0xc18779f8, 0xd057d5ea, 0x68e43a73, 0xd1dca7e4, 0x3dccfc8a, 0x9fdf063e, 
	0x0cfc8b78, 0x679f1bf2, 0x33e70498, 0xf21d569d, 0x38d8c2d7, 0xd7066fe4, 
	0xa589b34b, 0x7c09bc26, 0xb2c5223c, 0xa7439232, 0xa9632cf9, 0x3c5b672c, 
	0xd0d539c8, 0xe78321f1, 0xef47f84e, 0xef2ac65f, 0x4bf24d3f, 0xbc71836a, 
	0xe1ea9589, 0x5026b1fe, 0x1fce4c84, 0x26681394, 0x9e40ba43, 0x74b3ba5d, 
	0xa7af179f, 0x9452fcfe, 0x1f9be0c9, 0xbe2b7f3c, 0x4c78f897, 0xcc2c71f0, 
	0x61d8dd6f, 0x35ad37e7, 0xf9a5e887, 0xefcdf59d, 0xdb25da8e, 0xc71e0b58, 
	0x2b748cbe, 0x3dba44f3, 0xedbe7865, 0x7881f643, 0xffbc2d7f, 0x48ad91c8, 
	0xc7dcaecf, 0x18cfb317, 0x1fff1beb, 0xeeafa81d, 0x8d3386a9, 0x057d8c9d, 
	0x34ffbeff, 0x63a8d5c8, 0xa55ba00d, 0x75d2d792, 0xb957318e, 0x89d994ce, 
	0x5d74927c, 0x183d69a7, 0xdbb9e0ba, 0xa9663317, 0xbc4f6186, 0xf4d0f911, 
	0x81f1044a, 0x44623dd5, 0xcf7d6a3d, 0xc966c7cc, 0x2624eb83, 0xe1229989, 
	0xeb7a22c8, 0xecfd00ef, 0x62f6fd4a, 0x8dd61176, 0xfa406bd9, 0x1bcf199d, 
	0x2b8fe819, 0xacc74fb3, 0xdc4e458c, 0x70d598b6, 0xae809aba, 0xba23234a, 
	0x627cc0f6, 0x9ddb1806, 0xe1e69dbb, 0xcc5cec71, 0x2ce780be, 0x85bf3c94, 
	0x46353fc7, 0xe0ce7ab2, 0x6cf16bd1, 0x4a24f981, 0x50ed1956, 0x75956cac, 
	0x1b799e78, 0xede70cfe, 0xf606560d, 0x7fbfa9e0, 0x75c3b568, 0xad0ff9d7, 
	0x37ac32a0, 0xac34b256, 0xf814eb11, 0xa432cee5, 0x3048be93, 0xb5fc463e, 
	0xbc919736, 0x17a02dac, 0x2207df77, 0x0f7a46ab, 0xf4813d10, 0xb7eee656, 
	0xbf169f46, 0x1347f713, 0x7e6887fd, 0x2dee2353, 0x468ed86c, 0xe7c16bd5, 
	0x5eb1354e, 0x0679c813, 0x65d347ac, 0xe3d7cf3c, 0xe6df80ef, 0xd013e46a, 
	0xaae37a0d, 0x787ab3d3, 0x8d260cfe, 0xff7dc3b6, 0x37017b40, 0xb4e64627, 
	0x9beb3ae3, 0x198755f0, 0xddbee8f8, 0x2a6b6cf0, 0x012cef63, 0x7d38073a, 
	0xb39ca3cf, 0x9f703f81, 0xb9d39133, 0xc5ddf73b, 0x0f283531, 0x9df38496, 
	0xf56cb770, 0xffc70fdc, 0xdd3f1074, 0xb0c67307, 0xd63e3889, 0x95d8c32e, 
	0x6b09fc9b, 0x70ece200, 0x3391e81f, 0x9e9661be, 0x016483d6, 0x4fa43423, 
	0xe9819265, 0xc06ff9e1, 0x7e8013fb, 0x2b8f99ab, 0x07db7a16, 0xbbcee180, 
	0x9b547476, 0xb842f5f9, 0xcfcbfaee, 0x861d6566, 0x7e65c0e3, 0x95995fd4, 
	0x131c2775, 0x2df1f0af, 0x2bbf6c62, 0x8af7c68b, 0xe23832e3, 0x57189779, 
	0x0ce3a66f, 0xb2d1def9, 0xe51727d9, 0x74e320f8, 0x5a7d076c, 0xfd7c1d51, 
	0x47a48f7a, 0x3ceed720, 0x7de56f3e, 0xd0e78f53, 0xa8bee579, 0xa73fae3c, 
	0xc8330e81, 0x673ca2a7, 0xee6bee34, 0xc6319cf2, 0xe99f5c2e, 0x73bf00cc, 
	0x6d2d7ac7, 0x4b7bf0ad, 0xf6113d9f, 0x7909bf83, 0x7ac3194e, 0xafa879f0, 
	0x5ec15768, 0x0760d1cb, 0x1dbce2fb, 0xc8dfb8cd, 0xd8c1de70, 0xf9fc25e1, 
	0x9f3bfb6e, 0xddeb551a, 0x01f58265, 0xc06775cf, 0x074e0cf9, 0x4d180d83, 
	0x7e2efd52, 0xb241ec7f, 0x2eb8ed17, 0x522f689d, 0x4f42f6d5, 0xf19993fa, 
	0x46becebc, 0x616889d8, 0xf5f34e27, 0x7f7a05df, 0x7b0d12eb, 0x71a72a61, 
	0xe0ef4ff3, 0xc0e444fe, 0x9f69dd51, 0x8d4ae8bd, 0xc036c25f, 0xf54bc4f9, 
	0x223760d9, 0xea1d5eed, 0xc5ed15a7, 0xae0bd451, 0x37e37dbf, 0x0f419875, 
	0x33866c2b, 0x537e613b, 0x2abe7097, 0x7414eefa, 0x76b35d82, 0xbce9b5b9, 
	0x081ce90d, 0x1d7b6741, 0x5dd4b5d9, 0x8838f853, 0xe8fd5bce, 0x2fbbfcdc, 
	0xa0b74e89, 0x2780e3d3, 0xc77903af, 0xeb829d82, 0x74a98e83, 0xda5ecebf, 
	0xa38c09fd, 0x68dda58c, 0xffc6fabf, 0xecf903b4, 0x62b3e0d2, 0x5fe8b597, 
	0xc4bf45a6, 0x13d3dfe9, 0x3dff41a5, 0xec57e921, 0xb391c7b2, 0xc9aced04, 
	0x03acedc6, 0x1d0328f8, 0xb7d874fa, 0x99bacec0, 0xa3e7c16c, 0xd9bb42c1, 
	0xe7e48ccc, 0xcc27b1ac, 0xb1bb028d, 0xe98a2326, 0xa6edccff, 0xcf91e887, 
	0x6390bee0, 0x7dc74faa, 0x2ba8deea, 0xbf9026e9, 0x2fa5cbe3, 0xd3fae1e9, 
	0xe9cbd397, 0x794245f8, 0xd6ff9c24, 0x48f2ce67, 0xe12b7f18, 0x135b7289, 
	0x36d693ed, 0xe674f790, 0xbf24eed8, 0x49e2ba48, 0x7016be47, 0x57c04abe, 
	0x099d1b38, 0xdb87957c, 0xad5f38ef, 0x49f7f461, 0x779ebe2d, 0x4fe378d2, 
	0xdfd0d6ef, 0xfdfd7f2a, 0x462e84ea, 0xe515f5c7, 0x2fe9915c, 0x1b235767, 
	0x4b7e9e91, 0x37793d6b, 0x347f9c90, 0xce434e37, 0xc38b9330, 0x48b7e9e9, 
	0xae36b1ce, 0x4c871ea7, 0xe5cc6b7a, 0xccfd21e3, 0x1ba3e7f6, 0xbc2bb8f9, 
	0x45a2be7e, 0x1a7cf577, 0xd64eecaf, 0xb0c77ba0, 0x9f69a9fa, 0x5b29f886, 
	0xfbeba387, 0x5d2df25a, 0x6bd7e34c, 0xf7c86a26, 0xb9749095, 0x72bb5d04, 
	0xc835c9e1, 0xaf8957c7, 0xfd7cd911, 0x89de7628, 0x748ede76, 0xfe079d83, 
	0x83f610fd, 0xd7616a98, 0x02dfa0d7, 0x76e334fb, 0xd8c958df, 0x7fdc794b, 
	0x39fd3b20, 0xdd4efbd9, 0xf03ef0c3, 0x70da1a6f, 0xd69649f9, 0x2ab3f40e, 
	0x9e1ed07b, 0x9fb07610, 0x3e724db1, 0x38399bae, 0xf7afd679, 0x184ff932, 
	0x6b8e453f, 0x6c5e8ddc, 0x23d705b5, 0x8a563544, 0x760e22c3, 0xccca3ce0, 
	0x9c16e316, 0x41bf3b0f, 0x83718557, 0x09865abe, 0xc39ccf1c, 0x839cf8cc, 
	0x4e19abb3, 0x2c366ba8, 0xef75df6d, 0x4eac3998, 0x0ba7bd56, 0xf5d373de, 
	0xde5d43af, 0x4fc3aeb5, 0xb7def4fc, 0x363d050e, 0x439c7a7f, 0xab0d237a, 
	0x0d3c8637, 0xa1c81e7d, 0x2697c2f1, 0xdff3e868, 0x454dea42, 0xae073ea0, 
	0xf40ba433, 0xcba0ba64, 0xca13fa05, 0xa2d08f3f, 0xc6847e4b, 0x0b6fd8af, 
	0xa7039fe3, 0x4579fe55, 0x71ee7f80, 0xecfdccc0, 0x238d0444, 0x78319533, 
	0x74376036, 0xfe5f84cb, 0x3a2d2ff7, 0x5f53fe78, 0xe95f92f7, 0x83f1fe16, 
	0x15b59e6c, 0xea0776f4, 0x3d3bd035, 0x0f49fb83, 0xc82d78c0, 0x63a8a9f9, 
	0xdd53f456, 0xf2ec9718, 0x7fc519d9, 0x3f71e7b2, 0x2b1c4528, 0x64a30dfa, 
	0x262a8ff0, 0x1c8e3a75, 0x676c6387, 0x3c44b6f6, 0x399392b2, 0xa2740f18, 
	0x427e0fdb, 0xfbe6b8e7, 0xd8a4ef51, 0xfac1cfed, 0x3d2e96ca, 0x6991f7cf, 
	0xecaaafcd, 0x1b9da6b3, 0xd02c9ede, 0xe58cd3d2, 0x6705ee34, 0xc05eb435, 
	0xe17a548c, 0xd9f9f5b4, 0x2eb96713, 0xf51e78ce, 0x02aff382, 0xb044b3e2, 
	0xc45abf0b, 0x11d8a7f9, 0xd026d3b4, 0xf5e8176b, 0xbafc9d73, 0x0fed4079, 
	0xdbf4fce9, 0x6a5e718d, 0x537d1eb0, 0x1c468f4b, 0xa9082de7, 0xae6cee47, 
	0xe172bb47, 0x3dc7140d, 0xe38ea790, 0x83ca3c94, 0x89147943, 0xcc0aaee2, 
	0x435ef4a3, 0x7f63251e, 0xdd3e0319, 0x930fad5c, 0xfddb9147, 0x8e9b28f2, 
	0xc51f54e6, 0xdee1c6bc, 0xd7949df2, 0x8276dc88, 0x3f778b8e, 0xf28f2a13, 
	0xa3caabcb, 0x28f302b8, 0x0763ef41, 0xa5e51e45, 0xf3b557c6, 0xa7207128, 
	0xbc51e591, 0x4d1f641d, 0xe4568ede, 0x7a19e627, 0x1528f383, 0xf3fdfbd9, 
	0xb7fff628, 0x7e651479, 0x4f14795a, 0xdc3cceee, 0x94f97d67, 0xcc0cf3d0, 
	0x0cf328a7, 0x43d8a7ca, 0x0e8853e7, 0x2fa53e55, 0x4b90ea4e, 0x3d023e85, 
	0xbe3c5915, 0xf48bb8c2, 0xd431e213, 0xb9dd654f, 0x78c56fc1, 0xb0e302b4, 
	0xcb78be83, 0x85bc78c5, 0x96f1e7bf, 0xf3a59f96, 0x342ab3f3, 0xb5efffec, 
	0xf6e30fec, 0x76757c67, 0x9ddb7598, 0x533f2a17, 0xcfc95531, 0x950bcd1c, 
	0x98b7399f, 0x73bb2ffb, 0x79e3cbdf, 0x9b0f3126, 0xd2365fbf, 0x5a0ff5fd, 
	0x9fac27f6, 0x50bcfbfb, 0x50c56e7e, 0xb207f33c, 0xca658637, 0x8d29f57e, 
	0xf0ee7e7d, 0xff386ef1, 0x8354b0dc, 0xdcfd61ff, 0xe2e1bc81, 0x257f21c8, 
	0x542f5fd3, 0xfeb0c371, 0x06a971b7, 0xb9fac33f, 0xfc10a330, 0xb9f90e74, 
	0xe3b264f0, 0xdf714b91, 0x575cfc57, 0xa99b9fa0, 0xd1ff4fec, 0xf213fb8e, 
	0x1fa7f717, 0xadf9e12e, 0x2f94fca1, 0xd67c490f, 0xd4ee73f2, 0xf588cf9a, 
	0xb552fc7c, 0x567c2b9e, 0x3f4d1cfc, 0xe161f840, 0x5ae980fc, 0x3fd6107a, 
	0x130d9984, 0xd31c7857, 0xfd3ecf89, 0xc563419d, 0x7b7f82ff, 0x616bbe70, 
	0xbec244a5, 0xdfb5e333, 0x337e705b, 0xe9fd8146, 0x70ab7d86, 0x78c3354e, 
	0x80f1e240, 0xf8a06ed3, 0xba93aefc, 0xfd83b438, 0xdf5f8527, 0xf7ae9b33, 
	0x4bfb8a57, 0xdf9f90e7, 0x8132f304, 0xe3119c1d, 0xfb056f6d, 0x2727a737, 
	0x58e3458e, 0x49f318fa, 0x0f7824ce, 0x2eae1dec, 0xf60f4d8f, 0x26f3166e, 
	0xdec99a37, 0xc85bbd5b, 0xde60a6ae, 0x997c12b0, 0xaf0ec067, 0x34d66495, 
	0xb192e503, 0xac7ce907, 0xcd9921ae, 0xb6b3a60f, 0x5e3258f5, 0x1a02447f, 
	0xcfdfde80, 0xbfb3f6e3, 0xb7a70e75, 0x7a484e7a, 0x7ef97ea7, 0xc11afd4f, 
	0xfe3e038f, 0x7e80d3b8, 0xcaf38678, 0xaacc3b2f, 0xa5aceb7c, 0xb0649fdc, 
	0x5eff709e, 0x91604f6b, 0x76b30768, 0xd24f4958, 0xcdcaefa4, 0x3acdf4c1, 
	0xb9f44dd2, 0x790ee4d2, 0xe207fa1e, 0x75cba0ba, 0x9476abe5, 0x409ef2bb, 
	0x52b1dd3a, 0xb9f807b2, 0x37dfc2d6, 0x648eb5e3, 0x86b9675a, 0x9252c6d8, 
	0x8fc70d8f, 0x3a2cfad8, 0x4bd3ca2f, 0x25a55b71, 0x674cf8dd, 0x5a8f3d30, 
	0xf0bbae40, 0x977f4fbd, 0x2817e6a9, 0xaf9846df, 0x1e982174, 0x04e5af90, 
	0x4563d7c9, 0xdef62af9, 0xb6f78169, 0xd2d33633, 0x05df27e0, 0x4b8c1cf0, 
	0x814ddf61, 0x3879b05f, 0x15993d06, 0xabbc9bd5, 0x32a7ac41, 0x9d47cfbe, 
	0xc7fcf6bd, 0x7575ad69, 0x0bed0d64, 0x1a19ede7, 0x9faf6c76, 0xfc354b1d, 
	0xc2becfde, 0xbbca3d3f, 0x0e8de0b6, 0x357d25e6, 0x3ad4d8e0, 0xb028fdfd, 
	0xd9defd63, 0x921dfb32, 0x0cf5c593, 0xe80b906e, 0x607fe17f, 0xbf0f719c, 
	0x74fac62e, 0x7ed043f0, 0xe3b6f1ad, 0x53f8cd78, 0x115fa12f, 0x37309597, 
	0x3fb845ea, 0xff7320cb, 0x5b616bd1, 0x3e71fbf8, 0xdabe2052, 0x23fb8eba, 
	0xc7c0c966, 0x3e12a46f, 0x708ebada, 0x872fa056, 0xf0941c71, 0xd3add1d7, 
	0x7507109b, 0xc0d8f6c3, 0xf23d21fd, 0xfc27ee07, 0xc7afee15, 0x18e347fb, 
	0x4eb633ee, 0x06363c27, 0x29f22cd6, 0xc20df5ba, 0xdbbde15d, 0x71a33df1, 
	0x1df745dc, 0x770fb1c3, 0x0f487495, 0x7e0a4f44, 0x79801bab, 0x481cb13e, 
	0x9d5e80bd, 0x8fa7f897, 0xf5c7ad6f, 0x55be5fac, 0x7109bb7f, 0x4b648695, 
	0xb2771c13, 0x906ef2a9, 0x3aaff34b, 0xcee0a130, 0x5519f436, 0xe58ee0fa, 
	0x546cf676, 0xf4099246, 0x3ee40fad, 0xa3fdec16, 0x33b5dfbe, 0x73d937b4, 
	0xb3ecfcfa, 0x27024864, 0x9c0dd611, 0x21e550cf, 0x3ca78c4e, 0xd3df1384, 
	0xdf093849, 0xcf0c93e7, 0x3af7aaca, 0x8f91f003, 0xa009bde1, 0x4172876f, 
	0x79efc0f3, 0xf647d1cb, 0x3ac86596, 0xa42e63b4, 0x3d1526e7, 0x3c67d646, 
	0x6240eb89, 0x6a3c0618, 0x7c4fc993, 0x14fefd74, 0xae5bec1d, 0x2e2886ca, 
	0x30cc9677, 0x3186280e, 0x092cc1f9, 0xd74793f1, 0x1d74d9f7, 0xe1f0fdbe, 
	0xf71cadc2, 0x3e286291, 0x01da3b46, 0x9f01d7d7, 0xc1081cef, 0x77ef788f, 
	0x78ce7df1, 0x83882f79, 0x461a5739, 0x7ca79e45, 0xc7e5d912, 0x81d53aee, 
	0xa56c7c72, 0xf8123a21, 0x4d999ee0, 0x359f73fc, 0x9c7d09f6, 0xf1559468, 
	0x1b24e662, 0x2ebab73e, 0x25bfde9d, 0x1e6e31ab, 0x7ec9b5c8, 0xcc1e793c, 
	0x6e6f6f67, 0x67a03cdc, 0x05d032da, 0xb163cf90, 0xb66e6f9c, 0x711b2fb9, 
	0x1c7e788c, 0x70edd703, 0x9c493ddd, 0xd28e299f, 0xa0d97ddb, 0x713cee6f, 
	0x8dc7172c, 0x5994d8fc, 0xdabb436e, 0xbc7bf404, 0xfb01af98, 0x32768ad7, 
	0x3cea29bd, 0x41e29bd1, 0x760d1d3b, 0xe9f68bc9, 0x49fa3158, 0xe4517c41, 
	0x302e40c2, 0x583675bf, 0xee57a09f, 0xd8a277ca, 0x2e1d9512, 0xf2fff186, 
	0x937751d9, 0xa27eaa23, 0x39f0cf4f, 0x73f98b8d, 0xabb07ef0, 0xecf9e3b0, 
	0xc2792c23, 0x71961ae7, 0x759dd87f, 0x669202cc, 0xb1c02767, 0x0275ed17, 
	0x6cfed5e5, 0x554ef181, 0x9f794e7e, 0x619598e5, 0x36f583de, 0x45c2e6b6, 
	0xedb6e763, 0x77cf28bb, 0x0f1e56ef, 0x3b78d5de, 0x95d815ea, 0x410fdc52, 
	0xd74039ae, 0xaf421c8f, 0xce57a4bc, 0xcf4546a9, 0xbc78d226, 0x6819e851, 
	0x513f8e3b, 0xa3c697ee, 0x60ebb9de, 0x217b20bf, 0x38fed0d9, 0x25113f8f, 
	0x047a9d83, 0xe70aacf4, 0x4bd47a81, 0x891d14fa, 0xc7365cfe, 0x3cdf10a7, 
	0x015ff30c, 0x1f4159f7, 0x7983a91f, 0x7ffae195, 0x1dda227d, 0x956ec4a7, 
	0x88b3dec1, 0x38c7df83, 0x7ed09f4a, 0xc06faf1a, 0xaee90bfd, 0x8830a433, 
	0x4ef6d73f, 0xf80a3f7a, 0xa5953ebb, 0xbc36bce0, 0xd605e3b4, 0xdce396ad, 
	0x9e27687d, 0xf4d834e9, 0x34dec740, 0xbaa64fb6, 0xb456e90e, 0x1ae1c79b, 
	0x89de9bb7, 0x41780fb8, 0xf5fef816, 0xa7d9ee57, 0x411b77de, 0xdd3f705f, 
	0xecfb09d7, 0xe1cf7c44, 0xa47f7873, 0xcf9bdbb0, 0x0fe8ca24, 0xbef34ded, 
	0x74dfcf88, 0x7f43e804, 0xa291ceb5, 0xf9c9f78f, 0x0337c81c, 0x196c72f8, 
	0xcffa17f7, 0x73fdf367, 0x0fef9b20, 0xc9dffeca, 0x2b3faaf5, 0x76bbef9b, 
	0x43df5d71, 0xd4ba2976, 0xd838ee31, 0x9bd41aab, 0xd45fc10a, 0x360d27b3, 
	0xdf800fcc, 0xdf814722, 0x0de511b2, 0x32f0f7eb, 0x9b397fee, 0xaf62889e, 
	0x186ca3d2, 0xe84e22a7, 0x05bb46e9, 0xdaf504eb, 0x07966f78, 0xd8dd5278, 
	0x8d497e47, 0x80cacfa5, 0x71658fdf, 0xd61aa0bf, 0x3c76c1d3, 0xf0abdb32, 
	0x0bb05a9e, 0x0fe74019, 0x28a9f9e1, 0xf0e737ef, 0x3f0af9f5, 0x06f3826e, 
	0x89f9d02c, 0x3d446cc1, 0x978e197a, 0x9db93f51, 0xc7397fbe, 0xfd625d3b, 
	0xf5ce5a8f, 0x5ee306bf, 0x13ecff78, 0x5fe8c9ba, 0x9e7c2cba, 0x99cc9d77, 
	0xcd457e8c, 0x203fa093, 0xeb1316ff, 0x631273ba, 0xefe95999, 0x4ef902cf, 
	0x6b7beac9, 0xf659e816, 0xf819605c, 0x09f5d515, 0xc456ec07, 0xf3059957, 
	0x7de21120, 0x3417e0fd, 0x4c5896fe, 0xe9f229ff, 0x7f7a9187, 0x3f7bec56, 
	0x85f3fb83, 0xfcaa343e, 0x5538c0fc, 0x19357bc4, 0xa5e7fb37, 0xaebabd53, 
	0x8a3bd232, 0xb5cbf443, 0x3495adf2, 0x2db7765e, 0x95d21c64, 0x7f469c0a, 
	0xc623c444, 0xb3188f9b, 0x5abaf655, 0xe004b9d8, 0x8a51fa3b, 0x86fdabbd, 
	0xad50ec81, 0xb5ec2f51, 0xbaf6871c, 0x6fa19b76, 0x6b5fd00b, 0x9bfb4cda, 
	0xa2d67fb2, 0xb5a3b5fd, 0xf50e37ba, 0x70ed1bb8, 0x33723e2d, 0x7e24ce7f, 
	0x38a676bd, 0x79063da2, 0x6389e6d7, 0xe46e38b9, 0x3d231fc7, 0xe37d0b9f, 
	0x71f7fd7e, 0xbc44fb5e, 0x767370d1, 0xb10a8b0a, 0x9f853a1e, 0x34ff0b2e, 
	0xae073ec0, 0xd91de70f, 0xb3b4467d, 0xd824d9a9, 0xe409a3ba, 0x70c5d6ff, 
	0xe16d51bb, 0x4cd1eaf6, 0x69d70529, 0x3eef28dd, 0x8c8157f4, 0x9f16de7d, 
	0xf187dc7d, 0x5b2bae05, 0x66ebb736, 0xbbe73cfe, 0x36f928ce, 0x7824dfd0, 
	0x3ecfa95e, 0xbec07b39, 0xf58258e0, 0x80d9cf0f, 0x79c42efe, 0x784ede9b, 
	0xb9d7f501, 0xca1ce1a7, 0xcdf424d5, 0x10b8fc85, 0x25b85f3c, 0x2762fd05, 
	0x1afd43d8, 0x3e039fc1, 0x8a1e6d7e, 0x576abe3f, 0x12bf1fc7, 0xda3364f6, 
	0xfb07581f, 0xf7b03c44, 0xe38a29e4, 0x14c62c1a, 0xef81375c, 0x7e4a3cdb, 
	0x787df681, 0x71fc5fae, 0xe71fdb84, 0xfaf67b95, 0xfc0101c5, 0xdef9fcde, 
	0xf66f6873, 0xb03ef0c9, 0x7989effb, 0xaa2f7d01, 0xd9bd67ed, 0x32f5c368, 
	0x081580e8, 0xc2c1aa71, 0xc0bd56f1, 0x462723b1, 0x1f950f2e, 0xd78cb1da, 
	0x1dca1cef, 0x417bd745, 0x2f1d707f, 0x2bfdce59, 0x7b7153f4, 0x9cf95c23, 
	0x245f47f0, 0xbe13a57e, 0xb9be44cc, 0xecb9480b, 0x6388875f, 0xf113ac93, 
	0x79e064bf, 0x7f263e45, 0x8718f815, 0x9a61f478, 0x5e59da6a, 0x27501817, 
	0xf2f74de8, 0x813a4de7, 0x2778b1cf, 0xc9e3e49d, 0xef5cf43d, 0xfcfe5ee4, 
	0xf1f3ce5b, 0x06efe82d, 0x1ea2b9f9, 0x992ed350, 0xc92ec95b, 0x89d99af3, 
	0x44bb6d7a, 0xf73c3b7e, 0x7e53b8a1, 0xa7e288f1, 0xfd70d7bb, 0x22a5f9a6, 
	0x07c42c5f, 0x102f8b49, 0xbd1f103f, 0x0df65c7c, 0xa6fd1da9, 0x2bd38138, 
	0x137a9275, 0xbfc8238f, 0x7bfc2f9f, 0x9d5e77b2, 0x8bf101fc, 0x379a10e2, 
	0x3d08b78c, 0xd41e27d1, 0xc4a1fee3, 0xede50f39, 0x1e78c338, 0xbb21e2d6, 
	0xbd62b5ed, 0xdbb0be4a, 0x304fb14e, 0x3ca1e4bb, 0x60e724b1, 0xcdf8155d, 
	0x942e34dd, 0x32ccfc68, 0x741a1f9e, 0x89bd212c, 0x3cb7989c, 0xac55bd54, 
	0xe50e6fd8, 0x0afb8be6, 0x60b7de42, 0x2b87a2b9, 0x7bdefae8, 0x30cb8c9e, 
	0xf766dd80, 0x8e29b1fe, 0x4d75e5e8, 0xbf818768, 0x771fb8d5, 0x274e3da1, 
	0x9d9dd43f, 0xbd6feb4e, 0xf451f7cc, 0xc999e747, 0xc03f5a1e, 0x3df307f5, 
	0x2b9c7c01, 0xa4dae1fc, 0xb7e8ed53, 0x9366cf38, 0xe4ce74fd, 0x62e592c7, 
	0x91b3fd3f, 0xc33651f6, 0x02eafb48, 0x8dcba3e7, 0x45b5bbf0, 0xefc85a1f, 
	0x18b8e528, 0xcf98d5c6, 0x63b9e097, 0x909bfe81, 0xff7803ef, 0x3846e5fa, 
	0x687ce656, 0xf148fb45, 0x5e2f8e42, 0x99ef06d8, 0xd78beb4e, 0xe2217d6b, 
	0x3a478a72, 0xe518bd78, 0x1c41a715, 0xc78aa9d4, 0x2ca0e203, 0xe20a4e6f, 
	0x394bbdca, 0x9afaf4de, 0xe153a206, 0x8edbd82b, 0x673e0b56, 0x8bfc5447, 
	0xdd753efc, 0x4bd72b99, 0xaeb04ff5, 0x4fa42d2c, 0x07f36f6c, 0xd016ae9c, 
	0xb94b738f, 0xe72de79c, 0x68fc52f3, 0x7d20f7aa, 0x70adc564, 0x79cbe3ff, 
	0xee27581c, 0xc58f5f0b, 0x617e85fd, 0x5fdfae67, 0x0ac3c8d0, 0x4f28617f, 
	0x7cc27e89, 0xf9d48f6e, 0xd72c5f8b, 0xfa045fc8, 0x8bf9410b, 0xe3fb9637, 
	0x488dfb83, 0xc0bbc6c7, 0x7e1e832c, 0xff467286, 0x4388eecb, 0xebfc553d, 
	0x8ecf1fea, 0xbf426a4b, 0xf311e84b, 0x78cb7bb6, 0xc484eefe, 0x4798a7d8, 
	0xefcaaf5b, 0x18fd2d24, 0xe8e83b9f, 0x49fe8e5e, 0xf8577da0, 0xf986ee79, 
	0x05d7c35f, 0xd9e7e384, 0xa7e7e66b, 0x20f9d5cb, 0x59fd9f85, 0xfd09fcef, 
	0xdba88b40, 0xd3ff04eb, 0xd1f50179, 0xc57da16b, 0xfb2debcb, 0x065f702d, 
	0xc9674fe2, 0xce3a0cde, 0xe787ec69, 0xc787ee43, 0x3f55ec86, 0x89c8a1d9, 
	0x5f790b7f, 0x9f7dd0c7, 0x6c9b7dd1, 0x0388d1f5, 0x8fb77a6f, 0xb14d81fc, 
	0x79ca0a72, 0x97af85a3, 0x64f3c023, 0x0959afb4, 0x7ecbbf44, 0xcc316e2c, 
	0x886e5ab7, 0xe7eb0c5b, 0x97bc837f, 0xe09ff5c0, 0xd5f6a9fa, 0x6cfd52c5, 
	0xa0e4e23d, 0xdb88bd37, 0x3b82b56f, 0x9d5febc8, 0xd5d63ae2, 0xb9564ac6, 
	0x10fff30d, 0xabbd81e7, 0x06218df8, 0xfd9aa5fd, 0x9e611fb0, 0xab56fcf4, 
	0xbb79f905, 0x7de187b3, 0xbca7efb7, 0x486ecb9f, 0xe160fdc7, 0xdba3d2d4, 
	0x729dae21, 0xcf2de773, 0xa4bb5c61, 0xf305a8e6, 0x8f187a22, 0x917fcdf3, 
	0x153fd39d, 0x4e54ce54, 0xe8d6c379, 0x303e2137, 0x60cdd1b1, 0xe3efa34f, 
	0x51f405f6, 0x61657687, 0xe1df5f3e, 0x49c149f4, 0x89bd6116, 0x5857183e, 
	0xcfe1af90, 0x4e344aa7, 0x830c4db3, 0x8f96dc2b, 0x9f88107a, 0xd822fd51, 
	0xa9069ab9, 0xd3577f07, 0x0e8e7e00, 0x27bf21f9, 0xf9c951f8, 0x3c5ef6d1, 
	0xe9b9b1d0, 0x219dcac5, 0x7ec8b1f8, 0x8652c12a, 0x027378f8, 0xf62c6f84, 
	0x2b771e3e, 0x06fb787c, 0xbe48e1f1, 0xb4babac6, 0x483fc696, 0x433f70b1, 
	0x961fff1b, 0x48071e0f, 0xe5b00bec, 0x8a2f1cb1, 0x7e40f89c, 0x971ffd28, 
	0x2f7dd4af, 0x0ffd47c9, 0xfe74afa7, 0x035bd09c, 0xfbf025ea, 0x1d5bd0b4, 
	0xc2b0e1d2, 0xa81566e2, 0xfbdf66a7, 0x3c83f66a, 0x34f5ab4e, 0xc7ede3f5, 
	0x86ff2e49, 0xb92d7072, 0xf9f8e3f3, 0xdb7f9724, 0x2e582bb9, 0xc2528f24, 
	0x93ad5b7d, 0x3b5b8f88, 0x20bc84ca, 0x8fb98f2e, 0xd39153f3, 0x0a72811b, 
	0x921a43ac, 0xb549c713, 0x4b5874e4, 0x1a2e034e, 0x0ec9aa1f, 0xfda7a723, 
	0x201154e4, 0x3fa7aa27, 0x4eff5be3, 0x9f856fc1, 0xaf883c8a, 0xa50e42cd, 
	0x90b2bf82, 0x67e00ec3, 0x2a1ff826, 0x82792afe, 0xeeb33729, 0xe55e5506, 
	0x1dfd623b, 0xdf5ff7c8, 0xfbe7c83f, 0xa5f948cd, 0xd21c1f85, 0xc72957e2, 
	0x6348af95, 0x038bf635, 0x77fdeaf9, 0x3f19f961, 0x2461795c, 0x680f9193, 
	0x2e24d8af, 0xd157dc6f, 0x697c515e, 0xfd62b692, 0xe50f03eb, 0xca3f436d, 
	0xad1980e3, 0xd45bff03, 0xfc4e4705, 0x7f287e61, 0xff486db5, 0x7af3e70f, 
	0xdd6837c2, 0x375a198c, 0x375c866f, 0x777e876b, 0x6deefc44, 0xe8799dfa, 
	0xfc84ef7d, 0x057cccdd, 0xd125ffc7, 0x02ff44e3, 0xfbe7f7ce, 0x846b17fb, 
	0xfe81517f, 0x7fb6a445, 0xda145ee1, 0x384160bf, 0x38759165, 0x2ae2b29c, 
	0xd441ca71, 0x9709cf9f, 0x538508ec, 0x94e10c56, 0x4e204b3a, 0xd2489bf9, 
	0xc16ba49b, 0x3f994b29, 0x7514e94e, 0x786cfd1e, 0xec4ab29c, 0xf90b55eb, 
	0xcb155ebe, 0xc1cf3c6c, 0x702bf5f7, 0xf040f26f, 0xc1915ebe, 0x45caf5f7, 
	0xceef5f7c, 0xa7fafbe7, 0xaf7c4cf9, 0xfb85f306, 0x313cc266, 0x653841bf, 
	0x5b8fcf87, 0xf1aff058, 0xf24598e3, 0xa0643da0, 0x69f31d35, 0xf077763d, 
	0x738d1a3c, 0x303e380a, 0x402b88e8, 0x65fa9bbd, 0x0b6e0694, 0xa61f04f2, 
	0xfdb70022, 0xbbd79f28, 0x6aff5832, 0xc142b6dc, 0x1ebe616d, 0x4b67c093, 
	0x8f3b8e05, 0x3f0ed1f0, 0x9e40365c, 0xf84997a0, 0x0219b5fb, 0x72051d97, 
	0x2e22e7c1, 0xafecf30b, 0x956b97f3, 0xa552f3cc, 0x9d569d53, 0x05672c1c, 
	0x48ccae27, 0x1a533e37, 0x7870befc, 0xe6f3e06d, 0x76fc7014, 0x5b66efe6, 
	0xbf512312, 0x6f44ed99, 0x6d5b6e30, 0xdf509291, 0xf833ce67, 0xf09ffbe9, 
	0x82db8459, 0xdfbd83be, 0x0deb9730, 0xc30fb4e1, 0x3ec1e6fb, 0x6bf03bff, 
	0x6817ae25, 0x5d956557, 0x1b77e70c, 0x41775799, 0xa037ef56, 0xb1775871, 
	0xeb0198e8, 0xa25f6970, 0x0a07a2ba, 0x7fbfd942, 0xeffe2be4, 0x379e0292, 
	0x4b41fbe2, 0xa07ec041, 0xc3c8e7e9, 0x0a5b9fee, 0x1e8ceab4, 0x18fff1a3, 
	0xff66169d, 0xeba81774, 0xfb015c48, 0xd3e348e7, 0x3af46e37, 0xb4f8c6bc, 
	0xe35ae0ab, 0x6aa4e029, 0xca98ac7f, 0x038f29e3, 0xdcfb0524, 0xe77da1e8, 
	0xfb5082d9, 0x6502d2ce, 0x7a46dabf, 0xa1fac6e0, 0x90fd5552, 0xe09c9bc0, 
	0xde81b477, 0xdfe0cd4e, 0xa0547d43, 0xe7543df9, 0x3df403d8, 0xaf737b54, 
	0x17a87bef, 0x74f7c40b, 0x2a978758, 0x55faf4ea, 0x97930a79, 0x599cf4ea, 
	0x2528bbfc, 0xc7f7810f, 0x6fcb0466, 0x86913b3a, 0x33b324f6, 0x5bd71d27, 
	0xc5ea6c6f, 0x37cfe0dd, 0xfd7f3adb, 0xcf3df83c, 0x3bcba41a, 0x5e717d78, 
	0xff382be3, 0xde7a0143, 0x30fb717b, 0xedceeff7, 0xe5f1e02a, 0xe3a1051b, 
	0xae4337cb, 0x940a479b, 0xae847375, 0xeff67a2b, 0x0f2a3705, 0x749d7c32, 
	0x8bdf7b38, 0xe7007ef6, 0x2fcd11f5, 0xd33177dc, 0x53885d45, 0x406c1ea3, 
	0xb88f1d6b, 0x20b7bdee, 0xd5183d54, 0x846f5b61, 0x9277fbdd, 0x8197fe9f, 
	0xe43faf76, 0x487b787a, 0xbc05037e, 0x5a73eebe, 0xeea2f147, 0x502ba94b, 
	0x00575ff0, 0xc00aebfe, 0xf8015d7f, 0xff134baf, 0x7fa18905, 0xeedff02e, 
	0x06d3d842, 0x4baff87c, 0x00aebfe0, 0x85c7f7fc, 0x9caff85a, 0x61b39722, 
	0x3663dff0, 0x577cfb86, 0x2051fbfa, 0x5ea975f7, 0x7bbfe11b, 0xc4847476, 
	0x261bdb7f, 0x31bbfe20, 0x2477bbcd, 0x2bbaeff8, 0xc7f5ed5f, 0xe11b257f, 
	0xe71cedbf, 0x5d7fc408, 0xfe1027af, 0x17f111bb, 0xf5be17f0, 0x6252279d, 
	0xb5ff08a3, 0x6fdf55e9, 0xfc7215d6, 0xf8a15977, 0xef1026ce, 0xe9f6283a, 
	0x69efe176, 0x719ebfe2, 0xdfa077c7, 0x975171c8, 0x4f5d7fc0, 0x05017af2, 
	0x72fcc5ff, 0x3d6df01b, 0xdae81dca, 0x6071c851, 0xa227f8d7, 0x3d706dd8, 
	0x97dc2651, 0x0fb8bcf2, 0xc5ebfe21, 0x29fdc67a, 0x2cd2efc8, 0x4f292bf0, 
	0x62c2ea24, 0x7fc416bd, 0xc221fbf1, 0xb54e937f, 0x617efe63, 0x9d7fc721, 
	0xebee39c7, 0xe417fc44, 0x1bce0b3d, 0x15fc9fd0, 0xfc157dc7, 0xb7338177, 
	0x0fc0f310, 0x73fcf217, 0x1687ce65, 0xcc6e83b4, 0x1e60573f, 0x21f92b7b, 
	0xfc790a87, 0xc6af10c0, 0x09b4017a, 0x4f4e8794, 0xee8959d1, 0x15b1c214, 
	0xecfac33d, 0x38e3f456, 0xde38f9ee, 0xef3c5ebf, 0x587bd534, 0x2bea8965, 
	0x113c798a, 0x693e4388, 0x20a33ac3, 0x7f0b34b9, 0xa7fdcecd, 0x6321c6ab, 
	0x775d9e38, 0x53cd14f4, 0x9c249fa9, 0x21c465f1, 0x7fe87de5, 0xbcfbcdc1, 
	0xf24f88d1, 0x2bd69978, 0x38019bfa, 0x674deba4, 0xa8aafc94, 0xb6fb03ab, 
	0x5312e311, 0xc7b19c08, 0x36798291, 0xf021475a, 0x390a5bbf, 0x04b7087f, 
	0x3d7c6c3e, 0x4f8c05e1, 0x5b5e671e, 0x0e36ab63, 0xf21c42e9, 0x990e3044, 
	0x55f7c85f, 0x5283ae17, 0x1ae90e1f, 0x46ceedc5, 0xa7d229fb, 0x7f083a40, 
	0xc42eeb84, 0xfd3e4113, 0x62df8203, 0x3caf381d, 0x031eb7ed, 0x6e6f5df9, 
	0x6beef924, 0x102befe6, 0x21c40af3, 0x36b92c1b, 0x1e26bb94, 0x3c32391e, 
	0xaf217f7c, 0x3c56b82f, 0x116f487c, 0x387c970f, 0x757d387d, 0x0ff75e32, 
	0xd1b5b602, 0x8df1c8be, 0xdf1c8505, 0x1ef38f99, 0xfa53e350, 0xe53e351e, 
	0x50d4f812, 0x8f264e3d, 0x4ed9dd1b, 0x8855d51b, 0xb99ddc78, 0xa7c6aadf, 
	0x8a9f025c, 0x034be780, 0x5077eeb8, 0x98cb9dfd, 0x0d75f34d, 0x7afef5f2, 
	0x22a7c0a1, 0x2ec52e38, 0x68fdeb2a, 0x814de221, 0x1b26d4f8, 0x9fa859f8, 
	0x71053926, 0x3be5673b, 0x5d552651, 0xdfe42b15, 0xdbd6f921, 0xdeb81d33, 
	0x5975015c, 0xaacea52e, 0x2965d458, 0xe0bfca75, 0x8d2e5875, 0x4b372bfa, 
	0xfc0db3bd, 0xf9468da8, 0xb09bb6f3, 0x79ce45ae, 0xbca5ea96, 0xa49b9f47, 
	0xcbbbf7aa, 0x6772e71f, 0xeedcbd83, 0xc15c9efb, 0x5428beb9, 0x9a5eae70, 
	0x6ae70aaf, 0xe7c76d6f, 0x8beb9c70, 0xcb9c7f42, 0x6d71cb9d, 0x02ad45d8, 
	0x10b5b2e7, 0xd7dde5ce, 0x707fef0c, 0x8283e73e, 0xf4285f7f, 0x87099baf, 
	0xbf16ee87, 0x9bc0741f, 0xb83fd06b, 0xcef1c850, 0xfca1858b, 0xc542fec0, 
	0xd74cb88f, 0xedc85aff, 0x686ae22e, 0x27329b87, 0x75f5d459, 0x4effa14e, 
	0xa14effa1, 0xffa14eff, 0x4effa14e, 0x841bffa1, 0xfd33bb9e, 0xf994f2eb, 
	0xf9f116e5, 0x5e7df0f9, 0xf1c37b17, 0xbdabac7d, 0x5ffdf893, 0x476fdf0d, 
	0xf7c40e55, 0xcec06b9d, 0x7c00def6, 0x5f1bd45f, 0x2edfbe2b, 0xef843be4, 
	0xf7c7f4cf, 0x6120b93d, 0x45b9bfd2, 0x54cff4a1, 0xf3ede0a4, 0x046d7ae9, 
	0x71761a93, 0x03bf1f7f, 0x39ff7f41, 0x28bf8f58, 0xc40efff6, 0xdf591c65, 
	0x358a3b83, 0xe5cad5e2, 0xbaedcf94, 0x0f51a755, 0x8ea4525e, 0x9c16ab57, 
	0xc5aefbf2, 0x5ef8a747, 0xe79ce205, 0x178f0e40, 0xe94f7ff9, 0xf8742efb, 
	0x22c6f3bc, 0xb3a4f88d, 0x2f0fc696, 0xab88d14b, 0x53a485d7, 0x3a0f3bc9, 
	0x7d17c9e0, 0x99f40f7d, 0x741c2e3c, 0x8bcfce3c, 0x4611133e, 0x76a10fde, 
	0x1c6bcc34, 0xac9813cf, 0xf3826f3c, 0x9ff5cc32, 0x44fe6057, 0x62ee5e6b, 
	0x589d798d, 0x903ffc4c, 0x6daf35a1, 0x55fc6a45, 0x3f929799, 0x4c9be779, 
	0xbac07ef9, 0x78f230cb, 0xef7e0275, 0x2f8e7988, 0x4f2bda7b, 0xb5b2d1e3, 
	0xc4f98752, 0xcfe71d2d, 0x50e33630, 0xe8257b5b, 0x9bf0ddc3, 0x388baa52, 
	0x349f71c1, 0x1f832ac9, 0x449f8a04, 0xa769c679, 0xb8a8fe28, 0xdd1b5b24, 
	0x325a7a78, 0x865651ea, 0xb0fdc2c1, 0xcfb83d8c, 0x923bb6ce, 0x12bf0eb0, 
	0x75a793bf, 0xe7093c76, 0x09913c7d, 0xac9b957b, 0x11f4478e, 0x21b39273, 
	0x5e6370d8, 0xaae3fc1d, 0xb8c90d79, 0xa9df288e, 0x8a9a2f8a, 0x4af43e79, 
	0xbf1df291, 0x84eb1ab1, 0x61cee78f, 0x77955966, 0x4bea279c, 0x7baf75c5, 
	0xb99fe30e, 0xa9b1e50e, 0xde2866fe, 0xaa6df938, 0xfe132d37, 0xfac5dfd0, 
	0xfc91bf04, 0x8cbfac0a, 0xc87ac5ea, 0xbbcc68fa, 0xa4ff6054, 0x09b75136, 
	0x88b23ff7, 0xcb8493d7, 0xb9e5696b, 0xc3745afe, 0x7f4230ea, 0x63d62f27, 
	0xb9d73cb8, 0x73cd6ba2, 0x5bd3f59d, 0xe835cf25, 0x54eb4738, 0x2ea1d62f, 
	0x41b7af97, 0x428b5fc7, 0x4e4451d5, 0x50a2f7fc, 0x8bafff71, 0xeffafd94, 
	0xe5fc6a45, 0xf7ce62cd, 0xde5fc5ab, 0xfe21e785, 0x5fc6aff0, 0x291e2a9e, 
	0xd649e2fe, 0x5a3e62b7, 0x5fc00a4a, 0xf0b56f48, 0x095f0517, 0x1148f3a4, 
	0xabfaafdf, 0x7d6579c5, 0x99a7d004, 0x77d80a6f, 0xa37407dc, 0xe70675a6, 
	0xd9694e9b, 0x1a5c81bd, 0x61f1cc9b, 0x73b0c6f2, 0xc7c60c5d, 0x07e3ef95, 
	0xab16771d, 0xb0a477ed, 0xdc69d5df, 0x8af5c02f, 0x77e077fb, 0x07796e65, 
	0x1df4e1c5, 0xdf8a44d9, 0x816afee8, 0xfef1b877, 0x8778dacb, 0x466f7c4b, 
	0xf28c3fbf, 0xfa414eee, 0x39be31aa, 0x38778c11, 0xefc0be21, 0x88d70888, 
	0x991df10e, 0xd2b0fef8, 0x370ef1ce, 0x7a2a1be2, 0xbd20a709, 0xa0ac79e3, 
	0xbd4513ef, 0x2b7d387a, 0x76f5e62a, 0x7d1addf8, 0xdfe16887, 0x816694bb, 
	0xe1f56ebd, 0xe78b571d, 0x9962fd51, 0x7002df4a, 0x29be0fbc, 0x1e802df4, 
	0x2ec901c2, 0xeeac543c, 0xa995144b, 0xbe1a7bf4, 0x4c3abcee, 0xa68f143f, 
	0x5df7c3df, 0x3453b7fb, 0x8aa79efc, 0x88a1fafd, 0x094f5abe, 0xcc5d1bfd, 
	0x370f85ed, 0x665f10f4, 0xc249c91d, 0x257e28f9, 0x169e29c6, 0x3d135f9c, 
	0x49d8c22f, 0x2bc63478, 0x16af6eb8, 0xd147fbbf, 0x8efc1dff, 0xc3ed3ee8, 
	0x3bb708ef, 0x84c7ac1f, 0x1e92f5d7, 0x435d6326, 0x2d5b1eb0, 0xa576e1c3, 
	0x123edc75, 0xe3c25abf, 0xb317af78, 0xde5ddf90, 0xadc7a7f5, 0x119ab798, 
	0x4b8f48c3, 0x6f7f8c2d, 0xecfc1ac9, 0x139418e4, 0x276071c5, 0xc7e2423b, 
	0xa5e3b416, 0x6dfedf62, 0x30bae871, 0x79fe3f05, 0x3f8fc711, 0xad59fb43, 
	0xfbfd13f6, 0x89fa0489, 0xf6afed23, 0xd97b2d57, 0x7afa479a, 0x1a59e8df, 
	0xe2a9edfb, 0x92affe50, 0xfc741f9f, 0xffed58b6, 0x5fbe8846, 0xa971bf8a, 
	0x7dd706f8, 0xfdbe235e, 0xef0562b7, 0x9e104e00, 0xbb3f37f3, 0xe1761260, 
	0x4b8671fa, 0x7c60dcf4, 0x287172f5, 0x58a7a37f, 0xb3fe37f1, 0x3b8dfd18, 
	0xc5e59a7e, 0xf727bebc, 0xcf84e2ab, 0x89d93090, 0xee1a76eb, 0x7ce3f737, 
	0xcdbadc78, 0xe50d3acc, 0x0b70f8c1, 0xfb0165f6, 0x4ec4cdba, 0x0f9f78ea, 
	0xa956b8bf, 0x789b77ef, 0xc6d5d0fd, 0x3366fdfb, 0xaf894fbd, 0x1b7ff895, 
	0xbef8bcec, 0x5fdb2fd4, 0xea57fd42, 0xf3a6bfda, 0x0725d4be, 0x0b49f1c7, 
	0xbfd6ddb8, 0xa93f587c, 0x6181d719, 0x6879e30d, 0xc89d878a, 0xd23fb87f, 
	0x609ace92, 0x7bc147bd, 0x4e230e9b, 0xd4df5190, 0x718b638b, 0x3d8c9dcb, 
	0x82f20399, 0xb3d591eb, 0x314a5b8d, 0x839de52b, 0x2291ffbf, 0xce3fe6bf, 
	0x27cbfa46, 0xf5f9f2c7, 0xf143986c, 0x7c31bbc1, 0xaf9d117e, 0xd02cf5dd, 
	0x29a5cf71, 0x34fc7099, 0xf502bed5, 0x59ebf239, 0xdf30b253, 0x077de3d7, 
	0xbdc9e7e5, 0xcfca0573, 0x9a2732b9, 0x927ce7be, 0x65337f7f, 0xc71d9f42, 
	0x5037de53, 0x09c2187f, 0x31a9be80, 0xd956c3ec, 0xdfe76717, 0x2d6be3cf, 
	0x6ff14ebc, 0x69bd169c, 0xfaf05f5a, 0x5685707d, 0x6947a03f, 0xcffff6fd, 
	0xcdfb1a39, 0xd7a85737, 0xbf1dd82f, 0xf1d07b38, 0xfaf50ae0, 0x79bf0a35, 
	0x7df78c42, 0x83f52be4, 0x2df78039, 0x8599f7e5, 0xe2546d7f, 0xdfbf7cdc, 
	0xfc54ca8f, 0xf3bf22ee, 0xfefcb9d1, 0xdebc09cc, 0x450fb02c, 0x3ec08acb, 
	0xcd76fe14, 0x6a607e85, 0xb4d81fb0, 0x3e1f6342, 0x078d28f9, 0xf18566d6, 
	0xa15b1f03, 0xec0bbfae, 0x8ef60143, 0x4fb159e7, 0xa49bc890, 0x1e397076, 
	0x81167a00, 0x9908ce3d, 0xfb71e08f, 0x1eea35d7, 0xbdd169f6, 0x5e0dd798, 
	0x187269b8, 0xc569b4bc, 0x830f7570, 0x6a15968e, 0xebeb16fb, 0xfea238c7, 
	0x7efc5a2a, 0xf6ee8b4b, 0xe5be3445, 0xa97570e3, 0xc28456fb, 0x0f7e1579, 
	0xf4fd3a3a, 0x51f424c6, 0xbdde6f4b, 0x99f9bd46, 0xf20e3cd6, 0x2e87a8be, 
	0xffc30f8c, 0xe3ccc2b7, 0x7dd42b67, 0xca8da346, 0x4fd778ba, 0xfe43312e, 
	0xe5c9f5e8, 0x7d5ad5b1, 0xf8d0366f, 0x985d19ec, 0x761c9cf9, 0xe029b53e, 
	0x2d3e208f, 0x39f19349, 0x837ed0a3, 0x46e4f4ff, 0x0b7364eb, 0x0993bbed, 
	0x93cb3147, 0x399edf31, 0xfd794bc1, 0xa7f28935, 0x1f11472d, 0xf9fb7ced, 
	0x3de8f09b, 0x7cfa83b9, 0xc76b7179, 0xdf3fe9fe, 0x1481384e, 0x1c75fcdf, 
	0xea0f7af3, 0xc0740b2b, 0x94c72296, 0x5ecbfafb, 0xef9fe05c, 0xc9e40677, 
	0xeddbd6b4, 0x27ecb52b, 0xc66d178f, 0xfa89dfd0, 0xd86173f8, 0xcbf536f5, 
	0x35e5dbf7, 0xde66bef8, 0xb1e44aff, 0x3aa7495c, 0xa673a710, 0xf2921c71, 
	0x889fe858, 0xf989c7b8, 0xcb19f7ad, 0xd97f80b2, 0x563cf23b, 0xfb3d97ea, 
	0x7e638ed0, 0x6609eb0d, 0x14b3fbbc, 0x13e96bcc, 0xe7c07f2c, 0x124c5e52, 
	0xa25dae79, 0xbf2a8b0f, 0x9e4ac2f5, 0xa5687adf, 0x302b7e46, 0xdf910f7e, 
	0xfc451a3a, 0x2867fc25, 0xa5e5d5bf, 0xc8b556fc, 0x92b03d6f, 0xf98137fb, 
	0x6fc8a72d, 0x5bf20339, 0xb9471f98, 0x667ae1b9, 0xbe9f3d2f, 0x91efa5f7, 
	0xdafa3f61, 0x0fe7ae4a, 0x1db2feed, 0x9fca7b41, 0xf5f2f8b7, 0x0e8f4794, 
	0x89af93ce, 0x21ee2f95, 0x5bb5bdc2, 0x0875c65e, 0xbc10da4f, 0x8f348d3f, 
	0xbfe562b6, 0x970dafc6, 0xd2d42b47, 0x3479b0eb, 0x0e2a8c90, 0xd9bfbe55, 
	0xa55df224, 0x5df3fd2b, 0xabbe451b, 0xcbbe4c2a, 0xfd0bbf02, 0x958ad33d, 
	0x2b70f3a1, 0x8bf28657, 0xfc54afa7, 0x5eba52e2, 0x4952fa8d, 0x785bd3df, 
	0x57d6043e, 0xe073f637, 0x92bde2f6, 0xd555f1d0, 0x595f1e3c, 0x604b79e1, 
	0x3e908b3e, 0x6371075e, 0xac0534fb, 0x2355f88f, 0xac94d3ee, 0xbae08fce, 
	0x37f94b3a, 0xb571a75e, 0xc144b7f9, 0x5bf5a1ff, 0xadfe4c37, 0x01fbfaec, 
	0xad72527d, 0x585e80fd, 0x034bf6a9, 0x6d5d01fb, 0x5787a8df, 0xe18bf92a, 
	0x78cd46fb, 0xb1df4acd, 0x0a89f50f, 0xe80dffaa, 0x07601513, 0x9252b1dd, 
	0x27d7d7a7, 0xe80df28a, 0x89f50f4f, 0x2a8ef9e2, 0x85201fec, 0xe98463c8, 
	0xc23d551b, 0xc21f51be, 0x7910a57c, 0x8df411af, 0xa7b7d3f2, 0xfea85f51, 
	0xe78df418, 0x0fbbffa5, 0xf7f5d953, 0xc951fa61, 0x74c3ee8d, 0x987d8ade, 
	0xf4695712, 0xeff5ca61, 0x759954c3, 0x987d4acc, 0x30fa03b2, 0x4d713e2d, 
	0xb9fe987d, 0x04c3e952, 0x03bf0d96, 0xfb01bd43, 0x93aa3336, 0xbc8d8bfa, 
	0x8a5f530f, 0xfa48fe6e, 0x34baf130, 0xead3cfc5, 0x894af4c3, 0x69261f56, 
	0x130fba8f, 0x2bde477d, 0xbf272bbe, 0xaba7e783, 0xf2131fb0, 0x09f01b7d, 
	0x81feefe6, 0xe1d38fa1, 0xe456c1b5, 0x739f33f3, 0xab73e126, 0x6987de64, 
	0xf5037b5d, 0x7669aa61, 0xa61f6124, 0xd41d070d, 0x8ab9c987, 0x6954f5d7, 
	0x569261f4, 0xd5d43cf1, 0x79aa61f6, 0x56ec9d2e, 0x4889d60d, 0x2530fb21, 
	0xa61f4b5f, 0xc987d8f5, 0x4c3e8232, 0xeaa23a0f, 0xdd57645f, 0xab27e987, 
	0x130fb7ae, 0x38edad7b, 0xcec637c4, 0xa79f3b8d, 0xb7a7c97a, 0xd7ee3f72, 
	0x4423bedf, 0x53a0261f, 0xfb3aefc8, 0xd51b3130, 0xdc3a8acf, 0xf59192ce, 
	0xa256da61, 0x0deb8755, 0x0aa987d9, 0x556e83f7, 0xde25ee1d, 0xc3a94987, 
	0x74b3daad, 0xaa0fc60f, 0x87512dba, 0xe315b86b, 0x1d61ef85, 0xbfe889ae, 
	0x8ddc3aae, 0x7bb87501, 0x6ea9737b, 0x7f587bf5, 0xd564fb08, 0xf9194495, 
	0x740cd352, 0xe3d704b6, 0x79e12bae, 0xd7254590, 0xf03b8f59, 0xe2e3d511, 
	0x67ff5e56, 0xe4c7eaa6, 0x8f550a48, 0x386f758b, 0xdfc2b3ff, 0xebc83e72, 
	0xc12e3171, 0x26f100f5, 0xac4e66e1, 0xfca56dc7, 0x53ff7d3c, 0xc0b8f58d, 
	0x1f84c7f7, 0x71ea255b, 0x577f60ab, 0xaef6e3d7, 0x7dc7a80a, 0x5d5f1f8b, 
	0x94f3ea25, 0x97d15c7a, 0xb72331e9, 0xfc4a73d7, 0x29fecaeb, 0xf63541d6, 
	0xefc32a63, 0x5bbf41c1, 0x9498fd7c, 0xd8d54cfe, 0x768d698f, 0x05fea63f, 
	0xd5507fbc, 0xf6038482, 0xe9c7d132, 0x725c5f03, 0xfe0dd579, 0x1f1340be, 
	0x3f6759bb, 0x6997dda3, 0xf6b5d570, 0x638e0265, 0x97d0125c, 0xf81dd689, 
	0xdcd955ff, 0xf3c2e5ee, 0xdb096fd1, 0xd0c9a997, 0x7c33a5b7, 0x5585ea1d, 
	0xe997d7d7, 0xe947a08c, 0xb8e834cb, 0xbc742abc, 0xa8556573, 0x56f7ad3a, 
	0xa05a7529, 0x3cfeaa29, 0xeb024b73, 0x3fbbfef7, 0xfea57fcf, 0xbd433f3c, 
	0x85efd750, 0xa0b3cfe9, 0xf3faeae4, 0x529574fc, 0x429a0a8f, 0x2bee2c7d, 
	0xb34f1509, 0x16bf4512, 0xc17af094, 0xd284966f, 0x28946fc3, 0xba22f771, 
	0xff5d542f, 0xfaeae1a4, 0x5d635de7, 0x14a5d1ff, 0xc5fd2937, 0xde3c2caa, 
	0x1653347e, 0x3da4c5fd, 0xb498bfbc, 0xc5fd4467, 0x62fef216, 0xc5fd4155, 
	0x16ff1d78, 0x02f7d189, 0x317f451b, 0xfb21a7b0, 0xf90bb58b, 0x1b17f705, 
	0x4abfaebe, 0x897faea3, 0x02ab1fd8, 0x46abfaea, 0x7bf57f71, 0xbed14ef3, 
	0x5fd755a4, 0xf7f5d4a5, 0x5d655f66, 0xba926e7f, 0x84af3fae, 0xbfd75b0d, 
	0x504f7be1, 0xd30d7bdd, 0xb4cbec87, 0x5a65f44e, 0xf9b3eb67, 0x0fb7bdd5, 
	0xe36997df, 0x5f6c362a, 0xf112b6a6, 0x5f504b9d, 0x424b17a6, 0x5d03bdd5, 
	0xa997d8c9, 0xf745c446, 0xf1aabca3, 0x0c97effe, 0xbba997d7, 0xd32fbfc4, 
	0x29bf6124, 0x7d5eb13e, 0xabb1a65f, 0xb7f57a94, 0xd5ea024a, 0xe132fafd, 
	0x65f7c37d, 0x10df7fe2, 0xd5eb1cf5, 0x677d622d, 0x6979f097, 0x41fa65f5, 
	0x6bff9f09, 0xaa80df78, 0xffc9504f, 0xfe1bdf1f, 0xdfc144b1, 0xf3bb213f, 
	0x7cce0396, 0xf8fa86c1, 0x0eee3f5e, 0x6f1c4533, 0x8c4331cb, 0xf770a987, 
	0xdced21f3, 0xd73b2189, 0x854e764f, 0xe5d5f92f, 0xd56b575a, 0xd3bf8ae5, 
	0xdcc781a9, 0xffc35ab4, 0xa92e3119, 0x7faa1d5f, 0xfe3faf8b, 0x68cbfac8, 
	0x169221e1, 0x1fc6237d, 0x9f490a6f, 0xce047f0f, 0x3f890c5d, 0x2d6e888e, 
	0xa2d66ebe, 0xe3f8c47b, 0xf70f56d7, 0x1d074ff7, 0xbea1d5f6, 0xfd7ebdf3, 
	0x75f9c39c, 0x667ea04f, 0x5fb50eaf, 0xf4542ff7, 0x19f52413, 0x3d58e5d2, 
	0xea2a2e3c, 0xbc9d4484, 0x81b7a01c, 0x0d4ef275, 0x85a53efe, 0x17188e23, 
	0xafe3f22d, 0x7caf2752, 0x2b799bc7, 0x983dbbd0, 0xfdabf5de, 0xdfdf5c71, 
	0x4ef4e079, 0x5ae3d0d3, 0x6b2b7a2d, 0xfe6cff28, 0xfc387249, 0x3ebd243f, 
	0xad5dae3d, 0x424d71c6, 0x0072de1f, 0xd5905fc5, 0xc9e5fb24, 0xfb9ab0dd, 
	0x87571b5f, 0xcf2f37b2, 0xcdaffc57, 0xad4f9e42, 0xcb0f8d0e, 0xe1f6727e, 
	0xfefee1c3, 0xdd72f0df, 0x466eb5a9, 0xf4ef0f8c, 0x7281ef5b, 0xbf3c741d, 
	0xab2f5d5a, 0xa2dc09f0, 0x6379f0af, 0x9770e0cd, 0xf6fc98d3, 0x6cb3b0d9, 
	0x766eff01, 0xa1b18646, 0x7f2bae94, 0x5ea02897, 0x7f307989, 0x290f7f8c, 
	0xb361e202, 0x9e46a59d, 0xccde2c65, 0x326ff54a, 0x3bd3bc5f, 0x555cdf14, 
	0x00cb12fd, 0x5fee1427, 0x24f3cddc, 0xdf7a33b3, 0x763d20f2, 0xa9bd4526, 
	0xcd528f8a, 0x19537df4, 0x6f9447c6, 0xf806d391, 0xbefedaf1, 0x15b662f9, 
	0x5fea0be3, 0x117585e0, 0xaa87a525, 0xb0ffd293, 0xee7f8f53, 0xbd79d597, 
	0x3646b384, 0x3966dad3, 0x967c6b32, 0xfbc46b9e, 0x1364078d, 0xa88c83e6, 
	0x3ef7f46f, 0x738f2325, 0x1e47e364, 0x47a2cebc, 0x505c9c41, 0x5182edca, 
	0x07f1a5e8, 0x479ca4cc, 0x8f3941ff, 0xf41bf463, 0x710798a3, 0x2cc19663, 
	0xdbfef06d, 0x939fb94a, 0x78ebe6e8, 0x41cb0a5c, 0x51ae33fb, 0x4663c3a7, 
	0x417e7f19, 0x87cf5f19, 0x26f138c4, 0xa8ebc1e6, 0xc567f107, 0xe4cab7df, 
	0xe72f8c72, 0x6fbfc7f2, 0x7df48695, 0xe84befce, 0xf82a7b87, 0xe52bdff3, 
	0xfdc91171, 0xa65f4fac, 0xffaa66b3, 0xe877f862, 0x76975c79, 0x4de2e49e, 
	0xa7dfe01b, 0x63e25fa7, 0x8595f8ff, 0x0ee55f8f, 0xaecebbfc, 0x0b9f3e7f, 
	0x395f1874, 0xd8ced6d4, 0xf513111d, 0xefd4b9ce, 0x147db742, 0xf15e1de2, 
	0x0e98c877, 0xd9990eff, 0x40f57ac2, 0x6b17a477, 0xbfd0d952, 0xf633f729, 
	0x677bf89c, 0x7b6720a9, 0xaa708406, 0xed8f3c31, 0xa78df3ae, 0xfb8ef766, 
	0xdef8fdce, 0x18eeb6fb, 0x01ffd8cd, 0xde661958, 0x00036941, 0x7de59c78, 
	0xd5557c7b, 0x3bdaef9d, 0x00f23cfb, 0x7380424e, 0x1e761242, 0x3c4211c8, 
	0x0311e202, 0x2b1a5e6c, 0x8a7420d6, 0x204f69d5, 0x4060212f, 0x71d830ac, 
	0x84e0109f, 0x9a878428, 0xb620d828, 0x713b6d45, 0xbd8e95b4, 0xc561e6ed, 
	0x3ab4a3a9, 0x9b6d1c53, 0xb9b41448, 0x33a5a373, 0x7b1f0e99, 0xcfb58f7f, 
	0xdeac0133, 0xfa3e6ebf, 0xd7bdacd9, 0x7eb7eb5e, 0xb7efef8f, 0x7dadfad6, 
	0xc4f31dca, 0x98849b8a, 0xdc9aca32, 0x2fe215ea, 0x01edb7f0, 0x08d4c621, 
	0x108e4b65, 0xe2a602e3, 0xa7f816ae, 0xf10ba6b4, 0xec88487e, 0x709c2126, 
	0x2161f9a3, 0x7422dc72, 0x73dc1f5b, 0x8674b10b, 0xdbda7a10, 0xd35554af, 
	0x8d696b7d, 0x837c9110, 0x70dff9da, 0x0840732f, 0x2d884b2d, 0xa59cd8b5, 
	0x3578e99a, 0x785eccd3, 0xa13b7d06, 0x84625a8e, 0xb654b3cd, 0xee3c3a9c, 
	0x6ff8aa16, 0x08a3d5a8, 0xd9506fae, 0x69cb466d, 0x47911362, 0x478f7ee5, 
	0xfa81bf98, 0xb2711195, 0x334ee899, 0x7e91dda1, 0xf41722cf, 0xedfe19b3, 
	0x087400de, 0x7355fa8b, 0x8c059bda, 0x71dd1d5f, 0x6d42744c, 0xf6c0957f, 
	0xf6e0963d, 0x0c2b0b0f, 0xbab340ef, 0xfd0ce30a, 0xc878c87d, 0x119c7e84, 
	0x9e037e61, 0xcb4533cf, 0x4b97e00e, 0x0565ba39, 0x1bc2bd94, 0xa426f786, 
	0x4c752cf9, 0x85ff9f8c, 0x06df02fd, 0xe3c03af0, 0xacf2241f, 0xd37e902b, 
	0x695bfa02, 0xbd661dfc, 0xe241c7e4, 0x23d2094f, 0x139e8384, 0xbf987a5f, 
	0xf8e23369, 0xffefcbd3, 0x2629fc15, 0x2f47b8fe, 0x8d9c9172, 0xa26e73e2, 
	0x422078ab, 0x740b92e5, 0xa827a515, 0x35f4b37d, 0x6f898aba, 0xbbe27971, 
	0x8fa2be5c, 0x7b6057cb, 0x57c807a8, 0xefc4ff9b, 0xb97c6157, 0x49bf5587, 
	0x79fbbfcf, 0x94fe9df8, 0x17415748, 0xdd329e33, 0x1aca006a, 0xfbfb95eb, 
	0xd4eaadc2, 0xcdfb17af, 0x1cae88f6, 0xcd0cc3d0, 0x2bc33bd6, 0xf28bcef5, 
	0x3e16e787, 0xf7f3e377, 0xe65edc69, 0xe7c9f0a3, 0xf47d393d, 0x93b4ef9e, 
	0xe87afb9e, 0xe39de46a, 0xaa29de72, 0x45a7286e, 0xafb80e8c, 0xefd43f60, 
	0xb03d31c3, 0x3b07ac42, 0x05fa95e5, 0x2a91113d, 0xe7f43b6f, 0xbd8c52a9, 
	0xdbe4cf40, 0xa0f69c96, 0xd7847a7e, 0x7eac5373, 0x59ab0cff, 0xa8f6c4dd, 
	0x2eeaff41, 0xe03efe4f, 0x5b2aa38f, 0x5c21fedb, 0x3e48a0fd, 0x0ed75c21, 
	0x2540f78e, 0xe845074d, 0x67a4fae4, 0x767c4686, 0x02f1cc06, 0xdabc02e5, 
	0x66fee306, 0xf890d6d1, 0x1e31d113, 0x97fde1e5, 0x7827d232, 0xd7df1e3e, 
	0x1fa43c70, 0x5ca262a6, 0xc57b65db, 0x5853bd51, 0xb99ea54f, 0xe267a4dd, 
	0x281011cb, 0xa251d7d9, 0xdec50023, 0xf96d7c98, 0xb217cfb7, 0x7d32cb1d, 
	0xd13ef289, 0xb22438cc, 0xefd3b863, 0xc5679ab7, 0x777501f1, 0x2ae7f009, 
	0x1cfc0e7c, 0xed694e2d, 0x475e8867, 0xff8c6b7b, 0x222a3763, 0x9de02567, 
	0xbf67745b, 0x2477c420, 0x9c1aaf5f, 0xf4f9e34b, 0xf406f02f, 0x9645f9a7, 
	0x650b3b00, 0x65873d81, 0x5fdcb5bf, 0x70b2f5b8, 0x8dcef36f, 0x131eff54, 
	0x99ab53f4, 0xbe834237, 0x8de66baa, 0x5ae1bad2, 0x18348baa, 0xe1967547, 
	0x2a820ddd, 0xe4099f73, 0xac6e0036, 0x8cce7a60, 0xfe801c04, 0xcfb06e23, 
	0x3f4f50e3, 0xd5945bf2, 0x2579ae8c, 0x37e897a2, 0x84c7ec15, 0xe3637be7, 
	0x6942dcd3, 0x5cfd70f6, 0xf692e03f, 0x0b7dbcdd, 0x1c772885, 0xc45e42d5, 
	0xc23c5379, 0x0b6cf3c0, 0x1866a1d0, 0xa939cdcd, 0xe6fa8a7a, 0xf09a3a01, 
	0x0165c03a, 0x354e31d7, 0x8c0f65bc, 0xcedde417, 0xbfb5a0fa, 0x65cefaca, 
	0xf41dad23, 0x3c1bf7a3, 0x473a710e, 0xfb6ebe43, 0xfbed83ae, 0xe50d7ae4, 
	0x9334779d, 0x7bc01ecb, 0xc2790df4, 0x1c2ff88d, 0x26e5cd3d, 0x8695bdea, 
	0xffadd2fa, 0x0c7c486b, 0x19e0bb74, 0x15e3d78c, 0xb720693d, 0xd8849329, 
	0x3fa0e3c7, 0xd0f111e7, 0x7da88daa, 0x7ef50d22, 0x59cc405a, 0x90a6cb2f, 
	0x4fb9047c, 0xa98b2717, 0x132a542c, 0xe363d33f, 0x0fa3ebc6, 0xcf7abf20, 
	0xfc845cac, 0x7bb759ea, 0xa1feaa73, 0x97a4fc1e, 0x7942e9e8, 0xf6de3ea3, 
	0xcc7d31df, 0x3f057e02, 0x55e23e87, 0x7cbd406c, 0x97af1bc0, 0x597a49d5, 
	0xa5b64f7e, 0x9075ae32, 0x0e8db8fd, 0x578c0394, 0xe3d97da0, 0x4d481c7c, 
	0x2bfbc52b, 0x9eda023d, 0x02974422, 0xbeed3b7a, 0x34d2acea, 0xf67d6768, 
	0x88af5077, 0xe5f0163f, 0x664a9bbe, 0x0fd724a9, 0xe58f60c2, 0x5fbf73ca, 
	0x09c532f9, 0x38e3b777, 0x2f6ed0bd, 0x93f601db, 0x6f08857b, 0x5fea8f79, 
	0xff257281, 0x74744354, 0x5e5e5079, 0xc784298a, 0x50d1f42d, 0xe7a1709e, 
	0x37946c83, 0xf66eebe8, 0x2f6b4a13, 0x17be13db, 0xb1136f67, 0xd527f23d, 
	0x23577649, 0x4fed0ded, 0x6c16dd3c, 0xf9dcbd26, 0xb32ff914, 0xc3af8078, 
	0xe2632ff8, 0xd603f269, 0x93f61ec4, 0x974b9c57, 0xf4c50fe3, 0x3d6bb6c2, 
	0xf11df7cd, 0x975daa6a, 0x821f9fa3, 0x0c37e0ff, 0x8df106b5, 0x936504f9, 
	0xf4f718ca, 0x8e61c9c6, 0x27bf0de1, 0x8b1a58f9, 0x20bea083, 0x47e30eff, 
	0x652eaf35, 0x7d7c42bf, 0x6027162a, 0x3b57283f, 0xd9e6808e, 0xdc673eae, 
	0x2819c764, 0x874411b7, 0xc588e341, 0x7f105f09, 0x0aedb845, 0x61dd3fd0, 
	0xd4cdbab9, 0xda4aacb8, 0x5a78ea81, 0x0e52aa0d, 0x223e319d, 0x6cff509f, 
	0x5f1f11be, 0xc7f5be60, 0xafc497c5, 0x5f3f3e57, 0x3f517f50, 0xca10dfa1, 
	0x0b1e2527, 0xa78897ea, 0xa2bf1b3e, 0x69b5dd7a, 0x676a0ce7, 0x71ca7898, 
	0xed0395d4, 0xfc7dd594, 0x7489d281, 0x7f96e11b, 0xff05d683, 0x3f4de36f, 
	0x52afcc94, 0xf934c23b, 0x3ee8f7fe, 0x681bffd4, 0x08b7ef0f, 0x271d63d1, 
	0x2f9d5f7f, 0x70f8e046, 0x2d17cc1c, 0x8d86bf51, 0x74ae393b, 0xd19a4bb9, 
	0xf4bea1ef, 0xce4bb8f3, 0xc30f945f, 0xadfd95c7, 0x9e50dfec, 0x1c506f18, 
	0xdfb06e02, 0x379cbe64, 0x4c17de59, 0xb3666bf4, 0x9f263bb9, 0x3bc66e11, 
	0xde286edb, 0xfa72974f, 0x2f15e310, 0x171a25f1, 0xa97195ff, 0x9eb697ad, 
	0xa265eaa4, 0x397da23e, 0x248fc8fa, 0xd39ff3c6, 0x2c7d6d6e, 0x337187bf, 
	0x28aa8faa, 0x717f73ee, 0xc7d148f2, 0x8fa45d31, 0xdfeabfff, 0xf9f1e47e, 
	0x950c3d54, 0xe0f6bf81, 0xef74d7fc, 0x4ef1ff61, 0x7ad2e05b, 0x6431b196, 
	0x7a10cbfd, 0xd0413b96, 0x4abb337c, 0x31a59c84, 0x167e4c3f, 0x784aa8f5, 
	0x5edf8377, 0xdcc9e322, 0x219fe0b1, 0x5e062bce, 0xf2a53664, 0xddf90bbb, 
	0xd66fcf1b, 0x3eff28e3, 0x93c25ea3, 0xb7af3962, 0xcf25f96c, 0x5cb9072b, 
	0x4afcb162, 0x95fe324f, 0x1e08ba9e, 0x2bd17c52, 0xcb2af0e5, 0x53ab34e1, 
	0xa9f020da, 0x8b7fca2b, 0x6ff892f4, 0x99fddaa4, 0xd03afbc2, 0xa567548f, 
	0xc7a2d7bd, 0x85bab0f4, 0x86e9e0e3, 0xfa86ede1, 0x67d7880e, 0xacb5c174, 
	0xdcb0094b, 0xdfa1bad3, 0xef57c03d, 0x34c1c700, 0x4d7e3b4e, 0x46bf7789, 
	0x1d23eef1, 0x654f58d3, 0xf216fb7c, 0x738c8374, 0x47feef91, 0x444c7135, 
	0x006761e3, 0xc53771e6, 0xbc7601e6, 0x7987ed5f, 0x9e2c5740, 0xa9ee38a5, 
	0x038079d4, 0x01e723f9, 0x1ab461da, 0xfdf1438e, 0xb8b1c3ac, 0x3556e314, 
	0x8e4d6e2e, 0xb21b7f53, 0x718947e7, 0xc63fdda8, 0x8c896aaf, 0xd25e7947, 
	0xfb24f48d, 0xa50e3b79, 0xf8c4d5f8, 0x1cc7faba, 0xec77ea4f, 0x1eb1f8c5, 
	0xdb0f79f4, 0xed83ce2d, 0x46f51178, 0x718a33ce, 0xe92c515e, 0xaf9d1099, 
	0x71c4fc43, 0xd7377797, 0xb4bb612b, 0xefd053d4, 0xb3a1f74e, 0xf0e2484a, 
	0x43976cd5, 0xb99703c6, 0x33eb627e, 0x89d5e9e1, 0xfc59fcfa, 0x80f1ea3a, 
	0x4cef1a99, 0x5e27f8f0, 0xed3d3f14, 0x386a7e09, 0xd9edb4fc, 0x3ccf671d, 
	0x3f84ba5d, 0x2e83f249, 0xa7fb2743, 0xfe4b7771, 0x1493fbc6, 0x4e4ab05c, 
	0x24ddbc91, 0xf4d3b26f, 0x8a1e9d98, 0xbb48a7da, 0xf63da420, 0xd1f4ecc6, 
	0x215bec6f, 0x57d901ee, 0x7c30c285, 0x64da9718, 0x070cb8c2, 0x6be838e9, 
	0xb2809345, 0x31882bd0, 0xf6595efd, 0xfae872c8, 0x2e2f8126, 0xe93a9ebf, 
	0xe7e7ae37, 0xc80e5941, 0xb9ebdee7, 0x772c977e, 0xb2ede7c8, 0x6f3e51bc, 
	0xd837ef92, 0x671e6fef, 0xfedca116, 0xac3e43e8, 0xcd79669c, 0xab36214a, 
	0x1f236f83, 0xc58690e7, 0x7032b5e4, 0xe9da2bdc, 0x479e6155, 0x82fb657a, 
	0x3e3d9ffd, 0x62f5ee6b, 0xbb5f9623, 0x10799c7e, 0x6be33fae, 0xb7b8f15f, 
	0x6ec73d71, 0xdbb4936f, 0xf8b7274d, 0xeba9303c, 0x2178f6bb, 0x6b220ec4, 
	0xfbc5db25, 0x124c17a7, 0x381c42b9, 0x8050a0b9, 0x38cdd53d, 0xfe015e34, 
	0xe2be0dd6, 0xf6c98f35, 0xf6ba04af, 0x2c733288, 0xf2f22f88, 0xe6df4813, 
	0xae0ced3e, 0x57bf502f, 0xfbc1e6c6, 0xaa7d78b3, 0xc930d5cf, 0x2af501dd, 
	0x20f33fae, 0x82bb3bd4, 0x7aec05d7, 0x49b4e7f5, 0x53b62f62, 0xf005a671, 
	0x84b55fa5, 0x9bd07bf9, 0x5b63b186, 0xfdfb811e, 0xd6e03ed0, 0x797f0999, 
	0xf9b3c702, 0xa9876d3d, 0x7f77f4c7, 0x06185585, 0x9739b4ff, 0x95903bfb, 
	0xc3711eb8, 0xb5375e4a, 0x67dbadfb, 0x1ef8efd3, 0xe81fbfd2, 0x3a42e96a, 
	0x1bc279fd, 0x96919747, 0xf626a007, 0xfee7842f, 0x38c4ba38, 0xcf4a2ba2, 
	0x261db4ac, 0xd25fbfbc, 0xc2bf7d19, 0xf55d21f2, 0xe44356b9, 0xfacba455, 
	0xd25e43e1, 0xafb43cf3, 0x9262f9b5, 0x47f11279, 0xadfe21e4, 0xdb68940e, 
	0x0eeadec1, 0x0d6d8897, 0xbcd29d78, 0xbf3c5ced, 0xe04f7d17, 0x5ce38502, 
	0x7565c607, 0xdb6ba787, 0x680ebec1, 0x45568ce2, 0xfc302638, 0x319a77bc, 
	0xeeb3f109, 0xb0dbf5f0, 0x535bd03d, 0xd7a6357c, 0x3f1cf7fb, 0x96e0ca8d, 
	0xea8fd0f8, 0xd9571714, 0xf402757a, 0xd3e583dc, 0x9af5bd51, 0xb4d4f7e0, 
	0xb768d3c1, 0xe07afac9, 0xe43cf1f4, 0xa972ff67, 0x3a7ac9f7, 0xc454f401, 
	0x4bd2b1f1, 0x1929ac7c, 0x4f5b13ff, 0xb7f89e51, 0xbef1f405, 0x3ee3897d, 
	0xefe317d0, 0xebf4e2f7, 0x9cae9fbe, 0x17ef0e94, 0x07b39c80, 0x2685cf88, 
	0xf020e5ea, 0x7d1c4f61, 0xe247c7c8, 0x1a6efee4, 0xdeddade9, 0x81ded966, 
	0x6c82befe, 0x6868e718, 0xc8e91d2f, 0x8267be37, 0xdfac0edc, 0x677f62e2, 
	0xa1c5c78c, 0x205ddf03, 0x953e56cb, 0x5c9734cb, 0x61122d5f, 0xf26a1728, 
	0x942b6839, 0xcb486ff7, 0x0f3c8270, 0xe5efa284, 0xa3f37bd1, 0x67951f65, 
	0x58ed902c, 0xdda76a5e, 0x4f1ad7ee, 0x5e3feced, 0x03fff388, 0x71d2d21b, 
	0xb9f3639f, 0xc1c442be, 0x1156190d, 0x1cd8b340, 0xde24513c, 0xc77b6213, 
	0x88542296, 0xa84d416d, 0x7a2d0f60, 0x7a87ee8b, 0x7427fd5b, 0xd98bf83f, 
	0x04a2be30, 0x2e7b4b3e, 0xe3d8ced7, 0xfb7e40d0, 0xa95fcc56, 0xaefd479d, 
	0x8e282499, 0xbf41df31, 0x78e3a079, 0xa927ae3e, 0xa2174fa3, 0xee29fe9f, 
	0x79406c61, 0xbd61f21c, 0xbf40b2fb, 0x5ff79701, 0x0ed00ab0, 0xe30f2fe0, 
	0x4df79253, 0x7b06f2a9, 0x0af18f18, 0x6f3c37e9, 0xa7a4963c, 0x4bd04886, 
	0xea38ffa8, 0xf13e26b9, 0x6c6edfa2, 0x8828f9b0, 0x887f844f, 0xb6af1eb3, 
	0x976637bd, 0x3f520dfd, 0x65a71243, 0x79fa29bb, 0xcb6c6f2e, 0x363f58d8, 
	0x5b0d8ddd, 0xdbb1fa12, 0x04d1c7b5, 0x653f657c, 0x7a3d71b8, 0x93aafae4, 
	0x6ff62f18, 0x8f2e3208, 0x71e2d6ab, 0xd0c9bb26, 0x9ac86710, 0xf66eef88, 
	0xfd420fa7, 0x4f7de1a7, 0x21bdb691, 0x829b4ece, 0xd7dc4fec, 0x9be35db1, 
	0x98eca1ee, 0x884b96cb, 0xffa0bfc1, 0x2b964c57, 0xf18ae3f4, 0x30a478bf, 
	0x56ebef51, 0x60af7c72, 0x5fe2018d, 0xccf1ca33, 0x7c539f84, 0x24593191, 
	0xc2a3aee0, 0x19ae5154, 0x779fe6b9, 0xe697adc4, 0xe4c8fb7c, 0xeecf9c52, 
	0x2f119317, 0x9f4bfb6c, 0x06a57db8, 0xa0b2baed, 0x3eac60fe, 0x6d7be6f4, 
	0xaecf10bb, 0xf7a90110, 0xd9e5ca2a, 0xa0d97665, 0xe767c4d5, 0xb3880304, 
	0xfb0c06cf, 0x05a3c2be, 0x5cb2a47b, 0xfe6612bf, 0x315fda05, 0xab7cd3c7, 
	0xfc00e813, 0xe60faacd, 0xccae81f9, 0x90fa0c6f, 0x87258cbe, 0xa42e3d3b, 
	0x77e900eb, 0x1bd8257a, 0xc58a5bce, 0x1cef8c01, 0x05e60ed7, 0x1bd2a5b6, 
	0x594aa78d, 0xd64ecf9e, 0x8a1f5202, 0xd5c98884, 0x4eb79b8e, 0xddbba0ba, 
	0xa8621fb8, 0x7c692bd9, 0xefa3c60a, 0x77d4bf4b, 0x7b41486b, 0xdaea5576, 
	0xf7ffd076, 0xf62aa6fd, 0x743a7d01, 0xb9fb2399, 0xcb3ffc92, 0x4ff2c83b, 
	0x9863e18f, 0xfe493770, 0x8a22658e, 0xd3ebf16f, 0x27c65919, 0x13c6e27b, 
	0x336b676b, 0x165193b6, 0x9af3833c, 0x2539d73e, 0x411d4f5e, 0x9f805798, 
	0x2608a8ce, 0x214f43fa, 0x0999c9d9, 0xc711840f, 0x324f521d, 0xf7a7fae2, 
	0xf5050c2b, 0x7c6b91c5, 0x94fa822b, 0xd5dfad65, 0x7a7fda91, 0xe063cc3e, 
	0x87be7bbe, 0xbbe382fc, 0x07685d9b, 0x99722b30, 0x64de484b, 0xca150eb7, 
	0x33958abf, 0xe29e0fd0, 0x2f3e3372, 0x7c0970ab, 0x473de32e, 0xc4979439, 
	0xb99b4395, 0x63a2fd2c, 0xbfae46c5, 0x98ebf99c, 0x32cb99b1, 0x0d3873de, 
	0xacfb432e, 0x21971cb7, 0x91f7f15d, 0xc4e9212e, 0x8adf7a78, 0x4fb52bb3, 
	0x60d11884, 0xd80e2215, 0xbfc64ae3, 0xfc49a77e, 0x4d783fc4, 0x55068f68, 
	0xa1f8067f, 0x88b2630e, 0xcbb063d3, 0xfa7ef82d, 0x6a578fc4, 0x239fa44d, 
	0xcfd086da, 0xbdb32767, 0xdfbfcb24, 0x6e38bc1f, 0xe29ae7f8, 0x80e57137, 
	0xc37ded30, 0x4a70dc78, 0xd0ce70dc, 0x779c7495, 0xd251e8ce, 0x6a53ae41, 
	0xb27f3ee4, 0x5a18cd5e, 0x86599d1f, 0x7e1c6f6b, 0x3f6cfb68, 0xeb67bf6d, 
	0x3a2a8363, 0x04abdee2, 0x5c7d405c, 0x1b8c4c1c, 0xc7d20cbb, 0x7fb876d4, 
	0x5fe033c2, 0x78896dc6, 0x33c51196, 0xa7ea1b6b, 0x1b1acb33, 0xe4d0fdc1, 
	0xacf49276, 0xe290597f, 0x5d49bea3, 0x557d024a, 0xeb87d126, 0x29bfbc3c, 
	0xe3197d71, 0x13d753ba, 0x64103d71, 0xff7e0747, 0x160f9e2d, 0x4debc6bd, 
	0x2fdc80fa, 0xc8fb91ee, 0xf3d1b7a7, 0x78cdc402, 0x44ef3bbc, 0x87e4137d, 
	0x853df5dd, 0x8f689d9e, 0x2f843aa7, 0x9c6cbf55, 0xf47e2bee, 0xa57ebc68, 
	0x61a8ac4f, 0xdb8a32bd, 0x57a10e36, 0x5971b25f, 0xe8a74e10, 0xd467e557, 
	0xfad0ff2f, 0xe5fa90e5, 0xc2fd6328, 0xa0749475, 0x2fd4836f, 0x0d7eb247, 
	0x6f96778b, 0xfa50e0ef, 0xe6f188b5, 0x9e977812, 0x0162778c, 0x32fa57e9, 
	0x201e9f5b, 0xf14f4a7d, 0xe9de368f, 0x07fe31bb, 0xfa887e3a, 0xaadff6e4, 
	0x96919008, 0x9056f30f, 0x11f1466f, 0x6f183897, 0x73974c2f, 0x227097ba, 
	0x34df493d, 0x93ea0a1c, 0x87181735, 0x07e0cdfb, 0x867fa347, 0xbe669e76, 
	0x844f3986, 0x3c06f1e7, 0xc72ef5c7, 0x99ca30b9, 0xfd09bdda, 0x303dc409, 
	0x0766349f, 0x5c02c629, 0x565f9c48, 0xff71946d, 0xfa4ed43d, 0xf9c54334, 
	0x78dd53aa, 0x3ff8a874, 0x305147a3, 0x812ad6ee, 0xab79f8be, 0x0f9c4c1e, 
	0xabad7ec8, 0x256f1c82, 0xd7ff65e9, 0x71907f95, 0x832d6e33, 0x6593cd3e, 
	0x7f7c3d30, 0xd3365d96, 0x941979e9, 0xf1d27f59, 0x5e7cb6b9, 0x51d7f226, 
	0x45c4ce15, 0x4a4da98d, 0xf78338a6, 0xecb03a8f, 0x2ee7e4ac, 0x35979f83, 
	0x5495f3c0, 0x72f181df, 0x7db4617f, 0xd657b637, 0x87de8f34, 0x3bb9e8f7, 
	0xbe21f508, 0xf6c80f4e, 0x65dcfc43, 0xfef88e28, 0x1aa3c1dc, 0x73f0cfd6, 
	0x627a997f, 0x46bef07f, 0xd43ed965, 0x979672a3, 0x49e11fdb, 0x57533f6c, 
	0x5f683da8, 0xbd625751, 0x7cf869a3, 0xbdd38c0a, 0xe1a7ea92, 0x254af2f3, 
	0xf0fa0dd3, 0x87de1af3, 0x7de0332f, 0x420d4f28, 0xe5cfa07b, 0x65ae8501, 
	0xa75c1748, 0x57bef2ea, 0xfb40f7de, 0x0ebd3f50, 0x7e10cf7c, 0x33263409, 
	0x6a6c7e0c, 0x73b3cf19, 0x374ccdda, 0xe829e9e8, 0x76207d2f, 0x216b6fff, 
	0xa7f78640, 0x98f979ca, 0xe4f549c3, 0x9fa0ebfd, 0xe7ce58e9, 0x92bb72f7, 
	0xbd7295ea, 0xff7c1dd1, 0xe79e5aae, 0x701f0395, 0xbbf35a73, 0xe53efa84, 
	0x3ce264ab, 0xe72d4d64, 0x6d1d018b, 0x5b2b6f38, 0xf50dbbbf, 0xe9cffcb1, 
	0x712e3e77, 0xff11d680, 0xe80597fc, 0x3fe8d337, 0x80bf572c, 0xb3e5b3eb, 
	0x801e358e, 0x886795f1, 0x2b7209b0, 0x30ccd4d7, 0x703654bc, 0x27ce2663, 
	0x6dd955b5, 0x5b2d1f38, 0xa4fbe4bb, 0x8c27aa27, 0x2a1e527a, 0x53fdb612, 
	0x3b2ab7fc, 0x15b4f58c, 0x971aa6d9, 0xd6fb81ff, 0xcbadc71f, 0x278f3268, 
	0xefe396ab, 0xdd033ff2, 0xe864efd8, 0x0e7cbb7f, 0x5fabebe3, 0xfa868992, 
	0xf00fea3e, 0xd1f96cae, 0xbf0e770c, 0x9a37eb87, 0xab28f75c, 0x23ef470a, 
	0x795cb4ff, 0xe25e72bf, 0xb7ee7cfd, 0xef1250cc, 0xc1faca97, 0xf709e9a3, 
	0x40fd64cb, 0x0cfef138, 0x2f3fdf79, 0x6c857ef1, 0xe13be007, 0xdf7942fe, 
	0x709dd47b, 0xc76cb17f, 0xe5fba613, 0xe21b6619, 0xf02e3949, 0xa17bfd41, 
	0x35c268de, 0xaff00fe0, 0xb48fcfec, 0x94efdc61, 0x56ee52b8, 0x3701c484, 
	0x61a4f7c9, 0x5f2c9d97, 0x8ba6cb21, 0x2498e0ca, 0x7eb0b8ae, 0x49c011d1, 
	0xdbbd3bb0, 0x6df2bb20, 0xbda70934, 0x61d9064d, 0xefa2eff9, 0x84feb13b, 
	0x6837a0c3, 0x3f600da7, 0xec28845b, 0xca0b7982, 0x41f5042d, 0x4c3a0aa3, 
	0x6e5d4f2a, 0x76fcf3d2, 0xf1579f83, 0xc111f1f3, 0x2a4d2bcf, 0xd9061b97, 
	0xf4261e79, 0x4d07dda1, 0x80f2dbb2, 0x68e97641, 0x6b84bb00, 0xcd2572d1, 
	0x55e9ef03, 0xd80f5547, 0xb0ca84fb, 0x6342e58a, 0xf781ea9e, 0xf07d4a16, 
	0x7d007e22, 0xc5454105, 0xce2532f6, 0x728e07e4, 0xe12655fb, 0x987f78d0, 
	0x0695e5ca, 0x79f4f395, 0x1579f654, 0x8354ff1a, 0x1a0f2fe9, 0x9301238c, 
	0x486fc2f1, 0xb33a60fc, 0x27be989a, 0x4d95fda4, 0x9da13906, 0x9c4c293c, 
	0x62a94d07, 0xa43d025c, 0xd796a7ab, 0x121aa6e3, 0xf157107f, 0x92e24079, 
	0xd7e3cc3f, 0xbcaf7de5, 0xfa7ee1ef, 0x3fdd7ebf, 0x57bae164, 0xc42475d5, 
	0x5c4dcafe, 0x38a3ae36, 0xb71d446a, 0xd36b3fdf, 0x0cff903f, 0x50657ac8, 
	0xd73a7ac6, 0xcf942feb, 0x849cb23d, 0x582b5377, 0x12663d2f, 0xd9fbc92e, 
	0xdfd33311, 0x44aff7c9, 0xf7c85bbc, 0xaa4c6d47, 0x7ef598bf, 0xfde25364, 
	0x90c44771, 0x0d56f638, 0x2cd4fbeb, 0x83b05bc0, 0x7df8cba9, 0x0657de4b, 
	0xf386de7f, 0x531c54eb, 0x422dcf9c, 0xb7de2b1c, 0x23889bff, 0x5fee1b46, 
	0x88a8ae11, 0x7133bb23, 0xe36a66dd, 0x38c14541, 0xb7f03d60, 0xf43ae25a, 
	0xa22c6ceb, 0xdb1fb2fc, 0x79c51df8, 0xbfa1b8a1, 0x71136a87, 0x79f02e7e, 
	0xce3c40fc, 0xf793d527, 0x9be7109b, 0xa93e71e2, 0xf9e7145e, 0x8c75cdfe, 
	0x5a3d36f3, 0x17105148, 0x27a9b8a2, 0x37ec0df3, 0xfc66e99d, 0x3c437187, 
	0x3b72753e, 0x7fe035e1, 0x2f1be3fd, 0x4a45ff86, 0xff84cbf7, 0x59e79dd9, 
	0x3127c53f, 0x5b7da1bc, 0xc617db1f, 0x51508ed7, 0xfbf18ab3, 0xe3db8864, 
	0x0cf2a6e2, 0xd4cefc83, 0xb68779ba, 0x3a983f81, 0xe110eab3, 0x0dbcba86, 
	0x1fed84fd, 0x82859aca, 0xa1a669f4, 0x3d438cb4, 0xfc7c45d7, 0xb4f62ce8, 
	0xf5f1dd89, 0x28f2d284, 0xcee38bf4, 0x36437286, 0xafde3b8d, 0x2bf44d1c, 
	0xbbf83e34, 0x98b4fb63, 0x6b3f111e, 0x8a45fe51, 0xb3cafc02, 0xfcff12e5, 
	0xed7c98e1, 0x796bafeb, 0x75bbf2df, 0x75d52f8c, 0x72f18d88, 0xebd41437, 
	0x7ee492d7, 0x49ee4530, 0xe772a2f5, 0xe4ea6bfb, 0xf1d251fc, 0x93cb1d7a, 
	0xde4153f2, 0x576f292e, 0x4fbde590, 0x172d05fa, 0x4f0cf7e8, 0xfd241fff, 
	0xebc7577f, 0x6b82df2e, 0xbede2060, 0x6bf7ffb9, 0x6637dd79, 0xf68286df, 
	0x1caff78d, 0xa4efb788, 0xe6fb51fa, 0xfd2491fb, 0xe3b9763d, 0x1cb8bfc8, 
	0xe7f7c934, 0x86da38e5, 0xc3a7c719, 0x61d3e38c, 0x30e9f1c6, 0x692478e3, 
	0x71d56f1c, 0x71c9729c, 0x6c3cb294, 0x8a3b42dc, 0x659bff40, 0xd5f646fc, 
	0x8f43f344, 0x48ef3f19, 0x3f240f9e, 0xbc27dc07, 0x2a7dc38e, 0xc64fdc4b, 
	0x9fb03bfb, 0xfdc697f3, 0x76db3e64, 0xf3e484f4, 0x3cf861d2, 0x1fd92ea5, 
	0x7ef19f30, 0xaa483fa2, 0xafe7c49f, 0xc9fde927, 0x5f00bea8, 0xf815e3c7, 
	0x0ef92b5c, 0xc94ffef6, 0xddab3738, 0x812f738e, 0xfdffe173, 0x7bdce11c, 
	0x855b1fdb, 0x8df4cf76, 0x1ddc06ed, 0x8ec7fecf, 0x00fe71b3, 0x68cd7af8, 
	0x6dd591c6, 0x9fc7e2d3, 0xf1d1df84, 0xe3efc50b, 0x4fe389fb, 0x7f1d1faa, 
	0x9f1b7de2, 0x38c22fc8, 0xefee21c7, 0x11f70219, 0xbe893bef, 0xf3df495a, 
	0xc54b4d0f, 0xe5bf28a3, 0xf994cefd, 0x24bd5246, 0x8fefb23c, 0x39fdc23b, 
	0x46dbab1b, 0x82ce1e73, 0xf553d36d, 0x7e14b5e1, 0x96bc3eb0, 0xfaa48fc2, 
	0xdf60fa49, 0xf07bf58f, 0x7bce391e, 0xb978dfa8, 0xc72fe10d, 0x872fe70e, 
	0xbb4e5be1, 0x26ef4fdd, 0xd4d1be39, 0xa33f124f, 0x3fef2778, 0xa33f0c3d, 
	0x69f892f5, 0xeb8d8fdf, 0x9a7dfde2, 0x870fdfd4, 0x0e9f27f1, 0x29a7dfd3, 
	0xb29915fd, 0x9edb43bf, 0xb263e78f, 0x39ca261d, 0xf9249fc6, 0xf31fbd27, 
	0x8af2895f, 0x1c9c3fbd, 0x1246fd93, 0xc5ea925f, 0x78c272e1, 0xde24fd62, 
	0x3a37c94f, 0x8bf28637, 0xbcf9a9b6, 0x475a126f, 0x4a7b47f9, 0x8b3e6533, 
	0x526bbda9, 0x267943dc, 0x4c7039c2, 0xeaf31579, 0x0bdd93c1, 0xe6c1dce5, 
	0x798e7c0a, 0x1f4eb847, 0x9c437982, 0x43fd469d, 0xc571e990, 0x5d8eedf4, 
	0x7d5438ff, 0x1cf8e71b, 0xe37fc38a, 0x37fe9283, 0x433f3f51, 0x0e777bfb, 
	0xf5b0fed9, 0xefe04c4b, 0x974659cc, 0x7da1f75c, 0xbb7e99a5, 0xc42e098c, 
	0xf453bc87, 0x569c70c4, 0x52cdbf30, 0x6cb07b9a, 0x305f9039, 0x425a5429, 
	0x961e7ef4, 0x286c9c1f, 0x5df20f6a, 0xc31c43c9, 0x3e7c3b75, 0xf2a2d061, 
	0x2ec6ff4c, 0xf788fe41, 0x128e661b, 0x5e0f3947, 0x33fbe014, 0xd1e7c967, 
	0xe0a36175, 0xad5ccd34, 0x1aba1e82, 0x5cb8e785, 0xc0eb4038, 0x2e4184c6, 
	0x3f28b04f, 0xc24fd0ce, 0xdfd88155, 0xc691fb8d, 0x683ef5ef, 0x259eda67, 
	0x2fbc718f, 0xfc0a1f68, 0x0a03af2b, 0x23cc8dd9, 0xb5729ad4, 0x802d70ed, 
	0xba7fc9f7, 0xd54f545d, 0xbfb71e99, 0x2fb944ca, 0xf1eb5029, 0xdf23859c, 
	0xb60089ea, 0xb2b4ee39, 0x3ed27676, 0x65ef3fcf, 0xa645b6fe, 0xd24c1f23, 
	0x1f3299bf, 0xccfab6ed, 0x04373a7a, 0x9e16f97a, 0xa5b6fa47, 0x5d4ce3b4, 
	0x7d70534f, 0xa8df9629, 0xaece3e91, 0xbd47aa2f, 0x6ebf731b, 0x75c08bfd, 
	0x40a99084, 0xdbdc2c7c, 0xf153df29, 0x75cb2e83, 0xf147ec16, 0x9fb8cdeb, 
	0xa73e3c9c, 0x3549ebbf, 0x7577c724, 0x3f8abc6c, 0xf586a6f4, 0x541d7203, 
	0xb46c45ca, 0xd407ca2c, 0x7d70b0ef, 0x34a7cedc, 0x43329f30, 0xda99d7f6, 
	0x61ffb50f, 0xd752df2a, 0x93b4acd3, 0x7a8bae0a, 0xa6ea7f38, 0x5aa06908, 
	0x6f38c222, 0x67f9851b, 0xedd8b3b8, 0x6b61fda5, 0x6f9d9a7d, 0x3e68e546, 
	0x38d0c796, 0x63e65f8f, 0xac7ce29d, 0x445ed079, 0x272c76a1, 0xf7473b8c, 
	0x873d722c, 0xcec2a1fb, 0x2f28d2a7, 0xe51a5852, 0x82aa99bf, 0x663d50fc, 
	0xd313ae1a, 0x1c06f07e, 0xc3da9b9f, 0x4eb85b71, 0xfca5e55a, 0xea4334e1, 
	0x7a2fa48d, 0x4b8e408e, 0x60b7d52b, 0xa38d111e, 0x965c6137, 0xe3d2ebb3, 
	0xe9b7fbb0, 0x257bfa24, 0xba31d57d, 0xac80d26b, 0xe3f663f7, 0x3c0bb80c, 
	0xf805176c, 0x404086de, 0x883e7cc3, 0xfd68d291, 0x4c3163fc, 0x7fe729fe, 
	0x4f0b706e, 0xc9e51f76, 0x806905a7, 0xd4bbc166, 0x83ec289e, 0x83185aeb, 
	0x0b75f387, 0xae13b7fb, 0x77107814, 0xbf42c25d, 0x505feb54, 0xa0f0e780, 
	0x71db1d1d, 0x4e7a4df8, 0x007fa1ef, 0xb8b8e0c0, 0x5bcc09e1, 0x21450574, 
	0xf5abd79e, 0xf7c4296f, 0x5ca8af00, 0x30b2ba53, 0xb0f927db, 0xca44f51e, 
	0x13d656e1, 0xf1a56ed1, 0x871c98b2, 0x3688f9c9, 0x570447bf, 0xc6e789bf, 
	0x2df69cd4, 0x07a637a2, 0xd9d55f36, 0x19a1a7cf, 0x7e99cfd4, 0x6a7e815c, 
	0x6f5a351a, 0xc26d3b04, 0x5ba0cc7c, 0x019c8c8c, 0x2111e3bf, 0x20b5ca15, 
	0xa98e795e, 0xf997bda0, 0xccf9cedb, 0x696f9c05, 0x2eb9e015, 0x14d23f6c, 
	0x27cd97e3, 0x9e709bf8, 0x702e13cb, 0x11113f59, 0x43fd5d62, 0x1d4c0f12, 
	0x22babdf7, 0x5f10fbaf, 0xfd78736a, 0xa4b4a6a8, 0xf297bd20, 0x86eb7e30, 
	0x1b75eefe, 0x06d74805, 0x86734a7d, 0x47bc917e, 0x94f4846f, 0x9f0ea5f8, 
	0x3de768f7, 0xde3a6400, 0x1d379c22, 0xf08586ef, 0x98798ad5, 0xc09decff, 
	0x2673a679, 0x9f3c4cfb, 0xd79ea87b, 0xe7af9e97, 0x5d7db0f9, 0x7a9dff57, 
	0xdfa047f1, 0x933bfa04, 0xbf32a5e4, 0x871c1afe, 0x5c7a8eb2, 0x803be25a, 
	0xb482f976, 0x955389df, 0xd9185982, 0xdc21a383, 0x4fab82ac, 0x04fe8dd2, 
	0x22f10df1, 0x84c74f09, 0xe63b470c, 0x11be2023, 0xf08cfebe, 0xc3f32bd5, 
	0x57c052b5, 0x7a0b9fb8, 0x887fba34, 0xcce7d979, 0x78533fd3, 0xe1fa276d, 
	0x3cc4d29a, 0xa54d1aea, 0x06e5aeb8, 0x70f774a1, 0xf2eb82dc, 0x252c932d, 
	0xbcf58670, 0x9df4ec1b, 0xa7079e7a, 0xbe9f4de4, 0xcc1fca9d, 0x87271954, 
	0xadd82739, 0x55e343bf, 0xb9a60ee7, 0xc1f5de41, 0x3c7714e3, 0x855cc633, 
	0xa52d78f9, 0xa7e89d35, 0x50f7d737, 0xb2d296bd, 0x41b7b3db, 0x29a359bd, 
	0xad65b2af, 0xf2dbf646, 0xef73348b, 0x0f3fc618, 0x175ad7f0, 0xdb2c67c3, 
	0x07b316b8, 0x827f2353, 0x0c4af838, 0xdb5c6c6f, 0xf20a69a3, 0x49fb8a3f, 
	0x0e242878, 0xf84c76da, 0x68d78717, 0x4f6d6f97, 0xd94babc5, 0xb965ae1f, 
	0x0fecc7cf, 0xbe7093d7, 0x2c3f9d1e, 0x55cedcd7, 0xae40df72, 0xb23d113b, 
	0xaaffb25e, 0x402eabe8, 0x87a0dfdc, 0xbc3888f6, 0x154bf649, 0xadfbaf67, 
	0x733ff402, 0x28fdf00d, 0xed8f2df1, 0x7de3ccc2, 0x20fc636f, 0xb78f7bef, 
	0x4ff23ed8, 0x23e47db2, 0xc2be281f, 0x959767fc, 0x9f171ed7, 0xca765c61, 
	0x746f6895, 0x0a35590e, 0x8b8bf9e5, 0x43e6c3f2, 0xd151ff9c, 0x04fc522f, 
	0x9f5cefef, 0x479a3bfb, 0xe204d11d, 0x1691d141, 0xc8f10425, 0x5de3e034, 
	0xcc9f9718, 0x5e58fba7, 0x6cef720d, 0x879859f3, 0x7e0999d7, 0xaf8c4c6a, 
	0xa5d71cf8, 0x0beb8af0, 0x29366ffb, 0xf3d9deff, 0x78ae7973, 0xc7cde52e, 
	0x72fb87b7, 0x3b43c7fb, 0x8f7d330f, 0x7ce8c40f, 0xa4ef9ff8, 0x7f1d98f3, 
	0xe985d572, 0x01f1be9c, 0x01a3e8e2, 0x36807941, 0x4e90f39d, 0xef2743f4, 
	0x57f9f0f4, 0x2207d683, 0xcfe9eb8f, 0x1afc071d, 0xb0768969, 0x21edae93, 
	0xb057e1f5, 0xa9cfaa6c, 0x1ed3d658, 0x5ef5045a, 0x0fef350a, 0x5589e6e3, 
	0xe4f88fd2, 0x06f7d20d, 0xf9f2f74a, 0x181a17dc, 0x97d5449f, 0x9df3bee8, 
	0x82bcf6a9, 0x5aec77ce, 0xf9f166a4, 0xce84ab1a, 0x32842c8b, 0xf8a3fbd8, 
	0x63bbf21e, 0x9157bd16, 0xdf7ace57, 0x3b627370, 0xc9f28b41, 0x1d239a5d, 
	0xb8784bf5, 0xc599dafe, 0x68beff54, 0xd094b7ff, 0x9efd913e, 0x5c462adb, 
	0xdf2bf68e, 0xb27bf68f, 0xf0b9da98, 0xebeb9bb8, 0x76fd8975, 0xe6b95217, 
	0xe5d30e74, 0x6e784faf, 0x17ca3b8f, 0x57f42f1c, 0x7ca2c739, 0xa9965700, 
	0x7e637784, 0x6ee7cf09, 0xe79537ca, 0x7826fee0, 0xbb14d7cf, 0x1ff325df, 
	0x0ddbf9a2, 0x95e0371c, 0xe3db47ce, 0x71baac5f, 0x74ac219e, 0x7fc2e71a, 
	0x82ba674a, 0xd5d02577, 0x3153fce5, 0xf7d12bea, 0xd157bc09, 0xd6388c55, 
	0x62a1a4f5, 0xc164637e, 0x73bf5a7e, 0x39c51a56, 0xd87d3183, 0xc52a6e2f, 
	0xcbd94773, 0xd27ad296, 0x54f9f681, 0x1b725f4e, 0x7fb6ff3d, 0xe8ef9535, 
	0x2eca93b8, 0x73cb7f98, 0x44f7f44a, 0xcc64d8e0, 0xf3bcac0f, 0x5e5a77f6, 
	0x77dd9588, 0x2b7e3ede, 0x64ab6b9e, 0x70f639bd, 0x7cbdd329, 0xb4fc90d5, 
	0xf0591bc7, 0x33e6316e, 0x130fa974, 0x23fac9fd, 0x1f115782, 0x997dffd6, 
	0x82634f94, 0x43dbe3fc, 0xf455779c, 0x7e307b50, 0x5cd02f6e, 0xde57fd8c, 
	0xcdf7e3e9, 0xf9fef489, 0xbd44c282, 0x6849ae0e, 0x56b989f7, 0xb1234ff1, 
	0x7ef8ddf7, 0x5fde45eb, 0xf7c876be, 0x98e566bb, 0x38e8a768, 0x3a66ab9e, 
	0x3aaf103b, 0xa17896c6, 0xebe6c77e, 0x7bda3ea9, 0xa17e0637, 0xb9da13bb, 
	0x27a3f9d1, 0xb39da1cb, 0x301a8ffa, 0x46e3b5c6, 0x3e310c0c, 0x2c785cc8, 
	0x633df503, 0x0d28f371, 0xcb332130, 0x949e7152, 0x98aa6b91, 0xacb99e8f, 
	0xcfc05547, 0x008b726e, 0x0b197fc6, 0x0fac4cd5, 0xe7c290e5, 0xc3af298a, 
	0x032ae7ae, 0x773d06bd, 0x9dfa19dd, 0x4ff417b2, 0x7f11d66f, 0xb3dce136, 
	0xae4b8626, 0x0fd0a460, 0xae68baf8, 0xde30e7a5, 0xb4f2813e, 0xe2a569eb, 
	0xebb7de00, 0x9feabc2f, 0x9bcc2cf4, 0x3afaed2c, 0xe341a5c6, 0xb7dc74d8, 
	0xd5e78b1a, 0xf2718e80, 0x3c18dadc, 0x76e7cd1f, 0xb1bdb1b3, 0x8fbc0e78, 
	0xb4fb2f70, 0xdd91fa46, 0x332d1347, 0x5c279fa7, 0x7973cfa3, 0xe72e05f4, 
	0xe54ad89e, 0x2ae8d7dc, 0xe5c5bcc6, 0x7972ef31, 0xc7971f6c, 0xdc7973f6, 
	0xbb8f2e79, 0x09ef65c0, 0xbd32c7ca, 0xf9c36daf, 0xe90235a5, 0x5f79fa74, 
	0x4737ef39, 0x62d2cbd2, 0x08f5cb7c, 0x816f9e07, 0x610de289, 0x8839e7f6, 
	0x3cc645cf, 0x7576f905, 0x08d5f826, 0xce08f3ed, 0x00f8801b, 0x67a13ae4, 
	0x1b6bcd2e, 0xfbab7c61, 0x92b80830, 0xe13746f2, 0x54befcf9, 0x19c76bff, 
	0x33403cf6, 0xdfac7c94, 0x7841df88, 0xdb0f362a, 0xa7f01384, 0x66fe7444, 
	0x6e32fce2, 0xced7f45e, 0xbcf2452f, 0xfe7b7072, 0xca717187, 0xaf1f8de7, 
	0xfee4d3d5, 0x3b23e197, 0xc88fccd3, 0x1f0dbbcf, 0xe6cc43cd, 0xe7e86155, 
	0xd505905a, 0x867f6f73, 0x58cd60e2, 0x0bce4a71, 0x147c4b3f, 0x8fcc8b8b, 
	0xffa2f776, 0x710077df, 0xe6b356a3, 0xc4285eee, 0x6175a70e, 0x5d5c1e6f, 
	0x20efdfe6, 0xb8fe33fc, 0xbe92f58b, 0x9d20a307, 0x13aea6af, 0x9675c8d4, 
	0x846baada, 0x61e6357a, 0x3a3e73c9, 0x6b5ea5e7, 0x871dc228, 0x858801a7, 
	0x798cb222, 0x58f6d7f0, 0xff4864b7, 0xcd56e58d, 0xb33d23f4, 0xa439d69d, 
	0xdf2be607, 0x1875a0ca, 0x178ee963, 0x887cbf48, 0xe64745f7, 0x5bc404f9, 
	0x5ac7c8b5, 0xca1f2fd2, 0xd2bcc6b5, 0xf5227a47, 0x4288e6ac, 0xbf24fe79, 
	0xfd3fa956, 0xf367ee97, 0x897745da, 0xfd9cf875, 0xb26f3d98, 0x2efe7ce5, 
	0x15e13f9e, 0x572e57f7, 0x31fe261f, 0xcc17ce9b, 0x3b1b9ff9, 0x63553e71, 
	0x0c1ef7f0, 0x3d422acd, 0x079ff898, 0xfca0968b, 0x27e8b30d, 0xe7819e50, 
	0x03de702a, 0xee7f30b7, 0x70fa611a, 0xb83eae1d, 0x0617ce80, 0xf187d535, 
	0xad205d76, 0xe27c5044, 0x4ef5a4ee, 0x0dde2add, 0xbc99aaf2, 0x2f5a49f4, 
	0xfc62ac33, 0x316d558e, 0xe1f911c8, 0xf5107738, 0xf85076b8, 0xb10ace5a, 
	0x57bb9c5d, 0xf0dd7881, 0x3fa1f71f, 0xe6a336de, 0x13da8556, 0xe44e0fe4, 
	0x3cc37af2, 0xe30f8b7d, 0xd152b69e, 0x8efcf269, 0xe01eb3e8, 0x2b5fade7, 
	0x235f5135, 0xff8a68fa, 0x4e8d4adb, 0x8d30e73e, 0xed1d47f4, 0x8c07f9a5, 
	0xb8e68dff, 0x016ffdf5, 0x7c03fd1f, 0x18fdefa5, 0x4147ac15, 0x282dbe79, 
	0xe4043dcf, 0x3d2487b9, 0x47bc05fb, 0x4b308ff1, 0x26f9e23e, 0x9fa95fcd, 
	0x1e5cf0f7, 0xdd2977d8, 0x99fc883f, 0xc59d3ffb, 0x19b9fe38, 0xe7961146, 
	0x1b8f547b, 0xca547fe8, 0x1dffb935, 0x70ec8d7e, 0x07be7781, 0x99efdef9, 
	0xcdd3cf25, 0xe993fea2, 0x31c72bd9, 0x037ad337, 0x13373fc7, 0xd4ed00f8, 
	0xdc3e99e6, 0xf487df5f, 0x35d69e02, 0x41512c2c, 0x510a0fb8, 0xf44ed2d2, 
	0xfa7881bd, 0xc71cf953, 0x5bf6c831, 0x9b62f38c, 0x8362d68e, 0xe7fb5ff8, 
	0xd7113a07, 0x719a5708, 0x9df4cd1c, 0x347f889c, 0x14bfbf9d, 0x901da91f, 
	0x7de2db77, 0xe3c94f64, 0x7cb2cd68, 0x0ebfa061, 0x7f6255eb, 0xafe84f3f, 
	0x6acb42ae, 0x8123f781, 0xb4ce74d1, 0x9f19c67e, 0x1d3e41e2, 0x6ddea1f3, 
	0x5b68960f, 0x2474a943, 0x8c12fdd3, 0x697f38d7, 0x04cdcebe, 0xea9f01fe, 
	0x10ed70bc, 0x82c0a1e2, 0x81b9fe44, 0xedf7204f, 0x0ade2930, 0x9862397e, 
	0xa48fdb62, 0x194e23be, 0xc29acebc, 0x0e590697, 0x6fd90c55, 0xd8d67f34, 
	0x3bb3f949, 0xb6dabe64, 0x5a454b3b, 0x48f42e1c, 0xb857f9fd, 0xadad70ea, 
	0x20d74e68, 0x12cdaa66, 0x6b9b8c3e, 0x6d5ade64, 0xdbc521d9, 0xbe95d789, 
	0xddcf5c00, 0xdaa8f3c5, 0x279a5cca, 0x4bca0efd, 0x7d4f5007, 0x53d047c4, 
	0xa9f2099f, 0xedde33f1, 0x683cd26c, 0x453373ef, 0x9110c9e7, 0x73a569d8, 
	0x8037a8ff, 0x9f5a1e0f, 0x0df37e28, 0xfb9ceebc, 0xe20b2792, 0x7dc5d689, 
	0xb48f18c5, 0x0bb359dd, 0x5f44ade7, 0xb37d2a4f, 0xcfa736e7, 0x9a3ad108, 
	0x188ced7e, 0x817788bd, 0x63f621a6, 0x0631d792, 0xe67f689a, 0xd1d9d2c4, 
	0x7df884f5, 0xa5ff7b18, 0xef16875b, 0x799d3b05, 0x9c9f25a4, 0xa4c7ef02, 
	0x75c8f7ac, 0xb2be67f3, 0x93fa44c6, 0xb3bfb1d7, 0x1a5de276, 0xa14cbbe7, 
	0xa3a5fb38, 0x78058423, 0x7a00fc8a, 0xff035eef, 0xa73d23fa, 0xbefb6ef5, 
	0x57dc679d, 0xaf28ee3c, 0x1eb4183f, 0x62e80aef, 0x11e4e21b, 0x40ae7ff6, 
	0xf6cb19b0, 0x102b803e, 0x7087b6d0, 0x156b201f, 0x73a9fbae, 0xbf3c1507, 
	0x7805519c, 0xe3f9f9d8, 0xfbc4ad03, 0xa57b9413, 0x0193bf9f, 0x1748857f, 
	0x10d66bad, 0xcf14859d, 0xefc9a600, 0x40fad1b6, 0x6995c425, 0x6eba3cfc, 
	0x80e28e70, 0x38e7d6e1, 0xe9d7b3ae, 0x89e22a76, 0xc11ae107, 0x33d068f5, 
	0x0c73d8ad, 0x8ab02cf5, 0x29faede7, 0xf709fa41, 0x4ce9e27f, 0x17b2073c, 
	0xa9d2b5f4, 0xf090f7d1, 0xb723f939, 0xa97d5b50, 0x3666cce7, 0xf2855b4c, 
	0x52694800, 0x342d411a, 0x01016799, 0xb7d71b9b, 0xbae38e4d, 0xb428d79c, 
	0xc4f30c9e, 0x5e9c1e9c, 0xfcd5bfb1, 0xf381d13a, 0xbcf8238b, 0x8838a7ac, 
	0xa738dbf2, 0xf97c0824, 0x23af1e72, 0x55fa862f, 0x989f384d, 0xfdf68abf, 
	0xd61f3c82, 0xed41be70, 0x4de688ff, 0xab45aaca, 0x60307f48, 0xbc1abe44, 
	0xc05ee6fe, 0x3009b872, 0xd463bf06, 0x02798ea5, 0x8d2791cb, 0x517bf027, 
	0xeebfea5d, 0x6ca73f8e, 0xae4baf8f, 0x277d23a3, 0x4abe99ab, 0x84ff7bd4, 
	0xffe84a92, 0x6a7cf2f4, 0x9f406bff, 0x0dfdf441, 0x186817d3, 0x5d28be92, 
	0x29cfaf16, 0x83ce1ef0, 0x079c3e89, 0xb7fde76f, 0x9175b14a, 0x291d93a2, 
	0x3c41e718, 0x2abeb4a9, 0x9e97bef5, 0x11f7057f, 0x84dc71ec, 0x9ebe047c, 
	0x3d23a86c, 0xe88571a6, 0xf43cc2dc, 0x28ef50ff, 0xc1f36fb6, 0xf3e4c7d6, 
	0x80beb63f, 0x1e69851d, 0xca7de01e, 0x7ef1577b, 0x9f37adb2, 0x5bee4f5d, 
	0x87e2e785, 0x64d313d3, 0x3c78e07e, 0xd5b21eb4, 0x64f181ed, 0xe93d66af, 
	0x4253efc2, 0x079c4e3f, 0x19f3c176, 0xfbce0a3d, 0xe5829c68, 0x9500fb83, 
	0xf2117d41, 0x8bf51da5, 0xefa2c470, 0x12fcd831, 0xff9e791b, 0x52e66fc8, 
	0x87f5677f, 0xb70d5e58, 0x94b77dd0, 0xc87d7457, 0xe31bb2f1, 0x3940ffd0, 
	0xcfc98fad, 0xb857ac14, 0x29eb826e, 0xdb9eacce, 0xf943cef6, 0xa0ec7459, 
	0xf629a46b, 0x1ee588de, 0xd70c2db3, 0x640fc6b1, 0xeb74be3c, 0x32eb7135, 
	0x379a6cc6, 0x51578d8b, 0x6ff567bf, 0xbaaefd4b, 0x17c83d28, 0xa6e7a711, 
	0x62f676c5, 0xffac53c3, 0x11f08b5e, 0x1eba7382, 0x7a4c386f, 0xb46314e1, 
	0xefc977ed, 0xf29c8073, 0x22b8f356, 0x7b0c6d57, 0x2aba38cd, 0x3b77f0e7, 
	0x23fd74a3, 0x4d59e5d3, 0xba567ef4, 0xee1c33d2, 0x673bd066, 0x19ab2386, 
	0xd39565e6, 0xe0beb43c, 0xe055d19c, 0x957a79e3, 0xaf51730f, 0xf5f96dbb, 
	0x7daf800b, 0xe12f7d16, 0xf6e5aba0, 0x7af0275d, 0x3f0f87ec, 0x2fc75706, 
	0x60af5d94, 0x47bc39b9, 0xfe09f2a3, 0x3e31999e, 0xffa623f2, 0x8359c61c, 
	0x48ce8873, 0xffa4ae75, 0x68dfa655, 0x8debe04c, 0x94940cb7, 0xaf9087bb, 
	0x5b18fac1, 0x7b500c57, 0x96e25eff, 0xe525bded, 0x7e6876b4, 0x4a3cd2dc, 
	0xb23f18bb, 0xf077d116, 0x66b6b26a, 0x39960089, 0xb5c9af9e, 0xb9c3fd68, 
	0xc8cfdf98, 0xe7c6eada, 0x0ec1cbb5, 0xa67f48cf, 0x3e48f9e3, 0x1a08e36f, 
	0xfac39a8a, 0xd37e811f, 0xbb14f717, 0x2e4dffc9, 0x7f7f4371, 0x3a7c64e7, 
	0x19e38abf, 0x813bbfe1, 0x3f7ab3de, 0xb2c645e9, 0x0b88339e, 0xa535dd36, 
	0xcaf01287, 0xb2b74c14, 0xc2acffea, 0x369a5973, 0x96fcbaf1, 0x0e10ce18, 
	0x7ddaa6b5, 0x05219ded, 0xbf1063d7, 0x658e2f90, 0x00b2aa5d, 0xf102f1f5, 
	0x9406632f, 0xea0c9cf1, 0x8fcc9165, 0xeaab3c40, 0x799e31d2, 0xd653e1b1, 
	0x79458f67, 0xd53384af, 0x50105eb4, 0x358e24fa, 0x42ebf6a6, 0x0efbc1be, 
	0x88b773e4, 0x9139dbae, 0x1fcc3ddf, 0x3f9b03d4, 0x24bae362, 0x8d5a8cbe, 
	0x17bc417c, 0xcd74f271, 0x894cceb4, 0xc6d3caa4, 0x87cfa271, 0xad598f74, 
	0x0eca1fad, 0xdc71ab7d, 0xdb6876c9, 0xe30debdf, 0x64f9e357, 0x7c649dbb, 
	0x3cc5fc26, 0x30aae2e3, 0xbd4073e5, 0xfdff2486, 0x0f1f7807, 0xb57edbf5, 
	0x8e27f69d, 0xae3ee316, 0x704bd268, 0x5e94283f, 0x7abee34e, 0xce6fcf35, 
	0xbc6953ea, 0xc2637fc2, 0x29de5e3a, 0xc155fa53, 0x71a498f3, 0x9d33263b, 
	0x50fda4ab, 0x078bfd19, 0x71043dbf, 0x206108ea, 0x9d5ecfce, 0xe70c7718, 
	0x296f5a3f, 0xf087d353, 0xc9b8f61f, 0xb8f2947f, 0xbe32f5ce, 0xb8bf439f, 
	0x01a4b73c, 0x9c59cae8, 0x0cdd7445, 0x5c6885fd, 0xe5ae3c95, 0x195c684b, 
	0x08ba5c72, 0xac56b8d3, 0x397bb24e, 0x1bf7fdae, 0xea0f784a, 0xf5aab18f, 
	0x3091e638, 0x090e47ae, 0x3c3ae207, 0x0b63bedf, 0xec0c9be5, 0xd0f3f891, 
	0x01be308f, 0xd707393d, 0xefa14352, 0x74bb4901, 0x91ee69f6, 0xa46f4c3d, 
	0xcf027197, 0xe6acd677, 0xdb0874f5, 0x0fbebe88, 0x0a5fa44b, 0xb70ddd31, 
	0x9cedd025, 0x97a76891, 0x21c8c3d2, 0x6c79f685, 0xc63a403d, 0xedff70f6, 
	0x285c9db2, 0x40f523df, 0x17640598, 0x952b3f5d, 0xbe913474, 0x04d2d08a, 
	0x0ed7223a, 0x3237393c, 0x945eff3c, 0xb764fbeb, 0x3bf20fa8, 0x043b5171, 
	0x4e9d703a, 0xbb5267f8, 0x05713d4f, 0xafc6e7e3, 0x5673f424, 0x24ffb937, 
	0x70de755c, 0x45f94ce1, 0x21ca8ffa, 0xb0e4f2f7, 0x11c396cf, 0x69f8bfde, 
	0x03895ce1, 0x637fb9bb, 0x30e545ed, 0x2fa01d1c, 0x29763fb4, 0x71971ffe, 
	0x5316f08e, 0x7b7fdf3f, 0x177f1ca2, 0x6ef041eb, 0xf2e5cb92, 0xacfe3a3f, 
	0x863bf1c4, 0xab0bff19, 0x4ee87fa5, 0xbf967ea7, 0x7fe397e1, 0x6caffb8e, 
	0x701fe84a, 0x7fc6f2f1, 0x8efc713c, 0x3ddf8d4b, 0xb4f9fa85, 0xbfd93ae0, 
	0xeb1bfdc5, 0xd57fc712, 0x718fc7c5, 0x2bede333, 0x30473f24, 0xced6f087, 
	0xe1b17beb, 0x71f1d5d5, 0xdc0debd2, 0xe2b0b68e, 0xed02b1ba, 0x2bc354db, 
	0x46707162, 0x4337ef05, 0x7962ac3c, 0xfb89f3ff, 0xfc93bfa7, 0xb8d1afb3, 
	0xe49b2061, 0x39eaeb39, 0xf0ef9e52, 0x96ffda78, 0xfeba13c6, 0x23f721ca, 
	0x189146d5, 0xddfc1837, 0x5fdc0cc0, 0xc866b902, 0x55e8d2fc, 0x8deaa5e6, 
	0x003fc7cc, 0xfeb8411d, 0x7ed5f251, 0xf5f7219e, 0xab9feba2, 0x9fbf3bf9, 
	0x32fffb48, 0xe7403bf6, 0x2f3e29d4, 0x7b3ce46a, 0xbf7f8cbb, 0x80fc926c, 
	0x72371676, 0x5efdb7fe, 0x49a3ca21, 0x448183fa, 0x5fa8bfbc, 0x789547d2, 
	0x2d8f9c60, 0xeddfcd18, 0xab38e396, 0xbfb2468b, 0xc826f78d, 0x974bf6df, 
	0x1bcabfc2, 0x7681bbf8, 0x2ca7797f, 0xc82fcfee, 0xcc9ace0f, 0x6ecbb5df, 
	0xc8e0fdb4, 0xc6cf9246, 0x5fd90e6f, 0xc49e2e54, 0x1ce54079, 0x1bc717f6, 
	0x0efbd2c6, 0xf88c1799, 0x7049f947, 0xafd7f3c5, 0x791b7837, 0xf1cf837d, 
	0xd790d8bc, 0x3487af18, 0xbf187aff, 0x387c2203, 0xb871c20f, 0xeff44d5f, 
	0x9b97c06d, 0x3f4bbf25, 0xd1039f27, 0x28bd4f71, 0x51f4539f, 0xf972fbf2, 
	0xcf2a3b3b, 0xbf9fb259, 0xe9f3bf96, 0xbbf9e1fd, 0x37bf8930, 0xfdfc55fc, 
	0x237161a8, 0x243361c6, 0x74fad8be, 0x93b2f5c9, 0xecbd68f3, 0xb0a8ffb5, 
	0xd0af07bf, 0xdf344cb2, 0x0fd276e7, 0x5a56abf5, 0xeba222a6, 0x31dfc964, 
	0xd14e271c, 0xcca55cfe, 0x7ec6137f, 0x49a3f627, 0x93fbd87e, 0x6362bcd1, 
	0xe73f367f, 0x02d6aa75, 0x42eb577d, 0x77af5abc, 0x35d70e3f, 0x65e44656, 
	0x8f9976bc, 0x865c588b, 0xff4275fd, 0xdf77c03d, 0x84a7ee00, 0x632f6d9c, 
	0xf69c565c, 0x67943370, 0xd013ca0b, 0x9f6bad72, 0xbd957de7, 0xfdc2665b, 
	0x987df97b, 0xfbd279b7, 0x235ef885, 0x7147b7e7, 0xc274c8ef, 0x4f8f65bd, 
	0x7bfe3894, 0x05aeabb6, 0x8815f724, 0x55bf707b, 0x470e4ab1, 0xd759e7e2, 
	0xdff3f3d3, 0x65e25abe, 0xe1a5f598, 0x386f6a7e, 0x239cacbc, 0x9f6e1e68, 
	0xc17ca60f, 0x71ed74d1, 0xa47b6d03, 0xe73a55fe, 0x04e87eef, 0xd59ad38e, 
	0x279538fa, 0x3ae3ca3d, 0xd8e3f2d4, 0xbae8e3b9, 0x15bbc80b, 0xf82dd9f5, 
	0xe4a6077b, 0x8d3daaff, 0xcd1ebdf8, 0xb0cfdfcf, 0x55a0a77f, 0xf6dbdaeb, 
	0x6c7bb62a, 0x71f1eed6, 0x5daa5d74, 0xacaaaf99, 0xbb64303a, 0x22cbedc3, 
	0x4e1e31ff, 0xf7b597de, 0xb67f6939, 0xf5df7532, 0xfefbe6b3, 0xfd8fdabf, 
	0xe63bda19, 0xb4ccba7f, 0x157140c7, 0x9bff08b7, 0x3884fac9, 0x71d3e300, 
	0x8df7e8bd, 0x9adc57ec, 0x1f3ad9d1, 0x2d59afc6, 0x484e78ad, 0xbf7652eb, 
	0x5d49eb8c, 0xcfe11de1, 0x7b7b5ebf, 0x311b2fe3, 0x1b75e15f, 0x9caa3687, 
	0xc8f988cf, 0xf2526fe8, 0x4c6cdfc1, 0x7cc707c8, 0x7d6c5f45, 0x3fe91deb, 
	0xcfcc67c5, 0xc5fe8606, 0x4c8f5b8c, 0x7376d7c9, 0x8ff1259e, 0xfc231fe2, 
	0x9bea26ef, 0x94e93849, 0xb7a61afe, 0x2102f302, 0x8376519e, 0xed287e1e, 
	0xf7fd29d4, 0x4e7c8d47, 0xfe01a8ae, 0x8e884eb5, 0x6be52611, 0xff32fe76, 
	0x5ef2c13d, 0x9129f981, 0x30330b63, 0xfc75bbde, 0x3f328dc7, 0x0883f8b6, 
	0xd7bd91e5, 0xbd3d730e, 0xf6efbf9b, 0x4aded09f, 0x91aeef68, 0xc2cefd26, 
	0xdb9add23, 0x12f9cbdd, 0x7db23599, 0x699223a0, 0xf1b3db86, 0xbe23ef0a, 
	0xe43f61ac, 0xc7b44104, 0xab422efd, 0xee470003, 0xb708872b, 0xf3cff98c, 
	0xe47a6b7c, 0xcddfb8c7, 0xfe30bafb, 0x7dfdf815, 0xdbdf3011, 0x6f8c6afd, 
	0xafa5ce36, 0xad3af3e1, 0xd93f806b, 0xcca6fcb1, 0xf86e7c35, 0xd733ab97, 
	0xedb09fa0, 0xd663656d, 0xcc83d41a, 0x906b1186, 0x973a972f, 0xe957cf61, 
	0x7627863c, 0x63ce82ee, 0xa2ee7908, 0x45bcf53d, 0x7c504b30, 0x02ce7c9e, 
	0x6ffda4f5, 0x69327a62, 0x0f8f8c8d, 0xbc71caeb, 0xd803cf21, 0x7aa223e7, 
	0xbf26b6f9, 0xef9c9a83, 0xf2cfb89f, 0x3495e35e, 0x28a1bf5e, 0x9a24bf9c, 
	0x7f23703f, 0x3eec1f8c, 0x59a6ed06, 0x8f18ee77, 0x8d7e6f38, 0x2f1aefcf, 
	0xc38cceb5, 0xe13a7d69, 0xe4d7f7f4, 0x7c0f1e31, 0x9559f083, 0x40b527eb, 
	0x348efcaf, 0x2deb74e1, 0x5a152bfd, 0xd0ceb297, 0x079c887a, 0x94be766a, 
	0xd9e7047f, 0xb7057b3d, 0xd30d0fe7, 0x41f7cc1e, 0xbf2fb4ef, 0x3222a676, 
	0x8f863b44, 0x99eacbde, 0x5814f8c4, 0xd1aaed41, 0xad2f9d75, 0x6a4f9f89, 
	0x65779ca5, 0x46b0d5d3, 0xec27cc24, 0x0d93fa75, 0xd17bd177, 0x9a3d19bc, 
	0xfd764337, 0xd657c362, 0x7a87e768, 0x7bc771ce, 0x7e255f8d, 0x6977e3a7, 
	0x9b08e2e2, 0x8bb4ad6e, 0xb8d87df0, 0x62b8e4c2, 0x51395bd9, 0x1f7a1e1c, 
	0x6ce896ae, 0x3c4f36cd, 0x97d6c66c, 0xa475eace, 0x0ffba9c7, 0xf5c1ad77, 
	0x4b8d95bc, 0x5fd479e8, 0xbd3d7565, 0x81e93e7b, 0xebcf03b9, 0xe15f5a95, 
	0xdb463473, 0x671c998e, 0x338739e0, 0x7e522f85, 0xd8c85d72, 0xc5fc1bbc, 
	0xbe30d6af, 0xe830fe50, 0xe9965675, 0x9ec473c3, 0x2c4e7cb5, 0x987e7372, 
	0x4f10e5d6, 0x933b420e, 0x1ebc7d3d, 0xb8e1a667, 0xd563bcec, 0xd7067e03, 
	0x5bddfc83, 0x147183ae, 0x1b8a7c45, 0x56bdc270, 0xf235079e, 0xccb9fcf9, 
	0x16e91d7b, 0x34605de6, 0xe5265975, 0x28cdd429, 0xb55ca309, 0xbc6e46c9, 
	0x18cdd69d, 0xe1d4c97c, 0x4bd677fa, 0x09967bf2, 0xbe98ebf6, 0xbbcf13bc, 
	0xcf897ed7, 0x207a8c17, 0x0befc560, 0xfbc3585f, 0xed2dffa6, 0x0d9efdb1, 
	0x87967f5c, 0x65464af2, 0xd98eeff1, 0xcb5c6ff5, 0xd74be1f9, 0xb905fb4a, 
	0xfd53329f, 0xd3cc1640, 0xec9e7f71, 0x3fd2f819, 0x41efa4e8, 0xc377ed46, 
	0x310151e0, 0xdf9068be, 0x70bbac5d, 0xd7c13f14, 0x2c7154df, 0xffcf0478, 
	0xf1351e0f, 0x50cd63fb, 0xe4fbfbc6, 0xbaf82bfd, 0xa4d3ce69, 0xfb81fd17, 
	0x716abef9, 0x717bf27b, 0x3ceddf36, 0x2dbce4af, 0x7af804b5, 0x8cbcee36, 
	0xdd680e7d, 0x12039de5, 0x0099b9f6, 0x8bf9777f, 0x657f17ca, 0xb8be724d, 
	0x7ee08be9, 0x3dcd72f8, 0x99b1ce96, 0x3f237e7c, 0xc3e4dfba, 0x9b0d5fef, 
	0xb9581e27, 0x3931f507, 0x6de3b18e, 0xa6af0fca, 0xfb419e76, 0x1f71bca6, 
	0x13bd8f7d, 0xd39aa3fd, 0xf5a9e34e, 0x5f8cde6f, 0x2c0bac62, 0x79061cd8, 
	0xbc5aa8ee, 0xf4601ae0, 0xe8cba58e, 0xc5afd76a, 0x981b4bef, 0xb371b4ff, 
	0xbfa632b8, 0xf8c617f0, 0x363756a8, 0x329db187, 0x40b3b7a9, 0xb8d1376f, 
	0xf3450fc8, 0xea2457e2, 0x64df1db9, 0x67d4494d, 0x7d44dcd7, 0xe72d7ebe, 
	0xb2d7077b, 0xb3ea8dff, 0x49719fdc, 0xafd764ff, 0x0df9cb5e, 0xec7d646b, 
	0xf421adef, 0xce217099, 0x5c401d3f, 0xd7aa90dd, 0xf8837e75, 0x41d598e3, 
	0x31e5d6fd, 0xf86bed9d, 0x9c971fbb, 0xefe61d6f, 0x6ef27fd3, 0x517145d9, 
	0x5b4fd9fd, 0x9d114df2, 0x80eb756f, 0x4f58eb24, 0xde511f9c, 0x3603c504, 
	0xe0be20ce, 0xaf0d79b5, 0xff4b34e7, 0xc6378a93, 0xb6a6f145, 0xcd4bf8ec, 
	0x19de7cba, 0x5059af27, 0x9eac536f, 0x4ed2ca63, 0x4e5b33c4, 0xe199b7b5, 
	0x73926a8e, 0x5099cf18, 0xb58b603f, 0xfe587b93, 0x5e386f2e, 0xaad28ece, 
	0xdc5fbd30, 0x475852f3, 0xf7d1567e, 0x56b8a338, 0x25f6e21c, 0x8d8b6b7f, 
	0x838c0ece, 0xf4ed2f26, 0xa477e3e6, 0x73ec0f58, 0x235cdf55, 0xc52febd7, 
	0xe22a8eff, 0x276ff97f, 0xc35ffbda, 0x0d05d79c, 0x394893fb, 0xad359baf, 
	0xe5b2e883, 0xc78c91fe, 0xb7afd92e, 0x821bca92, 0x4bcd1725, 0xbd65ad71, 
	0x25ff964b, 0x4e5aefdb, 0xcef732e3, 0x13ed5cf9, 0x85be228e, 0x397b5246, 
	0x20de7823, 0xf2a0ef2a, 0xd135f940, 0x7a048275, 0x9d57f852, 0xabf03fc0, 
	0x710bfa1a, 0xbf4bfa0e, 0x6e78f18c, 0xd7d7f2a3, 0xe3217de7, 0xda2bf1b1, 
	0x57c625df, 0x6e76cedb, 0xeb7487af, 0x1c52d79b, 0x6845d726, 0xf7f2bd1c, 
	0xab1e8024, 0xee7e01fe, 0x7d451401, 0x63f3b42f, 0xf0901f38, 0x6deb0078, 
	0xbf787ae5, 0xf8fbe797, 0x7bf66b3b, 0xad888946, 0xbc500c97, 0x033c43ed, 
	0xc78be77f, 0xd96b9db5, 0x7e931fce, 0x339e46ba, 0x1718d1aa, 0x73ae3ef0, 
	0x607acd0a, 0x7c9dff28, 0xf152f95e, 0xbeefc538, 0xf6dcb8d4, 0x9f9dc333, 
	0x38f87901, 0x34f385af, 0x68a7faad, 0x6fe3c1fc, 0xad597e53, 0xaf6fdfce, 
	0x8915a7f5, 0xbfed3e38, 0x06aa7199, 0x1f005df7, 0xf0fe8afa, 0x473c04cc, 
	0x1fbe6fa6, 0xfb58afbf, 0xd203e71e, 0x639b14f7, 0x427351b8, 0xa39ea519, 
	0x22cf9ff3, 0x842f353d, 0x5f3e7133, 0xc3e1a0f3, 0xb9b541f3, 0xa5ec3046, 
	0x9fafdcf9, 0xf1af3b8f, 0x1e712b8c, 0xbbb87df7, 0x13759647, 0xf9750dcf, 
	0xdd8217ba, 0xe15c7eb7, 0xf9d70fdd, 0xa1c8ceef, 0x87f99d79, 0x7d422fad, 
	0x1b75fcd5, 0xeca6f3cf, 0x560ff280, 0xe748398d, 0xb9846edd, 0xc1bb5c55, 
	0xaee0c685, 0xfd61f9b8, 0xe3ad4cd7, 0xeae7d038, 0x3f4373a1, 0x05a4f9c0, 
	0xe51774f3, 0x7bfd8a8e, 0xe4df37ad, 0xbb6ccf76, 0x7778f316, 0xf70663ff, 
	0xca0bb25b, 0x7310c83f, 0x7ac22f76, 0x6157fb86, 0xbf026768, 0x7f60ed4f, 
	0x3c6ffcda, 0xfefc0278, 0x1f6d1ed4, 0x7bfee6e0, 0x135f86cc, 0x30a1e63d, 
	0x7907f688, 0x2fdb37d6, 0x9466bcf2, 0xef9f05be, 0xef27a7bf, 0xd7b40154, 
	0x251fb862, 0xdbe24dfa, 0xde9e6101, 0x69eff5c1, 0x4acf50a5, 0xc98fcfb3, 
	0x8f1476f3, 0x4130e7d9, 0x1dfa0ddf, 0x198f194a, 0x9d6f2eeb, 0x03bf9546, 
	0xd8cfaf64, 0xe0c672f9, 0x8177f2a3, 0xa452c52c, 0xf6bc53bd, 0xb1f764cf, 
	0xed9fc873, 0xa9e528dc, 0x93c23ae3, 0xde316fe6, 0xf9c19399, 0x83e7c0aa, 
	0x1eccc918, 0x7dfc2c25, 0x5aa78a38, 0x85d5b9f1, 0x19714afa, 0x3f837bd0, 
	0x6c17d697, 0x89bf7d7b, 0xeb8501e7, 0x8ed8df38, 0xaa836b4f, 0xf9843d5b, 
	0x52d6a6a1, 0x603ef24f, 0xd6611c82, 0x0b847844, 0x85e9c83d, 0xfd21737a, 
	0x478c9f1e, 0xd18ff917, 0xeff7ebf7, 0x79cd0715, 0x8079cf94, 0xdfed13f2, 
	0xf214ad01, 0x7189a1bb, 0xf89c7263, 0x0b8848cc, 0x089c657b, 0xf98efde5, 
	0xd4ce23b7, 0xd673e58c, 0x6b3ffd36, 0xf9799c62, 0x36a38e6e, 0xce0145b8, 
	0xbed0eb1b, 0xfaeb3ec0, 0x7cc3e27f, 0xe16e2da5, 0x0dbaf5c1, 0xd016e7a7, 
	0x873c98be, 0xe1847b37, 0xeeea7ec3, 0x8c15f987, 0xce71b829, 0x7a73f8c8, 
	0x7567f41b, 0x0667638c, 0xbaba950e, 0x2eaad885, 0x6ffd71d2, 0x0bb9864e, 
	0xbffb37c5, 0xf2c0df3a, 0xceb8ffec, 0xad9c90a7, 0x682fc41e, 0x8e30d6f7, 
	0x16af711f, 0xa5da6f9f, 0x68386384, 0x24bfffd3, 0xaeb5f6dd, 0xa83c24c5, 
	0xf5807893, 0xf4f5c15e, 0x435b3534, 0x6735a7be, 0x0d5f406b, 0x9e22a9e6, 
	0xa7941964, 0xa7e5c76a, 0x9bde389b, 0x8989457d, 0xbc018ddf, 0xc7c8a379, 
	0x6af7e3ed, 0x09718fbe, 0x1decf3d0, 0x10279405, 0x745c2339, 0x4e884ede, 
	0x3a274f3e, 0x65eb7123, 0xe388741b, 0xe04631cf, 0x71a36877, 0xe1f1ae5e, 
	0xf1bfb46e, 0x21cf63d6, 0x2afeb4ee, 0x5ef607cf, 0x8e85ef37, 0xfcc2ff9c, 
	0x5377c5d2, 0x87da297e, 0x4be7f64f, 0x3d00c3cd, 0x60847da1, 0xf9c3e28b, 
	0x95e72d9e, 0x432f58eb, 0xd3775771, 0x8cafcce5, 0xe57e662f, 0x57e762ff, 
	0x397ca0f7, 0xafce5f1f, 0x1bee1f2c, 0xb1dc39e3, 0xc7f21e3c, 0xe93c77f6, 
	0xf7d4a779, 0xdafd98da, 0x410da6f3, 0xaa574b90, 0x3f40751d, 0xe5cee19e, 
	0xbaff3efa, 0x1f1db26e, 0x75c07c00, 0xedc19eee, 0x99387e74, 0x00bc649e, 
	0xfa253cfb, 0x78031ec8, 0x4fa9ccfe, 0x2215dfa7, 0x4a9d5f7e, 0x3bfc9ab7, 
	0x142fc66b, 0xe703ab54, 0xc7711d34, 0xdb6c673e, 0x3dda3d7d, 0xed1ea5f0, 
	0x7662e7be, 0xc7c87c2f, 0x1f2dfbba, 0xdac305c6, 0x3eec107d, 0x7a8bf8c0, 
	0xc56f7640, 0x1f26fddb, 0xddb275da, 0x1fbf9d93, 0x2d5afbb3, 0xc9643bf1, 
	0x22df5f76, 0xd06beec8, 0xc72e3bee, 0x886e81ee, 0xbea5ebf7, 0x3e7294d4, 
	0x7c4ddbfa, 0xfed934ee, 0xbfcddf67, 0xff6c920f, 0xffb79ea0, 0x0e1c4b69, 
	0x0eb7fda0, 0xbc5fff6f, 0x9fde80fe, 0xea7f5e1d, 0x5d367f51, 0x2e04fe86, 
	0xc07c7f4f, 0x1cff5a07, 0xf8ec8f46, 0x8a2d1cd7, 0x3f55beb0, 0xb7e709a9, 
	0x84b8ff13, 0xff39c2e2, 0xfa843ae3, 0xf826e781, 0x3b2724fb, 0xff89ee91, 
	0xe7c25bd9, 0x3e12ac94, 0xc51464a7, 0x5faa539f, 0xfce28cb1, 0xb80c406b, 
	0x539f6d8e, 0x9458b07a, 0x5d21b9d0, 0xcb77e8f8, 0xfdc3e10c, 0xcd0707ac, 
	0x80bbf462, 0x5b88a54e, 0xce85a846, 0xff870921, 0x519b9629, 0x9e897c8a, 
	0xe13aaa43, 0x76cff5c3, 0xa6a96e79, 0xfd127cd4, 0x6bfbaefe, 0x62f5e56e, 
	0xf6b9eb41, 0xe2daa4b9, 0xb4973a12, 0x7e972abb, 0x02fffe5f, 0xe1a06a32, 
	0x00037071, 0x7ddd9c78, 0xd5547c0b, 0x33daefb9, 0x0793267b, 0x0c82f261, 
	0xc1793024, 0xc3b6e490, 0x62431843, 0x1c280276, 0x2a2d15ed, 0xe42745b6, 
	0x0da95131, 0xeca240ef, 0x50c84249, 0x4c978484, 0x2d401b05, 0x68d39887, 
	0x6d8a2ded, 0x623d2077, 0xb60a2b6b, 0x8673dad8, 0x9cd69a87, 0xa35a5636, 
	0xbef9e3d2, 0x799dad6f, 0xbd509124, 0xe1dfdee7, 0x6babb3f7, 0xf1ebdaf6, 
	0xbffd6fad, 0xc8a9dae7, 0x37558766, 0x367b3263, 0x31997d53, 0x0bbed243, 
	0x0dd8c6cc, 0x6af4dc9f, 0x9f632243, 0x4de6bfc2, 0xc55fed8c, 0xb19fa398, 
	0xd4b4a0fb, 0x52d7d630, 0x64eec358, 0xf085a98c, 0x739dd41f, 0xa1afd86b, 
	0xf0cb9aee, 0x3c5b9f5f, 0xf8c85c5f, 0xade3353f, 0x5e6d2a16, 0x68373c3f, 
	0xc677fd4c, 0xf8d85b62, 0x558c71a6, 0x98d631c5, 0xd03dd8c2, 0x538c2c7f, 
	0x43be5d91, 0x53cc632a, 0xc32d10d8, 0xcc713cfc, 0xdf804de6, 0x4f3b78d3, 
	0xf52961e1, 0xc545633c, 0xe0b3d10d, 0x5d4a5339, 0xb67d40cf, 0x54e7d985, 
	0xcc26f630, 0xd9fa1531, 0x733b4bbf, 0x55c716a6, 0x61cf362e, 0xd464f34c, 
	0xaeb00fb0, 0xaf6854d9, 0x5c0cb125, 0xd3d7c777, 0xe375c79f, 0x89b7bf7a, 
	0x06b1b8cf, 0x6b0d4fdb, 0x9fed16ef, 0xa1b53036, 0x63e7bc52, 0x8b22e5ac, 
	0xcd7a6e62, 0x599d42af, 0x16c5bf98, 0x7b1adfa4, 0xcbd64ef9, 0xfae2f5fb, 
	0xf63af9f2, 0x435a66af, 0x019db04a, 0xe7856fd6, 0xe9025687, 0x2a977c60, 
	0x6917abc5, 0xebf6237c, 0xb0e81b7a, 0xa9b1b19c, 0x9033998c, 0x254fd04e, 
	0xd5d2c70e, 0x7a675a68, 0x5d14147f, 0x01b646a9, 0x4c8d2b6a, 0x8b754efc, 
	0x55baf12a, 0x34ceb191, 0x9858375e, 0x7e83eb84, 0x43ad3335, 0xbfa05491, 
	0xa4a8f032, 0x25f1a22e, 0x27fb8a68, 0xfb32efe3, 0x1bbf8cb9, 0x5d188f92, 
	0x0f4f3d2a, 0x937bd144, 0x26d4a97a, 0x9d52a65d, 0x2d0b657c, 0xf7c3dedb, 
	0x940afedf, 0x3eed57db, 0x96bc60c0, 0xaaf7f506, 0x583ad8c6, 0xd20d75af, 
	0xff63f543, 0xff5eef85, 0x1bd7097b, 0x0c9bbe90, 0x26712cfd, 0x89d00331, 
	0x11db300d, 0xa2977e78, 0x3137edca, 0xb1f30896, 0xd00c3ae3, 0x6fb191b3, 
	0xa00e3f42, 0x7a3f1ddb, 0x8c3e5261, 0x34b4755b, 0x31eb00c5, 0x40bec164, 
	0x3532773f, 0x89ea09a5, 0x5105a4f6, 0xa6fdbf40, 0x811bbbd2, 0xb8bd779e, 
	0xb78e00fc, 0x0076b57f, 0x6cf187c7, 0x8532a24c, 0x68f631b5, 0x607be70d, 
	0x55fb862d, 0xfba4a718, 0xad3e7cdc, 0xad573f40, 0x11f2de2b, 0x69f9ff63, 
	0x9f063031, 0x4ba3ee07, 0x1b79fd86, 0xa9bec3db, 0xb6f58e54, 0x6116fef2, 
	0xcc19d97f, 0xb1ebc298, 0x63415ff0, 0xa23ec691, 0xcd86b0e5, 0x6966c3c0, 
	0xa205e37b, 0xc18eafdb, 0x8c575938, 0xbe60dae3, 0xb14b2b06, 0xa260bd42, 
	0x03d5b7b2, 0xf1aa17bf, 0x37deb06d, 0xb8c27cf0, 0x6fa9c905, 0xfed88bb0, 
	0x0f9c1ee4, 0x78f1aa73, 0xda3aeeee, 0x81b0c730, 0xde614bfa, 0xd9dfbf20, 
	0x3d86606e, 0xde12fd8c, 0xb3f7824f, 0x4664ce9f, 0x45bd2fa8, 0x801fdedd, 
	0xf732a475, 0xbf384be5, 0xc3f55f86, 0xfe7e0bba, 0xe546bfba, 0x7b4297ed, 
	0x2eb994cf, 0x9f2874d7, 0xeb8e617a, 0x3ebb2819, 0x5e09e5e6, 0xfd26e656, 
	0x675d018a, 0x4a578fdb, 0xc2cf9e78, 0x1dfed8ef, 0x80bfaed1, 0xfd106fbf, 
	0xef894324, 0x1db63de5, 0x3bd973df, 0xa401c90e, 0x12add657, 0xc2c587e2, 
	0x32c0dfd4, 0x604ac216, 0x06cdb31e, 0x68e9d23f, 0x0bd47abc, 0xb54beaeb, 
	0x782ef532, 0x0185a8b6, 0xd3beb3cb, 0x812f54a9, 0x8bd40b7a, 0x827405be, 
	0x4ebd1fb9, 0x86dbdfbd, 0xbbb8607c, 0x8eff9131, 0x5567d3f8, 0x26bf4dbc, 
	0xf4ffa368, 0x3507d9f3, 0xa82887ec, 0xc7d7e906, 0x7c9dfda0, 0xc626d4df, 
	0xc9d8b94e, 0xff60b1df, 0x2d1df391, 0x43ae447e, 0xf5c891c7, 0x033e7cd0, 
	0xc657e0af, 0xcca6bfe0, 0x39c436b3, 0xe740d38f, 0xbb63c6e9, 0xab80ac12, 
	0xd1afc0d9, 0x99f5eeb0, 0xf0030486, 0xd3145167, 0x30176f90, 0x43960125, 
	0xb8be4174, 0x81dd4621, 0x1886e2f2, 0xe3132798, 0x84f115fd, 0x00de1065, 
	0x2a4f11ed, 0x38d0cf32, 0xe79ab8fa, 0x3d5b0d74, 0xd6fddc7a, 0xede0df37, 
	0x236c9711, 0x3ec8abb7, 0x07e0312c, 0xf415e23b, 0x59813b1b, 0xec2fc0cc, 
	0x5be1225c, 0x8e2653f3, 0x3235fd77, 0xaf9eab9e, 0x2fa23116, 0x67b621e0, 
	0x1213fee6, 0x0f2583cc, 0x82c21434, 0xd36fecba, 0x7d986e7a, 0x118d29ac, 
	0xfc717a4e, 0x6c4bb9cd, 0x971e5788, 0x738062c1, 0x69fc01e5, 0x0571177a, 
	0x5dce0af0, 0xf613d225, 0x61bdbe73, 0xe227ee12, 0xe3a78e12, 0x89c702d2, 
	0xa27ef849, 0xe6077013, 0xede80cb7, 0xac728cbc, 0xb9ca00fc, 0xc1d8bbfd, 
	0x1fb0257d, 0xb74413ce, 0x1ab97e48, 0xce0a7b3f, 0x46f7a01c, 0x6345b7c9, 
	0x30bd5795, 0xbce78a9f, 0xe0f6e6b1, 0x69c4577e, 0x32362f36, 0x8fe4121a, 
	0xb94279c4, 0x1d9c3aea, 0x19f82ed5, 0x2334dbe6, 0xc7e220f1, 0xcb0eb05d, 
	0x90df6c1a, 0x8bbd0320, 0xd81d95e2, 0xf55886fe, 0xf23f1c55, 0x80bd105c, 
	0xc748956e, 0x1d2250c3, 0xf32abf01, 0x9b7f09cb, 0xd79d3932, 0xefd8fb3f, 
	0x74ed7299, 0xfee500fd, 0x0fcf885f, 0x3d04cb38, 0x7dc54e41, 0x6460790b, 
	0x05ccad7e, 0xfc132d7e, 0x96f905ad, 0xd20ee1d6, 0xd10ba749, 0xe8e82dc9, 
	0x9d7eba1d, 0xca51455e, 0x8806bbab, 0x1f3666df, 0xe1299c23, 0xf9e5ce78, 
	0xc3ce0501, 0x522db4bb, 0x2665c91b, 0x7c84caf9, 0xf5c37e47, 0x9237c886, 
	0x2eec1e63, 0x42dfef28, 0xf28d7af9, 0x2ef3975e, 0xe0c4bdbb, 0xef24f6a4, 
	0x179e2e49, 0xe68cbf72, 0x8539e129, 0x979e327f, 0xf3afb948, 0xc705f107, 
	0xb89749a1, 0x997c9fbc, 0xffc9d1ca, 0xe2f87eef, 0xcf907ca4, 0xf4a51785, 
	0x89df6864, 0x3abe07f4, 0xcfc157d0, 0x6ee5ca07, 0x87f8a7a1, 0xdc45d0e2, 
	0xe323cbdf, 0x1affed10, 0x04d4ce7e, 0x3bf81fce, 0xa197f7bd, 0xbbf91978, 
	0xefb4578e, 0x349e8f80, 0x7905e6c5, 0x356472e1, 0xf7e1aa18, 0x1918ef1e, 
	0x3b32b970, 0xea39e48b, 0xcf302d05, 0x04b0c076, 0x0fe3cb58, 0xbd92b83e, 
	0xc6f5f9ff, 0xde291ec4, 0x64c4f500, 0x8f02f655, 0x5a513e24, 0xf6f2b5eb, 
	0xc62e212f, 0x3f90521a, 0x0a436c59, 0x49ea23f2, 0xfeba2fc8, 0x487e7913, 
	0xf7d909ef, 0xf0297faa, 0x055da03b, 0x078003ea, 0xf9c17677, 0x392e3a02, 
	0x5481faf4, 0x42fb4b81, 0xeb03c970, 0x1d5ff673, 0x4b8b469f, 0xe0553f3a, 
	0x6f48ed3a, 0xe74ce746, 0x3b43aaaf, 0x6037c8fd, 0x06bcd807, 0x3fa05fe4, 
	0x8fe91dd2, 0xe9cf90fb, 0xcb9ab95f, 0x447a48f1, 0x4afd51e2, 0x3784cfbe, 
	0xde3ea0d6, 0x27b4fb84, 0x8a7c17a8, 0xe3ec1cfa, 0xf5129095, 0xd74c25c1, 
	0xbadce107, 0x883ea0d9, 0x1acf9e7a, 0x5c0e07a2, 0xa97c8f1f, 0x17a487eb, 
	0xc26f7bc2, 0x1fa19bf3, 0x5881e859, 0xa30f79c7, 0xf5c37a07, 0xa14679c0, 
	0x3ead1a07, 0x46b503d4, 0x8e0207ae, 0x5f9dfec0, 0xb940f5cd, 0x2b24f522, 
	0x9a9cd787, 0x7be1f5e4, 0xac2a8d8d, 0x2a867e27, 0x72d040f4, 0x455ca0a5, 
	0xc0f50b5b, 0x24fde137, 0x2cf65798, 0x6381e93b, 0x03f6016e, 0x9e37937e, 
	0xf2b4d7f6, 0x466b4be7, 0xab46f7d6, 0x237ae9df, 0x806a95ea, 0x4f4d99eb, 
	0xba3cf9f0, 0x38dea869, 0x53b83e92, 0xe3d42596, 0xedd55c75, 0x0d471d14, 
	0x26e11a59, 0x107b5ee1, 0x4bc4352f, 0x52f1d5df, 0x1744bfc7, 0xd332273f, 
	0x15837fa8, 0x47d9114e, 0xc72cfd2c, 0x83c78e3b, 0xea4ea838, 0xfc3c0cfb, 
	0x029f9750, 0xb3459917, 0x4bff60b5, 0xe5b8cb65, 0x7d607f02, 0xe97bb0b2, 
	0x87283fb9, 0xa5952f0b, 0xefbf304b, 0x5bfc70d7, 0x4178e2e3, 0x803fd3f6, 
	0x003ffb6f, 0x71c3dffe, 0xcb8ca5b6, 0xb9979685, 0x2179c03c, 0xbd605a41, 
	0x5f386b8d, 0xdda1bd13, 0x5e6711d7, 0x42e5e712, 0xc48d3ed0, 0x621f7d1b, 
	0x74e55ed0, 0x1cf81f4f, 0xe3f68bf2, 0x44fee099, 0xda0b27ca, 0x656f44a5, 
	0x20a895d2, 0x937a75dd, 0xf210165d, 0x396dfa08, 0xea08f201, 0xfae29f77, 
	0xbf26d7c6, 0xbc066931, 0x7396d877, 0x2949952f, 0xfe86cef7, 0xde54250e, 
	0x87ea1b3b, 0x1dff2b92, 0xab7093f1, 0x845f6424, 0xe1aeaafd, 0x22f68bfb, 
	0xb7f5f38e, 0xf8899db8, 0x7efc86d0, 0x1c5dffd2, 0x407c2467, 0x7f737839, 
	0x1cec4ed0, 0x32789db5, 0x9a83e385, 0xdc21f1c2, 0xa35e6c4e, 0xdefb89db, 
	0xbb007c40, 0x9da86f72, 0x4ed074b8, 0xf8a12964, 0xdb8ba4b0, 0x3e3a1d89, 
	0x2ef13b08, 0x09f713b4, 0x9fcad0bb, 0x07c0bfff, 0x09186f5d, 0x7ca07627, 
	0x036ef986, 0xda0f2fdb, 0x37727f16, 0x31c59be9, 0x8bf50daa, 0xe491a74a, 
	0x6c9716de, 0x8e297dc5, 0x02a7fc55, 0xcd7e3fc4, 0xfd8cd7c7, 0x5be73b37, 
	0xbd00eed1, 0xe12c55f1, 0x7fc813df, 0xe669ea60, 0x4df7ec0a, 0x7ef527d2, 
	0x1e65fd23, 0x80f4071c, 0xc681ab52, 0x7016b3e9, 0x016a59ff, 0x3fe91675, 
	0xdb8ab7db, 0xaab1c5ab, 0x39d615bf, 0x8ad4b52f, 0xab1c5afc, 0x1e02aabd, 
	0x71804d57, 0x3955cce0, 0x23d06c7a, 0xadaa626b, 0x41f895a9, 0x0c94ddf8, 
	0xab41e02f, 0x619b6245, 0xca8a6d7e, 0x9f83af9a, 0x70278e4d, 0x5814db9e, 
	0xf8c3dbd3, 0x79735cf5, 0xd79739dd, 0xe835e623, 0x4c9c5bc7, 0x71cdbc7e, 
	0xe02b436e, 0x45fb0ec5, 0xf84d3b2d, 0x7fd17aef, 0x0ed0daa7, 0xdb1c42ae, 
	0x7e77fc23, 0x9cda2f2c, 0xcebfa0b6, 0x9e7ee0e3, 0xeb26ae2d, 0xe748f3e2, 
	0x45e2eb1e, 0xd9641f68, 0x6ef6836e, 0x46ab81a0, 0xafb403ec, 0x0f71c55f, 
	0xe22afec8, 0x3f5866d0, 0xbd9371e2, 0x42fb86c9, 0x620bcc7e, 0xee089e5f, 
	0x7aa66553, 0x987415b0, 0x7a7f8fe6, 0x11ce2ad0, 0xc203fff2, 0xc999527f, 
	0xb5bf230e, 0xda199339, 0x77f35793, 0xa2efe456, 0xfd44aefd, 0x7afb82d0, 
	0xaaf90322, 0x4f51c60a, 0x167e38d1, 0x93554e32, 0xfd44d71c, 0xf2333127, 
	0x368bacf9, 0x1de62029, 0xc5ce943d, 0xd0cf8031, 0x4b2bab7f, 0xf50edcde, 
	0x4c1fd72f, 0xd79d0f33, 0xe74cbb66, 0xe2e3f9b3, 0xfa2788c3, 0x75fc9178, 
	0xaca9d60a, 0x589c6619, 0xf88a7196, 0xf90321ab, 0x9ad3d752, 0x387c6152, 
	0xe73b1edf, 0x5fc12aaf, 0xf1fd230f, 0x97f00b3f, 0x6379187f, 0x20a572e5, 
	0x6c6f8d4e, 0x2928f9c3, 0xbbe436ad, 0x50ac37ea, 0x27f749fe, 0xe2a60a83, 
	0x70148e3c, 0xd57ceafa, 0x52be246f, 0xda066a4c, 0xf84605e1, 0x1c63a05f, 
	0x3322fae3, 0x7448391d, 0x4d6cd01e, 0x5ed94137, 0x3a006192, 0xb5deb336, 
	0x47e841d2, 0xb0a8d435, 0x85599eee, 0xeee78acc, 0x3a819488, 0x6cbacc8e, 
	0xacaa4728, 0xfb96f2a9, 0xd0439da0, 0x57f62ec1, 0x99cda7bc, 0xf9436acb, 
	0x7c7e35dc, 0xde20ded3, 0x82cd1e10, 0xdc669f7d, 0x7ee46b9e, 0xc207c43c, 
	0xfc41f39b, 0x8eb2fc21, 0x5bd14fc2, 0x3f75f54e, 0xe29f9aba, 0xc76855e3, 
	0x3dbdd966, 0xf41b1993, 0xca5f6453, 0xfa2b7c20, 0x09f133d3, 0x583f1fb0, 
	0x913afdcd, 0x9e28a2f2, 0xd637e8a9, 0xd0f3c5e5, 0x73c9226e, 0x41388596, 
	0xc4f404f2, 0xe90e426d, 0x3568b07c, 0x512cafdf, 0x0a5a62ce, 0x7ec56bf6, 
	0x09d75e61, 0x78102aff, 0xd8bfce1c, 0x2544fa08, 0x1d5ecce1, 0x17095aaf, 
	0xbc5b57b5, 0x8299ccd8, 0xf714bd7c, 0x7ed82cab, 0xec0bee09, 0xc83c715f, 
	0xe067c42b, 0x11da1f1f, 0x3e41ab0a, 0xa029e9e9, 0x03482cfd, 0x39a00b3e, 
	0x406560dc, 0x275cbb9f, 0x625bdfc9, 0x4ab84139, 0xd3e05efe, 0x7c0563be, 
	0x7f04bb7f, 0xefb47e89, 0x50dab015, 0xd1b54b7e, 0x44dca2fe, 0xe97942be, 
	0xa7e5097d, 0x74ed17ba, 0x06deab94, 0xaaf7bfd2, 0x9e0b5f20, 0xac1bcefb, 
	0xef372831, 0xd1f9b946, 0x67f372c8, 0xabfdc3ab, 0x75f37283, 0x39f1372e, 
	0x20bf53f9, 0xd671e9b9, 0xc383d4b9, 0x61e6cfcb, 0x215ee7e4, 0xed6f88ff, 
	0xd8fedcf0, 0xfc8d19f6, 0x7196f73c, 0xf017b1fd, 0xf7b0cbf5, 0xde717eee, 
	0x6a311f51, 0xfd5be436, 0xd4067a5c, 0xb0ebf40c, 0xaed8efbf, 0xf079d302, 
	0xabb9d25c, 0x6f3e42c9, 0xc36dd23e, 0x5a486173, 0x62f9117a, 0xd393f09b, 
	0x7389f739, 0x0555728d, 0x5dbf451c, 0xb3e7b732, 0x4cbcef51, 0xfe9167bf, 
	0xdeff89be, 0xb5b5fa7c, 0xcf437dd2, 0xd6b9e0fb, 0xb9fa52e3, 0xf86156fe, 
	0xfbe5eeb9, 0x0a5f891e, 0xb88bc5ea, 0x83bf471d, 0x4ce7877d, 0xcd542b8f, 
	0x90607338, 0x2f18dccf, 0x03714338, 0xf8a60f5d, 0xad0fd401, 0x921b7ae6, 
	0x07f841a4, 0x388bcf5a, 0xf89a3682, 0x397e4281, 0x7e807e3d, 0xa7284585, 
	0x6f79f9b2, 0xdda23d5f, 0x3617a118, 0x405db4a6, 0xfc44d6fe, 0x7d6ded80, 
	0x7e17a837, 0x4175ce22, 0x3f1139f2, 0x8c373e00, 0x718fbf82, 0x1107f27f, 
	0xf2277dfc, 0x0525e837, 0xbb275e27, 0x982f83f1, 0xddaf3fbf, 0xdf0d74f8, 
	0x13dfd257, 0x1dbcfec4, 0xd6487fe2, 0xf7286d6c, 0x6dad289e, 0xec27b943, 
	0xa41c7d7e, 0xf1f911bb, 0xf92b52c9, 0xe5087e19, 0xc7795086, 0x84fd5a52, 
	0xfd586f7f, 0x76bbc8c3, 0xe20defa1, 0xbbc9224f, 0xee6ddad1, 0x8f14bf41, 
	0x514d1603, 0xffe17876, 0x35e612ff, 0x9f97fd17, 0x7b47e4bc, 0x867af3df, 
	0xfc62b58d, 0xbed0c2ca, 0x1e7f9c43, 0x7c7f8bfd, 0x6052e6df, 0x36fed09e, 
	0x9f446f68, 0xf5a5fa3b, 0xf5961676, 0xac73ff9a, 0x573f3167, 0xde40e345, 
	0x43467f60, 0xd8c9d122, 0xfa748890, 0xe08ffa0d, 0xf049a2fd, 0x279e853c, 
	0x3cf0efe1, 0xcfe9db09, 0xf164f7e1, 0x7f3e325e, 0x3bd73571, 0x051bde30, 
	0x69c54783, 0x249f9892, 0xec3dd7e6, 0xf0aeecfc, 0x218c0df9, 0x221c837a, 
	0x1498ab39, 0x181677f2, 0x8437bb81, 0x5ed519ea, 0xf5191fe4, 0x7207900c, 
	0xe784b77b, 0x2b7284df, 0xf2770423, 0x410b245d, 0xcf9090cf, 0xe18e50e2, 
	0xe84b9773, 0x1c70ae17, 0x71c2b8f2, 0xe89e25a8, 0xdbd30ff5, 0x8fdfc699, 
	0x3f4893d0, 0x1ef4977a, 0x3d41d7c2, 0xc559c849, 0x8654fc04, 0x64daf6f3, 
	0xf5ebc70d, 0x707afe23, 0x59087f7d, 0x70dce15f, 0x82edd55c, 0x30a97d41, 
	0x7c6a9e5c, 0xcd5fba3e, 0x50d924d5, 0x6afdd0af, 0x211f84e3, 0x0a6f9449, 
	0xbf66bbdc, 0x4b40f8ec, 0x5394294b, 0xe9ad0503, 0xf8d94e38, 0x38e01747, 
	0x33edbe87, 0x9e1fe30e, 0x819f84c4, 0x1a4657fb, 0x0dda0b6f, 0x649f5097, 
	0xb9f52f64, 0xed1eb90a, 0x2cf2fae4, 0xf542afb0, 0x7379489f, 0x7a87f41d, 
	0x8c95933e, 0xfaa87d70, 0xd0fa70e0, 0x30639466, 0xcfb416fe, 0xbf6c187e, 
	0x7368ce03, 0x50fa30ce, 0x482b3c84, 0xf5433353, 0x4dc5e6a1, 0xd0faa119, 
	0x7c1dfce0, 0x1f9c1efe, 0x08ce47ea, 0xea2b5939, 0xfae185d5, 0xba9390b8, 
	0xbf099b1f, 0x1b1fa0f5, 0xb7a4d7fd, 0x87976bc2, 0xdf0bb1fa, 0x3d4360dd, 
	0x34ea70af, 0xfd812b1b, 0xbd20cdea, 0xb33d7f68, 0xa9720cbd, 0x157b2c70, 
	0xc033dcd5, 0x8435250f, 0x4f5abb6b, 0xef9cff20, 0x3fdd7dc2, 0x5dfaf4b3, 
	0xfea1cf94, 0xda05e9ae, 0xa93ff22f, 0xc79d3d92, 0x91749429, 0x3f7e40c7, 
	0x7e480fdd, 0xbab73827, 0xa51d499f, 0xe60fa99f, 0x6938718c, 0x0f5bf721, 
	0xe48d3bf5, 0xe326d3ef, 0x9aa70e3c, 0x7a3da326, 0x9343ec68, 0x2620515d, 
	0x976eff8a, 0x6a7c3ec1, 0x98ed8fea, 0xfd06c1b4, 0x5bf71a56, 0xec913fa1, 
	0xaf7bf648, 0xfe7bfc26, 0x3a26f4a1, 0x9969dfa3, 0x9dfa3f7a, 0x3aeffd22, 
	0x217df5fd, 0xfd07b7fa, 0xe5fa0af2, 0xce7ed7bd, 0x95c1bffe, 0xeac38923, 
	0x0f3cfa6b, 0x77793f02, 0x6c781962, 0xff633777, 0x15ac02cc, 0x02c23fde, 
	0x0f9ced8f, 0x1c0ae0fb, 0xfb003b6b, 0xf6d634c3, 0xd579ca12, 0xd6ba06d8, 
	0xa6f97f3f, 0x7e7856fd, 0xf6efcbe4, 0x76c01c24, 0x5fbb63ea, 0x678176c6, 
	0xed7fc07d, 0x2fe27625, 0xafd83be2, 0x03bf18c3, 0xc58d61a5, 0x0fb66254, 
	0xe291bfe5, 0xe87e8377, 0xf9031685, 0xb4368147, 0x9fcad7af, 0xa7f12b16, 
	0xbbec2b72, 0xf923f381, 0xe73c45a9, 0x27cffe6a, 0xe298fea7, 0x539bdf6e, 
	0xfa167934, 0x279bad33, 0x5863dda3, 0xbf711168, 0xd84079a1, 0x0d555dbf, 
	0xfac06ea2, 0x1a4b55f6, 0x4e5bcf90, 0xfc409c94, 0xd830f3d1, 0xb5d97e08, 
	0x2cbef3e8, 0xf41ddcf8, 0xab4e1f63, 0xdf9c303c, 0x3d72b15a, 0xaafcb47c, 
	0xbf91edeb, 0x6c342e83, 0x5dfd6bfb, 0x31c733e7, 0xf078fc89, 0xed2f05cb, 
	0x8c47fa97, 0x768b315f, 0xcf9e0da1, 0x3da05a01, 0xc09a3305, 0x47faadcf, 
	0x6f666fc4, 0x32fbdfbc, 0x3b08ade6, 0x28e5b2dc, 0x4e4067c6, 0x266def2c, 
	0x4cbc4dba, 0x0af13aa5, 0x70f5a7af, 0x057b497c, 0x816b2bca, 0xf67e8075, 
	0xf2135d4f, 0xd8cd8ccd, 0x1877db79, 0x4999ebf9, 0x21e2997b, 0x510f1e36, 
	0x89b138f5, 0x26a98df6, 0xd3a66fb1, 0x9aeb5f3c, 0xb58115e2, 0xe3d2fec2, 
	0x7e9ab2b8, 0x51d60634, 0xdb9daf30, 0x411d6805, 0x99d7a1dd, 0x6993808d, 
	0xdf17e8b9, 0xa1d2b37f, 0x81bf302a, 0xc42cd9e3, 0x3458f1de, 0xb62c481b, 
	0x0d9e772d, 0x4bfc83f1, 0x5d414fd8, 0xc41c5b3b, 0x4d638c83, 0x80ab67e4, 
	0xd579f17e, 0x3bb234a9, 0x3ec4551e, 0x3fdcd458, 0x2f3b7ac0, 0xfec21f14, 
	0xffdc606f, 0xfa21db35, 0x46f973b1, 0x8e1e80ed, 0xa85c9617, 0xfc707c06, 
	0x7572fb34, 0x8edf630f, 0x03dd1c0a, 0x5669dce7, 0x48ce511a, 0x9f816a74, 
	0xadb3f765, 0x5468fcf0, 0xc02eca60, 0xfdac7f05, 0xa3a02ec9, 0x253cb95f, 
	0x7ffbda09, 0xe2817691, 0xc7e627d9, 0x8df6fce0, 0xfa737761, 0x5f05cb2b, 
	0xf403be64, 0x73a275ba, 0xf8e7e62d, 0x5685d963, 0x717507f4, 0x81cfdd7f, 
	0x8bf40fae, 0xfd0676f7, 0xd4fcbaff, 0xe8bd71d6, 0x9af7dc0e, 0xeb079fa0, 
	0xfe7dd823, 0x5e2fbb08, 0x91367dd8, 0xec21d637, 0x7dda1b3e, 0xbd73d733, 
	0x77f0aab2, 0xafbb726f, 0x03c443b1, 0x5ff35f28, 0x76116c66, 0x9a17969f, 
	0x977df637, 0xad8de791, 0x5385e3d3, 0xa0514e29, 0xdff77ddb, 0x1f7681d1, 
	0x8078c73e, 0x52ceaf3e, 0xa3f24fd5, 0x1873c7ea, 0xe16789c8, 0xe09aec79, 
	0x3f2e9f7a, 0xf3e31db0, 0xabc7262e, 0x99f318bb, 0xff487bd8, 0xe530390e, 
	0x4fb803d1, 0x33f471ea, 0x8e07356f, 0xbe0f4aed, 0x58f315b7, 0xe396fc60, 
	0x012c63dd, 0x8fa87fce, 0xf3925d1c, 0xf1d605a6, 0x9c2ff216, 0x31bb0ae3, 
	0x3ffd02cf, 0x5ad960f9, 0x0537e819, 0x28f91a76, 0x1ab0e817, 0xfd4573ea, 
	0x6ad7982e, 0x5104f798, 0x6fbf4acf, 0x88f3cad9, 0x06bdacf7, 0xf0e3c2f4, 
	0x9f3c257c, 0x0e81cf8a, 0x38f68bcf, 0x89379e2e, 0x09c43629, 0x8e49d7d0, 
	0x11eb8c29, 0xf2c93515, 0x8bf39416, 0xe98663af, 0x3f84f728, 0x1ce7f059, 
	0x2d6b67e0, 0x84e7fc1b, 0xea2ade33, 0x4ae39576, 0x43bd4862, 0xc82b5956, 
	0xdeec9f31, 0xec1e27bc, 0x6862b329, 0x86f7fd05, 0xb1a5d369, 0x78dcf1db, 
	0x8f4cdce9, 0xe054f255, 0x136aaac3, 0x40fb979d, 0xe1b29107, 0x4a7e07b0, 
	0xd4057a72, 0x5575801f, 0x81e5f7a9, 0x986b64c8, 0x093d5d35, 0x496c0c83, 
	0x4f3e03fb, 0x05630165, 0x12fdc38e, 0x34a4c79d, 0x9991505c, 0x3efa6fdb, 
	0x71e3ac54, 0xce3acf72, 0x8701cc57, 0x4d64f50f, 0x52973926, 0x897ed76f, 
	0x6f8eeae7, 0x7df788aa, 0xf75f9066, 0x544a7d02, 0x3c1314d6, 0xfd271707, 
	0x56fb8fc8, 0x17595d55, 0xa4cf7283, 0x7eff90d8, 0x079f96b2, 0x8cef0edd, 
	0x2fd0f253, 0x8722b9d2, 0x198a8bf4, 0xf14392f3, 0xf80e33a7, 0x7db05f6d, 
	0xe3c9f655, 0x3e41ed0d, 0xf24acaae, 0xfe2fcc33, 0x580b8027, 0xaaedc547, 
	0x1fd71f7f, 0xd4d15dfd, 0x9be6077f, 0x6f68ff50, 0xef0fce94, 0x71e2e0bf, 
	0xa545978a, 0xf7aeb1fa, 0x433ec9eb, 0x5e6676fd, 0xf185ee3c, 0xfd67a53c, 
	0x879c1acc, 0x83bcb327, 0xe3e04f9e, 0x1d2a6676, 0x055ea0fb, 0x8d3526e7, 
	0xdfed13af, 0x9214eaca, 0xeff79d23, 0xa540f8a1, 0xb11de4a2, 0x3519e7f2, 
	0x20f73f62, 0xefff013e, 0xb4c3ee09, 0x82ae3cb5, 0x9ec7ee25, 0x49e37f9f, 
	0x7f7da9c4, 0x3f42aa8d, 0x1dfc5026, 0x5e20ec44, 0xefc20bb1, 0x821bdcbc, 
	0x3c4eb767, 0x0dad96b5, 0x7e2458e2, 0xe56780cd, 0xf17dce30, 0xdd768fcc, 
	0x62d92ede, 0x59c7f781, 0x02b63b98, 0xda4f77fb, 0x4d7100bd, 0xdfe5fdad, 
	0x05ba1f04, 0xf907765f, 0x17d0f891, 0x1f9d3fe4, 0x8202cf89, 0x0f827d0f, 
	0xd50f90fb, 0x8a171057, 0x880981cc, 0xdee437cb, 0xf94b1e5d, 0x8dcdea56, 
	0xf08f31c7, 0x7cf2d6df, 0x34379e48, 0x6d3bca25, 0x6e63cc25, 0x6acb7794, 
	0x54b9d768, 0x87ef98b6, 0xae2de052, 0x4ab1ed0f, 0x3cf5b758, 0x196b75c7, 
	0xa3d603a7, 0x10f8f2d7, 0x90871e68, 0x3f57c00e, 0xb17d016e, 0x6e302d33, 
	0x6650e3eb, 0x7efb9607, 0xeab26506, 0x8d2cf3dc, 0x80e226fb, 0x3cfcf8ff, 
	0x8f3af1d4, 0xd5311c71, 0x73989c72, 0x47faa64c, 0x400f3b80, 0xfcf151fd, 
	0x21dd443f, 0x23f615f6, 0xd3ec3cef, 0x7dfbf03b, 0x7d651768, 0x41f4f29d, 
	0x7dc5c8cf, 0x64f15cea, 0xe908b4ae, 0x0bf1dcab, 0xf71d1f6e, 0xfe1e8015, 
	0xdf62a7e0, 0xe92ce998, 0x1ce99a63, 0x69fa6a95, 0xbd18bf2a, 0xd81f5220, 
	0xdd2fcf29, 0xb8c1f7c1, 0x2828bb83, 0x33cf1baf, 0xd55589ea, 0x19bcea0b, 
	0x54fe8ea2, 0x9d1d797b, 0x199a9327, 0x3c8c57ea, 0x743f7ac7, 0x9c854f9e, 
	0x9e7059e7, 0x79e721ed, 0x773a2ee6, 0xf3c4ff55, 0x576eaa78, 0xacf3f10e, 
	0x85f2ea1c, 0xe68f3b8e, 0x5543e3a1, 0x5c4199ee, 0xbe5b1c20, 0xaafc6c20, 
	0x0dc793cc, 0x6654e321, 0x838f957f, 0xaf7e1be7, 0xd8477e5c, 0x3cccaef9, 
	0x104f9fcc, 0x5c04c8f3, 0xc66fba81, 0xfeea7f2e, 0x12aef9e0, 0xee3a46f9, 
	0x44ffe3e9, 0x778e9bf0, 0xfc39c557, 0x3e907cfd, 0x87205b84, 0xf65d713b, 
	0xc4e9eba1, 0xd387b4f5, 0x7590d1ef, 0xeb45b8e9, 0x7aba080a, 0x7c257483, 
	0x85f48f3c, 0x7ae37575, 0x86dacf01, 0x613db3c3, 0xf0aaddeb, 0x63355ff3, 
	0xf019e117, 0x0389a2c3, 0xbd42df5c, 0xea9c2460, 0xf10e5e46, 0xb2b1af8b, 
	0xaed0d474, 0x1dddc5ff, 0x5465c84c, 0x753faf0e, 0xcc34f6df, 0xe3cb5dcb, 
	0x4ea7739c, 0xed0d949b, 0xe3bb38a6, 0xee0bdf71, 0x9cf1514f, 0x71c75f2d, 
	0xdbf5e0ab, 0xf6c0df48, 0xff5fe7a8, 0x8f7ed7f3, 0xb07badf4, 0x195b1d72, 
	0xac8f6f94, 0xb9d07915, 0x91ff7a36, 0x2f96d7b5, 0x6dc1f39e, 0xf24f3879, 
	0x3abac2cb, 0xc8d7d015, 0xbb21687e, 0x656fe73e, 0x1ea1b719, 0xcf1928af, 
	0xa4bfd0fb, 0x97fa8664, 0xd1760aaa, 0x58c75efe, 0x2ebfea26, 0xbe7a40d9, 
	0x12ec1327, 0x56454ac0, 0xd36f28b2, 0x2db5e4ae, 0x30f27ea2, 0xa033d49f, 
	0x71547c50, 0x0e3c6d19, 0x914c97f3, 0x1a159527, 0x617f815f, 0xaa661571, 
	0x5ff88c3e, 0x44cc68e2, 0x5b33bdfb, 0xf77da3f1, 0x30efda08, 0x15f9cd8f, 
	0x673fa2b7, 0xe28923bb, 0x7be315e4, 0xdc16f96d, 0xe4951cef, 0x6a2fde15, 
	0xa89f7a19, 0xd3df96bb, 0x7f396a50, 0xbf08d5f7, 0xb26fee94, 0x33cf0dcf, 
	0x4bd4e3d0, 0x5e60f3f9, 0xb6f9d803, 0xb9c0bf10, 0x2017e425, 0xe7f0387f, 
	0xee3cb575, 0x92a2b9d2, 0x8a7513ee, 0x119d44fb, 0x3dfa08f9, 0x343fba22, 
	0xf294f08b, 0xfc111e13, 0x97e545fa, 0xde169c53, 0x6d2fe1bf, 0x6611ea32, 
	0x36f21827, 0x0682e78c, 0x71c8fefc, 0xd1f3d465, 0xae291e5e, 0xcacef85c, 
	0x9d3eb865, 0xf6c01fff, 0x9d5f506b, 0xe7e243b6, 0x1c818ba2, 0x8b5a709d, 
	0xcf19fe46, 0xaf50994e, 0x8e39016b, 0x05896cf3, 0x870890bc, 0x1b00eb58, 
	0xf77a07fc, 0xb9c4bbb3, 0xf2a1b374, 0x1738ab65, 0xf72ca2cc, 0x2a9d7ae1, 
	0xed91bdd9, 0xdcde80aa, 0xf1e5ad9f, 0x7bef7ff8, 0xedffff18, 0xbaffb17a, 
	0x28b6bb3f, 0xf8e8dfdc, 0xcc4fda27, 0x8e79c1bf, 0x201c3f28, 0x643f483f, 
	0x51f950b6, 0x7948f889, 0xaf8d8a4c, 0xed73f788, 0xfa1343f2, 0x930fe6a0, 
	0x1f900e1f, 0x47e44307, 0xf930d9e9, 0xaebb7951, 0xabf1f227, 0xeade3972, 
	0x27e4b4e3, 0xacbc421d, 0xdb38e5ca, 0x21f27b72, 0xf3e8d38c, 0xf905c96a, 
	0x7e5436d1, 0x1f944678, 0xbd57cf0a, 0xa4a8fcaa, 0x87d247f9, 0xf90cff7e, 
	0x6f7a895a, 0xe7c1fb48, 0x948af411, 0x0439410b, 0x23d2327a, 0x9e985cea, 
	0xe428595c, 0x3790814d, 0xe5c24ba5, 0xe4e8c168, 0xb910c54a, 0x2d3fa832, 
	0x3e7d73f7, 0x6bf71f73, 0x5e85fa65, 0x7c165a97, 0x5389d6ff, 0x855e63d6, 
	0x5d930fae, 0xefa21d1f, 0xf3fe68fe, 0xe7c7cff7, 0x04fd1501, 0xf24e7c91, 
	0xbdeb9ca8, 0xd4a82786, 0xb9c4978c, 0x6d9cf384, 0x0a6972e7, 0x06b8a3c8, 
	0x9f10ff2c, 0xf17a48dd, 0xde8376bf, 0xb0919058, 0xe29abdda, 0x0ade7978, 
	0xa1b0e3ca, 0xbd71475e, 0x8e4748fd, 0x796b4757, 0x6ae006be, 0x3af7c607, 
	0x31b61c67, 0xf0b1cbca, 0x8be832f8, 0xad0ec1af, 0x0fd77683, 0xbf279f1f, 
	0xf2d262ad, 0xed3cbf10, 0x5dfa1e52, 0x3d7fd664, 0x7c60c5e5, 0xb4e74dde, 
	0x9d06e303, 0xbfb2de42, 0x3cabf0ef, 0xec7ae8a9, 0xa86e506f, 0xff1173a5, 
	0xb681b974, 0xc61575ab, 0x847dcff7, 0xe77df378, 0x18efca19, 0x17d6f7f4, 
	0x73eb4c91, 0x1bdf8517, 0xc5bdfdd5, 0xb171e1c5, 0x0e11afae, 0x3ba59aa4, 
	0xdef4e51e, 0x7bf419b5, 0x0fa518df, 0x75df6ff5, 0xc7be8581, 0xf58f74b1, 
	0xd2f9bf03, 0x83c50c03, 0x434d872f, 0xa297dc7d, 0xbd436cc6, 0xb26a2beb, 
	0x40cb07af, 0x7f6c11cc, 0xa56d2287, 0x8dc3b4fe, 0x8c14d22f, 0xbc908eb4, 
	0xb88bc460, 0x64ac2b85, 0x9915587f, 0x63b69fd7, 0x15c2cc7d, 0xb7ce2867, 
	0x1004bf30, 0x88f1e996, 0xcdf98584, 0xe7a5cf98, 0xbdbb4325, 0x6bb53b52, 
	0xb012f7c0, 0x88d5ed4e, 0x3f7e653c, 0xa7c2cc66, 0x57ede29f, 0xa1ede4ec, 
	0x7f1215de, 0xd32efbc0, 0xf1e1be69, 0xd8d52883, 0x73f7f42a, 0x90e61efc, 
	0xdcfd997b, 0x80793c1f, 0x206b27d7, 0xf5eb7daf, 0x7ec5643c, 0x9a12e28a, 
	0x4597e49d, 0x5d90b5b5, 0x807f92a0, 0xdff425ec, 0xc323e60c, 0xf8d0db73, 
	0x5173f903, 0x69cb38ee, 0x01f791fe, 0x4cb63f28, 0xa376cbe4, 0x41f1965d, 
	0x6565d90d, 0x0b2d562b, 0xbf04cbb1, 0xbeb49c5f, 0xfc2652c3, 0xeefc0a3a, 
	0x00b3abac, 0x56b9fffe, 0x785b21e4, 0x79fa065e, 0xbfd0d710, 0x30617943, 
	0xb784b53f, 0xdfd0d367, 0xe4f5ddf3, 0x7b2a89ef, 0x7de78f9f, 0x0437f560, 
	0xf909979e, 0x7950f2f0, 0x3ea3e382, 0xe77289d8, 0x0fbe0860, 0xe1fc5f27, 
	0xffe686fe, 0x94a5f209, 0xf270eee3, 0x77ff9f05, 0xc03197c9, 0x8d07a8a7, 
	0xa8be6724, 0xd667bafc, 0xf32271f1, 0xdaf3fceb, 0xaabf48fc, 0xe02e53fb, 
	0x23f4a03a, 0x3818547f, 0xdf424c7d, 0x2ff510fc, 0x8799179e, 0xf08753fe, 
	0x6179cc6f, 0xcff7b537, 0x403a224c, 0x55eb0179, 0x014fb0b9, 0x26fc9e7c, 
	0xeb1ce7d6, 0x773f21ce, 0x5abf9b69, 0x2755e3e1, 0x62dee904, 0x3d22dc04, 
	0x8efafb4d, 0xfbacc3e3, 0xb3ad1454, 0xaf8d3e30, 0x7aa6e9d3, 0x42455bfd, 
	0xb7e557cf, 0xefeba1d4, 0xfe0ac3b2, 0x55f5c2ca, 0x762389dc, 0xd43aa4e9, 
	0x356ac98f, 0x0b83ee8d, 0x9fa0e67f, 0xc4594def, 0xbda8a2a7, 0xd41ef301, 
	0x77be7ea1, 0xf7f4be44, 0x778c55e1, 0xb98b39f7, 0x40f42f9e, 0x827c8326, 
	0xf183bdf9, 0x839b8a70, 0xfe71823c, 0x75802603, 0xc887738a, 0x7f185997, 
	0x8f1210d8, 0x7a2f908f, 0x878f5e3c, 0x8f7d7c53, 0x179fbf88, 0xa86978f1, 
	0x176c1a1c, 0x2a9ec8c7, 0x6d79678e, 0x7df3a1de, 0x8ff40d3a, 0xe477a47d, 
	0x0f5a3de1, 0x21ac31c6, 0x9ae3d0f3, 0x5e62c5d5, 0xeefae1c5, 0x72b0ef3e, 
	0x1c8af36e, 0xd457f7f2, 0xb6eb79ea, 0x0af2fcb0, 0xcc1e4f91, 0xde45575b, 
	0xeb794aba, 0x439f9007, 0x66abd6f2, 0xcaeb79e8, 0x89df8a61, 0x3e60873c, 
	0x8cdc233c, 0xed2acbb4, 0x175bcca3, 0xad4d5a76, 0xfcceb79e, 0x79a181ad, 
	0x181315eb, 0x2c57ade5, 0xbd21b1ec, 0x87dce05a, 0x4cb3ade7, 0x888f3f3c, 
	0x22edf5bc, 0x4bb7422f, 0xca461d2b, 0x279c8ef7, 0x337fb3e5, 0x3edd7f24, 
	0x0df9d877, 0x48daddd2, 0x712d4079, 0xa15a67ed, 0x6fd5cdbf, 0x1c7f683f, 
	0x17b052f5, 0x494e29ab, 0xfdfea2f6, 0x9e7cca89, 0x5f995ebf, 0xf942736e, 
	0x1537d024, 0x9df8b4fd, 0xf3433d82, 0x9566abd7, 0xfafe61e7, 0xab87a01c, 
	0x9407ec5f, 0xfbe5ad5f, 0xfbafe7a2, 0xf5fcf216, 0xe53e6516, 0xea894faf, 
	0x9fcaf5fe, 0xf8ca9ca1, 0x015b9ab7, 0x32b8ff37, 0x48a7f10f, 0xea2760e0, 
	0x003fe47b, 0xbc71f19c, 0xabad7cc1, 0x7ae287df, 0x0fbee7c6, 0x7eddee25, 
	0xfca1f751, 0xf1212fc8, 0x842fd245, 0x43efc1de, 0xafe724a9, 0x1f50ff55, 
	0x7e8b543c, 0x21ebabd0, 0x3fdc6bd2, 0x95bbf25c, 0xd67e60af, 0xfbd0da91, 
	0x88b65ac2, 0xa1bc8bd3, 0xa7255129, 0xbff3fb79, 0xcc33775d, 0xf709ef0b, 
	0xce96f506, 0x31de4a6d, 0x1583fa2b, 0x7b40f3d7, 0x5dfe7ad7, 0x4e1f3d0f, 
	0x6017f3c7, 0xdd7133dd, 0x2371f911, 0xfb61c5e5, 0xc8e2f2e1, 0xf220b81e, 
	0xd9189ee2, 0xb9fe402e, 0x07db9fad, 0xdc59cf74, 0xc81c2093, 0x5542e20e, 
	0x85db9c26, 0x171ff7c0, 0x49ef43fb, 0x788ad694, 0xb127b8a1, 0x7c449edd, 
	0x892b39d5, 0x3fee83f0, 0x047b8b44, 0x1fa0c728, 0x73d0e175, 0xa6f1f15a, 
	0x83117bb0, 0x7df855e7, 0x6792bf74, 0xe4d71c85, 0x62823f44, 0x74af7bc3, 
	0x17fcf04e, 0x6d24db96, 0xf3a6b9e8, 0xc478f303, 0x0e6f2591, 0xeec3fcd0, 
	0x9dbe1043, 0xa4cd1c27, 0xf31116fb, 0xb8f3b16a, 0xedf0d5e6, 0x4a0e803f, 
	0x0d9be10d, 0xa91530fd, 0xfbfe0250, 0xcf0927ec, 0xdd9e052a, 0x7d267481, 
	0xfc8cf000, 0x7d5f5cf6, 0x30e39c5c, 0x941fd5bd, 0xe7bb9de7, 0x11dd93c7, 
	0xef38c7a9, 0xf6ee7aa0, 0x0c7a6129, 0xafd0adfa, 0x51b72834, 0x05e887ae, 
	0xe80e425d, 0xa02d3df2, 0x55e3a1ca, 0x61ee78e1, 0x27adebc6, 0xa88cd6ff, 
	0x195faa5c, 0x6e3e2dc4, 0x61c3acd5, 0x5e2866e3, 0xf148ffa2, 0xa4f3e9c6, 
	0xe2871c34, 0x226fc83b, 0x247e88be, 0x7c60a2ef, 0xa3d74067, 0x1e30df10, 
	0xae04c71c, 0x660a7c89, 0x4a9af49f, 0xdfa130b8, 0x1c4fbf4c, 0xa89b52a0, 
	0xed273b71, 0xd273b714, 0x9a439c78, 0x3934f880, 0x72809b4a, 0x73e02d1e, 
	0x1ee30654, 0x7e44ddba, 0x89328354, 0x1b3e45c7, 0xf81bdcb7, 0xdc746bf7, 
	0x96e6b19a, 0xcfd09909, 0xe44552ec, 0x42702041, 0x15d7a9dd, 0x94a1d51a, 
	0x3afe9018, 0xcc2c580e, 0x33107940, 0xf1ed0954, 0xfd0f7828, 0x8f6826bc, 
	0xb4bb347c, 0xb831e796, 0xf2e91e78, 0xf20dc2b4, 0xfc57ec1a, 0xd67ae0ee, 
	0x01b140e4, 0x40b7c9f1, 0x624efa75, 0x96c06019, 0xffbb1760, 0xe5ed0f97, 
	0x75b680a2, 0x3cc5d912, 0x0cc95c6e, 0x552c655b, 0x3ec33fc7, 0x7e06d6fa, 
	0xbfc82cf2, 0x5ca6b2b1, 0x08d491a1, 0x61bcc1f9, 0xdeba4c79, 0xcf0e5677, 
	0xba355a63, 0x8476263c, 0x921f9869, 0xde52b768, 0xaee79152, 0xc3bb840d, 
	0x1f01c7e5, 0xce71142c, 0x3f3bddab, 0x3dc781b0, 0xc92accfb, 0xf487fc79, 
	0xf74df69c, 0xff03b406, 0xffb5e96f, 0xb273746d, 0x17fe31d7, 0x1bc3dba4, 
	0x00a5ce50, 0x306f34c1, 0xdfa7509f, 0x30b5e8d5, 0xf84bb94a, 0xf6dbde43, 
	0x3ae37fe2, 0x78eb911c, 0xa47ff694, 0xff768c75, 0x72e06d97, 0xf16165ca, 
	0x21c397e8, 0x80367f11, 0xd12e947c, 0x2fd1a7ef, 0x9dbbf307, 0x39f64bbe, 
	0x4be3fbbf, 0x87f08a67, 0xb647184b, 0x9f50acc3, 0xc6d3785c, 0xa3e40492, 
	0xf586cc63, 0xdd798a1f, 0xad01f9ee, 0x65de34d3, 0x2d7e8348, 0xb76d8a51, 
	0xb15f943a, 0xa8779e1f, 0xedde1e50, 0xf9f8179e, 0x4ed8a7d8, 0x87af299b, 
	0xef9108e2, 0xba916ea5, 0x66152f09, 0x74c0f3d2, 0x7e9c43bc, 0x0ff7036f, 
	0x0959d2db, 0x5629f5da, 0x02b31ed6, 0xf7db8c4a, 0xdea79f05, 0xdcf8bcc8, 
	0x5bd70e69, 0x886fe7f4, 0x81f9e8f5, 0xf1cd2717, 0x5d903ca2, 0xfa2ff90a, 
	0x55ba0792, 0xd6b29407, 0x5587140d, 0x9bdf4428, 0x906ecf8a, 0x057d1d60, 
	0x3f81b9e2, 0xf3e309c7, 0xbcf41b46, 0x8894e412, 0xad9be38b, 0x22eb7fa2, 
	0xea53974c, 0xbb1832da, 0xfd81e620, 0xfbf98bab, 0xb8e34768, 0x12cc2d80, 
	0x9df848a7, 0x2f8a9b8c, 0xcbe8f9d0, 0x0c8ef185, 0x0ad92f1d, 0x74e72a74, 
	0xfc2dff40, 0x097111bb, 0xe3f46eea, 0x674b3702, 0xbdffd219, 0xaeae3c0d, 
	0x8ecc5f90, 0x828b3ef9, 0xf9e450fb, 0x711fdf33, 0xf04f5a2e, 0xe9f63173, 
	0x34e98280, 0xab64fb91, 0x30bbe264, 0x642fbe30, 0xc18aec9f, 0x17ec5e77, 
	0x2361bff4, 0x05d4b3c7, 0x792167c0, 0x65643385, 0x09e51742, 0xfe91132a, 
	0xcf74b5f7, 0x701238c4, 0x879f5ea5, 0xcaabc8fe, 0x9a3ebbc5, 0x86f9e0e0, 
	0x3fbfa4d7, 0x7f9751bd, 0x7a00f9e1, 0x959c769c, 0x030bc3fb, 0xa15ba777, 
	0xf23697fd, 0xe2854bfb, 0x47d612fe, 0xa30bddf7, 0xd76bdf81, 0x92fee20c, 
	0x29b1e797, 0x6db1e612, 0xc0f9c8d9, 0x27738df4, 0xf82d8f30, 0xa3630bdd, 
	0x38b193ba, 0x2e85eefc, 0x73c1bd7f, 0xbfca5a6c, 0x6369b17b, 0x2c2f77f8, 
	0xbc5e28b7, 0xb4ca679f, 0x0d8f317a, 0x363c8b9f, 0xca5c979a, 0x4c6eb3f0, 
	0x0e6c7d9e, 0xe56c0858, 0x363cf0c6, 0x617dccf3, 0x9e7a6c79, 0xc31bcbd9, 
	0x362accf3, 0xd99e767e, 0xf3c31bbd, 0xf68996cc, 0x8d829ea5, 0x6d52df94, 
	0xa564efa6, 0xe637587a, 0x8b848c0f, 0x8dfb1e7a, 0xfe748f82, 0xf58ff3d4, 
	0x5be8acbc, 0x65e6c3dc, 0x3b32a725, 0x39a965ea, 0x1eaee16c, 0x25f335c0, 
	0x11e81b75, 0xc2d4532e, 0x3f507b47, 0x27bba80b, 0xdcab5e61, 0x86e297ba, 
	0xa1b27f60, 0xb439f4e3, 0x20879106, 0xe3a1e6c9, 0x3933f4ea, 0x35c9bdf9, 
	0x51d38afb, 0x3efc1ac7, 0xa079e002, 0x9a9cec9c, 0x155027b2, 0x0eb1d295, 
	0xb3bbf7bf, 0x323bce87, 0xf582ea3e, 0x3a3e268f, 0xe6c0cf34, 0x60cf2e1d, 
	0x5ca7f406, 0x20cf261e, 0x02794ad3, 0xe5e782df, 0x033cc135, 0xad7a8f6c, 
	0x5230679e, 0x78a477dc, 0x319dd82f, 0xfdd02fdc, 0x613f6b9f, 0xd0f3ceac, 
	0x6e979246, 0x8bdf44c5, 0x613628b4, 0xfa9d93a7, 0x1e3e06e1, 0xea035dc8, 
	0x52fbc1d1, 0x2768a780, 0x31bbaa98, 0x18d81b1e, 0xe848bf71, 0xd8fbc193, 
	0x2927e4ad, 0xf1e64602, 0x685295a9, 0x76164a7c, 0x9fa0dfef, 0x46576489, 
	0x253e3179, 0xb425bae7, 0x76834d43, 0x0ed09328, 0x3407599d, 0x057ba7e8, 
	0x02bde852, 0xbbe800f3, 0x494f8a1e, 0x76e62fc8, 0x62b7dd2f, 0x01b57f7f, 
	0xa474dff7, 0xd157ee84, 0xa7582dbd, 0x4ca7c7ac, 0xf1465ebd, 0x22218328, 
	0xcd0c653e, 0xa753186b, 0x4f52a7c7, 0x2d467ee2, 0x9f1e1d3d, 0xfbf1742a, 
	0xb8974e08, 0x30e8232f, 0xc5adbdd2, 0xa92e887b, 0xef6f92e6, 0xb7d3fae5, 
	0x9ce88b1b, 0xf0b03e90, 0x96f92606, 0x9859f7e3, 0x8e09fe35, 0xff583e3f, 
	0xdfb91beb, 0x74e6ce5c, 0xbcbcefa3, 0xdf47fb4d, 0x1be79303, 0xf0bd2d62, 
	0xc25ec39e, 0x93fb19aa, 0x90b937c0, 0xe7c3f7df, 0x36fa7c28, 0x2cb3bf72, 
	0x8bde4897, 0x1889fbf8, 0xfb01efbc, 0x6a3da121, 0x124b76ca, 0x96f90f9c, 
	0xaf78b186, 0x7fd64e57, 0x92932fb7, 0x724e4710, 0x38e1a91c, 0x00fc3572, 
	0xcedd699c, 0x1b33cffd, 0xe279fc7e, 0xf75f4a9e, 0xbe7b8c02, 0x21b3c1bf, 
	0xc2ca8768, 0xc133955e, 0x19ff3b4a, 0x3785fcfe, 0xffba5d92, 0xb95799e1, 
	0xf3a01f2f, 0xf6a09a91, 0xcf40d860, 0xe2a2f8bb, 0xbef65d05, 0xc7ddc38d, 
	0x4a972e9f, 0x20bd37a8, 0xf50c8ae4, 0xb74fecd1, 0x7dc8a7c0, 0x497f8592, 
	0x36f2673f, 0x497fa126, 0x6da5fe16, 0xfee2def0, 0x3325fea1, 0xfa4cfbf0, 
	0xfce8df4e, 0xbf1ed84b, 0xbfd435eb, 0xc439e704, 0xb9d234bf, 0xefc8db6e, 
	0x46f9e293, 0xf845a73f, 0xa0e551f9, 0xb88a747b, 0xd8ec290f, 0x7c086859, 
	0x8fb7e214, 0x01d77738, 0x0aeff217, 0x87457ec0, 0x72f3a3dd, 0x3df8777f, 
	0xe79e133a, 0xf88c78f3, 0xf6f44e77, 0x1efd1463, 0xcada931d, 0xf92f9fc8, 
	0x35cf43bc, 0xf309439c, 0x747bf408, 0xf08d7651, 0x801b8f47, 0xafc892c8, 
	0xcc43afaf, 0xf4abb653, 0xfbc1ca3d, 0x1b814e9e, 0x8eeea2d5, 0xff16d3c0, 
	0xff21b8b0, 0x7e84ba71, 0x0f9d36de, 0x4cbcfd06, 0xa05e7ee2, 0x68538c33, 
	0xbe5e9036, 0xb6a6199f, 0x5d155f00, 0x4818f582, 0xfd6d65f5, 0x106fc4bc, 
	0x5f9c4dc9, 0x5247810a, 0xde001f60, 0x00e798d8, 0x4f804d6f, 0x963defd0, 
	0x189744c5, 0xce019358, 0x0595b46d, 0x3f91cf8c, 0xed00dda2, 0xb7df81ef, 
	0x752bfd40, 0x063e7f3c, 0x576839f5, 0xa26aced8, 0x30fa087f, 0xafdd33ee, 
	0x7d456e54, 0x2aed1f39, 0xbbddc71c, 0x8d7e0256, 0xed483813, 0xfde7a6df, 
	0x3dbc5996, 0x9e30b7ea, 0xcc49731a, 0x9b94e517, 0x2c7ec3cd, 0x39406656, 
	0x1e720b9c, 0xf71a35ed, 0xdcbae0b9, 0xbaa6eb63, 0xe3e51e80, 0x7d0a3ae7, 
	0x22867a21, 0xbfbc50ec, 0x78c4f141, 0x1966cf3a, 0x7fa00cf4, 0x406d3b2c, 
	0x7b646c7d, 0x55ee85af, 0x9a3fc0a9, 0x8f7b6461, 0xd34fd1e6, 0x69f68a9d, 
	0x05d385b4, 0xc4b84dfe, 0xe84cefef, 0x1e7dc51b, 0xcbfa0ff6, 0x8ce4fd07, 
	0xf5e59c65, 0x25c9b8c1, 0xe3eccf5e, 0xbccbacf5, 0xd785759e, 0x7d387bb3, 
	0x92a15fb2, 0xf5e59ce5, 0x7d78b79c, 0x9f5e25ca, 0xd20be7d2, 0x9ca3f69b, 
	0xef0f3588, 0xb17ed8b5, 0x43ca5df4, 0x5eb21ffe, 0xbafa9d7d, 0xf8c3a301, 
	0x489038d0, 0x61c968fe, 0x649438a5, 0x38266549, 0x9223c63f, 0xf21d9e66, 
	0xa1a642fe, 0x3902433f, 0xf9f9e128, 0x71154ecb, 0x348a7401, 0x8b7313e4, 
	0xb1bb359d, 0x57343474, 0x6f2a9963, 0x2e5043f9, 0x4db753b1, 0x4efe3e44, 
	0x36f88bb4, 0xd44da5ca, 0x221f84fd, 0xfe83e61f, 0xf5cd7c4c, 0xc63b41e7, 
	0xc27de8c1, 0x76a39421, 0xb3275dfe, 0xfe489d53, 0xbc871693, 0x975dc605, 
	0xe50ea271, 0x6f62dc95, 0xed4d52de, 0x58ef8a26, 0xa47c9e51, 0x8b764c3f, 
	0xf844e4ef, 0xdd9212bd, 0x61e6f90f, 0x098bfdc9, 0xcb7b4a71, 0x950b2829, 
	0xde61678a, 0x1a5b8a89, 0x7da0e7b4, 0x1ba6e212, 0x83f309e7, 0x6739d1e7, 
	0x297fd0eb, 0x2f9a15db, 0xa2e58c7b, 0x539a6b9d, 0xbd00eb9b, 0x71e64a3d, 
	0xcc298e9e, 0x650ed2d9, 0xa409cbae, 0xaf08fcc3, 0x5562ec85, 0x66407bc6, 
	0xf5b7528b, 0x342bac36, 0x697db32f, 0x8c69d6dd, 0xf1e3a95d, 0xf5c3b324, 
	0xe20736d0, 0x796752b6, 0x75c3b78d, 0x6bfe555d, 0xf6fd53f7, 0xf7eba717, 
	0xb98425c5, 0x33bc744f, 0x84be1a05, 0x4ebc891d, 0x288d4bb0, 0xc45c702f, 
	0xee279c6d, 0x10db8e07, 0x8eeb3f32, 0xb8752901, 0x689207f1, 0x59df7d3c, 
	0x6fd246eb, 0xdc70fe3e, 0x511fea67, 0x50e5565f, 0x0ecba6bd, 0xdf895833, 
	0x33f7e3d9, 0x3f262151, 0xbd232b76, 0x71ea7358, 0x3fdf853c, 0xf03be265, 
	0x904efb49, 0xc2d71afc, 0xffa013fd, 0x847c80f5, 0x76a5cdcd, 0xbb7edca9, 
	0x7217d3e7, 0x7632b7b3, 0x17bc7329, 0xc4e747db, 0xc135cbd4, 0xa175c2fd, 
	0x07f7d63c, 0x8aebc6e9, 0xe35ffd11, 0x28bf85ea, 0xebabde82, 0xb1d8dd39, 
	0x96f7e97b, 0xebe18d7f, 0x4754fa16, 0xaba75ce9, 0x3348e40b, 0x2c7547f7, 
	0xca13ba81, 0xb57bfe2a, 0x0a45fb89, 0xd105ac95, 0x351d27c0, 0x477bf475, 
	0xb76f1d43, 0x129fd45b, 0xbce3aef5, 0x6794427e, 0xdfdff38f, 0xf5d9f5e1, 
	0xd1d1afdc, 0xd7d509ff, 0x91e31975, 0xbdbbf6ef, 0x38f815b2, 0x03ef795f, 
	0x3a80638c, 0x9e8236ee, 0x6ea71f51, 0x07f7e955, 0x0fefe0ce, 0x07692d7c, 
	0x257cbb9e, 0xcb04850f, 0x8b5bde55, 0xd2a15e76, 0x5cf98951, 0x0c592d45, 
	0x4af9fcfd, 0xc4e645c7, 0xfccd79e7, 0xe783b439, 0x39baefeb, 0x07604bfe, 
	0x3ca4bfde, 0xaf81ef0e, 0x28baf214, 0x2f30914d, 0xab1410be, 0xe1872831, 
	0x85cff1dd, 0xe2c9cdd8, 0x7bca31bb, 0x83da12b3, 0x3f0a17bf, 0x585f5e9e, 
	0xbd0fedcf, 0xa5bfec1c, 0x03b11b31, 0x4cbf477f, 0xf48525d1, 0x521bd458, 
	0x07f44456, 0x92f9a0fa, 0x6cfa4b14, 0xbc79f5a6, 0xd4ba6327, 0x2b71831d, 
	0xbc95ecb3, 0x714c2f20, 0x5730e7c0, 0x24bb7e73, 0xe6b29e81, 0x78ed99d0, 
	0x79d46bfe, 0xa98fa40e, 0xf3163bcf, 0xd0c94d0d, 0x5bc4102e, 0x8879a460, 
	0xbb7ce6a3, 0xf8493a47, 0x3e615ac4, 0xd92ad11b, 0xeb17d410, 0x16e23e30, 
	0x62fc0ffc, 0xc971cdfa, 0xca69df8e, 0xbe23d771, 0x479b9dd4, 0x5f9898f7, 
	0xc0e78319, 0x59203c5c, 0x160ed11b, 0x3798b47a, 0x11356fc8, 0x4871d9e8, 
	0xbe122672, 0x7ff0632a, 0x3a859e3b, 0xe18ce38f, 0xbe850201, 0xb4f30987, 
	0x7ce25d27, 0x4c7dfa1e, 0x7efa73e4, 0xcb6df026, 0x0f79c1cb, 0x16f517c1, 
	0x83edffaa, 0xf373e202, 0xf717b72c, 0xbebecbb9, 0x118bfc9e, 0x54433bf1, 
	0x037888c0, 0xd71baee7, 0x51a9b4b3, 0x66809ef2, 0x075a064d, 0x79f37f43, 
	0x1e60fe71, 0x910efacb, 0x63dcd9df, 0xf40c9b18, 0x3b9faad9, 0x65709f2d, 
	0xfb338eaf, 0xa63f54dc, 0x99c30b4c, 0x2d4a5c41, 0x71d37c21, 0xc0bd68e7, 
	0xe63f813f, 0x2c963f77, 0x689e20de, 0x01b3b70a, 0x47140df7, 0xe5f9fbd1, 
	0x78c186bc, 0x4867fc2f, 0x55df4c5c, 0x82708101, 0xba1638f2, 0xac9e9156, 
	0xf4a4ef88, 0x3b42ac17, 0xa24ee940, 0x8aefc1f6, 0x70bcf0f4, 0xaf8e11d3, 
	0xaf16ea05, 0xa307283d, 0xfa0333e6, 0xfc71eec1, 0x172eb246, 0x107910f4, 
	0x3883e7ad, 0x0e0231d4, 0xa15f73b1, 0x58a97cba, 0xfad0578f, 0x77987a75, 
	0xdb516fb6, 0xb84ff883, 0x3d06fb4f, 0x3d46ee02, 0xfdf84aa7, 0x38537301, 
	0x3edd821e, 0xc6837116, 0xaeb9432f, 0xbd78fd52, 0x391657b8, 0xa90bc58f, 
	0x0d2cc6be, 0x7dc18f3b, 0xad90f310, 0x6f287ac7, 0x0ccba74b, 0xeaa7cf3e, 
	0xdae37ab4, 0x77bdb9e0, 0x20105806, 0x29c6e3cf, 0x854f1e5e, 0x2dfec27d, 
	0xd3f744aa, 0x83e4aaad, 0xa29b8e7d, 0x220c573f, 0x89e481ef, 0x412f69c5, 
	0xbed21adc, 0x0cefda19, 0xb6716efe, 0x38bb6197, 0x8fdc8df3, 0xee48ed8b, 
	0xc927c4a8, 0x24f2e1bf, 0x6a21fda4, 0x3ba4a5bf, 0x4c1f7db4, 0x8a2fe297, 
	0xdb05cf88, 0x51f6a45f, 0xd7b58637, 0x676c19d7, 0x880c605f, 0xd6f121e7, 
	0xc52a6931, 0x4a9fa193, 0x3f3c5da3, 0x397bde2f, 0xde855da4, 0x99fcdece, 
	0x7abc9aed, 0x667d4f7f, 0xef59b93b, 0x176a25ef, 0x9b31c741, 0x84c78a55, 
	0x9c5df3ac, 0xc57898ff, 0x8ceb59fb, 0x7e017dc6, 0xaaee331a, 0xbb524eed, 
	0x076b5729, 0x3776c5f4, 0xd93fb55e, 0xaf9aed88, 0xb5365fda, 0xe67caf1b, 
	0x7ee3457e, 0x57a9bb61, 0x7174076b, 0x18d7dd0f, 0x77e19da7, 0xefb447c1, 
	0x4fc42dac, 0xdf6025dd, 0xefb64779, 0xe7d4ace4, 0x768c9f11, 0x4d3dc52b, 
	0x8e628ab2, 0x2cff03ce, 0x767146bb, 0x3358d7fc, 0x71a1fdf4, 0x210f19bb, 
	0x165897ae, 0xe308dc53, 0x7c6f9881, 0x9e2ac00f, 0x8c9edd57, 0x7e387616, 
	0xdded03de, 0x79c3b468, 0xbc52315d, 0xfbe0c592, 0xaa9718d1, 0x7a63fea0, 
	0x5a1ffbe9, 0x2fbf3f4c, 0xebc03b17, 0xbf7d1ab1, 0x453b894f, 0xe2d0325f, 
	0x98faf34e, 0x263ebc73, 0xdf12a540, 0xfdf1ebcb, 0x01d8f9fc, 0x35ab1f5e, 
	0x4a7add51, 0x34f5baa6, 0xe39c27af, 0x950084f5, 0xaf2f624a, 0xe7f3f627, 
	0x9ebc0349, 0x7aa66da4, 0xd51329f2, 0x7af34f93, 0x4f5e39ca, 0xd3dcfa41, 
	0x7a8b90df, 0xa503bdf3, 0x3c0764b9, 0x4b80edce, 0x46e9bf99, 0xdce744ba, 
	0xebc610f9, 0x565fab47, 0xae02343e, 0x7aa7aea7, 0x504349c5, 0xd3c10caf, 
	0x89bc3b2e, 0x5c08bb71, 0xa8cef5d7, 0x801f9cb9, 0x8bf476ee, 0xec657ae8, 
	0xb843d011, 0x13fc84df, 0xae330f30, 0x3469572b, 0xa9173ea2, 0xa5ea0ea7, 
	0x398d1f42, 0xf237b526, 0xb40cd5fd, 0x8b7ee1bf, 0x2a71a57c, 0x9fa853ea, 
	0x667fa918, 0xff4379c6, 0xc7ae3c49, 0x143f7be8, 0xefdf8427, 0xdb77f9bb, 
	0xdcae9e50, 0xf266d5fa, 0x03bfa29f, 0x5bc2a7f4, 0xfef0bbdb, 0x01ade143, 
	0x42efb1f9, 0x71bb5379, 0x8f50cfd7, 0xc3b77bb3, 0x261e85db, 0xe4f077e1, 
	0x07e2ad38, 0xdefbbfdc, 0x0688fc36, 0x6037d346, 0xebc70c3a, 0x895b3ddb, 
	0x697faf8f, 0x8cdc9483, 0x1fd0097a, 0xee80a7ca, 0xfb986718, 0x91c784db, 
	0x927fb54e, 0x12cf882c, 0xf7fe4f9c, 0xf073f424, 0x5333a714, 0x839ba76c, 
	0xbf7a5371, 0x5a679f9f, 0x08f5c2bf, 0x3ddb9c7d, 0xf1ef11df, 0x6f7a2dfc, 
	0x3df1e611, 0xd37a825f, 0xfc7df0f7, 0xd6058b4e, 0x83cc5e71, 0xb71e31f4, 
	0xddbbc7d5, 0x6fe68873, 0x64b773f8, 0x17ef8353, 0xbbfe80a5, 0xc95af487, 
	0xf2fd1bb7, 0x354b58ca, 0xfbdf97ef, 0x9f6d7e86, 0x30604f3f, 0xa9d4c15e, 
	0xf5334e22, 0x53af9732, 0xa79a18b5, 0x9a9514e3, 0x87fe1543, 0x6ed479d6, 
	0x7689c91e, 0x44e50f36, 0x85a65fa8, 0xf7ea3ee2, 0x9f1cb8da, 0x6f85f18a, 
	0xdfdc0c04, 0x9ac99bd0, 0x36e65803, 0x3962f734, 0x41f9ec81, 0x7ff5837f, 
	0xff7a444f, 0x6becec6a, 0xe08c37f4, 0x95cde867, 0xcfd004b7, 0x59d12af0, 
	0xde6ccdee, 0x67ee1bd2, 0x921db640, 0x067a8377, 0xa04dafbe, 0x7f489bbc, 
	0x7d0dea03, 0xd4bd286a, 0xffb857a9, 0x95b3d1c6, 0xa8578eea, 0x8fe19ffc, 
	0xd29ffd82, 0xddb2e50b, 0xb3f479da, 0xfdcddb2c, 0x68d6cb2c, 0x6baf30e7, 
	0x03a81ad9, 0x6855963d, 0xd75e616f, 0xe9c08ab2, 0xfca19303, 0x9bc3c806, 
	0xb6626ca0, 0xb65871ed, 0x12f33fa7, 0x1db22f94, 0xd52c04be, 0x5025fdb7, 
	0x49efcd3e, 0x3dba7b2d, 0x2802df67, 0x1f47b3f7, 0xd97f1b01, 0xc47dec2b, 
	0x04af6589, 0x380fbf92, 0x7aacecb1, 0x3fdcdbf2, 0xa7edbe5d, 0x25187768, 
	0x3227fbfc, 0xc4291dda, 0x4fda1267, 0x7647db12, 0xb01bd907, 0xf30ff1df, 
	0x651eb373, 0x78e20d76, 0x8f68c3e2, 0x6613fa0d, 0xef7df3f1, 0x1d731b87, 
	0xef8f475b, 0x808f0f19, 0x236ec7ef, 0xf9b2c63b, 0xc1bf30ba, 0x97547648, 
	0x195a7a1d, 0x7111f7c4, 0x1ff41ffa, 0x0e837ee8, 0x265e15c3, 0x9dcfe15f, 
	0x3b55d385, 0x9d385b8e, 0x76f50b8f, 0xa7eb6b28, 0xa1bdfc33, 0xaf1f3a7e, 
	0xaa7f3f9e, 0xad7f9e9e, 0x1187faee, 0xbc4e3aff, 0xfb3fdfc8, 0xf1d3b522, 
	0x25dcb227, 0x3fc479ec, 0x8f7e886f, 0x97e8a769, 0x7189d284, 0xe4d8ddba, 
	0xcebda0ff, 0x1deb8ae3, 0x676a5946, 0x2718a384, 0x9393ff59, 0x542f29f3, 
	0x37227dfc, 0xf941993b, 0x3d224c9e, 0x5eff133e, 0xbd7bd015, 0xd8b08bc8, 
	0x790fef41, 0x145bde9f, 0xa0727fec, 0x0c03be98, 0xd08d2aed, 0x49c76eef, 
	0xbe24e4a3, 0xceec7927, 0xf296393f, 0x29e2d95e, 0x70660724, 0x001d913e, 
	0xc4382100, 0x93c0c554, 0xbf62ecba, 0x77cbaa55, 0x175fdd30, 0x31513940, 
	0xda3b13f5, 0xe3b615ad, 0x630b2eed, 0xc93fe365, 0xdcf7859c, 0xe3cefb1c, 
	0xfa8645f3, 0xbd4b941c, 0x2afe7e46, 0x6e5fbbf0, 0x0ca6e79c, 0x6e341dfe, 
	0x1458b4f7, 0xac45ef19, 0xdf30787d, 0xddf387d3, 0xc26f9ae6, 0xca9606dc, 
	0x5315be88, 0xb8c14f56, 0x7f8556f8, 0x6fd6851f, 0x0345efe3, 0xdff4fadf, 
	0x813ee661, 0xfe7e6d87, 0xaecbcf1c, 0xeffc8559, 0x0efd0108, 0x515ef0da, 
	0x6ae21453, 0x67e7838c, 0xaf7be2cb, 0x7d4227a4, 0xbf23036d, 0x78efc309, 
	0x64d77cc0, 0xbbfc1669, 0x3147e40e, 0x3853be62, 0x7ee5f77e, 0x12fa6dea, 
	0xbf91bb10, 0x512afd07, 0xac3907c0, 0xbbf43a3e, 0x35f80d5c, 0xd12b900e, 
	0x7efc7740, 0x80fe5f7e, 0x8efd0e57, 0xbc4fa5e9, 0x34e9c632, 0x6725af7e, 
	0xfbd87d60, 0x328cc739, 0xc7ae8df2, 0xf0194df6, 0x57a14d36, 0x396e91a3, 
	0xf2264ec7, 0x9063567d, 0xe6c739be, 0x87bff365, 0xfaf3c5a4, 0x39fc99c9, 
	0x53ed4b1b, 0xcfe32e9f, 0x7ee2b195, 0x2bfd09a2, 0x9f38638d, 0xab5858c7, 
	0x8bd41d94, 0x3d998b2d, 0xb3fa166a, 0xf40c58f2, 0x71e76853, 0xe69efd2f, 
	0x851c9716, 0xea7941fa, 0x639428bc, 0xc14b4fe8, 0xdff3f5b8, 0xfe93316e, 
	0x912e62cc, 0x7aed7d3e, 0xd5d52f75, 0x64a857b1, 0x8bd21ed6, 0x542beb55, 
	0xbcb384b2, 0xaf16f09e, 0xf5e25e27, 0x4f5e3ec4, 0x49ebccba, 0xb93d7857, 
	0x3566f487, 0x592a15f9, 0x4f5e59ca, 0x15ca0b79, 0x9f1b9adf, 0x78f2e34d, 
	0x9994c545, 0x157fc8d1, 0x422ee753, 0x7e895bdc, 0x47c053c9, 0xe9132576, 
	0x99abb267, 0x6764d8d8, 0x935f4899, 0xbd6d235d, 0xfd0ff80f, 0xc8dcf009, 
	0xee1331db, 0xe56dc56b, 0xdfe87cbe, 0xe112f755, 0xe63a7225, 0x9287324b, 
	0xf890fa4a, 0x57ea757b, 0x7b02aec0, 0x39ce2dca, 0x39e203e5, 0x93fef88c, 
	0x14604f9e, 0x60ca477f, 0x14447ae5, 0x5e2297e6, 0xffd232b4, 0xf7592ed4, 
	0x411c5353, 0xf48d1fcf, 0x24da1c07, 0x3c888dee, 0x4bcc28e2, 0x7911be45, 
	0xe57165bc, 0x5463d22a, 0xf7c820f6, 0xbf71cf65, 0xf13677e0, 0x3ee47def, 
	0x7e136fb4, 0xeb11419f, 0x04e9097f, 0xff54d8e7, 0xf7e8c3d2, 0x1f33ebd6, 
	0x3aea8f7a, 0xdfc65e7d, 0x57699e31, 0xf39d1ea8, 0xe5f2c3fe, 0xec9cffa0, 
	0xe5e8db1c, 0x3e05dfde, 0xc93376b0, 0x977fdd3d, 0x1e20e38e, 0xefd3b729, 
	0x04c6c5cf, 0xabb645fd, 0xf46ab7cb, 0x2a1ceee3, 0xb89b2ce7, 0xc0f3ad9c, 
	0x9477f90a, 0x839b676c, 0x3f46adeb, 0x7f9872fc, 0xff153da1, 0xc129cdae, 
	0x318af93f, 0xfb401adb, 0xc812c8c4, 0x26b46daf, 0x8bed1e80, 0xc23ddfa0, 
	0x66f18aff, 0xc6144efc, 0xbce0639f, 0x1e0324e6, 0x3fedf9e2, 0xce062874, 
	0x8f3104ec, 0x4afb7b1c, 0x3e3d4be4, 0x9fbe2d9d, 0x50702318, 0x9c53678f, 
	0xfcf7ea18, 0x68d5f735, 0xb6ff2fb4, 0x10e8d6ea, 0xa5c60bff, 0x4e3c03a3, 
	0xb27e816d, 0xb87cf136, 0xf4a7a869, 0x59abc487, 0xfa9abc78, 0x578c1f39, 
	0xb17eff53, 0x223bb41e, 0x23ebd6e2, 0xbd2463f8, 0xc2bac0c9, 0x36eba6f4, 
	0x944deb85, 0xd421bd28, 0x9c52aaaf, 0xa4f2fd8e, 0x0b5ef077, 0xdd23e81d, 
	0x1560ff22, 0xf2286fbf, 0xb51f840d, 0xff963bb4, 0x8fdd493d, 0xe52df96a, 
	0x4f22801f, 0xfd191c71, 0x7ea1eda8, 0xbff7ee54, 0xc9751f9a, 0x8fcc7fa6, 
	0x151fa32a, 0xf82ed7f6, 0x8eeed226, 0x7a098e7a, 0xcfd13e71, 0xa8fd1987, 
	0x887e3101, 0xa462b51f, 0x8fc55c79, 0x19be391a, 0xd04ca8fd, 0x2f307ce5, 
	0xfee4ce42, 0x4e0e3d54, 0x78cd987c, 0xe416d89c, 0x3bfc7caf, 0x7baf408f, 
	0x0ea80133, 0xa9e39432, 0xb7ec17a8, 0xc768a9b0, 0x184939e1, 0xeb845f15, 
	0x7d628dd3, 0xa386e243, 0xc647e7f4, 0xcb75f50d, 0xf4c98e73, 0xcfd14ef7, 
	0x9bf9c36f, 0x65b8ffc8, 0x3cff8f13, 0xf4cc10fc, 0x1f7ce0fd, 0x61c6f4af, 
	0x757dda3e, 0x11dfbfe1, 0xcf321f51, 0xc3ed0756, 0xce279c6e, 0xf54b51cb, 
	0xf440507c, 0x359f027b, 0xf9fc6fcf, 0x074f3e05, 0x687f9fec, 0xfdd5f51e, 
	0xe8e3806f, 0x9354b03f, 0xbff740ff, 0x8bcfe60d, 0x81ca27b8, 0xbcd0a89e, 
	0xe7f2856c, 0xbca03d41, 0x6cb3cc6c, 0x4973a72d, 0x88cfdaf9, 0xe7291af3, 
	0xdfdf3c8a, 0x4431f744, 0xac5b2b7e, 0xe661dea8, 0x2cfe9a5d, 0x7f9d17c9, 
	0xdfbf5964, 0xfe05d2c8, 0x3f72b7a7, 0xe96ba886, 0xea8e1f28, 0x5ed28ee3, 
	0x6f74f52d, 0xe3f1df12, 0xf908eb76, 0x6bc9237e, 0xc8afff3d, 0x75f0f3f3, 
	0xb65d61d9, 0x3d9aeba1, 0xedff7196, 0x220ff730, 0xe68d5bef, 0x6f6f153b, 
	0x2b3fbfd2, 0xdca153be, 0x3a5dffab, 0xa1e3ee3b, 0x426ddff4, 0xc74832f9, 
	0xb415fb34, 0x80ece58b, 0xe93263b6, 0xdfe77fcd, 0x76f2d70f, 0x85f294fc, 
	0x6084e803, 0xb3c73be2, 0xbb40ad41, 0x9f6265c8, 0xbeede49c, 0xf718a3be, 
	0x867dfb8d, 0x885fefee, 0xc83a749f, 0x197f3cd9, 0xbdb137f3, 0x58ac01c9, 
	0x65f0f826, 0x39b7bfe4, 0x3663edff, 0xfe402f91, 0x7dee91ab, 0xb6fe7a94, 
	0xdbaee489, 0x2232f3cc, 0x941de9f6, 0xee866b0f, 0x21280c0f, 0x5717fd9f, 
	0x006ebb27, 0x00100422, 0x7ffc20f6, 0x00007004, 0x000000d0, 0x001e2166, 
	0x001e3e9f, 0x001e3f6d, 0x001e409e, 0x001e1dd7, 0x001e8882, 0x001e1f5b, 
	0x001e1f12, 0x001e1f44, 0x001e1ee8, 0x001e2445, 0x001e1f2c, 0x001e648b, 
	0x00000090, 0x0000299b, 0x000028ed, 0x001e2cd6, 0x001e2f9c, 0x001e25bc, 
	0x00022c11, 0x00022c71, 0x00002ad3, 0x00002bd4, 0x00000020, 0x00048658, 
	0x001e8802, 0x00000020, 0x000484a1, 0x001e83f7, 0x00000020, 0x0006094c, 
	0x0006001d, 0x00000020, 0x001e0903, 0x0006005b, 0x00000020, 0x001e1700, 
	0x001e158d, 0x00000020, 0x000a5fc3, 0x000a44bd, 0x00000020, 0x0012414e, 
	0x001240d2, 0x00000060, 0x000c7fa4, 0x000c7916, 0x00127dbc, 0x00127bae, 
	0x000c79f1, 0x000c6d0c, 0x00000020, 0x000c79f1, 0x000c74e8, 0x00000020, 
	0x000c7fcc, 0x000c66da, 0x00000020, 0x00000080, 0x00000000, 0x00000060, 
	0x0001000a, 0x00131208, 0x58cdb22b, 0x00000000, 0x01020258, 0x00400804, 
	0x00000070, 0x00000022, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 
	0x00000000, 0x00001388, 0x00000050, 0xffffffff, 0xffffffff, 0xffffffff, 
	0xffffffff, 0x000000c8, 0x00002800, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 
	0x00000000, 0x00014012, 0xffff0000, 0x00000020, 0x01860000, 0x00000018, 
	0x000000a0, 0xfffe0007, 0x00000fff, 0xc03e00fd, 0x00000ff0, 0x003fffff, 
	0x00000f38, 0x01fc01bf, 0x00000ffe, 0xffffff83, 0x00000fff, 0x00000020, 
	0x803e3fff, 0x00000ff7, 0x00010012, 0x001e113c, 0x0003a1a1, 0x7ded9c78, 
	0xd51c740b, 0xeeabe095, 0xfeaaeeea, 0xa58fa548, 0x6da024b6, 0x6d96a4b7, 
	0x32031840, 0x88497112, 0xc4130658, 0xd990c127, 0xc83205a4, 0x20644bc6, 
	0x96619319, 0x5b96596a, 0x8d84b6fe, 0x32219324, 0x9b270763, 0x98599c78, 
	0x4a648498, 0xe316c1b2, 0x80f1c6b0, 0x84893137, 0x6d33306d, 0x11938322, 
	0xef7b0909, 0xdd54af7d, 0x324f892d, 0x9cf67667, 0xfca073e9, 0x77bd5eaa, 
	0xfbdffddf, 0xf87d2bee, 0x761f87e1, 0x29d8ca3c, 0x2b72624d, 0x158cb963, 
	0xc98c4d1b, 0x1dc56573, 0x9773f065, 0xbb1987b0, 0xcc45e665, 0x9fec64e8, 
	0xbf632f35, 0x3fc7db81, 0xcdffefcf, 0x42a19867, 0x17f5ad7f, 0x7f607757, 
	0x308c6156, 0xc87f82e6, 0x33b632f7, 0x0cf0ee1a, 0xccf4db53, 0xccad9b87, 
	0x1a5df1c0, 0xb0a7ddd3, 0x1c70cebb, 0x3e34c98d, 0xec65661b, 0x8c9ab87d, 
	0xdbce99b7, 0x9879a24c, 0x19af22c2, 0x8a64a970, 0xfac60dfb, 0xc7108034, 
	0x6194bb1d, 0xb87e3fbf, 0x8c6d1990, 0xe66447f5, 0xa426f3e6, 0x295ef4f9, 
	0x6660ebce, 0xc618b199, 0xc208f496, 0x5e55b9b9, 0x79e086ce, 0xe0c46e8b, 
	0xca532f79, 0xae30fd8c, 0x6d9a5d02, 0x82a89fb8, 0x56ffa079, 0x67a48585, 
	0xe5ab5d60, 0xa1145283, 0xa19ff182, 0x10c74b75, 0x3d28c95e, 0x3dba7001, 
	0xe89b65fd, 0x627151b6, 0x1beb633d, 0xbc144637, 0x23e7b7fe, 0x2a6eb87e, 
	0x41ac568c, 0x778416b0, 0x0b56d0cb, 0x5bf96daf, 0x07331f5c, 0x37e83e8c, 
	0x638db18d, 0xc9b7fc6c, 0x5fad67a1, 0x28b1f34d, 0x807d7fac, 0xb8066f65, 
	0x46ca3e77, 0xe99e7ce3, 0xd1f37eb8, 0xc6d3c24a, 0xb8cc5847, 0x75076e0b, 
	0x9847b62f, 0xe1b64de1, 0x8e9a5e7a, 0x1dd06eeb, 0x7c62d9d3, 0xfe22f14f, 
	0xe119e0b3, 0x6c7e6357, 0xcda85923, 0xff1cfd6a, 0x5193b532, 0xd0edcc40, 
	0x800c5804, 0x9f47b163, 0xdc12771e, 0x159be27e, 0x7690fb5b, 0x5edb8af2, 
	0xf69f8062, 0xd84bd8b6, 0x727171cf, 0x23985cfa, 0xf6b1e9a9, 0xc65de157, 
	0xf050fbff, 0xce31b25f, 0xda60d78c, 0x999c71ff, 0xacb5beb8, 0xe7374d76, 
	0xc708f897, 0xe7317c6f, 0x9b7de517, 0x2087be5f, 0xb5f4da8f, 0xd6e88ef8, 
	0xe88bd36c, 0x1f77ca9e, 0x2c7a67cb, 0xabf82236, 0x597f2279, 0xd5fc42fc, 
	0x6ee6f82c, 0xc2974f9a, 0x0e489eb0, 0x92dd87ad, 0xe6c97160, 0xf9abe21f, 
	0xff367c36, 0x271e9434, 0xa452cc38, 0x28d2bb8f, 0x1fccbe23, 0xede3f7d6, 
	0x27b5fdfc, 0x9dd279e1, 0xb197c660, 0x1196e03b, 0xdcd6ea9e, 0xb4a9ef45, 
	0xc7a9950e, 0x59493e00, 0xd77ae2a7, 0x843139ce, 0x4b8d3ce3, 0x3f914d1a, 
	0xcf782781, 0x67826d14, 0xde223c82, 0x49bc6c46, 0xfca26e8a, 0xe20afdc1, 
	0xfde4e613, 0x44f3f032, 0x94d0d610, 0x3e9b3eb2, 0x9b262f84, 0x7ae01fb5, 
	0x89f9d21a, 0x70ca55ed, 0x94ba735c, 0x10c51746, 0x72f4d174, 0x9fce93a2, 
	0xca263cc3, 0x264f35b9, 0x012249dd, 0x71566ffe, 0x1cf13278, 0x6dfadbaf, 
	0xcbb88394, 0xf70bd8a8, 0x2bed571d, 0x6072e2ab, 0x1b3b7d22, 0xb07e900e, 
	0x4e2faef0, 0x136dc3b0, 0x77a4cee1, 0x0c929d26, 0xc80bfef8, 0x7dbfd087, 
	0xf8d83a12, 0x660e8a99, 0x662aff1a, 0xe6c341d9, 0xa9ef5a53, 0xa82e813f, 
	0xe852466f, 0x9c72ccc2, 0xd4f8f887, 0x0b0f4f9f, 0x3ffae3ef, 0xebc64f43, 
	0x5c115bbf, 0x5e69f74f, 0x1ef9c687, 0xa59cbff8, 0x31e89fe0, 0xb61d227d, 
	0x6295afb8, 0x8fe5ffc0, 0x88597bd4, 0xf3f5dde6, 0x0e738236, 0xb4636bae, 
	0x73d70e7d, 0xc13cfcac, 0xdf23946f, 0x8a8746b1, 0x612f2df4, 0x6a8062cb, 
	0x6b60ec97, 0x59eee740, 0xc9aed7ab, 0x5bd2f5b5, 0x379b9712, 0x8a67ae24, 
	0xec62deb3, 0x3177f41c, 0x3036cd7d, 0x07df7083, 0xf2a82ff7, 0xffbc0730, 
	0x39a2d556, 0xf574232d, 0x25bcc0b4, 0xedf54d3b, 0x0a2fde6e, 0x277cb5f6, 
	0xd6def863, 0x72cb438b, 0x07db1872, 0xcfb855f7, 0xc430e0be, 0x56e752fc, 
	0x86e6cac6, 0xb03395b2, 0xb1eacfbe, 0xcae76035, 0x0df9721f, 0x14b7df58, 
	0x7a0130a3, 0x458556f5, 0x94cf40f3, 0xdbc7c6df, 0x834faae3, 0x6e3097fb, 
	0x50b5c015, 0xa1a3f4b2, 0x38c09f22, 0x61d768d9, 0xf8def4dd, 0x9bd7e655, 
	0x44adbd71, 0xd705564e, 0x9e5da2a5, 0x9b3f08cf, 0xa0313bee, 0x723cbf20, 
	0x38c0a7c0, 0x7f9ebe5b, 0xe7b3e95a, 0x3f79f971, 0xe2790ec6, 0x53a2ff70, 
	0xd6179666, 0x61cf8051, 0x344bda9c, 0xee177e49, 0x063ee98f, 0x67a1abcf, 
	0x1eb869db, 0x74061497, 0x61e7bab9, 0x5dfa0145, 0x61407aba, 0x02fdef40, 
	0x683ec8ff, 0x993ab717, 0xb3e346d9, 0x21c104e2, 0xa261b5fb, 0xe4827177, 
	0x004e28db, 0x7bc46bde, 0xd501b117, 0x208dcf41, 0xa60cebf2, 0xded0edab, 
	0x8e37e0fc, 0x5c2e7ce3, 0x768632f7, 0xa5df9e92, 0x8cb40f80, 0xe05efdae, 
	0x77ce0f5f, 0x0a0fe69a, 0x48ff2439, 0xf4412b8a, 0x757eb623, 0xcdcb3049, 
	0xd3c0b758, 0x4cd963fd, 0xa95ffe82, 0xe03b4572, 0x6c83fbfd, 0xb47209d8, 
	0xda1e5905, 0x282e97e5, 0x97fd0f9e, 0xe84b97a8, 0x6f7e7947, 0x3116c07a, 
	0x5ff1de47, 0x9e66ee80, 0x1027deea, 0xeb93492f, 0xc3d84317, 0x7d0cf1e4, 
	0xbb795213, 0x8575b791, 0xbf5a0d85, 0x0886361e, 0x5c21f0ce, 0xfd6b43df, 
	0xd3b185ac, 0x0492a373, 0x0c892c34, 0x8f4062af, 0x0c281566, 0xf35e5c7c, 
	0x49bd74d1, 0xe9e3edd0, 0x3f24837a, 0xd7d74290, 0x52202816, 0xf79ed2ec, 
	0xe7409e89, 0x01d713f7, 0xc8f1997d, 0x5bcc0f56, 0xbe43c7cf, 0x9d3a03c9, 
	0x0663d2cc, 0xcd5726e8, 0x1d8d5b8c, 0xa9f71f36, 0xc04e4bb7, 0xecd7b953, 
	0x79e21234, 0x94bfc205, 0x51b847e0, 0x691eb84f, 0x41bfa1f7, 0xf0e69e70, 
	0x4f2f4e33, 0xef0dba7c, 0x36f0e3bd, 0xc43e227d, 0x88af91f7, 0x3fde811f, 
	0xe2de7413, 0xf00a7500, 0x6ff2106f, 0x23f219f1, 0x36fc17eb, 0xb74df822, 
	0xbbe2ccf9, 0x84db3e4c, 0x87c2967c, 0x6ea36fc8, 0x7063d7ce, 0x3ef385dd, 
	0xb6ff9134, 0x8bd25aac, 0xf9c9f7fc, 0x6ef88dae, 0xd45df213, 0xf74dbbe6, 
	0x95dfe37d, 0x17b8f6ef, 0x5b5cb149, 0x558c96af, 0x5387947b, 0x974127fc, 
	0x346f42b3, 0xcf44ddab, 0xec2f01fb, 0x287594ad, 0x64bb44cc, 0xfa8963ad, 
	0x6abec484, 0x33ad0dcb, 0xf801d62c, 0x282abfbe, 0x7e9f234b, 0xd82fa81d, 
	0xf3d7a9f9, 0x21ed70f1, 0x4ebc2cb8, 0x44a5ab80, 0x3d3e9a96, 0x063e1b5c, 
	0x33216f2e, 0x9ed1df91, 0x16f7d048, 0x700bce18, 0x2bc009ed, 0xeac95700, 
	0x4778e985, 0xf7fd033b, 0xdcee5d80, 0xe9334349, 0xe77689a1, 0xb007946a, 
	0x3e50d307, 0x095e695b, 0x208b57e7, 0xdc7f22ee, 0xd02fd094, 0xd9ff71f5, 
	0xca88fdc9, 0xb7d40eb6, 0xc0e97fc7, 0x2fa7fde7, 0x752fcf13, 0x905c3b62, 
	0x68aedbc7, 0xefac195b, 0xc467ed49, 0x7dc28e8f, 0x5db4108e, 0xbfa4365f, 
	0x49f9ec31, 0x5e4f80fe, 0x8b727610, 0xe30bbcc3, 0x6c35f820, 0x81eb2960, 
	0x1eb132f5, 0xa7ad1ffc, 0xb58bc6d9, 0x37d567ae, 0x43d73e68, 0xd03b6f2e, 
	0xaf5cdc29, 0x57924ab0, 0xd90bed15, 0xf2dbe05b, 0x49d65b30, 0x76958376, 
	0xc28c7c82, 0x62ad3918, 0x828f8e7c, 0xaf822e33, 0x382d7460, 0xe8925a3b, 
	0xc70bf70f, 0x8842fdf8, 0x81af80c8, 0x75e157c3, 0x52dde694, 0x612fc7c6, 
	0x479127b2, 0x581fe7e3, 0x1fe7f34b, 0x769b2ba6, 0x9da7b78c, 0x5382ede0, 
	0x5c905dbc, 0x7e0faf6b, 0xf2d7e785, 0xbaf0c679, 0x9f9a616f, 0x3a3ae007, 
	0x252e2f00, 0x80ae3ac8, 0xe43563e7, 0x01f38e4f, 0xf049dff8, 0x33e02543, 
	0x7f03f617, 0x632cf5d6, 0x327e5837, 0x3e6391f0, 0xe71aadfa, 0x18e3ebd7, 
	0xc313812a, 0x33dfc972, 0x2ca87c44, 0x07cdb6a5, 0x9ffb8f2c, 0x84943fdc, 
	0x1ffed89c, 0x1e6163f7, 0x966513f2, 0x9f8835e3, 0xbe254e20, 0xb42a71e6, 
	0xea64c6f3, 0xa1e2279f, 0xc0e3f25c, 0x9ea18cbf, 0xd7f85c7a, 0x5ebfdc8d, 
	0x28fb5a02, 0x1cfc2fce, 0xfee3efdb, 0xc85addde, 0x3671f481, 0xbf145db3, 
	0x8e2d7a28, 0x74ceacd3, 0x8b18f7b0, 0xce787a2c, 0x576318fc, 0x7ea32b4c, 
	0xf8a7182c, 0x58db91c0, 0x6ba7fe8a, 0xea16746e, 0x63dce447, 0x75cb8231, 
	0x46f6863c, 0x6bb07167, 0x6050fcae, 0xc5fc0433, 0xc8712ed3, 0x965e9f48, 
	0xe1aa7845, 0xb55cf178, 0x01082b3a, 0xdb997cff, 0x3d1793bd, 0xfe0146ba, 
	0xed98b408, 0xaec67ef1, 0x84bb7072, 0xec07af76, 0x7746a05e, 0xe40cfea2, 
	0xc4fc15c3, 0x67fb9f80, 0x18afd035, 0x49794ff9, 0xac973c45, 0x2734f2e4, 
	0x76e086a7, 0xe6a7dc2f, 0xefe6fe03, 0xbc20a1dc, 0x5755eb97, 0xfb023da2, 
	0x85e8c6ba, 0x56ec1c71, 0x2fc266e3, 0xa72030d1, 0x7d4295b7, 0xf2f3f910, 
	0x30aec607, 0x8fcbbde0, 0xef855d56, 0x40187e5f, 0x9198f8a4, 0x49fcba55, 
	0x0d9d1368, 0x1be5d2a2, 0x5dbf5357, 0x70a76e0e, 0x1f0af61e, 0xf38dd117, 
	0xb28bb6a4, 0xbd816f41, 0x5fe1793b, 0x13fb41ae, 0xc49743d0, 0x5f2baec0, 
	0x051ae793, 0xafc47610, 0xec09636b, 0x913b3bae, 0xd9dd0d1f, 0x4934f445, 
	0x38d01caf, 0xf5dfd55e, 0xe15b620d, 0xd884092c, 0x80fe86dd, 0x7c4425af, 
	0x5e0a5c9c, 0x4f9017ec, 0xc30744aa, 0x9c24f3c1, 0xfb2b037f, 0xad8bbfa9, 
	0x25ff2076, 0x04ff457b, 0x416aafef, 0xcc72dd79, 0x57fdc04f, 0xbf037ee1, 
	0xcc98749f, 0x6f3c15f8, 0x73dad3c8, 0x3e807ac5, 0x3fb8390f, 0x270eb293, 
	0x757023ae, 0x60031add, 0xbbec340e, 0x9e6ff2d4, 0x0f5f3a46, 0xfbf36fed, 
	0xdda42ce0, 0xdeb41567, 0x8861f200, 0xef840119, 0x3ab65fd4, 0x3d25e919, 
	0x1c7c0860, 0xa175f271, 0xeaf5e55c, 0xb9afc859, 0x683fe009, 0x6fb6bd17, 
	0x6041ca13, 0xa29f91c5, 0x1df81d3f, 0x685ee2fb, 0xd1587917, 0x35c70336, 
	0x18576e25, 0x1e559fad, 0x9e9afc23, 0xef3cb94b, 0x576f48d3, 0xf9701881, 
	0x88f3a436, 0xa18ccd47, 0x743884be, 0xdc6de500, 0x0ebd082e, 0xf9039c71, 
	0x936d49ef, 0x0a7aed03, 0xc430d63e, 0x8f810ac3, 0xd14bfec6, 0xc0b2539f, 
	0x17ff807e, 0x229f02f0, 0x5c373ebe, 0x9e07fc80, 0x679c1ada, 0x87ae2e5c, 
	0x7e91a781, 0x581ffc0a, 0x7dac1e4f, 0xf824eb55, 0x8f8ebebe, 0x4d2e30e3, 
	0xc05ef7e3, 0x7d36cdeb, 0xc73ccf03, 0xf017bbdb, 0xf3c497f6, 0x948405fe, 
	0x39e10fc0, 0x66c947d0, 0xca8f9883, 0x23a55afa, 0xadf389a7, 0x6df398b6, 
	0x731f3c17, 0x28b0bf70, 0x4f14198b, 0x4e761f20, 0xc7c8cfc2, 0x27af824d, 
	0x9ec1e7e3, 0xbe267e34, 0xfcf4f91c, 0x7e8b7c4c, 0xdfd121d0, 0x153b7c14, 
	0x5a056b1f, 0x1f80b77b, 0x44f0f8f8, 0xfb74e63e, 0x5177f973, 0xd1fe89d4, 
	0xfe4bfc24, 0x9c43f4c3, 0xe0a6837f, 0x66f757df, 0xbeceaff0, 0x77dc02ff, 
	0x5f6db3f7, 0x237f849f, 0x55abfc19, 0x5f3f1138, 0xf08abeaf, 0xcc04c713, 
	0x3c7c89f9, 0x74f39d61, 0xfdad9fce, 0xd2c53eb4, 0xbe059f9f, 0x97c24d0c, 
	0xdb97c075, 0x68bcbe6c, 0xd5ccbe2a, 0x43cbe727, 0x4fccef82, 0x7ae397c7, 
	0xecf0f37d, 0xe3c70558, 0x04aeb807, 0xa3b375a3, 0x6a967fb6, 0xab4be597, 
	0x7b225964, 0x59d1fb21, 0x8fddebc8, 0xd85e4df8, 0xd960fc4b, 0x4f3f4cd5, 
	0x4b12190e, 0x8be0f795, 0xc43b548e, 0x9e690b7a, 0x22517f17, 0x2fdcc7f2, 
	0x41d6ee64, 0xbf9de909, 0x97022dba, 0x8c07488d, 0xff802267, 0xccefb426, 
	0x45767481, 0xb3b27c60, 0x6fc40e0d, 0x1e30c5c1, 0xaf5535d8, 0x50671d64, 
	0xd6591adf, 0x0ab854f3, 0xa2712e2e, 0xafd9957f, 0x3881e70f, 0x0e6d97cf, 
	0xe6ef80c6, 0x4c2c9e63, 0x3fd03970, 0xd678b82b, 0xf3e1efa4, 0xe0a6bf54, 
	0x70a4c8e2, 0x07fc7124, 0x2d3f1d26, 0x0b69277f, 0xdbd40cda, 0xf83253c0, 
	0x51dc3363, 0x69d0137d, 0x0beb9ba6, 0x90e8ab49, 0x6fbf3c42, 0xe6665e00, 
	0x5e3130cf, 0x8f55b490, 0x955ef84b, 0xbc017469, 0xf8518f0e, 0x5f53383c, 
	0x72de3cc6, 0xe890af1a, 0xf0846a0a, 0xc858d8dd, 0xfe0596e1, 0xf7e03c61, 
	0xe520bee4, 0x794b1d27, 0xcc65f15c, 0xae3ac1d3, 0x030ff2ff, 0x4e4bf061, 
	0x8e2d7ccd, 0x60df6574, 0xc5472859, 0x329dead3, 0xcae5ffc8, 0xcedc15c0, 
	0x700847a3, 0x8eb117f5, 0x95cd78e5, 0x770dbdd7, 0x89c1bcaf, 0x2d4ccefe, 
	0x847c4016, 0xf20417b2, 0x1567f781, 0xfc873ce5, 0xfc03e964, 0x99bf21ad, 
	0x10740f05, 0x930f0617, 0x1fa6c127, 0x63237da3, 0x7fbe09fa, 0xb78a7454, 
	0x5dbc928b, 0x8bb79e7c, 0x92ede03f, 0x5da8eb03, 0xecae9872, 0x7dbc6382, 
	0xbede09c1, 0x5f6f14f0, 0x8bede498, 0x45f6f3ce, 0xe876f01f, 0x18986d00, 
	0xe37cc3a1, 0xde31c664, 0x4e22719e, 0x70843878, 0x2766ceeb, 0xe95d87ee, 
	0x559df4e4, 0x73d69d3c, 0x4e15b4c5, 0xd2261fee, 0x4bc5c3fc, 0x43fcb2ee, 
	0x851b97e1, 0xd7b5ac1f, 0xc380f98b, 0xd699ff1d, 0x0e38ce6b, 0xe9b7c5d7, 
	0xe2d7e39b, 0xe8174415, 0x7b3e78bb, 0xae9fbe3c, 0xefd25dbc, 0x5dbe838c, 
	0x3757ee1c, 0xb866bb63, 0x4bdb13b4, 0xbfb8bdfa, 0xd611f8b5, 0xd7403f13, 
	0xed89bfab, 0x36ca30bf, 0x663e098c, 0xf1671e76, 0x16bfee4a, 0x8a3c6d1d, 
	0xb27da579, 0xc6667bc8, 0x24436391, 0x3ea21777, 0x429dfe41, 0x1bfa649f, 
	0x22306a4f, 0xe8b1c5d0, 0x76108e87, 0x71657a13, 0xf4449b43, 0x6ff3e769, 
	0x66be7993, 0x87ee46f1, 0xbe3c9c27, 0xfe501405, 0x9abfd2e7, 0x1e68cb5e, 
	0x1c8aec83, 0xfe48da94, 0x538a4314, 0xf70ba07b, 0xfe6216fd, 0x9fa71977, 
	0xfa88ab80, 0x03ff0e57, 0xa68fff3e, 0x0eb08be7, 0xc7cdbced, 0x5d4ba82c, 
	0xa32a1f3c, 0x5fb2bd9d, 0x349f6462, 0x78fb8b88, 0x70f0157f, 0xf0bfb885, 
	0x9525cb0f, 0xf5093deb, 0x7f473e0c, 0x05d6e166, 0x96fe49cc, 0x7d40ed2e, 
	0x5c6d9ba7, 0xec92981f, 0xe787b8c6, 0xfb735cdb, 0x37cc2407, 0x45b27c8a, 
	0x8f993cf7, 0x3b5711e3, 0xbac4688f, 0x3f0b7e80, 0x1d5fb05c, 0x3173ebc2, 
	0x434ee295, 0x57be7dc6, 0xa42f3c9d, 0xa89cc70c, 0x0ff7e697, 0xba9fd038, 
	0xc153322a, 0xdcfc0c3c, 0xdd162fc8, 0xf79b8e42, 0x1793f3e3, 0xec7a455e, 
	0xdd9e7fce, 0x7fa10d21, 0xfe825d20, 0xceaf9dca, 0xe9f5117b, 0x5922c8e9, 
	0x0daff181, 0xd21ac9d6, 0x8c61b18b, 0x8187f34f, 0xb1f129a2, 0x16a5b8ee, 
	0x6b208ffd, 0x7af319ba, 0x8299fa77, 0x1e4bf879, 0xbcf18bec, 0xb4ab7822, 
	0xcfed6a4f, 0xaaffb428, 0x5c7ce34d, 0x097de5b9, 0x676419f3, 0x87059c60, 
	0xc3e40e62, 0x9c93bf79, 0x75fee1f3, 0x81afafbe, 0x69d590d0, 0x99e7190e, 
	0x51b298af, 0xfae2eb4b, 0xa08dffa2, 0xe74cf7c8, 0x2fa5927e, 0xe212770c, 
	0xdd1ef9ce, 0x32ae17bd, 0xaee895e2, 0xa224c67b, 0xe3e5078b, 0x85b2301e, 
	0x166ee0a7, 0xe0fee38b, 0xce080abd, 0xeef7a04e, 0xe7e20958, 0x9853b02e, 
	0x9f33ba27, 0xbdcaebaf, 0x15d70852, 0x713b9834, 0x5b5df112, 0x03f07282, 
	0xdbceee8c, 0xa91e0cf4, 0xd8fe610b, 0x8a5d7fe6, 0x883f9ca9, 0xb8a87f9e, 
	0xd0bef116, 0xa43be3c3, 0xc2c5f22f, 0x728fce6c, 0xd49afa24, 0x261ff78f, 
	0xa73a437e, 0x147c0f8e, 0x413f7093, 0xf1ccc5d8, 0x23f58565, 0xf1fe16bd, 
	0xe9c4a732, 0x953ee267, 0x47cd0e35, 0x0a0e84f3, 0x3ee18c39, 0x2eeba28f, 
	0xa78a2ff4, 0x5ed190cd, 0xec8f7659, 0x5c6a5f5d, 0x718e30be, 0x500d8879, 
	0x4e5b3e5c, 0x3543cb8f, 0x3cb8c14c, 0xb8c37804, 0xf2e2243c, 0x315fa14b, 
	0xefe853ee, 0xa107c8aa, 0x9e1cb8f1, 0x4be686fc, 0xff51cb8b, 0xd4125fa1, 
	0x031f8f81, 0x681d6ab9, 0x2ab5f113, 0x45fd6077, 0x09cc25f4, 0x2e1e05b8, 
	0x4bf3715e, 0x1f74ef9c, 0x7d370fdf, 0x564f5831, 0x1b4fad6b, 0xe43fbf41, 
	0x45bb3c47, 0xedd6103e, 0x7c3378e3, 0xb2ff3788, 0x8ba412c8, 0x1cdfdcf5, 
	0x73d128da, 0xb5f187d3, 0xc3aadeff, 0x78599fe8, 0x40d69e29, 0xe0fc2278, 
	0x5445f7f8, 0x7e4ccbdc, 0xfc87c47d, 0x87607c9a, 0xe5fc950f, 0x101fe0fd, 
	0x151f86dc, 0xad47e5fe, 0xb31e7036, 0xe9ef36f1, 0x277e0387, 0xf89f9ff1, 
	0xe408fd1d, 0xa36f2bef, 0xadef2e79, 0xcf39700d, 0xde65b8a5, 0x98020bd3, 
	0x2971c12f, 0xdeed74ce, 0xee96fe48, 0x7e203568, 0x00b6dfa9, 0xa9f98696, 
	0x51be3c05, 0xd49c9fb8, 0x26f8f016, 0x64e4fdc8, 0xa223b448, 0x553fc56d, 
	0x8badbc55, 0x7ac1a8f8, 0x2a5bc62e, 0x768a8bc6, 0x8ab7688b, 0xfe8b56f1, 
	0x79c76886, 0x14f3665b, 0x44793784, 0xdfc43fdc, 0xf63c610b, 0xe9bf0db6, 
	0x1b56c059, 0x33e5fc76, 0x21dad3af, 0x8e3d904e, 0xdf3f7c43, 0x8c00fb10, 
	0x17ed00f4, 0xff997af0, 0x16c47e54, 0x28eec339, 0x827d1720, 0xb09e40cf, 
	0x2cd7c45c, 0xf1fbe7e0, 0x2d9f574a, 0x772121ef, 0x77e6c7e0, 0x146fdca6, 
	0x68bd91fb, 0x3efe41af, 0x465c7ce7, 0x9439f47f, 0xbfb0079b, 0x4fc8c4a1, 
	0x7e8c81fb, 0xb829e91a, 0x3776e506, 0xf0c033ea, 0x873f944c, 0x7e44cc66, 
	0xf5e410db, 0x4ccf3017, 0x78c6dbd2, 0xaa6672fe, 0x72d49cbf, 0xb75dfe78, 
	0xcb366bc2, 0xbc9befe0, 0x359f4a1e, 0xf85fa0a6, 0xfbe6595d, 0xbe28b331, 
	0x986dd851, 0xcc68ba9f, 0x72bb47cc, 0xaf91a8e1, 0xa178090d, 0xb61be2df, 
	0xcbbd0877, 0xcf7fb49c, 0x010e9fe1, 0xf633e629, 0x737b3d09, 0xc2ddcebc, 
	0x36f63bc7, 0xb1d943e5, 0xe8b3ca11, 0xbb1ea117, 0xff808357, 0xf1cfce14, 
	0xf841dc01, 0xc8734006, 0xe2c59d1f, 0x4b8241c6, 0x5967f6c3, 0xf41e75ce, 
	0x2e804a83, 0x00f7684d, 0xde843b0f, 0xd36d465a, 0x7bee821d, 0xb7283301, 
	0xebef8caf, 0x3087946b, 0x73fdf7c7, 0x24c7e352, 0x13c43f98, 0x4f118fe6, 
	0x2bf8033f, 0xe72c1f09, 0x91dbfc04, 0xda535bbf, 0x6254afc9, 0xb49eb65d, 
	0x35c5b0fc, 0x8def4afc, 0x07fa2bf2, 0xddb990bf, 0x8d7ce39f, 0x6e90b9fc, 
	0x887f8828, 0x2dff6887, 0x7f496ac4, 0x37d89926, 0x4cf1e069, 0xf297ab32, 
	0x5bd612c1, 0xaffef818, 0x9e22ef48, 0xbef00f11, 0x21cbef84, 0x8eefbf9d, 
	0x6c67d5a7, 0xa2cb1b9c, 0xe0255abc, 0xd529f387, 0xf47958cf, 0x73f0b28d, 
	0x8bbe9f30, 0x4ba7c84d, 0xe0173e80, 0xc1f40c33, 0x16973cfd, 0xe53abca4, 
	0x0def29bf, 0x1abb02f8, 0x2173b006, 0xf02adc3e, 0x9df1794f, 0x86f67929, 
	0x7f00dc38, 0x7f5866a9, 0x7aa0339d, 0x00ffc602, 0xd5f842f1, 0xd6cf5c55, 
	0x8a0d2b5d, 0x1f3ce3a7, 0x4efeaf5e, 0xb25b3cc6, 0x4f38a157, 0x931e7112, 
	0x104f47cd, 0x4f1d78fd, 0xb0ffa88f, 0x907a91ea, 0xfe917bfe, 0x839252c1, 
	0x9ade82a3, 0xff469a5e, 0x328fa8a0, 0xa4ae2b25, 0xe2a89ef1, 0xdc2ee172, 
	0x7e841657, 0x38fa4bc9, 0x1d391a1d, 0xe7ba0ab6, 0x5d9fb8b8, 0x70bb66af, 
	0x9c02643f, 0xc2d0fccc, 0x64c3d537, 0x54b717e0, 0x42120e90, 0x2b19f480, 
	0xb0cfdf4f, 0xefc063ea, 0x30df9171, 0xebc2d75e, 0xcf3d4469, 0x88dd52d6, 
	0x73eb1399, 0x4eb164b6, 0x118a1bd2, 0xfda5eb14, 0xe380bbdb, 0x7ffdacb2, 
	0x0957af84, 0xc56c7c62, 0xdf1de1e9, 0xbd7b45ed, 0xc76381f9, 0x9fd7fc79, 
	0x3336fdc3, 0xab36fd07, 0xba14c49f, 0x1cf4d21f, 0x8cf37f7c, 0x76a2aea1, 
	0x62e5ef84, 0x8ac1ffbe, 0x1c03fb53, 0x6d1ebcc5, 0xe1dbe13e, 0xe99f8b32, 
	0xa2b9fea0, 0xff466e7f, 0xb9fe8cdc, 0x3ec5db3b, 0x6b8c69f5, 0xfc25df6f, 
	0x2e3cc587, 0x5c5d63d0, 0x084f4cbf, 0xdbc1333f, 0xb29a3e2c, 0x45f60d1f, 
	0xdd503dd4, 0x2fb7ed20, 0x79677dc6, 0xcdd00157, 0xbb72e1e7, 0xa86fbee9, 
	0x9d971f18, 0x299f4891, 0x2d0fee1e, 0x8c59eb5c, 0x4aee09fb, 0x94fd1d36, 
	0x0577c065, 0xbb85bf5c, 0x202cdb78, 0x9dc2cabd, 0xd70cfef0, 0x20f62e6d, 
	0xa6b673ac, 0x62133e22, 0x0fbefcdf, 0x53d42ca4, 0x3ba5ea9e, 0xaa7a8f51, 
	0x1fa2777b, 0xb3cbea7f, 0x16351054, 0xc2387175, 0x8069d65e, 0x177e165f, 
	0xd7981bbc, 0x1aae0b33, 0x52ce97b4, 0x8b5c2159, 0x5c2f79e0, 0x49ddeeaf, 
	0xb5e8d8f9, 0x355d70fb, 0xb1651a17, 0xe7b6c63a, 0xe3063533, 0x576beb85, 
	0x1edc12c7, 0x85fcc41d, 0x032651cf, 0x4b8f7b7e, 0xdfb80e65, 0xc7daf02d, 
	0x93ca32f4, 0x7c54daf9, 0xbc1c765e, 0x7767c02e, 0xb05dd6f7, 0xe6e0d602, 
	0xdae33170, 0x1e032fed, 0xca072acb, 0xf3e3f9f0, 0x12d94a06, 0x66ff42bc, 
	0xe476f3c2, 0xb87fc78b, 0xf4e31775, 0x7b7fd155, 0xfcc1e71c, 0xd7997b10, 
	0x76c629f7, 0x17297bac, 0xf3e5ddf9, 0xc6ca7e39, 0x76ebddb2, 0xefd55e11, 
	0xc73df8c3, 0x86d0b207, 0x4d6417b1, 0xdf093906, 0x02754b36, 0xebf72f7f, 
	0xc6263145, 0x013efc07, 0x9a71c786, 0x9cfb87bf, 0x0f2dfd96, 0xeb0cfd35, 
	0x5e218e46, 0x57654fc1, 0x0ace3448, 0x7c2d9761, 0x17ceeb58, 0xcf5e5ceb, 
	0x6163e4f5, 0x74f38c33, 0x4eb1fdff, 0xfdfff405, 0x9a7fbe2e, 0xff77ef10, 
	0x153b6dfd, 0x2e63d3a0, 0x5f76871e, 0xfd79439d, 0x13d70f2a, 0x71d9dd16, 
	0x708a97a0, 0x38c41ddf, 0xacfd7c3c, 0xfa108eb6, 0x07319775, 0x7d89dbd6, 
	0x27089df3, 0x375b05f8, 0xfe269fe4, 0x806c70d8, 0xa39f38c5, 0x7f9187dc, 
	0x954ecf80, 0xd21950cf, 0x1a746bd7, 0xbbd95700, 0x27c89d5d, 0x9d3979e1, 
	0x21c6f90c, 0x39475d51, 0xab7971c0, 0xf5d3ff5d, 0x471b2c6e, 0x5b7e26bb, 
	0xed9bf636, 0x7f41ebe6, 0x10cee50b, 0x37a67bf9, 0x2c201e50, 0x0a5b13f2, 
	0x73fa18cc, 0xb23943cb, 0x6bb77604, 0x48edd6fd, 0x5e9ae5ff, 0xaa177984, 
	0xad7581cf, 0xce635850, 0x04df517c, 0xe89535f3, 0x509c638b, 0x0afe6945, 
	0xbfd08b33, 0x5bbf0534, 0xc1f72575, 0x706f58fc, 0xa52ac29f, 0x78a35d24, 
	0xb6fd0535, 0xed89edfe, 0x449b4f28, 0xd73c1add, 0x3d369273, 0x25906692, 
	0xa210ea52, 0x53061667, 0x6eb006eb, 0xb6f80e21, 0xb85c16ea, 0xfa70804f, 
	0x84a760f5, 0x579e78f9, 0xb8f00d29, 0xb815ea90, 0x021f09be, 0x277db7b8, 
	0xae4ab9ff, 0xb7a8c317, 0xc1fe826e, 0x0ef589d6, 0x0fe1ff16, 0x593585f3, 
	0xf4c3a7c0, 0x3fae165e, 0x89d1de1c, 0x07eeddf4, 0x5e3d0579, 0xcdf006f6, 
	0x05b7ea69, 0xcc3db5d1, 0x0fba49fd, 0x798bdfd7, 0xafdc5c3a, 0xae086bc0, 
	0x10773335, 0xc266cbbd, 0x355f70f2, 0x0cbd43bc, 0xa8642ee5, 0xd80f347d, 
	0xe613d47f, 0xffc62940, 0x16566165, 0x0176ff03, 0x1bac5533, 0x154c1c30, 
	0x0fb461fb, 0xd05f207b, 0x44e915c7, 0x619996fa, 0x7661b3b2, 0x72d2abe6, 
	0x88a56758, 0x2c0b4223, 0xb3de92c7, 0x0f7a6df6, 0xb975a4ec, 0xfb4a9558, 
	0x786afb90, 0x3fde2aff, 0x6643ed6c, 0x3f1e338c, 0x6b49b91c, 0xdfc6dc7f, 
	0xb0ebebff, 0xf7a8a99f, 0xb80b4dff, 0xbd0956f3, 0xbe8efe41, 0x18fbd70f, 
	0xa3beabd3, 0x7ae1f1da, 0x9a1e0ff4, 0x3d2c57a8, 0x3b30edd0, 0xf55e188d, 
	0xbd74f19d, 0xaf1e72f1, 0xd8ddef93, 0x1b6ff826, 0x9d188bee, 0xf754bdbd, 
	0xe4106b71, 0xf71725ee, 0x5cf9ad33, 0xfb863d5e, 0xf71cf830, 0x4baca6a9, 
	0x27f11687, 0xe9f3f9b3, 0xf3d62747, 0xf46cf8e2, 0xee03e893, 0x0fa54c67, 
	0x73340f48, 0x857dc3bf, 0xf5aefebd, 0x58dd51b7, 0x60c2f574, 0x867a1d5a, 
	0xb87a087e, 0xc4f4b41e, 0x7b32eb94, 0x5c8eead3, 0xe18b6feb, 0x1016dcbe, 
	0x8da76913, 0x7a75cca7, 0x8f6dc69c, 0x9beb7c71, 0x9a7a291c, 0x05515d81, 
	0x7a6c467d, 0x69a7494d, 0xccc8fe56, 0xfc827a15, 0x38ec1b9a, 0xc2f2972d, 
	0x423c70b7, 0x788b971c, 0x61c441ba, 0xbcf375bf, 0xe119e817, 0x0abf716f, 
	0xede3aefd, 0x83e07c62, 0x754c0bd2, 0xd5b5135f, 0x794f007d, 0x5f6b3e95, 
	0x71bf7f37, 0x13f023f4, 0xee7af04f, 0x3ba68fc6, 0x3ee09bd6, 0xc0f95952, 
	0x71eaeb2f, 0x26cf767c, 0x149b87d0, 0x6871cff6, 0x67d8d26f, 0x9bbcc136, 
	0x6a51e682, 0xb5115887, 0x3891c623, 0x92a9bbc0, 0x94a376fd, 0x0b9fef32, 
	0xf9e1c68f, 0xc329c773, 0x6bfe2575, 0x71a8ff9c, 0x0f3c42ca, 0x6d797c8f, 
	0xee3f9feb, 0xffffbd7f, 0x7a65fbf7, 0x2ffc5f3a, 0x5a1b8be0, 0xfb451fb9, 
	0x2f9e71f4, 0xd8273760, 0x6beb6621, 0x6c99adfc, 0x65f1ad5f, 0x7d9b57da, 
	0x52ec2c2e, 0xe4d5f684, 0xf15817af, 0x5f6d23bc, 0x3c47d44d, 0x872441a9, 
	0xcfb11479, 0x2312f546, 0x0867bea2, 0xa25f29eb, 0x306a4d78, 0xdb0d57d4, 
	0x0570ce0e, 0xb757583c, 0x8a12c1f9, 0x39a896e3, 0x95fa0e34, 0xfd0bf6a9, 
	0x57a3cc47, 0x943d72ba, 0x8fa8c8bf, 0x9a1ef1a5, 0xef4b2758, 0x6f1ea625, 
	0xcfc7bb6a, 0xb1fb8d99, 0xebdda27f, 0x4bfdc99a, 0x198633f2, 0x1be9c39d, 
	0xba513f42, 0x1e0cfb75, 0xeca6548f, 0x0a5c501b, 0x5d76cef0, 0x56bcc1e6, 
	0xb5bd5859, 0x738ec2ad, 0xf3cd74af, 0xa2c45e50, 0xc52758ab, 0xfc76231b, 
	0x8ac8f101, 0xc68e1c0d, 0xdfe31398, 0xcf184593, 0xb6c757dc, 0xfb8eb01b, 
	0x6189ae30, 0x2f71035c, 0x99f2b9d8, 0xfe31db5d, 0xc797515d, 0xfa80a6eb, 
	0x7ef3a7bb, 0x351fe0fd, 0xe110bf80, 0xda274c71, 0x8036b2d1, 0x05667813, 
	0x4ae30fae, 0x869e0f1c, 0x433af2eb, 0x015fef1a, 0xc3d6bdf4, 0xf1865ce9, 
	0x32dfcc34, 0xa32e672f, 0x2ab5973a, 0xe62bd5c6, 0x6cfe42bd, 0x779bccf9, 
	0x5f761c62, 0x05e50e55, 0x3ce9adc0, 0xef87f302, 0xb1b3ac7c, 0x7807fb8b, 
	0xeaeca4ce, 0x86874e9c, 0x79419e71, 0xd7379a81, 0x9e017695, 0xbebb33c3, 
	0xea3f11a5, 0x7d5f9865, 0x563dc44c, 0xbdac3ebd, 0xfdc9d628, 0xe8c7dc7f, 
	0x7a7ee7ce, 0xabb5f36f, 0x738e1a63, 0x78062b30, 0x0cc4fc78, 0xc96cc7da, 
	0x60bab337, 0xb5f5d5dd, 0x4a5a5d55, 0xcdfc21bc, 0x3f623cfb, 0x4456d7cd, 
	0xfee36ef1, 0x4475e530, 0xf222dbfc, 0x3d222b80, 0xaffd0c45, 0xf2353bcf, 
	0x4e8e0157, 0xcfc5b380, 0x2006ba8a, 0x67e5b90e, 0xec37d99b, 0xbcffb7f1, 
	0x8f885beb, 0x295fc715, 0x8f4da4c5, 0x44f41fc8, 0x71c2cb5e, 0x597afcfa, 
	0x30f3c027, 0x78039fcc, 0x7110eedd, 0xf30bac09, 0x1788dd35, 0xe10faf89, 
	0x3f0f2bff, 0x4145f2df, 0x17ffab07, 0xeb0cfc45, 0x947ac2af, 0xbc3fc42e, 
	0x7370fcb7, 0x598bee11, 0xd1c534f1, 0x1e0714c3, 0x3e771061, 0x345edbd6, 
	0x4ed7371e, 0xf8adaf8c, 0x98ebe29b, 0xfd6b0f8d, 0x172e07e0, 0xfe8c397c, 
	0x62dfd51d, 0x65cf0e3e, 0x55738b0d, 0xa5635f94, 0x3a6fae31, 0x4ae97bcf, 
	0x54aeb2e7, 0xaf26fcac, 0xb9e175d7, 0x5bcf0d2c, 0xb0b9236d, 0x55cd5bce, 
	0xd4c07ef8, 0xf50cade7, 0x2fde5ced, 0x93b9fc8a, 0x79d683c7, 0xe93c0fab, 
	0x7aacade7, 0x5573ccef, 0xbddd7e25, 0x98e0f00d, 0xc3e28391, 0xacc1e54a, 
	0xae7754cd, 0x835a6c37, 0xbfdd42f9, 0x1babd699, 0xb2d7d431, 0x8676dbcb, 
	0x9fc79fe4, 0x973ae2f9, 0x878affcf, 0x043ac79f, 0x7fe61d57, 0x7acfd05d, 
	0x144b265e, 0xf9f99787, 0x79e1fb7b, 0x8fef2b63, 0x878efefc, 0x6125afc7, 
	0xad78425d, 0x5c7b27f3, 0xebee7475, 0xa7df0a8b, 0xa0eb88f4, 0xba876f78, 
	0x50e5e789, 0xe97fa05e, 0xa9ab5fd8, 0xc40f72fa, 0xe624811b, 0x23f8f9b5, 
	0x77c27ef2, 0xdae1cc99, 0xb678e119, 0xa382d8f8, 0x50b3cc42, 0xaa5b0b9c, 
	0x71abbe70, 0xf70793fd, 0xb80a3663, 0xe1ed3e70, 0x25a6f9f4, 0x2d06f86d, 
	0xac5f323d, 0xe46ebadf, 0xe7fd6b57, 0x6a30dae0, 0xcad0bfcf, 0x3a8bf543, 
	0x94a98507, 0x2a7f04cf, 0xff8f67d1, 0xad3afaac, 0xde7ce167, 0x22e42ebf, 
	0xa7ad6a7b, 0x4be3ac49, 0x3ae35ae2, 0x785bf049, 0xc7d777ed, 0xead3eeb0, 
	0x5e370a9f, 0xbc18f9af, 0x652d3f62, 0xe7aacf9d, 0x83e7ff48, 0xc6da38bd, 
	0x8587e3c6, 0xf3e22ea2, 0xacbbaf0a, 0x38279d71, 0x5850fcac, 0x5ed9f976, 
	0xa90dceb8, 0x4fb85dd2, 0x7ac2cb1e, 0xd9c430eb, 0xdba47cb1, 0xe95f6407, 
	0x1a5bc039, 0xfb84d1da, 0x0f9e53f4, 0x00a99851, 0xae11fa4e, 0x4e7f1ff3, 
	0xce064464, 0x27bf3b02, 0x495d1ac8, 0x929fabe4, 0xc4072add, 0x63f389b7, 
	0xdcfc4d8d, 0x61c82355, 0x1b50e2ad, 0xad1b7047, 0x83f6c54d, 0xe5f3d70a, 
	0x4fc4252d, 0x1aa69e78, 0x0f454eda, 0x49fda21e, 0xe7175f91, 0x05a8969a, 
	0xcb69e20a, 0x4abd95aa, 0xf29d7e4a, 0xfa26dbd2, 0x62aff009, 0xfcfb7ded, 
	0xe9c2b37b, 0x5837e993, 0x4ab2f6f9, 0xf5ce98a9, 0xc29fe466, 0xbe2fa95f, 
	0x79d93dda, 0xb87c231b, 0xe9e79c53, 0x1b68fe43, 0xa1cfc2dd, 0x783ea30c, 
	0xf04b9d56, 0x57419c5e, 0xff84bf0b, 0x16778e26, 0x9f4ff5b6, 0xfc82997a, 
	0xa3cd77e9, 0x682ab3eb, 0x34b7f442, 0xfef18a5d, 0x3d94eca3, 0x5cafa59e, 
	0x9653e719, 0xd06edc28, 0xb9e7887c, 0x57f73a31, 0x64eaf82e, 0x0719d996, 
	0x4f3e51bb, 0xea2bd5ba, 0xaf8f500c, 0xf96f7212, 0xb48f1829, 0xe8dfa469, 
	0xaa8029dc, 0x3e595862, 0x54adc16f, 0x4ef22a7f, 0x92836a7d, 0x2f3ece73, 
	0xc02a708b, 0x38099717, 0xe8806446, 0xa9f3cd1c, 0xf858b7ce, 0x5be71962, 
	0x2a97559e, 0xb3cdc993, 0xb8a717ea, 0xee29a5ff, 0xa74a4d37, 0x49e6d567, 
	0x96ba57fb, 0xe4fe3ad1, 0x7c197073, 0xf76161a2, 0x0ec7c843, 0x5a9dfd0d, 
	0x09ed6ba6, 0x9241ff9c, 0xfdc8292f, 0xafd567e8, 0x18d2f6f2, 0xd9c733b5, 
	0xd9cc6d98, 0x55c67a8e, 0x982aedcb, 0x1e1f9145, 0xc44d9578, 0x97589b2b, 
	0xe7403918, 0x61c88dae, 0xe2bafe7e, 0xf7d36f18, 0xfb37e02a, 0x4ecf6f14, 
	0xf39cf6f2, 0x98e73574, 0x4a7b18eb, 0xf5fdf6b1, 0x70d1d412, 0x4bef84bf, 
	0xc387a419, 0x3af01c8f, 0x113f485a, 0x9d8585ff, 0x9168f4b0, 0x4b9fedca, 
	0x9636fb15, 0x3d79d73e, 0x5e2e040a, 0x3e0f1f5e, 0xe35f3c0c, 0x30e89c7b, 
	0x5ffb84bb, 0x526b6fb3, 0xabc57eb1, 0xd2a67df2, 0xa97efe7c, 0x7ccf3e9c, 
	0x3f7be795, 0x152be623, 0x705b91fb, 0x6ae41523, 0x5047630f, 0x7595c20f, 
	0x1dfb84ae, 0xe7e0be5c, 0x5ca8fdc5, 0x9973f395, 0xc35f0f78, 0x2a1985fa, 
	0x40796bcf, 0xbe522457, 0x344171d3, 0x7d056736, 0x1a6743a7, 0xec8fedd2, 
	0xbc63cdaa, 0xdf827c8d, 0x7c83381d, 0x5f2e47f1, 0xde3f623d, 0xb2fc0b31, 
	0x6c7ec4b7, 0x3c7ee188, 0x531ac7ed, 0x7c66c7ed, 0x8ad7e2af, 0xf7c60755, 
	0xf887b765, 0x63c3bfbe, 0xf9177e94, 0x45d8ea22, 0x8e7820fb, 0x77c6d87c, 
	0x1ce8c289, 0xfb857eda, 0x7eeafd45, 0xe991efce, 0x2cfbfb69, 0xa7fcfcf3, 
	0xe8109fe5, 0xddf4e9b3, 0x0301ce96, 0x7866d7f7, 0x606d1fc9, 0x9183fa26, 
	0xfe46d0b9, 0x514d32a9, 0xa7ebc94f, 0x998eab0d, 0xf046e7ef, 0x9d00f31c, 
	0x7df032c7, 0xbfc70f0c, 0xf7b491f7, 0xfd1f7175, 0x07c85380, 0x3a9753d1, 
	0x2943fef9, 0xfc470f9e, 0xe1625fa2, 0x2f6165f7, 0x3d02e932, 0x4421bbe8, 
	0x4f1f459f, 0xfdf11e87, 0x65ffc203, 0xdc78fd8c, 0x496565af, 0x52e6e295, 
	0xb82c3f6e, 0x4be63958, 0xd3367f49, 0x26f1e578, 0x83ac678e, 0xcfd0b1fc, 
	0xe6254417, 0x72d2f9e0, 0x3e93379c, 0xcb66bfc0, 0xa25f6e29, 0xfa7a7ccf, 
	0x12f42cbc, 0x9fe609d1, 0x7f25ad1b, 0x5a73ae1a, 0xc040de00, 0x423ea2a3, 
	0xba3a46f9, 0x5bf9e02e, 0x242dc5d7, 0xdf0a7d87, 0x8b0d2b2f, 0x500011ef, 
	0x27ae499d, 0x854a4e50, 0x05f24b9f, 0x3103ddf8, 0x96d8675a, 0xff825db3, 
	0x153cd5ea, 0xd44caff9, 0xe17b8047, 0x626ef8c5, 0xc39700bd, 0x436fc2dd, 
	0xeaff4479, 0xe084bf8c, 0x8f587e04, 0xf82081df, 0x7d5e10fa, 0xb801df46, 
	0x4f2d634e, 0x309e3039, 0xfdcf5a6e, 0x9076d1f7, 0x2a5b0885, 0x62cde1f6, 
	0x8ac96f5e, 0xfe39cf53, 0xf419caf7, 0x20afa13d, 0xb19f7c5f, 0x1a4d9595, 
	0x69560de6, 0x49ce986c, 0xead2d71e, 0x877fa086, 0xee9bfbc4, 0xb68f584a, 
	0xf8eaad5a, 0xa302fae4, 0x7e32b584, 0x62a9c2df, 0xe7161afc, 0xf98f51a8, 
	0x1eddf452, 0x739e3b58, 0x746303dd, 0x7f51333d, 0x15cd7859, 0xbb82d9f8, 
	0xef8fc9c2, 0xa3057547, 0x9ef23fa4, 0xc26e3807, 0xfc8dbf75, 0xbf52f2cf, 
	0x7f5e31f7, 0xe3c96a10, 0xaf2e26f9, 0x5bbae137, 0xdd265f88, 0xef8d710f, 
	0x587e7087, 0x3f68d11e, 0x4bdd53c4, 0x8f9821fb, 0xf62539c9, 0x7d8a4e45, 
	0xb743f011, 0x074d0756, 0x7510c7af, 0x1ffbe9d7, 0x979a0fb8, 0xadc570e4, 
	0xb10de438, 0xded3ba2f, 0x7d5add17, 0xffee3b7c, 0x75acfd59, 0x5a8fee64, 
	0x55cb2bf5, 0x5ee57eab, 0x9b3ad275, 0x6e057d4c, 0xb077ea68, 0xd88dcf48, 
	0x791e28f5, 0x899d7f58, 0xd2269e3a, 0x106c6a3b, 0xce935ae8, 0xf361251f, 
	0x88fd96cb, 0xf59112a2, 0x7b14eea6, 0x892cf542, 0x546ffb89, 0x253d334f, 
	0x2f4135ef, 0xdf693ac2, 0x033aa75f, 0x00ca1efc, 0xa1d47ff2, 0x3b262d0e, 
	0xabf5a5fa, 0xb096ec53, 0x0ffd7647, 0xf0e163b7, 0xbf085d8c, 0xd5645755, 
	0x32fa58f1, 0xeb09aead, 0xfea53f39, 0x2cde9664, 0x12b4ae7c, 0xd60acffa, 
	0x33fe5396, 0x2208cea3, 0x61d9a0c5, 0x9f9605c7, 0x109fce36, 0x817c5067, 
	0x76433df5, 0xbabc913c, 0x0cc6f3f6, 0x7d6b0f3b, 0xb37e050f, 0x363e02f6, 
	0x3bdcbd81, 0x4e3ce74c, 0xdd908e56, 0x5132fbb9, 0xf20bd3ff, 0xfdc73ec1, 
	0x42918df8, 0xcfe638f6, 0x3592992a, 0xc6fbc6cf, 0x19b61cca, 0x0f3926e4, 
	0xcf61d9e6, 0x3d07e653, 0x2bf7109a, 0x6bcb386c, 0x5c227476, 0x3e6a2b65, 
	0xb476fe4f, 0x98823386, 0x2dedafc7, 0x5780fb45, 0xfe7863b4, 0x7da26944, 
	0x0deb2524, 0x8ff29f3c, 0x4c0fc52a, 0x2275859f, 0x29cf1cf8, 0x9ff6e6ba, 
	0xbc44bac6, 0x54ccdd62, 0xff64b6fb, 0x28bc2f40, 0x6fc4bdf8, 0x9eee3ed2, 
	0xb28ff084, 0xf53ef3f8, 0xbafb8a90, 0xb037a065, 0x08fd053e, 0x122af903, 
	0x7206d8ea, 0xf23427bf, 0x7d70396f, 0x1677f845, 0xfff223fc, 0x1e747d56, 
	0xd3d215fe, 0x13ac2bd7, 0x7abf74f5, 0x87f8c554, 0x78e69dfa, 0xeb84cf74, 
	0x15fe57bc, 0xee3852f3, 0x571f28da, 0x1ce3833a, 0xe71a1557, 0x99e62ae7, 
	0x98ae71ad, 0xce954bf6, 0x52896b41, 0x32cf8fe1, 0x0f289e04, 0xb027798d, 
	0xc63d1b77, 0xf89d7d9c, 0x2f8149fe, 0x60201cb3, 0x3f7f9fb2, 0xafee15c8, 
	0xe296bcef, 0xe3073a2c, 0xea2d0fca, 0x0ef3a7ac, 0xfb40df45, 0x275837e1, 
	0xfe6bb7f0, 0x1c737bb0, 0xdbf7baaf, 0x49f7e02f, 0x77363bfa, 0xaff4fd60, 
	0xe073b4d5, 0x134fd71a, 0x5c2f81cf, 0xfc61e783, 0x7c0e7e51, 0xc78f4d4c, 
	0xce8c35fc, 0x19f3fb81, 0x0bf7039d, 0xaa0ffa7f, 0xf8de0738, 0x7e1de522, 
	0x37cfc759, 0x83f9c9ce, 0xf039e93a, 0x8e710de7, 0xe064a80b, 0xd4536d79, 
	0xda993369, 0xbce7e959, 0x7617ff2e, 0xc1ee78a5, 0xd33ee176, 0xace4e389, 
	0x2505731b, 0xcae5e73a, 0xafc96b87, 0x7bc239f9, 0x22f41e73, 0xad1eb31e, 
	0x7687ccf2, 0x2731bae1, 0x883f5856, 0xc456be39, 0x7c45e687, 0xeebc5c00, 
	0xba84fb7e, 0x4c3c34fb, 0x3c327ef7, 0x7515e85c, 0x3c4c89f7, 0x4cf0485c, 
	0xfb3dc3c0, 0xecf3a0ae, 0xe3e3a48f, 0xf4bf0047, 0xfc0e5b1b, 0x7a89dd51, 
	0xe23f86c6, 0x71df7ac5, 0x1a3efbf8, 0x213ecbfe, 0xf05a57fc, 0xd529fbef, 
	0x5ff0d883, 0x2bfc3939, 0x84615df7, 0xb6d9ce52, 0x47a8639b, 0xf41f730a, 
	0x0db03d62, 0xf78242ef, 0x835ff2d3, 0xc3bcfd37, 0x68df7054, 0x50fbbdc1, 
	0x9c6fde06, 0x0047ee1c, 0xe5f700ef, 0xfc231b5f, 0x7b67e35b, 0x8279b9f8, 
	0xdf9d3cfb, 0x3c21a359, 0xb5ba850f, 0x39e7c0dd, 0x6f68bccb, 0x51f3e197, 
	0x3cf63ec6, 0x3a69ef6a, 0xe1027a17, 0xb892fb41, 0xfec1ce9a, 0xd20adfee, 
	0x799253be, 0x6d49f51e, 0xf53dc119, 0x29d35479, 0xa4e64fbe, 0xe7584aef, 
	0xf8d8076b, 0xf3b4b4b9, 0xe74621b5, 0xbd45b27a, 0xd5aaeb82, 0xe17202b2, 
	0x6b263459, 0xf6f78031, 0xbe4724d5, 0xec8ba6a5, 0xdbb9c650, 0x27f3f4a9, 
	0x321f26bd, 0x4e24f3ad, 0x32124f3a, 0x814f118b, 0xde618848, 0xb489103f, 
	0x40d639e1, 0x0515d784, 0xae4ab2fe, 0xa3f03904, 0x9a8f82dc, 0x462f5abd, 
	0xb340fdf8, 0xfeefd00e, 0xd75e4448, 0xc750d782, 0xc6ef783a, 0xa32f811c, 
	0x0b64fc8c, 0x4547c0df, 0xbd163728, 0x71d6474e, 0xb666c8fa, 0x2d38780c, 
	0x987e81b3, 0x76761547, 0xeaf82afc, 0x2f6e5edb, 0x5f3cbc7a, 0xc797a4fe, 
	0xe62cf2ed, 0xae0ebcea, 0x6ee6d9fb, 0xe4552be0, 0xf49ad573, 0xd129ff78, 
	0x9e471adf, 0xfcf19215, 0x3fbfbca2, 0xfef803d0, 0x2e67c107, 0xbf70533f, 
	0x037c8dcc, 0x42ebbcfe, 0x20d33036, 0x7c60affd, 0x2f97dd6c, 0xf0840c8c, 
	0xa00b097e, 0x43872b3f, 0x3c97a431, 0xd27474cb, 0xbb1bc3b8, 0xe2ce9e80, 
	0xd3ae1b60, 0x0cfe5f7a, 0xd5da47bc, 0x9241df49, 0x7ddf7e45, 0xc069d835, 
	0x1e5e33f7, 0xd7e8c917, 0x65f3e36f, 0x1fb9e135, 0xd2f7c4a6, 0x9728033c, 
	0x7bcc0d72, 0x55d79ec6, 0xde78dbc2, 0x7fd1c38e, 0xe110e77b, 0xe538f925, 
	0x6d9c78ad, 0xe327e3e1, 0x91f70372, 0x56d906cf, 0x195817ce, 0xa067ed08, 
	0xbbab7c4d, 0xbf260f50, 0xb24db565, 0x2e84c90b, 0x8f6383fa, 0xb6acdbfd, 
	0x93f6a749, 0xa336ad2b, 0xb50e4bb6, 0x73f2d674, 0x2704097e, 0xb8f8be60, 
	0xb8c923f0, 0x1f071b64, 0x4f694b1f, 0x3da50fd3, 0x6943642f, 0xa1cd4bcf, 
	0xc6e5e7b4, 0xebed694b, 0x6b4a7ff4, 0xd387622f, 0xbd1b5fde, 0x3ee207a7, 
	0x1fbb1d65, 0x76b8a3f1, 0xc05e7af8, 0x1d19e4fa, 0x8f840ef1, 0x3e1d38fd, 
	0xf0e9c7f3, 0x6b493f19, 0x98ffea17, 0xd3331f0e, 0xb4cd33e1, 0x0319d7e7, 
	0x83e9f0e9, 0x4d19f0e9, 0x8710be02, 0xb9ee56af, 0x911be10e, 0xf19f8037, 
	0xf40fd206, 0x21767078, 0xbd06dfed, 0xba0123ac, 0x3fb894fc, 0xff03ef0d, 
	0x6beaf34c, 0x829bfef1, 0x0a7383bf, 0x63efea4d, 0x33fde22f, 0x8fbc7f56, 
	0x0bfa7dfd, 0x445fff78, 0x7e3142ff, 0x71a4d7a1, 0xbe7ee292, 0x65ef9fb8, 
	0x311dff74, 0xbf18a14e, 0x38d267d0, 0xbe7ee2a3, 0x63ef9fb8, 0xc040bf74, 
	0x07d3aca7, 0xf02b0e30, 0xc0136b1a, 0x1e3eb957, 0xe789e6c7, 0x1db35e79, 
	0x2f222bfb, 0xfbe3e052, 0xde02057c, 0xe3419f02, 0x01da9e29, 0xde2b5e7c, 
	0x99c22bc7, 0xf9e5fa27, 0xefd803cc, 0xae7f0165, 0x6bd73f80, 0xc447f8d0, 
	0x3f716cfd, 0xc1ae6bdb, 0xfc0547fb, 0x5cfe02b9, 0x1ce3419f, 0xc5b3f713, 
	0xb99f6cfd, 0x2abfef1f, 0xe311c9c6, 0x1a7578e4, 0x1fe8b8ff, 0xefc2eb10, 
	0x9ffde099, 0x38c5fd5b, 0xc69d3e39, 0x07ee213f, 0x9f01fc04, 0x196be34e, 
	0xacbcd378, 0x40b6f11d, 0xe62fdbac, 0x9ad97bf5, 0x235dbc54, 0xf189a6f0, 
	0x303b1f34, 0x02fcde19, 0xd18fbf0e, 0x4ed16e7c, 0x456d560e, 0x89f6c41b, 
	0x033c83ef, 0xded023ed, 0x7dcbce2d, 0x457bb44b, 0xf79ab13b, 0x23df5b8f, 
	0xbd627f81, 0xbfb89b46, 0x52b38c5a, 0xadbca3b4, 0xe8af0e94, 0x617947a9, 
	0xddef907b, 0xa3f7fd79, 0x43ceedbf, 0xceae0597, 0xf817477e, 0xfd59eed7, 
	0xaf0916d2, 0xc3be2fe6, 0x374b22f3, 0xdfe2e690, 0xf2540b23, 0xbf4cf83a, 
	0xd1a95020, 0xe85542f9, 0x947ad671, 0x4eb25fea, 0x1ebdb845, 0x6efd910b, 
	0xb9abfbfb, 0x00fe805f, 0xb73a47c6, 0x205f968f, 0x1eff0dff, 0x33e09b59, 
	0x093ee579, 0xc22b81ed, 0x6fb743fd, 0xec947bfc, 0xd8ebc031, 0xa1f15f65, 
	0x4eaee2bf, 0xbe20ffbf, 0xd56bd70f, 0x738c3e15, 0xf9570a0a, 0xea516e30, 
	0xe38e1243, 0x1e3d059a, 0xb749dbb4, 0xc601fdc1, 0xd97f01fd, 0x3f7c7cd7, 
	0x67aea325, 0x77f279ef, 0xf016f88e, 0xc90b91f6, 0x6de6790f, 0xbc99dfcb, 
	0x7aaa67ae, 0x35b5279e, 0xe63d5f04, 0x221ce887, 0x4dfe112b, 0x7fa0afc9, 
	0x5ba17870, 0xfead3f7b, 0xafef87d4, 0x9e26646a, 0xd7f18637, 0x9b73f20f, 
	0x4fc339d6, 0xc4c3ffb5, 0xc3c6053e, 0x90ae7e09, 0x835a2bf6, 0x18f124ac, 
	0xfbdd3763, 0xd2d6a194, 0xe3c326be, 0xd28bde86, 0x65f525f3, 0xdab3d4ba, 
	0xbbd497ce, 0xe7a87c5f, 0x1d9f78b3, 0xfd86d2df, 0x75f77f75, 0x794dff78, 
	0xa6e7ac23, 0x52d3074a, 0x1d7187de, 0xdf52c61b, 0x353eff77, 0x18708f7f, 
	0x5dfb9379, 0x74decfe8, 0x9e2363af, 0xb366f081, 0xd8bbf07b, 0x6bfd6cde, 
	0xa2f016df, 0x94f7ac3d, 0xfcc13605, 0xeb6aae4b, 0x73fb01c8, 0xf411d453, 
	0x17debe71, 0x90f5a0eb, 0xc2b37c3f, 0x63c89f4c, 0xfca28d75, 0x3ee00c0e, 
	0xdb4ff434, 0xdcfc378f, 0xb9fa89df, 0x9f3153bf, 0x7e1543fb, 0xf9057de6, 
	0xe7de6758, 0x645f0630, 0xa2dafbd2, 0xe533a619, 0x7f1f41fd, 0x7ef03bef, 
	0x375eae08, 0xb24ffeff, 0xf39c4061, 0x1ff45e67, 0x8ce65ebd, 0x8a7c4203, 
	0x041f88e9, 0x38f3f2fe, 0xec14bfc1, 0xdeebc43e, 0xe43e125b, 0x218f0a9f, 
	0x7bd9fa63, 0xf20711cb, 0xbcc39ab1, 0xb3790fe8, 0x677e2f4c, 0x5e2ba237, 
	0xbf9cec44, 0x7986d1d8, 0xf71988e3, 0xa37ef01a, 0xbbf1f2c2, 0x19bbb9eb, 
	0xfac08bd5, 0x7abcf187, 0xa2f241a4, 0xe97b3a1f, 0x1e091788, 0xfc814b01, 
	0x3407df8d, 0xd90c0236, 0x07cf0fba, 0x03bafbc0, 0x2dad2ffb, 0xc5d2fdc0, 
	0x842e830d, 0x0766cb47, 0x67260eb0, 0xbfde8443, 0xbef18744, 0x1779f021, 
	0x73c513cd, 0x60e89113, 0xab75c201, 0xb41212c2, 0x10bd140b, 0xac55c3fd, 
	0x1af304b1, 0xd27802ff, 0x86fbc5de, 0x2817ef0b, 0xcf8a0966, 0x10cc8fc5, 
	0x7e6047df, 0x794abf3c, 0x36bfaa1c, 0x1587e8bc, 0xdea83954, 0xe79fa8e0, 
	0xe6ac9653, 0x198a63f4, 0xb372073b, 0xb5f0ea24, 0xc3af9c02, 0x8e803bf3, 
	0xa5e67cc1, 0xcc6b9eef, 0xf1c235db, 0xc160fb8f, 0xa9dd0b33, 0xa04105f5, 
	0xa91fc22f, 0x1e22f26f, 0xcfe9a383, 0xb847df33, 0xab4f2062, 0x396f1df4, 
	0xd55c7fc1, 0x13a0e330, 0x6341b3f3, 0x0a92f310, 0xfdfe0e68, 0xe74f5667, 
	0x03df0509, 0x226e5503, 0xffb68cb9, 0x3f789b2b, 0xd6e75ba9, 0x0f7e3775, 
	0xf1e71142, 0x434c831b, 0xc6c87046, 0x9e4c20e0, 0x3a0a31e7, 0xad7fa424, 
	0x7322f91b, 0x50ac3c9c, 0x416f9f79, 0x9e88b9b4, 0xa3c03166, 0x474c1f00, 
	0xde188a86, 0xde76e9be, 0xe234fc0d, 0xc53e4ce7, 0xab6aa673, 0xad15dfcd, 
	0x42eb2f0e, 0xe78c61be, 0x6dac1d19, 0x2ef7df2d, 0xc73fa24e, 0x06fdc1c7, 
	0xf1b8bbac, 0xcadf9e45, 0x300a37ef, 0xf0eb86af, 0x8b4f1c03, 0x42759571, 
	0xbd2a3a8e, 0x27a78039, 0x3deb7dc4, 0xaede71b0, 0xab5bff14, 0xeb81fce7, 
	0xe68a7599, 0xf5c2ce8d, 0x8eef0c84, 0x19bebe26, 0x889c7ccd, 0x151e8795, 
	0xf1cfce72, 0x297af20f, 0xa0ba465d, 0xfa29ab9c, 0x0cc962a0, 0xe1477e2f, 
	0x2587011a, 0x23f724ff, 0x53e80f42, 0x7f9d7fcb, 0xbfb7f90a, 0xfca93047, 
	0xf9e7e5df, 0x1bfe5b0d, 0x5f1718bd, 0xa46ff282, 0x45e1bfca, 0x7fe4b179, 
	0xf9271eb6, 0xb9077927, 0x242a6d9a, 0x860fa4ff, 0x7a0dfe50, 0xecffc96e, 
	0xe31798d6, 0x3fca08aa, 0x7b366cd0, 0x49fe4d2c, 0xfe42a3ae, 0x407d6d9b, 
	0xfb780ff2, 0x87ddda15, 0x5e807f50, 0x2815e780, 0x5e844bff, 0xabc8a448, 
	0x780af202, 0xfa0124bc, 0xdbe60727, 0x716e48cd, 0xf987bbdd, 0xe22f77ba, 
	0xf5888deb, 0x7fbd6046, 0x33ede167, 0xad143cfc, 0xe0cf253b, 0x57a8c2fd, 
	0x7570e21d, 0x0a5c3946, 0xf0225f3c, 0xd2c7e167, 0xc67e167f, 0x63f02fd7, 
	0x33eb8faf, 0x78fb13c2, 0x27eb58fc, 0x9e01053c, 0xb37f583a, 0x9c12c7c0, 
	0x81f9a75f, 0xdca08f0f, 0x340de856, 0x2d2fa5bf, 0x1b30ac3e, 0x9826c6bc, 
	0xf7a351a7, 0x1a2b782d, 0x5ff0d35b, 0x402d6ec1, 0xcfd71b39, 0x5127d001, 
	0x47a82f1b, 0x084af7c5, 0xd31eb43f, 0x8fa8bfd6, 0xfada76f3, 0xa4c7d2d7, 
	0xf1b6ef87, 0x49cbe562, 0x7a6d470f, 0x204e7e93, 0xb46e2dfc, 0x68c72823, 
	0xc13e4807, 0xd8de9e8f, 0x570066e8, 0x19a652e3, 0xbf5e34cd, 0x1f0119f3, 
	0xeb934797, 0x9f9f0141, 0x74df08c9, 0xe9ec8f84, 0x6a120b37, 0xf7879e86, 
	0xaf401a2a, 0x42e1b62d, 0x73367779, 0x27ce7779, 0x50fd4b3d, 0x53cf11de, 
	0xdfa0d3f6, 0x02afdd88, 0x93ebb1f9, 0x17c263f0, 0xf9d3fa19, 0xe2cfb0f1, 
	0x2daf6e47, 0x7af65afa, 0xf6db1edc, 0x011f833a, 0xe9d8434e, 0x03dbb0a8, 
	0xf235ed13, 0x96de74a3, 0x87d7b25b, 0x00965f05, 0x46e6149a, 0x8b7da33a, 
	0x887b09b5, 0x7bafce76, 0x67b0b263, 0x0dbec24d, 0x7b031da1, 0x33e362d6, 
	0xd2ae4ed3, 0xe19dcec1, 0x9f00c4e3, 0xf876ad37, 0x1a373be8, 0x7ea2a79f, 
	0x91f31b20, 0xbb453d96, 0x7fcdfb8c, 0x71f37210, 0x0cf15576, 0x6d9abd72, 
	0x4b1ea978, 0x3abb6bd1, 0x9eb05e39, 0xa058fc97, 0x07616cc7, 0x45af5058, 
	0x6b76863b, 0x7add8a5e, 0x41738fdf, 0xf7fa7f3f, 0x41fe9093, 0x7e07ffa0, 
	0xe2cd7e7e, 0xb5e9a603, 0x3f9c603b, 0xb63d79fa, 0xdf168fc5, 0xb7cd5f10, 
	0x8868abc7, 0x1b5df8c9, 0xee482f8b, 0x7bbcb6e3, 0x176f0cb3, 0xec2fedea, 
	0x9877e2f5, 0xa46fde48, 0xbf1d417a, 0xd27e4137, 0x03775833, 0xe6c47a7a, 
	0x35fdf18f, 0x1c92d7a6, 0xe2f0ee34, 0x19d9fa99, 0x0be6e07a, 0x48ddff00, 
	0x73bf5e47, 0xc7ad8b32, 0x1d9f23f9, 0x6ffb8d98, 0x3f2cbe16, 0x8853b2da, 
	0x14eefa2f, 0x0a766be0, 0x700a2ebe, 0x77c4d73e, 0x35f13357, 0xbe39302b, 
	0x13e8034a, 0xfac370d8, 0xfc3eb442, 0x7433c6ae, 0xda573a8d, 0x78a9fee3, 
	0x8991f0b3, 0x544fc227, 0x226871e0, 0xfbf1ea9e, 0xdedcddd0, 0x63157af3, 
	0x636cf910, 0x2d21d780, 0x3fe4c849, 0x31e2d8de, 0x8bfdf056, 0x3fc7c46a, 
	0xf426f3c2, 0xbffbb24f, 0xb18ea5bb, 0xadfe10ad, 0xe4bafb07, 0x7bbea7a6, 
	0xf39001c7, 0xbba5f91e, 0x50d85da0, 0xbcddc777, 0x3375b98e, 0xfb3d6bf8, 
	0x1e60d40e, 0xc1ef6cf1, 0xef7bb41a, 0x3f242e8d, 0x03d033e9, 0xcf8824fd, 
	0x9c5ca00f, 0xf3dafd9e, 0x75077df8, 0xfa354371, 0xbc6d4a45, 0xdff80146, 
	0x79fb7b6b, 0x78c25fec, 0x804af22c, 0xb6f791eb, 0xfa835edf, 0x17a6acf4, 
	0x70bf83b4, 0x7ea8574e, 0xa357ee05, 0xda87569e, 0xd6df49aa, 0xa8375436, 
	0xf00bcf69, 0xa82fdc39, 0x15efe782, 0xf7e3cf99, 0x108f084c, 0x841bbdff, 
	0x7185eef1, 0x6355d50f, 0xd432a2fd, 0xdd53cd66, 0xddfe81ee, 0xefc00eb0, 
	0xf08b2d3b, 0xaf7b0088, 0xf68753d7, 0xa2cb6cf1, 0x40cfd43a, 0xd73c6abf, 
	0x9e17b67b, 0x6b389d83, 0x171b5436, 0xb673fcd8, 0xed1ab5b1, 0x4ba459e4, 
	0x7af2de8a, 0xef903de1, 0x5dc028ee, 0xbaf3e38b, 0xa5945f68, 0x050f13d5, 
	0xd3d9bd78, 0x628c8d70, 0xf71abd3f, 0x7fd87c5e, 0x419db51b, 0x52ece778, 
	0xf00959dd, 0x1d34ef7b, 0xc744c395, 0xefc03eb6, 0x66df04f7, 0xdea2caf5, 
	0xdc2bf407, 0xdbb0daef, 0xb2f5cad9, 0x6bf000fe, 0xd9c352d6, 0xffef0a7a, 
	0xc5d681c5, 0x7fd05f9c, 0x281c4ac9, 0x3d528d68, 0xf015b3bf, 0x0de22dd8, 
	0x5ac7bfe4, 0x4dfafe6d, 0xddbbfb80, 0xd11e2295, 0x5eb8cf80, 0x8c9f3193, 
	0x2cdabc7e, 0xb6f9dffc, 0x1cb64b1e, 0xf3f7f34c, 0xf6bec17a, 0x38c5f1d9, 
	0x91165b1e, 0x21b5df9f, 0xb0287948, 0xc041d5c7, 0xf79836eb, 0xb3c451b2, 
	0xbd40f846, 0xb714e732, 0x6ebc15f3, 0x23dbfea9, 0x36effedc, 0x766acaf1, 
	0x283e366b, 0xe829d94e, 0x72f02c38, 0x1bd3c608, 0xe43f2daa, 0x1f8db081, 
	0x1c8defa2, 0x208f28bf, 0x56ed0cef, 0xcf097d26, 0x533e364d, 0xda3e73ec, 
	0x132bc209, 0xbef58578, 0xd5d394b3, 0x6ce0f82f, 0x9a467754, 0x11c3ff68, 
	0x7fb6f611, 0x1d33f63a, 0x4ff814a1, 0x423fe966, 0xe57671fd, 0x32f7a487, 
	0x37f34ae9, 0xae897809, 0x31fdf6d1, 0x8e839fe4, 0xb424f3d4, 0xc7f6d4be, 
	0x7baffdd3, 0x36c5bc78, 0x360bb7e2, 0x5e5d1094, 0x207cf00f, 0xe70db7c1, 
	0x8d6ea96f, 0x9f00f0da, 0x691e2356, 0x2f1b21dc, 0xefac2704, 0xeb0bce2c, 
	0x84f511cb, 0x4a3f2720, 0xf79f22f4, 0x28396b54, 0x39f2e61f, 0x06e8de7c, 
	0x30b553d0, 0xecf77e1f, 0x1ac1c6fa, 0x2bf24b94, 0xc1ef1e80, 0x08ff587b, 
	0x7f47e9e4, 0xdb8aecef, 0xfe8a58eb, 0x217b6f7c, 0x1dd131c9, 0x3b7bdde9, 
	0xdf92dfe1, 0x77fe0165, 0xdf92a60c, 0x016ea2ad, 0x1290dfe1, 0xce3d2387, 
	0xe32dbb70, 0x2e9096f7, 0xbf78332d, 0xdbfd94e1, 0xf3af0ab3, 0xea8d7af7, 
	0x5fd39044, 0xc8e1fd03, 0x8593f1e2, 0x670d9cbf, 0x23f8a91c, 0x01fea1bc, 
	0x625d683e, 0x7887cbd3, 0xefbdf783, 0xe96b9c2e, 0x3c0ef6db, 0x8382f53f, 
	0x4425c4a5, 0x651c4c77, 0x9f76fde6, 0xcb5fbca4, 0xcc9df15c, 0xfde500fe, 
	0x1e63b96e, 0x6d125f3d, 0x1d17df4b, 0x40264eff, 0xbb801bfc, 0x7bfa79e7, 
	0xf9e74c0b, 0x3d44eebf, 0x7a5a6bed, 0xac4bfd0e, 0x16f8b1df, 0x84db15f5, 
	0xa1ef1e57, 0xf239449d, 0x3a3d00ae, 0xd034744c, 0xacb40c3f, 0xe10076a3, 
	0x91ee5c66, 0x3f8fc9bf, 0x6b72f5c5, 0x881f8db3, 0xee5106bb, 0xc9b83e2c, 
	0x4f313a63, 0x1495f960, 0x07ae3007, 0x5125ae10, 0x7c5be7ee, 0xfc97e168, 
	0x1f9b21db, 0xf9e32c6f, 0x6193804b, 0xc7b2c85e, 0xf9e11fe8, 0xacb31bfa, 
	0x40b9a6fc, 0xfec70bec, 0x6ee499b8, 0xd82bf601, 0xefe86acb, 0x27e4654e, 
	0xd78f66b7, 0x53d5a673, 0x7e005d93, 0xbff1877f, 0x5124b15b, 0xfa8ba35f, 
	0xfc56a1b2, 0xf7665193, 0xfbeca53f, 0xd7cd0b78, 0xdfa106bb, 0x349f8ea3, 
	0x13d09e63, 0xa5aae91d, 0xe7452d3f, 0x593e4139, 0x725e4a6e, 0xdffa566b, 
	0xbab25c03, 0x53bbfdee, 0x96bf94f2, 0x17aeb5fb, 0xd6537b18, 0x5fa05de3, 
	0x3cd9beb2, 0xde00eabc, 0x5b6c8f67, 0xd78df783, 0xbca45f3a, 0x3f5823e4, 
	0xfcc8bdee, 0xd8b3d62d, 0x9dd9a3cf, 0xcf4e0907, 0x7ce04fcb, 0x527befc6, 
	0xb1a77de0, 0x4a5f03f1, 0xfff1927b, 0xd48f9f8e, 0x447ad787, 0xd1196bde, 
	0xa2f91fb9, 0xa017213b, 0x9b27b83d, 0xe3dd31fb, 0xf6bd3079, 0x3f3e135c, 
	0xeef500b0, 0x1e56d99d, 0xf28058cc, 0x23cfe99a, 0x694ec87d, 0x0f3c02c6, 
	0xd5ebf418, 0x57a65f3c, 0xaf5cbf73, 0x52e97f46, 0x24e0fafc, 0x95d9fbfe, 
	0xb44b556f, 0x5d710f9f, 0xb2af9d93, 0x98e75bf2, 0x6ba1d3fe, 0x324dc601, 
	0x9adafb9d, 0x5b677d15, 0x6f4c9e1a, 0x9be2e51c, 0xd6bf6bed, 0x6f4df789, 
	0x751ef082, 0x7ee5af75, 0x621ef899, 0xb2c3e50d, 0x196e8f87, 0xd4ec7f24, 
	0x8fe835c6, 0x8ef471bd, 0x2ec7f27a, 0xfd06b659, 0x775dc1b1, 0x1b64738b, 
	0x263fa1d6, 0x3a78835f, 0x06b9efdb, 0xfa3ce9f9, 0xe64f0f63, 0x38fe158f, 
	0x563f92a8, 0x49b77f83, 0x83543da9, 0xdbe75d75, 0xea9c7e2a, 0x79b3c58f, 
	0x53fcf69e, 0xdfa12fa0, 0x16c7f439, 0x2854bda1, 0x54ff3fae, 0x43c60d4f, 
	0x0986bcf0, 0xb161aebf, 0xaa1d5cfd, 0x0626402b, 0x0aa6ac7f, 0xc45f3fde, 
	0x8fe69c7e, 0x60d5d7c5, 0x66aefa7c, 0x80f7b4d4, 0x0cff469e, 0x891df8f4, 
	0xa6b85475, 0xff3d710c, 0x00c7d02e, 0x589bbf64, 0xfcfd7a44, 0xb01f5876, 
	0xe17ef9d2, 0x1e83f59f, 0x3fb93fd1, 0x23ad1dd6, 0x295f4978, 0x6f63fb53, 
	0xe138f167, 0xafcf1658, 0x2c7f439d, 0xe763fb61, 0xce1b1fd0, 0xbf70c7f0, 
	0x0fc52b2e, 0x83df7e83, 0xb95b17f6, 0x77cd4ebd, 0xf8441da0, 0x14b31ed1, 
	0x097a8efd, 0xccbb43e1, 0x107fa645, 0xe59996ff, 0x3a3f75a7, 0x403a9af8, 
	0x1dea457c, 0x70da47f8, 0x69b4ed10, 0xe7816d74, 0xa84e3957, 0xd7cb53f5, 
	0xcefd45af, 0xfd7a729b, 0xb8b24fc3, 0x0b5d6dff, 0xcb4ebe0c, 0x54fb81ee, 
	0xfc81df8c, 0xc6cef88a, 0xbf4fd5aa, 0xf28bdce5, 0xbe338ac3, 0xfa9c588b, 
	0x88aff3fd, 0x9555963a, 0xffb107e5, 0x573ee168, 0xe4aef895, 0xd46f1821, 
	0xfb425838, 0xbb9d5356, 0xbdce2e3e, 0xc9fdf6eb, 0xf9dbbdce, 0x70c75e38, 
	0xd7a7296e, 0xe759f9c7, 0x084acfd0, 0xfb682aff, 0x963cd657, 0x5bd594ff, 
	0xc8bf3fff, 0xb5ca9fe3, 0xb3fa26eb, 0x85afe653, 0xb5f96b9f, 0x7f8796bf, 
	0xf46df5c7, 0x3d7fdd0f, 0x7b73ff99, 0xfc45d68d, 0x3e1cecf8, 0x27c628df, 
	0xdac77c76, 0x6eef3c13, 0x09fea1e6, 0x3798831a, 0x4e6c87fe, 0x38eb64b7, 
	0x59df145c, 0x10e778eb, 0xe50ba3e0, 0x88fe4dd3, 0x3f78ceb2, 0x07e27cf5, 
	0x477bfc59, 0x7df1661f, 0x447b8221, 0x6fed07ac, 0xc53f872b, 0xdfd1369f, 
	0xf7087d22, 0xddef007f, 0x40fdcad1, 0x9f16e3b4, 0x79881fa3, 0xc5ebe23f, 
	0xb8fbef82, 0x80fa45bd, 0xd76df9fd, 0x7e7f6475, 0xd07bf5df, 0x83d07183, 
	0x41eaa70f, 0x4b8896f6, 0x1e9336cb, 0xe225bc74, 0x287bd6d2, 0x2cbc752e, 
	0x8b6d52e2, 0x7d60f507, 0x0e7f8e35, 0xef5c38e3, 0xede97194, 0xa971123f, 
	0x35ca83d0, 0x6d9e9718, 0x54a3fe5b, 0xc0aaf83d, 0x3d15d9eb, 0x3d2c37a4, 
	0x3b88aef8, 0xad78aecf, 0x75a5c786, 0x9f50afa4, 0x3f6a5c62, 0xcf4b8f4f, 
	0xa59f0116, 0x22f3c1e8, 0x10ef7d2e, 0x4b8a3be8, 0x3ce0d71d, 0x0d6669ef, 
	0x53ecfdd2, 0x393e288b, 0x81b67187, 0xcc02f5f7, 0x016d9e5b, 0x747187fd, 
	0x778bd72f, 0x7e631c60, 0x7a483d2a, 0x06aef81d, 0xe2778ae3, 0xf533de5c, 
	0xb9b3f7e0, 0x365cfc1e, 0xb6cf4b8f, 0x6d2e3c18, 0x8acffde5, 0x0c9df4b8, 
	0x365b783d, 0x44c18eff, 0xfcd1f83d, 0x7f613df1, 0xfc84f933, 0x0e679248, 
	0x79e5005f, 0x9f3ca264, 0xa7d37115, 0xf5aae790, 0xf41bf41e, 0x1be79e6a, 
	0xb2f4805c, 0xae6f7cf2, 0x859b2b7c, 0x1770bf84, 0x5f683bf7, 0x0dfa53e5, 
	0xe6127e76, 0xca7e1369, 0x6fdcf01b, 0x727e5356, 0x64cef1aa, 0x02f4f78e, 
	0x7c41ef1c, 0x43c600fe, 0x3f2c5f9c, 0xf411e318, 0x0dfd684f, 0x876cfd7c, 
	0x1e2b7ebd, 0x253b2e79, 0xe3c65b7e, 0x4887b213, 0x1e3b618f, 0x8a64fcb6, 
	0x3c441a4f, 0xe3c9f252, 0x010e2b11, 0xf716f3bb, 0x1f078c77, 0x1ef80f7b, 
	0xa77bb6e3, 0x3fcedb8e, 0xf5b71195, 0x77969edf, 0xf9e2c9e9, 0xfbf8a9e0, 
	0x2fae02c6, 0x15e5fb2d, 0xe2b615df, 0x59ff4b5a, 0x11763ced, 0xc4b089e9, 
	0xfb3744f5, 0xd8af4166, 0x85392bc7, 0xd83b4fdf, 0xadb0f456, 0xbdbdf1ef, 
	0x17f313a3, 0x3d72566f, 0x7717eff9, 0x447e0481, 0xfd8935dc, 0xf1b3f110, 
	0x8f3f1133, 0xcf7f0275, 0x1b20fc0b, 0xfec033eb, 0x1b7d730c, 0xb56eed1d, 
	0x2e2b36e3, 0xe281f8b3, 0xee4275b8, 0xad388996, 0xace38ed9, 0x8e252cb8, 
	0x15bf3ca3, 0x391c8197, 0xfc041c79, 0x635fb298, 0x5c50cfed, 0xb1bb7066, 
	0x9f1121f4, 0x5038888d, 0x94607117, 0x0be235cb, 0xff54c1e3, 0x2893f2c9, 
	0x4538775f, 0x15db8ddf, 0xad04f5fd, 0xadfeffb3, 0x98f9d8ef, 0x66d65eb3, 
	0xbafc19e0, 0xe237e246, 0xac57cc3f, 0x02b7e718, 0xa7d237e4, 0x9556fc29, 
	0x8279d1fd, 0x1e4b6cfc, 0xe4b55eb9, 0xeb0fc731, 0x1ab5d28f, 0xcb9723d4, 
	0x3571c928, 0xcf974a1b, 0x58107ad4, 0xae3e3bd7, 0x7fa10e9f, 0x07d09d7f, 
	0xf505fe56, 0xd7b092ac, 0x292b7045, 0xfdae8770, 0xe3e07644, 0x44ecb1e2, 
	0xf9113e7a, 0xd7c04ee4, 0x6b6b05ff, 0x0000f969, 0x0003d4d1, 0x7dcd9c78, 
	0x555c7809, 0x77b9f0d9, 0x99dcccee, 0x93ec9664, 0x4d24cba4, 0x302869d2, 
	0x1b69805d, 0x92ed6ded, 0x85006a22, 0x80a48b52, 0xb4d44536, 0xbd9b0d54, 
	0x29669333, 0xe969265d, 0x4b012e02, 0x4316f85b, 0xf8a0d1e5, 0x2c06db7b, 
	0x8f951f8a, 0x513ef84f, 0x31654d02, 0x4943e568, 0xbeffc22b, 0x6cef79ef, 
	0xfffd056d, 0x3cfffbe7, 0xe59e9c0f, 0xef3de59e, 0xe673de7e, 0xaea45d4a, 
	0xb9442d99, 0x6f9e9a2e, 0x5d72e215, 0x13ae9f98, 0xa21417c2, 0xdf885dbd, 
	0xfd42172f, 0xe85710ac, 0xc215ee90, 0x1798c2bb, 0xaf5e7685, 0x23d83151, 
	0x10bf62c4, 0x2de63d62, 0xbf943775, 0x5e74bed1, 0x67f60174, 0xbf909854, 
	0x6a27edb6, 0x11b40b74, 0x097f1686, 0x5a196ffa, 0xf1088ea5, 0xaa6136b1, 
	0xa5b962b7, 0xcd4c2e6a, 0x423df1c3, 0xb1cb01e8, 0x3b1090f5, 0x6522c3ca, 
	0x497fd10a, 0x71e8abad, 0xc9a83748, 0xcb884d12, 0x7cb1559a, 0x96ffa45c, 
	0xdad134a5, 0x861dff21, 0x0bcd15f6, 0x7a87af4b, 0x86029845, 0xf29defc7, 
	0xc2a244fb, 0xa1aec421, 0x8c04f345, 0x3a5b6be3, 0x7cc1f44f, 0xe217ce4f, 
	0x861f1094, 0x308d89b6, 0x70eb54fe, 0x4e217af2, 0xc3fd5e34, 0x17e42f50, 
	0x9875551c, 0xcf5967b7, 0xb4197d3c, 0x21f9ac4f, 0x33809fb6, 0x93e2142e, 
	0xc020a700, 0xae9b8de9, 0xeed0172e, 0xd1c341f7, 0x6b8854b9, 0x27a85d0c, 
	0xf449bca8, 0x1e6bba62, 0x9a0bebd6, 0x65979a9b, 0x0c6b3dea, 0xbc564c07, 
	0xd0fc6551, 0x3df58d5c, 0xfed062f3, 0xdaebf83d, 0xdb1fc420, 0x22893697, 
	0x53468348, 0x0a212ee7, 0x2bffd042, 0x281eff30, 0xb1fef587, 0xb142e967, 
	0x635bbe0a, 0xfee002a9, 0x488fec06, 0x5ee6da41, 0x8feceb88, 0x229c72aa, 
	0xbf61354b, 0x6a51745a, 0x18fd00de, 0xfbf0f3cd, 0x79e6ac37, 0x0f9844e6, 
	0x16f3c3ac, 0xe7da5be4, 0xe2a41089, 0xfb0172ca, 0xb9d71733, 0x6eff0859, 
	0x7200f08d, 0xafcc3889, 0x8fa96dd0, 0xaeefae40, 0xaded79b6, 0x6eb1afd4, 
	0x03ef8854, 0x093f2c3e, 0x3cc2b7df, 0x777dbf20, 0xc32c43a7, 0x71872b76, 
	0x86a46f3e, 0x7f7e71cb, 0xde7e46d0, 0xdf8858b7, 0xddbf236a, 0x262139f9, 
	0x9d62f8c3, 0x2cb69710, 0x1e013824, 0x846e388e, 0x30915ef6, 0x584ddd61, 
	0x17d3f30f, 0x0af5c8b6, 0x228ca031, 0x3ae42b5c, 0x659d603b, 0xaed08f80, 
	0xac63f604, 0xe3644acd, 0xb0b7b417, 0x04484b7d, 0xaab89835, 0x2b0f8799, 
	0x6fe23db2, 0xef2cdb89, 0x0c2f1052, 0xfc04a897, 0x4a1d6a9c, 0x55684cbe, 
	0x7f087a6e, 0x171c4dcb, 0xf30455e6, 0x5d8558fa, 0xbd9b966f, 0xc9f94e34, 
	0x62aed48d, 0x27f889dc, 0x549bcf44, 0x42a2315e, 0xef6c80fb, 0x9378a9bd, 
	0xdd0a7800, 0x7f41f474, 0x7a3a6822, 0x18fee197, 0xbd17a45e, 0xa015354d, 
	0xf463488f, 0xe5e75c39, 0xd5c703ed, 0x19a62101, 0x68445ecd, 0x3d0bcdff, 
	0xe0290c22, 0x63f6125e, 0x35ecd59a, 0x7afec8b7, 0xe83ebfb9, 0x0614e9cf, 
	0x3b7ed3d6, 0xe6b09fb0, 0x67527de0, 0x4983ff63, 0x4b5a7fec, 0x5e0057bb, 
	0xff9e5ff8, 0xc0e9905c, 0x7d7ec04c, 0xc703a0fe, 0x701fba03, 0xcbfcdc00, 
	0xe91b97a1, 0x97dc01fb, 0xa71f8869, 0x31f1f832, 0x325175a5, 0x6db9f40e, 
	0xc8a6b97a, 0x17c89bf5, 0xe04fea6e, 0xaab59777, 0xe324f15e, 0x47eb8c03, 
	0xddb8303c, 0x472faa3a, 0x5ae98fb8, 0xa4957987, 0x73f01367, 0x7bce084c, 
	0x3d42c854, 0x55997fe4, 0x3bc4685f, 0xf37bdbb3, 0x10cc46f2, 0xcde565cf, 
	0x40737aa1, 0xa07ed7d2, 0x88b160af, 0x1aef809b, 0x5a9780a6, 0x1c5ea86c, 
	0x31adc683, 0xada1f481, 0xe40b7c80, 0x197f385b, 0xea311bd7, 0xeb98bb53, 
	0x3dde64db, 0xfae2a837, 0x4c50ba82, 0x15c7ea0b, 0x4d932891, 0xe544bf77, 
	0xf79420da, 0xc5060f07, 0x4e743397, 0xda408af3, 0x3d5eb1bc, 0x711bed45, 
	0x0f9e7b3c, 0xe10f9b16, 0x14c21f3c, 0xf450f9e6, 0xe7dc72c7, 0x43f1a89b, 
	0xf3263ccf, 0x9e689b47, 0x263f0d0f, 0xf5c439e7, 0x01fce3df, 0x6ea0ff59, 
	0x383f5236, 0x6f31bbbf, 0x12b60e34, 0x06ee36fe, 0xb96dfe7c, 0xe3779330, 
	0x6f547e7c, 0xd4fb901e, 0x007d7407, 0xe7ac24f9, 0xd42b33b7, 0xde591ee0, 
	0xf3d7127b, 0x23f8a0d3, 0x8449e7ef, 0xc6768ffb, 0x57632400, 0xf060f4c8, 
	0xec77ad18, 0x0aff2e46, 0x906ed8a7, 0xf0660ddb, 0x720dda86, 0x7ffb4c3b, 
	0xba36fb48, 0xf23578fa, 0x2ecb8427, 0x5297cb80, 0x7ed5aa47, 0x8839ddda, 
	0x14e016bf, 0x7cc86bd1, 0x5ef00534, 0x086c93db, 0x047a632e, 0x1e6ed0be, 
	0xd9fdc069, 0x1774255d, 0xbc338bd2, 0xfbd616af, 0xea03e633, 0x261bdbea, 
	0xf85ff7c0, 0x21f5edea, 0x0ae15d48, 0x38fd05d1, 0x35d14183, 0xaa22f203, 
	0x3e608f75, 0x4c3f75a4, 0x9f20adf4, 0xe85c7034, 0xf85935c7, 0x0f47005c, 
	0xe1f58ff6, 0x2748a8df, 0xc8e6ebb1, 0x3a171979, 0x3f6fff30, 0xdf242f9e, 
	0xf4261c30, 0x87ed5c2f, 0x28a79815, 0x1a0048ed, 0xdf066f88, 0x213f8a0e, 
	0xac715b5d, 0x8a854577, 0x3119d47c, 0x6377e415, 0x107747c1, 0x1d216afc, 
	0xe7367482, 0x38f4c897, 0xec24cac8, 0x2abff1d3, 0x0fc8a506, 0xb2049d20, 
	0x14380744, 0x7d851a41, 0x8cda408a, 0xd8ab55fb, 0x7e4752fc, 0x60b9dc79, 
	0xe3c1ca19, 0x38f5357f, 0x8ad183f0, 0x7b8474fb, 0x40f7b405, 0x5c50dafb, 
	0xee098b57, 0xe06dca3a, 0x9edf7a3f, 0x96d73e0c, 0xd8af54be, 0x79e41cf3, 
	0x77f6b346, 0x912f9736, 0x6378fe69, 0xa9cf9861, 0xf1ec7ccc, 0xf07e30dd, 
	0x6138d664, 0x99ff4798, 0x922c28f3, 0x7cc679fb, 0x7449cd26, 0x937f4036, 
	0x8293afbf, 0xf8faac20, 0xecfcccb2, 0xb3ebd979, 0x379e97e7, 0xa5f607af, 
	0x95f80fbe, 0xfe01c703, 0x0b975635, 0x13a45abf, 0xaaff1fa4, 0x0c81a91d, 
	0x278c9a7e, 0x118a3e36, 0xc1f101ab, 0xfc2214da, 0x30ac69a8, 0x7e135e51, 
	0xaf7907de, 0x411a93d1, 0xc51f35ba, 0x100fea7a, 0x40fbaa64, 0x28ade203, 
	0xcbabed8d, 0x0b86dfc2, 0xdea3d54f, 0x86f27c72, 0xc013c47a, 0x16e5052f, 
	0x194be3e1, 0xa88a737c, 0xbc611ae8, 0x48f9855b, 0xf879f282, 0x096d9c2c, 
	0x024fdb05, 0xe5fac6bc, 0x97cf84a3, 0x7ac83735, 0xdb03ae63, 0xcd7febff, 
	0x337ff9a3, 0xc422b1f8, 0x4862b55b, 0x79cc7d45, 0x037ca989, 0x749f1d9a, 
	0x9f383dc9, 0x492396b6, 0x95512709, 0x426edfcd, 0x8d78057c, 0xaaddf75e, 
	0x5f0ceee0, 0x5470c9b9, 0x67adf4d9, 0x57e7f7d1, 0x87547f6c, 0x9adcdf79, 
	0xbe99d06c, 0xe5cf0853, 0xea7823bf, 0xf9c8773f, 0xc5bfa2b9, 0x9de9a7f9, 
	0x8ea5f5e1, 0xc04fd59f, 0x515fb6f4, 0xbbf6c5fa, 0x5c5f6e08, 0x3fa52f77, 
	0xd68e7e0b, 0x8fb685f1, 0xfe4297d6, 0x92bf9f0b, 0x95bf9b52, 0x0af94bd5, 
	0xfd49a6f8, 0xd7086840, 0xbfbe93e3, 0x07390148, 0xb8f245b8, 0x545ef838, 
	0x88db3c05, 0xa2780774, 0x113a8496, 0xac3df40e, 0xaf2876f7, 0x64cafec6, 
	0xa3b8781e, 0xf7b652b7, 0x8f9567b4, 0x2e1ec708, 0x3ef6c4af, 0x6dce6f2e, 
	0x88f889df, 0x7a4917f5, 0x7a3b1807, 0x67f564f7, 0xf1c21b97, 0x0d377f20, 
	0xfb887fdb, 0xfe9cd433, 0x7481cfe0, 0x03fb8655, 0x1edc5978, 0xd30eeaee, 
	0x051e107e, 0x423f215b, 0xbd4496f8, 0xd810f48d, 0xbc6a5f0f, 0x2991e493, 
	0xa16962e5, 0x20f01efc, 0x87be6c29, 0x256eda74, 0xfdd8be51, 0x62427af9, 
	0xdd0caaeb, 0xda827afa, 0xc3f72836, 0xe11f5b98, 0xdf7e61ef, 0x5c2efa62, 
	0x96cfeb1f, 0x75af81bf, 0xf812de90, 0xf143a0da, 0x3a649ea0, 0x77f790e2, 
	0xffca248a, 0x9dd3d0c2, 0xff1fa071, 0xf703b0fa, 0xf60db0a1, 0x72fdd604, 
	0x01a486c5, 0x5bd6fafd, 0xfca50b7d, 0xbeffe075, 0x9ec7f36e, 0x3f943ef1, 
	0xf3bf0ed8, 0x0ff57f33, 0x5f5b1384, 0xfaca7e05, 0xaa207f96, 0xfab9836d, 
	0x13ef1c6e, 0xe5f8cc91, 0x3cd76bdf, 0xe4219f30, 0x38e26f5f, 0x1fd41fd0, 
	0x6e989aff, 0xd8310b96, 0x5ea24ce3, 0xbbb8363c, 0xc07a81de, 0x28f54343, 
	0x3b470a08, 0x42fad3b6, 0x80a14153, 0x0790ebfc, 0xd03e9578, 0xc9eca9d6, 
	0x9f22a5f0, 0xe29e28b1, 0x75b8e279, 0x740c3f52, 0x775c4e8a, 0xd3bc67b0, 
	0x856b7dc4, 0x203e21fd, 0x9e02623e, 0x110f6e06, 0x17786d3c, 0x189ca281, 
	0x8ce9fda3, 0x11aff943, 0x2eef416f, 0x75c63c42, 0x2e5db476, 0x01fee55e, 
	0xf88eff6e, 0x2fe2780b, 0x62d17995, 0x9afdbe12, 0x7cba44e5, 0xe1ec74c4, 
	0xd676caf2, 0x737f095f, 0xfb80bfdb, 0x25b3f58a, 0x2369417c, 0x67f74c7c, 
	0xe3a61b97, 0x1a6efe41, 0xfee26fb6, 0x7f4e448c, 0x8eb85788, 0xa78936a2, 
	0x83bf8885, 0x57041e12, 0xaf00f3d6, 0xad832e88, 0x81903e50, 0x8937c207, 
	0x4917e678, 0x03d52f84, 0x12437d7c, 0x40dbbe9e, 0xe8cb2e5d, 0x3a3f1523, 
	0x788431b0, 0x981198fc, 0x383efb89, 0xd79959d2, 0x33ebbddf, 0x810bcaed, 
	0x2ddec1ae, 0x59d93d6f, 0x683efb89, 0x19c3c5f5, 0x685e58be, 0x5845e33a, 
	0x025f7cfe, 0xf377ddf6, 0x679c46c0, 0x9f5623f9, 0x9e733e19, 0xc6fdcf54, 
	0x2d1bdfb1, 0x7f306789, 0x35303fb4, 0xc7ef11bb, 0x2c39b73f, 0xcc81d2d3, 
	0x70dd3e78, 0xb4c1bca0, 0xc6fd94c7, 0x07f6e2df, 0xa7f43db8, 0x9d02fd22, 
	0xc38f7a6a, 0xe272465c, 0xe255ea08, 0x19bfe87c, 0x0af8a4e5, 0x974cede9, 
	0x73dccf85, 0x351904c4, 0x8afb1ed6, 0x00f1f2c0, 0xfbf51d82, 0xf3e8e4af, 
	0x17cc25aa, 0x081d3ec1, 0x84ee7516, 0x3d086eef, 0xce27e36a, 0xb092ff0f, 
	0x5514afdf, 0x325b8b15, 0xb6b4677c, 0x17da08e2, 0x27cf27c7, 0xb56c2e7c, 
	0xe3e1b33a, 0x78ee5906, 0x9e61eb8b, 0x1d4bc385, 0x1eb8c3f1, 0x69eb0768, 
	0x4f1f6150, 0x6fa0ef60, 0xbd027f21, 0x868ab52b, 0x84fad0f3, 0xe61579e1, 
	0x583e66e7, 0x711f0b17, 0x23bae00d, 0x976ca089, 0x1bf181e8, 0xfac2c2dc, 
	0xd11ae6fa, 0x19d7e309, 0xea1bad41, 0xba2286bd, 0x127c1266, 0xa98bc029, 
	0x28132af3, 0x7322c6b7, 0x3fae043a, 0x50f0873c, 0xea8aa67f, 0x90873d61, 
	0x40b8364f, 0xd2fc070f, 0x90359fb1, 0xa23f8106, 0x2456211f, 0xf3cc3e76, 
	0x473b2329, 0x0a76c3f6, 0x67b6f5fe, 0x5164f3c1, 0x19f02751, 0xe1d9ca6d, 
	0x82ebc0d9, 0x59e5853f, 0x708a98fc, 0xa9d90a10, 0x070d9162, 0x63ea27d2, 
	0xa7983eb0, 0x9c23c366, 0xe19c4786, 0x20782711, 0x277a845f, 0x6c7effae, 
	0xe1a1e127, 0x733e1e3a, 0x52ac5afd, 0xc32d7cec, 0x51f6d2d7, 0x9117d798, 
	0xe1713beb, 0xb8c2b58f, 0x95fa0f9c, 0x4edc444e, 0x04e77fdc, 0xedfc07c9, 
	0x4e81d542, 0x3e4b16d6, 0xae7f9760, 0x675bca58, 0xd05b84a1, 0x2a576bcc, 
	0xcedf51cb, 0xea12ff2e, 0x5d3f58ba, 0xce69e3f6, 0x7dcb8efb, 0x548d426d, 
	0x4be472ca, 0xbcb2d9ce, 0x7db735b0, 0x50900f51, 0x0dd5df16, 0xb0bdf258, 
	0xfc9b88fe, 0xea185a35, 0x869e717b, 0xd3740bd2, 0xe115df01, 0x5be24d38, 
	0x65ffc89b, 0x70784b1e, 0x826e235c, 0x185ce4be, 0xa768084c, 0x7e22e6df, 
	0x9fb42774, 0xf195ed05, 0x92b309f9, 0x8b7e27da, 0xbdfa79db, 0xa0f7e01f, 
	0xa49a111d, 0x9d5b0fc7, 0x9c332f52, 0xe5865eb6, 0x9ad35f36, 0xc7ec9284, 
	0x415f61ef, 0x8d1bd74f, 0xf01b8f78, 0xd1506a74, 0x6281fc61, 0x6a7307e9, 
	0x089cee52, 0xdfe07ac3, 0xe9a18f5a, 0xc3643750, 0x99aee189, 0xe19cb722, 
	0x8e5875ae, 0x37de729c, 0x2dccddad, 0x6df6e3af, 0xef396e46, 0x52dcb683, 
	0x4531cbb3, 0x0fdec17d, 0xac33f40d, 0xf3265ef7, 0xf2a609de, 0xff12f5f0, 
	0x83eed107, 0xdac3da3c, 0xb0f6230e, 0xda19f205, 0x1a1f5086, 0xb7a82b77, 
	0x5f585168, 0x23b9d788, 0x1aa12f03, 0xe7fa868a, 0x32f76869, 0xf880979a, 
	0xbb07b62a, 0xd309f70d, 0xb66ed0ed, 0xef006a08, 0x10e2a9b2, 0x42de3dda, 
	0x2e744553, 0x0945a87b, 0x5bbd7ec2, 0xd17148ff, 0x3227e85a, 0x4863e69e, 
	0x55f44eaf, 0xf039718c, 0x63fd1d63, 0x04f49720, 0xb8ddfbec, 0xaa9e222f, 
	0xa44a7da0, 0x6ead5fa0, 0x3c022944, 0xda58a57a, 0x38c3387d, 0xd2e8dfd0, 
	0x4f9022a0, 0xfa7cc2d7, 0x0a2c8f80, 0xdfea070b, 0x04fa1f4c, 0x85da6fd6, 
	0x9ffb7882, 0xb41f52c5, 0xdbb69fcb, 0x3a071cb1, 0x72c76dca, 0x5b91d03f, 
	0x91d33cfe, 0x53f65d3e, 0x3bef3cb0, 0x523a072e, 0x1cb08e90, 0xe59d53f5, 
	0x4e51d03e, 0x0523a07b, 0x3f9ec8e9, 0x9fde8bee, 0x9c2d0fd9, 0x1fb0574f, 
	0x91271a1e, 0x82bc210a, 0xae4a6089, 0xdfa3e11b, 0xf7a3c4f6, 0xba32fa48, 
	0x153eb43d, 0xfacebee5, 0x576821c5, 0x9e574592, 0x9fd64342, 0xdfd03f9e, 
	0xd2aba191, 0xddd6b096, 0x0cc776ca, 0xda0e6fea, 0x04ff6949, 0xcda525db, 
	0x22b48fa0, 0x76423e61, 0x2fcbc9cb, 0xd1cb7694, 0xa2fca6ff, 0x9f325cab, 
	0x154ef3b6, 0xfc525da3, 0x4ff271ad, 0xea32ee94, 0x7633f8f7, 0x6a66a8c9, 
	0x71fc4cff, 0x2425aebe, 0x9f7ee33e, 0xc8eb7488, 0x3fde351f, 0x7550cc77, 
	0x89597f98, 0xdcbb0fa4, 0x39f5225b, 0x74b5f78d, 0xef1daf20, 0x5b9a2bab, 
	0xf722525e, 0x0bfde355, 0xc77de474, 0xa861bae5, 0x1cb23d91, 0xdb36a3f9, 
	0xf6dcb3c6, 0x550c0765, 0x3c13f964, 0xd56fb0cd, 0xe4dc5e28, 0xa0467687, 
	0x24f343de, 0x44a138fe, 0x53e047f2, 0x9e3f9947, 0x71a5eeec, 0x976a3f89, 
	0xbf5024b6, 0xe926dcf6, 0xcfda06a4, 0xdc7dc76a, 0x9da53090, 0xe0067f1c, 
	0xe3fd39e6, 0x3f8d9edf, 0x7f36a27a, 0xf1b3d4b4, 0xa9935747, 0x5c3701c4, 
	0xc05cdfcc, 0x9ca3b69f, 0x047a0d38, 0xa34f01f0, 0xde814f19, 0x98ff3a35, 
	0x92edf682, 0x2e6f8912, 0x2cc65f9b, 0x03ee97e2, 0xd2f91386, 0xdd83866a, 
	0xe4407b9f, 0x74bf3396, 0x9cb4b6ef, 0x6e97e672, 0x72e9bbe6, 0xe66e97e6, 
	0xe672e9bb, 0xbbe66e97, 0xc8a63976, 0x2fcc5d2f, 0x9d7fccdd, 0x2f812fcc, 
	0xff4b0fab, 0x4bd832b7, 0x7e45417c, 0x1016d2e9, 0xc4aabcbf, 0x0add97e6, 
	0x90cb89d2, 0xf204effc, 0x697e1cbf, 0x3d07c829, 0x5f89bba7, 0x8700a3ba, 
	0xae07b604, 0x4c1efe89, 0x808b2e71, 0x143d025f, 0x897e4b74, 0x3fc49172, 
	0xfd829f8c, 0x49073573, 0x6ebcb86f, 0x3ae94965, 0xfa074fc2, 0xa02a0b27, 
	0x7783f03d, 0xa4a67c66, 0x8f6cad64, 0xe8a579f3, 0x23a412fa, 0x8d6baefc, 
	0xe47c8f6c, 0x7c8cfb6c, 0xa63805d7, 0xe3f58cdd, 0xbc7a2fa4, 0x4f5df106, 
	0xda5bca42, 0x875c0adf, 0x35d77c41, 0x022d407b, 0xfb89dcfc, 0xf008764c, 
	0x3f53d409, 0x777c9291, 0x0fabac26, 0x5be48fe5, 0x3cee99db, 0x3d457fbc, 
	0xd0f482a6, 0x9cf92253, 0xbb35fe5d, 0xe945e31d, 0xc63b5e40, 0xb9dd928b, 
	0x4308dde5, 0xf36e9fac, 0xa6efbce5, 0x54dc7cdb, 0x1cb13e90, 0xb667aef9, 
	0xb6e54fad, 0xfd203b2f, 0x71fcf690, 0xec3f117f, 0x3ee1757d, 0x98babd03, 
	0xafb85d5e, 0x418e38bd, 0xb733d77c, 0xca0c1125, 0x3c7c2375, 0x609d75b7, 
	0xd9b43bbe, 0x9eabe193, 0xf69eb926, 0x63ae7912, 0x3dd22bd3, 0xff9e9fd5, 
	0xbd167f64, 0x183e46d6, 0x4b0daddf, 0x3684507b, 0xd86d9f13, 0x8feb2956, 
	0xc1fca11e, 0xf32c3f27, 0x807bbe69, 0x381c25f0, 0x76b77c45, 0x4ebbe49b, 
	0xf7155bf6, 0xa5d51f07, 0x96a4ad5d, 0x4d60f465, 0xcc7e520c, 0xd029ed10, 
	0xc7d5175f, 0xdd926e84, 0x3aca9ed3, 0x915828a7, 0x3f72843a, 0x7aff1cbf, 
	0xd1efca4e, 0x892eb29e, 0x4cee3c09, 0x2747f5eb, 0xe3849d92, 0x07af4d9f, 
	0x99d6a039, 0xb7727ad9, 0x0727ad9a, 0xa7922c3a, 0xd5c92cbf, 0x92567eb7, 
	0xf51727ab, 0xeb4bb5e4, 0xcfe5b9c9, 0xf4659e32, 0xa6efbce1, 0x9164f8db, 
	0x4965ff7c, 0xdb9c9ebe, 0x296538be, 0x3bb27ad9, 0x25cf2f96, 0xf27ad95e, 
	0x600e51af, 0x38c64d7f, 0x2df181cb, 0xdcf27ad9, 0x93d47163, 0xbf27acdd, 
	0xef03969c, 0x6c9ea5c5, 0x702fe8a9, 0x7c50de9f, 0x7299c757, 0x9e303dc0, 
	0xfcda5763, 0xe3f414bf, 0x6e467f78, 0x464f41ba, 0x3d06e03e, 0x327ac539, 
	0x9b847df2, 0x393d367e, 0x0e5f1265, 0xc9e9e695, 0xe5d3c7cc, 0x7ccc9eb6, 
	0xeb6e5d3c, 0xd3c7ccc9, 0xcc9eb6e5, 0x6e5d3bfc, 0x3facc9eb, 0x9e98e5db, 
	0xb82e4f4d, 0xd435f58c, 0x8b3e5f93, 0xf408bc9e, 0xb2b1a064, 0x4f4fbfd2, 
	0x3d407f76, 0xf610a0b9, 0x0d29c605, 0xfbcb4ea3, 0xdbaffa00, 0x9db9d16b, 
	0xe45ff59b, 0xbaaf68ef, 0x8a5e0f51, 0xa9715bfd, 0xc82ab707, 0x4a95978f, 
	0x7fc3637e, 0xc1e83e74, 0xc307a83d, 0x2e408afc, 0xaaff4a97, 0xe63e8f2b, 
	0xd7cae694, 0x1f254b0b, 0x47d1e576, 0x6da95dba, 0xc796e65f, 0xb87d254a, 
	0xfd23e8f2, 0x607d1e5d, 0x2b87d239, 0xf6ec3e8f, 0x67387d36, 0x06ec3e4b, 
	0xc3e6c87a, 0x802bd46e, 0x2f4cdc5e, 0x5e90d790, 0x5e41d35c, 0xeeb8bec1, 
	0xfd471639, 0xc5c30977, 0xe292db7d, 0xfc643b7b, 0x1d01fe04, 0x0afe429c, 
	0xe139b0c2, 0xc49af5c5, 0x864d5d77, 0xf71c7de8, 0xa4c36469, 0x2c0e413b, 
	0x9cf4fc97, 0xbdba377c, 0x3e69f301, 0xe217fcdb, 0xb06fafb3, 0x39e419cf, 
	0xa3b4ba9c, 0xdbf10261, 0xdf914aab, 0xaa1eae7a, 0x03f6c52f, 0x9f48a3e6, 
	0xf88b9eb6, 0x1be7da67, 0x8eb91995, 0x5cb217e7, 0x72af5ca8, 0x37d36abd, 
	0x5e643bd7, 0xffc9a1fa, 0xe5c5a94c, 0x7bf26240, 0xd4e7bf8d, 0xe4e172e2, 
	0x3dfc9def, 0x0b9716a7, 0xb8bbd717, 0xcb8b539e, 0xfd931541, 0x4e7fb9bb, 
	0x31072e2d, 0xae75eb21, 0x72e2d4e7, 0x3dfee1e1, 0x16a73fdc, 0xd72f0b97, 
	0x539eb97b, 0x0145cb8b, 0xfdc05ff7, 0xb9716a73, 0x0befe428, 0x2d4e7bf9, 
	0xfe3e172e, 0x73dfc7de, 0xf0b9716a, 0xeb9fbd73, 0x5cb8b539, 0x00ffb804, 
	0xc5a9cff7, 0xf23a40e5, 0xcf7f20fb, 0xa2e5c5a9, 0xe22fbf88, 0xb8b539ef, 
	0x7d73145c, 0x6a73d731, 0xe128b971, 0x7fb84bfe, 0x172e2d4e, 0x297dfca5, 
	0xc5a9cf7f, 0xbf8ca2e5, 0x39efe32f, 0x945cb8b5, 0xd7397d73, 0xb9716a73, 
	0x2bfee0a8, 0x2d4e7fb8, 0xae21172e, 0xa73d710f, 0x4a8b9716, 0xfb92bfee, 
	0x72e2d4e7, 0x55f5c551, 0xc5a9cf5c, 0xfb9aa2e5, 0x39fee6af, 0x4c5cb8b5, 
	0xf027efe0, 0x5c5a9cf7, 0xf7f2262e, 0x4e7bf913, 0x93172e2d, 0xd7127eb8, 
	0xb9716a73, 0x4ffdcc98, 0xb539fee6, 0xb9845cb8, 0x9cf5cc3e, 0x6a2e5c5a, 
	0xee1affb8, 0xcb8b539f, 0xd7d72d45, 0x16a73d72, 0xdc298b97, 0x9fee14ff, 
	0x45cb8b53, 0xc75f7f1d, 0x716a73df, 0xefe7a8b9, 0x4e7bf9eb, 0x0d172e2d, 
	0xf5c0df5c, 0x2e5c5a9c, 0x53ff72a6, 0x2d4e7fb9, 0xae11172e, 0xa73d708f, 
	0x698b9716, 0xee34ffdc, 0xcb8b539f, 0x37d72345, 0x16a73d72, 0xb8f38b97, 
	0x7fb8f3ff, 0x1f2a2d4e, 0x5fa49973, 0xc8a75fe2, 0x27fe77d5, 0xb34291d2, 
	0x71fd2930, 0x1b378c3e, 0xb12739db, 0xdb9e1f63, 0x9f67d57f, 0xb9f9e30f, 
	0x51713e7d, 0xe7485e2a, 0xf5f0bac4, 0x50f975c9, 0x59070cbe, 0x6e6f9cbe, 
	0x9da04736, 0xdc642955, 0x9e0b6447, 0xa67ccc1b, 0xa714e7ea, 0xfd0dfc83, 
	0x3dcfb562, 0xd8f1fa85, 0xe4ed3981, 0x23981e6f, 0xb5be7081, 0x66b3e319, 
	0x4c09355a, 0xdf245e71, 0x36f94836, 0x8fedc836, 0xf4ff21ce, 0x0ba7186c, 
	0xac199bfa, 0x1e41bad0, 0x3d400d8e, 0xd929f5ea, 0xef7f5a5f, 0xbbfa4659, 
	0x19666cb3, 0xbacccfc6, 0x7aacf2b7, 0x1e0fd8fc, 0x73bd47ab, 0x9ea3fbf4, 
	0xa997f8ec, 0x8e1ec343, 0xfc6b38c3, 0x453bda0b, 0x422ff159, 0x3c3921ec, 
	0x1295bbe9, 0x91cfe32e, 0x9de74e1c, 0x564a7d91, 0x2e3a4c7c, 0x5077fbe6, 
	0xef96cc5c, 0x8ff641dc, 0x85ab5e7d, 0x89ec8b85, 0x115c3a4b, 0x74bdc418, 
	0xa38d15dc, 0xc770eedc, 0x75305f20, 0x60aa5ddc, 0xfe89cc7d, 0x97c5d3fa, 
	0x616f6997, 0xc44d0ebb, 0x721c7ed1, 0x9fd49934, 0xaecce782, 0xfd2bfdb4, 
	0xa4ca6b7c, 0x7f9769bd, 0x25da4ca6, 0x9bfdb4ae, 0xff6d2ed7, 0xc6af96e6, 
	0xfd2cc333, 0xa64bf6ca, 0xbfdb4bbf, 0xe588efd2, 0x7adaff68, 0xb507ed97, 
	0x101d97db, 0xb9c97639, 0x2fa88cfc, 0x5ed25da1, 0xae53fd26, 0x5ded7126, 
	0x6d492ed2, 0x0c3d4af2, 0x635712ed, 0x4e25d90b, 0x51dd4ff6, 0xaaf7fd26, 
	0x9d7e74db, 0x13841b82, 0xe61c49f7, 0xfd3f45fd, 0x942a98ad, 0x628108af, 
	0xc9e02af1, 0xdd25bb05, 0x75ba48b6, 0xa679e586, 0x8a1df503, 0x86a9f8f3, 
	0xcfa8bee7, 0xe309dc50, 0x8de79e2f, 0x0e583ed3, 0x68ab9e4b, 0x3a13a4a6, 
	0x8f6ad357, 0x5e7c530d, 0xfe7788d0, 0x99311e52, 0x2c617c59, 0xc6261294, 
	0xbb4875d9, 0x31dfc6d5, 0xf0f1e321, 0xccecc928, 0xe73e9f6a, 0x4b9d28fb, 
	0x07df9e09, 0x4e3d27c1, 0x8f3f84f5, 0x865bdc95, 0x73b4227a, 0xa7c44cc4, 
	0x79b66398, 0xbfacdc26, 0xcf7f6e13, 0x4f9a347c, 0xbe3c434c, 0xca5ff8ba, 
	0xbdcdce30, 0xa801c874, 0xd446ed03, 0x63e659e8, 0xfc76161c, 0x4f9a07d7, 
	0x9be5ed5d, 0x9b395f91, 0xa76e286b, 0x0a8fe1ae, 0x4f34e5c5, 0x3f01744b, 
	0x55c48faa, 0x75a95f59, 0x1cc97a63, 0xedbb0eb5, 0x78e35470, 0xf1563787, 
	0x843f41fa, 0x438c4575, 0x40f082d5, 0x004d9e78, 0xd59b74db, 0x7f7213bb, 
	0xe30f7b9e, 0x59f8eca0, 0x533c60a1, 0x95160fda, 0xc185af78, 0x2ff4933e, 
	0xff904eba, 0x55cf1aac, 0x5a69e6b5, 0x63efcc37, 0xfb46ff45, 0x74d735a2, 
	0x764abf75, 0x377e157a, 0xd3ccfd8d, 0x8d3c1fd8, 0xb95765ed, 0xf4ec3fb4, 
	0xf38c9954, 0x8e7b2eaa, 0x75e345f8, 0x92eafa8f, 0x086f9b30, 0xdb6723d2, 
	0x37936df1, 0x9d2e91c4, 0x07b3ab11, 0x4ca47cf0, 0xfcd9439e, 0x9064d9d1, 
	0x0a59d65f, 0xaec65169, 0x447cc13e, 0x78a22c8c, 0x743f77a6, 0x81c7ed1e, 
	0x6f3413f2, 0x45294f18, 0x86b7be3e, 0x7d66e9ce, 0xe188bcc6, 0x59c17e41, 
	0x422fc733, 0xba6b3c7e, 0xbe1f914c, 0x863be583, 0x3238c22e, 0xa586d3f8, 
	0xf089d283, 0x18c2440e, 0xfdfb43c3, 0xe0fb42bc, 0x70d4a11c, 0xaef32abd, 
	0xdcee9293, 0xb6ef32e3, 0x47ebca54, 0x8c170955, 0xfffd267f, 0x71373a25, 
	0x16b9fee0, 0x9fbe110d, 0xc165b711, 0xd666b7d7, 0x29735225, 0xdbf4f0ee, 
	0x877139e5, 0x6730b8e9, 0xc4c1a26b, 0xe9182df8, 0x3d8768cb, 0x22b2d2aa, 
	0xfcc35f60, 0x15c735a7, 0xe151cf1c, 0xe5dad72e, 0x85bdf878, 0xbb9414f6, 
	0x855c96d1, 0xce90e9f1, 0xf9a73c20, 0x72d78898, 0xb2e2853c, 0xc0e7894c, 
	0x38ee08eb, 0xcd9f926d, 0x5a3fc921, 0x2370ff24, 0x7f508c1d, 0x88506b96, 
	0x19e99a19, 0x7d807822, 0x5b7ae302, 0x43c60144, 0x0a3a2a7a, 0x837eb442, 
	0x5b014bfa, 0xa0d4f1c3, 0x6307e749, 0x23a21efe, 0x0c47a5b3, 0xc7ac1303, 
	0xd7c074f3, 0xe7e2a886, 0xfd152438, 0x0b635305, 0x6bbeb8fc, 0x5d5da5cb, 
	0x97d8017f, 0x85038fc0, 0x09b8c142, 0xc588d4ad, 0x215e0cf5, 0x3ac92acf, 
	0x848e169f, 0x7519fd1f, 0x270aab75, 0x0ba7089a, 0xd4f5b5ca, 0x5579e7bf, 
	0x6a0bd9d2, 0x21862e06, 0xdda26dd7, 0x4ae30ab6, 0x8f189e01, 0xf502f203, 
	0x7de7821e, 0x3ba1b819, 0x6335d704, 0xc52f5f53, 0x21c4c559, 0xb0f6f38c, 
	0x2bd6031f, 0x2e98b5cf, 0x2e2d79ec, 0xa760f497, 0x039eba63, 0x9a9f5867, 
	0x8ec738c4, 0x956548a0, 0xf25c7d8f, 0x94caf31f, 0xcf0c1618, 0x7da6fdac, 
	0x7dcced7e, 0xda07dfcc, 0x21bfb6bf, 0xc3994037, 0x99cd28f9, 0x8dc9b3f2, 
	0xfd1bceb3, 0x49f34150, 0xe6fde71c, 0x7c24500f, 0x4eed3fad, 0xf9058798, 
	0x463ee967, 0xbc60a9ad, 0x29652b8a, 0x89a7a718, 0xdcacbf57, 0xe4abe387, 
	0x8bae1d6f, 0x4c004ea1, 0x0f71463b, 0x74a7a025, 0xc58d8d02, 0x8b9f5262, 
	0xc6385c72, 0xf996bf03, 0x131a9ace, 0x9c96661d, 0xf492bf6b, 0x0f8c3abc, 
	0xfd27f3c1, 0xf1841690, 0x61ae22c3, 0xfbae327c, 0x5f7fd66d, 0x5ff50f79, 
	0x8dfede79, 0x3ef7e972, 0x027e793e, 0xe9cf19f1, 0xf183cfb3, 0x9bf91e5c, 
	0xbf882a56, 0xa147fed9, 0x559eea1b, 0xe89597c4, 0x1e5f7293, 0x3ffd097e, 
	0x40a7e526, 0xc893a1bf, 0xde893aef, 0xe276f445, 0xa91e1317, 0xfe947de1, 
	0x14f31993, 0x05be24c5, 0xa79e37f6, 0x1ef9060d, 0x1ee1d808, 0xb7cbc7c4, 
	0xf844bf35, 0x7e866819, 0x81e2a667, 0xd6771866, 0x4f9443ee, 0x8c0638c1, 
	0x0bfc88d3, 0x77f661e8, 0x663104e6, 0x0fcde2e4, 0x69276706, 0x8597da1c, 
	0x37dd5b40, 0xc637ff4a, 0x278c1903, 0x99c93fd8, 0x6b922296, 0x83f4ba63, 
	0xf70961ab, 0x8139aee8, 0xacf5d018, 0xe802a7fd, 0xb9c7b547, 0xea1adb68, 
	0x7d83e2ff, 0x6fdfe429, 0x2e59bf07, 0x6ef066d6, 0xecadc717, 0x5546ec7a, 
	0x4eb4c5e9, 0x7840fdc5, 0x3c207ee1, 0xe1b69f50, 0xe972e5f1, 0x7e503db7, 
	0xb7fc5ca0, 0x07ed2384, 0xc7af39fa, 0x83cb49f3, 0xd15e77f4, 0xb9d394bf, 
	0x9e4385d2, 0xa4e49552, 0x7eb8714e, 0x162ef443, 0xd0a5e818, 0xf7582875, 
	0x5d6666b3, 0xdcd5114e, 0x79863720, 0x989163fe, 0xe30427b4, 0xcfbade73, 
	0x7be6f7e0, 0x57897744, 0x8bfdcb66, 0xdfbf1155, 0xf9913bdb, 0x3667ec2f, 
	0x7e3c07bf, 0x30fdf88b, 0xffe6d7cd, 0xcde32822, 0x6f09de89, 0xef10f7ac, 
	0xf9b7ba6d, 0xfbf30140, 0x221bfd34, 0x8a83fe87, 0xfd34f946, 0x8c3e4b97, 
	0xcfa85f67, 0x2456d68c, 0x357f1fb0, 0xf251ffec, 0xfd221733, 0x5ed3a409, 
	0x152cae34, 0x4e888be3, 0xaf974c3d, 0x7241ce65, 0x52f512e8, 0xe5afed93, 
	0xa6c32f7c, 0x24dcfb47, 0xd5c51e9f, 0x02fe8f44, 0x06fc4711, 0x3c41423d, 
	0x02c1d6d0, 0xc0b38e31, 0xe84a623c, 0xcca9e91f, 0xb2e7cfa5, 0xe99c73e8, 
	0xdc3d39d3, 0x1756788b, 0x73cfa5c9, 0xc2fa1fe9, 0x8e21a3e0, 0x49f87b2f, 
	0x12b89fa4, 0xf4ceb925, 0x3536fbba, 0x3f666b7a, 0xd46aeaeb, 0xc5fbb4a8, 
	0xe38784bd, 0x076fcf84, 0xdda3954f, 0x65d78398, 0x7f3c3fb2, 0x9f08fec2, 
	0x1660bfa1, 0xc696bc7e, 0xe302b567, 0x05ff10e8, 0x67b66ff7, 0x9f60dce2, 
	0x9c9ca30e, 0xf123fa71, 0x57f7e91e, 0x36771ed1, 0xd80f4a1a, 0xa90abe2d, 
	0x6f77d1a7, 0x3c23b2a1, 0x71ce8fb8, 0xd37674a1, 0x034785f9, 0xb974fa39, 
	0x06f502bf, 0x47a123fd, 0xfec44f51, 0x82eb0f88, 0x3fb145ce, 0xfae7c3e4, 
	0x0ed0ff1e, 0xab8e74d6, 0x73d13e07, 0x204f8655, 0x4d3ee0e6, 0x4e7290aa, 
	0xfdca096b, 0xde6e933f, 0xb6ecb333, 0xe8073f7c, 0x9788d5a9, 0x50d7d05e, 
	0x2246f6af, 0x4c36ae89, 0x5b793e25, 0x5693862c, 0xc5f7f48d, 0x7292ce2f, 
	0x2d59b96e, 0xec64f0b2, 0xacfeb4b2, 0x9ecfeb66, 0x7a3f4966, 0xdecdea58, 
	0xeb37a916, 0x5b9d0891, 0xa2e8ac7e, 0x3d47a40a, 0x6eeaee12, 0xf52e3643, 
	0xc7dcfb66, 0xe7b1cf3e, 0xea42acbf, 0xcf9a76cb, 0x3d3d6c17, 0xa84ff743, 
	0x973ef3d9, 0x7de6785e, 0xe5011814, 0xf983eb04, 0xafc851f7, 0x5237cd9e, 
	0xccb1c682, 0xdb60be5c, 0x38376039, 0x9e908f98, 0x0395f607, 0xb31dd729, 
	0xac7b2e28, 0xff63953c, 0xb734cd8c, 0xa29a7c71, 0x31570dc9, 0x367f594c, 
	0x63979761, 0x15e70db9, 0x63961747, 0xa38af81c, 0xc328e987, 0x704652dd, 
	0x46a1e879, 0xe9a6dfba, 0x0af78aa6, 0x7c2704c1, 0xa50cebd2, 0xaeda780f, 
	0xc3df690a, 0x1373cb3e, 0xced8a390, 0x51585979, 0xf34e3852, 0x4d7b6c84, 
	0xbf1d367b, 0xd6bbf64d, 0xfc71f5a5, 0xb10d14c0, 0xbe8efda4, 0x1d8c01ce, 
	0x42e5c458, 0x5b7c5f96, 0xfd40369f, 0x9e60504e, 0x02c73c29, 0xc746d6dc, 
	0xbe8135b7, 0x5399fdab, 0x69452731, 0x9c75a731, 0x71a9cc5e, 0xe0af4cab, 
	0xbf4e46f4, 0xa8f9a9c2, 0xdd39fb4c, 0x38f7e9cb, 0xf4c94eb5, 0x39474e19, 
	0x62a733fd, 0x14535f6e, 0x3fe997c7, 0x7845dc55, 0xe2f0fee0, 0xe63d72d5, 
	0x3bbb8434, 0xdf3571b2, 0xeb869b5b, 0xcef87f73, 0x9dec1ad5, 0xe8887e88, 
	0xd1f91dce, 0xe418ed6a, 0x4c921fc3, 0x5ea4b74f, 0xf7a41211, 0x854e786a, 
	0x793121f1, 0x9b0de84e, 0x377a8aaa, 0xd1ca23ee, 0x01728963, 0x0a86f6fc, 
	0x9fd147e9, 0xea36c1fd, 0xea5ce8ff, 0x1543d41f, 0xc70572fd, 0x921dbf60, 
	0xa59f12be, 0xe5f98abc, 0xcb6e3215, 0x35fde42d, 0x6f5ba427, 0xda1abc46, 
	0xe2f38856, 0x9807d2b8, 0x85f3e47f, 0x2d6c68b1, 0xc5cd7bea, 0x419b8f2c, 
	0xe7cb64fc, 0x024bf6bc, 0x1fbe71e2, 0x7d4b8e1a, 0x38fe43ca, 0x3e2807b0, 
	0xc647b000, 0x949e5b17, 0x58bdc3b4, 0x11f9e3af, 0x7df2d7e4, 0xc23f3a02, 
	0xdc3375ef, 0x07f912f7, 0x21e3df04, 0x176d81bf, 0x80763224, 0xdb1aec93, 
	0xf5b4e45f, 0x0635d372, 0x1593e5f6, 0x7f7f9e32, 0x06abb567, 0x9b25ccec, 
	0x4034964a, 0xd3a3adba, 0x02a87c89, 0xe8b3ff49, 0xfb7d01cf, 0xa7d6916a, 
	0x3f92ef81, 0x93c3f884, 0x915f77c8, 0x80fd027c, 0xde607f90, 0x7e90bfdd, 
	0xda026348, 0x19540f53, 0x38cd3d75, 0xc1eb556f, 0xeb4314ef, 0xc8bf7581, 
	0x8c01e2f2, 0x96f9c6b7, 0xf9a4ef2c, 0x8c04c6ea, 0xbd9feb53, 0x5e03afd8, 
	0x759a17f4, 0x7d0780bd, 0xf0ea8b6d, 0xd4bef8be, 0xd3dc5ae8, 0x5ee6bc07, 
	0xc2cd9bc4, 0x6f38422c, 0xa16a5edd, 0xa7afadbf, 0x613d4353, 0x276b9c2c, 
	0xd61e892c, 0x780f5d70, 0x0653078d, 0x9441efcd, 0x32f5b513, 0x43c7192e, 
	0xaf7ed8ff, 0x53f887d9, 0xc3e41179, 0x941eb798, 0xeeb35e7e, 0xbbdf9861, 
	0xe028ef30, 0x6fc692c5, 0xa47df1f4, 0x5a0fdc3a, 0x1f5e32df, 0xe30efbf4, 
	0x57d659cf, 0x6018f787, 0xbeff341e, 0x3ceb7b1d, 0xacc9c20a, 0xe1f5ed33, 
	0x4d16dbba, 0xf387f941, 0xeb473645, 0xaffda56c, 0x7ada3c43, 0x96ef5c97, 
	0x97afb3b6, 0xd78ab7d6, 0x8eb32cbd, 0xbae58bca, 0x82af1c12, 0x3005a471, 
	0xdfcdfecf, 0x176c722e, 0x8e10d0a2, 0x83c071d4, 0x067657db, 0xaf305fa1, 
	0x84341f28, 0x3de24a96, 0x21cf7934, 0x12f19218, 0x5fcd93b5, 0x7403fea0, 
	0x4f007a20, 0x5e291694, 0xfc829f31, 0x40bbb002, 0xa9d28812, 0x585ef1e2, 
	0xf152e957, 0xcfcd1f78, 0x37bc4a0a, 0xe7f78883, 0xd2230bb4, 0x0e5d689f, 
	0xd6ede029, 0xf3176d0e, 0xfff829f9, 0xf3b39fad, 0xb87e1166, 0x0ae011b5, 
	0x00054ceb, 0xf7c8803f, 0xa883c5fa, 0x36dcd56f, 0xbe05453c, 0x2341be1d, 
	0xef816eb8, 0xd73e6f09, 0xb8e30bb4, 0xd9df5afa, 0x967af789, 0xdda19c20, 
	0xeee78bd6, 0x7d35fbc2, 0x113bd3d1, 0x31759b5e, 0xf1c41125, 0xfdd1769b, 
	0x7f7936d9, 0xef83be96, 0x7491dfdb, 0x91f184b7, 0xf3c03bbe, 0x44e9f9a2, 
	0x82daed7f, 0x2fb8ddba, 0x7bad14e6, 0x9317f480, 0x973a2be8, 0xb5ac7f88, 
	0x1ebd9b73, 0xdda39fe4, 0x3be1d437, 0x16dba30b, 0x668e85d5, 0xad7d0efc, 
	0x71e894da, 0x1451271c, 0xabc1664a, 0x0fc931f5, 0x43803fb9, 0x2ca3c611, 
	0xffb07d61, 0xc6de77c6, 0x374c09d8, 0xedca640f, 0xc5fb377e, 0x9f5cf1b7, 
	0x76e01dda, 0x2eb5beb0, 0xfdb80f79, 0x0fa8b30e, 0xc25f59f8, 0xefc72811, 
	0xbc22cd0b, 0xf407d0a7, 0x65757488, 0xfd93ea48, 0x63cae4cf, 0xdce83211, 
	0xe32be70c, 0xba0520ff, 0x1cfc825e, 0xcc25a6ec, 0xc99ffbdf, 0xf6f9e7e5, 
	0xe8c4ba3f, 0xe82b715e, 0x14ce5201, 0x27df126b, 0x60d53f90, 0x7d13483b, 
	0x4bfb42cf, 0x4afd793f, 0xa2751fbc, 0x96f1a2d5, 0x26ea630a, 0x08b06b8a, 
	0x12c696cf, 0xfeef940e, 0x9f80a408, 0x8a355fa3, 0xa58091f1, 0xbda987cd, 
	0xae5b19ff, 0xb947ee2f, 0xb173ecbe, 0x61cfbc3e, 0x6d1f17eb, 0xdf00f685, 
	0x0a17ab65, 0x7fd8e3cf, 0xb0fd7beb, 0x3eb4fe1f, 0xdf8938b0, 0xfbfe58f9, 
	0x079c83d7, 0x35e8517e, 0xf1ded1fa, 0xbe09e9e5, 0x52e0fd3c, 0x75b137be, 
	0xf9c499a6, 0xf05f58fa, 0x63e07eb1, 0xfac7c0fd, 0x03f58f81, 0x3e07eb1f, 
	0xac7c0fd6, 0x3f58f81f, 0xe07eb1f0, 0xc7c0fd63, 0xf58f81fa, 0x07eb1f03, 
	0x7c0fd63e, 0x58f81fac, 0x7eb1f03f, 0xc0fd63e0, 0x8f81fac7, 0x9b7f03f5, 
	0x41d793b5, 0x8196e7f7, 0xfb4c509e, 0x6584f525, 0xcb1427a0, 0x1613d27a, 
	0x88e5c4f9, 0x08df7877, 0x2a9fece9, 0xbf508676, 0x81c93300, 0x1b6fe8f4, 
	0x1f7d99df, 0xc7be52ff, 0x8bf40cbc, 0xfd672c52, 0x17e81962, 0xac3f88a5, 
	0x56152c5f, 0x6678ff45, 0xb0184fbf, 0xb10a37af, 0xc2282c58, 0x2cc062fc, 
	0xcff2fbd4, 0x490def1d, 0xb7c194f9, 0x7aaf7921, 0x9c9da71d, 0x6074e4ee, 
	0x3ebfde5c, 0xb8f0e9c8, 0xa725ff2c, 0xa9bbb123, 0xb54e4dfc, 0x79537739, 
	0x5be1a739, 0x4e4cf965, 0xcb2add17, 0xf5b4e2af, 0xe3ae9951, 0x9dd393b4, 
	0x929c0e9c, 0x74e41ddf, 0xff2c94f8, 0x7323a725, 0x37fb3de4, 0xe8557a65, 
	0x4c77c110, 0xcbcb2b9b, 0x0e75c539, 0x79073af2, 0xcebc839d, 0x94675e41, 
	0x75e519d7, 0x073af20e, 0x5e519d79, 0x39d79467, 0xe41cebc8, 0x9d794675, 
	0x20e75e51, 0xd79073af, 0x1cebc839, 0xf20e75e4, 0x9d79073a, 0x94675e51, 
	0xebc839d7, 0x0e75e41c, 0xb3073af2, 0x3ae36bee, 0x839d7907, 0xf7398784, 
	0x0f6bdda1, 0x2e52c3c4, 0xa253fae5, 0xa57b257f, 0xccad4f78, 0x9d9097eb, 
	0x20d05ae4, 0xa22d7ef5, 0x6967e036, 0xe08c68fb, 0x70c57cea, 0xd5ba3f90, 
	0x60c278a2, 0xcc1c5e9e, 0xfe6d9bd3, 0x79ef97bb, 0xe8b86ded, 0x0bf48f72, 
	0x789ea094, 0x62b9f1a2, 0xecca9f79, 0x8a797947, 0x10deecf9, 0xbc16ebfc, 
	0x7edd1b17, 0x6b47fa3e, 0x5969b687, 0xfe6349fc, 0xb733163e, 0xdd91fd31, 
	0xf694a9e4, 0x174e3a4d, 0xe6ef2bcf, 0xbb2cb0f8, 0x1d21db12, 0xabc829d8, 
	0x2f9f74b5, 0xae34e528, 0x1e66eba5, 0xde0640f7, 0x3fbd3cc1, 0xdbf7a798, 
	0xe582b2fe, 0xa4acbfb6, 0xef5ded12, 0x65fcf227, 0xd03277ec, 0x37f65cae, 
	0xfa564efc, 0x9dfa4d1c, 0x3bf7c81f, 0x75e616ed, 0x9a77ed22, 0xb47ffece, 
	0x0b3de523, 0x0966dfbe, 0xf449f7a5, 0x13fd5c77, 0xdb3baff2, 0xb2df64e2, 
	0x0e19d7df, 0xf15b1b6b, 0x8d3e7d58, 0x61297283, 0x52c91fa2, 0xa2733f50, 
	0xcb26aa7f, 0x863d353f, 0x43f2caa0, 0x2638bfb1, 0xf4e753fd, 0xa5eeed4b, 
	0xe9ffd0f3, 0xc7738b78, 0xd73f4861, 0x0ef12b47, 0x969bfa21, 0x6fe19e56, 
	0x9d6a3f22, 0xafadf782, 0x167694ac, 0xdf91cb9e, 0x03d5fd02, 0x0d5fc01f, 
	0xb430f428, 0xef295e5f, 0xc7f68b07, 0x48e5ce09, 0xbfafd07f, 0x89e13972, 
	0xce887f3e, 0x30bab535, 0xfbd261f9, 0x2a13ea79, 0x32c867ee, 0x7befa85d, 
	0x88391f9e, 0xb960bd72, 0x2999f941, 0x307e85c5, 0xba5c97b0, 0x41ab4ff4, 
	0x3d19efd8, 0xa77de887, 0xfe412ac6, 0xa3b66aa7, 0x220bc604, 0x8796187e, 
	0x2123a6fc, 0x5f7d2411, 0x4678d79e, 0x478bfada, 0x25abe332, 0xe7a813bb, 
	0x050d53af, 0x90f5eff5, 0x282efd22, 0xf2a552fe, 0x60038427, 0x3fef107b, 
	0x6ff25e2a, 0x8cfbe31c, 0x2c1f1947, 0xb07e23c8, 0x85ac72ff, 0xd631cdf3, 
	0xbbee4487, 0xeff8e938, 0x398fc8bb, 0xbf6777f1, 0xb2b9e9d7, 0x65d910e5, 
	0x1d93a18a, 0xda3aaba6, 0xf497602b, 0xca69b9e0, 0x57b473a6, 0xbbd82ed0, 
	0x71b7afc0, 0xe40ef53c, 0x80274093, 0x2323b3df, 0x5b389f64, 0xb4fa8a85, 
	0xbe9d006e, 0xa0dff284, 0xd78f10f3, 0x673b6388, 0x1e29d2c4, 0xc8a8fd1b, 
	0xec338c7f, 0x03ce0493, 0xdea04fef, 0x1d637c48, 0xd2661fbe, 0x91c80a7d, 
	0x407dd9ff, 0x074adffa, 0x7dce3fa4, 0xe14fbe40, 0xc9e9203e, 0x0fd2131d, 
	0x67550917, 0x579869f3, 0xfa6e1fae, 0x61b1cfd9, 0x579d0a9e, 0xce1fa587, 
	0xebf3e31d, 0x7bad1103, 0xfb70fd04, 0x6b9f912a, 0xe739c207, 0x6e7c65d7, 
	0xd0f1c65d, 0x7f127565, 0x7c92ad1f, 0x474e16f9, 0x108fd8aa, 0x9acd5119, 
	0xce1971ac, 0xd4874363, 0x0fdc1afe, 0xeb03dbc3, 0xc3af54fb, 0xf162fb8b, 
	0x7f14d47e, 0x0fce92bf, 0xfd72df01, 0x79df1ceb, 0x16ef41be, 0xe886eb39, 
	0xb74c79fc, 0x82e5f8d4, 0xcae4661b, 0xe28354e8, 0xd8219daf, 0xcf9c0aa7, 
	0x0d313551, 0xb6c7adfd, 0x97561e20, 0xf3c4a91d, 0x0f1ff2f5, 0x6ff5f3c9, 
	0x73cdb8c9, 0x553faf9d, 0xe57f7999, 0xffaf9d6f, 0x47c652a2, 0x3937e30b, 
	0xc02b7472, 0xe8f1c845, 0x7cfa425e, 0x1175ba7d, 0xd7f249cb, 0xe7195acd, 
	0x4e8376f3, 0xb12d674f, 0x2f4ddfcf, 0xeddb8fd5, 0xf9c3dad1, 0x18627f49, 
	0xb9e574e3, 0xe1c7bd05, 0xf47e131c, 0x6b9acc1f, 0xbd16f7f1, 0x89eb3736, 
	0xe79e5e74, 0xf3172bb7, 0x7ff80578, 0x8e05baed, 0xde7e50b9, 0xd7ba3e8a, 
	0x74579e7e, 0xb9eedea2, 0x1c11d8f4, 0x6b53f1a7, 0x79cfd186, 0xa7bde31e, 
	0x0e292471, 0x9a897109, 0x1877df98, 0x335affea, 0xe6175df2, 0xe77f32e3, 
	0x884f9914, 0x6db9e30f, 0xe30d9de3, 0x1cb175df, 0xb6f3855a, 0xdd5fba14, 
	0x4bedcf22, 0x5223bd6d, 0x78c77a41, 0xc6f94ab3, 0x08783d4f, 0x917987c7, 
	0xf08c9a7c, 0xe4cce794, 0x07e4b98f, 0xe8b95397, 0xe347fa90, 0x6a47e946, 
	0xf81237ac, 0xbd635bfe, 0xfaf189d9, 0x754d1b8d, 0x8f9a21f7, 0xe00fbbb2, 
	0x1bfd2554, 0xe9c115da, 0x3f966762, 0x2754d2f3, 0x29139bde, 0xf4fd1873, 
	0x0d0abfd5, 0x5bfaff63, 0x15fa77cf, 0x4968677a, 0x2f3c22ef, 0xa3ba5f08, 
	0xb0bfd68b, 0x7e3dfa0f, 0x7b9a0d67, 0xe486d262, 0x604f3dc2, 0xd60b4d79, 
	0x61ebff1f, 0x2c71fbb1, 0xaef94fbf, 0x85cdf1c0, 0x5e58c37d, 0x177af91f, 
	0x074d8b96, 0x33b4ecb3, 0xabfad3e0, 0x5484f85c, 0x33e67f7a, 0xfca32ebf, 
	0x17dcd725, 0x3c0c890f, 0x92fc4f8e, 0x536c7e42, 0x7a4d6b9e, 0xbd0163bb, 
	0x875ba2cf, 0x717ed9e2, 0x837aff3e, 0x64bd53f1, 0x6c1fe288, 0x2c2cf6ff, 
	0x37f2137f, 0x38a4e82d, 0xa0f52106, 0x0f8f6f49, 0x49ce1c53, 0xc07a43cb, 
	0x5b7125fd, 0x4bfac03f, 0x78642eaa, 0x1c238e2e, 0xc6b47eed, 0x79eb8216, 
	0xdf925f2b, 0xe8143f2f, 0x82f4f4c4, 0x983b8c4e, 0xf8e872c4, 0x89c6afa4, 
	0xf45d7e9f, 0xe3151ca3, 0x04bbe40b, 0xfba11fe3, 0x37bf3af5, 0xeb827480, 
	0x57c02a77, 0x5437c41d, 0x54772f14, 0xa20aafce, 0x5dab79fc, 0x1f248a51, 
	0x823bf7c7, 0x3bab43cd, 0x5e0d7141, 0x33f521d5, 0x0a0c738e, 0xc06fea53, 
	0xc5fc2447, 0x8dfe1147, 0x21729f57, 0x2e55271c, 0x34be42ab, 0x1bbaaff9, 
	0x0f00a0e3, 0x2e7c2137, 0xfc3d8680, 0x9dfe230e, 0xfbc9ff0f, 0x27531437, 
	0xdd261daa, 0xb5ae3817, 0x17944d8a, 0x7b5137bb, 0x03e1246b, 0xbf70c3b6, 
	0x050ec5e0, 0x6df9d5c5, 0xe8ce2887, 0x85c57682, 0xcf1d3ef8, 0xfca14787, 
	0x17a85fea, 0x2b1e71c4, 0xe56f90aa, 0x65d1a3cf, 0x6b8e50fe, 0xfab326b5, 
	0xf008f1b5, 0xb5fc4157, 0x2e9b1ffb, 0xce07c7b6, 0xd4e3cfbc, 0xa36d79e4, 
	0x9f07a06b, 0x7ec49beb, 0x5c816133, 0x351ff844, 0x3327be94, 0x0fa739df, 
	0x99952b0c, 0xcdfc6df1, 0xdf04a7d7, 0xf29b185b, 0x2f922afb, 0x51af7f88, 
	0x3bbd20bc, 0x2f9c7bf8, 0xd404e1d0, 0x14c7aebb, 0xfb1b8bf8, 0x4dff271f, 
	0x1e408e5a, 0xa16338fd, 0x7f1cabdb, 0xf9c79aca, 0x1efd0511, 0xb6e4fe8b, 
	0x6e7410fd, 0xaf165d51, 0xcef3e6ca, 0x10f88f1b, 0xc0bdc5ff, 0xcdcf7bef, 
	0x7d5537ef, 0x6daa78b0, 0x354f1c55, 0xde8e6af8, 0xfde7cf96, 0x2d72d095, 
	0x4c6fc1d0, 0xc42b7f9b, 0x3902df8f, 0x0acde306, 0x76845f8f, 0xaadc3e5a, 
	0x1b21e29d, 0x816f14ae, 0xc19e36f8, 0xf630a737, 0x77a8f5db, 0x57031cbb, 
	0xc7443be2, 0x2dc2f0b5, 0x539c57c0, 0x7abc15c7, 0xca159ae3, 0x4dfcdb89, 
	0x0f9a3ee8, 0xe165f9c5, 0x11c5f399, 0xf1057cf5, 0xbbe13f6c, 0xdd233feb, 
	0xdeef1033, 0xb99e114c, 0x776b0eee, 0x0c7e91c5, 0x91f3bedb, 0xda6cd77d, 
	0xd5f30579, 0x09577e4e, 0x5fd27df2, 0xb8ed187e, 0x17c9a2d9, 0xeef5be04, 
	0x3ce9f37b, 0x91ea126a, 0x2bdeef40, 0x77ef4452, 0x85523e54, 0xc0ff55f7, 
	0x3a0cfdfc, 0x7695fa05, 0xa18beb15, 0x5c61561f, 0x675f8d82, 0x5a21ffee, 
	0xbffb19c7, 0x73dff607, 0x69fffdee, 0xf79307d5, 0xbcb1574f, 0xc5f3c94f, 
	0x7bcafbd0, 0xc267dfb9, 0x1652f80f, 0xffd93a3d, 0x44a97048, 0x55573cb8, 
	0x3accc7f4, 0x557eea4b, 0x19867145, 0xbb62f23a, 0xe1a5787c, 0xbd0f7cc8, 
	0xc73a718a, 0xdbfbb3cd, 0x9fe68bfe, 0x603ffbb6, 0x5fba9cdc, 0x03b28bca, 
	0xffd90a3d, 0xf65a4e7c, 0x9f65204f, 0x5000ff44, 0x607bce36, 0xf69717d8, 
	0xbedb27ad, 0x984dc74d, 0xca9d7ed2, 0x78e93ce7, 0xb3a7bc3a, 0x7c2dca8a, 
	0x0764105f, 0xe3e685e9, 0x0d0617ac, 0xc716ebca, 0xc7d9e5db, 0xf9eb39f6, 
	0x288bdfa0, 0xc4e6a3c5, 0x0666b9d3, 0x9679c2ef, 0xade6277e, 0xbcbf6953, 
	0x589d21d3, 0x022bbb14, 0xb1e4b9eb, 0x3f7a0955, 0xe369ed8f, 0x061894d2, 
	0xc21cd0fa, 0x347377c2, 0xcf811fdc, 0x87a4a93f, 0x1d549b79, 0x522baef5, 
	0x83bf6987, 0x7a7cf2d5, 0xfbbf622c, 0x7c0aa40b, 0x1627d0ad, 0x5e658b24, 
	0xdd800b9e, 0x27d924f4, 0xccb7b471, 0x402e67eb, 0xfd826a3b, 0xa0fbfe7d, 
	0x6c93b611, 0xc93b603a, 0x00b89910, 0x7179b7e2, 0xf17b5a45, 0x5c03e359, 
	0x52ffb491, 0xe268f5b1, 0xa0a1bab7, 0x5470127f, 0x2ba4bf41, 0x1e497ec2, 
	0x5cb170b7, 0x3306f1c7, 0x67c5029e, 0x238cb56e, 0x64f7daf4, 0x1ef19a17, 
	0x35667ef8, 0x3c732f9f, 0x680aebbb, 0xbae9fb0f, 0xb645ea14, 0x9b1fe65f, 
	0xc74d8147, 0x147e220d, 0x61583ddf, 0xfb428fc6, 0x0e32d5c5, 0xd7ed1feb, 
	0x74ae9f96, 0xcff4811c, 0xd141a338, 0xd8b26909, 0x1bf68438, 0xd92dc7ec, 
	0x9e7a4b71, 0xf3cf483f, 0x9b9fe507, 0xac16007a, 0x7da83b87, 0x20acbf9e, 
	0x73c61c60, 0xf5273a55, 0xa739cc88, 0xd7def121, 0x2fe81c26, 0xf549cfb3, 
	0xfe5bff3c, 0x607869b9, 0x0b71cc38, 0x0a0bd44e, 0x812a7de7, 0xeaf7befa, 
	0x67f446d8, 0x71235d78, 0x45176fd4, 0x0046d667, 0x2a5b2f5f, 0x3d2ce6c4, 
	0xa5bd5167, 0xd3b9636e, 0xccf3f30a, 0x069f1838, 0xa8cef7ed, 0x7200267f, 
	0x26b47747, 0x89684f50, 0x264df745, 0x2172df7d, 0x9cc7f6dc, 0xc0fe5714, 
	0x8438ffbc, 0x8bd5dce7, 0x180b8f54, 0x85cebec8, 0xaba046ae, 0x969b0da5, 
	0xfd450034, 0xd07bc42f, 0x7c4df717, 0x0bbe0d64, 0xd8f49c9c, 0x5c0ef813, 
	0x3a3ef592, 0xf75e83df, 0xe1be745e, 0x7f67f2c8, 0xedca5aa7, 0x2e3b6ade, 
	0x353dfa44, 0x0ae1d7be, 0x79adbec3, 0x8571fdff, 0x449d254a, 0xec75f773, 
	0x01f11482, 0x07c093eb, 0x33859e60, 0xf7c491bf, 0xa42bfc0c, 0xf0f42b7d, 
	0xd6ef7c14, 0xbb298c50, 0x94f779e5, 0xd6df44dd, 0xeeb0dd94, 0xfbe5ab3b, 
	0xb0a25ba3, 0x1f6ed051, 0x047ae834, 0xe204bfd2, 0x412bbf26, 0x04f72bf1, 
	0x6f751ce8, 0x85efd40b, 0x7c441bfa, 0xdf647008, 0x0c7e2295, 0xf78031e6, 
	0xacff08b1, 0x94017301, 0xdb52fbf3, 0xce1fff71, 0xf23b77ac, 0x73ed28bf, 
	0xffd7b09d, 0xa2cdca12, 0x07c4ff1c, 0xd7f00785, 0x596f8a3a, 0x523ff690, 
	0xf994d07e, 0xded783f7, 0x50d34d09, 0x76cff7ef, 0xb4ae78ea, 0x92db2fff, 
	0x4ff517e8, 0x21505268, 0x293557f2, 0x17dabfe8, 0x87940b0e, 0x8a01abda, 
	0x9fce485b, 0xf2816f18, 0x870025fd, 0x9c917e2c, 0x82c78c1a, 0x6a51f759, 
	0x7c86bd8f, 0x5f45ef77, 0xea58b178, 0x7d9bcdc3, 0x07e97399, 0x429ec0aa, 
	0xc8314623, 0xb9f3f64e, 0xd857be3b, 0x73a0a37b, 0x7dafa46d, 0x53efd2ed, 
	0xde546989, 0x5473c62f, 0xa9f0ef1b, 0xcc91ceeb, 0x7f36b739, 0x19fbc35c, 
	0x1c45780f, 0x2d5718ed, 0x71ce81fb, 0xcb9f6d4e, 0x5fd6dd27, 0x6e918b52, 
	0x3feede36, 0xb2be740d, 0x487bc555, 0xe6dfd68b, 0x5d021650, 0xfa2a5a17, 
	0x90a57d21, 0x4330bdd2, 0xf2cdeded, 0x6a19d757, 0x3dfad65f, 0x84492d4d, 
	0x9529a79f, 0x27f47dc4, 0x73f44caa, 0x7bbe006f, 0xe933c9de, 0x4fccdf70, 
	0x121e2175, 0xbd208e1d, 0x069aec1e, 0xf6a8b11b, 0x5f10278a, 0xa60cee88, 
	0xedd120c3, 0x5c25cbaf, 0xf2d96e4f, 0x8effe3f7, 0x6dff1209, 0xc0e9b5fc, 
	0x76edcfc6, 0xe0fbc79c, 0x0f0d4899, 0x676dfee0, 0xf7dce0bd, 0xe272fa73, 
	0xbe21f639, 0x835b3a49, 0xa67e7cf1, 0x835fa833, 0xaefb0671, 0x10c79334, 
	0x93306eff, 0x5fe678d9, 0xfc8d7a97, 0xb3e77997, 0xf6e403ba, 0xe0db8462, 
	0x215f553b, 0xabb927b4, 0xa026fb57, 0x0757a3de, 0x1a7e9026, 0xa9af1414, 
	0x7cc91757, 0x32576ec8, 0xf033cf01, 0x77ac39bd, 0xf3499895, 0x8dab4815, 
	0x9ec7ea04, 0xe07f1962, 0x4f88f8ff, 0x4f087a07, 0xbd35f290, 0xee1255df, 
	0x3e5b8ffe, 0xbdead9ef, 0x6153ef99, 0xa4136ed9, 0x233df97b, 0x6fbc8263, 
	0x682f32d5, 0xb17ebe21, 0x6439c65a, 0x8407f0f0, 0x141f4087, 0x352fef2f, 
	0xfbf9fc65, 0xc4b1e1e2, 0xe5b0f0d9, 0x02225496, 0x8c22f2f8, 0xe8e30353, 
	0x4171ca57, 0x441f538f, 0x7770b3f9, 0x50487222, 0x007df71c, 0x7e615b9f, 
	0xf5bc2c91, 0x8232365c, 0xdfc20c7e, 0xb7ddbc2c, 0x8915d5b2, 0x5a47e467, 
	0xe07c7c6e, 0xf92be409, 0x0b99eb78, 0xbc7a0b78, 0xbf0926ff, 0x7bff40bd, 
	0x865f7d60, 0x39e066f1, 0x2013eb13, 0x7e31eb67, 0xc698d8d4, 0x5fb47ac3, 
	0x9f1cfbec, 0x67efc09c, 0xa957fde1, 0x5ea035c7, 0xe5c9163b, 0xf5df80af, 
	0xf65ddf38, 0x1b308e39, 0x1d697ac6, 0x9a772ef4, 0xd4fccf8f, 0xeb17b23e, 
	0xfe71501e, 0x64396a22, 0xa115951c, 0x849f34fb, 0xefc4397d, 0xfd42bda6, 
	0x7879c54c, 0xf103ad0a, 0x5a7fa8d5, 0xfa42a2af, 0x682ba44d, 0x07966dff, 
	0x3c917f80, 0xd3648a7a, 0xc39b37d3, 0xda847c5a, 0x7450bc93, 0x33d79531, 
	0x948afd95, 0x50447587, 0x16f9a05f, 0x8bba0dfd, 0x5bdee5f5, 0x869e1f58, 
	0x5dafb4f8, 0xaedb75f2, 0x96a7a7ca, 0xcd5fa979, 0x7091fe94, 0x4bc19fdc, 
	0x00dd9fa4, 0x1fdc5a97, 0xfc4287c0, 0xfc2c8a21, 0x53f218b9, 0xa1fc4a4e, 
	0x477c1073, 0xcae8d107, 0xdc8a6f94, 0xd893e7f7, 0x97802ddf, 0xa7f76f30, 
	0x33bbbbe1, 0xf7305778, 0x7bbc1cf9, 0x9daef11a, 0x5c20aae0, 0xfec01d20, 
	0x22addf88, 0x43e2a2f9, 0x077c6e4c, 0x39dfc608, 0x2d03b6c1, 0x672bbfd7, 
	0xcf9bcfc1, 0xd7ac9f81, 0x7157c19c, 0xf8666f7d, 0x3d5fcd86, 0x0f20a788, 
	0xea78ce7e, 0x2933fdb1, 0x69788351, 0x4ee3a575, 0x6d6f106b, 0x82707d3c, 
	0xbc7487d4, 0xac7a4e27, 0x3afb8b51, 0xf0e517a6, 0x1adfd847, 0x3a775f5c, 
	0x1daccede, 0xd4f5a1eb, 0xf0b27ae2, 0x0f7a7ef4, 0x0701b2f8, 0xc00b69e1, 
	0xf24af089, 0x11faf775, 0xe3405945, 0xbfbcc14c, 0xff8d1ad0, 0xad0bca04, 
	0xc4b788bd, 0xfc326bf7, 0xf00c4b7e, 0xf003f06f, 0xd92f907d, 0xcbe51f7c, 
	0x2f3c3d3b, 0xfef48e5b, 0xe000f2fd, 0xb2ae26ba, 0x60bd401c, 0x368aab6e, 
	0x0ff507a4, 0x12beef80, 0xc2943123, 0x63254efd, 0xc007fe90, 0xb9e4e5b3, 
	0x8c5dc2e5, 0x68fbf99f, 0xc446dde3, 0x778976d7, 0xfeeaf8d9, 0xe30d4b74, 
	0xe0174f6b, 0xbdfc93eb, 0xe837f67b, 0x5a21649d, 0x342fdea5, 0xdd0abefb, 
	0x91db2bb3, 0x527ea1f0, 0xe3bf9010, 0xedf00a52, 0x35e60fba, 0xb814d738, 
	0x9ed203de, 0x25e1fb21, 0x5121e47c, 0xf8c118e7, 0x8fac9882, 0xb1faa7cc, 
	0x7e937cc8, 0x09722237, 0x2ecb25ad, 0xdf39ab21, 0x5d97392e, 0x8521db61, 
	0x4baa86ad, 0x7b26177e, 0xaa97bedf, 0x76f9f6c9, 0xd6304b4a, 0xf1fa021f, 
	0x4ed4fbcc, 0x5e7b8b84, 0xf6cdde88, 0xef3fc2ba, 0xe47b261d, 0xdd9fa6df, 
	0xdb25b91e, 0xc666b91e, 0x1ed8a7c1, 0x4dd05159, 0xf04fc8f6, 0x91ec01fc, 
	0xf4ddd5d9, 0x7057bd09, 0x7f920ded, 0x7d83b58c, 0xfb00f34e, 0x35dffa0b, 
	0x6387be51, 0xf1e571d3, 0xb7ba5e85, 0xa49ee7c1, 0xbe287937, 0xe608bea9, 
	0x7ee9b4b9, 0xb7a5ca17, 0x9bf94b27, 0x48da8789, 0x26eb50f1, 0xbfcdfb4b, 
	0xd70bb82e, 0xeb447fe3, 0x75c3c7b3, 0xa2e2f3fb, 0xec8bedfc, 0xb3847afa, 
	0x4e3b1eff, 0xfaa3acca, 0xff29b8bc, 0xc53d74d6, 0xce39f9d1, 0x4e71cfc9, 
	0xf2738e7e, 0x9f951c73, 0x805ea8e3, 0x82df06f9, 0xf953c73c, 0x496a9e39, 
	0x9ad7de40, 0xdae79614, 0x4aa38e7e, 0x483c566c, 0x3b37d577, 0xfc27283c, 
	0xf0a6b7cd, 0xf1cfd12c, 0xaf338d55, 0x7fbf89dc, 0x4ff8e2d3, 0x7894e5ba, 
	0xc003f801, 0x599c1aed, 0x7d3710bd, 0x4583d575, 0xdbb58fb0, 0x062ceca7, 
	0x92f9af38, 0xaeadb7cc, 0xfb0c59d9, 0xf61fceb2, 0xcefc866c, 0x95b61717, 
	0x77457e42, 0xb03589fc, 0x43f99f8f, 0x6ee6edb8, 0x20fc7f7a, 0x0bac9b9e, 
	0x40970b4e, 0xf170e6be, 0xefbefc41, 0xff28535b, 0x83954bd9, 0x1afed045, 
	0x0ede1c35, 0xc4d5affd, 0x265cf04f, 0xa04539d0, 0xf7a6aa7f, 0xc00ccf2e, 
	0x6f17759d, 0x990416da, 0x4c5a34be, 0x44feefed, 0xda04b86d, 0xa55abf6f, 
	0x3275ff7c, 0xa0ed5d1f, 0xb9b0bffe, 0xf89ffa86, 0xeebfacb6, 0x03e530ed, 
	0x5627c79d, 0xfefd8e3e, 0x80095fce, 0x260401df, 0x67d4866e, 0x7805b43d, 
	0xb7183b58, 0xd7beb648, 0xca6afdd6, 0x1c5f2812, 0xfc02de1e, 0x71bd476a, 
	0xb7e86eea, 0x5efe1ddd, 0x99db07aa, 0x471ea437, 0x1f763cfc, 0xfa8177de, 
	0xfd2ade7f, 0xfb1b35bc, 0x42ea3930, 0x77b1daba, 0x8f3c12ef, 0xf5f57da8, 
	0xc24f2825, 0x04a1d605, 0xa38cfbd0, 0xf80ba255, 0x7fcf8ce9, 0x1c7129fa, 
	0xa002ffd6, 0xf7e000ea, 0x3f414b42, 0x4abfb5cb, 0x795b3f10, 0xb22907ec, 
	0x7fa47aeb, 0xddef33f0, 0xe5c58ee6, 0x79e02def, 0x6a638ade, 0xb5f5e221, 
	0xa8a3ca8e, 0xb2fb5dbf, 0x6dbbe370, 0xedae14d7, 0x3ddffd41, 0x6ef8dc22, 
	0xd6b28ed2, 0xe01bbd7f, 0x3e6c0d7a, 0x87746ffa, 0x72976e48, 0x3f2efdbb, 
	0xdef75b96, 0x93cbf325, 0xff7b2c81, 0xb411ed68, 0xfd99aff7, 0xbc4f642f, 
	0x85fa513d, 0x654aaec8, 0x8095f9ec, 0x93cf34a7, 0xe573ae32, 0x7e65a7bb, 
	0x95b1f25c, 0xa0a0af88, 0xe9962caf, 0xf8ca262f, 0x8c9f95ee, 0xcb1d91f5, 
	0x458f6fef, 0xd1efc482, 0x53c934fe, 0x1fd97ff7, 0x59c7e790, 0x902460d7, 
	0x7a10eeff, 0xd0fefe3d, 0xf42f3065, 0xc110ef03, 0x11be14fa, 0xf0271217, 
	0x3bfc3a77, 0x7c20148e, 0xf0065f01, 0xa167502d, 0xc8aef138, 0x07ac0fb4, 
	0xedf981ba, 0x27bf2548, 0xda3b5e00, 0xc60447c3, 0x7afd6027, 0x371917c4, 
	0x45b20eb5, 0x4ebe9337, 0xd7d19674, 0xebeb072d, 0x1d1bb60e, 0x1c8c9ebd, 
	0x8e19d5f4, 0xd7dd7d6c, 0xf9c7ec14, 0x918e9af8, 0x7d401ebe, 0xbbbffa1d, 
	0xf98dda46, 0xb89031fc, 0x73f90467, 0x5faab24b, 0xf9b627de, 0x5982cb69, 
	0x6d0d7e52, 0xccf03c06, 0xd9e935fc, 0x0ed21581, 0x70fb3f79, 0x8f3c8d7f, 
	0x1f677ffd, 0x08fe4d3e, 0xa00c3edb, 0x6442787d, 0xf25687d9, 0x87da2b58, 
	0xccc87256, 0xedb813f4, 0xe5a1f65c, 0xf0fb23eb, 0xb7953bd8, 0x6dae79e0, 
	0xfec60207, 0xf7f3e111, 0x261bcfd9, 0xe99cf84a, 0xd6f3923f, 0xd253f7f8, 
	0x127f66f3, 0xe78477cd, 0x207e322f, 0xcecd2ff2, 0x475f7bc0, 0xda65ee90, 
	0xbbc114fa, 0x17f41fe6, 0x9ff8caad, 0x11bf5efe, 0x99e577ed, 0xe3f695f4, 
	0x5dfa4d78, 0x138fdb0b, 0x2b4e3f40, 0x72b68fde, 0x231d38fd, 0x12bcb16b, 
	0xd7f641d3, 0x903f22ac, 0x029ee303, 0x6609d7e8, 0x98ee39fc, 0x5c0bf749, 
	0xdf23c718, 0xe377a459, 0xed035fc8, 0x7ca493a2, 0xdcebf7cf, 0x66f97482, 
	0xd0058f86, 0xfa2af5bf, 0xfd269eb7, 0xfdd4f032, 0x0343b40e, 0xe29fbd3f, 
	0xc83b6dae, 0xfdadfecf, 0x7ea3f760, 0x63facd79, 0x7d67f449, 0xa5a5101d, 
	0xd8eaf11d, 0x3c6f646b, 0xed0d3b55, 0x1f4a6bbe, 0xfb7d466c, 0x64d7d29a, 
	0x4b4efc7f, 0xbcd9b660, 0xa88ded07, 0xc9d526b0, 0x449da0f9, 0xee98b77c, 
	0x5a7a385b, 0x36f719c5, 0xfb3c4dd6, 0xe7820dbd, 0x1dcf0cab, 0xcfd1c267, 
	0xbc07b0fe, 0xdb69c516, 0x6fefb3f0, 0xf7936eb8, 0x12786d49, 0x27ef111c, 
	0xbd2a77c9, 0x3b1f2493, 0xf90c7f9b, 0x9445f208, 0xc9fe69a3, 0xc5445572, 
	0xcabf3c09, 0xbd50d5f0, 0x75f84259, 0x29d1de82, 0x46acf981, 0xa24889ff, 
	0xfd90a4ff, 0x8daf8127, 0xe98074f8, 0x42bfde52, 0xbe049bf6, 0xd9bcf966, 
	0xfb4cdee5, 0x9ce640d4, 0x1a6ddb00, 0x67c9bf60, 0xe9273ee9, 0x91ae9fa5, 
	0x9db492fe, 0x53fa513a, 0xb4f8fc32, 0xef4c3943, 0x0e3f101b, 0xf97e3f20, 
	0x2dc7e71f, 0xe892a7b7, 0xe307d93f, 0x773da0d4, 0x5ac76d8b, 0xfd63b40e, 
	0xa527770b, 0xd0396b1d, 0x46bd7d8e, 0x2dfab1da, 0x81d7e229, 0xd046463b, 
	0xcfcf9fbf, 0x23fbfcd3, 0xb7f873cb, 0x127abd5e, 0x41c2abfa, 0x66b55fdb, 
	0xc2abfa12, 0xbcff9dba, 0x5f310fac, 0x983173c3, 0xdd4f35e7, 0xbcf18cdf, 
	0x963de728, 0xe585cf10, 0xbdefbfbe, 0x5bd39617, 0xfe2ec45b, 0xaf3a2c1d, 
	0x9d817ad9, 0x5b37e797, 0x479f611b, 0x3247bee8, 0xe6c5ef7d, 0x5ccfa85b, 
	0x5ebc5261, 0xf0833cf8, 0xaaf18dd4, 0xed89fb02, 0x0333f7c2, 0xffba7191, 
	0x6cfb9f62, 0xfdd1886d, 0x7c784097, 0xb28bde27, 0xb6b685cf, 0x39f23940, 
	0xefa55f8e, 0x7c778022, 0x17be85ff, 0xe7845dfc, 0xbcb87a47, 0x3b43b2ff, 
	0xae7e40e4, 0xdee5d40d, 0xedcfb17f, 0x1d7be922, 0xba3e6e74, 0x8511d47f, 
	0xb06e8d75, 0x5ff7d91c, 0x84a16102, 0x0df1c06e, 0x457a0a25, 0x402d7ee0, 
	0x8644e5ef, 0x879f65b6, 0x7e8202a7, 0x74c0316f, 0xf193afe9, 0xdc629813, 
	0xee6e6044, 0x7fbb527d, 0x78e22fcd, 0x3ed3095f, 0x89efcb33, 0xefe01fdf, 
	0xf9217d71, 0x3b8ed5fe, 0x23bf8284, 0xe311ef82, 0x7c7e4e3b, 0xe6776a07, 
	0xd7ba53bd, 0xe608f288, 0x3030c28b, 0x73de4877, 0x9d71d889, 0x497272b9, 
	0x9d6fbe40, 0x80fadf3e, 0x9ee906f7, 0x8d0dea20, 0xf5eae313, 0x88d6776c, 
	0xcc03dcb3, 0x5df153b5, 0x0fa403a2, 0x6e7c3fb2, 0xb5fa1759, 0x7a96107e, 
	0xc5598ee4, 0x7ea06a4b, 0x5c3bfec7, 0xdf6bfe78, 0x88be439b, 0xfa3f7c42, 
	0xeef35bf9, 0x7d1e01cd, 0x81df2c3b, 0x3d8defb5, 0x83f24937, 0x3df2c9da, 
	0x7be3ffee, 0xcb3eb663, 0x5ef6c3f7, 0x2575c6f4, 0xd9eecf52, 0xc5f815ba, 
	0x4715ffeb, 0x6736af3a, 0xf6cf5025, 0xc2ea1d15, 0x1bb20e78, 0xf411f964, 
	0xbbfb5d47, 0x7e409e7b, 0xd1f20d7c, 0x8dfbf875, 0x4efbf42d, 0x52179acb, 
	0x53bfb0dc, 0xfc6e91d5, 0xd4b14685, 0x8422cd1f, 0x5f5f67e3, 0xa7cf07b1, 
	0xc56efd57, 0xb1de78f3, 0xfb45b26e, 0x3a77c616, 0x41bace11, 0x7614f4ef, 
	0x44f073cb, 0xdef40bc9, 0xec977548, 0x4bbbf04f, 0x242f9fb8, 0xca8e3ee4, 
	0xe64c77bc, 0xf992de0b, 0xbe647782, 0x492c9870, 0xf929f0b3, 0x59ef866e, 
	0x20bdf799, 0x9951fef3, 0x7cc98ff7, 0x0f992de0, 0xc1f323bc, 0xbf094ee1, 
	0x0ed13aa7, 0xd7a3f792, 0x449298ed, 0x2a34b83e, 0x7c001792, 0xbbc6ca0a, 
	0xf4ba9ed0, 0x30ae8d93, 0x3a9d1fa4, 0xb958ef4e, 0x76f81f2e, 0x4be087ac, 
	0x75f6baeb, 0x65975ab0, 0xdf96a6ec, 0xbc20f555, 0xd55dfdae, 0x9f079451, 
	0x577618a9, 0x52eb38c1, 0x30eb36f7, 0xa56bdbff, 0xf87cbd7d, 0xff08a3fa, 
	0x3df5e4e4, 0xcb729e78, 0x74ea4385, 0x6fe575e8, 0xfa415ec0, 0x379f663d, 
	0x5bc22e5b, 0xecf1fa53, 0x9cfb4ef3, 0x8f22a454, 0xc8d73c53, 0x97ca1742, 
	0x4877ed95, 0xa9e3877b, 0x90ee1e57, 0x3a4875fd, 0x8773795b, 0xeaf8e7ac, 
	0x9e715795, 0xd4ad15ef, 0xaa3b49e6, 0xedf0d39c, 0x5aa826a9, 0x45d39339, 
	0xabf2cbb7, 0xa1fd6d38, 0xb4c9d74c, 0x0ba0e9b9, 0x93928bcf, 0xf502791f, 
	0x477b1d92, 0xd75c2097, 0xd5f7baf0, 0x7f42ea5d, 0xf651f927, 0xf240ec64, 
	0x1ff8c27f, 0xf5f195ae, 0xec288c42, 0x4778a66f, 0x56cbf237, 0xd10f673c, 
	0xd9ba4fef, 0x2f7c45bf, 0x24cdfc8a, 0x3f44effe, 0xcfcb3856, 0x8833df65, 
	0x484b5fb0, 0xfc0fc2bd, 0xfb2df507, 0x2ff1285e, 0x46bfc335, 0x45fe4aa7, 
	0x89f40b7c, 0x4f9b46b1, 0xdf4cbe4a, 0x25f8b247, 0x7b7c0f9f, 0x62ff9cb2, 
	0x5c5b5b8e, 0x0a3c9168, 0x901cdf20, 0x14defe29, 0x9f1c69f2, 0xd12b54e4, 
	0x22f51263, 0x5fb15fb4, 0x98abbbe2, 0x77442b0f, 0x231e76ef, 0x513ed078, 
	0xefee117f, 0xc04dea00, 0x0e58074f, 0x33919ddd, 0x69743f24, 0x90fee33f, 
	0xb961191c, 0x08e588b1, 0xff2b30e8, 0x76d3eb2c, 0xfb7353f4, 0xae51efb2, 
	0x3b2a4554, 0x19afd21e, 0x32c76aef, 0x93b97cf9, 0x0403676d, 0x054be0cf, 
	0x9ec8472b, 0xe80af9b5, 0x32f2aa45, 0xfc0d5fbe, 0x5cef8e2a, 0x248bd60b, 
	0xfaef699f, 0x25e7876f, 0x0f8047e6, 0x69fe7c05, 0x9d4099f3, 0x611be8e5, 
	0xf0c9e37e, 0x003be229, 0xb1d340ef, 0xc44fea38, 0x8a680677, 0x1df15fff, 
	0xbb57f2d7, 0xbd539e30, 0x37e27efa, 0x5cc7d697, 0x99bf10ff, 0x3f8dd87f, 
	0x9bf365af, 0xcf933e7c, 0x7f3a3faf, 0x32d211c4, 0x64dd67fc, 0xdc9b7863, 
	0x7d93e7a7, 0xf7393744, 0x579f09fd, 0x3047f7cb, 0xfb8ce10e, 0xca0f7cff, 
	0xaf1b7fc6, 0x36ff85cf, 0x77e3e7be, 0xf8dbfe3e, 0xfef137fb, 0xe24f4cb3, 
	0xe7fff82c, 0x0fffc1f7, 0x0137f788, 0xf19da37d, 0x75bff87e, 0xc347d4a6, 
	0xae306ef8, 0x4a83ef1f, 0xd0c1cebd, 0xfe7bc1ea, 0x4dd6f63b, 0xe8313f40, 
	0x3ed02f15, 0x5a4a79f1, 0x07df4fef, 0xc6327e7d, 0x41f7d9f7, 0x341f7803, 
	0xbbb76f8b, 0xe8520b5b, 0x2f19743f, 0x6e7974a4, 0xa87b7ac6, 0x5dfe803b, 
	0xcfd54f79, 0x7cfd5af7, 0xf7cfd5af, 0xaf7cfd5a, 0x5af7cfd5, 0xdf1efad3, 
	0xbdd73d6b, 0xb7bf2fa8, 0x23a2c1ea, 0xca14afa0, 0xff8fa9df, 0x5700f201, 
	0xd79a95f3, 0x8f51ba2b, 0xfbdfdd6b, 0xf6be2113, 0x08238d5c, 0x45e1b278, 
	0x7a85dfe9, 0xeddaf7f2, 0xccbefb6f, 0x9963fedf, 0xd227e3bf, 0xd3e77bff, 
	0x6efe040b, 0x40c092fd, 0xb64aefa2, 0xd8ccdef3, 0x8e1d817f, 0xf26ba442, 
	0xfb4a0d9f, 0xbfca3e34, 0xe6740937, 0x81c063bf, 0xbec7faf7, 0x379b68b9, 
	0xd63e5fcb, 0x4af36e6e, 0xfff2877b, 0xc538541b, 0x0000002a, 0x00039661, 
	0x7ded9c78, 0xe554780d, 0x6677e899, 0x2fe64cce, 0xf27fe4c9, 0x807e4c03, 
	0x01926049, 0xe5108483, 0xd6816024, 0x47f60bbd, 0x104e22f4, 0x46b8b06b, 
	0x7b506b8a, 0x2109333d, 0xa2098040, 0x5a356d40, 0xb3eed814, 0x1777ad17, 
	0x813ddbad, 0x36dad168, 0xb5376f5a, 0xb6101db6, 0xa96f66d4, 0xb488d74b, 
	0x3be7f7de, 0x01099333, 0xeecfa5bb, 0xcf3b9e7d, 0x9df1f3c3, 0xdfbcfdf3, 
	0xdfbefffb, 0x28acbe77, 0x567bc217, 0xd7e18f88, 0x0f1090fd, 0x16c4430b, 
	0x684bb109, 0x421cc78f, 0xaf2d0964, 0xfa2165ef, 0xa760bf84, 0x5defde07, 
	0x854a2654, 0xd3b3b538, 0x7ef07c2a, 0xd89560ef, 0xe73dc42d, 0xefa9dbbf, 
	0xc1fb2212, 0xf5743f8e, 0xf8f2310b, 0x21d53b83, 0x49ac4421, 0xdfc70fe0, 
	0xc367e303, 0x408fa3ff, 0xa9cadefb, 0x6e2162ce, 0xda73f984, 0x43217ea1, 
	0xebf3c274, 0xac67463c, 0xf0158848, 0x758ed9dc, 0xe389dadd, 0x20fd186e, 
	0x5ecb9fbf, 0x00778f3f, 0x0bb2cbc6, 0x8840b3bd, 0xd8710edd, 0xefd92ebb, 
	0xd13049fa, 0x2df71839, 0x547f5331, 0xb63dc388, 0xed06223d, 0x9ac5e6ab, 
	0xb579430e, 0x5c8db52c, 0x35cb20de, 0xb3af665c, 0xa861ed3a, 0x3b4e2af7, 
	0x6e307f3e, 0xb1084e57, 0xa3d37acc, 0xef3b9eb8, 0x33943d6b, 0xc3c54428, 
	0x66e68f95, 0x1bc5f108, 0xbb780ea1, 0xaa72d6e3, 0xefc1ddb7, 0xf50dded7, 
	0x9eac42cd, 0x16dbf5cb, 0x62cd7d70, 0x5ffb7f6e, 0x59f5fb72, 0x785ee2da, 
	0x5a2fe8ff, 0xfde1f2da, 0xaf239bcd, 0xabf785ac, 0x5b6fe37e, 0x5552f507, 
	0xd65d2177, 0xf41e977b, 0x7e5108f6, 0x0bcb9774, 0x589efbed, 0xf4f0f548, 
	0x10bbcb88, 0xb86aabd6, 0xd753714c, 0x18a9fe37, 0xe5be56e8, 0x3efab77b, 
	0xdeaefd0f, 0xff42f2ea, 0x0e1ba1c5, 0x8fae817a, 0xea9465fc, 0x42d8df0f, 
	0x72b75df5, 0x8f07743d, 0x846f5777, 0x01f49fc6, 0x03f5bfbf, 0x7537ea9d, 
	0x032f6c2d, 0xcc77cb78, 0x81da51d8, 0xf4563098, 0x02c810ee, 0x4a8462fd, 
	0x20d14b03, 0x25f6474e, 0xd43bb0e9, 0x61b44c78, 0x5853e2f9, 0x59758aee, 
	0x2b4063c5, 0x12cfbf3f, 0x1c7a65cd, 0xc33eeaf8, 0xecfe602a, 0xc8955758, 
	0x31f77287, 0x7d1308b7, 0x217ad5fb, 0xfa711e6c, 0x171c9ebc, 0xba4562e8, 
	0xfe758eec, 0x76b180bd, 0x898ff877, 0xac384233, 0x169e88c2, 0xc5b273c2, 
	0x96278025, 0x74ede6dd, 0x44b10ab4, 0x982aebd6, 0xf36e32ef, 0x1fe0161a, 
	0x1821c501, 0xebe8d3c7, 0xdd400c0c, 0x049e5861, 0x7686acfe, 0x8b176a01, 
	0xf6ef780b, 0x50444a18, 0x78011fd9, 0xd67fb39d, 0xfec1e029, 0x516aff39, 
	0x8adda0fa, 0x2dc53bf0, 0xfddbb442, 0xde00f4ef, 0xb6d66fb2, 0x1278473c, 
	0x2c5e9d91, 0xc61d1cf4, 0x38b2eac9, 0xa5aeb02c, 0x02ec5a4b, 0xdd0bf2e0, 
	0xcf0abfa1, 0xe76e5a3d, 0x735f9c6a, 0x67804ee8, 0x7983b433, 0x0ca1bb4a, 
	0x879bbe11, 0xce6a582c, 0x670d2a61, 0x33aeeb9c, 0x8d9d775c, 0xca3ddd52, 
	0x49d1b775, 0x2b71cf75, 0x5c433dd5, 0x7ae61ccf, 0x2d4a9c66, 0xb3d70ceb, 
	0xecfbf2ce, 0x1b67ae51, 0x1ef7545d, 0x45eea957, 0x69f96ff8, 0x5a50214b, 
	0xb2d6bfac, 0xb53c3670, 0x5dd338af, 0xdcb0780b, 0x0fdd94f8, 0x696fa7e5, 
	0xabe4a3b4, 0x1b589773, 0x552e9e81, 0xb805ecaf, 0xc6f7f96e, 0xfef0f5cd, 
	0x0668d1d6, 0xafd973e2, 0xe0047a4b, 0x35df96fb, 0x84229a3a, 0xf01d3e9f, 
	0x6f91feb1, 0x50a5943a, 0xc3aafb1e, 0x9ce8eb06, 0x0147a1b2, 0xdefedc3c, 
	0xd0bcfbcd, 0x37d7f5ae, 0xbfa03b0f, 0xc458602d, 0xbcbe2116, 0x8022d3b7, 
	0xd14fd6df, 0x5f327706, 0x3d02770e, 0x7fc3260a, 0x6dbe07df, 0xfe013a02, 
	0x32b5dab3, 0x4dc81b71, 0xd2d7f00f, 0xda9dff24, 0xf62acc79, 0x0ddabd02, 
	0xcd6a67d2, 0xf40588a4, 0xfbc03fce, 0x4f8fd03c, 0xbd1e845b, 0x9a2ada1d, 
	0x0e11748a, 0x15a5badd, 0x744a8b4b, 0x42743e03, 0xa2b792dd, 0xba79e10b, 
	0x3f22b744, 0xbf11d33f, 0xa47a81c7, 0xf482916d, 0x7465da7e, 0xa942fb02, 
	0xdea1d21d, 0x7a22230b, 0x0c003c77, 0x47ae3b78, 0x3f8c0557, 0xfd0877e2, 
	0x32c5e19f, 0xf84e88c0, 0xe303d43f, 0x45437eab, 0x75c75fb8, 0x80e217ad, 
	0x8a71a0cb, 0x0b2ebeaf, 0x9c3c7ff9, 0x29e01f00, 0x2cbafebb, 0x83e08384, 
	0x863db271, 0xc220cb75, 0xbfb15869, 0xc2366709, 0x9c3cbf19, 0xbe7873c5, 
	0x7e093874, 0x4b889f39, 0xfc255b78, 0x1ef0934b, 0x8e088970, 0xff55315f, 
	0x9e816fa7, 0xfdefab52, 0x8857ee43, 0x0bd6972e, 0xb217ac3d, 0x2e8e6dea, 
	0x3e0723d0, 0x83a9d9da, 0x7ebd64bc, 0x9740aad2, 0x5a4ed7ac, 0x2fdde105, 
	0xec8c60ba, 0x6f64d933, 0x9d19e40e, 0x37fe8047, 0x6ceb183d, 0xa8f3f280, 
	0x59ae8013, 0x857e87eb, 0xbd7fedf0, 0x3e015aa2, 0xd0ff29bc, 0x2833e412, 
	0xf38e8aad, 0x6015ef00, 0x07d92fa9, 0xc2434aed, 0xc4255c98, 0x59ff80dd, 
	0x9e9e17a0, 0x2c07bfff, 0x9ec78cb9, 0xd71be338, 0x01eff889, 0x807bf1fd, 
	0xa49edbc1, 0x591fc98b, 0x94368f48, 0xe023e077, 0x01da67b7, 0x18bfd0ff, 
	0x6cf3904b, 0xa0e921bf, 0x4d5e2277, 0x0e90d83a, 0xf7afb750, 0x6fd016ea, 
	0x8c9f0d19, 0x60ef085f, 0x5abc4618, 0xd0c7eba4, 0xd33ff046, 0x62048fee, 
	0x1cf8dfd4, 0x3b5f2094, 0x963d8996, 0x148e490f, 0xd6a3b86c, 0xd7ae0bac, 
	0x7c007f00, 0x0f806cb1, 0x2cfec1ec, 0x74022871, 0xfa35ccef, 0x0df97fb1, 
	0xf302c5ba, 0xc46867f9, 0x0e3019f7, 0xc36d4ff1, 0xac20fd1e, 0xa8fa302f, 
	0xe1f00fde, 0x8edda07a, 0x047b0d69, 0x3e8ff73e, 0xd844960a, 0xf5129a1c, 
	0x1cf01c22, 0x1a1a24d6, 0x17ea7268, 0x017f3d00, 0xf65dbae6, 0x405fb217, 
	0x0b11b7c2, 0x65e007c0, 0xdd603ab7, 0xfda9700b, 0x1866ea55, 0x73d10477, 
	0xf3f6bc23, 0x7d012378, 0x542eb9a7, 0x9c0ea76f, 0xdf9086b2, 0xbeac321e, 
	0x8b7e29e3, 0xdbbe285f, 0x094d7e70, 0x7ecc5e81, 0x9fb6cd4a, 0xd847fec1, 
	0xc5e391cf, 0xe740c5b2, 0xe52f7849, 0xfc0aab27, 0xbd973f16, 0x23767f30, 
	0x69f047cc, 0xc727aa8a, 0x6444b357, 0x3ecb9c4b, 0xea17493d, 0xc7f6507f, 
	0xaf40f9f5, 0x507bbda0, 0xd0a39128, 0x1d1423de, 0xc01656f4, 0x34ebfa87, 
	0x1abfa896, 0x17206e80, 0x2c2bc02a, 0x89c02f38, 0x10340c78, 0xf00447e1, 
	0xbe0417c1, 0xf0203a12, 0x6af70853, 0x23619ac4, 0x3b3421bd, 0x3e0453ce, 
	0x2e04fd9e, 0xf10f580c, 0x7c845364, 0x873c436f, 0x3f03a874, 0xdb74325b, 
	0x86dfd241, 0x81f7f51d, 0xe46e82c6, 0xe557ddbb, 0x9e9caa7e, 0x04ec670b, 
	0x50c673f5, 0x1894603e, 0x19c305e9, 0xfbb9fd03, 0x5fe483c0, 0xf585cfc1, 
	0x7f5f3503, 0xde9468b6, 0xfe026d0f, 0xdf59fb88, 0xf5f4d4dd, 0x4670724e, 
	0x8a46a633, 0x3ef01fa5, 0x7843dbf5, 0x53880581, 0xf7d05eb8, 0xefb3ffa0, 
	0xf903b904, 0x6efa0fdd, 0x58f3e81f, 0x7eedcb39, 0xc61ae595, 0x7585ea9a, 
	0xad049b69, 0xd537fe03, 0x3bd511bb, 0x686ef3af, 0xbc2768ef, 0x8f59d54c, 
	0x2297d34d, 0xc8c673dd, 0x4fabc59b, 0x07b7bd45, 0xf4ed45f1, 0xde302369, 
	0x34db0681, 0x17242fd4, 0xb3e720cd, 0x008cff3f, 0xa6abb3b8, 0x0b9015da, 
	0x4235a040, 0x1c011af3, 0x6c306b3f, 0xf3e43d45, 0x97e47b08, 0x8474ce34, 
	0x1c63d323, 0xc9afbac4, 0x7ce88338, 0x4113043c, 0x7ce06ffb, 0x2f03c2cf, 
	0xf446ff70, 0xa0eb120e, 0xeb9d61fa, 0xd5f9b78f, 0x1bda9848, 0x8a2fd076, 
	0xeb974c43, 0x0bf68e99, 0xd61d527a, 0x11ba4011, 0xd09739bc, 0x637d0d17, 
	0xa0f59fd6, 0x4d695abf, 0xaf935dea, 0xd96cf9d3, 0x1576af7c, 0xcd1c35d3, 
	0x5ff93aa6, 0x5050af7e, 0x62c4814e, 0x1ff01ad6, 0x7e82bf50, 0x02fa421e, 
	0x003d97fe, 0x93c00b5e, 0xafe980f1, 0xd7f45669, 0xa5871bb2, 0xd159a6bf, 
	0xf4093b5f, 0x7c459c0a, 0xe8c35e01, 0xe8ed0597, 0xfa0d65b0, 0xe5f51585, 
	0x45c7e003, 0x8276dfa4, 0x868fdaf0, 0xea3950e8, 0x5db7805e, 0x340face8, 
	0xe02d282b, 0x5fd4ff0f, 0xfccb7143, 0xee12cd15, 0x1259bd23, 0x6e19f7ae, 
	0x79fa1f7d, 0xe43e67cc, 0xf107b033, 0x87df8672, 0xf108f67c, 0x95f23959, 
	0xf94c2dd1, 0x33be4729, 0xe425ecf9, 0x67c4b3b3, 0x49cb3ae5, 0xc465d205, 
	0xe3767c01, 0x472b3e18, 0xe5366fba, 0x2315e852, 0x1567c43d, 0x3e18c4e2, 
	0xa1fd0a7b, 0x8ff041ec, 0xc13fd8e3, 0x67c45567, 0xc19f320f, 0xfb3a953c, 
	0x8b22a703, 0x91fb1f09, 0x7f23b6cf, 0xcb0f4c01, 0xff23b679, 0xab3e261c, 
	0xaab3e34a, 0x0e133e54, 0xffc2257f, 0x9859f230, 0xd0bcabe0, 0x413ae123, 
	0xfda157f0, 0x7caf909b, 0xfbd6637d, 0x243f47cc, 0xe8f3eefb, 0x7a16236b, 
	0x4ced16be, 0x56fd9df6, 0xd0b33ff4, 0x9fde03be, 0x7a0efb41, 0x21c1f321, 
	0xa467efb2, 0x3fbecf7d, 0x43c42bf6, 0x553e1f3a, 0x4e957cce, 0x1ebf9347, 
	0x6795f783, 0xdf10bf99, 0x8acd1e99, 0xc0f19772, 0xd82b17d0, 0x7f472f9f, 
	0xee729dfe, 0xfecf599f, 0xd0cbe3a5, 0x6abde81f, 0x6acff732, 0xfa69dbd9, 
	0xf1dfd85b, 0x4a9ed8e5, 0xd8c34ff6, 0x71fc8ddf, 0xa009e31a, 0x7cf2f44f, 
	0x79fc54a2, 0xa56b24f8, 0x0fe413e4, 0xc20b8fa0, 0xf20e73ea, 0xe4c5156b, 
	0x3343880f, 0x868fe226, 0x70fe5cff, 0x53447f23, 0x9d31a3f8, 0xfff2743f, 
	0x7f003632, 0xaf4c9f00, 0xb47f34b8, 0xdb238ddb, 0x3bdbde58, 0x113e4963, 
	0x67a027c8, 0xcf5c15fc, 0xe3377490, 0x4cfddbc8, 0x11238c77, 0x5a2710ff, 
	0x5b6e6f88, 0xe6f92c56, 0xe20e48a6, 0x2b4ef401, 0x7002a5c7, 0xa1c648e5, 
	0xdcf043d6, 0x438892d3, 0x7c224fad, 0x7ecd0e32, 0x3b471e30, 0xb478c0e9, 
	0x189c3c79, 0x29758b27, 0x43da3771, 0xb8f19ba8, 0xdf9287e9, 0x38a7780f, 
	0x47f484e1, 0x5d1fd2e3, 0x706e3823, 0x252fde5e, 0xf484f3ff, 0x2384354b, 
	0xa2bb48ae, 0x40cc9da0, 0x6ce80bbf, 0x9ee97e03, 0xcd4fde35, 0x44cd1dd8, 
	0xa9fc90ff, 0xb5afd250, 0x2b2ad1e9, 0x70e472e0, 0xde902ea3, 0xd6bfa60d, 
	0xfdc175c0, 0xb88e11b3, 0xafd173f4, 0xaba73f06, 0xab47fa5f, 0xa42cdfa5, 
	0x7e97149f, 0xa9c5f030, 0xc527e0e9, 0x54be3fa5, 0x12ef4bfa, 0x907a87dc, 
	0x3f4c6aff, 0x1a42fd8d, 0xafe29037, 0x0f9bfaa9, 0xdb7dde33, 0x2fed8ec1, 
	0x2856aa6b, 0xa4b881ee, 0xe012e31f, 0xcb03f44b, 0x2238a25e, 0x2b25e4bb, 
	0x699e31e6, 0x2fd8fb07, 0xf9d612f9, 0xd7e7a4cc, 0x05cefbe2, 0x865cef5f, 
	0xa69f21f0, 0xd2067bf0, 0xde75da0b, 0x2e0b7107, 0xe92fa1c4, 0xe80438c3, 
	0xc646b39c, 0x8718c52f, 0xf4baf23c, 0x7f22ce97, 0x7acf97dd, 0xe8df2b25, 
	0x579d008e, 0x8fa1bcfe, 0xc621d4fc, 0xe469fa23, 0x67ace9cf, 0xe6fafe36, 
	0x5d3c639f, 0xb4e2c8ba, 0xf2bfde03, 0x784fcdde, 0xb16f1eb1, 0x2be7202b, 
	0x6b1dbf07, 0x7f2bae82, 0x47f8cb2c, 0x740026b1, 0x54b2fbe5, 0x67f3f02f, 
	0xf0f2e23e, 0xdb2a3efc, 0xbf23ec1f, 0xbbcf38f3, 0xc30768f2, 0xe87ec1d1, 
	0xfc1d75ca, 0xff7c857e, 0xcb0f5905, 0x1e7ceaf7, 0xfe9650bf, 0xd9fc7807, 
	0x00f45cb2, 0x2c82ff3f, 0x72e6dfc3, 0x1622973d, 0x71f91978, 0x6eaecb49, 
	0x71727a01, 0xa8dd53d3, 0x3ca73acf, 0xa1a28aff, 0xbbba7a7f, 0x03c7020a, 
	0x69f65dd3, 0x199da820, 0x3ca4f7c6, 0xc1fcc12d, 0xe71cd98e, 0x865685f8, 
	0x615eca78, 0x171a9a3c, 0x555fdeed, 0x53e8a4a6, 0x51df63f0, 0x73f4938a, 
	0xc60b0c3b, 0x7a2cdf31, 0x2bdc42b6, 0x8e18a0e3, 0x4a4af103, 0xe471435c, 
	0xc01ffc49, 0xfd9a76cb, 0x1d9b06e8, 0xdd3d06e1, 0x00fa4c2d, 0x9e9a4b3c, 
	0xdc0357b3, 0xe0bd043f, 0x545f3905, 0xe42bc371, 0x897e4e67, 0xb1bae5d6, 
	0x45c21361, 0x918da5fc, 0x4877457b, 0xbccb8df9, 0x07ccbf40, 0xbc8911ac, 
	0x280f9981, 0x7af412c6, 0x387dca06, 0xef244f29, 0x309ea4f1, 0x6f8cd6e5, 
	0xf4f9c9c7, 0x2227aa23, 0xf118abe5, 0x4fe40c2c, 0xf2c14792, 0xf2cad393, 
	0x72cfdbb3, 0xba780393, 0x3bdb0a73, 0xf94c9e53, 0x258a7921, 0xfcba7bf5, 
	0x64bc048c, 0x059e3027, 0x78fcb14a, 0x292ae253, 0xfce7fb37, 0x6c79adeb, 
	0xec767b8f, 0xea4f3f00, 0x439dcf61, 0xd230a19d, 0x66a7ff77, 0xdfb27ac1, 
	0x22123b7b, 0x7edc7a3b, 0x3efbd618, 0xfa07dde0, 0x61e604f8, 0xcffd8036, 
	0xc20ee819, 0x297cb73c, 0x49d10af6, 0xca18eabf, 0xafd7a991, 0xed95f686, 
	0xf8c7d7ac, 0xb6c5b703, 0x89bf1057, 0x50e7367b, 0xb9fa28ff, 0x9f001b9e, 
	0x7b4a37e8, 0x8b1d5ae0, 0x8f83daa6, 0x35cfd82b, 0xc373c4f9, 0x01ed0450, 
	0x5dfc8bc2, 0x228fe1da, 0x8934dc9f, 0xedad73e1, 0xf805aee9, 0xad9bf232, 
	0xfe39a708, 0x2bdb0568, 0x2e153f1c, 0x691dff78, 0x003d9caf, 0x043a0a8f, 
	0xe41eacf1, 0x4789bdfc, 0xc7d32557, 0x0e79c95b, 0xec9d20e4, 0xc1d768a9, 
	0x62ac6b7e, 0x55eeda84, 0x3f45af37, 0x9da39e05, 0x037cb3f5, 0x29eb1ffc, 
	0xd76232f2, 0xd60bfe85, 0x3bd71850, 0xb4143346, 0x860d19ef, 0x331cf313, 
	0xc52b8a72, 0xeadf80ef, 0x2df3388e, 0x9b81f7a8, 0x0071c9f7, 0x3844b57e, 
	0xa0a5fc64, 0x8ca8837e, 0x383b0efc, 0x7f385d78, 0xe2cbe1a8, 0xf23e3cc7, 
	0xf07cfa65, 0x21ff21cb, 0x61dd17e0, 0x94a52bb2, 0xa2040acf, 0x012f28dd, 
	0x57f9ba9f, 0x15087650, 0x2c1c47f9, 0xd479c52c, 0xc79a5ecd, 0x42a5ebab, 
	0x5c03e7ae, 0x6a2306cf, 0x3daa13c6, 0xdda2df65, 0x01fc52b0, 0x1a7dd23c, 
	0xc94ad3c7, 0xc8040ccf, 0xce45fe5e, 0x2fa895d5, 0xeefe0332, 0xb6506dcd, 
	0xae382519, 0xdf5f5ead, 0x4d4b0c73, 0x6df805ec, 0xd51d62f9, 0x8f4c34cb, 
	0x7b479b09, 0xedd32b63, 0xbfa0ed85, 0x0ef1a916, 0x5b6148e0, 0x67757da4, 
	0xe462960f, 0x72df986f, 0xed7bd2b6, 0x7d72b6df, 0xb3a00ede, 0x7f4073ed, 
	0xf5eb9b8c, 0xe32fbdac, 0x56c77efb, 0x05a517d0, 0xd0552a4b, 0x4705f633, 
	0x3f30ab32, 0x42c884fc, 0x38cbd73a, 0x1f29ddfa, 0xde303a77, 0x7aba30e8, 
	0x4b973e40, 0x4fe4487e, 0x885c609a, 0xa1f3b28b, 0xe33e41cc, 0x76879f7e, 
	0x831f98a5, 0xfa95fd12, 0xf9a38686, 0xca49ce04, 0xa3beece3, 0xd57af09c, 
	0x74732386, 0xe711e33f, 0x44070ccd, 0xd52a19f7, 0x6fd067cd, 0x077d3d01, 
	0xeed143d6, 0x6b0bac7e, 0x6eb7ce27, 0x00fc83f4, 0xc707bd97, 0x7e03d7af, 
	0x3c6be63d, 0xc4f37fd8, 0x7b9e4cfb, 0xf5159afd, 0x3b07edc2, 0x69504e73, 
	0xc1bf01cd, 0xdd01d7f3, 0x41e0f20a, 0x1722967d, 0x6ff5c977, 0xef41f297, 
	0xf379a76f, 0x7237afd8, 0x0b1afec9, 0xb3dc5fa4, 0x8d78e48b, 0xe80a47ff, 
	0x7f60affb, 0x874f8608, 0xd00eaddb, 0x9e2f9ecb, 0x9338a5dd, 0xb7b667e3, 
	0x88ef3159, 0x083cc0f8, 0x297dbfc6, 0x21b59472, 0xfd027160, 0xe9115532, 
	0xb2c93e05, 0x2df50d09, 0xdb22dfb5, 0x5765fe73, 0xbf6a6964, 0xaf1c7b9e, 
	0x87cd3f62, 0x4f3e62fc, 0x7afbf72f, 0x973dc52a, 0x8be79fc7, 0xdaa61787, 
	0x65d20f43, 0x80fb5a75, 0xfa117f6c, 0x23ec1694, 0x278083be, 0x7b65fd07, 
	0x7b44cf48, 0xfe071e28, 0xa0bd456b, 0x227d6165, 0x13ea7c3e, 0x9233e1f2, 
	0xb7fc130f, 0xf86357e2, 0x19f2bf2f, 0x7f55ef5a, 0x9fd87c05, 0x554c8be4, 
	0x9f833e21, 0xf50fb635, 0x821470bb, 0xd259799e, 0xeff2a47d, 0xc1bfc52a, 
	0x4766b0f3, 0x1f5f4df9, 0x97fd43f6, 0xe93cf557, 0xff6fec35, 0x9177b515, 
	0x5f75c17e, 0xf0419fb4, 0xab8c9a69, 0xb05b1f7c, 0x2bc24bbe, 0xe4568d62, 
	0x141ff3af, 0xe518719a, 0x1fa89d0d, 0xc2d98ed1, 0x17c069d1, 0x2c47e996, 
	0xf71f287e, 0xc6fa4cbe, 0x7c51e816, 0x460397a8, 0x9b6bf104, 0xf10077b1, 
	0x31e648bb, 0x72eb0fbe, 0xe3821c63, 0x7171e5ac, 0x66cf535e, 0xdb3d4876, 
	0x0bf67a06, 0xfd4b3d49, 0xde0dff89, 0xac2c3897, 0x11c7087d, 0xf982dd61, 
	0x53e818c0, 0x1e0db7f4, 0xf20f6cc7, 0xfc20a5d0, 0xa8bf6e5e, 0xa4eac2aa, 
	0x92a6957c, 0x8b8e08fc, 0x6139f6cd, 0x19fbb0bf, 0xf3c7a8af, 0x3aff1934, 
	0xc61e7fb8, 0xb75a719d, 0xbd7055ea, 0x6ef50d9a, 0x23fc384e, 0x22eef415, 
	0x49c8cfe0, 0xfa1b33e2, 0x6c776031, 0xdc61a7a8, 0x1d8f8c6e, 0x3d73b09a, 
	0x9dd628fc, 0x03d87637, 0x057b8e30, 0xf768d3f8, 0xfa15eda6, 0x1efc82ad, 
	0x832327b4, 0xc488161d, 0x1be2fc13, 0x442a3b65, 0x185df284, 0x8a5ded27, 
	0xea20bb7c, 0x93bbfa83, 0x0c5221ff, 0x84aa53eb, 0x6d9e0108, 0xbba2bdc7, 
	0xd9edd255, 0xe7bdd08b, 0xc3c41607, 0x9cbd7bd6, 0x202d182f, 0x2c1b9fba, 
	0x253ef7a5, 0xe2869d10, 0x811185e2, 0x23bf22be, 0x36f2694a, 0x5a09efa0, 
	0x9fe315bf, 0x3362f3e2, 0x873e57fa, 0xdc26ebb0, 0xfa4e2087, 0xe30337a5, 
	0x7a6bdf16, 0x5f3fda16, 0xe38dd2a3, 0x6f9b043b, 0x92e030df, 0x8edd24e2, 
	0x342f8a0f, 0xb0bb23db, 0xe5317e64, 0xb7486cbe, 0x2abe20fb, 0xa1ec361b, 
	0xf41aa44e, 0xef7c90d8, 0x207f061b, 0x3ea93e25, 0xdda0b62f, 0xf51c68c7, 
	0x7de9a9d5, 0xaad78c4e, 0x23380c2f, 0x7d54422d, 0x0dd5923a, 0x11aab176, 
	0x9e0523b8, 0x73774c2a, 0x0f89dd7e, 0x1dd05fa6, 0x7cd28d8f, 0xba61f20a, 
	0x3c04ab1e, 0x4d3f1c63, 0x7ee2766b, 0x9400b4df, 0x529d57ac, 0xf5533aaf, 
	0x67a954ea, 0xb46e6646, 0xd7192e60, 0xfce525b1, 0xa4818804, 0xb4f4b0af, 
	0x3f699d32, 0x73dce808, 0x80ece982, 0x7c5535fa, 0x24b6c2ee, 0xedf4d2e7, 
	0x7ae4937f, 0x6bbefa22, 0x234ca839, 0x92e6bdf9, 0x817e9df4, 0x0d1041e3, 
	0xecbfdc97, 0xc008f942, 0x8e505dfc, 0xf8c6f368, 0x79815545, 0x4e2fa3b8, 
	0xee171487, 0xe68555b7, 0xe6bfb409, 0x2780033a, 0x3d4a6e5f, 0x72867114, 
	0x6c80bf65, 0xa47cfa0f, 0xff82636a, 0xabe21db1, 0xe55ee813, 0x2fca4e10, 
	0xb443fbe3, 0xa737d26e, 0x7d246e2a, 0xd8db3193, 0xca12ffa4, 0x07447af3, 
	0xb668af3f, 0xaffdc511, 0x1103f38c, 0x1bd428fd, 0xd2a53607, 0xc99968bd, 
	0x0f82c287, 0xbc73ce32, 0x4c6e6a73, 0xe848c721, 0xfe30bd96, 0x0bf06cc8, 
	0xd8f0939b, 0x1096e997, 0x2c26bbca, 0x5f8a68be, 0x75cfd82b, 0xef15d32d, 
	0xb3df2063, 0x21793687, 0xc557587e, 0xe74501fb, 0xb5ef949d, 0xe0bdf0cd, 
	0xa178fe03, 0x66bdf38a, 0xb675fc7f, 0xced87c33, 0x7638f1a1, 0x18a6c0cb, 
	0x55d7f38c, 0x6e8a1f6c, 0x8e30458e, 0xf78da7b1, 0xa7de2aed, 0xc8af1f48, 
	0x3c017805, 0xa3472db8, 0xf6376eb8, 0xfafc647b, 0x4b5671cd, 0x3fda623d, 
	0xc5b71c73, 0xcf037a4f, 0x0238e00c, 0x3ea01b4f, 0x501f38d5, 0xa55ddb9e, 
	0x697a406e, 0xa42c77ae, 0xdfa85cf7, 0xd8ef16dc, 0x0786417e, 0xdf30b81a, 
	0x9d9c7e33, 0x1ad14e34, 0x0c8e9bb6, 0x545afae1, 0xf3c1f3f6, 0x32ebf626, 
	0x90bbc48f, 0x593d4cdf, 0x0f996df8, 0x07be3f03, 0xa13c05e7, 0x9496ff5d, 
	0x7daabc9b, 0xa8cbe255, 0xe64ed9a7, 0x47a039e2, 0x8b7b5f58, 0x039e1db9, 
	0xf7f890ca, 0x7d2bab5c, 0xca4f9fc0, 0x967cf6e7, 0x3ee76c63, 0xfc89f2cb, 
	0x8c62f457, 0x0e5d2ff8, 0x0f08d68b, 0x6f9b07da, 0x010ee8ae, 0xa37a77bc, 
	0x869ed522, 0xd83b21ae, 0x75a3aae5, 0x22ef51bb, 0x911f1c82, 0x6d35befc, 
	0x94b3cb0a, 0xdfbdc7cf, 0x676d7962, 0xa97a2d39, 0x4a72823f, 0xbbf00af2, 
	0x863cf05d, 0x82571ff9, 0x9ffd702f, 0x2e737805, 0x492f67c2, 0x1a7c063d, 
	0xd1647cc5, 0x38c25ccd, 0x978fa236, 0x982453e9, 0x5859efee, 0x0773cbce, 
	0x74e93e89, 0xe7a7471b, 0xc71c39f5, 0x63c228e8, 0x95f228f4, 0x3933185d, 
	0xc43e226f, 0x833e5af3, 0x71fb26e3, 0x58e2a388, 0x0674fc42, 0x81c51f4b, 
	0x17e010f6, 0x9ca86bf5, 0x2533a7e2, 0x466f34b9, 0x34fc5a43, 0x3327e213, 
	0x3f12970f, 0xfa8202d9, 0xe0a7fc43, 0xe39faa3c, 0x8a07e028, 0x10e3d4a3, 
	0x8e31c417, 0x59e105fa, 0xd4710e3d, 0x28e78a19, 0xe75e2a8e, 0xa6e31a7f, 
	0x471c75e2, 0xbfd4af15, 0xa17a03d1, 0x62268d78, 0xc2b8b750, 0x3fe01dde, 
	0xe2c27957, 0xf7ac2ee1, 0x2ef91ebb, 0x3620dfbc, 0x140c036f, 0x8fc58977, 
	0x74b59c71, 0x43ee2e4b, 0xf794791b, 0x4616215c, 0x22bc7f90, 0x113fd52f, 
	0xebaa76be, 0xffb0b6e0, 0x43f55a0f, 0x91f5476a, 0x15f282bd, 0xbf990aca, 
	0x8c3d8dcf, 0xb94bf8eb, 0xe9b1689f, 0x089b5d79, 0x53aff9ff, 0xe2de0a29, 
	0x503bc17a, 0xd9e1a356, 0x4f0bcf40, 0xf0a373d1, 0x5c24a6cc, 0x9fe8e650, 
	0xc8af2e04, 0x974c3f21, 0x158e0ffb, 0x47efa939, 0x655e647a, 0xd139f811, 
	0xe58b7c24, 0xff25a43e, 0x17435e60, 0x0a3e3995, 0x72b9fda8, 0xf797229f, 
	0x91dcf519, 0xf903b22e, 0xd789b683, 0x5e875c93, 0x70eb8238, 0x57992288, 
	0x14e3922e, 0xf17eb8e1, 0x3bd222a3, 0xb8c628c2, 0xe6e5c410, 0xfb87cc9d, 
	0x978ee5b6, 0x3bf6d163, 0x474b7fe2, 0x27e51fc1, 0x0c05ee3f, 0xf96e7f83, 
	0xd8cbf82e, 0xc5c7fa4c, 0x08ff81c7, 0x4de45aaf, 0xa1aaac28, 0x0582e88d, 
	0x03e62369, 0x9620fb12, 0x25bbbc54, 0xf0019cde, 0x575cf13b, 0xd09e904c, 
	0x678cac2b, 0xf4cfe72f, 0x206131e5, 0x2060fc9e, 0xf91fa95b, 0x87616aaf, 
	0x7f31d016, 0xa6fe43d1, 0x0c47a4b1, 0x3c426492, 0xcee92ad1, 0xb8a7c978, 
	0x3f211fd2, 0x4ff472ee, 0xd1f843e7, 0x674980fe, 0xd38fbbf4, 0xc43a863c, 
	0x30db3cf9, 0x4f386dd7, 0xfc85b78b, 0xbcdfa68d, 0x5ff3c560, 0x3f003f26, 
	0x443de825, 0x4c3056a5, 0xe71051a5, 0x2819e17a, 0xd8f824d7, 0x6b79c428, 
	0x0c7c5b3e, 0xf4b0bbf1, 0x2fa4dded, 0x79407e30, 0xa4ce6aaf, 0x303abfbc, 
	0x9f0db918, 0xbf72a977, 0xe797e88c, 0x7ef2e48f, 0xf2b82096, 0xd7254afc, 
	0x58b5e1d3, 0x87dafc71, 0xdfa6de18, 0x785553cc, 0xdf43735f, 0x1abbda20, 
	0xee3d6784, 0x017d0397, 0xa299551f, 0x533de319, 0x770e00de, 0xd1c30cec, 
	0xfae34797, 0x63abdf08, 0x622f897b, 0x7df847c2, 0x01e0f992, 0xf88e77ec, 
	0x0c3b9e85, 0xb9e13f3e, 0xca30ef6d, 0x7d896dfb, 0xf3271e31, 0x938f8bce, 
	0x4bf33fde, 0x5c5bfb63, 0xff251222, 0xdf09b8d9, 0x8df11c8f, 0xd556c7c9, 
	0xb7ce2bcd, 0xf931d727, 0x14a1442c, 0xb6fb1927, 0xdfc57cc0, 0xeb87de1b, 
	0x1ea584f7, 0xbc7a936f, 0xb6f1ea4d, 0xdfde3d34, 0x6bfc8a50, 0xd727d5ca, 
	0xefe813e3, 0xef7f5336, 0xdb53b921, 0xccefeac6, 0x7b3be326, 0xce675f41, 
	0xac3f44d4, 0xfe3f3327, 0x2c419ead, 0x731fb7b5, 0xa5ad7ed2, 0xe675f407, 
	0x59e534e7, 0x5eccd3e0, 0x5fbc4be3, 0x276ed623, 0xbd93a0bd, 0xf760e8f7, 
	0x15bcc317, 0x71a9ad1d, 0xf10fda9a, 0x4b821ec2, 0x82a7fb41, 0x297cc6d1, 
	0x0d018bb6, 0x1432074e, 0xfb09c7b4, 0x8fc1fd87, 0x5c603bb5, 0x5dc0e7f4, 
	0x49ecbf42, 0xd81e6fc0, 0x1f240fe7, 0x7d91bce1, 0xe792f5e3, 0x3e4a23ee, 
	0x8f91dbca, 0x7b27eac6, 0x35a551fb, 0xeba51f45, 0xf13f84ab, 0x26c9e112, 
	0x3073e68c, 0x11ee6d8e, 0xdc7ae305, 0xecf9c4af, 0x78763e32, 0xa2b74585, 
	0x36f287b9, 0xf7004fa9, 0xd221fd4e, 0x78f87f3f, 0xb575e901, 0xf7147fca, 
	0x4395000f, 0x671829ea, 0xbe50aa89, 0x60aa9968, 0xe78e6ebc, 0x06dd0bf4, 
	0xc3dd87be, 0x2fd06dfb, 0xd3baf18a, 0x19f2f10f, 0x39fb1f9e, 0x872f10fd, 
	0x0f90fd93, 0xbf9138b6, 0xf5978b74, 0x7ee7828a, 0x312b9f40, 0x3c710f6a, 
	0xf01b7fb4, 0xf49f78e6, 0x710f3f3f, 0x03f44e9c, 0x1ac9183e, 0x9d836f1b, 
	0x7c93f4b4, 0x2c33f66b, 0xacb3f6e7, 0xb94632a7, 0x79f0619e, 0x3e71c759, 
	0xe218eb1f, 0xec57b2f3, 0xbfe52d3c, 0xcb82750b, 0xefcae12a, 0x04e62887, 
	0xe90b65e9, 0x3a20b8e5, 0x0f52151b, 0xe70b357b, 0x387da43f, 0x079815e8, 
	0x7051c732, 0xf027a41c, 0x29a5c617, 0xbd48b478, 0x83744167, 0x90b6578e, 
	0x007985bd, 0x9538ff9f, 0x90978ce3, 0xf126ceff, 0x077e7976, 0xe3f82946, 
	0xa9e3fdf9, 0xe2965e7c, 0xe0a73c7b, 0x80b62459, 0xb998e51f, 0x9821df46, 
	0xa29f88ee, 0xd307ac69, 0x9f9c09f7, 0x9eb00df1, 0x823ef8bf, 0x7efcb3eb, 
	0x6a823edc, 0xe801743c, 0x8ce8107c, 0x698a7ffa, 0x0210bcaf, 0x23b5f8a4, 
	0x6a5f720d, 0xdacfc249, 0x8a66fa8c, 0xdbca1799, 0xe3ca5dfb, 0xc00befa4, 
	0x866faff8, 0xc0817872, 0xf9394cf1, 0x12a79cb2, 0x9ea53d02, 0xdd4b2be6, 
	0xa9ff0557, 0x94baec8c, 0xcf3891f3, 0x38ba69af, 0xcd3fa82e, 0x4a746d3b, 
	0x084732d8, 0x16586fd3, 0x3f60f6e1, 0xe99b1ccb, 0x5bf9639c, 0xf95fa20e, 
	0x5acf103b, 0xb81ae2ab, 0xbffb49af, 0xf43fec14, 0xc712cca9, 0xac1e8077, 
	0xed55ae9d, 0x8bd5fe80, 0x21bb93b5, 0xd65f9e5e, 0xf5099fdc, 0xb9cde9fa, 
	0x9cc7a05e, 0x6e6772ba, 0x2cdfbc26, 0x9f5fd006, 0x5a65ad3a, 0x0fd03dde, 
	0x7ea201cf, 0x3e028874, 0xc617a7af, 0x442a1e38, 0x6b340bf9, 0xddc03105, 
	0xbe634cdf, 0x38d6e19a, 0x178e284f, 0xe76d7ae1, 0x8f304617, 0x2911d754, 
	0xab61e540, 0xf20afd01, 0x503fdf5a, 0xa8cdf140, 0xae20ba50, 0x0a56199f, 
	0x3b66bf31, 0x8279d1ab, 0x21735b60, 0x3de157b6, 0xbc22b7ca, 0x8a479ed2, 
	0xf21e4e48, 0xbee4fe33, 0x6195f6a2, 0x5513d7da, 0xa17eca9a, 0x877f4aae, 
	0xde4b03fc, 0xdda33ff0, 0x8a3aeb54, 0xd457e042, 0x9973e62e, 0xdc617fa4, 
	0x8f38d303, 0xef49bf09, 0xf375c864, 0x9e5249fb, 0x7a3c9126, 0x623873cd, 
	0xc1b3ce32, 0x6b79e221, 0x91e4fde8, 0xca7cf4cd, 0x29f52a39, 0x5eaca017, 
	0xca1565ba, 0xfeff8cf9, 0x01799f93, 0x8ce9ea9e, 0x2269cadf, 0x4b8d6582, 
	0xc4febc50, 0x9f638e34, 0xc6fc7896, 0x6bd38e34, 0xa223786e, 0x72e58bbe, 
	0xf0332bf2, 0x47c0037b, 0x61e40b86, 0xd7e5f000, 0xf688b514, 0x63cc1479, 
	0x8ae29adb, 0x9a4fe782, 0x00ae7ffa, 0x7dcad6df, 0x80c37506, 0x1b3d9303, 
	0xe228fefc, 0xbb805ef7, 0x7033f805, 0x834552cf, 0x6b3b00ba, 0x803f3e00, 
	0x259c9779, 0x7f782dfd, 0x6e7da0c0, 0x788b7f3c, 0x127efe24, 0x5f9afbe9, 
	0xe15f89d6, 0x965b7147, 0x0dc662c5, 0x657e6965, 0x0778d8d9, 0x3a54fca2, 
	0xa11c730e, 0x823cc874, 0x742f4bd0, 0x7e1df927, 0xf3e041fe, 0xd07e20df, 
	0x0f78825f, 0x069b5ffd, 0xf4425874, 0x489e938d, 0xc8074793, 0x6183f30f, 
	0x59a83f20, 0x4533ad61, 0x51ee504e, 0x082e6b9e, 0x933a9fc2, 0x539500f3, 
	0x7bf0543e, 0x9f308da4, 0x3f71f013, 0xd7b027ea, 0x927b9f35, 0xc5d66af0, 
	0xb273fea8, 0xaed20ddf, 0x6f6f8c7a, 0xa07038e3, 0x8ee50f2b, 0x222fc7e5, 
	0xcad76899, 0x5e99031d, 0xc7911f92, 0x3cf55de7, 0x74df2794, 0x788d23ce, 
	0xd77389bd, 0x73798e86, 0xf4f3d8ef, 0xf7805728, 0x4e2837eb, 0x8263dff2, 
	0x4fe6bfec, 0xaa6b0dd8, 0x1171881f, 0x934abf9d, 0x85e50317, 0x00b880c0, 
	0xe5abc3e5, 0x39557f21, 0xfdb07ec0, 0x7424bb65, 0x1f8bf7aa, 0x15ec1d51, 
	0x2765d3f9, 0xbed89d63, 0xc7bdddec, 0x9a2a5f50, 0x2c1eefa0, 0x58440f18, 
	0xbc52ceee, 0x95bc11a6, 0xcf07a32e, 0xcfffd4d9, 0x6b4fb479, 0xbe8a34c9, 
	0x8d0e502a, 0x533e3243, 0xbf1e1f3a, 0xa67a74fe, 0xebf2e3e3, 0xb189fd67, 
	0x1f7beb09, 0xfa93179f, 0x3f18345e, 0xfce7bcc0, 0xa1e8dfb7, 0x9f09237d, 
	0xcc85fb3f, 0xadd92b32, 0x3c7551bc, 0xd3c4549e, 0x4f023f89, 0xdbadfa93, 
	0xdb8c3e71, 0x5ff3c78a, 0xe3d33afa, 0xabbf5345, 0x295d6155, 0x49e7af1e, 
	0x5c904f4e, 0xc66b2d87, 0x23d927c8, 0x2b6153d0, 0x2037bf3c, 0x57f5edfa, 
	0xfbeb5e5e, 0x07c82995, 0xfab83ea6, 0x855c3eef, 0x85d985df, 0x276a3a56, 
	0x3ce94af8, 0x6bec6e71, 0x2fc1f7a8, 0x66f3a32b, 0x718fcd01, 0xe9bf29b2, 
	0x978e93f2, 0x41dca3af, 0xe506727c, 0xae5244fa, 0xe22400f1, 0x32c336b5, 
	0xa4dff720, 0x6c79697c, 0xb8ce40af, 0x379e1e7d, 0xcb1a65bf, 0x413a409b, 
	0xe5fdfabb, 0x49abca79, 0x9a4f127e, 0xb3f79e7a, 0xf3a4bc4c, 0xd907c9a7, 
	0xfd8d3889, 0x01f23f2e, 0xf14e8bf1, 0xa7e7e9af, 0xc8babbf3, 0x3b34dbf4, 
	0xf615c79f, 0x9a5dc508, 0xa3ed0fbd, 0x4fe4dfd4, 0x4c3887ec, 0xf5850f9e, 
	0x3ed0fbda, 0xfa56685e, 0x9fcc8ec0, 0x25afdfce, 0x368f17ce, 0x923df82b, 
	0xdf7863ed, 0xd015fb22, 0x7bee0ab8, 0x45f80b4d, 0x996de014, 0x44c3f9ce, 
	0xe9bbf03f, 0xb42f263b, 0x63cfb8c3, 0x71dba7c2, 0xfd02d3fd, 0x4a3f68ad, 
	0xcdd58a86, 0xc7f78ecf, 0xa1eb67e0, 0xb45143f1, 0xf8c077db, 0xfe290dde, 
	0xce7990d9, 0x7ee1b343, 0x99ff34c8, 0xd76e30e7, 0x213efe30, 0xea2af9f1, 
	0xce563fa9, 0x08efea75, 0xeb8c5404, 0x0f557e41, 0xbaa2ef08, 0x28679246, 
	0x489f8e29, 0x91ba4d9e, 0xf94ab6fc, 0x753db945, 0xece78ad0, 0x190ba63a, 
	0xc65fc7df, 0xf312abf8, 0x6bd49aee, 0xcf9f3a31, 0x7bf185f8, 0x48f5df24, 
	0x7c91ebbe, 0xf73efb87, 0x6f3b674f, 0xaead9df2, 0xddf113e1, 0xfc467c44, 
	0xedf92ad5, 0x4fe88bd5, 0x5da017a9, 0x2fd3ad19, 0xc2f553ca, 0xbf53fce5, 
	0xd6f5cad0, 0x946f3b54, 0xe25cf70f, 0x87bc6e3c, 0xcfe982f4, 0xfa44f19a, 
	0xd5db5a79, 0x09879f9c, 0x383b4927, 0xd103bf89, 0x66f9e126, 0xf9c15bdc, 
	0xca6e9d9f, 0xf1993ea9, 0xf3e7a3e1, 0x5ee4faec, 0x0fee0bf0, 0x1fd1ba84, 
	0x02ccf5a2, 0xa5dbfe75, 0xd245da0a, 0x78b7e87f, 0x218b7e13, 0xb0af81f7, 
	0x3a4c629f, 0x3189fe45, 0xda952cf9, 0x64dc5194, 0xce531908, 0xb8bbde91, 
	0xe49cf31f, 0xf90e5827, 0x96ffa431, 0xd6067f4a, 0xe70dfe42, 0x81f86cb7, 
	0xd3035147, 0xee51a4ab, 0xf7e5860b, 0xd9ba4937, 0x7e44ee18, 0x6af88ed1, 
	0xed3df8d1, 0x38d2b75f, 0x71ed1d26, 0x7fdff2e5, 0xaad27699, 0xe3dfb5c6, 
	0xb197dac7, 0xb1b4ea53, 0x1c4a55fe, 0x1e73c112, 0xffc010c1, 0x0ba39414, 
	0xc05f945c, 0x0668a379, 0xfbae3734, 0x3e7c19ee, 0xecc5dae3, 0x455fa327, 
	0x81f008fa, 0x6cdae8fa, 0xc40f6ab1, 0x6916d72f, 0xbac0f787, 0x7f8c1a9a, 
	0xa9f4947d, 0x00b5bc56, 0x2a3627b7, 0x951bb016, 0x275fec85, 0x5804dfce, 
	0x335776ee, 0xdc082d3f, 0x932716e8, 0x3682ca71, 0xdfc85845, 0x7eb1be15, 
	0x03e4c853, 0xc59ff31f, 0xebdf4f94, 0x60bbd740, 0xca06df3c, 0x43d51613, 
	0xff20b15c, 0x26d35160, 0xdf5b33d2, 0xa1e37d21, 0x1fa4c478, 0x7f84dfe8, 
	0x0088f984, 0x14e1edfa, 0x7491fcba, 0x9e6d9ef5, 0xf26efc8d, 0xb7433d85, 
	0x74f8f3f5, 0xf9c1700e, 0xf72883e5, 0xd438dff3, 0xe210fa85, 0xfb123504, 
	0x480f74e4, 0x0f7896bd, 0x8dcf63fe, 0xcee23fec, 0x6663d60f, 0x5afb841d, 
	0x533cdf19, 0xd768fbcd, 0x6477f116, 0x49ce7122, 0xeb87fda7, 0x7fb429cf, 
	0xf77abbdf, 0xf8ae78c3, 0x1f4b707a, 0x93f217fd, 0xaf4f9073, 0x851c2f9f, 
	0xac1f2427, 0x4739bf26, 0x5efec45c, 0xfb982ece, 0x20efc913, 0x6bbf8caf, 
	0x00e1b3fa, 0x9da623c7, 0x9f3989c1, 0xb5e471c7, 0xfffae6d9, 0xde7238b4, 
	0xce471cab, 0x91c729ff, 0x615c64f3, 0x2e8d91c6, 0x6668defe, 0xa1cfcb35, 
	0x43238e6a, 0x36471cd5, 0x9b7cb9be, 0x7d961b7a, 0x3d064714, 0x177c85c2, 
	0x47146974, 0xa2ba03da, 0x4bff41ee, 0xbec838a7, 0x718dd5a8, 0xc71d7064, 
	0xf3cad73b, 0x327381b9, 0xa3cad48e, 0x8e327096, 0xd3adf86c, 0x7e471a95, 
	0x48e39ab3, 0x1c04fed3, 0xe3cddf20, 0x67f152fd, 0xc6c71b88, 0x9df813a5, 
	0x3cf831c0, 0x663f1698, 0xa7e93f48, 0xf81f7235, 0xd3cbf58f, 0x1cf25cec, 
	0x387d58eb, 0x021fe64f, 0xf360b728, 0xad6a6f03, 0xa76f0f9c, 0x6f02d3ef, 
	0x7c155b87, 0xf29cb2de, 0xb7259ae1, 0x8ac6e31b, 0xcc6ee2bc, 0x388495bb, 
	0x3bdc5cff, 0xce53584f, 0x61ac9cd5, 0x3e49a73d, 0x6b2cd408, 0x7c993cb5, 
	0x9ab2bc5f, 0xdbac8fda, 0xf1e62f78, 0xfa006f28, 0xc7c89be0, 0x8afdb1eb, 
	0x8010e556, 0x7bf9d7e1, 0xeb4f9100, 0x0b843a0c, 0x094136f3, 0x8da2c8ef, 
	0xafbe62f7, 0x55472da4, 0x4dfd42d6, 0x2c7e92f0, 0xffa87cf3, 0xbbf3145b, 
	0x3d009739, 0xd4037239, 0x0b867d69, 0xb2310282, 0x6e6bacda, 0xdb37afaa, 
	0x9f6c6e1b, 0x87c22f0e, 0xbee0b0f4, 0xad97ca3c, 0xd3bf806d, 0x5fa1f711, 
	0xd58ef899, 0xce9e5062, 0xdb95d43d, 0x6b3428f5, 0xc273f3e4, 0x7f59d86f, 
	0x034a7af3, 0xe781555e, 0xdc036f23, 0xc1f3f85f, 0xf9c03bbd, 0x66f105cf, 
	0x74956bca, 0xfda9640d, 0x84235c42, 0x17cbcf0b, 0x783c54af, 0xd558a1ce, 
	0xe106faea, 0xee76997d, 0x20941739, 0x838e3153, 0xa9b217e8, 0xd074766b, 
	0x0c250bf9, 0xfba2fa80, 0x728ee556, 0xf86f011d, 0xde5d734c, 0xd9662142, 
	0x7abf685a, 0x9297180e, 0xf758fe94, 0xc1ebd4a6, 0x0e3887f8, 0x302fb811, 
	0xf55916cb, 0x57f8ca68, 0x35559169, 0x055fe329, 0xd9347785, 0x5f40767f, 
	0x6c9a3155, 0x7f48af3f, 0x19c42762, 0xa7b4eba1, 0xa1fc00b6, 0xda5ead02, 
	0x9efc3ee5, 0xdcad967d, 0x6c15e7b7, 0xbadb9da7, 0x0589db15, 0xb6832f7c, 
	0xb6377ba5, 0x21dfafd7, 0x343a43c7, 0x1705e6fd, 0xcb39977e, 0xfa966966, 
	0x939e48b3, 0xafc8322d, 0xa1c77cd2, 0xcf9ab97c, 0x63fb9ac5, 0x8a561f57, 
	0x2cd53cf0, 0x56fd429b, 0x5ec228f7, 0x0ba9f14e, 0x7398fbef, 0x9c1d5150, 
	0x3c71717f, 0x3bf45428, 0x559bda9b, 0xd1aacfa4, 0x1a79116c, 0xacd1d3e8, 
	0x55bf50a8, 0xa6ba512c, 0x45a48c42, 0x3c13965c, 0x371fa45e, 0xc2aa8511, 
	0xc55e8178, 0x04491a03, 0x037e80d6, 0x13e558f9, 0x10956b71, 0x766eeea7, 
	0x76f37da3, 0xdfe87d85, 0x6cfe6507, 0x55103eb5, 0x66b2ffb0, 0x15bb1efa, 
	0x178e2ed4, 0xe1b2efc4, 0xcd23dcfd, 0x5d079845, 0xa74bfb80, 0x49d2de65, 
	0xe7823a7a, 0x6f9ec103, 0x9afbc10b, 0xbe8f8a65, 0x7961bab3, 0x0f7807c4, 
	0xe6db2cd6, 0x6f7a83eb, 0x53ef07b3, 0x2396d059, 0xdd88fee8, 0xf39e2f30, 
	0xbc3e190e, 0x677822e7, 0xef1c1edf, 0x7cf9d357, 0x9f5b4d52, 0xaaf8f50b, 
	0x7c62d1b3, 0x5858eade, 0xea82e382, 0x210cbb57, 0x91a6fe56, 0x2d6f05f6, 
	0x6038a8fa, 0x63c4fdc7, 0x6eff6825, 0x6879d3c5, 0x4760bcaf, 0x129e095a, 
	0xdeb0afd4, 0x168f8c12, 0x0fb7d9dc, 0xf730f1ef, 0x620fc955, 0x3f8c7eff, 
	0xbea5cc04, 0x5107e29e, 0xf9f4899c, 0xe441fa0f, 0xfa4e1d47, 0x3117e4bb, 
	0x3023ed9d, 0x2c9f82cf, 0xa44572ed, 0x1bed041f, 0xc193f47f, 0xf85f7e4b, 
	0xfa43fb27, 0xe7cc1dda, 0xf3e075cb, 0x1b9a0bc6, 0x26706bed, 0x5395dbc7, 
	0xa09dba36, 0x9c025ac7, 0x9b885c67, 0xbb43ef77, 0xbeeed8b7, 0x6dbef93b, 
	0x2d829768, 0xc9fd61cd, 0x50153c64, 0xc347042d, 0x2129e777, 0xe50cff8a, 
	0x6bd7e230, 0x7ad30e44, 0xc061eb35, 0x74106e63, 0x05bb8c05, 0x8de284e4, 
	0xd83f3e61, 0xf18d8cfd, 0xc50e787a, 0x2f1d6f99, 0xccc6fce5, 0x06317b8e, 
	0xea4d7e15, 0x8ab78e7f, 0xe6f3d635, 0x1c1f29ba, 0xec61ed93, 0xff58d791, 
	0xdd610513, 0x1e84d123, 0xdd1e90f5, 0x1ea3d095, 0x254f9bd2, 0xd52668f4, 
	0xd1e84b9f, 0xeb3f6c4c, 0xcf037e17, 0xe6aaefd7, 0xef05bcbc, 0xfa95681f, 
	0x5b06fd1c, 0xefb42bdb, 0xf97fea63, 0xff52593d, 0x2aedcd6f, 0xd09f3d04, 
	0xf598faff, 0xc77b0c94, 0x052badd8, 0xed86adb7, 0xa879fa76, 0x6bfd7559, 
	0xf70fac5c, 0x7d07cd6d, 0x17720a33, 0x3c1dca4f, 0x5df5c12f, 0xbf8ffa03, 
	0x184bd49b, 0x208bf65e, 0xcc3960be, 0xd6ff8a30, 0x533b949e, 0x5f485d0e, 
	0x326b43f0, 0x843ec944, 0x61c82663, 0xf65bea31, 0x3c9ddf13, 0xf817ab77, 
	0x73677029, 0xfea9cf18, 0x1fec999f, 0x5505f09a, 0xd3f113e5, 0x9f99337b, 
	0x5691f1c6, 0xfdb77e4c, 0x6e6f3e2a, 0x303b4fee, 0xe50e7bde, 0xbca018d7, 
	0xa35fee16, 0x6fd1961f, 0xb1c873e1, 0x47b73c6a, 0x3e00b6e7, 0x9635da0b, 
	0xed361797, 0xe59ef8c6, 0xe01af021, 0x81d79cb5, 0xa475c774, 0xfc3a43ca, 
	0x81b8bc26, 0xdc98da1a, 0x93353f57, 0x071ad3bf, 0xe485bf7f, 0x8f35e460, 
	0x1cf943f4, 0x1d8eb99e, 0xf9e6bf12, 0x43614b1f, 0xe0dbcf14, 0x5fa718f8, 
	0xda1b58bb, 0x8ffa32fd, 0xbfdbc3da, 0xc4e39494, 0x727fc0fe, 0xdf91767e, 
	0xfb3f2632, 0x9ff3daa9, 0xb16b3f28, 0x1eaefe19, 0xf7f1975c, 0x96911dfc, 
	0xed2f99d3, 0x3ed2ede4, 0xf7692ffe, 0x737d814e, 0xf3cac388, 0x6d4f67a0, 
	0xdb3ee374, 0x456d4535, 0x9f17184d, 0x7803bb07, 0xfcba3058, 0x87ec55fc, 
	0xd03376fc, 0x262e17d7, 0xf503353b, 0xce0c3c3f, 0x6f1568ee, 0x727a7fc0, 
	0x41023a04, 0x54fe8fe9, 0x6f3333c6, 0xdf4229bb, 0x7636bd3d, 0x9c7edabf, 
	0x81d3e1fd, 0x5f7376c5, 0x6bd4f49a, 0xfa6d2fbc, 0xff09c55f, 0xffa3734b, 
	0xcbff43e5, 0x4d4ff98f, 0xef045bef, 0xb0f534cb, 0xfe71ca1b, 0x7687a2d7, 
	0x153bf8a4, 0x5e44fb9d, 0x4bff18c7, 0x2ffd13ff, 0xffd527b1, 0x19888b6a, 
	0xdb57fea9, 0x544bff38, 0xda13c0a6, 0x2bce0ba4, 0xccee1f6b, 0x1f9af1c7, 
	0x0bd2547c, 0x7f4bbbef, 0xf826720f, 0x1e6d473b, 0x2cfd37b7, 0xc65bebd0, 
	0xe29b75e7, 0x8ff21711, 0xadbef30d, 0x80dcf929, 0x5eb0fdf9, 0xf0136174, 
	0xfefe4cd5, 0xb0743914, 0x9e539e9b, 0x4cc7f4c4, 0xbfbea97f, 0x58fecdd9, 
	0x7ec1c5b3, 0x07de5b81, 0x7d7cc163, 0x4162bb53, 0xdff4c4bf, 0xf4cc7f4c, 
	0xe06d1ccf, 0xfd26b58f, 0xb2ffd333, 0xcc14d12d, 0x17fe9af3, 0x8a616bf9, 
	0x5fae285f, 0xdd3e05e5, 0x2997fd0f, 0x40bff416, 0x3bf0fa4f, 0xe903882a, 
	0x9fe9863c, 0x78596039, 0x9fe13c5e, 0x30f444b9, 0xdb4d15ea, 0xe3f017b6, 
	0x8a2721b8, 0xdfd1c4e7, 0x65acff24, 0x8a50b6d9, 0x67fa66ff, 0xc2c7f40e, 
	0x77d13714, 0x00dd8edb, 0x5dd5ca07, 0x361a8a27, 0xbf047ea1, 0x59e80f2c, 
	0xf4d57ac3, 0x03af48c7, 0xfb92f39c, 0x177f2ad0, 0x3ce9b9a6, 0xf7735787, 
	0x87537eb1, 0x01677cf9, 0xb6dc93ea, 0xfec5df27, 0x6d417e89, 0xa6bbc51b, 
	0x7999a53f, 0xbefa7c87, 0xdc916b26, 0x76f99317, 0x29d747da, 0xe61b6bef, 
	0x6ff9123c, 0xfda35aa2, 0x2c854fbd, 0xf85df805, 0x029686e2, 0x7f22dba4, 
	0x78e900b4, 0x0168e05d, 0x67a0d5fa, 0x739f300a, 0x00a5a05d, 0x37c114f3, 
	0xe4baeedf, 0xa447533d, 0xfec1d57f, 0x231c5f95, 0x44ca053a, 0x46f73ca6, 
	0x56b77279, 0xe3fa451e, 0xc7143f77, 0xf99875c9, 0xa3bf3320, 0xe3ce993a, 
	0xab3463f7, 0xc7946fd4, 0x3dede4b1, 0xaf122e26, 0xabe7477b, 0x531bf663, 
	0x12e817cf, 0xd7ae309f, 0x117fe301, 0x48fc1cb9, 0xc443bbc4, 0x1c8faf51, 
	0x49be7071, 0x65f807ae, 0xf932e910, 0x79c228ac, 0x456864a7, 0x4d17de31, 
	0x7da4779c, 0x10605b2c, 0xf7306ef5, 0x17ba5da7, 0xf26198fd, 0x0fbdd463, 
	0x616e0ee7, 0xc857fc3a, 0x51f92703, 0x1b7cc814, 0xf80fa3f3, 0xef9fe011, 
	0xbee55b16, 0xf707bd1c, 0x2da0e0b3, 0x373c3789, 0x7c147c82, 0x9e473a3d, 
	0x09c42bff, 0x6e17e703, 0x0d2273c3, 0xf2015acd, 0x139e506b, 0x291a3059, 
	0x46d9bc40, 0x23be5e21, 0x76c40e79, 0xa1392756, 0xceb01ef3, 0xc8a6a8c0, 
	0x8f546073, 0xe185747b, 0x9cfda834, 0x9b871c99, 0x9bf0e7fb, 0x3248f184, 
	0x624c673f, 0x7ce65d7c, 0x0efe5a49, 0xe508bce4, 0xd9dfccdc, 0x337bbe80, 
	0x17c9fc68, 0xc61017dd, 0xf29f9c14, 0xf8caaf79, 0xf3e5c4ee, 0x602f187a, 
	0xe92ae75e, 0x3282cdb7, 0x79f29674, 0xf1ebce11, 0x0bbb10f9, 0xe61f60f4, 
	0x40ce20f1, 0xb8a6d87d, 0xf8caefd4, 0xac87cf0a, 0x5e61772b, 0x6c68b02f, 
	0xe6682f5e, 0xf3d2daf5, 0xa9dd4b7a, 0x987cbd79, 0x9bef0977, 0x79433f92, 
	0x7affe6a1, 0x15c0bd79, 0x4b62173a, 0x08f627fa, 0x7f9a69f2, 0xfc0d7812, 
	0x3f996a93, 0xde4ff54b, 0x864ff34c, 0x3364ff4c, 0x1ed827f9, 0x9f84c9fd, 
	0x29fb26f2, 0x04af1901, 0x8e56b46a, 0x0aab0e2b, 0xcd5bc7c6, 0x6a8e607c, 
	0x7ea5a39e, 0xfe040798, 0x603cc5c8, 0xd8fa5c4a, 0xfdffce4c, 0xf7e4ccd5, 
	0xd65df4ae, 0xe607ce56, 0xe80a7e62, 0xaefd2b9e, 0xf93b4d40, 0x9cbb6659, 
	0xf263e595, 0xff24cb8a, 0xaa9fe599, 0xfc7f4c8f, 0x4247d54f, 0x9413a77e, 
	0xfdf8e171, 0xbf42a368, 0x8c12df84, 0xde295b86, 0x1ee84b15, 0x3ee66da2, 
	0x1ee9d08d, 0x5ad959ac, 0x3e434465, 0xe0aef65b, 0xd7a704f7, 0xdf7045a5, 
	0x07c6077a, 0x35f06740, 0xdf5d682a, 0x443ee610, 0xadcf7f05, 0x02b77a98, 
	0xa7ddb9d7, 0x14bb41ed, 0x1c513884, 0xde68f822, 0x77e2bc8a, 0xf5127f29, 
	0x9af2837e, 0x2bdfad13, 0x0b0b59ef, 0x35e81e79, 0x3cc20efa, 0x732e237f, 
	0xf3a267de, 0x50be6a39, 0x1f52cd22, 0xb79f1bed, 0x0cbe4a08, 0xf292f926, 
	0x971941d4, 0xa1ccef05, 0xf9d35def, 0x3f2d24b2, 0x979903fd, 0xf3ee597e, 
	0xba7e6505, 0xcd4be644, 0x4bccd478, 0x99bffe9b, 0xc1c736af, 0x81bdc078, 
	0xfc6e6af2, 0x57de8e7e, 0x7407e527, 0xaf7c98d9, 0x9817f30f, 0xe7fa3def, 
	0xf09af7c9, 0x863a7e63, 0x36d6c6fa, 0x999ddf80, 0x7984cb71, 0x94abe36a, 
	0xdd1310a7, 0xbb7c8193, 0xd6f9fc76, 0xf76ba76b, 0xfb863cee, 0x81e89a08, 
	0x11e9a2fa, 0xfc0ebde1, 0x3d66baae, 0x67d91407, 0x73defa4a, 0xd353e4a5, 
	0xedc6c9f7, 0xdf6e5da3, 0x1378c1ac, 0xb99f0df3, 0x273a4df9, 0xf977ee65, 
	0x29c85fb3, 0x39dcaf53, 0x94cc5029, 0xb67da0d7, 0x87fba9a5, 0xfea287e0, 
	0xe3f3e068, 0x0b7c8e78, 0xee740dc7, 0x9abfb123, 0xeba6e7e6, 0xbc2ab517, 
	0x2669f689, 0x633d2fd4, 0xb9e67df3, 0x8e1fb018, 0x40fb298d, 0xdfa1ffe0, 
	0xf090e783, 0x4adfc75c, 0x1f838e7e, 0xc1fae7cf, 0xbb3cc0ae, 0x8fbcb9e0, 
	0x807945d2, 0xcc93f609, 0x996a69f3, 0x18bef8df, 0x9fa697ef, 0x53b74b5b, 
	0x3845e713, 0x2814d84f, 0x65ab4252, 0x98f1075e, 0x7f79d796, 0x2645e706, 
	0x2bb613cc, 0x22c31fc4, 0x9123f997, 0x8ce53427, 0x36be6af3, 0xf309b396, 
	0x98fe5284, 0x9e40ae13, 0x037e87f0, 0x67dfeee5, 0x41427998, 0xf32694f7, 
	0xc6578184, 0x691913ec, 0x38fa37f2, 0xafd91fc9, 0xde7c62b5, 0x13ee4873, 
	0xe6fce15d, 0xbf84f225, 0x81c27997, 0x5ea08f1d, 0x7cf006d7, 0x0f0d439c, 
	0xa2edf4d0, 0x4db9ce99, 0x83df1587, 0xbfd495f1, 0x7b7cfb29, 0xe5d1f452, 
	0xc00ae8f4, 0xf445de5b, 0xbc2dea28, 0xcd4ff10f, 0x5e677b3f, 0xab1cff26, 
	0x86ee78a6, 0xb75469ce, 0x6efef5c8, 0xac4fb706, 0xfdd603bb, 0x0d1e60ff, 
	0xcfd191f7, 0x35a7cf4b, 0x007d005e, 0xb12078fe, 0x85cf300f, 0x58ff00fb, 
	0x7f23dfc3, 0xd98c46a7, 0x66eb3007, 0xef03f13e, 0x6fc533d5, 0x63dc7493, 
	0xfd03ef9e, 0x53d54de2, 0x57ba1840, 0x981867c3, 0x0d5af957, 0x5cf323db, 
	0x50ae7985, 0xce8b8404, 0xab84f8d9, 0x2f52696f, 0x81dcfb99, 0x3d17ad45, 
	0x0f2e3a77, 0x3595f988, 0x79a03cc9, 0x26f3062e, 0x0e791784, 0x1efa685f, 
	0x46c177b4, 0xecabf7bd, 0x78224467, 0xc6cb428f, 0x66fd537b, 0xfa80373a, 
	0x6fde4ee3, 0x6aefb14e, 0x57b4feea, 0x448c4fee, 0xd0fb3cff, 0x8c172fe4, 
	0xa4db8bf7, 0xc19b6d7f, 0xf13e8ae7, 0x51ff74fe, 0xa91e9fda, 0x3551e849, 
	0x2778ef55, 0x91a96fda, 0x857a347a, 0xf2765bf7, 0x9999cb7e, 0x50bb3ee6, 
	0x04b7eec7, 0xb7ecc706, 0x2dfb69e8, 0xd1e920da, 0x347d04dc, 0xe42ed535, 
	0xdd1ea4c4, 0xfff5657a, 0xdfd47ac4, 0x72be66e8, 0x8c5e5c22, 0x3f934ee3, 
	0xe3898caf, 0xe38e2102, 0xf489be6e, 0x99c749a3, 0x35fadf42, 0x289aa260, 
	0x1f1465c4, 0xfa8bf6e8, 0xe3c5fa19, 0xc73c3b1c, 0x0efc91b8, 0xa52f7d3f, 
	0xb92cde62, 0x0e36391f, 0xd3aa79a2, 0xd25d6fce, 0x71fff94f, 0x1c467fd0, 
	0x7d807564, 0x49f693d2, 0xe0627da0, 0x247f2ec8, 0x2ec0bffd, 0xed09cbe6, 
	0x67b632d9, 0x2edbf397, 0x975d5f67, 0xce3ddfdb, 0x583f72fb, 0x9fea993c, 
	0xa26cff74, 0x9782b2f9, 0x850313f1, 0x41f3cf64, 0xd47ce95c, 0xc15af844, 
	0x3f109af8, 0x84cfc661, 0x7fb8dbfd, 0x6d67bca3, 0xc6f145ae, 0xc30748c2, 
	0x1a38031d, 0x316df56b, 0x23e6cbe0, 0xd610bb8a, 0x72c828b3, 0x458d78dd, 
	0x4d9ffdfe, 0x6bc398bd, 0xd4cea0dc, 0x1d7eb10b, 0xdd1f67d5, 0x8f7a9bd3, 
	0x7dadeccc, 0xb563c8bd, 0xaa4ec68d, 0xea42290f, 0x506c6cab, 0xdb1be2f7, 
	0x4bb37df0, 0xe77f86df, 0xeb4bb660, 0xdd65bcc5, 0xa07637fa, 0xa15f9d12, 
	0xdad6b9d3, 0xe63648a1, 0x0d476ad5, 0x7866d777, 0xc6c9467f, 0x28fcf67c, 
	0x9ad187bc, 0x978a15db, 0xfbcd0557, 0xe46e6247, 0x21d830c7, 0xbb05e7e4, 
	0xfb87befa, 0x1b67b319, 0x87ffc8db, 0xc6fca0d5, 0x8d91e7db, 0xd798e91e, 
	0xd6bf7a9e, 0x531c6888, 0x342389b7, 0x7843bd5e, 0xfef05395, 0x9f1f6cac, 
	0x7b250b47, 0xe39df809, 0xf08fbed6, 0xea7d7ad7, 0x3ce4f2e6, 0x30f37dc6, 
	0x7f1e3da5, 0x9c4f00b5, 0x3c637166, 0xd67c3977, 0x7da11e21, 0xdb7d8bed, 
	0xeb7e0a44, 0xae784e80, 0xefa5ceac, 0xfb9e3940, 0xf7178e62, 0x84df6a51, 
	0x5e25ab76, 0x5aff822f, 0x578e1fc4, 0x7fa16461, 0x64547f35, 0xf5251577, 
	0x3bc47cc4, 0xf88751c0, 0x84dc7d05, 0xb3de8778, 0xbe0f9c82, 0xabf3973a, 
	0x89e63ab3, 0x3e30fdc3, 0x9fb0f3e0, 0xcc37b0f1, 0x4aae2af8, 0xdb1b378e, 
	0xc87db805, 0x40f2778f, 0x38b23109, 0x7d708f33, 0xb9f6b7f5, 0xfc78fb7d, 
	0xfdb1b9d0, 0xbde10742, 0x0399e80b, 0x3c3076f0, 0xd7e05f44, 0xafc0ddab, 
	0x36e3c261, 0xe8986fbc, 0x96d7700c, 0x55afb4e8, 0xfbefbebb, 0xf1c12f74, 
	0x07ae1648, 0x154f05e7, 0x0b2361c2, 0xed358fef, 0xf78fc21e, 0xd4fbe12c, 
	0x39f073fb, 0x180c3dff, 0x9e87e30f, 0x72b7ba1c, 0x603b6344, 0xc9091f20, 
	0x8777a827, 0x10503f80, 0xc45d7987, 0xda536b0f, 0x3e207e4b, 0xd3f927dd, 
	0xcbe41ffb, 0x63f3137d, 0x3e34de62, 0xbebf7b9c, 0x700bba2d, 0x3d3cd1ec, 
	0xbedca17b, 0xf301d7bc, 0x7f64113f, 0x38ffd66c, 0x99f88851, 0xd5ee696b, 
	0xeb33f053, 0xe7ba1cfe, 0x3223deb4, 0xffed027f, 0x03dfda1e, 0x0289afed, 
	0xd47c817f, 0x0b701fee, 0xcb8beba4, 0x41ced17b, 0xf3c5e108, 0x5f04a15c, 
	0xfbc6ecbf, 0x0fdd6699, 0xf8c0f7ed, 0x7e377417, 0xdbdb5ee7, 0xde4051ea, 
	0x8fcc3d6b, 0xf9ad3df5, 0x284a1df8, 0x79d72f21, 0x4f5d5fb0, 0x78e507b3, 
	0x8ed8cbae, 0xa5c73cfc, 0xcefa476d, 0x583cd06a, 0x397eb59f, 0xfeb98dc9, 
	0x3a91c359, 0x165a9f79, 0x05db879d, 0x853fd375, 0xb4d3f546, 0xa4ef7f08, 
	0x613f31bb, 0x5d423de6, 0x279dba4f, 0xd0f7df70, 0x534b9c67, 0x92a2f2f0, 
	0x0ac3e78d, 0xef104683, 0xd1e599c1, 0x01f245b7, 0x1648f6ee, 0x75f4bbda, 
	0xae6fc3a6, 0x27a1d697, 0x1bf04bd7, 0xe138fe12, 0x45718fcd, 0x7589fc3a, 
	0xf083ada5, 0x10f89611, 0xe20d9f68, 0xb0bdb353, 0x18def99d, 0xf983b3ff, 
	0x8dc554f2, 0xea27f411, 0xb8818e31, 0x9fa936a3, 0xb58f10b2, 0x36aafa69, 
	0x365b3eb1, 0x5ba83c31, 0x4cf4fba4, 0xe0046963, 0xfa621a6f, 0x772fdf08, 
	0x237afda0, 0xf7882a78, 0x18f74e35, 0x67a38c4e, 0x289d8ae5, 0x5fc74d97, 
	0x11cb13a8, 0x69a3867c, 0x911facb5, 0x8ea1e7f5, 0xe641e5fe, 0xe56ba6e7, 
	0x9f7e7efb, 0x7e3b9bf0, 0x0a737e48, 0x6b841e5c, 0x2bef8bbe, 0x0f15d46b, 
	0x0ae50fb6, 0x71d0e3e2, 0x0b229f13, 0x6d5a1391, 0xc61fc1d6, 0x5e26f3fa, 
	0xbe0300c1, 0xda26d743, 0x7994fbd3, 0xb3be897a, 0x2f985c61, 0xeb872bb4, 
	0x33ac9e67, 0xdd8b82fd, 0x3df739f3, 0x5eb31f96, 0x64f1cb5f, 0x0bef2d75, 
	0xd57411bc, 0x8aebe2a6, 0x887fa9e1, 0xfa74a5e2, 0x7635cfcd, 0xe31afd20, 
	0x44ed3c09, 0xb3afa53c, 0x4d6f0d29, 0x4a6b7869, 0x1a535bc3, 0x4c4f00de, 
	0xe9e08bf7, 0x4e5e0a40, 0xc8efcd06, 0xf0b7b60d, 0xabb7b23f, 0x8a6ae9e7, 
	0x2f6babde, 0xe15f7817, 0xb559c123, 0xed758728, 0x4a8f74d5, 0x63ac075d, 
	0xde35c61f, 0x9e7dcc17, 0x7af72903, 0x8bfbf489, 0xbdd21fbc, 0x5b7f9311, 
	0x4757fecb, 0xff7bf90e, 0xb95ce96d, 0xd7f9c2df, 0x42217dc4, 0x78e9ce57, 
	0x16b9aaee, 0xcf3107ef, 0x9de79933, 0xca885e2c, 0xcb04cec0, 0x53bfbbf8, 
	0xd2af4515, 0xa14c86f9, 0xe4ec0b7d, 0x52e7407d, 0xa93073a0, 0x8f889c17, 
	0x5fdd3a94, 0x23d34c17, 0xaf403b53, 0x339f537a, 0x1102879f, 0xf92b5e7a, 
	0xd37ef93b, 0xf8257136, 0x9aefe4dd, 0xe79a36d8, 0x768dfc22, 0xeb48ee61, 
	0xb1076beb, 0x8016f66c, 0x185f5267, 0x197cefb7, 0xb9cd2cca, 0x6229ef85, 
	0x4e56d9bb, 0x123f0cf7, 0xd5ba236c, 0xdadd01b6, 0xdd327f50, 0x695aeb82, 
	0xb2aaafff, 0x5b67e898, 0x6887f09f, 0xc6db539d, 0x269437ae, 0xf934a11f, 
	0xe1cf99a0, 0x49cac73a, 0xcc4e4d28, 0x67492ff8, 0x06c8f7be, 0xf51bbf46, 
	0xc637bc99, 0x6eae56d6, 0x8f845f0e, 0xbc516d6c, 0xeb86c5df, 0x0b8ef6c1, 
	0xb0eaf963, 0xa7fafc87, 0xfd53670a, 0xf10f6f71, 0xef88a58f, 0x83fdb58b, 
	0x675d7cae, 0xf338a2fe, 0x9963df08, 0x4ced8f3e, 0x899fc50e, 0xff872dfb, 
	0x3f07e299, 0x9c7083ce, 0xe4f3429d, 0xfe49b67e, 0x9d00a91d, 0x63de4c13, 
	0xa0336cf9, 0xe59f0455, 0xf1fbccf9, 0xadeef71e, 0x10587cc5, 0x03f811ed, 
	0x88fb7bc1, 0x0fd16a7f, 0xd3914fe8, 0x1f79e1fb, 0x4734b73c, 0xf27e1ef0, 
	0x6704e203, 0x8bc930d6, 0x72cc359e, 0xbb0619e2, 0xbdf80c79, 0x13d25dbd, 
	0xf8a64ced, 0x4913b40b, 0x9aba653e, 0xd5f44ef2, 0x4f7d3cae, 0xe3741c65, 
	0x0daaf3df, 0x5ef07b37, 0xe2b0dad2, 0x7a0bbc76, 0xb2d8cb36, 0xcc09f505, 
	0xfdf303d7, 0x97c3d48b, 0xf372f79b, 0xf86ef425, 0x8a7f734d, 0x317a17d6, 
	0xe3ed1b27, 0x5fd636cc, 0x6f58db33, 0x235f0615, 0x03a99879, 0x30f3e17f, 
	0x2fd813fb, 0xf8cebcf5, 0xbf506f7e, 0x1f904790, 0xc64fda92, 0x9fd47e2b, 
	0x578db3d3, 0xf5033cf1, 0xe3f10bf7, 0xde2d70e0, 0x038e6853, 0xcfd8dcfd, 
	0xfa74bb94, 0xeee4f9fc, 0x247efc32, 0xce1bdf8d, 0x277d5c92, 0x7df98ea3, 
	0xfbf12e78, 0x528d25a9, 0x52f9e50e, 0xbf265729, 0x62ba01ef, 0xef9d391e, 
	0x92fb4f09, 0xf071fd78, 0x1fbc5aa3, 0x6b2f1d3b, 0xa4faffb1, 0xbd38027e, 
	0x275fb4c3, 0x85fe1072, 0xe45ef20d, 0xe9096030, 0xad799ba5, 0xbcd4de95, 
	0x09e78a96, 0x2f79bdb9, 0x21edd519, 0x3760b2d0, 0xf77a7cb6, 0x7952e21b, 
	0xed3e402b, 0x0ed98563, 0x623e6fba, 0x94727e47, 0x5c7ebb08, 0xe7071288, 
	0xaae550d9, 0xfe7c7007, 0x457ea3bb, 0x12f3e264, 0xa38b6443, 0xc20fefd0, 
	0x37efa11e, 0x5fb19185, 0x1abe4488, 0xeb384420, 0x0ebd1ef7, 0x0d6beffd, 
	0xcb443bfe, 0x6bbbf9e4, 0x23fc0eb0, 0x807a61da, 0x93e787db, 0x9ba3dcf9, 
	0xbfb90df7, 0xce061bf0, 0xf3e4a197, 0x0c2ba63d, 0xf09ba637, 0x9fdc56e2, 
	0x6ef51df4, 0x7b2ef5c7, 0x5d9fd850, 0xf7dbd34d, 0x49699e61, 0xd1aff9da, 
	0x7dfb31ba, 0x229f7275, 0x7d09f0e8, 0x431fc10e, 0xf2c155bf, 0x72f74179, 
	0x3652fde2, 0x3c965af1, 0xf791e4a7, 0x5e1138d8, 0xd1444b87, 0xc5080ecf, 
	0xd575f785, 0x8ceefe1b, 0xfc1f9c7e, 0xd77cd4eb, 0x16fbb1b2, 0x82bf7275, 
	0x7f4f55f0, 0x0de68def, 0xed097ee1, 0x9f95f893, 0x46bb3f31, 0xb2bdf4a2, 
	0xacca01bb, 0xaab21a87, 0x8d87a8ac, 0xcfba2eec, 0x7f43c7aa, 0x11a1d66f, 
	0xb3638a3c, 0x66ebee53, 0x6f09d3be, 0xf13386e7, 0x427a1d0f, 0x05fef7da, 
	0xc3f239da, 0x1c37fe9f, 0x5592382f, 0xaf11fbc6, 0x2d1cfe21, 0xdfc41e43, 
	0xf7c63d88, 0xfbe12d59, 0x124d26ac, 0x9ce537a2, 0xd1db24eb, 0xcf533bd3, 
	0xfe207edd, 0x4df30790, 0x77c4b7b2, 0xd7bfc36e, 0xefe161d4, 0xee5f81bd, 
	0xc04b7980, 0x89d731df, 0xb5dbe2e7, 0xe7780181, 0xc9166874, 0x22e53157, 
	0xdbd262fc, 0x374e97ec, 0x724b9c78, 0x453bf48e, 0x427ee9fd, 0xf10a26a7, 
	0x0be2623b, 0x0ffb2718, 0x097c42c2, 0x9e61d7e8, 0xae58f8cf, 0xacdefa4c, 
	0x7c01ff01, 0x97cc6937, 0xff3a6740, 0x9f2229a7, 0x03fc08f1, 0x9d20f574, 
	0x3f227091, 0xccaff787, 0x6e455bef, 0xf49c7dda, 0x16b40377, 0x2f4d0eb9, 
	0xf803e548, 0x579ea5e5, 0x17cc111b, 0x42c3f5da, 0x48f824ef, 0xad306d8e, 
	0xf465fbc2, 0x1fc9929d, 0xf100d230, 0x7b902ce1, 0x3bce73a6, 0xb91fc45d, 
	0x9f732801, 0xb7c82868, 0x3e147f11, 0xcf44fa4f, 0x51e7ce3b, 0xbac99ee9, 
	0x63e797fb, 0x89afd73e, 0x7f7c73a2, 0x16139d27, 0xe183e769, 0xd716fc57, 
	0xefc1df8b, 0x0a276de5, 0x87801890, 0xb8373a4e, 0x4f781844, 0x1e4df013, 
	0xecef97e9, 0xf784fb25, 0x7d11765c, 0x5155cfd8, 0xbde24f9e, 0x4277fc51, 
	0x4fd8b310, 0xa1efe0ed, 0xefe14554, 0x42c21cc8, 0x1a6832f7, 0x693a17dd, 
	0x13839f31, 0x0e6677e6, 0x734dee8d, 0x8b763de0, 0xbe633d68, 0x6fba833b, 
	0x8ad5e088, 0x6f78ed87, 0xf2b15f90, 0xec62c379, 0x71fb90ef, 0xe07e7936, 
	0x7f1c75f7, 0xe71d5dff, 0x2e215d21, 0xe25e121d, 0xbd49b9df, 0x25c3e094, 
	0x4be224ea, 0xef88d0af, 0x96116996, 0x50cfef1f, 0x8aa9267e, 0x0a64f3a5, 
	0xc9443b5f, 0x7ce9fe98, 0xa9a5171e, 0xfbc3eaf7, 0x267bd4d2, 0x82def9d2, 
	0x922799fb, 0x746ebf7c, 0xfbea696e, 0x4a87f4bb, 0xc409ef53, 0x5e1291f3, 
	0xf0435f5d, 0x07ddf4ea, 0x142d03ee, 0xafb96ee2, 0x1d7686d0, 0x342ee1e4, 
	0x7c686ba0, 0x7fca9add, 0xb3921eb8, 0x08672525, 0x3e0946cf, 0x4a533b07, 
	0x86a8a9f7, 0x2be7cc36, 0x5ce9c527, 0x0cf936a5, 0xefa4af9f, 0x3efca7a9, 
	0x777e0b70, 0xbe3acbf7, 0xacf8447f, 0x32de218f, 0x19fb6aef, 0x1358cf3e, 
	0x5fa63e6f, 0xb10d4ec2, 0x8c6ed29d, 0xa65d77d1, 0x2e7e98ff, 0xe7150da3, 
	0xe797b608, 0x0dfb65a7, 0xa527f3a3, 0xee2569e2, 0xc913af57, 0xe713377b, 
	0x69ff5838, 0x8311ee9f, 0x9a606f74, 0x38e2be5f, 0xe3ffc7f9, 0x2fae1653, 
	0x1873e229, 0xdf9bd72f, 0xdf104f8f, 0x225dc701, 0x4f371bbe, 0x88bdff07, 
	0x4cb90bff, 0x00003b1b, 0x00036d21, 0x7ded9c78, 0xd754780b, 0x333eee75, 
	0xa3474667, 0x42423491, 0x48c0340f, 0x841a3108, 0x00804019, 0x39648e19, 
	0x07893116, 0xb50ec2fc, 0x383b1847, 0x07556df5, 0xe1c1c2b7, 0x11a4248c, 
	0x0fc230c2, 0x22b8e390, 0xd24e0ec5, 0xc5a43b16, 0x191cda69, 0x2698cb52, 
	0x396271d8, 0x91846e75, 0xc6e89a1d, 0x646df524, 0x3d77c497, 0x249799f6, 
	0xeded351e, 0xdf3bbf77, 0x39f66f67, 0xdac7ecfb, 0xaff5af6b, 0xaaded7b5, 
	0x4612cc2b, 0xd0e210b7, 0x40f8bb4c, 0x97caa788, 0x9b085e72, 0xcc885a71, 
	0x9e734269, 0xbca1acc6, 0x8f7bc06f, 0x37fe282b, 0xb6e11d64, 0x8f0bc84a, 
	0x3672c119, 0x2f13618f, 0x60fb910b, 0xe1844dab, 0x3f52bc35, 0x1a7b842b, 
	0x794c33d4, 0x3c136333, 0x4891e90c, 0xe9abd433, 0xf21ea336, 0x9a30c22d, 
	0xc14c7de9, 0x621742f7, 0x542b542b, 0x50bd0fd9, 0x85efe7be, 0x5d4cf941, 
	0x68068a14, 0x16c2f7ef, 0x17de1b79, 0x80ace10b, 0x05f363d7, 0x1ff7e38e, 
	0x9b4612ad, 0x3eebb710, 0xdfed0235, 0xe861e986, 0xa3ea6a93, 0xd34e501d, 
	0xdb87ec0d, 0x680cda25, 0x1efc7af2, 0x40f0e1c6, 0xbdb06a7f, 0x5c715313, 
	0x046bf60a, 0x0288a17a, 0x143e176c, 0x7ff831c6, 0x017ca9c3, 0xa041b5f9, 
	0xc9afb40f, 0x95af01d4, 0x90572c1a, 0xb1c8fd87, 0x44c8c229, 0x3829893a, 
	0xa334012e, 0x0a7eb6bc, 0xe41bd7be, 0x2a637538, 0xfbb737be, 0x53e7fa2c, 
	0x1f970f79, 0xb7187f85, 0x4335b142, 0xfea768c2, 0xb3a04e9a, 0xa8ff41a2, 
	0x53f29f3d, 0x79e8164c, 0xcf234fdc, 0x93531978, 0xb129b6f2, 0xb63f38bd, 
	0xf14e8ec7, 0x8bf33100, 0xef56a75a, 0x8fe6fa20, 0xe0be54a9, 0x47a20ee4, 
	0xdaf501bb, 0x247e87f2, 0x1ada1fa0, 0x2734015f, 0xbf61ff46, 0xb5067e30, 
	0x47454535, 0x7a77961b, 0xcaeb7fb1, 0x5b7f7267, 0xaafe52d6, 0xfe52e7a7, 
	0x821b9e47, 0xbeec01e2, 0xffdb14a7, 0xd03e921f, 0x2251528f, 0x426d8ec4, 
	0x71a46c89, 0x0abcb1fa, 0x477f6863, 0x2abf7e88, 0x97ea3e9c, 0xd1da987f, 
	0x346d675d, 0x4ea9d70e, 0x390c97ca, 0x96f25f29, 0x8e77be8b, 0x41f7a044, 
	0x8d0b6b68, 0xf90a39c3, 0xfd6babdd, 0x18af7e0e, 0x5fd4427d, 0xefaa0e15, 
	0x7d9b3b43, 0xa42cf3a2, 0xc04b3d3e, 0x6176ddf3, 0x748dddb6, 0x8fd85dd6, 
	0x8d70c2d3, 0xde2bbb42, 0xb40fc178, 0x2fb70b10, 0x49d82aab, 0x4ebc94f5, 
	0x6f251bed, 0xb43f7a41, 0x958fbda7, 0x93e42e6b, 0x70df9fdd, 0xa216ac42, 
	0x3b1beaa3, 0xf7bfa1ab, 0x050ae58c, 0xad6cfdea, 0x6309dc23, 0x94a4315b, 
	0x53dcbf20, 0xc0ed862c, 0xbdf0adc7, 0x2f2efe80, 0xede25cda, 0xec9fefc4, 
	0x7950ba43, 0x068f7f78, 0x3cd297ef, 0x69df49bc, 0xa43e44c2, 0x6d2147ef, 
	0xbdcaaaf1, 0x8d212f30, 0x438be2f9, 0x7c1234c2, 0xab1134a2, 0x0ed8bd89, 
	0xe5b5d3f4, 0x38c5551b, 0x1991568e, 0xd9e72d39, 0x02343a04, 0x3a631fdd, 
	0xecfda145, 0x264a7cfb, 0x9e913ba4, 0x9d6e90e7, 0x04fef541, 0xecba2cbd, 
	0xf45af591, 0x7ce1b5d9, 0x8f3c3155, 0xec7e1dea, 0xc226b16f, 0xf76fe836, 
	0x1efde7ad, 0xd9f3df78, 0xc3fed46d, 0xe1578f9b, 0x1a7ead38, 0x84c2a3ab, 
	0xa1eb12f9, 0xf229255f, 0x4d87e480, 0xeba99598, 0x583e553f, 0xe9d68372, 
	0xffebf191, 0x5d72b54b, 0x4eb8f7e3, 0xbe254586, 0x29763017, 0xe42f385f, 
	0x7284d53a, 0xcd379e8a, 0x9cd4a21e, 0x0cebf38d, 0xd782951a, 0xd9fd8993, 
	0xa1936db3, 0x54db7cc0, 0x2053f99f, 0xee879ef4, 0x9f40288b, 0x45c2fb8a, 
	0x8a9463d1, 0x62bcf0fd, 0x5f7a2193, 0x618b7482, 0x36fcc2ec, 0x31cee173, 
	0xf9c14d6a, 0xf8613311, 0xf38b1f28, 0xca5b3184, 0x1ca4bb97, 0x0fc42839, 
	0x04e7ce90, 0xee7a0209, 0xb9ca3a11, 0x11fe481f, 0xd100e6b5, 0x25396347, 
	0x3ebea09a, 0x8c2c5f2c, 0xf1f28933, 0xb0e72872, 0x59ca185c, 0x3d136ef2, 
	0x1eaf9037, 0xdc9040d5, 0xb1fec427, 0x74c995a5, 0x57b633ec, 0xbcaddd22, 
	0x833fb628, 0x62a1f7df, 0xaf46fa80, 0x20f925ea, 0x2ec4c5d6, 0xadd7cf98, 
	0x1db905fe, 0x7f385392, 0xd21fa03e, 0x4fb5de09, 0x4cf4f6a5, 0x2845f768, 
	0xf482d99f, 0x937b8231, 0x3def03e8, 0xe08f9fd8, 0x885db9d7, 0xa31e9263, 
	0x37aed477, 0x76f1080e, 0x7f913086, 0x783efdf1, 0xb663959f, 0xb338c2f5, 
	0x6e86cdb2, 0x1842f885, 0xdb9656d0, 0xe4f245b4, 0xefc45577, 0xcd0a53f6, 
	0x528863bf, 0x79cc31d3, 0x3bce59e7, 0x8747e00d, 0xf4617fbb, 0x53e1a638, 
	0xb482eecf, 0xf383dc40, 0xbabeb507, 0xf629680b, 0x9fe21c8b, 0xa5d3961a, 
	0x54157f53, 0xb6e90e49, 0x364df308, 0xad464df2, 0xaac4839e, 0x67dc7951, 
	0xd2eaae66, 0xb0ef7ea0, 0x17ed11d9, 0xbd72b7e2, 0xd6f0e359, 0x14c88c89, 
	0x85200b48, 0xbcdd7b7e, 0xb943cf4e, 0xcf07e452, 0x3e7132af, 0x9f277c8e, 
	0xde6e78f8, 0xcecbd279, 0x0b334755, 0x0e6a7e60, 0xbdb0d01e, 0x5b1b9f45, 
	0x2e9e402c, 0xb17475da, 0xea2ced01, 0xcb74e318, 0x7e7a12d8, 0x46c4b987, 
	0x94906ffc, 0xed6ef45d, 0xec3f7c52, 0x7bededd6, 0x00164e61, 0xdfbda0ed, 
	0xc40b9c7a, 0xb0f313af, 0x07a38e4f, 0x7bc3e7de, 0xa1e50bcd, 0xce7b23bf, 
	0x1fd035d9, 0x57447267, 0xe8d06414, 0xa3ebb5e3, 0xa0db4f30, 0x3125a79c, 
	0x7e9b5e5f, 0xae56b187, 0xf8689867, 0x3e02e8d4, 0x74639298, 0x987ac2f4, 
	0x76346d92, 0x1c9cf3c3, 0x47207750, 0x150db8a7, 0x67d604c5, 0x68f90b3c, 
	0x0cdaed50, 0xe8b170e9, 0x1c283904, 0xde100efe, 0xefe18a62, 0xbdf682ec, 
	0x8877adad, 0xac79e157, 0xf6c7ea96, 0x21ed0f28, 0xb1999d5f, 0xe3e90bb4, 
	0x2abbecdd, 0xfd90fc02, 0x51b56aa7, 0xe8e1c428, 0x73a8edb5, 0xf20650a1, 
	0xe8cf1411, 0xa9df4d5e, 0x3dc7cf38, 0x9d46372c, 0xea92b120, 0xe8b17ecb, 
	0x2687ce38, 0x0de6ee58, 0xe51384fb, 0x45b6b473, 0xd61f18fc, 0x3d71fe0a, 
	0x17e676e6, 0x43b848ef, 0x55ab7c90, 0x7467680d, 0x05bf943d, 0xdfb8858a, 
	0xdab14f1e, 0xebe32ff5, 0xd10db519, 0x3306537a, 0x25db8ff3, 0xd7ae809d, 
	0x24b47ce0, 0x85d1c78f, 0x471af1e3, 0x3c651be7, 0xfe455f7f, 0x157c836a, 
	0x5207173f, 0x6fa00b9f, 0xccb087ee, 0x9075a1df, 0x5404fd8d, 0x0e106d92, 
	0xa20db3d4, 0xd94f5087, 0xcf8abde9, 0x7f03d6b3, 0x0cdf9f03, 0xbea317ed, 
	0xcce5aed9, 0xf390e000, 0xc61f87a7, 0x7d40f9f1, 0xfcefc61d, 0xe708dbaf, 
	0xf967cc64, 0xdc22a9eb, 0xa58ae0f9, 0x7c308f44, 0x7e057a8f, 0xe48321b6, 
	0x73663d7f, 0xa9be309c, 0x34f44f5c, 0x3f528fbf, 0xedd7990c, 0x017bbf98, 
	0x4c1123af, 0xc7a8e76b, 0xd0daf98e, 0xe02ed96c, 0x9a939456, 0xc6491039, 
	0x12d712b9, 0xbc43ed9e, 0xfdf1377b, 0x142e7a38, 0xfba6065d, 0x3f23e7fb, 
	0x1bbf0366, 0x47ff21fb, 0x0f8685c3, 0x6174a3fb, 0xfcf5f1fd, 0x31f0a839, 
	0x6fd9ef12, 0x5bffbac2, 0xa49fe7e8, 0x888653ce, 0x5029b941, 0x6336a60f, 
	0xf0faf27e, 0x9f30be0e, 0x465ccdf8, 0x811ef783, 0xb43fbe3c, 0x1e77df8c, 
	0x7cbf7ce5, 0x6817edff, 0xf8d7331e, 0x1f9c1432, 0x581ee03f, 0x9937a357, 
	0x2cadb66d, 0x7c4ed49f, 0x84eb6fee, 0x7d0392f5, 0xa416fcee, 0xeb8abf7e, 
	0x7c0fcb27, 0x7dea1cf7, 0x55d714b3, 0xd9d7df8e, 0x218bdf05, 0xd7ce2967, 
	0xa42f4f55, 0xde54faf9, 0xe7100bb3, 0xb47add65, 0xcbea06b4, 0xa1a73169, 
	0x44b33f7e, 0xdfcbd2a4, 0xe2daf24a, 0x2ba68733, 0x8e7c4e34, 0xf5f4287c, 
	0xaf18ffd4, 0xc1a751a7, 0x087e04fa, 0x8208dfd7, 0xa457f904, 0x12d5c81f, 
	0x07a82796, 0xe71fbd28, 0x81039f93, 0x5d679c14, 0xfaaa75e7, 0xcf24450c, 
	0x11efd9ef, 0x2c751c5f, 0x2d883e62, 0xf0fbfe27, 0x1e1685b7, 0x3b9f13b0, 
	0xfd445e5b, 0xdb5a0a2e, 0xc26c90fc, 0xfbae5076, 0x519a6f81, 0xae6b03ae, 
	0xf503b146, 0xad4f3cc3, 0x4ff53af9, 0x599eb9fd, 0xa0d5b84a, 0xc630dc7a, 
	0x97ae118e, 0x3385bcf0, 0x7ac76984, 0x2be3758a, 0x3ab7a036, 0x155556bf, 
	0x5baadf92, 0xffb7dc41, 0xe11bae18, 0x710c759f, 0xa60ce8fc, 0xfa821287, 
	0x86dfaa0c, 0xde70a9fa, 0xb9402ddf, 0x241cdaef, 0x190aeb5c, 0x9e4867a4, 
	0x43a0907f, 0xc2733ce1, 0x7e922d72, 0x3c715c9e, 0x41a8fd02, 0x64415ffd, 
	0x274e32af, 0x70c1d870, 0x70c66745, 0x70b28e12, 0x118be21a, 0x76c9a7c9, 
	0x9671c5db, 0x61230dff, 0x8f01f537, 0xd1dea138, 0x80b3c626, 0x3101a153, 
	0x7d91cf0e, 0x5f712c30, 0x9b33d50d, 0x89c41bec, 0xe81a51ab, 0x6653967e, 
	0xb777e626, 0xfce2f7a8, 0xef60cd8b, 0xad7546ad, 0xea8e2255, 0xd46af893, 
	0x0debb80f, 0xaa25b841, 0xe1267024, 0xfc0923a0, 0x7d55b078, 0x5d120949, 
	0x70bb6494, 0x76089c52, 0x1fd910e6, 0xe771d126, 0x0afd074d, 0xf6b9df3c, 
	0xf10d7e1b, 0xf79f1ff0, 0x4cfbe017, 0x1b7af991, 0x4caea3e2, 0x803cdbb2, 
	0xda9fa097, 0x2a438ab2, 0x7f9ccb94, 0x6a2f66df, 0xf56382e6, 0xc4ef4867, 
	0x36277184, 0xea02ebcb, 0xc0f908ff, 0xd7e3cbd2, 0xb513af0d, 0x0d8e78fa, 
	0x2cc765f4, 0x4f00aab0, 0x11ef5dac, 0x0ed08f28, 0xeff4003b, 0xf5b45178, 
	0x2db7bd03, 0xf2c78982, 0x4c6f185b, 0x0b567c87, 0x95c40bcb, 0x27f7a899, 
	0xc7a097b0, 0x9cff9c2e, 0x596bd636, 0x34dac7b7, 0x6d279fe4, 0xe2af9c6e, 
	0x71025085, 0xced37d58, 0x64678c00, 0x03cdbf7e, 0x7dcc77cf, 0xcbd204eb, 
	0x65cbbfea, 0x3fd019b4, 0x1b36ded7, 0x75ac8282, 0x86b0c7c0, 0x9b7efe5c, 
	0x34e907d8, 0xd6720f78, 0x73e3f505, 0x28e6bbe1, 0x43342dd2, 0xb00d23d8, 
	0x7b740ade, 0x1f67de04, 0xc48d686c, 0xa097deb8, 0x5365915e, 0x4f23e055, 
	0x61b54dab, 0x2760367d, 0xe81e4718, 0x5663a263, 0x17df039b, 0x7039b6b6, 
	0x79d6b9dd, 0x1c607976, 0x1afc608b, 0xd63f5f8e, 0xa7d021f1, 0x63ac30f0, 
	0xde7c1f78, 0x98938bb4, 0x76410e1a, 0xeb81d889, 0x67a0f834, 0x5bfb6097, 
	0x41f7c08d, 0x4e228ed9, 0xefdf2438, 0x8a5d0188, 0x9a43af50, 0xc2deed2f, 
	0xd7675cb1, 0x50def8d3, 0x73ef839f, 0xc7cc5f5b, 0x087623b5, 0x9d740a8f, 
	0xb55fb072, 0xbbe53cc3, 0x5441c24d, 0x3647cc3f, 0xdddb13ac, 0x66775dfc, 
	0xb1458e82, 0xcc050ff0, 0x1dd21777, 0xb8b7e3e5, 0xda55029e, 0xd61e927b, 
	0xc85a5fb8, 0xe46fcce3, 0x30a9cdf9, 0xe54ed8ec, 0xd613c642, 0xf2dabbbc, 
	0x5ff32176, 0x217190bf, 0x65af49e4, 0xa5d9eedd, 0x071e7f41, 0xfea1e57a, 
	0x17e4141d, 0xb57b6aca, 0x1d400c4d, 0x0a5d9a6b, 0x7c27b9ca, 0xe03e9d6d, 
	0xd0081f53, 0xdc1e75a4, 0x320056db, 0xd635ac43, 0x59fd6016, 0xb2a9b748, 
	0xe312c7dd, 0x7188bc5a, 0xb53255e4, 0x85f15fec, 0x36d72621, 0x107f4155, 
	0x7e96ead4, 0x5dc93717, 0x445dfa5d, 0x90e59bbd, 0x58957eca, 0xcb7fad31, 
	0x55ab565e, 0xba616fe6, 0x516c7f49, 0xed5ae709, 0x807e46af, 0x90bcbdf1, 
	0xec63f253, 0x9417ac4d, 0x27c6318b, 0xa3718c4a, 0x90907cf0, 0xefca1f8b, 
	0x24abca04, 0xa76e9af9, 0x403e9a2a, 0xfc9a6876, 0xe2963923, 0x2176932f, 
	0x0cf2077e, 0xe4cabaec, 0xe4bd42f1, 0x0b3b4227, 0xb72599e5, 0x323c5ec8, 
	0xfc817e5e, 0xccea3924, 0x187cafe8, 0x19ac669e, 0x24663fae, 0x1abe8ee4, 
	0x24a83bec, 0xd1da6394, 0xf2ef856e, 0x6ddc9db1, 0xb39476e1, 0x43ac376e, 
	0xb6ec8898, 0x1ded8629, 0x451e272c, 0xb057723e, 0x21cf40bd, 0x163a06ed, 
	0x5cadfcc3, 0xa988f3c8, 0x83d0d20f, 0x0bd176be, 0xfe79cbe5, 0xf67cdb43, 
	0x7c9eb805, 0xf527dec2, 0x78ef8e33, 0x5dcf8f01, 0xb7a8aba1, 0x9f402b72, 
	0x2735a20e, 0x4766ef48, 0xdccf447d, 0xec77ac30, 0x8edfc3a7, 0x814facfe, 
	0xf280edde, 0x01f6716e, 0xe8f0f005, 0xc3b78966, 0xfaadb78c, 0xb79e7c2d, 
	0xf805c78b, 0xd87a4edc, 0xb95be590, 0xf1d71bbc, 0x19ebe3bd, 0x7a229db5, 
	0xcd4f36b9, 0x9fe248ef, 0x30e9dbff, 0x69da0fcc, 0xd788b17f, 0xaeb58175, 
	0xf228f845, 0x6bd08e67, 0xb812379f, 0xffd701b5, 0xe2f2f196, 0xb84e785a, 
	0x885d884b, 0x14786773, 0xfc8af381, 0x12b9f12f, 0x25affc95, 0xb949fff1, 
	0x52fee36e, 0x22a5ffe4, 0x7ee3c7ae, 0x208f4d1e, 0xfaf4b72e, 0x116fbe38, 
	0x5274e37e, 0x8de18bf9, 0xf96475b4, 0x61dc2c41, 0x1fcb06e1, 0xf204e162, 
	0xfc27b4a3, 0x1a3ad659, 0x10dcb20d, 0x60dc649f, 0x0fcb5fad, 0xf2c2f845, 
	0x5f8cd4ab, 0x6138c967, 0xa68bfc90, 0x7aa514ff, 0xd06e3255, 0xb1673c1a, 
	0x6f9fe65c, 0x60788cdc, 0x2ef7d863, 0xe7f247ae, 0x975f8c94, 0x24b3fee9, 
	0x57429339, 0x7449bfab, 0xfad2ba27, 0x6dbf80bf, 0xf9647952, 0x277e1295, 
	0x1e4098c3, 0xc4d6e9c5, 0x3e5d3f72, 0xedbfc1f5, 0xf3f92777, 0x3a22de24, 
	0x1d00ba6e, 0x17eb0d37, 0x5d8dcba2, 0xf49da062, 0x38d27082, 0x9679dd14, 
	0xc4e9a914, 0xc6fd66f1, 0x71de40c8, 0x637cf948, 0xff415da7, 0xf603820b, 
	0xcc59ea8f, 0x945646d7, 0x515980fd, 0xb4b203b6, 0xb43bf997, 0x2eb89d3b, 
	0xa76c17de, 0x4879fbc0, 0x274d4e67, 0xf8f5e3e8, 0xf9da0b7e, 0xea41d31a, 
	0xeeb72abf, 0xf7e63942, 0x4f619708, 0xc7665f5e, 0xd55ff000, 0xda3b669a, 
	0xf0ec7e71, 0x4c7d093d, 0x8238c1df, 0x204f6b6d, 0xa08008ee, 0xf5cdde74, 
	0x6bf492c7, 0x57617df6, 0x1fd7335e, 0x7bde06bb, 0x8fc748f4, 0x7fe1e459, 
	0x8a18fc71, 0x6b4bf4a6, 0xfb436bcb, 0xa30792cd, 0x05bbbe02, 0xefbc25d7, 
	0x196de390, 0xeb4977cf, 0x8b05ed9b, 0x90bda4cf, 0x7301f42d, 0x75fc04e7, 
	0xf258ebb9, 0x2fd785ad, 0xc09cb7e6, 0xbeeb4c9f, 0x47e1d833, 0x2746ee7b, 
	0xcc769bfb, 0x40acdeab, 0xe2bdda7b, 0x0db11750, 0xd3e259eb, 0x8376f18a, 
	0xf4b507e5, 0xc8beb5aa, 0xe09c395e, 0x1bb14be3, 0x45bef24e, 0x1f44ebd5, 
	0x4c2deaa3, 0x6bb5bfa5, 0x48874df9, 0xf36a7c1e, 0x4e87e459, 0xea0ff0d3, 
	0x9274f5e3, 0x0f62907d, 0x909fe28b, 0xa7e4f85d, 0xc6df72ed, 0xd1eefa45, 
	0xb22f5345, 0x1b1a07ef, 0xf6c9fcec, 0x13b5c6fd, 0x13b53efa, 0xdc8575f8, 
	0x3b53f2df, 0x128583ea, 0x0ed64d87, 0xec0bc820, 0xf7cc8e2f, 0x08c441d9, 
	0xe7a74bb7, 0x99c006ee, 0xb7b1ce50, 0x62362ec1, 0xaa03ec1e, 0x3f07df9e, 
	0x16476a17, 0xff672ecb, 0x7fa09bcb, 0xaabf02e6, 0xc4113ceb, 0x47ac0e9b, 
	0xbfd0fbe0, 0x1fa95a05, 0x43eaec1f, 0x45c1e77f, 0x613bf913, 0xdf094a6a, 
	0x8c694619, 0xc697adc6, 0x5298de40, 0xf3c8fc6e, 0xf4ffdcd7, 0xf5e1b1fd, 
	0x79ffbf94, 0xadf8ca5b, 0x330a32f5, 0x5698fc61, 0xcd47ad03, 0x9abb55ef, 
	0xe127eb13, 0xe4ff614f, 0xe54196a8, 0x8de33a6d, 0xaff626ec, 0x9ca7afa4, 
	0x3b4742cd, 0xd0dd7d3b, 0xae586bfe, 0x7bf2839f, 0xf4278bf4, 0x6c8fad2c, 
	0xe8632fcb, 0xf3a78f6c, 0xffac3ab1, 0xec09e694, 0xe04b92d6, 0xf20196bf, 
	0xfc853cbf, 0x1950f647, 0xde5345f1, 0xc5f08bca, 0x3fe4179b, 0x03e034c7, 
	0x39608be0, 0x3f685fd8, 0x82d53c06, 0xda0a4ffd, 0x11ff3089, 0x79f6ee7c, 
	0xf4f8a718, 0x3f6853f6, 0x87b4f46d, 0xa99ed8f2, 0x33b8873d, 0xa0f361d4, 
	0xbd2ba59d, 0xdde87f50, 0xe817b50c, 0xb633b795, 0x9d7643c3, 0xcd5de8e9, 
	0x6fbe71e5, 0x27e42780, 0xa03b062d, 0x776ef19b, 0x3813ed33, 0x57c05122, 
	0x46b4d715, 0x974f583c, 0xf3c4fa8a, 0x68590028, 0xd4302d5f, 0xebb462de, 
	0x3d7b6a1a, 0x7c033e09, 0x757c4765, 0x2fef117e, 0xa3b2ee02, 0xb30ee6dd, 
	0x4068123f, 0xb2aa9c76, 0x17f6e8dd, 0xe1ea05d9, 0x07f9e1bb, 0xe86e8fdc, 
	0x4a16eab7, 0x855dd82f, 0x843b431b, 0xe17f5137, 0x083b62d7, 0xa98a1fa7, 
	0x14c6f402, 0xf14e9f69, 0x428f91bf, 0x3a6dc8bd, 0x2e3fa1ba, 0x583cb9e0, 
	0x0ed28527, 0x3fa171c3, 0x517481dc, 0x60bd7c78, 0x986bbb67, 0x048ba30e, 
	0x3cab01e9, 0x005f71e6, 0x7a8b5fc6, 0xa7135b2d, 0x3bf441c4, 0x1fb63b09, 
	0x84f309dc, 0x8677e176, 0xd137a555, 0xfdaba43f, 0xad38c4fd, 0x7fee8d71, 
	0x5ff466e1, 0xdbf1999f, 0xd092516e, 0x609e7347, 0x13ce73fb, 0x58576425, 
	0x61aeccf5, 0x4c96767b, 0xe88a0517, 0x764f7c3d, 0x84cfbe2a, 0x5b9a2dfe, 
	0x27e7ca64, 0x9f063f71, 0x895afda3, 0xaff50b3a, 0xf20d47a6, 0x97da422b, 
	0xa16cbfa8, 0xd7bf1eb5, 0xc735fc8d, 0x3fa37665, 0x72344e73, 0xc157fb33, 
	0xcefa00c4, 0xbcf21079, 0xf94592bf, 0xb3efe2fb, 0xb9cd1170, 0x45defe23, 
	0x9901a6f9, 0xe5835107, 0xa1bcadcb, 0x3832be61, 0x2fee30fc, 0x80c30656, 
	0xf4f52151, 0xc46d1c3f, 0x3fbfdc34, 0x9c50521b, 0x0d2097b1, 0x0768b699, 
	0xc39ee1a6, 0x161c3ef8, 0xaa630fdd, 0xcb3afccf, 0x27f6ccb9, 0xff01af20, 
	0x6416fd02, 0x30a327e9, 0x2e92edef, 0xec6dd6e3, 0x776eb457, 0x99785eed, 
	0xbc6a037a, 0xf4af3c80, 0x03b3fb71, 0xc068afbd, 0x8cb9575f, 0xe89ea89e, 
	0xbe7ef587, 0x1c39eccb, 0xbeaf72c6, 0x74c6ec12, 0x50c52bed, 0xde973ccf, 
	0xf2e4dfb3, 0xa29c73c1, 0xb752abbf, 0x027b5dea, 0x2e5550fd, 0xbd4a677d, 
	0x26fde1ba, 0xd0bde3ef, 0x9bf20d3e, 0xc418fde3, 0x8cbb947e, 0x6bf97268, 
	0xd08abd64, 0x7bef26dd, 0x7c718d64, 0x4a39d642, 0x36d9d74d, 0xffef3ed9, 
	0xc17e38b9, 0xe4d94ed0, 0xa0a7e073, 0x58a5ec0b, 0x903b3f22, 0xb6e20af7, 
	0x31e8976a, 0x65f7c4cc, 0xb3065d72, 0xdb2449c4, 0x7637813b, 0x3d2038e1, 
	0xfc9d59e9, 0x7027abfd, 0x9975cd3d, 0xd3dfe33b, 0x83c65ef3, 0x79ed232e, 
	0xbbf7951e, 0x97f3fa44, 0x4b8579f1, 0x38f3e374, 0xf775c41e, 0x0bf5f22c, 
	0xe01eb337, 0x0f3986fd, 0x23f71e42, 0x3efe645a, 0xfbcc3ef9, 0x90ee730f, 
	0x479c43ef, 0x61f704d3, 0xc07d34e7, 0x5df975cf, 0x387bccb9, 0xd17ede3f, 
	0x9a61f153, 0x4e1d027e, 0xbc24c77e, 0xb3f14ae8, 0xae277b4b, 0xa0f4d2af, 
	0x2ba96c7f, 0x6c655f39, 0x45e32577, 0x64daac37, 0xfaeb893d, 0xb7cd3b78, 
	0xe13b75fb, 0xb0ff8a49, 0xe3d3b7f6, 0xb484aa2f, 0x0f1ea503, 0x7fc8d936, 
	0xe1f1173d, 0xfb2faa02, 0x39c7a82d, 0xfe85dfa7, 0xafc6a696, 0xdfa835b9, 
	0xe1ffa4b5, 0x6820ac76, 0xbde389df, 0x18e78e7e, 0x86f32292, 0xc371ae4f, 
	0xf07fd5fb, 0xbe00bbb6, 0xce1edebb, 0x1260b2fe, 0xbd1a7ca3, 0xf7faca25, 
	0x00e898c6, 0x9b7ab179, 0x3b2c4670, 0xd013abfb, 0x4bef4133, 0x26f167a2, 
	0x79c5ffe9, 0xf4f8fee8, 0xc5a67a45, 0x124fb97f, 0xe96cf57d, 0xdfa177d7, 
	0xd12fa2c5, 0x168e8933, 0x8e9e615d, 0x5d113ce1, 0x2ae8240f, 0x7c015e24, 
	0x4f7c42ed, 0x6f9007f1, 0x0bbbd86a, 0xcdd34fe5, 0x90d3dd87, 0xf3768dfe, 
	0x5fd3ac0c, 0x911c70d5, 0x55ebe745, 0xc3cc2fa0, 0xe30f61e8, 0x45db10fd, 
	0xf71cf3e9, 0x0ddd0243, 0xbe7f8620, 0x7f7a8138, 0x3cfda9f4, 0x43c6211f, 
	0xdf15dfe9, 0xb8e5f6c4, 0x138a67ef, 0xdff1b1dd, 0x0d55aa3b, 0xd78748ed, 
	0xc702f8a4, 0xa03b807d, 0xc61aeadf, 0x216e59a7, 0x5b54811e, 0xf40dba0c, 
	0xd71b639e, 0xd2a6fb8f, 0xc98b692f, 0xebce537d, 0x5bcfcc76, 0xa1dcfd2c, 
	0x3fe72413, 0x78e018dd, 0x9e52c586, 0x3ed317f5, 0x6ab1f399, 0xfbc6cf19, 
	0xfd358ea7, 0x391f5107, 0x723eb0d6, 0xbb110d78, 0xe10dd20e, 0x09c41ec8, 
	0x7bebf4db, 0x45f4df58, 0xa43ace41, 0x8c84501f, 0x559fb44c, 0x367313b0, 
	0x26517c52, 0x8b59e5ea, 0x7f604f19, 0xf40d8e39, 0xf5ece20a, 0xb09ec927, 
	0x2a6225fa, 0xcfef9fe9, 0x2371259f, 0xf6c99beb, 0xc0f29f75, 0x90f49308, 
	0xfd8bbfb5, 0xa5507e40, 0x40fd8abd, 0x06b5317c, 0xd309ffca, 0xf63ee505, 
	0xdd7aec8b, 0xf49a7da0, 0xebf7f1f2, 0xf38f7e27, 0xd5657ec2, 0xdeb5fd8f, 
	0xdd43ec27, 0x9f7ec83f, 0x5d40fd09, 0x71d88f2b, 0xda1ea8ff, 0xd8f98629, 
	0x6df9a651, 0x6076133b, 0xcf47f2d7, 0xfa4b5706, 0x885d1c62, 0xf7a321e3, 
	0xee10e77f, 0x9ca3fd33, 0xdf5d3dc7, 0x48baf2a9, 0xbe28d80c, 0x61b0b361, 
	0x0363837c, 0x2dd44bcf, 0xdfddfc52, 0xbafecc5b, 0x69fa6527, 0xd4327ac1, 
	0x2668fe51, 0x85c022e1, 0x251bc740, 0xdfa484ff, 0x1cc5b6f6, 0xa48b72a7, 
	0xf810a85f, 0xd66ef015, 0xc3c20691, 0x40197df1, 0x54ef883d, 0xbbbe17ac, 
	0x37ef3179, 0xfbbf097d, 0x1f3f8d0d, 0xc8fc93e7, 0x9d421eb0, 0x6f38230b, 
	0x1bbadb6a, 0xbd5f32e7, 0xeaf80bb9, 0x10ff4951, 0x30e3f3f0, 0x11c6d1bf, 
	0x6563c61b, 0x047b0877, 0x12a846e4, 0xd120c0e4, 0xc71c96d5, 0x6cdb86a1, 
	0x26dc3fd2, 0xf20c9fc8, 0x89fa587e, 0x6f660641, 0xa015db0a, 0x0dd82653, 
	0x629fc04e, 0x4fdfbc1e, 0x4fe260fe, 0x2f69b5f5, 0x6d1cbea2, 0xba19f192, 
	0x6c21e715, 0xa8647ec9, 0x55eb0db7, 0x8cdc5fd1, 0x97965deb, 0x5d51e47e, 
	0x567d8ffa, 0x1ff4877c, 0xbf3eba1f, 0x2457f703, 0xd448c7de, 0xee826648, 
	0x28f9c00e, 0xb33cc4f7, 0x5597c70d, 0xe30daa7e, 0x0f6eb36f, 0x593c70d9, 
	0xd8ba389f, 0xddf625f0, 0xa4674935, 0xeee50c6b, 0xdeb64bc8, 0x938e4917, 
	0xaa7c03bd, 0xed3640c4, 0x8999f396, 0xb2ad01f5, 0x717b7e0e, 0xbfd2106d, 
	0x21f9a991, 0x74c9afa7, 0xc6ffa644, 0xdf9223e9, 0x258ac4b2, 0x59dfc0b5, 
	0x79a53853, 0x811db30c, 0x357737ee, 0x5fec43d8, 0x9f81ba53, 0xfdcb175a, 
	0x7ed26123, 0xdc7c767e, 0x77d15f6c, 0xb03467a8, 0x7c13ba6f, 0x29f0a8ea, 
	0x36afb076, 0x76bf662c, 0x80a1b477, 0xf1d278e2, 0x399f9a44, 0x7e920fee, 
	0xffe92ea9, 0x411be001, 0x97fba73a, 0x0abfae3e, 0x2fc14dea, 0xb3b38d17, 
	0xff5077f6, 0x33f78c55, 0xfc8a1fa3, 0x250fd27c, 0xfb8bbea4, 0x155b5aa3, 
	0xc9fdb92d, 0x63de4efc, 0xa72fee3a, 0x358c91fb, 0x07784151, 0x15c505e4, 
	0xaf3d265e, 0x76acfd34, 0x2a5ff1ac, 0x70c6b4fd, 0xf179fd04, 0x171853b8, 
	0x9e8b78e2, 0x7f64af44, 0x3f1176b3, 0x85038c9d, 0xf40e297a, 0xbbdf26ae, 
	0xf4b1f0c7, 0x8d39773f, 0xc524f62f, 0xf4f1c631, 0x7f577e64, 0x397feb2f, 
	0x4d7ad68f, 0xb8e6b7f7, 0xb5ea3b0d, 0x1be03147, 0xaa8e68f0, 0x0991e17f, 
	0xfed2b1da, 0x64fe15b1, 0x69c7a4fa, 0x3779e2aa, 0xe1d16b8e, 0x6949d13c, 
	0x85a7c909, 0x9f00a728, 0xf666a88e, 0xc77f9c7e, 0x6e2987a1, 0x062d1757, 
	0x5bf1a7f4, 0x8c9648cb, 0x72c65fee, 0x745c484c, 0x1c65e648, 0xdcde5592, 
	0xe2b44cb7, 0xed499b7b, 0xfca11967, 0x979fb00e, 0x05ef3b7e, 0xf1c79ecb, 
	0x25bdafe2, 0xb92127c1, 0x49ae5b4f, 0xbdd20b3f, 0xe04f613b, 0x84f5c71a, 
	0xf804b0f8, 0x1a6ddca2, 0x15bf687d, 0xed0a9994, 0x265d8967, 0x20da69db, 
	0xa76b91c7, 0xc4399f38, 0x4a61ccf9, 0x99ea1775, 0x37e115a9, 0xa70f20a2, 
	0xecd78756, 0x9dee4002, 0x1f6afe2e, 0x474a89db, 0x4af73c29, 0xdc2c52fc, 
	0x3c29e7e8, 0x306b646c, 0xf54745ff, 0xfc1ff41c, 0x93d612f1, 0x5aaf53a5, 
	0xf1d37182, 0xeb2f50f8, 0xe7fc4481, 0x9de228f6, 0xe2806d32, 0x492e973f, 
	0xab2cff8d, 0x17f435d3, 0x9a401595, 0xcbd4a907, 0xfc644b75, 0x1487f867, 
	0xdef399ff, 0x6e77aa7c, 0x7c01bc1e, 0xe8f87353, 0xfa8db160, 0xd163b843, 
	0xe38b03ed, 0xffa005fe, 0x2eb67ba2, 0x434ef8e1, 0xd0c07dc1, 0xbfb7d612, 
	0x412c34f5, 0xefee93bc, 0x69715a14, 0x5e98708c, 0xe9d1b8ca, 0xcb6cfdc5, 
	0xa3df89af, 0xe791f89e, 0x58bed4d3, 0xc7179b7f, 0xa2fd91eb, 0x8a66ff78, 
	0x5c67fcb7, 0x79434f37, 0x1a18abf6, 0xc97f3bd2, 0xd71425ba, 0xf43c87e5, 
	0x51b77bd7, 0x67a7718f, 0x7468f472, 0xee23d798, 0xb6799623, 0xfe81a1de, 
	0x274923fd, 0xcc2317d4, 0x8c30ca75, 0x900efcab, 0x731fc0db, 0xef4847d7, 
	0xdb4e8a05, 0x68bcf8bc, 0xa3e23d6b, 0x48cc7bf2, 0x5f7f3d5f, 0xbca2b80c, 
	0x2503d7f0, 0x67f4bcf0, 0x1a12b6ad, 0x23bf9a57, 0x4c96ce78, 0x4836715f, 
	0x8ffcb7f8, 0x53f1175c, 0xf0170b42, 0xec6f5653, 0xaa3ad08d, 0x78719018, 
	0x78718686, 0x671cfd05, 0x27c87957, 0xf2af1e30, 0x73adbf90, 0xff1ca633, 
	0xcfabe159, 0xfb963a44, 0x1bbce884, 0x99033ffd, 0x10fcbe58, 0xf6cdebc7, 
	0xa1fdf847, 0xfef4e2c9, 0x4e67e69e, 0xd5a50bd1, 0x9ebefc4e, 0x4e9461ce, 
	0xcf04b1dd, 0x76e00045, 0x933f2447, 0x3913eb7c, 0x6be46fd8, 0xb7c64fcc, 
	0x5fbf25bb, 0xb11f6f8c, 0x8d7f56f8, 0xe713d6f8, 0xe62647db, 0xc5910ddb, 
	0xb7c43e92, 0x435d6ec3, 0xc4bc3d7e, 0xbfde478a, 0xfcff2264, 0xbf15f8c5, 
	0x41fd3f67, 0xf08ba79e, 0x9f4f826b, 0xfc92f6a1, 0xfbf451f0, 0x62fc6195, 
	0x46b8f8d9, 0xa42cfe7a, 0xff473fe8, 0x9ff67ec6, 0x7da53a8f, 0xf8e399be, 
	0xcfafaee6, 0xad9c79c6, 0x8afe487b, 0x04b37f25, 0x21024963, 0x31fb1b25, 
	0x08bc675b, 0x4a8d9bf3, 0x3f5c05ea, 0x4bf449bf, 0x8bda1a09, 0x1fdfec76, 
	0xfe50ff53, 0xcab6de20, 0xbef0b529, 0xef99ed1d, 0x079f112e, 0xa7aaeb3e, 
	0xc61f44f8, 0xfec26e25, 0xb113a509, 0xc2e990fa, 0xe62acc7e, 0x2151cafd, 
	0x4fb951ed, 0x1def724b, 0x4807578c, 0x4ce54dd7, 0x44cbbfb4, 0x0b7c6450, 
	0x730023f7, 0xd8d1c527, 0x1a690e0a, 0xd7f053b4, 0x300599b5, 0x3ddf85af, 
	0x6c71899a, 0x75a83fc5, 0xed3a4055, 0x1aaea3bd, 0x747c6748, 0xe50eab34, 
	0x20d66faf, 0xaac65bf2, 0x9da24fb1, 0xebe55193, 0x8f9e0ab9, 0x7a20c27e, 
	0xa51ee225, 0xbf6d239f, 0xe12c1d44, 0xf58d0c38, 0xb8c7cd8d, 0x2840b6ba, 
	0x7fbc4f28, 0x38e4f420, 0x6e52f3a2, 0x3bfc979d, 0xdefb61ea, 0xe7c629bc, 
	0xfc79fa68, 0x571c43e6, 0x458310e4, 0xe719bfd8, 0x23f23c8c, 0x03c904c4, 
	0xef9d67dd, 0x81af29d2, 0x631c6118, 0xe79f2514, 0xee328d1a, 0x3307fcb0, 
	0xc3bccd73, 0xe46241b4, 0xf940ef9f, 0xff93e7a0, 0xc2b9034d, 0xb3b61371, 
	0xf17efff0, 0x19d91b43, 0x740a2f18, 0xc87a3e99, 0xf6e06b5e, 0xe68f3cb5, 
	0x3cb80bd1, 0x5f82df9f, 0xda90fbd1, 0xe8b860fe, 0x6b9255af, 0x0ba72c0e, 
	0x3d7141dd, 0xdbe28341, 0x34bee48a, 0xd20e0ad8, 0xa7eb3a4f, 0x3d4fb922, 
	0xa6894e39, 0xfc53dfec, 0x0873d421, 0x1fb1e0e3, 0xf052ab43, 0xccfaa29a, 
	0x7c49127f, 0xfc85f72f, 0xc6532f38, 0xa5fccbcf, 0x5e982f3c, 0xdcb0bce6, 
	0xd979dcba, 0x81d7ea9c, 0xac3ec979, 0x4bcf27fe, 0x6e9c7ffb, 0xf4979df0, 
	0x93d894c9, 0xfcb687c8, 0xff616ffd, 0x2dd72f3e, 0x679221e0, 0x9cf26938, 
	0x1a3bed21, 0x866bd4ba, 0x3cb83328, 0xd09f5fad, 0xc179e4cb, 0xb05e7932, 
	0x2627e28c, 0x28e1ff9b, 0x0dd3379f, 0xc7262831, 0xb73542a9, 0x3f1aec9f, 
	0xe138872e, 0xebfa9233, 0xc40c88f5, 0x33b3bee7, 0xff3a36c3, 0xff53a624, 
	0xb3d2c23d, 0xd28e7ca5, 0xf4a39d66, 0xc507d8a6, 0x7437942d, 0xf903f2d5, 
	0x9c857cf8, 0x6fe921df, 0xc471e56b, 0x1f45a571, 0xa64f4fa1, 0xfe9d3c07, 
	0xcff86f16, 0x98d4a118, 0x99f9ca31, 0xe67e73ef, 0xa09d4879, 0x1cf8c65f, 
	0x5f3ca962, 0x30e1f3c9, 0x1e1446bc, 0xb43ec2fb, 0x7dbe6007, 0x5ba1a3cf, 
	0x24b5b80c, 0x6ae69f31, 0xb9e0abb0, 0xc7a8aa7f, 0x9bf30075, 0x3e56f52f, 
	0x329b2bef, 0x4dfe506f, 0x52bc1eb9, 0x2960fd9e, 0xb3f9afef, 0x4b25fbf9, 
	0x0f9a5c1f, 0x36efcdf8, 0x38fc7bdf, 0x7470afae, 0x3796364f, 0x8b5f8f5d, 
	0xd8eff4ed, 0x25f4cedb, 0x72546dbe, 0xf1604fd1, 0xaf9f16d3, 0x6a20fd0d, 
	0xee0e40e3, 0x90fcd38b, 0xf2a4da7f, 0xcdfd7c5b, 0x3f9adef8, 0x51f411b5, 
	0x7c97e998, 0xddca154e, 0xf4961f6d, 0x94f4cc3c, 0xf96473e5, 0xc07f9819, 
	0xc6c67fd7, 0xfee0cfed, 0xbb62e7d4, 0x453ee5a3, 0x4ce4bf61, 0x3294afb9, 
	0xc51df0ff, 0x47a7dfcb, 0x9feb8282, 0xf00fdfc9, 0x7f363e78, 0x1e993398, 
	0x71c73ffd, 0xccaf5dcc, 0xad55f5c0, 0xac06998b, 0x8d4b79c1, 0xde684719, 
	0x9df3d28d, 0x1abce7a4, 0x38ef87f3, 0xde4d7bcc, 0xa3bb2fd9, 0xce4df249, 
	0xc7cf3597, 0x6d7b7ca5, 0x1fd8e329, 0x56e7224f, 0xf62939e0, 0xbfb3e47b, 
	0x2d72c2f3, 0x5e818e5d, 0x99daf6cd, 0x7223fe7f, 0x7e7fd40c, 0x13f2096f, 
	0xcc6dfff4, 0x447e32ea, 0xf8489f90, 0xf2fdd285, 0xd96df5f8, 0xdb056ac5, 
	0x8ca1f0c5, 0xff93480b, 0x569f4c15, 0x4bb9c7c9, 0xbfc02281, 0xe794ee2b, 
	0xfb39dec3, 0x7f6c3cfd, 0xa7ba3eaa, 0x24bce935, 0x493f7f14, 0x2c1cd66f, 
	0x9f3f47cb, 0x573a4fd5, 0xa4fd0971, 0x733f40f1, 0x8b6a39e5, 0x4a1678be, 
	0xf39485ca, 0xa3f3e91a, 0x91ff8c6a, 0x13ce528e, 0x4f487d1d, 0xdb96cf68, 
	0xa6e5c76f, 0xee3ac33a, 0xdf8fa4eb, 0x7cb7e321, 0x673b3120, 0x7f41c927, 
	0xe0f9b450, 0xebc155fd, 0xf3e8efd0, 0xe054dafb, 0xd7d01cc3, 0x8543f91a, 
	0x67e7a312, 0xfd78379f, 0x6d8e3038, 0x5a743c42, 0xc75c79ea, 0xe2379e96, 
	0xebc1c17a, 0x7177ee22, 0x741b78e2, 0x396d3f7e, 0x078435db, 0x55c78f0e, 
	0xd1c30cce, 0x9df6a11f, 0xfe17d417, 0xf05e3a58, 0xcbc87b4a, 0xfa41147e, 
	0x97f552e7, 0xf212afa5, 0x8a1b2cda, 0xabe9d7fe, 0xe5747974, 0x452d91f5, 
	0x9fa8691f, 0x974c0f58, 0x85fa79fa, 0xa58ad2f4, 0x09f282e2, 0x9da26808, 
	0x1a1fcb67, 0x893b1c26, 0xd6e4b25e, 0x5b5c978f, 0x39657a8b, 0x7587939e, 
	0xad0a0819, 0x8e9017f0, 0x7685d77d, 0x25b1efd5, 0xcb0dd3a0, 0xe80aaed9, 
	0xe1c61e46, 0x4ab0627c, 0x62119db1, 0x8f36e2d9, 0x00108580, 0x3b042a7e, 
	0xad6eb036, 0x66f681e2, 0x1839632c, 0x666fa868, 0xa1a82f3b, 0x1e503843, 
	0x240e566e, 0x0e5849ec, 0xdbe3af14, 0xc4fc8cb5, 0x2fd6bcd6, 0xccf9b967, 
	0xe5034e32, 0x81db66a1, 0x86df7bc4, 0xfb2bf62a, 0xf343c574, 0x7efec053, 
	0x8fb81390, 0xe7cb53d0, 0xebe50222, 0xf167959b, 0x07d6dc5c, 0x05a7cf92, 
	0x7685c334, 0xe2af3d1c, 0x4e79e3fe, 0xcf8f2847, 0x4a4007dd, 0x50fd22de, 
	0x141bbeb8, 0xba2cfd83, 0x47dd004b, 0xc69e41d7, 0xcc157605, 0x2b46e8c7, 
	0xfe5167af, 0x99bcab7e, 0xfbd3e585, 0x3b43fd8d, 0x0ef686d7, 0xfc38b3ee, 
	0x5e6e7c03, 0xb29199fc, 0x69fd204f, 0x3bf3daa7, 0xc9f1871e, 0xcb3cc27e, 
	0xb71e5b7d, 0x7ee1e7df, 0x4ffb2c37, 0x5a96f7ed, 0xffcbe796, 0x9ea17155, 
	0xe40c75f6, 0xfdd0fda8, 0x1784f5e3, 0x6e2836aa, 0xac051930, 0xf007572e, 
	0x961ff2f7, 0x3a4f6828, 0xcf2c0e9a, 0xf3e2dc03, 0xcdf6bf86, 0x406b481c, 
	0x0efed324, 0xe38e82ff, 0x9f93765b, 0x2463c4d3, 0xdb7edbc2, 0x1e645303, 
	0xe1bb2fdf, 0x00f9e5d9, 0x363816b8, 0xc5a0b1d2, 0x36988a63, 0xf31ef896, 
	0xcd7ca49e, 0x65044539, 0xbf033efd, 0xf1e07fab, 0x8bfd44d6, 0xbcb03d6e, 
	0x9b4c1aea, 0xf686d4c1, 0xd1e29aa7, 0x785884eb, 0xcfe3929d, 0x71e07ca7, 
	0xdaacdefa, 0xff7d24f5, 0xa49fe3d1, 0x677653e7, 0xcb9273d3, 0xf5ead7b5, 
	0xac8a97a8, 0x2be0697d, 0x18f377da, 0x2c573a2e, 0x7cfc70e5, 0xbe9cba4a, 
	0xe4b65c88, 0x5fa9c070, 0xd2e50dfb, 0x73caf0e5, 0x81e21af5, 0xcc0bce00, 
	0xb3ee4043, 0x32531aac, 0x5f963e70, 0x1462b86f, 0x6114617f, 0xc86281bb, 
	0x455c6987, 0xf16ffcf2, 0xa30fbe71, 0xee2764f8, 0xe30d0a73, 0xa8df9653, 
	0xd71d1e68, 0xed8abdff, 0x034ba411, 0x1fab1ee1, 0x8fdd7223, 0x740b75c8, 
	0x8c6cfa23, 0x56bfb42a, 0x61af5fd3, 0x43e2cdfc, 0xf246864a, 0xbee4d74e, 
	0x73fa0675, 0x5c44b656, 0x18ef4388, 0xa79115cb, 0xf5adbfa1, 0xbafd0a8a, 
	0x1d293453, 0xd6dd71b3, 0x5cd3b66b, 0x6ef9045f, 0x50a86458, 0xe297605f, 
	0x6067bf46, 0x286bac13, 0xa3de077f, 0xb8fd0151, 0xbe415eb5, 0x8b848ef4, 
	0xc0e0efd1, 0x37e50f75, 0x0a6d031a, 0x2e22d796, 0x366bfd01, 0x0bea9514, 
	0xb24fc845, 0x4452b0e4, 0x18e0467e, 0xf4b2e73c, 0xf1117d68, 0x79d8cbb1, 
	0xadb3f508, 0xf20fa777, 0xe2fe4565, 0xe1c6073a, 0x83f4eef4, 0x83ac753c, 
	0x763bde14, 0x8d61bbd5, 0xbaa3c70a, 0x17d2f282, 0x5c73a3ca, 0xfbbd7581, 
	0xc9f32644, 0x238ed073, 0xe00b1668, 0x57a03eeb, 0x16abd009, 0x4bd23b80, 
	0xd44208c1, 0xb7de1edb, 0xc43bfdc3, 0x6f78b539, 0x6e89cfc0, 0x0d3fac05, 
	0x884347b2, 0x28fe7823, 0x394375ef, 0x019fc133, 0x60d357dc, 0xbab47efe, 
	0xf5fd05c0, 0x140b8756, 0x57b2f3a0, 0xfb1d7cde, 0xcd26ed43, 0x18cb7be3, 
	0xc96fdebf, 0x013f795f, 0x07e8e7da, 0xe31cfb42, 0xb31f3018, 0x6acc20f2, 
	0x2c57acdd, 0xdf558cbf, 0x72beb235, 0xdb951f59, 0x613b8c98, 0x839e10dd, 
	0xdc017375, 0xf9a9b819, 0x2bd3b882, 0xe3b947db, 0xeb78dc01, 0xe277be72, 
	0xa14e28eb, 0x7711ebfd, 0xe33d3ed3, 0x79d1c06e, 0x007f24de, 0x8966e2e1, 
	0x8f1e5fa7, 0xefd62e23, 0x6e391c74, 0xf9c3171c, 0xc2247e69, 0xa6376cf3, 
	0xf5c250e0, 0x87ae25ab, 0x22ffa7f6, 0x9dfd8ed6, 0x23b7e8ee, 0x24fa251e, 
	0x9fbc6bd1, 0xc0c4ed81, 0xb2ec8571, 0x2a189db8, 0x70313b23, 0xb9ec807c, 
	0xe8627671, 0x189d8a40, 0xe6c91e38, 0xc4ecd3ef, 0xed0981d0, 0x239f2844, 
	0x189db3cb, 0x2762903a, 0x3b22bc82, 0x01dd746f, 0xc4ed05d7, 0x13b601d0, 
	0x8313b04d, 0xfe4cff54, 0x73c7807e, 0xd0c4eca5, 0x5713b201, 0x589db10c, 
	0x00227687, 0x4ed1abcd, 0x2138f964, 0x3ecdb30e, 0x81919be1, 0xdc6cc0eb, 
	0xccc97a4d, 0x75caf6eb, 0xf0a7fcc4, 0xb8a94fbd, 0x953ffe1e, 0xef892bec, 
	0xe8f971d3, 0x2573d4a1, 0xf08f5b17, 0x4ae7ba2f, 0x7c059447, 0x4c35af50, 
	0xf0333f45, 0x6bbed8f1, 0x5bc37fb1, 0x1fd15b63, 0xf13bb7fe, 0x7d5d6079, 
	0xa9270538, 0xc1f75a36, 0xc12af71d, 0x3cf749d3, 0x61c8cc78, 0x61fb1f9e, 
	0xc22fbbe0, 0xff462b3a, 0xb46bd0ff, 0x8cf9d2af, 0xce7ce983, 0x33bdfc4d, 
	0x6ce88733, 0xf9d0a7ed, 0x3c45e791, 0x3cfd278e, 0xfeee75be, 0x46480f29, 
	0xa165a7c0, 0x85e91ab5, 0x28256d73, 0x6bb59aaf, 0x007ce1a6, 0x8e303349, 
	0xcb7bc363, 0xbf000a4b, 0xeff459dc, 0xef487e25, 0x0d363e2a, 0xf2c0a0fd, 
	0xeefcf0a7, 0x7ffae1bf, 0x1435f71f, 0xd75bee7a, 0xc9f187db, 0x7db1a7a8, 
	0x68d30fd0, 0x3eb7549d, 0x02623680, 0xbe33155f, 0x1e30b892, 0x01f7208f, 
	0x02557ca8, 0x850af177, 0x771c5b7c, 0xed7709b9, 0x372ee38d, 0xc4aface1, 
	0xe5365771, 0xaee38f9f, 0x60bf2c6c, 0xbc44cf8e, 0xde72ef75, 0x889c23bf, 
	0xdd6e5efd, 0xbc117163, 0x5e137628, 0x7ff963f4, 0x93938411, 0x61d0e3c7, 
	0xc092ff3c, 0xdfaa57b9, 0x6f7c24be, 0xce2353ed, 0xfc27305f, 0xc1d78b84, 
	0x9e030fcb, 0x56ddb5b2, 0x0c7892e9, 0xfe2278f9, 0xa03efe4b, 0x0d87c42a, 
	0xe0955bfe, 0xbb0f92db, 0x17e1f3c7, 0x5dee1f24, 0x8e3df3c6, 0xc94b871f, 
	0xb9caffee, 0xb26f697c, 0x06f0b65e, 0x24778ce1, 0x7ac2387e, 0xa36cf91e, 
	0x86e30e26, 0x968fcae4, 0x9838d515, 0xa3ef829f, 0x5174f03f, 0xa04b062d, 
	0x3d63ef3e, 0x56a67a8e, 0xb1509ee2, 0x467ce03a, 0x178acf88, 0xbffed04b, 
	0x8458bc53, 0xcbfcbfe7, 0x6e78ee39, 0x7d411ea7, 0xe76d8ca5, 0x1bb1bd78, 
	0xce343f68, 0xd8a13e67, 0x4bb1fcf0, 0x9f3c64d8, 0x0687fd8d, 0x600f51e5, 
	0xdc43eb1e, 0x2d7de2a5, 0x711efe49, 0xabc698b8, 0x807e901f, 0x07b97f74, 
	0xa7ce2204, 0x8a41f969, 0xfc0ff453, 0x7c97fee8, 0xf9614719, 0x43419c8f, 
	0x149af9c5, 0xea8e428f, 0x2a8f5c11, 0xea439274, 0x04ec8571, 0x9bc1ca55, 
	0x790e6e25, 0x67d20144, 0x105e816d, 0xadf07291, 0xe1fc421d, 0x9ce3b672, 
	0xf9153141, 0x617ae41d, 0xf5169e0a, 0xf2d7cc85, 0x4f21f7bc, 0x81847c8a, 
	0x71dd9e15, 0xffa5f839, 0x23dfe3cc, 0xe3defdb9, 0x57e84abf, 0xa71c0690, 
	0x247e9618, 0xefa5bed9, 0x49d2f413, 0xfb5ae73f, 0x1b66222f, 0x3b2f4415, 
	0xdba393df, 0xffa01ee9, 0x3a2cdd20, 0x7a237459, 0x385e9985, 0x310cce9f, 
	0xd20749f5, 0xcbdce8d7, 0xed6dcbf6, 0xeaedc65f, 0xb9f3e212, 0xbd431f68, 
	0xcdad8581, 0xcd1dcf14, 0xb378e813, 0x9bb264ec, 0xefab2f81, 0xfce2892a, 
	0xcdad02fa, 0x4e9ffbc9, 0xefebdb3f, 0x3053aff8, 0xca47a21e, 0x889db8d5, 
	0xeea59fe5, 0x9e3ede5f, 0x3ee9fcdb, 0xfb7dfba6, 0x7d21797e, 0x9af3c8a4, 
	0x9adc12a6, 0xb30f9fb4, 0x2139b879, 0xe9932207, 0x690b43a3, 0x9e9edafe, 
	0x3d73889a, 0xfb4bd09d, 0xc561b92d, 0xb6d61691, 0x0dbd21f9, 0x681bf9c7, 
	0xf24cd6df, 0x88a76e6d, 0x59befae0, 0x78e16dc6, 0xf90e5cf1, 0x5bfda125, 
	0x4db69be0, 0xb8a4def4, 0xdbe4cba3, 0x9f3fe832, 0x30fbe033, 0x04f9f16f, 
	0x9f8131f9, 0x4d76ae91, 0x9cb0a01f, 0x388f5e90, 0xa0a5bdf8, 0x3e4f4181, 
	0xf153bf24, 0x3d7c123d, 0xe09befbc, 0x03bf9879, 0x49f44a3c, 0xb794a3c2, 
	0x71aa83e4, 0x63c614bc, 0x30a9fc48, 0x82a5fcfe, 0x4c25c1eb, 0x59ce93f2, 
	0xf886dbde, 0xe4038e62, 0xf36ffb12, 0x7cb482de, 0xf1859eba, 0xf3a780e9, 
	0x079a7ed0, 0x926f70eb, 0x5f965e9d, 0x7e49c222, 0x7abbf280, 0x927b76bf, 
	0x7356601f, 0xc0bdce6f, 0x05e16517, 0x57011b99, 0xf5482bcd, 0x929acc1b, 
	0xfced1ef8, 0xc44abbf2, 0xf94963ed, 0x8c4ee20d, 0x135f290b, 0xaf98fd16, 
	0x50fdae11, 0xbf75795f, 0xbfd8abe3, 0xdd9dfaf3, 0xfbe530c7, 0x33efcafc, 
	0xef80fdd4, 0x4d03d5ca, 0xdf6a02b1, 0xd4b5ef7d, 0xf011b6be, 0xde96595c, 
	0xcd42f783, 0x5fdb729b, 0x3fc92e7e, 0xff41be51, 0xf63b5a4c, 0x9db16bbe, 
	0x285fdb61, 0x99f1bf58, 0xdb926bee, 0xb70afe19, 0xded57f53, 0x95fc09cc, 
	0xce904220, 0xae990b95, 0x961eef30, 0x42f9d6d3, 0xbb24d73d, 0x420cf745, 
	0x85e1bfea, 0x2bd03adc, 0x8f6259e5, 0xf9017bd1, 0x7f78c5a2, 0xdd18c6f5, 
	0xc897f8cb, 0x0637a017, 0x977f3397, 0x459c7057, 0xb78ca379, 0x1859ebf0, 
	0x6933f9b7, 0xa38b8d47, 0xaf5fa719, 0xe4f37d22, 0xb8f1824f, 0x35cfba6d, 
	0x7a93471e, 0x9e53d2ff, 0xae29cbf3, 0x6b3ee248, 0x9417963d, 0x3f4bfdd1, 
	0xfc02fd93, 0x49291592, 0xbe4317ca, 0xcb5f292f, 0x9f9045ef, 0x93cf444f, 
	0x86aa5690, 0x1b9f08ed, 0x3e671cf0, 0xfcff60f5, 0xdb17247a, 0xc81a2aab, 
	0xf30ed85d, 0x53e9df7b, 0x5bf485ca, 0xf3cb1d1a, 0x79441b6f, 0x55f9ab35, 
	0x796bf23b, 0x67fb55f8, 0xc57ff1a1, 0x393fddfe, 0xe9277f5d, 0x9dcb027a, 
	0x78f27ce3, 0xde36977f, 0x78e25ddf, 0x1917e075, 0xf72b9f5f, 0x97e42683, 
	0xa103f979, 0xc632f51c, 0x89895779, 0xada6f1e7, 0x6e7d8c00, 0x9f333a22, 
	0xcc7e521a, 0xb61f7a01, 0xf57ede4f, 0x2ec66f5d, 0xdad22388, 0x8f2bbb2f, 
	0xc5cdf3ce, 0xdcae5bf6, 0x98dea9ba, 0x685c47b7, 0x1fad239f, 0x3a13fde3, 
	0x1163f9f9, 0xcdd5e796, 0xe81cd1f5, 0xea636654, 0xafdd3f3e, 0x86dcfd0b, 
	0xe91b85fb, 0x7ef78a3b, 0xfce30577, 0x2ba59cd2, 0xe1c7ce30, 0x9f89b8e0, 
	0xa1a75ed7, 0x0af97d3f, 0xfaa5fd6b, 0xbdda44e5, 0x369bf0b5, 0xa369f9c2, 
	0xc8d7689d, 0x7f3498f8, 0xec1599cc, 0x857eb987, 0x29a18f3c, 0xf7945f74, 
	0x968caaec, 0x4d7189ad, 0xa06785ff, 0x424ffc85, 0x73d035f9, 0xc16f940d, 
	0xfea2a87e, 0xb6d02035, 0xbecb7302, 0xe1dd4806, 0xa6ef8f83, 0xa577e8fd, 
	0x5db9f4df, 0x1ce7c65f, 0x0accf887, 0xb9d31bf6, 0x4714a9d6, 0x6ffda1e1, 
	0xe791ee8f, 0x6f8c3c55, 0x6effca4d, 0x6dd9e305, 0x68e1058b, 0x94ac1887, 
	0xc532be7a, 0x1ed8376e, 0x890eb636, 0x87cfe841, 0x2a1ef82b, 0x748e55f8, 
	0xbbc83ed3, 0x9cf11b84, 0xc3bc69c1, 0x94709da2, 0xddcfee53, 0xb6fd2c50, 
	0xfecf911e, 0xb527c902, 0x667ee99b, 0xe638e753, 0xfde0afcf, 0xa0c79b39, 
	0xe41bd67d, 0x6bb6cdfe, 0xd46f1e79, 0x41db29c4, 0xeffcffc8, 0x716fd0fa, 
	0x8343c623, 0xf4687ffe, 0x7dc462ae, 0x80f7ef90, 0xffd0f0fd, 0xd04fe5fa, 
	0xef9d652f, 0xcd06c515, 0x7d6b3abf, 0x5bbe079f, 0x7f3d09a7, 0xd1a74124, 
	0xcef882fd, 0x41719eb6, 0x2803e48f, 0x609892ff, 0xfe936fdd, 0xbd29f2af, 
	0x6679e14f, 0x08de4524, 0x902fe3d1, 0x52303dbe, 0x92fbffac, 0xe567a3be, 
	0x8e21d3bd, 0xce2d1e4b, 0xe6b3c34c, 0x571f68db, 0xb86522f8, 0xb2ff549e, 
	0xbe0d5e03, 0x9c7531ad, 0x5fa6b57f, 0x5f26f251, 0xfa431e0f, 0x9ef89a5b, 
	0x94356758, 0x593bc01f, 0xe49286c2, 0x5d7033bf, 0x7fa798c0, 0x7dd06a58, 
	0x4888c257, 0xd62466ff, 0x6f5be097, 0x6711ec30, 0xf20ccf91, 0xf7ff6e93, 
	0xae2174cf, 0x40a91030, 0x1f49217d, 0x267e1263, 0xefc66e3e, 0x5e5a074a, 
	0x3ae7f04e, 0xf9d2feb9, 0xe58ef889, 0x9fde2ce8, 0xc03fe54b, 0xfcd2334f, 
	0xfc523379, 0xedf46979, 0x2ef5fdb9, 0x235d9fe4, 0xc2e7e4ed, 0x10fa4075, 
	0xdfac81d6, 0xc123b273, 0x5ff315bf, 0x577a4328, 0xc4ba6268, 0x909f7261, 
	0xc38069fd, 0x777ca3a6, 0xacd9ff49, 0xa14fbd69, 0xc396701f, 0x4a347198, 
	0xf78b37f3, 0xf859f563, 0x5a3be2dc, 0xef2cdd17, 0x0265bd1e, 0x4ddc5779, 
	0x07c59176, 0x8041fbf1, 0xf649a23f, 0xc6c5b6e1, 0x2b7fa5ef, 0xa27a67b3, 
	0xf667c89f, 0x7fc7e34d, 0xe38d7a51, 0x50fa7d3f, 0xb3671c86, 0xc46ae71c, 
	0xf0cecf07, 0xd66dbfb3, 0xc4e304d8, 0xde388275, 0xc7c59fa2, 0x03e2acea, 
	0xaea7c7c8, 0x7881591b, 0xdbffbd39, 0x4f8a0b66, 0xb4815f86, 0x7ca40bb7, 
	0x1d78e02a, 0xeded00b3, 0xf758568f, 0xafa9897c, 0xdb17fc53, 0x1c2bf0ab, 
	0x68e17ce1, 0xee185c52, 0xfce79cb3, 0x736fca25, 0xdf9259da, 0x9fa1dfe1, 
	0xfbe05bce, 0x1ed9bbdf, 0x3f242250, 0x9ef9b7cc, 0x9ecdf362, 0x871f8f2f, 
	0x8f38c477, 0xe3c82c76, 0x07403d2d, 0x33c72120, 0xbf69aa79, 0xb578363d, 
	0xab5dc7bc, 0xe8d938a3, 0x6d1fe4ad, 0x37be07fc, 0xbe2ecaa4, 0x96ccfb84, 
	0x737a85fc, 0x45cb9e24, 0xeeb0af3a, 0x9c8b0a17, 0x73ef7bb4, 0x40d1e252, 
	0x6fef26df, 0x5278b68d, 0xc856a9f6, 0xa25681fb, 0x2139ea9f, 0xfcb1d416, 
	0x39186676, 0xd24c1b8c, 0xf1b728e7, 0x865b413e, 0xf51dff91, 0xa077e5f2, 
	0x9608fd8e, 0x3d7946dc, 0x7e4248e5, 0x4ccedc93, 0xbf2cd791, 0x4e9f5e51, 
	0xdc84efc8, 0xd2bce936, 0xb3e63ac2, 0x2e9d3974, 0xf33711cf, 0x176ca5fd, 
	0x25bafa7f, 0xd57b8875, 0x5f7932a6, 0xad3bfb3d, 0xea8cc1b8, 0x17939261, 
	0x9adaab93, 0xd0e31d61, 0x9626ea32, 0xe338e9a7, 0xce167597, 0x089bac68, 
	0x67575c67, 0x65700fdd, 0x578bc670, 0x5f58ce33, 0xe3387977, 0x9c74bab6, 
	0xd3daefa1, 0xbf87f580, 0xfc85cb1d, 0x8fd5e63d, 0xb7b8ce30, 0xbd64a9fd, 
	0x73c977a1, 0x7a295de1, 0x37a5ace3, 0xbd226b84, 0x177587f1, 0x2fa41bd6, 
	0xedb7fa92, 0xf8afbe1e, 0x6b8c75b7, 0x0c6737e0, 0xcd870bea, 0x4c2fac39, 
	0xe8a9ca3f, 0xc4736d9c, 0x2c76214e, 0xf0d7e6dd, 0xea1bfcfe, 0x66bcf0aa, 
	0x9f7cadcf, 0xa031a57e, 0x1b41b9e0, 0xef81991e, 0xabbec633, 0x3e937ce0, 
	0x83ab7687, 0x678817c0, 0xfb004a83, 0xe8556ceb, 0x11a54c9c, 0xcb3e44c9, 
	0x42082e00, 0x4fd8f3f9, 0xf57aca5b, 0x202d7af2, 0x9bed6bfc, 0x6c4dfa58, 
	0x2027bfe7, 0x2b27b9e4, 0x4e21c5fe, 0xc0bf6804, 0xd0bc1c37, 0xaf5e8a3e, 
	0x22bbeb5a, 0x2345fee5, 0x8fd14812, 0x7ecb98c2, 0xafbed90e, 0x50c7f784, 
	0xdf3f22bf, 0xe3527ba2, 0xc1ff587d, 0xefcaf73a, 0xfef24e2b, 0x39d7eccf, 
	0xdb987b3f, 0xe34b3cad, 0xf1cf2b33, 0xe7b9da79, 0xca5f7d21, 0xf5b5398f, 
	0xdbb3d401, 0x4feffe7e, 0xc8c5dfd3, 0xb885fa1f, 0x9be47202, 0x5c8e5c57, 
	0xa57bfe1e, 0xbfe0caee, 0xf8f5cb1f, 0x2fdff071, 0x5702fe60, 0x77fdff18, 
	0x48af0fc1, 0x7e193eb9, 0x9c7585c0, 0xff15baf5, 0x801c417d, 0x79fd9572, 
	0x8b301e16, 0xa5bdf8c6, 0x48f617cf, 0x0663be7d, 0xe7197bac, 0x9f889d53, 
	0xa9f8c1ca, 0xffb24fea, 0xaf637ab1, 0xd7573acb, 0x55471499, 0x3547169b, 
	0xb3dfca4b, 0xbdff792b, 0xb36d61ba, 0xc9ca0cad, 0x1c789e78, 0x30b85b96, 
	0xe1baaa6e, 0x0aa566b6, 0xeb69b8e8, 0x44b2b103, 0x27a8413d, 0xad5ffa0b, 
	0x4798ac89, 0x11367fbe, 0xba7c2537, 0xc70dd78b, 0xe4855523, 0x9727d2fe, 
	0x105e7819, 0xe3a70ea7, 0x5923c54a, 0x77be07fd, 0xc25cfde1, 0xfa813fe1, 
	0x7c49fb0b, 0xc98bed6d, 0xfbe2487b, 0x3a41e162, 0x7f401897, 0x0fe43bf8, 
	0x5f39a177, 0xb70fe69d, 0x57d560e8, 0x4ec9577d, 0xe37fb7a4, 0x787f54d6, 
	0x3bc5f598, 0x2d2c8cfe, 0x3950df49, 0x29f6cfa0, 0x04b3c52a, 0x3b549c64, 
	0x27ef0174, 0xc82938a5, 0x5be6a957, 0xdef08dbd, 0x9bfdae1b, 0xe94f5c5c, 
	0xdf8d5171, 0x171293db, 0xf98ff7d5, 0x87c77e49, 0x6bdcf53e, 0xc524d7f9, 
	0x62ab1545, 0x98f7d25a, 0x6be524f7, 0x2608aa3c, 0x381747f9, 0x5f7cfe06, 
	0xc28bfd52, 0xb6e70703, 0x045fea26, 0x7efe4be3, 0x70703ea1, 0xe0f95256, 
	0x3d89f30e, 0x3b2387ac, 0x94fac29f, 0x9c61f68f, 0xc8f10ed4, 0xefe25eee, 
	0x8fefb4b9, 0x7a6130f1, 0xaff2724f, 0xd8103c64, 0x975c0157, 0x0c7de798, 
	0x0a3fcb9d, 0xbe89b0fa, 0x7f27d14f, 0x503b7185, 0x5e312fee, 0xc97e7807, 
	0x2a059777, 0x75de8f40, 0x81f7f5b5, 0x39ca174c, 0x51abf792, 0xc5739a7f, 
	0x567aea19, 0xfc5fbe0c, 0x415c0fd5, 0x96b69a60, 0xdb5f8a7a, 0x5f23e1fe, 
	0xdedabd43, 0x0e30b8aa, 0x8a7a8857, 0x470aa90b, 0xffc2365c, 0xffed3e46, 
	0xa9701fae, 0x65f3d7ac, 0xb27e571c, 0x91d6dbde, 0x0571c2e1, 0xdc5cca42, 
	0xa1bb9e9f, 0x0ffa2e79, 0x1067f09f, 0xc871c47f, 0x2e1f194a, 0xf097e3d7, 
	0xfddbac3d, 0xc6296366, 0xaa0df557, 0xb4de78a5, 0xf941d7c3, 0x94e3fe1d, 
	0xae7cf2a7, 0x52e785d2, 0x91ee9545, 0xed811f7f, 0x07a279c5, 0xc6034471, 
	0xa438d053, 0x29146fde, 0xc6dcdf7a, 0xb5fabf7a, 0x8fd0c49f, 0x6bbfa93d, 
	0x1901cf88, 0x68890e0f, 0x8eadf704, 0x7bf65c91, 0x87dcb645, 0xcff37b20, 
	0x3b8e32f4, 0x4e5c80f2, 0xb72587a2, 0x66ac392d, 0x82ff5cb2, 0xe52d8f15, 
	0x40e30fb2, 0xc57ce99a, 0xf7a7ac53, 0xd7de4fff, 0x8e67f34e, 0x9ca4f0ad, 
	0xf3c6b673, 0xa4273e45, 0x666f7c6b, 0x6d862683, 0x287ccf78, 0xb01f7533, 
	0xfca0f758, 0xcff29eae, 0xa1cfbc31, 0x0df31572, 0x4fdf4afc, 0x3900e38a, 
	0xb7da8a72, 0x3fd345e4, 0xfb40bc91, 0x7f4ecc67, 0x5df08756, 0x6799fedc, 
	0xafba44ec, 0x3fe5f6b4, 0x0ce43da6, 0x74e2391a, 0xb80a2ec2, 0x9273c877, 
	0x60972fc2, 0xfb8e79ee, 0x7dd1339f, 0x7ae25b22, 0xe915ef86, 0x9073aa0c, 
	0xcd1adbae, 0x44c91ecf, 0xd5d8f7bb, 0xfc4af764, 0x24f5fd8a, 0x42e94bed, 
	0x6e7691cf, 0x8ebdda0e, 0x2cff2c95, 0x2ee3495c, 0x176b7ec3, 0xc966f7ec, 
	0xaddf96e7, 0x406efd1a, 0x7b896aa7, 0xbd6f152e, 0xade3357d, 0x9bbf04ff, 
	0x4bb7ed0b, 0x5e1f5dc5, 0x5770657d, 0xe98fcac6, 0xea60db77, 0xab4681bf, 
	0xbae03a6f, 0xa815dc1c, 0xee2165f6, 0x3cd4deaa, 0x58b89db1, 0xeef8e5c4, 
	0x707dff19, 0x42fdd218, 0x66b80c38, 0x77dca0e7, 0xca18ff20, 0xcb8bc1c1, 
	0x58ef5c3f, 0xf92f213e, 0x4f87579c, 0x7776c52d, 0x9ce91bf8, 0xf459ca30, 
	0x797ffdb7, 0xb2f28979, 0x3b8a35f5, 0x5e457ffa, 0xf42e77c2, 0xdf2aa8db, 
	0xd6e501f7, 0xe74199ee, 0x0e507bc7, 0x5e245f54, 0x48478ace, 0xb7d8578f, 
	0xb978b272, 0x384f8a3a, 0xc1ef9c74, 0x272f171a, 0xfdad47f7, 0xbf465b53, 
	0x3ee052ad, 0x7895f6ea, 0x371582cf, 0x42e47c07, 0x7ea262bb, 0xbd55c6a6, 
	0xe3cdf43d, 0xc6c75e30, 0xc1ed8f9d, 0x1a85e371, 0x71483c40, 0x675fda9f, 
	0xd680871a, 0xe7fa35fe, 0x597ee276, 0x7d1bf0e3, 0xf0f3e22f, 0xf173a786, 
	0xe92238b9, 0x1339d992, 0x3ef235f2, 0x538053ed, 0xae4f6e80, 0x03467be4, 
	0xbd933537, 0xb23dd4a2, 0x018ff512, 0x889ee9cf, 0x1be882f5, 0xbf7137cf, 
	0x43f95af7, 0x47cf0bba, 0x55fde5f8, 0x3d70dfa2, 0x785ef907, 0xf485a0bf, 
	0x754ae10a, 0x8c5c9ae4, 0x7bc9f503, 0x0c3baac5, 0x7181c917, 0xf44c5df4, 
	0xd33d7b3d, 0x018c2fd7, 0x6f50cf0c, 0x270857aa, 0x0f897d22, 0x7b17ef53, 
	0x8948a568, 0xd516710b, 0x7ac190da, 0xa834fde3, 0xfbf1f1df, 0x1ef8fc78, 
	0xdd9769fd, 0xf51e70cf, 0xef94a873, 0x4aeaf82d, 0xfac9d3e6, 0x20c7ef1b, 
	0x0f9e23f7, 0xe9c6ff32, 0xdfa54fe7, 0x25ae5873, 0xd088bca9, 0xfcff56f7, 
	0x3a14078d, 0xbfde95c7, 0x2ff5277e, 0xf100c3e7, 0x9b3fd5b3, 0x35d08f53, 
	0xb69ef23b, 0x31babd78, 0xaf263f29, 0xe360ce9b, 0xc8cdd705, 0x12bbfe4a, 
	0x1575e9e3, 0x75ffc7f5, 0x3d7184f7, 0x84f7f3e9, 0x3e74bf9c, 0x9fa1f38b, 
	0x71b470f9, 0x35078cab, 0xf1cb7da4, 0xdb308193, 0x4f7b71b7, 0x089e7c13, 
	0xbcfda3cb, 0x925eed8e, 0x1e225720, 0x8a3286f4, 0x2ab19d07, 0xf74a0f1e, 
	0xe2255652, 0x2e304f41, 0xf5eec499, 0x9d8e110c, 0x4d078f17, 0x7966cf1b, 
	0xf70ae9ee, 0xb9a1aabb, 0x2f1b2959, 0x775c1677, 0xc62ca5e0, 0xcd766f1b, 
	0x92d078c4, 0xe292b21b, 0xcb2d4541, 0x9a3beb05, 0xf3497397, 0x8dc9a7a3, 
	0xf557cf20, 0x223fd28b, 0x7b561cfd, 0x62e0bf96, 0xd5f70e7e, 0xd230f7fc, 
	0x07e81cfd, 0x57e275c0, 0xe4211c65, 0xe224b762, 0x819fd0da, 0x8fd019b8, 
	0x6a87f70b, 0xae6e3156, 0xf74f973a, 0x32f4047b, 0x7a805b61, 0x03df1976, 
	0xbe8cb4d7, 0xdee27ff2, 0x905f3d88, 0xc3e7941e, 0x70f9e473, 0x78c2ef2b, 
	0xfac8cfb2, 0x32fef2fc, 0x8e03870b, 0xc007f3e0, 0x20fe787f, 0xece9bde9, 
	0x9d3ae7c7, 0x9637f247, 0xbfcf1f7d, 0x43ecbe90, 0xe0e303bf, 0x82654d65, 
	0x3e0b15ca, 0x857c04b7, 0x24aa96e7, 0x2e5f860e, 0x8065d7e2, 0x8d5cf05b, 
	0x777bdaff, 0x91be5c73, 0x6dc1f68b, 0xab73acab, 0x2a6b9726, 0xdcfb44eb, 
	0x9059cf2f, 0xf2a32f9e, 0x1eadd90a, 0x2ce3e283, 0x6bad6ebd, 0xa3ed1f1c, 
	0xabf7e9a4, 0xc15ffd83, 0x6e956bbf, 0x093f906f, 0x8d8712ed, 0x5b1eebf6, 
	0x81c2f7c5, 0x79d172fe, 0x30f7a17b, 0xb51644fd, 0xd85911e7, 0x37edcf7e, 
	0xa3b9e0f5, 0x5fb15627, 0xabe4530c, 0xabcdaac0, 0x79cfeff8, 0x577fc95c, 
	0xaa1eec8d, 0x5bebcf8f, 0x5bb463fe, 0xed7e493c, 0xe33f3976, 0xf669c9fc, 
	0x463b38cc, 0xedf1f77e, 0xea8fde19, 0xb96cf1c0, 0x7528fdf4, 0x7bc0997d, 
	0x5970d488, 0x7d43ee1b, 0x55eebafa, 0x82a81fb8, 0x897bc03c, 0xa7297dac, 
	0x977e45f0, 0xfbe5648b, 0x9f3ad555, 0x4b8bd4a2, 0x6ad43fb6, 0xe97df91f, 
	0xf644f8dc, 0x77de0ec7, 0x53785ced, 0xa3ab8e0f, 0xd209e61c, 0xc04f393e, 
	0x84e714df, 0xe3ef98fb, 0x1cd9e63e, 0x6c2887da, 0xb14c7de5, 0x35f685be, 
	0x7be07ff5, 0xb9e47fe7, 0xafee157b, 0xefa3bbcd, 0xd13b0b4b, 0x67fb29ee, 
	0x7efa471c, 0x3e7abed8, 0xf39a5987, 0xf689aacc, 0x755d9ec3, 0xd661fbb9, 
	0xfbc4edbe, 0xd9eb5b61, 0x55edf3ef, 0xf61fb797, 0xf7d2ab77, 0xbdcf98c3, 
	0x7feab532, 0x97db1579, 0xfd73ab7f, 0xbd77ed93, 0xa975c72c, 0xc47e5dfb, 
	0xfbc0bf9f, 0xf7cbbf7e, 0x9fde0afd, 0xc75e800a, 0xb3816df3, 0x1e785c8b, 
	0x701ce930, 0xefefd216, 0x69023f65, 0xf480ec7e, 0x039fa763, 0x2f5ff74e, 
	0xcff9e7af, 0x240b7496, 0x3f64f5c9, 0x799ffa30, 0xb0f3ca3d, 0x75bbce52, 
	0x92d80e79, 0x01cee3f7, 0x961d1e83, 0xd632ec7e, 0xfdb7e8df, 0x635ff2af, 
	0x6039e4ff, 0xa2ee9fba, 0x67e87c7a, 0xe3fdc7a4, 0x3b8f38f4, 0xf1eaa7a0, 
	0x840403ff, 0x00004bb3, 0x0002a921, 0x7dcd9c78, 0xd554780d, 0x93b9f099, 
	0x2199933b, 0x30084990, 0xc84c21f9, 0xb109b924, 0x988ac506, 0x48109b96, 
	0xd48d8fc2, 0x3b6caa15, 0xfa9b6909, 0x42dc5a9b, 0x926727cb, 0x3a401214, 
	0x96a24401, 0xb8b45127, 0xac0fdd9f, 0x5dad8b4f, 0xa8b6306f, 0xb65b1774, 
	0x46dbad65, 0xecd46e08, 0x8b6cba2e, 0xef7ebb2e, 0x97f3b9cf, 0x4fa54244, 
	0x87b1e79b, 0xe7b9cf73, 0xef3de7bc, 0xa9defbff, 0xf0908426, 0x26b548df, 
	0x3fc3ef1d, 0x9b15e984, 0xfa12bfa1, 0x796fb01b, 0x4dfa0b85, 0x449cdf76, 
	0xf9ec7bfd, 0xff9c24d6, 0xde6dfc21, 0x35fcc424, 0x01e522a5, 0xa16bfe21, 
	0x855b5310, 0xe1d994d8, 0x98848475, 0x453fd1d3, 0x2ed1080f, 0x5063b784, 
	0x5a35d288, 0x5685e89a, 0x03222b37, 0xdd279e30, 0x3b408fdf, 0x79c8884f, 
	0x70abfd11, 0xac77abea, 0x02134217, 0xed791197, 0x55332bd9, 0xcfffc71f, 
	0xcc8a8c8a, 0x3ae6211a, 0xc08a6edb, 0x75f8d7fb, 0xf63eb391, 0x717df63e, 
	0x5d3e79fd, 0x03f5a854, 0xaf0bdf12, 0xfeb713da, 0xe57db5d5, 0xe1b60d46, 
	0xdeb07c9b, 0x45faab55, 0xd3ce2d61, 0x35dfeeb2, 0xd54378c6, 0xfbd4cae7, 
	0xb0f0c652, 0xdb7846b1, 0xc25d1133, 0xad03dddb, 0xa0bb784f, 0x7f84d2bd, 
	0x8e8c5e02, 0x4eca6f52, 0xd551d75c, 0xdef633be, 0xdc212ae6, 0x5e788567, 
	0xab7d83cd, 0x28849bda, 0x49a5aedb, 0xb35957c0, 0xdfc04af0, 0xbdfa0735, 
	0x9fbe2eee, 0x0c421bc8, 0x44936ad5, 0x57af9c1d, 0xe91bbaf3, 0x4bc8de78, 
	0x56b5b442, 0x96e1fe11, 0x6fcc248b, 0xa49e1f5f, 0x3a7bfbc3, 0x03eae135, 
	0xaf619bfc, 0x349be683, 0xf586ee5e, 0xd589ffa1, 0x650e0f30, 0xc5795434, 
	0xed97b829, 0xee026955, 0xcd52d36f, 0x61fbd42b, 0x9a9b97e8, 0x88517c70, 
	0x63a6a407, 0x0a09f61f, 0x536b13a0, 0x211e9085, 0x5068e29c, 0x76737c02, 
	0xf0095e5b, 0x16a0f27d, 0x23dfd014, 0x5834dbfb, 0x1b55dae7, 0xf7983e82, 
	0x38db9c3a, 0x6baefb07, 0xff60d22c, 0xdaec1f4d, 0xa407a81f, 0x84393d4e, 
	0x5854e7f3, 0x2c116245, 0x30de96ef, 0x9a6371e0, 0x09bc45e9, 0x2fe749b7, 
	0xf0de134b, 0xcedfa651, 0xaf3e216c, 0x70eba7f0, 0x1e6a69e6, 0xead237bc, 
	0xd0d7f213, 0xbef05807, 0x0829d200, 0x4e42ab9f, 0x51212f11, 0xbfd8c384, 
	0x833c3e7e, 0x79ba4476, 0xaf9e7afe, 0x649f3489, 0x3d64f97c, 0x98efa5f6, 
	0x974ee74e, 0x0aac8704, 0x2422dac3, 0x901e20a6, 0xc20f10b9, 0x12fa9abd, 
	0x6f7492e0, 0xabf63a66, 0xfd871e4d, 0x93dc172c, 0x8546f759, 0x97f74838, 
	0x7a7cfb8e, 0x1c137081, 0x11c21515, 0x6fc6c707, 0x800ba209, 0x33d71d3f, 
	0x385f4cd2, 0xecfb7884, 0xddeb0171, 0x113beef7, 0x49e20777, 0x3687486a, 
	0xf0197d7d, 0x7afa03ec, 0xe367e145, 0x8c0eb035, 0x93e786ef, 0x537ad2ce, 
	0x50c61cf1, 0x833864fb, 0x707f1030, 0x0bf19fbf, 0xe3a017a2, 0xdef882a9, 
	0xdf9ae7c1, 0xdbee9532, 0xbb5ce9d4, 0x7bf75d61, 0x5393ea30, 0x3de0def1, 
	0xbcf705cb, 0xfbc33171, 0xee38b759, 0x7ffd0fd8, 0xf68f71fd, 0x5a03f506, 
	0xc8f1f033, 0xa468bf5a, 0x086faf7e, 0xcef6fffa, 0x751ebe6b, 0x1f60677f, 
	0xac3bdc3f, 0xeeae17af, 0x2b7bc1f1, 0x3a9cc2dd, 0x91dfbb14, 0x559780bd, 
	0xc66aefb0, 0x870053cf, 0xffe695a7, 0x0bbde04c, 0x3371dc33, 0x78490d0b, 
	0xcfd21a11, 0x7deeccec, 0x1d77d83e, 0x2218cf3c, 0xf4863fbc, 0x8a4e0db4, 
	0xe78dbfeb, 0x86467581, 0xd9beb47d, 0xfa401110, 0x61efc462, 0xd28868ba, 
	0xbc30a9d1, 0x0b840c17, 0x6e85d004, 0xe797d75c, 0x59e77786, 0xd4d829e6, 
	0xabcfa9b8, 0x93b4c375, 0x7f011820, 0x42e1fbff, 0x0e88db21, 0x27cfe204, 
	0x9d67c675, 0xb29d70b0, 0x435780f2, 0x9469a89e, 0x88f3d01a, 0x2fc853ab, 
	0x9d755ec0, 0x3cce03a2, 0x895c83f3, 0xb64f077c, 0xe5b93d12, 0xb3cc08d6, 
	0x8c3c7960, 0x0d79df7d, 0x02d13e8d, 0xa3cb1a6d, 0x9efb4d0f, 0xf853e6c7, 
	0xb12f922b, 0x67b848bc, 0xc3af0f90, 0x2ab36d3e, 0x57f43a83, 0xf10fbc99, 
	0xafcc1be3, 0xafc43fc8, 0xfe1be063, 0x6dfd710a, 0x42d89cb7, 0xf911167c, 
	0xd019beb8, 0x499f7d78, 0x11a5b77d, 0x9be3251d, 0xb4f70af0, 0x1d3da87d, 
	0xe8c8b2e9, 0x0afa402f, 0x864cc5ba, 0x32799cd7, 0x794a8055, 0x8df22667, 
	0xc8f95857, 0x4f79859f, 0xe85b1be6, 0x3a17853c, 0xf0e4f463, 0x27c88599, 
	0xbc333e23, 0x81d666fb, 0xb78d9ff8, 0x88977f11, 0x3e2fddc4, 0xdf13707f, 
	0xd8aae77b, 0x2f9fe073, 0x927d60ee, 0xe0abd1d9, 0xd293f451, 0x171cfa3c, 
	0xba28f73d, 0xb35cfb1a, 0x8973ecb3, 0x449df3c2, 0x3a5f847f, 0xff4c4bd7, 
	0xf069e402, 0x900b67ca, 0xd4fa6d0e, 0x487dfd0b, 0x7ff3a79f, 0xa9ef15b8, 
	0x242abaac, 0xdf7cf80b, 0xeefc84dd, 0x07fa7e20, 0x51abbda0, 0x04fd283e, 
	0x98f48e92, 0x9c679e17, 0x156fd38d, 0x1e50d7a0, 0xf73d001e, 0x467f0c52, 
	0x5c5e1bcd, 0xc9c2cd7f, 0x385de255, 0x7b86cd57, 0x808fca05, 0xe574c498, 
	0x3796f3a7, 0x5bdae864, 0xfea1ef71, 0xa5f9a889, 0x275c7768, 0x9ce8afc5, 
	0x8d310242, 0x94ed45b4, 0x7653b234, 0x3494ed46, 0x8d1e4bb2, 0xa99329da, 
	0x4ed474ff, 0xe7f38c99, 0x42c0a67e, 0x943ee4fb, 0x9f44ad77, 0xa95bc45e, 
	0x69c2b392, 0x2bf4ccbc, 0xc66f2ebe, 0xc223ae65, 0x42587118, 0x99de0efe, 
	0xd8eac9ef, 0xfce27003, 0x603cf0b7, 0x9d886d0f, 0xcf930ae7, 0xc01b7233, 
	0x83e5f37d, 0xb1bab4bb, 0xe1882b51, 0xb9c7a6c9, 0xf05f7db5, 0xe8e37db2, 
	0x22bbfa02, 0x78fa4d94, 0x7843ea0e, 0xfad57658, 0xfc237146, 0x684333a3, 
	0x73fbef12, 0x35e01a8d, 0xa33b64cd, 0x88e7ed7c, 0x6e574a0e, 0x317d9468, 
	0x8035703a, 0x9d3c075e, 0xdd78b631, 0xe91f3c3d, 0xe69fdec9, 0xacb82297, 
	0x5fe74f8f, 0xfc8055bb, 0xfa9e9031, 0x7409c346, 0x0d74fb55, 0x1ddb53d2, 
	0x3f4423bb, 0xf005bb62, 0xe117bb40, 0x7b5f14ac, 0xe5e8f994, 0x2fe801ad, 
	0xf91b5c0f, 0x35cb8e29, 0x7c68448f, 0x00ff1abb, 0x6e5b2fd7, 0xb9f2b646, 
	0x3fb18677, 0xe3f9e94f, 0x7005dbd2, 0x0a74873c, 0xad069bf7, 0x6fc607b8, 
	0xc7ac7a62, 0x5fc87bfe, 0x73cc3700, 0xbcbb65b4, 0x989bf671, 0xe1b1e7cf, 
	0x71adf9a7, 0xf1e6adef, 0x4d6fa52a, 0x183d6f60, 0x93c687a7, 0x45ac6027, 
	0xb7ac6e50, 0x126a5af9, 0x9d9d77f6, 0x0af96faa, 0x895c838e, 0x7f40efd3, 
	0xa457f2ad, 0x773ed81d, 0x69e51f43, 0xf43a7cc5, 0xaaeb34c6, 0x3bdeea3d, 
	0xbf0b5f10, 0x06be2559, 0x8bcfb73d, 0xddaf1eeb, 0x3abe2558, 0xb6bd3e5a, 
	0x7651cf90, 0x2fa9e804, 0x8c755cee, 0x48df688f, 0xff7057ea, 0x6fe37262, 
	0x1d9c6e51, 0xd5ba372d, 0x37278c7d, 0x8dd69ee8, 0x7a701f96, 0x3bf017da, 
	0xe39f2b67, 0x63639e14, 0x8beb5091, 0x2de908ac, 0x4f522b33, 0x6422b3f3, 
	0x6859599f, 0x85bffeff, 0x6fe1bfac, 0xd16f89da, 0xa9d7b4f8, 0xb887d315, 
	0xfb847d3f, 0x7f71ce33, 0xfbee05c6, 0xdf533607, 0x915a8c7f, 0xd9fb827d, 
	0x75e66faf, 0x9109ff49, 0xadcf4433, 0x356e619c, 0xa9a60794, 0xbf93bcec, 
	0xf37f6070, 0xf7964e13, 0xd829e5c3, 0x663fd2ff, 0x8727b8d2, 0x02bb8ee5, 
	0x2d01a7da, 0x0cffd99a, 0xd433b85e, 0xcfad8c56, 0x075cb30a, 0x8a12f229, 
	0x5e21a927, 0xd30ef9f6, 0x801c12fd, 0x4035b2ef, 0xa2afc07f, 0x010f7a57, 
	0x3e00d6be, 0x1d92b6e7, 0xbaf68697, 0x1d28b43e, 0xd7e20e70, 0x188f50d2, 
	0x8ef7201d, 0xd9df018e, 0x3e50526b, 0xa32b2f0f, 0xc12ffc3e, 0x6954d7a3, 
	0x8782ad62, 0x1fab59ec, 0xff0d89f5, 0x3e58aa0f, 0x66bb70d8, 0x821877cc, 
	0x13fe40e1, 0x2e6f9807, 0x55ff1f8a, 0xefd79f84, 0x87765749, 0x7ded7824, 
	0xb214cde0, 0x47ad5c53, 0x1fefb834, 0x5911ba2a, 0xbf70dbeb, 0x7d32be28, 
	0xe573d40e, 0x0ab6334b, 0x825907a2, 0xc32b19eb, 0xaa6d0fe4, 0x089b71be, 
	0x38257ad3, 0x43fa1f7f, 0xc8427ed0, 0xee211d49, 0xcace8187, 0x0384325b, 
	0xa0ef85ec, 0xeb4bd37f, 0xe27e2314, 0x8462a6ec, 0xe3c35c0f, 0xebf719a2, 
	0xc9768fde, 0x606ff43e, 0xbf9f27fe, 0x21e838ae, 0xf104a5ff, 0x95a0d657, 
	0x053f6508, 0x4129dfd8, 0x7553783b, 0x7e8113f7, 0x24de9fb2, 0xdbd27d78, 
	0x331bf087, 0xe6ec02bc, 0xdc6e9a2b, 0x0caa428a, 0x8241b5fd, 0x11f954a3, 
	0x13ffb8a5, 0x0c637f08, 0xff6c27fe, 0xf4832eac, 0xff31e3c1, 0xfbb248cc, 
	0xc3ff3c0c, 0xbbd83f08, 0x4fdd4de5, 0x284ffee0, 0x37e00cff, 0x5fc12f74, 
	0xfc134e2a, 0x012ba2a5, 0xd7f452fe, 0x3eea68ae, 0xf822a810, 0x68fcf187, 
	0x1db1f7af, 0x379ce739, 0x21dff706, 0xbcf4059c, 0xdf8f1e2c, 0x3c42f843, 
	0xb820ae1e, 0xc50fc8ca, 0xcf058178, 0x7f181e11, 0x5904e10c, 0xb3ccfe5f, 
	0xf82b6046, 0xcaab878f, 0x47387f94, 0xcdf040bc, 0x53697ec1, 0xfe8adff7, 
	0x58ea9d98, 0x0f365fdc, 0x4fd383e6, 0x17d51874, 0x4817d601, 0x31b39ea7, 
	0xbf22717e, 0xbf009c1c, 0x5f883284, 0x495ee64e, 0x3e299ffd, 0x89c6f9b0, 
	0xc63a737c, 0x387e5137, 0xfb4470ca, 0xf946be4a, 0xe3e448d8, 0xe7ccd5d9, 
	0x4c22f9d1, 0x95f0dbef, 0x91a7d4dd, 0xdf0c9d5d, 0x7c114fde, 0x8ebfaf9f, 
	0xcf86cdf8, 0xcfc332e1, 0x0f12fcd8, 0x1be7d287, 0xa5fed9a7, 0x9d6185a9, 
	0xdfb1170f, 0xb6a53b90, 0xa739ed1a, 0xe7089853, 0x75afcebf, 0xa5ce00fb, 
	0xe56fecd5, 0xd55f810d, 0xd153f2c4, 0x8ba8ffa7, 0x9c7fdef8, 0x7d99a3e4, 
	0x83d9fb92, 0xac27fed0, 0x6a3923eb, 0xf3f30ce6, 0x0ca7841c, 0x8bd02bed, 
	0x1a1b6d65, 0x5da17343, 0x6caafaca, 0x76868665, 0xc027ad86, 0xb80e162d, 
	0xafdbb9c7, 0xfd93b8a3, 0xec4595fc, 0xad556edf, 0xedacbcfd, 0xd00746c6, 
	0x538c5cdf, 0x05cc5f01, 0xa4ec903f, 0xda8dadd9, 0xaeeb7193, 0xef584829, 
	0x37ec458e, 0x4bc52ddb, 0xe89c151a, 0x467d81af, 0x82b0adf6, 0xba6e7cf8, 
	0x51361459, 0x419c350e, 0xf185dc7a, 0xf4439604, 0x2f8303de, 0xdaff266c, 
	0x10cbb62b, 0xe42e5b8d, 0x7e4141cf, 0xb098f999, 0xd92083fd, 0x0bfb16cb, 
	0x07cdf80f, 0x07b04e31, 0x3c21e1e5, 0x760bec0f, 0x06552b98, 0x36f9411f, 
	0x94f91464, 0xabf1d35f, 0x4090ec31, 0x2117fb37, 0xb2f233b6, 0xacee0fd8, 
	0xe0387b66, 0x6f2fbb66, 0xeb6a6178, 0x3a9f9886, 0x7f5f6df3, 0x5bb5f22b, 
	0x5c82ef68, 0xadf982ea, 0x545d0788, 0xd9d602fd, 0x3d7ac598, 0x7ef6b54f, 
	0xfeb3548f, 0xf7cd55dd, 0x4d5bf310, 0xe49ab7e5, 0xd5fd46b7, 0xe2afe53a, 
	0x2e40a73a, 0x5badf7fe, 0xa148de50, 0x71def1bb, 0x3953e43d, 0xfe9b9c0e, 
	0xce01373b, 0x467e2a8d, 0x27d61e71, 0x9df1f1e9, 0x6c69c689, 0x3f1c957d, 
	0x1436e3b2, 0x98fb81a7, 0xee19e8ad, 0x14c1ca63, 0x38e297da, 0xe8ee6fc2, 
	0x591cfe02, 0xb45ee1b2, 0x7a3f775f, 0x0ba476d3, 0x1a2a7e9b, 0xc7d74d5e, 
	0x7e7083f2, 0x10b7c729, 0xb3e615af, 0xfbc276f7, 0x9ed9aba7, 0xaeefe7b2, 
	0x8f8896ce, 0xb7fec21f, 0xb7031ca2, 0x6ffa0dbd, 0x8edf3355, 0x43d00f4b, 
	0x233094ff, 0xb25cf663, 0xff3a7eff, 0x884fcaeb, 0xaf38f7d9, 0x07beed0c, 
	0x07294f08, 0x49f51f95, 0x5696d3d2, 0xdbb78711, 0xeb7f2e00, 0x7ce9f218, 
	0x1ffbe905, 0xfd439a9d, 0xd6c87b64, 0xdfbeb6e7, 0x6ae7fbe7, 0xea88af71, 
	0xdda5d2fb, 0xdc8d0f64, 0xf925fecc, 0x28676873, 0xf7ca2e3f, 0x79f1936e, 
	0xc72bf283, 0x33fceff3, 0x33a63ab2, 0x39dc459e, 0xeec2fc6d, 0x49fdf809, 
	0x6db9c735, 0x9c197ffb, 0x58d9ea73, 0x22e8ed5c, 0xae3b2be6, 0xb5718656, 
	0xc71bc441, 0x571a2621, 0x4ffab0fb, 0x2f335715, 0x6336ae29, 0xab89e5d1, 
	0xf622d5fd, 0x5c4e3f3f, 0xf436eded, 0x5abd1b03, 0x5c709886, 0xd7bcb4ad, 
	0xbea3f5ab, 0x66ae3b1c, 0x86e57bc7, 0x63a2a093, 0x8fc61df6, 0xee17f924, 
	0x266bec42, 0x8df6cd2c, 0x2c0307b2, 0xae312e2f, 0xb6b3c765, 0x3ef40f5f, 
	0xfa68f117, 0xccbc528e, 0xdc720df2, 0xcfb7f68d, 0xa185f45f, 0x162d4a82, 
	0x90f8c267, 0x14fa8382, 0x7157aa27, 0x30af7822, 0xda1f7ba7, 0x994e8505, 
	0x747b9cff, 0xd6776bfc, 0xcbf2c281, 0x6f7b0713, 0xb7a3fb07, 0xe188296d, 
	0x253c3c6d, 0xf73ed9e3, 0xace7683b, 0xe1df9d8b, 0x77f78ab4, 0xd5c4e5fd, 
	0x2a3ffe90, 0x2166b6ae, 0x87e80858, 0x872458b7, 0xbcb29646, 0xa948e5b7, 
	0x5a1cb25b, 0x54bd72c9, 0xc86039d9, 0x948e3979, 0x751af045, 0x7186ba19, 
	0x238e6a81, 0xe6f2e269, 0x3caae6e9, 0xd39db25d, 0x2f9beca1, 0x027f3357, 
	0x029c535f, 0xea3f69e4, 0x0cdca8df, 0x2a221c70, 0xc52e6537, 0xaf6646c5, 
	0xc41457bf, 0x62e3879f, 0xc79f0346, 0xb9b407de, 0xf9c07846, 0x49cec64f, 
	0xe3197294, 0x8a2eef7c, 0x4ec8f9c6, 0x7df38b8e, 0x330279f4, 0xa3e53ce9, 
	0x279d47ee, 0x973f7894, 0xd9d2ee0b, 0x4773b221, 0x424af9c5, 0xff1cbc17, 
	0xc17b7b78, 0xee77d465, 0xea273a7c, 0x139e3b3b, 0xaaeeefbf, 0x7566ff77, 
	0xf93bea0d, 0x287c078d, 0xec5fac3f, 0xd96e3864, 0xc874c052, 0x45eb19f1, 
	0xd0599f15, 0x8c75cf09, 0x3b419e43, 0x32c37858, 0xce690e2e, 0x2de438e5, 
	0xe9b4871c, 0x7190e28c, 0xf56950f6, 0xebc94686, 0x28f31d17, 0xd9507a7b, 
	0x3d989ed3, 0xf834764d, 0x43cc2e00, 0xa05ba19e, 0x2319e63c, 0x64a0f295, 
	0xc97bc357, 0xffad3576, 0x7edd9c64, 0x6a3b3b11, 0x3d7b2b5f, 0x0cffb4ef, 
	0xfdb6a5da, 0x3c67546d, 0xe270fa4e, 0x4aa3f776, 0xc076665e, 0xe51aff39, 
	0xb6e5c61e, 0xbc739fb2, 0xf422dcf6, 0xe4fcecb3, 0xa0a730a0, 0xe53ca51c, 
	0xc9abf658, 0x75691ae7, 0x874fb68f, 0x89e7cb47, 0xd6a6cfc6, 0xcb88fdf0, 
	0x49133f1c, 0x21bcb371, 0xa61ec2eb, 0x0ada879f, 0xfe49f746, 0xf7ad1bad, 
	0x99ede202, 0x5f533f4a, 0x0d365da2, 0x747dbbe7, 0xa3e99f0e, 0xf8b7b973, 
	0xf5169cf8, 0x4ae7a2cb, 0x5cbce78e, 0xc74beb8c, 0xde51c74d, 0xb0a9eb27, 
	0x4d2454f6, 0xeb33c18f, 0x038beb0f, 0x8a86a7a4, 0x9bc3680d, 0x3eed1845, 
	0x6e46df8c, 0xe16fc58e, 0x073f434f, 0x8d6cebdf, 0x3c8bafbd, 0x0be60b7d, 
	0xef14a9dc, 0xc21ca075, 0x3ac3a67d, 0x2acf18a7, 0xd87d36ff, 0x3f4ff049, 
	0x6735f84b, 0x0cfee79c, 0x8fe6fc8b, 0x8f3fb3f6, 0xb3f04de7, 0x0b88f0cd, 
	0x1aaaf9fd, 0xc79033a2, 0x5d87f7e8, 0x9c3f820e, 0x1f21e17e, 0x13328ddb, 
	0x12f0b5ec, 0xebcc0f05, 0x236d52ee, 0x34bd8bd9, 0xbde8d2ee, 0xf63dcefb, 
	0xa06f194f, 0x4564759a, 0xd436f640, 0x4f48be70, 0x210d7153, 0xc3c06eb5, 
	0xbfec35ad, 0xd93176d8, 0x6cdf18b5, 0xf9f21a96, 0xb162ecc5, 0x64e2ed88, 
	0x62ec94fb, 0x6a731ff0, 0x7fc46b9a, 0xc13a5c21, 0xd4f42795, 0x17e854c8, 
	0x7de0fdf3, 0x851d3174, 0x7e0cfe31, 0x55c21568, 0xeafec35d, 0x25e31f5a, 
	0xefe7853c, 0xaa3f61ae, 0x8dc54b2d, 0x64ed4c84, 0xaced4a7a, 0xd7ddd18f, 
	0xbf8f2e6a, 0xb59dd365, 0x64b0a4e9, 0xa3e53dbc, 0x026103ba, 0xb3886edd, 
	0x093c2aa7, 0xdb220a75, 0x489f31f4, 0x26ad3f9a, 0x137e435c, 0x51d93fd0, 
	0x298a6bab, 0x1757fb5f, 0xe7e4038a, 0x5167f95a, 0x19bb0c7e, 0x3927653e, 
	0x50fb2332, 0xafd37cde, 0x676d8de4, 0x8ff51bbd, 0x0a8e11f3, 0xb6d372c1, 
	0xd91baccb, 0xdd4c732e, 0x3ff45bfb, 0x3f67e9be, 0xe7ade319, 0x12ad9e89, 
	0x6fb058b0, 0x32d6a51c, 0x596d7cf0, 0xf3f412c1, 0x7f95a6da, 0x76bd4359, 
	0xcb3ebb11, 0x0e7f840c, 0x42f3ea70, 0xb21efd12, 0xeda33df3, 0x3fcb8ffa, 
	0xa201df11, 0x9538e4a7, 0x7d4e5523, 0x4e031f4e, 0x1d106fe5, 0x1d3a5e37, 
	0xc6d9cf47, 0x2cb4c2e3, 0x25f7e719, 0xd27daf9f, 0x7fc46b8f, 0xd6021e02, 
	0x141d37b6, 0x0dbaa02f, 0xdc38c131, 0xc4c316a7, 0xa970e231, 0xde91212e, 
	0x795eb8ed, 0xebedcaa8, 0x6c8dc58a, 0x316ebeba, 0x2aaf8ddb, 0x1c6899fe, 
	0xbf3017e9, 0x3440e515, 0x787a148e, 0x2fae3547, 0x26eeea9f, 0x1b72a57f, 
	0x5b05adeb, 0x8fc42766, 0x0cc21e54, 0x9eece247, 0x13e4233c, 0xa9bef8c3, 
	0x1a3f158d, 0xf8b4b9aa, 0x555ed451, 0x1ad9f0fe, 0x58ff27b6, 0xafd926ff, 
	0x539fe5b1, 0x2f38dbd5, 0xb1c6deb1, 0x17144ff8, 0x1cae5610, 0xe3002e2f, 
	0x057c2377, 0x4fadd063, 0xd3c526e4, 0x88fe1172, 0x95bbfdc9, 0x4faaf81c, 
	0x89e63a0c, 0x276dfb8b, 0x7d909e59, 0xb99ce823, 0xeac5f708, 0xee3f6c3e, 
	0x39cfc42a, 0xfd319fa2, 0xe43cfb39, 0x78bfee57, 0xda2f423c, 0x8cefea90, 
	0x62545bad, 0x99ba6415, 0x74dd953f, 0xf8d2fc2a, 0x2a41ab72, 0xd0f9467e, 
	0xba9c8633, 0x9a9e7bc8, 0x3173f580, 0xb5e3bdfa, 0x3e63160b, 0x135e8e30, 
	0x12e4e6f8, 0x4bf45ca0, 0x3f900fd7, 0xf98c7487, 0xbf85bb04, 0xc7e741fe, 
	0x27939397, 0x7acc58af, 0xe88e5126, 0x28ce4728, 0x3e8cf77a, 0x89272da7, 
	0x9f199ece, 0xe5934dee, 0xb2f278fe, 0xc9e3cc21, 0x3de300fc, 0xf7883f74, 
	0x1d3c9497, 0x7d6eff03, 0x6f9ffcd0, 0xb60f7f8f, 0x086fd1de, 0xf472ed99, 
	0x4eba79fb, 0x8ded1172, 0x4724d3ce, 0x685d9dbc, 0x4e928aa7, 0x04b30fa2, 
	0x590a05ed, 0xc3bc3e60, 0xdd0097ce, 0xea095fa2, 0xc9e00f7a, 0x0ee42f98, 
	0xca48d04a, 0xff584e4f, 0xe827759e, 0x32b3d45f, 0x6e1eff5e, 0x85fe9831, 
	0xdb6ff481, 0x25feb6a1, 0x8dcf0f7d, 0x230c0719, 0x76fae295, 0x4c2aa73e, 
	0xd9e3fb7a, 0xb62e4ffd, 0xfedb50ed, 0x9b233997, 0x5aed7f51, 0xaae9f48c, 
	0xf245fd60, 0x89c951a7, 0xd0dfaa66, 0x6ddd7e50, 0x7222e1e3, 0x61b93c66, 
	0x00111fcb, 0x60f8133b, 0x7dd1aea3, 0xd1f8b6dd, 0x7f8153c5, 0x1a9d9552, 
	0x9edc836d, 0xc2fecc5a, 0x701ad0ab, 0x8e62d66f, 0xf8b6df67, 0x3b3be255, 
	0x027189ee, 0xb83877ac, 0x70ccf598, 0xbc68f7da, 0x8eaafa17, 0xc0bb4342, 
	0xa6b0c579, 0x7a19fca1, 0x8df39d21, 0xfbae6e29, 0xdc7e48bc, 0xf2f14c98, 
	0xd72efe3b, 0x7ca3cbae, 0xae3f3478, 0x71c7eff2, 0x967bcc3f, 0x4e214748, 
	0x67747153, 0x09e52f79, 0xd7581cf1, 0x52efef62, 0x8656a7fb, 0x1d1be434, 
	0x9df292e8, 0x30278317, 0xff8bf28d, 0xe9b7cfee, 0x1c784c71, 0x04761e57, 
	0x0570e0e2, 0xdaf986a5, 0x04803e7d, 0x30637968, 0x1f2407ca, 0xfe40796c, 
	0xc6c1f007, 0x3f90ef33, 0x8eb3f362, 0x8a33c7f9, 0xcbe33dcf, 0x264f5b0b, 
	0x1e570bcb, 0x6f2d83dc, 0x003e4a82, 0x1e2d343d, 0x179c3a62, 0x00633ca0, 
	0xd8309eec, 0x6d66ae11, 0xfb17a38a, 0x076cafbd, 0xd283d5fe, 0x263bbbbf, 
	0xd1af676f, 0xe909bfd9, 0xdef03d29, 0xd9bf001f, 0x2e7db798, 0x295b9f85, 
	0x713d3d29, 0xf3d4f3cf, 0x87cd0a40, 0x6a4394bf, 0x33740fdc, 0x92fe575b, 
	0x3d20a45b, 0xdbd1af95, 0x51f5561e, 0xd6347edf, 0xceea92d7, 0x69bf71cb, 
	0xeb869fb4, 0xbf784bea, 0x3cf53cf2, 0x687bcf00, 0x1a90ed1d, 0x75cafdc7, 
	0x905a4ebb, 0x97af667f, 0xfdfab016, 0x1fcad835, 0x5c006795, 0x04eb4295, 
	0xa52bcb18, 0x9efc05dc, 0x15ffbcd6, 0xb9e18cb0, 0x4ddedbcc, 0xa977dbcf, 
	0x215b5538, 0x73a88dd6, 0x3bb876b4, 0x2c4ea87b, 0x7d12718c, 0x479099b6, 
	0xc91e55d2, 0x071c2035, 0xdbcb7ee1, 0x0eb07685, 0x470809c0, 0x8bb469c5, 
	0x00f3e9c2, 0xde0a45ff, 0xe0e5d28b, 0xfb9744f5, 0xe5fb91ff, 0xd7447dcd, 
	0xec91d5e3, 0x68cac1f3, 0x91d527df, 0xa0806b38, 0x201d3116, 0x4c86067d, 
	0x7920ec2d, 0x3cf28e9e, 0x5a54f600, 0xce97ad33, 0xa3a65df2, 0x625aaf7c, 
	0xc72d89e7, 0x5a6c7685, 0x927c6ea8, 0x04440fed, 0xc7271bc1, 0x2daf081d, 
	0x6d3f6dc7, 0x4777a292, 0x7675f0ba, 0xd7bbae60, 0x2ff44861, 0xd9f87f95, 
	0x62d47808, 0xb1157d5c, 0xe8008ded, 0x3fd7dc3d, 0x647da16c, 0xb4b12deb, 
	0xd1840c53, 0xba7be6ef, 0xafe7096e, 0x8affae3e, 0x11f846e7, 0x4b4eca4f, 
	0xe099e757, 0xfc7a65f9, 0xd479a3f9, 0xffec2dc3, 0x1e80fc2a, 0xfddc61f3, 
	0xaec225da, 0x99e7e647, 0x0e7c3691, 0xa411e7fe, 0x377fb837, 0x87667be6, 
	0x16b6deb4, 0xf9a8a621, 0x168e97d0, 0x1cf63f8c, 0x21fe79c5, 0x626709e1, 
	0x3b6d7a1b, 0xca0c1dc0, 0xf8e207cc, 0x1cf9073c, 0xe35424f9, 0x875a3e41, 
	0xcaf805fc, 0x22ddf289, 0xf45df20f, 0x16ef9479, 0x4cef9879, 0x8e3521cf, 
	0xca2723fa, 0xf907a677, 0x4d4d64ae, 0xb76cc3df, 0x185edd3d, 0x79f327eb, 
	0xd0ae4c49, 0x5fb561ba, 0x78ae4c49, 0x1cf15c94, 0x5fb8e352, 0x78ae4c49, 
	0xa6fce3ba, 0xabe340a2, 0xc36c01fe, 0x7c015c4f, 0xfe7c839e, 0x205fcc22, 
	0xbcf80445, 0xb5f9b9a8, 0x5cf80303, 0x1bbfbf4e, 0x2a8f5b9f, 0x33687f3e, 
	0x51ac19c0, 0x70ed68e7, 0xc017f7e1, 0x3f285de7, 0xf313b383, 0x275541c5, 
	0x352edc58, 0x407d73e4, 0xa10bcfa6, 0x8ab52eff, 0x45fcf0b5, 0xf6083b53, 
	0xc91fdf75, 0x9fe9e3e7, 0xe23ebe7d, 0x43a3aa6f, 0x5f3063fd, 0xda90cc97, 
	0xb7de2477, 0x917f41e9, 0x662dbfee, 0xbf91f9af, 0x2a697f29, 0xfd924dfb, 
	0xae12ecf6, 0x8af80067, 0x7f11742f, 0x8c551d73, 0xe8938bbe, 0xbf8938bb, 
	0x387adec9, 0xe746dfc6, 0x62efe256, 0xf823eba3, 0xc127a2af, 0x0dfb211f, 
	0xfc5414f0, 0xad5dfd8b, 0x297f8597, 0x4437ea0e, 0x7c621f40, 0x4cf9da5c, 
	0x5fe2be7b, 0x52784259, 0x1f9d27f6, 0xc57df8f0, 0x2fe7c987, 0x6173eca9, 
	0xa2a727fc, 0xd7e451ef, 0x1cef386d, 0x90db4bf6, 0xeeaf8b5f, 0x97d229f9, 
	0x43c8371d, 0xf7768cb9, 0xd42de850, 0x14a0cecf, 0x36f8e27b, 0x3b9faa3f, 
	0xa3be2f48, 0xca3f25f8, 0x17a4ed47, 0x7ca3cfa3, 0x1f31aed4, 0x1a90ed49, 
	0x8fca3e47, 0x90d491f2, 0xe8d7528f, 0xc76c3fcf, 0xf58b1fd7, 0x3536f993, 
	0xbf682726, 0xa73f4af3, 0xda84e4c6, 0xcefda4cf, 0x8d483e2b, 0x9e2d09c9, 
	0x39865d6f, 0x65d9fa88, 0x809f3dc8, 0xfd2be6f3, 0x4a40ba9c, 0x73575be4, 
	0x9fa85bf3, 0xbea52bf3, 0x5b9e8323, 0x5bce18bb, 0x7e9216b6, 0x9536f9b3, 
	0xc3d7f3f5, 0x59675788, 0x2a767ea2, 0x3beb15be, 0xaf1483b4, 0xae4dbe60, 
	0x3b5e98f3, 0xc5c79d4e, 0x9d5474f8, 0x5714ac07, 0x0f2ce1e7, 0xbcae1038, 
	0x9d714921, 0x261e98bc, 0xe98bccbe, 0x9d3e04e1, 0xc3d51b5b, 0x313c17f9, 
	0x3fa89d3e, 0xeda9f365, 0x29d1c53f, 0xe5c617c5, 0xac9db3b3, 0x361f959f, 
	0xfcd99f1e, 0xfcfcbceb, 0x64fff94b, 0xb9f89dfe, 0x8abe7b4d, 0xbfcd8edb, 
	0xfe28ed46, 0x6a38bc25, 0x4e315f99, 0xd486f18e, 0xaa54deca, 0xe798f8b7, 
	0xea2438c2, 0xf7f3e067, 0x1d833f51, 0x8c9ec1fe, 0xf75cf8b1, 0xd4b51f22, 
	0x8a79f326, 0xfa2ef917, 0xbd2fa63c, 0x0f7a5f4a, 0x3e44f1a9, 0xb5cebf67, 
	0xcab7e6a6, 0xadb95f0e, 0xe64fd630, 0x3f6c5773, 0xd57be7e2, 0x7ed8ae7e, 
	0xbdf87609, 0x6c573f6a, 0xdc3b04bf, 0x07fe0c08, 0x202367ea, 0xc7195cf7, 
	0x294aaee7, 0x79e13a76, 0xa8fbf373, 0xffcf819f, 0x55dcf917, 0xe94efd69, 
	0x3c765be7, 0xa7876096, 0x6f0ec84e, 0x9fa42997, 0x5db1cf91, 0x3f505327, 
	0xfb045ebb, 0x9ef3f41c, 0x9fadcbda, 0xfd38c561, 0xfd64c53c, 0xe717f51c, 
	0xc76adfb1, 0x280e51a1, 0x79859ffe, 0x9ffe3898, 0x391979c5, 0x1fe613ab, 
	0xe9ea8daa, 0x885b0bfc, 0x9f8a03ff, 0x81ffca27, 0x3a003e78, 0x5e76740f, 
	0x02afff02, 0x717c3cfb, 0xe9fd77fe, 0xa5d67ff9, 0x959cdb9d, 0x7c023710, 
	0x330efe12, 0x802f08fe, 0xcf8a03df, 0xf362f193, 0xf11bdc3d, 0x2f3526fd, 
	0xfd20c2bf, 0x2f7abaed, 0x7dc18fd5, 0x5f1cc37a, 0xcd0eb0d2, 0x2de68e68, 
	0x8d8e11fa, 0x4ace1767, 0xe1446bf4, 0x3f154eb9, 0xa1f68f7b, 0x67f2faef, 
	0xf8993ac2, 0x33eb2c1d, 0x1ad6df1c, 0x5d3d47ab, 0x89b979cb, 0x7aec25e6, 
	0xdc75b8d6, 0xa919df18, 0x2e28ff65, 0xe545b10f, 0xe424b621, 0x3ced8621, 
	0xac75d8c4, 0x5c576eb8, 0xc38ec21e, 0x611f2c5d, 0xdfe065db, 0xcfa8213c, 
	0xe3b09776, 0x701e767f, 0xf8604465, 0x7ad7b6c6, 0xea5fc68c, 0x6ed44507, 
	0xbe397313, 0x523bef6e, 0x57609197, 0xa6f4df82, 0x1cdfb388, 0x29e732a9, 
	0xe3b71097, 0x5f216f7a, 0x97ae1c8a, 0x8696f150, 0x03921c86, 0xbae27ad5, 
	0x7109fdc7, 0x7e55db97, 0xddc549b6, 0xac833e89, 0x6e7e389f, 0x043aa896, 
	0xb04ab7d5, 0xcea8a10e, 0xf9f3d7ce, 0x8316f1c5, 0x497940fd, 0x9f8db776, 
	0x8268f8b8, 0xedc36e1d, 0x30301198, 0x80784f9f, 0x79526d7b, 0x21751830, 
	0x63df7e5c, 0x7a41be8d, 0x057585df, 0x85640fd0, 0xbf5d7162, 0xfa41ed5e, 
	0x522edb81, 0x708a2ae7, 0x4228a89e, 0xd43bf17e, 0x6ae757af, 0x3a2cf152, 
	0x2f73e21f, 0x1e7483f8, 0xc37583d3, 0x0a2510c2, 0x939d09ce, 0xbfde23e8, 
	0x67e2ca70, 0xa4af18ba, 0x81c561c7, 0x63bf8cad, 0x179516d0, 0x5c75be50, 
	0x098463b9, 0x3f035a6f, 0x3c3ef5cf, 0x23b236ed, 0x82db47cd, 0x0f2ade78, 
	0xa1a5d5e7, 0xf3c0cdee, 0xe3199c61, 0xc5b3a276, 0xa95d7bc0, 0x5afbfbce, 
	0xe8d7d7f8, 0x5fde0f7d, 0x0f566fee, 0x7ae73d23, 0xf6cea973, 0x3b779866, 
	0xd27b31e0, 0x8fe6cb54, 0xc8a79cd3, 0xc919b73d, 0xa05ee64f, 0x1bc882fc, 
	0x77937960, 0x66f6eb8c, 0xccfee09e, 0x3f9fb9d7, 0x11fcfdc4, 0xc73acfee, 
	0x7067967d, 0x17940315, 0xd4638192, 0xdc13828a, 0xfb9d782f, 0x3fb887b3, 
	0x24fb847b, 0xe3b96c7f, 0x8ebdbbac, 0x38221df3, 0xe0bcf9c0, 0xeffe9b51, 
	0x615ea201, 0x5f4187d5, 0x72d96597, 0x7cb2e64d, 0xbedf1415, 0x26442dcb, 
	0x17b997fb, 0xcff9ff36, 0xfbbc0113, 0x479fc5ce, 0x1e618f06, 0x92f1d530, 
	0xa0f0ffaa, 0xefb8269c, 0x3afee210, 0xcd70efae, 0xf80a0f00, 0x90b70ee3, 
	0x38d59a93, 0x27842fe5, 0x2a098ede, 0x8ebba6fb, 0xfff128e5, 0x4147881d, 
	0x33902879, 0x14794fc5, 0x619cb39d, 0x71a326f9, 0xd55f967e, 0xca89879c, 
	0xabaf9b19, 0x48f72da5, 0xd2f4d8ce, 0xbb67788b, 0xc6e59735, 0x9e6e9b9f, 
	0x827ae3ae, 0x59d9ba44, 0xf9fb03f7, 0x0eb3d21c, 0x778a8e73, 0x75bf39cd, 
	0x6d8176e2, 0xa0408057, 0xd594843a, 0x6c372419, 0x41f1d97c, 0xcb1e3253, 
	0x944b7656, 0x1c0729f7, 0x424beb96, 0x5cac85a4, 0x04b4938a, 0x6c41e6c4, 
	0xc3cdb68d, 0x7be9fad8, 0x45855755, 0xdab171f1, 0xef187943, 0x633dfc8b, 
	0x6b997cea, 0x07f39f7f, 0x6adcab84, 0xa1477ae3, 0x7f38aee9, 0xbef410d2, 
	0x6f9c901e, 0x78cd8008, 0x2935d706, 0x18b7a34f, 0x77d816fa, 0x09afc645, 
	0x604b7a1f, 0xaa6196f3, 0xf7c1c86f, 0xccbcab26, 0xf7d63ce4, 0xe6be5593, 
	0x2ed8ebdf, 0x059c01cd, 0xa7bc7e40, 0xace4cde4, 0xda11fd58, 0xec126987, 
	0x93e5d067, 0x934f39eb, 0xdda6c76c, 0x42cb587d, 0x398e8704, 0xfe47cfe2, 
	0xfd9c6369, 0xf640591a, 0x987f07ed, 0xbfb6e3ce, 0x73aaac2a, 0xdaf3bef0, 
	0xa2405ac3, 0x7d100b7d, 0x8cabf615, 0xeed00dc5, 0x151f45cf, 0xd1437ff6, 
	0x443314ff, 0xd71da070, 0x03a5ef06, 0x72f7f0de, 0xb84fbbe8, 0x1f69dca7, 
	0x3758e9d4, 0x6f093016, 0x754121e2, 0xd76bce81, 0x08a7f14f, 0x09c54f31, 
	0x7c3f2eae, 0x6417bb8d, 0xdc3314e6, 0x77f84839, 0x34b55eb0, 0x73b1fbdf, 
	0x3f389e22, 0x0755352e, 0x9cf38298, 0xeb2c189f, 0x7c63152a, 0xce9b399f, 
	0x564ef11b, 0xcfb67af9, 0x1bfc7c6d, 0xcbe9039e, 0x3da0fbce, 0xd9537e8f, 
	0xcbef84fa, 0x26a6bd9d, 0xce16841f, 0x0ad8fd21, 0x5e7083b2, 0x37eb00a4, 
	0x7677356b, 0xde950eac, 0x805c7807, 0x756bac37, 0xefc0af09, 0xf0fef02f, 
	0x073c0bfb, 0xd525b1e7, 0x1d54b9b1, 0x1999c605, 0x0357ae4e, 0xd575abc5, 
	0x9c638dc7, 0x647e83da, 0x17e608e0, 0xbf66f1a3, 0x7c46eb4b, 0xdf345c04, 
	0x76db4f8e, 0xbc3efd96, 0x9cb1a6d7, 0xbabf2074, 0x23b27bf0, 0x60408f80, 
	0xdb1c36b3, 0xed0813d7, 0x6317efc1, 0x1e1c02fb, 0xf0e933e4, 0xa1a07db1, 
	0x80bb04be, 0x17de01ee, 0xc02f7768, 0xeb87b9fb, 0x7aaf51a5, 0xd4bf422a, 
	0xb44e7c43, 0xeca647af, 0xe83e38e5, 0xedfb3465, 0x74c8f778, 0x5f51cf49, 
	0x7c3dc077, 0xbc4d2c1a, 0x2ba2b747, 0x2ba17fbf, 0x70505f29, 0xffa4e416, 
	0xcfc9f5fc, 0x1e73cf73, 0xb922d73f, 0x4d1de667, 0x79582c45, 0x4fa953c7, 
	0x3e3017f5, 0xf9fb9073, 0x3fcfdcc3, 0x9d67f3cb, 0x8b2cfee7, 0xc0cde5ea, 
	0x0f9bae51, 0x7904bf1c, 0xd1f49229, 0xd67f9f27, 0xacc20e55, 0x2d9e3ff2, 
	0xb10af72b, 0xe46e5850, 0x7745fd93, 0x5c9f21f6, 0x29ec1933, 0x277283e0, 
	0xfc9cb6b7, 0x83c73d52, 0x10b945b0, 0xf41e134a, 0x44fbf727, 0xf9fe04a9, 
	0xafd33d72, 0x12a7fcff, 0x81d770f0, 0x0b6f36d2, 0x5c3b7f56, 0xefca1772, 
	0x5b67e216, 0x519f1a9e, 0x7aaec9df, 0xfb4370df, 0xf55ddd5c, 0x3238df68, 
	0x3ca1778f, 0x68fe462b, 0xcdf928fc, 0xd759a2fe, 0xfe352689, 0x7b42de91, 
	0x2ec12fe1, 0x2a7a4910, 0xd674dfd9, 0x768f5fdd, 0x06454a50, 0x6ead97f9, 
	0x30679860, 0xa57a004f, 0xd93c7c67, 0x2ec31ff8, 0xe7f65e92, 0xefce22ff, 
	0x3f503bac, 0x6b2ebe96, 0x1ca0e708, 0x9f357dbe, 0xedfae3fb, 0x203d288f, 
	0x261f2530, 0x081d75fa, 0xf22e7ed3, 0x603d41e7, 0x52fe1ebe, 0xe973d1cf, 
	0x717ec63e, 0xf8853d42, 0xe61fa58b, 0x5f6f8adf, 0xd0e1d6e7, 0xd9f77f57, 
	0x699efc54, 0x5348fa3c, 0xaa69b7f5, 0xe7c6d76e, 0xd71cf57b, 0xfd5ebb79, 
	0x75c1933e, 0x676f582f, 0x4bcfaa09, 0x24f97c45, 0x9ff40aa8, 0x509a994c, 
	0xf13f3b2f, 0x1e32bd77, 0x0032ef5c, 0x2d7ba988, 0x66a7de17, 0xb7949cfa, 
	0xaa9d36cc, 0x6ffa9cbe, 0x2b00f92b, 0xad29f3d1, 0xd1d52a66, 0xb53e79de, 
	0x6bbeac22, 0x51aa3d61, 0x4eedd59e, 0x8bdfabf0, 0x6bbfcfbe, 0x2a6487a0, 
	0xfb9405ea, 0xca8d9df4, 0x2fe4269b, 0xde7898df, 0x7bb29274, 0xea27a647, 
	0xaff86285, 0xf04bfc8d, 0x415e38b7, 0xdfda25fe, 0x3e67c859, 0xc7b333f0, 
	0x300503cf, 0xabfe4c7e, 0x20798979, 0xe2079499, 0x238a247a, 0xbcaede23, 
	0x1f9370ce, 0x7a3fad1a, 0xcdfb9d42, 0x629efc8f, 0x33583c9c, 0x9ce17fc6, 
	0x1e4581cd, 0x9e50b78c, 0x0e6ff616, 0x7ac1e63e, 0x9ca5b29b, 0xca4e696f, 
	0x8f9f46d7, 0x71c5af93, 0x939b2bb4, 0x6b4db5f2, 0xc43c7606, 0xf853707e, 
	0x835f58f1, 0xb787897b, 0x41975629, 0xf6ab5eeb, 0x65d58a6b, 0xaf6be424, 
	0xc535fb55, 0xf29232ea, 0x66d46fb5, 0xf076be73, 0xae013b13, 0xbd744b4a, 
	0x432bf308, 0xcc09b753, 0x3d77ead7, 0xe5cf8359, 0xe277db7d, 0xd6faf173, 
	0xc0b831f3, 0x7a42e92e, 0xb3e68e2b, 0x1bff6807, 0xba9c7296, 0x0bef0a38, 
	0x79f46f04, 0x1417de14, 0x8bc116bc, 0x2ebf18e3, 0x116bc28e, 0x0cd76bbc, 
	0xd3f0a83c, 0xeb1456d6, 0x6d67e327, 0xf7ce5e34, 0xcfc2ab71, 0x3cbc68da, 
	0x556e3ef1, 0x8d1b59f8, 0x7e099b97, 0xb5518966, 0x6253f102, 0xfc44df84, 
	0x0e5a5714, 0xadaf67cc, 0x936f750c, 0x2768174c, 0xdf373496, 0x8e00e4f5, 
	0x67b737cb, 0xfaf5b8e2, 0xb3e031d6, 0xe525e6f3, 0xb4126205, 0x78e52db7, 
	0xd5533062, 0x7f632ffd, 0xeb9f1936, 0xfae7c1c7, 0x7d19f071, 0x70eb47ae, 
	0xa777543d, 0xa6b399f0, 0x9f0a7be6, 0x3c7f68bf, 0x37864fd6, 0x5be11eb9, 
	0xd5e39f0a, 0xe14b7c23, 0x211eb933, 0xbef2fe7a, 0xf451c97f, 0x62588c83, 
	0xda55dff4, 0x2813784f, 0xad2a73de, 0x1b8cedef, 0xc42999cf, 0xdddfb8ee, 
	0x08a609cc, 0xf44d7bf5, 0xdfd89bbb, 0x073a820b, 0xfb17bf70, 0xef9f43fb, 
	0xe4f841ab, 0x89dfef6f, 0xe0ebaf6d, 0x113da0cf, 0xd85d3bd2, 0x358adef6, 
	0x3aeb3901, 0x133fbede, 0xf7cfa1db, 0xac7b4154, 0x563ff79d, 0xbe10e6b8, 
	0xf2f1dcdf, 0x4c7e3803, 0x91efb71e, 0xf81639e0, 0xd78e0f42, 0x381d8ec8, 
	0xf4b6635e, 0x0a1c23f4, 0x2cde8efe, 0x8e9c9fe4, 0x7187d4c1, 0x96cc3bbf, 
	0x203f9c2e, 0x9e103b23, 0xd756408e, 0xda979a62, 0x9bbbe383, 0xdbd69aff, 
	0xe3f6f1de, 0xe6b1be38, 0xb99f3e39, 0x6c514b60, 0xddbfe87f, 0xfd18f8f1, 
	0xe179f851, 0x90de1b31, 0x0b7f3d1c, 0x0fd50fdc, 0x449b74da, 0x7296478f, 
	0x53307a5d, 0xb9c24bfe, 0x4b9f712f, 0xd5fb6f9e, 0xf307a507, 0x1b2df74a, 
	0xe51e9fdb, 0xa02eae47, 0x1da1c63a, 0xe8f8deb6, 0xe7d9f9df, 0x7c697f7b, 
	0x3bf6d83e, 0xe8044e73, 0xd6727e77, 0xa5063829, 0x51c157a7, 0x82bc7000, 
	0x3eba4378, 0x587ae8a7, 0x71aa0e7a, 0xe8955dfc, 0x8be280f8, 0x7647385e, 
	0xf8f61cec, 0x20f7b608, 0xe77f305d, 0xeff6e874, 0x3b9c258d, 0x6a23deba, 
	0xe3d8c0fc, 0x5bdfa7d8, 0xb23d2c39, 0x256fae27, 0x3f428ff5, 0x327fae3b, 
	0xf72cfc69, 0x37f3e7a3, 0xd42b7ed0, 0xcce7397e, 0xdbac21d0, 0x137720b9, 
	0x4c55eb1d, 0x3b721dd7, 0xaa38b5d3, 0x4e82c9e4, 0xb511dba4, 0xc206fcce, 
	0x0e9d7443, 0x60fd05ab, 0x17dccf78, 0xd8e58767, 0xbaba8cf1, 0x73d57dc4, 
	0xa973f43f, 0x75d78a0e, 0xcbe092f8, 0xb7c44d93, 0xf21f00e5, 0x2af13ce5, 
	0x366a477f, 0xd18a2d6d, 0x089fc397, 0x7f3c72cf, 0xeddeec6b, 0xe96b86d6, 
	0x6aeff632, 0xb6b92996, 0x19c2785c, 0xf2791fc0, 0xebf1d3f8, 0xf7d6a53f, 
	0x9eafc125, 0xb866ece7, 0x5aaf75ed, 0x6eae7ac6, 0xf69ddb19, 0x79d408b8, 
	0x4bf7a80e, 0x7623f9f1, 0xdd6929bc, 0xee0f0afd, 0xf3d1e7c4, 0xe0f0509c, 
	0x57f8f17b, 0xf88d3fcf, 0xa8cf79c4, 0xf5a48179, 0xfbeb539f, 0xd7c6c6eb, 
	0xa2ab8290, 0x8d5073c1, 0xe3d81f23, 0x42ba6c2b, 0xae27b13b, 0xe849f80f, 
	0x3b32fac3, 0x33fe7fae, 0xcf377d89, 0xcab6533f, 0x7f3af183, 0x23e8089e, 
	0xedb82794, 0x3bc7a401, 0x8dbeca3a, 0xfec8f7f4, 0x06ae887b, 0xba3fa9da, 
	0xfd274ece, 0xd29976b5, 0x5476495f, 0x7638f9f4, 0xc965dad4, 0xa8ed8d7a, 
	0x6fc66322, 0x55f5e332, 0x2d8df8a5, 0x8d15b7bf, 0x67ac9e3f, 0xd2bacd83, 
	0x7283c2d3, 0x4a65ceec, 0x883ec34e, 0x0f116c7f, 0xf77f53ff, 0x2b3efc32, 
	0xec7b0818, 0xabda1ffc, 0xa003ca26, 0x8b19a6dd, 0xe3f47e3c, 0xf59760fc, 
	0xf9817db0, 0xd4b3b5d2, 0x6bdb00f3, 0x02051545, 0x4645b0e3, 0x5ceb85d8, 
	0x0116bcaa, 0xf3bf18ab, 0x25d4bcc3, 0xc51573d6, 0xfa84c9e7, 0x63cc231d, 
	0xc8e39fa1, 0x5b75403a, 0xfbef9c62, 0x77c4538a, 0xfc547fb7, 0x94bf293a, 
	0x4f9db70c, 0x8e98fbf1, 0x906e311a, 0xe3027ac9, 0x98475862, 0xb8f18835, 
	0x34f14690, 0x98191bd0, 0xcd165e9f, 0x3eb47e1b, 0xe282b8aa, 0x9dbdbf9a, 
	0xce1603bf, 0x2e2d3696, 0x32f2f9ae, 0xafc727be, 0x7be9eae3, 0x1501fce2, 
	0xa5a67657, 0xde21ddb8, 0x67171dcf, 0xaa99767d, 0x57de4a43, 0xf07a495c, 
	0xb1fec3e6, 0xea93e7eb, 0xa1eb92a2, 0x6560f9f6, 0x99e6b3b8, 0x7f80df20, 
	0xfcb15982, 0xe411d637, 0x5a7ce6ce, 0x5aade173, 0x5319c70b, 0xb81c5586, 
	0x9c3e0e25, 0x7c16383f, 0xcbc20aa1, 0x8d57d3f2, 0xe3b5ef19, 0xe7d3b9bc, 
	0x15875c13, 0x53bfdbff, 0xbebf4a18, 0xbfee0b34, 0x4b8fd669, 0xbe6da0f3, 
	0x20b2faf2, 0xf85a5fb4, 0x25db8a63, 0xbb7dfbfb, 0x5aebef7b, 0xdfa4ad84, 
	0x375bed05, 0xd7f53f78, 0xfb13b249, 0xaeeecd9a, 0x3fe56c01, 0xed0a9dec, 
	0x06e8e11a, 0x63afb13b, 0xc1eadb50, 0x7df99036, 0x125f4fac, 0x126bbfba, 
	0x7deb9ff4, 0x4e7fde84, 0x60d4f7ad, 0x94ffbd0f, 0xef83dfdc, 0x48b4223f, 
	0xa4c7b42d, 0x5b047b6f, 0x1dffc16b, 0x4efbcf83, 0x1e07f344, 0xdff71dfc, 
	0x18e7678f, 0x5c7f23bf, 0xe2017cc7, 0xf74f98cb, 0x3e35ee5b, 0xe6e5feb2, 
	0x6abe8a15, 0x24efe59f, 0xdc33c00c, 0x985d6957, 0x2dcdd77f, 0xa47beec9, 
	0x31cbe7ee, 0x60ab78ee, 0xfaf6be7f, 0x7ec12a9c, 0x4e13c736, 0x7dbbf46a, 
	0xa4e85f98, 0xc6377f7e, 0xf3455617, 0xa2a662cb, 0x5e8efa33, 0x81fc18af, 
	0x7e3af446, 0xc502e81c, 0xfe352f6f, 0xe79e1663, 0xc5a16f38, 0x7a8f05fb, 
	0xfcab0f48, 0x8a3c15a2, 0xa937e744, 0x9086e9ce, 0xc2ffe283, 0x5f886a67, 
	0x5df8879c, 0xf0173f61, 0x9c5b9b3c, 0x7fa8e38f, 0x80b4dd57, 0xeb04bf7e, 
	0x5e30fb22, 0x26f9da60, 0xce4df28b, 0x9ca3f62c, 0x18fdbde5, 0x25e677a7, 
	0x2cb709da, 0x8370f967, 0x51699d6a, 0xfc630e7e, 0x0bf3d57f, 0x84bcf05e, 
	0x9ec28fed, 0x8eabc246, 0xcb658575, 0xeee4fe39, 0xf8c14b6d, 0x11d0f2ee, 
	0xec1bc607, 0xf0ccf97b, 0x784114a9, 0x929dfc93, 0x671175c9, 0x7f1d5a8c, 
	0x93d6e297, 0xd60fbad5, 0x74453d59, 0xc4155e61, 0xb606a0c8, 0x42e0d641, 
	0xc58fce27, 0x4879dddf, 0x4c69be4f, 0xac8fab5f, 0x1f1c12ac, 0x747c600d, 
	0x30a3f989, 0xa7d4491c, 0x53ccfc0a, 0xa76ab8dc, 0x55da02a3, 0x7ca4b7c3, 
	0x96eae812, 0xe09d0ee3, 0xacba5b73, 0xb8e27ba2, 0x5ca9ef60, 0x79f63bf5, 
	0x857bbf28, 0xa37ce3cc, 0xe3137d45, 0xb7cd1a8f, 0x17a98ce3, 0x01ee15a8, 
	0x8ee38b82, 0x1c7377e5, 0x7fd7c57e, 0xee02ab34, 0x1b83f97d, 0x8c5e1966, 
	0x39717e97, 0x6f57ebda, 0x70865a3a, 0x91e8ee7c, 0x31079414, 0x15dfe43a, 
	0xc4567aa4, 0x16ca4ff3, 0x55667c61, 0x1c70b0aa, 0xb5f78ef1, 0x75c79d2a, 
	0xad6bf423, 0x437f9f17, 0xfe30f4f3, 0x162f7fe3, 0xf58c37ee, 0xdfa2ab0b, 
	0x0fae2619, 0xbf17aefa, 0xf7f55d7b, 0xfe60a557, 0x1902474e, 0xfb43ad8a, 
	0xf02373e1, 0x610fc533, 0x6dc25efc, 0x2ff44e9a, 0xe8f382be, 0x7aad7ff7, 
	0xd54fc3e4, 0x8a1f10b7, 0xffea11c8, 0x3dcb396a, 0xbd766dcd, 0xfbe210e6, 
	0xa72c77f5, 0x0f3855df, 0xffaf40e3, 0x3e6dc6a4, 0x8e0ee90e, 0xf1841f7b, 
	0x9517be2e, 0x3ce5cb7f, 0x5beaa75d, 0xba1798b9, 0x77f47973, 0x71ccff6c, 
	0x8c648070, 0x87c23838, 0x389dcd7e, 0xae7535fe, 0xbf73d8ec, 0x626f28d0, 
	0x7f615f7f, 0x72ccf02f, 0xdb249b8e, 0x3e59df7b, 0x7d17bdb6, 0x87bd8e3e, 
	0x7bd963e3, 0x7bfc99e5, 0x40d7186d, 0x4f718d3d, 0xc1e82f55, 0x571ebeef, 
	0x73db6ffc, 0x25d73f7e, 0xdfb27cd1, 0xa3b9d00e, 0xed8337f1, 0xa978e4b8, 
	0xf415ef1f, 0x7fb2e970, 0xffff29fe, 0xdfaa4870, 0xea8d4c31, 0xaaeb4a60, 
	0x9ff41f0c, 0x7ad9fb56, 0x288ba6cf, 0x01ba289d, 0xc370c91d, 0x1cd7543a, 
	0xdf43c178, 0xbae72c1f, 0xfce09f8b, 0xd9f3b8d6, 0x340342f3, 0xaf3579ef, 
	0xa201c969, 0x3eea03d7, 0x450f6a2e, 0xa3c33bf8, 0xe84ea773, 0xfd6d7877, 
	0x979fec95, 0x7f906537, 0x2b573d1e, 0xfaf6eb9f, 0x9dcf04e3, 0x2f4573f6, 
	0x325ffa91, 0x7879a8df, 0x6a4d6e1e, 0xac5df193, 0xe545fef2, 0x9dfc1e8d, 
	0xfed7dff2, 0xde07b966, 0xe6596777, 0x25ef4911, 0xf25bb77c, 0x8d48afa9, 
	0xde4405ee, 0x7ea7ae10, 0xe38ea2ef, 0xb2efd1c8, 0xd4fe70a7, 0xd3f9c751, 
	0x24deeb3b, 0x72d84eb8, 0x5e9bc140, 0x5de98277, 0x7509d7dd, 0x446fd41f, 
	0xf8e99126, 0x5412b7ff, 0xaada257a, 0x4505cdf8, 0x9da0e707, 0xa07def0f, 
	0xb63af6fa, 0xd24c173d, 0xf056ab5b, 0x122ba5bc, 0xacb83fe7, 0x59c2056e, 
	0xd9ef82b7, 0x574b93b6, 0xb83d9f30, 0x7bc243ec, 0x934c77f2, 0x1dfd8c57, 
	0x38f9f453, 0x1f1c4371, 0xe6a63beb, 0xfcb51d35, 0x8df9843d, 0xfd6227ce, 
	0x39aabb64, 0xd473bf89, 0xf0e3cd7e, 0xafda8e77, 0x63bf8939, 0x43f0f171, 
	0x437e2e2a, 0xdbf254d9, 0xbb7180fe, 0x895ecae6, 0x2f947171, 0xcd454f78, 
	0xee31fb43, 0x0f29539b, 0xf8a2ed74, 0x31b6fd79, 0xfb522be0, 0xce390514, 
	0x749e7886, 0xcd074636, 0xc3f27681, 0x240fbe6c, 0xf98de77d, 0x255bee0f, 
	0xb55c8f58, 0x10ddf622, 0x3fd1cff1, 0xd4718eae, 0xf54943f7, 0x9bcd138a, 
	0x98d374d8, 0x748274c5, 0x8c447183, 0x65efaacf, 0xe177685c, 0x9c7c4f73, 
	0xe39e05ac, 0x113d2c7d, 0x09d68be3, 0x39e395c8, 0x56bc4fe4, 0x439d453a, 
	0x61ec1238, 0x37583390, 0xfdf9c623, 0x55be7df3, 0x2e0fdf44, 0xe902bd5b, 
	0xad8fca38, 0xc7f42e1d, 0xc45e3ffe, 0x00005923, 0x0012a622, 0x4d5a10e4, 
	0x0000f004, 0x00000090, 0x001e113c, 0x0012161e, 0x001215b5, 0x001e1722, 
	0x001e09e3, 0x001e540f, 0x001e0a8c, 0x001e1547, 0x001e15a3, 0x00000020, 
	0x001e1457, 0x001e1591, 0x00000050, 0x00001b52, 0x00121992, 0x001e2322, 
	0x001e1755, 0x00001cd7, 0x00000020, 0x0002506f, 0x001e512d, 0x00000020, 
	0x001e4f06, 0x00025167, 0x00000060, 0x00040877, 0x001e0222, 0x0004078b, 
	0x000400d8, 0x00040219, 0x000409da, 0x000000b0, 0x000631c3, 0x00060002, 
	0x00062efd, 0x001e361c, 0x001e30df, 0x000631fd, 0x00063047, 0x000634f6, 
	0x000634bc, 0x00063492, 0x001e2f50, 0x00000020, 0x00083843, 0x00083770, 
	0x00000020, 0x000827cb, 0x0008263a, 0x00000020, 0x001224cb, 0x00122584, 
	0x00000020, 0x001e4d5c, 0x001e4e61, 0x00000070, 0x001e4bcc, 0x001248c3, 
	0x001249d4, 0x000c3fa2, 0x000c3c40, 0x000c3b33, 0x000c4243, 0x00000050, 
	0x000c4433, 0x000c449d, 0x000c4541, 0x000c44b9, 0x000c4584, 0x00000020, 
	0x00123a84, 0x001245e4, 0x00000040, 0x00bebc20, 0x00000003, 0x00000000, 
	0x00000000, 0x00000060, 0x0001000a, 0x00131208, 0x58cdb22b, 0x00000000, 
	0x010205ff, 0x00400804, 0x00000020, 0x01961100, 0x00000018, 0x00000020, 
	0xff81ffff, 0x00000fff, 0x00000060, 0xfff80ff9, 0x00000fff, 0xffffffb9, 
	0x00000fff, 0xfff80ff9, 0x00000fff, 0x00010012, 0x001e1d1f, 0x00038701, 
	0x7dd59c78, 0xd5d47c7b, 0x3df9e89d, 0x24ccfde6, 0x76892121, 0xb2020108, 
	0x8714a536, 0x423f2dc0, 0x47842642, 0x40515640, 0x088d0407, 0x2254b238, 
	0x266fcb75, 0x703e2421, 0x6d405412, 0xdadaeec5, 0xd4ddef6e, 0x76a2eedb, 
	0x2d048777, 0xb68b76b8, 0x6f6b6d5b, 0x6d15c3c3, 0xf6bb4bda, 0x72bd6c63, 
	0xcbf38fbf, 0x5704123c, 0xfe6f76ef, 0xbf7e70e0, 0xef8f3bf3, 0xe75f7ceb, 
	0xe7f3f9cc, 0x12ee77cf, 0x450a89e2, 0xf084e7e8, 0xe63dd3ba, 0x3c8a2149, 
	0x84298f66, 0xbbd19c68, 0xe2129c4f, 0x03b5e54c, 0xafeb1ba2, 0xd0f58814, 
	0x33ec63ce, 0x3aafa815, 0x29bfa254, 0xed002784, 0xe6684213, 0x9d730ab9, 
	0xcdb83710, 0xca034cc7, 0xf805fdea, 0xbd19b6fd, 0x10a4898f, 0x02cd4b0b, 
	0x7d9400f3, 0x129a8966, 0x059844a2, 0xeed0831d, 0x70897f5c, 0x598680c1, 
	0x38dfdf82, 0x268856ac, 0xcf035768, 0x04373e61, 0xf03df54b, 0x78c54cfc, 
	0x442f7e21, 0x159dddfc, 0x076c8741, 0x86bd068f, 0x8857bdad, 0x51728abe, 
	0x26215bf8, 0x8f34c39a, 0xde30656d, 0x00af1a31, 0x83fab3c7, 0x603a4b71, 
	0x5bbe377e, 0x96d7315b, 0x2e6e3719, 0x71c710a8, 0x7c42299c, 0x2ebff641, 
	0xe70dfe33, 0x41c4cbd4, 0xb4d48621, 0xeb097f30, 0x8ec12a8e, 0x979c4271, 
	0x9753fc70, 0x25cc3819, 0xf4dd2c38, 0xd7c27eca, 0x008550b6, 0xd8ff797c, 
	0x17eb805b, 0x004b61a6, 0x920217bc, 0xdda91b93, 0xfbc7e200, 0xe592a9c1, 
	0xf25d3ef4, 0x9843e20c, 0xf81d4715, 0x6733d93c, 0xd4dfac37, 0xed8c5a84, 
	0x0153ec57, 0xa7eddeaf, 0x8827e64a, 0xfdf50a0e, 0x7c375dfc, 0x7afefc5f, 
	0xca04729b, 0xfb7e6306, 0xb0c7ec29, 0x377f4375, 0x88039856, 0x60f7ac7f, 
	0x23f10abb, 0x9dc42a33, 0xf409c4f0, 0xe91358b7, 0x04421be4, 0xd342cdca, 
	0x8a73f809, 0x940cffb4, 0xcdc7a442, 0xd6b64684, 0xddf09cc7, 0x9ba061d2, 
	0x13072846, 0xbd20ea85, 0x8527f617, 0xc42623b8, 0xb6cf581e, 0xf3d8aa03, 
	0xb38ba81d, 0xfda0505f, 0xb0a978b6, 0x4dc7067f, 0xe0f78817, 0x0995805f, 
	0xcd4a19f3, 0xc09f8b89, 0xf039aee3, 0x7671e000, 0xfd0ea17e, 0xcefb4235, 
	0xd8f99909, 0x7da94e81, 0xb7db96bc, 0xa47b72d6, 0x0084b78b, 0x4c208b90, 
	0xdf222862, 0x60e2d4d7, 0xac1278a2, 0x10a5043f, 0x19434287, 0x5a9971ba, 
	0x7b9f03b0, 0xf9876885, 0x7d2b6efa, 0xd8abf906, 0x9b9cfa29, 0xf1893e19, 
	0x5fe2bc19, 0x0cf91c7b, 0x70e80ef8, 0xf229f229, 0xf101e027, 0xd9680dbb, 
	0x0881093e, 0xeb949ddf, 0x6f79b807, 0x0f174d0b, 0x3d743d03, 0x3082205f, 
	0xd42a88df, 0x7dffa887, 0x2ffd595d, 0x32f8b329, 0xb106a25d, 0x7927b37f, 
	0x28c4f90a, 0x77d680ec, 0xff710b0c, 0x47012806, 0xc2477d0f, 0xff5ca0e3, 
	0x6fe7093a, 0xd0e7868f, 0x56bc2e70, 0xc0efd0e0, 0xed580373, 0x55c3c01a, 
	0xa4cda2b5, 0x731c54f9, 0x7d707e30, 0x279072fe, 0xb3ef888d, 0x0b7fc83d, 
	0x09059837, 0x2215da83, 0x31168efe, 0x2a6b1afe, 0xf380ddf5, 0xc232b125, 
	0xd60bcd2f, 0x3ef128df, 0x8fc72ad4, 0xf8f9f8f0, 0x08dfe6b7, 0xfce277df, 
	0x0b8ecdcf, 0x9e189798, 0x1f01ed4d, 0xd1e6c487, 0x63c11d78, 0xe8ec16d4, 
	0x8478e8fd, 0x5dc40bce, 0xca849f80, 0x76c42874, 0x0ff50784, 0x29c224fc, 
	0x6b01a75a, 0x1d71bb36, 0x7e34ed91, 0x984c29d0, 0x6c3d8297, 0xf931e787, 
	0x1856bc5d, 0xf876acc9, 0x3a15da1e, 0xf0012514, 0xc2198431, 0x217fe07e, 
	0x03a2cf84, 0xa509d141, 0x374c5d3e, 0x447a3e99, 0xdabbe50a, 0xed47bea7, 
	0x8bfd700a, 0x7b9dc25a, 0x769a1f80, 0x0fbd7e68, 0xfbc157de, 0x2a8e08bb, 
	0x92fc6fbe, 0x3041ed90, 0x44383f20, 0x65f81dba, 0x8ab260cd, 0x43568bf6, 
	0x7edc17be, 0x553755bd, 0xe3ad77fc, 0x5841558f, 0x2f92baff, 0xf2852a4e, 
	0x9c7f29a6, 0x36ef8614, 0xc9c5f55e, 0xa5bf50d5, 0x6b938ff1, 0xb5eb7ea0, 
	0x81129c5f, 0x1242fffa, 0xedb9fa07, 0xc14c3fda, 0x5a29a2fd, 0xdff28557, 
	0x4454a913, 0x75fce198, 0x16b7b380, 0x1802a9f6, 0xf2443aaf, 0xe60005aa, 
	0xbfadda01, 0x1a88e5a9, 0x352e7de2, 0x4caceb48, 0xb45d6375, 0xbaa4dd73, 
	0xd479614b, 0x4c54cbb0, 0xe1113e7e, 0xd5156be7, 0xd6f73f28, 0xda502740, 
	0x71d2a6c3, 0xc4ee2e0b, 0xc363c444, 0x01534356, 0x62f136de, 0xacdbc335, 
	0x77a73c46, 0xce8f0985, 0x6baa8b79, 0x1dc346bb, 0x01da9d44, 0x33503ddf, 
	0xfc619843, 0xdf89582e, 0xfe25338d, 0x6b8e8083, 0x5f3bef01, 0x8e10c713, 
	0x44fb6a33, 0x66ab340b, 0x82ac6c7a, 0xcff809fa, 0xbfd708aa, 0x71f7e114, 
	0xe36d6f59, 0xebeb21ba, 0x6225bd65, 0xf22545f1, 0xdb95c35d, 0xabbee14e, 
	0xb1139c47, 0x344c1f0e, 0x66f4329b, 0x912a30af, 0xd7c2d49e, 0x1bfc22ce, 
	0x29fa7cae, 0xaaf50fdc, 0x43c41ec1, 0xc3389d63, 0x41da81f4, 0x6ace1f06, 
	0x69c1e107, 0xc220a118, 0x828446ad, 0x96bfd44d, 0x07dfc75a, 0x8e5ddf61, 
	0x68fe0770, 0x0cef369c, 0x0cf40e40, 0xb0c66031, 0xeb877904, 0x62669cae, 
	0xd037f03f, 0xb77ae385, 0x909c200d, 0xde197098, 0xc817c072, 0x509b7b31, 
	0xe1f60f11, 0x23874174, 0x46b4de4b, 0x3944d044, 0xfae1a2d1, 0xa2a6e31a, 
	0x847df1a7, 0xe186bef9, 0x7d7293e1, 0x23dbbbe4, 0xe9f2a724, 0x98a5f481, 
	0x480987a4, 0x08f56a8f, 0xda1f7c5d, 0xe10bad2f, 0x4cce903c, 0x207a68d7, 
	0xe92939ba, 0x3511e005, 0xde51aaea, 0x309a3d21, 0xdedac6af, 0x6c1fd8d3, 
	0xf48ea191, 0x18b9ba68, 0x633d209d, 0x835744ff, 0x89ba01ff, 0xc37494ee, 
	0x7442f3f2, 0x24d2f443, 0x8e8b25e9, 0xe886e9f2, 0xe7e925c5, 0x8e7f7ca0, 
	0xd3ce03e5, 0x3c920b17, 0x955e95f6, 0x3af984ec, 0x9724a563, 0xae1a6fe1, 
	0x2ceb94d3, 0xb0d7cc74, 0x09966fbf, 0xce027da7, 0xe05773f7, 0xaecb17fb, 
	0xaa2a7920, 0xe502bbaf, 0x330bdb67, 0x698c2eb9, 0xbef6cf44, 0x679c15b7, 
	0x4e6fe1d1, 0xce8847bf, 0xd4149b8a, 0xd27b9cf3, 0x46e13c57, 0x40af36fe, 
	0x3e92163a, 0xa18e9e88, 0x31bf17bc, 0x683cd04f, 0xb757440e, 0x10ec9d20, 
	0xf4949e7b, 0xd218f806, 0x7d11db73, 0xbee49e11, 0x49e24f33, 0xd220d5d2, 
	0x47a2c8a3, 0xb9d10ee7, 0x91bf6b31, 0xb9390cfd, 0xd0cf55bd, 0xe6dd2e67, 
	0x0cd0ebd3, 0x47e61bf1, 0xc5b3e483, 0x9278768f, 0x0f603d04, 0xdcf0a020, 
	0xbd2cedd8, 0x37b53f72, 0x49b4f762, 0xbf0c897c, 0xef866d0f, 0xfbf0cbde, 
	0xe22df125, 0x0908d5b9, 0x94a6ffc9, 0x5b77a807, 0xd7cf9bfc, 0x279f971f, 
	0x5fb6ece3, 0x3a5daf98, 0x57f0dfef, 0xd2c5e921, 0xec4e2a47, 0xaf65faa1, 
	0x41b2fd71, 0xcfcb8d2a, 0x73f2fd72, 0x0a7bfef0, 0xfcf04bef, 0xfcfcc353, 
	0x78aeb853, 0x16a45450, 0xa517f108, 0x93d44730, 0x69fd04b0, 0xfbbd60be, 
	0x67401a8e, 0xdb4fbd15, 0x70efde81, 0x5df2853a, 0x9ffc1f98, 0xe31578f8, 
	0x5052cefb, 0x02ff507c, 0xef81587d, 0x1d7baf61, 0x68353cf5, 0xf362bd92, 
	0xe7d60a1a, 0xc72eeb3b, 0xafe8b4fd, 0x1045fb5e, 0xbd28b8e9, 0xcb2d08eb, 
	0xa0cf0810, 0xe6ff1fe4, 0xf007fa70, 0x61915b7f, 0xed6e9026, 0x11bcc25d, 
	0x894f2d9a, 0x20fa76a3, 0xbf140674, 0x84f58c68, 0x343e11a6, 0xb6887f49, 
	0x303df586, 0x43aae8c7, 0x97802a6f, 0xa74d78a6, 0x42fa0352, 0x8cec9c3c, 
	0xce9af3e1, 0xc3823ef6, 0x1a6e13d4, 0x506bea7f, 0xd9e91c06, 0xc429d8ff, 
	0x3fabd0a9, 0xda76b947, 0x804eae2f, 0xa275bb70, 0xe9b0bd20, 0x22739dda, 
	0x2bfa427e, 0x9c918e34, 0x77e2748d, 0xf758ed9b, 0xa4768c7b, 0x4f57ff34, 
	0xba5db3b4, 0x89e51fbf, 0x0d29abff, 0xf04d81eb, 0xc8a0f41c, 0x63b4770b, 
	0x9be37eff, 0xd8720e9a, 0xaa682db7, 0xb722ef00, 0x14f48dd8, 0x2eb43328, 
	0x6d98a798, 0x1d117654, 0x409d2b06, 0xf5957ec7, 0x2f081d31, 0xef90fb08, 
	0xfb434244, 0x9131d602, 0x893d22e9, 0x27c4a9e4, 0xe7286dc9, 0x7ca31d00, 
	0x0309b62e, 0x10079ff5, 0x56ec619f, 0x1fc4144c, 0xd2a1cb0a, 0xebd644f8, 
	0x552e4b74, 0x3d105e21, 0xd5bfdb26, 0xa5869fac, 0xcc2f1f3c, 0x36ebe157, 
	0x9e416e29, 0xa0fe810f, 0x81ff783a, 0x544bd57a, 0xe63f498a, 0xd641a4fa, 
	0xe59f26f3, 0xe61e4ef9, 0xb3c90a72, 0xf4829898, 0x36d1d9e2, 0xe523dc45, 
	0xa8bdc009, 0x2f24ece8, 0x5284bbd4, 0xfc4d3e99, 0xdbfa8d59, 0x056cf344, 
	0x5afabdc1, 0x5ca1d44d, 0x803d7e06, 0x5086a47c, 0x75c02dde, 0x0adf68c7, 
	0x07587b61, 0x83ec07d1, 0xe2378885, 0x8a371873, 0xed12777c, 0xed1502ea, 
	0x608dc5f7, 0x76a1efbf, 0xd88fbf64, 0xc18207d3, 0xf4ff878e, 0x3d967476, 
	0x3d3db1ad, 0xda7b4559, 0xf7e8357d, 0x707e98eb, 0xc5dbf05f, 0x6575efd2, 
	0xe2e884e8, 0xc427a609, 0x164f45ab, 0xfcfb58dd, 0x8b37091c, 0x41ba2c4e, 
	0xfff6a47a, 0xbe8dd39f, 0xaa792558, 0x5f373e4f, 0x7a657ac1, 0xed2665fe, 
	0x2ed0471b, 0x4dbee273, 0x4850a5fa, 0x4e11abff, 0x6baa7aff, 0xa7294eb4, 
	0x51bfaac4, 0x73499d71, 0xf873af02, 0xbfdf1545, 0xeb82b738, 0x12b270b6, 
	0xb1575eda, 0x5c7dc556, 0x65ab892d, 0x20974bd8, 0x0d87a179, 0x3d0de705, 
	0xcf1f28aa, 0x8cbc9654, 0xc5bf0b75, 0x009fecc5, 0x57fc8b7d, 0xc784c781, 
	0x3ff1780f, 0x907ebc26, 0xd0c5a267, 0x794f41ba, 0x6283ca57, 0xf44d43b0, 
	0x488d7923, 0xf0bdf002, 0x622fc25b, 0xd1f7dfdc, 0x4ad4d3be, 0x58d7e61d, 
	0x5a2dd47f, 0x29599ca1, 0x16f7d834, 0xffd3ba1a, 0xa0e710b6, 0xa7e8029f, 
	0x409f5ecb, 0x1c740aba, 0xfe82ef69, 0x35fa3302, 0x87022827, 0xf8739c71, 
	0x0ed12ebe, 0x3a8808f0, 0x001f670d, 0xdefa8f49, 0xb27ff842, 0x2fff3338, 
	0x58a76ca9, 0x248cd0e5, 0x67e43dd9, 0x33fdfe83, 0xb5df8ea1, 0xd1054502, 
	0x3362d10f, 0x8dff41f7, 0x2de3e269, 0x40aac3b0, 0xd2bbdd77, 0xd45e401a, 
	0xa67b2c4f, 0x4f4660f5, 0xe15fbfc0, 0x9a0d3a7c, 0xe4113a8f, 0xbe6fec2f, 
	0xa3fd02af, 0x5c0274fc, 0xeb0c909b, 0x7d6f2882, 0x0c3fa06d, 0x0b53f108, 
	0x4b533e5e, 0x50bc3ce0, 0x300ecd82, 0x214fda75, 0x1cfec739, 0xd03f0bf7, 
	0x8e23fa27, 0xb40f7b40, 0x4fb15bff, 0x7b45bf15, 0x64ddb9d8, 0x214907fd, 
	0xa90b1f63, 0x7dd5e50f, 0xa6fb5f00, 0xbeebb78b, 0x1a97e615, 0xec5f276d, 
	0xec0f22bb, 0xfd5df03f, 0xe8f3e0b6, 0xd6dfa96f, 0x49ca8ed2, 0xe920a6fd, 
	0xa03ec535, 0x7c013013, 0x1fba2f20, 0x386b7a84, 0xc63b3ce9, 0x6f512873, 
	0xfd8d6d2d, 0xdef80bb9, 0x5a7f6568, 0x36edf0f1, 0xce0feba4, 0x926613cf, 
	0x2e7e80f1, 0x2d86dddf, 0x8dc42fd1, 0x7d2c2e92, 0x8fd0ff0c, 0x06f0f440, 
	0x46be6902, 0x7a01a870, 0xd6789419, 0xc412b9f0, 0x22e90e7d, 0x2ee6fb08, 
	0x33b6a854, 0x4c42a47d, 0x4fd44117, 0x7b66aa97, 0x05ffc231, 0xd23f23e2, 
	0xc1b3ac2b, 0xd06e6229, 0x30efba37, 0x1f9f4843, 0x888d2f15, 0x012fb797, 
	0x89fbb32f, 0xddef414e, 0x3f9eb22e, 0xe77df389, 0x745bdfe2, 0x17e2b7f6, 
	0x6f497f3c, 0xf3676744, 0xfff5dde6, 0x752e9e9e, 0x2aec40de, 0x3e91ddfa, 
	0x69f07bda, 0xbc827150, 0xf7294dd3, 0x0b8a35ed, 0x259bc7f6, 0x77d59bfe, 
	0xbe2c3f89, 0x7c00de2d, 0x9edf2428, 0x89227ea4, 0xd1e5a363, 0xb63ef86e, 
	0xc4f7c33d, 0x3ce4fbef, 0x01bc8e80, 0x4ffc4691, 0x624fd8d3, 0x783783d1, 
	0xc75aeb4e, 0x5cf80a65, 0xa234a50d, 0xafaf294b, 0x10d3e098, 0x8f1d96de, 
	0xf78ed1ef, 0x206e7cde, 0x274b8eb8, 0x5c01177c, 0x4626d83c, 0xc46bbcfe, 
	0x027b2df7, 0x55489fed, 0xf00dfbde, 0xbdeb387e, 0x360f10d7, 0x54dd73c0, 
	0xbde9361f, 0xe1b90768, 0x3ec4295d, 0x60a7e798, 0x538d9fde, 0xfde702bf, 
	0x9a3ae4df, 0xfa037855, 0x3a50d886, 0x6ddf843f, 0xd4a8270c, 0x576c7bf9, 
	0xf45eb598, 0xbed3754b, 0xc375d664, 0x26d26e3a, 0xf7802e69, 0x961efb56, 
	0xe218a063, 0x153c8077, 0x89ef85f7, 0x0eeb9aa9, 0x00509e21, 0x56b72872, 
	0x27cd0b9a, 0x3dd3f232, 0xfe83e797, 0x3893beb2, 0x99f698ef, 0x96a708e3, 
	0x4f821a81, 0x0067c17c, 0xa3cc1a3e, 0x9e1e6b34, 0xf0f112ea, 0xfe97963a, 
	0xef791919, 0x441eba46, 0x7b141959, 0xeda19c61, 0xf837de30, 0xf76be47b, 
	0x68ed43ca, 0x4737fb57, 0x62e58a16, 0xf0b7aec4, 0x1f17fb7b, 0x4bff40ed, 
	0xc111d831, 0x0046680d, 0xf85ea0de, 0xfa2489c8, 0xf6359a63, 0xcd7404bf, 
	0x7b441c9d, 0x413a2c3c, 0xff3c8f8f, 0x3dea3f56, 0x92fa6bee, 0xb605d7a8, 
	0x008fee1e, 0xeb94071c, 0x55c61d35, 0x7ed13e6f, 0xbee38c15, 0x6dc55871, 
	0xf401d693, 0xc27ec6e9, 0xf6498e38, 0x8dd24799, 0x09a13a1a, 0x86710f39, 
	0xff61a0e0, 0xdfdb4c6f, 0xb9e3f481, 0x7481d53e, 0xd8395ee6, 0xe359e38f, 
	0xd21c3778, 0x3c887f50, 0xf700753f, 0x8247c2f1, 0x73af3ced, 0x2fe7da49, 
	0x2e1bc788, 0x12f5c782, 0x3b81008f, 0xf83dbe3e, 0xa6bfed25, 0x3d42e83d, 
	0x95f12373, 0xe68939da, 0x02917a47, 0xf5c3665c, 0x43de7ec2, 0x8cf7e875, 
	0xf0630fb4, 0x669d35bc, 0xcff20838, 0xe4a59cdb, 0x73c310a7, 0xf6b4aec9, 
	0x6162a02d, 0xb73d469e, 0xa49ed854, 0xef580bfe, 0x06c76915, 0xebc147c2, 
	0x3df0591d, 0xd409d220, 0x47d34af3, 0x9c639db0, 0xbf3f4091, 0xc44c2ecb, 
	0x4ff7458f, 0x584fac6a, 0x7cfcec65, 0xbae8f115, 0x6afe214f, 0xe05fd55e, 
	0x55fb475c, 0xfef303d8, 0x0057687b, 0xeb96e4fc, 0xa3cfe185, 0xe396e93e, 
	0x708a97d6, 0xe3ca1561, 0xed15c120, 0x3d0f735e, 0xcd38a41f, 0x3d900ed7, 
	0x8c2ebe82, 0x987cd07f, 0xaf9a541e, 0xeb3da853, 0x9f40bf64, 0x0abb830d, 
	0x8d60e1b2, 0xda1c6f5b, 0x5e6985a8, 0x720d9487, 0xe664efdc, 0x0b0d10d1, 
	0x1e7a3c35, 0xa01aadb7, 0x67cd1d38, 0x38f9e8c3, 0x4e81eb05, 0xe4105d23, 
	0x9e089f75, 0x3f20f9e1, 0x807b3ce3, 0xfc931e0e, 0xfcbf42ec, 0xc0f05943, 
	0xb18f77f9, 0xeb6f9c7e, 0x78593868, 0x8a7c10b8, 0x3e715b77, 0xf6c12eb3, 
	0x740f8a04, 0xb6e3f438, 0x91f488a8, 0x5e69337f, 0xf45da3e1, 0x9412fc3e, 
	0x82308033, 0x84f9e9db, 0x09f3f31f, 0x1ba963af, 0xd8a137c9, 0x9de801fa, 
	0xc7ec3f1c, 0xc9eae578, 0x45bd0750, 0x82391c73, 0xf78d9365, 0xfcb285c5, 
	0xd6e5cea6, 0x9b771cdd, 0xaf3221bd, 0x3794026b, 0xfd56b970, 0x7805e6a5, 
	0x2c2db56c, 0xeec8844f, 0xfa063f6a, 0x3d5d16d5, 0xd2a4dfb6, 0xe6986fbe, 
	0x3c02ea93, 0x78dcbe9e, 0x7a252cd4, 0x3cc04f2b, 0x9bbd94b6, 0x54f0e644, 
	0xfa0fa41a, 0x32798bb6, 0xdc61a1be, 0x7efb92c6, 0x6125a9a7, 0xf482dae3, 
	0xc2f47009, 0x6f93847b, 0x789e647b, 0x6313fe19, 0xe996d4bf, 0xf3a6c88a, 
	0xb5f18d98, 0xdd67ae4c, 0xa8e505f2, 0x304279cf, 0x01bf7e1e, 0x2fe2b3c6, 
	0xc3bc564a, 0x2ebc7829, 0xf03c0bd6, 0xf583c69e, 0xeb03ef67, 0x6724cd5c, 
	0xb57ecc5b, 0x8db8e506, 0x66e59df7, 0x0dda395d, 0xf05f6e9b, 0xc028e874, 
	0x5dbc2fcb, 0x4fc6ffd0, 0x5f70063b, 0x7abf75b8, 0xd7d600b6, 0x2114f4e2, 
	0x9b38b65d, 0x98fc71cb, 0x663b20df, 0x14b453ab, 0x0cfc5d03, 0x51c573fa, 
	0xef25893f, 0x1b16a101, 0xae073a07, 0x929bc6f3, 0xb26c6fd8, 0x7e829c98, 
	0xc1e37662, 0x0fefde01, 0x74682463, 0x356df99d, 0xfe80dfc6, 0x2e7fce3c, 
	0xb72df9c3, 0xfe834c83, 0x22cd3857, 0xb705bf84, 0xa246f6ad, 0x5f682d93, 
	0x151d1254, 0xfee3a3be, 0xeb87da90, 0x80e77a5d, 0xd639075b, 0xdb9ccf01, 
	0xdbebdda0, 0xb3a73f0a, 0x03b9423c, 0x38c76e78, 0xc76cafb4, 0xbc6f14a3, 
	0x0fd97552, 0xecfcdea1, 0xe853e607, 0x203f309f, 0xd24637bf, 0xdd06dfe0, 
	0xd0f6805e, 0x1df06996, 0x03da11e1, 0xc55a2cdf, 0x33d5d5f1, 0x6d57df79, 
	0x5a7d976c, 0xabbebc67, 0x5d5afcb3, 0x7ab9f4cc, 0x52cdf312, 0x2c82dfe0, 
	0xf3d86b3e, 0xf9f223fd, 0x8ddf3e20, 0x7cefc16b, 0x9d41ddfc, 0x71a596f5, 
	0x01f10ab5, 0xf01a1270, 0xee5fecff, 0x5e80502c, 0x51d6b496, 0x6741adfc, 
	0xfbda393f, 0x85510fd2, 0xb4263bf2, 0x199fe449, 0x3c342789, 0x96d68a8a, 
	0x4f7c5645, 0x2d9ff084, 0x2078ad73, 0xccb6fbc7, 0x0d88eab2, 0x64eac7a8, 
	0xef84337b, 0x6ffc649b, 0x24c1739d, 0xd96dcbf4, 0xc9ef5869, 0x53febcaf, 
	0x80aa4dcf, 0x3d3e1be7, 0x94157267, 0x6e7bcf37, 0xaf2874f2, 0x1c80f843, 
	0x67365d68, 0x6fa84cca, 0x29b9f1ba, 0xb4f4a173, 0x0280544e, 0xb03ce846, 
	0xd3a26ae9, 0xf5c7062d, 0x79eb1b14, 0xf54c5f8d, 0xe02f5c63, 0xd14d1e36, 
	0x17ae397a, 0xe273a770, 0xe243ff7a, 0xf60bba21, 0xfe4e7e25, 0x8e31c590, 
	0x8d8434db, 0x64db8c02, 0xe11da5c1, 0xa559bd12, 0x51bd833c, 0x2c5cf38e, 
	0x85a8b38e, 0x440f38e3, 0x08b2ee39, 0xf341d3e0, 0xffb2574a, 0x36e3c3e5, 
	0x2e3245be, 0xbe2ee323, 0x236e32b9, 0x4b37d8f9, 0xfdf2c3d6, 0x2f6e36ce, 
	0xd8be36e3, 0x70b7ae4e, 0x70ba279c, 0x563129db, 0x32e3069c, 0xd373c006, 
	0x2d338e3e, 0xd429fa7c, 0xd6a1a21f, 0xe75fa39f, 0x0f280d26, 0x555f21f4, 
	0xd6133ce5, 0x017dc11d, 0x75b4bbf0, 0x8c2da762, 0x8ed0876a, 0x2a637ed1, 
	0xe55fb8c7, 0xca8bef18, 0x1667e831, 0xbe5037b4, 0xc2ce4107, 0xb3f47af3, 
	0xa07f65a4, 0x92488ab7, 0xfe2739fc, 0xcef6cc2e, 0xf7f211e0, 0x5af7fdb4, 
	0x0360fd21, 0x7f197589, 0x401575d1, 0x4bcfa8f9, 0x341a8fbf, 0x7d77d454, 
	0xc979b59b, 0xfa5f8827, 0x9d8ca194, 0x81e805bc, 0xcf66f4e4, 0x7037e4bc, 
	0xcfe475fe, 0x58a779c3, 0xec52543f, 0xdf78521f, 0xe7682b4c, 0x889d2444, 
	0xf99cf696, 0x6332883d, 0x6cf398fb, 0xf2bf4137, 0x28bc263d, 0xf52e7e07, 
	0x72ce9f71, 0x3638b560, 0xf388552e, 0xf38a3d88, 0x3d5eb2dd, 0xa126e323, 
	0x62ccb8ec, 0x1c5d2719, 0x3d442feb, 0xb24b517d, 0xa2a4e390, 0xdf8be710, 
	0xcedcbd63, 0xf182dbf3, 0x014f9016, 0x2de29a4f, 0x17ac0f01, 0x9a76b2f9, 
	0x691e79c9, 0xbcfa938a, 0x1d947e33, 0x0394094f, 0xd6bec3fd, 0xf8a49350, 
	0x51b0c364, 0x8957139e, 0x4ab8cad5, 0x64e910b0, 0x40aeb84b, 0x6a193a07, 
	0x8ab8e5a9, 0xce2e1f8c, 0xc2dca78f, 0xfcf91cf9, 0x22edacb5, 0xfea5f5fc, 
	0xe42fe50f, 0xfd8fee6b, 0xb6fcf9a3, 0x86fcce34, 0xb5f48efc, 0xf93fe414, 
	0x1697a357, 0xfcd8ff4f, 0x2df926d6, 0xb099e56e, 0x8e3f35bf, 0x5275fc4e, 
	0xde71dbf2, 0x604fd08f, 0x8fc5a7f1, 0xda29ff16, 0xc98ebabb, 0x8bf6294d, 
	0xd707c3a2, 0x46ccfb4f, 0x2845e392, 0x7c95d767, 0xa369c8b1, 0xa0a289fc, 
	0x8a27f28d, 0xd9f4a14b, 0xd2deae58, 0x30e2c7f8, 0xb2d37ffc, 0x6155c6e7, 
	0xe7240d3b, 0x2054085f, 0xb10712eb, 0xd8153b0e, 0x9cc0b147, 0x7246dd22, 
	0x236bc8ba, 0x645c5d39, 0x5c5d3923, 0x4cf92361, 0x6fe35bdf, 0x871f696a, 
	0x9dfb5be3, 0xe4f97fb5, 0xea5e77be, 0xa0693763, 0x8d3bfc69, 0x14f1c497, 
	0x59cb642d, 0x175e22d7, 0xb8a5c3ed, 0xbb7dff0f, 0x0a3d01e8, 0xbbc057f7, 
	0xf5d252bf, 0xd21ff445, 0x2ed8527b, 0xfd21ef57, 0x34fb842d, 0x1e7633cf, 
	0xccdec7f4, 0x7a971f7c, 0x193643d7, 0x713ad9f7, 0xe502789e, 0x52f511c0, 
	0xdca945e4, 0xe00e50bf, 0x693b9273, 0x2cd4cfd9, 0x8e7e11b9, 0xc77fd7fd, 
	0xfd8e2d74, 0xbf6fea9c, 0x5ff5a2e9, 0x659d6f58, 0x007fa2f3, 0xd293b0ed, 
	0xda437b7e, 0xf696bf6d, 0xe51be61a, 0xfd9663d9, 0xfa8e2986, 0x94fdf1d7, 
	0x0dad7b5c, 0xfb1cafec, 0x1b0ed72c, 0xe272a7b2, 0x64d68a82, 0x85977fd3, 
	0xa7e93ab7, 0x77e3b807, 0x38173bee, 0xb4555f51, 0xe81d3665, 0xe6a773da, 
	0x6cf43e46, 0x0d66bcd7, 0x3be0ab94, 0xb65e7f94, 0x49b25edb, 0xc9ca46bd, 
	0x0b4eb316, 0x3655fbc2, 0xe35f93f6, 0x8f08ab4d, 0x34eaabe5, 0x7796efb4, 
	0x16577bc1, 0xf767c19d, 0xf33d251c, 0x57a03df0, 0xff6c6efa, 0xe913509b, 
	0xbfa83599, 0x65d35afa, 0x47a457c8, 0x877cc99e, 0x4f9812f8, 0x15f40657, 
	0xdd5eb8bc, 0xb2f011b0, 0xb57ac2fe, 0x68759a70, 0x831ac20f, 0x63ce3045, 
	0x5b9a9e92, 0x13c7d234, 0xf6810ace, 0xb7343b76, 0x53bac49f, 0xf8073ed8, 
	0xe8007b45, 0x5ac2f66c, 0x7de15fda, 0xdaf00eda, 0x0aa614ed, 0x800ee276, 
	0xa21df079, 0x53c441ab, 0xe369e242, 0xa013c355, 0x314eb10b, 0x4f5525ff, 
	0x83eeba7a, 0x3aeeb797, 0xd420c3f5, 0xdc54036f, 0xadb8eb0f, 0x3e5e3c4b, 
	0xc3db899c, 0xff04369f, 0x485950d9, 0x5adb937e, 0x4d226816, 0xca1d66f6, 
	0xfd53ef25, 0xfe301d33, 0x369ddf35, 0xade564a0, 0xfca81ef9, 0xb27ab297, 
	0x42f7420b, 0xef1feb67, 0x69fa01ff, 0xfabafa6e, 0xd38e117a, 0x39421032, 
	0xfb3f1f9e, 0x9b7ee557, 0x26f0971e, 0xc501687f, 0x826630a5, 0x9fc3b37a, 
	0xa1fd104e, 0x748122bf, 0x5c8e50f3, 0x2e591a30, 0x13291f20, 0xe2d97832, 
	0x6e31ca35, 0xd9fadbed, 0x4cd4ca79, 0xdfd05bff, 0x979f1674, 0x7b4573d3, 
	0x45bfb73c, 0x921dfe32, 0xf045dbf6, 0xe58a6b7e, 0x3ef085dc, 0x233fda5b, 
	0xcb3b24f1, 0xe59d80bb, 0x9fb906c8, 0x0af60adf, 0x7f68a5ea, 0x7cdbbe51, 
	0x7d620d55, 0xfa395d7e, 0x7ed6bd37, 0xfda9551e, 0xab3fe772, 0x056fd768, 
	0xc2ae2896, 0x1051737a, 0xcec3a1e4, 0xd823d572, 0xf9e58ffe, 0x2e393449, 
	0x71187826, 0x505fffd4, 0x6a688ed1, 0xa32b3c05, 0x6e446de9, 0xd8a7b009, 
	0x9d71a88e, 0x8fdd3921, 0x2ebebc79, 0x84bc48a3, 0xfc4e3c78, 0x21f9f16c, 
	0x3e06f54c, 0xe80d38db, 0xfe067c68, 0xbe4cd78a, 0xa27c4a6d, 0x7cc45e9e, 
	0x114aa5be, 0xbf9e60fb, 0x16fafa93, 0x2ddeed9d, 0xdfed7333, 0x4a6f9253, 
	0xf001bee5, 0xb7fec72a, 0x1e22f5c8, 0xd4079883, 0x76c478c4, 0xda2a6f68, 
	0x2cce88cf, 0xaded5878, 0x5da04b7e, 0xf625ce34, 0x72a768ab, 0xe51d22e8, 
	0x23de48fe, 0xcebb4b9f, 0xf7e419b7, 0xef3f4c84, 0x9edabca2, 0xfbc257ad, 
	0x7abb486f, 0x1a23c93c, 0xe395a5b7, 0x06f2d95a, 0x986586f1, 0x8e5dffc6, 
	0x31374d1c, 0x397ec79d, 0xbe93fc9f, 0x5db3c4a2, 0xa3a704f5, 0x7e1026f7, 
	0x63ee77f3, 0xf68d38fb, 0xa647ee31, 0x9f49bbd4, 0xf697b55f, 0x7dac5791, 
	0xaa03fd25, 0x40986b8f, 0x07fd91f5, 0x4dd7adf6, 0x2aafa231, 0x0b1f669a, 
	0x2d3e160e, 0x2716ae78, 0x89bb1dc6, 0x5525fced, 0x9df8e799, 0x77ee5771, 
	0xaf3eb44d, 0x9032a75d, 0x90b9bfd3, 0x1bf88ddb, 0x50f5fe30, 0xbf16af06, 
	0x08fd0b7f, 0x5db17df4, 0xda96fc27, 0x1483d2c7, 0xb9e73cad, 0x8fdad0b1, 
	0xa7c22144, 0xc9f38da1, 0xd93e641a, 0xf3b1b6e2, 0x2e4ec0c9, 0xc9f264f8, 
	0xf94eccfe, 0xac9f320d, 0xf9493aa1, 0x9dbe9664, 0x50d6479f, 0xaf7a4753, 
	0x096f7fa5, 0x0e7f94ab, 0xe3205414, 0x83d221f4, 0xbcb1bcad, 0x9845b2fc, 
	0x4bfb062f, 0x7da1e603, 0x0caf2b2e, 0x2b9473f4, 0x6cbafa23, 0x66479f9f, 
	0x67c671c7, 0x58c749e5, 0xd7c86faf, 0x7acd3feb, 0xd526d0fd, 0xc82b13ca, 
	0x08965bb6, 0x695b27ce, 0x6364f997, 0x27cecbb4, 0x490ff683, 0x6c955e7a, 
	0xb4ae3c47, 0x9215e8e7, 0x923c2c1f, 0xe31c74dd, 0xb26fea2b, 0xc92f93f3, 
	0x784939fe, 0xf3efc428, 0x2d45a0ed, 0x376485fd, 0x1fa27e20, 0x67fa1edf, 
	0xb21767c9, 0x8eed148b, 0x5a887e5c, 0x973dbc74, 0xef9e478e, 0x06cfe5c8, 
	0x45e96e7e, 0x9fd6765d, 0x5ceeed14, 0xbd3235f8, 0xdcaeda28, 0x79eb51e7, 
	0x8d1e7732, 0x73bb78d6, 0xf847a7da, 0x1e772bac, 0x124dffb2, 0xfb9cd7ef, 
	0x966762a7, 0x9d97795e, 0x5436b7f5, 0x9c61cf3c, 0x718ec7b0, 0x84f07b42, 
	0xcd21ed26, 0x42f1ce3c, 0x1fad8fe4, 0xf9412508, 0x7e8a861f, 0x8cae7d5e, 
	0x1f61040f, 0xad7f46e9, 0x96d7fa42, 0x74e82d56, 0xcc59bfa1, 0x5f77decf, 
	0x57defb94, 0xa3a8fee4, 0xf31679be, 0x7caf5850, 0xe1cf9e0a, 0x6f3c6ee7, 
	0xf7fcc0e4, 0x8a5c536f, 0x2abd33f6, 0x45cd22ac, 0x08eb7f9e, 0x7bf093c5, 
	0xd3daa768, 0x1812dfed, 0x8eca7a7f, 0xdaf39ffb, 0x5ee30d36, 0xb1eb088e, 
	0x638e390e, 0xeb838f25, 0xf2f00678, 0x396f1853, 0x9f81b78e, 0x14c3837b, 
	0x6ee2b367, 0x0d31b98e, 0x5e2b7bed, 0xef3953fa, 0x4ffc262b, 0x9161da3b, 
	0x5f90a122, 0x81ebfa15, 0x59db0efe, 0x386bea1e, 0x9d82f96e, 0x552225f3, 
	0xc1feedb9, 0x1dc7276a, 0x76e5e769, 0x2b549708, 0xa6fb878f, 0xe86f379e, 
	0x87a6795f, 0x7be0b7df, 0x75878f2f, 0xab36af8c, 0xde39da2f, 0xff3c142b, 
	0x8c69f181, 0x605fe9c7, 0xa57e5978, 0xe7c07ed3, 0x54329231, 0xe6bb7fbf, 
	0x34fbd3b4, 0xe62aedd9, 0x235f9137, 0x75503f37, 0xdb1e7398, 0x9a1d9f8b, 
	0xbcc7527d, 0xdc129fc0, 0x8e5d3385, 0x1bca207e, 0xdfdd7804, 0xf5073f5a, 
	0xd5df9855, 0xa13ca768, 0x46e08cfc, 0xbd2c98f1, 0x726ec875, 0xc7e4429c, 
	0xa7190c29, 0x69bff588, 0x57f56bd2, 0x7fc99a54, 0xc1ff7f83, 0xd50971c1, 
	0xe7e42469, 0x32ba6795, 0x978008f1, 0x9f3a0096, 0xdbfe60ea, 0xb471e92a, 
	0x3b6bf6dd, 0x6d5b6dda, 0xf8c7bd3a, 0xdf7e3763, 0x06e828e1, 0x60ee5421, 
	0x82ba813e, 0x72fa7cfc, 0xfe614891, 0xed55d96b, 0x3a55efa8, 0xe7622e98, 
	0x57ed0515, 0x61f188bd, 0x75ad2fc5, 0x6f583856, 0x84639afa, 0x6f0803fe, 
	0x507d960f, 0x7ba763d7, 0x0ef8e3e7, 0xad95e181, 0xfbdb5536, 0x1251c63c, 
	0xf73b774a, 0x07b8e29b, 0x59ff21fd, 0x2f6e16f5, 0x3cf8caf6, 0x02bd41ca, 
	0xbc564f64, 0xa5c82b7e, 0x87f5f79c, 0xfe82f6ce, 0xdc4fbb72, 0xc70270f3, 
	0xdef4e5bd, 0x95cfd4a3, 0xae38137b, 0x3efdeca2, 0xeea29f3e, 0x05fbfea5, 
	0xc09d67cf, 0xf6e8cbb8, 0x9fda5ff3, 0xa17c7f95, 0x21efbd7c, 0x5b8e2944, 
	0x6c37a541, 0xd9664bce, 0x245bba0d, 0x86f36f50, 0xa725e6bb, 0xfffb1c22, 
	0x6a7bc651, 0x7032d7ee, 0x49743c45, 0x187b383c, 0x3c1cc14f, 0xbba0fa1c, 
	0x729fdb01, 0xd097f3dc, 0x1f9c565f, 0x076804fd, 0xf68f7ea3, 0x078c83ef, 
	0xf0f00a6f, 0x451f8973, 0xe5038cfb, 0xd70f65a9, 0xe410dfa3, 0x4bccbd48, 
	0xf6a98610, 0x0712f3c0, 0x574469f3, 0x43f14b95, 0x85fec894, 0xffd23bf8, 
	0x9bacffde, 0xf80ba1f5, 0x57fb472b, 0xdfc41c1b, 0x7ad5fe79, 0x60dfd7d4, 
	0xebefc13e, 0x6fb1343b, 0x93dfc523, 0xacf1ffe8, 0x69152709, 0x8fd8d8af, 
	0x3b9f20a0, 0x3147129f, 0x077af83f, 0x7d238f9f, 0x0f9e1d75, 0x309c57ea, 
	0x9367b5ff, 0x7139c50a, 0xfaccb1fd, 0x09da3db1, 0xe7142740, 0x9bae4ef3, 
	0x04780bd7, 0x20afb79b, 0xfe8bbfcb, 0xdf1054e4, 0x3bd79a2f, 0x6805cf15, 
	0x1a70ef14, 0xe5e70aa2, 0xcaadaab8, 0xa2f7eb09, 0xfa1c71bf, 0x6e746d1b, 
	0xc8937ea2, 0x3f549739, 0x39c4e457, 0xbc8d67ea, 0x5d5ea857, 0x7ca7bd67, 
	0x738c9f3c, 0x8d00c4c4, 0xf2375f53, 0xeb22e29e, 0x2a4ce64a, 0x1c7f46ea, 
	0x5e363bc7, 0x55726735, 0x9ee1fa37, 0xca1d3c9b, 0xbbb60e1d, 0xce76bd6e, 
	0xbf509994, 0xef1916ed, 0x639ee708, 0x2886568a, 0x08deaf9f, 0xd8785d92, 
	0xb1dcf2c5, 0x1511c560, 0xeb8a21e8, 0xf14bb967, 0x66f7a80d, 0x48ce3bc7, 
	0x32ee707a, 0xfa4f5f39, 0xd9aa1b63, 0x9b0feb1f, 0xb363fa1a, 0xe74ed3e0, 
	0x2bacae91, 0x6f683d40, 0xe292f06b, 0x8336811d, 0x35ad1de3, 0x0008ef14, 
	0xbc4a3e9c, 0x9229bbc3, 0x3bc93e73, 0x7fe39237, 0xf592cef5, 0xc9d7acb0, 
	0x5cf22973, 0xd65ab79f, 0xeaae38db, 0x331f185c, 0xfe97e1de, 0x3e4afad5, 
	0xd85ce357, 0x670ef147, 0xf465faa8, 0x3b968eb7, 0x807f9e47, 0xc91743e5, 
	0xd05fe949, 0xa473bfa5, 0xd8ed907c, 0xfc7dca3f, 0xc2302706, 0xb0478a39, 
	0xed9f7e3c, 0xb5cf5d60, 0x64ef3f77, 0x6ca57db9, 0x221f8de7, 0xedc9073f, 
	0x539d0cd6, 0xadca1b3e, 0x35f91f78, 0x5403e1bc, 0xae9db2ea, 0x8f7b0787, 
	0x859f7c92, 0x4b6adef3, 0x036f6afe, 0xf70bffcd, 0x7e61fbbe, 0xda0e23c5, 
	0x0d0eec9f, 0xe5179ae5, 0x3bf7315f, 0x4b11f90e, 0xb88f5b90, 0x8ba15ea4, 
	0xe52bdfdf, 0xf719c230, 0x7dbcae8d, 0x4d87aac3, 0x1fefe382, 0x1ae3cac8, 
	0x7dc8df63, 0xbc583f5f, 0x8df689af, 0x84e87a1b, 0x6e7391a0, 0x8d878d41, 
	0x2f3a3101, 0x02fcff25, 0x7f8889ea, 0x68e73c87, 0x779475e9, 0xb9f51c74, 
	0x08af48b7, 0x47694c47, 0x70ea3eb3, 0xbdf50d08, 0x440cf0b7, 0xc28df31c, 
	0x7ea5ce74, 0x7d9338a7, 0x1e2471ce, 0x879dfe89, 0x3a4dfe90, 0x1b8fe6d7, 
	0x837fca21, 0x798fd0ef, 0xbd6fc497, 0xf513173c, 0x0f905788, 0x3173a4a1, 
	0xd2d5b5f5, 0x74af114e, 0x45d0cc1d, 0x55e61cb4, 0x695ff98a, 0x1fe84f3a, 
	0x941d0516, 0x37f9c477, 0x68b7c0f5, 0x33bd787f, 0x67b6ce5e, 0x708dec46, 
	0x14573cad, 0x43ba73a4, 0xefb6116d, 0x1ea2bc64, 0xb35b93ed, 0xfb014fda, 
	0x13968c44, 0x222e5a8b, 0x7b61ae27, 0x027242e9, 0x37f713e5, 0x29a6dc76, 
	0x941b71ca, 0x6f2fe85b, 0x49c50612, 0xff848e49, 0x8b46e413, 0x256b47ac, 
	0xb71d8e45, 0x52713921, 0x19e38dca, 0x93c962f9, 0xde1f954b, 0xbff231c9, 
	0xf047d28d, 0xe7dc54f9, 0xe7da4b95, 0x2223392d, 0xb75f6807, 0x730379f6, 
	0x393e28cd, 0x3d63cf48, 0xefd9cd9f, 0x798d93bd, 0x47e398ea, 0x1f18a9e7, 
	0x6d1f10ed, 0xc647eafc, 0x7ff87f1e, 0x9755f3d3, 0x61feb195, 0x443e1f8d, 
	0xfad1c77e, 0x078a21d8, 0x1ff1f47f, 0x4673d1cd, 0xd1af17c6, 0x1436b3f8, 
	0xcbaf8ce7, 0x615e8338, 0xf41ea96a, 0xe57eb2cb, 0x8b1db277, 0x20d66f72, 
	0x2059dfcb, 0xfe869ef7, 0x4b1b9fc6, 0x613faabe, 0x76dcaaf9, 0x7fcf10ff, 
	0xf3e2bc4c, 0x6b5e08ff, 0xd70d8e0e, 0xf3d0afb3, 0x94987fae, 0x7ec1c7ab, 
	0x119bfb4b, 0x5f977f22, 0x4602bbfa, 0x7ba4e899, 0x4fcff20f, 0xe91e53b6, 
	0xdd77f7c7, 0x317d44eb, 0x7baefe80, 0xf9f1fe50, 0xe57e4b49, 0x35fcbbfb, 
	0xbbfa0146, 0x1f56792c, 0xc93a0516, 0xe3269487, 0x39ce5a48, 0x577f3cc9, 
	0xf48f9e40, 0xe2bbfbe7, 0x44728e7c, 0xf90b89ce, 0xf41c60bb, 0xbf4b5577, 
	0xfae78c8d, 0x3b35fdf3, 0x4ac9f9e4, 0x2b958fcb, 0x21b4c1f7, 0x4bb2f97a, 
	0x68c6bbfa, 0xaaefed97, 0xbd2dc617, 0xe88c0724, 0xf7b20eee, 0x8929c4b4, 
	0xa54fd437, 0xc8f85d7e, 0xdbcc7689, 0xbafd4af1, 0xbb54eabe, 0x517ee2e2, 
	0x9f50066e, 0xa87ea41e, 0xa93066be, 0xdc7d1ea1, 0xdac9f6c9, 0xdf9475b3, 
	0x5b4faf95, 0xaf35b47a, 0xb0df52e3, 0x2877b04a, 0xfcc01ace, 0xbddfd009, 
	0x60f55765, 0x9a7eb5fc, 0xb798f8a0, 0x8afca54a, 0x5ca3f591, 0x72aefa47, 
	0xa5855e53, 0x58da0777, 0x0edff6ef, 0x0c6bb77a, 0x90857bbd, 0xed0640f9, 
	0x79f5f5ee, 0xade7f77a, 0x8eef52f7, 0xf005f75b, 0xea3754b9, 0xf4b31bdd, 
	0xef4b5aee, 0x781fc936, 0xdffbbd31, 0x7b979c9c, 0xd1bbbd31, 0x41a3bbd2, 
	0xbad7dfda, 0xce711ed8, 0x31bbbd61, 0x1c6eef4f, 0xf5804fb9, 0x80cbbc6e, 
	0xbcf12ef2, 0xef37d138, 0xc8b8fea7, 0xbf9e1f39, 0x34eeba9f, 0xded91ce9, 
	0x13fa0016, 0xea87ddf4, 0x0ade74dd, 0xd816eef5, 0x7f18632f, 0xde9a3e30, 
	0x79c222bd, 0x9bd6510b, 0xfb79f5bd, 0x7be5e7e7, 0x95acff6b, 0x07bca5fb, 
	0xe7971bc3, 0xbdf95bc1, 0x7ad8e96b, 0x4eff9d37, 0xd76ef467, 0xadbbd652, 
	0x51ffe073, 0x3f446f3d, 0xbdf634db, 0x7f193e03, 0xe7f120db, 0x0f9789b5, 
	0xd63e8c8b, 0xa0d87a88, 0x764c7f3c, 0x139d355c, 0x5fa4f46d, 0xe9456936, 
	0x2bcfb397, 0x0f4fbd7b, 0xf4b27ca0, 0xacf2c6ad, 0xf09a00fb, 0x73a0b27c, 
	0x000f74e1, 0x188f67f4, 0x911cf839, 0xb73e712f, 0x829c7a0c, 0xe52ecff2, 
	0xee6b50df, 0x7e8b65b9, 0x313d3e48, 0xfbac5e9a, 0xcafd2c27, 0x0c0df785, 
	0xc8a3ee66, 0xf97c9fa7, 0xa55f9d66, 0x989a077b, 0xc53f49ae, 0xd30406fb, 
	0xbe89d635, 0xa7a68d0e, 0x793f4c8f, 0xd3e409f7, 0x17f758d3, 0x598fa58c, 
	0x55d16674, 0xbb75ae01, 0x9293aba4, 0x7a4b8eae, 0x65f418fb, 0x247b59c9, 
	0xed57e744, 0x9f22afb8, 0x702eca45, 0xf2bb412f, 0xee91c4c9, 0xeabee174, 
	0x7b247193, 0x8dabef0d, 0xa8fc7cf2, 0x6c2208fb, 0x39fd1027, 0x74407da4, 
	0x38e45299, 0x91c587da, 0x648e327c, 0xbbf57dc7, 0x0d6afb59, 0x5d08e9d3, 
	0xabee0b8a, 0x867658ca, 0xb8cedf3d, 0xc676422a, 0xf825eec5, 0xef52eb9e, 
	0xcbb71025, 0x7dd0f57d, 0xfb57e81d, 0x17e28bb2, 0x1deb4822, 0xeaa73fb9, 
	0x8ef8fb02, 0x8eaaa1c3, 0x5ff2392c, 0x9d534ecc, 0xb217d74c, 0x6f662ed7, 
	0xdfb88e5c, 0x069efa36, 0xe31c5ffa, 0xce89470d, 0xa231e944, 0x00c78a73, 
	0xc7a6da1d, 0xf3632e28, 0x81aba21a, 0x7bbee4f8, 0xa8bf65ef, 0x6842e7b4, 
	0xa2038b2f, 0xcf21ce88, 0x27073865, 0x73a5d0fc, 0xecb8ff3e, 0xb2f41d7b, 
	0x8f6412ab, 0xd4228c47, 0xbd48966f, 0xe6a7f4e4, 0xdd613bb5, 0xb9c52bde, 
	0xb5a043ae, 0x638e38bb, 0x5736d7e1, 0x88a25fb0, 0x5e6c09f3, 0x017fdfd6, 
	0x3e81caed, 0x6a22f3ec, 0x5ff2fa10, 0x875e0bf6, 0xb3dd06f9, 0xf32cf6d1, 
	0x64f6f39b, 0x6a4b9e01, 0xd1c5b54a, 0x1eda6c9e, 0x6b1ca389, 0x0e7004da, 
	0xf68a39d3, 0x39d050d7, 0x660e74d3, 0x2046aa55, 0xc4377b7f, 0xd434e514, 
	0xe02e80e3, 0x8795d0a3, 0xd43f9c14, 0xe0fc9853, 0x1c70059b, 0xcc21faa4, 
	0x4efa6965, 0x9d241c5b, 0x96417a68, 0x23c70e27, 0x3a9e5035, 0x6477f5cc, 
	0x970cfedd, 0xacb8f7c1, 0xcfdf8f7c, 0xb285f594, 0x077d996c, 0xc4a1eb95, 
	0xbd65dbf7, 0x7753d653, 0xbbd5f971, 0x6477f9f8, 0x9e5905fd, 0x5c0ee678, 
	0x2826b3a7, 0xfe61d73a, 0x9ee74d47, 0xc6075e3e, 0x7dde606b, 0x95d0feb8, 
	0x6dfa10b1, 0xeb055ccf, 0x7759caeb, 0xdf05d71a, 0xf5013d93, 0x072fa213, 
	0xbdf8830e, 0x702373ef, 0x1ded8738, 0x2755bc72, 0xf1ecf5aa, 0x4a159c60, 
	0x6b09c702, 0xd847e882, 0xc2174812, 0x272e6798, 0x927f627a, 0xb397f50a, 
	0xdd5e7aea, 0x985ed79e, 0x0ce07539, 0x0ed9fd1d, 0x5e8c8f79, 0x445bcf2f, 
	0xa5f49f98, 0x93bf9cb5, 0xc706fde6, 0xfc7fb217, 0xcb17c71c, 0x5e7aeab3, 
	0x1ed79edd, 0x9faecfc6, 0xe3a35fd9, 0x1c7ecafa, 0xbeb029b3, 0xd211db32, 
	0x606ccb8b, 0xd9d7316f, 0x62b03ef1, 0x3e65fd3d, 0xf9f068ff, 0x4d530ed5, 
	0x545dde80, 0x098c142f, 0x82a67deb, 0x6bd9b0f7, 0x12ef04d2, 0x15f78a68, 
	0x2b0ef3ea, 0xfb77a061, 0xca5146e3, 0xe39b7e44, 0xbb963f46, 0x39411c4a, 
	0x1f8187a4, 0x05bde20f, 0x07af4760, 0xd15a2fbc, 0x9d487a8e, 0x7dc6fd9b, 
	0x18dcf315, 0xd7e4b117, 0xde1ed20d, 0x9638e6e1, 0xe01eb8c0, 0x8c6578ab, 
	0x7c2befee, 0xfce088dd, 0xc091b775, 0x30caf8fb, 0x69e607af, 0x276c14db, 
	0x2989ae24, 0xcdd0215a, 0x7a971122, 0xdef1e93b, 0x92cf50b9, 0xd2dccb37, 
	0x059355ae, 0xacb51e78, 0xc99f904a, 0xb0f96515, 0xfffa0630, 0x543f749b, 
	0x5037ce21, 0x215abe15, 0xc01f513a, 0xeee97078, 0xf0055ac3, 0x1d545aa9, 
	0xbb18c1a8, 0x80fceca8, 0xfcee1810, 0x9a6c503f, 0x50e096b8, 0x9ef805e6, 
	0x3527f281, 0xe03bde1a, 0x8fd83eb9, 0x14fc6c72, 0xb7f68fd1, 0x98422223, 
	0x31af6557, 0xecbaaf28, 0x705688d5, 0xdfa1db92, 0xf59b936e, 0x3f8e3f76, 
	0x7c7f1998, 0x857b70e2, 0xd37f199e, 0x966e4dc4, 0x063cd673, 0x70529c17, 
	0x0057907c, 0x7009dd1f, 0xb0978814, 0xdbaed0d0, 0x4c2ba830, 0xb9d7149f, 
	0xd4fecdc3, 0x427d8c7a, 0xa8395819, 0x95fe78e1, 0x1dab3487, 0x179171d2, 
	0xf48d24f8, 0x3bd7dc62, 0xfc97a19c, 0xf63757b8, 0x5fc63bf3, 0x7901fc82, 
	0x1f5428f7, 0x948ff8e2, 0xabc0e28b, 0xe17937e4, 0x828f7ce7, 0xf9247a0e, 
	0x65ee47c3, 0x000df8e0, 0xf8e91faa, 0x372e8aba, 0x48a2d7c9, 0x57e70ab2, 
	0xea21760d, 0xcc4eb055, 0x5a4a15e7, 0x65869f79, 0x0e11c97d, 0x37c51c93, 
	0xadfd0243, 0x471f843d, 0x54fb24c4, 0x40fbe6af, 0xfe295e80, 0x75a71f95, 
	0x1e713ae2, 0xe83a03c0, 0x87bc36e3, 0xa5f1cf91, 0x29017f29, 0x53ee3b6b, 
	0x5ac098ab, 0x5fe626d3, 0x87f1d52a, 0x4c578e11, 0xe74ddc78, 0xe44f4a04, 
	0xd30d6bec, 0xd6bed3d7, 0x5152bd30, 0x9586dc60, 0x05eedee1, 0x60480258, 
	0x63330d5d, 0x5803ddbd, 0x5a457aca, 0xca1e7aeb, 0x03e758aa, 0x286b9f58, 
	0xebd7bc29, 0xf311316e, 0x0714a12b, 0xd61b2f80, 0x86a739f0, 0xa7a561cd, 
	0xbec58851, 0x3f0fe5f0, 0x08dda50a, 0xc3a1bd62, 0x72e7b9e8, 0xfb33ef28, 
	0xe57d61ee, 0x50ddeec0, 0xa209f997, 0x61ba50da, 0xfd97a65e, 0xd7f0a351, 
	0x6be124fa, 0x7bafe227, 0xc3eafe34, 0x35fc1cc9, 0x31e50c38, 0xdc7b7881, 
	0x23cf1d9b, 0x71949dbc, 0x026bc03d, 0xc0fd43c6, 0xfdee9d53, 0x7bfb8989, 
	0x99ed97ba, 0xecf50da8, 0xb41db2e6, 0x25f7176f, 0x3df71dff, 0x3f9c95db, 
	0xd27e7f08, 0xf9cb3eaf, 0x588a0d21, 0xc2211f7a, 0xbed49bf0, 0xfa8247ee, 
	0x178e3a11, 0x871506a9, 0xef8e86ea, 0xe50e3ea1, 0xf6d31be4, 0x4fdf82eb, 
	0xf905f6b6, 0xdefc967e, 0xf90beb2e, 0xfd9761bd, 0x4defc35d, 0xd7337eab, 
	0x3bfb56d3, 0x778e7f65, 0x8e9af048, 0x3b0059f7, 0x5539d28f, 0x9512f9d3, 
	0xae63f5c2, 0xbae75ebb, 0xddd70cfb, 0xbcf75c43, 0xfbcf75c3, 0x251ef75c, 
	0x5f7a67c9, 0x7ef852a2, 0xebdf75cc, 0xa887fa5c, 0x8f388234, 0x8a408795, 
	0xee971c03, 0x6788367a, 0xfe3c57ce, 0xe002adac, 0xba81f574, 0x78ab8422, 
	0x9c211444, 0x4f7e1383, 0xe0ba24f2, 0x0f081d67, 0x015efb80, 0x4a4577f2, 
	0x647f210d, 0xbdf3a5f4, 0x4b352fa8, 0x7703e97d, 0xb610bdee, 0xea10e9b9, 
	0xfa79cd4b, 0x7d01e692, 0xa9eae909, 0xd539d35f, 0xf91d25bb, 0xbf37832f, 
	0xa01579a7, 0x3364b51e, 0xa9d347f3, 0x996f52d9, 0xed88fa4d, 0xa0bff8ca, 
	0xa7cd709e, 0x80551dcf, 0x748a7fde, 0x62a0f943, 0x088dd21f, 0x71e3b8c2, 
	0xae0f3e1d, 0xdabce163, 0x10239e10, 0xc6fac18f, 0x577fcf67, 0xbb6fe702, 
	0x8ff9a541, 0x7beae4f3, 0x385fc0cd, 0xf4115b7f, 0x966ff307, 0xf3972ff3, 
	0x39d9125f, 0xbce26150, 0xa2de69cb, 0xe7ad18e5, 0x81ae524b, 0x78402f7c, 
	0xf6b62d35, 0x9a8fde1f, 0xff584456, 0x6e247cfb, 0xb943279d, 0x0cfd82e9, 
	0x5e2749f7, 0x317283ac, 0xb0f50e9c, 0x8dd4363f, 0xbf116676, 0xba757e87, 
	0xb9f048df, 0x9555c2ea, 0x6c988e0d, 0x777e4eb7, 0xe0a2e19c, 0xf30a50be, 
	0xb63a76e7, 0x5a0d5f73, 0x0fb441e6, 0x1e7c2817, 0xd9764d2f, 0x555d78d2, 
	0x36ca9c76, 0xdf3fdf62, 0xf37df68b, 0x7e73914e, 0x925b596e, 0xe866c7db, 
	0xe9de987b, 0x36239f3c, 0x5fb8fbed, 0xf5ce6f36, 0xbfa405a7, 0xe126fe0c, 
	0x5b37cd78, 0xd6ffd9ef, 0xdf9d6adc, 0xbed88513, 0x1f5b4679, 0x4fde07c2, 
	0xc6ec8d7a, 0xb641a4f4, 0x05ee471f, 0x9870c73a, 0x5d03f782, 0x87f2b1ed, 
	0x80209ef9, 0x95ca1553, 0x3eb6dae6, 0xab3d3fd4, 0x8e6afd72, 0xa1095feb, 
	0x9e39b15f, 0xfb91ef1a, 0x9cd13119, 0x28e35bd4, 0xddf4682e, 0x7fcb3bb3, 
	0xfe482733, 0xd879afb6, 0x1f4db41e, 0x6cfa45ec, 0xe3c5615e, 0x7b56bf18, 
	0x01c78cb7, 0xdbf454bc, 0xfd836a38, 0xcc751fe8, 0xfbc49039, 0x7e5f4e04, 
	0xea0b9d55, 0x8df30f29, 0x6bbf6518, 0x17e327ea, 0xe9f44adf, 0xa7717e96, 
	0xa3bbf6c1, 0xd963a85c, 0x4198ceef, 0x70e71b7e, 0x63f6843a, 0x6c45e833, 
	0x995507bf, 0x987eaa07, 0xfd2ddc5f, 0xbf7ccee2, 0xe2fd21b8, 0x8bf3172d, 
	0x17e838c3, 0xb8bf4a8f, 0xf338cff4, 0xd28de2fd, 0xd9675e2f, 0xd44e7c93, 
	0x2e75bf82, 0xfab1687d, 0x3e96509b, 0xfbc3c7b8, 0x4d77c59a, 0x95e524d1, 
	0x5f861ad8, 0xbf0d81a9, 0x0eddda59, 0x313fec0f, 0xd9d717ee, 0x71fd89bc, 
	0x7408fcf0, 0xa02ddc23, 0x1e7f321f, 0x6cdb7bc1, 0x64af19de, 0x7c16d5db, 
	0xee93319d, 0x39e0b40b, 0xc4637f32, 0xca7ba6de, 0x9eaace00, 0x8c8f82ce, 
	0xedf34623, 0xb7b646ed, 0x7fa0bbfd, 0x3dc8df9a, 0x35fe395a, 0xcff79b87, 
	0xff966dbd, 0x37fba0d6, 0x3c771fc9, 0x86736fe3, 0xdffe8a85, 0xb09a7f7c, 
	0x636cebee, 0xc0b8ae7f, 0x5a4b9afd, 0xb3e46ad5, 0x9f8e31c5, 0x7f64effa, 
	0xf64f8c2a, 0xbdf5f379, 0xb59e51a7, 0x8ede9ca0, 0x665fd9ef, 0x77fcc5f9, 
	0xbe910b9e, 0x8597e320, 0x824af98e, 0xceb0cde8, 0x17c42b09, 0x5f74e168, 
	0x8d2d2e5c, 0x58e47327, 0x97ca1cbe, 0x5a5c963b, 0x7e4fd6d6, 0xa1cb0bfc, 
	0xaf64fdcc, 0x9f262953, 0x21e4fae1, 0x87794fae, 0x87de53eb, 0xfd87b4f2, 
	0x0e8724fb, 0xe21c8a5e, 0x0efc1abc, 0x119b9fed, 0xcb46e75e, 0xb43b941f, 
	0x67a9d6ef, 0x7e4977dc, 0xde59bf84, 0x3a2bfddc, 0x88447f22, 0x1faa4fe5, 
	0xcc71bfef, 0xf965ed29, 0x2e75f7f3, 0x17bd87a8, 0x4f893f92, 0x407cfe48, 
	0xe52a27f2, 0x92c5bb8f, 0x563aa63f, 0x331dce5c, 0x46ef8e29, 0x5f20717e, 
	0x97192118, 0x761e6553, 0x4fe4c3e8, 0x771fca54, 0x45b0ffbe, 0x0f8d0ffa, 
	0x8ed4cfbf, 0xcacc1ce3, 0x78f196a7, 0x5e1f3e77, 0x2b87fd2b, 0xae60bf2c, 
	0x083341fc, 0xf91987fd, 0xf12a78c3, 0x9195bdb2, 0xd957ac3f, 0x8fe41cfe, 
	0x31fc963e, 0xe65fb442, 0x51a89fc9, 0xb67f2797, 0x0f1d92bd, 0x8eebe0b0, 
	0x16e79209, 0x1fe6473c, 0x5bc8f2b5, 0xe6b78842, 0x1e52a9a8, 0x791f05b9, 
	0xbe536eaf, 0xf9c65ddc, 0xd05dfee3, 0xc7e9f13f, 0xb0ee3f93, 0x7f229ff9, 
	0xdc77242e, 0x7c0f6fd2, 0x8e7e885f, 0x48697c8c, 0xb3017ca0, 0x71cf10a8, 
	0x724676da, 0x36dad9ce, 0x6c17c6e7, 0x8cbacb37, 0xe55ad83f, 0x8e795c39, 
	0xcf2b56c1, 0xe3f75ae9, 0xc7448d06, 0xa657184f, 0x0e13cac8, 0x897df0f6, 
	0xd160ee32, 0xf68090d3, 0x76fc48d7, 0xb1c63c10, 0x3db304fd, 0xefd0434e, 
	0xf796ac46, 0x32e6c0f9, 0xd3ecf28e, 0x96c19e12, 0x36f77971, 0x2b39d096, 
	0x580fbf79, 0xd71c25bd, 0x7c309748, 0x4ed1e945, 0xeb1e97aa, 0xf6f990fc, 
	0x7473e01d, 0xc7cf32ab, 0xccb16f9a, 0xce61179b, 0xd05117a3, 0xddb3c757, 
	0x7600fc87, 0x05fd8873, 0x5e74a9e9, 0xe8a55566, 0x6dfcc41c, 0x17f84e78, 
	0x2bcfc953, 0xafebb3f3, 0xc54e767a, 0xf71a215e, 0x84fd9a1c, 0x03d9f98e, 
	0xe483f25e, 0x633767e5, 0xf30c765e, 0x20e6eb0c, 0x7a835c1d, 0x8248fe36, 
	0xa76bf521, 0x32fa58a1, 0x3d933fe6, 0x4fa43bf1, 0xbfe143b0, 0x257e658b, 
	0x05550fdd, 0x2a765bf5, 0x1f5493ae, 0x5e681b14, 0x497e1e74, 0xfa395d6b, 
	0xb2f35e6d, 0xfaad66df, 0xe60f9a65, 0x5c3de1b9, 0xe586e798, 0x25ced26b, 
	0xfa20fdfd, 0x3bcafe07, 0xb4407f96, 0x301f9c1a, 0x2f1ef73d, 0x57bf265b, 
	0x94bc7bc1, 0xdf6ad503, 0x2793f271, 0x352f1ef0, 0xfbc7ec14, 0xc5ebbe54, 
	0xc8c4e73b, 0x78cd543d, 0xe029d5df, 0xebcfbc0b, 0x3ebed033, 0x0a9cd0b2, 
	0xb12155f5, 0x9adae517, 0x9b638d24, 0xe788591b, 0x20ec46c8, 0x253fc02f, 
	0xfba54fdf, 0x1c3f28cf, 0xef82577a, 0x1a38f5e1, 0x46bd97d3, 0x3ef98029, 
	0xacdfd727, 0x9b7effc2, 0x76cb5fb9, 0x91b1fd80, 0x823d6fe7, 0x9301f0f5, 
	0x9406dcf2, 0x63fa2f7e, 0xe78c5e30, 0xecd56d41, 0x043f4187, 0x1af287c2, 
	0x193cc0df, 0xed824798, 0x77bf3c30, 0x62cfca1c, 0x0c7dcc3e, 0x797a1f8f, 
	0xf9c70cdf, 0xf73ec03c, 0xa0dfc80f, 0xe7648b57, 0xe6ff7959, 0x6ae231c1, 
	0x8f1b1fe8, 0xe1f47fed, 0x1fd85bed, 0x65f72034, 0x92ec4e8b, 0x62eed04e, 
	0x335435fa, 0x2170ff4b, 0xee10c71d, 0x841efa65, 0xff78b8fb, 0xe51fb1e7, 
	0x62c7d124, 0x9e600c61, 0x61de6b9f, 0x585bcc0d, 0xbdca7a4f, 0x3b047f6c, 
	0x8516ef81, 0xc42e3ef9, 0xf4abfd9f, 0x1345f49c, 0x07e252f5, 0x7c29b7ce, 
	0xe917a5a4, 0x9fb8d7fd, 0x579abcc3, 0x024d08ce, 0x1f5d08be, 0x339178e2, 
	0xce87f74d, 0x154ee5fe, 0x77d833ed, 0xe971df48, 0x2f9c4247, 0x2d3dd261, 
	0x75518751, 0x19bbea1f, 0xbbe28b3d, 0x27226d81, 0x41b021ff, 0x42fefce4, 
	0x3cdc9ae0, 0xf73c40e6, 0xe4bf163e, 0xbfed2123, 0x3c91a9c0, 0x97f642e5, 
	0xe79db87f, 0x1df659f5, 0xe7647bdb, 0x6d3dbc01, 0x6a7d1ce1, 0x37a04ecd, 
	0xad03d7b0, 0x2ba14fac, 0x0ba05ee8, 0x4857e9ef, 0x735e6a7f, 0x813ce28a, 
	0xba67b545, 0x7d1bbbe0, 0xceec9cf2, 0x7b6c99c8, 0xebc649bc, 0xef78de11, 
	0x2b539ae0, 0x735a7f48, 0x3c5efafa, 0xf2fa7dff, 0x453fa41d, 0x4feb637d, 
	0xfabe7d2e, 0x275fc4c9, 0x343e50fb, 0x2babf8c9, 0x9ad3faca, 0xfb4c6372, 
	0xfac2d5cd, 0xad386b93, 0x301f7ee1, 0xb5bf690c, 0xaf94fe90, 0x39e7e52f, 
	0xae4d7959, 0x2a29fd7c, 0xe68ba7f5, 0xa98cb535, 0xf5f2b93f, 0x7f5265a7, 
	0x4fe9645a, 0xe16ecf9c, 0xab924111, 0x3ebeb13f, 0xbf6b97cf, 0x9269a2b9, 
	0xcf658117, 0x14aef086, 0x739d2fc4, 0x1ad47a94, 0xf515788f, 0x349e3580, 
	0xac0da39d, 0x7feeb6af, 0x7e3b357f, 0xd5d3c16a, 0x2fa8a862, 0xf8b3f059, 
	0x8858e00b, 0xf7b359f6, 0xc6630377, 0xfbacdb4f, 0xe38e41f3, 0x9c91a3fa, 
	0xe4099bdf, 0xaf177faf, 0xc8cbb7df, 0xc696a3d1, 0x15d5cf39, 0x6a2f4836, 
	0x7c77b3ce, 0x110b2677, 0x5ec17bbf, 0x75cf2b18, 0x123bde0d, 0x998d7823, 
	0x07dd6ae7, 0xf62dc6b4, 0x75ab9e63, 0xf103d01f, 0x9b5cf3b1, 0xf27245b7, 
	0x44379a6a, 0xa1a77e72, 0xbcdc9af9, 0x5653e6d7, 0xbde33bfe, 0xff7b9e39, 
	0x28f285cf, 0x5f395b7c, 0x4533b022, 0xadbead79, 0xa4b9afac, 0xe7e5667e, 
	0x89bd5c7c, 0xafc0f5fc, 0x2f49e9ae, 0x5d37d1c2, 0xcc9a88f5, 0xe99e803d, 
	0x33088f49, 0xccdfa1bd, 0xc3e93d39, 0x847dd676, 0x5e996fde, 0xa7baeff4, 
	0x2748fd27, 0x5d533fb6, 0xfe09ae78, 0xbd635e0a, 0xc9d060ac, 0x654b3ff0, 
	0x175cf2ba, 0xeb9873af, 0xb7ecd313, 0x72c63aaa, 0xd704eaac, 0x85cfc92f, 
	0xe7cd2f72, 0x718faad4, 0xc812f059, 0xfa6b5709, 0xa0f525bb, 0x93142dcf, 
	0x5a4e041f, 0x61e56374, 0x0fba51d7, 0x86af7925, 0x9c467d79, 0x831917cf, 
	0xfcf21dbb, 0xf9e30859, 0x4870b062, 0xf27d7788, 0xcfbcb39c, 0xfc55ee83, 
	0x463ee65c, 0x8bbedbac, 0x8abdf3df, 0x55202a0a, 0x2174d788, 0xcfd05bea, 
	0xe8ccf521, 0x7bacfc7b, 0x3d7bac42, 0xe706c7b4, 0x967e000f, 0x7e8986e9, 
	0xfbfbfcd5, 0xaa621bdc, 0xff9d1376, 0x06ffb037, 0x03757320, 0xbe0a5bd5, 
	0x0ac4e343, 0xa77a9c61, 0xeea07988, 0xa7437191, 0xcbef7b9e, 0x90f58fa0, 
	0xde38fb6f, 0xb0d3f387, 0x1b25bc1f, 0xa9dd5bbe, 0x75dfe8a8, 0x8879f076, 
	0x5eabaf25, 0x8f6e59f7, 0xe912e07a, 0x797d5def, 0xf80abdee, 0x3dfd023e, 
	0x32f797e1, 0xc9764109, 0x7bdf20ea, 0x0778a1f6, 0x7ef69d3c, 0x9efa4fcb, 
	0xe3681fc4, 0x38dc97a1, 0x1f34059f, 0xfb27cc17, 0xede01bfc, 0x3e327dde, 
	0xdab8648b, 0x7bee275e, 0x7e9bd71e, 0xfd2fdeff, 0x92e5f1e9, 0xf5139d7a, 
	0xbf49a793, 0x4fbecfeb, 0x90ffd2d5, 0xe13e10ce, 0x2abfdf14, 0xbdd3e65a, 
	0xe68a030d, 0xc1cfbecf, 0x40ea9759, 0x6515d7fd, 0xbd4ff03d, 0x27bca73e, 
	0xceafe71c, 0x704df794, 0xcf5c61ff, 0xf0e8b06a, 0x4ba4527e, 0x5ee6666d, 
	0x2e557f8b, 0x2ffe93f3, 0xfa00b7ef, 0xff1cf3a4, 0xc2f1eb69, 0xaf467a7a, 
	0xe9e5f4e7, 0x003fb87d, 0x4d5f301f, 0xea7dd34e, 0xe5dfbce1, 0x63b6565a, 
	0x2b065d1f, 0x49977df3, 0x77fea038, 0x9d7c64ce, 0xa64e5935, 0x5d2d3f29, 
	0xea9bbc32, 0xe4a8e725, 0x8f85f2f3, 0x6d2f48a4, 0xd639f3f4, 0xefafafd5, 
	0xc80df8c5, 0x007a57d3, 0x19a64bcf, 0x5bff70fb, 0x2f4573b6, 0x781f09f9, 
	0x62699b56, 0x9b56a81c, 0xfe56cd0e, 0x156ab3ed, 0xa7f9afd4, 0xd0b9d2da, 
	0x3e1faaef, 0xca13325b, 0x16d6afa5, 0x3fe940d6, 0xef10a47f, 0xef2658a9, 
	0xe7ea39f1, 0xc5d582fc, 0x76f90ea2, 0xd72824f5, 0xe204fde3, 0x675fc144, 
	0xef26d8f8, 0xf7845d1f, 0x75f3c21a, 0x5bebf601, 0x092e1af7, 0xbee13db0, 
	0xce3276b6, 0x9f2ff66b, 0xdf337a95, 0x7a96e867, 0xcfbbc8b3, 0x74171fd0, 
	0xdf66619f, 0xfb87d86e, 0x3f3c92f6, 0xa5a892e5, 0xc8dfb2ff, 0xa4db4b77, 
	0x7b8c6ed2, 0x1f70fa45, 0x9e92fcb6, 0x9449e955, 0x3f3374a7, 0x4226b25f, 
	0x839748fe, 0xc96c977f, 0xf8dfae52, 0xd7261fee, 0x9bed7d40, 0xa044a73b, 
	0xd9f85ffd, 0xede4b8ff, 0x09667f11, 0xd638b3fe, 0xcaf9053f, 0x739956d3, 
	0x9ddae19f, 0x6f510a2b, 0x90fd225e, 0xa79c02e3, 0xbe81d96a, 0xbcfeb15f, 
	0xcbec6dd6, 0xea10d7be, 0x8df3b3fb, 0x7967e87f, 0xb21fef9b, 0xf2ca8f7e, 
	0x35e964f7, 0xf27150fb, 0xcaa7dfcb, 0xed2e8bf8, 0xff2ca9f7, 0xc689e510, 
	0x4a5eee58, 0x9db2f1be, 0xb52fbfb9, 0x5eae736c, 0xdce6ecb3, 0x6f65d27c, 
	0x9066bd4b, 0xd165b9f5, 0xb4f7399d, 0x7ca5fe59, 0x5fe594ff, 0xf389b25a, 
	0x94ff2d8d, 0xb6accfa5, 0x3cb16fab, 0xef76ff0f, 0xfe1fdc36, 0x93f74fca, 
	0x1e3f0355, 0x227ca9a4, 0x5a9fcbfb, 0x7afb5a8e, 0xdcc0fe03, 0x5cfdcb5f, 
	0x87bc4dca, 0xda4be2d8, 0xbee337d7, 0x4ddd3e9e, 0x7adc1970, 0xef93d03f, 
	0xa88563d6, 0x1c132fd7, 0x46fe21d7, 0xd9a9527f, 0x5b07f78b, 0xdf885fdf, 
	0x9087cf89, 0xef50cdef, 0xc2e7c8f3, 0xd810fa89, 0x0f10fb0b, 0xf75916cb, 
	0x71fae620, 0x34b03b2d, 0xad6572c0, 0xaaf24d27, 0x7dfacd79, 0xd0cb97c8, 
	0x3e06fb2f, 0x71255e37, 0xd1578c28, 0x491a8c5e, 0x225ed3ca, 0x17ec10ed, 
	0xdcb6b8f1, 0xaabcc428, 0xd178bce6, 0x6174e192, 0x8f149bc7, 0x25a3bca2, 
	0xe2ca3718, 0xd1b8fc9f, 0x23d828b2, 0x723f1931, 0xa48dc565, 0x1ff161bd, 
	0x64268fc5, 0xf20b8aec, 0x5c57659f, 0xe3f2ff80, 0xe7f2174f, 0xc4d17d92, 
	0xbee46272, 0x8272c151, 0xc6dbb7f2, 0xc8fedfce, 0xfc9718fc, 0x7c8aed28, 
	0xfcd4bcfe, 0x93c7e26d, 0x249b7f92, 0xbf32c6bf, 0x4b7c482b, 0x67feba7c, 
	0xde9037f7, 0xb77deb75, 0x67f2bd61, 0x1e7d13f7, 0x5fdef5ba, 0x6fb47f51, 
	0xb9f2cfba, 0xcfccb727, 0xf63b3a6e, 0x9eb727b9, 0x03fc84f8, 0xb7e802d3, 
	0x5603fcb2, 0x2fdf257c, 0xf2477440, 0xdfb2a531, 0x28e3c3e8, 0x43793f14, 
	0xe3b253c6, 0xa38817b8, 0x976bf458, 0x56259a71, 0x5fd2471c, 0x19609fbe, 
	0xa38275c6, 0x371f04fd, 0xc020b2be, 0xc57f81fe, 0x9edaeedf, 0x2d057bf5, 
	0xee57f382, 0x861ee956, 0xc21fde88, 0xe11633fb, 0x8baaa339, 0xdabb879f, 
	0xe2af7b9f, 0x81c83732, 0xa6e7f634, 0xf0c41bfb, 0xedaf29d7, 0xcd4f7966, 
	0x058fefc5, 0x74e5038d, 0x4b06fdde, 0xdfbdceee, 0x75755176, 0xc5d0eda7, 
	0x0e5db7ef, 0x7ef833f3, 0x36dfba3e, 0xdfbe3f33, 0xc8404d76, 0x46bf1f7b, 
	0x7991fbf1, 0xf344353e, 0xdcba6e8c, 0x43f13fba, 0xb3f92def, 0x23ce8271, 
	0x3ed8aabb, 0x7ce74d72, 0x9705571a, 0xffbc0247, 0x8be5931f, 0x9c0f7901, 
	0xc15d9f95, 0x242706e3, 0xa7e73a03, 0x13676868, 0xbea38e7e, 0x9c891463, 
	0x1df39d3c, 0x7e17a84e, 0xee8cf385, 0x39c6e40d, 0x75a6e70b, 0x8b0a9bb4, 
	0xa77d84a0, 0x9313de50, 0xb65e700a, 0xf29d7e18, 0xfa3f37b0, 0x94679979, 
	0xdf717e22, 0xcf373878, 0xcf11af68, 0x7a0e6ff6, 0xe07a8685, 0xbe560337, 
	0xb18143ea, 0xb0dd55f2, 0x529ba21a, 0xb8e295c3, 0x90752b89, 0x30fb43bf, 
	0x0095f155, 0xebb1e7ed, 0x598f38dd, 0x3cd35737, 0x1dd3fb4e, 0xbcc91fa4, 
	0xe1e8c2c2, 0xe7f24ceb, 0xa43e7418, 0xa93864c5, 0xbc7dfe5e, 0xd3977f11, 
	0x5bbcf150, 0xef026e09, 0x41beefc8, 0x28ebeac1, 0xa0d4b7ff, 0x51b824fd, 
	0x0738a02c, 0x47ee07d0, 0xee825d05, 0x1fb608b9, 0xa6efd048, 0xfa0a1ab4, 
	0xf0955f33, 0x7d05ac0c, 0xd813d618, 0xa20e2668, 0x9f2febbf, 0xe89e323a, 
	0xef356841, 0xb0fff265, 0xc83efd3d, 0xd9a8afb9, 0xc7351570, 0x39d6dea8, 
	0xbe2bca57, 0xc793235f, 0x1bdf7599, 0xe7ce31c9, 0x95311d54, 0x08eb377f, 
	0x197837c1, 0x44e29bcc, 0x5138a342, 0xbf475a4d, 0xa0f16b8b, 0xd7d6fe8e, 
	0x5d7cb902, 0x86a0d8f8, 0x73d243f7, 0x88949fd0, 0xc980ff68, 0xf16f2f35, 
	0xea9f9a69, 0x52fcf10a, 0xffba207f, 0xf8e3bbc3, 0x1d9770f7, 0x864c8a56, 
	0x72a1d917, 0x6f8b69de, 0xfe62be64, 0xd26d41bc, 0xc47e5912, 0xf77032fc, 
	0xe7798ea0, 0xe29868fe, 0xa7774359, 0x1239d693, 0xabcf8edd, 0x01089f69, 
	0x0d9ca383, 0x3df5ab45, 0xe41cf883, 0x5f29b7e6, 0x2eb77e87, 0xee770d14, 
	0xfd817681, 0x6dde1a6d, 0x5871dbe7, 0xd7e30b9b, 0x962bf65c, 0x40bdaf23, 
	0x93e57e74, 0xfe7d6833, 0x1550915d, 0xfe0f2bb4, 0xebf7803a, 0xb4371f3a, 
	0xdbe4a639, 0xf4fe8837, 0xef62e804, 0xe0873b4b, 0xb532f4ce, 0xa625f08b, 
	0x1a11eff2, 0xee58bb53, 0xce3aed4c, 0x005e91ed, 0xee66735e, 0x9959dfa5, 
	0xff47ea5d, 0xd063d32e, 0xd07c562b, 0x35787c49, 0x1c500fe6, 0x34ede10e, 
	0x75bfcc55, 0x5fc94b47, 0x938589e0, 0x1e3c7d9d, 0x02fff5c2, 0x148bfdb4, 
	0x00038ce1, 0x7de59c78, 0x555c940b, 0xaaaeee99, 0x9ea75553, 0xbababa7d, 
	0xee91fabb, 0xe549084a, 0x5013d0c1, 0x9398248b, 0x13274210, 0xd0b91687, 
	0x8b914220, 0x16d462d8, 0x465c36a3, 0xfa77554e, 0x00a92011, 0xd19c1d26, 
	0x913ae186, 0xe30dab99, 0x8f8ef18c, 0x181179d3, 0x02cbd6c4, 0x90e9d074, 
	0x1aae8864, 0x2691956c, 0x7ffb98d7, 0x5ea7deff, 0x733a009d, 0xadd6b3bd, 
	0xef6760b5, 0xfc7ecfb3, 0xffdfdffb, 0x1d3effd8, 0xee22b41c, 0xd16fc08c, 
	0x5890db73, 0x228a5e8b, 0xa8e4bb19, 0x92ddbc86, 0xcbc42a3d, 0x49fe17b1, 
	0xb1c4253c, 0x965f78a8, 0xadba87ea, 0xbb07c815, 0x8f6215cc, 0x2f3e1f10, 
	0x42bd6868, 0xe8855a04, 0xe7b720ff, 0xffd08ece, 0xb91ee175, 0x08435299, 
	0xdb6dcb8d, 0x984a7ca2, 0x75f7a2c2, 0x84ffa3ea, 0xb3332e10, 0xfae495cb, 
	0xae51c8f6, 0xaa7cef6f, 0x76be9ed4, 0x840572ca, 0xea76a268, 0x74429fa8, 
	0x4cff5858, 0xe2f2baf5, 0x1f7945a0, 0x5e426fe5, 0x0a4a0188, 0xb6ebedaf, 
	0xdb78d2e6, 0x4d17ef5e, 0xdfa19c42, 0xa885bbee, 0xb961a5f9, 0x6134873f, 
	0xf965ebb9, 0xa12f9520, 0x2269f576, 0xbf6a5202, 0x3f23716d, 0xf5f6d63f, 
	0x7c8f7d21, 0x92f9401e, 0x3f955b46, 0xf2c937a9, 0x4a5f2a5a, 0xe31db8a9, 
	0x3dac87b7, 0xab21cf3c, 0xfb7ed4a9, 0xdad4b132, 0xf0f8c425, 0xa7917ea1, 
	0xbf7683fe, 0xd5b8f485, 0xeb83beed, 0xf29644fb, 0x0dfe53cf, 0x709f4de4, 
	0x55b6de51, 0xf3f2f6de, 0xe9bc9c27, 0xda8fe7e5, 0xe71afbce, 0x6b9f1577, 
	0x18ed1fa8, 0x401f0e8b, 0x44a3149a, 0x8991a8a7, 0x9a441f0e, 0x22519bfc, 
	0x22d85454, 0x5da524ff, 0xf9187bb6, 0x1c7864ae, 0xf0c933cf, 0x4ed48688, 
	0x7cc7d63e, 0x29d7ee91, 0x88e5ff4f, 0xf121ad7e, 0x79cd30e4, 0xe6997404, 
	0xea08f6f5, 0x2c3ea4d7, 0x2bfe7bac, 0xddefe46e, 0x7be64cbe, 0x83fce69f, 
	0xbccbd517, 0x03e05cb0, 0xbee859bd, 0xaebc799b, 0xebdde897, 0x4fc5a95a, 
	0xcc9bd651, 0x0f98b3cd, 0x6dcf51fa, 0x5bf06e98, 0x8ffb2934, 0x5875d6dc, 
	0x0a693e27, 0x66c3839a, 0xf3ce1c69, 0x3835a0e6, 0xfcbd419e, 0xa4118ee1, 
	0xd504e1c6, 0xe0c5044f, 0x77eb2da8, 0xe054cb4c, 0xd769d33d, 0x7f53a438, 
	0x5ad8a0f1, 0xda29aed1, 0x3874909e, 0xf94c3fd9, 0x0e38e29e, 0xd06d7ea2, 
	0xbfaf281c, 0x4b4bb55e, 0xf8b82fe2, 0x4e71df3d, 0x9925ef85, 0x52e73ef7, 
	0x72e16ffd, 0xb95933ef, 0x729c476e, 0xa096a7e2, 0x713e083d, 0x26db91f2, 
	0x479a090f, 0x6aded063, 0xdbf7a5d9, 0xd1cac2dd, 0xd9096a3e, 0x13b64187, 
	0x810f778b, 0x693e943e, 0x3f7f2fac, 0x78d0487f, 0xe956821b, 0xe2ef2e7d, 
	0x59a0faf2, 0x10793e55, 0x7b4175e5, 0x7f3cb2a0, 0x0588e310, 0xf8772e2d, 
	0x97ddf79c, 0xbafbd7c1, 0xeea97bc5, 0x2a9a698b, 0xdff29af8, 0x3491fca7, 
	0x9ec6b64f, 0xea7df991, 0xbf2a13f9, 0x89073e57, 0xefe02dac, 0xa8ced919, 
	0xaa976f7a, 0x5bdf2c37, 0x0ff10b72, 0xa0cfb3ad, 0xef2a09f4, 0x682821b9, 
	0x4d6fa43f, 0x22f08b09, 0x88663adf, 0xc39bc37f, 0x92d1f001, 0xc006e61b, 
	0xb5d4be47, 0x373f7101, 0xe98d7fe9, 0xc37ff96e, 0xe60fd0a9, 0x433faf38, 
	0x26bff869, 0x25cf3086, 0x4ecae161, 0xcd858610, 0x94b5f1fa, 0xdafc9cdf, 
	0x4b2fda36, 0x861a64b6, 0xa374a72f, 0xa61c375d, 0x31044074, 0xaf5de21e, 
	0xa4f883ab, 0xe58af477, 0x9fe89934, 0xa4aff3ed, 0x92876bf6, 0x1bb50d7a, 
	0xfbab21b9, 0x43e8b4dd, 0x1a7e89fe, 0x895a9ac7, 0x4bbf116b, 0xc6d6be03, 
	0x30f7c844, 0x8cdaffb1, 0xd12f95c7, 0x88b4b237, 0x2380db23, 0xe314ee4b, 
	0xfed3ff72, 0x9f92dfa3, 0xfef38f75, 0xa62e5b77, 0xe6420dcf, 0xfce1e585, 
	0xf69e4e35, 0x17e9e813, 0xf1f13f76, 0xb4e99492, 0xde5bdf23, 0x098d6e37, 
	0xc5c2b4f1, 0x975cf768, 0xfc71ca48, 0x7fc38d15, 0x6283f7fd, 0x18cbd527, 
	0x3efa7802, 0xc6887f1a, 0xec615a1f, 0xfc7cd377, 0x3e5b7b41, 0x3f2a7123, 
	0x7e6cf9c2, 0xf23df24a, 0x6ce15bff, 0xa91a6ef8, 0xbd61f72c, 0x021129bc, 
	0x51f735bf, 0x9ebba205, 0x0f81ee14, 0xa4c474d1, 0xfe11b80f, 0xa6e5d323, 
	0x74f15efa, 0xbde9f508, 0xbec57010, 0xa2b8c93b, 0xb43eb4dd, 0x4e9b3b38, 
	0x01ae6504, 0x5f4b4f1a, 0x7892b087, 0x4f82f0cf, 0x155e141a, 0x20be9452, 
	0x2f9dc4c4, 0xae822212, 0x493171e9, 0x3e28c8ff, 0x5df281bb, 0x87c931c0, 
	0xf951ae4b, 0xd53cf54e, 0xd527eb27, 0xdf2ae5f3, 0xbf039f21, 0x5be17fc1, 
	0xda090f7b, 0xf75a5a8f, 0x3e994759, 0xad83963e, 0xf34b37a6, 0xff679daa, 
	0x7a8c35a3, 0x6e40f7e3, 0x07594b11, 0x372945b9, 0x3b9637e9, 0x664e582e, 
	0x58f91f29, 0x3f5ae5af, 0x3645fe5b, 0xfbc36d4f, 0xe38b164b, 0xbae5bd72, 
	0x4de7eb3a, 0xbcdd79f9, 0x68335b29, 0xd2d25a1c, 0x9ce01380, 0x7df2cdfc, 
	0x6f75c683, 0x25ff5cad, 0xb71d578b, 0x90fe4688, 0x3865613d, 0x2d6986dd, 
	0xf2c53eb9, 0x3137c694, 0xc245fd4c, 0xae83f6cb, 0xf73c2e60, 0x359708b7, 
	0xd177ed4a, 0xda7bd1ba, 0x181c1d8c, 0xa29af1a2, 0xde86bad7, 0xa0c2d332, 
	0xb8613e8a, 0x0a767f79, 0x3d636697, 0xf9e2bdd2, 0xe76b3d12, 0xa256fd89, 
	0xd22bbdec, 0xfe62cfa2, 0x0ff39571, 0xe6790ef8, 0x75ff921f, 0xb49f92a3, 
	0xc93fad24, 0x6c17f0b9, 0xf9253dcd, 0xc3fc6cf2, 0xe2b3767c, 0x2c7f9a2f, 
	0x87c0866f, 0xdce05fe0, 0x1e77eb92, 0x61317b46, 0x6cf60369, 0xbe2b7b3e, 
	0xdd63ff02, 0x7ea70f99, 0xed1b3e0f, 0xcabcf993, 0x98cf839f, 0xfc529ebf, 
	0x77c4b475, 0xa17929af, 0x3e637e29, 0x977c511b, 0xbce9f1e0, 0xc0454b0e, 
	0x47eae927, 0xf3de95be, 0xfbedc2df, 0x930e466d, 0xd8b811f1, 0x83cb32ff, 
	0x64b3b461, 0x9463e53e, 0x237a65c6, 0xfc418ff1, 0xb7a549b3, 0x2f7dcad6, 
	0x59822726, 0xc09e93d2, 0xfaa35e78, 0x22d044da, 0xd37e393c, 0x7e245f84, 
	0x4d6fbe7f, 0x78f2e043, 0xdeffc086, 0xdba5a1a1, 0xc61e7867, 0x34d99d36, 
	0x773a6d98, 0x9bc8e2bf, 0x7fcb8b8f, 0x5d107189, 0x45de17a0, 0x64e7e9fa, 
	0x899b35bf, 0x27fc940f, 0xa4fd15dc, 0x0c92b627, 0x959429a8, 0xffeb2d5f, 
	0xd125e144, 0x6724f399, 0x4447a087, 0xbebf2d7b, 0xc5feacbe, 0xb65d7daa, 
	0x0c665bef, 0xa1fcef41, 0xaa572fb3, 0x3c738c7e, 0xd39f2b5f, 0x51dc63cf, 
	0xfe919fa6, 0xe3f89795, 0xbc9f13ca, 0xc74bace0, 0xf2e5ddb7, 0x714e4c53, 
	0x3ac9b6fe, 0x02ed9ef5, 0xdb7a393f, 0x1084ad75, 0x4f4aaf90, 0xfd8ebe13, 
	0xedcf6a2e, 0x7f59b8cf, 0xcf59f6a3, 0x10da1b4b, 0x2bbc4bde, 0xe57c4837, 
	0xe0c4274d, 0xc5ae3ce3, 0xe352df68, 0xdd26d632, 0xc789c22e, 0xec5cfed0, 
	0xc12c7783, 0x979ba7f3, 0xaea4f1c8, 0xdafd825b, 0x9962f877, 0xd962e617, 
	0xc0cff8ef, 0xefbe220f, 0xc764a5b1, 0xa17eb60c, 0x77a47a16, 0x30f25ec8, 
	0x5ad375e5, 0xb8287e02, 0xa4d6abc5, 0x52d13b90, 0x4e7cc4f8, 0x4ff123f8, 
	0x2af67f43, 0xcab57fb5, 0x19f1bafa, 0x88f64431, 0x0c467fa1, 0x8f095dfe, 
	0x546380a6, 0x6e1160a7, 0xcfaa535d, 0xc28af778, 0x0e1291b7, 0xce119e32, 
	0xbef97417, 0x2ff19f53, 0xaaff1b3f, 0x4f30af71, 0x38e4aabc, 0xae0e936b, 
	0xd1cb64c3, 0x8ad6177a, 0xf2656357, 0xf89cf19c, 0x9d6aebf5, 0x1b7cf0cb, 
	0x2ff81cf0, 0x3fcf0a02, 0x6c1e70a8, 0xc15d926e, 0x7df08ffb, 0x290f497d, 
	0x3c60bae1, 0xc69d7075, 0xb232d6ef, 0xc90fac5f, 0x79728983, 0xb2479c50, 
	0xd82efb88, 0x99ba4549, 0x5a89be72, 0xa7445389, 0x5fdc0a89, 0x4adfe728, 
	0xefc57e65, 0x77a33fb0, 0x94457e93, 0x75a47630, 0xdbab3a8d, 0xeeeba33d, 
	0xac3ffbd9, 0x224b8c69, 0x2ed90765, 0x3b83b0ed, 0x82fdcbd7, 0xafcceefd, 
	0xe6ae7bb5, 0x3f56593f, 0x968ff549, 0x9bd757ea, 0x52a3cfd5, 0x9c768d2f, 
	0x15fd2f4b, 0x97a3a7f3, 0xb2496f86, 0x5e851a5e, 0x0412631a, 0x687a939e, 
	0x454e25e0, 0x07ccb8f0, 0xffc6940b, 0x75823132, 0x574d8709, 0x1ff53576, 
	0xbb055b1e, 0x3939bc2d, 0x61011f7e, 0x32dd8b78, 0x8dd2887c, 0xc4c38d53, 
	0xa483e14f, 0x2d3ad297, 0xda5ea5b6, 0xbeba3e30, 0xf0d3e899, 0x56817dad, 
	0xc9e9af6a, 0x4a42f064, 0x82b16feb, 0x323ca90b, 0xa5eb0574, 0xea58d12f, 
	0x77e24708, 0xfd2c9e59, 0xda55783b, 0xed7d7823, 0xb097ec1a, 0xac1e326e, 
	0x7ec0f5a2, 0x0f0b350d, 0xcfc913f6, 0x44a7ef38, 0x2bf60d5f, 0x7ff051cc, 
	0x0f3d3348, 0xf51e797a, 0x6e5f6047, 0x6605fc76, 0x337b9e1d, 0xe26c5ea2, 
	0x18df6cf6, 0xe15bf7f5, 0xac5e52c9, 0x7f12a336, 0x31d051e2, 0xfdcb76ea, 
	0x711a886f, 0xe4736287, 0x295e2b4d, 0xee7aedcf, 0xb01acddf, 0x649326b8, 
	0x20bffafd, 0x4471e0ed, 0x38f4fd0b, 0x4d26b7be, 0x3a657ea9, 0x88f8f1ae, 
	0x67828f3d, 0x51ca434d, 0xe01c98db, 0x28bed671, 0x53b522fd, 0x93b19a9c, 
	0x919b1f32, 0x6bde1d69, 0x00f181fe, 0x3eb9b3d6, 0x4ade1755, 0xdcc6bef2, 
	0x284a3f01, 0x0fb0e768, 0x126b4122, 0x87e5aefb, 0xec13ef9d, 0xd7ff3127, 
	0xc171f108, 0xcf03b330, 0x8962bdcb, 0xd7aabb32, 0xddc23d62, 0x4ebcc4a7, 
	0xd7ea9bf2, 0x58bb57fb, 0xf6465c6f, 0x3bdfd102, 0xb72be530, 0x9fa05a17, 
	0xf13f4034, 0xfc21dfb2, 0xeffea283, 0x47e14343, 0xefdea4ba, 0xfc8ffda6, 
	0xb9e3f5e2, 0xb28bf324, 0xd0dda407, 0x70813b0c, 0xa2edfc25, 0xfae5e13d, 
	0x60dd8e7d, 0x12f7bd72, 0x1f64e88f, 0xf6921f86, 0xac933443, 0x9be21bb0, 
	0xbda08f0c, 0x76423e16, 0x2cf7b503, 0x7f110fd5, 0x6bb2fe25, 0x6f7ccdc2, 
	0xfd328df8, 0xfa282ea9, 0xcfe11d95, 0xc60efad3, 0xba6b5ca4, 0x3ef474db, 
	0xfa6af51d, 0x61fb0444, 0x1bb4a4de, 0x05d349bc, 0x56ed81bb, 0x59f4d5aa, 
	0x25dc03db, 0x7a574efd, 0x4f9ca45f, 0x58235f88, 0x198f48b7, 0x3785bac1, 
	0x9da08fe5, 0x7a0bcd08, 0x0b1d355e, 0x25aeb750, 0x456ffcb6, 0xa4f58ebd, 
	0x5ea526f3, 0xd281fe17, 0x1bbd94db, 0x3cf4a83e, 0xbf85d7a5, 0xab8f9ead, 
	0xe3d29f7c, 0x21fe547a, 0xf517cf95, 0xd7c63f3a, 0x93ef6cf4, 0x77e91f18, 
	0x4c8bd4ba, 0xdbccfb1d, 0x07c1fa6a, 0xdf8ecf4d, 0xefb9f4a7, 0x12093702, 
	0x802783dd, 0xbf8ff45b, 0x8f2cfae3, 0xbc71b45d, 0xe93a77d8, 0x9eb94757, 
	0xd57e87ed, 0x00fab53a, 0xe95ff525, 0x6fd4e332, 0x67e4a1a1, 0xaabb201b, 
	0xfb24a5e5, 0x91b7c2d3, 0x7766515d, 0x811beb3a, 0xc93e015d, 0x222bb608, 
	0xbb0bc23d, 0xfe41ef02, 0xbb29d7b4, 0xba9fc94f, 0xfb107d90, 0xfa442ea0, 
	0x3fbde603, 0x1a377ec5, 0x32e1c1ce, 0x0b5d59ff, 0xe3e69b8d, 0x08eb47dd, 
	0x9e11997c, 0x1fd53f01, 0x94da3d37, 0xbbcd179a, 0xd9fb7c25, 0xca4a4de5, 
	0x72e89f67, 0xf42b6f41, 0xe3daf929, 0x04e617d8, 0xfeb159e4, 0xc4672485, 
	0x3f033e6c, 0x467ccf22, 0x263e2dfb, 0x8df98ef9, 0x2fa68bec, 0xf15baf09, 
	0x22b3d2ab, 0x0e85f655, 0x3dbf337a, 0x7e219005, 0xaff25a3b, 0x77077c38, 
	0x0ef8d9e9, 0x15ed03fb, 0x68ff8bed, 0x7c531c3e, 0x1f39bd67, 0x57adff32, 
	0x897377fc, 0x1ec2ef2f, 0xc70fed7e, 0x52d3f38f, 0x2c7fa80f, 0x803d023f, 
	0x721656e4, 0xc58f4a18, 0x6c82b5e3, 0x7b266cff, 0x0ac5d786, 0xf61f3f20, 
	0x4f9e71cc, 0x33da4a60, 0x4f21572c, 0x7b7137fb, 0x850fa0db, 0xe49e53e7, 
	0xd32e3860, 0x1da4c45f, 0xff4abaf3, 0x33d8e62d, 0x38f00f2e, 0x6c3cb9ac, 
	0x0ec87c2f, 0xdc92d188, 0x1ea5c68c, 0x7dcff2df, 0x6be25ade, 0xf7ea4c5f, 
	0xef0bd069, 0xf43ef4db, 0xeabf4520, 0xda5cb876, 0x4be8011d, 0xefec88e2, 
	0xcac3f55c, 0x607d012e, 0x7f54787f, 0xcc976561, 0x42f690ef, 0x25d95cb1, 
	0x7693ac9f, 0x25d95849, 0x8e4d8ff5, 0x30d88fc0, 0xa7f4056e, 0xbb2beaca, 
	0xdb2ebe64, 0x8c6ede8f, 0x31fe4fc0, 0xbb2b7f67, 0xeb3e7404, 0x9769b7f3, 
	0x7893ae6c, 0x25dbbbff, 0xafd03484, 0xcc9761ce, 0x3a9b8b92, 0xdc6373c7, 
	0xb0ed07af, 0xa8e3c1fd, 0x7b1c4fb4, 0xf64a3223, 0x4077638b, 0x935d830f, 
	0x7a4dfc81, 0xef08bf60, 0x5e70c7de, 0xcbf656f1, 0x3c45eb60, 0xbd90f74e, 
	0xf84a7618, 0xac96fbe3, 0xaef0960c, 0x37395eda, 0xbeb175fe, 0x08af6d5d, 
	0xec7797e5, 0x16ec3099, 0xd85e67da, 0x4bf6e531, 0x85e3ea4a, 0xf545c28c, 
	0xf27db57e, 0xe167e2bb, 0xa453b24e, 0xa761507e, 0x3fe908d4, 0x7642dc2f, 
	0xb31d994a, 0x97f24eb1, 0x0be1fb83, 0x51ee7cd3, 0xc9ff3b94, 0x6aa3c6e4, 
	0xfe6b9dff, 0x1fd213f3, 0xf8c7fe01, 0xfa43be1b, 0xf8927536, 0x9f383a5e, 
	0x661796d2, 0xb7d62982, 0x25df5ffd, 0x585217cf, 0x96b6b8c7, 0x84a446f1, 
	0xc229da47, 0xfb03bb03, 0x33917607, 0xc7a4f9bf, 0xeaca7bfa, 0xd1fea927, 
	0x7aeafd52, 0x5778fdd5, 0xa22e3ca5, 0x8d6c2983, 0x103b43f9, 0x0efb6e00, 
	0xdebcc3d8, 0xc8418ccb, 0x580fca37, 0x8b0b10a6, 0x08eb66fb, 0x5960b308, 
	0xf5e3ff51, 0xf470505b, 0xf297e143, 0xca3fb042, 0x107ba2bf, 0xa9c161f2, 
	0xc7e95ea2, 0xfa1b7dff, 0x760a6202, 0x78087185, 0xa2c6e0bb, 0xbca8c97e, 
	0xb7da74c0, 0x2df58ed9, 0x2dc4b976, 0x39389c42, 0x47c3801a, 0xdcb970eb, 
	0x563c932f, 0xeca172fe, 0xfe55d477, 0x3c8bef01, 0xb36bdb32, 0x8f8662a6, 
	0x31876a70, 0xe995c0ae, 0x8f06fc00, 0x3e0d5d11, 0xb0d2e987, 0xa5a633ff, 
	0xf3d33e41, 0xeeb45dcb, 0x26322e73, 0x40bcf2dc, 0x2bbd2bcf, 0x158176cf, 
	0xbfcf49d8, 0xd709f78b, 0x163c5c4e, 0x3a083d70, 0xc45c06f4, 0xde570b1b, 
	0x7e79023c, 0x640ad87e, 0x14374a6d, 0xcf9e26f5, 0xd738c282, 0x0327ce73, 
	0x9bab2fca, 0x6e806ea6, 0x0fc3a169, 0x5abb201b, 0x176d69fa, 0x12e2cbf2, 
	0x91217d17, 0x7ee03ec5, 0xcfdabe68, 0x0beefda4, 0xfc921359, 0x8d30c4d6, 
	0x9bec7cef, 0x62de54bd, 0x81a7c1ba, 0x43f7936e, 0x60b84660, 0x2c3c63b7, 
	0x0784bbd7, 0xb085d7fe, 0x1b78dfdb, 0xb28f7b76, 0x72ff95db, 0xf5ec39de, 
	0x969fa2b6, 0xfca035f0, 0xf1e21fb1, 0x8176dfb1, 0xbf0c0e73, 0xf324fc2b, 
	0xd508cf4d, 0x9e9a96d7, 0xbcf4a29d, 0x8e988679, 0x3417d9d6, 0xd0b79873, 
	0x9d723c87, 0x139f0f6d, 0x1ebb7fc2, 0x91ffb0e3, 0xd219abed, 0xee9eb883, 
	0x4a9bd729, 0xe60edf7e, 0x7e94dd13, 0x52750be2, 0xf02f48d0, 0xbd0fafb7, 
	0xb5b56a93, 0x7a7566d7, 0x7cc6fe7f, 0xf4a3f316, 0xb135f830, 0x7a007f3f, 
	0xc1d6904d, 0xf4dffda0, 0x7101e4f4, 0x55dfb674, 0x07bf979b, 0x587e7372, 
	0xd4fe7804, 0xf9003656, 0xa420373b, 0xcdcb197c, 0xbbe0fc17, 0xda82d3a0, 
	0xc9fd82a5, 0x9720e797, 0x9b846b02, 0x3df849f5, 0xdff7ca47, 0x773c11a1, 
	0x99e642e8, 0x89bdcf8b, 0xa56bf9f6, 0xbe22d9bf, 0xe94a785f, 0x7d72d377, 
	0xfe941616, 0x6bf12537, 0xdf2a8de1, 0xca9b9ea5, 0xcf569cbf, 0x4a7ca997, 
	0xc3fb473e, 0xd9fc96d7, 0x05d7fed5, 0x152c75af, 0x8166ae52, 0x89bcce0f, 
	0x365161be, 0x0cda7f6f, 0x7a0bddb3, 0xbec2fe50, 0xe1f03089, 0x7457f39c, 
	0xcf3f9eaa, 0x7a75833b, 0x27ef08ef, 0x688b8f45, 0xd5d3051d, 0x4f3fb30a, 
	0x9a1ff3ad, 0x97fd733e, 0x97762e84, 0x8f0b57d6, 0xceb02085, 0x17bf979f, 
	0xfd357076, 0xfec72e70, 0x2fe90ea0, 0x408af475, 0x7f1be907, 0xf42a15cc, 
	0xf1e6b091, 0xfdffaf00, 0x71b5d2fe, 0xca0371f8, 0x48ce1a5f, 0x7e0fa97f, 
	0x21e8b3be, 0x0323f01a, 0x80199fbf, 0xb81f3d3c, 0xb864ebc1, 0x2ee49e94, 
	0xf5aa3bd7, 0x43d28092, 0xef21e834, 0x9243d328, 0xf9da8fca, 0xefc87a56, 
	0xfe653f86, 0x598d5e52, 0x8e8dd2fe, 0xb971221e, 0xa03f7f1a, 0x967196f0, 
	0x72bb54f0, 0x14b495c6, 0x0e1466ce, 0x7cbf850b, 0xc587f61e, 0xbd2aefdd, 
	0xd7f35ce0, 0xd9dd32ee, 0xf63fb997, 0x296e047f, 0x8574ddfa, 0x239e7c87, 
	0x48efc2de, 0x326bd0bf, 0xcc8dfa1f, 0xcbf60f87, 0xa70cf67d, 0xcc9cf222, 
	0x74a25e47, 0x5723bd79, 0x2cb8f445, 0xe91b7f67, 0xc9e82e1d, 0xadfa4c7a, 
	0x3732ed34, 0x07a472fc, 0x889c0d3c, 0x705f667c, 0x281fb529, 0xb3cbf7ee, 
	0x87deefd8, 0xbf38e3d2, 0x7da16ef5, 0x04738639, 0x5817d1d3, 0x77af7bca, 
	0x3fa905f4, 0x756fc1d4, 0x2143fd82, 0xb3f78de0, 0x47633df2, 0xed4d285f, 
	0xecd3077b, 0x2bdef2a7, 0x6757d8d3, 0x7868f042, 0x497aa7ef, 0x617d6be8, 
	0xdafa1fbd, 0xf2a0d84c, 0x680f80af, 0xf4afcd3e, 0x9f941245, 0x608ed273, 
	0x9553449f, 0xe2d0ae7e, 0xc7ce172e, 0x3e7979bd, 0xfd2f51de, 0x37efb55c, 
	0x0a15cfd8, 0xd7e5599a, 0x82d7e1d2, 0x8f9d505f, 0x8aa7fe73, 0xf3a562df, 
	0x6f9f00cd, 0x721445a6, 0xed28c16a, 0x724b9b92, 0x005ee494, 0xb77b18eb, 
	0x478f9ced, 0x6177df51, 0xde7e1467, 0x88fa3a6a, 0x85cdc05e, 0x638b84a3, 
	0x2af56fbc, 0xf72d18f9, 0x834c145b, 0xe5598ffd, 0x943ac067, 0x7e82439f, 
	0xd0057ee5, 0xea7df395, 0xa4e15a79, 0x5ef4a73a, 0xab8157df, 0x45fb13d4, 
	0x8f7abb62, 0x4056ff28, 0xf8078f9d, 0xfd9e7c7c, 0xb5a0e82c, 0xa8f43a9a, 
	0x3948f9b2, 0xd7ae58b1, 0xb3d7b25c, 0xe53e92f9, 0x1df69bbd, 0xf74d279e, 
	0xee7a6ec0, 0xff659359, 0x4e8cc6f4, 0x2ef0a49a, 0x8e88fea6, 0xca6213cb, 
	0xe3f228f3, 0xf93fd9db, 0x4d8fe766, 0xb03b71b3, 0xf3e59331, 0x79ce65c6, 
	0xe3bda57b, 0x93b79e2b, 0xba7d0bbd, 0x5eb0f4c3, 0x2fc1ef47, 0xeb97af96, 
	0x4df655ed, 0x07ef6428, 0x264284ae, 0x5b778ae3, 0x5fd9bed1, 0x9c84df6e, 
	0x56cb1873, 0xe326ebe7, 0x72cfb78a, 0x9e46fb49, 0x2ede04c3, 0xae15a4ae, 
	0x81d275a8, 0xf1b3a327, 0xc12f9aa4, 0x5f33c8cf, 0xbf7ecc3e, 0x7bb9f968, 
	0xf71263ec, 0x7e61bc1c, 0x29f159bd, 0x3319adfc, 0xb8ff1c2a, 0x76903a0d, 
	0x03af337d, 0xf9ab5ffb, 0x57e577f7, 0x99b5cea1, 0x07bf33df, 0xfe28f6ff, 
	0xff39bccd, 0x3ce2df32, 0x8caff695, 0xe50332eb, 0xe5effd7c, 0xfbb429e3, 
	0x39f9b9da, 0x2938fca0, 0x8f87045d, 0xa0ac1d61, 0x2ab8901e, 0x20ed97cf, 
	0xc58f97ce, 0xbbcaffa5, 0x0e0564ea, 0x3b0e15fb, 0xe4e0e978, 0xdef87139, 
	0xef0273ca, 0xd69793a0, 0xc1c7b796, 0x7627e967, 0xb79638f0, 0xe1571e25, 
	0xd7bb83b5, 0x56f0fda9, 0x121f0ab8, 0xae0e55fc, 0xfff2a4be, 0xfa53f9f9, 
	0xf15fff6d, 0x97cdefe7, 0x4ccbe271, 0x85cf2f09, 0x9f14c7b3, 0xaeacf5ce, 
	0xd7c25bc2, 0x19770aa3, 0xa81c6521, 0x5df49bb7, 0xf5df4aa4, 0x3e3d9f75, 
	0xee04f480, 0xefafdfff, 0x7d0f523e, 0x5df4a7d7, 0xbbea4a6f, 0xd2ce9e0e, 
	0xaf89cf77, 0xed9ddf52, 0x2ffc2377, 0x6fbd7fd3, 0xdea6efa5, 0x36fbbea6, 
	0xe32df9f1, 0xd4ae2e03, 0xf4391d77, 0x90e4b30f, 0x01f19599, 0x4a037fb4, 
	0xf2509d0e, 0xa6394849, 0x97f603e2, 0xdffc07c7, 0xc87e4b96, 0x9ee72dc2, 
	0xa796fb3f, 0x2b9726cf, 0xb91ce0e3, 0x67e94a7c, 0x26fbf381, 0x3d5c2c70, 
	0xc8e79e7f, 0xa1fff9ec, 0xdffbf1e5, 0x79cede62, 0x27ed4f8a, 0x3e97e39f, 
	0x6bf27ec7, 0xfb41fffd, 0x1e50dc29, 0xf8ebe36f, 0x9d3f7bff, 0xd8fd20df, 
	0x48bd632f, 0xed9e151e, 0xb922cebb, 0xb78ab2f3, 0x29b37075, 0xc4ee0e6a, 
	0x5cc459f9, 0xc52ae237, 0x4d85373d, 0xbd56b65f, 0x1df108b7, 0xd7870fe6, 
	0xfede4d22, 0x8d295b37, 0x8f7b7f5b, 0x835ae3f4, 0x1f439221, 0x6e706b14, 
	0xf83abf45, 0x3369fc89, 0x5f1b738e, 0xde418887, 0xd711518b, 0xa58bbe31, 
	0x0dc7f45f, 0x731bfe52, 0xdee03757, 0xa9347bc6, 0x5f6b1c37, 0x98fc4395, 
	0x0f4c4ebe, 0xa1b1098f, 0x9d35fa41, 0x852beaf1, 0x7a59e71b, 0x12c4529c, 
	0x577be585, 0x9c16bd52, 0x5fbe64d3, 0xec7a758b, 0x3f7077f9, 0x325739d1, 
	0xed56f85f, 0x8fa835ab, 0xe4de6cf7, 0xcfac5f01, 0x77617ba5, 0xba52ffac, 
	0x6e1b4d37, 0x4c9f78fd, 0x39f4abf7, 0xfd29c74a, 0xde9f9517, 0x6feef327, 
	0x0dfe34c8, 0xe540be59, 0xe990de3b, 0xfd5e951a, 0xab7e7c86, 0xf25ef7ca, 
	0x94734e09, 0x9541fca2, 0x8fca92ff, 0xfdd321df, 0xe3027c77, 0x370b0a9a, 
	0x0dbde9fc, 0x6f189f52, 0xfc41b5bd, 0x6fcfb4a2, 0x1cc624d4, 0x9e5c8a8b, 
	0xb53d6dec, 0xc3fcbaef, 0xbab5f165, 0x451522e9, 0xff4a36d4, 0x045f3f20, 
	0xcebac1f3, 0x61bb3c40, 0x53fcbe4a, 0x8ab9df5a, 0x139f882f, 0x9734c707, 
	0x618acf3c, 0x13bc259f, 0xb489ac9e, 0xc73cfd9f, 0x62ddc687, 0x0f21a058, 
	0xc48920e2, 0xf2d910d6, 0xdb99a881, 0x1103cf49, 0xf008cd73, 0x1eb26c3c, 
	0xf81bc087, 0x2f9fb91b, 0xaf316ec3, 0xdc79f8e3, 0x61db91bf, 0xba6259e0, 
	0x1d7e6684, 0x9b9ce4fc, 0x6f2c06c6, 0x5dadda96, 0x2756dc2b, 0xba663775, 
	0x9def90dd, 0xa9a20f52, 0xe8f7a1bb, 0x9dc3bbdf, 0xf0280324, 0x663e3345, 
	0x6bee9f81, 0x0dbe68d0, 0xec7ec5f3, 0x7114dd23, 0x9e984bf8, 0x37eb9fc4, 
	0x8e03955c, 0xeba4583e, 0x89f106ce, 0x7f0574d9, 0xa688ee22, 0xe53d6317, 
	0xd597446b, 0x6633fed4, 0x10d8741a, 0xcfc43914, 0x1c8c1be9, 0x23febc36, 
	0x873aaf57, 0xa125edc0, 0x7956ec5f, 0xd475f38b, 0xf536167f, 0xe7b7492d, 
	0x55015201, 0x3fbdc2ff, 0xbabd51a6, 0x7d0e32f9, 0x18ae8bc5, 0x313fa1f4, 
	0x115f9a09, 0xab2392e2, 0xc4e440eb, 0xce0f0ee1, 0x9eae6af9, 0xcd973ef7, 
	0x79e39cdb, 0xf476fe1a, 0x836ae200, 0x1db5538d, 0x8af22388, 0x9e8847ba, 
	0xffaa6d49, 0xb710ace5, 0xa0de379d, 0x1f601db1, 0x85d67ac0, 0xfb4b2d6d, 
	0xec635f58, 0x5c683ec7, 0xbe23f628, 0x3b875d6c, 0xf970bb06, 0xc43aeae4, 
	0x4c9e244b, 0xca8f6a7b, 0xbf13b07a, 0x61f4a0d5, 0xe938cff4, 0x6d7581de, 
	0xfebeef7c, 0x4bf10d56, 0x0d0e9aa9, 0xe98b7dfd, 0xe0e4cc2f, 0xe0ed516f, 
	0x0e30cbd1, 0xafd93f9e, 0x27a2741b, 0x3d5c3715, 0xc83e784f, 0x4b9a96f1, 
	0x276781f2, 0xc2a0e78d, 0x120d5dad, 0x36be6ab7, 0xd199e7c5, 0x9c798daf, 
	0x6d77987a, 0xe88af898, 0xb1ecd310, 0xdbdc6407, 0x847bc1c9, 0x99e1a0b8, 
	0xe62bf106, 0x4f9c3acf, 0xf0ed04ff, 0x63f135b9, 0x35ef2953, 0x9a13f74c, 
	0xdee2af6c, 0xec0bea50, 0x1d5f8c37, 0x4e88f752, 0xa9ef39f1, 0xfea41bd7, 
	0xa25cb497, 0x39d79cec, 0x77ce75f7, 0xce256baf, 0x3c6a3c41, 0x898f9b9d, 
	0xbcbf44a6, 0xeffd458f, 0xb9d9f129, 0x760dc2d2, 0xd27f39ce, 0x18bfb906, 
	0xa49a9bf4, 0x93537960, 0x3d43694a, 0x43839348, 0x4e0f7127, 0x609e30c4, 
	0x6720292a, 0x5aacfa6b, 0x52a60fd4, 0x4c1ae71c, 0x9fa1b425, 0xc6393df2, 
	0xbf398ebd, 0xf17be394, 0x1fe4e330, 0x8c65f7fd, 0x331e9193, 0xc62de786, 
	0x93e20d6b, 0xd687efd4, 0xc0585678, 0x26cfe97b, 0x1167719c, 0x5d329cbf, 
	0x8bde7223, 0x6fd16fa0, 0x8f3cb0d1, 0xf38c345a, 0xd78946f9, 0x1c45fe34, 
	0xf7949e07, 0xeaefbcf4, 0x3b4ad15b, 0x76343fc1, 0x5fb4c3c9, 0xfd07aa0d, 
	0x0b76e85c, 0xdfb9c470, 0xbefe7847, 0x6ea8042c, 0x59025eb9, 0xdb9cf253, 
	0x0dcc99df, 0x417ecb8e, 0x56addf6f, 0xbf4bda44, 0x7f41bddb, 0xf4878e5a, 
	0xb06f7529, 0x069b51b6, 0xae32592e, 0x0bfba843, 0x24fc55f3, 0x132cf5ee, 
	0x6c9f8967, 0x9f8f2c69, 0x159e6c8c, 0xf7a6f93f, 0xe4f3b47a, 0x98489ebd, 
	0x710279f8, 0x11c7631f, 0x74ed493f, 0x1af9276f, 0x70ba62d9, 0x31b227af, 
	0xf185dae9, 0x93f195ac, 0x3f194cf3, 0xf790ebe9, 0xca977c7a, 0x28b73d7b, 
	0x90ae067a, 0x9bbc7bf7, 0xe3dfbe2d, 0xf3f3a3c4, 0xc8ddb25f, 0xe21ae971, 
	0xd6bcf94a, 0xa6bbe754, 0x9d1df707, 0xa5f18a76, 0xf6dcea3d, 0xade7152e, 
	0x0f51cce2, 0x372311f7, 0x0ef0f8a8, 0x2c516719, 0xbfd65abf, 0x68e251ac, 
	0xa994bfb1, 0x7f6587ce, 0x5b7f43ef, 0x52dfd2ce, 0xb177bef9, 0x7d274b8c, 
	0x8bd2e38e, 0xc6ac5fed, 0xa3d2e2a3, 0x73b8cbb7, 0x8ef887b4, 0x2e354ac8, 
	0xd7cf1ce3, 0x6289e7aa, 0xbf3f087c, 0x25ea51b6, 0x3c702fa4, 0xfd0f43af, 
	0x1bd7194a, 0xf5c656ba, 0xb78dc2ce, 0xd7390f8c, 0x01ea437d, 0xf71cf1fb, 
	0xf60bb50d, 0x8eb780b9, 0xada7c47f, 0x197e3b76, 0x4eccabd0, 0x8a1c87ee, 
	0x87f4543c, 0x2c882ef0, 0x63ee72ee, 0x237021b9, 0xf8e4eb3f, 0x95bdc8ca, 
	0x54eab2f7, 0xd064657c, 0x93fe9729, 0x9ff1c648, 0xcfeff3c8, 0x47c47e82, 
	0xe1efb211, 0x24f6897f, 0x1767f05d, 0xbadb8ef5, 0x9232be38, 0xa895f197, 
	0xa7657b8f, 0x9ff84740, 0x6c73c897, 0x41fa8bb2, 0x7162c8ef, 0xb7a6583c, 
	0x52b1bf7e, 0x09ee73df, 0x47c35e81, 0xeaebdef9, 0xe841f100, 0x5d59ddfd, 
	0x031767fa, 0xbd41fe77, 0xcb1e8b37, 0x95457ce4, 0xb2d3e1dd, 0xe1dd9bbf, 
	0x316c7b1d, 0x787b19db, 0xce17dcbd, 0x8c9c462c, 0xf25ac86f, 0xd96df070, 
	0x11f71c19, 0xc1919d81, 0x9539e2d3, 0xa9cecdeb, 0x19dbb3fe, 0xc656344f, 
	0xbaae10cb, 0x0b81ab80, 0x30740efa, 0x27f3c9ff, 0x6e3963b2, 0xd003f111, 
	0x64db22bf, 0x8ec9409c, 0x63a37695, 0xe2aa07c7, 0xad764a61, 0x59e7a0a8, 
	0xab8064e3, 0x3347a67d, 0xcd5279e9, 0xe8cbc55b, 0x3f299388, 0x3271529f, 
	0x5c7baab1, 0x978d20a1, 0xfe5669fa, 0xf2a670ba, 0x56ec571e, 0xdeebf8e1, 
	0xb22e3dd6, 0xfee54287, 0x460bdc3b, 0x6c7e7c7b, 0xb7dbe6cf, 0xf94b8f7d, 
	0xa50f22eb, 0x2324e22b, 0xe3de56f7, 0xbcaa0c8a, 0x3245d7f2, 0xd8c8e795, 
	0xf92f9ccf, 0x8f7aceeb, 0xdd4bb62b, 0xb7f7541f, 0xfde4bb62, 0x0ef11d2d, 
	0xa8e5b3a3, 0x1f1dbe77, 0x12690cb9, 0x37648161, 0x0e471a66, 0xef364d22, 
	0xb0bf41f1, 0x9415c8c4, 0xefcc9c5e, 0xd89a7088, 0xbbcf724b, 0xfb81ded2, 
	0x3d5cc6dd, 0xd924fac1, 0x63571c8f, 0xffd1fb48, 0x5278beae, 0xbf1bb72b, 
	0x5f7c4393, 0xdda54ff0, 0xc4a89b58, 0x8b4ac091, 0xdc60c6ed, 0x1031bb64, 
	0x31a3f296, 0xdf46ed21, 0xdfb8d7c7, 0xc807cd45, 0xb222a44e, 0xe409e91b, 
	0xac33f4fb, 0x86e0fd27, 0xec97ee26, 0xf7f05ad9, 0x2de89cfa, 0xdfa79bde, 
	0xdecc47fa, 0x0b783de2, 0x5cf3a3f6, 0xbfafa5c6, 0xbc4b9e81, 0x9f5e5c65, 
	0x80fb1cb6, 0x9fa399f7, 0xd91ddd50, 0x40def8a7, 0x5a4de82d, 0xdbd00ef9, 
	0xa50debd1, 0xbcfa3bd7, 0x17b60961, 0x82ef3b6e, 0x96fcf404, 0x9baceabf, 
	0xd6eb4f47, 0xcfc0075a, 0xf2917f75, 0x2c724fc0, 0xd63db16a, 0x47eb293c, 
	0x87515cce, 0xb227216b, 0x8cb7f722, 0x6407c3f4, 0xfbf50afc, 0x179f4954, 
	0x6fe3d496, 0xd72d2f3b, 0x9e0e4b41, 0x3d0824a6, 0xfc50e48d, 0x349e7d8b, 
	0x9cc36fcd, 0xd0af4c95, 0x8527b4aa, 0xc67bb87d, 0x5aa914b5, 0xf4bac29f, 
	0x7018fce9, 0x3e74efa8, 0x093dc429, 0xf59d8729, 0x2b961bf1, 0x1749bd07, 
	0x6937c45e, 0xe326b766, 0xdf2d6c9b, 0x6f1faa54, 0xf8d09f5b, 0x8c96073b, 
	0x3f2532b3, 0x789c0b88, 0xb8e5e11c, 0xbed265a9, 0x710f559f, 0xb87a6566, 
	0xac7f7e0f, 0xa1259a4b, 0x8fd25a08, 0x86bb6f1c, 0x39201be7, 0xddb2356c, 
	0xc5dd61a9, 0x27ec9605, 0xbe09fb29, 0xa8ea7edd, 0xdc99449d, 0x7154935e, 
	0xe0dd5b26, 0x4965c0e9, 0xb972b715, 0xbeb25bcc, 0x2ddbb52f, 0x977ca65e, 
	0x1a081b8c, 0xd5079716, 0x0d2611b8, 0x52760f9c, 0x5dcfcf3e, 0xe9482bd6, 
	0xdd73dc7d, 0x520627d0, 0xc99f9b90, 0xa1a3ef41, 0x425d5bd5, 0x19e6540d, 
	0x1e3d9437, 0xb78df354, 0x5fe7867d, 0x0d889b70, 0xe8773e28, 0xdd68d850, 
	0xe8958da6, 0x0aae2261, 0xd15ae876, 0xf82fae5b, 0x37f72dda, 0xcea69ef1, 
	0x23cb75fb, 0x5b759ce5, 0x8192fd18, 0xe2f8b50e, 0x7909adb6, 0x3f4d7e4f, 
	0x45d83ef8, 0x17da4722, 0x6f1961ee, 0xe73907d0, 0x3ec4275a, 0x7996fc01, 
	0x6e0abf07, 0xd427719b, 0x403b503d, 0x4d8a3d74, 0x2fef3b7c, 0x8e02c177, 
	0xf87f79e4, 0x7c63a556, 0x1121e6bf, 0x173c5c87, 0x9b79ec7e, 0xe005f1f8, 
	0xedda2f47, 0xc0031b73, 0x79c82f8d, 0x8152bd8c, 0xe78f811b, 0x1c05df6a, 
	0x05c1deb8, 0x7eb4de79, 0xda27c925, 0xe7397f0f, 0xdfeb84d1, 0xbc11fc4a, 
	0xf846ed29, 0x791e6950, 0x37f00177, 0xf395cbf7, 0xf3e6f3d8, 0xce6de278, 
	0x7139df63, 0xc1c49f70, 0xf9e5df23, 0x838d573c, 0x17ff25cb, 0xd80fe5ef, 
	0x4085c033, 0xb01337db, 0x78a98eab, 0x3707e228, 0xc3b20bef, 0x984fff59, 
	0xf287c46e, 0x7a48b6fc, 0x8d811e60, 0x4d5c6b53, 0xbf93e798, 0x264fee17, 
	0x56fefea4, 0x59de7df3, 0x7df359b7, 0xe4dfae5e, 0xefd16af7, 0xa06ef9ac, 
	0xbac31af5, 0xe3ca71f5, 0xda65bd66, 0xee283c0d, 0x7567e56f, 0x87fd87e6, 
	0xf2c08df3, 0xaa46d3b1, 0x740b9ef4, 0x7ed6ff59, 0x2d37df81, 0x8e73b46c, 
	0xc27f619c, 0x02e7a685, 0xe9fb646c, 0x5c8cfe0a, 0x0316c568, 0x3847e1af, 
	0x1b953489, 0x9bfb61ec, 0x2bbe07fd, 0x254c1ed3, 0x1fd9319c, 0x7f4a4811, 
	0xd0bbfc04, 0x4bf0026b, 0x60bfc14c, 0x971c7134, 0x3a044ff2, 0x0ee05aad, 
	0xfffeb295, 0x09339cea, 0xbf38dbf8, 0x470e9ca5, 0x94de7e98, 0x55f1e395, 
	0x8e2f57db, 0xfbc7cbb8, 0xa865fbbb, 0x2cf1f047, 0x68bd8cbf, 0xb6f8c832, 
	0xf1e845e8, 0x715beed7, 0xbf2e76f1, 0xf0edc5e4, 0xc09a240f, 0xae268687, 
	0x24afadfa, 0x42bf1da7, 0x7cc3beb5, 0x24ce738e, 0x3dfb24e1, 0xea4adad2, 
	0xc96d67ef, 0xff5bec26, 0x173cfb15, 0xce376703, 0x9e783bb8, 0x54bf06b6, 
	0xcbe4ab5d, 0xc1a5af68, 0x49374a2e, 0xbf29dabd, 0x6bf249a0, 0x1b77f29d, 
	0x753d5556, 0xafa6a3bf, 0xa09dfcb2, 0xf653de33, 0xf5533874, 0xf48f2a9e, 
	0x8f6a5a58, 0xfa845f2c, 0x750ebeca, 0x1dafd657, 0x1dff18b6, 0x29e58afe, 
	0xec2942df, 0x4f220fb4, 0xfa406f2a, 0x96adf119, 0xfbf24d55, 0xed2b7544, 
	0x5e7c6dae, 0x6123eb60, 0x400f6bf4, 0xa47bac5f, 0x7769da4b, 0x17d82cfa, 
	0x17faa55f, 0xaee2bce1, 0xd00db77d, 0x226c2afe, 0x4cfbc5f9, 0x450c9d30, 
	0x76da7f0f, 0x407fdf63, 0xbf29cb8d, 0x98e249aa, 0x4de4e8a1, 0x7453d555, 
	0x965475f2, 0xa7f15fbf, 0xe811e8a1, 0x954f7aac, 0x4eeda6eb, 0xd072c935, 
	0x0a7450c9, 0x27d65576, 0x7cedc73b, 0xe5cf89f7, 0x79ff29ba, 0x9c27414a, 
	0xf3cb75df, 0xd3271a3c, 0x09d016e9, 0xd714acfd, 0x6c753a2b, 0x65fb97bb, 
	0x91b7193a, 0x355c2174, 0x00be9d14, 0xd77d513a, 0xe001aacc, 0xeeea71a6, 
	0x21e7bc1e, 0x80fa00eb, 0x1ef93411, 0x7beea1ac, 0x1ef47286, 0xb63d87fc, 
	0xb5de3947, 0x1647b09d, 0xd279fd9b, 0xeca743bf, 0xfc137e5c, 0x5a9e634f, 
	0x4dc3d71a, 0x2a8adf52, 0x137e3efc, 0x2fb8f5d9, 0xf6c99b7e, 0x79e9e7fd, 
	0xf5ecef53, 0xfd24ded8, 0x80f94e33, 0xf5eadbe2, 0x5aabd628, 0x3efca70f, 
	0xebd5b7c5, 0x6aaf7c51, 0x68be503d, 0x387af67a, 0x88f59df5, 0x8785240e, 
	0xd0f50bfa, 0xae9bd8f3, 0x0747df0f, 0x62be71fd, 0x8c06336c, 0xe8379cbc, 
	0xaeb9dc62, 0xaf3e21e7, 0x328f59b0, 0xfeb99d4e, 0x9fd63efe, 0x72c2fbf5, 
	0x8d07215d, 0xe4626395, 0x4d6bf510, 0x67f6dddd, 0x72cab7a8, 0x5b735dce, 
	0x9348f885, 0xa1848ff4, 0xee3865b7, 0x60be0dc5, 0x2f414ffe, 0x0b712bda, 
	0xc1fb137a, 0xdba45e94, 0xe20fbe1e, 0xd94241e8, 0x941e8eff, 0xa076afb9, 
	0x540e4ca1, 0x4c6f37fb, 0x20ef434f, 0xeca3d795, 0x79da4d54, 0x8ed99fb4, 
	0xcb58f475, 0x2fc51bf3, 0x18776107, 0x85a7d726, 0x0b7c003c, 0x90793f5d, 
	0xae706bbf, 0x3c89c37b, 0xb230addb, 0x4f473e31, 0x7faa0828, 0x07efb28d, 
	0xe33beaca, 0x3d636c4f, 0x4d3a780e, 0xfdb97def, 0xe0e1c629, 0xf6399355, 
	0xd1d35f77, 0x33843a0f, 0xce7bcfc4, 0x57a6c386, 0x67d930e2, 0x7cfbc38c, 
	0xda7ec9f3, 0x967df6d0, 0xd22bfe4f, 0x701756be, 0xa09bcfb8, 0xfa6b70b4, 
	0x7981e834, 0xf43b7a3a, 0xde427087, 0xdf892213, 0xacc2f7cf, 0xbf87e93f, 
	0xc33998c9, 0x67b7e7f2, 0x0a45846a, 0x03d6086c, 0xa5c06dd1, 0x7b2ae7cc, 
	0xc536de20, 0xca0847e3, 0xbce02e33, 0xfed04f63, 0xda1dfda4, 0xb2547a44, 
	0xd8709f44, 0x265ce376, 0xec8ec9b4, 0xba1c3922, 0xcde5f681, 0x876627b8, 
	0x89d7da0c, 0x131e7966, 0x23b1ddbe, 0x5439f10e, 0xe1cec1b8, 0x01d1287b, 
	0x881e17e2, 0xc32f9fd5, 0x93edd0eb, 0xfd834f1c, 0xfd8cbd6e, 0x0870724f, 
	0xcdd27bfb, 0xccd13ddf, 0xc3cfb055, 0x3dcce4e1, 0xb43bdc3e, 0x2935be65, 
	0xfbe41dee, 0x97e72688, 0x7d7bf526, 0xf06f0f7c, 0x578919fe, 0x7eefd916, 
	0xd5f4171a, 0xc437ed10, 0xb4f31543, 0x4cbbf9ef, 0x2aa3be4e, 0x6faaae9f, 
	0x653be556, 0x4c9750fd, 0x079017c1, 0x3bdc0fb4, 0x9d5671cb, 0xec0d91df, 
	0x7ed17ac1, 0xe91db374, 0xf71fb93d, 0x2196c257, 0xd0e5ce70, 0x4f8860af, 
	0x5bacbfb3, 0xfd6911d9, 0x30f3d6d3, 0x9fb97523, 0x9f4fe932, 0x79d97f75, 
	0x4e865fde, 0x8cf442fc, 0x77150ce4, 0x138f3c2d, 0x3e005fbd, 0x255a7d62, 
	0x78f839be, 0x23c4b351, 0x2cd53ca7, 0xf4ac31f1, 0x8b1f0752, 0xdcb2e2f5, 
	0xfca747c1, 0xbca59b8f, 0x3a49ee72, 0x4f7c58f8, 0x88f83b95, 0x73a3e072, 
	0x47c1d26f, 0x796cfea7, 0x79ff3845, 0x04fa9f75, 0x719b03f4, 0x81e9c689, 
	0x2cde5abc, 0xa5787ae5, 0x5c9b63b5, 0x3eeb29ff, 0xc3f66bf4, 0xaf5c8d3e, 
	0xabc94cf8, 0x791d9abb, 0x79072675, 0xe6753a15, 0xaaf2e58b, 0x829defd8, 
	0x963e87eb, 0x531d1e9e, 0x700cb2fe, 0x23bfaba6, 0x8e97da50, 0xb47c8b3c, 
	0x28113fa7, 0x6f593efb, 0x47d9deba, 0x8cdddfc8, 0x377c7180, 0x5e43f690, 
	0xe52bdf3d, 0xffef259e, 0x10af1078, 0xf78e7251, 0x1fb4ae45, 0x10d3d70a, 
	0x07710a77, 0xf9c093b5, 0xdbbc9567, 0x94e7e8ac, 0xfa966a6f, 0xde4ab447, 
	0xc955eb15, 0x23fca73b, 0x55a33d6a, 0x5ef8aef2, 0xacdbbc95, 0x255a33d6, 
	0xad5736ef, 0x928b6467, 0x7e7a1977, 0xf3bc857f, 0x51ab6f40, 0x9f4d5b7a, 
	0xad28df5c, 0x9fad5e5f, 0x4379c861, 0x3cee85de, 0x7972c5fc, 0x77753a17, 
	0xf69efb1e, 0x047f4cd7, 0x123a25f3, 0xde4aa37d, 0xbca57a45, 0xbbc9550b, 
	0x3cf2cdd5, 0xdbaf1aa8, 0xce34eeb0, 0x7a62c3b6, 0xdb7bad0f, 0x547a62ab, 
	0x2f18b1e2, 0x68e75fb3, 0xc5c07dab, 0x10ccc1c4, 0x5439a9ec, 0xfc257e0f, 
	0xbeeccb86, 0x3f4d2b39, 0x6139beec, 0xe5af9ee7, 0xde2539c3, 0xb6a87dc3, 
	0x76c7cb01, 0x4731ce28, 0x7a79fbe4, 0xe16dadbf, 0xbb87bab4, 0x44377e42, 
	0xcf9cf7e2, 0x54dda686, 0xf8abb89e, 0x2a45d17d, 0x06ed891e, 0xc15dee61, 
	0xb498dddf, 0xf9bc812f, 0x9e4279f0, 0xc8f3aa6f, 0xf7f95844, 0xcf492e70, 
	0x4ebe6a63, 0xb50d0dbc, 0x0fe6513e, 0x7ea2e989, 0x4065f954, 0x4ba226ef, 
	0xdae52936, 0x135fd44b, 0xa6f949c6, 0x3d9bd301, 0xe24f1a5a, 0xc700d4e0, 
	0xe0e91c47, 0x79eadff3, 0xc91e61d4, 0x5bef71f2, 0xeb57ed21, 0x801efe12, 
	0xf19c73b2, 0xf1e5f33b, 0xbf57fe93, 0x7447e697, 0xbbf2913f, 0xd9ae1fd9, 
	0x3a9b8835, 0x8f1359a1, 0x4b0bf05a, 0xb553177a, 0x7c525e0f, 0xa4a50cf4, 
	0x281f8879, 0x345df5fc, 0xc3fc2375, 0x7fa48bbe, 0x189e77d8, 0xf396b9de, 
	0x8837deaf, 0x21f37c54, 0x21992f89, 0x3fdf17c2, 0x88cd3ad2, 0x4c77cfe2, 
	0xbe280f18, 0x45ffff64, 0x777c5e63, 0xc65177c6, 0x4e9887bd, 0x5343fb53, 
	0xff0e81e7, 0xe3c6af3f, 0xfec6cb8c, 0x48a7f4a3, 0x75b8f0b7, 0x7b0637be, 
	0xdf298ff2, 0x102c4d66, 0x3bdf2b67, 0xef52df31, 0x8ef3c6bf, 0x7f707af8, 
	0xfee38c70, 0x39dd2d3c, 0x4f7a93a6, 0xc7d5377b, 0x0b8f35c0, 0x2e69a9fc, 
	0x85cbd389, 0xfb3b251e, 0x6aff6715, 0xfd4e596e, 0x2cc7a144, 0x38f0fa15, 
	0x7b013bb7, 0xf113e68c, 0x33f52c9d, 0xc724ffbb, 0xed3d1077, 0x70bff31c, 
	0xa72efbe1, 0xa86ffb54, 0xe53d12f9, 0x379e8373, 0x5d139e95, 0xece27965, 
	0xe32f21ef, 0x710b842a, 0xefc6620d, 0x89097be2, 0xe7e519ec, 0x2880b446, 
	0x043c9d04, 0x637fe52a, 0x7fbf299d, 0xc9d5785b, 0x85bafbcb, 0x7de76d17, 
	0xe14c3efe, 0xd82f2769, 0xa6f85ecf, 0xdfcfbced, 0xc57c297f, 0x6afe0bc9, 
	0xc898814e, 0xf0d4ff39, 0x27939b7c, 0x5df9e292, 0x70f4de4e, 0x73ca56fe, 
	0x935bb6fb, 0x1df02beb, 0x917ba455, 0x91ad278f, 0x526ba0d5, 0x37c42de4, 
	0x35debfd9, 0x40c1c253, 0xaefaf58d, 0xd40c5c32, 0xcf15339b, 0x151bc51b, 
	0xdfb7cfcf, 0xd0be78a8, 0xbf91553a, 0x15dffcdc, 0x6fc42bf9, 0x9adfde2a, 
	0xb5eeecf9, 0x7c9727b8, 0x24513775, 0x79b9bde0, 0x37f0e5f7, 0x27bbef65, 
	0x7f89f182, 0xfd9f1cad, 0xb3e395af, 0x37c8ad5e, 0x1caf3f9a, 0x1cae989f, 
	0xf15d3d9f, 0x17eb72fc, 0x7f33e395, 0xeb3e3959, 0x31be350e, 0x9d573e39, 
	0xf0eadf1c, 0xcf8c11f6, 0xf8e561fa, 0x8e551fcc, 0x2553fc4f, 0xaa7fecfd, 
	0x52f59f1c, 0x1fccf8e5, 0xfc4fd257, 0xf67c72a4, 0x67c72a4f, 0x4f8d5c7f, 
	0xf1883ddb, 0x1f76f84d, 0xa15cf8c2, 0x7e39fafb, 0xf8e558ed, 0xf1caf1c4, 
	0xc72bc7d9, 0x1ca89d67, 0x952ff99f, 0x54af13e3, 0xa57ecfd2, 0xc9d67c72, 
	0xb1d6fc8a, 0x577c6a2d, 0x0dcdf1c9, 0x8c4dfa48, 0x3506276c, 0x3f3ee45b, 
	0x2687df0f, 0x682f387c, 0x6fce230f, 0xb709ca0d, 0x193caa92, 0x56be5c14, 
	0xef879f95, 0xc87ea346, 0x75f2823e, 0x2aa49daa, 0x9704864f, 0xf3faaa77, 
	0xe7a7f7d4, 0x676e2d05, 0xaedfaa83, 0xda0f6fda, 0xa8df2843, 0xefa9e7ca, 
	0x590bcf52, 0xaa9fcedc, 0xfb55da76, 0x49fb21ed, 0xed55cf94, 0x09cc8606, 
	0x0dcde3c4, 0x57d8c39a, 0x1e322d03, 0x75eef9ce, 0xf6e2d05b, 0x43567f89, 
	0xe7ab0fde, 0x733f5573, 0x43f72643, 0x09dfc57c, 0xe7cab573, 0xf3afd148, 
	0x90b6ec9d, 0xad5efdc5, 0xb54739c6, 0x7268273f, 0x71a8d7fb, 0xe179ab36, 
	0xef28cdbb, 0x76abea76, 0x6e4c84e6, 0xbea77ae7, 0xc873579a, 0x1bf28c3a, 
	0x6aab7954, 0xb82835a7, 0x3b551bfd, 0xdf1caa4d, 0xc679468b, 0xc1daafa9, 
	0xbe51acf7, 0xcaafa9c9, 0xb726429b, 0x374552df, 0x7419977c, 0xf516ebfb, 
	0x1cf52afd, 0xa72e97df, 0xdd1557db, 0xf03cd45a, 0xa337e67d, 0x4bd5425b, 
	0x5bd70484, 0xa8d3c6aa, 0x9f77c7da, 0x6a47fe51, 0x8e5571fc, 0xbca355ef, 
	0xaa379543, 0xf6431a76, 0x532f9421, 0x7955c4ed, 0xfcb8243c, 0xa0de5562, 
	0x42ef83e8, 0xaa9dfca3, 0x8e553a9d, 0x3ca113ef, 0xf457d4ed, 0xdc590869, 
	0xbea772ce, 0x39f7c72a, 0xdeaf5e50, 0xef86e877, 0x3f6e834b, 0xa9897450, 
	0xd23be3f1, 0x5e7b74e5, 0xb55eb5d1, 0x0f321f57, 0x62dd19bd, 0x90b15e6a, 
	0xd426fdc5, 0xfb556a78, 0xca373ef8, 0x23f8d59b, 0x20915c6a, 0xde54dbe9, 
	0x556bcaaa, 0x9321b53b, 0xed5369db, 0x2238d444, 0xca00f321, 0xa1beaa93, 
	0x828231da, 0xeaa79fdb, 0x61bf5587, 0xca8cbf7c, 0x4372abe7, 0x048463b5, 
	0xb540bfb7, 0x86fd5613, 0xafdb8243, 0x7c37e2a9, 0x7b741e2f, 0xa42dd143, 
	0xa37be5fa, 0xad3b7465, 0xdaa356e8, 0x07d909ab, 0x90b746ce, 0x3fe2071a, 
	0xf9575cf0, 0x671be242, 0xb8c10e38, 0x10b0f184, 0x09717954, 0x6fc2f10b, 
	0xf3e19df6, 0xbe5f754a, 0xabcaaaf0, 0x1785f2fb, 0x49fd6467, 0xe55a7f95, 
	0x9bff556d, 0xfabeb233, 0x2be154de, 0x9ea63f2a, 0x79e5a68f, 0x28a38aa7, 
	0xf579536c, 0x86fc2a3d, 0x508f40b7, 0xa4ae2ae5, 0xd1e52b70, 0x0423f28e, 
	0x300ccfce, 0xae4c2f8e, 0xfcd10fcb, 0xe821ecea, 0xd49d7ab9, 0xe58f7573, 
	0xf5ef77c6, 0xdb5cc6f3, 0xe8ad485d, 0x773d4b5f, 0xc311cb3c, 0x6222fcf2, 
	0x851ef826, 0xf10f3aa8, 0xc13dd45d, 0x21a683f1, 0xf7ffa106, 0xa8fecfde, 
	0x7f1571e8, 0xcfe32336, 0x972c4f72, 0x657597f5, 0x99fc7945, 0xa8db378a, 
	0x663037f8, 0xbca71ebb, 0x6e7de3fb, 0x21e8f39c, 0x3fa4ffd2, 0xeb403c43, 
	0xe59a89f9, 0xd73f88ad, 0xaf965457, 0x9eb4fbc4, 0xa3bdf23f, 0xde75cf95, 
	0x75eb82b9, 0xb4e4ac75, 0xba1bceda, 0x7c456cc4, 0x8663606e, 0xe7aa84e3, 
	0xe0ffc425, 0xff6f9e73, 0xd1c541a4, 0x5ff384fd, 0x9bc369fb, 0x7389d1c6, 
	0xd75dcfc4, 0x571e1efa, 0xcafad741, 0x420aa2e3, 0x8dc07ca8, 0xe53a0ad7, 
	0x613cfdcb, 0xe62c9fe9, 0x33795583, 0xca178a6d, 0x373383f2, 0x1a839f95, 
	0x1f859131, 0x764a4344, 0xcceb76b1, 0x8a87cc4d, 0x74aeb43f, 0xcabbfca6, 
	0x57951ada, 0x52da59f1, 0xd49f83ca, 0x937876f9, 0x4196f6c1, 0x87e236fa, 
	0x509719b4, 0x7a36bd7a, 0xc6a1fa54, 0xad3dfca9, 0xbf856d1f, 0xc54fe8b8, 
	0xfe9452b8, 0xa93793fd, 0xf14baeb8, 0xbf9c677f, 0x82dfd98e, 0xa475f1ff, 
	0xd7d7ce34, 0x7e49be9d, 0x89ab9007, 0xca9733d7, 0xfcab7571, 0x71ca9755, 
	0x5dfcaaf5, 0x2979df2a, 0xbad7fb8f, 0xfb45a97d, 0xbe3575f9, 0xa5d6eb5f, 
	0xf4083bf8, 0x5a51d2f0, 0x8cb4bdbf, 0xf7f20f1c, 0x1f826e67, 0x4eeff606, 
	0xb91c23e2, 0xaef6af82, 0xaec377a9, 0x34c8f947, 0xf995b3e6, 0xf864ed88, 
	0x99fed60d, 0x4a3ee57b, 0x47e991af, 0xf9e1ef5b, 0x92df3216, 0x14abb7e5, 
	0xbd543af5, 0xcd9d928e, 0x3d543af5, 0x64975da4, 0xdfc76eb0, 0x5bbf9475, 
	0x160ff8e6, 0xe4044d76, 0x62c520f7, 0x4b70fe03, 0xe213c3f9, 0x1715f831, 
	0x2096ba75, 0x0eed1e4e, 0x3adaa2f7, 0x6abc1f8e, 0x53e4bb5e, 0xe2ae5df5, 
	0xf78abc77, 0x5b7ee494, 0x9637e170, 0xfcfca4ac, 0x67c5eae4, 0x76be07db, 
	0x2532e3b2, 0xbf24533b, 0x6f4be320, 0x677d44ba, 0x7f9ce7f4, 0xb8ab3bf6, 
	0xef2d71fe, 0xc775bec2, 0x30715c7b, 0xcff3acf4, 0xf38ad6f1, 0x09f69d4f, 
	0x1df8b5ec, 0x80b5e982, 0x42b56252, 0x7e6437c7, 0x298f4c8d, 0xd3b1ea7f, 
	0xaf53932e, 0x5685f4e0, 0x4d3fbf69, 0xffcd0769, 0xbd9da528, 0xa9741f88, 
	0xd75b66f3, 0xcdea5e70, 0x71f9065e, 0x67a5b4ec, 0x7c6b57e1, 0x6d5f8758, 
	0x939e55b2, 0x75644bcd, 0x0e7a6749, 0xbe96e83a, 0x3d5fccb3, 0x2370fe2f, 
	0xe3c47fbe, 0x1ce350ec, 0x8c4f5b2f, 0xb78d43b7, 0x857f7663, 0xd3c54ba4, 
	0xfd38f1cb, 0x38a5addb, 0x4927ee01, 0xf67fb8e3, 0xbd610e38, 0x78cb3b5e, 
	0x0dc92e1a, 0x6bda897c, 0xf7c75d7f, 0xc6bde878, 0xf8d2faec, 0x679d719c, 
	0xe339f9c8, 0xcd5b8e2b, 0x8469fa87, 0xe89bfaff, 0x9f2a76e7, 0x4fbf495f, 
	0x4f6f087a, 0x79d5f6c8, 0xfefe6ecc, 0x46ed6e9e, 0x6bd5145c, 0xb89af3e4, 
	0x951b9be4, 0xb1a6f31f, 0xa3dfc13a, 0x0dddeef2, 0xd34df77f, 0x9f800ef3, 
	0xe85cf78a, 0x968ff6d1, 0x689747e5, 0xfca24f5b, 0x3f5ca7e4, 0x2ccc71a5, 
	0xd3a57197, 0xa0c825cb, 0xd4fef2ff, 0x81fa10f9, 0xf471b9fc, 0x75859cbc, 
	0xdf215e18, 0x7bf056b3, 0x1c6f7cce, 0x3e86d16b, 0x315dbb3c, 0x31f324f3, 
	0xbbf8fd62, 0x7f00894c, 0x38942eff, 0x9fec29f3, 0xe15e7fa2, 0xa37a786c, 
	0x9968fa18, 0x28bbbe5f, 0x9f183d97, 0x27b85fd3, 0x50bf1029, 0x088fbfed, 
	0x93dac715, 0x4b260f11, 0xfb52dbfb, 0xa79fb8ae, 0xb5ff8e4c, 0x7c6425b7, 
	0x0f9df404, 0x5985e296, 0x8fbac36f, 0xbbf8c78b, 0xf08f683e, 0x6a7f0aec, 
	0xece0e2c9, 0xe16ebefd, 0xeaefe4ff, 0xfbbf6b1d, 0x89ddfbac, 0xb5ca2d7f, 
	0x2e9947ee, 0xc8173b1b, 0x9629e6e7, 0xd1f95f83, 0xdb8f1e0a, 0xde0ef190, 
	0xa989c236, 0xd9ddfbd9, 0x76b5d7e7, 0xdf7de1cc, 0xf3e5fa21, 0x9bdf175e, 
	0x06acf6f4, 0xfb6b1f1f, 0xa27e1e7a, 0x9fee6d35, 0xdc09bf2b, 0x70f94568, 
	0xc7ffda99, 0xc34bf5df, 0xf9709448, 0x38672332, 0xe197a8f8, 0xb165bae3, 
	0x7faf10c7, 0x44bdda45, 0x0798f857, 0xc23fbb3d, 0xebbfd4f4, 0xdc7c5379, 
	0x496db5d0, 0x0f55e91a, 0xf3beba71, 0xf5c9c669, 0xe9c47e1b, 0x9e7aeb60, 
	0x61b9a74f, 0x77ca7cf1, 0xa715765e, 0x9f087c8e, 0xfd84f84f, 0xdc9a9ba2, 
	0x31e3822f, 0x667db58e, 0x6325d32d, 0x5a95fdf1, 0xe2074ce3, 0x08e67b88, 
	0xbbb05efe, 0xbac3912e, 0xdf34fbf0, 0x73a8e71b, 0x17997a99, 0xc7fb165d, 
	0x5e503f50, 0xf6b9653e, 0xef3e72a8, 0xcef2a889, 0xa21ffaca, 0xf8527a14, 
	0x73fcf41d, 0x57ec8ccc, 0x94e7b62b, 0xcbeb969b, 0xaf3e3dea, 0x67b554b9, 
	0x83da2ae6, 0xf7bf241e, 0x553efea9, 0x28707247, 0xac50f1c9, 0x29a6d5e7, 
	0xdbe17c4f, 0xf9669e9e, 0x89f7166c, 0x9c6af71b, 0xeb458bbf, 0x6a39c59f, 
	0x7d69f948, 0x21cfc4eb, 0xf9ba1d97, 0xfb6212bb, 0x5ddf65cd, 0x1db432ef, 
	0xbea1b388, 0xbd4d7fb6, 0x8adae34f, 0xfa4e11f9, 0x5d3becd6, 0x3e44b7ae, 
	0x4172ed36, 0xda58fd4f, 0x3f87170d, 0xbddc736c, 0x62cac07f, 0x5174f9cf, 
	0x4ddde32f, 0x6d7c1fd6, 0x14d9d335, 0x5c64fb3b, 0xfb87f2a2, 0xbeb18e57, 
	0xb06aa3e8, 0xfc6e5e13, 0x7e44d64e, 0x8d7a798d, 0x3f7977c4, 0x09d1c681, 
	0xf49ae13d, 0xd475c869, 0xc574f8c3, 0x32777ac7, 0x21709db7, 0xba063908, 
	0x3b687775, 0x796f9ea8, 0xfc3869df, 0xa353dc74, 0x3d3f45f1, 0xff100eee, 
	0xf791cd8c, 0xfa6b7d27, 0x6e325b4e, 0xb2fb85cb, 0xcdec0fa1, 0xb1c21ee1, 
	0x47bf16cf, 0x285ddfc8, 0x9bc5fa7c, 0xb84b0010, 0x1e61c993, 0x2df99a3f, 
	0x90b123cf, 0x5bca3714, 0x757d0794, 0x0ea5fd8b, 0xd623055e, 0xf09f9c1a, 
	0x7d3de9b8, 0xc0d75cbe, 0x1bf1c580, 0xd3d31bc1, 0x1912d738, 0x84e7e321, 
	0x5ce39ab5, 0x5b3464ff, 0xbf876e71, 0xe999b58f, 0x1c7f0391, 0xf8d37f02, 
	0x9c77e043, 0xbcf67723, 0xf6a8f457, 0x30ff8e89, 0xe9579e47, 0x748a5cea, 
	0x7a88f73d, 0x3e5e502f, 0x547bdc25, 0x9c3ee239, 0xb3a2b77b, 0xc541feb2, 
	0xbbf2bae7, 0xc1b89ad3, 0x9cf6c5b7, 0xbfb85372, 0x1c43deac, 0xf3fcae8d, 
	0xb45774c2, 0x9d043e07, 0x0ce7e042, 0x71d29fd6, 0x7d728f49, 0xe390f899, 
	0x94ef835b, 0x3d0e0d71, 0xc47edf40, 0x2cad464b, 0x89cfcbe8, 0x109f89fe, 
	0x13dd693d, 0xd1c61cea, 0xbc7e5afb, 0xfd413077, 0x9c9f3f37, 0x6cab1a6e, 
	0xd45bf3e7, 0x84f39c73, 0xd59edf4d, 0x31db3e94, 0xc5fbc4dd, 0xa06e21f4, 
	0x8bf179e9, 0x9f84b26c, 0xc29307cd, 0xa1a5f343, 0x95770c35, 0xa749bcf8, 
	0xfb9479fa, 0x5e7a3ca4, 0xfea11e9c, 0x6b325e9a, 0x3f3eb482, 0x9fa9539a, 
	0x792d8734, 0xc4f9fb1f, 0xd7f51ce9, 0x20d8ccf4, 0x0ff343f6, 0xd8d6d3cc, 
	0x73f2f9ec, 0xe1f0a71e, 0x7ef3597e, 0xe397b7aa, 0x1facb2d7, 0xbc0f0a51, 
	0xb77dcef6, 0xd3263bdd, 0x7db8d978, 0x6f909fc4, 0xd92d8748, 0x5535f66e, 
	0xefeaa53f, 0x793ff3e5, 0x7e597fdf, 0x192bef82, 0xbc878cba, 0x2777f680, 
	0xde9893be, 0xbc2af7cf, 0xae382727, 0x4ee791c5, 0xf249aedc, 0x1a99f919, 
	0xbb209b8e, 0xd9d6d3ec, 0x263bdbce, 0x77c41e39, 0x0e1be251, 0xf89c63bf, 
	0xff42f7f5, 0x4e7f5cb5, 0x2737bff5, 0x70f906d2, 0x164cfdac, 0x89a7f1f4, 
	0xf2ca7bc0, 0xe5d316ef, 0x4433c3e7, 0xea6bcf67, 0xa0eef039, 0x435d9ddf, 
	0x47aa3ae9, 0xefe18bf3, 0xee507d9a, 0xba5b9627, 0x7b2bcb9d, 0x5a7f7e5c, 
	0x9484c7c6, 0x4eed15de, 0x9f61f01e, 0x86fd537a, 0xc7eb973c, 0xba98967d, 
	0x96335d5f, 0xfcf40314, 0xf617bcf8, 0x19a3a703, 0x71049df9, 0x7a003981, 
	0xc6498787, 0x7dd4fad1, 0xf7007bbe, 0x7d836a9b, 0xcdc27903, 0x4dda4f98, 
	0xeb06c3b5, 0xc486b551, 0x4351dae5, 0x14bc7aec, 0x4be850f7, 0xd53d31f7, 
	0xb0c28fbd, 0xb2efabca, 0xd27387e0, 0xbf875d22, 0xa10c71cf, 0xae9d9ff7, 
	0xdb17fc4e, 0xcefed2dd, 0x7e24b49e, 0x1df9e4ed, 0xc4b77f54, 0xf50f75e4, 
	0x2a32fcd1, 0x1be69fee, 0xb1e870ec, 0x61e92b37, 0xa88f4165, 0x00e9ca57, 
	0x0f3835b5, 0x06f7e4f5, 0xd917987d, 0x156e853b, 0xa3eea4d7, 0x6212faf8, 
	0x784b87d7, 0x3b6fb459, 0x1d94fcd4, 0x55c2e27d, 0x9e798b9e, 0x3e13df36, 
	0x40f21a91, 0xe314d5be, 0xe33c6430, 0x8e526d2d, 0xb5d7e53a, 0x29ac1c49, 
	0xd55461c6, 0x5461c62b, 0x936a6f96, 0x8c535778, 0xaf7aa8c3, 0xe3218718, 
	0xb90e512b, 0x30e2a35e, 0xd656f7ea, 0x5283bfe7, 0xf2c4ff66, 0x166971d5, 
	0x84d5a5c7, 0xf8c38e6d, 0xc38c9b48, 0x7f6959a8, 0x3fe91efe, 0x40edc9ea, 
	0xec3f76bf, 0xf3fb9afa, 0x8d183803, 0xfa830e21, 0xf1936deb, 0xef99ae95, 
	0x57f8c80c, 0x2cd9f5b1, 0xe6753f3d, 0x757ef1ef, 0xb3ec463c, 0xe3cb2712, 
	0x58eff98a, 0x49f194ae, 0x6e7653b1, 0x51f865f8, 0x1561feed, 0xbf53a447, 
	0xfc49b7f7, 0x707c51aa, 0xf475f102, 0xb68bd0ef, 0x7b77710f, 0x7a28fa1d, 
	0xcaad2687, 0xd0ef4572, 0x5cb2b311, 0x16c857ad, 0x55f3e595, 0xb7b67dfd, 
	0x3fd15ca2, 0x94556e34, 0xe2be8523, 0xaf6843ac, 0x1be3cfc9, 0x2ade3e65, 
	0x7bf9c7b4, 0x3c7bb685, 0x1a8cf1c0, 0x5ba118fc, 0xb4e3f4cc, 0xf7a11f1f, 
	0xc8c3d013, 0x431d017e, 0x546fcd16, 0x12c1f3cd, 0xf6db84bd, 0x4e806f68, 
	0x547e0f54, 0x1ee05dc4, 0xc0d445a9, 0x407d20fa, 0xa06639c0, 0x1f9b17de, 
	0x2c7f836d, 0xc85e161e, 0xf3fa72ab, 0x53e1ab77, 0x94f2a82a, 0xa887fbfa, 
	0x36719397, 0xfcb90eb4, 0x0d67f46e, 0x74339e20, 0xa5ab4643, 0x26d0bff1, 
	0x2e71b9cf, 0x7c717d8a, 0x1c5ba4f7, 0x0d16f8e1, 0x0fb59cf1, 0xe79138ca, 
	0x29883ed4, 0x196c273a, 0x9b54f257, 0xf94ec794, 0x7ea4da77, 0xd7eb531c, 
	0x4f55593c, 0x91d35fad, 0x6a23f2ca, 0xbad4c4bf, 0xbd578c34, 0xf71bcaa7, 
	0x941738c9, 0x15883f43, 0xfd654bf7, 0x9c651796, 0xac7e338b, 0xe75c5543, 
	0x625ce359, 0xeb8e2d4b, 0x1f9f5d8c, 0x73cb9c40, 0x3bb13e8a, 0xe7ddff0f, 
	0x07b23ee5, 0x167e6077, 0xd4c671c7, 0x6f1fe4f7, 0xce9af193, 0x29efe1fe, 
	0xfcff79e4, 0xf16503f9, 0xa4b1d14c, 0xeca53436, 0xdeefb29b, 0xca48fd14, 
	0x4a8e89fe, 0x231486bd, 0xdfa68fb6, 0x8fb4a17b, 0xf3927c8e, 0xc9f1af6b, 
	0xfc9ed17c, 0xe737cb29, 0x2fd1ed3b, 0xff718b9a, 0x8e7fb1d4, 0x7181acbb, 
	0x6ef07017, 0xd6746b8e, 0x49ea44fb, 0xac73e42f, 0x0bc28388, 0xcbb6f1dc, 
	0x9f94e0fd, 0x88bfd672, 0x8af55583, 0xee595838, 0xd75caf69, 0x7bd56740, 
	0x26a41c45, 0xe072c8f7, 0xa1aeb3a0, 0x5afacaee, 0x71cb7852, 0x6b663e30, 
	0x853ac1c0, 0x32a37583, 0x03eb1cce, 0x4bb70c1c, 0x3a75a41c, 0x77b070a8, 
	0x675c8768, 0x11ec60e0, 0x30702b63, 0xb6b070ae, 0x55c1c1dd, 0x803dd55b, 
	0x0709a781, 0x1ccea7e3, 0x712ce7bd, 0x62c3f169, 0xa14e3cba, 0x2b130f1a, 
	0x718acf49, 0x27d30c9c, 0x00f47841, 0x3994e470, 0xe7197f98, 0xe7106264, 
	0xd7bfc700, 0x3c6833e5, 0xfe976cef, 0x8f8384b3, 0xc7c07384, 0x035361a6, 
	0x2edd5eff, 0xaf69dbf9, 0xa2a27089, 0x7d5fd9dc, 0x5ca2a7b6, 0xaf5363ad, 
	0xf0ae5955, 0xacc7a9b1, 0xd2eb572c, 0xe5151194, 0x503cf948, 0xb7534fad, 
	0x1b7557dc, 0xad753b65, 0xf971ef96, 0x38df1fbd, 0xe53367f1, 0xbf898f81, 
	0xaeb8f891, 0x89cbc65d, 0x7e0fbf19, 0xe924c499, 0xc247c061, 0x347c4aed, 
	0x49fef87d, 0x23d514fc, 0x44d9353a, 0x5bea1c87, 0x9ae9f83e, 0xb2dbe290, 
	0x6c7c49cf, 0x420fb46d, 0x477de57f, 0x59aa9fc5, 0x09f75edf, 0x93f40e39, 
	0x3b4f7e6d, 0x63136ce2, 0x30fc1886, 0xdcb48bf0, 0xaf0bd03d, 0x7d5c676c, 
	0x5e0418c4, 0x813d6d9c, 0x11e209af, 0x4b9e336d, 0x26b9c57c, 0xf85407df, 
	0xb09efb8a, 0xaf3d78ff, 0x56c5b8c0, 0xe0e26ce0, 0xf3710f98, 0x4712edfd, 
	0xe195ff8e, 0x47c1f8e5, 0x893b3e68, 0x3b492f3e, 0xfb976ac0, 0x53ad45ab, 
	0xfdf257b4, 0x9ddd14a7, 0xf5388ff2, 0x561bfad4, 0xfeb53d55, 0xe5957d35, 
	0x6c3ed45b, 0xce1aeb51, 0xfce7bd54, 0xb91ebfbd, 0x7c0e510f, 0x87daa96d, 
	0x61dafd4e, 0xf19d0fb9, 0x6f088fc7, 0xc7c6be39, 0x5f093d68, 0x135f0a13, 
	0x2d97dcb6, 0xe041ed4b, 0x3bed0b6b, 0x8a5bcdc4, 0x0f3bf12e, 0x4d7c294f, 
	0xf9835bde, 0x67e03ed9, 0x0fd7c28b, 0x2af83bb4, 0xbf83a5f7, 0x0eab53f1, 
	0xe36be395, 0xd7c3dbe8, 0xd7c2bcc6, 0x74f19844, 0x7f750ec1, 0x9c65c8e8, 
	0x77a9e27f, 0x5f117ccb, 0x7c0ed73f, 0x3efaffad, 0xee3537f6, 0xa75af896, 
	0x03d8ebf4, 0xefc86f89, 0x9e5ad80e, 0x072768fd, 0x44d55fe0, 0xc67117af, 
	0x279e57b8, 0x5fed75bd, 0x664549a4, 0x5f37a67b, 0x7d6cbfe6, 0xce10ebb9, 
	0xf1cbaa37, 0xb9dcbd63, 0x7555fe97, 0xff68bf1f, 0x74f598fc, 0xfb567ff4, 
	0xfa77d167, 0x4d7dc485, 0xf217dc67, 0xf114c1ef, 0xe53df69e, 0x757c280f, 
	0x57b5f7ca, 0xd5571fc7, 0x657de22b, 0x6cf804f9, 0xb8fe3cba, 0xde22bdea, 
	0xf1c81e9b, 0xf195ed03, 0x2e2f88c7, 0xe525afaf, 0x718a69f7, 0x1b963dbc, 
	0x7c54157c, 0x29afdfc5, 0xba7e3f8b, 0xfc7f18bd, 0x99f7852b, 0x5fb86afb, 
	0xb7c37bd6, 0xfa2bde55, 0xefef115e, 0x6c7e97ee, 0x4ddeff8b, 0x1aaad4e4, 
	0xeecc8719, 0xb7ff5299, 0x5fb03e12, 0xaf7e2ac9, 0xc3ef1cbb, 0xee7f092b, 
	0x8ac7dd2f, 0xc072b29c, 0xd162c8f9, 0xfabb279f, 0x3779b5f8, 0x0a57fe70, 
	0xdd3f1de7, 0xf58b2e89, 0xb85260e0, 0x4a1b8f10, 0xd0e67dca, 0x2b32983f, 
	0x83fd15cb, 0xb965561d, 0xda60bf5a, 0x38572cae, 0xbb85341f, 0x47ad5ca2, 
	0x28acd3b0, 0x02f1ca47, 0xb7785c4e, 0x2a8e138c, 0x9ab68f9c, 0xb6f3895e, 
	0x9eb83d06, 0xbaf9c0f2, 0x9379c201, 0xea2c96e8, 0xa26f7cc1, 0x7acdaf6e, 
	0x4a5189ed, 0x785e702b, 0x5391df81, 0x10f20f54, 0xfb289bf2, 0xe0d5007f, 
	0x0000f0f0, 0x0003a8a1, 0x7dc59c78, 0xd7555c0b, 0x873ef795, 0xcbdee5c3, 
	0xe4172e15, 0x882f18a1, 0xae444578, 0xd7978a21, 0x8f834d01, 0xfa979a28, 
	0x9b1a09b5, 0x21a64e98, 0xb5311b49, 0x4457b9e3, 0x17c1727c, 0x4c52f9a6, 
	0x3a9a4d33, 0x932648fd, 0x1cd7eda2, 0xa931998c, 0xb4cd419d, 0x3074cda4, 
	0x30eda331, 0x5338e31d, 0x5be699b4, 0xb875ed6b, 0x3331300f, 0xfcfc7e9d, 
	0x3f67d9b9, 0xaf6b5ece, 0xc7ed7fc7, 0x3d05fd21, 0x91097451, 0x215ee981, 
	0xd6e111c4, 0xe2910aae, 0x8d821232, 0x77afa442, 0x213cd68b, 0xdd827cfe, 
	0xf2057dab, 0xdb6d6ecd, 0xd2ed20af, 0x0847226d, 0xed085797, 0x3dc62161, 
	0x34497e50, 0x7286fb40, 0x3bc80c21, 0x18462df5, 0x08cd90d2, 0xc8b487ed, 
	0x420f8508, 0x12df4d7a, 0xf3842b5e, 0x9a426f4e, 0x684a8843, 0xfd04bf6f, 
	0xf96c4268, 0x1fe710a2, 0x2ec2ab09, 0x430ad0c4, 0x3fa0e715, 0xb70427a1, 
	0xea0f310b, 0x71bd40e5, 0xbc6f50b9, 0xa6e54910, 0x44243f66, 0x44773c31, 
	0xfc87cf3d, 0xbbc826c4, 0x4def0f20, 0xcbd5c5f4, 0xa56dcf90, 0x4067cfb1, 
	0xb15db02a, 0x1f51c7ec, 0xdb9f8ed7, 0xe5f35375, 0xb1d3e7c8, 0x9e7c997e, 
	0xbeb632bc, 0xe23535e6, 0x915ec3cf, 0x0de9e500, 0xc429de50, 0xbad3f0c7, 
	0xe507f919, 0x97d480df, 0x300fd424, 0x0385122f, 0xc9fc03df, 0x86d9f486, 
	0xa4b0ee2d, 0xee33f91b, 0x53ea5b49, 0xf42842cd, 0xdaf8f90f, 0x42c3bd95, 
	0x0c1cc2a8, 0xc05d9f22, 0x752b4c27, 0x7856fdb1, 0xcdc1faef, 0x10a7fd37, 
	0xeb6f269e, 0x5e2141b6, 0xb6ec209c, 0x28a5b097, 0x30851b12, 0x780c8e61, 
	0x9f4d289f, 0xf6c2f981, 0xffaf991c, 0xf3010cda, 0xa3186bff, 0x89177c01, 
	0xed162fdd, 0x1b6cf780, 0x0a772a2e, 0xd0bb9ad1, 0x885dfe2b, 0x33c383b4, 
	0x5e2f200a, 0x401a2f10, 0xd9e3ca77, 0xa45e9147, 0xf4cdf9ef, 0x89a5b11e, 
	0x61cb0512, 0x0723151e, 0x93538353, 0xcb950b9f, 0xd4e72e55, 0x4122e7e4, 
	0x9904f5e6, 0xf9353837, 0xbdb8d0b9, 0x3539edc6, 0xe448b9f9, 0x9edc89f6, 
	0x0b9f9353, 0xb8db971b, 0x9f93539c, 0x3fee248b, 0xd4e7fb89, 0xcec2e7e4, 
	0xe72e76e5, 0xc2e7e4d4, 0xb83bfdc1, 0x7e4d4e7f, 0xee5c9c2e, 0x4d4e72e4, 
	0xb9922e7e, 0x9fee64ff, 0x0b9f9353, 0x7177b717, 0x7e4d4e7b, 0xfb71c62e, 
	0x539edc71, 0x148b9f93, 0x72e14f2e, 0x2e7e4d4e, 0x54ffb952, 0x93539fee, 
	0xb7370b9f, 0x4e7b7377, 0xd22e7e4d, 0xb71a7db8, 0xe7e4d4e7, 0x1ee5c3c2, 
	0xe4d4e72e, 0xfb9d22e7, 0x39fee74f, 0xc8b9f935, 0xdc19f6e0, 0x9f93539e, 
	0x7edcf18b, 0xd4e7b73c, 0x9322e7e4, 0x9cb933cb, 0x8b9f9353, 0x8b3fee2c, 
	0xe4d4e7fb, 0xcb9b22e7, 0x539cb9b3, 0x1c8b9f93, 0xfb873fee, 0xe7e4d4e7, 
	0x4f970262, 0x4d4e72e0, 0x72262e7e, 0x7fb913ff, 0x2e7e4d4e, 0x2e7db972, 
	0xe4d4e7b7, 0xb71262e7, 0x39edc49f, 0xb8b9f935, 0xe26fcb89, 0x7e4d4e72, 
	0xff73262e, 0x4e7fb993, 0xbc2e7e4d, 0x72e5ee5c, 0x2e7e4d4e, 0x3cffb8f2, 
	0x93539fee, 0x2e7c8b9f, 0x4e72e7cf, 0xa62e7e4d, 0xb853ff70, 0x7e4d4e7f, 
	0x7db80a2e, 0xd4e7b701, 0x2a62e7e4, 0xedca9fb7, 0xb9f93539, 0x42f2e428, 
	0xe4d4e72e, 0xf71a62e7, 0xe7fb8d3f, 0xc2e7e4d4, 0x2e3ee5c7, 0xe7e4d4e7, 
	0x3ff73a62, 0xd4e7fb9d, 0x88a2e7e4, 0x9cb88bcb, 0x8b9f9353, 0x0cffdc19, 
	0x93539fee, 0x0cd90f9e, 0xd523fc61, 0xe2222d13, 0xe958fe5f, 0xb6784ba0, 
	0x4be347bc, 0x18ff820f, 0xb4205cfa, 0xf8fc10af, 0xbba7efe4, 0x6ab3a4bb, 
	0xf069926b, 0x754b108a, 0x1f82a3d5, 0xde9a4704, 0x4748e921, 0xcdc273ff, 
	0xbea666fe, 0x621468d7, 0xd8413199, 0xf13e40d6, 0xd202bd85, 0x67bd9ddb, 
	0x3d8c130d, 0x05c001da, 0x39eff3e7, 0xfbc21620, 0xe24d039a, 0x14d7a86e, 
	0xaf51dc20, 0xfaa74f1f, 0xfb087e46, 0xfe817b41, 0xfd2cdccc, 0x2ceeeddd, 
	0x5fb41b6d, 0xfab7fd0a, 0x05b7daa3, 0x4d438788, 0xfc29ff90, 0x07f65eb2, 
	0x8034e9e3, 0x24d5218e, 0x3b97273e, 0x84072d3c, 0xe5f5e6b8, 0x58850f89, 
	0x4c6796f5, 0x1f5437bf, 0x61ba3468, 0x55079b9c, 0x7e5857c4, 0xeb93ca10, 
	0x47aaab8f, 0x6afbbbce, 0x16ce1f94, 0xef11862f, 0x9d7e7ad8, 0x6f8466f6, 
	0x3fc83e60, 0x3997f4df, 0xf7c33f92, 0xc91e7f90, 0xa2f0be27, 0xfbfd8e72, 
	0xf0cff439, 0xba9a700c, 0xf835fc19, 0x9a1b71ed, 0xc49d2a8b, 0xe3083567, 
	0x4fc11e4c, 0xfc876a86, 0x8e76c00a, 0x45f3c8a6, 0x253f1279, 0xb8a7e08f, 
	0x29f8237a, 0xa40379f6, 0x724a7002, 0xebb72c81, 0x7046ed71, 0xcd73ec55, 
	0x50ef380b, 0x0d9c9e44, 0x044c4122, 0x08b886a7, 0x11aba0f0, 0x1e381dca, 
	0x320edd53, 0xa5da0ab2, 0xf4ca7be1, 0x130c767b, 0x1edc3f1f, 0x18b7fea6, 
	0x2b5c9b80, 0xf50121c2, 0x8d12d79c, 0xcb4fbc10, 0x9466e217, 0x42d7e1bf, 
	0x6bce37a8, 0x5db1071f, 0x6812e202, 0xed009cec, 0x016d2106, 0xbf03a4fc, 
	0xe10c1e1e, 0x5dbf9278, 0x42f0c97e, 0x59226d7f, 0xd1ef4abd, 0xd70aa200, 
	0x2dc9e593, 0x3378c8de, 0xaca2fcfe, 0xa4b88cff, 0xc379246e, 0x90f2236a, 
	0xf77c095e, 0x3f09f844, 0x67ac6e09, 0xf8cf794a, 0x3496df73, 0x0ae75790, 
	0xcc3716f7, 0xc49e577b, 0x9a71827b, 0x5c5eb061, 0xf40e48d4, 0xbca54b87, 
	0x7ca26ef4, 0x65b337f3, 0x3583da39, 0x7b203911, 0x93ca46b2, 0x22e510b2, 
	0x4db88798, 0x58bef464, 0x03db03bc, 0xfc435b6e, 0xe47a819d, 0xebc20a74, 
	0x75e2552e, 0x78499157, 0x104d75dd, 0x7cfe4f5e, 0xbc1a4263, 0xf19f2927, 
	0xc075e228, 0xec1fe7ad, 0xf24ebc27, 0xad0dfd05, 0x01f6d606, 0x5e25f373, 
	0x2bb7978f, 0x2ff6f271, 0x46976f28, 0xeb95dbcb, 0xfcf59bc8, 0xc6de58df, 
	0x70e3926d, 0x41c398b6, 0xc72a55e0, 0xbd2f3011, 0x47a476ca, 0x20681f24, 
	0x3b3e907e, 0xb90c1cef, 0xccb39fa1, 0xf2c6e4e7, 0xc8d2f2cc, 0x0430c17c, 
	0x1c9a2bc5, 0xcfcf359f, 0x483efd73, 0x3f6497dd, 0x5ed0ef34, 0x6bdaa378, 
	0x58ee7991, 0xfc25e723, 0xf6e7aca6, 0x7ec40d81, 0x404e2e24, 0xc161a63d, 
	0x7dbaba7c, 0xd1c1b6da, 0x7f9add38, 0x2da4b5e7, 0x579e5ac6, 0xc2ecef9c, 
	0xc607964f, 0xafb9aded, 0x82af89e5, 0x2ccd783d, 0xf9e4ec3a, 0xfc81bf46, 
	0x98764cbb, 0x5133b470, 0x93b4febc, 0xa234cfe8, 0x0f5ae5f8, 0x7a30bdf4, 
	0x80f191bc, 0xfd50737f, 0x676803e9, 0x940aeef4, 0x7336b4ab, 0xddba009e, 
	0x1de7badb, 0xd0f4c706, 0xc61e6094, 0x825b888f, 0xce9e9f20, 0xb9605ffe, 
	0xc0af51ab, 0x9c632f38, 0x527823b8, 0x7f1047f2, 0x7e285bbd, 0xdfcb195a, 
	0xd4979e64, 0x5a6a834d, 0xdeb17f14, 0xfe35fc98, 0xcffbf9a7, 0xfcf157a4, 
	0x57c96e15, 0xf4460931, 0x78bb68e8, 0xf1763ae5, 0x1c5d9c4a, 0x1f8879f7, 
	0xec139da1, 0xe8fc7460, 0x3012306c, 0xf8e14c7e, 0xed89a531, 0x70c1d824, 
	0x1883b497, 0xafac2a3f, 0x046f6bce, 0xe747e3a3, 0x9d959ab5, 0x8a3f18cd, 
	0xb49a4679, 0x263f18af, 0xfc537597, 0xe0e56e38, 0x54cd49e6, 0x55ba40cf, 
	0x42ad8bd4, 0xd2f8c234, 0x01b9bfd1, 0x7c4ddff7, 0xe3c61e24, 0xd8324790, 
	0xdc1fe43e, 0x893ec82b, 0x1a94f3c2, 0x66904385, 0xd0dcb8c3, 0xa91e6fcf, 
	0xfc802c29, 0x15afb985, 0x891c9316, 0xbd645769, 0x76c91f69, 0x103b13be, 
	0x576fc21d, 0xd4efb9e8, 0xc2779a0e, 0xbeb08f4f, 0x6fd37fbd, 0x8e41da0f, 
	0x5494d37e, 0xb8790768, 0xda2021af, 0xf00885ba, 0x14cc967b, 0x10a646c5, 
	0x1c6f6d3d, 0x7de74014, 0x41edae4f, 0xdadf7cff, 0x5f283da9, 0xb9b352ff, 
	0xffef07d0, 0xb0b324a7, 0x2b65d207, 0x208e10ce, 0xc6f987dc, 0xc267c4f1, 
	0x734e347f, 0x557e499a, 0xca749df7, 0xa31fb9f1, 0x7777bee7, 0x674fe444, 
	0x1778a2f9, 0xf94767c6, 0x9bef7e83, 0xc213df5d, 0x7bd917f7, 0xe9454854, 
	0x7eb156ff, 0xaa799811, 0x91549faf, 0x226d21ef, 0xdca2dfc9, 0xf40e4a65, 
	0x50bc44b5, 0xc5e8ac8b, 0x329f50ff, 0xf00543ca, 0x534691fc, 0x7e20c979, 
	0xfc932b4e, 0x88e9569c, 0x37c22ff0, 0x996dfd31, 0xff5a1c27, 0x40638835, 
	0xf17c962f, 0xea052cc5, 0x9e15e7df, 0xdca90796, 0xc47def83, 0xc971e725, 
	0xe39e8b17, 0xfa833c79, 0x734dfefd, 0x3e7c8bbf, 0x92f3b772, 0x31bfc613, 
	0x51c5da5f, 0x9553be7c, 0x04bc61f4, 0xa7111aed, 0xb17a89bf, 0xae4b39e1, 
	0xa3a2d860, 0xd2ab4a79, 0xa79bf508, 0x41eb6ebc, 0x33f8bafd, 0xb6a1ff94, 
	0x8f08c7ca, 0x363c4b0d, 0xbca010d4, 0xdca5bba9, 0xdfacb859, 0x1c0cb843, 
	0xff5177c8, 0xfd5efc8e, 0x623bb04d, 0x22bbee37, 0x7f410466, 0x7d48b48e, 
	0x4de30b5b, 0x6e5a34be, 0xb107bde1, 0x4c0f7dfd, 0xc7ca0dfd, 0x5d9e7a28, 
	0xa9e6e527, 0xf79b9202, 0x1177c453, 0x3fdfd667, 0xec768ede, 0x50f21388, 
	0xed0ec8ef, 0xcc07893d, 0x79bbd92c, 0xc11438d0, 0xdc76fb81, 0x803a2059, 
	0xa10caeee, 0xe79e78c2, 0x97de44f1, 0xfd415df8, 0xb689ebac, 0xced71d7f, 
	0x2293141c, 0xb5c8e076, 0x37c23db5, 0xa4cebb46, 0xf45b891e, 0x91dbe44a, 
	0xf1cbc816, 0x89fe5054, 0xfc0af291, 0xaffac8ff, 0xdf0394f7, 0x5309272f, 
	0x0faff7ce, 0x091f7ce2, 0x8cf5c6dc, 0x5feed879, 0x6e2aa71b, 0xbe4f7fa0, 
	0x3d16b3b4, 0x9f8ed617, 0x1c8ec021, 0x7a22cb69, 0x39e63e96, 0x8b143f6a, 
	0x7d02778b, 0x9e0e2a97, 0xee1bfc45, 0x06df3cac, 0x95438574, 0x5e90ede7, 
	0xe8b1f966, 0x36bb44ea, 0xb4159a9e, 0x042f5f01, 0xf28f39ee, 0xf262a176, 
	0xefe7a873, 0x9d61b4df, 0x72eff203, 0x22c68ebb, 0x7d783ad1, 0x6e9a2efb, 
	0xd6fdfb21, 0x9ed21984, 0x8e1156fb, 0x32ebfe6e, 0x062bfec1, 0xa938592f, 
	0x3e58f735, 0xfb70cffa, 0xfd703347, 0xeb40780b, 0x6139f75d, 0x8a1e513e, 
	0x671c0cb2, 0x028dbe64, 0x7fd06812, 0xfe88c6fb, 0x29c7997f, 0xbd251fd6, 
	0x438d653e, 0x7de503fc, 0x9db22687, 0x871c1430, 0xdd702765, 0xcfec5dec, 
	0xc68cf80d, 0x015c7a57, 0x46a4d5ba, 0xaf9e1f35, 0x7e4905ca, 0xae33ca54, 
	0xe2a90e5f, 0xe4bf4637, 0x617ed237, 0x83c7c422, 0x18170b98, 0x0bfe690b, 
	0x91aa1e28, 0x62d21ae3, 0x37ba77eb, 0x9f806d88, 0x8837daf6, 0x5ca05bd6, 
	0xe7684d17, 0x0895c307, 0x5750c5ab, 0xb88f8ca5, 0xcc58787e, 0xc3617b40, 
	0x70bfa1fe, 0x0a815253, 0x9e6cebef, 0x5f036da8, 0xed976431, 0xd647faad, 
	0x01a056df, 0xee0c86df, 0xca92ada7, 0x0798f7ac, 0xea33452b, 0x37ed0ef5, 
	0xf00bbb8c, 0x87f911bf, 0x0fd711df, 0xf1bf68b5, 0x7e25f948, 0x7e97cd9f, 
	0x8e9f92d3, 0x7605956d, 0x6485efe0, 0x4f1c47d0, 0x920cc178, 0x032cd0e7, 
	0x6485f8ed, 0x269caaf3, 0x57ca2af3, 0x1c2168d8, 0x101fad6c, 0x7e70badf, 
	0xa01bce6b, 0x5ebaf75f, 0xaf6d1f3e, 0x8acee8a2, 0x8b5efba6, 0xe41e8b6e, 
	0xfdd08ddb, 0xfdd100db, 0x2cb6d0c8, 0x500ba78e, 0xa5382e3e, 0xbb84517d, 
	0xe0a3e580, 0x29f0e214, 0xdf801220, 0xe1b3dc3e, 0x0ba9fa3c, 0xc628f34e, 
	0x066e1fc7, 0xf548ddbb, 0x03fd62a6, 0x483f3061, 0xb6984f9f, 0xfdfc7057, 
	0x2d0fd153, 0x969e1af2, 0x60e211bf, 0xfe40ae78, 0x269cc184, 0x83f80195, 
	0x68afd17e, 0x86a9f6e5, 0x28a9bf94, 0xf5728b37, 0x3bd42082, 0x07ff76b2, 
	0xfc3e3388, 0xdf033133, 0x1475c363, 0x4af11fc8, 0xb5b3847e, 0x936fb6e3, 
	0xc68d4ebc, 0x72bec25f, 0xaea3e92a, 0x282fdcb1, 0x0a2fa414, 0x8e2145e7, 
	0xe32ea0eb, 0x0271057e, 0xdf205bf6, 0x3421a8bb, 0x17fbdf15, 0x908b13eb, 
	0x56f144de, 0x7891fa11, 0x97e1fcfb, 0xc2a19d6f, 0x74d7beb8, 0x7ea0916b, 
	0xff19228d, 0xbfde497b, 0x2d198c27, 0xd7c8fe50, 0x946bf17e, 0x6b3afb87, 
	0xa2df687a, 0x710686ad, 0x51e40b5f, 0xff399a1f, 0xafaf9704, 0x0bee5a21, 
	0x52f9966c, 0x49bb072e, 0xca2aa6f9, 0xfbe7b87f, 0xa8ffa22f, 0xa07c18cf, 
	0x05a404ed, 0xda7b93fa, 0xebe97520, 0xaf100bc3, 0xd8f76be8, 0xfd1aafd1, 
	0x3d7e329d, 0xf10d3dba, 0xf96c1e94, 0x432d94a9, 0xc878e444, 0xf718487b, 
	0x0727b3c0, 0xa82849c4, 0x7e7ac29b, 0xaa41fadd, 0xe2fac41f, 0x0877ea46, 
	0xfa9167e3, 0x090d9e96, 0xcb377fa8, 0xe7b48b7b, 0x9c73ad63, 0x59d6dc77, 
	0x0a3ea1a0, 0x40e80bcf, 0x41e5058d, 0x76459fd0, 0x90ea13c3, 0x31ffbff5, 
	0xa78f573c, 0x5092bee3, 0xcc1ae943, 0x5f9462fb, 0x4dfab390, 0xf90d0a4f, 
	0x0b37ebcd, 0x772dac97, 0x3bd41c80, 0x73ca2745, 0x535dfe72, 0x39cf7834, 
	0xfec748c3, 0xfc35dfa9, 0xba6f5c1e, 0xafd82752, 0x3de063a5, 0x11dced84, 
	0xf7801efa, 0xba4e2324, 0x96bed2a2, 0x7ad324d8, 0xd235776c, 0xde97eace, 
	0xed0af38b, 0xb768c7d2, 0xdcaebeb4, 0x0f9a3293, 0xcae7ccf5, 0x8f70fa7f, 
	0x7f531fb8, 0xdbe9da07, 0x08a74e06, 0x13ec8bd0, 0x5f11a78d, 0xba77be55, 
	0xc2b7e51f, 0xa8cefe29, 0x607ae785, 0x55d00159, 0x56b4f3f1, 0x65e33ef1, 
	0x0794b7d0, 0x0f19ed2f, 0xfb30ab03, 0xa00bb453, 0x7657f33e, 0x192f3ca0, 
	0x516ff977, 0x543b2d9e, 0xf768b8f1, 0x17890120, 0xd79ea0f7, 0xc63721eb, 
	0x395d9655, 0xec8f3031, 0xa7f44db6, 0x7ea73ea0, 0xfd1a77dd, 0xaf3d50db, 
	0x573af17b, 0xc206d7ea, 0x71a2bed8, 0x4d6db682, 0xc7fa5d94, 0x8f1ed279, 
	0x7ae57fac, 0xf223325a, 0x7b7fa510, 0x421545f0, 0x1f8e89ef, 0xf7c8542b, 
	0x028be547, 0xf2bcbf52, 0xe7e715bd, 0x96c9fd49, 0x99156feb, 0xbfad6e5c, 
	0x64579d21, 0x21fb82bf, 0xd15fa1ba, 0x1627c910, 0x88238c8f, 0x455248e3, 
	0xb49238cc, 0xc44dbcb8, 0x6e292b8c, 0xe37149dc, 0xdfa2fec6, 0xe4c5fd8f, 
	0xf1e8bfa1, 0x7c659060, 0x531bf645, 0x73dc6e2f, 0xf8c0c26c, 0x27a9e205, 
	0x557e51c2, 0xc2542fb3, 0x983f47a0, 0xe2b7e322, 0x70fb9bb9, 0x3e5c6dde, 
	0x427f2be4, 0x9924e2e2, 0x2309e217, 0x4e2dfdaa, 0xcfc08461, 0x21e96715, 
	0x238dec03, 0xf78c986c, 0x1dca0d34, 0x266f2b21, 0x232bfe50, 0x4e2809e5, 
	0x0ed0a9c5, 0x37439ffc, 0x829eb9fa, 0x7bb31dcf, 0x61ba5bfb, 0xdf4593dc, 
	0x73d3c016, 0xf11d0aa6, 0xe25536b4, 0x3205ddc1, 0xd217bade, 0xaf8b486c, 
	0x14430425, 0xd0931b57, 0x8fd04fce, 0xfe90b975, 0x13df397a, 0x75c142bd, 
	0x0fe609b6, 0xf14b2aba, 0xf424ff49, 0xb426380b, 0x4a061bd7, 0xd13d3fc9, 
	0xe0042d9f, 0xcbb5e2ba, 0x1b3fa843, 0xe0ac80bc, 0x1eefa979, 0x7987bc45, 
	0x7e856da1, 0x84a2859a, 0x4e9c611a, 0xbf901fe3, 0x5dbdbc13, 0x7c402f2d, 
	0x05b57422, 0xbef01beb, 0xdf5e7824, 0xbae1a5db, 0x09b8cf86, 0xb7d94efd, 
	0x26b8423a, 0x8152f607, 0x15d44520, 0x17ad2ae9, 0x25f9eecd, 0x7c7cc5ea, 
	0x8bf9f90e, 0x246ece20, 0x3d234e7a, 0x82feb80b, 0x68beb215, 0x9e70d330, 
	0xf7e974ea, 0xd47af0e6, 0x56fedcad, 0xce39ff6e, 0x8f77ce7f, 0x393f802a, 
	0xf442cd27, 0x9d7ace47, 0x7ed083fa, 0x6dcf9110, 0x6eab963b, 0xf3b6dfc8, 
	0xec7a8a90, 0x1baae9f0, 0x0d7a70e8, 0x4bbee3ca, 0xecccbaf4, 0xe582ba45, 
	0x0a10efb3, 0x4ce28ee2, 0xbf782f90, 0xd87558b3, 0xeafede70, 0x2f5c6ea1, 
	0xaa186676, 0xb85f0681, 0xa67db173, 0x69fc48a9, 0x1f917237, 0x1d0ff5c1, 
	0x26cc78c0, 0xdb53dcf4, 0xa34d2e60, 0x95a0f910, 0x38924e97, 0xf5849f52, 
	0x87def96e, 0xb93da137, 0xc4d3c5e5, 0x32977f27, 0x9b5d8059, 0x99f877b9, 
	0xda73e032, 0x95c9dee6, 0xaa71bed0, 0x0f29f7b4, 0x4f4ef74e, 0xf9c7e392, 
	0xf9219b2b, 0x47367156, 0x895dff41, 0x0ab4817c, 0x9ab02053, 0xae7e1ad3, 
	0xf396be73, 0xa83a6715, 0xae41ad1f, 0xb9e2546b, 0xc2af2801, 0x39abca14, 
	0x3ae7e1ad, 0x3f396be7, 0x27992eef, 0x9c5a43be, 0xe895f922, 0x127e69d5, 
	0x3e69b28b, 0x792a2eaa, 0x368fe076, 0xf98421a5, 0x79b54bea, 0x4ce72f88, 
	0x07ff7195, 0xc5a7c38b, 0x70cf783a, 0x9d6f9e90, 0x74ed4b92, 0xed0f3c71, 
	0x39b3cb76, 0xad9c7187, 0xdd340c53, 0xe44936a2, 0xe447b21f, 0x3a1ddb63, 
	0xbf9adf3d, 0x5b69e88f, 0x15a3e52c, 0xed11aae5, 0x6dbf9c9b, 0x12df248b, 
	0x01a0f433, 0xcb0da2b8, 0x0a3e6907, 0x873e30c2, 0xe8a3ca57, 0x881daa0e, 
	0xbaa0f47f, 0x83ae0d7d, 0x64661d03, 0xb12388fc, 0x1159edbe, 0x60fc79c4, 
	0x80b0f851, 0xe93738b1, 0xad3ae22a, 0x822821a8, 0x104a0f28, 0x0bc386fd, 
	0x6437f3fa, 0x9f700a07, 0x0de45b42, 0xd9bd42b5, 0x0dc0a561, 0x692e8fe5, 
	0x064055cc, 0x2144eb13, 0xbe472fe2, 0x1dda2efe, 0xa1fdf71d, 0xa5d783be, 
	0x42a5bc87, 0x8a027c05, 0xceaa764a, 0x784f975d, 0x5a2ddeae, 0x1837afd0, 
	0x07f5a253, 0xd1e3dcec, 0x69fcc6f1, 0xa18bf2c7, 0x06e75bdf, 0xfd0194a6, 
	0x4a7324fe, 0xf67f5c9b, 0x779c7be2, 0xfd1b7f76, 0xc2ddd827, 0xa1df9816, 
	0xbf236a7f, 0x2038dc15, 0xf631194e, 0xed13e328, 0xaeb1f751, 0x47b21eca, 
	0xe8f6d119, 0x2b47b60e, 0x1dd1ece2, 0x4f408f6c, 0xd83cca26, 0x89dfc823, 
	0xf49068f6, 0xa3c4a27b, 0x5ee1167a, 0xf0d00fa6, 0xc95bf3f8, 0x7c8dbd5e, 
	0xfef5047f, 0x42ee2139, 0x2ff9057b, 0x697a1ea0, 0x664fb468, 0x9750e9e9, 
	0xdf5b709d, 0x1ed00d9f, 0x8d39da12, 0x6fe790e8, 0xfd235294, 0x98682d0a, 
	0xe95a97e9, 0xa90d13bd, 0xbfac19bf, 0xecf79819, 0x788fd81d, 0xb9bb6d21, 
	0xe1c61f3f, 0xc07e58de, 0x23ca6907, 0x5ba599c3, 0x1f594f89, 0x14ec5a41, 
	0xf8ae393b, 0x78bfbe06, 0x135ddb7f, 0xb77e4112, 0x421777e9, 0x17d1533a, 
	0x9cbc80b7, 0xeb441c42, 0x30c26674, 0xd8cd43da, 0xe889527d, 0x5a9e9cd5, 
	0xf3bca75a, 0xbd8a395b, 0x21d5d311, 0xa5ca43b7, 0x2458e49d, 0xa74738c8, 
	0x5931d838, 0x283ac128, 0x15807de7, 0x51d79e9d, 0xd67ceede, 0x6525fb43, 
	0x6e83bb37, 0x54e0e798, 0xe2ef27e9, 0x766d2af5, 0x422c9079, 0xf8c219b7, 
	0x217de84e, 0x33be275c, 0x3f189841, 0xb7575d0a, 0x37563f23, 0xfabda1f4, 
	0xa09cd9e0, 0x42f1de1b, 0x5b47ec81, 0xc1f640d4, 0x25f418b1, 0xfee3eb2c, 
	0x6dc8b686, 0x9f1051e9, 0xbfa0fbd3, 0x74fef00d, 0x86fb7768, 0xfc06b640, 
	0xca1cd65e, 0x93583946, 0x37ea9130, 0xd1b3c718, 0xbb45ae3e, 0xbcbf7305, 
	0xf2c1cd4d, 0xba7367c6, 0xfb3f7f30, 0x176fe011, 0x8a6ebfd2, 0x78ed7a49, 
	0x7c0bde0e, 0x53a6a35c, 0xcf51abb9, 0xbc41fe41, 0xdc44f94f, 0x91eb9665, 
	0xf79f3839, 0xd7fecbe7, 0xa8fb4be5, 0x8e8934ad, 0xee30d5e4, 0x9367cc1c, 
	0xb8a6d4fd, 0x907d2709, 0x4012ee1f, 0xf01363b7, 0x826fdf1b, 0xed2ed83d, 
	0xd073c61f, 0xec1c23dc, 0x45af91e7, 0xa3ddf7a0, 0xc9d578f5, 0x97ad0f3a, 
	0x2ef48dda, 0xc003f3e0, 0x31a6d28f, 0x7d04cdf4, 0x52743c43, 0xd34fbbe2, 
	0x73b3d237, 0xa83d77ac, 0x9443a76f, 0x464b7d67, 0x7d6419bd, 0xf5bea2f3, 
	0xa26fa8a9, 0xf6c74f54, 0xb42a8177, 0x7db97a58, 0x010dfeb4, 0x4a47a82d, 
	0x139b84b3, 0x791eb256, 0x731849cb, 0xbb1399a6, 0xb76dbe40, 0xc92a8989, 
	0xfd899ea7, 0x9f01363a, 0x9dd3f462, 0x2d47ed1e, 0x3f5134fd, 0x9c43d485, 
	0xf06fd21f, 0xf3685a13, 0x35471c59, 0x7ac42672, 0x12f586b9, 0x3b69e7f8, 
	0xd026ffb9, 0xbd0dd4bb, 0xfef0c599, 0xab224971, 0xa1fa9137, 0x9db4d475, 
	0x7f6807d9, 0x29fee425, 0x13f49df2, 0x717b745e, 0x7282ba63, 0x1bfba4b3, 
	0x7af16f38, 0x2271760a, 0x5f9995da, 0xe2b1747e, 0x4469e888, 0x24ed756f, 
	0x76e35279, 0x851e2fdc, 0x3ca3ccdf, 0x6188f37f, 0xe6b36e16, 0x076d78b1, 
	0x7827c3d9, 0xc3889cde, 0x380fd91a, 0x34825c50, 0xe827843f, 0xcf78b1fd, 
	0xfb8469c2, 0xf8b1af88, 0xcc034266, 0xcec47f4f, 0xf0857e59, 0xa8e30f60, 
	0xf8c27f68, 0x59e78bce, 0x1fe08cde, 0x4fc1ef0b, 0xdd5db46e, 0xf09b76c0, 
	0xfda32bd7, 0x91f0f5cf, 0xc20dfde0, 0x271e7247, 0x0f08fbe1, 0xeb0d9da1, 
	0x0b5e9193, 0x0924a50f, 0x7eb7e5af, 0x17f4f385, 0xb99def87, 0x6737822d, 
	0x5eee7c3e, 0xff789f9c, 0x0d05e165, 0x47f200f1, 0xcfb4a90f, 0x1e7e0838, 
	0xaeadbaec, 0xd835fc96, 0x9607c24b, 0x77cc4f3f, 0x8c287b4b, 0x40ce74a9, 
	0x50c35398, 0x4ca6dfdf, 0x3f439f75, 0xbdd53b5e, 0x83fcfd90, 0xd0d2f991, 
	0x7fb20f9f, 0x0f19fa27, 0xfc077fa0, 0x6d64ef38, 0xc113589e, 0x92a6e503, 
	0xdfc13e27, 0x7983fa07, 0xae5efeb1, 0x63e9d647, 0x0b8afbfb, 0x40bcf357, 
	0x376fd547, 0x5f80fbe6, 0xf2d74935, 0xcdad214b, 0xb94a727a, 0xb5c0f11d, 
	0x5bd7c829, 0xeb493ee7, 0x7bcad07d, 0xc0718daa, 0xd001c61a, 0xad6fd6f7, 
	0xc0c6273a, 0x1309b503, 0xaad64ec8, 0x3238319d, 0x011d571f, 0x1ddcd6af, 
	0x5b850f8b, 0x7b213f9e, 0xfafd90b2, 0x6607b639, 0x7e584ec4, 0xc40ede3c, 
	0x63183deb, 0x26ed0fea, 0xff944bca, 0xcfa4e7a4, 0x2d6f447a, 0x5f585ebd, 
	0xb1c5fe47, 0x73c556a0, 0x04f7f50b, 0x1c10edb2, 0x5af07e2e, 0x7e86dbb6, 
	0x6c9cc9e8, 0xbb6d9748, 0x7f05e396, 0xfb2057d4, 0xf360fe5d, 0xd7e41f04, 
	0x00d56b7c, 0x399f48e1, 0x0ae2ed01, 0x3f07f75c, 0x26ac22b6, 0xb9dc43d4, 
	0x2d77ec13, 0xaf076fd8, 0xb5a0a36f, 0x55d644e5, 0x58e87f2c, 0x4df3fe04, 
	0x17e683f4, 0xacf5caf6, 0x7ce95be5, 0x1a1f940b, 0xbe227cfd, 0x64b7e407, 
	0xf28ed1bc, 0xc0fc6d59, 0xdd51fb44, 0x9c73e9c9, 0xdcd32abe, 0xe94fb3f7, 
	0x93999ef0, 0x24f3548c, 0xe61487d6, 0x6810a531, 0x76a9f986, 0xa420fe43, 
	0xd596f257, 0x40e6f8c2, 0xabd820bd, 0x7628afca, 0xffc3f415, 0xe10a6d4a, 
	0xc76ae7f7, 0x66a87da1, 0x7de7e11c, 0x834e2ae4, 0x7e7d7285, 0x0b07a729, 
	0xfb9b1c65, 0xebca9f62, 0x402478d0, 0x541d3ee4, 0x8e937ae5, 0xfb23fd5b, 
	0xf5d8b71f, 0x57182171, 0x2e7d53e9, 0x5065bfc4, 0x1f97e11f, 0xb184b5ea, 
	0xd92aab9f, 0xd279eead, 0x547d3ce8, 0x26d33f25, 0xbd7695f3, 0xd705adb9, 
	0x29f77475, 0x132be48d, 0x76114ae5, 0xc805ca37, 0xf7ce2659, 0x7d03afac, 
	0x7e668780, 0x3c6e3bf5, 0xde125290, 0x5f05207e, 0xe266a094, 0xabb55aba, 
	0x9430b5fb, 0x37d04acf, 0xf58edded, 0x790793cd, 0x5eeb719d, 0x687affa8, 
	0xb38e0612, 0xe2d526b6, 0x612af33a, 0xffe6c24e, 0x1c9df30a, 0x633dafeb, 
	0x7f11fbd9, 0xafe238dd, 0x7bf6d13d, 0x45e3e331, 0xa3b8f823, 0xcc58e91d, 
	0x0d785afe, 0x6cc5eb92, 0x3e309767, 0xef07bf26, 0xa9e85dbb, 0x6f97ff68, 
	0xbc61c656, 0xc08bc963, 0x7fd29b73, 0x07f18f8f, 0x28bdee16, 0x3ae748f9, 
	0xd6bbffa1, 0x1fa1f707, 0x61ec7b04, 0x7da1ec7b, 0x532bd047, 0x538cdae2, 
	0x1cb05690, 0x0a273c09, 0xc69daaed, 0x2efa0319, 0xee77eaf9, 0xbd513f40, 
	0xc8d1c609, 0x7f20f77c, 0x3c94fca5, 0x1dace87e, 0x4a3a03e7, 0x23fe7f01, 
	0xf80d27e8, 0xbba05b57, 0x8ebcdcf1, 0xffa8edeb, 0xa17c58e1, 0xe9230b97, 
	0xd44fec61, 0xa6fe816e, 0x48dc4a15, 0xca7280fa, 0x7f643efb, 0xf47eb10f, 
	0xb2f47eb2, 0x7eb2f47e, 0x5fb2e2f4, 0x6879689a, 0x6a1cddb4, 0xf8ce7695, 
	0x213880fa, 0xe165c708, 0x982ffc3c, 0xfc1e7130, 0x3205dff3, 0x92fe80cb, 
	0xe01e41f7, 0x43fbabbd, 0x86076859, 0x7eb4ed7a, 0x906bd96c, 0xeb576a3b, 
	0x80c0ba02, 0x556d7c95, 0x86e3ce3f, 0x6899f9de, 0xf280be87, 0x5f59f903, 
	0xdb00743b, 0x5b7adacf, 0x480581ef, 0x4edefe9f, 0x99dfcd07, 0xb0d3371f, 
	0x85d30616, 0xecbbfc98, 0xd55fd853, 0xda9d8ac3, 0x5c071e21, 0xa46b9559, 
	0x0b103d92, 0xad5f7152, 0xc8daf40a, 0x874bf282, 0x816f67da, 0x8f3d8b54, 
	0x7de314f3, 0x2df7852b, 0xe59e7941, 0x108353d2, 0x74b95487, 0xcd02f057, 
	0xedc63b53, 0x85d32e55, 0xf996fee5, 0x21a788e5, 0x0ef3c5ed, 0x3ae9f591, 
	0x56efae17, 0x0bbe58ef, 0x1dea90e3, 0xfae14eab, 0x768ff609, 0xedeec473, 
	0xcf51ba0a, 0x0e412e48, 0x2c81a7ea, 0x36abfbc3, 0x8bb62929, 0x1f291ef8, 
	0xad903e39, 0x7f71914b, 0x373c9a69, 0x2394d4d1, 0x3cf1cf5a, 0x31f123fb, 
	0x1ffd7fcd, 0x5d67be6e, 0x2373a3c9, 0x67bda14d, 0x4d4f20bd, 0xd7b17e5b, 
	0xd1eafe0b, 0x7acf671d, 0xee8f7de1, 0x0bcfb89c, 0x185bf0fa, 0xf5c60f97, 
	0x3ec24758, 0xc7c3e01b, 0x8641ff9f, 0x26afd20b, 0xae103e81, 0x4f7f73d1, 
	0xe306132b, 0xff527d1c, 0xe722cfb6, 0xdd7657dd, 0xdb32fc8a, 0x473ff6ff, 
	0x1ff7d3db, 0xb76dd6b0, 0xce7fa3b6, 0xe5c8377d, 0x94da0a46, 0x7794a7ea, 
	0xec925d78, 0xfb0ff56d, 0x1c7cb806, 0xddd88f96, 0x44a5f79f, 0xed9bdddb, 
	0x4aed0ba6, 0x7cc1fa00, 0x71beb1e9, 0x58f64e58, 0xb907ddb0, 0x60fd039b, 
	0x7e7d947e, 0xf7cca8f7, 0x12f7bb4b, 0x9bfa19ca, 0x43bde6a7, 0x576ed9cf, 
	0x00eaf0ff, 0xbd647be5, 0xdf390cca, 0xf68db3d5, 0xf55f7836, 0xc41dbd22, 
	0x285e3c5a, 0xe65485ef, 0x5ea8f94a, 0xd5f2cba1, 0xe9187b7a, 0xc3da33ac, 
	0x68017728, 0x23aaf907, 0x08c6e740, 0xb69faa9f, 0xefcd9ff2, 0x5bf2c4bc, 
	0xd9c60475, 0xfaafa110, 0x1d33ce69, 0x39ff4d7e, 0x976a8dfa, 0xc0eddcee, 
	0x9d8ffcd4, 0xb4bc6fd2, 0xee46fc1b, 0xe8d4faf7, 0xf576e4f1, 0x683f267d, 
	0x7fe2dbf1, 0xaaaef7ee, 0xedc9e3d1, 0x0fe31aba, 0xfebd625f, 0x7f1ca152, 
	0x7c589cbc, 0xe969f8b6, 0xb28547e7, 0xaf4e39dd, 0x8eb76f2f, 0x4f556f29, 
	0xa689df05, 0xb587eaab, 0xe421fcef, 0x2c6ce48d, 0x9c86301c, 0x753d7cd1, 
	0x7e689df4, 0xe370fd54, 0xf672d13b, 0x99156bc4, 0x25a7a005, 0xfc85b97f, 
	0xc3b406f9, 0xbfb74fe1, 0x37b44af8, 0xd11aaf64, 0xa35f815e, 0x45cf4078, 
	0x4dfe4aff, 0x97ca5bfa, 0x1a79c96e, 0x4d65a5cf, 0xab6ee793, 0x4355ced9, 
	0x111d2dbb, 0xc5f6883f, 0xcec5f6ce, 0x6bcf05f6, 0xe24d3f3c, 0xe0becb29, 
	0xe36c4ffb, 0x5fdfa1fe, 0x498fbd23, 0x7b036a3f, 0x0e247b91, 0xcd633d6f, 
	0x5bc467cf, 0xfcf8e247, 0xe2d9f30c, 0xcc3fa6a7, 0x25b87df2, 0x9760bffd, 
	0x76b182ba, 0x1fffd8e9, 0x3aeea939, 0x8e8f6b1a, 0x67c9cac5, 0x6a67ff96, 
	0xeaaae863, 0xf87d65ad, 0x33ffcb23, 0xaae8631b, 0xf528ddea, 0x66aae981, 
	0xf00c227b, 0x7fe720e3, 0x4fcf285d, 0x978bf259, 0x22def0c0, 0x7137daa4, 
	0x7eaa0f9d, 0x8e88afff, 0x60d697d4, 0x1ea4601c, 0x7b7815aa, 0xb579fc84, 
	0xf2c4bc66, 0x6f6dba70, 0x79412e14, 0x333b06ef, 0x3edb2c5e, 0xc53fe528, 
	0x1522f84b, 0xc1ea2571, 0x2b188876, 0x5ca8783f, 0x78f83c41, 0xf40c2ece, 
	0xc849e89e, 0x98fc4b74, 0x4aed0992, 0x58ad39ff, 0xf11df144, 0x2263ae13, 
	0xcc75c26e, 0x0e872dd2, 0x995c65d8, 0x45a57185, 0x97afe947, 0x2d7a42ef, 
	0x37e1661c, 0x8859fbc0, 0x934f3657, 0xaed52afb, 0x8f5c6eb5, 0x58fdfa80, 
	0xf3a67fdf, 0xfe0bc620, 0x31da2b33, 0x85c2fda2, 0x93b2936b, 0x832fdc60, 
	0x88f180bd, 0x47ceb95e, 0x69da0376, 0xad42f397, 0xfaf1d1de, 0xefa27b68, 
	0x9e587d78, 0xc472a523, 0x34b3805b, 0x15e413e6, 0xf7c559c4, 0x7c476a1f, 
	0xe034f558, 0x7b4a41ad, 0xf8a13b71, 0xc3dacb77, 0x84b9ae50, 0xac9d01d2, 
	0x74ed269c, 0x74a97bd5, 0xd938bcee, 0xfa87ef68, 0xf68d13c5, 0x770a235e, 
	0xce0a75a9, 0xabfdf153, 0x205cf0fa, 0xc7ed3148, 0xaaaf8c6b, 0xba0f2f2f, 
	0xf674f9e1, 0x79c8dab3, 0x87afbd7b, 0x5e50bff0, 0x5b5ebe42, 0xb805ded6, 
	0x72699efb, 0x6f7ad27d, 0xafbd04f5, 0x9c8bf717, 0xa43f5f7a, 0x7979420f, 
	0x3daab8d4, 0xde619fe0, 0x38934fd6, 0xf01f3abf, 0x83f6585a, 0x0cb5a8e7, 
	0x90d304a1, 0x596ca17e, 0x55d8298b, 0x2dd573b0, 0x16eafe92, 0x3ce23f49, 
	0xff88f3f4, 0xbb3e6132, 0xbc11fe98, 0x4c0fd4ff, 0x7dc117cd, 0xa4155542, 
	0xca1f7093, 0xb68e5371, 0xb928a5ed, 0x8d185c65, 0x9f7c5b1b, 0x0e290f8e, 
	0x7bf922fe, 0x7be5e217, 0xef4b890d, 0x232af943, 0xf7c6caf9, 0x0b8433fa, 
	0xa5ef7fc7, 0x8f9d3650, 0xf073504a, 0x3fc8edbd, 0x3f7bd3d0, 0x6ae3963e, 
	0xc7c37685, 0xf4bb3d69, 0xc62f5d7c, 0x026f5009, 0x227483d6, 0x26f503f6, 
	0xdea0db14, 0x2c4daf6f, 0x6bbfd487, 0x7be8aecd, 0x0e50fe1f, 0xad2247eb, 
	0xbbe5574b, 0x57b0e95b, 0xe112687a, 0x2ed269f2, 0xdd243788, 0xda1bc7d9, 
	0x0e500e49, 0x26bd3c2d, 0x8c694712, 0x8d3e2db3, 0xb83af7f0, 0x8ddfe2da, 
	0x966aebe2, 0x7f946af3, 0x9c2ae798, 0x294a46df, 0x4d3338be, 0x39c8e1ca, 
	0x44df9611, 0x455fbf9c, 0xb829b7e4, 0xb2da2f65, 0xbebfb747, 0xf88c4d57, 
	0x3dc47ec9, 0xf18d2e32, 0x6c38f197, 0xe81a9f94, 0xcf53f58b, 0xa6783128, 
	0xc3f957ba, 0x1c78a9fa, 0xc6357037, 0x333f579e, 0x54c7062f, 0xf18bcef7, 
	0x587ef14f, 0x9a617df0, 0xf32287bf, 0x74f999f7, 0xf9fc53e4, 0x1c75ad2f, 
	0x71d3d3e6, 0x2c8fc671, 0xe207fdbc, 0xf91e3c53, 0x58ffaf25, 0x2e3a7a7c, 
	0xe311f8ae, 0x29f0ebf3, 0xfca46762, 0xa35a6f55, 0xbb01ffa0, 0xbc38c41b, 
	0xe29e537a, 0x17f6c358, 0x4d8127da, 0x4ace03b0, 0x2e7bbb44, 0x9d1b1ed6, 
	0xd837f631, 0x37f648df, 0xec07e688, 0x5a728a8f, 0x71ce7f7c, 0x40b0d7ba, 
	0x776587ce, 0x74ddb36d, 0x8fae669f, 0xee442def, 0x39ef1d39, 0xed13e727, 
	0x2eed0dae, 0xf506c7bc, 0xaaeca34a, 0x8e38826d, 0x14e6d776, 0x66eed1c7, 
	0xaeed62fa, 0xd10463cd, 0x24f966ee, 0x1be5b4fe, 0xd8bbb441, 0x11c6e20f, 
	0x8078cbbb, 0xfa506cf0, 0x23e39dcf, 0x4f9975f8, 0x17e26dda, 0x57f465fb, 
	0xa70e5755, 0x1ea5b826, 0x7a941c77, 0xf52831dc, 0x094fcd18, 0xc8d511c7, 
	0xf6d1ceef, 0xc675ed1b, 0x6e3b110b, 0xae2b6bd9, 0x651d7b27, 0xcf17ae87, 
	0x6dfb567f, 0x22242bad, 0x7423fb9d, 0x2a7cc03e, 0xcd3b5dfe, 0x6351756b, 
	0xb8a79d2a, 0x66e74a98, 0x76f5d38b, 0x50e277e4, 0xa4397b47, 0x037ea0eb, 
	0xf260b3fa, 0xc48b40ce, 0x0fe2c2f1, 0x717541c8, 0xd722aa63, 0xaa6d84b9, 
	0x0eb4f7c4, 0x642f3179, 0x1a3c3e03, 0x6ea7de4e, 0xfae8a985, 0xa43b3eda, 
	0xbf3ff95f, 0xe14770cb, 0x7e38dbfc, 0x403f5f8b, 0x01660df9, 0x6a3fd87f, 
	0x31671fec, 0x9f00ab9f, 0xac04c075, 0xa8ec45f2, 0xbf9201c4, 0x45b6eb88, 
	0xe66a87d9, 0xb93e4dc7, 0xc0dff98e, 0x5ef24981, 0x084efea1, 0xcb2d647c, 
	0xc03ae259, 0x1f4fe133, 0xc3a6f577, 0x9c0e8ea9, 0xc83f1817, 0xc8bea3e5, 
	0x191bf939, 0xbfef857f, 0x94cd638b, 0xe9ef141d, 0xf8c0b687, 0x0a49c3ed, 
	0x2a4a6bde, 0x8f10d337, 0xfa0a4ca5, 0x6dbb3cf0, 0xbb9a6f56, 0xe919ef05, 
	0xb8d7a409, 0xcf11baa0, 0xd575cb41, 0xd7c662aa, 0x3889a60d, 0x7638aab1, 
	0x27ddadfd, 0xa4277de5, 0x1e6497d9, 0x81555071, 0xfe2affd4, 0xd33b462e, 
	0x695e5233, 0x63f307d9, 0x0100cfc4, 0x59e20ac3, 0xbf7130bb, 0x7206c871, 
	0x97be1f7e, 0x154063ef, 0x5e7067dc, 0xfdf3a3cc, 0xf5002e78, 0x3a7179d7, 
	0xfccd37ed, 0xb4827793, 0xea5178cf, 0x9bc37399, 0x106807aa, 0x486983cd, 
	0x546fddcf, 0xe7253d13, 0x34fad68f, 0xee874efc, 0x5eb1ceb1, 0xb7de18f8, 
	0x3fb10cc4, 0xc45b3555, 0x2c7de35f, 0x15eed7ec, 0xba03f5a2, 0xfca1ea97, 
	0x36dae9c5, 0xa4e94718, 0xef787d17, 0xaf317ecb, 0xba45db75, 0xfd8695d7, 
	0xfd799556, 0xaa63e7db, 0xe05fb5e3, 0xbfb62987, 0x26f3fc81, 0xac3d46ef, 
	0x7edc2c6c, 0x6025d21c, 0x6e7ef1cf, 0x83e4f74b, 0x078ebdf8, 0xb4f7db07, 
	0xfbcf9603, 0x71869f2b, 0x3cf3c7dd, 0x37d1ea1a, 0x6e0df7e5, 0xd39ef8d7, 
	0xea109ae4, 0xe273fdb9, 0xfa6fde12, 0x53ee4f91, 0xbdb17158, 0x537dd052, 
	0x20a4067b, 0xc7b6767f, 0x3de4fbaf, 0x84feb14b, 0x89597c82, 0x9d79817c, 
	0xff905d3f, 0xbcd2fdbc, 0x9e06d9e3, 0x1055aa5f, 0x6fac2d57, 0xffd0126e, 
	0x13457bc2, 0x055a05e3, 0x6d41385c, 0xa6e8bf62, 0x558a47fc, 0xea7e8a9e, 
	0xd2e69bfd, 0x5343bcfe, 0x2c67189d, 0xcab3aeac, 0x106168d3, 0x63cf2958, 
	0xf6757bcb, 0xf13fe33a, 0x15b24d3e, 0x2f77e1cf, 0x3ffd7f70, 0x0ccd6ffd, 
	0x9c26f8c1, 0xc6f681d9, 0x0599f207, 0xd995bee5, 0x3ff41a5a, 0x82fba1a3, 
	0x13fc03d2, 0x47289c8b, 0x0feb95be, 0x887c93a4, 0xd0cfcc44, 0x1a5badbd, 
	0x07125e49, 0x4ccf4768, 0xb754a41c, 0xdb79945d, 0x93e520a5, 0xc93e6586, 
	0xfb750a24, 0x7b4d4a49, 0x8ef2887f, 0x5c779901, 0xc9a0eb91, 0xe173d11f, 
	0xf285b13a, 0x8a9453ae, 0xfccb6f71, 0x3e6577b8, 0xa7ccbce5, 0xdf3a410c, 
	0x5c40ec69, 0xd4fe975a, 0xeba3885b, 0x231f9e3c, 0xc493d55d, 0xbdf75c4e, 
	0x40866a0d, 0x95f4d5df, 0xfeffa16f, 0x1cf7909c, 0xadfb7d2c, 0x5ca3ae4f, 
	0x30527b63, 0x6393ea5d, 0x33f500f1, 0xa12e2ec3, 0x6b35391e, 0x9fe606fd, 
	0x154c4bf6, 0x3728bdfd, 0xc1d87f69, 0x50edb3e5, 0x1de92a61, 0xc6cf1fed, 
	0x22eb1f93, 0x15ea50f3, 0x9e01232e, 0xe9d7deeb, 0x30bd659c, 0x38115f5a, 
	0x683fb211, 0xe44dfdbe, 0x2bb763e6, 0xaefee887, 0xa53efb8a, 0xaafd1f50, 
	0x7dc5fa1d, 0x7bcfe4e4, 0x5c3de14f, 0x5cf65c6b, 0xc90c3788, 0x53973c17, 
	0x5a8c0e5e, 0xe033a117, 0xe30ac706, 0x48f10729, 0x61321b01, 0xa26f94ba, 
	0x7f48fc97, 0xd91ab88a, 0xce18aa6f, 0x72a6fda3, 0x622dc73b, 0xfdf44a65, 
	0x67bf1d19, 0xa799ef02, 0x8e4535bb, 0x7fce853b, 0x95ced218, 0xfbce81da, 
	0x2e303f91, 0xeeafed07, 0xa23973a1, 0x49cf052f, 0xeb13f345, 0xaba30917, 
	0x82e49fa5, 0x03af98fa, 0xf139855e, 0x57ecf8c3, 0x36e13964, 0xb35bdf3e, 
	0x79fba4c2, 0x63a144ce, 0x8681493f, 0xd61da31f, 0xce767b4a, 0x95ff110b, 
	0x55e7d00e, 0xd4a29f3c, 0x77537da0, 0x31e99cde, 0x821be076, 0x3d726bbe, 
	0x3d33503b, 0x93ea7f72, 0xe982c0ec, 0xe8bf7ef2, 0x0ec620f9, 0x26ffebc4, 
	0x147cd41f, 0x4b4ef7f4, 0xc4f9e5ff, 0x9bcbab85, 0xf7ad5f50, 0xa5fb5d10, 
	0x82b9f05e, 0xa942f0e4, 0xbbaf321f, 0x74d77f30, 0xe1bb5eeb, 0xe4b0f9c2, 
	0xd353bf15, 0x8fa27a4f, 0xfca0481b, 0xf54a41b8, 0x3a908b94, 0x23e4cd12, 
	0xef7c9e50, 0xcfe71525, 0x9da0f9f1, 0x0dcb11f6, 0xbe4e7fda, 0xcf1537af, 
	0xde6b27d9, 0x0eabb472, 0x9db3ff4d, 0xebbb4c4e, 0x7f402fb6, 0x0fb93fa8, 
	0x66a26cec, 0x2df7901c, 0x2b8835f4, 0xa76b79dd, 0x11e47de3, 0x64fa1efe, 
	0xd327fb3b, 0x36cecc6f, 0xdb3b674d, 0xecc6f17b, 0xa7e022ec, 0x45148317, 
	0xf2c9d2dd, 0x7615eb80, 0xba00e95d, 0x9df9feaa, 0x46bae31f, 0xf50ff22b, 
	0x1525e97d, 0x5963bd71, 0xf503aa6f, 0xd5cf26d9, 0xb697d495, 0xde58dd2a, 
	0x25e58a93, 0xe807cdf5, 0x2fd7101c, 0x6dfb3fb1, 0x403f53cc, 0x094d7e87, 
	0xbd7e2085, 0x5367e1fd, 0xedc99cf1, 0xfc47bf0f, 0xd4229dd5, 0xe45da206, 
	0x3e9173e5, 0xa8b22e79, 0xd76bbbae, 0xaa72510b, 0xf35bfe4b, 0x15dbcee1, 
	0xae67cfcb, 0x8073af23, 0xfeef409f, 0x55b57938, 0xd3f20a1a, 0x9e106196, 
	0xbab9f1b7, 0xed792ca7, 0xdea0a93d, 0x173f28df, 0xba72902e, 0xfc9cbab0, 
	0x405f6598, 0x13f16bbf, 0xba05f619, 0xa8affb8a, 0x970eb88f, 0x13b5d154, 
	0x7f80e1d7, 0x9c60d33b, 0xb57966df, 0x967ac8b7, 0xa4af0a9e, 0xd2a7da1b, 
	0xc43b3d79, 0x3b5ef01b, 0xeb89dbca, 0xdd955bcb, 0x4b1749dc, 0xe7115e60, 
	0x15d88e24, 0xadcf17a0, 0x73dfa0f8, 0x76829fd4, 0x4daf1ad5, 0xdf85a6f3, 
	0xce8dfac0, 0xc73c0e7d, 0x7f501224, 0x5e81072a, 0x7aeecfdc, 0x39c68d4e, 
	0xf28d7c22, 0x499b7ed7, 0x48b3ba7c, 0x492aa9f2, 0x641b4f28, 0xbce0b7bf, 
	0x3dfe471c, 0xc1e072c6, 0xea142134, 0xd10ea9a4, 0xdfb075bd, 0xe32273db, 
	0x405fb3b0, 0x506ec0f9, 0xe4a2323e, 0x502bf2c3, 0xcf12108e, 0x92c278b5, 
	0xbb9e0f1e, 0x27ba0514, 0x2670eb4c, 0x0e5887e5, 0x2e8d4a8b, 0xda0a2fb6, 
	0x536efc74, 0x2fbefef4, 0x03df18cb, 0xf9f1177d, 0xd1089b40, 0x8bd00179, 
	0x5f3cf27d, 0x7bda3f70, 0x8b4a4330, 0xf9f1fd89, 0x1f3c9f30, 0x2d7d8776, 
	0x6eddc1e9, 0xfe009831, 0x39927a6b, 0xf88d15fe, 0x0491fe9e, 0x20271998, 
	0x104aa96e, 0x7eb6db7b, 0xa0293dc2, 0xadc5f70a, 0xddebcdfd, 0xe1f88293, 
	0x5fefe300, 0x67de6105, 0xe87f83d4, 0x1cfc8fc6, 0xa437eeb3, 0x1c2ffb47, 
	0xd97f8e07, 0xefa0bf4a, 0x74ebd4de, 0x4369624e, 0x60222e0e, 0xfc31993f, 
	0xc0fa21d0, 0xfcf2f5fa, 0x95a88344, 0x46dd1de7, 0xff67f606, 0x216f7055, 
	0x861cb1d0, 0xabbaeb84, 0xd12f7e90, 0x9f3e89e9, 0x7ccf5458, 0x4739e5d2, 
	0x88733de8, 0xac8845ce, 0xfce95b2b, 0x8b7ce7b0, 0xdf1c2f9c, 0x2cbefaf4, 
	0xbcad3794, 0xc2579e54, 0x942cf0ef, 0xed4fd5f3, 0xf203f1f4, 0xc1f8e27c, 
	0xb1a7e444, 0x27e268ef, 0xb31c33f1, 0x7e3d7c5f, 0x92fca266, 0xafdf90df, 
	0x03e2b8a1, 0x28f6c3e6, 0x4a9f98ba, 0xf6e3d8f6, 0x7275c915, 0x7da83e8b, 
	0x87b3cb10, 0xf6d67fdb, 0xb7c8e226, 0x065d24b2, 0x7acc55d1, 0x5ac39d63, 
	0xf3a6ee5a, 0xc0fa6a8c, 0x065d30cf, 0xabde4900, 0x5b87d335, 0xcd67f322, 
	0x9e76ae9b, 0x0cb47b45, 0x85f11be6, 0xe74f6e56, 0xbe722bf3, 0xae8001b3, 
	0x7848d4a3, 0x64f9d3f8, 0x1f9e5d7e, 0x75dcbebb, 0x0271d6df, 0xcafea0fd, 
	0xfb68e73e, 0x0677f783, 0x06a4e3a0, 0x28e3086f, 0x2b8845db, 0x39b49ee9, 
	0xba4be91d, 0xabe39d38, 0xde01f7c8, 0x7ba4c14d, 0x17d239de, 0xf78eddf9, 
	0xefa33f3c, 0x65343c76, 0x93e21175, 0x1dc453f7, 0x2b69eeb8, 0x79f02bd5, 
	0x8151b952, 0xfe46af74, 0xaf618d35, 0xefa79f7a, 0x2bd88c1c, 0xf7ca7bf1, 
	0xfe69b8b4, 0x8354ec46, 0x2dc253b4, 0xe1460f5e, 0x0de89139, 0xf0cf7bc9, 
	0xc6eefc06, 0xed1566ac, 0x35f786bf, 0x14baf10e, 0xaf1211c5, 0xd69d2689, 
	0x9d4ac4bb, 0x5ca46aec, 0x739ce957, 0xf3e9d082, 0xf93ad926, 0x51a0ad5d, 
	0x2139d071, 0xb61e263d, 0xaf3e29da, 0xdc2b7c40, 0x7eab5fb2, 0xe5535fa4, 
	0xb714acfb, 0xc910fd42, 0x31d7e589, 0x89185e9e, 0xb7af15a7, 0x3a3f5955, 
	0x49150ebe, 0x9164f3ff, 0xb8adaf8c, 0x60f5701a, 0x4b4bc832, 0x69b7af11, 
	0x6f6cb3e6, 0x71512dfc, 0xd5c403b7, 0x9bea8eb9, 0xfa9165c9, 0xcf0dfc56, 
	0xbe27ec75, 0xd4373c3d, 0x4c6d2987, 0x70572a88, 0x2e4a2b3d, 0x6e2b53e3, 
	0xe2c21a37, 0xd7922d84, 0x0b458797, 0xa51981d8, 0x58f5e142, 0xd4c0e385, 
	0x4a3e322b, 0x4bc648fd, 0xb7a413ee, 0xafce9b86, 0x319233ae, 0xabe28c7e, 
	0xce3af91b, 0x3df82ba5, 0x489d6d22, 0xd095df96, 0xeb893695, 0x51af90d3, 
	0xcd669bf3, 0xb7f61b43, 0x7bc54cde, 0x4a6dae51, 0xbe7916df, 0x77e5cb8d, 
	0xdd028b08, 0x5840fb5d, 0x2ddf33cf, 0xe15e925c, 0x9eb95536, 0xf2073c19, 
	0xba34e455, 0xffe1442e, 0x4840675b, 0xd449f64d, 0x41700e22, 0xee4fb3cc, 
	0xfa4fd3b7, 0x5f03d963, 0xc3fc961a, 0x33513980, 0x00b1df3f, 0xdbafa9c7, 
	0x925a7a0d, 0x20e6b8da, 0x96494fc8, 0x33bf657e, 0x710d4fc2, 0x176978dd, 
	0x863dddf6, 0x12ee685d, 0xd60bb061, 0x470c1d3e, 0xac65be45, 0x7f5c0e13, 
	0x6c7f60ce, 0xf038675b, 0x3ad2641c, 0xb4fc8ec3, 0x5e98c367, 0x1807ad19, 
	0x04dc53df, 0xc759e86a, 0xeb8e7c72, 0x0af74e23, 0x1bcb2833, 0x275ca9d3, 
	0x20fc86bd, 0x99e14796, 0x333df904, 0xdf300700, 0x3d609d46, 0x884c1337, 
	0xe48a07b7, 0x39c89a39, 0x64bb5373, 0x54d87aa0, 0xb7297de3, 0x77bd016a, 
	0x6bc21d50, 0xe78bc2e3, 0x263de088, 0x3968c9d9, 0x44b4fe83, 0xdb10ff79, 
	0x9db1b8e1, 0xf72915e7, 0xb07ed0e9, 0x1b76e248, 0x9d8750e3, 0xe97f41eb, 
	0x538f7465, 0x5b35d77e, 0x7c7eb178, 0x3b41dfff, 0x7fce5976, 0x4c9bf690, 
	0xbc7694c5, 0x7366ec80, 0xe267dc9a, 0x33f0f97b, 0xcfc96df5, 0xf8caefa9, 
	0xfcbf7a7b, 0x3efc8c4e, 0x0a85f792, 0x79cc67e9, 0xbed93fe4, 0x3fe5343e, 
	0xdbc69ec8, 0xf972a4d9, 0xb3b2247d, 0x773724f5, 0x72813cef, 0x401e67a3, 
	0x8e32c9f9, 0xe88e19ec, 0x81f1e8e7, 0xe3735f9d, 0x46bc53e3, 0x192f3c85, 
	0x6f97be3f, 0xb32f7c68, 0x0e519fdd, 0x89d72efa, 0x748b9668, 0xd79c79c0, 
	0xf8e6a068, 0xbe187be8, 0x9bccc1cd, 0x99144ec0, 0xfc01e712, 0x0446b894, 
	0x827ca00f, 0x6788283a, 0x3bea69ee, 0x3fb178a8, 0xca59f73e, 0x1cf89df7, 
	0x79c46af5, 0xcf289eb4, 0xb4ee0299, 0x01e50a70, 0x3ed2640f, 0xc197dba6, 
	0x9e432638, 0x41e7950b, 0xdbfc67e1, 0x77d01f12, 0x97ebaf42, 0xc21b8cbb, 
	0xe6a5432f, 0x5197de00, 0xf19bbf45, 0x33c71b85, 0x1d42f19f, 0x33c005e3, 
	0xe6eb8869, 0x83fe0397, 0x773c36e7, 0x01e601fd, 0xfee375e7, 0x7dc41188, 
	0xa953f007, 0xa352d76c, 0x6a914f71, 0x75e36d74, 0x50d01c07, 0x0381c9e9, 
	0xd91f7a3e, 0x6e1fc057, 0x96eb073e, 0x6f6910fc, 0xa7a6f8c3, 0x697b699a, 
	0x5a0e8c3e, 0xd1dd5b37, 0xc88cde2f, 0xbd3fd415, 0xfc647c6d, 0xe76d1708, 
	0x11358e99, 0x4a97e63a, 0xff83aadc, 0x5e6195b0, 0x3e8b53e2, 0x9d160f8b, 
	0xacd7ae3a, 0x2c3a74fb, 0x8f74583e, 0x43bf01f0, 0xd3a688eb, 0x9c27ed4c, 
	0xce5f7602, 0x41d21a73, 0x6b728bfa, 0xa28dfd07, 0x21cde88f, 0xb07cf8ba, 
	0x1783e741, 0xf9e5f937, 0x6e3cf5e5, 0xfa2278b7, 0xc38b25fb, 0x35167e72, 
	0xb0db69a5, 0xf74edcbc, 0x1f2cedae, 0xbe2d4bf0, 0xe8187167, 0x15efa46f, 
	0xecf7413d, 0x8bf7f257, 0x3407074a, 0x6c5e446f, 0xe89ebe7c, 0x0cf2cb72, 
	0xc27e58df, 0x0df07cbc, 0x07c313f2, 0xb2884dfe, 0xf47acd5b, 0x6c0f3363, 
	0x21212974, 0xbc7f0d26, 0xc9abe31b, 0xdddfbfc3, 0x77ebf306, 0xd72c7699, 
	0x24c3fbf1, 0xde1b7a2f, 0xa5fbcb77, 0xe20e7670, 0x9f2cbebe, 0x24fa79dd, 
	0x42bce8e2, 0xbdf70dbd, 0x0eb388fc, 0x85a0fdd3, 0xd053efb8, 0xcc1dcf26, 
	0x90bbaf1c, 0x1fc9652f, 0x50bde3b6, 0xfda74bbf, 0xfa7f998f, 0xe7e436ab, 
	0xe28526c4, 0x0f97099c, 0xe2f56d77, 0x31799239, 0x297957fb, 0x5abad12f, 
	0x1d8e8acd, 0x9f9ba838, 0x50d0ee9f, 0xf1d41249, 0x9ae3ae74, 0x88f5c412, 
	0x21e2fe5b, 0x4c47ae0f, 0xfc5d4330, 0xb44c977d, 0x4a839517, 0xa98f9e26, 
	0x699b58ba, 0x89ebf297, 0x396e8b8e, 0x8e0566b2, 0xb454deb7, 0x4afbe044, 
	0x2086a6a1, 0x573e6fad, 0x2ae30496, 0xe7556e7b, 0xb9f79054, 0xbd68d2c7, 
	0x5a6cecb4, 0xadfdef10, 0x5ae6f3e2, 0x9bed037e, 0xf44dbcce, 0x36bebee1, 
	0x75c1e7d5, 0xbbc0ad4b, 0x421bae42, 0xc1718afc, 0xee82d2b7, 0x3e7cf8f7, 
	0xeba9c2e2, 0x0e24d33b, 0x90b6933c, 0xbdd161ee, 0x8f1f2830, 0xbbf213e5, 
	0x2f3f70bb, 0x3bd824e7, 0x28af21c4, 0xec2c7fb4, 0x8b01c526, 0x75a154ff, 
	0x3bf7c172, 0x0fb5ce47, 0xfdc2ed1e, 0x83eb65c0, 0xf757a899, 0xf00cb9e0, 
	0x6649396b, 0x62bf15a6, 0x3e2792fb, 0xebfde0f4, 0xef6d6f79, 0xe7cf0e9c, 
	0x39d43a9d, 0x0bef05bd, 0x24ce740f, 0x13f6053c, 0xe772fef9, 0xf71bec7e, 
	0xbedee94b, 0xfb8c14d0, 0xcd9854cb, 0x377dfcab, 0x86606ff8, 0x8b2bcb8c, 
	0x44ccfae5, 0xa603734e, 0x73bf6d1a, 0x1ceb0d8b, 0xc0177d02, 0x76494bc2, 
	0xf27da153, 0x3a415d22, 0xda0b6ec9, 0x1f6852b7, 0x46ac303c, 0xe2dceddb, 
	0xbefa355e, 0x360fb59d, 0xbc5367a4, 0x63dc43ad, 0x8bd9bc80, 0xd0e6bee5, 
	0x1fdcb081, 0x43fb966a, 0x718efdd6, 0xcfc3bf7c, 0x15f9c6b8, 0x70f885c5, 
	0x85dd24ce, 0x66fafddf, 0xf5ffdcb1, 0x6e5d3af3, 0xa27aa9b5, 0xfe41f1e9, 
	0x709e846a, 0xb6070471, 0xd65d027e, 0x3e893077, 0xcb0efd81, 0x3e8b7e7d, 
	0x7d0c70df, 0x51bf9867, 0xd176f0e7, 0x3cf94af7, 0xbeb67fab, 0xfb05cf0b, 
	0x3c211917, 0x866d7c07, 0xf274ffdc, 0x0aff5739, 0xba7a8e78, 0x918508da, 
	0x177d3afe, 0x007f43da, 0x677d41da, 0x3d1039a5, 0x2b62fe4f, 0x09e6d9ff, 
	0xaff189c7, 0x207872b3, 0xc5fcbe7a, 0x867a679c, 0xb40dcf7a, 0xf28ec978, 
	0xfc8345fd, 0xda4f75a9, 0xcbc3e78b, 0x3671eea2, 0x14a21ad5, 0xdeed10f4, 
	0x68af3117, 0xe69e615b, 0x48ddcd3a, 0x7929f807, 0x9fde344f, 0x91f67bc1, 
	0x96f7979d, 0x1dba5cf3, 0x4c4d19cf, 0x25b7deeb, 0xb8172514, 0xfcf06e3f, 
	0xd5f08c5f, 0xf84e7719, 0x1e72c5ab, 0xc73cf356, 0xfcfc77cb, 0xf03bcbc4, 
	0xa3473adf, 0xe8979f12, 0x23ec8cef, 0x37f3eb8a, 0xae126ed9, 0x74a5e4b1, 
	0xb962ae91, 0x3cc1fa13, 0x88dccb6e, 0xe3f3589e, 0xcf2bdd5f, 0x5ddff08d, 
	0x96692ff0, 0x5d786de7, 0xb5d333e7, 0x265d3056, 0x325fe1d1, 0xba113f22, 
	0xbcdf5906, 0xe9665c11, 0xe30bd11b, 0xc245d977, 0x43267458, 0x4e859fbf, 
	0x4972daff, 0x2fce4adf, 0xfa63f961, 0x15c669c6, 0xdedfafde, 0x5b9cf30e, 
	0x7ee75a64, 0x73a89e88, 0x3b8f743f, 0xaf459d77, 0x6f59cfa4, 0x339bccc4, 
	0xe4a3cd60, 0x975da257, 0x3c16b8f3, 0x1e846355, 0x79a75d87, 0x0d29e8b4, 
	0x44cf3498, 0xe0be6097, 0x1ed88afb, 0xebb93d30, 0xb195be98, 0xeface8f3, 
	0x6737998d, 0xe2d1e780, 0xba11a2cb, 0x78ba58d4, 0xeb0d2b1e, 0xfbd497dc, 
	0x689dfd12, 0x8e57f83e, 0x4af245d0, 0x1e8f77e3, 0x183bd137, 0xd5d2d791, 
	0x374d1aa6, 0xb5d229c9, 0xe4b2e988, 0xc637b2ac, 0x67c88dee, 0xd13bf349, 
	0x3257fbf4, 0xb9af2c5d, 0xa57e7195, 0xbf9988c4, 0x952bf61b, 0xd2547271, 
	0x28f7c31b, 0x7288d939, 0x4a07e232, 0x6e7eed62, 0xf29795a3, 0x3ed97ff1, 
	0xbfdbf3c4, 0x8dc8c454, 0x9bd2dcbf, 0x94dc903f, 0xdc8dfac4, 0xb918e1c6, 
	0x8f2d2ff1, 0x397f1791, 0x1fd309eb, 0x3aee6f4f, 0xb1cc7e4b, 0x11a967e5, 
	0x4afe5f23, 0xfe07a311, 0x7a207312, 0xddbf485e, 0xb2daf5a3, 0xd73d160f, 
	0x2c75af9d, 0xee4f4c3f, 0x7918ded2, 0xc79657f2, 0x64bfbfc8, 0xe693e078, 
	0x7d56ecb3, 0x47c3c489, 0xf0951453, 0xc3c61ef0, 0x070f107b, 0xffdd3a5c, 
	0xe53b46aa, 0x214eba25, 0x8ffd9e1e, 0x32070f12, 0xda0d7964, 0x1efc6eb5, 
	0xd09ff2d7, 0x5f186cf7, 0x9c669ecc, 0x673c7c42, 0x082e3192, 0xe58e66fe, 
	0xd4af19af, 0xbfc2faf0, 0x0deb94cf, 0xdc4a67c7, 0xf8c25c94, 0x1e758ce9, 
	0x1af794d1, 0x1efb195e, 0xa46ec069, 0x0e5f5f10, 0xb9c239d2, 0x8e709f50, 
	0x0ce1af75, 0x9dec239f, 0x4af6f927, 0x88523dec, 0x2b4e297b, 0x2570187d, 
	0x75e52fb4, 0xe2af0b19, 0xbe9fa1d4, 0xf8a14bb9, 0x85ca2608, 0x273398eb, 
	0xcfbc2e99, 0xd8c8737d, 0xa0f9dfc3, 0x0f019ffb, 0xe2107f3c, 0x75ef2338, 
	0x6725f7b4, 0x8f10bb3c, 0x9af4fcde, 0xa5c7c472, 0x200f479d, 0x67bee89f, 
	0xdd1fdd1e, 0x78be3885, 0x825df2ed, 0x23ed2c71, 0x89ccfdf2, 0xd709c706, 
	0xc7ea3fb9, 0x7c8397fb, 0xa9e7148f, 0x167a275c, 0x7714b51b, 0x74b5112d, 
	0x21b172de, 0x40edc371, 0x578d0b4f, 0x684df7ae, 0x05d72a3b, 0x3724798c, 
	0x29c4b2b3, 0x5388579c, 0xd7bf44c2, 0xefbe8eee, 0x9d9bdd6f, 0x2ee198ad, 
	0x1a66d5c2, 0xdbee87f2, 0x8c619c52, 0xe8eb777f, 0x67dba47b, 0xeb04fdca, 
	0xdf6528bb, 0xfd8fd55a, 0x1cb4dc43, 0xeb9990e3, 0xa7185cfb, 0xdcf872dc, 
	0x8c4d4ade, 0xfcdc47ac, 0xde22a288, 0x1836f9bf, 0x52ebc817, 0x9bad1750, 
	0xf28e9bde, 0xeb54d25a, 0xf2def7c2, 0xdd7bd3ad, 0x28cddf51, 0x65df9549, 
	0xf47bdb2d, 0x1ea1bcac, 0xf9760f7b, 0x2f7ce597, 0xb2f73e6d, 0x4c99f68d, 
	0x3dd663c2, 0x5bf7c158, 0x32549de7, 0xc117de70, 0x2e21b3f8, 0xb8dce92e, 
	0x9292e30f, 0x3053570d, 0xf1d92aee, 0xab573a1d, 0x785c39e3, 0xfc7be01e, 
	0x8b9f3f5a, 0x2e3f96f6, 0xdcfbbfa2, 0x0bb845da, 0x8c5a41d7, 0xa9ddfba8, 
	0x9f2b9d26, 0x3148ce39, 0x561ebf51, 0xf1baa7ec, 0xeec0e7fe, 0xaf7873fa, 
	0x8eb7607b, 0xa46b997a, 0x0771849c, 0x3d5ea1b2, 0x4dd8b5ca, 0x0f7c32fb, 
	0x645a2022, 0xc6e501b9, 0x01107be8, 0x20bfb437, 0xf8093353, 0x0620f78a, 
	0xe3b75f89, 0x1f6f03fb, 0x273c2d76, 0x5885dad3, 0xd97af12e, 0x31071de3, 
	0xe294858e, 0xa4fbd9d2, 0xd87a5b3c, 0xffbf225e, 0x8f6e7237, 0xe17c5bef, 
	0x8eb493c2, 0xe8cb2b3b, 0xa1e17dc3, 0x7dcc7f6e, 0x73fbe289, 0xd4e31efe, 
	0x3dcde359, 0xfe67a061, 0x023fe94c, 0x60ec82f9, 0xf6abfdf1, 0x51599c63, 
	0x3ce74bd8, 0xb4134d67, 0x7a889d1e, 0x7e2bed0e, 0xefc4d474, 0xb97bdd92, 
	0x7efc6df3, 0x1fb609ee, 0x7ef25925, 0xd9cf5afe, 0xb239d97d, 0x9f3e3f5f, 
	0x3ea1ef2c, 0xdbecfb30, 0xa9b70e78, 0x97f3ae44, 0xbff5934c, 0x3f7d22b4, 
	0x44b47f3e, 0xb32511c6, 0x8f907d64, 0xfe6eb83d, 0xeecec7e5, 0xc43eefc1, 
	0xcfc577cf, 0xe29efed3, 0xff197ed5, 0xcfbcda7f, 0x0b9cfe7c, 0x1796fce5, 
	0xd0f9d34f, 0x78af3978, 0xc3897152, 0xdfd0cf2c, 0x6d3cf09c, 0xe3cb20db, 
	0x187f9639, 0x1b0dccc7, 0x502db453, 0xcd28f3bf, 0x51bba40b, 0x381f67de, 
	0xc38c13fa, 0xbd1df62b, 0xfa225153, 0xc800fb31, 0x4de7e42d, 0xdfee7a96, 
	0x0adbe8f3, 0xe2832dd9, 0xe30c8a89, 0x778e7827, 0xba3af1f5, 0x82f38627, 
	0x10aaa5df, 0x1512d986, 0x90a8545f, 0xafd75a8f, 0x22f362d0, 0xabdbc65b, 
	0x5098ded0, 0xa9e607be, 0xb067623f, 0x63eb8d3f, 0xfa2fec75, 0x17f6101c, 
	0x0e359f9d, 0xfac831c6, 0x9f5a38df, 0x591b8f49, 0x2b9f41af, 0x8fda3e5e, 
	0x30abb1df, 0x9657f58f, 0x786fd68f, 0xfbf47f5f, 0xfd277d2d, 0x3bfbc3ee, 
	0xefa0c9df, 0xe8fda09e, 0x443f7d63, 0x97f0da7a, 0xdf2e8fd2, 0x57207801, 
	0xe3e16e3d, 0x7bf373f8, 0xf9c73f08, 0xcabe40ad, 0x5374c138, 0xe338e33e, 
	0x19addd04, 0x1ee7ceb4, 0xb02d9fcb, 0xe3b4348b, 0x52f939d6, 0xe58dc84f, 
	0xcc1fa1f3, 0xaadfb0d7, 0xae287e85, 0x3f49af56, 0x77bf1d77, 0x2bee58ad, 
	0x1203f204, 0x24f7f037, 0x24d71903, 0xf5cbb06e, 0x0ffbeb37, 0x1ec6d981, 
	0x8b03b38c, 0x3718ddcc, 0xf529985f, 0x2eff9aa3, 0x3c056045, 0xdab5bb47, 
	0x229b63c4, 0x41ec6750, 0xa0040a79, 0xfb9fd41d, 0x80fdc8d1, 0x15fba254, 
	0xac725eeb, 0x9bb1af3f, 0x57f4d1a9, 0x7f68fd43, 0xf5c6e38e, 0xf11fb9c9, 
	0x924bff79, 0x7c2bc09e, 0x7ee478af, 0x1d1be36e, 0x5c6f41c7, 0x3b9de5fa, 
	0xee2f1531, 0x66f9ceb4, 0xda7e3f01, 0xb96f3317, 0xcfdf633d, 0xb0be1ebd, 
	0x3f723df8, 0x6357a7f7, 0x7573ddf9, 0x5f81bf34, 0x21be04bf, 0x13978fce, 
	0x3f16cf8b, 0x577a3b2d, 0x03bb8c89, 0xee5ee69c, 0x1187b98b, 0xdd8de7e9, 
	0xe4e34b84, 0x6427ae6d, 0xf92167dd, 0x59d5ab9a, 0xe62a6af1, 0x0c46edab, 
	0x197badbf, 0x628b8075, 0x49554de4, 0xaaf92cde, 0xaf84f681, 0xb98d5f2e, 
	0x9c963197, 0x8e797cd1, 0xb9633949, 0x293dab9a, 0xb730f7f1, 0xef0e3b7b, 
	0x3df63abd, 0x7bc54fd6, 0xbde1c76f, 0xb1ef6357, 0xb54668d6, 0xd7a217bc, 
	0x7212f7e2, 0x798bee5f, 0xcdfd28cf, 0xfcd1a908, 0x0c50880b, 0xad9702ff, 
	0xdc729efb, 0xbc86ec73, 0x69fac2f7, 0x7af48ff1, 0xd2bfc230, 0x2c54c1cb, 
	0xa60a3e27, 0xf2f7df03, 0xe6f198d5, 0xa3531c66, 0x33f166f9, 0xf0c58e20, 
	0xef99702f, 0x47745a7b, 0x98ea52ec, 0xf6257272, 0x57dceb1e, 0xceb1ef63, 
	0x12725b75, 0xc6e29767, 0x460ef44d, 0xa389e7dd, 0x470de89b, 0xbe6b23d9, 
	0x63dec4af, 0x5793911d, 0xceb1ef63, 0xd89cb375, 0x9adbefad, 0x443ee36f, 
	0xfe48f510, 0xa7a588fd, 0x639e7113, 0xbd1477f5, 0x907e11de, 0xa99b9ddd, 
	0x5085eac6, 0xc7e689df, 0xabe63cc8, 0x58f4d169, 0xddd9617a, 0x3e20bd78, 
	0xc6afbd20, 0x97ae7fea, 0x3b3b67e9, 0xab103337, 0x4ef0220f, 0xe5e23f34, 
	0xfbfe66f4, 0x66191520, 0xec3fdd0a, 0xfef31b4d, 0xee75c561, 0x44b37e1f, 
	0xaffdb79e, 0x78ac3fde, 0xe89edcf7, 0x7f7387fb, 0x95cfdd6e, 0x4b1c0dfc, 
	0x67bfc56b, 0x7de5d220, 0x8a67078d, 0xe187fbb8, 0x3fde783d, 0xa5b8e0b7, 
	0xf531eee7, 0x46a4332d, 0xb3405dcb, 0x57ea45e6, 0xefd8d5e0, 0x745f903a, 
	0xa387f68f, 0xf67aedf4, 0x949ae0a2, 0xdc979e43, 0xb46a63cc, 0x9e3405bc, 
	0xc0abd617, 0x81dfb1ab, 0x0b279f88, 0x1ff45677, 0xac7f0936, 0x7c739a0d, 
	0xf7d27f12, 0x77f77efd, 0xc97ef07b, 0x3710f1ac, 0x4adc49b6, 0xabb1edb8, 
	0xd2c0f0e3, 0xfa54e1dc, 0x0f254a7b, 0x7cbbb3be, 0x991fef10, 0x0895fbbb, 
	0x62bf09df, 0xe9daf0bc, 0xc4860ddd, 0x35de78b7, 0xe130ec70, 0xa44bf7e0, 
	0xacf0b19f, 0x8fcf7385, 0x11bbb3c6, 0xc5697ecf, 0xe163ddd9, 0xd2c7b9d9, 
	0x37738bf6, 0xbfa1678e, 0xe8fe787d, 0x5e962517, 0x93fede0e, 0xddf731c4, 
	0xe39cf1da, 0xb7dfe1e4, 0x6b3239e3, 0xdf00addf, 0xdc7c479b, 0xb70ceb8d, 
	0x41bbedc4, 0xe29278bc, 0xd357de45, 0x6e85eff1, 0x4dabec8f, 0x4e71caf1, 
	0x7be8501c, 0xf3d9434b, 0xf33bc662, 0x6e85c6d0, 0xcedff795, 0xc61e3ef1, 
	0x6efa858d, 0x78a0a75c, 0xe24621d3, 0x4ebbeb5b, 0x1507d733, 0x471bcb8a, 
	0x51d2d7f6, 0x95072b2e, 0x6c5b8c74, 0x2eabdb8c, 0x39e3a6d6, 0x5a9f0b7c, 
	0xa112ec71, 0x1f9abed0, 0x23bab1f7, 0x319a6bdf, 0x97b9f100, 0xfb467fbe, 
	0x86f59167, 0x735b5c58, 0xffbe8d2d, 0x97ddf653, 0x1bfee0f6, 0xe70abbc4, 
	0x715a9709, 0x5acf15b0, 0x063360fb, 0x264fda14, 0xf913dbbc, 0x9385961e, 
	0x97bfdc15, 0xe262cef7, 0x2f7e2b5c, 0x7dd1f179, 0xc6893bf2, 0xc0bfc85b, 
	0xf403ce99, 0x2692b3fd, 0x19fc178a, 0x29653ef2, 0xf5ea15c6, 0x67cac7f7, 
	0x73b2dc49, 0x1ecb8c96, 0xddc7f59a, 0x9cfa1b1f, 0xd3735394, 0xf1816880, 
	0x14fae0d4, 0xfde761d0, 0xc71c11af, 0x26735ceb, 0xaaddf499, 0xfee4b3cb, 
	0xab9f0d59, 0xaffdb4fe, 0xdec567f7, 0xb8debb5b, 0xdac173ad, 0xcd7fee0d, 
	0x9ebf1599, 0xabdd06fa, 0xac5e33f3, 0x77d26d99, 0xc9166a71, 0xb3d5acfd, 
	0x67eb3c64, 0x02b3591c, 0x35bd039e, 0x885df5ab, 0x4cea6bcb, 0x13598fba, 
	0x39bbe930, 0x9d6b4afe, 0x5355d252, 0x796ebb1c, 0xafe0f3a3, 0xa646f5e4, 
	0x7638a6a3, 0x1e7e31fd, 0x23ebdf88, 0x70e3f874, 0x3f30dfef, 0xf5e9cbbf, 
	0x3f2465f7, 0x66a7e5e2, 0x7eb311b5, 0x6464b35f, 0xb28fff7d, 0xbab354df, 
	0xbedd6637, 0xebaf0966, 0xe3f363eb, 0xd6b7d333, 0xeb966f5a, 0x5a7735d3, 
	0xbd13a6f3, 0x71caeb23, 0x9c964efb, 0x69df775f, 0xefbb1185, 0xc0eaf2c4, 
	0x4f8a8cef, 0xea397ba7, 0x1f1c15f7, 0x7af347af, 0x2c9dcd75, 0xd21dfc0f, 
	0x775ff451, 0xdbd78a1f, 0x5fb23f3f, 0xeb0ff723, 0xf4f9988d, 0xf7b1f407, 
	0x63f6e213, 0x6b04fdac, 0x1f786f3e, 0xdebcf3ea, 0xd61bed6e, 0xa7ccc6f7, 
	0xb31cd03f, 0xbe8a309f, 0xf147eeeb, 0x47edc6fc, 0xec8c94d5, 0x5ef9ca8f, 
	0x9fecc7a9, 0x47ef4ffe, 0xbef094d5, 0x2bcf2593, 0x4df6639b, 0x47f7d147, 
	0x6bb297da, 0x8e384fc6, 0x60e3b8df, 0x94fe7d94, 0xe977297d, 0xe6b476d8, 
	0x4a1f6b6e, 0xb94d4dea, 0xccfdc4f8, 0x201507ff, 0x00000295, 0x0002d9c1, 
	0x7cd59c78, 0xd51c740b, 0x56abe095, 0xd5a97775, 0x6d4b552d, 0xa6cb65b9, 
	0x5b4ecb24, 0x90b6ec76, 0xb887d6ad, 0x12b04c6c, 0x1c9c6b6c, 0xebb277b0, 
	0x20831136, 0x0618a2ec, 0xab8d9b04, 0x096e5925, 0xc0602d03, 0x1823604a, 
	0x9c327196, 0x12630eb3, 0x94dd9c93, 0x8122218c, 0xa24849c4, 0x3b4990cc, 
	0x8ecc6716, 0x99843196, 0xf6425988, 0x4ff55e7e, 0x990cd92d, 0x893abb39, 
	0x3ef5d78b, 0xbdffddf7, 0x8552beef, 0x10850650, 0xf572cd3e, 0x132885a7, 
	0xd1db0bb6, 0xc5715b36, 0x26152885, 0x52c23db5, 0xd4425306, 0xa9759bae, 
	0x1183f05d, 0x1b57f813, 0xdc3ded97, 0xec6d7cde, 0xf819ea17, 0xb6d0ed8f, 
	0x36831da0, 0x5b728fbe, 0xee57ad53, 0xe69ec3e9, 0xc08f235d, 0xe5db6ef8, 
	0xb6db177a, 0xcf7f854b, 0x6b5889fd, 0x3c710b55, 0x02fdc2f9, 0x92d6bbd7, 
	0x8a974def, 0x5f8875f3, 0xa852db70, 0x729ecebd, 0x2b4b45dd, 0x89afde38, 
	0x961d7e92, 0xe2e30ddb, 0x3578fdd9, 0x39fdc15b, 0x9a3689fb, 0x17da3fb4, 
	0x03c455b4, 0xfb0dd7ae, 0x4fdd9339, 0x5d27b5ed, 0x90e9fb79, 0xd9fb93fb, 
	0x2a766ebc, 0xfb851f17, 0x62847b13, 0x01df87ed, 0xd613ab0e, 0x115ab639, 
	0x3d77e167, 0xd8c358a9, 0xf01254cd, 0xfd60d55e, 0xc2efe2ef, 0xc2cbfd85, 
	0xdd3c1b00, 0x0509e30d, 0x72dd2e9e, 0x0784f001, 0xc14ffb01, 0xd5b416da, 
	0xbe3f7486, 0xd0c618f7, 0xea9fd861, 0xb012a717, 0x274d998f, 0x8c15f885, 
	0xee05d2eb, 0x0e18c44f, 0x368ad3cf, 0xa356fb08, 0xed8e12e3, 0x27c0070c, 
	0xadba8f00, 0x08f76a08, 0x3def0125, 0x2e14559a, 0x20be39b5, 0x86669e5c, 
	0xb8051dcb, 0x1708cf10, 0x5d6665d0, 0x72c25c01, 0x3f5a2da5, 0xe684a171, 
	0xa7a598a9, 0x0753615d, 0xa9549f53, 0x40635bad, 0x03c747bf, 0x19f12bc9, 
	0x5c614717, 0x3f598769, 0xa806f802, 0x216d4115, 0xfcff09c6, 0x5cc47a57, 
	0xbf2cc4fa, 0xe93e89d7, 0x3c34ea60, 0xa375f1dd, 0x350be07e, 0x0d5d4ded, 
	0xea584efd, 0x84fe38fd, 0x06dd1c08, 0xe9e327cf, 0x7f58bfa4, 0xf34238d1, 
	0x1e0eef5b, 0x01a77e85, 0xbf48a3af, 0x6df1c0f1, 0x7cbe3fd8, 0xb7f608f4, 
	0x6157a3dc, 0x6464bb7f, 0xd2a68840, 0x6027fef1, 0xfe1448d4, 0xd1e01b79, 
	0x118fc4ec, 0x96c42bbe, 0xca214a81, 0x412a88ef, 0x6fa6d7c0, 0x914a506c, 
	0x52723e4f, 0x347d2209, 0xc4ee1ae1, 0xc30cada7, 0x3e37b5fb, 0x84be94a7, 
	0x93fab0f4, 0xb5550f80, 0xccbe082a, 0x2925e3ba, 0x3fdd375a, 0x75708fd2, 
	0xe00d562a, 0x5877175d, 0x2c4e32d7, 0x7073e90b, 0x91ede902, 0xec4899ed, 
	0x6833f10e, 0x2db97acc, 0xb2cfffa0, 0x07862ffd, 0x8c495380, 0x9eb85c31, 
	0xc2feb17a, 0x97547e24, 0x49f90d08, 0xe0730b73, 0x0317e075, 0x9e0ea2f8, 
	0xf87aba5d, 0x36eb8226, 0x63c70391, 0x02ed3f80, 0x2e2b26b6, 0xfa675e00, 
	0x075d6134, 0x2f7e3ecd, 0xe702b334, 0xc2ab3455, 0x3ef93c02, 0x3143f535, 
	0x818beb46, 0x831c4245, 0x901765f1, 0x9c1884ab, 0xb00b6216, 0x214dfaa2, 
	0x0d7c94ae, 0x86695b6d, 0xf7982d79, 0x175f30e7, 0xae7c0bcf, 0x3f40bca3, 
	0x492693db, 0x84fb833f, 0xe7c7bfee, 0xe86fe1ef, 0x58f38c20, 0xc315fac2, 
	0xc237f0eb, 0x62188813, 0xc272cd28, 0x10ff48ed, 0x5561a1ca, 0xd5876a0a, 
	0xa07f30c3, 0x38112ac7, 0x104cd4ef, 0xcefae3e9, 0xf2a79222, 0xc852b35e, 
	0xeb8b7e75, 0xacfddb74, 0x7a6f40f7, 0x80bff7f8, 0x9071fddf, 0xb657e863, 
	0x79c12cc7, 0x86210ccb, 0x4579c75e, 0x165fc225, 0x8f28a889, 0xa2a765d1, 
	0x0db14fe2, 0xfd83d9f2, 0x738e20ad, 0x965ec67f, 0x2c9f1e7c, 0x935aee5f, 
	0x86d0b5db, 0xdb7edcd5, 0x73c24d4c, 0x91cd799b, 0xddbcf043, 0xe8f28e5c, 
	0xeff65dbe, 0xb6a54fb6, 0xe60bf3c3, 0x5c008fa7, 0x1de310ee, 0x30eb62f8, 
	0x804fffcc, 0x9fa252ff, 0x617d4128, 0x7d40bea2, 0xd215f5d3, 0x257f373f, 
	0xa915fb40, 0x3ff6a67f, 0xde9ab6ff, 0x5f489e03, 0x905f9269, 0x87ca164c, 
	0x014a7a27, 0xfdadef3a, 0x088fda27, 0x901bfac5, 0x0062220f, 0xd3fb85f5, 
	0x419ffeb0, 0x8feb0e3b, 0x21ffd765, 0xdd3c21ca, 0x7af848b7, 0xbccbe1f2, 
	0xadef941f, 0x2db1efe2, 0x583b200e, 0x3963135b, 0x6bb430ed, 0x0bdbda72, 
	0xed055dda, 0x7be3053d, 0xdc7dda0b, 0x161234bf, 0x5f7fb043, 0x8e862224, 
	0x23561e13, 0x28cd4a1e, 0x56fe15d1, 0x7c423abf, 0x72b5fab7, 0x9eb78c7c, 
	0x14b9fd65, 0x2baff9f5, 0x0237fe7f, 0x8ad375f0, 0x3bea0d92, 0xc5cb6f60, 
	0xce3012a7, 0xe3b565d7, 0xcddba5ef, 0x39979476, 0x84547c7c, 0x07601e90, 
	0x7e4b3e88, 0xdd54ab15, 0x3fd74c42, 0xd1be4092, 0xd41b7ceb, 0xa876215e, 
	0x0df2ef8c, 0x73bd53c0, 0xa2a8f1e7, 0xa7d004f5, 0x7abbf6f3, 0xceb7b063, 
	0x3ee27821, 0x8fd910cc, 0xf345c511, 0x85dc44fb, 0x86d80afb, 0x8e59c4f0, 
	0x9be62c66, 0x25da7a59, 0x49e48276, 0xada8549d, 0xbd75ff62, 0x94e8b709, 
	0xb7f602fa, 0x6ebbf0fe, 0x486dfa1d, 0x470b716e, 0xe8df515e, 0x46e92cc2, 
	0xc380813a, 0xf3365dba, 0x30976961, 0xd6bbf03c, 0x09ef6c25, 0x26181ba4, 
	0x585247c2, 0x574fa0fb, 0x3e320c4a, 0xd00fcfcb, 0x2b69ae32, 0x66eadf0b, 
	0x1dd597e6, 0x6bd5878c, 0xe03d7db9, 0x7c7c0343, 0xafeb0369, 0xbf53c26f, 
	0x48db7880, 0x7b111074, 0xb1a7d227, 0x3a44a94b, 0x08454788, 0x67b35ce1, 
	0xb3f7084b, 0xe8df6fc3, 0x834639d8, 0x7d869dee, 0x5ef11a75, 0x67dc87f2, 
	0x45fec906, 0x3da7f032, 0x07a3a827, 0x44d529e7, 0xf9dbf71c, 0xadf08c64, 
	0xe8978aaa, 0xf5c309ae, 0xd5d3ce24, 0xa2ba0fdb, 0xd31899f3, 0xebd10ee5, 
	0x3479871a, 0x31e953c6, 0xf3403e31, 0x8d5f34d9, 0x48bcfe91, 0xd7b338e3, 
	0x6a2f71c2, 0xe1e81fd4, 0x787a659d, 0x5b611341, 0x3f46fee3, 0x26f78ff7, 
	0xf697c20c, 0x57c13f72, 0xad3d2afa, 0x99fad7d2, 0x67fe72ae, 0xdcef802c, 
	0xe4139b65, 0xa8c800a7, 0xe255d5cf, 0xdd306582, 0xc8fbbd1d, 0x4b8fdc41, 
	0xc6007819, 0x5527a669, 0x35c7d595, 0x77bf417e, 0xa6f58aae, 0x9fcebe00, 
	0xf0937ac5, 0xaff0097c, 0xa7ed9edc, 0x7527965a, 0xe371e914, 0x177e1506, 
	0x7c7a02d1, 0x7671e819, 0x93047a7e, 0x60a7e926, 0x0134fc1f, 0x7ac5b4eb, 
	0x5beb8185, 0x85afc0ca, 0x9603e8a8, 0xe5a7c52e, 0x659fb0d3, 0xabf0292a, 
	0x97cb2c2a, 0xc9f60c5a, 0xdf5c15b2, 0x630bc781, 0xc277a85d, 0x7efaf942, 
	0x4ed1e3a6, 0x5de89fa4, 0x1bb0fec2, 0xf6147de9, 0xea3e0511, 0x018d026c, 
	0xc98b72fb, 0xf44fe300, 0x9dfbd00a, 0xbbf422a7, 0xd0796637, 0xa71d101e, 
	0x051cf073, 0x7ea34a29, 0x1f845535, 0x98574cda, 0x5a64e88f, 0xfb7b9401, 
	0xd1f241a0, 0xf12b54f9, 0xd42a6e8f, 0x197a115f, 0xb31aebe9, 0x40f1a2cc, 
	0xb3d134b7, 0xaba63dec, 0x939065ff, 0xbf31f5c6, 0xab9d7e0a, 0x4115ea6a, 
	0x189988fe, 0xd0b919fc, 0xfd8cfff4, 0xed9473dc, 0x8ee7b4ae, 0xd0119b5d, 
	0x6417fc1f, 0xab0d8b29, 0xe910fa82, 0xda94fe88, 0x329f7e30, 0x8c7bf486, 
	0xafb8d7e8, 0xe813f495, 0xc9f210b2, 0xe1cb3f0e, 0x02aff438, 0x00df2d7c, 
	0x2cf9f5ff, 0x8fcfe0be, 0xfd9cf9fe, 0xf24ad13e, 0x2b3cfb40, 0xee52f9f7, 
	0x24ff4cfe, 0x9c7eabfb, 0xf307f687, 0x7c3f7cd4, 0xcfb10fe4, 0xd03fb8d3, 
	0xb93fabff, 0x1fa445f7, 0xd5dc63c8, 0xdbe6f04d, 0x936fc9cf, 0x67627cfe, 
	0x5991db8c, 0x45f5af6a, 0xcc469f48, 0x5cfd9e44, 0x479535ed, 0x584dda05, 
	0xdba6ed01, 0x0047afe8, 0x459e6ed1, 0x79fc077f, 0x7e8167dc, 0x36935f74, 
	0xeae6b79f, 0xabedf6c3, 0xc369bfc9, 0x04f58cc0, 0xedb6a5d9, 0xe5886235, 
	0xd2ed12f7, 0x639fa269, 0x12a7da97, 0xceda9764, 0x44bb216c, 0xdcbb40f8, 
	0x9bd04f04, 0xb8a2d31e, 0xe7feba6e, 0x8a2f9409, 0xb95c60e3, 0xc3ac7a65, 
	0x9b4fdfb0, 0xebe204ee, 0xea3bf028, 0x90be968f, 0x9d169d01, 0x61f33886, 
	0x479f338a, 0x9dd7a69b, 0x201ea0db, 0x3ae10d39, 0x3f282fc4, 0x243ca89f, 
	0x25e7df60, 0xeff5ccdf, 0x61f2176c, 0x5586d3d9, 0x07d59b3f, 0x8dcb7e65, 
	0x155da072, 0xfc0294f9, 0x72c27650, 0x8bb2388b, 0x70013fb8, 0x1d499e86, 
	0x09733942, 0xa9f4883b, 0xedef5bbe, 0xdead3907, 0xf195eae6, 0x5bfe156e, 
	0x9bd1bd7d, 0x6ab7dfc0, 0xbfab9fa4, 0x97f2cfc8, 0xd8268ab5, 0xde2bcdc7, 
	0x98a1fb23, 0xb0fbd0c6, 0xd635c570, 0xe27f2cf3, 0x575809e3, 0x88ad880b, 
	0xc03f32c7, 0x9d3d7089, 0x4731bbbe, 0x70f1656f, 0x76f18dc8, 0xb8a2d475, 
	0x70da7b58, 0x5c6c8929, 0xd9ff49ac, 0xa73fa6db, 0x035e7e01, 0x642f047c, 
	0x06ff19f9, 0x831dd17a, 0x94bf7200, 0x36638c3b, 0xdf10549f, 0x1731cdd3, 
	0x075ea3ca, 0xe566f760, 0x0a4cf511, 0x2f59d3f6, 0xac8d477a, 0x5ba8f73e, 
	0xcba05194, 0x0eb3a052, 0x1869e0fc, 0xfe3a8257, 0x0bdfa09e, 0x62b630e9, 
	0x0b789349, 0xa78853fd, 0xdcb85953, 0x012886cd, 0x656dac3b, 0x8a9a6bb8, 
	0xd612bdc3, 0x80cc38c3, 0x718924b8, 0x7ee85449, 0x989a93d4, 0x737f6618, 
	0x59fb0922, 0xff40f08b, 0xd2484063, 0xd5d09a1b, 0xc8da7a6e, 0x149e3307, 
	0x0dc605c9, 0x40221fcc, 0xcb1b59fe, 0xf012e95d, 0xdf44e3ff, 0xd4a7e200, 
	0x45cfc930, 0x00f488dd, 0x3f25523f, 0x0b3f64cb, 0x06bc0dfe, 0x3cb433fa, 
	0x067484d6, 0x597ee0bd, 0x454d3f21, 0x351f153e, 0x843e71fb, 0xdd28e117, 
	0x5c7b231a, 0x3cca24da, 0xcd7c2567, 0x29cae7a4, 0x496d822e, 0xeb4e573d, 
	0x1d718ec0, 0x82576b6d, 0xd26356e8, 0x387899fb, 0x7a393f4f, 0xadaded7c, 
	0xefac0de5, 0x845f7026, 0xf8afe807, 0x0bd4098d, 0x0ff6f5a5, 0x47f71e10, 
	0xcbf40123, 0xcfd89f11, 0x81d8d6bd, 0x3f045072, 0xe9ade7e4, 0x8c5ccab6, 
	0x2979d717, 0xafbfe857, 0x3e4fed51, 0xcd757100, 0x61ec78ca, 0x87fd6f88, 
	0x27247115, 0x2b7b07be, 0xc06db27c, 0x37ef4bfa, 0xaec0aa4b, 0xee346ffa, 
	0x79021e1d, 0xfb022c38, 0x45dfc05f, 0xe2fe4fc0, 0x101b8e49, 0x53c7802e, 
	0x5fe8022b, 0xafc127ba, 0xadeb3afe, 0xbf7a3e33, 0x769e8a7a, 0x407dd4eb, 
	0x7eec5573, 0xe9fa83df, 0xe903a266, 0x4f52b3ab, 0xd2d3bc61, 0x272b1ed7, 
	0x4d70d2bf, 0x19b23f4b, 0x5971efd1, 0x76cd08e7, 0xd4b2f502, 0x0e53a9a7, 
	0xd73b6d7d, 0xabd5cd1f, 0xdade01a7, 0x1cf919b5, 0xd8d53d41, 0xb8e71ca4, 
	0x86452ccf, 0xb97702a9, 0x4fa275ff, 0x4d7de935, 0xae01248c, 0x23e92faa, 
	0xb1bfe03a, 0x7e73fa01, 0xaeff8c2d, 0x807b0af2, 0xb8d5dbfa, 0xe772e37e, 
	0xf0bc043d, 0x653118d7, 0xa53e505b, 0xae45b7d1, 0xfb433307, 0x0d7fe03e, 
	0x3bfab1e4, 0x9006eab1, 0xb4e9dae7, 0xffbe014f, 0x229d576c, 0xab1dac8c, 
	0x13ea3ddb, 0x282f9c41, 0xdf7f205c, 0xa078e26f, 0xc2746ca1, 0xe7567205, 
	0x4c5246b3, 0x186a50ef, 0x453266db, 0xf6a2cb7a, 0x4fd89b8f, 0xf410795e, 
	0x08beff14, 0x5312e7f7, 0xee5f108b, 0x76825888, 0x179f8b36, 0x797f5046, 
	0xbc1c4e20, 0xa36b8851, 0x8c1d78b0, 0xbe79c75f, 0x041ba2eb, 0x12d68dfb, 
	0xdf63bfc4, 0x4b7be2dd, 0xffc01f90, 0xc6768259, 0x1f5a1fb1, 0xd80dcff8, 
	0xa7b8a75f, 0x37fb62da, 0x6172ce33, 0xd84a717d, 0xa69adbf0, 0xcbc8e3d6, 
	0x484ad222, 0x6d00d35a, 0xdb860fcc, 0x2cd7a049, 0x95bd6d97, 0xb8bbbedb, 
	0x23fd90bf, 0xe65efc7d, 0xf232010f, 0xeb33affb, 0x847143d4, 0xa2aff3ff, 
	0x6d31aa5c, 0x30adc911, 0xa4c1ff69, 0x6b7841ed, 0x5117ccca, 0x66b53cde, 
	0x71bbd908, 0x914fe8f7, 0xfbae572f, 0x3f1097fa, 0x35fc8fe0, 0xe0313dc5, 
	0xfe59fdbf, 0x6187c39c, 0x029ac3e0, 0x6ff03ebb, 0x7a76ae3f, 0x5af5047c, 
	0x7698a363, 0x3788baf2, 0x11dcaf87, 0x3b93f12f, 0x59fa2b62, 0x84e80bce, 
	0x3a93db17, 0x7db1e3cb, 0x3fcce5c5, 0xa79b8d8d, 0x0ac063ad, 0xe224e665, 
	0x1accaea9, 0xf54f10b1, 0x079c2dab, 0x798939f0, 0xb7fe35b4, 0x8b7ca45f, 
	0xb75c3d60, 0x48162854, 0xa2de1a8c, 0xd4ff80b8, 0xe837cb59, 0xf04d7805, 
	0xb33fc1b3, 0x8e2862a7, 0x78ce23c2, 0x751a7f90, 0xca4d5145, 0xbe52f557, 
	0xa973d24a, 0x963ce61e, 0x3157ee33, 0xd7c0a954, 0x2e7c7f30, 0xc5637b5f, 
	0x44355af9, 0xcc7f5f3e, 0x51af905e, 0xcc6e58be, 0xe1dbe210, 0xf9944f73, 
	0xf88de51c, 0x2fbfe646, 0x3f0ee7c6, 0xf89c5c92, 0xac7df003, 0x8f32db8f, 
	0xf2ff728e, 0xfbe7c921, 0x4a779f25, 0xf92b3f3e, 0xbd7c96dc, 0xec39f25f, 
	0x3f487fe3, 0x28272330, 0xef966607, 0x0c4c5ec1, 0x59708f5c, 0xb6bfd63e, 
	0x0ccdfd0f, 0x37cb0a5f, 0xfb016d8c, 0x21bb469a, 0xefe93fa8, 0x7caf8927, 
	0xaeb5ff68, 0x5e24b53a, 0x3e1d8f84, 0x39f8f3df, 0xf8f993e4, 0x070a5ffa, 
	0x097c3fcd, 0x1da58470, 0x91cc7091, 0xf56f9947, 0x33ca4168, 0x942dc27a, 
	0xe06b747f, 0x92206f9f, 0x2dfd2234, 0x9a4f7f49, 0xc35f95f3, 0x62ed0178, 
	0xf835c6ef, 0xd64b7bfe, 0xbd917af0, 0xbefd706b, 0x1da59b17, 0x6e891b33, 
	0x0bffe39e, 0x9d08bced, 0xf05adafc, 0x776a87f7, 0x85f18e5d, 0xe6bdb0fb, 
	0x3fe411f1, 0x45c50d6b, 0x75a6f12e, 0xae1e3586, 0xf246f249, 0xbe385290, 
	0xe3123f02, 0x1f92cdb0, 0x1efefcd5, 0xf8714efd, 0xb9d73c75, 0x9b3d0c53, 
	0xf034af95, 0x67ef0e93, 0x39872062, 0xdf926ef9, 0x61df911b, 0x5cacd2fe, 
	0x413e507b, 0x1e34669e, 0x7927f4ef, 0x73cae7d6, 0x585b8e46, 0xc51a678e, 
	0x14f5459b, 0xfa0fd0fc, 0x65cbb6e5, 0x1fa450dc, 0xbf8e9ffa, 0xdfe616eb, 
	0x1c13e6e4, 0x36b3383d, 0xe925dc7f, 0x5117a933, 0x224f503e, 0x6cfab3be, 
	0x9f5734a2, 0x1e13ea35, 0x23f3ce35, 0x9bf8d65e, 0x8eae9026, 0xd7eccc1e, 
	0x847abc60, 0xb109e7ce, 0x14cbc656, 0xa03fefcb, 0xa05f821c, 0xc8df3e22, 
	0xc011f719, 0x4d744e13, 0x87fa20fa, 0x82727899, 0x704676f9, 0xd4f91efe, 
	0x2232bf42, 0x7cdae7e5, 0xa566b13f, 0x80f242d8, 0x6f3ca2fe, 0xfc113f42, 
	0xfec690bf, 0xb7fefd39, 0xeb579ccd, 0x7c415e02, 0x17b7af84, 0x5be55e63, 
	0x75b79ccd, 0x0bc141f2, 0xebc93525, 0x2e962f29, 0x6a0f3903, 0xbc049aa6, 
	0x28444774, 0x5db84209, 0x72cfb3ce, 0x5eff51f9, 0x583c72a3, 0x4976161a, 
	0xc5a5e903, 0x178c7efa, 0xf01ac5ed, 0xe714c57b, 0xbacd