#ifndef __HW_DUMP_H
#define __HW_DUMP_H


/* e_dump.h: Everest network driver.
 *
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2014 QLogic Corporation
 * The contents of this file are subject to the terms of the
 * QLogic End User License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the License at
 * http://www.qlogic.com/Resources/Documents/DriverDownloadHelp/
 * QLogic_End_User_Software_License.txt
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 */



#ifndef ARRSIZE /* ! ECORE_UPSTREAM */
/*
 * ARRSIZE:
 * used to calcualte item count of an array
 * this macro is used to prevent compile warning for unreferenced parametes
*/
#define ARRSIZE(a)				(sizeof(a)/sizeof((a)[0]))
#endif /* ARRSIZE  */



/*definitions */
#define DRV_DUMP_XSTORM_WAITP_ADDRESS    0x2b8a80
#define DRV_DUMP_TSTORM_WAITP_ADDRESS    0x1b8a80
#define DRV_DUMP_USTORM_WAITP_ADDRESS    0x338a80
#define DRV_DUMP_CSTORM_WAITP_ADDRESS    0x238a80
#define DRV_DUMP_TSTORM_CAM_MODE         0x1B1440

#define DRV_DUMP_MAX_TIMER_PENDING      200
#define DRV_DUMP_MAX_HEADER             1000
#define DRV_DUMP_TIMER_SCAN_DONT_CARE   0xFF
#define RI_E1			0x1
#define RI_E1H			0x2
#define RI_E2			0x4
#define RI_E3			0x8
#define RI_E3B0			0x10
#define RI_ONLINE 		0x100
#define RI_OFFLINE			0x0
#define RI_PATH0_DUMP 		0x200
#define RI_PATH1_DUMP 		0x400

#define MAX_VFC_WRITE_SIZE 2


/* Data Source - For Extension Headers */
#define RI_SRC_XSTORM 0
#define RI_SRC_TSTORM 1
#define RI_SRC_USTORM 2
#define RI_SRC_CSTORM 3
#define RI_OTHER_BLOCK 4


/* Data Types */
#define RI_TYPE_IGU 0
#define RI_TYPE_VFC 1
#define RI_TYPE_SPLIT 2


/* VFC Status flag */
#define RI_VFC_IS_READY 1
#define RI_VFC_IS_BUSY 2
#define RI_VFC_IS_ONGOING_SEND 4
#define RI_E1_ONLINE			(RI_E1 | RI_ONLINE)
#define RI_E1H_ONLINE			(RI_E1H | RI_ONLINE)
#define RI_E1E1H_ONLINE			(RI_E1 | RI_E1H | RI_ONLINE)
#define RI_E2_ONLINE			(RI_E2 | RI_ONLINE)
#define RI_E1E2_ONLINE			(RI_E1 | RI_E2 | RI_ONLINE)
#define RI_E1HE2_ONLINE			(RI_E1H | RI_E2 | RI_ONLINE)
#define RI_E1E1HE2_ONLINE		(RI_E1 | RI_E1H | RI_E2 | RI_ONLINE)
#define RI_E3_ONLINE			(RI_E3 | RI_ONLINE)
#define RI_E1E3_ONLINE			(RI_E1 | RI_E3 | RI_ONLINE)
#define RI_E1HE3_ONLINE			(RI_E1H | RI_E3 | RI_ONLINE)
#define RI_E1E1HE3_ONLINE		(RI_E1 | RI_E1H | RI_E3 | RI_ONLINE)
#define RI_E2E3_ONLINE			(RI_E2 | RI_E3 | RI_ONLINE)
#define RI_E1E2E3_ONLINE			(RI_E1 | RI_E2 | RI_E3 | RI_ONLINE)
#define RI_E1HE2E3_ONLINE		(RI_E1H | RI_E2 | RI_E3 | RI_ONLINE)
#define RI_E1E1HE2E3_ONLINE		\
	(RI_E1 | RI_E1H | RI_E2 | RI_E3 | RI_ONLINE)
#define RI_E3B0_ONLINE			(RI_E3B0 | RI_ONLINE)
#define RI_E1E3B0_ONLINE			(RI_E1 | RI_E3B0 | RI_ONLINE)
#define RI_E1HE3B0_ONLINE		(RI_E1H | RI_E3B0 | RI_ONLINE)
#define RI_E1E1HE3B0_ONLINE		(RI_E1 | RI_E1H | RI_E3B0 | RI_ONLINE)
#define RI_E2E3B0_ONLINE			(RI_E2 | RI_E3B0 | RI_ONLINE)
#define RI_E1E2E3B0_ONLINE		(RI_E1 | RI_E2 | RI_E3B0 | RI_ONLINE)
#define RI_E1HE2E3B0_ONLINE		(RI_E1H | RI_E2 | RI_E3B0 | RI_ONLINE)
#define RI_E1E1HE2E3B0_ONLINE		\
	(RI_E1 | RI_E1H | RI_E2 | RI_E3B0 | RI_ONLINE)
#define RI_E3E3B0_ONLINE			(RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1E3E3B0_ONLINE		(RI_E1 | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1HE3E3B0_ONLINE		(RI_E1H | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1E1HE3E3B0_ONLINE		\
	(RI_E1 | RI_E1H | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E2E3E3B0_ONLINE		(RI_E2 | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1E2E3E3B0_ONLINE		\
	(RI_E1 | RI_E2 | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1HE2E3E3B0_ONLINE		\
	(RI_E1H | RI_E2 | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1E1HE2E3E3B0_ONLINE	\
	(RI_E1 | RI_E1H | RI_E2 | RI_E3 | RI_E3B0 | RI_ONLINE)
#define RI_E1_OFFLINE			(RI_E1 | RI_OFFLINE)
#define RI_E1H_OFFLINE			(RI_E1H | RI_OFFLINE)
#define RI_E1E1H_OFFLINE			(RI_E1 | RI_E1H | RI_OFFLINE)
#define RI_E2_OFFLINE			(RI_E2 | RI_OFFLINE)
#define RI_E1E2_OFFLINE			(RI_E1 | RI_E2 | RI_OFFLINE)
#define RI_E1HE2_OFFLINE			(RI_E1H | RI_E2 | RI_OFFLINE)
#define RI_E1E1HE2_OFFLINE		(RI_E1 | RI_E1H | RI_E2 | RI_OFFLINE)
#define RI_E3_OFFLINE			(RI_E3 | RI_OFFLINE)
#define RI_E1E3_OFFLINE			(RI_E1 | RI_E3 | RI_OFFLINE)
#define RI_E1HE3_OFFLINE			(RI_E1H | RI_E3 | RI_OFFLINE)
#define RI_E1E1HE3_OFFLINE		(RI_E1 | RI_E1H | RI_E3 | RI_OFFLINE)
#define RI_E2E3_OFFLINE			(RI_E2 | RI_E3 | RI_OFFLINE)
#define RI_E1E2E3_OFFLINE		(RI_E1 | RI_E2 | RI_E3 | RI_OFFLINE)
#define RI_E1HE2E3_OFFLINE		(RI_E1H | RI_E2 | RI_E3 | RI_OFFLINE)
#define RI_E1E1HE2E3_OFFLINE		\
	(RI_E1 | RI_E1H | RI_E2 | RI_E3 | RI_OFFLINE)
#define RI_E3B0_OFFLINE			(RI_E3B0 | RI_OFFLINE)
#define RI_E1E3B0_OFFLINE		(RI_E1 | RI_E3B0 | RI_OFFLINE)
#define RI_E1HE3B0_OFFLINE		(RI_E1H | RI_E3B0 | RI_OFFLINE)
#define RI_E1E1HE3B0_OFFLINE		(RI_E1 | RI_E1H | RI_E3B0 | RI_OFFLINE)
#define RI_E2E3B0_OFFLINE		(RI_E2 | RI_E3B0 | RI_OFFLINE)
#define RI_E1E2E3B0_OFFLINE		(RI_E1 | RI_E2 | RI_E3B0 | RI_OFFLINE)
#define RI_E1HE2E3B0_OFFLINE		(RI_E1H | RI_E2 | RI_E3B0 | RI_OFFLINE)
#define RI_E1E1HE2E3B0_OFFLINE		\
	(RI_E1 | RI_E1H | RI_E2 | RI_E3B0 | RI_OFFLINE)
#define RI_E3E3B0_OFFLINE		(RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E1E3E3B0_OFFLINE		(RI_E1 | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E1HE3E3B0_OFFLINE		(RI_E1H | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E1E1HE3E3B0_OFFLINE		\
	(RI_E1 | RI_E1H | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E2E3E3B0_OFFLINE		(RI_E2 | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E1E2E3E3B0_OFFLINE		\
	(RI_E1 | RI_E2 | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E1HE2E3E3B0_OFFLINE		\
	(RI_E1H | RI_E2 | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_E1E1HE2E3E3B0_OFFLINE	\
	(RI_E1 | RI_E1H | RI_E2 | RI_E3 | RI_E3B0 | RI_OFFLINE)
#define RI_ALL_ONLINE	RI_E1E1HE2E3E3B0_ONLINE
#define RI_ALL_OFFLINE	RI_E1E1HE2E3E3B0_OFFLINE

/* Macros for handling the MCP Tracebuffer */
#define DBG_DMP_TRACE_BUFFER_SIZE 0x800
#define DBG_DMP_TRACE_BUFFER_OFFSET(shmem0_offset) \
		((shmem0_offset) - DBG_DMP_TRACE_BUFFER_SIZE)


/* This struct holds a signature to ensure the dump returned from the driver
   match the meta data file inserted to grc_dump.tcl
   The signature is time stamp, diag version and grc_dump version */




struct hd_param {
	u32 time_stamp;
	u32 diag_ver;
	u32 grc_dump_ver;
};

struct dump_hdr {
	u32  hdr_size;	/* in dwords, excluding this field */
	struct hd_param	hd_param_all;
	u32  x_storm_wait_p_status;
	u32  t_storm_wait_p_status;
	u32  u_storm_wait_p_status;
	u32  c_storm_wait_p_status;
	u16  info;
	u8   idle_chk;
	u8   reserved;
};

#define HDR_SIGNATURE 0x11ff22ee

struct extension_hdr {
	u32  hdr_signature;
	u32  hdr_size;	/* in dwords, excluding this field */
	u32  data_size;	/* in dwords */
	u32  additional_data;
	u32  data_source; /* storm number or none if from a block. */
	u32  data_type;
	u32  reserved;
	u32  error;
};

struct igu_data {
	u32  valid;	/* is valid for the current chip */
	u32  max_size;	/* max read iterations */
	u32  is_last_commands;	/* put  value in the additional_data field */
	u32  is_data_valid;	/* non-zero for valid */
	u32  data[2];
};

struct vfc_general {
	u32  valid;	/* is valid for the current chip */
	u32  vfc_status;
	u32  vfc_address;
	u32  vfc_data_write;
	u32  vfc_data_read;
};

struct vfc_read_write_vector {
u32 read_size;
u32 address_value;
u32 write_value_num_valid;
u32 write_value[MAX_VFC_WRITE_SIZE];
};

struct vfc_read_task {
	const struct vfc_read_write_vector *read_write_vectors;
u32 array_size;
};

struct reg_addr {
	u32 addr;
	u32 size;
	u16 info;
};

struct wreg_addr {
	u32 addr;
	u32 size;
	u32 read_regs_count;
	const u32 *read_regs;
	u16 info;
};



/* generated file from GRC_dump.tcl
	The grcDump args were -withiornos -mcpfull -splitfull
	The chip was all*/



static const struct reg_addr reg_addrs[] = {
	{ 0x2000, 341, RI_ALL_ONLINE},
	{ 0x2800, 103, RI_ALL_ONLINE},
	{ 0x3000, 287, RI_ALL_ONLINE},
	{ 0x3800, 331, RI_ALL_ONLINE},
	{ 0x8800, 6, RI_ALL_ONLINE},
	{ 0x8818, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x9000, 147, RI_E2E3E3B0_ONLINE},
	{ 0x924c, 1, RI_E2_ONLINE},
	{ 0x9250, 16, RI_E2E3E3B0_ONLINE},
	{ 0x9400, 33, RI_E2E3E3B0_ONLINE},
	{ 0x9484, 5, RI_E3E3B0_ONLINE},
	{ 0xa000, 27, RI_ALL_ONLINE},
	{ 0xa06c, 1, RI_E1E1H_ONLINE},
	{ 0xa070, 71, RI_ALL_ONLINE},
	{ 0xa18c, 4, RI_E1E1H_ONLINE},
	{ 0xa19c, 62, RI_ALL_ONLINE},
	{ 0xa294, 2, RI_E1E1H_ONLINE},
	{ 0xa29c, 2, RI_ALL_ONLINE},
	{ 0xa2a4, 2, RI_E1E1HE2_ONLINE},
	{ 0xa2ac, 52, RI_ALL_ONLINE},
	{ 0xa39c, 7, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3b8, 2, RI_E3E3B0_ONLINE},
	{ 0xa3c0, 3, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3d0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3d8, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3e0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3e8, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3f0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa3f8, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa400, 40, RI_ALL_ONLINE},
	{ 0xa4a0, 1, RI_E1E1HE2_ONLINE},
	{ 0xa4a4, 2, RI_ALL_ONLINE},
	{ 0xa4ac, 2, RI_E1E1H_ONLINE},
	{ 0xa4b4, 1, RI_E1E1HE2_ONLINE},
	{ 0xa4b8, 2, RI_E1E1H_ONLINE},
	{ 0xa4c0, 3, RI_ALL_ONLINE},
	{ 0xa4cc, 5, RI_E1E1H_ONLINE},
	{ 0xa4e0, 3, RI_ALL_ONLINE},
	{ 0xa4fc, 2, RI_ALL_ONLINE},
	{ 0xa504, 1, RI_E1E1H_ONLINE},
	{ 0xa508, 3, RI_ALL_ONLINE},
	{ 0xa518, 1, RI_ALL_ONLINE},
	{ 0xa520, 1, RI_ALL_ONLINE},
	{ 0xa528, 1, RI_ALL_ONLINE},
	{ 0xa530, 1, RI_ALL_ONLINE},
	{ 0xa538, 1, RI_ALL_ONLINE},
	{ 0xa540, 1, RI_ALL_ONLINE},
	{ 0xa548, 1, RI_E1E1H_ONLINE},
	{ 0xa550, 1, RI_E1E1H_ONLINE},
	{ 0xa558, 1, RI_E1E1H_ONLINE},
	{ 0xa560, 1, RI_E1E1H_ONLINE},
	{ 0xa568, 1, RI_E1E1H_ONLINE},
	{ 0xa570, 1, RI_ALL_ONLINE},
	{ 0xa580, 1, RI_ALL_ONLINE},
	{ 0xa590, 1, RI_ALL_ONLINE},
	{ 0xa5a0, 1, RI_E1E1HE2_ONLINE},
	{ 0xa5c0, 1, RI_ALL_ONLINE},
	{ 0xa5e0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa5e8, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa5f0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa5f8, 1, RI_E1HE2_ONLINE},
	{ 0xa5fc, 9, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa620, 6, RI_E2E3E3B0_ONLINE},
	{ 0xa638, 20, RI_E2_ONLINE},
	{ 0xa688, 42, RI_E2E3E3B0_ONLINE},
	{ 0xa730, 1, RI_E2_ONLINE},
	{ 0xa734, 2, RI_E2E3E3B0_ONLINE},
	{ 0xa73c, 4, RI_E2_ONLINE},
	{ 0xa74c, 5, RI_E2E3E3B0_ONLINE},
	{ 0xa760, 5, RI_E2_ONLINE},
	{ 0xa774, 7, RI_E2E3E3B0_ONLINE},
	{ 0xa790, 15, RI_E2_ONLINE},
	{ 0xa7cc, 4, RI_E2E3E3B0_ONLINE},
	{ 0xa7e0, 6, RI_E3E3B0_ONLINE},
	{ 0xa800, 18, RI_E2_ONLINE},
	{ 0xa848, 33, RI_E2E3E3B0_ONLINE},
	{ 0xa8cc, 2, RI_E3E3B0_ONLINE},
	{ 0xa8d4, 4, RI_E2E3E3B0_ONLINE},
	{ 0xa8e4, 1, RI_E3E3B0_ONLINE},
	{ 0xa8e8, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa8f0, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa8f8, 30, RI_E3E3B0_ONLINE},
	{ 0xa974, 73, RI_E3E3B0_ONLINE},
	{ 0xac30, 1, RI_E3E3B0_ONLINE},
	{ 0xac40, 1, RI_E3E3B0_ONLINE},
	{ 0xac50, 1, RI_E3E3B0_ONLINE},
	{ 0xac60, 1, RI_E3B0_ONLINE},
	{ 0x10000, 9, RI_ALL_ONLINE},
	{ 0x10024, 1, RI_E1E1HE2_ONLINE},
	{ 0x10028, 5, RI_ALL_ONLINE},
	{ 0x1003c, 6, RI_E1E1HE2_ONLINE},
	{ 0x10054, 20, RI_ALL_ONLINE},
	{ 0x100a4, 4, RI_E1E1HE2_ONLINE},
	{ 0x100b4, 11, RI_ALL_ONLINE},
	{ 0x100e0, 4, RI_E1E1HE2_ONLINE},
	{ 0x100f0, 8, RI_ALL_ONLINE},
	{ 0x10110, 6, RI_E1E1HE2_ONLINE},
	{ 0x10128, 110, RI_ALL_ONLINE},
	{ 0x102e0, 4, RI_E1E1HE2_ONLINE},
	{ 0x102f0, 18, RI_ALL_ONLINE},
	{ 0x10338, 20, RI_E1E1HE2_ONLINE},
	{ 0x10388, 10, RI_ALL_ONLINE},
	{ 0x10400, 6, RI_E1E1HE2_ONLINE},
	{ 0x10418, 6, RI_ALL_ONLINE},
	{ 0x10430, 10, RI_E1E1HE2_ONLINE},
	{ 0x10458, 22, RI_ALL_ONLINE},
	{ 0x104b0, 12, RI_E1E1HE2_ONLINE},
	{ 0x104e0, 1, RI_ALL_ONLINE},
	{ 0x104e8, 2, RI_ALL_ONLINE},
	{ 0x104f4, 2, RI_ALL_ONLINE},
	{ 0x10500, 146, RI_ALL_ONLINE},
	{ 0x10750, 2, RI_E1E1HE2_ONLINE},
	{ 0x10760, 2, RI_E1E1HE2_ONLINE},
	{ 0x10770, 2, RI_E1E1HE2_ONLINE},
	{ 0x10780, 2, RI_E1E1HE2_ONLINE},
	{ 0x10790, 2, RI_ALL_ONLINE},
	{ 0x107a0, 2, RI_E1E1HE2_ONLINE},
	{ 0x107b0, 2, RI_E1E1HE2_ONLINE},
	{ 0x107c0, 2, RI_E1E1HE2_ONLINE},
	{ 0x107d0, 2, RI_E1E1HE2_ONLINE},
	{ 0x107e0, 2, RI_ALL_ONLINE},
	{ 0x10880, 2, RI_ALL_ONLINE},
	{ 0x10900, 2, RI_ALL_ONLINE},
	{ 0x16000, 1, RI_E1HE2_ONLINE},
	{ 0x16004, 25, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16070, 8, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16090, 4, RI_E1HE2E3_ONLINE},
	{ 0x160a0, 6, RI_E1HE2E3E3B0_ONLINE},
	{ 0x160c0, 7, RI_E1HE2E3E3B0_ONLINE},
	{ 0x160dc, 2, RI_E1HE2_ONLINE},
	{ 0x160e4, 10, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1610c, 2, RI_E1HE2_ONLINE},
	{ 0x16114, 6, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16140, 48, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16204, 5, RI_E1HE2E3E3B0_ONLINE},
	{ 0x18000, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x18008, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x18010, 35, RI_E2E3E3B0_ONLINE},
	{ 0x180a4, 2, RI_E2E3E3B0_ONLINE},
	{ 0x180c0, 9, RI_E2E3E3B0_ONLINE},
	{ 0x180e4, 1, RI_E2E3_ONLINE},
	{ 0x180e8, 2, RI_E2E3E3B0_ONLINE},
	{ 0x180f0, 1, RI_E2E3_ONLINE},
	{ 0x180f4, 79, RI_E2E3E3B0_ONLINE},
	{ 0x18230, 1, RI_E2E3_ONLINE},
	{ 0x18234, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1823c, 1, RI_E2E3_ONLINE},
	{ 0x18240, 13, RI_E2E3E3B0_ONLINE},
	{ 0x18274, 1, RI_E2_ONLINE},
	{ 0x18278, 81, RI_E2E3E3B0_ONLINE},
	{ 0x18440, 63, RI_E2E3E3B0_ONLINE},
	{ 0x18570, 42, RI_E3E3B0_ONLINE},
	{ 0x18618, 25, RI_E3B0_ONLINE},
	{ 0x18680, 44, RI_E3B0_ONLINE},
	{ 0x18748, 12, RI_E3B0_ONLINE},
	{ 0x18788, 1, RI_E3B0_ONLINE},
	{ 0x1879c, 6, RI_E3B0_ONLINE},
	{ 0x187c4, 51, RI_E3B0_ONLINE},
	{ 0x18a00, 48, RI_E3B0_ONLINE},
	{ 0x20000, 24, RI_ALL_ONLINE},
	{ 0x20060, 8, RI_ALL_ONLINE},
	{ 0x20080, 94, RI_ALL_ONLINE},
	{ 0x201f8, 1, RI_E1E1H_ONLINE},
	{ 0x201fc, 1, RI_ALL_ONLINE},
	{ 0x20200, 1, RI_E1E1H_ONLINE},
	{ 0x20204, 1, RI_ALL_ONLINE},
	{ 0x20208, 1, RI_E1E1H_ONLINE},
	{ 0x2020c, 39, RI_ALL_ONLINE},
	{ 0x202c8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x202d8, 4, RI_E2E3E3B0_ONLINE},
	{ 0x202f0, 1, RI_E3B0_ONLINE},
	{ 0x20400, 2, RI_ALL_ONLINE},
	{ 0x2040c, 8, RI_ALL_ONLINE},
	{ 0x2042c, 18, RI_E1HE2E3E3B0_ONLINE},
	{ 0x20480, 1, RI_ALL_ONLINE},
	{ 0x20500, 1, RI_ALL_ONLINE},
	{ 0x20600, 1, RI_ALL_ONLINE},
	{ 0x28000, 1, RI_ALL_ONLINE},
	{ 0x28004, 8191, RI_ALL_OFFLINE},
	{ 0x30000, 1, RI_ALL_ONLINE},
	{ 0x30004, 16383, RI_ALL_OFFLINE},
	{ 0x40000, 98, RI_ALL_ONLINE},
	{ 0x401a8, 8, RI_E1HE2E3E3B0_ONLINE},
	{ 0x401c8, 1, RI_E1H_ONLINE},
	{ 0x401cc, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x401d4, 2, RI_E2E3E3B0_ONLINE},
	{ 0x40200, 4, RI_ALL_ONLINE},
	{ 0x40220, 6, RI_E2E3E3B0_ONLINE},
	{ 0x40238, 8, RI_E2E3_ONLINE},
	{ 0x40258, 4, RI_E2E3E3B0_ONLINE},
	{ 0x40268, 2, RI_E3E3B0_ONLINE},
	{ 0x40270, 17, RI_E3B0_ONLINE},
	{ 0x40400, 43, RI_ALL_ONLINE},
	{ 0x404cc, 3, RI_E1HE2E3E3B0_ONLINE},
	{ 0x404e0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x40500, 2, RI_ALL_ONLINE},
	{ 0x40510, 2, RI_ALL_ONLINE},
	{ 0x40520, 2, RI_ALL_ONLINE},
	{ 0x40530, 2, RI_ALL_ONLINE},
	{ 0x40540, 2, RI_ALL_ONLINE},
	{ 0x40550, 10, RI_E2E3E3B0_ONLINE},
	{ 0x40610, 2, RI_E2E3E3B0_ONLINE},
	{ 0x42000, 164, RI_ALL_ONLINE},
	{ 0x422c0, 4, RI_E2E3E3B0_ONLINE},
	{ 0x422d4, 5, RI_E1HE2E3E3B0_ONLINE},
	{ 0x422e8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x42400, 49, RI_ALL_ONLINE},
	{ 0x424c8, 38, RI_ALL_ONLINE},
	{ 0x42568, 2, RI_ALL_ONLINE},
	{ 0x42640, 5, RI_E2E3E3B0_ONLINE},
	{ 0x42800, 1, RI_ALL_ONLINE},
	{ 0x50000, 1, RI_ALL_ONLINE},
	{ 0x50004, 19, RI_ALL_ONLINE},
	{ 0x50050, 8, RI_ALL_ONLINE},
	{ 0x50070, 88, RI_ALL_ONLINE},
	{ 0x501f0, 4, RI_E1HE2E3E3B0_ONLINE},
	{ 0x50200, 2, RI_ALL_ONLINE},
	{ 0x5020c, 7, RI_ALL_ONLINE},
	{ 0x50228, 6, RI_E1HE2E3E3B0_ONLINE},
	{ 0x50240, 1, RI_ALL_ONLINE},
	{ 0x50280, 1, RI_ALL_ONLINE},
	{ 0x50300, 1, RI_E2E3E3B0_ONLINE},
	{ 0x5030c, 1, RI_E2E3E3B0_ONLINE},
	{ 0x50318, 1, RI_E2E3E3B0_ONLINE},
	{ 0x5031c, 1, RI_E2E3E3B0_ONLINE},
	{ 0x50320, 2, RI_E2E3E3B0_ONLINE},
	{ 0x50330, 1, RI_E3B0_ONLINE},
	{ 0x52000, 1, RI_ALL_ONLINE},
	{ 0x54000, 1, RI_ALL_ONLINE},
	{ 0x54004, 3327, RI_ALL_OFFLINE},
	{ 0x58000, 1, RI_ALL_ONLINE},
	{ 0x58004, 8191, RI_E1E1H_OFFLINE},
	{ 0x60000, 26, RI_ALL_ONLINE},
	{ 0x60068, 8, RI_E1E1H_ONLINE},
	{ 0x60088, 12, RI_ALL_ONLINE},
	{ 0x600b8, 9, RI_E1E1H_ONLINE},
	{ 0x600dc, 1, RI_ALL_ONLINE},
	{ 0x600e0, 5, RI_E1E1H_ONLINE},
	{ 0x600f4, 1, RI_E1E1HE2_ONLINE},
	{ 0x600f8, 1, RI_E1E1H_ONLINE},
	{ 0x600fc, 8, RI_ALL_ONLINE},
	{ 0x6013c, 24, RI_E1H_ONLINE},
	{ 0x6019c, 2, RI_E2E3E3B0_ONLINE},
	{ 0x601ac, 18, RI_E2E3E3B0_ONLINE},
	{ 0x60200, 1, RI_ALL_ONLINE},
	{ 0x60204, 2, RI_ALL_OFFLINE},
	{ 0x60210, 13, RI_E2E3E3B0_ONLINE},
	{ 0x60244, 16, RI_E3B0_ONLINE},
	{ 0x61000, 1, RI_ALL_ONLINE},
	{ 0x61004, 511, RI_ALL_OFFLINE},
	{ 0x61800, 512, RI_E3E3B0_OFFLINE},
	{ 0x70000, 8, RI_ALL_ONLINE},
	{ 0x70020, 8184, RI_ALL_OFFLINE},
	{ 0x78000, 8192, RI_E3E3B0_OFFLINE},
	{ 0x85000, 3, RI_ALL_OFFLINE},
	{ 0x8501c, 7, RI_ALL_OFFLINE},
	{ 0x85048, 1, RI_ALL_OFFLINE},
	{ 0x85200, 32, RI_ALL_OFFLINE},
	{ 0xa0000, 16384, RI_E1E1H_OFFLINE},
	{ 0xb0000, 16384, RI_E1H_OFFLINE},
	{ 0xc1000, 7, RI_ALL_ONLINE},
	{ 0xc103c, 2, RI_E2E3E3B0_ONLINE},
	{ 0xc1800, 2, RI_ALL_ONLINE},
	{ 0xc2000, 164, RI_ALL_ONLINE},
	{ 0xc22c0, 5, RI_E2E3E3B0_ONLINE},
	{ 0xc22d8, 4, RI_E2E3E3B0_ONLINE},
	{ 0xc2400, 49, RI_ALL_ONLINE},
	{ 0xc24c8, 38, RI_ALL_ONLINE},
	{ 0xc2568, 2, RI_ALL_ONLINE},
	{ 0xc2600, 1, RI_ALL_ONLINE},
	{ 0xc4000, 165, RI_ALL_ONLINE},
	{ 0xc42d8, 2, RI_E2E3E3B0_ONLINE},
	{ 0xc42e0, 7, RI_E1HE2E3E3B0_ONLINE},
	{ 0xc42fc, 1, RI_E2E3E3B0_ONLINE},
	{ 0xc4400, 51, RI_ALL_ONLINE},
	{ 0xc44d0, 38, RI_ALL_ONLINE},
	{ 0xc4570, 2, RI_ALL_ONLINE},
	{ 0xc4578, 5, RI_E2E3E3B0_ONLINE},
	{ 0xc4600, 1, RI_ALL_ONLINE},
	{ 0xd0000, 19, RI_ALL_ONLINE},
	{ 0xd004c, 8, RI_ALL_ONLINE},
	{ 0xd006c, 91, RI_ALL_ONLINE},
	{ 0xd01fc, 1, RI_E2E3E3B0_ONLINE},
	{ 0xd0200, 2, RI_ALL_ONLINE},
	{ 0xd020c, 7, RI_ALL_ONLINE},
	{ 0xd0228, 18, RI_E1HE2E3E3B0_ONLINE},
	{ 0xd0280, 1, RI_ALL_ONLINE},
	{ 0xd0300, 1, RI_ALL_ONLINE},
	{ 0xd0400, 1, RI_ALL_ONLINE},
	{ 0xd0818, 1, RI_E3B0_ONLINE},
	{ 0xd4000, 1, RI_ALL_ONLINE},
	{ 0xd4004, 2559, RI_ALL_OFFLINE},
	{ 0xd8000, 1, RI_ALL_ONLINE},
	{ 0xd8004, 8191, RI_ALL_OFFLINE},
	{ 0xe0000, 21, RI_ALL_ONLINE},
	{ 0xe0054, 8, RI_ALL_ONLINE},
	{ 0xe0074, 49, RI_ALL_ONLINE},
	{ 0xe0138, 1, RI_E1E1H_ONLINE},
	{ 0xe013c, 35, RI_ALL_ONLINE},
	{ 0xe01f4, 1, RI_E2_ONLINE},
	{ 0xe01f8, 1, RI_E2E3E3B0_ONLINE},
	{ 0xe0200, 2, RI_ALL_ONLINE},
	{ 0xe020c, 8, RI_ALL_ONLINE},
	{ 0xe022c, 18, RI_E1HE2E3E3B0_ONLINE},
	{ 0xe0280, 1, RI_ALL_ONLINE},
	{ 0xe0300, 1, RI_ALL_ONLINE},
	{ 0xe0400, 1, RI_E3B0_ONLINE},
	{ 0xe1000, 1, RI_ALL_ONLINE},
	{ 0xe2000, 1, RI_ALL_ONLINE},
	{ 0xe2004, 2047, RI_ALL_OFFLINE},
	{ 0xf0000, 1, RI_ALL_ONLINE},
	{ 0xf0004, 16383, RI_ALL_OFFLINE},
	{ 0x101000, 12, RI_ALL_ONLINE},
	{ 0x101050, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x101054, 3, RI_E2E3E3B0_ONLINE},
	{ 0x101100, 1, RI_ALL_ONLINE},
	{ 0x101800, 8, RI_ALL_ONLINE},
	{ 0x102000, 18, RI_ALL_ONLINE},
	{ 0x102068, 6, RI_E2E3E3B0_ONLINE},
	{ 0x102080, 17, RI_ALL_ONLINE},
	{ 0x1020c8, 8, RI_E1H_ONLINE},
	{ 0x1020e8, 9, RI_E2E3E3B0_ONLINE},
	{ 0x102400, 1, RI_ALL_ONLINE},
	{ 0x103000, 26, RI_ALL_ONLINE},
	{ 0x103098, 5, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1030ac, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1030b4, 1, RI_E2_ONLINE},
	{ 0x1030b8, 7, RI_E2E3E3B0_ONLINE},
	{ 0x1030d8, 8, RI_E2E3E3B0_ONLINE},
	{ 0x103400, 1, RI_E2E3E3B0_ONLINE},
	{ 0x103404, 135, RI_E2E3E3B0_OFFLINE},
	{ 0x103800, 8, RI_ALL_ONLINE},
	{ 0x104000, 63, RI_ALL_ONLINE},
	{ 0x10411c, 16, RI_E2E3E3B0_ONLINE},
	{ 0x104200, 17, RI_ALL_ONLINE},
	{ 0x104400, 64, RI_ALL_ONLINE},
	{ 0x104500, 192, RI_ALL_OFFLINE},
	{ 0x104800, 64, RI_ALL_ONLINE},
	{ 0x104900, 192, RI_ALL_OFFLINE},
	{ 0x105000, 256, RI_ALL_ONLINE},
	{ 0x105400, 768, RI_ALL_OFFLINE},
	{ 0x107000, 7, RI_E2E3E3B0_ONLINE},
	{ 0x10701c, 1, RI_E3E3B0_ONLINE},
	{ 0x108000, 33, RI_E1E1H_ONLINE},
	{ 0x1080ac, 5, RI_E1H_ONLINE},
	{ 0x108100, 5, RI_E1E1H_ONLINE},
	{ 0x108120, 5, RI_E1E1H_ONLINE},
	{ 0x108200, 74, RI_E1E1H_ONLINE},
	{ 0x108400, 74, RI_E1E1H_ONLINE},
	{ 0x108800, 152, RI_E1E1H_ONLINE},
	{ 0x110000, 111, RI_E2E3E3B0_ONLINE},
	{ 0x1101dc, 1, RI_E3E3B0_ONLINE},
	{ 0x110200, 4, RI_E2E3E3B0_ONLINE},
	{ 0x120000, 2, RI_ALL_ONLINE},
	{ 0x120008, 4, RI_ALL_ONLINE},
	{ 0x120018, 3, RI_ALL_ONLINE},
	{ 0x120024, 4, RI_ALL_ONLINE},
	{ 0x120034, 3, RI_ALL_ONLINE},
	{ 0x120040, 4, RI_ALL_ONLINE},
	{ 0x120050, 3, RI_ALL_ONLINE},
	{ 0x12005c, 4, RI_ALL_ONLINE},
	{ 0x12006c, 3, RI_ALL_ONLINE},
	{ 0x120078, 4, RI_ALL_ONLINE},
	{ 0x120088, 3, RI_ALL_ONLINE},
	{ 0x120094, 4, RI_ALL_ONLINE},
	{ 0x1200a4, 3, RI_ALL_ONLINE},
	{ 0x1200b0, 4, RI_ALL_ONLINE},
	{ 0x1200c0, 3, RI_ALL_ONLINE},
	{ 0x1200cc, 4, RI_ALL_ONLINE},
	{ 0x1200dc, 3, RI_ALL_ONLINE},
	{ 0x1200e8, 4, RI_ALL_ONLINE},
	{ 0x1200f8, 3, RI_ALL_ONLINE},
	{ 0x120104, 4, RI_ALL_ONLINE},
	{ 0x120114, 1, RI_ALL_ONLINE},
	{ 0x120118, 22, RI_ALL_ONLINE},
	{ 0x120170, 2, RI_E1E1H_ONLINE},
	{ 0x120178, 243, RI_ALL_ONLINE},
	{ 0x120544, 4, RI_E1E1H_ONLINE},
	{ 0x120554, 6, RI_ALL_ONLINE},
	{ 0x12059c, 6, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1205b4, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1205b8, 15, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1205f4, 1, RI_E1HE2_ONLINE},
	{ 0x1205f8, 4, RI_E2E3E3B0_ONLINE},
	{ 0x120618, 1, RI_E2E3E3B0_ONLINE},
	{ 0x12061c, 20, RI_E1HE2E3E3B0_ONLINE},
	{ 0x12066c, 11, RI_E1HE2E3E3B0_ONLINE},
	{ 0x120698, 3, RI_E2E3E3B0_ONLINE},
	{ 0x1206a4, 1, RI_E2_ONLINE},
	{ 0x1206a8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1206b0, 75, RI_E2E3E3B0_ONLINE},
	{ 0x1207dc, 1, RI_E2_ONLINE},
	{ 0x1207fc, 1, RI_E2E3E3B0_ONLINE},
	{ 0x12080c, 65, RI_ALL_ONLINE},
	{ 0x120910, 7, RI_E2E3E3B0_ONLINE},
	{ 0x120930, 9, RI_E2E3E3B0_ONLINE},
	{ 0x12095c, 37, RI_E3E3B0_ONLINE},
	{ 0x120a00, 2, RI_E1E1HE2_ONLINE},
	{ 0x120b00, 1, RI_E3E3B0_ONLINE},
	{ 0x122000, 2, RI_ALL_ONLINE},
	{ 0x122008, 2046, RI_E1_OFFLINE},
	{ 0x128000, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x128008, 6142, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x130000, 35, RI_E2E3E3B0_ONLINE},
	{ 0x130100, 29, RI_E2E3E3B0_ONLINE},
	{ 0x130180, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130200, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130280, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130300, 5, RI_E2E3E3B0_ONLINE},
	{ 0x130380, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130400, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130480, 5, RI_E2E3E3B0_ONLINE},
	{ 0x130800, 72, RI_E2E3E3B0_ONLINE},
	{ 0x131000, 136, RI_E2E3E3B0_ONLINE},
	{ 0x132000, 148, RI_E2E3E3B0_ONLINE},
	{ 0x134000, 544, RI_E2E3E3B0_ONLINE},
	{ 0x140000, 1, RI_ALL_ONLINE},
	{ 0x140004, 9, RI_E1E1HE2E3_ONLINE},
	{ 0x140028, 8, RI_ALL_ONLINE},
	{ 0x140048, 10, RI_E1E1HE2E3_ONLINE},
	{ 0x140070, 1, RI_ALL_ONLINE},
	{ 0x140074, 10, RI_E1E1HE2E3_ONLINE},
	{ 0x14009c, 1, RI_ALL_ONLINE},
	{ 0x1400a0, 5, RI_E1E1HE2E3_ONLINE},
	{ 0x1400b4, 7, RI_ALL_ONLINE},
	{ 0x1400d0, 10, RI_E1E1HE2E3_ONLINE},
	{ 0x1400f8, 2, RI_ALL_ONLINE},
	{ 0x140100, 5, RI_E1E1H_ONLINE},
	{ 0x140114, 5, RI_E1E1HE2E3_ONLINE},
	{ 0x140128, 7, RI_ALL_ONLINE},
	{ 0x140144, 9, RI_E1E1HE2E3_ONLINE},
	{ 0x140168, 8, RI_ALL_ONLINE},
	{ 0x140188, 3, RI_E1E1HE2E3_ONLINE},
	{ 0x140194, 13, RI_ALL_ONLINE},
	{ 0x140200, 6, RI_E1E1HE2E3_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x140220, 4, RI_E2E3_ONLINE},
	{ 0x140240, 4, RI_E2E3_ONLINE},
#endif
	{ 0x140260, 4, RI_E2E3_ONLINE},
	{ 0x140280, 4, RI_E2E3_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x1402a0, 4, RI_E2E3_ONLINE},
	{ 0x1402c0, 4, RI_E2E3_ONLINE},
#endif
	{ 0x1402e0, 2, RI_E2E3_ONLINE},
	{ 0x1402e8, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1402f0, 9, RI_E2E3_ONLINE},
	{ 0x140314, 44, RI_E3B0_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x1403d0, 70, RI_E3B0_ONLINE},
#endif
	{ 0x144000, 4, RI_E1E1H_ONLINE},
	{ 0x148000, 4, RI_E1E1H_ONLINE},
	{ 0x14c000, 4, RI_E1E1H_ONLINE},
	{ 0x150000, 4, RI_E1E1H_ONLINE},
	{ 0x154000, 4, RI_E1E1H_ONLINE},
	{ 0x158000, 4, RI_E1E1H_ONLINE},
	{ 0x15c000, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x15c008, 5, RI_E1H_ONLINE},
	{ 0x15c020, 8, RI_E2E3E3B0_ONLINE},
	{ 0x15c040, 1, RI_E2E3_ONLINE},
	{ 0x15c044, 2, RI_E2E3E3B0_ONLINE},
	{ 0x15c04c, 8, RI_E2E3_ONLINE},
	{ 0x15c06c, 8, RI_E2E3E3B0_ONLINE},
	{ 0x15c090, 13, RI_E2E3E3B0_ONLINE},
	{ 0x15c0c8, 24, RI_E2E3E3B0_ONLINE},
	{ 0x15c128, 2, RI_E2E3_ONLINE},
	{ 0x15c130, 8, RI_E2E3E3B0_ONLINE},
	{ 0x15c150, 2, RI_E3E3B0_ONLINE},
	{ 0x15c158, 2, RI_E3_ONLINE},
	{ 0x15c160, 149, RI_E3B0_ONLINE},
	{ 0x160004, 6, RI_E3E3B0_ONLINE},
	{ 0x16003c, 1, RI_E3B0_ONLINE},
	{ 0x160040, 6, RI_E3E3B0_ONLINE},
	{ 0x16005c, 6, RI_E3E3B0_ONLINE},
	{ 0x160074, 1, RI_E3B0_ONLINE},
	{ 0x160078, 2, RI_E3E3B0_ONLINE},
	{ 0x160300, 8, RI_E3E3B0_ONLINE},
	{ 0x160330, 6, RI_E3E3B0_ONLINE},
	{ 0x160404, 6, RI_E3E3B0_ONLINE},
	{ 0x16043c, 1, RI_E3B0_ONLINE},
	{ 0x160440, 6, RI_E3E3B0_ONLINE},
	{ 0x16045c, 6, RI_E3E3B0_ONLINE},
	{ 0x160474, 1, RI_E3B0_ONLINE},
	{ 0x160478, 2, RI_E3E3B0_ONLINE},
	{ 0x160700, 8, RI_E3E3B0_ONLINE},
	{ 0x160730, 6, RI_E3E3B0_ONLINE},
	{ 0x161000, 7, RI_ALL_ONLINE},
	{ 0x16103c, 2, RI_E2E3E3B0_ONLINE},
	{ 0x161800, 2, RI_ALL_ONLINE},
	{ 0x162000, 54, RI_E3E3B0_ONLINE},
	{ 0x162200, 60, RI_E3E3B0_ONLINE},
	{ 0x162400, 54, RI_E3E3B0_ONLINE},
	{ 0x162600, 60, RI_E3E3B0_ONLINE},
	{ 0x162800, 54, RI_E3E3B0_ONLINE},
	{ 0x162a00, 60, RI_E3E3B0_ONLINE},
	{ 0x162c00, 54, RI_E3E3B0_ONLINE},
	{ 0x162e00, 60, RI_E3E3B0_ONLINE},
	{ 0x163000, 1, RI_E3E3B0_ONLINE},
	{ 0x163008, 1, RI_E3E3B0_ONLINE},
	{ 0x163010, 1, RI_E3E3B0_ONLINE},
	{ 0x163018, 1, RI_E3E3B0_ONLINE},
	{ 0x163020, 5, RI_E3E3B0_ONLINE},
	{ 0x163038, 3, RI_E3E3B0_ONLINE},
	{ 0x163048, 3, RI_E3E3B0_ONLINE},
	{ 0x163058, 1, RI_E3E3B0_ONLINE},
	{ 0x163060, 1, RI_E3E3B0_ONLINE},
	{ 0x163068, 1, RI_E3E3B0_ONLINE},
	{ 0x163070, 3, RI_E3E3B0_ONLINE},
	{ 0x163080, 1, RI_E3E3B0_ONLINE},
	{ 0x163088, 3, RI_E3E3B0_ONLINE},
	{ 0x163098, 1, RI_E3E3B0_ONLINE},
	{ 0x1630a0, 1, RI_E3E3B0_ONLINE},
	{ 0x1630a8, 1, RI_E3E3B0_ONLINE},
	{ 0x1630b0, 2, RI_E3B0_ONLINE},
	{ 0x1630c0, 1, RI_E3E3B0_ONLINE},
	{ 0x1630c8, 1, RI_E3E3B0_ONLINE},
	{ 0x1630d0, 1, RI_E3E3B0_ONLINE},
	{ 0x1630d8, 1, RI_E3E3B0_ONLINE},
	{ 0x1630e0, 2, RI_E3E3B0_ONLINE},
	{ 0x163110, 1, RI_E3E3B0_ONLINE},
	{ 0x163120, 2, RI_E3E3B0_ONLINE},
	{ 0x163420, 4, RI_E3E3B0_ONLINE},
	{ 0x163438, 2, RI_E3E3B0_ONLINE},
	{ 0x163488, 2, RI_E3E3B0_ONLINE},
	{ 0x163520, 2, RI_E3E3B0_ONLINE},
	{ 0x163800, 1, RI_E3E3B0_ONLINE},
	{ 0x163808, 1, RI_E3E3B0_ONLINE},
	{ 0x163810, 1, RI_E3E3B0_ONLINE},
	{ 0x163818, 1, RI_E3E3B0_ONLINE},
	{ 0x163820, 5, RI_E3E3B0_ONLINE},
	{ 0x163838, 3, RI_E3E3B0_ONLINE},
	{ 0x163848, 3, RI_E3E3B0_ONLINE},
	{ 0x163858, 1, RI_E3E3B0_ONLINE},
	{ 0x163860, 1, RI_E3E3B0_ONLINE},
	{ 0x163868, 1, RI_E3E3B0_ONLINE},
	{ 0x163870, 3, RI_E3E3B0_ONLINE},
	{ 0x163880, 1, RI_E3E3B0_ONLINE},
	{ 0x163888, 3, RI_E3E3B0_ONLINE},
	{ 0x163898, 1, RI_E3E3B0_ONLINE},
	{ 0x1638a0, 1, RI_E3E3B0_ONLINE},
	{ 0x1638a8, 1, RI_E3E3B0_ONLINE},
	{ 0x1638b0, 2, RI_E3B0_ONLINE},
	{ 0x1638c0, 1, RI_E3E3B0_ONLINE},
	{ 0x1638c8, 1, RI_E3E3B0_ONLINE},
	{ 0x1638d0, 1, RI_E3E3B0_ONLINE},
	{ 0x1638d8, 1, RI_E3E3B0_ONLINE},
	{ 0x1638e0, 2, RI_E3E3B0_ONLINE},
	{ 0x163910, 1, RI_E3E3B0_ONLINE},
	{ 0x163920, 2, RI_E3E3B0_ONLINE},
	{ 0x163c20, 4, RI_E3E3B0_ONLINE},
	{ 0x163c38, 2, RI_E3E3B0_ONLINE},
	{ 0x163c88, 2, RI_E3E3B0_ONLINE},
	{ 0x163d20, 2, RI_E3E3B0_ONLINE},
	{ 0x164000, 60, RI_ALL_ONLINE},
	{ 0x164110, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x164118, 15, RI_E2E3E3B0_ONLINE},
	{ 0x164200, 1, RI_ALL_ONLINE},
	{ 0x164208, 1, RI_ALL_ONLINE},
	{ 0x164210, 1, RI_ALL_ONLINE},
	{ 0x164218, 1, RI_ALL_ONLINE},
	{ 0x164220, 1, RI_ALL_ONLINE},
	{ 0x164228, 1, RI_ALL_ONLINE},
	{ 0x164230, 1, RI_ALL_ONLINE},
	{ 0x164238, 1, RI_ALL_ONLINE},
	{ 0x164240, 1, RI_ALL_ONLINE},
	{ 0x164248, 1, RI_ALL_ONLINE},
	{ 0x164250, 1, RI_ALL_ONLINE},
	{ 0x164258, 1, RI_ALL_ONLINE},
	{ 0x164260, 1, RI_ALL_ONLINE},
	{ 0x164270, 2, RI_ALL_ONLINE},
	{ 0x164280, 2, RI_ALL_ONLINE},
	{ 0x164800, 2, RI_ALL_ONLINE},
	{ 0x165000, 2, RI_ALL_ONLINE},
	{ 0x166000, 164, RI_ALL_ONLINE},
	{ 0x1662cc, 7, RI_E2E3E3B0_ONLINE},
	{ 0x166400, 49, RI_ALL_ONLINE},
	{ 0x1664c8, 38, RI_ALL_ONLINE},
	{ 0x166568, 2, RI_ALL_ONLINE},
	{ 0x166570, 5, RI_E2E3E3B0_ONLINE},
	{ 0x166800, 1, RI_ALL_ONLINE},
	{ 0x168000, 137, RI_ALL_ONLINE},
	{ 0x168224, 2, RI_E1E1H_ONLINE},
	{ 0x16822c, 29, RI_ALL_ONLINE},
	{ 0x1682a0, 12, RI_E1E1H_ONLINE},
	{ 0x1682d0, 12, RI_ALL_ONLINE},
	{ 0x168300, 2, RI_E1E1H_ONLINE},
	{ 0x168308, 68, RI_ALL_ONLINE},
	{ 0x168418, 2, RI_E1E1H_ONLINE},
	{ 0x168420, 6, RI_ALL_ONLINE},
	{ 0x168800, 19, RI_ALL_ONLINE},
	{ 0x168900, 1, RI_ALL_ONLINE},
	{ 0x168a00, 128, RI_ALL_ONLINE},
	{ 0x16a000, 1, RI_ALL_ONLINE},
	{ 0x16a004, 1535, RI_ALL_OFFLINE},
	{ 0x16c000, 1, RI_ALL_ONLINE},
	{ 0x16c004, 1535, RI_ALL_OFFLINE},
	{ 0x16e000, 16, RI_E1H_ONLINE},
	{ 0x16e040, 8, RI_E2E3E3B0_ONLINE},
	{ 0x16e100, 1, RI_E1H_ONLINE},
	{ 0x16e200, 2, RI_E1H_ONLINE},
	{ 0x16e400, 161, RI_E1H_ONLINE},
	{ 0x16e684, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16e68c, 12, RI_E1H_ONLINE},
	{ 0x16e6bc, 4, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16e6cc, 4, RI_E1H_ONLINE},
	{ 0x16e6e0, 2, RI_E2E3E3B0_ONLINE},
	{ 0x16e6e8, 5, RI_E2E3_ONLINE},
	{ 0x16e6fc, 5, RI_E2E3E3B0_ONLINE},
	{ 0x16e768, 17, RI_E2E3E3B0_ONLINE},
	{ 0x16e7ac, 12, RI_E3B0_ONLINE},
	{ 0x170000, 24, RI_ALL_ONLINE},
	{ 0x170060, 4, RI_E1E1H_ONLINE},
	{ 0x170070, 65, RI_ALL_ONLINE},
	{ 0x170194, 11, RI_E2E3E3B0_ONLINE},
	{ 0x1701c4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1701cc, 7, RI_E2E3E3B0_ONLINE},
	{ 0x1701e8, 1, RI_E3E3B0_ONLINE},
	{ 0x1701ec, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1701f4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x170200, 4, RI_ALL_ONLINE},
	{ 0x170214, 1, RI_ALL_ONLINE},
	{ 0x170218, 77, RI_E2E3E3B0_ONLINE},
	{ 0x170400, 64, RI_E2E3E3B0_ONLINE},
	{ 0x178000, 1, RI_ALL_ONLINE},
	{ 0x180000, 61, RI_ALL_ONLINE},
	{ 0x18013c, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x180200, 58, RI_ALL_ONLINE},
	{ 0x180340, 4, RI_ALL_ONLINE},
	{ 0x180380, 1, RI_E2E3E3B0_ONLINE},
	{ 0x180388, 1, RI_E2E3E3B0_ONLINE},
	{ 0x180390, 1, RI_E2E3E3B0_ONLINE},
	{ 0x180398, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1803a0, 5, RI_E2E3E3B0_ONLINE},
	{ 0x1803b4, 2, RI_E3E3B0_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x180400, 1, RI_ALL_ONLINE},
#endif
	{ 0x180404, 255, RI_E1E1H_OFFLINE},
	{ 0x181000, 4, RI_ALL_ONLINE},
	{ 0x181010, 1020, RI_ALL_OFFLINE},
	{ 0x182000, 4, RI_E3E3B0_ONLINE},
	{ 0x1a0000, 1, RI_ALL_ONLINE},
	{ 0x1a0004, 5631, RI_ALL_OFFLINE},
	{ 0x1a5800, 2560, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x1a8000, 1, RI_ALL_ONLINE},
	{ 0x1a8004, 8191, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x1b0000, 1, RI_ALL_ONLINE},
	{ 0x1b0004, 15, RI_E1H_OFFLINE},
	{ 0x1b0040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b0044, 239, RI_E1H_OFFLINE},
	{ 0x1b0400, 1, RI_ALL_ONLINE},
	{ 0x1b0404, 255, RI_E1H_OFFLINE},
	{ 0x1b0800, 1, RI_ALL_ONLINE},
	{ 0x1b0840, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b0c00, 1, RI_ALL_ONLINE},
	{ 0x1b1000, 1, RI_ALL_ONLINE},
	{ 0x1b1040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b1400, 1, RI_ALL_ONLINE},
	{ 0x1b1440, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b1480, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b14c0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b1800, 128, RI_ALL_OFFLINE},
	{ 0x1b1c00, 128, RI_ALL_OFFLINE},
	{ 0x1b2000, 1, RI_ALL_ONLINE},
	{ 0x1b2400, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b2404, 5631, RI_E2E3E3B0_OFFLINE},
	{ 0x1b8000, 1, RI_ALL_ONLINE},
	{ 0x1b8040, 1, RI_ALL_ONLINE},
	{ 0x1b8080, 1, RI_ALL_ONLINE},
	{ 0x1b80c0, 1, RI_ALL_ONLINE},
	{ 0x1b8100, 1, RI_ALL_ONLINE},
	{ 0x1b8140, 1, RI_ALL_ONLINE},
	{ 0x1b8180, 1, RI_ALL_ONLINE},
	{ 0x1b81c0, 1, RI_ALL_ONLINE},
	{ 0x1b8200, 1, RI_ALL_ONLINE},
	{ 0x1b8240, 1, RI_ALL_ONLINE},
	{ 0x1b8280, 1, RI_ALL_ONLINE},
	{ 0x1b82c0, 1, RI_ALL_ONLINE},
	{ 0x1b8300, 1, RI_ALL_ONLINE},
	{ 0x1b8340, 1, RI_ALL_ONLINE},
	{ 0x1b8380, 1, RI_ALL_ONLINE},
	{ 0x1b83c0, 1, RI_ALL_ONLINE},
	{ 0x1b8400, 1, RI_ALL_ONLINE},
	{ 0x1b8440, 1, RI_ALL_ONLINE},
	{ 0x1b8480, 1, RI_ALL_ONLINE},
	{ 0x1b84c0, 1, RI_ALL_ONLINE},
	{ 0x1b8500, 1, RI_ALL_ONLINE},
	{ 0x1b8540, 1, RI_ALL_ONLINE},
	{ 0x1b8580, 1, RI_ALL_ONLINE},
	{ 0x1b85c0, 19, RI_E2E3E3B0_ONLINE},
	{ 0x1b8800, 1, RI_ALL_ONLINE},
	{ 0x1b8840, 1, RI_ALL_ONLINE},
	{ 0x1b8880, 1, RI_ALL_ONLINE},
	{ 0x1b88c0, 1, RI_ALL_ONLINE},
	{ 0x1b8900, 1, RI_ALL_ONLINE},
	{ 0x1b8940, 1, RI_ALL_ONLINE},
	{ 0x1b8980, 1, RI_ALL_ONLINE},
	{ 0x1b89c0, 1, RI_ALL_ONLINE},
	{ 0x1b8a00, 1, RI_ALL_ONLINE},
	{ 0x1b8a40, 1, RI_ALL_ONLINE},
	{ 0x1b8a80, 1, RI_ALL_ONLINE},
	{ 0x1b8ac0, 1, RI_ALL_ONLINE},
	{ 0x1b8b00, 1, RI_ALL_ONLINE},
	{ 0x1b8b40, 1, RI_ALL_ONLINE},
	{ 0x1b8b80, 1, RI_ALL_ONLINE},
	{ 0x1b8bc0, 1, RI_ALL_ONLINE},
	{ 0x1b8c00, 1, RI_ALL_ONLINE},
	{ 0x1b8c40, 1, RI_ALL_ONLINE},
	{ 0x1b8c80, 1, RI_ALL_ONLINE},
	{ 0x1b8cc0, 1, RI_ALL_ONLINE},
	{ 0x1b8cc4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1b8d00, 1, RI_ALL_ONLINE},
	{ 0x1b8d40, 1, RI_ALL_ONLINE},
	{ 0x1b8d80, 1, RI_ALL_ONLINE},
	{ 0x1b8dc0, 1, RI_ALL_ONLINE},
	{ 0x1b8e00, 1, RI_ALL_ONLINE},
	{ 0x1b8e40, 1, RI_ALL_ONLINE},
	{ 0x1b8e80, 1, RI_ALL_ONLINE},
	{ 0x1b8e84, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1b8ec0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b8f00, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b8f40, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b8f80, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b8fc0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1b8fc4, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1b8fd0, 6, RI_E2E3E3B0_ONLINE},
	{ 0x1b8fe8, 2, RI_E3E3B0_ONLINE},
	{ 0x1b9000, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1b9040, 3, RI_E2E3E3B0_ONLINE},
	{ 0x1b905c, 1, RI_E3E3B0_ONLINE},
	{ 0x1b9064, 1, RI_E3B0_ONLINE},
	{ 0x1b9080, 10, RI_E3B0_ONLINE},
	{ 0x1b9400, 14, RI_E2E3E3B0_OFFLINE},
	{ 0x1b943c, 19, RI_E2E3E3B0_OFFLINE},
	{ 0x1b9490, 10, RI_E2E3E3B0_OFFLINE},
	{ 0x1c0000, 2, RI_ALL_ONLINE},
	{ 0x200000, 65, RI_ALL_ONLINE},
	{ 0x20014c, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x200200, 58, RI_ALL_ONLINE},
	{ 0x200340, 4, RI_ALL_ONLINE},
	{ 0x200380, 1, RI_E2E3E3B0_ONLINE},
	{ 0x200388, 1, RI_E2E3E3B0_ONLINE},
	{ 0x200390, 1, RI_E2E3E3B0_ONLINE},
	{ 0x200398, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2003a0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2003a8, 2, RI_E2E3E3B0_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x200400, 1, RI_ALL_ONLINE},
#endif
	{ 0x200404, 255, RI_E1E1H_OFFLINE},
	{ 0x202000, 4, RI_ALL_ONLINE},
	{ 0x202010, 2044, RI_ALL_OFFLINE},
	{ 0x204000, 4, RI_E3E3B0_ONLINE},
	{ 0x220000, 1, RI_ALL_ONLINE},
	{ 0x220004, 5631, RI_ALL_OFFLINE},
	{ 0x225800, 2560, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x228000, 1, RI_ALL_ONLINE},
	{ 0x228004, 8191, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x230000, 1, RI_ALL_ONLINE},
	{ 0x230004, 15, RI_E1H_OFFLINE},
	{ 0x230040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x230044, 239, RI_E1H_OFFLINE},
	{ 0x230400, 1, RI_ALL_ONLINE},
	{ 0x230404, 255, RI_E1H_OFFLINE},
	{ 0x230800, 1, RI_ALL_ONLINE},
	{ 0x230840, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x230c00, 1, RI_ALL_ONLINE},
	{ 0x231000, 1, RI_ALL_ONLINE},
	{ 0x231040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x231400, 1, RI_ALL_ONLINE},
	{ 0x231440, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x231480, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2314c0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x231800, 128, RI_ALL_OFFLINE},
	{ 0x231c00, 128, RI_ALL_OFFLINE},
	{ 0x232000, 1, RI_ALL_ONLINE},
	{ 0x232400, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x232404, 5631, RI_E2E3E3B0_OFFLINE},
	{ 0x238000, 1, RI_ALL_ONLINE},
	{ 0x238040, 1, RI_ALL_ONLINE},
	{ 0x238080, 1, RI_ALL_ONLINE},
	{ 0x2380c0, 1, RI_ALL_ONLINE},
	{ 0x238100, 1, RI_ALL_ONLINE},
	{ 0x238140, 1, RI_ALL_ONLINE},
	{ 0x238180, 1, RI_ALL_ONLINE},
	{ 0x2381c0, 1, RI_ALL_ONLINE},
	{ 0x238200, 1, RI_ALL_ONLINE},
	{ 0x238240, 1, RI_ALL_ONLINE},
	{ 0x238280, 1, RI_ALL_ONLINE},
	{ 0x2382c0, 1, RI_ALL_ONLINE},
	{ 0x238300, 1, RI_ALL_ONLINE},
	{ 0x238340, 1, RI_ALL_ONLINE},
	{ 0x238380, 1, RI_ALL_ONLINE},
	{ 0x2383c0, 1, RI_ALL_ONLINE},
	{ 0x238400, 1, RI_ALL_ONLINE},
	{ 0x238440, 1, RI_ALL_ONLINE},
	{ 0x238480, 1, RI_ALL_ONLINE},
	{ 0x2384c0, 1, RI_ALL_ONLINE},
	{ 0x238500, 1, RI_ALL_ONLINE},
	{ 0x238540, 1, RI_ALL_ONLINE},
	{ 0x238580, 1, RI_ALL_ONLINE},
	{ 0x2385c0, 19, RI_E2E3E3B0_ONLINE},
	{ 0x238800, 1, RI_ALL_ONLINE},
	{ 0x238840, 1, RI_ALL_ONLINE},
	{ 0x238880, 1, RI_ALL_ONLINE},
	{ 0x2388c0, 1, RI_ALL_ONLINE},
	{ 0x238900, 1, RI_ALL_ONLINE},
	{ 0x238940, 1, RI_ALL_ONLINE},
	{ 0x238980, 1, RI_ALL_ONLINE},
	{ 0x2389c0, 1, RI_ALL_ONLINE},
	{ 0x238a00, 1, RI_ALL_ONLINE},
	{ 0x238a40, 1, RI_ALL_ONLINE},
	{ 0x238a80, 1, RI_ALL_ONLINE},
	{ 0x238ac0, 1, RI_ALL_ONLINE},
	{ 0x238b00, 1, RI_ALL_ONLINE},
	{ 0x238b40, 1, RI_ALL_ONLINE},
	{ 0x238b80, 1, RI_ALL_ONLINE},
	{ 0x238bc0, 1, RI_ALL_ONLINE},
	{ 0x238c00, 1, RI_ALL_ONLINE},
	{ 0x238c40, 1, RI_ALL_ONLINE},
	{ 0x238c80, 1, RI_ALL_ONLINE},
	{ 0x238cc0, 1, RI_ALL_ONLINE},
	{ 0x238cc4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x238d00, 1, RI_ALL_ONLINE},
	{ 0x238d40, 1, RI_ALL_ONLINE},
	{ 0x238d80, 1, RI_ALL_ONLINE},
	{ 0x238dc0, 1, RI_ALL_ONLINE},
	{ 0x238e00, 1, RI_ALL_ONLINE},
	{ 0x238e40, 1, RI_ALL_ONLINE},
	{ 0x238e80, 1, RI_ALL_ONLINE},
	{ 0x238e84, 1, RI_E2E3E3B0_ONLINE},
	{ 0x238ec0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x238f00, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x238f40, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x238f80, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x238fc0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x238fc4, 2, RI_E2E3E3B0_ONLINE},
	{ 0x238fd0, 6, RI_E2E3E3B0_ONLINE},
	{ 0x238fe8, 2, RI_E3E3B0_ONLINE},
	{ 0x239000, 1, RI_E2E3E3B0_ONLINE},
	{ 0x239040, 3, RI_E2E3E3B0_ONLINE},
	{ 0x23905c, 1, RI_E3E3B0_ONLINE},
	{ 0x239064, 1, RI_E3B0_ONLINE},
	{ 0x239080, 10, RI_E3B0_ONLINE},
	{ 0x240000, 2, RI_ALL_ONLINE},
	{ 0x280000, 65, RI_ALL_ONLINE},
	{ 0x28014c, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x280200, 58, RI_ALL_ONLINE},
	{ 0x280340, 4, RI_ALL_ONLINE},
	{ 0x280380, 1, RI_E2E3E3B0_ONLINE},
	{ 0x280388, 1, RI_E2E3E3B0_ONLINE},
	{ 0x280390, 1, RI_E2E3E3B0_ONLINE},
	{ 0x280398, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2803a0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2803a8, 2, RI_E2E3E3B0_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x280400, 1, RI_ALL_ONLINE},
#endif
	{ 0x280404, 255, RI_E1E1H_OFFLINE},
	{ 0x282000, 4, RI_ALL_ONLINE},
	{ 0x282010, 2044, RI_ALL_OFFLINE},
	{ 0x284000, 4, RI_E3E3B0_ONLINE},
	{ 0x2a0000, 1, RI_ALL_ONLINE},
	{ 0x2a0004, 5631, RI_ALL_OFFLINE},
	{ 0x2a5800, 2560, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x2a8000, 1, RI_ALL_ONLINE},
	{ 0x2a8004, 8191, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x2b0000, 1, RI_ALL_ONLINE},
	{ 0x2b0004, 15, RI_E1H_OFFLINE},
	{ 0x2b0040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b0044, 239, RI_E1H_OFFLINE},
	{ 0x2b0400, 1, RI_ALL_ONLINE},
	{ 0x2b0404, 255, RI_E1H_OFFLINE},
	{ 0x2b0800, 1, RI_ALL_ONLINE},
	{ 0x2b0840, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b0c00, 1, RI_ALL_ONLINE},
	{ 0x2b1000, 1, RI_ALL_ONLINE},
	{ 0x2b1040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b1400, 1, RI_ALL_ONLINE},
	{ 0x2b1440, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b1480, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b14c0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b1800, 128, RI_ALL_OFFLINE},
	{ 0x2b1c00, 128, RI_ALL_OFFLINE},
	{ 0x2b2000, 1, RI_ALL_ONLINE},
	{ 0x2b2400, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b2404, 5631, RI_E2E3E3B0_OFFLINE},
	{ 0x2b8000, 1, RI_ALL_ONLINE},
	{ 0x2b8040, 1, RI_ALL_ONLINE},
	{ 0x2b8080, 1, RI_ALL_ONLINE},
	{ 0x2b80c0, 1, RI_ALL_ONLINE},
	{ 0x2b8100, 1, RI_ALL_ONLINE},
	{ 0x2b8140, 1, RI_ALL_ONLINE},
	{ 0x2b8180, 1, RI_ALL_ONLINE},
	{ 0x2b81c0, 1, RI_ALL_ONLINE},
	{ 0x2b8200, 1, RI_ALL_ONLINE},
	{ 0x2b8240, 1, RI_ALL_ONLINE},
	{ 0x2b8280, 1, RI_ALL_ONLINE},
	{ 0x2b82c0, 1, RI_ALL_ONLINE},
	{ 0x2b8300, 1, RI_ALL_ONLINE},
	{ 0x2b8340, 1, RI_ALL_ONLINE},
	{ 0x2b8380, 1, RI_ALL_ONLINE},
	{ 0x2b83c0, 1, RI_ALL_ONLINE},
	{ 0x2b8400, 1, RI_ALL_ONLINE},
	{ 0x2b8440, 1, RI_ALL_ONLINE},
	{ 0x2b8480, 1, RI_ALL_ONLINE},
	{ 0x2b84c0, 1, RI_ALL_ONLINE},
	{ 0x2b8500, 1, RI_ALL_ONLINE},
	{ 0x2b8540, 1, RI_ALL_ONLINE},
	{ 0x2b8580, 1, RI_ALL_ONLINE},
	{ 0x2b85c0, 19, RI_E2E3E3B0_ONLINE},
	{ 0x2b8800, 1, RI_ALL_ONLINE},
	{ 0x2b8840, 1, RI_ALL_ONLINE},
	{ 0x2b8880, 1, RI_ALL_ONLINE},
	{ 0x2b88c0, 1, RI_ALL_ONLINE},
	{ 0x2b8900, 1, RI_ALL_ONLINE},
	{ 0x2b8940, 1, RI_ALL_ONLINE},
	{ 0x2b8980, 1, RI_ALL_ONLINE},
	{ 0x2b89c0, 1, RI_ALL_ONLINE},
	{ 0x2b8a00, 1, RI_ALL_ONLINE},
	{ 0x2b8a40, 1, RI_ALL_ONLINE},
	{ 0x2b8a80, 1, RI_ALL_ONLINE},
	{ 0x2b8ac0, 1, RI_ALL_ONLINE},
	{ 0x2b8b00, 1, RI_ALL_ONLINE},
	{ 0x2b8b40, 1, RI_ALL_ONLINE},
	{ 0x2b8b80, 1, RI_ALL_ONLINE},
	{ 0x2b8bc0, 1, RI_ALL_ONLINE},
	{ 0x2b8c00, 1, RI_ALL_ONLINE},
	{ 0x2b8c40, 1, RI_ALL_ONLINE},
	{ 0x2b8c80, 1, RI_ALL_ONLINE},
	{ 0x2b8cc0, 1, RI_ALL_ONLINE},
	{ 0x2b8cc4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2b8d00, 1, RI_ALL_ONLINE},
	{ 0x2b8d40, 1, RI_ALL_ONLINE},
	{ 0x2b8d80, 1, RI_ALL_ONLINE},
	{ 0x2b8dc0, 1, RI_ALL_ONLINE},
	{ 0x2b8e00, 1, RI_ALL_ONLINE},
	{ 0x2b8e40, 1, RI_ALL_ONLINE},
	{ 0x2b8e80, 1, RI_ALL_ONLINE},
	{ 0x2b8e84, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2b8ec0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b8f00, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b8f40, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b8f80, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b8fc0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x2b8fc4, 2, RI_E2E3E3B0_ONLINE},
	{ 0x2b8fd0, 6, RI_E2E3E3B0_ONLINE},
	{ 0x2b8fe8, 2, RI_E3E3B0_ONLINE},
	{ 0x2b9000, 1, RI_E2E3E3B0_ONLINE},
	{ 0x2b9040, 3, RI_E2E3E3B0_ONLINE},
	{ 0x2b905c, 1, RI_E3E3B0_ONLINE},
	{ 0x2b9064, 1, RI_E3B0_ONLINE},
	{ 0x2b9080, 10, RI_E3B0_ONLINE},
	{ 0x2b9400, 14, RI_E2E3E3B0_ONLINE},
	{ 0x2b943c, 19, RI_E2E3E3B0_ONLINE},
	{ 0x2b9490, 10, RI_E2E3E3B0_ONLINE},
	{ 0x2c0000, 2, RI_ALL_ONLINE},
	{ 0x300000, 65, RI_ALL_ONLINE},
	{ 0x30014c, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x300200, 58, RI_ALL_ONLINE},
	{ 0x300340, 4, RI_ALL_ONLINE},
	{ 0x300380, 1, RI_E2E3E3B0_ONLINE},
	{ 0x300388, 1, RI_E2E3E3B0_ONLINE},
	{ 0x300390, 1, RI_E2E3E3B0_ONLINE},
	{ 0x300398, 1, RI_E2E3E3B0_ONLINE},
	{ 0x3003a0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x3003a8, 2, RI_E2E3E3B0_ONLINE},
#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */
	{ 0x300400, 1, RI_ALL_ONLINE},
#endif
	{ 0x300404, 255, RI_E1E1H_OFFLINE},
	{ 0x302000, 4, RI_ALL_ONLINE},
	{ 0x302010, 2044, RI_ALL_OFFLINE},
	{ 0x304000, 4, RI_E3E3B0_ONLINE},
	{ 0x320000, 1, RI_ALL_ONLINE},
	{ 0x320004, 5631, RI_ALL_OFFLINE},
	{ 0x325800, 2560, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x328000, 1, RI_ALL_ONLINE},
	{ 0x328004, 8191, RI_E1HE2E3E3B0_OFFLINE},
	{ 0x330000, 1, RI_ALL_ONLINE},
	{ 0x330004, 15, RI_E1H_OFFLINE},
	{ 0x330040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x330044, 239, RI_E1H_OFFLINE},
	{ 0x330400, 1, RI_ALL_ONLINE},
	{ 0x330404, 255, RI_E1H_OFFLINE},
	{ 0x330800, 1, RI_ALL_ONLINE},
	{ 0x330840, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x330c00, 1, RI_ALL_ONLINE},
	{ 0x331000, 1, RI_ALL_ONLINE},
	{ 0x331040, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x331400, 1, RI_ALL_ONLINE},
	{ 0x331440, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x331480, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x3314c0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x331800, 128, RI_ALL_OFFLINE},
	{ 0x331c00, 128, RI_ALL_OFFLINE},
	{ 0x332000, 1, RI_ALL_ONLINE},
	{ 0x332400, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x332404, 5631, RI_E2E3E3B0_OFFLINE},
	{ 0x338000, 1, RI_ALL_ONLINE},
	{ 0x338040, 1, RI_ALL_ONLINE},
	{ 0x338080, 1, RI_ALL_ONLINE},
	{ 0x3380c0, 1, RI_ALL_ONLINE},
	{ 0x338100, 1, RI_ALL_ONLINE},
	{ 0x338140, 1, RI_ALL_ONLINE},
	{ 0x338180, 1, RI_ALL_ONLINE},
	{ 0x3381c0, 1, RI_ALL_ONLINE},
	{ 0x338200, 1, RI_ALL_ONLINE},
	{ 0x338240, 1, RI_ALL_ONLINE},
	{ 0x338280, 1, RI_ALL_ONLINE},
	{ 0x3382c0, 1, RI_ALL_ONLINE},
	{ 0x338300, 1, RI_ALL_ONLINE},
	{ 0x338340, 1, RI_ALL_ONLINE},
	{ 0x338380, 1, RI_ALL_ONLINE},
	{ 0x3383c0, 1, RI_ALL_ONLINE},
	{ 0x338400, 1, RI_ALL_ONLINE},
	{ 0x338440, 1, RI_ALL_ONLINE},
	{ 0x338480, 1, RI_ALL_ONLINE},
	{ 0x3384c0, 1, RI_ALL_ONLINE},
	{ 0x338500, 1, RI_ALL_ONLINE},
	{ 0x338540, 1, RI_ALL_ONLINE},
	{ 0x338580, 1, RI_ALL_ONLINE},
	{ 0x3385c0, 19, RI_E2E3E3B0_ONLINE},
	{ 0x338800, 1, RI_ALL_ONLINE},
	{ 0x338840, 1, RI_ALL_ONLINE},
	{ 0x338880, 1, RI_ALL_ONLINE},
	{ 0x3388c0, 1, RI_ALL_ONLINE},
	{ 0x338900, 1, RI_ALL_ONLINE},
	{ 0x338940, 1, RI_ALL_ONLINE},
	{ 0x338980, 1, RI_ALL_ONLINE},
	{ 0x3389c0, 1, RI_ALL_ONLINE},
	{ 0x338a00, 1, RI_ALL_ONLINE},
	{ 0x338a40, 1, RI_ALL_ONLINE},
	{ 0x338a80, 1, RI_ALL_ONLINE},
	{ 0x338ac0, 1, RI_ALL_ONLINE},
	{ 0x338b00, 1, RI_ALL_ONLINE},
	{ 0x338b40, 1, RI_ALL_ONLINE},
	{ 0x338b80, 1, RI_ALL_ONLINE},
	{ 0x338bc0, 1, RI_ALL_ONLINE},
	{ 0x338c00, 1, RI_ALL_ONLINE},
	{ 0x338c40, 1, RI_ALL_ONLINE},
	{ 0x338c80, 1, RI_ALL_ONLINE},
	{ 0x338cc0, 1, RI_ALL_ONLINE},
	{ 0x338cc4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x338d00, 1, RI_ALL_ONLINE},
	{ 0x338d40, 1, RI_ALL_ONLINE},
	{ 0x338d80, 1, RI_ALL_ONLINE},
	{ 0x338dc0, 1, RI_ALL_ONLINE},
	{ 0x338e00, 1, RI_ALL_ONLINE},
	{ 0x338e40, 1, RI_ALL_ONLINE},
	{ 0x338e80, 1, RI_ALL_ONLINE},
	{ 0x338e84, 1, RI_E2E3E3B0_ONLINE},
	{ 0x338ec0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x338f00, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x338f40, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x338f80, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x338fc0, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x338fc4, 2, RI_E2E3E3B0_ONLINE},
	{ 0x338fd0, 6, RI_E2E3E3B0_ONLINE},
	{ 0x338fe8, 2, RI_E3E3B0_ONLINE},
	{ 0x339000, 1, RI_E2E3E3B0_ONLINE},
	{ 0x339040, 3, RI_E2E3E3B0_ONLINE},
	{ 0x33905c, 1, RI_E3E3B0_ONLINE},
	{ 0x339064, 1, RI_E3B0_ONLINE},
	{ 0x339080, 10, RI_E3B0_ONLINE},
	{ 0x340000, 2, RI_ALL_ONLINE},
	{ 0x3a0000, 32768, RI_E2E3E3B0_OFFLINE},
	{ 0x3c0000, 8192, RI_E2E3E3B0_OFFLINE}
};
#define REGS_COUNT ARRSIZE(reg_addrs)

#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */

static const struct reg_addr idle_addrs[] = {
	{ 0x2104, 1, RI_ALL_ONLINE},
	{ 0x2110, 2, RI_ALL_ONLINE},
	{ 0x211c, 8, RI_ALL_ONLINE},
	{ 0x2814, 1, RI_ALL_ONLINE},
	{ 0x281c, 2, RI_ALL_ONLINE},
	{ 0x2854, 1, RI_ALL_ONLINE},
	{ 0x285c, 1, RI_ALL_ONLINE},
	{ 0x3040, 1, RI_ALL_ONLINE},
	{ 0x9010, 7, RI_E2E3E3B0_ONLINE},
	{ 0x9030, 1, RI_E2E3E3B0_ONLINE},
	{ 0x9068, 16, RI_E2E3E3B0_ONLINE},
	{ 0x9230, 2, RI_E2E3E3B0_ONLINE},
	{ 0x9244, 1, RI_E2E3E3B0_ONLINE},
	{ 0x9298, 1, RI_E2E3E3B0_ONLINE},
	{ 0x92a8, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa38c, 1, RI_ALL_ONLINE},
	{ 0xa3c4, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa404, 3, RI_ALL_ONLINE},
	{ 0xa42c, 12, RI_ALL_ONLINE},
	{ 0xa580, 1, RI_ALL_ONLINE},
	{ 0xa590, 1, RI_ALL_ONLINE},
	{ 0xa600, 5, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa618, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0xa714, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa720, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa750, 1, RI_E2E3E3B0_ONLINE},
	{ 0xc09c, 1, RI_E1E1H_ONLINE},
	{ 0x103b0, 1, RI_ALL_ONLINE},
	{ 0x103c0, 1, RI_ALL_ONLINE},
	{ 0x103d0, 1, RI_E1H_ONLINE},
	{ 0x10418, 1, RI_ALL_ONLINE},
	{ 0x10420, 1, RI_ALL_ONLINE},
	{ 0x10428, 1, RI_ALL_ONLINE},
	{ 0x10460, 1, RI_ALL_ONLINE},
	{ 0x10474, 1, RI_ALL_ONLINE},
	{ 0x104e0, 1, RI_ALL_ONLINE},
	{ 0x104ec, 1, RI_ALL_ONLINE},
	{ 0x104f8, 1, RI_ALL_ONLINE},
	{ 0x10508, 1, RI_ALL_ONLINE},
	{ 0x10530, 1, RI_ALL_ONLINE},
	{ 0x10538, 1, RI_ALL_ONLINE},
	{ 0x10548, 1, RI_ALL_ONLINE},
	{ 0x10558, 1, RI_ALL_ONLINE},
	{ 0x182a8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x182b8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18308, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18318, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18338, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18348, 1, RI_E2E3E3B0_ONLINE},
	{ 0x183bc, 1, RI_E2E3E3B0_ONLINE},
	{ 0x183cc, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18570, 1, RI_E3E3B0_ONLINE},
	{ 0x18578, 1, RI_E3E3B0_ONLINE},
	{ 0x1858c, 1, RI_E3E3B0_ONLINE},
	{ 0x18594, 1, RI_E3E3B0_ONLINE},
	{ 0x1862c, 4, RI_E3B0_ONLINE},
	{ 0x2021c, 11, RI_ALL_ONLINE},
	{ 0x202a8, 1, RI_ALL_ONLINE},
	{ 0x202b8, 1, RI_ALL_ONLINE},
	{ 0x20404, 1, RI_ALL_ONLINE},
	{ 0x2040c, 2, RI_ALL_ONLINE},
	{ 0x2041c, 2, RI_ALL_ONLINE},
	{ 0x40154, 14, RI_ALL_ONLINE},
	{ 0x40198, 1, RI_ALL_ONLINE},
	{ 0x404ac, 1, RI_ALL_ONLINE},
	{ 0x404bc, 1, RI_ALL_ONLINE},
	{ 0x42290, 1, RI_ALL_ONLINE},
	{ 0x422a0, 1, RI_ALL_ONLINE},
	{ 0x422b0, 1, RI_ALL_ONLINE},
	{ 0x42548, 1, RI_ALL_ONLINE},
	{ 0x42550, 1, RI_ALL_ONLINE},
	{ 0x42558, 1, RI_ALL_ONLINE},
	{ 0x50160, 8, RI_ALL_ONLINE},
	{ 0x501d0, 1, RI_ALL_ONLINE},
	{ 0x501e0, 1, RI_ALL_ONLINE},
	{ 0x50204, 1, RI_ALL_ONLINE},
	{ 0x5020c, 2, RI_ALL_ONLINE},
	{ 0x5021c, 1, RI_ALL_ONLINE},
	{ 0x60090, 1, RI_ALL_ONLINE},
	{ 0x6011c, 1, RI_ALL_ONLINE},
	{ 0x6012c, 1, RI_ALL_ONLINE},
	{ 0xc101c, 1, RI_ALL_ONLINE},
	{ 0xc102c, 1, RI_ALL_ONLINE},
	{ 0xc2290, 1, RI_ALL_ONLINE},
	{ 0xc22a0, 1, RI_ALL_ONLINE},
	{ 0xc22b0, 1, RI_ALL_ONLINE},
	{ 0xc2548, 1, RI_ALL_ONLINE},
	{ 0xc2550, 1, RI_ALL_ONLINE},
	{ 0xc2558, 1, RI_ALL_ONLINE},
	{ 0xc4294, 1, RI_ALL_ONLINE},
	{ 0xc42a4, 1, RI_ALL_ONLINE},
	{ 0xc42b4, 1, RI_ALL_ONLINE},
	{ 0xc4550, 1, RI_ALL_ONLINE},
	{ 0xc4558, 1, RI_ALL_ONLINE},
	{ 0xc4560, 1, RI_ALL_ONLINE},
	{ 0xd016c, 8, RI_ALL_ONLINE},
	{ 0xd01d8, 1, RI_ALL_ONLINE},
	{ 0xd01e8, 1, RI_ALL_ONLINE},
	{ 0xd0204, 1, RI_ALL_ONLINE},
	{ 0xd020c, 3, RI_ALL_ONLINE},
	{ 0xe0154, 8, RI_ALL_ONLINE},
	{ 0xe01c8, 1, RI_ALL_ONLINE},
	{ 0xe01d8, 1, RI_ALL_ONLINE},
	{ 0xe0204, 1, RI_ALL_ONLINE},
	{ 0xe020c, 2, RI_ALL_ONLINE},
	{ 0xe021c, 2, RI_ALL_ONLINE},
	{ 0x101014, 1, RI_ALL_ONLINE},
	{ 0x101030, 1, RI_ALL_ONLINE},
	{ 0x101040, 1, RI_ALL_ONLINE},
	{ 0x102058, 1, RI_ALL_ONLINE},
	{ 0x102080, 16, RI_ALL_ONLINE},
	{ 0x103004, 2, RI_ALL_ONLINE},
	{ 0x103068, 1, RI_ALL_ONLINE},
	{ 0x103078, 1, RI_ALL_ONLINE},
	{ 0x103088, 1, RI_ALL_ONLINE},
	{ 0x10309c, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1030b8, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1030cc, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1030e0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x104004, 1, RI_ALL_ONLINE},
	{ 0x104018, 1, RI_ALL_ONLINE},
	{ 0x104020, 1, RI_ALL_ONLINE},
	{ 0x10403c, 1, RI_ALL_ONLINE},
	{ 0x1040fc, 1, RI_ALL_ONLINE},
	{ 0x10410c, 1, RI_ALL_ONLINE},
	{ 0x104400, 64, RI_ALL_ONLINE},
	{ 0x104800, 64, RI_ALL_ONLINE},
	{ 0x105000, 256, RI_ALL_ONLINE},
	{ 0x108094, 1, RI_E1E1H_ONLINE},
	{ 0x1201b0, 2, RI_ALL_ONLINE},
	{ 0x12032c, 1, RI_ALL_ONLINE},
	{ 0x12036c, 3, RI_ALL_ONLINE},
	{ 0x120408, 2, RI_ALL_ONLINE},
	{ 0x120414, 15, RI_ALL_ONLINE},
	{ 0x120478, 2, RI_ALL_ONLINE},
	{ 0x12052c, 1, RI_ALL_ONLINE},
	{ 0x120564, 3, RI_ALL_ONLINE},
	{ 0x12057c, 1, RI_ALL_ONLINE},
	{ 0x12058c, 1, RI_ALL_ONLINE},
	{ 0x120608, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x120778, 2, RI_E2E3E3B0_ONLINE},
	{ 0x120808, 3, RI_ALL_ONLINE},
	{ 0x120818, 1, RI_ALL_ONLINE},
	{ 0x120820, 1, RI_ALL_ONLINE},
	{ 0x120828, 1, RI_ALL_ONLINE},
	{ 0x120830, 1, RI_ALL_ONLINE},
	{ 0x120838, 1, RI_ALL_ONLINE},
	{ 0x120840, 1, RI_ALL_ONLINE},
	{ 0x120848, 1, RI_ALL_ONLINE},
	{ 0x120850, 1, RI_ALL_ONLINE},
	{ 0x120858, 1, RI_ALL_ONLINE},
	{ 0x120860, 1, RI_ALL_ONLINE},
	{ 0x120868, 1, RI_ALL_ONLINE},
	{ 0x120870, 1, RI_ALL_ONLINE},
	{ 0x120878, 1, RI_ALL_ONLINE},
	{ 0x120880, 1, RI_ALL_ONLINE},
	{ 0x120888, 1, RI_ALL_ONLINE},
	{ 0x120890, 1, RI_ALL_ONLINE},
	{ 0x120898, 1, RI_ALL_ONLINE},
	{ 0x1208a0, 1, RI_ALL_ONLINE},
	{ 0x1208a8, 1, RI_ALL_ONLINE},
	{ 0x1208b0, 1, RI_ALL_ONLINE},
	{ 0x1208b8, 1, RI_ALL_ONLINE},
	{ 0x1208c0, 1, RI_ALL_ONLINE},
	{ 0x1208c8, 1, RI_ALL_ONLINE},
	{ 0x1208d0, 1, RI_ALL_ONLINE},
	{ 0x1208d8, 1, RI_ALL_ONLINE},
	{ 0x1208e0, 1, RI_ALL_ONLINE},
	{ 0x1208e8, 1, RI_ALL_ONLINE},
	{ 0x1208f0, 1, RI_ALL_ONLINE},
	{ 0x1208f8, 1, RI_ALL_ONLINE},
	{ 0x120900, 1, RI_ALL_ONLINE},
	{ 0x120908, 1, RI_ALL_ONLINE},
	{ 0x130030, 1, RI_E2E3E3B0_ONLINE},
	{ 0x13004c, 3, RI_E2E3E3B0_ONLINE},
	{ 0x130064, 2, RI_E2E3E3B0_ONLINE},
	{ 0x13009c, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130130, 1, RI_E2E3E3B0_ONLINE},
	{ 0x13016c, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130300, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130480, 1, RI_E2E3E3B0_ONLINE},
	{ 0x14005c, 2, RI_E1E1HE2E3_ONLINE},
	{ 0x1400d0, 2, RI_E1E1HE2E3_ONLINE},
	{ 0x1400e0, 1, RI_E1E1HE2E3_ONLINE},
	{ 0x1401c8, 1, RI_E1E1HE2E3_ONLINE},
	{ 0x140200, 6, RI_E1E1HE2E3_ONLINE},
	{ 0x140338, 7, RI_E3B0_ONLINE},
	{ 0x140370, 7, RI_E3B0_ONLINE},
	{ 0x15c1bc, 6, RI_E3B0_ONLINE},
	{ 0x15c230, 7, RI_E3B0_ONLINE},
	{ 0x16101c, 1, RI_ALL_ONLINE},
	{ 0x16102c, 1, RI_ALL_ONLINE},
	{ 0x164014, 2, RI_ALL_ONLINE},
	{ 0x1640f0, 1, RI_ALL_ONLINE},
	{ 0x166290, 1, RI_ALL_ONLINE},
	{ 0x1662a0, 1, RI_ALL_ONLINE},
	{ 0x1662b0, 1, RI_ALL_ONLINE},
	{ 0x166548, 1, RI_ALL_ONLINE},
	{ 0x166550, 1, RI_ALL_ONLINE},
	{ 0x166558, 1, RI_ALL_ONLINE},
	{ 0x168000, 1, RI_ALL_ONLINE},
	{ 0x168008, 1, RI_ALL_ONLINE},
	{ 0x168010, 1, RI_ALL_ONLINE},
	{ 0x168018, 1, RI_ALL_ONLINE},
	{ 0x168028, 2, RI_ALL_ONLINE},
	{ 0x168058, 9, RI_ALL_ONLINE},
	{ 0x168238, 1, RI_ALL_ONLINE},
	{ 0x1682d0, 7, RI_ALL_ONLINE},
	{ 0x168300, 2, RI_E1E1H_ONLINE},
	{ 0x168308, 65, RI_ALL_ONLINE},
	{ 0x168410, 2, RI_ALL_ONLINE},
	{ 0x168438, 1, RI_ALL_ONLINE},
	{ 0x168448, 1, RI_ALL_ONLINE},
	{ 0x168a00, 128, RI_ALL_ONLINE},
	{ 0x16e200, 128, RI_E1H_ONLINE},
	{ 0x16e404, 2, RI_E1H_ONLINE},
	{ 0x16e584, 64, RI_E1H_ONLINE},
	{ 0x16e684, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16e68c, 4, RI_E1H_ONLINE},
	{ 0x16e6fc, 4, RI_E2E3E3B0_ONLINE},
	{ 0x16e7ac, 12, RI_E3B0_ONLINE},
	{ 0x1700a4, 1, RI_ALL_ONLINE},
	{ 0x1700ac, 2, RI_ALL_ONLINE},
	{ 0x1700c0, 1, RI_ALL_ONLINE},
	{ 0x170174, 1, RI_ALL_ONLINE},
	{ 0x170184, 1, RI_ALL_ONLINE},
	{ 0x1800f4, 1, RI_ALL_ONLINE},
	{ 0x180104, 1, RI_ALL_ONLINE},
	{ 0x180114, 1, RI_ALL_ONLINE},
	{ 0x180124, 1, RI_ALL_ONLINE},
	{ 0x18026c, 1, RI_ALL_ONLINE},
	{ 0x1802a0, 1, RI_ALL_ONLINE},
	{ 0x1b8000, 1, RI_ALL_ONLINE},
	{ 0x1b8040, 1, RI_ALL_ONLINE},
	{ 0x1b8080, 1, RI_ALL_ONLINE},
	{ 0x1b80c0, 1, RI_ALL_ONLINE},
	{ 0x200104, 1, RI_ALL_ONLINE},
	{ 0x200114, 1, RI_ALL_ONLINE},
	{ 0x200124, 1, RI_ALL_ONLINE},
	{ 0x200134, 1, RI_ALL_ONLINE},
	{ 0x20026c, 1, RI_ALL_ONLINE},
	{ 0x2002a0, 1, RI_ALL_ONLINE},
	{ 0x238000, 1, RI_ALL_ONLINE},
	{ 0x238040, 1, RI_ALL_ONLINE},
	{ 0x238080, 1, RI_ALL_ONLINE},
	{ 0x2380c0, 1, RI_ALL_ONLINE},
	{ 0x280104, 1, RI_ALL_ONLINE},
	{ 0x280114, 1, RI_ALL_ONLINE},
	{ 0x280124, 1, RI_ALL_ONLINE},
	{ 0x280134, 1, RI_ALL_ONLINE},
	{ 0x28026c, 1, RI_ALL_ONLINE},
	{ 0x2802a0, 1, RI_ALL_ONLINE},
	{ 0x2b8000, 1, RI_ALL_ONLINE},
	{ 0x2b8040, 1, RI_ALL_ONLINE},
	{ 0x2b8080, 1, RI_ALL_ONLINE},
	{ 0x300104, 1, RI_ALL_ONLINE},
	{ 0x300114, 1, RI_ALL_ONLINE},
	{ 0x300124, 1, RI_ALL_ONLINE},
	{ 0x300134, 1, RI_ALL_ONLINE},
	{ 0x30026c, 1, RI_ALL_ONLINE},
	{ 0x3002a0, 1, RI_ALL_ONLINE},
	{ 0x338000, 1, RI_ALL_ONLINE},
	{ 0x338040, 1, RI_ALL_ONLINE},
	{ 0x338080, 1, RI_ALL_ONLINE},
	{ 0x3380c0, 1, RI_ALL_ONLINE}
};

#define IDLE_REGS_COUNT ARRSIZE(idle_addrs)



static const struct reg_addr split_reg_addrs[] = {
	{ 0x2000, 341, RI_ALL_ONLINE},
	{ 0x2800, 103, RI_ALL_ONLINE},
	{ 0x3000, 287, RI_ALL_ONLINE},
	{ 0x3800, 331, RI_ALL_ONLINE},
	{ 0x942c, 4, RI_E2E3E3B0_ONLINE},
	{ 0x9454, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa270, 2, RI_ALL_ONLINE},
	{ 0xa408, 2, RI_ALL_ONLINE},
	{ 0xa580, 1, RI_ALL_ONLINE},
	{ 0xa590, 1, RI_ALL_ONLINE},
	{ 0xa78c, 1, RI_E2E3E3B0_ONLINE},
	{ 0xa858, 4, RI_E2E3E3B0_ONLINE},
	{ 0x10138, 34, RI_ALL_ONLINE},
	{ 0x10880, 2, RI_ALL_ONLINE},
	{ 0x10900, 2, RI_ALL_ONLINE},
	{ 0x160fc, 4, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16140, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16160, 1, RI_E1HE2E3E3B0_ONLINE},
	{ 0x16180, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x161c0, 2, RI_E1HE2E3E3B0_ONLINE},
	{ 0x180c8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18154, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18440, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18460, 1, RI_E2E3E3B0_ONLINE},
	{ 0x18480, 2, RI_E2E3E3B0_ONLINE},
	{ 0x184c0, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1866c, 4, RI_E3B0_ONLINE},
	{ 0x18a08, 4, RI_E3B0_ONLINE},
	{ 0x18a70, 20, RI_E3B0_ONLINE},
	{ 0x20100, 4, RI_ALL_ONLINE},
	{ 0x20118, 2, RI_ALL_ONLINE},
	{ 0x201c4, 12, RI_ALL_ONLINE},
	{ 0x40138, 1, RI_ALL_ONLINE},
	{ 0x40400, 2, RI_ALL_ONLINE},
	{ 0x40484, 4, RI_ALL_ONLINE},
	{ 0x404e0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x40500, 2, RI_ALL_ONLINE},
	{ 0x40510, 2, RI_ALL_ONLINE},
	{ 0x40520, 2, RI_ALL_ONLINE},
	{ 0x40530, 2, RI_ALL_ONLINE},
	{ 0x40540, 2, RI_ALL_ONLINE},
	{ 0x50000, 1, RI_ALL_ONLINE},
	{ 0x500e0, 8, RI_ALL_ONLINE},
	{ 0xd0114, 14, RI_ALL_ONLINE},
	{ 0xe0110, 8, RI_ALL_ONLINE},
	{ 0x10411c, 4, RI_E2E3E3B0_ONLINE},
	{ 0x104138, 1, RI_E2E3E3B0_ONLINE},
	{ 0x108018, 4, RI_E1E1H_ONLINE},
	{ 0x108038, 6, RI_E1E1H_ONLINE},
	{ 0x108058, 11, RI_E1E1H_ONLINE},
	{ 0x1080ac, 2, RI_E1H_ONLINE},
	{ 0x108100, 5, RI_E1E1H_ONLINE},
	{ 0x108120, 5, RI_E1E1H_ONLINE},
	{ 0x108200, 74, RI_E1E1H_ONLINE},
	{ 0x108400, 74, RI_E1E1H_ONLINE},
	{ 0x108800, 152, RI_E1E1H_ONLINE},
	{ 0x120534, 4, RI_ALL_ONLINE},
	{ 0x120544, 4, RI_E1E1H_ONLINE},
	{ 0x12061c, 20, RI_E1HE2E3E3B0_ONLINE},
	{ 0x1207d8, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130104, 4, RI_E2E3E3B0_ONLINE},
	{ 0x13011c, 5, RI_E2E3E3B0_ONLINE},
	{ 0x130134, 9, RI_E2E3E3B0_ONLINE},
	{ 0x13015c, 4, RI_E2E3E3B0_ONLINE},
	{ 0x130170, 1, RI_E2E3E3B0_ONLINE},
	{ 0x130180, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1402e8, 2, RI_E2E3E3B0_ONLINE},
	{ 0x164014, 2, RI_ALL_ONLINE},
	{ 0x1640d0, 2, RI_ALL_ONLINE},
	{ 0x164128, 2, RI_E2E3E3B0_ONLINE},
	{ 0x16e70c, 1, RI_E2E3E3B0_ONLINE},
	{ 0x170198, 5, RI_E2E3E3B0_ONLINE},
	{ 0x1701b8, 2, RI_E2E3E3B0_ONLINE},
	{ 0x1701d0, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1701e4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1701ec, 1, RI_E2E3E3B0_ONLINE},
	{ 0x1701f4, 1, RI_E2E3E3B0_ONLINE},
	{ 0x170320, 3, RI_E2E3E3B0_ONLINE},
	{ 0x170330, 2, RI_E2E3E3B0_ONLINE},
	{ 0x170340, 1, RI_E2E3E3B0_ONLINE}
};


#define SPLIT_REGS_COUNT ARRSIZE(split_reg_addrs)



static const u32 read_reg_e1_0[] = { 0x1b1000};


static const struct wreg_addr wreg_addrs_e1[] = {
	{ 0x1b0c00, 192, 1, read_reg_e1_0, RI_E1_OFFLINE}
};
#define WREGS_COUNT_E1 ARRSIZE(wreg_addrs_e1)


static const u32 read_reg_e1h_0[] = { 0x1b1040, 0x1b1000};


static const struct wreg_addr wreg_addrs_e1h[] = {
	{ 0x1b0c00, 256, 2, read_reg_e1h_0, RI_E1H_OFFLINE}
};

#define WREGS_COUNT_E1H ARRSIZE(wreg_addrs_e1h)


static const u32 read_reg_e2_0[] = { 0x1b1040, 0x1b1000};


static const struct wreg_addr wreg_addrs_e2[] = {
	{ 0x1b0c00, 128, 2, read_reg_e2_0, RI_E2_OFFLINE}
};

#define WREGS_COUNT_E2 ARRSIZE(wreg_addrs_e2)



static const u32 read_reg_e3_0[] = { 0x1b1040, 0x1b1000};


static const struct wreg_addr wreg_addrs_e3[] = {
	{ 0x1b0c00, 128, 2, read_reg_e3_0, RI_E3_OFFLINE}
};

#define WREGS_COUNT_E3 ARRSIZE(wreg_addrs_e3)

static const u32 read_reg_e3b0_0[] = { 0x1b1040, 0x1b1000};


static const struct wreg_addr wreg_addrs_e3b0[] = {
	{ 0x1b0c00, 128, 2, read_reg_e3b0_0, RI_E3B0_OFFLINE}
};

#define WREGS_COUNT_E3B0 ARRSIZE(wreg_addrs_e3b0)

#endif
/* The struct hold a signature to ensure the dump returned from the driver
	match the meta data file inserted to grc_dump.tcl
	The signature is time stamp,diag version and grc_dump version*/

static const struct hd_param hd_param_all = {0x4f0ae30c, 0x70038, 0x3a};

#ifndef ECORE_UPSTREAM /* ! ECORE_UPSTREAM */




static const u32 timer_status_regs_e1[] = { 0x164014, 0x164018};
static const u32 timer_scan_regs_e1[] = { 0x1640d0, 0x1640d4};

#define TIMER_REGS_COUNT_E1 ARRSIZE(timer_status_regs_e1)

static const struct vfc_general vfc_general_x_e1 = { 0, 0, 0, 0, 0};
static const struct vfc_general vfc_general_t_e1 = { 0, 0, 0, 0, 0};



static const struct igu_data igu_address_e1 = { 0, 0, 0, 0, { 0, 0} };



static const u32 timer_status_regs_e1h[] = { 0x164014, 0x164018};
static const u32 timer_scan_regs_e1h[] = { 0x1640d0, 0x1640d4};

#define TIMER_REGS_COUNT_E1H ARRSIZE(timer_status_regs_e1h)

static const struct vfc_general vfc_general_x_e1h = { 0, 0, 0, 0, 0};
static const struct vfc_general vfc_general_t_e1h = { 0, 0, 0, 0, 0};



static const struct igu_data igu_address_e1h = { 0, 0, 0, 0, { 0, 0} };






static const u32 timer_status_regs_e2[] = { 0x164014, 0x164018};
static const u32 timer_scan_regs_e2[] = { 0x1640d0, 0x1640d4};

#define TIMER_REGS_COUNT_E2 ARRSIZE(timer_status_regs_e2)

static const struct vfc_general vfc_general_x_e2 = {
	1, 0x2b8fd0, 0x2b8fc8, 0x2b8fc4, 0x2b8fcc
};
static const struct vfc_general vfc_general_t_e2 = {
	1, 0x1b8fd0, 0x1b8fc8, 0x1b8fc4, 0x1b8fcc
};
static const struct vfc_read_write_vector vfc_vectors_t_e2[1049] = {
	{ 4, 0, 0, {0,0}}
	, { 4, 4, 0, {0,0}}
	, { 4, 8, 0, {0,0}}
	, { 4, 12, 0, {0,0}}
	, { 4, 16, 0, {0,0}}
	, { 4, 20, 0, {0,0}}
	, { 4, 24, 0, {0,0}}
	, { 4, 28, 0, {0,0}}
	, { 4, 32, 0, {0,0}}
	, { 4, 36, 0, {0,0}}
	, { 4, 40, 0, {0,0}}
	, { 4, 44, 0, {0,0}}
	, { 4, 48, 0, {0,0}}
	, { 4, 52, 0, {0,0}}
	, { 4, 56, 0, {0,0}}
	, { 4, 60, 0, {0,0}}
	, { 4, 64, 0, {0,0}}
	, { 4, 68, 0, {0,0}}
	, { 4, 72, 0, {0,0}}
	, { 4, 76, 0, {0,0}}
	, { 4, 80, 0, {0,0}}
	, { 4, 84, 0, {0,0}}
	, { 4, 88, 0, {0,0}}
	, { 4, 92, 0, {0,0}}
	, { 4, 96, 0, {0,0}}
	, { 4, 100, 0, {0,0}}
	, { 4, 104, 0, {0,0}}
	, { 4, 108, 0, {0,0}}
	, { 4, 112, 0, {0,0}}
	, { 4, 116, 0, {0,0}}
	, { 4, 120, 0, {0,0}}
	, { 4, 124, 0, {0,0}}
	, { 4, 128, 0, {0,0}}
	, { 4, 132, 0, {0,0}}
	, { 4, 136, 0, {0,0}}
	, { 4, 140, 0, {0,0}}
	, { 4, 144, 0, {0,0}}
	, { 4, 148, 0, {0,0}}
	, { 4, 152, 0, {0,0}}
	, { 4, 156, 0, {0,0}}
	, { 4, 160, 0, {0,0}}
	, { 4, 164, 0, {0,0}}
	, { 4, 168, 0, {0,0}}
	, { 4, 172, 0, {0,0}}
	, { 4, 176, 0, {0,0}}
	, { 4, 180, 0, {0,0}}
	, { 4, 184, 0, {0,0}}
	, { 4, 188, 0, {0,0}}
	, { 4, 192, 0, {0,0}}
	, { 4, 196, 0, {0,0}}
	, { 4, 200, 0, {0,0}}
	, { 4, 204, 0, {0,0}}
	, { 4, 208, 0, {0,0}}
	, { 4, 212, 0, {0,0}}
	, { 4, 216, 0, {0,0}}
	, { 4, 220, 0, {0,0}}
	, { 4, 224, 0, {0,0}}
	, { 4, 228, 0, {0,0}}
	, { 4, 232, 0, {0,0}}
	, { 4, 236, 0, {0,0}}
	, { 4, 240, 0, {0,0}}
	, { 4, 244, 0, {0,0}}
	, { 4, 248, 0, {0,0}}
	, { 4, 252, 0, {0,0}}
	, { 4, 256, 0, {0,0}}
	, { 4, 260, 0, {0,0}}
	, { 4, 264, 0, {0,0}}
	, { 4, 268, 0, {0,0}}
	, { 4, 272, 0, {0,0}}
	, { 4, 276, 0, {0,0}}
	, { 4, 280, 0, {0,0}}
	, { 4, 284, 0, {0,0}}
	, { 4, 288, 0, {0,0}}
	, { 4, 292, 0, {0,0}}
	, { 4, 296, 0, {0,0}}
	, { 4, 300, 0, {0,0}}
	, { 4, 304, 0, {0,0}}
	, { 4, 308, 0, {0,0}}
	, { 4, 312, 0, {0,0}}
	, { 4, 316, 0, {0,0}}
	, { 4, 320, 0, {0,0}}
	, { 4, 324, 0, {0,0}}
	, { 4, 328, 0, {0,0}}
	, { 4, 332, 0, {0,0}}
	, { 4, 336, 0, {0,0}}
	, { 4, 340, 0, {0,0}}
	, { 4, 344, 0, {0,0}}
	, { 4, 348, 0, {0,0}}
	, { 4, 352, 0, {0,0}}
	, { 4, 356, 0, {0,0}}
	, { 4, 360, 0, {0,0}}
	, { 4, 364, 0, {0,0}}
	, { 4, 368, 0, {0,0}}
	, { 4, 372, 0, {0,0}}
	, { 4, 376, 0, {0,0}}
	, { 4, 380, 0, {0,0}}
	, { 4, 384, 0, {0,0}}
	, { 4, 388, 0, {0,0}}
	, { 4, 392, 0, {0,0}}
	, { 4, 396, 0, {0,0}}
	, { 4, 400, 0, {0,0}}
	, { 4, 404, 0, {0,0}}
	, { 4, 408, 0, {0,0}}
	, { 4, 412, 0, {0,0}}
	, { 4, 416, 0, {0,0}}
	, { 4, 420, 0, {0,0}}
	, { 4, 424, 0, {0,0}}
	, { 4, 428, 0, {0,0}}
	, { 4, 432, 0, {0,0}}
	, { 4, 436, 0, {0,0}}
	, { 4, 440, 0, {0,0}}
	, { 4, 444, 0, {0,0}}
	, { 4, 448, 0, {0,0}}
	, { 4, 452, 0, {0,0}}
	, { 4, 456, 0, {0,0}}
	, { 4, 460, 0, {0,0}}
	, { 4, 464, 0, {0,0}}
	, { 4, 468, 0, {0,0}}
	, { 4, 472, 0, {0,0}}
	, { 4, 476, 0, {0,0}}
	, { 4, 480, 0, {0,0}}
	, { 4, 484, 0, {0,0}}
	, { 4, 488, 0, {0,0}}
	, { 4, 492, 0, {0,0}}
	, { 4, 496, 0, {0,0}}
	, { 4, 500, 0, {0,0}}
	, { 4, 504, 0, {0,0}}
	, { 4, 508, 0, {0,0}}
	, { 4, 512, 0, {0,0}}
	, { 4, 516, 0, {0,0}}
	, { 4, 520, 0, {0,0}}
	, { 4, 524, 0, {0,0}}
	, { 4, 528, 0, {0,0}}
	, { 4, 532, 0, {0,0}}
	, { 4, 536, 0, {0,0}}
	, { 4, 540, 0, {0,0}}
	, { 4, 544, 0, {0,0}}
	, { 4, 548, 0, {0,0}}
	, { 4, 552, 0, {0,0}}
	, { 4, 556, 0, {0,0}}
	, { 4, 560, 0, {0,0}}
	, { 4, 564, 0, {0,0}}
	, { 4, 568, 0, {0,0}}
	, { 4, 572, 0, {0,0}}
	, { 4, 576, 0, {0,0}}
	, { 4, 580, 0, {0,0}}
	, { 4, 584, 0, {0,0}}
	, { 4, 588, 0, {0,0}}
	, { 4, 592, 0, {0,0}}
	, { 4, 596, 0, {0,0}}
	, { 4, 600, 0, {0,0}}
	, { 4, 604, 0, {0,0}}
	, { 4, 608, 0, {0,0}}
	, { 4, 612, 0, {0,0}}
	, { 4, 616, 0, {0,0}}
	, { 4, 620, 0, {0,0}}
	, { 4, 624, 0, {0,0}}
	, { 4, 628, 0, {0,0}}
	, { 4, 632, 0, {0,0}}
	, { 4, 636, 0, {0,0}}
	, { 4, 640, 0, {0,0}}
	, { 4, 644, 0, {0,0}}
	, { 4, 648, 0, {0,0}}
	, { 4, 652, 0, {0,0}}
	, { 4, 656, 0, {0,0}}
	, { 4, 660, 0, {0,0}}
	, { 4, 664, 0, {0,0}}
	, { 4, 668, 0, {0,0}}
	, { 4, 672, 0, {0,0}}
	, { 4, 676, 0, {0,0}}
	, { 4, 680, 0, {0,0}}
	, { 4, 684, 0, {0,0}}
	, { 4, 688, 0, {0,0}}
	, { 4, 692, 0, {0,0}}
	, { 4, 696, 0, {0,0}}
	, { 4, 700, 0, {0,0}}
	, { 4, 704, 0, {0,0}}
	, { 4, 708, 0, {0,0}}
	, { 4, 712, 0, {0,0}}
	, { 4, 716, 0, {0,0}}
	, { 4, 720, 0, {0,0}}
	, { 4, 724, 0, {0,0}}
	, { 4, 728, 0, {0,0}}
	, { 4, 732, 0, {0,0}}
	, { 4, 736, 0, {0,0}}
	, { 4, 740, 0, {0,0}}
	, { 4, 744, 0, {0,0}}
	, { 4, 748, 0, {0,0}}
	, { 4, 752, 0, {0,0}}
	, { 4, 756, 0, {0,0}}
	, { 4, 760, 0, {0,0}}
	, { 4, 764, 0, {0,0}}
	, { 4, 768, 0, {0,0}}
	, { 4, 772, 0, {0,0}}
	, { 4, 776, 0, {0,0}}
	, { 4, 780, 0, {0,0}}
	, { 4, 784, 0, {0,0}}
	, { 4, 788, 0, {0,0}}
	, { 4, 792, 0, {0,0}}
	, { 4, 796, 0, {0,0}}
	, { 4, 800, 0, {0,0}}
	, { 4, 804, 0, {0,0}}
	, { 4, 808, 0, {0,0}}
	, { 4, 812, 0, {0,0}}
	, { 4, 816, 0, {0,0}}
	, { 4, 820, 0, {0,0}}
	, { 4, 824, 0, {0,0}}
	, { 4, 828, 0, {0,0}}
	, { 4, 832, 0, {0,0}}
	, { 4, 836, 0, {0,0}}
	, { 4, 840, 0, {0,0}}
	, { 4, 844, 0, {0,0}}
	, { 4, 848, 0, {0,0}}
	, { 4, 852, 0, {0,0}}
	, { 4, 856, 0, {0,0}}
	, { 4, 860, 0, {0,0}}
	, { 4, 864, 0, {0,0}}
	, { 4, 868, 0, {0,0}}
	, { 4, 872, 0, {0,0}}
	, { 4, 876, 0, {0,0}}
	, { 4, 880, 0, {0,0}}
	, { 4, 884, 0, {0,0}}
	, { 4, 888, 0, {0,0}}
	, { 4, 892, 0, {0,0}}
	, { 4, 896, 0, {0,0}}
	, { 4, 900, 0, {0,0}}
	, { 4, 904, 0, {0,0}}
	, { 4, 908, 0, {0,0}}
	, { 4, 912, 0, {0,0}}
	, { 4, 916, 0, {0,0}}
	, { 4, 920, 0, {0,0}}
	, { 4, 924, 0, {0,0}}
	, { 4, 928, 0, {0,0}}
	, { 4, 932, 0, {0,0}}
	, { 4, 936, 0, {0,0}}
	, { 4, 940, 0, {0,0}}
	, { 4, 944, 0, {0,0}}
	, { 4, 948, 0, {0,0}}
	, { 4, 952, 0, {0,0}}
	, { 4, 956, 0, {0,0}}
	, { 4, 960, 0, {0,0}}
	, { 4, 964, 0, {0,0}}
	, { 4, 968, 0, {0,0}}
	, { 4, 972, 0, {0,0}}
	, { 4, 976, 0, {0,0}}
	, { 4, 980, 0, {0,0}}
	, { 4, 984, 0, {0,0}}
	, { 4, 988, 0, {0,0}}
	, { 4, 992, 0, {0,0}}
	, { 4, 996, 0, {0,0}}
	, { 4, 1000, 0, {0,0}}
	, { 4, 1004, 0, {0,0}}
	, { 4, 1008, 0, {0,0}}
	, { 4, 1012, 0, {0,0}}
	, { 4, 1016, 0, {0,0}}
	, { 4, 1020, 0, {0,0}}
	, { 4, 1024, 0, {0,0}}
	, { 4, 1028, 0, {0,0}}
	, { 4, 1032, 0, {0,0}}
	, { 4, 1036, 0, {0,0}}
	, { 4, 1040, 0, {0,0}}
	, { 4, 1044, 0, {0,0}}
	, { 4, 1048, 0, {0,0}}
	, { 4, 1052, 0, {0,0}}
	, { 4, 1056, 0, {0,0}}
	, { 4, 1060, 0, {0,0}}
	, { 4, 1064, 0, {0,0}}
	, { 4, 1068, 0, {0,0}}
	, { 4, 1072, 0, {0,0}}
	, { 4, 1076, 0, {0,0}}
	, { 4, 1080, 0, {0,0}}
	, { 4, 1084, 0, {0,0}}
	, { 4, 1088, 0, {0,0}}
	, { 4, 1092, 0, {0,0}}
	, { 4, 1096, 0, {0,0}}
	, { 4, 1100, 0, {0,0}}
	, { 4, 1104, 0, {0,0}}
	, { 4, 1108, 0, {0,0}}
	, { 4, 1112, 0, {0,0}}
	, { 4, 1116, 0, {0,0}}
	, { 4, 1120, 0, {0,0}}
	, { 4, 1124, 0, {0,0}}
	, { 4, 1128, 0, {0,0}}
	, { 4, 1132, 0, {0,0}}
	, { 4, 1136, 0, {0,0}}
	, { 4, 1140, 0, {0,0}}
	, { 4, 1144, 0, {0,0}}
	, { 4, 1148, 0, {0,0}}
	, { 4, 1152, 0, {0,0}}
	, { 4, 1156, 0, {0,0}}
	, { 4, 1160, 0, {0,0}}
	, { 4, 1164, 0, {0,0}}
	, { 4, 1168, 0, {0,0}}
	, { 4, 1172, 0, {0,0}}
	, { 4, 1176, 0, {0,0}}
	, { 4, 1180, 0, {0,0}}
	, { 4, 1184, 0, {0,0}}
	, { 4, 1188, 0, {0,0}}
	, { 4, 1192, 0, {0,0}}
	, { 4, 1196, 0, {0,0}}
	, { 4, 1200, 0, {0,0}}
	, { 4, 1204, 0, {0,0}}
	, { 4, 1208, 0, {0,0}}
	, { 4, 1212, 0, {0,0}}
	, { 4, 1216, 0, {0,0}}
	, { 4, 1220, 0, {0,0}}
	, { 4, 1224, 0, {0,0}}
	, { 4, 1228, 0, {0,0}}
	, { 4, 1232, 0, {0,0}}
	, { 4, 1236, 0, {0,0}}
	, { 4, 1240, 0, {0,0}}
	, { 4, 1244, 0, {0,0}}
	, { 4, 1248, 0, {0,0}}
	, { 4, 1252, 0, {0,0}}
	, { 4, 1256, 0, {0,0}}
	, { 4, 1260, 0, {0,0}}
	, { 4, 1264, 0, {0,0}}
	, { 4, 1268, 0, {0,0}}
	, { 4, 1272, 0, {0,0}}
	, { 4, 1276, 0, {0,0}}
	, { 4, 1280, 0, {0,0}}
	, { 4, 1284, 0, {0,0}}
	, { 4, 1288, 0, {0,0}}
	, { 4, 1292, 0, {0,0}}
	, { 4, 1296, 0, {0,0}}
	, { 4, 1300, 0, {0,0}}
	, { 4, 1304, 0, {0,0}}
	, { 4, 1308, 0, {0,0}}
	, { 4, 1312, 0, {0,0}}
	, { 4, 1316, 0, {0,0}}
	, { 4, 1320, 0, {0,0}}
	, { 4, 1324, 0, {0,0}}
	, { 4, 1328, 0, {0,0}}
	, { 4, 1332, 0, {0,0}}
	, { 4, 1336, 0, {0,0}}
	, { 4, 1340, 0, {0,0}}
	, { 4, 1344, 0, {0,0}}
	, { 4, 1348, 0, {0,0}}
	, { 4, 1352, 0, {0,0}}
	, { 4, 1356, 0, {0,0}}
	, { 4, 1360, 0, {0,0}}
	, { 4, 1364, 0, {0,0}}
	, { 4, 1368, 0, {0,0}}
	, { 4, 1372, 0, {0,0}}
	, { 4, 1376, 0, {0,0}}
	, { 4, 1380, 0, {0,0}}
	, { 4, 1384, 0, {0,0}}
	, { 4, 1388, 0, {0,0}}
	, { 4, 1392, 0, {0,0}}
	, { 4, 1396, 0, {0,0}}
	, { 4, 1400, 0, {0,0}}
	, { 4, 1404, 0, {0,0}}
	, { 4, 1408, 0, {0,0}}
	, { 4, 1412, 0, {0,0}}
	, { 4, 1416, 0, {0,0}}
	, { 4, 1420, 0, {0,0}}
	, { 4, 1424, 0, {0,0}}
	, { 4, 1428, 0, {0,0}}
	, { 4, 1432, 0, {0,0}}
	, { 4, 1436, 0, {0,0}}
	, { 4, 1440, 0, {0,0}}
	, { 4, 1444, 0, {0,0}}
	, { 4, 1448, 0, {0,0}}
	, { 4, 1452, 0, {0,0}}
	, { 4, 1456, 0, {0,0}}
	, { 4, 1460, 0, {0,0}}
	, { 4, 1464, 0, {0,0}}
	, { 4, 1468, 0, {0,0}}
	, { 4, 1472, 0, {0,0}}
	, { 4, 1476, 0, {0,0}}
	, { 4, 1480, 0, {0,0}}
	, { 4, 1484, 0, {0,0}}
	, { 4, 1488, 0, {0,0}}
	, { 4, 1492, 0, {0,0}}
	, { 4, 1496, 0, {0,0}}
	, { 4, 1500, 0, {0,0}}
	, { 4, 1504, 0, {0,0}}
	, { 4, 1508, 0, {0,0}}
	, { 4, 1512, 0, {0,0}}
	, { 4, 1516, 0, {0,0}}
	, { 4, 1520, 0, {0,0}}
	, { 4, 1524, 0, {0,0}}
	, { 4, 1528, 0, {0,0}}
	, { 4, 1532, 0, {0,0}}
	, { 4, 1536, 0, {0,0}}
	, { 4, 1540, 0, {0,0}}
	, { 4, 1544, 0, {0,0}}
	, { 4, 1548, 0, {0,0}}
	, { 4, 1552, 0, {0,0}}
	, { 4, 1556, 0, {0,0}}
	, { 4, 1560, 0, {0,0}}
	, { 4, 1564, 0, {0,0}}
	, { 4, 1568, 0, {0,0}}
	, { 4, 1572, 0, {0,0}}
	, { 4, 1576, 0, {0,0}}
	, { 4, 1580, 0, {0,0}}
	, { 4, 1584, 0, {0,0}}
	, { 4, 1588, 0, {0,0}}
	, { 4, 1592, 0, {0,0}}
	, { 4, 1596, 0, {0,0}}
	, { 4, 1600, 0, {0,0}}
	, { 4, 1604, 0, {0,0}}
	, { 4, 1608, 0, {0,0}}
	, { 4, 1612, 0, {0,0}}
	, { 4, 1616, 0, {0,0}}
	, { 4, 1620, 0, {0,0}}
	, { 4, 1624, 0, {0,0}}
	, { 4, 1628, 0, {0,0}}
	, { 4, 1632, 0, {0,0}}
	, { 4, 1636, 0, {0,0}}
	, { 4, 1640, 0, {0,0}}
	, { 4, 1644, 0, {0,0}}
	, { 4, 1648, 0, {0,0}}
	, { 4, 1652, 0, {0,0}}
	, { 4, 1656, 0, {0,0}}
	, { 4, 1660, 0, {0,0}}
	, { 4, 1664, 0, {0,0}}
	, { 4, 1668, 0, {0,0}}
	, { 4, 1672, 0, {0,0}}
	, { 4, 1676, 0, {0,0}}
	, { 4, 1680, 0, {0,0}}
	, { 4, 1684, 0, {0,0}}
	, { 4, 1688, 0, {0,0}}
	, { 4, 1692, 0, {0,0}}
	, { 4, 1696, 0, {0,0}}
	, { 4, 1700, 0, {0,0}}
	, { 4, 1704, 0, {0,0}}
	, { 4, 1708, 0, {0,0}}
	, { 4, 1712, 0, {0,0}}
	, { 4, 1716, 0, {0,0}}
	, { 4, 1720, 0, {0,0}}
	, { 4, 1724, 0, {0,0}}
	, { 4, 1728, 0, {0,0}}
	, { 4, 1732, 0, {0,0}}
	, { 4, 1736, 0, {0,0}}
	, { 4, 1740, 0, {0,0}}
	, { 4, 1744, 0, {0,0}}
	, { 4, 1748, 0, {0,0}}
	, { 4, 1752, 0, {0,0}}
	, { 4, 1756, 0, {0,0}}
	, { 4, 1760, 0, {0,0}}
	, { 4, 1764, 0, {0,0}}
	, { 4, 1768, 0, {0,0}}
	, { 4, 1772, 0, {0,0}}
	, { 4, 1776, 0, {0,0}}
	, { 4, 1780, 0, {0,0}}
	, { 4, 1784, 0, {0,0}}
	, { 4, 1788, 0, {0,0}}
	, { 4, 1792, 0, {0,0}}
	, { 4, 1796, 0, {0,0}}
	, { 4, 1800, 0, {0,0}}
	, { 4, 1804, 0, {0,0}}
	, { 4, 1808, 0, {0,0}}
	, { 4, 1812, 0, {0,0}}
	, { 4, 1816, 0, {0,0}}
	, { 4, 1820, 0, {0,0}}
	, { 4, 1824, 0, {0,0}}
	, { 4, 1828, 0, {0,0}}
	, { 4, 1832, 0, {0,0}}
	, { 4, 1836, 0, {0,0}}
	, { 4, 1840, 0, {0,0}}
	, { 4, 1844, 0, {0,0}}
	, { 4, 1848, 0, {0,0}}
	, { 4, 1852, 0, {0,0}}
	, { 4, 1856, 0, {0,0}}
	, { 4, 1860, 0, {0,0}}
	, { 4, 1864, 0, {0,0}}
	, { 4, 1868, 0, {0,0}}
	, { 4, 1872, 0, {0,0}}
	, { 4, 1876, 0, {0,0}}
	, { 4, 1880, 0, {0,0}}
	, { 4, 1884, 0, {0,0}}
	, { 4, 1888, 0, {0,0}}
	, { 4, 1892, 0, {0,0}}
	, { 4, 1896, 0, {0,0}}
	, { 4, 1900, 0, {0,0}}
	, { 4, 1904, 0, {0,0}}
	, { 4, 1908, 0, {0,0}}
	, { 4, 1912, 0, {0,0}}
	, { 4, 1916, 0, {0,0}}
	, { 4, 1920, 0, {0,0}}
	, { 4, 1924, 0, {0,0}}
	, { 4, 1928, 0, {0,0}}
	, { 4, 1932, 0, {0,0}}
	, { 4, 1936, 0, {0,0}}
	, { 4, 1940, 0, {0,0}}
	, { 4, 1944, 0, {0,0}}
	, { 4, 1948, 0, {0,0}}
	, { 4, 1952, 0, {0,0}}
	, { 4, 1956, 0, {0,0}}
	, { 4, 1960, 0, {0,0}}
	, { 4, 1964, 0, {0,0}}
	, { 4, 1968, 0, {0,0}}
	, { 4, 1972, 0, {0,0}}
	, { 4, 1976, 0, {0,0}}
	, { 4, 1980, 0, {0,0}}
	, { 4, 1984, 0, {0,0}}
	, { 4, 1988, 0, {0,0}}
	, { 4, 1992, 0, {0,0}}
	, { 4, 1996, 0, {0,0}}
	, { 4, 2000, 0, {0,0}}
	, { 4, 2004, 0, {0,0}}
	, { 4, 2008, 0, {0,0}}
	, { 4, 2012, 0, {0,0}}
	, { 4, 2016, 0, {0,0}}
	, { 4, 2020, 0, {0,0}}
	, { 4, 2024, 0, {0,0}}
	, { 4, 2028, 0, {0,0}}
	, { 4, 2032, 0, {0,0}}
	, { 4, 2036, 0, {0,0}}
	, { 4, 2040, 0, {0,0}}
	, { 4, 2044, 0, {0,0}}
	, { 4, 2048, 0, {0,0}}
	, { 4, 2052, 0, {0,0}}
	, { 4, 2056, 0, {0,0}}
	, { 4, 2060, 0, {0,0}}
	, { 4, 2064, 0, {0,0}}
	, { 4, 2068, 0, {0,0}}
	, { 4, 2072, 0, {0,0}}
	, { 4, 2076, 0, {0,0}}
	, { 4, 2080, 0, {0,0}}
	, { 4, 2084, 0, {0,0}}
	, { 4, 2088, 0, {0,0}}
	, { 4, 2092, 0, {0,0}}
	, { 4, 2096, 0, {0,0}}
	, { 4, 2100, 0, {0,0}}
	, { 4, 2104, 0, {0,0}}
	, { 4, 2108, 0, {0,0}}
	, { 4, 2112, 0, {0,0}}
	, { 4, 2116, 0, {0,0}}
	, { 4, 2120, 0, {0,0}}
	, { 4, 2124, 0, {0,0}}
	, { 4, 2128, 0, {0,0}}
	, { 4, 2132, 0, {0,0}}
	, { 4, 2136, 0, {0,0}}
	, { 4, 2140, 0, {0,0}}
	, { 4, 2144, 0, {0,0}}
	, { 4, 2148, 0, {0,0}}
	, { 4, 2152, 0, {0,0}}
	, { 4, 2156, 0, {0,0}}
	, { 4, 2160, 0, {0,0}}
	, { 4, 2164, 0, {0,0}}
	, { 4, 2168, 0, {0,0}}
	, { 4, 2172, 0, {0,0}}
	, { 4, 2176, 0, {0,0}}
	, { 4, 2180, 0, {0,0}}
	, { 4, 2184, 0, {0,0}}
	, { 4, 2188, 0, {0,0}}
	, { 4, 2192, 0, {0,0}}
	, { 4, 2196, 0, {0,0}}
	, { 4, 2200, 0, {0,0}}
	, { 4, 2204, 0, {0,0}}
	, { 4, 2208, 0, {0,0}}
	, { 4, 2212, 0, {0,0}}
	, { 4, 2216, 0, {0,0}}
	, { 4, 2220, 0, {0,0}}
	, { 4, 2224, 0, {0,0}}
	, { 4, 2228, 0, {0,0}}
	, { 4, 2232, 0, {0,0}}
	, { 4, 2236, 0, {0,0}}
	, { 4, 2240, 0, {0,0}}
	, { 4, 2244, 0, {0,0}}
	, { 4, 2248, 0, {0,0}}
	, { 4, 2252, 0, {0,0}}
	, { 4, 2256, 0, {0,0}}
	, { 4, 2260, 0, {0,0}}
	, { 4, 2264, 0, {0,0}}
	, { 4, 2268, 0, {0,0}}
	, { 4, 2272, 0, {0,0}}
	, { 4, 2276, 0, {0,0}}
	, { 4, 2280, 0, {0,0}}
	, { 4, 2284, 0, {0,0}}
	, { 4, 2288, 0, {0,0}}
	, { 4, 2292, 0, {0,0}}
	, { 4, 2296, 0, {0,0}}
	, { 4, 2300, 0, {0,0}}
	, { 4, 2304, 0, {0,0}}
	, { 4, 2308, 0, {0,0}}
	, { 4, 2312, 0, {0,0}}
	, { 4, 2316, 0, {0,0}}
	, { 4, 2320, 0, {0,0}}
	, { 4, 2324, 0, {0,0}}
	, { 4, 2328, 0, {0,0}}
	, { 4, 2332, 0, {0,0}}
	, { 4, 2336, 0, {0,0}}
	, { 4, 2340, 0, {0,0}}
	, { 4, 2344, 0, {0,0}}
	, { 4, 2348, 0, {0,0}}
	, { 4, 2352, 0, {0,0}}
	, { 4, 2356, 0, {0,0}}
	, { 4, 2360, 0, {0,0}}
	, { 4, 2364, 0, {0,0}}
	, { 4, 2368, 0, {0,0}}
	, { 4, 2372, 0, {0,0}}
	, { 4, 2376, 0, {0,0}}
	, { 4, 2380, 0, {0,0}}
	, { 4, 2384, 0, {0,0}}
	, { 4, 2388, 0, {0,0}}
	, { 4, 2392, 0, {0,0}}
	, { 4, 2396, 0, {0,0}}
	, { 4, 2400, 0, {0,0}}
	, { 4, 2404, 0, {0,0}}
	, { 4, 2408, 0, {0,0}}
	, { 4, 2412, 0, {0,0}}
	, { 4, 2416, 0, {0,0}}
	, { 4, 2420, 0, {0,0}}
	, { 4, 2424, 0, {0,0}}
	, { 4, 2428, 0, {0,0}}
	, { 4, 2432, 0, {0,0}}
	, { 4, 2436, 0, {0,0}}
	, { 4, 2440, 0, {0,0}}
	, { 4, 2444, 0, {0,0}}
	, { 4, 2448, 0, {0,0}}
	, { 4, 2452, 0, {0,0}}
	, { 4, 2456, 0, {0,0}}
	, { 4, 2460, 0, {0,0}}
	, { 4, 2464, 0, {0,0}}
	, { 4, 2468, 0, {0,0}}
	, { 4, 2472, 0, {0,0}}
	, { 4, 2476, 0, {0,0}}
	, { 4, 2480, 0, {0,0}}
	, { 4, 2484, 0, {0,0}}
	, { 4, 2488, 0, {0,0}}
	, { 4, 2492, 0, {0,0}}
	, { 4, 2496, 0, {0,0}}
	, { 4, 2500, 0, {0,0}}
	, { 4, 2504, 0, {0,0}}
	, { 4, 2508, 0, {0,0}}
	, { 4, 2512, 0, {0,0}}
	, { 4, 2516, 0, {0,0}}
	, { 4, 2520, 0, {0,0}}
	, { 4, 2524, 0, {0,0}}
	, { 4, 2528, 0, {0,0}}
	, { 4, 2532, 0, {0,0}}
	, { 4, 2536, 0, {0,0}}
	, { 4, 2540, 0, {0,0}}
	, { 4, 2544, 0, {0,0}}
	, { 4, 2548, 0, {0,0}}
	, { 4, 2552, 0, {0,0}}
	, { 4, 2556, 0, {0,0}}
	, { 4, 2560, 0, {0,0}}
	, { 4, 2564, 0, {0,0}}
	, { 4, 2568, 0, {0,0}}
	, { 4, 2572, 0, {0,0}}
	, { 4, 2576, 0, {0,0}}
	, { 4, 2580, 0, {0,0}}
	, { 4, 2584, 0, {0,0}}
	, { 4, 2588, 0, {0,0}}
	, { 4, 2592, 0, {0,0}}
	, { 4, 2596, 0, {0,0}}
	, { 4, 2600, 0, {0,0}}
	, { 4, 2604, 0, {0,0}}
	, { 4, 2608, 0, {0,0}}
	, { 4, 2612, 0, {0,0}}
	, { 4, 2616, 0, {0,0}}
	, { 4, 2620, 0, {0,0}}
	, { 4, 2624, 0, {0,0}}
	, { 4, 2628, 0, {0,0}}
	, { 4, 2632, 0, {0,0}}
	, { 4, 2636, 0, {0,0}}
	, { 4, 2640, 0, {0,0}}
	, { 4, 2644, 0, {0,0}}
	, { 4, 2648, 0, {0,0}}
	, { 4, 2652, 0, {0,0}}
	, { 4, 2656, 0, {0,0}}
	, { 4, 2660, 0, {0,0}}
	, { 4, 2664, 0, {0,0}}
	, { 4, 2668, 0, {0,0}}
	, { 4, 2672, 0, {0,0}}
	, { 4, 2676, 0, {0,0}}
	, { 4, 2680, 0, {0,0}}
	, { 4, 2684, 0, {0,0}}
	, { 4, 2688, 0, {0,0}}
	, { 4, 2692, 0, {0,0}}
	, { 4, 2696, 0, {0,0}}
	, { 4, 2700, 0, {0,0}}
	, { 4, 2704, 0, {0,0}}
	, { 4, 2708, 0, {0,0}}
	, { 4, 2712, 0, {0,0}}
	, { 4, 2716, 0, {0,0}}
	, { 4, 2720, 0, {0,0}}
	, { 4, 2724, 0, {0,0}}
	, { 4, 2728, 0, {0,0}}
	, { 4, 2732, 0, {0,0}}
	, { 4, 2736, 0, {0,0}}
	, { 4, 2740, 0, {0,0}}
	, { 4, 2744, 0, {0,0}}
	, { 4, 2748, 0, {0,0}}
	, { 4, 2752, 0, {0,0}}
	, { 4, 2756, 0, {0,0}}
	, { 4, 2760, 0, {0,0}}
	, { 4, 2764, 0, {0,0}}
	, { 4, 2768, 0, {0,0}}
	, { 4, 2772, 0, {0,0}}
	, { 4, 2776, 0, {0,0}}
	, { 4, 2780, 0, {0,0}}
	, { 4, 2784, 0, {0,0}}
	, { 4, 2788, 0, {0,0}}
	, { 4, 2792, 0, {0,0}}
	, { 4, 2796, 0, {0,0}}
	, { 4, 2800, 0, {0,0}}
	, { 4, 2804, 0, {0,0}}
	, { 4, 2808, 0, {0,0}}
	, { 4, 2812, 0, {0,0}}
	, { 4, 2816, 0, {0,0}}
	, { 4, 2820, 0, {0,0}}
	, { 4, 2824, 0, {0,0}}
	, { 4, 2828, 0, {0,0}}
	, { 4, 2832, 0, {0,0}}
	, { 4, 2836, 0, {0,0}}
	, { 4, 2840, 0, {0,0}}
	, { 4, 2844, 0, {0,0}}
	, { 4, 2848, 0, {0,0}}
	, { 4, 2852, 0, {0,0}}
	, { 4, 2856, 0, {0,0}}
	, { 4, 2860, 0, {0,0}}
	, { 4, 2864, 0, {0,0}}
	, { 4, 2868, 0, {0,0}}
	, { 4, 2872, 0, {0,0}}
	, { 4, 2876, 0, {0,0}}
	, { 4, 2880, 0, {0,0}}
	, { 4, 2884, 0, {0,0}}
	, { 4, 2888, 0, {0,0}}
	, { 4, 2892, 0, {0,0}}
	, { 4, 2896, 0, {0,0}}
	, { 4, 2900, 0, {0,0}}
	, { 4, 2904, 0, {0,0}}
	, { 4, 2908, 0, {0,0}}
	, { 4, 2912, 0, {0,0}}
	, { 4, 2916, 0, {0,0}}
	, { 4, 2920, 0, {0,0}}
	, { 4, 2924, 0, {0,0}}
	, { 4, 2928, 0, {0,0}}
	, { 4, 2932, 0, {0,0}}
	, { 4, 2936, 0, {0,0}}
	, { 4, 2940, 0, {0,0}}
	, { 4, 2944, 0, {0,0}}
	, { 4, 2948, 0, {0,0}}
	, { 4, 2952, 0, {0,0}}
	, { 4, 2956, 0, {0,0}}
	, { 4, 2960, 0, {0,0}}
	, { 4, 2964, 0, {0,0}}
	, { 4, 2968, 0, {0,0}}
	, { 4, 2972, 0, {0,0}}
	, { 4, 2976, 0, {0,0}}
	, { 4, 2980, 0, {0,0}}
	, { 4, 2984, 0, {0,0}}
	, { 4, 2988, 0, {0,0}}
	, { 4, 2992, 0, {0,0}}
	, { 4, 2996, 0, {0,0}}
	, { 4, 3000, 0, {0,0}}
	, { 4, 3004, 0, {0,0}}
	, { 4, 3008, 0, {0,0}}
	, { 4, 3012, 0, {0,0}}
	, { 4, 3016, 0, {0,0}}
	, { 4, 3020, 0, {0,0}}
	, { 4, 3024, 0, {0,0}}
	, { 4, 3028, 0, {0,0}}
	, { 4, 3032, 0, {0,0}}
	, { 4, 3036, 0, {0,0}}
	, { 4, 3040, 0, {0,0}}
	, { 4, 3044, 0, {0,0}}
	, { 4, 3048, 0, {0,0}}
	, { 4, 3052, 0, {0,0}}
	, { 4, 3056, 0, {0,0}}
	, { 6, 14, 2, {0,0}}
	, { 6, 14, 2, {0,1}}
	, { 6, 14, 2, {0,2}}
	, { 6, 14, 2, {0,3}}
	, { 6, 14, 2, {0,4}}
	, { 6, 14, 2, {0,5}}
	, { 6, 14, 2, {0,6}}
	, { 6, 14, 2, {0,7}}
	, { 6, 14, 2, {0,8}}
	, { 6, 14, 2, {0,9}}
	, { 6, 14, 2, {0,10}}
	, { 6, 14, 2, {0,11}}
	, { 6, 14, 2, {0,12}}
	, { 6, 14, 2, {0,13}}
	, { 6, 14, 2, {0,14}}
	, { 6, 14, 2, {0,15}}
	, { 6, 14, 2, {0,16}}
	, { 6, 14, 2, {0,17}}
	, { 6, 14, 2, {0,18}}
	, { 6, 14, 2, {0,19}}
	, { 6, 14, 2, {0,20}}
	, { 6, 14, 2, {0,21}}
	, { 6, 14, 2, {0,22}}
	, { 6, 14, 2, {0,23}}
	, { 6, 14, 2, {0,24}}
	, { 6, 14, 2, {0,25}}
	, { 6, 14, 2, {0,26}}
	, { 6, 14, 2, {0,27}}
	, { 6, 14, 2, {0,28}}
	, { 6, 14, 2, {0,29}}
	, { 6, 14, 2, {0,30}}
	, { 6, 14, 2, {0,31}}
	, { 6, 14, 2, {0,32}}
	, { 6, 14, 2, {0,33}}
	, { 6, 14, 2, {0,34}}
	, { 6, 14, 2, {0,35}}
	, { 6, 14, 2, {0,36}}
	, { 6, 14, 2, {0,37}}
	, { 6, 14, 2, {0,38}}
	, { 6, 14, 2, {0,39}}
	, { 6, 14, 2, {0,40}}
	, { 6, 14, 2, {0,41}}
	, { 6, 14, 2, {0,42}}
	, { 6, 14, 2, {0,43}}
	, { 6, 14, 2, {0,44}}
	, { 6, 14, 2, {0,45}}
	, { 6, 14, 2, {0,46}}
	, { 6, 14, 2, {0,47}}
	, { 6, 14, 2, {0,48}}
	, { 6, 14, 2, {0,49}}
	, { 6, 14, 2, {0,50}}
	, { 6, 14, 2, {0,51}}
	, { 6, 14, 2, {0,52}}
	, { 6, 14, 2, {0,53}}
	, { 6, 14, 2, {0,54}}
	, { 6, 14, 2, {0,55}}
	, { 6, 14, 2, {0,56}}
	, { 6, 14, 2, {0,57}}
	, { 6, 14, 2, {0,58}}
	, { 6, 14, 2, {0,59}}
	, { 6, 14, 2, {0,60}}
	, { 6, 14, 2, {0,61}}
	, { 6, 14, 2, {0,62}}
	, { 6, 14, 2, {0,63}}
	, { 6, 14, 2, {0,64}}
	, { 6, 14, 2, {0,65}}
	, { 6, 14, 2, {0,66}}
	, { 6, 14, 2, {0,67}}
	, { 6, 14, 2, {0,68}}
	, { 6, 14, 2, {0,69}}
	, { 6, 14, 2, {0,70}}
	, { 6, 14, 2, {0,71}}
	, { 6, 14, 2, {0,72}}
	, { 6, 14, 2, {0,73}}
	, { 6, 14, 2, {0,74}}
	, { 6, 14, 2, {0,75}}
	, { 6, 14, 2, {0,76}}
	, { 6, 14, 2, {0,77}}
	, { 6, 14, 2, {0,78}}
	, { 6, 14, 2, {0,79}}
	, { 6, 14, 2, {0,80}}
	, { 6, 14, 2, {0,81}}
	, { 6, 14, 2, {0,82}}
	, { 6, 14, 2, {0,83}}
	, { 6, 14, 2, {0,84}}
	, { 6, 14, 2, {0,85}}
	, { 6, 14, 2, {0,86}}
	, { 6, 14, 2, {0,87}}
	, { 6, 14, 2, {0,88}}
	, { 6, 14, 2, {0,89}}
	, { 6, 14, 2, {0,90}}
	, { 6, 14, 2, {0,91}}
	, { 6, 14, 2, {0,92}}
	, { 6, 14, 2, {0,93}}
	, { 6, 14, 2, {0,94}}
	, { 6, 14, 2, {0,95}}
	, { 6, 14, 2, {0,96}}
	, { 6, 14, 2, {0,97}}
	, { 6, 14, 2, {0,98}}
	, { 6, 14, 2, {0,99}}
	, { 6, 14, 2, {0,100}}
	, { 6, 14, 2, {0,101}}
	, { 6, 14, 2, {0,102}}
	, { 6, 14, 2, {0,103}}
	, { 6, 14, 2, {0,104}}
	, { 6, 14, 2, {0,105}}
	, { 6, 14, 2, {0,106}}
	, { 6, 14, 2, {0,107}}
	, { 6, 14, 2, {0,108}}
	, { 6, 14, 2, {0,109}}
	, { 6, 14, 2, {0,110}}
	, { 6, 14, 2, {0,111}}
	, { 6, 14, 2, {0,112}}
	, { 6, 14, 2, {0,113}}
	, { 6, 14, 2, {0,114}}
	, { 6, 14, 2, {0,115}}
	, { 6, 14, 2, {0,116}}
	, { 6, 14, 2, {0,117}}
	, { 6, 14, 2, {0,118}}
	, { 6, 14, 2, {0,119}}
	, { 6, 14, 2, {0,120}}
	, { 6, 14, 2, {0,121}}
	, { 6, 14, 2, {0,122}}
	, { 6, 14, 2, {0,123}}
	, { 6, 14, 2, {0,124}}
	, { 6, 14, 2, {0,125}}
	, { 6, 14, 2, {0,126}}
	, { 6, 14, 2, {0,127}}
	, { 6, 14, 2, {0,128}}
	, { 6, 14, 2, {0,129}}
	, { 6, 14, 2, {0,130}}
	, { 6, 14, 2, {0,131}}
	, { 6, 14, 2, {0,132}}
	, { 6, 14, 2, {0,133}}
	, { 6, 14, 2, {0,134}}
	, { 6, 14, 2, {0,135}}
	, { 6, 14, 2, {0,136}}
	, { 6, 14, 2, {0,137}}
	, { 6, 14, 2, {0,138}}
	, { 6, 14, 2, {0,139}}
	, { 6, 14, 2, {0,140}}
	, { 6, 14, 2, {0,141}}
	, { 6, 14, 2, {0,142}}
	, { 6, 14, 2, {0,143}}
	, { 6, 14, 2, {0,144}}
	, { 6, 14, 2, {0,145}}
	, { 6, 14, 2, {0,146}}
	, { 6, 14, 2, {0,147}}
	, { 6, 14, 2, {0,148}}
	, { 6, 14, 2, {0,149}}
	, { 6, 14, 2, {0,150}}
	, { 6, 14, 2, {0,151}}
	, { 6, 14, 2, {0,152}}
	, { 6, 14, 2, {0,153}}
	, { 6, 14, 2, {0,154}}
	, { 6, 14, 2, {0,155}}
	, { 6, 14, 2, {0,156}}
	, { 6, 14, 2, {0,157}}
	, { 6, 14, 2, {0,158}}
	, { 6, 14, 2, {0,159}}
	, { 6, 14, 2, {0,160}}
	, { 6, 14, 2, {0,161}}
	, { 6, 14, 2, {0,162}}
	, { 6, 14, 2, {0,163}}
	, { 6, 14, 2, {0,164}}
	, { 6, 14, 2, {0,165}}
	, { 6, 14, 2, {0,166}}
	, { 6, 14, 2, {0,167}}
	, { 6, 14, 2, {0,168}}
	, { 6, 14, 2, {0,169}}
	, { 6, 14, 2, {0,170}}
	, { 6, 14, 2, {0,171}}
	, { 6, 14, 2, {0,172}}
	, { 6, 14, 2, {0,173}}
	, { 6, 14, 2, {0,174}}
	, { 6, 14, 2, {0,175}}
	, { 6, 14, 2, {0,176}}
	, { 6, 14, 2, {0,177}}
	, { 6, 14, 2, {0,178}}
	, { 6, 14, 2, {0,179}}
	, { 6, 14, 2, {0,180}}
	, { 6, 14, 2, {0,181}}
	, { 6, 14, 2, {0,182}}
	, { 6, 14, 2, {0,183}}
	, { 6, 14, 2, {0,184}}
	, { 6, 14, 2, {0,185}}
	, { 6, 14, 2, {0,186}}
	, { 6, 14, 2, {0,187}}
	, { 6, 14, 2, {0,188}}
	, { 6, 14, 2, {0,189}}
	, { 6, 14, 2, {0,190}}
	, { 6, 14, 2, {0,191}}
	, { 6, 14, 2, {0,192}}
	, { 6, 14, 2, {0,193}}
	, { 6, 14, 2, {0,194}}
	, { 6, 14, 2, {0,195}}
	, { 6, 14, 2, {0,196}}
	, { 6, 14, 2, {0,197}}
	, { 6, 14, 2, {0,198}}
	, { 6, 14, 2, {0,199}}
	, { 6, 14, 2, {0,200}}
	, { 6, 14, 2, {0,201}}
	, { 6, 14, 2, {0,202}}
	, { 6, 14, 2, {0,203}}
	, { 6, 14, 2, {0,204}}
	, { 6, 14, 2, {0,205}}
	, { 6, 14, 2, {0,206}}
	, { 6, 14, 2, {0,207}}
	, { 6, 14, 2, {0,208}}
	, { 6, 14, 2, {0,209}}
	, { 6, 14, 2, {0,210}}
	, { 6, 14, 2, {0,211}}
	, { 6, 14, 2, {0,212}}
	, { 6, 14, 2, {0,213}}
	, { 6, 14, 2, {0,214}}
	, { 6, 14, 2, {0,215}}
	, { 6, 14, 2, {0,216}}
	, { 6, 14, 2, {0,217}}
	, { 6, 14, 2, {0,218}}
	, { 6, 14, 2, {0,219}}
	, { 6, 14, 2, {0,220}}
	, { 6, 14, 2, {0,221}}
	, { 6, 14, 2, {0,222}}
	, { 6, 14, 2, {0,223}}
	, { 6, 14, 2, {0,224}}
	, { 6, 14, 2, {0,225}}
	, { 6, 14, 2, {0,226}}
	, { 6, 14, 2, {0,227}}
	, { 6, 14, 2, {0,228}}
	, { 6, 14, 2, {0,229}}
	, { 6, 14, 2, {0,230}}
	, { 6, 14, 2, {0,231}}
	, { 6, 14, 2, {0,232}}
	, { 6, 14, 2, {0,233}}
	, { 6, 14, 2, {0,234}}
	, { 6, 14, 2, {0,235}}
	, { 6, 14, 2, {0,236}}
	, { 6, 14, 2, {0,237}}
	, { 6, 14, 2, {0,238}}
	, { 6, 14, 2, {0,239}}
	, { 6, 14, 2, {0,240}}
	, { 6, 14, 2, {0,241}}
	, { 6, 14, 2, {0,242}}
	, { 6, 14, 2, {0,243}}
	, { 6, 14, 2, {0,244}}
	, { 6, 14, 2, {0,245}}
	, { 6, 14, 2, {0,246}}
	, { 6, 14, 2, {0,247}}
	, { 6, 14, 2, {0,248}}
	, { 6, 14, 2, {0,249}}
	, { 6, 14, 2, {0,250}}
	, { 6, 14, 2, {0,251}}
	, { 6, 14, 2, {0,252}}
	, { 6, 14, 2, {0,253}}
	, { 6, 14, 2, {0,254}}
	, { 6, 14, 2, {0,255}}
	, { 6, 14, 2, {0,256}}
	, { 6, 14, 2, {0,257}}
	, { 6, 14, 2, {0,258}}
	, { 6, 14, 2, {0,259}}
	, { 6, 14, 2, {0,260}}
	, { 6, 14, 2, {0,261}}
	, { 6, 14, 2, {0,262}}
	, { 6, 14, 2, {0,263}}
	, { 6, 14, 2, {0,264}}
	, { 6, 14, 2, {0,265}}
	, { 6, 14, 2, {0,266}}
	, { 6, 14, 2, {0,267}}
	, { 6, 14, 2, {0,268}}
	, { 6, 14, 2, {0,269}}
	, { 6, 14, 2, {0,270}}
	, { 6, 14, 2, {0,271}}
	, { 10, 6, 1, {327681,0}}
	, { 10, 6, 1, {327937,0}}
	, { 10, 6, 1, {328193,0}}
	, { 10, 6, 1, {328449,0}}
	, { 10, 6, 1, {328705,0}}
	, { 10, 6, 1, {328961,0}}
	, { 10, 6, 1, {329217,0}}
	, { 10, 6, 1, {329473,0}}
	, { 10, 6, 1, {329729,0}}
	, { 10, 6, 1, {329985,0}}
	, { 10, 6, 1, {330241,0}}
	, { 10, 6, 1, {330497,0}}};

static const struct vfc_read_task vfc_task_t_e2 = {vfc_vectors_t_e2, 1049};
static const struct vfc_read_write_vector vfc_vectors_x_e2[1049] = {
	{ 4, 0, 0, {0,0}}
	, { 4, 4, 0, {0,0}}
	, { 4, 8, 0, {0,0}}
	, { 4, 12, 0, {0,0}}
	, { 4, 16, 0, {0,0}}
	, { 4, 20, 0, {0,0}}
	, { 4, 24, 0, {0,0}}
	, { 4, 28, 0, {0,0}}
	, { 4, 32, 0, {0,0}}
	, { 4, 36, 0, {0,0}}
	, { 4, 40, 0, {0,0}}
	, { 4, 44, 0, {0,0}}
	, { 4, 48, 0, {0,0}}
	, { 4, 52, 0, {0,0}}
	, { 4, 56, 0, {0,0}}
	, { 4, 60, 0, {0,0}}
	, { 4, 64, 0, {0,0}}
	, { 4, 68, 0, {0,0}}
	, { 4, 72, 0, {0,0}}
	, { 4, 76, 0, {0,0}}
	, { 4, 80, 0, {0,0}}
	, { 4, 84, 0, {0,0}}
	, { 4, 88, 0, {0,0}}
	, { 4, 92, 0, {0,0}}
	, { 4, 96, 0, {0,0}}
	, { 4, 100, 0, {0,0}}
	, { 4, 104, 0, {0,0}}
	, { 4, 108, 0, {0,0}}
	, { 4, 112, 0, {0,0}}
	, { 4, 116, 0, {0,0}}
	, { 4, 120, 0, {0,0}}
	, { 4, 124, 0, {0,0}}
	, { 4, 128, 0, {0,0}}
	, { 4, 132, 0, {0,0}}
	, { 4, 136, 0, {0,0}}
	, { 4, 140, 0, {0,0}}
	, { 4, 144, 0, {0,0}}
	, { 4, 148, 0, {0,0}}
	, { 4, 152, 0, {0,0}}
	, { 4, 156, 0, {0,0}}
	, { 4, 160, 0, {0,0}}
	, { 4, 164, 0, {0,0}}
	, { 4, 168, 0, {0,0}}
	, { 4, 172, 0, {0,0}}
	, { 4, 176, 0, {0,0}}
	, { 4, 180, 0, {0,0}}
	, { 4, 184, 0, {0,0}}
	, { 4, 188, 0, {0,0}}
	, { 4, 192, 0, {0,0}}
	, { 4, 196, 0, {0,0}}
	, { 4, 200, 0, {0,0}}
	, { 4, 204, 0, {0,0}}
	, { 4, 208, 0, {0,0}}
	, { 4, 212, 0, {0,0}}
	, { 4, 216, 0, {0,0}}
	, { 4, 220, 0, {0,0}}
	, { 4, 224, 0, {0,0}}
	, { 4, 228, 0, {0,0}}
	, { 4, 232, 0, {0,0}}
	, { 4, 236, 0, {0,0}}
	, { 4, 240, 0, {0,0}}
	, { 4, 244, 0, {0,0}}
	, { 4, 248, 0, {0,0}}
	, { 4, 252, 0, {0,0}}
	, { 4, 256, 0, {0,0}}
	, { 4, 260, 0, {0,0}}
	, { 4, 264, 0, {0,0}}
	, { 4, 268, 0, {0,0}}
	, { 4, 272, 0, {0,0}}
	, { 4, 276, 0, {0,0}}
	, { 4, 280, 0, {0,0}}
	, { 4, 284, 0, {0,0}}
	, { 4, 288, 0, {0,0}}
	, { 4, 292, 0, {0,0}}
	, { 4, 296, 0, {0,0}}
	, { 4, 300, 0, {0,0}}
	, { 4, 304, 0, {0,0}}
	, { 4, 308, 0, {0,0}}
	, { 4, 312, 0, {0,0}}
	, { 4, 316, 0, {0,0}}
	, { 4, 320, 0, {0,0}}
	, { 4, 324, 0, {0,0}}
	, { 4, 328, 0, {0,0}}
	, { 4, 332, 0, {0,0}}
	, { 4, 336, 0, {0,0}}
	, { 4, 340, 0, {0,0}}
	, { 4, 344, 0, {0,0}}
	, { 4, 348, 0, {0,0}}
	, { 4, 352, 0, {0,0}}
	, { 4, 356, 0, {0,0}}
	, { 4, 360, 0, {0,0}}
	, { 4, 364, 0, {0,0}}
	, { 4, 368, 0, {0,0}}
	, { 4, 372, 0, {0,0}}
	, { 4, 376, 0, {0,0}}
	, { 4, 380, 0, {0,0}}
	, { 4, 384, 0, {0,0}}
	, { 4, 388, 0, {0,0}}
	, { 4, 392, 0, {0,0}}
	, { 4, 396, 0, {0,0}}
	, { 4, 400, 0, {0,0}}
	, { 4, 404, 0, {0,0}}
	, { 4, 408, 0, {0,0}}
	, { 4, 412, 0, {0,0}}
	, { 4, 416, 0, {0,0}}
	, { 4, 420, 0, {0,0}}
	, { 4, 424, 0, {0,0}}
	, { 4, 428, 0, {0,0}}
	, { 4, 432, 0, {0,0}}
	, { 4, 436, 0, {0,0}}
	, { 4, 440, 0, {0,0}}
	, { 4, 444, 0, {0,0}}
	, { 4, 448, 0, {0,0}}
	, { 4, 452, 0, {0,0}}
	, { 4, 456, 0, {0,0}}
	, { 4, 460, 0, {0,0}}
	, { 4, 464, 0, {0,0}}
	, { 4, 468, 0, {0,0}}
	, { 4, 472, 0, {0,0}}
	, { 4, 476, 0, {0,0}}
	, { 4, 480, 0, {0,0}}
	, { 4, 484, 0, {0,0}}
	, { 4, 488, 0, {0,0}}
	, { 4, 492, 0, {0,0}}
	, { 4, 496, 0, {0,0}}
	, { 4, 500, 0, {0,0}}
	, { 4, 504, 0, {0,0}}
	, { 4, 508, 0, {0,0}}
	, { 4, 512, 0, {0,0}}
	, { 4, 516, 0, {0,0}}
	, { 4, 520, 0, {0,0}}
	, { 4, 524, 0, {0,0}}
	, { 4, 528, 0, {0,0}}
	, { 4, 532, 0, {0,0}}
	, { 4, 536, 0, {0,0}}
	, { 4, 540, 0, {0,0}}
	, { 4, 544, 0, {0,0}}
	, { 4, 548, 0, {0,0}}
	, { 4, 552, 0, {0,0}}
	, { 4, 556, 0, {0,0}}
	, { 4, 560, 0, {0,0}}
	, { 4, 564, 0, {0,0}}
	, { 4, 568, 0, {0,0}}
	, { 4, 572, 0, {0,0}}
	, { 4, 576, 0, {0,0}}
	, { 4, 580, 0, {0,0}}
	, { 4, 584, 0, {0,0}}
	, { 4, 588, 0, {0,0}}
	, { 4, 592, 0, {0,0}}
	, { 4, 596, 0, {0,0}}
	, { 4, 600, 0, {0,0}}
	, { 4, 604, 0, {0,0}}
	, { 4, 608, 0, {0,0}}
	, { 4, 612, 0, {0,0}}
	, { 4, 616, 0, {0,0}}
	, { 4, 620, 0, {0,0}}
	, { 4, 624, 0, {0,0}}
	, { 4, 628, 0, {0,0}}
	, { 4, 632, 0, {0,0}}
	, { 4, 636, 0, {0,0}}
	, { 4, 640, 0, {0,0}}
	, { 4, 644, 0, {0,0}}
	, { 4, 648, 0, {0,0}}
	, { 4, 652, 0, {0,0}}
	, { 4, 656, 0, {0,0}}
	, { 4, 660, 0, {0,0}}
	, { 4, 664, 0, {0,0}}
	, { 4, 668, 0, {0,0}}
	, { 4, 672, 0, {0,0}}
	, { 4, 676, 0, {0,0}}
	, { 4, 680, 0, {0,0}}
	, { 4, 684, 0, {0,0}}
	, { 4, 688, 0, {0,0}}
	, { 4, 692, 0, {0,0}}
	, { 4, 696, 0, {0,0}}
	, { 4, 700, 0, {0,0}}
	, { 4, 704, 0, {0,0}}
	, { 4, 708, 0, {0,0}}
	, { 4, 712, 0, {0,0}}
	, { 4, 716, 0, {0,0}}
	, { 4, 720, 0, {0,0}}
	, { 4, 724, 0, {0,0}}
	, { 4, 728, 0, {0,0}}
	, { 4, 732, 0, {0,0}}
	, { 4, 736, 0, {0,0}}
	, { 4, 740, 0, {0,0}}
	, { 4, 744, 0, {0,0}}
	, { 4, 748, 0, {0,0}}
	, { 4, 752, 0, {0,0}}
	, { 4, 756, 0, {0,0}}
	, { 4, 760, 0, {0,0}}
	, { 4, 764, 0, {0,0}}
	, { 4, 768, 0, {0,0}}
	, { 4, 772, 0, {0,0}}
	, { 4, 776, 0, {0,0}}
	, { 4, 780, 0, {0,0}}
	, { 4, 784, 0, {0,0}}
	, { 4, 788, 0, {0,0}}
	, { 4, 792, 0, {0,0}}
	, { 4, 796, 0, {0,0}}
	, { 4, 800, 0, {0,0}}
	, { 4, 804, 0, {0,0}}
	, { 4, 808, 0, {0,0}}
	, { 4, 812, 0, {0,0}}
	, { 4, 816, 0, {0,0}}
	, { 4, 820, 0, {0,0}}
	, { 4, 824, 0, {0,0}}
	, { 4, 828, 0, {0,0}}
	, { 4, 832, 0, {0,0}}
	, { 4, 836, 0, {0,0}}
	, { 4, 840, 0, {0,0}}
	, { 4, 844, 0, {0,0}}
	, { 4, 848, 0, {0,0}}
	, { 4, 852, 0, {0,0}}
	, { 4, 856, 0, {0,0}}
	, { 4, 860, 0, {0,0}}
	, { 4, 864, 0, {0,0}}
	, { 4, 868, 0, {0,0}}
	, { 4, 872, 0, {0,0}}
	, { 4, 876, 0, {0,0}}
	, { 4, 880, 0, {0,0}}
	, { 4, 884, 0, {0,0}}
	, { 4, 888, 0, {0,0}}
	, { 4, 892, 0, {0,0}}
	, { 4, 896, 0, {0,0}}
	, { 4, 900, 0, {0,0}}
	, { 4, 904, 0, {0,0}}
	, { 4, 908, 0, {0,0}}
	, { 4, 912, 0, {0,0}}
	, { 4, 916, 0, {0,0}}
	, { 4, 920, 0, {0,0}}
	, { 4, 924, 0, {0,0}}
	, { 4, 928, 0, {0,0}}
	, { 4, 932, 0, {0,0}}
	, { 4, 936, 0, {0,0}}
	, { 4, 940, 0, {0,0}}
	, { 4, 944, 0, {0,0}}
	, { 4, 948, 0, {0,0}}
	, { 4, 952, 0, {0,0}}
	, { 4, 956, 0, {0,0}}
	, { 4, 960, 0, {0,0}}
	, { 4, 964, 0, {0,0}}
	, { 4, 968, 0, {0,0}}
	, { 4, 972, 0, {0,0}}
	, { 4, 976, 0, {0,0}}
	, { 4, 980, 0, {0,0}}
	, { 4, 984, 0, {0,0}}
	, { 4, 988, 0, {0,0}}
	, { 4, 992, 0, {0,0}}
	, { 4, 996, 0, {0,0}}
	, { 4, 1000, 0, {0,0}}
	, { 4, 1004, 0, {0,0}}
	, { 4, 1008, 0, {0,0}}
	, { 4, 1012, 0, {0,0}}
	, { 4, 1016, 0, {0,0}}
	, { 4, 1020, 0, {0,0}}
	, { 4, 1024, 0, {0,0}}
	, { 4, 1028, 0, {0,0}}
	, { 4, 1032, 0, {0,0}}
	, { 4, 1036, 0, {0,0}}
	, { 4, 1040, 0, {0,0}}
	, { 4, 1044, 0, {0,0}}
	, { 4, 1048, 0, {0,0}}
	, { 4, 1052, 0, {0,0}}
	, { 4, 1056, 0, {0,0}}
	, { 4, 1060, 0, {0,0}}
	, { 4, 1064, 0, {0,0}}
	, { 4, 1068, 0, {0,0}}
	, { 4, 1072, 0, {0,0}}
	, { 4, 1076, 0, {0,0}}
	, { 4, 1080, 0, {0,0}}
	, { 4, 1084, 0, {0,0}}
	, { 4, 1088, 0, {0,0}}
	, { 4, 1092, 0, {0,0}}
	, { 4, 1096, 0, {0,0}}
	, { 4, 1100, 0, {0,0}}
	, { 4, 1104, 0, {0,0}}
	, { 4, 1108, 0, {0,0}}
	, { 4, 1112, 0, {0,0}}
	, { 4, 1116, 0, {0,0}}
	, { 4, 1120, 0, {0,0}}
	, { 4, 1124, 0, {0,0}}
	, { 4, 1128, 0, {0,0}}
	, { 4, 1132, 0, {0,0}}
	, { 4, 1136, 0, {0,0}}
	, { 4, 1140, 0, {0,0}}
	, { 4, 1144, 0, {0,0}}
	, { 4, 1148, 0, {0,0}}
	, { 4, 1152, 0, {0,0}}
	, { 4, 1156, 0, {0,0}}
	, { 4, 1160, 0, {0,0}}
	, { 4, 1164, 0, {0,0}}
	, { 4, 1168, 0, {0,0}}
	, { 4, 1172, 0, {0,0}}
	, { 4, 1176, 0, {0,0}}
	, { 4, 1180, 0, {0,0}}
	, { 4, 1184, 0, {0,0}}
	, { 4, 1188, 0, {0,0}}
	, { 4, 1192, 0, {0,0}}
	, { 4, 1196, 0, {0,0}}
	, { 4, 1200, 0, {0,0}}
	, { 4, 1204, 0, {0,0}}
	, { 4, 1208, 0, {0,0}}
	, { 4, 1212, 0, {0,0}}
	, { 4, 1216, 0, {0,0}}
	, { 4, 1220, 0, {0,0}}
	, { 4, 1224, 0, {0,0}}
	, { 4, 1228, 0, {0,0}}
	, { 4, 1232, 0, {0,0}}
	, { 4, 1236, 0, {0,0}}
	, { 4, 1240, 0, {0,0}}
	, { 4, 1244, 0, {0,0}}
	, { 4, 1248, 0, {0,0}}
	, { 4, 1252, 0, {0,0}}
	, { 4, 1256, 0, {0,0}}
	, { 4, 1260, 0, {0,0}}
	, { 4, 1264, 0, {0,0}}
	, { 4, 1268, 0, {0,0}}
	, { 4, 1272, 0, {0,0}}
	, { 4, 1276, 0, {0,0}}
	, { 4, 1280, 0, {0,0}}
	, { 4, 1284, 0, {0,0}}
	, { 4, 1288, 0, {0,0}}
	, { 4, 1292, 0, {0,0}}
	, { 4, 1296, 0, {0,0}}
	, { 4, 1300, 0, {0,0}}
	, { 4, 1304, 0, {0,0}}
	, { 4, 1308, 0, {0,0}}
	, { 4, 1312, 0, {0,0}}
	, { 4, 1316, 0, {0,0}}
	, { 4, 1320, 0, {0,0}}
	, { 4, 1324, 0, {0,0}}
	, { 4, 1328, 0, {0,0}}
	, { 4, 1332, 0, {0,0}}
	, { 4, 1336, 0, {0,0}}
	, { 4, 1340, 0, {0,0}}
	, { 4, 1344, 0, {0,0}}
	, { 4, 1348, 0, {0,0}}
	, { 4, 1352, 0, {0,0}}
	, { 4, 1356, 0, {0,0}}
	, { 4, 1360, 0, {0,0}}
	, { 4, 1364, 0, {0,0}}
	, { 4, 1368, 0, {0,0}}
	, { 4, 1372, 0, {0,0}}
	, { 4, 1376, 0, {0,0}}
	, { 4, 1380, 0, {0,0}}
	, { 4, 1384, 0, {0,0}}
	, { 4, 1388, 0, {0,0}}
	, { 4, 1392, 0, {0,0}}
	, { 4, 1396, 0, {0,0}}
	, { 4, 1400, 0, {0,0}}
	, { 4, 1404, 0, {0,0}}
	, { 4, 1408, 0, {0,0}}
	, { 4, 1412, 0, {0,0}}
	, { 4, 1416, 0, {0,0}}
	, { 4, 1420, 0, {0,0}}
	, { 4, 1424, 0, {0,0}}
	, { 4, 1428, 0, {0,0}}
	, { 4, 1432, 0, {0,0}}
	, { 4, 1436, 0, {0,0}}
	, { 4, 1440, 0, {0,0}}
	, { 4, 1444, 0, {0,0}}
	, { 4, 1448, 0, {0,0}}
	, { 4, 1452, 0, {0,0}}
	, { 4, 1456, 0, {0,0}}
	, { 4, 1460, 0, {0,0}}
	, { 4, 1464, 0, {0,0}}
	, { 4, 1468, 0, {0,0}}
	, { 4, 1472, 0, {0,0}}
	, { 4, 1476, 0, {0,0}}
	, { 4, 1480, 0, {0,0}}
	, { 4, 1484, 0, {0,0}}
	, { 4, 1488, 0, {0,0}}
	, { 4, 1492, 0, {0,0}}
	, { 4, 1496, 0, {0,0}}
	, { 4, 1500, 0, {0,0}}
	, { 4, 1504, 0, {0,0}}
	, { 4, 1508, 0, {0,0}}
	, { 4, 1512, 0, {0,0}}
	, { 4, 1516, 0, {0,0}}
	, { 4, 1520, 0, {0,0}}
	, { 4, 1524, 0, {0,0}}
	, { 4, 1528, 0, {0,0}}
	, { 4, 1532, 0, {0,0}}
	, { 4, 1536, 0, {0,0}}
	, { 4, 1540, 0, {0,0}}
	, { 4, 1544, 0, {0,0}}
	, { 4, 1548, 0, {0,0}}
	, { 4, 1552, 0, {0,0}}
	, { 4, 1556, 0, {0,0}}
	, { 4, 1560, 0, {0,0}}
	, { 4, 1564, 0, {0,0}}
	, { 4, 1568, 0, {0,0}}
	, { 4, 1572, 0, {0,0}}
	, { 4, 1576, 0, {0,0}}
	, { 4, 1580, 0, {0,0}}
	, { 4, 1584, 0, {0,0}}
	, { 4, 1588, 0, {0,0}}
	, { 4, 1592, 0, {0,0}}
	, { 4, 1596, 0, {0,0}}
	, { 4, 1600, 0, {0,0}}
	, { 4, 1604, 0, {0,0}}
	, { 4, 1608, 0, {0,0}}
	, { 4, 1612, 0, {0,0}}
	, { 4, 1616, 0, {0,0}}
	, { 4, 1620, 0, {0,0}}
	, { 4, 1624, 0, {0,0}}
	, { 4, 1628, 0, {0,0}}
	, { 4, 1632, 0, {0,0}}
	, { 4, 1636, 0, {0,0}}
	, { 4, 1640, 0, {0,0}}
	, { 4, 1644, 0, {0,0}}
	, { 4, 1648, 0, {0,0}}
	, { 4, 1652, 0, {0,0}}
	, { 4, 1656, 0, {0,0}}
	, { 4, 1660, 0, {0,0}}
	, { 4, 1664, 0, {0,0}}
	, { 4, 1668, 0, {0,0}}
	, { 4, 1672, 0, {0,0}}
	, { 4, 1676, 0, {0,0}}
	, { 4, 1680, 0, {0,0}}
	, { 4, 1684, 0, {0,0}}
	, { 4, 1688, 0, {0,0}}
	, { 4, 1692, 0, {0,0}}
	, { 4, 1696, 0, {0,0}}
	, { 4, 1700, 0, {0,0}}
	, { 4, 1704, 0, {0,0}}
	, { 4, 1708, 0, {0,0}}
	, { 4, 1712, 0, {0,0}}
	, { 4, 1716, 0, {0,0}}
	, { 4, 1720, 0, {0,0}}
	, { 4, 1724, 0, {0,0}}
	, { 4, 1728, 0, {0,0}}
	, { 4, 1732, 0, {0,0}}
	, { 4, 1736, 0, {0,0}}
	, { 4, 1740, 0, {0,0}}
	, { 4, 1744, 0, {0,0}}
	, { 4, 1748, 0, {0,0}}
	, { 4, 1752, 0, {0,0}}
	, { 4, 1756, 0, {0,0}}
	, { 4, 1760, 0, {0,0}}
	, { 4, 1764, 0, {0,0}}
	, { 4, 1768, 0, {0,0}}
	, { 4, 1772, 0, {0,0}}
	, { 4, 1776, 0, {0,0}}
	, { 4, 1780, 0, {0,0}}
	, { 4, 1784, 0, {0,0}}
	, { 4, 1788, 0, {0,0}}
	, { 4, 1792, 0, {0,0}}
	, { 4, 1796, 0, {0,0}}
	, { 4, 1800, 0, {0,0}}
	, { 4, 1804, 0, {0,0}}
	, { 4, 1808, 0, {0,0}}
	, { 4, 1812, 0, {0,0}}
	, { 4, 1816, 0, {0,0}}
	, { 4, 1820, 0, {0,0}}
	, { 4, 1824, 0, {0,0}}
	, { 4, 1828, 0, {0,0}}
	, { 4, 1832, 0, {0,0}}
	, { 4, 1836, 0, {0,0}}
	, { 4, 1840, 0, {0,0}}
	, { 4, 1844, 0, {0,0}}
	, { 4, 1848, 0, {0,0}}
	, { 4, 1852, 0, {0,0}}
	, { 4, 1856, 0, {0,0}}
	, { 4, 1860, 0, {0,0}}
	, { 4, 1864, 0, {0,0}}
	, { 4, 1868, 0, {0,0}}
	, { 4, 1872, 0, {0,0}}
	, { 4, 1876, 0, {0,0}}
	, { 4, 1880, 0, {0,0}}
	, { 4, 1884, 0, {0,0}}
	, { 4, 1888, 0, {0,0}}
	, { 4, 1892, 0, {0,0}}
	, { 4, 1896, 0, {0,0}}
	, { 4, 1900, 0, {0,0}}
	, { 4, 1904, 0, {0,0}}
	, { 4, 1908, 0, {0,0}}
	, { 4, 1912, 0, {0,0}}
	, { 4, 1916, 0, {0,0}}
	, { 4, 1920, 0, {0,0}}
	, { 4, 1924, 0, {0,0}}
	, { 4, 1928, 0, {0,0}}
	, { 4, 1932, 0, {0,0}}
	, { 4, 1936, 0, {0,0}}
	, { 4, 1940, 0, {0,0}}
	, { 4, 1944, 0, {0,0}}
	, { 4, 1948, 0, {0,0}}
	, { 4, 1952, 0, {0,0}}
	, { 4, 1956, 0, {0,0}}
	, { 4, 1960, 0, {0,0}}
	, { 4, 1964, 0, {0,0}}
	, { 4, 1968, 0, {0,0}}
	, { 4, 1972, 0, {0,0}}
	, { 4, 1976, 0, {0,0}}
	, { 4, 1980, 0, {0,0}}
	, { 4, 1984, 0, {0,0}}
	, { 4, 1988, 0, {0,0}}
	, { 4, 1992, 0, {0,0}}
	, { 4, 1996, 0, {0,0}}
	, { 4, 2000, 0, {0,0}}
	, { 4, 2004, 0, {0,0}}
	, { 4, 2008, 0, {0,0}}
	, { 4, 2012, 0, {0,0}}
	, { 4, 2016, 0, {0,0}}
	, { 4, 2020, 0, {0,0}}
	, { 4, 2024, 0, {0,0}}
	, { 4, 2028, 0, {0,0}}
	, { 4, 2032, 0, {0,0}}
	, { 4, 2036, 0, {0,0}}
	, { 4, 2040, 0, {0,0}}
	, { 4, 2044, 0, {0,0}}
	, { 4, 2048, 0, {0,0}}
	, { 4, 2052, 0, {0,0}}
	, { 4, 2056, 0, {0,0}}
	, { 4, 2060, 0, {0,0}}
	, { 4, 2064, 0, {0,0}}
	, { 4, 2068, 0, {0,0}}
	, { 4, 2072, 0, {0,0}}
	, { 4, 2076, 0, {0,0}}
	, { 4, 2080, 0, {0,0}}
	, { 4, 2084, 0, {0,0}}
	, { 4, 2088, 0, {0,0}}
	, { 4, 2092, 0, {0,0}}
	, { 4, 2096, 0, {0,0}}
	, { 4, 2100, 0, {0,0}}
	, { 4, 2104, 0, {0,0}}
	, { 4, 2108, 0, {0,0}}
	, { 4, 2112, 0, {0,0}}
	, { 4, 2116, 0, {0,0}}
	, { 4, 2120, 0, {0,0}}
	, { 4, 2124, 0, {0,0}}
	, { 4, 2128, 0, {0,0}}
	, { 4, 2132, 0, {0,0}}
	, { 4, 2136, 0, {0,0}}
	, { 4, 2140, 0, {0,0}}
	, { 4, 2144, 0, {0,0}}
	, { 4, 2148, 0, {0,0}}
	, { 4, 2152, 0, {0,0}}
	, { 4, 2156, 0, {0,0}}
	, { 4, 2160, 0, {0,0}}
	, { 4, 2164, 0, {0,0}}
	, { 4, 2168, 0, {0,0}}
	, { 4, 2172, 0, {0,0}}
	, { 4, 2176, 0, {0,0}}
	, { 4, 2180, 0, {0,0}}
	, { 4, 2184, 0, {0,0}}
	, { 4, 2188, 0, {0,0}}
	, { 4, 2192, 0, {0,0}}
	, { 4, 2196, 0, {0,0}}
	, { 4, 2200, 0, {0,0}}
	, { 4, 2204, 0, {0,0}}
	, { 4, 2208, 0, {0,0}}
	, { 4, 2212, 0, {0,0}}
	, { 4, 2216, 0, {0,0}}
	, { 4, 2220, 0, {0,0}}
	, { 4, 2224, 0, {0,0}}
	, { 4, 2228, 0, {0,0}}
	, { 4, 2232, 0, {0,0}}
	, { 4, 2236, 0, {0,0}}
	, { 4, 2240, 0, {0,0}}
	, { 4, 2244, 0, {0,0}}
	, { 4, 2248, 0, {0,0}}
	, { 4, 2252, 0, {0,0}}
	, { 4, 2256, 0, {0,0}}
	, { 4, 2260, 0, {0,0}}
	, { 4, 2264, 0, {0,0}}
	, { 4, 2268, 0, {0,0}}
	, { 4, 2272, 0, {0,0}}
	, { 4, 2276, 0, {0,0}}
	, { 4, 2280, 0, {0,0}}
	, { 4, 2284, 0, {0,0}}
	, { 4, 2288, 0, {0,0}}
	, { 4, 2292, 0, {0,0}}
	, { 4, 2296, 0, {0,0}}
	, { 4, 2300, 0, {0,0}}
	, { 4, 2304, 0, {0,0}}
	, { 4, 2308, 0, {0,0}}
	, { 4, 2312, 0, {0,0}}
	, { 4, 2316, 0, {0,0}}
	, { 4, 2320, 0, {0,0}}
	, { 4, 2324, 0, {0,0}}
	, { 4, 2328, 0, {0,0}}
	, { 4, 2332, 0, {0,0}}
	, { 4, 2336, 0, {0,0}}
	, { 4, 2340, 0, {0,0}}
	, { 4, 2344, 0, {0,0}}
	, { 4, 2348, 0, {0,0}}
	, { 4, 2352, 0, {0,0}}
	, { 4, 2356, 0, {0,0}}
	, { 4, 2360, 0, {0,0}}
	, { 4, 2364, 0, {0,0}}
	, { 4, 2368, 0, {0,0}}
	, { 4, 2372, 0, {0,0}}
	, { 4, 2376, 0, {0,0}}
	, { 4, 2380, 0, {0,0}}
	, { 4, 2384, 0, {0,0}}
	, { 4, 2388, 0, {0,0}}
	, { 4, 2392, 0, {0,0}}
	, { 4, 2396, 0, {0,0}}
	, { 4, 2400, 0, {0,0}}
	, { 4, 2404, 0, {0,0}}
	, { 4, 2408, 0, {0,0}}
	, { 4, 2412, 0, {0,0}}
	, { 4, 2416, 0, {0,0}}
	, { 4, 2420, 0, {0,0}}
	, { 4, 2424, 0, {0,0}}
	, { 4, 2428, 0, {0,0}}
	, { 4, 2432, 0, {0,0}}
	, { 4, 2436, 0, {0,0}}
	, { 4, 2440, 0, {0,0}}
	, { 4, 2444, 0, {0,0}}
	, { 4, 2448, 0, {0,0}}
	, { 4, 2452, 0, {0,0}}
	, { 4, 2456, 0, {0,0}}
	, { 4, 2460, 0, {0,0}}
	, { 4, 2464, 0, {0,0}}
	, { 4, 2468, 0, {0,0}}
	, { 4, 2472, 0, {0,0}}
	, { 4, 2476, 0, {0,0}}
	, { 4, 2480, 0, {0,0}}
	, { 4, 2484, 0, {0,0}}
	, { 4, 2488, 0, {0,0}}
	, { 4, 2492, 0, {0,0}}
	, { 4, 2496, 0, {0,0}}
	, { 4, 2500, 0, {0,0}}
	, { 4, 2504, 0, {0,0}}
	, { 4, 2508, 0, {0,0}}
	, { 4, 2512, 0, {0,0}}
	, { 4, 2516, 0, {0,0}}
	, { 4, 2520, 0, {0,0}}
	, { 4, 2524, 0, {0,0}}
	, { 4, 2528, 0, {0,0}}
	, { 4, 2532, 0, {0,0}}
	, { 4, 2536, 0, {0,0}}
	, { 4, 2540, 0, {0,0}}
	, { 4, 2544, 0, {0,0}}
	, { 4, 2548, 0, {0,0}}
	, { 4, 2552, 0, {0,0}}
	, { 4, 2556, 0, {0,0}}
	, { 4, 2560, 0, {0,0}}
	, { 4, 2564, 0, {0,0}}
	, { 4, 2568, 0, {0,0}}
	, { 4, 2572, 0, {0,0}}
	, { 4, 2576, 0, {0,0}}
	, { 4, 2580, 0, {0,0}}
	, { 4, 2584, 0, {0,0}}
	, { 4, 2588, 0, {0,0}}
	, { 4, 2592, 0, {0,0}}
	, { 4, 2596, 0, {0,0}}
	, { 4, 2600, 0, {0,0}}
	, { 4, 2604, 0, {0,0}}
	, { 4, 2608, 0, {0,0}}
	, { 4, 2612, 0, {0,0}}
	, { 4, 2616, 0, {0,0}}
	, { 4, 2620, 0, {0,0}}
	, { 4, 2624, 0, {0,0}}
	, { 4, 2628, 0, {0,0}}
	, { 4, 2632, 0, {0,0}}
	, { 4, 2636, 0, {0,0}}
	, { 4, 2640, 0, {0,0}}
	, { 4, 2644, 0, {0,0}}
	, { 4, 2648, 0, {0,0}}
	, { 4, 2652, 0, {0,0}}
	, { 4, 2656, 0, {0,0}}
	, { 4, 2660, 0, {0,0}}
	, { 4, 2664, 0, {0,0}}
	, { 4, 2668, 0, {0,0}}
	, { 4, 2672, 0, {0,0}}
	, { 4, 2676, 0, {0,0}}
	, { 4, 2680, 0, {0,0}}
	, { 4, 2684, 0, {0,0}}
	, { 4, 2688, 0, {0,0}}
	, { 4, 2692, 0, {0,0}}
	, { 4, 2696, 0, {0,0}}
	, { 4, 2700, 0, {0,0}}
	, { 4, 2704, 0, {0,0}}
	, { 4, 2708, 0, {0,0}}
	, { 4, 2712, 0, {0,0}}
	, { 4, 2716, 0, {0,0}}
	, { 4, 2720, 0, {0,0}}
	, { 4, 2724, 0, {0,0}}
	, { 4, 2728, 0, {0,0}}
	, { 4, 2732, 0, {0,0}}
	, { 4, 2736, 0, {0,0}}
	, { 4, 2740, 0, {0,0}}
	, { 4, 2744, 0, {0,0}}
	, { 4, 2748, 0, {0,0}}
	, { 4, 2752, 0, {0,0}}
	, { 4, 2756, 0, {0,0}}
	, { 4, 2760, 0, {0,0}}
	, { 4, 2764, 0, {0,0}}
	, { 4, 2768, 0, {0,0}}
	, { 4, 2772, 0, {0,0}}
	, { 4, 2776, 0, {0,0}}
	, { 4, 2780, 0, {0,0}}
	, { 4, 2784, 0, {0,0}}
	, { 4, 2788, 0, {0,0}}
	, { 4, 2792, 0, {0,0}}
	, { 4, 2796, 0, {0,0}}
	, { 4, 2800, 0, {0,0}}
	, { 4, 2804, 0, {0,0}}
	, { 4, 2808, 0, {0,0}}
	, { 4, 2812, 0, {0,0}}
	, { 4, 2816, 0, {0,0}}
	, { 4, 2820, 0, {0,0}}
	, { 4, 2824, 0, {0,0}}
	, { 4, 2828, 0, {0,0}}
	, { 4, 2832, 0, {0,0}}
	, { 4, 2836, 0, {0,0}}
	, { 4, 2840, 0, {0,0}}
	, { 4, 2844, 0, {0,0}}
	, { 4, 2848, 0, {0,0}}
	, { 4, 2852, 0, {0,0}}
	, { 4, 2856, 0, {0,0}}
	, { 4, 2860, 0, {0,0}}
	, { 4, 2864, 0, {0,0}}
	, { 4, 2868, 0, {0,0}}
	, { 4, 2872, 0, {0,0}}
	, { 4, 2876, 0, {0,0}}
	, { 4, 2880, 0, {0,0}}
	, { 4, 2884, 0, {0,0}}
	, { 4, 2888, 0, {0,0}}
	, { 4, 2892, 0, {0,0}}
	, { 4, 2896, 0, {0,0}}
	, { 4, 2900, 0, {0,0}}
	, { 4, 2904, 0, {0,0}}
	, { 4, 2908, 0, {0,0}}
	, { 4, 2912, 0, {0,0}}
	, { 4, 2916, 0, {0,0}}
	, { 4, 2920, 0, {0,0}}
	, { 4, 2924, 0, {0,0}}
	, { 4, 2928, 0, {0,0}}
	, { 4, 2932, 0, {0,0}}
	, { 4, 2936, 0, {0,0}}
	, { 4, 2940, 0, {0,0}}
	, { 4, 2944, 0, {0,0}}
	, { 4, 2948, 0, {0,0}}
	, { 4, 2952, 0, {0,0}}
	, { 4, 2956, 0, {0,0}}
	, { 4, 2960, 0, {0,0}}
	, { 4, 2964, 0, {0,0}}
	, { 4, 2968, 0, {0,0}}
	, { 4, 2972, 0, {0,0}}
	, { 4, 2976, 0, {0,0}}
	, { 4, 2980, 0, {0,0}}
	, { 4, 2984, 0, {0,0}}
	, { 4, 2988, 0, {0,0}}
	, { 4, 2992, 0, {0,0}}
	, { 4, 2996, 0, {0,0}}
	, { 4, 3000, 0, {0,0}}
	, { 4, 3004, 0, {0,0}}
	, { 4, 3008, 0, {0,0}}
	, { 4, 3012, 0, {0,0}}
	, { 4, 3016, 0, {0,0}}
	, { 4, 3020, 0, {0,0}}
	, { 4, 3024, 0, {0,0}}
	, { 4, 3028, 0, {0,0}}
	, { 4, 3032, 0, {0,0}}
	, { 4, 3036, 0, {0,0}}
	, { 4, 3040, 0, {0,0}}
	, { 4, 3044, 0, {0,0}}
	, { 4, 3048, 0, {0,0}}
	, { 4, 3052, 0, {0,0}}
	, { 4, 3056, 0, {0,0}}
	, { 6, 14, 2, {0,0}}
	, { 6, 14, 2, {0,1}}
	, { 6, 14, 2, {0,2}}
	, { 6, 14, 2, {0,3}}
	, { 6, 14, 2, {0,4}}
	, { 6, 14, 2, {0,5}}
	, { 6, 14, 2, {0,6}}
	, { 6, 14, 2, {0,7}}
	, { 6, 14, 2, {0,8}}
	, { 6, 14, 2, {0,9}}
	, { 6, 14, 2, {0,10}}
	, { 6, 14, 2, {0,11}}
	, { 6, 14, 2, {0,12}}
	, { 6, 14, 2, {0,13}}
	, { 6, 14, 2, {0,14}}
	, { 6, 14, 2, {0,15}}
	, { 6, 14, 2, {0,16}}
	, { 6, 14, 2, {0,17}}
	, { 6, 14, 2, {0,18}}
	, { 6, 14, 2, {0,19}}
	, { 6, 14, 2, {0,20}}
	, { 6, 14, 2, {0,21}}
	, { 6, 14, 2, {0,22}}
	, { 6, 14, 2, {0,23}}
	, { 6, 14, 2, {0,24}}
	, { 6, 14, 2, {0,25}}
	, { 6, 14, 2, {0,26}}
	, { 6, 14, 2, {0,27}}
	, { 6, 14, 2, {0,28}}
	, { 6, 14, 2, {0,29}}
	, { 6, 14, 2, {0,30}}
	, { 6, 14, 2, {0,31}}
	, { 6, 14, 2, {0,32}}
	, { 6, 14, 2, {0,33}}
	, { 6, 14, 2, {0,34}}
	, { 6, 14, 2, {0,35}}
	, { 6, 14, 2, {0,36}}
	, { 6, 14, 2, {0,37}}
	, { 6, 14, 2, {0,38}}
	, { 6, 14, 2, {0,39}}
	, { 6, 14, 2, {0,40}}
	, { 6, 14, 2, {0,41}}
	, { 6, 14, 2, {0,42}}
	, { 6, 14, 2, {0,43}}
	, { 6, 14, 2, {0,44}}
	, { 6, 14, 2, {0,45}}
	, { 6, 14, 2, {0,46}}
	, { 6, 14, 2, {0,47}}
	, { 6, 14, 2, {0,48}}
	, { 6, 14, 2, {0,49}}
	, { 6, 14, 2, {0,50}}
	, { 6, 14, 2, {0,51}}
	, { 6, 14, 2, {0,52}}
	, { 6, 14, 2, {0,53}}
	, { 6, 14, 2, {0,54}}
	, { 6, 14, 2, {0,55}}
	, { 6, 14, 2, {0,56}}
	, { 6, 14, 2, {0,57}}
	, { 6, 14, 2, {0,58}}
	, { 6, 14, 2, {0,59}}
	, { 6, 14, 2, {0,60}}
	, { 6, 14, 2, {0,61}}
	, { 6, 14, 2, {0,62}}
	, { 6, 14, 2, {0,63}}
	, { 6, 14, 2, {0,64}}
	, { 6, 14, 2, {0,65}}
	, { 6, 14, 2, {0,66}}
	, { 6, 14, 2, {0,67}}
	, { 6, 14, 2, {0,68}}
	, { 6, 14, 2, {0,69}}
	, { 6, 14, 2, {0,70}}
	, { 6, 14, 2, {0,71}}
	, { 6, 14, 2, {0,72}}
	, { 6, 14, 2, {0,73}}
	, { 6, 14, 2, {0,74}}
	, { 6, 14, 2, {0,75}}
	, { 6, 14, 2, {0,76}}
	, { 6, 14, 2, {0,77}}
	, { 6, 14, 2, {0,78}}
	, { 6, 14, 2, {0,79}}
	, { 6, 14, 2, {0,80}}
	, { 6, 14, 2, {0,81}}
	, { 6, 14, 2, {0,82}}
	, { 6, 14, 2, {0,83}}
	, { 6, 14, 2, {0,84}}
	, { 6, 14, 2, {0,85}}
	, { 6, 14, 2, {0,86}}
	, { 6, 14, 2, {0,87}}
	, { 6, 14, 2, {0,88}}
	, { 6, 14, 2, {0,89}}
	, { 6, 14, 2, {0,90}}
	, { 6, 14, 2, {0,91}}
	, { 6, 14, 2, {0,92}}
	, { 6, 14, 2, {0,93}}
	, { 6, 14, 2, {0,94}}
	, { 6, 14, 2, {0,95}}
	, { 6, 14, 2, {0,96}}
	, { 6, 14, 2, {0,97}}
	, { 6, 14, 2, {0,98}}
	, { 6, 14, 2, {0,99}}
	, { 6, 14, 2, {0,100}}
	, { 6, 14, 2, {0,101}}
	, { 6, 14, 2, {0,102}}
	, { 6, 14, 2, {0,103}}
	, { 6, 14, 2, {0,104}}
	, { 6, 14, 2, {0,105}}
	, { 6, 14, 2, {0,106}}
	, { 6, 14, 2, {0,107}}
	, { 6, 14, 2, {0,108}}
	, { 6, 14, 2, {0,109}}
	, { 6, 14, 2, {0,110}}
	, { 6, 14, 2, {0,111}}
	, { 6, 14, 2, {0,112}}
	, { 6, 14, 2, {0,113}}
	, { 6, 14, 2, {0,114}}
	, { 6, 14, 2, {0,115}}
	, { 6, 14, 2, {0,116}}
	, { 6, 14, 2, {0,117}}
	, { 6, 14, 2, {0,118}}
	, { 6, 14, 2, {0,119}}
	, { 6, 14, 2, {0,120}}
	, { 6, 14, 2, {0,121}}
	, { 6, 14, 2, {0,122}}
	, { 6, 14, 2, {0,123}}
	, { 6, 14, 2, {0,124}}
	, { 6, 14, 2, {0,125}}
	, { 6, 14, 2, {0,126}}
	, { 6, 14, 2, {0,127}}
	, { 6, 14, 2, {0,128}}
	, { 6, 14, 2, {0,129}}
	, { 6, 14, 2, {0,130}}
	, { 6, 14, 2, {0,131}}
	, { 6, 14, 2, {0,132}}
	, { 6, 14, 2, {0,133}}
	, { 6, 14, 2, {0,134}}
	, { 6, 14, 2, {0,135}}
	, { 6, 14, 2, {0,136}}
	, { 6, 14, 2, {0,137}}
	, { 6, 14, 2, {0,138}}
	, { 6, 14, 2, {0,139}}
	, { 6, 14, 2, {0,140}}
	, { 6, 14, 2, {0,141}}
	, { 6, 14, 2, {0,142}}
	, { 6, 14, 2, {0,143}}
	, { 6, 14, 2, {0,144}}
	, { 6, 14, 2, {0,145}}
	, { 6, 14, 2, {0,146}}
	, { 6, 14, 2, {0,147}}
	, { 6, 14, 2, {0,148}}
	, { 6, 14, 2, {0,149}}
	, { 6, 14, 2, {0,150}}
	, { 6, 14, 2, {0,151}}
	, { 6, 14, 2, {0,152}}
	, { 6, 14, 2, {0,153}}
	, { 6, 14, 2, {0,154}}
	, { 6, 14, 2, {0,155}}
	, { 6, 14, 2, {0,156}}
	, { 6, 14, 2, {0,157}}
	, { 6, 14, 2, {0,158}}
	, { 6, 14, 2, {0,159}}
	, { 6, 14, 2, {0,160}}
	, { 6, 14, 2, {0,161}}
	, { 6, 14, 2, {0,162}}
	, { 6, 14, 2, {0,163}}
	, { 6, 14, 2, {0,164}}
	, { 6, 14, 2, {0,165}}
	, { 6, 14, 2, {0,166}}
	, { 6, 14, 2, {0,167}}
	, { 6, 14, 2, {0,168}}
	, { 6, 14, 2, {0,169}}
	, { 6, 14, 2, {0,170}}
	, { 6, 14, 2, {0,171}}
	, { 6, 14, 2, {0,172}}
	, { 6, 14, 2, {0,173}}
	, { 6, 14, 2, {0,174}}
	, { 6, 14, 2, {0,175}}
	, { 6, 14, 2, {0,176}}
	, { 6, 14, 2, {0,177}}
	, { 6, 14, 2, {0,178}}
	, { 6, 14, 2, {0,179}}
	, { 6, 14, 2, {0,180}}
	, { 6, 14, 2, {0,181}}
	, { 6, 14, 2, {0,182}}
	, { 6, 14, 2, {0,183}}
	, { 6, 14, 2, {0,184}}
	, { 6, 14, 2, {0,185}}
	, { 6, 14, 2, {0,186}}
	, { 6, 14, 2, {0,187}}
	, { 6, 14, 2, {0,188}}
	, { 6, 14, 2, {0,189}}
	, { 6, 14, 2, {0,190}}
	, { 6, 14, 2, {0,191}}
	, { 6, 14, 2, {0,192}}
	, { 6, 14, 2, {0,193}}
	, { 6, 14, 2, {0,194}}
	, { 6, 14, 2, {0,195}}
	, { 6, 14, 2, {0,196}}
	, { 6, 14, 2, {0,197}}
	, { 6, 14, 2, {0,198}}
	, { 6, 14, 2, {0,199}}
	, { 6, 14, 2, {0,200}}
	, { 6, 14, 2, {0,201}}
	, { 6, 14, 2, {0,202}}
	, { 6, 14, 2, {0,203}}
	, { 6, 14, 2, {0,204}}
	, { 6, 14, 2, {0,205}}
	, { 6, 14, 2, {0,206}}
	, { 6, 14, 2, {0,207}}
	, { 6, 14, 2, {0,208}}
	, { 6, 14, 2, {0,209}}
	, { 6, 14, 2, {0,210}}
	, { 6, 14, 2, {0,211}}
	, { 6, 14, 2, {0,212}}
	, { 6, 14, 2, {0,213}}
	, { 6, 14, 2, {0,214}}
	, { 6, 14, 2, {0,215}}
	, { 6, 14, 2, {0,216}}
	, { 6, 14, 2, {0,217}}
	, { 6, 14, 2, {0,218}}
	, { 6, 14, 2, {0,219}}
	, { 6, 14, 2, {0,220}}
	, { 6, 14, 2, {0,221}}
	, { 6, 14, 2, {0,222}}
	, { 6, 14, 2, {0,223}}
	, { 6, 14, 2, {0,224}}
	, { 6, 14, 2, {0,225}}
	, { 6, 14, 2, {0,226}}
	, { 6, 14, 2, {0,227}}
	, { 6, 14, 2, {0,228}}
	, { 6, 14, 2, {0,229}}
	, { 6, 14, 2, {0,230}}
	, { 6, 14, 2, {0,231}}
	, { 6, 14, 2, {0,232}}
	, { 6, 14, 2, {0,233}}
	, { 6, 14, 2, {0,234}}
	, { 6, 14, 2, {0,235}}
	, { 6, 14, 2, {0,236}}
	, { 6, 14, 2, {0,237}}
	, { 6, 14, 2, {0,238}}
	, { 6, 14, 2, {0,239}}
	, { 6, 14, 2, {0,240}}
	, { 6, 14, 2, {0,241}}
	, { 6, 14, 2, {0,242}}
	, { 6, 14, 2, {0,243}}
	, { 6, 14, 2, {0,244}}
	, { 6, 14, 2, {0,245}}
	, { 6, 14, 2, {0,246}}
	, { 6, 14, 2, {0,247}}
	, { 6, 14, 2, {0,248}}
	, { 6, 14, 2, {0,249}}
	, { 6, 14, 2, {0,250}}
	, { 6, 14, 2, {0,251}}
	, { 6, 14, 2, {0,252}}
	, { 6, 14, 2, {0,253}}
	, { 6, 14, 2, {0,254}}
	, { 6, 14, 2, {0,255}}
	, { 6, 14, 2, {0,256}}
	, { 6, 14, 2, {0,257}}
	, { 6, 14, 2, {0,258}}
	, { 6, 14, 2, {0,259}}
	, { 6, 14, 2, {0,260}}
	, { 6, 14, 2, {0,261}}
	, { 6, 14, 2, {0,262}}
	, { 6, 14, 2, {0,263}}
	, { 6, 14, 2, {0,264}}
	, { 6, 14, 2, {0,265}}
	, { 6, 14, 2, {0,266}}
	, { 6, 14, 2, {0,267}}
	, { 6, 14, 2, {0,268}}
	, { 6, 14, 2, {0,269}}
	, { 6, 14, 2, {0,270}}
	, { 6, 14, 2, {0,271}}
	, { 10, 6, 1, {327681,0}}
	, { 10, 6, 1, {327937,0}}
	, { 10, 6, 1, {328193,0}}
	, { 10, 6, 1, {328449,0}}
	, { 10, 6, 1, {328705,0}}
	, { 10, 6, 1, {328961,0}}
	, { 10, 6, 1, {329217,0}}
	, { 10, 6, 1, {329473,0}}
	, { 10, 6, 1, {329729,0}}
	, { 10, 6, 1, {329985,0}}
	, { 10, 6, 1, {330241,0}}
	, { 10, 6, 1, {330497,0}}};

static const struct vfc_read_task vfc_task_x_e2 = {vfc_vectors_x_e2, 1049};



static const struct igu_data igu_address_e2 = {
	1, 10, 0x130034, 0x130130, { 0x00130178, 0x0013017c}
};





static const u32 timer_status_regs_e3[] = { 0x164014, 0x164018};
static const u32 timer_scan_regs_e3[] = { 0x1640d0, 0x1640d4};

#define TIMER_REGS_COUNT_E3 ARRSIZE(timer_status_regs_e3)

static const struct vfc_general vfc_general_x_e3 = {
	1, 0x2b8fd0, 0x2b8fc8, 0x2b8fc4, 0x2b8fcc
};
static const struct vfc_general vfc_general_t_e3 = {
	1, 0x1b8fd0, 0x1b8fc8, 0x1b8fc4, 0x1b8fcc
};
static const struct vfc_read_write_vector vfc_vectors_t_e3[1049] = {
	{ 4, 0, 0, {0,0}}
	, { 4, 4, 0, {0,0}}
	, { 4, 8, 0, {0,0}}
	, { 4, 12, 0, {0,0}}
	, { 4, 16, 0, {0,0}}
	, { 4, 20, 0, {0,0}}
	, { 4, 24, 0, {0,0}}
	, { 4, 28, 0, {0,0}}
	, { 4, 32, 0, {0,0}}
	, { 4, 36, 0, {0,0}}
	, { 4, 40, 0, {0,0}}
	, { 4, 44, 0, {0,0}}
	, { 4, 48, 0, {0,0}}
	, { 4, 52, 0, {0,0}}
	, { 4, 56, 0, {0,0}}
	, { 4, 60, 0, {0,0}}
	, { 4, 64, 0, {0,0}}
	, { 4, 68, 0, {0,0}}
	, { 4, 72, 0, {0,0}}
	, { 4, 76, 0, {0,0}}
	, { 4, 80, 0, {0,0}}
	, { 4, 84, 0, {0,0}}
	, { 4, 88, 0, {0,0}}
	, { 4, 92, 0, {0,0}}
	, { 4, 96, 0, {0,0}}
	, { 4, 100, 0, {0,0}}
	, { 4, 104, 0, {0,0}}
	, { 4, 108, 0, {0,0}}
	, { 4, 112, 0, {0,0}}
	, { 4, 116, 0, {0,0}}
	, { 4, 120, 0, {0,0}}
	, { 4, 124, 0, {0,0}}
	, { 4, 128, 0, {0,0}}
	, { 4, 132, 0, {0,0}}
	, { 4, 136, 0, {0,0}}
	, { 4, 140, 0, {0,0}}
	, { 4, 144, 0, {0,0}}
	, { 4, 148, 0, {0,0}}
	, { 4, 152, 0, {0,0}}
	, { 4, 156, 0, {0,0}}
	, { 4, 160, 0, {0,0}}
	, { 4, 164, 0, {0,0}}
	, { 4, 168, 0, {0,0}}
	, { 4, 172, 0, {0,0}}
	, { 4, 176, 0, {0,0}}
	, { 4, 180, 0, {0,0}}
	, { 4, 184, 0, {0,0}}
	, { 4, 188, 0, {0,0}}
	, { 4, 192, 0, {0,0}}
	, { 4, 196, 0, {0,0}}
	, { 4, 200, 0, {0,0}}
	, { 4, 204, 0, {0,0}}
	, { 4, 208, 0, {0,0}}
	, { 4, 212, 0, {0,0}}
	, { 4, 216, 0, {0,0}}
	, { 4, 220, 0, {0,0}}
	, { 4, 224, 0, {0,0}}
	, { 4, 228, 0, {0,0}}
	, { 4, 232, 0, {0,0}}
	, { 4, 236, 0, {0,0}}
	, { 4, 240, 0, {0,0}}
	, { 4, 244, 0, {0,0}}
	, { 4, 248, 0, {0,0}}
	, { 4, 252, 0, {0,0}}
	, { 4, 256, 0, {0,0}}
	, { 4, 260, 0, {0,0}}
	, { 4, 264, 0, {0,0}}
	, { 4, 268, 0, {0,0}}
	, { 4, 272, 0, {0,0}}
	, { 4, 276, 0, {0,0}}
	, { 4, 280, 0, {0,0}}
	, { 4, 284, 0, {0,0}}
	, { 4, 288, 0, {0,0}}
	, { 4, 292, 0, {0,0}}
	, { 4, 296, 0, {0,0}}
	, { 4, 300, 0, {0,0}}
	, { 4, 304, 0, {0,0}}
	, { 4, 308, 0, {0,0}}
	, { 4, 312, 0, {0,0}}
	, { 4, 316, 0, {0,0}}
	, { 4, 320, 0, {0,0}}
	, { 4, 324, 0, {0,0}}
	, { 4, 328, 0, {0,0}}
	, { 4, 332, 0, {0,0}}
	, { 4, 336, 0, {0,0}}
	, { 4, 340, 0, {0,0}}
	, { 4, 344, 0, {0,0}}
	, { 4, 348, 0, {0,0}}
	, { 4, 352, 0, {0,0}}
	, { 4, 356, 0, {0,0}}
	, { 4, 360, 0, {0,0}}
	, { 4, 364, 0, {0,0}}
	, { 4, 368, 0, {0,0}}
	, { 4, 372, 0, {0,0}}
	, { 4, 376, 0, {0,0}}
	, { 4, 380, 0, {0,0}}
	, { 4, 384, 0, {0,0}}
	, { 4, 388, 0, {0,0}}
	, { 4, 392, 0, {0,0}}
	, { 4, 396, 0, {0,0}}
	, { 4, 400, 0, {0,0}}
	, { 4, 404, 0, {0,0}}
	, { 4, 408, 0, {0,0}}
	, { 4, 412, 0, {0,0}}
	, { 4, 416, 0, {0,0}}
	, { 4, 420, 0, {0,0}}
	, { 4, 424, 0, {0,0}}
	, { 4, 428, 0, {0,0}}
	, { 4, 432, 0, {0,0}}
	, { 4, 436, 0, {0,0}}
	, { 4, 440, 0, {0,0}}
	, { 4, 444, 0, {0,0}}
	, { 4, 448, 0, {0,0}}
	, { 4, 452, 0, {0,0}}
	, { 4, 456, 0, {0,0}}
	, { 4, 460, 0, {0,0}}
	, { 4, 464, 0, {0,0}}
	, { 4, 468, 0, {0,0}}
	, { 4, 472, 0, {0,0}}
	, { 4, 476, 0, {0,0}}
	, { 4, 480, 0, {0,0}}
	, { 4, 484, 0, {0,0}}
	, { 4, 488, 0, {0,0}}
	, { 4, 492, 0, {0,0}}
	, { 4, 496, 0, {0,0}}
	, { 4, 500, 0, {0,0}}
	, { 4, 504, 0, {0,0}}
	, { 4, 508, 0, {0,0}}
	, { 4, 512, 0, {0,0}}
	, { 4, 516, 0, {0,0}}
	, { 4, 520, 0, {0,0}}
	, { 4, 524, 0, {0,0}}
	, { 4, 528, 0, {0,0}}
	, { 4, 532, 0, {0,0}}
	, { 4, 536, 0, {0,0}}
	, { 4, 540, 0, {0,0}}
	, { 4, 544, 0, {0,0}}
	, { 4, 548, 0, {0,0}}
	, { 4, 552, 0, {0,0}}
	, { 4, 556, 0, {0,0}}
	, { 4, 560, 0, {0,0}}
	, { 4, 564, 0, {0,0}}
	, { 4, 568, 0, {0,0}}
	, { 4, 572, 0, {0,0}}
	, { 4, 576, 0, {0,0}}
	, { 4, 580, 0, {0,0}}
	, { 4, 584, 0, {0,0}}
	, { 4, 588, 0, {0,0}}
	, { 4, 592, 0, {0,0}}
	, { 4, 596, 0, {0,0}}
	, { 4, 600, 0, {0,0}}
	, { 4, 604, 0, {0,0}}
	, { 4, 608, 0, {0,0}}
	, { 4, 612, 0, {0,0}}
	, { 4, 616, 0, {0,0}}
	, { 4, 620, 0, {0,0}}
	, { 4, 624, 0, {0,0}}
	, { 4, 628, 0, {0,0}}
	, { 4, 632, 0, {0,0}}
	, { 4, 636, 0, {0,0}}
	, { 4, 640, 0, {0,0}}
	, { 4, 644, 0, {0,0}}
	, { 4, 648, 0, {0,0}}
	, { 4, 652, 0, {0,0}}
	, { 4, 656, 0, {0,0}}
	, { 4, 660, 0, {0,0}}
	, { 4, 664, 0, {0,0}}
	, { 4, 668, 0, {0,0}}
	, { 4, 672, 0, {0,0}}
	, { 4, 676, 0, {0,0}}
	, { 4, 680, 0, {0,0}}
	, { 4, 684, 0, {0,0}}
	, { 4, 688, 0, {0,0}}
	, { 4, 692, 0, {0,0}}
	, { 4, 696, 0, {0,0}}
	, { 4, 700, 0, {0,0}}
	, { 4, 704, 0, {0,0}}
	, { 4, 708, 0, {0,0}}
	, { 4, 712, 0, {0,0}}
	, { 4, 716, 0, {0,0}}
	, { 4, 720, 0, {0,0}}
	, { 4, 724, 0, {0,0}}
	, { 4, 728, 0, {0,0}}
	, { 4, 732, 0, {0,0}}
	, { 4, 736, 0, {0,0}}
	, { 4, 740, 0, {0,0}}
	, { 4, 744, 0, {0,0}}
	, { 4, 748, 0, {0,0}}
	, { 4, 752, 0, {0,0}}
	, { 4, 756, 0, {0,0}}
	, { 4, 760, 0, {0,0}}
	, { 4, 764, 0, {0,0}}
	, { 4, 768, 0, {0,0}}
	, { 4, 772, 0, {0,0}}
	, { 4, 776, 0, {0,0}}
	, { 4, 780, 0, {0,0}}
	, { 4, 784, 0, {0,0}}
	, { 4, 788, 0, {0,0}}
	, { 4, 792, 0, {0,0}}
	, { 4, 796, 0, {0,0}}
	, { 4, 800, 0, {0,0}}
	, { 4, 804, 0, {0,0}}
	, { 4, 808, 0, {0,0}}
	, { 4, 812, 0, {0,0}}
	, { 4, 816, 0, {0,0}}
	, { 4, 820, 0, {0,0}}
	, { 4, 824, 0, {0,0}}
	, { 4, 828, 0, {0,0}}
	, { 4, 832, 0, {0,0}}
	, { 4, 836, 0, {0,0}}
	, { 4, 840, 0, {0,0}}
	, { 4, 844, 0, {0,0}}
	, { 4, 848, 0, {0,0}}
	, { 4, 852, 0, {0,0}}
	, { 4, 856, 0, {0,0}}
	, { 4, 860, 0, {0,0}}
	, { 4, 864, 0, {0,0}}
	, { 4, 868, 0, {0,0}}
	, { 4, 872, 0, {0,0}}
	, { 4, 876, 0, {0,0}}
	, { 4, 880, 0, {0,0}}
	, { 4, 884, 0, {0,0}}
	, { 4, 888, 0, {0,0}}
	, { 4, 892, 0, {0,0}}
	, { 4, 896, 0, {0,0}}
	, { 4, 900, 0, {0,0}}
	, { 4, 904, 0, {0,0}}
	, { 4, 908, 0, {0,0}}
	, { 4, 912, 0, {0,0}}
	, { 4, 916, 0, {0,0}}
	, { 4, 920, 0, {0,0}}
	, { 4, 924, 0, {0,0}}
	, { 4, 928, 0, {0,0}}
	, { 4, 932, 0, {0,0}}
	, { 4, 936, 0, {0,0}}
	, { 4, 940, 0, {0,0}}
	, { 4, 944, 0, {0,0}}
	, { 4, 948, 0, {0,0}}
	, { 4, 952, 0, {0,0}}
	, { 4, 956, 0, {0,0}}
	, { 4, 960, 0, {0,0}}
	, { 4, 964, 0, {0,0}}
	, { 4, 968, 0, {0,0}}
	, { 4, 972, 0, {0,0}}
	, { 4, 976, 0, {0,0}}
	, { 4, 980, 0, {0,0}}
	, { 4, 984, 0, {0,0}}
	, { 4, 988, 0, {0,0}}
	, { 4, 992, 0, {0,0}}
	, { 4, 996, 0, {0,0}}
	, { 4, 1000, 0, {0,0}}
	, { 4, 1004, 0, {0,0}}
	, { 4, 1008, 0, {0,0}}
	, { 4, 1012, 0, {0,0}}
	, { 4, 1016, 0, {0,0}}
	, { 4, 1020, 0, {0,0}}
	, { 4, 1024, 0, {0,0}}
	, { 4, 1028, 0, {0,0}}
	, { 4, 1032, 0, {0,0}}
	, { 4, 1036, 0, {0,0}}
	, { 4, 1040, 0, {0,0}}
	, { 4, 1044, 0, {0,0}}
	, { 4, 1048, 0, {0,0}}
	, { 4, 1052, 0, {0,0}}
	, { 4, 1056, 0, {0,0}}
	, { 4, 1060, 0, {0,0}}
	, { 4, 1064, 0, {0,0}}
	, { 4, 1068, 0, {0,0}}
	, { 4, 1072, 0, {0,0}}
	, { 4, 1076, 0, {0,0}}
	, { 4, 1080, 0, {0,0}}
	, { 4, 1084, 0, {0,0}}
	, { 4, 1088, 0, {0,0}}
	, { 4, 1092, 0, {0,0}}
	, { 4, 1096, 0, {0,0}}
	, { 4, 1100, 0, {0,0}}
	, { 4, 1104, 0, {0,0}}
	, { 4, 1108, 0, {0,0}}
	, { 4, 1112, 0, {0,0}}
	, { 4, 1116, 0, {0,0}}
	, { 4, 1120, 0, {0,0}}
	, { 4, 1124, 0, {0,0}}
	, { 4, 1128, 0, {0,0}}
	, { 4, 1132, 0, {0,0}}
	, { 4, 1136, 0, {0,0}}
	, { 4, 1140, 0, {0,0}}
	, { 4, 1144, 0, {0,0}}
	, { 4, 1148, 0, {0,0}}
	, { 4, 1152, 0, {0,0}}
	, { 4, 1156, 0, {0,0}}
	, { 4, 1160, 0, {0,0}}
	, { 4, 1164, 0, {0,0}}
	, { 4, 1168, 0, {0,0}}
	, { 4, 1172, 0, {0,0}}
	, { 4, 1176, 0, {0,0}}
	, { 4, 1180, 0, {0,0}}
	, { 4, 1184, 0, {0,0}}
	, { 4, 1188, 0, {0,0}}
	, { 4, 1192, 0, {0,0}}
	, { 4, 1196, 0, {0,0}}
	, { 4, 1200, 0, {0,0}}
	, { 4, 1204, 0, {0,0}}
	, { 4, 1208, 0, {0,0}}
	, { 4, 1212, 0, {0,0}}
	, { 4, 1216, 0, {0,0}}
	, { 4, 1220, 0, {0,0}}
	, { 4, 1224, 0, {0,0}}
	, { 4, 1228, 0, {0,0}}
	, { 4, 1232, 0, {0,0}}
	, { 4, 1236, 0, {0,0}}
	, { 4, 1240, 0, {0,0}}
	, { 4, 1244, 0, {0,0}}
	, { 4, 1248, 0, {0,0}}
	, { 4, 1252, 0, {0,0}}
	, { 4, 1256, 0, {0,0}}
	, { 4, 1260, 0, {0,0}}
	, { 4, 1264, 0, {0,0}}
	, { 4, 1268, 0, {0,0}}
	, { 4, 1272, 0, {0,0}}
	, { 4, 1276, 0, {0,0}}
	, { 4, 1280, 0, {0,0}}
	, { 4, 1284, 0, {0,0}}
	, { 4, 1288, 0, {0,0}}
	, { 4, 1292, 0, {0,0}}
	, { 4, 1296, 0, {0,0}}
	, { 4, 1300, 0, {0,0}}
	, { 4, 1304, 0, {0,0}}
	, { 4, 1308, 0, {0,0}}
	, { 4, 1312, 0, {0,0}}
	, { 4, 1316, 0, {0,0}}
	, { 4, 1320, 0, {0,0}}
	, { 4, 1324, 0, {0,0}}
	, { 4, 1328, 0, {0,0}}
	, { 4, 1332, 0, {0,0}}
	, { 4, 1336, 0, {0,0}}
	, { 4, 1340, 0, {0,0}}
	, { 4, 1344, 0, {0,0}}
	, { 4, 1348, 0, {0,0}}
	, { 4, 1352, 0, {0,0}}
	, { 4, 1356, 0, {0,0}}
	, { 4, 1360, 0, {0,0}}
	, { 4, 1364, 0, {0,0}}
	, { 4, 1368, 0, {0,0}}
	, { 4, 1372, 0, {0,0}}
	, { 4, 1376, 0, {0,0}}
	, { 4, 1380, 0, {0,0}}
	, { 4, 1384, 0, {0,0}}
	, { 4, 1388, 0, {0,0}}
	, { 4, 1392, 0, {0,0}}
	, { 4, 1396, 0, {0,0}}
	, { 4, 1400, 0, {0,0}}
	, { 4, 1404, 0, {0,0}}
	, { 4, 1408, 0, {0,0}}
	, { 4, 1412, 0, {0,0}}
	, { 4, 1416, 0, {0,0}}
	, { 4, 1420, 0, {0,0}}
	, { 4, 1424, 0, {0,0}}
	, { 4, 1428, 0, {0,0}}
	, { 4, 1432, 0, {0,0}}
	, { 4, 1436, 0, {0,0}}
	, { 4, 1440, 0, {0,0}}
	, { 4, 1444, 0, {0,0}}
	, { 4, 1448, 0, {0,0}}
	, { 4, 1452, 0, {0,0}}
	, { 4, 1456, 0, {0,0}}
	, { 4, 1460, 0, {0,0}}
	, { 4, 1464, 0, {0,0}}
	, { 4, 1468, 0, {0,0}}
	, { 4, 1472, 0, {0,0}}
	, { 4, 1476, 0, {0,0}}
	, { 4, 1480, 0, {0,0}}
	, { 4, 1484, 0, {0,0}}
	, { 4, 1488, 0, {0,0}}
	, { 4, 1492, 0, {0,0}}
	, { 4, 1496, 0, {0,0}}
	, { 4, 1500, 0, {0,0}}
	, { 4, 1504, 0, {0,0}}
	, { 4, 1508, 0, {0,0}}
	, { 4, 1512, 0, {0,0}}
	, { 4, 1516, 0, {0,0}}
	, { 4, 1520, 0, {0,0}}
	, { 4, 1524, 0, {0,0}}
	, { 4, 1528, 0, {0,0}}
	, { 4, 1532, 0, {0,0}}
	, { 4, 1536, 0, {0,0}}
	, { 4, 1540, 0, {0,0}}
	, { 4, 1544, 0, {0,0}}
	, { 4, 1548, 0, {0,0}}
	, { 4, 1552, 0, {0,0}}
	, { 4, 1556, 0, {0,0}}
	, { 4, 1560, 0, {0,0}}
	, { 4, 1564, 0, {0,0}}
	, { 4, 1568, 0, {0,0}}
	, { 4, 1572, 0, {0,0}}
	, { 4, 1576, 0, {0,0}}
	, { 4, 1580, 0, {0,0}}
	, { 4, 1584, 0, {0,0}}
	, { 4, 1588, 0, {0,0}}
	, { 4, 1592, 0, {0,0}}
	, { 4, 1596, 0, {0,0}}
	, { 4, 1600, 0, {0,0}}
	, { 4, 1604, 0, {0,0}}
	, { 4, 1608, 0, {0,0}}
	, { 4, 1612, 0, {0,0}}
	, { 4, 1616, 0, {0,0}}
	, { 4, 1620, 0, {0,0}}
	, { 4, 1624, 0, {0,0}}
	, { 4, 1628, 0, {0,0}}
	, { 4, 1632, 0, {0,0}}
	, { 4, 1636, 0, {0,0}}
	, { 4, 1640, 0, {0,0}}
	, { 4, 1644, 0, {0,0}}
	, { 4, 1648, 0, {0,0}}
	, { 4, 1652, 0, {0,0}}
	, { 4, 1656, 0, {0,0}}
	, { 4, 1660, 0, {0,0}}
	, { 4, 1664, 0, {0,0}}
	, { 4, 1668, 0, {0,0}}
	, { 4, 1672, 0, {0,0}}
	, { 4, 1676, 0, {0,0}}
	, { 4, 1680, 0, {0,0}}
	, { 4, 1684, 0, {0,0}}
	, { 4, 1688, 0, {0,0}}
	, { 4, 1692, 0, {0,0}}
	, { 4, 1696, 0, {0,0}}
	, { 4, 1700, 0, {0,0}}
	, { 4, 1704, 0, {0,0}}
	, { 4, 1708, 0, {0,0}}
	, { 4, 1712, 0, {0,0}}
	, { 4, 1716, 0, {0,0}}
	, { 4, 1720, 0, {0,0}}
	, { 4, 1724, 0, {0,0}}
	, { 4, 1728, 0, {0,0}}
	, { 4, 1732, 0, {0,0}}
	, { 4, 1736, 0, {0,0}}
	, { 4, 1740, 0, {0,0}}
	, { 4, 1744, 0, {0,0}}
	, { 4, 1748, 0, {0,0}}
	, { 4, 1752, 0, {0,0}}
	, { 4, 1756, 0, {0,0}}
	, { 4, 1760, 0, {0,0}}
	, { 4, 1764, 0, {0,0}}
	, { 4, 1768, 0, {0,0}}
	, { 4, 1772, 0, {0,0}}
	, { 4, 1776, 0, {0,0}}
	, { 4, 1780, 0, {0,0}}
	, { 4, 1784, 0, {0,0}}
	, { 4, 1788, 0, {0,0}}
	, { 4, 1792, 0, {0,0}}
	, { 4, 1796, 0, {0,0}}
	, { 4, 1800, 0, {0,0}}
	, { 4, 1804, 0, {0,0}}
	, { 4, 1808, 0, {0,0}}
	, { 4, 1812, 0, {0,0}}
	, { 4, 1816, 0, {0,0}}
	, { 4, 1820, 0, {0,0}}
	, { 4, 1824, 0, {0,0}}
	, { 4, 1828, 0, {0,0}}
	, { 4, 1832, 0, {0,0}}
	, { 4, 1836, 0, {0,0}}
	, { 4, 1840, 0, {0,0}}
	, { 4, 1844, 0, {0,0}}
	, { 4, 1848, 0, {0,0}}
	, { 4, 1852, 0, {0,0}}
	, { 4, 1856, 0, {0,0}}
	, { 4, 1860, 0, {0,0}}
	, { 4, 1864, 0, {0,0}}
	, { 4, 1868, 0, {0,0}}
	, { 4, 1872, 0, {0,0}}
	, { 4, 1876, 0, {0,0}}
	, { 4, 1880, 0, {0,0}}
	, { 4, 1884, 0, {0,0}}
	, { 4, 1888, 0, {0,0}}
	, { 4, 1892, 0, {0,0}}
	, { 4, 1896, 0, {0,0}}
	, { 4, 1900, 0, {0,0}}
	, { 4, 1904, 0, {0,0}}
	, { 4, 1908, 0, {0,0}}
	, { 4, 1912, 0, {0,0}}
	, { 4, 1916, 0, {0,0}}
	, { 4, 1920, 0, {0,0}}
	, { 4, 1924, 0, {0,0}}
	, { 4, 1928, 0, {0,0}}
	, { 4, 1932, 0, {0,0}}
	, { 4, 1936, 0, {0,0}}
	, { 4, 1940, 0, {0,0}}
	, { 4, 1944, 0, {0,0}}
	, { 4, 1948, 0, {0,0}}
	, { 4, 1952, 0, {0,0}}
	, { 4, 1956, 0, {0,0}}
	, { 4, 1960, 0, {0,0}}
	, { 4, 1964, 0, {0,0}}
	, { 4, 1968, 0, {0,0}}
	, { 4, 1972, 0, {0,0}}
	, { 4, 1976, 0, {0,0}}
	, { 4, 1980, 0, {0,0}}
	, { 4, 1984, 0, {0,0}}
	, { 4, 1988, 0, {0,0}}
	, { 4, 1992, 0, {0,0}}
	, { 4, 1996, 0, {0,0}}
	, { 4, 2000, 0, {0,0}}
	, { 4, 2004, 0, {0,0}}
	, { 4, 2008, 0, {0,0}}
	, { 4, 2012, 0, {0,0}}
	, { 4, 2016, 0, {0,0}}
	, { 4, 2020, 0, {0,0}}
	, { 4, 2024, 0, {0,0}}
	, { 4, 2028, 0, {0,0}}
	, { 4, 2032, 0, {0,0}}
	, { 4, 2036, 0, {0,0}}
	, { 4, 2040, 0, {0,0}}
	, { 4, 2044, 0, {0,0}}
	, { 4, 2048, 0, {0,0}}
	, { 4, 2052, 0, {0,0}}
	, { 4, 2056, 0, {0,0}}
	, { 4, 2060, 0, {0,0}}
	, { 4, 2064, 0, {0,0}}
	, { 4, 2068, 0, {0,0}}
	, { 4, 2072, 0, {0,0}}
	, { 4, 2076, 0, {0,0}}
	, { 4, 2080, 0, {0,0}}
	, { 4, 2084, 0, {0,0}}
	, { 4, 2088, 0, {0,0}}
	, { 4, 2092, 0, {0,0}}
	, { 4, 2096, 0, {0,0}}
	, { 4, 2100, 0, {0,0}}
	, { 4, 2104, 0, {0,0}}
	, { 4, 2108, 0, {0,0}}
	, { 4, 2112, 0, {0,0}}
	, { 4, 2116, 0, {0,0}}
	, { 4, 2120, 0, {0,0}}
	, { 4, 2124, 0, {0,0}}
	, { 4, 2128, 0, {0,0}}
	, { 4, 2132, 0, {0,0}}
	, { 4, 2136, 0, {0,0}}
	, { 4, 2140, 0, {0,0}}
	, { 4, 2144, 0, {0,0}}
	, { 4, 2148, 0, {0,0}}
	, { 4, 2152, 0, {0,0}}
	, { 4, 2156, 0, {0,0}}
	, { 4, 2160, 0, {0,0}}
	, { 4, 2164, 0, {0,0}}
	, { 4, 2168, 0, {0,0}}
	, { 4, 2172, 0, {0,0}}
	, { 4, 2176, 0, {0,0}}
	, { 4, 2180, 0, {0,0}}
	, { 4, 2184, 0, {0,0}}
	, { 4, 2188, 0, {0,0}}
	, { 4, 2192, 0, {0,0}}
	, { 4, 2196, 0, {0,0}}
	, { 4, 2200, 0, {0,0}}
	, { 4, 2204, 0, {0,0}}
	, { 4, 2208, 0, {0,0}}
	, { 4, 2212, 0, {0,0}}
	, { 4, 2216, 0, {0,0}}
	, { 4, 2220, 0, {0,0}}
	, { 4, 2224, 0, {0,0}}
	, { 4, 2228, 0, {0,0}}
	, { 4, 2232, 0, {0,0}}
	, { 4, 2236, 0, {0,0}}
	, { 4, 2240, 0, {0,0}}
	, { 4, 2244, 0, {0,0}}
	, { 4, 2248, 0, {0,0}}
	, { 4, 2252, 0, {0,0}}
	, { 4, 2256, 0, {0,0}}
	, { 4, 2260, 0, {0,0}}
	, { 4, 2264, 0, {0,0}}
	, { 4, 2268, 0, {0,0}}
	, { 4, 2272, 0, {0,0}}
	, { 4, 2276, 0, {0,0}}
	, { 4, 2280, 0, {0,0}}
	, { 4, 2284, 0, {0,0}}
	, { 4, 2288, 0, {0,0}}
	, { 4, 2292, 0, {0,0}}
	, { 4, 2296, 0, {0,0}}
	, { 4, 2300, 0, {0,0}}
	, { 4, 2304, 0, {0,0}}
	, { 4, 2308, 0, {0,0}}
	, { 4, 2312, 0, {0,0}}
	, { 4, 2316, 0, {0,0}}
	, { 4, 2320, 0, {0,0}}
	, { 4, 2324, 0, {0,0}}
	, { 4, 2328, 0, {0,0}}
	, { 4, 2332, 0, {0,0}}
	, { 4, 2336, 0, {0,0}}
	, { 4, 2340, 0, {0,0}}
	, { 4, 2344, 0, {0,0}}
	, { 4, 2348, 0, {0,0}}
	, { 4, 2352, 0, {0,0}}
	, { 4, 2356, 0, {0,0}}
	, { 4, 2360, 0, {0,0}}
	, { 4, 2364, 0, {0,0}}
	, { 4, 2368, 0, {0,0}}
	, { 4, 2372, 0, {0,0}}
	, { 4, 2376, 0, {0,0}}
	, { 4, 2380, 0, {0,0}}
	, { 4, 2384, 0, {0,0}}
	, { 4, 2388, 0, {0,0}}
	, { 4, 2392, 0, {0,0}}
	, { 4, 2396, 0, {0,0}}
	, { 4, 2400, 0, {0,0}}
	, { 4, 2404, 0, {0,0}}
	, { 4, 2408, 0, {0,0}}
	, { 4, 2412, 0, {0,0}}
	, { 4, 2416, 0, {0,0}}
	, { 4, 2420, 0, {0,0}}
	, { 4, 2424, 0, {0,0}}
	, { 4, 2428, 0, {0,0}}
	, { 4, 2432, 0, {0,0}}
	, { 4, 2436, 0, {0,0}}
	, { 4, 2440, 0, {0,0}}
	, { 4, 2444, 0, {0,0}}
	, { 4, 2448, 0, {0,0}}
	, { 4, 2452, 0, {0,0}}
	, { 4, 2456, 0, {0,0}}
	, { 4, 2460, 0, {0,0}}
	, { 4, 2464, 0, {0,0}}
	, { 4, 2468, 0, {0,0}}
	, { 4, 2472, 0, {0,0}}
	, { 4, 2476, 0, {0,0}}
	, { 4, 2480, 0, {0,0}}
	, { 4, 2484, 0, {0,0}}
	, { 4, 2488, 0, {0,0}}
	, { 4, 2492, 0, {0,0}}
	, { 4, 2496, 0, {0,0}}
	, { 4, 2500, 0, {0,0}}
	, { 4, 2504, 0, {0,0}}
	, { 4, 2508, 0, {0,0}}
	, { 4, 2512, 0, {0,0}}
	, { 4, 2516, 0, {0,0}}
	, { 4, 2520, 0, {0,0}}
	, { 4, 2524, 0, {0,0}}
	, { 4, 2528, 0, {0,0}}
	, { 4, 2532, 0, {0,0}}
	, { 4, 2536, 0, {0,0}}
	, { 4, 2540, 0, {0,0}}
	, { 4, 2544, 0, {0,0}}
	, { 4, 2548, 0, {0,0}}
	, { 4, 2552, 0, {0,0}}
	, { 4, 2556, 0, {0,0}}
	, { 4, 2560, 0, {0,0}}
	, { 4, 2564, 0, {0,0}}
	, { 4, 2568, 0, {0,0}}
	, { 4, 2572, 0, {0,0}}
	, { 4, 2576, 0, {0,0}}
	, { 4, 2580, 0, {0,0}}
	, { 4, 2584, 0, {0,0}}
	, { 4, 2588, 0, {0,0}}
	, { 4, 2592, 0, {0,0}}
	, { 4, 2596, 0, {0,0}}
	, { 4, 2600, 0, {0,0}}
	, { 4, 2604, 0, {0,0}}
	, { 4, 2608, 0, {0,0}}
	, { 4, 2612, 0, {0,0}}
	, { 4, 2616, 0, {0,0}}
	, { 4, 2620, 0, {0,0}}
	, { 4, 2624, 0, {0,0}}
	, { 4, 2628, 0, {0,0}}
	, { 4, 2632, 0, {0,0}}
	, { 4, 2636, 0, {0,0}}
	, { 4, 2640, 0, {0,0}}
	, { 4, 2644, 0, {0,0}}
	, { 4, 2648, 0, {0,0}}
	, { 4, 2652, 0, {0,0}}
	, { 4, 2656, 0, {0,0}}
	, { 4, 2660, 0, {0,0}}
	, { 4, 2664, 0, {0,0}}
	, { 4, 2668, 0, {0,0}}
	, { 4, 2672, 0, {0,0}}
	, { 4, 2676, 0, {0,0}}
	, { 4, 2680, 0, {0,0}}
	, { 4, 2684, 0, {0,0}}
	, { 4, 2688, 0, {0,0}}
	, { 4, 2692, 0, {0,0}}
	, { 4, 2696, 0, {0,0}}
	, { 4, 2700, 0, {0,0}}
	, { 4, 2704, 0, {0,0}}
	, { 4, 2708, 0, {0,0}}
	, { 4, 2712, 0, {0,0}}
	, { 4, 2716, 0, {0,0}}
	, { 4, 2720, 0, {0,0}}
	, { 4, 2724, 0, {0,0}}
	, { 4, 2728, 0, {0,0}}
	, { 4, 2732, 0, {0,0}}
	, { 4, 2736, 0, {0,0}}
	, { 4, 2740, 0, {0,0}}
	, { 4, 2744, 0, {0,0}}
	, { 4, 2748, 0, {0,0}}
	, { 4, 2752, 0, {0,0}}
	, { 4, 2756, 0, {0,0}}
	, { 4, 2760, 0, {0,0}}
	, { 4, 2764, 0, {0,0}}
	, { 4, 2768, 0, {0,0}}
	, { 4, 2772, 0, {0,0}}
	, { 4, 2776, 0, {0,0}}
	, { 4, 2780, 0, {0,0}}
	, { 4, 2784, 0, {0,0}}
	, { 4, 2788, 0, {0,0}}
	, { 4, 2792, 0, {0,0}}
	, { 4, 2796, 0, {0,0}}
	, { 4, 2800, 0, {0,0}}
	, { 4, 2804, 0, {0,0}}
	, { 4, 2808, 0, {0,0}}
	, { 4, 2812, 0, {0,0}}
	, { 4, 2816, 0, {0,0}}
	, { 4, 2820, 0, {0,0}}
	, { 4, 2824, 0, {0,0}}
	, { 4, 2828, 0, {0,0}}
	, { 4, 2832, 0, {0,0}}
	, { 4, 2836, 0, {0,0}}
	, { 4, 2840, 0, {0,0}}
	, { 4, 2844, 0, {0,0}}
	, { 4, 2848, 0, {0,0}}
	, { 4, 2852, 0, {0,0}}
	, { 4, 2856, 0, {0,0}}
	, { 4, 2860, 0, {0,0}}
	, { 4, 2864, 0, {0,0}}
	, { 4, 2868, 0, {0,0}}
	, { 4, 2872, 0, {0,0}}
	, { 4, 2876, 0, {0,0}}
	, { 4, 2880, 0, {0,0}}
	, { 4, 2884, 0, {0,0}}
	, { 4, 2888, 0, {0,0}}
	, { 4, 2892, 0, {0,0}}
	, { 4, 2896, 0, {0,0}}
	, { 4, 2900, 0, {0,0}}
	, { 4, 2904, 0, {0,0}}
	, { 4, 2908, 0, {0,0}}
	, { 4, 2912, 0, {0,0}}
	, { 4, 2916, 0, {0,0}}
	, { 4, 2920, 0, {0,0}}
	, { 4, 2924, 0, {0,0}}
	, { 4, 2928, 0, {0,0}}
	, { 4, 2932, 0, {0,0}}
	, { 4, 2936, 0, {0,0}}
	, { 4, 2940, 0, {0,0}}
	, { 4, 2944, 0, {0,0}}
	, { 4, 2948, 0, {0,0}}
	, { 4, 2952, 0, {0,0}}
	, { 4, 2956, 0, {0,0}}
	, { 4, 2960, 0, {0,0}}
	, { 4, 2964, 0, {0,0}}
	, { 4, 2968, 0, {0,0}}
	, { 4, 2972, 0, {0,0}}
	, { 4, 2976, 0, {0,0}}
	, { 4, 2980, 0, {0,0}}
	, { 4, 2984, 0, {0,0}}
	, { 4, 2988, 0, {0,0}}
	, { 4, 2992, 0, {0,0}}
	, { 4, 2996, 0, {0,0}}
	, { 4, 3000, 0, {0,0}}
	, { 4, 3004, 0, {0,0}}
	, { 4, 3008, 0, {0,0}}
	, { 4, 3012, 0, {0,0}}
	, { 4, 3016, 0, {0,0}}
	, { 4, 3020, 0, {0,0}}
	, { 4, 3024, 0, {0,0}}
	, { 4, 3028, 0, {0,0}}
	, { 4, 3032, 0, {0,0}}
	, { 4, 3036, 0, {0,0}}
	, { 4, 3040, 0, {0,0}}
	, { 4, 3044, 0, {0,0}}
	, { 4, 3048, 0, {0,0}}
	, { 4, 3052, 0, {0,0}}
	, { 4, 3056, 0, {0,0}}
	, { 6, 14, 2, {0,0}}
	, { 6, 14, 2, {0,1}}
	, { 6, 14, 2, {0,2}}
	, { 6, 14, 2, {0,3}}
	, { 6, 14, 2, {0,4}}
	, { 6, 14, 2, {0,5}}
	, { 6, 14, 2, {0,6}}
	, { 6, 14, 2, {0,7}}
	, { 6, 14, 2, {0,8}}
	, { 6, 14, 2, {0,9}}
	, { 6, 14, 2, {0,10}}
	, { 6, 14, 2, {0,11}}
	, { 6, 14, 2, {0,12}}
	, { 6, 14, 2, {0,13}}
	, { 6, 14, 2, {0,14}}
	, { 6, 14, 2, {0,15}}
	, { 6, 14, 2, {0,16}}
	, { 6, 14, 2, {0,17}}
	, { 6, 14, 2, {0,18}}
	, { 6, 14, 2, {0,19}}
	, { 6, 14, 2, {0,20}}
	, { 6, 14, 2, {0,21}}
	, { 6, 14, 2, {0,22}}
	, { 6, 14, 2, {0,23}}
	, { 6, 14, 2, {0,24}}
	, { 6, 14, 2, {0,25}}
	, { 6, 14, 2, {0,26}}
	, { 6, 14, 2, {0,27}}
	, { 6, 14, 2, {0,28}}
	, { 6, 14, 2, {0,29}}
	, { 6, 14, 2, {0,30}}
	, { 6, 14, 2, {0,31}}
	, { 6, 14, 2, {0,32}}
	, { 6, 14, 2, {0,33}}
	, { 6, 14, 2, {0,34}}
	, { 6, 14, 2, {0,35}}
	, { 6, 14, 2, {0,36}}
	, { 6, 14, 2, {0,37}}
	, { 6, 14, 2, {0,38}}
	, { 6, 14, 2, {0,39}}
	, { 6, 14, 2, {0,40}}
	, { 6, 14, 2, {0,41}}
	, { 6, 14, 2, {0,42}}
	, { 6, 14, 2, {0,43}}
	, { 6, 14, 2, {0,44}}
	, { 6, 14, 2, {0,45}}
	, { 6, 14, 2, {0,46}}
	, { 6, 14, 2, {0,47}}
	, { 6, 14, 2, {0,48}}
	, { 6, 14, 2, {0,49}}
	, { 6, 14, 2, {0,50}}
	, { 6, 14, 2, {0,51}}
	, { 6, 14, 2, {0,52}}
	, { 6, 14, 2, {0,53}}
	, { 6, 14, 2, {0,54}}
	, { 6, 14, 2, {0,55}}
	, { 6, 14, 2, {0,56}}
	, { 6, 14, 2, {0,57}}
	, { 6, 14, 2, {0,58}}
	, { 6, 14, 2, {0,59}}
	, { 6, 14, 2, {0,60}}
	, { 6, 14, 2, {0,61}}
	, { 6, 14, 2, {0,62}}
	, { 6, 14, 2, {0,63}}
	, { 6, 14, 2, {0,64}}
	, { 6, 14, 2, {0,65}}
	, { 6, 14, 2, {0,66}}
	, { 6, 14, 2, {0,67}}
	, { 6, 14, 2, {0,68}}
	, { 6, 14, 2, {0,69}}
	, { 6, 14, 2, {0,70}}
	, { 6, 14, 2, {0,71}}
	, { 6, 14, 2, {0,72}}
	, { 6, 14, 2, {0,73}}
	, { 6, 14, 2, {0,74}}
	, { 6, 14, 2, {0,75}}
	, { 6, 14, 2, {0,76}}
	, { 6, 14, 2, {0,77}}
	, { 6, 14, 2, {0,78}}
	, { 6, 14, 2, {0,79}}
	, { 6, 14, 2, {0,80}}
	, { 6, 14, 2, {0,81}}
	, { 6, 14, 2, {0,82}}
	, { 6, 14, 2, {0,83}}
	, { 6, 14, 2, {0,84}}
	, { 6, 14, 2, {0,85}}
	, { 6, 14, 2, {0,86}}
	, { 6, 14, 2, {0,87}}
	, { 6, 14, 2, {0,88}}
	, { 6, 14, 2, {0,89}}
	, { 6, 14, 2, {0,90}}
	, { 6, 14, 2, {0,91}}
	, { 6, 14, 2, {0,92}}
	, { 6, 14, 2, {0,93}}
	, { 6, 14, 2, {0,94}}
	, { 6, 14, 2, {0,95}}
	, { 6, 14, 2, {0,96}}
	, { 6, 14, 2, {0,97}}
	, { 6, 14, 2, {0,98}}
	, { 6, 14, 2, {0,99}}
	, { 6, 14, 2, {0,100}}
	, { 6, 14, 2, {0,101}}
	, { 6, 14, 2, {0,102}}
	, { 6, 14, 2, {0,103}}
	, { 6, 14, 2, {0,104}}
	, { 6, 14, 2, {0,105}}
	, { 6, 14, 2, {0,106}}
	, { 6, 14, 2, {0,107}}
	, { 6, 14, 2, {0,108}}
	, { 6, 14, 2, {0,109}}
	, { 6, 14, 2, {0,110}}
	, { 6, 14, 2, {0,111}}
	, { 6, 14, 2, {0,112}}
	, { 6, 14, 2, {0,113}}
	, { 6, 14, 2, {0,114}}
	, { 6, 14, 2, {0,115}}
	, { 6, 14, 2, {0,116}}
	, { 6, 14, 2, {0,117}}
	, { 6, 14, 2, {0,118}}
	, { 6, 14, 2, {0,119}}
	, { 6, 14, 2, {0,120}}
	, { 6, 14, 2, {0,121}}
	, { 6, 14, 2, {0,122}}
	, { 6, 14, 2, {0,123}}
	, { 6, 14, 2, {0,124}}
	, { 6, 14, 2, {0,125}}
	, { 6, 14, 2, {0,126}}
	, { 6, 14, 2, {0,127}}
	, { 6, 14, 2, {0,128}}
	, { 6, 14, 2, {0,129}}
	, { 6, 14, 2, {0,130}}
	, { 6, 14, 2, {0,131}}
	, { 6, 14, 2, {0,132}}
	, { 6, 14, 2, {0,133}}
	, { 6, 14, 2, {0,134}}
	, { 6, 14, 2, {0,135}}
	, { 6, 14, 2, {0,136}}
	, { 6, 14, 2, {0,137}}
	, { 6, 14, 2, {0,138}}
	, { 6, 14, 2, {0,139}}
	, { 6, 14, 2, {0,140}}
	, { 6, 14, 2, {0,141}}
	, { 6, 14, 2, {0,142}}
	, { 6, 14, 2, {0,143}}
	, { 6, 14, 2, {0,144}}
	, { 6, 14, 2, {0,145}}
	, { 6, 14, 2, {0,146}}
	, { 6, 14, 2, {0,147}}
	, { 6, 14, 2, {0,148}}
	, { 6, 14, 2, {0,149}}
	, { 6, 14, 2, {0,150}}
	, { 6, 14, 2, {0,151}}
	, { 6, 14, 2, {0,152}}
	, { 6, 14, 2, {0,153}}
	, { 6, 14, 2, {0,154}}
	, { 6, 14, 2, {0,155}}
	, { 6, 14, 2, {0,156}}
	, { 6, 14, 2, {0,157}}
	, { 6, 14, 2, {0,158}}
	, { 6, 14, 2, {0,159}}
	, { 6, 14, 2, {0,160}}
	, { 6, 14, 2, {0,161}}
	, { 6, 14, 2, {0,162}}
	, { 6, 14, 2, {0,163}}
	, { 6, 14, 2, {0,164}}
	, { 6, 14, 2, {0,165}}
	, { 6, 14, 2, {0,166}}
	, { 6, 14, 2, {0,167}}
	, { 6, 14, 2, {0,168}}
	, { 6, 14, 2, {0,169}}
	, { 6, 14, 2, {0,170}}
	, { 6, 14, 2, {0,171}}
	, { 6, 14, 2, {0,172}}
	, { 6, 14, 2, {0,173}}
	, { 6, 14, 2, {0,174}}
	, { 6, 14, 2, {0,175}}
	, { 6, 14, 2, {0,176}}
	, { 6, 14, 2, {0,177}}
	, { 6, 14, 2, {0,178}}
	, { 6, 14, 2, {0,179}}
	, { 6, 14, 2, {0,180}}
	, { 6, 14, 2, {0,181}}
	, { 6, 14, 2, {0,182}}
	, { 6, 14, 2, {0,183}}
	, { 6, 14, 2, {0,184}}
	, { 6, 14, 2, {0,185}}
	, { 6, 14, 2, {0,186}}
	, { 6, 14, 2, {0,187}}
	, { 6, 14, 2, {0,188}}
	, { 6, 14, 2, {0,189}}
	, { 6, 14, 2, {0,190}}
	, { 6, 14, 2, {0,191}}
	, { 6, 14, 2, {0,192}}
	, { 6, 14, 2, {0,193}}
	, { 6, 14, 2, {0,194}}
	, { 6, 14, 2, {0,195}}
	, { 6, 14, 2, {0,196}}
	, { 6, 14, 2, {0,197}}
	, { 6, 14, 2, {0,198}}
	, { 6, 14, 2, {0,199}}
	, { 6, 14, 2, {0,200}}
	, { 6, 14, 2, {0,201}}
	, { 6, 14, 2, {0,202}}
	, { 6, 14, 2, {0,203}}
	, { 6, 14, 2, {0,204}}
	, { 6, 14, 2, {0,205}}
	, { 6, 14, 2, {0,206}}
	, { 6, 14, 2, {0,207}}
	, { 6, 14, 2, {0,208}}
	, { 6, 14, 2, {0,209}}
	, { 6, 14, 2, {0,210}}
	, { 6, 14, 2, {0,211}}
	, { 6, 14, 2, {0,212}}
	, { 6, 14, 2, {0,213}}
	, { 6, 14, 2, {0,214}}
	, { 6, 14, 2, {0,215}}
	, { 6, 14, 2, {0,216}}
	, { 6, 14, 2, {0,217}}
	, { 6, 14, 2, {0,218}}
	, { 6, 14, 2, {0,219}}
	, { 6, 14, 2, {0,220}}
	, { 6, 14, 2, {0,221}}
	, { 6, 14, 2, {0,222}}
	, { 6, 14, 2, {0,223}}
	, { 6, 14, 2, {0,224}}
	, { 6, 14, 2, {0,225}}
	, { 6, 14, 2, {0,226}}
	, { 6, 14, 2, {0,227}}
	, { 6, 14, 2, {0,228}}
	, { 6, 14, 2, {0,229}}
	, { 6, 14, 2, {0,230}}
	, { 6, 14, 2, {0,231}}
	, { 6, 14, 2, {0,232}}
	, { 6, 14, 2, {0,233}}
	, { 6, 14, 2, {0,234}}
	, { 6, 14, 2, {0,235}}
	, { 6, 14, 2, {0,236}}
	, { 6, 14, 2, {0,237}}
	, { 6, 14, 2, {0,238}}
	, { 6, 14, 2, {0,239}}
	, { 6, 14, 2, {0,240}}
	, { 6, 14, 2, {0,241}}
	, { 6, 14, 2, {0,242}}
	, { 6, 14, 2, {0,243}}
	, { 6, 14, 2, {0,244}}
	, { 6, 14, 2, {0,245}}
	, { 6, 14, 2, {0,246}}
	, { 6, 14, 2, {0,247}}
	, { 6, 14, 2, {0,248}}
	, { 6, 14, 2, {0,249}}
	, { 6, 14, 2, {0,250}}
	, { 6, 14, 2, {0,251}}
	, { 6, 14, 2, {0,252}}
	, { 6, 14, 2, {0,253}}
	, { 6, 14, 2, {0,254}}
	, { 6, 14, 2, {0,255}}
	, { 6, 14, 2, {0,256}}
	, { 6, 14, 2, {0,257}}
	, { 6, 14, 2, {0,258}}
	, { 6, 14, 2, {0,259}}
	, { 6, 14, 2, {0,260}}
	, { 6, 14, 2, {0,261}}
	, { 6, 14, 2, {0,262}}
	, { 6, 14, 2, {0,263}}
	, { 6, 14, 2, {0,264}}
	, { 6, 14, 2, {0,265}}
	, { 6, 14, 2, {0,266}}
	, { 6, 14, 2, {0,267}}
	, { 6, 14, 2, {0,268}}
	, { 6, 14, 2, {0,269}}
	, { 6, 14, 2, {0,270}}
	, { 6, 14, 2, {0,271}}
	, { 10, 6, 1, {327681,0}}
	, { 10, 6, 1, {327937,0}}
	, { 10, 6, 1, {328193,0}}
	, { 10, 6, 1, {328449,0}}
	, { 10, 6, 1, {328705,0}}
	, { 10, 6, 1, {328961,0}}
	, { 10, 6, 1, {329217,0}}
	, { 10, 6, 1, {329473,0}}
	, { 10, 6, 1, {329729,0}}
	, { 10, 6, 1, {329985,0}}
	, { 10, 6, 1, {330241,0}}
	, { 10, 6, 1, {330497,0}}};

static const struct vfc_read_task vfc_task_t_e3 = {vfc_vectors_t_e3, 1049};
static const struct vfc_read_write_vector vfc_vectors_x_e3[1049] = {
	{ 4, 0, 0, {0,0}}
	, { 4, 4, 0, {0,0}}
	, { 4, 8, 0, {0,0}}
	, { 4, 12, 0, {0,0}}
	, { 4, 16, 0, {0,0}}
	, { 4, 20, 0, {0,0}}
	, { 4, 24, 0, {0,0}}
	, { 4, 28, 0, {0,0}}
	, { 4, 32, 0, {0,0}}
	, { 4, 36, 0, {0,0}}
	, { 4, 40, 0, {0,0}}
	, { 4, 44, 0, {0,0}}
	, { 4, 48, 0, {0,0}}
	, { 4, 52, 0, {0,0}}
	, { 4, 56, 0, {0,0}}
	, { 4, 60, 0, {0,0}}
	, { 4, 64, 0, {0,0}}
	, { 4, 68, 0, {0,0}}
	, { 4, 72, 0, {0,0}}
	, { 4, 76, 0, {0,0}}
	, { 4, 80, 0, {0,0}}
	, { 4, 84, 0, {0,0}}
	, { 4, 88, 0, {0,0}}
	, { 4, 92, 0, {0,0}}
	, { 4, 96, 0, {0,0}}
	, { 4, 100, 0, {0,0}}
	, { 4, 104, 0, {0,0}}
	, { 4, 108, 0, {0,0}}
	, { 4, 112, 0, {0,0}}
	, { 4, 116, 0, {0,0}}
	, { 4, 120, 0, {0,0}}
	, { 4, 124, 0, {0,0}}
	, { 4, 128, 0, {0,0}}
	, { 4, 132, 0, {0,0}}
	, { 4, 136, 0, {0,0}}
	, { 4, 140, 0, {0,0}}
	, { 4, 144, 0, {0,0}}
	, { 4, 148, 0, {0,0}}
	, { 4, 152, 0, {0,0}}
	, { 4, 156, 0, {0,0}}
	, { 4, 160, 0, {0,0}}
	, { 4, 164, 0, {0,0}}
	, { 4, 168, 0, {0,0}}
	, { 4, 172, 0, {0,0}}
	, { 4, 176, 0, {0,0}}
	, { 4, 180, 0, {0,0}}
	, { 4, 184, 0, {0,0}}
	, { 4, 188, 0, {0,0}}
	, { 4, 192, 0, {0,0}}
	, { 4, 196, 0, {0,0}}
	, { 4, 200, 0, {0,0}}
	, { 4, 204, 0, {0,0}}
	, { 4, 208, 0, {0,0}}
	, { 4, 212, 0, {0,0}}
	, { 4, 216, 0, {0,0}}
	, { 4, 220, 0, {0,0}}
	, { 4, 224, 0, {0,0}}
	, { 4, 228, 0, {0,0}}
	, { 4, 232, 0, {0,0}}
	, { 4, 236, 0, {0,0}}
	, { 4, 240, 0, {0,0}}
	, { 4, 244, 0, {0,0}}
	, { 4, 248, 0, {0,0}}
	, { 4, 252, 0, {0,0}}
	, { 4, 256, 0, {0,0}}
	, { 4, 260, 0, {0,0}}
	, { 4, 264, 0, {0,0}}
	, { 4, 268, 0, {0,0}}
	, { 4, 272, 0, {0,0}}
	, { 4, 276, 0, {0,0}}
	, { 4, 280, 0, {0,0}}
	, { 4, 284, 0, {0,0}}
	, { 4, 288, 0, {0,0}}
	, { 4, 292, 0, {0,0}}
	, { 4, 296, 0, {0,0}}
	, { 4, 300, 0, {0,0}}
	, { 4, 304, 0, {0,0}}
	, { 4, 308, 0, {0,0}}
	, { 4, 312, 0, {0,0}}
	, { 4, 316, 0, {0,0}}
	, { 4, 320, 0, {0,0}}
	, { 4, 324, 0, {0,0}}
	, { 4, 328, 0, {0,0}}
	, { 4, 332, 0, {0,0}}
	, { 4, 336, 0, {0,0}}
	, { 4, 340, 0, {0,0}}
	, { 4, 344, 0, {0,0}}
	, { 4, 348, 0, {0,0}}
	, { 4, 352, 0, {0,0}}
	, { 4, 356, 0, {0,0}}
	, { 4, 360, 0, {0,0}}
	, { 4, 364, 0, {0,0}}
	, { 4, 368, 0, {0,0}}
	, { 4, 372, 0, {0,0}}
	, { 4, 376, 0, {0,0}}
	, { 4, 380, 0, {0,0}}
	, { 4, 384, 0, {0,0}}
	, { 4, 388, 0, {0,0}}
	, { 4, 392, 0, {0,0}}
	, { 4, 396, 0, {0,0}}
	, { 4, 400, 0, {0,0}}
	, { 4, 404, 0, {0,0}}
	, { 4, 408, 0, {0,0}}
	, { 4, 412, 0, {0,0}}
	, { 4, 416, 0, {0,0}}
	, { 4, 420, 0, {0,0}}
	, { 4, 424, 0, {0,0}}
	, { 4, 428, 0, {0,0}}
	, { 4, 432, 0, {0,0}}
	, { 4, 436, 0, {0,0}}
	, { 4, 440, 0, {0,0}}
	, { 4, 444, 0, {0,0}}
	, { 4, 448, 0, {0,0}}
	, { 4, 452, 0, {0,0}}
	, { 4, 456, 0, {0,0}}
	, { 4, 460, 0, {0,0}}
	, { 4, 464, 0, {0,0}}
	, { 4, 468, 0, {0,0}}
	, { 4, 472, 0, {0,0}}
	, { 4, 476, 0, {0,0}}
	, { 4, 480, 0, {0,0}}
	, { 4, 484, 0, {0,0}}
	, { 4, 488, 0, {0,0}}
	, { 4, 492, 0, {0,0}}
	, { 4, 496, 0, {0,0}}
	, { 4, 500, 0, {0,0}}
	, { 4, 504, 0, {0,0}}
	, { 4, 508, 0, {0,0}}
	, { 4, 512, 0, {0,0}}
	, { 4, 516, 0, {0,0}}
	, { 4, 520, 0, {0,0}}
	, { 4, 524, 0, {0,0}}
	, { 4, 528, 0, {0,0}}
	, { 4, 532, 0, {0,0}}
	, { 4, 536, 0, {0,0}}
	, { 4, 540, 0, {0,0}}
	, { 4, 544, 0, {0,0}}
	, { 4, 548, 0, {0,0}}
	, { 4, 552, 0, {0,0}}
	, { 4, 556, 0, {0,0}}
	, { 4, 560, 0, {0,0}}
	, { 4, 564, 0, {0,0}}
	, { 4, 568, 0, {0,0}}
	, { 4, 572, 0, {0,0}}
	, { 4, 576, 0, {0,0}}
	, { 4, 580, 0, {0,0}}
	, { 4, 584, 0, {0,0}}
	, { 4, 588, 0, {0,0}}
	, { 4, 592, 0, {0,0}}
	, { 4, 596, 0, {0,0}}
	, { 4, 600, 0, {0,0}}
	, { 4, 604, 0, {0,0}}
	, { 4, 608, 0, {0,0}}
	, { 4, 612, 0, {0,0}}
	, { 4, 616, 0, {0,0}}
	, { 4, 620, 0, {0,0}}
	, { 4, 624, 0, {0,0}}
	, { 4, 628, 0, {0,0}}
	, { 4, 632, 0, {0,0}}
	, { 4, 636, 0, {0,0}}
	, { 4, 640, 0, {0,0}}
	, { 4, 644, 0, {0,0}}
	, { 4, 648, 0, {0,0}}
	, { 4, 652, 0, {0,0}}
	, { 4, 656, 0, {0,0}}
	, { 4, 660, 0, {0,0}}
	, { 4, 664, 0, {0,0}}
	, { 4, 668, 0, {0,0}}
	, { 4, 672, 0, {0,0}}
	, { 4, 676, 0, {0,0}}
	, { 4, 680, 0, {0,0}}
	, { 4, 684, 0, {0,0}}
	, { 4, 688, 0, {0,0}}
	, { 4, 692, 0, {0,0}}
	, { 4, 696, 0, {0,0}}
	, { 4, 700, 0, {0,0}}
	, { 4, 704, 0, {0,0}}
	, { 4, 708, 0, {0,0}}
	, { 4, 712, 0, {0,0}}
	, { 4, 716, 0, {0,0}}
	, { 4, 720, 0, {0,0}}
	, { 4, 724, 0, {0,0}}
	, { 4, 728, 0, {0,0}}
	, { 4, 732, 0, {0,0}}
	, { 4, 736, 0, {0,0}}
	, { 4, 740, 0, {0,0}}
	, { 4, 744, 0, {0,0}}
	, { 4, 748, 0, {0,0}}
	, { 4, 752, 0, {0,0}}
	, { 4, 756, 0, {0,0}}
	, { 4, 760, 0, {0,0}}
	, { 4, 764, 0, {0,0}}
	, { 4, 768, 0, {0,0}}
	, { 4, 772, 0, {0,0}}
	, { 4, 776, 0, {0,0}}
	, { 4, 780, 0, {0,0}}
	, { 4, 784, 0, {0,0}}
	, { 4, 788, 0, {0,0}}
	, { 4, 792, 0, {0,0}}
	, { 4, 796, 0, {0,0}}
	, { 4, 800, 0, {0,0}}
	, { 4, 804, 0, {0,0}}
	, { 4, 808, 0, {0,0}}
	, { 4, 812, 0, {0,0}}
	, { 4, 816, 0, {0,0}}
	, { 4, 820, 0, {0,0}}
	, { 4, 824, 0, {0,0}}
	, { 4, 828, 0, {0,0}}
	, { 4, 832, 0, {0,0}}
	, { 4, 836, 0, {0,0}}
	, { 4, 840, 0, {0,0}}
	, { 4, 844, 0, {0,0}}
	, { 4, 848, 0, {0,0}}
	, { 4, 852, 0, {0,0}}
	, { 4, 856, 0, {0,0}}
	, { 4, 860, 0, {0,0}}
	, { 4, 864, 0, {0,0}}
	, { 4, 868, 0, {0,0}}
	, { 4, 872, 0, {0,0}}
	, { 4, 876, 0, {0,0}}
	, { 4, 880, 0, {0,0}}
	, { 4, 884, 0, {0,0}}
	, { 4, 888, 0, {0,0}}
	, { 4, 892, 0, {0,0}}
	, { 4, 896, 0, {0,0}}
	, { 4, 900, 0, {0,0}}
	, { 4, 904, 0, {0,0}}
	, { 4, 908, 0, {0,0}}
	, { 4, 912, 0, {0,0}}
	, { 4, 916, 0, {0,0}}
	, { 4, 920, 0, {0,0}}
	, { 4, 924, 0, {0,0}}
	, { 4, 928, 0, {0,0}}
	, { 4, 932, 0, {0,0}}
	, { 4, 936, 0, {0,0}}
	, { 4, 940, 0, {0,0}}
	, { 4, 944, 0, {0,0}}
	, { 4, 948, 0, {0,0}}
	, { 4, 952, 0, {0,0}}
	, { 4, 956, 0, {0,0}}
	, { 4, 960, 0, {0,0}}
	, { 4, 964, 0, {0,0}}
	, { 4, 968, 0, {0,0}}
	, { 4, 972, 0, {0,0}}
	, { 4, 976, 0, {0,0}}
	, { 4, 980, 0, {0,0}}
	, { 4, 984, 0, {0,0}}
	, { 4, 988, 0, {0,0}}
	, { 4, 992, 0, {0,0}}
	, { 4, 996, 0, {0,0}}
	, { 4, 1000, 0, {0,0}}
	, { 4, 1004, 0, {0,0}}
	, { 4, 1008, 0, {0,0}}
	, { 4, 1012, 0, {0,0}}
	, { 4, 1016, 0, {0,0}}
	, { 4, 1020, 0, {0,0}}
	, { 4, 1024, 0, {0,0}}
	, { 4, 1028, 0, {0,0}}
	, { 4, 1032, 0, {0,0}}
	, { 4, 1036, 0, {0,0}}
	, { 4, 1040, 0, {0,0}}
	, { 4, 1044, 0, {0,0}}
	, { 4, 1048, 0, {0,0}}
	, { 4, 1052, 0, {0,0}}
	, { 4, 1056, 0, {0,0}}
	, { 4, 1060, 0, {0,0}}
	, { 4, 1064, 0, {0,0}}
	, { 4, 1068, 0, {0,0}}
	, { 4, 1072, 0, {0,0}}
	, { 4, 1076, 0, {0,0}}
	, { 4, 1080, 0, {0,0}}
	, { 4, 1084, 0, {0,0}}
	, { 4, 1088, 0, {0,0}}
	, { 4, 1092, 0, {0,0}}
	, { 4, 1096, 0, {0,0}}
	, { 4, 1100, 0, {0,0}}
	, { 4, 1104, 0, {0,0}}
	, { 4, 1108, 0, {0,0}}
	, { 4, 1112, 0, {0,0}}
	, { 4, 1116, 0, {0,0}}
	, { 4, 1120, 0, {0,0}}
	, { 4, 1124, 0, {0,0}}
	, { 4, 1128, 0, {0,0}}
	, { 4, 1132, 0, {0,0}}
	, { 4, 1136, 0, {0,0}}
	, { 4, 1140, 0, {0,0}}
	, { 4, 1144, 0, {0,0}}
	, { 4, 1148, 0, {0,0}}
	, { 4, 1152, 0, {0,0}}
	, { 4, 1156, 0, {0,0}}
	, { 4, 1160, 0, {0,0}}
	, { 4, 1164, 0, {0,0}}
	, { 4, 1168, 0, {0,0}}
	, { 4, 1172, 0, {0,0}}
	, { 4, 1176, 0, {0,0}}
	, { 4, 1180, 0, {0,0}}
	, { 4, 1184, 0, {0,0}}
	, { 4, 1188, 0, {0,0}}
	, { 4, 1192, 0, {0,0}}
	, { 4, 1196, 0, {0,0}}
	, { 4, 1200, 0, {0,0}}
	, { 4, 1204, 0, {0,0}}
	, { 4, 1208, 0, {0,0}}
	, { 4, 1212, 0, {0,0}}
	, { 4, 1216, 0, {0,0}}
	, { 4, 1220, 0, {0,0}}
	, { 4, 1224, 0, {0,0}}
	, { 4, 1228, 0, {0,0}}
	, { 4, 1232, 0, {0,0}}
	, { 4, 1236, 0, {0,0}}
	, { 4, 1240, 0, {0,0}}
	, { 4, 1244, 0, {0,0}}
	, { 4, 1248, 0, {0,0}}
	, { 4, 1252, 0, {0,0}}
	, { 4, 1256, 0, {0,0}}
	, { 4, 1260, 0, {0,0}}
	, { 4, 1264, 0, {0,0}}
	, { 4, 1268, 0, {0,0}}
	, { 4, 1272, 0, {0,0}}
	, { 4, 1276, 0, {0,0}}
	, { 4, 1280, 0, {0,0}}
	, { 4, 1284, 0, {0,0}}
	, { 4, 1288, 0, {0,0}}
	, { 4, 1292, 0, {0,0}}
	, { 4, 1296, 0, {0,0}}
	, { 4, 1300, 0, {0,0}}
	, { 4, 1304, 0, {0,0}}
	, { 4, 1308, 0, {0,0}}
	, { 4, 1312, 0, {0,0}}
	, { 4, 1316, 0, {0,0}}
	, { 4, 1320, 0, {0,0}}
	, { 4, 1324, 0, {0,0}}
	, { 4, 1328, 0, {0,0}}
	, { 4, 1332, 0, {0,0}}
	, { 4, 1336, 0, {0,0}}
	, { 4, 1340, 0, {0,0}}
	, { 4, 1344, 0, {0,0}}
	, { 4, 1348, 0, {0,0}}
	, { 4, 1352, 0, {0,0}}
	, { 4, 1356, 0, {0,0}}
	, { 4, 1360, 0, {0,0}}
	, { 4, 1364, 0, {0,0}}
	, { 4, 1368, 0, {0,0}}
	, { 4, 1372, 0, {0,0}}
	, { 4, 1376, 0, {0,0}}
	, { 4, 1380, 0, {0,0}}
	, { 4, 1384, 0, {0,0}}
	, { 4, 1388, 0, {0,0}}
	, { 4, 1392, 0, {0,0}}
	, { 4, 1396, 0, {0,0}}
	, { 4, 1400, 0, {0,0}}
	, { 4, 1404, 0, {0,0}}
	, { 4, 1408, 0, {0,0}}
	, { 4, 1412, 0, {0,0}}
	, { 4, 1416, 0, {0,0}}
	, { 4, 1420, 0, {0,0}}
	, { 4, 1424, 0, {0,0}}
	, { 4, 1428, 0, {0,0}}
	, { 4, 1432, 0, {0,0}}
	, { 4, 1436, 0, {0,0}}
	, { 4, 1440, 0, {0,0}}
	, { 4, 1444, 0, {0,0}}
	, { 4, 1448, 0, {0,0}}
	, { 4, 1452, 0, {0,0}}
	, { 4, 1456, 0, {0,0}}
	, { 4, 1460, 0, {0,0}}
	, { 4, 1464, 0, {0,0}}
	, { 4, 1468, 0, {0,0}}
	, { 4, 1472, 0, {0,0}}
	, { 4, 1476, 0, {0,0}}
	, { 4, 1480, 0, {0,0}}
	, { 4, 1484, 0, {0,0}}
	, { 4, 1488, 0, {0,0}}
	, { 4, 1492, 0, {0,0}}
	, { 4, 1496, 0, {0,0}}
	, { 4, 1500, 0, {0,0}}
	, { 4, 1504, 0, {0,0}}
	, { 4, 1508, 0, {0,0}}
	, { 4, 1512, 0, {0,0}}
	, { 4, 1516, 0, {0,0}}
	, { 4, 1520, 0, {0,0}}
	, { 4, 1524, 0, {0,0}}
	, { 4, 1528, 0, {0,0}}
	, { 4, 1532, 0, {0,0}}
	, { 4, 1536, 0, {0,0}}
	, { 4, 1540, 0, {0,0}}
	, { 4, 1544, 0, {0,0}}
	, { 4, 1548, 0, {0,0}}
	, { 4, 1552, 0, {0,0}}
	, { 4, 1556, 0, {0,0}}
	, { 4, 1560, 0, {0,0}}
	, { 4, 1564, 0, {0,0}}
	, { 4, 1568, 0, {0,0}}
	, { 4, 1572, 0, {0,0}}
	, { 4, 1576, 0, {0,0}}
	, { 4, 1580, 0, {0,0}}
	, { 4, 1584, 0, {0,0}}
	, { 4, 1588, 0, {0,0}}
	, { 4, 1592, 0, {0,0}}
	, { 4, 1596, 0, {0,0}}
	, { 4, 1600, 0, {0,0}}
	, { 4, 1604, 0, {0,0}}
	, { 4, 1608, 0, {0,0}}
	, { 4, 1612, 0, {0,0}}
	, { 4, 1616, 0, {0,0}}
	, { 4, 1620, 0, {0,0}}
	, { 4, 1624, 0, {0,0}}
	, { 4, 1628, 0, {0,0}}
	, { 4, 1632, 0, {0,0}}
	, { 4, 1636, 0, {0,0}}
	, { 4, 1640, 0, {0,0}}
	, { 4, 1644, 0, {0,0}}
	, { 4, 1648, 0, {0,0}}
	, { 4, 1652, 0, {0,0}}
	, { 4, 1656, 0, {0,0}}
	, { 4, 1660, 0, {0,0}}
	, { 4, 1664, 0, {0,0}}
	, { 4, 1668, 0, {0,0}}
	, { 4, 1672, 0, {0,0}}
	, { 4, 1676, 0, {0,0}}
	, { 4, 1680, 0, {0,0}}
	, { 4, 1684, 0, {0,0}}
	, { 4, 1688, 0, {0,0}}
	, { 4, 1692, 0, {0,0}}
	, { 4, 1696, 0, {0,0}}
	, { 4, 1700, 0, {0,0}}
	, { 4, 1704, 0, {0,0}}
	, { 4, 1708, 0, {0,0}}
	, { 4, 1712, 0, {0,0}}
	, { 4, 1716, 0, {0,0}}
	, { 4, 1720, 0, {0,0}}
	, { 4, 1724, 0, {0,0}}
	, { 4, 1728, 0, {0,0}}
	, { 4, 1732, 0, {0,0}}
	, { 4, 1736, 0, {0,0}}
	, { 4, 1740, 0, {0,0}}
	, { 4, 1744, 0, {0,0}}
	, { 4, 1748, 0, {0,0}}
	, { 4, 1752, 0, {0,0}}
	, { 4, 1756, 0, {0,0}}
	, { 4, 1760, 0, {0,0}}
	, { 4, 1764, 0, {0,0}}
	, { 4, 1768, 0, {0,0}}
	, { 4, 1772, 0, {0,0}}
	, { 4, 1776, 0, {0,0}}
	, { 4, 1780, 0, {0,0}}
	, { 4, 1784, 0, {0,0}}
	, { 4, 1788, 0, {0,0}}
	, { 4, 1792, 0, {0,0}}
	, { 4, 1796, 0, {0,0}}
	, { 4, 1800, 0, {0,0}}
	, { 4, 1804, 0, {0,0}}
	, { 4, 1808, 0, {0,0}}
	, { 4, 1812, 0, {0,0}}
	, { 4, 1816, 0, {0,0}}
	, { 4, 1820, 0, {0,0}}
	, { 4, 1824, 0, {0,0}}
	, { 4, 1828, 0, {0,0}}
	, { 4, 1832, 0, {0,0}}
	, { 4, 1836, 0, {0,0}}
	, { 4, 1840, 0, {0,0}}
	, { 4, 1844, 0, {0,0}}
	, { 4, 1848, 0, {0,0}}
	, { 4, 1852, 0, {0,0}}
	, { 4, 1856, 0, {0,0}}
	, { 4, 1860, 0, {0,0}}
	, { 4, 1864, 0, {0,0}}
	, { 4, 1868, 0, {0,0}}
	, { 4, 1872, 0, {0,0}}
	, { 4, 1876, 0, {0,0}}
	, { 4, 1880, 0, {0,0}}
	, { 4, 1884, 0, {0,0}}
	, { 4, 1888, 0, {0,0}}
	, { 4, 1892, 0, {0,0}}
	, { 4, 1896, 0, {0,0}}
	, { 4, 1900, 0, {0,0}}
	, { 4, 1904, 0, {0,0}}
	, { 4, 1908, 0, {0,0}}
	, { 4, 1912, 0, {0,0}}
	, { 4, 1916, 0, {0,0}}
	, { 4, 1920, 0, {0,0}}
	, { 4, 1924, 0, {0,0}}
	, { 4, 1928, 0, {0,0}}
	, { 4, 1932, 0, {0,0}}
	, { 4, 1936, 0, {0,0}}
	, { 4, 1940, 0, {0,0}}
	, { 4, 1944, 0, {0,0}}
	, { 4, 1948, 0, {0,0}}
	, { 4, 1952, 0, {0,0}}
	, { 4, 1956, 0, {0,0}}
	, { 4, 1960, 0, {0,0}}
	, { 4, 1964, 0, {0,0}}
	, { 4, 1968, 0, {0,0}}
	, { 4, 1972, 0, {0,0}}
	, { 4, 1976, 0, {0,0}}
	, { 4, 1980, 0, {0,0}}
	, { 4, 1984, 0, {0,0}}
	, { 4, 1988, 0, {0,0}}
	, { 4, 1992, 0, {0,0}}
	, { 4, 1996, 0, {0,0}}
	, { 4, 2000, 0, {0,0}}
	, { 4, 2004, 0, {0,0}}
	, { 4, 2008, 0, {0,0}}
	, { 4, 2012, 0, {0,0}}
	, { 4, 2016, 0, {0,0}}
	, { 4, 2020, 0, {0,0}}
	, { 4, 2024, 0, {0,0}}
	, { 4, 2028, 0, {0,0}}
	, { 4, 2032, 0, {0,0}}
	, { 4, 2036, 0, {0,0}}
	, { 4, 2040, 0, {0,0}}
	, { 4, 2044, 0, {0,0}}
	, { 4, 2048, 0, {0,0}}
	, { 4, 2052, 0, {0,0}}
	, { 4, 2056, 0, {0,0}}
	, { 4, 2060, 0, {0,0}}
	, { 4, 2064, 0, {0,0}}
	, { 4, 2068, 0, {0,0}}
	, { 4, 2072, 0, {0,0}}
	, { 4, 2076, 0, {0,0}}
	, { 4, 2080, 0, {0,0}}
	, { 4, 2084, 0, {0,0}}
	, { 4, 2088, 0, {0,0}}
	, { 4, 2092, 0, {0,0}}
	, { 4, 2096, 0, {0,0}}
	, { 4, 2100, 0, {0,0}}
	, { 4, 2104, 0, {0,0}}
	, { 4, 2108, 0, {0,0}}
	, { 4, 2112, 0, {0,0}}
	, { 4, 2116, 0, {0,0}}
	, { 4, 2120, 0, {0,0}}
	, { 4, 2124, 0, {0,0}}
	, { 4, 2128, 0, {0,0}}
	, { 4, 2132, 0, {0,0}}
	, { 4, 2136, 0, {0,0}}
	, { 4, 2140, 0, {0,0}}
	, { 4, 2144, 0, {0,0}}
	, { 4, 2148, 0, {0,0}}
	, { 4, 2152, 0, {0,0}}
	, { 4, 2156, 0, {0,0}}
	, { 4, 2160, 0, {0,0}}
	, { 4, 2164, 0, {0,0}}
	, { 4, 2168, 0, {0,0}}
	, { 4, 2172, 0, {0,0}}
	, { 4, 2176, 0, {0,0}}
	, { 4, 2180, 0, {0,0}}
	, { 4, 2184, 0, {0,0}}
	, { 4, 2188, 0, {0,0}}
	, { 4, 2192, 0, {0,0}}
	, { 4, 2196, 0, {0,0}}
	, { 4, 2200, 0, {0,0}}
	, { 4, 2204, 0, {0,0}}
	, { 4, 2208, 0, {0,0}}
	, { 4, 2212, 0, {0,0}}
	, { 4, 2216, 0, {0,0}}
	, { 4, 2220, 0, {0,0}}
	, { 4, 2224, 0, {0,0}}
	, { 4, 2228, 0, {0,0}}
	, { 4, 2232, 0, {0,0}}
	, { 4, 2236, 0, {0,0}}
	, { 4, 2240, 0, {0,0}}
	, { 4, 2244, 0, {0,0}}
	, { 4, 2248, 0, {0,0}}
	, { 4, 2252, 0, {0,0}}
	, { 4, 2256, 0, {0,0}}
	, { 4, 2260, 0, {0,0}}
	, { 4, 2264, 0, {0,0}}
	, { 4, 2268, 0, {0,0}}
	, { 4, 2272, 0, {0,0}}
	, { 4, 2276, 0, {0,0}}
	, { 4, 2280, 0, {0,0}}
	, { 4, 2284, 0, {0,0}}
	, { 4, 2288, 0, {0,0}}
	, { 4, 2292, 0, {0,0}}
	, { 4, 2296, 0, {0,0}}
	, { 4, 2300, 0, {0,0}}
	, { 4, 2304, 0, {0,0}}
	, { 4, 2308, 0, {0,0}}
	, { 4, 2312, 0, {0,0}}
	, { 4, 2316, 0, {0,0}}
	, { 4, 2320, 0, {0,0}}
	, { 4, 2324, 0, {0,0}}
	, { 4, 2328, 0, {0,0}}
	, { 4, 2332, 0, {0,0}}
	, { 4, 2336, 0, {0,0}}
	, { 4, 2340, 0, {0,0}}
	, { 4, 2344, 0, {0,0}}
	, { 4, 2348, 0, {0,0}}
	, { 4, 2352, 0, {0,0}}
	, { 4, 2356, 0, {0,0}}
	, { 4, 2360, 0, {0,0}}
	, { 4, 2364, 0, {0,0}}
	, { 4, 2368, 0, {0,0}}
	, { 4, 2372, 0, {0,0}}
	, { 4, 2376, 0, {0,0}}
	, { 4, 2380, 0, {0,0}}
	, { 4, 2384, 0, {0,0}}
	, { 4, 2388, 0, {0,0}}
	, { 4, 2392, 0, {0,0}}
	, { 4, 2396, 0, {0,0}}
	, { 4, 2400, 0, {0,0}}
	, { 4, 2404, 0, {0,0}}
	, { 4, 2408, 0, {0,0}}
	, { 4, 2412, 0, {0,0}}
	, { 4, 2416, 0, {0,0}}
	, { 4, 2420, 0, {0,0}}
	, { 4, 2424, 0, {0,0}}
	, { 4, 2428, 0, {0,0}}
	, { 4, 2432, 0, {0,0}}
	, { 4, 2436, 0, {0,0}}
	, { 4, 2440, 0, {0,0}}
	, { 4, 2444, 0, {0,0}}
	, { 4, 2448, 0, {0,0}}
	, { 4, 2452, 0, {0,0}}
	, { 4, 2456, 0, {0,0}}
	, { 4, 2460, 0, {0,0}}
	, { 4, 2464, 0, {0,0}}
	, { 4, 2468, 0, {0,0}}
	, { 4, 2472, 0, {0,0}}
	, { 4, 2476, 0, {0,0}}
	, { 4, 2480, 0, {0,0}}
	, { 4, 2484, 0, {0,0}}
	, { 4, 2488, 0, {0,0}}
	, { 4, 2492, 0, {0,0}}
	, { 4, 2496, 0, {0,0}}
	, { 4, 2500, 0, {0,0}}
	, { 4, 2504, 0, {0,0}}
	, { 4, 2508, 0, {0,0}}
	, { 4, 2512, 0, {0,0}}
	, { 4, 2516, 0, {0,0}}
	, { 4, 2520, 0, {0,0}}
	, { 4, 2524, 0, {0,0}}
	, { 4, 2528, 0, {0,0}}
	, { 4, 2532, 0, {0,0}}
	, { 4, 2536, 0, {0,0}}
	, { 4, 2540, 0, {0,0}}
	, { 4, 2544, 0, {0,0}}
	, { 4, 2548, 0, {0,0}}
	, { 4, 2552, 0, {0,0}}
	, { 4, 2556, 0, {0,0}}
	, { 4, 2560, 0, {0,0}}
	, { 4, 2564, 0, {0,0}}
	, { 4, 2568, 0, {0,0}}
	, { 4, 2572, 0, {0,0}}
	, { 4, 2576, 0, {0,0}}
	, { 4, 2580, 0, {0,0}}
	, { 4, 2584, 0, {0,0}}
	, { 4, 2588, 0, {0,0}}
	, { 4, 2592, 0, {0,0}}
	, { 4, 2596, 0, {0,0}}
	, { 4, 2600, 0, {0,0}}
	, { 4, 2604, 0, {0,0}}
	, { 4, 2608, 0, {0,0}}
	, { 4, 2612, 0, {0,0}}
	, { 4, 2616, 0, {0,0}}
	, { 4, 2620, 0, {0,0}}
	, { 4, 2624, 0, {0,0}}
	, { 4, 2628, 0, {0,0}}
	, { 4, 2632, 0, {0,0}}
	, { 4, 2636, 0, {0,0}}
	, { 4, 2640, 0, {0,0}}
	, { 4, 2644, 0, {0,0}}
	, { 4, 2648, 0, {0,0}}
	, { 4, 2652, 0, {0,0}}
	, { 4, 2656, 0, {0,0}}
	, { 4, 2660, 0, {0,0}}
	, { 4, 2664, 0, {0,0}}
	, { 4, 2668, 0, {0,0}}
	, { 4, 2672, 0, {0,0}}
	, { 4, 2676, 0, {0,0}}
	, { 4, 2680, 0, {0,0}}
	, { 4, 2684, 0, {0,0}}
	, { 4, 2688, 0, {0,0}}
	, { 4, 2692, 0, {0,0}}
	, { 4, 2696, 0, {0,0}}
	, { 4, 2700, 0, {0,0}}
	, { 4, 2704, 0, {0,0}}
	, { 4, 2708, 0, {0,0}}
	, { 4, 2712, 0, {0,0}}
	, { 4, 2716, 0, {0,0}}
	, { 4, 2720, 0, {0,0}}
	, { 4, 2724, 0, {0,0}}
	, { 4, 2728, 0, {0,0}}
	, { 4, 2732, 0, {0,0}}
	, { 4, 2736, 0, {0,0}}
	, { 4, 2740, 0, {0,0}}
	, { 4, 2744, 0, {0,0}}
	, { 4, 2748, 0, {0,0}}
	, { 4, 2752, 0, {0,0}}
	, { 4, 2756, 0, {0,0}}
	, { 4, 2760, 0, {0,0}}
	, { 4, 2764, 0, {0,0}}
	, { 4, 2768, 0, {0,0}}
	, { 4, 2772, 0, {0,0}}
	, { 4, 2776, 0, {0,0}}
	, { 4, 2780, 0, {0,0}}
	, { 4, 2784, 0, {0,0}}
	, { 4, 2788, 0, {0,0}}
	, { 4, 2792, 0, {0,0}}
	, { 4, 2796, 0, {0,0}}
	, { 4, 2800, 0, {0,0}}
	, { 4, 2804, 0, {0,0}}
	, { 4, 2808, 0, {0,0}}
	, { 4, 2812, 0, {0,0}}
	, { 4, 2816, 0, {0,0}}
	, { 4, 2820, 0, {0,0}}
	, { 4, 2824, 0, {0,0}}
	, { 4, 2828, 0, {0,0}}
	, { 4, 2832, 0, {0,0}}
	, { 4, 2836, 0, {0,0}}
	, { 4, 2840, 0, {0,0}}
	, { 4, 2844, 0, {0,0}}
	, { 4, 2848, 0, {0,0}}
	, { 4, 2852, 0, {0,0}}
	, { 4, 2856, 0, {0,0}}
	, { 4, 2860, 0, {0,0}}
	, { 4, 2864, 0, {0,0}}
	, { 4, 2868, 0, {0,0}}
	, { 4, 2872, 0, {0,0}}
	, { 4, 2876, 0, {0,0}}
	, { 4, 2880, 0, {0,0}}
	, { 4, 2884, 0, {0,0}}
	, { 4, 2888, 0, {0,0}}
	, { 4, 2892, 0, {0,0}}
	, { 4, 2896, 0, {0,0}}
	, { 4, 2900, 0, {0,0}}
	, { 4, 2904, 0, {0,0}}
	, { 4, 2908, 0, {0,0}}
	, { 4, 2912, 0, {0,0}}
	, { 4, 2916, 0, {0,0}}
	, { 4, 2920, 0, {0,0}}
	, { 4, 2924, 0, {0,0}}
	, { 4, 2928, 0, {0,0}}
	, { 4, 2932, 0, {0,0}}
	, { 4, 2936, 0, {0,0}}
	, { 4, 2940, 0, {0,0}}
	, { 4, 2944, 0, {0,0}}
	, { 4, 2948, 0, {0,0}}
	, { 4, 2952, 0, {0,0}}
	, { 4, 2956, 0, {0,0}}
	, { 4, 2960, 0, {0,0}}
	, { 4, 2964, 0, {0,0}}
	, { 4, 2968, 0, {0,0}}
	, { 4, 2972, 0, {0,0}}
	, { 4, 2976, 0, {0,0}}
	, { 4, 2980, 0, {0,0}}
	, { 4, 2984, 0, {0,0}}
	, { 4, 2988, 0, {0,0}}
	, { 4, 2992, 0, {0,0}}
	, { 4, 2996, 0, {0,0}}
	, { 4, 3000, 0, {0,0}}
	, { 4, 3004, 0, {0,0}}
	, { 4, 3008, 0, {0,0}}
	, { 4, 3012, 0, {0,0}}
	, { 4, 3016, 0, {0,0}}
	, { 4, 3020, 0, {0,0}}
	, { 4, 3024, 0, {0,0}}
	, { 4, 3028, 0, {0,0}}
	, { 4, 3032, 0, {0,0}}
	, { 4, 3036, 0, {0,0}}
	, { 4, 3040, 0, {0,0}}
	, { 4, 3044, 0, {0,0}}
	, { 4, 3048, 0, {0,0}}
	, { 4, 3052, 0, {0,0}}
	, { 4, 3056, 0, {0,0}}
	, { 6, 14, 2, {0,0}}
	, { 6, 14, 2, {0,1}}
	, { 6, 14, 2, {0,2}}
	, { 6, 14, 2, {0,3}}
	, { 6, 14, 2, {0,4}}
	, { 6, 14, 2, {0,5}}
	, { 6, 14, 2, {0,6}}
	, { 6, 14, 2, {0,7}}
	, { 6, 14, 2, {0,8}}
	, { 6, 14, 2, {0,9}}
	, { 6, 14, 2, {0,10}}
	, { 6, 14, 2, {0,11}}
	, { 6, 14, 2, {0,12}}
	, { 6, 14, 2, {0,13}}
	, { 6, 14, 2, {0,14}}
	, { 6, 14, 2, {0,15}}
	, { 6, 14, 2, {0,16}}
	, { 6, 14, 2, {0,17}}
	, { 6, 14, 2, {0,18}}
	, { 6, 14, 2, {0,19}}
	, { 6, 14, 2, {0,20}}
	, { 6, 14, 2, {0,21}}
	, { 6, 14, 2, {0,22}}
	, { 6, 14, 2, {0,23}}
	, { 6, 14, 2, {0,24}}
	, { 6, 14, 2, {0,25}}
	, { 6, 14, 2, {0,26}}
	, { 6, 14, 2, {0,27}}
	, { 6, 14, 2, {0,28}}
	, { 6, 14, 2, {0,29}}
	, { 6, 14, 2, {0,30}}
	, { 6, 14, 2, {0,31}}
	, { 6, 14, 2, {0,32}}
	, { 6, 14, 2, {0,33}}
	, { 6, 14, 2, {0,34}}
	, { 6, 14, 2, {0,35}}
	, { 6, 14, 2, {0,36}}
	, { 6, 14, 2, {0,37}}
	, { 6, 14, 2, {0,38}}
	, { 6, 14, 2, {0,39}}
	, { 6, 14, 2, {0,40}}
	, { 6, 14, 2, {0,41}}
	, { 6, 14, 2, {0,42}}
	, { 6, 14, 2, {0,43}}
	, { 6, 14, 2, {0,44}}
	, { 6, 14, 2, {0,45}}
	, { 6, 14, 2, {0,46}}
	, { 6, 14, 2, {0,47}}
	, { 6, 14, 2, {0,48}}
	, { 6, 14, 2, {0,49}}
	, { 6, 14, 2, {0,50}}
	, { 6, 14, 2, {0,51}}
	, { 6, 14, 2, {0,52}}
	, { 6, 14, 2, {0,53}}
	, { 6, 14, 2, {0,54}}
	, { 6, 14, 2, {0,55}}
	, { 6, 14, 2, {0,56}}
	, { 6, 14, 2, {0,57}}
	, { 6, 14, 2, {0,58}}
	, { 6, 14, 2, {0,59}}
	, { 6, 14, 2, {0,60}}
	, { 6, 14, 2, {0,61}}
	, { 6, 14, 2, {0,62}}
	, { 6, 14, 2, {0,63}}
	, { 6, 14, 2, {0,64}}
	, { 6, 14, 2, {0,65}}
	, { 6, 14, 2, {0,66}}
	, { 6, 14, 2, {0,67}}
	, { 6, 14, 2, {0,68}}
	, { 6, 14, 2, {0,69}}
	, { 6, 14, 2, {0,70}}
	, { 6, 14, 2, {0,71}}
	, { 6, 14, 2, {0,72}}
	, { 6, 14, 2, {0,73}}
	, { 6, 14, 2, {0,74}}
	, { 6, 14, 2, {0,75}}
	, { 6, 14, 2, {0,76}}
	, { 6, 14, 2, {0,77}}
	, { 6, 14, 2, {0,78}}
	, { 6, 14, 2, {0,79}}
	, { 6, 14, 2, {0,80}}
	, { 6, 14, 2, {0,81}}
	, { 6, 14, 2, {0,82}}
	, { 6, 14, 2, {0,83}}
	, { 6, 14, 2, {0,84}}
	, { 6, 14, 2, {0,85}}
	, { 6, 14, 2, {0,86}}
	, { 6, 14, 2, {0,87}}
	, { 6, 14, 2, {0,88}}
	, { 6, 14, 2, {0,89}}
	, { 6, 14, 2, {0,90}}
	, { 6, 14, 2, {0,91}}
	, { 6, 14, 2, {0,92}}
	, { 6, 14, 2, {0,93}}
	, { 6, 14, 2, {0,94}}
	, { 6, 14, 2, {0,95}}
	, { 6, 14, 2, {0,96}}
	, { 6, 14, 2, {0,97}}
	, { 6, 14, 2, {0,98}}
	, { 6, 14, 2, {0,99}}
	, { 6, 14, 2, {0,100}}
	, { 6, 14, 2, {0,101}}
	, { 6, 14, 2, {0,102}}
	, { 6, 14, 2, {0,103}}
	, { 6, 14, 2, {0,104}}
	, { 6, 14, 2, {0,105}}
	, { 6, 14, 2, {0,106}}
	, { 6, 14, 2, {0,107}}
	, { 6, 14, 2, {0,108}}
	, { 6, 14, 2, {0,109}}
	, { 6, 14, 2, {0,110}}
	, { 6, 14, 2, {0,111}}
	, { 6, 14, 2, {0,112}}
	, { 6, 14, 2, {0,113}}
	, { 6, 14, 2, {0,114}}
	, { 6, 14, 2, {0,115}}
	, { 6, 14, 2, {0,116}}
	, { 6, 14, 2, {0,117}}
	, { 6, 14, 2, {0,118}}
	, { 6, 14, 2, {0,119}}
	, { 6, 14, 2, {0,120}}
	, { 6, 14, 2, {0,121}}
	, { 6, 14, 2, {0,122}}
	, { 6, 14, 2, {0,123}}
	, { 6, 14, 2, {0,124}}
	, { 6, 14, 2, {0,125}}
	, { 6, 14, 2, {0,126}}
	, { 6, 14, 2, {0,127}}
	, { 6, 14, 2, {0,128}}
	, { 6, 14, 2, {0,129}}
	, { 6, 14, 2, {0,130}}
	, { 6, 14, 2, {0,131}}
	, { 6, 14, 2, {0,132}}
	, { 6, 14, 2, {0,133}}
	, { 6, 14, 2, {0,134}}
	, { 6, 14, 2, {0,135}}
	, { 6, 14, 2, {0,136}}
	, { 6, 14, 2, {0,137}}
	, { 6, 14, 2, {0,138}}
	, { 6, 14, 2, {0,139}}
	, { 6, 14, 2, {0,140}}
	, { 6, 14, 2, {0,141}}
	, { 6, 14, 2, {0,142}}
	, { 6, 14, 2, {0,143}}
	, { 6, 14, 2, {0,144}}
	, { 6, 14, 2, {0,145}}
	, { 6, 14, 2, {0,146}}
	, { 6, 14, 2, {0,147}}
	, { 6, 14, 2, {0,148}}
	, { 6, 14, 2, {0,149}}
	, { 6, 14, 2, {0,150}}
	, { 6, 14, 2, {0,151}}
	, { 6, 14, 2, {0,152}}
	, { 6, 14, 2, {0,153}}
	, { 6, 14, 2, {0,154}}
	, { 6, 14, 2, {0,155}}
	, { 6, 14, 2, {0,156}}
	, { 6, 14, 2, {0,157}}
	, { 6, 14, 2, {0,158}}
	, { 6, 14, 2, {0,159}}
	, { 6, 14, 2, {0,160}}
	, { 6, 14, 2, {0,161}}
	, { 6, 14, 2, {0,162}}
	, { 6, 14, 2, {0,163}}
	, { 6, 14, 2, {0,164}}
	, { 6, 14, 2, {0,165}}
	, { 6, 14, 2, {0,166}}
	, { 6, 14, 2, {0,167}}
	, { 6, 14, 2, {0,168}}
	, { 6, 14, 2, {0,169}}
	, { 6, 14, 2, {0,170}}
	, { 6, 14, 2, {0,171}}
	, { 6, 14, 2, {0,172}}
	, { 6, 14, 2, {0,173}}
	, { 6, 14, 2, {0,174}}
	, { 6, 14, 2, {0,175}}
	, { 6, 14, 2, {0,176}}
	, { 6, 14, 2, {0,177}}
	, { 6, 14, 2, {0,178}}
	, { 6, 14, 2, {0,179}}
	, { 6, 14, 2, {0,180}}
	, { 6, 14, 2, {0,181}}
	, { 6, 14, 2, {0,182}}
	, { 6, 14, 2, {0,183}}
	, { 6, 14, 2, {0,184}}
	, { 6, 14, 2, {0,185}}
	, { 6, 14, 2, {0,186}}
	, { 6, 14, 2, {0,187}}
	, { 6, 14, 2, {0,188}}
	, { 6, 14, 2, {0,189}}
	, { 6, 14, 2, {0,190}}
	, { 6, 14, 2, {0,191}}
	, { 6, 14, 2, {0,192}}
	, { 6, 14, 2, {0,193}}
	, { 6, 14, 2, {0,194}}
	, { 6, 14, 2, {0,195}}
	, { 6, 14, 2, {0,196}}
	, { 6, 14, 2, {0,197}}
	, { 6, 14, 2, {0,198}}
	, { 6, 14, 2, {0,199}}
	, { 6, 14, 2, {0,200}}
	, { 6, 14, 2, {0,201}}
	, { 6, 14, 2, {0,202}}
	, { 6, 14, 2, {0,203}}
	, { 6, 14, 2, {0,204}}
	, { 6, 14, 2, {0,205}}
	, { 6, 14, 2, {0,206}}
	, { 6, 14, 2, {0,207}}
	, { 6, 14, 2, {0,208}}
	, { 6, 14, 2, {0,209}}
	, { 6, 14, 2, {0,210}}
	, { 6, 14, 2, {0,211}}
	, { 6, 14, 2, {0,212}}
	, { 6, 14, 2, {0,213}}
	, { 6, 14, 2, {0,214}}
	, { 6, 14, 2, {0,215}}
	, { 6, 14, 2, {0,216}}
	, { 6, 14, 2, {0,217}}
	, { 6, 14, 2, {0,218}}
	, { 6, 14, 2, {0,219}}
	, { 6, 14, 2, {0,220}}
	, { 6, 14, 2, {0,221}}
	, { 6, 14, 2, {0,222}}
	, { 6, 14, 2, {0,223}}
	, { 6, 14, 2, {0,224}}
	, { 6, 14, 2, {0,225}}
	, { 6, 14, 2, {0,226}}
	, { 6, 14, 2, {0,227}}
	, { 6, 14, 2, {0,228}}
	, { 6, 14, 2, {0,229}}
	, { 6, 14, 2, {0,230}}
	, { 6, 14, 2, {0,231}}
	, { 6, 14, 2, {0,232}}
	, { 6, 14, 2, {0,233}}
	, { 6, 14, 2, {0,234}}
	, { 6, 14, 2, {0,235}}
	, { 6, 14, 2, {0,236}}
	, { 6, 14, 2, {0,237}}
	, { 6, 14, 2, {0,238}}
	, { 6, 14, 2, {0,239}}
	, { 6, 14, 2, {0,240}}
	, { 6, 14, 2, {0,241}}
	, { 6, 14, 2, {0,242}}
	, { 6, 14, 2, {0,243}}
	, { 6, 14, 2, {0,244}}
	, { 6, 14, 2, {0,245}}
	, { 6, 14, 2, {0,246}}
	, { 6, 14, 2, {0,247}}
	, { 6, 14, 2, {0,248}}
	, { 6, 14, 2, {0,249}}
	, { 6, 14, 2, {0,250}}
	, { 6, 14, 2, {0,251}}
	, { 6, 14, 2, {0,252}}
	, { 6, 14, 2, {0,253}}
	, { 6, 14, 2, {0,254}}
	, { 6, 14, 2, {0,255}}
	, { 6, 14, 2, {0,256}}
	, { 6, 14, 2, {0,257}}
	, { 6, 14, 2, {0,258}}
	, { 6, 14, 2, {0,259}}
	, { 6, 14, 2, {0,260}}
	, { 6, 14, 2, {0,261}}
	, { 6, 14, 2, {0,262}}
	, { 6, 14, 2, {0,263}}
	, { 6, 14, 2, {0,264}}
	, { 6, 14, 2, {0,265}}
	, { 6, 14, 2, {0,266}}
	, { 6, 14, 2, {0,267}}
	, { 6, 14, 2, {0,268}}
	, { 6, 14, 2, {0,269}}
	, { 6, 14, 2, {0,270}}
	, { 6, 14, 2, {0,271}}
	, { 10, 6, 1, {327681,0}}
	, { 10, 6, 1, {327937,0}}
	, { 10, 6, 1, {328193,0}}
	, { 10, 6, 1, {328449,0}}
	, { 10, 6, 1, {328705,0}}
	, { 10, 6, 1, {328961,0}}
	, { 10, 6, 1, {329217,0}}
	, { 10, 6, 1, {329473,0}}
	, { 10, 6, 1, {329729,0}}
	, { 10, 6, 1, {329985,0}}
	, { 10, 6, 1, {330241,0}}
	, { 10, 6, 1, {330497,0}}};

static const struct vfc_read_task vfc_task_x_e3 = {vfc_vectors_x_e3, 1049};



static const struct igu_data igu_address_e3 = {
	1, 10, 0x130034, 0x130130, { 0x00130178, 0x0013017c}
};





static const u32 timer_status_regs_e3b0[] = { 0x164014, 0x164018};
static const u32 timer_scan_regs_e3b0[] = { 0x1640d0, 0x1640d4};

#define TIMER_REGS_COUNT_E3B0 ARRSIZE(timer_status_regs_e3b0)


static const struct vfc_general vfc_general_x_e3b0 = {
	1, 0x2b8fd0, 0x2b8fc8, 0x2b8fc4, 0x2b8fcc
};

static const struct vfc_general vfc_general_t_e3b0 = {
	1, 0x1b8fd0, 0x1b8fc8, 0x1b8fc4, 0x1b8fcc
};

static const struct vfc_read_write_vector vfc_vectors_t_e3b0[1049] = {
	{ 4, 0, 0, {0,0}}
	, { 4, 4, 0, {0,0}}
	, { 4, 8, 0, {0,0}}
	, { 4, 12, 0, {0,0}}
	, { 4, 16, 0, {0,0}}
	, { 4, 20, 0, {0,0}}
	, { 4, 24, 0, {0,0}}
	, { 4, 28, 0, {0,0}}
	, { 4, 32, 0, {0,0}}
	, { 4, 36, 0, {0,0}}
	, { 4, 40, 0, {0,0}}
	, { 4, 44, 0, {0,0}}
	, { 4, 48, 0, {0,0}}
	, { 4, 52, 0, {0,0}}
	, { 4, 56, 0, {0,0}}
	, { 4, 60, 0, {0,0}}
	, { 4, 64, 0, {0,0}}
	, { 4, 68, 0, {0,0}}
	, { 4, 72, 0, {0,0}}
	, { 4, 76, 0, {0,0}}
	, { 4, 80, 0, {0,0}}
	, { 4, 84, 0, {0,0}}
	, { 4, 88, 0, {0,0}}
	, { 4, 92, 0, {0,0}}
	, { 4, 96, 0, {0,0}}
	, { 4, 100, 0, {0,0}}
	, { 4, 104, 0, {0,0}}
	, { 4, 108, 0, {0,0}}
	, { 4, 112, 0, {0,0}}
	, { 4, 116, 0, {0,0}}
	, { 4, 120, 0, {0,0}}
	, { 4, 124, 0, {0,0}}
	, { 4, 128, 0, {0,0}}
	, { 4, 132, 0, {0,0}}
	, { 4, 136, 0, {0,0}}
	, { 4, 140, 0, {0,0}}
	, { 4, 144, 0, {0,0}}
	, { 4, 148, 0, {0,0}}
	, { 4, 152, 0, {0,0}}
	, { 4, 156, 0, {0,0}}
	, { 4, 160, 0, {0,0}}
	, { 4, 164, 0, {0,0}}
	, { 4, 168, 0, {0,0}}
	, { 4, 172, 0, {0,0}}
	, { 4, 176, 0, {0,0}}
	, { 4, 180, 0, {0,0}}
	, { 4, 184, 0, {0,0}}
	, { 4, 188, 0, {0,0}}
	, { 4, 192, 0, {0,0}}
	, { 4, 196, 0, {0,0}}
	, { 4, 200, 0, {0,0}}
	, { 4, 204, 0, {0,0}}
	, { 4, 208, 0, {0,0}}
	, { 4, 212, 0, {0,0}}
	, { 4, 216, 0, {0,0}}
	, { 4, 220, 0, {0,0}}
	, { 4, 224, 0, {0,0}}
	, { 4, 228, 0, {0,0}}
	, { 4, 232, 0, {0,0}}
	, { 4, 236, 0, {0,0}}
	, { 4, 240, 0, {0,0}}
	, { 4, 244, 0, {0,0}}
	, { 4, 248, 0, {0,0}}
	, { 4, 252, 0, {0,0}}
	, { 4, 256, 0, {0,0}}
	, { 4, 260, 0, {0,0}}
	, { 4, 264, 0, {0,0}}
	, { 4, 268, 0, {0,0}}
	, { 4, 272, 0, {0,0}}
	, { 4, 276, 0, {0,0}}
	, { 4, 280, 0, {0,0}}
	, { 4, 284, 0, {0,0}}
	, { 4, 288, 0, {0,0}}
	, { 4, 292, 0, {0,0}}
	, { 4, 296, 0, {0,0}}
	, { 4, 300, 0, {0,0}}
	, { 4, 304, 0, {0,0}}
	, { 4, 308, 0, {0,0}}
	, { 4, 312, 0, {0,0}}
	, { 4, 316, 0, {0,0}}
	, { 4, 320, 0, {0,0}}
	, { 4, 324, 0, {0,0}}
	, { 4, 328, 0, {0,0}}
	, { 4, 332, 0, {0,0}}
	, { 4, 336, 0, {0,0}}
	, { 4, 340, 0, {0,0}}
	, { 4, 344, 0, {0,0}}
	, { 4, 348, 0, {0,0}}
	, { 4, 352, 0, {0,0}}
	, { 4, 356, 0, {0,0}}
	, { 4, 360, 0, {0,0}}
	, { 4, 364, 0, {0,0}}
	, { 4, 368, 0, {0,0}}
	, { 4, 372, 0, {0,0}}
	, { 4, 376, 0, {0,0}}
	, { 4, 380, 0, {0,0}}
	, { 4, 384, 0, {0,0}}
	, { 4, 388, 0, {0,0}}
	, { 4, 392, 0, {0,0}}
	, { 4, 396, 0, {0,0}}
	, { 4, 400, 0, {0,0}}
	, { 4, 404, 0, {0,0}}
	, { 4, 408, 0, {0,0}}
	, { 4, 412, 0, {0,0}}
	, { 4, 416, 0, {0,0}}
	, { 4, 420, 0, {0,0}}
	, { 4, 424, 0, {0,0}}
	, { 4, 428, 0, {0,0}}
	, { 4, 432, 0, {0,0}}
	, { 4, 436, 0, {0,0}}
	, { 4, 440, 0, {0,0}}
	, { 4, 444, 0, {0,0}}
	, { 4, 448, 0, {0,0}}
	, { 4, 452, 0, {0,0}}
	, { 4, 456, 0, {0,0}}
	, { 4, 460, 0, {0,0}}
	, { 4, 464, 0, {0,0}}
	, { 4, 468, 0, {0,0}}
	, { 4, 472, 0, {0,0}}
	, { 4, 476, 0, {0,0}}
	, { 4, 480, 0, {0,0}}
	, { 4, 484, 0, {0,0}}
	, { 4, 488, 0, {0,0}}
	, { 4, 492, 0, {0,0}}
	, { 4, 496, 0, {0,0}}
	, { 4, 500, 0, {0,0}}
	, { 4, 504, 0, {0,0}}
	, { 4, 508, 0, {0,0}}
	, { 4, 512, 0, {0,0}}
	, { 4, 516, 0, {0,0}}
	, { 4, 520, 0, {0,0}}
	, { 4, 524, 0, {0,0}}
	, { 4, 528, 0, {0,0}}
	, { 4, 532, 0, {0,0}}
	, { 4, 536, 0, {0,0}}
	, { 4, 540, 0, {0,0}}
	, { 4, 544, 0, {0,0}}
	, { 4, 548, 0, {0,0}}
	, { 4, 552, 0, {0,0}}
	, { 4, 556, 0, {0,0}}
	, { 4, 560, 0, {0,0}}
	, { 4, 564, 0, {0,0}}
	, { 4, 568, 0, {0,0}}
	, { 4, 572, 0, {0,0}}
	, { 4, 576, 0, {0,0}}
	, { 4, 580, 0, {0,0}}
	, { 4, 584, 0, {0,0}}
	, { 4, 588, 0, {0,0}}
	, { 4, 592, 0, {0,0}}
	, { 4, 596, 0, {0,0}}
	, { 4, 600, 0, {0,0}}
	, { 4, 604, 0, {0,0}}
	, { 4, 608, 0, {0,0}}
	, { 4, 612, 0, {0,0}}
	, { 4, 616, 0, {0,0}}
	, { 4, 620, 0, {0,0}}
	, { 4, 624, 0, {0,0}}
	, { 4, 628, 0, {0,0}}
	, { 4, 632, 0, {0,0}}
	, { 4, 636, 0, {0,0}}
	, { 4, 640, 0, {0,0}}
	, { 4, 644, 0, {0,0}}
	, { 4, 648, 0, {0,0}}
	, { 4, 652, 0, {0,0}}
	, { 4, 656, 0, {0,0}}
	, { 4, 660, 0, {0,0}}
	, { 4, 664, 0, {0,0}}
	, { 4, 668, 0, {0,0}}
	, { 4, 672, 0, {0,0}}
	, { 4, 676, 0, {0,0}}
	, { 4, 680, 0, {0,0}}
	, { 4, 684, 0, {0,0}}
	, { 4, 688, 0, {0,0}}
	, { 4, 692, 0, {0,0}}
	, { 4, 696, 0, {0,0}}
	, { 4, 700, 0, {0,0}}
	, { 4, 704, 0, {0,0}}
	, { 4, 708, 0, {0,0}}
	, { 4, 712, 0, {0,0}}
	, { 4, 716, 0, {0,0}}
	, { 4, 720, 0, {0,0}}
	, { 4, 724, 0, {0,0}}
	, { 4, 728, 0, {0,0}}
	, { 4, 732, 0, {0,0}}
	, { 4, 736, 0, {0,0}}
	, { 4, 740, 0, {0,0}}
	, { 4, 744, 0, {0,0}}
	, { 4, 748, 0, {0,0}}
	, { 4, 752, 0, {0,0}}
	, { 4, 756, 0, {0,0}}
	, { 4, 760, 0, {0,0}}
	, { 4, 764, 0, {0,0}}
	, { 4, 768, 0, {0,0}}
	, { 4, 772, 0, {0,0}}
	, { 4, 776, 0, {0,0}}
	, { 4, 780, 0, {0,0}}
	, { 4, 784, 0, {0,0}}
	, { 4, 788, 0, {0,0}}
	, { 4, 792, 0, {0,0}}
	, { 4, 796, 0, {0,0}}
	, { 4, 800, 0, {0,0}}
	, { 4, 804, 0, {0,0}}
	, { 4, 808, 0, {0,0}}
	, { 4, 812, 0, {0,0}}
	, { 4, 816, 0, {0,0}}
	, { 4, 820, 0, {0,0}}
	, { 4, 824, 0, {0,0}}
	, { 4, 828, 0, {0,0}}
	, { 4, 832, 0, {0,0}}
	, { 4, 836, 0, {0,0}}
	, { 4, 840, 0, {0,0}}
	, { 4, 844, 0, {0,0}}
	, { 4, 848, 0, {0,0}}
	, { 4, 852, 0, {0,0}}
	, { 4, 856, 0, {0,0}}
	, { 4, 860, 0, {0,0}}
	, { 4, 864, 0, {0,0}}
	, { 4, 868, 0, {0,0}}
	, { 4, 872, 0, {0,0}}
	, { 4, 876, 0, {0,0}}
	, { 4, 880, 0, {0,0}}
	, { 4, 884, 0, {0,0}}
	, { 4, 888, 0, {0,0}}
	, { 4, 892, 0, {0,0}}
	, { 4, 896, 0, {0,0}}
	, { 4, 900, 0, {0,0}}
	, { 4, 904, 0, {0,0}}
	, { 4, 908, 0, {0,0}}
	, { 4, 912, 0, {0,0}}
	, { 4, 916, 0, {0,0}}
	, { 4, 920, 0, {0,0}}
	, { 4, 924, 0, {0,0}}
	, { 4, 928, 0, {0,0}}
	, { 4, 932, 0, {0,0}}
	, { 4, 936, 0, {0,0}}
	, { 4, 940, 0, {0,0}}
	, { 4, 944, 0, {0,0}}
	, { 4, 948, 0, {0,0}}
	, { 4, 952, 0, {0,0}}
	, { 4, 956, 0, {0,0}}
	, { 4, 960, 0, {0,0}}
	, { 4, 964, 0, {0,0}}
	, { 4, 968, 0, {0,0}}
	, { 4, 972, 0, {0,0}}
	, { 4, 976, 0, {0,0}}
	, { 4, 980, 0, {0,0}}
	, { 4, 984, 0, {0,0}}
	, { 4, 988, 0, {0,0}}
	, { 4, 992, 0, {0,0}}
	, { 4, 996, 0, {0,0}}
	, { 4, 1000, 0, {0,0}}
	, { 4, 1004, 0, {0,0}}
	, { 4, 1008, 0, {0,0}}
	, { 4, 1012, 0, {0,0}}
	, { 4, 1016, 0, {0,0}}
	, { 4, 1020, 0, {0,0}}
	, { 4, 1024, 0, {0,0}}
	, { 4, 1028, 0, {0,0}}
	, { 4, 1032, 0, {0,0}}
	, { 4, 1036, 0, {0,0}}
	, { 4, 1040, 0, {0,0}}
	, { 4, 1044, 0, {0,0}}
	, { 4, 1048, 0, {0,0}}
	, { 4, 1052, 0, {0,0}}
	, { 4, 1056, 0, {0,0}}
	, { 4, 1060, 0, {0,0}}
	, { 4, 1064, 0, {0,0}}
	, { 4, 1068, 0, {0,0}}
	, { 4, 1072, 0, {0,0}}
	, { 4, 1076, 0, {0,0}}
	, { 4, 1080, 0, {0,0}}
	, { 4, 1084, 0, {0,0}}
	, { 4, 1088, 0, {0,0}}
	, { 4, 1092, 0, {0,0}}
	, { 4, 1096, 0, {0,0}}
	, { 4, 1100, 0, {0,0}}
	, { 4, 1104, 0, {0,0}}
	, { 4, 1108, 0, {0,0}}
	, { 4, 1112, 0, {0,0}}
	, { 4, 1116, 0, {0,0}}
	, { 4, 1120, 0, {0,0}}
	, { 4, 1124, 0, {0,0}}
	, { 4, 1128, 0, {0,0}}
	, { 4, 1132, 0, {0,0}}
	, { 4, 1136, 0, {0,0}}
	, { 4, 1140, 0, {0,0}}
	, { 4, 1144, 0, {0,0}}
	, { 4, 1148, 0, {0,0}}
	, { 4, 1152, 0, {0,0}}
	, { 4, 1156, 0, {0,0}}
	, { 4, 1160, 0, {0,0}}
	, { 4, 1164, 0, {0,0}}
	, { 4, 1168, 0, {0,0}}
	, { 4, 1172, 0, {0,0}}
	, { 4, 1176, 0, {0,0}}
	, { 4, 1180, 0, {0,0}}
	, { 4, 1184, 0, {0,0}}
	, { 4, 1188, 0, {0,0}}
	, { 4, 1192, 0, {0,0}}
	, { 4, 1196, 0, {0,0}}
	, { 4, 1200, 0, {0,0}}
	, { 4, 1204, 0, {0,0}}
	, { 4, 1208, 0, {0,0}}
	, { 4, 1212, 0, {0,0}}
	, { 4, 1216, 0, {0,0}}
	, { 4, 1220, 0, {0,0}}
	, { 4, 1224, 0, {0,0}}
	, { 4, 1228, 0, {0,0}}
	, { 4, 1232, 0, {0,0}}
	, { 4, 1236, 0, {0,0}}
	, { 4, 1240, 0, {0,0}}
	, { 4, 1244, 0, {0,0}}
	, { 4, 1248, 0, {0,0}}
	, { 4, 1252, 0, {0,0}}
	, { 4, 1256, 0, {0,0}}
	, { 4, 1260, 0, {0,0}}
	, { 4, 1264, 0, {0,0}}
	, { 4, 1268, 0, {0,0}}
	, { 4, 1272, 0, {0,0}}
	, { 4, 1276, 0, {0,0}}
	, { 4, 1280, 0, {0,0}}
	, { 4, 1284, 0, {0,0}}
	, { 4, 1288, 0, {0,0}}
	, { 4, 1292, 0, {0,0}}
	, { 4, 1296, 0, {0,0}}
	, { 4, 1300, 0, {0,0}}
	, { 4, 1304, 0, {0,0}}
	, { 4, 1308, 0, {0,0}}
	, { 4, 1312, 0, {0,0}}
	, { 4, 1316, 0, {0,0}}
	, { 4, 1320, 0, {0,0}}
	, { 4, 1324, 0, {0,0}}
	, { 4, 1328, 0, {0,0}}
	, { 4, 1332, 0, {0,0}}
	, { 4, 1336, 0, {0,0}}
	, { 4, 1340, 0, {0,0}}
	, { 4, 1344, 0, {0,0}}
	, { 4, 1348, 0, {0,0}}
	, { 4, 1352, 0, {0,0}}
	, { 4, 1356, 0, {0,0}}
	, { 4, 1360, 0, {0,0}}
	, { 4, 1364, 0, {0,0}}
	, { 4, 1368, 0, {0,0}}
	, { 4, 1372, 0, {0,0}}
	, { 4, 1376, 0, {0,0}}
	, { 4, 1380, 0, {0,0}}
	, { 4, 1384, 0, {0,0}}
	, { 4, 1388, 0, {0,0}}
	, { 4, 1392, 0, {0,0}}
	, { 4, 1396, 0, {0,0}}
	, { 4, 1400, 0, {0,0}}
	, { 4, 1404, 0, {0,0}}
	, { 4, 1408, 0, {0,0}}
	, { 4, 1412, 0, {0,0}}
	, { 4, 1416, 0, {0,0}}
	, { 4, 1420, 0, {0,0}}
	, { 4, 1424, 0, {0,0}}
	, { 4, 1428, 0, {0,0}}
	, { 4, 1432, 0, {0,0}}
	, { 4, 1436, 0, {0,0}}
	, { 4, 1440, 0, {0,0}}
	, { 4, 1444, 0, {0,0}}
	, { 4, 1448, 0, {0,0}}
	, { 4, 1452, 0, {0,0}}
	, { 4, 1456, 0, {0,0}}
	, { 4, 1460, 0, {0,0}}
	, { 4, 1464, 0, {0,0}}
	, { 4, 1468, 0, {0,0}}
	, { 4, 1472, 0, {0,0}}
	, { 4, 1476, 0, {0,0}}
	, { 4, 1480, 0, {0,0}}
	, { 4, 1484, 0, {0,0}}
	, { 4, 1488, 0, {0,0}}
	, { 4, 1492, 0, {0,0}}
	, { 4, 1496, 0, {0,0}}
	, { 4, 1500, 0, {0,0}}
	, { 4, 1504, 0, {0,0}}
	, { 4, 1508, 0, {0,0}}
	, { 4, 1512, 0, {0,0}}
	, { 4, 1516, 0, {0,0}}
	, { 4, 1520, 0, {0,0}}
	, { 4, 1524, 0, {0,0}}
	, { 4, 1528, 0, {0,0}}
	, { 4, 1532, 0, {0,0}}
	, { 4, 1536, 0, {0,0}}
	, { 4, 1540, 0, {0,0}}
	, { 4, 1544, 0, {0,0}}
	, { 4, 1548, 0, {0,0}}
	, { 4, 1552, 0, {0,0}}
	, { 4, 1556, 0, {0,0}}
	, { 4, 1560, 0, {0,0}}
	, { 4, 1564, 0, {0,0}}
	, { 4, 1568, 0, {0,0}}
	, { 4, 1572, 0, {0,0}}
	, { 4, 1576, 0, {0,0}}
	, { 4, 1580, 0, {0,0}}
	, { 4, 1584, 0, {0,0}}
	, { 4, 1588, 0, {0,0}}
	, { 4, 1592, 0, {0,0}}
	, { 4, 1596, 0, {0,0}}
	, { 4, 1600, 0, {0,0}}
	, { 4, 1604, 0, {0,0}}
	, { 4, 1608, 0, {0,0}}
	, { 4, 1612, 0, {0,0}}
	, { 4, 1616, 0, {0,0}}
	, { 4, 1620, 0, {0,0}}
	, { 4, 1624, 0, {0,0}}
	, { 4, 1628, 0, {0,0}}
	, { 4, 1632, 0, {0,0}}
	, { 4, 1636, 0, {0,0}}
	, { 4, 1640, 0, {0,0}}
	, { 4, 1644, 0, {0,0}}
	, { 4, 1648, 0, {0,0}}
	, { 4, 1652, 0, {0,0}}
	, { 4, 1656, 0, {0,0}}
	, { 4, 1660, 0, {0,0}}
	, { 4, 1664, 0, {0,0}}
	, { 4, 1668, 0, {0,0}}
	, { 4, 1672, 0, {0,0}}
	, { 4, 1676, 0, {0,0}}
	, { 4, 1680, 0, {0,0}}
	, { 4, 1684, 0, {0,0}}
	, { 4, 1688, 0, {0,0}}
	, { 4, 1692, 0, {0,0}}
	, { 4, 1696, 0, {0,0}}
	, { 4, 1700, 0, {0,0}}
	, { 4, 1704, 0, {0,0}}
	, { 4, 1708, 0, {0,0}}
	, { 4, 1712, 0, {0,0}}
	, { 4, 1716, 0, {0,0}}
	, { 4, 1720, 0, {0,0}}
	, { 4, 1724, 0, {0,0}}
	, { 4, 1728, 0, {0,0}}
	, { 4, 1732, 0, {0,0}}
	, { 4, 1736, 0, {0,0}}
	, { 4, 1740, 0, {0,0}}
	, { 4, 1744, 0, {0,0}}
	, { 4, 1748, 0, {0,0}}
	, { 4, 1752, 0, {0,0}}
	, { 4, 1756, 0, {0,0}}
	, { 4, 1760, 0, {0,0}}
	, { 4, 1764, 0, {0,0}}
	, { 4, 1768, 0, {0,0}}
	, { 4, 1772, 0, {0,0}}
	, { 4, 1776, 0, {0,0}}
	, { 4, 1780, 0, {0,0}}
	, { 4, 1784, 0, {0,0}}
	, { 4, 1788, 0, {0,0}}
	, { 4, 1792, 0, {0,0}}
	, { 4, 1796, 0, {0,0}}
	, { 4, 1800, 0, {0,0}}
	, { 4, 1804, 0, {0,0}}
	, { 4, 1808, 0, {0,0}}
	, { 4, 1812, 0, {0,0}}
	, { 4, 1816, 0, {0,0}}
	, { 4, 1820, 0, {0,0}}
	, { 4, 1824, 0, {0,0}}
	, { 4, 1828, 0, {0,0}}
	, { 4, 1832, 0, {0,0}}
	, { 4, 1836, 0, {0,0}}
	, { 4, 1840, 0, {0,0}}
	, { 4, 1844, 0, {0,0}}
	, { 4, 1848, 0, {0,0}}
	, { 4, 1852, 0, {0,0}}
	, { 4, 1856, 0, {0,0}}
	, { 4, 1860, 0, {0,0}}
	, { 4, 1864, 0, {0,0}}
	, { 4, 1868, 0, {0,0}}
	, { 4, 1872, 0, {0,0}}
	, { 4, 1876, 0, {0,0}}
	, { 4, 1880, 0, {0,0}}
	, { 4, 1884, 0, {0,0}}
	, { 4, 1888, 0, {0,0}}
	, { 4, 1892, 0, {0,0}}
	, { 4, 1896, 0, {0,0}}
	, { 4, 1900, 0, {0,0}}
	, { 4, 1904, 0, {0,0}}
	, { 4, 1908, 0, {0,0}}
	, { 4, 1912, 0, {0,0}}
	, { 4, 1916, 0, {0,0}}
	, { 4, 1920, 0, {0,0}}
	, { 4, 1924, 0, {0,0}}
	, { 4, 1928, 0, {0,0}}
	, { 4, 1932, 0, {0,0}}
	, { 4, 1936, 0, {0,0}}
	, { 4, 1940, 0, {0,0}}
	, { 4, 1944, 0, {0,0}}
	, { 4, 1948, 0, {0,0}}
	, { 4, 1952, 0, {0,0}}
	, { 4, 1956, 0, {0,0}}
	, { 4, 1960, 0, {0,0}}
	, { 4, 1964, 0, {0,0}}
	, { 4, 1968, 0, {0,0}}
	, { 4, 1972, 0, {0,0}}
	, { 4, 1976, 0, {0,0}}
	, { 4, 1980, 0, {0,0}}
	, { 4, 1984, 0, {0,0}}
	, { 4, 1988, 0, {0,0}}
	, { 4, 1992, 0, {0,0}}
	, { 4, 1996, 0, {0,0}}
	, { 4, 2000, 0, {0,0}}
	, { 4, 2004, 0, {0,0}}
	, { 4, 2008, 0, {0,0}}
	, { 4, 2012, 0, {0,0}}
	, { 4, 2016, 0, {0,0}}
	, { 4, 2020, 0, {0,0}}
	, { 4, 2024, 0, {0,0}}
	, { 4, 2028, 0, {0,0}}
	, { 4, 2032, 0, {0,0}}
	, { 4, 2036, 0, {0,0}}
	, { 4, 2040, 0, {0,0}}
	, { 4, 2044, 0, {0,0}}
	, { 4, 2048, 0, {0,0}}
	, { 4, 2052, 0, {0,0}}
	, { 4, 2056, 0, {0,0}}
	, { 4, 2060, 0, {0,0}}
	, { 4, 2064, 0, {0,0}}
	, { 4, 2068, 0, {0,0}}
	, { 4, 2072, 0, {0,0}}
	, { 4, 2076, 0, {0,0}}
	, { 4, 2080, 0, {0,0}}
	, { 4, 2084, 0, {0,0}}
	, { 4, 2088, 0, {0,0}}
	, { 4, 2092, 0, {0,0}}
	, { 4, 2096, 0, {0,0}}
	, { 4, 2100, 0, {0,0}}
	, { 4, 2104, 0, {0,0}}
	, { 4, 2108, 0, {0,0}}
	, { 4, 2112, 0, {0,0}}
	, { 4, 2116, 0, {0,0}}
	, { 4, 2120, 0, {0,0}}
	, { 4, 2124, 0, {0,0}}
	, { 4, 2128, 0, {0,0}}
	, { 4, 2132, 0, {0,0}}
	, { 4, 2136, 0, {0,0}}
	, { 4, 2140, 0, {0,0}}
	, { 4, 2144, 0, {0,0}}
	, { 4, 2148, 0, {0,0}}
	, { 4, 2152, 0, {0,0}}
	, { 4, 2156, 0, {0,0}}
	, { 4, 2160, 0, {0,0}}
	, { 4, 2164, 0, {0,0}}
	, { 4, 2168, 0, {0,0}}
	, { 4, 2172, 0, {0,0}}
	, { 4, 2176, 0, {0,0}}
	, { 4, 2180, 0, {0,0}}
	, { 4, 2184, 0, {0,0}}
	, { 4, 2188, 0, {0,0}}
	, { 4, 2192, 0, {0,0}}
	, { 4, 2196, 0, {0,0}}
	, { 4, 2200, 0, {0,0}}
	, { 4, 2204, 0, {0,0}}
	, { 4, 2208, 0, {0,0}}
	, { 4, 2212, 0, {0,0}}
	, { 4, 2216, 0, {0,0}}
	, { 4, 2220, 0, {0,0}}
	, { 4, 2224, 0, {0,0}}
	, { 4, 2228, 0, {0,0}}
	, { 4, 2232, 0, {0,0}}
	, { 4, 2236, 0, {0,0}}
	, { 4, 2240, 0, {0,0}}
	, { 4, 2244, 0, {0,0}}
	, { 4, 2248, 0, {0,0}}
	, { 4, 2252, 0, {0,0}}
	, { 4, 2256, 0, {0,0}}
	, { 4, 2260, 0, {0,0}}
	, { 4, 2264, 0, {0,0}}
	, { 4, 2268, 0, {0,0}}
	, { 4, 2272, 0, {0,0}}
	, { 4, 2276, 0, {0,0}}
	, { 4, 2280, 0, {0,0}}
	, { 4, 2284, 0, {0,0}}
	, { 4, 2288, 0, {0,0}}
	, { 4, 2292, 0, {0,0}}
	, { 4, 2296, 0, {0,0}}
	, { 4, 2300, 0, {0,0}}
	, { 4, 2304, 0, {0,0}}
	, { 4, 2308, 0, {0,0}}
	, { 4, 2312, 0, {0,0}}
	, { 4, 2316, 0, {0,0}}
	, { 4, 2320, 0, {0,0}}
	, { 4, 2324, 0, {0,0}}
	, { 4, 2328, 0, {0,0}}
	, { 4, 2332, 0, {0,0}}
	, { 4, 2336, 0, {0,0}}
	, { 4, 2340, 0, {0,0}}
	, { 4, 2344, 0, {0,0}}
	, { 4, 2348, 0, {0,0}}
	, { 4, 2352, 0, {0,0}}
	, { 4, 2356, 0, {0,0}}
	, { 4, 2360, 0, {0,0}}
	, { 4, 2364, 0, {0,0}}
	, { 4, 2368, 0, {0,0}}
	, { 4, 2372, 0, {0,0}}
	, { 4, 2376, 0, {0,0}}
	, { 4, 2380, 0, {0,0}}
	, { 4, 2384, 0, {0,0}}
	, { 4, 2388, 0, {0,0}}
	, { 4, 2392, 0, {0,0}}
	, { 4, 2396, 0, {0,0}}
	, { 4, 2400, 0, {0,0}}
	, { 4, 2404, 0, {0,0}}
	, { 4, 2408, 0, {0,0}}
	, { 4, 2412, 0, {0,0}}
	, { 4, 2416, 0, {0,0}}
	, { 4, 2420, 0, {0,0}}
	, { 4, 2424, 0, {0,0}}
	, { 4, 2428, 0, {0,0}}
	, { 4, 2432, 0, {0,0}}
	, { 4, 2436, 0, {0,0}}
	, { 4, 2440, 0, {0,0}}
	, { 4, 2444, 0, {0,0}}
	, { 4, 2448, 0, {0,0}}
	, { 4, 2452, 0, {0,0}}
	, { 4, 2456, 0, {0,0}}
	, { 4, 2460, 0, {0,0}}
	, { 4, 2464, 0, {0,0}}
	, { 4, 2468, 0, {0,0}}
	, { 4, 2472, 0, {0,0}}
	, { 4, 2476, 0, {0,0}}
	, { 4, 2480, 0, {0,0}}
	, { 4, 2484, 0, {0,0}}
	, { 4, 2488, 0, {0,0}}
	, { 4, 2492, 0, {0,0}}
	, { 4, 2496, 0, {0,0}}
	, { 4, 2500, 0, {0,0}}
	, { 4, 2504, 0, {0,0}}
	, { 4, 2508, 0, {0,0}}
	, { 4, 2512, 0, {0,0}}
	, { 4, 2516, 0, {0,0}}
	, { 4, 2520, 0, {0,0}}
	, { 4, 2524, 0, {0,0}}
	, { 4, 2528, 0, {0,0}}
	, { 4, 2532, 0, {0,0}}
	, { 4, 2536, 0, {0,0}}
	, { 4, 2540, 0, {0,0}}
	, { 4, 2544, 0, {0,0}}
	, { 4, 2548, 0, {0,0}}
	, { 4, 2552, 0, {0,0}}
	, { 4, 2556, 0, {0,0}}
	, { 4, 2560, 0, {0,0}}
	, { 4, 2564, 0, {0,0}}
	, { 4, 2568, 0, {0,0}}
	, { 4, 2572, 0, {0,0}}
	, { 4, 2576, 0, {0,0}}
	, { 4, 2580, 0, {0,0}}
	, { 4, 2584, 0, {0,0}}
	, { 4, 2588, 0, {0,0}}
	, { 4, 2592, 0, {0,0}}
	, { 4, 2596, 0, {0,0}}
	, { 4, 2600, 0, {0,0}}
	, { 4, 2604, 0, {0,0}}
	, { 4, 2608, 0, {0,0}}
	, { 4, 2612, 0, {0,0}}
	, { 4, 2616, 0, {0,0}}
	, { 4, 2620, 0, {0,0}}
	, { 4, 2624, 0, {0,0}}
	, { 4, 2628, 0, {0,0}}
	, { 4, 2632, 0, {0,0}}
	, { 4, 2636, 0, {0,0}}
	, { 4, 2640, 0, {0,0}}
	, { 4, 2644, 0, {0,0}}
	, { 4, 2648, 0, {0,0}}
	, { 4, 2652, 0, {0,0}}
	, { 4, 2656, 0, {0,0}}
	, { 4, 2660, 0, {0,0}}
	, { 4, 2664, 0, {0,0}}
	, { 4, 2668, 0, {0,0}}
	, { 4, 2672, 0, {0,0}}
	, { 4, 2676, 0, {0,0}}
	, { 4, 2680, 0, {0,0}}
	, { 4, 2684, 0, {0,0}}
	, { 4, 2688, 0, {0,0}}
	, { 4, 2692, 0, {0,0}}
	, { 4, 2696, 0, {0,0}}
	, { 4, 2700, 0, {0,0}}
	, { 4, 2704, 0, {0,0}}
	, { 4, 2708, 0, {0,0}}
	, { 4, 2712, 0, {0,0}}
	, { 4, 2716, 0, {0,0}}
	, { 4, 2720, 0, {0,0}}
	, { 4, 2724, 0, {0,0}}
	, { 4, 2728, 0, {0,0}}
	, { 4, 2732, 0, {0,0}}
	, { 4, 2736, 0, {0,0}}
	, { 4, 2740, 0, {0,0}}
	, { 4, 2744, 0, {0,0}}
	, { 4, 2748, 0, {0,0}}
	, { 4, 2752, 0, {0,0}}
	, { 4, 2756, 0, {0,0}}
	, { 4, 2760, 0, {0,0}}
	, { 4, 2764, 0, {0,0}}
	, { 4, 2768, 0, {0,0}}
	, { 4, 2772, 0, {0,0}}
	, { 4, 2776, 0, {0,0}}
	, { 4, 2780, 0, {0,0}}
	, { 4, 2784, 0, {0,0}}
	, { 4, 2788, 0, {0,0}}
	, { 4, 2792, 0, {0,0}}
	, { 4, 2796, 0, {0,0}}
	, { 4, 2800, 0, {0,0}}
	, { 4, 2804, 0, {0,0}}
	, { 4, 2808, 0, {0,0}}
	, { 4, 2812, 0, {0,0}}
	, { 4, 2816, 0, {0,0}}
	, { 4, 2820, 0, {0,0}}
	, { 4, 2824, 0, {0,0}}
	, { 4, 2828, 0, {0,0}}
	, { 4, 2832, 0, {0,0}}
	, { 4, 2836, 0, {0,0}}
	, { 4, 2840, 0, {0,0}}
	, { 4, 2844, 0, {0,0}}
	, { 4, 2848, 0, {0,0}}
	, { 4, 2852, 0, {0,0}}
	, { 4, 2856, 0, {0,0}}
	, { 4, 2860, 0, {0,0}}
	, { 4, 2864, 0, {0,0}}
	, { 4, 2868, 0, {0,0}}
	, { 4, 2872, 0, {0,0}}
	, { 4, 2876, 0, {0,0}}
	, { 4, 2880, 0, {0,0}}
	, { 4, 2884, 0, {0,0}}
	, { 4, 2888, 0, {0,0}}
	, { 4, 2892, 0, {0,0}}
	, { 4, 2896, 0, {0,0}}
	, { 4, 2900, 0, {0,0}}
	, { 4, 2904, 0, {0,0}}
	, { 4, 2908, 0, {0,0}}
	, { 4, 2912, 0, {0,0}}
	, { 4, 2916, 0, {0,0}}
	, { 4, 2920, 0, {0,0}}
	, { 4, 2924, 0, {0,0}}
	, { 4, 2928, 0, {0,0}}
	, { 4, 2932, 0, {0,0}}
	, { 4, 2936, 0, {0,0}}
	, { 4, 2940, 0, {0,0}}
	, { 4, 2944, 0, {0,0}}
	, { 4, 2948, 0, {0,0}}
	, { 4, 2952, 0, {0,0}}
	, { 4, 2956, 0, {0,0}}
	, { 4, 2960, 0, {0,0}}
	, { 4, 2964, 0, {0,0}}
	, { 4, 2968, 0, {0,0}}
	, { 4, 2972, 0, {0,0}}
	, { 4, 2976, 0, {0,0}}
	, { 4, 2980, 0, {0,0}}
	, { 4, 2984, 0, {0,0}}
	, { 4, 2988, 0, {0,0}}
	, { 4, 2992, 0, {0,0}}
	, { 4, 2996, 0, {0,0}}
	, { 4, 3000, 0, {0,0}}
	, { 4, 3004, 0, {0,0}}
	, { 4, 3008, 0, {0,0}}
	, { 4, 3012, 0, {0,0}}
	, { 4, 3016, 0, {0,0}}
	, { 4, 3020, 0, {0,0}}
	, { 4, 3024, 0, {0,0}}
	, { 4, 3028, 0, {0,0}}
	, { 4, 3032, 0, {0,0}}
	, { 4, 3036, 0, {0,0}}
	, { 4, 3040, 0, {0,0}}
	, { 4, 3044, 0, {0,0}}
	, { 4, 3048, 0, {0,0}}
	, { 4, 3052, 0, {0,0}}
	, { 4, 3056, 0, {0,0}}
	, { 6, 14, 2, {0,0}}
	, { 6, 14, 2, {0,1}}
	, { 6, 14, 2, {0,2}}
	, { 6, 14, 2, {0,3}}
	, { 6, 14, 2, {0,4}}
	, { 6, 14, 2, {0,5}}
	, { 6, 14, 2, {0,6}}
	, { 6, 14, 2, {0,7}}
	, { 6, 14, 2, {0,8}}
	, { 6, 14, 2, {0,9}}
	, { 6, 14, 2, {0,10}}
	, { 6, 14, 2, {0,11}}
	, { 6, 14, 2, {0,12}}
	, { 6, 14, 2, {0,13}}
	, { 6, 14, 2, {0,14}}
	, { 6, 14, 2, {0,15}}
	, { 6, 14, 2, {0,16}}
	, { 6, 14, 2, {0,17}}
	, { 6, 14, 2, {0,18}}
	, { 6, 14, 2, {0,19}}
	, { 6, 14, 2, {0,20}}
	, { 6, 14, 2, {0,21}}
	, { 6, 14, 2, {0,22}}
	, { 6, 14, 2, {0,23}}
	, { 6, 14, 2, {0,24}}
	, { 6, 14, 2, {0,25}}
	, { 6, 14, 2, {0,26}}
	, { 6, 14, 2, {0,27}}
	, { 6, 14, 2, {0,28}}
	, { 6, 14, 2, {0,29}}
	, { 6, 14, 2, {0,30}}
	, { 6, 14, 2, {0,31}}
	, { 6, 14, 2, {0,32}}
	, { 6, 14, 2, {0,33}}
	, { 6, 14, 2, {0,34}}
	, { 6, 14, 2, {0,35}}
	, { 6, 14, 2, {0,36}}
	, { 6, 14, 2, {0,37}}
	, { 6, 14, 2, {0,38}}
	, { 6, 14, 2, {0,39}}
	, { 6, 14, 2, {0,40}}
	, { 6, 14, 2, {0,41}}
	, { 6, 14, 2, {0,42}}
	, { 6, 14, 2, {0,43}}
	, { 6, 14, 2, {0,44}}
	, { 6, 14, 2, {0,45}}
	, { 6, 14, 2, {0,46}}
	, { 6, 14, 2, {0,47}}
	, { 6, 14, 2, {0,48}}
	, { 6, 14, 2, {0,49}}
	, { 6, 14, 2, {0,50}}
	, { 6, 14, 2, {0,51}}
	, { 6, 14, 2, {0,52}}
	, { 6, 14, 2, {0,53}}
	, { 6, 14, 2, {0,54}}
	, { 6, 14, 2, {0,55}}
	, { 6, 14, 2, {0,56}}
	, { 6, 14, 2, {0,57}}
	, { 6, 14, 2, {0,58}}
	, { 6, 14, 2, {0,59}}
	, { 6, 14, 2, {0,60}}
	, { 6, 14, 2, {0,61}}
	, { 6, 14, 2, {0,62}}
	, { 6, 14, 2, {0,63}}
	, { 6, 14, 2, {0,64}}
	, { 6, 14, 2, {0,65}}
	, { 6, 14, 2, {0,66}}
	, { 6, 14, 2, {0,67}}
	, { 6, 14, 2, {0,68}}
	, { 6, 14, 2, {0,69}}
	, { 6, 14, 2, {0,70}}
	, { 6, 14, 2, {0,71}}
	, { 6, 14, 2, {0,72}}
	, { 6, 14, 2, {0,73}}
	, { 6, 14, 2, {0,74}}
	, { 6, 14, 2, {0,75}}
	, { 6, 14, 2, {0,76}}
	, { 6, 14, 2, {0,77}}
	, { 6, 14, 2, {0,78}}
	, { 6, 14, 2, {0,79}}
	, { 6, 14, 2, {0,80}}
	, { 6, 14, 2, {0,81}}
	, { 6, 14, 2, {0,82}}
	, { 6, 14, 2, {0,83}}
	, { 6, 14, 2, {0,84}}
	, { 6, 14, 2, {0,85}}
	, { 6, 14, 2, {0,86}}
	, { 6, 14, 2, {0,87}}
	, { 6, 14, 2, {0,88}}
	, { 6, 14, 2, {0,89}}
	, { 6, 14, 2, {0,90}}
	, { 6, 14, 2, {0,91}}
	, { 6, 14, 2, {0,92}}
	, { 6, 14, 2, {0,93}}
	, { 6, 14, 2, {0,94}}
	, { 6, 14, 2, {0,95}}
	, { 6, 14, 2, {0,96}}
	, { 6, 14, 2, {0,97}}
	, { 6, 14, 2, {0,98}}
	, { 6, 14, 2, {0,99}}
	, { 6, 14, 2, {0,100}}
	, { 6, 14, 2, {0,101}}
	, { 6, 14, 2, {0,102}}
	, { 6, 14, 2, {0,103}}
	, { 6, 14, 2, {0,104}}
	, { 6, 14, 2, {0,105}}
	, { 6, 14, 2, {0,106}}
	, { 6, 14, 2, {0,107}}
	, { 6, 14, 2, {0,108}}
	, { 6, 14, 2, {0,109}}
	, { 6, 14, 2, {0,110}}
	, { 6, 14, 2, {0,111}}
	, { 6, 14, 2, {0,112}}
	, { 6, 14, 2, {0,113}}
	, { 6, 14, 2, {0,114}}
	, { 6, 14, 2, {0,115}}
	, { 6, 14, 2, {0,116}}
	, { 6, 14, 2, {0,117}}
	, { 6, 14, 2, {0,118}}
	, { 6, 14, 2, {0,119}}
	, { 6, 14, 2, {0,120}}
	, { 6, 14, 2, {0,121}}
	, { 6, 14, 2, {0,122}}
	, { 6, 14, 2, {0,123}}
	, { 6, 14, 2, {0,124}}
	, { 6, 14, 2, {0,125}}
	, { 6, 14, 2, {0,126}}
	, { 6, 14, 2, {0,127}}
	, { 6, 14, 2, {0,128}}
	, { 6, 14, 2, {0,129}}
	, { 6, 14, 2, {0,130}}
	, { 6, 14, 2, {0,131}}
	, { 6, 14, 2, {0,132}}
	, { 6, 14, 2, {0,133}}
	, { 6, 14, 2, {0,134}}
	, { 6, 14, 2, {0,135}}
	, { 6, 14, 2, {0,136}}
	, { 6, 14, 2, {0,137}}
	, { 6, 14, 2, {0,138}}
	, { 6, 14, 2, {0,139}}
	, { 6, 14, 2, {0,140}}
	, { 6, 14, 2, {0,141}}
	, { 6, 14, 2, {0,142}}
	, { 6, 14, 2, {0,143}}
	, { 6, 14, 2, {0,144}}
	, { 6, 14, 2, {0,145}}
	, { 6, 14, 2, {0,146}}
	, { 6, 14, 2, {0,147}}
	, { 6, 14, 2, {0,148}}
	, { 6, 14, 2, {0,149}}
	, { 6, 14, 2, {0,150}}
	, { 6, 14, 2, {0,151}}
	, { 6, 14, 2, {0,152}}
	, { 6, 14, 2, {0,153}}
	, { 6, 14, 2, {0,154}}
	, { 6, 14, 2, {0,155}}
	, { 6, 14, 2, {0,156}}
	, { 6, 14, 2, {0,157}}
	, { 6, 14, 2, {0,158}}
	, { 6, 14, 2, {0,159}}
	, { 6, 14, 2, {0,160}}
	, { 6, 14, 2, {0,161}}
	, { 6, 14, 2, {0,162}}
	, { 6, 14, 2, {0,163}}
	, { 6, 14, 2, {0,164}}
	, { 6, 14, 2, {0,165}}
	, { 6, 14, 2, {0,166}}
	, { 6, 14, 2, {0,167}}
	, { 6, 14, 2, {0,168}}
	, { 6, 14, 2, {0,169}}
	, { 6, 14, 2, {0,170}}
	, { 6, 14, 2, {0,171}}
	, { 6, 14, 2, {0,172}}
	, { 6, 14, 2, {0,173}}
	, { 6, 14, 2, {0,174}}
	, { 6, 14, 2, {0,175}}
	, { 6, 14, 2, {0,176}}
	, { 6, 14, 2, {0,177}}
	, { 6, 14, 2, {0,178}}
	, { 6, 14, 2, {0,179}}
	, { 6, 14, 2, {0,180}}
	, { 6, 14, 2, {0,181}}
	, { 6, 14, 2, {0,182}}
	, { 6, 14, 2, {0,183}}
	, { 6, 14, 2, {0,184}}
	, { 6, 14, 2, {0,185}}
	, { 6, 14, 2, {0,186}}
	, { 6, 14, 2, {0,187}}
	, { 6, 14, 2, {0,188}}
	, { 6, 14, 2, {0,189}}
	, { 6, 14, 2, {0,190}}
	, { 6, 14, 2, {0,191}}
	, { 6, 14, 2, {0,192}}
	, { 6, 14, 2, {0,193}}
	, { 6, 14, 2, {0,194}}
	, { 6, 14, 2, {0,195}}
	, { 6, 14, 2, {0,196}}
	, { 6, 14, 2, {0,197}}
	, { 6, 14, 2, {0,198}}
	, { 6, 14, 2, {0,199}}
	, { 6, 14, 2, {0,200}}
	, { 6, 14, 2, {0,201}}
	, { 6, 14, 2, {0,202}}
	, { 6, 14, 2, {0,203}}
	, { 6, 14, 2, {0,204}}
	, { 6, 14, 2, {0,205}}
	, { 6, 14, 2, {0,206}}
	, { 6, 14, 2, {0,207}}
	, { 6, 14, 2, {0,208}}
	, { 6, 14, 2, {0,209}}
	, { 6, 14, 2, {0,210}}
	, { 6, 14, 2, {0,211}}
	, { 6, 14, 2, {0,212}}
	, { 6, 14, 2, {0,213}}
	, { 6, 14, 2, {0,214}}
	, { 6, 14, 2, {0,215}}
	, { 6, 14, 2, {0,216}}
	, { 6, 14, 2, {0,217}}
	, { 6, 14, 2, {0,218}}
	, { 6, 14, 2, {0,219}}
	, { 6, 14, 2, {0,220}}
	, { 6, 14, 2, {0,221}}
	, { 6, 14, 2, {0,222}}
	, { 6, 14, 2, {0,223}}
	, { 6, 14, 2, {0,224}}
	, { 6, 14, 2, {0,225}}
	, { 6, 14, 2, {0,226}}
	, { 6, 14, 2, {0,227}}
	, { 6, 14, 2, {0,228}}
	, { 6, 14, 2, {0,229}}
	, { 6, 14, 2, {0,230}}
	, { 6, 14, 2, {0,231}}
	, { 6, 14, 2, {0,232}}
	, { 6, 14, 2, {0,233}}
	, { 6, 14, 2, {0,234}}
	, { 6, 14, 2, {0,235}}
	, { 6, 14, 2, {0,236}}
	, { 6, 14, 2, {0,237}}
	, { 6, 14, 2, {0,238}}
	, { 6, 14, 2, {0,239}}
	, { 6, 14, 2, {0,240}}
	, { 6, 14, 2, {0,241}}
	, { 6, 14, 2, {0,242}}
	, { 6, 14, 2, {0,243}}
	, { 6, 14, 2, {0,244}}
	, { 6, 14, 2, {0,245}}
	, { 6, 14, 2, {0,246}}
	, { 6, 14, 2, {0,247}}
	, { 6, 14, 2, {0,248}}
	, { 6, 14, 2, {0,249}}
	, { 6, 14, 2, {0,250}}
	, { 6, 14, 2, {0,251}}
	, { 6, 14, 2, {0,252}}
	, { 6, 14, 2, {0,253}}
	, { 6, 14, 2, {0,254}}
	, { 6, 14, 2, {0,255}}
	, { 6, 14, 2, {0,256}}
	, { 6, 14, 2, {0,257}}
	, { 6, 14, 2, {0,258}}
	, { 6, 14, 2, {0,259}}
	, { 6, 14, 2, {0,260}}
	, { 6, 14, 2, {0,261}}
	, { 6, 14, 2, {0,262}}
	, { 6, 14, 2, {0,263}}
	, { 6, 14, 2, {0,264}}
	, { 6, 14, 2, {0,265}}
	, { 6, 14, 2, {0,266}}
	, { 6, 14, 2, {0,267}}
	, { 6, 14, 2, {0,268}}
	, { 6, 14, 2, {0,269}}
	, { 6, 14, 2, {0,270}}
	, { 6, 14, 2, {0,271}}
	, { 10, 6, 1, {327681,0}}
	, { 10, 6, 1, {327937,0}}
	, { 10, 6, 1, {328193,0}}
	, { 10, 6, 1, {328449,0}}
	, { 10, 6, 1, {328705,0}}
	, { 10, 6, 1, {328961,0}}
	, { 10, 6, 1, {329217,0}}
	, { 10, 6, 1, {329473,0}}
	, { 10, 6, 1, {329729,0}}
	, { 10, 6, 1, {329985,0}}
	, { 10, 6, 1, {330241,0}}
	, { 10, 6, 1, {330497,0}}};

static const struct vfc_read_task vfc_task_t_e3b0 = {vfc_vectors_t_e3b0, 1049};
static const struct vfc_read_write_vector vfc_vectors_x_e3b0[1049] = {
	{ 4, 0, 0, {0,0}}
	, { 4, 4, 0, {0,0}}
	, { 4, 8, 0, {0,0}}
	, { 4, 12, 0, {0,0}}
	, { 4, 16, 0, {0,0}}
	, { 4, 20, 0, {0,0}}
	, { 4, 24, 0, {0,0}}
	, { 4, 28, 0, {0,0}}
	, { 4, 32, 0, {0,0}}
	, { 4, 36, 0, {0,0}}
	, { 4, 40, 0, {0,0}}
	, { 4, 44, 0, {0,0}}
	, { 4, 48, 0, {0,0}}
	, { 4, 52, 0, {0,0}}
	, { 4, 56, 0, {0,0}}
	, { 4, 60, 0, {0,0}}
	, { 4, 64, 0, {0,0}}
	, { 4, 68, 0, {0,0}}
	, { 4, 72, 0, {0,0}}
	, { 4, 76, 0, {0,0}}
	, { 4, 80, 0, {0,0}}
	, { 4, 84, 0, {0,0}}
	, { 4, 88, 0, {0,0}}
	, { 4, 92, 0, {0,0}}
	, { 4, 96, 0, {0,0}}
	, { 4, 100, 0, {0,0}}
	, { 4, 104, 0, {0,0}}
	, { 4, 108, 0, {0,0}}
	, { 4, 112, 0, {0,0}}
	, { 4, 116, 0, {0,0}}
	, { 4, 120, 0, {0,0}}
	, { 4, 124, 0, {0,0}}
	, { 4, 128, 0, {0,0}}
	, { 4, 132, 0, {0,0}}
	, { 4, 136, 0, {0,0}}
	, { 4, 140, 0, {0,0}}
	, { 4, 144, 0, {0,0}}
	, { 4, 148, 0, {0,0}}
	, { 4, 152, 0, {0,0}}
	, { 4, 156, 0, {0,0}}
	, { 4, 160, 0, {0,0}}
	, { 4, 164, 0, {0,0}}
	, { 4, 168, 0, {0,0}}
	, { 4, 172, 0, {0,0}}
	, { 4, 176, 0, {0,0}}
	, { 4, 180, 0, {0,0}}
	, { 4, 184, 0, {0,0}}
	, { 4, 188, 0, {0,0}}
	, { 4, 192, 0, {0,0}}
	, { 4, 196, 0, {0,0}}
	, { 4, 200, 0, {0,0}}
	, { 4, 204, 0, {0,0}}
	, { 4, 208, 0, {0,0}}
	, { 4, 212, 0, {0,0}}
	, { 4, 216, 0, {0,0}}
	, { 4, 220, 0, {0,0}}
	, { 4, 224, 0, {0,0}}
	, { 4, 228, 0, {0,0}}
	, { 4, 232, 0, {0,0}}
	, { 4, 236, 0, {0,0}}
	, { 4, 240, 0, {0,0}}
	, { 4, 244, 0, {0,0}}
	, { 4, 248, 0, {0,0}}
	, { 4, 252, 0, {0,0}}
	, { 4, 256, 0, {0,0}}
	, { 4, 260, 0, {0,0}}
	, { 4, 264, 0, {0,0}}
	, { 4, 268, 0, {0,0}}
	, { 4, 272, 0, {0,0}}
	, { 4, 276, 0, {0,0}}
	, { 4, 280, 0, {0,0}}
	, { 4, 284, 0, {0,0}}
	, { 4, 288, 0, {0,0}}
	, { 4, 292, 0, {0,0}}
	, { 4, 296, 0, {0,0}}
	, { 4, 300, 0, {0,0}}
	, { 4, 304, 0, {0,0}}
	, { 4, 308, 0, {0,0}}
	, { 4, 312, 0, {0,0}}
	, { 4, 316, 0, {0,0}}
	, { 4, 320, 0, {0,0}}
	, { 4, 324, 0, {0,0}}
	, { 4, 328, 0, {0,0}}
	, { 4, 332, 0, {0,0}}
	, { 4, 336, 0, {0,0}}
	, { 4, 340, 0, {0,0}}
	, { 4, 344, 0, {0,0}}
	, { 4, 348, 0, {0,0}}
	, { 4, 352, 0, {0,0}}
	, { 4, 356, 0, {0,0}}
	, { 4, 360, 0, {0,0}}
	, { 4, 364, 0, {0,0}}
	, { 4, 368, 0, {0,0}}
	, { 4, 372, 0, {0,0}}
	, { 4, 376, 0, {0,0}}
	, { 4, 380, 0, {0,0}}
	, { 4, 384, 0, {0,0}}
	, { 4, 388, 0, {0,0}}
	, { 4, 392, 0, {0,0}}
	, { 4, 396, 0, {0,0}}
	, { 4, 400, 0, {0,0}}
	, { 4, 404, 0, {0,0}}
	, { 4, 408, 0, {0,0}}
	, { 4, 412, 0, {0,0}}
	, { 4, 416, 0, {0,0}}
	, { 4, 420, 0, {0,0}}
	, { 4, 424, 0, {0,0}}
	, { 4, 428, 0, {0,0}}
	, { 4, 432, 0, {0,0}}
	, { 4, 436, 0, {0,0}}
	, { 4, 440, 0, {0,0}}
	, { 4, 444, 0, {0,0}}
	, { 4, 448, 0, {0,0}}
	, { 4, 452, 0, {0,0}}
	, { 4, 456, 0, {0,0}}
	, { 4, 460, 0, {0,0}}
	, { 4, 464, 0, {0,0}}
	, { 4, 468, 0, {0,0}}
	, { 4, 472, 0, {0,0}}
	, { 4, 476, 0, {0,0}}
	, { 4, 480, 0, {0,0}}
	, { 4, 484, 0, {0,0}}
	, { 4, 488, 0, {0,0}}
	, { 4, 492, 0, {0,0}}
	, { 4, 496, 0, {0,0}}
	, { 4, 500, 0, {0,0}}
	, { 4, 504, 0, {0,0}}
	, { 4, 508, 0, {0,0}}
	, { 4, 512, 0, {0,0}}
	, { 4, 516, 0, {0,0}}
	, { 4, 520, 0, {0,0}}
	, { 4, 524, 0, {0,0}}
	, { 4, 528, 0, {0,0}}
	, { 4, 532, 0, {0,0}}
	, { 4, 536, 0, {0,0}}
	, { 4, 540, 0, {0,0}}
	, { 4, 544, 0, {0,0}}
	, { 4, 548, 0, {0,0}}
	, { 4, 552, 0, {0,0}}
	, { 4, 556, 0, {0,0}}
	, { 4, 560, 0, {0,0}}
	, { 4, 564, 0, {0,0}}
	, { 4, 568, 0, {0,0}}
	, { 4, 572, 0, {0,0}}
	, { 4, 576, 0, {0,0}}
	, { 4, 580, 0, {0,0}}
	, { 4, 584, 0, {0,0}}
	, { 4, 588, 0, {0,0}}
	, { 4, 592, 0, {0,0}}
	, { 4, 596, 0, {0,0}}
	, { 4, 600, 0, {0,0}}
	, { 4, 604, 0, {0,0}}
	, { 4, 608, 0, {0,0}}
	, { 4, 612, 0, {0,0}}
	, { 4, 616, 0, {0,0}}
	, { 4, 620, 0, {0,0}}
	, { 4, 624, 0, {0,0}}
	, { 4, 628, 0, {0,0}}
	, { 4, 632, 0, {0,0}}
	, { 4, 636, 0, {0,0}}
	, { 4, 640, 0, {0,0}}
	, { 4, 644, 0, {0,0}}
	, { 4, 648, 0, {0,0}}
	, { 4, 652, 0, {0,0}}
	, { 4, 656, 0, {0,0}}
	, { 4, 660, 0, {0,0}}
	, { 4, 664, 0, {0,0}}
	, { 4, 668, 0, {0,0}}
	, { 4, 672, 0, {0,0}}
	, { 4, 676, 0, {0,0}}
	, { 4, 680, 0, {0,0}}
	, { 4, 684, 0, {0,0}}
	, { 4, 688, 0, {0,0}}
	, { 4, 692, 0, {0,0}}
	, { 4, 696, 0, {0,0}}
	, { 4, 700, 0, {0,0}}
	, { 4, 704, 0, {0,0}}
	, { 4, 708, 0, {0,0}}
	, { 4, 712, 0, {0,0}}
	, { 4, 716, 0, {0,0}}
	, { 4, 720, 0, {0,0}}
	, { 4, 724, 0, {0,0}}
	, { 4, 728, 0, {0,0}}
	, { 4, 732, 0, {0,0}}
	, { 4, 736, 0, {0,0}}
	, { 4, 740, 0, {0,0}}
	, { 4, 744, 0, {0,0}}
	, { 4, 748, 0, {0,0}}
	, { 4, 752, 0, {0,0}}
	, { 4, 756, 0, {0,0}}
	, { 4, 760, 0, {0,0}}
	, { 4, 764, 0, {0,0}}
	, { 4, 768, 0, {0,0}}
	, { 4, 772, 0, {0,0}}
	, { 4, 776, 0, {0,0}}
	, { 4, 780, 0, {0,0}}
	, { 4, 784, 0, {0,0}}
	, { 4, 788, 0, {0,0}}
	, { 4, 792, 0, {0,0}}
	, { 4, 796, 0, {0,0}}
	, { 4, 800, 0, {0,0}}
	, { 4, 804, 0, {0,0}}
	, { 4, 808, 0, {0,0}}
	, { 4, 812, 0, {0,0}}
	, { 4, 816, 0, {0,0}}
	, { 4, 820, 0, {0,0}}
	, { 4, 824, 0, {0,0}}
	, { 4, 828, 0, {0,0}}
	, { 4, 832, 0, {0,0}}
	, { 4, 836, 0, {0,0}}
	, { 4, 840, 0, {0,0}}
	, { 4, 844, 0, {0,0}}
	, { 4, 848, 0, {0,0}}
	, { 4, 852, 0, {0,0}}
	, { 4, 856, 0, {0,0}}
	, { 4, 860, 0, {0,0}}
	, { 4, 864, 0, {0,0}}
	, { 4, 868, 0, {0,0}}
	, { 4, 872, 0, {0,0}}
	, { 4, 876, 0, {0,0}}
	, { 4, 880, 0, {0,0}}
	, { 4, 884, 0, {0,0}}
	, { 4, 888, 0, {0,0}}
	, { 4, 892, 0, {0,0}}
	, { 4, 896, 0, {0,0}}
	, { 4, 900, 0, {0,0}}
	, { 4, 904, 0, {0,0}}
	, { 4, 908, 0, {0,0}}
	, { 4, 912, 0, {0,0}}
	, { 4, 916, 0, {0,0}}
	, { 4, 920, 0, {0,0}}
	, { 4, 924, 0, {0,0}}
	, { 4, 928, 0, {0,0}}
	, { 4, 932, 0, {0,0}}
	, { 4, 936, 0, {0,0}}
	, { 4, 940, 0, {0,0}}
	, { 4, 944, 0, {0,0}}
	, { 4, 948, 0, {0,0}}
	, { 4, 952, 0, {0,0}}
	, { 4, 956, 0, {0,0}}
	, { 4, 960, 0, {0,0}}
	, { 4, 964, 0, {0,0}}
	, { 4, 968, 0, {0,0}}
	, { 4, 972, 0, {0,0}}
	, { 4, 976, 0, {0,0}}
	, { 4, 980, 0, {0,0}}
	, { 4, 984, 0, {0,0}}
	, { 4, 988, 0, {0,0}}
	, { 4, 992, 0, {0,0}}
	, { 4, 996, 0, {0,0}}
	, { 4, 1000, 0, {0,0}}
	, { 4, 1004, 0, {0,0}}
	, { 4, 1008, 0, {0,0}}
	, { 4, 1012, 0, {0,0}}
	, { 4, 1016, 0, {0,0}}
	, { 4, 1020, 0, {0,0}}
	, { 4, 1024, 0, {0,0}}
	, { 4, 1028, 0, {0,0}}
	, { 4, 1032, 0, {0,0}}
	, { 4, 1036, 0, {0,0}}
	, { 4, 1040, 0, {0,0}}
	, { 4, 1044, 0, {0,0}}
	, { 4, 1048, 0, {0,0}}
	, { 4, 1052, 0, {0,0}}
	, { 4, 1056, 0, {0,0}}
	, { 4, 1060, 0, {0,0}}
	, { 4, 1064, 0, {0,0}}
	, { 4, 1068, 0, {0,0}}
	, { 4, 1072, 0, {0,0}}
	, { 4, 1076, 0, {0,0}}
	, { 4, 1080, 0, {0,0}}
	, { 4, 1084, 0, {0,0}}
	, { 4, 1088, 0, {0,0}}
	, { 4, 1092, 0, {0,0}}
	, { 4, 1096, 0, {0,0}}
	, { 4, 1100, 0, {0,0}}
	, { 4, 1104, 0, {0,0}}
	, { 4, 1108, 0, {0,0}}
	, { 4, 1112, 0, {0,0}}
	, { 4, 1116, 0, {0,0}}
	, { 4, 1120, 0, {0,0}}
	, { 4, 1124, 0, {0,0}}
	, { 4, 1128, 0, {0,0}}
	, { 4, 1132, 0, {0,0}}
	, { 4, 1136, 0, {0,0}}
	, { 4, 1140, 0, {0,0}}
	, { 4, 1144, 0, {0,0}}
	, { 4, 1148, 0, {0,0}}
	, { 4, 1152, 0, {0,0}}
	, { 4, 1156, 0, {0,0}}
	, { 4, 1160, 0, {0,0}}
	, { 4, 1164, 0, {0,0}}
	, { 4, 1168, 0, {0,0}}
	, { 4, 1172, 0, {0,0}}
	, { 4, 1176, 0, {0,0}}
	, { 4, 1180, 0, {0,0}}
	, { 4, 1184, 0, {0,0}}
	, { 4, 1188, 0, {0,0}}
	, { 4, 1192, 0, {0,0}}
	, { 4, 1196, 0, {0,0}}
	, { 4, 1200, 0, {0,0}}
	, { 4, 1204, 0, {0,0}}
	, { 4, 1208, 0, {0,0}}
	, { 4, 1212, 0, {0,0}}
	, { 4, 1216, 0, {0,0}}
	, { 4, 1220, 0, {0,0}}
	, { 4, 1224, 0, {0,0}}
	, { 4, 1228, 0, {0,0}}
	, { 4, 1232, 0, {0,0}}
	, { 4, 1236, 0, {0,0}}
	, { 4, 1240, 0, {0,0}}
	, { 4, 1244, 0, {0,0}}
	, { 4, 1248, 0, {0,0}}
	, { 4, 1252, 0, {0,0}}
	, { 4, 1256, 0, {0,0}}
	, { 4, 1260, 0, {0,0}}
	, { 4, 1264, 0, {0,0}}
	, { 4, 1268, 0, {0,0}}
	, { 4, 1272, 0, {0,0}}
	, { 4, 1276, 0, {0,0}}
	, { 4, 1280, 0, {0,0}}
	, { 4, 1284, 0, {0,0}}
	, { 4, 1288, 0, {0,0}}
	, { 4, 1292, 0, {0,0}}
	, { 4, 1296, 0, {0,0}}
	, { 4, 1300, 0, {0,0}}
	, { 4, 1304, 0, {0,0}}
	, { 4, 1308, 0, {0,0}}
	, { 4, 1312, 0, {0,0}}
	, { 4, 1316, 0, {0,0}}
	, { 4, 1320, 0, {0,0}}
	, { 4, 1324, 0, {0,0}}
	, { 4, 1328, 0, {0,0}}
	, { 4, 1332, 0, {0,0}}
	, { 4, 1336, 0, {0,0}}
	, { 4, 1340, 0, {0,0}}
	, { 4, 1344, 0, {0,0}}
	, { 4, 1348, 0, {0,0}}
	, { 4, 1352, 0, {0,0}}
	, { 4, 1356, 0, {0,0}}
	, { 4, 1360, 0, {0,0}}
	, { 4, 1364, 0, {0,0}}
	, { 4, 1368, 0, {0,0}}
	, { 4, 1372, 0, {0,0}}
	, { 4, 1376, 0, {0,0}}
	, { 4, 1380, 0, {0,0}}
	, { 4, 1384, 0, {0,0}}
	, { 4, 1388, 0, {0,0}}
	, { 4, 1392, 0, {0,0}}
	, { 4, 1396, 0, {0,0}}
	, { 4, 1400, 0, {0,0}}
	, { 4, 1404, 0, {0,0}}
	, { 4, 1408, 0, {0,0}}
	, { 4, 1412, 0, {0,0}}
	, { 4, 1416, 0, {0,0}}
	, { 4, 1420, 0, {0,0}}
	, { 4, 1424, 0, {0,0}}
	, { 4, 1428, 0, {0,0}}
	, { 4, 1432, 0, {0,0}}
	, { 4, 1436, 0, {0,0}}
	, { 4, 1440, 0, {0,0}}
	, { 4, 1444, 0, {0,0}}
	, { 4, 1448, 0, {0,0}}
	, { 4, 1452, 0, {0,0}}
	, { 4, 1456, 0, {0,0}}
	, { 4, 1460, 0, {0,0}}
	, { 4, 1464, 0, {0,0}}
	, { 4, 1468, 0, {0,0}}
	, { 4, 1472, 0, {0,0}}
	, { 4, 1476, 0, {0,0}}
	, { 4, 1480, 0, {0,0}}
	, { 4, 1484, 0, {0,0}}
	, { 4, 1488, 0, {0,0}}
	, { 4, 1492, 0, {0,0}}
	, { 4, 1496, 0, {0,0}}
	, { 4, 1500, 0, {0,0}}
	, { 4, 1504, 0, {0,0}}
	, { 4, 1508, 0, {0,0}}
	, { 4, 1512, 0, {0,0}}
	, { 4, 1516, 0, {0,0}}
	, { 4, 1520, 0, {0,0}}
	, { 4, 1524, 0, {0,0}}
	, { 4, 1528, 0, {0,0}}
	, { 4, 1532, 0, {0,0}}
	, { 4, 1536, 0, {0,0}}
	, { 4, 1540, 0, {0,0}}
	, { 4, 1544, 0, {0,0}}
	, { 4, 1548, 0, {0,0}}
	, { 4, 1552, 0, {0,0}}
	, { 4, 1556, 0, {0,0}}
	, { 4, 1560, 0, {0,0}}
	, { 4, 1564, 0, {0,0}}
	, { 4, 1568, 0, {0,0}}
	, { 4, 1572, 0, {0,0}}
	, { 4, 1576, 0, {0,0}}
	, { 4, 1580, 0, {0,0}}
	, { 4, 1584, 0, {0,0}}
	, { 4, 1588, 0, {0,0}}
	, { 4, 1592, 0, {0,0}}
	, { 4, 1596, 0, {0,0}}
	, { 4, 1600, 0, {0,0}}
	, { 4, 1604, 0, {0,0}}
	, { 4, 1608, 0, {0,0}}
	, { 4, 1612, 0, {0,0}}
	, { 4, 1616, 0, {0,0}}
	, { 4, 1620, 0, {0,0}}
	, { 4, 1624, 0, {0,0}}
	, { 4, 1628, 0, {0,0}}
	, { 4, 1632, 0, {0,0}}
	, { 4, 1636, 0, {0,0}}
	, { 4, 1640, 0, {0,0}}
	, { 4, 1644, 0, {0,0}}
	, { 4, 1648, 0, {0,0}}
	, { 4, 1652, 0, {0,0}}
	, { 4, 1656, 0, {0,0}}
	, { 4, 1660, 0, {0,0}}
	, { 4, 1664, 0, {0,0}}
	, { 4, 1668, 0, {0,0}}
	, { 4, 1672, 0, {0,0}}
	, { 4, 1676, 0, {0,0}}
	, { 4, 1680, 0, {0,0}}
	, { 4, 1684, 0, {0,0}}
	, { 4, 1688, 0, {0,0}}
	, { 4, 1692, 0, {0,0}}
	, { 4, 1696, 0, {0,0}}
	, { 4, 1700, 0, {0,0}}
	, { 4, 1704, 0, {0,0}}
	, { 4, 1708, 0, {0,0}}
	, { 4, 1712, 0, {0,0}}
	, { 4, 1716, 0, {0,0}}
	, { 4, 1720, 0, {0,0}}
	, { 4, 1724, 0, {0,0}}
	, { 4, 1728, 0, {0,0}}
	, { 4, 1732, 0, {0,0}}
	, { 4, 1736, 0, {0,0}}
	, { 4, 1740, 0, {0,0}}
	, { 4, 1744, 0, {0,0}}
	, { 4, 1748, 0, {0,0}}
	, { 4, 1752, 0, {0,0}}
	, { 4, 1756, 0, {0,0}}
	, { 4, 1760, 0, {0,0}}
	, { 4, 1764, 0, {0,0}}
	, { 4, 1768, 0, {0,0}}
	, { 4, 1772, 0, {0,0}}
	, { 4, 1776, 0, {0,0}}
	, { 4, 1780, 0, {0,0}}
	, { 4, 1784, 0, {0,0}}
	, { 4, 1788, 0, {0,0}}
	, { 4, 1792, 0, {0,0}}
	, { 4, 1796, 0, {0,0}}
	, { 4, 1800, 0, {0,0}}
	, { 4, 1804, 0, {0,0}}
	, { 4, 1808, 0, {0,0}}
	, { 4, 1812, 0, {0,0}}
	, { 4, 1816, 0, {0,0}}
	, { 4, 1820, 0, {0,0}}
	, { 4, 1824, 0, {0,0}}
	, { 4, 1828, 0, {0,0}}
	, { 4, 1832, 0, {0,0}}
	, { 4, 1836, 0, {0,0}}
	, { 4, 1840, 0, {0,0}}
	, { 4, 1844, 0, {0,0}}
	, { 4, 1848, 0, {0,0}}
	, { 4, 1852, 0, {0,0}}
	, { 4, 1856, 0, {0,0}}
	, { 4, 1860, 0, {0,0}}
	, { 4, 1864, 0, {0,0}}
	, { 4, 1868, 0, {0,0}}
	, { 4, 1872, 0, {0,0}}
	, { 4, 1876, 0, {0,0}}
	, { 4, 1880, 0, {0,0}}
	, { 4, 1884, 0, {0,0}}
	, { 4, 1888, 0, {0,0}}
	, { 4, 1892, 0, {0,0}}
	, { 4, 1896, 0, {0,0}}
	, { 4, 1900, 0, {0,0}}
	, { 4, 1904, 0, {0,0}}
	, { 4, 1908, 0, {0,0}}
	, { 4, 1912, 0, {0,0}}
	, { 4, 1916, 0, {0,0}}
	, { 4, 1920, 0, {0,0}}
	, { 4, 1924, 0, {0,0}}
	, { 4, 1928, 0, {0,0}}
	, { 4, 1932, 0, {0,0}}
	, { 4, 1936, 0, {0,0}}
	, { 4, 1940, 0, {0,0}}
	, { 4, 1944, 0, {0,0}}
	, { 4, 1948, 0, {0,0}}
	, { 4, 1952, 0, {0,0}}
	, { 4, 1956, 0, {0,0}}
	, { 4, 1960, 0, {0,0}}
	, { 4, 1964, 0, {0,0}}
	, { 4, 1968, 0, {0,0}}
	, { 4, 1972, 0, {0,0}}
	, { 4, 1976, 0, {0,0}}
	, { 4, 1980, 0, {0,0}}
	, { 4, 1984, 0, {0,0}}
	, { 4, 1988, 0, {0,0}}
	, { 4, 1992, 0, {0,0}}
	, { 4, 1996, 0, {0,0}}
	, { 4, 2000, 0, {0,0}}
	, { 4, 2004, 0, {0,0}}
	, { 4, 2008, 0, {0,0}}
	, { 4, 2012, 0, {0,0}}
	, { 4, 2016, 0, {0,0}}
	, { 4, 2020, 0, {0,0}}
	, { 4, 2024, 0, {0,0}}
	, { 4, 2028, 0, {0,0}}
	, { 4, 2032, 0, {0,0}}
	, { 4, 2036, 0, {0,0}}
	, { 4, 2040, 0, {0,0}}
	, { 4, 2044, 0, {0,0}}
	, { 4, 2048, 0, {0,0}}
	, { 4, 2052, 0, {0,0}}
	, { 4, 2056, 0, {0,0}}
	, { 4, 2060, 0, {0,0}}
	, { 4, 2064, 0, {0,0}}
	, { 4, 2068, 0, {0,0}}
	, { 4, 2072, 0, {0,0}}
	, { 4, 2076, 0, {0,0}}
	, { 4, 2080, 0, {0,0}}
	, { 4, 2084, 0, {0,0}}
	, { 4, 2088, 0, {0,0}}
	, { 4, 2092, 0, {0,0}}
	, { 4, 2096, 0, {0,0}}
	, { 4, 2100, 0, {0,0}}
	, { 4, 2104, 0, {0,0}}
	, { 4, 2108, 0, {0,0}}
	, { 4, 2112, 0, {0,0}}
	, { 4, 2116, 0, {0,0}}
	, { 4, 2120, 0, {0,0}}
	, { 4, 2124, 0, {0,0}}
	, { 4, 2128, 0, {0,0}}
	, { 4, 2132, 0, {0,0}}
	, { 4, 2136, 0, {0,0}}
	, { 4, 2140, 0, {0,0}}
	, { 4, 2144, 0, {0,0}}
	, { 4, 2148, 0, {0,0}}
	, { 4, 2152, 0, {0,0}}
	, { 4, 2156, 0, {0,0}}
	, { 4, 2160, 0, {0,0}}
	, { 4, 2164, 0, {0,0}}
	, { 4, 2168, 0, {0,0}}
	, { 4, 2172, 0, {0,0}}
	, { 4, 2176, 0, {0,0}}
	, { 4, 2180, 0, {0,0}}
	, { 4, 2184, 0, {0,0}}
	, { 4, 2188, 0, {0,0}}
	, { 4, 2192, 0, {0,0}}
	, { 4, 2196, 0, {0,0}}
	, { 4, 2200, 0, {0,0}}
	, { 4, 2204, 0, {0,0}}
	, { 4, 2208, 0, {0,0}}
	, { 4, 2212, 0, {0,0}}
	, { 4, 2216, 0, {0,0}}
	, { 4, 2220, 0, {0,0}}
	, { 4, 2224, 0, {0,0}}
	, { 4, 2228, 0, {0,0}}
	, { 4, 2232, 0, {0,0}}
	, { 4, 2236, 0, {0,0}}
	, { 4, 2240, 0, {0,0}}
	, { 4, 2244, 0, {0,0}}
	, { 4, 2248, 0, {0,0}}
	, { 4, 2252, 0, {0,0}}
	, { 4, 2256, 0, {0,0}}
	, { 4, 2260, 0, {0,0}}
	, { 4, 2264, 0, {0,0}}
	, { 4, 2268, 0, {0,0}}
	, { 4, 2272, 0, {0,0}}
	, { 4, 2276, 0, {0,0}}
	, { 4, 2280, 0, {0,0}}
	, { 4, 2284, 0, {0,0}}
	, { 4, 2288, 0, {0,0}}
	, { 4, 2292, 0, {0,0}}
	, { 4, 2296, 0, {0,0}}
	, { 4, 2300, 0, {0,0}}
	, { 4, 2304, 0, {0,0}}
	, { 4, 2308, 0, {0,0}}
	, { 4, 2312, 0, {0,0}}
	, { 4, 2316, 0, {0,0}}
	, { 4, 2320, 0, {0,0}}
	, { 4, 2324, 0, {0,0}}
	, { 4, 2328, 0, {0,0}}
	, { 4, 2332, 0, {0,0}}
	, { 4, 2336, 0, {0,0}}
	, { 4, 2340, 0, {0,0}}
	, { 4, 2344, 0, {0,0}}
	, { 4, 2348, 0, {0,0}}
	, { 4, 2352, 0, {0,0}}
	, { 4, 2356, 0, {0,0}}
	, { 4, 2360, 0, {0,0}}
	, { 4, 2364, 0, {0,0}}
	, { 4, 2368, 0, {0,0}}
	, { 4, 2372, 0, {0,0}}
	, { 4, 2376, 0, {0,0}}
	, { 4, 2380, 0, {0,0}}
	, { 4, 2384, 0, {0,0}}
	, { 4, 2388, 0, {0,0}}
	, { 4, 2392, 0, {0,0}}
	, { 4, 2396, 0, {0,0}}
	, { 4, 2400, 0, {0,0}}
	, { 4, 2404, 0, {0,0}}
	, { 4, 2408, 0, {0,0}}
	, { 4, 2412, 0, {0,0}}
	, { 4, 2416, 0, {0,0}}
	, { 4, 2420, 0, {0,0}}
	, { 4, 2424, 0, {0,0}}
	, { 4, 2428, 0, {0,0}}
	, { 4, 2432, 0, {0,0}}
	, { 4, 2436, 0, {0,0}}
	, { 4, 2440, 0, {0,0}}
	, { 4, 2444, 0, {0,0}}
	, { 4, 2448, 0, {0,0}}
	, { 4, 2452, 0, {0,0}}
	, { 4, 2456, 0, {0,0}}
	, { 4, 2460, 0, {0,0}}
	, { 4, 2464, 0, {0,0}}
	, { 4, 2468, 0, {0,0}}
	, { 4, 2472, 0, {0,0}}
	, { 4, 2476, 0, {0,0}}
	, { 4, 2480, 0, {0,0}}
	, { 4, 2484, 0, {0,0}}
	, { 4, 2488, 0, {0,0}}
	, { 4, 2492, 0, {0,0}}
	, { 4, 2496, 0, {0,0}}
	, { 4, 2500, 0, {0,0}}
	, { 4, 2504, 0, {0,0}}
	, { 4, 2508, 0, {0,0}}
	, { 4, 2512, 0, {0,0}}
	, { 4, 2516, 0, {0,0}}
	, { 4, 2520, 0, {0,0}}
	, { 4, 2524, 0, {0,0}}
	, { 4, 2528, 0, {0,0}}
	, { 4, 2532, 0, {0,0}}
	, { 4, 2536, 0, {0,0}}
	, { 4, 2540, 0, {0,0}}
	, { 4, 2544, 0, {0,0}}
	, { 4, 2548, 0, {0,0}}
	, { 4, 2552, 0, {0,0}}
	, { 4, 2556, 0, {0,0}}
	, { 4, 2560, 0, {0,0}}
	, { 4, 2564, 0, {0,0}}
	, { 4, 2568, 0, {0,0}}
	, { 4, 2572, 0, {0,0}}
	, { 4, 2576, 0, {0,0}}
	, { 4, 2580, 0, {0,0}}
	, { 4, 2584, 0, {0,0}}
	, { 4, 2588, 0, {0,0}}
	, { 4, 2592, 0, {0,0}}
	, { 4, 2596, 0, {0,0}}
	, { 4, 2600, 0, {0,0}}
	, { 4, 2604, 0, {0,0}}
	, { 4, 2608, 0, {0,0}}
	, { 4, 2612, 0, {0,0}}
	, { 4, 2616, 0, {0,0}}
	, { 4, 2620, 0, {0,0}}
	, { 4, 2624, 0, {0,0}}
	, { 4, 2628, 0, {0,0}}
	, { 4, 2632, 0, {0,0}}
	, { 4, 2636, 0, {0,0}}
	, { 4, 2640, 0, {0,0}}
	, { 4, 2644, 0, {0,0}}
	, { 4, 2648, 0, {0,0}}
	, { 4, 2652, 0, {0,0}}
	, { 4, 2656, 0, {0,0}}
	, { 4, 2660, 0, {0,0}}
	, { 4, 2664, 0, {0,0}}
	, { 4, 2668, 0, {0,0}}
	, { 4, 2672, 0, {0,0}}
	, { 4, 2676, 0, {0,0}}
	, { 4, 2680, 0, {0,0}}
	, { 4, 2684, 0, {0,0}}
	, { 4, 2688, 0, {0,0}}
	, { 4, 2692, 0, {0,0}}
	, { 4, 2696, 0, {0,0}}
	, { 4, 2700, 0, {0,0}}
	, { 4, 2704, 0, {0,0}}
	, { 4, 2708, 0, {0,0}}
	, { 4, 2712, 0, {0,0}}
	, { 4, 2716, 0, {0,0}}
	, { 4, 2720, 0, {0,0}}
	, { 4, 2724, 0, {0,0}}
	, { 4, 2728, 0, {0,0}}
	, { 4, 2732, 0, {0,0}}
	, { 4, 2736, 0, {0,0}}
	, { 4, 2740, 0, {0,0}}
	, { 4, 2744, 0, {0,0}}
	, { 4, 2748, 0, {0,0}}
	, { 4, 2752, 0, {0,0}}
	, { 4, 2756, 0, {0,0}}
	, { 4, 2760, 0, {0,0}}
	, { 4, 2764, 0, {0,0}}
	, { 4, 2768, 0, {0,0}}
	, { 4, 2772, 0, {0,0}}
	, { 4, 2776, 0, {0,0}}
	, { 4, 2780, 0, {0,0}}
	, { 4, 2784, 0, {0,0}}
	, { 4, 2788, 0, {0,0}}
	, { 4, 2792, 0, {0,0}}
	, { 4, 2796, 0, {0,0}}
	, { 4, 2800, 0, {0,0}}
	, { 4, 2804, 0, {0,0}}
	, { 4, 2808, 0, {0,0}}
	, { 4, 2812, 0, {0,0}}
	, { 4, 2816, 0, {0,0}}
	, { 4, 2820, 0, {0,0}}
	, { 4, 2824, 0, {0,0}}
	, { 4, 2828, 0, {0,0}}
	, { 4, 2832, 0, {0,0}}
	, { 4, 2836, 0, {0,0}}
	, { 4, 2840, 0, {0,0}}
	, { 4, 2844, 0, {0,0}}
	, { 4, 2848, 0, {0,0}}
	, { 4, 2852, 0, {0,0}}
	, { 4, 2856, 0, {0,0}}
	, { 4, 2860, 0, {0,0}}
	, { 4, 2864, 0, {0,0}}
	, { 4, 2868, 0, {0,0}}
	, { 4, 2872, 0, {0,0}}
	, { 4, 2876, 0, {0,0}}
	, { 4, 2880, 0, {0,0}}
	, { 4, 2884, 0, {0,0}}
	, { 4, 2888, 0, {0,0}}
	, { 4, 2892, 0, {0,0}}
	, { 4, 2896, 0, {0,0}}
	, { 4, 2900, 0, {0,0}}
	, { 4, 2904, 0, {0,0}}
	, { 4, 2908, 0, {0,0}}
	, { 4, 2912, 0, {0,0}}
	, { 4, 2916, 0, {0,0}}
	, { 4, 2920, 0, {0,0}}
	, { 4, 2924, 0, {0,0}}
	, { 4, 2928, 0, {0,0}}
	, { 4, 2932, 0, {0,0}}
	, { 4, 2936, 0, {0,0}}
	, { 4, 2940, 0, {0,0}}
	, { 4, 2944, 0, {0,0}}
	, { 4, 2948, 0, {0,0}}
	, { 4, 2952, 0, {0,0}}
	, { 4, 2956, 0, {0,0}}
	, { 4, 2960, 0, {0,0}}
	, { 4, 2964, 0, {0,0}}
	, { 4, 2968, 0, {0,0}}
	, { 4, 2972, 0, {0,0}}
	, { 4, 2976, 0, {0,0}}
	, { 4, 2980, 0, {0,0}}
	, { 4, 2984, 0, {0,0}}
	, { 4, 2988, 0, {0,0}}
	, { 4, 2992, 0, {0,0}}
	, { 4, 2996, 0, {0,0}}
	, { 4, 3000, 0, {0,0}}
	, { 4, 3004, 0, {0,0}}
	, { 4, 3008, 0, {0,0}}
	, { 4, 3012, 0, {0,0}}
	, { 4, 3016, 0, {0,0}}
	, { 4, 3020, 0, {0,0}}
	, { 4, 3024, 0, {0,0}}
	, { 4, 3028, 0, {0,0}}
	, { 4, 3032, 0, {0,0}}
	, { 4, 3036, 0, {0,0}}
	, { 4, 3040, 0, {0,0}}
	, { 4, 3044, 0, {0,0}}
	, { 4, 3048, 0, {0,0}}
	, { 4, 3052, 0, {0,0}}
	, { 4, 3056, 0, {0,0}}
	, { 6, 14, 2, {0,0}}
	, { 6, 14, 2, {0,1}}
	, { 6, 14, 2, {0,2}}
	, { 6, 14, 2, {0,3}}
	, { 6, 14, 2, {0,4}}
	, { 6, 14, 2, {0,5}}
	, { 6, 14, 2, {0,6}}
	, { 6, 14, 2, {0,7}}
	, { 6, 14, 2, {0,8}}
	, { 6, 14, 2, {0,9}}
	, { 6, 14, 2, {0,10}}
	, { 6, 14, 2, {0,11}}
	, { 6, 14, 2, {0,12}}
	, { 6, 14, 2, {0,13}}
	, { 6, 14, 2, {0,14}}
	, { 6, 14, 2, {0,15}}
	, { 6, 14, 2, {0,16}}
	, { 6, 14, 2, {0,17}}
	, { 6, 14, 2, {0,18}}
	, { 6, 14, 2, {0,19}}
	, { 6, 14, 2, {0,20}}
	, { 6, 14, 2, {0,21}}
	, { 6, 14, 2, {0,22}}
	, { 6, 14, 2, {0,23}}
	, { 6, 14, 2, {0,24}}
	, { 6, 14, 2, {0,25}}
	, { 6, 14, 2, {0,26}}
	, { 6, 14, 2, {0,27}}
	, { 6, 14, 2, {0,28}}
	, { 6, 14, 2, {0,29}}
	, { 6, 14, 2, {0,30}}
	, { 6, 14, 2, {0,31}}
	, { 6, 14, 2, {0,32}}
	, { 6, 14, 2, {0,33}}
	, { 6, 14, 2, {0,34}}
	, { 6, 14, 2, {0,35}}
	, { 6, 14, 2, {0,36}}
	, { 6, 14, 2, {0,37}}
	, { 6, 14, 2, {0,38}}
	, { 6, 14, 2, {0,39}}
	, { 6, 14, 2, {0,40}}
	, { 6, 14, 2, {0,41}}
	, { 6, 14, 2, {0,42}}
	, { 6, 14, 2, {0,43}}
	, { 6, 14, 2, {0,44}}
	, { 6, 14, 2, {0,45}}
	, { 6, 14, 2, {0,46}}
	, { 6, 14, 2, {0,47}}
	, { 6, 14, 2, {0,48}}
	, { 6, 14, 2, {0,49}}
	, { 6, 14, 2, {0,50}}
	, { 6, 14, 2, {0,51}}
	, { 6, 14, 2, {0,52}}
	, { 6, 14, 2, {0,53}}
	, { 6, 14, 2, {0,54}}
	, { 6, 14, 2, {0,55}}
	, { 6, 14, 2, {0,56}}
	, { 6, 14, 2, {0,57}}
	, { 6, 14, 2, {0,58}}
	, { 6, 14, 2, {0,59}}
	, { 6, 14, 2, {0,60}}
	, { 6, 14, 2, {0,61}}
	, { 6, 14, 2, {0,62}}
	, { 6, 14, 2, {0,63}}
	, { 6, 14, 2, {0,64}}
	, { 6, 14, 2, {0,65}}
	, { 6, 14, 2, {0,66}}
	, { 6, 14, 2, {0,67}}
	, { 6, 14, 2, {0,68}}
	, { 6, 14, 2, {0,69}}
	, { 6, 14, 2, {0,70}}
	, { 6, 14, 2, {0,71}}
	, { 6, 14, 2, {0,72}}
	, { 6, 14, 2, {0,73}}
	, { 6, 14, 2, {0,74}}
	, { 6, 14, 2, {0,75}}
	, { 6, 14, 2, {0,76}}
	, { 6, 14, 2, {0,77}}
	, { 6, 14, 2, {0,78}}
	, { 6, 14, 2, {0,79}}
	, { 6, 14, 2, {0,80}}
	, { 6, 14, 2, {0,81}}
	, { 6, 14, 2, {0,82}}
	, { 6, 14, 2, {0,83}}
	, { 6, 14, 2, {0,84}}
	, { 6, 14, 2, {0,85}}
	, { 6, 14, 2, {0,86}}
	, { 6, 14, 2, {0,87}}
	, { 6, 14, 2, {0,88}}
	, { 6, 14, 2, {0,89}}
	, { 6, 14, 2, {0,90}}
	, { 6, 14, 2, {0,91}}
	, { 6, 14, 2, {0,92}}
	, { 6, 14, 2, {0,93}}
	, { 6, 14, 2, {0,94}}
	, { 6, 14, 2, {0,95}}
	, { 6, 14, 2, {0,96}}
	, { 6, 14, 2, {0,97}}
	, { 6, 14, 2, {0,98}}
	, { 6, 14, 2, {0,99}}
	, { 6, 14, 2, {0,100}}
	, { 6, 14, 2, {0,101}}
	, { 6, 14, 2, {0,102}}
	, { 6, 14, 2, {0,103}}
	, { 6, 14, 2, {0,104}}
	, { 6, 14, 2, {0,105}}
	, { 6, 14, 2, {0,106}}
	, { 6, 14, 2, {0,107}}
	, { 6, 14, 2, {0,108}}
	, { 6, 14, 2, {0,109}}
	, { 6, 14, 2, {0,110}}
	, { 6, 14, 2, {0,111}}
	, { 6, 14, 2, {0,112}}
	, { 6, 14, 2, {0,113}}
	, { 6, 14, 2, {0,114}}
	, { 6, 14, 2, {0,115}}
	, { 6, 14, 2, {0,116}}
	, { 6, 14, 2, {0,117}}
	, { 6, 14, 2, {0,118}}
	, { 6, 14, 2, {0,119}}
	, { 6, 14, 2, {0,120}}
	, { 6, 14, 2, {0,121}}
	, { 6, 14, 2, {0,122}}
	, { 6, 14, 2, {0,123}}
	, { 6, 14, 2, {0,124}}
	, { 6, 14, 2, {0,125}}
	, { 6, 14, 2, {0,126}}
	, { 6, 14, 2, {0,127}}
	, { 6, 14, 2, {0,128}}
	, { 6, 14, 2, {0,129}}
	, { 6, 14, 2, {0,130}}
	, { 6, 14, 2, {0,131}}
	, { 6, 14, 2, {0,132}}
	, { 6, 14, 2, {0,133}}
	, { 6, 14, 2, {0,134}}
	, { 6, 14, 2, {0,135}}
	, { 6, 14, 2, {0,136}}
	, { 6, 14, 2, {0,137}}
	, { 6, 14, 2, {0,138}}
	, { 6, 14, 2, {0,139}}
	, { 6, 14, 2, {0,140}}
	, { 6, 14, 2, {0,141}}
	, { 6, 14, 2, {0,142}}
	, { 6, 14, 2, {0,143}}
	, { 6, 14, 2, {0,144}}
	, { 6, 14, 2, {0,145}}
	, { 6, 14, 2, {0,146}}
	, { 6, 14, 2, {0,147}}
	, { 6, 14, 2, {0,148}}
	, { 6, 14, 2, {0,149}}
	, { 6, 14, 2, {0,150}}
	, { 6, 14, 2, {0,151}}
	, { 6, 14, 2, {0,152}}
	, { 6, 14, 2, {0,153}}
	, { 6, 14, 2, {0,154}}
	, { 6, 14, 2, {0,155}}
	, { 6, 14, 2, {0,156}}
	, { 6, 14, 2, {0,157}}
	, { 6, 14, 2, {0,158}}
	, { 6, 14, 2, {0,159}}
	, { 6, 14, 2, {0,160}}
	, { 6, 14, 2, {0,161}}
	, { 6, 14, 2, {0,162}}
	, { 6, 14, 2, {0,163}}
	, { 6, 14, 2, {0,164}}
	, { 6, 14, 2, {0,165}}
	, { 6, 14, 2, {0,166}}
	, { 6, 14, 2, {0,167}}
	, { 6, 14, 2, {0,168}}
	, { 6, 14, 2, {0,169}}
	, { 6, 14, 2, {0,170}}
	, { 6, 14, 2, {0,171}}
	, { 6, 14, 2, {0,172}}
	, { 6, 14, 2, {0,173}}
	, { 6, 14, 2, {0,174}}
	, { 6, 14, 2, {0,175}}
	, { 6, 14, 2, {0,176}}
	, { 6, 14, 2, {0,177}}
	, { 6, 14, 2, {0,178}}
	, { 6, 14, 2, {0,179}}
	, { 6, 14, 2, {0,180}}
	, { 6, 14, 2, {0,181}}
	, { 6, 14, 2, {0,182}}
	, { 6, 14, 2, {0,183}}
	, { 6, 14, 2, {0,184}}
	, { 6, 14, 2, {0,185}}
	, { 6, 14, 2, {0,186}}
	, { 6, 14, 2, {0,187}}
	, { 6, 14, 2, {0,188}}
	, { 6, 14, 2, {0,189}}
	, { 6, 14, 2, {0,190}}
	, { 6, 14, 2, {0,191}}
	, { 6, 14, 2, {0,192}}
	, { 6, 14, 2, {0,193}}
	, { 6, 14, 2, {0,194}}
	, { 6, 14, 2, {0,195}}
	, { 6, 14, 2, {0,196}}
	, { 6, 14, 2, {0,197}}
	, { 6, 14, 2, {0,198}}
	, { 6, 14, 2, {0,199}}
	, { 6, 14, 2, {0,200}}
	, { 6, 14, 2, {0,201}}
	, { 6, 14, 2, {0,202}}
	, { 6, 14, 2, {0,203}}
	, { 6, 14, 2, {0,204}}
	, { 6, 14, 2, {0,205}}
	, { 6, 14, 2, {0,206}}
	, { 6, 14, 2, {0,207}}
	, { 6, 14, 2, {0,208}}
	, { 6, 14, 2, {0,209}}
	, { 6, 14, 2, {0,210}}
	, { 6, 14, 2, {0,211}}
	, { 6, 14, 2, {0,212}}
	, { 6, 14, 2, {0,213}}
	, { 6, 14, 2, {0,214}}
	, { 6, 14, 2, {0,215}}
	, { 6, 14, 2, {0,216}}
	, { 6, 14, 2, {0,217}}
	, { 6, 14, 2, {0,218}}
	, { 6, 14, 2, {0,219}}
	, { 6, 14, 2, {0,220}}
	, { 6, 14, 2, {0,221}}
	, { 6, 14, 2, {0,222}}
	, { 6, 14, 2, {0,223}}
	, { 6, 14, 2, {0,224}}
	, { 6, 14, 2, {0,225}}
	, { 6, 14, 2, {0,226}}
	, { 6, 14, 2, {0,227}}
	, { 6, 14, 2, {0,228}}
	, { 6, 14, 2, {0,229}}
	, { 6, 14, 2, {0,230}}
	, { 6, 14, 2, {0,231}}
	, { 6, 14, 2, {0,232}}
	, { 6, 14, 2, {0,233}}
	, { 6, 14, 2, {0,234}}
	, { 6, 14, 2, {0,235}}
	, { 6, 14, 2, {0,236}}
	, { 6, 14, 2, {0,237}}
	, { 6, 14, 2, {0,238}}
	, { 6, 14, 2, {0,239}}
	, { 6, 14, 2, {0,240}}
	, { 6, 14, 2, {0,241}}
	, { 6, 14, 2, {0,242}}
	, { 6, 14, 2, {0,243}}
	, { 6, 14, 2, {0,244}}
	, { 6, 14, 2, {0,245}}
	, { 6, 14, 2, {0,246}}
	, { 6, 14, 2, {0,247}}
	, { 6, 14, 2, {0,248}}
	, { 6, 14, 2, {0,249}}
	, { 6, 14, 2, {0,250}}
	, { 6, 14, 2, {0,251}}
	, { 6, 14, 2, {0,252}}
	, { 6, 14, 2, {0,253}}
	, { 6, 14, 2, {0,254}}
	, { 6, 14, 2, {0,255}}
	, { 6, 14, 2, {0,256}}
	, { 6, 14, 2, {0,257}}
	, { 6, 14, 2, {0,258}}
	, { 6, 14, 2, {0,259}}
	, { 6, 14, 2, {0,260}}
	, { 6, 14, 2, {0,261}}
	, { 6, 14, 2, {0,262}}
	, { 6, 14, 2, {0,263}}
	, { 6, 14, 2, {0,264}}
	, { 6, 14, 2, {0,265}}
	, { 6, 14, 2, {0,266}}
	, { 6, 14, 2, {0,267}}
	, { 6, 14, 2, {0,268}}
	, { 6, 14, 2, {0,269}}
	, { 6, 14, 2, {0,270}}
	, { 6, 14, 2, {0,271}}
	, { 10, 6, 1, {327681,0}}
	, { 10, 6, 1, {327937,0}}
	, { 10, 6, 1, {328193,0}}
	, { 10, 6, 1, {328449,0}}
	, { 10, 6, 1, {328705,0}}
	, { 10, 6, 1, {328961,0}}
	, { 10, 6, 1, {329217,0}}
	, { 10, 6, 1, {329473,0}}
	, { 10, 6, 1, {329729,0}}
	, { 10, 6, 1, {329985,0}}
	, { 10, 6, 1, {330241,0}}
	, { 10, 6, 1, {330497,0}}};

static const struct vfc_read_task vfc_task_x_e3b0 = {vfc_vectors_x_e3b0, 1049};



static const struct igu_data igu_address_e3b0 = {
	1, 10, 0x130034, 0x130130, { 0x00130178, 0x0013017c}
};


#define PAGE_MODE_VALUES_E1 0

#define PAGE_READ_REGS_E1 0

#define PAGE_WRITE_REGS_E1 0

static const u32 page_vals_e1[] = {0};

static const u32 page_write_regs_e1[] = {0};

static const struct reg_addr page_read_regs_e1[] = {
	{0x0, 0, RI_E1_ONLINE}
};

#define PAGE_MODE_VALUES_E1H 0


#define PAGE_READ_REGS_E1H 0

#define PAGE_WRITE_REGS_E1H 0

static const u32 page_vals_e1h[] = {0};

static const u32 page_write_regs_e1h[] = {0};

static const struct reg_addr page_read_regs_e1h[] = {
	{0x0, 0, RI_E1H_ONLINE}
};

#endif
#define PAGE_MODE_VALUES_E2 2


#define PAGE_READ_REGS_E2 1

#define PAGE_WRITE_REGS_E2 1

static const u32 page_vals_e2[] = { 0,  128};

static const u32 page_write_regs_e2[] = {328476};

static const struct reg_addr page_read_regs_e2[] = {
	{0x58000, 4608, RI_E2_ONLINE}
};

#define PAGE_MODE_VALUES_E3 2


#define PAGE_READ_REGS_E3 1

#define PAGE_WRITE_REGS_E3 1

static const u32 page_vals_e3[] = { 0,  128};

static const u32 page_write_regs_e3[] = {328476};

static const struct reg_addr page_read_regs_e3[] = {
	{0x58000, 4608, RI_E3E3B0_ONLINE}
};

#endif
