#ifndef __EVEREST_L5CM_CONSTANTS_H_
#define __EVEREST_L5CM_CONSTANTS_H_

/**
* This file defines HSI constants for the L5CM flows
*/

/* Slow path commands */
#define L5CM_RAMROD_CMD_ID_BASE							(0x80)
#define L5CM_RAMROD_CMD_ID_ENABLE_SEARCHER				(L5CM_RAMROD_CMD_ID_BASE + 1)  // This is just to make the c-asm check happy
#define L5CM_RAMROD_CMD_ID_ADD_NEW_CONNECTION			(L5CM_RAMROD_CMD_ID_BASE + 2)
#define L5CM_RAMROD_CMD_ID_TCP_CONNECT					(L5CM_RAMROD_CMD_ID_BASE + 3)
#define L5CM_INT_RAMROD_CMD_ID_SYN_ACK_FLUSH			(L5CM_RAMROD_CMD_ID_BASE + 4)  // This ramrod is only between the X and the T, where the T proceed with SYN/ACK arrival
#define L5CM_RAMROD_CMD_ID_PCS_RESPONSE1_SUCCESS		(L5CM_RAMROD_CMD_ID_BASE + 5)  // Send SYN/ACK
#define L5CM_RAMROD_CMD_ID_PCS_RESPONSE2_SUCCESS		(L5CM_RAMROD_CMD_ID_BASE + 6)  // L4-OFFLOAD for MPA request
#define L5CM_RAMROD_CMD_ID_PCS_RESPONSE3_SUCCESS		(L5CM_RAMROD_CMD_ID_BASE + 7)  // L4-OFFLOAD for DDP segment 
#define L5CM_RAMROD_CMD_ID_PCS_RESPONSE4_SUCCESS		(L5CM_RAMROD_CMD_ID_BASE + 8) // Done sending DDP to FORWARDING CHANNEL --> Free PCS
#define L5CM_RAMROD_CMD_ID_PCS_RESPONSE_FAILURE			(L5CM_RAMROD_CMD_ID_BASE + 9) // Done sending DDP to FORWARDING CHANNEL --> Free PCS
#define L5CM_RAMROD_CMD_ID_INIT_SEED					(L5CM_RAMROD_CMD_ID_BASE + 10)
#define L5CM_RAMROD_CMD_ID_UPDATE_SEED					(L5CM_RAMROD_CMD_ID_BASE + 11)
#define L5CM_RAMROD_CMD_ID_CLOSE						(L5CM_RAMROD_CMD_ID_BASE + 12)
#define L5CM_RAMROD_CMD_ID_ABORT						(L5CM_RAMROD_CMD_ID_BASE + 13)
#define L5CM_RAMROD_CMD_ID_SEARCHER_DELETE				(L5CM_RAMROD_CMD_ID_BASE + 14)
#define L5CM_RAMROD_CMD_ID_TERMINATE_OFFLOAD			(L5CM_RAMROD_CMD_ID_BASE + 15)
#define L5CM_RAMROD_CMD_ID_QUERY						(L5CM_RAMROD_CMD_ID_BASE + 16)


#define L5CM_MAX_FREE_PCS_RING_SIZE			(32)
#define L5CM_MAX_ISQ_SIZE					(32)
#define L5CM_MAX_RANDOM_SEEDS				(8)
#define L5CM_LISTENER_IP_ADDR_TABLE_SIZE	(15) 

#define L5CM_MAX_LISTENER_PAGES				(16)
#define L5CM_LISTENER_PAGE_TABLE_SIZE		(0x10000 / L5CM_MAX_LISTENER_PAGES) // Bytes

#define PCS_STATUS_OK						(0)
#define PCS_STATUS_ERROR					(1)


#define L5CM_TCP_STATE_LISTEN            (1)
#define L5CM_TCP_STATE_SYN_SENT          (2)
#define L5CM_TCP_STATE_SYN_RECV          (3)
#define L5CM_TCP_STATE_CLOSE_WAIT        (4)
#define L5CM_TCP_STATE_ESTABLISHED       (5)
#define L5CM_TCP_STATE_FIN_WAIT1         (6)
#define L5CM_TCP_STATE_FIN_WAIT2         (7)
#define L5CM_TCP_STATE_TIME_WAIT         (8)
#define L5CM_TCP_STATE_CLOSE             (9)
#define L5CM_TCP_STATE_LAST_ACK          (10)
#define L5CM_TCP_STATE_CLOSING	        (11)
#define L5CM_TCP_STATE_WAIT_TX_ACK1      (12)
#define L5CM_TCP_STATE_WAIT_TX_ACK2      (13)
#define L5CM_TCP_STATE_WAIT_MSL_SET      (14)
#define L5CM_TCP_STATE_MAX	            (15) // Only 4 bits

#endif //__EVEREST_L5CM_CONSTANTS_H_
