/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2014 QLogic Corporation
 * The contents of this file are subject to the terms of the
 * QLogic End User License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the License at
 * http://www.qlogic.com/Resources/Documents/DriverDownloadHelp/
 * QLogic_End_User_Software_License.txt
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 */
#ifndef __577XX_INT_OFFSETS__
#define __577XX_INT_OFFSETS__

#define COMMON_SB_SIZE                                               (IRO[0].base)
#define COMMON_SB_DATA_SIZE                                          (IRO[1].base)
#define COMMON_SP_SB_SIZE                                            (IRO[2].base)
#define COMMON_SP_SB_DATA_SIZE                                       (IRO[3].base)
#define COMMON_DYNAMIC_HC_CONFIG_SIZE                                (IRO[4].base)
#define COMMON_ASM_ASSERT_MSG_SIZE                                   (IRO[5].base)
#define COMMON_ASM_ASSERT_INDEX_SIZE                                 (IRO[6].base)
#define COMMON_ASM_INVALID_ASSERT_OPCODE                             (IRO[7].base)
#define COMMON_RAM1_TEST_EVENT_ID                                    (IRO[8].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_EVENT_ID               (IRO[9].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_1_OFFSET               (IRO[10].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_2_OFFSET               (IRO[11].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_3_OFFSET               (IRO[12].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_1_RESULT_OFFSET        (IRO[13].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_2_RESULT_OFFSET        (IRO[14].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_3_RESULT_OFFSET        (IRO[15].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_1_MASK                 (IRO[16].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_2_MASK                 (IRO[17].base)
#define COMMON_INBOUND_INTERRUPT_TEST_AGG_INT_3_MASK                 (IRO[18].base)
#define COMMON_KUKU_TEST_AGG_INT                                     (IRO[19].base)
#define COMMON_KUKU_TEST_EVENTID                                     (IRO[20].base)
#define COMMON_KUKU_PCI_READ_OPCODE                                  (IRO[21].base)
#define COMMON_KUKU_LOAD_CONTEXT_OPCODE                              (IRO[22].base)
#define COMMON_KUKU_LOAD_CONTEXT_INCVAL                              (IRO[23].base)
#define COMMON_KUKU_LOAD_CONTEXT_REGION                              (IRO[24].base)
#define COMMON_KUKU_LOAD_CONTEXT_CID                                 (IRO[25].base)
#define COMMON_KUKU_LOAD_CONTEXT_RUN_PBF_ECHO_TEST                   (IRO[26].base)
#define COMMON_KUKU_QM_PAUSE_OPCODE                                  (IRO[27].base)
#define COMMON_KUKU_TEST_UNUSED_FOCS_SUCCESS_OPCODE_VALUE            (IRO[28].base)
#define COMMON_KUKU_TEST_UNUSED_FOCS_OPCODE_VALUE                    (IRO[29].base)
/* Base physical address of slow path ring */
#define XSTORM_SPQ_PAGE_BASE_OFFSET(funcId)                          (IRO[30].base + ((funcId) * IRO[30].m1))
#define XSTORM_SPQ_PAGE_BASE_SIZE                                    (IRO[30].size)
/* Producer of slow path ring. An update of this field triggers a slow path operation on the device */
#define XSTORM_SPQ_PROD_OFFSET(funcId)                               (IRO[31].base + ((funcId) * IRO[31].m1))
#define XSTORM_SPQ_PROD_SIZE                                         (IRO[31].size)
/* Location of slow path ring data. Should be zeroed in function close process */
#define XSTORM_SPQ_DATA_OFFSET(funcId)                               (IRO[32].base + ((funcId) * IRO[32].m1))
#define XSTORM_SPQ_DATA_SIZE                                         (IRO[32].size)
#define XSTORM_HIGIG_HDR_LENGTH_OFFSET(portId)                       (IRO[33].base + ((portId) * IRO[33].m1))
#define XSTORM_HIGIG_HDR_LENGTH_SIZE                                 (IRO[33].size)
/* Base physical address of slow path ring (VFs) */
#define XSTORM_VF_SPQ_PAGE_BASE_OFFSET(vfId)                         (IRO[34].base + ((vfId) * IRO[34].m1))
#define XSTORM_VF_SPQ_PAGE_BASE_SIZE                                 (IRO[34].size)
/* Producer of slow path ring. An update of this field triggers a slow path operation on the device (VFs) */
#define XSTORM_VF_SPQ_PROD_OFFSET(vfId)                              (IRO[35].base + ((vfId) * IRO[35].m1))
#define XSTORM_VF_SPQ_PROD_SIZE                                      (IRO[35].size)
/* Location of slow path ring data. Should be zeroed in function close process (VFs) */
#define XSTORM_VF_SPQ_DATA_OFFSET(vfId)                              (IRO[36].base + ((vfId) * IRO[36].m1))
#define XSTORM_VF_SPQ_DATA_SIZE                                      (IRO[36].size)
#define XSTORM_JUMBO_SUPPORT_OFFSET(pfId)                            (IRO[37].base + (((pfId)>>1) * IRO[37].m1) + (((pfId)&1) * IRO[37].m2))
#define XSTORM_JUMBO_SUPPORT_SIZE                                    (IRO[37].size)
#define XSTORM_COMMON_IP_ID_MASK_OFFSET                              (IRO[38].base)
#define XSTORM_COMMON_IP_ID_MASK_SIZE                                (IRO[38].size)
/* TCP real time clock parameters */
#define XSTORM_COMMON_RTC_PARAMS_OFFSET                              (IRO[39].base)
#define XSTORM_COMMON_RTC_PARAMS_SIZE                                (IRO[39].size)
/* Resolution of TCP real time clock */
#define XSTORM_COMMON_RTC_RESOLUTION_OFFSET                          (IRO[40].base)
#define XSTORM_COMMON_RTC_RESOLUTION_SIZE                            (IRO[40].size)
/* Description	Storms FW version number, written in Xstorm RAM upon init */
#define XSTORM_FW_VERSION_OFFSET                                     (IRO[41].base)
#define XSTORM_FW_VERSION_SIZE                                       (IRO[41].size)
/* Offload licensing values */
#define XSTORM_LICENSE_VALUES_OFFSET(pfId)                           (IRO[42].base + ((pfId) * IRO[42].m1))
#define XSTORM_LICENSE_VALUES_SIZE                                   (IRO[42].size)
/* Congestion management variables per port */
#define XSTORM_CMNG_PER_PORT_VARS_OFFSET(portId)                     (IRO[43].base + ((portId) * IRO[43].m1))
#define XSTORM_CMNG_PER_PORT_VARS_SIZE                               (IRO[43].size)
/* Rate shaping variables, per VNIC */
#define XSTORM_RATE_SHAPING_PER_VN_VARS_OFFSET(pfId)                 (IRO[44].base + ((pfId) * IRO[44].m1))
#define XSTORM_RATE_SHAPING_PER_VN_VARS_SIZE                         (IRO[44].size)
/* Fairness variables, per VNIC */
#define XSTORM_FAIRNESS_PER_VN_VARS_OFFSET(pfId)                     (IRO[45].base + ((pfId) * IRO[45].m1))
#define XSTORM_FAIRNESS_PER_VN_VARS_SIZE                             (IRO[45].size)
/* Offset of per-queue statistics in Xstorm. Need to be zeroes before clients which use this statistics queue are loaded. */
#define XSTORM_PER_QUEUE_STATS_OFFSET(xStatQueueId)                  (IRO[46].base + ((xStatQueueId) * IRO[46].m1))
#define XSTORM_PER_QUEUE_STATS_SIZE                                  (IRO[46].size)
/* Function enable bit for Xstorm. Need to be set before a new function (PF or VF) is loaded. */
#define XSTORM_FUNC_EN_OFFSET(funcId)                                (IRO[47].base + ((funcId) * IRO[47].m1))
#define XSTORM_FUNC_EN_SIZE                                          (IRO[47].size)
/* Maps between VF IDs and their parent PF */
#define XSTORM_VF_TO_PF_OFFSET(funcId)                               (IRO[48].base + ((funcId) * IRO[48].m1))
#define XSTORM_VF_TO_PF_SIZE                                         (IRO[48].size)
/* When set, all slow path commands for this function are recorded in Storms assert memory (debug feature). */
#define XSTORM_RECORD_SLOW_PATH_OFFSET(funcId)                       (IRO[49].base + ((funcId) * IRO[49].m1))
#define XSTORM_RECORD_SLOW_PATH_SIZE                                 (IRO[49].size)
/* Xstorm assert list location in RAM */
#define XSTORM_ASSERT_LIST_OFFSET(assertListEntry)                   (IRO[50].base + ((assertListEntry) * IRO[50].m1))
#define XSTORM_ASSERT_LIST_SIZE                                      (IRO[50].size)
/* Xstorm assert list index (producer) location in RAM */
#define XSTORM_ASSERT_LIST_INDEX_OFFSET                              (IRO[51].base)
#define XSTORM_ASSERT_LIST_INDEX_SIZE                                (IRO[51].size)
#define XSTORM_TIME_SYNC_TEST_ADDRESS_OFFSET                         (IRO[52].base)
#define XSTORM_TIME_SYNC_TEST_ADDRESS_SIZE                           (IRO[52].size)
#define PCI_READ_KUKUE_CODE_OPPCOE                                   (IRO[53].base)
#define LOAD_CONTEXT_KUKUE_CODE_OPPCOE                               (IRO[54].base)
#define QM_PAUSE_KUKUE_CODE_OPPCOE                                   (IRO[55].base)
#define PAUSE_TEST_XOFF_PORT0_KUKUE_CODE_OPPCOE                      (IRO[56].base)
#define PAUSE_TEST_XON_PORT0_KUKUE_CODE_OPPCOE                       (IRO[57].base)
#define PAUSE_TEST_XOFF_PORT1_KUKUE_CODE_OPPCOE                      (IRO[58].base)
#define PAUSE_TEST_XON_PORT1_KUKUE_CODE_OPPCOE                       (IRO[59].base)
#define TEST_UNUSED_FOCS_KUKUE_CODE_OPPCOE                           (IRO[60].base)
#define PBF_ECHO_KUKUE_CODE_OPPCOE                                   (IRO[61].base)
#define TIME_SYNC_PORT0_KUKUE_CODE_OPPCOE                            (IRO[62].base)
#define TIME_SYNC_PORT1_KUKUE_CODE_OPPCOE                            (IRO[63].base)
#define IGU_TEST_KUKUE_CODE_OPPCOE                                   (IRO[64].base)
#define XSTORM_AGG_INT_INITIAL_CLEANUP_INDEX                         (IRO[65].base)
#define XSTORM_AGG_INT_FINAL_CLEANUP_INDEX                           (IRO[66].base)
#define XSTORM_AGG_INT_FINAL_CLEANUP_COMP_TYPE                       (IRO[67].base)
/* Internal statistics of error handlers in Everets2 */
#define XSTORM_ERROR_HANDLER_STATISTICS_RAM_OFFSET                   (IRO[68].base)
#define XSTORM_ERROR_HANDLER_STATISTICS_RAM_SIZE                     (IRO[68].size)
#define XSTORM_LB_PHYSICAL_QUEUES_INFO_OFFSET                        (IRO[69].base)
#define XSTORM_LB_PHYSICAL_QUEUES_INFO_SIZE                          (IRO[69].size)
/* VF-accessible queue zone in Xstorm in Everest2 */
#define XSTORM_QUEUE_ZONE_OFFSET(queueId)                            (IRO[70].base + ((queueId) * IRO[70].m1))
#define XSTORM_QUEUE_ZONE_SIZE                                       (IRO[70].size)
/* VF-accessible VF zone in Xstorm in Everest2 */
#define XSTORM_VF_ZONE_OFFSET(vfId)                                  (IRO[71].base + ((vfId) * IRO[71].m1))
#define XSTORM_VF_ZONE_SIZE                                          (IRO[71].size)
#define XSTORM_FIVE_TUPLE_SRC_EN_OFFSET                              (IRO[72].base)
#define XSTORM_FIVE_TUPLE_SRC_EN_SIZE                                (IRO[72].size)
#define XSTORM_E2_INTEG_RAM_OFFSET                                   (IRO[73].base)
#define XSTORM_E2_INTEG_RAM_SIZE                                     (IRO[73].size)
#define XSTORM_QM_OPPORTUNISTIC_RAM_OFFSET                           (IRO[74].base)
#define XSTORM_QM_OPPORTUNISTIC_RAM_SIZE                             (IRO[74].size)
#define XSTORM_SIDE_INFO_INPUT_LSB_OFFSET                            (IRO[75].base)
#define XSTORM_SIDE_INFO_INPUT_LSB_SIZE                              (IRO[75].size)
#define XSTORM_E2_INTEG_VLAN_ID_OFFSET                               (IRO[76].base)
#define XSTORM_E2_INTEG_VLAN_ID_SIZE                                 (IRO[76].size)
#define XSTORM_E2_INTEG_VLAN_ID_EN_OFFSET                            (IRO[77].base)
#define XSTORM_E2_INTEG_VLAN_ID_EN_SIZE                              (IRO[77].size)
#define XSTORM_VFC_TEST_LINE_OFFSET                                  (IRO[78].base)
#define XSTORM_VFC_TEST_LINE_SIZE                                    (IRO[78].size)
#define XSTORM_VFC_TEST_RESULT_OFFSET                                (IRO[79].base)
#define XSTORM_VFC_TEST_RESULT_SIZE                                  (IRO[79].size)
#define XSTORM_VFC_OP_GEN_VALUE                                      (IRO[80].base)
#define XSTORM_INBOUND_INTERRUPT_TEST_VF_INFO_SIZE_IN_BYTES          (IRO[81].base)
#define XSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_1_INDEX                (IRO[82].base)
#define XSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_2_INDEX                (IRO[83].base)
#define XSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_3_INDEX                (IRO[84].base)
#define XSTORM_DPM_BUFFER_OFFSET                                     (IRO[85].base)
#define XSTORM_DPM_BUFFER_SIZE                                       (IRO[85].size)
#define XSTORM_KUKU_TEST_OPCODE_OFFSET                               (IRO[86].base)
#define XSTORM_KUKU_TEST_OPCODE_SIZE                                 (IRO[86].size)
#define XSTORM_KUKU_LOAD_CONTEXT_TEST_OFFSET                         (IRO[87].base)
#define XSTORM_KUKU_LOAD_CONTEXT_TEST_SIZE                           (IRO[87].size)
#define XSTORM_KUKU_OP_GEN_VALUE                                     (IRO[88].base)
#define XSTORM_QM_PAUSE_TEST_QUEUE_MASK_OFFSET                       (IRO[89].base)
#define XSTORM_QM_PAUSE_TEST_QUEUE_MASK_SIZE                         (IRO[89].size)
#define XSTORM_QM_PAUSE_TEST_GROUP_OFFSET                            (IRO[90].base)
#define XSTORM_QM_PAUSE_TEST_GROUP_SIZE                              (IRO[90].size)
#define XSTORM_QM_PAUSE_TEST_PORT_OFFSET                             (IRO[91].base)
#define XSTORM_QM_PAUSE_TEST_PORT_SIZE                               (IRO[91].size)
#define XSTORM_KUKU_PBF_ECHO_OPCODE                                  (IRO[92].base)
#define XSTORM_KUKU_PBF_ECHO_INCVAL                                  (IRO[93].base)
#define XSTORM_KUKU_PBF_ECHO_REGION                                  (IRO[94].base)
#define XSTORM_KUKU_PBF_ECHO_RUN_PBF_ECHO_TEST                       (IRO[95].base)
#define XSTORM_KUKU_PBF_ECHO_CID                                     (IRO[96].base)
#define XSTORM_KUKU_PBF_ECHO_SUCCESS_VALUE                           (IRO[97].base)
#define XSTORM_KUKU_TIME_SYNC_FLG_OFFSET(funcId)                     (IRO[98].base + ((funcId) * IRO[98].m1))
#define XSTORM_KUKU_TIME_SYNC_FLG_SIZE                               (IRO[98].size)
#define TSTORM_INDIRECTION_TABLE_ENTRY_SIZE                          (IRO[99].base)
/* TCP real time clock parameters */
#define TSTORM_COMMON_RTC_PARAMS_OFFSET                              (IRO[100].base)
#define TSTORM_COMMON_RTC_PARAMS_SIZE                                (IRO[100].size)
/* Tstorm assert list location in RAM */
#define TSTORM_ASSERT_LIST_OFFSET(assertListEntry)                   (IRO[101].base + ((assertListEntry) * IRO[101].m1))
#define TSTORM_ASSERT_LIST_SIZE                                      (IRO[101].size)
/* Tstorm assert list index (producer) location in RAM */
#define TSTORM_ASSERT_LIST_INDEX_OFFSET                              (IRO[102].base)
#define TSTORM_ASSERT_LIST_INDEX_SIZE                                (IRO[102].size)
/* Tstorm Measure PCI Latency Control location in RAM */
#define TSTORM_MEASURE_PCI_LATENCY_CTRL_OFFSET                       (IRO[103].base)
#define TSTORM_MEASURE_PCI_LATENCY_CTRL_SIZE                         (IRO[103].size)
/* Tstorm Measure PCI Latency Data location in RAM */
#define TSTORM_MEASURE_PCI_LATENCY_DATA_OFFSET                       (IRO[104].base)
#define TSTORM_MEASURE_PCI_LATENCY_DATA_SIZE                         (IRO[104].size)
#define TSTORM_AGG_MEASURE_PCI_LATENCY_INDEX                         (IRO[105].base)
#define TSTORM_AGG_MEASURE_PCI_LATENCY_COMP_TYPE                     (IRO[106].base)
/* Description	Function enable bit for Tstorm. Need to be set before a new function (PF or VF) is loaded. */
#define TSTORM_FUNC_EN_OFFSET(funcId)                                (IRO[107].base + ((funcId) * IRO[107].m1))
#define TSTORM_FUNC_EN_SIZE                                          (IRO[107].size)
/* Maps between VF IDs and their parent PF */
#define TSTORM_VF_TO_PF_OFFSET(funcId)                               (IRO[108].base + ((funcId) * IRO[108].m1))
#define TSTORM_VF_TO_PF_SIZE                                         (IRO[108].size)
/* When set, all slow path commands for this function are recorded in Storms assert memory (debug feature). */
#define TSTORM_RECORD_SLOW_PATH_OFFSET(funcId)                       (IRO[109].base + ((funcId) * IRO[109].m1))
#define TSTORM_RECORD_SLOW_PATH_SIZE                                 (IRO[109].size)
/* Offset of per-queue statistics in Tstorm. Need to be zeroes before clients which use this statistics queue are loaded. */
#define TSTORM_PER_QUEUE_STATS_OFFSET(tStatQueueId)                  (IRO[110].base + ((tStatQueueId) * IRO[110].m1))
#define TSTORM_PER_QUEUE_STATS_SIZE                                  (IRO[110].size)
/* SAFC workaround handler enable, needed in Everest1h A0 only. */
#define TSTORM_COMMON_SAFC_WORKAROUND_ENABLE_OFFSET                  (IRO[111].base)
#define TSTORM_COMMON_SAFC_WORKAROUND_ENABLE_SIZE                    (IRO[111].size)
/* SAFC workaround handler timeout, needed in Everest1h A0 only. */
#define TSTORM_COMMON_SAFC_WORKAROUND_TIMEOUT_10USEC_OFFSET          (IRO[112].base)
#define TSTORM_COMMON_SAFC_WORKAROUND_TIMEOUT_10USEC_SIZE            (IRO[112].size)
/* Internal statistics of error handlers in Everets2 */
#define TSTORM_ERROR_HANDLER_STATISTICS_RAM_OFFSET                   (IRO[113].base)
#define TSTORM_ERROR_HANDLER_STATISTICS_RAM_SIZE                     (IRO[113].size)
#define TSTORM_VFC_TEST_RSS_KEY_OFFSET(portId)                       (IRO[114].base + ((portId) * IRO[114].m1))
#define TSTORM_VFC_TEST_RSS_KEY_SIZE                                 (IRO[114].size)
/* VF-accessible queue zone in Tstorm in Everest2 */
#define TSTORM_QUEUE_ZONE_OFFSET(queueId)                            (IRO[115].base + ((queueId) * IRO[115].m1))
#define TSTORM_QUEUE_ZONE_SIZE                                       (IRO[115].size)
/* VF-accessible VF zone in Tstorm in Everest2 */
#define TSTORM_VF_ZONE_OFFSET(vfId)                                  (IRO[116].base + ((vfId) * IRO[116].m1))
#define TSTORM_VF_ZONE_SIZE                                          (IRO[116].size)
#define TSTORM_E2_INTEG_RAM_OFFSET                                   (IRO[117].base)
#define TSTORM_E2_INTEG_RAM_SIZE                                     (IRO[117].size)
#define TSTORM_LSB_SIDE_BAND_INFO_OFFSET                             (IRO[118].base)
#define TSTORM_LSB_SIDE_BAND_INFO_SIZE                               (IRO[118].size)
#define TSTORM_MSB_SIDE_BAND_INFO_OFFSET                             (IRO[119].base)
#define TSTORM_MSB_SIDE_BAND_INFO_SIZE                               (IRO[119].size)
#define TSTORM_VFC_TEST_LINE_OFFSET                                  (IRO[120].base)
#define TSTORM_VFC_TEST_LINE_SIZE                                    (IRO[120].size)
#define TSTORM_VFC_TEST_RESULT_OFFSET                                (IRO[121].base)
#define TSTORM_VFC_TEST_RESULT_SIZE                                  (IRO[121].size)
#define TSTORM_VFC_OP_GEN_VALUE                                      (IRO[122].base)
#define TSTORM_INBOUND_INTERRUPT_TEST_VF_INFO_SIZE_IN_BYTES          (IRO[123].base)
#define TSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_1_INDEX                (IRO[124].base)
#define TSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_2_INDEX                (IRO[125].base)
#define TSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_3_INDEX                (IRO[126].base)
#define TSTORM_KUKU_TEST_OPCODE_OFFSET                               (IRO[127].base)
#define TSTORM_KUKU_TEST_OPCODE_SIZE                                 (IRO[127].size)
#define TSTORM_KUKU_LOAD_CONTEXT_TEST_OFFSET                         (IRO[128].base)
#define TSTORM_KUKU_LOAD_CONTEXT_TEST_SIZE                           (IRO[128].size)
#define TSTORM_KUKU_OP_GEN_VALUE                                     (IRO[129].base)
#define TSTORM_PCI_READ_TEST_ADDRESS_LO_OFFSET                       (IRO[130].base)
#define TSTORM_PCI_READ_TEST_ADDRESS_LO_SIZE                         (IRO[130].size)
#define TSTORM_PCI_READ_TEST_ADDRESS_HI_OFFSET                       (IRO[131].base)
#define TSTORM_PCI_READ_TEST_ADDRESS_HI_SIZE                         (IRO[131].size)
#define TSTORM_PCI_READ_TEST_RAM_ADDRESS_OFFSET                      (IRO[132].base)
#define TSTORM_PCI_READ_TEST_RAM_ADDRESS_SIZE                        (IRO[132].size)
#define TSTORM_PCI_READ_TEST_PCI_ENTITY_OFFSET                       (IRO[133].base)
#define TSTORM_PCI_READ_TEST_PCI_ENTITY_SIZE                         (IRO[133].size)
#define TSTORM_TIME_SYNC_TEST_ADDRESS_OFFSET                         (IRO[134].base)
#define TSTORM_TIME_SYNC_TEST_ADDRESS_SIZE                           (IRO[134].size)
#define TSTORM_KUKU_NIG_PAUSE_TEST_MASK_OFFSET                       (IRO[135].base)
#define TSTORM_KUKU_NIG_PAUSE_TEST_MASK_SIZE                         (IRO[135].size)
/* Status blocks location in Cstorm RAM */
#define CSTORM_STATUS_BLOCK_OFFSET(sbId)                             (IRO[136].base + ((sbId) * IRO[136].m1))
#define CSTORM_STATUS_BLOCK_SIZE                                     (IRO[136].size)
/* Status blocks configuration location in Cstorm RAM */
#define CSTORM_STATUS_BLOCK_DATA_OFFSET(sbId)                        (IRO[137].base + ((sbId) * IRO[137].m1))
#define CSTORM_STATUS_BLOCK_DATA_SIZE                                (IRO[137].size)
/* Status blocks state configuration location in Cstorm RAM */
#define CSTORM_STATUS_BLOCK_DATA_STATE_OFFSET(sbId)                  (IRO[138].base + ((sbId) * IRO[138].m1))
#define CSTORM_STATUS_BLOCK_DATA_STATE_SIZE                          (IRO[138].size)
/* Status blocks timeout per index in Cstorm RAM */
#define CSTORM_STATUS_BLOCK_DATA_TIMEOUT_OFFSET(sbId,hcIndex)        (IRO[139].base + ((sbId) * IRO[139].m1) + ((hcIndex) * IRO[139].m2))
#define CSTORM_STATUS_BLOCK_DATA_TIMEOUT_SIZE                        (IRO[139].size)
/* Status blocks flags per index in Cstorm RAM */
#define CSTORM_STATUS_BLOCK_DATA_FLAGS_OFFSET(sbId,hcIndex)          (IRO[140].base + ((sbId) * IRO[140].m1) + ((hcIndex) * IRO[140].m2))
#define CSTORM_STATUS_BLOCK_DATA_FLAGS_SIZE                          (IRO[140].size)
/* Block of status block synchronization lines in Cstorm RAM */
#define CSTORM_SYNC_BLOCK_OFFSET(sbId)                               (IRO[141].base + ((sbId) * IRO[141].m1))
#define CSTORM_SYNC_BLOCK_SIZE                                       (IRO[141].size)
/* Status block synchronization lines in Cstorm RAM (Everest2) */
#define CSTORM_HC_SYNC_LINE_INDEX_E2_OFFSET(hcIndex,sbId)            (IRO[142].base + (((hcIndex)>>2) * IRO[142].m1) + (((hcIndex)&3) * IRO[142].m2) + ((sbId) * IRO[142].m3))
#define CSTORM_HC_SYNC_LINE_INDEX_E2_SIZE                            (IRO[142].size)
/* Status block synchronization lines in Cstorm RAM (Everest1/1h) */
#define CSTORM_HC_SYNC_LINE_INDEX_E1X_OFFSET(hcIndex,sbId)           (IRO[143].base + ((hcIndex) * IRO[143].m1) + ((sbId) * IRO[143].m2))
#define CSTORM_HC_SYNC_LINE_INDEX_E1X_SIZE                           (IRO[143].size)
/* Dynamic host coalescing counter in synchronization lines */
#define CSTORM_HC_SYNC_LINE_DHC_OFFSET(sbSyncLines,sbId)             (IRO[144].base + ((sbSyncLines) * IRO[144].m1) + ((sbId) * IRO[144].m2))
#define CSTORM_HC_SYNC_LINE_DHC_SIZE                                 (IRO[144].size)
/* Slow path status blocks location in Cstorm RAM. */
#define CSTORM_SP_STATUS_BLOCK_OFFSET(pfId)                          (IRO[145].base + ((pfId) * IRO[145].m1))
#define CSTORM_SP_STATUS_BLOCK_SIZE                                  (IRO[145].size)
/* Slow path status blocks configuration location in Cstorm RAM. */
#define CSTORM_SP_STATUS_BLOCK_DATA_OFFSET(pfId)                     (IRO[146].base + ((pfId) * IRO[146].m1))
#define CSTORM_SP_STATUS_BLOCK_DATA_SIZE                             (IRO[146].size)
/* Slow path status blocks state configuration location in Cstorm RAM. */
#define CSTORM_SP_STATUS_BLOCK_DATA_STATE_OFFSET(pfId)               (IRO[147].base + ((pfId) * IRO[147].m1))
#define CSTORM_SP_STATUS_BLOCK_DATA_STATE_SIZE                       (IRO[147].size)
/* Block of slow path status blocks synchronization lines in Cstorm RAM. */
#define CSTORM_SP_SYNC_BLOCK_OFFSET(pfId)                            (IRO[148].base + ((pfId) * IRO[148].m1))
#define CSTORM_SP_SYNC_BLOCK_SIZE                                    (IRO[148].size)
/* Slow path status blocks synchronization line in Cstorm RAM. */
#define CSTORM_SP_HC_SYNC_LINE_INDEX_OFFSET(hcSpIndex,pfId)          (IRO[149].base + ((hcSpIndex) * IRO[149].m1) + ((pfId) * IRO[149].m2))
#define CSTORM_SP_HC_SYNC_LINE_INDEX_SIZE                            (IRO[149].size)
/* Configuration of dynamic host coalescing algorithm. */
#define CSTORM_DYNAMIC_HC_CONFIG_OFFSET(pfId)                        (IRO[150].base + ((pfId) * IRO[150].m1))
#define CSTORM_DYNAMIC_HC_CONFIG_SIZE                                (IRO[150].size)
/* Cstorm assert list location in RAM  */
#define CSTORM_ASSERT_LIST_OFFSET(assertListEntry)                   (IRO[151].base + ((assertListEntry) * IRO[151].m1))
#define CSTORM_ASSERT_LIST_SIZE                                      (IRO[151].size)
/* Cstorm assert list index (producer) location in RAM */
#define CSTORM_ASSERT_LIST_INDEX_OFFSET                              (IRO[152].base)
#define CSTORM_ASSERT_LIST_INDEX_SIZE                                (IRO[152].size)
/* Function enable bit for Cstorm. Need to be set before a new function (PF or VF) is loaded. */
#define CSTORM_FUNC_EN_OFFSET(funcId)                                (IRO[153].base + ((funcId) * IRO[153].m1))
#define CSTORM_FUNC_EN_SIZE                                          (IRO[153].size)
/* Maps between VF IDs and their parent PF  */
#define CSTORM_VF_TO_PF_OFFSET(funcId)                               (IRO[154].base + ((funcId) * IRO[154].m1))
#define CSTORM_VF_TO_PF_SIZE                                         (IRO[154].size)
/* Configuration of dynamic host coalescing algorithm. */
#define CSTORM_RECORD_SLOW_PATH_OFFSET(funcId)                       (IRO[155].base + ((funcId) * IRO[155].m1))
#define CSTORM_RECORD_SLOW_PATH_SIZE                                 (IRO[155].size)
/* Dynamic HC driver counter, written on fast path */
#define CSTORM_BYTE_COUNTER_OFFSET(sbId,dhcIndex)                    (IRO[156].base + ((sbId) * IRO[156].m1) + ((dhcIndex) * IRO[156].m2))
#define CSTORM_BYTE_COUNTER_SIZE                                     (IRO[156].size)
/* Event ring configuration location on Cstorm RAM */
#define CSTORM_EVENT_RING_DATA_OFFSET(pfId)                          (IRO[157].base + (((pfId)>>1) * IRO[157].m1) + (((pfId)&1) * IRO[157].m2))
#define CSTORM_EVENT_RING_DATA_SIZE                                  (IRO[157].size)
/* Event ring producer location on Cstorm RAM */
#define CSTORM_EVENT_RING_PROD_OFFSET(pfId)                          (IRO[158].base + (((pfId)>>1) * IRO[158].m1) + (((pfId)&1) * IRO[158].m2))
#define CSTORM_EVENT_RING_PROD_SIZE                                  (IRO[158].size)
/* Valid bit of VF-PF channel, used by PF driver to enable the communication channel. */
#define CSTORM_VF_PF_CHANNEL_STATE_OFFSET(vfId)                      (IRO[159].base + ((vfId) * IRO[159].m1))
#define CSTORM_VF_PF_CHANNEL_STATE_SIZE                              (IRO[159].size)
#define CSTORM_VF_PF_CHANNEL_VALID_OFFSET(vfId)                      (IRO[160].base + ((vfId) * IRO[160].m1))
#define CSTORM_VF_PF_CHANNEL_VALID_SIZE                              (IRO[160].size)
/* IGU mode to use in Everest2 (use enum igu_mode) */
#define CSTORM_IGU_MODE_OFFSET                                       (IRO[161].base)
#define CSTORM_IGU_MODE_SIZE                                         (IRO[161].size)
/* Internal statistics of error handlers in Everets2 */
#define CSTORM_ERROR_HANDLER_STATISTICS_RAM_OFFSET                   (IRO[162].base)
#define CSTORM_ERROR_HANDLER_STATISTICS_RAM_SIZE                     (IRO[162].size)
/* Driver polls this offset after FLR final cleanup operation to see when the cleanup operation finished */
#define CSTORM_FINAL_CLEANUP_COMPLETE_OFFSET(funcId)                 (IRO[163].base + ((funcId) * IRO[163].m1))
#define CSTORM_FINAL_CLEANUP_COMPLETE_SIZE                           (IRO[163].size)
/* VF-accessible queue zone in Cstorm in Everest2 */
#define CSTORM_QUEUE_ZONE_OFFSET(queueId)                            (IRO[164].base + ((queueId) * IRO[164].m1))
#define CSTORM_QUEUE_ZONE_SIZE                                       (IRO[164].size)
/* VF-accessible VF zone in Cstorm in Everest2 */
#define CSTORM_VF_ZONE_OFFSET(vfId)                                  (IRO[165].base + ((vfId) * IRO[165].m1))
#define CSTORM_VF_ZONE_SIZE                                          (IRO[165].size)
#define CSTORM_INBOUND_INTERRUPT_TEST_VF_INFO_SIZE_IN_BYTES          (IRO[166].base)
#define CSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_1_INDEX                (IRO[167].base)
#define CSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_2_INDEX                (IRO[168].base)
#define CSTORM_INBOUND_INTERRUPT_TEST_AGG_INT_3_INDEX                (IRO[169].base)
#define CSTORM_KUKU_TEST_OPCODE_OFFSET                               (IRO[170].base)
#define CSTORM_KUKU_TEST_OPCODE_SIZE                                 (IRO[170].size)
#define CSTORM_KUKU_LOAD_CONTEXT_TEST_OFFSET                         (IRO[171].base)
#define CSTORM_KUKU_LOAD_CONTEXT_TEST_SIZE                           (IRO[171].size)
#define CSTORM_KUKU_OP_GEN_VALUE                                     (IRO[172].base)
#define CSTORM_IGU_TEST_PF_ID_OFFSET                                 (IRO[173].base)
#define CSTORM_IGU_TEST_PF_ID_SIZE                                   (IRO[173].size)
#define CSTORM_IGU_TEST_VF_ID_OFFSET                                 (IRO[174].base)
#define CSTORM_IGU_TEST_VF_ID_SIZE                                   (IRO[174].size)
#define CSTORM_IGU_TEST_VF_VALID_OFFSET                              (IRO[175].base)
#define CSTORM_IGU_TEST_VF_VALID_SIZE                                (IRO[175].size)
#define CSTORM_IGU_TEST_ADDRESS_OFFSET                               (IRO[176].base)
#define CSTORM_IGU_TEST_ADDRESS_SIZE                                 (IRO[176].size)
#define CSTORM_IGU_TEST_IGU_COMMAND_OFFSET                           (IRO[177].base)
#define CSTORM_IGU_TEST_IGU_COMMAND_SIZE                             (IRO[177].size)
#define USTORM_INDIRECTION_TABLE_OFFSET(portId)                      (IRO[178].base + ((portId) * IRO[178].m1))
#define USTORM_INDIRECTION_TABLE_SIZE                                (IRO[178].size)
#define USTORM_INDIRECTION_TABLE_ENTRY_SIZE                          (IRO[179].base)
/* Ustorm assert list location in RAM */
#define USTORM_ASSERT_LIST_OFFSET(assertListEntry)                   (IRO[180].base + ((assertListEntry) * IRO[180].m1))
#define USTORM_ASSERT_LIST_SIZE                                      (IRO[180].size)
/* Ustorm assert list index (producer) location in RAM */
#define USTORM_ASSERT_LIST_INDEX_OFFSET                              (IRO[181].base)
#define USTORM_ASSERT_LIST_INDEX_SIZE                                (IRO[181].size)
/* Function enable bit for Ustorm. Need to be set before a new function (PF or VF) is loaded. */
#define USTORM_FUNC_EN_OFFSET(funcId)                                (IRO[182].base + ((funcId) * IRO[182].m1))
#define USTORM_FUNC_EN_SIZE                                          (IRO[182].size)
/* Maps between VF IDs and their parent PF */
#define USTORM_VF_TO_PF_OFFSET(funcId)                               (IRO[183].base + ((funcId) * IRO[183].m1))
#define USTORM_VF_TO_PF_SIZE                                         (IRO[183].size)
/* When set, all slow path commands for this function are recorded in Storms assert memory (debug feature). */
#define USTORM_RECORD_SLOW_PATH_OFFSET(funcId)                       (IRO[184].base + ((funcId) * IRO[184].m1))
#define USTORM_RECORD_SLOW_PATH_SIZE                                 (IRO[184].size)
/* Offset of per-queue statistics in Ustorm. Need to be zeroes before clients which use this statistics queue are loaded. */
#define USTORM_PER_QUEUE_STATS_OFFSET(uStatQueueId)                  (IRO[185].base + ((uStatQueueId) * IRO[185].m1))
#define USTORM_PER_QUEUE_STATS_SIZE                                  (IRO[185].size)
/* Valid physical address on host memory, used in Everest1 for PXP memory bug workaround */
#define USTORM_MEM_WORKAROUND_ADDRESS_OFFSET(pfId)                   (IRO[186].base + ((pfId) * IRO[186].m1))
#define USTORM_MEM_WORKAROUND_ADDRESS_SIZE                           (IRO[186].size)
/* Enable for pause on exhausted ring feature for Ethernet */
#define USTORM_ETH_PAUSE_ENABLED_OFFSET(portId)                      (IRO[187].base + ((portId) * IRO[187].m1))
#define USTORM_ETH_PAUSE_ENABLED_SIZE                                (IRO[187].size)
/* Enable for pause on exhausted ring feature for TOE */
#define USTORM_TOE_PAUSE_ENABLED_OFFSET(portId)                      (IRO[188].base + ((portId) * IRO[188].m1))
#define USTORM_TOE_PAUSE_ENABLED_SIZE                                (IRO[188].size)
/* Timeout for stopping sending pause commands from RX firmware, in order to avoid constant pause in case of driver not responding. */
#define USTORM_MAX_PAUSE_TIME_USEC_OFFSET(portId)                    (IRO[189].base + ((portId) * IRO[189].m1))
#define USTORM_MAX_PAUSE_TIME_USEC_SIZE                              (IRO[189].size)
/* Internal statistics of error handlers in Everets2 */
#define USTORM_ERROR_HANDLER_STATISTICS_RAM_OFFSET                   (IRO[190].base)
#define USTORM_ERROR_HANDLER_STATISTICS_RAM_SIZE                     (IRO[190].size)
/* VF-accessible queue zone in Ustorm in Everest2 */
#define USTORM_QUEUE_ZONE_OFFSET(queueId)                            (IRO[191].base + ((queueId) * IRO[191].m1))
#define USTORM_QUEUE_ZONE_SIZE                                       (IRO[191].size)
/* VF-accessible VF zone in Ustorm in Everest2 */
#define USTORM_VF_ZONE_OFFSET(vfId)                                  (IRO[192].base + ((vfId) * IRO[192].m1))
#define USTORM_VF_ZONE_SIZE                                          (IRO[192].size)
#define USTORM_INBOUND_INTERRUPT_TEST_VF_INFO_SIZE_IN_BYTES          (IRO[193].base)
#define USTORM_INBOUND_INTERRUPT_TEST_AGG_INT_1_INDEX                (IRO[194].base)
#define USTORM_INBOUND_INTERRUPT_TEST_AGG_INT_2_INDEX                (IRO[195].base)
#define USTORM_INBOUND_INTERRUPT_TEST_AGG_INT_3_INDEX                (IRO[196].base)
#define USTORM_KUKU_TEST_OPCODE_OFFSET                               (IRO[197].base)
#define USTORM_KUKU_TEST_OPCODE_SIZE                                 (IRO[197].size)
#define USTORM_KUKU_LOAD_CONTEXT_TEST_OFFSET                         (IRO[198].base)
#define USTORM_KUKU_LOAD_CONTEXT_TEST_SIZE                           (IRO[198].size)
#define USTORM_KUKU_OP_GEN_VALUE                                     (IRO[199].base)
#define USTORM_PCI_READ_TEST_ADDRESS_LO_OFFSET                       (IRO[200].base)
#define USTORM_PCI_READ_TEST_ADDRESS_LO_SIZE                         (IRO[200].size)
#define USTORM_PCI_READ_TEST_ADDRESS_HI_OFFSET                       (IRO[201].base)
#define USTORM_PCI_READ_TEST_ADDRESS_HI_SIZE                         (IRO[201].size)
#define USTORM_PCI_READ_TEST_RAM_ADDRESS_OFFSET                      (IRO[202].base)
#define USTORM_PCI_READ_TEST_RAM_ADDRESS_SIZE                        (IRO[202].size)
#define USTORM_PCI_READ_TEST_PCI_ENTITY_OFFSET                       (IRO[203].base)
#define USTORM_PCI_READ_TEST_PCI_ENTITY_SIZE                         (IRO[203].size)
#define USTORM_KUKU_NIG_PAUSE_TEST_MASK_OFFSET                       (IRO[204].base)
#define USTORM_KUKU_NIG_PAUSE_TEST_MASK_SIZE                         (IRO[204].size)
/* PF-related classification data, used in Everest1/1h */
#define TSTORM_FUNCTION_COMMON_CONFIG_OFFSET(pfId)                   (IRO[205].base + ((pfId) * IRO[205].m1))
#define TSTORM_FUNCTION_COMMON_CONFIG_SIZE                           (IRO[205].size)
/* PF-related filter bits, used in Everest1/1h */
#define TSTORM_MAC_FILTER_CONFIG_OFFSET(pfId)                        (IRO[206].base + ((pfId) * IRO[206].m1))
#define TSTORM_MAC_FILTER_CONFIG_SIZE                                (IRO[206].size)
/* PF-related approximate multicast bits, used in Everest1h */
#define TSTORM_APPROXIMATE_MATCH_MULTICAST_FILTERING_OFFSET(pfId)    (IRO[207].base + ((pfId) * IRO[207].m1))
#define TSTORM_APPROXIMATE_MATCH_MULTICAST_FILTERING_SIZE            (IRO[207].size)
/* Set in order to accept packets which failed MF classification (for debug purpose) */
#define TSTORM_ACCEPT_CLASSIFY_FAILED_OFFSET                         (IRO[208].base)
#define TSTORM_ACCEPT_CLASSIFY_FAILED_SIZE                           (IRO[208].size)
/* Set in order to accept packets which failed MF classification (for debug purpose) */
#define TSTORM_ACCEPT_CLASSIFY_FAIL_E2_ENABLE_OFFSET(portId)         (IRO[209].base + ((portId) * IRO[209].m1))
#define TSTORM_ACCEPT_CLASSIFY_FAIL_E2_ENABLE_SIZE                   (IRO[209].size)
/* Set the VNIC to accept packets which failed MF classification (for debug purpose) */
#define TSTORM_ACCEPT_CLASSIFY_FAIL_E2_VNIC_OFFSET(portId)           (IRO[210].base + ((portId) * IRO[210].m1))
#define TSTORM_ACCEPT_CLASSIFY_FAIL_E2_VNIC_SIZE                     (IRO[210].size)
#define USTORM_CQE_PAGE_NEXT_OFFSET(portId,clientId)                 (IRO[211].base + ((portId) * IRO[211].m1) + ((clientId) * IRO[211].m2))
#define USTORM_CQE_PAGE_NEXT_SIZE                                    (IRO[211].size)
/* TPA aggregation data (should be zeroed by driver upon init as init tool has limitation of data unions) */
#define USTORM_AGG_DATA_OFFSET                                       (IRO[212].base)
#define USTORM_AGG_DATA_SIZE                                         (IRO[212].size)
/* TPA aggregation timeout value */
#define USTORM_TPA_BTR_OFFSET                                        (IRO[213].base)
#define USTORM_TPA_BTR_SIZE                                          (IRO[213].size)
/* Minimum byte count for a single packet in dynamic host coalescing counters */
#define USTORM_ETH_DYNAMIC_HC_PARAM_OFFSET                           (IRO[214].base)
#define USTORM_ETH_DYNAMIC_HC_PARAM_SIZE                             (IRO[214].size)
/* RX rings producers, updated in fats path in Ustorm RAM (Everest1/1h) */
#define USTORM_RX_PRODS_E1X_OFFSET(portId,clientId)                  (IRO[215].base + ((portId) * IRO[215].m1) + ((clientId) * IRO[215].m2))
#define USTORM_RX_PRODS_E1X_SIZE                                     (IRO[215].size)
/* RX rings producers, updated in fats path in Ustorm RAM (Everest2) */
#define USTORM_RX_PRODS_E2_OFFSET(qzoneId)                           (IRO[216].base + ((qzoneId) * IRO[216].m1))
#define USTORM_RX_PRODS_E2_SIZE                                      (IRO[216].size)
#define XSTORM_TCP_GLOBAL_DEL_ACK_COUNTER_ENABLED_OFFSET(portId)     (IRO[217].base + ((portId) * IRO[217].m1))
#define XSTORM_TCP_GLOBAL_DEL_ACK_COUNTER_ENABLED_SIZE               (IRO[217].size)
#define XSTORM_TCP_GLOBAL_DEL_ACK_COUNTER_MAX_COUNT_OFFSET(portId)   (IRO[218].base + ((portId) * IRO[218].m1))
#define XSTORM_TCP_GLOBAL_DEL_ACK_COUNTER_MAX_COUNT_SIZE             (IRO[218].size)
#define XSTORM_TCP_IPID_OFFSET(pfId)                                 (IRO[219].base + (((pfId)>>1) * IRO[219].m1) + (((pfId)&1) * IRO[219].m2))
#define XSTORM_TCP_IPID_SIZE                                         (IRO[219].size)
#define XSTORM_TCP_TX_SWS_TIMER_VAL_OFFSET(pfId)                     (IRO[220].base + (((pfId)>>1) * IRO[220].m1) + (((pfId)&1) * IRO[220].m2))
#define XSTORM_TCP_TX_SWS_TIMER_VAL_SIZE                             (IRO[220].size)
#define XSTORM_TCP_TX_SWITCHING_EN_OFFSET(portId)                    (IRO[221].base + ((portId) * IRO[221].m1))
#define XSTORM_TCP_TX_SWITCHING_EN_SIZE                              (IRO[221].size)
#define TSTORM_TCP_DUPLICATE_ACK_THRESHOLD_OFFSET(pfId)              (IRO[222].base + ((pfId) * IRO[222].m1))
#define TSTORM_TCP_DUPLICATE_ACK_THRESHOLD_SIZE                      (IRO[222].size)
#define TSTORM_TCP_MAX_CWND_OFFSET(pfId)                             (IRO[223].base + ((pfId) * IRO[223].m1))
#define TSTORM_TCP_MAX_CWND_SIZE                                     (IRO[223].size)
#define TSTORM_TCP_GLOBAL_PARAMS_OFFSET                              (IRO[224].base)
#define TSTORM_TCP_GLOBAL_PARAMS_SIZE                                (IRO[224].size)
#define TSTORM_TCP_ISLES_ARRAY_DESCRIPTOR_OFFSET                     (IRO[225].base)
#define TSTORM_TCP_ISLES_ARRAY_DESCRIPTOR_SIZE                       (IRO[225].size)
#define TSTORM_TCP_ISLES_ARRAY_OFFSET                                (IRO[226].base)
#define TSTORM_TCP_ISLES_ARRAY_SIZE                                  (IRO[226].size)
#define XSTORM_TOE_LLC_SNAP_ENABLED_OFFSET(pfId)                     (IRO[227].base + (((pfId)>>1) * IRO[227].m1) + (((pfId)&1) * IRO[227].m2))
#define XSTORM_TOE_LLC_SNAP_ENABLED_SIZE                             (IRO[227].size)
#define XSTORM_OUT_OCTETS_OFFSET                                     (IRO[228].base)
#define XSTORM_OUT_OCTETS_SIZE                                       (IRO[228].size)
#define TSTORM_TOE_MAX_SEG_RETRANSMIT_OFFSET(pfId)                   (IRO[229].base + ((pfId) * IRO[229].m1))
#define TSTORM_TOE_MAX_SEG_RETRANSMIT_SIZE                           (IRO[229].size)
#define TSTORM_TOE_DOUBT_REACHABILITY_OFFSET(pfId)                   (IRO[230].base + ((pfId) * IRO[230].m1))
#define TSTORM_TOE_DOUBT_REACHABILITY_SIZE                           (IRO[230].size)
#define TSTORM_TOE_MAX_DOMINANCE_VALUE_OFFSET                        (IRO[231].base)
#define TSTORM_TOE_MAX_DOMINANCE_VALUE_SIZE                          (IRO[231].size)
#define TSTORM_TOE_DOMINANCE_THRESHOLD_OFFSET                        (IRO[232].base)
#define TSTORM_TOE_DOMINANCE_THRESHOLD_SIZE                          (IRO[232].size)
#define CSTORM_TOE_CQ_CONS_PTR_LO_OFFSET(rssId,portId)               (IRO[233].base + ((rssId) * IRO[233].m1) + ((portId) * IRO[233].m2))
#define CSTORM_TOE_CQ_CONS_PTR_LO_SIZE                               (IRO[233].size)
#define CSTORM_TOE_CQ_CONS_PTR_HI_OFFSET(rssId,portId)               (IRO[234].base + ((rssId) * IRO[234].m1) + ((portId) * IRO[234].m2))
#define CSTORM_TOE_CQ_CONS_PTR_HI_SIZE                               (IRO[234].size)
#define CSTORM_TOE_CQ_PROD_OFFSET(rssId,portId)                      (IRO[235].base + ((rssId) * IRO[235].m1) + ((portId) * IRO[235].m2))
#define CSTORM_TOE_CQ_PROD_SIZE                                      (IRO[235].size)
#define CSTORM_TOE_CQ_CONS_OFFSET(rssId,portId)                      (IRO[236].base + ((rssId) * IRO[236].m1) + ((portId) * IRO[236].m2))
#define CSTORM_TOE_CQ_CONS_SIZE                                      (IRO[236].size)
#define CSTORM_TOE_CQ_NXT_PAGE_ADDR_VALID_OFFSET(rssId,portId)       (IRO[237].base + ((rssId) * IRO[237].m1) + ((portId) * IRO[237].m2))
#define CSTORM_TOE_CQ_NXT_PAGE_ADDR_VALID_SIZE                       (IRO[237].size)
#define CSTORM_TOE_STATUS_BLOCK_ID_OFFSET(rssId,portId)              (IRO[238].base + ((rssId) * IRO[238].m1) + ((portId) * IRO[238].m2))
#define CSTORM_TOE_STATUS_BLOCK_ID_SIZE                              (IRO[238].size)
#define CSTORM_TOE_STATUS_BLOCK_INDEX_OFFSET(rssId,portId)           (IRO[239].base + ((rssId) * IRO[239].m1) + ((portId) * IRO[239].m2))
#define CSTORM_TOE_STATUS_BLOCK_INDEX_SIZE                           (IRO[239].size)
#define CSTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_LO_OFFSET(rssId,portId)    (IRO[240].base + ((rssId) * IRO[240].m1) + ((portId) * IRO[240].m2))
#define CSTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_LO_SIZE                    (IRO[240].size)
#define CSTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_HI_OFFSET(rssId,portId)    (IRO[241].base + ((rssId) * IRO[241].m1) + ((portId) * IRO[241].m2))
#define CSTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_HI_SIZE                    (IRO[241].size)
#define CSTORM_TOE_DYNAMIC_HC_PROD_OFFSET(rssId,portId)              (IRO[242].base + ((rssId) * IRO[242].m1) + ((portId) * IRO[242].m2))
#define CSTORM_TOE_DYNAMIC_HC_PROD_SIZE                              (IRO[242].size)
#define CSTORM_TOE_DYNAMIC_HC_CONS_OFFSET(rssId,portId)              (IRO[243].base + ((rssId) * IRO[243].m1) + ((portId) * IRO[243].m2))
#define CSTORM_TOE_DYNAMIC_HC_CONS_SIZE                              (IRO[243].size)
#define USTORM_GRQ_CACHE_BD_LO_OFFSET(rssId,portId,grqBdId)          (IRO[244].base + ((rssId) * IRO[244].m1) + ((portId) * IRO[244].m2) + ((grqBdId) * IRO[244].m3))
#define USTORM_GRQ_CACHE_BD_LO_SIZE                                  (IRO[244].size)
#define USTORM_GRQ_CACHE_BD_HI_OFFSET(rssId,portId,grqBdId)          (IRO[245].base + ((rssId) * IRO[245].m1) + ((portId) * IRO[245].m2) + ((grqBdId) * IRO[245].m3))
#define USTORM_GRQ_CACHE_BD_HI_SIZE                                  (IRO[245].size)
#define USTORM_TOE_GRQ_CACHE_NUM_BDS                                 (IRO[246].base)
#define USTORM_TOE_GRQ_LOCAL_PROD_OFFSET(rssId,portId)               (IRO[247].base + ((rssId) * IRO[247].m1) + ((portId) * IRO[247].m2))
#define USTORM_TOE_GRQ_LOCAL_PROD_SIZE                               (IRO[247].size)
#define USTORM_TOE_GRQ_LOCAL_CONS_OFFSET(rssId,portId)               (IRO[248].base + ((rssId) * IRO[248].m1) + ((portId) * IRO[248].m2))
#define USTORM_TOE_GRQ_LOCAL_CONS_SIZE                               (IRO[248].size)
#define USTORM_TOE_GRQ_CONS_OFFSET(rssId,portId)                     (IRO[249].base + ((rssId) * IRO[249].m1) + ((portId) * IRO[249].m2))
#define USTORM_TOE_GRQ_CONS_SIZE                                     (IRO[249].size)
#define USTORM_TOE_GRQ_PROD_OFFSET(rssId,portId)                     (IRO[250].base + ((rssId) * IRO[250].m1) + ((portId) * IRO[250].m2))
#define USTORM_TOE_GRQ_PROD_SIZE                                     (IRO[250].size)
#define USTORM_TOE_GRQ_CONS_PTR_LO_OFFSET(rssId,portId)              (IRO[251].base + ((rssId) * IRO[251].m1) + ((portId) * IRO[251].m2))
#define USTORM_TOE_GRQ_CONS_PTR_LO_SIZE                              (IRO[251].size)
#define USTORM_TOE_GRQ_CONS_PTR_HI_OFFSET(rssId,portId)              (IRO[252].base + ((rssId) * IRO[252].m1) + ((portId) * IRO[252].m2))
#define USTORM_TOE_GRQ_CONS_PTR_HI_SIZE                              (IRO[252].size)
#define USTORM_TOE_GRQ_BUF_SIZE_OFFSET(rssId,portId)                 (IRO[253].base + ((rssId) * IRO[253].m1) + ((portId) * IRO[253].m2))
#define USTORM_TOE_GRQ_BUF_SIZE_SIZE                                 (IRO[253].size)
#define USTORM_TOE_CQ_NXT_PAGE_ADDR_VALID_OFFSET(rssId,portId)       (IRO[254].base + ((rssId) * IRO[254].m1) + ((portId) * IRO[254].m2))
#define USTORM_TOE_CQ_NXT_PAGE_ADDR_VALID_SIZE                       (IRO[254].size)
#define USTORM_TOE_CQ_CONS_OFFSET(rssId,portId)                      (IRO[255].base + ((rssId) * IRO[255].m1) + ((portId) * IRO[255].m2))
#define USTORM_TOE_CQ_CONS_SIZE                                      (IRO[255].size)
#define USTORM_TOE_CQ_PROD_OFFSET(rssId,portId)                      (IRO[256].base + ((rssId) * IRO[256].m1) + ((portId) * IRO[256].m2))
#define USTORM_TOE_CQ_PROD_SIZE                                      (IRO[256].size)
#define USTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_LO_OFFSET(rssId,portId)    (IRO[257].base + ((rssId) * IRO[257].m1) + ((portId) * IRO[257].m2))
#define USTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_LO_SIZE                    (IRO[257].size)
#define USTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_HI_OFFSET(rssId,portId)    (IRO[258].base + ((rssId) * IRO[258].m1) + ((portId) * IRO[258].m2))
#define USTORM_TOE_CQ_NEXT_PAGE_BASE_ADDR_HI_SIZE                    (IRO[258].size)
#define USTORM_TOE_CQ_CONS_PTR_LO_OFFSET(rssId,portId)               (IRO[259].base + ((rssId) * IRO[259].m1) + ((portId) * IRO[259].m2))
#define USTORM_TOE_CQ_CONS_PTR_LO_SIZE                               (IRO[259].size)
#define USTORM_TOE_CQ_CONS_PTR_HI_OFFSET(rssId,portId)               (IRO[260].base + ((rssId) * IRO[260].m1) + ((portId) * IRO[260].m2))
#define USTORM_TOE_CQ_CONS_PTR_HI_SIZE                               (IRO[260].size)
#define USTORM_TOE_STATUS_BLOCK_ID_OFFSET(rssId,portId)              (IRO[261].base + ((rssId) * IRO[261].m1) + ((portId) * IRO[261].m2))
#define USTORM_TOE_STATUS_BLOCK_ID_SIZE                              (IRO[261].size)
#define USTORM_TOE_STATUS_BLOCK_INDEX_OFFSET(rssId,portId)           (IRO[262].base + ((rssId) * IRO[262].m1) + ((portId) * IRO[262].m2))
#define USTORM_TOE_STATUS_BLOCK_INDEX_SIZE                           (IRO[262].size)
#define USTORM_TOE_TCP_PUSH_TIMER_TICKS_OFFSET(pfId)                 (IRO[263].base + ((pfId) * IRO[263].m1))
#define USTORM_TOE_TCP_PUSH_TIMER_TICKS_SIZE                         (IRO[263].size)
#define USTORM_TOE_GRQ_XOFF_COUNTER_OFFSET(pfId)                     (IRO[264].base + ((pfId) * IRO[264].m1))
#define USTORM_TOE_GRQ_XOFF_COUNTER_SIZE                             (IRO[264].size)
#define USTORM_TOE_RCQ_XOFF_COUNTER_OFFSET(pfId)                     (IRO[265].base + ((pfId) * IRO[265].m1))
#define USTORM_TOE_RCQ_XOFF_COUNTER_SIZE                             (IRO[265].size)
#define USTORM_TOE_CQ_THR_LOW_OFFSET                                 (IRO[266].base)
#define USTORM_TOE_CQ_THR_LOW_SIZE                                   (IRO[266].size)
#define USTORM_TOE_GRQ_THR_LOW_OFFSET                                (IRO[267].base)
#define USTORM_TOE_GRQ_THR_LOW_SIZE                                  (IRO[267].size)
#define USTORM_TOE_CQ_THR_HIGH_OFFSET                                (IRO[268].base)
#define USTORM_TOE_CQ_THR_HIGH_SIZE                                  (IRO[268].size)
#define USTORM_TOE_GRQ_THR_HIGH_OFFSET                               (IRO[269].base)
#define USTORM_TOE_GRQ_THR_HIGH_SIZE                                 (IRO[269].size)
#define TSTORM_ISCSI_TCP_VARS_FLAGS_OFFSET(pfId)                     (IRO[270].base + ((pfId) * IRO[270].m1))
#define TSTORM_ISCSI_TCP_VARS_FLAGS_SIZE                             (IRO[270].size)
#define TSTORM_ISCSI_TCP_VARS_LSB_LOCAL_MAC_ADDR_OFFSET(pfId)        (IRO[271].base + ((pfId) * IRO[271].m1))
#define TSTORM_ISCSI_TCP_VARS_LSB_LOCAL_MAC_ADDR_SIZE                (IRO[271].size)
#define TSTORM_ISCSI_TCP_VARS_MID_LOCAL_MAC_ADDR_OFFSET(pfId)        (IRO[272].base + ((pfId) * IRO[272].m1))
#define TSTORM_ISCSI_TCP_VARS_MID_LOCAL_MAC_ADDR_SIZE                (IRO[272].size)
#define TSTORM_ISCSI_TCP_VARS_MSB_LOCAL_MAC_ADDR_OFFSET(pfId)        (IRO[273].base + ((pfId) * IRO[273].m1))
#define TSTORM_ISCSI_TCP_VARS_MSB_LOCAL_MAC_ADDR_SIZE                (IRO[273].size)
#define TSTORM_ISCSI_RQ_SIZE_OFFSET(pfId)                            (IRO[274].base + ((pfId) * IRO[274].m1))
#define TSTORM_ISCSI_RQ_SIZE_SIZE                                    (IRO[274].size)
#define TSTORM_ISCSI_PAGE_SIZE_OFFSET(pfId)                          (IRO[275].base + ((pfId) * IRO[275].m1))
#define TSTORM_ISCSI_PAGE_SIZE_SIZE                                  (IRO[275].size)
#define TSTORM_ISCSI_PAGE_SIZE_LOG_OFFSET(pfId)                      (IRO[276].base + ((pfId) * IRO[276].m1))
#define TSTORM_ISCSI_PAGE_SIZE_LOG_SIZE                              (IRO[276].size)
#define TSTORM_ISCSI_NUM_OF_TASKS_OFFSET(pfId)                       (IRO[277].base + ((pfId) * IRO[277].m1))
#define TSTORM_ISCSI_NUM_OF_TASKS_SIZE                               (IRO[277].size)
#define TSTORM_ISCSI_ERROR_BITMAP_OFFSET(pfId)                       (IRO[278].base + ((pfId) * IRO[278].m1))
#define TSTORM_ISCSI_ERROR_BITMAP_SIZE                               (IRO[278].size)
#define TSTORM_ISCSI_L2_ISCSI_OOO_CID_TABLE_OFFSET(pfId)             (IRO[279].base + ((pfId) * IRO[279].m1))
#define TSTORM_ISCSI_L2_ISCSI_OOO_CID_TABLE_SIZE                     (IRO[279].size)
#define TSTORM_ISCSI_L2_ISCSI_OOO_CLIENT_ID_TABLE_OFFSET(pfId)       (IRO[280].base + ((pfId) * IRO[280].m1))
#define TSTORM_ISCSI_L2_ISCSI_OOO_CLIENT_ID_TABLE_SIZE               (IRO[280].size)
#define TSTORM_ISCSI_L2_ISCSI_OOO_PROD_OFFSET(pfId)                  (IRO[281].base + ((pfId) * IRO[281].m1))
#define TSTORM_ISCSI_L2_ISCSI_OOO_PROD_SIZE                          (IRO[281].size)
#define TSTORM_ISCSI_L2_ISCSI_OOO_RX_BDS_THRSHLD_OFFSET(pfId)        (IRO[282].base + ((pfId) * IRO[282].m1))
#define TSTORM_ISCSI_L2_ISCSI_OOO_RX_BDS_THRSHLD_SIZE                (IRO[282].size)
#define TSTORM_ISCSI_L2_ISCSI_OOO_CONS_OFFSET(pfId)                  (IRO[283].base + ((pfId) * IRO[283].m1))
#define TSTORM_ISCSI_L2_ISCSI_OOO_CONS_SIZE                          (IRO[283].size)
#define TSTORM_ISCSI_TCP_LOCAL_ADV_WND_OFFSET(pfId)                  (IRO[284].base + ((pfId) * IRO[284].m1))
#define TSTORM_ISCSI_TCP_LOCAL_ADV_WND_SIZE                          (IRO[284].size)
#define USTORM_ISCSI_PAGE_SIZE_OFFSET(pfId)                          (IRO[285].base + ((pfId) * IRO[285].m1))
#define USTORM_ISCSI_PAGE_SIZE_SIZE                                  (IRO[285].size)
#define USTORM_ISCSI_PAGE_SIZE_LOG_OFFSET(pfId)                      (IRO[286].base + ((pfId) * IRO[286].m1))
#define USTORM_ISCSI_PAGE_SIZE_LOG_SIZE                              (IRO[286].size)
#define USTORM_ISCSI_NUM_OF_TASKS_OFFSET(pfId)                       (IRO[287].base + ((pfId) * IRO[287].m1))
#define USTORM_ISCSI_NUM_OF_TASKS_SIZE                               (IRO[287].size)
#define USTORM_ISCSI_R2TQ_SIZE_OFFSET(pfId)                          (IRO[288].base + ((pfId) * IRO[288].m1))
#define USTORM_ISCSI_R2TQ_SIZE_SIZE                                  (IRO[288].size)
#define USTORM_ISCSI_CQ_SIZE_OFFSET(pfId)                            (IRO[289].base + ((pfId) * IRO[289].m1))
#define USTORM_ISCSI_CQ_SIZE_SIZE                                    (IRO[289].size)
#define USTORM_ISCSI_CQ_SQN_SIZE_OFFSET(pfId)                        (IRO[290].base + ((pfId) * IRO[290].m1))
#define USTORM_ISCSI_CQ_SQN_SIZE_SIZE                                (IRO[290].size)
#define USTORM_ISCSI_GLOBAL_BUF_PHYS_ADDR_OFFSET(pfId)               (IRO[291].base + ((pfId) * IRO[291].m1))
#define USTORM_ISCSI_GLOBAL_BUF_PHYS_ADDR_SIZE                       (IRO[291].size)
#define USTORM_ISCSI_RQ_BUFFER_SIZE_OFFSET(pfId)                     (IRO[292].base + ((pfId) * IRO[292].m1))
#define USTORM_ISCSI_RQ_BUFFER_SIZE_SIZE                             (IRO[292].size)
#define USTORM_ISCSI_RQ_SIZE_OFFSET(pfId)                            (IRO[293].base + ((pfId) * IRO[293].m1))
#define USTORM_ISCSI_RQ_SIZE_SIZE                                    (IRO[293].size)
#define USTORM_ISCSI_ERROR_BITMAP_OFFSET(pfId)                       (IRO[294].base + ((pfId) * IRO[294].m1))
#define USTORM_ISCSI_ERROR_BITMAP_SIZE                               (IRO[294].size)
#define XSTORM_ISCSI_TCP_VARS_TTL_OFFSET(pfId)                       (IRO[295].base + ((pfId) * IRO[295].m1))
#define XSTORM_ISCSI_TCP_VARS_TTL_SIZE                               (IRO[295].size)
#define XSTORM_ISCSI_TCP_VARS_TOS_OFFSET(pfId)                       (IRO[296].base + ((pfId) * IRO[296].m1))
#define XSTORM_ISCSI_TCP_VARS_TOS_SIZE                               (IRO[296].size)
#define XSTORM_ISCSI_TCP_VARS_FLAGS_OFFSET(pfId)                     (IRO[297].base + ((pfId) * IRO[297].m1))
#define XSTORM_ISCSI_TCP_VARS_FLAGS_SIZE                             (IRO[297].size)
#define XSTORM_ISCSI_TCP_VARS_ADV_WND_SCL_OFFSET(pfId)               (IRO[298].base + ((pfId) * IRO[298].m1))
#define XSTORM_ISCSI_TCP_VARS_ADV_WND_SCL_SIZE                       (IRO[298].size)
#define XSTORM_ISCSI_PAGE_SIZE_OFFSET(pfId)                          (IRO[299].base + ((pfId) * IRO[299].m1))
#define XSTORM_ISCSI_PAGE_SIZE_SIZE                                  (IRO[299].size)
#define XSTORM_ISCSI_PAGE_SIZE_LOG_OFFSET(pfId)                      (IRO[300].base + ((pfId) * IRO[300].m1))
#define XSTORM_ISCSI_PAGE_SIZE_LOG_SIZE                              (IRO[300].size)
#define XSTORM_ISCSI_NUM_OF_TASKS_OFFSET(pfId)                       (IRO[301].base + ((pfId) * IRO[301].m1))
#define XSTORM_ISCSI_NUM_OF_TASKS_SIZE                               (IRO[301].size)
#define XSTORM_ISCSI_HQ_SIZE_OFFSET(pfId)                            (IRO[302].base + ((pfId) * IRO[302].m1))
#define XSTORM_ISCSI_HQ_SIZE_SIZE                                    (IRO[302].size)
#define XSTORM_ISCSI_SQ_SIZE_OFFSET(pfId)                            (IRO[303].base + ((pfId) * IRO[303].m1))
#define XSTORM_ISCSI_SQ_SIZE_SIZE                                    (IRO[303].size)
#define XSTORM_ISCSI_R2TQ_SIZE_OFFSET(pfId)                          (IRO[304].base + ((pfId) * IRO[304].m1))
#define XSTORM_ISCSI_R2TQ_SIZE_SIZE                                  (IRO[304].size)
#define XSTORM_ISCSI_LOCAL_MAC_ADDR0_OFFSET(pfId)                    (IRO[305].base + ((pfId) * IRO[305].m1))
#define XSTORM_ISCSI_LOCAL_MAC_ADDR0_SIZE                            (IRO[305].size)
#define XSTORM_ISCSI_LOCAL_MAC_ADDR1_OFFSET(pfId)                    (IRO[306].base + ((pfId) * IRO[306].m1))
#define XSTORM_ISCSI_LOCAL_MAC_ADDR1_SIZE                            (IRO[306].size)
#define XSTORM_ISCSI_LOCAL_MAC_ADDR2_OFFSET(pfId)                    (IRO[307].base + ((pfId) * IRO[307].m1))
#define XSTORM_ISCSI_LOCAL_MAC_ADDR2_SIZE                            (IRO[307].size)
#define XSTORM_ISCSI_LOCAL_MAC_ADDR3_OFFSET(pfId)                    (IRO[308].base + ((pfId) * IRO[308].m1))
#define XSTORM_ISCSI_LOCAL_MAC_ADDR3_SIZE                            (IRO[308].size)
#define XSTORM_ISCSI_LOCAL_MAC_ADDR4_OFFSET(pfId)                    (IRO[309].base + ((pfId) * IRO[309].m1))
#define XSTORM_ISCSI_LOCAL_MAC_ADDR4_SIZE                            (IRO[309].size)
#define XSTORM_ISCSI_LOCAL_MAC_ADDR5_OFFSET(pfId)                    (IRO[310].base + ((pfId) * IRO[310].m1))
#define XSTORM_ISCSI_LOCAL_MAC_ADDR5_SIZE                            (IRO[310].size)
#define XSTORM_ISCSI_LOCAL_VLAN_OFFSET(pfId)                         (IRO[311].base + ((pfId) * IRO[311].m1))
#define XSTORM_ISCSI_LOCAL_VLAN_SIZE                                 (IRO[311].size)
#define CSTORM_ISCSI_PAGE_SIZE_OFFSET(pfId)                          (IRO[312].base + ((pfId) * IRO[312].m1))
#define CSTORM_ISCSI_PAGE_SIZE_SIZE                                  (IRO[312].size)
#define CSTORM_ISCSI_PAGE_SIZE_LOG_OFFSET(pfId)                      (IRO[313].base + ((pfId) * IRO[313].m1))
#define CSTORM_ISCSI_PAGE_SIZE_LOG_SIZE                              (IRO[313].size)
#define CSTORM_ISCSI_NUM_OF_TASKS_OFFSET(pfId)                       (IRO[314].base + ((pfId) * IRO[314].m1))
#define CSTORM_ISCSI_NUM_OF_TASKS_SIZE                               (IRO[314].size)
#define CSTORM_ISCSI_EQ_PROD_OFFSET(pfId,iscsiEqId)                  (IRO[315].base + ((pfId) * IRO[315].m1) + ((iscsiEqId) * IRO[315].m2))
#define CSTORM_ISCSI_EQ_PROD_SIZE                                    (IRO[315].size)
#define CSTORM_ISCSI_EQ_CONS_OFFSET(pfId,iscsiEqId)                  (IRO[316].base + ((pfId) * IRO[316].m1) + ((iscsiEqId) * IRO[316].m2))
#define CSTORM_ISCSI_EQ_CONS_SIZE                                    (IRO[316].size)
#define CSTORM_ISCSI_EQ_NEXT_PAGE_ADDR_OFFSET(pfId,iscsiEqId)        (IRO[317].base + ((pfId) * IRO[317].m1) + ((iscsiEqId) * IRO[317].m2))
#define CSTORM_ISCSI_EQ_NEXT_PAGE_ADDR_SIZE                          (IRO[317].size)
#define CSTORM_ISCSI_EQ_NEXT_EQE_ADDR_OFFSET(pfId,iscsiEqId)         (IRO[318].base + ((pfId) * IRO[318].m1) + ((iscsiEqId) * IRO[318].m2))
#define CSTORM_ISCSI_EQ_NEXT_EQE_ADDR_SIZE                           (IRO[318].size)
#define CSTORM_ISCSI_EQ_NEXT_PAGE_ADDR_VALID_OFFSET(pfId,iscsiEqId)  (IRO[319].base + ((pfId) * IRO[319].m1) + ((iscsiEqId) * IRO[319].m2))
#define CSTORM_ISCSI_EQ_NEXT_PAGE_ADDR_VALID_SIZE                    (IRO[319].size)
#define CSTORM_ISCSI_EQ_SB_NUM_OFFSET(pfId,iscsiEqId)                (IRO[320].base + ((pfId) * IRO[320].m1) + ((iscsiEqId) * IRO[320].m2))
#define CSTORM_ISCSI_EQ_SB_NUM_SIZE                                  (IRO[320].size)
#define CSTORM_ISCSI_EQ_SB_INDEX_OFFSET(pfId,iscsiEqId)              (IRO[321].base + ((pfId) * IRO[321].m1) + ((iscsiEqId) * IRO[321].m2))
#define CSTORM_ISCSI_EQ_SB_INDEX_SIZE                                (IRO[321].size)
#define CSTORM_ISCSI_HQ_SIZE_OFFSET(pfId)                            (IRO[322].base + ((pfId) * IRO[322].m1))
#define CSTORM_ISCSI_HQ_SIZE_SIZE                                    (IRO[322].size)
#define CSTORM_ISCSI_CQ_SIZE_OFFSET(pfId)                            (IRO[323].base + ((pfId) * IRO[323].m1))
#define CSTORM_ISCSI_CQ_SIZE_SIZE                                    (IRO[323].size)
#define CSTORM_ISCSI_CQ_SQN_SIZE_OFFSET(pfId)                        (IRO[324].base + ((pfId) * IRO[324].m1))
#define CSTORM_ISCSI_CQ_SQN_SIZE_SIZE                                (IRO[324].size)
#define USTORM_FCOE_EQ_PROD_OFFSET(pfId)                             (IRO[325].base + ((pfId) * IRO[325].m1))
#define USTORM_FCOE_EQ_PROD_SIZE                                     (IRO[325].size)
#define USTORM_FCOE_TIMER_PARAM_OFFSET                               (IRO[326].base)
#define USTORM_FCOE_TIMER_PARAM_SIZE                                 (IRO[326].size)
#define USTORM_TIMER_ARRAY_OFFSET                                    (IRO[327].base)
#define USTORM_TIMER_ARRAY_SIZE                                      (IRO[327].size)
#define USTORM_STAT_FC_CRC_CNT_OFFSET                                (IRO[328].base)
#define USTORM_STAT_FC_CRC_CNT_SIZE                                  (IRO[328].size)
#define USTORM_STAT_EOFA_DEL_CNT_OFFSET                              (IRO[329].base)
#define USTORM_STAT_EOFA_DEL_CNT_SIZE                                (IRO[329].size)
#define USTORM_STAT_MISS_FRAME_CNT_OFFSET                            (IRO[330].base)
#define USTORM_STAT_MISS_FRAME_CNT_SIZE                              (IRO[330].size)
#define USTORM_STAT_SEQ_TIMEOUT_CNT_OFFSET                           (IRO[331].base)
#define USTORM_STAT_SEQ_TIMEOUT_CNT_SIZE                             (IRO[331].size)
#define USTORM_STAT_DROP_SEQ_CNT_OFFSET                              (IRO[332].base)
#define USTORM_STAT_DROP_SEQ_CNT_SIZE                                (IRO[332].size)
#define USTORM_STAT_FCOE_RX_DROP_PKT_CNT_OFFSET                      (IRO[333].base)
#define USTORM_STAT_FCOE_RX_DROP_PKT_CNT_SIZE                        (IRO[333].size)
#define USTORM_STAT_FCP_RX_PKT_CNT_OFFSET                            (IRO[334].base)
#define USTORM_STAT_FCP_RX_PKT_CNT_SIZE                              (IRO[334].size)
#define USTORM_STAT_OFFSET                                           (IRO[335].base)
#define USTORM_STAT_SIZE                                             (IRO[335].size)
#define USTORM_DEBUG_DROP_PKT_CNT_OFFSET                             (IRO[336].base)
#define USTORM_DEBUG_DROP_PKT_CNT_SIZE                               (IRO[336].size)
#define USTORM_DEBUG_OFFSET                                          (IRO[337].base)
#define USTORM_DEBUG_SIZE                                            (IRO[337].size)
#define USTORM_CACHED_TCE_MNG_INFO_DWORD_ONE_OFFSET(cached_tbl_size) (IRO[338].base + ((cached_tbl_size) * IRO[338].m1))
#define USTORM_CACHED_TCE_MNG_INFO_DWORD_ONE_SIZE                    (IRO[338].size)
#define USTORM_CACHED_TCE_MNG_INFO_DWORD_TWO_OFFSET(cached_tbl_size) (IRO[339].base + ((cached_tbl_size) * IRO[339].m1))
#define USTORM_CACHED_TCE_MNG_INFO_DWORD_TWO_SIZE                    (IRO[339].size)
#define USTORM_CACHED_TCE_ENTRY_TCE_OFFSET                           (IRO[340].base)
#define USTORM_CACHED_TCE_ENTRY_TCE_SIZE                             (IRO[340].size)
#define USTORM_CACHED_TCE_ENTRY_MNG_INFO_OFFSET                      (IRO[341].base)
#define USTORM_CACHED_TCE_ENTRY_MNG_INFO_SIZE                        (IRO[341].size)
#define USTORM_FCOE_CACHED_TCE_TBL_BIT_MAP_OFFSET                    (IRO[342].base)
#define USTORM_FCOE_CACHED_TCE_TBL_BIT_MAP_SIZE                      (IRO[342].size)
#define USTORM_DEBUG_CACHED_TCE_WAIT_4_BD_READ_OFFSET                (IRO[343].base)
#define USTORM_DEBUG_CACHED_TCE_WAIT_4_BD_READ_SIZE                  (IRO[343].size)
#define USTORM_DEBUG_CACHED_TCE_WAKE_ANOTHER_THREAD_DATA_OFFSET      (IRO[344].base)
#define USTORM_DEBUG_CACHED_TCE_WAKE_ANOTHER_THREAD_DATA_SIZE        (IRO[344].size)
#define USTORM_DEBUG_CACHED_TCE_WAKE_ANOTHER_THREAD_NON_DATA_OFFSET  (IRO[345].base)
#define USTORM_DEBUG_CACHED_TCE_WAKE_ANOTHER_THREAD_NON_DATA_SIZE    (IRO[345].size)
#define USTORM_DEBUG_CACHED_TCE_WAKE_ANOTHER_THREAD_ERR_OFFSET       (IRO[346].base)
#define USTORM_DEBUG_CACHED_TCE_WAKE_ANOTHER_THREAD_ERR_SIZE         (IRO[346].size)
#define USTORM_DEBUG_CACHED_TCE_GLOBAL_TIMER_TASK_IN_USE_OFFSET      (IRO[347].base)
#define USTORM_DEBUG_CACHED_TCE_GLOBAL_TIMER_TASK_IN_USE_SIZE        (IRO[347].size)
#define USTORM_DEBUG_CACHED_TCE_DEL_CACHED_TASK_OFFSET               (IRO[348].base)
#define USTORM_DEBUG_CACHED_TCE_DEL_CACHED_TASK_SIZE                 (IRO[348].size)
#define USTORM_DEBUG_CACHED_TCE_SILENT_DROP_CACHED_TASK_OFFSET       (IRO[349].base)
#define USTORM_DEBUG_CACHED_TCE_SILENT_DROP_CACHED_TASK_SIZE         (IRO[349].size)
#define USTORM_DEBUG_CACHED_TCE_OFFSET                               (IRO[350].base)
#define USTORM_DEBUG_CACHED_TCE_SIZE                                 (IRO[350].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_SEQ_CNT_ON_DROP_OFFSET          (IRO[351].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_SEQ_CNT_ON_DROP_SIZE            (IRO[351].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_SEQ_CNT_ON_CRC_ERROR_OFFSET     (IRO[352].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_SEQ_CNT_ON_CRC_ERROR_SIZE       (IRO[352].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_SEQ_CNT_ON_ERROR_OFFSET         (IRO[353].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_SEQ_CNT_ON_ERROR_SIZE           (IRO[353].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_PREVIOUS_THREAD_OFFSET          (IRO[354].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_PREVIOUS_THREAD_SIZE            (IRO[354].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_CRC_ERR_DETECT_DATA_IN_OFFSET   (IRO[355].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_CRC_ERR_DETECT_DATA_IN_SIZE     (IRO[355].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_CRC_ERR_DETECT_READ_TCE_OFFSET  (IRO[356].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_CRC_ERR_DETECT_READ_TCE_SIZE    (IRO[356].size)
#define USTORM_FCOE_DEBUG_CACHED_TCE_CRC_ERR_DETECT_DROP_ERR_OFFSET  (IRO[357].base)
#define USTORM_FCOE_DEBUG_CACHED_TCE_CRC_ERR_DETECT_DROP_ERR_SIZE    (IRO[357].size)
#define USTORM_FCOE_DEBUG_PARAMS_ERRORS_NUMBER_OFFSET                (IRO[358].base)
#define USTORM_FCOE_DEBUG_PARAMS_ERRORS_NUMBER_SIZE                  (IRO[358].size)
#define USTORM_FCOE_DEBUG_PARAMS_SILENT_DROP_NUMBER_OFFSET           (IRO[359].base)
#define USTORM_FCOE_DEBUG_PARAMS_SILENT_DROP_NUMBER_SIZE             (IRO[359].size)
#define USTORM_FCOE_DEBUG_PARAMS_SILENT_DROP_BITMAP_OFFSET           (IRO[360].base)
#define USTORM_FCOE_DEBUG_PARAMS_SILENT_DROP_BITMAP_SIZE             (IRO[360].size)
#define USTORM_FCOE_DEBUG_PARAMS_ENABLE_CONN_RACE_OFFSET             (IRO[361].base)
#define USTORM_FCOE_DEBUG_PARAMS_ENABLE_CONN_RACE_SIZE               (IRO[361].size)
#define USTORM_FCOE_DEBUG_PARAMS_TASK_IN_USE_OFFSET                  (IRO[362].base)
#define USTORM_FCOE_DEBUG_PARAMS_TASK_IN_USE_SIZE                    (IRO[362].size)
#define USTORM_FCOE_DEBUG_PARAMS_CRC_ERROR_TASK_IN_USE_OFFSET        (IRO[363].base)
#define USTORM_FCOE_DEBUG_PARAMS_CRC_ERROR_TASK_IN_USE_SIZE          (IRO[363].size)
#define XSTORM_FCOE_TIMER_PARAM_OFFSET                               (IRO[364].base)
#define XSTORM_FCOE_TIMER_PARAM_SIZE                                 (IRO[364].size)
#define XSTORM_TIMER_ARRAY_OFFSET                                    (IRO[365].base)
#define XSTORM_TIMER_ARRAY_SIZE                                      (IRO[365].size)
#define XSTORM_STAT_FCOE_TX_PKT_CNT_OFFSET                           (IRO[366].base)
#define XSTORM_STAT_FCOE_TX_PKT_CNT_SIZE                             (IRO[366].size)
#define XSTORM_STAT_FCOE_TX_BYTE_CNT_OFFSET                          (IRO[367].base)
#define XSTORM_STAT_FCOE_TX_BYTE_CNT_SIZE                            (IRO[367].size)
#define XSTORM_STAT_FCP_TX_PKT_CNT_OFFSET                            (IRO[368].base)
#define XSTORM_STAT_FCP_TX_PKT_CNT_SIZE                              (IRO[368].size)
#define XSTORM_STAT_OFFSET                                           (IRO[369].base)
#define XSTORM_STAT_SIZE                                             (IRO[369].size)
#define XSTORM_DEBUG_ABTS_BLOCK_SQ_CNT_OFFSET                        (IRO[370].base)
#define XSTORM_DEBUG_ABTS_BLOCK_SQ_CNT_SIZE                          (IRO[370].size)
#define XSTORM_DEBUG_CLEANUP_BLOCK_SQ_CNT_OFFSET                     (IRO[371].base)
#define XSTORM_DEBUG_CLEANUP_BLOCK_SQ_CNT_SIZE                       (IRO[371].size)
#define XSTORM_DEBUG_OFFSET                                          (IRO[372].base)
#define XSTORM_DEBUG_SIZE                                            (IRO[372].size)
#define TSTORM_STAT_FCOE_VER_CNT_OFFSET                              (IRO[373].base)
#define TSTORM_STAT_FCOE_VER_CNT_SIZE                                (IRO[373].size)
#define TSTORM_STAT_FCOE_RX_PKT_CNT_OFFSET                           (IRO[374].base)
#define TSTORM_STAT_FCOE_RX_PKT_CNT_SIZE                             (IRO[374].size)
#define TSTORM_STAT_FCOE_RX_BYTE_CNT_OFFSET                          (IRO[375].base)
#define TSTORM_STAT_FCOE_RX_BYTE_CNT_SIZE                            (IRO[375].size)
#define TSTORM_STAT_FCOE_RX_DROP_PKT_CNT_OFFSET                      (IRO[376].base)
#define TSTORM_STAT_FCOE_RX_DROP_PKT_CNT_SIZE                        (IRO[376].size)
#define TSTORM_STAT_OFFSET                                           (IRO[377].base)
#define TSTORM_STAT_SIZE                                             (IRO[377].size)
#define TSTORM_PORT_DEBUG_WAIT_FOR_YOUR_TURN_SP_CNT_OFFSET           (IRO[378].base)
#define TSTORM_PORT_DEBUG_WAIT_FOR_YOUR_TURN_SP_CNT_SIZE             (IRO[378].size)
#define TSTORM_PORT_DEBUG_AFEX_ERROR_PACKETS_OFFSET                  (IRO[379].base)
#define TSTORM_PORT_DEBUG_AFEX_ERROR_PACKETS_SIZE                    (IRO[379].size)
#define TSTORM_PORT_DEBUG_OFFSET                                     (IRO[380].base)
#define TSTORM_PORT_DEBUG_SIZE                                       (IRO[380].size)
#define TSTORM_REORDER_DATA_OFFSET                                   (IRO[381].base)
#define TSTORM_REORDER_DATA_SIZE                                     (IRO[381].size)
#define TSTORM_REORDER_WAITING_TABLE_OFFSET                          (IRO[382].base)
#define TSTORM_REORDER_WAITING_TABLE_SIZE                            (IRO[382].size)
#define TSTORM_WAITING_LIST_SIZE                                     (IRO[383].base)
#define TSTORM_REORDER_WAITING_ENTRY_OFFSET                          (IRO[384].base)
#define TSTORM_REORDER_WAITING_ENTRY_SIZE                            (IRO[384].size)

#define NUM_OF_INT_OFFSET_MACROS 385

#endif // __577XX_INT_OFFSETS__
