/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*	Copyright (c) 1983, 1984, 1985, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved	*/

/*
 * Portions of this source code were derived from Berkeley 4.3 BSD
 * under license from the Regents of the University of California.
 */

#ifndef _SYS_DESDATA_H
#define	_SYS_DESDATA_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * softdesdata.c, Data for software implementation of DES
 */

/*
 * Lint can't handle static's in include files.
 * Complains "defined but not used" and then "used but not defined"
 */
#ifdef __lint
#define	static
#endif

/*
 * Permuted-choice 1 from the key bits
 * to yield C and D.
 * Note that bits 8,16... are left out:
 * They are intended for a parity check.
 * Table has been munged to be zero-origin
 */

const short	PC1_C[] = {
	57-1, 49-1, 41-1, 33-1, 25-1, 17-1,  9-1,
	1-1,  58-1, 50-1, 42-1, 34-1, 26-1, 18-1,
	10-1,  2-1, 59-1, 51-1, 43-1, 35-1, 27-1,
	19-1, 11-1,  3-1, 60-1, 52-1, 44-1, 36-1,
};

const short	PC1_D[] = {
	63-1, 55-1, 47-1, 39-1, 31-1, 23-1, 15-1,
	7-1,  62-1, 54-1, 46-1, 38-1, 30-1, 22-1,
	14-1,  6-1, 61-1, 53-1, 45-1, 37-1, 29-1,
	21-1, 13-1,  5-1, 28-1, 20-1, 12-1,  4-1,
};

/*
 * Sequence of shifts used for the key schedule.
 */
const char	shifts[] = {
	1-1, 1-1, 2-1, 2-1, 2-1, 2-1, 2-1, 2-1,
	1-1, 2-1, 2-1, 2-1, 2-1, 2-1, 2-1, 1-1,
};

/*
 * Permuted-choice 2, to pick out the bits from
 * the CD array that generate the key schedule.
 */
const	char	PC2_C[] = {
	14, 17, 11, 24, 1,  5,
	3,  28, 15, 6,  21, 10,
	23, 19, 12, 4,  26, 8,
	16, 7,  27, 20, 13, 2,
};

const	char	PC2_D[] = {
	41-28, 52-28, 31-28, 37-28, 47-28, 55-28,
	30-28, 40-28, 51-28, 45-28, 33-28, 48-28,
	44-28, 49-28, 39-28, 56-28, 34-28, 53-28,
	46-28, 42-28, 50-28, 36-28, 29-28, 32-28,
};

/*
 * Initial permutation
 */
const	short	IPtab[64] = {
	40-1,  8-1, 48-1, 16-1, 56-1, 24-1, 64-1, 32-1,
	39-1,  7-1, 47-1, 15-1, 55-1, 23-1, 63-1, 31-1,
	38-1,  6-1, 46-1, 14-1, 54-1, 22-1, 62-1, 30-1,
	37-1,  5-1, 45-1, 13-1, 53-1, 21-1, 61-1, 29-1,
	36-1,  4-1, 44-1, 12-1, 52-1, 20-1, 60-1, 28-1,
	35-1,  3-1, 43-1, 11-1, 51-1, 19-1, 59-1, 27-1,
	34-1,  2-1, 42-1, 10-1, 50-1, 18-1, 58-1, 26-1,
	33-1,  1-1, 41-1,  9-1, 49-1, 17-1, 57-1, 25-1,
};

/*
 * Final permutation
 */
const	short	FPtab[64] = {
	58-1, 50-1, 42-1, 34-1, 26-1, 18-1, 10-1,  2-1,
	60-1, 52-1, 44-1, 36-1, 28-1, 20-1, 12-1,  4-1,
	62-1, 54-1, 46-1, 38-1, 30-1, 22-1, 14-1,  6-1,
	64-1, 56-1, 48-1, 40-1, 32-1, 24-1, 16-1,  8-1,
	57-1, 49-1, 41-1, 33-1, 25-1, 17-1,  9-1,  1-1,
	59-1, 51-1, 43-1, 35-1, 27-1, 19-1, 11-1,  3-1,
	61-1, 53-1, 45-1, 37-1, 29-1, 21-1, 13-1,  5-1,
	63-1, 55-1, 47-1, 39-1, 31-1, 23-1, 15-1,  7-1,
};

/*
 * Mask bit selection table
 */
const	uint32_t longtab[32] = {
	0x80000000U,	0x40000000U,	0x20000000U,	0x10000000U,
	0x8000000U,	0x4000000U,	0x2000000U,	0x1000000U,
	0x800000U,	0x400000U,	0x200000U,	0x100000U,
	0x80000U,	0x40000U,	0x20000U,	0x10000U,
	0x8000U,	0x4000U,	0x2000U,	0x1000U,
	0x800U,		0x400U,		0x200U,		0x100U,
	0x80U,		0x40U,		0x20U,		0x10U,
	0x8U,		0x4U,		0x2U,		0x1U,
};

/*
 * Table to expand 32 bit (4 bytes of 8 bits) R value
 * to 48 bits (8 bytes of 6 bits)
 */
struct R_to_ER {
	uint32_t l0, l1;
};

const	struct R_to_ER R_to_ER_tab[4][256] = {
	{{ 0x00000000, 0x00000000, },	{ 0x00022000, 0x00000000, },
	{ 0x00040000, 0x00000000, },	{ 0x00062000, 0x00000000, },
	{ 0x00080000, 0x00000000, },	{ 0x000a2000, 0x00000000, },
	{ 0x000c0000, 0x00000000, },	{ 0x000e2000, 0x00000000, },
	{ 0x01100000, 0x00000000, },	{ 0x01122000, 0x00000000, },
	{ 0x01140000, 0x00000000, },	{ 0x01162000, 0x00000000, },
	{ 0x01180000, 0x00000000, },	{ 0x011a2000, 0x00000000, },
	{ 0x011c0000, 0x00000000, },	{ 0x011e2000, 0x00000000, },
	{ 0x02200000, 0x00000000, },	{ 0x02222000, 0x00000000, },
	{ 0x02240000, 0x00000000, },	{ 0x02262000, 0x00000000, },
	{ 0x02280000, 0x00000000, },	{ 0x022a2000, 0x00000000, },
	{ 0x022c0000, 0x00000000, },	{ 0x022e2000, 0x00000000, },
	{ 0x03300000, 0x00000000, },	{ 0x03322000, 0x00000000, },
	{ 0x03340000, 0x00000000, },	{ 0x03362000, 0x00000000, },
	{ 0x03380000, 0x00000000, },	{ 0x033a2000, 0x00000000, },
	{ 0x033c0000, 0x00000000, },	{ 0x033e2000, 0x00000000, },
	{ 0x04000000, 0x00000000, },	{ 0x04022000, 0x00000000, },
	{ 0x04040000, 0x00000000, },	{ 0x04062000, 0x00000000, },
	{ 0x04080000, 0x00000000, },	{ 0x040a2000, 0x00000000, },
	{ 0x040c0000, 0x00000000, },	{ 0x040e2000, 0x00000000, },
	{ 0x05100000, 0x00000000, },	{ 0x05122000, 0x00000000, },
	{ 0x05140000, 0x00000000, },	{ 0x05162000, 0x00000000, },
	{ 0x05180000, 0x00000000, },	{ 0x051a2000, 0x00000000, },
	{ 0x051c0000, 0x00000000, },	{ 0x051e2000, 0x00000000, },
	{ 0x06200000, 0x00000000, },	{ 0x06222000, 0x00000000, },
	{ 0x06240000, 0x00000000, },	{ 0x06262000, 0x00000000, },
	{ 0x06280000, 0x00000000, },	{ 0x062a2000, 0x00000000, },
	{ 0x062c0000, 0x00000000, },	{ 0x062e2000, 0x00000000, },
	{ 0x07300000, 0x00000000, },	{ 0x07322000, 0x00000000, },
	{ 0x07340000, 0x00000000, },	{ 0x07362000, 0x00000000, },
	{ 0x07380000, 0x00000000, },	{ 0x073a2000, 0x00000000, },
	{ 0x073c0000, 0x00000000, },	{ 0x073e2000, 0x00000000, },
	{ 0x08000000, 0x00000000, },	{ 0x08022000, 0x00000000, },
	{ 0x08040000, 0x00000000, },	{ 0x08062000, 0x00000000, },
	{ 0x08080000, 0x00000000, },	{ 0x080a2000, 0x00000000, },
	{ 0x080c0000, 0x00000000, },	{ 0x080e2000, 0x00000000, },
	{ 0x09100000, 0x00000000, },	{ 0x09122000, 0x00000000, },
	{ 0x09140000, 0x00000000, },	{ 0x09162000, 0x00000000, },
	{ 0x09180000, 0x00000000, },	{ 0x091a2000, 0x00000000, },
	{ 0x091c0000, 0x00000000, },	{ 0x091e2000, 0x00000000, },
	{ 0x0a200000, 0x00000000, },	{ 0x0a222000, 0x00000000, },
	{ 0x0a240000, 0x00000000, },	{ 0x0a262000, 0x00000000, },
	{ 0x0a280000, 0x00000000, },	{ 0x0a2a2000, 0x00000000, },
	{ 0x0a2c0000, 0x00000000, },	{ 0x0a2e2000, 0x00000000, },
	{ 0x0b300000, 0x00000000, },	{ 0x0b322000, 0x00000000, },
	{ 0x0b340000, 0x00000000, },	{ 0x0b362000, 0x00000000, },
	{ 0x0b380000, 0x00000000, },	{ 0x0b3a2000, 0x00000000, },
	{ 0x0b3c0000, 0x00000000, },	{ 0x0b3e2000, 0x00000000, },
	{ 0x0c000000, 0x00000000, },	{ 0x0c022000, 0x00000000, },
	{ 0x0c040000, 0x00000000, },	{ 0x0c062000, 0x00000000, },
	{ 0x0c080000, 0x00000000, },	{ 0x0c0a2000, 0x00000000, },
	{ 0x0c0c0000, 0x00000000, },	{ 0x0c0e2000, 0x00000000, },
	{ 0x0d100000, 0x00000000, },	{ 0x0d122000, 0x00000000, },
	{ 0x0d140000, 0x00000000, },	{ 0x0d162000, 0x00000000, },
	{ 0x0d180000, 0x00000000, },	{ 0x0d1a2000, 0x00000000, },
	{ 0x0d1c0000, 0x00000000, },	{ 0x0d1e2000, 0x00000000, },
	{ 0x0e200000, 0x00000000, },	{ 0x0e222000, 0x00000000, },
	{ 0x0e240000, 0x00000000, },	{ 0x0e262000, 0x00000000, },
	{ 0x0e280000, 0x00000000, },	{ 0x0e2a2000, 0x00000000, },
	{ 0x0e2c0000, 0x00000000, },	{ 0x0e2e2000, 0x00000000, },
	{ 0x0f300000, 0x00000000, },	{ 0x0f322000, 0x00000000, },
	{ 0x0f340000, 0x00000000, },	{ 0x0f362000, 0x00000000, },
	{ 0x0f380000, 0x00000000, },	{ 0x0f3a2000, 0x00000000, },
	{ 0x0f3c0000, 0x00000000, },	{ 0x0f3e2000, 0x00000000, },
	{ 0x10000000, 0x00000001, },	{ 0x10022000, 0x00000001, },
	{ 0x10040000, 0x00000001, },	{ 0x10062000, 0x00000001, },
	{ 0x10080000, 0x00000001, },	{ 0x100a2000, 0x00000001, },
	{ 0x100c0000, 0x00000001, },	{ 0x100e2000, 0x00000001, },
	{ 0x11100000, 0x00000001, },	{ 0x11122000, 0x00000001, },
	{ 0x11140000, 0x00000001, },	{ 0x11162000, 0x00000001, },
	{ 0x11180000, 0x00000001, },	{ 0x111a2000, 0x00000001, },
	{ 0x111c0000, 0x00000001, },	{ 0x111e2000, 0x00000001, },
	{ 0x12200000, 0x00000001, },	{ 0x12222000, 0x00000001, },
	{ 0x12240000, 0x00000001, },	{ 0x12262000, 0x00000001, },
	{ 0x12280000, 0x00000001, },	{ 0x122a2000, 0x00000001, },
	{ 0x122c0000, 0x00000001, },	{ 0x122e2000, 0x00000001, },
	{ 0x13300000, 0x00000001, },	{ 0x13322000, 0x00000001, },
	{ 0x13340000, 0x00000001, },	{ 0x13362000, 0x00000001, },
	{ 0x13380000, 0x00000001, },	{ 0x133a2000, 0x00000001, },
	{ 0x133c0000, 0x00000001, },	{ 0x133e2000, 0x00000001, },
	{ 0x14000000, 0x00000001, },	{ 0x14022000, 0x00000001, },
	{ 0x14040000, 0x00000001, },	{ 0x14062000, 0x00000001, },
	{ 0x14080000, 0x00000001, },	{ 0x140a2000, 0x00000001, },
	{ 0x140c0000, 0x00000001, },	{ 0x140e2000, 0x00000001, },
	{ 0x15100000, 0x00000001, },	{ 0x15122000, 0x00000001, },
	{ 0x15140000, 0x00000001, },	{ 0x15162000, 0x00000001, },
	{ 0x15180000, 0x00000001, },	{ 0x151a2000, 0x00000001, },
	{ 0x151c0000, 0x00000001, },	{ 0x151e2000, 0x00000001, },
	{ 0x16200000, 0x00000001, },	{ 0x16222000, 0x00000001, },
	{ 0x16240000, 0x00000001, },	{ 0x16262000, 0x00000001, },
	{ 0x16280000, 0x00000001, },	{ 0x162a2000, 0x00000001, },
	{ 0x162c0000, 0x00000001, },	{ 0x162e2000, 0x00000001, },
	{ 0x17300000, 0x00000001, },	{ 0x17322000, 0x00000001, },
	{ 0x17340000, 0x00000001, },	{ 0x17362000, 0x00000001, },
	{ 0x17380000, 0x00000001, },	{ 0x173a2000, 0x00000001, },
	{ 0x173c0000, 0x00000001, },	{ 0x173e2000, 0x00000001, },
	{ 0x18000000, 0x00000001, },	{ 0x18022000, 0x00000001, },
	{ 0x18040000, 0x00000001, },	{ 0x18062000, 0x00000001, },
	{ 0x18080000, 0x00000001, },	{ 0x180a2000, 0x00000001, },
	{ 0x180c0000, 0x00000001, },	{ 0x180e2000, 0x00000001, },
	{ 0x19100000, 0x00000001, },	{ 0x19122000, 0x00000001, },
	{ 0x19140000, 0x00000001, },	{ 0x19162000, 0x00000001, },
	{ 0x19180000, 0x00000001, },	{ 0x191a2000, 0x00000001, },
	{ 0x191c0000, 0x00000001, },	{ 0x191e2000, 0x00000001, },
	{ 0x1a200000, 0x00000001, },	{ 0x1a222000, 0x00000001, },
	{ 0x1a240000, 0x00000001, },	{ 0x1a262000, 0x00000001, },
	{ 0x1a280000, 0x00000001, },	{ 0x1a2a2000, 0x00000001, },
	{ 0x1a2c0000, 0x00000001, },	{ 0x1a2e2000, 0x00000001, },
	{ 0x1b300000, 0x00000001, },	{ 0x1b322000, 0x00000001, },
	{ 0x1b340000, 0x00000001, },	{ 0x1b362000, 0x00000001, },
	{ 0x1b380000, 0x00000001, },	{ 0x1b3a2000, 0x00000001, },
	{ 0x1b3c0000, 0x00000001, },	{ 0x1b3e2000, 0x00000001, },
	{ 0x1c000000, 0x00000001, },	{ 0x1c022000, 0x00000001, },
	{ 0x1c040000, 0x00000001, },	{ 0x1c062000, 0x00000001, },
	{ 0x1c080000, 0x00000001, },	{ 0x1c0a2000, 0x00000001, },
	{ 0x1c0c0000, 0x00000001, },	{ 0x1c0e2000, 0x00000001, },
	{ 0x1d100000, 0x00000001, },	{ 0x1d122000, 0x00000001, },
	{ 0x1d140000, 0x00000001, },	{ 0x1d162000, 0x00000001, },
	{ 0x1d180000, 0x00000001, },	{ 0x1d1a2000, 0x00000001, },
	{ 0x1d1c0000, 0x00000001, },	{ 0x1d1e2000, 0x00000001, },
	{ 0x1e200000, 0x00000001, },	{ 0x1e222000, 0x00000001, },
	{ 0x1e240000, 0x00000001, },	{ 0x1e262000, 0x00000001, },
	{ 0x1e280000, 0x00000001, },	{ 0x1e2a2000, 0x00000001, },
	{ 0x1e2c0000, 0x00000001, },	{ 0x1e2e2000, 0x00000001, },
	{ 0x1f300000, 0x00000001, },	{ 0x1f322000, 0x00000001, },
	{ 0x1f340000, 0x00000001, },	{ 0x1f362000, 0x00000001, },
	{ 0x1f380000, 0x00000001, },	{ 0x1f3a2000, 0x00000001, },
	{ 0x1f3c0000, 0x00000001, },	{ 0x1f3e2000, 0x00000001, }, },

	{{ 0x00000000, 0x00000000, },	{ 0x00000002, 0x20000000, },
	{ 0x00000004, 0x00000000, },	{ 0x00000006, 0x20000000, },
	{ 0x00000008, 0x00000000, },	{ 0x0000000a, 0x20000000, },
	{ 0x0000000c, 0x00000000, },	{ 0x0000000e, 0x20000000, },
	{ 0x00000110, 0x00000000, },	{ 0x00000112, 0x20000000, },
	{ 0x00000114, 0x00000000, },	{ 0x00000116, 0x20000000, },
	{ 0x00000118, 0x00000000, },	{ 0x0000011a, 0x20000000, },
	{ 0x0000011c, 0x00000000, },	{ 0x0000011e, 0x20000000, },
	{ 0x00000220, 0x00000000, },	{ 0x00000222, 0x20000000, },
	{ 0x00000224, 0x00000000, },	{ 0x00000226, 0x20000000, },
	{ 0x00000228, 0x00000000, },	{ 0x0000022a, 0x20000000, },
	{ 0x0000022c, 0x00000000, },	{ 0x0000022e, 0x20000000, },
	{ 0x00000330, 0x00000000, },	{ 0x00000332, 0x20000000, },
	{ 0x00000334, 0x00000000, },	{ 0x00000336, 0x20000000, },
	{ 0x00000338, 0x00000000, },	{ 0x0000033a, 0x20000000, },
	{ 0x0000033c, 0x00000000, },	{ 0x0000033e, 0x20000000, },
	{ 0x00000400, 0x00000000, },	{ 0x00000402, 0x20000000, },
	{ 0x00000404, 0x00000000, },	{ 0x00000406, 0x20000000, },
	{ 0x00000408, 0x00000000, },	{ 0x0000040a, 0x20000000, },
	{ 0x0000040c, 0x00000000, },	{ 0x0000040e, 0x20000000, },
	{ 0x00000510, 0x00000000, },	{ 0x00000512, 0x20000000, },
	{ 0x00000514, 0x00000000, },	{ 0x00000516, 0x20000000, },
	{ 0x00000518, 0x00000000, },	{ 0x0000051a, 0x20000000, },
	{ 0x0000051c, 0x00000000, },	{ 0x0000051e, 0x20000000, },
	{ 0x00000620, 0x00000000, },	{ 0x00000622, 0x20000000, },
	{ 0x00000624, 0x00000000, },	{ 0x00000626, 0x20000000, },
	{ 0x00000628, 0x00000000, },	{ 0x0000062a, 0x20000000, },
	{ 0x0000062c, 0x00000000, },	{ 0x0000062e, 0x20000000, },
	{ 0x00000730, 0x00000000, },	{ 0x00000732, 0x20000000, },
	{ 0x00000734, 0x00000000, },	{ 0x00000736, 0x20000000, },
	{ 0x00000738, 0x00000000, },	{ 0x0000073a, 0x20000000, },
	{ 0x0000073c, 0x00000000, },	{ 0x0000073e, 0x20000000, },
	{ 0x00000800, 0x00000000, },	{ 0x00000802, 0x20000000, },
	{ 0x00000804, 0x00000000, },	{ 0x00000806, 0x20000000, },
	{ 0x00000808, 0x00000000, },	{ 0x0000080a, 0x20000000, },
	{ 0x0000080c, 0x00000000, },	{ 0x0000080e, 0x20000000, },
	{ 0x00000910, 0x00000000, },	{ 0x00000912, 0x20000000, },
	{ 0x00000914, 0x00000000, },	{ 0x00000916, 0x20000000, },
	{ 0x00000918, 0x00000000, },	{ 0x0000091a, 0x20000000, },
	{ 0x0000091c, 0x00000000, },	{ 0x0000091e, 0x20000000, },
	{ 0x00000a20, 0x00000000, },	{ 0x00000a22, 0x20000000, },
	{ 0x00000a24, 0x00000000, },	{ 0x00000a26, 0x20000000, },
	{ 0x00000a28, 0x00000000, },	{ 0x00000a2a, 0x20000000, },
	{ 0x00000a2c, 0x00000000, },	{ 0x00000a2e, 0x20000000, },
	{ 0x00000b30, 0x00000000, },	{ 0x00000b32, 0x20000000, },
	{ 0x00000b34, 0x00000000, },	{ 0x00000b36, 0x20000000, },
	{ 0x00000b38, 0x00000000, },	{ 0x00000b3a, 0x20000000, },
	{ 0x00000b3c, 0x00000000, },	{ 0x00000b3e, 0x20000000, },
	{ 0x00000c00, 0x00000000, },	{ 0x00000c02, 0x20000000, },
	{ 0x00000c04, 0x00000000, },	{ 0x00000c06, 0x20000000, },
	{ 0x00000c08, 0x00000000, },	{ 0x00000c0a, 0x20000000, },
	{ 0x00000c0c, 0x00000000, },	{ 0x00000c0e, 0x20000000, },
	{ 0x00000d10, 0x00000000, },	{ 0x00000d12, 0x20000000, },
	{ 0x00000d14, 0x00000000, },	{ 0x00000d16, 0x20000000, },
	{ 0x00000d18, 0x00000000, },	{ 0x00000d1a, 0x20000000, },
	{ 0x00000d1c, 0x00000000, },	{ 0x00000d1e, 0x20000000, },
	{ 0x00000e20, 0x00000000, },	{ 0x00000e22, 0x20000000, },
	{ 0x00000e24, 0x00000000, },	{ 0x00000e26, 0x20000000, },
	{ 0x00000e28, 0x00000000, },	{ 0x00000e2a, 0x20000000, },
	{ 0x00000e2c, 0x00000000, },	{ 0x00000e2e, 0x20000000, },
	{ 0x00000f30, 0x00000000, },	{ 0x00000f32, 0x20000000, },
	{ 0x00000f34, 0x00000000, },	{ 0x00000f36, 0x20000000, },
	{ 0x00000f38, 0x00000000, },	{ 0x00000f3a, 0x20000000, },
	{ 0x00000f3c, 0x00000000, },	{ 0x00000f3e, 0x20000000, },
	{ 0x00011000, 0x00000000, },	{ 0x00011002, 0x20000000, },
	{ 0x00011004, 0x00000000, },	{ 0x00011006, 0x20000000, },
	{ 0x00011008, 0x00000000, },	{ 0x0001100a, 0x20000000, },
	{ 0x0001100c, 0x00000000, },	{ 0x0001100e, 0x20000000, },
	{ 0x00011110, 0x00000000, },	{ 0x00011112, 0x20000000, },
	{ 0x00011114, 0x00000000, },	{ 0x00011116, 0x20000000, },
	{ 0x00011118, 0x00000000, },	{ 0x0001111a, 0x20000000, },
	{ 0x0001111c, 0x00000000, },	{ 0x0001111e, 0x20000000, },
	{ 0x00011220, 0x00000000, },	{ 0x00011222, 0x20000000, },
	{ 0x00011224, 0x00000000, },	{ 0x00011226, 0x20000000, },
	{ 0x00011228, 0x00000000, },	{ 0x0001122a, 0x20000000, },
	{ 0x0001122c, 0x00000000, },	{ 0x0001122e, 0x20000000, },
	{ 0x00011330, 0x00000000, },	{ 0x00011332, 0x20000000, },
	{ 0x00011334, 0x00000000, },	{ 0x00011336, 0x20000000, },
	{ 0x00011338, 0x00000000, },	{ 0x0001133a, 0x20000000, },
	{ 0x0001133c, 0x00000000, },	{ 0x0001133e, 0x20000000, },
	{ 0x00011400, 0x00000000, },	{ 0x00011402, 0x20000000, },
	{ 0x00011404, 0x00000000, },	{ 0x00011406, 0x20000000, },
	{ 0x00011408, 0x00000000, },	{ 0x0001140a, 0x20000000, },
	{ 0x0001140c, 0x00000000, },	{ 0x0001140e, 0x20000000, },
	{ 0x00011510, 0x00000000, },	{ 0x00011512, 0x20000000, },
	{ 0x00011514, 0x00000000, },	{ 0x00011516, 0x20000000, },
	{ 0x00011518, 0x00000000, },	{ 0x0001151a, 0x20000000, },
	{ 0x0001151c, 0x00000000, },	{ 0x0001151e, 0x20000000, },
	{ 0x00011620, 0x00000000, },	{ 0x00011622, 0x20000000, },
	{ 0x00011624, 0x00000000, },	{ 0x00011626, 0x20000000, },
	{ 0x00011628, 0x00000000, },	{ 0x0001162a, 0x20000000, },
	{ 0x0001162c, 0x00000000, },	{ 0x0001162e, 0x20000000, },
	{ 0x00011730, 0x00000000, },	{ 0x00011732, 0x20000000, },
	{ 0x00011734, 0x00000000, },	{ 0x00011736, 0x20000000, },
	{ 0x00011738, 0x00000000, },	{ 0x0001173a, 0x20000000, },
	{ 0x0001173c, 0x00000000, },	{ 0x0001173e, 0x20000000, },
	{ 0x00011800, 0x00000000, },	{ 0x00011802, 0x20000000, },
	{ 0x00011804, 0x00000000, },	{ 0x00011806, 0x20000000, },
	{ 0x00011808, 0x00000000, },	{ 0x0001180a, 0x20000000, },
	{ 0x0001180c, 0x00000000, },	{ 0x0001180e, 0x20000000, },
	{ 0x00011910, 0x00000000, },	{ 0x00011912, 0x20000000, },
	{ 0x00011914, 0x00000000, },	{ 0x00011916, 0x20000000, },
	{ 0x00011918, 0x00000000, },	{ 0x0001191a, 0x20000000, },
	{ 0x0001191c, 0x00000000, },	{ 0x0001191e, 0x20000000, },
	{ 0x00011a20, 0x00000000, },	{ 0x00011a22, 0x20000000, },
	{ 0x00011a24, 0x00000000, },	{ 0x00011a26, 0x20000000, },
	{ 0x00011a28, 0x00000000, },	{ 0x00011a2a, 0x20000000, },
	{ 0x00011a2c, 0x00000000, },	{ 0x00011a2e, 0x20000000, },
	{ 0x00011b30, 0x00000000, },	{ 0x00011b32, 0x20000000, },
	{ 0x00011b34, 0x00000000, },	{ 0x00011b36, 0x20000000, },
	{ 0x00011b38, 0x00000000, },	{ 0x00011b3a, 0x20000000, },
	{ 0x00011b3c, 0x00000000, },	{ 0x00011b3e, 0x20000000, },
	{ 0x00011c00, 0x00000000, },	{ 0x00011c02, 0x20000000, },
	{ 0x00011c04, 0x00000000, },	{ 0x00011c06, 0x20000000, },
	{ 0x00011c08, 0x00000000, },	{ 0x00011c0a, 0x20000000, },
	{ 0x00011c0c, 0x00000000, },	{ 0x00011c0e, 0x20000000, },
	{ 0x00011d10, 0x00000000, },	{ 0x00011d12, 0x20000000, },
	{ 0x00011d14, 0x00000000, },	{ 0x00011d16, 0x20000000, },
	{ 0x00011d18, 0x00000000, },	{ 0x00011d1a, 0x20000000, },
	{ 0x00011d1c, 0x00000000, },	{ 0x00011d1e, 0x20000000, },
	{ 0x00011e20, 0x00000000, },	{ 0x00011e22, 0x20000000, },
	{ 0x00011e24, 0x00000000, },	{ 0x00011e26, 0x20000000, },
	{ 0x00011e28, 0x00000000, },	{ 0x00011e2a, 0x20000000, },
	{ 0x00011e2c, 0x00000000, },	{ 0x00011e2e, 0x20000000, },
	{ 0x00011f30, 0x00000000, },	{ 0x00011f32, 0x20000000, },
	{ 0x00011f34, 0x00000000, },	{ 0x00011f36, 0x20000000, },
	{ 0x00011f38, 0x00000000, },	{ 0x00011f3a, 0x20000000, },
	{ 0x00011f3c, 0x00000000, },	{ 0x00011f3e, 0x20000000, }, },

	{{ 0x00000000, 0x00000000, },	{ 0x00000000, 0x00022000, },
	{ 0x00000000, 0x00040000, },	{ 0x00000000, 0x00062000, },
	{ 0x00000000, 0x00080000, },	{ 0x00000000, 0x000a2000, },
	{ 0x00000000, 0x000c0000, },	{ 0x00000000, 0x000e2000, },
	{ 0x00000000, 0x01100000, },	{ 0x00000000, 0x01122000, },
	{ 0x00000000, 0x01140000, },	{ 0x00000000, 0x01162000, },
	{ 0x00000000, 0x01180000, },	{ 0x00000000, 0x011a2000, },
	{ 0x00000000, 0x011c0000, },	{ 0x00000000, 0x011e2000, },
	{ 0x00000000, 0x02200000, },	{ 0x00000000, 0x02222000, },
	{ 0x00000000, 0x02240000, },	{ 0x00000000, 0x02262000, },
	{ 0x00000000, 0x02280000, },	{ 0x00000000, 0x022a2000, },
	{ 0x00000000, 0x022c0000, },	{ 0x00000000, 0x022e2000, },
	{ 0x00000000, 0x03300000, },	{ 0x00000000, 0x03322000, },
	{ 0x00000000, 0x03340000, },	{ 0x00000000, 0x03362000, },
	{ 0x00000000, 0x03380000, },	{ 0x00000000, 0x033a2000, },
	{ 0x00000000, 0x033c0000, },	{ 0x00000000, 0x033e2000, },
	{ 0x00000000, 0x04000000, },	{ 0x00000000, 0x04022000, },
	{ 0x00000000, 0x04040000, },	{ 0x00000000, 0x04062000, },
	{ 0x00000000, 0x04080000, },	{ 0x00000000, 0x040a2000, },
	{ 0x00000000, 0x040c0000, },	{ 0x00000000, 0x040e2000, },
	{ 0x00000000, 0x05100000, },	{ 0x00000000, 0x05122000, },
	{ 0x00000000, 0x05140000, },	{ 0x00000000, 0x05162000, },
	{ 0x00000000, 0x05180000, },	{ 0x00000000, 0x051a2000, },
	{ 0x00000000, 0x051c0000, },	{ 0x00000000, 0x051e2000, },
	{ 0x00000000, 0x06200000, },	{ 0x00000000, 0x06222000, },
	{ 0x00000000, 0x06240000, },	{ 0x00000000, 0x06262000, },
	{ 0x00000000, 0x06280000, },	{ 0x00000000, 0x062a2000, },
	{ 0x00000000, 0x062c0000, },	{ 0x00000000, 0x062e2000, },
	{ 0x00000000, 0x07300000, },	{ 0x00000000, 0x07322000, },
	{ 0x00000000, 0x07340000, },	{ 0x00000000, 0x07362000, },
	{ 0x00000000, 0x07380000, },	{ 0x00000000, 0x073a2000, },
	{ 0x00000000, 0x073c0000, },	{ 0x00000000, 0x073e2000, },
	{ 0x00000000, 0x08000000, },	{ 0x00000000, 0x08022000, },
	{ 0x00000000, 0x08040000, },	{ 0x00000000, 0x08062000, },
	{ 0x00000000, 0x08080000, },	{ 0x00000000, 0x080a2000, },
	{ 0x00000000, 0x080c0000, },	{ 0x00000000, 0x080e2000, },
	{ 0x00000000, 0x09100000, },	{ 0x00000000, 0x09122000, },
	{ 0x00000000, 0x09140000, },	{ 0x00000000, 0x09162000, },
	{ 0x00000000, 0x09180000, },	{ 0x00000000, 0x091a2000, },
	{ 0x00000000, 0x091c0000, },	{ 0x00000000, 0x091e2000, },
	{ 0x00000000, 0x0a200000, },	{ 0x00000000, 0x0a222000, },
	{ 0x00000000, 0x0a240000, },	{ 0x00000000, 0x0a262000, },
	{ 0x00000000, 0x0a280000, },	{ 0x00000000, 0x0a2a2000, },
	{ 0x00000000, 0x0a2c0000, },	{ 0x00000000, 0x0a2e2000, },
	{ 0x00000000, 0x0b300000, },	{ 0x00000000, 0x0b322000, },
	{ 0x00000000, 0x0b340000, },	{ 0x00000000, 0x0b362000, },
	{ 0x00000000, 0x0b380000, },	{ 0x00000000, 0x0b3a2000, },
	{ 0x00000000, 0x0b3c0000, },	{ 0x00000000, 0x0b3e2000, },
	{ 0x00000000, 0x0c000000, },	{ 0x00000000, 0x0c022000, },
	{ 0x00000000, 0x0c040000, },	{ 0x00000000, 0x0c062000, },
	{ 0x00000000, 0x0c080000, },	{ 0x00000000, 0x0c0a2000, },
	{ 0x00000000, 0x0c0c0000, },	{ 0x00000000, 0x0c0e2000, },
	{ 0x00000000, 0x0d100000, },	{ 0x00000000, 0x0d122000, },
	{ 0x00000000, 0x0d140000, },	{ 0x00000000, 0x0d162000, },
	{ 0x00000000, 0x0d180000, },	{ 0x00000000, 0x0d1a2000, },
	{ 0x00000000, 0x0d1c0000, },	{ 0x00000000, 0x0d1e2000, },
	{ 0x00000000, 0x0e200000, },	{ 0x00000000, 0x0e222000, },
	{ 0x00000000, 0x0e240000, },	{ 0x00000000, 0x0e262000, },
	{ 0x00000000, 0x0e280000, },	{ 0x00000000, 0x0e2a2000, },
	{ 0x00000000, 0x0e2c0000, },	{ 0x00000000, 0x0e2e2000, },
	{ 0x00000000, 0x0f300000, },	{ 0x00000000, 0x0f322000, },
	{ 0x00000000, 0x0f340000, },	{ 0x00000000, 0x0f362000, },
	{ 0x00000000, 0x0f380000, },	{ 0x00000000, 0x0f3a2000, },
	{ 0x00000000, 0x0f3c0000, },	{ 0x00000000, 0x0f3e2000, },
	{ 0x00000001, 0x10000000, },	{ 0x00000001, 0x10022000, },
	{ 0x00000001, 0x10040000, },	{ 0x00000001, 0x10062000, },
	{ 0x00000001, 0x10080000, },	{ 0x00000001, 0x100a2000, },
	{ 0x00000001, 0x100c0000, },	{ 0x00000001, 0x100e2000, },
	{ 0x00000001, 0x11100000, },	{ 0x00000001, 0x11122000, },
	{ 0x00000001, 0x11140000, },	{ 0x00000001, 0x11162000, },
	{ 0x00000001, 0x11180000, },	{ 0x00000001, 0x111a2000, },
	{ 0x00000001, 0x111c0000, },	{ 0x00000001, 0x111e2000, },
	{ 0x00000001, 0x12200000, },	{ 0x00000001, 0x12222000, },
	{ 0x00000001, 0x12240000, },	{ 0x00000001, 0x12262000, },
	{ 0x00000001, 0x12280000, },	{ 0x00000001, 0x122a2000, },
	{ 0x00000001, 0x122c0000, },	{ 0x00000001, 0x122e2000, },
	{ 0x00000001, 0x13300000, },	{ 0x00000001, 0x13322000, },
	{ 0x00000001, 0x13340000, },	{ 0x00000001, 0x13362000, },
	{ 0x00000001, 0x13380000, },	{ 0x00000001, 0x133a2000, },
	{ 0x00000001, 0x133c0000, },	{ 0x00000001, 0x133e2000, },
	{ 0x00000001, 0x14000000, },	{ 0x00000001, 0x14022000, },
	{ 0x00000001, 0x14040000, },	{ 0x00000001, 0x14062000, },
	{ 0x00000001, 0x14080000, },	{ 0x00000001, 0x140a2000, },
	{ 0x00000001, 0x140c0000, },	{ 0x00000001, 0x140e2000, },
	{ 0x00000001, 0x15100000, },	{ 0x00000001, 0x15122000, },
	{ 0x00000001, 0x15140000, },	{ 0x00000001, 0x15162000, },
	{ 0x00000001, 0x15180000, },	{ 0x00000001, 0x151a2000, },
	{ 0x00000001, 0x151c0000, },	{ 0x00000001, 0x151e2000, },
	{ 0x00000001, 0x16200000, },	{ 0x00000001, 0x16222000, },
	{ 0x00000001, 0x16240000, },	{ 0x00000001, 0x16262000, },
	{ 0x00000001, 0x16280000, },	{ 0x00000001, 0x162a2000, },
	{ 0x00000001, 0x162c0000, },	{ 0x00000001, 0x162e2000, },
	{ 0x00000001, 0x17300000, },	{ 0x00000001, 0x17322000, },
	{ 0x00000001, 0x17340000, },	{ 0x00000001, 0x17362000, },
	{ 0x00000001, 0x17380000, },	{ 0x00000001, 0x173a2000, },
	{ 0x00000001, 0x173c0000, },	{ 0x00000001, 0x173e2000, },
	{ 0x00000001, 0x18000000, },	{ 0x00000001, 0x18022000, },
	{ 0x00000001, 0x18040000, },	{ 0x00000001, 0x18062000, },
	{ 0x00000001, 0x18080000, },	{ 0x00000001, 0x180a2000, },
	{ 0x00000001, 0x180c0000, },	{ 0x00000001, 0x180e2000, },
	{ 0x00000001, 0x19100000, },	{ 0x00000001, 0x19122000, },
	{ 0x00000001, 0x19140000, },	{ 0x00000001, 0x19162000, },
	{ 0x00000001, 0x19180000, },	{ 0x00000001, 0x191a2000, },
	{ 0x00000001, 0x191c0000, },	{ 0x00000001, 0x191e2000, },
	{ 0x00000001, 0x1a200000, },	{ 0x00000001, 0x1a222000, },
	{ 0x00000001, 0x1a240000, },	{ 0x00000001, 0x1a262000, },
	{ 0x00000001, 0x1a280000, },	{ 0x00000001, 0x1a2a2000, },
	{ 0x00000001, 0x1a2c0000, },	{ 0x00000001, 0x1a2e2000, },
	{ 0x00000001, 0x1b300000, },	{ 0x00000001, 0x1b322000, },
	{ 0x00000001, 0x1b340000, },	{ 0x00000001, 0x1b362000, },
	{ 0x00000001, 0x1b380000, },	{ 0x00000001, 0x1b3a2000, },
	{ 0x00000001, 0x1b3c0000, },	{ 0x00000001, 0x1b3e2000, },
	{ 0x00000001, 0x1c000000, },	{ 0x00000001, 0x1c022000, },
	{ 0x00000001, 0x1c040000, },	{ 0x00000001, 0x1c062000, },
	{ 0x00000001, 0x1c080000, },	{ 0x00000001, 0x1c0a2000, },
	{ 0x00000001, 0x1c0c0000, },	{ 0x00000001, 0x1c0e2000, },
	{ 0x00000001, 0x1d100000, },	{ 0x00000001, 0x1d122000, },
	{ 0x00000001, 0x1d140000, },	{ 0x00000001, 0x1d162000, },
	{ 0x00000001, 0x1d180000, },	{ 0x00000001, 0x1d1a2000, },
	{ 0x00000001, 0x1d1c0000, },	{ 0x00000001, 0x1d1e2000, },
	{ 0x00000001, 0x1e200000, },	{ 0x00000001, 0x1e222000, },
	{ 0x00000001, 0x1e240000, },	{ 0x00000001, 0x1e262000, },
	{ 0x00000001, 0x1e280000, },	{ 0x00000001, 0x1e2a2000, },
	{ 0x00000001, 0x1e2c0000, },	{ 0x00000001, 0x1e2e2000, },
	{ 0x00000001, 0x1f300000, },	{ 0x00000001, 0x1f322000, },
	{ 0x00000001, 0x1f340000, },	{ 0x00000001, 0x1f362000, },
	{ 0x00000001, 0x1f380000, },	{ 0x00000001, 0x1f3a2000, },
	{ 0x00000001, 0x1f3c0000, },	{ 0x00000001, 0x1f3e2000, }, },

	{{ 0x00000000, 0x00000000, },	{ 0x20000000, 0x00000002, },
	{ 0x00000000, 0x00000004, },	{ 0x20000000, 0x00000006, },
	{ 0x00000000, 0x00000008, },	{ 0x20000000, 0x0000000a, },
	{ 0x00000000, 0x0000000c, },	{ 0x20000000, 0x0000000e, },
	{ 0x00000000, 0x00000110, },	{ 0x20000000, 0x00000112, },
	{ 0x00000000, 0x00000114, },	{ 0x20000000, 0x00000116, },
	{ 0x00000000, 0x00000118, },	{ 0x20000000, 0x0000011a, },
	{ 0x00000000, 0x0000011c, },	{ 0x20000000, 0x0000011e, },
	{ 0x00000000, 0x00000220, },	{ 0x20000000, 0x00000222, },
	{ 0x00000000, 0x00000224, },	{ 0x20000000, 0x00000226, },
	{ 0x00000000, 0x00000228, },	{ 0x20000000, 0x0000022a, },
	{ 0x00000000, 0x0000022c, },	{ 0x20000000, 0x0000022e, },
	{ 0x00000000, 0x00000330, },	{ 0x20000000, 0x00000332, },
	{ 0x00000000, 0x00000334, },	{ 0x20000000, 0x00000336, },
	{ 0x00000000, 0x00000338, },	{ 0x20000000, 0x0000033a, },
	{ 0x00000000, 0x0000033c, },	{ 0x20000000, 0x0000033e, },
	{ 0x00000000, 0x00000400, },	{ 0x20000000, 0x00000402, },
	{ 0x00000000, 0x00000404, },	{ 0x20000000, 0x00000406, },
	{ 0x00000000, 0x00000408, },	{ 0x20000000, 0x0000040a, },
	{ 0x00000000, 0x0000040c, },	{ 0x20000000, 0x0000040e, },
	{ 0x00000000, 0x00000510, },	{ 0x20000000, 0x00000512, },
	{ 0x00000000, 0x00000514, },	{ 0x20000000, 0x00000516, },
	{ 0x00000000, 0x00000518, },	{ 0x20000000, 0x0000051a, },
	{ 0x00000000, 0x0000051c, },	{ 0x20000000, 0x0000051e, },
	{ 0x00000000, 0x00000620, },	{ 0x20000000, 0x00000622, },
	{ 0x00000000, 0x00000624, },	{ 0x20000000, 0x00000626, },
	{ 0x00000000, 0x00000628, },	{ 0x20000000, 0x0000062a, },
	{ 0x00000000, 0x0000062c, },	{ 0x20000000, 0x0000062e, },
	{ 0x00000000, 0x00000730, },	{ 0x20000000, 0x00000732, },
	{ 0x00000000, 0x00000734, },	{ 0x20000000, 0x00000736, },
	{ 0x00000000, 0x00000738, },	{ 0x20000000, 0x0000073a, },
	{ 0x00000000, 0x0000073c, },	{ 0x20000000, 0x0000073e, },
	{ 0x00000000, 0x00000800, },	{ 0x20000000, 0x00000802, },
	{ 0x00000000, 0x00000804, },	{ 0x20000000, 0x00000806, },
	{ 0x00000000, 0x00000808, },	{ 0x20000000, 0x0000080a, },
	{ 0x00000000, 0x0000080c, },	{ 0x20000000, 0x0000080e, },
	{ 0x00000000, 0x00000910, },	{ 0x20000000, 0x00000912, },
	{ 0x00000000, 0x00000914, },	{ 0x20000000, 0x00000916, },
	{ 0x00000000, 0x00000918, },	{ 0x20000000, 0x0000091a, },
	{ 0x00000000, 0x0000091c, },	{ 0x20000000, 0x0000091e, },
	{ 0x00000000, 0x00000a20, },	{ 0x20000000, 0x00000a22, },
	{ 0x00000000, 0x00000a24, },	{ 0x20000000, 0x00000a26, },
	{ 0x00000000, 0x00000a28, },	{ 0x20000000, 0x00000a2a, },
	{ 0x00000000, 0x00000a2c, },	{ 0x20000000, 0x00000a2e, },
	{ 0x00000000, 0x00000b30, },	{ 0x20000000, 0x00000b32, },
	{ 0x00000000, 0x00000b34, },	{ 0x20000000, 0x00000b36, },
	{ 0x00000000, 0x00000b38, },	{ 0x20000000, 0x00000b3a, },
	{ 0x00000000, 0x00000b3c, },	{ 0x20000000, 0x00000b3e, },
	{ 0x00000000, 0x00000c00, },	{ 0x20000000, 0x00000c02, },
	{ 0x00000000, 0x00000c04, },	{ 0x20000000, 0x00000c06, },
	{ 0x00000000, 0x00000c08, },	{ 0x20000000, 0x00000c0a, },
	{ 0x00000000, 0x00000c0c, },	{ 0x20000000, 0x00000c0e, },
	{ 0x00000000, 0x00000d10, },	{ 0x20000000, 0x00000d12, },
	{ 0x00000000, 0x00000d14, },	{ 0x20000000, 0x00000d16, },
	{ 0x00000000, 0x00000d18, },	{ 0x20000000, 0x00000d1a, },
	{ 0x00000000, 0x00000d1c, },	{ 0x20000000, 0x00000d1e, },
	{ 0x00000000, 0x00000e20, },	{ 0x20000000, 0x00000e22, },
	{ 0x00000000, 0x00000e24, },	{ 0x20000000, 0x00000e26, },
	{ 0x00000000, 0x00000e28, },	{ 0x20000000, 0x00000e2a, },
	{ 0x00000000, 0x00000e2c, },	{ 0x20000000, 0x00000e2e, },
	{ 0x00000000, 0x00000f30, },	{ 0x20000000, 0x00000f32, },
	{ 0x00000000, 0x00000f34, },	{ 0x20000000, 0x00000f36, },
	{ 0x00000000, 0x00000f38, },	{ 0x20000000, 0x00000f3a, },
	{ 0x00000000, 0x00000f3c, },	{ 0x20000000, 0x00000f3e, },
	{ 0x00000000, 0x00011000, },	{ 0x20000000, 0x00011002, },
	{ 0x00000000, 0x00011004, },	{ 0x20000000, 0x00011006, },
	{ 0x00000000, 0x00011008, },	{ 0x20000000, 0x0001100a, },
	{ 0x00000000, 0x0001100c, },	{ 0x20000000, 0x0001100e, },
	{ 0x00000000, 0x00011110, },	{ 0x20000000, 0x00011112, },
	{ 0x00000000, 0x00011114, },	{ 0x20000000, 0x00011116, },
	{ 0x00000000, 0x00011118, },	{ 0x20000000, 0x0001111a, },
	{ 0x00000000, 0x0001111c, },	{ 0x20000000, 0x0001111e, },
	{ 0x00000000, 0x00011220, },	{ 0x20000000, 0x00011222, },
	{ 0x00000000, 0x00011224, },	{ 0x20000000, 0x00011226, },
	{ 0x00000000, 0x00011228, },	{ 0x20000000, 0x0001122a, },
	{ 0x00000000, 0x0001122c, },	{ 0x20000000, 0x0001122e, },
	{ 0x00000000, 0x00011330, },	{ 0x20000000, 0x00011332, },
	{ 0x00000000, 0x00011334, },	{ 0x20000000, 0x00011336, },
	{ 0x00000000, 0x00011338, },	{ 0x20000000, 0x0001133a, },
	{ 0x00000000, 0x0001133c, },	{ 0x20000000, 0x0001133e, },
	{ 0x00000000, 0x00011400, },	{ 0x20000000, 0x00011402, },
	{ 0x00000000, 0x00011404, },	{ 0x20000000, 0x00011406, },
	{ 0x00000000, 0x00011408, },	{ 0x20000000, 0x0001140a, },
	{ 0x00000000, 0x0001140c, },	{ 0x20000000, 0x0001140e, },
	{ 0x00000000, 0x00011510, },	{ 0x20000000, 0x00011512, },
	{ 0x00000000, 0x00011514, },	{ 0x20000000, 0x00011516, },
	{ 0x00000000, 0x00011518, },	{ 0x20000000, 0x0001151a, },
	{ 0x00000000, 0x0001151c, },	{ 0x20000000, 0x0001151e, },
	{ 0x00000000, 0x00011620, },	{ 0x20000000, 0x00011622, },
	{ 0x00000000, 0x00011624, },	{ 0x20000000, 0x00011626, },
	{ 0x00000000, 0x00011628, },	{ 0x20000000, 0x0001162a, },
	{ 0x00000000, 0x0001162c, },	{ 0x20000000, 0x0001162e, },
	{ 0x00000000, 0x00011730, },	{ 0x20000000, 0x00011732, },
	{ 0x00000000, 0x00011734, },	{ 0x20000000, 0x00011736, },
	{ 0x00000000, 0x00011738, },	{ 0x20000000, 0x0001173a, },
	{ 0x00000000, 0x0001173c, },	{ 0x20000000, 0x0001173e, },
	{ 0x00000000, 0x00011800, },	{ 0x20000000, 0x00011802, },
	{ 0x00000000, 0x00011804, },	{ 0x20000000, 0x00011806, },
	{ 0x00000000, 0x00011808, },	{ 0x20000000, 0x0001180a, },
	{ 0x00000000, 0x0001180c, },	{ 0x20000000, 0x0001180e, },
	{ 0x00000000, 0x00011910, },	{ 0x20000000, 0x00011912, },
	{ 0x00000000, 0x00011914, },	{ 0x20000000, 0x00011916, },
	{ 0x00000000, 0x00011918, },	{ 0x20000000, 0x0001191a, },
	{ 0x00000000, 0x0001191c, },	{ 0x20000000, 0x0001191e, },
	{ 0x00000000, 0x00011a20, },	{ 0x20000000, 0x00011a22, },
	{ 0x00000000, 0x00011a24, },	{ 0x20000000, 0x00011a26, },
	{ 0x00000000, 0x00011a28, },	{ 0x20000000, 0x00011a2a, },
	{ 0x00000000, 0x00011a2c, },	{ 0x20000000, 0x00011a2e, },
	{ 0x00000000, 0x00011b30, },	{ 0x20000000, 0x00011b32, },
	{ 0x00000000, 0x00011b34, },	{ 0x20000000, 0x00011b36, },
	{ 0x00000000, 0x00011b38, },	{ 0x20000000, 0x00011b3a, },
	{ 0x00000000, 0x00011b3c, },	{ 0x20000000, 0x00011b3e, },
	{ 0x00000000, 0x00011c00, },	{ 0x20000000, 0x00011c02, },
	{ 0x00000000, 0x00011c04, },	{ 0x20000000, 0x00011c06, },
	{ 0x00000000, 0x00011c08, },	{ 0x20000000, 0x00011c0a, },
	{ 0x00000000, 0x00011c0c, },	{ 0x20000000, 0x00011c0e, },
	{ 0x00000000, 0x00011d10, },	{ 0x20000000, 0x00011d12, },
	{ 0x00000000, 0x00011d14, },	{ 0x20000000, 0x00011d16, },
	{ 0x00000000, 0x00011d18, },	{ 0x20000000, 0x00011d1a, },
	{ 0x00000000, 0x00011d1c, },	{ 0x20000000, 0x00011d1e, },
	{ 0x00000000, 0x00011e20, },	{ 0x20000000, 0x00011e22, },
	{ 0x00000000, 0x00011e24, },	{ 0x20000000, 0x00011e26, },
	{ 0x00000000, 0x00011e28, },	{ 0x20000000, 0x00011e2a, },
	{ 0x00000000, 0x00011e2c, },	{ 0x20000000, 0x00011e2e, },
	{ 0x00000000, 0x00011f30, },	{ 0x20000000, 0x00011f32, },
	{ 0x00000000, 0x00011f34, },	{ 0x20000000, 0x00011f36, },
	{ 0x00000000, 0x00011f38, },	{ 0x20000000, 0x00011f3a, },
	{ 0x00000000, 0x00011f3c, },	{ 0x20000000, 0x00011f3e, }, }
};

/*
 * The 8 selection functions.
 * 8 functions to map 6 bits to 64 bits
 */
const	uint32_t  S_tab[8][64] = {
	{
		0xe0000000U, 0x00000000U, 0x40000000U, 0xf0000000U,
		0xd0000000U, 0x70000000U, 0x10000000U, 0x40000000U,
		0x20000000U, 0xe0000000U, 0xf0000000U, 0x20000000U,
		0xb0000000U, 0xd0000000U, 0x80000000U, 0x10000000U,
		0x30000000U, 0xa0000000U, 0xa0000000U, 0x60000000U,
		0x60000000U, 0xc0000000U, 0xc0000000U, 0xb0000000U,
		0x50000000U, 0x90000000U, 0x90000000U, 0x50000000U,
		0x00000000U, 0x30000000U, 0x70000000U, 0x80000000U,
		0x40000000U, 0xf0000000U, 0x10000000U, 0xc0000000U,
		0xe0000000U, 0x80000000U, 0x80000000U, 0x20000000U,
		0xd0000000U, 0x40000000U, 0x60000000U, 0x90000000U,
		0x20000000U, 0x10000000U, 0xb0000000U, 0x70000000U,
		0xf0000000U, 0x50000000U, 0xc0000000U, 0xb0000000U,
		0x90000000U, 0x30000000U, 0x70000000U, 0xe0000000U,
		0x30000000U, 0xa0000000U, 0xa0000000U, 0x00000000U,
		0x50000000U, 0x60000000U, 0x00000000U, 0xd0000000U,
	},
	{
		0x0f000000U, 0x03000000U, 0x01000000U, 0x0d000000U,
		0x08000000U, 0x04000000U, 0x0e000000U, 0x07000000U,
		0x06000000U, 0x0f000000U, 0x0b000000U, 0x02000000U,
		0x03000000U, 0x08000000U, 0x04000000U, 0x0e000000U,
		0x09000000U, 0x0c000000U, 0x07000000U, 0x00000000U,
		0x02000000U, 0x01000000U, 0x0d000000U, 0x0a000000U,
		0x0c000000U, 0x06000000U, 0x00000000U, 0x09000000U,
		0x05000000U, 0x0b000000U, 0x0a000000U, 0x05000000U,
		0x00000000U, 0x0d000000U, 0x0e000000U, 0x08000000U,
		0x07000000U, 0x0a000000U, 0x0b000000U, 0x01000000U,
		0x0a000000U, 0x03000000U, 0x04000000U, 0x0f000000U,
		0x0d000000U, 0x04000000U, 0x01000000U, 0x02000000U,
		0x05000000U, 0x0b000000U, 0x08000000U, 0x06000000U,
		0x0c000000U, 0x07000000U, 0x06000000U, 0x0c000000U,
		0x09000000U, 0x00000000U, 0x03000000U, 0x05000000U,
		0x02000000U, 0x0e000000U, 0x0f000000U, 0x09000000U,
	},
	{
		0x00a00000U, 0x00d00000U, 0x00000000U, 0x00700000U,
		0x00900000U, 0x00000000U, 0x00e00000U, 0x00900000U,
		0x00600000U, 0x00300000U, 0x00300000U, 0x00400000U,
		0x00f00000U, 0x00600000U, 0x00500000U, 0x00a00000U,
		0x00100000U, 0x00200000U, 0x00d00000U, 0x00800000U,
		0x00c00000U, 0x00500000U, 0x00700000U, 0x00e00000U,
		0x00b00000U, 0x00c00000U, 0x00400000U, 0x00b00000U,
		0x00200000U, 0x00f00000U, 0x00800000U, 0x00100000U,
		0x00d00000U, 0x00100000U, 0x00600000U, 0x00a00000U,
		0x00400000U, 0x00d00000U, 0x00900000U, 0x00000000U,
		0x00800000U, 0x00600000U, 0x00f00000U, 0x00900000U,
		0x00300000U, 0x00800000U, 0x00000000U, 0x00700000U,
		0x00b00000U, 0x00400000U, 0x00100000U, 0x00f00000U,
		0x00200000U, 0x00e00000U, 0x00c00000U, 0x00300000U,
		0x00500000U, 0x00b00000U, 0x00a00000U, 0x00500000U,
		0x00e00000U, 0x00200000U, 0x00700000U, 0x00c00000U,
	},
	{
		0x00070000U, 0x000d0000U, 0x000d0000, 0x00080000U,
		0x000e0000U, 0x000b0000U, 0x00030000, 0x00050000U,
		0x00000000U, 0x00060000U, 0x00060000, 0x000f0000U,
		0x00090000U, 0x00000000U, 0x000a0000, 0x00030000U,
		0x00010000U, 0x00040000U, 0x00020000, 0x00070000U,
		0x00080000U, 0x00020000U, 0x00050000, 0x000c0000U,
		0x000b0000U, 0x00010000U, 0x000c0000, 0x000a0000U,
		0x00040000U, 0x000e0000U, 0x000f0000, 0x00090000U,
		0x000a0000U, 0x00030000U, 0x00060000, 0x000f0000U,
		0x00090000U, 0x00000000U, 0x00000000, 0x00060000U,
		0x000c0000U, 0x000a0000U, 0x000b0000, 0x00010000U,
		0x00070000U, 0x000d0000U, 0x000d0000, 0x00080000U,
		0x000f0000U, 0x00090000U, 0x00010000, 0x00040000U,
		0x00030000U, 0x00050000U, 0x000e0000, 0x000b0000U,
		0x00050000U, 0x000c0000U, 0x00020000, 0x00070000U,
		0x00080000U, 0x00020000U, 0x00040000, 0x000e0000U,
	},
	{
		0x00002000U, 0x0000e000U, 0x0000c000U, 0x0000b000U,
		0x00004000U, 0x00002000U, 0x00001000U, 0x0000c000U,
		0x00007000U, 0x00004000U, 0x0000a000U, 0x00007000U,
		0x0000b000U, 0x0000d000U, 0x00006000U, 0x00001000U,
		0x00008000U, 0x00005000U, 0x00005000U, 0x00000000U,
		0x00003000U, 0x0000f000U, 0x0000f000U, 0x0000a000U,
		0x0000d000U, 0x00003000U, 0x00000000U, 0x00009000U,
		0x0000e000U, 0x00008000U, 0x00009000U, 0x00006000U,
		0x00004000U, 0x0000b000U, 0x00002000U, 0x00008000U,
		0x00001000U, 0x0000c000U, 0x0000b000U, 0x00007000U,
		0x0000a000U, 0x00001000U, 0x0000d000U, 0x0000e000U,
		0x00007000U, 0x00002000U, 0x00008000U, 0x0000d000U,
		0x0000f000U, 0x00006000U, 0x00009000U, 0x0000f000U,
		0x0000c000U, 0x00000000U, 0x00005000U, 0x00009000U,
		0x00006000U, 0x0000a000U, 0x00003000U, 0x00004000U,
		0x00000000U, 0x00005000U, 0x0000e000U, 0x00003000U,
	},
	{
		0x00000c00U, 0x00000a00U, 0x00000100U, 0x00000f00U,
		0x00000a00U, 0x00000400U, 0x00000f00U, 0x00000200U,
		0x00000900U, 0x00000700U, 0x00000200U, 0x00000c00U,
		0x00000600U, 0x00000900U, 0x00000800U, 0x00000500U,
		0x00000000U, 0x00000600U, 0x00000d00U, 0x00000100U,
		0x00000300U, 0x00000d00U, 0x00000400U, 0x00000e00U,
		0x00000e00U, 0x00000000U, 0x00000700U, 0x00000b00U,
		0x00000500U, 0x00000300U, 0x00000b00U, 0x00000800U,
		0x00000900U, 0x00000400U, 0x00000e00U, 0x00000300U,
		0x00000f00U, 0x00000200U, 0x00000500U, 0x00000c00U,
		0x00000200U, 0x00000900U, 0x00000800U, 0x00000500U,
		0x00000c00U, 0x00000f00U, 0x00000300U, 0x00000a00U,
		0x00000700U, 0x00000b00U, 0x00000000U, 0x00000e00U,
		0x00000400U, 0x00000100U, 0x00000a00U, 0x00000700U,
		0x00000100U, 0x00000600U, 0x00000d00U, 0x00000000U,
		0x00000b00U, 0x00000800U, 0x00000600U, 0x00000d00U,
	},
	{
		0x00000040U, 0x000000d0U, 0x000000b0U, 0x00000000U,
		0x00000020U, 0x000000b0U, 0x000000e0U, 0x00000070U,
		0x000000f0U, 0x00000040U, 0x00000000U, 0x00000090U,
		0x00000080U, 0x00000010U, 0x000000d0U, 0x000000a0U,
		0x00000030U, 0x000000e0U, 0x000000c0U, 0x00000030U,
		0x00000090U, 0x00000050U, 0x00000070U, 0x000000c0U,
		0x00000050U, 0x00000020U, 0x000000a0U, 0x000000f0U,
		0x00000060U, 0x00000080U, 0x00000010U, 0x00000060U,
		0x00000010U, 0x00000060U, 0x00000040U, 0x000000b0U,
		0x000000b0U, 0x000000d0U, 0x000000d0U, 0x00000080U,
		0x000000c0U, 0x00000010U, 0x00000030U, 0x00000040U,
		0x00000070U, 0x000000a0U, 0x000000e0U, 0x00000070U,
		0x000000a0U, 0x00000090U, 0x000000f0U, 0x00000050U,
		0x00000060U, 0x00000000U, 0x00000080U, 0x000000f0U,
		0x00000000U, 0x000000e0U, 0x00000050U, 0x00000020U,
		0x00000090U, 0x00000030U, 0x00000020U, 0x000000c0U,
	},
	{
		0x0000000dU, 0x00000001U, 0x00000002U, 0x0000000fU,
		0x00000008U, 0x0000000dU, 0x00000004U, 0x00000008U,
		0x00000006U, 0x0000000aU, 0x0000000fU, 0x00000003U,
		0x0000000bU, 0x00000007U, 0x00000001U, 0x00000004U,
		0x0000000aU, 0x0000000cU, 0x00000009U, 0x00000005U,
		0x00000003U, 0x00000006U, 0x0000000eU, 0x0000000bU,
		0x00000005U, 0x00000000U, 0x00000000U, 0x0000000eU,
		0x0000000cU, 0x00000009U, 0x00000007U, 0x00000002U,
		0x00000007U, 0x00000002U, 0x0000000bU, 0x00000001U,
		0x00000004U, 0x0000000eU, 0x00000001U, 0x00000007U,
		0x00000009U, 0x00000004U, 0x0000000cU, 0x0000000aU,
		0x0000000eU, 0x00000008U, 0x00000002U, 0x0000000dU,
		0x00000000U, 0x0000000fU, 0x00000006U, 0x0000000cU,
		0x0000000aU, 0x00000009U, 0x0000000dU, 0x00000000U,
		0x0000000fU, 0x00000003U, 0x00000003U, 0x00000005U,
		0x00000005U, 0x00000006U, 0x00000008U, 0x0000000bU,
	},
};

/*
 * Permute 32 bit output of S boxes
 */
const 	uint32_t	P_tab[4][256] = {
	0x00000000U, 0x00004000U, 0x40000000U, 0x40004000U,
	0x00000010U, 0x00004010U, 0x40000010U, 0x40004010U,
	0x00080000U, 0x00084000U, 0x40080000U, 0x40084000U,
	0x00080010U, 0x00084010U, 0x40080010U, 0x40084010U,
	0x00000002U, 0x00004002U, 0x40000002U, 0x40004002U,
	0x00000012U, 0x00004012U, 0x40000012U, 0x40004012U,
	0x00080002U, 0x00084002U, 0x40080002U, 0x40084002U,
	0x00080012U, 0x00084012U, 0x40080012U, 0x40084012U,
	0x00000200U, 0x00004200U, 0x40000200U, 0x40004200U,
	0x00000210U, 0x00004210U, 0x40000210U, 0x40004210U,
	0x00080200U, 0x00084200U, 0x40080200U, 0x40084200U,
	0x00080210U, 0x00084210U, 0x40080210U, 0x40084210U,
	0x00000202U, 0x00004202U, 0x40000202U, 0x40004202U,
	0x00000212U, 0x00004212U, 0x40000212U, 0x40004212U,
	0x00080202U, 0x00084202U, 0x40080202U, 0x40084202U,
	0x00080212U, 0x00084212U, 0x40080212U, 0x40084212U,
	0x00008000U, 0x0000c000U, 0x40008000U, 0x4000c000U,
	0x00008010U, 0x0000c010U, 0x40008010U, 0x4000c010U,
	0x00088000U, 0x0008c000U, 0x40088000U, 0x4008c000U,
	0x00088010U, 0x0008c010U, 0x40088010U, 0x4008c010U,
	0x00008002U, 0x0000c002U, 0x40008002U, 0x4000c002U,
	0x00008012U, 0x0000c012U, 0x40008012U, 0x4000c012U,
	0x00088002U, 0x0008c002U, 0x40088002U, 0x4008c002U,
	0x00088012U, 0x0008c012U, 0x40088012U, 0x4008c012U,
	0x00008200U, 0x0000c200U, 0x40008200U, 0x4000c200U,
	0x00008210U, 0x0000c210U, 0x40008210U, 0x4000c210U,
	0x00088200U, 0x0008c200U, 0x40088200U, 0x4008c200U,
	0x00088210U, 0x0008c210U, 0x40088210U, 0x4008c210U,
	0x00008202U, 0x0000c202U, 0x40008202U, 0x4000c202U,
	0x00008212U, 0x0000c212U, 0x40008212U, 0x4000c212U,
	0x00088202U, 0x0008c202U, 0x40088202U, 0x4008c202U,
	0x00088212U, 0x0008c212U, 0x40088212U, 0x4008c212U,
	0x00800000U, 0x00804000U, 0x40800000U, 0x40804000U,
	0x00800010U, 0x00804010U, 0x40800010U, 0x40804010U,
	0x00880000U, 0x00884000U, 0x40880000U, 0x40884000U,
	0x00880010U, 0x00884010U, 0x40880010U, 0x40884010U,
	0x00800002U, 0x00804002U, 0x40800002U, 0x40804002U,
	0x00800012U, 0x00804012U, 0x40800012U, 0x40804012U,
	0x00880002U, 0x00884002U, 0x40880002U, 0x40884002U,
	0x00880012U, 0x00884012U, 0x40880012U, 0x40884012U,
	0x00800200U, 0x00804200U, 0x40800200U, 0x40804200U,
	0x00800210U, 0x00804210U, 0x40800210U, 0x40804210U,
	0x00880200U, 0x00884200U, 0x40880200U, 0x40884200U,
	0x00880210U, 0x00884210U, 0x40880210U, 0x40884210U,
	0x00800202U, 0x00804202U, 0x40800202U, 0x40804202U,
	0x00800212U, 0x00804212U, 0x40800212U, 0x40804212U,
	0x00880202U, 0x00884202U, 0x40880202U, 0x40884202U,
	0x00880212U, 0x00884212U, 0x40880212U, 0x40884212U,
	0x00808000U, 0x0080c000U, 0x40808000U, 0x4080c000U,
	0x00808010U, 0x0080c010U, 0x40808010U, 0x4080c010U,
	0x00888000U, 0x0088c000U, 0x40888000U, 0x4088c000U,
	0x00888010U, 0x0088c010U, 0x40888010U, 0x4088c010U,
	0x00808002U, 0x0080c002U, 0x40808002U, 0x4080c002U,
	0x00808012U, 0x0080c012U, 0x40808012U, 0x4080c012U,
	0x00888002U, 0x0088c002U, 0x40888002U, 0x4088c002U,
	0x00888012U, 0x0088c012U, 0x40888012U, 0x4088c012U,
	0x00808200U, 0x0080c200U, 0x40808200U, 0x4080c200U,
	0x00808210U, 0x0080c210U, 0x40808210U, 0x4080c210U,
	0x00888200U, 0x0088c200U, 0x40888200U, 0x4088c200U,
	0x00888210U, 0x0088c210U, 0x40888210U, 0x4088c210U,
	0x00808202U, 0x0080c202U, 0x40808202U, 0x4080c202U,
	0x00808212U, 0x0080c212U, 0x40808212U, 0x4080c212U,
	0x00888202U, 0x0088c202U, 0x40888202U, 0x4088c202U,
	0x00888212U, 0x0088c212U, 0x40888212U, 0x4088c212U,
	0x00000000U, 0x80000000U, 0x00400000U, 0x80400000U,
	0x00001000U, 0x80001000U, 0x00401000U, 0x80401000U,
	0x00000040U, 0x80000040U, 0x00400040U, 0x80400040U,
	0x00001040U, 0x80001040U, 0x00401040U, 0x80401040U,
	0x04000000U, 0x84000000U, 0x04400000U, 0x84400000U,
	0x04001000U, 0x84001000U, 0x04401000U, 0x84401000U,
	0x04000040U, 0x84000040U, 0x04400040U, 0x84400040U,
	0x04001040U, 0x84001040U, 0x04401040U, 0x84401040U,
	0x00000004U, 0x80000004U, 0x00400004U, 0x80400004U,
	0x00001004U, 0x80001004U, 0x00401004U, 0x80401004U,
	0x00000044U, 0x80000044U, 0x00400044U, 0x80400044U,
	0x00001044U, 0x80001044U, 0x00401044U, 0x80401044U,
	0x04000004U, 0x84000004U, 0x04400004U, 0x84400004U,
	0x04001004U, 0x84001004U, 0x04401004U, 0x84401004U,
	0x04000044U, 0x84000044U, 0x04400044U, 0x84400044U,
	0x04001044U, 0x84001044U, 0x04401044U, 0x84401044U,
	0x00010000U, 0x80010000U, 0x00410000U, 0x80410000U,
	0x00011000U, 0x80011000U, 0x00411000U, 0x80411000U,
	0x00010040U, 0x80010040U, 0x00410040U, 0x80410040U,
	0x00011040U, 0x80011040U, 0x00411040U, 0x80411040U,
	0x04010000U, 0x84010000U, 0x04410000U, 0x84410000U,
	0x04011000U, 0x84011000U, 0x04411000U, 0x84411000U,
	0x04010040U, 0x84010040U, 0x04410040U, 0x84410040U,
	0x04011040U, 0x84011040U, 0x04411040U, 0x84411040U,
	0x00010004U, 0x80010004U, 0x00410004U, 0x80410004U,
	0x00011004U, 0x80011004U, 0x00411004U, 0x80411004U,
	0x00010044U, 0x80010044U, 0x00410044U, 0x80410044U,
	0x00011044U, 0x80011044U, 0x00411044U, 0x80411044U,
	0x04010004U, 0x84010004U, 0x04410004U, 0x84410004U,
	0x04011004U, 0x84011004U, 0x04411004U, 0x84411004U,
	0x04010044U, 0x84010044U, 0x04410044U, 0x84410044U,
	0x04011044U, 0x84011044U, 0x04411044U, 0x84411044U,
	0x00000100U, 0x80000100U, 0x00400100U, 0x80400100U,
	0x00001100U, 0x80001100U, 0x00401100U, 0x80401100U,
	0x00000140U, 0x80000140U, 0x00400140U, 0x80400140U,
	0x00001140U, 0x80001140U, 0x00401140U, 0x80401140U,
	0x04000100U, 0x84000100U, 0x04400100U, 0x84400100U,
	0x04001100U, 0x84001100U, 0x04401100U, 0x84401100U,
	0x04000140U, 0x84000140U, 0x04400140U, 0x84400140U,
	0x04001140U, 0x84001140U, 0x04401140U, 0x84401140U,
	0x00000104U, 0x80000104U, 0x00400104U, 0x80400104U,
	0x00001104U, 0x80001104U, 0x00401104U, 0x80401104U,
	0x00000144U, 0x80000144U, 0x00400144U, 0x80400144U,
	0x00001144U, 0x80001144U, 0x00401144U, 0x80401144U,
	0x04000104U, 0x84000104U, 0x04400104U, 0x84400104U,
	0x04001104U, 0x84001104U, 0x04401104U, 0x84401104U,
	0x04000144U, 0x84000144U, 0x04400144U, 0x84400144U,
	0x04001144U, 0x84001144U, 0x04401144U, 0x84401144U,
	0x00010100U, 0x80010100U, 0x00410100U, 0x80410100U,
	0x00011100U, 0x80011100U, 0x00411100U, 0x80411100U,
	0x00010140U, 0x80010140U, 0x00410140U, 0x80410140U,
	0x00011140U, 0x80011140U, 0x00411140U, 0x80411140U,
	0x04010100U, 0x84010100U, 0x04410100U, 0x84410100U,
	0x04011100U, 0x84011100U, 0x04411100U, 0x84411100U,
	0x04010140U, 0x84010140U, 0x04410140U, 0x84410140U,
	0x04011140U, 0x84011140U, 0x04411140U, 0x84411140U,
	0x00010104U, 0x80010104U, 0x00410104U, 0x80410104U,
	0x00011104U, 0x80011104U, 0x00411104U, 0x80411104U,
	0x00010144U, 0x80010144U, 0x00410144U, 0x80410144U,
	0x00011144U, 0x80011144U, 0x00411144U, 0x80411144U,
	0x04010104U, 0x84010104U, 0x04410104U, 0x84410104U,
	0x04011104U, 0x84011104U, 0x04411104U, 0x84411104U,
	0x04010144U, 0x84010144U, 0x04410144U, 0x84410144U,
	0x04011144U, 0x84011144U, 0x04411144U, 0x84411144U,
	0x00000000U, 0x00002000U, 0x00200000U, 0x00202000U,
	0x00000008U, 0x00002008U, 0x00200008U, 0x00202008U,
	0x10000000U, 0x10002000U, 0x10200000U, 0x10202000U,
	0x10000008U, 0x10002008U, 0x10200008U, 0x10202008U,
	0x20000000U, 0x20002000U, 0x20200000U, 0x20202000U,
	0x20000008U, 0x20002008U, 0x20200008U, 0x20202008U,
	0x30000000U, 0x30002000U, 0x30200000U, 0x30202000U,
	0x30000008U, 0x30002008U, 0x30200008U, 0x30202008U,
	0x00000080U, 0x00002080U, 0x00200080U, 0x00202080U,
	0x00000088U, 0x00002088U, 0x00200088U, 0x00202088U,
	0x10000080U, 0x10002080U, 0x10200080U, 0x10202080U,
	0x10000088U, 0x10002088U, 0x10200088U, 0x10202088U,
	0x20000080U, 0x20002080U, 0x20200080U, 0x20202080U,
	0x20000088U, 0x20002088U, 0x20200088U, 0x20202088U,
	0x30000080U, 0x30002080U, 0x30200080U, 0x30202080U,
	0x30000088U, 0x30002088U, 0x30200088U, 0x30202088U,
	0x00040000U, 0x00042000U, 0x00240000U, 0x00242000U,
	0x00040008U, 0x00042008U, 0x00240008U, 0x00242008U,
	0x10040000U, 0x10042000U, 0x10240000U, 0x10242000U,
	0x10040008U, 0x10042008U, 0x10240008U, 0x10242008U,
	0x20040000U, 0x20042000U, 0x20240000U, 0x20242000U,
	0x20040008U, 0x20042008U, 0x20240008U, 0x20242008U,
	0x30040000U, 0x30042000U, 0x30240000U, 0x30242000U,
	0x30040008U, 0x30042008U, 0x30240008U, 0x30242008U,
	0x00040080U, 0x00042080U, 0x00240080U, 0x00242080U,
	0x00040088U, 0x00042088U, 0x00240088U, 0x00242088U,
	0x10040080U, 0x10042080U, 0x10240080U, 0x10242080U,
	0x10040088U, 0x10042088U, 0x10240088U, 0x10242088U,
	0x20040080U, 0x20042080U, 0x20240080U, 0x20242080U,
	0x20040088U, 0x20042088U, 0x20240088U, 0x20242088U,
	0x30040080U, 0x30042080U, 0x30240080U, 0x30242080U,
	0x30040088U, 0x30042088U, 0x30240088U, 0x30242088U,
	0x01000000U, 0x01002000U, 0x01200000U, 0x01202000U,
	0x01000008U, 0x01002008U, 0x01200008U, 0x01202008U,
	0x11000000U, 0x11002000U, 0x11200000U, 0x11202000U,
	0x11000008U, 0x11002008U, 0x11200008U, 0x11202008U,
	0x21000000U, 0x21002000U, 0x21200000U, 0x21202000U,
	0x21000008U, 0x21002008U, 0x21200008U, 0x21202008U,
	0x31000000U, 0x31002000U, 0x31200000U, 0x31202000U,
	0x31000008U, 0x31002008U, 0x31200008U, 0x31202008U,
	0x01000080U, 0x01002080U, 0x01200080U, 0x01202080U,
	0x01000088U, 0x01002088U, 0x01200088U, 0x01202088U,
	0x11000080U, 0x11002080U, 0x11200080U, 0x11202080U,
	0x11000088U, 0x11002088U, 0x11200088U, 0x11202088U,
	0x21000080U, 0x21002080U, 0x21200080U, 0x21202080U,
	0x21000088U, 0x21002088U, 0x21200088U, 0x21202088U,
	0x31000080U, 0x31002080U, 0x31200080U, 0x31202080U,
	0x31000088U, 0x31002088U, 0x31200088U, 0x31202088U,
	0x01040000U, 0x01042000U, 0x01240000U, 0x01242000U,
	0x01040008U, 0x01042008U, 0x01240008U, 0x01242008U,
	0x11040000U, 0x11042000U, 0x11240000U, 0x11242000U,
	0x11040008U, 0x11042008U, 0x11240008U, 0x11242008U,
	0x21040000U, 0x21042000U, 0x21240000U, 0x21242000U,
	0x21040008U, 0x21042008U, 0x21240008U, 0x21242008U,
	0x31040000U, 0x31042000U, 0x31240000U, 0x31242000U,
	0x31040008U, 0x31042008U, 0x31240008U, 0x31242008U,
	0x01040080U, 0x01042080U, 0x01240080U, 0x01242080U,
	0x01040088U, 0x01042088U, 0x01240088U, 0x01242088U,
	0x11040080U, 0x11042080U, 0x11240080U, 0x11242080U,
	0x11040088U, 0x11042088U, 0x11240088U, 0x11242088U,
	0x21040080U, 0x21042080U, 0x21240080U, 0x21242080U,
	0x21040088U, 0x21042088U, 0x21240088U, 0x21242088U,
	0x31040080U, 0x31042080U, 0x31240080U, 0x31242080U,
	0x31040088U, 0x31042088U, 0x31240088U, 0x31242088U,
	0x00000000U, 0x00000800U, 0x00020000U, 0x00020800U,
	0x00000020U, 0x00000820U, 0x00020020U, 0x00020820U,
	0x08000000U, 0x08000800U, 0x08020000U, 0x08020800U,
	0x08000020U, 0x08000820U, 0x08020020U, 0x08020820U,
	0x02000000U, 0x02000800U, 0x02020000U, 0x02020800U,
	0x02000020U, 0x02000820U, 0x02020020U, 0x02020820U,
	0x0a000000U, 0x0a000800U, 0x0a020000U, 0x0a020800U,
	0x0a000020U, 0x0a000820U, 0x0a020020U, 0x0a020820U,
	0x00000400U, 0x00000c00U, 0x00020400U, 0x00020c00U,
	0x00000420U, 0x00000c20U, 0x00020420U, 0x00020c20U,
	0x08000400U, 0x08000c00U, 0x08020400U, 0x08020c00U,
	0x08000420U, 0x08000c20U, 0x08020420U, 0x08020c20U,
	0x02000400U, 0x02000c00U, 0x02020400U, 0x02020c00U,
	0x02000420U, 0x02000c20U, 0x02020420U, 0x02020c20U,
	0x0a000400U, 0x0a000c00U, 0x0a020400U, 0x0a020c00U,
	0x0a000420U, 0x0a000c20U, 0x0a020420U, 0x0a020c20U,
	0x00100000U, 0x00100800U, 0x00120000U, 0x00120800U,
	0x00100020U, 0x00100820U, 0x00120020U, 0x00120820U,
	0x08100000U, 0x08100800U, 0x08120000U, 0x08120800U,
	0x08100020U, 0x08100820U, 0x08120020U, 0x08120820U,
	0x02100000U, 0x02100800U, 0x02120000U, 0x02120800U,
	0x02100020U, 0x02100820U, 0x02120020U, 0x02120820U,
	0x0a100000U, 0x0a100800U, 0x0a120000U, 0x0a120800U,
	0x0a100020U, 0x0a100820U, 0x0a120020U, 0x0a120820U,
	0x00100400U, 0x00100c00U, 0x00120400U, 0x00120c00U,
	0x00100420U, 0x00100c20U, 0x00120420U, 0x00120c20U,
	0x08100400U, 0x08100c00U, 0x08120400U, 0x08120c00U,
	0x08100420U, 0x08100c20U, 0x08120420U, 0x08120c20U,
	0x02100400U, 0x02100c00U, 0x02120400U, 0x02120c00U,
	0x02100420U, 0x02100c20U, 0x02120420U, 0x02120c20U,
	0x0a100400U, 0x0a100c00U, 0x0a120400U, 0x0a120c00U,
	0x0a100420U, 0x0a100c20U, 0x0a120420U, 0x0a120c20U,
	0x00000001U, 0x00000801U, 0x00020001U, 0x00020801U,
	0x00000021U, 0x00000821U, 0x00020021U, 0x00020821U,
	0x08000001U, 0x08000801U, 0x08020001U, 0x08020801U,
	0x08000021U, 0x08000821U, 0x08020021U, 0x08020821U,
	0x02000001U, 0x02000801U, 0x02020001U, 0x02020801U,
	0x02000021U, 0x02000821U, 0x02020021U, 0x02020821U,
	0x0a000001U, 0x0a000801U, 0x0a020001U, 0x0a020801U,
	0x0a000021U, 0x0a000821U, 0x0a020021U, 0x0a020821U,
	0x00000401U, 0x00000c01U, 0x00020401U, 0x00020c01U,
	0x00000421U, 0x00000c21U, 0x00020421U, 0x00020c21U,
	0x08000401U, 0x08000c01U, 0x08020401U, 0x08020c01U,
	0x08000421U, 0x08000c21U, 0x08020421U, 0x08020c21U,
	0x02000401U, 0x02000c01U, 0x02020401U, 0x02020c01U,
	0x02000421U, 0x02000c21U, 0x02020421U, 0x02020c21U,
	0x0a000401U, 0x0a000c01U, 0x0a020401U, 0x0a020c01U,
	0x0a000421U, 0x0a000c21U, 0x0a020421U, 0x0a020c21U,
	0x00100001U, 0x00100801U, 0x00120001U, 0x00120801U,
	0x00100021U, 0x00100821U, 0x00120021U, 0x00120821U,
	0x08100001U, 0x08100801U, 0x08120001U, 0x08120801U,
	0x08100021U, 0x08100821U, 0x08120021U, 0x08120821U,
	0x02100001U, 0x02100801U, 0x02120001U, 0x02120801U,
	0x02100021U, 0x02100821U, 0x02120021U, 0x02120821U,
	0x0a100001U, 0x0a100801U, 0x0a120001U, 0x0a120801U,
	0x0a100021U, 0x0a100821U, 0x0a120021U, 0x0a120821U,
	0x00100401U, 0x00100c01U, 0x00120401U, 0x00120c01U,
	0x00100421U, 0x00100c21U, 0x00120421U, 0x00120c21U,
	0x08100401U, 0x08100c01U, 0x08120401U, 0x08120c01U,
	0x08100421U, 0x08100c21U, 0x08120421U, 0x08120c21U,
	0x02100401U, 0x02100c01U, 0x02120401U, 0x02120c01U,
	0x02100421U, 0x02100c21U, 0x02120421U, 0x02120c21U,
	0x0a100401U, 0x0a100c01U, 0x0a120401U, 0x0a120c01U,
	0x0a100421U, 0x0a100c21U, 0x0a120421U, 0x0a120c21U,
};

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_DESDATA_H */
