#!/bin/bash

file=$1
project=$(echo "$2" | cut -d = -f 2)

if [[ "$file" = "" ]] ; then
    echo "Usage:  $0 <file with smatch messages> -p=<project>"
    exit 1
fi

if [[ "$project" != "kernel" ]] ; then
    exit 0
fi

bin_dir=$(dirname $0)
remove=$(echo ${bin_dir}/../smatch_data/kernel.returns_held.remove)
tmp=$(mktemp /tmp/smatch.XXXX)

echo "// list of functions that return a held device." \
    > kernel.returns_held_funcs
echo '// generated by `gen_returns_held.sh`' >> kernel.returns_held_funcs
grep "returned dev is held" $file | cut -s -d ' ' -f 2 | cut -d '(' -f 1 | \
    sort -u > $tmp
cat $tmp $remove $remove 2> /dev/null | sort | uniq -u \
    >> kernel.returns_held_funcs
rm $tmp
echo "Done.  List saved as 'kernel.returns_held_funcs'"

