/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright (c) 2015, Joyent, Inc.
 */

/*
 * Test chacha20 key stream with known TVs.
 *
 * Based on data from:
 * https://tools.ietf.org/html/draft-strombergson-chacha-test-vectors-01
 */

#include <strings.h>
#include <chacha.h>
#include <assert.h>

/* Test Vector 1 */

static uint8_t cha_key1[16] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t cha_iv1[8] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t cha_fbl1[] = {
	0x89, 0x67, 0x09, 0x52, 0x60, 0x83, 0x64, 0xfd,
	0x00, 0xb2, 0xf9, 0x09, 0x36, 0xf0, 0x31, 0xc8,
	0xe7, 0x56, 0xe1, 0x5d, 0xba, 0x04, 0xb8, 0x49,
	0x3d, 0x00, 0x42, 0x92, 0x59, 0xb2, 0x0f, 0x46,
	0xcc, 0x04, 0xf1, 0x11, 0x24, 0x6b, 0x6c, 0x2c,
	0xe0, 0x66, 0xbe, 0x3b, 0xfb, 0x32, 0xd9, 0xaa,
	0x0f, 0xdd, 0xfb, 0xc1, 0x21, 0x23, 0xd4, 0xb9,
	0xe4, 0x4f, 0x34, 0xdc, 0xa0, 0x5a, 0x10, 0x3f
};
static uint8_t cha_sbl1[] = {
	0x6c, 0xd1, 0x35, 0xc2, 0x87, 0x8c, 0x83, 0x2b,
	0x58, 0x96, 0xb1, 0x34, 0xf6, 0x14, 0x2a, 0x9d,
	0x4d, 0x8d, 0x0d, 0x8f, 0x10, 0x26, 0xd2, 0x0a,
	0x0a, 0x81, 0x51, 0x2c, 0xbc, 0xe6, 0xe9, 0x75,
	0x8a, 0x71, 0x43, 0xd0, 0x21, 0x97, 0x80, 0x22,
	0xa3, 0x84, 0x14, 0x1a, 0x80, 0xce, 0xa3, 0x06,
	0x2f, 0x41, 0xf6, 0x7a, 0x75, 0x2e, 0x66, 0xad,
	0x34, 0x11, 0x98, 0x4c, 0x78, 0x7e, 0x30, 0xad
};

/* Test Vector 2 */
static uint8_t cha_key2[16] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t cha_iv2[8] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static uint8_t cha_fbl2[] = {
	0xae, 0x56, 0x06, 0x0d, 0x04, 0xf5, 0xb5, 0x97,
	0x89, 0x7f, 0xf2, 0xaf, 0x13, 0x88, 0xdb, 0xce,
	0xff, 0x5a, 0x2a, 0x49, 0x20, 0x33, 0x5d, 0xc1,
	0x7a, 0x3c, 0xb1, 0xb1, 0xb1, 0x0f, 0xbe, 0x70,
	0xec, 0xe8, 0xf4, 0x86, 0x4d, 0x8c, 0x7c, 0xdf,
	0x00, 0x76, 0x45, 0x3a, 0x82, 0x91, 0xc7, 0xdb,
	0xeb, 0x3a, 0xa9, 0xc9, 0xd1, 0x0e, 0x8c, 0xa3,
	0x6b, 0xe4, 0x44, 0x93, 0x76, 0xed, 0x7c, 0x42
};

static uint8_t cha_sbl2[] = {
	0xfc, 0x3d, 0x47, 0x1c, 0x34, 0xa3, 0x6f, 0xbb,
	0xf6, 0x16, 0xbc, 0x0a, 0x0e, 0x7c, 0x52, 0x30,
	0x30, 0xd9, 0x44, 0xf4, 0x3e, 0xc3, 0xe7, 0x8d,
	0xd6, 0xa1, 0x24, 0x66, 0x54, 0x7c, 0xb4, 0xf7,
	0xb3, 0xce, 0xbd, 0x0a, 0x50, 0x05, 0xe7, 0x62,
	0xe5, 0x62, 0xd1, 0x37, 0x5b, 0x7a, 0xc4, 0x45,
	0x93, 0xa9, 0x91, 0xb8, 0x5d, 0x1a, 0x60, 0xfb,
	0xa2, 0x03, 0x5d, 0xfa, 0xa2, 0xa6, 0x42, 0xd5
};

/* Test Vector 3 */
static uint8_t cha_key3[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static uint8_t cha_iv3[] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static uint8_t cha_fbl3[] = {
	0x16, 0x63, 0x87, 0x9e, 0xb3, 0xf2, 0xc9, 0x94,
	0x9e, 0x23, 0x88, 0xca, 0xa3, 0x43, 0xd3, 0x61,
	0xbb, 0x13, 0x27, 0x71, 0x24, 0x5a, 0xe6, 0xd0,
	0x27, 0xca, 0x9c, 0xb0, 0x10, 0xdc, 0x1f, 0xa7,
	0x17, 0x8d, 0xc4, 0x1f, 0x82, 0x78, 0xbc, 0x1f,
	0x64, 0xb3, 0xf1, 0x27, 0x69, 0xa2, 0x40, 0x97,
	0xf4, 0x0d, 0x63, 0xa8, 0x63, 0x66, 0xbd, 0xb3,
	0x6a, 0xc0, 0x8a, 0xbe, 0x60, 0xc0, 0x7f, 0xe8
};

static uint8_t cha_sbl3[] = {
	0xb0, 0x57, 0x37, 0x5c, 0x89, 0x14, 0x44, 0x08,
	0xcc, 0x74, 0x46, 0x24, 0xf6, 0x9f, 0x7f, 0x4c,
	0xcb, 0xd9, 0x33, 0x66, 0xc9, 0x2f, 0xc4, 0xdf,
	0xca, 0xda, 0x65, 0xf1, 0xb9, 0x59, 0xd8, 0xc6,
	0x4d, 0xfc, 0x50, 0xde, 0x71, 0x1f, 0xb4, 0x64,
	0x16, 0xc2, 0x55, 0x3c, 0xc6, 0x0f, 0x21, 0xbb,
	0xfd, 0x00, 0x64, 0x91, 0xcb, 0x17, 0x88, 0x8b,
	0x4f, 0xb3, 0x52, 0x1c, 0x4f, 0xdd, 0x87, 0x45
};

/* Test Vector 4 */
static uint8_t cha_key4[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static uint8_t cha_iv4[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static uint8_t cha_fbl4[] = {
	0x99, 0x29, 0x47, 0xc3, 0x96, 0x61, 0x26, 0xa0,
	0xe6, 0x60, 0xa3, 0xe9, 0x5d, 0xb0, 0x48, 0xde,
	0x09, 0x1f, 0xb9, 0xe0, 0x18, 0x5b, 0x1e, 0x41,
	0xe4, 0x10, 0x15, 0xbb, 0x7e, 0xe5, 0x01, 0x50,
	0x39, 0x9e, 0x47, 0x60, 0xb2, 0x62, 0xf9, 0xd5,
	0x3f, 0x26, 0xd8, 0xdd, 0x19, 0xe5, 0x6f, 0x5c,
	0x50, 0x6a, 0xe0, 0xc3, 0x61, 0x9f, 0xa6, 0x7f,
	0xb0, 0xc4, 0x08, 0x10, 0x6d, 0x02, 0x03, 0xee
};

static uint8_t cha_sbl4[] = {
	0x40, 0xea, 0x3c, 0xfa, 0x61, 0xfa, 0x32, 0xa2,
	0xfd, 0xa8, 0xd1, 0x23, 0x8a, 0x21, 0x35, 0xd9,
	0xd4, 0x17, 0x87, 0x75, 0x24, 0x0f, 0x99, 0x00,
	0x70, 0x64, 0xa6, 0xa7, 0xf0, 0xc7, 0x31, 0xb6,
	0x7c, 0x22, 0x7c, 0x52, 0xef, 0x79, 0x6b, 0x6b,
	0xed, 0x9f, 0x90, 0x59, 0xba, 0x06, 0x14, 0xbc,
	0xf6, 0xdd, 0x6e, 0x38, 0x91, 0x7f, 0x3b, 0x15,
	0x0e, 0x57, 0x63, 0x75, 0xbe, 0x50, 0xed, 0x67
};

/* Test Vector 5 */
static uint8_t cha_key5[] = {
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55
};
static uint8_t cha_iv5[] = {
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55
};

static uint8_t cha_fbl5[] = {
	0x35, 0x7d, 0x7d, 0x94, 0xf9, 0x66, 0x77, 0x8f,
	0x58, 0x15, 0xa2, 0x05, 0x1d, 0xcb, 0x04, 0x13,
	0x3b, 0x26, 0xb0, 0xea, 0xd9, 0xf5, 0x7d, 0xd0,
	0x99, 0x27, 0x83, 0x7b, 0xc3, 0x06, 0x7e, 0x4b,
	0x6b, 0xf2, 0x99, 0xad, 0x81, 0xf7, 0xf5, 0x0c,
	0x8d, 0xa8, 0x3c, 0x78, 0x10, 0xbf, 0xc1, 0x7b,
	0xb6, 0xf4, 0x81, 0x3a, 0xb6, 0xc3, 0x26, 0x95,
	0x70, 0x45, 0xfd, 0x3f, 0xd5, 0xe1, 0x99, 0x15
};

static uint8_t cha_sbl5[] = {
	0xec, 0x74, 0x4a, 0x6b, 0x9b, 0xf8, 0xcb, 0xdc,
	0xb3, 0x6d, 0x8b, 0x6a, 0x54, 0x99, 0xc6, 0x8a,
	0x08, 0xef, 0x7b, 0xe6, 0xcc, 0x1e, 0x93, 0xf2,
	0xf5, 0xbc, 0xd2, 0xca, 0xd4, 0xe4, 0x7c, 0x18,
	0xa3, 0xe5, 0xd9, 0x4b, 0x56, 0x66, 0x38, 0x2c,
	0x6d, 0x13, 0x0d, 0x82, 0x2d, 0xd5, 0x6a, 0xac,
	0xb0, 0xf8, 0x19, 0x52, 0x78, 0xe7, 0xb2, 0x92,
	0x49, 0x5f, 0x09, 0x86, 0x8d, 0xdf, 0x12, 0xcc
};

/* Test Vector 6 */

static uint8_t cha_key6[] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa
};
static uint8_t cha_iv6[] = {
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa
};

static uint8_t cha_fbl6[] = {
	0xfc, 0x79, 0xac, 0xbd, 0x58, 0x52, 0x61, 0x03,
	0x86, 0x27, 0x76, 0xaa, 0xb2, 0x0f, 0x3b, 0x7d,
	0x8d, 0x31, 0x49, 0xb2, 0xfa, 0xb6, 0x57, 0x66,
	0x29, 0x93, 0x16, 0xb6, 0xe5, 0xb1, 0x66, 0x84,
	0xde, 0x5d, 0xe5, 0x48, 0xc1, 0xb7, 0xd0, 0x83,
	0xef, 0xd9, 0xe3, 0x05, 0x23, 0x19, 0xe0, 0xc6,
	0x25, 0x41, 0x41, 0xda, 0x04, 0xa6, 0x58, 0x6d,
	0xf8, 0x00, 0xf6, 0x4d, 0x46, 0xb0, 0x1c, 0x87
};

static uint8_t cha_sbl6[] = {
	0x1f, 0x05, 0xbc, 0x67, 0xe0, 0x76, 0x28, 0xeb,
	0xe6, 0xf6, 0x86, 0x5a, 0x21, 0x77, 0xe0, 0xb6,
	0x6a, 0x55, 0x8a, 0xa7, 0xcc, 0x1e, 0x8f, 0xf1,
	0xa9, 0x8d, 0x27, 0xf7, 0x07, 0x1f, 0x83, 0x35,
	0xef, 0xce, 0x45, 0x37, 0xbb, 0x0e, 0xf7, 0xb5,
	0x73, 0xb3, 0x2f, 0x32, 0x76, 0x5f, 0x29, 0x00,
	0x7d, 0xa5, 0x3b, 0xba, 0x62, 0xe7, 0xa4, 0x4d,
	0x00, 0x6f, 0x41, 0xeb, 0x28, 0xfe, 0x15, 0xd6
};

/* Test Vector 7 */
static uint8_t cha_key7[] = {
	0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
	0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff
};
static uint8_t cha_iv7[] = {
	0x0f, 0x1e, 0x2d, 0x3c, 0x4b, 0x5a, 0x69, 0x78
};

static uint8_t cha_fbl7[] = {
	0xd1, 0xab, 0xf6, 0x30, 0x46, 0x7e, 0xb4, 0xf6,
	0x7f, 0x1c, 0xfb, 0x47, 0xcd, 0x62, 0x6a, 0xae,
	0x8a, 0xfe, 0xdb, 0xbe, 0x4f, 0xf8, 0xfc, 0x5f,
	0xe9, 0xcf, 0xae, 0x30, 0x7e, 0x74, 0xed, 0x45,
	0x1f, 0x14, 0x04, 0x42, 0x5a, 0xd2, 0xb5, 0x45,
	0x69, 0xd5, 0xf1, 0x81, 0x48, 0x93, 0x99, 0x71,
	0xab, 0xb8, 0xfa, 0xfc, 0x88, 0xce, 0x4a, 0xc7,
	0xfe, 0x1c, 0x3d, 0x1f, 0x7a, 0x1e, 0xb7, 0xca
};

static uint8_t cha_sbl7[] = {
	0xe7, 0x6c, 0xa8, 0x7b, 0x61, 0xa9, 0x71, 0x35,
	0x41, 0x49, 0x77, 0x60, 0xdd, 0x9a, 0xe0, 0x59,
	0x35, 0x0c, 0xad, 0x0d, 0xce, 0xdf, 0xaa, 0x80,
	0xa8, 0x83, 0x11, 0x9a, 0x1a, 0x6f, 0x98, 0x7f,
	0xd1, 0xce, 0x91, 0xfd, 0x8e, 0xe0, 0x82, 0x80,
	0x34, 0xb4, 0x11, 0x20, 0x0a, 0x97, 0x45, 0xa2,
	0x85, 0x55, 0x44, 0x75, 0xd1, 0x2a, 0xfc, 0x04,
	0x88, 0x7f, 0xef, 0x35, 0x16, 0xd1, 0x2a, 0x2c
};

/* Test Vector 8 */
static uint8_t cha_key8[] = {
	0xc4, 0x6e, 0xc1, 0xb1, 0x8c, 0xe8, 0xa8, 0x78,
	0x72, 0x5a, 0x37, 0xe7, 0x80, 0xdf, 0xb7, 0x35
};
static uint8_t cha_iv8[] = {
	0x1a, 0xda, 0x31, 0xd5, 0xcf, 0x68, 0x82, 0x21
};

static uint8_t cha_fbl8[] = {
	0x82, 0x6a, 0xbd, 0xd8, 0x44, 0x60, 0xe2, 0xe9,
	0x34, 0x9f, 0x0e, 0xf4, 0xaf, 0x5b, 0x17, 0x9b,
	0x42, 0x6e, 0x4b, 0x2d, 0x10, 0x9a, 0x9c, 0x5b,
	0xb4, 0x40, 0x00, 0xae, 0x51, 0xbe, 0xa9, 0x0a,
	0x49, 0x6b, 0xee, 0xef, 0x62, 0xa7, 0x68, 0x50,
	0xff, 0x3f, 0x04, 0x02, 0xc4, 0xdd, 0xc9, 0x9f,
	0x6d, 0xb0, 0x7f, 0x15, 0x1c, 0x1c, 0x0d, 0xfa,
	0xc2, 0xe5, 0x65, 0x65, 0xd6, 0x28, 0x96, 0x25
};

static uint8_t cha_sbl8[] = {
	0x5b, 0x23, 0x13, 0x2e, 0x7b, 0x46, 0x9c, 0x7b,
	0xfb, 0x88, 0xfa, 0x95, 0xd4, 0x4c, 0xa5, 0xae,
	0x3e, 0x45, 0xe8, 0x48, 0xa4, 0x10, 0x8e, 0x98,
	0xba, 0xd7, 0xa9, 0xeb, 0x15, 0x51, 0x27, 0x84,
	0xa6, 0xa9, 0xe6, 0xe5, 0x91, 0xdc, 0xe6, 0x74,
	0x12, 0x0a, 0xca, 0xf9, 0x04, 0x0f, 0xf5, 0x0f,
	0xf3, 0xac, 0x30, 0xcc, 0xfb, 0x5e, 0x14, 0x20,
	0x4f, 0x5e, 0x42, 0x68, 0xb9, 0x0a, 0x88, 0x04
};

static void
chacha_test(uint8_t *key, uint8_t keylen, uint8_t *iv, uint8_t *bl0,
    uint8_t *bl1)
{
	uint8_t res0[64], res1[64];
	chacha_ctx_t ctx;
	int ret;

	bzero(&ctx, sizeof (ctx));
	bzero(res0, sizeof (res0));
	bzero(res1, sizeof (res1));
	chacha_keysetup(&ctx, key, keylen * 8, 0);
	chacha_ivsetup(&ctx, iv);
	chacha_encrypt_bytes(&ctx, res0, res0, sizeof (res0));
	chacha_encrypt_bytes(&ctx, res1, res1, sizeof (res1));
	ret = bcmp(res0, bl0, sizeof (res0));
	assert(ret == 0);
	ret = bcmp(res1, bl1, sizeof (res0));
	assert(ret == 0);
}

int
main(void)
{
	chacha_test(cha_key1, sizeof (cha_key1), cha_iv1, cha_fbl1, cha_sbl1);
	chacha_test(cha_key2, sizeof (cha_key2), cha_iv2, cha_fbl2, cha_sbl2);
	chacha_test(cha_key3, sizeof (cha_key3), cha_iv3, cha_fbl3, cha_sbl3);
	chacha_test(cha_key4, sizeof (cha_key4), cha_iv4, cha_fbl4, cha_sbl4);
	chacha_test(cha_key5, sizeof (cha_key5), cha_iv5, cha_fbl5, cha_sbl5);
	chacha_test(cha_key6, sizeof (cha_key6), cha_iv6, cha_fbl6, cha_sbl6);
	chacha_test(cha_key7, sizeof (cha_key7), cha_iv7, cha_fbl7, cha_sbl7);
	chacha_test(cha_key8, sizeof (cha_key8), cha_iv8, cha_fbl8, cha_sbl8);
	return (0);
}
