/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright 2015 Nexenta Systems, Inc.  All rights reserved.
 */

#ifndef _AES_GCM_H
#define	_AES_GCM_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Test vectors
 * NIST, "The Galois/Counter Mode of Operation (GCM)", Appendix B
 * http://csrc.nist.gov/groups/ST/toolkit/
 *     BCM/documents/proposedmodes/gcm/gcm-spec.pdf
 */

uint8_t GCM_KEY0[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define	GCM_DATA0 NULL

#define	GCM_AUTH0 NULL

uint8_t GCM_IV0[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_RES0[] = {
	0x58, 0xe2, 0xfc, 0xce, 0xfa, 0x7e, 0x30, 0x61,
	0x36, 0x7f, 0x1d, 0x57, 0xa4, 0xe7, 0x45, 0x5a,
};

uint8_t GCM_KEY1[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_DATA1[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define	GCM_AUTH1 NULL

uint8_t GCM_IV1[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_RES1[] = {
	0x03, 0x88, 0xda, 0xce, 0x60, 0xb6, 0xa3, 0x92,
	0xf3, 0x28, 0xc2, 0xb9, 0x71, 0xb2, 0xfe, 0x78,
	0xab, 0x6e, 0x47, 0xd4, 0x2c, 0xec, 0x13, 0xbd,
	0xf5, 0x3a, 0x67, 0xb2, 0x12, 0x57, 0xbd, 0xdf,
};

uint8_t GCM_KEY2[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA2[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55,
};

#define	GCM_AUTH2 NULL

uint8_t GCM_IV2[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};

uint8_t GCM_RES2[] = {
	0x42, 0x83, 0x1e, 0xc2, 0x21, 0x77, 0x74, 0x24,
	0x4b, 0x72, 0x21, 0xb7, 0x84, 0xd0, 0xd4, 0x9c,
	0xe3, 0xaa, 0x21, 0x2f, 0x2c, 0x02, 0xa4, 0xe0,
	0x35, 0xc1, 0x7e, 0x23, 0x29, 0xac, 0xa1, 0x2e,
	0x21, 0xd5, 0x14, 0xb2, 0x54, 0x66, 0x93, 0x1c,
	0x7d, 0x8f, 0x6a, 0x5a, 0xac, 0x84, 0xaa, 0x05,
	0x1b, 0xa3, 0x0b, 0x39, 0x6a, 0x0a, 0xac, 0x97,
	0x3d, 0x58, 0xe0, 0x91, 0x47, 0x3f, 0x59, 0x85,
	0x4d, 0x5c, 0x2a, 0xf3, 0x27, 0xcd, 0x64, 0xa6,
	0x2c, 0xf3, 0x5a, 0xbd, 0x2b, 0xa6, 0xfa, 0xb4,
};

uint8_t GCM_KEY3[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA3[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH3[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV3[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};

uint8_t GCM_RES3[] = {
	0x42, 0x83, 0x1e, 0xc2, 0x21, 0x77, 0x74, 0x24,
	0x4b, 0x72, 0x21, 0xb7, 0x84, 0xd0, 0xd4, 0x9c,
	0xe3, 0xaa, 0x21, 0x2f, 0x2c, 0x02, 0xa4, 0xe0,
	0x35, 0xc1, 0x7e, 0x23, 0x29, 0xac, 0xa1, 0x2e,
	0x21, 0xd5, 0x14, 0xb2, 0x54, 0x66, 0x93, 0x1c,
	0x7d, 0x8f, 0x6a, 0x5a, 0xac, 0x84, 0xaa, 0x05,
	0x1b, 0xa3, 0x0b, 0x39, 0x6a, 0x0a, 0xac, 0x97,
	0x3d, 0x58, 0xe0, 0x91, 0x5b, 0xc9, 0x4f, 0xbc,
	0x32, 0x21, 0xa5, 0xdb, 0x94, 0xfa, 0xe9, 0x5a,
	0xe7, 0x12, 0x1a, 0x47,
};

uint8_t GCM_KEY4[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA4[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH4[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV4[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
};

uint8_t GCM_RES4[] = {
	0x61, 0x35, 0x3b, 0x4c, 0x28, 0x06, 0x93, 0x4a,
	0x77, 0x7f, 0xf5, 0x1f, 0xa2, 0x2a, 0x47, 0x55,
	0x69, 0x9b, 0x2a, 0x71, 0x4f, 0xcd, 0xc6, 0xf8,
	0x37, 0x66, 0xe5, 0xf9, 0x7b, 0x6c, 0x74, 0x23,
	0x73, 0x80, 0x69, 0x00, 0xe4, 0x9f, 0x24, 0xb2,
	0x2b, 0x09, 0x75, 0x44, 0xd4, 0x89, 0x6b, 0x42,
	0x49, 0x89, 0xb5, 0xe1, 0xeb, 0xac, 0x0f, 0x07,
	0xc2, 0x3f, 0x45, 0x98, 0x36, 0x12, 0xd2, 0xe7,
	0x9e, 0x3b, 0x07, 0x85, 0x56, 0x1b, 0xe1, 0x4a,
	0xac, 0xa2, 0xfc, 0xcb,
};

uint8_t GCM_KEY5[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA5[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH5[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV5[] = {
	0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,
	0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,
	0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,
	0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,
	0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,
	0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,
	0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,
	0xa6, 0x37, 0xb3, 0x9b,
};

uint8_t GCM_RES5[] = {
	0x8c, 0xe2, 0x49, 0x98, 0x62, 0x56, 0x15, 0xb6,
	0x03, 0xa0, 0x33, 0xac, 0xa1, 0x3f, 0xb8, 0x94,
	0xbe, 0x91, 0x12, 0xa5, 0xc3, 0xa2, 0x11, 0xa8,
	0xba, 0x26, 0x2a, 0x3c, 0xca, 0x7e, 0x2c, 0xa7,
	0x01, 0xe4, 0xa9, 0xa4, 0xfb, 0xa4, 0x3c, 0x90,
	0xcc, 0xdc, 0xb2, 0x81, 0xd4, 0x8c, 0x7c, 0x6f,
	0xd6, 0x28, 0x75, 0xd2, 0xac, 0xa4, 0x17, 0x03,
	0x4c, 0x34, 0xae, 0xe5, 0x61, 0x9c, 0xc5, 0xae,
	0xff, 0xfe, 0x0b, 0xfa, 0x46, 0x2a, 0xf4, 0x3c,
	0x16, 0x99, 0xd0, 0x50,
};

uint8_t GCM_KEY6[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define	GCM_DATA6 NULL

#define	GCM_AUTH6 NULL

uint8_t GCM_IV6[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_RES6[] = {
	0xcd, 0x33, 0xb2, 0x8a, 0xc7, 0x73, 0xf7, 0x4b,
	0xa0, 0x0e, 0xd1, 0xf3, 0x12, 0x57, 0x24, 0x35,
};

uint8_t GCM_KEY7[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_DATA7[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define	GCM_AUTH7 NULL

uint8_t GCM_IV7[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_RES7[] = {
	0x98, 0xe7, 0x24, 0x7c, 0x07, 0xf0, 0xfe, 0x41,
	0x1c, 0x26, 0x7e, 0x43, 0x84, 0xb0, 0xf6, 0x00,
	0x2f, 0xf5, 0x8d, 0x80, 0x03, 0x39, 0x27, 0xab,
	0x8e, 0xf4, 0xd4, 0x58, 0x75, 0x14, 0xf0, 0xfb,
};

uint8_t GCM_KEY8[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};

uint8_t GCM_DATA8[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55,
};

#define	GCM_AUTH8 NULL

uint8_t GCM_IV8[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};

uint8_t GCM_RES8[] = {
	0x39, 0x80, 0xca, 0x0b, 0x3c, 0x00, 0xe8, 0x41,
	0xeb, 0x06, 0xfa, 0xc4, 0x87, 0x2a, 0x27, 0x57,
	0x85, 0x9e, 0x1c, 0xea, 0xa6, 0xef, 0xd9, 0x84,
	0x62, 0x85, 0x93, 0xb4, 0x0c, 0xa1, 0xe1, 0x9c,
	0x7d, 0x77, 0x3d, 0x00, 0xc1, 0x44, 0xc5, 0x25,
	0xac, 0x61, 0x9d, 0x18, 0xc8, 0x4a, 0x3f, 0x47,
	0x18, 0xe2, 0x44, 0x8b, 0x2f, 0xe3, 0x24, 0xd9,
	0xcc, 0xda, 0x27, 0x10, 0xac, 0xad, 0xe2, 0x56,
	0x99, 0x24, 0xa7, 0xc8, 0x58, 0x73, 0x36, 0xbf,
	0xb1, 0x18, 0x02, 0x4d, 0xb8, 0x67, 0x4a, 0x14,
};

uint8_t GCM_KEY9[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};

uint8_t GCM_DATA9[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH9[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV9[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};

uint8_t GCM_RES9[] = {
	0x39, 0x80, 0xca, 0x0b, 0x3c, 0x00, 0xe8, 0x41,
	0xeb, 0x06, 0xfa, 0xc4, 0x87, 0x2a, 0x27, 0x57,
	0x85, 0x9e, 0x1c, 0xea, 0xa6, 0xef, 0xd9, 0x84,
	0x62, 0x85, 0x93, 0xb4, 0x0c, 0xa1, 0xe1, 0x9c,
	0x7d, 0x77, 0x3d, 0x00, 0xc1, 0x44, 0xc5, 0x25,
	0xac, 0x61, 0x9d, 0x18, 0xc8, 0x4a, 0x3f, 0x47,
	0x18, 0xe2, 0x44, 0x8b, 0x2f, 0xe3, 0x24, 0xd9,
	0xcc, 0xda, 0x27, 0x10, 0x25, 0x19, 0x49, 0x8e,
	0x80, 0xf1, 0x47, 0x8f, 0x37, 0xba, 0x55, 0xbd,
	0x6d, 0x27, 0x61, 0x8c,
};

uint8_t GCM_KEY10[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};

uint8_t GCM_DATA10[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH10[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV10[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
};

uint8_t GCM_RES10[] = {
	0x0f, 0x10, 0xf5, 0x99, 0xae, 0x14, 0xa1, 0x54,
	0xed, 0x24, 0xb3, 0x6e, 0x25, 0x32, 0x4d, 0xb8,
	0xc5, 0x66, 0x63, 0x2e, 0xf2, 0xbb, 0xb3, 0x4f,
	0x83, 0x47, 0x28, 0x0f, 0xc4, 0x50, 0x70, 0x57,
	0xfd, 0xdc, 0x29, 0xdf, 0x9a, 0x47, 0x1f, 0x75,
	0xc6, 0x65, 0x41, 0xd4, 0xd4, 0xda, 0xd1, 0xc9,
	0xe9, 0x3a, 0x19, 0xa5, 0x8e, 0x8b, 0x47, 0x3f,
	0xa0, 0xf0, 0x62, 0xf7, 0x65, 0xdc, 0xc5, 0x7f,
	0xcf, 0x62, 0x3a, 0x24, 0x09, 0x4f, 0xcc, 0xa4,
	0x0d, 0x35, 0x33, 0xf8,
};

uint8_t GCM_KEY11[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};

uint8_t GCM_DATA11[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH11[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV11[] = {
	0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,
	0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,
	0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,
	0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,
	0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,
	0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,
	0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,
	0xa6, 0x37, 0xb3, 0x9b,
};

uint8_t GCM_RES11[] = {
	0xd2, 0x7e, 0x88, 0x68, 0x1c, 0xe3, 0x24, 0x3c,
	0x48, 0x30, 0x16, 0x5a, 0x8f, 0xdc, 0xf9, 0xff,
	0x1d, 0xe9, 0xa1, 0xd8, 0xe6, 0xb4, 0x47, 0xef,
	0x6e, 0xf7, 0xb7, 0x98, 0x28, 0x66, 0x6e, 0x45,
	0x81, 0xe7, 0x90, 0x12, 0xaf, 0x34, 0xdd, 0xd9,
	0xe2, 0xf0, 0x37, 0x58, 0x9b, 0x29, 0x2d, 0xb3,
	0xe6, 0x7c, 0x03, 0x67, 0x45, 0xfa, 0x22, 0xe7,
	0xe9, 0xb7, 0x37, 0x3b, 0xdc, 0xf5, 0x66, 0xff,
	0x29, 0x1c, 0x25, 0xbb, 0xb8, 0x56, 0x8f, 0xc3,
	0xd3, 0x76, 0xa6, 0xd9,
};

uint8_t GCM_KEY12[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define	GCM_DATA12 NULL

#define	GCM_AUTH12 NULL

uint8_t GCM_IV12[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_RES12[] = {
	0x53, 0x0f, 0x8a, 0xfb, 0xc7, 0x45, 0x36, 0xb9,
	0xa9, 0x63, 0xb4, 0xf1, 0xc4, 0xcb, 0x73, 0x8b,
};

uint8_t GCM_KEY13[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_DATA13[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define	GCM_AUTH13 NULL

uint8_t GCM_IV13[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};

uint8_t GCM_RES13[] = {
	0xce, 0xa7, 0x40, 0x3d, 0x4d, 0x60, 0x6b, 0x6e,
	0x07, 0x4e, 0xc5, 0xd3, 0xba, 0xf3, 0x9d, 0x18,
	0xd0, 0xd1, 0xc8, 0xa7, 0x99, 0x99, 0x6b, 0xf0,
	0x26, 0x5b, 0x98, 0xb5, 0xd4, 0x8a, 0xb9, 0x19,
};

uint8_t GCM_KEY14[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA14[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55,
};

#define	GCM_AUTH14 NULL

uint8_t GCM_IV14[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};

uint8_t GCM_RES14[] = {
	0x52, 0x2d, 0xc1, 0xf0, 0x99, 0x56, 0x7d, 0x07,
	0xf4, 0x7f, 0x37, 0xa3, 0x2a, 0x84, 0x42, 0x7d,
	0x64, 0x3a, 0x8c, 0xdc, 0xbf, 0xe5, 0xc0, 0xc9,
	0x75, 0x98, 0xa2, 0xbd, 0x25, 0x55, 0xd1, 0xaa,
	0x8c, 0xb0, 0x8e, 0x48, 0x59, 0x0d, 0xbb, 0x3d,
	0xa7, 0xb0, 0x8b, 0x10, 0x56, 0x82, 0x88, 0x38,
	0xc5, 0xf6, 0x1e, 0x63, 0x93, 0xba, 0x7a, 0x0a,
	0xbc, 0xc9, 0xf6, 0x62, 0x89, 0x80, 0x15, 0xad,
	0xb0, 0x94, 0xda, 0xc5, 0xd9, 0x34, 0x71, 0xbd,
	0xec, 0x1a, 0x50, 0x22, 0x70, 0xe3, 0xcc, 0x6c,
};

uint8_t GCM_KEY15[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA15[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH15[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV15[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};

uint8_t GCM_RES15[] = {
	0x52, 0x2d, 0xc1, 0xf0, 0x99, 0x56, 0x7d, 0x07,
	0xf4, 0x7f, 0x37, 0xa3, 0x2a, 0x84, 0x42, 0x7d,
	0x64, 0x3a, 0x8c, 0xdc, 0xbf, 0xe5, 0xc0, 0xc9,
	0x75, 0x98, 0xa2, 0xbd, 0x25, 0x55, 0xd1, 0xaa,
	0x8c, 0xb0, 0x8e, 0x48, 0x59, 0x0d, 0xbb, 0x3d,
	0xa7, 0xb0, 0x8b, 0x10, 0x56, 0x82, 0x88, 0x38,
	0xc5, 0xf6, 0x1e, 0x63, 0x93, 0xba, 0x7a, 0x0a,
	0xbc, 0xc9, 0xf6, 0x62, 0x76, 0xfc, 0x6e, 0xce,
	0x0f, 0x4e, 0x17, 0x68, 0xcd, 0xdf, 0x88, 0x53,
	0xbb, 0x2d, 0x55, 0x1b,
};

uint8_t GCM_KEY16[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA16[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH16[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV16[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
};

uint8_t GCM_RES16[] = {
	0xc3, 0x76, 0x2d, 0xf1, 0xca, 0x78, 0x7d, 0x32,
	0xae, 0x47, 0xc1, 0x3b, 0xf1, 0x98, 0x44, 0xcb,
	0xaf, 0x1a, 0xe1, 0x4d, 0x0b, 0x97, 0x6a, 0xfa,
	0xc5, 0x2f, 0xf7, 0xd7, 0x9b, 0xba, 0x9d, 0xe0,
	0xfe, 0xb5, 0x82, 0xd3, 0x39, 0x34, 0xa4, 0xf0,
	0x95, 0x4c, 0xc2, 0x36, 0x3b, 0xc7, 0x3f, 0x78,
	0x62, 0xac, 0x43, 0x0e, 0x64, 0xab, 0xe4, 0x99,
	0xf4, 0x7c, 0x9b, 0x1f, 0x3a, 0x33, 0x7d, 0xbf,
	0x46, 0xa7, 0x92, 0xc4, 0x5e, 0x45, 0x49, 0x13,
	0xfe, 0x2e, 0xa8, 0xf2,
};

uint8_t GCM_KEY17[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};

uint8_t GCM_DATA17[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};

uint8_t GCM_AUTH17[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};

uint8_t GCM_IV17[] = {
	0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,
	0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,
	0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,
	0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,
	0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,
	0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,
	0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,
	0xa6, 0x37, 0xb3, 0x9b,
};

uint8_t GCM_RES17[] = {
	0x5a, 0x8d, 0xef, 0x2f, 0x0c, 0x9e, 0x53, 0xf1,
	0xf7, 0x5d, 0x78, 0x53, 0x65, 0x9e, 0x2a, 0x20,
	0xee, 0xb2, 0xb2, 0x2a, 0xaf, 0xde, 0x64, 0x19,
	0xa0, 0x58, 0xab, 0x4f, 0x6f, 0x74, 0x6b, 0xf4,
	0x0f, 0xc0, 0xc3, 0xb7, 0x80, 0xf2, 0x44, 0x45,
	0x2d, 0xa3, 0xeb, 0xf1, 0xc5, 0xd8, 0x2c, 0xde,
	0xa2, 0x41, 0x89, 0x97, 0x20, 0x0e, 0xf8, 0x2e,
	0x44, 0xae, 0x7e, 0x3f, 0xa4, 0x4a, 0x82, 0x66,
	0xee, 0x1c, 0x8e, 0xb0, 0xc8, 0xb5, 0xd4, 0xcf,
	0x5a, 0xe9, 0xf1, 0x9a,
};


uint8_t *DATA[] = {
	GCM_DATA0, GCM_DATA1, GCM_DATA2, GCM_DATA3, GCM_DATA4, GCM_DATA5,
	GCM_DATA6, GCM_DATA7, GCM_DATA8, GCM_DATA9, GCM_DATA10, GCM_DATA11,
	GCM_DATA12, GCM_DATA13, GCM_DATA14, GCM_DATA15, GCM_DATA16, GCM_DATA17,
};

size_t DATALEN[] = {
	0, sizeof (GCM_DATA1), sizeof (GCM_DATA2), sizeof (GCM_DATA3),
	sizeof (GCM_DATA4), sizeof (GCM_DATA5), 0, sizeof (GCM_DATA7),
	sizeof (GCM_DATA8), sizeof (GCM_DATA9), sizeof (GCM_DATA10),
	sizeof (GCM_DATA11), 0, sizeof (GCM_DATA13), sizeof (GCM_DATA14),
	sizeof (GCM_DATA15), sizeof (GCM_DATA16),
	sizeof (GCM_DATA17),
};

uint8_t *RES[] = {
	GCM_RES0, GCM_RES1, GCM_RES2, GCM_RES3, GCM_RES4, GCM_RES5,
	GCM_RES6, GCM_RES7, GCM_RES8, GCM_RES9, GCM_RES10, GCM_RES11,
	GCM_RES12, GCM_RES13, GCM_RES14, GCM_RES15, GCM_RES16, GCM_RES17,
};

size_t RESLEN[] = {
	sizeof (GCM_RES0), sizeof (GCM_RES1), sizeof (GCM_RES2),
	sizeof (GCM_RES3), sizeof (GCM_RES4), sizeof (GCM_RES5),
	sizeof (GCM_RES6), sizeof (GCM_RES7), sizeof (GCM_RES8),
	sizeof (GCM_RES9), sizeof (GCM_RES10), sizeof (GCM_RES11),
	sizeof (GCM_RES12), sizeof (GCM_RES13), sizeof (GCM_RES14),
	sizeof (GCM_RES15), sizeof (GCM_RES16), sizeof (GCM_RES17),
};

uint8_t *IV[] = {
	GCM_IV0, GCM_IV1, GCM_IV2, GCM_IV3, GCM_IV4, GCM_IV5,
	GCM_IV6, GCM_IV7, GCM_IV8, GCM_IV9, GCM_IV10, GCM_IV11,
	GCM_IV12, GCM_IV13, GCM_IV14, GCM_IV15, GCM_IV16, GCM_IV17,
};

size_t IVLEN[] = {
	sizeof (GCM_IV0), sizeof (GCM_IV1), sizeof (GCM_IV2),
	sizeof (GCM_IV3), sizeof (GCM_IV4), sizeof (GCM_IV5),
	sizeof (GCM_IV6), sizeof (GCM_IV7), sizeof (GCM_IV8),
	sizeof (GCM_IV9), sizeof (GCM_IV10), sizeof (GCM_IV11),
	sizeof (GCM_IV12), sizeof (GCM_IV13), sizeof (GCM_IV14),
	sizeof (GCM_IV15), sizeof (GCM_IV16), sizeof (GCM_IV17),
};

uint8_t *AUTH[] = {
	GCM_AUTH0, GCM_AUTH1, GCM_AUTH2, GCM_AUTH3, GCM_AUTH4, GCM_AUTH5,
	GCM_AUTH6, GCM_AUTH7, GCM_AUTH8, GCM_AUTH9, GCM_AUTH10, GCM_AUTH11,
	GCM_AUTH12, GCM_AUTH13, GCM_AUTH14, GCM_AUTH15, GCM_AUTH16, GCM_AUTH17,
};

size_t AUTHLEN[] = {
	0, 0, 0, sizeof (GCM_AUTH3), sizeof (GCM_AUTH4), sizeof (GCM_AUTH5),
	0, 0, 0, sizeof (GCM_AUTH9), sizeof (GCM_AUTH10), sizeof (GCM_AUTH11),
	0, 0, 0, sizeof (GCM_AUTH15), sizeof (GCM_AUTH16), sizeof (GCM_AUTH17),
};

uint8_t *KEY[] = {
	GCM_KEY0, GCM_KEY1, GCM_KEY2, GCM_KEY3, GCM_KEY4, GCM_KEY5,
	GCM_KEY6, GCM_KEY7, GCM_KEY8, GCM_KEY9, GCM_KEY10, GCM_KEY11,
	GCM_KEY12, GCM_KEY13, GCM_KEY14, GCM_KEY15, GCM_KEY16, GCM_KEY17,
};

size_t KEYLEN[] = {
	sizeof (GCM_KEY0), sizeof (GCM_KEY1), sizeof (GCM_KEY2),
	sizeof (GCM_KEY3), sizeof (GCM_KEY4), sizeof (GCM_KEY5),
	sizeof (GCM_KEY6), sizeof (GCM_KEY7), sizeof (GCM_KEY8),
	sizeof (GCM_KEY9), sizeof (GCM_KEY10), sizeof (GCM_KEY11),
	sizeof (GCM_KEY12), sizeof (GCM_KEY13), sizeof (GCM_KEY14),
	sizeof (GCM_KEY15), sizeof (GCM_KEY16), sizeof (GCM_KEY17),
};

#ifdef __cplusplus
}
#endif

#endif /* _AES_GCM_H */
