/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright 2015 Nexenta Systems, Inc.  All rights reserved.
 */

#ifndef _AES_CCM_H
#define	_AES_CCM_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Test vectors
 * RFC3610 section 4
 */

/*
 * 1st half
 */
static uint8_t CCM_KEY1[16] = {
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
	0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
};

/* nonces */
static uint8_t CCM1_N[] = {
	0x00, 0x00, 0x00, 0x03, 0x02, 0x01, 0x00, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM2_N[] = {
	0x00, 0x00, 0x00, 0x04, 0x03, 0x02, 0x01, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM3_N[] = {
	0x00, 0x00, 0x00, 0x05, 0x04, 0x03, 0x02, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM4_N[] = {
	0x00, 0x00, 0x00, 0x06, 0x05, 0x04, 0x03, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM5_N[] = {
	0x00, 0x00, 0x00, 0x07, 0x06, 0x05, 0x04, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM6_N[] = {
	0x00, 0x00, 0x00, 0x08, 0x07, 0x06, 0x05, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM7_N[] = {
	0x00, 0x00, 0x00, 0x09, 0x08, 0x07, 0x06, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM8_N[] = {
	0x00, 0x00, 0x00, 0x0A, 0x09, 0x08, 0x07, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM9_N[] = {
	0x00, 0x00, 0x00, 0x0B, 0x0A, 0x09, 0x08, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM10_N[] = {
	0x00, 0x00, 0x00, 0x0C, 0x0B, 0x0A, 0x09, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM11_N[] = {
	0x00, 0x00, 0x00, 0x0D, 0x0C, 0x0B, 0x0A, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};
static uint8_t CCM12_N[] = {
	0x00, 0x00, 0x00, 0x0E, 0x0D, 0x0C, 0x0B, 0xA0,
	0xA1, 0xA2, 0xA3, 0xA4, 0xA5,
};

/* vector data is a subset of this */
static uint8_t CCM_DATA1[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20,
};

/* results */
static uint8_t CCM1_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x58, 0x8C, 0x97, 0x9A, 0x61, 0xC6, 0x63, 0xD2,
	0xF0, 0x66, 0xD0, 0xC2, 0xC0, 0xF9, 0x89, 0x80,
	0x6D, 0x5F, 0x6B, 0x61, 0xDA, 0xC3, 0x84, 0x17,
	0xE8, 0xD1, 0x2C, 0xFD, 0xF9, 0x26, 0xE0,
};
static uint8_t CCM2_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x72, 0xC9, 0x1A, 0x36, 0xE1, 0x35, 0xF8, 0xCF,
	0x29, 0x1C, 0xA8, 0x94, 0x08, 0x5C, 0x87, 0xE3,
	0xCC, 0x15, 0xC4, 0x39, 0xC9, 0xE4, 0x3A, 0x3B,
	0xA0, 0x91, 0xD5, 0x6E, 0x10, 0x40, 0x09, 0x16,
};
static uint8_t CCM3_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x51, 0xB1, 0xE5, 0xF4, 0x4A, 0x19, 0x7D, 0x1D,
	0xA4, 0x6B, 0x0F, 0x8E, 0x2D, 0x28, 0x2A, 0xE8,
	0x71, 0xE8, 0x38, 0xBB, 0x64, 0xDA, 0x85, 0x96,
	0x57, 0x4A, 0xDA, 0xA7, 0x6F, 0xBD, 0x9F, 0xB0,
	0xC5,
};
static uint8_t CCM4_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0xA2, 0x8C, 0x68, 0x65,
	0x93, 0x9A, 0x9A, 0x79, 0xFA, 0xAA, 0x5C, 0x4C,
	0x2A, 0x9D, 0x4A, 0x91, 0xCD, 0xAC, 0x8C, 0x96,
	0xC8, 0x61, 0xB9, 0xC9, 0xE6, 0x1E, 0xF1,
};
static uint8_t CCM5_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0xDC, 0xF1, 0xFB, 0x7B,
	0x5D, 0x9E, 0x23, 0xFB, 0x9D, 0x4E, 0x13, 0x12,
	0x53, 0x65, 0x8A, 0xD8, 0x6E, 0xBD, 0xCA, 0x3E,
	0x51, 0xE8, 0x3F, 0x07, 0x7D, 0x9C, 0x2D, 0x93,
};
static uint8_t CCM6_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x6F, 0xC1, 0xB0, 0x11,
	0xF0, 0x06, 0x56, 0x8B, 0x51, 0x71, 0xA4, 0x2D,
	0x95, 0x3D, 0x46, 0x9B, 0x25, 0x70, 0xA4, 0xBD,
	0x87, 0x40, 0x5A, 0x04, 0x43, 0xAC, 0x91, 0xCB,
	0x94,
};
static uint8_t CCM7_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x01, 0x35, 0xD1, 0xB2, 0xC9, 0x5F, 0x41, 0xD5,
	0xD1, 0xD4, 0xFE, 0xC1, 0x85, 0xD1, 0x66, 0xB8,
	0x09, 0x4E, 0x99, 0x9D, 0xFE, 0xD9, 0x6C, 0x04,
	0x8C, 0x56, 0x60, 0x2C, 0x97, 0xAC, 0xBB, 0x74,
	0x90,
};
static uint8_t CCM8_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x7B, 0x75, 0x39, 0x9A, 0xC0, 0x83, 0x1D, 0xD2,
	0xF0, 0xBB, 0xD7, 0x58, 0x79, 0xA2, 0xFD, 0x8F,
	0x6C, 0xAE, 0x6B, 0x6C, 0xD9, 0xB7, 0xDB, 0x24,
	0xC1, 0x7B, 0x44, 0x33, 0xF4, 0x34, 0x96, 0x3F,
	0x34, 0xB4,
};
static uint8_t CCM9_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x82, 0x53, 0x1A, 0x60, 0xCC, 0x24, 0x94, 0x5A,
	0x4B, 0x82, 0x79, 0x18, 0x1A, 0xB5, 0xC8, 0x4D,
	0xF2, 0x1C, 0xE7, 0xF9, 0xB7, 0x3F, 0x42, 0xE1,
	0x97, 0xEA, 0x9C, 0x07, 0xE5, 0x6B, 0x5E, 0xB1,
	0x7E, 0x5F, 0x4E,
};
static uint8_t CCM10_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x07, 0x34, 0x25, 0x94,
	0x15, 0x77, 0x85, 0x15, 0x2B, 0x07, 0x40, 0x98,
	0x33, 0x0A, 0xBB, 0x14, 0x1B, 0x94, 0x7B, 0x56,
	0x6A, 0xA9, 0x40, 0x6B, 0x4D, 0x99, 0x99, 0x88,
	0xDD,
};
static uint8_t CCM11_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0x67, 0x6B, 0xB2, 0x03,
	0x80, 0xB0, 0xE3, 0x01, 0xE8, 0xAB, 0x79, 0x59,
	0x0A, 0x39, 0x6D, 0xA7, 0x8B, 0x83, 0x49, 0x34,
	0xF5, 0x3A, 0xA2, 0xE9, 0x10, 0x7A, 0x8B, 0x6C,
	0x02, 0x2C,
};
static uint8_t CCM12_RES[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0A, 0x0B, 0xC0, 0xFF, 0xA0, 0xD6,
	0xF0, 0x5B, 0xDB, 0x67, 0xF2, 0x4D, 0x43, 0xA4,
	0x33, 0x8D, 0x2A, 0xA4, 0xBE, 0xD7, 0xB2, 0x0E,
	0x43, 0xCD, 0x1A, 0xA3, 0x16, 0x62, 0xE7, 0xAD,
	0x65, 0xD6, 0xDB,
};


/*
 * 2nd half
 */
static uint8_t CCM_KEY2[16] = {
	0xD7, 0x82, 0x8D, 0x13, 0xB2, 0xB0, 0xBD, 0xC3,
	0x25, 0xA7, 0x62, 0x36, 0xDF, 0x93, 0xCC, 0x6B,
};

/* nonces */
static uint8_t CCM13_N[] = {
	0x00, 0x41, 0x2B, 0x4E, 0xA9, 0xCD, 0xBE, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM14_N[] = {
	0x00, 0x33, 0x56, 0x8E, 0xF7, 0xB2, 0x63, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM15_N[] = {
	0x00, 0x10, 0x3F, 0xE4, 0x13, 0x36, 0x71, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM16_N[] = {
	0x00, 0x76, 0x4C, 0x63, 0xB8, 0x05, 0x8E, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM17_N[] = {
	0x00, 0xF8, 0xB6, 0x78, 0x09, 0x4E, 0x3B, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM18_N[] = {
	0x00, 0xD5, 0x60, 0x91, 0x2D, 0x3F, 0x70, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM19_N[] = {
	0x00, 0x42, 0xFF, 0xF8, 0xF1, 0x95, 0x1C, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM20_N[] = {
	0x00, 0x92, 0x0F, 0x40, 0xE5, 0x6C, 0xDC, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM21_N[] = {
	0x00, 0x27, 0xCA, 0x0C, 0x71, 0x20, 0xBC, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM22_N[] = {
	0x00, 0x5B, 0x8C, 0xCB, 0xCD, 0x9A, 0xF8, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM23_N[] = {
	0x00, 0x3E, 0xBE, 0x94, 0x04, 0x4B, 0x9A, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};
static uint8_t CCM24_N[] = {
	0x00, 0x8D, 0x49, 0x3B, 0x30, 0xAE, 0x8B, 0x3C,
	0x96, 0x96, 0x76, 0x6C, 0xFA,
};

/* data */
static uint8_t CCM13_DATA[] = {
	0x0B, 0xE1, 0xA8, 0x8B, 0xAC, 0xE0, 0x18, 0xB1,
	0x08, 0xE8, 0xCF, 0x97, 0xD8, 0x20, 0xEA, 0x25,
	0x84, 0x60, 0xE9, 0x6A, 0xD9, 0xCF, 0x52, 0x89,
	0x05, 0x4D, 0x89, 0x5C, 0xEA, 0xC4, 0x7C,
};
static uint8_t CCM14_DATA[] = {
	0x63, 0x01, 0x8F, 0x76, 0xDC, 0x8A, 0x1B, 0xCB,
	0x90, 0x20, 0xEA, 0x6F, 0x91, 0xBD, 0xD8, 0x5A,
	0xFA, 0x00, 0x39, 0xBA, 0x4B, 0xAF, 0xF9, 0xBF,
	0xB7, 0x9C, 0x70, 0x28, 0x94, 0x9C, 0xD0, 0xEC,
};
static uint8_t CCM15_DATA[] = {
	0xAA, 0x6C, 0xFA, 0x36, 0xCA, 0xE8, 0x6B, 0x40,
	0xB9, 0x16, 0xE0, 0xEA, 0xCC, 0x1C, 0x00, 0xD7,
	0xDC, 0xEC, 0x68, 0xEC, 0x0B, 0x3B, 0xBB, 0x1A,
	0x02, 0xDE, 0x8A, 0x2D, 0x1A, 0xA3, 0x46, 0x13,
	0x2E,
};
static uint8_t CCM16_DATA[] = {
	0xD0, 0xD0, 0x73, 0x5C, 0x53, 0x1E, 0x1B, 0xEC,
	0xF0, 0x49, 0xC2, 0x44, 0x12, 0xDA, 0xAC, 0x56,
	0x30, 0xEF, 0xA5, 0x39, 0x6F, 0x77, 0x0C, 0xE1,
	0xA6, 0x6B, 0x21, 0xF7, 0xB2, 0x10, 0x1C,
};
static uint8_t CCM17_DATA[] = {
	0x77, 0xB6, 0x0F, 0x01, 0x1C, 0x03, 0xE1, 0x52,
	0x58, 0x99, 0xBC, 0xAE, 0xE8, 0x8B, 0x6A, 0x46,
	0xC7, 0x8D, 0x63, 0xE5, 0x2E, 0xB8, 0xC5, 0x46,
	0xEF, 0xB5, 0xDE, 0x6F, 0x75, 0xE9, 0xCC, 0x0D,
};
static uint8_t CCM18_DATA[] = {
	0xCD, 0x90, 0x44, 0xD2, 0xB7, 0x1F, 0xDB, 0x81,
	0x20, 0xEA, 0x60, 0xC0, 0x64, 0x35, 0xAC, 0xBA,
	0xFB, 0x11, 0xA8, 0x2E, 0x2F, 0x07, 0x1D, 0x7C,
	0xA4, 0xA5, 0xEB, 0xD9, 0x3A, 0x80, 0x3B, 0xA8,
	0x7F,
};
static uint8_t CCM19_DATA[] = {
	0xD8, 0x5B, 0xC7, 0xE6, 0x9F, 0x94, 0x4F, 0xB8,
	0x8A, 0x19, 0xB9, 0x50, 0xBC, 0xF7, 0x1A, 0x01,
	0x8E, 0x5E, 0x67, 0x01, 0xC9, 0x17, 0x87, 0x65,
	0x98, 0x09, 0xD6, 0x7D, 0xBE, 0xDD, 0x18,
};
static uint8_t CCM20_DATA[] = {
	0x74, 0xA0, 0xEB, 0xC9, 0x06, 0x9F, 0x5B, 0x37,
	0x17, 0x61, 0x43, 0x3C, 0x37, 0xC5, 0xA3, 0x5F,
	0xC1, 0xF3, 0x9F, 0x40, 0x63, 0x02, 0xEB, 0x90,
	0x7C, 0x61, 0x63, 0xBE, 0x38, 0xC9, 0x84, 0x37,
};
static uint8_t CCM21_DATA[] = {
	0x44, 0xA3, 0xAA, 0x3A, 0xAE, 0x64, 0x75, 0xCA,
	0xA4, 0x34, 0xA8, 0xE5, 0x85, 0x00, 0xC6, 0xE4,
	0x15, 0x30, 0x53, 0x88, 0x62, 0xD6, 0x86, 0xEA,
	0x9E, 0x81, 0x30, 0x1B, 0x5A, 0xE4, 0x22, 0x6B,
	0xFA,
};
static uint8_t CCM22_DATA[] = {
	0xEC, 0x46, 0xBB, 0x63, 0xB0, 0x25, 0x20, 0xC3,
	0x3C, 0x49, 0xFD, 0x70, 0xB9, 0x6B, 0x49, 0xE2,
	0x1D, 0x62, 0x17, 0x41, 0x63, 0x28, 0x75, 0xDB,
	0x7F, 0x6C, 0x92, 0x43, 0xD2, 0xD7, 0xC2,
};
static uint8_t CCM23_DATA[] = {
	0x47, 0xA6, 0x5A, 0xC7, 0x8B, 0x3D, 0x59, 0x42,
	0x27, 0xE8, 0x5E, 0x71, 0xE2, 0xFC, 0xFB, 0xB8,
	0x80, 0x44, 0x2C, 0x73, 0x1B, 0xF9, 0x51, 0x67,
	0xC8, 0xFF, 0xD7, 0x89, 0x5E, 0x33, 0x70, 0x76,
};
static uint8_t CCM24_DATA[] = {
	0x6E, 0x37, 0xA6, 0xEF, 0x54, 0x6D, 0x95, 0x5D,
	0x34, 0xAB, 0x60, 0x59, 0xAB, 0xF2, 0x1C, 0x0B,
	0x02, 0xFE, 0xB8, 0x8F, 0x85, 0x6D, 0xF4, 0xA3,
	0x73, 0x81, 0xBC, 0xE3, 0xCC, 0x12, 0x85, 0x17,
	0xD4,
};

/* results */

static uint8_t CCM13_RES[] = {
	0x0B, 0xE1, 0xA8, 0x8B, 0xAC, 0xE0, 0x18, 0xB1,
	0x4C, 0xB9, 0x7F, 0x86, 0xA2, 0xA4, 0x68, 0x9A,
	0x87, 0x79, 0x47, 0xAB, 0x80, 0x91, 0xEF, 0x53,
	0x86, 0xA6, 0xFF, 0xBD, 0xD0, 0x80, 0xF8, 0xE7,
	0x8C, 0xF7, 0xCB, 0x0C, 0xDD, 0xD7, 0xB3,
};
static uint8_t CCM14_RES[] = {
	0x63, 0x01, 0x8F, 0x76, 0xDC, 0x8A, 0x1B, 0xCB,
	0x4C, 0xCB, 0x1E, 0x7C, 0xA9, 0x81, 0xBE, 0xFA,
	0xA0, 0x72, 0x6C, 0x55, 0xD3, 0x78, 0x06, 0x12,
	0x98, 0xC8, 0x5C, 0x92, 0x81, 0x4A, 0xBC, 0x33,
	0xC5, 0x2E, 0xE8, 0x1D, 0x7D, 0x77, 0xC0, 0x8A,
};
static uint8_t CCM15_RES[] = {
	0xAA, 0x6C, 0xFA, 0x36, 0xCA, 0xE8, 0x6B, 0x40,
	0xB1, 0xD2, 0x3A, 0x22, 0x20, 0xDD, 0xC0, 0xAC,
	0x90, 0x0D, 0x9A, 0xA0, 0x3C, 0x61, 0xFC, 0xF4,
	0xA5, 0x59, 0xA4, 0x41, 0x77, 0x67, 0x08, 0x97,
	0x08, 0xA7, 0x76, 0x79, 0x6E, 0xDB, 0x72, 0x35,
	0x06,
};
static uint8_t CCM16_RES[] = {
	0xD0, 0xD0, 0x73, 0x5C, 0x53, 0x1E, 0x1B, 0xEC,
	0xF0, 0x49, 0xC2, 0x44, 0x14, 0xD2, 0x53, 0xC3,
	0x96, 0x7B, 0x70, 0x60, 0x9B, 0x7C, 0xBB, 0x7C,
	0x49, 0x91, 0x60, 0x28, 0x32, 0x45, 0x26, 0x9A,
	0x6F, 0x49, 0x97, 0x5B, 0xCA, 0xDE, 0xAF,
};
static uint8_t CCM17_RES[] = {
	0x77, 0xB6, 0x0F, 0x01, 0x1C, 0x03, 0xE1, 0x52,
	0x58, 0x99, 0xBC, 0xAE, 0x55, 0x45, 0xFF, 0x1A,
	0x08, 0x5E, 0xE2, 0xEF, 0xBF, 0x52, 0xB2, 0xE0,
	0x4B, 0xEE, 0x1E, 0x23, 0x36, 0xC7, 0x3E, 0x3F,
	0x76, 0x2C, 0x0C, 0x77, 0x44, 0xFE, 0x7E, 0x3C,
};
static uint8_t CCM18_RES[] = {
	0xCD, 0x90, 0x44, 0xD2, 0xB7, 0x1F, 0xDB, 0x81,
	0x20, 0xEA, 0x60, 0xC0, 0x00, 0x97, 0x69, 0xEC,
	0xAB, 0xDF, 0x48, 0x62, 0x55, 0x94, 0xC5, 0x92,
	0x51, 0xE6, 0x03, 0x57, 0x22, 0x67, 0x5E, 0x04,
	0xC8, 0x47, 0x09, 0x9E, 0x5A, 0xE0, 0x70, 0x45,
	0x51,
};
static uint8_t CCM19_RES[] = {
	0xD8, 0x5B, 0xC7, 0xE6, 0x9F, 0x94, 0x4F, 0xB8,
	0xBC, 0x21, 0x8D, 0xAA, 0x94, 0x74, 0x27, 0xB6,
	0xDB, 0x38, 0x6A, 0x99, 0xAC, 0x1A, 0xEF, 0x23,
	0xAD, 0xE0, 0xB5, 0x29, 0x39, 0xCB, 0x6A, 0x63,
	0x7C, 0xF9, 0xBE, 0xC2, 0x40, 0x88, 0x97, 0xC6,
	0xBA,
};
static uint8_t CCM20_RES[] = {
	0x74, 0xA0, 0xEB, 0xC9, 0x06, 0x9F, 0x5B, 0x37,
	0x58, 0x10, 0xE6, 0xFD, 0x25, 0x87, 0x40, 0x22,
	0xE8, 0x03, 0x61, 0xA4, 0x78, 0xE3, 0xE9, 0xCF,
	0x48, 0x4A, 0xB0, 0x4F, 0x44, 0x7E, 0xFF, 0xF6,
	0xF0, 0xA4, 0x77, 0xCC, 0x2F, 0xC9, 0xBF, 0x54,
	0x89, 0x44,
};
static uint8_t CCM21_RES[] = {
	0x44, 0xA3, 0xAA, 0x3A, 0xAE, 0x64, 0x75, 0xCA,
	0xF2, 0xBE, 0xED, 0x7B, 0xC5, 0x09, 0x8E, 0x83,
	0xFE, 0xB5, 0xB3, 0x16, 0x08, 0xF8, 0xE2, 0x9C,
	0x38, 0x81, 0x9A, 0x89, 0xC8, 0xE7, 0x76, 0xF1,
	0x54, 0x4D, 0x41, 0x51, 0xA4, 0xED, 0x3A, 0x8B,
	0x87, 0xB9, 0xCE,
};
static uint8_t CCM22_RES[] = {
	0xEC, 0x46, 0xBB, 0x63, 0xB0, 0x25, 0x20, 0xC3,
	0x3C, 0x49, 0xFD, 0x70, 0x31, 0xD7, 0x50, 0xA0,
	0x9D, 0xA3, 0xED, 0x7F, 0xDD, 0xD4, 0x9A, 0x20,
	0x32, 0xAA, 0xBF, 0x17, 0xEC, 0x8E, 0xBF, 0x7D,
	0x22, 0xC8, 0x08, 0x8C, 0x66, 0x6B, 0xE5, 0xC1,
	0x97,
};
static uint8_t CCM23_RES[] = {
	0x47, 0xA6, 0x5A, 0xC7, 0x8B, 0x3D, 0x59, 0x42,
	0x27, 0xE8, 0x5E, 0x71, 0xE8, 0x82, 0xF1, 0xDB,
	0xD3, 0x8C, 0xE3, 0xED, 0xA7, 0xC2, 0x3F, 0x04,
	0xDD, 0x65, 0x07, 0x1E, 0xB4, 0x13, 0x42, 0xAC,
	0xDF, 0x7E, 0x00, 0xDC, 0xCE, 0xC7, 0xAE, 0x52,
	0x98, 0x7D,
};
static uint8_t CCM24_RES[] = {
	0x6E, 0x37, 0xA6, 0xEF, 0x54, 0x6D, 0x95, 0x5D,
	0x34, 0xAB, 0x60, 0x59, 0xF3, 0x29, 0x05, 0xB8,
	0x8A, 0x64, 0x1B, 0x04, 0xB9, 0xC9, 0xFF, 0xB5,
	0x8C, 0xC3, 0x90, 0x90, 0x0F, 0x3D, 0xA1, 0x2A,
	0xB1, 0x6D, 0xCE, 0x9E, 0x82, 0xEF, 0xA1, 0x6D,
	0xA6, 0x20, 0x59,
};

uint8_t *DATA_2[] = {
	CCM13_DATA, CCM14_DATA, CCM15_DATA, CCM16_DATA, CCM17_DATA, CCM18_DATA,
	CCM19_DATA, CCM20_DATA, CCM21_DATA, CCM22_DATA, CCM23_DATA, CCM24_DATA,
};

size_t DATALEN[] = {
	31, 32, 33, 31, 32, 33, 31, 32, 33, 31, 32, 33,
	sizeof (CCM13_DATA), sizeof (CCM14_DATA), sizeof (CCM15_DATA),
	sizeof (CCM16_DATA), sizeof (CCM17_DATA), sizeof (CCM18_DATA),
	sizeof (CCM19_DATA), sizeof (CCM20_DATA), sizeof (CCM21_DATA),
	sizeof (CCM22_DATA), sizeof (CCM23_DATA), sizeof (CCM24_DATA),
};

uint8_t *RES[] = {
	CCM1_RES, CCM2_RES, CCM3_RES, CCM4_RES, CCM5_RES, CCM6_RES,
	CCM7_RES, CCM8_RES, CCM9_RES, CCM10_RES, CCM11_RES, CCM12_RES,
	CCM13_RES, CCM14_RES, CCM15_RES, CCM16_RES, CCM17_RES, CCM18_RES,
	CCM19_RES, CCM20_RES, CCM21_RES, CCM22_RES, CCM23_RES, CCM24_RES,
};

size_t RESLEN[] = {
	sizeof (CCM1_RES), sizeof (CCM2_RES), sizeof (CCM3_RES),
	sizeof (CCM4_RES), sizeof (CCM5_RES), sizeof (CCM6_RES),
	sizeof (CCM7_RES), sizeof (CCM8_RES), sizeof (CCM9_RES),
	sizeof (CCM10_RES), sizeof (CCM11_RES), sizeof (CCM12_RES),
	sizeof (CCM13_RES), sizeof (CCM14_RES), sizeof (CCM15_RES),
	sizeof (CCM16_RES), sizeof (CCM17_RES), sizeof (CCM18_RES),
	sizeof (CCM19_RES), sizeof (CCM20_RES), sizeof (CCM21_RES),
	sizeof (CCM22_RES), sizeof (CCM23_RES), sizeof (CCM24_RES),
};

uint8_t *NONCE[] = {
	CCM1_N, CCM2_N, CCM3_N, CCM4_N, CCM5_N, CCM6_N, CCM7_N, CCM8_N,
	CCM9_N, CCM10_N, CCM11_N, CCM12_N, CCM13_N, CCM14_N, CCM15_N, CCM16_N,
	CCM17_N, CCM18_N, CCM19_N, CCM20_N, CCM21_N, CCM22_N, CCM23_N, CCM24_N,
};

size_t NONCELEN[] = {
	sizeof (CCM1_N), sizeof (CCM2_N), sizeof (CCM3_N), sizeof (CCM4_N),
	sizeof (CCM5_N), sizeof (CCM6_N), sizeof (CCM7_N), sizeof (CCM8_N),
	sizeof (CCM9_N), sizeof (CCM10_N), sizeof (CCM11_N), sizeof (CCM12_N),
	sizeof (CCM13_N), sizeof (CCM14_N), sizeof (CCM15_N), sizeof (CCM16_N),
	sizeof (CCM17_N), sizeof (CCM18_N), sizeof (CCM19_N), sizeof (CCM20_N),
	sizeof (CCM21_N), sizeof (CCM22_N), sizeof (CCM23_N), sizeof (CCM24_N),
};

size_t AUTHLEN[] = {
	8, 8, 8, 12, 12, 12, 8, 8, 8, 12, 12, 12,
	8, 8, 8, 12, 12, 12, 8, 8, 8, 12, 12, 12,
};

size_t MACLEN[] = {
	8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10,
	8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10,
};

#ifdef __cplusplus
}
#endif

#endif /* _AES_CCM_H */
