/*
 * This file and its contents are supplied under the terms of the
 * Common Development and Distribution License ("CDDL"), version 1.0.
 * You may only use this file in accordance with the terms of version
 * 1.0 of the CDDL.
 *
 * A full copy of the text of the CDDL should have accompanied this
 * source.  A copy of the CDDL is also available via the Internet at
 * http://www.illumos.org/license/CDDL.
 */

/*
 * Copyright 2015 Nexenta Systems, Inc.  All rights reserved.
 * Copyright 2019 Joyent, Inc.
 */

#ifndef _AES_CBC_PAD_H
#define	_AES_CBC_PAD_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * A search for test vectors that included PKCS7 padding has proven
 * unsuccessful.  Instead, a few of the test aes_cbc test vectors
 * were used as a starting point, adding extra data to the xx_DATA[]
 * arrays to test padding.
 *
 * To compute the xx_RES[] (encrypted) values, openssl on an machine
 * running macOS Mojave was used.
 */

static uint8_t CBC_PAD1_KEY[16] = {
	0x06, 0xa9, 0x21, 0x40, 0x36, 0xb8, 0xa1, 0x5b,
	0x51, 0x2e, 0x03, 0xd5, 0x34, 0x12, 0x00, 0x06,
};
static uint8_t CBC_PAD1_IV[16] = {
	0x3d, 0xaf, 0xba, 0x42, 0x9d, 0x9e, 0xb4, 0x30,
	0xb4, 0x22, 0xda, 0x80, 0x2c, 0x9f, 0xac, 0x41,
};
static uint8_t CBC_PAD1_DATA[] = {
	'S', 'i', 'n', 'g', 'l', 'e', ' ', 'b',
	'l', 'o', 'c', 'k', ' ', 'm', 's', 'g',
};

static uint8_t CBC_PAD1_RES[] = {
	0xe3, 0x53, 0x77, 0x9c, 0x10, 0x79, 0xae, 0xb8,
	0x27, 0x08, 0x94, 0x2d, 0xbe, 0x77, 0x18, 0x1a,

	0xb9, 0x7c, 0x82, 0x5e, 0x1c, 0x78, 0x51, 0x46,
	0x54, 0x2d, 0x39, 0x69, 0x41, 0xbc, 0xe5, 0x5d
};


static uint8_t CBC_PAD2_KEY[] = {
	0xc2, 0x86, 0x69, 0x6d, 0x88, 0x7c, 0x9a, 0xa0,
	0x61, 0x1b, 0xbb, 0x3e, 0x20, 0x25, 0xa4, 0x5a,
};
static uint8_t CBC_PAD2_IV[] = {
	0x56, 0x2e, 0x17, 0x99, 0x6d, 0x09, 0x3d, 0x28,
	0xdd, 0xb3, 0xba, 0x69, 0x5a, 0x2e, 0x6f, 0x58,
};
static uint8_t CBC_PAD2_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,

	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
};

static uint8_t CBC_PAD2_RES[] = {
	0xd2, 0x96, 0xcd, 0x94, 0xc2, 0xcc, 0xcf, 0x8a,
	0x3a, 0x86, 0x30, 0x28, 0xb5, 0xe1, 0xdc, 0x0a,

	0x75, 0x86, 0x60, 0x2d, 0x25, 0x3c, 0xff, 0xf9,
	0x1b, 0x82, 0x66, 0xbe, 0xa6, 0xd6, 0x1a, 0xb1,

	0xbc, 0xfd, 0x81, 0x02, 0x22, 0x02, 0x36, 0x6b,
	0xde, 0x6d, 0xd2, 0x60, 0xa1, 0x58, 0x41, 0xa1
};


static uint8_t CBC_PAD3_KEY[] = {
	0xc2, 0x86, 0x69, 0x6d, 0x88, 0x7c, 0x9a, 0xa0,
	0x61, 0x1b, 0xbb, 0x3e, 0x20, 0x25, 0xa4, 0x5a,
};
static uint8_t CBC_PAD3_IV[] = {
	0x56, 0x2e, 0x17, 0x99, 0x6d, 0x09, 0x3d, 0x28,
	0xdd, 0xb3, 0xba, 0x69, 0x5a, 0x2e, 0x6f, 0x58,
};

static uint8_t CBC_PAD3_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,

	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x00,
};

static uint8_t CBC_PAD3_RES[] = {
	0xd2, 0x96, 0xcd, 0x94, 0xc2, 0xcc, 0xcf, 0x8a,
	0x3a, 0x86, 0x30, 0x28, 0xb5, 0xe1, 0xdc, 0x0a,

	0x75, 0x86, 0x60, 0x2d, 0x25, 0x3c, 0xff, 0xf9,
	0x1b, 0x82, 0x66, 0xbe, 0xa6, 0xd6, 0x1a, 0xb1,

	0xde, 0xf6, 0x23, 0xa9, 0xc6, 0xf5, 0xc6, 0xb9,
	0x56, 0x14, 0x49, 0x60, 0xb2, 0x3d, 0x2f, 0x7f
};


static uint8_t CBC_PAD4_KEY[] = {
	0xc2, 0x86, 0x69, 0x6d, 0x88, 0x7c, 0x9a, 0xa0,
	0x61, 0x1b, 0xbb, 0x3e, 0x20, 0x25, 0xa4, 0x5a,
};

static uint8_t CBC_PAD4_IV[] = {
	0x56, 0x2e, 0x17, 0x99, 0x6d, 0x09, 0x3d, 0x28,
	0xdd, 0xb3, 0xba, 0x69, 0x5a, 0x2e, 0x6f, 0x58,
};

static uint8_t CBC_PAD4_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,

	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x00, 0x01,
};

static uint8_t CBC_PAD4_RES[] = {
	0xd2, 0x96, 0xcd, 0x94, 0xc2, 0xcc, 0xcf, 0x8a,
	0x3a, 0x86, 0x30, 0x28, 0xb5, 0xe1, 0xdc, 0x0a,

	0x75, 0x86, 0x60, 0x2d, 0x25, 0x3c, 0xff, 0xf9,
	0x1b, 0x82, 0x66, 0xbe, 0xa6, 0xd6, 0x1a, 0xb1,

	0x30, 0xce, 0x1d, 0xd5, 0xd1, 0xb3, 0x0e, 0xde,
	0x59, 0x9c, 0x3b, 0x31, 0x1b, 0x62, 0xf0, 0x23
};


static uint8_t CBC_PAD5_KEY[] = {
	0xc2, 0x86, 0x69, 0x6d, 0x88, 0x7c, 0x9a, 0xa0,
	0x61, 0x1b, 0xbb, 0x3e, 0x20, 0x25, 0xa4, 0x5a,
};

static uint8_t CBC_PAD5_IV[] = {
	0x56, 0x2e, 0x17, 0x99, 0x6d, 0x09, 0x3d, 0x28,
	0xdd, 0xb3, 0xba, 0x69, 0x5a, 0x2e, 0x6f, 0x58,
};

static uint8_t CBC_PAD5_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,

	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d,
};

static uint8_t CBC_PAD5_RES[] = {
	0xd2, 0x96, 0xcd, 0x94, 0xc2, 0xcc, 0xcf, 0x8a,
	0x3a, 0x86, 0x30, 0x28, 0xb5, 0xe1, 0xdc, 0x0a,

	0x75, 0x86, 0x60, 0x2d, 0x25, 0x3c, 0xff, 0xf9,
	0x1b, 0x82, 0x66, 0xbe, 0xa6, 0xd6, 0x1a, 0xb1,

	0xd3, 0x1c, 0x5a, 0x9d, 0xc4, 0x37, 0xa7, 0x7a,
	0x74, 0xca, 0xb3, 0x69, 0x2b, 0x7b, 0x1f, 0xad
};


static uint8_t CBC_PAD6_KEY[] = {
	0xc2, 0x86, 0x69, 0x6d, 0x88, 0x7c, 0x9a, 0xa0,
	0x61, 0x1b, 0xbb, 0x3e, 0x20, 0x25, 0xa4, 0x5a,
};

static uint8_t CBC_PAD6_IV[] = {
	0x56, 0x2e, 0x17, 0x99, 0x6d, 0x09, 0x3d, 0x28,
	0xdd, 0xb3, 0xba, 0x69, 0x5a, 0x2e, 0x6f, 0x58,
};

static uint8_t CBC_PAD6_DATA[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,

	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
};

static uint8_t CBC_PAD6_RES[] = {
	0xd2, 0x96, 0xcd, 0x94, 0xc2, 0xcc, 0xcf, 0x8a,
	0x3a, 0x86, 0x30, 0x28, 0xb5, 0xe1, 0xdc, 0x0a,

	0x75, 0x86, 0x60, 0x2d, 0x25, 0x3c, 0xff, 0xf9,
	0x1b, 0x82, 0x66, 0xbe, 0xa6, 0xd6, 0x1a, 0xb1,

	0x79, 0x33, 0x83, 0xff, 0x4a, 0x64, 0x9d, 0xe3,
	0x4d, 0x6f, 0x19, 0x94, 0x28, 0x7d, 0x65, 0x67
};

uint8_t *DATA[] = {
	CBC_PAD1_DATA, CBC_PAD2_DATA, CBC_PAD3_DATA,
	CBC_PAD4_DATA, CBC_PAD5_DATA, CBC_PAD6_DATA,
};

size_t DATALEN[] = {
	sizeof (CBC_PAD1_DATA), sizeof (CBC_PAD2_DATA),
	sizeof (CBC_PAD3_DATA), sizeof (CBC_PAD4_DATA),
	sizeof (CBC_PAD5_DATA), sizeof (CBC_PAD6_DATA),
};

uint8_t *KEY[] = {
	CBC_PAD1_KEY, CBC_PAD2_KEY, CBC_PAD3_KEY,
	CBC_PAD4_KEY, CBC_PAD5_KEY, CBC_PAD6_KEY,
};

size_t KEYLEN[] = {
	sizeof (CBC_PAD1_KEY), sizeof (CBC_PAD2_KEY),
	sizeof (CBC_PAD3_KEY), sizeof (CBC_PAD4_KEY),
	sizeof (CBC_PAD5_KEY), sizeof (CBC_PAD6_KEY),
};

uint8_t *IV[] = {
	CBC_PAD1_IV, CBC_PAD2_IV, CBC_PAD3_IV,
	CBC_PAD4_IV, CBC_PAD5_IV, CBC_PAD6_IV,
};

size_t IVLEN[] = {
	sizeof (CBC_PAD1_IV), sizeof (CBC_PAD2_IV),
	sizeof (CBC_PAD3_IV), sizeof (CBC_PAD4_IV),
	sizeof (CBC_PAD5_IV), sizeof (CBC_PAD6_IV),
};

uint8_t *RES[] = {
	CBC_PAD1_RES, CBC_PAD2_RES, CBC_PAD3_RES,
	CBC_PAD4_RES, CBC_PAD5_RES, CBC_PAD6_RES,
};

size_t RESLEN[] = {
	sizeof (CBC_PAD1_RES), sizeof (CBC_PAD2_RES),
	sizeof (CBC_PAD3_RES), sizeof (CBC_PAD4_RES),
	sizeof (CBC_PAD5_RES), sizeof (CBC_PAD6_RES),
};

#ifdef __cplusplus
}
#endif

#endif /* _AES_CBC_PAD_H */
