#
# This file and its contents are supplied under the terms of the
# Common Development and Distribution License ("CDDL"), version 1.0.
# You may only use this file in accordance with the terms of version
# 1.0 of the CDDL.
#
# A full copy of the text of the CDDL should have accompanied this
# source.  A copy of the CDDL is also available via the Internet
# at http://www.illumos.org/license/CDDL.
#

#
# Copyright 2011, Richard Lowe
# Copyright 2017 Nexenta Systems, Inc.
#

MANDOC=		$(ONBLD_TOOLS)/bin/${MACH}/mandoc
ROOTMAN=	$(ROOT)/usr/share/man
ROOTHASMAN=	$(ROOT)/usr/has/man
FILEMODE=	0444

# The manual section being built, client Makefiles must set this to, for e.g.
# "3perl", with case matching that of the section name as installed.
#
# MANSECT=

MANCHECKS=	$(MANFILES:%=%.check)
ROOTMANFILES=	$(MANFILES:%=$(ROOTMAN)/man$(MANSECT)/%)
ROOTMANLINKS=	$(MANLINKS:%=$(ROOTMAN)/man$(MANSECT)/%)

$(ROOTMAN)/man$(MANSECT) $(ROOTHASMAN)/man$(MANSECT):
		$(INS.dir)

$(ROOTHASMAN)/man$(MANSECT)/%: % $(ROOTHASMAN)/man$(MANSECT)
		$(INS.file)

$(ROOTMAN)/man$(MANSECT)/% : % $(ROOTMAN)/man$(MANSECT)
		$(INS.file)

#
# Note that new mandoc adds some checks for lots of extra whitespace.
# We don't want to check our legacy pages for that.  There are thousands
# and thousands of them in our man pages.  Please still check them
# manually when editing (git pbchk will do so for you.)
#
$(MANCHECKS):
		@$(ECHO) "checking $(@:%.check=%)"; \
		if $(EGREP) -q "^.TH" $(@:%.check=%); then \
		$(MANDOC) -Tlint -Werror $(@:%.check=%); \
		else; \
		$(MANDOC) -Tlint -Wwarning $(@:%.check=%); \
		fi

$(MANLINKS):
		$(RM) $@; $(SYMLINK) $(LINKSRC) $@

$(ROOTMANLINKS): $(MANLINKS) $(ROOTMAN)/man$(MANSECT)
		$(RM) $@; $(CP) -RP $(@F) $(@D)

all:

check:		$(MANCHECKS)

clean:

clobber:
		$(RM) $(MANLINKS)

.PARALLEL:

FRC:
