#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#

#
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
#

#
# Generate the table mapping NT status codes to strings.
# The table is sorted in numerical order by putting the
# numeric constants as a comment first on each line, and
# then running the table body through sort(1).
#

BEGIN {
	printf("/* Table generated by smb_status_gen.awk */\n");
	printf("#include <smb/ntstatus.h>\n\n");
	printf("typedef struct smb_status_table {\n");
	printf("\tunsigned int value;\n");
	printf("\tconst char *name;\n");
	printf("} smb_status_table_t;\n\n");
	printf("static const smb_status_table_t ntx_table[] = {\n");
}
/^#define.NT_STATUS_/ {
	# Skip the _SEVERITY defines.
	if ( $2 ~ /^NT_STATUS_SEVERITY_/ )
		next


	# Make sure the constant looks as expected.
	if ( $3 !~ /^0x[0-9A-F]+$/ ) {
		print "Warning: Unexpected format: "$0 > "/dev/stderr"
		exit 1;
	}

	# print: comment { macro, string },
	printf("\t/* %s */\t{ %s,\t\"%s\" },\n",
		$3, $2, substr($2,11)) | "sort" ;
}
END {
	close("sort");
	printf("};\n");
}
