/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright (c) 1994, 2010, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2017 Nexenta Systems, Inc.  All rights reserved.
 */

/*	Copyright (c) 1983, 1984, 1985, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved	*/

/*
 * Portions of this source code were derived from Berkeley 4.3 BSD
 * under license from the Regents of the University of California.
 */

/*
 * Modified version of syscall/unlink.c
 */

#include <sys/param.h>
#include <sys/isa_defs.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <sys/systm.h>
#include <sys/errno.h>
#include <sys/vnode.h>
#include <sys/vfs.h>
#include <sys/uio.h>
#include <sys/debug.h>
#include <sys/file.h>
#include <sys/fcntl.h>

#include <libfksmbfs.h>

/*
 * Unlink a file from a directory
 * Like syscall/unlinkat.c
 */
int
fake_unlink(char *path, int flags)
{
	vnode_t *dvp = NULL;
	char *lastcomp = NULL;
	int error;

	if (path == NULL)
		return (EFAULT);

	error = fake_lookup_dir(path, &dvp, &lastcomp);
	if (error != 0)
		return (error);

	/*
	 * Some logic from vn_removeat() here
	 */
	if (dvp->v_vfsp->vfs_flag & VFS_RDONLY) {
		error = EROFS;
		goto out;
	}

	if (flags == AT_REMOVEDIR) {
		error = VOP_RMDIR(dvp, lastcomp, NULL, CRED(), NULL, 0);
	} else {
		error = VOP_REMOVE(dvp, lastcomp, CRED(), NULL, 0);
	}

out:
	if (dvp != NULL)
		VN_RELE(dvp);

	return (error);
}
