/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1995-1998 by Sun Microsystems, Inc.
 * All rights reserved.
 */

/* LINTLIBRARY */

/*
 * vw_print.c
 *
 * XCurses Library
 *
 * Copyright 1990, 1995 by Mortice Kern Systems Inc.  All rights reserved.
 *
 */

#if M_RCSID
#ifndef lint
static char rcsID[] = "$Header: /rd/src/libc/xcurses/rcs/vw_print.c 1.3 "
"1995/08/30 19:37:28 danv Exp $";
#endif
#endif

#include <private.h>
#include <stdarg.h>

int
vw_printw(WINDOW *w, char *fmt, va_list ap)
{
	int	size = BUFSIZ;
	char	*buffer;
	int	n, rv;

	buffer = (char *)malloc(size);
	if (buffer == NULL)
		return (ERR);

	/* CONSTCOND */
	while (1) {
		n = vsnprintf(buffer, size, fmt, ap);
		if (n < size)
			break;
		size *= 2;
		buffer = (char *)realloc(buffer, size);
		if (buffer == NULL)
			return (ERR);
	}
	va_end(ap);
	rv = waddnstr(w, buffer, -1);
	free(buffer);
	return (rv);
}
