/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1995-1998 by Sun Microsystems, Inc.
 * All rights reserved.
 */

/* LINTLIBRARY */

/*
 * killchar.c
 *
 * XCurses Library
 *
 * Copyright 1990, 1995 by Mortice Kern Systems Inc.  All rights reserved.
 *
 */

#if M_RCSID
#ifndef lint
static char rcsID[] =
"$Header: /team/ps/sun_xcurses/archive/local_changes/xcurses/src/lib/"
"libxcurses/src/libc/xcurses/rcs/killchar.c 1.2 1998/06/04 19:55:50 "
"cbates Exp $";
#endif
#endif

#include <private.h>

char
erasechar(void)
{
	char ch;

	/*
	 * Refer to _shell instead of _prog, since _shell will
	 * correctly reflect the user's prefered settings, whereas
	 * _prog may not have been initialised if both input and
	 * output have been redirected.
	 */
	ch = (char)PTERMIOS(_shell)->c_cc[VERASE];

	return (ch);
}

char
killchar(void)
{
	char ch;

	/*
	 * Refer to _shell instead of _prog, since _shell will
	 * correctly reflect the user's prefered settings, whereas
	 * _prog may not have been initialised if both input and
	 * output have been redirected.
	 */
	ch = (char)PTERMIOS(_shell)->c_cc[VKILL];

	return (ch);
}
