/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 * All rights reserved.
 */

/*
 * delay.c
 *
 * XCurses Library
 *
 * Copyright 1990, 1995 by Mortice Kern Systems Inc.  All rights reserved.
 *
 */

#ifdef M_RCSID
#ifndef lint
static char rcsID[] = "$Header: /rd/src/libc/xcurses/rcs/delay.c 1.1 1995/06/05 19:32:22 ant Exp $";
#endif
#endif

#include <private.h>

/*
 * Insert an N milli-second delay by inserting pad characters
 * into the output stream.
 */
int
delay_output(ms)
int ms;
{
	int null = '\0';
	unsigned number, baud;

#ifdef M_CURSES_TRACE
	__m_trace("delay_output(%d)", ms);
#endif

	baud = baudrate();

	if (!no_pad_char) {
		if (pad_char != (char *) 0)
			null = *pad_char;
		number = (baud/10 * ms)/1000;
		while (0 < number--)
			(void) __m_putchar(null);
	}

	return __m_return_code("delay_output", OK);
}

