/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 1999 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_DISPLAY_H
#define	_DISPLAY_H

#ifdef	__cplusplus
extern "C" {
#endif

extern int logging;
extern int print_flag;

#define	NOPRINT		0
#define	PRINT		1
#define	MX_SBUS_SLOTS	4

/*
 * Define a structure to contain both the DRAM SIMM and NVRAM
 * SIMM memory totals in MBytes.
 */
struct mem_total {
	int dram;
	int nvsimm;
};

/* Functions in common display.c module */
void disp_powerfail(Prom_node *);
void log_printf(char *, ...);
char *get_time(uchar_t *);
void print_header(int);

#ifdef	__cplusplus
}
#endif

#endif	/* _DISPLAY_H */
