/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2011 Nexenta Systems, Inc.  All rights reserved.
 */
/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Let arg(x) denote a double precision number near x such that both
 * sin(arg(x)) and cos(arg(x)) are approximated by double precision
 * numbers to within a relative error less than 2^-61.
 *
 * Then for i = 5, ..., 101
 *
 *   __vlibm_TBL_sincos2[4*i]   := arg(i/128),
 *   __vlibm_TBL_sincos2[4*i+1] := sin(arg(i/128)), and
 *   __vlibm_TBL_sincos2[4*i+2] := cos(arg(i/128))
 *
 * (For i = 0, ..., 4, use zero instead of arg(i/128) above.)
 */
const double __vlibm_TBL_sincos2[] = {
 0.0000000000000000000e+00, 0.0000000000000000000e+00, 1.0000000000000000000e+00, 0.0,
 0.0000000000000000000e+00, 0.0000000000000000000e+00, 1.0000000000000000000e+00, 0.0,
 0.0000000000000000000e+00, 0.0000000000000000000e+00, 1.0000000000000000000e+00, 0.0,
 0.0000000000000000000e+00, 0.0000000000000000000e+00, 1.0000000000000000000e+00, 0.0,
 0.0000000000000000000e+00, 0.0000000000000000000e+00, 1.0000000000000000000e+00, 0.0,
 3.9062500000301640657e-02, 3.9052566650723562203e-02, 9.9923715755469721955e-01, 0.0,
 4.6874999999606224710e-02, 4.6857835747740897436e-02, 9.9890156833846133200e-01, 0.0,
 5.4687499999642848192e-02, 5.4660244884709843771e-02, 9.9850501131899360718e-01, 0.0,
 6.2500000000560454461e-02, 6.2459317842939558740e-02, 9.9804751070006414437e-01, 0.0,
 7.0312499999974784060e-02, 7.0254578604834888589e-02, 9.9752909440529957674e-01, 0.0,
 7.8125000000139249723e-02, 7.8045551390106132628e-02, 9.9694979407601780341e-01, 0.0,
 8.5937500000010338952e-02, 8.5831760676889648498e-02, 9.9630964506979713402e-01, 0.0,
 9.3749999999981376009e-02, 9.3612731235494350823e-02, 9.9560868645800348897e-01, 0.0,
 1.0156249999991998068e-01, 1.0138798815545004006e-01, 9.9484696102354874814e-01, 0.0,
 1.0937499999996859457e-01, 1.0915705687529114742e-01, 9.9402451525821255984e-01, 0.0,
 1.1718749999982362719e-01, 1.1691946321080448623e-01, 9.9314139935987832963e-01, 0.0,
 1.2500000000009922618e-01, 1.2467473338532614191e-01, 9.9219766722931668212e-01, 0.0,
 1.3281249999975877629e-01, 1.3242239405610808922e-01, 9.9119337646720018231e-01, 0.0,
 1.4062500000063443695e-01, 1.4016197234769187108e-01, 9.9012858837001815893e-01, 0.0,
 1.4843749999955710428e-01, 1.4789299587297158323e-01, 9.8900336792738841041e-01, 0.0,
 1.5624999999999389377e-01, 1.5561499277355000936e-01, 9.8781778381647289411e-01, 0.0,
 1.6406250000016783797e-01, 1.6332749173677843513e-01, 9.8657190839947017658e-01, 0.0,
 1.7187500000029506952e-01, 1.7103002203168574114e-01, 9.8526581771816335031e-01, 0.0,
 1.7968750000084471319e-01, 1.7872211353598477235e-01, 9.8389959148951300349e-01, 0.0,
 1.8749999999944111373e-01, 1.8640329676172079365e-01, 9.8247331310135943561e-01, 0.0,
 1.9531249999999666933e-01, 1.9407310289290652383e-01, 9.8098706960566983692e-01, 0.0,
 2.0312500000009747758e-01, 2.0173106380173427832e-01, 9.7944095171552869594e-01, 0.0,
 2.1093750000010619283e-01, 2.0937671208609748286e-01, 9.7783505379793755896e-01, 0.0,
 2.1875000000030794811e-01, 2.1700958109531076623e-01, 9.7616947386856844915e-01, 0.0,
 2.2656249999987468358e-01, 2.2462920495758317840e-01, 9.7444431358601713011e-01, 0.0,
 2.3437500000010527690e-01, 2.3223511861161386105e-01, 9.7265967824488830384e-01, 0.0,
 2.4218749999999975020e-01, 2.3982685783066132190e-01, 9.7081567677034952268e-01, 0.0,
 2.4999999999974262255e-01, 2.4740395925427355328e-01, 9.6891242171070846023e-01, 0.0,
 2.5781250000144378953e-01, 2.5496596041727453974e-01, 9.6695002923030970443e-01, 0.0,
 2.6562500000037131409e-01, 2.6251239976951157296e-01, 9.6492861910467353503e-01, 0.0,
 2.7343750000018046675e-01, 2.7004281671875879356e-01, 9.6284831470933096575e-01, 0.0,
 2.8125000000148109303e-01, 2.7755675164775922559e-01, 9.6070924301515081556e-01, 0.0,
 2.8906250000049193982e-01, 2.8505374594101895447e-01, 9.5851153458108839800e-01, 0.0,
 2.9687499999876038048e-01, 2.9253334202214215098e-01, 9.5625532354353792730e-01, 0.0,
 3.0468750000020183855e-01, 2.9999508337887559328e-01, 9.5394074760883418307e-01, 0.0,
 3.1249999999968136599e-01, 3.0743851458007764865e-01, 9.5156794804827016243e-01, 0.0,
 3.2031250000105265796e-01, 3.1486318132074436749e-01, 9.4913706968413158460e-01, 0.0,
 3.2812499999976940668e-01, 3.2226863043316833490e-01, 9.4664826088612763488e-01, 0.0,
 3.3593749999946614926e-01, 3.2965440993035616257e-01, 9.4410167355718033200e-01, 0.0,
 3.4375000000042527093e-01, 3.3702006902265346788e-01, 9.4149746312773774370e-01, 0.0,
 3.5156249999849442656e-01, 3.4436515814428492188e-01, 9.3883578854678395587e-01, 0.0,
 3.5937500000102234887e-01, 3.5168922899577109709e-01, 9.3611681226669574141e-01, 0.0,
 3.6718749999811656215e-01, 3.5899183454430716456e-01, 9.3334070024322457471e-01, 0.0,
 3.7500000000009731105e-01, 3.6627252908613811000e-01, 9.3050762191227864850e-01, 0.0,
 3.8281249999980870857e-01, 3.7353086823851550102e-01, 9.2761775019292336264e-01, 0.0,
 3.9062500000029726221e-01, 3.8076640899266506191e-01, 9.2467126146692291133e-01, 0.0,
 3.9843749999969407805e-01, 3.8797870972674308732e-01, 9.2166833557347060957e-01, 0.0,
 4.0625000000035305092e-01, 3.9516733024125855200e-01, 9.1860915579477875337e-01, 0.0,
 4.1406249999977551290e-01, 4.0233183177756759452e-01, 9.1549390884839154658e-01, 0.0,
 4.2187500000064509509e-01, 4.0947177705388360103e-01, 9.1232278487185369809e-01, 0.0,
 4.2968750000090671914e-01, 4.1658673028286541395e-01, 9.0909597741505332458e-01, 0.0,
 4.3749999999977579046e-01, 4.2367625720373491838e-01, 9.0581368342603141297e-01, 0.0,
 4.4531249999998151479e-01, 4.3073992511078651457e-01, 9.0247610323794946741e-01, 0.0,
 4.5312499999986916022e-01, 4.3777730287263749709e-01, 8.9908344056019573465e-01, 0.0,
 4.6093749998776573085e-01, 4.4478796095356976092e-01, 8.9563590246861235489e-01, 0.0,
 4.6874999999894750857e-01, 4.5177147149074481369e-01, 8.9213369936746989008e-01, 0.0,
 4.7656249999993238742e-01, 4.5872740821667651323e-01, 8.8857704502806655888e-01, 0.0,
 4.8437500000085281782e-01, 4.6565534658591489769e-01, 8.8496615652574617261e-01, 0.0,
 4.9218750000026373348e-01, 4.7255486375153687995e-01, 8.8130125425121597083e-01, 0.0,
 5.0000000000063071770e-01, 4.7942553860475650707e-01, 8.7758256189007033399e-01, 0.0,
 5.0781250000246225262e-01, 4.8626695179542711589e-01, 8.7381030641185719610e-01, 0.0,
 5.1562499999926780792e-01, 4.9307868575328606120e-01, 8.6998471805877841678e-01, 0.0,
 5.2343749999866429068e-01, 4.9986032473185659786e-01, 8.6610603032132438273e-01, 0.0,
 5.3125000000045408122e-01, 5.0661145481464886497e-01, 8.6217447993465046174e-01, 0.0,
 5.3906250000013333779e-01, 5.1333166394358564766e-01, 8.5819030686259190066e-01, 0.0,
 5.4687499999851685306e-01, 5.2002054195246016910e-01, 8.5415375427815665166e-01, 0.0,
 5.5468749999993749444e-01, 5.2667768059033359673e-01, 8.5006506854945318441e-01, 0.0,
 5.6249999999973876452e-01, 5.3330267353579918765e-01, 8.4592449923120727195e-01, 0.0,
 5.7031249999981425969e-01, 5.3989511643504806138e-01, 8.4173229904143864744e-01, 0.0,
 5.7812499995867461244e-01, 5.4645460688459401855e-01, 8.3748872387310613341e-01, 0.0,
 5.8593749999782485105e-01, 5.5298074462871504853e-01, 8.3319403266578417888e-01, 0.0,
 5.9374999999819222385e-01, 5.5947313124586850464e-01, 8.2884848761033713682e-01, 0.0,
 6.0156250000116751053e-01, 5.6593137050886854755e-01, 8.2445235391376847645e-01, 0.0,
 6.0937499999740707413e-01, 5.7235506823238102569e-01, 8.2000589989871808250e-01, 0.0,
 6.1718749999640543091e-01, 5.7874383235483894961e-01, 8.1550939694845581140e-01, 0.0,
 6.2500000000776623210e-01, 5.8509727294676028286e-01, 8.1096311950067390129e-01, 0.0,
 6.3281250000034772185e-01, 5.9141500220159670675e-01, 8.0636734505489826574e-01, 0.0,
 6.4062499999937538853e-01, 5.9769663453820076615e-01, 8.0172235409879177848e-01, 0.0,
 6.4843750000738653583e-01, 6.0394178656004393613e-01, 7.9702843013700730435e-01, 0.0,
 6.5625000000061406435e-01, 6.1015007707627788580e-01, 7.9228585967680387192e-01, 0.0,
 6.6406249999753186319e-01, 6.1632112717960729764e-01, 7.8749493216912724858e-01, 0.0,
 6.7187500000431277236e-01, 6.2245456022571910015e-01, 7.8265594002358829240e-01, 0.0,
 6.7968749999981381560e-01, 6.2855000184488485360e-01, 7.7776917860043492947e-01, 0.0,
 6.8749999999877509094e-01, 6.3460708001432264425e-01, 7.7283494615324888066e-01, 0.0,
 6.9531250000506295006e-01, 6.4062542504411801314e-01, 7.6785354383960691127e-01, 0.0,
 7.0312499999963207209e-01, 6.4660466959087170569e-01, 7.6282527571081415463e-01, 0.0,
 7.1093749999987698729e-01, 6.5254444872567274327e-01, 7.5775044865529961324e-01, 0.0,
 7.1875000000017263968e-01, 6.5844439991069747542e-01, 7.5262937241795280219e-01, 0.0,
 7.2656250000154842805e-01, 6.6430416304410366823e-01, 7.4746235956218753937e-01, 0.0,
 7.3437500000182720505e-01, 6.7012338047451913692e-01, 7.4224972545727685436e-01, 0.0,
 7.4218750000178623782e-01, 6.7590169702749525182e-01, 7.3699178825503341983e-01, 0.0,
 7.5000000000121047616e-01, 6.8163876002421985856e-01, 7.3168886887299577904e-01, 0.0,
 7.5781249999863331546e-01, 6.8733421930288085555e-01, 7.2634129097504795958e-01, 0.0,
 7.6562500000199784633e-01, 6.9298772724775825615e-01, 7.2094938094431193498e-01, 0.0,
 7.7343750000033728575e-01, 6.9859893878992307403e-01, 7.1551346788274594601e-01, 0.0,
 7.8125000000087474472e-01, 7.0416751145515477095e-01, 7.1003388356546370819e-01, 0.0,
 7.8906249999555477803e-01, 7.0969310536076801732e-01, 7.0451096244372934940e-01, 0.0,
};
