/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2011 Nexenta Systems, Inc.  All rights reserved.
 */
/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Table of constants for 2/pi, used in __rem_pio2l (trigl) function.
 * By K.C. Ng, April 25, 1989
 */

#include "libm.h"

const int _TBL_ipio2l_inf[] = { /* by DHBailey MP package */
	0xA2F983, 0x6E4E44, 0x1529FC, 0x2757D1, 0xF534DD, 0xC0DB62,
	0x95993C, 0x439041, 0xFE5163, 0xABDEBB, 0xC561B7, 0x246E3A,
	0x424DD2, 0xE00649, 0x2EEA09, 0xD1921C, 0xFE1DEB, 0x1CB129,
	0xA73EE8, 0x8235F5, 0x2EBB44, 0x84E99C, 0x7026B4, 0x5F7E41,
	0x3991D6, 0x398353, 0x39F49C, 0x845F8B, 0xBDF928, 0x3B1FF8,
	0x97FFDE, 0x05980F, 0xEF2F11, 0x8B5A0A, 0x6D1F6D, 0x367ECF,
	0x27CB09, 0xB74F46, 0x3F669E, 0x5FEA2D, 0x7527BA, 0xC7EBE5,
	0xF17B3D, 0x0739F7, 0x8A5292, 0xEA6BFB, 0x5FB11F, 0x8D5D08,
	0x560330, 0x46FC7B, 0x6BABF0, 0xCFBC20, 0x9AF436, 0x1DA9E3,
	0x91615E, 0xE61B08, 0x659985, 0x5F14A0, 0x68408D, 0xFFD880,
	0x4D7327, 0x310606, 0x1556CA, 0x73A8C9, 0x60E27B, 0xC08C6B,
	0x47C419, 0xC367CD, 0xDCE809, 0x2A8359, 0xC4768B, 0x961CA6,
	0xDDAF44, 0xD15719, 0x053EA5, 0xFF0705, 0x3F7E33, 0xE832C2,
	0xDE4F98, 0x327DBB, 0xC33D26, 0xEF6B1E, 0x5EF89F, 0x3A1F35,
	0xCAF27F, 0x1D87F1, 0x21907C, 0x7C246A, 0xFA6ED5, 0x772D30,
	0x433B15, 0xC614B5, 0x9D19C3, 0xC2C4AD, 0x414D2C, 0x5D000C,
	0x467D86, 0x2D71E3, 0x9AC69B, 0x006233, 0x7CD2B4, 0x97A7B4,
	0xD55537, 0xF63ED7, 0x1810A3, 0xFC764D, 0x2A9D64, 0xABD770,
	0xF87C63, 0x57B07A, 0xE71517, 0x5649C0, 0xD9D63B, 0x3884A7,
	0xCB2324, 0x778AD6, 0x23545A, 0xB91F00, 0x1B0AF1, 0xDFCE19,
	0xFF319F, 0x6A1E66, 0x615799, 0x47FBAC, 0xD87F7E, 0xB76522,
	0x89E832, 0x60BFE6, 0xCDC4EF, 0x09366C, 0xD43F5D, 0xD7DE16,
	0xDE3B58, 0x929BDE, 0x2822D2, 0xE88628, 0x4D58E2, 0x32CAC6,
	0x16E308, 0xCB7DE0, 0x50C017, 0xA71DF3, 0x5BE018, 0x34132E,
	0x621283, 0x014883, 0x5B8EF5, 0x7FB0AD, 0xF2E91E, 0x434A48,
	0xD36710, 0xD8DDAA, 0x425FAE, 0xCE616A, 0xA4280A, 0xB499D3,
	0xF2A606, 0x7F775C, 0x83C2A3, 0x883C61, 0x78738A, 0x5A8CAF,
	0xBDD76F, 0x63A62D, 0xCBBFF4, 0xEF818D, 0x67C126, 0x45CA55,
	0x36D9CA, 0xD2A828, 0x8D61C2, 0x77C912, 0x142604, 0x9B4612,
	0xC459C4, 0x44C5C8, 0x91B24D, 0xF31700, 0xAD43D4, 0xE54929,
	0x10D5FD, 0xFCBE00, 0xCC941E, 0xEECE70, 0xF53E13, 0x80F1EC,
	0xC3E7B3, 0x28F8C7, 0x940593, 0x3E71C1, 0xB3092E, 0xF3450B,
	0x9C1288, 0x7B20AB, 0x9FB52E, 0xC29247, 0x2F327B, 0x6D550C,
	0x90A772, 0x1FE76B, 0x96CB31, 0x4A1679, 0xE27941, 0x89DFF4,
	0x9794E8, 0x84E6E2, 0x973199, 0x6BED88, 0x365F5F, 0x0EFDBB,
	0xB49A48, 0x6CA467, 0x427271, 0x325D8D, 0xB8159F, 0x09E5BC,
	0x25318D, 0x3974F7, 0x1C0530, 0x010C0D, 0x68084B, 0x58EE2C,
	0x90AA47, 0x02E774, 0x24D6BD, 0xA67DF7, 0x72486E, 0xEF169F,
	0xA6948E, 0xF691B4, 0x5153D1, 0xF20ACF, 0x339820, 0x7E4BF5,
	0x6863B2, 0x5F3EDD, 0x035D40, 0x7F8985, 0x295255, 0xC06437,
	0x10D86D, 0x324832, 0x754C5B, 0xD4714E, 0x6E5445, 0xC1090B,
	0x69F52A, 0xD56614, 0x9D0727, 0x50045D, 0xDB3BB4, 0xC576EA,
	0x17F987, 0x7D6B49, 0xBA271D, 0x296996, 0xACCCC6, 0x5414AD,
	0x6AE290, 0x89D988, 0x50722C, 0xBEA404, 0x940777, 0x7030F3,
	0x27FC00, 0xA871EA, 0x49C266, 0x3DE064, 0x83DD97, 0x973FA3,
	0xFD9443, 0x8C860D, 0xDE4131, 0x9D3992, 0x8C70DD, 0xE7B717,
	0x3BDF08, 0x2B3715, 0xA0805C, 0x93805A, 0x921110, 0xD8E80F,
	0xAF806C, 0x4BFFDB, 0x0F9038, 0x761859, 0x15A562, 0xBBCB61,
	0xB989C7, 0xBD4010, 0x04F2D2, 0x277549, 0xF6B6EB, 0xBB22DB,
	0xAA140A, 0x2F2689, 0x768364, 0x333B09, 0x1A940E, 0xAA3A51,
	0xC2A31D, 0xAEEDAF, 0x12265C, 0x4DC26D, 0x9C7A2D, 0x9756C0,
	0x833F03, 0xF6F009, 0x8C402B, 0x99316D, 0x07B439, 0x15200C,
	0x5BC3D8, 0xC492F5, 0x4BADC6, 0xA5CA4E, 0xCD37A7, 0x36A9E6,
	0x9492AB, 0x6842DD, 0xDE6319, 0xEF8C76, 0x528B68, 0x37DBFC,
	0xABA1AE, 0x3115DF, 0xA1AE00, 0xDAFB0C, 0x664D64, 0xB705ED,
	0x306529, 0xBF5657, 0x3AFF47, 0xB9F96A, 0xF3BE75, 0xDF9328,
	0x3080AB, 0xF68C66, 0x15CB04, 0x0622FA, 0x1DE4D9, 0xA4B33D,
	0x8F1B57, 0x09CD36, 0xE9424E, 0xA4BE13, 0xB52333, 0x1AAAF0,
	0xA8654F, 0xA5C1D2, 0x0F3F0B, 0xCD785B, 0x76F923, 0x048B7B,
	0x721789, 0x53A6C6, 0xE26E6F, 0x00EBEF, 0x584A9B, 0xB7DAC4,
	0xBA66AA, 0xCFCF76, 0x1D02D1, 0x2DF1B1, 0xC1998C, 0x77ADC3,
	0xDA4886, 0xA05DF7, 0xF480C6, 0x2FF0AC, 0x9AECDD, 0xBC5C3F,
	0x6DDED0, 0x1FC790, 0xB6DB2A, 0x3A25A3, 0x9AAF00, 0x9353AD,
	0x0457B6, 0xB42D29, 0x7E804B, 0xA707DA, 0x0EAA76, 0xA1597B,
	0x2A1216, 0x2DB7DC, 0xFDE5FA, 0xFEDB89, 0xFDBE89, 0x6C76E4,
	0xFCA906, 0x70803E, 0x156E85, 0xFF87FD, 0x073E28, 0x336761,
	0x86182A, 0xEABD4D, 0xAFE7B3, 0x6E6D8F, 0x396795, 0x5BBF31,
	0x48D784, 0x16DF30, 0x432DC7, 0x356125, 0xCE70C9, 0xB8CB30,
	0xFD6CBF, 0xA200A4, 0xE46C05, 0xA0DD5A, 0x476F21, 0xD21262,
	0x845CB9, 0x496170, 0xE0566B, 0x015299, 0x375550, 0xB7D51E,
	0xC4F133, 0x5F6E13, 0xE4305D, 0xA92E85, 0xC3B21D, 0x3632A1,
	0xA4B708, 0xD4B1EA, 0x21F716, 0xE4698F, 0x77FF27, 0x80030C,
	0x2D408D, 0xA0CD4F, 0x99A520, 0xD3A2B3, 0x0A5D2F, 0x42F9B4,
	0xCBDA11, 0xD0BE7D, 0xC1DB9B, 0xBD17AB, 0x81A2CA, 0x5C6A08,
	0x17552E, 0x550027, 0xF0147F, 0x8607E1, 0x640B14, 0x8D4196,
	0xDEBE87, 0x2AFDDA, 0xB6256B, 0x34897B, 0xFEF305, 0x9EBFB9,
	0x4F6A68, 0xA82A4A, 0x5AC44F, 0xBCF82D, 0x985AD7, 0x95C7F4,
	0x8D4D0D, 0xA63A20, 0x5F57A4, 0xB13F14, 0x953880, 0x0120CC,
	0x86DD71, 0xB6DEC9, 0xF560BF, 0x11654D, 0x6B0701, 0xACB08C,
	0xD0C0B2, 0x485551, 0x0EFB1E, 0xC37295, 0x3B06A3, 0x3540C0,
	0x7BDC06, 0xCC45E0, 0xFA294E, 0xC8CAD6, 0x41F3E8, 0xDE647C,
	0xD8649B, 0x31BED9, 0xC397A4, 0xD45877, 0xC5E369, 0x13DAF0,
	0x3C3ABA, 0x461846, 0x5F7555, 0xF5BDD2, 0xC6926E, 0x5D2EAC,
	0xED440E, 0x423E1C, 0x87C461, 0xE9FD29, 0xF3D6E7, 0xCA7C22,
	0x35916F, 0xC5E008, 0x8DD7FF, 0xE26A6E, 0xC6FDB0, 0xC10893,
	0x745D7C, 0xB2AD6B, 0x9D6ECD, 0x7B723E, 0x6A11C6, 0xA9CFF7,
	0xDF7329, 0xBAC9B5, 0x5100B7, 0x0DB2E2, 0x24BA74, 0x607DE5,
	0x8AD874, 0x2C150D, 0x0C1881, 0x94667E, 0x162901, 0x767A9F,
	0xBEFDFD, 0xEF4556, 0x367ED9, 0x13D9EC, 0xB9BA8B, 0xFC97C4,
	0x27A831, 0xC36EF1, 0x36C594, 0x56A8D8, 0xB5A8B4, 0x0ECCCF,
	0x2D8912, 0x34576F, 0x89562C, 0xE3CE99, 0xB920D6, 0xAA5E6B,
	0x9C2A3E, 0xCC5F11, 0x4A0BFD, 0xFBF4E1, 0x6D3B8E, 0x2C86E2,
	0x84D4E9, 0xA9B4FC, 0xD1EEEF, 0xC9352E, 0x61392F, 0x442138,
	0xC8D91B, 0x0AFC81, 0x6A4AFB, 0xD81C2F, 0x84B453, 0x8C994E,
	0xCC2254, 0xDC552A, 0xD6C6C0, 0x96190B, 0xB8701A, 0x649569,
	0x605A26, 0xEE523F, 0x0F117F, 0x11B5F4, 0xF5CBFC, 0x2DBC34,
	0xEEBC34, 0xCC5DE8, 0x605EDD, 0x9B8E67, 0xEF3392, 0xB817C9,
	0x9B5861, 0xBC57E1, 0xC68351, 0x103ED8, 0x4871DD, 0xDD1C2D,
	0xA118AF, 0x462C21, 0xD7F359, 0x987AD9, 0xC0549E, 0xFA864F,
	0xFC0656, 0xAE79E5, 0x362289, 0x22AD38, 0xDC9367, 0xAAE855,
	0x382682, 0x9BE7CA, 0xA40D51, 0xB13399, 0x0ED7A9, 0x480569,
	0xF0B265, 0xA7887F, 0x974C88, 0x36D1F9, 0xB39221, 0x4A827B,
	0x21CF98, 0xDC9F40, 0x5547DC, 0x3A74E1, 0x42EB67, 0xDF9DFE,
	0x5FD45E, 0xA4677B, 0x7AACBA, 0xA2F655, 0x23882B, 0x55BA41,
	0x086E59, 0x862A21, 0x834739, 0xE6E389, 0xD49EE5, 0x40FB49,
	0xE956FF, 0xCA0F1C, 0x8A59C5, 0x2BFA94, 0xC5C1D3, 0xCFC50F,
	0xAE5ADB, 0x86C547, 0x624385, 0x3B8621, 0x94792C, 0x876110,
	0x7B4C2A, 0x1A2C80, 0x12BF43, 0x902688, 0x893C78, 0xE4C4A8,
	0x7BDBE5, 0xC23AC4, 0xEAF426, 0x8A67F7, 0xBF920D, 0x2BA365,
	0xB1933D, 0x0B7CBD, 0xDC51A4, 0x63DD27, 0xDDE169, 0x19949A,
	0x9529A8, 0x28CE68, 0xB4ED09, 0x209F44, 0xCA984E, 0x638270,
	0x237C7E, 0x32B90F, 0x8EF5A7, 0xE75614, 0x08F121, 0x2A9DB5,
	0x4D7E6F, 0x5119A5, 0xABF9B5, 0xD6DF82, 0x61DD96, 0x023616,
	0x9F3AC4, 0xA1A283, 0x6DED72, 0x7A8D39, 0xA9B882, 0x5C326B,
	0x5B2746, 0xED3400, 0x7700D2, 0x55F4FC, 0x4D5901, 0x8071E0,
	0xE13F89, 0xB295F3, 0x64A8F1, 0xAEA74B, 0x38FC4C, 0xEAB2BB,
	0x47270B, 0xABC3A7, 0x34BA60, 0x52DD34, 0xF8563A, 0xEB7E8A,
	0x31BB36, 0x5895B7, 0x47F7A9, 0x94C3AA, 0xD39225, 0x1E7F3E,
	0xD8974E, 0xBBA94F, 0xD8AE01, 0xE661B4, 0x393D8E, 0xA523AA,
	0x33068E, 0x1633B5, 0x3BB188, 0x1D3A9D, 0x4013D0, 0xCC1BE5,
	0xF862E7, 0x3BF28F, 0x39B5BF, 0x0BC235, 0x22747E, 0xA247C0,
	0xD52D1F, 0x19ADD3, 0x9094DF, 0x9311D0, 0xB42B25, 0x496DB2,
	0xE264B2, 0x5EF135, 0x3BC6A4, 0x1A4AD0, 0xAAC92E, 0x64E886,
	0x573091, 0x982CFB, 0x311B1A, 0x08728B, 0xBDCEE1, 0x60E142,
	0xEB641D, 0xD0BBA3, 0xE559D4, 0x597B8C, 0x2A4483, 0xF332BA,
	0xF84867, 0x2C8D1B, 0x2FA9B0, 0x50F3DD, 0xF9F573, 0xDB61B4,
	0xFE233E, 0x6C41A6, 0xEEA318, 0x775A26, 0xBC5E5C, 0xCEA708,
	0x94DC57, 0xE20196, 0xF1E839, 0xBE4851, 0x5D2D2F, 0x4E9555,
	0xD96EC2, 0xE7D755, 0x6304E0, 0xC02E0E, 0xFC40A0, 0xBBF9B3,
	0x7125A7, 0x222DFB, 0xF619D8, 0x838C1C, 0x6619E6, 0xB20D55,
	0xBB5137, 0x79E809, 0xAF9149, 0x0D73DE, 0x0B0DA5, 0xCE7F58,
	0xAC1934, 0x724667, 0x7A1A13, 0x9E26BC, 0x4555E7, 0x585CB5,
	0x711D14, 0x486991, 0x480D60, 0x56ADAB, 0xD62F64, 0x96EE0C,
	0x212FF3, 0x5D6D88, 0xA67684, 0x95651E, 0xAB9E0A, 0x4DDEFE,
	0x571010, 0x836A39, 0xF8EA31, 0x9E381D, 0xEAC8B1, 0xCAC96B,
	0x37F21E, 0xD505E9, 0x984743, 0x9FC56C, 0x0331B7, 0x3B8BF8,
	0x86E56A, 0x8DC343, 0x6230E7, 0x93CFD5, 0x6A8F2D, 0x733005,
	0x1AF021, 0xA09FCB, 0x7415A1, 0xD56B23, 0x6FF725, 0x2F4BC7,
	0xB8A591, 0x7FAC59, 0x5C55DE, 0x212C38, 0xB13296, 0x5CFF50,
	0x366262, 0xFA7B16, 0xF4D9A6, 0x2ACFE7, 0xF07403, 0xD4D604,
	0x6FD916, 0x31B1BF, 0xCBB450, 0x5BD7C8, 0x0CE194, 0x6BD643,
	0x4FD91C, 0xDF4543, 0x5F3453, 0xE2B5AA, 0xC9AEC8, 0x131485,
	0xF9D2BF, 0xBADB9E, 0x76F5B9, 0xAF15CF, 0xCA3182, 0x14B56D,
	0xE9FE4D, 0x50FC35, 0xF5AED5, 0xA2D0C1, 0xC96057, 0x192EB6,
	0xE91D92, 0x07D144, 0xAEA3C6, 0x343566, 0x26D5B4, 0x3161E2,
	0x37F1A2, 0x209EFF, 0x958E23, 0x493798, 0x35F4A6, 0x4BDC02,
	0xC2BE13, 0xBE80A0, 0x0B72A3, 0x115C5F, 0x1E1BD1, 0x0DB4D3,
	0x869E85, 0x96976B, 0x2AC91F, 0x8A26C2, 0x3070F0, 0x041412,
	0xFC9FA5, 0xF72A38, 0x9C6878, 0xE2AA76, 0x50CFE1, 0x559274,
	0x934E38, 0x0A92F7, 0x5533F0, 0xA63DB4, 0x399971, 0xE2B755,
	0xA98A7C, 0x008F19, 0xAC54D2, 0x2EA0B4, 0xF5F3E0, 0x60C849,
	0xFFD269, 0xAE52CE, 0x7A5FDD, 0xE9CE06, 0xFB0AE8, 0xA50CCE,
	0xEA9D3E, 0x3766DD, 0xB834F5, 0x0DA090,
};

#if 0
const int _TBL_ipio2l_66[] = {
	0xA2F983, 0x6E4E44, 0x152A00, 0x062BC4, 0x0DA276, 0xBED4C1,
	0xFDF905, 0x5CD5BA, 0x767CEC, 0x1F80D6, 0xC26053, 0x3A0070,
	0x107C2A, 0xF68EE9, 0x687B7A, 0xB990AA, 0x38DE4B, 0x96CFF3,
	0x92735E, 0x8B34F6, 0x195BFC, 0x27F88E, 0xA93EC5, 0x3958A5,
	0x3E5D13, 0x1C55A8, 0x5B4A8B, 0xA42E04, 0x12D105, 0x35580D,
	0xF62347, 0x450900, 0xB98BCA, 0xF7E8A4, 0xA2E5D5, 0x69BC52,
	0xF0381D, 0x1A0A88, 0xFE8714, 0x7F6735, 0xBB7D4D, 0xC6F642,
	0xB27E80, 0x6191BF, 0xB6B750, 0x52776E, 0xD60FD0, 0x607DCC,
	0x68BFAF, 0xED69FC, 0x6EB305, 0xD2557D, 0x25BDFB, 0x3E4AA1,
	0x84472D, 0x8B0376, 0xF77740, 0xD290DF, 0x15EC8C, 0x45A5C3,
	0x6181EF, 0xC5E7E8, 0xD8909C, 0xF62144, 0x298428, 0x6E5D9D,
	0xF9A9B4, 0xCDBD2F, 0xC083E7, 0x0D3957, 0xECA3B2, 0x96223C,
	0xC1080D, 0x087D47, 0x7D7576, 0xA614B1, 0x42A4B6, 0xAA173C,
	0xE217E5, 0xFDCD34, 0x279D5F, 0x39AACA, 0x1CA8DF, 0x8B6633,
	0x5C49E4, 0xB56803, 0x1E7938, 0x741FDC, 0x4CB19B, 0xCECC3B,
	0x921EB7, 0x7C0FC3, 0x361F23, 0xF9EE22, 0xBA4235, 0xA5FCA3,
	0xBD4680, 0xFCDF65, 0xFC96AD, 0x31C90C, 0x919EEB, 0xFE0FB7,
	0x75B4B0, 0x693961, 0x75BCAA, 0xEB6F39, 0xA343C0, 0xD16FF2,
	0x33DAD0, 0xC1E095, 0x053182, 0x11E4A1, 0x40F943, 0x32D314,
	0xAF1B98, 0xE1B05A, 0xE5F3AD, 0x6E633F, 0x363D14, 0xA3777C,
	0xC8C6EE, 0x001E18, 0x0D180C, 0xAA1369, 0xEDFBA2, 0x998A9D,
	0x16E799, 0x693B75, 0x90EF50, 0x938DD4, 0xFB7ACD, 0x67CEEB,
	0x249DE3, 0x9B9B52, 0xD8CDAC, 0xC31A54, 0x855FBF, 0x848591,
	0x0954B0, 0x946B8C, 0xA4C7B4, 0x9A9E51, 0xF20425, 0xAA2637,
	0xFC6657, 0x7D8625, 0x620B74, 0x8B578D, 0xEC9A05, 0xDEF24F,
	0x7F19B0, 0xFC2544, 0x1DA0F1, 0x23790C, 0xC4294D, 0x6D3C32,
	0x66FE56, 0xD45562, 0x66264F, 0xA24162, 0x13E930, 0xB0E7C0,
	0xFA0E97, 0xBFC62C, 0x0E663F, 0x90F33B, 0x55E73C, 0xD791F7,
	0xD3F00D, 0xAB01C7, 0x40CF8F, 0xA593BA, 0xE627D5, 0x4A8308,
	0x32DC06, 0x80C876, 0x1C3DB5, 0xB5489F, 0x632CDF, 0xB02517,
	0xD17EFA, 0x92570F, 0xFAED44, 0x8F8536, 0x27069B, 0xC014DC,
	0x997D48, 0x961D61, 0x7A960B, 0x31B622, 0xD3C425, 0xA69520,
	0x98D29E, 0xF1C973, 0x5483D7, 0x99611E, 0xEAFF5F, 0x7DEFF1,
	0x98475C, 0x91C787, 0x537E17, 0x068C65, 0xF05E52, 0x942F04,
	0x37CF92, 0xEF4223, 0xC4C52F, 0x521DAA, 0xBAAF97, 0x972236,
	0xA2B3D3, 0x62C921, 0x8D3A8B, 0x2B3302, 0x6061B9, 0x0CBE94,
	0x75F451, 0xBD06DE, 0x86042D, 0xFB61ED, 0x4C8869, 0x590232,
	0x479963, 0x23518D, 0xAF5D28, 0x60C9DE, 0x473DB0, 0x9DE009,
	0xD8FC4C, 0xE96991, 0x9CA455, 0x800BC8, 0x977CE0, 0xDCBFA6,
	0x19D249, 0xA0F76D, 0x5F9B2F, 0x452BB3, 0x77E091, 0xB6383A,
	0x7BE9C2, 0x4BF7C1, 0x8A5EBF, 0xEB0D55, 0x9AF4DC, 0x275CA0,
	0xED09D0, 0xE50A7F, 0xBEF42C, 0x4803AF, 0x56139F, 0xD58848,
	0x797D96, 0xB8352E, 0x49D90D, 0x7607E0, 0xC99256, 0x75F530,
	0xB72237, 0x1AF080, 0xC2E813, 0x06CFA9, 0xB9DF8E, 0x919C38,
	0x89D97E, 0x0464D5, 0xB12EEF, 0xD14165, 0x365A72, 0x550D35,
	0x3772D8, 0xF41B58, 0x0378A7, 0x2D5D7D, 0xD6E433, 0xDD2018,
	0x139FD7, 0x1B5621, 0x94E046, 0x97A323, 0x693176, 0x28DF59,
	0xD24273, 0x0E4E26, 0xA9A8F6, 0xF15B41, 0x450EE3, 0x57EA61,
	0x7DADA6, 0xF21086, 0x394BEE, 0x8F4813, 0x3FDEE9, 0xF3A53D,
	0xAB2F40, 0x8B1E2B, 0xA07FD4, 0x992CC4, 0x63532D, 0x9F35A2,
	0x6FA290, 0x0094DE, 0xD2A24D, 0x755B81, 0x79F9E1, 0xFE1D35,
	0xFEE8CC, 0x9224C5, 0x54E2CE, 0x41F31C, 0xF45138, 0xED6D10,
	0x6B439D, 0xD2BE46, 0xC327D4, 0x68BFB0, 0x46D5A5, 0x79B285,
	0x776D7C, 0xE18647, 0x00E32F, 0xEBB7F2, 0x5DE307, 0x5A8EA0,
	0x06CEFE, 0x20923C, 0x354CE1, 0xAD09C5, 0x56996D, 0xCFB124,
	0xEF7BC1, 0x76BF72, 0xF20753, 0x5BBAFA, 0xB8A2B2, 0x5914F2,
	0x5D834F, 0xE64A08, 0x14C3AB, 0x07796B, 0xF2212D, 0xC74049,
	0xB61C6A, 0x282CFC, 0x25070C, 0x315BF1, 0x6FEAD3, 0x2CD2E5,
	0xD10F9C, 0x1972BB, 0x908073, 0x0F368C, 0x69BE97, 0xA242B0,
	0x722DFE, 0xAFE6A2, 0x143D8B, 0x5C5699, 0x48232B, 0xFF49AC,
	0xB5FA62, 0x6AD778, 0x7A844D, 0x258AA0, 0x8EDE3D, 0x9A9496,
	0x49924E, 0xA33E97, 0x4F43FA, 0xC40741, 0x2F764A, 0x8EB2B1,
	0x8E67D3, 0x9FF324, 0x51B11B, 0x5D6E09, 0xE9AD3E, 0xFFA902,
	0xF48653, 0x0845D3, 0xDED33E, 0x32D30E, 0x6247CA, 0x7C586D,
	0x2EAF9E, 0x323A35, 0xAD11FB, 0x0F420C, 0x0E0685, 0x401B60,
	0xBB3D43, 0xF4D489, 0xBCDC4C, 0x40FFBA, 0x18AB08, 0x7AC72D,
	0x5E76DB, 0xE8344E, 0x3975A2, 0xF9611B, 0x1121F3, 0x3A429C,
	0x9B18EC, 0xF298B1, 0x8AEC78, 0x1C248B, 0x69108F, 0xDB2D37,
	0xA1A613, 0x910359, 0x521451, 0xD4441F, 0x0BB3B6, 0x50D9DB,
	0xBD589F, 0x62A62E, 0xA9B903, 0x935F63, 0x058BEC, 0x78BCB5,
	0x2CB460, 0x3A9037, 0x0291C4, 0x1FABC1, 0xBE7D05, 0xF948E7,
	0x6BA5CD, 0xF62A0A, 0x9AEA19, 0x2257AB, 0x2E0D7D, 0x9EB93F,
	0x5E3F77, 0xD4A13F, 0x08E3DB, 0xDFD689, 0x2B9B4E, 0xB58427,
	0x25424B, 0x1197FD, 0xCF298A, 0x314008, 0xD5687F, 0x0F0EAC,
	0x13C485, 0xF684B2, 0xED7EC7, 0x6E636D, 0x28C933, 0xE19058,
	0x688B6A, 0xC88905, 0xFB2F31, 0x61304C, 0xC19765, 0x60D81A,
	0x57F276, 0xC6EFC4, 0x048954, 0x303470, 0xDA6F6F, 0x93901A,
	0x911439, 0x363D12, 0x59E72B, 0x6F9F1E, 0x57C584, 0xDF0D23,
	0xBB743F, 0xADE99C, 0x546097, 0xFCC820, 0xCBB968, 0xDA9B5F,
	0x0DC271, 0x563337, 0x9ED662, 0xE7C44F, 0x3129F8, 0xF5EAF9,
	0xDAF7F2, 0xCD09FF, 0xA92535, 0x441C29, 0x7DF436, 0xE2B00A,
	0x36746F, 0xF1DC61, 0x9D3C9C, 0x63AB71, 0xB8F3BB, 0x1C80F6,
	0x62FF65, 0x5FFE5F, 0x3B2814, 0xBADE27, 0x1B384B, 0x268AA9,
	0xBD91EF, 0xCA436B, 0xABE107, 0x88DCA6, 0xC3AFC0, 0x85D155,
	0x464A48, 0xBFDAEB, 0xC6F389, 0x907C11, 0x0D3E41, 0xCD2197,
	0x549008, 0x817E4E, 0x8C7154, 0x1DC37F, 0x5E897E, 0xA9A2FE,
	0xEC6060, 0xCC0728, 0x430D3B, 0x62471C, 0xD3A4D3, 0x2BA57B,
	0xE5D15A, 0xD632F3, 0xF2B76F, 0xEC8498, 0xAE41C2, 0xAAF413,
	0xEAF5C0, 0xDD1B07, 0xB9A2A0, 0x59F230, 0xA3F61B, 0x8F8643,
	0x05DE6B, 0x1B5B8E, 0x63ECC5, 0xBFF01D, 0x8F1440, 0x3F8ADF,
	0x2E6539, 0xF3DB7A, 0x293FE5, 0x7EE714, 0x88E6D8, 0x2B2A6A,
	0xDF6E34, 0x8D4604, 0x4F6594, 0x639063, 0x6B51CC, 0x0D05CD,
	0x009607, 0xE7BF70, 0xC9A0EA, 0x0D80DD, 0xA1A065, 0x0DCB8F,
	0xA48430, 0x715934, 0x6FC8E4, 0x6FFC52, 0xEF8B05, 0xDE506A,
	0xE62BBC, 0x31480F, 0xEA64EA, 0x51E6FB, 0x9AE773, 0x21C54D,
	0xBFA080, 0x273D1E, 0x9FFD4E, 0x0C2CA8, 0x0690A5, 0xF8773B,
	0x4B2680, 0x6E3F56, 0xC8B89F, 0x0B7BD0, 0x71C8BF, 0x5AABD3,
	0x2BA93E, 0x9D2EE1, 0xCDF2FA, 0xEE57BE, 0x84A116, 0xDA756D,
	0x8FD6C0, 0x927153, 0xFF5EF3, 0x9F8331, 0x713411, 0xF945F3,
	0x0382B2, 0x8BAE30, 0xBC45A4, 0x630101, 0x5C9C3A, 0x643CFD,
	0x48115C, 0x17F03E, 0xB5F55E, 0x288DAF, 0x725660, 0xFB58E0,
	0xFC189E, 0x1ECA69, 0xFB19A6, 0xFA7A92, 0x7CC48E, 0x869372,
	0x58089A, 0x16DB5C, 0xADC0CD, 0x09D3D4, 0xD1108E, 0xDC64ED,
	0x3A999C, 0xAA8716, 0x5A3D8E, 0x7037FB, 0x1976AD, 0xE477D7,
	0x23782B, 0xC51F39, 0x4A5E9A, 0xDAD9DA, 0xE5B559, 0x08EF06,
	0x76E24F, 0x7361AD, 0x5F42A3, 0x9B70E5, 0xCE96C4, 0x552E99,
	0x6D7A6F, 0x804474, 0x4FA45B, 0x1D115B, 0x6D109E, 0x0A1A63,
	0x1084A6, 0xE18E5D, 0x2D8589, 0x203345, 0x4851AF, 0xA71EDC,
	0x03B6B1, 0x267970, 0xDEC908, 0x795BED, 0x7099B9, 0x209321,
	0x7FC2E7, 0x0F3E5E, 0xC7A4F4, 0x088129, 0x59AE63, 0x4E3251,
	0x344268, 0x79285D, 0x2B9494, 0xF1E2A2, 0xF7DA20, 0xDF6756,
	0xCA3BA3, 0x422489, 0xA2239C, 0x38724D, 0x2AC767, 0x601E9D,
	0xB47C6C, 0xA22481, 0xBBB655, 0x1EC0C4, 0xD84A97, 0xD449EE,
	0x162C9D, 0x782F29, 0xCEB4FA, 0xE317BC, 0x2FFDBD, 0xB342D2,
	0xB2CB19, 0x323AB9, 0x1AFF93, 0x13A8DF, 0x86B5A5, 0x5741D6,
	0xC54342, 0x3CAC29, 0xF7517C, 0x129A7A, 0xB2B8B4, 0x9B709F,
	0x3923C5, 0xEAFA6E, 0xDB9077, 0x29EEA0, 0x702D8C, 0x4DC14F,
	0xE46933, 0xA764E4, 0x754266, 0xFA4F98, 0x643DA5, 0xCA775C,
	0x7F1632, 0xE671A3, 0x4BF4C6, 0xA82378, 0xEFD317, 0xE62D38,
	0xD461C9, 0x8EEC80, 0xC89882, 0x4CC73C, 0x830F3F, 0xE4B200,
	0x582615, 0x6CD558, 0xA66727, 0xEF7975, 0xFEA5CE, 0x147A40,
	0x4796E4, 0xC07761, 0xF5D5B3, 0x6B65FB, 0xE4F14D, 0xA837CA,
	0x9A152A, 0x554E94, 0x83EC5F, 0xA62174, 0x85E2ED, 0xCCE71C,
	0x3540FF, 0x088A84, 0xBA2816, 0x293610, 0x4C3EE7, 0x8E55A9,
	0x49E5E5, 0x782178, 0x45D2AA, 0x9BB449, 0x00D282, 0xF61E67,
	0xE2F7DE, 0xCC6AA1, 0xCD1979, 0x52FEDB, 0x9A8776, 0x70A018,
	0x500271, 0x1273BA, 0xDE648E, 0x7AC7F7, 0x767725, 0xD0A457,
	0xF17250, 0xBC578C, 0x2DFD3A, 0x97F988, 0xA576C8, 0x8129BB,
	0x22D9C3, 0x0436ED, 0x650791, 0xA314EC, 0x42A0B3, 0x37A521,
	0x4BFB2B, 0x8C1B7F, 0x115E17, 0xF7C27F, 0xC1D5EB, 0x060487,
	0x8A28D6, 0x41330F, 0xBFAE67, 0x7774E8, 0x4CCC3C, 0x6B2F80,
	0x628BF2, 0x1E41A6, 0x8D0B22, 0xBC85BA, 0xCCF461, 0xBEC69C,
	0xDF8A10, 0x3C5E71, 0x2F8D5F, 0x63D3DA, 0x5934D1, 0x2CA35D,
	0xC687A2, 0x24E9B4, 0x1843D3, 0x5C9B97, 0x9B580C, 0x780B2C,
	0x59943D, 0x0744D0, 0x8DA6E3, 0x07AAF6, 0x2214D0, 0x72E8D7,
	0x54151B, 0x514DE9, 0x8DCC3B, 0x0CEB00, 0x2C4DE3, 0x5012AE,
	0xD7B72E, 0xB7DE9A, 0x641B2F, 0xF9CF17, 0x8BD282, 0x9F31A3,
	0xDED846, 0x467E05, 0x26CCEA, 0xF8E404, 0x65572E, 0x82C594,
	0xE572A9, 0x895653, 0xA1AA94, 0x8DD876, 0x5E9A61, 0x69EB1C,
	0x0385A9, 0x5BC844, 0x95B2DF, 0x6678F6, 0xFA7033, 0xE4F434,
	0x5584A9, 0x32C099, 0x9AD846, 0xB3FFD1, 0xA81C56, 0x4E54EF,
	0x54D173, 0xF191B4, 0x49B2A2, 0xB309D9, 0x546D8D, 0xC0A51E,
	0xCAFFC0, 0x785400, 0x05F69D, 0x894056, 0xC33098, 0xDFF6C2,
	0x908D97, 0x05CC96, 0x46484B, 0xBD7B9D, 0xB152F5, 0x5A7461,
	0x59CA20, 0x8F8EF5, 0xC9FF05, 0xF6F398, 0x856C97, 0x81E07C,
	0xAE5EDA, 0x51BDC9, 0xF26437, 0xBBC8CE, 0x091B52, 0x68B6A5,
	0x90750E, 0x925EF9, 0x3D9CB3, 0x46EA96, 0x97D648, 0x78BCC7,
	0xF4B488, 0x05275E, 0x6619DF, 0x56D4A0, 0x8C5C41, 0xDB345A,
	0x0B79DA, 0x496369, 0x96109B, 0x667664, 0xC40CF9, 0x91D7CA,
	0x119F1A, 0xA99272, 0xCBB529, 0xBB033E, 0x8F91C0, 0x570045,
	0xB845C2, 0x2B8E52, 0x687AFB, 0x0D0AA3, 0x200863, 0x043B83,
	0xF129DE, 0x49C2D6, 0x9641D2, 0xC4747C, 0x220804, 0x503F05,
	0x7E274F, 0xCA83D9, 0x9D6495, 0x0E5039,
};
const int _TBL_ipio2l_53[] = {
	0xA2F983, 0x6E4E44, 0x16F3C4, 0xEA69B5, 0xD3E131, 0x60E1D2,
	0xD7982A, 0xC031F5, 0xD67BCC, 0xFD1375, 0x60919B, 0x3FA0BB,
	0x612ABB, 0x714F9B, 0x03DA8A, 0xC05948, 0xD023F4, 0x5AFA37,
	0x51631D, 0xCD7A90, 0xC0474A, 0xF6A6F3, 0x1A52E1, 0x5C3927,
	0x3ADA45, 0x4E2DB5, 0x64E8C4, 0x274A5B, 0xB74ADC, 0x1E6591,
	0x2822BE, 0x4771F5, 0x12A63F, 0x83BD35, 0x2488CA, 0x1FE1BE,
	0x42C21A, 0x682569, 0x2AFB91, 0x68ADE1, 0x4A42E5, 0x9BE357,
	0xB79675, 0xCE998A, 0x83AF8B, 0xE645E6, 0xDF0789, 0x9E9747,
	0xAA15FF, 0x358C3F, 0xAF3141, 0x72A3F7, 0x2BF1D4, 0xF3AD96,
	0x7D759F, 0x257FCE, 0x29FB69, 0xB1B42C, 0xC32DE1, 0x8C0BBD,
	0x31EC2F, 0x942026, 0x85DCE7, 0x653FF3, 0x136FA7, 0x0D7A5F,
	0x93FC61, 0x035287, 0xC77FCA, 0x73530A, 0xC6BC15, 0x0E4B0F,
	0x568FCE, 0x2D3456, 0x4D7FE1, 0xA12CD1, 0xB2CEA2, 0x531C62,
	0x70B4D2, 0x1BCE9A, 0x87704D, 0x6B83D7, 0xAA8121, 0x2530EA,
	0x2074BF, 0x28A071, 0x9D69C3, 0x406DD8, 0xF58783, 0x115D89,
	0x5E85F3, 0xAACDCC, 0x8C0B57, 0xD7DFFE, 0x550D96, 0xC43EB4,
	0x89ABA7, 0x94F595, 0x56F260, 0x06A4CD, 0x7FD2E2, 0x6FDFA8,
	0x3E9C98, 0xBFD682, 0xAD3A12, 0x23A8A6, 0x173A89, 0x5DE9BD,
	0x95A978, 0x28E484, 0x5964F3, 0x496AF0, 0x4B1DA9, 0x989061,
	0xBD2BF2, 0xE01A90, 0x0905B7, 0xAC39AC, 0x52D5B7, 0x109F25,
	0x3AE1DC, 0xF90A7C, 0x33F4E5, 0xF5DFDF, 0x1522D0, 0x562CE6,
	0x392CFF, 0xEB9032, 0x10A08E, 0x0B1D7F, 0x42B80A, 0x366DD2,
	0xC24F89, 0x02222E, 0x21494C, 0x985287, 0x87FD07, 0x2EE361,
	0xAD8D68, 0xE72273, 0x9E8D59, 0xD09999, 0x10F4A1, 0x1079A3,
	0xE9BEAF, 0x9C0887, 0x09C622, 0xEBCF06, 0x974532, 0x086A8F,
	0x6CEA05, 0x388C00, 0x74969E, 0xC85B16, 0x385A38, 0x9A2F35,
	0x670531, 0xABA6D0, 0xEFD3C1, 0x27AD92, 0xF4203E, 0x3D619F,
	0x4D05F4, 0x9AE7CC, 0x03B592, 0x41FF55, 0xCAFCA5, 0x1A0987,
	0x88AB79, 0x3627D4, 0x25B12A, 0x52594A, 0xA2BEB0, 0x25C3F2,
	0x4489DA, 0x7959A7, 0xEAEC89, 0xB34714, 0x960196, 0x1FC33A,
	0x7F0275, 0x32EF92, 0x0111CE, 0x8E4685, 0x6F5B34, 0xF6123A,
	0x5543B2, 0xE9A02A, 0x74E03F, 0x54D5A8, 0x086A2C, 0x4A9CD3,
	0x921191, 0x229764, 0x0A1A84, 0x9B45AE, 0xC653A5, 0xB15F33,
	0x100FD1, 0x7DD740, 0xB20CD3, 0x0A0786, 0xF506C3, 0x25EBF4,
	0x3AB39E, 0xE3BB24, 0x27646F, 0xEECE57, 0x706BFE, 0xC7A869,
	0x57ED51, 0x118C82, 0x2B0FF5, 0xC8E545, 0xC43D80, 0x2A3183,
	0x4C1BB9, 0xBC108A, 0x099779, 0xF9ECC8, 0x2A1063, 0x5D2F6A,
	0x8F2675, 0x12FF6D, 0x32EED9, 0xE4A245, 0x7392CF, 0x5C240B,
	0xC476FF, 0x97AFC7, 0xB76131, 0x665E05, 0x67BD57, 0x19E998,
	0x3A5863, 0x23B8AA, 0x5B5608, 0x8A66C6, 0x5F2AD3, 0x78BAFA,
	0x3516CE, 0xCBEA16, 0x6E40D4, 0xB463D4, 0xA6C12F, 0xABD3D7,
	0x32650A, 0x579D10, 0x3CB9E2, 0x1A02A7, 0xDF2FFA, 0x28C991,
	0xB2264C, 0x027870, 0x47BDD4, 0xF243B1, 0x39AE2C, 0x282EA4,
	0xAF1D98, 0x2AFD16, 0xABE7AF, 0x17CB67, 0x8FF93E, 0x793167,
	0x435F6B, 0x48058B, 0x417DA0, 0xE01217, 0x085A69, 0xB50E36,
	0x79A4CD, 0xD74907, 0x26C4B5, 0xB90054, 0x06C3AD, 0x5AB38F,
	0x585E91, 0xD04E4F, 0x2938CE, 0xD4EAA7, 0xA06DE5, 0x40BFE5,
	0xDE6849, 0xEF65F0, 0xF1D4BB, 0x94C21E, 0x66E978, 0x1B9B94,
	0x961043, 0x5961B8, 0xBAAA74, 0xD662EE, 0x9DABF6, 0x0AFE28,
	0x9587A4, 0xA632BC, 0x09149F, 0xDEA996, 0x2CAFD7, 0xBDE29B,
	0x7159E6, 0x1F7C49, 0xF2E2ED, 0xBFA992, 0x7C77EF, 0xC245D0,
	0xB2D129, 0x993E75, 0xAB4C0C, 0x5C84B6, 0x17F542, 0x45314E,
	0x1DEF1B, 0xE3BDCC, 0xB3AE86, 0x24522F, 0x918FC6, 0x2138D5,
	0x883646, 0x6858B6, 0x032762, 0x5170F8, 0x4974EA, 0x76BF77,
	0xECDA8A, 0x9EADDD, 0x2404EF, 0xC52A5D, 0xF2E858, 0xC42D60,
	0xD18C08, 0xDE59B2, 0x4CC3A6, 0x94D888, 0x4C4AF0, 0xCF1F8C,
	0xBF2F6F, 0x7B4535, 0x98B0DB, 0x2BE0CF, 0x4616A7, 0xA8D9FB,
	0x88CA7A, 0x5087E1, 0x18DD8A, 0x1A9F4F, 0x1DCECE, 0xF8609E,
	0xE2F0C8, 0x9AD7D4, 0xE3CDFE, 0xC6FDD5, 0x8FF3CD, 0x7D45AA,
	0xD34957, 0x7C1963, 0x6CE098, 0xB70215, 0x326BBF, 0x47B3A6,
	0xF9235D, 0x6F66F5, 0xC6E40C, 0xE7F50B, 0xFF2FDD, 0x5A1251,
	0xE95EF1, 0xDE8E67, 0xECEE9B, 0xC9F98E, 0x722224, 0x6DF750,
	0x81D08F, 0x2BFCF0, 0xDDC10D, 0x775314, 0xDB1D87, 0x41626B,
	0x9EDF31, 0x7738D9, 0x8D9EB4, 0x4F1C2A, 0xF3E795, 0xB69699,
	0xD9A56D, 0x31BB1B, 0x542975, 0xAB917B, 0x63927C, 0x9BB764,
	0x84A598, 0x0A0C51, 0x5E48C4, 0x7780E3, 0x87E156, 0x155972,
	0xE406F8, 0x48AB9E, 0x3CCDDA, 0x010F87, 0x683B70, 0x400CAD,
	0x5DE5C5, 0x7262FA, 0xFA248D, 0x013AF2, 0xE2E8B5, 0x995F7D,
	0x7F8C4B, 0x0E8B59, 0x1006F1, 0x40B6E9, 0x760654, 0xCBCC8C,
	0x086F40, 0xDC7F6F, 0xFCD0D4, 0xA47ADE, 0x5204FA, 0xF38A9D,
	0xE76C7C, 0x575207, 0x499BF1, 0x0DB01C, 0x09098E, 0x957A71,
	0xD53E0E, 0x61DF1D, 0xE6EF34, 0x5821EC, 0x96BCC0, 0xDC96CE,
	0xA9C0AE, 0x130B2C, 0xCCC589, 0x829BB9, 0x2A75BA, 0x97611C,
	0x0CEAB8, 0x165D9D, 0x35AD41, 0x82A805, 0x975628, 0x5601A6,
	0x074F08, 0x80A27D, 0xEFA64E, 0xD7BB4B, 0x5E6397, 0xC92FFC,
	0x4F3F7A, 0xBEA764, 0x0C9B7D, 0xC5DC74, 0xEAD216, 0x6DBBC0,
	0x913E3E, 0xABF50B, 0x95B24A, 0x3FC9C5, 0xE7BA15, 0x8C7F70,
	0xF81358, 0x774606, 0xCE8C0D, 0xB6B268, 0xB85BA6, 0xAC9B2E,
	0x1AAB05, 0x0C6C82, 0x6EC2AE, 0x606874, 0x8F60BF, 0x1FBC7B,
	0x58C97A, 0x448794, 0xBA48A0, 0x72E882, 0x6D3568, 0xE131FD,
	0x4745D0, 0x0BFA1E, 0x07B01D, 0x474D43, 0x59387E, 0x5B0AD5,
	0xC37A8C, 0x0474E8, 0x13D99D, 0x68A13C, 0xB69118, 0x89228C,
	0x6F7D83, 0x86D665, 0x5C7744, 0xDD183E, 0x1C2E17, 0x712F5E,
	0x4AACCB, 0xB69B68, 0xA1201F, 0x743C2B, 0xF6AD70, 0x92E024,
	0xF34FD8, 0x33712E, 0xFE1D73, 0x4471F0, 0x7D0526, 0x58AF47,
	0x7B11FE, 0x1FCE4F, 0x1356C9, 0x9CE3CA, 0xA843C0, 0x8EEA3C,
	0xABEEE4, 0xA5D495, 0xA407A4, 0x31BB4B, 0x0AA1E3, 0x518E7C,
	0xAA4A66, 0xD82CD8, 0x6EF8D2, 0x6F32E6, 0x1DC26B, 0x17AE59,
	0x4B683B, 0x8D48F7, 0xF4FBD8, 0xD4FE0A, 0xE961DE, 0x87BD37,
	0xE6CCD6, 0xCBD76D, 0x3E99DE, 0xB72E21, 0x54EB90, 0x6AB45D,
	0x600AFB, 0xA17B2F, 0xDA0421, 0xE6CA95, 0x35AAA2, 0x7D8FB1,
	0x3207BB, 0xBF82EE, 0x71F55F, 0xC661CB, 0xBD72A1, 0xBF5A64,
	0x6E39E8, 0x6C6DE2, 0x2BD178, 0xAF62A5, 0xA7D86E, 0xE7D0FE,
	0x84DB03, 0x67FDA2, 0x2D6809, 0x0F8B8F, 0x1B50E3, 0x234EF5,
	0x7325ED, 0x8F8F4C, 0xC1E426, 0x3066AD, 0x0759A4, 0xE03390,
	0x70CC9A, 0x524F77, 0xCDD489, 0x97DD24, 0xA81858, 0xF24513,
	0xA9C18E, 0x2A2F82, 0xC2C014, 0xB8E7F0, 0x934036, 0xD36E51,
	0xD9A089, 0xDBC587, 0xB30418, 0x969192, 0x0A5213, 0xE21841,
	0x2881EC, 0x9A293F, 0x0DF705, 0x85B497, 0xE430B9, 0xE90ECF,
	0xC15FDC, 0x9E8A7E, 0xC5472D, 0xB54FBD, 0x456AF2, 0xCA80B6,
	0xAE25FE, 0xA03B46, 0x6C6CFD, 0x78382A, 0x0E7877, 0x7F2D31,
	0x03C827, 0x61CF52, 0x339A2F, 0x2286A9, 0xE41DF0, 0x640F5C,
	0xBEF364, 0x010506, 0x6D2C21, 0x841EFF, 0x7F3B5D, 0xD98DC8,
	0x0F9421, 0xA25B0C, 0x4C2C44, 0x922392, 0xB98A8A, 0x6179B9,
	0xF7B419, 0x289AAF, 0xE92F47, 0x5E47A2, 0x82927F, 0xC7290E,
	0x6C925C, 0xBA5A3C, 0x8FB7F6, 0x9C4BEE, 0x02C529, 0x0CFCD7,
	0x5EBD8C, 0x7196E0, 0x4B917E, 0x6B9780, 0x6A1731, 0xA617FF,
	0x27A20D, 0x5A56A3, 0x43C4DB, 0xC62EA4, 0x637A84, 0x1C46F9,
	0x33C780, 0x61A278, 0x4915C9, 0xD6C776, 0x6A7C66, 0xD8DD0C,
	0xF87EB1, 0x124C43, 0x5B87E7, 0x097456, 0x3C2FA7, 0x307C4A,
	0x54267A, 0x30E34E, 0xC0CF98, 0xD75B19, 0xFADEDB, 0x12CBE8,
	0x29F24C, 0x579C7E, 0xBF3682, 0xDCB460, 0xAE08B3, 0xA524BC,
	0xC181C2, 0x5DAB90, 0x466602, 0x55345B, 0xA13941, 0x47D820,
	0x278066, 0x81B089, 0x165EFB, 0x4D27FD, 0x2BF9F4, 0x2E2FFB,
	0x6106B5, 0xE76806, 0x445A84, 0x0BDA0D, 0x49D7A4, 0x72650D,
	0xCDC55B, 0x3E16BC, 0x132F6F, 0x29E8FD, 0xE58428, 0x621E41,
	0x7D2AC4, 0xAB5697, 0xAC61EB, 0xE5DAF0, 0x654ED6, 0x8E77E3,
	0x0B2FBC, 0x2E63A3, 0xC8296A, 0x8B631F, 0x4ECCA6, 0x91859C,
	0x9E3E45, 0x0E3CC7, 0xC12454, 0xCCBCB6, 0x17979E, 0xD0D374,
	0xA489A2, 0xC6258F, 0xE8EF9E, 0x12EE26, 0xC614C2, 0x62E23E,
	0xCA8C5C, 0x409AC9, 0x511D05, 0xA88CE0, 0x195500, 0xF7144F,
	0x913BB7, 0x17D064, 0xF6C9CE, 0xAC5D11, 0xD0C313, 0xBCCCB6,
	0xAAD4FC, 0xE47B2C, 0xFE4362, 0xF2E712, 0x2D5EFF, 0x833822,
	0x58A1D7, 0x68377C, 0xE49B25, 0x22B179, 0x048796, 0x069400,
	0xE670D3, 0xD2CB85, 0x55FBE6, 0x67F281, 0xFE2DE0, 0x8CFAF2,
	0x9865BC, 0x210CD3, 0x86DD70, 0x43D00F, 0x55E279, 0x679252,
	0x8D4F58, 0xE17AC5, 0x6A6127, 0x1B0876, 0x5D8ED0, 0x701330,
	0xD5BD25, 0xC9A126, 0x57C571, 0xDC5C3F, 0xB6D34E, 0xB72383,
	0x001A9E, 0x7D36C0, 0x8151F6, 0x65D7C1, 0xE1F513, 0xCD372A,
	0xE69B0C, 0xD02685, 0x23C3EB, 0x3544CB, 0xF0BE31, 0x83F399,
	0xCB93F8, 0xFFC693, 0x908EC6, 0x8E5DE1, 0x315B7E, 0x67CE7B,
	0x40AAF7, 0x7FD285, 0x069B36, 0x03C00A, 0x13C7D5, 0x0DA14C,
	0x1EAAD4, 0x2B777F, 0x8E05C1, 0x5AD1AE, 0x60C398, 0xA4EA59,
	0x10BEED, 0x88F2FA, 0x69B941, 0xA54E70, 0xA817C3, 0xB96246,
	0xE8EEDC, 0x56D570, 0xBBEBB5, 0xD8F235, 0x201AB9, 0x9CC747,
	0x5BC2FB, 0xC877F3, 0x428CF6, 0x4EEF84, 0xBF85FD, 0xEE6D34,
	0x84C2DE, 0xC42F4C, 0x1A513B, 0x9AC41F, 0x87FFFA, 0x1CA431,
	0x714252, 0xC73FB9, 0x662D89, 0x3D83BA, 0xBDF046, 0x2E4F62,
	0x76B7C0, 0x81336C, 0xBE80A9, 0x4C9D72, 0x739A15, 0x47972C,
	0xA36A1B, 0xD31731, 0x54BA46, 0x2E8C72, 0xFEA5A5, 0x9A7E5F,
	0xC359ED, 0x8F0FFB, 0x1270DA, 0x5E9B08, 0xB0BFCB, 0x36974C,
	0x6CD8F9, 0xD02E1F, 0x1C3F2F, 0xFCF8F0, 0x4C2C6D, 0x0B2169,
	0x48B9CE, 0x42737D, 0xA8E974, 0x64062D, 0xA86C59, 0xEEC419,
	0x047C83, 0x996A23, 0xF2A4C8, 0x4BE1B8, 0x348286, 0xE84240,
	0x8337CB, 0xE55A2F, 0xC17750, 0xA4DA06, 0x64347F, 0x59A5A1,
	0xDFF53D, 0x62A571, 0xEECF3A, 0x886700, 0xC06DAF, 0x4E161F,
	0x12670E, 0xBDFE1A, 0xA72B38, 0x5BA22C, 0xFED227, 0x3FC814,
	0x150E5A, 0xE99B3A, 0x8EE9FC, 0xBC1845, 0x32373A, 0xBDA476,
	0xCEB88F, 0x7FAED3, 0xDB9116, 0x31CF72, 0x1A5136, 0xC4F362,
	0xDE4799, 0x768043, 0x386207, 0x8E5497, 0xB0EF6D, 0x6C57FB,
	0xF56664, 0xD24F05, 0xE0F702, 0x8A41EF, 0xA2EC53, 0x09731C,
	0x6157FE, 0xC5731C, 0xEF1A2E, 0x60EC10, 0xA67EFE, 0x486A73,
	0x8004F6, 0xC3F482, 0x63BA28, 0x107282,
};
#endif
