/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * Copyright (c) 2019, Joyent, Inc.
 * Copyright 2020 OmniOS Community Edition (OmniOSce) Association.
 */

/*
 * This header file defines the interfaces available from the CTF debugger
 * library, libctf.  This library provides functions that a debugger can
 * use to operate on data in the Compact ANSI-C Type Format (CTF).  This
 * is NOT a public interface, although it may eventually become one in
 * the fullness of time after we gain more experience with the interfaces.
 *
 * In the meantime, be aware that any program linked with libctf in this
 * release of illumos is almost guaranteed to break in the next release.
 *
 * In short, do not use this header file or libctf for any purpose.
 */

#ifndef	_LIBCTF_H
#define	_LIBCTF_H

#include <sys/ctf_api.h>
#include <libelf.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This flag can be used to enable debug messages.
 */
extern int _libctf_debug;

typedef enum ctf_diff_flag {
	CTF_DIFF_F_IGNORE_INTNAMES = 0x01
} ctf_diff_flag_t;

typedef struct ctf_diff ctf_diff_t;
typedef void (*ctf_diff_type_f)(ctf_file_t *, ctf_id_t, boolean_t, ctf_file_t *,
    ctf_id_t, void *);
typedef void (*ctf_diff_func_f)(ctf_file_t *, ulong_t, boolean_t, ctf_file_t *,
    ulong_t, void *);
typedef void (*ctf_diff_obj_f)(ctf_file_t *, ulong_t, ctf_id_t, boolean_t,
    ctf_file_t *, ulong_t, ctf_id_t, void *);

extern int ctf_diff_init(ctf_file_t *, ctf_file_t *, ctf_diff_t **);
extern uint_t ctf_diff_getflags(ctf_diff_t *);
extern int ctf_diff_setflags(ctf_diff_t *, uint_t);
extern int ctf_diff_types(ctf_diff_t *, ctf_diff_type_f, void *);
extern int ctf_diff_functions(ctf_diff_t *, ctf_diff_func_f, void *);
extern int ctf_diff_objects(ctf_diff_t *, ctf_diff_obj_f, void *);
extern void ctf_diff_fini(ctf_diff_t *);

#define	CTF_CONVERT_DEFAULT_BATCHSIZE	256
#define	CTF_CONVERT_DEFAULT_NTHREADS	4

typedef enum ctf_convert_flag {
	/*
	 * Normally, we return a failure if we find a C-derived compilation
	 * unit that lacks DWARF or CTF (as required).  This flag over-rides
	 * this check.
	 */
	CTF_ALLOW_MISSING_DEBUG	 = 0x01,
	/*
	 * Normally, we return a failure if we can't fully convert a structure
	 * to CTF format, such as an enum with too many values. This flag
	 * allows us to continue and convert what we can.
	 */
	CTF_ALLOW_TRUNCATION = 0x02,
	/*
	 * Conversion is not usually attempted for objects that don't appear
	 * to be built from C sources. This flag overrides this and attempts
	 * conversion anyway.
	 */
	CTF_FORCE_CONVERSION = 0x04
} ctf_convert_flag_t;

#define	CTF_CONVERT_ALL_FLAGS	(CTF_ALLOW_MISSING_DEBUG | \
				    CTF_ALLOW_TRUNCATION | \
				    CTF_FORCE_CONVERSION)

/* opaque handle for ctfconvert functions */
struct ctf_convert_handle;
typedef struct ctf_convert_handle ctf_convert_t;

extern ctf_convert_t *ctf_convert_init(int *);
extern void ctf_convert_fini(ctf_convert_t *);

typedef void (*ctf_convert_warn_f)(void *, const char *, ...);
/* Any warning callback must be MT-Safe if multiple threads are used */
extern int ctf_convert_set_warncb(ctf_convert_t *, ctf_convert_warn_f, void *);
extern int ctf_convert_set_batchsize(ctf_convert_t *, uint_t);
extern int ctf_convert_set_flags(ctf_convert_t *, ctf_convert_flag_t);
extern int ctf_convert_set_label(ctf_convert_t *, const char *);
extern int ctf_convert_set_nthreads(ctf_convert_t *, uint_t);
extern int ctf_convert_add_ignore(ctf_convert_t *, const char *);

extern ctf_file_t *ctf_fdconvert(ctf_convert_t *, int, int *, char *, size_t);


typedef enum ctf_hsc_ret {
	CHR_ERROR = -1,
	CHR_NO_C_SOURCE = 0,
	CHR_HAS_C_SOURCE = 1
} ctf_hsc_ret_t;

extern ctf_hsc_ret_t ctf_has_c_source(Elf *, char *, size_t);

typedef struct ctf_merge_handle ctf_merge_t;
extern ctf_merge_t *ctf_merge_init(int, int *);
extern int ctf_merge_add(ctf_merge_t *, ctf_file_t *);
extern int ctf_merge_set_nthreads(ctf_merge_t *, const uint_t);
extern int ctf_merge_label(ctf_merge_t *, const char *);
extern int ctf_merge_uniquify(ctf_merge_t *, ctf_file_t *, const char *);
extern int ctf_merge_merge(ctf_merge_t *, ctf_file_t **);
extern int ctf_merge_dedup(ctf_merge_t *, ctf_file_t **);
extern void ctf_merge_fini(ctf_merge_t *);

#define	CTF_ELFWRITE_F_COMPRESS		0x1
extern int ctf_elffdwrite(ctf_file_t *, int, int, int);
extern int ctf_elfwrite(ctf_file_t *, const char *, const char *, int);

#ifdef	__cplusplus
}
#endif

#endif	/* _LIBCTF_H */
