/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 */

/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

#include "lint.h"
#include <string.h>
#include <sys/types.h>

/*
 * Copy s2 to s1, truncating or null-padding to always copy n bytes
 * return a pointer to the terminating null byte in s1, or,
 * if s1 is not null-terminated, s1 + n.
 */
char *
stpncpy(char *_RESTRICT_KYWD s1, const char *_RESTRICT_KYWD s2, size_t n)
{
	size_t len = strnlen(s2, n);

	(void) strncpy(s1, s2, n);

	return ((len < n) ? s1 + len : s1 + n);
}
