/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 * under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
 */

/*
 * Copyright (c) 1994 by Sun Microsystems, Inc.
 */



#ifndef _UTF2JOHAP92_H_
#define _UTF2JOHAP92_H_


#include "hangulcode.h"

typedef struct __conv_desc {
	unsigned short          ci, v, cf;
	enum { E, CI, V, CF }   prev_state;
} _conv_desc;

#define RESET_CONV_DESC()\
			cd->ci = cd->v = cd->cf = CVC_FILL; cd->prev_state = E;
#define PROCESS_PRIOR_CVC()\
	{\
		unsigned short code;\
		\
		if (cd->prev_state != E)\
		{\
			if ((obtail - ob) < 2)\
			{\
				errno = E2BIG;\
				ret_val = (size_t)-1;\
				break;\
			}\
			\
			if ((cd->ci <= 18 || cd->ci == CVC_FILL) &&\
			    (cd->v <= 20 || cd->v == CVC_FILL) &&\
			    (cd->cf <= 28 || cd->cf == CVC_FILL))\
			{\
				code = (cd->ci == CVC_FILL) ? 1 : cd->ci + 2;\
				code = (code<<5) | ((unsigned short)(cd->v ==\
					CVC_FILL) ? 2 : cd->v +\
					(short)(cd->v + 1) / 6 * 2 + 3);\
				code = (code<<5) | ((cd->cf == CVC_FILL) ? 1 : \
					cd->cf + cd->cf / 18) | 0x8000;\
			}\
			else\
			{\
				/* Let's assume the code is non-identical. */\
				code = (((unsigned short)NON_IDENTICAL) << 8) |\
					((unsigned short)NON_IDENTICAL);\
				ret_val += 2;\
			}\
			*ob++ = (char)((code >> 8) & 0xFF);\
			*ob++ = (char)(code & 0xFF);\
			RESET_CONV_DESC();\
		}\
	}

#define MAX_U2J92_NUM		8223

kcode_table utf8_to_johap92_tbl[] = {
	{ 0xD9AE, 0xE082A1 },
	{ 0xD9B4, 0xE082A4 },
	{ 0xD967, 0xE082A7 },
	{ 0xD937, 0xE082A8 },
	{ 0xDCA3, 0xE082AA },
	{ 0xD97C, 0xE082AB },
	{ 0xD956, 0xE082B0 },
	{ 0xD94E, 0xE082B1 },
	{ 0xDD99, 0xE082B2 },
	{ 0xDD9A, 0xE082B3 },
	{ 0xD9A5, 0xE082B4 },
	{ 0xD9D2, 0xE082B6 },
	{ 0xD9AC, 0xE082B8 },
	{ 0xDD98, 0xE082B9 },
	{ 0xDCAC, 0xE082BA },
	{ 0xD97D, 0xE082BB },
	{ 0xDCF9, 0xE082BC },
	{ 0xDCF6, 0xE082BD },
	{ 0xDCFA, 0xE082BE },
	{ 0xD9AF, 0xE082BF },
	{ 0xDCA1, 0xE08386 },
	{ 0xDCA2, 0xE08390 },
	{ 0xD94F, 0xE08397 },
	{ 0xDCAA, 0xE08398 },
	{ 0xDCAD, 0xE0839E },
	{ 0xDD3C, 0xE0839F },
	{ 0xDD31, 0xE083A6 },
	{ 0xDD33, 0xE083B0 },
	{ 0xD950, 0xE083B7 },
	{ 0xDD3A, 0xE083B8 },
	{ 0xDD3D, 0xE083BE },
	{ 0xDD32, 0xE08491 },
	{ 0xDCA4, 0xE084A6 },
	{ 0xDD34, 0xE084A7 },
	{ 0xDD35, 0xE084B1 },
	{ 0xDCA6, 0xE084B2 },
	{ 0xDD36, 0xE084B3 },
	{ 0xDD37, 0xE084B8 },
	{ 0xDCA8, 0xE084BF },
	{ 0xDD38, 0xE08580 },
	{ 0xDCA9, 0xE08581 },
	{ 0xDD39, 0xE08582 },
	{ 0xDD40, 0xE08589 },
	{ 0xDCAF, 0xE0858A },
	{ 0xDD3F, 0xE0858B },
	{ 0xDCAB, 0xE08592 },
	{ 0xDD3B, 0xE08593 },
	{ 0xDCAE, 0xE085A6 },
	{ 0xDD3E, 0xE085A7 },
	{ 0xD9A7, 0xE08B87 },
	{ 0xD9A8, 0xE08B98 },
	{ 0xD9AB, 0xE08B99 },
	{ 0xD9AA, 0xE08B9A },
	{ 0xD9AD, 0xE08B9B },
	{ 0xD9A6, 0xE08B9C },
	{ 0xD9A9, 0xE08B9D },
	{ 0xDB51, 0xE08E91 },
	{ 0xDB52, 0xE08E92 },
	{ 0xDB53, 0xE08E93 },
	{ 0xDB54, 0xE08E94 },
	{ 0xDB55, 0xE08E95 },
	{ 0xDB56, 0xE08E96 },
	{ 0xDB57, 0xE08E97 },
	{ 0xDB58, 0xE08E98 },
	{ 0xDB59, 0xE08E99 },
	{ 0xDB5A, 0xE08E9A },
	{ 0xDB5B, 0xE08E9B },
	{ 0xDB5C, 0xE08E9C },
	{ 0xDB5D, 0xE08E9D },
	{ 0xDB5E, 0xE08E9E },
	{ 0xDB5F, 0xE08E9F },
	{ 0xDB60, 0xE08EA0 },
	{ 0xDB61, 0xE08EA1 },
	{ 0xDB62, 0xE08EA3 },
	{ 0xDB63, 0xE08EA4 },
	{ 0xDB64, 0xE08EA5 },
	{ 0xDB65, 0xE08EA6 },
	{ 0xDB66, 0xE08EA7 },
	{ 0xDB67, 0xE08EA8 },
	{ 0xDB68, 0xE08EA9 },
	{ 0xDB71, 0xE08EB1 },
	{ 0xDB72, 0xE08EB2 },
	{ 0xDB73, 0xE08EB3 },
	{ 0xDB74, 0xE08EB4 },
	{ 0xDB75, 0xE08EB5 },
	{ 0xDB76, 0xE08EB6 },
	{ 0xDB77, 0xE08EB7 },
	{ 0xDB78, 0xE08EB8 },
	{ 0xDB79, 0xE08EB9 },
	{ 0xDB7A, 0xE08EBA },
	{ 0xDB7B, 0xE08EBB },
	{ 0xDB7C, 0xE08EBC },
	{ 0xDB7D, 0xE08EBD },
	{ 0xDB7E, 0xE08EBE },
	{ 0xDB91, 0xE08EBF },
	{ 0xDB92, 0xE08F80 },
	{ 0xDB93, 0xE08F81 },
	{ 0xDB94, 0xE08F83 },
	{ 0xDB95, 0xE08F84 },
	{ 0xDB96, 0xE08F85 },
	{ 0xDB97, 0xE08F86 },
	{ 0xDB98, 0xE08F87 },
	{ 0xDB99, 0xE08F88 },
	{ 0xDB9A, 0xE08F89 },
	{ 0xDEA7, 0xE09081 },
	{ 0xDEA1, 0xE09090 },
	{ 0xDEA2, 0xE09091 },
	{ 0xDEA3, 0xE09092 },
	{ 0xDEA4, 0xE09093 },
	{ 0xDEA5, 0xE09094 },
	{ 0xDEA6, 0xE09095 },
	{ 0xDEA8, 0xE09096 },
	{ 0xDEA9, 0xE09097 },
	{ 0xDEAA, 0xE09098 },
	{ 0xDEAB, 0xE09099 },
	{ 0xDEAC, 0xE0909A },
	{ 0xDEAD, 0xE0909B },
	{ 0xDEAE, 0xE0909C },
	{ 0xDEAF, 0xE0909D },
	{ 0xDEB0, 0xE0909E },
	{ 0xDEB1, 0xE0909F },
	{ 0xDEB2, 0xE090A0 },
	{ 0xDEB3, 0xE090A1 },
	{ 0xDEB4, 0xE090A2 },
	{ 0xDEB5, 0xE090A3 },
	{ 0xDEB6, 0xE090A4 },
	{ 0xDEB7, 0xE090A5 },
	{ 0xDEB8, 0xE090A6 },
	{ 0xDEB9, 0xE090A7 },
	{ 0xDEBA, 0xE090A8 },
	{ 0xDEBB, 0xE090A9 },
	{ 0xDEBC, 0xE090AA },
	{ 0xDEBD, 0xE090AB },
	{ 0xDEBE, 0xE090AC },
	{ 0xDEBF, 0xE090AD },
	{ 0xDEC0, 0xE090AE },
	{ 0xDEC1, 0xE090AF },
	{ 0xDED1, 0xE090B0 },
	{ 0xDED2, 0xE090B1 },
	{ 0xDED3, 0xE090B2 },
	{ 0xDED4, 0xE090B3 },
	{ 0xDED5, 0xE090B4 },
	{ 0xDED6, 0xE090B5 },
	{ 0xDED8, 0xE090B6 },
	{ 0xDED9, 0xE090B7 },
	{ 0xDEDA, 0xE090B8 },
	{ 0xDEDB, 0xE090B9 },
	{ 0xDEDC, 0xE090BA },
	{ 0xDEDD, 0xE090BB },
	{ 0xDEDE, 0xE090BC },
	{ 0xDEDF, 0xE090BD },
	{ 0xDEE0, 0xE090BE },
	{ 0xDEE1, 0xE090BF },
	{ 0xDEE2, 0xE09180 },
	{ 0xDEE3, 0xE09181 },
	{ 0xDEE4, 0xE09182 },
	{ 0xDEE5, 0xE09183 },
	{ 0xDEE6, 0xE09184 },
	{ 0xDEE7, 0xE09185 },
	{ 0xDEE8, 0xE09186 },
	{ 0xDEE9, 0xE09187 },
	{ 0xDEEA, 0xE09188 },
	{ 0xDEEB, 0xE09189 },
	{ 0xDEEC, 0xE0918A },
	{ 0xDEED, 0xE0918B },
	{ 0xDEEE, 0xE0918C },
	{ 0xDEEF, 0xE0918D },
	{ 0xDEF0, 0xE0918E },
	{ 0xDEF1, 0xE0918F },
	{ 0xDED7, 0xE09191 },
	{ 0xD939, 0xE28093 },
	{ 0xD93A, 0xE28094 },
	{ 0xD93B, 0xE28096 },
	{ 0xD93E, 0xE28098 },
	{ 0xD93F, 0xE28099 },
	{ 0xD940, 0xE2809C },
	{ 0xD941, 0xE2809D },
	{ 0xD9D3, 0xE280A0 },
	{ 0xD9D4, 0xE280A1 },
	{ 0xD935, 0xE280A5 },
	{ 0xD936, 0xE280A6 },
	{ 0xD9B6, 0xE280B0 },
	{ 0xD957, 0xE280B2 },
	{ 0xD958, 0xE280B3 },
	{ 0xD968, 0xE280BB },
	{ 0xDD9B, 0xE281B4 },
	{ 0xDD9C, 0xE281BF },
	{ 0xDD9D, 0xE28281 },
	{ 0xDD9E, 0xE28282 },
	{ 0xDD9F, 0xE28283 },
	{ 0xDDA0, 0xE28284 },
	{ 0xD959, 0xE28483 },
	{ 0xD9B5, 0xE28489 },
	{ 0xDC34, 0xE28493 },
	{ 0xD9E0, 0xE28496 },
	{ 0xD9E5, 0xE284A1 },
	{ 0xD9E2, 0xE284A2 },
	{ 0xDC69, 0xE284A6 },
	{ 0xD95A, 0xE284AB },
	{ 0xDCF7, 0xE28593 },
	{ 0xDCF8, 0xE28594 },
	{ 0xDCFB, 0xE2859B },
	{ 0xDCFC, 0xE2859C },
	{ 0xDCFD, 0xE2859D },
	{ 0xDCFE, 0xE2859E },
	{ 0xDB40, 0xE285A0 },
	{ 0xDB41, 0xE285A1 },
	{ 0xDB42, 0xE285A2 },
	{ 0xDB43, 0xE285A3 },
	{ 0xDB44, 0xE285A4 },
	{ 0xDB45, 0xE285A5 },
	{ 0xDB46, 0xE285A6 },
	{ 0xDB47, 0xE285A7 },
	{ 0xDB48, 0xE285A8 },
	{ 0xDB49, 0xE285A9 },
	{ 0xDB31, 0xE285B0 },
	{ 0xDB32, 0xE285B1 },
	{ 0xDB33, 0xE285B2 },
	{ 0xDB34, 0xE285B3 },
	{ 0xDB35, 0xE285B4 },
	{ 0xDB36, 0xE285B5 },
	{ 0xDB37, 0xE285B6 },
	{ 0xDB38, 0xE285B7 },
	{ 0xDB39, 0xE285B8 },
	{ 0xDB3A, 0xE285B9 },
	{ 0xD977, 0xE28690 },
	{ 0xD978, 0xE28691 },
	{ 0xD976, 0xE28692 },
	{ 0xD979, 0xE28693 },
	{ 0xD97A, 0xE28694 },
	{ 0xD9D5, 0xE28695 },
	{ 0xD9D8, 0xE28696 },
	{ 0xD9D6, 0xE28697 },
	{ 0xD9D9, 0xE28698 },
	{ 0xD9D7, 0xE28699 },
	{ 0xD9A1, 0xE28792 },
	{ 0xD9A2, 0xE28794 },
	{ 0xD9A3, 0xE28880 },
	{ 0xD963, 0xE28882 },
	{ 0xD9A4, 0xE28883 },
	{ 0xD964, 0xE28887 },
	{ 0xD996, 0xE28888 },
	{ 0xD997, 0xE2888B },
	{ 0xD9B3, 0xE2888F },
	{ 0xD9B2, 0xE28891 },
	{ 0xD97E, 0xE2889A },
	{ 0xD992, 0xE2889D },
	{ 0xD954, 0xE2889E },
	{ 0xD960, 0xE288A0 },
	{ 0xD99E, 0xE288A7 },
	{ 0xD99F, 0xE288A8 },
	{ 0xD99D, 0xE288A9 },
	{ 0xD99C, 0xE288AA },
	{ 0xD994, 0xE288AB },
	{ 0xD995, 0xE288AC },
	{ 0xD9B1, 0xE288AE },
	{ 0xD955, 0xE288B4 },
	{ 0xD993, 0xE288B5 },
	{ 0xD9B0, 0xE288B6 },
	{ 0xD991, 0xE288BD },
	{ 0xD966, 0xE28992 },
	{ 0xD951, 0xE289A0 },
	{ 0xD965, 0xE289A1 },
	{ 0xD952, 0xE289A4 },
	{ 0xD953, 0xE289A5 },
	{ 0xD99A, 0xE28A82 },
	{ 0xD99B, 0xE28A83 },
	{ 0xD998, 0xE28A86 },
	{ 0xD999, 0xE28A87 },
	{ 0xD961, 0xE28AA5 },
	{ 0xD962, 0xE28C92 },
	{ 0xDCE7, 0xE291A0 },
	{ 0xDCE8, 0xE291A1 },
	{ 0xDCE9, 0xE291A2 },
	{ 0xDCEA, 0xE291A3 },
	{ 0xDCEB, 0xE291A4 },
	{ 0xDCEC, 0xE291A5 },
	{ 0xDCED, 0xE291A6 },
	{ 0xDCEE, 0xE291A7 },
	{ 0xDCEF, 0xE291A8 },
	{ 0xDCF0, 0xE291A9 },
	{ 0xDCF1, 0xE291AA },
	{ 0xDCF2, 0xE291AB },
	{ 0xDCF3, 0xE291AC },
	{ 0xDCF4, 0xE291AD },
	{ 0xDCF5, 0xE291AE },
	{ 0xDD77, 0xE291B4 },
	{ 0xDD78, 0xE291B5 },
	{ 0xDD79, 0xE291B6 },
	{ 0xDD7A, 0xE291B7 },
	{ 0xDD7B, 0xE291B8 },
	{ 0xDD7C, 0xE291B9 },
	{ 0xDD7D, 0xE291BA },
	{ 0xDD7E, 0xE291BB },
	{ 0xDD91, 0xE291BC },
	{ 0xDD92, 0xE291BD },
	{ 0xDD93, 0xE291BE },
	{ 0xDD94, 0xE291BF },
	{ 0xDD95, 0xE29280 },
	{ 0xDD96, 0xE29281 },
	{ 0xDD97, 0xE29282 },
	{ 0xDD5D, 0xE2929C },
	{ 0xDD5E, 0xE2929D },
	{ 0xDD5F, 0xE2929E },
	{ 0xDD60, 0xE2929F },
	{ 0xDD61, 0xE292A0 },
	{ 0xDD62, 0xE292A1 },
	{ 0xDD63, 0xE292A2 },
	{ 0xDD64, 0xE292A3 },
	{ 0xDD65, 0xE292A4 },
	{ 0xDD66, 0xE292A5 },
	{ 0xDD67, 0xE292A6 },
	{ 0xDD68, 0xE292A7 },
	{ 0xDD69, 0xE292A8 },
	{ 0xDD6A, 0xE292A9 },
	{ 0xDD6B, 0xE292AA },
	{ 0xDD6C, 0xE292AB },
	{ 0xDD6D, 0xE292AC },
	{ 0xDD6E, 0xE292AD },
	{ 0xDD6F, 0xE292AE },
	{ 0xDD70, 0xE292AF },
	{ 0xDD71, 0xE292B0 },
	{ 0xDD72, 0xE292B1 },
	{ 0xDD73, 0xE292B2 },
	{ 0xDD74, 0xE292B3 },
	{ 0xDD75, 0xE292B4 },
	{ 0xDD76, 0xE292B5 },
	{ 0xDCCD, 0xE29390 },
	{ 0xDCCE, 0xE29391 },
	{ 0xDCCF, 0xE29392 },
	{ 0xDCD0, 0xE29393 },
	{ 0xDCD1, 0xE29394 },
	{ 0xDCD2, 0xE29395 },
	{ 0xDCD3, 0xE29396 },
	{ 0xDCD4, 0xE29397 },
	{ 0xDCD5, 0xE29398 },
	{ 0xDCD6, 0xE29399 },
	{ 0xDCD7, 0xE2939A },
	{ 0xDCD8, 0xE2939B },
	{ 0xDCD9, 0xE2939C },
	{ 0xDCDA, 0xE2939D },
	{ 0xDCDB, 0xE2939E },
	{ 0xDCDC, 0xE2939F },
	{ 0xDCDD, 0xE293A0 },
	{ 0xDCDE, 0xE293A1 },
	{ 0xDCDF, 0xE293A2 },
	{ 0xDCE0, 0xE293A3 },
	{ 0xDCE1, 0xE293A4 },
	{ 0xDCE2, 0xE293A5 },
	{ 0xDCE3, 0xE293A6 },
	{ 0xDCE4, 0xE293A7 },
	{ 0xDCE5, 0xE293A8 },
	{ 0xDCE6, 0xE293A9 },
	{ 0xDBA1, 0xE29480 },
	{ 0xDBAC, 0xE29481 },
	{ 0xDBA2, 0xE29482 },
	{ 0xDBAD, 0xE29483 },
	{ 0xDBA3, 0xE2948C },
	{ 0xDBC8, 0xE2948D },
	{ 0xDBC7, 0xE2948E },
	{ 0xDBAE, 0xE2948F },
	{ 0xDBA4, 0xE29490 },
	{ 0xDBC2, 0xE29491 },
	{ 0xDBC1, 0xE29492 },
	{ 0xDBAF, 0xE29493 },
	{ 0xDBA6, 0xE29494 },
	{ 0xDBC6, 0xE29495 },
	{ 0xDBC5, 0xE29496 },
	{ 0xDBB1, 0xE29497 },
	{ 0xDBA5, 0xE29498 },
	{ 0xDBC4, 0xE29499 },
	{ 0xDBC3, 0xE2949A },
	{ 0xDBB0, 0xE2949B },
	{ 0xDBA7, 0xE2949C },
	{ 0xDBBC, 0xE2949D },
	{ 0xDBC9, 0xE2949E },
	{ 0xDBCA, 0xE2949F },
	{ 0xDBB7, 0xE294A0 },
	{ 0xDBCB, 0xE294A1 },
	{ 0xDBCC, 0xE294A2 },
	{ 0xDBB2, 0xE294A3 },
	{ 0xDBA9, 0xE294A4 },
	{ 0xDBBE, 0xE294A5 },
	{ 0xDBCD, 0xE294A6 },
	{ 0xDBCE, 0xE294A7 },
	{ 0xDBB9, 0xE294A8 },
	{ 0xDBCF, 0xE294A9 },
	{ 0xDBD0, 0xE294AA },
	{ 0xDBB4, 0xE294AB },
	{ 0xDBA8, 0xE294AC },
	{ 0xDBD1, 0xE294AD },
	{ 0xDBD2, 0xE294AE },
	{ 0xDBB8, 0xE294AF },
	{ 0xDBBD, 0xE294B0 },
	{ 0xDBD3, 0xE294B1 },
	{ 0xDBD4, 0xE294B2 },
	{ 0xDBB3, 0xE294B3 },
	{ 0xDBAA, 0xE294B4 },
	{ 0xDBD5, 0xE294B5 },
	{ 0xDBD6, 0xE294B6 },
	{ 0xDBBA, 0xE294B7 },
	{ 0xDBBF, 0xE294B8 },
	{ 0xDBD7, 0xE294B9 },
	{ 0xDBD8, 0xE294BA },
	{ 0xDBB5, 0xE294BB },
	{ 0xDBAB, 0xE294BC },
	{ 0xDBD9, 0xE294BD },
	{ 0xDBDA, 0xE294BE },
	{ 0xDBBB, 0xE294BF },
	{ 0xDBDB, 0xE29580 },
	{ 0xDBDC, 0xE29581 },
	{ 0xDBC0, 0xE29582 },
	{ 0xDBDD, 0xE29583 },
	{ 0xDBDE, 0xE29584 },
	{ 0xDBDF, 0xE29585 },
	{ 0xDBE0, 0xE29586 },
	{ 0xDBE1, 0xE29587 },
	{ 0xDBE2, 0xE29588 },
	{ 0xDBE3, 0xE29589 },
	{ 0xDBE4, 0xE2958A },
	{ 0xDBB6, 0xE2958B },
	{ 0xD9C6, 0xE29692 },
	{ 0xD971, 0xE296A0 },
	{ 0xD970, 0xE296A1 },
	{ 0xD9C3, 0xE296A3 },
	{ 0xD9C7, 0xE296A4 },
	{ 0xD9C8, 0xE296A5 },
	{ 0xD9CB, 0xE296A6 },
	{ 0xD9CA, 0xE296A7 },
	{ 0xD9C9, 0xE296A8 },
	{ 0xD9CC, 0xE296A9 },
	{ 0xD973, 0xE296B2 },
	{ 0xD972, 0xE296B3 },
	{ 0xD9BA, 0xE296B6 },
	{ 0xD9B9, 0xE296B7 },
	{ 0xD975, 0xE296BC },
	{ 0xD974, 0xE296BD },
	{ 0xD9B8, 0xE29780 },
	{ 0xD9B7, 0xE29781 },
	{ 0xD96F, 0xE29786 },
	{ 0xD96E, 0xE29787 },
	{ 0xD9C2, 0xE29788 },
	{ 0xD9C1, 0xE29789 },
	{ 0xD96B, 0xE2978B },
	{ 0xD96D, 0xE2978E },
	{ 0xD96C, 0xE2978F },
	{ 0xD9C4, 0xE29790 },
	{ 0xD9C5, 0xE29791 },
	{ 0xD96A, 0xE29885 },
	{ 0xD969, 0xE29886 },
	{ 0xD9CF, 0xE2988E },
	{ 0xD9CE, 0xE2988F },
	{ 0xD9D0, 0xE2989C },
	{ 0xD9D1, 0xE2989E },
	{ 0xD95F, 0xE29980 },
	{ 0xD95E, 0xE29982 },
	{ 0xD9BC, 0xE299A0 },
	{ 0xD9BD, 0xE299A1 },
	{ 0xD9C0, 0xE299A3 },
	{ 0xD9BB, 0xE299A4 },
	{ 0xD9BE, 0xE299A5 },
	{ 0xD9BF, 0xE299A7 },
	{ 0xD9CD, 0xE299A8 },
	{ 0xD9DB, 0xE299A9 },
	{ 0xD9DC, 0xE299AA },
	{ 0xD9DD, 0xE299AC },
	{ 0xD9DA, 0xE299AD },
	{ 0xD931, 0xE38080 },
	{ 0xD932, 0xE38081 },
	{ 0xD933, 0xE38082 },
	{ 0xD938, 0xE38083 },
	{ 0xD944, 0xE38088 },
	{ 0xD945, 0xE38089 },
	{ 0xD946, 0xE3808A },
	{ 0xD947, 0xE3808B },
	{ 0xD948, 0xE3808C },
	{ 0xD949, 0xE3808D },
	{ 0xD94A, 0xE3808E },
	{ 0xD94B, 0xE3808F },
	{ 0xD94C, 0xE38090 },
	{ 0xD94D, 0xE38091 },
	{ 0xD97B, 0xE38093 },
	{ 0xD942, 0xE38094 },
	{ 0xD943, 0xE38095 },
	{ 0xDDA1, 0xE38181 },
	{ 0xDDA2, 0xE38182 },
	{ 0xDDA3, 0xE38183 },
	{ 0xDDA4, 0xE38184 },
	{ 0xDDA5, 0xE38185 },
	{ 0xDDA6, 0xE38186 },
	{ 0xDDA7, 0xE38187 },
	{ 0xDDA8, 0xE38188 },
	{ 0xDDA9, 0xE38189 },
	{ 0xDDAA, 0xE3818A },
	{ 0xDDAB, 0xE3818B },
	{ 0xDDAC, 0xE3818C },
	{ 0xDDAD, 0xE3818D },
	{ 0xDDAE, 0xE3818E },
	{ 0xDDAF, 0xE3818F },
	{ 0xDDB0, 0xE38190 },
	{ 0xDDB1, 0xE38191 },
	{ 0xDDB2, 0xE38192 },
	{ 0xDDB3, 0xE38193 },
	{ 0xDDB4, 0xE38194 },
	{ 0xDDB5, 0xE38195 },
	{ 0xDDB6, 0xE38196 },
	{ 0xDDB7, 0xE38197 },
	{ 0xDDB8, 0xE38198 },
	{ 0xDDB9, 0xE38199 },
	{ 0xDDBA, 0xE3819A },
	{ 0xDDBB, 0xE3819B },
	{ 0xDDBC, 0xE3819C },
	{ 0xDDBD, 0xE3819D },
	{ 0xDDBE, 0xE3819E },
	{ 0xDDBF, 0xE3819F },
	{ 0xDDC0, 0xE381A0 },
	{ 0xDDC1, 0xE381A1 },
	{ 0xDDC2, 0xE381A2 },
	{ 0xDDC3, 0xE381A3 },
	{ 0xDDC4, 0xE381A4 },
	{ 0xDDC5, 0xE381A5 },
	{ 0xDDC6, 0xE381A6 },
	{ 0xDDC7, 0xE381A7 },
	{ 0xDDC8, 0xE381A8 },
	{ 0xDDC9, 0xE381A9 },
	{ 0xDDCA, 0xE381AA },
	{ 0xDDCB, 0xE381AB },
	{ 0xDDCC, 0xE381AC },
	{ 0xDDCD, 0xE381AD },
	{ 0xDDCE, 0xE381AE },
	{ 0xDDCF, 0xE381AF },
	{ 0xDDD0, 0xE381B0 },
	{ 0xDDD1, 0xE381B1 },
	{ 0xDDD2, 0xE381B2 },
	{ 0xDDD3, 0xE381B3 },
	{ 0xDDD4, 0xE381B4 },
	{ 0xDDD5, 0xE381B5 },
	{ 0xDDD6, 0xE381B6 },
	{ 0xDDD7, 0xE381B7 },
	{ 0xDDD8, 0xE381B8 },
	{ 0xDDD9, 0xE381B9 },
	{ 0xDDDA, 0xE381BA },
	{ 0xDDDB, 0xE381BB },
	{ 0xDDDC, 0xE381BC },
	{ 0xDDDD, 0xE381BD },
	{ 0xDDDE, 0xE381BE },
	{ 0xDDDF, 0xE381BF },
	{ 0xDDE0, 0xE38280 },
	{ 0xDDE1, 0xE38281 },
	{ 0xDDE2, 0xE38282 },
	{ 0xDDE3, 0xE38283 },
	{ 0xDDE4, 0xE38284 },
	{ 0xDDE5, 0xE38285 },
	{ 0xDDE6, 0xE38286 },
	{ 0xDDE7, 0xE38287 },
	{ 0xDDE8, 0xE38288 },
	{ 0xDDE9, 0xE38289 },
	{ 0xDDEA, 0xE3828A },
	{ 0xDDEB, 0xE3828B },
	{ 0xDDEC, 0xE3828C },
	{ 0xDDED, 0xE3828D },
	{ 0xDDEE, 0xE3828E },
	{ 0xDDEF, 0xE3828F },
	{ 0xDDF0, 0xE38290 },
	{ 0xDDF1, 0xE38291 },
	{ 0xDDF2, 0xE38292 },
	{ 0xDDF3, 0xE38293 },
	{ 0xDE31, 0xE382A1 },
	{ 0xDE32, 0xE382A2 },
	{ 0xDE33, 0xE382A3 },
	{ 0xDE34, 0xE382A4 },
	{ 0xDE35, 0xE382A5 },
	{ 0xDE36, 0xE382A6 },
	{ 0xDE37, 0xE382A7 },
	{ 0xDE38, 0xE382A8 },
	{ 0xDE39, 0xE382A9 },
	{ 0xDE3A, 0xE382AA },
	{ 0xDE3B, 0xE382AB },
	{ 0xDE3C, 0xE382AC },
	{ 0xDE3D, 0xE382AD },
	{ 0xDE3E, 0xE382AE },
	{ 0xDE3F, 0xE382AF },
	{ 0xDE40, 0xE382B0 },
	{ 0xDE41, 0xE382B1 },
	{ 0xDE42, 0xE382B2 },
	{ 0xDE43, 0xE382B3 },
	{ 0xDE44, 0xE382B4 },
	{ 0xDE45, 0xE382B5 },
	{ 0xDE46, 0xE382B6 },
	{ 0xDE47, 0xE382B7 },
	{ 0xDE48, 0xE382B8 },
	{ 0xDE49, 0xE382B9 },
	{ 0xDE4A, 0xE382BA },
	{ 0xDE4B, 0xE382BB },
	{ 0xDE4C, 0xE382BC },
	{ 0xDE4D, 0xE382BD },
	{ 0xDE4E, 0xE382BE },
	{ 0xDE4F, 0xE382BF },
	{ 0xDE50, 0xE38380 },
	{ 0xDE51, 0xE38381 },
	{ 0xDE52, 0xE38382 },
	{ 0xDE53, 0xE38383 },
	{ 0xDE54, 0xE38384 },
	{ 0xDE55, 0xE38385 },
	{ 0xDE56, 0xE38386 },
	{ 0xDE57, 0xE38387 },
	{ 0xDE58, 0xE38388 },
	{ 0xDE59, 0xE38389 },
	{ 0xDE5A, 0xE3838A },
	{ 0xDE5B, 0xE3838B },
	{ 0xDE5C, 0xE3838C },
	{ 0xDE5D, 0xE3838D },
	{ 0xDE5E, 0xE3838E },
	{ 0xDE5F, 0xE3838F },
	{ 0xDE60, 0xE38390 },
	{ 0xDE61, 0xE38391 },
	{ 0xDE62, 0xE38392 },
	{ 0xDE63, 0xE38393 },
	{ 0xDE64, 0xE38394 },
	{ 0xDE65, 0xE38395 },
	{ 0xDE66, 0xE38396 },
	{ 0xDE67, 0xE38397 },
	{ 0xDE68, 0xE38398 },
	{ 0xDE69, 0xE38399 },
	{ 0xDE6A, 0xE3839A },
	{ 0xDE6B, 0xE3839B },
	{ 0xDE6C, 0xE3839C },
	{ 0xDE6D, 0xE3839D },
	{ 0xDE6E, 0xE3839E },
	{ 0xDE6F, 0xE3839F },
	{ 0xDE70, 0xE383A0 },
	{ 0xDE71, 0xE383A1 },
	{ 0xDE72, 0xE383A2 },
	{ 0xDE73, 0xE383A3 },
	{ 0xDE74, 0xE383A4 },
	{ 0xDE75, 0xE383A5 },
	{ 0xDE76, 0xE383A6 },
	{ 0xDE77, 0xE383A7 },
	{ 0xDE78, 0xE383A8 },
	{ 0xDE79, 0xE383A9 },
	{ 0xDE7A, 0xE383AA },
	{ 0xDE7B, 0xE383AB },
	{ 0xDE7C, 0xE383AC },
	{ 0xDE7D, 0xE383AD },
	{ 0xDE7E, 0xE383AE },
	{ 0xDE91, 0xE383AF },
	{ 0xDE92, 0xE383B0 },
	{ 0xDE93, 0xE383B1 },
	{ 0xDE94, 0xE383B2 },
	{ 0xDE95, 0xE383B3 },
	{ 0xDE96, 0xE383B4 },
	{ 0xDE97, 0xE383B5 },
	{ 0xDE98, 0xE383B6 },
	{ 0xD934, 0xE383BB },
	{ 0xDAA1, 0xE384B1 },
	{ 0xDAA2, 0xE384B2 },
	{ 0xDAA3, 0xE384B3 },
	{ 0xDAA4, 0xE384B4 },
	{ 0xDAA5, 0xE384B5 },
	{ 0xDAA6, 0xE384B6 },
	{ 0xDAA7, 0xE384B7 },
	{ 0xDAA8, 0xE384B8 },
	{ 0xDAA9, 0xE384B9 },
	{ 0xDAAA, 0xE384BA },
	{ 0xDAAB, 0xE384BB },
	{ 0xDAAC, 0xE384BC },
	{ 0xDAAD, 0xE384BD },
	{ 0xDAAE, 0xE384BE },
	{ 0xDAAF, 0xE384BF },
	{ 0xDAB0, 0xE38580 },
	{ 0xDAB1, 0xE38581 },
	{ 0xDAB2, 0xE38582 },
	{ 0xDAB3, 0xE38583 },
	{ 0xDAB4, 0xE38584 },
	{ 0xDAB5, 0xE38585 },
	{ 0xDAB6, 0xE38586 },
	{ 0xDAB7, 0xE38587 },
	{ 0xDAB8, 0xE38588 },
	{ 0xDAB9, 0xE38589 },
	{ 0xDABA, 0xE3858A },
	{ 0xDABB, 0xE3858B },
	{ 0xDABC, 0xE3858C },
	{ 0xDABD, 0xE3858D },
	{ 0xDABE, 0xE3858E },
	{ 0xDABF, 0xE3858F },
	{ 0xDAC0, 0xE38590 },
	{ 0xDAC1, 0xE38591 },
	{ 0xDAC2, 0xE38592 },
	{ 0xDAC3, 0xE38593 },
	{ 0xDAC4, 0xE38594 },
	{ 0xDAC5, 0xE38595 },
	{ 0xDAC6, 0xE38596 },
	{ 0xDAC7, 0xE38597 },
	{ 0xDAC8, 0xE38598 },
	{ 0xDAC9, 0xE38599 },
	{ 0xDACA, 0xE3859A },
	{ 0xDACB, 0xE3859B },
	{ 0xDACC, 0xE3859C },
	{ 0xDACD, 0xE3859D },
	{ 0xDACE, 0xE3859E },
	{ 0xDACF, 0xE3859F },
	{ 0xDAD0, 0xE385A0 },
	{ 0xDAD1, 0xE385A1 },
	{ 0xDAD2, 0xE385A2 },
	{ 0xDAD3, 0xE385A3 },
	{ 0xDAD4, 0xE385A4 },
	{ 0xDAD5, 0xE385A5 },
	{ 0xDAD6, 0xE385A6 },
	{ 0xDAD7, 0xE385A7 },
	{ 0xDAD8, 0xE385A8 },
	{ 0xDAD9, 0xE385A9 },
	{ 0xDADA, 0xE385AA },
	{ 0xDADB, 0xE385AB },
	{ 0xDADC, 0xE385AC },
	{ 0xDADD, 0xE385AD },
	{ 0xDADE, 0xE385AE },
	{ 0xDADF, 0xE385AF },
	{ 0xDAE0, 0xE385B0 },
	{ 0xDAE1, 0xE385B1 },
	{ 0xDAE2, 0xE385B2 },
	{ 0xDAE3, 0xE385B3 },
	{ 0xDAE4, 0xE385B4 },
	{ 0xDAE5, 0xE385B5 },
	{ 0xDAE6, 0xE385B6 },
	{ 0xDAE7, 0xE385B7 },
	{ 0xDAE8, 0xE385B8 },
	{ 0xDAE9, 0xE385B9 },
	{ 0xDAEA, 0xE385BA },
	{ 0xDAEB, 0xE385BB },
	{ 0xDAEC, 0xE385BC },
	{ 0xDAED, 0xE385BD },
	{ 0xDAEE, 0xE385BE },
	{ 0xDAEF, 0xE385BF },
	{ 0xDAF0, 0xE38680 },
	{ 0xDAF1, 0xE38681 },
	{ 0xDAF2, 0xE38682 },
	{ 0xDAF3, 0xE38683 },
	{ 0xDAF4, 0xE38684 },
	{ 0xDAF5, 0xE38685 },
	{ 0xDAF6, 0xE38686 },
	{ 0xDAF7, 0xE38687 },
	{ 0xDAF8, 0xE38688 },
	{ 0xDAF9, 0xE38689 },
	{ 0xDAFA, 0xE3868A },
	{ 0xDAFB, 0xE3868B },
	{ 0xDAFC, 0xE3868C },
	{ 0xDAFD, 0xE3868D },
	{ 0xDAFE, 0xE3868E },
	{ 0xDD41, 0xE38880 },
	{ 0xDD42, 0xE38881 },
	{ 0xDD43, 0xE38882 },
	{ 0xDD44, 0xE38883 },
	{ 0xDD45, 0xE38884 },
	{ 0xDD46, 0xE38885 },
	{ 0xDD47, 0xE38886 },
	{ 0xDD48, 0xE38887 },
	{ 0xDD49, 0xE38888 },
	{ 0xDD4A, 0xE38889 },
	{ 0xDD4B, 0xE3888A },
	{ 0xDD4C, 0xE3888B },
	{ 0xDD4D, 0xE3888C },
	{ 0xDD4E, 0xE3888D },
	{ 0xDD4F, 0xE3888E },
	{ 0xDD50, 0xE3888F },
	{ 0xDD51, 0xE38890 },
	{ 0xDD52, 0xE38891 },
	{ 0xDD53, 0xE38892 },
	{ 0xDD54, 0xE38893 },
	{ 0xDD55, 0xE38894 },
	{ 0xDD56, 0xE38895 },
	{ 0xDD57, 0xE38896 },
	{ 0xDD58, 0xE38897 },
	{ 0xDD59, 0xE38898 },
	{ 0xDD5A, 0xE38899 },
	{ 0xDD5B, 0xE3889A },
	{ 0xDD5C, 0xE3889B },
	{ 0xD9DF, 0xE3889C },
	{ 0xDCB1, 0xE389A0 },
	{ 0xDCB2, 0xE389A1 },
	{ 0xDCB3, 0xE389A2 },
	{ 0xDCB4, 0xE389A3 },
	{ 0xDCB5, 0xE389A4 },
	{ 0xDCB6, 0xE389A5 },
	{ 0xDCB7, 0xE389A6 },
	{ 0xDCB8, 0xE389A7 },
	{ 0xDCB9, 0xE389A8 },
	{ 0xDCBA, 0xE389A9 },
	{ 0xDCBB, 0xE389AA },
	{ 0xDCBC, 0xE389AB },
	{ 0xDCBD, 0xE389AC },
	{ 0xDCBE, 0xE389AD },
	{ 0xDCBF, 0xE389AE },
	{ 0xDCC0, 0xE389AF },
	{ 0xDCC1, 0xE389B0 },
	{ 0xDCC2, 0xE389B1 },
	{ 0xDCC3, 0xE389B2 },
	{ 0xDCC4, 0xE389B3 },
	{ 0xDCC5, 0xE389B4 },
	{ 0xDCC6, 0xE389B5 },
	{ 0xDCC7, 0xE389B6 },
	{ 0xDCC8, 0xE389B7 },
	{ 0xDCC9, 0xE389B8 },
	{ 0xDCCA, 0xE389B9 },
	{ 0xDCCB, 0xE389BA },
	{ 0xDCCC, 0xE389BB },
	{ 0xD9DE, 0xE389BF },
	{ 0xDC59, 0xE38E80 },
	{ 0xDC5A, 0xE38E81 },
	{ 0xDC5B, 0xE38E82 },
	{ 0xDC5C, 0xE38E83 },
	{ 0xDC5D, 0xE38E84 },
	{ 0xDC4A, 0xE38E88 },
	{ 0xDC4B, 0xE38E89 },
	{ 0xDC6C, 0xE38E8A },
	{ 0xDC6D, 0xE38E8B },
	{ 0xDC6E, 0xE38E8C },
	{ 0xDC46, 0xE38E8D },
	{ 0xDC47, 0xE38E8E },
	{ 0xDC48, 0xE38E8F },
	{ 0xDC64, 0xE38E90 },
	{ 0xDC65, 0xE38E91 },
	{ 0xDC66, 0xE38E92 },
	{ 0xDC67, 0xE38E93 },
	{ 0xDC68, 0xE38E94 },
	{ 0xDC31, 0xE38E95 },
	{ 0xDC32, 0xE38E96 },
	{ 0xDC33, 0xE38E97 },
	{ 0xDC35, 0xE38E98 },
	{ 0xDC3B, 0xE38E99 },
	{ 0xDC3C, 0xE38E9A },
	{ 0xDC3D, 0xE38E9B },
	{ 0xDC3E, 0xE38E9C },
	{ 0xDC3F, 0xE38E9D },
	{ 0xDC40, 0xE38E9E },
	{ 0xDC41, 0xE38E9F },
	{ 0xDC42, 0xE38EA0 },
	{ 0xDC43, 0xE38EA1 },
	{ 0xDC44, 0xE38EA2 },
	{ 0xDC37, 0xE38EA3 },
	{ 0xDC38, 0xE38EA4 },
	{ 0xDC39, 0xE38EA5 },
	{ 0xDC3A, 0xE38EA6 },
	{ 0xDC4D, 0xE38EA7 },
	{ 0xDC4E, 0xE38EA8 },
	{ 0xDC75, 0xE38EA9 },
	{ 0xDC76, 0xE38EAA },
	{ 0xDC77, 0xE38EAB },
	{ 0xDC78, 0xE38EAC },
	{ 0xDC71, 0xE38EAD },
	{ 0xDC72, 0xE38EAE },
	{ 0xDC73, 0xE38EAF },
	{ 0xDC4F, 0xE38EB0 },
	{ 0xDC50, 0xE38EB1 },
	{ 0xDC51, 0xE38EB2 },
	{ 0xDC52, 0xE38EB3 },
	{ 0xDC53, 0xE38EB4 },
	{ 0xDC54, 0xE38EB5 },
	{ 0xDC55, 0xE38EB6 },
	{ 0xDC56, 0xE38EB7 },
	{ 0xDC57, 0xE38EB8 },
	{ 0xDC58, 0xE38EB9 },
	{ 0xDC5E, 0xE38EBA },
	{ 0xDC5F, 0xE38EBB },
	{ 0xDC60, 0xE38EBC },
	{ 0xDC61, 0xE38EBD },
	{ 0xDC62, 0xE38EBE },
	{ 0xDC63, 0xE38EBF },
	{ 0xDC6A, 0xE38F80 },
	{ 0xDC6B, 0xE38F81 },
	{ 0xD9E3, 0xE38F82 },
	{ 0xDC7C, 0xE38F83 },
	{ 0xDC36, 0xE38F84 },
	{ 0xDC70, 0xE38F85 },
	{ 0xDC91, 0xE38F86 },
	{ 0xD9E1, 0xE38F87 },
	{ 0xDC4C, 0xE38F88 },
	{ 0xDC7D, 0xE38F89 },
	{ 0xDC45, 0xE38F8A },
	{ 0xDC49, 0xE38F8F },
	{ 0xDC7A, 0xE38F90 },
	{ 0xDC7B, 0xE38F93 },
	{ 0xDC6F, 0xE38F96 },
	{ 0xD9E4, 0xE38F98 },
	{ 0xDC74, 0xE38F9B },
	{ 0xDC7E, 0xE38F9C },
	{ 0xDC79, 0xE38F9D },
	{ 0x8861, 0xE39080 },
	{ 0x8862, 0xE39081 },
	{ 0x8865, 0xE39082 },
	{ 0x8868, 0xE39083 },
	{ 0x8869, 0xE39084 },
	{ 0x886A, 0xE39085 },
	{ 0x886B, 0xE39086 },
	{ 0x8871, 0xE39087 },
	{ 0x8873, 0xE39088 },
	{ 0x8874, 0xE39089 },
	{ 0x8875, 0xE3908A },
	{ 0x8876, 0xE3908B },
	{ 0x8877, 0xE3908C },
	{ 0x8878, 0xE3908D },
	{ 0x8879, 0xE3908E },
	{ 0x887B, 0xE3908F },
	{ 0x887C, 0xE39090 },
	{ 0x887D, 0xE39091 },
	{ 0x8881, 0xE39092 },
	{ 0x8882, 0xE39093 },
	{ 0x8885, 0xE39094 },
	{ 0x8889, 0xE39095 },
	{ 0x8891, 0xE39096 },
	{ 0x8893, 0xE39097 },
	{ 0x8895, 0xE39098 },
	{ 0x8896, 0xE39099 },
	{ 0x8897, 0xE3909A },
	{ 0x88A1, 0xE3909B },
	{ 0x88A2, 0xE3909C },
	{ 0x88A5, 0xE3909D },
	{ 0x88A9, 0xE3909E },
	{ 0x88B5, 0xE3909F },
	{ 0x88B7, 0xE390A0 },
	{ 0x88C1, 0xE390A1 },
	{ 0x88C5, 0xE390A2 },
	{ 0x88C9, 0xE390A3 },
	{ 0x88E1, 0xE390A4 },
	{ 0x88E2, 0xE390A5 },
	{ 0x88E5, 0xE390A6 },
	{ 0x88E8, 0xE390A7 },
	{ 0x88E9, 0xE390A8 },
	{ 0x88EB, 0xE390A9 },
	{ 0x88F1, 0xE390AA },
	{ 0x88F3, 0xE390AB },
	{ 0x88F5, 0xE390AC },
	{ 0x88F6, 0xE390AD },
	{ 0x88F7, 0xE390AE },
	{ 0x88F8, 0xE390AF },
	{ 0x88FB, 0xE390B0 },
	{ 0x88FC, 0xE390B1 },
	{ 0x88FD, 0xE390B2 },
	{ 0x8941, 0xE390B3 },
	{ 0x8945, 0xE390B4 },
	{ 0x8949, 0xE390B5 },
	{ 0x8951, 0xE390B6 },
	{ 0x8953, 0xE390B7 },
	{ 0x8955, 0xE390B8 },
	{ 0x8956, 0xE390B9 },
	{ 0x8957, 0xE390BA },
	{ 0x8961, 0xE390BB },
	{ 0x8962, 0xE390BC },
	{ 0x8963, 0xE390BD },
	{ 0x8965, 0xE390BE },
	{ 0x8968, 0xE390BF },
	{ 0x8969, 0xE39180 },
	{ 0x8971, 0xE39181 },
	{ 0x8973, 0xE39182 },
	{ 0x8975, 0xE39183 },
	{ 0x8976, 0xE39184 },
	{ 0x8977, 0xE39185 },
	{ 0x897B, 0xE39186 },
	{ 0x8981, 0xE39187 },
	{ 0x8985, 0xE39188 },
	{ 0x8989, 0xE39189 },
	{ 0x8993, 0xE3918A },
	{ 0x8995, 0xE3918B },
	{ 0x89A1, 0xE3918C },
	{ 0x89A2, 0xE3918D },
	{ 0x89A5, 0xE3918E },
	{ 0x89A8, 0xE3918F },
	{ 0x89A9, 0xE39190 },
	{ 0x89AB, 0xE39191 },
	{ 0x89AD, 0xE39192 },
	{ 0x89B0, 0xE39193 },
	{ 0x89B1, 0xE39194 },
	{ 0x89B3, 0xE39195 },
	{ 0x89B5, 0xE39196 },
	{ 0x89B7, 0xE39197 },
	{ 0x89B8, 0xE39198 },
	{ 0x89C1, 0xE39199 },
	{ 0x89C2, 0xE3919A },
	{ 0x89C5, 0xE3919B },
	{ 0x89C9, 0xE3919C },
	{ 0x89CB, 0xE3919D },
	{ 0x89D1, 0xE3919E },
	{ 0x89D3, 0xE3919F },
	{ 0x89D5, 0xE391A0 },
	{ 0x89D7, 0xE391A1 },
	{ 0x89E1, 0xE391A2 },
	{ 0x89E5, 0xE391A3 },
	{ 0x89E9, 0xE391A4 },
	{ 0x89F3, 0xE391A5 },
	{ 0x89F6, 0xE391A6 },
	{ 0x89F7, 0xE391A7 },
	{ 0x8A41, 0xE391A8 },
	{ 0x8A42, 0xE391A9 },
	{ 0x8A45, 0xE391AA },
	{ 0x8A49, 0xE391AB },
	{ 0x8A51, 0xE391AC },
	{ 0x8A53, 0xE391AD },
	{ 0x8A55, 0xE391AE },
	{ 0x8A57, 0xE391AF },
	{ 0x8A61, 0xE391B0 },
	{ 0x8A65, 0xE391B1 },
	{ 0x8A69, 0xE391B2 },
	{ 0x8A73, 0xE391B3 },
	{ 0x8A75, 0xE391B4 },
	{ 0x8A81, 0xE391B5 },
	{ 0x8A82, 0xE391B6 },
	{ 0x8A85, 0xE391B7 },
	{ 0x8A88, 0xE391B8 },
	{ 0x8A89, 0xE391B9 },
	{ 0x8A8A, 0xE391BA },
	{ 0x8A8B, 0xE391BB },
	{ 0x8A90, 0xE391BC },
	{ 0x8A91, 0xE391BD },
	{ 0x8A93, 0xE391BE },
	{ 0x8A95, 0xE391BF },
	{ 0x8A97, 0xE39280 },
	{ 0x8A98, 0xE39281 },
	{ 0x8AA1, 0xE39282 },
	{ 0x8AA2, 0xE39283 },
	{ 0x8AA5, 0xE39284 },
	{ 0x8AA9, 0xE39285 },
	{ 0x8AB6, 0xE39286 },
	{ 0x8AB7, 0xE39287 },
	{ 0x8AC1, 0xE39288 },
	{ 0x8AD5, 0xE39289 },
	{ 0x8AE1, 0xE3928A },
	{ 0x8AE2, 0xE3928B },
	{ 0x8AE5, 0xE3928C },
	{ 0x8AE9, 0xE3928D },
	{ 0x8AF1, 0xE3928E },
	{ 0x8AF3, 0xE3928F },
	{ 0x8AF5, 0xE39290 },
	{ 0x8B41, 0xE39291 },
	{ 0x8B45, 0xE39292 },
	{ 0x8B49, 0xE39293 },
	{ 0x8B61, 0xE39294 },
	{ 0x8B62, 0xE39295 },
	{ 0x8B65, 0xE39296 },
	{ 0x8B68, 0xE39297 },
	{ 0x8B69, 0xE39298 },
	{ 0x8B6A, 0xE39299 },
	{ 0x8B71, 0xE3929A },
	{ 0x8B73, 0xE3929B },
	{ 0x8B75, 0xE3929C },
	{ 0x8B77, 0xE3929D },
	{ 0x8B81, 0xE3929E },
	{ 0x8BA1, 0xE3929F },
	{ 0x8BA2, 0xE392A0 },
	{ 0x8BA5, 0xE392A1 },
	{ 0x8BA8, 0xE392A2 },
	{ 0x8BA9, 0xE392A3 },
	{ 0x8BAB, 0xE392A4 },
	{ 0x8BB1, 0xE392A5 },
	{ 0x8BB3, 0xE392A6 },
	{ 0x8BB5, 0xE392A7 },
	{ 0x8BB7, 0xE392A8 },
	{ 0x8BB8, 0xE392A9 },
	{ 0x8BBC, 0xE392AA },
	{ 0x8C61, 0xE392AB },
	{ 0x8C62, 0xE392AC },
	{ 0x8C63, 0xE392AD },
	{ 0x8C65, 0xE392AE },
	{ 0x8C69, 0xE392AF },
	{ 0x8C6B, 0xE392B0 },
	{ 0x8C71, 0xE392B1 },
	{ 0x8C73, 0xE392B2 },
	{ 0x8C75, 0xE392B3 },
	{ 0x8C76, 0xE392B4 },
	{ 0x8C77, 0xE392B5 },
	{ 0x8C7B, 0xE392B6 },
	{ 0x8C81, 0xE392B7 },
	{ 0x8C82, 0xE392B8 },
	{ 0x8C85, 0xE392B9 },
	{ 0x8C89, 0xE392BA },
	{ 0x8C91, 0xE392BB },
	{ 0x8C93, 0xE392BC },
	{ 0x8C95, 0xE392BD },
	{ 0x8C96, 0xE392BE },
	{ 0x8C97, 0xE392BF },
	{ 0x8CA1, 0xE39380 },
	{ 0x8CA2, 0xE39381 },
	{ 0x8CA9, 0xE39382 },
	{ 0x8CE1, 0xE39383 },
	{ 0x8CE2, 0xE39384 },
	{ 0x8CE3, 0xE39385 },
	{ 0x8CE5, 0xE39386 },
	{ 0x8CE9, 0xE39387 },
	{ 0x8CF1, 0xE39388 },
	{ 0x8CF3, 0xE39389 },
	{ 0x8CF5, 0xE3938A },
	{ 0x8CF6, 0xE3938B },
	{ 0x8CF7, 0xE3938C },
	{ 0x8D41, 0xE3938D },
	{ 0x8D42, 0xE3938E },
	{ 0x8D45, 0xE3938F },
	{ 0x8D51, 0xE39390 },
	{ 0x8D55, 0xE39391 },
	{ 0x8D57, 0xE39392 },
	{ 0x8D61, 0xE39393 },
	{ 0x8D65, 0xE39394 },
	{ 0x8D69, 0xE39395 },
	{ 0x8D75, 0xE39396 },
	{ 0x8D76, 0xE39397 },
	{ 0x8D7B, 0xE39398 },
	{ 0x8D81, 0xE39399 },
	{ 0x8DA1, 0xE3939A },
	{ 0x8DA2, 0xE3939B },
	{ 0x8DA5, 0xE3939C },
	{ 0x8DA7, 0xE3939D },
	{ 0x8DA9, 0xE3939E },
	{ 0x8DB1, 0xE3939F },
	{ 0x8DB3, 0xE393A0 },
	{ 0x8DB5, 0xE393A1 },
	{ 0x8DB7, 0xE393A2 },
	{ 0x8DB8, 0xE393A3 },
	{ 0x8DB9, 0xE393A4 },
	{ 0x8DC1, 0xE393A5 },
	{ 0x8DC2, 0xE393A6 },
	{ 0x8DC9, 0xE393A7 },
	{ 0x8DD6, 0xE393A8 },
	{ 0x8DD7, 0xE393A9 },
	{ 0x8DE1, 0xE393AA },
	{ 0x8DE2, 0xE393AB },
	{ 0x8DF7, 0xE393AC },
	{ 0x8E41, 0xE393AD },
	{ 0x8E45, 0xE393AE },
	{ 0x8E49, 0xE393AF },
	{ 0x8E51, 0xE393B0 },
	{ 0x8E53, 0xE393B1 },
	{ 0x8E57, 0xE393B2 },
	{ 0x8E61, 0xE393B3 },
	{ 0x8E81, 0xE393B4 },
	{ 0x8E82, 0xE393B5 },
	{ 0x8E85, 0xE393B6 },
	{ 0x8E89, 0xE393B7 },
	{ 0x8E90, 0xE393B8 },
	{ 0x8E91, 0xE393B9 },
	{ 0x8E93, 0xE393BA },
	{ 0x8E95, 0xE393BB },
	{ 0x8E97, 0xE393BC },
	{ 0x8E98, 0xE393BD },
	{ 0x8EA1, 0xE393BE },
	{ 0x8EA9, 0xE393BF },
	{ 0x8EB6, 0xE39480 },
	{ 0x8EB7, 0xE39481 },
	{ 0x8EC1, 0xE39482 },
	{ 0x8EC2, 0xE39483 },
	{ 0x8EC5, 0xE39484 },
	{ 0x8EC9, 0xE39485 },
	{ 0x8ED1, 0xE39486 },
	{ 0x8ED3, 0xE39487 },
	{ 0x8ED6, 0xE39488 },
	{ 0x8EE1, 0xE39489 },
	{ 0x8EE5, 0xE3948A },
	{ 0x8EE9, 0xE3948B },
	{ 0x8EF1, 0xE3948C },
	{ 0x8EF3, 0xE3948D },
	{ 0x8F41, 0xE3948E },
	{ 0x8F61, 0xE3948F },
	{ 0x8F62, 0xE39490 },
	{ 0x8F65, 0xE39491 },
	{ 0x8F67, 0xE39492 },
	{ 0x8F69, 0xE39493 },
	{ 0x8F6B, 0xE39494 },
	{ 0x8F70, 0xE39495 },
	{ 0x8F71, 0xE39496 },
	{ 0x8F73, 0xE39497 },
	{ 0x8F75, 0xE39498 },
	{ 0x8F77, 0xE39499 },
	{ 0x8F7B, 0xE3949A },
	{ 0x8FA1, 0xE3949B },
	{ 0x8FA2, 0xE3949C },
	{ 0x8FA5, 0xE3949D },
	{ 0x8FA9, 0xE3949E },
	{ 0x8FB1, 0xE3949F },
	{ 0x8FB3, 0xE394A0 },
	{ 0x8FB5, 0xE394A1 },
	{ 0x8FB7, 0xE394A2 },
	{ 0x9061, 0xE394A3 },
	{ 0x9062, 0xE394A4 },
	{ 0x9063, 0xE394A5 },
	{ 0x9065, 0xE394A6 },
	{ 0x9068, 0xE394A7 },
	{ 0x9069, 0xE394A8 },
	{ 0x906A, 0xE394A9 },
	{ 0x906B, 0xE394AA },
	{ 0x9071, 0xE394AB },
	{ 0x9073, 0xE394AC },
	{ 0x9075, 0xE394AD },
	{ 0x9076, 0xE394AE },
	{ 0x9077, 0xE394AF },
	{ 0x9078, 0xE394B0 },
	{ 0x9079, 0xE394B1 },
	{ 0x907B, 0xE394B2 },
	{ 0x907D, 0xE394B3 },
	{ 0x9081, 0xE394B4 },
	{ 0x9082, 0xE394B5 },
	{ 0x9085, 0xE394B6 },
	{ 0x9089, 0xE394B7 },
	{ 0x9091, 0xE394B8 },
	{ 0x9093, 0xE394B9 },
	{ 0x9095, 0xE394BA },
	{ 0x9096, 0xE394BB },
	{ 0x9097, 0xE394BC },
	{ 0x90A1, 0xE394BD },
	{ 0x90A2, 0xE394BE },
	{ 0x90A5, 0xE394BF },
	{ 0x90A9, 0xE39580 },
	{ 0x90B1, 0xE39581 },
	{ 0x90B7, 0xE39582 },
	{ 0x90E1, 0xE39583 },
	{ 0x90E2, 0xE39584 },
	{ 0x90E4, 0xE39585 },
	{ 0x90E5, 0xE39586 },
	{ 0x90E9, 0xE39587 },
	{ 0x90EB, 0xE39588 },
	{ 0x90EC, 0xE39589 },
	{ 0x90F1, 0xE3958A },
	{ 0x90F3, 0xE3958B },
	{ 0x90F5, 0xE3958C },
	{ 0x90F6, 0xE3958D },
	{ 0x90F7, 0xE3958E },
	{ 0x90FD, 0xE3958F },
	{ 0x9141, 0xE39590 },
	{ 0x9142, 0xE39591 },
	{ 0x9145, 0xE39592 },
	{ 0x9149, 0xE39593 },
	{ 0x9151, 0xE39594 },
	{ 0x9153, 0xE39595 },
	{ 0x9155, 0xE39596 },
	{ 0x9156, 0xE39597 },
	{ 0x9157, 0xE39598 },
	{ 0x9161, 0xE39599 },
	{ 0x9162, 0xE3959A },
	{ 0x9165, 0xE3959B },
	{ 0x9169, 0xE3959C },
	{ 0x9171, 0xE3959D },
	{ 0x9173, 0xE3959E },
	{ 0x9176, 0xE3959F },
	{ 0x9177, 0xE395A0 },
	{ 0x917A, 0xE395A1 },
	{ 0x9181, 0xE395A2 },
	{ 0x9185, 0xE395A3 },
	{ 0x91A1, 0xE395A4 },
	{ 0x91A2, 0xE395A5 },
	{ 0x91A5, 0xE395A6 },
	{ 0x91A9, 0xE395A7 },
	{ 0x91AB, 0xE395A8 },
	{ 0x91B1, 0xE395A9 },
	{ 0x91B3, 0xE395AA },
	{ 0x91B5, 0xE395AB },
	{ 0x91B7, 0xE395AC },
	{ 0x91BC, 0xE395AD },
	{ 0x91BD, 0xE395AE },
	{ 0x91C1, 0xE395AF },
	{ 0x91C5, 0xE395B0 },
	{ 0x91C9, 0xE395B1 },
	{ 0x91D6, 0xE395B2 },
	{ 0x9241, 0xE395B3 },
	{ 0x9245, 0xE395B4 },
	{ 0x9249, 0xE395B5 },
	{ 0x9251, 0xE395B6 },
	{ 0x9253, 0xE395B7 },
	{ 0x9255, 0xE395B8 },
	{ 0x9261, 0xE395B9 },
	{ 0x9262, 0xE395BA },
	{ 0x9265, 0xE395BB },
	{ 0x9269, 0xE395BC },
	{ 0x9273, 0xE395BD },
	{ 0x9275, 0xE395BE },
	{ 0x9277, 0xE395BF },
	{ 0x9281, 0xE39680 },
	{ 0x9282, 0xE39681 },
	{ 0x9285, 0xE39682 },
	{ 0x9288, 0xE39683 },
	{ 0x9289, 0xE39684 },
	{ 0x9291, 0xE39685 },
	{ 0x9293, 0xE39686 },
	{ 0x9295, 0xE39687 },
	{ 0x9297, 0xE39688 },
	{ 0x92A1, 0xE39689 },
	{ 0x92B6, 0xE3968A },
	{ 0x92C1, 0xE3968B },
	{ 0x92E1, 0xE3968C },
	{ 0x92E5, 0xE3968D },
	{ 0x92E9, 0xE3968E },
	{ 0x92F1, 0xE3968F },
	{ 0x92F3, 0xE39690 },
	{ 0x9341, 0xE39691 },
	{ 0x9342, 0xE39692 },
	{ 0x9349, 0xE39693 },
	{ 0x9351, 0xE39694 },
	{ 0x9353, 0xE39695 },
	{ 0x9357, 0xE39696 },
	{ 0x9361, 0xE39697 },
	{ 0x9362, 0xE39698 },
	{ 0x9365, 0xE39699 },
	{ 0x9369, 0xE3969A },
	{ 0x936A, 0xE3969B },
	{ 0x936B, 0xE3969C },
	{ 0x9371, 0xE3969D },
	{ 0x9373, 0xE3969E },
	{ 0x9375, 0xE3969F },
	{ 0x9377, 0xE396A0 },
	{ 0x9378, 0xE396A1 },
	{ 0x937C, 0xE396A2 },
	{ 0x9381, 0xE396A3 },
	{ 0x9385, 0xE396A4 },
	{ 0x9389, 0xE396A5 },
	{ 0x93A1, 0xE396A6 },
	{ 0x93A2, 0xE396A7 },
	{ 0x93A5, 0xE396A8 },
	{ 0x93A9, 0xE396A9 },
	{ 0x93AB, 0xE396AA },
	{ 0x93B1, 0xE396AB },
	{ 0x93B3, 0xE396AC },
	{ 0x93B5, 0xE396AD },
	{ 0x93B7, 0xE396AE },
	{ 0x93BC, 0xE396AF },
	{ 0x9461, 0xE396B0 },
	{ 0x9462, 0xE396B1 },
	{ 0x9463, 0xE396B2 },
	{ 0x9465, 0xE396B3 },
	{ 0x9468, 0xE396B4 },
	{ 0x9469, 0xE396B5 },
	{ 0x946A, 0xE396B6 },
	{ 0x946B, 0xE396B7 },
	{ 0x946C, 0xE396B8 },
	{ 0x9470, 0xE396B9 },
	{ 0x9471, 0xE396BA },
	{ 0x9473, 0xE396BB },
	{ 0x9475, 0xE396BC },
	{ 0x9476, 0xE396BD },
	{ 0x9477, 0xE396BE },
	{ 0x9478, 0xE396BF },
	{ 0x9479, 0xE39780 },
	{ 0x947D, 0xE39781 },
	{ 0x9481, 0xE39782 },
	{ 0x9482, 0xE39783 },
	{ 0x9485, 0xE39784 },
	{ 0x9489, 0xE39785 },
	{ 0x9491, 0xE39786 },
	{ 0x9493, 0xE39787 },
	{ 0x9495, 0xE39788 },
	{ 0x9496, 0xE39789 },
	{ 0x9497, 0xE3978A },
	{ 0x94A1, 0xE3978B },
	{ 0x94E1, 0xE3978C },
	{ 0x94E2, 0xE3978D },
	{ 0x94E3, 0xE3978E },
	{ 0x94E5, 0xE3978F },
	{ 0x94E8, 0xE39790 },
	{ 0x94E9, 0xE39791 },
	{ 0x94EB, 0xE39792 },
	{ 0x94EC, 0xE39793 },
	{ 0x94F1, 0xE39794 },
	{ 0x94F3, 0xE39795 },
	{ 0x94F5, 0xE39796 },
	{ 0x94F7, 0xE39797 },
	{ 0x94F9, 0xE39798 },
	{ 0x94FC, 0xE39799 },
	{ 0x9541, 0xE3979A },
	{ 0x9542, 0xE3979B },
	{ 0x9545, 0xE3979C },
	{ 0x9549, 0xE3979D },
	{ 0x9551, 0xE3979E },
	{ 0x9553, 0xE3979F },
	{ 0x9555, 0xE397A0 },
	{ 0x9556, 0xE397A1 },
	{ 0x9557, 0xE397A2 },
	{ 0x9561, 0xE397A3 },
	{ 0x9565, 0xE397A4 },
	{ 0x9569, 0xE397A5 },
	{ 0x9576, 0xE397A6 },
	{ 0x9577, 0xE397A7 },
	{ 0x9581, 0xE397A8 },
	{ 0x9585, 0xE397A9 },
	{ 0x95A1, 0xE397AA },
	{ 0x95A2, 0xE397AB },
	{ 0x95A5, 0xE397AC },
	{ 0x95A8, 0xE397AD },
	{ 0x95A9, 0xE397AE },
	{ 0x95AB, 0xE397AF },
	{ 0x95AD, 0xE397B0 },
	{ 0x95B1, 0xE397B1 },
	{ 0x95B3, 0xE397B2 },
	{ 0x95B5, 0xE397B3 },
	{ 0x95B7, 0xE397B4 },
	{ 0x95B9, 0xE397B5 },
	{ 0x95BB, 0xE397B6 },
	{ 0x95C1, 0xE397B7 },
	{ 0x95C5, 0xE397B8 },
	{ 0x95C9, 0xE397B9 },
	{ 0x95E1, 0xE397BA },
	{ 0x95F6, 0xE397BB },
	{ 0x9641, 0xE397BC },
	{ 0x9645, 0xE397BD },
	{ 0x9649, 0xE397BE },
	{ 0x9651, 0xE397BF },
	{ 0x9653, 0xE39880 },
	{ 0x9655, 0xE39881 },
	{ 0x9661, 0xE39882 },
	{ 0x9681, 0xE39883 },
	{ 0x9682, 0xE39884 },
	{ 0x9685, 0xE39885 },
	{ 0x9689, 0xE39886 },
	{ 0x9691, 0xE39887 },
	{ 0x9693, 0xE39888 },
	{ 0x9695, 0xE39889 },
	{ 0x9697, 0xE3988A },
	{ 0x96A1, 0xE3988B },
	{ 0x96B6, 0xE3988C },
	{ 0x96C1, 0xE3988D },
	{ 0x96D7, 0xE3988E },
	{ 0x96E1, 0xE3988F },
	{ 0x96E5, 0xE39890 },
	{ 0x96E9, 0xE39891 },
	{ 0x96F3, 0xE39892 },
	{ 0x96F5, 0xE39893 },
	{ 0x96F7, 0xE39894 },
	{ 0x9741, 0xE39895 },
	{ 0x9745, 0xE39896 },
	{ 0x9749, 0xE39897 },
	{ 0x9751, 0xE39898 },
	{ 0x9757, 0xE39899 },
	{ 0x9761, 0xE3989A },
	{ 0x9762, 0xE3989B },
	{ 0x9765, 0xE3989C },
	{ 0x9768, 0xE3989D },
	{ 0x9769, 0xE3989E },
	{ 0x976B, 0xE3989F },
	{ 0x9771, 0xE398A0 },
	{ 0x9773, 0xE398A1 },
	{ 0x9775, 0xE398A2 },
	{ 0x9777, 0xE398A3 },
	{ 0x9781, 0xE398A4 },
	{ 0x97A1, 0xE398A5 },
	{ 0x97A2, 0xE398A6 },
	{ 0x97A5, 0xE398A7 },
	{ 0x97A8, 0xE398A8 },
	{ 0x97A9, 0xE398A9 },
	{ 0x97B1, 0xE398AA },
	{ 0x97B3, 0xE398AB },
	{ 0x97B5, 0xE398AC },
	{ 0x97B6, 0xE398AD },
	{ 0x97B7, 0xE398AE },
	{ 0x97B8, 0xE398AF },
	{ 0x9861, 0xE398B0 },
	{ 0x9862, 0xE398B1 },
	{ 0x9865, 0xE398B2 },
	{ 0x9869, 0xE398B3 },
	{ 0x9871, 0xE398B4 },
	{ 0x9873, 0xE398B5 },
	{ 0x9875, 0xE398B6 },
	{ 0x9876, 0xE398B7 },
	{ 0x9877, 0xE398B8 },
	{ 0x987D, 0xE398B9 },
	{ 0x9881, 0xE398BA },
	{ 0x9882, 0xE398BB },
	{ 0x9885, 0xE398BC },
	{ 0x9889, 0xE398BD },
	{ 0x9891, 0xE398BE },
	{ 0x9893, 0xE398BF },
	{ 0x9895, 0xE39980 },
	{ 0x9896, 0xE39981 },
	{ 0x9897, 0xE39982 },
	{ 0x98E1, 0xE39983 },
	{ 0x98E2, 0xE39984 },
	{ 0x98E5, 0xE39985 },
	{ 0x98E9, 0xE39986 },
	{ 0x98EB, 0xE39987 },
	{ 0x98EC, 0xE39988 },
	{ 0x98F1, 0xE39989 },
	{ 0x98F3, 0xE3998A },
	{ 0x98F5, 0xE3998B },
	{ 0x98F6, 0xE3998C },
	{ 0x98F7, 0xE3998D },
	{ 0x98FD, 0xE3998E },
	{ 0x9941, 0xE3998F },
	{ 0x9942, 0xE39990 },
	{ 0x9945, 0xE39991 },
	{ 0x9949, 0xE39992 },
	{ 0x9951, 0xE39993 },
	{ 0x9953, 0xE39994 },
	{ 0x9955, 0xE39995 },
	{ 0x9956, 0xE39996 },
	{ 0x9957, 0xE39997 },
	{ 0x9961, 0xE39998 },
	{ 0x9976, 0xE39999 },
	{ 0x99A1, 0xE3999A },
	{ 0x99A2, 0xE3999B },
	{ 0x99A5, 0xE3999C },
	{ 0x99A9, 0xE3999D },
	{ 0x99B7, 0xE3999E },
	{ 0x99C1, 0xE3999F },
	{ 0x99C9, 0xE399A0 },
	{ 0x99E1, 0xE399A1 },
	{ 0x9A41, 0xE399A2 },
	{ 0x9A45, 0xE399A3 },
	{ 0x9A81, 0xE399A4 },
	{ 0x9A82, 0xE399A5 },
	{ 0x9A85, 0xE399A6 },
	{ 0x9A89, 0xE399A7 },
	{ 0x9A90, 0xE399A8 },
	{ 0x9A91, 0xE399A9 },
	{ 0x9A97, 0xE399AA },
	{ 0x9AC1, 0xE399AB },
	{ 0x9AE1, 0xE399AC },
	{ 0x9AE5, 0xE399AD },
	{ 0x9AE9, 0xE399AE },
	{ 0x9AF1, 0xE399AF },
	{ 0x9AF3, 0xE399B0 },
	{ 0x9AF7, 0xE399B1 },
	{ 0x9B61, 0xE399B2 },
	{ 0x9B62, 0xE399B3 },
	{ 0x9B65, 0xE399B4 },
	{ 0x9B68, 0xE399B5 },
	{ 0x9B69, 0xE399B6 },
	{ 0x9B71, 0xE399B7 },
	{ 0x9B73, 0xE399B8 },
	{ 0x9B75, 0xE399B9 },
	{ 0x9B81, 0xE399BA },
	{ 0x9B85, 0xE399BB },
	{ 0x9B89, 0xE399BC },
	{ 0x9B91, 0xE399BD },
	{ 0x9B93, 0xE399BE },
	{ 0x9BA1, 0xE399BF },
	{ 0x9BA5, 0xE39A80 },
	{ 0x9BA9, 0xE39A81 },
	{ 0x9BB1, 0xE39A82 },
	{ 0x9BB3, 0xE39A83 },
	{ 0x9BB5, 0xE39A84 },
	{ 0x9BB7, 0xE39A85 },
	{ 0x9C61, 0xE39A86 },
	{ 0x9C62, 0xE39A87 },
	{ 0x9C65, 0xE39A88 },
	{ 0x9C69, 0xE39A89 },
	{ 0x9C71, 0xE39A8A },
	{ 0x9C73, 0xE39A8B },
	{ 0x9C75, 0xE39A8C },
	{ 0x9C76, 0xE39A8D },
	{ 0x9C77, 0xE39A8E },
	{ 0x9C78, 0xE39A8F },
	{ 0x9C7C, 0xE39A90 },
	{ 0x9C7D, 0xE39A91 },
	{ 0x9C81, 0xE39A92 },
	{ 0x9C82, 0xE39A93 },
	{ 0x9C85, 0xE39A94 },
	{ 0x9C89, 0xE39A95 },
	{ 0x9C91, 0xE39A96 },
	{ 0x9C93, 0xE39A97 },
	{ 0x9C95, 0xE39A98 },
	{ 0x9C96, 0xE39A99 },
	{ 0x9C97, 0xE39A9A },
	{ 0x9CA1, 0xE39A9B },
	{ 0x9CA2, 0xE39A9C },
	{ 0x9CA5, 0xE39A9D },
	{ 0x9CB5, 0xE39A9E },
	{ 0x9CB7, 0xE39A9F },
	{ 0x9CE1, 0xE39AA0 },
	{ 0x9CE2, 0xE39AA1 },
	{ 0x9CE5, 0xE39AA2 },
	{ 0x9CE9, 0xE39AA3 },
	{ 0x9CF1, 0xE39AA4 },
	{ 0x9CF3, 0xE39AA5 },
	{ 0x9CF5, 0xE39AA6 },
	{ 0x9CF6, 0xE39AA7 },
	{ 0x9CF7, 0xE39AA8 },
	{ 0x9CFD, 0xE39AA9 },
	{ 0x9D41, 0xE39AAA },
	{ 0x9D42, 0xE39AAB },
	{ 0x9D45, 0xE39AAC },
	{ 0x9D49, 0xE39AAD },
	{ 0x9D51, 0xE39AAE },
	{ 0x9D53, 0xE39AAF },
	{ 0x9D55, 0xE39AB0 },
	{ 0x9D57, 0xE39AB1 },
	{ 0x9D61, 0xE39AB2 },
	{ 0x9D62, 0xE39AB3 },
	{ 0x9D65, 0xE39AB4 },
	{ 0x9D69, 0xE39AB5 },
	{ 0x9D71, 0xE39AB6 },
	{ 0x9D73, 0xE39AB7 },
	{ 0x9D75, 0xE39AB8 },
	{ 0x9D76, 0xE39AB9 },
	{ 0x9D77, 0xE39ABA },
	{ 0x9D81, 0xE39ABB },
	{ 0x9D85, 0xE39ABC },
	{ 0x9D93, 0xE39ABD },
	{ 0x9D95, 0xE39ABE },
	{ 0x9DA1, 0xE39ABF },
	{ 0x9DA2, 0xE39B80 },
	{ 0x9DA5, 0xE39B81 },
	{ 0x9DA9, 0xE39B82 },
	{ 0x9DB1, 0xE39B83 },
	{ 0x9DB3, 0xE39B84 },
	{ 0x9DB5, 0xE39B85 },
	{ 0x9DB7, 0xE39B86 },
	{ 0x9DC1, 0xE39B87 },
	{ 0x9DC5, 0xE39B88 },
	{ 0x9DD7, 0xE39B89 },
	{ 0x9DF6, 0xE39B8A },
	{ 0x9E41, 0xE39B8B },
	{ 0x9E45, 0xE39B8C },
	{ 0x9E49, 0xE39B8D },
	{ 0x9E51, 0xE39B8E },
	{ 0x9E53, 0xE39B8F },
	{ 0x9E55, 0xE39B90 },
	{ 0x9E57, 0xE39B91 },
	{ 0x9E61, 0xE39B92 },
	{ 0x9E65, 0xE39B93 },
	{ 0x9E69, 0xE39B94 },
	{ 0x9E73, 0xE39B95 },
	{ 0x9E75, 0xE39B96 },
	{ 0x9E77, 0xE39B97 },
	{ 0x9E81, 0xE39B98 },
	{ 0x9E82, 0xE39B99 },
	{ 0x9E85, 0xE39B9A },
	{ 0x9E89, 0xE39B9B },
	{ 0x9E91, 0xE39B9C },
	{ 0x9E93, 0xE39B9D },
	{ 0x9E95, 0xE39B9E },
	{ 0x9E97, 0xE39B9F },
	{ 0x9EA1, 0xE39BA0 },
	{ 0x9EB6, 0xE39BA1 },
	{ 0x9EC1, 0xE39BA2 },
	{ 0x9EE1, 0xE39BA3 },
	{ 0x9EE2, 0xE39BA4 },
	{ 0x9EE5, 0xE39BA5 },
	{ 0x9EE9, 0xE39BA6 },
	{ 0x9EF1, 0xE39BA7 },
	{ 0x9EF5, 0xE39BA8 },
	{ 0x9EF7, 0xE39BA9 },
	{ 0x9F41, 0xE39BAA },
	{ 0x9F42, 0xE39BAB },
	{ 0x9F45, 0xE39BAC },
	{ 0x9F49, 0xE39BAD },
	{ 0x9F51, 0xE39BAE },
	{ 0x9F53, 0xE39BAF },
	{ 0x9F55, 0xE39BB0 },
	{ 0x9F57, 0xE39BB1 },
	{ 0x9F61, 0xE39BB2 },
	{ 0x9F62, 0xE39BB3 },
	{ 0x9F65, 0xE39BB4 },
	{ 0x9F69, 0xE39BB5 },
	{ 0x9F71, 0xE39BB6 },
	{ 0x9F73, 0xE39BB7 },
	{ 0x9F75, 0xE39BB8 },
	{ 0x9F77, 0xE39BB9 },
	{ 0x9F78, 0xE39BBA },
	{ 0x9F7B, 0xE39BBB },
	{ 0x9F7C, 0xE39BBC },
	{ 0x9FA1, 0xE39BBD },
	{ 0x9FA2, 0xE39BBE },
	{ 0x9FA5, 0xE39BBF },
	{ 0x9FA9, 0xE39C80 },
	{ 0x9FB1, 0xE39C81 },
	{ 0x9FB3, 0xE39C82 },
	{ 0x9FB5, 0xE39C83 },
	{ 0x9FB7, 0xE39C84 },
	{ 0xA061, 0xE39C85 },
	{ 0xA062, 0xE39C86 },
	{ 0xA065, 0xE39C87 },
	{ 0xA067, 0xE39C88 },
	{ 0xA068, 0xE39C89 },
	{ 0xA069, 0xE39C8A },
	{ 0xA06A, 0xE39C8B },
	{ 0xA06B, 0xE39C8C },
	{ 0xA071, 0xE39C8D },
	{ 0xA073, 0xE39C8E },
	{ 0xA075, 0xE39C8F },
	{ 0xA077, 0xE39C90 },
	{ 0xA078, 0xE39C91 },
	{ 0xA07B, 0xE39C92 },
	{ 0xA07D, 0xE39C93 },
	{ 0xA081, 0xE39C94 },
	{ 0xA082, 0xE39C95 },
	{ 0xA085, 0xE39C96 },
	{ 0xA089, 0xE39C97 },
	{ 0xA091, 0xE39C98 },
	{ 0xA093, 0xE39C99 },
	{ 0xA095, 0xE39C9A },
	{ 0xA096, 0xE39C9B },
	{ 0xA097, 0xE39C9C },
	{ 0xA098, 0xE39C9D },
	{ 0xA0A1, 0xE39C9E },
	{ 0xA0A2, 0xE39C9F },
	{ 0xA0A9, 0xE39CA0 },
	{ 0xA0B7, 0xE39CA1 },
	{ 0xA0E1, 0xE39CA2 },
	{ 0xA0E2, 0xE39CA3 },
	{ 0xA0E5, 0xE39CA4 },
	{ 0xA0E9, 0xE39CA5 },
	{ 0xA0EB, 0xE39CA6 },
	{ 0xA0F1, 0xE39CA7 },
	{ 0xA0F3, 0xE39CA8 },
	{ 0xA0F5, 0xE39CA9 },
	{ 0xA0F7, 0xE39CAA },
	{ 0xA0F8, 0xE39CAB },
	{ 0xA0FD, 0xE39CAC },
	{ 0xA141, 0xE39CAD },
	{ 0xA142, 0xE39CAE },
	{ 0xA145, 0xE39CAF },
	{ 0xA149, 0xE39CB0 },
	{ 0xA151, 0xE39CB1 },
	{ 0xA153, 0xE39CB2 },
	{ 0xA155, 0xE39CB3 },
	{ 0xA156, 0xE39CB4 },
	{ 0xA157, 0xE39CB5 },
	{ 0xA161, 0xE39CB6 },
	{ 0xA162, 0xE39CB7 },
	{ 0xA165, 0xE39CB8 },
	{ 0xA169, 0xE39CB9 },
	{ 0xA175, 0xE39CBA },
	{ 0xA176, 0xE39CBB },
	{ 0xA177, 0xE39CBC },
	{ 0xA179, 0xE39CBD },
	{ 0xA181, 0xE39CBE },
	{ 0xA1A1, 0xE39CBF },
	{ 0xA1A2, 0xE39D80 },
	{ 0xA1A4, 0xE39D81 },
	{ 0xA1A5, 0xE39D82 },
	{ 0xA1A9, 0xE39D83 },
	{ 0xA1AB, 0xE39D84 },
	{ 0xA1B1, 0xE39D85 },
	{ 0xA1B3, 0xE39D86 },
	{ 0xA1B5, 0xE39D87 },
	{ 0xA1B7, 0xE39D88 },
	{ 0xA1C1, 0xE39D89 },
	{ 0xA1C5, 0xE39D8A },
	{ 0xA1D6, 0xE39D8B },
	{ 0xA1D7, 0xE39D8C },
	{ 0xA241, 0xE39D8D },
	{ 0xA245, 0xE39D8E },
	{ 0xA249, 0xE39D8F },
	{ 0xA253, 0xE39D90 },
	{ 0xA255, 0xE39D91 },
	{ 0xA257, 0xE39D92 },
	{ 0xA261, 0xE39D93 },
	{ 0xA265, 0xE39D94 },
	{ 0xA269, 0xE39D95 },
	{ 0xA273, 0xE39D96 },
	{ 0xA275, 0xE39D97 },
	{ 0xA281, 0xE39D98 },
	{ 0xA282, 0xE39D99 },
	{ 0xA283, 0xE39D9A },
	{ 0xA285, 0xE39D9B },
	{ 0xA288, 0xE39D9C },
	{ 0xA289, 0xE39D9D },
	{ 0xA28A, 0xE39D9E },
	{ 0xA28B, 0xE39D9F },
	{ 0xA291, 0xE39DA0 },
	{ 0xA293, 0xE39DA1 },
	{ 0xA295, 0xE39DA2 },
	{ 0xA297, 0xE39DA3 },
	{ 0xA29B, 0xE39DA4 },
	{ 0xA29D, 0xE39DA5 },
	{ 0xA2A1, 0xE39DA6 },
	{ 0xA2A5, 0xE39DA7 },
	{ 0xA2A9, 0xE39DA8 },
	{ 0xA2B3, 0xE39DA9 },
	{ 0xA2B5, 0xE39DAA },
	{ 0xA2C1, 0xE39DAB },
	{ 0xA2E1, 0xE39DAC },
	{ 0xA2E5, 0xE39DAD },
	{ 0xA2E9, 0xE39DAE },
	{ 0xA341, 0xE39DAF },
	{ 0xA345, 0xE39DB0 },
	{ 0xA349, 0xE39DB1 },
	{ 0xA351, 0xE39DB2 },
	{ 0xA355, 0xE39DB3 },
	{ 0xA361, 0xE39DB4 },
	{ 0xA365, 0xE39DB5 },
	{ 0xA369, 0xE39DB6 },
	{ 0xA371, 0xE39DB7 },
	{ 0xA375, 0xE39DB8 },
	{ 0xA3A1, 0xE39DB9 },
	{ 0xA3A2, 0xE39DBA },
	{ 0xA3A5, 0xE39DBB },
	{ 0xA3A8, 0xE39DBC },
	{ 0xA3A9, 0xE39DBD },
	{ 0xA3AB, 0xE39DBE },
	{ 0xA3B1, 0xE39DBF },
	{ 0xA3B3, 0xE39E80 },
	{ 0xA3B5, 0xE39E81 },
	{ 0xA3B6, 0xE39E82 },
	{ 0xA3B7, 0xE39E83 },
	{ 0xA3B9, 0xE39E84 },
	{ 0xA3BB, 0xE39E85 },
	{ 0xA461, 0xE39E86 },
	{ 0xA462, 0xE39E87 },
	{ 0xA463, 0xE39E88 },
	{ 0xA464, 0xE39E89 },
	{ 0xA465, 0xE39E8A },
	{ 0xA468, 0xE39E8B },
	{ 0xA469, 0xE39E8C },
	{ 0xA46A, 0xE39E8D },
	{ 0xA46B, 0xE39E8E },
	{ 0xA46C, 0xE39E8F },
	{ 0xA471, 0xE39E90 },
	{ 0xA473, 0xE39E91 },
	{ 0xA475, 0xE39E92 },
	{ 0xA477, 0xE39E93 },
	{ 0xA47B, 0xE39E94 },
	{ 0xA481, 0xE39E95 },
	{ 0xA482, 0xE39E96 },
	{ 0xA485, 0xE39E97 },
	{ 0xA489, 0xE39E98 },
	{ 0xA491, 0xE39E99 },
	{ 0xA493, 0xE39E9A },
	{ 0xA495, 0xE39E9B },
	{ 0xA496, 0xE39E9C },
	{ 0xA497, 0xE39E9D },
	{ 0xA49B, 0xE39E9E },
	{ 0xA4A1, 0xE39E9F },
	{ 0xA4A2, 0xE39EA0 },
	{ 0xA4A5, 0xE39EA1 },
	{ 0xA4B3, 0xE39EA2 },
	{ 0xA4E1, 0xE39EA3 },
	{ 0xA4E2, 0xE39EA4 },
	{ 0xA4E5, 0xE39EA5 },
	{ 0xA4E8, 0xE39EA6 },
	{ 0xA4E9, 0xE39EA7 },
	{ 0xA4EB, 0xE39EA8 },
	{ 0xA4F1, 0xE39EA9 },
	{ 0xA4F3, 0xE39EAA },
	{ 0xA4F5, 0xE39EAB },
	{ 0xA4F7, 0xE39EAC },
	{ 0xA4F8, 0xE39EAD },
	{ 0xA541, 0xE39EAE },
	{ 0xA542, 0xE39EAF },
	{ 0xA545, 0xE39EB0 },
	{ 0xA548, 0xE39EB1 },
	{ 0xA549, 0xE39EB2 },
	{ 0xA551, 0xE39EB3 },
	{ 0xA553, 0xE39EB4 },
	{ 0xA555, 0xE39EB5 },
	{ 0xA556, 0xE39EB6 },
	{ 0xA557, 0xE39EB7 },
	{ 0xA561, 0xE39EB8 },
	{ 0xA562, 0xE39EB9 },
	{ 0xA565, 0xE39EBA },
	{ 0xA569, 0xE39EBB },
	{ 0xA573, 0xE39EBC },
	{ 0xA575, 0xE39EBD },
	{ 0xA576, 0xE39EBE },
	{ 0xA577, 0xE39EBF },
	{ 0xA57B, 0xE39F80 },
	{ 0xA581, 0xE39F81 },
	{ 0xA585, 0xE39F82 },
	{ 0xA5A1, 0xE39F83 },
	{ 0xA5A2, 0xE39F84 },
	{ 0xA5A3, 0xE39F85 },
	{ 0xA5A5, 0xE39F86 },
	{ 0xA5A9, 0xE39F87 },
	{ 0xA5B1, 0xE39F88 },
	{ 0xA5B3, 0xE39F89 },
	{ 0xA5B5, 0xE39F8A },
	{ 0xA5B7, 0xE39F8B },
	{ 0xA5C1, 0xE39F8C },
	{ 0xA5C5, 0xE39F8D },
	{ 0xA5D6, 0xE39F8E },
	{ 0xA5E1, 0xE39F8F },
	{ 0xA5F6, 0xE39F90 },
	{ 0xA641, 0xE39F91 },
	{ 0xA642, 0xE39F92 },
	{ 0xA645, 0xE39F93 },
	{ 0xA649, 0xE39F94 },
	{ 0xA651, 0xE39F95 },
	{ 0xA653, 0xE39F96 },
	{ 0xA661, 0xE39F97 },
	{ 0xA665, 0xE39F98 },
	{ 0xA681, 0xE39F99 },
	{ 0xA682, 0xE39F9A },
	{ 0xA685, 0xE39F9B },
	{ 0xA688, 0xE39F9C },
	{ 0xA689, 0xE39F9D },
	{ 0xA68A, 0xE39F9E },
	{ 0xA68B, 0xE39F9F },
	{ 0xA691, 0xE39FA0 },
	{ 0xA693, 0xE39FA1 },
	{ 0xA695, 0xE39FA2 },
	{ 0xA697, 0xE39FA3 },
	{ 0xA69B, 0xE39FA4 },
	{ 0xA69C, 0xE39FA5 },
	{ 0xA6A1, 0xE39FA6 },
	{ 0xA6A9, 0xE39FA7 },
	{ 0xA6B6, 0xE39FA8 },
	{ 0xA6C1, 0xE39FA9 },
	{ 0xA6E1, 0xE39FAA },
	{ 0xA6E2, 0xE39FAB },
	{ 0xA6E5, 0xE39FAC },
	{ 0xA6E9, 0xE39FAD },
	{ 0xA6F7, 0xE39FAE },
	{ 0xA741, 0xE39FAF },
	{ 0xA745, 0xE39FB0 },
	{ 0xA749, 0xE39FB1 },
	{ 0xA751, 0xE39FB2 },
	{ 0xA755, 0xE39FB3 },
	{ 0xA757, 0xE39FB4 },
	{ 0xA761, 0xE39FB5 },
	{ 0xA762, 0xE39FB6 },
	{ 0xA765, 0xE39FB7 },
	{ 0xA769, 0xE39FB8 },
	{ 0xA771, 0xE39FB9 },
	{ 0xA773, 0xE39FBA },
	{ 0xA775, 0xE39FBB },
	{ 0xA7A1, 0xE39FBC },
	{ 0xA7A2, 0xE39FBD },
	{ 0xA7A5, 0xE39FBE },
	{ 0xA7A9, 0xE39FBF },
	{ 0xA7AB, 0xE3A080 },
	{ 0xA7B1, 0xE3A081 },
	{ 0xA7B3, 0xE3A082 },
	{ 0xA7B5, 0xE3A083 },
	{ 0xA7B7, 0xE3A084 },
	{ 0xA7B8, 0xE3A085 },
	{ 0xA7B9, 0xE3A086 },
	{ 0xA861, 0xE3A087 },
	{ 0xA862, 0xE3A088 },
	{ 0xA865, 0xE3A089 },
	{ 0xA869, 0xE3A08A },
	{ 0xA86B, 0xE3A08B },
	{ 0xA871, 0xE3A08C },
	{ 0xA873, 0xE3A08D },
	{ 0xA875, 0xE3A08E },
	{ 0xA876, 0xE3A08F },
	{ 0xA877, 0xE3A090 },
	{ 0xA87D, 0xE3A091 },
	{ 0xA881, 0xE3A092 },
	{ 0xA882, 0xE3A093 },
	{ 0xA885, 0xE3A094 },
	{ 0xA889, 0xE3A095 },
	{ 0xA891, 0xE3A096 },
	{ 0xA893, 0xE3A097 },
	{ 0xA895, 0xE3A098 },
	{ 0xA896, 0xE3A099 },
	{ 0xA897, 0xE3A09A },
	{ 0xA8A1, 0xE3A09B },
	{ 0xA8A2, 0xE3A09C },
	{ 0xA8B1, 0xE3A09D },
	{ 0xA8E1, 0xE3A09E },
	{ 0xA8E2, 0xE3A09F },
	{ 0xA8E5, 0xE3A0A0 },
	{ 0xA8E8, 0xE3A0A1 },
	{ 0xA8E9, 0xE3A0A2 },
	{ 0xA8F1, 0xE3A0A3 },
	{ 0xA8F5, 0xE3A0A4 },
	{ 0xA8F6, 0xE3A0A5 },
	{ 0xA8F7, 0xE3A0A6 },
	{ 0xA941, 0xE3A0A7 },
	{ 0xA957, 0xE3A0A8 },
	{ 0xA961, 0xE3A0A9 },
	{ 0xA962, 0xE3A0AA },
	{ 0xA971, 0xE3A0AB },
	{ 0xA973, 0xE3A0AC },
	{ 0xA975, 0xE3A0AD },
	{ 0xA976, 0xE3A0AE },
	{ 0xA977, 0xE3A0AF },
	{ 0xA9A1, 0xE3A0B0 },
	{ 0xA9A2, 0xE3A0B1 },
	{ 0xA9A5, 0xE3A0B2 },
	{ 0xA9A9, 0xE3A0B3 },
	{ 0xA9B1, 0xE3A0B4 },
	{ 0xA9B3, 0xE3A0B5 },
	{ 0xA9B7, 0xE3A0B6 },
	{ 0xAA41, 0xE3A0B7 },
	{ 0xAA61, 0xE3A0B8 },
	{ 0xAA77, 0xE3A0B9 },
	{ 0xAA81, 0xE3A0BA },
	{ 0xAA82, 0xE3A0BB },
	{ 0xAA85, 0xE3A0BC },
	{ 0xAA89, 0xE3A0BD },
	{ 0xAA91, 0xE3A0BE },
	{ 0xAA95, 0xE3A0BF },
	{ 0xAA97, 0xE3A180 },
	{ 0xAB41, 0xE3A181 },
	{ 0xAB57, 0xE3A182 },
	{ 0xAB61, 0xE3A183 },
	{ 0xAB65, 0xE3A184 },
	{ 0xAB69, 0xE3A185 },
	{ 0xAB71, 0xE3A186 },
	{ 0xAB73, 0xE3A187 },
	{ 0xABA1, 0xE3A188 },
	{ 0xABA2, 0xE3A189 },
	{ 0xABA5, 0xE3A18A },
	{ 0xABA9, 0xE3A18B },
	{ 0xABB1, 0xE3A18C },
	{ 0xABB3, 0xE3A18D },
	{ 0xABB5, 0xE3A18E },
	{ 0xABB7, 0xE3A18F },
	{ 0xAC61, 0xE3A190 },
	{ 0xAC62, 0xE3A191 },
	{ 0xAC64, 0xE3A192 },
	{ 0xAC65, 0xE3A193 },
	{ 0xAC68, 0xE3A194 },
	{ 0xAC69, 0xE3A195 },
	{ 0xAC6A, 0xE3A196 },
	{ 0xAC6B, 0xE3A197 },
	{ 0xAC71, 0xE3A198 },
	{ 0xAC73, 0xE3A199 },
	{ 0xAC75, 0xE3A19A },
	{ 0xAC76, 0xE3A19B },
	{ 0xAC77, 0xE3A19C },
	{ 0xAC7B, 0xE3A19D },
	{ 0xAC81, 0xE3A19E },
	{ 0xAC82, 0xE3A19F },
	{ 0xAC85, 0xE3A1A0 },
	{ 0xAC89, 0xE3A1A1 },
	{ 0xAC91, 0xE3A1A2 },
	{ 0xAC93, 0xE3A1A3 },
	{ 0xAC95, 0xE3A1A4 },
	{ 0xAC96, 0xE3A1A5 },
	{ 0xAC97, 0xE3A1A6 },
	{ 0xACA1, 0xE3A1A7 },
	{ 0xACA2, 0xE3A1A8 },
	{ 0xACA5, 0xE3A1A9 },
	{ 0xACA9, 0xE3A1AA },
	{ 0xACB1, 0xE3A1AB },
	{ 0xACB3, 0xE3A1AC },
	{ 0xACB5, 0xE3A1AD },
	{ 0xACB7, 0xE3A1AE },
	{ 0xACC1, 0xE3A1AF },
	{ 0xACC5, 0xE3A1B0 },
	{ 0xACC9, 0xE3A1B1 },
	{ 0xACD1, 0xE3A1B2 },
	{ 0xACD7, 0xE3A1B3 },
	{ 0xACE1, 0xE3A1B4 },
	{ 0xACE2, 0xE3A1B5 },
	{ 0xACE3, 0xE3A1B6 },
	{ 0xACE4, 0xE3A1B7 },
	{ 0xACE5, 0xE3A1B8 },
	{ 0xACE8, 0xE3A1B9 },
	{ 0xACE9, 0xE3A1BA },
	{ 0xACEB, 0xE3A1BB },
	{ 0xACEC, 0xE3A1BC },
	{ 0xACF1, 0xE3A1BD },
	{ 0xACF3, 0xE3A1BE },
	{ 0xACF5, 0xE3A1BF },
	{ 0xACF6, 0xE3A280 },
	{ 0xACF7, 0xE3A281 },
	{ 0xACFC, 0xE3A282 },
	{ 0xAD41, 0xE3A283 },
	{ 0xAD42, 0xE3A284 },
	{ 0xAD45, 0xE3A285 },
	{ 0xAD49, 0xE3A286 },
	{ 0xAD51, 0xE3A287 },
	{ 0xAD53, 0xE3A288 },
	{ 0xAD55, 0xE3A289 },
	{ 0xAD56, 0xE3A28A },
	{ 0xAD57, 0xE3A28B },
	{ 0xAD61, 0xE3A28C },
	{ 0xAD62, 0xE3A28D },
	{ 0xAD65, 0xE3A28E },
	{ 0xAD69, 0xE3A28F },
	{ 0xAD71, 0xE3A290 },
	{ 0xAD73, 0xE3A291 },
	{ 0xAD75, 0xE3A292 },
	{ 0xAD76, 0xE3A293 },
	{ 0xAD77, 0xE3A294 },
	{ 0xAD81, 0xE3A295 },
	{ 0xAD85, 0xE3A296 },
	{ 0xAD89, 0xE3A297 },
	{ 0xAD97, 0xE3A298 },
	{ 0xADA1, 0xE3A299 },
	{ 0xADA2, 0xE3A29A },
	{ 0xADA3, 0xE3A29B },
	{ 0xADA5, 0xE3A29C },
	{ 0xADA9, 0xE3A29D },
	{ 0xADAB, 0xE3A29E },
	{ 0xADB1, 0xE3A29F },
	{ 0xADB3, 0xE3A2A0 },
	{ 0xADB5, 0xE3A2A1 },
	{ 0xADB7, 0xE3A2A2 },
	{ 0xADBB, 0xE3A2A3 },
	{ 0xADC1, 0xE3A2A4 },
	{ 0xADC2, 0xE3A2A5 },
	{ 0xADC5, 0xE3A2A6 },
	{ 0xADC9, 0xE3A2A7 },
	{ 0xADD7, 0xE3A2A8 },
	{ 0xADE1, 0xE3A2A9 },
	{ 0xADE5, 0xE3A2AA },
	{ 0xADE9, 0xE3A2AB },
	{ 0xADF1, 0xE3A2AC },
	{ 0xADF5, 0xE3A2AD },
	{ 0xADF6, 0xE3A2AE },
	{ 0xAE41, 0xE3A2AF },
	{ 0xAE45, 0xE3A2B0 },
	{ 0xAE49, 0xE3A2B1 },
	{ 0xAE51, 0xE3A2B2 },
	{ 0xAE53, 0xE3A2B3 },
	{ 0xAE55, 0xE3A2B4 },
	{ 0xAE61, 0xE3A2B5 },
	{ 0xAE62, 0xE3A2B6 },
	{ 0xAE65, 0xE3A2B7 },
	{ 0xAE69, 0xE3A2B8 },
	{ 0xAE71, 0xE3A2B9 },
	{ 0xAE73, 0xE3A2BA },
	{ 0xAE75, 0xE3A2BB },
	{ 0xAE77, 0xE3A2BC },
	{ 0xAE81, 0xE3A2BD },
	{ 0xAE82, 0xE3A2BE },
	{ 0xAE85, 0xE3A2BF },
	{ 0xAE88, 0xE3A380 },
	{ 0xAE89, 0xE3A381 },
	{ 0xAE91, 0xE3A382 },
	{ 0xAE93, 0xE3A383 },
	{ 0xAE95, 0xE3A384 },
	{ 0xAE97, 0xE3A385 },
	{ 0xAE99, 0xE3A386 },
	{ 0xAE9B, 0xE3A387 },
	{ 0xAE9C, 0xE3A388 },
	{ 0xAEA1, 0xE3A389 },
	{ 0xAEB6, 0xE3A38A },
	{ 0xAEC1, 0xE3A38B },
	{ 0xAEC2, 0xE3A38C },
	{ 0xAEC5, 0xE3A38D },
	{ 0xAEC9, 0xE3A38E },
	{ 0xAED1, 0xE3A38F },
	{ 0xAED7, 0xE3A390 },
	{ 0xAEE1, 0xE3A391 },
	{ 0xAEE2, 0xE3A392 },
	{ 0xAEE5, 0xE3A393 },
	{ 0xAEE9, 0xE3A394 },
	{ 0xAEF1, 0xE3A395 },
	{ 0xAEF3, 0xE3A396 },
	{ 0xAEF5, 0xE3A397 },
	{ 0xAEF7, 0xE3A398 },
	{ 0xAF41, 0xE3A399 },
	{ 0xAF42, 0xE3A39A },
	{ 0xAF49, 0xE3A39B },
	{ 0xAF51, 0xE3A39C },
	{ 0xAF55, 0xE3A39D },
	{ 0xAF57, 0xE3A39E },
	{ 0xAF61, 0xE3A39F },
	{ 0xAF62, 0xE3A3A0 },
	{ 0xAF65, 0xE3A3A1 },
	{ 0xAF69, 0xE3A3A2 },
	{ 0xAF6A, 0xE3A3A3 },
	{ 0xAF71, 0xE3A3A4 },
	{ 0xAF73, 0xE3A3A5 },
	{ 0xAF75, 0xE3A3A6 },
	{ 0xAF77, 0xE3A3A7 },
	{ 0xAFA1, 0xE3A3A8 },
	{ 0xAFA2, 0xE3A3A9 },
	{ 0xAFA5, 0xE3A3AA },
	{ 0xAFA8, 0xE3A3AB },
	{ 0xAFA9, 0xE3A3AC },
	{ 0xAFB0, 0xE3A3AD },
	{ 0xAFB1, 0xE3A3AE },
	{ 0xAFB3, 0xE3A3AF },
	{ 0xAFB5, 0xE3A3B0 },
	{ 0xAFB7, 0xE3A3B1 },
	{ 0xAFBC, 0xE3A3B2 },
	{ 0xB061, 0xE3A3B3 },
	{ 0xB062, 0xE3A3B4 },
	{ 0xB064, 0xE3A3B5 },
	{ 0xB065, 0xE3A3B6 },
	{ 0xB069, 0xE3A3B7 },
	{ 0xB071, 0xE3A3B8 },
	{ 0xB073, 0xE3A3B9 },
	{ 0xB076, 0xE3A3BA },
	{ 0xB077, 0xE3A3BB },
	{ 0xB07D, 0xE3A3BC },
	{ 0xB081, 0xE3A3BD },
	{ 0xB082, 0xE3A3BE },
	{ 0xB085, 0xE3A3BF },
	{ 0xB089, 0xE3A480 },
	{ 0xB091, 0xE3A481 },
	{ 0xB093, 0xE3A482 },
	{ 0xB096, 0xE3A483 },
	{ 0xB097, 0xE3A484 },
	{ 0xB0B7, 0xE3A485 },
	{ 0xB0E1, 0xE3A486 },
	{ 0xB0E2, 0xE3A487 },
	{ 0xB0E5, 0xE3A488 },
	{ 0xB0E9, 0xE3A489 },
	{ 0xB0EB, 0xE3A48A },
	{ 0xB0F1, 0xE3A48B },
	{ 0xB0F3, 0xE3A48C },
	{ 0xB0F6, 0xE3A48D },
	{ 0xB0F7, 0xE3A48E },
	{ 0xB141, 0xE3A48F },
	{ 0xB145, 0xE3A490 },
	{ 0xB149, 0xE3A491 },
	{ 0xB185, 0xE3A492 },
	{ 0xB1A1, 0xE3A493 },
	{ 0xB1A2, 0xE3A494 },
	{ 0xB1A5, 0xE3A495 },
	{ 0xB1A8, 0xE3A496 },
	{ 0xB1A9, 0xE3A497 },
	{ 0xB1AB, 0xE3A498 },
	{ 0xB1B1, 0xE3A499 },
	{ 0xB1B3, 0xE3A49A },
	{ 0xB1B7, 0xE3A49B },
	{ 0xB1C1, 0xE3A49C },
	{ 0xB1C2, 0xE3A49D },
	{ 0xB1C5, 0xE3A49E },
	{ 0xB1D6, 0xE3A49F },
	{ 0xB1E1, 0xE3A4A0 },
	{ 0xB1F6, 0xE3A4A1 },
	{ 0xB241, 0xE3A4A2 },
	{ 0xB245, 0xE3A4A3 },
	{ 0xB249, 0xE3A4A4 },
	{ 0xB251, 0xE3A4A5 },
	{ 0xB253, 0xE3A4A6 },
	{ 0xB261, 0xE3A4A7 },
	{ 0xB281, 0xE3A4A8 },
	{ 0xB282, 0xE3A4A9 },
	{ 0xB285, 0xE3A4AA },
	{ 0xB289, 0xE3A4AB },
	{ 0xB291, 0xE3A4AC },
	{ 0xB293, 0xE3A4AD },
	{ 0xB297, 0xE3A4AE },
	{ 0xB2A1, 0xE3A4AF },
	{ 0xB2B6, 0xE3A4B0 },
	{ 0xB2C1, 0xE3A4B1 },
	{ 0xB2E1, 0xE3A4B2 },
	{ 0xB2E5, 0xE3A4B3 },
	{ 0xB357, 0xE3A4B4 },
	{ 0xB361, 0xE3A4B5 },
	{ 0xB362, 0xE3A4B6 },
	{ 0xB365, 0xE3A4B7 },
	{ 0xB369, 0xE3A4B8 },
	{ 0xB36B, 0xE3A4B9 },
	{ 0xB370, 0xE3A4BA },
	{ 0xB371, 0xE3A4BB },
	{ 0xB373, 0xE3A4BC },
	{ 0xB381, 0xE3A4BD },
	{ 0xB385, 0xE3A4BE },
	{ 0xB389, 0xE3A4BF },
	{ 0xB391, 0xE3A580 },
	{ 0xB3A1, 0xE3A581 },
	{ 0xB3A2, 0xE3A582 },
	{ 0xB3A5, 0xE3A583 },
	{ 0xB3A9, 0xE3A584 },
	{ 0xB3B1, 0xE3A585 },
	{ 0xB3B3, 0xE3A586 },
	{ 0xB3B5, 0xE3A587 },
	{ 0xB3B7, 0xE3A588 },
	{ 0xB461, 0xE3A589 },
	{ 0xB462, 0xE3A58A },
	{ 0xB465, 0xE3A58B },
	{ 0xB466, 0xE3A58C },
	{ 0xB467, 0xE3A58D },
	{ 0xB469, 0xE3A58E },
	{ 0xB46A, 0xE3A58F },
	{ 0xB46B, 0xE3A590 },
	{ 0xB470, 0xE3A591 },
	{ 0xB471, 0xE3A592 },
	{ 0xB473, 0xE3A593 },
	{ 0xB475, 0xE3A594 },
	{ 0xB476, 0xE3A595 },
	{ 0xB477, 0xE3A596 },
	{ 0xB47B, 0xE3A597 },
	{ 0xB47C, 0xE3A598 },
	{ 0xB481, 0xE3A599 },
	{ 0xB482, 0xE3A59A },
	{ 0xB485, 0xE3A59B },
	{ 0xB489, 0xE3A59C },
	{ 0xB491, 0xE3A59D },
	{ 0xB493, 0xE3A59E },
	{ 0xB495, 0xE3A59F },
	{ 0xB496, 0xE3A5A0 },
	{ 0xB497, 0xE3A5A1 },
	{ 0xB4A1, 0xE3A5A2 },
	{ 0xB4A2, 0xE3A5A3 },
	{ 0xB4A5, 0xE3A5A4 },
	{ 0xB4A9, 0xE3A5A5 },
	{ 0xB4AC, 0xE3A5A6 },
	{ 0xB4B1, 0xE3A5A7 },
	{ 0xB4B3, 0xE3A5A8 },
	{ 0xB4B5, 0xE3A5A9 },
	{ 0xB4B7, 0xE3A5AA },
	{ 0xB4BB, 0xE3A5AB },
	{ 0xB4BD, 0xE3A5AC },
	{ 0xB4C1, 0xE3A5AD },
	{ 0xB4C5, 0xE3A5AE },
	{ 0xB4C9, 0xE3A5AF },
	{ 0xB4D3, 0xE3A5B0 },
	{ 0xB4E1, 0xE3A5B1 },
	{ 0xB4E2, 0xE3A5B2 },
	{ 0xB4E5, 0xE3A5B3 },
	{ 0xB4E6, 0xE3A5B4 },
	{ 0xB4E8, 0xE3A5B5 },
	{ 0xB4E9, 0xE3A5B6 },
	{ 0xB4EA, 0xE3A5B7 },
	{ 0xB4EB, 0xE3A5B8 },
	{ 0xB4F1, 0xE3A5B9 },
	{ 0xB4F3, 0xE3A5BA },
	{ 0xB4F4, 0xE3A5BB },
	{ 0xB4F5, 0xE3A5BC },
	{ 0xB4F6, 0xE3A5BD },
	{ 0xB4F7, 0xE3A5BE },
	{ 0xB4F8, 0xE3A5BF },
	{ 0xB4FA, 0xE3A680 },
	{ 0xB4FC, 0xE3A681 },
	{ 0xB541, 0xE3A682 },
	{ 0xB542, 0xE3A683 },
	{ 0xB545, 0xE3A684 },
	{ 0xB549, 0xE3A685 },
	{ 0xB551, 0xE3A686 },
	{ 0xB553, 0xE3A687 },
	{ 0xB555, 0xE3A688 },
	{ 0xB557, 0xE3A689 },
	{ 0xB561, 0xE3A68A },
	{ 0xB562, 0xE3A68B },
	{ 0xB563, 0xE3A68C },
	{ 0xB565, 0xE3A68D },
	{ 0xB569, 0xE3A68E },
	{ 0xB56B, 0xE3A68F },
	{ 0xB56C, 0xE3A690 },
	{ 0xB571, 0xE3A691 },
	{ 0xB573, 0xE3A692 },
	{ 0xB574, 0xE3A693 },
	{ 0xB575, 0xE3A694 },
	{ 0xB576, 0xE3A695 },
	{ 0xB577, 0xE3A696 },
	{ 0xB57B, 0xE3A697 },
	{ 0xB57C, 0xE3A698 },
	{ 0xB57D, 0xE3A699 },
	{ 0xB581, 0xE3A69A },
	{ 0xB585, 0xE3A69B },
	{ 0xB589, 0xE3A69C },
	{ 0xB591, 0xE3A69D },
	{ 0xB593, 0xE3A69E },
	{ 0xB595, 0xE3A69F },
	{ 0xB596, 0xE3A6A0 },
	{ 0xB5A1, 0xE3A6A1 },
	{ 0xB5A2, 0xE3A6A2 },
	{ 0xB5A5, 0xE3A6A3 },
	{ 0xB5A9, 0xE3A6A4 },
	{ 0xB5AA, 0xE3A6A5 },
	{ 0xB5AB, 0xE3A6A6 },
	{ 0xB5AD, 0xE3A6A7 },
	{ 0xB5B0, 0xE3A6A8 },
	{ 0xB5B1, 0xE3A6A9 },
	{ 0xB5B3, 0xE3A6AA },
	{ 0xB5B5, 0xE3A6AB },
	{ 0xB5B7, 0xE3A6AC },
	{ 0xB5B9, 0xE3A6AD },
	{ 0xB5C1, 0xE3A6AE },
	{ 0xB5C2, 0xE3A6AF },
	{ 0xB5C5, 0xE3A6B0 },
	{ 0xB5C9, 0xE3A6B1 },
	{ 0xB5D1, 0xE3A6B2 },
	{ 0xB5D3, 0xE3A6B3 },
	{ 0xB5D5, 0xE3A6B4 },
	{ 0xB5D6, 0xE3A6B5 },
	{ 0xB5D7, 0xE3A6B6 },
	{ 0xB5E1, 0xE3A6B7 },
	{ 0xB5E2, 0xE3A6B8 },
	{ 0xB5E5, 0xE3A6B9 },
	{ 0xB5F1, 0xE3A6BA },
	{ 0xB5F5, 0xE3A6BB },
	{ 0xB5F7, 0xE3A6BC },
	{ 0xB641, 0xE3A6BD },
	{ 0xB642, 0xE3A6BE },
	{ 0xB645, 0xE3A6BF },
	{ 0xB649, 0xE3A780 },
	{ 0xB651, 0xE3A781 },
	{ 0xB653, 0xE3A782 },
	{ 0xB655, 0xE3A783 },
	{ 0xB657, 0xE3A784 },
	{ 0xB661, 0xE3A785 },
	{ 0xB662, 0xE3A786 },
	{ 0xB665, 0xE3A787 },
	{ 0xB669, 0xE3A788 },
	{ 0xB671, 0xE3A789 },
	{ 0xB673, 0xE3A78A },
	{ 0xB675, 0xE3A78B },
	{ 0xB677, 0xE3A78C },
	{ 0xB681, 0xE3A78D },
	{ 0xB682, 0xE3A78E },
	{ 0xB685, 0xE3A78F },
	{ 0xB689, 0xE3A790 },
	{ 0xB68A, 0xE3A791 },
	{ 0xB68B, 0xE3A792 },
	{ 0xB691, 0xE3A793 },
	{ 0xB693, 0xE3A794 },
	{ 0xB695, 0xE3A795 },
	{ 0xB697, 0xE3A796 },
	{ 0xB6A1, 0xE3A797 },
	{ 0xB6A2, 0xE3A798 },
	{ 0xB6A5, 0xE3A799 },
	{ 0xB6A9, 0xE3A79A },
	{ 0xB6B1, 0xE3A79B },
	{ 0xB6B3, 0xE3A79C },
	{ 0xB6B6, 0xE3A79D },
	{ 0xB6B7, 0xE3A79E },
	{ 0xB6C1, 0xE3A79F },
	{ 0xB6C2, 0xE3A7A0 },
	{ 0xB6C5, 0xE3A7A1 },
	{ 0xB6C9, 0xE3A7A2 },
	{ 0xB6D1, 0xE3A7A3 },
	{ 0xB6D3, 0xE3A7A4 },
	{ 0xB6D7, 0xE3A7A5 },
	{ 0xB6E1, 0xE3A7A6 },
	{ 0xB6E2, 0xE3A7A7 },
	{ 0xB6E5, 0xE3A7A8 },
	{ 0xB6E9, 0xE3A7A9 },
	{ 0xB6F1, 0xE3A7AA },
	{ 0xB6F3, 0xE3A7AB },
	{ 0xB6F5, 0xE3A7AC },
	{ 0xB6F7, 0xE3A7AD },
	{ 0xB741, 0xE3A7AE },
	{ 0xB742, 0xE3A7AF },
	{ 0xB745, 0xE3A7B0 },
	{ 0xB749, 0xE3A7B1 },
	{ 0xB751, 0xE3A7B2 },
	{ 0xB753, 0xE3A7B3 },
	{ 0xB755, 0xE3A7B4 },
	{ 0xB757, 0xE3A7B5 },
	{ 0xB759, 0xE3A7B6 },
	{ 0xB761, 0xE3A7B7 },
	{ 0xB762, 0xE3A7B8 },
	{ 0xB765, 0xE3A7B9 },
	{ 0xB769, 0xE3A7BA },
	{ 0xB76F, 0xE3A7BB },
	{ 0xB771, 0xE3A7BC },
	{ 0xB773, 0xE3A7BD },
	{ 0xB775, 0xE3A7BE },
	{ 0xB777, 0xE3A7BF },
	{ 0xB778, 0xE3A880 },
	{ 0xB779, 0xE3A881 },
	{ 0xB77A, 0xE3A882 },
	{ 0xB77B, 0xE3A883 },
	{ 0xB77C, 0xE3A884 },
	{ 0xB77D, 0xE3A885 },
	{ 0xB781, 0xE3A886 },
	{ 0xB785, 0xE3A887 },
	{ 0xB789, 0xE3A888 },
	{ 0xB791, 0xE3A889 },
	{ 0xB795, 0xE3A88A },
	{ 0xB7A1, 0xE3A88B },
	{ 0xB7A2, 0xE3A88C },
	{ 0xB7A5, 0xE3A88D },
	{ 0xB7A9, 0xE3A88E },
	{ 0xB7AA, 0xE3A88F },
	{ 0xB7AB, 0xE3A890 },
	{ 0xB7B0, 0xE3A891 },
	{ 0xB7B1, 0xE3A892 },
	{ 0xB7B3, 0xE3A893 },
	{ 0xB7B5, 0xE3A894 },
	{ 0xB7B6, 0xE3A895 },
	{ 0xB7B7, 0xE3A896 },
	{ 0xB7B8, 0xE3A897 },
	{ 0xB7BC, 0xE3A898 },
	{ 0xB861, 0xE3A899 },
	{ 0xB862, 0xE3A89A },
	{ 0xB865, 0xE3A89B },
	{ 0xB867, 0xE3A89C },
	{ 0xB868, 0xE3A89D },
	{ 0xB869, 0xE3A89E },
	{ 0xB86B, 0xE3A89F },
	{ 0xB871, 0xE3A8A0 },
	{ 0xB873, 0xE3A8A1 },
	{ 0xB875, 0xE3A8A2 },
	{ 0xB876, 0xE3A8A3 },
	{ 0xB877, 0xE3A8A4 },
	{ 0xB878, 0xE3A8A5 },
	{ 0xB881, 0xE3A8A6 },
	{ 0xB882, 0xE3A8A7 },
	{ 0xB885, 0xE3A8A8 },
	{ 0xB889, 0xE3A8A9 },
	{ 0xB891, 0xE3A8AA },
	{ 0xB893, 0xE3A8AB },
	{ 0xB895, 0xE3A8AC },
	{ 0xB896, 0xE3A8AD },
	{ 0xB897, 0xE3A8AE },
	{ 0xB8A1, 0xE3A8AF },
	{ 0xB8A2, 0xE3A8B0 },
	{ 0xB8A5, 0xE3A8B1 },
	{ 0xB8A7, 0xE3A8B2 },
	{ 0xB8A9, 0xE3A8B3 },
	{ 0xB8B1, 0xE3A8B4 },
	{ 0xB8B7, 0xE3A8B5 },
	{ 0xB8C1, 0xE3A8B6 },
	{ 0xB8C5, 0xE3A8B7 },
	{ 0xB8C9, 0xE3A8B8 },
	{ 0xB8E1, 0xE3A8B9 },
	{ 0xB8E2, 0xE3A8BA },
	{ 0xB8E5, 0xE3A8BB },
	{ 0xB8E9, 0xE3A8BC },
	{ 0xB8EB, 0xE3A8BD },
	{ 0xB8F1, 0xE3A8BE },
	{ 0xB8F3, 0xE3A8BF },
	{ 0xB8F5, 0xE3A980 },
	{ 0xB8F7, 0xE3A981 },
	{ 0xB8F8, 0xE3A982 },
	{ 0xB941, 0xE3A983 },
	{ 0xB942, 0xE3A984 },
	{ 0xB945, 0xE3A985 },
	{ 0xB949, 0xE3A986 },
	{ 0xB951, 0xE3A987 },
	{ 0xB953, 0xE3A988 },
	{ 0xB955, 0xE3A989 },
	{ 0xB957, 0xE3A98A },
	{ 0xB961, 0xE3A98B },
	{ 0xB965, 0xE3A98C },
	{ 0xB969, 0xE3A98D },
	{ 0xB971, 0xE3A98E },
	{ 0xB973, 0xE3A98F },
	{ 0xB976, 0xE3A990 },
	{ 0xB977, 0xE3A991 },
	{ 0xB981, 0xE3A992 },
	{ 0xB9A1, 0xE3A993 },
	{ 0xB9A2, 0xE3A994 },
	{ 0xB9A5, 0xE3A995 },
	{ 0xB9A9, 0xE3A996 },
	{ 0xB9AB, 0xE3A997 },
	{ 0xB9B1, 0xE3A998 },
	{ 0xB9B3, 0xE3A999 },
	{ 0xB9B5, 0xE3A99A },
	{ 0xB9B7, 0xE3A99B },
	{ 0xB9B8, 0xE3A99C },
	{ 0xB9B9, 0xE3A99D },
	{ 0xB9BD, 0xE3A99E },
	{ 0xB9C1, 0xE3A99F },
	{ 0xB9C2, 0xE3A9A0 },
	{ 0xB9C9, 0xE3A9A1 },
	{ 0xB9D3, 0xE3A9A2 },
	{ 0xB9D5, 0xE3A9A3 },
	{ 0xB9D7, 0xE3A9A4 },
	{ 0xB9E1, 0xE3A9A5 },
	{ 0xB9F6, 0xE3A9A6 },
	{ 0xB9F7, 0xE3A9A7 },
	{ 0xBA41, 0xE3A9A8 },
	{ 0xBA45, 0xE3A9A9 },
	{ 0xBA49, 0xE3A9AA },
	{ 0xBA51, 0xE3A9AB },
	{ 0xBA53, 0xE3A9AC },
	{ 0xBA55, 0xE3A9AD },
	{ 0xBA57, 0xE3A9AE },
	{ 0xBA61, 0xE3A9AF },
	{ 0xBA62, 0xE3A9B0 },
	{ 0xBA65, 0xE3A9B1 },
	{ 0xBA77, 0xE3A9B2 },
	{ 0xBA81, 0xE3A9B3 },
	{ 0xBA82, 0xE3A9B4 },
	{ 0xBA85, 0xE3A9B5 },
	{ 0xBA89, 0xE3A9B6 },
	{ 0xBA8A, 0xE3A9B7 },
	{ 0xBA8B, 0xE3A9B8 },
	{ 0xBA91, 0xE3A9B9 },
	{ 0xBA93, 0xE3A9BA },
	{ 0xBA95, 0xE3A9BB },
	{ 0xBA97, 0xE3A9BC },
	{ 0xBAA1, 0xE3A9BD },
	{ 0xBAB6, 0xE3A9BE },
	{ 0xBAC1, 0xE3A9BF },
	{ 0xBAE1, 0xE3AA80 },
	{ 0xBAE2, 0xE3AA81 },
	{ 0xBAE5, 0xE3AA82 },
	{ 0xBAE9, 0xE3AA83 },
	{ 0xBAF1, 0xE3AA84 },
	{ 0xBAF3, 0xE3AA85 },
	{ 0xBAF5, 0xE3AA86 },
	{ 0xBB41, 0xE3AA87 },
	{ 0xBB45, 0xE3AA88 },
	{ 0xBB49, 0xE3AA89 },
	{ 0xBB51, 0xE3AA8A },
	{ 0xBB61, 0xE3AA8B },
	{ 0xBB62, 0xE3AA8C },
	{ 0xBB65, 0xE3AA8D },
	{ 0xBB69, 0xE3AA8E },
	{ 0xBB71, 0xE3AA8F },
	{ 0xBB73, 0xE3AA90 },
	{ 0xBB75, 0xE3AA91 },
	{ 0xBB77, 0xE3AA92 },
	{ 0xBBA1, 0xE3AA93 },
	{ 0xBBA2, 0xE3AA94 },
	{ 0xBBA5, 0xE3AA95 },
	{ 0xBBA8, 0xE3AA96 },
	{ 0xBBA9, 0xE3AA97 },
	{ 0xBBAB, 0xE3AA98 },
	{ 0xBBB1, 0xE3AA99 },
	{ 0xBBB3, 0xE3AA9A },
	{ 0xBBB5, 0xE3AA9B },
	{ 0xBBB7, 0xE3AA9C },
	{ 0xBBB8, 0xE3AA9D },
	{ 0xBBBB, 0xE3AA9E },
	{ 0xBBBC, 0xE3AA9F },
	{ 0xBC61, 0xE3AAA0 },
	{ 0xBC62, 0xE3AAA1 },
	{ 0xBC65, 0xE3AAA2 },
	{ 0xBC67, 0xE3AAA3 },
	{ 0xBC69, 0xE3AAA4 },
	{ 0xBC6C, 0xE3AAA5 },
	{ 0xBC71, 0xE3AAA6 },
	{ 0xBC73, 0xE3AAA7 },
	{ 0xBC75, 0xE3AAA8 },
	{ 0xBC76, 0xE3AAA9 },
	{ 0xBC77, 0xE3AAAA },
	{ 0xBC81, 0xE3AAAB },
	{ 0xBC82, 0xE3AAAC },
	{ 0xBC85, 0xE3AAAD },
	{ 0xBC89, 0xE3AAAE },
	{ 0xBC91, 0xE3AAAF },
	{ 0xBC93, 0xE3AAB0 },
	{ 0xBC95, 0xE3AAB1 },
	{ 0xBC96, 0xE3AAB2 },
	{ 0xBC97, 0xE3AAB3 },
	{ 0xBCA1, 0xE3AAB4 },
	{ 0xBCA5, 0xE3AAB5 },
	{ 0xBCB7, 0xE3AAB6 },
	{ 0xBCE1, 0xE3AAB7 },
	{ 0xBCE2, 0xE3AAB8 },
	{ 0xBCE5, 0xE3AAB9 },
	{ 0xBCE9, 0xE3AABA },
	{ 0xBCF1, 0xE3AABB },
	{ 0xBCF3, 0xE3AABC },
	{ 0xBCF5, 0xE3AABD },
	{ 0xBCF6, 0xE3AABE },
	{ 0xBCF7, 0xE3AABF },
	{ 0xBD41, 0xE3AB80 },
	{ 0xBD57, 0xE3AB81 },
	{ 0xBD61, 0xE3AB82 },
	{ 0xBD76, 0xE3AB83 },
	{ 0xBDA1, 0xE3AB84 },
	{ 0xBDA2, 0xE3AB85 },
	{ 0xBDA5, 0xE3AB86 },
	{ 0xBDA9, 0xE3AB87 },
	{ 0xBDB1, 0xE3AB88 },
	{ 0xBDB3, 0xE3AB89 },
	{ 0xBDB5, 0xE3AB8A },
	{ 0xBDB7, 0xE3AB8B },
	{ 0xBDB9, 0xE3AB8C },
	{ 0xBDC1, 0xE3AB8D },
	{ 0xBDC2, 0xE3AB8E },
	{ 0xBDC9, 0xE3AB8F },
	{ 0xBDD6, 0xE3AB90 },
	{ 0xBDE1, 0xE3AB91 },
	{ 0xBDF6, 0xE3AB92 },
	{ 0xBE41, 0xE3AB93 },
	{ 0xBE45, 0xE3AB94 },
	{ 0xBE49, 0xE3AB95 },
	{ 0xBE51, 0xE3AB96 },
	{ 0xBE53, 0xE3AB97 },
	{ 0xBE77, 0xE3AB98 },
	{ 0xBE81, 0xE3AB99 },
	{ 0xBE82, 0xE3AB9A },
	{ 0xBE85, 0xE3AB9B },
	{ 0xBE89, 0xE3AB9C },
	{ 0xBE91, 0xE3AB9D },
	{ 0xBE93, 0xE3AB9E },
	{ 0xBE97, 0xE3AB9F },
	{ 0xBEA1, 0xE3ABA0 },
	{ 0xBEB6, 0xE3ABA1 },
	{ 0xBEB7, 0xE3ABA2 },
	{ 0xBEE1, 0xE3ABA3 },
	{ 0xBF41, 0xE3ABA4 },
	{ 0xBF61, 0xE3ABA5 },
	{ 0xBF71, 0xE3ABA6 },
	{ 0xBF75, 0xE3ABA7 },
	{ 0xBF77, 0xE3ABA8 },
	{ 0xBFA1, 0xE3ABA9 },
	{ 0xBFA2, 0xE3ABAA },
	{ 0xBFA5, 0xE3ABAB },
	{ 0xBFA9, 0xE3ABAC },
	{ 0xBFB1, 0xE3ABAD },
	{ 0xBFB3, 0xE3ABAE },
	{ 0xBFB7, 0xE3ABAF },
	{ 0xBFB8, 0xE3ABB0 },
	{ 0xBFBD, 0xE3ABB1 },
	{ 0xC061, 0xE3ABB2 },
	{ 0xC062, 0xE3ABB3 },
	{ 0xC065, 0xE3ABB4 },
	{ 0xC067, 0xE3ABB5 },
	{ 0xC069, 0xE3ABB6 },
	{ 0xC071, 0xE3ABB7 },
	{ 0xC073, 0xE3ABB8 },
	{ 0xC075, 0xE3ABB9 },
	{ 0xC076, 0xE3ABBA },
	{ 0xC077, 0xE3ABBB },
	{ 0xC078, 0xE3ABBC },
	{ 0xC081, 0xE3ABBD },
	{ 0xC082, 0xE3ABBE },
	{ 0xC085, 0xE3ABBF },
	{ 0xC089, 0xE3AC80 },
	{ 0xC091, 0xE3AC81 },
	{ 0xC093, 0xE3AC82 },
	{ 0xC095, 0xE3AC83 },
	{ 0xC096, 0xE3AC84 },
	{ 0xC097, 0xE3AC85 },
	{ 0xC0A1, 0xE3AC86 },
	{ 0xC0A5, 0xE3AC87 },
	{ 0xC0A7, 0xE3AC88 },
	{ 0xC0A9, 0xE3AC89 },
	{ 0xC0B1, 0xE3AC8A },
	{ 0xC0B7, 0xE3AC8B },
	{ 0xC0E1, 0xE3AC8C },
	{ 0xC0E2, 0xE3AC8D },
	{ 0xC0E5, 0xE3AC8E },
	{ 0xC0E9, 0xE3AC8F },
	{ 0xC0F1, 0xE3AC90 },
	{ 0xC0F3, 0xE3AC91 },
	{ 0xC0F5, 0xE3AC92 },
	{ 0xC0F6, 0xE3AC93 },
	{ 0xC0F7, 0xE3AC94 },
	{ 0xC141, 0xE3AC95 },
	{ 0xC142, 0xE3AC96 },
	{ 0xC145, 0xE3AC97 },
	{ 0xC149, 0xE3AC98 },
	{ 0xC151, 0xE3AC99 },
	{ 0xC153, 0xE3AC9A },
	{ 0xC155, 0xE3AC9B },
	{ 0xC157, 0xE3AC9C },
	{ 0xC161, 0xE3AC9D },
	{ 0xC165, 0xE3AC9E },
	{ 0xC176, 0xE3AC9F },
	{ 0xC181, 0xE3ACA0 },
	{ 0xC185, 0xE3ACA1 },
	{ 0xC197, 0xE3ACA2 },
	{ 0xC1A1, 0xE3ACA3 },
	{ 0xC1A2, 0xE3ACA4 },
	{ 0xC1A5, 0xE3ACA5 },
	{ 0xC1A9, 0xE3ACA6 },
	{ 0xC1B1, 0xE3ACA7 },
	{ 0xC1B3, 0xE3ACA8 },
	{ 0xC1B5, 0xE3ACA9 },
	{ 0xC1B7, 0xE3ACAA },
	{ 0xC1C1, 0xE3ACAB },
	{ 0xC1C5, 0xE3ACAC },
	{ 0xC1C9, 0xE3ACAD },
	{ 0xC1D7, 0xE3ACAE },
	{ 0xC241, 0xE3ACAF },
	{ 0xC245, 0xE3ACB0 },
	{ 0xC249, 0xE3ACB1 },
	{ 0xC251, 0xE3ACB2 },
	{ 0xC253, 0xE3ACB3 },
	{ 0xC255, 0xE3ACB4 },
	{ 0xC257, 0xE3ACB5 },
	{ 0xC261, 0xE3ACB6 },
	{ 0xC271, 0xE3ACB7 },
	{ 0xC281, 0xE3ACB8 },
	{ 0xC282, 0xE3ACB9 },
	{ 0xC285, 0xE3ACBA },
	{ 0xC289, 0xE3ACBB },
	{ 0xC291, 0xE3ACBC },
	{ 0xC293, 0xE3ACBD },
	{ 0xC295, 0xE3ACBE },
	{ 0xC297, 0xE3ACBF },
	{ 0xC2A1, 0xE3AD80 },
	{ 0xC2B6, 0xE3AD81 },
	{ 0xC2C1, 0xE3AD82 },
	{ 0xC2C5, 0xE3AD83 },
	{ 0xC2E1, 0xE3AD84 },
	{ 0xC2E5, 0xE3AD85 },
	{ 0xC2E9, 0xE3AD86 },
	{ 0xC2F1, 0xE3AD87 },
	{ 0xC2F3, 0xE3AD88 },
	{ 0xC2F5, 0xE3AD89 },
	{ 0xC2F7, 0xE3AD8A },
	{ 0xC341, 0xE3AD8B },
	{ 0xC345, 0xE3AD8C },
	{ 0xC349, 0xE3AD8D },
	{ 0xC351, 0xE3AD8E },
	{ 0xC357, 0xE3AD8F },
	{ 0xC361, 0xE3AD90 },
	{ 0xC362, 0xE3AD91 },
	{ 0xC365, 0xE3AD92 },
	{ 0xC369, 0xE3AD93 },
	{ 0xC371, 0xE3AD94 },
	{ 0xC373, 0xE3AD95 },
	{ 0xC375, 0xE3AD96 },
	{ 0xC377, 0xE3AD97 },
	{ 0xC3A1, 0xE3AD98 },
	{ 0xC3A2, 0xE3AD99 },
	{ 0xC3A5, 0xE3AD9A },
	{ 0xC3A8, 0xE3AD9B },
	{ 0xC3A9, 0xE3AD9C },
	{ 0xC3AA, 0xE3AD9D },
	{ 0xC3B1, 0xE3AD9E },
	{ 0xC3B3, 0xE3AD9F },
	{ 0xC3B5, 0xE3ADA0 },
	{ 0xC3B7, 0xE3ADA1 },
	{ 0xC461, 0xE3ADA2 },
	{ 0xC462, 0xE3ADA3 },
	{ 0xC465, 0xE3ADA4 },
	{ 0xC469, 0xE3ADA5 },
	{ 0xC471, 0xE3ADA6 },
	{ 0xC473, 0xE3ADA7 },
	{ 0xC475, 0xE3ADA8 },
	{ 0xC477, 0xE3ADA9 },
	{ 0xC481, 0xE3ADAA },
	{ 0xC482, 0xE3ADAB },
	{ 0xC485, 0xE3ADAC },
	{ 0xC489, 0xE3ADAD },
	{ 0xC491, 0xE3ADAE },
	{ 0xC493, 0xE3ADAF },
	{ 0xC495, 0xE3ADB0 },
	{ 0xC496, 0xE3ADB1 },
	{ 0xC497, 0xE3ADB2 },
	{ 0xC4A1, 0xE3ADB3 },
	{ 0xC4A2, 0xE3ADB4 },
	{ 0xC4B7, 0xE3ADB5 },
	{ 0xC4E1, 0xE3ADB6 },
	{ 0xC4E2, 0xE3ADB7 },
	{ 0xC4E5, 0xE3ADB8 },
	{ 0xC4E8, 0xE3ADB9 },
	{ 0xC4E9, 0xE3ADBA },
	{ 0xC4F1, 0xE3ADBB },
	{ 0xC4F3, 0xE3ADBC },
	{ 0xC4F5, 0xE3ADBD },
	{ 0xC4F6, 0xE3ADBE },
	{ 0xC4F7, 0xE3ADBF },
	{ 0xC541, 0xE3AE80 },
	{ 0xC542, 0xE3AE81 },
	{ 0xC545, 0xE3AE82 },
	{ 0xC549, 0xE3AE83 },
	{ 0xC551, 0xE3AE84 },
	{ 0xC553, 0xE3AE85 },
	{ 0xC555, 0xE3AE86 },
	{ 0xC557, 0xE3AE87 },
	{ 0xC561, 0xE3AE88 },
	{ 0xC565, 0xE3AE89 },
	{ 0xC569, 0xE3AE8A },
	{ 0xC571, 0xE3AE8B },
	{ 0xC573, 0xE3AE8C },
	{ 0xC575, 0xE3AE8D },
	{ 0xC576, 0xE3AE8E },
	{ 0xC577, 0xE3AE8F },
	{ 0xC581, 0xE3AE90 },
	{ 0xC5A1, 0xE3AE91 },
	{ 0xC5A2, 0xE3AE92 },
	{ 0xC5A5, 0xE3AE93 },
	{ 0xC5A9, 0xE3AE94 },
	{ 0xC5B1, 0xE3AE95 },
	{ 0xC5B3, 0xE3AE96 },
	{ 0xC5B5, 0xE3AE97 },
	{ 0xC5B7, 0xE3AE98 },
	{ 0xC5C1, 0xE3AE99 },
	{ 0xC5C2, 0xE3AE9A },
	{ 0xC5C5, 0xE3AE9B },
	{ 0xC5C9, 0xE3AE9C },
	{ 0xC5D1, 0xE3AE9D },
	{ 0xC5D7, 0xE3AE9E },
	{ 0xC5E1, 0xE3AE9F },
	{ 0xC5F7, 0xE3AEA0 },
	{ 0xC641, 0xE3AEA1 },
	{ 0xC649, 0xE3AEA2 },
	{ 0xC661, 0xE3AEA3 },
	{ 0xC681, 0xE3AEA4 },
	{ 0xC682, 0xE3AEA5 },
	{ 0xC685, 0xE3AEA6 },
	{ 0xC689, 0xE3AEA7 },
	{ 0xC691, 0xE3AEA8 },
	{ 0xC693, 0xE3AEA9 },
	{ 0xC695, 0xE3AEAA },
	{ 0xC697, 0xE3AEAB },
	{ 0xC6A1, 0xE3AEAC },
	{ 0xC6A5, 0xE3AEAD },
	{ 0xC6A9, 0xE3AEAE },
	{ 0xC6B7, 0xE3AEAF },
	{ 0xC6C1, 0xE3AEB0 },
	{ 0xC6D7, 0xE3AEB1 },
	{ 0xC6E1, 0xE3AEB2 },
	{ 0xC6E2, 0xE3AEB3 },
	{ 0xC6E5, 0xE3AEB4 },
	{ 0xC6E9, 0xE3AEB5 },
	{ 0xC6F1, 0xE3AEB6 },
	{ 0xC6F3, 0xE3AEB7 },
	{ 0xC6F5, 0xE3AEB8 },
	{ 0xC6F7, 0xE3AEB9 },
	{ 0xC741, 0xE3AEBA },
	{ 0xC745, 0xE3AEBB },
	{ 0xC749, 0xE3AEBC },
	{ 0xC751, 0xE3AEBD },
	{ 0xC761, 0xE3AEBE },
	{ 0xC762, 0xE3AEBF },
	{ 0xC765, 0xE3AF80 },
	{ 0xC769, 0xE3AF81 },
	{ 0xC771, 0xE3AF82 },
	{ 0xC773, 0xE3AF83 },
	{ 0xC777, 0xE3AF84 },
	{ 0xC7A1, 0xE3AF85 },
	{ 0xC7A2, 0xE3AF86 },
	{ 0xC7A5, 0xE3AF87 },
	{ 0xC7A9, 0xE3AF88 },
	{ 0xC7B1, 0xE3AF89 },
	{ 0xC7B3, 0xE3AF8A },
	{ 0xC7B5, 0xE3AF8B },
	{ 0xC7B7, 0xE3AF8C },
	{ 0xC861, 0xE3AF8D },
	{ 0xC862, 0xE3AF8E },
	{ 0xC865, 0xE3AF8F },
	{ 0xC869, 0xE3AF90 },
	{ 0xC86A, 0xE3AF91 },
	{ 0xC871, 0xE3AF92 },
	{ 0xC873, 0xE3AF93 },
	{ 0xC875, 0xE3AF94 },
	{ 0xC876, 0xE3AF95 },
	{ 0xC877, 0xE3AF96 },
	{ 0xC881, 0xE3AF97 },
	{ 0xC882, 0xE3AF98 },
	{ 0xC885, 0xE3AF99 },
	{ 0xC889, 0xE3AF9A },
	{ 0xC891, 0xE3AF9B },
	{ 0xC893, 0xE3AF9C },
	{ 0xC895, 0xE3AF9D },
	{ 0xC896, 0xE3AF9E },
	{ 0xC897, 0xE3AF9F },
	{ 0xC8A1, 0xE3AFA0 },
	{ 0xC8B7, 0xE3AFA1 },
	{ 0xC8E1, 0xE3AFA2 },
	{ 0xC8E2, 0xE3AFA3 },
	{ 0xC8E5, 0xE3AFA4 },
	{ 0xC8E9, 0xE3AFA5 },
	{ 0xC8EB, 0xE3AFA6 },
	{ 0xC8F1, 0xE3AFA7 },
	{ 0xC8F3, 0xE3AFA8 },
	{ 0xC8F5, 0xE3AFA9 },
	{ 0xC8F6, 0xE3AFAA },
	{ 0xC8F7, 0xE3AFAB },
	{ 0xC941, 0xE3AFAC },
	{ 0xC942, 0xE3AFAD },
	{ 0xC945, 0xE3AFAE },
	{ 0xC949, 0xE3AFAF },
	{ 0xC951, 0xE3AFB0 },
	{ 0xC953, 0xE3AFB1 },
	{ 0xC955, 0xE3AFB2 },
	{ 0xC957, 0xE3AFB3 },
	{ 0xC961, 0xE3AFB4 },
	{ 0xC965, 0xE3AFB5 },
	{ 0xC976, 0xE3AFB6 },
	{ 0xC981, 0xE3AFB7 },
	{ 0xC985, 0xE3AFB8 },
	{ 0xC9A1, 0xE3AFB9 },
	{ 0xC9A2, 0xE3AFBA },
	{ 0xC9A5, 0xE3AFBB },
	{ 0xC9A9, 0xE3AFBC },
	{ 0xC9B1, 0xE3AFBD },
	{ 0xC9B3, 0xE3AFBE },
	{ 0xC9B5, 0xE3AFBF },
	{ 0xC9B7, 0xE3B080 },
	{ 0xC9BC, 0xE3B081 },
	{ 0xC9C1, 0xE3B082 },
	{ 0xC9C5, 0xE3B083 },
	{ 0xC9E1, 0xE3B084 },
	{ 0xCA41, 0xE3B085 },
	{ 0xCA45, 0xE3B086 },
	{ 0xCA55, 0xE3B087 },
	{ 0xCA57, 0xE3B088 },
	{ 0xCA61, 0xE3B089 },
	{ 0xCA81, 0xE3B08A },
	{ 0xCA82, 0xE3B08B },
	{ 0xCA85, 0xE3B08C },
	{ 0xCA89, 0xE3B08D },
	{ 0xCA91, 0xE3B08E },
	{ 0xCA93, 0xE3B08F },
	{ 0xCA95, 0xE3B090 },
	{ 0xCA97, 0xE3B091 },
	{ 0xCAA1, 0xE3B092 },
	{ 0xCAB6, 0xE3B093 },
	{ 0xCAC1, 0xE3B094 },
	{ 0xCAE1, 0xE3B095 },
	{ 0xCAE2, 0xE3B096 },
	{ 0xCAE5, 0xE3B097 },
	{ 0xCAE9, 0xE3B098 },
	{ 0xCAF1, 0xE3B099 },
	{ 0xCAF3, 0xE3B09A },
	{ 0xCAF7, 0xE3B09B },
	{ 0xCB41, 0xE3B09C },
	{ 0xCB45, 0xE3B09D },
	{ 0xCB49, 0xE3B09E },
	{ 0xCB51, 0xE3B09F },
	{ 0xCB57, 0xE3B0A0 },
	{ 0xCB61, 0xE3B0A1 },
	{ 0xCB62, 0xE3B0A2 },
	{ 0xCB65, 0xE3B0A3 },
	{ 0xCB68, 0xE3B0A4 },
	{ 0xCB69, 0xE3B0A5 },
	{ 0xCB6B, 0xE3B0A6 },
	{ 0xCB71, 0xE3B0A7 },
	{ 0xCB73, 0xE3B0A8 },
	{ 0xCB75, 0xE3B0A9 },
	{ 0xCB81, 0xE3B0AA },
	{ 0xCB85, 0xE3B0AB },
	{ 0xCB89, 0xE3B0AC },
	{ 0xCB91, 0xE3B0AD },
	{ 0xCB93, 0xE3B0AE },
	{ 0xCBA1, 0xE3B0AF },
	{ 0xCBA2, 0xE3B0B0 },
	{ 0xCBA5, 0xE3B0B1 },
	{ 0xCBA9, 0xE3B0B2 },
	{ 0xCBB1, 0xE3B0B3 },
	{ 0xCBB3, 0xE3B0B4 },
	{ 0xCBB5, 0xE3B0B5 },
	{ 0xCBB7, 0xE3B0B6 },
	{ 0xCC61, 0xE3B0B7 },
	{ 0xCC62, 0xE3B0B8 },
	{ 0xCC63, 0xE3B0B9 },
	{ 0xCC65, 0xE3B0BA },
	{ 0xCC69, 0xE3B0BB },
	{ 0xCC6B, 0xE3B0BC },
	{ 0xCC71, 0xE3B0BD },
	{ 0xCC73, 0xE3B0BE },
	{ 0xCC75, 0xE3B0BF },
	{ 0xCC76, 0xE3B180 },
	{ 0xCC77, 0xE3B181 },
	{ 0xCC7B, 0xE3B182 },
	{ 0xCC81, 0xE3B183 },
	{ 0xCC82, 0xE3B184 },
	{ 0xCC85, 0xE3B185 },
	{ 0xCC89, 0xE3B186 },
	{ 0xCC91, 0xE3B187 },
	{ 0xCC93, 0xE3B188 },
	{ 0xCC95, 0xE3B189 },
	{ 0xCC96, 0xE3B18A },
	{ 0xCC97, 0xE3B18B },
	{ 0xCCA1, 0xE3B18C },
	{ 0xCCA2, 0xE3B18D },
	{ 0xCCE1, 0xE3B18E },
	{ 0xCCE2, 0xE3B18F },
	{ 0xCCE5, 0xE3B190 },
	{ 0xCCE9, 0xE3B191 },
	{ 0xCCF1, 0xE3B192 },
	{ 0xCCF3, 0xE3B193 },
	{ 0xCCF5, 0xE3B194 },
	{ 0xCCF6, 0xE3B195 },
	{ 0xCCF7, 0xE3B196 },
	{ 0xCD41, 0xE3B197 },
	{ 0xCD42, 0xE3B198 },
	{ 0xCD45, 0xE3B199 },
	{ 0xCD49, 0xE3B19A },
	{ 0xCD51, 0xE3B19B },
	{ 0xCD53, 0xE3B19C },
	{ 0xCD55, 0xE3B19D },
	{ 0xCD57, 0xE3B19E },
	{ 0xCD61, 0xE3B19F },
	{ 0xCD65, 0xE3B1A0 },
	{ 0xCD69, 0xE3B1A1 },
	{ 0xCD71, 0xE3B1A2 },
	{ 0xCD73, 0xE3B1A3 },
	{ 0xCD76, 0xE3B1A4 },
	{ 0xCD77, 0xE3B1A5 },
	{ 0xCD81, 0xE3B1A6 },
	{ 0xCD89, 0xE3B1A7 },
	{ 0xCD93, 0xE3B1A8 },
	{ 0xCD95, 0xE3B1A9 },
	{ 0xCDA1, 0xE3B1AA },
	{ 0xCDA2, 0xE3B1AB },
	{ 0xCDA5, 0xE3B1AC },
	{ 0xCDA9, 0xE3B1AD },
	{ 0xCDB1, 0xE3B1AE },
	{ 0xCDB3, 0xE3B1AF },
	{ 0xCDB5, 0xE3B1B0 },
	{ 0xCDB7, 0xE3B1B1 },
	{ 0xCDC1, 0xE3B1B2 },
	{ 0xCDD7, 0xE3B1B3 },
	{ 0xCE41, 0xE3B1B4 },
	{ 0xCE45, 0xE3B1B5 },
	{ 0xCE61, 0xE3B1B6 },
	{ 0xCE65, 0xE3B1B7 },
	{ 0xCE69, 0xE3B1B8 },
	{ 0xCE73, 0xE3B1B9 },
	{ 0xCE75, 0xE3B1BA },
	{ 0xCE81, 0xE3B1BB },
	{ 0xCE82, 0xE3B1BC },
	{ 0xCE85, 0xE3B1BD },
	{ 0xCE88, 0xE3B1BE },
	{ 0xCE89, 0xE3B1BF },
	{ 0xCE8B, 0xE3B280 },
	{ 0xCE91, 0xE3B281 },
	{ 0xCE93, 0xE3B282 },
	{ 0xCE95, 0xE3B283 },
	{ 0xCE97, 0xE3B284 },
	{ 0xCEA1, 0xE3B285 },
	{ 0xCEB7, 0xE3B286 },
	{ 0xCEE1, 0xE3B287 },
	{ 0xCEE5, 0xE3B288 },
	{ 0xCEE9, 0xE3B289 },
	{ 0xCEF1, 0xE3B28A },
	{ 0xCEF5, 0xE3B28B },
	{ 0xCF41, 0xE3B28C },
	{ 0xCF45, 0xE3B28D },
	{ 0xCF49, 0xE3B28E },
	{ 0xCF51, 0xE3B28F },
	{ 0xCF55, 0xE3B290 },
	{ 0xCF57, 0xE3B291 },
	{ 0xCF61, 0xE3B292 },
	{ 0xCF65, 0xE3B293 },
	{ 0xCF69, 0xE3B294 },
	{ 0xCF71, 0xE3B295 },
	{ 0xCF73, 0xE3B296 },
	{ 0xCF75, 0xE3B297 },
	{ 0xCFA1, 0xE3B298 },
	{ 0xCFA2, 0xE3B299 },
	{ 0xCFA5, 0xE3B29A },
	{ 0xCFA9, 0xE3B29B },
	{ 0xCFB1, 0xE3B29C },
	{ 0xCFB3, 0xE3B29D },
	{ 0xCFB5, 0xE3B29E },
	{ 0xCFB7, 0xE3B29F },
	{ 0xD061, 0xE3B2A0 },
	{ 0xD062, 0xE3B2A1 },
	{ 0xD065, 0xE3B2A2 },
	{ 0xD069, 0xE3B2A3 },
	{ 0xD06E, 0xE3B2A4 },
	{ 0xD071, 0xE3B2A5 },
	{ 0xD073, 0xE3B2A6 },
	{ 0xD075, 0xE3B2A7 },
	{ 0xD077, 0xE3B2A8 },
	{ 0xD081, 0xE3B2A9 },
	{ 0xD082, 0xE3B2AA },
	{ 0xD085, 0xE3B2AB },
	{ 0xD089, 0xE3B2AC },
	{ 0xD091, 0xE3B2AD },
	{ 0xD093, 0xE3B2AE },
	{ 0xD095, 0xE3B2AF },
	{ 0xD096, 0xE3B2B0 },
	{ 0xD097, 0xE3B2B1 },
	{ 0xD0A1, 0xE3B2B2 },
	{ 0xD0B7, 0xE3B2B3 },
	{ 0xD0E1, 0xE3B2B4 },
	{ 0xD0E2, 0xE3B2B5 },
	{ 0xD0E5, 0xE3B2B6 },
	{ 0xD0E9, 0xE3B2B7 },
	{ 0xD0EB, 0xE3B2B8 },
	{ 0xD0F1, 0xE3B2B9 },
	{ 0xD0F3, 0xE3B2BA },
	{ 0xD0F5, 0xE3B2BB },
	{ 0xD0F7, 0xE3B2BC },
	{ 0xD141, 0xE3B2BD },
	{ 0xD142, 0xE3B2BE },
	{ 0xD145, 0xE3B2BF },
	{ 0xD149, 0xE3B380 },
	{ 0xD151, 0xE3B381 },
	{ 0xD153, 0xE3B382 },
	{ 0xD155, 0xE3B383 },
	{ 0xD157, 0xE3B384 },
	{ 0xD161, 0xE3B385 },
	{ 0xD162, 0xE3B386 },
	{ 0xD165, 0xE3B387 },
	{ 0xD169, 0xE3B388 },
	{ 0xD171, 0xE3B389 },
	{ 0xD173, 0xE3B38A },
	{ 0xD175, 0xE3B38B },
	{ 0xD176, 0xE3B38C },
	{ 0xD177, 0xE3B38D },
	{ 0xD181, 0xE3B38E },
	{ 0xD185, 0xE3B38F },
	{ 0xD189, 0xE3B390 },
	{ 0xD193, 0xE3B391 },
	{ 0xD1A1, 0xE3B392 },
	{ 0xD1A2, 0xE3B393 },
	{ 0xD1A5, 0xE3B394 },
	{ 0xD1A9, 0xE3B395 },
	{ 0xD1AE, 0xE3B396 },
	{ 0xD1B1, 0xE3B397 },
	{ 0xD1B3, 0xE3B398 },
	{ 0xD1B5, 0xE3B399 },
	{ 0xD1B7, 0xE3B39A },
	{ 0xD1BB, 0xE3B39B },
	{ 0xD1C1, 0xE3B39C },
	{ 0xD1C2, 0xE3B39D },
	{ 0xD1C5, 0xE3B39E },
	{ 0xD1C9, 0xE3B39F },
	{ 0xD1D5, 0xE3B3A0 },
	{ 0xD1D7, 0xE3B3A1 },
	{ 0xD1E1, 0xE3B3A2 },
	{ 0xD1E2, 0xE3B3A3 },
	{ 0xD1E5, 0xE3B3A4 },
	{ 0xD1F5, 0xE3B3A5 },
	{ 0xD1F7, 0xE3B3A6 },
	{ 0xD241, 0xE3B3A7 },
	{ 0xD242, 0xE3B3A8 },
	{ 0xD245, 0xE3B3A9 },
	{ 0xD249, 0xE3B3AA },
	{ 0xD253, 0xE3B3AB },
	{ 0xD255, 0xE3B3AC },
	{ 0xD257, 0xE3B3AD },
	{ 0xD261, 0xE3B3AE },
	{ 0xD265, 0xE3B3AF },
	{ 0xD269, 0xE3B3B0 },
	{ 0xD273, 0xE3B3B1 },
	{ 0xD275, 0xE3B3B2 },
	{ 0xD281, 0xE3B3B3 },
	{ 0xD282, 0xE3B3B4 },
	{ 0xD285, 0xE3B3B5 },
	{ 0xD289, 0xE3B3B6 },
	{ 0xD28E, 0xE3B3B7 },
	{ 0xD291, 0xE3B3B8 },
	{ 0xD295, 0xE3B3B9 },
	{ 0xD297, 0xE3B3BA },
	{ 0xD2A1, 0xE3B3BB },
	{ 0xD2A5, 0xE3B3BC },
	{ 0xD2A9, 0xE3B3BD },
	{ 0xD2B1, 0xE3B3BE },
	{ 0xD2B7, 0xE3B3BF },
	{ 0xD2C1, 0xE3B480 },
	{ 0xD2C2, 0xE3B481 },
	{ 0xD2C5, 0xE3B482 },
	{ 0xD2C9, 0xE3B483 },
	{ 0xD2D7, 0xE3B484 },
	{ 0xD2E1, 0xE3B485 },
	{ 0xD2E2, 0xE3B486 },
	{ 0xD2E5, 0xE3B487 },
	{ 0xD2E9, 0xE3B488 },
	{ 0xD2F1, 0xE3B489 },
	{ 0xD2F3, 0xE3B48A },
	{ 0xD2F5, 0xE3B48B },
	{ 0xD2F7, 0xE3B48C },
	{ 0xD341, 0xE3B48D },
	{ 0xD342, 0xE3B48E },
	{ 0xD345, 0xE3B48F },
	{ 0xD349, 0xE3B490 },
	{ 0xD351, 0xE3B491 },
	{ 0xD355, 0xE3B492 },
	{ 0xD357, 0xE3B493 },
	{ 0xD361, 0xE3B494 },
	{ 0xD362, 0xE3B495 },
	{ 0xD365, 0xE3B496 },
	{ 0xD367, 0xE3B497 },
	{ 0xD368, 0xE3B498 },
	{ 0xD369, 0xE3B499 },
	{ 0xD36A, 0xE3B49A },
	{ 0xD371, 0xE3B49B },
	{ 0xD373, 0xE3B49C },
	{ 0xD375, 0xE3B49D },
	{ 0xD377, 0xE3B49E },
	{ 0xD37B, 0xE3B49F },
	{ 0xD381, 0xE3B4A0 },
	{ 0xD385, 0xE3B4A1 },
	{ 0xD389, 0xE3B4A2 },
	{ 0xD391, 0xE3B4A3 },
	{ 0xD393, 0xE3B4A4 },
	{ 0xD397, 0xE3B4A5 },
	{ 0xD3A1, 0xE3B4A6 },
	{ 0xD3A2, 0xE3B4A7 },
	{ 0xD3A5, 0xE3B4A8 },
	{ 0xD3A9, 0xE3B4A9 },
	{ 0xD3B1, 0xE3B4AA },
	{ 0xD3B3, 0xE3B4AB },
	{ 0xD3B5, 0xE3B4AC },
	{ 0xD3B7, 0xE3B4AD },
	{ 0xF179, 0xE4B880 },
	{ 0xF2CB, 0xE4B881 },
	{ 0xF662, 0xE4B883 },
	{ 0xE742, 0xE4B887 },
	{ 0xF1DB, 0xE4B888 },
	{ 0xEAB2, 0xE4B889 },
	{ 0xEABE, 0xE4B88A },
	{ 0xF7BB, 0xE4B88B },
	{ 0xE996, 0xE4B88D },
	{ 0xF5E4, 0xE4B891 },
	{ 0xF4A6, 0xE4B894 },
	{ 0xE9E0, 0xE4B895 },
	{ 0xEBA6, 0xE4B896 },
	{ 0xE29A, 0xE4B898 },
	{ 0xE940, 0xE4B899 },
	{ 0xECAA, 0xE4B89E },
	{ 0xF3E9, 0xE4B8AD },
	{ 0xE1FA, 0xE4B8B2 },
	{ 0xF93F, 0xE4B8B8 },
	{ 0xE4A1, 0xE4B8B9 },
	{ 0xF3AB, 0xE4B8BB },
	{ 0xEED1, 0xE4B982 },
	{ 0xE43C, 0xE4B983 },
	{ 0xE29B, 0xE4B985 },
	{ 0xF3FD, 0xE4B98B },
	{ 0xEA4F, 0xE4B98D },
	{ 0xF8BA, 0xE4B98E },
	{ 0xF7B9, 0xE4B98F },
	{ 0xE262, 0xE4B996 },
	{ 0xECAB, 0xE4B998 },
	{ 0xF0E0, 0xE4B999 },
	{ 0xE29C, 0xE4B99D },
	{ 0xE0F7, 0xE4B99E },
	{ 0xEDA5, 0xE4B99F },
	{ 0xE071, 0xE4B9AB },
	{ 0xE55C, 0xE4B9AD },
	{ 0xF071, 0xE4B9B3 },
	{ 0xE973, 0xE4B9B6 },
	{ 0xEAAD, 0xE4B9B7 },
	{ 0xE0EB, 0xE4B9BE },
	{ 0xE5AF, 0xE4BA82 },
	{ 0xE697, 0xE4BA86 },
	{ 0xEDF8, 0xE4BA88 },
	{ 0xEA50, 0xE4BA8B },
	{ 0xF133, 0xE4BA8C },
	{ 0xEFCD, 0xE4BA8E },
	{ 0xF037, 0xE4BA90 },
	{ 0xEFF6, 0xE4BA91 },
	{ 0xF8BB, 0xE4BA92 },
	{ 0xEEE9, 0xE4BA94 },
	{ 0xF2CC, 0xE4BA95 },
	{ 0xE376, 0xE4BA98 },
	{ 0xEA51, 0xE4BA9B },
	{ 0xED3C, 0xE4BA9E },
	{ 0xE75C, 0xE4BAA1 },
	{ 0xF7F1, 0xE4BAA2 },
	{ 0xE26F, 0xE4BAA4 },
	{ 0xF834, 0xE4BAA5 },
	{ 0xEE42, 0xE4BAA6 },
	{ 0xF89D, 0xE4BAA8 },
	{ 0xF84D, 0xE4BAAB },
	{ 0xE158, 0xE4BAAC },
	{ 0xF2CD, 0xE4BAAD },
	{ 0xE5D5, 0xE4BAAE },
	{ 0xE4A2, 0xE4BAB6 },
	{ 0xF161, 0xE4BABA },
	{ 0xED37, 0xE4BB80 },
	{ 0xF162, 0xE4BB81 },
	{ 0xF641, 0xE4BB84 },
	{ 0xE29D, 0xE4BB87 },
	{ 0xE361, 0xE4BB8A },
	{ 0xE0BF, 0xE4BB8B },
	{ 0xF1A4, 0xE4BB8D },
	{ 0xF1A8, 0xE4BB94 },
	{ 0xEA52, 0xE4BB95 },
	{ 0xF672, 0xE4BB96 },
	{ 0xF1DC, 0xE4BB97 },
	{ 0xE997, 0xE4BB98 },
	{ 0xEB49, 0xE4BB99 },
	{ 0xE55E, 0xE4BB9D },
	{ 0xF545, 0xE4BB9F },
	{ 0xE4DB, 0xE4BBA3 },
	{ 0xE645, 0xE4BBA4 },
	{ 0xF134, 0xE4BBA5 },
	{ 0xED76, 0xE4BBB0 },
	{ 0xF3EA, 0xE4BBB2 },
	{ 0xE0EC, 0xE4BBB6 },
	{ 0xE0C0, 0xE4BBB7 },
	{ 0xF194, 0xE4BBBB },
	{ 0xE37A, 0xE4BC81 },
	{ 0xF7F2, 0xE4BC89 },
	{ 0xF135, 0xE4BC8A },
	{ 0xE36F, 0xE4BC8B },
	{ 0xEEEA, 0xE4BC8D },
	{ 0xE37B, 0xE4BC8E },
	{ 0xE961, 0xE4BC8F },
	{ 0xE8E9, 0xE4BC90 },
	{ 0xF9CC, 0xE4BC91 },
	{ 0xE8D7, 0xE4BCAF },
	{ 0xE871, 0xE4BCB4 },
	{ 0xE646, 0xE4BCB6 },
	{ 0xECDF, 0xE4BCB8 },
	{ 0xEA53, 0xE4BCBA },
	{ 0xEA54, 0xE4BCBC },
	{ 0xE031, 0xE4BCBD },
	{ 0xF27C, 0xE4BD83 },
	{ 0xE4A3, 0xE4BD86 },
	{ 0xF247, 0xE4BD87 },
	{ 0xF75F, 0xE4BD88 },
	{ 0xF058, 0xE4BD8D },
	{ 0xF248, 0xE4BD8E },
	{ 0xF3AC, 0xE4BD8F },
	{ 0xF3A5, 0xE4BD90 },
	{ 0xEFCE, 0xE4BD91 },
	{ 0xF7BC, 0xE4BD95 },
	{ 0xEDF9, 0xE4BD99 },
	{ 0xF17A, 0xE4BD9A },
	{ 0xE9D6, 0xE4BD9B },
	{ 0xF1C2, 0xE4BD9C },
	{ 0xF735, 0xE4BDA9 },
	{ 0xEDBA, 0xE4BDAF },
	{ 0xE8D8, 0xE4BDB0 },
	{ 0xE032, 0xE4BDB3 },
	{ 0xE3CD, 0xE4BDB6 },
	{ 0xF27D, 0xE4BDBA },
	{ 0xF17B, 0xE4BDBE },
	{ 0xEA55, 0xE4BDBF },
	{ 0xECE0, 0xE4BE81 },
	{ 0xE059, 0xE4BE83 },
	{ 0xF479, 0xE4BE84 },
	{ 0xE5CE, 0xE4BE86 },
	{ 0xF646, 0xE4BE88 },
	{ 0xE252, 0xE4BE8A },
	{ 0xE657, 0xE4BE8B },
	{ 0xECB4, 0xE4BE8D },
	{ 0xF3AD, 0xE4BE8F },
	{ 0xF072, 0xE4BE91 },
	{ 0xE6C2, 0xE4BE96 },
	{ 0xF4A7, 0xE4BE98 },
	{ 0xE1EA, 0xE4BE9B },
	{ 0xF0EE, 0xE4BE9D },
	{ 0xE7B2, 0xE4BEAE },
	{ 0xF9A5, 0xE4BEAF },
	{ 0xF665, 0xE4BEB5 },
	{ 0xE5E2, 0xE4BEB6 },
	{ 0xF745, 0xE4BEBF },
	{ 0xE197, 0xE4BF82 },
	{ 0xF5B5, 0xE4BF83 },
	{ 0xED3D, 0xE4BF84 },
	{ 0xEEEB, 0xE4BF89 },
	{ 0xF3D5, 0xE4BF8A },
	{ 0xF34B, 0xE4BF8E },
	{ 0xEFB5, 0xE4BF91 },
	{ 0xE159, 0xE4BF93 },
	{ 0xF865, 0xE4BF94 },
	{ 0xEBD4, 0xE4BF97 },
	{ 0xE6D6, 0xE4BF9A },
	{ 0xE951, 0xE4BF9D },
	{ 0xEA56, 0xE4BF9F },
	{ 0xF891, 0xE4BFA0 },
	{ 0xECE1, 0xE4BFA1 },
	{ 0xEBF3, 0xE4BFAE },
	{ 0xE998, 0xE4BFAF },
	{ 0xE29E, 0xE4BFB1 },
	{ 0xE8C4, 0xE4BFB3 },
	{ 0xF793, 0xE4BFB5 },
	{ 0xE974, 0xE4BFB8 },
	{ 0xEDEF, 0xE4BFBA },
	{ 0xE941, 0xE58082 },
	{ 0xE5D6, 0xE58086 },
	{ 0xF4DA, 0xE58089 },
	{ 0xE0C1, 0xE5808B },
	{ 0xE8C3, 0xE5808D },
	{ 0xE7FA, 0xE58091 },
	{ 0xE4EE, 0xE58092 },
	{ 0xF848, 0xE58096 },
	{ 0xF9A6, 0xE58099 },
	{ 0xF0EF, 0xE5809A },
	{ 0xF536, 0xE5809C },
	{ 0xE15A, 0xE5809E },
	{ 0xF4A8, 0xE5809F },
	{ 0xF4DB, 0xE580A1 },
	{ 0xE8A7, 0xE580A3 },
	{ 0xF647, 0xE580A4 },
	{ 0xE2E6, 0xE580A6 },
	{ 0xF394, 0xE580A7 },
	{ 0xE0DA, 0xE580A8 },
	{ 0xEED2, 0xE580AA },
	{ 0xE6C3, 0xE580AB },
	{ 0xF692, 0xE580AC },
	{ 0xEF6E, 0xE580AD },
	{ 0xEDA6, 0xE580BB },
	{ 0xEDE7, 0xE58183 },
	{ 0xE033, 0xE58187 },
	{ 0xE137, 0xE58188 },
	{ 0xF059, 0xE58189 },
	{ 0xF746, 0xE5818F },
	{ 0xF835, 0xE58195 },
	{ 0xF3AE, 0xE5819A },
	{ 0xF2CE, 0xE5819C },
	{ 0xE0ED, 0xE581A5 },
	{ 0xF640, 0xE581B4 },
	{ 0xF2CF, 0xE581B5 },
	{ 0xEFCF, 0xE581B6 },
	{ 0xF6DE, 0xE581B8 },
	{ 0xE263, 0xE58280 },
	{ 0xE999, 0xE58285 },
	{ 0xE8A8, 0xE5828D },
	{ 0xE0F8, 0xE58291 },
	{ 0xEAA1, 0xE58298 },
	{ 0xE9E1, 0xE58299 },
	{ 0xF5CA, 0xE582AC },
	{ 0xEFB6, 0xE582AD },
	{ 0xEEEC, 0xE582B2 },
	{ 0xF27E, 0xE582B3 },
	{ 0xF4F0, 0xE582B5 },
	{ 0xEABF, 0xE582B7 },
	{ 0xE15B, 0xE582BE },
	{ 0xE351, 0xE58385 },
	{ 0xF562, 0xE58389 },
	{ 0xEB4A, 0xE5838A },
	{ 0xEAC0, 0xE5838F },
	{ 0xE270, 0xE58391 },
	{ 0xE962, 0xE58395 },
	{ 0xF9EA, 0xE58396 },
	{ 0xE698, 0xE5839A },
	{ 0xF05A, 0xE5839E },
	{ 0xEF79, 0xE583A5 },
	{ 0xECAC, 0xE583A7 },
	{ 0xF4D0, 0xE583AD },
	{ 0xE034, 0xE583B9 },
	{ 0xE8F8, 0xE583BB },
	{ 0xEA57, 0xE583BF },
	{ 0xF0F0, 0xE58480 },
	{ 0xF3D6, 0xE58481 },
	{ 0xEDE2, 0xE58484 },
	{ 0xE15C, 0xE58486 },
	{ 0xE0FB, 0xE58489 },
	{ 0xF073, 0xE58492 },
	{ 0xEAC1, 0xE5849F },
	{ 0xE67D, 0xE584A1 },
	{ 0xEFD0, 0xE584AA },
	{ 0xF249, 0xE584B2 },
	{ 0xE5E3, 0xE584B7 },
	{ 0xE3D3, 0xE584BA },
	{ 0xEDF0, 0xE584BC },
	{ 0xEF44, 0xE58580 },
	{ 0xF0C3, 0xE58581 },
	{ 0xF03A, 0xE58583 },
	{ 0xF89E, 0xE58584 },
	{ 0xF5F6, 0xE58585 },
	{ 0xF34C, 0xE58586 },
	{ 0xF9D4, 0xE58587 },
	{ 0xEB4B, 0xE58588 },
	{ 0xE253, 0xE58589 },
	{ 0xE34A, 0xE5858B },
	{ 0xF6BA, 0xE5858C },
	{ 0xE795, 0xE5858D },
	{ 0xF6CD, 0xE5858E },
	{ 0xED3E, 0xE58592 },
	{ 0xE56F, 0xE5859C },
	{ 0xE377, 0xE585A2 },
	{ 0xF19F, 0xE585A5 },
	{ 0xE43E, 0xE585A7 },
	{ 0xF291, 0xE585A8 },
	{ 0xE5D7, 0xE585A9 },
	{ 0xF074, 0xE585AA },
	{ 0xF732, 0xE585AB },
	{ 0xE1EB, 0xE585AC },
	{ 0xE6BF, 0xE585AD },
	{ 0xF8B1, 0xE585AE },
	{ 0xE1EC, 0xE585B1 },
	{ 0xE942, 0xE585B5 },
	{ 0xE37C, 0xE585B6 },
	{ 0xE29F, 0xE585B7 },
	{ 0xF292, 0xE585B8 },
	{ 0xE152, 0xE585BC },
	{ 0xE37D, 0xE58680 },
	{ 0xEDF7, 0xE58686 },
	{ 0xF4FC, 0xE5868A },
	{ 0xF232, 0xE5868D },
	{ 0xE7B3, 0xE58692 },
	{ 0xE796, 0xE58695 },
	{ 0xEFB7, 0xE58697 },
	{ 0xE23E, 0xE586A0 },
	{ 0xE7A2, 0xE586A5 },
	{ 0xE793, 0xE586AA },
	{ 0xE55F, 0xE586AC },
	{ 0xEDA7, 0xE586B6 },
	{ 0xE5D2, 0xE586B7 },
	{ 0xE639, 0xE586BD },
	{ 0xF532, 0xE58784 },
	{ 0xF3D7, 0xE58786 },
	{ 0xE5D8, 0xE58789 },
	{ 0xF34D, 0xE5878B },
	{ 0xE6D0, 0xE5878C },
	{ 0xE560, 0xE5878D },
	{ 0xE6CF, 0xE5879C },
	{ 0xF0EA, 0xE5879D },
	{ 0xF9EB, 0xE5879E },
	{ 0xE8ED, 0xE587A1 },
	{ 0xF955, 0xE587B0 },
	{ 0xE0C2, 0xE587B1 },
	{ 0xF9D5, 0xE587B6 },
	{ 0xF558, 0xE587B8 },
	{ 0xEF7A, 0xE587B9 },
	{ 0xF5F3, 0xE587BA },
	{ 0xF7DE, 0xE587BD },
	{ 0xE4EF, 0xE58880 },
	{ 0xF163, 0xE58883 },
	{ 0xE9C2, 0xE58886 },
	{ 0xF2B7, 0xE58887 },
	{ 0xEED4, 0xE58888 },
	{ 0xE05A, 0xE5888A },
	{ 0xE7FB, 0xE5888E },
	{ 0xF89F, 0xE58891 },
	{ 0xE63A, 0xE58897 },
	{ 0xF59A, 0xE5889D },
	{ 0xF6F7, 0xE588A4 },
	{ 0xE93C, 0xE588A5 },
	{ 0xE6D7, 0xE588A9 },
	{ 0xEAA2, 0xE588AA },
	{ 0xE24E, 0xE588AE },
	{ 0xE4F0, 0xE588B0 },
	{ 0xF334, 0xE588B6 },
	{ 0xEBEC, 0xE588B7 },
	{ 0xE2E7, 0xE588B8 },
	{ 0xF4CB, 0xE588B9 },
	{ 0xF1A9, 0xE588BA },
	{ 0xE04E, 0xE588BB },
	{ 0xF591, 0xE58983 },
	{ 0xF65E, 0xE58987 },
	{ 0xEA9D, 0xE5898A },
	{ 0xE34B, 0xE5898B },
	{ 0xE5B7, 0xE5898C },
	{ 0xF293, 0xE5898D },
	{ 0xF538, 0xE58994 },
	{ 0xE99A, 0xE58996 },
	{ 0xE0A7, 0xE5899B },
	{ 0xE85E, 0xE5899D },
	{ 0xEB76, 0xE589A1 },
	{ 0xF1A5, 0xE589A9 },
	{ 0xF294, 0xE589AA },
	{ 0xE99B, 0xE589AF },
	{ 0xF7DC, 0xE589B2 },
	{ 0xF4DC, 0xE589B5 },
	{ 0xF794, 0xE589BD },
	{ 0xF59B, 0xE589BF },
	{ 0xF993, 0xE58A83 },
	{ 0xE34C, 0xE58A87 },
	{ 0xE8F9, 0xE58A88 },
	{ 0xE6B1, 0xE58A89 },
	{ 0xE0FC, 0xE58A8D },
	{ 0xF335, 0xE58A91 },
	{ 0xE0FD, 0xE58A92 },
	{ 0xE5F4, 0xE58A9B },
	{ 0xE1ED, 0xE58A9F },
	{ 0xE035, 0xE58AA0 },
	{ 0xE63B, 0xE58AA3 },
	{ 0xE352, 0xE58AA4 },
	{ 0xF34E, 0xE58AA9 },
	{ 0xE44D, 0xE58AAA },
	{ 0xE134, 0xE58AAB },
	{ 0xF846, 0xE58ABE },
	{ 0xE15D, 0xE58B81 },
	{ 0xE89C, 0xE58B83 },
	{ 0xF65F, 0xE58B85 },
	{ 0xEFB8, 0xE58B87 },
	{ 0xE797, 0xE58B89 },
	{ 0xE15E, 0xE58B8D },
	{ 0xE6CD, 0xE58B92 },
	{ 0xE561, 0xE58B95 },
	{ 0xEFED, 0xE58B96 },
	{ 0xE07B, 0xE58B98 },
	{ 0xE7E2, 0xE58B99 },
	{ 0xF9B2, 0xE58B9B },
	{ 0xECAD, 0xE58B9D },
	{ 0xE65C, 0xE58B9E },
	{ 0xE7B4, 0xE58B9F },
	{ 0xEBA7, 0xE58BA2 },
	{ 0xF263, 0xE58BA3 },
	{ 0xE353, 0xE58BA4 },
	{ 0xF9B3, 0xE58BB3 },
	{ 0xE5E4, 0xE58BB5 },
	{ 0xE2E8, 0xE58BB8 },
	{ 0xF1C3, 0xE58BBA },
	{ 0xE342, 0xE58BBB },
	{ 0xE2A0, 0xE58BBE },
	{ 0xE838, 0xE58BBF },
	{ 0xF760, 0xE58C85 },
	{ 0xF9D6, 0xE58C88 },
	{ 0xF761, 0xE58C8D },
	{ 0xF762, 0xE58C8F },
	{ 0xE963, 0xE58C90 },
	{ 0xE9E2, 0xE58C95 },
	{ 0xF8F9, 0xE58C96 },
	{ 0xE9C1, 0xE58C97 },
	{ 0xECB5, 0xE58C99 },
	{ 0xF1DD, 0xE58CA0 },
	{ 0xE254, 0xE58CA1 },
	{ 0xE0A1, 0xE58CA3 },
	{ 0xE9E3, 0xE58CAA },
	{ 0xF96D, 0xE58CAF },
	{ 0xF7AF, 0xE58CB9 },
	{ 0xE49D, 0xE58CBF },
	{ 0xE2A1, 0xE58D80 },
	{ 0xED38, 0xE58D81 },
	{ 0xF546, 0xE58D83 },
	{ 0xF1A0, 0xE58D84 },
	{ 0xECAE, 0xE58D87 },
	{ 0xEEED, 0xE58D88 },
	{ 0xF9C1, 0xE58D89 },
	{ 0xE872, 0xE58D8A },
	{ 0xE743, 0xE58D8D },
	{ 0xE9E4, 0xE58D91 },
	{ 0xF391, 0xE58D92 },
	{ 0xF693, 0xE58D93 },
	{ 0xF892, 0xE58D94 },
	{ 0xE3F5, 0xE58D97 },
	{ 0xE85F, 0xE58D9A },
	{ 0xE964, 0xE58D9C },
	{ 0xE936, 0xE58D9E },
	{ 0xF2BF, 0xE58DA0 },
	{ 0xE25F, 0xE58DA6 },
	{ 0xEB69, 0xE58DA8 },
	{ 0xE7D6, 0xE58DAF },
	{ 0xF164, 0xE58DB0 },
	{ 0xF05B, 0xE58DB1 },
	{ 0xE04F, 0xE58DB4 },
	{ 0xE5B0, 0xE58DB5 },
	{ 0xE2E9, 0xE58DB7 },
	{ 0xF3ED, 0xE58DBD },
	{ 0xE15F, 0xE58DBF },
	{ 0xED9A, 0xE58E84 },
	{ 0xED7D, 0xE58E93 },
	{ 0xE6D8, 0xE58E98 },
	{ 0xF9A7, 0xE58E9A },
	{ 0xF03B, 0xE58E9F },
	{ 0xF642, 0xE58EA0 },
	{ 0xE2F0, 0xE58EA5 },
	{ 0xF7BD, 0xE58EA6 },
	{ 0xEE96, 0xE58EAD },
	{ 0xE0DB, 0xE58EBB },
	{ 0xF4D1, 0xE58F83 },
	{ 0xEFD1, 0xE58F88 },
	{ 0xF4A9, 0xE58F89 },
	{ 0xE370, 0xE58F8A },
	{ 0xEFD2, 0xE58F8B },
	{ 0xE873, 0xE58F8D },
	{ 0xEC62, 0xE58F94 },
	{ 0xF632, 0xE58F96 },
	{ 0xEBF4, 0xE58F97 },
	{ 0xE874, 0xE58F9B },
	{ 0xEED5, 0xE58FA1 },
	{ 0xF5BF, 0xE58FA2 },
	{ 0xE2A2, 0xE58FA3 },
	{ 0xE1AF, 0xE58FA4 },
	{ 0xE2A3, 0xE58FA5 },
	{ 0xE1B0, 0xE58FA9 },
	{ 0xF3FE, 0xE58FAA },
	{ 0xE333, 0xE58FAB },
	{ 0xEBAF, 0xE58FAC },
	{ 0xF733, 0xE58FAD },
	{ 0xE036, 0xE58FAF },
	{ 0xF6BB, 0xE58FB0 },
	{ 0xF47A, 0xE58FB1 },
	{ 0xEA58, 0xE58FB2 },
	{ 0xEFD3, 0xE58FB3 },
	{ 0xEA59, 0xE58FB8 },
	{ 0xF9DE, 0xE59083 },
	{ 0xE050, 0xE59084 },
	{ 0xF7EA, 0xE59088 },
	{ 0xE3CE, 0xE59089 },
	{ 0xF264, 0xE5908A },
	{ 0xE562, 0xE5908C },
	{ 0xE7A3, 0xE5908D },
	{ 0xF9A8, 0xE5908E },
	{ 0xE6D9, 0xE5908F },
	{ 0xF6CE, 0xE59090 },
	{ 0xF84E, 0xE59091 },
	{ 0xE2D6, 0xE5909B },
	{ 0xE6F0, 0xE5909D },
	{ 0xF0E1, 0xE5909F },
	{ 0xF755, 0xE590A0 },
	{ 0xE99C, 0xE590A6 },
	{ 0xE9C3, 0xE590A9 },
	{ 0xF7DF, 0xE590AB },
	{ 0xEEEF, 0xE590B3 },
	{ 0xF9E5, 0xE590B8 },
	{ 0xF633, 0xE590B9 },
	{ 0xE7FC, 0xE590BB },
	{ 0xF9A9, 0xE590BC },
	{ 0xEEEE, 0xE590BE },
	{ 0xE5E5, 0xE59182 },
	{ 0xF2D0, 0xE59188 },
	{ 0xE1B1, 0xE5918A },
	{ 0xF6A2, 0xE59191 },
	{ 0xF3B2, 0xE591A8 },
	{ 0xF3B1, 0xE591AA },
	{ 0xE1B2, 0xE591B1 },
	{ 0xE83B, 0xE591B3 },
	{ 0xE037, 0xE591B5 },
	{ 0xECE2, 0xE591BB },
	{ 0xF8BC, 0xE591BC },
	{ 0xE7A4, 0xE591BD },
	{ 0xF24A, 0xE59280 },
	{ 0xF763, 0xE59286 },
	{ 0xF8FA, 0xE5928C },
	{ 0xE2A4, 0xE5928E },
	{ 0xE99D, 0xE59290 },
	{ 0xF673, 0xE592A4 },
	{ 0xF1AA, 0xE592A8 },
	{ 0xF431, 0xE592AB },
	{ 0xE271, 0xE592AC },
	{ 0xF836, 0xE592B3 },
	{ 0xF7E0, 0xE592B8 },
	{ 0xF166, 0xE592BD },
	{ 0xED7E, 0xE59380 },
	{ 0xF7A1, 0xE59381 },
	{ 0xF8EF, 0xE59384 },
	{ 0xF7EB, 0xE59388 },
	{ 0xF233, 0xE59389 },
	{ 0xF03C, 0xE593A1 },
	{ 0xE038, 0xE593A5 },
	{ 0xF59C, 0xE593A8 },
	{ 0xE1D6, 0xE593AD },
	{ 0xF998, 0xE593AE },
	{ 0xF559, 0xE593B2 },
	{ 0xF764, 0xE593BA },
	{ 0xF736, 0xE59484 },
	{ 0xEA5A, 0xE59486 },
	{ 0xF456, 0xE59487 },
	{ 0xE6DA, 0xE5948E },
	{ 0xE4D0, 0xE59490 },
	{ 0xE755, 0xE5949C },
	{ 0xF076, 0xE594AF },
	{ 0xF4DD, 0xE594B1 },
	{ 0xED6A, 0xE594B5 },
	{ 0xF674, 0xE594BE },
	{ 0xF694, 0xE59584 },
	{ 0xEAC2, 0xE59586 },
	{ 0xE7FD, 0xE5958F },
	{ 0xE198, 0xE59593 },
	{ 0xE4BA, 0xE59596 },
	{ 0xED3F, 0xE5959E },
	{ 0xF7E1, 0xE595A3 },
	{ 0xF336, 0xE595BC },
	{ 0xE0D3, 0xE59680 },
	{ 0xEB4C, 0xE59684 },
	{ 0xF55A, 0xE59686 },
	{ 0xE59C, 0xE59687 },
	{ 0xF9AA, 0xE59689 },
	{ 0xF7E2, 0xE5968A },
	{ 0xF547, 0xE59698 },
	{ 0xF9C2, 0xE59699 },
	{ 0xF940, 0xE5969A },
	{ 0xF9EC, 0xE5969C },
	{ 0xE072, 0xE5969D },
	{ 0xF9BD, 0xE596A7 },
	{ 0xF077, 0xE596A9 },
	{ 0xEAC3, 0xE596AA },
	{ 0xE3D2, 0xE596AB },
	{ 0xE272, 0xE596AC },
	{ 0xE4A4, 0xE596AE },
	{ 0xF9AB, 0xE59785 },
	{ 0xEAE0, 0xE59787 },
	{ 0xF457, 0xE59794 },
	{ 0xEEF0, 0xE5979A },
	{ 0xE37E, 0xE5979C },
	{ 0xF4AA, 0xE5979F },
	{ 0xEA5B, 0xE597A3 },
	{ 0xF648, 0xE597A4 },
	{ 0xEBF5, 0xE597BD },
	{ 0xF3B3, 0xE597BE },
	{ 0xF6A3, 0xE59886 },
	{ 0xE039, 0xE59889 },
	{ 0xE2A5, 0xE59894 },
	{ 0xEAC4, 0xE59897 },
	{ 0xEBB0, 0xE598AF },
	{ 0xF34F, 0xE598B2 },
	{ 0xF634, 0xE598B4 },
	{ 0xECB6, 0xE598B6 },
	{ 0xF856, 0xE59993 },
	{ 0xE391, 0xE599A8 },
	{ 0xF9ED, 0xE599AB },
	{ 0xE9C4, 0xE599B4 },
	{ 0xF999, 0xE59A86 },
	{ 0xEE4F, 0xE59AA5 },
	{ 0xEA3D, 0xE59AAC },
	{ 0xF84F, 0xE59AAE },
	{ 0xEDF1, 0xE59AB4 },
	{ 0xF1C4, 0xE59ABC },
	{ 0xE435, 0xE59B8A },
	{ 0xF9EE, 0xE59B8D },
	{ 0xF5B6, 0xE59B91 },
	{ 0xEBF6, 0xE59B9A },
	{ 0xEA5C, 0xE59B9B },
	{ 0xF96E, 0xE59B9E },
	{ 0xF167, 0xE59BA0 },
	{ 0xE1DD, 0xE59BB0 },
	{ 0xE647, 0xE59BB9 },
	{ 0xE1B3, 0xE59BBA },
	{ 0xF765, 0xE59C83 },
	{ 0xEDD8, 0xE59C84 },
	{ 0xE2EA, 0xE59C88 },
	{ 0xE2D0, 0xE59C8B },
	{ 0xF05C, 0xE59C8D },
	{ 0xF03E, 0xE59C92 },
	{ 0xF03D, 0xE59C93 },
	{ 0xE4F1, 0xE59C96 },
	{ 0xE4A5, 0xE59C98 },
	{ 0xF6CF, 0xE59C9F },
	{ 0xF234, 0xE59CA8 },
	{ 0xE334, 0xE59CAD },
	{ 0xF432, 0xE59CB0 },
	{ 0xE392, 0xE59CBB },
	{ 0xF433, 0xE59D80 },
	{ 0xF6F8, 0xE59D82 },
	{ 0xE343, 0xE59D87 },
	{ 0xE8A9, 0xE59D8A },
	{ 0xE4BB, 0xE59D8D },
	{ 0xE07C, 0xE59D8E },
	{ 0xF3A6, 0xE59D90 },
	{ 0xE0D5, 0xE59D91 },
	{ 0xF6E7, 0xE59DA1 },
	{ 0xE1DE, 0xE59DA4 },
	{ 0xF6A4, 0xE59DA6 },
	{ 0xF750, 0xE59DAA },
	{ 0xE4DD, 0xE59DAE },
	{ 0xE160, 0xE59DB0 },
	{ 0xE2A6, 0xE59DB5 },
	{ 0xF695, 0xE59DBC },
	{ 0xEBF7, 0xE59E82 },
	{ 0xE4DC, 0xE59E88 },
	{ 0xF8A0, 0xE59E8B },
	{ 0xF837, 0xE59E93 },
	{ 0xF0D9, 0xE59EA0 },
	{ 0xE2A7, 0xE59EA2 },
	{ 0xF03F, 0xE59EA3 },
	{ 0xED91, 0xE59F83 },
	{ 0xEFB9, 0xE59F87 },
	{ 0xF3D8, 0xE59F88 },
	{ 0xE768, 0xE59F8B },
	{ 0xEB94, 0xE59F8E },
	{ 0xEE44, 0xE59F9F },
	{ 0xE99E, 0xE59FA0 },
	{ 0xF4F1, 0xE59FB0 },
	{ 0xECD0, 0xE59FB4 },
	{ 0xF49D, 0xE59FB7 },
	{ 0xE8C6, 0xE59FB9 },
	{ 0xE393, 0xE59FBA },
	{ 0xE394, 0xE59FBC },
	{ 0xE2DC, 0xE5A080 },
	{ 0xE4D1, 0xE5A082 },
	{ 0xE141, 0xE5A085 },
	{ 0xF6D8, 0xE5A086 },
	{ 0xE0A8, 0xE5A088 },
	{ 0xF0BC, 0xE5A089 },
	{ 0xED4E, 0xE5A08A },
	{ 0xF56C, 0xE5A09E },
	{ 0xE952, 0xE5A0A1 },
	{ 0xF337, 0xE5A0A4 },
	{ 0xEE50, 0xE5A0A7 },
	{ 0xE07D, 0xE5A0AA },
	{ 0xEF7B, 0xE5A0AF },
	{ 0xEDE8, 0xE5A0B0 },
	{ 0xE953, 0xE5A0B1 },
	{ 0xF1DE, 0xE5A0B4 },
	{ 0xE4F2, 0xE5A0B5 },
	{ 0xE199, 0xE5A0BA },
	{ 0xE264, 0xE5A18A },
	{ 0xEEAB, 0xE5A18B },
	{ 0xE0C3, 0xE5A18F },
	{ 0xEBB1, 0xE5A191 },
	{ 0xF6B2, 0xE5A194 },
	{ 0xE4F3, 0xE5A197 },
	{ 0xE4D2, 0xE5A198 },
	{ 0xF5C0, 0xE5A19A },
	{ 0xEADD, 0xE5A19E },
	{ 0xF295, 0xE5A1A1 },
	{ 0xEEF1, 0xE5A1A2 },
	{ 0xF9B4, 0xE5A1A4 },
	{ 0xF458, 0xE5A1B5 },
	{ 0xF4D2, 0xE5A1B9 },
	{ 0xF296, 0xE5A1BC },
	{ 0xEC63, 0xE5A1BE },
	{ 0xE161, 0xE5A283 },
	{ 0xEAEA, 0xE5A285 },
	{ 0xEFBA, 0xE5A289 },
	{ 0xE7D7, 0xE5A293 },
	{ 0xF5CD, 0xE5A29C },
	{ 0xF3F2, 0xE5A29E },
	{ 0xF857, 0xE5A29F },
	{ 0xE7F8, 0xE5A2A8 },
	{ 0xE552, 0xE5A2A9 },
	{ 0xF675, 0xE5A2AE },
	{ 0xE9C5, 0xE5A2B3 },
	{ 0xEEF2, 0xE5A2BA },
	{ 0xF1DF, 0xE5A2BB },
	{ 0xE05B, 0xE5A2BE },
	{ 0xE8FA, 0xE5A381 },
	{ 0xEF45, 0xE5A385 },
	{ 0xE4A6, 0xE5A387 },
	{ 0xF9B5, 0xE5A38E },
	{ 0xF7C9, 0xE5A391 },
	{ 0xED72, 0xE5A393 },
	{ 0xF8BD, 0xE5A395 },
	{ 0xE6A4, 0xE5A398 },
	{ 0xE255, 0xE5A399 },
	{ 0xE265, 0xE5A39E },
	{ 0xE676, 0xE5A39F },
	{ 0xEDBD, 0xE5A3A4 },
	{ 0xEA5D, 0xE5A3AB },
	{ 0xF195, 0xE5A3AC },
	{ 0xF1E0, 0xE5A3AF },
	{ 0xF17C, 0xE5A3B9 },
	{ 0xF8BE, 0xE5A3BA },
	{ 0xEAEB, 0xE5A3BB },
	{ 0xEBF8, 0xE5A3BD },
	{ 0xF7BE, 0xE5A48F },
	{ 0xE395, 0xE5A494 },
	{ 0xEB3A, 0xE5A495 },
	{ 0xEF72, 0xE5A496 },
	{ 0xEC64, 0xE5A499 },
	{ 0xE49F, 0xE5A49A },
	{ 0xEDA8, 0xE5A49C },
	{ 0xE7D3, 0xE5A4A2 },
	{ 0xE4DE, 0xE5A4A7 },
	{ 0xF548, 0xE5A4A9 },
	{ 0xF6BC, 0xE5A4AA },
	{ 0xE99F, 0xE5A4AB },
	{ 0xEF7C, 0xE5A4AD },
	{ 0xED77, 0xE5A4AE },
	{ 0xECF7, 0xE5A4B1 },
	{ 0xF138, 0xE5A4B7 },
	{ 0xF893, 0xE5A4BE },
	{ 0xEDF2, 0xE5A584 },
	{ 0xE396, 0xE5A587 },
	{ 0xE43F, 0xE5A588 },
	{ 0xE975, 0xE5A589 },
	{ 0xE335, 0xE5A58E },
	{ 0xF3B4, 0xE5A58F },
	{ 0xF941, 0xE5A590 },
	{ 0xE19A, 0xE5A591 },
	{ 0xE9C6, 0xE5A594 },
	{ 0xF861, 0xE5A595 },
	{ 0xF6DF, 0xE5A597 },
	{ 0xF838, 0xE5A59A },
	{ 0xF297, 0xE5A5A0 },
	{ 0xEA5E, 0xE5A5A2 },
	{ 0xEEF3, 0xE5A5A7 },
	{ 0xF6AC, 0xE5A5AA },
	{ 0xF0C4, 0xE5A5AB },
	{ 0xF1E1, 0xE5A5AC },
	{ 0xEB3B, 0xE5A5AD },
	{ 0xE9C7, 0xE5A5AE },
	{ 0xE443, 0xE5A5B3 },
	{ 0xE44F, 0xE5A5B4 },
	{ 0xE05C, 0xE5A5B8 },
	{ 0xF8BF, 0xE5A5BD },
	{ 0xEDFD, 0xE5A682 },
	{ 0xE9E5, 0xE5A683 },
	{ 0xE75D, 0xE5A684 },
	{ 0xF196, 0xE5A68A },
	{ 0xE397, 0xE5A693 },
	{ 0xEF7D, 0xE5A696 },
	{ 0xE362, 0xE5A697 },
	{ 0xE7D8, 0xE5A699 },
	{ 0xF676, 0xE5A6A5 },
	{ 0xE8AA, 0xE5A6A8 },
	{ 0xF6E0, 0xE5A6AC },
	{ 0xE769, 0xE5A6B9 },
	{ 0xF533, 0xE5A6BB },
	{ 0xF56D, 0xE5A6BE },
	{ 0xF2D1, 0xE5A783 },
	{ 0xE7B5, 0xE5A786 },
	{ 0xF1AB, 0xE5A789 },
	{ 0xECB7, 0xE5A78B },
	{ 0xF24B, 0xE5A790 },
	{ 0xE1B4, 0xE5A791 },
	{ 0xEB95, 0xE5A793 },
	{ 0xF05D, 0xE5A794 },
	{ 0xF197, 0xE5A799 },
	{ 0xEF7E, 0xE5A79A },
	{ 0xE0A9, 0xE5A79C },
	{ 0xF3AF, 0xE5A79D },
	{ 0xE05D, 0xE5A7A6 },
	{ 0xF139, 0xE5A7A8 },
	{ 0xF47B, 0xE5A7AA },
	{ 0xF9EF, 0xE5A7AC },
	{ 0xF7F3, 0xE5A7AE },
	{ 0xEE51, 0xE5A7B8 },
	{ 0xF168, 0xE5A7BB },
	{ 0xF1AC, 0xE5A7BF },
	{ 0xF05E, 0xE5A881 },
	{ 0xEF6F, 0xE5A883 },
	{ 0xEA5F, 0xE5A891 },
	{ 0xE436, 0xE5A898 },
	{ 0xEEF4, 0xE5A89B },
	{ 0xE3D6, 0xE5A89C },
	{ 0xEE52, 0xE5A89F },
	{ 0xECE3, 0xE5A8A0 },
	{ 0xED40, 0xE5A8A5 },
	{ 0xE744, 0xE5A8A9 },
	{ 0xF635, 0xE5A8B6 },
	{ 0xF4DE, 0xE5A8BC },
	{ 0xE6A5, 0xE5A981 },
	{ 0xF6E8, 0xE5A986 },
	{ 0xEF56, 0xE5A989 },
	{ 0xF8E6, 0xE5A99A },
	{ 0xE9E6, 0xE5A9A2 },
	{ 0xE9A0, 0xE5A9A6 },
	{ 0xE76A, 0xE5AA92 },
	{ 0xE83C, 0xE5AA9A },
	{ 0xF040, 0xE5AA9B },
	{ 0xECB8, 0xE5AAA4 },
	{ 0xE03A, 0xE5AB81 },
	{ 0xEBF9, 0xE5AB82 },
	{ 0xF041, 0xE5AB84 },
	{ 0xF47C, 0xE5AB89 },
	{ 0xF87E, 0xE5AB8C },
	{ 0xF265, 0xE5ABA1 },
	{ 0xF7F4, 0xE5ABA6 },
	{ 0xE47C, 0xE5ABA9 },
	{ 0xF8FB, 0xE5AC85 },
	{ 0xF9F0, 0xE5AC89 },
	{ 0xEB4D, 0xE5AC8B },
	{ 0xE273, 0xE5AC8C },
	{ 0xF756, 0xE5AC96 },
	{ 0xEA3E, 0xE5ACAA },
	{ 0xEAC5, 0xE5AD80 },
	{ 0xEDBE, 0xE5AD83 },
	{ 0xF1AD, 0xE5AD90 },
	{ 0xF87A, 0xE5AD91 },
	{ 0xE1EE, 0xE5AD94 },
	{ 0xF1A6, 0xE5AD95 },
	{ 0xF1AE, 0xE5AD97 },
	{ 0xF37D, 0xE5AD98 },
	{ 0xE9A1, 0xE5AD9A },
	{ 0xF1AF, 0xE5AD9C },
	{ 0xF99A, 0xE5AD9D },
	{ 0xE77B, 0xE5AD9F },
	{ 0xE19B, 0xE5ADA3 },
	{ 0xE1B5, 0xE5ADA4 },
	{ 0xF839, 0xE5ADA9 },
	{ 0xEBDD, 0xE5ADAB },
	{ 0xEC65, 0xE5ADB0 },
	{ 0xF1CF, 0xE5ADB1 },
	{ 0xE9A2, 0xE5ADB5 },
	{ 0xF7CA, 0xE5ADB8 },
	{ 0xF078, 0xE5ADBA },
	{ 0xEDED, 0xE5ADBC },
	{ 0xE4EB, 0xE5AE85 },
	{ 0xEFD4, 0xE5AE87 },
	{ 0xEBFA, 0xE5AE88 },
	{ 0xED5C, 0xE5AE89 },
	{ 0xEBE4, 0xE5AE8B },
	{ 0xEF57, 0xE5AE8C },
	{ 0xE26B, 0xE5AE8F },
	{ 0xE965, 0xE5AE93 },
	{ 0xF6B5, 0xE5AE95 },
	{ 0xF995, 0xE5AE96 },
	{ 0xF395, 0xE5AE97 },
	{ 0xE23F, 0xE5AE98 },
	{ 0xF3B5, 0xE5AE99 },
	{ 0xF2D2, 0xE5AE9A },
	{ 0xEF58, 0xE5AE9B },
	{ 0xF0F1, 0xE5AE9C },
	{ 0xE0D4, 0xE5AEA2 },
	{ 0xEB4E, 0xE5AEA3 },
	{ 0xECF8, 0xE5AEA4 },
	{ 0xF079, 0xE5AEA5 },
	{ 0xF942, 0xE5AEA6 },
	{ 0xEB96, 0xE5AEAC },
	{ 0xE2E0, 0xE5AEAE },
	{ 0xF235, 0xE5AEB0 },
	{ 0xF83A, 0xE5AEB3 },
	{ 0xEE53, 0xE5AEB4 },
	{ 0xEBB2, 0xE5AEB5 },
	{ 0xE03B, 0xE5AEB6 },
	{ 0xECE4, 0xE5AEB8 },
	{ 0xEFBB, 0xE5AEB9 },
	{ 0xEC66, 0xE5AEBF },
	{ 0xF4F2, 0xE5AF80 },
	{ 0xF266, 0xE5AF82 },
	{ 0xF042, 0xE5AF83 },
	{ 0xE398, 0xE5AF84 },
	{ 0xF169, 0xE5AF85 },
	{ 0xE85B, 0xE5AF86 },
	{ 0xE2A8, 0xE5AF87 },
	{ 0xE9A3, 0xE5AF8C },
	{ 0xE76B, 0xE5AF90 },
	{ 0xF7CE, 0xE5AF92 },
	{ 0xEFD5, 0xE5AF93 },
	{ 0xECD1, 0xE5AF94 },
	{ 0xE44C, 0xE5AF97 },
	{ 0xE73C, 0xE5AF9E },
	{ 0xF4CC, 0xE5AF9F },
	{ 0xE1FB, 0xE5AFA1 },
	{ 0xF666, 0xE5AFA2 },
	{ 0xEEF5, 0xE5AFA4 },
	{ 0xEF91, 0xE5AFA5 },
	{ 0xECF9, 0xE5AFA6 },
	{ 0xE44B, 0xE5AFA7 },
	{ 0xF4F3, 0xE5AFA8 },
	{ 0xECFB, 0xE5AFA9 },
	{ 0xEA60, 0xE5AFAB },
	{ 0xE240, 0xE5AFAC },
	{ 0xE699, 0xE5AFAE },
	{ 0xF3D9, 0xE5AFAF },
	{ 0xF5C1, 0xE5AFB5 },
	{ 0xE954, 0xE5AFB6 },
	{ 0xF5BB, 0xE5AFB8 },
	{ 0xEA61, 0xE5AFBA },
	{ 0xE976, 0xE5B081 },
	{ 0xEA62, 0xE5B084 },
	{ 0xF1E2, 0xE5B087 },
	{ 0xF298, 0xE5B088 },
	{ 0xF05F, 0xE5B089 },
	{ 0xF37E, 0xE5B08A },
	{ 0xECFC, 0xE5B08B },
	{ 0xE4DF, 0xE5B08D },
	{ 0xE4F4, 0xE5B08E },
	{ 0xEBB3, 0xE5B08F },
	{ 0xEBB4, 0xE5B091 },
	{ 0xF563, 0xE5B096 },
	{ 0xEAC6, 0xE5B099 },
	{ 0xEFD6, 0xE5B0A4 },
	{ 0xE8AB, 0xE5B0A8 },
	{ 0xF636, 0xE5B0B1 },
	{ 0xECB9, 0xE5B0B8 },
	{ 0xF0C5, 0xE5B0B9 },
	{ 0xF539, 0xE5B0BA },
	{ 0xE1B6, 0xE5B0BB },
	{ 0xE49B, 0xE5B0BC },
	{ 0xE83D, 0xE5B0BE },
	{ 0xE473, 0xE5B0BF },
	{ 0xE2D1, 0xE5B180 },
	{ 0xE0DC, 0xE5B185 },
	{ 0xE19C, 0xE5B186 },
	{ 0xE2DD, 0xE5B188 },
	{ 0xEF39, 0xE5B18B },
	{ 0xECBB, 0xE5B18D },
	{ 0xECBA, 0xE5B18E },
	{ 0xEB6A, 0xE5B191 },
	{ 0xF299, 0xE5B195 },
	{ 0xE943, 0xE5B19B },
	{ 0xE4F5, 0xE5B1A0 },
	{ 0xE6A6, 0xE5B1A2 },
	{ 0xF645, 0xE5B1A4 },
	{ 0xE6DB, 0xE5B1A5 },
	{ 0xEBD5, 0xE5B1AC },
	{ 0xE57A, 0xE5B1AF },
	{ 0xEAA3, 0xE5B1B1 },
	{ 0xF9DF, 0xE5B1B9 },
	{ 0xE399, 0xE5B290 },
	{ 0xF1D4, 0xE5B291 },
	{ 0xE0AA, 0xE5B2A1 },
	{ 0xED6B, 0xE5B2A9 },
	{ 0xEBFB, 0xE5B2AB },
	{ 0xE0A2, 0xE5B2AC },
	{ 0xE4E0, 0xE5B2B1 },
	{ 0xED4F, 0xE5B2B3 },
	{ 0xF8C0, 0xE5B2B5 },
	{ 0xE84E, 0xE5B2B7 },
	{ 0xED5D, 0xE5B2B8 },
	{ 0xE649, 0xE5B2BA },
	{ 0xF2C0, 0xE5B2BE },
	{ 0xEBFC, 0xE5B380 },
	{ 0xF649, 0xE5B399 },
	{ 0xEAC7, 0xE5B3A0 },
	{ 0xED41, 0xE5B3A8 },
	{ 0xE977, 0xE5B3AF },
	{ 0xE978, 0xE5B3B0 },
	{ 0xF866, 0xE5B3B4 },
	{ 0xE4F6, 0xE5B3B6 },
	{ 0xF3DA, 0xE5B3BB },
	{ 0xF894, 0xE5B3BD },
	{ 0xEC9F, 0xE5B487 },
	{ 0xE5CF, 0xE5B48D },
	{ 0xE39A, 0xE5B48E },
	{ 0xE1DF, 0xE5B491 },
	{ 0xF5CB, 0xE5B494 },
	{ 0xED92, 0xE5B496 },
	{ 0xE0AB, 0xE5B497 },
	{ 0xE6C4, 0xE5B499 },
	{ 0xECA0, 0xE5B4A7 },
	{ 0xE9DA, 0xE5B4A9 },
	{ 0xE83E, 0xE5B58B },
	{ 0xE07E, 0xE5B58C },
	{ 0xE5B9, 0xE5B590 },
	{ 0xECA1, 0xE5B5A9 },
	{ 0xEF73, 0xE5B5AC },
	{ 0xF4AB, 0xE5B5AF },
	{ 0xE2A9, 0xE5B687 },
	{ 0xE4F7, 0xE5B68B },
	{ 0xE593, 0xE5B69D },
	{ 0xE274, 0xE5B6A0 },
	{ 0xEF94, 0xE5B6A2 },
	{ 0xEDF5, 0xE5B6AA },
	{ 0xEEAE, 0xE5B6B8 },
	{ 0xE64A, 0xE5B6BA },
	{ 0xEAEC, 0xE5B6BC },
	{ 0xED50, 0xE5B6BD },
	{ 0xEF74, 0xE5B78D },
	{ 0xE745, 0xE5B792 },
	{ 0xED6C, 0xE5B796 },
	{ 0xF549, 0xE5B79D },
	{ 0xF3B6, 0xE5B79E },
	{ 0xEC6E, 0xE5B7A1 },
	{ 0xEBB5, 0xE5B7A2 },
	{ 0xE1EF, 0xE5B7A5 },
	{ 0xF3A7, 0xE5B7A6 },
	{ 0xE275, 0xE5B7A7 },
	{ 0xE0DD, 0xE5B7A8 },
	{ 0xE7E3, 0xE5B7AB },
	{ 0xF4AC, 0xE5B7AE },
	{ 0xE39B, 0xE5B7B1 },
	{ 0xF13B, 0xE5B7B2 },
	{ 0xEA63, 0xE5B7B3 },
	{ 0xF6E9, 0xE5B7B4 },
	{ 0xF7F5, 0xE5B7B7 },
	{ 0xEBDE, 0xE5B7BD },
	{ 0xE0EE, 0xE5B7BE },
	{ 0xECBC, 0xE5B882 },
	{ 0xF766, 0xE5B883 },
	{ 0xE8EE, 0xE5B886 },
	{ 0xF9F1, 0xE5B88C },
	{ 0xF6B6, 0xE5B891 },
	{ 0xF56E, 0xE5B896 },
	{ 0xF47D, 0xE5B899 },
	{ 0xE8D9, 0xE5B89B },
	{ 0xF338, 0xE5B89D },
	{ 0xEBFD, 0xE5B8A5 },
	{ 0xEA64, 0xE5B8AB },
	{ 0xEB3C, 0xE5B8AD },
	{ 0xF1E3, 0xE5B8B3 },
	{ 0xE4E1, 0xE5B8B6 },
	{ 0xEAC8, 0xE5B8B8 },
	{ 0xE7B6, 0xE5B8BD },
	{ 0xF9AC, 0xE5B8BF },
	{ 0xF2D3, 0xE5B980 },
	{ 0xED51, 0xE5B984 },
	{ 0xF77B, 0xE5B985 },
	{ 0xE8AC, 0xE5B987 },
	{ 0xF956, 0xE5B98C },
	{ 0xE73D, 0xE5B995 },
	{ 0xF64A, 0xE5B99F },
	{ 0xE8DF, 0xE5B9A1 },
	{ 0xE4D3, 0xE5B9A2 },
	{ 0xF757, 0xE5B9A3 },
	{ 0xE05E, 0xE5B9B2 },
	{ 0xF751, 0xE5B9B3 },
	{ 0xE444, 0xE5B9B4 },
	{ 0xE944, 0xE5B9B7 },
	{ 0xF849, 0xE5B9B8 },
	{ 0xE05F, 0xE5B9B9 },
	{ 0xF943, 0xE5B9BB },
	{ 0xF07A, 0xE5B9BC },
	{ 0xF07B, 0xE5B9BD },
	{ 0xE39C, 0xE5B9BE },
	{ 0xF1E4, 0xE5BA84 },
	{ 0xE9E7, 0xE5BA87 },
	{ 0xEAC9, 0xE5BA8A },
	{ 0xEAED, 0xE5BA8F },
	{ 0xF24C, 0xE5BA95 },
	{ 0xF2C1, 0xE5BA97 },
	{ 0xE162, 0xE5BA9A },
	{ 0xE9A4, 0xE5BA9C },
	{ 0xEACA, 0xE5BAA0 },
	{ 0xE4F8, 0xE5BAA6 },
	{ 0xF3A8, 0xE5BAA7 },
	{ 0xE1B7, 0xE5BAAB },
	{ 0xF2D4, 0xE5BAAD },
	{ 0xED6D, 0xE5BAB5 },
	{ 0xEAEE, 0xE5BAB6 },
	{ 0xE0AC, 0xE5BAB7 },
	{ 0xEFBC, 0xE5BAB8 },
	{ 0xF07C, 0xE5BABE },
	{ 0xEACB, 0xE5BB82 },
	{ 0xF7BF, 0xE5BB88 },
	{ 0xE63F, 0xE5BB89 },
	{ 0xE5C6, 0xE5BB8A },
	{ 0xE2AA, 0xE5BB90 },
	{ 0xE239, 0xE5BB93 },
	{ 0xE69A, 0xE5BB96 },
	{ 0xF3B7, 0xE5BB9A },
	{ 0xF29A, 0xE5BB9B },
	{ 0xE7D9, 0xE5BB9F },
	{ 0xF4DF, 0xE5BBA0 },
	{ 0xF758, 0xE5BBA2 },
	{ 0xE256, 0xE5BBA3 },
	{ 0xE5E6, 0xE5BBAC },
	{ 0xF576, 0xE5BBB3 },
	{ 0xEE55, 0xE5BBB6 },
	{ 0xF2D5, 0xE5BBB7 },
	{ 0xE0EF, 0xE5BBBA },
	{ 0xF96F, 0xE5BBBB },
	{ 0xE937, 0xE5BC81 },
	{ 0xE677, 0xE5BC84 },
	{ 0xF759, 0xE5BC8A },
	{ 0xECD2, 0xE5BC8F },
	{ 0xECBD, 0xE5BC91 },
	{ 0xE2E1, 0xE5BC93 },
	{ 0xF350, 0xE5BC94 },
	{ 0xF16A, 0xE5BC95 },
	{ 0xE9D7, 0xE5BC97 },
	{ 0xF8F0, 0xE5BC98 },
	{ 0xF13C, 0xE5BC9B },
	{ 0xF339, 0xE5BC9F },
	{ 0xF867, 0xE5BCA6 },
	{ 0xF8C1, 0xE5BCA7 },
	{ 0xE450, 0xE5BCA9 },
	{ 0xEDB0, 0xE5BCB1 },
	{ 0xF1E5, 0xE5BCB5 },
	{ 0xE0AD, 0xE5BCBA },
	{ 0xF7B0, 0xE5BCBC },
	{ 0xF6A5, 0xE5BD88 },
	{ 0xE0AE, 0xE5BD8A },
	{ 0xE83F, 0xE5BD8C },
	{ 0xE746, 0xE5BD8E },
	{ 0xE4A7, 0xE5BD96 },
	{ 0xF8B2, 0xE5BD97 },
	{ 0xF9C4, 0xE5BD99 },
	{ 0xF13D, 0xE5BD9B },
	{ 0xF8A1, 0xE5BDA2 },
	{ 0xEDE9, 0xE5BDA6 },
	{ 0xEFEE, 0xE5BDA7 },
	{ 0xF4F4, 0xE5BDA9 },
	{ 0xF795, 0xE5BDAA },
	{ 0xF351, 0xE5BDAB },
	{ 0xEA3F, 0xE5BDAC },
	{ 0xF740, 0xE5BDAD },
	{ 0xF4E0, 0xE5BDB0 },
	{ 0xEEAF, 0xE5BDB1 },
	{ 0xE8AD, 0xE5BDB7 },
	{ 0xEE45, 0xE5BDB9 },
	{ 0xF7A8, 0xE5BDBC },
	{ 0xE9D8, 0xE5BDBF },
	{ 0xEF69, 0xE5BE80 },
	{ 0xF2D6, 0xE5BE81 },
	{ 0xE4E2, 0xE5BE85 },
	{ 0xEC6F, 0xE5BE87 },
	{ 0xF970, 0xE5BE8A },
	{ 0xE6C8, 0xE5BE8B },
	{ 0xF9AD, 0xE5BE8C },
	{ 0xEAEF, 0xE5BE90 },
	{ 0xE163, 0xE5BE91 },
	{ 0xE4F9, 0xE5BE92 },
	{ 0xE592, 0xE5BE97 },
	{ 0xE8C7, 0xE5BE98 },
	{ 0xEA65, 0xE5BE99 },
	{ 0xF396, 0xE5BE9E },
	{ 0xE5D0, 0xE5BEA0 },
	{ 0xEDD9, 0xE5BEA1 },
	{ 0xF957, 0xE5BEA8 },
	{ 0xE966, 0xE5BEA9 },
	{ 0xEC70, 0xE5BEAA },
	{ 0xE840, 0xE5BEAE },
	{ 0xF4A3, 0xE5BEB5 },
	{ 0xE4EC, 0xE5BEB7 },
	{ 0xF55B, 0xE5BEB9 },
	{ 0xF9C5, 0xE5BEBD },
	{ 0xECFD, 0xE5BF83 },
	{ 0xF7B1, 0xE5BF85 },
	{ 0xE39D, 0xE5BF8C },
	{ 0xF16B, 0xE5BF8D },
	{ 0xF5BC, 0xE5BF96 },
	{ 0xF434, 0xE5BF97 },
	{ 0xE75E, 0xE5BF98 },
	{ 0xE75F, 0xE5BF99 },
	{ 0xF5F7, 0xE5BFA0 },
	{ 0xF671, 0xE5BFAB },
	{ 0xE447, 0xE5BFB5 },
	{ 0xF8EC, 0xE5BFBD },
	{ 0xE9C8, 0xE5BFBF },
	{ 0xED78, 0xE6808F },
	{ 0xE451, 0xE68092 },
	{ 0xF767, 0xE68096 },
	{ 0xE64B, 0xE6809C },
	{ 0xEA66, 0xE6809D },
	{ 0xF6BD, 0xE680A0 },
	{ 0xF13E, 0xE680A1 },
	{ 0xE371, 0xE680A5 },
	{ 0xEB97, 0xE680A7 },
	{ 0xF043, 0xE680A8 },
	{ 0xE266, 0xE680AA },
	{ 0xE135, 0xE680AF },
	{ 0xF198, 0xE68181 },
	{ 0xEC71, 0xE68182 },
	{ 0xECBE, 0xE68183 },
	{ 0xF958, 0xE6818D },
	{ 0xE1F0, 0xE68190 },
	{ 0xF7F6, 0xE68192 },
	{ 0xEAF0, 0xE68195 },
	{ 0xEDBF, 0xE68199 },
	{ 0xE24F, 0xE6819D },
	{ 0xF971, 0xE681A2 },
	{ 0xF1B0, 0xE681A3 },
	{ 0xF9D1, 0xE681A4 },
	{ 0xF64B, 0xE681A5 },
	{ 0xF7CF, 0xE681A8 },
	{ 0xF0DA, 0xE681A9 },
	{ 0xE051, 0xE681AA },
	{ 0xE448, 0xE681AC },
	{ 0xE1F1, 0xE681AD },
	{ 0xECD3, 0xE681AF },
	{ 0xF9E6, 0xE681B0 },
	{ 0xEE7D, 0xE68285 },
	{ 0xECFA, 0xE68289 },
	{ 0xF33A, 0xE6828C },
	{ 0xF7D0, 0xE6828D },
	{ 0xF972, 0xE68294 },
	{ 0xF737, 0xE68296 },
	{ 0xEBE5, 0xE6829A },
	{ 0xF29B, 0xE6829B },
	{ 0xEEF6, 0xE6829F },
	{ 0xF07D, 0xE682A0 },
	{ 0xF944, 0xE682A3 },
	{ 0xF5C2, 0xE682A4 },
	{ 0xE6DC, 0xE682A7 },
	{ 0xF397, 0xE682B0 },
	{ 0xE9E8, 0xE682B2 },
	{ 0xE4ED, 0xE682B3 },
	{ 0xF5FC, 0xE682B4 },
	{ 0xE84F, 0xE682B6 },
	{ 0xE19D, 0xE682B8 },
	{ 0xE4FA, 0xE682BC },
	{ 0xF534, 0xE682BD },
	{ 0xF2D7, 0xE68385 },
	{ 0xE553, 0xE68387 },
	{ 0xF8E3, 0xE68391 },
	{ 0xF8ED, 0xE6839A },
	{ 0xEB3D, 0xE6839C },
	{ 0xF07E, 0xE6839F },
	{ 0xF8B3, 0xE683A0 },
	{ 0xED52, 0xE683A1 },
	{ 0xF677, 0xE683B0 },
	{ 0xE46D, 0xE683B1 },
	{ 0xEACC, 0xE683B3 },
	{ 0xF959, 0xE683B6 },
	{ 0xEDA9, 0xE683B9 },
	{ 0xEB98, 0xE683BA },
	{ 0xF643, 0xE683BB },
	{ 0xEBFE, 0xE68481 },
	{ 0xE0F0, 0xE68486 },
	{ 0xF091, 0xE68488 },
	{ 0xF092, 0xE68489 },
	{ 0xE850, 0xE6848D },
	{ 0xF744, 0xE6848E },
	{ 0xF0F2, 0xE6848F },
	{ 0xED53, 0xE68495 },
	{ 0xEFD7, 0xE6849A },
	{ 0xED93, 0xE6849B },
	{ 0xE091, 0xE6849F },
	{ 0xE267, 0xE684A7 },
	{ 0xF95A, 0xE684B0 },
	{ 0xF4E1, 0xE684B4 },
	{ 0xE0C4, 0xE684B7 },
	{ 0xECE5, 0xE684BC },
	{ 0xE0C5, 0xE684BE },
	{ 0xF044, 0xE684BF },
	{ 0xEFBD, 0xE68582 },
	{ 0xE6C9, 0xE68584 },
	{ 0xF0DB, 0xE68587 },
	{ 0xF1B1, 0xE68588 },
	{ 0xE153, 0xE6858A },
	{ 0xF6BE, 0xE6858B },
	{ 0xF95B, 0xE6858C },
	{ 0xF796, 0xE68593 },
	{ 0xE7B7, 0xE68595 },
	{ 0xF4D3, 0xE68598 },
	{ 0xF4D4, 0xE68599 },
	{ 0xF6E4, 0xE6859D },
	{ 0xF6D1, 0xE6859F },
	{ 0xE747, 0xE685A2 },
	{ 0xE241, 0xE685A3 },
	{ 0xE052, 0xE685A4 },
	{ 0xF8B4, 0xE685A7 },
	{ 0xE0C6, 0xE685A8 },
	{ 0xF398, 0xE685AB },
	{ 0xE5E7, 0xE685AE },
	{ 0xF060, 0xE685B0 },
	{ 0xE164, 0xE685B6 },
	{ 0xE0AF, 0xE685B7 },
	{ 0xF53A, 0xE685BD },
	{ 0xEFAF, 0xE685BE },
	{ 0xF5C3, 0xE68681 },
	{ 0xEFD8, 0xE68682 },
	{ 0xE9E9, 0xE6868A },
	{ 0xF3F3, 0xE6868E },
	{ 0xE5FB, 0xE68690 },
	{ 0xEA4B, 0xE68691 },
	{ 0xF59D, 0xE68694 },
	{ 0xF9F3, 0xE68698 },
	{ 0xF9F2, 0xE68699 },
	{ 0xF6A6, 0xE6869A },
	{ 0xE9C9, 0xE686A4 },
	{ 0xE563, 0xE686A7 },
	{ 0xE138, 0xE686A9 },
	{ 0xE851, 0xE686AB },
	{ 0xE165, 0xE686AC },
	{ 0xE7E4, 0xE686AE },
	{ 0xF85A, 0xE686B2 },
	{ 0xEDE3, 0xE686B6 },
	{ 0xE4BC, 0xE686BA },
	{ 0xE092, 0xE686BE },
	{ 0xE354, 0xE68783 },
	{ 0xE060, 0xE68787 },
	{ 0xF83B, 0xE68788 },
	{ 0xF0EB, 0xE68789 },
	{ 0xEEF8, 0xE6878A },
	{ 0xE7E5, 0xE6878B },
	{ 0xE3D7, 0xE687A6 },
	{ 0xF4A4, 0xE687B2 },
	{ 0xE59D, 0xE687B6 },
	{ 0xF973, 0xE687B7 },
	{ 0xF868, 0xE687B8 },
	{ 0xF4D5, 0xE687BA },
	{ 0xE2AB, 0xE687BC },
	{ 0xF0F3, 0xE687BF },
	{ 0xE5FC, 0xE68880 },
	{ 0xE4D4, 0xE68887 },
	{ 0xE1FC, 0xE68888 },
	{ 0xE7E6, 0xE6888A },
	{ 0xEC9B, 0xE6888C },
	{ 0xEC31, 0xE6888D },
	{ 0xF0D4, 0xE6888E },
	{ 0xEB99, 0xE68890 },
	{ 0xED42, 0xE68891 },
	{ 0xE19E, 0xE68892 },
	{ 0xF8E4, 0xE68896 },
	{ 0xF53B, 0xE6889A },
	{ 0xE34D, 0xE6889F },
	{ 0xE093, 0xE688A1 },
	{ 0xF2B8, 0xE688AA },
	{ 0xE6C0, 0xE688AE },
	{ 0xF29C, 0xE688B0 },
	{ 0xF9F4, 0xE688B1 },
	{ 0xE4E3, 0xE688B4 },
	{ 0xF8C2, 0xE688B6 },
	{ 0xE5E8, 0xE688BE },
	{ 0xE8AE, 0xE688BF },
	{ 0xEBB6, 0xE68980 },
	{ 0xF747, 0xE68981 },
	{ 0xEB4F, 0xE68987 },
	{ 0xF8C3, 0xE68988 },
	{ 0xE9EA, 0xE68989 },
	{ 0xEC32, 0xE6898B },
	{ 0xF236, 0xE6898D },
	{ 0xF678, 0xE68993 },
	{ 0xF697, 0xE68998 },
	{ 0xE9CA, 0xE689AE },
	{ 0xE372, 0xE689B1 },
	{ 0xE9A6, 0xE689B6 },
	{ 0xE9EB, 0xE689B9 },
	{ 0xED9B, 0xE689BC },
	{ 0xECAF, 0xE689BF },
	{ 0xE39E, 0xE68A80 },
	{ 0xF59E, 0xE68A84 },
	{ 0xE14C, 0xE68A89 },
	{ 0xF6EA, 0xE68A8A },
	{ 0xEDE4, 0xE68A91 },
	{ 0xEAF1, 0xE68A92 },
	{ 0xF6E1, 0xE68A95 },
	{ 0xF7F7, 0xE68A97 },
	{ 0xF2B9, 0xE68A98 },
	{ 0xF768, 0xE68A9B },
	{ 0xF7A9, 0xE68AAB },
	{ 0xF769, 0xE68AB1 },
	{ 0xF24D, 0xE68AB5 },
	{ 0xE756, 0xE68AB9 },
	{ 0xED73, 0xE68ABC },
	{ 0xF5CE, 0xE68ABD },
	{ 0xE9D9, 0xE68B82 },
	{ 0xE7E7, 0xE68B87 },
	{ 0xE449, 0xE68B88 },
	{ 0xE5C3, 0xE68B89 },
	{ 0xE875, 0xE68B8C },
	{ 0xE860, 0xE68B8D },
	{ 0xE3D9, 0xE68B8F },
	{ 0xE268, 0xE68B90 },
	{ 0xE0DE, 0xE68B92 },
	{ 0xF53C, 0xE68B93 },
	{ 0xE89D, 0xE68B94 },
	{ 0xF679, 0xE68B96 },
	{ 0xEF95, 0xE68B97 },
	{ 0xE2AC, 0xE68B98 },
	{ 0xF392, 0xE68B99 },
	{ 0xF59F, 0xE68B9B },
	{ 0xE8C8, 0xE68B9C },
	{ 0xE250, 0xE68BAC },
	{ 0xECD4, 0xE68BAD },
	{ 0xE3CF, 0xE68BAE },
	{ 0xF3F5, 0xE68BAF },
	{ 0xE1F2, 0xE68BB1 },
	{ 0xE2EB, 0xE68BB3 },
	{ 0xE1B8, 0xE68BB7 },
	{ 0xECA6, 0xE68BBE },
	{ 0xE3DA, 0xE68BBF },
	{ 0xF435, 0xE68C81 },
	{ 0xF436, 0xE68C87 },
	{ 0xED5E, 0xE68C89 },
	{ 0xE4FB, 0xE68C91 },
	{ 0xF3A9, 0xE68CAB },
	{ 0xF459, 0xE68CAF },
	{ 0xF2D8, 0xE68CBA },
	{ 0xEE59, 0xE68CBB },
	{ 0xE748, 0xE68CBD },
	{ 0xF895, 0xE68CBE },
	{ 0xF4B5, 0xE68D89 },
	{ 0xF734, 0xE68D8C },
	{ 0xE3F3, 0xE68D8F },
	{ 0xEE58, 0xE68D90 },
	{ 0xF76A, 0xE68D95 },
	{ 0xE979, 0xE68DA7 },
	{ 0xEA67, 0xE68DA8 },
	{ 0xE0DF, 0xE68DAE },
	{ 0xE2EC, 0xE68DB2 },
	{ 0xF56F, 0xE68DB7 },
	{ 0xE3F4, 0xE68DBA },
	{ 0xE44A, 0xE68DBB },
	{ 0xEAF2, 0xE68DBF },
	{ 0xEBB7, 0xE68E83 },
	{ 0xEC33, 0xE68E88 },
	{ 0xE4FC, 0xE68E89 },
	{ 0xF1E6, 0xE68E8C },
	{ 0xE8C9, 0xE68E92 },
	{ 0xED9C, 0xE68E96 },
	{ 0xE2DE, 0xE68E98 },
	{ 0xE260, 0xE68E9B },
	{ 0xE5D3, 0xE68EA0 },
	{ 0xF4F5, 0xE68EA1 },
	{ 0xF6AE, 0xE68EA2 },
	{ 0xF2C8, 0xE68EA5 },
	{ 0xE1F3, 0xE68EA7 },
	{ 0xF5CF, 0xE68EA8 },
	{ 0xEDF3, 0xE68EA9 },
	{ 0xF352, 0xE68EAA },
	{ 0xE061, 0xE68F80 },
	{ 0xF093, 0xE68F84 },
	{ 0xE336, 0xE68F86 },
	{ 0xE7DA, 0xE68F8F },
	{ 0xF33B, 0xE68F90 },
	{ 0xF0E7, 0xE68F96 },
	{ 0xEDC0, 0xE68F9A },
	{ 0xF945, 0xE68F9B },
	{ 0xED54, 0xE68FA1 },
	{ 0xE139, 0xE68FAD },
	{ 0xF9C6, 0xE68FAE },
	{ 0xF045, 0xE68FB4 },
	{ 0xEDAA, 0xE68FB6 },
	{ 0xEABA, 0xE68FB7 },
	{ 0xEBDF, 0xE6908D },
	{ 0xE861, 0xE6908F },
	{ 0xEBB8, 0xE69094 },
	{ 0xEF96, 0xE69096 },
	{ 0xE4FD, 0xE69097 },
	{ 0xEC34, 0xE6909C },
	{ 0xF45A, 0xE690A2 },
	{ 0xE876, 0xE690AC },
	{ 0xF6B3, 0xE690AD },
	{ 0xF9CD, 0xE690BA },
	{ 0xF4B6, 0xE690BE },
	{ 0xF267, 0xE69198 },
	{ 0xF5C4, 0xE691A0 },
	{ 0xE734, 0xE691A9 },
	{ 0xF437, 0xE691AF },
	{ 0xE7B8, 0xE691B8 },
	{ 0xE7B9, 0xE691B9 },
	{ 0xF2C9, 0xE691BA },
	{ 0xE65E, 0xE69288 },
	{ 0xF6CB, 0xE69291 },
	{ 0xEAAE, 0xE69292 },
	{ 0xEF97, 0xE69293 },
	{ 0xE445, 0xE6929A },
	{ 0xE4D5, 0xE6929E },
	{ 0xF55C, 0xE692A4 },
	{ 0xE89E, 0xE692A5 },
	{ 0xE7E8, 0xE692AB },
	{ 0xF6EB, 0xE692AD },
	{ 0xF5C9, 0xE692AE },
	{ 0xF4BC, 0xE692B0 },
	{ 0xE862, 0xE692B2 },
	{ 0xE4B5, 0xE692BB },
	{ 0xEF46, 0xE69381 },
	{ 0xE65F, 0xE69384 },
	{ 0xF54A, 0xE69385 },
	{ 0xF6C9, 0xE69387 },
	{ 0xE13A, 0xE6938A },
	{ 0xF353, 0xE6938D },
	{ 0xE166, 0xE6938E },
	{ 0xE363, 0xE69392 },
	{ 0xE4BD, 0xE69394 },
	{ 0xE8FB, 0xE69398 },
	{ 0xE0E0, 0xE6939A },
	{ 0xE4E4, 0xE693A1 },
	{ 0xF699, 0xE693A2 },
	{ 0xE5BA, 0xE693A5 },
	{ 0xF4CD, 0xE693A6 },
	{ 0xE0E1, 0xE693A7 },
	{ 0xF0F4, 0xE693AC },
	{ 0xF53D, 0xE693B2 },
	{ 0xF93A, 0xE693B4 },
	{ 0xF6EC, 0xE693BA },
	{ 0xEF98, 0xE693BE },
	{ 0xE877, 0xE69480 },
	{ 0xF6CC, 0xE69484 },
	{ 0xEDC1, 0xE69498 },
	{ 0xEB7E, 0xE6949D },
	{ 0xE5FD, 0xE694A3 },
	{ 0xE276, 0xE694AA },
	{ 0xF93B, 0xE694AB },
	{ 0xE5BB, 0xE694AC },
	{ 0xF438, 0xE694AF },
	{ 0xEC35, 0xE694B6 },
	{ 0xE1B9, 0xE694B7 },
	{ 0xF094, 0xE694B8 },
	{ 0xE0C7, 0xE694B9 },
	{ 0xE1F4, 0xE694BB },
	{ 0xE8AF, 0xE694BE },
	{ 0xF2D9, 0xE694BF },
	{ 0xE1BA, 0xE69585 },
	{ 0xF99B, 0xE69588 },
	{ 0xEAF3, 0xE6958D },
	{ 0xE277, 0xE6958E },
	{ 0xE852, 0xE6958F },
	{ 0xE2AD, 0xE69591 },
	{ 0xEEF9, 0xE69596 },
	{ 0xF738, 0xE69597 },
	{ 0xF4E2, 0xE6959E },
	{ 0xE094, 0xE695A2 },
	{ 0xEAA4, 0xE695A3 },
	{ 0xE554, 0xE695A6 },
	{ 0xE167, 0xE695AC },
	{ 0xEDC2, 0xE695AD },
	{ 0xE1BB, 0xE695B2 },
	{ 0xF2DA, 0xE695B4 },
	{ 0xF268, 0xE695B5 },
	{ 0xE9A7, 0xE695B7 },
	{ 0xEC36, 0xE695B8 },
	{ 0xEB50, 0xE695BE },
	{ 0xE640, 0xE69682 },
	{ 0xF75A, 0xE69683 },
	{ 0xF99C, 0xE69685 },
	{ 0xE7FE, 0xE69687 },
	{ 0xEA40, 0xE6968C },
	{ 0xE9EC, 0xE69690 },
	{ 0xE878, 0xE69691 },
	{ 0xE570, 0xE69697 },
	{ 0xE69B, 0xE69699 },
	{ 0xE1D7, 0xE6969B },
	{ 0xEA68, 0xE6969C },
	{ 0xF49A, 0xE6969F },
	{ 0xED66, 0xE696A1 },
	{ 0xE355, 0xE696A4 },
	{ 0xF53E, 0xE696A5 },
	{ 0xE9A8, 0xE696A7 },
	{ 0xF1C5, 0xE696AB },
	{ 0xF4D6, 0xE696AC },
	{ 0xEA69, 0xE696AF },
	{ 0xECE6, 0xE696B0 },
	{ 0xE4A8, 0xE696B7 },
	{ 0xE8B0, 0xE696B9 },
	{ 0xEDDA, 0xE696BC },
	{ 0xECBF, 0xE696BD },
	{ 0xE8B1, 0xE69781 },
	{ 0xE5E9, 0xE69785 },
	{ 0xEB51, 0xE6978B },
	{ 0xF2DB, 0xE6978C },
	{ 0xF379, 0xE6978F },
	{ 0xE6B2, 0xE69792 },
	{ 0xE39F, 0xE69797 },
	{ 0xE7E9, 0xE697A0 },
	{ 0xE3A0, 0xE697A3 },
	{ 0xF17D, 0xE697A5 },
	{ 0xE4A9, 0xE697A6 },
	{ 0xF439, 0xE697A8 },
	{ 0xF354, 0xE697A9 },
	{ 0xEC72, 0xE697AC },
	{ 0xEFEF, 0xE697AD },
	{ 0xF7D1, 0xE697B1 },
	{ 0xEFD9, 0xE697B4 },
	{ 0xEF6A, 0xE697BA },
	{ 0xE853, 0xE697BB },
	{ 0xE854, 0xE697BC },
	{ 0xE555, 0xE697BD },
	{ 0xEEFA, 0xE697BF },
	{ 0xE1E0, 0xE69886 },
	{ 0xECB0, 0xE69887 },
	{ 0xE8B2, 0xE69889 },
	{ 0xF8C4, 0xE6988A },
	{ 0xF4E3, 0xE6988C },
	{ 0xE7A5, 0xE6988E },
	{ 0xF8E7, 0xE6988F },
	{ 0xE9CB, 0xE69890 },
	{ 0xE364, 0xE69891 },
	{ 0xEE46, 0xE69893 },
	{ 0xEB3E, 0xE69894 },
	{ 0xF9DA, 0xE69895 },
	{ 0xE945, 0xE6989E },
	{ 0xEB9A, 0xE6989F },
	{ 0xEEB1, 0xE698A0 },
	{ 0xF5F0, 0xE698A5 },
	{ 0xE76C, 0xE698A7 },
	{ 0xF1C6, 0xE698A8 },
	{ 0xEBB9, 0xE698AD },
	{ 0xECC0, 0xE698AF },
	{ 0xF7C0, 0xE698B0 },
	{ 0xEFF0, 0xE698B1 },
	{ 0xE7DB, 0xE698B4 },
	{ 0xF4E4, 0xE698B6 },
	{ 0xE946, 0xE698BA },
	{ 0xED79, 0xE698BB },
	{ 0xF355, 0xE69981 },
	{ 0xECC1, 0xE69982 },
	{ 0xF95C, 0xE69983 },
	{ 0xF95D, 0xE69984 },
	{ 0xF45B, 0xE69989 },
	{ 0xF45C, 0xE6998B },
	{ 0xED5F, 0xE6998F },
	{ 0xF3DB, 0xE69999 },
	{ 0xF869, 0xE6999B },
	{ 0xF3B8, 0xE6999D },
	{ 0xF9F5, 0xE6999E },
	{ 0xEB9B, 0xE6999F },
	{ 0xEEFB, 0xE699A4 },
	{ 0xF947, 0xE699A5 },
	{ 0xF974, 0xE699A6 },
	{ 0xF8C5, 0xE699A7 },
	{ 0xECE7, 0xE699A8 },
	{ 0xE749, 0xE699A9 },
	{ 0xF69A, 0xE699AB },
	{ 0xE955, 0xE699AE },
	{ 0xE168, 0xE699AF },
	{ 0xEB3F, 0xE699B3 },
	{ 0xF577, 0xE699B4 },
	{ 0xF2DC, 0xE699B6 },
	{ 0xE2FC, 0xE699B7 },
	{ 0xF2DD, 0xE699B8 },
	{ 0xF43A, 0xE699BA },
	{ 0xF9BE, 0xE69A84 },
	{ 0xE03C, 0xE69A87 },
	{ 0xF9BB, 0xE69A88 },
	{ 0xF9C7, 0xE69A89 },
	{ 0xEEB2, 0xE69A8E },
	{ 0xF061, 0xE69A90 },
	{ 0xEAF4, 0xE69A91 },
	{ 0xE3EC, 0xE69A96 },
	{ 0xED6E, 0xE69A97 },
	{ 0xEDC3, 0xE69A98 },
	{ 0xE7A6, 0xE69A9D },
	{ 0xE1BC, 0xE69AA0 },
	{ 0xF4E5, 0xE69AA2 },
	{ 0xF1D5, 0xE69AAB },
	{ 0xE7BA, 0xE69AAE },
	{ 0xF1E7, 0xE69AB2 },
	{ 0xF8B5, 0xE69AB3 },
	{ 0xF77C, 0xE69AB4 },
	{ 0xEB77, 0xE69AB9 },
	{ 0xE169, 0xE69ABB },
	{ 0xE556, 0xE69ABE },
	{ 0xEEA5, 0xE69B84 },
	{ 0xE5F5, 0xE69B86 },
	{ 0xE4BE, 0xE69B87 },
	{ 0xF99D, 0xE69B89 },
	{ 0xED94, 0xE69B96 },
	{ 0xEAF5, 0xE69B99 },
	{ 0xEF9A, 0xE69B9C },
	{ 0xF77D, 0xE69B9D },
	{ 0xE257, 0xE69BA0 },
	{ 0xF9F6, 0xE69BA6 },
	{ 0xEF68, 0xE69BB0 },
	{ 0xE1D8, 0xE69BB2 },
	{ 0xEED6, 0xE69BB3 },
	{ 0xE16A, 0xE69BB4 },
	{ 0xE073, 0xE69BB7 },
	{ 0xEAF6, 0xE69BB8 },
	{ 0xF357, 0xE69BB9 },
	{ 0xF356, 0xE69BBA },
	{ 0xE74A, 0xE69BBC },
	{ 0xF3F4, 0xE69BBE },
	{ 0xF592, 0xE69BBF },
	{ 0xF5CC, 0xE69C80 },
	{ 0xF975, 0xE69C83 },
	{ 0xF055, 0xE69C88 },
	{ 0xF095, 0xE69C89 },
	{ 0xE9DB, 0xE69C8B },
	{ 0xE967, 0xE69C8D },
	{ 0xEA9F, 0xE69C94 },
	{ 0xF49B, 0xE69C95 },
	{ 0xE5C7, 0xE69C97 },
	{ 0xE760, 0xE69C9B },
	{ 0xF358, 0xE69C9D },
	{ 0xE3A1, 0xE69C9E },
	{ 0xE3A2, 0xE69C9F },
	{ 0xE7D4, 0xE69CA6 },
	{ 0xE678, 0xE69CA7 },
	{ 0xE7CA, 0xE69CA8 },
	{ 0xE841, 0xE69CAA },
	{ 0xE757, 0xE69CAB },
	{ 0xE972, 0xE69CAC },
	{ 0xF4CE, 0xE69CAD },
	{ 0xF5F4, 0xE69CAE },
	{ 0xF3B9, 0xE69CB1 },
	{ 0xE863, 0xE69CB4 },
	{ 0xF67A, 0xE69CB6 },
	{ 0xE2F5, 0xE69CBA },
	{ 0xF9AE, 0xE69CBD },
	{ 0xE062, 0xE69D86 },
	{ 0xEAB4, 0xE69D89 },
	{ 0xE6DD, 0xE69D8E },
	{ 0xF84A, 0xE69D8F },
	{ 0xF237, 0xE69D90 },
	{ 0xF5BD, 0xE69D91 },
	{ 0xF797, 0xE69D93 },
	{ 0xF1E8, 0xE69D96 },
	{ 0xE571, 0xE69D9C },
	{ 0xE3A3, 0xE69D9E },
	{ 0xEBD6, 0xE69D9F },
	{ 0xF7F8, 0xE69DAD },
	{ 0xE8CA, 0xE69DAF },
	{ 0xE0F9, 0xE69DB0 },
	{ 0xE564, 0xE69DB1 },
	{ 0xE7DC, 0xE69DB3 },
	{ 0xF24E, 0xE69DB5 },
	{ 0xF6ED, 0xE69DB7 },
	{ 0xE47E, 0xE69DBB },
	{ 0xEBE6, 0xE69DBE },
	{ 0xF6F9, 0xE69DBF },
	{ 0xE9ED, 0xE69E87 },
	{ 0xEF6B, 0xE69E89 },
	{ 0xE8B3, 0xE69E8B },
	{ 0xE3F7, 0xE69E8F },
	{ 0xEB40, 0xE69E90 },
	{ 0xE572, 0xE69E93 },
	{ 0xF667, 0xE69E95 },
	{ 0xE6F9, 0xE69E97 },
	{ 0xE76D, 0xE69E9A },
	{ 0xE1FD, 0xE69E9C },
	{ 0xF43B, 0xE69E9D },
	{ 0xE1BD, 0xE69EAF },
	{ 0xF752, 0xE69EB0 },
	{ 0xF43C, 0xE69EB3 },
	{ 0xE03D, 0xE69EB6 },
	{ 0xE03E, 0xE69EB7 },
	{ 0xE2AE, 0xE69EB8 },
	{ 0xECC2, 0xE69EBE },
	{ 0xE947, 0xE69F84 },
	{ 0xE8DA, 0xE69F8F },
	{ 0xE7BB, 0xE69F90 },
	{ 0xE095, 0xE69F91 },
	{ 0xF663, 0xE69F92 },
	{ 0xEE9A, 0xE69F93 },
	{ 0xF097, 0xE69F94 },
	{ 0xF098, 0xE69F9A },
	{ 0xF69B, 0xE69F9D },
	{ 0xE2AF, 0xE69FA9 },
	{ 0xE063, 0xE69FAC },
	{ 0xE03F, 0xE69FAF },
	{ 0xE440, 0xE69FB0 },
	{ 0xF3BA, 0xE69FB1 },
	{ 0xE6B3, 0xE69FB3 },
	{ 0xECC3, 0xE69FB4 },
	{ 0xF4FD, 0xE69FB5 },
	{ 0xEA6A, 0xE69FB6 },
	{ 0xEA6B, 0xE69FBB },
	{ 0xF2DE, 0xE69FBE },
	{ 0xEC73, 0xE6A092 },
	{ 0xF29D, 0xE6A093 },
	{ 0xEAF7, 0xE6A096 },
	{ 0xE6CA, 0xE6A097 },
	{ 0xE278, 0xE6A0A1 },
	{ 0xE8DB, 0xE6A0A2 },
	{ 0xF3BB, 0xE6A0AA },
	{ 0xEFF1, 0xE6A0AF },
	{ 0xF847, 0xE6A0B8 },
	{ 0xE356, 0xE6A0B9 },
	{ 0xE13B, 0xE6A0BC },
	{ 0xF238, 0xE6A0BD },
	{ 0xE0FA, 0xE6A180 },
	{ 0xF7F9, 0xE6A181 },
	{ 0xE19F, 0xE6A182 },
	{ 0xE4FE, 0xE6A183 },
	{ 0xED60, 0xE6A188 },
	{ 0xF47E, 0xE6A18E },
	{ 0xE565, 0xE6A190 },
	{ 0xEACD, 0xE6A191 },
	{ 0xF948, 0xE6A193 },
	{ 0xE3D0, 0xE6A194 },
	{ 0xF45D, 0xE6A1AD },
	{ 0xF6D2, 0xE6A1B6 },
	{ 0xE064, 0xE6A1BF },
	{ 0xE5D9, 0xE6A281 },
	{ 0xE76E, 0xE6A285 },
	{ 0xE1D9, 0xE6A28F },
	{ 0xF239, 0xE6A293 },
	{ 0xF64C, 0xE6A294 },
	{ 0xE16B, 0xE6A297 },
	{ 0xF359, 0xE6A29D },
	{ 0xF99E, 0xE6A29F },
	{ 0xEF59, 0xE6A2A1 },
	{ 0xF5A0, 0xE6A2A2 },
	{ 0xEEFC, 0xE6A2A7 },
	{ 0xE6DE, 0xE6A2A8 },
	{ 0xEA6C, 0xE6A2AD },
	{ 0xF33C, 0xE6A2AF },
	{ 0xE1A0, 0xE6A2B0 },
	{ 0xE1E1, 0xE6A2B1 },
	{ 0xEBBA, 0xE6A2B3 },
	{ 0xE8EF, 0xE6A2B5 },
	{ 0xE842, 0xE6A2B6 },
	{ 0xE3A5, 0xE6A384 },
	{ 0xE948, 0xE6A385 },
	{ 0xE798, 0xE6A389 },
	{ 0xE3A4, 0xE6A38B },
	{ 0xE1E2, 0xE6A38D },
	{ 0xE97A, 0xE6A392 },
	{ 0xF399, 0xE6A395 },
	{ 0xF35A, 0xE6A397 },
	{ 0xE34E, 0xE6A398 },
	{ 0xE9DC, 0xE6A39A },
	{ 0xE566, 0xE6A39F },
	{ 0xE4D6, 0xE6A3A0 },
	{ 0xF1D0, 0xE6A3A7 },
	{ 0xE1A1, 0xE6A3A8 },
	{ 0xEAB5, 0xE6A3AE },
	{ 0xEAF8, 0xE6A3B2 },
	{ 0xE531, 0xE6A3B9 },
	{ 0xE242, 0xE6A3BA },
	{ 0xEF5A, 0xE6A480 },
	{ 0xF0F5, 0xE6A485 },
	{ 0xECD5, 0xE6A48D },
	{ 0xF5D0, 0xE6A48E },
	{ 0xF5A1, 0xE6A492 },
	{ 0xE7A7, 0xE6A4A7 },
	{ 0xEDAB, 0xE6A4B0 },
	{ 0xEE5B, 0xE6A4BD },
	{ 0xF5F1, 0xE6A4BF },
	{ 0xEDC5, 0xE6A58A },
	{ 0xF7A3, 0xE6A593 },
	{ 0xEB6B, 0xE6A594 },
	{ 0xF67B, 0xE6A595 },
	{ 0xE0F1, 0xE6A597 },
	{ 0xE7EA, 0xE6A599 },
	{ 0xF5A2, 0xE6A59A },
	{ 0xE6D1, 0xE6A59E },
	{ 0xE3F8, 0xE6A5A0 },
	{ 0xF09A, 0xE6A5A1 },
	{ 0xF09B, 0xE6A5A2 },
	{ 0xE843, 0xE6A5A3 },
	{ 0xF2DF, 0xE6A5A8 },
	{ 0xF3EF, 0xE6A5AB },
	{ 0xEDF6, 0xE6A5AD },
	{ 0xF24F, 0xE6A5AE },
	{ 0xEC74, 0xE6A5AF },
	{ 0xE34F, 0xE6A5B5 },
	{ 0xF83C, 0xE6A5B7 },
	{ 0xF5D1, 0xE6A5B8 },
	{ 0xEEB3, 0xE6A5B9 },
	{ 0xEFBE, 0xE6A695 },
	{ 0xF45E, 0xE6A69B },
	{ 0xE8B4, 0xE6A69C },
	{ 0xF95E, 0xE6A6A5 },
	{ 0xE9EE, 0xE6A6A7 },
	{ 0xEEB4, 0xE6A6AE },
	{ 0xE6B4, 0xE6A6B4 },
	{ 0xF6B4, 0xE6A6BB },
	{ 0xE1BE, 0xE6A781 },
	{ 0xE879, 0xE6A783 },
	{ 0xE2B0, 0xE6A78B },
	{ 0xF6D9, 0xE6A78C },
	{ 0xF4E6, 0xE6A78D },
	{ 0xE269, 0xE6A790 },
	{ 0xE23A, 0xE6A7A8 },
	{ 0xE0C8, 0xE6A7AA },
	{ 0xE337, 0xE6A7BB },
	{ 0xF35B, 0xE6A7BD },
	{ 0xE357, 0xE6A7BF },
	{ 0xED55, 0xE6A882 },
	{ 0xE8E0, 0xE6A88A },
	{ 0xE5DA, 0xE6A891 },
	{ 0xE6A7, 0xE6A893 },
	{ 0xF250, 0xE6A897 },
	{ 0xF798, 0xE6A899 },
	{ 0xF5D2, 0xE6A89E },
	{ 0xF1E9, 0xE6A89F },
	{ 0xE7BC, 0xE6A8A1 },
	{ 0xEDC6, 0xE6A8A3 },
	{ 0xF5A3, 0xE6A8B5 },
	{ 0xE864, 0xE6A8B8 },
	{ 0xEC37, 0xE6A8B9 },
	{ 0xF8FC, 0xE6A8BA },
	{ 0xF3DC, 0xE6A8BD },
	{ 0xE096, 0xE6A984 },
	{ 0xEF9C, 0xE6A988 },
	{ 0xE279, 0xE6A98B },
	{ 0xEFF8, 0xE6A992 },
	{ 0xEC75, 0xE6A993 },
	{ 0xE349, 0xE6A998 },
	{ 0xE594, 0xE6A999 },
	{ 0xE3A6, 0xE6A99F },
	{ 0xEACE, 0xE6A9A1 },
	{ 0xF996, 0xE6A9AB },
	{ 0xE4AA, 0xE6AA80 },
	{ 0xE13C, 0xE6AA84 },
	{ 0xF2E0, 0xE6AA89 },
	{ 0xEDE5, 0xE6AA8D },
	{ 0xE365, 0xE6AA8E },
	{ 0xE8FC, 0xE6AA97 },
	{ 0xF976, 0xE6AA9C },
	{ 0xE0FE, 0xE6AAA2 },
	{ 0xF1EA, 0xE6AAA3 },
	{ 0xEA41, 0xE6AAB3 },
	{ 0xF7E3, 0xE6AABB },
	{ 0xE532, 0xE6AB82 },
	{ 0xE2F6, 0xE6AB83 },
	{ 0xE660, 0xE6AB93 },
	{ 0xE5EA, 0xE6AB9A },
	{ 0xF3EE, 0xE6AB9B },
	{ 0xF85B, 0xE6ABB6 },
	{ 0xEDA1, 0xE6ABBB },
	{ 0xE5B1, 0xE6AC84 },
	{ 0xE2ED, 0xE6AC8A },
	{ 0xF1EB, 0xE6AC8C },
	{ 0xE5B2, 0xE6AC92 },
	{ 0xE5BC, 0xE6AC96 },
	{ 0xF9E2, 0xE6ACA0 },
	{ 0xF4AD, 0xE6ACA1 },
	{ 0xF9DB, 0xE6ACA3 },
	{ 0xEFB0, 0xE6ACB2 },
	{ 0xE3A7, 0xE6ACBA },
	{ 0xF9E3, 0xE6ACBD },
	{ 0xE243, 0xE6ACBE },
	{ 0xF9E4, 0xE6AD86 },
	{ 0xF85E, 0xE6AD87 },
	{ 0xE040, 0xE6AD8C },
	{ 0xF6A7, 0xE6AD8E },
	{ 0xE2B1, 0xE6AD90 },
	{ 0xEE32, 0xE6AD9F },
	{ 0xF946, 0xE6ADA1 },
	{ 0xF43D, 0xE6ADA2 },
	{ 0xF2E1, 0xE6ADA3 },
	{ 0xF4AE, 0xE6ADA4 },
	{ 0xE956, 0xE6ADA5 },
	{ 0xE7EB, 0xE6ADA6 },
	{ 0xEF70, 0xE6ADAA },
	{ 0xEBA8, 0xE6ADB2 },
	{ 0xE5F6, 0xE6ADB7 },
	{ 0xE2FD, 0xE6ADB8 },
	{ 0xEA6D, 0xE6ADBB },
	{ 0xE7D1, 0xE6ADBF },
	{ 0xED7A, 0xE6AE83 },
	{ 0xF45F, 0xE6AE84 },
	{ 0xF6BF, 0xE6AE86 },
	{ 0xEC76, 0xE6AE89 },
	{ 0xEC38, 0xE6AE8A },
	{ 0xECD6, 0xE6AE96 },
	{ 0xF1D1, 0xE6AE98 },
	{ 0xEFF9, 0xE6AE9E },
	{ 0xE641, 0xE6AEAE },
	{ 0xEA42, 0xE6AEAF },
	{ 0xEB78, 0xE6AEB2 },
	{ 0xE4AB, 0xE6AEB5 },
	{ 0xF0DC, 0xE6AEB7 },
	{ 0xEAAF, 0xE6AEBA },
	{ 0xE053, 0xE6AEBC },
	{ 0xF29E, 0xE6AEBF },
	{ 0xF9C3, 0xE6AF81 },
	{ 0xF0F6, 0xE6AF85 },
	{ 0xE2B2, 0xE6AF86 },
	{ 0xE7EC, 0xE6AF8B },
	{ 0xE7BD, 0xE6AF8D },
	{ 0xE76F, 0xE6AF8F },
	{ 0xE548, 0xE6AF92 },
	{ 0xF0BE, 0xE6AF93 },
	{ 0xE9EF, 0xE6AF94 },
	{ 0xE9F0, 0xE6AF96 },
	{ 0xE9F1, 0xE6AF97 },
	{ 0xE9F2, 0xE6AF98 },
	{ 0xE7BE, 0xE6AF9B },
	{ 0xF8C6, 0xE6AFAB },
	{ 0xE2B3, 0xE6AFAC },
	{ 0xF29F, 0xE6B088 },
	{ 0xED3B, 0xE6B08F },
	{ 0xE855, 0xE6B091 },
	{ 0xE77C, 0xE6B093 },
	{ 0xE3A8, 0xE6B0A3 },
	{ 0xEC39, 0xE6B0B4 },
	{ 0xEA4C, 0xE6B0B7 },
	{ 0xEEB5, 0xE6B0B8 },
	{ 0xE8F0, 0xE6B0BE },
	{ 0xF2E2, 0xE6B180 },
	{ 0xF3F0, 0xE6B181 },
	{ 0xE2B4, 0xE6B182 },
	{ 0xE8F1, 0xE6B18E },
	{ 0xEB41, 0xE6B190 },
	{ 0xEAA5, 0xE6B195 },
	{ 0xF7D2, 0xE6B197 },
	{ 0xEEFD, 0xE6B19A },
	{ 0xEE33, 0xE6B19D },
	{ 0xF8F1, 0xE6B19E },
	{ 0xE0B0, 0xE6B19F },
	{ 0xF43E, 0xE6B1A0 },
	{ 0xE1E7, 0xE6B1A8 },
	{ 0xEF6C, 0xE6B1AA },
	{ 0xEED7, 0xE6B1AD },
	{ 0xF6C0, 0xE6B1B0 },
	{ 0xE373, 0xE6B1B2 },
	{ 0xE831, 0xE6B1B6 },
	{ 0xE14D, 0xE6B1BA },
	{ 0xE3A9, 0xE6B1BD },
	{ 0xE9CC, 0xE6B1BE },
	{ 0xECFE, 0xE6B281 },
	{ 0xE3AA, 0xE6B282 },
	{ 0xEF3A, 0xE6B283 },
	{ 0xF046, 0xE6B285 },
	{ 0xF7FA, 0xE6B286 },
	{ 0xEE5C, 0xE6B287 },
	{ 0xF668, 0xE6B288 },
	{ 0xE557, 0xE6B28C },
	{ 0xE7CB, 0xE6B290 },
	{ 0xE7D2, 0xE6B292 },
	{ 0xE4CB, 0xE6B293 },
	{ 0xE799, 0xE6B294 },
	{ 0xE839, 0xE6B295 },
	{ 0xF5F8, 0xE6B296 },
	{ 0xEA6E, 0xE6B299 },
	{ 0xF43F, 0xE6B29A },
	{ 0xF739, 0xE6B29B },
	{ 0xE758, 0xE6B2AB },
	{ 0xF251, 0xE6B2AE },
	{ 0xF7C1, 0xE6B2B3 },
	{ 0xE9F3, 0xE6B2B8 },
	{ 0xF09C, 0xE6B2B9 },
	{ 0xF64D, 0xE6B2BB },
	{ 0xEBBB, 0xE6B2BC },
	{ 0xE1BF, 0xE6B2BD },
	{ 0xF564, 0xE6B2BE },
	{ 0xEE5D, 0xE6B2BF },
	{ 0xF95F, 0xE6B381 },
	{ 0xF8A2, 0xE6B382 },
	{ 0xEB6C, 0xE6B384 },
	{ 0xF54B, 0xE6B389 },
	{ 0xE865, 0xE6B38A },
	{ 0xF7B2, 0xE6B38C },
	{ 0xF8F2, 0xE6B393 },
	{ 0xE8F6, 0xE6B395 },
	{ 0xEA6F, 0xE6B397 },
	{ 0xE8F2, 0xE6B39B },
	{ 0xF76C, 0xE6B3A1 },
	{ 0xF6EE, 0xE6B3A2 },
	{ 0xF0E8, 0xE6B3A3 },
	{ 0xE49C, 0xE6B3A5 },
	{ 0xF3BC, 0xE6B3A8 },
	{ 0xF86A, 0xE6B3AB },
	{ 0xE87A, 0xE6B3AE },
	{ 0xE856, 0xE6B3AF },
	{ 0xF6C1, 0xE6B3B0 },
	{ 0xEEB6, 0xE6B3B3 },
	{ 0xEDC7, 0xE6B48B },
	{ 0xE63C, 0xE6B48C },
	{ 0xE957, 0xE6B491 },
	{ 0xEBA9, 0xE6B497 },
	{ 0xEC3A, 0xE6B499 },
	{ 0xE5A6, 0xE6B49B },
	{ 0xE567, 0xE6B49E },
	{ 0xF460, 0xE6B4A5 },
	{ 0xF09D, 0xE6B4A7 },
	{ 0xEB6D, 0xE6B4A9 },
	{ 0xF8F3, 0xE6B4AA },
	{ 0xF3BD, 0xE6B4B2 },
	{ 0xEC77, 0xE6B4B5 },
	{ 0xF9D7, 0xE6B4B6 },
	{ 0xE258, 0xE6B4B8 },
	{ 0xF047, 0xE6B4B9 },
	{ 0xF950, 0xE6B4BB },
	{ 0xF9E7, 0xE6B4BD },
	{ 0xF6EF, 0xE6B4BE },
	{ 0xE6B5, 0xE6B581 },
	{ 0xF2BA, 0xE6B599 },
	{ 0xF3DD, 0xE6B59A },
	{ 0xEA43, 0xE6B59C },
	{ 0xEF5B, 0xE6B5A3 },
	{ 0xF76D, 0xE6B5A6 },
	{ 0xF8C7, 0xE6B5A9 },
	{ 0xE5C8, 0xE6B5AA },
	{ 0xE6DF, 0xE6B5AC },
	{ 0xE9A9, 0xE6B5AE },
	{ 0xEFB1, 0xE6B5B4 },
	{ 0xF83D, 0xE6B5B7 },
	{ 0xF669, 0xE6B5B8 },
	{ 0xF896, 0xE6B5B9 },
	{ 0xF73A, 0xE6B5BF },
	{ 0xEE7E, 0xE6B685 },
	{ 0xE16C, 0xE6B687 },
	{ 0xEBBC, 0xE6B688 },
	{ 0xEB91, 0xE6B689 },
	{ 0xEFBF, 0xE6B68C },
	{ 0xF99F, 0xE6B68D },
	{ 0xEE5E, 0xE6B68E },
	{ 0xEBD7, 0xE6B691 },
	{ 0xEE5F, 0xE6B693 },
	{ 0xF593, 0xE6B695 },
	{ 0xED95, 0xE6B6AF },
	{ 0xED9D, 0xE6B6B2 },
	{ 0xF7E4, 0xE6B6B5 },
	{ 0xF2E3, 0xE6B780 },
	{ 0xE2EE, 0xE6B783 },
	{ 0xF64E, 0xE6B784 },
	{ 0xEB42, 0xE6B785 },
	{ 0xF9A0, 0xE6B786 },
	{ 0xE3AB, 0xE6B787 },
	{ 0xE6FA, 0xE6B78B },
	{ 0xF8C8, 0xE6B78F },
	{ 0xEC67, 0xE6B791 },
	{ 0xE533, 0xE6B798 },
	{ 0xF39A, 0xE6B799 },
	{ 0xE6A8, 0xE6B79A },
	{ 0xEBE7, 0xE6B79E },
	{ 0xE4BF, 0xE6B7A1 },
	{ 0xF2E4, 0xE6B7A8 },
	{ 0xE6C5, 0xE6B7AA },
	{ 0xF0E2, 0xE6B7AB },
	{ 0xF977, 0xE6B7AE },
	{ 0xED32, 0xE6B7B1 },
	{ 0xEC78, 0xE6B7B3 },
	{ 0xEE60, 0xE6B7B5 },
	{ 0xF8E8, 0xE6B7B7 },
	{ 0xF578, 0xE6B7B8 },
	{ 0xEDF4, 0xE6B7B9 },
	{ 0xF54C, 0xE6B7BA },
	{ 0xF565, 0xE6B7BB },
	{ 0xEAB6, 0xE6B897 },
	{ 0xF949, 0xE6B899 },
	{ 0xF252, 0xE6B89A },
	{ 0xE097, 0xE6B89B },
	{ 0xF2E5, 0xE6B89F },
	{ 0xE0E2, 0xE6B8A0 },
	{ 0xE534, 0xE6B8A1 },
	{ 0xEA70, 0xE6B8A3 },
	{ 0xE89F, 0xE6B8A4 },
	{ 0xED56, 0xE6B8A5 },
	{ 0xEF4E, 0xE6B8A6 },
	{ 0xEB6E, 0xE6B8AB },
	{ 0xF644, 0xE6B8AC },
	{ 0xF062, 0xE6B8AD },
	{ 0xF7FB, 0xE6B8AF },
	{ 0xEB52, 0xE6B8B2 },
	{ 0xE074, 0xE6B8B4 },
	{ 0xEEB7, 0xE6B8B6 },
	{ 0xF09F, 0xE6B8B8 },
	{ 0xE7DD, 0xE6B8BA },
	{ 0xE844, 0xE6B8BC },
	{ 0xF23A, 0xE6B8BD },
	{ 0xF8E9, 0xE6B8BE },
	{ 0xE8CB, 0xE6B983 },
	{ 0xE845, 0xE6B984 },
	{ 0xF3BE, 0xE6B98A },
	{ 0xE4AC, 0xE6B98D },
	{ 0xF8C9, 0xE6B996 },
	{ 0xEACF, 0xE6B998 },
	{ 0xE4C0, 0xE6B99B },
	{ 0xECD7, 0xE6B99C },
	{ 0xF2E6, 0xE6B99E },
	{ 0xF960, 0xE6B99F },
	{ 0xEFC0, 0xE6B9A7 },
	{ 0xF5D3, 0xE6B9AB },
	{ 0xF16C, 0xE6B9AE },
	{ 0xF6B7, 0xE6B9AF },
	{ 0xF048, 0xE6B9B2 },
	{ 0xE3F9, 0xE6B9B3 },
	{ 0xE958, 0xE6B9BA },
	{ 0xF049, 0xE6BA90 },
	{ 0xF3DE, 0xE6BA96 },
	{ 0xE6B6, 0xE6BA9C },
	{ 0xE2B5, 0xE6BA9D },
	{ 0xE7A8, 0xE6BA9F },
	{ 0xF17E, 0xE6BAA2 },
	{ 0xE9AA, 0xE6BAA5 },
	{ 0xE1A2, 0xE6BAAA },
	{ 0xEF3E, 0xE6BAAB },
	{ 0xEBBD, 0xE6BAAF },
	{ 0xF461, 0xE6BAB1 },
	{ 0xEFC1, 0xE6BAB6 },
	{ 0xE49E, 0xE6BABA },
	{ 0xE8B5, 0xE6BB82 },
	{ 0xF4E7, 0xE6BB84 },
	{ 0xE7A0, 0xE6BB85 },
	{ 0xF961, 0xE6BB89 },
	{ 0xF1B2, 0xE6BB8B },
	{ 0xF53F, 0xE6BB8C },
	{ 0xF8A3, 0xE6BB8E },
	{ 0xF951, 0xE6BB91 },
	{ 0xF23B, 0xE6BB93 },
	{ 0xE535, 0xE6BB94 },
	{ 0xF594, 0xE6BBAF },
	{ 0xF269, 0xE6BBB4 },
	{ 0xF8CA, 0xE6BBB8 },
	{ 0xE1E3, 0xE6BBBE },
	{ 0xE74B, 0xE6BBBF },
	{ 0xEDDB, 0xE6BC81 },
	{ 0xF799, 0xE6BC82 },
	{ 0xF664, 0xE6BC86 },
	{ 0xE6A9, 0xE6BC8F },
	{ 0xE0C9, 0xE6BC91 },
	{ 0xEE61, 0xE6BC94 },
	{ 0xF35C, 0xE6BC95 },
	{ 0xE73E, 0xE6BCA0 },
	{ 0xF7D3, 0xE6BCA2 },
	{ 0xE5FE, 0xE6BCA3 },
	{ 0xE74C, 0xE6BCAB },
	{ 0xF440, 0xE6BCAC },
	{ 0xEC3B, 0xE6BCB1 },
	{ 0xF4E8, 0xE6BCB2 },
	{ 0xF2C2, 0xE6BCB8 },
	{ 0xF1EC, 0xE6BCBF },
	{ 0xEEB8, 0xE6BD81 },
	{ 0xE8A0, 0xE6BD91 },
	{ 0xE14E, 0xE6BD94 },
	{ 0xF49E, 0xE6BD97 },
	{ 0xE87B, 0xE6BD98 },
	{ 0xEC68, 0xE6BD9A },
	{ 0xF1D6, 0xE6BD9B },
	{ 0xE661, 0xE6BD9E },
	{ 0xEB43, 0xE6BD9F },
	{ 0xF962, 0xE6BDA2 },
	{ 0xF0C8, 0xE6BDA4 },
	{ 0xE4C1, 0xE6BDAD },
	{ 0xF35D, 0xE6BDAE },
	{ 0xE2F7, 0xE6BDB0 },
	{ 0xF1D2, 0xE6BDBA },
	{ 0xE568, 0xE6BDBC },
	{ 0xE959, 0xE6BDBD },
	{ 0xE6F1, 0xE6BDBE },
	{ 0xEABB, 0xE6BE81 },
	{ 0xF4A5, 0xE6BE84 },
	{ 0xF55D, 0xE6BE88 },
	{ 0xF3BF, 0xE6BE8D },
	{ 0xF741, 0xE6BE8E },
	{ 0xEFFA, 0xE6BE90 },
	{ 0xF8CB, 0xE6BE94 },
	{ 0xE065, 0xE6BE97 },
	{ 0xF7D4, 0xE6BEA3 },
	{ 0xF6CA, 0xE6BEA4 },
	{ 0xE658, 0xE6BEA7 },
	{ 0xF978, 0xE6BEAE },
	{ 0xF4BD, 0xE6BEAF },
	{ 0xF2A0, 0xE6BEB1 },
	{ 0xEEFE, 0xE6BEB3 },
	{ 0xE4C2, 0xE6BEB9 },
	{ 0xE4B6, 0xE6BEBE },
	{ 0xE13D, 0xE6BF80 },
	{ 0xF69C, 0xE6BF81 },
	{ 0xE642, 0xE6BF82 },
	{ 0xE468, 0xE6BF83 },
	{ 0xEED8, 0xE6BF8A },
	{ 0xECA5, 0xE6BF95 },
	{ 0xEEB9, 0xE6BF9A },
	{ 0xF33D, 0xE6BF9F },
	{ 0xF8CC, 0xE6BFA0 },
	{ 0xF0A1, 0xE6BFA1 },
	{ 0xE536, 0xE6BFA4 },
	{ 0xF8CD, 0xE6BFA9 },
	{ 0xE5BD, 0xE6BFAB },
	{ 0xF3DF, 0xE6BFAC },
	{ 0xF69D, 0xE6BFAF },
	{ 0xEA44, 0xE6BFB1 },
	{ 0xE5EB, 0xE6BFBE },
	{ 0xEDC8, 0xE78081 },
	{ 0xF8A4, 0xE78085 },
	{ 0xE549, 0xE78086 },
	{ 0xEA71, 0xE78089 },
	{ 0xED33, 0xE7808B },
	{ 0xE6B7, 0xE7808F },
	{ 0xF77E, 0xE78091 },
	{ 0xEA45, 0xE78095 },
	{ 0xE662, 0xE78098 },
	{ 0xF7D5, 0xE7809A },
	{ 0xEEBA, 0xE7809B },
	{ 0xF0D5, 0xE7809C },
	{ 0xE5F7, 0xE7809D },
	{ 0xF2E7, 0xE7809E },
	{ 0xEBBE, 0xE7809F },
	{ 0xF83E, 0xE780A3 },
	{ 0xE679, 0xE780A7 },
	{ 0xE67E, 0xE780A8 },
	{ 0xEEBB, 0xE780AF },
	{ 0xF15B, 0xE780B7 },
	{ 0xE5B3, 0xE780BE },
	{ 0xE244, 0xE7818C },
	{ 0xF8A5, 0xE78190 },
	{ 0xEBEE, 0xE78191 },
	{ 0xF6A8, 0xE78198 },
	{ 0xF8CE, 0xE7819D },
	{ 0xE74D, 0xE781A3 },
	{ 0xF8FD, 0xE781AB },
	{ 0xF979, 0xE781B0 },
	{ 0xE2B6, 0xE781B8 },
	{ 0xF1C7, 0xE781BC },
	{ 0xF23C, 0xE781BD },
	{ 0xE16D, 0xE78285 },
	{ 0xF637, 0xE7828A },
	{ 0xEE9C, 0xE7828E },
	{ 0xF5A4, 0xE78292 },
	{ 0xF9DC, 0xE78298 },
	{ 0xF1B3, 0xE78299 },
	{ 0xE259, 0xE7829A },
	{ 0xF2E8, 0xE782A1 },
	{ 0xEBBF, 0xE782A4 },
	{ 0xF86B, 0xE782AB },
	{ 0xE0E3, 0xE782AC },
	{ 0xF6A9, 0xE782AD },
	{ 0xF8A6, 0xE782AF },
	{ 0xE949, 0xE782B3 },
	{ 0xF3C0, 0xE782B7 },
	{ 0xF1C8, 0xE782B8 },
	{ 0xF2C3, 0xE782B9 },
	{ 0xE63D, 0xE78388 },
	{ 0xF9CE, 0xE7838B },
	{ 0xEF31, 0xE7838F },
	{ 0xF8F4, 0xE78398 },
	{ 0xE5A7, 0xE78399 },
	{ 0xF3F6, 0xE7839D },
	{ 0xEE63, 0xE7839F },
	{ 0xE16E, 0xE783B1 },
	{ 0xF742, 0xE783B9 },
	{ 0xE97B, 0xE783BD },
	{ 0xF9B6, 0xE78484 },
	{ 0xEDEA, 0xE78489 },
	{ 0xF3E0, 0xE7848C },
	{ 0xE8CC, 0xE78499 },
	{ 0xE9CD, 0xE7849A },
	{ 0xE558, 0xE7849E },
	{ 0xE7ED, 0xE784A1 },
	{ 0xF5A5, 0xE784A6 },
	{ 0xEE9D, 0xE784B0 },
	{ 0xEE64, 0xE784B6 },
	{ 0xF9C8, 0xE78587 },
	{ 0xE631, 0xE78589 },
	{ 0xF9BF, 0xE7858A },
	{ 0xF963, 0xE7858C },
	{ 0xF2A1, 0xE7858E },
	{ 0xEEBC, 0xE78590 },
	{ 0xE3EE, 0xE78596 },
	{ 0xEE65, 0xE78599 },
	{ 0xEFF2, 0xE7859C },
	{ 0xEAB0, 0xE7859E },
	{ 0xE770, 0xE785A4 },
	{ 0xF94A, 0xE785A5 },
	{ 0xF9AF, 0xE785A6 },
	{ 0xF35E, 0xE785A7 },
	{ 0xE8E1, 0xE785A9 },
	{ 0xEDC9, 0xE785AC },
	{ 0xF1B4, 0xE785AE },
	{ 0xEB53, 0xE785BD },
	{ 0xECD8, 0xE78684 },
	{ 0xEFFB, 0xE78689 },
	{ 0xF038, 0xE7868A },
	{ 0xF9B7, 0xE7868F },
	{ 0xF8A7, 0xE78692 },
	{ 0xEFC2, 0xE78694 },
	{ 0xF9F7, 0xE78699 },
	{ 0xEC69, 0xE7869F },
	{ 0xE97C, 0xE786A2 },
	{ 0xEF32, 0xE786AC },
	{ 0xEE92, 0xE786B1 },
	{ 0xF9F8, 0xE786B9 },
	{ 0xF9F9, 0xE786BA },
	{ 0xF64F, 0xE786BE },
	{ 0xEEA7, 0xE78781 },
	{ 0xEE67, 0xE78783 },
	{ 0xE595, 0xE78788 },
	{ 0xE559, 0xE78789 },
	{ 0xE69C, 0xE7878E },
	{ 0xE6F2, 0xE78790 },
	{ 0xEBC0, 0xE78792 },
	{ 0xE8E2, 0xE78794 },
	{ 0xEE68, 0xE78795 },
	{ 0xEEBD, 0xE7879F },
	{ 0xF35F, 0xE787A5 },
	{ 0xF4BE, 0xE787A6 },
	{ 0xEC3C, 0xE787A7 },
	{ 0xF5B7, 0xE787AD },
	{ 0xEB92, 0xE787AE },
	{ 0xF9B8, 0xE787BB },
	{ 0xECE8, 0xE787BC },
	{ 0xE537, 0xE787BE },
	{ 0xEF9E, 0xE787BF },
	{ 0xF862, 0xE78880 },
	{ 0xF791, 0xE78886 },
	{ 0xE663, 0xE78890 },
	{ 0xE5B4, 0xE7889B },
	{ 0xF360, 0xE788AA },
	{ 0xF6F0, 0xE788AC },
	{ 0xF243, 0xE788AD },
	{ 0xF04A, 0xE788B0 },
	{ 0xF063, 0xE788B2 },
	{ 0xF1C9, 0xE788B5 },
	{ 0xE9AB, 0xE788B6 },
	{ 0xEDAC, 0xE788BA },
	{ 0xF9A1, 0xE788BB },
	{ 0xEAD0, 0xE788BD },
	{ 0xF143, 0xE788BE },
	{ 0xEAD1, 0xE78980 },
	{ 0xF1ED, 0xE78986 },
	{ 0xF748, 0xE78987 },
	{ 0xF6FA, 0xE78988 },
	{ 0xF73B, 0xE7898C },
	{ 0xF570, 0xE78992 },
	{ 0xE54A, 0xE78998 },
	{ 0xED43, 0xE78999 },
	{ 0xEFDA, 0xE7899B },
	{ 0xEA46, 0xE7899D },
	{ 0xE7BF, 0xE7899F },
	{ 0xE7C0, 0xE789A1 },
	{ 0xE691, 0xE789A2 },
	{ 0xE7CC, 0xE789A7 },
	{ 0xE83A, 0xE789A9 },
	{ 0xEAE5, 0xE789B2 },
	{ 0xF6E5, 0xE789B9 },
	{ 0xE142, 0xE789BD },
	{ 0xEAF9, 0xE78A80 },
	{ 0xE6E0, 0xE78A81 },
	{ 0xE54B, 0xE78AA2 },
	{ 0xF9FA, 0xE78AA7 },
	{ 0xE143, 0xE78AAC },
	{ 0xE8F3, 0xE78AAF },
	{ 0xEAD2, 0xE78B80 },
	{ 0xE25A, 0xE78B82 },
	{ 0xF26A, 0xE78B84 },
	{ 0xED74, 0xE78B8E },
	{ 0xF8CF, 0xE78B90 },
	{ 0xE2B7, 0xE78B97 },
	{ 0xF253, 0xE78B99 },
	{ 0xE27A, 0xE78BA1 },
	{ 0xEC3D, 0xE78BA9 },
	{ 0xE6E1, 0xE78BB8 },
	{ 0xF897, 0xE78BB9 },
	{ 0xE5C9, 0xE78BBC },
	{ 0xF73C, 0xE78BBD },
	{ 0xEED9, 0xE78C8A },
	{ 0xF4E9, 0xE78C96 },
	{ 0xE77D, 0xE78C9B },
	{ 0xECC4, 0xE78C9C },
	{ 0xF393, 0xE78C9D },
	{ 0xEF75, 0xE78CA5 },
	{ 0xEB9C, 0xE78CA9 },
	{ 0xF254, 0xE78CAA },
	{ 0xE7DE, 0xE78CAB },
	{ 0xF0A2, 0xE78CB6 },
	{ 0xF0A3, 0xE78CB7 },
	{ 0xF952, 0xE78CBE },
	{ 0xF04B, 0xE78CBF },
	{ 0xEF3B, 0xE78D84 },
	{ 0xEA72, 0xE78D85 },
	{ 0xF1EF, 0xE78D90 },
	{ 0xEF33, 0xE78D92 },
	{ 0xE2F1, 0xE78D97 },
	{ 0xE54C, 0xE78DA8 },
	{ 0xF97A, 0xE78DAA },
	{ 0xEEBE, 0xE78DB0 },
	{ 0xF994, 0xE78DB2 },
	{ 0xE644, 0xE78DB5 },
	{ 0xEC3E, 0xE78DB8 },
	{ 0xE4B7, 0xE78DBA },
	{ 0xF85C, 0xE78DBB },
	{ 0xF86C, 0xE78E84 },
	{ 0xF1B5, 0xE78E86 },
	{ 0xEBE3, 0xE78E87 },
	{ 0xEF3C, 0xE78E89 },
	{ 0xEF6D, 0xE78E8B },
	{ 0xF2E9, 0xE78E8E },
	{ 0xF54D, 0xE78E94 },
	{ 0xE2B8, 0xE78E96 },
	{ 0xEFDB, 0xE78E97 },
	{ 0xE3AC, 0xE78E98 },
	{ 0xE857, 0xE78E9F },
	{ 0xF0C9, 0xE78EA7 },
	{ 0xEF5C, 0xE78EA9 },
	{ 0xEA47, 0xE78EAD },
	{ 0xE64C, 0xE78EB2 },
	{ 0xE4E5, 0xE78EB3 },
	{ 0xF86D, 0xE78EB9 },
	{ 0xE866, 0xE78F80 },
	{ 0xE041, 0xE78F82 },
	{ 0xE858, 0xE78F89 },
	{ 0xEAA6, 0xE78F8A },
	{ 0xF7B3, 0xE78F8C },
	{ 0xF462, 0xE78F8D },
	{ 0xE054, 0xE78F8F },
	{ 0xE25B, 0xE78F96 },
	{ 0xE1F5, 0xE78F99 },
	{ 0xF9B0, 0xE78F9D },
	{ 0xE5A8, 0xE78F9E },
	{ 0xF3C1, 0xE78FA0 },
	{ 0xEC79, 0xE78FA3 },
	{ 0xE95A, 0xE78FA4 },
	{ 0xF144, 0xE78FA5 },
	{ 0xF850, 0xE78FA6 },
	{ 0xF8A8, 0xE78FA9 },
	{ 0xE338, 0xE78FAA },
	{ 0xE87C, 0xE78FAD },
	{ 0xE7EE, 0xE78FB7 },
	{ 0xEB9D, 0xE78FB9 },
	{ 0xF2EA, 0xE78FBD },
	{ 0xF86E, 0xE78FBE },
	{ 0xEB54, 0xE79081 },
	{ 0xE2B9, 0xE79083 },
	{ 0xE5CA, 0xE79085 },
	{ 0xE6E2, 0xE79086 },
	{ 0xEC3F, 0xE79087 },
	{ 0xE6B8, 0xE79089 },
	{ 0xEF5D, 0xE79093 },
	{ 0xF66A, 0xE7909B },
	{ 0xF2A2, 0xE790A0 },
	{ 0xEC6A, 0xE790A1 },
	{ 0xF69E, 0xE790A2 },
	{ 0xF8D0, 0xE790A5 },
	{ 0xE3AD, 0xE790A6 },
	{ 0xE1E4, 0xE790A8 },
	{ 0xE3AE, 0xE790AA },
	{ 0xE97D, 0xE790AB },
	{ 0xEF5E, 0xE790AC },
	{ 0xF39B, 0xE790AE },
	{ 0xE245, 0xE790AF },
	{ 0xEE9E, 0xE790B0 },
	{ 0xE6FB, 0xE790B3 },
	{ 0xE366, 0xE790B4 },
	{ 0xE9F5, 0xE790B5 },
	{ 0xF6F1, 0xE790B6 },
	{ 0xF69F, 0xE790B8 },
	{ 0xE8F7, 0xE790BA },
	{ 0xF8EA, 0xE790BF },
	{ 0xEFDC, 0xE79180 },
	{ 0xE7C1, 0xE79181 },
	{ 0xF5F2, 0xE79183 },
	{ 0xEB55, 0xE79184 },
	{ 0xF064, 0xE7918B },
	{ 0xF7C2, 0xE79195 },
	{ 0xF04C, 0xE79197 },
	{ 0xE455, 0xE79199 },
	{ 0xF8D1, 0xE7919A },
	{ 0xEEC0, 0xE7919B },
	{ 0xF0A5, 0xE7919C },
	{ 0xEAFA, 0xE7919E },
	{ 0xECA2, 0xE7919F },
	{ 0xE6B9, 0xE791A0 },
	{ 0xEFC3, 0xE791A2 },
	{ 0xEF9F, 0xE791A4 },
	{ 0xEF3F, 0xE791A5 },
	{ 0xF463, 0xE791A8 },
	{ 0xF8A9, 0xE791A9 },
	{ 0xE735, 0xE791AA },
	{ 0xE5CB, 0xE791AF },
	{ 0xE358, 0xE791BE },
	{ 0xE3AF, 0xE79282 },
	{ 0xE6E3, 0xE79283 },
	{ 0xEB56, 0xE79287 },
	{ 0xE632, 0xE79289 },
	{ 0xF1F0, 0xE7928B },
	{ 0xE6F3, 0xE79298 },
	{ 0xF964, 0xE7929C },
	{ 0xE867, 0xE7929E },
	{ 0xE16F, 0xE7929F },
	{ 0xF464, 0xE792A1 },
	{ 0xE3B0, 0xE792A3 },
	{ 0xE170, 0xE792A5 },
	{ 0xE8FD, 0xE792A7 },
	{ 0xF4BF, 0xE792A8 },
	{ 0xF361, 0xE792AA },
	{ 0xF94B, 0xE792B0 },
	{ 0xEC40, 0xE792B2 },
	{ 0xEE35, 0xE792B5 },
	{ 0xEC6B, 0xE792B9 },
	{ 0xEADE, 0xE792BD },
	{ 0xEB57, 0xE792BF },
	{ 0xF491, 0xE79386 },
	{ 0xE171, 0xE7938A },
	{ 0xE67A, 0xE7938F },
	{ 0xEEC2, 0xE79394 },
	{ 0xE246, 0xE79398 },
	{ 0xF4C0, 0xE7939A },
	{ 0xE1FE, 0xE7939C },
	{ 0xF8D2, 0xE793A0 },
	{ 0xF79A, 0xE793A2 },
	{ 0xF6FB, 0xE793A3 },
	{ 0xEF4F, 0xE793A6 },
	{ 0xEF47, 0xE793AE },
	{ 0xF1B6, 0xE793B7 },
	{ 0xE94A, 0xE79481 },
	{ 0xE144, 0xE79484 },
	{ 0xF3F7, 0xE79491 },
	{ 0xEF48, 0xE79495 },
	{ 0xE098, 0xE79498 },
	{ 0xED34, 0xE7949A },
	{ 0xF566, 0xE7949B },
	{ 0xEAE6, 0xE7949F },
	{ 0xEAA7, 0xE794A3 },
	{ 0xEAE7, 0xE794A5 },
	{ 0xEBC1, 0xE794A6 },
	{ 0xEFC4, 0xE794A8 },
	{ 0xE95B, 0xE794AB },
	{ 0xEFC5, 0xE794AC },
	{ 0xF2A3, 0xE794B0 },
	{ 0xF0A6, 0xE794B1 },
	{ 0xE0A3, 0xE794B2 },
	{ 0xECE9, 0xE794B3 },
	{ 0xE3FB, 0xE794B7 },
	{ 0xF2A4, 0xE794B8 },
	{ 0xF2EB, 0xE794BA },
	{ 0xE344, 0xE79587 },
	{ 0xE1A3, 0xE7958C },
	{ 0xEF76, 0xE7958F },
	{ 0xF2A5, 0xE79591 },
	{ 0xE4CC, 0xE79593 },
	{ 0xE87D, 0xE79594 },
	{ 0xE6BA, 0xE79599 },
	{ 0xF465, 0xE7959B },
	{ 0xF5E5, 0xE7959C },
	{ 0xE7EF, 0xE7959D },
	{ 0xF7B4, 0xE795A2 },
	{ 0xE5D4, 0xE795A5 },
	{ 0xF9CF, 0xE795A6 },
	{ 0xE8E3, 0xE795AA },
	{ 0xF3E1, 0xE795AF },
	{ 0xF146, 0xE795B0 },
	{ 0xF8FE, 0xE795B5 },
	{ 0xE4D7, 0xE795B6 },
	{ 0xE3B1, 0xE795B8 },
	{ 0xE0B1, 0xE795BA },
	{ 0xE3B2, 0xE795BF },
	{ 0xE0B2, 0xE79686 },
	{ 0xF3C2, 0xE79687 },
	{ 0xF571, 0xE7968A },
	{ 0xF7B5, 0xE7968B },
	{ 0xEBC3, 0xE7968E },
	{ 0xEBC2, 0xE7968F },
	{ 0xF0F7, 0xE79691 },
	{ 0xEAA8, 0xE7969D },
	{ 0xE0CA, 0xE796A5 },
	{ 0xEE49, 0xE796AB },
	{ 0xF76E, 0xE796B1 },
	{ 0xF7AA, 0xE796B2 },
	{ 0xE099, 0xE796B3 },
	{ 0xF1B7, 0xE796B5 },
	{ 0xE4B8, 0xE796B8 },
	{ 0xF466, 0xE796B9 },
	{ 0xE569, 0xE796BC },
	{ 0xF255, 0xE796BD },
	{ 0xF492, 0xE796BE },
	{ 0xE042, 0xE79782 },
	{ 0xE94B, 0xE79785 },
	{ 0xF3F8, 0xE79787 },
	{ 0xF147, 0xE7978D },
	{ 0xEDCA, 0xE79792 },
	{ 0xF650, 0xE79794 },
	{ 0xF9DD, 0xE79795 },
	{ 0xE573, 0xE79798 },
	{ 0xE172, 0xE79799 },
	{ 0xF6D4, 0xE7979B },
	{ 0xE6E5, 0xE797A2 },
	{ 0xE4C3, 0xE797B0 },
	{ 0xE736, 0xE797B2 },
	{ 0xF651, 0xE797B4 },
	{ 0xE9F6, 0xE797BA },
	{ 0xE1C0, 0xE797BC },
	{ 0xEDDC, 0xE79880 },
	{ 0xEDCB, 0xE7988D },
	{ 0xEBC4, 0xE79899 },
	{ 0xEF40, 0xE7989F },
	{ 0xF540, 0xE798A0 },
	{ 0xF4EA, 0xE798A1 },
	{ 0xE87E, 0xE798A2 },
	{ 0xE6BB, 0xE798A4 },
	{ 0xEC41, 0xE798A6 },
	{ 0xE6AA, 0xE798BB },
	{ 0xE69D, 0xE79982 },
	{ 0xED6F, 0xE7998C },
	{ 0xE066, 0xE7998E },
	{ 0xF0A8, 0xE79992 },
	{ 0xE8FE, 0xE79996 },
	{ 0xF652, 0xE799A1 },
	{ 0xF2BB, 0xE799A4 },
	{ 0xE59F, 0xE799A9 },
	{ 0xEB58, 0xE799AC },
	{ 0xEF49, 0xE799B0 },
	{ 0xF2A6, 0xE799B2 },
	{ 0xE1A4, 0xE799B8 },
	{ 0xE596, 0xE799BB },
	{ 0xE8A1, 0xE799BC },
	{ 0xE8DC, 0xE799BD },
	{ 0xE8DD, 0xE799BE },
	{ 0xF26C, 0xE79A84 },
	{ 0xE0CB, 0xE79A86 },
	{ 0xF965, 0xE79A87 },
	{ 0xE27B, 0xE79A8E },
	{ 0xE1C1, 0xE79A90 },
	{ 0xF8D3, 0xE79A93 },
	{ 0xF7AB, 0xE79AAE },
	{ 0xF5D4, 0xE79ABA },
	{ 0xE7A9, 0xE79ABF },
	{ 0xEFDD, 0xE79B82 },
	{ 0xE8CD, 0xE79B83 },
	{ 0xE9CE, 0xE79B86 },
	{ 0xEEC3, 0xE79B88 },
	{ 0xF15C, 0xE79B8A },
	{ 0xF7EC, 0xE79B92 },
	{ 0xE0CC, 0xE79B96 },
	{ 0xEB9E, 0xE79B9B },
	{ 0xE538, 0xE79B9C },
	{ 0xF1D3, 0xE79B9E },
	{ 0xE791, 0xE79B9F },
	{ 0xF467, 0xE79BA1 },
	{ 0xE09A, 0xE79BA3 },
	{ 0xE891, 0xE79BA4 },
	{ 0xE664, 0xE79BA7 },
	{ 0xE7CD, 0xE79BAE },
	{ 0xE77E, 0xE79BB2 },
	{ 0xF451, 0xE79BB4 },
	{ 0xEAD3, 0xE79BB8 },
	{ 0xE892, 0xE79BBC },
	{ 0xEC7A, 0xE79BBE },
	{ 0xEB9F, 0xE79C81 },
	{ 0xE79A, 0xE79C84 },
	{ 0xF6AF, 0xE79C88 },
	{ 0xE846, 0xE79C89 },
	{ 0xE067, 0xE79C8B },
	{ 0xF468, 0xE79C9E },
	{ 0xE79B, 0xE79CA0 },
	{ 0xF86F, 0xE79CA9 },
	{ 0xE2EF, 0xE79CB7 },
	{ 0xE7C2, 0xE79CB8 },
	{ 0xF362, 0xE79CBA },
	{ 0xED61, 0xE79CBC },
	{ 0xF4B7, 0xE79D80 },
	{ 0xF870, 0xE79D8D },
	{ 0xF2EC, 0xE79D9B },
	{ 0xEC42, 0xE79DA1 },
	{ 0xE54D, 0xE79DA3 },
	{ 0xE7CE, 0xE79DA6 },
	{ 0xF572, 0xE79DAB },
	{ 0xE539, 0xE79DB9 },
	{ 0xE1C2, 0xE79DBE },
	{ 0xEEDA, 0xE79DBF },
	{ 0xF469, 0xE79E8B },
	{ 0xE7AA, 0xE79E91 },
	{ 0xE74E, 0xE79E9E },
	{ 0xE93D, 0xE79EA5 },
	{ 0xEC7B, 0xE79EAC },
	{ 0xE69E, 0xE79EAD },
	{ 0xE09B, 0xE79EB0 },
	{ 0xE56A, 0xE79EB3 },
	{ 0xF567, 0xE79EBB },
	{ 0xE131, 0xE79EBC },
	{ 0xE2BA, 0xE79EBF },
	{ 0xF5B8, 0xE79F97 },
	{ 0xE7C3, 0xE79F9B },
	{ 0xE378, 0xE79F9C },
	{ 0xECC5, 0xE79FA2 },
	{ 0xF0F8, 0xE79FA3 },
	{ 0xF441, 0xE79FA5 },
	{ 0xE2BB, 0xE79FA9 },
	{ 0xE4AD, 0xE79FAD },
	{ 0xEF71, 0xE79FAE },
	{ 0xE27C, 0xE79FAF },
	{ 0xEB44, 0xE79FB3 },
	{ 0xEA73, 0xE7A082 },
	{ 0xE9F7, 0xE7A092 },
	{ 0xF442, 0xE7A0A5 },
	{ 0xF4F6, 0xE7A0A6 },
	{ 0xF66B, 0xE7A0A7 },
	{ 0xE6FE, 0xE7A0AC },
	{ 0xF76F, 0xE7A0B2 },
	{ 0xF6F2, 0xE7A0B4 },
	{ 0xE339, 0xE7A185 },
	{ 0xEE6A, 0xE7A18F },
	{ 0xF5A6, 0xE7A19D },
	{ 0xE6BC, 0xE7A1AB },
	{ 0xE173, 0xE7A1AC },
	{ 0xEE6B, 0xE7A1AF },
	{ 0xE9DD, 0xE7A1BC },
	{ 0xE3B3, 0xE7A281 },
	{ 0xF2ED, 0xE7A287 },
	{ 0xE66E, 0xE7A28C },
	{ 0xED96, 0xE7A28D },
	{ 0xEBEF, 0xE7A28E },
	{ 0xE9F8, 0xE7A291 },
	{ 0xEF5F, 0xE7A297 },
	{ 0xE075, 0xE7A2A3 },
	{ 0xE931, 0xE7A2A7 },
	{ 0xEB45, 0xE7A2A9 },
	{ 0xF93C, 0xE7A2BA },
	{ 0xF93D, 0xE7A2BB },
	{ 0xE737, 0xE7A2BC },
	{ 0xF1B8, 0xE7A381 },
	{ 0xE8B6, 0xE7A385 },
	{ 0xE692, 0xE7A38A },
	{ 0xF4AF, 0xE7A38B },
	{ 0xE1A5, 0xE7A38E },
	{ 0xE893, 0xE7A390 },
	{ 0xE738, 0xE7A3A8 },
	{ 0xE174, 0xE7A3AC },
	{ 0xE3B4, 0xE7A3AF },
	{ 0xE068, 0xE7A3B5 },
	{ 0xE894, 0xE7A3BB },
	{ 0xF5A7, 0xE7A481 },
	{ 0xF5A8, 0xE7A48E },
	{ 0xEE36, 0xE7A496 },
	{ 0xE5EC, 0xE7A4AA },
	{ 0xE5F8, 0xE7A4AB },
	{ 0xE895, 0xE7A4AC },
	{ 0xECC6, 0xE7A4BA },
	{ 0xEA74, 0xE7A4BE },
	{ 0xEA75, 0xE7A580 },
	{ 0xE3B5, 0xE7A581 },
	{ 0xE3B6, 0xE7A587 },
	{ 0xE3B7, 0xE7A588 },
	{ 0xF443, 0xE7A589 },
	{ 0xEFDE, 0xE7A590 },
	{ 0xF363, 0xE7A596 },
	{ 0xF444, 0xE7A597 },
	{ 0xF364, 0xE7A59A },
	{ 0xE0E4, 0xE7A59B },
	{ 0xF8D4, 0xE7A59C },
	{ 0xF5E6, 0xE7A59D },
	{ 0xECEA, 0xE7A59E },
	{ 0xEA76, 0xE7A5A0 },
	{ 0xEAD4, 0xE7A5A5 },
	{ 0xF79B, 0xE7A5A8 },
	{ 0xF33E, 0xE7A5AD },
	{ 0xE3B8, 0xE7A5BA },
	{ 0xE66F, 0xE7A5BF },
	{ 0xE367, 0xE7A681 },
	{ 0xF931, 0xE7A68D },
	{ 0xF2EE, 0xE7A68E },
	{ 0xE968, 0xE7A68F },
	{ 0xEFDF, 0xE7A691 },
	{ 0xEDDD, 0xE7A6A6 },
	{ 0xF9FB, 0xE7A6A7 },
	{ 0xEB59, 0xE7A6AA },
	{ 0xE659, 0xE7A6AE },
	{ 0xE53A, 0xE7A6B1 },
	{ 0xEDCC, 0xE7A6B3 },
	{ 0xEFE0, 0xE7A6B9 },
	{ 0xE368, 0xE7A6BD },
	{ 0xF932, 0xE7A6BE },
	{ 0xE54E, 0xE7A6BF },
	{ 0xEC43, 0xE7A780 },
	{ 0xEA77, 0xE7A781 },
	{ 0xE94C, 0xE7A789 },
	{ 0xE446, 0xE7A78A },
	{ 0xF5D5, 0xE7A78B },
	{ 0xE231, 0xE7A791 },
	{ 0xF5A9, 0xE7A792 },
	{ 0xE9F9, 0xE7A795 },
	{ 0xE9FA, 0xE7A798 },
	{ 0xF365, 0xE7A79F },
	{ 0xF66F, 0xE7A7A4 },
	{ 0xF46A, 0xE7A7A6 },
	{ 0xED7B, 0xE7A7A7 },
	{ 0xF493, 0xE7A7A9 },
	{ 0xF149, 0xE7A7BB },
	{ 0xF9FC, 0xE7A880 },
	{ 0xEBAA, 0xE7A885 },
	{ 0xE069, 0xE7A888 },
	{ 0xF2EF, 0xE7A88B },
	{ 0xF5AA, 0xE7A88D },
	{ 0xF19B, 0xE7A894 },
	{ 0xF73D, 0xE7A897 },
	{ 0xF452, 0xE7A899 },
	{ 0xF653, 0xE7A89A },
	{ 0xE6D2, 0xE7A89C },
	{ 0xF7A2, 0xE7A89F },
	{ 0xF366, 0xE7A8A0 },
	{ 0xF39C, 0xE7A8AE },
	{ 0xF670, 0xE7A8B1 },
	{ 0xEFF3, 0xE7A8B6 },
	{ 0xF453, 0xE7A8B7 },
	{ 0xE53B, 0xE7A8BB },
	{ 0xE043, 0xE7A8BC },
	{ 0xE1A6, 0xE7A8BD },
	{ 0xE1C3, 0xE7A8BF },
	{ 0xE1DA, 0xE7A980 },
	{ 0xE7CF, 0xE7A986 },
	{ 0xF654, 0xE7A989 },
	{ 0xF26D, 0xE7A98D },
	{ 0xEEC4, 0xE7A98E },
	{ 0xEC44, 0xE7A997 },
	{ 0xEAE2, 0xE7A9A1 },
	{ 0xEEDB, 0xE7A9A2 },
	{ 0xEF41, 0xE7A9A9 },
	{ 0xF93E, 0xE7A9AB },
	{ 0xEDCD, 0xE7A9B0 },
	{ 0xF87B, 0xE7A9B4 },
	{ 0xE2BC, 0xE7A9B6 },
	{ 0xE2E2, 0xE7A9B9 },
	{ 0xE1F6, 0xE7A9BA },
	{ 0xF2F0, 0xE7A9BD },
	{ 0xF54E, 0xE7A9BF },
	{ 0xE55D, 0xE7AA81 },
	{ 0xF4B8, 0xE7AA84 },
	{ 0xEFA1, 0xE7AA88 },
	{ 0xF494, 0xE7AA92 },
	{ 0xF4EB, 0xE7AA93 },
	{ 0xF367, 0xE7AA95 },
	{ 0xE2D7, 0xE7AA98 },
	{ 0xE2DF, 0xE7AA9F },
	{ 0xEF50, 0xE7AAA9 },
	{ 0xEF51, 0xE7AAAA },
	{ 0xE2E3, 0xE7AAAE },
	{ 0xEFA2, 0xE7AAAF },
	{ 0xE33A, 0xE7AABA },
	{ 0xF4C1, 0xE7AB84 },
	{ 0xE33B, 0xE7AB85 },
	{ 0xE574, 0xE7AB87 },
	{ 0xF2BC, 0xE7AB8A },
	{ 0xE731, 0xE7AB8B },
	{ 0xE7DF, 0xE7AB97 },
	{ 0xF4D7, 0xE7AB99 },
	{ 0xE94D, 0xE7AB9D },
	{ 0xE175, 0xE7AB9F },
	{ 0xF1F1, 0xE7ABA0 },
	{ 0xF3E2, 0xE7ABA3 },
	{ 0xE56B, 0xE7ABA5 },
	{ 0xEC45, 0xE7ABAA },
	{ 0xE076, 0xE7ABAD },
	{ 0xE4AE, 0xE7ABAF },
	{ 0xE176, 0xE7ABB6 },
	{ 0xF3D3, 0xE7ABB9 },
	{ 0xF5E7, 0xE7ABBA },
	{ 0xE06A, 0xE7ABBF },
	{ 0xF8EE, 0xE7AC8F },
	{ 0xEBC5, 0xE7AC91 },
	{ 0xEAE9, 0xE7AC99 },
	{ 0xF26E, 0xE7AC9B },
	{ 0xF6C2, 0xE7AC9E },
	{ 0xE732, 0xE7ACA0 },
	{ 0xE9AC, 0xE7ACA6 },
	{ 0xF33F, 0xE7ACAC },
	{ 0xE64D, 0xE7ACAD },
	{ 0xEBAB, 0xE7ACB9 },
	{ 0xF7B6, 0xE7AD86 },
	{ 0xE597, 0xE7AD89 },
	{ 0xE359, 0xE7AD8B },
	{ 0xF2A7, 0xE7AD8C },
	{ 0xEC7C, 0xE7AD8D },
	{ 0xE8EA, 0xE7AD8F },
	{ 0xE25C, 0xE7AD90 },
	{ 0xF5E8, 0xE7AD91 },
	{ 0xF6D5, 0xE7AD92 },
	{ 0xE4CD, 0xE7AD94 },
	{ 0xF4FE, 0xE7AD96 },
	{ 0xE345, 0xE7ADA0 },
	{ 0xEBA0, 0xE7ADAC },
	{ 0xEAFB, 0xE7ADAE },
	{ 0xEE6D, 0xE7ADB5 },
	{ 0xEF34, 0xE7ADBD },
	{ 0xE0CD, 0xE7AE87 },
	{ 0xF2A8, 0xE7AE8B },
	{ 0xF244, 0xE7AE8F },
	{ 0xE868, 0xE7AE94 },
	{ 0xE3B9, 0xE7AE95 },
	{ 0xEAA9, 0xE7AE97 },
	{ 0xF4B0, 0xE7AE9A },
	{ 0xE154, 0xE7AE9D },
	{ 0xE247, 0xE7AEA1 },
	{ 0xF2A9, 0xE7AEAD },
	{ 0xEAD5, 0xE7AEB1 },
	{ 0xF1D7, 0xE7AEB4 },
	{ 0xF256, 0xE7AEB8 },
	{ 0xF2BD, 0xE7AF80 },
	{ 0xF966, 0xE7AF81 },
	{ 0xE8F4, 0xE7AF84 },
	{ 0xF2AA, 0xE7AF86 },
	{ 0xF749, 0xE7AF87 },
	{ 0xF5E9, 0xE7AF89 },
	{ 0xECD9, 0xE7AF92 },
	{ 0xEBC6, 0xE7AFA0 },
	{ 0xE54F, 0xE7AFA4 },
	{ 0xEA78, 0xE7AFA9 },
	{ 0xF37A, 0xE7B087 },
	{ 0xF4C2, 0xE7B092 },
	{ 0xE4AF, 0xE7B09E },
	{ 0xE06B, 0xE7B0A1 },
	{ 0xF967, 0xE7B0A7 },
	{ 0xF1D8, 0xE7B0AA },
	{ 0xEBC7, 0xE7B0AB },
	{ 0xF568, 0xE7B0BD },
	{ 0xE643, 0xE7B0BE },
	{ 0xE9AD, 0xE7B0BF },
	{ 0xE5BE, 0xE7B183 },
	{ 0xF3C3, 0xE7B18C },
	{ 0xF26F, 0xE7B18D },
	{ 0xE67B, 0xE7B1A0 },
	{ 0xF569, 0xE7B1A4 },
	{ 0xE6E6, 0xE7B1AC },
	{ 0xE847, 0xE7B1B3 },
	{ 0xE9FB, 0xE7B283 },
	{ 0xE9CF, 0xE7B289 },
	{ 0xE733, 0xE7B292 },
	{ 0xE869, 0xE7B295 },
	{ 0xF368, 0xE7B297 },
	{ 0xF2C4, 0xE7B298 },
	{ 0xEBD8, 0xE7B29F },
	{ 0xF3D4, 0xE7B2A5 },
	{ 0xF1F2, 0xE7B2A7 },
	{ 0xE5DB, 0xE7B2AE },
	{ 0xE5DC, 0xE7B2B1 },
	{ 0xF4C4, 0xE7B2B2 },
	{ 0xE0D7, 0xE7B2B3 },
	{ 0xEC46, 0xE7B2B9 },
	{ 0xF2F1, 0xE7B2BE },
	{ 0xF8D5, 0xE7B38A },
	{ 0xE4D8, 0xE7B396 },
	{ 0xE9D0, 0xE7B39E },
	{ 0xF369, 0xE7B39F },
	{ 0xE0B3, 0xE7B3A0 },
	{ 0xE5DD, 0xE7B3A7 },
	{ 0xE1A7, 0xE7B3BB },
	{ 0xE33C, 0xE7B3BE },
	{ 0xE3BA, 0xE7B480 },
	{ 0xF3C4, 0xE7B482 },
	{ 0xEDB3, 0xE7B484 },
	{ 0xF8F5, 0xE7B485 },
	{ 0xEFE1, 0xE7B486 },
	{ 0xF9E0, 0xE7B487 },
	{ 0xF94C, 0xE7B488 },
	{ 0xE832, 0xE7B48A },
	{ 0xE833, 0xE7B48B },
	{ 0xE431, 0xE7B48D },
	{ 0xE491, 0xE7B490 },
	{ 0xEC7D, 0xE7B494 },
	{ 0xEA79, 0xE7B497 },
	{ 0xE26C, 0xE7B498 },
	{ 0xF445, 0xE7B499 },
	{ 0xE374, 0xE7B49A },
	{ 0xE9D1, 0xE7B49B },
	{ 0xEBC8, 0xE7B4A0 },
	{ 0xE8B7, 0xE7B4A1 },
	{ 0xEAE3, 0xE7B4A2 },
	{ 0xF1B9, 0xE7B4AB },
	{ 0xF3C5, 0xE7B4AC },
	{ 0xF4CF, 0xE7B4AE },
	{ 0xE6AB, 0xE7B4AF },
	{ 0xEBAC, 0xE7B4B0 },
	{ 0xECEB, 0xE7B4B3 },
	{ 0xF257, 0xE7B4B5 },
	{ 0xEBC9, 0xE7B4B9 },
	{ 0xE09C, 0xE7B4BA },
	{ 0xF39D, 0xE7B582 },
	{ 0xF871, 0xE7B583 },
	{ 0xF36A, 0xE7B584 },
	{ 0xE177, 0xE7B585 },
	{ 0xE896, 0xE7B586 },
	{ 0xE14F, 0xE7B590 },
	{ 0xE27D, 0xE7B59E },
	{ 0xE5A9, 0xE7B5A1 },
	{ 0xF872, 0xE7B5A2 },
	{ 0xE375, 0xE7B5A6 },
	{ 0xF0D6, 0xE7B5A8 },
	{ 0xF16F, 0xE7B5AA },
	{ 0xEAFC, 0xE7B5AE },
	{ 0xF6D6, 0xE7B5B1 },
	{ 0xEA7A, 0xE7B5B2 },
	{ 0xE0B4, 0xE7B5B3 },
	{ 0xF2BE, 0xE7B5B6 },
	{ 0xE145, 0xE7B5B9 },
	{ 0xE2BD, 0xE7B5BF },
	{ 0xF2F2, 0xE7B68E },
	{ 0xEC47, 0xE7B68F },
	{ 0xE178, 0xE7B693 },
	{ 0xF39E, 0xE7B69C },
	{ 0xE670, 0xE7B6A0 },
	{ 0xF3C6, 0xE7B6A2 },
	{ 0xEC48, 0xE7B6AC },
	{ 0xF0AB, 0xE7B6AD },
	{ 0xE0B5, 0xE7B6B1 },
	{ 0xE761, 0xE7B6B2 },
	{ 0xF55E, 0xE7B6B4 },
	{ 0xF4F7, 0xE7B6B5 },
	{ 0xE6C6, 0xE7B6B8 },
	{ 0xE3BB, 0xE7B6BA },
	{ 0xF6AA, 0xE7B6BB },
	{ 0xF1CA, 0xE7B6BD },
	{ 0xE6D3, 0xE7B6BE },
	{ 0xE79C, 0xE7B6BF },
	{ 0xF655, 0xE7B787 },
	{ 0xE3CC, 0xE7B78A },
	{ 0xE9FC, 0xE7B78B },
	{ 0xEAFD, 0xE7B796 },
	{ 0xF7E5, 0xE7B798 },
	{ 0xEB5A, 0xE7B79A },
	{ 0xF49F, 0xE7B79D },
	{ 0xE4B0, 0xE7B79E },
	{ 0xF595, 0xE7B7A0 },
	{ 0xE859, 0xE7B7A1 },
	{ 0xEE6E, 0xE7B7A3 },
	{ 0xF74A, 0xE7B7A8 },
	{ 0xEF60, 0xE7B7A9 },
	{ 0xE79D, 0xE7B7AC },
	{ 0xF065, 0xE7B7AF },
	{ 0xE633, 0xE7B7B4 },
	{ 0xF656, 0xE7B7BB },
	{ 0xF46B, 0xE7B889 },
	{ 0xED9E, 0xE7B88A },
	{ 0xEF42, 0xE7B895 },
	{ 0xE86A, 0xE7B89B },
	{ 0xF46C, 0xE7B89D },
	{ 0xF8D6, 0xE7B89E },
	{ 0xEFB2, 0xE7B89F },
	{ 0xF23D, 0xE7B8A1 },
	{ 0xF873, 0xE7B8A3 },
	{ 0xE97E, 0xE7B8AB },
	{ 0xF5EA, 0xE7B8AE },
	{ 0xEE70, 0xE7B8AF },
	{ 0xF39F, 0xE7B8B1 },
	{ 0xE6AC, 0xE7B8B7 },
	{ 0xF5C5, 0xE7B8BD },
	{ 0xF270, 0xE7B8BE },
	{ 0xE8E5, 0xE7B981 },
	{ 0xE9DE, 0xE7B983 },
	{ 0xE7F0, 0xE7B986 },
	{ 0xEFA3, 0xE7B987 },
	{ 0xF3F9, 0xE7B992 },
	{ 0xF454, 0xE7B994 },
	{ 0xEB5B, 0xE7B995 },
	{ 0xEFA4, 0xE7B99E },
	{ 0xEC49, 0xE7B9A1 },
	{ 0xECB1, 0xE7B9A9 },
	{ 0xF97B, 0xE7B9AA },
	{ 0xE1A8, 0xE7B9AB },
	{ 0xE146, 0xE7B9AD },
	{ 0xF36B, 0xE7B9B0 },
	{ 0xEE4A, 0xE7B9B9 },
	{ 0xE1A9, 0xE7B9BC },
	{ 0xF4C3, 0xE7BA82 },
	{ 0xEBD9, 0xE7BA8C },
	{ 0xF2AB, 0xE7BA8F },
	{ 0xEEC5, 0xE7BA93 },
	{ 0xEB79, 0xE7BA96 },
	{ 0xF4C5, 0xE7BA98 },
	{ 0xE550, 0xE7BA9B },
	{ 0xE5BF, 0xE7BA9C },
	{ 0xE9AE, 0xE7BCB6 },
	{ 0xF7FC, 0xE7BCB8 },
	{ 0xE150, 0xE7BCBA },
	{ 0xEDA2, 0xE7BD8C },
	{ 0xE248, 0xE7BD90 },
	{ 0xE762, 0xE7BD94 },
	{ 0xF7D6, 0xE7BD95 },
	{ 0xF3AA, 0xE7BDAA },
	{ 0xE261, 0xE7BDAB },
	{ 0xF657, 0xE7BDAE },
	{ 0xE8EB, 0xE7BDB0 },
	{ 0xEAFE, 0xE7BDB2 },
	{ 0xE771, 0xE7BDB5 },
	{ 0xF6F3, 0xE7BDB7 },
	{ 0xE6E7, 0xE7BDB9 },
	{ 0xE5A0, 0xE7BE85 },
	{ 0xE3BC, 0xE7BE88 },
	{ 0xEDCF, 0xE7BE8A },
	{ 0xE0B6, 0xE7BE8C },
	{ 0xE848, 0xE7BE8E },
	{ 0xE1C4, 0xE7BE94 },
	{ 0xE64E, 0xE7BE9A },
	{ 0xEC4A, 0xE7BE9E },
	{ 0xE2D8, 0xE7BEA4 },
	{ 0xEB5C, 0xE7BEA8 },
	{ 0xF0F9, 0xE7BEA9 },
	{ 0xF9FD, 0xE7BEB2 },
	{ 0xE6E8, 0xE7BEB8 },
	{ 0xE0D8, 0xE7BEB9 },
	{ 0xEFE2, 0xE7BEBD },
	{ 0xEF4A, 0xE7BF81 },
	{ 0xECC7, 0xE7BF85 },
	{ 0xF15D, 0xE7BF8A },
	{ 0xF15E, 0xE7BF8C },
	{ 0xE64F, 0xE7BF8E },
	{ 0xECA7, 0xE7BF92 },
	{ 0xEAD6, 0xE7BF94 },
	{ 0xF9E8, 0xE7BF95 },
	{ 0xF271, 0xE7BF9F },
	{ 0xF638, 0xE7BFA0 },
	{ 0xE9FD, 0xE7BFA1 },
	{ 0xF74B, 0xE7BFA9 },
	{ 0xEF61, 0xE7BFAB },
	{ 0xF7D7, 0xE7BFB0 },
	{ 0xE27E, 0xE7BFB9 },
	{ 0xF15F, 0xE7BFBC },
	{ 0xEFA5, 0xE88080 },
	{ 0xE665, 0xE88081 },
	{ 0xE1C5, 0xE88083 },
	{ 0xF1BA, 0xE88085 },
	{ 0xE3BD, 0xE88086 },
	{ 0xE2BE, 0xE88089 },
	{ 0xF14B, 0xE8808C },
	{ 0xE441, 0xE88090 },
	{ 0xE179, 0xE88095 },
	{ 0xE7C4, 0xE88097 },
	{ 0xEFFC, 0xE88098 },
	{ 0xE3BE, 0xE880AD },
	{ 0xF14C, 0xE880B3 },
	{ 0xEDAD, 0xE880B6 },
	{ 0xF6B0, 0xE880BD },
	{ 0xE17A, 0xE880BF },
	{ 0xE4C4, 0xE88183 },
	{ 0xE650, 0xE88186 },
	{ 0xE69F, 0xE8818A },
	{ 0xEBA1, 0xE88196 },
	{ 0xEA4D, 0xE88198 },
	{ 0xF639, 0xE8819A },
	{ 0xE834, 0xE8819E },
	{ 0xE634, 0xE881AF },
	{ 0xF5C6, 0xE881B0 },
	{ 0xEBA2, 0xE881B2 },
	{ 0xEFC6, 0xE881B3 },
	{ 0xF455, 0xE881B7 },
	{ 0xF579, 0xE881BD },
	{ 0xE67C, 0xE881BE },
	{ 0xF0D3, 0xE881BF },
	{ 0xF14D, 0xE88284 },
	{ 0xEC6C, 0xE88285 },
	{ 0xEA7B, 0xE88286 },
	{ 0xF36C, 0xE88287 },
	{ 0xF0BF, 0xE88289 },
	{ 0xE6CE, 0xE8828B },
	{ 0xE3BF, 0xE8828C },
	{ 0xF5AB, 0xE88296 },
	{ 0xF7FD, 0xE8829B },
	{ 0xE06C, 0xE8829D },
	{ 0xE1C6, 0xE882A1 },
	{ 0xF446, 0xE882A2 },
	{ 0xE9FE, 0xE882A5 },
	{ 0xE147, 0xE882A9 },
	{ 0xE8B8, 0xE882AA },
	{ 0xE379, 0xE882AF },
	{ 0xE26D, 0xE882B1 },
	{ 0xF0C0, 0xE882B2 },
	{ 0xF9A2, 0xE882B4 },
	{ 0xF75B, 0xE882BA },
	{ 0xF066, 0xE88383 },
	{ 0xF3B0, 0xE88384 },
	{ 0xE8CE, 0xE8838C },
	{ 0xF6C3, 0xE8838E },
	{ 0xE8CF, 0xE8839A },
	{ 0xE0A4, 0xE8839B },
	{ 0xF770, 0xE8839E },
	{ 0xF8D7, 0xE883A1 },
	{ 0xF0CA, 0xE883A4 },
	{ 0xEB31, 0xE883A5 },
	{ 0xE25D, 0xE883B1 },
	{ 0xE56C, 0xE883B4 },
	{ 0xF9D8, 0xE883B8 },
	{ 0xE498, 0xE883BD },
	{ 0xF447, 0xE88482 },
	{ 0xF898, 0xE88485 },
	{ 0xF63A, 0xE88486 },
	{ 0xF899, 0xE88487 },
	{ 0xE776, 0xE88488 },
	{ 0xF541, 0xE8848A },
	{ 0xEF62, 0xE88498 },
	{ 0xE055, 0xE8849A },
	{ 0xE17B, 0xE8849B },
	{ 0xEC7E, 0xE884A3 },
	{ 0xEC4B, 0xE884A9 },
	{ 0xF6AD, 0xE884AB },
	{ 0xF771, 0xE884AF },
	{ 0xF4EC, 0xE884B9 },
	{ 0xEA31, 0xE884BE },
	{ 0xED9F, 0xE8858B },
	{ 0xECEC, 0xE8858E },
	{ 0xE9AF, 0xE88590 },
	{ 0xE9B0, 0xE88591 },
	{ 0xE0B7, 0xE88594 },
	{ 0xEF63, 0xE88595 },
	{ 0xEBA3, 0xE885A5 },
	{ 0xE470, 0xE885A6 },
	{ 0xF3A0, 0xE885AB },
	{ 0xEFA6, 0xE885B0 },
	{ 0xE0F2, 0xE885B1 },
	{ 0xF1F3, 0xE885B8 },
	{ 0xE969, 0xE885B9 },
	{ 0xEB5D, 0xE885BA },
	{ 0xF6DA, 0xE885BF },
	{ 0xE8B9, 0xE88680 },
	{ 0xE13E, 0xE88688 },
	{ 0xE86B, 0xE8868A },
	{ 0xE1C7, 0xE8868F },
	{ 0xE9B1, 0xE8869A },
	{ 0xE73F, 0xE8869C },
	{ 0xECA3, 0xE8869D },
	{ 0xE291, 0xE886A0 },
	{ 0xF495, 0xE886A3 },
	{ 0xF743, 0xE886A8 },
	{ 0xEB5E, 0xE886B3 },
	{ 0xF5FD, 0xE886B5 },
	{ 0xF0EC, 0xE886BA },
	{ 0xE4C5, 0xE886BD },
	{ 0xF97C, 0xE886BE },
	{ 0xE46B, 0xE886BF },
	{ 0xE57B, 0xE88780 },
	{ 0xEA32, 0xE88782 },
	{ 0xEDE6, 0xE88786 },
	{ 0xF340, 0xE8878D },
	{ 0xE5C4, 0xE88798 },
	{ 0xF1F4, 0xE8879F },
	{ 0xECED, 0xE887A3 },
	{ 0xEF52, 0xE887A5 },
	{ 0xF1F5, 0xE887A7 },
	{ 0xE6FC, 0xE887A8 },
	{ 0xF1BB, 0xE887AA },
	{ 0xF63B, 0xE887AD },
	{ 0xF448, 0xE887B3 },
	{ 0xF658, 0xE887B4 },
	{ 0xE4E6, 0xE887BA },
	{ 0xF46D, 0xE887BB },
	{ 0xE2BF, 0xE887BC },
	{ 0xF0AC, 0xE887BE },
	{ 0xE2C0, 0xE88885 },
	{ 0xEE38, 0xE88887 },
	{ 0xF9E9, 0xE88888 },
	{ 0xE2C1, 0xE8888A },
	{ 0xEB6F, 0xE8888C },
	{ 0xEA7C, 0xE8888D },
	{ 0xEB32, 0xE88892 },
	{ 0xF54F, 0xE8889B },
	{ 0xEC91, 0xE8889C },
	{ 0xE7F1, 0xE8889E },
	{ 0xF3C7, 0xE8889F },
	{ 0xE0B8, 0xE888A1 },
	{ 0xF7FE, 0xE888AA },
	{ 0xE8BA, 0xE888AB },
	{ 0xE897, 0xE888AC },
	{ 0xF67C, 0xE888B5 },
	{ 0xE86C, 0xE888B6 },
	{ 0xF874, 0xE888B7 },
	{ 0xEB5F, 0xE888B9 },
	{ 0xE9B2, 0xE88980 },
	{ 0xEE39, 0xE88985 },
	{ 0xF2F3, 0xE88987 },
	{ 0xF4ED, 0xE88999 },
	{ 0xF0FA, 0xE889A4 },
	{ 0xF7E6, 0xE889A6 },
	{ 0xE06D, 0xE889AE },
	{ 0xE5DE, 0xE889AF },
	{ 0xE06E, 0xE889B1 },
	{ 0xEAE4, 0xE889B2 },
	{ 0xEE9F, 0xE889B6 },
	{ 0xF5AC, 0xE889B8 },
	{ 0xED97, 0xE889BE },
	{ 0xEFE3, 0xE88A8B },
	{ 0xF1CB, 0xE88A8D },
	{ 0xE2E4, 0xE88A8E },
	{ 0xE763, 0xE88A92 },
	{ 0xE9B3, 0xE88A99 },
	{ 0xE57C, 0xE88A9A },
	{ 0xF449, 0xE88A9D },
	{ 0xEAB7, 0xE88A9F },
	{ 0xE0CE, 0xE88AA5 },
	{ 0xF8D8, 0xE88AA6 },
	{ 0xE369, 0xE88AA9 },
	{ 0xE9D2, 0xE88AAC },
	{ 0xF6F4, 0xE88AAD },
	{ 0xEEDC, 0xE88AAE },
	{ 0xED35, 0xE88AAF },
	{ 0xF933, 0xE88AB1 },
	{ 0xE8BB, 0xE88AB3 },
	{ 0xF44A, 0xE88AB7 },
	{ 0xEFFD, 0xE88AB8 },
	{ 0xE35A, 0xE88AB9 },
	{ 0xF5D6, 0xE88ABB },
	{ 0xE7C5, 0xE88ABC },
	{ 0xED44, 0xE88ABD },
	{ 0xF1A7, 0xE88ABF },
	{ 0xF04D, 0xE88B91 },
	{ 0xEEA0, 0xE88B92 },
	{ 0xF6C4, 0xE88B94 },
	{ 0xF5AD, 0xE88B95 },
	{ 0xE7E0, 0xE88B97 },
	{ 0xE044, 0xE88B9B },
	{ 0xF772, 0xE88B9E },
	{ 0xE2C2, 0xE88B9F },
	{ 0xF14E, 0xE88BA1 },
	{ 0xEDB4, 0xE88BA5 },
	{ 0xE1C8, 0xE88BA6 },
	{ 0xF258, 0xE88BA7 },
	{ 0xEEC8, 0xE88BB1 },
	{ 0xE1C9, 0xE88BBD },
	{ 0xF7B7, 0xE88BBE },
	{ 0xF3E8, 0xE88C81 },
	{ 0xE7F2, 0xE88C82 },
	{ 0xE8F5, 0xE88C83 },
	{ 0xE045, 0xE88C84 },
	{ 0xE7C6, 0xE88C85 },
	{ 0xE759, 0xE88C89 },
	{ 0xE7AB, 0xE88C97 },
	{ 0xF1BC, 0xE88CA8 },
	{ 0xE764, 0xE88CAB },
	{ 0xE96A, 0xE88CAF },
	{ 0xEC4C, 0xE88CB1 },
	{ 0xF97D, 0xE88CB4 },
	{ 0xF170, 0xE88CB5 },
	{ 0xE4A0, 0xE88CB6 },
	{ 0xEFC7, 0xE88CB8 },
	{ 0xEE3A, 0xE88CB9 },
	{ 0xEC92, 0xE88D80 },
	{ 0xF84B, 0xE88D87 },
	{ 0xF5AE, 0xE88D89 },
	{ 0xF8AA, 0xE88D8A },
	{ 0xF19D, 0xE88D8F },
	{ 0xF14F, 0xE88D91 },
	{ 0xF968, 0xE88D92 },
	{ 0xE575, 0xE88DB3 },
	{ 0xF7C3, 0xE88DB7 },
	{ 0xF272, 0xE88DBB },
	{ 0xE6E9, 0xE88E89 },
	{ 0xF1F6, 0xE88E8A },
	{ 0xEA7D, 0xE88E8E },
	{ 0xE17C, 0xE88E96 },
	{ 0xECEE, 0xE88E98 },
	{ 0xEF64, 0xE88E9E },
	{ 0xF89A, 0xE88EA2 },
	{ 0xE9B4, 0xE88EA9 },
	{ 0xED45, 0xE88EAA },
	{ 0xE740, 0xE88EAB },
	{ 0xE765, 0xE88EBD },
	{ 0xF57A, 0xE88F81 },
	{ 0xE249, 0xE88F85 },
	{ 0xE671, 0xE88F89 },
	{ 0xE2D2, 0xE88F8A },
	{ 0xE346, 0xE88F8C },
	{ 0xE232, 0xE88F93 },
	{ 0xF4EE, 0xE88F96 },
	{ 0xF4F8, 0xE88F9C },
	{ 0xE95C, 0xE88FA9 },
	{ 0xE35B, 0xE88FAB },
	{ 0xF934, 0xE88FAF },
	{ 0xE1CA, 0xE88FB0 },
	{ 0xE6D4, 0xE88FB1 },
	{ 0xEA33, 0xE88FB2 },
	{ 0xED70, 0xE88FB4 },
	{ 0xF259, 0xE88FB9 },
	{ 0xEC6D, 0xE88FBD },
	{ 0xF5FE, 0xE89083 },
	{ 0xE53C, 0xE89084 },
	{ 0xE5D1, 0xE8908A },
	{ 0xE792, 0xE8908C },
	{ 0xF753, 0xE8908D },
	{ 0xF067, 0xE8908E },
	{ 0xF5D7, 0xE890A9 },
	{ 0xE74F, 0xE890AC },
	{ 0xF9C0, 0xE890B1 },
	{ 0xF0AD, 0xE890B8 },
	{ 0xE5AA, 0xE890BD },
	{ 0xEEA8, 0xE89189 },
	{ 0xF25A, 0xE89197 },
	{ 0xE077, 0xE8919B },
	{ 0xF773, 0xE891A1 },
	{ 0xE56D, 0xE891A3 },
	{ 0xF068, 0xE891A6 },
	{ 0xF8D9, 0xE891AB },
	{ 0xF1F7, 0xE891AC },
	{ 0xEDB5, 0xE891AF },
	{ 0xE33D, 0xE891B5 },
	{ 0xF3F1, 0xE891BA },
	{ 0xEC4D, 0xE89290 },
	{ 0xECC8, 0xE89294 },
	{ 0xE7D5, 0xE89299 },
	{ 0xEAAA, 0xE8929C },
	{ 0xE8BC, 0xE892A1 },
	{ 0xF774, 0xE892B2 },
	{ 0xF3FA, 0xE892B8 },
	{ 0xEDB6, 0xE892BB },
	{ 0xF4EF, 0xE892BC },
	{ 0xF8DA, 0xE892BF },
	{ 0xEBE0, 0xE89380 },
	{ 0xE7AC, 0xE89382 },
	{ 0xF5EB, 0xE89384 },
	{ 0xEB46, 0xE89386 },
	{ 0xEFC8, 0xE89389 },
	{ 0xE0CF, 0xE8938B },
	{ 0xECC9, 0xE8938D },
	{ 0xEA7E, 0xE89391 },
	{ 0xEC4E, 0xE8939A },
	{ 0xE991, 0xE893AC },
	{ 0xE635, 0xE893AE },
	{ 0xEC93, 0xE893B4 },
	{ 0xE6A0, 0xE893BC },
	{ 0xE7A1, 0xE89491 },
	{ 0xE750, 0xE89493 },
	{ 0xE96B, 0xE89494 },
	{ 0xF1BD, 0xE89497 },
	{ 0xEAB8, 0xE89498 },
	{ 0xF035, 0xE8949A },
	{ 0xE6AD, 0xE8949E },
	{ 0xF4F9, 0xE894A1 },
	{ 0xF1F8, 0xE894A3 },
	{ 0xF5C7, 0xE894A5 },
	{ 0xEBCA, 0xE894AC },
	{ 0xF0E3, 0xE894AD },
	{ 0xF46E, 0xE894AF },
	{ 0xF75C, 0xE894BD },
	{ 0xF069, 0xE894BF },
	{ 0xE4C6, 0xE89581 },
	{ 0xE8E6, 0xE89583 },
	{ 0xF5AF, 0xE89589 },
	{ 0xE292, 0xE8958E },
	{ 0xEFFE, 0xE89593 },
	{ 0xF8B6, 0xE89599 },
	{ 0xEC94, 0xE895A3 },
	{ 0xE2F2, 0xE895A8 },
	{ 0xF6B9, 0xE895A9 },
	{ 0xE7F3, 0xE895AA },
	{ 0xEBCB, 0xE895AD },
	{ 0xE86D, 0xE89684 },
	{ 0xE849, 0xE89687 },
	{ 0xF0FB, 0xE8968F },
	{ 0xE0B9, 0xE89691 },
	{ 0xF1F9, 0xE89694 },
	{ 0xEB70, 0xE8969B },
	{ 0xF550, 0xE896A6 },
	{ 0xF9BC, 0xE896A8 },
	{ 0xEAB1, 0xE896A9 },
	{ 0xECEF, 0xE896AA },
	{ 0xEB33, 0xE896AF },
	{ 0xF9B9, 0xE896B0 },
	{ 0xF341, 0xE896BA },
	{ 0xE1CB, 0xE89781 },
	{ 0xF1BE, 0xE89789 },
	{ 0xE5C0, 0xE8978D },
	{ 0xECF0, 0xE8978E },
	{ 0xF1FA, 0xE8978F },
	{ 0xEFE4, 0xE89795 },
	{ 0xE5ED, 0xE8979C },
	{ 0xEEDD, 0xE8979D },
	{ 0xE598, 0xE897A4 },
	{ 0xEDB7, 0xE897A5 },
	{ 0xE8E7, 0xE897A9 },
	{ 0xEC4F, 0xE897AA },
	{ 0xF25B, 0xE897B7 },
	{ 0xE6F4, 0xE897BA },
	{ 0xF36D, 0xE897BB },
	{ 0xE23B, 0xE897BF },
	{ 0xEEDE, 0xE89882 },
	{ 0xE666, 0xE89886 },
	{ 0xEBCC, 0xE89887 },
	{ 0xEF43, 0xE8988A },
	{ 0xEDEE, 0xE89896 },
	{ 0xE932, 0xE89897 },
	{ 0xEB60, 0xE8989A },
	{ 0xE5B5, 0xE898AD },
	{ 0xE5A1, 0xE898BF },
	{ 0xF8DB, 0xE8998E },
	{ 0xF7CB, 0xE89990 },
	{ 0xE0F3, 0xE89994 },
	{ 0xF535, 0xE89995 },
	{ 0xF858, 0xE8999B },
	{ 0xE667, 0xE8999C },
	{ 0xEFE5, 0xE8999E },
	{ 0xF8DC, 0xE8999F },
	{ 0xF9D0, 0xE899A7 },
	{ 0xF8F6, 0xE899B9 },
	{ 0xE835, 0xE89A8A },
	{ 0xE8BD, 0xE89A8C },
	{ 0xF172, 0xE89A93 },
	{ 0xE1F7, 0xE89AA3 },
	{ 0xF36E, 0xE89AA4 },
	{ 0xF659, 0xE89AA9 },
	{ 0xEA91, 0xE89B87 },
	{ 0xE4B1, 0xE89B8B },
	{ 0xF97E, 0xE89B94 },
	{ 0xEF53, 0xE89B99 },
	{ 0xF3C8, 0xE89B9B },
	{ 0xE293, 0xE89B9F },
	{ 0xF7ED, 0xE89BA4 },
	{ 0xF496, 0xE89BAD },
	{ 0xED46, 0xE89BBE },
	{ 0xF5B9, 0xE89C80 },
	{ 0xE992, 0xE89C82 },
	{ 0xECF1, 0xE89C83 },
	{ 0xEF35, 0xE89C88 },
	{ 0xF44B, 0xE89C98 },
	{ 0xEA34, 0xE89C9A },
	{ 0xE85C, 0xE89C9C },
	{ 0xE079, 0xE89D8E },
	{ 0xECDA, 0xE89D95 },
	{ 0xF969, 0xE89D97 },
	{ 0xF06A, 0xE89D9F },
	{ 0xF7C4, 0xE89DA6 },
	{ 0xECA4, 0xE89DA8 },
	{ 0xF8DD, 0xE89DB4 },
	{ 0xF2CA, 0xE89DB6 },
	{ 0xEF54, 0xE89DB8 },
	{ 0xE5CC, 0xE89E82 },
	{ 0xF0D7, 0xE89E8D },
	{ 0xE7AD, 0xE89E9F },
	{ 0xF8AB, 0xE89EA2 },
	{ 0xE4D9, 0xE89EB3 },
	{ 0xE5A2, 0xE89EBA },
	{ 0xF66E, 0xE89F84 },
	{ 0xE898, 0xE89FA0 },
	{ 0xEB61, 0xE89FAC },
	{ 0xEFA8, 0xE89FAF },
	{ 0xF5F9, 0xE89FB2 },
	{ 0xF83F, 0xE89FB9 },
	{ 0xF0FC, 0xE89FBB },
	{ 0xEB7A, 0xE89FBE },
	{ 0xECB2, 0xE8A085 },
	{ 0xE5C5, 0xE8A09F },
	{ 0xF3E3, 0xE8A0A2 },
	{ 0xE5EE, 0xE8A0A3 },
	{ 0xE1CC, 0xE8A0B1 },
	{ 0xF1D9, 0xE8A0B6 },
	{ 0xE751, 0xE8A0BB },
	{ 0xF87C, 0xE8A180 },
	{ 0xF3EB, 0xE8A186 },
	{ 0xF84C, 0xE8A18C },
	{ 0xEE72, 0xE8A18D },
	{ 0xF875, 0xE8A192 },
	{ 0xEC9C, 0xE8A193 },
	{ 0xE046, 0xE8A197 },
	{ 0xED47, 0xE8A199 },
	{ 0xF06B, 0xE8A19B },
	{ 0xF5FA, 0xE8A19D },
	{ 0xF8AC, 0xE8A1A1 },
	{ 0xE2C3, 0xE8A1A2 },
	{ 0xF0FD, 0xE8A1A3 },
	{ 0xF79C, 0xE8A1A8 },
	{ 0xEAB9, 0xE8A1AB },
	{ 0xEBF1, 0xE8A1B0 },
	{ 0xE434, 0xE8A1B2 },
	{ 0xF5FB, 0xE8A1B7 },
	{ 0xE36A, 0xE8A1BE },
	{ 0xE36B, 0xE8A1BF },
	{ 0xF04E, 0xE8A281 },
	{ 0xE7B1, 0xE8A282 },
	{ 0xE047, 0xE8A288 },
	{ 0xE4E7, 0xE8A28B },
	{ 0xF775, 0xE8A28D },
	{ 0xE4B2, 0xE8A292 },
	{ 0xEC50, 0xE8A296 },
	{ 0xF46F, 0xE8A297 },
	{ 0xE1E5, 0xE8A29E },
	{ 0xF7AC, 0xE8A2AB },
	{ 0xE1CD, 0xE8A2B4 },
	{ 0xF23E, 0xE8A381 },
	{ 0xE63E, 0xE8A382 },
	{ 0xE6EA, 0xE8A38F },
	{ 0xEEE0, 0xE8A394 },
	{ 0xF0AE, 0xE8A395 },
	{ 0xE2D9, 0xE8A399 },
	{ 0xE95D, 0xE8A39C },
	{ 0xF1FB, 0xE8A39D },
	{ 0xEA92, 0xE8A39F },
	{ 0xE6EB, 0xE8A3A1 },
	{ 0xEA35, 0xE8A3A8 },
	{ 0xEAD7, 0xE8A3B3 },
	{ 0xE8D0, 0xE8A3B4 },
	{ 0xE8D1, 0xE8A3B5 },
	{ 0xE5A3, 0xE8A3B8 },
	{ 0xF342, 0xE8A3BD },
	{ 0xE96C, 0xE8A487 },
	{ 0xE078, 0xE8A490 },
	{ 0xF776, 0xE8A492 },
	{ 0xE95E, 0xE8A493 },
	{ 0xF06C, 0xE8A498 },
	{ 0xE8D2, 0xE8A499 },
	{ 0xEFB3, 0xE8A4A5 },
	{ 0xF6DB, 0xE8A4AA },
	{ 0xECA8, 0xE8A4B6 },
	{ 0xE6AE, 0xE8A4B8 },
	{ 0xEB71, 0xE8A4BB },
	{ 0xE0BA, 0xE8A581 },
	{ 0xEDD1, 0xE8A584 },
	{ 0xE36C, 0xE8A59F },
	{ 0xE5C1, 0xE8A5A4 },
	{ 0xE75A, 0xE8A5AA },
	{ 0xECA9, 0xE8A5B2 },
	{ 0xEB34, 0xE8A5BF },
	{ 0xEFA9, 0xE8A681 },
	{ 0xE4C7, 0xE8A683 },
	{ 0xE96D, 0xE8A686 },
	{ 0xF73E, 0xE8A687 },
	{ 0xE148, 0xE8A68B },
	{ 0xE33E, 0xE8A68F },
	{ 0xE794, 0xE8A693 },
	{ 0xECCA, 0xE8A696 },
	{ 0xE13F, 0xE8A6A1 },
	{ 0xE53D, 0xE8A6A9 },
	{ 0xF661, 0xE8A6AA },
	{ 0xE35C, 0xE8A6B2 },
	{ 0xE056, 0xE8A6BA },
	{ 0xE5C2, 0xE8A6BD },
	{ 0xE24A, 0xE8A780 },
	{ 0xE057, 0xE8A792 },
	{ 0xF840, 0xE8A7A3 },
	{ 0xEAD8, 0xE8A7B4 },
	{ 0xF5BA, 0xE8A7B8 },
	{ 0xEDEB, 0xE8A880 },
	{ 0xF2F4, 0xE8A882 },
	{ 0xE9B5, 0xE8A883 },
	{ 0xE1AA, 0xE8A888 },
	{ 0xECF2, 0xE8A88A },
	{ 0xF8F7, 0xE8A88C },
	{ 0xF6D0, 0xE8A88E },
	{ 0xF9BA, 0xE8A893 },
	{ 0xF9E1, 0xE8A896 },
	{ 0xF6A0, 0xE8A897 },
	{ 0xE3C0, 0xE8A898 },
	{ 0xEF55, 0xE8A89B },
	{ 0xED48, 0xE8A89D },
	{ 0xEBE8, 0xE8A89F },
	{ 0xE151, 0xE8A8A3 },
	{ 0xE47D, 0xE8A8A5 },
	{ 0xE8BE, 0xE8A8AA },
	{ 0xEB72, 0xE8A8AD },
	{ 0xF859, 0xE8A8B1 },
	{ 0xEBCD, 0xE8A8B4 },
	{ 0xE048, 0xE8A8B6 },
	{ 0xF470, 0xE8A8BA },
	{ 0xF3C9, 0xE8A8BB },
	{ 0xEA93, 0xE8A990 },
	{ 0xF36F, 0xE8A994 },
	{ 0xF754, 0xE8A995 },
	{ 0xF25C, 0xE8A99B },
	{ 0xEA94, 0xE8A99E },
	{ 0xEEC9, 0xE8A9A0 },
	{ 0xEC95, 0xE8A9A2 },
	{ 0xEEE1, 0xE8A9A3 },
	{ 0xECCB, 0xE8A9A6 },
	{ 0xECCC, 0xE8A9A9 },
	{ 0xE2F8, 0xE8A9AD },
	{ 0xF2AC, 0xE8A9AE },
	{ 0xF9FE, 0xE8A9B0 },
	{ 0xF935, 0xE8A9B1 },
	{ 0xF841, 0xE8A9B2 },
	{ 0xEAD9, 0xE8A9B3 },
	{ 0xEB62, 0xE8A9B5 },
	{ 0xF56A, 0xE8A9B9 },
	{ 0xF3CA, 0xE8AA85 },
	{ 0xE233, 0xE8AA87 },
	{ 0xF44C, 0xE8AA8C },
	{ 0xF173, 0xE8AA8D },
	{ 0xEB35, 0xE8AA93 },
	{ 0xF6AB, 0xE8AA95 },
	{ 0xF0AF, 0xE8AA98 },
	{ 0xEDDE, 0xE8AA9E },
	{ 0xEBA4, 0xE8AAA0 },
	{ 0xE1AB, 0xE8AAA1 },
	{ 0xE7F4, 0xE8AAA3 },
	{ 0xEF36, 0xE8AAA4 },
	{ 0xE1CE, 0xE8AAA5 },
	{ 0xEBE9, 0xE8AAA6 },
	{ 0xF991, 0xE8AAA8 },
	{ 0xEB73, 0xE8AAAA },
	{ 0xEC51, 0xE8AAB0 },
	{ 0xE234, 0xE8AAB2 },
	{ 0xEA36, 0xE8AAB9 },
	{ 0xF0FE, 0xE8AABC },
	{ 0xF0DD, 0xE8AABE },
	{ 0xF370, 0xE8AABF },
	{ 0xF56B, 0xE8AB82 },
	{ 0xEC96, 0xE8AB84 },
	{ 0xE4C8, 0xE8AB87 },
	{ 0xF57B, 0xE8AB8B },
	{ 0xF245, 0xE8AB8D },
	{ 0xF5D8, 0xE8AB8F },
	{ 0xE5DF, 0xE8AB92 },
	{ 0xE675, 0xE8AB96 },
	{ 0xF0B0, 0xE8AB9B },
	{ 0xF573, 0xE8AB9C },
	{ 0xECCD, 0xE8ABA1 },
	{ 0xF596, 0xE8ABA6 },
	{ 0xF842, 0xE8ABA7 },
	{ 0xF2F5, 0xE8ABAA },
	{ 0xE06F, 0xE8ABAB },
	{ 0xF0B1, 0xE8ABAD },
	{ 0xF1BF, 0xE8ABAE },
	{ 0xF9C9, 0xE8ABB1 },
	{ 0xED36, 0xE8ABB6 },
	{ 0xF7A4, 0xE8ABB7 },
	{ 0xF343, 0xE8ABB8 },
	{ 0xEDEC, 0xE8ABBA },
	{ 0xE3E7, 0xE8ABBE },
	{ 0xE7C7, 0xE8AC80 },
	{ 0xED67, 0xE8AC81 },
	{ 0xF06D, 0xE8AC82 },
	{ 0xE599, 0xE8AC84 },
	{ 0xE84A, 0xE8AC8E },
	{ 0xE85D, 0xE8AC90 },
	{ 0xF7CC, 0xE8AC94 },
	{ 0xEBDA, 0xE8AC96 },
	{ 0xE8BF, 0xE8AC97 },
	{ 0xE155, 0xE8AC99 },
	{ 0xF160, 0xE8AC9A },
	{ 0xE0BB, 0xE8AC9B },
	{ 0xEA95, 0xE8AC9D },
	{ 0xEFAA, 0xE8ACA0 },
	{ 0xE7C8, 0xE8ACA8 },
	{ 0xF273, 0xE8ACAB },
	{ 0xE6BD, 0xE8ACAC },
	{ 0xE2C4, 0xE8ACB3 },
	{ 0xE35D, 0xE8ACB9 },
	{ 0xF936, 0xE8AD81 },
	{ 0xF3FB, 0xE8AD89 },
	{ 0xF9D2, 0xE8AD8E },
	{ 0xE3C1, 0xE8AD8F },
	{ 0xECDB, 0xE8AD98 },
	{ 0xE4C9, 0xE8AD9A },
	{ 0xE95F, 0xE8AD9C },
	{ 0xE17D, 0xE8ADA6 },
	{ 0xEA37, 0xE8ADAC },
	{ 0xEE4B, 0xE8ADAF },
	{ 0xF131, 0xE8ADB0 },
	{ 0xE149, 0xE8ADB4 },
	{ 0xF8DE, 0xE8ADB7 },
	{ 0xEEE2, 0xE8ADBD },
	{ 0xE551, 0xE8AE80 },
	{ 0xE938, 0xE8AE8A },
	{ 0xEC52, 0xE8AE90 },
	{ 0xF4D8, 0xE8AE92 },
	{ 0xEDD3, 0xE8AE93 },
	{ 0xF4D9, 0xE8AE96 },
	{ 0xF4C6, 0xE8AE9A },
	{ 0xE1DB, 0xE8B0B7 },
	{ 0xE1AC, 0xE8B0BF },
	{ 0xF953, 0xE8B181 },
	{ 0xE577, 0xE8B186 },
	{ 0xE3C2, 0xE8B188 },
	{ 0xF7A5, 0xE8B18A },
	{ 0xEF65, 0xE8B18C },
	{ 0xECCE, 0xE8B195 },
	{ 0xE55A, 0xE8B19A },
	{ 0xEADA, 0xE8B1A1 },
	{ 0xF8DF, 0xE8B1AA },
	{ 0xEEE3, 0xE8B1AB },
	{ 0xF79D, 0xE8B1B9 },
	{ 0xECCF, 0xE8B1BA },
	{ 0xF5B0, 0xE8B282 },
	{ 0xE777, 0xE8B28A },
	{ 0xE7C9, 0xE8B28C },
	{ 0xF73F, 0xE8B29D },
	{ 0xF2F6, 0xE8B29E },
	{ 0xE9B6, 0xE8B2A0 },
	{ 0xF23F, 0xE8B2A1 },
	{ 0xE1F8, 0xE8B2A2 },
	{ 0xEA48, 0xE8B2A7 },
	{ 0xF937, 0xE8B2A8 },
	{ 0xF6FC, 0xE8B2A9 },
	{ 0xF6B1, 0xE8B2AA },
	{ 0xE24B, 0xE8B2AB },
	{ 0xF531, 0xE8B2AC },
	{ 0xF25D, 0xE8B2AF },
	{ 0xEBAE, 0xE8B2B0 },
	{ 0xF153, 0xE8B2B3 },
	{ 0xE2FE, 0xE8B2B4 },
	{ 0xF74F, 0xE8B2B6 },
	{ 0xE772, 0xE8B2B7 },
	{ 0xE4E8, 0xE8B2B8 },
	{ 0xEA38, 0xE8B2BB },
	{ 0xF574, 0xE8B2BC },
	{ 0xF152, 0xE8B2BD },
	{ 0xE7F5, 0xE8B2BF },
	{ 0xF7C5, 0xE8B380 },
	{ 0xE9D3, 0xE8B381 },
	{ 0xE693, 0xE8B382 },
	{ 0xF19E, 0xE8B383 },
	{ 0xF992, 0xE8B384 },
	{ 0xF1C0, 0xE8B387 },
	{ 0xE049, 0xE8B388 },
	{ 0xF274, 0xE8B38A },
	{ 0xF471, 0xE8B391 },
	{ 0xEA49, 0xE8B393 },
	{ 0xE694, 0xE8B39A },
	{ 0xEA96, 0xE8B39C },
	{ 0xEADB, 0xE8B39E },
	{ 0xE8D3, 0xE8B3A0 },
	{ 0xF877, 0xE8B3A2 },
	{ 0xE773, 0xE8B3A3 },
	{ 0xF551, 0xE8B3A4 },
	{ 0xE9B7, 0xE8B3A6 },
	{ 0xF497, 0xE8B3AA },
	{ 0xE53E, 0xE8B3AD },
	{ 0xE695, 0xE8B3B4 },
	{ 0xE9B8, 0xE8B3BB },
	{ 0xE2C5, 0xE8B3BC },
	{ 0xEADF, 0xE8B3BD },
	{ 0xF44E, 0xE8B484 },
	{ 0xF631, 0xE8B485 },
	{ 0xF0CB, 0xE8B487 },
	{ 0xF3FC, 0xE8B488 },
	{ 0xF4C7, 0xE8B48A },
	{ 0xEB7B, 0xE8B48D },
	{ 0xF1FC, 0xE8B493 },
	{ 0xEBDB, 0xE8B496 },
	{ 0xF275, 0xE8B5A4 },
	{ 0xEA97, 0xE8B5A6 },
	{ 0xF863, 0xE8B5AB },
	{ 0xF3CB, 0xE8B5B0 },
	{ 0xE33F, 0xE8B5B3 },
	{ 0xE9B9, 0xE8B5B4 },
	{ 0xE3C3, 0xE8B5B7 },
	{ 0xF5B1, 0xE8B685 },
	{ 0xF056, 0xE8B68A },
	{ 0xF371, 0xE8B699 },
	{ 0xF63C, 0xE8B6A3 },
	{ 0xF5D9, 0xE8B6A8 },
	{ 0xF37B, 0xE8B6B3 },
	{ 0xE9BA, 0xE8B6BA },
	{ 0xF44F, 0xE8B6BE },
	{ 0xF6C5, 0xE8B786 },
	{ 0xE8A2, 0xE8B78B },
	{ 0xF498, 0xE8B78C },
	{ 0xE04A, 0xE8B78F },
	{ 0xF6F5, 0xE8B79B },
	{ 0xE0E5, 0xE8B79D },
	{ 0xF276, 0xE8B7A1 },
	{ 0xEB63, 0xE8B7A3 },
	{ 0xE235, 0xE8B7A8 },
	{ 0xE668, 0xE8B7AF },
	{ 0xE53F, 0xE8B7B3 },
	{ 0xEFC9, 0xE8B88A },
	{ 0xE4CE, 0xE8B88F },
	{ 0xF552, 0xE8B890 },
	{ 0xE0E6, 0xE8B89E },
	{ 0xF3A1, 0xE8B8AA },
	{ 0xF0B2, 0xE8B8B0 },
	{ 0xF3A2, 0xE8B8B5 },
	{ 0xF0B3, 0xE8B982 },
	{ 0xF344, 0xE8B984 },
	{ 0xE0F4, 0xE8B987 },
	{ 0xE540, 0xE8B988 },
	{ 0xF4B2, 0xE8B989 },
	{ 0xF8B7, 0xE8B98A },
	{ 0xF5EC, 0xE8B999 },
	{ 0xF277, 0xE8B99F },
	{ 0xF542, 0xE8B9A0 },
	{ 0xF5ED, 0xE8B9B4 },
	{ 0xE2F3, 0xE8B9B6 },
	{ 0xF372, 0xE8BA81 },
	{ 0xF25E, 0xE8BA87 },
	{ 0xF3CC, 0xE8BA8A },
	{ 0xEDB8, 0xE8BA8D },
	{ 0xE6F5, 0xE8BAAA },
	{ 0xECF3, 0xE8BAAB },
	{ 0xE2E5, 0xE8BAAC },
	{ 0xE2C6, 0xE8BB80 },
	{ 0xF4B3, 0xE8BB8A },
	{ 0xED68, 0xE8BB8B },
	{ 0xE2F9, 0xE8BB8C },
	{ 0xE2DA, 0xE8BB8D },
	{ 0xF85D, 0xE8BB92 },
	{ 0xEE73, 0xE8BB9F },
	{ 0xF472, 0xE8BBAB },
	{ 0xF5EE, 0xE8BBB8 },
	{ 0xE04B, 0xE8BBBB },
	{ 0xECDC, 0xE8BBBE },
	{ 0xE294, 0xE8BC83 },
	{ 0xE669, 0xE8BC85 },
	{ 0xF240, 0xE8BC89 },
	{ 0xF575, 0xE8BC92 },
	{ 0xE752, 0xE8BC93 },
	{ 0xE960, 0xE8BC94 },
	{ 0xE17E, 0xE8BC95 },
	{ 0xE5E0, 0xE8BC9B },
	{ 0xF65A, 0xE8BC9C },
	{ 0xF9CA, 0xE8BC9D },
	{ 0xE766, 0xE8BC9E },
	{ 0xF55F, 0xE8BC9F },
	{ 0xE636, 0xE8BCA6 },
	{ 0xE94E, 0xE8BCA7 },
	{ 0xE8D4, 0xE8BCA9 },
	{ 0xE6C7, 0xE8BCAA },
	{ 0xF4A0, 0xE8BCAF },
	{ 0xF3CD, 0xE8BCB3 },
	{ 0xEC53, 0xE8BCB8 },
	{ 0xE96E, 0xE8BCB9 },
	{ 0xE96F, 0xE8BCBB },
	{ 0xF2AD, 0xE8BCBE },
	{ 0xEE3B, 0xE8BCBF },
	{ 0xF7DD, 0xE8BD84 },
	{ 0xF04F, 0xE8BD85 },
	{ 0xF2AE, 0xE8BD89 },
	{ 0xF560, 0xE8BD8D },
	{ 0xE295, 0xE8BD8E },
	{ 0xEE3C, 0xE8BD9D },
	{ 0xE26E, 0xE8BD9F },
	{ 0xE5F9, 0xE8BDA2 },
	{ 0xECF4, 0xE8BE9B },
	{ 0xE1D0, 0xE8BE9C },
	{ 0xE5B8, 0xE8BEA3 },
	{ 0xF6FD, 0xE8BEA6 },
	{ 0xE939, 0xE8BEA8 },
	{ 0xEA98, 0xE8BEAD },
	{ 0xE93A, 0xE8BEAF },
	{ 0xF473, 0xE8BEB0 },
	{ 0xEFB4, 0xE8BEB1 },
	{ 0xE46C, 0xE8BEB2 },
	{ 0xEFE6, 0xE8BF82 },
	{ 0xECF6, 0xE8BF85 },
	{ 0xEECA, 0xE8BF8E },
	{ 0xE35E, 0xE8BF91 },
	{ 0xE899, 0xE8BF94 },
	{ 0xE04C, 0xE8BFA6 },
	{ 0xF278, 0xE8BFAA },
	{ 0xE86E, 0xE8BFAB },
	{ 0xF499, 0xE8BFAD },
	{ 0xEC9D, 0xE8BFB0 },
	{ 0xE136, 0xE8BFB2 },
	{ 0xE84B, 0xE8BFB7 },
	{ 0xF279, 0xE8BFB9 },
	{ 0xF5DA, 0xE8BFBD },
	{ 0xF6DC, 0xE98080 },
	{ 0xEBEA, 0xE98081 },
	{ 0xE251, 0xE98082 },
	{ 0xE541, 0xE98083 },
	{ 0xF9B1, 0xE98085 },
	{ 0xEE4D, 0xE98086 },
	{ 0xF8AD, 0xE98088 },
	{ 0xF777, 0xE9808B },
	{ 0xEBCE, 0xE9808D },
	{ 0xF6E2, 0xE9808F },
	{ 0xF5EF, 0xE98090 },
	{ 0xE2C7, 0xE98091 },
	{ 0xE542, 0xE98094 },
	{ 0xE191, 0xE98095 },
	{ 0xE578, 0xE98097 },
	{ 0xF25F, 0xE98099 },
	{ 0xF6D7, 0xE9809A },
	{ 0xEB36, 0xE9809D },
	{ 0xE651, 0xE9809E },
	{ 0xEBDC, 0xE9809F },
	{ 0xF373, 0xE980A0 },
	{ 0xF3E4, 0xE980A1 },
	{ 0xE993, 0xE980A2 },
	{ 0xE637, 0xE980A3 },
	{ 0xF597, 0xE980AE },
	{ 0xF3CE, 0xE980B1 },
	{ 0xF474, 0xE980B2 },
	{ 0xE340, 0xE980B5 },
	{ 0xF191, 0xE980B8 },
	{ 0xF7BA, 0xE980BC },
	{ 0xF0B5, 0xE980BE },
	{ 0xE57D, 0xE98181 },
	{ 0xEC54, 0xE98182 },
	{ 0xEFE7, 0xE98187 },
	{ 0xF0B4, 0xE9818A },
	{ 0xF031, 0xE9818B },
	{ 0xF74C, 0xE9818D },
	{ 0xE236, 0xE9818E },
	{ 0xF7C6, 0xE98190 },
	{ 0xF96A, 0xE98191 },
	{ 0xE543, 0xE98193 },
	{ 0xE4B9, 0xE98194 },
	{ 0xF06E, 0xE98195 },
	{ 0xEFAB, 0xE98199 },
	{ 0xEBE1, 0xE9819C },
	{ 0xE4CF, 0xE9819D },
	{ 0xF598, 0xE9819E },
	{ 0xF050, 0xE981A0 },
	{ 0xEBCF, 0xE981A1 },
	{ 0xE14A, 0xE981A3 },
	{ 0xF27A, 0xE981A9 },
	{ 0xF374, 0xE981AD },
	{ 0xF4B4, 0xE981AE },
	{ 0xE57E, 0xE981AF },
	{ 0xF450, 0xE981B2 },
	{ 0xF3E5, 0xE981B5 },
	{ 0xF553, 0xE981B7 },
	{ 0xEB64, 0xE981B8 },
	{ 0xF0B6, 0xE981BA },
	{ 0xE6A1, 0xE981BC },
	{ 0xE0E8, 0xE981BD },
	{ 0xF7AD, 0xE981BF },
	{ 0xEFAD, 0xE98280 },
	{ 0xE774, 0xE98281 },
	{ 0xF843, 0xE98282 },
	{ 0xEC55, 0xE98283 },
	{ 0xF94D, 0xE98284 },
	{ 0xF154, 0xE98287 },
	{ 0xE741, 0xE98288 },
	{ 0xE93B, 0xE9828A },
	{ 0xE5A4, 0xE9828F },
	{ 0xF0E9, 0xE98291 },
	{ 0xEF4B, 0xE98295 },
	{ 0xE767, 0xE98299 },
	{ 0xF8AE, 0xE982A2 },
	{ 0xE3E1, 0xE982A3 },
	{ 0xE8C0, 0xE982A6 },
	{ 0xF5BE, 0xE982A8 },
	{ 0xEA99, 0xE982AA },
	{ 0xE09D, 0xE982AF },
	{ 0xF6C6, 0xE982B0 },
	{ 0xE2C8, 0xE982B1 },
	{ 0xEBD0, 0xE982B5 },
	{ 0xF260, 0xE982B8 },
	{ 0xEFF4, 0xE98381 },
	{ 0xE296, 0xE9838A },
	{ 0xE5CD, 0xE9839E },
	{ 0xE2DB, 0xE983A1 },
	{ 0xE9BB, 0xE983A8 },
	{ 0xE23C, 0xE983AD },
	{ 0xEFE8, 0xE983B5 },
	{ 0xE544, 0xE983BD },
	{ 0xED57, 0xE98482 },
	{ 0xF5DB, 0xE98492 },
	{ 0xF851, 0xE98495 },
	{ 0xEA39, 0xE98499 },
	{ 0xE59A, 0xE984A7 },
	{ 0xF2F7, 0xE984AD },
	{ 0xE4B3, 0xE984B2 },
	{ 0xF0B7, 0xE98589 },
	{ 0xF2F8, 0xE9858A },
	{ 0xF5DC, 0xE9858B },
	{ 0xF1CC, 0xE9858C },
	{ 0xE8D5, 0xE9858D },
	{ 0xF3CF, 0xE9858E },
	{ 0xF3D0, 0xE98592 },
	{ 0xF5B2, 0xE985A2 },
	{ 0xE7AE, 0xE985A9 },
	{ 0xE5AC, 0xE985AA },
	{ 0xEC56, 0xE985AC },
	{ 0xF9A3, 0xE985B5 },
	{ 0xF8E5, 0xE985B7 },
	{ 0xEAAB, 0xE985B8 },
	{ 0xEC97, 0xE98687 },
	{ 0xF63D, 0xE98689 },
	{ 0xF5B3, 0xE9868B },
	{ 0xF345, 0xE9868D },
	{ 0xEBA5, 0xE98692 },
	{ 0xF5DD, 0xE9869C },
	{ 0xF132, 0xE986AB },
	{ 0xF1FD, 0xE986AC },
	{ 0xF5B4, 0xE986AE },
	{ 0xF8B8, 0xE986AF },
	{ 0xE8A3, 0xE986B1 },
	{ 0xE65A, 0xE986B4 },
	{ 0xE0D9, 0xE986B5 },
	{ 0xEDD4, 0xE98780 },
	{ 0xF4FA, 0xE98787 },
	{ 0xF0B8, 0xE98789 },
	{ 0xEB47, 0xE9878B },
	{ 0xE6EC, 0xE9878C },
	{ 0xF3EC, 0xE9878D },
	{ 0xEDAF, 0xE9878E },
	{ 0xE5E1, 0xE9878F },
	{ 0xE6ED, 0xE98790 },
	{ 0xE3D1, 0xE98791 },
	{ 0xEBF2, 0xE98797 },
	{ 0xF2F9, 0xE98798 },
	{ 0xE9BC, 0xE9879C },
	{ 0xF66C, 0xE9879D },
	{ 0xF375, 0xE987A3 },
	{ 0xF554, 0xE987A7 },
	{ 0xEFE9, 0xE987AA },
	{ 0xF4FB, 0xE987B5 },
	{ 0xE591, 0xE9888D },
	{ 0xE132, 0xE98890 },
	{ 0xF6FE, 0xE98891 },
	{ 0xEABC, 0xE98892 },
	{ 0xF0CD, 0xE98897 },
	{ 0xE347, 0xE9889E },
	{ 0xE652, 0xE988B4 },
	{ 0xEF3D, 0xE988BA },
	{ 0xF2AF, 0xE988BF },
	{ 0xE0A5, 0xE98980 },
	{ 0xE0E9, 0xE98985 },
	{ 0xF878, 0xE98989 },
	{ 0xE156, 0xE98997 },
	{ 0xEE77, 0xE9899B },
	{ 0xF057, 0xE9899E },
	{ 0xE8A4, 0xE989A2 },
	{ 0xE2C9, 0xE989A4 },
	{ 0xEC9E, 0xE989A5 },
	{ 0xF2FA, 0xE989A6 },
	{ 0xF0DE, 0xE98A80 },
	{ 0xF5C8, 0xE98A83 },
	{ 0xE56E, 0xE98A85 },
	{ 0xEB65, 0xE98A91 },
	{ 0xF2B0, 0xE98A93 },
	{ 0xEC57, 0xE98A96 },
	{ 0xE7AF, 0xE98A98 },
	{ 0xF7E7, 0xE98A9C },
	{ 0xEEE5, 0xE98AB3 },
	{ 0xE2CA, 0xE98AB6 },
	{ 0xEBD1, 0xE98AB7 },
	{ 0xEC58, 0xE98AB9 },
	{ 0xF2FB, 0xE98B8C },
	{ 0xF89B, 0xE98B8F },
	{ 0xE994, 0xE98B92 },
	{ 0xEB37, 0xE98BA4 },
	{ 0xF778, 0xE98BAA },
	{ 0xE0EA, 0xE98BB8 },
	{ 0xE0BC, 0xE98BBC },
	{ 0xE672, 0xE98C84 },
	{ 0xF5DE, 0xE98C90 },
	{ 0xF5DF, 0xE98C98 },
	{ 0xF246, 0xE98C9A },
	{ 0xEC98, 0xE98C9E },
	{ 0xE4CA, 0xE98C9F },
	{ 0xF2FC, 0xE98CA0 },
	{ 0xE3C4, 0xE98CA1 },
	{ 0xF2B1, 0xE98CA2 },
	{ 0xE3C5, 0xE98CA4 },
	{ 0xE36E, 0xE98CA6 },
	{ 0xE7E1, 0xE98CA8 },
	{ 0xEB48, 0xE98CAB },
	{ 0xE1D1, 0xE98CAE },
	{ 0xF4B9, 0xE98CAF },
	{ 0xEECC, 0xE98D88 },
	{ 0xE638, 0xE98D8A },
	{ 0xE237, 0xE98D8B },
	{ 0xE545, 0xE98D8D },
	{ 0xED58, 0xE98D94 },
	{ 0xE4B4, 0xE98D9B },
	{ 0xF0B9, 0xE98DAE },
	{ 0xE0F5, 0xE98DB5 },
	{ 0xF66D, 0xE98DBC },
	{ 0xF3A3, 0xE98DBE },
	{ 0xE157, 0xE98E8C },
	{ 0xEFCA, 0xE98E94 },
	{ 0xEBF0, 0xE98E96 },
	{ 0xF5E0, 0xE98E9A },
	{ 0xF8AF, 0xE98EA3 },
	{ 0xE0D1, 0xE98EA7 },
	{ 0xF8E0, 0xE98EAC },
	{ 0xF475, 0xE98EAD },
	{ 0xF192, 0xE98EB0 },
	{ 0xF37C, 0xE98F83 },
	{ 0xF27B, 0xE98F91 },
	{ 0xEFCB, 0xE98F9E },
	{ 0xE192, 0xE98FA1 },
	{ 0xE6AF, 0xE98FA4 },
	{ 0xF4A1, 0xE98FB6 },
	{ 0xF997, 0xE99084 },
	{ 0xF3A4, 0xE99098 },
	{ 0xEB66, 0xE990A5 },
	{ 0xF2B2, 0xE990AB },
	{ 0xF561, 0xE990B5 },
	{ 0xF6A1, 0xE990B8 },
	{ 0xF3D1, 0xE99184 },
	{ 0xE09E, 0xE99191 },
	{ 0xE09F, 0xE99192 },
	{ 0xE25E, 0xE9919B },
	{ 0xF4C8, 0xE991BD },
	{ 0xF4BA, 0xE991BF },
	{ 0xF1FE, 0xE995B7 },
	{ 0xE836, 0xE99680 },
	{ 0xEB7C, 0xE99683 },
	{ 0xF75D, 0xE99689 },
	{ 0xE0D2, 0xE9968B },
	{ 0xF0CE, 0xE9968F },
	{ 0xF7D8, 0xE99691 },
	{ 0xF7D9, 0xE99692 },
	{ 0xE070, 0xE99693 },
	{ 0xE85A, 0xE99694 },
	{ 0xE0A6, 0xE99698 },
	{ 0xE058, 0xE996A3 },
	{ 0xF7EE, 0xE996A4 },
	{ 0xE8EC, 0xE996A5 },
	{ 0xE341, 0xE996A8 },
	{ 0xE5EF, 0xE996AD },
	{ 0xEE95, 0xE996B1 },
	{ 0xEEA2, 0xE996BB },
	{ 0xED69, 0xE996BC },
	{ 0xED71, 0xE99787 },
	{ 0xF954, 0xE9978A },
	{ 0xF7EF, 0xE99794 },
	{ 0xE2F4, 0xE99795 },
	{ 0xF6E6, 0xE99796 },
	{ 0xE24C, 0xE9979C },
	{ 0xF555, 0xE997A1 },
	{ 0xE933, 0xE997A2 },
	{ 0xE9BD, 0xE9989C },
	{ 0xF556, 0xE998A1 },
	{ 0xF731, 0xE998AA },
	{ 0xEF66, 0xE998AE },
	{ 0xE8C1, 0xE998B2 },
	{ 0xF376, 0xE998BB },
	{ 0xED49, 0xE998BF },
	{ 0xF67D, 0xE99980 },
	{ 0xF7AE, 0xE99982 },
	{ 0xE9BE, 0xE99984 },
	{ 0xE6B0, 0xE9998B },
	{ 0xE778, 0xE9998C },
	{ 0xE0BD, 0xE9998D },
	{ 0xF7DA, 0xE99990 },
	{ 0xF75E, 0xE9999B },
	{ 0xF7F0, 0xE9999C },
	{ 0xEB7D, 0xE9999D },
	{ 0xECB3, 0xE9999E },
	{ 0xF543, 0xE9999F },
	{ 0xF052, 0xE999A2 },
	{ 0xF476, 0xE999A3 },
	{ 0xF346, 0xE999A4 },
	{ 0xE8D6, 0xE999AA },
	{ 0xF0E4, 0xE999B0 },
	{ 0xF477, 0xE999B3 },
	{ 0xE6D5, 0xE999B5 },
	{ 0xE546, 0xE999B6 },
	{ 0xF7E8, 0xE999B7 },
	{ 0xE6C1, 0xE999B8 },
	{ 0xEDD5, 0xE999BD },
	{ 0xEFEA, 0xE99A85 },
	{ 0xE6CC, 0xE99A86 },
	{ 0xE4E9, 0xE99A8A },
	{ 0xEC59, 0xE99A8B },
	{ 0xF96B, 0xE99A8D },
	{ 0xE1AD, 0xE99A8E },
	{ 0xE140, 0xE99A94 },
	{ 0xF032, 0xE99A95 },
	{ 0xED98, 0xE99A98 },
	{ 0xE350, 0xE99A99 },
	{ 0xF347, 0xE99A9B },
	{ 0xF231, 0xE99A9C },
	{ 0xE6F6, 0xE99AA3 },
	{ 0xEC5A, 0xE99AA7 },
	{ 0xEC5B, 0xE99AA8 },
	{ 0xF85F, 0xE99AAA },
	{ 0xF0DF, 0xE99AB1 },
	{ 0xE65B, 0xE99AB7 },
	{ 0xF544, 0xE99ABB },
	{ 0xF1CD, 0xE99B80 },
	{ 0xED62, 0xE99B81 },
	{ 0xF039, 0xE99B84 },
	{ 0xED4A, 0xE99B85 },
	{ 0xF4A2, 0xE99B86 },
	{ 0xE1D2, 0xE99B87 },
	{ 0xF65B, 0xE99B89 },
	{ 0xF3E6, 0xE99B8B },
	{ 0xF1C1, 0xE99B8C },
	{ 0xEF4C, 0xE99B8D },
	{ 0xF261, 0xE99B8E },
	{ 0xF377, 0xE99B95 },
	{ 0xEC5C, 0xE99B96 },
	{ 0xED3A, 0xE99B99 },
	{ 0xF5E1, 0xE99B9B },
	{ 0xF1DA, 0xE99B9C },
	{ 0xE6EE, 0xE99BA2 },
	{ 0xE3F1, 0xE99BA3 },
	{ 0xEFEB, 0xE99BA8 },
	{ 0xEFEC, 0xE99BA9 },
	{ 0xEB74, 0xE99BAA },
	{ 0xE837, 0xE99BAF },
	{ 0xE9D4, 0xE99BB0 },
	{ 0xF033, 0xE99BB2 },
	{ 0xE653, 0xE99BB6 },
	{ 0xE696, 0xE99BB7 },
	{ 0xE86F, 0xE99BB9 },
	{ 0xF2B3, 0xE99BBB },
	{ 0xEC5D, 0xE99C80 },
	{ 0xF2FD, 0xE99C86 },
	{ 0xF478, 0xE99C87 },
	{ 0xF2C5, 0xE99C91 },
	{ 0xEEE7, 0xE99C93 },
	{ 0xE6FD, 0xE99C96 },
	{ 0xEECE, 0xE99C99 },
	{ 0xEADC, 0xE99C9C },
	{ 0xF7C7, 0xE99C9E },
	{ 0xE7F6, 0xE99CA7 },
	{ 0xEAAC, 0xE99CB0 },
	{ 0xE66A, 0xE99CB2 },
	{ 0xE934, 0xE99CB9 },
	{ 0xF348, 0xE99CBD },
	{ 0xE5FA, 0xE99D82 },
	{ 0xED99, 0xE99D84 },
	{ 0xE654, 0xE99D88 },
	{ 0xF57C, 0xE99D91 },
	{ 0xF2FE, 0xE99D96 },
	{ 0xF331, 0xE99D9C },
	{ 0xEA3A, 0xE99D9E },
	{ 0xE84C, 0xE99DA1 },
	{ 0xE79E, 0xE99DA2 },
	{ 0xF864, 0xE99DA9 },
	{ 0xF175, 0xE99DAD },
	{ 0xF938, 0xE99DB4 },
	{ 0xF176, 0xE99DB7 },
	{ 0xE75B, 0xE99DBA },
	{ 0xF8B9, 0xE99E8B },
	{ 0xED63, 0xE99E8D },
	{ 0xE1F9, 0xE99E8F },
	{ 0xE2D3, 0xE99EA0 },
	{ 0xE07A, 0xE99EA8 },
	{ 0xE2D4, 0xE99EAB },
	{ 0xF74D, 0xE99EAD },
	{ 0xF557, 0xE99F86 },
	{ 0xF06F, 0xE99F8B },
	{ 0xF7DB, 0xE99F93 },
	{ 0xE547, 0xE99F9C },
	{ 0xF0E5, 0xE99FB3 },
	{ 0xEBD2, 0xE99FB6 },
	{ 0xF034, 0xE99FBB },
	{ 0xF852, 0xE99FBF },
	{ 0xF8E1, 0xE9A080 },
	{ 0xF87D, 0xE9A081 },
	{ 0xF332, 0xE9A082 },
	{ 0xE193, 0xE9A083 },
	{ 0xF833, 0xE9A085 },
	{ 0xEC99, 0xE9A086 },
	{ 0xEC5E, 0xE9A088 },
	{ 0xEFF5, 0xE9A08A },
	{ 0xEBEB, 0xE9A08C },
	{ 0xEEE8, 0xE9A090 },
	{ 0xEF67, 0xE9A091 },
	{ 0xE89A, 0xE9A092 },
	{ 0xE55B, 0xE9A093 },
	{ 0xF6F6, 0xE9A097 },
	{ 0xE655, 0xE9A098 },
	{ 0xE579, 0xE9A0AD },
	{ 0xF89C, 0xE9A0B0 },
	{ 0xE194, 0xE9A0B8 },
	{ 0xF6DD, 0xE9A0B9 },
	{ 0xEA4A, 0xE9A0BB },
	{ 0xE238, 0xE9A186 },
	{ 0xF349, 0xE9A18C },
	{ 0xEDA0, 0xE9A18D },
	{ 0xED59, 0xE9A18E },
	{ 0xED64, 0xE9A194 },
	{ 0xF053, 0xE9A198 },
	{ 0xF2B4, 0xE9A19A },
	{ 0xE6BE, 0xE9A19E },
	{ 0xF8E2, 0xE9A1A5 },
	{ 0xE1D3, 0xE9A1A7 },
	{ 0xF2B5, 0xE9A1AB },
	{ 0xF879, 0xE9A1AF },
	{ 0xF7A6, 0xE9A2A8 },
	{ 0xEABD, 0xE9A2AF },
	{ 0xF6C7, 0xE9A2B1 },
	{ 0xF79F, 0xE9A384 },
	{ 0xF79E, 0xE9A387 },
	{ 0xEA3B, 0xE9A39B },
	{ 0xE8E8, 0xE9A39C },
	{ 0xECDD, 0xE9A39F },
	{ 0xEBE2, 0xE9A3A1 },
	{ 0xE3C6, 0xE9A3A2 },
	{ 0xF660, 0xE9A3AD },
	{ 0xF0E6, 0xE9A3AE },
	{ 0xE89B, 0xE9A3AF },
	{ 0xF157, 0xE9A3B4 },
	{ 0xEA9A, 0xE9A3BC },
	{ 0xF779, 0xE9A3BD },
	{ 0xECDE, 0xE9A3BE },
	{ 0xE297, 0xE9A483 },
	{ 0xF853, 0xE9A489 },
	{ 0xEDD7, 0xE9A48A },
	{ 0xF158, 0xE9A48C },
	{ 0xF4C9, 0xE9A490 },
	{ 0xED4B, 0xE9A493 },
	{ 0xEE3E, 0xE9A498 },
	{ 0xF2B6, 0xE9A49E },
	{ 0xE94F, 0xE9A4A0 },
	{ 0xE24D, 0xE9A4A8 },
	{ 0xE753, 0xE9A585 },
	{ 0xE35F, 0xE9A589 },
	{ 0xE2FA, 0xE9A58B },
	{ 0xF4CA, 0xE9A58C },
	{ 0xEB67, 0xE9A58D },
	{ 0xE3C7, 0xE9A591 },
	{ 0xEFAE, 0xE9A592 },
	{ 0xEF4D, 0xE9A594 },
	{ 0xF854, 0xE9A597 },
	{ 0xEC5F, 0xE9A696 },
	{ 0xF855, 0xE9A699 },
	{ 0xF7B8, 0xE9A69D },
	{ 0xE970, 0xE9A6A5 },
	{ 0xF8B0, 0xE9A6A8 },
	{ 0xE739, 0xE9A6AC },
	{ 0xEDDF, 0xE9A6AD },
	{ 0xF7A7, 0xE9A6AE },
	{ 0xF67E, 0xE9A6B1 },
	{ 0xF65C, 0xE9A6B3 },
	{ 0xEC9A, 0xE9A6B4 },
	{ 0xF193, 0xE9A6B9 },
	{ 0xE870, 0xE9A781 },
	{ 0xF3D2, 0xE9A790 },
	{ 0xE45C, 0xE9A791 },
	{ 0xE2CB, 0xE9A792 },
	{ 0xE04D, 0xE9A795 },
	{ 0xE9BF, 0xE9A799 },
	{ 0xF691, 0xE9A79D },
	{ 0xEA9B, 0xE9A79F },
	{ 0xF844, 0xE9A7AD },
	{ 0xE5AD, 0xE9A7B1 },
	{ 0xF3E7, 0xE9A7BF },
	{ 0xEA4E, 0xE9A881 },
	{ 0xE950, 0xE9A888 },
	{ 0xE3C8, 0xE9A88E },
	{ 0xE3C9, 0xE9A88F },
	{ 0xF74E, 0xE9A899 },
	{ 0xE0F6, 0xE9A8AB },
	{ 0xE59B, 0xE9A8B0 },
	{ 0xF5E2, 0xE9A8B6 },
	{ 0xEBD3, 0xE9A8B7 },
	{ 0xE779, 0xE9A980 },
	{ 0xF7A0, 0xE9A983 },
	{ 0xE2CC, 0xE9A985 },
	{ 0xF9A4, 0xE9A98D },
	{ 0xE298, 0xE9A995 },
	{ 0xF860, 0xE9A997 },
	{ 0xE195, 0xE9A99A },
	{ 0xEE4E, 0xE9A99B },
	{ 0xF63E, 0xE9A99F },
	{ 0xE5F0, 0xE9A9A2 },
	{ 0xE3CA, 0xE9A9A5 },
	{ 0xF94E, 0xE9A9A9 },
	{ 0xE5F1, 0xE9A9AA },
	{ 0xE1E9, 0xE9AAA8 },
	{ 0xF845, 0xE9AAB8 },
	{ 0xEC60, 0xE9AB93 },
	{ 0xF599, 0xE9AB94 },
	{ 0xE1D4, 0xE9AB98 },
	{ 0xEEA3, 0xE9ABA5 },
	{ 0xE8A5, 0xE9ABAE },
	{ 0xEC61, 0xE9AC9A },
	{ 0xE6A2, 0xE9ACA7 },
	{ 0xF6E3, 0xE9ACAA },
	{ 0xF036, 0xE9ACB1 },
	{ 0xE331, 0xE9ACBC },
	{ 0xE26A, 0xE9AD81 },
	{ 0xF8EB, 0xE9AD82 },
	{ 0xE8A6, 0xE9AD83 },
	{ 0xE8DE, 0xE9AD84 },
	{ 0xE775, 0xE9AD85 },
	{ 0xF070, 0xE9AD8F },
	{ 0xE73A, 0xE9AD94 },
	{ 0xEDE0, 0xE9AD9A },
	{ 0xE66B, 0xE9ADAF },
	{ 0xF2C6, 0xE9AE8E },
	{ 0xF77A, 0xE9AE91 },
	{ 0xED65, 0xE9AE9F },
	{ 0xE299, 0xE9AEAB },
	{ 0xEB68, 0xE9AEAE },
	{ 0xE6EF, 0xE9AF89 },
	{ 0xF57D, 0xE9AF96 },
	{ 0xE1E6, 0xE9AFA4 },
	{ 0xE196, 0xE9AFA8 },
	{ 0xF5E3, 0xE9B08D },
	{ 0xED5A, 0xE9B090 },
	{ 0xE971, 0xE9B092 },
	{ 0xF7C8, 0xE9B095 },
	{ 0xF94F, 0xE9B0A5 },
	{ 0xEF37, 0xE9B0B2 },
	{ 0xE754, 0xE9B0BB },
	{ 0xE0BE, 0xE9B187 },
	{ 0xE93E, 0xE9B189 },
	{ 0xE6F7, 0xE9B197 },
	{ 0xF378, 0xE9B3A5 },
	{ 0xE9C0, 0xE9B3A7 },
	{ 0xE2CD, 0xE9B3A9 },
	{ 0xE995, 0xE9B3B3 },
	{ 0xE7B0, 0xE9B3B4 },
	{ 0xEE79, 0xE9B3B6 },
	{ 0xED4C, 0xE9B489 },
	{ 0xF054, 0xE9B49B },
	{ 0xED7C, 0xE9B4A6 },
	{ 0xED75, 0xE9B4A8 },
	{ 0xF8F8, 0xE9B4BB },
	{ 0xE14B, 0xE9B591 },
	{ 0xED4D, 0xE9B59D },
	{ 0xE1DC, 0xE9B5A0 },
	{ 0xE7F7, 0xE9B5A1 },
	{ 0xE9DF, 0xE9B5AC },
	{ 0xF1CE, 0xE9B5B2 },
	{ 0xE7D0, 0xE9B6A9 },
	{ 0xEDA3, 0xE9B6AF },
	{ 0xF7CD, 0xE9B6B4 },
	{ 0xE1AE, 0xE9B784 },
	{ 0xE2CE, 0xE9B797 },
	{ 0xF63F, 0xE9B7B2 },
	{ 0xF9D3, 0xE9B7B8 },
	{ 0xF0ED, 0xE9B7B9 },
	{ 0xE66C, 0xE9B7BA },
	{ 0xEDA4, 0xE9B89A },
	{ 0xE5B6, 0xE9B89E },
	{ 0xE66D, 0xE9B9B5 },
	{ 0xF7E9, 0xE9B9B9 },
	{ 0xEEA4, 0xE9B9BD },
	{ 0xE673, 0xE9B9BF },
	{ 0xE3CB, 0xE9BA92 },
	{ 0xE674, 0xE9BA93 },
	{ 0xE5F2, 0xE9BA97 },
	{ 0xEA9C, 0xE9BA9D },
	{ 0xE6F8, 0xE9BA9F },
	{ 0xE77A, 0xE9BAA5 },
	{ 0xE2D5, 0xE9BAB4 },
	{ 0xE79F, 0xE9BAB5 },
	{ 0xE73B, 0xE9BABB },
	{ 0xF9CB, 0xE9BABE },
	{ 0xF96C, 0xE9BB83 },
	{ 0xEB38, 0xE9BB8D },
	{ 0xE5F3, 0xE9BB8E },
	{ 0xF9D9, 0xE9BB91 },
	{ 0xE133, 0xE9BB94 },
	{ 0xE7F9, 0xE9BB98 },
	{ 0xE4EA, 0xE9BB9B },
	{ 0xF5F5, 0xE9BB9C },
	{ 0xF2C7, 0xE9BB9E },
	{ 0xE4DA, 0xE9BBA8 },
	{ 0xE84D, 0xE9BBB4 },
	{ 0xEF38, 0xE9BC87 },
	{ 0xE93F, 0xE9BC88 },
	{ 0xF333, 0xE9BC8E },
	{ 0xE1D5, 0xE9BC93 },
	{ 0xEB39, 0xE9BCA0 },
	{ 0xEA3C, 0xE9BCBB },
	{ 0xF34A, 0xE9BD8A },
	{ 0xF241, 0xE9BD8B },
	{ 0xF242, 0xE9BD8E },
	{ 0xF65D, 0xE9BD92 },
	{ 0xF262, 0xE9BD9F },
	{ 0xE656, 0xE9BDA1 },
	{ 0xEB75, 0xE9BDA7 },
	{ 0xF4BB, 0xE9BDAA },
	{ 0xEDE1, 0xE9BDAC },
	{ 0xED5B, 0xE9BDB7 },
	{ 0xE6A3, 0xE9BE8D },
	{ 0xE8C2, 0xE9BE90 },
	{ 0xE0A0, 0xE9BE95 },
	{ 0xE2CF, 0xE9BE9C },
	{ 0xE0D0, 0xEFA480 },
	{ 0xE0D6, 0xEFA481 },
	{ 0xE0E7, 0xEFA482 },
	{ 0xE1CF, 0xEFA483 },
	{ 0xE1E8, 0xEFA484 },
	{ 0xE23D, 0xEFA485 },
	{ 0xE2FB, 0xEFA486 },
	{ 0xE332, 0xEFA487 },
	{ 0xE348, 0xEFA488 },
	{ 0xE360, 0xEFA489 },
	{ 0xE36D, 0xEFA48A },
	{ 0xE3D4, 0xEFA48B },
	{ 0xE3D5, 0xEFA48C },
	{ 0xE3D8, 0xEFA48D },
	{ 0xE3DB, 0xEFA48E },
	{ 0xE3DC, 0xEFA48F },
	{ 0xE3DD, 0xEFA490 },
	{ 0xE3DE, 0xEFA491 },
	{ 0xE3DF, 0xEFA492 },
	{ 0xE3E0, 0xEFA493 },
	{ 0xE3E2, 0xEFA494 },
	{ 0xE3E3, 0xEFA495 },
	{ 0xE3E4, 0xEFA496 },
	{ 0xE3E5, 0xEFA497 },
	{ 0xE3E6, 0xEFA498 },
	{ 0xE3E8, 0xEFA499 },
	{ 0xE3E9, 0xEFA49A },
	{ 0xE3EA, 0xEFA49B },
	{ 0xE3EB, 0xEFA49C },
	{ 0xE3ED, 0xEFA49D },
	{ 0xE3EF, 0xEFA49E },
	{ 0xE3F0, 0xEFA49F },
	{ 0xE3F2, 0xEFA4A0 },
	{ 0xE3F6, 0xEFA4A1 },
	{ 0xE3FA, 0xEFA4A2 },
	{ 0xE3FC, 0xEFA4A3 },
	{ 0xE3FD, 0xEFA4A4 },
	{ 0xE3FE, 0xEFA4A5 },
	{ 0xE432, 0xEFA4A6 },
	{ 0xE433, 0xEFA4A7 },
	{ 0xE437, 0xEFA4A8 },
	{ 0xE438, 0xEFA4A9 },
	{ 0xE439, 0xEFA4AA },
	{ 0xE43A, 0xEFA4AB },
	{ 0xE43B, 0xEFA4AC },
	{ 0xE43D, 0xEFA4AD },
	{ 0xE442, 0xEFA4AE },
	{ 0xE44E, 0xEFA4AF },
	{ 0xE452, 0xEFA4B0 },
	{ 0xE453, 0xEFA4B1 },
	{ 0xE454, 0xEFA4B2 },
	{ 0xE456, 0xEFA4B3 },
	{ 0xE457, 0xEFA4B4 },
	{ 0xE458, 0xEFA4B5 },
	{ 0xE459, 0xEFA4B6 },
	{ 0xE45A, 0xEFA4B7 },
	{ 0xE45B, 0xEFA4B8 },
	{ 0xE45D, 0xEFA4B9 },
	{ 0xE45E, 0xEFA4BA },
	{ 0xE45F, 0xEFA4BB },
	{ 0xE460, 0xEFA4BC },
	{ 0xE461, 0xEFA4BD },
	{ 0xE462, 0xEFA4BE },
	{ 0xE463, 0xEFA4BF },
	{ 0xE464, 0xEFA580 },
	{ 0xE465, 0xEFA581 },
	{ 0xE466, 0xEFA582 },
	{ 0xE467, 0xEFA583 },
	{ 0xE469, 0xEFA584 },
	{ 0xE46A, 0xEFA585 },
	{ 0xE46E, 0xEFA586 },
	{ 0xE46F, 0xEFA587 },
	{ 0xE471, 0xEFA588 },
	{ 0xE472, 0xEFA589 },
	{ 0xE474, 0xEFA58A },
	{ 0xE475, 0xEFA58B },
	{ 0xE476, 0xEFA58C },
	{ 0xE477, 0xEFA58D },
	{ 0xE478, 0xEFA58E },
	{ 0xE479, 0xEFA58F },
	{ 0xE47A, 0xEFA590 },
	{ 0xE47B, 0xEFA591 },
	{ 0xE492, 0xEFA592 },
	{ 0xE493, 0xEFA593 },
	{ 0xE494, 0xEFA594 },
	{ 0xE495, 0xEFA595 },
	{ 0xE496, 0xEFA596 },
	{ 0xE497, 0xEFA597 },
	{ 0xE499, 0xEFA598 },
	{ 0xE49A, 0xEFA599 },
	{ 0xE576, 0xEFA59A },
	{ 0xE59E, 0xEFA59B },
	{ 0xE5A5, 0xEFA59C },
	{ 0xE5AB, 0xEFA59D },
	{ 0xE5AE, 0xEFA59E },
	{ 0xE648, 0xEFA59F },
	{ 0xE65D, 0xEFA5A0 },
	{ 0xE6CB, 0xEFA5A1 },
	{ 0xE6E4, 0xEFA5A2 },
	{ 0xE8C5, 0xEFA5A3 },
	{ 0xE8E4, 0xEFA5A4 },
	{ 0xE935, 0xEFA5A5 },
	{ 0xE9A5, 0xEFA5A6 },
	{ 0xE9D5, 0xEFA5A7 },
	{ 0xE9F4, 0xEFA5A8 },
	{ 0xEA9E, 0xEFA5A9 },
	{ 0xEAA0, 0xEFA5AA },
	{ 0xEAB3, 0xEFA5AB },
	{ 0xEAE1, 0xEFA5AC },
	{ 0xEAE8, 0xEFA5AD },
	{ 0xEB93, 0xEFA5AE },
	{ 0xEBAD, 0xEFA5AF },
	{ 0xEBED, 0xEFA5B0 },
	{ 0xECF5, 0xEFA5B1 },
	{ 0xED31, 0xEFA5B2 },
	{ 0xED39, 0xEFA5B3 },
	{ 0xEDAE, 0xEFA5B4 },
	{ 0xEDB1, 0xEFA5B5 },
	{ 0xEDB2, 0xEFA5B6 },
	{ 0xEDB9, 0xEFA5B7 },
	{ 0xEDBB, 0xEFA5B8 },
	{ 0xEDBC, 0xEFA5B9 },
	{ 0xEDC4, 0xEFA5BA },
	{ 0xEDCE, 0xEFA5BB },
	{ 0xEDD0, 0xEFA5BC },
	{ 0xEDD2, 0xEFA5BD },
	{ 0xEDD6, 0xEFA5BE },
	{ 0xEDFA, 0xEFA5BF },
	{ 0xEDFB, 0xEFA680 },
	{ 0xEDFC, 0xEFA681 },
	{ 0xEDFE, 0xEFA682 },
	{ 0xEE31, 0xEFA683 },
	{ 0xEE34, 0xEFA684 },
	{ 0xEE37, 0xEFA685 },
	{ 0xEE3D, 0xEFA686 },
	{ 0xEE3F, 0xEFA687 },
	{ 0xEE40, 0xEFA688 },
	{ 0xEE41, 0xEFA689 },
	{ 0xEE43, 0xEFA68A },
	{ 0xEE47, 0xEFA68B },
	{ 0xEE48, 0xEFA68C },
	{ 0xEE4C, 0xEFA68D },
	{ 0xEE54, 0xEFA68E },
	{ 0xEE56, 0xEFA68F },
	{ 0xEE57, 0xEFA690 },
	{ 0xEE5A, 0xEFA691 },
	{ 0xEE62, 0xEFA692 },
	{ 0xEE66, 0xEFA693 },
	{ 0xEE69, 0xEFA694 },
	{ 0xEE6C, 0xEFA695 },
	{ 0xEE6F, 0xEFA696 },
	{ 0xEE71, 0xEFA697 },
	{ 0xEE74, 0xEFA698 },
	{ 0xEE75, 0xEFA699 },
	{ 0xEE76, 0xEFA69A },
	{ 0xEE78, 0xEFA69B },
	{ 0xEE7A, 0xEFA69C },
	{ 0xEE7B, 0xEFA69D },
	{ 0xEE7C, 0xEFA69E },
	{ 0xEE91, 0xEFA69F },
	{ 0xEE93, 0xEFA6A0 },
	{ 0xEE94, 0xEFA6A1 },
	{ 0xEE97, 0xEFA6A2 },
	{ 0xEE98, 0xEFA6A3 },
	{ 0xEE99, 0xEFA6A4 },
	{ 0xEE9B, 0xEFA6A5 },
	{ 0xEEA1, 0xEFA6A6 },
	{ 0xEEA6, 0xEFA6A7 },
	{ 0xEEA9, 0xEFA6A8 },
	{ 0xEEAA, 0xEFA6A9 },
	{ 0xEEAC, 0xEFA6AA },
	{ 0xEEAD, 0xEFA6AB },
	{ 0xEEB0, 0xEFA6AC },
	{ 0xEEBF, 0xEFA6AD },
	{ 0xEEC1, 0xEFA6AE },
	{ 0xEEC6, 0xEFA6AF },
	{ 0xEEC7, 0xEFA6B0 },
	{ 0xEECB, 0xEFA6B1 },
	{ 0xEECD, 0xEFA6B2 },
	{ 0xEECF, 0xEFA6B3 },
	{ 0xEED0, 0xEFA6B4 },
	{ 0xEED3, 0xEFA6B5 },
	{ 0xEEDF, 0xEFA6B6 },
	{ 0xEEE4, 0xEFA6B7 },
	{ 0xEEE6, 0xEFA6B8 },
	{ 0xEEF7, 0xEFA6B9 },
	{ 0xEF77, 0xEFA6BA },
	{ 0xEF78, 0xEFA6BB },
	{ 0xEF92, 0xEFA6BC },
	{ 0xEF93, 0xEFA6BD },
	{ 0xEF99, 0xEFA6BE },
	{ 0xEF9B, 0xEFA6BF },
	{ 0xEF9D, 0xEFA780 },
	{ 0xEFA0, 0xEFA781 },
	{ 0xEFA7, 0xEFA782 },
	{ 0xEFAC, 0xEFA783 },
	{ 0xEFCC, 0xEFA784 },
	{ 0xEFF7, 0xEFA785 },
	{ 0xF051, 0xEFA786 },
	{ 0xF075, 0xEFA787 },
	{ 0xF096, 0xEFA788 },
	{ 0xF099, 0xEFA789 },
	{ 0xF09E, 0xEFA78A },
	{ 0xF0A0, 0xEFA78B },
	{ 0xF0A4, 0xEFA78C },
	{ 0xF0A7, 0xEFA78D },
	{ 0xF0A9, 0xEFA78E },
	{ 0xF0AA, 0xEFA78F },
	{ 0xF0BA, 0xEFA790 },
	{ 0xF0BB, 0xEFA791 },
	{ 0xF0BD, 0xEFA792 },
	{ 0xF0C1, 0xEFA793 },
	{ 0xF0C2, 0xEFA794 },
	{ 0xF0C6, 0xEFA795 },
	{ 0xF0C7, 0xEFA796 },
	{ 0xF0CC, 0xEFA797 },
	{ 0xF0CF, 0xEFA798 },
	{ 0xF0D0, 0xEFA799 },
	{ 0xF0D1, 0xEFA79A },
	{ 0xF0D2, 0xEFA79B },
	{ 0xF0D8, 0xEFA79C },
	{ 0xF136, 0xEFA79D },
	{ 0xF137, 0xEFA79E },
	{ 0xF13A, 0xEFA79F },
	{ 0xF13F, 0xEFA7A0 },
	{ 0xF140, 0xEFA7A1 },
	{ 0xF141, 0xEFA7A2 },
	{ 0xF142, 0xEFA7A3 },
	{ 0xF145, 0xEFA7A4 },
	{ 0xF148, 0xEFA7A5 },
	{ 0xF14A, 0xEFA7A6 },
	{ 0xF150, 0xEFA7A7 },
	{ 0xF151, 0xEFA7A8 },
	{ 0xF155, 0xEFA7A9 },
	{ 0xF156, 0xEFA7AA },
	{ 0xF159, 0xEFA7AB },
	{ 0xF15A, 0xEFA7AC },
	{ 0xF165, 0xEFA7AD },
	{ 0xF16D, 0xEFA7AE },
	{ 0xF16E, 0xEFA7AF },
	{ 0xF171, 0xEFA7B0 },
	{ 0xF174, 0xEFA7B1 },
	{ 0xF177, 0xEFA7B2 },
	{ 0xF178, 0xEFA7B3 },
	{ 0xF199, 0xEFA7B4 },
	{ 0xF19A, 0xEFA7B5 },
	{ 0xF19C, 0xEFA7B6 },
	{ 0xF1A1, 0xEFA7B7 },
	{ 0xF1A2, 0xEFA7B8 },
	{ 0xF1A3, 0xEFA7B9 },
	{ 0xF1EE, 0xEFA7BA },
	{ 0xF26B, 0xEFA7BB },
	{ 0xF44D, 0xEFA7BC },
	{ 0xF49C, 0xEFA7BD },
	{ 0xF4B1, 0xEFA7BE },
	{ 0xF537, 0xEFA7BF },
	{ 0xF57E, 0xEFA880 },
	{ 0xF696, 0xEFA881 },
	{ 0xF698, 0xEFA882 },
	{ 0xF6B8, 0xEFA883 },
	{ 0xF6C8, 0xEFA884 },
	{ 0xF6D3, 0xEFA885 },
	{ 0xF76B, 0xEFA886 },
	{ 0xF792, 0xEFA887 },
	{ 0xF831, 0xEFA888 },
	{ 0xF832, 0xEFA889 },
	{ 0xF876, 0xEFA88A },
	{ 0xF939, 0xEFA88B },
	{ 0xDA31, 0xEFBC81 },
	{ 0xDA32, 0xEFBC82 },
	{ 0xDA33, 0xEFBC83 },
	{ 0xDA34, 0xEFBC84 },
	{ 0xDA35, 0xEFBC85 },
	{ 0xDA36, 0xEFBC86 },
	{ 0xDA37, 0xEFBC87 },
	{ 0xDA38, 0xEFBC88 },
	{ 0xDA39, 0xEFBC89 },
	{ 0xDA3A, 0xEFBC8A },
	{ 0xDA3B, 0xEFBC8B },
	{ 0xDA3C, 0xEFBC8C },
	{ 0xDA3D, 0xEFBC8D },
	{ 0xDA3E, 0xEFBC8E },
	{ 0xDA3F, 0xEFBC8F },
	{ 0xDA40, 0xEFBC90 },
	{ 0xDA41, 0xEFBC91 },
	{ 0xDA42, 0xEFBC92 },
	{ 0xDA43, 0xEFBC93 },
	{ 0xDA44, 0xEFBC94 },
	{ 0xDA45, 0xEFBC95 },
	{ 0xDA46, 0xEFBC96 },
	{ 0xDA47, 0xEFBC97 },
	{ 0xDA48, 0xEFBC98 },
	{ 0xDA49, 0xEFBC99 },
	{ 0xDA4A, 0xEFBC9A },
	{ 0xDA4B, 0xEFBC9B },
	{ 0xDA4C, 0xEFBC9C },
	{ 0xDA4D, 0xEFBC9D },
	{ 0xDA4E, 0xEFBC9E },
	{ 0xDA4F, 0xEFBC9F },
	{ 0xDA50, 0xEFBCA0 },
	{ 0xDA51, 0xEFBCA1 },
	{ 0xDA52, 0xEFBCA2 },
	{ 0xDA53, 0xEFBCA3 },
	{ 0xDA54, 0xEFBCA4 },
	{ 0xDA55, 0xEFBCA5 },
	{ 0xDA56, 0xEFBCA6 },
	{ 0xDA57, 0xEFBCA7 },
	{ 0xDA58, 0xEFBCA8 },
	{ 0xDA59, 0xEFBCA9 },
	{ 0xDA5A, 0xEFBCAA },
	{ 0xDA5B, 0xEFBCAB },
	{ 0xDA5C, 0xEFBCAC },
	{ 0xDA5D, 0xEFBCAD },
	{ 0xDA5E, 0xEFBCAE },
	{ 0xDA5F, 0xEFBCAF },
	{ 0xDA60, 0xEFBCB0 },
	{ 0xDA61, 0xEFBCB1 },
	{ 0xDA62, 0xEFBCB2 },
	{ 0xDA63, 0xEFBCB3 },
	{ 0xDA64, 0xEFBCB4 },
	{ 0xDA65, 0xEFBCB5 },
	{ 0xDA66, 0xEFBCB6 },
	{ 0xDA67, 0xEFBCB7 },
	{ 0xDA68, 0xEFBCB8 },
	{ 0xDA69, 0xEFBCB9 },
	{ 0xDA6A, 0xEFBCBA },
	{ 0xDA6B, 0xEFBCBB },
	{ 0xD93C, 0xEFBCBC },
	{ 0xDA6D, 0xEFBCBD },
	{ 0xDA6E, 0xEFBCBE },
	{ 0xDA6F, 0xEFBCBF },
	{ 0xDA70, 0xEFBD80 },
	{ 0xDA71, 0xEFBD81 },
	{ 0xDA72, 0xEFBD82 },
	{ 0xDA73, 0xEFBD83 },
	{ 0xDA74, 0xEFBD84 },
	{ 0xDA75, 0xEFBD85 },
	{ 0xDA76, 0xEFBD86 },
	{ 0xDA77, 0xEFBD87 },
	{ 0xDA78, 0xEFBD88 },
	{ 0xDA79, 0xEFBD89 },
	{ 0xDA7A, 0xEFBD8A },
	{ 0xDA7B, 0xEFBD8B },
	{ 0xDA7C, 0xEFBD8C },
	{ 0xDA7D, 0xEFBD8D },
	{ 0xDA7E, 0xEFBD8E },
	{ 0xDA91, 0xEFBD8F },
	{ 0xDA92, 0xEFBD90 },
	{ 0xDA93, 0xEFBD91 },
	{ 0xDA94, 0xEFBD92 },
	{ 0xDA95, 0xEFBD93 },
	{ 0xDA96, 0xEFBD94 },
	{ 0xDA97, 0xEFBD95 },
	{ 0xDA98, 0xEFBD96 },
	{ 0xDA99, 0xEFBD97 },
	{ 0xDA9A, 0xEFBD98 },
	{ 0xDA9B, 0xEFBD99 },
	{ 0xDA9C, 0xEFBD9A },
	{ 0xDA9D, 0xEFBD9B },
	{ 0xDA9E, 0xEFBD9C },
	{ 0xDA9F, 0xEFBD9D },
	{ 0xD93D, 0xEFBD9E },
	{ 0xD95B, 0xEFBFA0 },
	{ 0xD95C, 0xEFBFA1 },
	{ 0xD9A0, 0xEFBFA2 },
	{ 0xDAA0, 0xEFBFA3 },
	{ 0xD95D, 0xEFBFA5 },
	{ 0xDA6C, 0xEFBFA6 }
};


#endif	/* _UTF2JOHAP92_H_ */
