/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 * under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
 */

/*
 * Copyright (c) 1994 by Sun Microsystems, Inc.
 */



#ifndef	_UTF2ISO2022_H_
#define	_UTF2ISO2022_H_


#include "hangulcode.h"

typedef struct __conv_desc {
	unsigned short          ci, v, cf;
	enum { E, CI, V, CF }   prev_state;
	char			designated;
	enum { ASCII, WANSUNG }	state;
} _conv_desc;

#define RESET_CONV_DESC()\
			cd->ci = cd->v = cd->cf = CVC_FILL; cd->prev_state = E;
#define PROCESS_PRIOR_CVC()\
	{\
		unsigned short	code;\
		\
		if (cd->prev_state != E)\
		{\
			short 	num = (cd->designated) ?\
					(cd->state == ASCII ? 3 : 2) :\
					(cd->state == ASCII ? 7 : 6);\
			if ((obtail - ob) < num)\
			{\
				errno = E2BIG;\
				ret_val = (size_t)-1;\
				break;\
			}\
			\
			code = _johap_to_wansung(cd->ci, cd->v, cd->cf);\
			if (code == FAILED)\
			{\
				/* Let's assume the code is non-identical. */\
				num = (cd->designated && cd->state == WANSUNG)\
				      ? 3 : 2;\
				if ((obtail - ob) < num)\
				{\
					errno = E2BIG;\
					ret_val = (size_t)-1;\
					break;\
				}\
				if (num > 2)\
				{\
					*ob++ = SI;\
					cd->state = ASCII;\
				}\
				*ob++ = NON_IDENTICAL;\
				*ob++ = NON_IDENTICAL;\
				ret_val += 2;\
			}\
			else\
			{\
				if (!cd->designated && errno != EILSEQ)\
				{\
					*ob++ = ESC;\
					*ob++ = '$';\
					*ob++ = ')';\
					*ob++ = 'C';\
					cd->designated = 1;\
				}\
				if (cd->state == ASCII && errno != EILSEQ)\
				{\
					*ob++ = SO;\
					cd->state = WANSUNG;\
				}\
				*ob++ = (char)((code >> 8) & 0x7F);\
				*ob++ = (char)(code & 0x7F);\
			}\
			RESET_CONV_DESC();\
		}\
	}

#define MAX_U2ISO2022_NUM	8223

kcode_table utf82iso2022_tbl[] = {
	{ 0x222E, 0xE082A1 },
	{ 0x2234, 0xE082A4 },
	{ 0x2157, 0xE082A7 },
	{ 0x2127, 0xE082A8 },
	{ 0x2823, 0xE082AA },
	{ 0x216C, 0xE082AB },
	{ 0x2146, 0xE082B0 },
	{ 0x213E, 0xE082B1 },
	{ 0x2977, 0xE082B2 },
	{ 0x2978, 0xE082B3 },
	{ 0x2225, 0xE082B4 },
	{ 0x2252, 0xE082B6 },
	{ 0x222C, 0xE082B8 },
	{ 0x2976, 0xE082B9 },
	{ 0x282C, 0xE082BA },
	{ 0x216D, 0xE082BB },
	{ 0x2879, 0xE082BC },
	{ 0x2876, 0xE082BD },
	{ 0x287A, 0xE082BE },
	{ 0x222F, 0xE082BF },
	{ 0x2821, 0xE08386 },
	{ 0x2822, 0xE08390 },
	{ 0x213F, 0xE08397 },
	{ 0x282A, 0xE08398 },
	{ 0x282D, 0xE0839E },
	{ 0x292C, 0xE0839F },
	{ 0x2921, 0xE083A6 },
	{ 0x2923, 0xE083B0 },
	{ 0x2140, 0xE083B7 },
	{ 0x292A, 0xE083B8 },
	{ 0x292D, 0xE083BE },
	{ 0x2922, 0xE08491 },
	{ 0x2824, 0xE084A6 },
	{ 0x2924, 0xE084A7 },
	{ 0x2925, 0xE084B1 },
	{ 0x2826, 0xE084B2 },
	{ 0x2926, 0xE084B3 },
	{ 0x2927, 0xE084B8 },
	{ 0x2828, 0xE084BF },
	{ 0x2928, 0xE08580 },
	{ 0x2829, 0xE08581 },
	{ 0x2929, 0xE08582 },
	{ 0x2930, 0xE08589 },
	{ 0x282F, 0xE0858A },
	{ 0x292F, 0xE0858B },
	{ 0x282B, 0xE08592 },
	{ 0x292B, 0xE08593 },
	{ 0x282E, 0xE085A6 },
	{ 0x292E, 0xE085A7 },
	{ 0x2227, 0xE08B87 },
	{ 0x2228, 0xE08B98 },
	{ 0x222B, 0xE08B99 },
	{ 0x222A, 0xE08B9A },
	{ 0x222D, 0xE08B9B },
	{ 0x2226, 0xE08B9C },
	{ 0x2229, 0xE08B9D },
	{ 0x2541, 0xE08E91 },
	{ 0x2542, 0xE08E92 },
	{ 0x2543, 0xE08E93 },
	{ 0x2544, 0xE08E94 },
	{ 0x2545, 0xE08E95 },
	{ 0x2546, 0xE08E96 },
	{ 0x2547, 0xE08E97 },
	{ 0x2548, 0xE08E98 },
	{ 0x2549, 0xE08E99 },
	{ 0x254A, 0xE08E9A },
	{ 0x254B, 0xE08E9B },
	{ 0x254C, 0xE08E9C },
	{ 0x254D, 0xE08E9D },
	{ 0x254E, 0xE08E9E },
	{ 0x254F, 0xE08E9F },
	{ 0x2550, 0xE08EA0 },
	{ 0x2551, 0xE08EA1 },
	{ 0x2552, 0xE08EA3 },
	{ 0x2553, 0xE08EA4 },
	{ 0x2554, 0xE08EA5 },
	{ 0x2555, 0xE08EA6 },
	{ 0x2556, 0xE08EA7 },
	{ 0x2557, 0xE08EA8 },
	{ 0x2558, 0xE08EA9 },
	{ 0x2561, 0xE08EB1 },
	{ 0x2562, 0xE08EB2 },
	{ 0x2563, 0xE08EB3 },
	{ 0x2564, 0xE08EB4 },
	{ 0x2565, 0xE08EB5 },
	{ 0x2566, 0xE08EB6 },
	{ 0x2567, 0xE08EB7 },
	{ 0x2568, 0xE08EB8 },
	{ 0x2569, 0xE08EB9 },
	{ 0x256A, 0xE08EBA },
	{ 0x256B, 0xE08EBB },
	{ 0x256C, 0xE08EBC },
	{ 0x256D, 0xE08EBD },
	{ 0x256E, 0xE08EBE },
	{ 0x256F, 0xE08EBF },
	{ 0x2570, 0xE08F80 },
	{ 0x2571, 0xE08F81 },
	{ 0x2572, 0xE08F83 },
	{ 0x2573, 0xE08F84 },
	{ 0x2574, 0xE08F85 },
	{ 0x2575, 0xE08F86 },
	{ 0x2576, 0xE08F87 },
	{ 0x2577, 0xE08F88 },
	{ 0x2578, 0xE08F89 },
	{ 0x2C27, 0xE09081 },
	{ 0x2C21, 0xE09090 },
	{ 0x2C22, 0xE09091 },
	{ 0x2C23, 0xE09092 },
	{ 0x2C24, 0xE09093 },
	{ 0x2C25, 0xE09094 },
	{ 0x2C26, 0xE09095 },
	{ 0x2C28, 0xE09096 },
	{ 0x2C29, 0xE09097 },
	{ 0x2C2A, 0xE09098 },
	{ 0x2C2B, 0xE09099 },
	{ 0x2C2C, 0xE0909A },
	{ 0x2C2D, 0xE0909B },
	{ 0x2C2E, 0xE0909C },
	{ 0x2C2F, 0xE0909D },
	{ 0x2C30, 0xE0909E },
	{ 0x2C31, 0xE0909F },
	{ 0x2C32, 0xE090A0 },
	{ 0x2C33, 0xE090A1 },
	{ 0x2C34, 0xE090A2 },
	{ 0x2C35, 0xE090A3 },
	{ 0x2C36, 0xE090A4 },
	{ 0x2C37, 0xE090A5 },
	{ 0x2C38, 0xE090A6 },
	{ 0x2C39, 0xE090A7 },
	{ 0x2C3A, 0xE090A8 },
	{ 0x2C3B, 0xE090A9 },
	{ 0x2C3C, 0xE090AA },
	{ 0x2C3D, 0xE090AB },
	{ 0x2C3E, 0xE090AC },
	{ 0x2C3F, 0xE090AD },
	{ 0x2C40, 0xE090AE },
	{ 0x2C41, 0xE090AF },
	{ 0x2C51, 0xE090B0 },
	{ 0x2C52, 0xE090B1 },
	{ 0x2C53, 0xE090B2 },
	{ 0x2C54, 0xE090B3 },
	{ 0x2C55, 0xE090B4 },
	{ 0x2C56, 0xE090B5 },
	{ 0x2C58, 0xE090B6 },
	{ 0x2C59, 0xE090B7 },
	{ 0x2C5A, 0xE090B8 },
	{ 0x2C5B, 0xE090B9 },
	{ 0x2C5C, 0xE090BA },
	{ 0x2C5D, 0xE090BB },
	{ 0x2C5E, 0xE090BC },
	{ 0x2C5F, 0xE090BD },
	{ 0x2C60, 0xE090BE },
	{ 0x2C61, 0xE090BF },
	{ 0x2C62, 0xE09180 },
	{ 0x2C63, 0xE09181 },
	{ 0x2C64, 0xE09182 },
	{ 0x2C65, 0xE09183 },
	{ 0x2C66, 0xE09184 },
	{ 0x2C67, 0xE09185 },
	{ 0x2C68, 0xE09186 },
	{ 0x2C69, 0xE09187 },
	{ 0x2C6A, 0xE09188 },
	{ 0x2C6B, 0xE09189 },
	{ 0x2C6C, 0xE0918A },
	{ 0x2C6D, 0xE0918B },
	{ 0x2C6E, 0xE0918C },
	{ 0x2C6F, 0xE0918D },
	{ 0x2C70, 0xE0918E },
	{ 0x2C71, 0xE0918F },
	{ 0x2C57, 0xE09191 },
	{ 0x2129, 0xE28093 },
	{ 0x212A, 0xE28094 },
	{ 0x212B, 0xE28096 },
	{ 0x212E, 0xE28098 },
	{ 0x212F, 0xE28099 },
	{ 0x2130, 0xE2809C },
	{ 0x2131, 0xE2809D },
	{ 0x2253, 0xE280A0 },
	{ 0x2254, 0xE280A1 },
	{ 0x2125, 0xE280A5 },
	{ 0x2126, 0xE280A6 },
	{ 0x2236, 0xE280B0 },
	{ 0x2147, 0xE280B2 },
	{ 0x2148, 0xE280B3 },
	{ 0x2158, 0xE280BB },
	{ 0x2979, 0xE281B4 },
	{ 0x297A, 0xE281BF },
	{ 0x297B, 0xE28281 },
	{ 0x297C, 0xE28282 },
	{ 0x297D, 0xE28283 },
	{ 0x297E, 0xE28284 },
	{ 0x2149, 0xE28483 },
	{ 0x2235, 0xE28489 },
	{ 0x2724, 0xE28493 },
	{ 0x2260, 0xE28496 },
	{ 0x2265, 0xE284A1 },
	{ 0x2262, 0xE284A2 },
	{ 0x2759, 0xE284A6 },
	{ 0x214A, 0xE284AB },
	{ 0x2877, 0xE28593 },
	{ 0x2878, 0xE28594 },
	{ 0x287B, 0xE2859B },
	{ 0x287C, 0xE2859C },
	{ 0x287D, 0xE2859D },
	{ 0x287E, 0xE2859E },
	{ 0x2530, 0xE285A0 },
	{ 0x2531, 0xE285A1 },
	{ 0x2532, 0xE285A2 },
	{ 0x2533, 0xE285A3 },
	{ 0x2534, 0xE285A4 },
	{ 0x2535, 0xE285A5 },
	{ 0x2536, 0xE285A6 },
	{ 0x2537, 0xE285A7 },
	{ 0x2538, 0xE285A8 },
	{ 0x2539, 0xE285A9 },
	{ 0x2521, 0xE285B0 },
	{ 0x2522, 0xE285B1 },
	{ 0x2523, 0xE285B2 },
	{ 0x2524, 0xE285B3 },
	{ 0x2525, 0xE285B4 },
	{ 0x2526, 0xE285B5 },
	{ 0x2527, 0xE285B6 },
	{ 0x2528, 0xE285B7 },
	{ 0x2529, 0xE285B8 },
	{ 0x252A, 0xE285B9 },
	{ 0x2167, 0xE28690 },
	{ 0x2168, 0xE28691 },
	{ 0x2166, 0xE28692 },
	{ 0x2169, 0xE28693 },
	{ 0x216A, 0xE28694 },
	{ 0x2255, 0xE28695 },
	{ 0x2258, 0xE28696 },
	{ 0x2256, 0xE28697 },
	{ 0x2259, 0xE28698 },
	{ 0x2257, 0xE28699 },
	{ 0x2221, 0xE28792 },
	{ 0x2222, 0xE28794 },
	{ 0x2223, 0xE28880 },
	{ 0x2153, 0xE28882 },
	{ 0x2224, 0xE28883 },
	{ 0x2154, 0xE28887 },
	{ 0x2174, 0xE28888 },
	{ 0x2175, 0xE2888B },
	{ 0x2233, 0xE2888F },
	{ 0x2232, 0xE28891 },
	{ 0x216E, 0xE2889A },
	{ 0x2170, 0xE2889D },
	{ 0x2144, 0xE2889E },
	{ 0x2150, 0xE288A0 },
	{ 0x217C, 0xE288A7 },
	{ 0x217D, 0xE288A8 },
	{ 0x217B, 0xE288A9 },
	{ 0x217A, 0xE288AA },
	{ 0x2172, 0xE288AB },
	{ 0x2173, 0xE288AC },
	{ 0x2231, 0xE288AE },
	{ 0x2145, 0xE288B4 },
	{ 0x2171, 0xE288B5 },
	{ 0x2230, 0xE288B6 },
	{ 0x216F, 0xE288BD },
	{ 0x2156, 0xE28992 },
	{ 0x2141, 0xE289A0 },
	{ 0x2155, 0xE289A1 },
	{ 0x2142, 0xE289A4 },
	{ 0x2143, 0xE289A5 },
	{ 0x2178, 0xE28A82 },
	{ 0x2179, 0xE28A83 },
	{ 0x2176, 0xE28A86 },
	{ 0x2177, 0xE28A87 },
	{ 0x2151, 0xE28AA5 },
	{ 0x2152, 0xE28C92 },
	{ 0x2867, 0xE291A0 },
	{ 0x2868, 0xE291A1 },
	{ 0x2869, 0xE291A2 },
	{ 0x286A, 0xE291A3 },
	{ 0x286B, 0xE291A4 },
	{ 0x286C, 0xE291A5 },
	{ 0x286D, 0xE291A6 },
	{ 0x286E, 0xE291A7 },
	{ 0x286F, 0xE291A8 },
	{ 0x2870, 0xE291A9 },
	{ 0x2871, 0xE291AA },
	{ 0x2872, 0xE291AB },
	{ 0x2873, 0xE291AC },
	{ 0x2874, 0xE291AD },
	{ 0x2875, 0xE291AE },
	{ 0x2967, 0xE291B4 },
	{ 0x2968, 0xE291B5 },
	{ 0x2969, 0xE291B6 },
	{ 0x296A, 0xE291B7 },
	{ 0x296B, 0xE291B8 },
	{ 0x296C, 0xE291B9 },
	{ 0x296D, 0xE291BA },
	{ 0x296E, 0xE291BB },
	{ 0x296F, 0xE291BC },
	{ 0x2970, 0xE291BD },
	{ 0x2971, 0xE291BE },
	{ 0x2972, 0xE291BF },
	{ 0x2973, 0xE29280 },
	{ 0x2974, 0xE29281 },
	{ 0x2975, 0xE29282 },
	{ 0x294D, 0xE2929C },
	{ 0x294E, 0xE2929D },
	{ 0x294F, 0xE2929E },
	{ 0x2950, 0xE2929F },
	{ 0x2951, 0xE292A0 },
	{ 0x2952, 0xE292A1 },
	{ 0x2953, 0xE292A2 },
	{ 0x2954, 0xE292A3 },
	{ 0x2955, 0xE292A4 },
	{ 0x2956, 0xE292A5 },
	{ 0x2957, 0xE292A6 },
	{ 0x2958, 0xE292A7 },
	{ 0x2959, 0xE292A8 },
	{ 0x295A, 0xE292A9 },
	{ 0x295B, 0xE292AA },
	{ 0x295C, 0xE292AB },
	{ 0x295D, 0xE292AC },
	{ 0x295E, 0xE292AD },
	{ 0x295F, 0xE292AE },
	{ 0x2960, 0xE292AF },
	{ 0x2961, 0xE292B0 },
	{ 0x2962, 0xE292B1 },
	{ 0x2963, 0xE292B2 },
	{ 0x2964, 0xE292B3 },
	{ 0x2965, 0xE292B4 },
	{ 0x2966, 0xE292B5 },
	{ 0x284D, 0xE29390 },
	{ 0x284E, 0xE29391 },
	{ 0x284F, 0xE29392 },
	{ 0x2850, 0xE29393 },
	{ 0x2851, 0xE29394 },
	{ 0x2852, 0xE29395 },
	{ 0x2853, 0xE29396 },
	{ 0x2854, 0xE29397 },
	{ 0x2855, 0xE29398 },
	{ 0x2856, 0xE29399 },
	{ 0x2857, 0xE2939A },
	{ 0x2858, 0xE2939B },
	{ 0x2859, 0xE2939C },
	{ 0x285A, 0xE2939D },
	{ 0x285B, 0xE2939E },
	{ 0x285C, 0xE2939F },
	{ 0x285D, 0xE293A0 },
	{ 0x285E, 0xE293A1 },
	{ 0x285F, 0xE293A2 },
	{ 0x2860, 0xE293A3 },
	{ 0x2861, 0xE293A4 },
	{ 0x2862, 0xE293A5 },
	{ 0x2863, 0xE293A6 },
	{ 0x2864, 0xE293A7 },
	{ 0x2865, 0xE293A8 },
	{ 0x2866, 0xE293A9 },
	{ 0x2621, 0xE29480 },
	{ 0x262C, 0xE29481 },
	{ 0x2622, 0xE29482 },
	{ 0x262D, 0xE29483 },
	{ 0x2623, 0xE2948C },
	{ 0x2648, 0xE2948D },
	{ 0x2647, 0xE2948E },
	{ 0x262E, 0xE2948F },
	{ 0x2624, 0xE29490 },
	{ 0x2642, 0xE29491 },
	{ 0x2641, 0xE29492 },
	{ 0x262F, 0xE29493 },
	{ 0x2626, 0xE29494 },
	{ 0x2646, 0xE29495 },
	{ 0x2645, 0xE29496 },
	{ 0x2631, 0xE29497 },
	{ 0x2625, 0xE29498 },
	{ 0x2644, 0xE29499 },
	{ 0x2643, 0xE2949A },
	{ 0x2630, 0xE2949B },
	{ 0x2627, 0xE2949C },
	{ 0x263C, 0xE2949D },
	{ 0x2649, 0xE2949E },
	{ 0x264A, 0xE2949F },
	{ 0x2637, 0xE294A0 },
	{ 0x264B, 0xE294A1 },
	{ 0x264C, 0xE294A2 },
	{ 0x2632, 0xE294A3 },
	{ 0x2629, 0xE294A4 },
	{ 0x263E, 0xE294A5 },
	{ 0x264D, 0xE294A6 },
	{ 0x264E, 0xE294A7 },
	{ 0x2639, 0xE294A8 },
	{ 0x264F, 0xE294A9 },
	{ 0x2650, 0xE294AA },
	{ 0x2634, 0xE294AB },
	{ 0x2628, 0xE294AC },
	{ 0x2651, 0xE294AD },
	{ 0x2652, 0xE294AE },
	{ 0x2638, 0xE294AF },
	{ 0x263D, 0xE294B0 },
	{ 0x2653, 0xE294B1 },
	{ 0x2654, 0xE294B2 },
	{ 0x2633, 0xE294B3 },
	{ 0x262A, 0xE294B4 },
	{ 0x2655, 0xE294B5 },
	{ 0x2656, 0xE294B6 },
	{ 0x263A, 0xE294B7 },
	{ 0x263F, 0xE294B8 },
	{ 0x2657, 0xE294B9 },
	{ 0x2658, 0xE294BA },
	{ 0x2635, 0xE294BB },
	{ 0x262B, 0xE294BC },
	{ 0x2659, 0xE294BD },
	{ 0x265A, 0xE294BE },
	{ 0x263B, 0xE294BF },
	{ 0x265B, 0xE29580 },
	{ 0x265C, 0xE29581 },
	{ 0x2640, 0xE29582 },
	{ 0x265D, 0xE29583 },
	{ 0x265E, 0xE29584 },
	{ 0x265F, 0xE29585 },
	{ 0x2660, 0xE29586 },
	{ 0x2661, 0xE29587 },
	{ 0x2662, 0xE29588 },
	{ 0x2663, 0xE29589 },
	{ 0x2664, 0xE2958A },
	{ 0x2636, 0xE2958B },
	{ 0x2246, 0xE29692 },
	{ 0x2161, 0xE296A0 },
	{ 0x2160, 0xE296A1 },
	{ 0x2243, 0xE296A3 },
	{ 0x2247, 0xE296A4 },
	{ 0x2248, 0xE296A5 },
	{ 0x224B, 0xE296A6 },
	{ 0x224A, 0xE296A7 },
	{ 0x2249, 0xE296A8 },
	{ 0x224C, 0xE296A9 },
	{ 0x2163, 0xE296B2 },
	{ 0x2162, 0xE296B3 },
	{ 0x223A, 0xE296B6 },
	{ 0x2239, 0xE296B7 },
	{ 0x2165, 0xE296BC },
	{ 0x2164, 0xE296BD },
	{ 0x2238, 0xE29780 },
	{ 0x2237, 0xE29781 },
	{ 0x215F, 0xE29786 },
	{ 0x215E, 0xE29787 },
	{ 0x2242, 0xE29788 },
	{ 0x2241, 0xE29789 },
	{ 0x215B, 0xE2978B },
	{ 0x215D, 0xE2978E },
	{ 0x215C, 0xE2978F },
	{ 0x2244, 0xE29790 },
	{ 0x2245, 0xE29791 },
	{ 0x215A, 0xE29885 },
	{ 0x2159, 0xE29886 },
	{ 0x224F, 0xE2988E },
	{ 0x224E, 0xE2988F },
	{ 0x2250, 0xE2989C },
	{ 0x2251, 0xE2989E },
	{ 0x214F, 0xE29980 },
	{ 0x214E, 0xE29982 },
	{ 0x223C, 0xE299A0 },
	{ 0x223D, 0xE299A1 },
	{ 0x2240, 0xE299A3 },
	{ 0x223B, 0xE299A4 },
	{ 0x223E, 0xE299A5 },
	{ 0x223F, 0xE299A7 },
	{ 0x224D, 0xE299A8 },
	{ 0x225B, 0xE299A9 },
	{ 0x225C, 0xE299AA },
	{ 0x225D, 0xE299AC },
	{ 0x225A, 0xE299AD },
	{ 0x2121, 0xE38080 },
	{ 0x2122, 0xE38081 },
	{ 0x2123, 0xE38082 },
	{ 0x2128, 0xE38083 },
	{ 0x2134, 0xE38088 },
	{ 0x2135, 0xE38089 },
	{ 0x2136, 0xE3808A },
	{ 0x2137, 0xE3808B },
	{ 0x2138, 0xE3808C },
	{ 0x2139, 0xE3808D },
	{ 0x213A, 0xE3808E },
	{ 0x213B, 0xE3808F },
	{ 0x213C, 0xE38090 },
	{ 0x213D, 0xE38091 },
	{ 0x216B, 0xE38093 },
	{ 0x2132, 0xE38094 },
	{ 0x2133, 0xE38095 },
	{ 0x2A21, 0xE38181 },
	{ 0x2A22, 0xE38182 },
	{ 0x2A23, 0xE38183 },
	{ 0x2A24, 0xE38184 },
	{ 0x2A25, 0xE38185 },
	{ 0x2A26, 0xE38186 },
	{ 0x2A27, 0xE38187 },
	{ 0x2A28, 0xE38188 },
	{ 0x2A29, 0xE38189 },
	{ 0x2A2A, 0xE3818A },
	{ 0x2A2B, 0xE3818B },
	{ 0x2A2C, 0xE3818C },
	{ 0x2A2D, 0xE3818D },
	{ 0x2A2E, 0xE3818E },
	{ 0x2A2F, 0xE3818F },
	{ 0x2A30, 0xE38190 },
	{ 0x2A31, 0xE38191 },
	{ 0x2A32, 0xE38192 },
	{ 0x2A33, 0xE38193 },
	{ 0x2A34, 0xE38194 },
	{ 0x2A35, 0xE38195 },
	{ 0x2A36, 0xE38196 },
	{ 0x2A37, 0xE38197 },
	{ 0x2A38, 0xE38198 },
	{ 0x2A39, 0xE38199 },
	{ 0x2A3A, 0xE3819A },
	{ 0x2A3B, 0xE3819B },
	{ 0x2A3C, 0xE3819C },
	{ 0x2A3D, 0xE3819D },
	{ 0x2A3E, 0xE3819E },
	{ 0x2A3F, 0xE3819F },
	{ 0x2A40, 0xE381A0 },
	{ 0x2A41, 0xE381A1 },
	{ 0x2A42, 0xE381A2 },
	{ 0x2A43, 0xE381A3 },
	{ 0x2A44, 0xE381A4 },
	{ 0x2A45, 0xE381A5 },
	{ 0x2A46, 0xE381A6 },
	{ 0x2A47, 0xE381A7 },
	{ 0x2A48, 0xE381A8 },
	{ 0x2A49, 0xE381A9 },
	{ 0x2A4A, 0xE381AA },
	{ 0x2A4B, 0xE381AB },
	{ 0x2A4C, 0xE381AC },
	{ 0x2A4D, 0xE381AD },
	{ 0x2A4E, 0xE381AE },
	{ 0x2A4F, 0xE381AF },
	{ 0x2A50, 0xE381B0 },
	{ 0x2A51, 0xE381B1 },
	{ 0x2A52, 0xE381B2 },
	{ 0x2A53, 0xE381B3 },
	{ 0x2A54, 0xE381B4 },
	{ 0x2A55, 0xE381B5 },
	{ 0x2A56, 0xE381B6 },
	{ 0x2A57, 0xE381B7 },
	{ 0x2A58, 0xE381B8 },
	{ 0x2A59, 0xE381B9 },
	{ 0x2A5A, 0xE381BA },
	{ 0x2A5B, 0xE381BB },
	{ 0x2A5C, 0xE381BC },
	{ 0x2A5D, 0xE381BD },
	{ 0x2A5E, 0xE381BE },
	{ 0x2A5F, 0xE381BF },
	{ 0x2A60, 0xE38280 },
	{ 0x2A61, 0xE38281 },
	{ 0x2A62, 0xE38282 },
	{ 0x2A63, 0xE38283 },
	{ 0x2A64, 0xE38284 },
	{ 0x2A65, 0xE38285 },
	{ 0x2A66, 0xE38286 },
	{ 0x2A67, 0xE38287 },
	{ 0x2A68, 0xE38288 },
	{ 0x2A69, 0xE38289 },
	{ 0x2A6A, 0xE3828A },
	{ 0x2A6B, 0xE3828B },
	{ 0x2A6C, 0xE3828C },
	{ 0x2A6D, 0xE3828D },
	{ 0x2A6E, 0xE3828E },
	{ 0x2A6F, 0xE3828F },
	{ 0x2A70, 0xE38290 },
	{ 0x2A71, 0xE38291 },
	{ 0x2A72, 0xE38292 },
	{ 0x2A73, 0xE38293 },
	{ 0x2B21, 0xE382A1 },
	{ 0x2B22, 0xE382A2 },
	{ 0x2B23, 0xE382A3 },
	{ 0x2B24, 0xE382A4 },
	{ 0x2B25, 0xE382A5 },
	{ 0x2B26, 0xE382A6 },
	{ 0x2B27, 0xE382A7 },
	{ 0x2B28, 0xE382A8 },
	{ 0x2B29, 0xE382A9 },
	{ 0x2B2A, 0xE382AA },
	{ 0x2B2B, 0xE382AB },
	{ 0x2B2C, 0xE382AC },
	{ 0x2B2D, 0xE382AD },
	{ 0x2B2E, 0xE382AE },
	{ 0x2B2F, 0xE382AF },
	{ 0x2B30, 0xE382B0 },
	{ 0x2B31, 0xE382B1 },
	{ 0x2B32, 0xE382B2 },
	{ 0x2B33, 0xE382B3 },
	{ 0x2B34, 0xE382B4 },
	{ 0x2B35, 0xE382B5 },
	{ 0x2B36, 0xE382B6 },
	{ 0x2B37, 0xE382B7 },
	{ 0x2B38, 0xE382B8 },
	{ 0x2B39, 0xE382B9 },
	{ 0x2B3A, 0xE382BA },
	{ 0x2B3B, 0xE382BB },
	{ 0x2B3C, 0xE382BC },
	{ 0x2B3D, 0xE382BD },
	{ 0x2B3E, 0xE382BE },
	{ 0x2B3F, 0xE382BF },
	{ 0x2B40, 0xE38380 },
	{ 0x2B41, 0xE38381 },
	{ 0x2B42, 0xE38382 },
	{ 0x2B43, 0xE38383 },
	{ 0x2B44, 0xE38384 },
	{ 0x2B45, 0xE38385 },
	{ 0x2B46, 0xE38386 },
	{ 0x2B47, 0xE38387 },
	{ 0x2B48, 0xE38388 },
	{ 0x2B49, 0xE38389 },
	{ 0x2B4A, 0xE3838A },
	{ 0x2B4B, 0xE3838B },
	{ 0x2B4C, 0xE3838C },
	{ 0x2B4D, 0xE3838D },
	{ 0x2B4E, 0xE3838E },
	{ 0x2B4F, 0xE3838F },
	{ 0x2B50, 0xE38390 },
	{ 0x2B51, 0xE38391 },
	{ 0x2B52, 0xE38392 },
	{ 0x2B53, 0xE38393 },
	{ 0x2B54, 0xE38394 },
	{ 0x2B55, 0xE38395 },
	{ 0x2B56, 0xE38396 },
	{ 0x2B57, 0xE38397 },
	{ 0x2B58, 0xE38398 },
	{ 0x2B59, 0xE38399 },
	{ 0x2B5A, 0xE3839A },
	{ 0x2B5B, 0xE3839B },
	{ 0x2B5C, 0xE3839C },
	{ 0x2B5D, 0xE3839D },
	{ 0x2B5E, 0xE3839E },
	{ 0x2B5F, 0xE3839F },
	{ 0x2B60, 0xE383A0 },
	{ 0x2B61, 0xE383A1 },
	{ 0x2B62, 0xE383A2 },
	{ 0x2B63, 0xE383A3 },
	{ 0x2B64, 0xE383A4 },
	{ 0x2B65, 0xE383A5 },
	{ 0x2B66, 0xE383A6 },
	{ 0x2B67, 0xE383A7 },
	{ 0x2B68, 0xE383A8 },
	{ 0x2B69, 0xE383A9 },
	{ 0x2B6A, 0xE383AA },
	{ 0x2B6B, 0xE383AB },
	{ 0x2B6C, 0xE383AC },
	{ 0x2B6D, 0xE383AD },
	{ 0x2B6E, 0xE383AE },
	{ 0x2B6F, 0xE383AF },
	{ 0x2B70, 0xE383B0 },
	{ 0x2B71, 0xE383B1 },
	{ 0x2B72, 0xE383B2 },
	{ 0x2B73, 0xE383B3 },
	{ 0x2B74, 0xE383B4 },
	{ 0x2B75, 0xE383B5 },
	{ 0x2B76, 0xE383B6 },
	{ 0x2124, 0xE383BB },
	{ 0x2421, 0xE384B1 },
	{ 0x2422, 0xE384B2 },
	{ 0x2423, 0xE384B3 },
	{ 0x2424, 0xE384B4 },
	{ 0x2425, 0xE384B5 },
	{ 0x2426, 0xE384B6 },
	{ 0x2427, 0xE384B7 },
	{ 0x2428, 0xE384B8 },
	{ 0x2429, 0xE384B9 },
	{ 0x242A, 0xE384BA },
	{ 0x242B, 0xE384BB },
	{ 0x242C, 0xE384BC },
	{ 0x242D, 0xE384BD },
	{ 0x242E, 0xE384BE },
	{ 0x242F, 0xE384BF },
	{ 0x2430, 0xE38580 },
	{ 0x2431, 0xE38581 },
	{ 0x2432, 0xE38582 },
	{ 0x2433, 0xE38583 },
	{ 0x2434, 0xE38584 },
	{ 0x2435, 0xE38585 },
	{ 0x2436, 0xE38586 },
	{ 0x2437, 0xE38587 },
	{ 0x2438, 0xE38588 },
	{ 0x2439, 0xE38589 },
	{ 0x243A, 0xE3858A },
	{ 0x243B, 0xE3858B },
	{ 0x243C, 0xE3858C },
	{ 0x243D, 0xE3858D },
	{ 0x243E, 0xE3858E },
	{ 0x243F, 0xE3858F },
	{ 0x2440, 0xE38590 },
	{ 0x2441, 0xE38591 },
	{ 0x2442, 0xE38592 },
	{ 0x2443, 0xE38593 },
	{ 0x2444, 0xE38594 },
	{ 0x2445, 0xE38595 },
	{ 0x2446, 0xE38596 },
	{ 0x2447, 0xE38597 },
	{ 0x2448, 0xE38598 },
	{ 0x2449, 0xE38599 },
	{ 0x244A, 0xE3859A },
	{ 0x244B, 0xE3859B },
	{ 0x244C, 0xE3859C },
	{ 0x244D, 0xE3859D },
	{ 0x244E, 0xE3859E },
	{ 0x244F, 0xE3859F },
	{ 0x2450, 0xE385A0 },
	{ 0x2451, 0xE385A1 },
	{ 0x2452, 0xE385A2 },
	{ 0x2453, 0xE385A3 },
	{ 0x2454, 0xE385A4 },
	{ 0x2455, 0xE385A5 },
	{ 0x2456, 0xE385A6 },
	{ 0x2457, 0xE385A7 },
	{ 0x2458, 0xE385A8 },
	{ 0x2459, 0xE385A9 },
	{ 0x245A, 0xE385AA },
	{ 0x245B, 0xE385AB },
	{ 0x245C, 0xE385AC },
	{ 0x245D, 0xE385AD },
	{ 0x245E, 0xE385AE },
	{ 0x245F, 0xE385AF },
	{ 0x2460, 0xE385B0 },
	{ 0x2461, 0xE385B1 },
	{ 0x2462, 0xE385B2 },
	{ 0x2463, 0xE385B3 },
	{ 0x2464, 0xE385B4 },
	{ 0x2465, 0xE385B5 },
	{ 0x2466, 0xE385B6 },
	{ 0x2467, 0xE385B7 },
	{ 0x2468, 0xE385B8 },
	{ 0x2469, 0xE385B9 },
	{ 0x246A, 0xE385BA },
	{ 0x246B, 0xE385BB },
	{ 0x246C, 0xE385BC },
	{ 0x246D, 0xE385BD },
	{ 0x246E, 0xE385BE },
	{ 0x246F, 0xE385BF },
	{ 0x2470, 0xE38680 },
	{ 0x2471, 0xE38681 },
	{ 0x2472, 0xE38682 },
	{ 0x2473, 0xE38683 },
	{ 0x2474, 0xE38684 },
	{ 0x2475, 0xE38685 },
	{ 0x2476, 0xE38686 },
	{ 0x2477, 0xE38687 },
	{ 0x2478, 0xE38688 },
	{ 0x2479, 0xE38689 },
	{ 0x247A, 0xE3868A },
	{ 0x247B, 0xE3868B },
	{ 0x247C, 0xE3868C },
	{ 0x247D, 0xE3868D },
	{ 0x247E, 0xE3868E },
	{ 0x2931, 0xE38880 },
	{ 0x2932, 0xE38881 },
	{ 0x2933, 0xE38882 },
	{ 0x2934, 0xE38883 },
	{ 0x2935, 0xE38884 },
	{ 0x2936, 0xE38885 },
	{ 0x2937, 0xE38886 },
	{ 0x2938, 0xE38887 },
	{ 0x2939, 0xE38888 },
	{ 0x293A, 0xE38889 },
	{ 0x293B, 0xE3888A },
	{ 0x293C, 0xE3888B },
	{ 0x293D, 0xE3888C },
	{ 0x293E, 0xE3888D },
	{ 0x293F, 0xE3888E },
	{ 0x2940, 0xE3888F },
	{ 0x2941, 0xE38890 },
	{ 0x2942, 0xE38891 },
	{ 0x2943, 0xE38892 },
	{ 0x2944, 0xE38893 },
	{ 0x2945, 0xE38894 },
	{ 0x2946, 0xE38895 },
	{ 0x2947, 0xE38896 },
	{ 0x2948, 0xE38897 },
	{ 0x2949, 0xE38898 },
	{ 0x294A, 0xE38899 },
	{ 0x294B, 0xE3889A },
	{ 0x294C, 0xE3889B },
	{ 0x225F, 0xE3889C },
	{ 0x2831, 0xE389A0 },
	{ 0x2832, 0xE389A1 },
	{ 0x2833, 0xE389A2 },
	{ 0x2834, 0xE389A3 },
	{ 0x2835, 0xE389A4 },
	{ 0x2836, 0xE389A5 },
	{ 0x2837, 0xE389A6 },
	{ 0x2838, 0xE389A7 },
	{ 0x2839, 0xE389A8 },
	{ 0x283A, 0xE389A9 },
	{ 0x283B, 0xE389AA },
	{ 0x283C, 0xE389AB },
	{ 0x283D, 0xE389AC },
	{ 0x283E, 0xE389AD },
	{ 0x283F, 0xE389AE },
	{ 0x2840, 0xE389AF },
	{ 0x2841, 0xE389B0 },
	{ 0x2842, 0xE389B1 },
	{ 0x2843, 0xE389B2 },
	{ 0x2844, 0xE389B3 },
	{ 0x2845, 0xE389B4 },
	{ 0x2846, 0xE389B5 },
	{ 0x2847, 0xE389B6 },
	{ 0x2848, 0xE389B7 },
	{ 0x2849, 0xE389B8 },
	{ 0x284A, 0xE389B9 },
	{ 0x284B, 0xE389BA },
	{ 0x284C, 0xE389BB },
	{ 0x225E, 0xE389BF },
	{ 0x2749, 0xE38E80 },
	{ 0x274A, 0xE38E81 },
	{ 0x274B, 0xE38E82 },
	{ 0x274C, 0xE38E83 },
	{ 0x274D, 0xE38E84 },
	{ 0x273A, 0xE38E88 },
	{ 0x273B, 0xE38E89 },
	{ 0x275C, 0xE38E8A },
	{ 0x275D, 0xE38E8B },
	{ 0x275E, 0xE38E8C },
	{ 0x2736, 0xE38E8D },
	{ 0x2737, 0xE38E8E },
	{ 0x2738, 0xE38E8F },
	{ 0x2754, 0xE38E90 },
	{ 0x2755, 0xE38E91 },
	{ 0x2756, 0xE38E92 },
	{ 0x2757, 0xE38E93 },
	{ 0x2758, 0xE38E94 },
	{ 0x2721, 0xE38E95 },
	{ 0x2722, 0xE38E96 },
	{ 0x2723, 0xE38E97 },
	{ 0x2725, 0xE38E98 },
	{ 0x272B, 0xE38E99 },
	{ 0x272C, 0xE38E9A },
	{ 0x272D, 0xE38E9B },
	{ 0x272E, 0xE38E9C },
	{ 0x272F, 0xE38E9D },
	{ 0x2730, 0xE38E9E },
	{ 0x2731, 0xE38E9F },
	{ 0x2732, 0xE38EA0 },
	{ 0x2733, 0xE38EA1 },
	{ 0x2734, 0xE38EA2 },
	{ 0x2727, 0xE38EA3 },
	{ 0x2728, 0xE38EA4 },
	{ 0x2729, 0xE38EA5 },
	{ 0x272A, 0xE38EA6 },
	{ 0x273D, 0xE38EA7 },
	{ 0x273E, 0xE38EA8 },
	{ 0x2765, 0xE38EA9 },
	{ 0x2766, 0xE38EAA },
	{ 0x2767, 0xE38EAB },
	{ 0x2768, 0xE38EAC },
	{ 0x2761, 0xE38EAD },
	{ 0x2762, 0xE38EAE },
	{ 0x2763, 0xE38EAF },
	{ 0x273F, 0xE38EB0 },
	{ 0x2740, 0xE38EB1 },
	{ 0x2741, 0xE38EB2 },
	{ 0x2742, 0xE38EB3 },
	{ 0x2743, 0xE38EB4 },
	{ 0x2744, 0xE38EB5 },
	{ 0x2745, 0xE38EB6 },
	{ 0x2746, 0xE38EB7 },
	{ 0x2747, 0xE38EB8 },
	{ 0x2748, 0xE38EB9 },
	{ 0x274E, 0xE38EBA },
	{ 0x274F, 0xE38EBB },
	{ 0x2750, 0xE38EBC },
	{ 0x2751, 0xE38EBD },
	{ 0x2752, 0xE38EBE },
	{ 0x2753, 0xE38EBF },
	{ 0x275A, 0xE38F80 },
	{ 0x275B, 0xE38F81 },
	{ 0x2263, 0xE38F82 },
	{ 0x276C, 0xE38F83 },
	{ 0x2726, 0xE38F84 },
	{ 0x2760, 0xE38F85 },
	{ 0x276F, 0xE38F86 },
	{ 0x2261, 0xE38F87 },
	{ 0x273C, 0xE38F88 },
	{ 0x276D, 0xE38F89 },
	{ 0x2735, 0xE38F8A },
	{ 0x2739, 0xE38F8F },
	{ 0x276A, 0xE38F90 },
	{ 0x276B, 0xE38F93 },
	{ 0x275F, 0xE38F96 },
	{ 0x2264, 0xE38F98 },
	{ 0x2764, 0xE38F9B },
	{ 0x276E, 0xE38F9C },
	{ 0x2769, 0xE38F9D },
	{ 0x3021, 0xE39080 },
	{ 0x3022, 0xE39081 },
	{ 0x3023, 0xE39082 },
	{ 0x3024, 0xE39083 },
	{ 0x3025, 0xE39084 },
	{ 0x3026, 0xE39085 },
	{ 0x3027, 0xE39086 },
	{ 0x3028, 0xE39087 },
	{ 0x3029, 0xE39088 },
	{ 0x302A, 0xE39089 },
	{ 0x302B, 0xE3908A },
	{ 0x302C, 0xE3908B },
	{ 0x302D, 0xE3908C },
	{ 0x302E, 0xE3908D },
	{ 0x302F, 0xE3908E },
	{ 0x3030, 0xE3908F },
	{ 0x3031, 0xE39090 },
	{ 0x3032, 0xE39091 },
	{ 0x3033, 0xE39092 },
	{ 0x3034, 0xE39093 },
	{ 0x3035, 0xE39094 },
	{ 0x3036, 0xE39095 },
	{ 0x3037, 0xE39096 },
	{ 0x3038, 0xE39097 },
	{ 0x3039, 0xE39098 },
	{ 0x303A, 0xE39099 },
	{ 0x303B, 0xE3909A },
	{ 0x303C, 0xE3909B },
	{ 0x303D, 0xE3909C },
	{ 0x303E, 0xE3909D },
	{ 0x303F, 0xE3909E },
	{ 0x3040, 0xE3909F },
	{ 0x3041, 0xE390A0 },
	{ 0x3042, 0xE390A1 },
	{ 0x3043, 0xE390A2 },
	{ 0x3044, 0xE390A3 },
	{ 0x3045, 0xE390A4 },
	{ 0x3046, 0xE390A5 },
	{ 0x3047, 0xE390A6 },
	{ 0x3048, 0xE390A7 },
	{ 0x3049, 0xE390A8 },
	{ 0x304A, 0xE390A9 },
	{ 0x304B, 0xE390AA },
	{ 0x304C, 0xE390AB },
	{ 0x304D, 0xE390AC },
	{ 0x304E, 0xE390AD },
	{ 0x304F, 0xE390AE },
	{ 0x3050, 0xE390AF },
	{ 0x3051, 0xE390B0 },
	{ 0x3052, 0xE390B1 },
	{ 0x3053, 0xE390B2 },
	{ 0x3054, 0xE390B3 },
	{ 0x3055, 0xE390B4 },
	{ 0x3056, 0xE390B5 },
	{ 0x3057, 0xE390B6 },
	{ 0x3058, 0xE390B7 },
	{ 0x3059, 0xE390B8 },
	{ 0x305A, 0xE390B9 },
	{ 0x305B, 0xE390BA },
	{ 0x305C, 0xE390BB },
	{ 0x305D, 0xE390BC },
	{ 0x305E, 0xE390BD },
	{ 0x305F, 0xE390BE },
	{ 0x3060, 0xE390BF },
	{ 0x3061, 0xE39180 },
	{ 0x3062, 0xE39181 },
	{ 0x3063, 0xE39182 },
	{ 0x3064, 0xE39183 },
	{ 0x3065, 0xE39184 },
	{ 0x3066, 0xE39185 },
	{ 0x3067, 0xE39186 },
	{ 0x3068, 0xE39187 },
	{ 0x3069, 0xE39188 },
	{ 0x306A, 0xE39189 },
	{ 0x306B, 0xE3918A },
	{ 0x306C, 0xE3918B },
	{ 0x306D, 0xE3918C },
	{ 0x306E, 0xE3918D },
	{ 0x306F, 0xE3918E },
	{ 0x3070, 0xE3918F },
	{ 0x3071, 0xE39190 },
	{ 0x3072, 0xE39191 },
	{ 0x3073, 0xE39192 },
	{ 0x3074, 0xE39193 },
	{ 0x3075, 0xE39194 },
	{ 0x3076, 0xE39195 },
	{ 0x3077, 0xE39196 },
	{ 0x3078, 0xE39197 },
	{ 0x3079, 0xE39198 },
	{ 0x307A, 0xE39199 },
	{ 0x307B, 0xE3919A },
	{ 0x307C, 0xE3919B },
	{ 0x307D, 0xE3919C },
	{ 0x307E, 0xE3919D },
	{ 0x3121, 0xE3919E },
	{ 0x3122, 0xE3919F },
	{ 0x3123, 0xE391A0 },
	{ 0x3124, 0xE391A1 },
	{ 0x3125, 0xE391A2 },
	{ 0x3126, 0xE391A3 },
	{ 0x3127, 0xE391A4 },
	{ 0x3128, 0xE391A5 },
	{ 0x3129, 0xE391A6 },
	{ 0x312A, 0xE391A7 },
	{ 0x312B, 0xE391A8 },
	{ 0x312C, 0xE391A9 },
	{ 0x312D, 0xE391AA },
	{ 0x312E, 0xE391AB },
	{ 0x312F, 0xE391AC },
	{ 0x3130, 0xE391AD },
	{ 0x3131, 0xE391AE },
	{ 0x3132, 0xE391AF },
	{ 0x3133, 0xE391B0 },
	{ 0x3134, 0xE391B1 },
	{ 0x3135, 0xE391B2 },
	{ 0x3136, 0xE391B3 },
	{ 0x3137, 0xE391B4 },
	{ 0x3138, 0xE391B5 },
	{ 0x3139, 0xE391B6 },
	{ 0x313A, 0xE391B7 },
	{ 0x313B, 0xE391B8 },
	{ 0x313C, 0xE391B9 },
	{ 0x313D, 0xE391BA },
	{ 0x313E, 0xE391BB },
	{ 0x313F, 0xE391BC },
	{ 0x3140, 0xE391BD },
	{ 0x3141, 0xE391BE },
	{ 0x3142, 0xE391BF },
	{ 0x3143, 0xE39280 },
	{ 0x3144, 0xE39281 },
	{ 0x3145, 0xE39282 },
	{ 0x3146, 0xE39283 },
	{ 0x3147, 0xE39284 },
	{ 0x3148, 0xE39285 },
	{ 0x3149, 0xE39286 },
	{ 0x314A, 0xE39287 },
	{ 0x314B, 0xE39288 },
	{ 0x314C, 0xE39289 },
	{ 0x314D, 0xE3928A },
	{ 0x314E, 0xE3928B },
	{ 0x314F, 0xE3928C },
	{ 0x3150, 0xE3928D },
	{ 0x3151, 0xE3928E },
	{ 0x3152, 0xE3928F },
	{ 0x3153, 0xE39290 },
	{ 0x3154, 0xE39291 },
	{ 0x3155, 0xE39292 },
	{ 0x3156, 0xE39293 },
	{ 0x3157, 0xE39294 },
	{ 0x3158, 0xE39295 },
	{ 0x3159, 0xE39296 },
	{ 0x315A, 0xE39297 },
	{ 0x315B, 0xE39298 },
	{ 0x315C, 0xE39299 },
	{ 0x315D, 0xE3929A },
	{ 0x315E, 0xE3929B },
	{ 0x315F, 0xE3929C },
	{ 0x3160, 0xE3929D },
	{ 0x3161, 0xE3929E },
	{ 0x3162, 0xE3929F },
	{ 0x3163, 0xE392A0 },
	{ 0x3164, 0xE392A1 },
	{ 0x3165, 0xE392A2 },
	{ 0x3166, 0xE392A3 },
	{ 0x3167, 0xE392A4 },
	{ 0x3168, 0xE392A5 },
	{ 0x3169, 0xE392A6 },
	{ 0x316A, 0xE392A7 },
	{ 0x316B, 0xE392A8 },
	{ 0x316C, 0xE392A9 },
	{ 0x316D, 0xE392AA },
	{ 0x316E, 0xE392AB },
	{ 0x316F, 0xE392AC },
	{ 0x3170, 0xE392AD },
	{ 0x3171, 0xE392AE },
	{ 0x3172, 0xE392AF },
	{ 0x3173, 0xE392B0 },
	{ 0x3174, 0xE392B1 },
	{ 0x3175, 0xE392B2 },
	{ 0x3176, 0xE392B3 },
	{ 0x3177, 0xE392B4 },
	{ 0x3178, 0xE392B5 },
	{ 0x3179, 0xE392B6 },
	{ 0x317A, 0xE392B7 },
	{ 0x317B, 0xE392B8 },
	{ 0x317C, 0xE392B9 },
	{ 0x317D, 0xE392BA },
	{ 0x317E, 0xE392BB },
	{ 0x3221, 0xE392BC },
	{ 0x3222, 0xE392BD },
	{ 0x3223, 0xE392BE },
	{ 0x3224, 0xE392BF },
	{ 0x3225, 0xE39380 },
	{ 0x3226, 0xE39381 },
	{ 0x3227, 0xE39382 },
	{ 0x3228, 0xE39383 },
	{ 0x3229, 0xE39384 },
	{ 0x322A, 0xE39385 },
	{ 0x322B, 0xE39386 },
	{ 0x322C, 0xE39387 },
	{ 0x322D, 0xE39388 },
	{ 0x322E, 0xE39389 },
	{ 0x322F, 0xE3938A },
	{ 0x3230, 0xE3938B },
	{ 0x3231, 0xE3938C },
	{ 0x3232, 0xE3938D },
	{ 0x3233, 0xE3938E },
	{ 0x3234, 0xE3938F },
	{ 0x3235, 0xE39390 },
	{ 0x3236, 0xE39391 },
	{ 0x3237, 0xE39392 },
	{ 0x3238, 0xE39393 },
	{ 0x3239, 0xE39394 },
	{ 0x323A, 0xE39395 },
	{ 0x323B, 0xE39396 },
	{ 0x323C, 0xE39397 },
	{ 0x323D, 0xE39398 },
	{ 0x323E, 0xE39399 },
	{ 0x323F, 0xE3939A },
	{ 0x3240, 0xE3939B },
	{ 0x3241, 0xE3939C },
	{ 0x3242, 0xE3939D },
	{ 0x3243, 0xE3939E },
	{ 0x3244, 0xE3939F },
	{ 0x3245, 0xE393A0 },
	{ 0x3246, 0xE393A1 },
	{ 0x3247, 0xE393A2 },
	{ 0x3248, 0xE393A3 },
	{ 0x3249, 0xE393A4 },
	{ 0x324A, 0xE393A5 },
	{ 0x324B, 0xE393A6 },
	{ 0x324C, 0xE393A7 },
	{ 0x324D, 0xE393A8 },
	{ 0x324E, 0xE393A9 },
	{ 0x324F, 0xE393AA },
	{ 0x3250, 0xE393AB },
	{ 0x3251, 0xE393AC },
	{ 0x3252, 0xE393AD },
	{ 0x3253, 0xE393AE },
	{ 0x3254, 0xE393AF },
	{ 0x3255, 0xE393B0 },
	{ 0x3256, 0xE393B1 },
	{ 0x3257, 0xE393B2 },
	{ 0x3258, 0xE393B3 },
	{ 0x3259, 0xE393B4 },
	{ 0x325A, 0xE393B5 },
	{ 0x325B, 0xE393B6 },
	{ 0x325C, 0xE393B7 },
	{ 0x325D, 0xE393B8 },
	{ 0x325E, 0xE393B9 },
	{ 0x325F, 0xE393BA },
	{ 0x3260, 0xE393BB },
	{ 0x3261, 0xE393BC },
	{ 0x3262, 0xE393BD },
	{ 0x3263, 0xE393BE },
	{ 0x3264, 0xE393BF },
	{ 0x3265, 0xE39480 },
	{ 0x3266, 0xE39481 },
	{ 0x3267, 0xE39482 },
	{ 0x3268, 0xE39483 },
	{ 0x3269, 0xE39484 },
	{ 0x326A, 0xE39485 },
	{ 0x326B, 0xE39486 },
	{ 0x326C, 0xE39487 },
	{ 0x326D, 0xE39488 },
	{ 0x326E, 0xE39489 },
	{ 0x326F, 0xE3948A },
	{ 0x3270, 0xE3948B },
	{ 0x3271, 0xE3948C },
	{ 0x3272, 0xE3948D },
	{ 0x3273, 0xE3948E },
	{ 0x3274, 0xE3948F },
	{ 0x3275, 0xE39490 },
	{ 0x3276, 0xE39491 },
	{ 0x3277, 0xE39492 },
	{ 0x3278, 0xE39493 },
	{ 0x3279, 0xE39494 },
	{ 0x327A, 0xE39495 },
	{ 0x327B, 0xE39496 },
	{ 0x327C, 0xE39497 },
	{ 0x327D, 0xE39498 },
	{ 0x327E, 0xE39499 },
	{ 0x3321, 0xE3949A },
	{ 0x3322, 0xE3949B },
	{ 0x3323, 0xE3949C },
	{ 0x3324, 0xE3949D },
	{ 0x3325, 0xE3949E },
	{ 0x3326, 0xE3949F },
	{ 0x3327, 0xE394A0 },
	{ 0x3328, 0xE394A1 },
	{ 0x3329, 0xE394A2 },
	{ 0x332A, 0xE394A3 },
	{ 0x332B, 0xE394A4 },
	{ 0x332C, 0xE394A5 },
	{ 0x332D, 0xE394A6 },
	{ 0x332E, 0xE394A7 },
	{ 0x332F, 0xE394A8 },
	{ 0x3330, 0xE394A9 },
	{ 0x3331, 0xE394AA },
	{ 0x3332, 0xE394AB },
	{ 0x3333, 0xE394AC },
	{ 0x3334, 0xE394AD },
	{ 0x3335, 0xE394AE },
	{ 0x3336, 0xE394AF },
	{ 0x3337, 0xE394B0 },
	{ 0x3338, 0xE394B1 },
	{ 0x3339, 0xE394B2 },
	{ 0x333A, 0xE394B3 },
	{ 0x333B, 0xE394B4 },
	{ 0x333C, 0xE394B5 },
	{ 0x333D, 0xE394B6 },
	{ 0x333E, 0xE394B7 },
	{ 0x333F, 0xE394B8 },
	{ 0x3340, 0xE394B9 },
	{ 0x3341, 0xE394BA },
	{ 0x3342, 0xE394BB },
	{ 0x3343, 0xE394BC },
	{ 0x3344, 0xE394BD },
	{ 0x3345, 0xE394BE },
	{ 0x3346, 0xE394BF },
	{ 0x3347, 0xE39580 },
	{ 0x3348, 0xE39581 },
	{ 0x3349, 0xE39582 },
	{ 0x334A, 0xE39583 },
	{ 0x334B, 0xE39584 },
	{ 0x334C, 0xE39585 },
	{ 0x334D, 0xE39586 },
	{ 0x334E, 0xE39587 },
	{ 0x334F, 0xE39588 },
	{ 0x3350, 0xE39589 },
	{ 0x3351, 0xE3958A },
	{ 0x3352, 0xE3958B },
	{ 0x3353, 0xE3958C },
	{ 0x3354, 0xE3958D },
	{ 0x3355, 0xE3958E },
	{ 0x3356, 0xE3958F },
	{ 0x3357, 0xE39590 },
	{ 0x3358, 0xE39591 },
	{ 0x3359, 0xE39592 },
	{ 0x335A, 0xE39593 },
	{ 0x335B, 0xE39594 },
	{ 0x335C, 0xE39595 },
	{ 0x335D, 0xE39596 },
	{ 0x335E, 0xE39597 },
	{ 0x335F, 0xE39598 },
	{ 0x3360, 0xE39599 },
	{ 0x3361, 0xE3959A },
	{ 0x3362, 0xE3959B },
	{ 0x3363, 0xE3959C },
	{ 0x3364, 0xE3959D },
	{ 0x3365, 0xE3959E },
	{ 0x3366, 0xE3959F },
	{ 0x3367, 0xE395A0 },
	{ 0x3368, 0xE395A1 },
	{ 0x3369, 0xE395A2 },
	{ 0x336A, 0xE395A3 },
	{ 0x336B, 0xE395A4 },
	{ 0x336C, 0xE395A5 },
	{ 0x336D, 0xE395A6 },
	{ 0x336E, 0xE395A7 },
	{ 0x336F, 0xE395A8 },
	{ 0x3370, 0xE395A9 },
	{ 0x3371, 0xE395AA },
	{ 0x3372, 0xE395AB },
	{ 0x3373, 0xE395AC },
	{ 0x3374, 0xE395AD },
	{ 0x3375, 0xE395AE },
	{ 0x3376, 0xE395AF },
	{ 0x3377, 0xE395B0 },
	{ 0x3378, 0xE395B1 },
	{ 0x3379, 0xE395B2 },
	{ 0x337A, 0xE395B3 },
	{ 0x337B, 0xE395B4 },
	{ 0x337C, 0xE395B5 },
	{ 0x337D, 0xE395B6 },
	{ 0x337E, 0xE395B7 },
	{ 0x3421, 0xE395B8 },
	{ 0x3422, 0xE395B9 },
	{ 0x3423, 0xE395BA },
	{ 0x3424, 0xE395BB },
	{ 0x3425, 0xE395BC },
	{ 0x3426, 0xE395BD },
	{ 0x3427, 0xE395BE },
	{ 0x3428, 0xE395BF },
	{ 0x3429, 0xE39680 },
	{ 0x342A, 0xE39681 },
	{ 0x342B, 0xE39682 },
	{ 0x342C, 0xE39683 },
	{ 0x342D, 0xE39684 },
	{ 0x342E, 0xE39685 },
	{ 0x342F, 0xE39686 },
	{ 0x3430, 0xE39687 },
	{ 0x3431, 0xE39688 },
	{ 0x3432, 0xE39689 },
	{ 0x3433, 0xE3968A },
	{ 0x3434, 0xE3968B },
	{ 0x3435, 0xE3968C },
	{ 0x3436, 0xE3968D },
	{ 0x3437, 0xE3968E },
	{ 0x3438, 0xE3968F },
	{ 0x3439, 0xE39690 },
	{ 0x343A, 0xE39691 },
	{ 0x343B, 0xE39692 },
	{ 0x343C, 0xE39693 },
	{ 0x343D, 0xE39694 },
	{ 0x343E, 0xE39695 },
	{ 0x343F, 0xE39696 },
	{ 0x3440, 0xE39697 },
	{ 0x3441, 0xE39698 },
	{ 0x3442, 0xE39699 },
	{ 0x3443, 0xE3969A },
	{ 0x3444, 0xE3969B },
	{ 0x3445, 0xE3969C },
	{ 0x3446, 0xE3969D },
	{ 0x3447, 0xE3969E },
	{ 0x3448, 0xE3969F },
	{ 0x3449, 0xE396A0 },
	{ 0x344A, 0xE396A1 },
	{ 0x344B, 0xE396A2 },
	{ 0x344C, 0xE396A3 },
	{ 0x344D, 0xE396A4 },
	{ 0x344E, 0xE396A5 },
	{ 0x344F, 0xE396A6 },
	{ 0x3450, 0xE396A7 },
	{ 0x3451, 0xE396A8 },
	{ 0x3452, 0xE396A9 },
	{ 0x3453, 0xE396AA },
	{ 0x3454, 0xE396AB },
	{ 0x3455, 0xE396AC },
	{ 0x3456, 0xE396AD },
	{ 0x3457, 0xE396AE },
	{ 0x3458, 0xE396AF },
	{ 0x3459, 0xE396B0 },
	{ 0x345A, 0xE396B1 },
	{ 0x345B, 0xE396B2 },
	{ 0x345C, 0xE396B3 },
	{ 0x345D, 0xE396B4 },
	{ 0x345E, 0xE396B5 },
	{ 0x345F, 0xE396B6 },
	{ 0x3460, 0xE396B7 },
	{ 0x3461, 0xE396B8 },
	{ 0x3462, 0xE396B9 },
	{ 0x3463, 0xE396BA },
	{ 0x3464, 0xE396BB },
	{ 0x3465, 0xE396BC },
	{ 0x3466, 0xE396BD },
	{ 0x3467, 0xE396BE },
	{ 0x3468, 0xE396BF },
	{ 0x3469, 0xE39780 },
	{ 0x346A, 0xE39781 },
	{ 0x346B, 0xE39782 },
	{ 0x346C, 0xE39783 },
	{ 0x346D, 0xE39784 },
	{ 0x346E, 0xE39785 },
	{ 0x346F, 0xE39786 },
	{ 0x3470, 0xE39787 },
	{ 0x3471, 0xE39788 },
	{ 0x3472, 0xE39789 },
	{ 0x3473, 0xE3978A },
	{ 0x3474, 0xE3978B },
	{ 0x3475, 0xE3978C },
	{ 0x3476, 0xE3978D },
	{ 0x3477, 0xE3978E },
	{ 0x3478, 0xE3978F },
	{ 0x3479, 0xE39790 },
	{ 0x347A, 0xE39791 },
	{ 0x347B, 0xE39792 },
	{ 0x347C, 0xE39793 },
	{ 0x347D, 0xE39794 },
	{ 0x347E, 0xE39795 },
	{ 0x3521, 0xE39796 },
	{ 0x3522, 0xE39797 },
	{ 0x3523, 0xE39798 },
	{ 0x3524, 0xE39799 },
	{ 0x3525, 0xE3979A },
	{ 0x3526, 0xE3979B },
	{ 0x3527, 0xE3979C },
	{ 0x3528, 0xE3979D },
	{ 0x3529, 0xE3979E },
	{ 0x352A, 0xE3979F },
	{ 0x352B, 0xE397A0 },
	{ 0x352C, 0xE397A1 },
	{ 0x352D, 0xE397A2 },
	{ 0x352E, 0xE397A3 },
	{ 0x352F, 0xE397A4 },
	{ 0x3530, 0xE397A5 },
	{ 0x3531, 0xE397A6 },
	{ 0x3532, 0xE397A7 },
	{ 0x3533, 0xE397A8 },
	{ 0x3534, 0xE397A9 },
	{ 0x3535, 0xE397AA },
	{ 0x3536, 0xE397AB },
	{ 0x3537, 0xE397AC },
	{ 0x3538, 0xE397AD },
	{ 0x3539, 0xE397AE },
	{ 0x353A, 0xE397AF },
	{ 0x353B, 0xE397B0 },
	{ 0x353C, 0xE397B1 },
	{ 0x353D, 0xE397B2 },
	{ 0x353E, 0xE397B3 },
	{ 0x353F, 0xE397B4 },
	{ 0x3540, 0xE397B5 },
	{ 0x3541, 0xE397B6 },
	{ 0x3542, 0xE397B7 },
	{ 0x3543, 0xE397B8 },
	{ 0x3544, 0xE397B9 },
	{ 0x3545, 0xE397BA },
	{ 0x3546, 0xE397BB },
	{ 0x3547, 0xE397BC },
	{ 0x3548, 0xE397BD },
	{ 0x3549, 0xE397BE },
	{ 0x354A, 0xE397BF },
	{ 0x354B, 0xE39880 },
	{ 0x354C, 0xE39881 },
	{ 0x354D, 0xE39882 },
	{ 0x354E, 0xE39883 },
	{ 0x354F, 0xE39884 },
	{ 0x3550, 0xE39885 },
	{ 0x3551, 0xE39886 },
	{ 0x3552, 0xE39887 },
	{ 0x3553, 0xE39888 },
	{ 0x3554, 0xE39889 },
	{ 0x3555, 0xE3988A },
	{ 0x3556, 0xE3988B },
	{ 0x3557, 0xE3988C },
	{ 0x3558, 0xE3988D },
	{ 0x3559, 0xE3988E },
	{ 0x355A, 0xE3988F },
	{ 0x355B, 0xE39890 },
	{ 0x355C, 0xE39891 },
	{ 0x355D, 0xE39892 },
	{ 0x355E, 0xE39893 },
	{ 0x355F, 0xE39894 },
	{ 0x3560, 0xE39895 },
	{ 0x3561, 0xE39896 },
	{ 0x3562, 0xE39897 },
	{ 0x3563, 0xE39898 },
	{ 0x3564, 0xE39899 },
	{ 0x3565, 0xE3989A },
	{ 0x3566, 0xE3989B },
	{ 0x3567, 0xE3989C },
	{ 0x3568, 0xE3989D },
	{ 0x3569, 0xE3989E },
	{ 0x356A, 0xE3989F },
	{ 0x356B, 0xE398A0 },
	{ 0x356C, 0xE398A1 },
	{ 0x356D, 0xE398A2 },
	{ 0x356E, 0xE398A3 },
	{ 0x356F, 0xE398A4 },
	{ 0x3570, 0xE398A5 },
	{ 0x3571, 0xE398A6 },
	{ 0x3572, 0xE398A7 },
	{ 0x3573, 0xE398A8 },
	{ 0x3574, 0xE398A9 },
	{ 0x3575, 0xE398AA },
	{ 0x3576, 0xE398AB },
	{ 0x3577, 0xE398AC },
	{ 0x3578, 0xE398AD },
	{ 0x3579, 0xE398AE },
	{ 0x357A, 0xE398AF },
	{ 0x357B, 0xE398B0 },
	{ 0x357C, 0xE398B1 },
	{ 0x357D, 0xE398B2 },
	{ 0x357E, 0xE398B3 },
	{ 0x3621, 0xE398B4 },
	{ 0x3622, 0xE398B5 },
	{ 0x3623, 0xE398B6 },
	{ 0x3624, 0xE398B7 },
	{ 0x3625, 0xE398B8 },
	{ 0x3626, 0xE398B9 },
	{ 0x3627, 0xE398BA },
	{ 0x3628, 0xE398BB },
	{ 0x3629, 0xE398BC },
	{ 0x362A, 0xE398BD },
	{ 0x362B, 0xE398BE },
	{ 0x362C, 0xE398BF },
	{ 0x362D, 0xE39980 },
	{ 0x362E, 0xE39981 },
	{ 0x362F, 0xE39982 },
	{ 0x3630, 0xE39983 },
	{ 0x3631, 0xE39984 },
	{ 0x3632, 0xE39985 },
	{ 0x3633, 0xE39986 },
	{ 0x3634, 0xE39987 },
	{ 0x3635, 0xE39988 },
	{ 0x3636, 0xE39989 },
	{ 0x3637, 0xE3998A },
	{ 0x3638, 0xE3998B },
	{ 0x3639, 0xE3998C },
	{ 0x363A, 0xE3998D },
	{ 0x363B, 0xE3998E },
	{ 0x363C, 0xE3998F },
	{ 0x363D, 0xE39990 },
	{ 0x363E, 0xE39991 },
	{ 0x363F, 0xE39992 },
	{ 0x3640, 0xE39993 },
	{ 0x3641, 0xE39994 },
	{ 0x3642, 0xE39995 },
	{ 0x3643, 0xE39996 },
	{ 0x3644, 0xE39997 },
	{ 0x3645, 0xE39998 },
	{ 0x3646, 0xE39999 },
	{ 0x3647, 0xE3999A },
	{ 0x3648, 0xE3999B },
	{ 0x3649, 0xE3999C },
	{ 0x364A, 0xE3999D },
	{ 0x364B, 0xE3999E },
	{ 0x364C, 0xE3999F },
	{ 0x364D, 0xE399A0 },
	{ 0x364E, 0xE399A1 },
	{ 0x364F, 0xE399A2 },
	{ 0x3650, 0xE399A3 },
	{ 0x3651, 0xE399A4 },
	{ 0x3652, 0xE399A5 },
	{ 0x3653, 0xE399A6 },
	{ 0x3654, 0xE399A7 },
	{ 0x3655, 0xE399A8 },
	{ 0x3656, 0xE399A9 },
	{ 0x3657, 0xE399AA },
	{ 0x3658, 0xE399AB },
	{ 0x3659, 0xE399AC },
	{ 0x365A, 0xE399AD },
	{ 0x365B, 0xE399AE },
	{ 0x365C, 0xE399AF },
	{ 0x365D, 0xE399B0 },
	{ 0x365E, 0xE399B1 },
	{ 0x365F, 0xE399B2 },
	{ 0x3660, 0xE399B3 },
	{ 0x3661, 0xE399B4 },
	{ 0x3662, 0xE399B5 },
	{ 0x3663, 0xE399B6 },
	{ 0x3664, 0xE399B7 },
	{ 0x3665, 0xE399B8 },
	{ 0x3666, 0xE399B9 },
	{ 0x3667, 0xE399BA },
	{ 0x3668, 0xE399BB },
	{ 0x3669, 0xE399BC },
	{ 0x366A, 0xE399BD },
	{ 0x366B, 0xE399BE },
	{ 0x366C, 0xE399BF },
	{ 0x366D, 0xE39A80 },
	{ 0x366E, 0xE39A81 },
	{ 0x366F, 0xE39A82 },
	{ 0x3670, 0xE39A83 },
	{ 0x3671, 0xE39A84 },
	{ 0x3672, 0xE39A85 },
	{ 0x3673, 0xE39A86 },
	{ 0x3674, 0xE39A87 },
	{ 0x3675, 0xE39A88 },
	{ 0x3676, 0xE39A89 },
	{ 0x3677, 0xE39A8A },
	{ 0x3678, 0xE39A8B },
	{ 0x3679, 0xE39A8C },
	{ 0x367A, 0xE39A8D },
	{ 0x367B, 0xE39A8E },
	{ 0x367C, 0xE39A8F },
	{ 0x367D, 0xE39A90 },
	{ 0x367E, 0xE39A91 },
	{ 0x3721, 0xE39A92 },
	{ 0x3722, 0xE39A93 },
	{ 0x3723, 0xE39A94 },
	{ 0x3724, 0xE39A95 },
	{ 0x3725, 0xE39A96 },
	{ 0x3726, 0xE39A97 },
	{ 0x3727, 0xE39A98 },
	{ 0x3728, 0xE39A99 },
	{ 0x3729, 0xE39A9A },
	{ 0x372A, 0xE39A9B },
	{ 0x372B, 0xE39A9C },
	{ 0x372C, 0xE39A9D },
	{ 0x372D, 0xE39A9E },
	{ 0x372E, 0xE39A9F },
	{ 0x372F, 0xE39AA0 },
	{ 0x3730, 0xE39AA1 },
	{ 0x3731, 0xE39AA2 },
	{ 0x3732, 0xE39AA3 },
	{ 0x3733, 0xE39AA4 },
	{ 0x3734, 0xE39AA5 },
	{ 0x3735, 0xE39AA6 },
	{ 0x3736, 0xE39AA7 },
	{ 0x3737, 0xE39AA8 },
	{ 0x3738, 0xE39AA9 },
	{ 0x3739, 0xE39AAA },
	{ 0x373A, 0xE39AAB },
	{ 0x373B, 0xE39AAC },
	{ 0x373C, 0xE39AAD },
	{ 0x373D, 0xE39AAE },
	{ 0x373E, 0xE39AAF },
	{ 0x373F, 0xE39AB0 },
	{ 0x3740, 0xE39AB1 },
	{ 0x3741, 0xE39AB2 },
	{ 0x3742, 0xE39AB3 },
	{ 0x3743, 0xE39AB4 },
	{ 0x3744, 0xE39AB5 },
	{ 0x3745, 0xE39AB6 },
	{ 0x3746, 0xE39AB7 },
	{ 0x3747, 0xE39AB8 },
	{ 0x3748, 0xE39AB9 },
	{ 0x3749, 0xE39ABA },
	{ 0x374A, 0xE39ABB },
	{ 0x374B, 0xE39ABC },
	{ 0x374C, 0xE39ABD },
	{ 0x374D, 0xE39ABE },
	{ 0x374E, 0xE39ABF },
	{ 0x374F, 0xE39B80 },
	{ 0x3750, 0xE39B81 },
	{ 0x3751, 0xE39B82 },
	{ 0x3752, 0xE39B83 },
	{ 0x3753, 0xE39B84 },
	{ 0x3754, 0xE39B85 },
	{ 0x3755, 0xE39B86 },
	{ 0x3756, 0xE39B87 },
	{ 0x3757, 0xE39B88 },
	{ 0x3758, 0xE39B89 },
	{ 0x3759, 0xE39B8A },
	{ 0x375A, 0xE39B8B },
	{ 0x375B, 0xE39B8C },
	{ 0x375C, 0xE39B8D },
	{ 0x375D, 0xE39B8E },
	{ 0x375E, 0xE39B8F },
	{ 0x375F, 0xE39B90 },
	{ 0x3760, 0xE39B91 },
	{ 0x3761, 0xE39B92 },
	{ 0x3762, 0xE39B93 },
	{ 0x3763, 0xE39B94 },
	{ 0x3764, 0xE39B95 },
	{ 0x3765, 0xE39B96 },
	{ 0x3766, 0xE39B97 },
	{ 0x3767, 0xE39B98 },
	{ 0x3768, 0xE39B99 },
	{ 0x3769, 0xE39B9A },
	{ 0x376A, 0xE39B9B },
	{ 0x376B, 0xE39B9C },
	{ 0x376C, 0xE39B9D },
	{ 0x376D, 0xE39B9E },
	{ 0x376E, 0xE39B9F },
	{ 0x376F, 0xE39BA0 },
	{ 0x3770, 0xE39BA1 },
	{ 0x3771, 0xE39BA2 },
	{ 0x3772, 0xE39BA3 },
	{ 0x3773, 0xE39BA4 },
	{ 0x3774, 0xE39BA5 },
	{ 0x3775, 0xE39BA6 },
	{ 0x3776, 0xE39BA7 },
	{ 0x3777, 0xE39BA8 },
	{ 0x3778, 0xE39BA9 },
	{ 0x3779, 0xE39BAA },
	{ 0x377A, 0xE39BAB },
	{ 0x377B, 0xE39BAC },
	{ 0x377C, 0xE39BAD },
	{ 0x377D, 0xE39BAE },
	{ 0x377E, 0xE39BAF },
	{ 0x3821, 0xE39BB0 },
	{ 0x3822, 0xE39BB1 },
	{ 0x3823, 0xE39BB2 },
	{ 0x3824, 0xE39BB3 },
	{ 0x3825, 0xE39BB4 },
	{ 0x3826, 0xE39BB5 },
	{ 0x3827, 0xE39BB6 },
	{ 0x3828, 0xE39BB7 },
	{ 0x3829, 0xE39BB8 },
	{ 0x382A, 0xE39BB9 },
	{ 0x382B, 0xE39BBA },
	{ 0x382C, 0xE39BBB },
	{ 0x382D, 0xE39BBC },
	{ 0x382E, 0xE39BBD },
	{ 0x382F, 0xE39BBE },
	{ 0x3830, 0xE39BBF },
	{ 0x3831, 0xE39C80 },
	{ 0x3832, 0xE39C81 },
	{ 0x3833, 0xE39C82 },
	{ 0x3834, 0xE39C83 },
	{ 0x3835, 0xE39C84 },
	{ 0x3836, 0xE39C85 },
	{ 0x3837, 0xE39C86 },
	{ 0x3838, 0xE39C87 },
	{ 0x3839, 0xE39C88 },
	{ 0x383A, 0xE39C89 },
	{ 0x383B, 0xE39C8A },
	{ 0x383C, 0xE39C8B },
	{ 0x383D, 0xE39C8C },
	{ 0x383E, 0xE39C8D },
	{ 0x383F, 0xE39C8E },
	{ 0x3840, 0xE39C8F },
	{ 0x3841, 0xE39C90 },
	{ 0x3842, 0xE39C91 },
	{ 0x3843, 0xE39C92 },
	{ 0x3844, 0xE39C93 },
	{ 0x3845, 0xE39C94 },
	{ 0x3846, 0xE39C95 },
	{ 0x3847, 0xE39C96 },
	{ 0x3848, 0xE39C97 },
	{ 0x3849, 0xE39C98 },
	{ 0x384A, 0xE39C99 },
	{ 0x384B, 0xE39C9A },
	{ 0x384C, 0xE39C9B },
	{ 0x384D, 0xE39C9C },
	{ 0x384E, 0xE39C9D },
	{ 0x384F, 0xE39C9E },
	{ 0x3850, 0xE39C9F },
	{ 0x3851, 0xE39CA0 },
	{ 0x3852, 0xE39CA1 },
	{ 0x3853, 0xE39CA2 },
	{ 0x3854, 0xE39CA3 },
	{ 0x3855, 0xE39CA4 },
	{ 0x3856, 0xE39CA5 },
	{ 0x3857, 0xE39CA6 },
	{ 0x3858, 0xE39CA7 },
	{ 0x3859, 0xE39CA8 },
	{ 0x385A, 0xE39CA9 },
	{ 0x385B, 0xE39CAA },
	{ 0x385C, 0xE39CAB },
	{ 0x385D, 0xE39CAC },
	{ 0x385E, 0xE39CAD },
	{ 0x385F, 0xE39CAE },
	{ 0x3860, 0xE39CAF },
	{ 0x3861, 0xE39CB0 },
	{ 0x3862, 0xE39CB1 },
	{ 0x3863, 0xE39CB2 },
	{ 0x3864, 0xE39CB3 },
	{ 0x3865, 0xE39CB4 },
	{ 0x3866, 0xE39CB5 },
	{ 0x3867, 0xE39CB6 },
	{ 0x3868, 0xE39CB7 },
	{ 0x3869, 0xE39CB8 },
	{ 0x386A, 0xE39CB9 },
	{ 0x386B, 0xE39CBA },
	{ 0x386C, 0xE39CBB },
	{ 0x386D, 0xE39CBC },
	{ 0x386E, 0xE39CBD },
	{ 0x386F, 0xE39CBE },
	{ 0x3870, 0xE39CBF },
	{ 0x3871, 0xE39D80 },
	{ 0x3872, 0xE39D81 },
	{ 0x3873, 0xE39D82 },
	{ 0x3874, 0xE39D83 },
	{ 0x3875, 0xE39D84 },
	{ 0x3876, 0xE39D85 },
	{ 0x3877, 0xE39D86 },
	{ 0x3878, 0xE39D87 },
	{ 0x3879, 0xE39D88 },
	{ 0x387A, 0xE39D89 },
	{ 0x387B, 0xE39D8A },
	{ 0x387C, 0xE39D8B },
	{ 0x387D, 0xE39D8C },
	{ 0x387E, 0xE39D8D },
	{ 0x3921, 0xE39D8E },
	{ 0x3922, 0xE39D8F },
	{ 0x3923, 0xE39D90 },
	{ 0x3924, 0xE39D91 },
	{ 0x3925, 0xE39D92 },
	{ 0x3926, 0xE39D93 },
	{ 0x3927, 0xE39D94 },
	{ 0x3928, 0xE39D95 },
	{ 0x3929, 0xE39D96 },
	{ 0x392A, 0xE39D97 },
	{ 0x392B, 0xE39D98 },
	{ 0x392C, 0xE39D99 },
	{ 0x392D, 0xE39D9A },
	{ 0x392E, 0xE39D9B },
	{ 0x392F, 0xE39D9C },
	{ 0x3930, 0xE39D9D },
	{ 0x3931, 0xE39D9E },
	{ 0x3932, 0xE39D9F },
	{ 0x3933, 0xE39DA0 },
	{ 0x3934, 0xE39DA1 },
	{ 0x3935, 0xE39DA2 },
	{ 0x3936, 0xE39DA3 },
	{ 0x3937, 0xE39DA4 },
	{ 0x3938, 0xE39DA5 },
	{ 0x3939, 0xE39DA6 },
	{ 0x393A, 0xE39DA7 },
	{ 0x393B, 0xE39DA8 },
	{ 0x393C, 0xE39DA9 },
	{ 0x393D, 0xE39DAA },
	{ 0x393E, 0xE39DAB },
	{ 0x393F, 0xE39DAC },
	{ 0x3940, 0xE39DAD },
	{ 0x3941, 0xE39DAE },
	{ 0x3942, 0xE39DAF },
	{ 0x3943, 0xE39DB0 },
	{ 0x3944, 0xE39DB1 },
	{ 0x3945, 0xE39DB2 },
	{ 0x3946, 0xE39DB3 },
	{ 0x3947, 0xE39DB4 },
	{ 0x3948, 0xE39DB5 },
	{ 0x3949, 0xE39DB6 },
	{ 0x394A, 0xE39DB7 },
	{ 0x394B, 0xE39DB8 },
	{ 0x394C, 0xE39DB9 },
	{ 0x394D, 0xE39DBA },
	{ 0x394E, 0xE39DBB },
	{ 0x394F, 0xE39DBC },
	{ 0x3950, 0xE39DBD },
	{ 0x3951, 0xE39DBE },
	{ 0x3952, 0xE39DBF },
	{ 0x3953, 0xE39E80 },
	{ 0x3954, 0xE39E81 },
	{ 0x3955, 0xE39E82 },
	{ 0x3956, 0xE39E83 },
	{ 0x3957, 0xE39E84 },
	{ 0x3958, 0xE39E85 },
	{ 0x3959, 0xE39E86 },
	{ 0x395A, 0xE39E87 },
	{ 0x395B, 0xE39E88 },
	{ 0x395C, 0xE39E89 },
	{ 0x395D, 0xE39E8A },
	{ 0x395E, 0xE39E8B },
	{ 0x395F, 0xE39E8C },
	{ 0x3960, 0xE39E8D },
	{ 0x3961, 0xE39E8E },
	{ 0x3962, 0xE39E8F },
	{ 0x3963, 0xE39E90 },
	{ 0x3964, 0xE39E91 },
	{ 0x3965, 0xE39E92 },
	{ 0x3966, 0xE39E93 },
	{ 0x3967, 0xE39E94 },
	{ 0x3968, 0xE39E95 },
	{ 0x3969, 0xE39E96 },
	{ 0x396A, 0xE39E97 },
	{ 0x396B, 0xE39E98 },
	{ 0x396C, 0xE39E99 },
	{ 0x396D, 0xE39E9A },
	{ 0x396E, 0xE39E9B },
	{ 0x396F, 0xE39E9C },
	{ 0x3970, 0xE39E9D },
	{ 0x3971, 0xE39E9E },
	{ 0x3972, 0xE39E9F },
	{ 0x3973, 0xE39EA0 },
	{ 0x3974, 0xE39EA1 },
	{ 0x3975, 0xE39EA2 },
	{ 0x3976, 0xE39EA3 },
	{ 0x3977, 0xE39EA4 },
	{ 0x3978, 0xE39EA5 },
	{ 0x3979, 0xE39EA6 },
	{ 0x397A, 0xE39EA7 },
	{ 0x397B, 0xE39EA8 },
	{ 0x397C, 0xE39EA9 },
	{ 0x397D, 0xE39EAA },
	{ 0x397E, 0xE39EAB },
	{ 0x3A21, 0xE39EAC },
	{ 0x3A22, 0xE39EAD },
	{ 0x3A23, 0xE39EAE },
	{ 0x3A24, 0xE39EAF },
	{ 0x3A25, 0xE39EB0 },
	{ 0x3A26, 0xE39EB1 },
	{ 0x3A27, 0xE39EB2 },
	{ 0x3A28, 0xE39EB3 },
	{ 0x3A29, 0xE39EB4 },
	{ 0x3A2A, 0xE39EB5 },
	{ 0x3A2B, 0xE39EB6 },
	{ 0x3A2C, 0xE39EB7 },
	{ 0x3A2D, 0xE39EB8 },
	{ 0x3A2E, 0xE39EB9 },
	{ 0x3A2F, 0xE39EBA },
	{ 0x3A30, 0xE39EBB },
	{ 0x3A31, 0xE39EBC },
	{ 0x3A32, 0xE39EBD },
	{ 0x3A33, 0xE39EBE },
	{ 0x3A34, 0xE39EBF },
	{ 0x3A35, 0xE39F80 },
	{ 0x3A36, 0xE39F81 },
	{ 0x3A37, 0xE39F82 },
	{ 0x3A38, 0xE39F83 },
	{ 0x3A39, 0xE39F84 },
	{ 0x3A3A, 0xE39F85 },
	{ 0x3A3B, 0xE39F86 },
	{ 0x3A3C, 0xE39F87 },
	{ 0x3A3D, 0xE39F88 },
	{ 0x3A3E, 0xE39F89 },
	{ 0x3A3F, 0xE39F8A },
	{ 0x3A40, 0xE39F8B },
	{ 0x3A41, 0xE39F8C },
	{ 0x3A42, 0xE39F8D },
	{ 0x3A43, 0xE39F8E },
	{ 0x3A44, 0xE39F8F },
	{ 0x3A45, 0xE39F90 },
	{ 0x3A46, 0xE39F91 },
	{ 0x3A47, 0xE39F92 },
	{ 0x3A48, 0xE39F93 },
	{ 0x3A49, 0xE39F94 },
	{ 0x3A4A, 0xE39F95 },
	{ 0x3A4B, 0xE39F96 },
	{ 0x3A4C, 0xE39F97 },
	{ 0x3A4D, 0xE39F98 },
	{ 0x3A4E, 0xE39F99 },
	{ 0x3A4F, 0xE39F9A },
	{ 0x3A50, 0xE39F9B },
	{ 0x3A51, 0xE39F9C },
	{ 0x3A52, 0xE39F9D },
	{ 0x3A53, 0xE39F9E },
	{ 0x3A54, 0xE39F9F },
	{ 0x3A55, 0xE39FA0 },
	{ 0x3A56, 0xE39FA1 },
	{ 0x3A57, 0xE39FA2 },
	{ 0x3A58, 0xE39FA3 },
	{ 0x3A59, 0xE39FA4 },
	{ 0x3A5A, 0xE39FA5 },
	{ 0x3A5B, 0xE39FA6 },
	{ 0x3A5C, 0xE39FA7 },
	{ 0x3A5D, 0xE39FA8 },
	{ 0x3A5E, 0xE39FA9 },
	{ 0x3A5F, 0xE39FAA },
	{ 0x3A60, 0xE39FAB },
	{ 0x3A61, 0xE39FAC },
	{ 0x3A62, 0xE39FAD },
	{ 0x3A63, 0xE39FAE },
	{ 0x3A64, 0xE39FAF },
	{ 0x3A65, 0xE39FB0 },
	{ 0x3A66, 0xE39FB1 },
	{ 0x3A67, 0xE39FB2 },
	{ 0x3A68, 0xE39FB3 },
	{ 0x3A69, 0xE39FB4 },
	{ 0x3A6A, 0xE39FB5 },
	{ 0x3A6B, 0xE39FB6 },
	{ 0x3A6C, 0xE39FB7 },
	{ 0x3A6D, 0xE39FB8 },
	{ 0x3A6E, 0xE39FB9 },
	{ 0x3A6F, 0xE39FBA },
	{ 0x3A70, 0xE39FBB },
	{ 0x3A71, 0xE39FBC },
	{ 0x3A72, 0xE39FBD },
	{ 0x3A73, 0xE39FBE },
	{ 0x3A74, 0xE39FBF },
	{ 0x3A75, 0xE3A080 },
	{ 0x3A76, 0xE3A081 },
	{ 0x3A77, 0xE3A082 },
	{ 0x3A78, 0xE3A083 },
	{ 0x3A79, 0xE3A084 },
	{ 0x3A7A, 0xE3A085 },
	{ 0x3A7B, 0xE3A086 },
	{ 0x3A7C, 0xE3A087 },
	{ 0x3A7D, 0xE3A088 },
	{ 0x3A7E, 0xE3A089 },
	{ 0x3B21, 0xE3A08A },
	{ 0x3B22, 0xE3A08B },
	{ 0x3B23, 0xE3A08C },
	{ 0x3B24, 0xE3A08D },
	{ 0x3B25, 0xE3A08E },
	{ 0x3B26, 0xE3A08F },
	{ 0x3B27, 0xE3A090 },
	{ 0x3B28, 0xE3A091 },
	{ 0x3B29, 0xE3A092 },
	{ 0x3B2A, 0xE3A093 },
	{ 0x3B2B, 0xE3A094 },
	{ 0x3B2C, 0xE3A095 },
	{ 0x3B2D, 0xE3A096 },
	{ 0x3B2E, 0xE3A097 },
	{ 0x3B2F, 0xE3A098 },
	{ 0x3B30, 0xE3A099 },
	{ 0x3B31, 0xE3A09A },
	{ 0x3B32, 0xE3A09B },
	{ 0x3B33, 0xE3A09C },
	{ 0x3B34, 0xE3A09D },
	{ 0x3B35, 0xE3A09E },
	{ 0x3B36, 0xE3A09F },
	{ 0x3B37, 0xE3A0A0 },
	{ 0x3B38, 0xE3A0A1 },
	{ 0x3B39, 0xE3A0A2 },
	{ 0x3B3A, 0xE3A0A3 },
	{ 0x3B3B, 0xE3A0A4 },
	{ 0x3B3C, 0xE3A0A5 },
	{ 0x3B3D, 0xE3A0A6 },
	{ 0x3B3E, 0xE3A0A7 },
	{ 0x3B3F, 0xE3A0A8 },
	{ 0x3B40, 0xE3A0A9 },
	{ 0x3B41, 0xE3A0AA },
	{ 0x3B42, 0xE3A0AB },
	{ 0x3B43, 0xE3A0AC },
	{ 0x3B44, 0xE3A0AD },
	{ 0x3B45, 0xE3A0AE },
	{ 0x3B46, 0xE3A0AF },
	{ 0x3B47, 0xE3A0B0 },
	{ 0x3B48, 0xE3A0B1 },
	{ 0x3B49, 0xE3A0B2 },
	{ 0x3B4A, 0xE3A0B3 },
	{ 0x3B4B, 0xE3A0B4 },
	{ 0x3B4C, 0xE3A0B5 },
	{ 0x3B4D, 0xE3A0B6 },
	{ 0x3B4E, 0xE3A0B7 },
	{ 0x3B4F, 0xE3A0B8 },
	{ 0x3B50, 0xE3A0B9 },
	{ 0x3B51, 0xE3A0BA },
	{ 0x3B52, 0xE3A0BB },
	{ 0x3B53, 0xE3A0BC },
	{ 0x3B54, 0xE3A0BD },
	{ 0x3B55, 0xE3A0BE },
	{ 0x3B56, 0xE3A0BF },
	{ 0x3B57, 0xE3A180 },
	{ 0x3B58, 0xE3A181 },
	{ 0x3B59, 0xE3A182 },
	{ 0x3B5A, 0xE3A183 },
	{ 0x3B5B, 0xE3A184 },
	{ 0x3B5C, 0xE3A185 },
	{ 0x3B5D, 0xE3A186 },
	{ 0x3B5E, 0xE3A187 },
	{ 0x3B5F, 0xE3A188 },
	{ 0x3B60, 0xE3A189 },
	{ 0x3B61, 0xE3A18A },
	{ 0x3B62, 0xE3A18B },
	{ 0x3B63, 0xE3A18C },
	{ 0x3B64, 0xE3A18D },
	{ 0x3B65, 0xE3A18E },
	{ 0x3B66, 0xE3A18F },
	{ 0x3B67, 0xE3A190 },
	{ 0x3B68, 0xE3A191 },
	{ 0x3B69, 0xE3A192 },
	{ 0x3B6A, 0xE3A193 },
	{ 0x3B6B, 0xE3A194 },
	{ 0x3B6C, 0xE3A195 },
	{ 0x3B6D, 0xE3A196 },
	{ 0x3B6E, 0xE3A197 },
	{ 0x3B6F, 0xE3A198 },
	{ 0x3B70, 0xE3A199 },
	{ 0x3B71, 0xE3A19A },
	{ 0x3B72, 0xE3A19B },
	{ 0x3B73, 0xE3A19C },
	{ 0x3B74, 0xE3A19D },
	{ 0x3B75, 0xE3A19E },
	{ 0x3B76, 0xE3A19F },
	{ 0x3B77, 0xE3A1A0 },
	{ 0x3B78, 0xE3A1A1 },
	{ 0x3B79, 0xE3A1A2 },
	{ 0x3B7A, 0xE3A1A3 },
	{ 0x3B7B, 0xE3A1A4 },
	{ 0x3B7C, 0xE3A1A5 },
	{ 0x3B7D, 0xE3A1A6 },
	{ 0x3B7E, 0xE3A1A7 },
	{ 0x3C21, 0xE3A1A8 },
	{ 0x3C22, 0xE3A1A9 },
	{ 0x3C23, 0xE3A1AA },
	{ 0x3C24, 0xE3A1AB },
	{ 0x3C25, 0xE3A1AC },
	{ 0x3C26, 0xE3A1AD },
	{ 0x3C27, 0xE3A1AE },
	{ 0x3C28, 0xE3A1AF },
	{ 0x3C29, 0xE3A1B0 },
	{ 0x3C2A, 0xE3A1B1 },
	{ 0x3C2B, 0xE3A1B2 },
	{ 0x3C2C, 0xE3A1B3 },
	{ 0x3C2D, 0xE3A1B4 },
	{ 0x3C2E, 0xE3A1B5 },
	{ 0x3C2F, 0xE3A1B6 },
	{ 0x3C30, 0xE3A1B7 },
	{ 0x3C31, 0xE3A1B8 },
	{ 0x3C32, 0xE3A1B9 },
	{ 0x3C33, 0xE3A1BA },
	{ 0x3C34, 0xE3A1BB },
	{ 0x3C35, 0xE3A1BC },
	{ 0x3C36, 0xE3A1BD },
	{ 0x3C37, 0xE3A1BE },
	{ 0x3C38, 0xE3A1BF },
	{ 0x3C39, 0xE3A280 },
	{ 0x3C3A, 0xE3A281 },
	{ 0x3C3B, 0xE3A282 },
	{ 0x3C3C, 0xE3A283 },
	{ 0x3C3D, 0xE3A284 },
	{ 0x3C3E, 0xE3A285 },
	{ 0x3C3F, 0xE3A286 },
	{ 0x3C40, 0xE3A287 },
	{ 0x3C41, 0xE3A288 },
	{ 0x3C42, 0xE3A289 },
	{ 0x3C43, 0xE3A28A },
	{ 0x3C44, 0xE3A28B },
	{ 0x3C45, 0xE3A28C },
	{ 0x3C46, 0xE3A28D },
	{ 0x3C47, 0xE3A28E },
	{ 0x3C48, 0xE3A28F },
	{ 0x3C49, 0xE3A290 },
	{ 0x3C4A, 0xE3A291 },
	{ 0x3C4B, 0xE3A292 },
	{ 0x3C4C, 0xE3A293 },
	{ 0x3C4D, 0xE3A294 },
	{ 0x3C4E, 0xE3A295 },
	{ 0x3C4F, 0xE3A296 },
	{ 0x3C50, 0xE3A297 },
	{ 0x3C51, 0xE3A298 },
	{ 0x3C52, 0xE3A299 },
	{ 0x3C53, 0xE3A29A },
	{ 0x3C54, 0xE3A29B },
	{ 0x3C55, 0xE3A29C },
	{ 0x3C56, 0xE3A29D },
	{ 0x3C57, 0xE3A29E },
	{ 0x3C58, 0xE3A29F },
	{ 0x3C59, 0xE3A2A0 },
	{ 0x3C5A, 0xE3A2A1 },
	{ 0x3C5B, 0xE3A2A2 },
	{ 0x3C5C, 0xE3A2A3 },
	{ 0x3C5D, 0xE3A2A4 },
	{ 0x3C5E, 0xE3A2A5 },
	{ 0x3C5F, 0xE3A2A6 },
	{ 0x3C60, 0xE3A2A7 },
	{ 0x3C61, 0xE3A2A8 },
	{ 0x3C62, 0xE3A2A9 },
	{ 0x3C63, 0xE3A2AA },
	{ 0x3C64, 0xE3A2AB },
	{ 0x3C65, 0xE3A2AC },
	{ 0x3C66, 0xE3A2AD },
	{ 0x3C67, 0xE3A2AE },
	{ 0x3C68, 0xE3A2AF },
	{ 0x3C69, 0xE3A2B0 },
	{ 0x3C6A, 0xE3A2B1 },
	{ 0x3C6B, 0xE3A2B2 },
	{ 0x3C6C, 0xE3A2B3 },
	{ 0x3C6D, 0xE3A2B4 },
	{ 0x3C6E, 0xE3A2B5 },
	{ 0x3C6F, 0xE3A2B6 },
	{ 0x3C70, 0xE3A2B7 },
	{ 0x3C71, 0xE3A2B8 },
	{ 0x3C72, 0xE3A2B9 },
	{ 0x3C73, 0xE3A2BA },
	{ 0x3C74, 0xE3A2BB },
	{ 0x3C75, 0xE3A2BC },
	{ 0x3C76, 0xE3A2BD },
	{ 0x3C77, 0xE3A2BE },
	{ 0x3C78, 0xE3A2BF },
	{ 0x3C79, 0xE3A380 },
	{ 0x3C7A, 0xE3A381 },
	{ 0x3C7B, 0xE3A382 },
	{ 0x3C7C, 0xE3A383 },
	{ 0x3C7D, 0xE3A384 },
	{ 0x3C7E, 0xE3A385 },
	{ 0x3D21, 0xE3A386 },
	{ 0x3D22, 0xE3A387 },
	{ 0x3D23, 0xE3A388 },
	{ 0x3D24, 0xE3A389 },
	{ 0x3D25, 0xE3A38A },
	{ 0x3D26, 0xE3A38B },
	{ 0x3D27, 0xE3A38C },
	{ 0x3D28, 0xE3A38D },
	{ 0x3D29, 0xE3A38E },
	{ 0x3D2A, 0xE3A38F },
	{ 0x3D2B, 0xE3A390 },
	{ 0x3D2C, 0xE3A391 },
	{ 0x3D2D, 0xE3A392 },
	{ 0x3D2E, 0xE3A393 },
	{ 0x3D2F, 0xE3A394 },
	{ 0x3D30, 0xE3A395 },
	{ 0x3D31, 0xE3A396 },
	{ 0x3D32, 0xE3A397 },
	{ 0x3D33, 0xE3A398 },
	{ 0x3D34, 0xE3A399 },
	{ 0x3D35, 0xE3A39A },
	{ 0x3D36, 0xE3A39B },
	{ 0x3D37, 0xE3A39C },
	{ 0x3D38, 0xE3A39D },
	{ 0x3D39, 0xE3A39E },
	{ 0x3D3A, 0xE3A39F },
	{ 0x3D3B, 0xE3A3A0 },
	{ 0x3D3C, 0xE3A3A1 },
	{ 0x3D3D, 0xE3A3A2 },
	{ 0x3D3E, 0xE3A3A3 },
	{ 0x3D3F, 0xE3A3A4 },
	{ 0x3D40, 0xE3A3A5 },
	{ 0x3D41, 0xE3A3A6 },
	{ 0x3D42, 0xE3A3A7 },
	{ 0x3D43, 0xE3A3A8 },
	{ 0x3D44, 0xE3A3A9 },
	{ 0x3D45, 0xE3A3AA },
	{ 0x3D46, 0xE3A3AB },
	{ 0x3D47, 0xE3A3AC },
	{ 0x3D48, 0xE3A3AD },
	{ 0x3D49, 0xE3A3AE },
	{ 0x3D4A, 0xE3A3AF },
	{ 0x3D4B, 0xE3A3B0 },
	{ 0x3D4C, 0xE3A3B1 },
	{ 0x3D4D, 0xE3A3B2 },
	{ 0x3D4E, 0xE3A3B3 },
	{ 0x3D4F, 0xE3A3B4 },
	{ 0x3D50, 0xE3A3B5 },
	{ 0x3D51, 0xE3A3B6 },
	{ 0x3D52, 0xE3A3B7 },
	{ 0x3D53, 0xE3A3B8 },
	{ 0x3D54, 0xE3A3B9 },
	{ 0x3D55, 0xE3A3BA },
	{ 0x3D56, 0xE3A3BB },
	{ 0x3D57, 0xE3A3BC },
	{ 0x3D58, 0xE3A3BD },
	{ 0x3D59, 0xE3A3BE },
	{ 0x3D5A, 0xE3A3BF },
	{ 0x3D5B, 0xE3A480 },
	{ 0x3D5C, 0xE3A481 },
	{ 0x3D5D, 0xE3A482 },
	{ 0x3D5E, 0xE3A483 },
	{ 0x3D5F, 0xE3A484 },
	{ 0x3D60, 0xE3A485 },
	{ 0x3D61, 0xE3A486 },
	{ 0x3D62, 0xE3A487 },
	{ 0x3D63, 0xE3A488 },
	{ 0x3D64, 0xE3A489 },
	{ 0x3D65, 0xE3A48A },
	{ 0x3D66, 0xE3A48B },
	{ 0x3D67, 0xE3A48C },
	{ 0x3D68, 0xE3A48D },
	{ 0x3D69, 0xE3A48E },
	{ 0x3D6A, 0xE3A48F },
	{ 0x3D6B, 0xE3A490 },
	{ 0x3D6C, 0xE3A491 },
	{ 0x3D6D, 0xE3A492 },
	{ 0x3D6E, 0xE3A493 },
	{ 0x3D6F, 0xE3A494 },
	{ 0x3D70, 0xE3A495 },
	{ 0x3D71, 0xE3A496 },
	{ 0x3D72, 0xE3A497 },
	{ 0x3D73, 0xE3A498 },
	{ 0x3D74, 0xE3A499 },
	{ 0x3D75, 0xE3A49A },
	{ 0x3D76, 0xE3A49B },
	{ 0x3D77, 0xE3A49C },
	{ 0x3D78, 0xE3A49D },
	{ 0x3D79, 0xE3A49E },
	{ 0x3D7A, 0xE3A49F },
	{ 0x3D7B, 0xE3A4A0 },
	{ 0x3D7C, 0xE3A4A1 },
	{ 0x3D7D, 0xE3A4A2 },
	{ 0x3D7E, 0xE3A4A3 },
	{ 0x3E21, 0xE3A4A4 },
	{ 0x3E22, 0xE3A4A5 },
	{ 0x3E23, 0xE3A4A6 },
	{ 0x3E24, 0xE3A4A7 },
	{ 0x3E25, 0xE3A4A8 },
	{ 0x3E26, 0xE3A4A9 },
	{ 0x3E27, 0xE3A4AA },
	{ 0x3E28, 0xE3A4AB },
	{ 0x3E29, 0xE3A4AC },
	{ 0x3E2A, 0xE3A4AD },
	{ 0x3E2B, 0xE3A4AE },
	{ 0x3E2C, 0xE3A4AF },
	{ 0x3E2D, 0xE3A4B0 },
	{ 0x3E2E, 0xE3A4B1 },
	{ 0x3E2F, 0xE3A4B2 },
	{ 0x3E30, 0xE3A4B3 },
	{ 0x3E31, 0xE3A4B4 },
	{ 0x3E32, 0xE3A4B5 },
	{ 0x3E33, 0xE3A4B6 },
	{ 0x3E34, 0xE3A4B7 },
	{ 0x3E35, 0xE3A4B8 },
	{ 0x3E36, 0xE3A4B9 },
	{ 0x3E37, 0xE3A4BA },
	{ 0x3E38, 0xE3A4BB },
	{ 0x3E39, 0xE3A4BC },
	{ 0x3E3A, 0xE3A4BD },
	{ 0x3E3B, 0xE3A4BE },
	{ 0x3E3C, 0xE3A4BF },
	{ 0x3E3D, 0xE3A580 },
	{ 0x3E3E, 0xE3A581 },
	{ 0x3E3F, 0xE3A582 },
	{ 0x3E40, 0xE3A583 },
	{ 0x3E41, 0xE3A584 },
	{ 0x3E42, 0xE3A585 },
	{ 0x3E43, 0xE3A586 },
	{ 0x3E44, 0xE3A587 },
	{ 0x3E45, 0xE3A588 },
	{ 0x3E46, 0xE3A589 },
	{ 0x3E47, 0xE3A58A },
	{ 0x3E48, 0xE3A58B },
	{ 0x3E49, 0xE3A58C },
	{ 0x3E4A, 0xE3A58D },
	{ 0x3E4B, 0xE3A58E },
	{ 0x3E4C, 0xE3A58F },
	{ 0x3E4D, 0xE3A590 },
	{ 0x3E4E, 0xE3A591 },
	{ 0x3E4F, 0xE3A592 },
	{ 0x3E50, 0xE3A593 },
	{ 0x3E51, 0xE3A594 },
	{ 0x3E52, 0xE3A595 },
	{ 0x3E53, 0xE3A596 },
	{ 0x3E54, 0xE3A597 },
	{ 0x3E55, 0xE3A598 },
	{ 0x3E56, 0xE3A599 },
	{ 0x3E57, 0xE3A59A },
	{ 0x3E58, 0xE3A59B },
	{ 0x3E59, 0xE3A59C },
	{ 0x3E5A, 0xE3A59D },
	{ 0x3E5B, 0xE3A59E },
	{ 0x3E5C, 0xE3A59F },
	{ 0x3E5D, 0xE3A5A0 },
	{ 0x3E5E, 0xE3A5A1 },
	{ 0x3E5F, 0xE3A5A2 },
	{ 0x3E60, 0xE3A5A3 },
	{ 0x3E61, 0xE3A5A4 },
	{ 0x3E62, 0xE3A5A5 },
	{ 0x3E63, 0xE3A5A6 },
	{ 0x3E64, 0xE3A5A7 },
	{ 0x3E65, 0xE3A5A8 },
	{ 0x3E66, 0xE3A5A9 },
	{ 0x3E67, 0xE3A5AA },
	{ 0x3E68, 0xE3A5AB },
	{ 0x3E69, 0xE3A5AC },
	{ 0x3E6A, 0xE3A5AD },
	{ 0x3E6B, 0xE3A5AE },
	{ 0x3E6C, 0xE3A5AF },
	{ 0x3E6D, 0xE3A5B0 },
	{ 0x3E6E, 0xE3A5B1 },
	{ 0x3E6F, 0xE3A5B2 },
	{ 0x3E70, 0xE3A5B3 },
	{ 0x3E71, 0xE3A5B4 },
	{ 0x3E72, 0xE3A5B5 },
	{ 0x3E73, 0xE3A5B6 },
	{ 0x3E74, 0xE3A5B7 },
	{ 0x3E75, 0xE3A5B8 },
	{ 0x3E76, 0xE3A5B9 },
	{ 0x3E77, 0xE3A5BA },
	{ 0x3E78, 0xE3A5BB },
	{ 0x3E79, 0xE3A5BC },
	{ 0x3E7A, 0xE3A5BD },
	{ 0x3E7B, 0xE3A5BE },
	{ 0x3E7C, 0xE3A5BF },
	{ 0x3E7D, 0xE3A680 },
	{ 0x3E7E, 0xE3A681 },
	{ 0x3F21, 0xE3A682 },
	{ 0x3F22, 0xE3A683 },
	{ 0x3F23, 0xE3A684 },
	{ 0x3F24, 0xE3A685 },
	{ 0x3F25, 0xE3A686 },
	{ 0x3F26, 0xE3A687 },
	{ 0x3F27, 0xE3A688 },
	{ 0x3F28, 0xE3A689 },
	{ 0x3F29, 0xE3A68A },
	{ 0x3F2A, 0xE3A68B },
	{ 0x3F2B, 0xE3A68C },
	{ 0x3F2C, 0xE3A68D },
	{ 0x3F2D, 0xE3A68E },
	{ 0x3F2E, 0xE3A68F },
	{ 0x3F2F, 0xE3A690 },
	{ 0x3F30, 0xE3A691 },
	{ 0x3F31, 0xE3A692 },
	{ 0x3F32, 0xE3A693 },
	{ 0x3F33, 0xE3A694 },
	{ 0x3F34, 0xE3A695 },
	{ 0x3F35, 0xE3A696 },
	{ 0x3F36, 0xE3A697 },
	{ 0x3F37, 0xE3A698 },
	{ 0x3F38, 0xE3A699 },
	{ 0x3F39, 0xE3A69A },
	{ 0x3F3A, 0xE3A69B },
	{ 0x3F3B, 0xE3A69C },
	{ 0x3F3C, 0xE3A69D },
	{ 0x3F3D, 0xE3A69E },
	{ 0x3F3E, 0xE3A69F },
	{ 0x3F3F, 0xE3A6A0 },
	{ 0x3F40, 0xE3A6A1 },
	{ 0x3F41, 0xE3A6A2 },
	{ 0x3F42, 0xE3A6A3 },
	{ 0x3F43, 0xE3A6A4 },
	{ 0x3F44, 0xE3A6A5 },
	{ 0x3F45, 0xE3A6A6 },
	{ 0x3F46, 0xE3A6A7 },
	{ 0x3F47, 0xE3A6A8 },
	{ 0x3F48, 0xE3A6A9 },
	{ 0x3F49, 0xE3A6AA },
	{ 0x3F4A, 0xE3A6AB },
	{ 0x3F4B, 0xE3A6AC },
	{ 0x3F4C, 0xE3A6AD },
	{ 0x3F4D, 0xE3A6AE },
	{ 0x3F4E, 0xE3A6AF },
	{ 0x3F4F, 0xE3A6B0 },
	{ 0x3F50, 0xE3A6B1 },
	{ 0x3F51, 0xE3A6B2 },
	{ 0x3F52, 0xE3A6B3 },
	{ 0x3F53, 0xE3A6B4 },
	{ 0x3F54, 0xE3A6B5 },
	{ 0x3F55, 0xE3A6B6 },
	{ 0x3F56, 0xE3A6B7 },
	{ 0x3F57, 0xE3A6B8 },
	{ 0x3F58, 0xE3A6B9 },
	{ 0x3F59, 0xE3A6BA },
	{ 0x3F5A, 0xE3A6BB },
	{ 0x3F5B, 0xE3A6BC },
	{ 0x3F5C, 0xE3A6BD },
	{ 0x3F5D, 0xE3A6BE },
	{ 0x3F5E, 0xE3A6BF },
	{ 0x3F5F, 0xE3A780 },
	{ 0x3F60, 0xE3A781 },
	{ 0x3F61, 0xE3A782 },
	{ 0x3F62, 0xE3A783 },
	{ 0x3F63, 0xE3A784 },
	{ 0x3F64, 0xE3A785 },
	{ 0x3F65, 0xE3A786 },
	{ 0x3F66, 0xE3A787 },
	{ 0x3F67, 0xE3A788 },
	{ 0x3F68, 0xE3A789 },
	{ 0x3F69, 0xE3A78A },
	{ 0x3F6A, 0xE3A78B },
	{ 0x3F6B, 0xE3A78C },
	{ 0x3F6C, 0xE3A78D },
	{ 0x3F6D, 0xE3A78E },
	{ 0x3F6E, 0xE3A78F },
	{ 0x3F6F, 0xE3A790 },
	{ 0x3F70, 0xE3A791 },
	{ 0x3F71, 0xE3A792 },
	{ 0x3F72, 0xE3A793 },
	{ 0x3F73, 0xE3A794 },
	{ 0x3F74, 0xE3A795 },
	{ 0x3F75, 0xE3A796 },
	{ 0x3F76, 0xE3A797 },
	{ 0x3F77, 0xE3A798 },
	{ 0x3F78, 0xE3A799 },
	{ 0x3F79, 0xE3A79A },
	{ 0x3F7A, 0xE3A79B },
	{ 0x3F7B, 0xE3A79C },
	{ 0x3F7C, 0xE3A79D },
	{ 0x3F7D, 0xE3A79E },
	{ 0x3F7E, 0xE3A79F },
	{ 0x4021, 0xE3A7A0 },
	{ 0x4022, 0xE3A7A1 },
	{ 0x4023, 0xE3A7A2 },
	{ 0x4024, 0xE3A7A3 },
	{ 0x4025, 0xE3A7A4 },
	{ 0x4026, 0xE3A7A5 },
	{ 0x4027, 0xE3A7A6 },
	{ 0x4028, 0xE3A7A7 },
	{ 0x4029, 0xE3A7A8 },
	{ 0x402A, 0xE3A7A9 },
	{ 0x402B, 0xE3A7AA },
	{ 0x402C, 0xE3A7AB },
	{ 0x402D, 0xE3A7AC },
	{ 0x402E, 0xE3A7AD },
	{ 0x402F, 0xE3A7AE },
	{ 0x4030, 0xE3A7AF },
	{ 0x4031, 0xE3A7B0 },
	{ 0x4032, 0xE3A7B1 },
	{ 0x4033, 0xE3A7B2 },
	{ 0x4034, 0xE3A7B3 },
	{ 0x4035, 0xE3A7B4 },
	{ 0x4036, 0xE3A7B5 },
	{ 0x4037, 0xE3A7B6 },
	{ 0x4038, 0xE3A7B7 },
	{ 0x4039, 0xE3A7B8 },
	{ 0x403A, 0xE3A7B9 },
	{ 0x403B, 0xE3A7BA },
	{ 0x403C, 0xE3A7BB },
	{ 0x403D, 0xE3A7BC },
	{ 0x403E, 0xE3A7BD },
	{ 0x403F, 0xE3A7BE },
	{ 0x4040, 0xE3A7BF },
	{ 0x4041, 0xE3A880 },
	{ 0x4042, 0xE3A881 },
	{ 0x4043, 0xE3A882 },
	{ 0x4044, 0xE3A883 },
	{ 0x4045, 0xE3A884 },
	{ 0x4046, 0xE3A885 },
	{ 0x4047, 0xE3A886 },
	{ 0x4048, 0xE3A887 },
	{ 0x4049, 0xE3A888 },
	{ 0x404A, 0xE3A889 },
	{ 0x404B, 0xE3A88A },
	{ 0x404C, 0xE3A88B },
	{ 0x404D, 0xE3A88C },
	{ 0x404E, 0xE3A88D },
	{ 0x404F, 0xE3A88E },
	{ 0x4050, 0xE3A88F },
	{ 0x4051, 0xE3A890 },
	{ 0x4052, 0xE3A891 },
	{ 0x4053, 0xE3A892 },
	{ 0x4054, 0xE3A893 },
	{ 0x4055, 0xE3A894 },
	{ 0x4056, 0xE3A895 },
	{ 0x4057, 0xE3A896 },
	{ 0x4058, 0xE3A897 },
	{ 0x4059, 0xE3A898 },
	{ 0x405A, 0xE3A899 },
	{ 0x405B, 0xE3A89A },
	{ 0x405C, 0xE3A89B },
	{ 0x405D, 0xE3A89C },
	{ 0x405E, 0xE3A89D },
	{ 0x405F, 0xE3A89E },
	{ 0x4060, 0xE3A89F },
	{ 0x4061, 0xE3A8A0 },
	{ 0x4062, 0xE3A8A1 },
	{ 0x4063, 0xE3A8A2 },
	{ 0x4064, 0xE3A8A3 },
	{ 0x4065, 0xE3A8A4 },
	{ 0x4066, 0xE3A8A5 },
	{ 0x4067, 0xE3A8A6 },
	{ 0x4068, 0xE3A8A7 },
	{ 0x4069, 0xE3A8A8 },
	{ 0x406A, 0xE3A8A9 },
	{ 0x406B, 0xE3A8AA },
	{ 0x406C, 0xE3A8AB },
	{ 0x406D, 0xE3A8AC },
	{ 0x406E, 0xE3A8AD },
	{ 0x406F, 0xE3A8AE },
	{ 0x4070, 0xE3A8AF },
	{ 0x4071, 0xE3A8B0 },
	{ 0x4072, 0xE3A8B1 },
	{ 0x4073, 0xE3A8B2 },
	{ 0x4074, 0xE3A8B3 },
	{ 0x4075, 0xE3A8B4 },
	{ 0x4076, 0xE3A8B5 },
	{ 0x4077, 0xE3A8B6 },
	{ 0x4078, 0xE3A8B7 },
	{ 0x4079, 0xE3A8B8 },
	{ 0x407A, 0xE3A8B9 },
	{ 0x407B, 0xE3A8BA },
	{ 0x407C, 0xE3A8BB },
	{ 0x407D, 0xE3A8BC },
	{ 0x407E, 0xE3A8BD },
	{ 0x4121, 0xE3A8BE },
	{ 0x4122, 0xE3A8BF },
	{ 0x4123, 0xE3A980 },
	{ 0x4124, 0xE3A981 },
	{ 0x4125, 0xE3A982 },
	{ 0x4126, 0xE3A983 },
	{ 0x4127, 0xE3A984 },
	{ 0x4128, 0xE3A985 },
	{ 0x4129, 0xE3A986 },
	{ 0x412A, 0xE3A987 },
	{ 0x412B, 0xE3A988 },
	{ 0x412C, 0xE3A989 },
	{ 0x412D, 0xE3A98A },
	{ 0x412E, 0xE3A98B },
	{ 0x412F, 0xE3A98C },
	{ 0x4130, 0xE3A98D },
	{ 0x4131, 0xE3A98E },
	{ 0x4132, 0xE3A98F },
	{ 0x4133, 0xE3A990 },
	{ 0x4134, 0xE3A991 },
	{ 0x4135, 0xE3A992 },
	{ 0x4136, 0xE3A993 },
	{ 0x4137, 0xE3A994 },
	{ 0x4138, 0xE3A995 },
	{ 0x4139, 0xE3A996 },
	{ 0x413A, 0xE3A997 },
	{ 0x413B, 0xE3A998 },
	{ 0x413C, 0xE3A999 },
	{ 0x413D, 0xE3A99A },
	{ 0x413E, 0xE3A99B },
	{ 0x413F, 0xE3A99C },
	{ 0x4140, 0xE3A99D },
	{ 0x4141, 0xE3A99E },
	{ 0x4142, 0xE3A99F },
	{ 0x4143, 0xE3A9A0 },
	{ 0x4144, 0xE3A9A1 },
	{ 0x4145, 0xE3A9A2 },
	{ 0x4146, 0xE3A9A3 },
	{ 0x4147, 0xE3A9A4 },
	{ 0x4148, 0xE3A9A5 },
	{ 0x4149, 0xE3A9A6 },
	{ 0x414A, 0xE3A9A7 },
	{ 0x414B, 0xE3A9A8 },
	{ 0x414C, 0xE3A9A9 },
	{ 0x414D, 0xE3A9AA },
	{ 0x414E, 0xE3A9AB },
	{ 0x414F, 0xE3A9AC },
	{ 0x4150, 0xE3A9AD },
	{ 0x4151, 0xE3A9AE },
	{ 0x4152, 0xE3A9AF },
	{ 0x4153, 0xE3A9B0 },
	{ 0x4154, 0xE3A9B1 },
	{ 0x4155, 0xE3A9B2 },
	{ 0x4156, 0xE3A9B3 },
	{ 0x4157, 0xE3A9B4 },
	{ 0x4158, 0xE3A9B5 },
	{ 0x4159, 0xE3A9B6 },
	{ 0x415A, 0xE3A9B7 },
	{ 0x415B, 0xE3A9B8 },
	{ 0x415C, 0xE3A9B9 },
	{ 0x415D, 0xE3A9BA },
	{ 0x415E, 0xE3A9BB },
	{ 0x415F, 0xE3A9BC },
	{ 0x4160, 0xE3A9BD },
	{ 0x4161, 0xE3A9BE },
	{ 0x4162, 0xE3A9BF },
	{ 0x4163, 0xE3AA80 },
	{ 0x4164, 0xE3AA81 },
	{ 0x4165, 0xE3AA82 },
	{ 0x4166, 0xE3AA83 },
	{ 0x4167, 0xE3AA84 },
	{ 0x4168, 0xE3AA85 },
	{ 0x4169, 0xE3AA86 },
	{ 0x416A, 0xE3AA87 },
	{ 0x416B, 0xE3AA88 },
	{ 0x416C, 0xE3AA89 },
	{ 0x416D, 0xE3AA8A },
	{ 0x416E, 0xE3AA8B },
	{ 0x416F, 0xE3AA8C },
	{ 0x4170, 0xE3AA8D },
	{ 0x4171, 0xE3AA8E },
	{ 0x4172, 0xE3AA8F },
	{ 0x4173, 0xE3AA90 },
	{ 0x4174, 0xE3AA91 },
	{ 0x4175, 0xE3AA92 },
	{ 0x4176, 0xE3AA93 },
	{ 0x4177, 0xE3AA94 },
	{ 0x4178, 0xE3AA95 },
	{ 0x4179, 0xE3AA96 },
	{ 0x417A, 0xE3AA97 },
	{ 0x417B, 0xE3AA98 },
	{ 0x417C, 0xE3AA99 },
	{ 0x417D, 0xE3AA9A },
	{ 0x417E, 0xE3AA9B },
	{ 0x4221, 0xE3AA9C },
	{ 0x4222, 0xE3AA9D },
	{ 0x4223, 0xE3AA9E },
	{ 0x4224, 0xE3AA9F },
	{ 0x4225, 0xE3AAA0 },
	{ 0x4226, 0xE3AAA1 },
	{ 0x4227, 0xE3AAA2 },
	{ 0x4228, 0xE3AAA3 },
	{ 0x4229, 0xE3AAA4 },
	{ 0x422A, 0xE3AAA5 },
	{ 0x422B, 0xE3AAA6 },
	{ 0x422C, 0xE3AAA7 },
	{ 0x422D, 0xE3AAA8 },
	{ 0x422E, 0xE3AAA9 },
	{ 0x422F, 0xE3AAAA },
	{ 0x4230, 0xE3AAAB },
	{ 0x4231, 0xE3AAAC },
	{ 0x4232, 0xE3AAAD },
	{ 0x4233, 0xE3AAAE },
	{ 0x4234, 0xE3AAAF },
	{ 0x4235, 0xE3AAB0 },
	{ 0x4236, 0xE3AAB1 },
	{ 0x4237, 0xE3AAB2 },
	{ 0x4238, 0xE3AAB3 },
	{ 0x4239, 0xE3AAB4 },
	{ 0x423A, 0xE3AAB5 },
	{ 0x423B, 0xE3AAB6 },
	{ 0x423C, 0xE3AAB7 },
	{ 0x423D, 0xE3AAB8 },
	{ 0x423E, 0xE3AAB9 },
	{ 0x423F, 0xE3AABA },
	{ 0x4240, 0xE3AABB },
	{ 0x4241, 0xE3AABC },
	{ 0x4242, 0xE3AABD },
	{ 0x4243, 0xE3AABE },
	{ 0x4244, 0xE3AABF },
	{ 0x4245, 0xE3AB80 },
	{ 0x4246, 0xE3AB81 },
	{ 0x4247, 0xE3AB82 },
	{ 0x4248, 0xE3AB83 },
	{ 0x4249, 0xE3AB84 },
	{ 0x424A, 0xE3AB85 },
	{ 0x424B, 0xE3AB86 },
	{ 0x424C, 0xE3AB87 },
	{ 0x424D, 0xE3AB88 },
	{ 0x424E, 0xE3AB89 },
	{ 0x424F, 0xE3AB8A },
	{ 0x4250, 0xE3AB8B },
	{ 0x4251, 0xE3AB8C },
	{ 0x4252, 0xE3AB8D },
	{ 0x4253, 0xE3AB8E },
	{ 0x4254, 0xE3AB8F },
	{ 0x4255, 0xE3AB90 },
	{ 0x4256, 0xE3AB91 },
	{ 0x4257, 0xE3AB92 },
	{ 0x4258, 0xE3AB93 },
	{ 0x4259, 0xE3AB94 },
	{ 0x425A, 0xE3AB95 },
	{ 0x425B, 0xE3AB96 },
	{ 0x425C, 0xE3AB97 },
	{ 0x425D, 0xE3AB98 },
	{ 0x425E, 0xE3AB99 },
	{ 0x425F, 0xE3AB9A },
	{ 0x4260, 0xE3AB9B },
	{ 0x4261, 0xE3AB9C },
	{ 0x4262, 0xE3AB9D },
	{ 0x4263, 0xE3AB9E },
	{ 0x4264, 0xE3AB9F },
	{ 0x4265, 0xE3ABA0 },
	{ 0x4266, 0xE3ABA1 },
	{ 0x4267, 0xE3ABA2 },
	{ 0x4268, 0xE3ABA3 },
	{ 0x4269, 0xE3ABA4 },
	{ 0x426A, 0xE3ABA5 },
	{ 0x426B, 0xE3ABA6 },
	{ 0x426C, 0xE3ABA7 },
	{ 0x426D, 0xE3ABA8 },
	{ 0x426E, 0xE3ABA9 },
	{ 0x426F, 0xE3ABAA },
	{ 0x4270, 0xE3ABAB },
	{ 0x4271, 0xE3ABAC },
	{ 0x4272, 0xE3ABAD },
	{ 0x4273, 0xE3ABAE },
	{ 0x4274, 0xE3ABAF },
	{ 0x4275, 0xE3ABB0 },
	{ 0x4276, 0xE3ABB1 },
	{ 0x4277, 0xE3ABB2 },
	{ 0x4278, 0xE3ABB3 },
	{ 0x4279, 0xE3ABB4 },
	{ 0x427A, 0xE3ABB5 },
	{ 0x427B, 0xE3ABB6 },
	{ 0x427C, 0xE3ABB7 },
	{ 0x427D, 0xE3ABB8 },
	{ 0x427E, 0xE3ABB9 },
	{ 0x4321, 0xE3ABBA },
	{ 0x4322, 0xE3ABBB },
	{ 0x4323, 0xE3ABBC },
	{ 0x4324, 0xE3ABBD },
	{ 0x4325, 0xE3ABBE },
	{ 0x4326, 0xE3ABBF },
	{ 0x4327, 0xE3AC80 },
	{ 0x4328, 0xE3AC81 },
	{ 0x4329, 0xE3AC82 },
	{ 0x432A, 0xE3AC83 },
	{ 0x432B, 0xE3AC84 },
	{ 0x432C, 0xE3AC85 },
	{ 0x432D, 0xE3AC86 },
	{ 0x432E, 0xE3AC87 },
	{ 0x432F, 0xE3AC88 },
	{ 0x4330, 0xE3AC89 },
	{ 0x4331, 0xE3AC8A },
	{ 0x4332, 0xE3AC8B },
	{ 0x4333, 0xE3AC8C },
	{ 0x4334, 0xE3AC8D },
	{ 0x4335, 0xE3AC8E },
	{ 0x4336, 0xE3AC8F },
	{ 0x4337, 0xE3AC90 },
	{ 0x4338, 0xE3AC91 },
	{ 0x4339, 0xE3AC92 },
	{ 0x433A, 0xE3AC93 },
	{ 0x433B, 0xE3AC94 },
	{ 0x433C, 0xE3AC95 },
	{ 0x433D, 0xE3AC96 },
	{ 0x433E, 0xE3AC97 },
	{ 0x433F, 0xE3AC98 },
	{ 0x4340, 0xE3AC99 },
	{ 0x4341, 0xE3AC9A },
	{ 0x4342, 0xE3AC9B },
	{ 0x4343, 0xE3AC9C },
	{ 0x4344, 0xE3AC9D },
	{ 0x4345, 0xE3AC9E },
	{ 0x4346, 0xE3AC9F },
	{ 0x4347, 0xE3ACA0 },
	{ 0x4348, 0xE3ACA1 },
	{ 0x4349, 0xE3ACA2 },
	{ 0x434A, 0xE3ACA3 },
	{ 0x434B, 0xE3ACA4 },
	{ 0x434C, 0xE3ACA5 },
	{ 0x434D, 0xE3ACA6 },
	{ 0x434E, 0xE3ACA7 },
	{ 0x434F, 0xE3ACA8 },
	{ 0x4350, 0xE3ACA9 },
	{ 0x4351, 0xE3ACAA },
	{ 0x4352, 0xE3ACAB },
	{ 0x4353, 0xE3ACAC },
	{ 0x4354, 0xE3ACAD },
	{ 0x4355, 0xE3ACAE },
	{ 0x4356, 0xE3ACAF },
	{ 0x4357, 0xE3ACB0 },
	{ 0x4358, 0xE3ACB1 },
	{ 0x4359, 0xE3ACB2 },
	{ 0x435A, 0xE3ACB3 },
	{ 0x435B, 0xE3ACB4 },
	{ 0x435C, 0xE3ACB5 },
	{ 0x435D, 0xE3ACB6 },
	{ 0x435E, 0xE3ACB7 },
	{ 0x435F, 0xE3ACB8 },
	{ 0x4360, 0xE3ACB9 },
	{ 0x4361, 0xE3ACBA },
	{ 0x4362, 0xE3ACBB },
	{ 0x4363, 0xE3ACBC },
	{ 0x4364, 0xE3ACBD },
	{ 0x4365, 0xE3ACBE },
	{ 0x4366, 0xE3ACBF },
	{ 0x4367, 0xE3AD80 },
	{ 0x4368, 0xE3AD81 },
	{ 0x4369, 0xE3AD82 },
	{ 0x436A, 0xE3AD83 },
	{ 0x436B, 0xE3AD84 },
	{ 0x436C, 0xE3AD85 },
	{ 0x436D, 0xE3AD86 },
	{ 0x436E, 0xE3AD87 },
	{ 0x436F, 0xE3AD88 },
	{ 0x4370, 0xE3AD89 },
	{ 0x4371, 0xE3AD8A },
	{ 0x4372, 0xE3AD8B },
	{ 0x4373, 0xE3AD8C },
	{ 0x4374, 0xE3AD8D },
	{ 0x4375, 0xE3AD8E },
	{ 0x4376, 0xE3AD8F },
	{ 0x4377, 0xE3AD90 },
	{ 0x4378, 0xE3AD91 },
	{ 0x4379, 0xE3AD92 },
	{ 0x437A, 0xE3AD93 },
	{ 0x437B, 0xE3AD94 },
	{ 0x437C, 0xE3AD95 },
	{ 0x437D, 0xE3AD96 },
	{ 0x437E, 0xE3AD97 },
	{ 0x4421, 0xE3AD98 },
	{ 0x4422, 0xE3AD99 },
	{ 0x4423, 0xE3AD9A },
	{ 0x4424, 0xE3AD9B },
	{ 0x4425, 0xE3AD9C },
	{ 0x4426, 0xE3AD9D },
	{ 0x4427, 0xE3AD9E },
	{ 0x4428, 0xE3AD9F },
	{ 0x4429, 0xE3ADA0 },
	{ 0x442A, 0xE3ADA1 },
	{ 0x442B, 0xE3ADA2 },
	{ 0x442C, 0xE3ADA3 },
	{ 0x442D, 0xE3ADA4 },
	{ 0x442E, 0xE3ADA5 },
	{ 0x442F, 0xE3ADA6 },
	{ 0x4430, 0xE3ADA7 },
	{ 0x4431, 0xE3ADA8 },
	{ 0x4432, 0xE3ADA9 },
	{ 0x4433, 0xE3ADAA },
	{ 0x4434, 0xE3ADAB },
	{ 0x4435, 0xE3ADAC },
	{ 0x4436, 0xE3ADAD },
	{ 0x4437, 0xE3ADAE },
	{ 0x4438, 0xE3ADAF },
	{ 0x4439, 0xE3ADB0 },
	{ 0x443A, 0xE3ADB1 },
	{ 0x443B, 0xE3ADB2 },
	{ 0x443C, 0xE3ADB3 },
	{ 0x443D, 0xE3ADB4 },
	{ 0x443E, 0xE3ADB5 },
	{ 0x443F, 0xE3ADB6 },
	{ 0x4440, 0xE3ADB7 },
	{ 0x4441, 0xE3ADB8 },
	{ 0x4442, 0xE3ADB9 },
	{ 0x4443, 0xE3ADBA },
	{ 0x4444, 0xE3ADBB },
	{ 0x4445, 0xE3ADBC },
	{ 0x4446, 0xE3ADBD },
	{ 0x4447, 0xE3ADBE },
	{ 0x4448, 0xE3ADBF },
	{ 0x4449, 0xE3AE80 },
	{ 0x444A, 0xE3AE81 },
	{ 0x444B, 0xE3AE82 },
	{ 0x444C, 0xE3AE83 },
	{ 0x444D, 0xE3AE84 },
	{ 0x444E, 0xE3AE85 },
	{ 0x444F, 0xE3AE86 },
	{ 0x4450, 0xE3AE87 },
	{ 0x4451, 0xE3AE88 },
	{ 0x4452, 0xE3AE89 },
	{ 0x4453, 0xE3AE8A },
	{ 0x4454, 0xE3AE8B },
	{ 0x4455, 0xE3AE8C },
	{ 0x4456, 0xE3AE8D },
	{ 0x4457, 0xE3AE8E },
	{ 0x4458, 0xE3AE8F },
	{ 0x4459, 0xE3AE90 },
	{ 0x445A, 0xE3AE91 },
	{ 0x445B, 0xE3AE92 },
	{ 0x445C, 0xE3AE93 },
	{ 0x445D, 0xE3AE94 },
	{ 0x445E, 0xE3AE95 },
	{ 0x445F, 0xE3AE96 },
	{ 0x4460, 0xE3AE97 },
	{ 0x4461, 0xE3AE98 },
	{ 0x4462, 0xE3AE99 },
	{ 0x4463, 0xE3AE9A },
	{ 0x4464, 0xE3AE9B },
	{ 0x4465, 0xE3AE9C },
	{ 0x4466, 0xE3AE9D },
	{ 0x4467, 0xE3AE9E },
	{ 0x4468, 0xE3AE9F },
	{ 0x4469, 0xE3AEA0 },
	{ 0x446A, 0xE3AEA1 },
	{ 0x446B, 0xE3AEA2 },
	{ 0x446C, 0xE3AEA3 },
	{ 0x446D, 0xE3AEA4 },
	{ 0x446E, 0xE3AEA5 },
	{ 0x446F, 0xE3AEA6 },
	{ 0x4470, 0xE3AEA7 },
	{ 0x4471, 0xE3AEA8 },
	{ 0x4472, 0xE3AEA9 },
	{ 0x4473, 0xE3AEAA },
	{ 0x4474, 0xE3AEAB },
	{ 0x4475, 0xE3AEAC },
	{ 0x4476, 0xE3AEAD },
	{ 0x4477, 0xE3AEAE },
	{ 0x4478, 0xE3AEAF },
	{ 0x4479, 0xE3AEB0 },
	{ 0x447A, 0xE3AEB1 },
	{ 0x447B, 0xE3AEB2 },
	{ 0x447C, 0xE3AEB3 },
	{ 0x447D, 0xE3AEB4 },
	{ 0x447E, 0xE3AEB5 },
	{ 0x4521, 0xE3AEB6 },
	{ 0x4522, 0xE3AEB7 },
	{ 0x4523, 0xE3AEB8 },
	{ 0x4524, 0xE3AEB9 },
	{ 0x4525, 0xE3AEBA },
	{ 0x4526, 0xE3AEBB },
	{ 0x4527, 0xE3AEBC },
	{ 0x4528, 0xE3AEBD },
	{ 0x4529, 0xE3AEBE },
	{ 0x452A, 0xE3AEBF },
	{ 0x452B, 0xE3AF80 },
	{ 0x452C, 0xE3AF81 },
	{ 0x452D, 0xE3AF82 },
	{ 0x452E, 0xE3AF83 },
	{ 0x452F, 0xE3AF84 },
	{ 0x4530, 0xE3AF85 },
	{ 0x4531, 0xE3AF86 },
	{ 0x4532, 0xE3AF87 },
	{ 0x4533, 0xE3AF88 },
	{ 0x4534, 0xE3AF89 },
	{ 0x4535, 0xE3AF8A },
	{ 0x4536, 0xE3AF8B },
	{ 0x4537, 0xE3AF8C },
	{ 0x4538, 0xE3AF8D },
	{ 0x4539, 0xE3AF8E },
	{ 0x453A, 0xE3AF8F },
	{ 0x453B, 0xE3AF90 },
	{ 0x453C, 0xE3AF91 },
	{ 0x453D, 0xE3AF92 },
	{ 0x453E, 0xE3AF93 },
	{ 0x453F, 0xE3AF94 },
	{ 0x4540, 0xE3AF95 },
	{ 0x4541, 0xE3AF96 },
	{ 0x4542, 0xE3AF97 },
	{ 0x4543, 0xE3AF98 },
	{ 0x4544, 0xE3AF99 },
	{ 0x4545, 0xE3AF9A },
	{ 0x4546, 0xE3AF9B },
	{ 0x4547, 0xE3AF9C },
	{ 0x4548, 0xE3AF9D },
	{ 0x4549, 0xE3AF9E },
	{ 0x454A, 0xE3AF9F },
	{ 0x454B, 0xE3AFA0 },
	{ 0x454C, 0xE3AFA1 },
	{ 0x454D, 0xE3AFA2 },
	{ 0x454E, 0xE3AFA3 },
	{ 0x454F, 0xE3AFA4 },
	{ 0x4550, 0xE3AFA5 },
	{ 0x4551, 0xE3AFA6 },
	{ 0x4552, 0xE3AFA7 },
	{ 0x4553, 0xE3AFA8 },
	{ 0x4554, 0xE3AFA9 },
	{ 0x4555, 0xE3AFAA },
	{ 0x4556, 0xE3AFAB },
	{ 0x4557, 0xE3AFAC },
	{ 0x4558, 0xE3AFAD },
	{ 0x4559, 0xE3AFAE },
	{ 0x455A, 0xE3AFAF },
	{ 0x455B, 0xE3AFB0 },
	{ 0x455C, 0xE3AFB1 },
	{ 0x455D, 0xE3AFB2 },
	{ 0x455E, 0xE3AFB3 },
	{ 0x455F, 0xE3AFB4 },
	{ 0x4560, 0xE3AFB5 },
	{ 0x4561, 0xE3AFB6 },
	{ 0x4562, 0xE3AFB7 },
	{ 0x4563, 0xE3AFB8 },
	{ 0x4564, 0xE3AFB9 },
	{ 0x4565, 0xE3AFBA },
	{ 0x4566, 0xE3AFBB },
	{ 0x4567, 0xE3AFBC },
	{ 0x4568, 0xE3AFBD },
	{ 0x4569, 0xE3AFBE },
	{ 0x456A, 0xE3AFBF },
	{ 0x456B, 0xE3B080 },
	{ 0x456C, 0xE3B081 },
	{ 0x456D, 0xE3B082 },
	{ 0x456E, 0xE3B083 },
	{ 0x456F, 0xE3B084 },
	{ 0x4570, 0xE3B085 },
	{ 0x4571, 0xE3B086 },
	{ 0x4572, 0xE3B087 },
	{ 0x4573, 0xE3B088 },
	{ 0x4574, 0xE3B089 },
	{ 0x4575, 0xE3B08A },
	{ 0x4576, 0xE3B08B },
	{ 0x4577, 0xE3B08C },
	{ 0x4578, 0xE3B08D },
	{ 0x4579, 0xE3B08E },
	{ 0x457A, 0xE3B08F },
	{ 0x457B, 0xE3B090 },
	{ 0x457C, 0xE3B091 },
	{ 0x457D, 0xE3B092 },
	{ 0x457E, 0xE3B093 },
	{ 0x4621, 0xE3B094 },
	{ 0x4622, 0xE3B095 },
	{ 0x4623, 0xE3B096 },
	{ 0x4624, 0xE3B097 },
	{ 0x4625, 0xE3B098 },
	{ 0x4626, 0xE3B099 },
	{ 0x4627, 0xE3B09A },
	{ 0x4628, 0xE3B09B },
	{ 0x4629, 0xE3B09C },
	{ 0x462A, 0xE3B09D },
	{ 0x462B, 0xE3B09E },
	{ 0x462C, 0xE3B09F },
	{ 0x462D, 0xE3B0A0 },
	{ 0x462E, 0xE3B0A1 },
	{ 0x462F, 0xE3B0A2 },
	{ 0x4630, 0xE3B0A3 },
	{ 0x4631, 0xE3B0A4 },
	{ 0x4632, 0xE3B0A5 },
	{ 0x4633, 0xE3B0A6 },
	{ 0x4634, 0xE3B0A7 },
	{ 0x4635, 0xE3B0A8 },
	{ 0x4636, 0xE3B0A9 },
	{ 0x4637, 0xE3B0AA },
	{ 0x4638, 0xE3B0AB },
	{ 0x4639, 0xE3B0AC },
	{ 0x463A, 0xE3B0AD },
	{ 0x463B, 0xE3B0AE },
	{ 0x463C, 0xE3B0AF },
	{ 0x463D, 0xE3B0B0 },
	{ 0x463E, 0xE3B0B1 },
	{ 0x463F, 0xE3B0B2 },
	{ 0x4640, 0xE3B0B3 },
	{ 0x4641, 0xE3B0B4 },
	{ 0x4642, 0xE3B0B5 },
	{ 0x4643, 0xE3B0B6 },
	{ 0x4644, 0xE3B0B7 },
	{ 0x4645, 0xE3B0B8 },
	{ 0x4646, 0xE3B0B9 },
	{ 0x4647, 0xE3B0BA },
	{ 0x4648, 0xE3B0BB },
	{ 0x4649, 0xE3B0BC },
	{ 0x464A, 0xE3B0BD },
	{ 0x464B, 0xE3B0BE },
	{ 0x464C, 0xE3B0BF },
	{ 0x464D, 0xE3B180 },
	{ 0x464E, 0xE3B181 },
	{ 0x464F, 0xE3B182 },
	{ 0x4650, 0xE3B183 },
	{ 0x4651, 0xE3B184 },
	{ 0x4652, 0xE3B185 },
	{ 0x4653, 0xE3B186 },
	{ 0x4654, 0xE3B187 },
	{ 0x4655, 0xE3B188 },
	{ 0x4656, 0xE3B189 },
	{ 0x4657, 0xE3B18A },
	{ 0x4658, 0xE3B18B },
	{ 0x4659, 0xE3B18C },
	{ 0x465A, 0xE3B18D },
	{ 0x465B, 0xE3B18E },
	{ 0x465C, 0xE3B18F },
	{ 0x465D, 0xE3B190 },
	{ 0x465E, 0xE3B191 },
	{ 0x465F, 0xE3B192 },
	{ 0x4660, 0xE3B193 },
	{ 0x4661, 0xE3B194 },
	{ 0x4662, 0xE3B195 },
	{ 0x4663, 0xE3B196 },
	{ 0x4664, 0xE3B197 },
	{ 0x4665, 0xE3B198 },
	{ 0x4666, 0xE3B199 },
	{ 0x4667, 0xE3B19A },
	{ 0x4668, 0xE3B19B },
	{ 0x4669, 0xE3B19C },
	{ 0x466A, 0xE3B19D },
	{ 0x466B, 0xE3B19E },
	{ 0x466C, 0xE3B19F },
	{ 0x466D, 0xE3B1A0 },
	{ 0x466E, 0xE3B1A1 },
	{ 0x466F, 0xE3B1A2 },
	{ 0x4670, 0xE3B1A3 },
	{ 0x4671, 0xE3B1A4 },
	{ 0x4672, 0xE3B1A5 },
	{ 0x4673, 0xE3B1A6 },
	{ 0x4674, 0xE3B1A7 },
	{ 0x4675, 0xE3B1A8 },
	{ 0x4676, 0xE3B1A9 },
	{ 0x4677, 0xE3B1AA },
	{ 0x4678, 0xE3B1AB },
	{ 0x4679, 0xE3B1AC },
	{ 0x467A, 0xE3B1AD },
	{ 0x467B, 0xE3B1AE },
	{ 0x467C, 0xE3B1AF },
	{ 0x467D, 0xE3B1B0 },
	{ 0x467E, 0xE3B1B1 },
	{ 0x4721, 0xE3B1B2 },
	{ 0x4722, 0xE3B1B3 },
	{ 0x4723, 0xE3B1B4 },
	{ 0x4724, 0xE3B1B5 },
	{ 0x4725, 0xE3B1B6 },
	{ 0x4726, 0xE3B1B7 },
	{ 0x4727, 0xE3B1B8 },
	{ 0x4728, 0xE3B1B9 },
	{ 0x4729, 0xE3B1BA },
	{ 0x472A, 0xE3B1BB },
	{ 0x472B, 0xE3B1BC },
	{ 0x472C, 0xE3B1BD },
	{ 0x472D, 0xE3B1BE },
	{ 0x472E, 0xE3B1BF },
	{ 0x472F, 0xE3B280 },
	{ 0x4730, 0xE3B281 },
	{ 0x4731, 0xE3B282 },
	{ 0x4732, 0xE3B283 },
	{ 0x4733, 0xE3B284 },
	{ 0x4734, 0xE3B285 },
	{ 0x4735, 0xE3B286 },
	{ 0x4736, 0xE3B287 },
	{ 0x4737, 0xE3B288 },
	{ 0x4738, 0xE3B289 },
	{ 0x4739, 0xE3B28A },
	{ 0x473A, 0xE3B28B },
	{ 0x473B, 0xE3B28C },
	{ 0x473C, 0xE3B28D },
	{ 0x473D, 0xE3B28E },
	{ 0x473E, 0xE3B28F },
	{ 0x473F, 0xE3B290 },
	{ 0x4740, 0xE3B291 },
	{ 0x4741, 0xE3B292 },
	{ 0x4742, 0xE3B293 },
	{ 0x4743, 0xE3B294 },
	{ 0x4744, 0xE3B295 },
	{ 0x4745, 0xE3B296 },
	{ 0x4746, 0xE3B297 },
	{ 0x4747, 0xE3B298 },
	{ 0x4748, 0xE3B299 },
	{ 0x4749, 0xE3B29A },
	{ 0x474A, 0xE3B29B },
	{ 0x474B, 0xE3B29C },
	{ 0x474C, 0xE3B29D },
	{ 0x474D, 0xE3B29E },
	{ 0x474E, 0xE3B29F },
	{ 0x474F, 0xE3B2A0 },
	{ 0x4750, 0xE3B2A1 },
	{ 0x4751, 0xE3B2A2 },
	{ 0x4752, 0xE3B2A3 },
	{ 0x4753, 0xE3B2A4 },
	{ 0x4754, 0xE3B2A5 },
	{ 0x4755, 0xE3B2A6 },
	{ 0x4756, 0xE3B2A7 },
	{ 0x4757, 0xE3B2A8 },
	{ 0x4758, 0xE3B2A9 },
	{ 0x4759, 0xE3B2AA },
	{ 0x475A, 0xE3B2AB },
	{ 0x475B, 0xE3B2AC },
	{ 0x475C, 0xE3B2AD },
	{ 0x475D, 0xE3B2AE },
	{ 0x475E, 0xE3B2AF },
	{ 0x475F, 0xE3B2B0 },
	{ 0x4760, 0xE3B2B1 },
	{ 0x4761, 0xE3B2B2 },
	{ 0x4762, 0xE3B2B3 },
	{ 0x4763, 0xE3B2B4 },
	{ 0x4764, 0xE3B2B5 },
	{ 0x4765, 0xE3B2B6 },
	{ 0x4766, 0xE3B2B7 },
	{ 0x4767, 0xE3B2B8 },
	{ 0x4768, 0xE3B2B9 },
	{ 0x4769, 0xE3B2BA },
	{ 0x476A, 0xE3B2BB },
	{ 0x476B, 0xE3B2BC },
	{ 0x476C, 0xE3B2BD },
	{ 0x476D, 0xE3B2BE },
	{ 0x476E, 0xE3B2BF },
	{ 0x476F, 0xE3B380 },
	{ 0x4770, 0xE3B381 },
	{ 0x4771, 0xE3B382 },
	{ 0x4772, 0xE3B383 },
	{ 0x4773, 0xE3B384 },
	{ 0x4774, 0xE3B385 },
	{ 0x4775, 0xE3B386 },
	{ 0x4776, 0xE3B387 },
	{ 0x4777, 0xE3B388 },
	{ 0x4778, 0xE3B389 },
	{ 0x4779, 0xE3B38A },
	{ 0x477A, 0xE3B38B },
	{ 0x477B, 0xE3B38C },
	{ 0x477C, 0xE3B38D },
	{ 0x477D, 0xE3B38E },
	{ 0x477E, 0xE3B38F },
	{ 0x4821, 0xE3B390 },
	{ 0x4822, 0xE3B391 },
	{ 0x4823, 0xE3B392 },
	{ 0x4824, 0xE3B393 },
	{ 0x4825, 0xE3B394 },
	{ 0x4826, 0xE3B395 },
	{ 0x4827, 0xE3B396 },
	{ 0x4828, 0xE3B397 },
	{ 0x4829, 0xE3B398 },
	{ 0x482A, 0xE3B399 },
	{ 0x482B, 0xE3B39A },
	{ 0x482C, 0xE3B39B },
	{ 0x482D, 0xE3B39C },
	{ 0x482E, 0xE3B39D },
	{ 0x482F, 0xE3B39E },
	{ 0x4830, 0xE3B39F },
	{ 0x4831, 0xE3B3A0 },
	{ 0x4832, 0xE3B3A1 },
	{ 0x4833, 0xE3B3A2 },
	{ 0x4834, 0xE3B3A3 },
	{ 0x4835, 0xE3B3A4 },
	{ 0x4836, 0xE3B3A5 },
	{ 0x4837, 0xE3B3A6 },
	{ 0x4838, 0xE3B3A7 },
	{ 0x4839, 0xE3B3A8 },
	{ 0x483A, 0xE3B3A9 },
	{ 0x483B, 0xE3B3AA },
	{ 0x483C, 0xE3B3AB },
	{ 0x483D, 0xE3B3AC },
	{ 0x483E, 0xE3B3AD },
	{ 0x483F, 0xE3B3AE },
	{ 0x4840, 0xE3B3AF },
	{ 0x4841, 0xE3B3B0 },
	{ 0x4842, 0xE3B3B1 },
	{ 0x4843, 0xE3B3B2 },
	{ 0x4844, 0xE3B3B3 },
	{ 0x4845, 0xE3B3B4 },
	{ 0x4846, 0xE3B3B5 },
	{ 0x4847, 0xE3B3B6 },
	{ 0x4848, 0xE3B3B7 },
	{ 0x4849, 0xE3B3B8 },
	{ 0x484A, 0xE3B3B9 },
	{ 0x484B, 0xE3B3BA },
	{ 0x484C, 0xE3B3BB },
	{ 0x484D, 0xE3B3BC },
	{ 0x484E, 0xE3B3BD },
	{ 0x484F, 0xE3B3BE },
	{ 0x4850, 0xE3B3BF },
	{ 0x4851, 0xE3B480 },
	{ 0x4852, 0xE3B481 },
	{ 0x4853, 0xE3B482 },
	{ 0x4854, 0xE3B483 },
	{ 0x4855, 0xE3B484 },
	{ 0x4856, 0xE3B485 },
	{ 0x4857, 0xE3B486 },
	{ 0x4858, 0xE3B487 },
	{ 0x4859, 0xE3B488 },
	{ 0x485A, 0xE3B489 },
	{ 0x485B, 0xE3B48A },
	{ 0x485C, 0xE3B48B },
	{ 0x485D, 0xE3B48C },
	{ 0x485E, 0xE3B48D },
	{ 0x485F, 0xE3B48E },
	{ 0x4860, 0xE3B48F },
	{ 0x4861, 0xE3B490 },
	{ 0x4862, 0xE3B491 },
	{ 0x4863, 0xE3B492 },
	{ 0x4864, 0xE3B493 },
	{ 0x4865, 0xE3B494 },
	{ 0x4866, 0xE3B495 },
	{ 0x4867, 0xE3B496 },
	{ 0x4868, 0xE3B497 },
	{ 0x4869, 0xE3B498 },
	{ 0x486A, 0xE3B499 },
	{ 0x486B, 0xE3B49A },
	{ 0x486C, 0xE3B49B },
	{ 0x486D, 0xE3B49C },
	{ 0x486E, 0xE3B49D },
	{ 0x486F, 0xE3B49E },
	{ 0x4870, 0xE3B49F },
	{ 0x4871, 0xE3B4A0 },
	{ 0x4872, 0xE3B4A1 },
	{ 0x4873, 0xE3B4A2 },
	{ 0x4874, 0xE3B4A3 },
	{ 0x4875, 0xE3B4A4 },
	{ 0x4876, 0xE3B4A5 },
	{ 0x4877, 0xE3B4A6 },
	{ 0x4878, 0xE3B4A7 },
	{ 0x4879, 0xE3B4A8 },
	{ 0x487A, 0xE3B4A9 },
	{ 0x487B, 0xE3B4AA },
	{ 0x487C, 0xE3B4AB },
	{ 0x487D, 0xE3B4AC },
	{ 0x487E, 0xE3B4AD },
	{ 0x6C69, 0xE4B880 },
	{ 0x6F4B, 0xE4B881 },
	{ 0x7652, 0xE4B883 },
	{ 0x5832, 0xE4B887 },
	{ 0x6D5B, 0xE4B888 },
	{ 0x5F32, 0xE4B889 },
	{ 0x5F3E, 0xE4B88A },
	{ 0x793B, 0xE4B88B },
	{ 0x5C74, 0xE4B88D },
	{ 0x7564, 0xE4B891 },
	{ 0x7326, 0xE4B894 },
	{ 0x5D60, 0xE4B895 },
	{ 0x6126, 0xE4B896 },
	{ 0x4E78, 0xE4B898 },
	{ 0x5C30, 0xE4B899 },
	{ 0x632A, 0xE4B89E },
	{ 0x7169, 0xE4B8AD },
	{ 0x4D7A, 0xE4B8B2 },
	{ 0x7C2F, 0xE4B8B8 },
	{ 0x5321, 0xE4B8B9 },
	{ 0x712B, 0xE4B8BB },
	{ 0x6751, 0xE4B982 },
	{ 0x522C, 0xE4B983 },
	{ 0x4E79, 0xE4B985 },
	{ 0x717D, 0xE4B98B },
	{ 0x5E3F, 0xE4B98D },
	{ 0x7B3A, 0xE4B98E },
	{ 0x7939, 0xE4B98F },
	{ 0x4E52, 0xE4B996 },
	{ 0x632B, 0xE4B998 },
	{ 0x6B60, 0xE4B999 },
	{ 0x4E7A, 0xE4B99D },
	{ 0x4B77, 0xE4B99E },
	{ 0x6525, 0xE4B99F },
	{ 0x4A61, 0xE4B9AB },
	{ 0x544C, 0xE4B9AD },
	{ 0x6A61, 0xE4B9B3 },
	{ 0x5C63, 0xE4B9B6 },
	{ 0x5F2D, 0xE4B9B7 },
	{ 0x4B6B, 0xE4B9BE },
	{ 0x552F, 0xE4BA82 },
	{ 0x5675, 0xE4BA86 },
	{ 0x6578, 0xE4BA88 },
	{ 0x5E40, 0xE4BA8B },
	{ 0x6C23, 0xE4BA8C },
	{ 0x694D, 0xE4BA8E },
	{ 0x6A27, 0xE4BA90 },
	{ 0x6976, 0xE4BA91 },
	{ 0x7B3B, 0xE4BA92 },
	{ 0x6769, 0xE4BA94 },
	{ 0x6F4C, 0xE4BA95 },
	{ 0x5066, 0xE4BA98 },
	{ 0x5E41, 0xE4BA9B },
	{ 0x642C, 0xE4BA9E },
	{ 0x584C, 0xE4BAA1 },
	{ 0x7971, 0xE4BAA2 },
	{ 0x4E5F, 0xE4BAA4 },
	{ 0x7A24, 0xE4BAA5 },
	{ 0x6632, 0xE4BAA6 },
	{ 0x7A7B, 0xE4BAA8 },
	{ 0x7A3D, 0xE4BAAB },
	{ 0x4C48, 0xE4BAAC },
	{ 0x6F4D, 0xE4BAAD },
	{ 0x5555, 0xE4BAAE },
	{ 0x5322, 0xE4BAB6 },
	{ 0x6C51, 0xE4BABA },
	{ 0x6427, 0xE4BB80 },
	{ 0x6C52, 0xE4BB81 },
	{ 0x7631, 0xE4BB84 },
	{ 0x4E7B, 0xE4BB87 },
	{ 0x5051, 0xE4BB8A },
	{ 0x4B3F, 0xE4BB8B },
	{ 0x6D24, 0xE4BB8D },
	{ 0x6D28, 0xE4BB94 },
	{ 0x5E42, 0xE4BB95 },
	{ 0x7662, 0xE4BB96 },
	{ 0x6D5C, 0xE4BB97 },
	{ 0x5C75, 0xE4BB98 },
	{ 0x6039, 0xE4BB99 },
	{ 0x544E, 0xE4BB9D },
	{ 0x7435, 0xE4BB9F },
	{ 0x535B, 0xE4BBA3 },
	{ 0x5635, 0xE4BBA4 },
	{ 0x6C24, 0xE4BBA5 },
	{ 0x6466, 0xE4BBB0 },
	{ 0x716A, 0xE4BBB2 },
	{ 0x4B6C, 0xE4BBB6 },
	{ 0x4B40, 0xE4BBB7 },
	{ 0x6C72, 0xE4BBBB },
	{ 0x506A, 0xE4BC81 },
	{ 0x7972, 0xE4BC89 },
	{ 0x6C25, 0xE4BC8A },
	{ 0x505F, 0xE4BC8B },
	{ 0x676A, 0xE4BC8D },
	{ 0x506B, 0xE4BC8E },
	{ 0x5C51, 0xE4BC8F },
	{ 0x5B69, 0xE4BC90 },
	{ 0x7D4C, 0xE4BC91 },
	{ 0x5B57, 0xE4BCAF },
	{ 0x5A61, 0xE4BCB4 },
	{ 0x5636, 0xE4BCB6 },
	{ 0x635F, 0xE4BCB8 },
	{ 0x5E43, 0xE4BCBA },
	{ 0x5E44, 0xE4BCBC },
	{ 0x4A21, 0xE4BCBD },
	{ 0x6E6C, 0xE4BD83 },
	{ 0x5323, 0xE4BD86 },
	{ 0x6E37, 0xE4BD87 },
	{ 0x784F, 0xE4BD88 },
	{ 0x6A48, 0xE4BD8D },
	{ 0x6E38, 0xE4BD8E },
	{ 0x712C, 0xE4BD8F },
	{ 0x7125, 0xE4BD90 },
	{ 0x694E, 0xE4BD91 },
	{ 0x793C, 0xE4BD95 },
	{ 0x6579, 0xE4BD99 },
	{ 0x6C6A, 0xE4BD9A },
	{ 0x5D56, 0xE4BD9B },
	{ 0x6D42, 0xE4BD9C },
	{ 0x7825, 0xE4BDA9 },
	{ 0x653A, 0xE4BDAF },
	{ 0x5B58, 0xE4BDB0 },
	{ 0x4A22, 0xE4BDB3 },
	{ 0x514D, 0xE4BDB6 },
	{ 0x6E6D, 0xE4BDBA },
	{ 0x6C6B, 0xE4BDBE },
	{ 0x5E45, 0xE4BDBF },
	{ 0x6360, 0xE4BE81 },
	{ 0x4A49, 0xE4BE83 },
	{ 0x7269, 0xE4BE84 },
	{ 0x554E, 0xE4BE86 },
	{ 0x7636, 0xE4BE88 },
	{ 0x4E42, 0xE4BE8A },
	{ 0x5647, 0xE4BE8B },
	{ 0x6334, 0xE4BE8D },
	{ 0x712D, 0xE4BE8F },
	{ 0x6A62, 0xE4BE91 },
	{ 0x5742, 0xE4BE96 },
	{ 0x7327, 0xE4BE98 },
	{ 0x4D6A, 0xE4BE9B },
	{ 0x6B6E, 0xE4BE9D },
	{ 0x5932, 0xE4BEAE },
	{ 0x7D25, 0xE4BEAF },
	{ 0x7655, 0xE4BEB5 },
	{ 0x5562, 0xE4BEB6 },
	{ 0x7835, 0xE4BEBF },
	{ 0x4C75, 0xE4BF82 },
	{ 0x7535, 0xE4BF83 },
	{ 0x642D, 0xE4BF84 },
	{ 0x676B, 0xE4BF89 },
	{ 0x7155, 0xE4BF8A },
	{ 0x703B, 0xE4BF8E },
	{ 0x6935, 0xE4BF91 },
	{ 0x4C49, 0xE4BF93 },
	{ 0x7A55, 0xE4BF94 },
	{ 0x6154, 0xE4BF97 },
	{ 0x5756, 0xE4BF9A },
	{ 0x5C41, 0xE4BF9D },
	{ 0x5E46, 0xE4BF9F },
	{ 0x7A6F, 0xE4BFA0 },
	{ 0x6361, 0xE4BFA1 },
	{ 0x6173, 0xE4BFAE },
	{ 0x5C76, 0xE4BFAF },
	{ 0x4E7C, 0xE4BFB1 },
	{ 0x5B44, 0xE4BFB3 },
	{ 0x7871, 0xE4BFB5 },
	{ 0x5C64, 0xE4BFB8 },
	{ 0x656F, 0xE4BFBA },
	{ 0x5C31, 0xE58082 },
	{ 0x5556, 0xE58086 },
	{ 0x735A, 0xE58089 },
	{ 0x4B41, 0xE5808B },
	{ 0x5B43, 0xE5808D },
	{ 0x597A, 0xE58091 },
	{ 0x536E, 0xE58092 },
	{ 0x7A38, 0xE58096 },
	{ 0x7D26, 0xE58099 },
	{ 0x6B6F, 0xE5809A },
	{ 0x7426, 0xE5809C },
	{ 0x4C4A, 0xE5809E },
	{ 0x7328, 0xE5809F },
	{ 0x735B, 0xE580A1 },
	{ 0x5B27, 0xE580A3 },
	{ 0x7637, 0xE580A4 },
	{ 0x4F66, 0xE580A6 },
	{ 0x7072, 0xE580A7 },
	{ 0x4B5A, 0xE580A8 },
	{ 0x6752, 0xE580AA },
	{ 0x5743, 0xE580AB },
	{ 0x7670, 0xE580AC },
	{ 0x685E, 0xE580AD },
	{ 0x6526, 0xE580BB },
	{ 0x6567, 0xE58183 },
	{ 0x4A23, 0xE58187 },
	{ 0x4C27, 0xE58188 },
	{ 0x6A49, 0xE58189 },
	{ 0x7836, 0xE5818F },
	{ 0x7A25, 0xE58195 },
	{ 0x712E, 0xE5819A },
	{ 0x6F4E, 0xE5819C },
	{ 0x4B6D, 0xE581A5 },
	{ 0x7630, 0xE581B4 },
	{ 0x6F4F, 0xE581B5 },
	{ 0x694F, 0xE581B6 },
	{ 0x775E, 0xE581B8 },
	{ 0x4E53, 0xE58280 },
	{ 0x5C77, 0xE58285 },
	{ 0x5B28, 0xE5828D },
	{ 0x4B78, 0xE58291 },
	{ 0x5F21, 0xE58298 },
	{ 0x5D61, 0xE58299 },
	{ 0x754A, 0xE582AC },
	{ 0x6936, 0xE582AD },
	{ 0x676C, 0xE582B2 },
	{ 0x6E6E, 0xE582B3 },
	{ 0x7370, 0xE582B5 },
	{ 0x5F3F, 0xE582B7 },
	{ 0x4C4B, 0xE582BE },
	{ 0x5041, 0xE58385 },
	{ 0x7452, 0xE58389 },
	{ 0x603A, 0xE5838A },
	{ 0x5F40, 0xE5838F },
	{ 0x4E60, 0xE58391 },
	{ 0x5C52, 0xE58395 },
	{ 0x7D6A, 0xE58396 },
	{ 0x5676, 0xE5839A },
	{ 0x6A4A, 0xE5839E },
	{ 0x6869, 0xE583A5 },
	{ 0x632C, 0xE583A7 },
	{ 0x7350, 0xE583AD },
	{ 0x4A24, 0xE583B9 },
	{ 0x5B78, 0xE583BB },
	{ 0x5E47, 0xE583BF },
	{ 0x6B70, 0xE58480 },
	{ 0x7156, 0xE58481 },
	{ 0x6562, 0xE58484 },
	{ 0x4C4C, 0xE58486 },
	{ 0x4B7B, 0xE58489 },
	{ 0x6A63, 0xE58492 },
	{ 0x5F41, 0xE5849F },
	{ 0x566D, 0xE584A1 },
	{ 0x6950, 0xE584AA },
	{ 0x6E39, 0xE584B2 },
	{ 0x5563, 0xE584B7 },
	{ 0x5153, 0xE584BA },
	{ 0x6570, 0xE584BC },
	{ 0x6834, 0xE58580 },
	{ 0x6B43, 0xE58581 },
	{ 0x6A2A, 0xE58583 },
	{ 0x7A7C, 0xE58584 },
	{ 0x7576, 0xE58585 },
	{ 0x703C, 0xE58586 },
	{ 0x7D54, 0xE58587 },
	{ 0x603B, 0xE58588 },
	{ 0x4E43, 0xE58589 },
	{ 0x503A, 0xE5858B },
	{ 0x773A, 0xE5858C },
	{ 0x5873, 0xE5858D },
	{ 0x774D, 0xE5858E },
	{ 0x642E, 0xE58592 },
	{ 0x545F, 0xE5859C },
	{ 0x5067, 0xE585A2 },
	{ 0x6C7D, 0xE585A5 },
	{ 0x522E, 0xE585A7 },
	{ 0x6E6F, 0xE585A8 },
	{ 0x5557, 0xE585A9 },
	{ 0x6A64, 0xE585AA },
	{ 0x7822, 0xE585AB },
	{ 0x4D6B, 0xE585AC },
	{ 0x573F, 0xE585AD },
	{ 0x7B31, 0xE585AE },
	{ 0x4D6C, 0xE585B1 },
	{ 0x5C32, 0xE585B5 },
	{ 0x506C, 0xE585B6 },
	{ 0x4E7D, 0xE585B7 },
	{ 0x6E70, 0xE585B8 },
	{ 0x4C42, 0xE585BC },
	{ 0x506D, 0xE58680 },
	{ 0x6577, 0xE58686 },
	{ 0x737C, 0xE5868A },
	{ 0x6E22, 0xE5868D },
	{ 0x5933, 0xE58692 },
	{ 0x5874, 0xE58695 },
	{ 0x6937, 0xE58697 },
	{ 0x4E2E, 0xE586A0 },
	{ 0x5922, 0xE586A5 },
	{ 0x5871, 0xE586AA },
	{ 0x544F, 0xE586AC },
	{ 0x6527, 0xE586B6 },
	{ 0x5552, 0xE586B7 },
	{ 0x5629, 0xE586BD },
	{ 0x7422, 0xE58784 },
	{ 0x7157, 0xE58786 },
	{ 0x5558, 0xE58789 },
	{ 0x703D, 0xE5878B },
	{ 0x5750, 0xE5878C },
	{ 0x5450, 0xE5878D },
	{ 0x574F, 0xE5879C },
	{ 0x6B6A, 0xE5879D },
	{ 0x7D6B, 0xE5879E },
	{ 0x5B6D, 0xE587A1 },
	{ 0x7C45, 0xE587B0 },
	{ 0x4B42, 0xE587B1 },
	{ 0x7D55, 0xE587B6 },
	{ 0x7448, 0xE587B8 },
	{ 0x686A, 0xE587B9 },
	{ 0x7573, 0xE587BA },
	{ 0x795E, 0xE587BD },
	{ 0x536F, 0xE58880 },
	{ 0x6C53, 0xE58883 },
	{ 0x5D42, 0xE58886 },
	{ 0x6F37, 0xE58887 },
	{ 0x6754, 0xE58888 },
	{ 0x4A4A, 0xE5888A },
	{ 0x597B, 0xE5888E },
	{ 0x7A7D, 0xE58891 },
	{ 0x562A, 0xE58897 },
	{ 0x7478, 0xE5889D },
	{ 0x7777, 0xE588A4 },
	{ 0x5C2C, 0xE588A5 },
	{ 0x5757, 0xE588A9 },
	{ 0x5F22, 0xE588AA },
	{ 0x4E3E, 0xE588AE },
	{ 0x5370, 0xE588B0 },
	{ 0x7024, 0xE588B6 },
	{ 0x616C, 0xE588B7 },
	{ 0x4F67, 0xE588B8 },
	{ 0x734B, 0xE588B9 },
	{ 0x6D29, 0xE588BA },
	{ 0x4A3E, 0xE588BB },
	{ 0x746F, 0xE58983 },
	{ 0x764E, 0xE58987 },
	{ 0x5E7B, 0xE5898A },
	{ 0x503B, 0xE5898B },
	{ 0x5537, 0xE5898C },
	{ 0x6E71, 0xE5898D },
	{ 0x7428, 0xE58994 },
	{ 0x5C78, 0xE58996 },
	{ 0x4B27, 0xE5899B },
	{ 0x5A4E, 0xE5899D },
	{ 0x6066, 0xE589A1 },
	{ 0x6D25, 0xE589A9 },
	{ 0x6E72, 0xE589AA },
	{ 0x5C79, 0xE589AF },
	{ 0x795C, 0xE589B2 },
	{ 0x735C, 0xE589B5 },
	{ 0x7872, 0xE589BD },
	{ 0x7479, 0xE589BF },
	{ 0x7C71, 0xE58A83 },
	{ 0x503C, 0xE58A87 },
	{ 0x5B79, 0xE58A88 },
	{ 0x5731, 0xE58A89 },
	{ 0x4B7C, 0xE58A8D },
	{ 0x7025, 0xE58A91 },
	{ 0x4B7D, 0xE58A92 },
	{ 0x5574, 0xE58A9B },
	{ 0x4D6D, 0xE58A9F },
	{ 0x4A25, 0xE58AA0 },
	{ 0x562B, 0xE58AA3 },
	{ 0x5042, 0xE58AA4 },
	{ 0x703E, 0xE58AA9 },
	{ 0x523D, 0xE58AAA },
	{ 0x4C24, 0xE58AAB },
	{ 0x7A36, 0xE58ABE },
	{ 0x4C4D, 0xE58B81 },
	{ 0x5A7A, 0xE58B83 },
	{ 0x764F, 0xE58B85 },
	{ 0x6938, 0xE58B87 },
	{ 0x5875, 0xE58B89 },
	{ 0x4C4E, 0xE58B8D },
	{ 0x574D, 0xE58B92 },
	{ 0x5451, 0xE58B95 },
	{ 0x696D, 0xE58B96 },
	{ 0x4A6B, 0xE58B98 },
	{ 0x5962, 0xE58B99 },
	{ 0x7D32, 0xE58B9B },
	{ 0x632D, 0xE58B9D },
	{ 0x564C, 0xE58B9E },
	{ 0x5934, 0xE58B9F },
	{ 0x6127, 0xE58BA2 },
	{ 0x6E53, 0xE58BA3 },
	{ 0x5043, 0xE58BA4 },
	{ 0x7D33, 0xE58BB3 },
	{ 0x5564, 0xE58BB5 },
	{ 0x4F68, 0xE58BB8 },
	{ 0x6D43, 0xE58BBA },
	{ 0x5032, 0xE58BBB },
	{ 0x4E7E, 0xE58BBE },
	{ 0x5A28, 0xE58BBF },
	{ 0x7850, 0xE58C85 },
	{ 0x7D56, 0xE58C88 },
	{ 0x7851, 0xE58C8D },
	{ 0x7852, 0xE58C8F },
	{ 0x5C53, 0xE58C90 },
	{ 0x5D62, 0xE58C95 },
	{ 0x7B79, 0xE58C96 },
	{ 0x5D41, 0xE58C97 },
	{ 0x6335, 0xE58C99 },
	{ 0x6D5D, 0xE58CA0 },
	{ 0x4E44, 0xE58CA1 },
	{ 0x4B21, 0xE58CA3 },
	{ 0x5D63, 0xE58CAA },
	{ 0x7C5D, 0xE58CAF },
	{ 0x792F, 0xE58CB9 },
	{ 0x527B, 0xE58CBF },
	{ 0x4F21, 0xE58D80 },
	{ 0x6428, 0xE58D81 },
	{ 0x7436, 0xE58D83 },
	{ 0x6C7E, 0xE58D84 },
	{ 0x632E, 0xE58D87 },
	{ 0x676D, 0xE58D88 },
	{ 0x7D41, 0xE58D89 },
	{ 0x5A62, 0xE58D8A },
	{ 0x5833, 0xE58D8D },
	{ 0x5D64, 0xE58D91 },
	{ 0x706F, 0xE58D92 },
	{ 0x7671, 0xE58D93 },
	{ 0x7A70, 0xE58D94 },
	{ 0x5175, 0xE58D97 },
	{ 0x5A4F, 0xE58D9A },
	{ 0x5C54, 0xE58D9C },
	{ 0x5C26, 0xE58D9E },
	{ 0x6F3F, 0xE58DA0 },
	{ 0x4E4F, 0xE58DA6 },
	{ 0x6059, 0xE58DA8 },
	{ 0x5956, 0xE58DAF },
	{ 0x6C54, 0xE58DB0 },
	{ 0x6A4B, 0xE58DB1 },
	{ 0x4A3F, 0xE58DB4 },
	{ 0x5530, 0xE58DB5 },
	{ 0x4F69, 0xE58DB7 },
	{ 0x716D, 0xE58DBD },
	{ 0x4C4F, 0xE58DBF },
	{ 0x6478, 0xE58E84 },
	{ 0x646D, 0xE58E93 },
	{ 0x5758, 0xE58E98 },
	{ 0x7D27, 0xE58E9A },
	{ 0x6A2B, 0xE58E9F },
	{ 0x7632, 0xE58EA0 },
	{ 0x4F70, 0xE58EA5 },
	{ 0x793D, 0xE58EA6 },
	{ 0x6674, 0xE58EAD },
	{ 0x4B5B, 0xE58EBB },
	{ 0x7351, 0xE58F83 },
	{ 0x6951, 0xE58F88 },
	{ 0x7329, 0xE58F89 },
	{ 0x5060, 0xE58F8A },
	{ 0x6952, 0xE58F8B },
	{ 0x5A63, 0xE58F8D },
	{ 0x6252, 0xE58F94 },
	{ 0x7622, 0xE58F96 },
	{ 0x6174, 0xE58F97 },
	{ 0x5A64, 0xE58F9B },
	{ 0x6755, 0xE58FA1 },
	{ 0x753F, 0xE58FA2 },
	{ 0x4F22, 0xE58FA3 },
	{ 0x4D2F, 0xE58FA4 },
	{ 0x4F23, 0xE58FA5 },
	{ 0x4D30, 0xE58FA9 },
	{ 0x717E, 0xE58FAA },
	{ 0x5023, 0xE58FAB },
	{ 0x612F, 0xE58FAC },
	{ 0x7823, 0xE58FAD },
	{ 0x4A26, 0xE58FAF },
	{ 0x773B, 0xE58FB0 },
	{ 0x726A, 0xE58FB1 },
	{ 0x5E48, 0xE58FB2 },
	{ 0x6953, 0xE58FB3 },
	{ 0x5E49, 0xE58FB8 },
	{ 0x7D5E, 0xE59083 },
	{ 0x4A40, 0xE59084 },
	{ 0x796A, 0xE59088 },
	{ 0x514E, 0xE59089 },
	{ 0x6E54, 0xE5908A },
	{ 0x5452, 0xE5908C },
	{ 0x5923, 0xE5908D },
	{ 0x7D28, 0xE5908E },
	{ 0x5759, 0xE5908F },
	{ 0x774E, 0xE59090 },
	{ 0x7A3E, 0xE59091 },
	{ 0x4F56, 0xE5909B },
	{ 0x5770, 0xE5909D },
	{ 0x6B61, 0xE5909F },
	{ 0x7845, 0xE590A0 },
	{ 0x5C7A, 0xE590A6 },
	{ 0x5D43, 0xE590A9 },
	{ 0x795F, 0xE590AB },
	{ 0x676F, 0xE590B3 },
	{ 0x7D65, 0xE590B8 },
	{ 0x7623, 0xE590B9 },
	{ 0x597C, 0xE590BB },
	{ 0x7D29, 0xE590BC },
	{ 0x676E, 0xE590BE },
	{ 0x5565, 0xE59182 },
	{ 0x6F50, 0xE59188 },
	{ 0x4D31, 0xE5918A },
	{ 0x7722, 0xE59191 },
	{ 0x7132, 0xE591A8 },
	{ 0x7131, 0xE591AA },
	{ 0x4D32, 0xE591B1 },
	{ 0x5A2B, 0xE591B3 },
	{ 0x4A27, 0xE591B5 },
	{ 0x6362, 0xE591BB },
	{ 0x7B3C, 0xE591BC },
	{ 0x5924, 0xE591BD },
	{ 0x6E3A, 0xE59280 },
	{ 0x7853, 0xE59286 },
	{ 0x7B7A, 0xE5928C },
	{ 0x4F24, 0xE5928E },
	{ 0x5C7B, 0xE59290 },
	{ 0x7663, 0xE592A4 },
	{ 0x6D2A, 0xE592A8 },
	{ 0x7221, 0xE592AB },
	{ 0x4E61, 0xE592AC },
	{ 0x7A26, 0xE592B3 },
	{ 0x7960, 0xE592B8 },
	{ 0x6C56, 0xE592BD },
	{ 0x646E, 0xE59380 },
	{ 0x7921, 0xE59381 },
	{ 0x7B6F, 0xE59384 },
	{ 0x796B, 0xE59388 },
	{ 0x6E23, 0xE59389 },
	{ 0x6A2C, 0xE593A1 },
	{ 0x4A28, 0xE593A5 },
	{ 0x747A, 0xE593A8 },
	{ 0x4D56, 0xE593AD },
	{ 0x7C76, 0xE593AE },
	{ 0x7449, 0xE593B2 },
	{ 0x7854, 0xE593BA },
	{ 0x7826, 0xE59484 },
	{ 0x5E4A, 0xE59486 },
	{ 0x7246, 0xE59487 },
	{ 0x575A, 0xE5948E },
	{ 0x5350, 0xE59490 },
	{ 0x5845, 0xE5949C },
	{ 0x6A66, 0xE594AF },
	{ 0x735D, 0xE594B1 },
	{ 0x645A, 0xE594B5 },
	{ 0x7664, 0xE594BE },
	{ 0x7672, 0xE59584 },
	{ 0x5F42, 0xE59586 },
	{ 0x597D, 0xE5958F },
	{ 0x4C76, 0xE59593 },
	{ 0x533A, 0xE59596 },
	{ 0x642F, 0xE5959E },
	{ 0x7961, 0xE595A3 },
	{ 0x7026, 0xE595BC },
	{ 0x4B53, 0xE59680 },
	{ 0x603C, 0xE59684 },
	{ 0x744A, 0xE59686 },
	{ 0x547A, 0xE59687 },
	{ 0x7D2A, 0xE59689 },
	{ 0x7962, 0xE5968A },
	{ 0x7437, 0xE59698 },
	{ 0x7D42, 0xE59699 },
	{ 0x7C30, 0xE5969A },
	{ 0x7D6C, 0xE5969C },
	{ 0x4A62, 0xE5969D },
	{ 0x7D3D, 0xE596A7 },
	{ 0x6A67, 0xE596A9 },
	{ 0x5F43, 0xE596AA },
	{ 0x5152, 0xE596AB },
	{ 0x4E62, 0xE596AC },
	{ 0x5324, 0xE596AE },
	{ 0x7D2B, 0xE59785 },
	{ 0x5F60, 0xE59787 },
	{ 0x7247, 0xE59794 },
	{ 0x6770, 0xE5979A },
	{ 0x506E, 0xE5979C },
	{ 0x732A, 0xE5979F },
	{ 0x5E4B, 0xE597A3 },
	{ 0x7638, 0xE597A4 },
	{ 0x6175, 0xE597BD },
	{ 0x7133, 0xE597BE },
	{ 0x7723, 0xE59886 },
	{ 0x4A29, 0xE59889 },
	{ 0x4F25, 0xE59894 },
	{ 0x5F44, 0xE59897 },
	{ 0x6130, 0xE598AF },
	{ 0x703F, 0xE598B2 },
	{ 0x7624, 0xE598B4 },
	{ 0x6336, 0xE598B6 },
	{ 0x7A46, 0xE59993 },
	{ 0x506F, 0xE599A8 },
	{ 0x7D6D, 0xE599AB },
	{ 0x5D44, 0xE599B4 },
	{ 0x7C77, 0xE59A86 },
	{ 0x663F, 0xE59AA5 },
	{ 0x5E2D, 0xE59AAC },
	{ 0x7A3F, 0xE59AAE },
	{ 0x6571, 0xE59AB4 },
	{ 0x6D44, 0xE59ABC },
	{ 0x5225, 0xE59B8A },
	{ 0x7D6E, 0xE59B8D },
	{ 0x7536, 0xE59B91 },
	{ 0x6176, 0xE59B9A },
	{ 0x5E4C, 0xE59B9B },
	{ 0x7C5E, 0xE59B9E },
	{ 0x6C57, 0xE59BA0 },
	{ 0x4D5D, 0xE59BB0 },
	{ 0x5637, 0xE59BB9 },
	{ 0x4D33, 0xE59BBA },
	{ 0x7855, 0xE59C83 },
	{ 0x6558, 0xE59C84 },
	{ 0x4F6A, 0xE59C88 },
	{ 0x4F50, 0xE59C8B },
	{ 0x6A4C, 0xE59C8D },
	{ 0x6A2E, 0xE59C92 },
	{ 0x6A2D, 0xE59C93 },
	{ 0x5371, 0xE59C96 },
	{ 0x5325, 0xE59C98 },
	{ 0x774F, 0xE59C9F },
	{ 0x6E24, 0xE59CA8 },
	{ 0x5024, 0xE59CAD },
	{ 0x7222, 0xE59CB0 },
	{ 0x5070, 0xE59CBB },
	{ 0x7223, 0xE59D80 },
	{ 0x7778, 0xE59D82 },
	{ 0x5033, 0xE59D87 },
	{ 0x5B29, 0xE59D8A },
	{ 0x533B, 0xE59D8D },
	{ 0x4A6C, 0xE59D8E },
	{ 0x7126, 0xE59D90 },
	{ 0x4B55, 0xE59D91 },
	{ 0x7767, 0xE59DA1 },
	{ 0x4D5E, 0xE59DA4 },
	{ 0x7724, 0xE59DA6 },
	{ 0x7840, 0xE59DAA },
	{ 0x535D, 0xE59DAE },
	{ 0x4C50, 0xE59DB0 },
	{ 0x4F26, 0xE59DB5 },
	{ 0x7673, 0xE59DBC },
	{ 0x6177, 0xE59E82 },
	{ 0x535C, 0xE59E88 },
	{ 0x7A7E, 0xE59E8B },
	{ 0x7A27, 0xE59E93 },
	{ 0x6B59, 0xE59EA0 },
	{ 0x4F27, 0xE59EA2 },
	{ 0x6A2F, 0xE59EA3 },
	{ 0x646F, 0xE59F83 },
	{ 0x6939, 0xE59F87 },
	{ 0x7158, 0xE59F88 },
	{ 0x5858, 0xE59F8B },
	{ 0x6072, 0xE59F8E },
	{ 0x6634, 0xE59F9F },
	{ 0x5C7C, 0xE59FA0 },
	{ 0x7371, 0xE59FB0 },
	{ 0x6350, 0xE59FB4 },
	{ 0x727B, 0xE59FB7 },
	{ 0x5B46, 0xE59FB9 },
	{ 0x5071, 0xE59FBA },
	{ 0x5072, 0xE59FBC },
	{ 0x4F5C, 0xE5A080 },
	{ 0x5351, 0xE5A082 },
	{ 0x4C31, 0xE5A085 },
	{ 0x7758, 0xE5A086 },
	{ 0x4B28, 0xE5A088 },
	{ 0x6B3C, 0xE5A089 },
	{ 0x643E, 0xE5A08A },
	{ 0x745C, 0xE5A09E },
	{ 0x5C42, 0xE5A0A1 },
	{ 0x7027, 0xE5A0A4 },
	{ 0x6640, 0xE5A0A7 },
	{ 0x4A6D, 0xE5A0AA },
	{ 0x686B, 0xE5A0AF },
	{ 0x6568, 0xE5A0B0 },
	{ 0x5C43, 0xE5A0B1 },
	{ 0x6D5E, 0xE5A0B4 },
	{ 0x5372, 0xE5A0B5 },
	{ 0x4C77, 0xE5A0BA },
	{ 0x4E54, 0xE5A18A },
	{ 0x672B, 0xE5A18B },
	{ 0x4B43, 0xE5A18F },
	{ 0x6131, 0xE5A191 },
	{ 0x7732, 0xE5A194 },
	{ 0x5373, 0xE5A197 },
	{ 0x5352, 0xE5A198 },
	{ 0x7540, 0xE5A19A },
	{ 0x5F5D, 0xE5A19E },
	{ 0x6E73, 0xE5A1A1 },
	{ 0x6771, 0xE5A1A2 },
	{ 0x7D34, 0xE5A1A4 },
	{ 0x7248, 0xE5A1B5 },
	{ 0x7352, 0xE5A1B9 },
	{ 0x6E74, 0xE5A1BC },
	{ 0x6253, 0xE5A1BE },
	{ 0x4C51, 0xE5A283 },
	{ 0x5F6A, 0xE5A285 },
	{ 0x693A, 0xE5A289 },
	{ 0x5957, 0xE5A293 },
	{ 0x754D, 0xE5A29C },
	{ 0x7172, 0xE5A29E },
	{ 0x7A47, 0xE5A29F },
	{ 0x5978, 0xE5A2A8 },
	{ 0x5442, 0xE5A2A9 },
	{ 0x7665, 0xE5A2AE },
	{ 0x5D45, 0xE5A2B3 },
	{ 0x6772, 0xE5A2BA },
	{ 0x6D5F, 0xE5A2BB },
	{ 0x4A4B, 0xE5A2BE },
	{ 0x5B7A, 0xE5A381 },
	{ 0x6835, 0xE5A385 },
	{ 0x5326, 0xE5A387 },
	{ 0x7D35, 0xE5A38E },
	{ 0x7949, 0xE5A391 },
	{ 0x6462, 0xE5A393 },
	{ 0x7B3D, 0xE5A395 },
	{ 0x5724, 0xE5A398 },
	{ 0x4E45, 0xE5A399 },
	{ 0x4E55, 0xE5A39E },
	{ 0x5666, 0xE5A39F },
	{ 0x653D, 0xE5A3A4 },
	{ 0x5E4D, 0xE5A3AB },
	{ 0x6C73, 0xE5A3AC },
	{ 0x6D60, 0xE5A3AF },
	{ 0x6C6C, 0xE5A3B9 },
	{ 0x7B3E, 0xE5A3BA },
	{ 0x5F6B, 0xE5A3BB },
	{ 0x6178, 0xE5A3BD },
	{ 0x793E, 0xE5A48F },
	{ 0x5073, 0xE5A494 },
	{ 0x602A, 0xE5A495 },
	{ 0x6862, 0xE5A496 },
	{ 0x6254, 0xE5A499 },
	{ 0x527D, 0xE5A49A },
	{ 0x6528, 0xE5A49C },
	{ 0x5953, 0xE5A4A2 },
	{ 0x535E, 0xE5A4A7 },
	{ 0x7438, 0xE5A4A9 },
	{ 0x773C, 0xE5A4AA },
	{ 0x5C7D, 0xE5A4AB },
	{ 0x686C, 0xE5A4AD },
	{ 0x6467, 0xE5A4AE },
	{ 0x6377, 0xE5A4B1 },
	{ 0x6C28, 0xE5A4B7 },
	{ 0x7A71, 0xE5A4BE },
	{ 0x6572, 0xE5A584 },
	{ 0x5074, 0xE5A587 },
	{ 0x522F, 0xE5A588 },
	{ 0x5C65, 0xE5A589 },
	{ 0x5025, 0xE5A58E },
	{ 0x7134, 0xE5A58F },
	{ 0x7C31, 0xE5A590 },
	{ 0x4C78, 0xE5A591 },
	{ 0x5D46, 0xE5A594 },
	{ 0x7A51, 0xE5A595 },
	{ 0x775F, 0xE5A597 },
	{ 0x7A28, 0xE5A59A },
	{ 0x6E75, 0xE5A5A0 },
	{ 0x5E4E, 0xE5A5A2 },
	{ 0x6773, 0xE5A5A7 },
	{ 0x772C, 0xE5A5AA },
	{ 0x6B44, 0xE5A5AB },
	{ 0x6D61, 0xE5A5AC },
	{ 0x602B, 0xE5A5AD },
	{ 0x5D47, 0xE5A5AE },
	{ 0x5233, 0xE5A5B3 },
	{ 0x523F, 0xE5A5B4 },
	{ 0x4A4C, 0xE5A5B8 },
	{ 0x7B3F, 0xE5A5BD },
	{ 0x657D, 0xE5A682 },
	{ 0x5D65, 0xE5A683 },
	{ 0x584D, 0xE5A684 },
	{ 0x6C74, 0xE5A68A },
	{ 0x5075, 0xE5A693 },
	{ 0x686D, 0xE5A696 },
	{ 0x5052, 0xE5A697 },
	{ 0x5958, 0xE5A699 },
	{ 0x7666, 0xE5A6A5 },
	{ 0x5B2A, 0xE5A6A8 },
	{ 0x7760, 0xE5A6AC },
	{ 0x5859, 0xE5A6B9 },
	{ 0x7423, 0xE5A6BB },
	{ 0x745D, 0xE5A6BE },
	{ 0x6F51, 0xE5A783 },
	{ 0x5935, 0xE5A786 },
	{ 0x6D2B, 0xE5A789 },
	{ 0x6337, 0xE5A78B },
	{ 0x6E3B, 0xE5A790 },
	{ 0x4D34, 0xE5A791 },
	{ 0x6073, 0xE5A793 },
	{ 0x6A4D, 0xE5A794 },
	{ 0x6C75, 0xE5A799 },
	{ 0x686E, 0xE5A79A },
	{ 0x4B29, 0xE5A79C },
	{ 0x712F, 0xE5A79D },
	{ 0x4A4D, 0xE5A7A6 },
	{ 0x6C29, 0xE5A7A8 },
	{ 0x726B, 0xE5A7AA },
	{ 0x7D6F, 0xE5A7AC },
	{ 0x7973, 0xE5A7AE },
	{ 0x6641, 0xE5A7B8 },
	{ 0x6C58, 0xE5A7BB },
	{ 0x6D2C, 0xE5A7BF },
	{ 0x6A4E, 0xE5A881 },
	{ 0x685F, 0xE5A883 },
	{ 0x5E4F, 0xE5A891 },
	{ 0x5226, 0xE5A898 },
	{ 0x6774, 0xE5A89B },
	{ 0x5156, 0xE5A89C },
	{ 0x6642, 0xE5A89F },
	{ 0x6363, 0xE5A8A0 },
	{ 0x6430, 0xE5A8A5 },
	{ 0x5834, 0xE5A8A9 },
	{ 0x7625, 0xE5A8B6 },
	{ 0x735E, 0xE5A8BC },
	{ 0x5725, 0xE5A981 },
	{ 0x7768, 0xE5A986 },
	{ 0x6846, 0xE5A989 },
	{ 0x7B66, 0xE5A99A },
	{ 0x5D66, 0xE5A9A2 },
	{ 0x5C7E, 0xE5A9A6 },
	{ 0x585A, 0xE5AA92 },
	{ 0x5A2C, 0xE5AA9A },
	{ 0x6A30, 0xE5AA9B },
	{ 0x6338, 0xE5AAA4 },
	{ 0x4A2A, 0xE5AB81 },
	{ 0x6179, 0xE5AB82 },
	{ 0x6A31, 0xE5AB84 },
	{ 0x726C, 0xE5AB89 },
	{ 0x7A6E, 0xE5AB8C },
	{ 0x6E55, 0xE5ABA1 },
	{ 0x7974, 0xE5ABA6 },
	{ 0x526C, 0xE5ABA9 },
	{ 0x7B7B, 0xE5AC85 },
	{ 0x7D70, 0xE5AC89 },
	{ 0x603D, 0xE5AC8B },
	{ 0x4E63, 0xE5AC8C },
	{ 0x7846, 0xE5AC96 },
	{ 0x5E2E, 0xE5ACAA },
	{ 0x5F45, 0xE5AD80 },
	{ 0x653E, 0xE5AD83 },
	{ 0x6D2D, 0xE5AD90 },
	{ 0x7A6A, 0xE5AD91 },
	{ 0x4D6E, 0xE5AD94 },
	{ 0x6D26, 0xE5AD95 },
	{ 0x6D2E, 0xE5AD97 },
	{ 0x706D, 0xE5AD98 },
	{ 0x5D21, 0xE5AD9A },
	{ 0x6D2F, 0xE5AD9C },
	{ 0x7C78, 0xE5AD9D },
	{ 0x586B, 0xE5AD9F },
	{ 0x4C79, 0xE5ADA3 },
	{ 0x4D35, 0xE5ADA4 },
	{ 0x7A29, 0xE5ADA9 },
	{ 0x615D, 0xE5ADAB },
	{ 0x6255, 0xE5ADB0 },
	{ 0x6D4F, 0xE5ADB1 },
	{ 0x5D22, 0xE5ADB5 },
	{ 0x794A, 0xE5ADB8 },
	{ 0x6A68, 0xE5ADBA },
	{ 0x656D, 0xE5ADBC },
	{ 0x536B, 0xE5AE85 },
	{ 0x6954, 0xE5AE87 },
	{ 0x617A, 0xE5AE88 },
	{ 0x644C, 0xE5AE89 },
	{ 0x6164, 0xE5AE8B },
	{ 0x6847, 0xE5AE8C },
	{ 0x4E5B, 0xE5AE8F },
	{ 0x5C55, 0xE5AE93 },
	{ 0x7735, 0xE5AE95 },
	{ 0x7C73, 0xE5AE96 },
	{ 0x7073, 0xE5AE97 },
	{ 0x4E2F, 0xE5AE98 },
	{ 0x7135, 0xE5AE99 },
	{ 0x6F52, 0xE5AE9A },
	{ 0x6848, 0xE5AE9B },
	{ 0x6B71, 0xE5AE9C },
	{ 0x4B54, 0xE5AEA2 },
	{ 0x603E, 0xE5AEA3 },
	{ 0x6378, 0xE5AEA4 },
	{ 0x6A69, 0xE5AEA5 },
	{ 0x7C32, 0xE5AEA6 },
	{ 0x6074, 0xE5AEAC },
	{ 0x4F60, 0xE5AEAE },
	{ 0x6E25, 0xE5AEB0 },
	{ 0x7A2A, 0xE5AEB3 },
	{ 0x6643, 0xE5AEB4 },
	{ 0x6132, 0xE5AEB5 },
	{ 0x4A2B, 0xE5AEB6 },
	{ 0x6364, 0xE5AEB8 },
	{ 0x693B, 0xE5AEB9 },
	{ 0x6256, 0xE5AEBF },
	{ 0x7372, 0xE5AF80 },
	{ 0x6E56, 0xE5AF82 },
	{ 0x6A32, 0xE5AF83 },
	{ 0x5076, 0xE5AF84 },
	{ 0x6C59, 0xE5AF85 },
	{ 0x5A4B, 0xE5AF86 },
	{ 0x4F28, 0xE5AF87 },
	{ 0x5D23, 0xE5AF8C },
	{ 0x585B, 0xE5AF90 },
	{ 0x794E, 0xE5AF92 },
	{ 0x6955, 0xE5AF93 },
	{ 0x6351, 0xE5AF94 },
	{ 0x523C, 0xE5AF97 },
	{ 0x582C, 0xE5AF9E },
	{ 0x734C, 0xE5AF9F },
	{ 0x4D7B, 0xE5AFA1 },
	{ 0x7656, 0xE5AFA2 },
	{ 0x6775, 0xE5AFA4 },
	{ 0x686F, 0xE5AFA5 },
	{ 0x6379, 0xE5AFA6 },
	{ 0x523B, 0xE5AFA7 },
	{ 0x7373, 0xE5AFA8 },
	{ 0x637B, 0xE5AFA9 },
	{ 0x5E50, 0xE5AFAB },
	{ 0x4E30, 0xE5AFAC },
	{ 0x5677, 0xE5AFAE },
	{ 0x7159, 0xE5AFAF },
	{ 0x7541, 0xE5AFB5 },
	{ 0x5C44, 0xE5AFB6 },
	{ 0x753B, 0xE5AFB8 },
	{ 0x5E51, 0xE5AFBA },
	{ 0x5C66, 0xE5B081 },
	{ 0x5E52, 0xE5B084 },
	{ 0x6D62, 0xE5B087 },
	{ 0x6E76, 0xE5B088 },
	{ 0x6A4F, 0xE5B089 },
	{ 0x706E, 0xE5B08A },
	{ 0x637C, 0xE5B08B },
	{ 0x535F, 0xE5B08D },
	{ 0x5374, 0xE5B08E },
	{ 0x6133, 0xE5B08F },
	{ 0x6134, 0xE5B091 },
	{ 0x7453, 0xE5B096 },
	{ 0x5F46, 0xE5B099 },
	{ 0x6956, 0xE5B0A4 },
	{ 0x5B2B, 0xE5B0A8 },
	{ 0x7626, 0xE5B0B1 },
	{ 0x6339, 0xE5B0B8 },
	{ 0x6B45, 0xE5B0B9 },
	{ 0x7429, 0xE5B0BA },
	{ 0x4D36, 0xE5B0BB },
	{ 0x5279, 0xE5B0BC },
	{ 0x5A2D, 0xE5B0BE },
	{ 0x5263, 0xE5B0BF },
	{ 0x4F51, 0xE5B180 },
	{ 0x4B5C, 0xE5B185 },
	{ 0x4C7A, 0xE5B186 },
	{ 0x4F5D, 0xE5B188 },
	{ 0x6829, 0xE5B18B },
	{ 0x633B, 0xE5B18D },
	{ 0x633A, 0xE5B18E },
	{ 0x605A, 0xE5B191 },
	{ 0x6E77, 0xE5B195 },
	{ 0x5C33, 0xE5B19B },
	{ 0x5375, 0xE5B1A0 },
	{ 0x5726, 0xE5B1A2 },
	{ 0x7635, 0xE5B1A4 },
	{ 0x575B, 0xE5B1A5 },
	{ 0x6155, 0xE5B1AC },
	{ 0x546A, 0xE5B1AF },
	{ 0x5F23, 0xE5B1B1 },
	{ 0x7D5F, 0xE5B1B9 },
	{ 0x5077, 0xE5B290 },
	{ 0x6D54, 0xE5B291 },
	{ 0x4B2A, 0xE5B2A1 },
	{ 0x645B, 0xE5B2A9 },
	{ 0x617B, 0xE5B2AB },
	{ 0x4B22, 0xE5B2AC },
	{ 0x5360, 0xE5B2B1 },
	{ 0x643F, 0xE5B2B3 },
	{ 0x7B40, 0xE5B2B5 },
	{ 0x5A3E, 0xE5B2B7 },
	{ 0x644D, 0xE5B2B8 },
	{ 0x5639, 0xE5B2BA },
	{ 0x6F40, 0xE5B2BE },
	{ 0x617C, 0xE5B380 },
	{ 0x7639, 0xE5B399 },
	{ 0x5F47, 0xE5B3A0 },
	{ 0x6431, 0xE5B3A8 },
	{ 0x5C67, 0xE5B3AF },
	{ 0x5C68, 0xE5B3B0 },
	{ 0x7A56, 0xE5B3B4 },
	{ 0x5376, 0xE5B3B6 },
	{ 0x715A, 0xE5B3BB },
	{ 0x7A72, 0xE5B3BD },
	{ 0x627D, 0xE5B487 },
	{ 0x554F, 0xE5B48D },
	{ 0x5078, 0xE5B48E },
	{ 0x4D5F, 0xE5B491 },
	{ 0x754B, 0xE5B494 },
	{ 0x6470, 0xE5B496 },
	{ 0x4B2B, 0xE5B497 },
	{ 0x5744, 0xE5B499 },
	{ 0x627E, 0xE5B4A7 },
	{ 0x5D5A, 0xE5B4A9 },
	{ 0x5A2E, 0xE5B58B },
	{ 0x4A6E, 0xE5B58C },
	{ 0x5539, 0xE5B590 },
	{ 0x6321, 0xE5B5A9 },
	{ 0x6863, 0xE5B5AC },
	{ 0x732B, 0xE5B5AF },
	{ 0x4F29, 0xE5B687 },
	{ 0x5377, 0xE5B68B },
	{ 0x5471, 0xE5B69D },
	{ 0x4E64, 0xE5B6A0 },
	{ 0x6872, 0xE5B6A2 },
	{ 0x6575, 0xE5B6AA },
	{ 0x672E, 0xE5B6B8 },
	{ 0x563A, 0xE5B6BA },
	{ 0x5F6C, 0xE5B6BC },
	{ 0x6440, 0xE5B6BD },
	{ 0x6864, 0xE5B78D },
	{ 0x5835, 0xE5B792 },
	{ 0x645C, 0xE5B796 },
	{ 0x7439, 0xE5B79D },
	{ 0x7136, 0xE5B79E },
	{ 0x625E, 0xE5B7A1 },
	{ 0x6135, 0xE5B7A2 },
	{ 0x4D6F, 0xE5B7A5 },
	{ 0x7127, 0xE5B7A6 },
	{ 0x4E65, 0xE5B7A7 },
	{ 0x4B5D, 0xE5B7A8 },
	{ 0x5963, 0xE5B7AB },
	{ 0x732C, 0xE5B7AE },
	{ 0x5079, 0xE5B7B1 },
	{ 0x6C2B, 0xE5B7B2 },
	{ 0x5E53, 0xE5B7B3 },
	{ 0x7769, 0xE5B7B4 },
	{ 0x7975, 0xE5B7B7 },
	{ 0x615E, 0xE5B7BD },
	{ 0x4B6E, 0xE5B7BE },
	{ 0x633C, 0xE5B882 },
	{ 0x7856, 0xE5B883 },
	{ 0x5B6E, 0xE5B886 },
	{ 0x7D71, 0xE5B88C },
	{ 0x7736, 0xE5B891 },
	{ 0x745E, 0xE5B896 },
	{ 0x726D, 0xE5B899 },
	{ 0x5B59, 0xE5B89B },
	{ 0x7028, 0xE5B89D },
	{ 0x617D, 0xE5B8A5 },
	{ 0x5E54, 0xE5B8AB },
	{ 0x602C, 0xE5B8AD },
	{ 0x6D63, 0xE5B8B3 },
	{ 0x5361, 0xE5B8B6 },
	{ 0x5F48, 0xE5B8B8 },
	{ 0x5936, 0xE5B8BD },
	{ 0x7D2C, 0xE5B8BF },
	{ 0x6F53, 0xE5B980 },
	{ 0x6441, 0xE5B984 },
	{ 0x786B, 0xE5B985 },
	{ 0x5B2C, 0xE5B987 },
	{ 0x7C46, 0xE5B98C },
	{ 0x582D, 0xE5B995 },
	{ 0x763A, 0xE5B99F },
	{ 0x5B5F, 0xE5B9A1 },
	{ 0x5353, 0xE5B9A2 },
	{ 0x7847, 0xE5B9A3 },
	{ 0x4A4E, 0xE5B9B2 },
	{ 0x7841, 0xE5B9B3 },
	{ 0x5234, 0xE5B9B4 },
	{ 0x5C34, 0xE5B9B7 },
	{ 0x7A39, 0xE5B9B8 },
	{ 0x4A4F, 0xE5B9B9 },
	{ 0x7C33, 0xE5B9BB },
	{ 0x6A6A, 0xE5B9BC },
	{ 0x6A6B, 0xE5B9BD },
	{ 0x507A, 0xE5B9BE },
	{ 0x6D64, 0xE5BA84 },
	{ 0x5D67, 0xE5BA87 },
	{ 0x5F49, 0xE5BA8A },
	{ 0x5F6D, 0xE5BA8F },
	{ 0x6E3C, 0xE5BA95 },
	{ 0x6F41, 0xE5BA97 },
	{ 0x4C52, 0xE5BA9A },
	{ 0x5D24, 0xE5BA9C },
	{ 0x5F4A, 0xE5BAA0 },
	{ 0x5378, 0xE5BAA6 },
	{ 0x7128, 0xE5BAA7 },
	{ 0x4D37, 0xE5BAAB },
	{ 0x6F54, 0xE5BAAD },
	{ 0x645D, 0xE5BAB5 },
	{ 0x5F6E, 0xE5BAB6 },
	{ 0x4B2C, 0xE5BAB7 },
	{ 0x693C, 0xE5BAB8 },
	{ 0x6A6C, 0xE5BABE },
	{ 0x5F4B, 0xE5BB82 },
	{ 0x793F, 0xE5BB88 },
	{ 0x562F, 0xE5BB89 },
	{ 0x5546, 0xE5BB8A },
	{ 0x4F2A, 0xE5BB90 },
	{ 0x4E29, 0xE5BB93 },
	{ 0x5678, 0xE5BB96 },
	{ 0x7137, 0xE5BB9A },
	{ 0x6E78, 0xE5BB9B },
	{ 0x5959, 0xE5BB9F },
	{ 0x735F, 0xE5BBA0 },
	{ 0x7848, 0xE5BBA2 },
	{ 0x4E46, 0xE5BBA3 },
	{ 0x5566, 0xE5BBAC },
	{ 0x7466, 0xE5BBB3 },
	{ 0x6645, 0xE5BBB6 },
	{ 0x6F55, 0xE5BBB7 },
	{ 0x4B6F, 0xE5BBBA },
	{ 0x7C5F, 0xE5BBBB },
	{ 0x5C27, 0xE5BC81 },
	{ 0x5667, 0xE5BC84 },
	{ 0x7849, 0xE5BC8A },
	{ 0x6352, 0xE5BC8F },
	{ 0x633D, 0xE5BC91 },
	{ 0x4F61, 0xE5BC93 },
	{ 0x7040, 0xE5BC94 },
	{ 0x6C5A, 0xE5BC95 },
	{ 0x5D57, 0xE5BC97 },
	{ 0x7B70, 0xE5BC98 },
	{ 0x6C2C, 0xE5BC9B },
	{ 0x7029, 0xE5BC9F },
	{ 0x7A57, 0xE5BCA6 },
	{ 0x7B41, 0xE5BCA7 },
	{ 0x5240, 0xE5BCA9 },
	{ 0x6530, 0xE5BCB1 },
	{ 0x6D65, 0xE5BCB5 },
	{ 0x4B2D, 0xE5BCBA },
	{ 0x7930, 0xE5BCBC },
	{ 0x7725, 0xE5BD88 },
	{ 0x4B2E, 0xE5BD8A },
	{ 0x5A2F, 0xE5BD8C },
	{ 0x5836, 0xE5BD8E },
	{ 0x5327, 0xE5BD96 },
	{ 0x7B32, 0xE5BD97 },
	{ 0x7D44, 0xE5BD99 },
	{ 0x6C2D, 0xE5BD9B },
	{ 0x7B21, 0xE5BDA2 },
	{ 0x6569, 0xE5BDA6 },
	{ 0x696E, 0xE5BDA7 },
	{ 0x7374, 0xE5BDA9 },
	{ 0x7873, 0xE5BDAA },
	{ 0x7041, 0xE5BDAB },
	{ 0x5E2F, 0xE5BDAC },
	{ 0x7830, 0xE5BDAD },
	{ 0x7360, 0xE5BDB0 },
	{ 0x672F, 0xE5BDB1 },
	{ 0x5B2D, 0xE5BDB7 },
	{ 0x6635, 0xE5BDB9 },
	{ 0x7928, 0xE5BDBC },
	{ 0x5D58, 0xE5BDBF },
	{ 0x6859, 0xE5BE80 },
	{ 0x6F56, 0xE5BE81 },
	{ 0x5362, 0xE5BE85 },
	{ 0x625F, 0xE5BE87 },
	{ 0x7C60, 0xE5BE8A },
	{ 0x5748, 0xE5BE8B },
	{ 0x7D2D, 0xE5BE8C },
	{ 0x5F6F, 0xE5BE90 },
	{ 0x4C53, 0xE5BE91 },
	{ 0x5379, 0xE5BE92 },
	{ 0x5470, 0xE5BE97 },
	{ 0x5B47, 0xE5BE98 },
	{ 0x5E55, 0xE5BE99 },
	{ 0x7074, 0xE5BE9E },
	{ 0x5550, 0xE5BEA0 },
	{ 0x6559, 0xE5BEA1 },
	{ 0x7C47, 0xE5BEA8 },
	{ 0x5C56, 0xE5BEA9 },
	{ 0x6260, 0xE5BEAA },
	{ 0x5A30, 0xE5BEAE },
	{ 0x7323, 0xE5BEB5 },
	{ 0x536C, 0xE5BEB7 },
	{ 0x744B, 0xE5BEB9 },
	{ 0x7D45, 0xE5BEBD },
	{ 0x637D, 0xE5BF83 },
	{ 0x7931, 0xE5BF85 },
	{ 0x507B, 0xE5BF8C },
	{ 0x6C5B, 0xE5BF8D },
	{ 0x753C, 0xE5BF96 },
	{ 0x7224, 0xE5BF97 },
	{ 0x584E, 0xE5BF98 },
	{ 0x584F, 0xE5BF99 },
	{ 0x7577, 0xE5BFA0 },
	{ 0x7661, 0xE5BFAB },
	{ 0x5237, 0xE5BFB5 },
	{ 0x7B6C, 0xE5BFBD },
	{ 0x5D48, 0xE5BFBF },
	{ 0x6468, 0xE6808F },
	{ 0x5241, 0xE68092 },
	{ 0x7857, 0xE68096 },
	{ 0x563B, 0xE6809C },
	{ 0x5E56, 0xE6809D },
	{ 0x773D, 0xE680A0 },
	{ 0x6C2E, 0xE680A1 },
	{ 0x5061, 0xE680A5 },
	{ 0x6075, 0xE680A7 },
	{ 0x6A33, 0xE680A8 },
	{ 0x4E56, 0xE680AA },
	{ 0x4C25, 0xE680AF },
	{ 0x6C76, 0xE68181 },
	{ 0x6261, 0xE68182 },
	{ 0x633E, 0xE68183 },
	{ 0x7C48, 0xE6818D },
	{ 0x4D70, 0xE68190 },
	{ 0x7976, 0xE68192 },
	{ 0x5F70, 0xE68195 },
	{ 0x653F, 0xE68199 },
	{ 0x4E3F, 0xE6819D },
	{ 0x7C61, 0xE681A2 },
	{ 0x6D30, 0xE681A3 },
	{ 0x7D51, 0xE681A4 },
	{ 0x763B, 0xE681A5 },
	{ 0x794F, 0xE681A8 },
	{ 0x6B5A, 0xE681A9 },
	{ 0x4A41, 0xE681AA },
	{ 0x5238, 0xE681AC },
	{ 0x4D71, 0xE681AD },
	{ 0x6353, 0xE681AF },
	{ 0x7D66, 0xE681B0 },
	{ 0x666D, 0xE68285 },
	{ 0x637A, 0xE68289 },
	{ 0x702A, 0xE6828C },
	{ 0x7950, 0xE6828D },
	{ 0x7C62, 0xE68294 },
	{ 0x7827, 0xE68296 },
	{ 0x6165, 0xE6829A },
	{ 0x6E79, 0xE6829B },
	{ 0x6776, 0xE6829F },
	{ 0x6A6D, 0xE682A0 },
	{ 0x7C34, 0xE682A3 },
	{ 0x7542, 0xE682A4 },
	{ 0x575C, 0xE682A7 },
	{ 0x7075, 0xE682B0 },
	{ 0x5D68, 0xE682B2 },
	{ 0x536D, 0xE682B3 },
	{ 0x757C, 0xE682B4 },
	{ 0x5A3F, 0xE682B6 },
	{ 0x4C7B, 0xE682B8 },
	{ 0x537A, 0xE682BC },
	{ 0x7424, 0xE682BD },
	{ 0x6F57, 0xE68385 },
	{ 0x5443, 0xE68387 },
	{ 0x7B63, 0xE68391 },
	{ 0x7B6D, 0xE6839A },
	{ 0x602D, 0xE6839C },
	{ 0x6A6E, 0xE6839F },
	{ 0x7B33, 0xE683A0 },
	{ 0x6442, 0xE683A1 },
	{ 0x7667, 0xE683B0 },
	{ 0x525D, 0xE683B1 },
	{ 0x5F4C, 0xE683B3 },
	{ 0x7C49, 0xE683B6 },
	{ 0x6529, 0xE683B9 },
	{ 0x6076, 0xE683BA },
	{ 0x7633, 0xE683BB },
	{ 0x617E, 0xE68481 },
	{ 0x4B70, 0xE68486 },
	{ 0x6A6F, 0xE68488 },
	{ 0x6A70, 0xE68489 },
	{ 0x5A40, 0xE6848D },
	{ 0x7834, 0xE6848E },
	{ 0x6B72, 0xE6848F },
	{ 0x6443, 0xE68495 },
	{ 0x6957, 0xE6849A },
	{ 0x6471, 0xE6849B },
	{ 0x4A6F, 0xE6849F },
	{ 0x4E57, 0xE684A7 },
	{ 0x7C4A, 0xE684B0 },
	{ 0x7361, 0xE684B4 },
	{ 0x4B44, 0xE684B7 },
	{ 0x6365, 0xE684BC },
	{ 0x4B45, 0xE684BE },
	{ 0x6A34, 0xE684BF },
	{ 0x693D, 0xE68582 },
	{ 0x5749, 0xE68584 },
	{ 0x6B5B, 0xE68587 },
	{ 0x6D31, 0xE68588 },
	{ 0x4C43, 0xE6858A },
	{ 0x773E, 0xE6858B },
	{ 0x7C4B, 0xE6858C },
	{ 0x7874, 0xE68593 },
	{ 0x5937, 0xE68595 },
	{ 0x7353, 0xE68598 },
	{ 0x7354, 0xE68599 },
	{ 0x7764, 0xE6859D },
	{ 0x7751, 0xE6859F },
	{ 0x5837, 0xE685A2 },
	{ 0x4E31, 0xE685A3 },
	{ 0x4A42, 0xE685A4 },
	{ 0x7B34, 0xE685A7 },
	{ 0x4B46, 0xE685A8 },
	{ 0x7076, 0xE685AB },
	{ 0x5567, 0xE685AE },
	{ 0x6A50, 0xE685B0 },
	{ 0x4C54, 0xE685B6 },
	{ 0x4B2F, 0xE685B7 },
	{ 0x742A, 0xE685BD },
	{ 0x692F, 0xE685BE },
	{ 0x7543, 0xE68681 },
	{ 0x6958, 0xE68682 },
	{ 0x5D69, 0xE6868A },
	{ 0x7173, 0xE6868E },
	{ 0x557B, 0xE68690 },
	{ 0x5E3B, 0xE68691 },
	{ 0x747B, 0xE68694 },
	{ 0x7D73, 0xE68698 },
	{ 0x7D72, 0xE68699 },
	{ 0x7726, 0xE6869A },
	{ 0x5D49, 0xE686A4 },
	{ 0x5453, 0xE686A7 },
	{ 0x4C28, 0xE686A9 },
	{ 0x5A41, 0xE686AB },
	{ 0x4C55, 0xE686AC },
	{ 0x5964, 0xE686AE },
	{ 0x7A4A, 0xE686B2 },
	{ 0x6563, 0xE686B6 },
	{ 0x533C, 0xE686BA },
	{ 0x4A70, 0xE686BE },
	{ 0x5044, 0xE68783 },
	{ 0x4A50, 0xE68787 },
	{ 0x7A2B, 0xE68788 },
	{ 0x6B6B, 0xE68789 },
	{ 0x6778, 0xE6878A },
	{ 0x5965, 0xE6878B },
	{ 0x5157, 0xE687A6 },
	{ 0x7324, 0xE687B2 },
	{ 0x547B, 0xE687B6 },
	{ 0x7C63, 0xE687B7 },
	{ 0x7A58, 0xE687B8 },
	{ 0x7355, 0xE687BA },
	{ 0x4F2B, 0xE687BC },
	{ 0x6B73, 0xE687BF },
	{ 0x557C, 0xE68880 },
	{ 0x5354, 0xE68887 },
	{ 0x4D7C, 0xE68888 },
	{ 0x5966, 0xE6888A },
	{ 0x6279, 0xE6888C },
	{ 0x6221, 0xE6888D },
	{ 0x6B54, 0xE6888E },
	{ 0x6077, 0xE68890 },
	{ 0x6432, 0xE68891 },
	{ 0x4C7C, 0xE68892 },
	{ 0x7B64, 0xE68896 },
	{ 0x742B, 0xE6889A },
	{ 0x503D, 0xE6889F },
	{ 0x4A71, 0xE688A1 },
	{ 0x6F38, 0xE688AA },
	{ 0x5740, 0xE688AE },
	{ 0x6E7A, 0xE688B0 },
	{ 0x7D74, 0xE688B1 },
	{ 0x5363, 0xE688B4 },
	{ 0x7B42, 0xE688B6 },
	{ 0x5568, 0xE688BE },
	{ 0x5B2E, 0xE688BF },
	{ 0x6136, 0xE68980 },
	{ 0x7837, 0xE68981 },
	{ 0x603F, 0xE68987 },
	{ 0x7B43, 0xE68988 },
	{ 0x5D6A, 0xE68989 },
	{ 0x6222, 0xE6898B },
	{ 0x6E26, 0xE6898D },
	{ 0x7668, 0xE68993 },
	{ 0x7675, 0xE68998 },
	{ 0x5D4A, 0xE689AE },
	{ 0x5062, 0xE689B1 },
	{ 0x5D26, 0xE689B6 },
	{ 0x5D6B, 0xE689B9 },
	{ 0x6479, 0xE689BC },
	{ 0x632F, 0xE689BF },
	{ 0x507C, 0xE68A80 },
	{ 0x747C, 0xE68A84 },
	{ 0x4C3C, 0xE68A89 },
	{ 0x776A, 0xE68A8A },
	{ 0x6564, 0xE68A91 },
	{ 0x5F71, 0xE68A92 },
	{ 0x7761, 0xE68A95 },
	{ 0x7977, 0xE68A97 },
	{ 0x6F39, 0xE68A98 },
	{ 0x7858, 0xE68A9B },
	{ 0x7929, 0xE68AAB },
	{ 0x7859, 0xE68AB1 },
	{ 0x6E3D, 0xE68AB5 },
	{ 0x5846, 0xE68AB9 },
	{ 0x6463, 0xE68ABC },
	{ 0x754E, 0xE68ABD },
	{ 0x5D59, 0xE68B82 },
	{ 0x5967, 0xE68B87 },
	{ 0x5239, 0xE68B88 },
	{ 0x5543, 0xE68B89 },
	{ 0x5A65, 0xE68B8C },
	{ 0x5A50, 0xE68B8D },
	{ 0x5159, 0xE68B8F },
	{ 0x4E58, 0xE68B90 },
	{ 0x4B5E, 0xE68B92 },
	{ 0x742C, 0xE68B93 },
	{ 0x5A7B, 0xE68B94 },
	{ 0x7669, 0xE68B96 },
	{ 0x6873, 0xE68B97 },
	{ 0x4F2C, 0xE68B98 },
	{ 0x7070, 0xE68B99 },
	{ 0x747D, 0xE68B9B },
	{ 0x5B48, 0xE68B9C },
	{ 0x4E40, 0xE68BAC },
	{ 0x6354, 0xE68BAD },
	{ 0x514F, 0xE68BAE },
	{ 0x7175, 0xE68BAF },
	{ 0x4D72, 0xE68BB1 },
	{ 0x4F6B, 0xE68BB3 },
	{ 0x4D38, 0xE68BB7 },
	{ 0x6326, 0xE68BBE },
	{ 0x515A, 0xE68BBF },
	{ 0x7225, 0xE68C81 },
	{ 0x7226, 0xE68C87 },
	{ 0x644E, 0xE68C89 },
	{ 0x537B, 0xE68C91 },
	{ 0x7129, 0xE68CAB },
	{ 0x7249, 0xE68CAF },
	{ 0x6F58, 0xE68CBA },
	{ 0x6649, 0xE68CBB },
	{ 0x5838, 0xE68CBD },
	{ 0x7A73, 0xE68CBE },
	{ 0x7335, 0xE68D89 },
	{ 0x7824, 0xE68D8C },
	{ 0x5173, 0xE68D8F },
	{ 0x6648, 0xE68D90 },
	{ 0x785A, 0xE68D95 },
	{ 0x5C69, 0xE68DA7 },
	{ 0x5E57, 0xE68DA8 },
	{ 0x4B5F, 0xE68DAE },
	{ 0x4F6C, 0xE68DB2 },
	{ 0x745F, 0xE68DB7 },
	{ 0x5174, 0xE68DBA },
	{ 0x523A, 0xE68DBB },
	{ 0x5F72, 0xE68DBF },
	{ 0x6137, 0xE68E83 },
	{ 0x6223, 0xE68E88 },
	{ 0x537C, 0xE68E89 },
	{ 0x6D66, 0xE68E8C },
	{ 0x5B49, 0xE68E92 },
	{ 0x647A, 0xE68E96 },
	{ 0x4F5E, 0xE68E98 },
	{ 0x4E50, 0xE68E9B },
	{ 0x5553, 0xE68EA0 },
	{ 0x7375, 0xE68EA1 },
	{ 0x772E, 0xE68EA2 },
	{ 0x6F48, 0xE68EA5 },
	{ 0x4D73, 0xE68EA7 },
	{ 0x754F, 0xE68EA8 },
	{ 0x6573, 0xE68EA9 },
	{ 0x7042, 0xE68EAA },
	{ 0x4A51, 0xE68F80 },
	{ 0x6A71, 0xE68F84 },
	{ 0x5026, 0xE68F86 },
	{ 0x595A, 0xE68F8F },
	{ 0x702B, 0xE68F90 },
	{ 0x6B67, 0xE68F96 },
	{ 0x6540, 0xE68F9A },
	{ 0x7C35, 0xE68F9B },
	{ 0x6444, 0xE68FA1 },
	{ 0x4C29, 0xE68FAD },
	{ 0x7D46, 0xE68FAE },
	{ 0x6A35, 0xE68FB4 },
	{ 0x652A, 0xE68FB6 },
	{ 0x5F3A, 0xE68FB7 },
	{ 0x615F, 0xE6908D },
	{ 0x5A51, 0xE6908F },
	{ 0x6138, 0xE69094 },
	{ 0x6874, 0xE69096 },
	{ 0x537D, 0xE69097 },
	{ 0x6224, 0xE6909C },
	{ 0x724A, 0xE690A2 },
	{ 0x5A66, 0xE690AC },
	{ 0x7733, 0xE690AD },
	{ 0x7D4D, 0xE690BA },
	{ 0x7336, 0xE690BE },
	{ 0x6E57, 0xE69198 },
	{ 0x7544, 0xE691A0 },
	{ 0x5824, 0xE691A9 },
	{ 0x7227, 0xE691AF },
	{ 0x5938, 0xE691B8 },
	{ 0x5939, 0xE691B9 },
	{ 0x6F49, 0xE691BA },
	{ 0x564E, 0xE69288 },
	{ 0x774B, 0xE69291 },
	{ 0x5F2E, 0xE69292 },
	{ 0x6875, 0xE69293 },
	{ 0x5235, 0xE6929A },
	{ 0x5355, 0xE6929E },
	{ 0x744C, 0xE692A4 },
	{ 0x5A7C, 0xE692A5 },
	{ 0x5968, 0xE692AB },
	{ 0x776B, 0xE692AD },
	{ 0x7549, 0xE692AE },
	{ 0x733C, 0xE692B0 },
	{ 0x5A52, 0xE692B2 },
	{ 0x5335, 0xE692BB },
	{ 0x6836, 0xE69381 },
	{ 0x564F, 0xE69384 },
	{ 0x743A, 0xE69385 },
	{ 0x7749, 0xE69387 },
	{ 0x4C2A, 0xE6938A },
	{ 0x7043, 0xE6938D },
	{ 0x4C56, 0xE6938E },
	{ 0x5053, 0xE69392 },
	{ 0x533D, 0xE69394 },
	{ 0x5B7B, 0xE69398 },
	{ 0x4B60, 0xE6939A },
	{ 0x5364, 0xE693A1 },
	{ 0x7677, 0xE693A2 },
	{ 0x553A, 0xE693A5 },
	{ 0x734D, 0xE693A6 },
	{ 0x4B61, 0xE693A7 },
	{ 0x6B74, 0xE693AC },
	{ 0x742D, 0xE693B2 },
	{ 0x7C2A, 0xE693B4 },
	{ 0x776C, 0xE693BA },
	{ 0x6876, 0xE693BE },
	{ 0x5A67, 0xE69480 },
	{ 0x774C, 0xE69484 },
	{ 0x6541, 0xE69498 },
	{ 0x606E, 0xE6949D },
	{ 0x557D, 0xE694A3 },
	{ 0x4E66, 0xE694AA },
	{ 0x7C2B, 0xE694AB },
	{ 0x553B, 0xE694AC },
	{ 0x7228, 0xE694AF },
	{ 0x6225, 0xE694B6 },
	{ 0x4D39, 0xE694B7 },
	{ 0x6A72, 0xE694B8 },
	{ 0x4B47, 0xE694B9 },
	{ 0x4D74, 0xE694BB },
	{ 0x5B2F, 0xE694BE },
	{ 0x6F59, 0xE694BF },
	{ 0x4D3A, 0xE69585 },
	{ 0x7C79, 0xE69588 },
	{ 0x5F73, 0xE6958D },
	{ 0x4E67, 0xE6958E },
	{ 0x5A42, 0xE6958F },
	{ 0x4F2D, 0xE69591 },
	{ 0x6779, 0xE69596 },
	{ 0x7828, 0xE69597 },
	{ 0x7362, 0xE6959E },
	{ 0x4A72, 0xE695A2 },
	{ 0x5F24, 0xE695A3 },
	{ 0x5444, 0xE695A6 },
	{ 0x4C57, 0xE695AC },
	{ 0x6542, 0xE695AD },
	{ 0x4D3B, 0xE695B2 },
	{ 0x6F5A, 0xE695B4 },
	{ 0x6E58, 0xE695B5 },
	{ 0x5D27, 0xE695B7 },
	{ 0x6226, 0xE695B8 },
	{ 0x6040, 0xE695BE },
	{ 0x5630, 0xE69682 },
	{ 0x784A, 0xE69683 },
	{ 0x7C7A, 0xE69685 },
	{ 0x597E, 0xE69687 },
	{ 0x5E30, 0xE6968C },
	{ 0x5D6C, 0xE69690 },
	{ 0x5A68, 0xE69691 },
	{ 0x5460, 0xE69697 },
	{ 0x5679, 0xE69699 },
	{ 0x4D57, 0xE6969B },
	{ 0x5E58, 0xE6969C },
	{ 0x7278, 0xE6969F },
	{ 0x6456, 0xE696A1 },
	{ 0x5045, 0xE696A4 },
	{ 0x742E, 0xE696A5 },
	{ 0x5D28, 0xE696A7 },
	{ 0x6D45, 0xE696AB },
	{ 0x7356, 0xE696AC },
	{ 0x5E59, 0xE696AF },
	{ 0x6366, 0xE696B0 },
	{ 0x5328, 0xE696B7 },
	{ 0x5B30, 0xE696B9 },
	{ 0x655A, 0xE696BC },
	{ 0x633F, 0xE696BD },
	{ 0x5B31, 0xE69781 },
	{ 0x5569, 0xE69785 },
	{ 0x6041, 0xE6978B },
	{ 0x6F5B, 0xE6978C },
	{ 0x7069, 0xE6978F },
	{ 0x5732, 0xE69792 },
	{ 0x507D, 0xE69797 },
	{ 0x5969, 0xE697A0 },
	{ 0x507E, 0xE697A3 },
	{ 0x6C6D, 0xE697A5 },
	{ 0x5329, 0xE697A6 },
	{ 0x7229, 0xE697A8 },
	{ 0x7044, 0xE697A9 },
	{ 0x6262, 0xE697AC },
	{ 0x696F, 0xE697AD },
	{ 0x7951, 0xE697B1 },
	{ 0x6959, 0xE697B4 },
	{ 0x685A, 0xE697BA },
	{ 0x5A43, 0xE697BB },
	{ 0x5A44, 0xE697BC },
	{ 0x5445, 0xE697BD },
	{ 0x677A, 0xE697BF },
	{ 0x4D60, 0xE69886 },
	{ 0x6330, 0xE69887 },
	{ 0x5B32, 0xE69889 },
	{ 0x7B44, 0xE6988A },
	{ 0x7363, 0xE6988C },
	{ 0x5925, 0xE6988E },
	{ 0x7B67, 0xE6988F },
	{ 0x5D4B, 0xE69890 },
	{ 0x5054, 0xE69891 },
	{ 0x6636, 0xE69893 },
	{ 0x602E, 0xE69894 },
	{ 0x7D5A, 0xE69895 },
	{ 0x5C35, 0xE6989E },
	{ 0x6078, 0xE6989F },
	{ 0x6731, 0xE698A0 },
	{ 0x7570, 0xE698A5 },
	{ 0x585C, 0xE698A7 },
	{ 0x6D46, 0xE698A8 },
	{ 0x6139, 0xE698AD },
	{ 0x6340, 0xE698AF },
	{ 0x7940, 0xE698B0 },
	{ 0x6970, 0xE698B1 },
	{ 0x595B, 0xE698B4 },
	{ 0x7364, 0xE698B6 },
	{ 0x5C36, 0xE698BA },
	{ 0x6469, 0xE698BB },
	{ 0x7045, 0xE69981 },
	{ 0x6341, 0xE69982 },
	{ 0x7C4C, 0xE69983 },
	{ 0x7C4D, 0xE69984 },
	{ 0x724B, 0xE69989 },
	{ 0x724C, 0xE6998B },
	{ 0x644F, 0xE6998F },
	{ 0x715B, 0xE69999 },
	{ 0x7A59, 0xE6999B },
	{ 0x7138, 0xE6999D },
	{ 0x7D75, 0xE6999E },
	{ 0x6079, 0xE6999F },
	{ 0x677B, 0xE699A4 },
	{ 0x7C37, 0xE699A5 },
	{ 0x7C64, 0xE699A6 },
	{ 0x7B45, 0xE699A7 },
	{ 0x6367, 0xE699A8 },
	{ 0x5839, 0xE699A9 },
	{ 0x7678, 0xE699AB },
	{ 0x5C45, 0xE699AE },
	{ 0x4C58, 0xE699AF },
	{ 0x602F, 0xE699B3 },
	{ 0x7467, 0xE699B4 },
	{ 0x6F5C, 0xE699B6 },
	{ 0x4F7C, 0xE699B7 },
	{ 0x6F5D, 0xE699B8 },
	{ 0x722A, 0xE699BA },
	{ 0x7D3E, 0xE69A84 },
	{ 0x4A2C, 0xE69A87 },
	{ 0x7D3B, 0xE69A88 },
	{ 0x7D47, 0xE69A89 },
	{ 0x6732, 0xE69A8E },
	{ 0x6A51, 0xE69A90 },
	{ 0x5F74, 0xE69A91 },
	{ 0x516C, 0xE69A96 },
	{ 0x645E, 0xE69A97 },
	{ 0x6543, 0xE69A98 },
	{ 0x5926, 0xE69A9D },
	{ 0x4D3C, 0xE69AA0 },
	{ 0x7365, 0xE69AA2 },
	{ 0x6D55, 0xE69AAB },
	{ 0x593A, 0xE69AAE },
	{ 0x6D67, 0xE69AB2 },
	{ 0x7B35, 0xE69AB3 },
	{ 0x786C, 0xE69AB4 },
	{ 0x6067, 0xE69AB9 },
	{ 0x4C59, 0xE69ABB },
	{ 0x5446, 0xE69ABE },
	{ 0x6725, 0xE69B84 },
	{ 0x5575, 0xE69B86 },
	{ 0x533E, 0xE69B87 },
	{ 0x7C7B, 0xE69B89 },
	{ 0x6472, 0xE69B96 },
	{ 0x5F75, 0xE69B99 },
	{ 0x6878, 0xE69B9C },
	{ 0x786D, 0xE69B9D },
	{ 0x4E47, 0xE69BA0 },
	{ 0x7D76, 0xE69BA6 },
	{ 0x6858, 0xE69BB0 },
	{ 0x4D58, 0xE69BB2 },
	{ 0x6756, 0xE69BB3 },
	{ 0x4C5A, 0xE69BB4 },
	{ 0x4A63, 0xE69BB7 },
	{ 0x5F76, 0xE69BB8 },
	{ 0x7047, 0xE69BB9 },
	{ 0x7046, 0xE69BBA },
	{ 0x583A, 0xE69BBC },
	{ 0x7174, 0xE69BBE },
	{ 0x7470, 0xE69BBF },
	{ 0x754C, 0xE69C80 },
	{ 0x7C65, 0xE69C83 },
	{ 0x6A45, 0xE69C88 },
	{ 0x6A73, 0xE69C89 },
	{ 0x5D5B, 0xE69C8B },
	{ 0x5C57, 0xE69C8D },
	{ 0x5E7D, 0xE69C94 },
	{ 0x7279, 0xE69C95 },
	{ 0x5547, 0xE69C97 },
	{ 0x5850, 0xE69C9B },
	{ 0x7048, 0xE69C9D },
	{ 0x5121, 0xE69C9E },
	{ 0x5122, 0xE69C9F },
	{ 0x5954, 0xE69CA6 },
	{ 0x5668, 0xE69CA7 },
	{ 0x594A, 0xE69CA8 },
	{ 0x5A31, 0xE69CAA },
	{ 0x5847, 0xE69CAB },
	{ 0x5C62, 0xE69CAC },
	{ 0x734E, 0xE69CAD },
	{ 0x7574, 0xE69CAE },
	{ 0x7139, 0xE69CB1 },
	{ 0x5A53, 0xE69CB4 },
	{ 0x766A, 0xE69CB6 },
	{ 0x4F75, 0xE69CBA },
	{ 0x7D2E, 0xE69CBD },
	{ 0x4A52, 0xE69D86 },
	{ 0x5F34, 0xE69D89 },
	{ 0x575D, 0xE69D8E },
	{ 0x7A3A, 0xE69D8F },
	{ 0x6E27, 0xE69D90 },
	{ 0x753D, 0xE69D91 },
	{ 0x7875, 0xE69D93 },
	{ 0x6D68, 0xE69D96 },
	{ 0x5461, 0xE69D9C },
	{ 0x5123, 0xE69D9E },
	{ 0x6156, 0xE69D9F },
	{ 0x7978, 0xE69DAD },
	{ 0x5B4A, 0xE69DAF },
	{ 0x4B79, 0xE69DB0 },
	{ 0x5454, 0xE69DB1 },
	{ 0x595C, 0xE69DB3 },
	{ 0x6E3E, 0xE69DB5 },
	{ 0x776D, 0xE69DB7 },
	{ 0x526E, 0xE69DBB },
	{ 0x6166, 0xE69DBE },
	{ 0x7779, 0xE69DBF },
	{ 0x5D6D, 0xE69E87 },
	{ 0x685B, 0xE69E89 },
	{ 0x5B33, 0xE69E8B },
	{ 0x5177, 0xE69E8F },
	{ 0x6030, 0xE69E90 },
	{ 0x5462, 0xE69E93 },
	{ 0x7657, 0xE69E95 },
	{ 0x5779, 0xE69E97 },
	{ 0x585D, 0xE69E9A },
	{ 0x4D7D, 0xE69E9C },
	{ 0x722B, 0xE69E9D },
	{ 0x4D3D, 0xE69EAF },
	{ 0x7842, 0xE69EB0 },
	{ 0x722C, 0xE69EB3 },
	{ 0x4A2D, 0xE69EB6 },
	{ 0x4A2E, 0xE69EB7 },
	{ 0x4F2E, 0xE69EB8 },
	{ 0x6342, 0xE69EBE },
	{ 0x5C37, 0xE69F84 },
	{ 0x5B5A, 0xE69F8F },
	{ 0x593B, 0xE69F90 },
	{ 0x4A73, 0xE69F91 },
	{ 0x7653, 0xE69F92 },
	{ 0x6678, 0xE69F93 },
	{ 0x6A75, 0xE69F94 },
	{ 0x6A76, 0xE69F9A },
	{ 0x7679, 0xE69F9D },
	{ 0x4F2F, 0xE69FA9 },
	{ 0x4A53, 0xE69FAC },
	{ 0x4A2F, 0xE69FAF },
	{ 0x5230, 0xE69FB0 },
	{ 0x713A, 0xE69FB1 },
	{ 0x5733, 0xE69FB3 },
	{ 0x6343, 0xE69FB4 },
	{ 0x737D, 0xE69FB5 },
	{ 0x5E5A, 0xE69FB6 },
	{ 0x5E5B, 0xE69FBB },
	{ 0x6F5E, 0xE69FBE },
	{ 0x6263, 0xE6A092 },
	{ 0x6E7B, 0xE6A093 },
	{ 0x5F77, 0xE6A096 },
	{ 0x574A, 0xE6A097 },
	{ 0x4E68, 0xE6A0A1 },
	{ 0x5B5B, 0xE6A0A2 },
	{ 0x713B, 0xE6A0AA },
	{ 0x6971, 0xE6A0AF },
	{ 0x7A37, 0xE6A0B8 },
	{ 0x5046, 0xE6A0B9 },
	{ 0x4C2B, 0xE6A0BC },
	{ 0x6E28, 0xE6A0BD },
	{ 0x4B7A, 0xE6A180 },
	{ 0x7979, 0xE6A181 },
	{ 0x4C7D, 0xE6A182 },
	{ 0x537E, 0xE6A183 },
	{ 0x6450, 0xE6A188 },
	{ 0x726E, 0xE6A18E },
	{ 0x5455, 0xE6A190 },
	{ 0x5F4D, 0xE6A191 },
	{ 0x7C38, 0xE6A193 },
	{ 0x5150, 0xE6A194 },
	{ 0x724D, 0xE6A1AD },
	{ 0x7752, 0xE6A1B6 },
	{ 0x4A54, 0xE6A1BF },
	{ 0x5559, 0xE6A281 },
	{ 0x585E, 0xE6A285 },
	{ 0x4D59, 0xE6A28F },
	{ 0x6E29, 0xE6A293 },
	{ 0x763C, 0xE6A294 },
	{ 0x4C5B, 0xE6A297 },
	{ 0x7049, 0xE6A29D },
	{ 0x7C7C, 0xE6A29F },
	{ 0x6849, 0xE6A2A1 },
	{ 0x747E, 0xE6A2A2 },
	{ 0x677C, 0xE6A2A7 },
	{ 0x575E, 0xE6A2A8 },
	{ 0x5E5C, 0xE6A2AD },
	{ 0x702C, 0xE6A2AF },
	{ 0x4C7E, 0xE6A2B0 },
	{ 0x4D61, 0xE6A2B1 },
	{ 0x613A, 0xE6A2B3 },
	{ 0x5B6F, 0xE6A2B5 },
	{ 0x5A32, 0xE6A2B6 },
	{ 0x5125, 0xE6A384 },
	{ 0x5C38, 0xE6A385 },
	{ 0x5876, 0xE6A389 },
	{ 0x5124, 0xE6A38B },
	{ 0x4D62, 0xE6A38D },
	{ 0x5C6A, 0xE6A392 },
	{ 0x7077, 0xE6A395 },
	{ 0x704A, 0xE6A397 },
	{ 0x503E, 0xE6A398 },
	{ 0x5D5C, 0xE6A39A },
	{ 0x5456, 0xE6A39F },
	{ 0x5356, 0xE6A3A0 },
	{ 0x6D50, 0xE6A3A7 },
	{ 0x4D21, 0xE6A3A8 },
	{ 0x5F35, 0xE6A3AE },
	{ 0x5F78, 0xE6A3B2 },
	{ 0x5421, 0xE6A3B9 },
	{ 0x4E32, 0xE6A3BA },
	{ 0x684A, 0xE6A480 },
	{ 0x6B75, 0xE6A485 },
	{ 0x6355, 0xE6A48D },
	{ 0x7550, 0xE6A48E },
	{ 0x7521, 0xE6A492 },
	{ 0x5927, 0xE6A4A7 },
	{ 0x652B, 0xE6A4B0 },
	{ 0x664B, 0xE6A4BD },
	{ 0x7571, 0xE6A4BF },
	{ 0x6545, 0xE6A58A },
	{ 0x7923, 0xE6A593 },
	{ 0x605B, 0xE6A594 },
	{ 0x766B, 0xE6A595 },
	{ 0x4B71, 0xE6A597 },
	{ 0x596A, 0xE6A599 },
	{ 0x7522, 0xE6A59A },
	{ 0x5751, 0xE6A59E },
	{ 0x5178, 0xE6A5A0 },
	{ 0x6A78, 0xE6A5A1 },
	{ 0x6A79, 0xE6A5A2 },
	{ 0x5A33, 0xE6A5A3 },
	{ 0x6F5F, 0xE6A5A8 },
	{ 0x716F, 0xE6A5AB },
	{ 0x6576, 0xE6A5AD },
	{ 0x6E3F, 0xE6A5AE },
	{ 0x6264, 0xE6A5AF },
	{ 0x503F, 0xE6A5B5 },
	{ 0x7A2C, 0xE6A5B7 },
	{ 0x7551, 0xE6A5B8 },
	{ 0x6733, 0xE6A5B9 },
	{ 0x693E, 0xE6A695 },
	{ 0x724E, 0xE6A69B },
	{ 0x5B34, 0xE6A69C },
	{ 0x7C4E, 0xE6A6A5 },
	{ 0x5D6E, 0xE6A6A7 },
	{ 0x6734, 0xE6A6AE },
	{ 0x5734, 0xE6A6B4 },
	{ 0x7734, 0xE6A6BB },
	{ 0x4D3E, 0xE6A781 },
	{ 0x5A69, 0xE6A783 },
	{ 0x4F30, 0xE6A78B },
	{ 0x7759, 0xE6A78C },
	{ 0x7366, 0xE6A78D },
	{ 0x4E59, 0xE6A790 },
	{ 0x4E2A, 0xE6A7A8 },
	{ 0x4B48, 0xE6A7AA },
	{ 0x5027, 0xE6A7BB },
	{ 0x704B, 0xE6A7BD },
	{ 0x5047, 0xE6A7BF },
	{ 0x6445, 0xE6A882 },
	{ 0x5B60, 0xE6A88A },
	{ 0x555A, 0xE6A891 },
	{ 0x5727, 0xE6A893 },
	{ 0x6E40, 0xE6A897 },
	{ 0x7876, 0xE6A899 },
	{ 0x7552, 0xE6A89E },
	{ 0x6D69, 0xE6A89F },
	{ 0x593C, 0xE6A8A1 },
	{ 0x6546, 0xE6A8A3 },
	{ 0x7523, 0xE6A8B5 },
	{ 0x5A54, 0xE6A8B8 },
	{ 0x6227, 0xE6A8B9 },
	{ 0x7B7C, 0xE6A8BA },
	{ 0x715C, 0xE6A8BD },
	{ 0x4A74, 0xE6A984 },
	{ 0x687A, 0xE6A988 },
	{ 0x4E69, 0xE6A98B },
	{ 0x6978, 0xE6A992 },
	{ 0x6265, 0xE6A993 },
	{ 0x5039, 0xE6A998 },
	{ 0x5472, 0xE6A999 },
	{ 0x5126, 0xE6A99F },
	{ 0x5F4E, 0xE6A9A1 },
	{ 0x7C74, 0xE6A9AB },
	{ 0x532A, 0xE6AA80 },
	{ 0x4C2C, 0xE6AA84 },
	{ 0x6F60, 0xE6AA89 },
	{ 0x6565, 0xE6AA8D },
	{ 0x5055, 0xE6AA8E },
	{ 0x5B7C, 0xE6AA97 },
	{ 0x7C66, 0xE6AA9C },
	{ 0x4B7E, 0xE6AAA2 },
	{ 0x6D6A, 0xE6AAA3 },
	{ 0x5E31, 0xE6AAB3 },
	{ 0x7963, 0xE6AABB },
	{ 0x5422, 0xE6AB82 },
	{ 0x4F76, 0xE6AB83 },
	{ 0x5650, 0xE6AB93 },
	{ 0x556A, 0xE6AB9A },
	{ 0x716E, 0xE6AB9B },
	{ 0x7A4B, 0xE6ABB6 },
	{ 0x6521, 0xE6ABBB },
	{ 0x5531, 0xE6AC84 },
	{ 0x4F6D, 0xE6AC8A },
	{ 0x6D6B, 0xE6AC8C },
	{ 0x5532, 0xE6AC92 },
	{ 0x553C, 0xE6AC96 },
	{ 0x7D62, 0xE6ACA0 },
	{ 0x732D, 0xE6ACA1 },
	{ 0x7D5B, 0xE6ACA3 },
	{ 0x6930, 0xE6ACB2 },
	{ 0x5127, 0xE6ACBA },
	{ 0x7D63, 0xE6ACBD },
	{ 0x4E33, 0xE6ACBE },
	{ 0x7D64, 0xE6AD86 },
	{ 0x7A4E, 0xE6AD87 },
	{ 0x4A30, 0xE6AD8C },
	{ 0x7727, 0xE6AD8E },
	{ 0x4F31, 0xE6AD90 },
	{ 0x6622, 0xE6AD9F },
	{ 0x7C36, 0xE6ADA1 },
	{ 0x722D, 0xE6ADA2 },
	{ 0x6F61, 0xE6ADA3 },
	{ 0x732E, 0xE6ADA4 },
	{ 0x5C46, 0xE6ADA5 },
	{ 0x596B, 0xE6ADA6 },
	{ 0x6860, 0xE6ADAA },
	{ 0x6128, 0xE6ADB2 },
	{ 0x5576, 0xE6ADB7 },
	{ 0x4F7D, 0xE6ADB8 },
	{ 0x5E5D, 0xE6ADBB },
	{ 0x5951, 0xE6ADBF },
	{ 0x646A, 0xE6AE83 },
	{ 0x724F, 0xE6AE84 },
	{ 0x773F, 0xE6AE86 },
	{ 0x6266, 0xE6AE89 },
	{ 0x6228, 0xE6AE8A },
	{ 0x6356, 0xE6AE96 },
	{ 0x6D51, 0xE6AE98 },
	{ 0x6979, 0xE6AE9E },
	{ 0x5631, 0xE6AEAE },
	{ 0x5E32, 0xE6AEAF },
	{ 0x6068, 0xE6AEB2 },
	{ 0x532B, 0xE6AEB5 },
	{ 0x6B5C, 0xE6AEB7 },
	{ 0x5F2F, 0xE6AEBA },
	{ 0x4A43, 0xE6AEBC },
	{ 0x6E7C, 0xE6AEBF },
	{ 0x7D43, 0xE6AF81 },
	{ 0x6B76, 0xE6AF85 },
	{ 0x4F32, 0xE6AF86 },
	{ 0x596C, 0xE6AF8B },
	{ 0x593D, 0xE6AF8D },
	{ 0x585F, 0xE6AF8F },
	{ 0x5438, 0xE6AF92 },
	{ 0x6B3E, 0xE6AF93 },
	{ 0x5D6F, 0xE6AF94 },
	{ 0x5D70, 0xE6AF96 },
	{ 0x5D71, 0xE6AF97 },
	{ 0x5D72, 0xE6AF98 },
	{ 0x593E, 0xE6AF9B },
	{ 0x7B46, 0xE6AFAB },
	{ 0x4F33, 0xE6AFAC },
	{ 0x6E7D, 0xE6B088 },
	{ 0x642B, 0xE6B08F },
	{ 0x5A45, 0xE6B091 },
	{ 0x586C, 0xE6B093 },
	{ 0x5128, 0xE6B0A3 },
	{ 0x6229, 0xE6B0B4 },
	{ 0x5E3C, 0xE6B0B7 },
	{ 0x6735, 0xE6B0B8 },
	{ 0x5B70, 0xE6B0BE },
	{ 0x6F62, 0xE6B180 },
	{ 0x7170, 0xE6B181 },
	{ 0x4F34, 0xE6B182 },
	{ 0x5B71, 0xE6B18E },
	{ 0x6031, 0xE6B190 },
	{ 0x5F25, 0xE6B195 },
	{ 0x7952, 0xE6B197 },
	{ 0x677D, 0xE6B19A },
	{ 0x6623, 0xE6B19D },
	{ 0x7B71, 0xE6B19E },
	{ 0x4B30, 0xE6B19F },
	{ 0x722E, 0xE6B1A0 },
	{ 0x4D67, 0xE6B1A8 },
	{ 0x685C, 0xE6B1AA },
	{ 0x6757, 0xE6B1AD },
	{ 0x7740, 0xE6B1B0 },
	{ 0x5063, 0xE6B1B2 },
	{ 0x5A21, 0xE6B1B6 },
	{ 0x4C3D, 0xE6B1BA },
	{ 0x5129, 0xE6B1BD },
	{ 0x5D4C, 0xE6B1BE },
	{ 0x637E, 0xE6B281 },
	{ 0x512A, 0xE6B282 },
	{ 0x682A, 0xE6B283 },
	{ 0x6A36, 0xE6B285 },
	{ 0x797A, 0xE6B286 },
	{ 0x664C, 0xE6B287 },
	{ 0x7658, 0xE6B288 },
	{ 0x5447, 0xE6B28C },
	{ 0x594B, 0xE6B290 },
	{ 0x5952, 0xE6B292 },
	{ 0x534B, 0xE6B293 },
	{ 0x5877, 0xE6B294 },
	{ 0x5A29, 0xE6B295 },
	{ 0x7578, 0xE6B296 },
	{ 0x5E5E, 0xE6B299 },
	{ 0x722F, 0xE6B29A },
	{ 0x7829, 0xE6B29B },
	{ 0x5848, 0xE6B2AB },
	{ 0x6E41, 0xE6B2AE },
	{ 0x7941, 0xE6B2B3 },
	{ 0x5D73, 0xE6B2B8 },
	{ 0x6A7A, 0xE6B2B9 },
	{ 0x763D, 0xE6B2BB },
	{ 0x613B, 0xE6B2BC },
	{ 0x4D3F, 0xE6B2BD },
	{ 0x7454, 0xE6B2BE },
	{ 0x664D, 0xE6B2BF },
	{ 0x7C4F, 0xE6B381 },
	{ 0x7B22, 0xE6B382 },
	{ 0x605C, 0xE6B384 },
	{ 0x743B, 0xE6B389 },
	{ 0x5A55, 0xE6B38A },
	{ 0x7932, 0xE6B38C },
	{ 0x7B72, 0xE6B393 },
	{ 0x5B76, 0xE6B395 },
	{ 0x5E5F, 0xE6B397 },
	{ 0x5B72, 0xE6B39B },
	{ 0x785C, 0xE6B3A1 },
	{ 0x776E, 0xE6B3A2 },
	{ 0x6B68, 0xE6B3A3 },
	{ 0x527A, 0xE6B3A5 },
	{ 0x713C, 0xE6B3A8 },
	{ 0x7A5A, 0xE6B3AB },
	{ 0x5A6A, 0xE6B3AE },
	{ 0x5A46, 0xE6B3AF },
	{ 0x7741, 0xE6B3B0 },
	{ 0x6736, 0xE6B3B3 },
	{ 0x6547, 0xE6B48B },
	{ 0x562C, 0xE6B48C },
	{ 0x5C47, 0xE6B491 },
	{ 0x6129, 0xE6B497 },
	{ 0x622A, 0xE6B499 },
	{ 0x5526, 0xE6B49B },
	{ 0x5457, 0xE6B49E },
	{ 0x7250, 0xE6B4A5 },
	{ 0x6A7B, 0xE6B4A7 },
	{ 0x605D, 0xE6B4A9 },
	{ 0x7B73, 0xE6B4AA },
	{ 0x713D, 0xE6B4B2 },
	{ 0x6267, 0xE6B4B5 },
	{ 0x7D57, 0xE6B4B6 },
	{ 0x4E48, 0xE6B4B8 },
	{ 0x6A37, 0xE6B4B9 },
	{ 0x7C40, 0xE6B4BB },
	{ 0x7D67, 0xE6B4BD },
	{ 0x776F, 0xE6B4BE },
	{ 0x5735, 0xE6B581 },
	{ 0x6F3A, 0xE6B599 },
	{ 0x715D, 0xE6B59A },
	{ 0x5E33, 0xE6B59C },
	{ 0x684B, 0xE6B5A3 },
	{ 0x785D, 0xE6B5A6 },
	{ 0x7B47, 0xE6B5A9 },
	{ 0x5548, 0xE6B5AA },
	{ 0x575F, 0xE6B5AC },
	{ 0x5D29, 0xE6B5AE },
	{ 0x6931, 0xE6B5B4 },
	{ 0x7A2D, 0xE6B5B7 },
	{ 0x7659, 0xE6B5B8 },
	{ 0x7A74, 0xE6B5B9 },
	{ 0x782A, 0xE6B5BF },
	{ 0x666E, 0xE6B685 },
	{ 0x4C5C, 0xE6B687 },
	{ 0x613C, 0xE6B688 },
	{ 0x606F, 0xE6B689 },
	{ 0x693F, 0xE6B68C },
	{ 0x7C7D, 0xE6B68D },
	{ 0x664E, 0xE6B68E },
	{ 0x6157, 0xE6B691 },
	{ 0x664F, 0xE6B693 },
	{ 0x7471, 0xE6B695 },
	{ 0x6473, 0xE6B6AF },
	{ 0x647B, 0xE6B6B2 },
	{ 0x7964, 0xE6B6B5 },
	{ 0x6F63, 0xE6B780 },
	{ 0x4F6E, 0xE6B783 },
	{ 0x763E, 0xE6B784 },
	{ 0x6032, 0xE6B785 },
	{ 0x7C7E, 0xE6B786 },
	{ 0x512B, 0xE6B787 },
	{ 0x577A, 0xE6B78B },
	{ 0x7B48, 0xE6B78F },
	{ 0x6257, 0xE6B791 },
	{ 0x5423, 0xE6B798 },
	{ 0x7078, 0xE6B799 },
	{ 0x5728, 0xE6B79A },
	{ 0x6167, 0xE6B79E },
	{ 0x533F, 0xE6B7A1 },
	{ 0x6F64, 0xE6B7A8 },
	{ 0x5745, 0xE6B7AA },
	{ 0x6B62, 0xE6B7AB },
	{ 0x7C67, 0xE6B7AE },
	{ 0x6422, 0xE6B7B1 },
	{ 0x6268, 0xE6B7B3 },
	{ 0x6650, 0xE6B7B5 },
	{ 0x7B68, 0xE6B7B7 },
	{ 0x7468, 0xE6B7B8 },
	{ 0x6574, 0xE6B7B9 },
	{ 0x743C, 0xE6B7BA },
	{ 0x7455, 0xE6B7BB },
	{ 0x5F36, 0xE6B897 },
	{ 0x7C39, 0xE6B899 },
	{ 0x6E42, 0xE6B89A },
	{ 0x4A75, 0xE6B89B },
	{ 0x6F65, 0xE6B89F },
	{ 0x4B62, 0xE6B8A0 },
	{ 0x5424, 0xE6B8A1 },
	{ 0x5E60, 0xE6B8A3 },
	{ 0x5A7D, 0xE6B8A4 },
	{ 0x6446, 0xE6B8A5 },
	{ 0x683E, 0xE6B8A6 },
	{ 0x605E, 0xE6B8AB },
	{ 0x7634, 0xE6B8AC },
	{ 0x6A52, 0xE6B8AD },
	{ 0x797B, 0xE6B8AF },
	{ 0x6042, 0xE6B8B2 },
	{ 0x4A64, 0xE6B8B4 },
	{ 0x6737, 0xE6B8B6 },
	{ 0x6A7D, 0xE6B8B8 },
	{ 0x595D, 0xE6B8BA },
	{ 0x5A34, 0xE6B8BC },
	{ 0x6E2A, 0xE6B8BD },
	{ 0x7B69, 0xE6B8BE },
	{ 0x5B4B, 0xE6B983 },
	{ 0x5A35, 0xE6B984 },
	{ 0x713E, 0xE6B98A },
	{ 0x532C, 0xE6B98D },
	{ 0x7B49, 0xE6B996 },
	{ 0x5F4F, 0xE6B998 },
	{ 0x5340, 0xE6B99B },
	{ 0x6357, 0xE6B99C },
	{ 0x6F66, 0xE6B99E },
	{ 0x7C50, 0xE6B99F },
	{ 0x6940, 0xE6B9A7 },
	{ 0x7553, 0xE6B9AB },
	{ 0x6C5C, 0xE6B9AE },
	{ 0x7737, 0xE6B9AF },
	{ 0x6A38, 0xE6B9B2 },
	{ 0x5179, 0xE6B9B3 },
	{ 0x5C48, 0xE6B9BA },
	{ 0x6A39, 0xE6BA90 },
	{ 0x715E, 0xE6BA96 },
	{ 0x5736, 0xE6BA9C },
	{ 0x4F35, 0xE6BA9D },
	{ 0x5928, 0xE6BA9F },
	{ 0x6C6E, 0xE6BAA2 },
	{ 0x5D2A, 0xE6BAA5 },
	{ 0x4D22, 0xE6BAAA },
	{ 0x682E, 0xE6BAAB },
	{ 0x613D, 0xE6BAAF },
	{ 0x7251, 0xE6BAB1 },
	{ 0x6941, 0xE6BAB6 },
	{ 0x527C, 0xE6BABA },
	{ 0x5B35, 0xE6BB82 },
	{ 0x7367, 0xE6BB84 },
	{ 0x587E, 0xE6BB85 },
	{ 0x7C51, 0xE6BB89 },
	{ 0x6D32, 0xE6BB8B },
	{ 0x742F, 0xE6BB8C },
	{ 0x7B23, 0xE6BB8E },
	{ 0x7C41, 0xE6BB91 },
	{ 0x6E2B, 0xE6BB93 },
	{ 0x5425, 0xE6BB94 },
	{ 0x7472, 0xE6BBAF },
	{ 0x6E59, 0xE6BBB4 },
	{ 0x7B4A, 0xE6BBB8 },
	{ 0x4D63, 0xE6BBBE },
	{ 0x583B, 0xE6BBBF },
	{ 0x655B, 0xE6BC81 },
	{ 0x7877, 0xE6BC82 },
	{ 0x7654, 0xE6BC86 },
	{ 0x5729, 0xE6BC8F },
	{ 0x4B49, 0xE6BC91 },
	{ 0x6651, 0xE6BC94 },
	{ 0x704C, 0xE6BC95 },
	{ 0x582E, 0xE6BCA0 },
	{ 0x7953, 0xE6BCA2 },
	{ 0x557E, 0xE6BCA3 },
	{ 0x583C, 0xE6BCAB },
	{ 0x7230, 0xE6BCAC },
	{ 0x622B, 0xE6BCB1 },
	{ 0x7368, 0xE6BCB2 },
	{ 0x6F42, 0xE6BCB8 },
	{ 0x6D6C, 0xE6BCBF },
	{ 0x6738, 0xE6BD81 },
	{ 0x5A7E, 0xE6BD91 },
	{ 0x4C3E, 0xE6BD94 },
	{ 0x727C, 0xE6BD97 },
	{ 0x5A6B, 0xE6BD98 },
	{ 0x6258, 0xE6BD9A },
	{ 0x6D56, 0xE6BD9B },
	{ 0x5651, 0xE6BD9E },
	{ 0x6033, 0xE6BD9F },
	{ 0x7C52, 0xE6BDA2 },
	{ 0x6B48, 0xE6BDA4 },
	{ 0x5341, 0xE6BDAD },
	{ 0x704D, 0xE6BDAE },
	{ 0x4F77, 0xE6BDB0 },
	{ 0x6D52, 0xE6BDBA },
	{ 0x5458, 0xE6BDBC },
	{ 0x5C49, 0xE6BDBD },
	{ 0x5771, 0xE6BDBE },
	{ 0x5F3B, 0xE6BE81 },
	{ 0x7325, 0xE6BE84 },
	{ 0x744D, 0xE6BE88 },
	{ 0x713F, 0xE6BE8D },
	{ 0x7831, 0xE6BE8E },
	{ 0x697A, 0xE6BE90 },
	{ 0x7B4B, 0xE6BE94 },
	{ 0x4A55, 0xE6BE97 },
	{ 0x7954, 0xE6BEA3 },
	{ 0x774A, 0xE6BEA4 },
	{ 0x5648, 0xE6BEA7 },
	{ 0x7C68, 0xE6BEAE },
	{ 0x733D, 0xE6BEAF },
	{ 0x6E7E, 0xE6BEB1 },
	{ 0x677E, 0xE6BEB3 },
	{ 0x5342, 0xE6BEB9 },
	{ 0x5336, 0xE6BEBE },
	{ 0x4C2D, 0xE6BF80 },
	{ 0x767A, 0xE6BF81 },
	{ 0x5632, 0xE6BF82 },
	{ 0x5258, 0xE6BF83 },
	{ 0x6758, 0xE6BF8A },
	{ 0x6325, 0xE6BF95 },
	{ 0x6739, 0xE6BF9A },
	{ 0x702D, 0xE6BF9F },
	{ 0x7B4C, 0xE6BFA0 },
	{ 0x6B21, 0xE6BFA1 },
	{ 0x5426, 0xE6BFA4 },
	{ 0x7B4D, 0xE6BFA9 },
	{ 0x553D, 0xE6BFAB },
	{ 0x715F, 0xE6BFAC },
	{ 0x767B, 0xE6BFAF },
	{ 0x5E34, 0xE6BFB1 },
	{ 0x556B, 0xE6BFBE },
	{ 0x6548, 0xE78081 },
	{ 0x7B24, 0xE78085 },
	{ 0x5439, 0xE78086 },
	{ 0x5E61, 0xE78089 },
	{ 0x6423, 0xE7808B },
	{ 0x5737, 0xE7808F },
	{ 0x786E, 0xE78091 },
	{ 0x5E35, 0xE78095 },
	{ 0x5652, 0xE78098 },
	{ 0x7955, 0xE7809A },
	{ 0x673A, 0xE7809B },
	{ 0x6B55, 0xE7809C },
	{ 0x5577, 0xE7809D },
	{ 0x6F67, 0xE7809E },
	{ 0x613E, 0xE7809F },
	{ 0x7A2E, 0xE780A3 },
	{ 0x5669, 0xE780A7 },
	{ 0x566E, 0xE780A8 },
	{ 0x673B, 0xE780AF },
	{ 0x6C4B, 0xE780B7 },
	{ 0x5533, 0xE780BE },
	{ 0x4E34, 0xE7818C },
	{ 0x7B25, 0xE78190 },
	{ 0x616E, 0xE78191 },
	{ 0x7728, 0xE78198 },
	{ 0x7B4E, 0xE7819D },
	{ 0x583D, 0xE781A3 },
	{ 0x7B7D, 0xE781AB },
	{ 0x7C69, 0xE781B0 },
	{ 0x4F36, 0xE781B8 },
	{ 0x6D47, 0xE781BC },
	{ 0x6E2C, 0xE781BD },
	{ 0x4C5D, 0xE78285 },
	{ 0x7627, 0xE7828A },
	{ 0x667A, 0xE7828E },
	{ 0x7524, 0xE78292 },
	{ 0x7D5C, 0xE78298 },
	{ 0x6D33, 0xE78299 },
	{ 0x4E49, 0xE7829A },
	{ 0x6F68, 0xE782A1 },
	{ 0x613F, 0xE782A4 },
	{ 0x7A5B, 0xE782AB },
	{ 0x4B63, 0xE782AC },
	{ 0x7729, 0xE782AD },
	{ 0x7B26, 0xE782AF },
	{ 0x5C39, 0xE782B3 },
	{ 0x7140, 0xE782B7 },
	{ 0x6D48, 0xE782B8 },
	{ 0x6F43, 0xE782B9 },
	{ 0x562D, 0xE78388 },
	{ 0x7D4E, 0xE7838B },
	{ 0x6821, 0xE7838F },
	{ 0x7B74, 0xE78398 },
	{ 0x5527, 0xE78399 },
	{ 0x7176, 0xE7839D },
	{ 0x6653, 0xE7839F },
	{ 0x4C5E, 0xE783B1 },
	{ 0x7832, 0xE783B9 },
	{ 0x5C6B, 0xE783BD },
	{ 0x7D36, 0xE78484 },
	{ 0x656A, 0xE78489 },
	{ 0x7160, 0xE7848C },
	{ 0x5B4C, 0xE78499 },
	{ 0x5D4D, 0xE7849A },
	{ 0x5448, 0xE7849E },
	{ 0x596D, 0xE784A1 },
	{ 0x7525, 0xE784A6 },
	{ 0x667B, 0xE784B0 },
	{ 0x6654, 0xE784B6 },
	{ 0x7D48, 0xE78587 },
	{ 0x5621, 0xE78589 },
	{ 0x7D3F, 0xE7858A },
	{ 0x7C53, 0xE7858C },
	{ 0x6F21, 0xE7858E },
	{ 0x673C, 0xE78590 },
	{ 0x516E, 0xE78596 },
	{ 0x6655, 0xE78599 },
	{ 0x6972, 0xE7859C },
	{ 0x5F30, 0xE7859E },
	{ 0x5860, 0xE785A4 },
	{ 0x7C3A, 0xE785A5 },
	{ 0x7D2F, 0xE785A6 },
	{ 0x704E, 0xE785A7 },
	{ 0x5B61, 0xE785A9 },
	{ 0x6549, 0xE785AC },
	{ 0x6D34, 0xE785AE },
	{ 0x6043, 0xE785BD },
	{ 0x6358, 0xE78684 },
	{ 0x697B, 0xE78689 },
	{ 0x6A28, 0xE7868A },
	{ 0x7D37, 0xE7868F },
	{ 0x7B27, 0xE78692 },
	{ 0x6942, 0xE78694 },
	{ 0x7D77, 0xE78699 },
	{ 0x6259, 0xE7869F },
	{ 0x5C6C, 0xE786A2 },
	{ 0x6822, 0xE786AC },
	{ 0x6670, 0xE786B1 },
	{ 0x7D78, 0xE786B9 },
	{ 0x7D79, 0xE786BA },
	{ 0x763F, 0xE786BE },
	{ 0x6727, 0xE78781 },
	{ 0x6657, 0xE78783 },
	{ 0x5473, 0xE78788 },
	{ 0x5449, 0xE78789 },
	{ 0x567A, 0xE7878E },
	{ 0x5772, 0xE78790 },
	{ 0x6140, 0xE78792 },
	{ 0x5B62, 0xE78794 },
	{ 0x6658, 0xE78795 },
	{ 0x673D, 0xE7879F },
	{ 0x704F, 0xE787A5 },
	{ 0x733E, 0xE787A6 },
	{ 0x622C, 0xE787A7 },
	{ 0x7537, 0xE787AD },
	{ 0x6070, 0xE787AE },
	{ 0x7D38, 0xE787BB },
	{ 0x6368, 0xE787BC },
	{ 0x5427, 0xE787BE },
	{ 0x687C, 0xE787BF },
	{ 0x7A52, 0xE78880 },
	{ 0x786F, 0xE78886 },
	{ 0x5653, 0xE78890 },
	{ 0x5534, 0xE7889B },
	{ 0x7050, 0xE788AA },
	{ 0x7770, 0xE788AC },
	{ 0x6E33, 0xE788AD },
	{ 0x6A3A, 0xE788B0 },
	{ 0x6A53, 0xE788B2 },
	{ 0x6D49, 0xE788B5 },
	{ 0x5D2B, 0xE788B6 },
	{ 0x652C, 0xE788BA },
	{ 0x7D21, 0xE788BB },
	{ 0x5F50, 0xE788BD },
	{ 0x6C33, 0xE788BE },
	{ 0x5F51, 0xE78980 },
	{ 0x6D6D, 0xE78986 },
	{ 0x7838, 0xE78987 },
	{ 0x777A, 0xE78988 },
	{ 0x782B, 0xE7898C },
	{ 0x7460, 0xE78992 },
	{ 0x543A, 0xE78998 },
	{ 0x6433, 0xE78999 },
	{ 0x695A, 0xE7899B },
	{ 0x5E36, 0xE7899D },
	{ 0x593F, 0xE7899F },
	{ 0x5940, 0xE789A1 },
	{ 0x566F, 0xE789A2 },
	{ 0x594C, 0xE789A7 },
	{ 0x5A2A, 0xE789A9 },
	{ 0x5F65, 0xE789B2 },
	{ 0x7765, 0xE789B9 },
	{ 0x4C32, 0xE789BD },
	{ 0x5F79, 0xE78A80 },
	{ 0x5760, 0xE78A81 },
	{ 0x543B, 0xE78AA2 },
	{ 0x7D7A, 0xE78AA7 },
	{ 0x4C33, 0xE78AAC },
	{ 0x5B73, 0xE78AAF },
	{ 0x5F52, 0xE78B80 },
	{ 0x4E4A, 0xE78B82 },
	{ 0x6E5A, 0xE78B84 },
	{ 0x6464, 0xE78B8E },
	{ 0x7B4F, 0xE78B90 },
	{ 0x4F37, 0xE78B97 },
	{ 0x6E43, 0xE78B99 },
	{ 0x4E6A, 0xE78BA1 },
	{ 0x622D, 0xE78BA9 },
	{ 0x5761, 0xE78BB8 },
	{ 0x7A75, 0xE78BB9 },
	{ 0x5549, 0xE78BBC },
	{ 0x782C, 0xE78BBD },
	{ 0x6759, 0xE78C8A },
	{ 0x7369, 0xE78C96 },
	{ 0x586D, 0xE78C9B },
	{ 0x6344, 0xE78C9C },
	{ 0x7071, 0xE78C9D },
	{ 0x6865, 0xE78CA5 },
	{ 0x607A, 0xE78CA9 },
	{ 0x6E44, 0xE78CAA },
	{ 0x595E, 0xE78CAB },
	{ 0x6B22, 0xE78CB6 },
	{ 0x6B23, 0xE78CB7 },
	{ 0x7C42, 0xE78CBE },
	{ 0x6A3B, 0xE78CBF },
	{ 0x682B, 0xE78D84 },
	{ 0x5E62, 0xE78D85 },
	{ 0x6D6F, 0xE78D90 },
	{ 0x6823, 0xE78D92 },
	{ 0x4F71, 0xE78D97 },
	{ 0x543C, 0xE78DA8 },
	{ 0x7C6A, 0xE78DAA },
	{ 0x673E, 0xE78DB0 },
	{ 0x7C72, 0xE78DB2 },
	{ 0x5634, 0xE78DB5 },
	{ 0x622E, 0xE78DB8 },
	{ 0x5337, 0xE78DBA },
	{ 0x7A4C, 0xE78DBB },
	{ 0x7A5C, 0xE78E84 },
	{ 0x6D35, 0xE78E86 },
	{ 0x6163, 0xE78E87 },
	{ 0x682C, 0xE78E89 },
	{ 0x685D, 0xE78E8B },
	{ 0x6F69, 0xE78E8E },
	{ 0x743D, 0xE78E94 },
	{ 0x4F38, 0xE78E96 },
	{ 0x695B, 0xE78E97 },
	{ 0x512C, 0xE78E98 },
	{ 0x5A47, 0xE78E9F },
	{ 0x6B49, 0xE78EA7 },
	{ 0x684C, 0xE78EA9 },
	{ 0x5E37, 0xE78EAD },
	{ 0x563C, 0xE78EB2 },
	{ 0x5365, 0xE78EB3 },
	{ 0x7A5D, 0xE78EB9 },
	{ 0x5A56, 0xE78F80 },
	{ 0x4A31, 0xE78F82 },
	{ 0x5A48, 0xE78F89 },
	{ 0x5F26, 0xE78F8A },
	{ 0x7933, 0xE78F8C },
	{ 0x7252, 0xE78F8D },
	{ 0x4A44, 0xE78F8F },
	{ 0x4E4B, 0xE78F96 },
	{ 0x4D75, 0xE78F99 },
	{ 0x7D30, 0xE78F9D },
	{ 0x5528, 0xE78F9E },
	{ 0x7141, 0xE78FA0 },
	{ 0x6269, 0xE78FA3 },
	{ 0x5C4A, 0xE78FA4 },
	{ 0x6C34, 0xE78FA5 },
	{ 0x7A40, 0xE78FA6 },
	{ 0x7B28, 0xE78FA9 },
	{ 0x5028, 0xE78FAA },
	{ 0x5A6C, 0xE78FAD },
	{ 0x596E, 0xE78FB7 },
	{ 0x607B, 0xE78FB9 },
	{ 0x6F6A, 0xE78FBD },
	{ 0x7A5E, 0xE78FBE },
	{ 0x6044, 0xE79081 },
	{ 0x4F39, 0xE79083 },
	{ 0x554A, 0xE79085 },
	{ 0x5762, 0xE79086 },
	{ 0x622F, 0xE79087 },
	{ 0x5738, 0xE79089 },
	{ 0x684D, 0xE79093 },
	{ 0x765A, 0xE7909B },
	{ 0x6F22, 0xE790A0 },
	{ 0x625A, 0xE790A1 },
	{ 0x767C, 0xE790A2 },
	{ 0x7B50, 0xE790A5 },
	{ 0x512D, 0xE790A6 },
	{ 0x4D64, 0xE790A8 },
	{ 0x512E, 0xE790AA },
	{ 0x5C6D, 0xE790AB },
	{ 0x684E, 0xE790AC },
	{ 0x7079, 0xE790AE },
	{ 0x4E35, 0xE790AF },
	{ 0x667C, 0xE790B0 },
	{ 0x577B, 0xE790B3 },
	{ 0x5056, 0xE790B4 },
	{ 0x5D75, 0xE790B5 },
	{ 0x7771, 0xE790B6 },
	{ 0x767D, 0xE790B8 },
	{ 0x5B77, 0xE790BA },
	{ 0x7B6A, 0xE790BF },
	{ 0x695C, 0xE79180 },
	{ 0x5941, 0xE79181 },
	{ 0x7572, 0xE79183 },
	{ 0x6045, 0xE79184 },
	{ 0x6A54, 0xE7918B },
	{ 0x7942, 0xE79195 },
	{ 0x6A3C, 0xE79197 },
	{ 0x5245, 0xE79199 },
	{ 0x7B51, 0xE7919A },
	{ 0x6740, 0xE7919B },
	{ 0x6B25, 0xE7919C },
	{ 0x5F7A, 0xE7919E },
	{ 0x6322, 0xE7919F },
	{ 0x5739, 0xE791A0 },
	{ 0x6943, 0xE791A2 },
	{ 0x687D, 0xE791A4 },
	{ 0x682F, 0xE791A5 },
	{ 0x7253, 0xE791A8 },
	{ 0x7B29, 0xE791A9 },
	{ 0x5825, 0xE791AA },
	{ 0x554B, 0xE791AF },
	{ 0x5048, 0xE791BE },
	{ 0x512F, 0xE79282 },
	{ 0x5763, 0xE79283 },
	{ 0x6046, 0xE79287 },
	{ 0x5622, 0xE79289 },
	{ 0x6D70, 0xE7928B },
	{ 0x5773, 0xE79298 },
	{ 0x7C54, 0xE7929C },
	{ 0x5A57, 0xE7929E },
	{ 0x4C5F, 0xE7929F },
	{ 0x7254, 0xE792A1 },
	{ 0x5130, 0xE792A3 },
	{ 0x4C60, 0xE792A5 },
	{ 0x5B7D, 0xE792A7 },
	{ 0x733F, 0xE792A8 },
	{ 0x7051, 0xE792AA },
	{ 0x7C3B, 0xE792B0 },
	{ 0x6230, 0xE792B2 },
	{ 0x6625, 0xE792B5 },
	{ 0x625B, 0xE792B9 },
	{ 0x5F5E, 0xE792BD },
	{ 0x6047, 0xE792BF },
	{ 0x726F, 0xE79386 },
	{ 0x4C61, 0xE7938A },
	{ 0x566A, 0xE7938F },
	{ 0x6742, 0xE79394 },
	{ 0x4E36, 0xE79398 },
	{ 0x7340, 0xE7939A },
	{ 0x4D7E, 0xE7939C },
	{ 0x7B52, 0xE793A0 },
	{ 0x7878, 0xE793A2 },
	{ 0x777B, 0xE793A3 },
	{ 0x683F, 0xE793A6 },
	{ 0x6837, 0xE793AE },
	{ 0x6D36, 0xE793B7 },
	{ 0x5C3A, 0xE79481 },
	{ 0x4C34, 0xE79484 },
	{ 0x7177, 0xE79491 },
	{ 0x6838, 0xE79495 },
	{ 0x4A76, 0xE79498 },
	{ 0x6424, 0xE7949A },
	{ 0x7456, 0xE7949B },
	{ 0x5F66, 0xE7949F },
	{ 0x5F27, 0xE794A3 },
	{ 0x5F67, 0xE794A5 },
	{ 0x6141, 0xE794A6 },
	{ 0x6944, 0xE794A8 },
	{ 0x5C4B, 0xE794AB },
	{ 0x6945, 0xE794AC },
	{ 0x6F23, 0xE794B0 },
	{ 0x6B26, 0xE794B1 },
	{ 0x4B23, 0xE794B2 },
	{ 0x6369, 0xE794B3 },
	{ 0x517B, 0xE794B7 },
	{ 0x6F24, 0xE794B8 },
	{ 0x6F6B, 0xE794BA },
	{ 0x5034, 0xE79587 },
	{ 0x4D23, 0xE7958C },
	{ 0x6866, 0xE7958F },
	{ 0x6F25, 0xE79591 },
	{ 0x534C, 0xE79593 },
	{ 0x5A6D, 0xE79594 },
	{ 0x573A, 0xE79599 },
	{ 0x7255, 0xE7959B },
	{ 0x7565, 0xE7959C },
	{ 0x596F, 0xE7959D },
	{ 0x7934, 0xE795A2 },
	{ 0x5554, 0xE795A5 },
	{ 0x7D4F, 0xE795A6 },
	{ 0x5B63, 0xE795AA },
	{ 0x7161, 0xE795AF },
	{ 0x6C36, 0xE795B0 },
	{ 0x7B7E, 0xE795B5 },
	{ 0x5357, 0xE795B6 },
	{ 0x5131, 0xE795B8 },
	{ 0x4B31, 0xE795BA },
	{ 0x5132, 0xE795BF },
	{ 0x4B32, 0xE79686 },
	{ 0x7142, 0xE79687 },
	{ 0x7461, 0xE7968A },
	{ 0x7935, 0xE7968B },
	{ 0x6143, 0xE7968E },
	{ 0x6142, 0xE7968F },
	{ 0x6B77, 0xE79691 },
	{ 0x5F28, 0xE7969D },
	{ 0x4B4A, 0xE796A5 },
	{ 0x6639, 0xE796AB },
	{ 0x785E, 0xE796B1 },
	{ 0x792A, 0xE796B2 },
	{ 0x4A77, 0xE796B3 },
	{ 0x6D37, 0xE796B5 },
	{ 0x5338, 0xE796B8 },
	{ 0x7256, 0xE796B9 },
	{ 0x5459, 0xE796BC },
	{ 0x6E45, 0xE796BD },
	{ 0x7270, 0xE796BE },
	{ 0x4A32, 0xE79782 },
	{ 0x5C3B, 0xE79785 },
	{ 0x7178, 0xE79787 },
	{ 0x6C37, 0xE7978D },
	{ 0x654A, 0xE79792 },
	{ 0x7640, 0xE79794 },
	{ 0x7D5D, 0xE79795 },
	{ 0x5463, 0xE79798 },
	{ 0x4C62, 0xE79799 },
	{ 0x7754, 0xE7979B },
	{ 0x5765, 0xE797A2 },
	{ 0x5343, 0xE797B0 },
	{ 0x5826, 0xE797B2 },
	{ 0x7641, 0xE797B4 },
	{ 0x5D76, 0xE797BA },
	{ 0x4D40, 0xE797BC },
	{ 0x655C, 0xE79880 },
	{ 0x654B, 0xE7988D },
	{ 0x6144, 0xE79899 },
	{ 0x6830, 0xE7989F },
	{ 0x7430, 0xE798A0 },
	{ 0x736A, 0xE798A1 },
	{ 0x5A6E, 0xE798A2 },
	{ 0x573B, 0xE798A4 },
	{ 0x6231, 0xE798A6 },
	{ 0x572A, 0xE798BB },
	{ 0x567B, 0xE79982 },
	{ 0x645F, 0xE7998C },
	{ 0x4A56, 0xE7998E },
	{ 0x6B28, 0xE79992 },
	{ 0x5B7E, 0xE79996 },
	{ 0x7642, 0xE799A1 },
	{ 0x6F3B, 0xE799A4 },
	{ 0x547D, 0xE799A9 },
	{ 0x6048, 0xE799AC },
	{ 0x6839, 0xE799B0 },
	{ 0x6F26, 0xE799B2 },
	{ 0x4D24, 0xE799B8 },
	{ 0x5474, 0xE799BB },
	{ 0x5B21, 0xE799BC },
	{ 0x5B5C, 0xE799BD },
	{ 0x5B5D, 0xE799BE },
	{ 0x6E5C, 0xE79A84 },
	{ 0x4B4B, 0xE79A86 },
	{ 0x7C55, 0xE79A87 },
	{ 0x4E6B, 0xE79A8E },
	{ 0x4D41, 0xE79A90 },
	{ 0x7B53, 0xE79A93 },
	{ 0x792B, 0xE79AAE },
	{ 0x7554, 0xE79ABA },
	{ 0x5929, 0xE79ABF },
	{ 0x695D, 0xE79B82 },
	{ 0x5B4D, 0xE79B83 },
	{ 0x5D4E, 0xE79B86 },
	{ 0x6743, 0xE79B88 },
	{ 0x6C4C, 0xE79B8A },
	{ 0x796C, 0xE79B92 },
	{ 0x4B4C, 0xE79B96 },
	{ 0x607C, 0xE79B9B },
	{ 0x5428, 0xE79B9C },
	{ 0x6D53, 0xE79B9E },
	{ 0x586F, 0xE79B9F },
	{ 0x7257, 0xE79BA1 },
	{ 0x4A78, 0xE79BA3 },
	{ 0x5A6F, 0xE79BA4 },
	{ 0x5654, 0xE79BA7 },
	{ 0x594D, 0xE79BAE },
	{ 0x586E, 0xE79BB2 },
	{ 0x7241, 0xE79BB4 },
	{ 0x5F53, 0xE79BB8 },
	{ 0x5A70, 0xE79BBC },
	{ 0x626A, 0xE79BBE },
	{ 0x607D, 0xE79C81 },
	{ 0x5878, 0xE79C84 },
	{ 0x772F, 0xE79C88 },
	{ 0x5A36, 0xE79C89 },
	{ 0x4A57, 0xE79C8B },
	{ 0x7258, 0xE79C9E },
	{ 0x5879, 0xE79CA0 },
	{ 0x7A5F, 0xE79CA9 },
	{ 0x4F6F, 0xE79CB7 },
	{ 0x5942, 0xE79CB8 },
	{ 0x7052, 0xE79CBA },
	{ 0x6451, 0xE79CBC },
	{ 0x7337, 0xE79D80 },
	{ 0x7A60, 0xE79D8D },
	{ 0x6F6C, 0xE79D9B },
	{ 0x6232, 0xE79DA1 },
	{ 0x543D, 0xE79DA3 },
	{ 0x594E, 0xE79DA6 },
	{ 0x7462, 0xE79DAB },
	{ 0x5429, 0xE79DB9 },
	{ 0x4D42, 0xE79DBE },
	{ 0x675A, 0xE79DBF },
	{ 0x7259, 0xE79E8B },
	{ 0x592A, 0xE79E91 },
	{ 0x583E, 0xE79E9E },
	{ 0x5C2D, 0xE79EA5 },
	{ 0x626B, 0xE79EAC },
	{ 0x567C, 0xE79EAD },
	{ 0x4A79, 0xE79EB0 },
	{ 0x545A, 0xE79EB3 },
	{ 0x7457, 0xE79EBB },
	{ 0x4C21, 0xE79EBC },
	{ 0x4F3A, 0xE79EBF },
	{ 0x7538, 0xE79F97 },
	{ 0x5943, 0xE79F9B },
	{ 0x5068, 0xE79F9C },
	{ 0x6345, 0xE79FA2 },
	{ 0x6B78, 0xE79FA3 },
	{ 0x7231, 0xE79FA5 },
	{ 0x4F3B, 0xE79FA9 },
	{ 0x532D, 0xE79FAD },
	{ 0x6861, 0xE79FAE },
	{ 0x4E6C, 0xE79FAF },
	{ 0x6034, 0xE79FB3 },
	{ 0x5E63, 0xE7A082 },
	{ 0x5D77, 0xE7A092 },
	{ 0x7232, 0xE7A0A5 },
	{ 0x7376, 0xE7A0A6 },
	{ 0x765B, 0xE7A0A7 },
	{ 0x577E, 0xE7A0AC },
	{ 0x785F, 0xE7A0B2 },
	{ 0x7772, 0xE7A0B4 },
	{ 0x5029, 0xE7A185 },
	{ 0x665A, 0xE7A18F },
	{ 0x7526, 0xE7A19D },
	{ 0x573C, 0xE7A1AB },
	{ 0x4C63, 0xE7A1AC },
	{ 0x665B, 0xE7A1AF },
	{ 0x5D5D, 0xE7A1BC },
	{ 0x5133, 0xE7A281 },
	{ 0x6F6D, 0xE7A287 },
	{ 0x565E, 0xE7A28C },
	{ 0x6474, 0xE7A28D },
	{ 0x616F, 0xE7A28E },
	{ 0x5D78, 0xE7A291 },
	{ 0x684F, 0xE7A297 },
	{ 0x4A65, 0xE7A2A3 },
	{ 0x5C21, 0xE7A2A7 },
	{ 0x6035, 0xE7A2A9 },
	{ 0x7C2C, 0xE7A2BA },
	{ 0x7C2D, 0xE7A2BB },
	{ 0x5827, 0xE7A2BC },
	{ 0x6D38, 0xE7A381 },
	{ 0x5B36, 0xE7A385 },
	{ 0x5670, 0xE7A38A },
	{ 0x732F, 0xE7A38B },
	{ 0x4D25, 0xE7A38E },
	{ 0x5A71, 0xE7A390 },
	{ 0x5828, 0xE7A3A8 },
	{ 0x4C64, 0xE7A3AC },
	{ 0x5134, 0xE7A3AF },
	{ 0x4A58, 0xE7A3B5 },
	{ 0x5A72, 0xE7A3BB },
	{ 0x7527, 0xE7A481 },
	{ 0x7528, 0xE7A48E },
	{ 0x6626, 0xE7A496 },
	{ 0x556C, 0xE7A4AA },
	{ 0x5578, 0xE7A4AB },
	{ 0x5A73, 0xE7A4AC },
	{ 0x6346, 0xE7A4BA },
	{ 0x5E64, 0xE7A4BE },
	{ 0x5E65, 0xE7A580 },
	{ 0x5135, 0xE7A581 },
	{ 0x5136, 0xE7A587 },
	{ 0x5137, 0xE7A588 },
	{ 0x7233, 0xE7A589 },
	{ 0x695E, 0xE7A590 },
	{ 0x7053, 0xE7A596 },
	{ 0x7234, 0xE7A597 },
	{ 0x7054, 0xE7A59A },
	{ 0x4B64, 0xE7A59B },
	{ 0x7B54, 0xE7A59C },
	{ 0x7566, 0xE7A59D },
	{ 0x636A, 0xE7A59E },
	{ 0x5E66, 0xE7A5A0 },
	{ 0x5F54, 0xE7A5A5 },
	{ 0x7879, 0xE7A5A8 },
	{ 0x702E, 0xE7A5AD },
	{ 0x5138, 0xE7A5BA },
	{ 0x565F, 0xE7A5BF },
	{ 0x5057, 0xE7A681 },
	{ 0x7C21, 0xE7A68D },
	{ 0x6F6E, 0xE7A68E },
	{ 0x5C58, 0xE7A68F },
	{ 0x695F, 0xE7A691 },
	{ 0x655D, 0xE7A6A6 },
	{ 0x7D7B, 0xE7A6A7 },
	{ 0x6049, 0xE7A6AA },
	{ 0x5649, 0xE7A6AE },
	{ 0x542A, 0xE7A6B1 },
	{ 0x654C, 0xE7A6B3 },
	{ 0x6960, 0xE7A6B9 },
	{ 0x5058, 0xE7A6BD },
	{ 0x7C22, 0xE7A6BE },
	{ 0x543E, 0xE7A6BF },
	{ 0x6233, 0xE7A780 },
	{ 0x5E67, 0xE7A781 },
	{ 0x5C3C, 0xE7A789 },
	{ 0x5236, 0xE7A78A },
	{ 0x7555, 0xE7A78B },
	{ 0x4E21, 0xE7A791 },
	{ 0x7529, 0xE7A792 },
	{ 0x5D79, 0xE7A795 },
	{ 0x5D7A, 0xE7A798 },
	{ 0x7055, 0xE7A79F },
	{ 0x765F, 0xE7A7A4 },
	{ 0x725A, 0xE7A7A6 },
	{ 0x646B, 0xE7A7A7 },
	{ 0x7271, 0xE7A7A9 },
	{ 0x6C39, 0xE7A7BB },
	{ 0x7D7C, 0xE7A880 },
	{ 0x612A, 0xE7A885 },
	{ 0x4A59, 0xE7A888 },
	{ 0x6F6F, 0xE7A88B },
	{ 0x752A, 0xE7A88D },
	{ 0x6C79, 0xE7A894 },
	{ 0x782D, 0xE7A897 },
	{ 0x7242, 0xE7A899 },
	{ 0x7643, 0xE7A89A },
	{ 0x5752, 0xE7A89C },
	{ 0x7922, 0xE7A89F },
	{ 0x7056, 0xE7A8A0 },
	{ 0x707A, 0xE7A8AE },
	{ 0x7660, 0xE7A8B1 },
	{ 0x6973, 0xE7A8B6 },
	{ 0x7243, 0xE7A8B7 },
	{ 0x542B, 0xE7A8BB },
	{ 0x4A33, 0xE7A8BC },
	{ 0x4D26, 0xE7A8BD },
	{ 0x4D43, 0xE7A8BF },
	{ 0x4D5A, 0xE7A980 },
	{ 0x594F, 0xE7A986 },
	{ 0x7644, 0xE7A989 },
	{ 0x6E5D, 0xE7A98D },
	{ 0x6744, 0xE7A98E },
	{ 0x6234, 0xE7A997 },
	{ 0x5F62, 0xE7A9A1 },
	{ 0x675B, 0xE7A9A2 },
	{ 0x6831, 0xE7A9A9 },
	{ 0x7C2E, 0xE7A9AB },
	{ 0x654D, 0xE7A9B0 },
	{ 0x7A6B, 0xE7A9B4 },
	{ 0x4F3C, 0xE7A9B6 },
	{ 0x4F62, 0xE7A9B9 },
	{ 0x4D76, 0xE7A9BA },
	{ 0x6F70, 0xE7A9BD },
	{ 0x743E, 0xE7A9BF },
	{ 0x544D, 0xE7AA81 },
	{ 0x7338, 0xE7AA84 },
	{ 0x6921, 0xE7AA88 },
	{ 0x7272, 0xE7AA92 },
	{ 0x736B, 0xE7AA93 },
	{ 0x7057, 0xE7AA95 },
	{ 0x4F57, 0xE7AA98 },
	{ 0x4F5F, 0xE7AA9F },
	{ 0x6840, 0xE7AAA9 },
	{ 0x6841, 0xE7AAAA },
	{ 0x4F63, 0xE7AAAE },
	{ 0x6922, 0xE7AAAF },
	{ 0x502A, 0xE7AABA },
	{ 0x7341, 0xE7AB84 },
	{ 0x502B, 0xE7AB85 },
	{ 0x5464, 0xE7AB87 },
	{ 0x6F3C, 0xE7AB8A },
	{ 0x5821, 0xE7AB8B },
	{ 0x595F, 0xE7AB97 },
	{ 0x7357, 0xE7AB99 },
	{ 0x5C3D, 0xE7AB9D },
	{ 0x4C65, 0xE7AB9F },
	{ 0x6D71, 0xE7ABA0 },
	{ 0x7162, 0xE7ABA3 },
	{ 0x545B, 0xE7ABA5 },
	{ 0x6235, 0xE7ABAA },
	{ 0x4A66, 0xE7ABAD },
	{ 0x532E, 0xE7ABAF },
	{ 0x4C66, 0xE7ABB6 },
	{ 0x7153, 0xE7ABB9 },
	{ 0x7567, 0xE7ABBA },
	{ 0x4A5A, 0xE7ABBF },
	{ 0x7B6E, 0xE7AC8F },
	{ 0x6145, 0xE7AC91 },
	{ 0x5F69, 0xE7AC99 },
	{ 0x6E5E, 0xE7AC9B },
	{ 0x7742, 0xE7AC9E },
	{ 0x5822, 0xE7ACA0 },
	{ 0x5D2C, 0xE7ACA6 },
	{ 0x702F, 0xE7ACAC },
	{ 0x563D, 0xE7ACAD },
	{ 0x612B, 0xE7ACB9 },
	{ 0x7936, 0xE7AD86 },
	{ 0x5475, 0xE7AD89 },
	{ 0x5049, 0xE7AD8B },
	{ 0x6F27, 0xE7AD8C },
	{ 0x626C, 0xE7AD8D },
	{ 0x5B6A, 0xE7AD8F },
	{ 0x4E4C, 0xE7AD90 },
	{ 0x7568, 0xE7AD91 },
	{ 0x7755, 0xE7AD92 },
	{ 0x534D, 0xE7AD94 },
	{ 0x737E, 0xE7AD96 },
	{ 0x5035, 0xE7ADA0 },
	{ 0x607E, 0xE7ADAC },
	{ 0x5F7B, 0xE7ADAE },
	{ 0x665D, 0xE7ADB5 },
	{ 0x6824, 0xE7ADBD },
	{ 0x4B4D, 0xE7AE87 },
	{ 0x6F28, 0xE7AE8B },
	{ 0x6E34, 0xE7AE8F },
	{ 0x5A58, 0xE7AE94 },
	{ 0x5139, 0xE7AE95 },
	{ 0x5F29, 0xE7AE97 },
	{ 0x7330, 0xE7AE9A },
	{ 0x4C44, 0xE7AE9D },
	{ 0x4E37, 0xE7AEA1 },
	{ 0x6F29, 0xE7AEAD },
	{ 0x5F55, 0xE7AEB1 },
	{ 0x6D57, 0xE7AEB4 },
	{ 0x6E46, 0xE7AEB8 },
	{ 0x6F3D, 0xE7AF80 },
	{ 0x7C56, 0xE7AF81 },
	{ 0x5B74, 0xE7AF84 },
	{ 0x6F2A, 0xE7AF86 },
	{ 0x7839, 0xE7AF87 },
	{ 0x7569, 0xE7AF89 },
	{ 0x6359, 0xE7AF92 },
	{ 0x6146, 0xE7AFA0 },
	{ 0x543F, 0xE7AFA4 },
	{ 0x5E68, 0xE7AFA9 },
	{ 0x706A, 0xE7B087 },
	{ 0x7342, 0xE7B092 },
	{ 0x532F, 0xE7B09E },
	{ 0x4A5B, 0xE7B0A1 },
	{ 0x7C57, 0xE7B0A7 },
	{ 0x6D58, 0xE7B0AA },
	{ 0x6147, 0xE7B0AB },
	{ 0x7458, 0xE7B0BD },
	{ 0x5633, 0xE7B0BE },
	{ 0x5D2D, 0xE7B0BF },
	{ 0x553E, 0xE7B183 },
	{ 0x7143, 0xE7B18C },
	{ 0x6E5F, 0xE7B18D },
	{ 0x566B, 0xE7B1A0 },
	{ 0x7459, 0xE7B1A4 },
	{ 0x5766, 0xE7B1AC },
	{ 0x5A37, 0xE7B1B3 },
	{ 0x5D7B, 0xE7B283 },
	{ 0x5D4F, 0xE7B289 },
	{ 0x5823, 0xE7B292 },
	{ 0x5A59, 0xE7B295 },
	{ 0x7058, 0xE7B297 },
	{ 0x6F44, 0xE7B298 },
	{ 0x6158, 0xE7B29F },
	{ 0x7154, 0xE7B2A5 },
	{ 0x6D72, 0xE7B2A7 },
	{ 0x555B, 0xE7B2AE },
	{ 0x555C, 0xE7B2B1 },
	{ 0x7344, 0xE7B2B2 },
	{ 0x4B57, 0xE7B2B3 },
	{ 0x6236, 0xE7B2B9 },
	{ 0x6F71, 0xE7B2BE },
	{ 0x7B55, 0xE7B38A },
	{ 0x5358, 0xE7B396 },
	{ 0x5D50, 0xE7B39E },
	{ 0x7059, 0xE7B39F },
	{ 0x4B33, 0xE7B3A0 },
	{ 0x555D, 0xE7B3A7 },
	{ 0x4D27, 0xE7B3BB },
	{ 0x502C, 0xE7B3BE },
	{ 0x513A, 0xE7B480 },
	{ 0x7144, 0xE7B482 },
	{ 0x6533, 0xE7B484 },
	{ 0x7B75, 0xE7B485 },
	{ 0x6961, 0xE7B486 },
	{ 0x7D60, 0xE7B487 },
	{ 0x7C3C, 0xE7B488 },
	{ 0x5A22, 0xE7B48A },
	{ 0x5A23, 0xE7B48B },
	{ 0x5221, 0xE7B48D },
	{ 0x526F, 0xE7B490 },
	{ 0x626D, 0xE7B494 },
	{ 0x5E69, 0xE7B497 },
	{ 0x4E5C, 0xE7B498 },
	{ 0x7235, 0xE7B499 },
	{ 0x5064, 0xE7B49A },
	{ 0x5D51, 0xE7B49B },
	{ 0x6148, 0xE7B4A0 },
	{ 0x5B37, 0xE7B4A1 },
	{ 0x5F63, 0xE7B4A2 },
	{ 0x6D39, 0xE7B4AB },
	{ 0x7145, 0xE7B4AC },
	{ 0x734F, 0xE7B4AE },
	{ 0x572B, 0xE7B4AF },
	{ 0x612C, 0xE7B4B0 },
	{ 0x636B, 0xE7B4B3 },
	{ 0x6E47, 0xE7B4B5 },
	{ 0x6149, 0xE7B4B9 },
	{ 0x4A7A, 0xE7B4BA },
	{ 0x707B, 0xE7B582 },
	{ 0x7A61, 0xE7B583 },
	{ 0x705A, 0xE7B584 },
	{ 0x4C67, 0xE7B585 },
	{ 0x5A74, 0xE7B586 },
	{ 0x4C3F, 0xE7B590 },
	{ 0x4E6D, 0xE7B59E },
	{ 0x5529, 0xE7B5A1 },
	{ 0x7A62, 0xE7B5A2 },
	{ 0x5065, 0xE7B5A6 },
	{ 0x6B56, 0xE7B5A8 },
	{ 0x6C5F, 0xE7B5AA },
	{ 0x5F7C, 0xE7B5AE },
	{ 0x7756, 0xE7B5B1 },
	{ 0x5E6A, 0xE7B5B2 },
	{ 0x4B34, 0xE7B5B3 },
	{ 0x6F3E, 0xE7B5B6 },
	{ 0x4C35, 0xE7B5B9 },
	{ 0x4F3D, 0xE7B5BF },
	{ 0x6F72, 0xE7B68E },
	{ 0x6237, 0xE7B68F },
	{ 0x4C68, 0xE7B693 },
	{ 0x707C, 0xE7B69C },
	{ 0x5660, 0xE7B6A0 },
	{ 0x7146, 0xE7B6A2 },
	{ 0x6238, 0xE7B6AC },
	{ 0x6B2B, 0xE7B6AD },
	{ 0x4B35, 0xE7B6B1 },
	{ 0x5851, 0xE7B6B2 },
	{ 0x744E, 0xE7B6B4 },
	{ 0x7377, 0xE7B6B5 },
	{ 0x5746, 0xE7B6B8 },
	{ 0x513B, 0xE7B6BA },
	{ 0x772A, 0xE7B6BB },
	{ 0x6D4A, 0xE7B6BD },
	{ 0x5753, 0xE7B6BE },
	{ 0x587A, 0xE7B6BF },
	{ 0x7645, 0xE7B787 },
	{ 0x514C, 0xE7B78A },
	{ 0x5D7C, 0xE7B78B },
	{ 0x5F7D, 0xE7B796 },
	{ 0x7965, 0xE7B798 },
	{ 0x604A, 0xE7B79A },
	{ 0x727D, 0xE7B79D },
	{ 0x5330, 0xE7B79E },
	{ 0x7473, 0xE7B7A0 },
	{ 0x5A49, 0xE7B7A1 },
	{ 0x665E, 0xE7B7A3 },
	{ 0x783A, 0xE7B7A8 },
	{ 0x6850, 0xE7B7A9 },
	{ 0x587B, 0xE7B7AC },
	{ 0x6A55, 0xE7B7AF },
	{ 0x5623, 0xE7B7B4 },
	{ 0x7646, 0xE7B7BB },
	{ 0x725B, 0xE7B889 },
	{ 0x647C, 0xE7B88A },
	{ 0x6832, 0xE7B895 },
	{ 0x5A5A, 0xE7B89B },
	{ 0x725C, 0xE7B89D },
	{ 0x7B56, 0xE7B89E },
	{ 0x6932, 0xE7B89F },
	{ 0x6E2D, 0xE7B8A1 },
	{ 0x7A63, 0xE7B8A3 },
	{ 0x5C6E, 0xE7B8AB },
	{ 0x756A, 0xE7B8AE },
	{ 0x6660, 0xE7B8AF },
	{ 0x707D, 0xE7B8B1 },
	{ 0x572C, 0xE7B8B7 },
	{ 0x7545, 0xE7B8BD },
	{ 0x6E60, 0xE7B8BE },
	{ 0x5B65, 0xE7B981 },
	{ 0x5D5E, 0xE7B983 },
	{ 0x5970, 0xE7B986 },
	{ 0x6923, 0xE7B987 },
	{ 0x7179, 0xE7B992 },
	{ 0x7244, 0xE7B994 },
	{ 0x604B, 0xE7B995 },
	{ 0x6924, 0xE7B99E },
	{ 0x6239, 0xE7B9A1 },
	{ 0x6331, 0xE7B9A9 },
	{ 0x7C6B, 0xE7B9AA },
	{ 0x4D28, 0xE7B9AB },
	{ 0x4C36, 0xE7B9AD },
	{ 0x705B, 0xE7B9B0 },
	{ 0x663A, 0xE7B9B9 },
	{ 0x4D29, 0xE7B9BC },
	{ 0x7343, 0xE7BA82 },
	{ 0x6159, 0xE7BA8C },
	{ 0x6F2B, 0xE7BA8F },
	{ 0x6745, 0xE7BA93 },
	{ 0x6069, 0xE7BA96 },
	{ 0x7345, 0xE7BA98 },
	{ 0x5440, 0xE7BA9B },
	{ 0x553F, 0xE7BA9C },
	{ 0x5D2E, 0xE7BCB6 },
	{ 0x797C, 0xE7BCB8 },
	{ 0x4C40, 0xE7BCBA },
	{ 0x6522, 0xE7BD8C },
	{ 0x4E38, 0xE7BD90 },
	{ 0x5852, 0xE7BD94 },
	{ 0x7956, 0xE7BD95 },
	{ 0x712A, 0xE7BDAA },
	{ 0x4E51, 0xE7BDAB },
	{ 0x7647, 0xE7BDAE },
	{ 0x5B6B, 0xE7BDB0 },
	{ 0x5F7E, 0xE7BDB2 },
	{ 0x5861, 0xE7BDB5 },
	{ 0x7773, 0xE7BDB7 },
	{ 0x5767, 0xE7BDB9 },
	{ 0x547E, 0xE7BE85 },
	{ 0x513C, 0xE7BE88 },
	{ 0x654F, 0xE7BE8A },
	{ 0x4B36, 0xE7BE8C },
	{ 0x5A38, 0xE7BE8E },
	{ 0x4D44, 0xE7BE94 },
	{ 0x563E, 0xE7BE9A },
	{ 0x623A, 0xE7BE9E },
	{ 0x4F58, 0xE7BEA4 },
	{ 0x604C, 0xE7BEA8 },
	{ 0x6B79, 0xE7BEA9 },
	{ 0x7D7D, 0xE7BEB2 },
	{ 0x5768, 0xE7BEB8 },
	{ 0x4B58, 0xE7BEB9 },
	{ 0x6962, 0xE7BEBD },
	{ 0x683A, 0xE7BF81 },
	{ 0x6347, 0xE7BF85 },
	{ 0x6C4D, 0xE7BF8A },
	{ 0x6C4E, 0xE7BF8C },
	{ 0x563F, 0xE7BF8E },
	{ 0x6327, 0xE7BF92 },
	{ 0x5F56, 0xE7BF94 },
	{ 0x7D68, 0xE7BF95 },
	{ 0x6E61, 0xE7BF9F },
	{ 0x7628, 0xE7BFA0 },
	{ 0x5D7D, 0xE7BFA1 },
	{ 0x783B, 0xE7BFA9 },
	{ 0x6851, 0xE7BFAB },
	{ 0x7957, 0xE7BFB0 },
	{ 0x4E6E, 0xE7BFB9 },
	{ 0x6C4F, 0xE7BFBC },
	{ 0x6925, 0xE88080 },
	{ 0x5655, 0xE88081 },
	{ 0x4D45, 0xE88083 },
	{ 0x6D3A, 0xE88085 },
	{ 0x513D, 0xE88086 },
	{ 0x4F3E, 0xE88089 },
	{ 0x6C3B, 0xE8808C },
	{ 0x5231, 0xE88090 },
	{ 0x4C69, 0xE88095 },
	{ 0x5944, 0xE88097 },
	{ 0x697C, 0xE88098 },
	{ 0x513E, 0xE880AD },
	{ 0x6C3C, 0xE880B3 },
	{ 0x652D, 0xE880B6 },
	{ 0x7730, 0xE880BD },
	{ 0x4C6A, 0xE880BF },
	{ 0x5344, 0xE88183 },
	{ 0x5640, 0xE88186 },
	{ 0x567D, 0xE8818A },
	{ 0x6121, 0xE88196 },
	{ 0x5E3D, 0xE88198 },
	{ 0x7629, 0xE8819A },
	{ 0x5A24, 0xE8819E },
	{ 0x5624, 0xE881AF },
	{ 0x7546, 0xE881B0 },
	{ 0x6122, 0xE881B2 },
	{ 0x6946, 0xE881B3 },
	{ 0x7245, 0xE881B7 },
	{ 0x7469, 0xE881BD },
	{ 0x566C, 0xE881BE },
	{ 0x6B53, 0xE881BF },
	{ 0x6C3D, 0xE88284 },
	{ 0x625C, 0xE88285 },
	{ 0x5E6B, 0xE88286 },
	{ 0x705C, 0xE88287 },
	{ 0x6B3F, 0xE88289 },
	{ 0x574E, 0xE8828B },
	{ 0x513F, 0xE8828C },
	{ 0x752B, 0xE88296 },
	{ 0x797D, 0xE8829B },
	{ 0x4A5C, 0xE8829D },
	{ 0x4D46, 0xE882A1 },
	{ 0x7236, 0xE882A2 },
	{ 0x5D7E, 0xE882A5 },
	{ 0x4C37, 0xE882A9 },
	{ 0x5B38, 0xE882AA },
	{ 0x5069, 0xE882AF },
	{ 0x4E5D, 0xE882B1 },
	{ 0x6B40, 0xE882B2 },
	{ 0x7D22, 0xE882B4 },
	{ 0x784B, 0xE882BA },
	{ 0x6A56, 0xE88383 },
	{ 0x7130, 0xE88384 },
	{ 0x5B4E, 0xE8838C },
	{ 0x7743, 0xE8838E },
	{ 0x5B4F, 0xE8839A },
	{ 0x4B24, 0xE8839B },
	{ 0x7860, 0xE8839E },
	{ 0x7B57, 0xE883A1 },
	{ 0x6B4A, 0xE883A4 },
	{ 0x6021, 0xE883A5 },
	{ 0x4E4D, 0xE883B1 },
	{ 0x545C, 0xE883B4 },
	{ 0x7D58, 0xE883B8 },
	{ 0x5276, 0xE883BD },
	{ 0x7237, 0xE88482 },
	{ 0x7A76, 0xE88485 },
	{ 0x762A, 0xE88486 },
	{ 0x7A77, 0xE88487 },
	{ 0x5866, 0xE88488 },
	{ 0x7431, 0xE8848A },
	{ 0x6852, 0xE88498 },
	{ 0x4A45, 0xE8849A },
	{ 0x4C6B, 0xE8849B },
	{ 0x626E, 0xE884A3 },
	{ 0x623B, 0xE884A9 },
	{ 0x772D, 0xE884AB },
	{ 0x7861, 0xE884AF },
	{ 0x736C, 0xE884B9 },
	{ 0x5E21, 0xE884BE },
	{ 0x647D, 0xE8858B },
	{ 0x636C, 0xE8858E },
	{ 0x5D2F, 0xE88590 },
	{ 0x5D30, 0xE88591 },
	{ 0x4B37, 0xE88594 },
	{ 0x6853, 0xE88595 },
	{ 0x6123, 0xE885A5 },
	{ 0x5260, 0xE885A6 },
	{ 0x707E, 0xE885AB },
	{ 0x6926, 0xE885B0 },
	{ 0x4B72, 0xE885B1 },
	{ 0x6D73, 0xE885B8 },
	{ 0x5C59, 0xE885B9 },
	{ 0x604D, 0xE885BA },
	{ 0x775A, 0xE885BF },
	{ 0x5B39, 0xE88680 },
	{ 0x4C2E, 0xE88688 },
	{ 0x5A5B, 0xE8868A },
	{ 0x4D47, 0xE8868F },
	{ 0x5D31, 0xE8869A },
	{ 0x582F, 0xE8869C },
	{ 0x6323, 0xE8869D },
	{ 0x4E6F, 0xE886A0 },
	{ 0x7273, 0xE886A3 },
	{ 0x7833, 0xE886A8 },
	{ 0x604E, 0xE886B3 },
	{ 0x757D, 0xE886B5 },
	{ 0x6B6C, 0xE886BA },
	{ 0x5345, 0xE886BD },
	{ 0x7C6C, 0xE886BE },
	{ 0x525B, 0xE886BF },
	{ 0x546B, 0xE88780 },
	{ 0x5E22, 0xE88782 },
	{ 0x6566, 0xE88786 },
	{ 0x7030, 0xE8878D },
	{ 0x5544, 0xE88798 },
	{ 0x6D74, 0xE8879F },
	{ 0x636D, 0xE887A3 },
	{ 0x6842, 0xE887A5 },
	{ 0x6D75, 0xE887A7 },
	{ 0x577C, 0xE887A8 },
	{ 0x6D3B, 0xE887AA },
	{ 0x762B, 0xE887AD },
	{ 0x7238, 0xE887B3 },
	{ 0x7648, 0xE887B4 },
	{ 0x5366, 0xE887BA },
	{ 0x725D, 0xE887BB },
	{ 0x4F3F, 0xE887BC },
	{ 0x6B2C, 0xE887BE },
	{ 0x4F40, 0xE88885 },
	{ 0x6628, 0xE88887 },
	{ 0x7D69, 0xE88888 },
	{ 0x4F41, 0xE8888A },
	{ 0x605F, 0xE8888C },
	{ 0x5E6C, 0xE8888D },
	{ 0x6022, 0xE88892 },
	{ 0x743F, 0xE8889B },
	{ 0x626F, 0xE8889C },
	{ 0x5971, 0xE8889E },
	{ 0x7147, 0xE8889F },
	{ 0x4B38, 0xE888A1 },
	{ 0x797E, 0xE888AA },
	{ 0x5B3A, 0xE888AB },
	{ 0x5A75, 0xE888AC },
	{ 0x766C, 0xE888B5 },
	{ 0x5A5C, 0xE888B6 },
	{ 0x7A64, 0xE888B7 },
	{ 0x604F, 0xE888B9 },
	{ 0x5D32, 0xE88980 },
	{ 0x6629, 0xE88985 },
	{ 0x6F73, 0xE88987 },
	{ 0x736D, 0xE88999 },
	{ 0x6B7A, 0xE889A4 },
	{ 0x7966, 0xE889A6 },
	{ 0x4A5D, 0xE889AE },
	{ 0x555E, 0xE889AF },
	{ 0x4A5E, 0xE889B1 },
	{ 0x5F64, 0xE889B2 },
	{ 0x667D, 0xE889B6 },
	{ 0x752C, 0xE889B8 },
	{ 0x6475, 0xE889BE },
	{ 0x6963, 0xE88A8B },
	{ 0x6D4B, 0xE88A8D },
	{ 0x4F64, 0xE88A8E },
	{ 0x5853, 0xE88A92 },
	{ 0x5D33, 0xE88A99 },
	{ 0x546C, 0xE88A9A },
	{ 0x7239, 0xE88A9D },
	{ 0x5F37, 0xE88A9F },
	{ 0x4B4E, 0xE88AA5 },
	{ 0x7B58, 0xE88AA6 },
	{ 0x5059, 0xE88AA9 },
	{ 0x5D52, 0xE88AAC },
	{ 0x7774, 0xE88AAD },
	{ 0x675C, 0xE88AAE },
	{ 0x6425, 0xE88AAF },
	{ 0x7C23, 0xE88AB1 },
	{ 0x5B3B, 0xE88AB3 },
	{ 0x723A, 0xE88AB7 },
	{ 0x697D, 0xE88AB8 },
	{ 0x504A, 0xE88AB9 },
	{ 0x7556, 0xE88ABB },
	{ 0x5945, 0xE88ABC },
	{ 0x6434, 0xE88ABD },
	{ 0x6D27, 0xE88ABF },
	{ 0x6A3D, 0xE88B91 },
	{ 0x667E, 0xE88B92 },
	{ 0x7744, 0xE88B94 },
	{ 0x752D, 0xE88B95 },
	{ 0x5960, 0xE88B97 },
	{ 0x4A34, 0xE88B9B },
	{ 0x7862, 0xE88B9E },
	{ 0x4F42, 0xE88B9F },
	{ 0x6C3E, 0xE88BA1 },
	{ 0x6534, 0xE88BA5 },
	{ 0x4D48, 0xE88BA6 },
	{ 0x6E48, 0xE88BA7 },
	{ 0x6748, 0xE88BB1 },
	{ 0x4D49, 0xE88BBD },
	{ 0x7937, 0xE88BBE },
	{ 0x7168, 0xE88C81 },
	{ 0x5972, 0xE88C82 },
	{ 0x5B75, 0xE88C83 },
	{ 0x4A35, 0xE88C84 },
	{ 0x5946, 0xE88C85 },
	{ 0x5849, 0xE88C89 },
	{ 0x592B, 0xE88C97 },
	{ 0x6D3C, 0xE88CA8 },
	{ 0x5854, 0xE88CAB },
	{ 0x5C5A, 0xE88CAF },
	{ 0x623C, 0xE88CB1 },
	{ 0x7C6D, 0xE88CB4 },
	{ 0x6C60, 0xE88CB5 },
	{ 0x527E, 0xE88CB6 },
	{ 0x6947, 0xE88CB8 },
	{ 0x662A, 0xE88CB9 },
	{ 0x6270, 0xE88D80 },
	{ 0x7A3B, 0xE88D87 },
	{ 0x752E, 0xE88D89 },
	{ 0x7B2A, 0xE88D8A },
	{ 0x6C7B, 0xE88D8F },
	{ 0x6C3F, 0xE88D91 },
	{ 0x7C58, 0xE88D92 },
	{ 0x5465, 0xE88DB3 },
	{ 0x7943, 0xE88DB7 },
	{ 0x6E62, 0xE88DBB },
	{ 0x5769, 0xE88E89 },
	{ 0x6D76, 0xE88E8A },
	{ 0x5E6D, 0xE88E8E },
	{ 0x4C6C, 0xE88E96 },
	{ 0x636E, 0xE88E98 },
	{ 0x6854, 0xE88E9E },
	{ 0x7A78, 0xE88EA2 },
	{ 0x5D34, 0xE88EA9 },
	{ 0x6435, 0xE88EAA },
	{ 0x5830, 0xE88EAB },
	{ 0x5855, 0xE88EBD },
	{ 0x746A, 0xE88F81 },
	{ 0x4E39, 0xE88F85 },
	{ 0x5661, 0xE88F89 },
	{ 0x4F52, 0xE88F8A },
	{ 0x5036, 0xE88F8C },
	{ 0x4E22, 0xE88F93 },
	{ 0x736E, 0xE88F96 },
	{ 0x7378, 0xE88F9C },
	{ 0x5C4C, 0xE88FA9 },
	{ 0x504B, 0xE88FAB },
	{ 0x7C24, 0xE88FAF },
	{ 0x4D4A, 0xE88FB0 },
	{ 0x5754, 0xE88FB1 },
	{ 0x5E23, 0xE88FB2 },
	{ 0x6460, 0xE88FB4 },
	{ 0x6E49, 0xE88FB9 },
	{ 0x625D, 0xE88FBD },
	{ 0x757E, 0xE89083 },
	{ 0x542C, 0xE89084 },
	{ 0x5551, 0xE8908A },
	{ 0x5870, 0xE8908C },
	{ 0x7843, 0xE8908D },
	{ 0x6A57, 0xE8908E },
	{ 0x7557, 0xE890A9 },
	{ 0x583F, 0xE890AC },
	{ 0x7D40, 0xE890B1 },
	{ 0x6B2D, 0xE890B8 },
	{ 0x552A, 0xE890BD },
	{ 0x6728, 0xE89189 },
	{ 0x6E4A, 0xE89197 },
	{ 0x4A67, 0xE8919B },
	{ 0x7863, 0xE891A1 },
	{ 0x545D, 0xE891A3 },
	{ 0x6A58, 0xE891A6 },
	{ 0x7B59, 0xE891AB },
	{ 0x6D77, 0xE891AC },
	{ 0x6535, 0xE891AF },
	{ 0x502D, 0xE891B5 },
	{ 0x7171, 0xE891BA },
	{ 0x623D, 0xE89290 },
	{ 0x6348, 0xE89294 },
	{ 0x5955, 0xE89299 },
	{ 0x5F2A, 0xE8929C },
	{ 0x5B3C, 0xE892A1 },
	{ 0x7864, 0xE892B2 },
	{ 0x717A, 0xE892B8 },
	{ 0x6536, 0xE892BB },
	{ 0x736F, 0xE892BC },
	{ 0x7B5A, 0xE892BF },
	{ 0x6160, 0xE89380 },
	{ 0x592C, 0xE89382 },
	{ 0x756B, 0xE89384 },
	{ 0x6036, 0xE89386 },
	{ 0x6948, 0xE89389 },
	{ 0x4B4F, 0xE8938B },
	{ 0x6349, 0xE8938D },
	{ 0x5E6E, 0xE89391 },
	{ 0x623E, 0xE8939A },
	{ 0x5C6F, 0xE893AC },
	{ 0x5625, 0xE893AE },
	{ 0x6271, 0xE893B4 },
	{ 0x567E, 0xE893BC },
	{ 0x5921, 0xE89491 },
	{ 0x5840, 0xE89493 },
	{ 0x5C5B, 0xE89494 },
	{ 0x6D3D, 0xE89497 },
	{ 0x5F38, 0xE89498 },
	{ 0x6A25, 0xE8949A },
	{ 0x572D, 0xE8949E },
	{ 0x7379, 0xE894A1 },
	{ 0x6D78, 0xE894A3 },
	{ 0x7547, 0xE894A5 },
	{ 0x614A, 0xE894AC },
	{ 0x6B63, 0xE894AD },
	{ 0x725E, 0xE894AF },
	{ 0x784C, 0xE894BD },
	{ 0x6A59, 0xE894BF },
	{ 0x5346, 0xE89581 },
	{ 0x5B66, 0xE89583 },
	{ 0x752F, 0xE89589 },
	{ 0x4E70, 0xE8958E },
	{ 0x697E, 0xE89593 },
	{ 0x7B36, 0xE89599 },
	{ 0x6272, 0xE895A3 },
	{ 0x4F72, 0xE895A8 },
	{ 0x7739, 0xE895A9 },
	{ 0x5973, 0xE895AA },
	{ 0x614B, 0xE895AD },
	{ 0x5A5D, 0xE89684 },
	{ 0x5A39, 0xE89687 },
	{ 0x6B7B, 0xE8968F },
	{ 0x4B39, 0xE89691 },
	{ 0x6D79, 0xE89694 },
	{ 0x6060, 0xE8969B },
	{ 0x7440, 0xE896A6 },
	{ 0x7D3C, 0xE896A8 },
	{ 0x5F31, 0xE896A9 },
	{ 0x636F, 0xE896AA },
	{ 0x6023, 0xE896AF },
	{ 0x7D39, 0xE896B0 },
	{ 0x7031, 0xE896BA },
	{ 0x4D4B, 0xE89781 },
	{ 0x6D3E, 0xE89789 },
	{ 0x5540, 0xE8978D },
	{ 0x6370, 0xE8978E },
	{ 0x6D7A, 0xE8978F },
	{ 0x6964, 0xE89795 },
	{ 0x556D, 0xE8979C },
	{ 0x675D, 0xE8979D },
	{ 0x5476, 0xE897A4 },
	{ 0x6537, 0xE897A5 },
	{ 0x5B67, 0xE897A9 },
	{ 0x623F, 0xE897AA },
	{ 0x6E4B, 0xE897B7 },
	{ 0x5774, 0xE897BA },
	{ 0x705D, 0xE897BB },
	{ 0x4E2B, 0xE897BF },
	{ 0x675E, 0xE89882 },
	{ 0x5656, 0xE89886 },
	{ 0x614C, 0xE89887 },
	{ 0x6833, 0xE8988A },
	{ 0x656E, 0xE89896 },
	{ 0x5C22, 0xE89897 },
	{ 0x6050, 0xE8989A },
	{ 0x5535, 0xE898AD },
	{ 0x5521, 0xE898BF },
	{ 0x7B5B, 0xE8998E },
	{ 0x794B, 0xE89990 },
	{ 0x4B73, 0xE89994 },
	{ 0x7425, 0xE89995 },
	{ 0x7A48, 0xE8999B },
	{ 0x5657, 0xE8999C },
	{ 0x6965, 0xE8999E },
	{ 0x7B5C, 0xE8999F },
	{ 0x7D50, 0xE899A7 },
	{ 0x7B76, 0xE899B9 },
	{ 0x5A25, 0xE89A8A },
	{ 0x5B3D, 0xE89A8C },
	{ 0x6C62, 0xE89A93 },
	{ 0x4D77, 0xE89AA3 },
	{ 0x705E, 0xE89AA4 },
	{ 0x7649, 0xE89AA9 },
	{ 0x5E6F, 0xE89B87 },
	{ 0x5331, 0xE89B8B },
	{ 0x7C6E, 0xE89B94 },
	{ 0x6843, 0xE89B99 },
	{ 0x7148, 0xE89B9B },
	{ 0x4E71, 0xE89B9F },
	{ 0x796D, 0xE89BA4 },
	{ 0x7274, 0xE89BAD },
	{ 0x6436, 0xE89BBE },
	{ 0x7539, 0xE89C80 },
	{ 0x5C70, 0xE89C82 },
	{ 0x6371, 0xE89C83 },
	{ 0x6825, 0xE89C88 },
	{ 0x723B, 0xE89C98 },
	{ 0x5E24, 0xE89C9A },
	{ 0x5A4C, 0xE89C9C },
	{ 0x4A69, 0xE89D8E },
	{ 0x635A, 0xE89D95 },
	{ 0x7C59, 0xE89D97 },
	{ 0x6A5A, 0xE89D9F },
	{ 0x7944, 0xE89DA6 },
	{ 0x6324, 0xE89DA8 },
	{ 0x7B5D, 0xE89DB4 },
	{ 0x6F4A, 0xE89DB6 },
	{ 0x6844, 0xE89DB8 },
	{ 0x554C, 0xE89E82 },
	{ 0x6B57, 0xE89E8D },
	{ 0x592D, 0xE89E9F },
	{ 0x7B2B, 0xE89EA2 },
	{ 0x5359, 0xE89EB3 },
	{ 0x5522, 0xE89EBA },
	{ 0x765E, 0xE89F84 },
	{ 0x5A76, 0xE89FA0 },
	{ 0x6051, 0xE89FAC },
	{ 0x6928, 0xE89FAF },
	{ 0x7579, 0xE89FB2 },
	{ 0x7A2F, 0xE89FB9 },
	{ 0x6B7C, 0xE89FBB },
	{ 0x606A, 0xE89FBE },
	{ 0x6332, 0xE8A085 },
	{ 0x5545, 0xE8A09F },
	{ 0x7163, 0xE8A0A2 },
	{ 0x556E, 0xE8A0A3 },
	{ 0x4D4C, 0xE8A0B1 },
	{ 0x6D59, 0xE8A0B6 },
	{ 0x5841, 0xE8A0BB },
	{ 0x7A6C, 0xE8A180 },
	{ 0x716B, 0xE8A186 },
	{ 0x7A3C, 0xE8A18C },
	{ 0x6662, 0xE8A18D },
	{ 0x7A65, 0xE8A192 },
	{ 0x627A, 0xE8A193 },
	{ 0x4A36, 0xE8A197 },
	{ 0x6437, 0xE8A199 },
	{ 0x6A5B, 0xE8A19B },
	{ 0x757A, 0xE8A19D },
	{ 0x7B2C, 0xE8A1A1 },
	{ 0x4F43, 0xE8A1A2 },
	{ 0x6B7D, 0xE8A1A3 },
	{ 0x787A, 0xE8A1A8 },
	{ 0x5F39, 0xE8A1AB },
	{ 0x6171, 0xE8A1B0 },
	{ 0x5224, 0xE8A1B2 },
	{ 0x757B, 0xE8A1B7 },
	{ 0x505A, 0xE8A1BE },
	{ 0x505B, 0xE8A1BF },
	{ 0x6A3E, 0xE8A281 },
	{ 0x5931, 0xE8A282 },
	{ 0x4A37, 0xE8A288 },
	{ 0x5367, 0xE8A28B },
	{ 0x7865, 0xE8A28D },
	{ 0x5332, 0xE8A292 },
	{ 0x6240, 0xE8A296 },
	{ 0x725F, 0xE8A297 },
	{ 0x4D65, 0xE8A29E },
	{ 0x792C, 0xE8A2AB },
	{ 0x4D4D, 0xE8A2B4 },
	{ 0x6E2E, 0xE8A381 },
	{ 0x562E, 0xE8A382 },
	{ 0x576A, 0xE8A38F },
	{ 0x6760, 0xE8A394 },
	{ 0x6B2E, 0xE8A395 },
	{ 0x4F59, 0xE8A399 },
	{ 0x5C4D, 0xE8A39C },
	{ 0x6D7B, 0xE8A39D },
	{ 0x5E70, 0xE8A39F },
	{ 0x576B, 0xE8A3A1 },
	{ 0x5E25, 0xE8A3A8 },
	{ 0x5F57, 0xE8A3B3 },
	{ 0x5B50, 0xE8A3B4 },
	{ 0x5B51, 0xE8A3B5 },
	{ 0x5523, 0xE8A3B8 },
	{ 0x7032, 0xE8A3BD },
	{ 0x5C5C, 0xE8A487 },
	{ 0x4A68, 0xE8A490 },
	{ 0x7866, 0xE8A492 },
	{ 0x5C4E, 0xE8A493 },
	{ 0x6A5C, 0xE8A498 },
	{ 0x5B52, 0xE8A499 },
	{ 0x6933, 0xE8A4A5 },
	{ 0x775B, 0xE8A4AA },
	{ 0x6328, 0xE8A4B6 },
	{ 0x572E, 0xE8A4B8 },
	{ 0x6061, 0xE8A4BB },
	{ 0x4B3A, 0xE8A581 },
	{ 0x6551, 0xE8A584 },
	{ 0x505C, 0xE8A59F },
	{ 0x5541, 0xE8A5A4 },
	{ 0x584A, 0xE8A5AA },
	{ 0x6329, 0xE8A5B2 },
	{ 0x6024, 0xE8A5BF },
	{ 0x6929, 0xE8A681 },
	{ 0x5347, 0xE8A683 },
	{ 0x5C5D, 0xE8A686 },
	{ 0x782E, 0xE8A687 },
	{ 0x4C38, 0xE8A68B },
	{ 0x502E, 0xE8A68F },
	{ 0x5872, 0xE8A693 },
	{ 0x634A, 0xE8A696 },
	{ 0x4C2F, 0xE8A6A1 },
	{ 0x542D, 0xE8A6A9 },
	{ 0x7651, 0xE8A6AA },
	{ 0x504C, 0xE8A6B2 },
	{ 0x4A46, 0xE8A6BA },
	{ 0x5542, 0xE8A6BD },
	{ 0x4E3A, 0xE8A780 },
	{ 0x4A47, 0xE8A792 },
	{ 0x7A30, 0xE8A7A3 },
	{ 0x5F58, 0xE8A7B4 },
	{ 0x753A, 0xE8A7B8 },
	{ 0x656B, 0xE8A880 },
	{ 0x6F74, 0xE8A882 },
	{ 0x5D35, 0xE8A883 },
	{ 0x4D2A, 0xE8A888 },
	{ 0x6372, 0xE8A88A },
	{ 0x7B77, 0xE8A88C },
	{ 0x7750, 0xE8A88E },
	{ 0x7D3A, 0xE8A893 },
	{ 0x7D61, 0xE8A896 },
	{ 0x767E, 0xE8A897 },
	{ 0x5140, 0xE8A898 },
	{ 0x6845, 0xE8A89B },
	{ 0x6438, 0xE8A89D },
	{ 0x6168, 0xE8A89F },
	{ 0x4C41, 0xE8A8A3 },
	{ 0x526D, 0xE8A8A5 },
	{ 0x5B3E, 0xE8A8AA },
	{ 0x6062, 0xE8A8AD },
	{ 0x7A49, 0xE8A8B1 },
	{ 0x614D, 0xE8A8B4 },
	{ 0x4A38, 0xE8A8B6 },
	{ 0x7260, 0xE8A8BA },
	{ 0x7149, 0xE8A8BB },
	{ 0x5E71, 0xE8A990 },
	{ 0x705F, 0xE8A994 },
	{ 0x7844, 0xE8A995 },
	{ 0x6E4C, 0xE8A99B },
	{ 0x5E72, 0xE8A99E },
	{ 0x6749, 0xE8A9A0 },
	{ 0x6273, 0xE8A9A2 },
	{ 0x6761, 0xE8A9A3 },
	{ 0x634B, 0xE8A9A6 },
	{ 0x634C, 0xE8A9A9 },
	{ 0x4F78, 0xE8A9AD },
	{ 0x6F2C, 0xE8A9AE },
	{ 0x7D7E, 0xE8A9B0 },
	{ 0x7C25, 0xE8A9B1 },
	{ 0x7A31, 0xE8A9B2 },
	{ 0x5F59, 0xE8A9B3 },
	{ 0x6052, 0xE8A9B5 },
	{ 0x745A, 0xE8A9B9 },
	{ 0x714A, 0xE8AA85 },
	{ 0x4E23, 0xE8AA87 },
	{ 0x723C, 0xE8AA8C },
	{ 0x6C63, 0xE8AA8D },
	{ 0x6025, 0xE8AA93 },
	{ 0x772B, 0xE8AA95 },
	{ 0x6B2F, 0xE8AA98 },
	{ 0x655E, 0xE8AA9E },
	{ 0x6124, 0xE8AAA0 },
	{ 0x4D2B, 0xE8AAA1 },
	{ 0x5974, 0xE8AAA3 },
	{ 0x6826, 0xE8AAA4 },
	{ 0x4D4E, 0xE8AAA5 },
	{ 0x6169, 0xE8AAA6 },
	{ 0x7C6F, 0xE8AAA8 },
	{ 0x6063, 0xE8AAAA },
	{ 0x6241, 0xE8AAB0 },
	{ 0x4E24, 0xE8AAB2 },
	{ 0x5E26, 0xE8AAB9 },
	{ 0x6B7E, 0xE8AABC },
	{ 0x6B5D, 0xE8AABE },
	{ 0x7060, 0xE8AABF },
	{ 0x745B, 0xE8AB82 },
	{ 0x6274, 0xE8AB84 },
	{ 0x5348, 0xE8AB87 },
	{ 0x746B, 0xE8AB8B },
	{ 0x6E35, 0xE8AB8D },
	{ 0x7558, 0xE8AB8F },
	{ 0x555F, 0xE8AB92 },
	{ 0x5665, 0xE8AB96 },
	{ 0x6B30, 0xE8AB9B },
	{ 0x7463, 0xE8AB9C },
	{ 0x634D, 0xE8ABA1 },
	{ 0x7474, 0xE8ABA6 },
	{ 0x7A32, 0xE8ABA7 },
	{ 0x6F75, 0xE8ABAA },
	{ 0x4A5F, 0xE8ABAB },
	{ 0x6B31, 0xE8ABAD },
	{ 0x6D3F, 0xE8ABAE },
	{ 0x7D49, 0xE8ABB1 },
	{ 0x6426, 0xE8ABB6 },
	{ 0x7924, 0xE8ABB7 },
	{ 0x7033, 0xE8ABB8 },
	{ 0x656C, 0xE8ABBA },
	{ 0x5167, 0xE8ABBE },
	{ 0x5947, 0xE8AC80 },
	{ 0x6457, 0xE8AC81 },
	{ 0x6A5D, 0xE8AC82 },
	{ 0x5477, 0xE8AC84 },
	{ 0x5A3A, 0xE8AC8E },
	{ 0x5A4D, 0xE8AC90 },
	{ 0x794C, 0xE8AC94 },
	{ 0x615A, 0xE8AC96 },
	{ 0x5B3F, 0xE8AC97 },
	{ 0x4C45, 0xE8AC99 },
	{ 0x6C50, 0xE8AC9A },
	{ 0x4B3B, 0xE8AC9B },
	{ 0x5E73, 0xE8AC9D },
	{ 0x692A, 0xE8ACA0 },
	{ 0x5948, 0xE8ACA8 },
	{ 0x6E63, 0xE8ACAB },
	{ 0x573D, 0xE8ACAC },
	{ 0x4F44, 0xE8ACB3 },
	{ 0x504D, 0xE8ACB9 },
	{ 0x7C26, 0xE8AD81 },
	{ 0x717B, 0xE8AD89 },
	{ 0x7D52, 0xE8AD8E },
	{ 0x5141, 0xE8AD8F },
	{ 0x635B, 0xE8AD98 },
	{ 0x5349, 0xE8AD9A },
	{ 0x5C4F, 0xE8AD9C },
	{ 0x4C6D, 0xE8ADA6 },
	{ 0x5E27, 0xE8ADAC },
	{ 0x663B, 0xE8ADAF },
	{ 0x6C21, 0xE8ADB0 },
	{ 0x4C39, 0xE8ADB4 },
	{ 0x7B5E, 0xE8ADB7 },
	{ 0x6762, 0xE8ADBD },
	{ 0x5441, 0xE8AE80 },
	{ 0x5C28, 0xE8AE8A },
	{ 0x6242, 0xE8AE90 },
	{ 0x7358, 0xE8AE92 },
	{ 0x6553, 0xE8AE93 },
	{ 0x7359, 0xE8AE96 },
	{ 0x7346, 0xE8AE9A },
	{ 0x4D5B, 0xE8B0B7 },
	{ 0x4D2C, 0xE8B0BF },
	{ 0x7C43, 0xE8B181 },
	{ 0x5467, 0xE8B186 },
	{ 0x5142, 0xE8B188 },
	{ 0x7925, 0xE8B18A },
	{ 0x6855, 0xE8B18C },
	{ 0x634E, 0xE8B195 },
	{ 0x544A, 0xE8B19A },
	{ 0x5F5A, 0xE8B1A1 },
	{ 0x7B5F, 0xE8B1AA },
	{ 0x6763, 0xE8B1AB },
	{ 0x787B, 0xE8B1B9 },
	{ 0x634F, 0xE8B1BA },
	{ 0x7530, 0xE8B282 },
	{ 0x5867, 0xE8B28A },
	{ 0x5949, 0xE8B28C },
	{ 0x782F, 0xE8B29D },
	{ 0x6F76, 0xE8B29E },
	{ 0x5D36, 0xE8B2A0 },
	{ 0x6E2F, 0xE8B2A1 },
	{ 0x4D78, 0xE8B2A2 },
	{ 0x5E38, 0xE8B2A7 },
	{ 0x7C27, 0xE8B2A8 },
	{ 0x777C, 0xE8B2A9 },
	{ 0x7731, 0xE8B2AA },
	{ 0x4E3B, 0xE8B2AB },
	{ 0x7421, 0xE8B2AC },
	{ 0x6E4D, 0xE8B2AF },
	{ 0x612E, 0xE8B2B0 },
	{ 0x6C43, 0xE8B2B3 },
	{ 0x4F7E, 0xE8B2B4 },
	{ 0x783F, 0xE8B2B6 },
	{ 0x5862, 0xE8B2B7 },
	{ 0x5368, 0xE8B2B8 },
	{ 0x5E28, 0xE8B2BB },
	{ 0x7464, 0xE8B2BC },
	{ 0x6C42, 0xE8B2BD },
	{ 0x5975, 0xE8B2BF },
	{ 0x7945, 0xE8B380 },
	{ 0x5D53, 0xE8B381 },
	{ 0x5671, 0xE8B382 },
	{ 0x6C7C, 0xE8B383 },
	{ 0x7C70, 0xE8B384 },
	{ 0x6D40, 0xE8B387 },
	{ 0x4A39, 0xE8B388 },
	{ 0x6E64, 0xE8B38A },
	{ 0x7261, 0xE8B391 },
	{ 0x5E39, 0xE8B393 },
	{ 0x5672, 0xE8B39A },
	{ 0x5E74, 0xE8B39C },
	{ 0x5F5B, 0xE8B39E },
	{ 0x5B53, 0xE8B3A0 },
	{ 0x7A67, 0xE8B3A2 },
	{ 0x5863, 0xE8B3A3 },
	{ 0x7441, 0xE8B3A4 },
	{ 0x5D37, 0xE8B3A6 },
	{ 0x7275, 0xE8B3AA },
	{ 0x542E, 0xE8B3AD },
	{ 0x5673, 0xE8B3B4 },
	{ 0x5D38, 0xE8B3BB },
	{ 0x4F45, 0xE8B3BC },
	{ 0x5F5F, 0xE8B3BD },
	{ 0x723E, 0xE8B484 },
	{ 0x7621, 0xE8B485 },
	{ 0x6B4B, 0xE8B487 },
	{ 0x717C, 0xE8B488 },
	{ 0x7347, 0xE8B48A },
	{ 0x606B, 0xE8B48D },
	{ 0x6D7C, 0xE8B493 },
	{ 0x615B, 0xE8B496 },
	{ 0x6E65, 0xE8B5A4 },
	{ 0x5E75, 0xE8B5A6 },
	{ 0x7A53, 0xE8B5AB },
	{ 0x714B, 0xE8B5B0 },
	{ 0x502F, 0xE8B5B3 },
	{ 0x5D39, 0xE8B5B4 },
	{ 0x5143, 0xE8B5B7 },
	{ 0x7531, 0xE8B685 },
	{ 0x6A46, 0xE8B68A },
	{ 0x7061, 0xE8B699 },
	{ 0x762C, 0xE8B6A3 },
	{ 0x7559, 0xE8B6A8 },
	{ 0x706B, 0xE8B6B3 },
	{ 0x5D3A, 0xE8B6BA },
	{ 0x723F, 0xE8B6BE },
	{ 0x7745, 0xE8B786 },
	{ 0x5B22, 0xE8B78B },
	{ 0x7276, 0xE8B78C },
	{ 0x4A3A, 0xE8B78F },
	{ 0x7775, 0xE8B79B },
	{ 0x4B65, 0xE8B79D },
	{ 0x6E66, 0xE8B7A1 },
	{ 0x6053, 0xE8B7A3 },
	{ 0x4E25, 0xE8B7A8 },
	{ 0x5658, 0xE8B7AF },
	{ 0x542F, 0xE8B7B3 },
	{ 0x6949, 0xE8B88A },
	{ 0x534E, 0xE8B88F },
	{ 0x7442, 0xE8B890 },
	{ 0x4B66, 0xE8B89E },
	{ 0x7121, 0xE8B8AA },
	{ 0x6B32, 0xE8B8B0 },
	{ 0x7122, 0xE8B8B5 },
	{ 0x6B33, 0xE8B982 },
	{ 0x7034, 0xE8B984 },
	{ 0x4B74, 0xE8B987 },
	{ 0x5430, 0xE8B988 },
	{ 0x7332, 0xE8B989 },
	{ 0x7B37, 0xE8B98A },
	{ 0x756C, 0xE8B999 },
	{ 0x6E67, 0xE8B99F },
	{ 0x7432, 0xE8B9A0 },
	{ 0x756D, 0xE8B9B4 },
	{ 0x4F73, 0xE8B9B6 },
	{ 0x7062, 0xE8BA81 },
	{ 0x6E4E, 0xE8BA87 },
	{ 0x714C, 0xE8BA8A },
	{ 0x6538, 0xE8BA8D },
	{ 0x5775, 0xE8BAAA },
	{ 0x6373, 0xE8BAAB },
	{ 0x4F65, 0xE8BAAC },
	{ 0x4F46, 0xE8BB80 },
	{ 0x7333, 0xE8BB8A },
	{ 0x6458, 0xE8BB8B },
	{ 0x4F79, 0xE8BB8C },
	{ 0x4F5A, 0xE8BB8D },
	{ 0x7A4D, 0xE8BB92 },
	{ 0x6663, 0xE8BB9F },
	{ 0x7262, 0xE8BBAB },
	{ 0x756E, 0xE8BBB8 },
	{ 0x4A3B, 0xE8BBBB },
	{ 0x635C, 0xE8BBBE },
	{ 0x4E72, 0xE8BC83 },
	{ 0x5659, 0xE8BC85 },
	{ 0x6E30, 0xE8BC89 },
	{ 0x7465, 0xE8BC92 },
	{ 0x5842, 0xE8BC93 },
	{ 0x5C50, 0xE8BC94 },
	{ 0x4C6E, 0xE8BC95 },
	{ 0x5560, 0xE8BC9B },
	{ 0x764A, 0xE8BC9C },
	{ 0x7D4A, 0xE8BC9D },
	{ 0x5856, 0xE8BC9E },
	{ 0x744F, 0xE8BC9F },
	{ 0x5626, 0xE8BCA6 },
	{ 0x5C3E, 0xE8BCA7 },
	{ 0x5B54, 0xE8BCA9 },
	{ 0x5747, 0xE8BCAA },
	{ 0x727E, 0xE8BCAF },
	{ 0x714D, 0xE8BCB3 },
	{ 0x6243, 0xE8BCB8 },
	{ 0x5C5E, 0xE8BCB9 },
	{ 0x5C5F, 0xE8BCBB },
	{ 0x6F2D, 0xE8BCBE },
	{ 0x662B, 0xE8BCBF },
	{ 0x795D, 0xE8BD84 },
	{ 0x6A3F, 0xE8BD85 },
	{ 0x6F2E, 0xE8BD89 },
	{ 0x7450, 0xE8BD8D },
	{ 0x4E73, 0xE8BD8E },
	{ 0x662C, 0xE8BD9D },
	{ 0x4E5E, 0xE8BD9F },
	{ 0x5579, 0xE8BDA2 },
	{ 0x6374, 0xE8BE9B },
	{ 0x4D50, 0xE8BE9C },
	{ 0x5538, 0xE8BEA3 },
	{ 0x777D, 0xE8BEA6 },
	{ 0x5C29, 0xE8BEA8 },
	{ 0x5E76, 0xE8BEAD },
	{ 0x5C2A, 0xE8BEAF },
	{ 0x7263, 0xE8BEB0 },
	{ 0x6934, 0xE8BEB1 },
	{ 0x525C, 0xE8BEB2 },
	{ 0x6966, 0xE8BF82 },
	{ 0x6376, 0xE8BF85 },
	{ 0x674A, 0xE8BF8E },
	{ 0x504E, 0xE8BF91 },
	{ 0x5A77, 0xE8BF94 },
	{ 0x4A3C, 0xE8BFA6 },
	{ 0x6E68, 0xE8BFAA },
	{ 0x5A5E, 0xE8BFAB },
	{ 0x7277, 0xE8BFAD },
	{ 0x627B, 0xE8BFB0 },
	{ 0x4C26, 0xE8BFB2 },
	{ 0x5A3B, 0xE8BFB7 },
	{ 0x6E69, 0xE8BFB9 },
	{ 0x755A, 0xE8BFBD },
	{ 0x775C, 0xE98080 },
	{ 0x616A, 0xE98081 },
	{ 0x4E41, 0xE98082 },
	{ 0x5431, 0xE98083 },
	{ 0x7D31, 0xE98085 },
	{ 0x663D, 0xE98086 },
	{ 0x7B2D, 0xE98088 },
	{ 0x7867, 0xE9808B },
	{ 0x614E, 0xE9808D },
	{ 0x7762, 0xE9808F },
	{ 0x756F, 0xE98090 },
	{ 0x4F47, 0xE98091 },
	{ 0x5432, 0xE98094 },
	{ 0x4C6F, 0xE98095 },
	{ 0x5468, 0xE98097 },
	{ 0x6E4F, 0xE98099 },
	{ 0x7757, 0xE9809A },
	{ 0x6026, 0xE9809D },
	{ 0x5641, 0xE9809E },
	{ 0x615C, 0xE9809F },
	{ 0x7063, 0xE980A0 },
	{ 0x7164, 0xE980A1 },
	{ 0x5C71, 0xE980A2 },
	{ 0x5627, 0xE980A3 },
	{ 0x7475, 0xE980AE },
	{ 0x714E, 0xE980B1 },
	{ 0x7264, 0xE980B2 },
	{ 0x5030, 0xE980B5 },
	{ 0x6C6F, 0xE980B8 },
	{ 0x793A, 0xE980BC },
	{ 0x6B35, 0xE980BE },
	{ 0x546D, 0xE98181 },
	{ 0x6244, 0xE98182 },
	{ 0x6967, 0xE98187 },
	{ 0x6B34, 0xE9818A },
	{ 0x6A21, 0xE9818B },
	{ 0x783C, 0xE9818D },
	{ 0x4E26, 0xE9818E },
	{ 0x7946, 0xE98190 },
	{ 0x7C5A, 0xE98191 },
	{ 0x5433, 0xE98193 },
	{ 0x5339, 0xE98194 },
	{ 0x6A5E, 0xE98195 },
	{ 0x692B, 0xE98199 },
	{ 0x6161, 0xE9819C },
	{ 0x534F, 0xE9819D },
	{ 0x7476, 0xE9819E },
	{ 0x6A40, 0xE981A0 },
	{ 0x614F, 0xE981A1 },
	{ 0x4C3A, 0xE981A3 },
	{ 0x6E6A, 0xE981A9 },
	{ 0x7064, 0xE981AD },
	{ 0x7334, 0xE981AE },
	{ 0x546E, 0xE981AF },
	{ 0x7240, 0xE981B2 },
	{ 0x7165, 0xE981B5 },
	{ 0x7443, 0xE981B7 },
	{ 0x6054, 0xE981B8 },
	{ 0x6B36, 0xE981BA },
	{ 0x5721, 0xE981BC },
	{ 0x4B68, 0xE981BD },
	{ 0x792D, 0xE981BF },
	{ 0x692D, 0xE98280 },
	{ 0x5864, 0xE98281 },
	{ 0x7A33, 0xE98282 },
	{ 0x6245, 0xE98283 },
	{ 0x7C3D, 0xE98284 },
	{ 0x6C44, 0xE98287 },
	{ 0x5831, 0xE98288 },
	{ 0x5C2B, 0xE9828A },
	{ 0x5524, 0xE9828F },
	{ 0x6B69, 0xE98291 },
	{ 0x683B, 0xE98295 },
	{ 0x5857, 0xE98299 },
	{ 0x7B2E, 0xE982A2 },
	{ 0x5161, 0xE982A3 },
	{ 0x5B40, 0xE982A6 },
	{ 0x753E, 0xE982A8 },
	{ 0x5E77, 0xE982AA },
	{ 0x4A7B, 0xE982AF },
	{ 0x7746, 0xE982B0 },
	{ 0x4F48, 0xE982B1 },
	{ 0x6150, 0xE982B5 },
	{ 0x6E50, 0xE982B8 },
	{ 0x6974, 0xE98381 },
	{ 0x4E74, 0xE9838A },
	{ 0x554D, 0xE9839E },
	{ 0x4F5B, 0xE983A1 },
	{ 0x5D3B, 0xE983A8 },
	{ 0x4E2C, 0xE983AD },
	{ 0x6968, 0xE983B5 },
	{ 0x5434, 0xE983BD },
	{ 0x6447, 0xE98482 },
	{ 0x755B, 0xE98492 },
	{ 0x7A41, 0xE98495 },
	{ 0x5E29, 0xE98499 },
	{ 0x5478, 0xE984A7 },
	{ 0x6F77, 0xE984AD },
	{ 0x5333, 0xE984B2 },
	{ 0x6B37, 0xE98589 },
	{ 0x6F78, 0xE9858A },
	{ 0x755C, 0xE9858B },
	{ 0x6D4C, 0xE9858C },
	{ 0x5B55, 0xE9858D },
	{ 0x714F, 0xE9858E },
	{ 0x7150, 0xE98592 },
	{ 0x7532, 0xE985A2 },
	{ 0x592E, 0xE985A9 },
	{ 0x552C, 0xE985AA },
	{ 0x6246, 0xE985AC },
	{ 0x7D23, 0xE985B5 },
	{ 0x7B65, 0xE985B7 },
	{ 0x5F2B, 0xE985B8 },
	{ 0x6275, 0xE98687 },
	{ 0x762D, 0xE98689 },
	{ 0x7533, 0xE9868B },
	{ 0x7035, 0xE9868D },
	{ 0x6125, 0xE98692 },
	{ 0x755D, 0xE9869C },
	{ 0x6C22, 0xE986AB },
	{ 0x6D7D, 0xE986AC },
	{ 0x7534, 0xE986AE },
	{ 0x7B38, 0xE986AF },
	{ 0x5B23, 0xE986B1 },
	{ 0x564A, 0xE986B4 },
	{ 0x4B59, 0xE986B5 },
	{ 0x6554, 0xE98780 },
	{ 0x737A, 0xE98787 },
	{ 0x6B38, 0xE98789 },
	{ 0x6037, 0xE9878B },
	{ 0x576C, 0xE9878C },
	{ 0x716C, 0xE9878D },
	{ 0x652F, 0xE9878E },
	{ 0x5561, 0xE9878F },
	{ 0x576D, 0xE98790 },
	{ 0x5151, 0xE98791 },
	{ 0x6172, 0xE98797 },
	{ 0x6F79, 0xE98798 },
	{ 0x5D3C, 0xE9879C },
	{ 0x765C, 0xE9879D },
	{ 0x7065, 0xE987A3 },
	{ 0x7444, 0xE987A7 },
	{ 0x6969, 0xE987AA },
	{ 0x737B, 0xE987B5 },
	{ 0x546F, 0xE9888D },
	{ 0x4C22, 0xE98890 },
	{ 0x777E, 0xE98891 },
	{ 0x5F3C, 0xE98892 },
	{ 0x6B4D, 0xE98897 },
	{ 0x5037, 0xE9889E },
	{ 0x5642, 0xE988B4 },
	{ 0x682D, 0xE988BA },
	{ 0x6F2F, 0xE988BF },
	{ 0x4B25, 0xE98980 },
	{ 0x4B69, 0xE98985 },
	{ 0x7A68, 0xE98989 },
	{ 0x4C46, 0xE98997 },
	{ 0x6667, 0xE9899B },
	{ 0x6A47, 0xE9899E },
	{ 0x5B24, 0xE989A2 },
	{ 0x4F49, 0xE989A4 },
	{ 0x627C, 0xE989A5 },
	{ 0x6F7A, 0xE989A6 },
	{ 0x6B5E, 0xE98A80 },
	{ 0x7548, 0xE98A83 },
	{ 0x545E, 0xE98A85 },
	{ 0x6055, 0xE98A91 },
	{ 0x6F30, 0xE98A93 },
	{ 0x6247, 0xE98A96 },
	{ 0x592F, 0xE98A98 },
	{ 0x7967, 0xE98A9C },
	{ 0x6765, 0xE98AB3 },
	{ 0x4F4A, 0xE98AB6 },
	{ 0x6151, 0xE98AB7 },
	{ 0x6248, 0xE98AB9 },
	{ 0x6F7B, 0xE98B8C },
	{ 0x7A79, 0xE98B8F },
	{ 0x5C72, 0xE98B92 },
	{ 0x6027, 0xE98BA4 },
	{ 0x7868, 0xE98BAA },
	{ 0x4B6A, 0xE98BB8 },
	{ 0x4B3C, 0xE98BBC },
	{ 0x5662, 0xE98C84 },
	{ 0x755E, 0xE98C90 },
	{ 0x755F, 0xE98C98 },
	{ 0x6E36, 0xE98C9A },
	{ 0x6276, 0xE98C9E },
	{ 0x534A, 0xE98C9F },
	{ 0x6F7C, 0xE98CA0 },
	{ 0x5144, 0xE98CA1 },
	{ 0x6F31, 0xE98CA2 },
	{ 0x5145, 0xE98CA4 },
	{ 0x505E, 0xE98CA6 },
	{ 0x5961, 0xE98CA8 },
	{ 0x6038, 0xE98CAB },
	{ 0x4D51, 0xE98CAE },
	{ 0x7339, 0xE98CAF },
	{ 0x674C, 0xE98D88 },
	{ 0x5628, 0xE98D8A },
	{ 0x4E27, 0xE98D8B },
	{ 0x5435, 0xE98D8D },
	{ 0x6448, 0xE98D94 },
	{ 0x5334, 0xE98D9B },
	{ 0x6B39, 0xE98DAE },
	{ 0x4B75, 0xE98DB5 },
	{ 0x765D, 0xE98DBC },
	{ 0x7123, 0xE98DBE },
	{ 0x4C47, 0xE98E8C },
	{ 0x694A, 0xE98E94 },
	{ 0x6170, 0xE98E96 },
	{ 0x7560, 0xE98E9A },
	{ 0x7B2F, 0xE98EA3 },
	{ 0x4B51, 0xE98EA7 },
	{ 0x7B60, 0xE98EAC },
	{ 0x7265, 0xE98EAD },
	{ 0x6C70, 0xE98EB0 },
	{ 0x706C, 0xE98F83 },
	{ 0x6E6B, 0xE98F91 },
	{ 0x694B, 0xE98F9E },
	{ 0x4C70, 0xE98FA1 },
	{ 0x572F, 0xE98FA4 },
	{ 0x7321, 0xE98FB6 },
	{ 0x7C75, 0xE99084 },
	{ 0x7124, 0xE99098 },
	{ 0x6056, 0xE990A5 },
	{ 0x6F32, 0xE990AB },
	{ 0x7451, 0xE990B5 },
	{ 0x7721, 0xE990B8 },
	{ 0x7151, 0xE99184 },
	{ 0x4A7C, 0xE99191 },
	{ 0x4A7D, 0xE99192 },
	{ 0x4E4E, 0xE9919B },
	{ 0x7348, 0xE991BD },
	{ 0x733A, 0xE991BF },
	{ 0x6D7E, 0xE995B7 },
	{ 0x5A26, 0xE99680 },
	{ 0x606C, 0xE99683 },
	{ 0x784D, 0xE99689 },
	{ 0x4B52, 0xE9968B },
	{ 0x6B4E, 0xE9968F },
	{ 0x7958, 0xE99691 },
	{ 0x7959, 0xE99692 },
	{ 0x4A60, 0xE99693 },
	{ 0x5A4A, 0xE99694 },
	{ 0x4B26, 0xE99698 },
	{ 0x4A48, 0xE996A3 },
	{ 0x796E, 0xE996A4 },
	{ 0x5B6C, 0xE996A5 },
	{ 0x5031, 0xE996A8 },
	{ 0x556F, 0xE996AD },
	{ 0x6673, 0xE996B1 },
	{ 0x6722, 0xE996BB },
	{ 0x6459, 0xE996BC },
	{ 0x6461, 0xE99787 },
	{ 0x7C44, 0xE9978A },
	{ 0x796F, 0xE99794 },
	{ 0x4F74, 0xE99795 },
	{ 0x7766, 0xE99796 },
	{ 0x4E3C, 0xE9979C },
	{ 0x7445, 0xE997A1 },
	{ 0x5C23, 0xE997A2 },
	{ 0x5D3D, 0xE9989C },
	{ 0x7446, 0xE998A1 },
	{ 0x7821, 0xE998AA },
	{ 0x6856, 0xE998AE },
	{ 0x5B41, 0xE998B2 },
	{ 0x7066, 0xE998BB },
	{ 0x6439, 0xE998BF },
	{ 0x766D, 0xE99980 },
	{ 0x792E, 0xE99982 },
	{ 0x5D3E, 0xE99984 },
	{ 0x5730, 0xE9998B },
	{ 0x5868, 0xE9998C },
	{ 0x4B3D, 0xE9998D },
	{ 0x795A, 0xE99990 },
	{ 0x784E, 0xE9999B },
	{ 0x7970, 0xE9999C },
	{ 0x606D, 0xE9999D },
	{ 0x6333, 0xE9999E },
	{ 0x7433, 0xE9999F },
	{ 0x6A42, 0xE999A2 },
	{ 0x7266, 0xE999A3 },
	{ 0x7036, 0xE999A4 },
	{ 0x5B56, 0xE999AA },
	{ 0x6B64, 0xE999B0 },
	{ 0x7267, 0xE999B3 },
	{ 0x5755, 0xE999B5 },
	{ 0x5436, 0xE999B6 },
	{ 0x7968, 0xE999B7 },
	{ 0x5741, 0xE999B8 },
	{ 0x6555, 0xE999BD },
	{ 0x696A, 0xE99A85 },
	{ 0x574C, 0xE99A86 },
	{ 0x5369, 0xE99A8A },
	{ 0x6249, 0xE99A8B },
	{ 0x7C5B, 0xE99A8D },
	{ 0x4D2D, 0xE99A8E },
	{ 0x4C30, 0xE99A94 },
	{ 0x6A22, 0xE99A95 },
	{ 0x6476, 0xE99A98 },
	{ 0x5040, 0xE99A99 },
	{ 0x7037, 0xE99A9B },
	{ 0x6E21, 0xE99A9C },
	{ 0x5776, 0xE99AA3 },
	{ 0x624A, 0xE99AA7 },
	{ 0x624B, 0xE99AA8 },
	{ 0x7A4F, 0xE99AAA },
	{ 0x6B5F, 0xE99AB1 },
	{ 0x564B, 0xE99AB7 },
	{ 0x7434, 0xE99ABB },
	{ 0x6D4D, 0xE99B80 },
	{ 0x6452, 0xE99B81 },
	{ 0x6A29, 0xE99B84 },
	{ 0x643A, 0xE99B85 },
	{ 0x7322, 0xE99B86 },
	{ 0x4D52, 0xE99B87 },
	{ 0x764B, 0xE99B89 },
	{ 0x7166, 0xE99B8B },
	{ 0x6D41, 0xE99B8C },
	{ 0x683C, 0xE99B8D },
	{ 0x6E51, 0xE99B8E },
	{ 0x7067, 0xE99B95 },
	{ 0x624C, 0xE99B96 },
	{ 0x642A, 0xE99B99 },
	{ 0x7561, 0xE99B9B },
	{ 0x6D5A, 0xE99B9C },
	{ 0x576E, 0xE99BA2 },
	{ 0x5171, 0xE99BA3 },
	{ 0x696B, 0xE99BA8 },
	{ 0x696C, 0xE99BA9 },
	{ 0x6064, 0xE99BAA },
	{ 0x5A27, 0xE99BAF },
	{ 0x5D54, 0xE99BB0 },
	{ 0x6A23, 0xE99BB2 },
	{ 0x5643, 0xE99BB6 },
	{ 0x5674, 0xE99BB7 },
	{ 0x5A5F, 0xE99BB9 },
	{ 0x6F33, 0xE99BBB },
	{ 0x624D, 0xE99C80 },
	{ 0x6F7D, 0xE99C86 },
	{ 0x7268, 0xE99C87 },
	{ 0x6F45, 0xE99C91 },
	{ 0x6767, 0xE99C93 },
	{ 0x577D, 0xE99C96 },
	{ 0x674E, 0xE99C99 },
	{ 0x5F5C, 0xE99C9C },
	{ 0x7947, 0xE99C9E },
	{ 0x5976, 0xE99CA7 },
	{ 0x5F2C, 0xE99CB0 },
	{ 0x565A, 0xE99CB2 },
	{ 0x5C24, 0xE99CB9 },
	{ 0x7038, 0xE99CBD },
	{ 0x557A, 0xE99D82 },
	{ 0x6477, 0xE99D84 },
	{ 0x5644, 0xE99D88 },
	{ 0x746C, 0xE99D91 },
	{ 0x6F7E, 0xE99D96 },
	{ 0x7021, 0xE99D9C },
	{ 0x5E2A, 0xE99D9E },
	{ 0x5A3C, 0xE99DA1 },
	{ 0x587C, 0xE99DA2 },
	{ 0x7A54, 0xE99DA9 },
	{ 0x6C65, 0xE99DAD },
	{ 0x7C28, 0xE99DB4 },
	{ 0x6C66, 0xE99DB7 },
	{ 0x584B, 0xE99DBA },
	{ 0x7B39, 0xE99E8B },
	{ 0x6453, 0xE99E8D },
	{ 0x4D79, 0xE99E8F },
	{ 0x4F53, 0xE99EA0 },
	{ 0x4A6A, 0xE99EA8 },
	{ 0x4F54, 0xE99EAB },
	{ 0x783D, 0xE99EAD },
	{ 0x7447, 0xE99F86 },
	{ 0x6A5F, 0xE99F8B },
	{ 0x795B, 0xE99F93 },
	{ 0x5437, 0xE99F9C },
	{ 0x6B65, 0xE99FB3 },
	{ 0x6152, 0xE99FB6 },
	{ 0x6A24, 0xE99FBB },
	{ 0x7A42, 0xE99FBF },
	{ 0x7B61, 0xE9A080 },
	{ 0x7A6D, 0xE9A081 },
	{ 0x7022, 0xE9A082 },
	{ 0x4C71, 0xE9A083 },
	{ 0x7A23, 0xE9A085 },
	{ 0x6277, 0xE9A086 },
	{ 0x624E, 0xE9A088 },
	{ 0x6975, 0xE9A08A },
	{ 0x616B, 0xE9A08C },
	{ 0x6768, 0xE9A090 },
	{ 0x6857, 0xE9A091 },
	{ 0x5A78, 0xE9A092 },
	{ 0x544B, 0xE9A093 },
	{ 0x7776, 0xE9A097 },
	{ 0x5645, 0xE9A098 },
	{ 0x5469, 0xE9A0AD },
	{ 0x7A7A, 0xE9A0B0 },
	{ 0x4C72, 0xE9A0B8 },
	{ 0x775D, 0xE9A0B9 },
	{ 0x5E3A, 0xE9A0BB },
	{ 0x4E28, 0xE9A186 },
	{ 0x7039, 0xE9A18C },
	{ 0x647E, 0xE9A18D },
	{ 0x6449, 0xE9A18E },
	{ 0x6454, 0xE9A194 },
	{ 0x6A43, 0xE9A198 },
	{ 0x6F34, 0xE9A19A },
	{ 0x573E, 0xE9A19E },
	{ 0x7B62, 0xE9A1A5 },
	{ 0x4D53, 0xE9A1A7 },
	{ 0x6F35, 0xE9A1AB },
	{ 0x7A69, 0xE9A1AF },
	{ 0x7926, 0xE9A2A8 },
	{ 0x5F3D, 0xE9A2AF },
	{ 0x7747, 0xE9A2B1 },
	{ 0x787D, 0xE9A384 },
	{ 0x787C, 0xE9A387 },
	{ 0x5E2B, 0xE9A39B },
	{ 0x5B68, 0xE9A39C },
	{ 0x635D, 0xE9A39F },
	{ 0x6162, 0xE9A3A1 },
	{ 0x5146, 0xE9A3A2 },
	{ 0x7650, 0xE9A3AD },
	{ 0x6B66, 0xE9A3AE },
	{ 0x5A79, 0xE9A3AF },
	{ 0x6C47, 0xE9A3B4 },
	{ 0x5E78, 0xE9A3BC },
	{ 0x7869, 0xE9A3BD },
	{ 0x635E, 0xE9A3BE },
	{ 0x4E75, 0xE9A483 },
	{ 0x7A43, 0xE9A489 },
	{ 0x6557, 0xE9A48A },
	{ 0x6C48, 0xE9A48C },
	{ 0x7349, 0xE9A490 },
	{ 0x643B, 0xE9A493 },
	{ 0x662E, 0xE9A498 },
	{ 0x6F36, 0xE9A49E },
	{ 0x5C3F, 0xE9A4A0 },
	{ 0x4E3D, 0xE9A4A8 },
	{ 0x5843, 0xE9A585 },
	{ 0x504F, 0xE9A589 },
	{ 0x4F7A, 0xE9A58B },
	{ 0x734A, 0xE9A58C },
	{ 0x6057, 0xE9A58D },
	{ 0x5147, 0xE9A591 },
	{ 0x692E, 0xE9A592 },
	{ 0x683D, 0xE9A594 },
	{ 0x7A44, 0xE9A597 },
	{ 0x624F, 0xE9A696 },
	{ 0x7A45, 0xE9A699 },
	{ 0x7938, 0xE9A69D },
	{ 0x5C60, 0xE9A6A5 },
	{ 0x7B30, 0xE9A6A8 },
	{ 0x5829, 0xE9A6AC },
	{ 0x655F, 0xE9A6AD },
	{ 0x7927, 0xE9A6AE },
	{ 0x766E, 0xE9A6B1 },
	{ 0x764C, 0xE9A6B3 },
	{ 0x6278, 0xE9A6B4 },
	{ 0x6C71, 0xE9A6B9 },
	{ 0x5A60, 0xE9A781 },
	{ 0x7152, 0xE9A790 },
	{ 0x524C, 0xE9A791 },
	{ 0x4F4B, 0xE9A792 },
	{ 0x4A3D, 0xE9A795 },
	{ 0x5D3F, 0xE9A799 },
	{ 0x766F, 0xE9A79D },
	{ 0x5E79, 0xE9A79F },
	{ 0x7A34, 0xE9A7AD },
	{ 0x552D, 0xE9A7B1 },
	{ 0x7167, 0xE9A7BF },
	{ 0x5E3E, 0xE9A881 },
	{ 0x5C40, 0xE9A888 },
	{ 0x5148, 0xE9A88E },
	{ 0x5149, 0xE9A88F },
	{ 0x783E, 0xE9A899 },
	{ 0x4B76, 0xE9A8AB },
	{ 0x5479, 0xE9A8B0 },
	{ 0x7562, 0xE9A8B6 },
	{ 0x6153, 0xE9A8B7 },
	{ 0x5869, 0xE9A980 },
	{ 0x787E, 0xE9A983 },
	{ 0x4F4C, 0xE9A985 },
	{ 0x7D24, 0xE9A98D },
	{ 0x4E76, 0xE9A995 },
	{ 0x7A50, 0xE9A997 },
	{ 0x4C73, 0xE9A99A },
	{ 0x663E, 0xE9A99B },
	{ 0x762E, 0xE9A99F },
	{ 0x5570, 0xE9A9A2 },
	{ 0x514A, 0xE9A9A5 },
	{ 0x7C3E, 0xE9A9A9 },
	{ 0x5571, 0xE9A9AA },
	{ 0x4D69, 0xE9AAA8 },
	{ 0x7A35, 0xE9AAB8 },
	{ 0x6250, 0xE9AB93 },
	{ 0x7477, 0xE9AB94 },
	{ 0x4D54, 0xE9AB98 },
	{ 0x6723, 0xE9ABA5 },
	{ 0x5B25, 0xE9ABAE },
	{ 0x6251, 0xE9AC9A },
	{ 0x5722, 0xE9ACA7 },
	{ 0x7763, 0xE9ACAA },
	{ 0x6A26, 0xE9ACB1 },
	{ 0x5021, 0xE9ACBC },
	{ 0x4E5A, 0xE9AD81 },
	{ 0x7B6B, 0xE9AD82 },
	{ 0x5B26, 0xE9AD83 },
	{ 0x5B5E, 0xE9AD84 },
	{ 0x5865, 0xE9AD85 },
	{ 0x6A60, 0xE9AD8F },
	{ 0x582A, 0xE9AD94 },
	{ 0x6560, 0xE9AD9A },
	{ 0x565B, 0xE9ADAF },
	{ 0x6F46, 0xE9AE8E },
	{ 0x786A, 0xE9AE91 },
	{ 0x6455, 0xE9AE9F },
	{ 0x4E77, 0xE9AEAB },
	{ 0x6058, 0xE9AEAE },
	{ 0x576F, 0xE9AF89 },
	{ 0x746D, 0xE9AF96 },
	{ 0x4D66, 0xE9AFA4 },
	{ 0x4C74, 0xE9AFA8 },
	{ 0x7563, 0xE9B08D },
	{ 0x644A, 0xE9B090 },
	{ 0x5C61, 0xE9B092 },
	{ 0x7948, 0xE9B095 },
	{ 0x7C3F, 0xE9B0A5 },
	{ 0x6827, 0xE9B0B2 },
	{ 0x5844, 0xE9B0BB },
	{ 0x4B3E, 0xE9B187 },
	{ 0x5C2E, 0xE9B189 },
	{ 0x5777, 0xE9B197 },
	{ 0x7068, 0xE9B3A5 },
	{ 0x5D40, 0xE9B3A7 },
	{ 0x4F4D, 0xE9B3A9 },
	{ 0x5C73, 0xE9B3B3 },
	{ 0x5930, 0xE9B3B4 },
	{ 0x6669, 0xE9B3B6 },
	{ 0x643C, 0xE9B489 },
	{ 0x6A44, 0xE9B49B },
	{ 0x646C, 0xE9B4A6 },
	{ 0x6465, 0xE9B4A8 },
	{ 0x7B78, 0xE9B4BB },
	{ 0x4C3B, 0xE9B591 },
	{ 0x643D, 0xE9B59D },
	{ 0x4D5C, 0xE9B5A0 },
	{ 0x5977, 0xE9B5A1 },
	{ 0x5D5F, 0xE9B5AC },
	{ 0x6D4E, 0xE9B5B2 },
	{ 0x5950, 0xE9B6A9 },
	{ 0x6523, 0xE9B6AF },
	{ 0x794D, 0xE9B6B4 },
	{ 0x4D2E, 0xE9B784 },
	{ 0x4F4E, 0xE9B797 },
	{ 0x762F, 0xE9B7B2 },
	{ 0x7D53, 0xE9B7B8 },
	{ 0x6B6D, 0xE9B7B9 },
	{ 0x565C, 0xE9B7BA },
	{ 0x6524, 0xE9B89A },
	{ 0x5536, 0xE9B89E },
	{ 0x565D, 0xE9B9B5 },
	{ 0x7969, 0xE9B9B9 },
	{ 0x6724, 0xE9B9BD },
	{ 0x5663, 0xE9B9BF },
	{ 0x514B, 0xE9BA92 },
	{ 0x5664, 0xE9BA93 },
	{ 0x5572, 0xE9BA97 },
	{ 0x5E7A, 0xE9BA9D },
	{ 0x5778, 0xE9BA9F },
	{ 0x586A, 0xE9BAA5 },
	{ 0x4F55, 0xE9BAB4 },
	{ 0x587D, 0xE9BAB5 },
	{ 0x582B, 0xE9BABB },
	{ 0x7D4B, 0xE9BABE },
	{ 0x7C5C, 0xE9BB83 },
	{ 0x6028, 0xE9BB8D },
	{ 0x5573, 0xE9BB8E },
	{ 0x7D59, 0xE9BB91 },
	{ 0x4C23, 0xE9BB94 },
	{ 0x5979, 0xE9BB98 },
	{ 0x536A, 0xE9BB9B },
	{ 0x7575, 0xE9BB9C },
	{ 0x6F47, 0xE9BB9E },
	{ 0x535A, 0xE9BBA8 },
	{ 0x5A3D, 0xE9BBB4 },
	{ 0x6828, 0xE9BC87 },
	{ 0x5C2F, 0xE9BC88 },
	{ 0x7023, 0xE9BC8E },
	{ 0x4D55, 0xE9BC93 },
	{ 0x6029, 0xE9BCA0 },
	{ 0x5E2C, 0xE9BCBB },
	{ 0x703A, 0xE9BD8A },
	{ 0x6E31, 0xE9BD8B },
	{ 0x6E32, 0xE9BD8E },
	{ 0x764D, 0xE9BD92 },
	{ 0x6E52, 0xE9BD9F },
	{ 0x5646, 0xE9BDA1 },
	{ 0x6065, 0xE9BDA7 },
	{ 0x733B, 0xE9BDAA },
	{ 0x6561, 0xE9BDAC },
	{ 0x644B, 0xE9BDB7 },
	{ 0x5723, 0xE9BE8D },
	{ 0x5B42, 0xE9BE90 },
	{ 0x4A7E, 0xE9BE95 },
	{ 0x4F4F, 0xE9BE9C },
	{ 0x4B50, 0xEFA480 },
	{ 0x4B56, 0xEFA481 },
	{ 0x4B67, 0xEFA482 },
	{ 0x4D4F, 0xEFA483 },
	{ 0x4D68, 0xEFA484 },
	{ 0x4E2D, 0xEFA485 },
	{ 0x4F7B, 0xEFA486 },
	{ 0x5022, 0xEFA487 },
	{ 0x5038, 0xEFA488 },
	{ 0x5050, 0xEFA489 },
	{ 0x505D, 0xEFA48A },
	{ 0x5154, 0xEFA48B },
	{ 0x5155, 0xEFA48C },
	{ 0x5158, 0xEFA48D },
	{ 0x515B, 0xEFA48E },
	{ 0x515C, 0xEFA48F },
	{ 0x515D, 0xEFA490 },
	{ 0x515E, 0xEFA491 },
	{ 0x515F, 0xEFA492 },
	{ 0x5160, 0xEFA493 },
	{ 0x5162, 0xEFA494 },
	{ 0x5163, 0xEFA495 },
	{ 0x5164, 0xEFA496 },
	{ 0x5165, 0xEFA497 },
	{ 0x5166, 0xEFA498 },
	{ 0x5168, 0xEFA499 },
	{ 0x5169, 0xEFA49A },
	{ 0x516A, 0xEFA49B },
	{ 0x516B, 0xEFA49C },
	{ 0x516D, 0xEFA49D },
	{ 0x516F, 0xEFA49E },
	{ 0x5170, 0xEFA49F },
	{ 0x5172, 0xEFA4A0 },
	{ 0x5176, 0xEFA4A1 },
	{ 0x517A, 0xEFA4A2 },
	{ 0x517C, 0xEFA4A3 },
	{ 0x517D, 0xEFA4A4 },
	{ 0x517E, 0xEFA4A5 },
	{ 0x5222, 0xEFA4A6 },
	{ 0x5223, 0xEFA4A7 },
	{ 0x5227, 0xEFA4A8 },
	{ 0x5228, 0xEFA4A9 },
	{ 0x5229, 0xEFA4AA },
	{ 0x522A, 0xEFA4AB },
	{ 0x522B, 0xEFA4AC },
	{ 0x522D, 0xEFA4AD },
	{ 0x5232, 0xEFA4AE },
	{ 0x523E, 0xEFA4AF },
	{ 0x5242, 0xEFA4B0 },
	{ 0x5243, 0xEFA4B1 },
	{ 0x5244, 0xEFA4B2 },
	{ 0x5246, 0xEFA4B3 },
	{ 0x5247, 0xEFA4B4 },
	{ 0x5248, 0xEFA4B5 },
	{ 0x5249, 0xEFA4B6 },
	{ 0x524A, 0xEFA4B7 },
	{ 0x524B, 0xEFA4B8 },
	{ 0x524D, 0xEFA4B9 },
	{ 0x524E, 0xEFA4BA },
	{ 0x524F, 0xEFA4BB },
	{ 0x5250, 0xEFA4BC },
	{ 0x5251, 0xEFA4BD },
	{ 0x5252, 0xEFA4BE },
	{ 0x5253, 0xEFA4BF },
	{ 0x5254, 0xEFA580 },
	{ 0x5255, 0xEFA581 },
	{ 0x5256, 0xEFA582 },
	{ 0x5257, 0xEFA583 },
	{ 0x5259, 0xEFA584 },
	{ 0x525A, 0xEFA585 },
	{ 0x525E, 0xEFA586 },
	{ 0x525F, 0xEFA587 },
	{ 0x5261, 0xEFA588 },
	{ 0x5262, 0xEFA589 },
	{ 0x5264, 0xEFA58A },
	{ 0x5265, 0xEFA58B },
	{ 0x5266, 0xEFA58C },
	{ 0x5267, 0xEFA58D },
	{ 0x5268, 0xEFA58E },
	{ 0x5269, 0xEFA58F },
	{ 0x526A, 0xEFA590 },
	{ 0x526B, 0xEFA591 },
	{ 0x5270, 0xEFA592 },
	{ 0x5271, 0xEFA593 },
	{ 0x5272, 0xEFA594 },
	{ 0x5273, 0xEFA595 },
	{ 0x5274, 0xEFA596 },
	{ 0x5275, 0xEFA597 },
	{ 0x5277, 0xEFA598 },
	{ 0x5278, 0xEFA599 },
	{ 0x5466, 0xEFA59A },
	{ 0x547C, 0xEFA59B },
	{ 0x5525, 0xEFA59C },
	{ 0x552B, 0xEFA59D },
	{ 0x552E, 0xEFA59E },
	{ 0x5638, 0xEFA59F },
	{ 0x564D, 0xEFA5A0 },
	{ 0x574B, 0xEFA5A1 },
	{ 0x5764, 0xEFA5A2 },
	{ 0x5B45, 0xEFA5A3 },
	{ 0x5B64, 0xEFA5A4 },
	{ 0x5C25, 0xEFA5A5 },
	{ 0x5D25, 0xEFA5A6 },
	{ 0x5D55, 0xEFA5A7 },
	{ 0x5D74, 0xEFA5A8 },
	{ 0x5E7C, 0xEFA5A9 },
	{ 0x5E7E, 0xEFA5AA },
	{ 0x5F33, 0xEFA5AB },
	{ 0x5F61, 0xEFA5AC },
	{ 0x5F68, 0xEFA5AD },
	{ 0x6071, 0xEFA5AE },
	{ 0x612D, 0xEFA5AF },
	{ 0x616D, 0xEFA5B0 },
	{ 0x6375, 0xEFA5B1 },
	{ 0x6421, 0xEFA5B2 },
	{ 0x6429, 0xEFA5B3 },
	{ 0x652E, 0xEFA5B4 },
	{ 0x6531, 0xEFA5B5 },
	{ 0x6532, 0xEFA5B6 },
	{ 0x6539, 0xEFA5B7 },
	{ 0x653B, 0xEFA5B8 },
	{ 0x653C, 0xEFA5B9 },
	{ 0x6544, 0xEFA5BA },
	{ 0x654E, 0xEFA5BB },
	{ 0x6550, 0xEFA5BC },
	{ 0x6552, 0xEFA5BD },
	{ 0x6556, 0xEFA5BE },
	{ 0x657A, 0xEFA5BF },
	{ 0x657B, 0xEFA680 },
	{ 0x657C, 0xEFA681 },
	{ 0x657E, 0xEFA682 },
	{ 0x6621, 0xEFA683 },
	{ 0x6624, 0xEFA684 },
	{ 0x6627, 0xEFA685 },
	{ 0x662D, 0xEFA686 },
	{ 0x662F, 0xEFA687 },
	{ 0x6630, 0xEFA688 },
	{ 0x6631, 0xEFA689 },
	{ 0x6633, 0xEFA68A },
	{ 0x6637, 0xEFA68B },
	{ 0x6638, 0xEFA68C },
	{ 0x663C, 0xEFA68D },
	{ 0x6644, 0xEFA68E },
	{ 0x6646, 0xEFA68F },
	{ 0x6647, 0xEFA690 },
	{ 0x664A, 0xEFA691 },
	{ 0x6652, 0xEFA692 },
	{ 0x6656, 0xEFA693 },
	{ 0x6659, 0xEFA694 },
	{ 0x665C, 0xEFA695 },
	{ 0x665F, 0xEFA696 },
	{ 0x6661, 0xEFA697 },
	{ 0x6664, 0xEFA698 },
	{ 0x6665, 0xEFA699 },
	{ 0x6666, 0xEFA69A },
	{ 0x6668, 0xEFA69B },
	{ 0x666A, 0xEFA69C },
	{ 0x666B, 0xEFA69D },
	{ 0x666C, 0xEFA69E },
	{ 0x666F, 0xEFA69F },
	{ 0x6671, 0xEFA6A0 },
	{ 0x6672, 0xEFA6A1 },
	{ 0x6675, 0xEFA6A2 },
	{ 0x6676, 0xEFA6A3 },
	{ 0x6677, 0xEFA6A4 },
	{ 0x6679, 0xEFA6A5 },
	{ 0x6721, 0xEFA6A6 },
	{ 0x6726, 0xEFA6A7 },
	{ 0x6729, 0xEFA6A8 },
	{ 0x672A, 0xEFA6A9 },
	{ 0x672C, 0xEFA6AA },
	{ 0x672D, 0xEFA6AB },
	{ 0x6730, 0xEFA6AC },
	{ 0x673F, 0xEFA6AD },
	{ 0x6741, 0xEFA6AE },
	{ 0x6746, 0xEFA6AF },
	{ 0x6747, 0xEFA6B0 },
	{ 0x674B, 0xEFA6B1 },
	{ 0x674D, 0xEFA6B2 },
	{ 0x674F, 0xEFA6B3 },
	{ 0x6750, 0xEFA6B4 },
	{ 0x6753, 0xEFA6B5 },
	{ 0x675F, 0xEFA6B6 },
	{ 0x6764, 0xEFA6B7 },
	{ 0x6766, 0xEFA6B8 },
	{ 0x6777, 0xEFA6B9 },
	{ 0x6867, 0xEFA6BA },
	{ 0x6868, 0xEFA6BB },
	{ 0x6870, 0xEFA6BC },
	{ 0x6871, 0xEFA6BD },
	{ 0x6877, 0xEFA6BE },
	{ 0x6879, 0xEFA6BF },
	{ 0x687B, 0xEFA780 },
	{ 0x687E, 0xEFA781 },
	{ 0x6927, 0xEFA782 },
	{ 0x692C, 0xEFA783 },
	{ 0x694C, 0xEFA784 },
	{ 0x6977, 0xEFA785 },
	{ 0x6A41, 0xEFA786 },
	{ 0x6A65, 0xEFA787 },
	{ 0x6A74, 0xEFA788 },
	{ 0x6A77, 0xEFA789 },
	{ 0x6A7C, 0xEFA78A },
	{ 0x6A7E, 0xEFA78B },
	{ 0x6B24, 0xEFA78C },
	{ 0x6B27, 0xEFA78D },
	{ 0x6B29, 0xEFA78E },
	{ 0x6B2A, 0xEFA78F },
	{ 0x6B3A, 0xEFA790 },
	{ 0x6B3B, 0xEFA791 },
	{ 0x6B3D, 0xEFA792 },
	{ 0x6B41, 0xEFA793 },
	{ 0x6B42, 0xEFA794 },
	{ 0x6B46, 0xEFA795 },
	{ 0x6B47, 0xEFA796 },
	{ 0x6B4C, 0xEFA797 },
	{ 0x6B4F, 0xEFA798 },
	{ 0x6B50, 0xEFA799 },
	{ 0x6B51, 0xEFA79A },
	{ 0x6B52, 0xEFA79B },
	{ 0x6B58, 0xEFA79C },
	{ 0x6C26, 0xEFA79D },
	{ 0x6C27, 0xEFA79E },
	{ 0x6C2A, 0xEFA79F },
	{ 0x6C2F, 0xEFA7A0 },
	{ 0x6C30, 0xEFA7A1 },
	{ 0x6C31, 0xEFA7A2 },
	{ 0x6C32, 0xEFA7A3 },
	{ 0x6C35, 0xEFA7A4 },
	{ 0x6C38, 0xEFA7A5 },
	{ 0x6C3A, 0xEFA7A6 },
	{ 0x6C40, 0xEFA7A7 },
	{ 0x6C41, 0xEFA7A8 },
	{ 0x6C45, 0xEFA7A9 },
	{ 0x6C46, 0xEFA7AA },
	{ 0x6C49, 0xEFA7AB },
	{ 0x6C4A, 0xEFA7AC },
	{ 0x6C55, 0xEFA7AD },
	{ 0x6C5D, 0xEFA7AE },
	{ 0x6C5E, 0xEFA7AF },
	{ 0x6C61, 0xEFA7B0 },
	{ 0x6C64, 0xEFA7B1 },
	{ 0x6C67, 0xEFA7B2 },
	{ 0x6C68, 0xEFA7B3 },
	{ 0x6C77, 0xEFA7B4 },
	{ 0x6C78, 0xEFA7B5 },
	{ 0x6C7A, 0xEFA7B6 },
	{ 0x6D21, 0xEFA7B7 },
	{ 0x6D22, 0xEFA7B8 },
	{ 0x6D23, 0xEFA7B9 },
	{ 0x6D6E, 0xEFA7BA },
	{ 0x6E5B, 0xEFA7BB },
	{ 0x723D, 0xEFA7BC },
	{ 0x727A, 0xEFA7BD },
	{ 0x7331, 0xEFA7BE },
	{ 0x7427, 0xEFA7BF },
	{ 0x746E, 0xEFA880 },
	{ 0x7674, 0xEFA881 },
	{ 0x7676, 0xEFA882 },
	{ 0x7738, 0xEFA883 },
	{ 0x7748, 0xEFA884 },
	{ 0x7753, 0xEFA885 },
	{ 0x785B, 0xEFA886 },
	{ 0x7870, 0xEFA887 },
	{ 0x7A21, 0xEFA888 },
	{ 0x7A22, 0xEFA889 },
	{ 0x7A66, 0xEFA88A },
	{ 0x7C29, 0xEFA88B },
	{ 0x2321, 0xEFBC81 },
	{ 0x2322, 0xEFBC82 },
	{ 0x2323, 0xEFBC83 },
	{ 0x2324, 0xEFBC84 },
	{ 0x2325, 0xEFBC85 },
	{ 0x2326, 0xEFBC86 },
	{ 0x2327, 0xEFBC87 },
	{ 0x2328, 0xEFBC88 },
	{ 0x2329, 0xEFBC89 },
	{ 0x232A, 0xEFBC8A },
	{ 0x232B, 0xEFBC8B },
	{ 0x232C, 0xEFBC8C },
	{ 0x232D, 0xEFBC8D },
	{ 0x232E, 0xEFBC8E },
	{ 0x232F, 0xEFBC8F },
	{ 0x2330, 0xEFBC90 },
	{ 0x2331, 0xEFBC91 },
	{ 0x2332, 0xEFBC92 },
	{ 0x2333, 0xEFBC93 },
	{ 0x2334, 0xEFBC94 },
	{ 0x2335, 0xEFBC95 },
	{ 0x2336, 0xEFBC96 },
	{ 0x2337, 0xEFBC97 },
	{ 0x2338, 0xEFBC98 },
	{ 0x2339, 0xEFBC99 },
	{ 0x233A, 0xEFBC9A },
	{ 0x233B, 0xEFBC9B },
	{ 0x233C, 0xEFBC9C },
	{ 0x233D, 0xEFBC9D },
	{ 0x233E, 0xEFBC9E },
	{ 0x233F, 0xEFBC9F },
	{ 0x2340, 0xEFBCA0 },
	{ 0x2341, 0xEFBCA1 },
	{ 0x2342, 0xEFBCA2 },
	{ 0x2343, 0xEFBCA3 },
	{ 0x2344, 0xEFBCA4 },
	{ 0x2345, 0xEFBCA5 },
	{ 0x2346, 0xEFBCA6 },
	{ 0x2347, 0xEFBCA7 },
	{ 0x2348, 0xEFBCA8 },
	{ 0x2349, 0xEFBCA9 },
	{ 0x234A, 0xEFBCAA },
	{ 0x234B, 0xEFBCAB },
	{ 0x234C, 0xEFBCAC },
	{ 0x234D, 0xEFBCAD },
	{ 0x234E, 0xEFBCAE },
	{ 0x234F, 0xEFBCAF },
	{ 0x2350, 0xEFBCB0 },
	{ 0x2351, 0xEFBCB1 },
	{ 0x2352, 0xEFBCB2 },
	{ 0x2353, 0xEFBCB3 },
	{ 0x2354, 0xEFBCB4 },
	{ 0x2355, 0xEFBCB5 },
	{ 0x2356, 0xEFBCB6 },
	{ 0x2357, 0xEFBCB7 },
	{ 0x2358, 0xEFBCB8 },
	{ 0x2359, 0xEFBCB9 },
	{ 0x235A, 0xEFBCBA },
	{ 0x235B, 0xEFBCBB },
	{ 0x212C, 0xEFBCBC },
	{ 0x235D, 0xEFBCBD },
	{ 0x235E, 0xEFBCBE },
	{ 0x235F, 0xEFBCBF },
	{ 0x2360, 0xEFBD80 },
	{ 0x2361, 0xEFBD81 },
	{ 0x2362, 0xEFBD82 },
	{ 0x2363, 0xEFBD83 },
	{ 0x2364, 0xEFBD84 },
	{ 0x2365, 0xEFBD85 },
	{ 0x2366, 0xEFBD86 },
	{ 0x2367, 0xEFBD87 },
	{ 0x2368, 0xEFBD88 },
	{ 0x2369, 0xEFBD89 },
	{ 0x236A, 0xEFBD8A },
	{ 0x236B, 0xEFBD8B },
	{ 0x236C, 0xEFBD8C },
	{ 0x236D, 0xEFBD8D },
	{ 0x236E, 0xEFBD8E },
	{ 0x236F, 0xEFBD8F },
	{ 0x2370, 0xEFBD90 },
	{ 0x2371, 0xEFBD91 },
	{ 0x2372, 0xEFBD92 },
	{ 0x2373, 0xEFBD93 },
	{ 0x2374, 0xEFBD94 },
	{ 0x2375, 0xEFBD95 },
	{ 0x2376, 0xEFBD96 },
	{ 0x2377, 0xEFBD97 },
	{ 0x2378, 0xEFBD98 },
	{ 0x2379, 0xEFBD99 },
	{ 0x237A, 0xEFBD9A },
	{ 0x237B, 0xEFBD9B },
	{ 0x237C, 0xEFBD9C },
	{ 0x237D, 0xEFBD9D },
	{ 0x212D, 0xEFBD9E },
	{ 0x214B, 0xEFBFA0 },
	{ 0x214C, 0xEFBFA1 },
	{ 0x217E, 0xEFBFA2 },
	{ 0x237E, 0xEFBFA3 },
	{ 0x214D, 0xEFBFA5 },
	{ 0x235C, 0xEFBFA6 }
};


#endif	/* _UTF2ISO2022_H_ */
