/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 * under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
 */

/*
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 */



#ifndef _UTF2EUC_TABLE_H_
#define _UTF2EUC_TABLE_H_


#include "common_han.h"
#include "common_def.h"

hcode_table utf2euc_tbl[] = {
	{ 0xA2AE, 0xC2A1 },
	{ 0xA2B4, 0xC2A4 },
	{ 0xA1D7, 0xC2A7 },
	{ 0xA1A7, 0xC2A8 },
	{ 0xA8A3, 0xC2AA },
	{ 0xA1A9, 0xC2AD },
        { 0xA2E7, 0xC2AE },     /* Registered mark      */
	{ 0xA1C6, 0xC2B0 },
	{ 0xA1BE, 0xC2B1 },
	{ 0xA9F7, 0xC2B2 },
	{ 0xA9F8, 0xC2B3 },
	{ 0xA2A5, 0xC2B4 },
	{ 0xA2D2, 0xC2B6 },
	{ 0xA1A4, 0xC2B7 },
	{ 0xA2AC, 0xC2B8 },
	{ 0xA9F6, 0xC2B9 },
	{ 0xA8AC, 0xC2BA },
	{ 0xA8F9, 0xC2BC },
	{ 0xA8F6, 0xC2BD },
	{ 0xA8FA, 0xC2BE },
	{ 0xA2AF, 0xC2BF },
	{ 0xA8A1, 0xC386 },
	{ 0xA8A2, 0xC390 },
	{ 0xA1BF, 0xC397 },
	{ 0xA8AA, 0xC398 },
	{ 0xA8AD, 0xC39E },
	{ 0xA9AC, 0xC39F },
	{ 0xA9A1, 0xC3A6 },
	{ 0xA9A3, 0xC3B0 },
	{ 0xA1C0, 0xC3B7 },
	{ 0xA9AA, 0xC3B8 },
	{ 0xA9AD, 0xC3BE },
	{ 0xA9A2, 0xC491 },
	{ 0xA8A4, 0xC4A6 },
	{ 0xA9A4, 0xC4A7 },
	{ 0xA9A5, 0xC4B1 },
	{ 0xA8A6, 0xC4B2 },
	{ 0xA9A6, 0xC4B3 },
	{ 0xA9A7, 0xC4B8 },
	{ 0xA8A8, 0xC4BF },
	{ 0xA9A8, 0xC580 },
	{ 0xA8A9, 0xC581 },
	{ 0xA9A9, 0xC582 },
	{ 0xA9B0, 0xC589 },
	{ 0xA8AF, 0xC58A },
	{ 0xA9AF, 0xC58B },
	{ 0xA8AB, 0xC592 },
	{ 0xA9AB, 0xC593 },
	{ 0xA8AE, 0xC5A6 },
	{ 0xA9AE, 0xC5A7 },
	{ 0xA2A7, 0xCB87 },
	{ 0xA2B0, 0xCB90 },
	{ 0xA2A8, 0xCB98 },
	{ 0xA2AB, 0xCB99 },
	{ 0xA2AA, 0xCB9A },
	{ 0xA2AD, 0xCB9B },
	{ 0xA2A9, 0xCB9D },
	{ 0xA5C1, 0xCE91 },
	{ 0xA5C2, 0xCE92 },
	{ 0xA5C3, 0xCE93 },
	{ 0xA5C4, 0xCE94 },
	{ 0xA5C5, 0xCE95 },
	{ 0xA5C6, 0xCE96 },
	{ 0xA5C7, 0xCE97 },
	{ 0xA5C8, 0xCE98 },
	{ 0xA5C9, 0xCE99 },
	{ 0xA5CA, 0xCE9A },
	{ 0xA5CB, 0xCE9B },
	{ 0xA5CC, 0xCE9C },
	{ 0xA5CD, 0xCE9D },
	{ 0xA5CE, 0xCE9E },
	{ 0xA5CF, 0xCE9F },
	{ 0xA5D0, 0xCEA0 },
	{ 0xA5D1, 0xCEA1 },
	{ 0xA5D2, 0xCEA3 },
	{ 0xA5D3, 0xCEA4 },
	{ 0xA5D4, 0xCEA5 },
	{ 0xA5D5, 0xCEA6 },
	{ 0xA5D6, 0xCEA7 },
	{ 0xA5D7, 0xCEA8 },
	{ 0xA5D8, 0xCEA9 },
	{ 0xA5E1, 0xCEB1 },
	{ 0xA5E2, 0xCEB2 },
	{ 0xA5E3, 0xCEB3 },
	{ 0xA5E4, 0xCEB4 },
	{ 0xA5E5, 0xCEB5 },
	{ 0xA5E6, 0xCEB6 },
	{ 0xA5E7, 0xCEB7 },
	{ 0xA5E8, 0xCEB8 },
	{ 0xA5E9, 0xCEB9 },
	{ 0xA5EA, 0xCEBA },
	{ 0xA5EB, 0xCEBB },
	{ 0xA5EC, 0xCEBC },
	{ 0xA5ED, 0xCEBD },
	{ 0xA5EE, 0xCEBE },
	{ 0xA5EF, 0xCEBF },
	{ 0xA5F0, 0xCF80 },
	{ 0xA5F1, 0xCF81 },
	{ 0xA5F2, 0xCF83 },
	{ 0xA5F3, 0xCF84 },
	{ 0xA5F4, 0xCF85 },
	{ 0xA5F5, 0xCF86 },
	{ 0xA5F6, 0xCF87 },
	{ 0xA5F7, 0xCF88 },
	{ 0xA5F8, 0xCF89 },
	{ 0xACA7, 0xD081 },
	{ 0xACA1, 0xD090 },
	{ 0xACA2, 0xD091 },
	{ 0xACA3, 0xD092 },
	{ 0xACA4, 0xD093 },
	{ 0xACA5, 0xD094 },
	{ 0xACA6, 0xD095 },
	{ 0xACA8, 0xD096 },
	{ 0xACA9, 0xD097 },
	{ 0xACAA, 0xD098 },
	{ 0xACAB, 0xD099 },
	{ 0xACAC, 0xD09A },
	{ 0xACAD, 0xD09B },
	{ 0xACAE, 0xD09C },
	{ 0xACAF, 0xD09D },
	{ 0xACB0, 0xD09E },
	{ 0xACB1, 0xD09F },
	{ 0xACB2, 0xD0A0 },
	{ 0xACB3, 0xD0A1 },
	{ 0xACB4, 0xD0A2 },
	{ 0xACB5, 0xD0A3 },
	{ 0xACB6, 0xD0A4 },
	{ 0xACB7, 0xD0A5 },
	{ 0xACB8, 0xD0A6 },
	{ 0xACB9, 0xD0A7 },
	{ 0xACBA, 0xD0A8 },
	{ 0xACBB, 0xD0A9 },
	{ 0xACBC, 0xD0AA },
	{ 0xACBD, 0xD0AB },
	{ 0xACBE, 0xD0AC },
	{ 0xACBF, 0xD0AD },
	{ 0xACC0, 0xD0AE },
	{ 0xACC1, 0xD0AF },
	{ 0xACD1, 0xD0B0 },
	{ 0xACD2, 0xD0B1 },
	{ 0xACD3, 0xD0B2 },
	{ 0xACD4, 0xD0B3 },
	{ 0xACD5, 0xD0B4 },
	{ 0xACD6, 0xD0B5 },
	{ 0xACD8, 0xD0B6 },
	{ 0xACD9, 0xD0B7 },
	{ 0xACDA, 0xD0B8 },
	{ 0xACDB, 0xD0B9 },
	{ 0xACDC, 0xD0BA },
	{ 0xACDD, 0xD0BB },
	{ 0xACDE, 0xD0BC },
	{ 0xACDF, 0xD0BD },
	{ 0xACE0, 0xD0BE },
	{ 0xACE1, 0xD0BF },
	{ 0xACE2, 0xD180 },
	{ 0xACE3, 0xD181 },
	{ 0xACE4, 0xD182 },
	{ 0xACE5, 0xD183 },
	{ 0xACE6, 0xD184 },
	{ 0xACE7, 0xD185 },
	{ 0xACE8, 0xD186 },
	{ 0xACE9, 0xD187 },
	{ 0xACEA, 0xD188 },
	{ 0xACEB, 0xD189 },
	{ 0xACEC, 0xD18A },
	{ 0xACED, 0xD18B },
	{ 0xACEE, 0xD18C },
	{ 0xACEF, 0xD18D },
	{ 0xACF0, 0xD18E },
	{ 0xACF1, 0xD18F },
	{ 0xACD7, 0xD191 },
	{ 0xA1AA, 0xE28095 },
	{ 0xA1AE, 0xE28098 },
	{ 0xA1AF, 0xE28099 },
	{ 0xA1B0, 0xE2809C },
	{ 0xA1B1, 0xE2809D },
	{ 0xA2D3, 0xE280A0 },
	{ 0xA2D4, 0xE280A1 },
	{ 0xA1A5, 0xE280A5 },
	{ 0xA1A6, 0xE280A6 },
	{ 0xA2B6, 0xE280B0 },
	{ 0xA1C7, 0xE280B2 },
	{ 0xA1C8, 0xE280B3 },
	{ 0xA1D8, 0xE280BB },
	{ 0xA9F9, 0xE281B4 },
	{ 0xA9FA, 0xE281BF },
	{ 0xA9FB, 0xE28281 },
	{ 0xA9FC, 0xE28282 },
	{ 0xA9FD, 0xE28283 },
	{ 0xA9FE, 0xE28284 },
	{ 0xA2E6, 0xE282AC },   /* Euro currency symbol */
	{ 0xA1C9, 0xE28483 },
	{ 0xA2B5, 0xE28489 },
	{ 0xA7A4, 0xE28493 },
	{ 0xA2E0, 0xE28496 },
	{ 0xA2E5, 0xE284A1 },
	{ 0xA2E2, 0xE284A2 },
	{ 0xA7D9, 0xE284A6 },
	{ 0xA1CA, 0xE284AB },
	{ 0xA8F7, 0xE28593 },
	{ 0xA8F8, 0xE28594 },
	{ 0xA8FB, 0xE2859B },
	{ 0xA8FC, 0xE2859C },
	{ 0xA8FD, 0xE2859D },
	{ 0xA8FE, 0xE2859E },
	{ 0xA5B0, 0xE285A0 },
	{ 0xA5B1, 0xE285A1 },
	{ 0xA5B2, 0xE285A2 },
	{ 0xA5B3, 0xE285A3 },
	{ 0xA5B4, 0xE285A4 },
	{ 0xA5B5, 0xE285A5 },
	{ 0xA5B6, 0xE285A6 },
	{ 0xA5B7, 0xE285A7 },
	{ 0xA5B8, 0xE285A8 },
	{ 0xA5B9, 0xE285A9 },
	{ 0xA5A1, 0xE285B0 },
	{ 0xA5A2, 0xE285B1 },
	{ 0xA5A3, 0xE285B2 },
	{ 0xA5A4, 0xE285B3 },
	{ 0xA5A5, 0xE285B4 },
	{ 0xA5A6, 0xE285B5 },
	{ 0xA5A7, 0xE285B6 },
	{ 0xA5A8, 0xE285B7 },
	{ 0xA5A9, 0xE285B8 },
	{ 0xA5AA, 0xE285B9 },
	{ 0xA1E7, 0xE28690 },
	{ 0xA1E8, 0xE28691 },
	{ 0xA1E6, 0xE28692 },
	{ 0xA1E9, 0xE28693 },
	{ 0xA1EA, 0xE28694 },
	{ 0xA2D5, 0xE28695 },
	{ 0xA2D8, 0xE28696 },
	{ 0xA2D6, 0xE28697 },
	{ 0xA2D9, 0xE28698 },
	{ 0xA2D7, 0xE28699 },
	{ 0xA2A1, 0xE28792 },
	{ 0xA2A2, 0xE28794 },
	{ 0xA2A3, 0xE28880 },
	{ 0xA1D3, 0xE28882 },
	{ 0xA2A4, 0xE28883 },
	{ 0xA1D4, 0xE28887 },
	{ 0xA1F4, 0xE28888 },
	{ 0xA1F5, 0xE2888B },
	{ 0xA2B3, 0xE2888F },
	{ 0xA2B2, 0xE28891 },
	{ 0xA1EE, 0xE2889A },
	{ 0xA1F0, 0xE2889D },
	{ 0xA1C4, 0xE2889E },
	{ 0xA1D0, 0xE288A0 },
	{ 0xA1AB, 0xE288A5 },
	{ 0xA1FC, 0xE288A7 },
	{ 0xA1FD, 0xE288A8 },
	{ 0xA1FB, 0xE288A9 },
	{ 0xA1FA, 0xE288AA },
	{ 0xA1F2, 0xE288AB },
	{ 0xA1F3, 0xE288AC },
	{ 0xA2B1, 0xE288AE },
	{ 0xA1C5, 0xE288B4 },
	{ 0xA1F1, 0xE288B5 },
	{ 0xA1AD, 0xE288BC },
	{ 0xA1EF, 0xE288BD },
	{ 0xA1D6, 0xE28992 },
	{ 0xA1C1, 0xE289A0 },
	{ 0xA1D5, 0xE289A1 },
	{ 0xA1C2, 0xE289A4 },
	{ 0xA1C3, 0xE289A5 },
	{ 0xA1EC, 0xE289AA },
	{ 0xA1ED, 0xE289AB },
	{ 0xA1F8, 0xE28A82 },
	{ 0xA1F9, 0xE28A83 },
	{ 0xA1F6, 0xE28A86 },
	{ 0xA1F7, 0xE28A87 },
	{ 0xA2C1, 0xE28A99 },
	{ 0xA1D1, 0xE28AA5 },
	{ 0xA1D2, 0xE28C92 },
	{ 0xA8E7, 0xE291A0 },
	{ 0xA8E8, 0xE291A1 },
	{ 0xA8E9, 0xE291A2 },
	{ 0xA8EA, 0xE291A3 },
	{ 0xA8EB, 0xE291A4 },
	{ 0xA8EC, 0xE291A5 },
	{ 0xA8ED, 0xE291A6 },
	{ 0xA8EE, 0xE291A7 },
	{ 0xA8EF, 0xE291A8 },
	{ 0xA8F0, 0xE291A9 },
	{ 0xA8F1, 0xE291AA },
	{ 0xA8F2, 0xE291AB },
	{ 0xA8F3, 0xE291AC },
	{ 0xA8F4, 0xE291AD },
	{ 0xA8F5, 0xE291AE },
	{ 0xA9E7, 0xE291B4 },
	{ 0xA9E8, 0xE291B5 },
	{ 0xA9E9, 0xE291B6 },
	{ 0xA9EA, 0xE291B7 },
	{ 0xA9EB, 0xE291B8 },
	{ 0xA9EC, 0xE291B9 },
	{ 0xA9ED, 0xE291BA },
	{ 0xA9EE, 0xE291BB },
	{ 0xA9EF, 0xE291BC },
	{ 0xA9F0, 0xE291BD },
	{ 0xA9F1, 0xE291BE },
	{ 0xA9F2, 0xE291BF },
	{ 0xA9F3, 0xE29280 },
	{ 0xA9F4, 0xE29281 },
	{ 0xA9F5, 0xE29282 },
	{ 0xA9CD, 0xE2929C },
	{ 0xA9CE, 0xE2929D },
	{ 0xA9CF, 0xE2929E },
	{ 0xA9D0, 0xE2929F },
	{ 0xA9D1, 0xE292A0 },
	{ 0xA9D2, 0xE292A1 },
	{ 0xA9D3, 0xE292A2 },
	{ 0xA9D4, 0xE292A3 },
	{ 0xA9D5, 0xE292A4 },
	{ 0xA9D6, 0xE292A5 },
	{ 0xA9D7, 0xE292A6 },
	{ 0xA9D8, 0xE292A7 },
	{ 0xA9D9, 0xE292A8 },
	{ 0xA9DA, 0xE292A9 },
	{ 0xA9DB, 0xE292AA },
	{ 0xA9DC, 0xE292AB },
	{ 0xA9DD, 0xE292AC },
	{ 0xA9DE, 0xE292AD },
	{ 0xA9DF, 0xE292AE },
	{ 0xA9E0, 0xE292AF },
	{ 0xA9E1, 0xE292B0 },
	{ 0xA9E2, 0xE292B1 },
	{ 0xA9E3, 0xE292B2 },
	{ 0xA9E4, 0xE292B3 },
	{ 0xA9E5, 0xE292B4 },
	{ 0xA9E6, 0xE292B5 },
	{ 0xA8CD, 0xE29390 },
	{ 0xA8CE, 0xE29391 },
	{ 0xA8CF, 0xE29392 },
	{ 0xA8D0, 0xE29393 },
	{ 0xA8D1, 0xE29394 },
	{ 0xA8D2, 0xE29395 },
	{ 0xA8D3, 0xE29396 },
	{ 0xA8D4, 0xE29397 },
	{ 0xA8D5, 0xE29398 },
	{ 0xA8D6, 0xE29399 },
	{ 0xA8D7, 0xE2939A },
	{ 0xA8D8, 0xE2939B },
	{ 0xA8D9, 0xE2939C },
	{ 0xA8DA, 0xE2939D },
	{ 0xA8DB, 0xE2939E },
	{ 0xA8DC, 0xE2939F },
	{ 0xA8DD, 0xE293A0 },
	{ 0xA8DE, 0xE293A1 },
	{ 0xA8DF, 0xE293A2 },
	{ 0xA8E0, 0xE293A3 },
	{ 0xA8E1, 0xE293A4 },
	{ 0xA8E2, 0xE293A5 },
	{ 0xA8E3, 0xE293A6 },
	{ 0xA8E4, 0xE293A7 },
	{ 0xA8E5, 0xE293A8 },
	{ 0xA8E6, 0xE293A9 },
	{ 0xA6A1, 0xE29480 },
	{ 0xA6AC, 0xE29481 },
	{ 0xA6A2, 0xE29482 },
	{ 0xA6AD, 0xE29483 },
	{ 0xA6A3, 0xE2948C },
	{ 0xA6C8, 0xE2948D },
	{ 0xA6C7, 0xE2948E },
	{ 0xA6AE, 0xE2948F },
	{ 0xA6A4, 0xE29490 },
	{ 0xA6C2, 0xE29491 },
	{ 0xA6C1, 0xE29492 },
	{ 0xA6AF, 0xE29493 },
	{ 0xA6A6, 0xE29494 },
	{ 0xA6C6, 0xE29495 },
	{ 0xA6C5, 0xE29496 },
	{ 0xA6B1, 0xE29497 },
	{ 0xA6A5, 0xE29498 },
	{ 0xA6C4, 0xE29499 },
	{ 0xA6C3, 0xE2949A },
	{ 0xA6B0, 0xE2949B },
	{ 0xA6A7, 0xE2949C },
	{ 0xA6BC, 0xE2949D },
	{ 0xA6C9, 0xE2949E },
	{ 0xA6CA, 0xE2949F },
	{ 0xA6B7, 0xE294A0 },
	{ 0xA6CB, 0xE294A1 },
	{ 0xA6CC, 0xE294A2 },
	{ 0xA6B2, 0xE294A3 },
	{ 0xA6A9, 0xE294A4 },
	{ 0xA6BE, 0xE294A5 },
	{ 0xA6CD, 0xE294A6 },
	{ 0xA6CE, 0xE294A7 },
	{ 0xA6B9, 0xE294A8 },
	{ 0xA6CF, 0xE294A9 },
	{ 0xA6D0, 0xE294AA },
	{ 0xA6B4, 0xE294AB },
	{ 0xA6A8, 0xE294AC },
	{ 0xA6D1, 0xE294AD },
	{ 0xA6D2, 0xE294AE },
	{ 0xA6B8, 0xE294AF },
	{ 0xA6BD, 0xE294B0 },
	{ 0xA6D3, 0xE294B1 },
	{ 0xA6D4, 0xE294B2 },
	{ 0xA6B3, 0xE294B3 },
	{ 0xA6AA, 0xE294B4 },
	{ 0xA6D5, 0xE294B5 },
	{ 0xA6D6, 0xE294B6 },
	{ 0xA6BA, 0xE294B7 },
	{ 0xA6BF, 0xE294B8 },
	{ 0xA6D7, 0xE294B9 },
	{ 0xA6D8, 0xE294BA },
	{ 0xA6B5, 0xE294BB },
	{ 0xA6AB, 0xE294BC },
	{ 0xA6D9, 0xE294BD },
	{ 0xA6DA, 0xE294BE },
	{ 0xA6BB, 0xE294BF },
	{ 0xA6DB, 0xE29580 },
	{ 0xA6DC, 0xE29581 },
	{ 0xA6C0, 0xE29582 },
	{ 0xA6DD, 0xE29583 },
	{ 0xA6DE, 0xE29584 },
	{ 0xA6DF, 0xE29585 },
	{ 0xA6E0, 0xE29586 },
	{ 0xA6E1, 0xE29587 },
	{ 0xA6E2, 0xE29588 },
	{ 0xA6E3, 0xE29589 },
	{ 0xA6E4, 0xE2958A },
	{ 0xA6B6, 0xE2958B },
	{ 0xA2C6, 0xE29692 },
	{ 0xA1E1, 0xE296A0 },
	{ 0xA1E0, 0xE296A1 },
	{ 0xA2C3, 0xE296A3 },
	{ 0xA2C7, 0xE296A4 },
	{ 0xA2C8, 0xE296A5 },
	{ 0xA2CB, 0xE296A6 },
	{ 0xA2CA, 0xE296A7 },
	{ 0xA2C9, 0xE296A8 },
	{ 0xA2CC, 0xE296A9 },
	{ 0xA1E3, 0xE296B2 },
	{ 0xA1E2, 0xE296B3 },
	{ 0xA2BA, 0xE296B6 },
	{ 0xA2B9, 0xE296B7 },
	{ 0xA1E5, 0xE296BC },
	{ 0xA1E4, 0xE296BD },
	{ 0xA2B8, 0xE29780 },
	{ 0xA2B7, 0xE29781 },
	{ 0xA1DF, 0xE29786 },
	{ 0xA1DE, 0xE29787 },
	{ 0xA2C2, 0xE29788 },
	{ 0xA1DB, 0xE2978B },
	{ 0xA1DD, 0xE2978E },
	{ 0xA1DC, 0xE2978F },
	{ 0xA2C4, 0xE29790 },
	{ 0xA2C5, 0xE29791 },
	{ 0xA1DA, 0xE29885 },
	{ 0xA1D9, 0xE29886 },
	{ 0xA2CF, 0xE2988E },
	{ 0xA2CE, 0xE2988F },
	{ 0xA2D0, 0xE2989C },
	{ 0xA2D1, 0xE2989E },
	{ 0xA1CF, 0xE29980 },
	{ 0xA1CE, 0xE29982 },
	{ 0xA2BC, 0xE299A0 },
	{ 0xA2BD, 0xE299A1 },
	{ 0xA2C0, 0xE299A3 },
	{ 0xA2BB, 0xE299A4 },
	{ 0xA2BE, 0xE299A5 },
	{ 0xA2BF, 0xE299A7 },
	{ 0xA2CD, 0xE299A8 },
	{ 0xA2DB, 0xE299A9 },
	{ 0xA2DC, 0xE299AA },
	{ 0xA2DD, 0xE299AC },
	{ 0xA2DA, 0xE299AD },
	{ 0xA1A1, 0xE38080 },
	{ 0xA1A2, 0xE38081 },
	{ 0xA1A3, 0xE38082 },
	{ 0xA1A8, 0xE38083 },
	{ 0xA1B4, 0xE38088 },
	{ 0xA1B5, 0xE38089 },
	{ 0xA1B6, 0xE3808A },
	{ 0xA1B7, 0xE3808B },
	{ 0xA1B8, 0xE3808C },
	{ 0xA1B9, 0xE3808D },
	{ 0xA1BA, 0xE3808E },
	{ 0xA1BB, 0xE3808F },
	{ 0xA1BC, 0xE38090 },
	{ 0xA1BD, 0xE38091 },
	{ 0xA1EB, 0xE38093 },
	{ 0xA1B2, 0xE38094 },
	{ 0xA1B3, 0xE38095 },
	{ 0xAAA1, 0xE38181 },
	{ 0xAAA2, 0xE38182 },
	{ 0xAAA3, 0xE38183 },
	{ 0xAAA4, 0xE38184 },
	{ 0xAAA5, 0xE38185 },
	{ 0xAAA6, 0xE38186 },
	{ 0xAAA7, 0xE38187 },
	{ 0xAAA8, 0xE38188 },
	{ 0xAAA9, 0xE38189 },
	{ 0xAAAA, 0xE3818A },
	{ 0xAAAB, 0xE3818B },
	{ 0xAAAC, 0xE3818C },
	{ 0xAAAD, 0xE3818D },
	{ 0xAAAE, 0xE3818E },
	{ 0xAAAF, 0xE3818F },
	{ 0xAAB0, 0xE38190 },
	{ 0xAAB1, 0xE38191 },
	{ 0xAAB2, 0xE38192 },
	{ 0xAAB3, 0xE38193 },
	{ 0xAAB4, 0xE38194 },
	{ 0xAAB5, 0xE38195 },
	{ 0xAAB6, 0xE38196 },
	{ 0xAAB7, 0xE38197 },
	{ 0xAAB8, 0xE38198 },
	{ 0xAAB9, 0xE38199 },
	{ 0xAABA, 0xE3819A },
	{ 0xAABB, 0xE3819B },
	{ 0xAABC, 0xE3819C },
	{ 0xAABD, 0xE3819D },
	{ 0xAABE, 0xE3819E },
	{ 0xAABF, 0xE3819F },
	{ 0xAAC0, 0xE381A0 },
	{ 0xAAC1, 0xE381A1 },
	{ 0xAAC2, 0xE381A2 },
	{ 0xAAC3, 0xE381A3 },
	{ 0xAAC4, 0xE381A4 },
	{ 0xAAC5, 0xE381A5 },
	{ 0xAAC6, 0xE381A6 },
	{ 0xAAC7, 0xE381A7 },
	{ 0xAAC8, 0xE381A8 },
	{ 0xAAC9, 0xE381A9 },
	{ 0xAACA, 0xE381AA },
	{ 0xAACB, 0xE381AB },
	{ 0xAACC, 0xE381AC },
	{ 0xAACD, 0xE381AD },
	{ 0xAACE, 0xE381AE },
	{ 0xAACF, 0xE381AF },
	{ 0xAAD0, 0xE381B0 },
	{ 0xAAD1, 0xE381B1 },
	{ 0xAAD2, 0xE381B2 },
	{ 0xAAD3, 0xE381B3 },
	{ 0xAAD4, 0xE381B4 },
	{ 0xAAD5, 0xE381B5 },
	{ 0xAAD6, 0xE381B6 },
	{ 0xAAD7, 0xE381B7 },
	{ 0xAAD8, 0xE381B8 },
	{ 0xAAD9, 0xE381B9 },
	{ 0xAADA, 0xE381BA },
	{ 0xAADB, 0xE381BB },
	{ 0xAADC, 0xE381BC },
	{ 0xAADD, 0xE381BD },
	{ 0xAADE, 0xE381BE },
	{ 0xAADF, 0xE381BF },
	{ 0xAAE0, 0xE38280 },
	{ 0xAAE1, 0xE38281 },
	{ 0xAAE2, 0xE38282 },
	{ 0xAAE3, 0xE38283 },
	{ 0xAAE4, 0xE38284 },
	{ 0xAAE5, 0xE38285 },
	{ 0xAAE6, 0xE38286 },
	{ 0xAAE7, 0xE38287 },
	{ 0xAAE8, 0xE38288 },
	{ 0xAAE9, 0xE38289 },
	{ 0xAAEA, 0xE3828A },
	{ 0xAAEB, 0xE3828B },
	{ 0xAAEC, 0xE3828C },
	{ 0xAAED, 0xE3828D },
	{ 0xAAEE, 0xE3828E },
	{ 0xAAEF, 0xE3828F },
	{ 0xAAF0, 0xE38290 },
	{ 0xAAF1, 0xE38291 },
	{ 0xAAF2, 0xE38292 },
	{ 0xAAF3, 0xE38293 },
	{ 0xABA1, 0xE382A1 },
	{ 0xABA2, 0xE382A2 },
	{ 0xABA3, 0xE382A3 },
	{ 0xABA4, 0xE382A4 },
	{ 0xABA5, 0xE382A5 },
	{ 0xABA6, 0xE382A6 },
	{ 0xABA7, 0xE382A7 },
	{ 0xABA8, 0xE382A8 },
	{ 0xABA9, 0xE382A9 },
	{ 0xABAA, 0xE382AA },
	{ 0xABAB, 0xE382AB },
	{ 0xABAC, 0xE382AC },
	{ 0xABAD, 0xE382AD },
	{ 0xABAE, 0xE382AE },
	{ 0xABAF, 0xE382AF },
	{ 0xABB0, 0xE382B0 },
	{ 0xABB1, 0xE382B1 },
	{ 0xABB2, 0xE382B2 },
	{ 0xABB3, 0xE382B3 },
	{ 0xABB4, 0xE382B4 },
	{ 0xABB5, 0xE382B5 },
	{ 0xABB6, 0xE382B6 },
	{ 0xABB7, 0xE382B7 },
	{ 0xABB8, 0xE382B8 },
	{ 0xABB9, 0xE382B9 },
	{ 0xABBA, 0xE382BA },
	{ 0xABBB, 0xE382BB },
	{ 0xABBC, 0xE382BC },
	{ 0xABBD, 0xE382BD },
	{ 0xABBE, 0xE382BE },
	{ 0xABBF, 0xE382BF },
	{ 0xABC0, 0xE38380 },
	{ 0xABC1, 0xE38381 },
	{ 0xABC2, 0xE38382 },
	{ 0xABC3, 0xE38383 },
	{ 0xABC4, 0xE38384 },
	{ 0xABC5, 0xE38385 },
	{ 0xABC6, 0xE38386 },
	{ 0xABC7, 0xE38387 },
	{ 0xABC8, 0xE38388 },
	{ 0xABC9, 0xE38389 },
	{ 0xABCA, 0xE3838A },
	{ 0xABCB, 0xE3838B },
	{ 0xABCC, 0xE3838C },
	{ 0xABCD, 0xE3838D },
	{ 0xABCE, 0xE3838E },
	{ 0xABCF, 0xE3838F },
	{ 0xABD0, 0xE38390 },
	{ 0xABD1, 0xE38391 },
	{ 0xABD2, 0xE38392 },
	{ 0xABD3, 0xE38393 },
	{ 0xABD4, 0xE38394 },
	{ 0xABD5, 0xE38395 },
	{ 0xABD6, 0xE38396 },
	{ 0xABD7, 0xE38397 },
	{ 0xABD8, 0xE38398 },
	{ 0xABD9, 0xE38399 },
	{ 0xABDA, 0xE3839A },
	{ 0xABDB, 0xE3839B },
	{ 0xABDC, 0xE3839C },
	{ 0xABDD, 0xE3839D },
	{ 0xABDE, 0xE3839E },
	{ 0xABDF, 0xE3839F },
	{ 0xABE0, 0xE383A0 },
	{ 0xABE1, 0xE383A1 },
	{ 0xABE2, 0xE383A2 },
	{ 0xABE3, 0xE383A3 },
	{ 0xABE4, 0xE383A4 },
	{ 0xABE5, 0xE383A5 },
	{ 0xABE6, 0xE383A6 },
	{ 0xABE7, 0xE383A7 },
	{ 0xABE8, 0xE383A8 },
	{ 0xABE9, 0xE383A9 },
	{ 0xABEA, 0xE383AA },
	{ 0xABEB, 0xE383AB },
	{ 0xABEC, 0xE383AC },
	{ 0xABED, 0xE383AD },
	{ 0xABEE, 0xE383AE },
	{ 0xABEF, 0xE383AF },
	{ 0xABF0, 0xE383B0 },
	{ 0xABF1, 0xE383B1 },
	{ 0xABF2, 0xE383B2 },
	{ 0xABF3, 0xE383B3 },
	{ 0xABF4, 0xE383B4 },
	{ 0xABF5, 0xE383B5 },
	{ 0xABF6, 0xE383B6 },
	{ 0xA4A1, 0xE384B1 },
	{ 0xA4A2, 0xE384B2 },
	{ 0xA4A3, 0xE384B3 },
	{ 0xA4A4, 0xE384B4 },
	{ 0xA4A5, 0xE384B5 },
	{ 0xA4A6, 0xE384B6 },
	{ 0xA4A7, 0xE384B7 },
	{ 0xA4A8, 0xE384B8 },
	{ 0xA4A9, 0xE384B9 },
	{ 0xA4AA, 0xE384BA },
	{ 0xA4AB, 0xE384BB },
	{ 0xA4AC, 0xE384BC },
	{ 0xA4AD, 0xE384BD },
	{ 0xA4AE, 0xE384BE },
	{ 0xA4AF, 0xE384BF },
	{ 0xA4B0, 0xE38580 },
	{ 0xA4B1, 0xE38581 },
	{ 0xA4B2, 0xE38582 },
	{ 0xA4B3, 0xE38583 },
	{ 0xA4B4, 0xE38584 },
	{ 0xA4B5, 0xE38585 },
	{ 0xA4B6, 0xE38586 },
	{ 0xA4B7, 0xE38587 },
	{ 0xA4B8, 0xE38588 },
	{ 0xA4B9, 0xE38589 },
	{ 0xA4BA, 0xE3858A },
	{ 0xA4BB, 0xE3858B },
	{ 0xA4BC, 0xE3858C },
	{ 0xA4BD, 0xE3858D },
	{ 0xA4BE, 0xE3858E },
	{ 0xA4BF, 0xE3858F },
	{ 0xA4C0, 0xE38590 },
	{ 0xA4C1, 0xE38591 },
	{ 0xA4C2, 0xE38592 },
	{ 0xA4C3, 0xE38593 },
	{ 0xA4C4, 0xE38594 },
	{ 0xA4C5, 0xE38595 },
	{ 0xA4C6, 0xE38596 },
	{ 0xA4C7, 0xE38597 },
	{ 0xA4C8, 0xE38598 },
	{ 0xA4C9, 0xE38599 },
	{ 0xA4CA, 0xE3859A },
	{ 0xA4CB, 0xE3859B },
	{ 0xA4CC, 0xE3859C },
	{ 0xA4CD, 0xE3859D },
	{ 0xA4CE, 0xE3859E },
	{ 0xA4CF, 0xE3859F },
	{ 0xA4D0, 0xE385A0 },
	{ 0xA4D1, 0xE385A1 },
	{ 0xA4D2, 0xE385A2 },
	{ 0xA4D3, 0xE385A3 },
	{ 0xA4D4, 0xE385A4 },
	{ 0xA4D5, 0xE385A5 },
	{ 0xA4D6, 0xE385A6 },
	{ 0xA4D7, 0xE385A7 },
	{ 0xA4D8, 0xE385A8 },
	{ 0xA4D9, 0xE385A9 },
	{ 0xA4DA, 0xE385AA },
	{ 0xA4DB, 0xE385AB },
	{ 0xA4DC, 0xE385AC },
	{ 0xA4DD, 0xE385AD },
	{ 0xA4DE, 0xE385AE },
	{ 0xA4DF, 0xE385AF },
	{ 0xA4E0, 0xE385B0 },
	{ 0xA4E1, 0xE385B1 },
	{ 0xA4E2, 0xE385B2 },
	{ 0xA4E3, 0xE385B3 },
	{ 0xA4E4, 0xE385B4 },
	{ 0xA4E5, 0xE385B5 },
	{ 0xA4E6, 0xE385B6 },
	{ 0xA4E7, 0xE385B7 },
	{ 0xA4E8, 0xE385B8 },
	{ 0xA4E9, 0xE385B9 },
	{ 0xA4EA, 0xE385BA },
	{ 0xA4EB, 0xE385BB },
	{ 0xA4EC, 0xE385BC },
	{ 0xA4ED, 0xE385BD },
	{ 0xA4EE, 0xE385BE },
	{ 0xA4EF, 0xE385BF },
	{ 0xA4F0, 0xE38680 },
	{ 0xA4F1, 0xE38681 },
	{ 0xA4F2, 0xE38682 },
	{ 0xA4F3, 0xE38683 },
	{ 0xA4F4, 0xE38684 },
	{ 0xA4F5, 0xE38685 },
	{ 0xA4F6, 0xE38686 },
	{ 0xA4F7, 0xE38687 },
	{ 0xA4F8, 0xE38688 },
	{ 0xA4F9, 0xE38689 },
	{ 0xA4FA, 0xE3868A },
	{ 0xA4FB, 0xE3868B },
	{ 0xA4FC, 0xE3868C },
	{ 0xA4FD, 0xE3868D },
	{ 0xA4FE, 0xE3868E },
	{ 0xA9B1, 0xE38880 },
	{ 0xA9B2, 0xE38881 },
	{ 0xA9B3, 0xE38882 },
	{ 0xA9B4, 0xE38883 },
	{ 0xA9B5, 0xE38884 },
	{ 0xA9B6, 0xE38885 },
	{ 0xA9B7, 0xE38886 },
	{ 0xA9B8, 0xE38887 },
	{ 0xA9B9, 0xE38888 },
	{ 0xA9BA, 0xE38889 },
	{ 0xA9BB, 0xE3888A },
	{ 0xA9BC, 0xE3888B },
	{ 0xA9BD, 0xE3888C },
	{ 0xA9BE, 0xE3888D },
	{ 0xA9BF, 0xE3888E },
	{ 0xA9C0, 0xE3888F },
	{ 0xA9C1, 0xE38890 },
	{ 0xA9C2, 0xE38891 },
	{ 0xA9C3, 0xE38892 },
	{ 0xA9C4, 0xE38893 },
	{ 0xA9C5, 0xE38894 },
	{ 0xA9C6, 0xE38895 },
	{ 0xA9C7, 0xE38896 },
	{ 0xA9C8, 0xE38897 },
	{ 0xA9C9, 0xE38898 },
	{ 0xA9CA, 0xE38899 },
	{ 0xA9CB, 0xE3889A },
	{ 0xA9CC, 0xE3889B },
	{ 0xA2DF, 0xE3889C },
	{ 0xA8B1, 0xE389A0 },
	{ 0xA8B2, 0xE389A1 },
	{ 0xA8B3, 0xE389A2 },
	{ 0xA8B4, 0xE389A3 },
	{ 0xA8B5, 0xE389A4 },
	{ 0xA8B6, 0xE389A5 },
	{ 0xA8B7, 0xE389A6 },
	{ 0xA8B8, 0xE389A7 },
	{ 0xA8B9, 0xE389A8 },
	{ 0xA8BA, 0xE389A9 },
	{ 0xA8BB, 0xE389AA },
	{ 0xA8BC, 0xE389AB },
	{ 0xA8BD, 0xE389AC },
	{ 0xA8BE, 0xE389AD },
	{ 0xA8BF, 0xE389AE },
	{ 0xA8C0, 0xE389AF },
	{ 0xA8C1, 0xE389B0 },
	{ 0xA8C2, 0xE389B1 },
	{ 0xA8C3, 0xE389B2 },
	{ 0xA8C4, 0xE389B3 },
	{ 0xA8C5, 0xE389B4 },
	{ 0xA8C6, 0xE389B5 },
	{ 0xA8C7, 0xE389B6 },
	{ 0xA8C8, 0xE389B7 },
	{ 0xA8C9, 0xE389B8 },
	{ 0xA8CA, 0xE389B9 },
	{ 0xA8CB, 0xE389BA },
	{ 0xA8CC, 0xE389BB },
	{ 0xA2DE, 0xE389BF },
	{ 0xA7C9, 0xE38E80 },
	{ 0xA7CA, 0xE38E81 },
	{ 0xA7CB, 0xE38E82 },
	{ 0xA7CC, 0xE38E83 },
	{ 0xA7CD, 0xE38E84 },
	{ 0xA7BA, 0xE38E88 },
	{ 0xA7BB, 0xE38E89 },
	{ 0xA7DC, 0xE38E8A },
	{ 0xA7DD, 0xE38E8B },
	{ 0xA7DE, 0xE38E8C },
	{ 0xA7B6, 0xE38E8D },
	{ 0xA7B7, 0xE38E8E },
	{ 0xA7B8, 0xE38E8F },
	{ 0xA7D4, 0xE38E90 },
	{ 0xA7D5, 0xE38E91 },
	{ 0xA7D6, 0xE38E92 },
	{ 0xA7D7, 0xE38E93 },
	{ 0xA7D8, 0xE38E94 },
	{ 0xA7A1, 0xE38E95 },
	{ 0xA7A2, 0xE38E96 },
	{ 0xA7A3, 0xE38E97 },
	{ 0xA7A5, 0xE38E98 },
	{ 0xA7AB, 0xE38E99 },
	{ 0xA7AC, 0xE38E9A },
	{ 0xA7AD, 0xE38E9B },
	{ 0xA7AE, 0xE38E9C },
	{ 0xA7AF, 0xE38E9D },
	{ 0xA7B0, 0xE38E9E },
	{ 0xA7B1, 0xE38E9F },
	{ 0xA7B2, 0xE38EA0 },
	{ 0xA7B3, 0xE38EA1 },
	{ 0xA7B4, 0xE38EA2 },
	{ 0xA7A7, 0xE38EA3 },
	{ 0xA7A8, 0xE38EA4 },
	{ 0xA7A9, 0xE38EA5 },
	{ 0xA7AA, 0xE38EA6 },
	{ 0xA7BD, 0xE38EA7 },
	{ 0xA7BE, 0xE38EA8 },
	{ 0xA7E5, 0xE38EA9 },
	{ 0xA7E6, 0xE38EAA },
	{ 0xA7E7, 0xE38EAB },
	{ 0xA7E8, 0xE38EAC },
	{ 0xA7E1, 0xE38EAD },
	{ 0xA7E2, 0xE38EAE },
	{ 0xA7E3, 0xE38EAF },
	{ 0xA7BF, 0xE38EB0 },
	{ 0xA7C0, 0xE38EB1 },
	{ 0xA7C1, 0xE38EB2 },
	{ 0xA7C2, 0xE38EB3 },
	{ 0xA7C3, 0xE38EB4 },
	{ 0xA7C4, 0xE38EB5 },
	{ 0xA7C5, 0xE38EB6 },
	{ 0xA7C6, 0xE38EB7 },
	{ 0xA7C7, 0xE38EB8 },
	{ 0xA7C8, 0xE38EB9 },
	{ 0xA7CE, 0xE38EBA },
	{ 0xA7CF, 0xE38EBB },
	{ 0xA7D0, 0xE38EBC },
	{ 0xA7D1, 0xE38EBD },
	{ 0xA7D2, 0xE38EBE },
	{ 0xA7D3, 0xE38EBF },
	{ 0xA7DA, 0xE38F80 },
	{ 0xA7DB, 0xE38F81 },
	{ 0xA2E3, 0xE38F82 },
	{ 0xA7EC, 0xE38F83 },
	{ 0xA7A6, 0xE38F84 },
	{ 0xA7E0, 0xE38F85 },
	{ 0xA7EF, 0xE38F86 },
	{ 0xA2E1, 0xE38F87 },
	{ 0xA7BC, 0xE38F88 },
	{ 0xA7ED, 0xE38F89 },
	{ 0xA7B5, 0xE38F8A },
	{ 0xA7B9, 0xE38F8F },
	{ 0xA7EA, 0xE38F90 },
	{ 0xA7EB, 0xE38F93 },
	{ 0xA7DF, 0xE38F96 },
	{ 0xA2E4, 0xE38F98 },
	{ 0xA7E4, 0xE38F9B },
	{ 0xA7EE, 0xE38F9C },
	{ 0xA7E9, 0xE38F9D },
	{ 0xB0A1, 0xE39080 },
	{ 0xB0A2, 0xE39081 },
	{ 0xB0A3, 0xE39082 },
	{ 0xB0A4, 0xE39083 },
	{ 0xB0A5, 0xE39084 },
	{ 0xB0A6, 0xE39085 },
	{ 0xB0A7, 0xE39086 },
	{ 0xB0A8, 0xE39087 },
	{ 0xB0A9, 0xE39088 },
	{ 0xB0AA, 0xE39089 },
	{ 0xB0AB, 0xE3908A },
	{ 0xB0AC, 0xE3908B },
	{ 0xB0AD, 0xE3908C },
	{ 0xB0AE, 0xE3908D },
	{ 0xB0AF, 0xE3908E },
	{ 0xB0B0, 0xE3908F },
	{ 0xB0B1, 0xE39090 },
	{ 0xB0B2, 0xE39091 },
	{ 0xB0B3, 0xE39092 },
	{ 0xB0B4, 0xE39093 },
	{ 0xB0B5, 0xE39094 },
	{ 0xB0B6, 0xE39095 },
	{ 0xB0B7, 0xE39096 },
	{ 0xB0B8, 0xE39097 },
	{ 0xB0B9, 0xE39098 },
	{ 0xB0BA, 0xE39099 },
	{ 0xB0BB, 0xE3909A },
	{ 0xB0BC, 0xE3909B },
	{ 0xB0BD, 0xE3909C },
	{ 0xB0BE, 0xE3909D },
	{ 0xB0BF, 0xE3909E },
	{ 0xB0C0, 0xE3909F },
	{ 0xB0C1, 0xE390A0 },
	{ 0xB0C2, 0xE390A1 },
	{ 0xB0C3, 0xE390A2 },
	{ 0xB0C4, 0xE390A3 },
	{ 0xB0C5, 0xE390A4 },
	{ 0xB0C6, 0xE390A5 },
	{ 0xB0C7, 0xE390A6 },
	{ 0xB0C8, 0xE390A7 },
	{ 0xB0C9, 0xE390A8 },
	{ 0xB0CA, 0xE390A9 },
	{ 0xB0CB, 0xE390AA },
	{ 0xB0CC, 0xE390AB },
	{ 0xB0CD, 0xE390AC },
	{ 0xB0CE, 0xE390AD },
	{ 0xB0CF, 0xE390AE },
	{ 0xB0D0, 0xE390AF },
	{ 0xB0D1, 0xE390B0 },
	{ 0xB0D2, 0xE390B1 },
	{ 0xB0D3, 0xE390B2 },
	{ 0xB0D4, 0xE390B3 },
	{ 0xB0D5, 0xE390B4 },
	{ 0xB0D6, 0xE390B5 },
	{ 0xB0D7, 0xE390B6 },
	{ 0xB0D8, 0xE390B7 },
	{ 0xB0D9, 0xE390B8 },
	{ 0xB0DA, 0xE390B9 },
	{ 0xB0DB, 0xE390BA },
	{ 0xB0DC, 0xE390BB },
	{ 0xB0DD, 0xE390BC },
	{ 0xB0DE, 0xE390BD },
	{ 0xB0DF, 0xE390BE },
	{ 0xB0E0, 0xE390BF },
	{ 0xB0E1, 0xE39180 },
	{ 0xB0E2, 0xE39181 },
	{ 0xB0E3, 0xE39182 },
	{ 0xB0E4, 0xE39183 },
	{ 0xB0E5, 0xE39184 },
	{ 0xB0E6, 0xE39185 },
	{ 0xB0E7, 0xE39186 },
	{ 0xB0E8, 0xE39187 },
	{ 0xB0E9, 0xE39188 },
	{ 0xB0EA, 0xE39189 },
	{ 0xB0EB, 0xE3918A },
	{ 0xB0EC, 0xE3918B },
	{ 0xB0ED, 0xE3918C },
	{ 0xB0EE, 0xE3918D },
	{ 0xB0EF, 0xE3918E },
	{ 0xB0F0, 0xE3918F },
	{ 0xB0F1, 0xE39190 },
	{ 0xB0F2, 0xE39191 },
	{ 0xB0F3, 0xE39192 },
	{ 0xB0F4, 0xE39193 },
	{ 0xB0F5, 0xE39194 },
	{ 0xB0F6, 0xE39195 },
	{ 0xB0F7, 0xE39196 },
	{ 0xB0F8, 0xE39197 },
	{ 0xB0F9, 0xE39198 },
	{ 0xB0FA, 0xE39199 },
	{ 0xB0FB, 0xE3919A },
	{ 0xB0FC, 0xE3919B },
	{ 0xB0FD, 0xE3919C },
	{ 0xB0FE, 0xE3919D },
	{ 0xB1A1, 0xE3919E },
	{ 0xB1A2, 0xE3919F },
	{ 0xB1A3, 0xE391A0 },
	{ 0xB1A4, 0xE391A1 },
	{ 0xB1A5, 0xE391A2 },
	{ 0xB1A6, 0xE391A3 },
	{ 0xB1A7, 0xE391A4 },
	{ 0xB1A8, 0xE391A5 },
	{ 0xB1A9, 0xE391A6 },
	{ 0xB1AA, 0xE391A7 },
	{ 0xB1AB, 0xE391A8 },
	{ 0xB1AC, 0xE391A9 },
	{ 0xB1AD, 0xE391AA },
	{ 0xB1AE, 0xE391AB },
	{ 0xB1AF, 0xE391AC },
	{ 0xB1B0, 0xE391AD },
	{ 0xB1B1, 0xE391AE },
	{ 0xB1B2, 0xE391AF },
	{ 0xB1B3, 0xE391B0 },
	{ 0xB1B4, 0xE391B1 },
	{ 0xB1B5, 0xE391B2 },
	{ 0xB1B6, 0xE391B3 },
	{ 0xB1B7, 0xE391B4 },
	{ 0xB1B8, 0xE391B5 },
	{ 0xB1B9, 0xE391B6 },
	{ 0xB1BA, 0xE391B7 },
	{ 0xB1BB, 0xE391B8 },
	{ 0xB1BC, 0xE391B9 },
	{ 0xB1BD, 0xE391BA },
	{ 0xB1BE, 0xE391BB },
	{ 0xB1BF, 0xE391BC },
	{ 0xB1C0, 0xE391BD },
	{ 0xB1C1, 0xE391BE },
	{ 0xB1C2, 0xE391BF },
	{ 0xB1C3, 0xE39280 },
	{ 0xB1C4, 0xE39281 },
	{ 0xB1C5, 0xE39282 },
	{ 0xB1C6, 0xE39283 },
	{ 0xB1C7, 0xE39284 },
	{ 0xB1C8, 0xE39285 },
	{ 0xB1C9, 0xE39286 },
	{ 0xB1CA, 0xE39287 },
	{ 0xB1CB, 0xE39288 },
	{ 0xB1CC, 0xE39289 },
	{ 0xB1CD, 0xE3928A },
	{ 0xB1CE, 0xE3928B },
	{ 0xB1CF, 0xE3928C },
	{ 0xB1D0, 0xE3928D },
	{ 0xB1D1, 0xE3928E },
	{ 0xB1D2, 0xE3928F },
	{ 0xB1D3, 0xE39290 },
	{ 0xB1D4, 0xE39291 },
	{ 0xB1D5, 0xE39292 },
	{ 0xB1D6, 0xE39293 },
	{ 0xB1D7, 0xE39294 },
	{ 0xB1D8, 0xE39295 },
	{ 0xB1D9, 0xE39296 },
	{ 0xB1DA, 0xE39297 },
	{ 0xB1DB, 0xE39298 },
	{ 0xB1DC, 0xE39299 },
	{ 0xB1DD, 0xE3929A },
	{ 0xB1DE, 0xE3929B },
	{ 0xB1DF, 0xE3929C },
	{ 0xB1E0, 0xE3929D },
	{ 0xB1E1, 0xE3929E },
	{ 0xB1E2, 0xE3929F },
	{ 0xB1E3, 0xE392A0 },
	{ 0xB1E4, 0xE392A1 },
	{ 0xB1E5, 0xE392A2 },
	{ 0xB1E6, 0xE392A3 },
	{ 0xB1E7, 0xE392A4 },
	{ 0xB1E8, 0xE392A5 },
	{ 0xB1E9, 0xE392A6 },
	{ 0xB1EA, 0xE392A7 },
	{ 0xB1EB, 0xE392A8 },
	{ 0xB1EC, 0xE392A9 },
	{ 0xB1ED, 0xE392AA },
	{ 0xB1EE, 0xE392AB },
	{ 0xB1EF, 0xE392AC },
	{ 0xB1F0, 0xE392AD },
	{ 0xB1F1, 0xE392AE },
	{ 0xB1F2, 0xE392AF },
	{ 0xB1F3, 0xE392B0 },
	{ 0xB1F4, 0xE392B1 },
	{ 0xB1F5, 0xE392B2 },
	{ 0xB1F6, 0xE392B3 },
	{ 0xB1F7, 0xE392B4 },
	{ 0xB1F8, 0xE392B5 },
	{ 0xB1F9, 0xE392B6 },
	{ 0xB1FA, 0xE392B7 },
	{ 0xB1FB, 0xE392B8 },
	{ 0xB1FC, 0xE392B9 },
	{ 0xB1FD, 0xE392BA },
	{ 0xB1FE, 0xE392BB },
	{ 0xB2A1, 0xE392BC },
	{ 0xB2A2, 0xE392BD },
	{ 0xB2A3, 0xE392BE },
	{ 0xB2A4, 0xE392BF },
	{ 0xB2A5, 0xE39380 },
	{ 0xB2A6, 0xE39381 },
	{ 0xB2A7, 0xE39382 },
	{ 0xB2A8, 0xE39383 },
	{ 0xB2A9, 0xE39384 },
	{ 0xB2AA, 0xE39385 },
	{ 0xB2AB, 0xE39386 },
	{ 0xB2AC, 0xE39387 },
	{ 0xB2AD, 0xE39388 },
	{ 0xB2AE, 0xE39389 },
	{ 0xB2AF, 0xE3938A },
	{ 0xB2B0, 0xE3938B },
	{ 0xB2B1, 0xE3938C },
	{ 0xB2B2, 0xE3938D },
	{ 0xB2B3, 0xE3938E },
	{ 0xB2B4, 0xE3938F },
	{ 0xB2B5, 0xE39390 },
	{ 0xB2B6, 0xE39391 },
	{ 0xB2B7, 0xE39392 },
	{ 0xB2B8, 0xE39393 },
	{ 0xB2B9, 0xE39394 },
	{ 0xB2BA, 0xE39395 },
	{ 0xB2BB, 0xE39396 },
	{ 0xB2BC, 0xE39397 },
	{ 0xB2BD, 0xE39398 },
	{ 0xB2BE, 0xE39399 },
	{ 0xB2BF, 0xE3939A },
	{ 0xB2C0, 0xE3939B },
	{ 0xB2C1, 0xE3939C },
	{ 0xB2C2, 0xE3939D },
	{ 0xB2C3, 0xE3939E },
	{ 0xB2C4, 0xE3939F },
	{ 0xB2C5, 0xE393A0 },
	{ 0xB2C6, 0xE393A1 },
	{ 0xB2C7, 0xE393A2 },
	{ 0xB2C8, 0xE393A3 },
	{ 0xB2C9, 0xE393A4 },
	{ 0xB2CA, 0xE393A5 },
	{ 0xB2CB, 0xE393A6 },
	{ 0xB2CC, 0xE393A7 },
	{ 0xB2CD, 0xE393A8 },
	{ 0xB2CE, 0xE393A9 },
	{ 0xB2CF, 0xE393AA },
	{ 0xB2D0, 0xE393AB },
	{ 0xB2D1, 0xE393AC },
	{ 0xB2D2, 0xE393AD },
	{ 0xB2D3, 0xE393AE },
	{ 0xB2D4, 0xE393AF },
	{ 0xB2D5, 0xE393B0 },
	{ 0xB2D6, 0xE393B1 },
	{ 0xB2D7, 0xE393B2 },
	{ 0xB2D8, 0xE393B3 },
	{ 0xB2D9, 0xE393B4 },
	{ 0xB2DA, 0xE393B5 },
	{ 0xB2DB, 0xE393B6 },
	{ 0xB2DC, 0xE393B7 },
	{ 0xB2DD, 0xE393B8 },
	{ 0xB2DE, 0xE393B9 },
	{ 0xB2DF, 0xE393BA },
	{ 0xB2E0, 0xE393BB },
	{ 0xB2E1, 0xE393BC },
	{ 0xB2E2, 0xE393BD },
	{ 0xB2E3, 0xE393BE },
	{ 0xB2E4, 0xE393BF },
	{ 0xB2E5, 0xE39480 },
	{ 0xB2E6, 0xE39481 },
	{ 0xB2E7, 0xE39482 },
	{ 0xB2E8, 0xE39483 },
	{ 0xB2E9, 0xE39484 },
	{ 0xB2EA, 0xE39485 },
	{ 0xB2EB, 0xE39486 },
	{ 0xB2EC, 0xE39487 },
	{ 0xB2ED, 0xE39488 },
	{ 0xB2EE, 0xE39489 },
	{ 0xB2EF, 0xE3948A },
	{ 0xB2F0, 0xE3948B },
	{ 0xB2F1, 0xE3948C },
	{ 0xB2F2, 0xE3948D },
	{ 0xB2F3, 0xE3948E },
	{ 0xB2F4, 0xE3948F },
	{ 0xB2F5, 0xE39490 },
	{ 0xB2F6, 0xE39491 },
	{ 0xB2F7, 0xE39492 },
	{ 0xB2F8, 0xE39493 },
	{ 0xB2F9, 0xE39494 },
	{ 0xB2FA, 0xE39495 },
	{ 0xB2FB, 0xE39496 },
	{ 0xB2FC, 0xE39497 },
	{ 0xB2FD, 0xE39498 },
	{ 0xB2FE, 0xE39499 },
	{ 0xB3A1, 0xE3949A },
	{ 0xB3A2, 0xE3949B },
	{ 0xB3A3, 0xE3949C },
	{ 0xB3A4, 0xE3949D },
	{ 0xB3A5, 0xE3949E },
	{ 0xB3A6, 0xE3949F },
	{ 0xB3A7, 0xE394A0 },
	{ 0xB3A8, 0xE394A1 },
	{ 0xB3A9, 0xE394A2 },
	{ 0xB3AA, 0xE394A3 },
	{ 0xB3AB, 0xE394A4 },
	{ 0xB3AC, 0xE394A5 },
	{ 0xB3AD, 0xE394A6 },
	{ 0xB3AE, 0xE394A7 },
	{ 0xB3AF, 0xE394A8 },
	{ 0xB3B0, 0xE394A9 },
	{ 0xB3B1, 0xE394AA },
	{ 0xB3B2, 0xE394AB },
	{ 0xB3B3, 0xE394AC },
	{ 0xB3B4, 0xE394AD },
	{ 0xB3B5, 0xE394AE },
	{ 0xB3B6, 0xE394AF },
	{ 0xB3B7, 0xE394B0 },
	{ 0xB3B8, 0xE394B1 },
	{ 0xB3B9, 0xE394B2 },
	{ 0xB3BA, 0xE394B3 },
	{ 0xB3BB, 0xE394B4 },
	{ 0xB3BC, 0xE394B5 },
	{ 0xB3BD, 0xE394B6 },
	{ 0xB3BE, 0xE394B7 },
	{ 0xB3BF, 0xE394B8 },
	{ 0xB3C0, 0xE394B9 },
	{ 0xB3C1, 0xE394BA },
	{ 0xB3C2, 0xE394BB },
	{ 0xB3C3, 0xE394BC },
	{ 0xB3C4, 0xE394BD },
	{ 0xB3C5, 0xE394BE },
	{ 0xB3C6, 0xE394BF },
	{ 0xB3C7, 0xE39580 },
	{ 0xB3C8, 0xE39581 },
	{ 0xB3C9, 0xE39582 },
	{ 0xB3CA, 0xE39583 },
	{ 0xB3CB, 0xE39584 },
	{ 0xB3CC, 0xE39585 },
	{ 0xB3CD, 0xE39586 },
	{ 0xB3CE, 0xE39587 },
	{ 0xB3CF, 0xE39588 },
	{ 0xB3D0, 0xE39589 },
	{ 0xB3D1, 0xE3958A },
	{ 0xB3D2, 0xE3958B },
	{ 0xB3D3, 0xE3958C },
	{ 0xB3D4, 0xE3958D },
	{ 0xB3D5, 0xE3958E },
	{ 0xB3D6, 0xE3958F },
	{ 0xB3D7, 0xE39590 },
	{ 0xB3D8, 0xE39591 },
	{ 0xB3D9, 0xE39592 },
	{ 0xB3DA, 0xE39593 },
	{ 0xB3DB, 0xE39594 },
	{ 0xB3DC, 0xE39595 },
	{ 0xB3DD, 0xE39596 },
	{ 0xB3DE, 0xE39597 },
	{ 0xB3DF, 0xE39598 },
	{ 0xB3E0, 0xE39599 },
	{ 0xB3E1, 0xE3959A },
	{ 0xB3E2, 0xE3959B },
	{ 0xB3E3, 0xE3959C },
	{ 0xB3E4, 0xE3959D },
	{ 0xB3E5, 0xE3959E },
	{ 0xB3E6, 0xE3959F },
	{ 0xB3E7, 0xE395A0 },
	{ 0xB3E8, 0xE395A1 },
	{ 0xB3E9, 0xE395A2 },
	{ 0xB3EA, 0xE395A3 },
	{ 0xB3EB, 0xE395A4 },
	{ 0xB3EC, 0xE395A5 },
	{ 0xB3ED, 0xE395A6 },
	{ 0xB3EE, 0xE395A7 },
	{ 0xB3EF, 0xE395A8 },
	{ 0xB3F0, 0xE395A9 },
	{ 0xB3F1, 0xE395AA },
	{ 0xB3F2, 0xE395AB },
	{ 0xB3F3, 0xE395AC },
	{ 0xB3F4, 0xE395AD },
	{ 0xB3F5, 0xE395AE },
	{ 0xB3F6, 0xE395AF },
	{ 0xB3F7, 0xE395B0 },
	{ 0xB3F8, 0xE395B1 },
	{ 0xB3F9, 0xE395B2 },
	{ 0xB3FA, 0xE395B3 },
	{ 0xB3FB, 0xE395B4 },
	{ 0xB3FC, 0xE395B5 },
	{ 0xB3FD, 0xE395B6 },
	{ 0xB3FE, 0xE395B7 },
	{ 0xB4A1, 0xE395B8 },
	{ 0xB4A2, 0xE395B9 },
	{ 0xB4A3, 0xE395BA },
	{ 0xB4A4, 0xE395BB },
	{ 0xB4A5, 0xE395BC },
	{ 0xB4A6, 0xE395BD },
	{ 0xB4A7, 0xE395BE },
	{ 0xB4A8, 0xE395BF },
	{ 0xB4A9, 0xE39680 },
	{ 0xB4AA, 0xE39681 },
	{ 0xB4AB, 0xE39682 },
	{ 0xB4AC, 0xE39683 },
	{ 0xB4AD, 0xE39684 },
	{ 0xB4AE, 0xE39685 },
	{ 0xB4AF, 0xE39686 },
	{ 0xB4B0, 0xE39687 },
	{ 0xB4B1, 0xE39688 },
	{ 0xB4B2, 0xE39689 },
	{ 0xB4B3, 0xE3968A },
	{ 0xB4B4, 0xE3968B },
	{ 0xB4B5, 0xE3968C },
	{ 0xB4B6, 0xE3968D },
	{ 0xB4B7, 0xE3968E },
	{ 0xB4B8, 0xE3968F },
	{ 0xB4B9, 0xE39690 },
	{ 0xB4BA, 0xE39691 },
	{ 0xB4BB, 0xE39692 },
	{ 0xB4BC, 0xE39693 },
	{ 0xB4BD, 0xE39694 },
	{ 0xB4BE, 0xE39695 },
	{ 0xB4BF, 0xE39696 },
	{ 0xB4C0, 0xE39697 },
	{ 0xB4C1, 0xE39698 },
	{ 0xB4C2, 0xE39699 },
	{ 0xB4C3, 0xE3969A },
	{ 0xB4C4, 0xE3969B },
	{ 0xB4C5, 0xE3969C },
	{ 0xB4C6, 0xE3969D },
	{ 0xB4C7, 0xE3969E },
	{ 0xB4C8, 0xE3969F },
	{ 0xB4C9, 0xE396A0 },
	{ 0xB4CA, 0xE396A1 },
	{ 0xB4CB, 0xE396A2 },
	{ 0xB4CC, 0xE396A3 },
	{ 0xB4CD, 0xE396A4 },
	{ 0xB4CE, 0xE396A5 },
	{ 0xB4CF, 0xE396A6 },
	{ 0xB4D0, 0xE396A7 },
	{ 0xB4D1, 0xE396A8 },
	{ 0xB4D2, 0xE396A9 },
	{ 0xB4D3, 0xE396AA },
	{ 0xB4D4, 0xE396AB },
	{ 0xB4D5, 0xE396AC },
	{ 0xB4D6, 0xE396AD },
	{ 0xB4D7, 0xE396AE },
	{ 0xB4D8, 0xE396AF },
	{ 0xB4D9, 0xE396B0 },
	{ 0xB4DA, 0xE396B1 },
	{ 0xB4DB, 0xE396B2 },
	{ 0xB4DC, 0xE396B3 },
	{ 0xB4DD, 0xE396B4 },
	{ 0xB4DE, 0xE396B5 },
	{ 0xB4DF, 0xE396B6 },
	{ 0xB4E0, 0xE396B7 },
	{ 0xB4E1, 0xE396B8 },
	{ 0xB4E2, 0xE396B9 },
	{ 0xB4E3, 0xE396BA },
	{ 0xB4E4, 0xE396BB },
	{ 0xB4E5, 0xE396BC },
	{ 0xB4E6, 0xE396BD },
	{ 0xB4E7, 0xE396BE },
	{ 0xB4E8, 0xE396BF },
	{ 0xB4E9, 0xE39780 },
	{ 0xB4EA, 0xE39781 },
	{ 0xB4EB, 0xE39782 },
	{ 0xB4EC, 0xE39783 },
	{ 0xB4ED, 0xE39784 },
	{ 0xB4EE, 0xE39785 },
	{ 0xB4EF, 0xE39786 },
	{ 0xB4F0, 0xE39787 },
	{ 0xB4F1, 0xE39788 },
	{ 0xB4F2, 0xE39789 },
	{ 0xB4F3, 0xE3978A },
	{ 0xB4F4, 0xE3978B },
	{ 0xB4F5, 0xE3978C },
	{ 0xB4F6, 0xE3978D },
	{ 0xB4F7, 0xE3978E },
	{ 0xB4F8, 0xE3978F },
	{ 0xB4F9, 0xE39790 },
	{ 0xB4FA, 0xE39791 },
	{ 0xB4FB, 0xE39792 },
	{ 0xB4FC, 0xE39793 },
	{ 0xB4FD, 0xE39794 },
	{ 0xB4FE, 0xE39795 },
	{ 0xB5A1, 0xE39796 },
	{ 0xB5A2, 0xE39797 },
	{ 0xB5A3, 0xE39798 },
	{ 0xB5A4, 0xE39799 },
	{ 0xB5A5, 0xE3979A },
	{ 0xB5A6, 0xE3979B },
	{ 0xB5A7, 0xE3979C },
	{ 0xB5A8, 0xE3979D },
	{ 0xB5A9, 0xE3979E },
	{ 0xB5AA, 0xE3979F },
	{ 0xB5AB, 0xE397A0 },
	{ 0xB5AC, 0xE397A1 },
	{ 0xB5AD, 0xE397A2 },
	{ 0xB5AE, 0xE397A3 },
	{ 0xB5AF, 0xE397A4 },
	{ 0xB5B0, 0xE397A5 },
	{ 0xB5B1, 0xE397A6 },
	{ 0xB5B2, 0xE397A7 },
	{ 0xB5B3, 0xE397A8 },
	{ 0xB5B4, 0xE397A9 },
	{ 0xB5B5, 0xE397AA },
	{ 0xB5B6, 0xE397AB },
	{ 0xB5B7, 0xE397AC },
	{ 0xB5B8, 0xE397AD },
	{ 0xB5B9, 0xE397AE },
	{ 0xB5BA, 0xE397AF },
	{ 0xB5BB, 0xE397B0 },
	{ 0xB5BC, 0xE397B1 },
	{ 0xB5BD, 0xE397B2 },
	{ 0xB5BE, 0xE397B3 },
	{ 0xB5BF, 0xE397B4 },
	{ 0xB5C0, 0xE397B5 },
	{ 0xB5C1, 0xE397B6 },
	{ 0xB5C2, 0xE397B7 },
	{ 0xB5C3, 0xE397B8 },
	{ 0xB5C4, 0xE397B9 },
	{ 0xB5C5, 0xE397BA },
	{ 0xB5C6, 0xE397BB },
	{ 0xB5C7, 0xE397BC },
	{ 0xB5C8, 0xE397BD },
	{ 0xB5C9, 0xE397BE },
	{ 0xB5CA, 0xE397BF },
	{ 0xB5CB, 0xE39880 },
	{ 0xB5CC, 0xE39881 },
	{ 0xB5CD, 0xE39882 },
	{ 0xB5CE, 0xE39883 },
	{ 0xB5CF, 0xE39884 },
	{ 0xB5D0, 0xE39885 },
	{ 0xB5D1, 0xE39886 },
	{ 0xB5D2, 0xE39887 },
	{ 0xB5D3, 0xE39888 },
	{ 0xB5D4, 0xE39889 },
	{ 0xB5D5, 0xE3988A },
	{ 0xB5D6, 0xE3988B },
	{ 0xB5D7, 0xE3988C },
	{ 0xB5D8, 0xE3988D },
	{ 0xB5D9, 0xE3988E },
	{ 0xB5DA, 0xE3988F },
	{ 0xB5DB, 0xE39890 },
	{ 0xB5DC, 0xE39891 },
	{ 0xB5DD, 0xE39892 },
	{ 0xB5DE, 0xE39893 },
	{ 0xB5DF, 0xE39894 },
	{ 0xB5E0, 0xE39895 },
	{ 0xB5E1, 0xE39896 },
	{ 0xB5E2, 0xE39897 },
	{ 0xB5E3, 0xE39898 },
	{ 0xB5E4, 0xE39899 },
	{ 0xB5E5, 0xE3989A },
	{ 0xB5E6, 0xE3989B },
	{ 0xB5E7, 0xE3989C },
	{ 0xB5E8, 0xE3989D },
	{ 0xB5E9, 0xE3989E },
	{ 0xB5EA, 0xE3989F },
	{ 0xB5EB, 0xE398A0 },
	{ 0xB5EC, 0xE398A1 },
	{ 0xB5ED, 0xE398A2 },
	{ 0xB5EE, 0xE398A3 },
	{ 0xB5EF, 0xE398A4 },
	{ 0xB5F0, 0xE398A5 },
	{ 0xB5F1, 0xE398A6 },
	{ 0xB5F2, 0xE398A7 },
	{ 0xB5F3, 0xE398A8 },
	{ 0xB5F4, 0xE398A9 },
	{ 0xB5F5, 0xE398AA },
	{ 0xB5F6, 0xE398AB },
	{ 0xB5F7, 0xE398AC },
	{ 0xB5F8, 0xE398AD },
	{ 0xB5F9, 0xE398AE },
	{ 0xB5FA, 0xE398AF },
	{ 0xB5FB, 0xE398B0 },
	{ 0xB5FC, 0xE398B1 },
	{ 0xB5FD, 0xE398B2 },
	{ 0xB5FE, 0xE398B3 },
	{ 0xB6A1, 0xE398B4 },
	{ 0xB6A2, 0xE398B5 },
	{ 0xB6A3, 0xE398B6 },
	{ 0xB6A4, 0xE398B7 },
	{ 0xB6A5, 0xE398B8 },
	{ 0xB6A6, 0xE398B9 },
	{ 0xB6A7, 0xE398BA },
	{ 0xB6A8, 0xE398BB },
	{ 0xB6A9, 0xE398BC },
	{ 0xB6AA, 0xE398BD },
	{ 0xB6AB, 0xE398BE },
	{ 0xB6AC, 0xE398BF },
	{ 0xB6AD, 0xE39980 },
	{ 0xB6AE, 0xE39981 },
	{ 0xB6AF, 0xE39982 },
	{ 0xB6B0, 0xE39983 },
	{ 0xB6B1, 0xE39984 },
	{ 0xB6B2, 0xE39985 },
	{ 0xB6B3, 0xE39986 },
	{ 0xB6B4, 0xE39987 },
	{ 0xB6B5, 0xE39988 },
	{ 0xB6B6, 0xE39989 },
	{ 0xB6B7, 0xE3998A },
	{ 0xB6B8, 0xE3998B },
	{ 0xB6B9, 0xE3998C },
	{ 0xB6BA, 0xE3998D },
	{ 0xB6BB, 0xE3998E },
	{ 0xB6BC, 0xE3998F },
	{ 0xB6BD, 0xE39990 },
	{ 0xB6BE, 0xE39991 },
	{ 0xB6BF, 0xE39992 },
	{ 0xB6C0, 0xE39993 },
	{ 0xB6C1, 0xE39994 },
	{ 0xB6C2, 0xE39995 },
	{ 0xB6C3, 0xE39996 },
	{ 0xB6C4, 0xE39997 },
	{ 0xB6C5, 0xE39998 },
	{ 0xB6C6, 0xE39999 },
	{ 0xB6C7, 0xE3999A },
	{ 0xB6C8, 0xE3999B },
	{ 0xB6C9, 0xE3999C },
	{ 0xB6CA, 0xE3999D },
	{ 0xB6CB, 0xE3999E },
	{ 0xB6CC, 0xE3999F },
	{ 0xB6CD, 0xE399A0 },
	{ 0xB6CE, 0xE399A1 },
	{ 0xB6CF, 0xE399A2 },
	{ 0xB6D0, 0xE399A3 },
	{ 0xB6D1, 0xE399A4 },
	{ 0xB6D2, 0xE399A5 },
	{ 0xB6D3, 0xE399A6 },
	{ 0xB6D4, 0xE399A7 },
	{ 0xB6D5, 0xE399A8 },
	{ 0xB6D6, 0xE399A9 },
	{ 0xB6D7, 0xE399AA },
	{ 0xB6D8, 0xE399AB },
	{ 0xB6D9, 0xE399AC },
	{ 0xB6DA, 0xE399AD },
	{ 0xB6DB, 0xE399AE },
	{ 0xB6DC, 0xE399AF },
	{ 0xB6DD, 0xE399B0 },
	{ 0xB6DE, 0xE399B1 },
	{ 0xB6DF, 0xE399B2 },
	{ 0xB6E0, 0xE399B3 },
	{ 0xB6E1, 0xE399B4 },
	{ 0xB6E2, 0xE399B5 },
	{ 0xB6E3, 0xE399B6 },
	{ 0xB6E4, 0xE399B7 },
	{ 0xB6E5, 0xE399B8 },
	{ 0xB6E6, 0xE399B9 },
	{ 0xB6E7, 0xE399BA },
	{ 0xB6E8, 0xE399BB },
	{ 0xB6E9, 0xE399BC },
	{ 0xB6EA, 0xE399BD },
	{ 0xB6EB, 0xE399BE },
	{ 0xB6EC, 0xE399BF },
	{ 0xB6ED, 0xE39A80 },
	{ 0xB6EE, 0xE39A81 },
	{ 0xB6EF, 0xE39A82 },
	{ 0xB6F0, 0xE39A83 },
	{ 0xB6F1, 0xE39A84 },
	{ 0xB6F2, 0xE39A85 },
	{ 0xB6F3, 0xE39A86 },
	{ 0xB6F4, 0xE39A87 },
	{ 0xB6F5, 0xE39A88 },
	{ 0xB6F6, 0xE39A89 },
	{ 0xB6F7, 0xE39A8A },
	{ 0xB6F8, 0xE39A8B },
	{ 0xB6F9, 0xE39A8C },
	{ 0xB6FA, 0xE39A8D },
	{ 0xB6FB, 0xE39A8E },
	{ 0xB6FC, 0xE39A8F },
	{ 0xB6FD, 0xE39A90 },
	{ 0xB6FE, 0xE39A91 },
	{ 0xB7A1, 0xE39A92 },
	{ 0xB7A2, 0xE39A93 },
	{ 0xB7A3, 0xE39A94 },
	{ 0xB7A4, 0xE39A95 },
	{ 0xB7A5, 0xE39A96 },
	{ 0xB7A6, 0xE39A97 },
	{ 0xB7A7, 0xE39A98 },
	{ 0xB7A8, 0xE39A99 },
	{ 0xB7A9, 0xE39A9A },
	{ 0xB7AA, 0xE39A9B },
	{ 0xB7AB, 0xE39A9C },
	{ 0xB7AC, 0xE39A9D },
	{ 0xB7AD, 0xE39A9E },
	{ 0xB7AE, 0xE39A9F },
	{ 0xB7AF, 0xE39AA0 },
	{ 0xB7B0, 0xE39AA1 },
	{ 0xB7B1, 0xE39AA2 },
	{ 0xB7B2, 0xE39AA3 },
	{ 0xB7B3, 0xE39AA4 },
	{ 0xB7B4, 0xE39AA5 },
	{ 0xB7B5, 0xE39AA6 },
	{ 0xB7B6, 0xE39AA7 },
	{ 0xB7B7, 0xE39AA8 },
	{ 0xB7B8, 0xE39AA9 },
	{ 0xB7B9, 0xE39AAA },
	{ 0xB7BA, 0xE39AAB },
	{ 0xB7BB, 0xE39AAC },
	{ 0xB7BC, 0xE39AAD },
	{ 0xB7BD, 0xE39AAE },
	{ 0xB7BE, 0xE39AAF },
	{ 0xB7BF, 0xE39AB0 },
	{ 0xB7C0, 0xE39AB1 },
	{ 0xB7C1, 0xE39AB2 },
	{ 0xB7C2, 0xE39AB3 },
	{ 0xB7C3, 0xE39AB4 },
	{ 0xB7C4, 0xE39AB5 },
	{ 0xB7C5, 0xE39AB6 },
	{ 0xB7C6, 0xE39AB7 },
	{ 0xB7C7, 0xE39AB8 },
	{ 0xB7C8, 0xE39AB9 },
	{ 0xB7C9, 0xE39ABA },
	{ 0xB7CA, 0xE39ABB },
	{ 0xB7CB, 0xE39ABC },
	{ 0xB7CC, 0xE39ABD },
	{ 0xB7CD, 0xE39ABE },
	{ 0xB7CE, 0xE39ABF },
	{ 0xB7CF, 0xE39B80 },
	{ 0xB7D0, 0xE39B81 },
	{ 0xB7D1, 0xE39B82 },
	{ 0xB7D2, 0xE39B83 },
	{ 0xB7D3, 0xE39B84 },
	{ 0xB7D4, 0xE39B85 },
	{ 0xB7D5, 0xE39B86 },
	{ 0xB7D6, 0xE39B87 },
	{ 0xB7D7, 0xE39B88 },
	{ 0xB7D8, 0xE39B89 },
	{ 0xB7D9, 0xE39B8A },
	{ 0xB7DA, 0xE39B8B },
	{ 0xB7DB, 0xE39B8C },
	{ 0xB7DC, 0xE39B8D },
	{ 0xB7DD, 0xE39B8E },
	{ 0xB7DE, 0xE39B8F },
	{ 0xB7DF, 0xE39B90 },
	{ 0xB7E0, 0xE39B91 },
	{ 0xB7E1, 0xE39B92 },
	{ 0xB7E2, 0xE39B93 },
	{ 0xB7E3, 0xE39B94 },
	{ 0xB7E4, 0xE39B95 },
	{ 0xB7E5, 0xE39B96 },
	{ 0xB7E6, 0xE39B97 },
	{ 0xB7E7, 0xE39B98 },
	{ 0xB7E8, 0xE39B99 },
	{ 0xB7E9, 0xE39B9A },
	{ 0xB7EA, 0xE39B9B },
	{ 0xB7EB, 0xE39B9C },
	{ 0xB7EC, 0xE39B9D },
	{ 0xB7ED, 0xE39B9E },
	{ 0xB7EE, 0xE39B9F },
	{ 0xB7EF, 0xE39BA0 },
	{ 0xB7F0, 0xE39BA1 },
	{ 0xB7F1, 0xE39BA2 },
	{ 0xB7F2, 0xE39BA3 },
	{ 0xB7F3, 0xE39BA4 },
	{ 0xB7F4, 0xE39BA5 },
	{ 0xB7F5, 0xE39BA6 },
	{ 0xB7F6, 0xE39BA7 },
	{ 0xB7F7, 0xE39BA8 },
	{ 0xB7F8, 0xE39BA9 },
	{ 0xB7F9, 0xE39BAA },
	{ 0xB7FA, 0xE39BAB },
	{ 0xB7FB, 0xE39BAC },
	{ 0xB7FC, 0xE39BAD },
	{ 0xB7FD, 0xE39BAE },
	{ 0xB7FE, 0xE39BAF },
	{ 0xB8A1, 0xE39BB0 },
	{ 0xB8A2, 0xE39BB1 },
	{ 0xB8A3, 0xE39BB2 },
	{ 0xB8A4, 0xE39BB3 },
	{ 0xB8A5, 0xE39BB4 },
	{ 0xB8A6, 0xE39BB5 },
	{ 0xB8A7, 0xE39BB6 },
	{ 0xB8A8, 0xE39BB7 },
	{ 0xB8A9, 0xE39BB8 },
	{ 0xB8AA, 0xE39BB9 },
	{ 0xB8AB, 0xE39BBA },
	{ 0xB8AC, 0xE39BBB },
	{ 0xB8AD, 0xE39BBC },
	{ 0xB8AE, 0xE39BBD },
	{ 0xB8AF, 0xE39BBE },
	{ 0xB8B0, 0xE39BBF },
	{ 0xB8B1, 0xE39C80 },
	{ 0xB8B2, 0xE39C81 },
	{ 0xB8B3, 0xE39C82 },
	{ 0xB8B4, 0xE39C83 },
	{ 0xB8B5, 0xE39C84 },
	{ 0xB8B6, 0xE39C85 },
	{ 0xB8B7, 0xE39C86 },
	{ 0xB8B8, 0xE39C87 },
	{ 0xB8B9, 0xE39C88 },
	{ 0xB8BA, 0xE39C89 },
	{ 0xB8BB, 0xE39C8A },
	{ 0xB8BC, 0xE39C8B },
	{ 0xB8BD, 0xE39C8C },
	{ 0xB8BE, 0xE39C8D },
	{ 0xB8BF, 0xE39C8E },
	{ 0xB8C0, 0xE39C8F },
	{ 0xB8C1, 0xE39C90 },
	{ 0xB8C2, 0xE39C91 },
	{ 0xB8C3, 0xE39C92 },
	{ 0xB8C4, 0xE39C93 },
	{ 0xB8C5, 0xE39C94 },
	{ 0xB8C6, 0xE39C95 },
	{ 0xB8C7, 0xE39C96 },
	{ 0xB8C8, 0xE39C97 },
	{ 0xB8C9, 0xE39C98 },
	{ 0xB8CA, 0xE39C99 },
	{ 0xB8CB, 0xE39C9A },
	{ 0xB8CC, 0xE39C9B },
	{ 0xB8CD, 0xE39C9C },
	{ 0xB8CE, 0xE39C9D },
	{ 0xB8CF, 0xE39C9E },
	{ 0xB8D0, 0xE39C9F },
	{ 0xB8D1, 0xE39CA0 },
	{ 0xB8D2, 0xE39CA1 },
	{ 0xB8D3, 0xE39CA2 },
	{ 0xB8D4, 0xE39CA3 },
	{ 0xB8D5, 0xE39CA4 },
	{ 0xB8D6, 0xE39CA5 },
	{ 0xB8D7, 0xE39CA6 },
	{ 0xB8D8, 0xE39CA7 },
	{ 0xB8D9, 0xE39CA8 },
	{ 0xB8DA, 0xE39CA9 },
	{ 0xB8DB, 0xE39CAA },
	{ 0xB8DC, 0xE39CAB },
	{ 0xB8DD, 0xE39CAC },
	{ 0xB8DE, 0xE39CAD },
	{ 0xB8DF, 0xE39CAE },
	{ 0xB8E0, 0xE39CAF },
	{ 0xB8E1, 0xE39CB0 },
	{ 0xB8E2, 0xE39CB1 },
	{ 0xB8E3, 0xE39CB2 },
	{ 0xB8E4, 0xE39CB3 },
	{ 0xB8E5, 0xE39CB4 },
	{ 0xB8E6, 0xE39CB5 },
	{ 0xB8E7, 0xE39CB6 },
	{ 0xB8E8, 0xE39CB7 },
	{ 0xB8E9, 0xE39CB8 },
	{ 0xB8EA, 0xE39CB9 },
	{ 0xB8EB, 0xE39CBA },
	{ 0xB8EC, 0xE39CBB },
	{ 0xB8ED, 0xE39CBC },
	{ 0xB8EE, 0xE39CBD },
	{ 0xB8EF, 0xE39CBE },
	{ 0xB8F0, 0xE39CBF },
	{ 0xB8F1, 0xE39D80 },
	{ 0xB8F2, 0xE39D81 },
	{ 0xB8F3, 0xE39D82 },
	{ 0xB8F4, 0xE39D83 },
	{ 0xB8F5, 0xE39D84 },
	{ 0xB8F6, 0xE39D85 },
	{ 0xB8F7, 0xE39D86 },
	{ 0xB8F8, 0xE39D87 },
	{ 0xB8F9, 0xE39D88 },
	{ 0xB8FA, 0xE39D89 },
	{ 0xB8FB, 0xE39D8A },
	{ 0xB8FC, 0xE39D8B },
	{ 0xB8FD, 0xE39D8C },
	{ 0xB8FE, 0xE39D8D },
	{ 0xB9A1, 0xE39D8E },
	{ 0xB9A2, 0xE39D8F },
	{ 0xB9A3, 0xE39D90 },
	{ 0xB9A4, 0xE39D91 },
	{ 0xB9A5, 0xE39D92 },
	{ 0xB9A6, 0xE39D93 },
	{ 0xB9A7, 0xE39D94 },
	{ 0xB9A8, 0xE39D95 },
	{ 0xB9A9, 0xE39D96 },
	{ 0xB9AA, 0xE39D97 },
	{ 0xB9AB, 0xE39D98 },
	{ 0xB9AC, 0xE39D99 },
	{ 0xB9AD, 0xE39D9A },
	{ 0xB9AE, 0xE39D9B },
	{ 0xB9AF, 0xE39D9C },
	{ 0xB9B0, 0xE39D9D },
	{ 0xB9B1, 0xE39D9E },
	{ 0xB9B2, 0xE39D9F },
	{ 0xB9B3, 0xE39DA0 },
	{ 0xB9B4, 0xE39DA1 },
	{ 0xB9B5, 0xE39DA2 },
	{ 0xB9B6, 0xE39DA3 },
	{ 0xB9B7, 0xE39DA4 },
	{ 0xB9B8, 0xE39DA5 },
	{ 0xB9B9, 0xE39DA6 },
	{ 0xB9BA, 0xE39DA7 },
	{ 0xB9BB, 0xE39DA8 },
	{ 0xB9BC, 0xE39DA9 },
	{ 0xB9BD, 0xE39DAA },
	{ 0xB9BE, 0xE39DAB },
	{ 0xB9BF, 0xE39DAC },
	{ 0xB9C0, 0xE39DAD },
	{ 0xB9C1, 0xE39DAE },
	{ 0xB9C2, 0xE39DAF },
	{ 0xB9C3, 0xE39DB0 },
	{ 0xB9C4, 0xE39DB1 },
	{ 0xB9C5, 0xE39DB2 },
	{ 0xB9C6, 0xE39DB3 },
	{ 0xB9C7, 0xE39DB4 },
	{ 0xB9C8, 0xE39DB5 },
	{ 0xB9C9, 0xE39DB6 },
	{ 0xB9CA, 0xE39DB7 },
	{ 0xB9CB, 0xE39DB8 },
	{ 0xB9CC, 0xE39DB9 },
	{ 0xB9CD, 0xE39DBA },
	{ 0xB9CE, 0xE39DBB },
	{ 0xB9CF, 0xE39DBC },
	{ 0xB9D0, 0xE39DBD },
	{ 0xB9D1, 0xE39DBE },
	{ 0xB9D2, 0xE39DBF },
	{ 0xB9D3, 0xE39E80 },
	{ 0xB9D4, 0xE39E81 },
	{ 0xB9D5, 0xE39E82 },
	{ 0xB9D6, 0xE39E83 },
	{ 0xB9D7, 0xE39E84 },
	{ 0xB9D8, 0xE39E85 },
	{ 0xB9D9, 0xE39E86 },
	{ 0xB9DA, 0xE39E87 },
	{ 0xB9DB, 0xE39E88 },
	{ 0xB9DC, 0xE39E89 },
	{ 0xB9DD, 0xE39E8A },
	{ 0xB9DE, 0xE39E8B },
	{ 0xB9DF, 0xE39E8C },
	{ 0xB9E0, 0xE39E8D },
	{ 0xB9E1, 0xE39E8E },
	{ 0xB9E2, 0xE39E8F },
	{ 0xB9E3, 0xE39E90 },
	{ 0xB9E4, 0xE39E91 },
	{ 0xB9E5, 0xE39E92 },
	{ 0xB9E6, 0xE39E93 },
	{ 0xB9E7, 0xE39E94 },
	{ 0xB9E8, 0xE39E95 },
	{ 0xB9E9, 0xE39E96 },
	{ 0xB9EA, 0xE39E97 },
	{ 0xB9EB, 0xE39E98 },
	{ 0xB9EC, 0xE39E99 },
	{ 0xB9ED, 0xE39E9A },
	{ 0xB9EE, 0xE39E9B },
	{ 0xB9EF, 0xE39E9C },
	{ 0xB9F0, 0xE39E9D },
	{ 0xB9F1, 0xE39E9E },
	{ 0xB9F2, 0xE39E9F },
	{ 0xB9F3, 0xE39EA0 },
	{ 0xB9F4, 0xE39EA1 },
	{ 0xB9F5, 0xE39EA2 },
	{ 0xB9F6, 0xE39EA3 },
	{ 0xB9F7, 0xE39EA4 },
	{ 0xB9F8, 0xE39EA5 },
	{ 0xB9F9, 0xE39EA6 },
	{ 0xB9FA, 0xE39EA7 },
	{ 0xB9FB, 0xE39EA8 },
	{ 0xB9FC, 0xE39EA9 },
	{ 0xB9FD, 0xE39EAA },
	{ 0xB9FE, 0xE39EAB },
	{ 0xBAA1, 0xE39EAC },
	{ 0xBAA2, 0xE39EAD },
	{ 0xBAA3, 0xE39EAE },
	{ 0xBAA4, 0xE39EAF },
	{ 0xBAA5, 0xE39EB0 },
	{ 0xBAA6, 0xE39EB1 },
	{ 0xBAA7, 0xE39EB2 },
	{ 0xBAA8, 0xE39EB3 },
	{ 0xBAA9, 0xE39EB4 },
	{ 0xBAAA, 0xE39EB5 },
	{ 0xBAAB, 0xE39EB6 },
	{ 0xBAAC, 0xE39EB7 },
	{ 0xBAAD, 0xE39EB8 },
	{ 0xBAAE, 0xE39EB9 },
	{ 0xBAAF, 0xE39EBA },
	{ 0xBAB0, 0xE39EBB },
	{ 0xBAB1, 0xE39EBC },
	{ 0xBAB2, 0xE39EBD },
	{ 0xBAB3, 0xE39EBE },
	{ 0xBAB4, 0xE39EBF },
	{ 0xBAB5, 0xE39F80 },
	{ 0xBAB6, 0xE39F81 },
	{ 0xBAB7, 0xE39F82 },
	{ 0xBAB8, 0xE39F83 },
	{ 0xBAB9, 0xE39F84 },
	{ 0xBABA, 0xE39F85 },
	{ 0xBABB, 0xE39F86 },
	{ 0xBABC, 0xE39F87 },
	{ 0xBABD, 0xE39F88 },
	{ 0xBABE, 0xE39F89 },
	{ 0xBABF, 0xE39F8A },
	{ 0xBAC0, 0xE39F8B },
	{ 0xBAC1, 0xE39F8C },
	{ 0xBAC2, 0xE39F8D },
	{ 0xBAC3, 0xE39F8E },
	{ 0xBAC4, 0xE39F8F },
	{ 0xBAC5, 0xE39F90 },
	{ 0xBAC6, 0xE39F91 },
	{ 0xBAC7, 0xE39F92 },
	{ 0xBAC8, 0xE39F93 },
	{ 0xBAC9, 0xE39F94 },
	{ 0xBACA, 0xE39F95 },
	{ 0xBACB, 0xE39F96 },
	{ 0xBACC, 0xE39F97 },
	{ 0xBACD, 0xE39F98 },
	{ 0xBACE, 0xE39F99 },
	{ 0xBACF, 0xE39F9A },
	{ 0xBAD0, 0xE39F9B },
	{ 0xBAD1, 0xE39F9C },
	{ 0xBAD2, 0xE39F9D },
	{ 0xBAD3, 0xE39F9E },
	{ 0xBAD4, 0xE39F9F },
	{ 0xBAD5, 0xE39FA0 },
	{ 0xBAD6, 0xE39FA1 },
	{ 0xBAD7, 0xE39FA2 },
	{ 0xBAD8, 0xE39FA3 },
	{ 0xBAD9, 0xE39FA4 },
	{ 0xBADA, 0xE39FA5 },
	{ 0xBADB, 0xE39FA6 },
	{ 0xBADC, 0xE39FA7 },
	{ 0xBADD, 0xE39FA8 },
	{ 0xBADE, 0xE39FA9 },
	{ 0xBADF, 0xE39FAA },
	{ 0xBAE0, 0xE39FAB },
	{ 0xBAE1, 0xE39FAC },
	{ 0xBAE2, 0xE39FAD },
	{ 0xBAE3, 0xE39FAE },
	{ 0xBAE4, 0xE39FAF },
	{ 0xBAE5, 0xE39FB0 },
	{ 0xBAE6, 0xE39FB1 },
	{ 0xBAE7, 0xE39FB2 },
	{ 0xBAE8, 0xE39FB3 },
	{ 0xBAE9, 0xE39FB4 },
	{ 0xBAEA, 0xE39FB5 },
	{ 0xBAEB, 0xE39FB6 },
	{ 0xBAEC, 0xE39FB7 },
	{ 0xBAED, 0xE39FB8 },
	{ 0xBAEE, 0xE39FB9 },
	{ 0xBAEF, 0xE39FBA },
	{ 0xBAF0, 0xE39FBB },
	{ 0xBAF1, 0xE39FBC },
	{ 0xBAF2, 0xE39FBD },
	{ 0xBAF3, 0xE39FBE },
	{ 0xBAF4, 0xE39FBF },
	{ 0xBAF5, 0xE3A080 },
	{ 0xBAF6, 0xE3A081 },
	{ 0xBAF7, 0xE3A082 },
	{ 0xBAF8, 0xE3A083 },
	{ 0xBAF9, 0xE3A084 },
	{ 0xBAFA, 0xE3A085 },
	{ 0xBAFB, 0xE3A086 },
	{ 0xBAFC, 0xE3A087 },
	{ 0xBAFD, 0xE3A088 },
	{ 0xBAFE, 0xE3A089 },
	{ 0xBBA1, 0xE3A08A },
	{ 0xBBA2, 0xE3A08B },
	{ 0xBBA3, 0xE3A08C },
	{ 0xBBA4, 0xE3A08D },
	{ 0xBBA5, 0xE3A08E },
	{ 0xBBA6, 0xE3A08F },
	{ 0xBBA7, 0xE3A090 },
	{ 0xBBA8, 0xE3A091 },
	{ 0xBBA9, 0xE3A092 },
	{ 0xBBAA, 0xE3A093 },
	{ 0xBBAB, 0xE3A094 },
	{ 0xBBAC, 0xE3A095 },
	{ 0xBBAD, 0xE3A096 },
	{ 0xBBAE, 0xE3A097 },
	{ 0xBBAF, 0xE3A098 },
	{ 0xBBB0, 0xE3A099 },
	{ 0xBBB1, 0xE3A09A },
	{ 0xBBB2, 0xE3A09B },
	{ 0xBBB3, 0xE3A09C },
	{ 0xBBB4, 0xE3A09D },
	{ 0xBBB5, 0xE3A09E },
	{ 0xBBB6, 0xE3A09F },
	{ 0xBBB7, 0xE3A0A0 },
	{ 0xBBB8, 0xE3A0A1 },
	{ 0xBBB9, 0xE3A0A2 },
	{ 0xBBBA, 0xE3A0A3 },
	{ 0xBBBB, 0xE3A0A4 },
	{ 0xBBBC, 0xE3A0A5 },
	{ 0xBBBD, 0xE3A0A6 },
	{ 0xBBBE, 0xE3A0A7 },
	{ 0xBBBF, 0xE3A0A8 },
	{ 0xBBC0, 0xE3A0A9 },
	{ 0xBBC1, 0xE3A0AA },
	{ 0xBBC2, 0xE3A0AB },
	{ 0xBBC3, 0xE3A0AC },
	{ 0xBBC4, 0xE3A0AD },
	{ 0xBBC5, 0xE3A0AE },
	{ 0xBBC6, 0xE3A0AF },
	{ 0xBBC7, 0xE3A0B0 },
	{ 0xBBC8, 0xE3A0B1 },
	{ 0xBBC9, 0xE3A0B2 },
	{ 0xBBCA, 0xE3A0B3 },
	{ 0xBBCB, 0xE3A0B4 },
	{ 0xBBCC, 0xE3A0B5 },
	{ 0xBBCD, 0xE3A0B6 },
	{ 0xBBCE, 0xE3A0B7 },
	{ 0xBBCF, 0xE3A0B8 },
	{ 0xBBD0, 0xE3A0B9 },
	{ 0xBBD1, 0xE3A0BA },
	{ 0xBBD2, 0xE3A0BB },
	{ 0xBBD3, 0xE3A0BC },
	{ 0xBBD4, 0xE3A0BD },
	{ 0xBBD5, 0xE3A0BE },
	{ 0xBBD6, 0xE3A0BF },
	{ 0xBBD7, 0xE3A180 },
	{ 0xBBD8, 0xE3A181 },
	{ 0xBBD9, 0xE3A182 },
	{ 0xBBDA, 0xE3A183 },
	{ 0xBBDB, 0xE3A184 },
	{ 0xBBDC, 0xE3A185 },
	{ 0xBBDD, 0xE3A186 },
	{ 0xBBDE, 0xE3A187 },
	{ 0xBBDF, 0xE3A188 },
	{ 0xBBE0, 0xE3A189 },
	{ 0xBBE1, 0xE3A18A },
	{ 0xBBE2, 0xE3A18B },
	{ 0xBBE3, 0xE3A18C },
	{ 0xBBE4, 0xE3A18D },
	{ 0xBBE5, 0xE3A18E },
	{ 0xBBE6, 0xE3A18F },
	{ 0xBBE7, 0xE3A190 },
	{ 0xBBE8, 0xE3A191 },
	{ 0xBBE9, 0xE3A192 },
	{ 0xBBEA, 0xE3A193 },
	{ 0xBBEB, 0xE3A194 },
	{ 0xBBEC, 0xE3A195 },
	{ 0xBBED, 0xE3A196 },
	{ 0xBBEE, 0xE3A197 },
	{ 0xBBEF, 0xE3A198 },
	{ 0xBBF0, 0xE3A199 },
	{ 0xBBF1, 0xE3A19A },
	{ 0xBBF2, 0xE3A19B },
	{ 0xBBF3, 0xE3A19C },
	{ 0xBBF4, 0xE3A19D },
	{ 0xBBF5, 0xE3A19E },
	{ 0xBBF6, 0xE3A19F },
	{ 0xBBF7, 0xE3A1A0 },
	{ 0xBBF8, 0xE3A1A1 },
	{ 0xBBF9, 0xE3A1A2 },
	{ 0xBBFA, 0xE3A1A3 },
	{ 0xBBFB, 0xE3A1A4 },
	{ 0xBBFC, 0xE3A1A5 },
	{ 0xBBFD, 0xE3A1A6 },
	{ 0xBBFE, 0xE3A1A7 },
	{ 0xBCA1, 0xE3A1A8 },
	{ 0xBCA2, 0xE3A1A9 },
	{ 0xBCA3, 0xE3A1AA },
	{ 0xBCA4, 0xE3A1AB },
	{ 0xBCA5, 0xE3A1AC },
	{ 0xBCA6, 0xE3A1AD },
	{ 0xBCA7, 0xE3A1AE },
	{ 0xBCA8, 0xE3A1AF },
	{ 0xBCA9, 0xE3A1B0 },
	{ 0xBCAA, 0xE3A1B1 },
	{ 0xBCAB, 0xE3A1B2 },
	{ 0xBCAC, 0xE3A1B3 },
	{ 0xBCAD, 0xE3A1B4 },
	{ 0xBCAE, 0xE3A1B5 },
	{ 0xBCAF, 0xE3A1B6 },
	{ 0xBCB0, 0xE3A1B7 },
	{ 0xBCB1, 0xE3A1B8 },
	{ 0xBCB2, 0xE3A1B9 },
	{ 0xBCB3, 0xE3A1BA },
	{ 0xBCB4, 0xE3A1BB },
	{ 0xBCB5, 0xE3A1BC },
	{ 0xBCB6, 0xE3A1BD },
	{ 0xBCB7, 0xE3A1BE },
	{ 0xBCB8, 0xE3A1BF },
	{ 0xBCB9, 0xE3A280 },
	{ 0xBCBA, 0xE3A281 },
	{ 0xBCBB, 0xE3A282 },
	{ 0xBCBC, 0xE3A283 },
	{ 0xBCBD, 0xE3A284 },
	{ 0xBCBE, 0xE3A285 },
	{ 0xBCBF, 0xE3A286 },
	{ 0xBCC0, 0xE3A287 },
	{ 0xBCC1, 0xE3A288 },
	{ 0xBCC2, 0xE3A289 },
	{ 0xBCC3, 0xE3A28A },
	{ 0xBCC4, 0xE3A28B },
	{ 0xBCC5, 0xE3A28C },
	{ 0xBCC6, 0xE3A28D },
	{ 0xBCC7, 0xE3A28E },
	{ 0xBCC8, 0xE3A28F },
	{ 0xBCC9, 0xE3A290 },
	{ 0xBCCA, 0xE3A291 },
	{ 0xBCCB, 0xE3A292 },
	{ 0xBCCC, 0xE3A293 },
	{ 0xBCCD, 0xE3A294 },
	{ 0xBCCE, 0xE3A295 },
	{ 0xBCCF, 0xE3A296 },
	{ 0xBCD0, 0xE3A297 },
	{ 0xBCD1, 0xE3A298 },
	{ 0xBCD2, 0xE3A299 },
	{ 0xBCD3, 0xE3A29A },
	{ 0xBCD4, 0xE3A29B },
	{ 0xBCD5, 0xE3A29C },
	{ 0xBCD6, 0xE3A29D },
	{ 0xBCD7, 0xE3A29E },
	{ 0xBCD8, 0xE3A29F },
	{ 0xBCD9, 0xE3A2A0 },
	{ 0xBCDA, 0xE3A2A1 },
	{ 0xBCDB, 0xE3A2A2 },
	{ 0xBCDC, 0xE3A2A3 },
	{ 0xBCDD, 0xE3A2A4 },
	{ 0xBCDE, 0xE3A2A5 },
	{ 0xBCDF, 0xE3A2A6 },
	{ 0xBCE0, 0xE3A2A7 },
	{ 0xBCE1, 0xE3A2A8 },
	{ 0xBCE2, 0xE3A2A9 },
	{ 0xBCE3, 0xE3A2AA },
	{ 0xBCE4, 0xE3A2AB },
	{ 0xBCE5, 0xE3A2AC },
	{ 0xBCE6, 0xE3A2AD },
	{ 0xBCE7, 0xE3A2AE },
	{ 0xBCE8, 0xE3A2AF },
	{ 0xBCE9, 0xE3A2B0 },
	{ 0xBCEA, 0xE3A2B1 },
	{ 0xBCEB, 0xE3A2B2 },
	{ 0xBCEC, 0xE3A2B3 },
	{ 0xBCED, 0xE3A2B4 },
	{ 0xBCEE, 0xE3A2B5 },
	{ 0xBCEF, 0xE3A2B6 },
	{ 0xBCF0, 0xE3A2B7 },
	{ 0xBCF1, 0xE3A2B8 },
	{ 0xBCF2, 0xE3A2B9 },
	{ 0xBCF3, 0xE3A2BA },
	{ 0xBCF4, 0xE3A2BB },
	{ 0xBCF5, 0xE3A2BC },
	{ 0xBCF6, 0xE3A2BD },
	{ 0xBCF7, 0xE3A2BE },
	{ 0xBCF8, 0xE3A2BF },
	{ 0xBCF9, 0xE3A380 },
	{ 0xBCFA, 0xE3A381 },
	{ 0xBCFB, 0xE3A382 },
	{ 0xBCFC, 0xE3A383 },
	{ 0xBCFD, 0xE3A384 },
	{ 0xBCFE, 0xE3A385 },
	{ 0xBDA1, 0xE3A386 },
	{ 0xBDA2, 0xE3A387 },
	{ 0xBDA3, 0xE3A388 },
	{ 0xBDA4, 0xE3A389 },
	{ 0xBDA5, 0xE3A38A },
	{ 0xBDA6, 0xE3A38B },
	{ 0xBDA7, 0xE3A38C },
	{ 0xBDA8, 0xE3A38D },
	{ 0xBDA9, 0xE3A38E },
	{ 0xBDAA, 0xE3A38F },
	{ 0xBDAB, 0xE3A390 },
	{ 0xBDAC, 0xE3A391 },
	{ 0xBDAD, 0xE3A392 },
	{ 0xBDAE, 0xE3A393 },
	{ 0xBDAF, 0xE3A394 },
	{ 0xBDB0, 0xE3A395 },
	{ 0xBDB1, 0xE3A396 },
	{ 0xBDB2, 0xE3A397 },
	{ 0xBDB3, 0xE3A398 },
	{ 0xBDB4, 0xE3A399 },
	{ 0xBDB5, 0xE3A39A },
	{ 0xBDB6, 0xE3A39B },
	{ 0xBDB7, 0xE3A39C },
	{ 0xBDB8, 0xE3A39D },
	{ 0xBDB9, 0xE3A39E },
	{ 0xBDBA, 0xE3A39F },
	{ 0xBDBB, 0xE3A3A0 },
	{ 0xBDBC, 0xE3A3A1 },
	{ 0xBDBD, 0xE3A3A2 },
	{ 0xBDBE, 0xE3A3A3 },
	{ 0xBDBF, 0xE3A3A4 },
	{ 0xBDC0, 0xE3A3A5 },
	{ 0xBDC1, 0xE3A3A6 },
	{ 0xBDC2, 0xE3A3A7 },
	{ 0xBDC3, 0xE3A3A8 },
	{ 0xBDC4, 0xE3A3A9 },
	{ 0xBDC5, 0xE3A3AA },
	{ 0xBDC6, 0xE3A3AB },
	{ 0xBDC7, 0xE3A3AC },
	{ 0xBDC8, 0xE3A3AD },
	{ 0xBDC9, 0xE3A3AE },
	{ 0xBDCA, 0xE3A3AF },
	{ 0xBDCB, 0xE3A3B0 },
	{ 0xBDCC, 0xE3A3B1 },
	{ 0xBDCD, 0xE3A3B2 },
	{ 0xBDCE, 0xE3A3B3 },
	{ 0xBDCF, 0xE3A3B4 },
	{ 0xBDD0, 0xE3A3B5 },
	{ 0xBDD1, 0xE3A3B6 },
	{ 0xBDD2, 0xE3A3B7 },
	{ 0xBDD3, 0xE3A3B8 },
	{ 0xBDD4, 0xE3A3B9 },
	{ 0xBDD5, 0xE3A3BA },
	{ 0xBDD6, 0xE3A3BB },
	{ 0xBDD7, 0xE3A3BC },
	{ 0xBDD8, 0xE3A3BD },
	{ 0xBDD9, 0xE3A3BE },
	{ 0xBDDA, 0xE3A3BF },
	{ 0xBDDB, 0xE3A480 },
	{ 0xBDDC, 0xE3A481 },
	{ 0xBDDD, 0xE3A482 },
	{ 0xBDDE, 0xE3A483 },
	{ 0xBDDF, 0xE3A484 },
	{ 0xBDE0, 0xE3A485 },
	{ 0xBDE1, 0xE3A486 },
	{ 0xBDE2, 0xE3A487 },
	{ 0xBDE3, 0xE3A488 },
	{ 0xBDE4, 0xE3A489 },
	{ 0xBDE5, 0xE3A48A },
	{ 0xBDE6, 0xE3A48B },
	{ 0xBDE7, 0xE3A48C },
	{ 0xBDE8, 0xE3A48D },
	{ 0xBDE9, 0xE3A48E },
	{ 0xBDEA, 0xE3A48F },
	{ 0xBDEB, 0xE3A490 },
	{ 0xBDEC, 0xE3A491 },
	{ 0xBDED, 0xE3A492 },
	{ 0xBDEE, 0xE3A493 },
	{ 0xBDEF, 0xE3A494 },
	{ 0xBDF0, 0xE3A495 },
	{ 0xBDF1, 0xE3A496 },
	{ 0xBDF2, 0xE3A497 },
	{ 0xBDF3, 0xE3A498 },
	{ 0xBDF4, 0xE3A499 },
	{ 0xBDF5, 0xE3A49A },
	{ 0xBDF6, 0xE3A49B },
	{ 0xBDF7, 0xE3A49C },
	{ 0xBDF8, 0xE3A49D },
	{ 0xBDF9, 0xE3A49E },
	{ 0xBDFA, 0xE3A49F },
	{ 0xBDFB, 0xE3A4A0 },
	{ 0xBDFC, 0xE3A4A1 },
	{ 0xBDFD, 0xE3A4A2 },
	{ 0xBDFE, 0xE3A4A3 },
	{ 0xBEA1, 0xE3A4A4 },
	{ 0xBEA2, 0xE3A4A5 },
	{ 0xBEA3, 0xE3A4A6 },
	{ 0xBEA4, 0xE3A4A7 },
	{ 0xBEA5, 0xE3A4A8 },
	{ 0xBEA6, 0xE3A4A9 },
	{ 0xBEA7, 0xE3A4AA },
	{ 0xBEA8, 0xE3A4AB },
	{ 0xBEA9, 0xE3A4AC },
	{ 0xBEAA, 0xE3A4AD },
	{ 0xBEAB, 0xE3A4AE },
	{ 0xBEAC, 0xE3A4AF },
	{ 0xBEAD, 0xE3A4B0 },
	{ 0xBEAE, 0xE3A4B1 },
	{ 0xBEAF, 0xE3A4B2 },
	{ 0xBEB0, 0xE3A4B3 },
	{ 0xBEB1, 0xE3A4B4 },
	{ 0xBEB2, 0xE3A4B5 },
	{ 0xBEB3, 0xE3A4B6 },
	{ 0xBEB4, 0xE3A4B7 },
	{ 0xBEB5, 0xE3A4B8 },
	{ 0xBEB6, 0xE3A4B9 },
	{ 0xBEB7, 0xE3A4BA },
	{ 0xBEB8, 0xE3A4BB },
	{ 0xBEB9, 0xE3A4BC },
	{ 0xBEBA, 0xE3A4BD },
	{ 0xBEBB, 0xE3A4BE },
	{ 0xBEBC, 0xE3A4BF },
	{ 0xBEBD, 0xE3A580 },
	{ 0xBEBE, 0xE3A581 },
	{ 0xBEBF, 0xE3A582 },
	{ 0xBEC0, 0xE3A583 },
	{ 0xBEC1, 0xE3A584 },
	{ 0xBEC2, 0xE3A585 },
	{ 0xBEC3, 0xE3A586 },
	{ 0xBEC4, 0xE3A587 },
	{ 0xBEC5, 0xE3A588 },
	{ 0xBEC6, 0xE3A589 },
	{ 0xBEC7, 0xE3A58A },
	{ 0xBEC8, 0xE3A58B },
	{ 0xBEC9, 0xE3A58C },
	{ 0xBECA, 0xE3A58D },
	{ 0xBECB, 0xE3A58E },
	{ 0xBECC, 0xE3A58F },
	{ 0xBECD, 0xE3A590 },
	{ 0xBECE, 0xE3A591 },
	{ 0xBECF, 0xE3A592 },
	{ 0xBED0, 0xE3A593 },
	{ 0xBED1, 0xE3A594 },
	{ 0xBED2, 0xE3A595 },
	{ 0xBED3, 0xE3A596 },
	{ 0xBED4, 0xE3A597 },
	{ 0xBED5, 0xE3A598 },
	{ 0xBED6, 0xE3A599 },
	{ 0xBED7, 0xE3A59A },
	{ 0xBED8, 0xE3A59B },
	{ 0xBED9, 0xE3A59C },
	{ 0xBEDA, 0xE3A59D },
	{ 0xBEDB, 0xE3A59E },
	{ 0xBEDC, 0xE3A59F },
	{ 0xBEDD, 0xE3A5A0 },
	{ 0xBEDE, 0xE3A5A1 },
	{ 0xBEDF, 0xE3A5A2 },
	{ 0xBEE0, 0xE3A5A3 },
	{ 0xBEE1, 0xE3A5A4 },
	{ 0xBEE2, 0xE3A5A5 },
	{ 0xBEE3, 0xE3A5A6 },
	{ 0xBEE4, 0xE3A5A7 },
	{ 0xBEE5, 0xE3A5A8 },
	{ 0xBEE6, 0xE3A5A9 },
	{ 0xBEE7, 0xE3A5AA },
	{ 0xBEE8, 0xE3A5AB },
	{ 0xBEE9, 0xE3A5AC },
	{ 0xBEEA, 0xE3A5AD },
	{ 0xBEEB, 0xE3A5AE },
	{ 0xBEEC, 0xE3A5AF },
	{ 0xBEED, 0xE3A5B0 },
	{ 0xBEEE, 0xE3A5B1 },
	{ 0xBEEF, 0xE3A5B2 },
	{ 0xBEF0, 0xE3A5B3 },
	{ 0xBEF1, 0xE3A5B4 },
	{ 0xBEF2, 0xE3A5B5 },
	{ 0xBEF3, 0xE3A5B6 },
	{ 0xBEF4, 0xE3A5B7 },
	{ 0xBEF5, 0xE3A5B8 },
	{ 0xBEF6, 0xE3A5B9 },
	{ 0xBEF7, 0xE3A5BA },
	{ 0xBEF8, 0xE3A5BB },
	{ 0xBEF9, 0xE3A5BC },
	{ 0xBEFA, 0xE3A5BD },
	{ 0xBEFB, 0xE3A5BE },
	{ 0xBEFC, 0xE3A5BF },
	{ 0xBEFD, 0xE3A680 },
	{ 0xBEFE, 0xE3A681 },
	{ 0xBFA1, 0xE3A682 },
	{ 0xBFA2, 0xE3A683 },
	{ 0xBFA3, 0xE3A684 },
	{ 0xBFA4, 0xE3A685 },
	{ 0xBFA5, 0xE3A686 },
	{ 0xBFA6, 0xE3A687 },
	{ 0xBFA7, 0xE3A688 },
	{ 0xBFA8, 0xE3A689 },
	{ 0xBFA9, 0xE3A68A },
	{ 0xBFAA, 0xE3A68B },
	{ 0xBFAB, 0xE3A68C },
	{ 0xBFAC, 0xE3A68D },
	{ 0xBFAD, 0xE3A68E },
	{ 0xBFAE, 0xE3A68F },
	{ 0xBFAF, 0xE3A690 },
	{ 0xBFB0, 0xE3A691 },
	{ 0xBFB1, 0xE3A692 },
	{ 0xBFB2, 0xE3A693 },
	{ 0xBFB3, 0xE3A694 },
	{ 0xBFB4, 0xE3A695 },
	{ 0xBFB5, 0xE3A696 },
	{ 0xBFB6, 0xE3A697 },
	{ 0xBFB7, 0xE3A698 },
	{ 0xBFB8, 0xE3A699 },
	{ 0xBFB9, 0xE3A69A },
	{ 0xBFBA, 0xE3A69B },
	{ 0xBFBB, 0xE3A69C },
	{ 0xBFBC, 0xE3A69D },
	{ 0xBFBD, 0xE3A69E },
	{ 0xBFBE, 0xE3A69F },
	{ 0xBFBF, 0xE3A6A0 },
	{ 0xBFC0, 0xE3A6A1 },
	{ 0xBFC1, 0xE3A6A2 },
	{ 0xBFC2, 0xE3A6A3 },
	{ 0xBFC3, 0xE3A6A4 },
	{ 0xBFC4, 0xE3A6A5 },
	{ 0xBFC5, 0xE3A6A6 },
	{ 0xBFC6, 0xE3A6A7 },
	{ 0xBFC7, 0xE3A6A8 },
	{ 0xBFC8, 0xE3A6A9 },
	{ 0xBFC9, 0xE3A6AA },
	{ 0xBFCA, 0xE3A6AB },
	{ 0xBFCB, 0xE3A6AC },
	{ 0xBFCC, 0xE3A6AD },
	{ 0xBFCD, 0xE3A6AE },
	{ 0xBFCE, 0xE3A6AF },
	{ 0xBFCF, 0xE3A6B0 },
	{ 0xBFD0, 0xE3A6B1 },
	{ 0xBFD1, 0xE3A6B2 },
	{ 0xBFD2, 0xE3A6B3 },
	{ 0xBFD3, 0xE3A6B4 },
	{ 0xBFD4, 0xE3A6B5 },
	{ 0xBFD5, 0xE3A6B6 },
	{ 0xBFD6, 0xE3A6B7 },
	{ 0xBFD7, 0xE3A6B8 },
	{ 0xBFD8, 0xE3A6B9 },
	{ 0xBFD9, 0xE3A6BA },
	{ 0xBFDA, 0xE3A6BB },
	{ 0xBFDB, 0xE3A6BC },
	{ 0xBFDC, 0xE3A6BD },
	{ 0xBFDD, 0xE3A6BE },
	{ 0xBFDE, 0xE3A6BF },
	{ 0xBFDF, 0xE3A780 },
	{ 0xBFE0, 0xE3A781 },
	{ 0xBFE1, 0xE3A782 },
	{ 0xBFE2, 0xE3A783 },
	{ 0xBFE3, 0xE3A784 },
	{ 0xBFE4, 0xE3A785 },
	{ 0xBFE5, 0xE3A786 },
	{ 0xBFE6, 0xE3A787 },
	{ 0xBFE7, 0xE3A788 },
	{ 0xBFE8, 0xE3A789 },
	{ 0xBFE9, 0xE3A78A },
	{ 0xBFEA, 0xE3A78B },
	{ 0xBFEB, 0xE3A78C },
	{ 0xBFEC, 0xE3A78D },
	{ 0xBFED, 0xE3A78E },
	{ 0xBFEE, 0xE3A78F },
	{ 0xBFEF, 0xE3A790 },
	{ 0xBFF0, 0xE3A791 },
	{ 0xBFF1, 0xE3A792 },
	{ 0xBFF2, 0xE3A793 },
	{ 0xBFF3, 0xE3A794 },
	{ 0xBFF4, 0xE3A795 },
	{ 0xBFF5, 0xE3A796 },
	{ 0xBFF6, 0xE3A797 },
	{ 0xBFF7, 0xE3A798 },
	{ 0xBFF8, 0xE3A799 },
	{ 0xBFF9, 0xE3A79A },
	{ 0xBFFA, 0xE3A79B },
	{ 0xBFFB, 0xE3A79C },
	{ 0xBFFC, 0xE3A79D },
	{ 0xBFFD, 0xE3A79E },
	{ 0xBFFE, 0xE3A79F },
	{ 0xC0A1, 0xE3A7A0 },
	{ 0xC0A2, 0xE3A7A1 },
	{ 0xC0A3, 0xE3A7A2 },
	{ 0xC0A4, 0xE3A7A3 },
	{ 0xC0A5, 0xE3A7A4 },
	{ 0xC0A6, 0xE3A7A5 },
	{ 0xC0A7, 0xE3A7A6 },
	{ 0xC0A8, 0xE3A7A7 },
	{ 0xC0A9, 0xE3A7A8 },
	{ 0xC0AA, 0xE3A7A9 },
	{ 0xC0AB, 0xE3A7AA },
	{ 0xC0AC, 0xE3A7AB },
	{ 0xC0AD, 0xE3A7AC },
	{ 0xC0AE, 0xE3A7AD },
	{ 0xC0AF, 0xE3A7AE },
	{ 0xC0B0, 0xE3A7AF },
	{ 0xC0B1, 0xE3A7B0 },
	{ 0xC0B2, 0xE3A7B1 },
	{ 0xC0B3, 0xE3A7B2 },
	{ 0xC0B4, 0xE3A7B3 },
	{ 0xC0B5, 0xE3A7B4 },
	{ 0xC0B6, 0xE3A7B5 },
	{ 0xC0B7, 0xE3A7B6 },
	{ 0xC0B8, 0xE3A7B7 },
	{ 0xC0B9, 0xE3A7B8 },
	{ 0xC0BA, 0xE3A7B9 },
	{ 0xC0BB, 0xE3A7BA },
	{ 0xC0BC, 0xE3A7BB },
	{ 0xC0BD, 0xE3A7BC },
	{ 0xC0BE, 0xE3A7BD },
	{ 0xC0BF, 0xE3A7BE },
	{ 0xC0C0, 0xE3A7BF },
	{ 0xC0C1, 0xE3A880 },
	{ 0xC0C2, 0xE3A881 },
	{ 0xC0C3, 0xE3A882 },
	{ 0xC0C4, 0xE3A883 },
	{ 0xC0C5, 0xE3A884 },
	{ 0xC0C6, 0xE3A885 },
	{ 0xC0C7, 0xE3A886 },
	{ 0xC0C8, 0xE3A887 },
	{ 0xC0C9, 0xE3A888 },
	{ 0xC0CA, 0xE3A889 },
	{ 0xC0CB, 0xE3A88A },
	{ 0xC0CC, 0xE3A88B },
	{ 0xC0CD, 0xE3A88C },
	{ 0xC0CE, 0xE3A88D },
	{ 0xC0CF, 0xE3A88E },
	{ 0xC0D0, 0xE3A88F },
	{ 0xC0D1, 0xE3A890 },
	{ 0xC0D2, 0xE3A891 },
	{ 0xC0D3, 0xE3A892 },
	{ 0xC0D4, 0xE3A893 },
	{ 0xC0D5, 0xE3A894 },
	{ 0xC0D6, 0xE3A895 },
	{ 0xC0D7, 0xE3A896 },
	{ 0xC0D8, 0xE3A897 },
	{ 0xC0D9, 0xE3A898 },
	{ 0xC0DA, 0xE3A899 },
	{ 0xC0DB, 0xE3A89A },
	{ 0xC0DC, 0xE3A89B },
	{ 0xC0DD, 0xE3A89C },
	{ 0xC0DE, 0xE3A89D },
	{ 0xC0DF, 0xE3A89E },
	{ 0xC0E0, 0xE3A89F },
	{ 0xC0E1, 0xE3A8A0 },
	{ 0xC0E2, 0xE3A8A1 },
	{ 0xC0E3, 0xE3A8A2 },
	{ 0xC0E4, 0xE3A8A3 },
	{ 0xC0E5, 0xE3A8A4 },
	{ 0xC0E6, 0xE3A8A5 },
	{ 0xC0E7, 0xE3A8A6 },
	{ 0xC0E8, 0xE3A8A7 },
	{ 0xC0E9, 0xE3A8A8 },
	{ 0xC0EA, 0xE3A8A9 },
	{ 0xC0EB, 0xE3A8AA },
	{ 0xC0EC, 0xE3A8AB },
	{ 0xC0ED, 0xE3A8AC },
	{ 0xC0EE, 0xE3A8AD },
	{ 0xC0EF, 0xE3A8AE },
	{ 0xC0F0, 0xE3A8AF },
	{ 0xC0F1, 0xE3A8B0 },
	{ 0xC0F2, 0xE3A8B1 },
	{ 0xC0F3, 0xE3A8B2 },
	{ 0xC0F4, 0xE3A8B3 },
	{ 0xC0F5, 0xE3A8B4 },
	{ 0xC0F6, 0xE3A8B5 },
	{ 0xC0F7, 0xE3A8B6 },
	{ 0xC0F8, 0xE3A8B7 },
	{ 0xC0F9, 0xE3A8B8 },
	{ 0xC0FA, 0xE3A8B9 },
	{ 0xC0FB, 0xE3A8BA },
	{ 0xC0FC, 0xE3A8BB },
	{ 0xC0FD, 0xE3A8BC },
	{ 0xC0FE, 0xE3A8BD },
	{ 0xC1A1, 0xE3A8BE },
	{ 0xC1A2, 0xE3A8BF },
	{ 0xC1A3, 0xE3A980 },
	{ 0xC1A4, 0xE3A981 },
	{ 0xC1A5, 0xE3A982 },
	{ 0xC1A6, 0xE3A983 },
	{ 0xC1A7, 0xE3A984 },
	{ 0xC1A8, 0xE3A985 },
	{ 0xC1A9, 0xE3A986 },
	{ 0xC1AA, 0xE3A987 },
	{ 0xC1AB, 0xE3A988 },
	{ 0xC1AC, 0xE3A989 },
	{ 0xC1AD, 0xE3A98A },
	{ 0xC1AE, 0xE3A98B },
	{ 0xC1AF, 0xE3A98C },
	{ 0xC1B0, 0xE3A98D },
	{ 0xC1B1, 0xE3A98E },
	{ 0xC1B2, 0xE3A98F },
	{ 0xC1B3, 0xE3A990 },
	{ 0xC1B4, 0xE3A991 },
	{ 0xC1B5, 0xE3A992 },
	{ 0xC1B6, 0xE3A993 },
	{ 0xC1B7, 0xE3A994 },
	{ 0xC1B8, 0xE3A995 },
	{ 0xC1B9, 0xE3A996 },
	{ 0xC1BA, 0xE3A997 },
	{ 0xC1BB, 0xE3A998 },
	{ 0xC1BC, 0xE3A999 },
	{ 0xC1BD, 0xE3A99A },
	{ 0xC1BE, 0xE3A99B },
	{ 0xC1BF, 0xE3A99C },
	{ 0xC1C0, 0xE3A99D },
	{ 0xC1C1, 0xE3A99E },
	{ 0xC1C2, 0xE3A99F },
	{ 0xC1C3, 0xE3A9A0 },
	{ 0xC1C4, 0xE3A9A1 },
	{ 0xC1C5, 0xE3A9A2 },
	{ 0xC1C6, 0xE3A9A3 },
	{ 0xC1C7, 0xE3A9A4 },
	{ 0xC1C8, 0xE3A9A5 },
	{ 0xC1C9, 0xE3A9A6 },
	{ 0xC1CA, 0xE3A9A7 },
	{ 0xC1CB, 0xE3A9A8 },
	{ 0xC1CC, 0xE3A9A9 },
	{ 0xC1CD, 0xE3A9AA },
	{ 0xC1CE, 0xE3A9AB },
	{ 0xC1CF, 0xE3A9AC },
	{ 0xC1D0, 0xE3A9AD },
	{ 0xC1D1, 0xE3A9AE },
	{ 0xC1D2, 0xE3A9AF },
	{ 0xC1D3, 0xE3A9B0 },
	{ 0xC1D4, 0xE3A9B1 },
	{ 0xC1D5, 0xE3A9B2 },
	{ 0xC1D6, 0xE3A9B3 },
	{ 0xC1D7, 0xE3A9B4 },
	{ 0xC1D8, 0xE3A9B5 },
	{ 0xC1D9, 0xE3A9B6 },
	{ 0xC1DA, 0xE3A9B7 },
	{ 0xC1DB, 0xE3A9B8 },
	{ 0xC1DC, 0xE3A9B9 },
	{ 0xC1DD, 0xE3A9BA },
	{ 0xC1DE, 0xE3A9BB },
	{ 0xC1DF, 0xE3A9BC },
	{ 0xC1E0, 0xE3A9BD },
	{ 0xC1E1, 0xE3A9BE },
	{ 0xC1E2, 0xE3A9BF },
	{ 0xC1E3, 0xE3AA80 },
	{ 0xC1E4, 0xE3AA81 },
	{ 0xC1E5, 0xE3AA82 },
	{ 0xC1E6, 0xE3AA83 },
	{ 0xC1E7, 0xE3AA84 },
	{ 0xC1E8, 0xE3AA85 },
	{ 0xC1E9, 0xE3AA86 },
	{ 0xC1EA, 0xE3AA87 },
	{ 0xC1EB, 0xE3AA88 },
	{ 0xC1EC, 0xE3AA89 },
	{ 0xC1ED, 0xE3AA8A },
	{ 0xC1EE, 0xE3AA8B },
	{ 0xC1EF, 0xE3AA8C },
	{ 0xC1F0, 0xE3AA8D },
	{ 0xC1F1, 0xE3AA8E },
	{ 0xC1F2, 0xE3AA8F },
	{ 0xC1F3, 0xE3AA90 },
	{ 0xC1F4, 0xE3AA91 },
	{ 0xC1F5, 0xE3AA92 },
	{ 0xC1F6, 0xE3AA93 },
	{ 0xC1F7, 0xE3AA94 },
	{ 0xC1F8, 0xE3AA95 },
	{ 0xC1F9, 0xE3AA96 },
	{ 0xC1FA, 0xE3AA97 },
	{ 0xC1FB, 0xE3AA98 },
	{ 0xC1FC, 0xE3AA99 },
	{ 0xC1FD, 0xE3AA9A },
	{ 0xC1FE, 0xE3AA9B },
	{ 0xC2A1, 0xE3AA9C },
	{ 0xC2A2, 0xE3AA9D },
	{ 0xC2A3, 0xE3AA9E },
	{ 0xC2A4, 0xE3AA9F },
	{ 0xC2A5, 0xE3AAA0 },
	{ 0xC2A6, 0xE3AAA1 },
	{ 0xC2A7, 0xE3AAA2 },
	{ 0xC2A8, 0xE3AAA3 },
	{ 0xC2A9, 0xE3AAA4 },
	{ 0xC2AA, 0xE3AAA5 },
	{ 0xC2AB, 0xE3AAA6 },
	{ 0xC2AC, 0xE3AAA7 },
	{ 0xC2AD, 0xE3AAA8 },
	{ 0xC2AE, 0xE3AAA9 },
	{ 0xC2AF, 0xE3AAAA },
	{ 0xC2B0, 0xE3AAAB },
	{ 0xC2B1, 0xE3AAAC },
	{ 0xC2B2, 0xE3AAAD },
	{ 0xC2B3, 0xE3AAAE },
	{ 0xC2B4, 0xE3AAAF },
	{ 0xC2B5, 0xE3AAB0 },
	{ 0xC2B6, 0xE3AAB1 },
	{ 0xC2B7, 0xE3AAB2 },
	{ 0xC2B8, 0xE3AAB3 },
	{ 0xC2B9, 0xE3AAB4 },
	{ 0xC2BA, 0xE3AAB5 },
	{ 0xC2BB, 0xE3AAB6 },
	{ 0xC2BC, 0xE3AAB7 },
	{ 0xC2BD, 0xE3AAB8 },
	{ 0xC2BE, 0xE3AAB9 },
	{ 0xC2BF, 0xE3AABA },
	{ 0xC2C0, 0xE3AABB },
	{ 0xC2C1, 0xE3AABC },
	{ 0xC2C2, 0xE3AABD },
	{ 0xC2C3, 0xE3AABE },
	{ 0xC2C4, 0xE3AABF },
	{ 0xC2C5, 0xE3AB80 },
	{ 0xC2C6, 0xE3AB81 },
	{ 0xC2C7, 0xE3AB82 },
	{ 0xC2C8, 0xE3AB83 },
	{ 0xC2C9, 0xE3AB84 },
	{ 0xC2CA, 0xE3AB85 },
	{ 0xC2CB, 0xE3AB86 },
	{ 0xC2CC, 0xE3AB87 },
	{ 0xC2CD, 0xE3AB88 },
	{ 0xC2CE, 0xE3AB89 },
	{ 0xC2CF, 0xE3AB8A },
	{ 0xC2D0, 0xE3AB8B },
	{ 0xC2D1, 0xE3AB8C },
	{ 0xC2D2, 0xE3AB8D },
	{ 0xC2D3, 0xE3AB8E },
	{ 0xC2D4, 0xE3AB8F },
	{ 0xC2D5, 0xE3AB90 },
	{ 0xC2D6, 0xE3AB91 },
	{ 0xC2D7, 0xE3AB92 },
	{ 0xC2D8, 0xE3AB93 },
	{ 0xC2D9, 0xE3AB94 },
	{ 0xC2DA, 0xE3AB95 },
	{ 0xC2DB, 0xE3AB96 },
	{ 0xC2DC, 0xE3AB97 },
	{ 0xC2DD, 0xE3AB98 },
	{ 0xC2DE, 0xE3AB99 },
	{ 0xC2DF, 0xE3AB9A },
	{ 0xC2E0, 0xE3AB9B },
	{ 0xC2E1, 0xE3AB9C },
	{ 0xC2E2, 0xE3AB9D },
	{ 0xC2E3, 0xE3AB9E },
	{ 0xC2E4, 0xE3AB9F },
	{ 0xC2E5, 0xE3ABA0 },
	{ 0xC2E6, 0xE3ABA1 },
	{ 0xC2E7, 0xE3ABA2 },
	{ 0xC2E8, 0xE3ABA3 },
	{ 0xC2E9, 0xE3ABA4 },
	{ 0xC2EA, 0xE3ABA5 },
	{ 0xC2EB, 0xE3ABA6 },
	{ 0xC2EC, 0xE3ABA7 },
	{ 0xC2ED, 0xE3ABA8 },
	{ 0xC2EE, 0xE3ABA9 },
	{ 0xC2EF, 0xE3ABAA },
	{ 0xC2F0, 0xE3ABAB },
	{ 0xC2F1, 0xE3ABAC },
	{ 0xC2F2, 0xE3ABAD },
	{ 0xC2F3, 0xE3ABAE },
	{ 0xC2F4, 0xE3ABAF },
	{ 0xC2F5, 0xE3ABB0 },
	{ 0xC2F6, 0xE3ABB1 },
	{ 0xC2F7, 0xE3ABB2 },
	{ 0xC2F8, 0xE3ABB3 },
	{ 0xC2F9, 0xE3ABB4 },
	{ 0xC2FA, 0xE3ABB5 },
	{ 0xC2FB, 0xE3ABB6 },
	{ 0xC2FC, 0xE3ABB7 },
	{ 0xC2FD, 0xE3ABB8 },
	{ 0xC2FE, 0xE3ABB9 },
	{ 0xC3A1, 0xE3ABBA },
	{ 0xC3A2, 0xE3ABBB },
	{ 0xC3A3, 0xE3ABBC },
	{ 0xC3A4, 0xE3ABBD },
	{ 0xC3A5, 0xE3ABBE },
	{ 0xC3A6, 0xE3ABBF },
	{ 0xC3A7, 0xE3AC80 },
	{ 0xC3A8, 0xE3AC81 },
	{ 0xC3A9, 0xE3AC82 },
	{ 0xC3AA, 0xE3AC83 },
	{ 0xC3AB, 0xE3AC84 },
	{ 0xC3AC, 0xE3AC85 },
	{ 0xC3AD, 0xE3AC86 },
	{ 0xC3AE, 0xE3AC87 },
	{ 0xC3AF, 0xE3AC88 },
	{ 0xC3B0, 0xE3AC89 },
	{ 0xC3B1, 0xE3AC8A },
	{ 0xC3B2, 0xE3AC8B },
	{ 0xC3B3, 0xE3AC8C },
	{ 0xC3B4, 0xE3AC8D },
	{ 0xC3B5, 0xE3AC8E },
	{ 0xC3B6, 0xE3AC8F },
	{ 0xC3B7, 0xE3AC90 },
	{ 0xC3B8, 0xE3AC91 },
	{ 0xC3B9, 0xE3AC92 },
	{ 0xC3BA, 0xE3AC93 },
	{ 0xC3BB, 0xE3AC94 },
	{ 0xC3BC, 0xE3AC95 },
	{ 0xC3BD, 0xE3AC96 },
	{ 0xC3BE, 0xE3AC97 },
	{ 0xC3BF, 0xE3AC98 },
	{ 0xC3C0, 0xE3AC99 },
	{ 0xC3C1, 0xE3AC9A },
	{ 0xC3C2, 0xE3AC9B },
	{ 0xC3C3, 0xE3AC9C },
	{ 0xC3C4, 0xE3AC9D },
	{ 0xC3C5, 0xE3AC9E },
	{ 0xC3C6, 0xE3AC9F },
	{ 0xC3C7, 0xE3ACA0 },
	{ 0xC3C8, 0xE3ACA1 },
	{ 0xC3C9, 0xE3ACA2 },
	{ 0xC3CA, 0xE3ACA3 },
	{ 0xC3CB, 0xE3ACA4 },
	{ 0xC3CC, 0xE3ACA5 },
	{ 0xC3CD, 0xE3ACA6 },
	{ 0xC3CE, 0xE3ACA7 },
	{ 0xC3CF, 0xE3ACA8 },
	{ 0xC3D0, 0xE3ACA9 },
	{ 0xC3D1, 0xE3ACAA },
	{ 0xC3D2, 0xE3ACAB },
	{ 0xC3D3, 0xE3ACAC },
	{ 0xC3D4, 0xE3ACAD },
	{ 0xC3D5, 0xE3ACAE },
	{ 0xC3D6, 0xE3ACAF },
	{ 0xC3D7, 0xE3ACB0 },
	{ 0xC3D8, 0xE3ACB1 },
	{ 0xC3D9, 0xE3ACB2 },
	{ 0xC3DA, 0xE3ACB3 },
	{ 0xC3DB, 0xE3ACB4 },
	{ 0xC3DC, 0xE3ACB5 },
	{ 0xC3DD, 0xE3ACB6 },
	{ 0xC3DE, 0xE3ACB7 },
	{ 0xC3DF, 0xE3ACB8 },
	{ 0xC3E0, 0xE3ACB9 },
	{ 0xC3E1, 0xE3ACBA },
	{ 0xC3E2, 0xE3ACBB },
	{ 0xC3E3, 0xE3ACBC },
	{ 0xC3E4, 0xE3ACBD },
	{ 0xC3E5, 0xE3ACBE },
	{ 0xC3E6, 0xE3ACBF },
	{ 0xC3E7, 0xE3AD80 },
	{ 0xC3E8, 0xE3AD81 },
	{ 0xC3E9, 0xE3AD82 },
	{ 0xC3EA, 0xE3AD83 },
	{ 0xC3EB, 0xE3AD84 },
	{ 0xC3EC, 0xE3AD85 },
	{ 0xC3ED, 0xE3AD86 },
	{ 0xC3EE, 0xE3AD87 },
	{ 0xC3EF, 0xE3AD88 },
	{ 0xC3F0, 0xE3AD89 },
	{ 0xC3F1, 0xE3AD8A },
	{ 0xC3F2, 0xE3AD8B },
	{ 0xC3F3, 0xE3AD8C },
	{ 0xC3F4, 0xE3AD8D },
	{ 0xC3F5, 0xE3AD8E },
	{ 0xC3F6, 0xE3AD8F },
	{ 0xC3F7, 0xE3AD90 },
	{ 0xC3F8, 0xE3AD91 },
	{ 0xC3F9, 0xE3AD92 },
	{ 0xC3FA, 0xE3AD93 },
	{ 0xC3FB, 0xE3AD94 },
	{ 0xC3FC, 0xE3AD95 },
	{ 0xC3FD, 0xE3AD96 },
	{ 0xC3FE, 0xE3AD97 },
	{ 0xC4A1, 0xE3AD98 },
	{ 0xC4A2, 0xE3AD99 },
	{ 0xC4A3, 0xE3AD9A },
	{ 0xC4A4, 0xE3AD9B },
	{ 0xC4A5, 0xE3AD9C },
	{ 0xC4A6, 0xE3AD9D },
	{ 0xC4A7, 0xE3AD9E },
	{ 0xC4A8, 0xE3AD9F },
	{ 0xC4A9, 0xE3ADA0 },
	{ 0xC4AA, 0xE3ADA1 },
	{ 0xC4AB, 0xE3ADA2 },
	{ 0xC4AC, 0xE3ADA3 },
	{ 0xC4AD, 0xE3ADA4 },
	{ 0xC4AE, 0xE3ADA5 },
	{ 0xC4AF, 0xE3ADA6 },
	{ 0xC4B0, 0xE3ADA7 },
	{ 0xC4B1, 0xE3ADA8 },
	{ 0xC4B2, 0xE3ADA9 },
	{ 0xC4B3, 0xE3ADAA },
	{ 0xC4B4, 0xE3ADAB },
	{ 0xC4B5, 0xE3ADAC },
	{ 0xC4B6, 0xE3ADAD },
	{ 0xC4B7, 0xE3ADAE },
	{ 0xC4B8, 0xE3ADAF },
	{ 0xC4B9, 0xE3ADB0 },
	{ 0xC4BA, 0xE3ADB1 },
	{ 0xC4BB, 0xE3ADB2 },
	{ 0xC4BC, 0xE3ADB3 },
	{ 0xC4BD, 0xE3ADB4 },
	{ 0xC4BE, 0xE3ADB5 },
	{ 0xC4BF, 0xE3ADB6 },
	{ 0xC4C0, 0xE3ADB7 },
	{ 0xC4C1, 0xE3ADB8 },
	{ 0xC4C2, 0xE3ADB9 },
	{ 0xC4C3, 0xE3ADBA },
	{ 0xC4C4, 0xE3ADBB },
	{ 0xC4C5, 0xE3ADBC },
	{ 0xC4C6, 0xE3ADBD },
	{ 0xC4C7, 0xE3ADBE },
	{ 0xC4C8, 0xE3ADBF },
	{ 0xC4C9, 0xE3AE80 },
	{ 0xC4CA, 0xE3AE81 },
	{ 0xC4CB, 0xE3AE82 },
	{ 0xC4CC, 0xE3AE83 },
	{ 0xC4CD, 0xE3AE84 },
	{ 0xC4CE, 0xE3AE85 },
	{ 0xC4CF, 0xE3AE86 },
	{ 0xC4D0, 0xE3AE87 },
	{ 0xC4D1, 0xE3AE88 },
	{ 0xC4D2, 0xE3AE89 },
	{ 0xC4D3, 0xE3AE8A },
	{ 0xC4D4, 0xE3AE8B },
	{ 0xC4D5, 0xE3AE8C },
	{ 0xC4D6, 0xE3AE8D },
	{ 0xC4D7, 0xE3AE8E },
	{ 0xC4D8, 0xE3AE8F },
	{ 0xC4D9, 0xE3AE90 },
	{ 0xC4DA, 0xE3AE91 },
	{ 0xC4DB, 0xE3AE92 },
	{ 0xC4DC, 0xE3AE93 },
	{ 0xC4DD, 0xE3AE94 },
	{ 0xC4DE, 0xE3AE95 },
	{ 0xC4DF, 0xE3AE96 },
	{ 0xC4E0, 0xE3AE97 },
	{ 0xC4E1, 0xE3AE98 },
	{ 0xC4E2, 0xE3AE99 },
	{ 0xC4E3, 0xE3AE9A },
	{ 0xC4E4, 0xE3AE9B },
	{ 0xC4E5, 0xE3AE9C },
	{ 0xC4E6, 0xE3AE9D },
	{ 0xC4E7, 0xE3AE9E },
	{ 0xC4E8, 0xE3AE9F },
	{ 0xC4E9, 0xE3AEA0 },
	{ 0xC4EA, 0xE3AEA1 },
	{ 0xC4EB, 0xE3AEA2 },
	{ 0xC4EC, 0xE3AEA3 },
	{ 0xC4ED, 0xE3AEA4 },
	{ 0xC4EE, 0xE3AEA5 },
	{ 0xC4EF, 0xE3AEA6 },
	{ 0xC4F0, 0xE3AEA7 },
	{ 0xC4F1, 0xE3AEA8 },
	{ 0xC4F2, 0xE3AEA9 },
	{ 0xC4F3, 0xE3AEAA },
	{ 0xC4F4, 0xE3AEAB },
	{ 0xC4F5, 0xE3AEAC },
	{ 0xC4F6, 0xE3AEAD },
	{ 0xC4F7, 0xE3AEAE },
	{ 0xC4F8, 0xE3AEAF },
	{ 0xC4F9, 0xE3AEB0 },
	{ 0xC4FA, 0xE3AEB1 },
	{ 0xC4FB, 0xE3AEB2 },
	{ 0xC4FC, 0xE3AEB3 },
	{ 0xC4FD, 0xE3AEB4 },
	{ 0xC4FE, 0xE3AEB5 },
	{ 0xC5A1, 0xE3AEB6 },
	{ 0xC5A2, 0xE3AEB7 },
	{ 0xC5A3, 0xE3AEB8 },
	{ 0xC5A4, 0xE3AEB9 },
	{ 0xC5A5, 0xE3AEBA },
	{ 0xC5A6, 0xE3AEBB },
	{ 0xC5A7, 0xE3AEBC },
	{ 0xC5A8, 0xE3AEBD },
	{ 0xC5A9, 0xE3AEBE },
	{ 0xC5AA, 0xE3AEBF },
	{ 0xC5AB, 0xE3AF80 },
	{ 0xC5AC, 0xE3AF81 },
	{ 0xC5AD, 0xE3AF82 },
	{ 0xC5AE, 0xE3AF83 },
	{ 0xC5AF, 0xE3AF84 },
	{ 0xC5B0, 0xE3AF85 },
	{ 0xC5B1, 0xE3AF86 },
	{ 0xC5B2, 0xE3AF87 },
	{ 0xC5B3, 0xE3AF88 },
	{ 0xC5B4, 0xE3AF89 },
	{ 0xC5B5, 0xE3AF8A },
	{ 0xC5B6, 0xE3AF8B },
	{ 0xC5B7, 0xE3AF8C },
	{ 0xC5B8, 0xE3AF8D },
	{ 0xC5B9, 0xE3AF8E },
	{ 0xC5BA, 0xE3AF8F },
	{ 0xC5BB, 0xE3AF90 },
	{ 0xC5BC, 0xE3AF91 },
	{ 0xC5BD, 0xE3AF92 },
	{ 0xC5BE, 0xE3AF93 },
	{ 0xC5BF, 0xE3AF94 },
	{ 0xC5C0, 0xE3AF95 },
	{ 0xC5C1, 0xE3AF96 },
	{ 0xC5C2, 0xE3AF97 },
	{ 0xC5C3, 0xE3AF98 },
	{ 0xC5C4, 0xE3AF99 },
	{ 0xC5C5, 0xE3AF9A },
	{ 0xC5C6, 0xE3AF9B },
	{ 0xC5C7, 0xE3AF9C },
	{ 0xC5C8, 0xE3AF9D },
	{ 0xC5C9, 0xE3AF9E },
	{ 0xC5CA, 0xE3AF9F },
	{ 0xC5CB, 0xE3AFA0 },
	{ 0xC5CC, 0xE3AFA1 },
	{ 0xC5CD, 0xE3AFA2 },
	{ 0xC5CE, 0xE3AFA3 },
	{ 0xC5CF, 0xE3AFA4 },
	{ 0xC5D0, 0xE3AFA5 },
	{ 0xC5D1, 0xE3AFA6 },
	{ 0xC5D2, 0xE3AFA7 },
	{ 0xC5D3, 0xE3AFA8 },
	{ 0xC5D4, 0xE3AFA9 },
	{ 0xC5D5, 0xE3AFAA },
	{ 0xC5D6, 0xE3AFAB },
	{ 0xC5D7, 0xE3AFAC },
	{ 0xC5D8, 0xE3AFAD },
	{ 0xC5D9, 0xE3AFAE },
	{ 0xC5DA, 0xE3AFAF },
	{ 0xC5DB, 0xE3AFB0 },
	{ 0xC5DC, 0xE3AFB1 },
	{ 0xC5DD, 0xE3AFB2 },
	{ 0xC5DE, 0xE3AFB3 },
	{ 0xC5DF, 0xE3AFB4 },
	{ 0xC5E0, 0xE3AFB5 },
	{ 0xC5E1, 0xE3AFB6 },
	{ 0xC5E2, 0xE3AFB7 },
	{ 0xC5E3, 0xE3AFB8 },
	{ 0xC5E4, 0xE3AFB9 },
	{ 0xC5E5, 0xE3AFBA },
	{ 0xC5E6, 0xE3AFBB },
	{ 0xC5E7, 0xE3AFBC },
	{ 0xC5E8, 0xE3AFBD },
	{ 0xC5E9, 0xE3AFBE },
	{ 0xC5EA, 0xE3AFBF },
	{ 0xC5EB, 0xE3B080 },
	{ 0xC5EC, 0xE3B081 },
	{ 0xC5ED, 0xE3B082 },
	{ 0xC5EE, 0xE3B083 },
	{ 0xC5EF, 0xE3B084 },
	{ 0xC5F0, 0xE3B085 },
	{ 0xC5F1, 0xE3B086 },
	{ 0xC5F2, 0xE3B087 },
	{ 0xC5F3, 0xE3B088 },
	{ 0xC5F4, 0xE3B089 },
	{ 0xC5F5, 0xE3B08A },
	{ 0xC5F6, 0xE3B08B },
	{ 0xC5F7, 0xE3B08C },
	{ 0xC5F8, 0xE3B08D },
	{ 0xC5F9, 0xE3B08E },
	{ 0xC5FA, 0xE3B08F },
	{ 0xC5FB, 0xE3B090 },
	{ 0xC5FC, 0xE3B091 },
	{ 0xC5FD, 0xE3B092 },
	{ 0xC5FE, 0xE3B093 },
	{ 0xC6A1, 0xE3B094 },
	{ 0xC6A2, 0xE3B095 },
	{ 0xC6A3, 0xE3B096 },
	{ 0xC6A4, 0xE3B097 },
	{ 0xC6A5, 0xE3B098 },
	{ 0xC6A6, 0xE3B099 },
	{ 0xC6A7, 0xE3B09A },
	{ 0xC6A8, 0xE3B09B },
	{ 0xC6A9, 0xE3B09C },
	{ 0xC6AA, 0xE3B09D },
	{ 0xC6AB, 0xE3B09E },
	{ 0xC6AC, 0xE3B09F },
	{ 0xC6AD, 0xE3B0A0 },
	{ 0xC6AE, 0xE3B0A1 },
	{ 0xC6AF, 0xE3B0A2 },
	{ 0xC6B0, 0xE3B0A3 },
	{ 0xC6B1, 0xE3B0A4 },
	{ 0xC6B2, 0xE3B0A5 },
	{ 0xC6B3, 0xE3B0A6 },
	{ 0xC6B4, 0xE3B0A7 },
	{ 0xC6B5, 0xE3B0A8 },
	{ 0xC6B6, 0xE3B0A9 },
	{ 0xC6B7, 0xE3B0AA },
	{ 0xC6B8, 0xE3B0AB },
	{ 0xC6B9, 0xE3B0AC },
	{ 0xC6BA, 0xE3B0AD },
	{ 0xC6BB, 0xE3B0AE },
	{ 0xC6BC, 0xE3B0AF },
	{ 0xC6BD, 0xE3B0B0 },
	{ 0xC6BE, 0xE3B0B1 },
	{ 0xC6BF, 0xE3B0B2 },
	{ 0xC6C0, 0xE3B0B3 },
	{ 0xC6C1, 0xE3B0B4 },
	{ 0xC6C2, 0xE3B0B5 },
	{ 0xC6C3, 0xE3B0B6 },
	{ 0xC6C4, 0xE3B0B7 },
	{ 0xC6C5, 0xE3B0B8 },
	{ 0xC6C6, 0xE3B0B9 },
	{ 0xC6C7, 0xE3B0BA },
	{ 0xC6C8, 0xE3B0BB },
	{ 0xC6C9, 0xE3B0BC },
	{ 0xC6CA, 0xE3B0BD },
	{ 0xC6CB, 0xE3B0BE },
	{ 0xC6CC, 0xE3B0BF },
	{ 0xC6CD, 0xE3B180 },
	{ 0xC6CE, 0xE3B181 },
	{ 0xC6CF, 0xE3B182 },
	{ 0xC6D0, 0xE3B183 },
	{ 0xC6D1, 0xE3B184 },
	{ 0xC6D2, 0xE3B185 },
	{ 0xC6D3, 0xE3B186 },
	{ 0xC6D4, 0xE3B187 },
	{ 0xC6D5, 0xE3B188 },
	{ 0xC6D6, 0xE3B189 },
	{ 0xC6D7, 0xE3B18A },
	{ 0xC6D8, 0xE3B18B },
	{ 0xC6D9, 0xE3B18C },
	{ 0xC6DA, 0xE3B18D },
	{ 0xC6DB, 0xE3B18E },
	{ 0xC6DC, 0xE3B18F },
	{ 0xC6DD, 0xE3B190 },
	{ 0xC6DE, 0xE3B191 },
	{ 0xC6DF, 0xE3B192 },
	{ 0xC6E0, 0xE3B193 },
	{ 0xC6E1, 0xE3B194 },
	{ 0xC6E2, 0xE3B195 },
	{ 0xC6E3, 0xE3B196 },
	{ 0xC6E4, 0xE3B197 },
	{ 0xC6E5, 0xE3B198 },
	{ 0xC6E6, 0xE3B199 },
	{ 0xC6E7, 0xE3B19A },
	{ 0xC6E8, 0xE3B19B },
	{ 0xC6E9, 0xE3B19C },
	{ 0xC6EA, 0xE3B19D },
	{ 0xC6EB, 0xE3B19E },
	{ 0xC6EC, 0xE3B19F },
	{ 0xC6ED, 0xE3B1A0 },
	{ 0xC6EE, 0xE3B1A1 },
	{ 0xC6EF, 0xE3B1A2 },
	{ 0xC6F0, 0xE3B1A3 },
	{ 0xC6F1, 0xE3B1A4 },
	{ 0xC6F2, 0xE3B1A5 },
	{ 0xC6F3, 0xE3B1A6 },
	{ 0xC6F4, 0xE3B1A7 },
	{ 0xC6F5, 0xE3B1A8 },
	{ 0xC6F6, 0xE3B1A9 },
	{ 0xC6F7, 0xE3B1AA },
	{ 0xC6F8, 0xE3B1AB },
	{ 0xC6F9, 0xE3B1AC },
	{ 0xC6FA, 0xE3B1AD },
	{ 0xC6FB, 0xE3B1AE },
	{ 0xC6FC, 0xE3B1AF },
	{ 0xC6FD, 0xE3B1B0 },
	{ 0xC6FE, 0xE3B1B1 },
	{ 0xC7A1, 0xE3B1B2 },
	{ 0xC7A2, 0xE3B1B3 },
	{ 0xC7A3, 0xE3B1B4 },
	{ 0xC7A4, 0xE3B1B5 },
	{ 0xC7A5, 0xE3B1B6 },
	{ 0xC7A6, 0xE3B1B7 },
	{ 0xC7A7, 0xE3B1B8 },
	{ 0xC7A8, 0xE3B1B9 },
	{ 0xC7A9, 0xE3B1BA },
	{ 0xC7AA, 0xE3B1BB },
	{ 0xC7AB, 0xE3B1BC },
	{ 0xC7AC, 0xE3B1BD },
	{ 0xC7AD, 0xE3B1BE },
	{ 0xC7AE, 0xE3B1BF },
	{ 0xC7AF, 0xE3B280 },
	{ 0xC7B0, 0xE3B281 },
	{ 0xC7B1, 0xE3B282 },
	{ 0xC7B2, 0xE3B283 },
	{ 0xC7B3, 0xE3B284 },
	{ 0xC7B4, 0xE3B285 },
	{ 0xC7B5, 0xE3B286 },
	{ 0xC7B6, 0xE3B287 },
	{ 0xC7B7, 0xE3B288 },
	{ 0xC7B8, 0xE3B289 },
	{ 0xC7B9, 0xE3B28A },
	{ 0xC7BA, 0xE3B28B },
	{ 0xC7BB, 0xE3B28C },
	{ 0xC7BC, 0xE3B28D },
	{ 0xC7BD, 0xE3B28E },
	{ 0xC7BE, 0xE3B28F },
	{ 0xC7BF, 0xE3B290 },
	{ 0xC7C0, 0xE3B291 },
	{ 0xC7C1, 0xE3B292 },
	{ 0xC7C2, 0xE3B293 },
	{ 0xC7C3, 0xE3B294 },
	{ 0xC7C4, 0xE3B295 },
	{ 0xC7C5, 0xE3B296 },
	{ 0xC7C6, 0xE3B297 },
	{ 0xC7C7, 0xE3B298 },
	{ 0xC7C8, 0xE3B299 },
	{ 0xC7C9, 0xE3B29A },
	{ 0xC7CA, 0xE3B29B },
	{ 0xC7CB, 0xE3B29C },
	{ 0xC7CC, 0xE3B29D },
	{ 0xC7CD, 0xE3B29E },
	{ 0xC7CE, 0xE3B29F },
	{ 0xC7CF, 0xE3B2A0 },
	{ 0xC7D0, 0xE3B2A1 },
	{ 0xC7D1, 0xE3B2A2 },
	{ 0xC7D2, 0xE3B2A3 },
	{ 0xC7D3, 0xE3B2A4 },
	{ 0xC7D4, 0xE3B2A5 },
	{ 0xC7D5, 0xE3B2A6 },
	{ 0xC7D6, 0xE3B2A7 },
	{ 0xC7D7, 0xE3B2A8 },
	{ 0xC7D8, 0xE3B2A9 },
	{ 0xC7D9, 0xE3B2AA },
	{ 0xC7DA, 0xE3B2AB },
	{ 0xC7DB, 0xE3B2AC },
	{ 0xC7DC, 0xE3B2AD },
	{ 0xC7DD, 0xE3B2AE },
	{ 0xC7DE, 0xE3B2AF },
	{ 0xC7DF, 0xE3B2B0 },
	{ 0xC7E0, 0xE3B2B1 },
	{ 0xC7E1, 0xE3B2B2 },
	{ 0xC7E2, 0xE3B2B3 },
	{ 0xC7E3, 0xE3B2B4 },
	{ 0xC7E4, 0xE3B2B5 },
	{ 0xC7E5, 0xE3B2B6 },
	{ 0xC7E6, 0xE3B2B7 },
	{ 0xC7E7, 0xE3B2B8 },
	{ 0xC7E8, 0xE3B2B9 },
	{ 0xC7E9, 0xE3B2BA },
	{ 0xC7EA, 0xE3B2BB },
	{ 0xC7EB, 0xE3B2BC },
	{ 0xC7EC, 0xE3B2BD },
	{ 0xC7ED, 0xE3B2BE },
	{ 0xC7EE, 0xE3B2BF },
	{ 0xC7EF, 0xE3B380 },
	{ 0xC7F0, 0xE3B381 },
	{ 0xC7F1, 0xE3B382 },
	{ 0xC7F2, 0xE3B383 },
	{ 0xC7F3, 0xE3B384 },
	{ 0xC7F4, 0xE3B385 },
	{ 0xC7F5, 0xE3B386 },
	{ 0xC7F6, 0xE3B387 },
	{ 0xC7F7, 0xE3B388 },
	{ 0xC7F8, 0xE3B389 },
	{ 0xC7F9, 0xE3B38A },
	{ 0xC7FA, 0xE3B38B },
	{ 0xC7FB, 0xE3B38C },
	{ 0xC7FC, 0xE3B38D },
	{ 0xC7FD, 0xE3B38E },
	{ 0xC7FE, 0xE3B38F },
	{ 0xC8A1, 0xE3B390 },
	{ 0xC8A2, 0xE3B391 },
	{ 0xC8A3, 0xE3B392 },
	{ 0xC8A4, 0xE3B393 },
	{ 0xC8A5, 0xE3B394 },
	{ 0xC8A6, 0xE3B395 },
	{ 0xC8A7, 0xE3B396 },
	{ 0xC8A8, 0xE3B397 },
	{ 0xC8A9, 0xE3B398 },
	{ 0xC8AA, 0xE3B399 },
	{ 0xC8AB, 0xE3B39A },
	{ 0xC8AC, 0xE3B39B },
	{ 0xC8AD, 0xE3B39C },
	{ 0xC8AE, 0xE3B39D },
	{ 0xC8AF, 0xE3B39E },
	{ 0xC8B0, 0xE3B39F },
	{ 0xC8B1, 0xE3B3A0 },
	{ 0xC8B2, 0xE3B3A1 },
	{ 0xC8B3, 0xE3B3A2 },
	{ 0xC8B4, 0xE3B3A3 },
	{ 0xC8B5, 0xE3B3A4 },
	{ 0xC8B6, 0xE3B3A5 },
	{ 0xC8B7, 0xE3B3A6 },
	{ 0xC8B8, 0xE3B3A7 },
	{ 0xC8B9, 0xE3B3A8 },
	{ 0xC8BA, 0xE3B3A9 },
	{ 0xC8BB, 0xE3B3AA },
	{ 0xC8BC, 0xE3B3AB },
	{ 0xC8BD, 0xE3B3AC },
	{ 0xC8BE, 0xE3B3AD },
	{ 0xC8BF, 0xE3B3AE },
	{ 0xC8C0, 0xE3B3AF },
	{ 0xC8C1, 0xE3B3B0 },
	{ 0xC8C2, 0xE3B3B1 },
	{ 0xC8C3, 0xE3B3B2 },
	{ 0xC8C4, 0xE3B3B3 },
	{ 0xC8C5, 0xE3B3B4 },
	{ 0xC8C6, 0xE3B3B5 },
	{ 0xC8C7, 0xE3B3B6 },
	{ 0xC8C8, 0xE3B3B7 },
	{ 0xC8C9, 0xE3B3B8 },
	{ 0xC8CA, 0xE3B3B9 },
	{ 0xC8CB, 0xE3B3BA },
	{ 0xC8CC, 0xE3B3BB },
	{ 0xC8CD, 0xE3B3BC },
	{ 0xC8CE, 0xE3B3BD },
	{ 0xC8CF, 0xE3B3BE },
	{ 0xC8D0, 0xE3B3BF },
	{ 0xC8D1, 0xE3B480 },
	{ 0xC8D2, 0xE3B481 },
	{ 0xC8D3, 0xE3B482 },
	{ 0xC8D4, 0xE3B483 },
	{ 0xC8D5, 0xE3B484 },
	{ 0xC8D6, 0xE3B485 },
	{ 0xC8D7, 0xE3B486 },
	{ 0xC8D8, 0xE3B487 },
	{ 0xC8D9, 0xE3B488 },
	{ 0xC8DA, 0xE3B489 },
	{ 0xC8DB, 0xE3B48A },
	{ 0xC8DC, 0xE3B48B },
	{ 0xC8DD, 0xE3B48C },
	{ 0xC8DE, 0xE3B48D },
	{ 0xC8DF, 0xE3B48E },
	{ 0xC8E0, 0xE3B48F },
	{ 0xC8E1, 0xE3B490 },
	{ 0xC8E2, 0xE3B491 },
	{ 0xC8E3, 0xE3B492 },
	{ 0xC8E4, 0xE3B493 },
	{ 0xC8E5, 0xE3B494 },
	{ 0xC8E6, 0xE3B495 },
	{ 0xC8E7, 0xE3B496 },
	{ 0xC8E8, 0xE3B497 },
	{ 0xC8E9, 0xE3B498 },
	{ 0xC8EA, 0xE3B499 },
	{ 0xC8EB, 0xE3B49A },
	{ 0xC8EC, 0xE3B49B },
	{ 0xC8ED, 0xE3B49C },
	{ 0xC8EE, 0xE3B49D },
	{ 0xC8EF, 0xE3B49E },
	{ 0xC8F0, 0xE3B49F },
	{ 0xC8F1, 0xE3B4A0 },
	{ 0xC8F2, 0xE3B4A1 },
	{ 0xC8F3, 0xE3B4A2 },
	{ 0xC8F4, 0xE3B4A3 },
	{ 0xC8F5, 0xE3B4A4 },
	{ 0xC8F6, 0xE3B4A5 },
	{ 0xC8F7, 0xE3B4A6 },
	{ 0xC8F8, 0xE3B4A7 },
	{ 0xC8F9, 0xE3B4A8 },
	{ 0xC8FA, 0xE3B4A9 },
	{ 0xC8FB, 0xE3B4AA },
	{ 0xC8FC, 0xE3B4AB },
	{ 0xC8FD, 0xE3B4AC },
	{ 0xC8FE, 0xE3B4AD },
	{ 0xECE9, 0xE4B880 },
	{ 0xEFCB, 0xE4B881 },
	{ 0xF6D2, 0xE4B883 },
	{ 0xD8B2, 0xE4B887 },
	{ 0xEDDB, 0xE4B888 },
	{ 0xDFB2, 0xE4B889 },
	{ 0xDFBE, 0xE4B88A },
	{ 0xF9BB, 0xE4B88B },
	{ 0xDCF4, 0xE4B88D },
	{ 0xF5E4, 0xE4B891 },
	{ 0xF3A6, 0xE4B894 },
	{ 0xDDE0, 0xE4B895 },
	{ 0xE1A6, 0xE4B896 },
	{ 0xCEF8, 0xE4B898 },
	{ 0xDCB0, 0xE4B899 },
	{ 0xE3AA, 0xE4B89E },
	{ 0xF1E9, 0xE4B8AD },
	{ 0xCDFA, 0xE4B8B2 },
	{ 0xFCAF, 0xE4B8B8 },
	{ 0xD3A1, 0xE4B8B9 },
	{ 0xF1AB, 0xE4B8BB },
	{ 0xE7D1, 0xE4B982 },
	{ 0xD2AC, 0xE4B983 },
	{ 0xCEF9, 0xE4B985 },
	{ 0xF1FD, 0xE4B98B },
	{ 0xDEBF, 0xE4B98D },
	{ 0xFBBA, 0xE4B98E },
	{ 0xF9B9, 0xE4B98F },
	{ 0xCED2, 0xE4B996 },
	{ 0xE3AB, 0xE4B998 },
	{ 0xEBE0, 0xE4B999 },
	{ 0xCEFA, 0xE4B99D },
	{ 0xCBF7, 0xE4B99E },
	{ 0xE5A5, 0xE4B99F },
	{ 0xCAE1, 0xE4B9AB },
	{ 0xD4CC, 0xE4B9AD },
	{ 0xEAE1, 0xE4B9B3 },
	{ 0xDCE3, 0xE4B9B6 },
	{ 0xDFAD, 0xE4B9B7 },
	{ 0xCBEB, 0xE4B9BE },
	{ 0xD5AF, 0xE4BA82 },
	{ 0xD6F5, 0xE4BA86 },
	{ 0xE5F8, 0xE4BA88 },
	{ 0xDEC0, 0xE4BA8B },
	{ 0xECA3, 0xE4BA8C },
	{ 0xE9CD, 0xE4BA8E },
	{ 0xEAA7, 0xE4BA90 },
	{ 0xE9F6, 0xE4BA91 },
	{ 0xFBBB, 0xE4BA92 },
	{ 0xE7E9, 0xE4BA94 },
	{ 0xEFCC, 0xE4BA95 },
	{ 0xD0E6, 0xE4BA98 },
	{ 0xDEC1, 0xE4BA9B },
	{ 0xE4AC, 0xE4BA9E },
	{ 0xD8CC, 0xE4BAA1 },
	{ 0xF9F1, 0xE4BAA2 },
	{ 0xCEDF, 0xE4BAA4 },
	{ 0xFAA4, 0xE4BAA5 },
	{ 0xE6B2, 0xE4BAA6 },
	{ 0xFAFB, 0xE4BAA8 },
	{ 0xFABD, 0xE4BAAB },
	{ 0xCCC8, 0xE4BAAC },
	{ 0xEFCD, 0xE4BAAD },
	{ 0xD5D5, 0xE4BAAE },
	{ 0xD3A2, 0xE4BAB6 },
	{ 0xECD1, 0xE4BABA },
	{ 0xE4A7, 0xE4BB80 },
	{ 0xECD2, 0xE4BB81 },
	{ 0xF6B1, 0xE4BB84 },
	{ 0xCEFB, 0xE4BB87 },
	{ 0xD0D1, 0xE4BB8A },
	{ 0xCBBF, 0xE4BB8B },
	{ 0xEDA4, 0xE4BB8D },
	{ 0xEDA8, 0xE4BB94 },
	{ 0xDEC2, 0xE4BB95 },
	{ 0xF6E2, 0xE4BB96 },
	{ 0xEDDC, 0xE4BB97 },
	{ 0xDCF5, 0xE4BB98 },
	{ 0xE0B9, 0xE4BB99 },
	{ 0xD4CE, 0xE4BB9D },
	{ 0xF4B5, 0xE4BB9F },
	{ 0xD3DB, 0xE4BBA3 },
	{ 0xD6B5, 0xE4BBA4 },
	{ 0xECA4, 0xE4BBA5 },
	{ 0xE4E6, 0xE4BBB0 },
	{ 0xF1EA, 0xE4BBB2 },
	{ 0xCBEC, 0xE4BBB6 },
	{ 0xCBC0, 0xE4BBB7 },
	{ 0xECF2, 0xE4BBBB },
	{ 0xD0EA, 0xE4BC81 },
	{ 0xF9F2, 0xE4BC89 },
	{ 0xECA5, 0xE4BC8A },
	{ 0xD0DF, 0xE4BC8B },
	{ 0xE7EA, 0xE4BC8D },
	{ 0xD0EB, 0xE4BC8E },
	{ 0xDCD1, 0xE4BC8F },
	{ 0xDBE9, 0xE4BC90 },
	{ 0xFDCC, 0xE4BC91 },
	{ 0xDBD7, 0xE4BCAF },
	{ 0xDAE1, 0xE4BCB4 },
	{ 0xD6B6, 0xE4BCB6 },
	{ 0xE3DF, 0xE4BCB8 },
	{ 0xDEC3, 0xE4BCBA },
	{ 0xDEC4, 0xE4BCBC },
	{ 0xCAA1, 0xE4BCBD },
	{ 0xEEEC, 0xE4BD83 },
	{ 0xD3A3, 0xE4BD86 },
	{ 0xEEB7, 0xE4BD87 },
	{ 0xF8CF, 0xE4BD88 },
	{ 0xEAC8, 0xE4BD8D },
	{ 0xEEB8, 0xE4BD8E },
	{ 0xF1AC, 0xE4BD8F },
	{ 0xF1A5, 0xE4BD90 },
	{ 0xE9CE, 0xE4BD91 },
	{ 0xF9BC, 0xE4BD95 },
	{ 0xE5F9, 0xE4BD99 },
	{ 0xECEA, 0xE4BD9A },
	{ 0xDDD6, 0xE4BD9B },
	{ 0xEDC2, 0xE4BD9C },
	{ 0xF8A5, 0xE4BDA9 },
	{ 0xE5BA, 0xE4BDAF },
	{ 0xDBD8, 0xE4BDB0 },
	{ 0xCAA2, 0xE4BDB3 },
	{ 0xD1CD, 0xE4BDB6 },
	{ 0xEEED, 0xE4BDBA },
	{ 0xECEB, 0xE4BDBE },
	{ 0xDEC5, 0xE4BDBF },
	{ 0xE3E0, 0xE4BE81 },
	{ 0xCAC9, 0xE4BE83 },
	{ 0xF2E9, 0xE4BE84 },
	{ 0xD5CE, 0xE4BE86 },
	{ 0xF6B6, 0xE4BE88 },
	{ 0xCEC2, 0xE4BE8A },
	{ 0xD6C7, 0xE4BE8B },
	{ 0xE3B4, 0xE4BE8D },
	{ 0xF1AD, 0xE4BE8F },
	{ 0xEAE2, 0xE4BE91 },
	{ 0xD7C2, 0xE4BE96 },
	{ 0xF3A7, 0xE4BE98 },
	{ 0xCDEA, 0xE4BE9B },
	{ 0xEBEE, 0xE4BE9D },
	{ 0xD9B2, 0xE4BEAE },
	{ 0xFDA5, 0xE4BEAF },
	{ 0xF6D5, 0xE4BEB5 },
	{ 0xD5E2, 0xE4BEB6 },
	{ 0xF8B5, 0xE4BEBF },
	{ 0xCCF5, 0xE4BF82 },
	{ 0xF5B5, 0xE4BF83 },
	{ 0xE4AD, 0xE4BF84 },
	{ 0xE7EB, 0xE4BF89 },
	{ 0xF1D5, 0xE4BF8A },
	{ 0xF0BB, 0xE4BF8E },
	{ 0xE9B5, 0xE4BF91 },
	{ 0xCCC9, 0xE4BF93 },
	{ 0xFAD5, 0xE4BF94 },
	{ 0xE1D4, 0xE4BF97 },
	{ 0xD7D6, 0xE4BF9A },
	{ 0xDCC1, 0xE4BF9D },
	{ 0xDEC6, 0xE4BF9F },
	{ 0xFAEF, 0xE4BFA0 },
	{ 0xE3E1, 0xE4BFA1 },
	{ 0xE1F3, 0xE4BFAE },
	{ 0xDCF6, 0xE4BFAF },
	{ 0xCEFC, 0xE4BFB1 },
	{ 0xDBC4, 0xE4BFB3 },
	{ 0xF8F1, 0xE4BFB5 },
	{ 0xDCE4, 0xE4BFB8 },
	{ 0xE5EF, 0xE4BFBA },
	{ 0xDCB1, 0xE58082 },
	{ 0xD5D6, 0xE58086 },
	{ 0xF3DA, 0xE58089 },
	{ 0xCBC1, 0xE5808B },
	{ 0xDBC3, 0xE5808D },
	{ 0xD9FA, 0xE58091 },
	{ 0xD3EE, 0xE58092 },
	{ 0xFAB8, 0xE58096 },
	{ 0xFDA6, 0xE58099 },
	{ 0xEBEF, 0xE5809A },
	{ 0xF4A6, 0xE5809C },
	{ 0xCCCA, 0xE5809E },
	{ 0xF3A8, 0xE5809F },
	{ 0xF3DB, 0xE580A1 },
	{ 0xDBA7, 0xE580A3 },
	{ 0xF6B7, 0xE580A4 },
	{ 0xCFE6, 0xE580A6 },
	{ 0xF0F2, 0xE580A7 },
	{ 0xCBDA, 0xE580A8 },
	{ 0xE7D2, 0xE580AA },
	{ 0xD7C3, 0xE580AB },
	{ 0xF6F0, 0xE580AC },
	{ 0xE8DE, 0xE580AD },
	{ 0xE5A6, 0xE580BB },
	{ 0xE5E7, 0xE58183 },
	{ 0xCAA3, 0xE58187 },
	{ 0xCCA7, 0xE58188 },
	{ 0xEAC9, 0xE58189 },
	{ 0xF8B6, 0xE5818F },
	{ 0xFAA5, 0xE58195 },
	{ 0xF1AE, 0xE5819A },
	{ 0xEFCE, 0xE5819C },
	{ 0xCBED, 0xE581A5 },
	{ 0xF6B0, 0xE581B4 },
	{ 0xEFCF, 0xE581B5 },
	{ 0xE9CF, 0xE581B6 },
	{ 0xF7DE, 0xE581B8 },
	{ 0xCED3, 0xE58280 },
	{ 0xDCF7, 0xE58285 },
	{ 0xDBA8, 0xE5828D },
	{ 0xCBF8, 0xE58291 },
	{ 0xDFA1, 0xE58298 },
	{ 0xDDE1, 0xE58299 },
	{ 0xF5CA, 0xE582AC },
	{ 0xE9B6, 0xE582AD },
	{ 0xE7EC, 0xE582B2 },
	{ 0xEEEE, 0xE582B3 },
	{ 0xF3F0, 0xE582B5 },
	{ 0xDFBF, 0xE582B7 },
	{ 0xCCCB, 0xE582BE },
	{ 0xD0C1, 0xE58385 },
	{ 0xF4D2, 0xE58389 },
	{ 0xE0BA, 0xE5838A },
	{ 0xDFC0, 0xE5838F },
	{ 0xCEE0, 0xE58391 },
	{ 0xDCD2, 0xE58395 },
	{ 0xFDEA, 0xE58396 },
	{ 0xD6F6, 0xE5839A },
	{ 0xEACA, 0xE5839E },
	{ 0xE8E9, 0xE583A5 },
	{ 0xE3AC, 0xE583A7 },
	{ 0xF3D0, 0xE583AD },
	{ 0xCAA4, 0xE583B9 },
	{ 0xDBF8, 0xE583BB },
	{ 0xDEC7, 0xE583BF },
	{ 0xEBF0, 0xE58480 },
	{ 0xF1D6, 0xE58481 },
	{ 0xE5E2, 0xE58484 },
	{ 0xCCCC, 0xE58486 },
	{ 0xCBFB, 0xE58489 },
	{ 0xEAE3, 0xE58492 },
	{ 0xDFC1, 0xE5849F },
	{ 0xD6ED, 0xE584A1 },
	{ 0xE9D0, 0xE584AA },
	{ 0xEEB9, 0xE584B2 },
	{ 0xD5E3, 0xE584B7 },
	{ 0xD1D3, 0xE584BA },
	{ 0xE5F0, 0xE584BC },
	{ 0xE8B4, 0xE58580 },
	{ 0xEBC3, 0xE58581 },
	{ 0xEAAA, 0xE58583 },
	{ 0xFAFC, 0xE58584 },
	{ 0xF5F6, 0xE58585 },
	{ 0xF0BC, 0xE58586 },
	{ 0xFDD4, 0xE58587 },
	{ 0xE0BB, 0xE58588 },
	{ 0xCEC3, 0xE58589 },
	{ 0xD0BA, 0xE5858B },
	{ 0xF7BA, 0xE5858C },
	{ 0xD8F3, 0xE5858D },
	{ 0xF7CD, 0xE5858E },
	{ 0xE4AE, 0xE58592 },
	{ 0xD4DF, 0xE5859C },
	{ 0xD0E7, 0xE585A2 },
	{ 0xECFD, 0xE585A5 },
	{ 0xD2AE, 0xE585A7 },
	{ 0xEEEF, 0xE585A8 },
	{ 0xD5D7, 0xE585A9 },
	{ 0xEAE4, 0xE585AA },
	{ 0xF8A2, 0xE585AB },
	{ 0xCDEB, 0xE585AC },
	{ 0xD7BF, 0xE585AD },
	{ 0xFBB1, 0xE585AE },
	{ 0xCDEC, 0xE585B1 },
	{ 0xDCB2, 0xE585B5 },
	{ 0xD0EC, 0xE585B6 },
	{ 0xCEFD, 0xE585B7 },
	{ 0xEEF0, 0xE585B8 },
	{ 0xCCC2, 0xE585BC },
	{ 0xD0ED, 0xE58680 },
	{ 0xE5F7, 0xE58686 },
	{ 0xF3FC, 0xE5868A },
	{ 0xEEA2, 0xE5868D },
	{ 0xD9B3, 0xE58692 },
	{ 0xD8F4, 0xE58695 },
	{ 0xE9B7, 0xE58697 },
	{ 0xCEAE, 0xE586A0 },
	{ 0xD9A2, 0xE586A5 },
	{ 0xD8F1, 0xE586AA },
	{ 0xD4CF, 0xE586AC },
	{ 0xE5A7, 0xE586B6 },
	{ 0xD5D2, 0xE586B7 },
	{ 0xD6A9, 0xE586BD },
	{ 0xF4A2, 0xE58784 },
	{ 0xF1D7, 0xE58786 },
	{ 0xD5D8, 0xE58789 },
	{ 0xF0BD, 0xE5878B },
	{ 0xD7D0, 0xE5878C },
	{ 0xD4D0, 0xE5878D },
	{ 0xD7CF, 0xE5879C },
	{ 0xEBEA, 0xE5879D },
	{ 0xFDEB, 0xE5879E },
	{ 0xDBED, 0xE587A1 },
	{ 0xFCC5, 0xE587B0 },
	{ 0xCBC2, 0xE587B1 },
	{ 0xFDD5, 0xE587B6 },
	{ 0xF4C8, 0xE587B8 },
	{ 0xE8EA, 0xE587B9 },
	{ 0xF5F3, 0xE587BA },
	{ 0xF9DE, 0xE587BD },
	{ 0xD3EF, 0xE58880 },
	{ 0xECD3, 0xE58883 },
	{ 0xDDC2, 0xE58886 },
	{ 0xEFB7, 0xE58887 },
	{ 0xE7D4, 0xE58888 },
	{ 0xCACA, 0xE5888A },
	{ 0xD9FB, 0xE5888E },
	{ 0xFAFD, 0xE58891 },
	{ 0xD6AA, 0xE58897 },
	{ 0xF4F8, 0xE5889D },
	{ 0xF7F7, 0xE588A4 },
	{ 0xDCAC, 0xE588A5 },
	{ 0xD7D7, 0xE588A9 },
	{ 0xDFA2, 0xE588AA },
	{ 0xCEBE, 0xE588AE },
	{ 0xD3F0, 0xE588B0 },
	{ 0xF0A4, 0xE588B6 },
	{ 0xE1EC, 0xE588B7 },
	{ 0xCFE7, 0xE588B8 },
	{ 0xF3CB, 0xE588B9 },
	{ 0xEDA9, 0xE588BA },
	{ 0xCABE, 0xE588BB },
	{ 0xF4EF, 0xE58983 },
	{ 0xF6CE, 0xE58987 },
	{ 0xDEFB, 0xE5898A },
	{ 0xD0BB, 0xE5898B },
	{ 0xD5B7, 0xE5898C },
	{ 0xEEF1, 0xE5898D },
	{ 0xF4A8, 0xE58994 },
	{ 0xDCF8, 0xE58996 },
	{ 0xCBA7, 0xE5899B },
	{ 0xDACE, 0xE5899D },
	{ 0xE0E6, 0xE589A1 },
	{ 0xEDA5, 0xE589A9 },
	{ 0xEEF2, 0xE589AA },
	{ 0xDCF9, 0xE589AF },
	{ 0xF9DC, 0xE589B2 },
	{ 0xF3DC, 0xE589B5 },
	{ 0xF8F2, 0xE589BD },
	{ 0xF4F9, 0xE589BF },
	{ 0xFCF1, 0xE58A83 },
	{ 0xD0BC, 0xE58A87 },
	{ 0xDBF9, 0xE58A88 },
	{ 0xD7B1, 0xE58A89 },
	{ 0xCBFC, 0xE58A8D },
	{ 0xF0A5, 0xE58A91 },
	{ 0xCBFD, 0xE58A92 },
	{ 0xD5F4, 0xE58A9B },
	{ 0xCDED, 0xE58A9F },
	{ 0xCAA5, 0xE58AA0 },
	{ 0xD6AB, 0xE58AA3 },
	{ 0xD0C2, 0xE58AA4 },
	{ 0xF0BE, 0xE58AA9 },
	{ 0xD2BD, 0xE58AAA },
	{ 0xCCA4, 0xE58AAB },
	{ 0xFAB6, 0xE58ABE },
	{ 0xCCCD, 0xE58B81 },
	{ 0xDAFA, 0xE58B83 },
	{ 0xF6CF, 0xE58B85 },
	{ 0xE9B8, 0xE58B87 },
	{ 0xD8F5, 0xE58B89 },
	{ 0xCCCE, 0xE58B8D },
	{ 0xD7CD, 0xE58B92 },
	{ 0xD4D1, 0xE58B95 },
	{ 0xE9ED, 0xE58B96 },
	{ 0xCAEB, 0xE58B98 },
	{ 0xD9E2, 0xE58B99 },
	{ 0xFDB2, 0xE58B9B },
	{ 0xE3AD, 0xE58B9D },
	{ 0xD6CC, 0xE58B9E },
	{ 0xD9B4, 0xE58B9F },
	{ 0xE1A7, 0xE58BA2 },
	{ 0xEED3, 0xE58BA3 },
	{ 0xD0C3, 0xE58BA4 },
	{ 0xFDB3, 0xE58BB3 },
	{ 0xD5E4, 0xE58BB5 },
	{ 0xCFE8, 0xE58BB8 },
	{ 0xEDC3, 0xE58BBA },
	{ 0xD0B2, 0xE58BBB },
	{ 0xCEFE, 0xE58BBE },
	{ 0xDAA8, 0xE58BBF },
	{ 0xF8D0, 0xE58C85 },
	{ 0xFDD6, 0xE58C88 },
	{ 0xF8D1, 0xE58C8D },
	{ 0xF8D2, 0xE58C8F },
	{ 0xDCD3, 0xE58C90 },
	{ 0xDDE2, 0xE58C95 },
	{ 0xFBF9, 0xE58C96 },
	{ 0xDDC1, 0xE58C97 },
	{ 0xE3B5, 0xE58C99 },
	{ 0xEDDD, 0xE58CA0 },
	{ 0xCEC4, 0xE58CA1 },
	{ 0xCBA1, 0xE58CA3 },
	{ 0xDDE3, 0xE58CAA },
	{ 0xFCDD, 0xE58CAF },
	{ 0xF9AF, 0xE58CB9 },
	{ 0xD2FB, 0xE58CBF },
	{ 0xCFA1, 0xE58D80 },
	{ 0xE4A8, 0xE58D81 },
	{ 0xF4B6, 0xE58D83 },
	{ 0xECFE, 0xE58D84 },
	{ 0xE3AE, 0xE58D87 },
	{ 0xE7ED, 0xE58D88 },
	{ 0xFDC1, 0xE58D89 },
	{ 0xDAE2, 0xE58D8A },
	{ 0xD8B3, 0xE58D8D },
	{ 0xDDE4, 0xE58D91 },
	{ 0xF0EF, 0xE58D92 },
	{ 0xF6F1, 0xE58D93 },
	{ 0xFAF0, 0xE58D94 },
	{ 0xD1F5, 0xE58D97 },
	{ 0xDACF, 0xE58D9A },
	{ 0xDCD4, 0xE58D9C },
	{ 0xDCA6, 0xE58D9E },
	{ 0xEFBF, 0xE58DA0 },
	{ 0xCECF, 0xE58DA6 },
	{ 0xE0D9, 0xE58DA8 },
	{ 0xD9D6, 0xE58DAF },
	{ 0xECD4, 0xE58DB0 },
	{ 0xEACB, 0xE58DB1 },
	{ 0xCABF, 0xE58DB4 },
	{ 0xD5B0, 0xE58DB5 },
	{ 0xCFE9, 0xE58DB7 },
	{ 0xF1ED, 0xE58DBD },
	{ 0xCCCF, 0xE58DBF },
	{ 0xE4F8, 0xE58E84 },
	{ 0xE4ED, 0xE58E93 },
	{ 0xD7D8, 0xE58E98 },
	{ 0xFDA7, 0xE58E9A },
	{ 0xEAAB, 0xE58E9F },
	{ 0xF6B2, 0xE58EA0 },
	{ 0xCFF0, 0xE58EA5 },
	{ 0xF9BD, 0xE58EA6 },
	{ 0xE6F4, 0xE58EAD },
	{ 0xCBDB, 0xE58EBB },
	{ 0xF3D1, 0xE58F83 },
	{ 0xE9D1, 0xE58F88 },
	{ 0xF3A9, 0xE58F89 },
	{ 0xD0E0, 0xE58F8A },
	{ 0xE9D2, 0xE58F8B },
	{ 0xDAE3, 0xE58F8D },
	{ 0xE2D2, 0xE58F94 },
	{ 0xF6A2, 0xE58F96 },
	{ 0xE1F4, 0xE58F97 },
	{ 0xDAE4, 0xE58F9B },
	{ 0xE7D5, 0xE58FA1 },
	{ 0xF5BF, 0xE58FA2 },
	{ 0xCFA2, 0xE58FA3 },
	{ 0xCDAF, 0xE58FA4 },
	{ 0xCFA3, 0xE58FA5 },
	{ 0xCDB0, 0xE58FA9 },
	{ 0xF1FE, 0xE58FAA },
	{ 0xD0A3, 0xE58FAB },
	{ 0xE1AF, 0xE58FAC },
	{ 0xF8A3, 0xE58FAD },
	{ 0xCAA6, 0xE58FAF },
	{ 0xF7BB, 0xE58FB0 },
	{ 0xF2EA, 0xE58FB1 },
	{ 0xDEC8, 0xE58FB2 },
	{ 0xE9D3, 0xE58FB3 },
	{ 0xDEC9, 0xE58FB8 },
	{ 0xFDDE, 0xE59083 },
	{ 0xCAC0, 0xE59084 },
	{ 0xF9EA, 0xE59088 },
	{ 0xD1CE, 0xE59089 },
	{ 0xEED4, 0xE5908A },
	{ 0xD4D2, 0xE5908C },
	{ 0xD9A3, 0xE5908D },
	{ 0xFDA8, 0xE5908E },
	{ 0xD7D9, 0xE5908F },
	{ 0xF7CE, 0xE59090 },
	{ 0xFABE, 0xE59091 },
	{ 0xCFD6, 0xE5909B },
	{ 0xD7F0, 0xE5909D },
	{ 0xEBE1, 0xE5909F },
	{ 0xF8C5, 0xE590A0 },
	{ 0xDCFA, 0xE590A6 },
	{ 0xDDC3, 0xE590A9 },
	{ 0xF9DF, 0xE590AB },
	{ 0xE7EF, 0xE590B3 },
	{ 0xFDE5, 0xE590B8 },
	{ 0xF6A3, 0xE590B9 },
	{ 0xD9FC, 0xE590BB },
	{ 0xFDA9, 0xE590BC },
	{ 0xE7EE, 0xE590BE },
	{ 0xD5E5, 0xE59182 },
	{ 0xEFD0, 0xE59188 },
	{ 0xCDB1, 0xE5918A },
	{ 0xF7A2, 0xE59191 },
	{ 0xF1B2, 0xE591A8 },
	{ 0xF1B1, 0xE591AA },
	{ 0xCDB2, 0xE591B1 },
	{ 0xDAAB, 0xE591B3 },
	{ 0xCAA7, 0xE591B5 },
	{ 0xE3E2, 0xE591BB },
	{ 0xFBBC, 0xE591BC },
	{ 0xD9A4, 0xE591BD },
	{ 0xEEBA, 0xE59280 },
	{ 0xF8D3, 0xE59286 },
	{ 0xFBFA, 0xE5928C },
	{ 0xCFA4, 0xE5928E },
	{ 0xDCFB, 0xE59290 },
	{ 0xF6E3, 0xE592A4 },
	{ 0xEDAA, 0xE592A8 },
	{ 0xF2A1, 0xE592AB },
	{ 0xCEE1, 0xE592AC },
	{ 0xFAA6, 0xE592B3 },
	{ 0xF9E0, 0xE592B8 },
	{ 0xECD6, 0xE592BD },
	{ 0xE4EE, 0xE59380 },
	{ 0xF9A1, 0xE59381 },
	{ 0xFBEF, 0xE59384 },
	{ 0xF9EB, 0xE59388 },
	{ 0xEEA3, 0xE59389 },
	{ 0xEAAC, 0xE593A1 },
	{ 0xCAA8, 0xE593A5 },
	{ 0xF4FA, 0xE593A8 },
	{ 0xCDD6, 0xE593AD },
	{ 0xFCF6, 0xE593AE },
	{ 0xF4C9, 0xE593B2 },
	{ 0xF8D4, 0xE593BA },
	{ 0xF8A6, 0xE59484 },
	{ 0xDECA, 0xE59486 },
	{ 0xF2C6, 0xE59487 },
	{ 0xD7DA, 0xE5948E },
	{ 0xD3D0, 0xE59490 },
	{ 0xD8C5, 0xE5949C },
	{ 0xEAE6, 0xE594AF },
	{ 0xF3DD, 0xE594B1 },
	{ 0xE4DA, 0xE594B5 },
	{ 0xF6E4, 0xE594BE },
	{ 0xF6F2, 0xE59584 },
	{ 0xDFC2, 0xE59586 },
	{ 0xD9FD, 0xE5958F },
	{ 0xCCF6, 0xE59593 },
	{ 0xD3BA, 0xE59596 },
	{ 0xE4AF, 0xE5959E },
	{ 0xF9E1, 0xE595A3 },
	{ 0xF0A6, 0xE595BC },
	{ 0xCBD3, 0xE59680 },
	{ 0xE0BC, 0xE59684 },
	{ 0xF4CA, 0xE59686 },
	{ 0xD4FA, 0xE59687 },
	{ 0xFDAA, 0xE59689 },
	{ 0xF9E2, 0xE5968A },
	{ 0xF4B7, 0xE59698 },
	{ 0xFDC2, 0xE59699 },
	{ 0xFCB0, 0xE5969A },
	{ 0xFDEC, 0xE5969C },
	{ 0xCAE2, 0xE5969D },
	{ 0xFDBD, 0xE596A7 },
	{ 0xEAE7, 0xE596A9 },
	{ 0xDFC3, 0xE596AA },
	{ 0xD1D2, 0xE596AB },
	{ 0xCEE2, 0xE596AC },
	{ 0xD3A4, 0xE596AE },
	{ 0xFDAB, 0xE59785 },
	{ 0xDFE0, 0xE59787 },
	{ 0xF2C7, 0xE59794 },
	{ 0xE7F0, 0xE5979A },
	{ 0xD0EE, 0xE5979C },
	{ 0xF3AA, 0xE5979F },
	{ 0xDECB, 0xE597A3 },
	{ 0xF6B8, 0xE597A4 },
	{ 0xE1F5, 0xE597BD },
	{ 0xF1B3, 0xE597BE },
	{ 0xF7A3, 0xE59886 },
	{ 0xCAA9, 0xE59889 },
	{ 0xCFA5, 0xE59894 },
	{ 0xDFC4, 0xE59897 },
	{ 0xE1B0, 0xE598AF },
	{ 0xF0BF, 0xE598B2 },
	{ 0xF6A4, 0xE598B4 },
	{ 0xE3B6, 0xE598B6 },
	{ 0xFAC6, 0xE59993 },
	{ 0xD0EF, 0xE599A8 },
	{ 0xFDED, 0xE599AB },
	{ 0xDDC4, 0xE599B4 },
	{ 0xFCF7, 0xE59A86 },
	{ 0xE6BF, 0xE59AA5 },
	{ 0xDEAD, 0xE59AAC },
	{ 0xFABF, 0xE59AAE },
	{ 0xE5F1, 0xE59AB4 },
	{ 0xEDC4, 0xE59ABC },
	{ 0xD2A5, 0xE59B8A },
	{ 0xFDEE, 0xE59B8D },
	{ 0xF5B6, 0xE59B91 },
	{ 0xE1F6, 0xE59B9A },
	{ 0xDECC, 0xE59B9B },
	{ 0xFCDE, 0xE59B9E },
	{ 0xECD7, 0xE59BA0 },
	{ 0xCDDD, 0xE59BB0 },
	{ 0xD6B7, 0xE59BB9 },
	{ 0xCDB3, 0xE59BBA },
	{ 0xF8D5, 0xE59C83 },
	{ 0xE5D8, 0xE59C84 },
	{ 0xCFEA, 0xE59C88 },
	{ 0xCFD0, 0xE59C8B },
	{ 0xEACC, 0xE59C8D },
	{ 0xEAAE, 0xE59C92 },
	{ 0xEAAD, 0xE59C93 },
	{ 0xD3F1, 0xE59C96 },
	{ 0xD3A5, 0xE59C98 },
	{ 0xF7CF, 0xE59C9F },
	{ 0xEEA4, 0xE59CA8 },
	{ 0xD0A4, 0xE59CAD },
	{ 0xF2A2, 0xE59CB0 },
	{ 0xD0F0, 0xE59CBB },
	{ 0xF2A3, 0xE59D80 },
	{ 0xF7F8, 0xE59D82 },
	{ 0xD0B3, 0xE59D87 },
	{ 0xDBA9, 0xE59D8A },
	{ 0xD3BB, 0xE59D8D },
	{ 0xCAEC, 0xE59D8E },
	{ 0xF1A6, 0xE59D90 },
	{ 0xCBD5, 0xE59D91 },
	{ 0xF7E7, 0xE59DA1 },
	{ 0xCDDE, 0xE59DA4 },
	{ 0xF7A4, 0xE59DA6 },
	{ 0xF8C0, 0xE59DAA },
	{ 0xD3DD, 0xE59DAE },
	{ 0xCCD0, 0xE59DB0 },
	{ 0xCFA6, 0xE59DB5 },
	{ 0xF6F3, 0xE59DBC },
	{ 0xE1F7, 0xE59E82 },
	{ 0xD3DC, 0xE59E88 },
	{ 0xFAFE, 0xE59E8B },
	{ 0xFAA7, 0xE59E93 },
	{ 0xEBD9, 0xE59EA0 },
	{ 0xCFA7, 0xE59EA2 },
	{ 0xEAAF, 0xE59EA3 },
	{ 0xE4EF, 0xE59F83 },
	{ 0xE9B9, 0xE59F87 },
	{ 0xF1D8, 0xE59F88 },
	{ 0xD8D8, 0xE59F8B },
	{ 0xE0F2, 0xE59F8E },
	{ 0xE6B4, 0xE59F9F },
	{ 0xDCFC, 0xE59FA0 },
	{ 0xF3F1, 0xE59FB0 },
	{ 0xE3D0, 0xE59FB4 },
	{ 0xF2FB, 0xE59FB7 },
	{ 0xDBC6, 0xE59FB9 },
	{ 0xD0F1, 0xE59FBA },
	{ 0xD0F2, 0xE59FBC },
	{ 0xCFDC, 0xE5A080 },
	{ 0xD3D1, 0xE5A082 },
	{ 0xCCB1, 0xE5A085 },
	{ 0xF7D8, 0xE5A086 },
	{ 0xCBA8, 0xE5A088 },
	{ 0xEBBC, 0xE5A089 },
	{ 0xE4BE, 0xE5A08A },
	{ 0xF4DC, 0xE5A09E },
	{ 0xDCC2, 0xE5A0A1 },
	{ 0xF0A7, 0xE5A0A4 },
	{ 0xE6C0, 0xE5A0A7 },
	{ 0xCAED, 0xE5A0AA },
	{ 0xE8EB, 0xE5A0AF },
	{ 0xE5E8, 0xE5A0B0 },
	{ 0xDCC3, 0xE5A0B1 },
	{ 0xEDDE, 0xE5A0B4 },
	{ 0xD3F2, 0xE5A0B5 },
	{ 0xCCF7, 0xE5A0BA },
	{ 0xCED4, 0xE5A18A },
	{ 0xE7AB, 0xE5A18B },
	{ 0xCBC3, 0xE5A18F },
	{ 0xE1B1, 0xE5A191 },
	{ 0xF7B2, 0xE5A194 },
	{ 0xD3F3, 0xE5A197 },
	{ 0xD3D2, 0xE5A198 },
	{ 0xF5C0, 0xE5A19A },
	{ 0xDFDD, 0xE5A19E },
	{ 0xEEF3, 0xE5A1A1 },
	{ 0xE7F1, 0xE5A1A2 },
	{ 0xFDB4, 0xE5A1A4 },
	{ 0xF2C8, 0xE5A1B5 },
	{ 0xF3D2, 0xE5A1B9 },
	{ 0xEEF4, 0xE5A1BC },
	{ 0xE2D3, 0xE5A1BE },
	{ 0xCCD1, 0xE5A283 },
	{ 0xDFEA, 0xE5A285 },
	{ 0xE9BA, 0xE5A289 },
	{ 0xD9D7, 0xE5A293 },
	{ 0xF5CD, 0xE5A29C },
	{ 0xF1F2, 0xE5A29E },
	{ 0xFAC7, 0xE5A29F },
	{ 0xD9F8, 0xE5A2A8 },
	{ 0xD4C2, 0xE5A2A9 },
	{ 0xF6E5, 0xE5A2AE },
	{ 0xDDC5, 0xE5A2B3 },
	{ 0xE7F2, 0xE5A2BA },
	{ 0xEDDF, 0xE5A2BB },
	{ 0xCACB, 0xE5A2BE },
	{ 0xDBFA, 0xE5A381 },
	{ 0xE8B5, 0xE5A385 },
	{ 0xD3A6, 0xE5A387 },
	{ 0xFDB5, 0xE5A38E },
	{ 0xF9C9, 0xE5A391 },
	{ 0xE4E2, 0xE5A393 },
	{ 0xFBBD, 0xE5A395 },
	{ 0xD7A4, 0xE5A398 },
	{ 0xCEC5, 0xE5A399 },
	{ 0xCED5, 0xE5A39E },
	{ 0xD6E6, 0xE5A39F },
	{ 0xE5BD, 0xE5A3A4 },
	{ 0xDECD, 0xE5A3AB },
	{ 0xECF3, 0xE5A3AC },
	{ 0xEDE0, 0xE5A3AF },
	{ 0xECEC, 0xE5A3B9 },
	{ 0xFBBE, 0xE5A3BA },
	{ 0xDFEB, 0xE5A3BB },
	{ 0xE1F8, 0xE5A3BD },
	{ 0xF9BE, 0xE5A48F },
	{ 0xD0F3, 0xE5A494 },
	{ 0xE0AA, 0xE5A495 },
	{ 0xE8E2, 0xE5A496 },
	{ 0xE2D4, 0xE5A499 },
	{ 0xD2FD, 0xE5A49A },
	{ 0xE5A8, 0xE5A49C },
	{ 0xD9D3, 0xE5A4A2 },
	{ 0xD3DE, 0xE5A4A7 },
	{ 0xF4B8, 0xE5A4A9 },
	{ 0xF7BC, 0xE5A4AA },
	{ 0xDCFD, 0xE5A4AB },
	{ 0xE8EC, 0xE5A4AD },
	{ 0xE4E7, 0xE5A4AE },
	{ 0xE3F7, 0xE5A4B1 },
	{ 0xECA8, 0xE5A4B7 },
	{ 0xFAF1, 0xE5A4BE },
	{ 0xE5F2, 0xE5A584 },
	{ 0xD0F4, 0xE5A587 },
	{ 0xD2AF, 0xE5A588 },
	{ 0xDCE5, 0xE5A589 },
	{ 0xD0A5, 0xE5A58E },
	{ 0xF1B4, 0xE5A58F },
	{ 0xFCB1, 0xE5A590 },
	{ 0xCCF8, 0xE5A591 },
	{ 0xDDC6, 0xE5A594 },
	{ 0xFAD1, 0xE5A595 },
	{ 0xF7DF, 0xE5A597 },
	{ 0xFAA8, 0xE5A59A },
	{ 0xEEF5, 0xE5A5A0 },
	{ 0xDECE, 0xE5A5A2 },
	{ 0xE7F3, 0xE5A5A7 },
	{ 0xF7AC, 0xE5A5AA },
	{ 0xEBC4, 0xE5A5AB },
	{ 0xEDE1, 0xE5A5AC },
	{ 0xE0AB, 0xE5A5AD },
	{ 0xDDC7, 0xE5A5AE },
	{ 0xD2B3, 0xE5A5B3 },
	{ 0xD2BF, 0xE5A5B4 },
	{ 0xCACC, 0xE5A5B8 },
	{ 0xFBBF, 0xE5A5BD },
	{ 0xE5FD, 0xE5A682 },
	{ 0xDDE5, 0xE5A683 },
	{ 0xD8CD, 0xE5A684 },
	{ 0xECF4, 0xE5A68A },
	{ 0xD0F5, 0xE5A693 },
	{ 0xE8ED, 0xE5A696 },
	{ 0xD0D2, 0xE5A697 },
	{ 0xD9D8, 0xE5A699 },
	{ 0xF6E6, 0xE5A6A5 },
	{ 0xDBAA, 0xE5A6A8 },
	{ 0xF7E0, 0xE5A6AC },
	{ 0xD8D9, 0xE5A6B9 },
	{ 0xF4A3, 0xE5A6BB },
	{ 0xF4DD, 0xE5A6BE },
	{ 0xEFD1, 0xE5A783 },
	{ 0xD9B5, 0xE5A786 },
	{ 0xEDAB, 0xE5A789 },
	{ 0xE3B7, 0xE5A78B },
	{ 0xEEBB, 0xE5A790 },
	{ 0xCDB4, 0xE5A791 },
	{ 0xE0F3, 0xE5A793 },
	{ 0xEACD, 0xE5A794 },
	{ 0xECF5, 0xE5A799 },
	{ 0xE8EE, 0xE5A79A },
	{ 0xCBA9, 0xE5A79C },
	{ 0xF1AF, 0xE5A79D },
	{ 0xCACD, 0xE5A7A6 },
	{ 0xECA9, 0xE5A7A8 },
	{ 0xF2EB, 0xE5A7AA },
	{ 0xFDEF, 0xE5A7AC },
	{ 0xF9F3, 0xE5A7AE },
	{ 0xE6C1, 0xE5A7B8 },
	{ 0xECD8, 0xE5A7BB },
	{ 0xEDAC, 0xE5A7BF },
	{ 0xEACE, 0xE5A881 },
	{ 0xE8DF, 0xE5A883 },
	{ 0xDECF, 0xE5A891 },
	{ 0xD2A6, 0xE5A898 },
	{ 0xE7F4, 0xE5A89B },
	{ 0xD1D6, 0xE5A89C },
	{ 0xE6C2, 0xE5A89F },
	{ 0xE3E3, 0xE5A8A0 },
	{ 0xE4B0, 0xE5A8A5 },
	{ 0xD8B4, 0xE5A8A9 },
	{ 0xF6A5, 0xE5A8B6 },
	{ 0xF3DE, 0xE5A8BC },
	{ 0xD7A5, 0xE5A981 },
	{ 0xF7E8, 0xE5A986 },
	{ 0xE8C6, 0xE5A989 },
	{ 0xFBE6, 0xE5A99A },
	{ 0xDDE6, 0xE5A9A2 },
	{ 0xDCFE, 0xE5A9A6 },
	{ 0xD8DA, 0xE5AA92 },
	{ 0xDAAC, 0xE5AA9A },
	{ 0xEAB0, 0xE5AA9B },
	{ 0xE3B8, 0xE5AAA4 },
	{ 0xCAAA, 0xE5AB81 },
	{ 0xE1F9, 0xE5AB82 },
	{ 0xEAB1, 0xE5AB84 },
	{ 0xF2EC, 0xE5AB89 },
	{ 0xFAEE, 0xE5AB8C },
	{ 0xEED5, 0xE5ABA1 },
	{ 0xF9F4, 0xE5ABA6 },
	{ 0xD2EC, 0xE5ABA9 },
	{ 0xFBFB, 0xE5AC85 },
	{ 0xFDF0, 0xE5AC89 },
	{ 0xE0BD, 0xE5AC8B },
	{ 0xCEE3, 0xE5AC8C },
	{ 0xF8C6, 0xE5AC96 },
	{ 0xDEAE, 0xE5ACAA },
	{ 0xDFC5, 0xE5AD80 },
	{ 0xE5BE, 0xE5AD83 },
	{ 0xEDAD, 0xE5AD90 },
	{ 0xFAEA, 0xE5AD91 },
	{ 0xCDEE, 0xE5AD94 },
	{ 0xEDA6, 0xE5AD95 },
	{ 0xEDAE, 0xE5AD97 },
	{ 0xF0ED, 0xE5AD98 },
	{ 0xDDA1, 0xE5AD9A },
	{ 0xEDAF, 0xE5AD9C },
	{ 0xFCF8, 0xE5AD9D },
	{ 0xD8EB, 0xE5AD9F },
	{ 0xCCF9, 0xE5ADA3 },
	{ 0xCDB5, 0xE5ADA4 },
	{ 0xFAA9, 0xE5ADA9 },
	{ 0xE1DD, 0xE5ADAB },
	{ 0xE2D5, 0xE5ADB0 },
	{ 0xEDCF, 0xE5ADB1 },
	{ 0xDDA2, 0xE5ADB5 },
	{ 0xF9CA, 0xE5ADB8 },
	{ 0xEAE8, 0xE5ADBA },
	{ 0xE5ED, 0xE5ADBC },
	{ 0xD3EB, 0xE5AE85 },
	{ 0xE9D4, 0xE5AE87 },
	{ 0xE1FA, 0xE5AE88 },
	{ 0xE4CC, 0xE5AE89 },
	{ 0xE1E4, 0xE5AE8B },
	{ 0xE8C7, 0xE5AE8C },
	{ 0xCEDB, 0xE5AE8F },
	{ 0xDCD5, 0xE5AE93 },
	{ 0xF7B5, 0xE5AE95 },
	{ 0xFCF3, 0xE5AE96 },
	{ 0xF0F3, 0xE5AE97 },
	{ 0xCEAF, 0xE5AE98 },
	{ 0xF1B5, 0xE5AE99 },
	{ 0xEFD2, 0xE5AE9A },
	{ 0xE8C8, 0xE5AE9B },
	{ 0xEBF1, 0xE5AE9C },
	{ 0xCBD4, 0xE5AEA2 },
	{ 0xE0BE, 0xE5AEA3 },
	{ 0xE3F8, 0xE5AEA4 },
	{ 0xEAE9, 0xE5AEA5 },
	{ 0xFCB2, 0xE5AEA6 },
	{ 0xE0F4, 0xE5AEAC },
	{ 0xCFE0, 0xE5AEAE },
	{ 0xEEA5, 0xE5AEB0 },
	{ 0xFAAA, 0xE5AEB3 },
	{ 0xE6C3, 0xE5AEB4 },
	{ 0xE1B2, 0xE5AEB5 },
	{ 0xCAAB, 0xE5AEB6 },
	{ 0xE3E4, 0xE5AEB8 },
	{ 0xE9BB, 0xE5AEB9 },
	{ 0xE2D6, 0xE5AEBF },
	{ 0xF3F2, 0xE5AF80 },
	{ 0xEED6, 0xE5AF82 },
	{ 0xEAB2, 0xE5AF83 },
	{ 0xD0F6, 0xE5AF84 },
	{ 0xECD9, 0xE5AF85 },
	{ 0xDACB, 0xE5AF86 },
	{ 0xCFA8, 0xE5AF87 },
	{ 0xDDA3, 0xE5AF8C },
	{ 0xD8DB, 0xE5AF90 },
	{ 0xF9CE, 0xE5AF92 },
	{ 0xE9D5, 0xE5AF93 },
	{ 0xE3D1, 0xE5AF94 },
	{ 0xD2BC, 0xE5AF97 },
	{ 0xD8AC, 0xE5AF9E },
	{ 0xF3CC, 0xE5AF9F },
	{ 0xCDFB, 0xE5AFA1 },
	{ 0xF6D6, 0xE5AFA2 },
	{ 0xE7F5, 0xE5AFA4 },
	{ 0xE8EF, 0xE5AFA5 },
	{ 0xE3F9, 0xE5AFA6 },
	{ 0xD2BB, 0xE5AFA7 },
	{ 0xF3F3, 0xE5AFA8 },
	{ 0xE3FB, 0xE5AFA9 },
	{ 0xDED0, 0xE5AFAB },
	{ 0xCEB0, 0xE5AFAC },
	{ 0xD6F7, 0xE5AFAE },
	{ 0xF1D9, 0xE5AFAF },
	{ 0xF5C1, 0xE5AFB5 },
	{ 0xDCC4, 0xE5AFB6 },
	{ 0xF5BB, 0xE5AFB8 },
	{ 0xDED1, 0xE5AFBA },
	{ 0xDCE6, 0xE5B081 },
	{ 0xDED2, 0xE5B084 },
	{ 0xEDE2, 0xE5B087 },
	{ 0xEEF6, 0xE5B088 },
	{ 0xEACF, 0xE5B089 },
	{ 0xF0EE, 0xE5B08A },
	{ 0xE3FC, 0xE5B08B },
	{ 0xD3DF, 0xE5B08D },
	{ 0xD3F4, 0xE5B08E },
	{ 0xE1B3, 0xE5B08F },
	{ 0xE1B4, 0xE5B091 },
	{ 0xF4D3, 0xE5B096 },
	{ 0xDFC6, 0xE5B099 },
	{ 0xE9D6, 0xE5B0A4 },
	{ 0xDBAB, 0xE5B0A8 },
	{ 0xF6A6, 0xE5B0B1 },
	{ 0xE3B9, 0xE5B0B8 },
	{ 0xEBC5, 0xE5B0B9 },
	{ 0xF4A9, 0xE5B0BA },
	{ 0xCDB6, 0xE5B0BB },
	{ 0xD2F9, 0xE5B0BC },
	{ 0xDAAD, 0xE5B0BE },
	{ 0xD2E3, 0xE5B0BF },
	{ 0xCFD1, 0xE5B180 },
	{ 0xCBDC, 0xE5B185 },
	{ 0xCCFA, 0xE5B186 },
	{ 0xCFDD, 0xE5B188 },
	{ 0xE8A9, 0xE5B18B },
	{ 0xE3BB, 0xE5B18D },
	{ 0xE3BA, 0xE5B18E },
	{ 0xE0DA, 0xE5B191 },
	{ 0xEEF7, 0xE5B195 },
	{ 0xDCB3, 0xE5B19B },
	{ 0xD3F5, 0xE5B1A0 },
	{ 0xD7A6, 0xE5B1A2 },
	{ 0xF6B5, 0xE5B1A4 },
	{ 0xD7DB, 0xE5B1A5 },
	{ 0xE1D5, 0xE5B1AC },
	{ 0xD4EA, 0xE5B1AF },
	{ 0xDFA3, 0xE5B1B1 },
	{ 0xFDDF, 0xE5B1B9 },
	{ 0xD0F7, 0xE5B290 },
	{ 0xEDD4, 0xE5B291 },
	{ 0xCBAA, 0xE5B2A1 },
	{ 0xE4DB, 0xE5B2A9 },
	{ 0xE1FB, 0xE5B2AB },
	{ 0xCBA2, 0xE5B2AC },
	{ 0xD3E0, 0xE5B2B1 },
	{ 0xE4BF, 0xE5B2B3 },
	{ 0xFBC0, 0xE5B2B5 },
	{ 0xDABE, 0xE5B2B7 },
	{ 0xE4CD, 0xE5B2B8 },
	{ 0xD6B9, 0xE5B2BA },
	{ 0xEFC0, 0xE5B2BE },
	{ 0xE1FC, 0xE5B380 },
	{ 0xF6B9, 0xE5B399 },
	{ 0xDFC7, 0xE5B3A0 },
	{ 0xE4B1, 0xE5B3A8 },
	{ 0xDCE7, 0xE5B3AF },
	{ 0xDCE8, 0xE5B3B0 },
	{ 0xFAD6, 0xE5B3B4 },
	{ 0xD3F6, 0xE5B3B6 },
	{ 0xF1DA, 0xE5B3BB },
	{ 0xFAF2, 0xE5B3BD },
	{ 0xE2FD, 0xE5B487 },
	{ 0xD5CF, 0xE5B48D },
	{ 0xD0F8, 0xE5B48E },
	{ 0xCDDF, 0xE5B491 },
	{ 0xF5CB, 0xE5B494 },
	{ 0xE4F0, 0xE5B496 },
	{ 0xCBAB, 0xE5B497 },
	{ 0xD7C4, 0xE5B499 },
	{ 0xE2FE, 0xE5B4A7 },
	{ 0xDDDA, 0xE5B4A9 },
	{ 0xDAAE, 0xE5B58B },
	{ 0xCAEE, 0xE5B58C },
	{ 0xD5B9, 0xE5B590 },
	{ 0xE3A1, 0xE5B5A9 },
	{ 0xE8E3, 0xE5B5AC },
	{ 0xF3AB, 0xE5B5AF },
	{ 0xCFA9, 0xE5B687 },
	{ 0xD3F7, 0xE5B68B },
	{ 0xD4F1, 0xE5B69D },
	{ 0xCEE4, 0xE5B6A0 },
	{ 0xE8F2, 0xE5B6A2 },
	{ 0xE5F5, 0xE5B6AA },
	{ 0xE7AE, 0xE5B6B8 },
	{ 0xD6BA, 0xE5B6BA },
	{ 0xDFEC, 0xE5B6BC },
	{ 0xE4C0, 0xE5B6BD },
	{ 0xE8E4, 0xE5B78D },
	{ 0xD8B5, 0xE5B792 },
	{ 0xE4DC, 0xE5B796 },
	{ 0xF4B9, 0xE5B79D },
	{ 0xF1B6, 0xE5B79E },
	{ 0xE2DE, 0xE5B7A1 },
	{ 0xE1B5, 0xE5B7A2 },
	{ 0xCDEF, 0xE5B7A5 },
	{ 0xF1A7, 0xE5B7A6 },
	{ 0xCEE5, 0xE5B7A7 },
	{ 0xCBDD, 0xE5B7A8 },
	{ 0xD9E3, 0xE5B7AB },
	{ 0xF3AC, 0xE5B7AE },
	{ 0xD0F9, 0xE5B7B1 },
	{ 0xECAB, 0xE5B7B2 },
	{ 0xDED3, 0xE5B7B3 },
	{ 0xF7E9, 0xE5B7B4 },
	{ 0xF9F5, 0xE5B7B7 },
	{ 0xE1DE, 0xE5B7BD },
	{ 0xCBEE, 0xE5B7BE },
	{ 0xE3BC, 0xE5B882 },
	{ 0xF8D6, 0xE5B883 },
	{ 0xDBEE, 0xE5B886 },
	{ 0xFDF1, 0xE5B88C },
	{ 0xF7B6, 0xE5B891 },
	{ 0xF4DE, 0xE5B896 },
	{ 0xF2ED, 0xE5B899 },
	{ 0xDBD9, 0xE5B89B },
	{ 0xF0A8, 0xE5B89D },
	{ 0xE1FD, 0xE5B8A5 },
	{ 0xDED4, 0xE5B8AB },
	{ 0xE0AC, 0xE5B8AD },
	{ 0xEDE3, 0xE5B8B3 },
	{ 0xD3E1, 0xE5B8B6 },
	{ 0xDFC8, 0xE5B8B8 },
	{ 0xD9B6, 0xE5B8BD },
	{ 0xFDAC, 0xE5B8BF },
	{ 0xEFD3, 0xE5B980 },
	{ 0xE4C1, 0xE5B984 },
	{ 0xF8EB, 0xE5B985 },
	{ 0xDBAC, 0xE5B987 },
	{ 0xFCC6, 0xE5B98C },
	{ 0xD8AD, 0xE5B995 },
	{ 0xF6BA, 0xE5B99F },
	{ 0xDBDF, 0xE5B9A1 },
	{ 0xD3D3, 0xE5B9A2 },
	{ 0xF8C7, 0xE5B9A3 },
	{ 0xCACE, 0xE5B9B2 },
	{ 0xF8C1, 0xE5B9B3 },
	{ 0xD2B4, 0xE5B9B4 },
	{ 0xDCB4, 0xE5B9B7 },
	{ 0xFAB9, 0xE5B9B8 },
	{ 0xCACF, 0xE5B9B9 },
	{ 0xFCB3, 0xE5B9BB },
	{ 0xEAEA, 0xE5B9BC },
	{ 0xEAEB, 0xE5B9BD },
	{ 0xD0FA, 0xE5B9BE },
	{ 0xEDE4, 0xE5BA84 },
	{ 0xDDE7, 0xE5BA87 },
	{ 0xDFC9, 0xE5BA8A },
	{ 0xDFED, 0xE5BA8F },
	{ 0xEEBC, 0xE5BA95 },
	{ 0xEFC1, 0xE5BA97 },
	{ 0xCCD2, 0xE5BA9A },
	{ 0xDDA4, 0xE5BA9C },
	{ 0xDFCA, 0xE5BAA0 },
	{ 0xD3F8, 0xE5BAA6 },
	{ 0xF1A8, 0xE5BAA7 },
	{ 0xCDB7, 0xE5BAAB },
	{ 0xEFD4, 0xE5BAAD },
	{ 0xE4DD, 0xE5BAB5 },
	{ 0xDFEE, 0xE5BAB6 },
	{ 0xCBAC, 0xE5BAB7 },
	{ 0xE9BC, 0xE5BAB8 },
	{ 0xEAEC, 0xE5BABE },
	{ 0xDFCB, 0xE5BB82 },
	{ 0xF9BF, 0xE5BB88 },
	{ 0xD6AF, 0xE5BB89 },
	{ 0xD5C6, 0xE5BB8A },
	{ 0xCFAA, 0xE5BB90 },
	{ 0xCEA9, 0xE5BB93 },
	{ 0xD6F8, 0xE5BB96 },
	{ 0xF1B7, 0xE5BB9A },
	{ 0xEEF8, 0xE5BB9B },
	{ 0xD9D9, 0xE5BB9F },
	{ 0xF3DF, 0xE5BBA0 },
	{ 0xF8C8, 0xE5BBA2 },
	{ 0xCEC6, 0xE5BBA3 },
	{ 0xD5E6, 0xE5BBAC },
	{ 0xF4E6, 0xE5BBB3 },
	{ 0xE6C5, 0xE5BBB6 },
	{ 0xEFD5, 0xE5BBB7 },
	{ 0xCBEF, 0xE5BBBA },
	{ 0xFCDF, 0xE5BBBB },
	{ 0xDCA7, 0xE5BC81 },
	{ 0xD6E7, 0xE5BC84 },
	{ 0xF8C9, 0xE5BC8A },
	{ 0xE3D2, 0xE5BC8F },
	{ 0xE3BD, 0xE5BC91 },
	{ 0xCFE1, 0xE5BC93 },
	{ 0xF0C0, 0xE5BC94 },
	{ 0xECDA, 0xE5BC95 },
	{ 0xDDD7, 0xE5BC97 },
	{ 0xFBF0, 0xE5BC98 },
	{ 0xECAC, 0xE5BC9B },
	{ 0xF0A9, 0xE5BC9F },
	{ 0xFAD7, 0xE5BCA6 },
	{ 0xFBC1, 0xE5BCA7 },
	{ 0xD2C0, 0xE5BCA9 },
	{ 0xE5B0, 0xE5BCB1 },
	{ 0xEDE5, 0xE5BCB5 },
	{ 0xCBAD, 0xE5BCBA },
	{ 0xF9B0, 0xE5BCBC },
	{ 0xF7A5, 0xE5BD88 },
	{ 0xCBAE, 0xE5BD8A },
	{ 0xDAAF, 0xE5BD8C },
	{ 0xD8B6, 0xE5BD8E },
	{ 0xD3A7, 0xE5BD96 },
	{ 0xFBB2, 0xE5BD97 },
	{ 0xFDC4, 0xE5BD99 },
	{ 0xECAD, 0xE5BD9B },
	{ 0xFBA1, 0xE5BDA2 },
	{ 0xE5E9, 0xE5BDA6 },
	{ 0xE9EE, 0xE5BDA7 },
	{ 0xF3F4, 0xE5BDA9 },
	{ 0xF8F3, 0xE5BDAA },
	{ 0xF0C1, 0xE5BDAB },
	{ 0xDEAF, 0xE5BDAC },
	{ 0xF8B0, 0xE5BDAD },
	{ 0xF3E0, 0xE5BDB0 },
	{ 0xE7AF, 0xE5BDB1 },
	{ 0xDBAD, 0xE5BDB7 },
	{ 0xE6B5, 0xE5BDB9 },
	{ 0xF9A8, 0xE5BDBC },
	{ 0xDDD8, 0xE5BDBF },
	{ 0xE8D9, 0xE5BE80 },
	{ 0xEFD6, 0xE5BE81 },
	{ 0xD3E2, 0xE5BE85 },
	{ 0xE2DF, 0xE5BE87 },
	{ 0xFCE0, 0xE5BE8A },
	{ 0xD7C8, 0xE5BE8B },
	{ 0xFDAD, 0xE5BE8C },
	{ 0xDFEF, 0xE5BE90 },
	{ 0xCCD3, 0xE5BE91 },
	{ 0xD3F9, 0xE5BE92 },
	{ 0xD4F0, 0xE5BE97 },
	{ 0xDBC7, 0xE5BE98 },
	{ 0xDED5, 0xE5BE99 },
	{ 0xF0F4, 0xE5BE9E },
	{ 0xD5D0, 0xE5BEA0 },
	{ 0xE5D9, 0xE5BEA1 },
	{ 0xFCC7, 0xE5BEA8 },
	{ 0xDCD6, 0xE5BEA9 },
	{ 0xE2E0, 0xE5BEAA },
	{ 0xDAB0, 0xE5BEAE },
	{ 0xF3A3, 0xE5BEB5 },
	{ 0xD3EC, 0xE5BEB7 },
	{ 0xF4CB, 0xE5BEB9 },
	{ 0xFDC5, 0xE5BEBD },
	{ 0xE3FD, 0xE5BF83 },
	{ 0xF9B1, 0xE5BF85 },
	{ 0xD0FB, 0xE5BF8C },
	{ 0xECDB, 0xE5BF8D },
	{ 0xF5BC, 0xE5BF96 },
	{ 0xF2A4, 0xE5BF97 },
	{ 0xD8CE, 0xE5BF98 },
	{ 0xD8CF, 0xE5BF99 },
	{ 0xF5F7, 0xE5BFA0 },
	{ 0xF6E1, 0xE5BFAB },
	{ 0xD2B7, 0xE5BFB5 },
	{ 0xFBEC, 0xE5BFBD },
	{ 0xDDC8, 0xE5BFBF },
	{ 0xE4E8, 0xE6808F },
	{ 0xD2C1, 0xE68092 },
	{ 0xF8D7, 0xE68096 },
	{ 0xD6BB, 0xE6809C },
	{ 0xDED6, 0xE6809D },
	{ 0xF7BD, 0xE680A0 },
	{ 0xECAE, 0xE680A1 },
	{ 0xD0E1, 0xE680A5 },
	{ 0xE0F5, 0xE680A7 },
	{ 0xEAB3, 0xE680A8 },
	{ 0xCED6, 0xE680AA },
	{ 0xCCA5, 0xE680AF },
	{ 0xECF6, 0xE68181 },
	{ 0xE2E1, 0xE68182 },
	{ 0xE3BE, 0xE68183 },
	{ 0xFCC8, 0xE6818D },
	{ 0xCDF0, 0xE68190 },
	{ 0xF9F6, 0xE68192 },
	{ 0xDFF0, 0xE68195 },
	{ 0xE5BF, 0xE68199 },
	{ 0xCEBF, 0xE6819D },
	{ 0xFCE1, 0xE681A2 },
	{ 0xEDB0, 0xE681A3 },
	{ 0xFDD1, 0xE681A4 },
	{ 0xF6BB, 0xE681A5 },
	{ 0xF9CF, 0xE681A8 },
	{ 0xEBDA, 0xE681A9 },
	{ 0xCAC1, 0xE681AA },
	{ 0xD2B8, 0xE681AC },
	{ 0xCDF1, 0xE681AD },
	{ 0xE3D3, 0xE681AF },
	{ 0xFDE6, 0xE681B0 },
	{ 0xE6ED, 0xE68285 },
	{ 0xE3FA, 0xE68289 },
	{ 0xF0AA, 0xE6828C },
	{ 0xF9D0, 0xE6828D },
	{ 0xFCE2, 0xE68294 },
	{ 0xF8A7, 0xE68296 },
	{ 0xE1E5, 0xE6829A },
	{ 0xEEF9, 0xE6829B },
	{ 0xE7F6, 0xE6829F },
	{ 0xEAED, 0xE682A0 },
	{ 0xFCB4, 0xE682A3 },
	{ 0xF5C2, 0xE682A4 },
	{ 0xD7DC, 0xE682A7 },
	{ 0xF0F5, 0xE682B0 },
	{ 0xDDE8, 0xE682B2 },
	{ 0xD3ED, 0xE682B3 },
	{ 0xF5FC, 0xE682B4 },
	{ 0xDABF, 0xE682B6 },
	{ 0xCCFB, 0xE682B8 },
	{ 0xD3FA, 0xE682BC },
	{ 0xF4A4, 0xE682BD },
	{ 0xEFD7, 0xE68385 },
	{ 0xD4C3, 0xE68387 },
	{ 0xFBE3, 0xE68391 },
	{ 0xFBED, 0xE6839A },
	{ 0xE0AD, 0xE6839C },
	{ 0xEAEE, 0xE6839F },
	{ 0xFBB3, 0xE683A0 },
	{ 0xE4C2, 0xE683A1 },
	{ 0xF6E7, 0xE683B0 },
	{ 0xD2DD, 0xE683B1 },
	{ 0xDFCC, 0xE683B3 },
	{ 0xFCC9, 0xE683B6 },
	{ 0xE5A9, 0xE683B9 },
	{ 0xE0F6, 0xE683BA },
	{ 0xF6B3, 0xE683BB },
	{ 0xE1FE, 0xE68481 },
	{ 0xCBF0, 0xE68486 },
	{ 0xEAEF, 0xE68488 },
	{ 0xEAF0, 0xE68489 },
	{ 0xDAC0, 0xE6848D },
	{ 0xF8B4, 0xE6848E },
	{ 0xEBF2, 0xE6848F },
	{ 0xE4C3, 0xE68495 },
	{ 0xE9D7, 0xE6849A },
	{ 0xE4F1, 0xE6849B },
	{ 0xCAEF, 0xE6849F },
	{ 0xCED7, 0xE684A7 },
	{ 0xFCCA, 0xE684B0 },
	{ 0xF3E1, 0xE684B4 },
	{ 0xCBC4, 0xE684B7 },
	{ 0xE3E5, 0xE684BC },
	{ 0xCBC5, 0xE684BE },
	{ 0xEAB4, 0xE684BF },
	{ 0xE9BD, 0xE68582 },
	{ 0xD7C9, 0xE68584 },
	{ 0xEBDB, 0xE68587 },
	{ 0xEDB1, 0xE68588 },
	{ 0xCCC3, 0xE6858A },
	{ 0xF7BE, 0xE6858B },
	{ 0xFCCB, 0xE6858C },
	{ 0xF8F4, 0xE68593 },
	{ 0xD9B7, 0xE68595 },
	{ 0xF3D3, 0xE68598 },
	{ 0xF3D4, 0xE68599 },
	{ 0xF7E4, 0xE6859D },
	{ 0xF7D1, 0xE6859F },
	{ 0xD8B7, 0xE685A2 },
	{ 0xCEB1, 0xE685A3 },
	{ 0xCAC2, 0xE685A4 },
	{ 0xFBB4, 0xE685A7 },
	{ 0xCBC6, 0xE685A8 },
	{ 0xF0F6, 0xE685AB },
	{ 0xD5E7, 0xE685AE },
	{ 0xEAD0, 0xE685B0 },
	{ 0xCCD4, 0xE685B6 },
	{ 0xCBAF, 0xE685B7 },
	{ 0xF4AA, 0xE685BD },
	{ 0xE9AF, 0xE685BE },
	{ 0xF5C3, 0xE68681 },
	{ 0xE9D8, 0xE68682 },
	{ 0xDDE9, 0xE6868A },
	{ 0xF1F3, 0xE6868E },
	{ 0xD5FB, 0xE68690 },
	{ 0xDEBB, 0xE68691 },
	{ 0xF4FB, 0xE68694 },
	{ 0xFDF3, 0xE68698 },
	{ 0xFDF2, 0xE68699 },
	{ 0xF7A6, 0xE6869A },
	{ 0xDDC9, 0xE686A4 },
	{ 0xD4D3, 0xE686A7 },
	{ 0xCCA8, 0xE686A9 },
	{ 0xDAC1, 0xE686AB },
	{ 0xCCD5, 0xE686AC },
	{ 0xD9E4, 0xE686AE },
	{ 0xFACA, 0xE686B2 },
	{ 0xE5E3, 0xE686B6 },
	{ 0xD3BC, 0xE686BA },
	{ 0xCAF0, 0xE686BE },
	{ 0xD0C4, 0xE68783 },
	{ 0xCAD0, 0xE68787 },
	{ 0xFAAB, 0xE68788 },
	{ 0xEBEB, 0xE68789 },
	{ 0xE7F8, 0xE6878A },
	{ 0xD9E5, 0xE6878B },
	{ 0xD1D7, 0xE687A6 },
	{ 0xF3A4, 0xE687B2 },
	{ 0xD4FB, 0xE687B6 },
	{ 0xFCE3, 0xE687B7 },
	{ 0xFAD8, 0xE687B8 },
	{ 0xF3D5, 0xE687BA },
	{ 0xCFAB, 0xE687BC },
	{ 0xEBF3, 0xE687BF },
	{ 0xD5FC, 0xE68880 },
	{ 0xD3D4, 0xE68887 },
	{ 0xCDFC, 0xE68888 },
	{ 0xD9E6, 0xE6888A },
	{ 0xE2F9, 0xE6888C },
	{ 0xE2A1, 0xE6888D },
	{ 0xEBD4, 0xE6888E },
	{ 0xE0F7, 0xE68890 },
	{ 0xE4B2, 0xE68891 },
	{ 0xCCFC, 0xE68892 },
	{ 0xFBE4, 0xE68896 },
	{ 0xF4AB, 0xE6889A },
	{ 0xD0BD, 0xE6889F },
	{ 0xCAF1, 0xE688A1 },
	{ 0xEFB8, 0xE688AA },
	{ 0xD7C0, 0xE688AE },
	{ 0xEEFA, 0xE688B0 },
	{ 0xFDF4, 0xE688B1 },
	{ 0xD3E3, 0xE688B4 },
	{ 0xFBC2, 0xE688B6 },
	{ 0xD5E8, 0xE688BE },
	{ 0xDBAE, 0xE688BF },
	{ 0xE1B6, 0xE68980 },
	{ 0xF8B7, 0xE68981 },
	{ 0xE0BF, 0xE68987 },
	{ 0xFBC3, 0xE68988 },
	{ 0xDDEA, 0xE68989 },
	{ 0xE2A2, 0xE6898B },
	{ 0xEEA6, 0xE6898D },
	{ 0xF6E8, 0xE68993 },
	{ 0xF6F5, 0xE68998 },
	{ 0xDDCA, 0xE689AE },
	{ 0xD0E2, 0xE689B1 },
	{ 0xDDA6, 0xE689B6 },
	{ 0xDDEB, 0xE689B9 },
	{ 0xE4F9, 0xE689BC },
	{ 0xE3AF, 0xE689BF },
	{ 0xD0FC, 0xE68A80 },
	{ 0xF4FC, 0xE68A84 },
	{ 0xCCBC, 0xE68A89 },
	{ 0xF7EA, 0xE68A8A },
	{ 0xE5E4, 0xE68A91 },
	{ 0xDFF1, 0xE68A92 },
	{ 0xF7E1, 0xE68A95 },
	{ 0xF9F7, 0xE68A97 },
	{ 0xEFB9, 0xE68A98 },
	{ 0xF8D8, 0xE68A9B },
	{ 0xF9A9, 0xE68AAB },
	{ 0xF8D9, 0xE68AB1 },
	{ 0xEEBD, 0xE68AB5 },
	{ 0xD8C6, 0xE68AB9 },
	{ 0xE4E3, 0xE68ABC },
	{ 0xF5CE, 0xE68ABD },
	{ 0xDDD9, 0xE68B82 },
	{ 0xD9E7, 0xE68B87 },
	{ 0xD2B9, 0xE68B88 },
	{ 0xD5C3, 0xE68B89 },
	{ 0xDAE5, 0xE68B8C },
	{ 0xDAD0, 0xE68B8D },
	{ 0xD1D9, 0xE68B8F },
	{ 0xCED8, 0xE68B90 },
	{ 0xCBDE, 0xE68B92 },
	{ 0xF4AC, 0xE68B93 },
	{ 0xDAFB, 0xE68B94 },
	{ 0xF6E9, 0xE68B96 },
	{ 0xE8F3, 0xE68B97 },
	{ 0xCFAC, 0xE68B98 },
	{ 0xF0F0, 0xE68B99 },
	{ 0xF4FD, 0xE68B9B },
	{ 0xDBC8, 0xE68B9C },
	{ 0xCEC0, 0xE68BAC },
	{ 0xE3D4, 0xE68BAD },
	{ 0xD1CF, 0xE68BAE },
	{ 0xF1F5, 0xE68BAF },
	{ 0xCDF2, 0xE68BB1 },
	{ 0xCFEB, 0xE68BB3 },
	{ 0xCDB8, 0xE68BB7 },
	{ 0xE3A6, 0xE68BBE },
	{ 0xD1DA, 0xE68BBF },
	{ 0xF2A5, 0xE68C81 },
	{ 0xF2A6, 0xE68C87 },
	{ 0xE4CE, 0xE68C89 },
	{ 0xD3FB, 0xE68C91 },
	{ 0xF1A9, 0xE68CAB },
	{ 0xF2C9, 0xE68CAF },
	{ 0xEFD8, 0xE68CBA },
	{ 0xE6C9, 0xE68CBB },
	{ 0xD8B8, 0xE68CBD },
	{ 0xFAF3, 0xE68CBE },
	{ 0xF3B5, 0xE68D89 },
	{ 0xF8A4, 0xE68D8C },
	{ 0xD1F3, 0xE68D8F },
	{ 0xE6C8, 0xE68D90 },
	{ 0xF8DA, 0xE68D95 },
	{ 0xDCE9, 0xE68DA7 },
	{ 0xDED7, 0xE68DA8 },
	{ 0xCBDF, 0xE68DAE },
	{ 0xCFEC, 0xE68DB2 },
	{ 0xF4DF, 0xE68DB7 },
	{ 0xD1F4, 0xE68DBA },
	{ 0xD2BA, 0xE68DBB },
	{ 0xDFF2, 0xE68DBF },
	{ 0xE1B7, 0xE68E83 },
	{ 0xE2A3, 0xE68E88 },
	{ 0xD3FC, 0xE68E89 },
	{ 0xEDE6, 0xE68E8C },
	{ 0xDBC9, 0xE68E92 },
	{ 0xE4FA, 0xE68E96 },
	{ 0xCFDE, 0xE68E98 },
	{ 0xCED0, 0xE68E9B },
	{ 0xD5D3, 0xE68EA0 },
	{ 0xF3F5, 0xE68EA1 },
	{ 0xF7AE, 0xE68EA2 },
	{ 0xEFC8, 0xE68EA5 },
	{ 0xCDF3, 0xE68EA7 },
	{ 0xF5CF, 0xE68EA8 },
	{ 0xE5F3, 0xE68EA9 },
	{ 0xF0C2, 0xE68EAA },
	{ 0xCAD1, 0xE68F80 },
	{ 0xEAF1, 0xE68F84 },
	{ 0xD0A6, 0xE68F86 },
	{ 0xD9DA, 0xE68F8F },
	{ 0xF0AB, 0xE68F90 },
	{ 0xEBE7, 0xE68F96 },
	{ 0xE5C0, 0xE68F9A },
	{ 0xFCB5, 0xE68F9B },
	{ 0xE4C4, 0xE68FA1 },
	{ 0xCCA9, 0xE68FAD },
	{ 0xFDC6, 0xE68FAE },
	{ 0xEAB5, 0xE68FB4 },
	{ 0xE5AA, 0xE68FB6 },
	{ 0xDFBA, 0xE68FB7 },
	{ 0xE1DF, 0xE6908D },
	{ 0xDAD1, 0xE6908F },
	{ 0xE1B8, 0xE69094 },
	{ 0xE8F4, 0xE69096 },
	{ 0xD3FD, 0xE69097 },
	{ 0xE2A4, 0xE6909C },
	{ 0xF2CA, 0xE690A2 },
	{ 0xDAE6, 0xE690AC },
	{ 0xF7B3, 0xE690AD },
	{ 0xFDCD, 0xE690BA },
	{ 0xF3B6, 0xE690BE },
	{ 0xEED7, 0xE69198 },
	{ 0xF5C4, 0xE691A0 },
	{ 0xD8A4, 0xE691A9 },
	{ 0xF2A7, 0xE691AF },
	{ 0xD9B8, 0xE691B8 },
	{ 0xD9B9, 0xE691B9 },
	{ 0xEFC9, 0xE691BA },
	{ 0xD6CE, 0xE69288 },
	{ 0xF7CB, 0xE69291 },
	{ 0xDFAE, 0xE69292 },
	{ 0xE8F5, 0xE69293 },
	{ 0xD2B5, 0xE6929A },
	{ 0xD3D5, 0xE6929E },
	{ 0xF4CC, 0xE692A4 },
	{ 0xDAFC, 0xE692A5 },
	{ 0xD9E8, 0xE692AB },
	{ 0xF7EB, 0xE692AD },
	{ 0xF5C9, 0xE692AE },
	{ 0xF3BC, 0xE692B0 },
	{ 0xDAD2, 0xE692B2 },
	{ 0xD3B5, 0xE692BB },
	{ 0xE8B6, 0xE69381 },
	{ 0xD6CF, 0xE69384 },
	{ 0xF4BA, 0xE69385 },
	{ 0xF7C9, 0xE69387 },
	{ 0xCCAA, 0xE6938A },
	{ 0xF0C3, 0xE6938D },
	{ 0xCCD6, 0xE6938E },
	{ 0xD0D3, 0xE69392 },
	{ 0xD3BD, 0xE69394 },
	{ 0xDBFB, 0xE69398 },
	{ 0xCBE0, 0xE6939A },
	{ 0xD3E4, 0xE693A1 },
	{ 0xF6F7, 0xE693A2 },
	{ 0xD5BA, 0xE693A5 },
	{ 0xF3CD, 0xE693A6 },
	{ 0xCBE1, 0xE693A7 },
	{ 0xEBF4, 0xE693AC },
	{ 0xF4AD, 0xE693B2 },
	{ 0xFCAA, 0xE693B4 },
	{ 0xF7EC, 0xE693BA },
	{ 0xE8F6, 0xE693BE },
	{ 0xDAE7, 0xE69480 },
	{ 0xF7CC, 0xE69484 },
	{ 0xE5C1, 0xE69498 },
	{ 0xE0EE, 0xE6949D },
	{ 0xD5FD, 0xE694A3 },
	{ 0xCEE6, 0xE694AA },
	{ 0xFCAB, 0xE694AB },
	{ 0xD5BB, 0xE694AC },
	{ 0xF2A8, 0xE694AF },
	{ 0xE2A5, 0xE694B6 },
	{ 0xCDB9, 0xE694B7 },
	{ 0xEAF2, 0xE694B8 },
	{ 0xCBC7, 0xE694B9 },
	{ 0xCDF4, 0xE694BB },
	{ 0xDBAF, 0xE694BE },
	{ 0xEFD9, 0xE694BF },
	{ 0xCDBA, 0xE69585 },
	{ 0xFCF9, 0xE69588 },
	{ 0xDFF3, 0xE6958D },
	{ 0xCEE7, 0xE6958E },
	{ 0xDAC2, 0xE6958F },
	{ 0xCFAD, 0xE69591 },
	{ 0xE7F9, 0xE69596 },
	{ 0xF8A8, 0xE69597 },
	{ 0xF3E2, 0xE6959E },
	{ 0xCAF2, 0xE695A2 },
	{ 0xDFA4, 0xE695A3 },
	{ 0xD4C4, 0xE695A6 },
	{ 0xCCD7, 0xE695AC },
	{ 0xE5C2, 0xE695AD },
	{ 0xCDBB, 0xE695B2 },
	{ 0xEFDA, 0xE695B4 },
	{ 0xEED8, 0xE695B5 },
	{ 0xDDA7, 0xE695B7 },
	{ 0xE2A6, 0xE695B8 },
	{ 0xE0C0, 0xE695BE },
	{ 0xD6B0, 0xE69682 },
	{ 0xF8CA, 0xE69683 },
	{ 0xFCFA, 0xE69685 },
	{ 0xD9FE, 0xE69687 },
	{ 0xDEB0, 0xE6968C },
	{ 0xDDEC, 0xE69690 },
	{ 0xDAE8, 0xE69691 },
	{ 0xD4E0, 0xE69697 },
	{ 0xD6F9, 0xE69699 },
	{ 0xCDD7, 0xE6969B },
	{ 0xDED8, 0xE6969C },
	{ 0xF2F8, 0xE6969F },
	{ 0xE4D6, 0xE696A1 },
	{ 0xD0C5, 0xE696A4 },
	{ 0xF4AE, 0xE696A5 },
	{ 0xDDA8, 0xE696A7 },
	{ 0xEDC5, 0xE696AB },
	{ 0xF3D6, 0xE696AC },
	{ 0xDED9, 0xE696AF },
	{ 0xE3E6, 0xE696B0 },
	{ 0xD3A8, 0xE696B7 },
	{ 0xDBB0, 0xE696B9 },
	{ 0xE5DA, 0xE696BC },
	{ 0xE3BF, 0xE696BD },
	{ 0xDBB1, 0xE69781 },
	{ 0xD5E9, 0xE69785 },
	{ 0xE0C1, 0xE6978B },
	{ 0xEFDB, 0xE6978C },
	{ 0xF0E9, 0xE6978F },
	{ 0xD7B2, 0xE69792 },
	{ 0xD0FD, 0xE69797 },
	{ 0xD9E9, 0xE697A0 },
	{ 0xD0FE, 0xE697A3 },
	{ 0xECED, 0xE697A5 },
	{ 0xD3A9, 0xE697A6 },
	{ 0xF2A9, 0xE697A8 },
	{ 0xF0C4, 0xE697A9 },
	{ 0xE2E2, 0xE697AC },
	{ 0xE9EF, 0xE697AD },
	{ 0xF9D1, 0xE697B1 },
	{ 0xE9D9, 0xE697B4 },
	{ 0xE8DA, 0xE697BA },
	{ 0xDAC3, 0xE697BB },
	{ 0xDAC4, 0xE697BC },
	{ 0xD4C5, 0xE697BD },
	{ 0xE7FA, 0xE697BF },
	{ 0xCDE0, 0xE69886 },
	{ 0xE3B0, 0xE69887 },
	{ 0xDBB2, 0xE69889 },
	{ 0xFBC4, 0xE6988A },
	{ 0xF3E3, 0xE6988C },
	{ 0xD9A5, 0xE6988E },
	{ 0xFBE7, 0xE6988F },
	{ 0xDDCB, 0xE69890 },
	{ 0xD0D4, 0xE69891 },
	{ 0xE6B6, 0xE69893 },
	{ 0xE0AE, 0xE69894 },
	{ 0xFDDA, 0xE69895 },
	{ 0xDCB5, 0xE6989E },
	{ 0xE0F8, 0xE6989F },
	{ 0xE7B1, 0xE698A0 },
	{ 0xF5F0, 0xE698A5 },
	{ 0xD8DC, 0xE698A7 },
	{ 0xEDC6, 0xE698A8 },
	{ 0xE1B9, 0xE698AD },
	{ 0xE3C0, 0xE698AF },
	{ 0xF9C0, 0xE698B0 },
	{ 0xE9F0, 0xE698B1 },
	{ 0xD9DB, 0xE698B4 },
	{ 0xF3E4, 0xE698B6 },
	{ 0xDCB6, 0xE698BA },
	{ 0xE4E9, 0xE698BB },
	{ 0xF0C5, 0xE69981 },
	{ 0xE3C1, 0xE69982 },
	{ 0xFCCC, 0xE69983 },
	{ 0xFCCD, 0xE69984 },
	{ 0xF2CB, 0xE69989 },
	{ 0xF2CC, 0xE6998B },
	{ 0xE4CF, 0xE6998F },
	{ 0xF1DB, 0xE69999 },
	{ 0xFAD9, 0xE6999B },
	{ 0xF1B8, 0xE6999D },
	{ 0xFDF5, 0xE6999E },
	{ 0xE0F9, 0xE6999F },
	{ 0xE7FB, 0xE699A4 },
	{ 0xFCB7, 0xE699A5 },
	{ 0xFCE4, 0xE699A6 },
	{ 0xFBC5, 0xE699A7 },
	{ 0xE3E7, 0xE699A8 },
	{ 0xD8B9, 0xE699A9 },
	{ 0xF6F8, 0xE699AB },
	{ 0xDCC5, 0xE699AE },
	{ 0xCCD8, 0xE699AF },
	{ 0xE0AF, 0xE699B3 },
	{ 0xF4E7, 0xE699B4 },
	{ 0xEFDC, 0xE699B6 },
	{ 0xCFFC, 0xE699B7 },
	{ 0xEFDD, 0xE699B8 },
	{ 0xF2AA, 0xE699BA },
	{ 0xFDBE, 0xE69A84 },
	{ 0xCAAC, 0xE69A87 },
	{ 0xFDBB, 0xE69A88 },
	{ 0xFDC7, 0xE69A89 },
	{ 0xE7B2, 0xE69A8E },
	{ 0xEAD1, 0xE69A90 },
	{ 0xDFF4, 0xE69A91 },
	{ 0xD1EC, 0xE69A96 },
	{ 0xE4DE, 0xE69A97 },
	{ 0xE5C3, 0xE69A98 },
	{ 0xD9A6, 0xE69A9D },
	{ 0xCDBC, 0xE69AA0 },
	{ 0xF3E5, 0xE69AA2 },
	{ 0xEDD5, 0xE69AAB },
	{ 0xD9BA, 0xE69AAE },
	{ 0xEDE7, 0xE69AB2 },
	{ 0xFBB5, 0xE69AB3 },
	{ 0xF8EC, 0xE69AB4 },
	{ 0xE0E7, 0xE69AB9 },
	{ 0xCCD9, 0xE69ABB },
	{ 0xD4C6, 0xE69ABE },
	{ 0xE7A5, 0xE69B84 },
	{ 0xD5F5, 0xE69B86 },
	{ 0xD3BE, 0xE69B87 },
	{ 0xFCFB, 0xE69B89 },
	{ 0xE4F2, 0xE69B96 },
	{ 0xDFF5, 0xE69B99 },
	{ 0xE8F8, 0xE69B9C },
	{ 0xF8ED, 0xE69B9D },
	{ 0xCEC7, 0xE69BA0 },
	{ 0xFDF6, 0xE69BA6 },
	{ 0xE8D8, 0xE69BB0 },
	{ 0xCDD8, 0xE69BB2 },
	{ 0xE7D6, 0xE69BB3 },
	{ 0xCCDA, 0xE69BB4 },
	{ 0xCAE3, 0xE69BB7 },
	{ 0xDFF6, 0xE69BB8 },
	{ 0xF0C7, 0xE69BB9 },
	{ 0xF0C6, 0xE69BBA },
	{ 0xD8BA, 0xE69BBC },
	{ 0xF1F4, 0xE69BBE },
	{ 0xF4F0, 0xE69BBF },
	{ 0xF5CC, 0xE69C80 },
	{ 0xFCE5, 0xE69C83 },
	{ 0xEAC5, 0xE69C88 },
	{ 0xEAF3, 0xE69C89 },
	{ 0xDDDB, 0xE69C8B },
	{ 0xDCD7, 0xE69C8D },
	{ 0xDEFD, 0xE69C94 },
	{ 0xF2F9, 0xE69C95 },
	{ 0xD5C7, 0xE69C97 },
	{ 0xD8D0, 0xE69C9B },
	{ 0xF0C8, 0xE69C9D },
	{ 0xD1A1, 0xE69C9E },
	{ 0xD1A2, 0xE69C9F },
	{ 0xD9D4, 0xE69CA6 },
	{ 0xD6E8, 0xE69CA7 },
	{ 0xD9CA, 0xE69CA8 },
	{ 0xDAB1, 0xE69CAA },
	{ 0xD8C7, 0xE69CAB },
	{ 0xDCE2, 0xE69CAC },
	{ 0xF3CE, 0xE69CAD },
	{ 0xF5F4, 0xE69CAE },
	{ 0xF1B9, 0xE69CB1 },
	{ 0xDAD3, 0xE69CB4 },
	{ 0xF6EA, 0xE69CB6 },
	{ 0xCFF5, 0xE69CBA },
	{ 0xFDAE, 0xE69CBD },
	{ 0xCAD2, 0xE69D86 },
	{ 0xDFB4, 0xE69D89 },
	{ 0xD7DD, 0xE69D8E },
	{ 0xFABA, 0xE69D8F },
	{ 0xEEA7, 0xE69D90 },
	{ 0xF5BD, 0xE69D91 },
	{ 0xF8F5, 0xE69D93 },
	{ 0xEDE8, 0xE69D96 },
	{ 0xD4E1, 0xE69D9C },
	{ 0xD1A3, 0xE69D9E },
	{ 0xE1D6, 0xE69D9F },
	{ 0xF9F8, 0xE69DAD },
	{ 0xDBCA, 0xE69DAF },
	{ 0xCBF9, 0xE69DB0 },
	{ 0xD4D4, 0xE69DB1 },
	{ 0xD9DC, 0xE69DB3 },
	{ 0xEEBE, 0xE69DB5 },
	{ 0xF7ED, 0xE69DB7 },
	{ 0xD2EE, 0xE69DBB },
	{ 0xE1E6, 0xE69DBE },
	{ 0xF7F9, 0xE69DBF },
	{ 0xDDED, 0xE69E87 },
	{ 0xE8DB, 0xE69E89 },
	{ 0xDBB3, 0xE69E8B },
	{ 0xD1F7, 0xE69E8F },
	{ 0xE0B0, 0xE69E90 },
	{ 0xD4E2, 0xE69E93 },
	{ 0xF6D7, 0xE69E95 },
	{ 0xD7F9, 0xE69E97 },
	{ 0xD8DD, 0xE69E9A },
	{ 0xCDFD, 0xE69E9C },
	{ 0xF2AB, 0xE69E9D },
	{ 0xCDBD, 0xE69EAF },
	{ 0xF8C2, 0xE69EB0 },
	{ 0xF2AC, 0xE69EB3 },
	{ 0xCAAD, 0xE69EB6 },
	{ 0xCAAE, 0xE69EB7 },
	{ 0xCFAE, 0xE69EB8 },
	{ 0xE3C2, 0xE69EBE },
	{ 0xDCB7, 0xE69F84 },
	{ 0xDBDA, 0xE69F8F },
	{ 0xD9BB, 0xE69F90 },
	{ 0xCAF3, 0xE69F91 },
	{ 0xF6D3, 0xE69F92 },
	{ 0xE6F8, 0xE69F93 },
	{ 0xEAF5, 0xE69F94 },
	{ 0xEAF6, 0xE69F9A },
	{ 0xF6F9, 0xE69F9D },
	{ 0xCFAF, 0xE69FA9 },
	{ 0xCAD3, 0xE69FAC },
	{ 0xCAAF, 0xE69FAF },
	{ 0xD2B0, 0xE69FB0 },
	{ 0xF1BA, 0xE69FB1 },
	{ 0xD7B3, 0xE69FB3 },
	{ 0xE3C3, 0xE69FB4 },
	{ 0xF3FD, 0xE69FB5 },
	{ 0xDEDA, 0xE69FB6 },
	{ 0xDEDB, 0xE69FBB },
	{ 0xEFDE, 0xE69FBE },
	{ 0xE2E3, 0xE6A092 },
	{ 0xEEFB, 0xE6A093 },
	{ 0xDFF7, 0xE6A096 },
	{ 0xD7CA, 0xE6A097 },
	{ 0xCEE8, 0xE6A0A1 },
	{ 0xDBDB, 0xE6A0A2 },
	{ 0xF1BB, 0xE6A0AA },
	{ 0xE9F1, 0xE6A0AF },
	{ 0xFAB7, 0xE6A0B8 },
	{ 0xD0C6, 0xE6A0B9 },
	{ 0xCCAB, 0xE6A0BC },
	{ 0xEEA8, 0xE6A0BD },
	{ 0xCBFA, 0xE6A180 },
	{ 0xF9F9, 0xE6A181 },
	{ 0xCCFD, 0xE6A182 },
	{ 0xD3FE, 0xE6A183 },
	{ 0xE4D0, 0xE6A188 },
	{ 0xF2EE, 0xE6A18E },
	{ 0xD4D5, 0xE6A190 },
	{ 0xDFCD, 0xE6A191 },
	{ 0xFCB8, 0xE6A193 },
	{ 0xD1D0, 0xE6A194 },
	{ 0xF2CD, 0xE6A1AD },
	{ 0xF7D2, 0xE6A1B6 },
	{ 0xCAD4, 0xE6A1BF },
	{ 0xD5D9, 0xE6A281 },
	{ 0xD8DE, 0xE6A285 },
	{ 0xCDD9, 0xE6A28F },
	{ 0xEEA9, 0xE6A293 },
	{ 0xF6BC, 0xE6A294 },
	{ 0xCCDB, 0xE6A297 },
	{ 0xF0C9, 0xE6A29D },
	{ 0xFCFC, 0xE6A29F },
	{ 0xE8C9, 0xE6A2A1 },
	{ 0xF4FE, 0xE6A2A2 },
	{ 0xE7FC, 0xE6A2A7 },
	{ 0xD7DE, 0xE6A2A8 },
	{ 0xDEDC, 0xE6A2AD },
	{ 0xF0AC, 0xE6A2AF },
	{ 0xCCFE, 0xE6A2B0 },
	{ 0xCDE1, 0xE6A2B1 },
	{ 0xE1BA, 0xE6A2B3 },
	{ 0xDBEF, 0xE6A2B5 },
	{ 0xDAB2, 0xE6A2B6 },
	{ 0xD1A5, 0xE6A384 },
	{ 0xDCB8, 0xE6A385 },
	{ 0xD8F6, 0xE6A389 },
	{ 0xD1A4, 0xE6A38B },
	{ 0xCDE2, 0xE6A38D },
	{ 0xDCEA, 0xE6A392 },
	{ 0xF0F7, 0xE6A395 },
	{ 0xF0CA, 0xE6A397 },
	{ 0xD0BE, 0xE6A398 },
	{ 0xDDDC, 0xE6A39A },
	{ 0xD4D6, 0xE6A39F },
	{ 0xD3D6, 0xE6A3A0 },
	{ 0xEDD0, 0xE6A3A7 },
	{ 0xCDA1, 0xE6A3A8 },
	{ 0xDFB5, 0xE6A3AE },
	{ 0xDFF8, 0xE6A3B2 },
	{ 0xD4A1, 0xE6A3B9 },
	{ 0xCEB2, 0xE6A3BA },
	{ 0xE8CA, 0xE6A480 },
	{ 0xEBF5, 0xE6A485 },
	{ 0xE3D5, 0xE6A48D },
	{ 0xF5D0, 0xE6A48E },
	{ 0xF5A1, 0xE6A492 },
	{ 0xD9A7, 0xE6A4A7 },
	{ 0xE5AB, 0xE6A4B0 },
	{ 0xE6CB, 0xE6A4BD },
	{ 0xF5F1, 0xE6A4BF },
	{ 0xE5C5, 0xE6A58A },
	{ 0xF9A3, 0xE6A593 },
	{ 0xE0DB, 0xE6A594 },
	{ 0xF6EB, 0xE6A595 },
	{ 0xCBF1, 0xE6A597 },
	{ 0xD9EA, 0xE6A599 },
	{ 0xF5A2, 0xE6A59A },
	{ 0xD7D1, 0xE6A59E },
	{ 0xD1F8, 0xE6A5A0 },
	{ 0xEAF8, 0xE6A5A1 },
	{ 0xEAF9, 0xE6A5A2 },
	{ 0xDAB3, 0xE6A5A3 },
	{ 0xEFDF, 0xE6A5A8 },
	{ 0xF1EF, 0xE6A5AB },
	{ 0xE5F6, 0xE6A5AD },
	{ 0xEEBF, 0xE6A5AE },
	{ 0xE2E4, 0xE6A5AF },
	{ 0xD0BF, 0xE6A5B5 },
	{ 0xFAAC, 0xE6A5B7 },
	{ 0xF5D1, 0xE6A5B8 },
	{ 0xE7B3, 0xE6A5B9 },
	{ 0xE9BE, 0xE6A695 },
	{ 0xF2CE, 0xE6A69B },
	{ 0xDBB4, 0xE6A69C },
	{ 0xFCCE, 0xE6A6A5 },
	{ 0xDDEE, 0xE6A6A7 },
	{ 0xE7B4, 0xE6A6AE },
	{ 0xD7B4, 0xE6A6B4 },
	{ 0xF7B4, 0xE6A6BB },
	{ 0xCDBE, 0xE6A781 },
	{ 0xDAE9, 0xE6A783 },
	{ 0xCFB0, 0xE6A78B },
	{ 0xF7D9, 0xE6A78C },
	{ 0xF3E6, 0xE6A78D },
	{ 0xCED9, 0xE6A790 },
	{ 0xCEAA, 0xE6A7A8 },
	{ 0xCBC8, 0xE6A7AA },
	{ 0xD0A7, 0xE6A7BB },
	{ 0xF0CB, 0xE6A7BD },
	{ 0xD0C7, 0xE6A7BF },
	{ 0xE4C5, 0xE6A882 },
	{ 0xDBE0, 0xE6A88A },
	{ 0xD5DA, 0xE6A891 },
	{ 0xD7A7, 0xE6A893 },
	{ 0xEEC0, 0xE6A897 },
	{ 0xF8F6, 0xE6A899 },
	{ 0xF5D2, 0xE6A89E },
	{ 0xEDE9, 0xE6A89F },
	{ 0xD9BC, 0xE6A8A1 },
	{ 0xE5C6, 0xE6A8A3 },
	{ 0xF5A3, 0xE6A8B5 },
	{ 0xDAD4, 0xE6A8B8 },
	{ 0xE2A7, 0xE6A8B9 },
	{ 0xFBFC, 0xE6A8BA },
	{ 0xF1DC, 0xE6A8BD },
	{ 0xCAF4, 0xE6A984 },
	{ 0xE8FA, 0xE6A988 },
	{ 0xCEE9, 0xE6A98B },
	{ 0xE9F8, 0xE6A992 },
	{ 0xE2E5, 0xE6A993 },
	{ 0xD0B9, 0xE6A998 },
	{ 0xD4F2, 0xE6A999 },
	{ 0xD1A6, 0xE6A99F },
	{ 0xDFCE, 0xE6A9A1 },
	{ 0xFCF4, 0xE6A9AB },
	{ 0xD3AA, 0xE6AA80 },
	{ 0xCCAC, 0xE6AA84 },
	{ 0xEFE0, 0xE6AA89 },
	{ 0xE5E5, 0xE6AA8D },
	{ 0xD0D5, 0xE6AA8E },
	{ 0xDBFC, 0xE6AA97 },
	{ 0xFCE6, 0xE6AA9C },
	{ 0xCBFE, 0xE6AAA2 },
	{ 0xEDEA, 0xE6AAA3 },
	{ 0xDEB1, 0xE6AAB3 },
	{ 0xF9E3, 0xE6AABB },
	{ 0xD4A2, 0xE6AB82 },
	{ 0xCFF6, 0xE6AB83 },
	{ 0xD6D0, 0xE6AB93 },
	{ 0xD5EA, 0xE6AB9A },
	{ 0xF1EE, 0xE6AB9B },
	{ 0xFACB, 0xE6ABB6 },
	{ 0xE5A1, 0xE6ABBB },
	{ 0xD5B1, 0xE6AC84 },
	{ 0xCFED, 0xE6AC8A },
	{ 0xEDEB, 0xE6AC8C },
	{ 0xD5B2, 0xE6AC92 },
	{ 0xD5BC, 0xE6AC96 },
	{ 0xFDE2, 0xE6ACA0 },
	{ 0xF3AD, 0xE6ACA1 },
	{ 0xFDDB, 0xE6ACA3 },
	{ 0xE9B0, 0xE6ACB2 },
	{ 0xD1A7, 0xE6ACBA },
	{ 0xFDE3, 0xE6ACBD },
	{ 0xCEB3, 0xE6ACBE },
	{ 0xFDE4, 0xE6AD86 },
	{ 0xFACE, 0xE6AD87 },
	{ 0xCAB0, 0xE6AD8C },
	{ 0xF7A7, 0xE6AD8E },
	{ 0xCFB1, 0xE6AD90 },
	{ 0xE6A2, 0xE6AD9F },
	{ 0xFCB6, 0xE6ADA1 },
	{ 0xF2AD, 0xE6ADA2 },
	{ 0xEFE1, 0xE6ADA3 },
	{ 0xF3AE, 0xE6ADA4 },
	{ 0xDCC6, 0xE6ADA5 },
	{ 0xD9EB, 0xE6ADA6 },
	{ 0xE8E0, 0xE6ADAA },
	{ 0xE1A8, 0xE6ADB2 },
	{ 0xD5F6, 0xE6ADB7 },
	{ 0xCFFD, 0xE6ADB8 },
	{ 0xDEDD, 0xE6ADBB },
	{ 0xD9D1, 0xE6ADBF },
	{ 0xE4EA, 0xE6AE83 },
	{ 0xF2CF, 0xE6AE84 },
	{ 0xF7BF, 0xE6AE86 },
	{ 0xE2E6, 0xE6AE89 },
	{ 0xE2A8, 0xE6AE8A },
	{ 0xE3D6, 0xE6AE96 },
	{ 0xEDD1, 0xE6AE98 },
	{ 0xE9F9, 0xE6AE9E },
	{ 0xD6B1, 0xE6AEAE },
	{ 0xDEB2, 0xE6AEAF },
	{ 0xE0E8, 0xE6AEB2 },
	{ 0xD3AB, 0xE6AEB5 },
	{ 0xEBDC, 0xE6AEB7 },
	{ 0xDFAF, 0xE6AEBA },
	{ 0xCAC3, 0xE6AEBC },
	{ 0xEEFC, 0xE6AEBF },
	{ 0xFDC3, 0xE6AF81 },
	{ 0xEBF6, 0xE6AF85 },
	{ 0xCFB2, 0xE6AF86 },
	{ 0xD9EC, 0xE6AF8B },
	{ 0xD9BD, 0xE6AF8D },
	{ 0xD8DF, 0xE6AF8F },
	{ 0xD4B8, 0xE6AF92 },
	{ 0xEBBE, 0xE6AF93 },
	{ 0xDDEF, 0xE6AF94 },
	{ 0xDDF0, 0xE6AF96 },
	{ 0xDDF1, 0xE6AF97 },
	{ 0xDDF2, 0xE6AF98 },
	{ 0xD9BE, 0xE6AF9B },
	{ 0xFBC6, 0xE6AFAB },
	{ 0xCFB3, 0xE6AFAC },
	{ 0xEEFD, 0xE6B088 },
	{ 0xE4AB, 0xE6B08F },
	{ 0xDAC5, 0xE6B091 },
	{ 0xD8EC, 0xE6B093 },
	{ 0xD1A8, 0xE6B0A3 },
	{ 0xE2A9, 0xE6B0B4 },
	{ 0xDEBC, 0xE6B0B7 },
	{ 0xE7B5, 0xE6B0B8 },
	{ 0xDBF0, 0xE6B0BE },
	{ 0xEFE2, 0xE6B180 },
	{ 0xF1F0, 0xE6B181 },
	{ 0xCFB4, 0xE6B182 },
	{ 0xDBF1, 0xE6B18E },
	{ 0xE0B1, 0xE6B190 },
	{ 0xDFA5, 0xE6B195 },
	{ 0xF9D2, 0xE6B197 },
	{ 0xE7FD, 0xE6B19A },
	{ 0xE6A3, 0xE6B19D },
	{ 0xFBF1, 0xE6B19E },
	{ 0xCBB0, 0xE6B19F },
	{ 0xF2AE, 0xE6B1A0 },
	{ 0xCDE7, 0xE6B1A8 },
	{ 0xE8DC, 0xE6B1AA },
	{ 0xE7D7, 0xE6B1AD },
	{ 0xF7C0, 0xE6B1B0 },
	{ 0xD0E3, 0xE6B1B2 },
	{ 0xDAA1, 0xE6B1B6 },
	{ 0xCCBD, 0xE6B1BA },
	{ 0xD1A9, 0xE6B1BD },
	{ 0xDDCC, 0xE6B1BE },
	{ 0xE3FE, 0xE6B281 },
	{ 0xD1AA, 0xE6B282 },
	{ 0xE8AA, 0xE6B283 },
	{ 0xEAB6, 0xE6B285 },
	{ 0xF9FA, 0xE6B286 },
	{ 0xE6CC, 0xE6B287 },
	{ 0xF6D8, 0xE6B288 },
	{ 0xD4C7, 0xE6B28C },
	{ 0xD9CB, 0xE6B290 },
	{ 0xD9D2, 0xE6B292 },
	{ 0xD3CB, 0xE6B293 },
	{ 0xD8F7, 0xE6B294 },
	{ 0xDAA9, 0xE6B295 },
	{ 0xF5F8, 0xE6B296 },
	{ 0xDEDE, 0xE6B299 },
	{ 0xF2AF, 0xE6B29A },
	{ 0xF8A9, 0xE6B29B },
	{ 0xD8C8, 0xE6B2AB },
	{ 0xEEC1, 0xE6B2AE },
	{ 0xF9C1, 0xE6B2B3 },
	{ 0xDDF3, 0xE6B2B8 },
	{ 0xEAFA, 0xE6B2B9 },
	{ 0xF6BD, 0xE6B2BB },
	{ 0xE1BB, 0xE6B2BC },
	{ 0xCDBF, 0xE6B2BD },
	{ 0xF4D4, 0xE6B2BE },
	{ 0xE6CD, 0xE6B2BF },
	{ 0xFCCF, 0xE6B381 },
	{ 0xFBA2, 0xE6B382 },
	{ 0xE0DC, 0xE6B384 },
	{ 0xF4BB, 0xE6B389 },
	{ 0xDAD5, 0xE6B38A },
	{ 0xF9B2, 0xE6B38C },
	{ 0xFBF2, 0xE6B393 },
	{ 0xDBF6, 0xE6B395 },
	{ 0xDEDF, 0xE6B397 },
	{ 0xDBF2, 0xE6B39B },
	{ 0xF8DC, 0xE6B3A1 },
	{ 0xF7EE, 0xE6B3A2 },
	{ 0xEBE8, 0xE6B3A3 },
	{ 0xD2FA, 0xE6B3A5 },
	{ 0xF1BC, 0xE6B3A8 },
	{ 0xFADA, 0xE6B3AB },
	{ 0xDAEA, 0xE6B3AE },
	{ 0xDAC6, 0xE6B3AF },
	{ 0xF7C1, 0xE6B3B0 },
	{ 0xE7B6, 0xE6B3B3 },
	{ 0xE5C7, 0xE6B48B },
	{ 0xD6AC, 0xE6B48C },
	{ 0xDCC7, 0xE6B491 },
	{ 0xE1A9, 0xE6B497 },
	{ 0xE2AA, 0xE6B499 },
	{ 0xD5A6, 0xE6B49B },
	{ 0xD4D7, 0xE6B49E },
	{ 0xF2D0, 0xE6B4A5 },
	{ 0xEAFB, 0xE6B4A7 },
	{ 0xE0DD, 0xE6B4A9 },
	{ 0xFBF3, 0xE6B4AA },
	{ 0xF1BD, 0xE6B4B2 },
	{ 0xE2E7, 0xE6B4B5 },
	{ 0xFDD7, 0xE6B4B6 },
	{ 0xCEC8, 0xE6B4B8 },
	{ 0xEAB7, 0xE6B4B9 },
	{ 0xFCC0, 0xE6B4BB },
	{ 0xFDE7, 0xE6B4BD },
	{ 0xF7EF, 0xE6B4BE },
	{ 0xD7B5, 0xE6B581 },
	{ 0xEFBA, 0xE6B599 },
	{ 0xF1DD, 0xE6B59A },
	{ 0xDEB3, 0xE6B59C },
	{ 0xE8CB, 0xE6B5A3 },
	{ 0xF8DD, 0xE6B5A6 },
	{ 0xFBC7, 0xE6B5A9 },
	{ 0xD5C8, 0xE6B5AA },
	{ 0xD7DF, 0xE6B5AC },
	{ 0xDDA9, 0xE6B5AE },
	{ 0xE9B1, 0xE6B5B4 },
	{ 0xFAAD, 0xE6B5B7 },
	{ 0xF6D9, 0xE6B5B8 },
	{ 0xFAF4, 0xE6B5B9 },
	{ 0xF8AA, 0xE6B5BF },
	{ 0xE6EE, 0xE6B685 },
	{ 0xCCDC, 0xE6B687 },
	{ 0xE1BC, 0xE6B688 },
	{ 0xE0EF, 0xE6B689 },
	{ 0xE9BF, 0xE6B68C },
	{ 0xFCFD, 0xE6B68D },
	{ 0xE6CE, 0xE6B68E },
	{ 0xE1D7, 0xE6B691 },
	{ 0xE6CF, 0xE6B693 },
	{ 0xF4F1, 0xE6B695 },
	{ 0xE4F3, 0xE6B6AF },
	{ 0xE4FB, 0xE6B6B2 },
	{ 0xF9E4, 0xE6B6B5 },
	{ 0xEFE3, 0xE6B780 },
	{ 0xCFEE, 0xE6B783 },
	{ 0xF6BE, 0xE6B784 },
	{ 0xE0B2, 0xE6B785 },
	{ 0xFCFE, 0xE6B786 },
	{ 0xD1AB, 0xE6B787 },
	{ 0xD7FA, 0xE6B78B },
	{ 0xFBC8, 0xE6B78F },
	{ 0xE2D7, 0xE6B791 },
	{ 0xD4A3, 0xE6B798 },
	{ 0xF0F8, 0xE6B799 },
	{ 0xD7A8, 0xE6B79A },
	{ 0xE1E7, 0xE6B79E },
	{ 0xD3BF, 0xE6B7A1 },
	{ 0xEFE4, 0xE6B7A8 },
	{ 0xD7C5, 0xE6B7AA },
	{ 0xEBE2, 0xE6B7AB },
	{ 0xFCE7, 0xE6B7AE },
	{ 0xE4A2, 0xE6B7B1 },
	{ 0xE2E8, 0xE6B7B3 },
	{ 0xE6D0, 0xE6B7B5 },
	{ 0xFBE8, 0xE6B7B7 },
	{ 0xF4E8, 0xE6B7B8 },
	{ 0xE5F4, 0xE6B7B9 },
	{ 0xF4BC, 0xE6B7BA },
	{ 0xF4D5, 0xE6B7BB },
	{ 0xDFB6, 0xE6B897 },
	{ 0xFCB9, 0xE6B899 },
	{ 0xEEC2, 0xE6B89A },
	{ 0xCAF5, 0xE6B89B },
	{ 0xEFE5, 0xE6B89F },
	{ 0xCBE2, 0xE6B8A0 },
	{ 0xD4A4, 0xE6B8A1 },
	{ 0xDEE0, 0xE6B8A3 },
	{ 0xDAFD, 0xE6B8A4 },
	{ 0xE4C6, 0xE6B8A5 },
	{ 0xE8BE, 0xE6B8A6 },
	{ 0xE0DE, 0xE6B8AB },
	{ 0xF6B4, 0xE6B8AC },
	{ 0xEAD2, 0xE6B8AD },
	{ 0xF9FB, 0xE6B8AF },
	{ 0xE0C2, 0xE6B8B2 },
	{ 0xCAE4, 0xE6B8B4 },
	{ 0xE7B7, 0xE6B8B6 },
	{ 0xEAFD, 0xE6B8B8 },
	{ 0xD9DD, 0xE6B8BA },
	{ 0xDAB4, 0xE6B8BC },
	{ 0xEEAA, 0xE6B8BD },
	{ 0xFBE9, 0xE6B8BE },
	{ 0xDBCB, 0xE6B983 },
	{ 0xDAB5, 0xE6B984 },
	{ 0xF1BE, 0xE6B98A },
	{ 0xD3AC, 0xE6B98D },
	{ 0xFBC9, 0xE6B996 },
	{ 0xDFCF, 0xE6B998 },
	{ 0xD3C0, 0xE6B99B },
	{ 0xE3D7, 0xE6B99C },
	{ 0xEFE6, 0xE6B99E },
	{ 0xFCD0, 0xE6B99F },
	{ 0xE9C0, 0xE6B9A7 },
	{ 0xF5D3, 0xE6B9AB },
	{ 0xECDC, 0xE6B9AE },
	{ 0xF7B7, 0xE6B9AF },
	{ 0xEAB8, 0xE6B9B2 },
	{ 0xD1F9, 0xE6B9B3 },
	{ 0xDCC8, 0xE6B9BA },
	{ 0xEAB9, 0xE6BA90 },
	{ 0xF1DE, 0xE6BA96 },
	{ 0xD7B6, 0xE6BA9C },
	{ 0xCFB5, 0xE6BA9D },
	{ 0xD9A8, 0xE6BA9F },
	{ 0xECEE, 0xE6BAA2 },
	{ 0xDDAA, 0xE6BAA5 },
	{ 0xCDA2, 0xE6BAAA },
	{ 0xE8AE, 0xE6BAAB },
	{ 0xE1BD, 0xE6BAAF },
	{ 0xF2D1, 0xE6BAB1 },
	{ 0xE9C1, 0xE6BAB6 },
	{ 0xD2FC, 0xE6BABA },
	{ 0xDBB5, 0xE6BB82 },
	{ 0xF3E7, 0xE6BB84 },
	{ 0xD8FE, 0xE6BB85 },
	{ 0xFCD1, 0xE6BB89 },
	{ 0xEDB2, 0xE6BB8B },
	{ 0xF4AF, 0xE6BB8C },
	{ 0xFBA3, 0xE6BB8E },
	{ 0xFCC1, 0xE6BB91 },
	{ 0xEEAB, 0xE6BB93 },
	{ 0xD4A5, 0xE6BB94 },
	{ 0xF4F2, 0xE6BBAF },
	{ 0xEED9, 0xE6BBB4 },
	{ 0xFBCA, 0xE6BBB8 },
	{ 0xCDE3, 0xE6BBBE },
	{ 0xD8BB, 0xE6BBBF },
	{ 0xE5DB, 0xE6BC81 },
	{ 0xF8F7, 0xE6BC82 },
	{ 0xF6D4, 0xE6BC86 },
	{ 0xD7A9, 0xE6BC8F },
	{ 0xCBC9, 0xE6BC91 },
	{ 0xE6D1, 0xE6BC94 },
	{ 0xF0CC, 0xE6BC95 },
	{ 0xD8AE, 0xE6BCA0 },
	{ 0xF9D3, 0xE6BCA2 },
	{ 0xD5FE, 0xE6BCA3 },
	{ 0xD8BC, 0xE6BCAB },
	{ 0xF2B0, 0xE6BCAC },
	{ 0xE2AB, 0xE6BCB1 },
	{ 0xF3E8, 0xE6BCB2 },
	{ 0xEFC2, 0xE6BCB8 },
	{ 0xEDEC, 0xE6BCBF },
	{ 0xE7B8, 0xE6BD81 },
	{ 0xDAFE, 0xE6BD91 },
	{ 0xCCBE, 0xE6BD94 },
	{ 0xF2FC, 0xE6BD97 },
	{ 0xDAEB, 0xE6BD98 },
	{ 0xE2D8, 0xE6BD9A },
	{ 0xEDD6, 0xE6BD9B },
	{ 0xD6D1, 0xE6BD9E },
	{ 0xE0B3, 0xE6BD9F },
	{ 0xFCD2, 0xE6BDA2 },
	{ 0xEBC8, 0xE6BDA4 },
	{ 0xD3C1, 0xE6BDAD },
	{ 0xF0CD, 0xE6BDAE },
	{ 0xCFF7, 0xE6BDB0 },
	{ 0xEDD2, 0xE6BDBA },
	{ 0xD4D8, 0xE6BDBC },
	{ 0xDCC9, 0xE6BDBD },
	{ 0xD7F1, 0xE6BDBE },
	{ 0xDFBB, 0xE6BE81 },
	{ 0xF3A5, 0xE6BE84 },
	{ 0xF4CD, 0xE6BE88 },
	{ 0xF1BF, 0xE6BE8D },
	{ 0xF8B1, 0xE6BE8E },
	{ 0xE9FA, 0xE6BE90 },
	{ 0xFBCB, 0xE6BE94 },
	{ 0xCAD5, 0xE6BE97 },
	{ 0xF9D4, 0xE6BEA3 },
	{ 0xF7CA, 0xE6BEA4 },
	{ 0xD6C8, 0xE6BEA7 },
	{ 0xFCE8, 0xE6BEAE },
	{ 0xF3BD, 0xE6BEAF },
	{ 0xEEFE, 0xE6BEB1 },
	{ 0xE7FE, 0xE6BEB3 },
	{ 0xD3C2, 0xE6BEB9 },
	{ 0xD3B6, 0xE6BEBE },
	{ 0xCCAD, 0xE6BF80 },
	{ 0xF6FA, 0xE6BF81 },
	{ 0xD6B2, 0xE6BF82 },
	{ 0xD2D8, 0xE6BF83 },
	{ 0xE7D8, 0xE6BF8A },
	{ 0xE3A5, 0xE6BF95 },
	{ 0xE7B9, 0xE6BF9A },
	{ 0xF0AD, 0xE6BF9F },
	{ 0xFBCC, 0xE6BFA0 },
	{ 0xEBA1, 0xE6BFA1 },
	{ 0xD4A6, 0xE6BFA4 },
	{ 0xFBCD, 0xE6BFA9 },
	{ 0xD5BD, 0xE6BFAB },
	{ 0xF1DF, 0xE6BFAC },
	{ 0xF6FB, 0xE6BFAF },
	{ 0xDEB4, 0xE6BFB1 },
	{ 0xD5EB, 0xE6BFBE },
	{ 0xE5C8, 0xE78081 },
	{ 0xFBA4, 0xE78085 },
	{ 0xD4B9, 0xE78086 },
	{ 0xDEE1, 0xE78089 },
	{ 0xE4A3, 0xE7808B },
	{ 0xD7B7, 0xE7808F },
	{ 0xF8EE, 0xE78091 },
	{ 0xDEB5, 0xE78095 },
	{ 0xD6D2, 0xE78098 },
	{ 0xF9D5, 0xE7809A },
	{ 0xE7BA, 0xE7809B },
	{ 0xEBD5, 0xE7809C },
	{ 0xD5F7, 0xE7809D },
	{ 0xEFE7, 0xE7809E },
	{ 0xE1BE, 0xE7809F },
	{ 0xFAAE, 0xE780A3 },
	{ 0xD6E9, 0xE780A7 },
	{ 0xD6EE, 0xE780A8 },
	{ 0xE7BB, 0xE780AF },
	{ 0xECCB, 0xE780B7 },
	{ 0xD5B3, 0xE780BE },
	{ 0xCEB4, 0xE7818C },
	{ 0xFBA5, 0xE78190 },
	{ 0xE1EE, 0xE78191 },
	{ 0xF7A8, 0xE78198 },
	{ 0xFBCE, 0xE7819D },
	{ 0xD8BD, 0xE781A3 },
	{ 0xFBFD, 0xE781AB },
	{ 0xFCE9, 0xE781B0 },
	{ 0xCFB6, 0xE781B8 },
	{ 0xEDC7, 0xE781BC },
	{ 0xEEAC, 0xE781BD },
	{ 0xCCDD, 0xE78285 },
	{ 0xF6A7, 0xE7828A },
	{ 0xE6FA, 0xE7828E },
	{ 0xF5A4, 0xE78292 },
	{ 0xFDDC, 0xE78298 },
	{ 0xEDB3, 0xE78299 },
	{ 0xCEC9, 0xE7829A },
	{ 0xEFE8, 0xE782A1 },
	{ 0xE1BF, 0xE782A4 },
	{ 0xFADB, 0xE782AB },
	{ 0xCBE3, 0xE782AC },
	{ 0xF7A9, 0xE782AD },
	{ 0xFBA6, 0xE782AF },
	{ 0xDCB9, 0xE782B3 },
	{ 0xF1C0, 0xE782B7 },
	{ 0xEDC8, 0xE782B8 },
	{ 0xEFC3, 0xE782B9 },
	{ 0xD6AD, 0xE78388 },
	{ 0xFDCE, 0xE7838B },
	{ 0xE8A1, 0xE7838F },
	{ 0xFBF4, 0xE78398 },
	{ 0xD5A7, 0xE78399 },
	{ 0xF1F6, 0xE7839D },
	{ 0xE6D3, 0xE7839F },
	{ 0xCCDE, 0xE783B1 },
	{ 0xF8B2, 0xE783B9 },
	{ 0xDCEB, 0xE783BD },
	{ 0xFDB6, 0xE78484 },
	{ 0xE5EA, 0xE78489 },
	{ 0xF1E0, 0xE7848C },
	{ 0xDBCC, 0xE78499 },
	{ 0xDDCD, 0xE7849A },
	{ 0xD4C8, 0xE7849E },
	{ 0xD9ED, 0xE784A1 },
	{ 0xF5A5, 0xE784A6 },
	{ 0xE6FB, 0xE784B0 },
	{ 0xE6D4, 0xE784B6 },
	{ 0xFDC8, 0xE78587 },
	{ 0xD6A1, 0xE78589 },
	{ 0xFDBF, 0xE7858A },
	{ 0xFCD3, 0xE7858C },
	{ 0xEFA1, 0xE7858E },
	{ 0xE7BC, 0xE78590 },
	{ 0xD1EE, 0xE78596 },
	{ 0xE6D5, 0xE78599 },
	{ 0xE9F2, 0xE7859C },
	{ 0xDFB0, 0xE7859E },
	{ 0xD8E0, 0xE785A4 },
	{ 0xFCBA, 0xE785A5 },
	{ 0xFDAF, 0xE785A6 },
	{ 0xF0CE, 0xE785A7 },
	{ 0xDBE1, 0xE785A9 },
	{ 0xE5C9, 0xE785AC },
	{ 0xEDB4, 0xE785AE },
	{ 0xE0C3, 0xE785BD },
	{ 0xE3D8, 0xE78684 },
	{ 0xE9FB, 0xE78689 },
	{ 0xEAA8, 0xE7868A },
	{ 0xFDB7, 0xE7868F },
	{ 0xFBA7, 0xE78692 },
	{ 0xE9C2, 0xE78694 },
	{ 0xFDF7, 0xE78699 },
	{ 0xE2D9, 0xE7869F },
	{ 0xDCEC, 0xE786A2 },
	{ 0xE8A2, 0xE786AC },
	{ 0xE6F0, 0xE786B1 },
	{ 0xFDF8, 0xE786B9 },
	{ 0xFDF9, 0xE786BA },
	{ 0xF6BF, 0xE786BE },
	{ 0xE7A7, 0xE78781 },
	{ 0xE6D7, 0xE78783 },
	{ 0xD4F3, 0xE78788 },
	{ 0xD4C9, 0xE78789 },
	{ 0xD6FA, 0xE7878E },
	{ 0xD7F2, 0xE78790 },
	{ 0xE1C0, 0xE78792 },
	{ 0xDBE2, 0xE78794 },
	{ 0xE6D8, 0xE78795 },
	{ 0xE7BD, 0xE7879F },
	{ 0xF0CF, 0xE787A5 },
	{ 0xF3BE, 0xE787A6 },
	{ 0xE2AC, 0xE787A7 },
	{ 0xF5B7, 0xE787AD },
	{ 0xE0F0, 0xE787AE },
	{ 0xFDB8, 0xE787BB },
	{ 0xE3E8, 0xE787BC },
	{ 0xD4A7, 0xE787BE },
	{ 0xE8FC, 0xE787BF },
	{ 0xFAD2, 0xE78880 },
	{ 0xF8EF, 0xE78886 },
	{ 0xD6D3, 0xE78890 },
	{ 0xD5B4, 0xE7889B },
	{ 0xF0D0, 0xE788AA },
	{ 0xF7F0, 0xE788AC },
	{ 0xEEB3, 0xE788AD },
	{ 0xEABA, 0xE788B0 },
	{ 0xEAD3, 0xE788B2 },
	{ 0xEDC9, 0xE788B5 },
	{ 0xDDAB, 0xE788B6 },
	{ 0xE5AC, 0xE788BA },
	{ 0xFDA1, 0xE788BB },
	{ 0xDFD0, 0xE788BD },
	{ 0xECB3, 0xE788BE },
	{ 0xDFD1, 0xE78980 },
	{ 0xEDED, 0xE78986 },
	{ 0xF8B8, 0xE78987 },
	{ 0xF7FA, 0xE78988 },
	{ 0xF8AB, 0xE7898C },
	{ 0xF4E0, 0xE78992 },
	{ 0xD4BA, 0xE78998 },
	{ 0xE4B3, 0xE78999 },
	{ 0xE9DA, 0xE7899B },
	{ 0xDEB6, 0xE7899D },
	{ 0xD9BF, 0xE7899F },
	{ 0xD9C0, 0xE789A1 },
	{ 0xD6EF, 0xE789A2 },
	{ 0xD9CC, 0xE789A7 },
	{ 0xDAAA, 0xE789A9 },
	{ 0xDFE5, 0xE789B2 },
	{ 0xF7E5, 0xE789B9 },
	{ 0xCCB2, 0xE789BD },
	{ 0xDFF9, 0xE78A80 },
	{ 0xD7E0, 0xE78A81 },
	{ 0xD4BB, 0xE78AA2 },
	{ 0xFDFA, 0xE78AA7 },
	{ 0xCCB3, 0xE78AAC },
	{ 0xDBF3, 0xE78AAF },
	{ 0xDFD2, 0xE78B80 },
	{ 0xCECA, 0xE78B82 },
	{ 0xEEDA, 0xE78B84 },
	{ 0xE4E4, 0xE78B8E },
	{ 0xFBCF, 0xE78B90 },
	{ 0xCFB7, 0xE78B97 },
	{ 0xEEC3, 0xE78B99 },
	{ 0xCEEA, 0xE78BA1 },
	{ 0xE2AD, 0xE78BA9 },
	{ 0xD7E1, 0xE78BB8 },
	{ 0xFAF5, 0xE78BB9 },
	{ 0xD5C9, 0xE78BBC },
	{ 0xF8AC, 0xE78BBD },
	{ 0xE7D9, 0xE78C8A },
	{ 0xF3E9, 0xE78C96 },
	{ 0xD8ED, 0xE78C9B },
	{ 0xE3C4, 0xE78C9C },
	{ 0xF0F1, 0xE78C9D },
	{ 0xE8E5, 0xE78CA5 },
	{ 0xE0FA, 0xE78CA9 },
	{ 0xEEC4, 0xE78CAA },
	{ 0xD9DE, 0xE78CAB },
	{ 0xEBA2, 0xE78CB6 },
	{ 0xEBA3, 0xE78CB7 },
	{ 0xFCC2, 0xE78CBE },
	{ 0xEABB, 0xE78CBF },
	{ 0xE8AB, 0xE78D84 },
	{ 0xDEE2, 0xE78D85 },
	{ 0xEDEF, 0xE78D90 },
	{ 0xE8A3, 0xE78D92 },
	{ 0xCFF1, 0xE78D97 },
	{ 0xD4BC, 0xE78DA8 },
	{ 0xFCEA, 0xE78DAA },
	{ 0xE7BE, 0xE78DB0 },
	{ 0xFCF2, 0xE78DB2 },
	{ 0xD6B4, 0xE78DB5 },
	{ 0xE2AE, 0xE78DB8 },
	{ 0xD3B7, 0xE78DBA },
	{ 0xFACC, 0xE78DBB },
	{ 0xFADC, 0xE78E84 },
	{ 0xEDB5, 0xE78E86 },
	{ 0xE1E3, 0xE78E87 },
	{ 0xE8AC, 0xE78E89 },
	{ 0xE8DD, 0xE78E8B },
	{ 0xEFE9, 0xE78E8E },
	{ 0xF4BD, 0xE78E94 },
	{ 0xCFB8, 0xE78E96 },
	{ 0xE9DB, 0xE78E97 },
	{ 0xD1AC, 0xE78E98 },
	{ 0xDAC7, 0xE78E9F },
	{ 0xEBC9, 0xE78EA7 },
	{ 0xE8CC, 0xE78EA9 },
	{ 0xDEB7, 0xE78EAD },
	{ 0xD6BC, 0xE78EB2 },
	{ 0xD3E5, 0xE78EB3 },
	{ 0xFADD, 0xE78EB9 },
	{ 0xDAD6, 0xE78F80 },
	{ 0xCAB1, 0xE78F82 },
	{ 0xDAC8, 0xE78F89 },
	{ 0xDFA6, 0xE78F8A },
	{ 0xF9B3, 0xE78F8C },
	{ 0xF2D2, 0xE78F8D },
	{ 0xCAC4, 0xE78F8F },
	{ 0xCECB, 0xE78F96 },
	{ 0xCDF5, 0xE78F99 },
	{ 0xFDB0, 0xE78F9D },
	{ 0xD5A8, 0xE78F9E },
	{ 0xF1C1, 0xE78FA0 },
	{ 0xE2E9, 0xE78FA3 },
	{ 0xDCCA, 0xE78FA4 },
	{ 0xECB4, 0xE78FA5 },
	{ 0xFAC0, 0xE78FA6 },
	{ 0xFBA8, 0xE78FA9 },
	{ 0xD0A8, 0xE78FAA },
	{ 0xDAEC, 0xE78FAD },
	{ 0xD9EE, 0xE78FB7 },
	{ 0xE0FB, 0xE78FB9 },
	{ 0xEFEA, 0xE78FBD },
	{ 0xFADE, 0xE78FBE },
	{ 0xE0C4, 0xE79081 },
	{ 0xCFB9, 0xE79083 },
	{ 0xD5CA, 0xE79085 },
	{ 0xD7E2, 0xE79086 },
	{ 0xE2AF, 0xE79087 },
	{ 0xD7B8, 0xE79089 },
	{ 0xE8CD, 0xE79093 },
	{ 0xF6DA, 0xE7909B },
	{ 0xEFA2, 0xE790A0 },
	{ 0xE2DA, 0xE790A1 },
	{ 0xF6FC, 0xE790A2 },
	{ 0xFBD0, 0xE790A5 },
	{ 0xD1AD, 0xE790A6 },
	{ 0xCDE4, 0xE790A8 },
	{ 0xD1AE, 0xE790AA },
	{ 0xDCED, 0xE790AB },
	{ 0xE8CE, 0xE790AC },
	{ 0xF0F9, 0xE790AE },
	{ 0xCEB5, 0xE790AF },
	{ 0xE6FC, 0xE790B0 },
	{ 0xD7FB, 0xE790B3 },
	{ 0xD0D6, 0xE790B4 },
	{ 0xDDF5, 0xE790B5 },
	{ 0xF7F1, 0xE790B6 },
	{ 0xF6FD, 0xE790B8 },
	{ 0xDBF7, 0xE790BA },
	{ 0xFBEA, 0xE790BF },
	{ 0xE9DC, 0xE79180 },
	{ 0xD9C1, 0xE79181 },
	{ 0xF5F2, 0xE79183 },
	{ 0xE0C5, 0xE79184 },
	{ 0xEAD4, 0xE7918B },
	{ 0xF9C2, 0xE79195 },
	{ 0xEABC, 0xE79197 },
	{ 0xD2C5, 0xE79199 },
	{ 0xFBD1, 0xE7919A },
	{ 0xE7C0, 0xE7919B },
	{ 0xEBA5, 0xE7919C },
	{ 0xDFFA, 0xE7919E },
	{ 0xE3A2, 0xE7919F },
	{ 0xD7B9, 0xE791A0 },
	{ 0xE9C3, 0xE791A2 },
	{ 0xE8FD, 0xE791A4 },
	{ 0xE8AF, 0xE791A5 },
	{ 0xF2D3, 0xE791A8 },
	{ 0xFBA9, 0xE791A9 },
	{ 0xD8A5, 0xE791AA },
	{ 0xD5CB, 0xE791AF },
	{ 0xD0C8, 0xE791BE },
	{ 0xD1AF, 0xE79282 },
	{ 0xD7E3, 0xE79283 },
	{ 0xE0C6, 0xE79287 },
	{ 0xD6A2, 0xE79289 },
	{ 0xEDF0, 0xE7928B },
	{ 0xD7F3, 0xE79298 },
	{ 0xFCD4, 0xE7929C },
	{ 0xDAD7, 0xE7929E },
	{ 0xCCDF, 0xE7929F },
	{ 0xF2D4, 0xE792A1 },
	{ 0xD1B0, 0xE792A3 },
	{ 0xCCE0, 0xE792A5 },
	{ 0xDBFD, 0xE792A7 },
	{ 0xF3BF, 0xE792A8 },
	{ 0xF0D1, 0xE792AA },
	{ 0xFCBB, 0xE792B0 },
	{ 0xE2B0, 0xE792B2 },
	{ 0xE6A5, 0xE792B5 },
	{ 0xE2DB, 0xE792B9 },
	{ 0xDFDE, 0xE792BD },
	{ 0xE0C7, 0xE792BF },
	{ 0xF2EF, 0xE79386 },
	{ 0xCCE1, 0xE7938A },
	{ 0xD6EA, 0xE7938F },
	{ 0xE7C2, 0xE79394 },
	{ 0xCEB6, 0xE79398 },
	{ 0xF3C0, 0xE7939A },
	{ 0xCDFE, 0xE7939C },
	{ 0xFBD2, 0xE793A0 },
	{ 0xF8F8, 0xE793A2 },
	{ 0xF7FB, 0xE793A3 },
	{ 0xE8BF, 0xE793A6 },
	{ 0xE8B7, 0xE793AE },
	{ 0xEDB6, 0xE793B7 },
	{ 0xDCBA, 0xE79481 },
	{ 0xCCB4, 0xE79484 },
	{ 0xF1F7, 0xE79491 },
	{ 0xE8B8, 0xE79495 },
	{ 0xCAF6, 0xE79498 },
	{ 0xE4A4, 0xE7949A },
	{ 0xF4D6, 0xE7949B },
	{ 0xDFE6, 0xE7949F },
	{ 0xDFA7, 0xE794A3 },
	{ 0xDFE7, 0xE794A5 },
	{ 0xE1C1, 0xE794A6 },
	{ 0xE9C4, 0xE794A8 },
	{ 0xDCCB, 0xE794AB },
	{ 0xE9C5, 0xE794AC },
	{ 0xEFA3, 0xE794B0 },
	{ 0xEBA6, 0xE794B1 },
	{ 0xCBA3, 0xE794B2 },
	{ 0xE3E9, 0xE794B3 },
	{ 0xD1FB, 0xE794B7 },
	{ 0xEFA4, 0xE794B8 },
	{ 0xEFEB, 0xE794BA },
	{ 0xD0B4, 0xE79587 },
	{ 0xCDA3, 0xE7958C },
	{ 0xE8E6, 0xE7958F },
	{ 0xEFA5, 0xE79591 },
	{ 0xD3CC, 0xE79593 },
	{ 0xDAED, 0xE79594 },
	{ 0xD7BA, 0xE79599 },
	{ 0xF2D5, 0xE7959B },
	{ 0xF5E5, 0xE7959C },
	{ 0xD9EF, 0xE7959D },
	{ 0xF9B4, 0xE795A2 },
	{ 0xD5D4, 0xE795A5 },
	{ 0xFDCF, 0xE795A6 },
	{ 0xDBE3, 0xE795AA },
	{ 0xF1E1, 0xE795AF },
	{ 0xECB6, 0xE795B0 },
	{ 0xFBFE, 0xE795B5 },
	{ 0xD3D7, 0xE795B6 },
	{ 0xD1B1, 0xE795B8 },
	{ 0xCBB1, 0xE795BA },
	{ 0xD1B2, 0xE795BF },
	{ 0xCBB2, 0xE79686 },
	{ 0xF1C2, 0xE79687 },
	{ 0xF4E1, 0xE7968A },
	{ 0xF9B5, 0xE7968B },
	{ 0xE1C3, 0xE7968E },
	{ 0xE1C2, 0xE7968F },
	{ 0xEBF7, 0xE79691 },
	{ 0xDFA8, 0xE7969D },
	{ 0xCBCA, 0xE796A5 },
	{ 0xE6B9, 0xE796AB },
	{ 0xF8DE, 0xE796B1 },
	{ 0xF9AA, 0xE796B2 },
	{ 0xCAF7, 0xE796B3 },
	{ 0xEDB7, 0xE796B5 },
	{ 0xD3B8, 0xE796B8 },
	{ 0xF2D6, 0xE796B9 },
	{ 0xD4D9, 0xE796BC },
	{ 0xEEC5, 0xE796BD },
	{ 0xF2F0, 0xE796BE },
	{ 0xCAB2, 0xE79782 },
	{ 0xDCBB, 0xE79785 },
	{ 0xF1F8, 0xE79787 },
	{ 0xECB7, 0xE7978D },
	{ 0xE5CA, 0xE79792 },
	{ 0xF6C0, 0xE79794 },
	{ 0xFDDD, 0xE79795 },
	{ 0xD4E3, 0xE79798 },
	{ 0xCCE2, 0xE79799 },
	{ 0xF7D4, 0xE7979B },
	{ 0xD7E5, 0xE797A2 },
	{ 0xD3C3, 0xE797B0 },
	{ 0xD8A6, 0xE797B2 },
	{ 0xF6C1, 0xE797B4 },
	{ 0xDDF6, 0xE797BA },
	{ 0xCDC0, 0xE797BC },
	{ 0xE5DC, 0xE79880 },
	{ 0xE5CB, 0xE7988D },
	{ 0xE1C4, 0xE79899 },
	{ 0xE8B0, 0xE7989F },
	{ 0xF4B0, 0xE798A0 },
	{ 0xF3EA, 0xE798A1 },
	{ 0xDAEE, 0xE798A2 },
	{ 0xD7BB, 0xE798A4 },
	{ 0xE2B1, 0xE798A6 },
	{ 0xD7AA, 0xE798BB },
	{ 0xD6FB, 0xE79982 },
	{ 0xE4DF, 0xE7998C },
	{ 0xCAD6, 0xE7998E },
	{ 0xEBA8, 0xE79992 },
	{ 0xDBFE, 0xE79996 },
	{ 0xF6C2, 0xE799A1 },
	{ 0xEFBB, 0xE799A4 },
	{ 0xD4FD, 0xE799A9 },
	{ 0xE0C8, 0xE799AC },
	{ 0xE8B9, 0xE799B0 },
	{ 0xEFA6, 0xE799B2 },
	{ 0xCDA4, 0xE799B8 },
	{ 0xD4F4, 0xE799BB },
	{ 0xDBA1, 0xE799BC },
	{ 0xDBDC, 0xE799BD },
	{ 0xDBDD, 0xE799BE },
	{ 0xEEDC, 0xE79A84 },
	{ 0xCBCB, 0xE79A86 },
	{ 0xFCD5, 0xE79A87 },
	{ 0xCEEB, 0xE79A8E },
	{ 0xCDC1, 0xE79A90 },
	{ 0xFBD3, 0xE79A93 },
	{ 0xF9AB, 0xE79AAE },
	{ 0xF5D4, 0xE79ABA },
	{ 0xD9A9, 0xE79ABF },
	{ 0xE9DD, 0xE79B82 },
	{ 0xDBCD, 0xE79B83 },
	{ 0xDDCE, 0xE79B86 },
	{ 0xE7C3, 0xE79B88 },
	{ 0xECCC, 0xE79B8A },
	{ 0xF9EC, 0xE79B92 },
	{ 0xCBCC, 0xE79B96 },
	{ 0xE0FC, 0xE79B9B },
	{ 0xD4A8, 0xE79B9C },
	{ 0xEDD3, 0xE79B9E },
	{ 0xD8EF, 0xE79B9F },
	{ 0xF2D7, 0xE79BA1 },
	{ 0xCAF8, 0xE79BA3 },
	{ 0xDAEF, 0xE79BA4 },
	{ 0xD6D4, 0xE79BA7 },
	{ 0xD9CD, 0xE79BAE },
	{ 0xD8EE, 0xE79BB2 },
	{ 0xF2C1, 0xE79BB4 },
	{ 0xDFD3, 0xE79BB8 },
	{ 0xDAF0, 0xE79BBC },
	{ 0xE2EA, 0xE79BBE },
	{ 0xE0FD, 0xE79C81 },
	{ 0xD8F8, 0xE79C84 },
	{ 0xF7AF, 0xE79C88 },
	{ 0xDAB6, 0xE79C89 },
	{ 0xCAD7, 0xE79C8B },
	{ 0xF2D8, 0xE79C9E },
	{ 0xD8F9, 0xE79CA0 },
	{ 0xFADF, 0xE79CA9 },
	{ 0xCFEF, 0xE79CB7 },
	{ 0xD9C2, 0xE79CB8 },
	{ 0xF0D2, 0xE79CBA },
	{ 0xE4D1, 0xE79CBC },
	{ 0xF3B7, 0xE79D80 },
	{ 0xFAE0, 0xE79D8D },
	{ 0xEFEC, 0xE79D9B },
	{ 0xE2B2, 0xE79DA1 },
	{ 0xD4BD, 0xE79DA3 },
	{ 0xD9CE, 0xE79DA6 },
	{ 0xF4E2, 0xE79DAB },
	{ 0xD4A9, 0xE79DB9 },
	{ 0xCDC2, 0xE79DBE },
	{ 0xE7DA, 0xE79DBF },
	{ 0xF2D9, 0xE79E8B },
	{ 0xD9AA, 0xE79E91 },
	{ 0xD8BE, 0xE79E9E },
	{ 0xDCAD, 0xE79EA5 },
	{ 0xE2EB, 0xE79EAC },
	{ 0xD6FC, 0xE79EAD },
	{ 0xCAF9, 0xE79EB0 },
	{ 0xD4DA, 0xE79EB3 },
	{ 0xF4D7, 0xE79EBB },
	{ 0xCCA1, 0xE79EBC },
	{ 0xCFBA, 0xE79EBF },
	{ 0xF5B8, 0xE79F97 },
	{ 0xD9C3, 0xE79F9B },
	{ 0xD0E8, 0xE79F9C },
	{ 0xE3C5, 0xE79FA2 },
	{ 0xEBF8, 0xE79FA3 },
	{ 0xF2B1, 0xE79FA5 },
	{ 0xCFBB, 0xE79FA9 },
	{ 0xD3AD, 0xE79FAD },
	{ 0xE8E1, 0xE79FAE },
	{ 0xCEEC, 0xE79FAF },
	{ 0xE0B4, 0xE79FB3 },
	{ 0xDEE3, 0xE7A082 },
	{ 0xDDF7, 0xE7A092 },
	{ 0xF2B2, 0xE7A0A5 },
	{ 0xF3F6, 0xE7A0A6 },
	{ 0xF6DB, 0xE7A0A7 },
	{ 0xD7FE, 0xE7A0AC },
	{ 0xF8DF, 0xE7A0B2 },
	{ 0xF7F2, 0xE7A0B4 },
	{ 0xD0A9, 0xE7A185 },
	{ 0xE6DA, 0xE7A18F },
	{ 0xF5A6, 0xE7A19D },
	{ 0xD7BC, 0xE7A1AB },
	{ 0xCCE3, 0xE7A1AC },
	{ 0xE6DB, 0xE7A1AF },
	{ 0xDDDD, 0xE7A1BC },
	{ 0xD1B3, 0xE7A281 },
	{ 0xEFED, 0xE7A287 },
	{ 0xD6DE, 0xE7A28C },
	{ 0xE4F4, 0xE7A28D },
	{ 0xE1EF, 0xE7A28E },
	{ 0xDDF8, 0xE7A291 },
	{ 0xE8CF, 0xE7A297 },
	{ 0xCAE5, 0xE7A2A3 },
	{ 0xDCA1, 0xE7A2A7 },
	{ 0xE0B5, 0xE7A2A9 },
	{ 0xFCAC, 0xE7A2BA },
	{ 0xFCAD, 0xE7A2BB },
	{ 0xD8A7, 0xE7A2BC },
	{ 0xEDB8, 0xE7A381 },
	{ 0xDBB6, 0xE7A385 },
	{ 0xD6F0, 0xE7A38A },
	{ 0xF3AF, 0xE7A38B },
	{ 0xCDA5, 0xE7A38E },
	{ 0xDAF1, 0xE7A390 },
	{ 0xD8A8, 0xE7A3A8 },
	{ 0xCCE4, 0xE7A3AC },
	{ 0xD1B4, 0xE7A3AF },
	{ 0xCAD8, 0xE7A3B5 },
	{ 0xDAF2, 0xE7A3BB },
	{ 0xF5A7, 0xE7A481 },
	{ 0xF5A8, 0xE7A48E },
	{ 0xE6A6, 0xE7A496 },
	{ 0xD5EC, 0xE7A4AA },
	{ 0xD5F8, 0xE7A4AB },
	{ 0xDAF3, 0xE7A4AC },
	{ 0xE3C6, 0xE7A4BA },
	{ 0xDEE4, 0xE7A4BE },
	{ 0xDEE5, 0xE7A580 },
	{ 0xD1B5, 0xE7A581 },
	{ 0xD1B6, 0xE7A587 },
	{ 0xD1B7, 0xE7A588 },
	{ 0xF2B3, 0xE7A589 },
	{ 0xE9DE, 0xE7A590 },
	{ 0xF0D3, 0xE7A596 },
	{ 0xF2B4, 0xE7A597 },
	{ 0xF0D4, 0xE7A59A },
	{ 0xCBE4, 0xE7A59B },
	{ 0xFBD4, 0xE7A59C },
	{ 0xF5E6, 0xE7A59D },
	{ 0xE3EA, 0xE7A59E },
	{ 0xDEE6, 0xE7A5A0 },
	{ 0xDFD4, 0xE7A5A5 },
	{ 0xF8F9, 0xE7A5A8 },
	{ 0xF0AE, 0xE7A5AD },
	{ 0xD1B8, 0xE7A5BA },
	{ 0xD6DF, 0xE7A5BF },
	{ 0xD0D7, 0xE7A681 },
	{ 0xFCA1, 0xE7A68D },
	{ 0xEFEE, 0xE7A68E },
	{ 0xDCD8, 0xE7A68F },
	{ 0xE9DF, 0xE7A691 },
	{ 0xE5DD, 0xE7A6A6 },
	{ 0xFDFB, 0xE7A6A7 },
	{ 0xE0C9, 0xE7A6AA },
	{ 0xD6C9, 0xE7A6AE },
	{ 0xD4AA, 0xE7A6B1 },
	{ 0xE5CC, 0xE7A6B3 },
	{ 0xE9E0, 0xE7A6B9 },
	{ 0xD0D8, 0xE7A6BD },
	{ 0xFCA2, 0xE7A6BE },
	{ 0xD4BE, 0xE7A6BF },
	{ 0xE2B3, 0xE7A780 },
	{ 0xDEE7, 0xE7A781 },
	{ 0xDCBC, 0xE7A789 },
	{ 0xD2B6, 0xE7A78A },
	{ 0xF5D5, 0xE7A78B },
	{ 0xCEA1, 0xE7A791 },
	{ 0xF5A9, 0xE7A792 },
	{ 0xDDF9, 0xE7A795 },
	{ 0xDDFA, 0xE7A798 },
	{ 0xF0D5, 0xE7A79F },
	{ 0xF6DF, 0xE7A7A4 },
	{ 0xF2DA, 0xE7A7A6 },
	{ 0xE4EB, 0xE7A7A7 },
	{ 0xF2F1, 0xE7A7A9 },
	{ 0xECB9, 0xE7A7BB },
	{ 0xFDFC, 0xE7A880 },
	{ 0xE1AA, 0xE7A885 },
	{ 0xCAD9, 0xE7A888 },
	{ 0xEFEF, 0xE7A88B },
	{ 0xF5AA, 0xE7A88D },
	{ 0xECF9, 0xE7A894 },
	{ 0xF8AD, 0xE7A897 },
	{ 0xF2C2, 0xE7A899 },
	{ 0xF6C3, 0xE7A89A },
	{ 0xD7D2, 0xE7A89C },
	{ 0xF9A2, 0xE7A89F },
	{ 0xF0D6, 0xE7A8A0 },
	{ 0xF0FA, 0xE7A8AE },
	{ 0xF6E0, 0xE7A8B1 },
	{ 0xE9F3, 0xE7A8B6 },
	{ 0xF2C3, 0xE7A8B7 },
	{ 0xD4AB, 0xE7A8BB },
	{ 0xCAB3, 0xE7A8BC },
	{ 0xCDA6, 0xE7A8BD },
	{ 0xCDC3, 0xE7A8BF },
	{ 0xCDDA, 0xE7A980 },
	{ 0xD9CF, 0xE7A986 },
	{ 0xF6C4, 0xE7A989 },
	{ 0xEEDD, 0xE7A98D },
	{ 0xE7C4, 0xE7A98E },
	{ 0xE2B4, 0xE7A997 },
	{ 0xDFE2, 0xE7A9A1 },
	{ 0xE7DB, 0xE7A9A2 },
	{ 0xE8B1, 0xE7A9A9 },
	{ 0xFCAE, 0xE7A9AB },
	{ 0xE5CD, 0xE7A9B0 },
	{ 0xFAEB, 0xE7A9B4 },
	{ 0xCFBC, 0xE7A9B6 },
	{ 0xCFE2, 0xE7A9B9 },
	{ 0xCDF6, 0xE7A9BA },
	{ 0xEFF0, 0xE7A9BD },
	{ 0xF4BE, 0xE7A9BF },
	{ 0xD4CD, 0xE7AA81 },
	{ 0xF3B8, 0xE7AA84 },
	{ 0xE9A1, 0xE7AA88 },
	{ 0xF2F2, 0xE7AA92 },
	{ 0xF3EB, 0xE7AA93 },
	{ 0xF0D7, 0xE7AA95 },
	{ 0xCFD7, 0xE7AA98 },
	{ 0xCFDF, 0xE7AA9F },
	{ 0xE8C0, 0xE7AAA9 },
	{ 0xE8C1, 0xE7AAAA },
	{ 0xCFE3, 0xE7AAAE },
	{ 0xE9A2, 0xE7AAAF },
	{ 0xD0AA, 0xE7AABA },
	{ 0xF3C1, 0xE7AB84 },
	{ 0xD0AB, 0xE7AB85 },
	{ 0xD4E4, 0xE7AB87 },
	{ 0xEFBC, 0xE7AB8A },
	{ 0xD8A1, 0xE7AB8B },
	{ 0xD9DF, 0xE7AB97 },
	{ 0xF3D7, 0xE7AB99 },
	{ 0xDCBD, 0xE7AB9D },
	{ 0xCCE5, 0xE7AB9F },
	{ 0xEDF1, 0xE7ABA0 },
	{ 0xF1E2, 0xE7ABA3 },
	{ 0xD4DB, 0xE7ABA5 },
	{ 0xE2B5, 0xE7ABAA },
	{ 0xCAE6, 0xE7ABAD },
	{ 0xD3AE, 0xE7ABAF },
	{ 0xCCE6, 0xE7ABB6 },
	{ 0xF1D3, 0xE7ABB9 },
	{ 0xF5E7, 0xE7ABBA },
	{ 0xCADA, 0xE7ABBF },
	{ 0xFBEE, 0xE7AC8F },
	{ 0xE1C5, 0xE7AC91 },
	{ 0xDFE9, 0xE7AC99 },
	{ 0xEEDE, 0xE7AC9B },
	{ 0xF7C2, 0xE7AC9E },
	{ 0xD8A2, 0xE7ACA0 },
	{ 0xDDAC, 0xE7ACA6 },
	{ 0xF0AF, 0xE7ACAC },
	{ 0xD6BD, 0xE7ACAD },
	{ 0xE1AB, 0xE7ACB9 },
	{ 0xF9B6, 0xE7AD86 },
	{ 0xD4F5, 0xE7AD89 },
	{ 0xD0C9, 0xE7AD8B },
	{ 0xEFA7, 0xE7AD8C },
	{ 0xE2EC, 0xE7AD8D },
	{ 0xDBEA, 0xE7AD8F },
	{ 0xCECC, 0xE7AD90 },
	{ 0xF5E8, 0xE7AD91 },
	{ 0xF7D5, 0xE7AD92 },
	{ 0xD3CD, 0xE7AD94 },
	{ 0xF3FE, 0xE7AD96 },
	{ 0xD0B5, 0xE7ADA0 },
	{ 0xE0FE, 0xE7ADAC },
	{ 0xDFFB, 0xE7ADAE },
	{ 0xE6DD, 0xE7ADB5 },
	{ 0xE8A4, 0xE7ADBD },
	{ 0xCBCD, 0xE7AE87 },
	{ 0xEFA8, 0xE7AE8B },
	{ 0xEEB4, 0xE7AE8F },
	{ 0xDAD8, 0xE7AE94 },
	{ 0xD1B9, 0xE7AE95 },
	{ 0xDFA9, 0xE7AE97 },
	{ 0xF3B0, 0xE7AE9A },
	{ 0xCCC4, 0xE7AE9D },
	{ 0xCEB7, 0xE7AEA1 },
	{ 0xEFA9, 0xE7AEAD },
	{ 0xDFD5, 0xE7AEB1 },
	{ 0xEDD7, 0xE7AEB4 },
	{ 0xEEC6, 0xE7AEB8 },
	{ 0xEFBD, 0xE7AF80 },
	{ 0xFCD6, 0xE7AF81 },
	{ 0xDBF4, 0xE7AF84 },
	{ 0xEFAA, 0xE7AF86 },
	{ 0xF8B9, 0xE7AF87 },
	{ 0xF5E9, 0xE7AF89 },
	{ 0xE3D9, 0xE7AF92 },
	{ 0xE1C6, 0xE7AFA0 },
	{ 0xD4BF, 0xE7AFA4 },
	{ 0xDEE8, 0xE7AFA9 },
	{ 0xF0EA, 0xE7B087 },
	{ 0xF3C2, 0xE7B092 },
	{ 0xD3AF, 0xE7B09E },
	{ 0xCADB, 0xE7B0A1 },
	{ 0xFCD7, 0xE7B0A7 },
	{ 0xEDD8, 0xE7B0AA },
	{ 0xE1C7, 0xE7B0AB },
	{ 0xF4D8, 0xE7B0BD },
	{ 0xD6B3, 0xE7B0BE },
	{ 0xDDAD, 0xE7B0BF },
	{ 0xD5BE, 0xE7B183 },
	{ 0xF1C3, 0xE7B18C },
	{ 0xEEDF, 0xE7B18D },
	{ 0xD6EB, 0xE7B1A0 },
	{ 0xF4D9, 0xE7B1A4 },
	{ 0xD7E6, 0xE7B1AC },
	{ 0xDAB7, 0xE7B1B3 },
	{ 0xDDFB, 0xE7B283 },
	{ 0xDDCF, 0xE7B289 },
	{ 0xD8A3, 0xE7B292 },
	{ 0xDAD9, 0xE7B295 },
	{ 0xF0D8, 0xE7B297 },
	{ 0xEFC4, 0xE7B298 },
	{ 0xE1D8, 0xE7B29F },
	{ 0xF1D4, 0xE7B2A5 },
	{ 0xEDF2, 0xE7B2A7 },
	{ 0xD5DB, 0xE7B2AE },
	{ 0xD5DC, 0xE7B2B1 },
	{ 0xF3C4, 0xE7B2B2 },
	{ 0xCBD7, 0xE7B2B3 },
	{ 0xE2B6, 0xE7B2B9 },
	{ 0xEFF1, 0xE7B2BE },
	{ 0xFBD5, 0xE7B38A },
	{ 0xD3D8, 0xE7B396 },
	{ 0xDDD0, 0xE7B39E },
	{ 0xF0D9, 0xE7B39F },
	{ 0xCBB3, 0xE7B3A0 },
	{ 0xD5DD, 0xE7B3A7 },
	{ 0xCDA7, 0xE7B3BB },
	{ 0xD0AC, 0xE7B3BE },
	{ 0xD1BA, 0xE7B480 },
	{ 0xF1C4, 0xE7B482 },
	{ 0xE5B3, 0xE7B484 },
	{ 0xFBF5, 0xE7B485 },
	{ 0xE9E1, 0xE7B486 },
	{ 0xFDE0, 0xE7B487 },
	{ 0xFCBC, 0xE7B488 },
	{ 0xDAA2, 0xE7B48A },
	{ 0xDAA3, 0xE7B48B },
	{ 0xD2A1, 0xE7B48D },
	{ 0xD2EF, 0xE7B490 },
	{ 0xE2ED, 0xE7B494 },
	{ 0xDEE9, 0xE7B497 },
	{ 0xCEDC, 0xE7B498 },
	{ 0xF2B5, 0xE7B499 },
	{ 0xD0E4, 0xE7B49A },
	{ 0xDDD1, 0xE7B49B },
	{ 0xE1C8, 0xE7B4A0 },
	{ 0xDBB7, 0xE7B4A1 },
	{ 0xDFE3, 0xE7B4A2 },
	{ 0xEDB9, 0xE7B4AB },
	{ 0xF1C5, 0xE7B4AC },
	{ 0xF3CF, 0xE7B4AE },
	{ 0xD7AB, 0xE7B4AF },
	{ 0xE1AC, 0xE7B4B0 },
	{ 0xE3EB, 0xE7B4B3 },
	{ 0xEEC7, 0xE7B4B5 },
	{ 0xE1C9, 0xE7B4B9 },
	{ 0xCAFA, 0xE7B4BA },
	{ 0xF0FB, 0xE7B582 },
	{ 0xFAE1, 0xE7B583 },
	{ 0xF0DA, 0xE7B584 },
	{ 0xCCE7, 0xE7B585 },
	{ 0xDAF4, 0xE7B586 },
	{ 0xCCBF, 0xE7B590 },
	{ 0xCEED, 0xE7B59E },
	{ 0xD5A9, 0xE7B5A1 },
	{ 0xFAE2, 0xE7B5A2 },
	{ 0xD0E5, 0xE7B5A6 },
	{ 0xEBD6, 0xE7B5A8 },
	{ 0xECDF, 0xE7B5AA },
	{ 0xDFFC, 0xE7B5AE },
	{ 0xF7D6, 0xE7B5B1 },
	{ 0xDEEA, 0xE7B5B2 },
	{ 0xCBB4, 0xE7B5B3 },
	{ 0xEFBE, 0xE7B5B6 },
	{ 0xCCB5, 0xE7B5B9 },
	{ 0xCFBD, 0xE7B5BF },
	{ 0xEFF2, 0xE7B68E },
	{ 0xE2B7, 0xE7B68F },
	{ 0xCCE8, 0xE7B693 },
	{ 0xF0FC, 0xE7B69C },
	{ 0xD6E0, 0xE7B6A0 },
	{ 0xF1C6, 0xE7B6A2 },
	{ 0xE2B8, 0xE7B6AC },
	{ 0xEBAB, 0xE7B6AD },
	{ 0xCBB5, 0xE7B6B1 },
	{ 0xD8D1, 0xE7B6B2 },
	{ 0xF4CE, 0xE7B6B4 },
	{ 0xF3F7, 0xE7B6B5 },
	{ 0xD7C6, 0xE7B6B8 },
	{ 0xD1BB, 0xE7B6BA },
	{ 0xF7AA, 0xE7B6BB },
	{ 0xEDCA, 0xE7B6BD },
	{ 0xD7D3, 0xE7B6BE },
	{ 0xD8FA, 0xE7B6BF },
	{ 0xF6C5, 0xE7B787 },
	{ 0xD1CC, 0xE7B78A },
	{ 0xDDFC, 0xE7B78B },
	{ 0xDFFD, 0xE7B796 },
	{ 0xF9E5, 0xE7B798 },
	{ 0xE0CA, 0xE7B79A },
	{ 0xF2FD, 0xE7B79D },
	{ 0xD3B0, 0xE7B79E },
	{ 0xF4F3, 0xE7B7A0 },
	{ 0xDAC9, 0xE7B7A1 },
	{ 0xE6DE, 0xE7B7A3 },
	{ 0xF8BA, 0xE7B7A8 },
	{ 0xE8D0, 0xE7B7A9 },
	{ 0xD8FB, 0xE7B7AC },
	{ 0xEAD5, 0xE7B7AF },
	{ 0xD6A3, 0xE7B7B4 },
	{ 0xF6C6, 0xE7B7BB },
	{ 0xF2DB, 0xE7B889 },
	{ 0xE4FC, 0xE7B88A },
	{ 0xE8B2, 0xE7B895 },
	{ 0xDADA, 0xE7B89B },
	{ 0xF2DC, 0xE7B89D },
	{ 0xFBD6, 0xE7B89E },
	{ 0xE9B2, 0xE7B89F },
	{ 0xEEAD, 0xE7B8A1 },
	{ 0xFAE3, 0xE7B8A3 },
	{ 0xDCEE, 0xE7B8AB },
	{ 0xF5EA, 0xE7B8AE },
	{ 0xE6E0, 0xE7B8AF },
	{ 0xF0FD, 0xE7B8B1 },
	{ 0xD7AC, 0xE7B8B7 },
	{ 0xF5C5, 0xE7B8BD },
	{ 0xEEE0, 0xE7B8BE },
	{ 0xDBE5, 0xE7B981 },
	{ 0xDDDE, 0xE7B983 },
	{ 0xD9F0, 0xE7B986 },
	{ 0xE9A3, 0xE7B987 },
	{ 0xF1F9, 0xE7B992 },
	{ 0xF2C4, 0xE7B994 },
	{ 0xE0CB, 0xE7B995 },
	{ 0xE9A4, 0xE7B99E },
	{ 0xE2B9, 0xE7B9A1 },
	{ 0xE3B1, 0xE7B9A9 },
	{ 0xFCEB, 0xE7B9AA },
	{ 0xCDA8, 0xE7B9AB },
	{ 0xCCB6, 0xE7B9AD },
	{ 0xF0DB, 0xE7B9B0 },
	{ 0xE6BA, 0xE7B9B9 },
	{ 0xCDA9, 0xE7B9BC },
	{ 0xF3C3, 0xE7BA82 },
	{ 0xE1D9, 0xE7BA8C },
	{ 0xEFAB, 0xE7BA8F },
	{ 0xE7C5, 0xE7BA93 },
	{ 0xE0E9, 0xE7BA96 },
	{ 0xF3C5, 0xE7BA98 },
	{ 0xD4C0, 0xE7BA9B },
	{ 0xD5BF, 0xE7BA9C },
	{ 0xDDAE, 0xE7BCB6 },
	{ 0xF9FC, 0xE7BCB8 },
	{ 0xCCC0, 0xE7BCBA },
	{ 0xE5A2, 0xE7BD8C },
	{ 0xCEB8, 0xE7BD90 },
	{ 0xD8D2, 0xE7BD94 },
	{ 0xF9D6, 0xE7BD95 },
	{ 0xF1AA, 0xE7BDAA },
	{ 0xCED1, 0xE7BDAB },
	{ 0xF6C7, 0xE7BDAE },
	{ 0xDBEB, 0xE7BDB0 },
	{ 0xDFFE, 0xE7BDB2 },
	{ 0xD8E1, 0xE7BDB5 },
	{ 0xF7F3, 0xE7BDB7 },
	{ 0xD7E7, 0xE7BDB9 },
	{ 0xD4FE, 0xE7BE85 },
	{ 0xD1BC, 0xE7BE88 },
	{ 0xE5CF, 0xE7BE8A },
	{ 0xCBB6, 0xE7BE8C },
	{ 0xDAB8, 0xE7BE8E },
	{ 0xCDC4, 0xE7BE94 },
	{ 0xD6BE, 0xE7BE9A },
	{ 0xE2BA, 0xE7BE9E },
	{ 0xCFD8, 0xE7BEA4 },
	{ 0xE0CC, 0xE7BEA8 },
	{ 0xEBF9, 0xE7BEA9 },
	{ 0xFDFD, 0xE7BEB2 },
	{ 0xD7E8, 0xE7BEB8 },
	{ 0xCBD8, 0xE7BEB9 },
	{ 0xE9E2, 0xE7BEBD },
	{ 0xE8BA, 0xE7BF81 },
	{ 0xE3C7, 0xE7BF85 },
	{ 0xECCD, 0xE7BF8A },
	{ 0xECCE, 0xE7BF8C },
	{ 0xD6BF, 0xE7BF8E },
	{ 0xE3A7, 0xE7BF92 },
	{ 0xDFD6, 0xE7BF94 },
	{ 0xFDE8, 0xE7BF95 },
	{ 0xEEE1, 0xE7BF9F },
	{ 0xF6A8, 0xE7BFA0 },
	{ 0xDDFD, 0xE7BFA1 },
	{ 0xF8BB, 0xE7BFA9 },
	{ 0xE8D1, 0xE7BFAB },
	{ 0xF9D7, 0xE7BFB0 },
	{ 0xCEEE, 0xE7BFB9 },
	{ 0xECCF, 0xE7BFBC },
	{ 0xE9A5, 0xE88080 },
	{ 0xD6D5, 0xE88081 },
	{ 0xCDC5, 0xE88083 },
	{ 0xEDBA, 0xE88085 },
	{ 0xD1BD, 0xE88086 },
	{ 0xCFBE, 0xE88089 },
	{ 0xECBB, 0xE8808C },
	{ 0xD2B1, 0xE88090 },
	{ 0xCCE9, 0xE88095 },
	{ 0xD9C4, 0xE88097 },
	{ 0xE9FC, 0xE88098 },
	{ 0xD1BE, 0xE880AD },
	{ 0xECBC, 0xE880B3 },
	{ 0xE5AD, 0xE880B6 },
	{ 0xF7B0, 0xE880BD },
	{ 0xCCEA, 0xE880BF },
	{ 0xD3C4, 0xE88183 },
	{ 0xD6C0, 0xE88186 },
	{ 0xD6FD, 0xE8818A },
	{ 0xE1A1, 0xE88196 },
	{ 0xDEBD, 0xE88198 },
	{ 0xF6A9, 0xE8819A },
	{ 0xDAA4, 0xE8819E },
	{ 0xD6A4, 0xE881AF },
	{ 0xF5C6, 0xE881B0 },
	{ 0xE1A2, 0xE881B2 },
	{ 0xE9C6, 0xE881B3 },
	{ 0xF2C5, 0xE881B7 },
	{ 0xF4E9, 0xE881BD },
	{ 0xD6EC, 0xE881BE },
	{ 0xEBD3, 0xE881BF },
	{ 0xECBD, 0xE88284 },
	{ 0xE2DC, 0xE88285 },
	{ 0xDEEB, 0xE88286 },
	{ 0xF0DC, 0xE88287 },
	{ 0xEBBF, 0xE88289 },
	{ 0xD7CE, 0xE8828B },
	{ 0xD1BF, 0xE8828C },
	{ 0xF5AB, 0xE88296 },
	{ 0xF9FD, 0xE8829B },
	{ 0xCADC, 0xE8829D },
	{ 0xCDC6, 0xE882A1 },
	{ 0xF2B6, 0xE882A2 },
	{ 0xDDFE, 0xE882A5 },
	{ 0xCCB7, 0xE882A9 },
	{ 0xDBB8, 0xE882AA },
	{ 0xD0E9, 0xE882AF },
	{ 0xCEDD, 0xE882B1 },
	{ 0xEBC0, 0xE882B2 },
	{ 0xFDA2, 0xE882B4 },
	{ 0xF8CB, 0xE882BA },
	{ 0xEAD6, 0xE88383 },
	{ 0xF1B0, 0xE88384 },
	{ 0xDBCE, 0xE8838C },
	{ 0xF7C3, 0xE8838E },
	{ 0xDBCF, 0xE8839A },
	{ 0xCBA4, 0xE8839B },
	{ 0xF8E0, 0xE8839E },
	{ 0xFBD7, 0xE883A1 },
	{ 0xEBCA, 0xE883A4 },
	{ 0xE0A1, 0xE883A5 },
	{ 0xCECD, 0xE883B1 },
	{ 0xD4DC, 0xE883B4 },
	{ 0xFDD8, 0xE883B8 },
	{ 0xD2F6, 0xE883BD },
	{ 0xF2B7, 0xE88482 },
	{ 0xFAF6, 0xE88485 },
	{ 0xF6AA, 0xE88486 },
	{ 0xFAF7, 0xE88487 },
	{ 0xD8E6, 0xE88488 },
	{ 0xF4B1, 0xE8848A },
	{ 0xE8D2, 0xE88498 },
	{ 0xCAC5, 0xE8849A },
	{ 0xCCEB, 0xE8849B },
	{ 0xE2EE, 0xE884A3 },
	{ 0xE2BB, 0xE884A9 },
	{ 0xF7AD, 0xE884AB },
	{ 0xF8E1, 0xE884AF },
	{ 0xF3EC, 0xE884B9 },
	{ 0xDEA1, 0xE884BE },
	{ 0xE4FD, 0xE8858B },
	{ 0xE3EC, 0xE8858E },
	{ 0xDDAF, 0xE88590 },
	{ 0xDDB0, 0xE88591 },
	{ 0xCBB7, 0xE88594 },
	{ 0xE8D3, 0xE88595 },
	{ 0xE1A3, 0xE885A5 },
	{ 0xD2E0, 0xE885A6 },
	{ 0xF0FE, 0xE885AB },
	{ 0xE9A6, 0xE885B0 },
	{ 0xCBF2, 0xE885B1 },
	{ 0xEDF3, 0xE885B8 },
	{ 0xDCD9, 0xE885B9 },
	{ 0xE0CD, 0xE885BA },
	{ 0xF7DA, 0xE885BF },
	{ 0xDBB9, 0xE88680 },
	{ 0xCCAE, 0xE88688 },
	{ 0xDADB, 0xE8868A },
	{ 0xCDC7, 0xE8868F },
	{ 0xDDB1, 0xE8869A },
	{ 0xD8AF, 0xE8869C },
	{ 0xE3A3, 0xE8869D },
	{ 0xCEEF, 0xE886A0 },
	{ 0xF2F3, 0xE886A3 },
	{ 0xF8B3, 0xE886A8 },
	{ 0xE0CE, 0xE886B3 },
	{ 0xF5FD, 0xE886B5 },
	{ 0xEBEC, 0xE886BA },
	{ 0xD3C5, 0xE886BD },
	{ 0xFCEC, 0xE886BE },
	{ 0xD2DB, 0xE886BF },
	{ 0xD4EB, 0xE88780 },
	{ 0xDEA2, 0xE88782 },
	{ 0xE5E6, 0xE88786 },
	{ 0xF0B0, 0xE8878D },
	{ 0xD5C4, 0xE88798 },
	{ 0xEDF4, 0xE8879F },
	{ 0xE3ED, 0xE887A3 },
	{ 0xE8C2, 0xE887A5 },
	{ 0xEDF5, 0xE887A7 },
	{ 0xD7FC, 0xE887A8 },
	{ 0xEDBB, 0xE887AA },
	{ 0xF6AB, 0xE887AD },
	{ 0xF2B8, 0xE887B3 },
	{ 0xF6C8, 0xE887B4 },
	{ 0xD3E6, 0xE887BA },
	{ 0xF2DD, 0xE887BB },
	{ 0xCFBF, 0xE887BC },
	{ 0xEBAC, 0xE887BE },
	{ 0xCFC0, 0xE88885 },
	{ 0xE6A8, 0xE88887 },
	{ 0xFDE9, 0xE88888 },
	{ 0xCFC1, 0xE8888A },
	{ 0xE0DF, 0xE8888C },
	{ 0xDEEC, 0xE8888D },
	{ 0xE0A2, 0xE88892 },
	{ 0xF4BF, 0xE8889B },
	{ 0xE2EF, 0xE8889C },
	{ 0xD9F1, 0xE8889E },
	{ 0xF1C7, 0xE8889F },
	{ 0xCBB8, 0xE888A1 },
	{ 0xF9FE, 0xE888AA },
	{ 0xDBBA, 0xE888AB },
	{ 0xDAF5, 0xE888AC },
	{ 0xF6EC, 0xE888B5 },
	{ 0xDADC, 0xE888B6 },
	{ 0xFAE4, 0xE888B7 },
	{ 0xE0CF, 0xE888B9 },
	{ 0xDDB2, 0xE88980 },
	{ 0xE6A9, 0xE88985 },
	{ 0xEFF3, 0xE88987 },
	{ 0xF3ED, 0xE88999 },
	{ 0xEBFA, 0xE889A4 },
	{ 0xF9E6, 0xE889A6 },
	{ 0xCADD, 0xE889AE },
	{ 0xD5DE, 0xE889AF },
	{ 0xCADE, 0xE889B1 },
	{ 0xDFE4, 0xE889B2 },
	{ 0xE6FD, 0xE889B6 },
	{ 0xF5AC, 0xE889B8 },
	{ 0xE4F5, 0xE889BE },
	{ 0xE9E3, 0xE88A8B },
	{ 0xEDCB, 0xE88A8D },
	{ 0xCFE4, 0xE88A8E },
	{ 0xD8D3, 0xE88A92 },
	{ 0xDDB3, 0xE88A99 },
	{ 0xD4EC, 0xE88A9A },
	{ 0xF2B9, 0xE88A9D },
	{ 0xDFB7, 0xE88A9F },
	{ 0xCBCE, 0xE88AA5 },
	{ 0xFBD8, 0xE88AA6 },
	{ 0xD0D9, 0xE88AA9 },
	{ 0xDDD2, 0xE88AAC },
	{ 0xF7F4, 0xE88AAD },
	{ 0xE7DC, 0xE88AAE },
	{ 0xE4A5, 0xE88AAF },
	{ 0xFCA3, 0xE88AB1 },
	{ 0xDBBB, 0xE88AB3 },
	{ 0xF2BA, 0xE88AB7 },
	{ 0xE9FD, 0xE88AB8 },
	{ 0xD0CA, 0xE88AB9 },
	{ 0xF5D6, 0xE88ABB },
	{ 0xD9C5, 0xE88ABC },
	{ 0xE4B4, 0xE88ABD },
	{ 0xEDA7, 0xE88ABF },
	{ 0xEABD, 0xE88B91 },
	{ 0xE6FE, 0xE88B92 },
	{ 0xF7C4, 0xE88B94 },
	{ 0xF5AD, 0xE88B95 },
	{ 0xD9E0, 0xE88B97 },
	{ 0xCAB4, 0xE88B9B },
	{ 0xF8E2, 0xE88B9E },
	{ 0xCFC2, 0xE88B9F },
	{ 0xECBE, 0xE88BA1 },
	{ 0xE5B4, 0xE88BA5 },
	{ 0xCDC8, 0xE88BA6 },
	{ 0xEEC8, 0xE88BA7 },
	{ 0xE7C8, 0xE88BB1 },
	{ 0xCDC9, 0xE88BBD },
	{ 0xF9B7, 0xE88BBE },
	{ 0xF1E8, 0xE88C81 },
	{ 0xD9F2, 0xE88C82 },
	{ 0xDBF5, 0xE88C83 },
	{ 0xCAB5, 0xE88C84 },
	{ 0xD9C6, 0xE88C85 },
	{ 0xD8C9, 0xE88C89 },
	{ 0xD9AB, 0xE88C97 },
	{ 0xEDBC, 0xE88CA8 },
	{ 0xD8D4, 0xE88CAB },
	{ 0xDCDA, 0xE88CAF },
	{ 0xE2BC, 0xE88CB1 },
	{ 0xFCED, 0xE88CB4 },
	{ 0xECE0, 0xE88CB5 },
	{ 0xD2FE, 0xE88CB6 },
	{ 0xE9C7, 0xE88CB8 },
	{ 0xE6AA, 0xE88CB9 },
	{ 0xE2F0, 0xE88D80 },
	{ 0xFABB, 0xE88D87 },
	{ 0xF5AE, 0xE88D89 },
	{ 0xFBAA, 0xE88D8A },
	{ 0xECFB, 0xE88D8F },
	{ 0xECBF, 0xE88D91 },
	{ 0xFCD8, 0xE88D92 },
	{ 0xD4E5, 0xE88DB3 },
	{ 0xF9C3, 0xE88DB7 },
	{ 0xEEE2, 0xE88DBB },
	{ 0xD7E9, 0xE88E89 },
	{ 0xEDF6, 0xE88E8A },
	{ 0xDEED, 0xE88E8E },
	{ 0xCCEC, 0xE88E96 },
	{ 0xE3EE, 0xE88E98 },
	{ 0xE8D4, 0xE88E9E },
	{ 0xFAF8, 0xE88EA2 },
	{ 0xDDB4, 0xE88EA9 },
	{ 0xE4B5, 0xE88EAA },
	{ 0xD8B0, 0xE88EAB },
	{ 0xD8D5, 0xE88EBD },
	{ 0xF4EA, 0xE88F81 },
	{ 0xCEB9, 0xE88F85 },
	{ 0xD6E1, 0xE88F89 },
	{ 0xCFD2, 0xE88F8A },
	{ 0xD0B6, 0xE88F8C },
	{ 0xCEA2, 0xE88F93 },
	{ 0xF3EE, 0xE88F96 },
	{ 0xF3F8, 0xE88F9C },
	{ 0xDCCC, 0xE88FA9 },
	{ 0xD0CB, 0xE88FAB },
	{ 0xFCA4, 0xE88FAF },
	{ 0xCDCA, 0xE88FB0 },
	{ 0xD7D4, 0xE88FB1 },
	{ 0xDEA3, 0xE88FB2 },
	{ 0xE4E0, 0xE88FB4 },
	{ 0xEEC9, 0xE88FB9 },
	{ 0xE2DD, 0xE88FBD },
	{ 0xF5FE, 0xE89083 },
	{ 0xD4AC, 0xE89084 },
	{ 0xD5D1, 0xE8908A },
	{ 0xD8F0, 0xE8908C },
	{ 0xF8C3, 0xE8908D },
	{ 0xEAD7, 0xE8908E },
	{ 0xF5D7, 0xE890A9 },
	{ 0xD8BF, 0xE890AC },
	{ 0xFDC0, 0xE890B1 },
	{ 0xEBAD, 0xE890B8 },
	{ 0xD5AA, 0xE890BD },
	{ 0xE7A8, 0xE89189 },
	{ 0xEECA, 0xE89197 },
	{ 0xCAE7, 0xE8919B },
	{ 0xF8E3, 0xE891A1 },
	{ 0xD4DD, 0xE891A3 },
	{ 0xEAD8, 0xE891A6 },
	{ 0xFBD9, 0xE891AB },
	{ 0xEDF7, 0xE891AC },
	{ 0xE5B5, 0xE891AF },
	{ 0xD0AD, 0xE891B5 },
	{ 0xF1F1, 0xE891BA },
	{ 0xE2BD, 0xE89290 },
	{ 0xE3C8, 0xE89294 },
	{ 0xD9D5, 0xE89299 },
	{ 0xDFAA, 0xE8929C },
	{ 0xDBBC, 0xE892A1 },
	{ 0xF8E4, 0xE892B2 },
	{ 0xF1FA, 0xE892B8 },
	{ 0xE5B6, 0xE892BB },
	{ 0xF3EF, 0xE892BC },
	{ 0xFBDA, 0xE892BF },
	{ 0xE1E0, 0xE89380 },
	{ 0xD9AC, 0xE89382 },
	{ 0xF5EB, 0xE89384 },
	{ 0xE0B6, 0xE89386 },
	{ 0xE9C8, 0xE89389 },
	{ 0xCBCF, 0xE8938B },
	{ 0xE3C9, 0xE8938D },
	{ 0xDEEE, 0xE89391 },
	{ 0xE2BE, 0xE8939A },
	{ 0xDCEF, 0xE893AC },
	{ 0xD6A5, 0xE893AE },
	{ 0xE2F1, 0xE893B4 },
	{ 0xD6FE, 0xE893BC },
	{ 0xD9A1, 0xE89491 },
	{ 0xD8C0, 0xE89493 },
	{ 0xDCDB, 0xE89494 },
	{ 0xEDBD, 0xE89497 },
	{ 0xDFB8, 0xE89498 },
	{ 0xEAA5, 0xE8949A },
	{ 0xD7AD, 0xE8949E },
	{ 0xF3F9, 0xE894A1 },
	{ 0xEDF8, 0xE894A3 },
	{ 0xF5C7, 0xE894A5 },
	{ 0xE1CA, 0xE894AC },
	{ 0xEBE3, 0xE894AD },
	{ 0xF2DE, 0xE894AF },
	{ 0xF8CC, 0xE894BD },
	{ 0xEAD9, 0xE894BF },
	{ 0xD3C6, 0xE89581 },
	{ 0xDBE6, 0xE89583 },
	{ 0xF5AF, 0xE89589 },
	{ 0xCEF0, 0xE8958E },
	{ 0xE9FE, 0xE89593 },
	{ 0xFBB6, 0xE89599 },
	{ 0xE2F2, 0xE895A3 },
	{ 0xCFF2, 0xE895A8 },
	{ 0xF7B9, 0xE895A9 },
	{ 0xD9F3, 0xE895AA },
	{ 0xE1CB, 0xE895AD },
	{ 0xDADD, 0xE89684 },
	{ 0xDAB9, 0xE89687 },
	{ 0xEBFB, 0xE8968F },
	{ 0xCBB9, 0xE89691 },
	{ 0xEDF9, 0xE89694 },
	{ 0xE0E0, 0xE8969B },
	{ 0xF4C0, 0xE896A6 },
	{ 0xFDBC, 0xE896A8 },
	{ 0xDFB1, 0xE896A9 },
	{ 0xE3EF, 0xE896AA },
	{ 0xE0A3, 0xE896AF },
	{ 0xFDB9, 0xE896B0 },
	{ 0xF0B1, 0xE896BA },
	{ 0xCDCB, 0xE89781 },
	{ 0xEDBE, 0xE89789 },
	{ 0xD5C0, 0xE8978D },
	{ 0xE3F0, 0xE8978E },
	{ 0xEDFA, 0xE8978F },
	{ 0xE9E4, 0xE89795 },
	{ 0xD5ED, 0xE8979C },
	{ 0xE7DD, 0xE8979D },
	{ 0xD4F6, 0xE897A4 },
	{ 0xE5B7, 0xE897A5 },
	{ 0xDBE7, 0xE897A9 },
	{ 0xE2BF, 0xE897AA },
	{ 0xEECB, 0xE897B7 },
	{ 0xD7F4, 0xE897BA },
	{ 0xF0DD, 0xE897BB },
	{ 0xCEAB, 0xE897BF },
	{ 0xE7DE, 0xE89882 },
	{ 0xD6D6, 0xE89886 },
	{ 0xE1CC, 0xE89887 },
	{ 0xE8B3, 0xE8988A },
	{ 0xE5EE, 0xE89896 },
	{ 0xDCA2, 0xE89897 },
	{ 0xE0D0, 0xE8989A },
	{ 0xD5B5, 0xE898AD },
	{ 0xD5A1, 0xE898BF },
	{ 0xFBDB, 0xE8998E },
	{ 0xF9CB, 0xE89990 },
	{ 0xCBF3, 0xE89994 },
	{ 0xF4A5, 0xE89995 },
	{ 0xFAC8, 0xE8999B },
	{ 0xD6D7, 0xE8999C },
	{ 0xE9E5, 0xE8999E },
	{ 0xFBDC, 0xE8999F },
	{ 0xFDD0, 0xE899A7 },
	{ 0xFBF6, 0xE899B9 },
	{ 0xDAA5, 0xE89A8A },
	{ 0xDBBD, 0xE89A8C },
	{ 0xECE2, 0xE89A93 },
	{ 0xCDF7, 0xE89AA3 },
	{ 0xF0DE, 0xE89AA4 },
	{ 0xF6C9, 0xE89AA9 },
	{ 0xDEEF, 0xE89B87 },
	{ 0xD3B1, 0xE89B8B },
	{ 0xFCEE, 0xE89B94 },
	{ 0xE8C3, 0xE89B99 },
	{ 0xF1C8, 0xE89B9B },
	{ 0xCEF1, 0xE89B9F },
	{ 0xF9ED, 0xE89BA4 },
	{ 0xF2F4, 0xE89BAD },
	{ 0xE4B6, 0xE89BBE },
	{ 0xF5B9, 0xE89C80 },
	{ 0xDCF0, 0xE89C82 },
	{ 0xE3F1, 0xE89C83 },
	{ 0xE8A5, 0xE89C88 },
	{ 0xF2BB, 0xE89C98 },
	{ 0xDEA4, 0xE89C9A },
	{ 0xDACC, 0xE89C9C },
	{ 0xCAE9, 0xE89D8E },
	{ 0xE3DA, 0xE89D95 },
	{ 0xFCD9, 0xE89D97 },
	{ 0xEADA, 0xE89D9F },
	{ 0xF9C4, 0xE89DA6 },
	{ 0xE3A4, 0xE89DA8 },
	{ 0xFBDD, 0xE89DB4 },
	{ 0xEFCA, 0xE89DB6 },
	{ 0xE8C4, 0xE89DB8 },
	{ 0xD5CC, 0xE89E82 },
	{ 0xEBD7, 0xE89E8D },
	{ 0xD9AD, 0xE89E9F },
	{ 0xFBAB, 0xE89EA2 },
	{ 0xD3D9, 0xE89EB3 },
	{ 0xD5A2, 0xE89EBA },
	{ 0xF6DE, 0xE89F84 },
	{ 0xDAF6, 0xE89FA0 },
	{ 0xE0D1, 0xE89FAC },
	{ 0xE9A8, 0xE89FAF },
	{ 0xF5F9, 0xE89FB2 },
	{ 0xFAAF, 0xE89FB9 },
	{ 0xEBFC, 0xE89FBB },
	{ 0xE0EA, 0xE89FBE },
	{ 0xE3B2, 0xE8A085 },
	{ 0xD5C5, 0xE8A09F },
	{ 0xF1E3, 0xE8A0A2 },
	{ 0xD5EE, 0xE8A0A3 },
	{ 0xCDCC, 0xE8A0B1 },
	{ 0xEDD9, 0xE8A0B6 },
	{ 0xD8C1, 0xE8A0BB },
	{ 0xFAEC, 0xE8A180 },
	{ 0xF1EB, 0xE8A186 },
	{ 0xFABC, 0xE8A18C },
	{ 0xE6E2, 0xE8A18D },
	{ 0xFAE5, 0xE8A192 },
	{ 0xE2FA, 0xE8A193 },
	{ 0xCAB6, 0xE8A197 },
	{ 0xE4B7, 0xE8A199 },
	{ 0xEADB, 0xE8A19B },
	{ 0xF5FA, 0xE8A19D },
	{ 0xFBAC, 0xE8A1A1 },
	{ 0xCFC3, 0xE8A1A2 },
	{ 0xEBFD, 0xE8A1A3 },
	{ 0xF8FA, 0xE8A1A8 },
	{ 0xDFB9, 0xE8A1AB },
	{ 0xE1F1, 0xE8A1B0 },
	{ 0xD2A4, 0xE8A1B2 },
	{ 0xF5FB, 0xE8A1B7 },
	{ 0xD0DA, 0xE8A1BE },
	{ 0xD0DB, 0xE8A1BF },
	{ 0xEABE, 0xE8A281 },
	{ 0xD9B1, 0xE8A282 },
	{ 0xCAB7, 0xE8A288 },
	{ 0xD3E7, 0xE8A28B },
	{ 0xF8E5, 0xE8A28D },
	{ 0xD3B2, 0xE8A292 },
	{ 0xE2C0, 0xE8A296 },
	{ 0xF2DF, 0xE8A297 },
	{ 0xCDE5, 0xE8A29E },
	{ 0xF9AC, 0xE8A2AB },
	{ 0xCDCD, 0xE8A2B4 },
	{ 0xEEAE, 0xE8A381 },
	{ 0xD6AE, 0xE8A382 },
	{ 0xD7EA, 0xE8A38F },
	{ 0xE7E0, 0xE8A394 },
	{ 0xEBAE, 0xE8A395 },
	{ 0xCFD9, 0xE8A399 },
	{ 0xDCCD, 0xE8A39C },
	{ 0xEDFB, 0xE8A39D },
	{ 0xDEF0, 0xE8A39F },
	{ 0xD7EB, 0xE8A3A1 },
	{ 0xDEA5, 0xE8A3A8 },
	{ 0xDFD7, 0xE8A3B3 },
	{ 0xDBD0, 0xE8A3B4 },
	{ 0xDBD1, 0xE8A3B5 },
	{ 0xD5A3, 0xE8A3B8 },
	{ 0xF0B2, 0xE8A3BD },
	{ 0xDCDC, 0xE8A487 },
	{ 0xCAE8, 0xE8A490 },
	{ 0xF8E6, 0xE8A492 },
	{ 0xDCCE, 0xE8A493 },
	{ 0xEADC, 0xE8A498 },
	{ 0xDBD2, 0xE8A499 },
	{ 0xE9B3, 0xE8A4A5 },
	{ 0xF7DB, 0xE8A4AA },
	{ 0xE3A8, 0xE8A4B6 },
	{ 0xD7AE, 0xE8A4B8 },
	{ 0xE0E1, 0xE8A4BB },
	{ 0xCBBA, 0xE8A581 },
	{ 0xE5D1, 0xE8A584 },
	{ 0xD0DC, 0xE8A59F },
	{ 0xD5C1, 0xE8A5A4 },
	{ 0xD8CA, 0xE8A5AA },
	{ 0xE3A9, 0xE8A5B2 },
	{ 0xE0A4, 0xE8A5BF },
	{ 0xE9A9, 0xE8A681 },
	{ 0xD3C7, 0xE8A683 },
	{ 0xDCDD, 0xE8A686 },
	{ 0xF8AE, 0xE8A687 },
	{ 0xCCB8, 0xE8A68B },
	{ 0xD0AE, 0xE8A68F },
	{ 0xD8F2, 0xE8A693 },
	{ 0xE3CA, 0xE8A696 },
	{ 0xCCAF, 0xE8A6A1 },
	{ 0xD4AD, 0xE8A6A9 },
	{ 0xF6D1, 0xE8A6AA },
	{ 0xD0CC, 0xE8A6B2 },
	{ 0xCAC6, 0xE8A6BA },
	{ 0xD5C2, 0xE8A6BD },
	{ 0xCEBA, 0xE8A780 },
	{ 0xCAC7, 0xE8A792 },
	{ 0xFAB0, 0xE8A7A3 },
	{ 0xDFD8, 0xE8A7B4 },
	{ 0xF5BA, 0xE8A7B8 },
	{ 0xE5EB, 0xE8A880 },
	{ 0xEFF4, 0xE8A882 },
	{ 0xDDB5, 0xE8A883 },
	{ 0xCDAA, 0xE8A888 },
	{ 0xE3F2, 0xE8A88A },
	{ 0xFBF7, 0xE8A88C },
	{ 0xF7D0, 0xE8A88E },
	{ 0xFDBA, 0xE8A893 },
	{ 0xFDE1, 0xE8A896 },
	{ 0xF6FE, 0xE8A897 },
	{ 0xD1C0, 0xE8A898 },
	{ 0xE8C5, 0xE8A89B },
	{ 0xE4B8, 0xE8A89D },
	{ 0xE1E8, 0xE8A89F },
	{ 0xCCC1, 0xE8A8A3 },
	{ 0xD2ED, 0xE8A8A5 },
	{ 0xDBBE, 0xE8A8AA },
	{ 0xE0E2, 0xE8A8AD },
	{ 0xFAC9, 0xE8A8B1 },
	{ 0xE1CD, 0xE8A8B4 },
	{ 0xCAB8, 0xE8A8B6 },
	{ 0xF2E0, 0xE8A8BA },
	{ 0xF1C9, 0xE8A8BB },
	{ 0xDEF1, 0xE8A990 },
	{ 0xF0DF, 0xE8A994 },
	{ 0xF8C4, 0xE8A995 },
	{ 0xEECC, 0xE8A99B },
	{ 0xDEF2, 0xE8A99E },
	{ 0xE7C9, 0xE8A9A0 },
	{ 0xE2F3, 0xE8A9A2 },
	{ 0xE7E1, 0xE8A9A3 },
	{ 0xE3CB, 0xE8A9A6 },
	{ 0xE3CC, 0xE8A9A9 },
	{ 0xCFF8, 0xE8A9AD },
	{ 0xEFAC, 0xE8A9AE },
	{ 0xFDFE, 0xE8A9B0 },
	{ 0xFCA5, 0xE8A9B1 },
	{ 0xFAB1, 0xE8A9B2 },
	{ 0xDFD9, 0xE8A9B3 },
	{ 0xE0D2, 0xE8A9B5 },
	{ 0xF4DA, 0xE8A9B9 },
	{ 0xF1CA, 0xE8AA85 },
	{ 0xCEA3, 0xE8AA87 },
	{ 0xF2BC, 0xE8AA8C },
	{ 0xECE3, 0xE8AA8D },
	{ 0xE0A5, 0xE8AA93 },
	{ 0xF7AB, 0xE8AA95 },
	{ 0xEBAF, 0xE8AA98 },
	{ 0xE5DE, 0xE8AA9E },
	{ 0xE1A4, 0xE8AAA0 },
	{ 0xCDAB, 0xE8AAA1 },
	{ 0xD9F4, 0xE8AAA3 },
	{ 0xE8A6, 0xE8AAA4 },
	{ 0xCDCE, 0xE8AAA5 },
	{ 0xE1E9, 0xE8AAA6 },
	{ 0xFCEF, 0xE8AAA8 },
	{ 0xE0E3, 0xE8AAAA },
	{ 0xE2C1, 0xE8AAB0 },
	{ 0xCEA4, 0xE8AAB2 },
	{ 0xDEA6, 0xE8AAB9 },
	{ 0xEBFE, 0xE8AABC },
	{ 0xEBDD, 0xE8AABE },
	{ 0xF0E0, 0xE8AABF },
	{ 0xF4DB, 0xE8AB82 },
	{ 0xE2F4, 0xE8AB84 },
	{ 0xD3C8, 0xE8AB87 },
	{ 0xF4EB, 0xE8AB8B },
	{ 0xEEB5, 0xE8AB8D },
	{ 0xF5D8, 0xE8AB8F },
	{ 0xD5DF, 0xE8AB92 },
	{ 0xD6E5, 0xE8AB96 },
	{ 0xEBB0, 0xE8AB9B },
	{ 0xF4E3, 0xE8AB9C },
	{ 0xE3CD, 0xE8ABA1 },
	{ 0xF4F4, 0xE8ABA6 },
	{ 0xFAB2, 0xE8ABA7 },
	{ 0xEFF5, 0xE8ABAA },
	{ 0xCADF, 0xE8ABAB },
	{ 0xEBB1, 0xE8ABAD },
	{ 0xEDBF, 0xE8ABAE },
	{ 0xFDC9, 0xE8ABB1 },
	{ 0xE4A6, 0xE8ABB6 },
	{ 0xF9A4, 0xE8ABB7 },
	{ 0xF0B3, 0xE8ABB8 },
	{ 0xE5EC, 0xE8ABBA },
	{ 0xD1E7, 0xE8ABBE },
	{ 0xD9C7, 0xE8AC80 },
	{ 0xE4D7, 0xE8AC81 },
	{ 0xEADD, 0xE8AC82 },
	{ 0xD4F7, 0xE8AC84 },
	{ 0xDABA, 0xE8AC8E },
	{ 0xDACD, 0xE8AC90 },
	{ 0xF9CC, 0xE8AC94 },
	{ 0xE1DA, 0xE8AC96 },
	{ 0xDBBF, 0xE8AC97 },
	{ 0xCCC5, 0xE8AC99 },
	{ 0xECD0, 0xE8AC9A },
	{ 0xCBBB, 0xE8AC9B },
	{ 0xDEF3, 0xE8AC9D },
	{ 0xE9AA, 0xE8ACA0 },
	{ 0xD9C8, 0xE8ACA8 },
	{ 0xEEE3, 0xE8ACAB },
	{ 0xD7BD, 0xE8ACAC },
	{ 0xCFC4, 0xE8ACB3 },
	{ 0xD0CD, 0xE8ACB9 },
	{ 0xFCA6, 0xE8AD81 },
	{ 0xF1FB, 0xE8AD89 },
	{ 0xFDD2, 0xE8AD8E },
	{ 0xD1C1, 0xE8AD8F },
	{ 0xE3DB, 0xE8AD98 },
	{ 0xD3C9, 0xE8AD9A },
	{ 0xDCCF, 0xE8AD9C },
	{ 0xCCED, 0xE8ADA6 },
	{ 0xDEA7, 0xE8ADAC },
	{ 0xE6BB, 0xE8ADAF },
	{ 0xECA1, 0xE8ADB0 },
	{ 0xCCB9, 0xE8ADB4 },
	{ 0xFBDE, 0xE8ADB7 },
	{ 0xE7E2, 0xE8ADBD },
	{ 0xD4C1, 0xE8AE80 },
	{ 0xDCA8, 0xE8AE8A },
	{ 0xE2C2, 0xE8AE90 },
	{ 0xF3D8, 0xE8AE92 },
	{ 0xE5D3, 0xE8AE93 },
	{ 0xF3D9, 0xE8AE96 },
	{ 0xF3C6, 0xE8AE9A },
	{ 0xCDDB, 0xE8B0B7 },
	{ 0xCDAC, 0xE8B0BF },
	{ 0xFCC3, 0xE8B181 },
	{ 0xD4E7, 0xE8B186 },
	{ 0xD1C2, 0xE8B188 },
	{ 0xF9A5, 0xE8B18A },
	{ 0xE8D5, 0xE8B18C },
	{ 0xE3CE, 0xE8B195 },
	{ 0xD4CA, 0xE8B19A },
	{ 0xDFDA, 0xE8B1A1 },
	{ 0xFBDF, 0xE8B1AA },
	{ 0xE7E3, 0xE8B1AB },
	{ 0xF8FB, 0xE8B1B9 },
	{ 0xE3CF, 0xE8B1BA },
	{ 0xF5B0, 0xE8B282 },
	{ 0xD8E7, 0xE8B28A },
	{ 0xD9C9, 0xE8B28C },
	{ 0xF8AF, 0xE8B29D },
	{ 0xEFF6, 0xE8B29E },
	{ 0xDDB6, 0xE8B2A0 },
	{ 0xEEAF, 0xE8B2A1 },
	{ 0xCDF8, 0xE8B2A2 },
	{ 0xDEB8, 0xE8B2A7 },
	{ 0xFCA7, 0xE8B2A8 },
	{ 0xF7FC, 0xE8B2A9 },
	{ 0xF7B1, 0xE8B2AA },
	{ 0xCEBB, 0xE8B2AB },
	{ 0xF4A1, 0xE8B2AC },
	{ 0xEECD, 0xE8B2AF },
	{ 0xE1AE, 0xE8B2B0 },
	{ 0xECC3, 0xE8B2B3 },
	{ 0xCFFE, 0xE8B2B4 },
	{ 0xF8BF, 0xE8B2B6 },
	{ 0xD8E2, 0xE8B2B7 },
	{ 0xD3E8, 0xE8B2B8 },
	{ 0xDEA8, 0xE8B2BB },
	{ 0xF4E4, 0xE8B2BC },
	{ 0xECC2, 0xE8B2BD },
	{ 0xD9F5, 0xE8B2BF },
	{ 0xF9C5, 0xE8B380 },
	{ 0xDDD3, 0xE8B381 },
	{ 0xD6F1, 0xE8B382 },
	{ 0xECFC, 0xE8B383 },
	{ 0xFCF0, 0xE8B384 },
	{ 0xEDC0, 0xE8B387 },
	{ 0xCAB9, 0xE8B388 },
	{ 0xEEE4, 0xE8B38A },
	{ 0xF2E1, 0xE8B391 },
	{ 0xDEB9, 0xE8B393 },
	{ 0xD6F2, 0xE8B39A },
	{ 0xDEF4, 0xE8B39C },
	{ 0xDFDB, 0xE8B39E },
	{ 0xDBD3, 0xE8B3A0 },
	{ 0xFAE7, 0xE8B3A2 },
	{ 0xD8E3, 0xE8B3A3 },
	{ 0xF4C1, 0xE8B3A4 },
	{ 0xDDB7, 0xE8B3A6 },
	{ 0xF2F5, 0xE8B3AA },
	{ 0xD4AE, 0xE8B3AD },
	{ 0xD6F3, 0xE8B3B4 },
	{ 0xDDB8, 0xE8B3BB },
	{ 0xCFC5, 0xE8B3BC },
	{ 0xDFDF, 0xE8B3BD },
	{ 0xF2BE, 0xE8B484 },
	{ 0xF6A1, 0xE8B485 },
	{ 0xEBCB, 0xE8B487 },
	{ 0xF1FC, 0xE8B488 },
	{ 0xF3C7, 0xE8B48A },
	{ 0xE0EB, 0xE8B48D },
	{ 0xEDFC, 0xE8B493 },
	{ 0xE1DB, 0xE8B496 },
	{ 0xEEE5, 0xE8B5A4 },
	{ 0xDEF5, 0xE8B5A6 },
	{ 0xFAD3, 0xE8B5AB },
	{ 0xF1CB, 0xE8B5B0 },
	{ 0xD0AF, 0xE8B5B3 },
	{ 0xDDB9, 0xE8B5B4 },
	{ 0xD1C3, 0xE8B5B7 },
	{ 0xF5B1, 0xE8B685 },
	{ 0xEAC6, 0xE8B68A },
	{ 0xF0E1, 0xE8B699 },
	{ 0xF6AC, 0xE8B6A3 },
	{ 0xF5D9, 0xE8B6A8 },
	{ 0xF0EB, 0xE8B6B3 },
	{ 0xDDBA, 0xE8B6BA },
	{ 0xF2BF, 0xE8B6BE },
	{ 0xF7C5, 0xE8B786 },
	{ 0xDBA2, 0xE8B78B },
	{ 0xF2F6, 0xE8B78C },
	{ 0xCABA, 0xE8B78F },
	{ 0xF7F5, 0xE8B79B },
	{ 0xCBE5, 0xE8B79D },
	{ 0xEEE6, 0xE8B7A1 },
	{ 0xE0D3, 0xE8B7A3 },
	{ 0xCEA5, 0xE8B7A8 },
	{ 0xD6D8, 0xE8B7AF },
	{ 0xD4AF, 0xE8B7B3 },
	{ 0xE9C9, 0xE8B88A },
	{ 0xD3CE, 0xE8B88F },
	{ 0xF4C2, 0xE8B890 },
	{ 0xCBE6, 0xE8B89E },
	{ 0xF1A1, 0xE8B8AA },
	{ 0xEBB2, 0xE8B8B0 },
	{ 0xF1A2, 0xE8B8B5 },
	{ 0xEBB3, 0xE8B982 },
	{ 0xF0B4, 0xE8B984 },
	{ 0xCBF4, 0xE8B987 },
	{ 0xD4B0, 0xE8B988 },
	{ 0xF3B2, 0xE8B989 },
	{ 0xFBB7, 0xE8B98A },
	{ 0xF5EC, 0xE8B999 },
	{ 0xEEE7, 0xE8B99F },
	{ 0xF4B2, 0xE8B9A0 },
	{ 0xF5ED, 0xE8B9B4 },
	{ 0xCFF3, 0xE8B9B6 },
	{ 0xF0E2, 0xE8BA81 },
	{ 0xEECE, 0xE8BA87 },
	{ 0xF1CC, 0xE8BA8A },
	{ 0xE5B8, 0xE8BA8D },
	{ 0xD7F5, 0xE8BAAA },
	{ 0xE3F3, 0xE8BAAB },
	{ 0xCFE5, 0xE8BAAC },
	{ 0xCFC6, 0xE8BB80 },
	{ 0xF3B3, 0xE8BB8A },
	{ 0xE4D8, 0xE8BB8B },
	{ 0xCFF9, 0xE8BB8C },
	{ 0xCFDA, 0xE8BB8D },
	{ 0xFACD, 0xE8BB92 },
	{ 0xE6E3, 0xE8BB9F },
	{ 0xF2E2, 0xE8BBAB },
	{ 0xF5EE, 0xE8BBB8 },
	{ 0xCABB, 0xE8BBBB },
	{ 0xE3DC, 0xE8BBBE },
	{ 0xCEF2, 0xE8BC83 },
	{ 0xD6D9, 0xE8BC85 },
	{ 0xEEB0, 0xE8BC89 },
	{ 0xF4E5, 0xE8BC92 },
	{ 0xD8C2, 0xE8BC93 },
	{ 0xDCD0, 0xE8BC94 },
	{ 0xCCEE, 0xE8BC95 },
	{ 0xD5E0, 0xE8BC9B },
	{ 0xF6CA, 0xE8BC9C },
	{ 0xFDCA, 0xE8BC9D },
	{ 0xD8D6, 0xE8BC9E },
	{ 0xF4CF, 0xE8BC9F },
	{ 0xD6A6, 0xE8BCA6 },
	{ 0xDCBE, 0xE8BCA7 },
	{ 0xDBD4, 0xE8BCA9 },
	{ 0xD7C7, 0xE8BCAA },
	{ 0xF2FE, 0xE8BCAF },
	{ 0xF1CD, 0xE8BCB3 },
	{ 0xE2C3, 0xE8BCB8 },
	{ 0xDCDE, 0xE8BCB9 },
	{ 0xDCDF, 0xE8BCBB },
	{ 0xEFAD, 0xE8BCBE },
	{ 0xE6AB, 0xE8BCBF },
	{ 0xF9DD, 0xE8BD84 },
	{ 0xEABF, 0xE8BD85 },
	{ 0xEFAE, 0xE8BD89 },
	{ 0xF4D0, 0xE8BD8D },
	{ 0xCEF3, 0xE8BD8E },
	{ 0xE6AC, 0xE8BD9D },
	{ 0xCEDE, 0xE8BD9F },
	{ 0xD5F9, 0xE8BDA2 },
	{ 0xE3F4, 0xE8BE9B },
	{ 0xCDD0, 0xE8BE9C },
	{ 0xD5B8, 0xE8BEA3 },
	{ 0xF7FD, 0xE8BEA6 },
	{ 0xDCA9, 0xE8BEA8 },
	{ 0xDEF6, 0xE8BEAD },
	{ 0xDCAA, 0xE8BEAF },
	{ 0xF2E3, 0xE8BEB0 },
	{ 0xE9B4, 0xE8BEB1 },
	{ 0xD2DC, 0xE8BEB2 },
	{ 0xE9E6, 0xE8BF82 },
	{ 0xE3F6, 0xE8BF85 },
	{ 0xE7CA, 0xE8BF8E },
	{ 0xD0CE, 0xE8BF91 },
	{ 0xDAF7, 0xE8BF94 },
	{ 0xCABC, 0xE8BFA6 },
	{ 0xEEE8, 0xE8BFAA },
	{ 0xDADE, 0xE8BFAB },
	{ 0xF2F7, 0xE8BFAD },
	{ 0xE2FB, 0xE8BFB0 },
	{ 0xCCA6, 0xE8BFB2 },
	{ 0xDABB, 0xE8BFB7 },
	{ 0xEEE9, 0xE8BFB9 },
	{ 0xF5DA, 0xE8BFBD },
	{ 0xF7DC, 0xE98080 },
	{ 0xE1EA, 0xE98081 },
	{ 0xCEC1, 0xE98082 },
	{ 0xD4B1, 0xE98083 },
	{ 0xFDB1, 0xE98085 },
	{ 0xE6BD, 0xE98086 },
	{ 0xFBAD, 0xE98088 },
	{ 0xF8E7, 0xE9808B },
	{ 0xE1CE, 0xE9808D },
	{ 0xF7E2, 0xE9808F },
	{ 0xF5EF, 0xE98090 },
	{ 0xCFC7, 0xE98091 },
	{ 0xD4B2, 0xE98094 },
	{ 0xCCEF, 0xE98095 },
	{ 0xD4E8, 0xE98097 },
	{ 0xEECF, 0xE98099 },
	{ 0xF7D7, 0xE9809A },
	{ 0xE0A6, 0xE9809D },
	{ 0xD6C1, 0xE9809E },
	{ 0xE1DC, 0xE9809F },
	{ 0xF0E3, 0xE980A0 },
	{ 0xF1E4, 0xE980A1 },
	{ 0xDCF1, 0xE980A2 },
	{ 0xD6A7, 0xE980A3 },
	{ 0xF4F5, 0xE980AE },
	{ 0xF1CE, 0xE980B1 },
	{ 0xF2E4, 0xE980B2 },
	{ 0xD0B0, 0xE980B5 },
	{ 0xECEF, 0xE980B8 },
	{ 0xF9BA, 0xE980BC },
	{ 0xEBB5, 0xE980BE },
	{ 0xD4ED, 0xE98181 },
	{ 0xE2C4, 0xE98182 },
	{ 0xE9E7, 0xE98187 },
	{ 0xEBB4, 0xE9818A },
	{ 0xEAA1, 0xE9818B },
	{ 0xF8BC, 0xE9818D },
	{ 0xCEA6, 0xE9818E },
	{ 0xF9C6, 0xE98190 },
	{ 0xFCDA, 0xE98191 },
	{ 0xD4B3, 0xE98193 },
	{ 0xD3B9, 0xE98194 },
	{ 0xEADE, 0xE98195 },
	{ 0xE9AB, 0xE98199 },
	{ 0xE1E1, 0xE9819C },
	{ 0xD3CF, 0xE9819D },
	{ 0xF4F6, 0xE9819E },
	{ 0xEAC0, 0xE981A0 },
	{ 0xE1CF, 0xE981A1 },
	{ 0xCCBA, 0xE981A3 },
	{ 0xEEEA, 0xE981A9 },
	{ 0xF0E4, 0xE981AD },
	{ 0xF3B4, 0xE981AE },
	{ 0xD4EE, 0xE981AF },
	{ 0xF2C0, 0xE981B2 },
	{ 0xF1E5, 0xE981B5 },
	{ 0xF4C3, 0xE981B7 },
	{ 0xE0D4, 0xE981B8 },
	{ 0xEBB6, 0xE981BA },
	{ 0xD7A1, 0xE981BC },
	{ 0xCBE8, 0xE981BD },
	{ 0xF9AD, 0xE981BF },
	{ 0xE9AD, 0xE98280 },
	{ 0xD8E4, 0xE98281 },
	{ 0xFAB3, 0xE98282 },
	{ 0xE2C5, 0xE98283 },
	{ 0xFCBD, 0xE98284 },
	{ 0xECC4, 0xE98287 },
	{ 0xD8B1, 0xE98288 },
	{ 0xDCAB, 0xE9828A },
	{ 0xD5A4, 0xE9828F },
	{ 0xEBE9, 0xE98291 },
	{ 0xE8BB, 0xE98295 },
	{ 0xD8D7, 0xE98299 },
	{ 0xFBAE, 0xE982A2 },
	{ 0xD1E1, 0xE982A3 },
	{ 0xDBC0, 0xE982A6 },
	{ 0xF5BE, 0xE982A8 },
	{ 0xDEF7, 0xE982AA },
	{ 0xCAFB, 0xE982AF },
	{ 0xF7C6, 0xE982B0 },
	{ 0xCFC8, 0xE982B1 },
	{ 0xE1D0, 0xE982B5 },
	{ 0xEED0, 0xE982B8 },
	{ 0xE9F4, 0xE98381 },
	{ 0xCEF4, 0xE9838A },
	{ 0xD5CD, 0xE9839E },
	{ 0xCFDB, 0xE983A1 },
	{ 0xDDBB, 0xE983A8 },
	{ 0xCEAC, 0xE983AD },
	{ 0xE9E8, 0xE983B5 },
	{ 0xD4B4, 0xE983BD },
	{ 0xE4C7, 0xE98482 },
	{ 0xF5DB, 0xE98492 },
	{ 0xFAC1, 0xE98495 },
	{ 0xDEA9, 0xE98499 },
	{ 0xD4F8, 0xE984A7 },
	{ 0xEFF7, 0xE984AD },
	{ 0xD3B3, 0xE984B2 },
	{ 0xEBB7, 0xE98589 },
	{ 0xEFF8, 0xE9858A },
	{ 0xF5DC, 0xE9858B },
	{ 0xEDCC, 0xE9858C },
	{ 0xDBD5, 0xE9858D },
	{ 0xF1CF, 0xE9858E },
	{ 0xF1D0, 0xE98592 },
	{ 0xF5B2, 0xE985A2 },
	{ 0xD9AE, 0xE985A9 },
	{ 0xD5AC, 0xE985AA },
	{ 0xE2C6, 0xE985AC },
	{ 0xFDA3, 0xE985B5 },
	{ 0xFBE5, 0xE985B7 },
	{ 0xDFAB, 0xE985B8 },
	{ 0xE2F5, 0xE98687 },
	{ 0xF6AD, 0xE98689 },
	{ 0xF5B3, 0xE9868B },
	{ 0xF0B5, 0xE9868D },
	{ 0xE1A5, 0xE98692 },
	{ 0xF5DD, 0xE9869C },
	{ 0xECA2, 0xE986AB },
	{ 0xEDFD, 0xE986AC },
	{ 0xF5B4, 0xE986AE },
	{ 0xFBB8, 0xE986AF },
	{ 0xDBA3, 0xE986B1 },
	{ 0xD6CA, 0xE986B4 },
	{ 0xCBD9, 0xE986B5 },
	{ 0xE5D4, 0xE98780 },
	{ 0xF3FA, 0xE98787 },
	{ 0xEBB8, 0xE98789 },
	{ 0xE0B7, 0xE9878B },
	{ 0xD7EC, 0xE9878C },
	{ 0xF1EC, 0xE9878D },
	{ 0xE5AF, 0xE9878E },
	{ 0xD5E1, 0xE9878F },
	{ 0xD7ED, 0xE98790 },
	{ 0xD1D1, 0xE98791 },
	{ 0xE1F2, 0xE98797 },
	{ 0xEFF9, 0xE98798 },
	{ 0xDDBC, 0xE9879C },
	{ 0xF6DC, 0xE9879D },
	{ 0xF0E5, 0xE987A3 },
	{ 0xF4C4, 0xE987A7 },
	{ 0xE9E9, 0xE987AA },
	{ 0xF3FB, 0xE987B5 },
	{ 0xD4EF, 0xE9888D },
	{ 0xCCA2, 0xE98890 },
	{ 0xF7FE, 0xE98891 },
	{ 0xDFBC, 0xE98892 },
	{ 0xEBCD, 0xE98897 },
	{ 0xD0B7, 0xE9889E },
	{ 0xD6C2, 0xE988B4 },
	{ 0xE8AD, 0xE988BA },
	{ 0xEFAF, 0xE988BF },
	{ 0xCBA5, 0xE98980 },
	{ 0xCBE9, 0xE98985 },
	{ 0xFAE8, 0xE98989 },
	{ 0xCCC6, 0xE98997 },
	{ 0xE6E7, 0xE9899B },
	{ 0xEAC7, 0xE9899E },
	{ 0xDBA4, 0xE989A2 },
	{ 0xCFC9, 0xE989A4 },
	{ 0xE2FC, 0xE989A5 },
	{ 0xEFFA, 0xE989A6 },
	{ 0xEBDE, 0xE98A80 },
	{ 0xF5C8, 0xE98A83 },
	{ 0xD4DE, 0xE98A85 },
	{ 0xE0D5, 0xE98A91 },
	{ 0xEFB0, 0xE98A93 },
	{ 0xE2C7, 0xE98A96 },
	{ 0xD9AF, 0xE98A98 },
	{ 0xF9E7, 0xE98A9C },
	{ 0xE7E5, 0xE98AB3 },
	{ 0xCFCA, 0xE98AB6 },
	{ 0xE1D1, 0xE98AB7 },
	{ 0xE2C8, 0xE98AB9 },
	{ 0xEFFB, 0xE98B8C },
	{ 0xFAF9, 0xE98B8F },
	{ 0xDCF2, 0xE98B92 },
	{ 0xE0A7, 0xE98BA4 },
	{ 0xF8E8, 0xE98BAA },
	{ 0xCBEA, 0xE98BB8 },
	{ 0xCBBC, 0xE98BBC },
	{ 0xD6E2, 0xE98C84 },
	{ 0xF5DE, 0xE98C90 },
	{ 0xF5DF, 0xE98C98 },
	{ 0xEEB6, 0xE98C9A },
	{ 0xE2F6, 0xE98C9E },
	{ 0xD3CA, 0xE98C9F },
	{ 0xEFFC, 0xE98CA0 },
	{ 0xD1C4, 0xE98CA1 },
	{ 0xEFB1, 0xE98CA2 },
	{ 0xD1C5, 0xE98CA4 },
	{ 0xD0DE, 0xE98CA6 },
	{ 0xD9E1, 0xE98CA8 },
	{ 0xE0B8, 0xE98CAB },
	{ 0xCDD1, 0xE98CAE },
	{ 0xF3B9, 0xE98CAF },
	{ 0xE7CC, 0xE98D88 },
	{ 0xD6A8, 0xE98D8A },
	{ 0xCEA7, 0xE98D8B },
	{ 0xD4B5, 0xE98D8D },
	{ 0xE4C8, 0xE98D94 },
	{ 0xD3B4, 0xE98D9B },
	{ 0xEBB9, 0xE98DAE },
	{ 0xCBF5, 0xE98DB5 },
	{ 0xF6DD, 0xE98DBC },
	{ 0xF1A3, 0xE98DBE },
	{ 0xCCC7, 0xE98E8C },
	{ 0xE9CA, 0xE98E94 },
	{ 0xE1F0, 0xE98E96 },
	{ 0xF5E0, 0xE98E9A },
	{ 0xFBAF, 0xE98EA3 },
	{ 0xCBD1, 0xE98EA7 },
	{ 0xFBE0, 0xE98EAC },
	{ 0xF2E5, 0xE98EAD },
	{ 0xECF0, 0xE98EB0 },
	{ 0xF0EC, 0xE98F83 },
	{ 0xEEEB, 0xE98F91 },
	{ 0xE9CB, 0xE98F9E },
	{ 0xCCF0, 0xE98FA1 },
	{ 0xD7AF, 0xE98FA4 },
	{ 0xF3A1, 0xE98FB6 },
	{ 0xFCF5, 0xE99084 },
	{ 0xF1A4, 0xE99098 },
	{ 0xE0D6, 0xE990A5 },
	{ 0xEFB2, 0xE990AB },
	{ 0xF4D1, 0xE990B5 },
	{ 0xF7A1, 0xE990B8 },
	{ 0xF1D1, 0xE99184 },
	{ 0xCAFC, 0xE99191 },
	{ 0xCAFD, 0xE99192 },
	{ 0xCECE, 0xE9919B },
	{ 0xF3C8, 0xE991BD },
	{ 0xF3BA, 0xE991BF },
	{ 0xEDFE, 0xE995B7 },
	{ 0xDAA6, 0xE99680 },
	{ 0xE0EC, 0xE99683 },
	{ 0xF8CD, 0xE99689 },
	{ 0xCBD2, 0xE9968B },
	{ 0xEBCE, 0xE9968F },
	{ 0xF9D8, 0xE99691 },
	{ 0xF9D9, 0xE99692 },
	{ 0xCAE0, 0xE99693 },
	{ 0xDACA, 0xE99694 },
	{ 0xCBA6, 0xE99698 },
	{ 0xCAC8, 0xE996A3 },
	{ 0xF9EE, 0xE996A4 },
	{ 0xDBEC, 0xE996A5 },
	{ 0xD0B1, 0xE996A8 },
	{ 0xD5EF, 0xE996AD },
	{ 0xE6F3, 0xE996B1 },
	{ 0xE7A2, 0xE996BB },
	{ 0xE4D9, 0xE996BC },
	{ 0xE4E1, 0xE99787 },
	{ 0xFCC4, 0xE9978A },
	{ 0xF9EF, 0xE99794 },
	{ 0xCFF4, 0xE99795 },
	{ 0xF7E6, 0xE99796 },
	{ 0xCEBC, 0xE9979C },
	{ 0xF4C5, 0xE997A1 },
	{ 0xDCA3, 0xE997A2 },
	{ 0xDDBD, 0xE9989C },
	{ 0xF4C6, 0xE998A1 },
	{ 0xF8A1, 0xE998AA },
	{ 0xE8D6, 0xE998AE },
	{ 0xDBC1, 0xE998B2 },
	{ 0xF0E6, 0xE998BB },
	{ 0xE4B9, 0xE998BF },
	{ 0xF6ED, 0xE99980 },
	{ 0xF9AE, 0xE99982 },
	{ 0xDDBE, 0xE99984 },
	{ 0xD7B0, 0xE9998B },
	{ 0xD8E8, 0xE9998C },
	{ 0xCBBD, 0xE9998D },
	{ 0xF9DA, 0xE99990 },
	{ 0xF8CE, 0xE9999B },
	{ 0xF9F0, 0xE9999C },
	{ 0xE0ED, 0xE9999D },
	{ 0xE3B3, 0xE9999E },
	{ 0xF4B3, 0xE9999F },
	{ 0xEAC2, 0xE999A2 },
	{ 0xF2E6, 0xE999A3 },
	{ 0xF0B6, 0xE999A4 },
	{ 0xDBD6, 0xE999AA },
	{ 0xEBE4, 0xE999B0 },
	{ 0xF2E7, 0xE999B3 },
	{ 0xD7D5, 0xE999B5 },
	{ 0xD4B6, 0xE999B6 },
	{ 0xF9E8, 0xE999B7 },
	{ 0xD7C1, 0xE999B8 },
	{ 0xE5D5, 0xE999BD },
	{ 0xE9EA, 0xE99A85 },
	{ 0xD7CC, 0xE99A86 },
	{ 0xD3E9, 0xE99A8A },
	{ 0xE2C9, 0xE99A8B },
	{ 0xFCDB, 0xE99A8D },
	{ 0xCDAD, 0xE99A8E },
	{ 0xCCB0, 0xE99A94 },
	{ 0xEAA2, 0xE99A95 },
	{ 0xE4F6, 0xE99A98 },
	{ 0xD0C0, 0xE99A99 },
	{ 0xF0B7, 0xE99A9B },
	{ 0xEEA1, 0xE99A9C },
	{ 0xD7F6, 0xE99AA3 },
	{ 0xE2CA, 0xE99AA7 },
	{ 0xE2CB, 0xE99AA8 },
	{ 0xFACF, 0xE99AAA },
	{ 0xEBDF, 0xE99AB1 },
	{ 0xD6CB, 0xE99AB7 },
	{ 0xF4B4, 0xE99ABB },
	{ 0xEDCD, 0xE99B80 },
	{ 0xE4D2, 0xE99B81 },
	{ 0xEAA9, 0xE99B84 },
	{ 0xE4BA, 0xE99B85 },
	{ 0xF3A2, 0xE99B86 },
	{ 0xCDD2, 0xE99B87 },
	{ 0xF6CB, 0xE99B89 },
	{ 0xF1E6, 0xE99B8B },
	{ 0xEDC1, 0xE99B8C },
	{ 0xE8BC, 0xE99B8D },
	{ 0xEED1, 0xE99B8E },
	{ 0xF0E7, 0xE99B95 },
	{ 0xE2CC, 0xE99B96 },
	{ 0xE4AA, 0xE99B99 },
	{ 0xF5E1, 0xE99B9B },
	{ 0xEDDA, 0xE99B9C },
	{ 0xD7EE, 0xE99BA2 },
	{ 0xD1F1, 0xE99BA3 },
	{ 0xE9EB, 0xE99BA8 },
	{ 0xE9EC, 0xE99BA9 },
	{ 0xE0E4, 0xE99BAA },
	{ 0xDAA7, 0xE99BAF },
	{ 0xDDD4, 0xE99BB0 },
	{ 0xEAA3, 0xE99BB2 },
	{ 0xD6C3, 0xE99BB6 },
	{ 0xD6F4, 0xE99BB7 },
	{ 0xDADF, 0xE99BB9 },
	{ 0xEFB3, 0xE99BBB },
	{ 0xE2CD, 0xE99C80 },
	{ 0xEFFD, 0xE99C86 },
	{ 0xF2E8, 0xE99C87 },
	{ 0xEFC5, 0xE99C91 },
	{ 0xE7E7, 0xE99C93 },
	{ 0xD7FD, 0xE99C96 },
	{ 0xE7CE, 0xE99C99 },
	{ 0xDFDC, 0xE99C9C },
	{ 0xF9C7, 0xE99C9E },
	{ 0xD9F6, 0xE99CA7 },
	{ 0xDFAC, 0xE99CB0 },
	{ 0xD6DA, 0xE99CB2 },
	{ 0xDCA4, 0xE99CB9 },
	{ 0xF0B8, 0xE99CBD },
	{ 0xD5FA, 0xE99D82 },
	{ 0xE4F7, 0xE99D84 },
	{ 0xD6C4, 0xE99D88 },
	{ 0xF4EC, 0xE99D91 },
	{ 0xEFFE, 0xE99D96 },
	{ 0xF0A1, 0xE99D9C },
	{ 0xDEAA, 0xE99D9E },
	{ 0xDABC, 0xE99DA1 },
	{ 0xD8FC, 0xE99DA2 },
	{ 0xFAD4, 0xE99DA9 },
	{ 0xECE5, 0xE99DAD },
	{ 0xFCA8, 0xE99DB4 },
	{ 0xECE6, 0xE99DB7 },
	{ 0xD8CB, 0xE99DBA },
	{ 0xFBB9, 0xE99E8B },
	{ 0xE4D3, 0xE99E8D },
	{ 0xCDF9, 0xE99E8F },
	{ 0xCFD3, 0xE99EA0 },
	{ 0xCAEA, 0xE99EA8 },
	{ 0xCFD4, 0xE99EAB },
	{ 0xF8BD, 0xE99EAD },
	{ 0xF4C7, 0xE99F86 },
	{ 0xEADF, 0xE99F8B },
	{ 0xF9DB, 0xE99F93 },
	{ 0xD4B7, 0xE99F9C },
	{ 0xEBE5, 0xE99FB3 },
	{ 0xE1D2, 0xE99FB6 },
	{ 0xEAA4, 0xE99FBB },
	{ 0xFAC2, 0xE99FBF },
	{ 0xFBE1, 0xE9A080 },
	{ 0xFAED, 0xE9A081 },
	{ 0xF0A2, 0xE9A082 },
	{ 0xCCF1, 0xE9A083 },
	{ 0xFAA3, 0xE9A085 },
	{ 0xE2F7, 0xE9A086 },
	{ 0xE2CE, 0xE9A088 },
	{ 0xE9F5, 0xE9A08A },
	{ 0xE1EB, 0xE9A08C },
	{ 0xE7E8, 0xE9A090 },
	{ 0xE8D7, 0xE9A091 },
	{ 0xDAF8, 0xE9A092 },
	{ 0xD4CB, 0xE9A093 },
	{ 0xF7F6, 0xE9A097 },
	{ 0xD6C5, 0xE9A098 },
	{ 0xD4E9, 0xE9A0AD },
	{ 0xFAFA, 0xE9A0B0 },
	{ 0xCCF2, 0xE9A0B8 },
	{ 0xF7DD, 0xE9A0B9 },
	{ 0xDEBA, 0xE9A0BB },
	{ 0xCEA8, 0xE9A186 },
	{ 0xF0B9, 0xE9A18C },
	{ 0xE4FE, 0xE9A18D },
	{ 0xE4C9, 0xE9A18E },
	{ 0xE4D4, 0xE9A194 },
	{ 0xEAC3, 0xE9A198 },
	{ 0xEFB4, 0xE9A19A },
	{ 0xD7BE, 0xE9A19E },
	{ 0xFBE2, 0xE9A1A5 },
	{ 0xCDD3, 0xE9A1A7 },
	{ 0xEFB5, 0xE9A1AB },
	{ 0xFAE9, 0xE9A1AF },
	{ 0xF9A6, 0xE9A2A8 },
	{ 0xDFBD, 0xE9A2AF },
	{ 0xF7C7, 0xE9A2B1 },
	{ 0xF8FD, 0xE9A384 },
	{ 0xF8FC, 0xE9A387 },
	{ 0xDEAB, 0xE9A39B },
	{ 0xDBE8, 0xE9A39C },
	{ 0xE3DD, 0xE9A39F },
	{ 0xE1E2, 0xE9A3A1 },
	{ 0xD1C6, 0xE9A3A2 },
	{ 0xF6D0, 0xE9A3AD },
	{ 0xEBE6, 0xE9A3AE },
	{ 0xDAF9, 0xE9A3AF },
	{ 0xECC7, 0xE9A3B4 },
	{ 0xDEF8, 0xE9A3BC },
	{ 0xF8E9, 0xE9A3BD },
	{ 0xE3DE, 0xE9A3BE },
	{ 0xCEF5, 0xE9A483 },
	{ 0xFAC3, 0xE9A489 },
	{ 0xE5D7, 0xE9A48A },
	{ 0xECC8, 0xE9A48C },
	{ 0xF3C9, 0xE9A490 },
	{ 0xE4BB, 0xE9A493 },
	{ 0xE6AE, 0xE9A498 },
	{ 0xEFB6, 0xE9A49E },
	{ 0xDCBF, 0xE9A4A0 },
	{ 0xCEBD, 0xE9A4A8 },
	{ 0xD8C3, 0xE9A585 },
	{ 0xD0CF, 0xE9A589 },
	{ 0xCFFA, 0xE9A58B },
	{ 0xF3CA, 0xE9A58C },
	{ 0xE0D7, 0xE9A58D },
	{ 0xD1C7, 0xE9A591 },
	{ 0xE9AE, 0xE9A592 },
	{ 0xE8BD, 0xE9A594 },
	{ 0xFAC4, 0xE9A597 },
	{ 0xE2CF, 0xE9A696 },
	{ 0xFAC5, 0xE9A699 },
	{ 0xF9B8, 0xE9A69D },
	{ 0xDCE0, 0xE9A6A5 },
	{ 0xFBB0, 0xE9A6A8 },
	{ 0xD8A9, 0xE9A6AC },
	{ 0xE5DF, 0xE9A6AD },
	{ 0xF9A7, 0xE9A6AE },
	{ 0xF6EE, 0xE9A6B1 },
	{ 0xF6CC, 0xE9A6B3 },
	{ 0xE2F8, 0xE9A6B4 },
	{ 0xECF1, 0xE9A6B9 },
	{ 0xDAE0, 0xE9A781 },
	{ 0xF1D2, 0xE9A790 },
	{ 0xD2CC, 0xE9A791 },
	{ 0xCFCB, 0xE9A792 },
	{ 0xCABD, 0xE9A795 },
	{ 0xDDBF, 0xE9A799 },
	{ 0xF6EF, 0xE9A79D },
	{ 0xDEF9, 0xE9A79F },
	{ 0xFAB4, 0xE9A7AD },
	{ 0xD5AD, 0xE9A7B1 },
	{ 0xF1E7, 0xE9A7BF },
	{ 0xDEBE, 0xE9A881 },
	{ 0xDCC0, 0xE9A888 },
	{ 0xD1C8, 0xE9A88E },
	{ 0xD1C9, 0xE9A88F },
	{ 0xF8BE, 0xE9A899 },
	{ 0xCBF6, 0xE9A8AB },
	{ 0xD4F9, 0xE9A8B0 },
	{ 0xF5E2, 0xE9A8B6 },
	{ 0xE1D3, 0xE9A8B7 },
	{ 0xD8E9, 0xE9A980 },
	{ 0xF8FE, 0xE9A983 },
	{ 0xCFCC, 0xE9A985 },
	{ 0xFDA4, 0xE9A98D },
	{ 0xCEF6, 0xE9A995 },
	{ 0xFAD0, 0xE9A997 },
	{ 0xCCF3, 0xE9A99A },
	{ 0xE6BE, 0xE9A99B },
	{ 0xF6AE, 0xE9A99F },
	{ 0xD5F0, 0xE9A9A2 },
	{ 0xD1CA, 0xE9A9A5 },
	{ 0xFCBE, 0xE9A9A9 },
	{ 0xD5F1, 0xE9A9AA },
	{ 0xCDE9, 0xE9AAA8 },
	{ 0xFAB5, 0xE9AAB8 },
	{ 0xE2D0, 0xE9AB93 },
	{ 0xF4F7, 0xE9AB94 },
	{ 0xCDD4, 0xE9AB98 },
	{ 0xE7A3, 0xE9ABA5 },
	{ 0xDBA5, 0xE9ABAE },
	{ 0xE2D1, 0xE9AC9A },
	{ 0xD7A2, 0xE9ACA7 },
	{ 0xF7E3, 0xE9ACAA },
	{ 0xEAA6, 0xE9ACB1 },
	{ 0xD0A1, 0xE9ACBC },
	{ 0xCEDA, 0xE9AD81 },
	{ 0xFBEB, 0xE9AD82 },
	{ 0xDBA6, 0xE9AD83 },
	{ 0xDBDE, 0xE9AD84 },
	{ 0xD8E5, 0xE9AD85 },
	{ 0xEAE0, 0xE9AD8F },
	{ 0xD8AA, 0xE9AD94 },
	{ 0xE5E0, 0xE9AD9A },
	{ 0xD6DB, 0xE9ADAF },
	{ 0xEFC6, 0xE9AE8E },
	{ 0xF8EA, 0xE9AE91 },
	{ 0xE4D5, 0xE9AE9F },
	{ 0xCEF7, 0xE9AEAB },
	{ 0xE0D8, 0xE9AEAE },
	{ 0xD7EF, 0xE9AF89 },
	{ 0xF4ED, 0xE9AF96 },
	{ 0xCDE6, 0xE9AFA4 },
	{ 0xCCF4, 0xE9AFA8 },
	{ 0xF5E3, 0xE9B08D },
	{ 0xE4CA, 0xE9B090 },
	{ 0xDCE1, 0xE9B092 },
	{ 0xF9C8, 0xE9B095 },
	{ 0xFCBF, 0xE9B0A5 },
	{ 0xE8A7, 0xE9B0B2 },
	{ 0xD8C4, 0xE9B0BB },
	{ 0xCBBE, 0xE9B187 },
	{ 0xDCAE, 0xE9B189 },
	{ 0xD7F7, 0xE9B197 },
	{ 0xF0E8, 0xE9B3A5 },
	{ 0xDDC0, 0xE9B3A7 },
	{ 0xCFCD, 0xE9B3A9 },
	{ 0xDCF3, 0xE9B3B3 },
	{ 0xD9B0, 0xE9B3B4 },
	{ 0xE6E9, 0xE9B3B6 },
	{ 0xE4BC, 0xE9B489 },
	{ 0xEAC4, 0xE9B49B },
	{ 0xE4EC, 0xE9B4A6 },
	{ 0xE4E5, 0xE9B4A8 },
	{ 0xFBF8, 0xE9B4BB },
	{ 0xCCBB, 0xE9B591 },
	{ 0xE4BD, 0xE9B59D },
	{ 0xCDDC, 0xE9B5A0 },
	{ 0xD9F7, 0xE9B5A1 },
	{ 0xDDDF, 0xE9B5AC },
	{ 0xEDCE, 0xE9B5B2 },
	{ 0xD9D0, 0xE9B6A9 },
	{ 0xE5A3, 0xE9B6AF },
	{ 0xF9CD, 0xE9B6B4 },
	{ 0xCDAE, 0xE9B784 },
	{ 0xCFCE, 0xE9B797 },
	{ 0xF6AF, 0xE9B7B2 },
	{ 0xFDD3, 0xE9B7B8 },
	{ 0xEBED, 0xE9B7B9 },
	{ 0xD6DC, 0xE9B7BA },
	{ 0xE5A4, 0xE9B89A },
	{ 0xD5B6, 0xE9B89E },
	{ 0xD6DD, 0xE9B9B5 },
	{ 0xF9E9, 0xE9B9B9 },
	{ 0xE7A4, 0xE9B9BD },
	{ 0xD6E3, 0xE9B9BF },
	{ 0xD1CB, 0xE9BA92 },
	{ 0xD6E4, 0xE9BA93 },
	{ 0xD5F2, 0xE9BA97 },
	{ 0xDEFA, 0xE9BA9D },
	{ 0xD7F8, 0xE9BA9F },
	{ 0xD8EA, 0xE9BAA5 },
	{ 0xCFD5, 0xE9BAB4 },
	{ 0xD8FD, 0xE9BAB5 },
	{ 0xD8AB, 0xE9BABB },
	{ 0xFDCB, 0xE9BABE },
	{ 0xFCDC, 0xE9BB83 },
	{ 0xE0A8, 0xE9BB8D },
	{ 0xD5F3, 0xE9BB8E },
	{ 0xFDD9, 0xE9BB91 },
	{ 0xCCA3, 0xE9BB94 },
	{ 0xD9F9, 0xE9BB98 },
	{ 0xD3EA, 0xE9BB9B },
	{ 0xF5F5, 0xE9BB9C },
	{ 0xEFC7, 0xE9BB9E },
	{ 0xD3DA, 0xE9BBA8 },
	{ 0xDABD, 0xE9BBB4 },
	{ 0xE8A8, 0xE9BC87 },
	{ 0xDCAF, 0xE9BC88 },
	{ 0xF0A3, 0xE9BC8E },
	{ 0xCDD5, 0xE9BC93 },
	{ 0xE0A9, 0xE9BCA0 },
	{ 0xDEAC, 0xE9BCBB },
	{ 0xF0BA, 0xE9BD8A },
	{ 0xEEB1, 0xE9BD8B },
	{ 0xEEB2, 0xE9BD8E },
	{ 0xF6CD, 0xE9BD92 },
	{ 0xEED2, 0xE9BD9F },
	{ 0xD6C6, 0xE9BDA1 },
	{ 0xE0E5, 0xE9BDA7 },
	{ 0xF3BB, 0xE9BDAA },
	{ 0xE5E1, 0xE9BDAC },
	{ 0xE4CB, 0xE9BDB7 },
	{ 0xD7A3, 0xE9BE8D },
	{ 0xDBC2, 0xE9BE90 },
	{ 0xCAFE, 0xE9BE95 },
	{ 0xCFCF, 0xE9BE9C },
	{ 0xB0A1, 0xEAB080 },
	{ 0xB0A2, 0xEAB081 },
	{ 0xB0A3, 0xEAB084 },
	{ 0xB0A4, 0xEAB087 },
	{ 0xB0A5, 0xEAB088 },
	{ 0xB0A6, 0xEAB089 },
	{ 0xB0A7, 0xEAB08A },
	{ 0xB0A8, 0xEAB090 },
	{ 0xB0A9, 0xEAB091 },
	{ 0xB0AA, 0xEAB092 },
	{ 0xB0AB, 0xEAB093 },
	{ 0xB0AC, 0xEAB094 },
	{ 0xB0AD, 0xEAB095 },
	{ 0xB0AE, 0xEAB096 },
	{ 0xB0AF, 0xEAB097 },
	{ 0xB0B0, 0xEAB099 },
	{ 0xB0B1, 0xEAB09A },
	{ 0xB0B2, 0xEAB09B },
	{ 0xB0B3, 0xEAB09C },
	{ 0xB0B4, 0xEAB09D },
	{ 0xB0B5, 0xEAB0A0 },
	{ 0xB0B6, 0xEAB0A4 },
	{ 0xB0B7, 0xEAB0AC },
	{ 0xB0B8, 0xEAB0AD },
	{ 0xB0B9, 0xEAB0AF },
	{ 0xB0BA, 0xEAB0B0 },
	{ 0xB0BB, 0xEAB0B1 },
	{ 0xB0BC, 0xEAB0B8 },
	{ 0xB0BD, 0xEAB0B9 },
	{ 0xB0BE, 0xEAB0BC },
	{ 0xB0BF, 0xEAB180 },
	{ 0xB0C0, 0xEAB18B },
	{ 0xB0C1, 0xEAB18D },
	{ 0xB0C2, 0xEAB194 },
	{ 0xB0C3, 0xEAB198 },
	{ 0xB0C4, 0xEAB19C },
	{ 0xB0C5, 0xEAB1B0 },
	{ 0xB0C6, 0xEAB1B1 },
	{ 0xB0C7, 0xEAB1B4 },
	{ 0xB0C8, 0xEAB1B7 },
	{ 0xB0C9, 0xEAB1B8 },
	{ 0xB0CA, 0xEAB1BA },
	{ 0xB0CB, 0xEAB280 },
	{ 0xB0CC, 0xEAB281 },
	{ 0xB0CD, 0xEAB283 },
	{ 0xB0CE, 0xEAB284 },
	{ 0xB0CF, 0xEAB285 },
	{ 0xB0D0, 0xEAB286 },
	{ 0xB0D1, 0xEAB289 },
	{ 0xB0D2, 0xEAB28A },
	{ 0xB0D3, 0xEAB28B },
	{ 0xB0D4, 0xEAB28C },
	{ 0xB0D5, 0xEAB290 },
	{ 0xB0D6, 0xEAB294 },
	{ 0xB0D7, 0xEAB29C },
	{ 0xB0D8, 0xEAB29D },
	{ 0xB0D9, 0xEAB29F },
	{ 0xB0DA, 0xEAB2A0 },
	{ 0xB0DB, 0xEAB2A1 },
	{ 0xB0DC, 0xEAB2A8 },
	{ 0xB0DD, 0xEAB2A9 },
	{ 0xB0DE, 0xEAB2AA },
	{ 0xB0DF, 0xEAB2AC },
	{ 0xB0E0, 0xEAB2AF },
	{ 0xB0E1, 0xEAB2B0 },
	{ 0xB0E2, 0xEAB2B8 },
	{ 0xB0E3, 0xEAB2B9 },
	{ 0xB0E4, 0xEAB2BB },
	{ 0xB0E5, 0xEAB2BC },
	{ 0xB0E6, 0xEAB2BD },
	{ 0xB0E7, 0xEAB381 },
	{ 0xB0E8, 0xEAB384 },
	{ 0xB0E9, 0xEAB388 },
	{ 0xB0EA, 0xEAB38C },
	{ 0xB0EB, 0xEAB395 },
	{ 0xB0EC, 0xEAB397 },
	{ 0xB0ED, 0xEAB3A0 },
	{ 0xB0EE, 0xEAB3A1 },
	{ 0xB0EF, 0xEAB3A4 },
	{ 0xB0F0, 0xEAB3A7 },
	{ 0xB0F1, 0xEAB3A8 },
	{ 0xB0F2, 0xEAB3AA },
	{ 0xB0F3, 0xEAB3AC },
	{ 0xB0F4, 0xEAB3AF },
	{ 0xB0F5, 0xEAB3B0 },
	{ 0xB0F6, 0xEAB3B1 },
	{ 0xB0F7, 0xEAB3B3 },
	{ 0xB0F8, 0xEAB3B5 },
	{ 0xB0F9, 0xEAB3B6 },
	{ 0xB0FA, 0xEAB3BC },
	{ 0xB0FB, 0xEAB3BD },
	{ 0xB0FC, 0xEAB480 },
	{ 0xB0FD, 0xEAB484 },
	{ 0xB0FE, 0xEAB486 },
	{ 0xB1A1, 0xEAB48C },
	{ 0xB1A2, 0xEAB48D },
	{ 0xB1A3, 0xEAB48F },
	{ 0xB1A4, 0xEAB491 },
	{ 0xB1A5, 0xEAB498 },
	{ 0xB1A6, 0xEAB49C },
	{ 0xB1A7, 0xEAB4A0 },
	{ 0xB1A8, 0xEAB4A9 },
	{ 0xB1A9, 0xEAB4AC },
	{ 0xB1AA, 0xEAB4AD },
	{ 0xB1AB, 0xEAB4B4 },
	{ 0xB1AC, 0xEAB4B5 },
	{ 0xB1AD, 0xEAB4B8 },
	{ 0xB1AE, 0xEAB4BC },
	{ 0xB1AF, 0xEAB584 },
	{ 0xB1B0, 0xEAB585 },
	{ 0xB1B1, 0xEAB587 },
	{ 0xB1B2, 0xEAB589 },
	{ 0xB1B3, 0xEAB590 },
	{ 0xB1B4, 0xEAB594 },
	{ 0xB1B5, 0xEAB598 },
	{ 0xB1B6, 0xEAB5A1 },
	{ 0xB1B7, 0xEAB5A3 },
	{ 0xB1B8, 0xEAB5AC },
	{ 0xB1B9, 0xEAB5AD },
	{ 0xB1BA, 0xEAB5B0 },
	{ 0xB1BB, 0xEAB5B3 },
	{ 0xB1BC, 0xEAB5B4 },
	{ 0xB1BD, 0xEAB5B5 },
	{ 0xB1BE, 0xEAB5B6 },
	{ 0xB1BF, 0xEAB5BB },
	{ 0xB1C0, 0xEAB5BC },
	{ 0xB1C1, 0xEAB5BD },
	{ 0xB1C2, 0xEAB5BF },
	{ 0xB1C3, 0xEAB681 },
	{ 0xB1C4, 0xEAB682 },
	{ 0xB1C5, 0xEAB688 },
	{ 0xB1C6, 0xEAB689 },
	{ 0xB1C7, 0xEAB68C },
	{ 0xB1C8, 0xEAB690 },
	{ 0xB1C9, 0xEAB69C },
	{ 0xB1CA, 0xEAB69D },
	{ 0xB1CB, 0xEAB6A4 },
	{ 0xB1CC, 0xEAB6B7 },
	{ 0xB1CD, 0xEAB780 },
	{ 0xB1CE, 0xEAB781 },
	{ 0xB1CF, 0xEAB784 },
	{ 0xB1D0, 0xEAB788 },
	{ 0xB1D1, 0xEAB790 },
	{ 0xB1D2, 0xEAB791 },
	{ 0xB1D3, 0xEAB793 },
	{ 0xB1D4, 0xEAB79C },
	{ 0xB1D5, 0xEAB7A0 },
	{ 0xB1D6, 0xEAB7A4 },
	{ 0xB1D7, 0xEAB7B8 },
	{ 0xB1D8, 0xEAB7B9 },
	{ 0xB1D9, 0xEAB7BC },
	{ 0xB1DA, 0xEAB7BF },
	{ 0xB1DB, 0xEAB880 },
	{ 0xB1DC, 0xEAB881 },
	{ 0xB1DD, 0xEAB888 },
	{ 0xB1DE, 0xEAB889 },
	{ 0xB1DF, 0xEAB88B },
	{ 0xB1E0, 0xEAB88D },
	{ 0xB1E1, 0xEAB894 },
	{ 0xB1E2, 0xEAB8B0 },
	{ 0xB1E3, 0xEAB8B1 },
	{ 0xB1E4, 0xEAB8B4 },
	{ 0xB1E5, 0xEAB8B7 },
	{ 0xB1E6, 0xEAB8B8 },
	{ 0xB1E7, 0xEAB8BA },
	{ 0xB1E8, 0xEAB980 },
	{ 0xB1E9, 0xEAB981 },
	{ 0xB1EA, 0xEAB983 },
	{ 0xB1EB, 0xEAB985 },
	{ 0xB1EC, 0xEAB986 },
	{ 0xB1ED, 0xEAB98A },
	{ 0xB1EE, 0xEAB98C },
	{ 0xB1EF, 0xEAB98D },
	{ 0xB1F0, 0xEAB98E },
	{ 0xB1F1, 0xEAB990 },
	{ 0xB1F2, 0xEAB994 },
	{ 0xB1F3, 0xEAB996 },
	{ 0xB1F4, 0xEAB99C },
	{ 0xB1F5, 0xEAB99D },
	{ 0xB1F6, 0xEAB99F },
	{ 0xB1F7, 0xEAB9A0 },
	{ 0xB1F8, 0xEAB9A1 },
	{ 0xB1F9, 0xEAB9A5 },
	{ 0xB1FA, 0xEAB9A8 },
	{ 0xB1FB, 0xEAB9A9 },
	{ 0xB1FC, 0xEAB9AC },
	{ 0xB1FD, 0xEAB9B0 },
	{ 0xB1FE, 0xEAB9B8 },
	{ 0xB2A1, 0xEAB9B9 },
	{ 0xB2A2, 0xEAB9BB },
	{ 0xB2A3, 0xEAB9BC },
	{ 0xB2A4, 0xEAB9BD },
	{ 0xB2A5, 0xEABA84 },
	{ 0xB2A6, 0xEABA85 },
	{ 0xB2A7, 0xEABA8C },
	{ 0xB2A8, 0xEABABC },
	{ 0xB2A9, 0xEABABD },
	{ 0xB2AA, 0xEABABE },
	{ 0xB2AB, 0xEABB80 },
	{ 0xB2AC, 0xEABB84 },
	{ 0xB2AD, 0xEABB8C },
	{ 0xB2AE, 0xEABB8D },
	{ 0xB2AF, 0xEABB8F },
	{ 0xB2B0, 0xEABB90 },
	{ 0xB2B1, 0xEABB91 },
	{ 0xB2B2, 0xEABB98 },
	{ 0xB2B3, 0xEABB99 },
	{ 0xB2B4, 0xEABB9C },
	{ 0xB2B5, 0xEABBA8 },
	{ 0xB2B6, 0xEABBAB },
	{ 0xB2B7, 0xEABBAD },
	{ 0xB2B8, 0xEABBB4 },
	{ 0xB2B9, 0xEABBB8 },
	{ 0xB2BA, 0xEABBBC },
	{ 0xB2BB, 0xEABC87 },
	{ 0xB2BC, 0xEABC88 },
	{ 0xB2BD, 0xEABC8D },
	{ 0xB2BE, 0xEABC90 },
	{ 0xB2BF, 0xEABCAC },
	{ 0xB2C0, 0xEABCAD },
	{ 0xB2C1, 0xEABCB0 },
	{ 0xB2C2, 0xEABCB2 },
	{ 0xB2C3, 0xEABCB4 },
	{ 0xB2C4, 0xEABCBC },
	{ 0xB2C5, 0xEABCBD },
	{ 0xB2C6, 0xEABCBF },
	{ 0xB2C7, 0xEABD81 },
	{ 0xB2C8, 0xEABD82 },
	{ 0xB2C9, 0xEABD83 },
	{ 0xB2CA, 0xEABD88 },
	{ 0xB2CB, 0xEABD89 },
	{ 0xB2CC, 0xEABD90 },
	{ 0xB2CD, 0xEABD9C },
	{ 0xB2CE, 0xEABD9D },
	{ 0xB2CF, 0xEABDA4 },
	{ 0xB2D0, 0xEABDA5 },
	{ 0xB2D1, 0xEABDB9 },
	{ 0xB2D2, 0xEABE80 },
	{ 0xB2D3, 0xEABE84 },
	{ 0xB2D4, 0xEABE88 },
	{ 0xB2D5, 0xEABE90 },
	{ 0xB2D6, 0xEABE91 },
	{ 0xB2D7, 0xEABE95 },
	{ 0xB2D8, 0xEABE9C },
	{ 0xB2D9, 0xEABEB8 },
	{ 0xB2DA, 0xEABEB9 },
	{ 0xB2DB, 0xEABEBC },
	{ 0xB2DC, 0xEABF80 },
	{ 0xB2DD, 0xEABF87 },
	{ 0xB2DE, 0xEABF88 },
	{ 0xB2DF, 0xEABF89 },
	{ 0xB2E0, 0xEABF8B },
	{ 0xB2E1, 0xEABF8D },
	{ 0xB2E2, 0xEABF8E },
	{ 0xB2E3, 0xEABF94 },
	{ 0xB2E4, 0xEABF9C },
	{ 0xB2E5, 0xEABFA8 },
	{ 0xB2E6, 0xEABFA9 },
	{ 0xB2E7, 0xEABFB0 },
	{ 0xB2E8, 0xEABFB1 },
	{ 0xB2E9, 0xEABFB4 },
	{ 0xB2EA, 0xEABFB8 },
	{ 0xB2EB, 0xEB8080 },
	{ 0xB2EC, 0xEB8081 },
	{ 0xB2ED, 0xEB8084 },
	{ 0xB2EE, 0xEB808C },
	{ 0xB2EF, 0xEB8090 },
	{ 0xB2F0, 0xEB8094 },
	{ 0xB2F1, 0xEB809C },
	{ 0xB2F2, 0xEB809D },
	{ 0xB2F3, 0xEB80A8 },
	{ 0xB2F4, 0xEB8184 },
	{ 0xB2F5, 0xEB8185 },
	{ 0xB2F6, 0xEB8188 },
	{ 0xB2F7, 0xEB818A },
	{ 0xB2F8, 0xEB818C },
	{ 0xB2F9, 0xEB818E },
	{ 0xB2FA, 0xEB8193 },
	{ 0xB2FB, 0xEB8194 },
	{ 0xB2FC, 0xEB8195 },
	{ 0xB2FD, 0xEB8197 },
	{ 0xB2FE, 0xEB8199 },
	{ 0xB3A1, 0xEB819D },
	{ 0xB3A2, 0xEB81BC },
	{ 0xB3A3, 0xEB81BD },
	{ 0xB3A4, 0xEB8280 },
	{ 0xB3A5, 0xEB8284 },
	{ 0xB3A6, 0xEB828C },
	{ 0xB3A7, 0xEB828D },
	{ 0xB3A8, 0xEB828F },
	{ 0xB3A9, 0xEB8291 },
	{ 0xB3AA, 0xEB8298 },
	{ 0xB3AB, 0xEB8299 },
	{ 0xB3AC, 0xEB829A },
	{ 0xB3AD, 0xEB829C },
	{ 0xB3AE, 0xEB829F },
	{ 0xB3AF, 0xEB82A0 },
	{ 0xB3B0, 0xEB82A1 },
	{ 0xB3B1, 0xEB82A2 },
	{ 0xB3B2, 0xEB82A8 },
	{ 0xB3B3, 0xEB82A9 },
	{ 0xB3B4, 0xEB82AB },
	{ 0xB3B5, 0xEB82AC },
	{ 0xB3B6, 0xEB82AD },
	{ 0xB3B7, 0xEB82AE },
	{ 0xB3B8, 0xEB82AF },
	{ 0xB3B9, 0xEB82B1 },
	{ 0xB3BA, 0xEB82B3 },
	{ 0xB3BB, 0xEB82B4 },
	{ 0xB3BC, 0xEB82B5 },
	{ 0xB3BD, 0xEB82B8 },
	{ 0xB3BE, 0xEB82BC },
	{ 0xB3BF, 0xEB8384 },
	{ 0xB3C0, 0xEB8385 },
	{ 0xB3C1, 0xEB8387 },
	{ 0xB3C2, 0xEB8388 },
	{ 0xB3C3, 0xEB8389 },
	{ 0xB3C4, 0xEB8390 },
	{ 0xB3C5, 0xEB8391 },
	{ 0xB3C6, 0xEB8394 },
	{ 0xB3C7, 0xEB8398 },
	{ 0xB3C8, 0xEB83A0 },
	{ 0xB3C9, 0xEB83A5 },
	{ 0xB3CA, 0xEB8488 },
	{ 0xB3CB, 0xEB8489 },
	{ 0xB3CC, 0xEB848B },
	{ 0xB3CD, 0xEB848C },
	{ 0xB3CE, 0xEB8490 },
	{ 0xB3CF, 0xEB8492 },
	{ 0xB3D0, 0xEB8493 },
	{ 0xB3D1, 0xEB8498 },
	{ 0xB3D2, 0xEB8499 },
	{ 0xB3D3, 0xEB849B },
	{ 0xB3D4, 0xEB849C },
	{ 0xB3D5, 0xEB849D },
	{ 0xB3D6, 0xEB84A3 },
	{ 0xB3D7, 0xEB84A4 },
	{ 0xB3D8, 0xEB84A5 },
	{ 0xB3D9, 0xEB84A8 },
	{ 0xB3DA, 0xEB84AC },
	{ 0xB3DB, 0xEB84B4 },
	{ 0xB3DC, 0xEB84B5 },
	{ 0xB3DD, 0xEB84B7 },
	{ 0xB3DE, 0xEB84B8 },
	{ 0xB3DF, 0xEB84B9 },
	{ 0xB3E0, 0xEB8580 },
	{ 0xB3E1, 0xEB8581 },
	{ 0xB3E2, 0xEB8584 },
	{ 0xB3E3, 0xEB8588 },
	{ 0xB3E4, 0xEB8590 },
	{ 0xB3E5, 0xEB8591 },
	{ 0xB3E6, 0xEB8594 },
	{ 0xB3E7, 0xEB8595 },
	{ 0xB3E8, 0xEB8598 },
	{ 0xB3E9, 0xEB859C },
	{ 0xB3EA, 0xEB85A0 },
	{ 0xB3EB, 0xEB85B8 },
	{ 0xB3EC, 0xEB85B9 },
	{ 0xB3ED, 0xEB85BC },
	{ 0xB3EE, 0xEB8680 },
	{ 0xB3EF, 0xEB8682 },
	{ 0xB3F0, 0xEB8688 },
	{ 0xB3F1, 0xEB8689 },
	{ 0xB3F2, 0xEB868B },
	{ 0xB3F3, 0xEB868D },
	{ 0xB3F4, 0xEB8692 },
	{ 0xB3F5, 0xEB8693 },
	{ 0xB3F6, 0xEB8694 },
	{ 0xB3F7, 0xEB8698 },
	{ 0xB3F8, 0xEB869C },
	{ 0xB3F9, 0xEB86A8 },
	{ 0xB3FA, 0xEB878C },
	{ 0xB3FB, 0xEB8790 },
	{ 0xB3FC, 0xEB8794 },
	{ 0xB3FD, 0xEB879C },
	{ 0xB3FE, 0xEB879D },
	{ 0xB4A1, 0xEB879F },
	{ 0xB4A2, 0xEB87A8 },
	{ 0xB4A3, 0xEB87A9 },
	{ 0xB4A4, 0xEB87AC },
	{ 0xB4A5, 0xEB87B0 },
	{ 0xB4A6, 0xEB87B9 },
	{ 0xB4A7, 0xEB87BB },
	{ 0xB4A8, 0xEB87BD },
	{ 0xB4A9, 0xEB8884 },
	{ 0xB4AA, 0xEB8885 },
	{ 0xB4AB, 0xEB8888 },
	{ 0xB4AC, 0xEB888B },
	{ 0xB4AD, 0xEB888C },
	{ 0xB4AE, 0xEB8894 },
	{ 0xB4AF, 0xEB8895 },
	{ 0xB4B0, 0xEB8897 },
	{ 0xB4B1, 0xEB8899 },
	{ 0xB4B2, 0xEB88A0 },
	{ 0xB4B3, 0xEB88B4 },
	{ 0xB4B4, 0xEB88BC },
	{ 0xB4B5, 0xEB8998 },
	{ 0xB4B6, 0xEB899C },
	{ 0xB4B7, 0xEB89A0 },
	{ 0xB4B8, 0xEB89A8 },
	{ 0xB4B9, 0xEB89A9 },
	{ 0xB4BA, 0xEB89B4 },
	{ 0xB4BB, 0xEB89B5 },
	{ 0xB4BC, 0xEB89BC },
	{ 0xB4BD, 0xEB8A84 },
	{ 0xB4BE, 0xEB8A85 },
	{ 0xB4BF, 0xEB8A89 },
	{ 0xB4C0, 0xEB8A90 },
	{ 0xB4C1, 0xEB8A91 },
	{ 0xB4C2, 0xEB8A94 },
	{ 0xB4C3, 0xEB8A98 },
	{ 0xB4C4, 0xEB8A99 },
	{ 0xB4C5, 0xEB8A9A },
	{ 0xB4C6, 0xEB8AA0 },
	{ 0xB4C7, 0xEB8AA1 },
	{ 0xB4C8, 0xEB8AA3 },
	{ 0xB4C9, 0xEB8AA5 },
	{ 0xB4CA, 0xEB8AA6 },
	{ 0xB4CB, 0xEB8AAA },
	{ 0xB4CC, 0xEB8AAC },
	{ 0xB4CD, 0xEB8AB0 },
	{ 0xB4CE, 0xEB8AB4 },
	{ 0xB4CF, 0xEB8B88 },
	{ 0xB4D0, 0xEB8B89 },
	{ 0xB4D1, 0xEB8B8C },
	{ 0xB4D2, 0xEB8B90 },
	{ 0xB4D3, 0xEB8B92 },
	{ 0xB4D4, 0xEB8B98 },
	{ 0xB4D5, 0xEB8B99 },
	{ 0xB4D6, 0xEB8B9B },
	{ 0xB4D7, 0xEB8B9D },
	{ 0xB4D8, 0xEB8BA2 },
	{ 0xB4D9, 0xEB8BA4 },
	{ 0xB4DA, 0xEB8BA5 },
	{ 0xB4DB, 0xEB8BA6 },
	{ 0xB4DC, 0xEB8BA8 },
	{ 0xB4DD, 0xEB8BAB },
	{ 0xB4DE, 0xEB8BAC },
	{ 0xB4DF, 0xEB8BAD },
	{ 0xB4E0, 0xEB8BAE },
	{ 0xB4E1, 0xEB8BAF },
	{ 0xB4E2, 0xEB8BB3 },
	{ 0xB4E3, 0xEB8BB4 },
	{ 0xB4E4, 0xEB8BB5 },
	{ 0xB4E5, 0xEB8BB7 },
	{ 0xB4E6, 0xEB8BB8 },
	{ 0xB4E7, 0xEB8BB9 },
	{ 0xB4E8, 0xEB8BBA },
	{ 0xB4E9, 0xEB8BBB },
	{ 0xB4EA, 0xEB8BBF },
	{ 0xB4EB, 0xEB8C80 },
	{ 0xB4EC, 0xEB8C81 },
	{ 0xB4ED, 0xEB8C84 },
	{ 0xB4EE, 0xEB8C88 },
	{ 0xB4EF, 0xEB8C90 },
	{ 0xB4F0, 0xEB8C91 },
	{ 0xB4F1, 0xEB8C93 },
	{ 0xB4F2, 0xEB8C94 },
	{ 0xB4F3, 0xEB8C95 },
	{ 0xB4F4, 0xEB8C9C },
	{ 0xB4F5, 0xEB8D94 },
	{ 0xB4F6, 0xEB8D95 },
	{ 0xB4F7, 0xEB8D96 },
	{ 0xB4F8, 0xEB8D98 },
	{ 0xB4F9, 0xEB8D9B },
	{ 0xB4FA, 0xEB8D9C },
	{ 0xB4FB, 0xEB8D9E },
	{ 0xB4FC, 0xEB8D9F },
	{ 0xB4FD, 0xEB8DA4 },
	{ 0xB4FE, 0xEB8DA5 },
	{ 0xB5A1, 0xEB8DA7 },
	{ 0xB5A2, 0xEB8DA9 },
	{ 0xB5A3, 0xEB8DAB },
	{ 0xB5A4, 0xEB8DAE },
	{ 0xB5A5, 0xEB8DB0 },
	{ 0xB5A6, 0xEB8DB1 },
	{ 0xB5A7, 0xEB8DB4 },
	{ 0xB5A8, 0xEB8DB8 },
	{ 0xB5A9, 0xEB8E80 },
	{ 0xB5AA, 0xEB8E81 },
	{ 0xB5AB, 0xEB8E83 },
	{ 0xB5AC, 0xEB8E84 },
	{ 0xB5AD, 0xEB8E85 },
	{ 0xB5AE, 0xEB8E8C },
	{ 0xB5AF, 0xEB8E90 },
	{ 0xB5B0, 0xEB8E94 },
	{ 0xB5B1, 0xEB8EA0 },
	{ 0xB5B2, 0xEB8EA1 },
	{ 0xB5B3, 0xEB8EA8 },
	{ 0xB5B4, 0xEB8EAC },
	{ 0xB5B5, 0xEB8F84 },
	{ 0xB5B6, 0xEB8F85 },
	{ 0xB5B7, 0xEB8F88 },
	{ 0xB5B8, 0xEB8F8B },
	{ 0xB5B9, 0xEB8F8C },
	{ 0xB5BA, 0xEB8F8E },
	{ 0xB5BB, 0xEB8F90 },
	{ 0xB5BC, 0xEB8F94 },
	{ 0xB5BD, 0xEB8F95 },
	{ 0xB5BE, 0xEB8F97 },
	{ 0xB5BF, 0xEB8F99 },
	{ 0xB5C0, 0xEB8F9B },
	{ 0xB5C1, 0xEB8F9D },
	{ 0xB5C2, 0xEB8FA0 },
	{ 0xB5C3, 0xEB8FA4 },
	{ 0xB5C4, 0xEB8FA8 },
	{ 0xB5C5, 0xEB8FBC },
	{ 0xB5C6, 0xEB9090 },
	{ 0xB5C7, 0xEB9098 },
	{ 0xB5C8, 0xEB909C },
	{ 0xB5C9, 0xEB90A0 },
	{ 0xB5CA, 0xEB90A8 },
	{ 0xB5CB, 0xEB90A9 },
	{ 0xB5CC, 0xEB90AB },
	{ 0xB5CD, 0xEB90B4 },
	{ 0xB5CE, 0xEB9190 },
	{ 0xB5CF, 0xEB9191 },
	{ 0xB5D0, 0xEB9194 },
	{ 0xB5D1, 0xEB9198 },
	{ 0xB5D2, 0xEB91A0 },
	{ 0xB5D3, 0xEB91A1 },
	{ 0xB5D4, 0xEB91A3 },
	{ 0xB5D5, 0xEB91A5 },
	{ 0xB5D6, 0xEB91AC },
	{ 0xB5D7, 0xEB9280 },
	{ 0xB5D8, 0xEB9288 },
	{ 0xB5D9, 0xEB929D },
	{ 0xB5DA, 0xEB92A4 },
	{ 0xB5DB, 0xEB92A8 },
	{ 0xB5DC, 0xEB92AC },
	{ 0xB5DD, 0xEB92B5 },
	{ 0xB5DE, 0xEB92B7 },
	{ 0xB5DF, 0xEB92B9 },
	{ 0xB5E0, 0xEB9380 },
	{ 0xB5E1, 0xEB9384 },
	{ 0xB5E2, 0xEB9388 },
	{ 0xB5E3, 0xEB9390 },
	{ 0xB5E4, 0xEB9395 },
	{ 0xB5E5, 0xEB939C },
	{ 0xB5E6, 0xEB939D },
	{ 0xB5E7, 0xEB93A0 },
	{ 0xB5E8, 0xEB93A3 },
	{ 0xB5E9, 0xEB93A4 },
	{ 0xB5EA, 0xEB93A6 },
	{ 0xB5EB, 0xEB93AC },
	{ 0xB5EC, 0xEB93AD },
	{ 0xB5ED, 0xEB93AF },
	{ 0xB5EE, 0xEB93B1 },
	{ 0xB5EF, 0xEB93B8 },
	{ 0xB5F0, 0xEB9494 },
	{ 0xB5F1, 0xEB9495 },
	{ 0xB5F2, 0xEB9498 },
	{ 0xB5F3, 0xEB949B },
	{ 0xB5F4, 0xEB949C },
	{ 0xB5F5, 0xEB94A4 },
	{ 0xB5F6, 0xEB94A5 },
	{ 0xB5F7, 0xEB94A7 },
	{ 0xB5F8, 0xEB94A8 },
	{ 0xB5F9, 0xEB94A9 },
	{ 0xB5FA, 0xEB94AA },
	{ 0xB5FB, 0xEB94B0 },
	{ 0xB5FC, 0xEB94B1 },
	{ 0xB5FD, 0xEB94B4 },
	{ 0xB5FE, 0xEB94B8 },
	{ 0xB6A1, 0xEB9580 },
	{ 0xB6A2, 0xEB9581 },
	{ 0xB6A3, 0xEB9583 },
	{ 0xB6A4, 0xEB9584 },
	{ 0xB6A5, 0xEB9585 },
	{ 0xB6A6, 0xEB958B },
	{ 0xB6A7, 0xEB958C },
	{ 0xB6A8, 0xEB958D },
	{ 0xB6A9, 0xEB9590 },
	{ 0xB6AA, 0xEB9594 },
	{ 0xB6AB, 0xEB959C },
	{ 0xB6AC, 0xEB959D },
	{ 0xB6AD, 0xEB959F },
	{ 0xB6AE, 0xEB95A0 },
	{ 0xB6AF, 0xEB95A1 },
	{ 0xB6B0, 0xEB96A0 },
	{ 0xB6B1, 0xEB96A1 },
	{ 0xB6B2, 0xEB96A4 },
	{ 0xB6B3, 0xEB96A8 },
	{ 0xB6B4, 0xEB96AA },
	{ 0xB6B5, 0xEB96AB },
	{ 0xB6B6, 0xEB96B0 },
	{ 0xB6B7, 0xEB96B1 },
	{ 0xB6B8, 0xEB96B3 },
	{ 0xB6B9, 0xEB96B4 },
	{ 0xB6BA, 0xEB96B5 },
	{ 0xB6BB, 0xEB96BB },
	{ 0xB6BC, 0xEB96BC },
	{ 0xB6BD, 0xEB96BD },
	{ 0xB6BE, 0xEB9780 },
	{ 0xB6BF, 0xEB9784 },
	{ 0xB6C0, 0xEB978C },
	{ 0xB6C1, 0xEB978D },
	{ 0xB6C2, 0xEB978F },
	{ 0xB6C3, 0xEB9790 },
	{ 0xB6C4, 0xEB9791 },
	{ 0xB6C5, 0xEB9798 },
	{ 0xB6C6, 0xEB97AC },
	{ 0xB6C7, 0xEB9890 },
	{ 0xB6C8, 0xEB9891 },
	{ 0xB6C9, 0xEB9894 },
	{ 0xB6CA, 0xEB9898 },
	{ 0xB6CB, 0xEB98A5 },
	{ 0xB6CC, 0xEB98AC },
	{ 0xB6CD, 0xEB98B4 },
	{ 0xB6CE, 0xEB9988 },
	{ 0xB6CF, 0xEB99A4 },
	{ 0xB6D0, 0xEB99A8 },
	{ 0xB6D1, 0xEB9A9C },
	{ 0xB6D2, 0xEB9A9D },
	{ 0xB6D3, 0xEB9AA0 },
	{ 0xB6D4, 0xEB9AA4 },
	{ 0xB6D5, 0xEB9AAB },
	{ 0xB6D6, 0xEB9AAC },
	{ 0xB6D7, 0xEB9AB1 },
	{ 0xB6D8, 0xEB9B94 },
	{ 0xB6D9, 0xEB9BB0 },
	{ 0xB6DA, 0xEB9BB4 },
	{ 0xB6DB, 0xEB9BB8 },
	{ 0xB6DC, 0xEB9C80 },
	{ 0xB6DD, 0xEB9C81 },
	{ 0xB6DE, 0xEB9C85 },
	{ 0xB6DF, 0xEB9CA8 },
	{ 0xB6E0, 0xEB9CA9 },
	{ 0xB6E1, 0xEB9CAC },
	{ 0xB6E2, 0xEB9CAF },
	{ 0xB6E3, 0xEB9CB0 },
	{ 0xB6E4, 0xEB9CB8 },
	{ 0xB6E5, 0xEB9CB9 },
	{ 0xB6E6, 0xEB9CBB },
	{ 0xB6E7, 0xEB9D84 },
	{ 0xB6E8, 0xEB9D88 },
	{ 0xB6E9, 0xEB9D8C },
	{ 0xB6EA, 0xEB9D94 },
	{ 0xB6EB, 0xEB9D95 },
	{ 0xB6EC, 0xEB9DA0 },
	{ 0xB6ED, 0xEB9DA4 },
	{ 0xB6EE, 0xEB9DA8 },
	{ 0xB6EF, 0xEB9DB0 },
	{ 0xB6F0, 0xEB9DB1 },
	{ 0xB6F1, 0xEB9DB3 },
	{ 0xB6F2, 0xEB9DB5 },
	{ 0xB6F3, 0xEB9DBC },
	{ 0xB6F4, 0xEB9DBD },
	{ 0xB6F5, 0xEB9E80 },
	{ 0xB6F6, 0xEB9E84 },
	{ 0xB6F7, 0xEB9E8C },
	{ 0xB6F8, 0xEB9E8D },
	{ 0xB6F9, 0xEB9E8F },
	{ 0xB6FA, 0xEB9E90 },
	{ 0xB6FB, 0xEB9E91 },
	{ 0xB6FC, 0xEB9E92 },
	{ 0xB6FD, 0xEB9E96 },
	{ 0xB6FE, 0xEB9E97 },
	{ 0xB7A1, 0xEB9E98 },
	{ 0xB7A2, 0xEB9E99 },
	{ 0xB7A3, 0xEB9E9C },
	{ 0xB7A4, 0xEB9EA0 },
	{ 0xB7A5, 0xEB9EA8 },
	{ 0xB7A6, 0xEB9EA9 },
	{ 0xB7A7, 0xEB9EAB },
	{ 0xB7A8, 0xEB9EAC },
	{ 0xB7A9, 0xEB9EAD },
	{ 0xB7AA, 0xEB9EB4 },
	{ 0xB7AB, 0xEB9EB5 },
	{ 0xB7AC, 0xEB9EB8 },
	{ 0xB7AD, 0xEB9F87 },
	{ 0xB7AE, 0xEB9F89 },
	{ 0xB7AF, 0xEB9FAC },
	{ 0xB7B0, 0xEB9FAD },
	{ 0xB7B1, 0xEB9FB0 },
	{ 0xB7B2, 0xEB9FB4 },
	{ 0xB7B3, 0xEB9FBC },
	{ 0xB7B4, 0xEB9FBD },
	{ 0xB7B5, 0xEB9FBF },
	{ 0xB7B6, 0xEBA080 },
	{ 0xB7B7, 0xEBA081 },
	{ 0xB7B8, 0xEBA087 },
	{ 0xB7B9, 0xEBA088 },
	{ 0xB7BA, 0xEBA089 },
	{ 0xB7BB, 0xEBA08C },
	{ 0xB7BC, 0xEBA090 },
	{ 0xB7BD, 0xEBA098 },
	{ 0xB7BE, 0xEBA099 },
	{ 0xB7BF, 0xEBA09B },
	{ 0xB7C0, 0xEBA09D },
	{ 0xB7C1, 0xEBA0A4 },
	{ 0xB7C2, 0xEBA0A5 },
	{ 0xB7C3, 0xEBA0A8 },
	{ 0xB7C4, 0xEBA0AC },
	{ 0xB7C5, 0xEBA0B4 },
	{ 0xB7C6, 0xEBA0B5 },
	{ 0xB7C7, 0xEBA0B7 },
	{ 0xB7C8, 0xEBA0B8 },
	{ 0xB7C9, 0xEBA0B9 },
	{ 0xB7CA, 0xEBA180 },
	{ 0xB7CB, 0xEBA184 },
	{ 0xB7CC, 0xEBA191 },
	{ 0xB7CD, 0xEBA193 },
	{ 0xB7CE, 0xEBA19C },
	{ 0xB7CF, 0xEBA19D },
	{ 0xB7D0, 0xEBA1A0 },
	{ 0xB7D1, 0xEBA1A4 },
	{ 0xB7D2, 0xEBA1AC },
	{ 0xB7D3, 0xEBA1AD },
	{ 0xB7D4, 0xEBA1AF },
	{ 0xB7D5, 0xEBA1B1 },
	{ 0xB7D6, 0xEBA1B8 },
	{ 0xB7D7, 0xEBA1BC },
	{ 0xB7D8, 0xEBA28D },
	{ 0xC9FA, 0xEBA294 },
	{ 0xB7D9, 0xEBA2A8 },
	{ 0xB7DA, 0xEBA2B0 },
	{ 0xB7DB, 0xEBA2B4 },
	{ 0xB7DC, 0xEBA2B8 },
	{ 0xB7DD, 0xEBA380 },
	{ 0xB7DE, 0xEBA381 },
	{ 0xB7DF, 0xEBA383 },
	{ 0xB7E0, 0xEBA385 },
	{ 0xB7E1, 0xEBA38C },
	{ 0xB7E2, 0xEBA390 },
	{ 0xB7E3, 0xEBA394 },
	{ 0xB7E4, 0xEBA39D },
	{ 0xB7E5, 0xEBA39F },
	{ 0xB7E6, 0xEBA3A1 },
	{ 0xB7E7, 0xEBA3A8 },
	{ 0xB7E8, 0xEBA3A9 },
	{ 0xB7E9, 0xEBA3AC },
	{ 0xB7EA, 0xEBA3B0 },
	{ 0xB7EB, 0xEBA3B8 },
	{ 0xB7EC, 0xEBA3B9 },
	{ 0xB7ED, 0xEBA3BB },
	{ 0xB7EE, 0xEBA3BD },
	{ 0xB7EF, 0xEBA484 },
	{ 0xB7F0, 0xEBA498 },
	{ 0xB7F1, 0xEBA4A0 },
	{ 0xB7F2, 0xEBA4BC },
	{ 0xB7F3, 0xEBA4BD },
	{ 0xB7F4, 0xEBA580 },
	{ 0xB7F5, 0xEBA584 },
	{ 0xB7F6, 0xEBA58C },
	{ 0xB7F7, 0xEBA58F },
	{ 0xB7F8, 0xEBA591 },
	{ 0xB7F9, 0xEBA598 },
	{ 0xB7FA, 0xEBA599 },
	{ 0xB7FB, 0xEBA59C },
	{ 0xB7FC, 0xEBA5A0 },
	{ 0xB7FD, 0xEBA5A8 },
	{ 0xB7FE, 0xEBA5A9 },
	{ 0xB8A1, 0xEBA5AB },
	{ 0xB8A2, 0xEBA5AD },
	{ 0xB8A3, 0xEBA5B4 },
	{ 0xB8A4, 0xEBA5B5 },
	{ 0xB8A5, 0xEBA5B8 },
	{ 0xB8A6, 0xEBA5BC },
	{ 0xB8A7, 0xEBA684 },
	{ 0xB8A8, 0xEBA685 },
	{ 0xB8A9, 0xEBA687 },
	{ 0xB8AA, 0xEBA689 },
	{ 0xB8AB, 0xEBA68A },
	{ 0xB8AC, 0xEBA68D },
	{ 0xB8AD, 0xEBA68E },
	{ 0xB8AE, 0xEBA6AC },
	{ 0xB8AF, 0xEBA6AD },
	{ 0xB8B0, 0xEBA6B0 },
	{ 0xB8B1, 0xEBA6B4 },
	{ 0xB8B2, 0xEBA6BC },
	{ 0xB8B3, 0xEBA6BD },
	{ 0xB8B4, 0xEBA6BF },
	{ 0xB8B5, 0xEBA781 },
	{ 0xB8B6, 0xEBA788 },
	{ 0xB8B7, 0xEBA789 },
	{ 0xB8B8, 0xEBA78C },
	{ 0xB8B9, 0xEBA78E },
	{ 0xB8BA, 0xEBA78F },
	{ 0xB8BB, 0xEBA790 },
	{ 0xB8BC, 0xEBA791 },
	{ 0xB8BD, 0xEBA792 },
	{ 0xB8BE, 0xEBA798 },
	{ 0xB8BF, 0xEBA799 },
	{ 0xB8C0, 0xEBA79B },
	{ 0xB8C1, 0xEBA79D },
	{ 0xB8C2, 0xEBA79E },
	{ 0xB8C3, 0xEBA7A1 },
	{ 0xB8C4, 0xEBA7A3 },
	{ 0xB8C5, 0xEBA7A4 },
	{ 0xB8C6, 0xEBA7A5 },
	{ 0xB8C7, 0xEBA7A8 },
	{ 0xB8C8, 0xEBA7AC },
	{ 0xB8C9, 0xEBA7B4 },
	{ 0xB8CA, 0xEBA7B5 },
	{ 0xB8CB, 0xEBA7B7 },
	{ 0xB8CC, 0xEBA7B8 },
	{ 0xB8CD, 0xEBA7B9 },
	{ 0xB8CE, 0xEBA7BA },
	{ 0xB8CF, 0xEBA880 },
	{ 0xB8D0, 0xEBA881 },
	{ 0xB8D1, 0xEBA888 },
	{ 0xB8D2, 0xEBA895 },
	{ 0xB8D3, 0xEBA8B8 },
	{ 0xB8D4, 0xEBA8B9 },
	{ 0xB8D5, 0xEBA8BC },
	{ 0xB8D6, 0xEBA980 },
	{ 0xB8D7, 0xEBA982 },
	{ 0xB8D8, 0xEBA988 },
	{ 0xB8D9, 0xEBA989 },
	{ 0xB8DA, 0xEBA98B },
	{ 0xB8DB, 0xEBA98D },
	{ 0xB8DC, 0xEBA98E },
	{ 0xB8DD, 0xEBA993 },
	{ 0xB8DE, 0xEBA994 },
	{ 0xB8DF, 0xEBA995 },
	{ 0xB8E0, 0xEBA998 },
	{ 0xB8E1, 0xEBA99C },
	{ 0xB8E2, 0xEBA9A4 },
	{ 0xB8E3, 0xEBA9A5 },
	{ 0xB8E4, 0xEBA9A7 },
	{ 0xB8E5, 0xEBA9A8 },
	{ 0xB8E6, 0xEBA9A9 },
	{ 0xB8E7, 0xEBA9B0 },
	{ 0xB8E8, 0xEBA9B1 },
	{ 0xB8E9, 0xEBA9B4 },
	{ 0xB8EA, 0xEBA9B8 },
	{ 0xB8EB, 0xEBAA83 },
	{ 0xB8EC, 0xEBAA84 },
	{ 0xB8ED, 0xEBAA85 },
	{ 0xB8EE, 0xEBAA87 },
	{ 0xB8EF, 0xEBAA8C },
	{ 0xB8F0, 0xEBAAA8 },
	{ 0xB8F1, 0xEBAAA9 },
	{ 0xB8F2, 0xEBAAAB },
	{ 0xB8F3, 0xEBAAAC },
	{ 0xB8F4, 0xEBAAB0 },
	{ 0xB8F5, 0xEBAAB2 },
	{ 0xB8F6, 0xEBAAB8 },
	{ 0xB8F7, 0xEBAAB9 },
	{ 0xB8F8, 0xEBAABB },
	{ 0xB8F9, 0xEBAABD },
	{ 0xB8FA, 0xEBAB84 },
	{ 0xB8FB, 0xEBAB88 },
	{ 0xB8FC, 0xEBAB98 },
	{ 0xB8FD, 0xEBAB99 },
	{ 0xB8FE, 0xEBABBC },
	{ 0xB9A1, 0xEBAC80 },
	{ 0xB9A2, 0xEBAC84 },
	{ 0xB9A3, 0xEBAC8D },
	{ 0xB9A4, 0xEBAC8F },
	{ 0xB9A5, 0xEBAC91 },
	{ 0xB9A6, 0xEBAC98 },
	{ 0xB9A7, 0xEBAC9C },
	{ 0xB9A8, 0xEBACA0 },
	{ 0xB9A9, 0xEBACA9 },
	{ 0xB9AA, 0xEBACAB },
	{ 0xB9AB, 0xEBACB4 },
	{ 0xB9AC, 0xEBACB5 },
	{ 0xB9AD, 0xEBACB6 },
	{ 0xB9AE, 0xEBACB8 },
	{ 0xB9AF, 0xEBACBB },
	{ 0xB9B0, 0xEBACBC },
	{ 0xB9B1, 0xEBACBD },
	{ 0xB9B2, 0xEBACBE },
	{ 0xB9B3, 0xEBAD84 },
	{ 0xB9B4, 0xEBAD85 },
	{ 0xB9B5, 0xEBAD87 },
	{ 0xB9B6, 0xEBAD89 },
	{ 0xB9B7, 0xEBAD8D },
	{ 0xB9B8, 0xEBAD8F },
	{ 0xB9B9, 0xEBAD90 },
	{ 0xB9BA, 0xEBAD94 },
	{ 0xB9BB, 0xEBAD98 },
	{ 0xB9BC, 0xEBADA1 },
	{ 0xB9BD, 0xEBADA3 },
	{ 0xB9BE, 0xEBADAC },
	{ 0xB9BF, 0xEBAE88 },
	{ 0xB9C0, 0xEBAE8C },
	{ 0xB9C1, 0xEBAE90 },
	{ 0xB9C2, 0xEBAEA4 },
	{ 0xB9C3, 0xEBAEA8 },
	{ 0xB9C4, 0xEBAEAC },
	{ 0xB9C5, 0xEBAEB4 },
	{ 0xB9C6, 0xEBAEB7 },
	{ 0xB9C7, 0xEBAF80 },
	{ 0xB9C8, 0xEBAF84 },
	{ 0xB9C9, 0xEBAF88 },
	{ 0xB9CA, 0xEBAF90 },
	{ 0xB9CB, 0xEBAF93 },
	{ 0xB9CC, 0xEBAFB8 },
	{ 0xB9CD, 0xEBAFB9 },
	{ 0xB9CE, 0xEBAFBC },
	{ 0xB9CF, 0xEBAFBF },
	{ 0xB9D0, 0xEBB080 },
	{ 0xB9D1, 0xEBB082 },
	{ 0xB9D2, 0xEBB088 },
	{ 0xB9D3, 0xEBB089 },
	{ 0xB9D4, 0xEBB08B },
	{ 0xB9D5, 0xEBB08C },
	{ 0xB9D6, 0xEBB08D },
	{ 0xB9D7, 0xEBB08F },
	{ 0xB9D8, 0xEBB091 },
	{ 0xB9D9, 0xEBB094 },
	{ 0xB9DA, 0xEBB095 },
	{ 0xB9DB, 0xEBB096 },
	{ 0xB9DC, 0xEBB097 },
	{ 0xB9DD, 0xEBB098 },
	{ 0xB9DE, 0xEBB09B },
	{ 0xB9DF, 0xEBB09C },
	{ 0xB9E0, 0xEBB09D },
	{ 0xB9E1, 0xEBB09E },
	{ 0xB9E2, 0xEBB09F },
	{ 0xB9E3, 0xEBB0A4 },
	{ 0xB9E4, 0xEBB0A5 },
	{ 0xB9E5, 0xEBB0A7 },
	{ 0xB9E6, 0xEBB0A9 },
	{ 0xB9E7, 0xEBB0AD },
	{ 0xB9E8, 0xEBB0B0 },
	{ 0xB9E9, 0xEBB0B1 },
	{ 0xB9EA, 0xEBB0B4 },
	{ 0xB9EB, 0xEBB0B8 },
	{ 0xB9EC, 0xEBB180 },
	{ 0xB9ED, 0xEBB181 },
	{ 0xB9EE, 0xEBB183 },
	{ 0xB9EF, 0xEBB184 },
	{ 0xB9F0, 0xEBB185 },
	{ 0xB9F1, 0xEBB189 },
	{ 0xB9F2, 0xEBB18C },
	{ 0xB9F3, 0xEBB18D },
	{ 0xB9F4, 0xEBB190 },
	{ 0xB9F5, 0xEBB19D },
	{ 0xB9F6, 0xEBB284 },
	{ 0xB9F7, 0xEBB285 },
	{ 0xB9F8, 0xEBB288 },
	{ 0xB9F9, 0xEBB28B },
	{ 0xB9FA, 0xEBB28C },
	{ 0xB9FB, 0xEBB28E },
	{ 0xB9FC, 0xEBB294 },
	{ 0xB9FD, 0xEBB295 },
	{ 0xB9FE, 0xEBB297 },
	{ 0xBAA1, 0xEBB299 },
	{ 0xBAA2, 0xEBB29A },
	{ 0xBAA3, 0xEBB2A0 },
	{ 0xBAA4, 0xEBB2A1 },
	{ 0xBAA5, 0xEBB2A4 },
	{ 0xBAA6, 0xEBB2A7 },
	{ 0xBAA7, 0xEBB2A8 },
	{ 0xBAA8, 0xEBB2B0 },
	{ 0xBAA9, 0xEBB2B1 },
	{ 0xBAAA, 0xEBB2B3 },
	{ 0xBAAB, 0xEBB2B4 },
	{ 0xBAAC, 0xEBB2B5 },
	{ 0xBAAD, 0xEBB2BC },
	{ 0xBAAE, 0xEBB2BD },
	{ 0xBAAF, 0xEBB380 },
	{ 0xBAB0, 0xEBB384 },
	{ 0xBAB1, 0xEBB38D },
	{ 0xBAB2, 0xEBB38F },
	{ 0xBAB3, 0xEBB390 },
	{ 0xBAB4, 0xEBB391 },
	{ 0xBAB5, 0xEBB395 },
	{ 0xBAB6, 0xEBB398 },
	{ 0xBAB7, 0xEBB39C },
	{ 0xBAB8, 0xEBB3B4 },
	{ 0xBAB9, 0xEBB3B5 },
	{ 0xBABA, 0xEBB3B6 },
	{ 0xBABB, 0xEBB3B8 },
	{ 0xBABC, 0xEBB3BC },
	{ 0xBABD, 0xEBB484 },
	{ 0xBABE, 0xEBB485 },
	{ 0xBABF, 0xEBB487 },
	{ 0xBAC0, 0xEBB489 },
	{ 0xBAC1, 0xEBB490 },
	{ 0xBAC2, 0xEBB494 },
	{ 0xBAC3, 0xEBB4A4 },
	{ 0xBAC4, 0xEBB4AC },
	{ 0xBAC5, 0xEBB580 },
	{ 0xBAC6, 0xEBB588 },
	{ 0xBAC7, 0xEBB589 },
	{ 0xBAC8, 0xEBB58C },
	{ 0xBAC9, 0xEBB590 },
	{ 0xBACA, 0xEBB598 },
	{ 0xBACB, 0xEBB599 },
	{ 0xBACC, 0xEBB5A4 },
	{ 0xBACD, 0xEBB5A8 },
	{ 0xBACE, 0xEBB680 },
	{ 0xBACF, 0xEBB681 },
	{ 0xBAD0, 0xEBB684 },
	{ 0xBAD1, 0xEBB687 },
	{ 0xBAD2, 0xEBB688 },
	{ 0xBAD3, 0xEBB689 },
	{ 0xBAD4, 0xEBB68A },
	{ 0xBAD5, 0xEBB690 },
	{ 0xBAD6, 0xEBB691 },
	{ 0xBAD7, 0xEBB693 },
	{ 0xBAD8, 0xEBB695 },
	{ 0xBAD9, 0xEBB699 },
	{ 0xBADA, 0xEBB69A },
	{ 0xBADB, 0xEBB69C },
	{ 0xBADC, 0xEBB6A4 },
	{ 0xBADD, 0xEBB6B0 },
	{ 0xBADE, 0xEBB6B8 },
	{ 0xBADF, 0xEBB794 },
	{ 0xBAE0, 0xEBB795 },
	{ 0xBAE1, 0xEBB798 },
	{ 0xBAE2, 0xEBB79C },
	{ 0xBAE3, 0xEBB7A9 },
	{ 0xBAE4, 0xEBB7B0 },
	{ 0xBAE5, 0xEBB7B4 },
	{ 0xBAE6, 0xEBB7B8 },
	{ 0xBAE7, 0xEBB880 },
	{ 0xBAE8, 0xEBB883 },
	{ 0xBAE9, 0xEBB885 },
	{ 0xBAEA, 0xEBB88C },
	{ 0xBAEB, 0xEBB88D },
	{ 0xBAEC, 0xEBB890 },
	{ 0xBAED, 0xEBB894 },
	{ 0xBAEE, 0xEBB89C },
	{ 0xBAEF, 0xEBB89D },
	{ 0xBAF0, 0xEBB89F },
	{ 0xBAF1, 0xEBB984 },
	{ 0xBAF2, 0xEBB985 },
	{ 0xBAF3, 0xEBB988 },
	{ 0xBAF4, 0xEBB98C },
	{ 0xBAF5, 0xEBB98E },
	{ 0xBAF6, 0xEBB994 },
	{ 0xBAF7, 0xEBB995 },
	{ 0xBAF8, 0xEBB997 },
	{ 0xBAF9, 0xEBB999 },
	{ 0xBAFA, 0xEBB99A },
	{ 0xBAFB, 0xEBB99B },
	{ 0xBAFC, 0xEBB9A0 },
	{ 0xBAFD, 0xEBB9A1 },
	{ 0xBAFE, 0xEBB9A4 },
	{ 0xBBA1, 0xEBB9A8 },
	{ 0xBBA2, 0xEBB9AA },
	{ 0xBBA3, 0xEBB9B0 },
	{ 0xBBA4, 0xEBB9B1 },
	{ 0xBBA5, 0xEBB9B3 },
	{ 0xBBA6, 0xEBB9B4 },
	{ 0xBBA7, 0xEBB9B5 },
	{ 0xBBA8, 0xEBB9BB },
	{ 0xBBA9, 0xEBB9BC },
	{ 0xBBAA, 0xEBB9BD },
	{ 0xBBAB, 0xEBBA80 },
	{ 0xBBAC, 0xEBBA84 },
	{ 0xBBAD, 0xEBBA8C },
	{ 0xBBAE, 0xEBBA8D },
	{ 0xBBAF, 0xEBBA8F },
	{ 0xBBB0, 0xEBBA90 },
	{ 0xBBB1, 0xEBBA91 },
	{ 0xBBB2, 0xEBBA98 },
	{ 0xBBB3, 0xEBBA99 },
	{ 0xBBB4, 0xEBBAA8 },
	{ 0xBBB5, 0xEBBB90 },
	{ 0xBBB6, 0xEBBB91 },
	{ 0xBBB7, 0xEBBB94 },
	{ 0xBBB8, 0xEBBB97 },
	{ 0xBBB9, 0xEBBB98 },
	{ 0xBBBA, 0xEBBBA0 },
	{ 0xBBBB, 0xEBBBA3 },
	{ 0xBBBC, 0xEBBBA4 },
	{ 0xBBBD, 0xEBBBA5 },
	{ 0xBBBE, 0xEBBBAC },
	{ 0xBBBF, 0xEBBC81 },
	{ 0xBBC0, 0xEBBC88 },
	{ 0xBBC1, 0xEBBC89 },
	{ 0xBBC2, 0xEBBC98 },
	{ 0xBBC3, 0xEBBC99 },
	{ 0xBBC4, 0xEBBC9B },
	{ 0xBBC5, 0xEBBC9C },
	{ 0xBBC6, 0xEBBC9D },
	{ 0xBBC7, 0xEBBD80 },
	{ 0xBBC8, 0xEBBD81 },
	{ 0xBBC9, 0xEBBD84 },
	{ 0xBBCA, 0xEBBD88 },
	{ 0xBBCB, 0xEBBD90 },
	{ 0xBBCC, 0xEBBD91 },
	{ 0xBBCD, 0xEBBD95 },
	{ 0xBBCE, 0xEBBE94 },
	{ 0xBBCF, 0xEBBEB0 },
	{ 0xBBD0, 0xEBBF85 },
	{ 0xBBD1, 0xEBBF8C },
	{ 0xBBD2, 0xEBBF8D },
	{ 0xBBD3, 0xEBBF90 },
	{ 0xBBD4, 0xEBBF94 },
	{ 0xBBD5, 0xEBBF9C },
	{ 0xBBD6, 0xEBBF9F },
	{ 0xBBD7, 0xEBBFA1 },
	{ 0xBBD8, 0xEC80BC },
	{ 0xBBD9, 0xEC8191 },
	{ 0xBBDA, 0xEC8198 },
	{ 0xBBDB, 0xEC819C },
	{ 0xBBDC, 0xEC81A0 },
	{ 0xBBDD, 0xEC81A8 },
	{ 0xBBDE, 0xEC81A9 },
	{ 0xBBDF, 0xEC8290 },
	{ 0xBBE0, 0xEC8291 },
	{ 0xBBE1, 0xEC8294 },
	{ 0xBBE2, 0xEC8298 },
	{ 0xBBE3, 0xEC82A0 },
	{ 0xBBE4, 0xEC82A1 },
	{ 0xBBE5, 0xEC82A3 },
	{ 0xBBE6, 0xEC82A5 },
	{ 0xBBE7, 0xEC82AC },
	{ 0xBBE8, 0xEC82AD },
	{ 0xBBE9, 0xEC82AF },
	{ 0xBBEA, 0xEC82B0 },
	{ 0xBBEB, 0xEC82B3 },
	{ 0xBBEC, 0xEC82B4 },
	{ 0xBBED, 0xEC82B5 },
	{ 0xBBEE, 0xEC82B6 },
	{ 0xBBEF, 0xEC82BC },
	{ 0xBBF0, 0xEC82BD },
	{ 0xBBF1, 0xEC82BF },
	{ 0xBBF2, 0xEC8380 },
	{ 0xBBF3, 0xEC8381 },
	{ 0xBBF4, 0xEC8385 },
	{ 0xBBF5, 0xEC8388 },
	{ 0xBBF6, 0xEC8389 },
	{ 0xBBF7, 0xEC838C },
	{ 0xBBF8, 0xEC8390 },
	{ 0xBBF9, 0xEC8398 },
	{ 0xBBFA, 0xEC8399 },
	{ 0xBBFB, 0xEC839B },
	{ 0xBBFC, 0xEC839C },
	{ 0xBBFD, 0xEC839D },
	{ 0xBBFE, 0xEC83A4 },
	{ 0xBCA1, 0xEC83A5 },
	{ 0xBCA2, 0xEC83A8 },
	{ 0xBCA3, 0xEC83AC },
	{ 0xBCA4, 0xEC83B4 },
	{ 0xBCA5, 0xEC83B5 },
	{ 0xBCA6, 0xEC83B7 },
	{ 0xBCA7, 0xEC83B9 },
	{ 0xBCA8, 0xEC8480 },
	{ 0xBCA9, 0xEC8484 },
	{ 0xBCAA, 0xEC8488 },
	{ 0xBCAB, 0xEC8490 },
	{ 0xBCAC, 0xEC8495 },
	{ 0xBCAD, 0xEC849C },
	{ 0xBCAE, 0xEC849D },
	{ 0xBCAF, 0xEC849E },
	{ 0xBCB0, 0xEC849F },
	{ 0xBCB1, 0xEC84A0 },
	{ 0xBCB2, 0xEC84A3 },
	{ 0xBCB3, 0xEC84A4 },
	{ 0xBCB4, 0xEC84A6 },
	{ 0xBCB5, 0xEC84A7 },
	{ 0xBCB6, 0xEC84AC },
	{ 0xBCB7, 0xEC84AD },
	{ 0xBCB8, 0xEC84AF },
	{ 0xBCB9, 0xEC84B0 },
	{ 0xBCBA, 0xEC84B1 },
	{ 0xBCBB, 0xEC84B6 },
	{ 0xBCBC, 0xEC84B8 },
	{ 0xBCBD, 0xEC84B9 },
	{ 0xBCBE, 0xEC84BC },
	{ 0xBCBF, 0xEC8580 },
	{ 0xBCC0, 0xEC8588 },
	{ 0xBCC1, 0xEC8589 },
	{ 0xBCC2, 0xEC858B },
	{ 0xBCC3, 0xEC858C },
	{ 0xBCC4, 0xEC858D },
	{ 0xBCC5, 0xEC8594 },
	{ 0xBCC6, 0xEC8595 },
	{ 0xBCC7, 0xEC8598 },
	{ 0xBCC8, 0xEC859C },
	{ 0xBCC9, 0xEC85A4 },
	{ 0xBCCA, 0xEC85A5 },
	{ 0xBCCB, 0xEC85A7 },
	{ 0xBCCC, 0xEC85A8 },
	{ 0xBCCD, 0xEC85A9 },
	{ 0xBCCE, 0xEC85B0 },
	{ 0xBCCF, 0xEC85B4 },
	{ 0xBCD0, 0xEC85B8 },
	{ 0xBCD1, 0xEC8685 },
	{ 0xBCD2, 0xEC868C },
	{ 0xBCD3, 0xEC868D },
	{ 0xBCD4, 0xEC868E },
	{ 0xBCD5, 0xEC8690 },
	{ 0xBCD6, 0xEC8694 },
	{ 0xBCD7, 0xEC8696 },
	{ 0xBCD8, 0xEC869C },
	{ 0xBCD9, 0xEC869D },
	{ 0xBCDA, 0xEC869F },
	{ 0xBCDB, 0xEC86A1 },
	{ 0xBCDC, 0xEC86A5 },
	{ 0xBCDD, 0xEC86A8 },
	{ 0xBCDE, 0xEC86A9 },
	{ 0xBCDF, 0xEC86AC },
	{ 0xBCE0, 0xEC86B0 },
	{ 0xBCE1, 0xEC86BD },
	{ 0xBCE2, 0xEC8784 },
	{ 0xBCE3, 0xEC8788 },
	{ 0xBCE4, 0xEC878C },
	{ 0xBCE5, 0xEC8794 },
	{ 0xBCE6, 0xEC8797 },
	{ 0xBCE7, 0xEC8798 },
	{ 0xBCE8, 0xEC87A0 },
	{ 0xBCE9, 0xEC87A4 },
	{ 0xBCEA, 0xEC87A8 },
	{ 0xBCEB, 0xEC87B0 },
	{ 0xBCEC, 0xEC87B1 },
	{ 0xBCED, 0xEC87B3 },
	{ 0xBCEE, 0xEC87BC },
	{ 0xBCEF, 0xEC87BD },
	{ 0xBCF0, 0xEC8880 },
	{ 0xBCF1, 0xEC8884 },
	{ 0xBCF2, 0xEC888C },
	{ 0xBCF3, 0xEC888D },
	{ 0xBCF4, 0xEC888F },
	{ 0xBCF5, 0xEC8891 },
	{ 0xBCF6, 0xEC8898 },
	{ 0xBCF7, 0xEC8899 },
	{ 0xBCF8, 0xEC889C },
	{ 0xBCF9, 0xEC889F },
	{ 0xBCFA, 0xEC88A0 },
	{ 0xBCFB, 0xEC88A8 },
	{ 0xBCFC, 0xEC88A9 },
	{ 0xBCFD, 0xEC88AB },
	{ 0xBCFE, 0xEC88AD },
	{ 0xBDA1, 0xEC88AF },
	{ 0xBDA2, 0xEC88B1 },
	{ 0xBDA3, 0xEC88B2 },
	{ 0xBDA4, 0xEC88B4 },
	{ 0xBDA5, 0xEC8988 },
	{ 0xBDA6, 0xEC8990 },
	{ 0xBDA7, 0xEC8991 },
	{ 0xBDA8, 0xEC8994 },
	{ 0xBDA9, 0xEC8998 },
	{ 0xBDAA, 0xEC89A0 },
	{ 0xBDAB, 0xEC89A5 },
	{ 0xBDAC, 0xEC89AC },
	{ 0xBDAD, 0xEC89AD },
	{ 0xBDAE, 0xEC89B0 },
	{ 0xBDAF, 0xEC89B4 },
	{ 0xBDB0, 0xEC89BC },
	{ 0xBDB1, 0xEC89BD },
	{ 0xBDB2, 0xEC89BF },
	{ 0xBDB3, 0xEC8A81 },
	{ 0xBDB4, 0xEC8A88 },
	{ 0xBDB5, 0xEC8A89 },
	{ 0xBDB6, 0xEC8A90 },
	{ 0xBDB7, 0xEC8A98 },
	{ 0xBDB8, 0xEC8A9B },
	{ 0xBDB9, 0xEC8A9D },
	{ 0xBDBA, 0xEC8AA4 },
	{ 0xBDBB, 0xEC8AA5 },
	{ 0xBDBC, 0xEC8AA8 },
	{ 0xBDBD, 0xEC8AAC },
	{ 0xBDBE, 0xEC8AAD },
	{ 0xBDBF, 0xEC8AB4 },
	{ 0xBDC0, 0xEC8AB5 },
	{ 0xBDC1, 0xEC8AB7 },
	{ 0xBDC2, 0xEC8AB9 },
	{ 0xBDC3, 0xEC8B9C },
	{ 0xBDC4, 0xEC8B9D },
	{ 0xBDC5, 0xEC8BA0 },
	{ 0xBDC6, 0xEC8BA3 },
	{ 0xBDC7, 0xEC8BA4 },
	{ 0xBDC8, 0xEC8BAB },
	{ 0xBDC9, 0xEC8BAC },
	{ 0xBDCA, 0xEC8BAD },
	{ 0xBDCB, 0xEC8BAF },
	{ 0xBDCC, 0xEC8BB1 },
	{ 0xBDCD, 0xEC8BB6 },
	{ 0xBDCE, 0xEC8BB8 },
	{ 0xBDCF, 0xEC8BB9 },
	{ 0xBDD0, 0xEC8BBB },
	{ 0xBDD1, 0xEC8BBC },
	{ 0xBDD2, 0xEC8C80 },
	{ 0xBDD3, 0xEC8C88 },
	{ 0xBDD4, 0xEC8C89 },
	{ 0xBDD5, 0xEC8C8C },
	{ 0xBDD6, 0xEC8C8D },
	{ 0xBDD7, 0xEC8C93 },
	{ 0xBDD8, 0xEC8C94 },
	{ 0xBDD9, 0xEC8C95 },
	{ 0xBDDA, 0xEC8C98 },
	{ 0xBDDB, 0xEC8C9C },
	{ 0xBDDC, 0xEC8CA4 },
	{ 0xBDDD, 0xEC8CA5 },
	{ 0xBDDE, 0xEC8CA8 },
	{ 0xBDDF, 0xEC8CA9 },
	{ 0xC9FB, 0xEC8CB0 },
	{ 0xBDE0, 0xEC8D85 },
	{ 0xBDE1, 0xEC8DA8 },
	{ 0xBDE2, 0xEC8DA9 },
	{ 0xBDE3, 0xEC8DAC },
	{ 0xBDE4, 0xEC8DB0 },
	{ 0xBDE5, 0xEC8DB2 },
	{ 0xBDE6, 0xEC8DB8 },
	{ 0xBDE7, 0xEC8DB9 },
	{ 0xBDE8, 0xEC8DBC },
	{ 0xBDE9, 0xEC8DBD },
	{ 0xBDEA, 0xEC8E84 },
	{ 0xBDEB, 0xEC8E88 },
	{ 0xBDEC, 0xEC8E8C },
	{ 0xC9FC, 0xEC8EBC },
	{ 0xBDED, 0xEC8F80 },
	{ 0xBDEE, 0xEC8F98 },
	{ 0xBDEF, 0xEC8F99 },
	{ 0xBDF0, 0xEC8F9C },
	{ 0xBDF1, 0xEC8F9F },
	{ 0xBDF2, 0xEC8FA0 },
	{ 0xBDF3, 0xEC8FA2 },
	{ 0xBDF4, 0xEC8FA8 },
	{ 0xBDF5, 0xEC8FA9 },
	{ 0xBDF6, 0xEC8FAD },
	{ 0xBDF7, 0xEC8FB4 },
	{ 0xBDF8, 0xEC8FB5 },
	{ 0xBDF9, 0xEC8FB8 },
	{ 0xBDFA, 0xEC9088 },
	{ 0xBDFB, 0xEC9090 },
	{ 0xBDFC, 0xEC90A4 },
	{ 0xBDFD, 0xEC90AC },
	{ 0xBDFE, 0xEC90B0 },
	{ 0xBEA1, 0xEC90B4 },
	{ 0xBEA2, 0xEC90BC },
	{ 0xBEA3, 0xEC90BD },
	{ 0xBEA4, 0xEC9188 },
	{ 0xBEA5, 0xEC91A4 },
	{ 0xBEA6, 0xEC91A5 },
	{ 0xBEA7, 0xEC91A8 },
	{ 0xBEA8, 0xEC91AC },
	{ 0xBEA9, 0xEC91B4 },
	{ 0xBEAA, 0xEC91B5 },
	{ 0xBEAB, 0xEC91B9 },
	{ 0xBEAC, 0xEC9280 },
	{ 0xBEAD, 0xEC9294 },
	{ 0xBEAE, 0xEC929C },
	{ 0xBEAF, 0xEC92B8 },
	{ 0xBEB0, 0xEC92BC },
	{ 0xC9FD, 0xEC9394 },
	{ 0xBEB1, 0xEC93A9 },
	{ 0xBEB2, 0xEC93B0 },
	{ 0xBEB3, 0xEC93B1 },
	{ 0xBEB4, 0xEC93B4 },
	{ 0xBEB5, 0xEC93B8 },
	{ 0xBEB6, 0xEC93BA },
	{ 0xBEB7, 0xEC93BF },
	{ 0xBEB8, 0xEC9480 },
	{ 0xBEB9, 0xEC9481 },
	{ 0xBEBA, 0xEC948C },
	{ 0xBEBB, 0xEC9490 },
	{ 0xBEBC, 0xEC9494 },
	{ 0xBEBD, 0xEC949C },
	{ 0xBEBE, 0xEC94A8 },
	{ 0xBEBF, 0xEC94A9 },
	{ 0xBEC0, 0xEC94AC },
	{ 0xBEC1, 0xEC94B0 },
	{ 0xBEC2, 0xEC94B8 },
	{ 0xBEC3, 0xEC94B9 },
	{ 0xBEC4, 0xEC94BB },
	{ 0xBEC5, 0xEC94BD },
	{ 0xBEC6, 0xEC9584 },
	{ 0xBEC7, 0xEC9585 },
	{ 0xBEC8, 0xEC9588 },
	{ 0xBEC9, 0xEC9589 },
	{ 0xBECA, 0xEC958A },
	{ 0xBECB, 0xEC958C },
	{ 0xBECC, 0xEC958D },
	{ 0xBECD, 0xEC958E },
	{ 0xBECE, 0xEC9593 },
	{ 0xBECF, 0xEC9594 },
	{ 0xBED0, 0xEC9595 },
	{ 0xBED1, 0xEC9597 },
	{ 0xBED2, 0xEC9598 },
	{ 0xBED3, 0xEC9599 },
	{ 0xBED4, 0xEC959D },
	{ 0xBED5, 0xEC959E },
	{ 0xBED6, 0xEC95A0 },
	{ 0xBED7, 0xEC95A1 },
	{ 0xBED8, 0xEC95A4 },
	{ 0xBED9, 0xEC95A8 },
	{ 0xBEDA, 0xEC95B0 },
	{ 0xBEDB, 0xEC95B1 },
	{ 0xBEDC, 0xEC95B3 },
	{ 0xBEDD, 0xEC95B4 },
	{ 0xBEDE, 0xEC95B5 },
	{ 0xBEDF, 0xEC95BC },
	{ 0xBEE0, 0xEC95BD },
	{ 0xBEE1, 0xEC9680 },
	{ 0xBEE2, 0xEC9684 },
	{ 0xBEE3, 0xEC9687 },
	{ 0xBEE4, 0xEC968C },
	{ 0xBEE5, 0xEC968D },
	{ 0xBEE6, 0xEC968F },
	{ 0xBEE7, 0xEC9691 },
	{ 0xBEE8, 0xEC9695 },
	{ 0xBEE9, 0xEC9697 },
	{ 0xBEEA, 0xEC9698 },
	{ 0xBEEB, 0xEC969C },
	{ 0xBEEC, 0xEC96A0 },
	{ 0xBEED, 0xEC96A9 },
	{ 0xBEEE, 0xEC96B4 },
	{ 0xBEEF, 0xEC96B5 },
	{ 0xBEF0, 0xEC96B8 },
	{ 0xBEF1, 0xEC96B9 },
	{ 0xBEF2, 0xEC96BB },
	{ 0xBEF3, 0xEC96BC },
	{ 0xBEF4, 0xEC96BD },
	{ 0xBEF5, 0xEC96BE },
	{ 0xBEF6, 0xEC9784 },
	{ 0xBEF7, 0xEC9785 },
	{ 0xBEF8, 0xEC9786 },
	{ 0xBEF9, 0xEC9787 },
	{ 0xBEFA, 0xEC9788 },
	{ 0xBEFB, 0xEC9789 },
	{ 0xBEFC, 0xEC978A },
	{ 0xBEFD, 0xEC978C },
	{ 0xBEFE, 0xEC978E },
	{ 0xBFA1, 0xEC9790 },
	{ 0xBFA2, 0xEC9791 },
	{ 0xBFA3, 0xEC9794 },
	{ 0xBFA4, 0xEC9798 },
	{ 0xBFA5, 0xEC97A0 },
	{ 0xBFA6, 0xEC97A1 },
	{ 0xBFA7, 0xEC97A3 },
	{ 0xBFA8, 0xEC97A5 },
	{ 0xBFA9, 0xEC97AC },
	{ 0xBFAA, 0xEC97AD },
	{ 0xBFAB, 0xEC97AE },
	{ 0xBFAC, 0xEC97B0 },
	{ 0xBFAD, 0xEC97B4 },
	{ 0xBFAE, 0xEC97B6 },
	{ 0xBFAF, 0xEC97B7 },
	{ 0xBFB0, 0xEC97BC },
	{ 0xBFB1, 0xEC97BD },
	{ 0xBFB2, 0xEC97BE },
	{ 0xBFB3, 0xEC97BF },
	{ 0xBFB4, 0xEC9880 },
	{ 0xBFB5, 0xEC9881 },
	{ 0xBFB6, 0xEC9885 },
	{ 0xBFB7, 0xEC9886 },
	{ 0xBFB8, 0xEC9887 },
	{ 0xBFB9, 0xEC9888 },
	{ 0xBFBA, 0xEC988C },
	{ 0xBFBB, 0xEC9890 },
	{ 0xBFBC, 0xEC9898 },
	{ 0xBFBD, 0xEC9899 },
	{ 0xBFBE, 0xEC989B },
	{ 0xBFBF, 0xEC989C },
	{ 0xBFC0, 0xEC98A4 },
	{ 0xBFC1, 0xEC98A5 },
	{ 0xBFC2, 0xEC98A8 },
	{ 0xBFC3, 0xEC98AC },
	{ 0xBFC4, 0xEC98AD },
	{ 0xBFC5, 0xEC98AE },
	{ 0xBFC6, 0xEC98B0 },
	{ 0xBFC7, 0xEC98B3 },
	{ 0xBFC8, 0xEC98B4 },
	{ 0xBFC9, 0xEC98B5 },
	{ 0xBFCA, 0xEC98B7 },
	{ 0xBFCB, 0xEC98B9 },
	{ 0xBFCC, 0xEC98BB },
	{ 0xBFCD, 0xEC9980 },
	{ 0xBFCE, 0xEC9981 },
	{ 0xBFCF, 0xEC9984 },
	{ 0xBFD0, 0xEC9988 },
	{ 0xBFD1, 0xEC9990 },
	{ 0xBFD2, 0xEC9991 },
	{ 0xBFD3, 0xEC9993 },
	{ 0xBFD4, 0xEC9994 },
	{ 0xBFD5, 0xEC9995 },
	{ 0xBFD6, 0xEC999C },
	{ 0xBFD7, 0xEC999D },
	{ 0xBFD8, 0xEC99A0 },
	{ 0xBFD9, 0xEC99AC },
	{ 0xBFDA, 0xEC99AF },
	{ 0xBFDB, 0xEC99B1 },
	{ 0xBFDC, 0xEC99B8 },
	{ 0xBFDD, 0xEC99B9 },
	{ 0xBFDE, 0xEC99BC },
	{ 0xBFDF, 0xEC9A80 },
	{ 0xBFE0, 0xEC9A88 },
	{ 0xBFE1, 0xEC9A89 },
	{ 0xBFE2, 0xEC9A8B },
	{ 0xBFE3, 0xEC9A8D },
	{ 0xBFE4, 0xEC9A94 },
	{ 0xBFE5, 0xEC9A95 },
	{ 0xBFE6, 0xEC9A98 },
	{ 0xBFE7, 0xEC9A9C },
	{ 0xBFE8, 0xEC9AA4 },
	{ 0xBFE9, 0xEC9AA5 },
	{ 0xBFEA, 0xEC9AA7 },
	{ 0xBFEB, 0xEC9AA9 },
	{ 0xBFEC, 0xEC9AB0 },
	{ 0xBFED, 0xEC9AB1 },
	{ 0xBFEE, 0xEC9AB4 },
	{ 0xBFEF, 0xEC9AB8 },
	{ 0xBFF0, 0xEC9AB9 },
	{ 0xBFF1, 0xEC9ABA },
	{ 0xBFF2, 0xEC9B80 },
	{ 0xBFF3, 0xEC9B81 },
	{ 0xBFF4, 0xEC9B83 },
	{ 0xBFF5, 0xEC9B85 },
	{ 0xBFF6, 0xEC9B8C },
	{ 0xBFF7, 0xEC9B8D },
	{ 0xBFF8, 0xEC9B90 },
	{ 0xBFF9, 0xEC9B94 },
	{ 0xBFFA, 0xEC9B9C },
	{ 0xBFFB, 0xEC9B9D },
	{ 0xBFFC, 0xEC9BA0 },
	{ 0xBFFD, 0xEC9BA1 },
	{ 0xBFFE, 0xEC9BA8 },
	{ 0xC0A1, 0xEC9BA9 },
	{ 0xC0A2, 0xEC9BAC },
	{ 0xC0A3, 0xEC9BB0 },
	{ 0xC0A4, 0xEC9BB8 },
	{ 0xC0A5, 0xEC9BB9 },
	{ 0xC0A6, 0xEC9BBD },
	{ 0xC0A7, 0xEC9C84 },
	{ 0xC0A8, 0xEC9C85 },
	{ 0xC0A9, 0xEC9C88 },
	{ 0xC0AA, 0xEC9C8C },
	{ 0xC0AB, 0xEC9C94 },
	{ 0xC0AC, 0xEC9C95 },
	{ 0xC0AD, 0xEC9C97 },
	{ 0xC0AE, 0xEC9C99 },
	{ 0xC0AF, 0xEC9CA0 },
	{ 0xC0B0, 0xEC9CA1 },
	{ 0xC0B1, 0xEC9CA4 },
	{ 0xC0B2, 0xEC9CA8 },
	{ 0xC0B3, 0xEC9CB0 },
	{ 0xC0B4, 0xEC9CB1 },
	{ 0xC0B5, 0xEC9CB3 },
	{ 0xC0B6, 0xEC9CB5 },
	{ 0xC0B7, 0xEC9CB7 },
	{ 0xC0B8, 0xEC9CBC },
	{ 0xC0B9, 0xEC9CBD },
	{ 0xC0BA, 0xEC9D80 },
	{ 0xC0BB, 0xEC9D84 },
	{ 0xC0BC, 0xEC9D8A },
	{ 0xC0BD, 0xEC9D8C },
	{ 0xC0BE, 0xEC9D8D },
	{ 0xC0BF, 0xEC9D8F },
	{ 0xC0C0, 0xEC9D91 },
	{ 0xC0C1, 0xEC9D92 },
	{ 0xC0C2, 0xEC9D93 },
	{ 0xC0C3, 0xEC9D94 },
	{ 0xC0C4, 0xEC9D95 },
	{ 0xC0C5, 0xEC9D96 },
	{ 0xC0C6, 0xEC9D97 },
	{ 0xC0C7, 0xEC9D98 },
	{ 0xC0C8, 0xEC9D9C },
	{ 0xC0C9, 0xEC9DA0 },
	{ 0xC0CA, 0xEC9DA8 },
	{ 0xC0CB, 0xEC9DAB },
	{ 0xC0CC, 0xEC9DB4 },
	{ 0xC0CD, 0xEC9DB5 },
	{ 0xC0CE, 0xEC9DB8 },
	{ 0xC0CF, 0xEC9DBC },
	{ 0xC0D0, 0xEC9DBD },
	{ 0xC0D1, 0xEC9DBE },
	{ 0xC0D2, 0xEC9E83 },
	{ 0xC0D3, 0xEC9E84 },
	{ 0xC0D4, 0xEC9E85 },
	{ 0xC0D5, 0xEC9E87 },
	{ 0xC0D6, 0xEC9E88 },
	{ 0xC0D7, 0xEC9E89 },
	{ 0xC0D8, 0xEC9E8A },
	{ 0xC0D9, 0xEC9E8E },
	{ 0xC0DA, 0xEC9E90 },
	{ 0xC0DB, 0xEC9E91 },
	{ 0xC0DC, 0xEC9E94 },
	{ 0xC0DD, 0xEC9E96 },
	{ 0xC0DE, 0xEC9E97 },
	{ 0xC0DF, 0xEC9E98 },
	{ 0xC0E0, 0xEC9E9A },
	{ 0xC0E1, 0xEC9EA0 },
	{ 0xC0E2, 0xEC9EA1 },
	{ 0xC0E3, 0xEC9EA3 },
	{ 0xC0E4, 0xEC9EA4 },
	{ 0xC0E5, 0xEC9EA5 },
	{ 0xC0E6, 0xEC9EA6 },
	{ 0xC0E7, 0xEC9EAC },
	{ 0xC0E8, 0xEC9EAD },
	{ 0xC0E9, 0xEC9EB0 },
	{ 0xC0EA, 0xEC9EB4 },
	{ 0xC0EB, 0xEC9EBC },
	{ 0xC0EC, 0xEC9EBD },
	{ 0xC0ED, 0xEC9EBF },
	{ 0xC0EE, 0xEC9F80 },
	{ 0xC0EF, 0xEC9F81 },
	{ 0xC0F0, 0xEC9F88 },
	{ 0xC0F1, 0xEC9F89 },
	{ 0xC0F2, 0xEC9F8C },
	{ 0xC0F3, 0xEC9F8E },
	{ 0xC0F4, 0xEC9F90 },
	{ 0xC0F5, 0xEC9F98 },
	{ 0xC0F6, 0xEC9F9D },
	{ 0xC0F7, 0xEC9FA4 },
	{ 0xC0F8, 0xEC9FA8 },
	{ 0xC0F9, 0xEC9FAC },
	{ 0xC0FA, 0xECA080 },
	{ 0xC0FB, 0xECA081 },
	{ 0xC0FC, 0xECA084 },
	{ 0xC0FD, 0xECA088 },
	{ 0xC0FE, 0xECA08A },
	{ 0xC1A1, 0xECA090 },
	{ 0xC1A2, 0xECA091 },
	{ 0xC1A3, 0xECA093 },
	{ 0xC1A4, 0xECA095 },
	{ 0xC1A5, 0xECA096 },
	{ 0xC1A6, 0xECA09C },
	{ 0xC1A7, 0xECA09D },
	{ 0xC1A8, 0xECA0A0 },
	{ 0xC1A9, 0xECA0A4 },
	{ 0xC1AA, 0xECA0AC },
	{ 0xC1AB, 0xECA0AD },
	{ 0xC1AC, 0xECA0AF },
	{ 0xC1AD, 0xECA0B1 },
	{ 0xC1AE, 0xECA0B8 },
	{ 0xC1AF, 0xECA0BC },
	{ 0xC1B0, 0xECA180 },
	{ 0xC1B1, 0xECA188 },
	{ 0xC1B2, 0xECA189 },
	{ 0xC1B3, 0xECA18C },
	{ 0xC1B4, 0xECA18D },
	{ 0xC1B5, 0xECA194 },
	{ 0xC1B6, 0xECA1B0 },
	{ 0xC1B7, 0xECA1B1 },
	{ 0xC1B8, 0xECA1B4 },
	{ 0xC1B9, 0xECA1B8 },
	{ 0xC1BA, 0xECA1BA },
	{ 0xC1BB, 0xECA280 },
	{ 0xC1BC, 0xECA281 },
	{ 0xC1BD, 0xECA283 },
	{ 0xC1BE, 0xECA285 },
	{ 0xC1BF, 0xECA286 },
	{ 0xC1C0, 0xECA287 },
	{ 0xC1C1, 0xECA28B },
	{ 0xC1C2, 0xECA28C },
	{ 0xC1C3, 0xECA28D },
	{ 0xC1C4, 0xECA294 },
	{ 0xC1C5, 0xECA29D },
	{ 0xC1C6, 0xECA29F },
	{ 0xC1C7, 0xECA2A1 },
	{ 0xC1C8, 0xECA2A8 },
	{ 0xC1C9, 0xECA2BC },
	{ 0xC1CA, 0xECA2BD },
	{ 0xC1CB, 0xECA384 },
	{ 0xC1CC, 0xECA388 },
	{ 0xC1CD, 0xECA38C },
	{ 0xC1CE, 0xECA394 },
	{ 0xC1CF, 0xECA395 },
	{ 0xC1D0, 0xECA397 },
	{ 0xC1D1, 0xECA399 },
	{ 0xC1D2, 0xECA3A0 },
	{ 0xC1D3, 0xECA3A1 },
	{ 0xC1D4, 0xECA3A4 },
	{ 0xC1D5, 0xECA3B5 },
	{ 0xC1D6, 0xECA3BC },
	{ 0xC1D7, 0xECA3BD },
	{ 0xC1D8, 0xECA480 },
	{ 0xC1D9, 0xECA484 },
	{ 0xC1DA, 0xECA485 },
	{ 0xC1DB, 0xECA486 },
	{ 0xC1DC, 0xECA48C },
	{ 0xC1DD, 0xECA48D },
	{ 0xC1DE, 0xECA48F },
	{ 0xC1DF, 0xECA491 },
	{ 0xC1E0, 0xECA498 },
	{ 0xC1E1, 0xECA4AC },
	{ 0xC1E2, 0xECA4B4 },
	{ 0xC1E3, 0xECA590 },
	{ 0xC1E4, 0xECA591 },
	{ 0xC1E5, 0xECA594 },
	{ 0xC1E6, 0xECA598 },
	{ 0xC1E7, 0xECA5A0 },
	{ 0xC1E8, 0xECA5A1 },
	{ 0xC1E9, 0xECA5A3 },
	{ 0xC1EA, 0xECA5AC },
	{ 0xC1EB, 0xECA5B0 },
	{ 0xC1EC, 0xECA5B4 },
	{ 0xC1ED, 0xECA5BC },
	{ 0xC1EE, 0xECA688 },
	{ 0xC1EF, 0xECA689 },
	{ 0xC1F0, 0xECA68C },
	{ 0xC1F1, 0xECA690 },
	{ 0xC1F2, 0xECA698 },
	{ 0xC1F3, 0xECA699 },
	{ 0xC1F4, 0xECA69B },
	{ 0xC1F5, 0xECA69D },
	{ 0xC1F6, 0xECA780 },
	{ 0xC1F7, 0xECA781 },
	{ 0xC1F8, 0xECA784 },
	{ 0xC1F9, 0xECA787 },
	{ 0xC1FA, 0xECA788 },
	{ 0xC1FB, 0xECA78A },
	{ 0xC1FC, 0xECA790 },
	{ 0xC1FD, 0xECA791 },
	{ 0xC1FE, 0xECA793 },
	{ 0xC2A1, 0xECA795 },
	{ 0xC2A2, 0xECA796 },
	{ 0xC2A3, 0xECA799 },
	{ 0xC2A4, 0xECA79A },
	{ 0xC2A5, 0xECA79C },
	{ 0xC2A6, 0xECA79D },
	{ 0xC2A7, 0xECA7A0 },
	{ 0xC2A8, 0xECA7A2 },
	{ 0xC2A9, 0xECA7A4 },
	{ 0xC2AA, 0xECA7A7 },
	{ 0xC2AB, 0xECA7AC },
	{ 0xC2AC, 0xECA7AD },
	{ 0xC2AD, 0xECA7AF },
	{ 0xC2AE, 0xECA7B0 },
	{ 0xC2AF, 0xECA7B1 },
	{ 0xC2B0, 0xECA7B8 },
	{ 0xC2B1, 0xECA7B9 },
	{ 0xC2B2, 0xECA7BC },
	{ 0xC2B3, 0xECA880 },
	{ 0xC2B4, 0xECA888 },
	{ 0xC2B5, 0xECA889 },
	{ 0xC2B6, 0xECA88B },
	{ 0xC2B7, 0xECA88C },
	{ 0xC2B8, 0xECA88D },
	{ 0xC2B9, 0xECA894 },
	{ 0xC2BA, 0xECA898 },
	{ 0xC2BB, 0xECA8A9 },
	{ 0xC2BC, 0xECA98C },
	{ 0xC2BD, 0xECA98D },
	{ 0xC2BE, 0xECA990 },
	{ 0xC2BF, 0xECA994 },
	{ 0xC2C0, 0xECA99C },
	{ 0xC2C1, 0xECA99D },
	{ 0xC2C2, 0xECA99F },
	{ 0xC2C3, 0xECA9A0 },
	{ 0xC2C4, 0xECA9A1 },
	{ 0xC2C5, 0xECA9A8 },
	{ 0xC2C6, 0xECA9BD },
	{ 0xC2C7, 0xECAA84 },
	{ 0xC2C8, 0xECAA98 },
	{ 0xC2C9, 0xECAABC },
	{ 0xC2CA, 0xECAABD },
	{ 0xC2CB, 0xECAB80 },
	{ 0xC2CC, 0xECAB84 },
	{ 0xC2CD, 0xECAB8C },
	{ 0xC2CE, 0xECAB8D },
	{ 0xC2CF, 0xECAB8F },
	{ 0xC2D0, 0xECAB91 },
	{ 0xC2D1, 0xECAB93 },
	{ 0xC2D2, 0xECAB98 },
	{ 0xC2D3, 0xECAB99 },
	{ 0xC2D4, 0xECABA0 },
	{ 0xC2D5, 0xECABAC },
	{ 0xC2D6, 0xECABB4 },
	{ 0xC2D7, 0xECAC88 },
	{ 0xC2D8, 0xECAC90 },
	{ 0xC2D9, 0xECAC94 },
	{ 0xC2DA, 0xECAC98 },
	{ 0xC2DB, 0xECACA0 },
	{ 0xC2DC, 0xECACA1 },
	{ 0xC9FE, 0xECACAC },
	{ 0xC2DD, 0xECAD81 },
	{ 0xC2DE, 0xECAD88 },
	{ 0xC2DF, 0xECAD89 },
	{ 0xC2E0, 0xECAD8C },
	{ 0xC2E1, 0xECAD90 },
	{ 0xC2E2, 0xECAD98 },
	{ 0xC2E3, 0xECAD99 },
	{ 0xC2E4, 0xECAD9D },
	{ 0xC2E5, 0xECADA4 },
	{ 0xC2E6, 0xECADB8 },
	{ 0xC2E7, 0xECADB9 },
	{ 0xC2E8, 0xECAE9C },
	{ 0xC2E9, 0xECAEB8 },
	{ 0xC2EA, 0xECAF94 },
	{ 0xC2EB, 0xECAFA4 },
	{ 0xC2EC, 0xECAFA7 },
	{ 0xC2ED, 0xECAFA9 },
	{ 0xC2EE, 0xECB08C },
	{ 0xC2EF, 0xECB08D },
	{ 0xC2F0, 0xECB090 },
	{ 0xC2F1, 0xECB094 },
	{ 0xC2F2, 0xECB09C },
	{ 0xC2F3, 0xECB09D },
	{ 0xC2F4, 0xECB0A1 },
	{ 0xC2F5, 0xECB0A2 },
	{ 0xC2F6, 0xECB0A7 },
	{ 0xC2F7, 0xECB0A8 },
	{ 0xC2F8, 0xECB0A9 },
	{ 0xC2F9, 0xECB0AC },
	{ 0xC2FA, 0xECB0AE },
	{ 0xC2FB, 0xECB0B0 },
	{ 0xC2FC, 0xECB0B8 },
	{ 0xC2FD, 0xECB0B9 },
	{ 0xC2FE, 0xECB0BB },
	{ 0xC3A1, 0xECB0BC },
	{ 0xC3A2, 0xECB0BD },
	{ 0xC3A3, 0xECB0BE },
	{ 0xC3A4, 0xECB184 },
	{ 0xC3A5, 0xECB185 },
	{ 0xC3A6, 0xECB188 },
	{ 0xC3A7, 0xECB18C },
	{ 0xC3A8, 0xECB194 },
	{ 0xC3A9, 0xECB195 },
	{ 0xC3AA, 0xECB197 },
	{ 0xC3AB, 0xECB198 },
	{ 0xC3AC, 0xECB199 },
	{ 0xC3AD, 0xECB1A0 },
	{ 0xC3AE, 0xECB1A4 },
	{ 0xC3AF, 0xECB1A6 },
	{ 0xC3B0, 0xECB1A8 },
	{ 0xC3B1, 0xECB1B0 },
	{ 0xC3B2, 0xECB1B5 },
	{ 0xC3B3, 0xECB298 },
	{ 0xC3B4, 0xECB299 },
	{ 0xC3B5, 0xECB29C },
	{ 0xC3B6, 0xECB2A0 },
	{ 0xC3B7, 0xECB2A8 },
	{ 0xC3B8, 0xECB2A9 },
	{ 0xC3B9, 0xECB2AB },
	{ 0xC3BA, 0xECB2AC },
	{ 0xC3BB, 0xECB2AD },
	{ 0xC3BC, 0xECB2B4 },
	{ 0xC3BD, 0xECB2B5 },
	{ 0xC3BE, 0xECB2B8 },
	{ 0xC3BF, 0xECB2BC },
	{ 0xC3C0, 0xECB384 },
	{ 0xC3C1, 0xECB385 },
	{ 0xC3C2, 0xECB387 },
	{ 0xC3C3, 0xECB389 },
	{ 0xC3C4, 0xECB390 },
	{ 0xC3C5, 0xECB394 },
	{ 0xC3C6, 0xECB3A4 },
	{ 0xC3C7, 0xECB3AC },
	{ 0xC3C8, 0xECB3B0 },
	{ 0xC3C9, 0xECB481 },
	{ 0xC3CA, 0xECB488 },
	{ 0xC3CB, 0xECB489 },
	{ 0xC3CC, 0xECB48C },
	{ 0xC3CD, 0xECB490 },
	{ 0xC3CE, 0xECB498 },
	{ 0xC3CF, 0xECB499 },
	{ 0xC3D0, 0xECB49B },
	{ 0xC3D1, 0xECB49D },
	{ 0xC3D2, 0xECB4A4 },
	{ 0xC3D3, 0xECB4A8 },
	{ 0xC3D4, 0xECB4AC },
	{ 0xC3D5, 0xECB4B9 },
	{ 0xC3D6, 0xECB59C },
	{ 0xC3D7, 0xECB5A0 },
	{ 0xC3D8, 0xECB5A4 },
	{ 0xC3D9, 0xECB5AC },
	{ 0xC3DA, 0xECB5AD },
	{ 0xC3DB, 0xECB5AF },
	{ 0xC3DC, 0xECB5B1 },
	{ 0xC3DD, 0xECB5B8 },
	{ 0xC3DE, 0xECB688 },
	{ 0xC3DF, 0xECB694 },
	{ 0xC3E0, 0xECB695 },
	{ 0xC3E1, 0xECB698 },
	{ 0xC3E2, 0xECB69C },
	{ 0xC3E3, 0xECB6A4 },
	{ 0xC3E4, 0xECB6A5 },
	{ 0xC3E5, 0xECB6A7 },
	{ 0xC3E6, 0xECB6A9 },
	{ 0xC3E7, 0xECB6B0 },
	{ 0xC3E8, 0xECB784 },
	{ 0xC3E9, 0xECB78C },
	{ 0xC3EA, 0xECB790 },
	{ 0xC3EB, 0xECB7A8 },
	{ 0xC3EC, 0xECB7AC },
	{ 0xC3ED, 0xECB7B0 },
	{ 0xC3EE, 0xECB7B8 },
	{ 0xC3EF, 0xECB7B9 },
	{ 0xC3F0, 0xECB7BB },
	{ 0xC3F1, 0xECB7BD },
	{ 0xC3F2, 0xECB884 },
	{ 0xC3F3, 0xECB888 },
	{ 0xC3F4, 0xECB88C },
	{ 0xC3F5, 0xECB894 },
	{ 0xC3F6, 0xECB899 },
	{ 0xC3F7, 0xECB8A0 },
	{ 0xC3F8, 0xECB8A1 },
	{ 0xC3F9, 0xECB8A4 },
	{ 0xC3FA, 0xECB8A8 },
	{ 0xC3FB, 0xECB8B0 },
	{ 0xC3FC, 0xECB8B1 },
	{ 0xC3FD, 0xECB8B3 },
	{ 0xC3FE, 0xECB8B5 },
	{ 0xC4A1, 0xECB998 },
	{ 0xC4A2, 0xECB999 },
	{ 0xC4A3, 0xECB99C },
	{ 0xC4A4, 0xECB99F },
	{ 0xC4A5, 0xECB9A0 },
	{ 0xC4A6, 0xECB9A1 },
	{ 0xC4A7, 0xECB9A8 },
	{ 0xC4A8, 0xECB9A9 },
	{ 0xC4A9, 0xECB9AB },
	{ 0xC4AA, 0xECB9AD },
	{ 0xC4AB, 0xECB9B4 },
	{ 0xC4AC, 0xECB9B5 },
	{ 0xC4AD, 0xECB9B8 },
	{ 0xC4AE, 0xECB9BC },
	{ 0xC4AF, 0xECBA84 },
	{ 0xC4B0, 0xECBA85 },
	{ 0xC4B1, 0xECBA87 },
	{ 0xC4B2, 0xECBA89 },
	{ 0xC4B3, 0xECBA90 },
	{ 0xC4B4, 0xECBA91 },
	{ 0xC4B5, 0xECBA94 },
	{ 0xC4B6, 0xECBA98 },
	{ 0xC4B7, 0xECBAA0 },
	{ 0xC4B8, 0xECBAA1 },
	{ 0xC4B9, 0xECBAA3 },
	{ 0xC4BA, 0xECBAA4 },
	{ 0xC4BB, 0xECBAA5 },
	{ 0xC4BC, 0xECBAAC },
	{ 0xC4BD, 0xECBAAD },
	{ 0xC4BE, 0xECBB81 },
	{ 0xC4BF, 0xECBBA4 },
	{ 0xC4C0, 0xECBBA5 },
	{ 0xC4C1, 0xECBBA8 },
	{ 0xC4C2, 0xECBBAB },
	{ 0xC4C3, 0xECBBAC },
	{ 0xC4C4, 0xECBBB4 },
	{ 0xC4C5, 0xECBBB5 },
	{ 0xC4C6, 0xECBBB7 },
	{ 0xC4C7, 0xECBBB8 },
	{ 0xC4C8, 0xECBBB9 },
	{ 0xC4C9, 0xECBC80 },
	{ 0xC4CA, 0xECBC81 },
	{ 0xC4CB, 0xECBC84 },
	{ 0xC4CC, 0xECBC88 },
	{ 0xC4CD, 0xECBC90 },
	{ 0xC4CE, 0xECBC91 },
	{ 0xC4CF, 0xECBC93 },
	{ 0xC4D0, 0xECBC95 },
	{ 0xC4D1, 0xECBC9C },
	{ 0xC4D2, 0xECBCA0 },
	{ 0xC4D3, 0xECBCA4 },
	{ 0xC4D4, 0xECBCAC },
	{ 0xC4D5, 0xECBCAD },
	{ 0xC4D6, 0xECBCAF },
	{ 0xC4D7, 0xECBCB0 },
	{ 0xC4D8, 0xECBCB1 },
	{ 0xC4D9, 0xECBCB8 },
	{ 0xC4DA, 0xECBD94 },
	{ 0xC4DB, 0xECBD95 },
	{ 0xC4DC, 0xECBD98 },
	{ 0xC4DD, 0xECBD9C },
	{ 0xC4DE, 0xECBDA4 },
	{ 0xC4DF, 0xECBDA5 },
	{ 0xC4E0, 0xECBDA7 },
	{ 0xC4E1, 0xECBDA9 },
	{ 0xC4E2, 0xECBDB0 },
	{ 0xC4E3, 0xECBDB1 },
	{ 0xC4E4, 0xECBDB4 },
	{ 0xC4E5, 0xECBDB8 },
	{ 0xC4E6, 0xECBE80 },
	{ 0xC4E7, 0xECBE85 },
	{ 0xC4E8, 0xECBE8C },
	{ 0xC4E9, 0xECBEA1 },
	{ 0xC4EA, 0xECBEA8 },
	{ 0xC4EB, 0xECBEB0 },
	{ 0xC4EC, 0xECBF84 },
	{ 0xC4ED, 0xECBFA0 },
	{ 0xC4EE, 0xECBFA1 },
	{ 0xC4EF, 0xECBFA4 },
	{ 0xC4F0, 0xECBFA8 },
	{ 0xC4F1, 0xECBFB0 },
	{ 0xC4F2, 0xECBFB1 },
	{ 0xC4F3, 0xECBFB3 },
	{ 0xC4F4, 0xECBFB5 },
	{ 0xC4F5, 0xECBFBC },
	{ 0xC4F6, 0xED8080 },
	{ 0xC4F7, 0xED8084 },
	{ 0xC4F8, 0xED8091 },
	{ 0xC4F9, 0xED8098 },
	{ 0xC4FA, 0xED80AD },
	{ 0xC4FB, 0xED80B4 },
	{ 0xC4FC, 0xED80B5 },
	{ 0xC4FD, 0xED80B8 },
	{ 0xC4FE, 0xED80BC },
	{ 0xC5A1, 0xED8184 },
	{ 0xC5A2, 0xED8185 },
	{ 0xC5A3, 0xED8187 },
	{ 0xC5A4, 0xED8189 },
	{ 0xC5A5, 0xED8190 },
	{ 0xC5A6, 0xED8194 },
	{ 0xC5A7, 0xED8198 },
	{ 0xC5A8, 0xED81A0 },
	{ 0xC5A9, 0xED81AC },
	{ 0xC5AA, 0xED81AD },
	{ 0xC5AB, 0xED81B0 },
	{ 0xC5AC, 0xED81B4 },
	{ 0xC5AD, 0xED81BC },
	{ 0xC5AE, 0xED81BD },
	{ 0xC5AF, 0xED8281 },
	{ 0xC5B0, 0xED82A4 },
	{ 0xC5B1, 0xED82A5 },
	{ 0xC5B2, 0xED82A8 },
	{ 0xC5B3, 0xED82AC },
	{ 0xC5B4, 0xED82B4 },
	{ 0xC5B5, 0xED82B5 },
	{ 0xC5B6, 0xED82B7 },
	{ 0xC5B7, 0xED82B9 },
	{ 0xC5B8, 0xED8380 },
	{ 0xC5B9, 0xED8381 },
	{ 0xC5BA, 0xED8384 },
	{ 0xC5BB, 0xED8388 },
	{ 0xC5BC, 0xED8389 },
	{ 0xC5BD, 0xED8390 },
	{ 0xC5BE, 0xED8391 },
	{ 0xC5BF, 0xED8393 },
	{ 0xC5C0, 0xED8394 },
	{ 0xC5C1, 0xED8395 },
	{ 0xC5C2, 0xED839C },
	{ 0xC5C3, 0xED839D },
	{ 0xC5C4, 0xED83A0 },
	{ 0xC5C5, 0xED83A4 },
	{ 0xC5C6, 0xED83AC },
	{ 0xC5C7, 0xED83AD },
	{ 0xC5C8, 0xED83AF },
	{ 0xC5C9, 0xED83B0 },
	{ 0xC5CA, 0xED83B1 },
	{ 0xC5CB, 0xED83B8 },
	{ 0xC5CC, 0xED848D },
	{ 0xC5CD, 0xED84B0 },
	{ 0xC5CE, 0xED84B1 },
	{ 0xC5CF, 0xED84B4 },
	{ 0xC5D0, 0xED84B8 },
	{ 0xC5D1, 0xED84BA },
	{ 0xC5D2, 0xED8580 },
	{ 0xC5D3, 0xED8581 },
	{ 0xC5D4, 0xED8583 },
	{ 0xC5D5, 0xED8584 },
	{ 0xC5D6, 0xED8585 },
	{ 0xC5D7, 0xED858C },
	{ 0xC5D8, 0xED858D },
	{ 0xC5D9, 0xED8590 },
	{ 0xC5DA, 0xED8594 },
	{ 0xC5DB, 0xED859C },
	{ 0xC5DC, 0xED859D },
	{ 0xC5DD, 0xED859F },
	{ 0xC5DE, 0xED85A1 },
	{ 0xC5DF, 0xED85A8 },
	{ 0xC5E0, 0xED85AC },
	{ 0xC5E1, 0xED85BC },
	{ 0xC5E2, 0xED8684 },
	{ 0xC5E3, 0xED8688 },
	{ 0xC5E4, 0xED86A0 },
	{ 0xC5E5, 0xED86A1 },
	{ 0xC5E6, 0xED86A4 },
	{ 0xC5E7, 0xED86A8 },
	{ 0xC5E8, 0xED86B0 },
	{ 0xC5E9, 0xED86B1 },
	{ 0xC5EA, 0xED86B3 },
	{ 0xC5EB, 0xED86B5 },
	{ 0xC5EC, 0xED86BA },
	{ 0xC5ED, 0xED86BC },
	{ 0xC5EE, 0xED8780 },
	{ 0xC5EF, 0xED8798 },
	{ 0xC5F0, 0xED87B4 },
	{ 0xC5F1, 0xED87B8 },
	{ 0xC5F2, 0xED8887 },
	{ 0xC5F3, 0xED8889 },
	{ 0xC5F4, 0xED8890 },
	{ 0xC5F5, 0xED88AC },
	{ 0xC5F6, 0xED88AD },
	{ 0xC5F7, 0xED88B0 },
	{ 0xC5F8, 0xED88B4 },
	{ 0xC5F9, 0xED88BC },
	{ 0xC5FA, 0xED88BD },
	{ 0xC5FB, 0xED88BF },
	{ 0xC5FC, 0xED8981 },
	{ 0xC5FD, 0xED8988 },
	{ 0xC5FE, 0xED899C },
	{ 0xC6A1, 0xED89A4 },
	{ 0xC6A2, 0xED8A80 },
	{ 0xC6A3, 0xED8A81 },
	{ 0xC6A4, 0xED8A84 },
	{ 0xC6A5, 0xED8A88 },
	{ 0xC6A6, 0xED8A90 },
	{ 0xC6A7, 0xED8A91 },
	{ 0xC6A8, 0xED8A95 },
	{ 0xC6A9, 0xED8A9C },
	{ 0xC6AA, 0xED8AA0 },
	{ 0xC6AB, 0xED8AA4 },
	{ 0xC6AC, 0xED8AAC },
	{ 0xC6AD, 0xED8AB1 },
	{ 0xC6AE, 0xED8AB8 },
	{ 0xC6AF, 0xED8AB9 },
	{ 0xC6B0, 0xED8ABC },
	{ 0xC6B1, 0xED8ABF },
	{ 0xC6B2, 0xED8B80 },
	{ 0xC6B3, 0xED8B82 },
	{ 0xC6B4, 0xED8B88 },
	{ 0xC6B5, 0xED8B89 },
	{ 0xC6B6, 0xED8B8B },
	{ 0xC6B7, 0xED8B94 },
	{ 0xC6B8, 0xED8B98 },
	{ 0xC6B9, 0xED8B9C },
	{ 0xC6BA, 0xED8BA4 },
	{ 0xC6BB, 0xED8BA5 },
	{ 0xC6BC, 0xED8BB0 },
	{ 0xC6BD, 0xED8BB1 },
	{ 0xC6BE, 0xED8BB4 },
	{ 0xC6BF, 0xED8BB8 },
	{ 0xC6C0, 0xED8C80 },
	{ 0xC6C1, 0xED8C81 },
	{ 0xC6C2, 0xED8C83 },
	{ 0xC6C3, 0xED8C85 },
	{ 0xC6C4, 0xED8C8C },
	{ 0xC6C5, 0xED8C8D },
	{ 0xC6C6, 0xED8C8E },
	{ 0xC6C7, 0xED8C90 },
	{ 0xC6C8, 0xED8C94 },
	{ 0xC6C9, 0xED8C96 },
	{ 0xC6CA, 0xED8C9C },
	{ 0xC6CB, 0xED8C9D },
	{ 0xC6CC, 0xED8C9F },
	{ 0xC6CD, 0xED8CA0 },
	{ 0xC6CE, 0xED8CA1 },
	{ 0xC6CF, 0xED8CA5 },
	{ 0xC6D0, 0xED8CA8 },
	{ 0xC6D1, 0xED8CA9 },
	{ 0xC6D2, 0xED8CAC },
	{ 0xC6D3, 0xED8CB0 },
	{ 0xC6D4, 0xED8CB8 },
	{ 0xC6D5, 0xED8CB9 },
	{ 0xC6D6, 0xED8CBB },
	{ 0xC6D7, 0xED8CBC },
	{ 0xC6D8, 0xED8CBD },
	{ 0xC6D9, 0xED8D84 },
	{ 0xC6DA, 0xED8D85 },
	{ 0xC6DB, 0xED8DBC },
	{ 0xC6DC, 0xED8DBD },
	{ 0xC6DD, 0xED8E80 },
	{ 0xC6DE, 0xED8E84 },
	{ 0xC6DF, 0xED8E8C },
	{ 0xC6E0, 0xED8E8D },
	{ 0xC6E1, 0xED8E8F },
	{ 0xC6E2, 0xED8E90 },
	{ 0xC6E3, 0xED8E91 },
	{ 0xC6E4, 0xED8E98 },
	{ 0xC6E5, 0xED8E99 },
	{ 0xC6E6, 0xED8E9C },
	{ 0xC6E7, 0xED8EA0 },
	{ 0xC6E8, 0xED8EA8 },
	{ 0xC6E9, 0xED8EA9 },
	{ 0xC6EA, 0xED8EAB },
	{ 0xC6EB, 0xED8EAD },
	{ 0xC6EC, 0xED8EB4 },
	{ 0xC6ED, 0xED8EB8 },
	{ 0xC6EE, 0xED8EBC },
	{ 0xC6EF, 0xED8F84 },
	{ 0xC6F0, 0xED8F85 },
	{ 0xC6F1, 0xED8F88 },
	{ 0xC6F2, 0xED8F89 },
	{ 0xC6F3, 0xED8F90 },
	{ 0xC6F4, 0xED8F98 },
	{ 0xC6F5, 0xED8FA1 },
	{ 0xC6F6, 0xED8FA3 },
	{ 0xC6F7, 0xED8FAC },
	{ 0xC6F8, 0xED8FAD },
	{ 0xC6F9, 0xED8FB0 },
	{ 0xC6FA, 0xED8FB4 },
	{ 0xC6FB, 0xED8FBC },
	{ 0xC6FC, 0xED8FBD },
	{ 0xC6FD, 0xED8FBF },
	{ 0xC6FE, 0xED9081 },
	{ 0xC7A1, 0xED9088 },
	{ 0xC7A2, 0xED909D },
	{ 0xC7A3, 0xED9180 },
	{ 0xC7A4, 0xED9184 },
	{ 0xC7A5, 0xED919C },
	{ 0xC7A6, 0xED91A0 },
	{ 0xC7A7, 0xED91A4 },
	{ 0xC7A8, 0xED91AD },
	{ 0xC7A9, 0xED91AF },
	{ 0xC7AA, 0xED91B8 },
	{ 0xC7AB, 0xED91B9 },
	{ 0xC7AC, 0xED91BC },
	{ 0xC7AD, 0xED91BF },
	{ 0xC7AE, 0xED9280 },
	{ 0xC7AF, 0xED9282 },
	{ 0xC7B0, 0xED9288 },
	{ 0xC7B1, 0xED9289 },
	{ 0xC7B2, 0xED928B },
	{ 0xC7B3, 0xED928D },
	{ 0xC7B4, 0xED9294 },
	{ 0xC7B5, 0xED92A9 },
	{ 0xC7B6, 0xED938C },
	{ 0xC7B7, 0xED9390 },
	{ 0xC7B8, 0xED9394 },
	{ 0xC7B9, 0xED939C },
	{ 0xC7BA, 0xED939F },
	{ 0xC7BB, 0xED93A8 },
	{ 0xC7BC, 0xED93AC },
	{ 0xC7BD, 0xED93B0 },
	{ 0xC7BE, 0xED93B8 },
	{ 0xC7BF, 0xED93BB },
	{ 0xC7C0, 0xED93BD },
	{ 0xC7C1, 0xED9484 },
	{ 0xC7C2, 0xED9488 },
	{ 0xC7C3, 0xED948C },
	{ 0xC7C4, 0xED9494 },
	{ 0xC7C5, 0xED9495 },
	{ 0xC7C6, 0xED9497 },
	{ 0xC7C7, 0xED94BC },
	{ 0xC7C8, 0xED94BD },
	{ 0xC7C9, 0xED9580 },
	{ 0xC7CA, 0xED9584 },
	{ 0xC7CB, 0xED958C },
	{ 0xC7CC, 0xED958D },
	{ 0xC7CD, 0xED958F },
	{ 0xC7CE, 0xED9591 },
	{ 0xC7CF, 0xED9598 },
	{ 0xC7D0, 0xED9599 },
	{ 0xC7D1, 0xED959C },
	{ 0xC7D2, 0xED95A0 },
	{ 0xC7D3, 0xED95A5 },
	{ 0xC7D4, 0xED95A8 },
	{ 0xC7D5, 0xED95A9 },
	{ 0xC7D6, 0xED95AB },
	{ 0xC7D7, 0xED95AD },
	{ 0xC7D8, 0xED95B4 },
	{ 0xC7D9, 0xED95B5 },
	{ 0xC7DA, 0xED95B8 },
	{ 0xC7DB, 0xED95BC },
	{ 0xC7DC, 0xED9684 },
	{ 0xC7DD, 0xED9685 },
	{ 0xC7DE, 0xED9687 },
	{ 0xC7DF, 0xED9688 },
	{ 0xC7E0, 0xED9689 },
	{ 0xC7E1, 0xED9690 },
	{ 0xC7E2, 0xED96A5 },
	{ 0xC7E3, 0xED9788 },
	{ 0xC7E4, 0xED9789 },
	{ 0xC7E5, 0xED978C },
	{ 0xC7E6, 0xED9790 },
	{ 0xC7E7, 0xED9792 },
	{ 0xC7E8, 0xED9798 },
	{ 0xC7E9, 0xED9799 },
	{ 0xC7EA, 0xED979B },
	{ 0xC7EB, 0xED979D },
	{ 0xC7EC, 0xED97A4 },
	{ 0xC7ED, 0xED97A5 },
	{ 0xC7EE, 0xED97A8 },
	{ 0xC7EF, 0xED97AC },
	{ 0xC7F0, 0xED97B4 },
	{ 0xC7F1, 0xED97B5 },
	{ 0xC7F2, 0xED97B7 },
	{ 0xC7F3, 0xED97B9 },
	{ 0xC7F4, 0xED9880 },
	{ 0xC7F5, 0xED9881 },
	{ 0xC7F6, 0xED9884 },
	{ 0xC7F7, 0xED9888 },
	{ 0xC7F8, 0xED9890 },
	{ 0xC7F9, 0xED9891 },
	{ 0xC7FA, 0xED9893 },
	{ 0xC7FB, 0xED9894 },
	{ 0xC7FC, 0xED9895 },
	{ 0xC7FD, 0xED989C },
	{ 0xC7FE, 0xED98A0 },
	{ 0xC8A1, 0xED98A4 },
	{ 0xC8A2, 0xED98AD },
	{ 0xC8A3, 0xED98B8 },
	{ 0xC8A4, 0xED98B9 },
	{ 0xC8A5, 0xED98BC },
	{ 0xC8A6, 0xED9980 },
	{ 0xC8A7, 0xED9985 },
	{ 0xC8A8, 0xED9988 },
	{ 0xC8A9, 0xED9989 },
	{ 0xC8AA, 0xED998B },
	{ 0xC8AB, 0xED998D },
	{ 0xC8AC, 0xED9991 },
	{ 0xC8AD, 0xED9994 },
	{ 0xC8AE, 0xED9995 },
	{ 0xC8AF, 0xED9998 },
	{ 0xC8B0, 0xED999C },
	{ 0xC8B1, 0xED99A7 },
	{ 0xC8B2, 0xED99A9 },
	{ 0xC8B3, 0xED99B0 },
	{ 0xC8B4, 0xED99B1 },
	{ 0xC8B5, 0xED99B4 },
	{ 0xC8B6, 0xED9A83 },
	{ 0xC8B7, 0xED9A85 },
	{ 0xC8B8, 0xED9A8C },
	{ 0xC8B9, 0xED9A8D },
	{ 0xC8BA, 0xED9A90 },
	{ 0xC8BB, 0xED9A94 },
	{ 0xC8BC, 0xED9A9D },
	{ 0xC8BD, 0xED9A9F },
	{ 0xC8BE, 0xED9AA1 },
	{ 0xC8BF, 0xED9AA8 },
	{ 0xC8C0, 0xED9AAC },
	{ 0xC8C1, 0xED9AB0 },
	{ 0xC8C2, 0xED9AB9 },
	{ 0xC8C3, 0xED9ABB },
	{ 0xC8C4, 0xED9B84 },
	{ 0xC8C5, 0xED9B85 },
	{ 0xC8C6, 0xED9B88 },
	{ 0xC8C7, 0xED9B8C },
	{ 0xC8C8, 0xED9B91 },
	{ 0xC8C9, 0xED9B94 },
	{ 0xC8CA, 0xED9B97 },
	{ 0xC8CB, 0xED9B99 },
	{ 0xC8CC, 0xED9BA0 },
	{ 0xC8CD, 0xED9BA4 },
	{ 0xC8CE, 0xED9BA8 },
	{ 0xC8CF, 0xED9BB0 },
	{ 0xC8D0, 0xED9BB5 },
	{ 0xC8D1, 0xED9BBC },
	{ 0xC8D2, 0xED9BBD },
	{ 0xC8D3, 0xED9C80 },
	{ 0xC8D4, 0xED9C84 },
	{ 0xC8D5, 0xED9C91 },
	{ 0xC8D6, 0xED9C98 },
	{ 0xC8D7, 0xED9C99 },
	{ 0xC8D8, 0xED9C9C },
	{ 0xC8D9, 0xED9CA0 },
	{ 0xC8DA, 0xED9CA8 },
	{ 0xC8DB, 0xED9CA9 },
	{ 0xC8DC, 0xED9CAB },
	{ 0xC8DD, 0xED9CAD },
	{ 0xC8DE, 0xED9CB4 },
	{ 0xC8DF, 0xED9CB5 },
	{ 0xC8E0, 0xED9CB8 },
	{ 0xC8E1, 0xED9CBC },
	{ 0xC8E2, 0xED9D84 },
	{ 0xC8E3, 0xED9D87 },
	{ 0xC8E4, 0xED9D89 },
	{ 0xC8E5, 0xED9D90 },
	{ 0xC8E6, 0xED9D91 },
	{ 0xC8E7, 0xED9D94 },
	{ 0xC8E8, 0xED9D96 },
	{ 0xC8E9, 0xED9D97 },
	{ 0xC8EA, 0xED9D98 },
	{ 0xC8EB, 0xED9D99 },
	{ 0xC8EC, 0xED9DA0 },
	{ 0xC8ED, 0xED9DA1 },
	{ 0xC8EE, 0xED9DA3 },
	{ 0xC8EF, 0xED9DA5 },
	{ 0xC8F0, 0xED9DA9 },
	{ 0xC8F1, 0xED9DAC },
	{ 0xC8F2, 0xED9DB0 },
	{ 0xC8F3, 0xED9DB4 },
	{ 0xC8F4, 0xED9DBC },
	{ 0xC8F5, 0xED9DBD },
	{ 0xC8F6, 0xED9E81 },
	{ 0xC8F7, 0xED9E88 },
	{ 0xC8F8, 0xED9E89 },
	{ 0xC8F9, 0xED9E8C },
	{ 0xC8FA, 0xED9E90 },
	{ 0xC8FB, 0xED9E98 },
	{ 0xC8FC, 0xED9E99 },
	{ 0xC8FD, 0xED9E9B },
	{ 0xC8FE, 0xED9E9D },
	{ 0xCBD0, 0xEFA480 },
	{ 0xCBD6, 0xEFA481 },
	{ 0xCBE7, 0xEFA482 },
	{ 0xCDCF, 0xEFA483 },
	{ 0xCDE8, 0xEFA484 },
	{ 0xCEAD, 0xEFA485 },
	{ 0xCFFB, 0xEFA486 },
	{ 0xD0A2, 0xEFA487 },
	{ 0xD0B8, 0xEFA488 },
	{ 0xD0D0, 0xEFA489 },
	{ 0xD0DD, 0xEFA48A },
	{ 0xD1D4, 0xEFA48B },
	{ 0xD1D5, 0xEFA48C },
	{ 0xD1D8, 0xEFA48D },
	{ 0xD1DB, 0xEFA48E },
	{ 0xD1DC, 0xEFA48F },
	{ 0xD1DD, 0xEFA490 },
	{ 0xD1DE, 0xEFA491 },
	{ 0xD1DF, 0xEFA492 },
	{ 0xD1E0, 0xEFA493 },
	{ 0xD1E2, 0xEFA494 },
	{ 0xD1E3, 0xEFA495 },
	{ 0xD1E4, 0xEFA496 },
	{ 0xD1E5, 0xEFA497 },
	{ 0xD1E6, 0xEFA498 },
	{ 0xD1E8, 0xEFA499 },
	{ 0xD1E9, 0xEFA49A },
	{ 0xD1EA, 0xEFA49B },
	{ 0xD1EB, 0xEFA49C },
	{ 0xD1ED, 0xEFA49D },
	{ 0xD1EF, 0xEFA49E },
	{ 0xD1F0, 0xEFA49F },
	{ 0xD1F2, 0xEFA4A0 },
	{ 0xD1F6, 0xEFA4A1 },
	{ 0xD1FA, 0xEFA4A2 },
	{ 0xD1FC, 0xEFA4A3 },
	{ 0xD1FD, 0xEFA4A4 },
	{ 0xD1FE, 0xEFA4A5 },
	{ 0xD2A2, 0xEFA4A6 },
	{ 0xD2A3, 0xEFA4A7 },
	{ 0xD2A7, 0xEFA4A8 },
	{ 0xD2A8, 0xEFA4A9 },
	{ 0xD2A9, 0xEFA4AA },
	{ 0xD2AA, 0xEFA4AB },
	{ 0xD2AB, 0xEFA4AC },
	{ 0xD2AD, 0xEFA4AD },
	{ 0xD2B2, 0xEFA4AE },
	{ 0xD2BE, 0xEFA4AF },
	{ 0xD2C2, 0xEFA4B0 },
	{ 0xD2C3, 0xEFA4B1 },
	{ 0xD2C4, 0xEFA4B2 },
	{ 0xD2C6, 0xEFA4B3 },
	{ 0xD2C7, 0xEFA4B4 },
	{ 0xD2C8, 0xEFA4B5 },
	{ 0xD2C9, 0xEFA4B6 },
	{ 0xD2CA, 0xEFA4B7 },
	{ 0xD2CB, 0xEFA4B8 },
	{ 0xD2CD, 0xEFA4B9 },
	{ 0xD2CE, 0xEFA4BA },
	{ 0xD2CF, 0xEFA4BB },
	{ 0xD2D0, 0xEFA4BC },
	{ 0xD2D1, 0xEFA4BD },
	{ 0xD2D2, 0xEFA4BE },
	{ 0xD2D3, 0xEFA4BF },
	{ 0xD2D4, 0xEFA580 },
	{ 0xD2D5, 0xEFA581 },
	{ 0xD2D6, 0xEFA582 },
	{ 0xD2D7, 0xEFA583 },
	{ 0xD2D9, 0xEFA584 },
	{ 0xD2DA, 0xEFA585 },
	{ 0xD2DE, 0xEFA586 },
	{ 0xD2DF, 0xEFA587 },
	{ 0xD2E1, 0xEFA588 },
	{ 0xD2E2, 0xEFA589 },
	{ 0xD2E4, 0xEFA58A },
	{ 0xD2E5, 0xEFA58B },
	{ 0xD2E6, 0xEFA58C },
	{ 0xD2E7, 0xEFA58D },
	{ 0xD2E8, 0xEFA58E },
	{ 0xD2E9, 0xEFA58F },
	{ 0xD2EA, 0xEFA590 },
	{ 0xD2EB, 0xEFA591 },
	{ 0xD2F0, 0xEFA592 },
	{ 0xD2F1, 0xEFA593 },
	{ 0xD2F2, 0xEFA594 },
	{ 0xD2F3, 0xEFA595 },
	{ 0xD2F4, 0xEFA596 },
	{ 0xD2F5, 0xEFA597 },
	{ 0xD2F7, 0xEFA598 },
	{ 0xD2F8, 0xEFA599 },
	{ 0xD4E6, 0xEFA59A },
	{ 0xD4FC, 0xEFA59B },
	{ 0xD5A5, 0xEFA59C },
	{ 0xD5AB, 0xEFA59D },
	{ 0xD5AE, 0xEFA59E },
	{ 0xD6B8, 0xEFA59F },
	{ 0xD6CD, 0xEFA5A0 },
	{ 0xD7CB, 0xEFA5A1 },
	{ 0xD7E4, 0xEFA5A2 },
	{ 0xDBC5, 0xEFA5A3 },
	{ 0xDBE4, 0xEFA5A4 },
	{ 0xDCA5, 0xEFA5A5 },
	{ 0xDDA5, 0xEFA5A6 },
	{ 0xDDD5, 0xEFA5A7 },
	{ 0xDDF4, 0xEFA5A8 },
	{ 0xDEFC, 0xEFA5A9 },
	{ 0xDEFE, 0xEFA5AA },
	{ 0xDFB3, 0xEFA5AB },
	{ 0xDFE1, 0xEFA5AC },
	{ 0xDFE8, 0xEFA5AD },
	{ 0xE0F1, 0xEFA5AE },
	{ 0xE1AD, 0xEFA5AF },
	{ 0xE1ED, 0xEFA5B0 },
	{ 0xE3F5, 0xEFA5B1 },
	{ 0xE4A1, 0xEFA5B2 },
	{ 0xE4A9, 0xEFA5B3 },
	{ 0xE5AE, 0xEFA5B4 },
	{ 0xE5B1, 0xEFA5B5 },
	{ 0xE5B2, 0xEFA5B6 },
	{ 0xE5B9, 0xEFA5B7 },
	{ 0xE5BB, 0xEFA5B8 },
	{ 0xE5BC, 0xEFA5B9 },
	{ 0xE5C4, 0xEFA5BA },
	{ 0xE5CE, 0xEFA5BB },
	{ 0xE5D0, 0xEFA5BC },
	{ 0xE5D2, 0xEFA5BD },
	{ 0xE5D6, 0xEFA5BE },
	{ 0xE5FA, 0xEFA5BF },
	{ 0xE5FB, 0xEFA680 },
	{ 0xE5FC, 0xEFA681 },
	{ 0xE5FE, 0xEFA682 },
	{ 0xE6A1, 0xEFA683 },
	{ 0xE6A4, 0xEFA684 },
	{ 0xE6A7, 0xEFA685 },
	{ 0xE6AD, 0xEFA686 },
	{ 0xE6AF, 0xEFA687 },
	{ 0xE6B0, 0xEFA688 },
	{ 0xE6B1, 0xEFA689 },
	{ 0xE6B3, 0xEFA68A },
	{ 0xE6B7, 0xEFA68B },
	{ 0xE6B8, 0xEFA68C },
	{ 0xE6BC, 0xEFA68D },
	{ 0xE6C4, 0xEFA68E },
	{ 0xE6C6, 0xEFA68F },
	{ 0xE6C7, 0xEFA690 },
	{ 0xE6CA, 0xEFA691 },
	{ 0xE6D2, 0xEFA692 },
	{ 0xE6D6, 0xEFA693 },
	{ 0xE6D9, 0xEFA694 },
	{ 0xE6DC, 0xEFA695 },
	{ 0xE6DF, 0xEFA696 },
	{ 0xE6E1, 0xEFA697 },
	{ 0xE6E4, 0xEFA698 },
	{ 0xE6E5, 0xEFA699 },
	{ 0xE6E6, 0xEFA69A },
	{ 0xE6E8, 0xEFA69B },
	{ 0xE6EA, 0xEFA69C },
	{ 0xE6EB, 0xEFA69D },
	{ 0xE6EC, 0xEFA69E },
	{ 0xE6EF, 0xEFA69F },
	{ 0xE6F1, 0xEFA6A0 },
	{ 0xE6F2, 0xEFA6A1 },
	{ 0xE6F5, 0xEFA6A2 },
	{ 0xE6F6, 0xEFA6A3 },
	{ 0xE6F7, 0xEFA6A4 },
	{ 0xE6F9, 0xEFA6A5 },
	{ 0xE7A1, 0xEFA6A6 },
	{ 0xE7A6, 0xEFA6A7 },
	{ 0xE7A9, 0xEFA6A8 },
	{ 0xE7AA, 0xEFA6A9 },
	{ 0xE7AC, 0xEFA6AA },
	{ 0xE7AD, 0xEFA6AB },
	{ 0xE7B0, 0xEFA6AC },
	{ 0xE7BF, 0xEFA6AD },
	{ 0xE7C1, 0xEFA6AE },
	{ 0xE7C6, 0xEFA6AF },
	{ 0xE7C7, 0xEFA6B0 },
	{ 0xE7CB, 0xEFA6B1 },
	{ 0xE7CD, 0xEFA6B2 },
	{ 0xE7CF, 0xEFA6B3 },
	{ 0xE7D0, 0xEFA6B4 },
	{ 0xE7D3, 0xEFA6B5 },
	{ 0xE7DF, 0xEFA6B6 },
	{ 0xE7E4, 0xEFA6B7 },
	{ 0xE7E6, 0xEFA6B8 },
	{ 0xE7F7, 0xEFA6B9 },
	{ 0xE8E7, 0xEFA6BA },
	{ 0xE8E8, 0xEFA6BB },
	{ 0xE8F0, 0xEFA6BC },
	{ 0xE8F1, 0xEFA6BD },
	{ 0xE8F7, 0xEFA6BE },
	{ 0xE8F9, 0xEFA6BF },
	{ 0xE8FB, 0xEFA780 },
	{ 0xE8FE, 0xEFA781 },
	{ 0xE9A7, 0xEFA782 },
	{ 0xE9AC, 0xEFA783 },
	{ 0xE9CC, 0xEFA784 },
	{ 0xE9F7, 0xEFA785 },
	{ 0xEAC1, 0xEFA786 },
	{ 0xEAE5, 0xEFA787 },
	{ 0xEAF4, 0xEFA788 },
	{ 0xEAF7, 0xEFA789 },
	{ 0xEAFC, 0xEFA78A },
	{ 0xEAFE, 0xEFA78B },
	{ 0xEBA4, 0xEFA78C },
	{ 0xEBA7, 0xEFA78D },
	{ 0xEBA9, 0xEFA78E },
	{ 0xEBAA, 0xEFA78F },
	{ 0xEBBA, 0xEFA790 },
	{ 0xEBBB, 0xEFA791 },
	{ 0xEBBD, 0xEFA792 },
	{ 0xEBC1, 0xEFA793 },
	{ 0xEBC2, 0xEFA794 },
	{ 0xEBC6, 0xEFA795 },
	{ 0xEBC7, 0xEFA796 },
	{ 0xEBCC, 0xEFA797 },
	{ 0xEBCF, 0xEFA798 },
	{ 0xEBD0, 0xEFA799 },
	{ 0xEBD1, 0xEFA79A },
	{ 0xEBD2, 0xEFA79B },
	{ 0xEBD8, 0xEFA79C },
	{ 0xECA6, 0xEFA79D },
	{ 0xECA7, 0xEFA79E },
	{ 0xECAA, 0xEFA79F },
	{ 0xECAF, 0xEFA7A0 },
	{ 0xECB0, 0xEFA7A1 },
	{ 0xECB1, 0xEFA7A2 },
	{ 0xECB2, 0xEFA7A3 },
	{ 0xECB5, 0xEFA7A4 },
	{ 0xECB8, 0xEFA7A5 },
	{ 0xECBA, 0xEFA7A6 },
	{ 0xECC0, 0xEFA7A7 },
	{ 0xECC1, 0xEFA7A8 },
	{ 0xECC5, 0xEFA7A9 },
	{ 0xECC6, 0xEFA7AA },
	{ 0xECC9, 0xEFA7AB },
	{ 0xECCA, 0xEFA7AC },
	{ 0xECD5, 0xEFA7AD },
	{ 0xECDD, 0xEFA7AE },
	{ 0xECDE, 0xEFA7AF },
	{ 0xECE1, 0xEFA7B0 },
	{ 0xECE4, 0xEFA7B1 },
	{ 0xECE7, 0xEFA7B2 },
	{ 0xECE8, 0xEFA7B3 },
	{ 0xECF7, 0xEFA7B4 },
	{ 0xECF8, 0xEFA7B5 },
	{ 0xECFA, 0xEFA7B6 },
	{ 0xEDA1, 0xEFA7B7 },
	{ 0xEDA2, 0xEFA7B8 },
	{ 0xEDA3, 0xEFA7B9 },
	{ 0xEDEE, 0xEFA7BA },
	{ 0xEEDB, 0xEFA7BB },
	{ 0xF2BD, 0xEFA7BC },
	{ 0xF2FA, 0xEFA7BD },
	{ 0xF3B1, 0xEFA7BE },
	{ 0xF4A7, 0xEFA7BF },
	{ 0xF4EE, 0xEFA880 },
	{ 0xF6F4, 0xEFA881 },
	{ 0xF6F6, 0xEFA882 },
	{ 0xF7B8, 0xEFA883 },
	{ 0xF7C8, 0xEFA884 },
	{ 0xF7D3, 0xEFA885 },
	{ 0xF8DB, 0xEFA886 },
	{ 0xF8F0, 0xEFA887 },
	{ 0xFAA1, 0xEFA888 },
	{ 0xFAA2, 0xEFA889 },
	{ 0xFAE6, 0xEFA88A },
	{ 0xFCA9, 0xEFA88B },
	{ 0xA3A1, 0xEFBC81 },
	{ 0xA3A2, 0xEFBC82 },
	{ 0xA3A3, 0xEFBC83 },
	{ 0xA3A4, 0xEFBC84 },
	{ 0xA3A5, 0xEFBC85 },
	{ 0xA3A6, 0xEFBC86 },
	{ 0xA3A7, 0xEFBC87 },
	{ 0xA3A8, 0xEFBC88 },
	{ 0xA3A9, 0xEFBC89 },
	{ 0xA3AA, 0xEFBC8A },
	{ 0xA3AB, 0xEFBC8B },
	{ 0xA3AC, 0xEFBC8C },
	{ 0xA3AD, 0xEFBC8D },
	{ 0xA3AE, 0xEFBC8E },
	{ 0xA3AF, 0xEFBC8F },
	{ 0xA3B0, 0xEFBC90 },
	{ 0xA3B1, 0xEFBC91 },
	{ 0xA3B2, 0xEFBC92 },
	{ 0xA3B3, 0xEFBC93 },
	{ 0xA3B4, 0xEFBC94 },
	{ 0xA3B5, 0xEFBC95 },
	{ 0xA3B6, 0xEFBC96 },
	{ 0xA3B7, 0xEFBC97 },
	{ 0xA3B8, 0xEFBC98 },
	{ 0xA3B9, 0xEFBC99 },
	{ 0xA3BA, 0xEFBC9A },
	{ 0xA3BB, 0xEFBC9B },
	{ 0xA3BC, 0xEFBC9C },
	{ 0xA3BD, 0xEFBC9D },
	{ 0xA3BE, 0xEFBC9E },
	{ 0xA3BF, 0xEFBC9F },
	{ 0xA3C0, 0xEFBCA0 },
	{ 0xA3C1, 0xEFBCA1 },
	{ 0xA3C2, 0xEFBCA2 },
	{ 0xA3C3, 0xEFBCA3 },
	{ 0xA3C4, 0xEFBCA4 },
	{ 0xA3C5, 0xEFBCA5 },
	{ 0xA3C6, 0xEFBCA6 },
	{ 0xA3C7, 0xEFBCA7 },
	{ 0xA3C8, 0xEFBCA8 },
	{ 0xA3C9, 0xEFBCA9 },
	{ 0xA3CA, 0xEFBCAA },
	{ 0xA3CB, 0xEFBCAB },
	{ 0xA3CC, 0xEFBCAC },
	{ 0xA3CD, 0xEFBCAD },
	{ 0xA3CE, 0xEFBCAE },
	{ 0xA3CF, 0xEFBCAF },
	{ 0xA3D0, 0xEFBCB0 },
	{ 0xA3D1, 0xEFBCB1 },
	{ 0xA3D2, 0xEFBCB2 },
	{ 0xA3D3, 0xEFBCB3 },
	{ 0xA3D4, 0xEFBCB4 },
	{ 0xA3D5, 0xEFBCB5 },
	{ 0xA3D6, 0xEFBCB6 },
	{ 0xA3D7, 0xEFBCB7 },
	{ 0xA3D8, 0xEFBCB8 },
	{ 0xA3D9, 0xEFBCB9 },
	{ 0xA3DA, 0xEFBCBA },
	{ 0xA3DB, 0xEFBCBB },
	{ 0xA1AC, 0xEFBCBC },
	{ 0xA3DD, 0xEFBCBD },
	{ 0xA3DE, 0xEFBCBE },
	{ 0xA3DF, 0xEFBCBF },
	{ 0xA3E0, 0xEFBD80 },
	{ 0xA3E1, 0xEFBD81 },
	{ 0xA3E2, 0xEFBD82 },
	{ 0xA3E3, 0xEFBD83 },
	{ 0xA3E4, 0xEFBD84 },
	{ 0xA3E5, 0xEFBD85 },
	{ 0xA3E6, 0xEFBD86 },
	{ 0xA3E7, 0xEFBD87 },
	{ 0xA3E8, 0xEFBD88 },
	{ 0xA3E9, 0xEFBD89 },
	{ 0xA3EA, 0xEFBD8A },
	{ 0xA3EB, 0xEFBD8B },
	{ 0xA3EC, 0xEFBD8C },
	{ 0xA3ED, 0xEFBD8D },
	{ 0xA3EE, 0xEFBD8E },
	{ 0xA3EF, 0xEFBD8F },
	{ 0xA3F0, 0xEFBD90 },
	{ 0xA3F1, 0xEFBD91 },
	{ 0xA3F2, 0xEFBD92 },
	{ 0xA3F3, 0xEFBD93 },
	{ 0xA3F4, 0xEFBD94 },
	{ 0xA3F5, 0xEFBD95 },
	{ 0xA3F6, 0xEFBD96 },
	{ 0xA3F7, 0xEFBD97 },
	{ 0xA3F8, 0xEFBD98 },
	{ 0xA3F9, 0xEFBD99 },
	{ 0xA3FA, 0xEFBD9A },
	{ 0xA3FB, 0xEFBD9B },
	{ 0xA3FC, 0xEFBD9C },
	{ 0xA3FD, 0xEFBD9D },
	{ 0xA2A6, 0xEFBD9E },
	{ 0xA1CB, 0xEFBFA0 },
	{ 0xA1CC, 0xEFBFA1 },
	{ 0xA1FE, 0xEFBFA2 },
	{ 0xA3FE, 0xEFBFA3 },
	{ 0xA1CD, 0xEFBFA5 },
	{ 0xA3DC, 0xEFBFA6 }
};


#endif  /* _UTF2EUC_TABLE_H_ */
