/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 *  ICU License - ICU 1.8.1 and later
 *
 *  COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1995-2005 International Business Machines Corporation and others
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 * --------------------------------------------------------------------------
 * All trademarks and registered trademarks mentioned herein are the property
 * of their respective owners.
 */
/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 * All rights reserved.
 */


#ifndef	_CP933_TO_UCS2_H_
#define	_CP933_TO_UCS2_H_


/* maxium mapping number from IBM Cp933 to UCS */
#define MAX_UCS_NUM             10970


/* CNS 11643-1992 plane #1 to Big-5 conversion table */
lookup_table    cp933_ucs2_tab[MAX_UCS_NUM] = {
        {0x0000, 0x0000},
        {0x0001, 0x0001},
        {0x0002, 0x0002},
        {0x0003, 0x0003},
        {0xFFFD, 0x0004},
        {0x0009, 0x0005},
        {0xFFFD, 0x0006},
        {0x007F, 0x0007},
        {0xFFFD, 0x0008},
        {0xFFFD, 0x0009},
        {0xFFFD, 0x000A},
        {0x000B, 0x000B},
        {0x000C, 0x000C},
        {0x000D, 0x000D},
        {0x000E, 0x000E},
        {0x000F, 0x000F},
        {0x0010, 0x0010},
        {0x0011, 0x0011},
        {0x0012, 0x0012},
        {0x0013, 0x0013},
        {0xFFFD, 0x0014},
        {0xFFFD, 0x0015},
        {0x0008, 0x0016},
        {0xFFFD, 0x0017},
        {0x0018, 0x0018},
        {0x0019, 0x0019},
        {0xFFFD, 0x001A},
        {0xFFFD, 0x001B},
        {0x001C, 0x001C},
        {0x001D, 0x001D},
        {0x001E, 0x001E},
        {0x001F, 0x001F},
        {0xFFFD, 0x0020},
        {0xFFFD, 0x0021},
        {0xFFFD, 0x0022},
        {0xFFFD, 0x0023},
        {0xFFFD, 0x0024},
        {0x000A, 0x0025},
        {0x0017, 0x0026},
        {0x001B, 0x0027},
        {0xFFFD, 0x0028},
        {0xFFFD, 0x0029},
        {0xFFFD, 0x002A},
        {0xFFFD, 0x002B},
        {0xFFFD, 0x002C},
        {0x0005, 0x002D},
        {0x0006, 0x002E},
        {0x0007, 0x002F},
        {0xFFFD, 0x0030},
        {0xFFFD, 0x0031},
        {0x0016, 0x0032},
        {0xFFFD, 0x0033},
        {0xFFFD, 0x0034},
        {0xFFFD, 0x0035},
        {0xFFFD, 0x0036},
        {0x0004, 0x0037},
        {0xFFFD, 0x0038},
        {0xFFFD, 0x0039},
        {0xFFFD, 0x003A},
        {0xFFFD, 0x003B},
        {0x0014, 0x003C},
        {0x0015, 0x003D},
        {0xFFFD, 0x003E},
        {0x001A, 0x003F},
        {0x0020, 0x0040},
        {0xFFFD, 0x0041},
        {0xFFA0, 0x0042},
        {0xFFA1, 0x0043},
        {0xFFA2, 0x0044},
        {0xFFA3, 0x0045},
        {0xFFA4, 0x0046},
        {0xFFA5, 0x0047},
        {0xFFA6, 0x0048},
        {0xFFA7, 0x0049},
        {0x00A2, 0x004A},
        {0x002E, 0x004B},
        {0x003C, 0x004C},
        {0x0028, 0x004D},
        {0x002B, 0x004E},
        {0x007C, 0x004F},
        {0x0026, 0x0050},
        {0xFFFD, 0x0051},
        {0xFFA8, 0x0052},
        {0xFFA9, 0x0053},
        {0xFFAA, 0x0054},
        {0xFFAB, 0x0055},
        {0xFFAC, 0x0056},
        {0xFFAD, 0x0057},
        {0xFFAE, 0x0058},
        {0xFFAF, 0x0059},
        {0x0021, 0x005A},
        {0x0024, 0x005B},
        {0x002A, 0x005C},
        {0x0029, 0x005D},
        {0x003B, 0x005E},
        {0x00AC, 0x005F},
        {0x002D, 0x0060},
        {0x002F, 0x0061},
        {0xFFB0, 0x0062},
        {0xFFB1, 0x0063},
        {0xFFB2, 0x0064},
        {0xFFB3, 0x0065},
        {0xFFB4, 0x0066},
        {0xFFB5, 0x0067},
        {0xFFB6, 0x0068},
        {0xFFB7, 0x0069},
        {0x00A6, 0x006A},
        {0x002C, 0x006B},
        {0x0025, 0x006C},
        {0x005F, 0x006D},
        {0x003E, 0x006E},
        {0x003F, 0x006F},
        {0x005B, 0x0070},
        {0xFFFD, 0x0071},
        {0xFFB8, 0x0072},
        {0xFFB9, 0x0073},
        {0xFFBA, 0x0074},
        {0xFFBB, 0x0075},
        {0xFFBC, 0x0076},
        {0xFFBD, 0x0077},
        {0xFFBE, 0x0078},
        {0x0060, 0x0079},
        {0x003A, 0x007A},
        {0x0023, 0x007B},
        {0x0040, 0x007C},
        {0x0027, 0x007D},
        {0x003D, 0x007E},
        {0x0022, 0x007F},
        {0x005D, 0x0080},
        {0x0061, 0x0081},
        {0x0062, 0x0082},
        {0x0063, 0x0083},
        {0x0064, 0x0084},
        {0x0065, 0x0085},
        {0x0066, 0x0086},
        {0x0067, 0x0087},
        {0x0068, 0x0088},
        {0x0069, 0x0089},
        {0xFFC2, 0x008A},
        {0xFFC3, 0x008B},
        {0xFFC4, 0x008C},
        {0xFFC5, 0x008D},
        {0xFFC6, 0x008E},
        {0xFFC7, 0x008F},
        {0xFFFD, 0x0090},
        {0x006A, 0x0091},
        {0x006B, 0x0092},
        {0x006C, 0x0093},
        {0x006D, 0x0094},
        {0x006E, 0x0095},
        {0x006F, 0x0096},
        {0x0070, 0x0097},
        {0x0071, 0x0098},
        {0x0072, 0x0099},
        {0xFFCA, 0x009A},
        {0xFFCB, 0x009B},
        {0xFFCC, 0x009C},
        {0xFFCD, 0x009D},
        {0xFFCE, 0x009E},
        {0xFFCF, 0x009F},
        {0x00AF, 0x00A0},
        {0x007E, 0x00A1},
        {0x0073, 0x00A2},
        {0x0074, 0x00A3},
        {0x0075, 0x00A4},
        {0x0076, 0x00A5},
        {0x0077, 0x00A6},
        {0x0078, 0x00A7},
        {0x0079, 0x00A8},
        {0x007A, 0x00A9},
        {0xFFD2, 0x00AA},
        {0xFFD3, 0x00AB},
        {0xFFD4, 0x00AC},
        {0xFFD5, 0x00AD},
        {0xFFD6, 0x00AE},
        {0xFFD7, 0x00AF},
        {0x005E, 0x00B0},
        {0xFFFD, 0x00B1},
        {0x005C, 0x00B2},
        {0xFFFD, 0x00B3},
        {0xFFFD, 0x00B4},
        {0xFFFD, 0x00B5},
        {0xFFFD, 0x00B6},
        {0xFFFD, 0x00B7},
        {0xFFFD, 0x00B8},
        {0xFFFD, 0x00B9},
        {0xFFDA, 0x00BA},
        {0xFFDB, 0x00BB},
        {0xFFDC, 0x00BC},
        {0xFFFD, 0x00BD},
        {0xFFFD, 0x00BE},
        {0xFFFD, 0x00BF},
        {0x007B, 0x00C0},
        {0x0041, 0x00C1},
        {0x0042, 0x00C2},
        {0x0043, 0x00C3},
        {0x0044, 0x00C4},
        {0x0045, 0x00C5},
        {0x0046, 0x00C6},
        {0x0047, 0x00C7},
        {0x0048, 0x00C8},
        {0x0049, 0x00C9},
        {0xFFFD, 0x00CA},
        {0xFFFD, 0x00CB},
        {0xFFFD, 0x00CC},
        {0xFFFD, 0x00CD},
        {0xFFFD, 0x00CE},
        {0xFFFD, 0x00CF},
        {0x007D, 0x00D0},
        {0x004A, 0x00D1},
        {0x004B, 0x00D2},
        {0x004C, 0x00D3},
        {0x004D, 0x00D4},
        {0x004E, 0x00D5},
        {0x004F, 0x00D6},
        {0x0050, 0x00D7},
        {0x0051, 0x00D8},
        {0x0052, 0x00D9},
        {0xFFFD, 0x00DA},
        {0xFFFD, 0x00DB},
        {0xFFFD, 0x00DC},
        {0xFFFD, 0x00DD},
        {0xFFFD, 0x00DE},
        {0xFFFD, 0x00DF},
        {0x20A9, 0x00E0},
        {0xFFFD, 0x00E1},
        {0x0053, 0x00E2},
        {0x0054, 0x00E3},
        {0x0055, 0x00E4},
        {0x0056, 0x00E5},
        {0x0057, 0x00E6},
        {0x0058, 0x00E7},
        {0x0059, 0x00E8},
        {0x005A, 0x00E9},
        {0xFFFD, 0x00EA},
        {0xFFFD, 0x00EB},
        {0xFFFD, 0x00EC},
        {0xFFFD, 0x00ED},
        {0xFFFD, 0x00EE},
        {0xFFFD, 0x00EF},
        {0x0030, 0x00F0},
        {0x0031, 0x00F1},
        {0x0032, 0x00F2},
        {0x0033, 0x00F3},
        {0x0034, 0x00F4},
        {0x0035, 0x00F5},
        {0x0036, 0x00F6},
        {0x0037, 0x00F7},
        {0x0038, 0x00F8},
        {0x0039, 0x00F9},
        {0xFFFD, 0x00FA},
        {0xFFFD, 0x00FB},
        {0xFFFD, 0x00FC},
        {0xFFFD, 0x00FD},
        {0xFFFD, 0x00FE},
        {0xFFFD, 0x00FF},
        {0x3000, 0x4040},
        {0x3001, 0x4141},
        {0x3002, 0x4142},
        {0x00B7, 0x4143},
        {0x2025, 0x4144},
        {0x2026, 0x4145},
        {0x00A8, 0x4146},
        {0x3003, 0x4147},
        {0x2010, 0x4148},
        {0x2015, 0x4149},
        {0x2225, 0x414A},
        {0xFF3C, 0x414B},
        {0xFFE3, 0x414C},
        {0x2018, 0x414D},
        {0x2019, 0x414E},
        {0x201C, 0x414F},
        {0x201D, 0x4150},
        {0x3014, 0x4151},
        {0x3015, 0x4152},
        {0x3008, 0x4153},
        {0x3009, 0x4154},
        {0x300A, 0x4155},
        {0x300B, 0x4156},
        {0x300C, 0x4157},
        {0x300D, 0x4158},
        {0x300E, 0x4159},
        {0x300F, 0x415A},
        {0x3010, 0x415B},
        {0x3011, 0x415C},
        {0x00B1, 0x415D},
        {0x00D7, 0x415E},
        {0x00F7, 0x415F},
        {0x01C2, 0x4160},
        {0x2266, 0x4161},
        {0x2267, 0x4162},
        {0x221E, 0x4163},
        {0x2234, 0x4164},
        {0x00B0, 0x4165},
        {0x2032, 0x4166},
        {0x2033, 0x4167},
        {0x2103, 0x4168},
        {0x212A, 0x4169},
        {0xFF3E, 0x416A},
        {0xFFE1, 0x416B},
        {0xFFE5, 0x416C},
        {0x3396, 0x416D},
        {0x3397, 0x416E},
        {0x2113, 0x416F},
        {0x33C4, 0x4170},
        {0x339C, 0x4171},
        {0x339D, 0x4172},
        {0x339E, 0x4173},
        {0x338E, 0x4174},
        {0x338F, 0x4175},
        {0x00A7, 0x4176},
        {0x203B, 0x4177},
        {0x2606, 0x4178},
        {0x2605, 0x4179},
        {0x25CB, 0x417A},
        {0x25CF, 0x417B},
        {0x25CE, 0x417C},
        {0x25C7, 0x417D},
        {0x25C6, 0x417E},
        {0x25A1, 0x417F},
        {0x25A0, 0x4180},
        {0x25B3, 0x4181},
        {0x25B2, 0x4182},
        {0x25BD, 0x4183},
        {0x25BC, 0x4184},
        {0x2192, 0x4185},
        {0x2190, 0x4186},
        {0x2191, 0x4187},
        {0x2193, 0x4188},
        {0x2194, 0x4189},
        {0x3013, 0x418A},
        {0xFF3B, 0x418B},
        {0xFF3D, 0x418C},
        {0x2260, 0x418D},
        {0x2264, 0x418E},
        {0x2265, 0x418F},
        {0x212B, 0x4190},
        {0x2642, 0x4191},
        {0x2640, 0x4192},
        {0x2220, 0x4193},
        {0x22A5, 0x4194},
        {0x2312, 0x4195},
        {0x2202, 0x4196},
        {0x2207, 0x4197},
        {0x2261, 0x4198},
        {0x2252, 0x4199},
        {0x226A, 0x419A},
        {0x226B, 0x419B},
        {0x221A, 0x419C},
        {0x223D, 0x419D},
        {0xFFE0, 0x424A},
        {0xFF0E, 0x424B},
        {0xFF1C, 0x424C},
        {0xFF08, 0x424D},
        {0xFF0B, 0x424E},
        {0xFF5C, 0x424F},
        {0xFF06, 0x4250},
        {0xFF01, 0x425A},
        {0xFF04, 0x425B},
        {0xFF0A, 0x425C},
        {0xFF09, 0x425D},
        {0xFF1B, 0x425E},
        {0xFFE2, 0x425F},
        {0xFF0D, 0x4260},
        {0xFF0F, 0x4261},
        {0xFFE4, 0x426A},
        {0xFF0C, 0x426B},
        {0xFF05, 0x426C},
        {0xFF3F, 0x426D},
        {0xFF1E, 0x426E},
        {0xFF1F, 0x426F},
        {0xFF40, 0x4279},
        {0xFF1A, 0x427A},
        {0xFF03, 0x427B},
        {0xFF20, 0x427C},
        {0xFF07, 0x427D},
        {0xFF1D, 0x427E},
        {0xFF02, 0x427F},
        {0xFF41, 0x4281},
        {0xFF42, 0x4282},
        {0xFF43, 0x4283},
        {0xFF44, 0x4284},
        {0xFF45, 0x4285},
        {0xFF46, 0x4286},
        {0xFF47, 0x4287},
        {0xFF48, 0x4288},
        {0xFF49, 0x4289},
        {0xFF4A, 0x4291},
        {0xFF4B, 0x4292},
        {0xFF4C, 0x4293},
        {0xFF4D, 0x4294},
        {0xFF4E, 0x4295},
        {0xFF4F, 0x4296},
        {0xFF50, 0x4297},
        {0xFF51, 0x4298},
        {0xFF52, 0x4299},
        {0x223C, 0x42A1},
        {0xFF53, 0x42A2},
        {0xFF54, 0x42A3},
        {0xFF55, 0x42A4},
        {0xFF56, 0x42A5},
        {0xFF57, 0x42A6},
        {0xFF58, 0x42A7},
        {0xFF59, 0x42A8},
        {0xFF5A, 0x42A9},
        {0xFF5B, 0x42C0},
        {0xFF21, 0x42C1},
        {0xFF22, 0x42C2},
        {0xFF23, 0x42C3},
        {0xFF24, 0x42C4},
        {0xFF25, 0x42C5},
        {0xFF26, 0x42C6},
        {0xFF27, 0x42C7},
        {0xFF28, 0x42C8},
        {0xFF29, 0x42C9},
        {0xFF5D, 0x42D0},
        {0xFF2A, 0x42D1},
        {0xFF2B, 0x42D2},
        {0xFF2C, 0x42D3},
        {0xFF2D, 0x42D4},
        {0xFF2E, 0x42D5},
        {0xFF2F, 0x42D6},
        {0xFF30, 0x42D7},
        {0xFF31, 0x42D8},
        {0xFF32, 0x42D9},
        {0xFFE6, 0x42E0},
        {0xFF33, 0x42E2},
        {0xFF34, 0x42E3},
        {0xFF35, 0x42E4},
        {0xFF36, 0x42E5},
        {0xFF37, 0x42E6},
        {0xFF38, 0x42E7},
        {0xFF39, 0x42E8},
        {0xFF3A, 0x42E9},
        {0xFF10, 0x42F0},
        {0xFF11, 0x42F1},
        {0xFF12, 0x42F2},
        {0xFF13, 0x42F3},
        {0xFF14, 0x42F4},
        {0xFF15, 0x42F5},
        {0xFF16, 0x42F6},
        {0xFF17, 0x42F7},
        {0xFF18, 0x42F8},
        {0xFF19, 0x42F9},
        {0x3165, 0x4341},
        {0x3166, 0x4342},
        {0x3167, 0x4343},
        {0x3168, 0x4344},
        {0x3169, 0x4345},
        {0x316A, 0x4346},
        {0x316B, 0x4347},
        {0x316C, 0x4348},
        {0x316D, 0x4349},
        {0x316E, 0x434A},
        {0x316F, 0x434B},
        {0x3170, 0x434C},
        {0x3171, 0x434D},
        {0x3172, 0x434E},
        {0x3173, 0x434F},
        {0x3174, 0x4350},
        {0x3175, 0x4351},
        {0x3176, 0x4352},
        {0x3177, 0x4353},
        {0x3178, 0x4354},
        {0x3179, 0x4355},
        {0x317A, 0x4356},
        {0x317B, 0x4357},
        {0x317C, 0x4358},
        {0x317D, 0x4359},
        {0x317E, 0x435A},
        {0x317F, 0x435B},
        {0x3180, 0x435C},
        {0x3181, 0x435D},
        {0x3182, 0x435E},
        {0x3183, 0x435F},
        {0x3184, 0x4360},
        {0x3185, 0x4361},
        {0x3186, 0x4362},
        {0x3187, 0x4363},
        {0x3188, 0x4364},
        {0x3189, 0x4365},
        {0x318A, 0x4366},
        {0x318B, 0x4367},
        {0x318C, 0x4368},
        {0x318D, 0x4369},
        {0x318E, 0x436A},
        {0x3041, 0x4441},
        {0x3042, 0x4442},
        {0x3043, 0x4443},
        {0x3044, 0x4444},
        {0x3045, 0x4445},
        {0x3046, 0x4446},
        {0x3047, 0x4447},
        {0x3048, 0x4448},
        {0x3049, 0x4449},
        {0x304A, 0x444A},
        {0x304B, 0x444B},
        {0x304C, 0x444C},
        {0x304D, 0x444D},
        {0x304E, 0x444E},
        {0x304F, 0x444F},
        {0x3050, 0x4450},
        {0x3051, 0x4451},
        {0x3052, 0x4452},
        {0x3053, 0x4453},
        {0x3054, 0x4454},
        {0x3055, 0x4455},
        {0x3056, 0x4456},
        {0x3057, 0x4457},
        {0x3058, 0x4458},
        {0x3059, 0x4459},
        {0x305A, 0x445A},
        {0x305B, 0x445B},
        {0x305C, 0x445C},
        {0x305D, 0x445D},
        {0x305E, 0x445E},
        {0x305F, 0x445F},
        {0x3060, 0x4460},
        {0x3061, 0x4461},
        {0x3062, 0x4462},
        {0x3063, 0x4463},
        {0x3064, 0x4464},
        {0x3065, 0x4465},
        {0x3066, 0x4466},
        {0x3067, 0x4467},
        {0x3068, 0x4468},
        {0x3069, 0x4469},
        {0x306A, 0x446A},
        {0x306B, 0x446B},
        {0x306C, 0x446C},
        {0x306D, 0x446D},
        {0x306E, 0x446E},
        {0x306F, 0x446F},
        {0x3070, 0x4470},
        {0x3071, 0x4471},
        {0x3072, 0x4472},
        {0x3073, 0x4473},
        {0x3074, 0x4474},
        {0x3075, 0x4475},
        {0x3076, 0x4476},
        {0x3077, 0x4477},
        {0x3078, 0x4478},
        {0x3079, 0x4479},
        {0x307A, 0x447A},
        {0x307B, 0x447B},
        {0x307C, 0x447C},
        {0x307D, 0x447D},
        {0x307E, 0x447E},
        {0x307F, 0x447F},
        {0x3080, 0x4480},
        {0x3081, 0x4481},
        {0x3082, 0x4482},
        {0x3083, 0x4483},
        {0x3084, 0x4484},
        {0x3085, 0x4485},
        {0x3086, 0x4486},
        {0x3087, 0x4487},
        {0x3088, 0x4488},
        {0x3089, 0x4489},
        {0x308A, 0x448A},
        {0x308B, 0x448B},
        {0x308C, 0x448C},
        {0x308D, 0x448D},
        {0x308E, 0x448E},
        {0x308F, 0x448F},
        {0x3090, 0x4490},
        {0x3091, 0x4491},
        {0x3092, 0x4492},
        {0x3093, 0x4493},
        {0x30A1, 0x4541},
        {0x30A2, 0x4542},
        {0x30A3, 0x4543},
        {0x30A4, 0x4544},
        {0x30A5, 0x4545},
        {0x30A6, 0x4546},
        {0x30A7, 0x4547},
        {0x30A8, 0x4548},
        {0x30A9, 0x4549},
        {0x30AA, 0x454A},
        {0x30AB, 0x454B},
        {0x30AC, 0x454C},
        {0x30AD, 0x454D},
        {0x30AE, 0x454E},
        {0x30AF, 0x454F},
        {0x30B0, 0x4550},
        {0x30B1, 0x4551},
        {0x30B2, 0x4552},
        {0x30B3, 0x4553},
        {0x30B4, 0x4554},
        {0x30B5, 0x4555},
        {0x30B6, 0x4556},
        {0x30B7, 0x4557},
        {0x30B8, 0x4558},
        {0x30B9, 0x4559},
        {0x30BA, 0x455A},
        {0x30BB, 0x455B},
        {0x30BC, 0x455C},
        {0x30BD, 0x455D},
        {0x30BE, 0x455E},
        {0x30BF, 0x455F},
        {0x30C0, 0x4560},
        {0x30C1, 0x4561},
        {0x30C2, 0x4562},
        {0x30C3, 0x4563},
        {0x30C4, 0x4564},
        {0x30C5, 0x4565},
        {0x30C6, 0x4566},
        {0x30C7, 0x4567},
        {0x30C8, 0x4568},
        {0x30C9, 0x4569},
        {0x30CA, 0x456A},
        {0x30CB, 0x456B},
        {0x30CC, 0x456C},
        {0x30CD, 0x456D},
        {0x30CE, 0x456E},
        {0x30CF, 0x456F},
        {0x30D0, 0x4570},
        {0x30D1, 0x4571},
        {0x30D2, 0x4572},
        {0x30D3, 0x4573},
        {0x30D4, 0x4574},
        {0x30D5, 0x4575},
        {0x30D6, 0x4576},
        {0x30D7, 0x4577},
        {0x30D8, 0x4578},
        {0x30D9, 0x4579},
        {0x30DA, 0x457A},
        {0x30DB, 0x457B},
        {0x30DC, 0x457C},
        {0x30DD, 0x457D},
        {0x30DE, 0x457E},
        {0x30DF, 0x457F},
        {0x30E0, 0x4580},
        {0x30E1, 0x4581},
        {0x30E2, 0x4582},
        {0x30E3, 0x4583},
        {0x30E4, 0x4584},
        {0x30E5, 0x4585},
        {0x30E6, 0x4586},
        {0x30E7, 0x4587},
        {0x30E8, 0x4588},
        {0x30E9, 0x4589},
        {0x30EA, 0x458A},
        {0x30EB, 0x458B},
        {0x30EC, 0x458C},
        {0x30ED, 0x458D},
        {0x30EE, 0x458E},
        {0x30EF, 0x458F},
        {0x30F0, 0x4590},
        {0x30F1, 0x4591},
        {0x30F2, 0x4592},
        {0x30F3, 0x4593},
        {0x30F4, 0x4594},
        {0x30F5, 0x4595},
        {0x30F6, 0x4596},
        {0x2170, 0x4641},
        {0x2171, 0x4642},
        {0x2172, 0x4643},
        {0x2173, 0x4644},
        {0x2174, 0x4645},
        {0x2175, 0x4646},
        {0x2176, 0x4647},
        {0x2177, 0x4648},
        {0x2178, 0x4649},
        {0x2179, 0x464A},
        {0x2160, 0x4650},
        {0x2161, 0x4651},
        {0x2162, 0x4652},
        {0x2163, 0x4653},
        {0x2164, 0x4654},
        {0x2165, 0x4655},
        {0x2166, 0x4656},
        {0x2167, 0x4657},
        {0x2168, 0x4658},
        {0x2169, 0x4659},
        {0x0391, 0x4661},
        {0x0392, 0x4662},
        {0x0393, 0x4663},
        {0x0394, 0x4664},
        {0x0395, 0x4665},
        {0x0396, 0x4666},
        {0x0397, 0x4667},
        {0x0398, 0x4668},
        {0x0399, 0x4669},
        {0x039A, 0x466A},
        {0x039B, 0x466B},
        {0x039C, 0x466C},
        {0x039D, 0x466D},
        {0x039E, 0x466E},
        {0x039F, 0x466F},
        {0x03A0, 0x4670},
        {0x03A1, 0x4671},
        {0x03A3, 0x4672},
        {0x03A4, 0x4673},
        {0x03A5, 0x4674},
        {0x03A6, 0x4675},
        {0x03A7, 0x4676},
        {0x03A8, 0x4677},
        {0x03A9, 0x4678},
        {0x03B1, 0x4681},
        {0x03B2, 0x4682},
        {0x03B3, 0x4683},
        {0x03B4, 0x4684},
        {0x03B5, 0x4685},
        {0x03B6, 0x4686},
        {0x03B7, 0x4687},
        {0x03B8, 0x4688},
        {0x03B9, 0x4689},
        {0x03BA, 0x468A},
        {0x03BB, 0x468B},
        {0x03BC, 0x468C},
        {0x03BD, 0x468D},
        {0x03BE, 0x468E},
        {0x03BF, 0x468F},
        {0x03C0, 0x4690},
        {0x03C1, 0x4691},
        {0x03C3, 0x4692},
        {0x03C4, 0x4693},
        {0x03C5, 0x4694},
        {0x03C6, 0x4695},
        {0x03C7, 0x4696},
        {0x03C8, 0x4697},
        {0x03C9, 0x4698},
        {0x2500, 0x4741},
        {0x2502, 0x4742},
        {0x250C, 0x4743},
        {0x2510, 0x4744},
        {0x2518, 0x4745},
        {0x2514, 0x4746},
        {0x251C, 0x4747},
        {0x252C, 0x4748},
        {0x2524, 0x4749},
        {0x2534, 0x474A},
        {0x253C, 0x474B},
        {0x2501, 0x474C},
        {0x2503, 0x474D},
        {0x250F, 0x474E},
        {0x2513, 0x474F},
        {0x251B, 0x4750},
        {0x2517, 0x4751},
        {0x2523, 0x4752},
        {0x2533, 0x4753},
        {0x252B, 0x4754},
        {0x253B, 0x4755},
        {0x254B, 0x4756},
        {0x2520, 0x4757},
        {0x252F, 0x4758},
        {0x2528, 0x4759},
        {0x2537, 0x475A},
        {0x253F, 0x475B},
        {0x251D, 0x475C},
        {0x2530, 0x475D},
        {0x2525, 0x475E},
        {0x2538, 0x475F},
        {0x2542, 0x4760},
        {0x2512, 0x4761},
        {0x2511, 0x4762},
        {0x251A, 0x4763},
        {0x2519, 0x4764},
        {0x2516, 0x4765},
        {0x2515, 0x4766},
        {0x250E, 0x4767},
        {0x250D, 0x4768},
        {0x251E, 0x4769},
        {0x251F, 0x476A},
        {0x2521, 0x476B},
        {0x2522, 0x476C},
        {0x2526, 0x476D},
        {0x2527, 0x476E},
        {0x2529, 0x476F},
        {0x252A, 0x4770},
        {0x252D, 0x4771},
        {0x252E, 0x4772},
        {0x2531, 0x4773},
        {0x2532, 0x4774},
        {0x2535, 0x4775},
        {0x2536, 0x4776},
        {0x2539, 0x4777},
        {0x253A, 0x4778},
        {0x253D, 0x4779},
        {0x253E, 0x477A},
        {0x2540, 0x477B},
        {0x2541, 0x477C},
        {0x2543, 0x477D},
        {0x2544, 0x477E},
        {0x2545, 0x477F},
        {0x2546, 0x4780},
        {0x2547, 0x4781},
        {0x2548, 0x4782},
        {0x2549, 0x4783},
        {0x254A, 0x4784},
        {0x3395, 0x4841},
        {0x3398, 0x4842},
        {0x33A3, 0x4843},
        {0x33A4, 0x4844},
        {0x33A5, 0x4845},
        {0x33A6, 0x4846},
        {0x3399, 0x4847},
        {0x339A, 0x4848},
        {0x339B, 0x4849},
        {0x339F, 0x484A},
        {0x33A0, 0x484B},
        {0x33A1, 0x484C},
        {0x33A2, 0x484D},
        {0x33CA, 0x484E},
        {0x338D, 0x484F},
        {0x33CF, 0x4850},
        {0x3388, 0x4851},
        {0x3389, 0x4852},
        {0x33C8, 0x4853},
        {0x33A7, 0x4854},
        {0x33A8, 0x4855},
        {0x33B0, 0x4856},
        {0x33B1, 0x4857},
        {0x33B2, 0x4858},
        {0x33B3, 0x4859},
        {0x33B4, 0x485A},
        {0x33B5, 0x485B},
        {0x33B6, 0x485C},
        {0x33B7, 0x485D},
        {0x33B8, 0x485E},
        {0x33B9, 0x485F},
        {0x3380, 0x4860},
        {0x3381, 0x4861},
        {0x3382, 0x4862},
        {0x3383, 0x4863},
        {0x3384, 0x4864},
        {0x33BA, 0x4865},
        {0x33BB, 0x4866},
        {0x33BC, 0x4867},
        {0x33BD, 0x4868},
        {0x33BE, 0x4869},
        {0x33BF, 0x486A},
        {0x3390, 0x486B},
        {0x3391, 0x486C},
        {0x3392, 0x486D},
        {0x3393, 0x486E},
        {0x3394, 0x486F},
        {0x2126, 0x4870},
        {0x33C0, 0x4871},
        {0x33C1, 0x4872},
        {0x338A, 0x4873},
        {0x338B, 0x4874},
        {0x338C, 0x4875},
        {0x33D6, 0x4876},
        {0x33C5, 0x4877},
        {0x33AD, 0x4878},
        {0x33AE, 0x4879},
        {0x33AF, 0x487A},
        {0x33DB, 0x487B},
        {0x33A9, 0x487C},
        {0x33AA, 0x487D},
        {0x33AB, 0x487E},
        {0x33AC, 0x487F},
        {0x33DD, 0x4880},
        {0x33D0, 0x4881},
        {0x33D3, 0x4882},
        {0x33C3, 0x4883},
        {0x33C9, 0x4884},
        {0x33DC, 0x4885},
        {0x33C6, 0x4886},
        {0x221D, 0x4941},
        {0x2235, 0x4942},
        {0x222B, 0x4943},
        {0x222C, 0x4944},
        {0x2208, 0x4945},
        {0x220B, 0x4946},
        {0x2286, 0x4947},
        {0x2287, 0x4948},
        {0x2282, 0x4949},
        {0x2283, 0x494A},
        {0x222A, 0x494B},
        {0x2229, 0x494C},
        {0x2227, 0x494D},
        {0x2228, 0x494E},
        {0x21D2, 0x494F},
        {0x21D4, 0x4950},
        {0x2200, 0x4951},
        {0x2203, 0x4952},
        {0x00B4, 0x4953},
        {0xFF5E, 0x4954},
        {0x02C7, 0x4955},
        {0x02D8, 0x4956},
        {0x02DD, 0x4957},
        {0x02DA, 0x4958},
        {0x02D9, 0x4959},
        {0x00B8, 0x495A},
        {0x02DB, 0x495B},
        {0x00A1, 0x495C},
        {0x00BF, 0x495D},
        {0x02D0, 0x495E},
        {0x222E, 0x495F},
        {0x2211, 0x4960},
        {0x220F, 0x4961},
        {0x00A4, 0x4962},
        {0x2109, 0x4963},
        {0x2030, 0x4964},
        {0x25C1, 0x4965},
        {0x25C0, 0x4966},
        {0x25B7, 0x4967},
        {0x25B6, 0x4968},
        {0x2664, 0x4969},
        {0x2660, 0x496A},
        {0x2661, 0x496B},
        {0x2665, 0x496C},
        {0x2667, 0x496D},
        {0x2663, 0x496E},
        {0x2299, 0x496F},
        {0x25C8, 0x4970},
        {0x25A3, 0x4971},
        {0x25D0, 0x4972},
        {0x25D1, 0x4973},
        {0x2592, 0x4974},
        {0x25A4, 0x4975},
        {0x25A5, 0x4976},
        {0x25A8, 0x4977},
        {0x25A7, 0x4978},
        {0x25A6, 0x4979},
        {0x25A9, 0x497A},
        {0x2668, 0x497B},
        {0x260F, 0x497C},
        {0x260E, 0x497D},
        {0x261C, 0x497E},
        {0x261E, 0x497F},
        {0x00B6, 0x4980},
        {0x2020, 0x4981},
        {0x2021, 0x4982},
        {0x2195, 0x4983},
        {0x2197, 0x4984},
        {0x2199, 0x4985},
        {0x2196, 0x4986},
        {0x2198, 0x4987},
        {0x266D, 0x4988},
        {0x2669, 0x4989},
        {0x266A, 0x498A},
        {0x266C, 0x498B},
        {0x327F, 0x498C},
        {0x321C, 0x498D},
        {0x2116, 0x498E},
        {0x33C7, 0x498F},
        {0x2122, 0x4990},
        {0x33C2, 0x4991},
        {0x33D8, 0x4992},
        {0x2121, 0x4993},
        {0x02BA, 0x4994},
        {0x0410, 0x4A41},
        {0x0411, 0x4A42},
        {0x0412, 0x4A43},
        {0x0413, 0x4A44},
        {0x0414, 0x4A45},
        {0x0415, 0x4A46},
        {0x0401, 0x4A47},
        {0x0416, 0x4A48},
        {0x0417, 0x4A49},
        {0x0418, 0x4A4A},
        {0x0419, 0x4A4B},
        {0x041A, 0x4A4C},
        {0x041B, 0x4A4D},
        {0x041C, 0x4A4E},
        {0x041D, 0x4A4F},
        {0x041E, 0x4A50},
        {0x041F, 0x4A51},
        {0x0420, 0x4A52},
        {0x0421, 0x4A53},
        {0x0422, 0x4A54},
        {0x0423, 0x4A55},
        {0x0424, 0x4A56},
        {0x0425, 0x4A57},
        {0x0426, 0x4A58},
        {0x0427, 0x4A59},
        {0x0428, 0x4A5A},
        {0x0429, 0x4A5B},
        {0x042A, 0x4A5C},
        {0x042B, 0x4A5D},
        {0x042C, 0x4A5E},
        {0x042D, 0x4A5F},
        {0x042E, 0x4A60},
        {0x042F, 0x4A61},
        {0x0430, 0x4A62},
        {0x0431, 0x4A63},
        {0x0432, 0x4A64},
        {0x0433, 0x4A65},
        {0x0434, 0x4A66},
        {0x0435, 0x4A67},
        {0x0451, 0x4A68},
        {0x0436, 0x4A69},
        {0x0437, 0x4A6A},
        {0x0438, 0x4A6B},
        {0x0439, 0x4A6C},
        {0x043A, 0x4A6D},
        {0x043B, 0x4A6E},
        {0x043C, 0x4A6F},
        {0x043D, 0x4A70},
        {0x043E, 0x4A71},
        {0x043F, 0x4A72},
        {0x0440, 0x4A73},
        {0x0441, 0x4A74},
        {0x0442, 0x4A75},
        {0x0443, 0x4A76},
        {0x0444, 0x4A77},
        {0x0445, 0x4A78},
        {0x0446, 0x4A79},
        {0x0447, 0x4A7A},
        {0x0448, 0x4A7B},
        {0x0449, 0x4A7C},
        {0x044A, 0x4A7D},
        {0x044B, 0x4A7E},
        {0x044C, 0x4A7F},
        {0x044D, 0x4A80},
        {0x044E, 0x4A81},
        {0x044F, 0x4A82},
        {0x00C6, 0x4B41},
        {0x00D0, 0x4B42},
        {0x00AA, 0x4B43},
        {0x0126, 0x4B44},
        {0x0132, 0x4B46},
        {0x013F, 0x4B48},
        {0x0141, 0x4B49},
        {0x00D8, 0x4B4A},
        {0x0152, 0x4B4B},
        {0x00BA, 0x4B4C},
        {0x00DE, 0x4B4D},
        {0x0166, 0x4B4E},
        {0x014A, 0x4B4F},
        {0x3260, 0x4B51},
        {0x3261, 0x4B52},
        {0x3262, 0x4B53},
        {0x3263, 0x4B54},
        {0x3264, 0x4B55},
        {0x3265, 0x4B56},
        {0x3266, 0x4B57},
        {0x3267, 0x4B58},
        {0x3268, 0x4B59},
        {0x3269, 0x4B5A},
        {0x326A, 0x4B5B},
        {0x326B, 0x4B5C},
        {0x326C, 0x4B5D},
        {0x326D, 0x4B5E},
        {0x326E, 0x4B5F},
        {0x326F, 0x4B60},
        {0x3270, 0x4B61},
        {0x3271, 0x4B62},
        {0x3272, 0x4B63},
        {0x3273, 0x4B64},
        {0x3274, 0x4B65},
        {0x3275, 0x4B66},
        {0x3276, 0x4B67},
        {0x3277, 0x4B68},
        {0x3278, 0x4B69},
        {0x3279, 0x4B6A},
        {0x327A, 0x4B6B},
        {0x327B, 0x4B6C},
        {0x24D0, 0x4B6D},
        {0x24D1, 0x4B6E},
        {0x24D2, 0x4B6F},
        {0x24D3, 0x4B70},
        {0x24D4, 0x4B71},
        {0x24D5, 0x4B72},
        {0x24D6, 0x4B73},
        {0x24D7, 0x4B74},
        {0x24D8, 0x4B75},
        {0x24D9, 0x4B76},
        {0x24DA, 0x4B77},
        {0x24DB, 0x4B78},
        {0x24DC, 0x4B79},
        {0x24DD, 0x4B7A},
        {0x24DE, 0x4B7B},
        {0x24DF, 0x4B7C},
        {0x24E0, 0x4B7D},
        {0x24E1, 0x4B7E},
        {0x24E2, 0x4B7F},
        {0x24E3, 0x4B80},
        {0x24E4, 0x4B81},
        {0x24E5, 0x4B82},
        {0x24E6, 0x4B83},
        {0x24E7, 0x4B84},
        {0x24E8, 0x4B85},
        {0x24E9, 0x4B86},
        {0x2460, 0x4B87},
        {0x2461, 0x4B88},
        {0x2462, 0x4B89},
        {0x2463, 0x4B8A},
        {0x2464, 0x4B8B},
        {0x2465, 0x4B8C},
        {0x2466, 0x4B8D},
        {0x2467, 0x4B8E},
        {0x2468, 0x4B8F},
        {0x2469, 0x4B90},
        {0x246A, 0x4B91},
        {0x246B, 0x4B92},
        {0x246C, 0x4B93},
        {0x246D, 0x4B94},
        {0x246E, 0x4B95},
        {0x00BD, 0x4B96},
        {0x2153, 0x4B97},
        {0x2154, 0x4B98},
        {0x00BC, 0x4B99},
        {0x00BE, 0x4B9A},
        {0x215B, 0x4B9B},
        {0x215C, 0x4B9C},
        {0x215D, 0x4B9D},
        {0x215E, 0x4B9E},
        {0x00E6, 0x4BA0},
        {0x0111, 0x4BA1},
        {0x00F0, 0x4BA2},
        {0x0127, 0x4BA3},
        {0x0131, 0x4BA4},
        {0x0133, 0x4BA5},
        {0x0138, 0x4BA6},
        {0x0140, 0x4BA7},
        {0x0142, 0x4BA8},
        {0x00F8, 0x4BA9},
        {0x0153, 0x4BAA},
        {0x00DF, 0x4BAB},
        {0x00FE, 0x4BAC},
        {0x0167, 0x4BAD},
        {0x014B, 0x4BAE},
        {0x0149, 0x4BAF},
        {0x3200, 0x4BB0},
        {0x3201, 0x4BB1},
        {0x3202, 0x4BB2},
        {0x3203, 0x4BB3},
        {0x3204, 0x4BB4},
        {0x3205, 0x4BB5},
        {0x3206, 0x4BB6},
        {0x3207, 0x4BB7},
        {0x3208, 0x4BB8},
        {0x3209, 0x4BB9},
        {0x320A, 0x4BBA},
        {0x320B, 0x4BBB},
        {0x320C, 0x4BBC},
        {0x320D, 0x4BBD},
        {0x320E, 0x4BBE},
        {0x320F, 0x4BBF},
        {0x3210, 0x4BC0},
        {0x3211, 0x4BC1},
        {0x3212, 0x4BC2},
        {0x3213, 0x4BC3},
        {0x3214, 0x4BC4},
        {0x3215, 0x4BC5},
        {0x3216, 0x4BC6},
        {0x3217, 0x4BC7},
        {0x3218, 0x4BC8},
        {0x3219, 0x4BC9},
        {0x321A, 0x4BCA},
        {0x321B, 0x4BCB},
        {0x249C, 0x4BCC},
        {0x249D, 0x4BCD},
        {0x249E, 0x4BCE},
        {0x249F, 0x4BCF},
        {0x24A0, 0x4BD0},
        {0x24A1, 0x4BD1},
        {0x24A2, 0x4BD2},
        {0x24A3, 0x4BD3},
        {0x24A4, 0x4BD4},
        {0x24A5, 0x4BD5},
        {0x24A6, 0x4BD6},
        {0x24A7, 0x4BD7},
        {0x24A8, 0x4BD8},
        {0x24A9, 0x4BD9},
        {0x24AA, 0x4BDA},
        {0x24AB, 0x4BDB},
        {0x24AC, 0x4BDC},
        {0x24AD, 0x4BDD},
        {0x24AE, 0x4BDE},
        {0x24AF, 0x4BDF},
        {0x24B0, 0x4BE0},
        {0x24B1, 0x4BE1},
        {0x24B2, 0x4BE2},
        {0x24B3, 0x4BE3},
        {0x24B4, 0x4BE4},
        {0x24B5, 0x4BE5},
        {0x2474, 0x4BE6},
        {0x2475, 0x4BE7},
        {0x2476, 0x4BE8},
        {0x2477, 0x4BE9},
        {0x2478, 0x4BEA},
        {0x2479, 0x4BEB},
        {0x247A, 0x4BEC},
        {0x247B, 0x4BED},
        {0x247C, 0x4BEE},
        {0x247D, 0x4BEF},
        {0x247E, 0x4BF0},
        {0x247F, 0x4BF1},
        {0x2480, 0x4BF2},
        {0x2481, 0x4BF3},
        {0x2482, 0x4BF4},
        {0x00B9, 0x4BF5},
        {0x00B2, 0x4BF6},
        {0x00B3, 0x4BF7},
        {0x2074, 0x4BF8},
        {0x207F, 0x4BF9},
        {0x2081, 0x4BFA},
        {0x2082, 0x4BFB},
        {0x2083, 0x4BFC},
        {0x2084, 0x4BFD},
        {0x4F3D, 0x5041},
        {0x4F73, 0x5042},
        {0x5047, 0x5043},
        {0x50F9, 0x5044},
        {0x52A0, 0x5045},
        {0x53EF, 0x5046},
        {0x5475, 0x5047},
        {0x54E5, 0x5048},
        {0x5609, 0x5049},
        {0x5AC1, 0x504A},
        {0x5BB6, 0x504B},
        {0x6687, 0x504C},
        {0x67EF, 0x504D},
        {0x67B6, 0x504E},
        {0x6B4C, 0x504F},
        {0x7A3C, 0x5050},
        {0x82DB, 0x5051},
        {0x8304, 0x5052},
        {0x8857, 0x5053},
        {0x8888, 0x5054},
        {0x8A36, 0x5055},
        {0x8CC8, 0x5056},
        {0x8DCF, 0x5057},
        {0x8EFB, 0x5058},
        {0x8FE6, 0x5059},
        {0x99D5, 0x505A},
        {0x523B, 0x505B},
        {0x5374, 0x505C},
        {0x5404, 0x505D},
        {0xF8FE, 0x505E},
        {0x606A, 0x505F},
        {0x64F1, 0x5060},
        {0x6BBC, 0x5061},
        {0x73CF, 0x5062},
        {0x811A, 0x5063},
        {0x89BA, 0x5064},
        {0x89D2, 0x5065},
        {0x95A3, 0x5066},
        {0x520A, 0x5067},
        {0x58BE, 0x5068},
        {0x5978, 0x5069},
        {0x59E6, 0x506A},
        {0x5E72, 0x506B},
        {0x5E79, 0x506C},
        {0x61C7, 0x506D},
        {0x63C0, 0x506E},
        {0x6746, 0x506F},
        {0x6F97, 0x5070},
        {0x764E, 0x5071},
        {0x770B, 0x5072},
        {0x7A08, 0x5073},
        {0x7AFF, 0x5074},
        {0x7C21, 0x5075},
        {0x826E, 0x5076},
        {0x8271, 0x5077},
        {0x809D, 0x5078},
        {0x8AEB, 0x5079},
        {0x9593, 0x507A},
        {0x4E6B, 0x507B},
        {0x559D, 0x507C},
        {0x66F7, 0x507D},
        {0x6E34, 0x507E},
        {0x78A3, 0x507F},
        {0x7AED, 0x5080},
        {0x8910, 0x5081},
        {0x7FAF, 0x5082},
        {0x845B, 0x5083},
        {0x97A8, 0x5084},
        {0x52D8, 0x5085},
        {0x574E, 0x5086},
        {0x582A, 0x5087},
        {0x5D4C, 0x5088},
        {0x611F, 0x5089},
        {0x61BE, 0x508A},
        {0x6562, 0x508B},
        {0x67D1, 0x508C},
        {0x6A44, 0x508D},
        {0x6E1B, 0x508E},
        {0x7518, 0x508F},
        {0x75B3, 0x5090},
        {0x76E3, 0x5091},
        {0x7D3A, 0x5092},
        {0x9163, 0x5093},
        {0x9451, 0x5094},
        {0x9F95, 0x5095},
        {0x5323, 0x5096},
        {0x5CAC, 0x5097},
        {0x7532, 0x5098},
        {0x80DB, 0x5099},
        {0x9240, 0x509A},
        {0x9598, 0x509B},
        {0x5CA1, 0x509C},
        {0x525B, 0x509D},
        {0x59DC, 0x509E},
        {0x5D17, 0x509F},
        {0x5EB7, 0x50A0},
        {0x5F3A, 0x50A1},
        {0x5F4A, 0x50A2},
        {0x6177, 0x50A3},
        {0x6C5F, 0x50A4},
        {0x7586, 0x50A5},
        {0x7DB1, 0x50A6},
        {0x8941, 0x50A7},
        {0x7CE0, 0x50A8},
        {0x8154, 0x50A9},
        {0x8591, 0x50AA},
        {0x8B1B, 0x50AB},
        {0x92FC, 0x50AC},
        {0x964D, 0x50AD},
        {0x4ECB, 0x50AE},
        {0x4EF7, 0x50AF},
        {0x500B, 0x50B0},
        {0x51F1, 0x50B1},
        {0x6137, 0x50B2},
        {0x613E, 0x50B3},
        {0x6168, 0x50B4},
        {0x6539, 0x50B5},
        {0x69EA, 0x50B6},
        {0x6F11, 0x50B7},
        {0x75A5, 0x50B8},
        {0x7686, 0x50B9},
        {0x76D6, 0x50BA},
        {0x7B87, 0x50BB},
        {0x82A5, 0x50BC},
        {0x84CB, 0x50BD},
        {0x958B, 0x50BE},
        {0x5BA2, 0x50BF},
        {0x5751, 0x50C0},
        {0xF901, 0x50C1},
        {0x7CB3, 0x50C2},
        {0x7FB9, 0x50C3},
        {0x91B5, 0x50C4},
        {0x53BB, 0x50C5},
        {0x5C45, 0x50C6},
        {0x5DE8, 0x50C7},
        {0x62D2, 0x50C8},
        {0x636E, 0x50C9},
        {0x64DA, 0x50CA},
        {0x6E20, 0x50CB},
        {0x70AC, 0x50CC},
        {0x64E7, 0x50CD},
        {0x8DDD, 0x50CE},
        {0x907D, 0x50CF},
        {0xF902, 0x50D0},
        {0xF8FD, 0x50D1},
        {0x92F8, 0x50D2},
        {0x4E7E, 0x50D3},
        {0x4EF6, 0x50D4},
        {0x5065, 0x50D5},
        {0x5DFE, 0x50D6},
        {0x5EFA, 0x50D7},
        {0x6106, 0x50D8},
        {0x8654, 0x50D9},
        {0x8E47, 0x50DA},
        {0x9375, 0x50DB},
        {0x9A2B, 0x50DC},
        {0x4E5E, 0x50DD},
        {0x5091, 0x50DE},
        {0x6770, 0x50DF},
        {0x5109, 0x50E0},
        {0x528D, 0x50E1},
        {0x6AA2, 0x50E2},
        {0x77BC, 0x50E3},
        {0x9ED4, 0x50E4},
        {0x52AB, 0x50E5},
        {0x602F, 0x50E6},
        {0x5048, 0x50E7},
        {0x61A9, 0x50E8},
        {0x63ED, 0x50E9},
        {0x64CA, 0x50EA},
        {0x683C, 0x50EB},
        {0x6A84, 0x50EC},
        {0x6FC0, 0x50ED},
        {0x89A1, 0x50EE},
        {0x9694, 0x50EF},
        {0x9ABC, 0x50F0},
        {0x5805, 0x50F1},
        {0x80A9, 0x50F2},
        {0x727D, 0x50F3},
        {0x72AC, 0x50F4},
        {0x7504, 0x50F5},
        {0x7D79, 0x50F6},
        {0x7E6D, 0x50F7},
        {0x898B, 0x50F8},
        {0x8B74, 0x50F9},
        {0x9063, 0x50FA},
        {0x9D51, 0x50FB},
        {0x6F54, 0x50FC},
        {0x6C7A, 0x50FD},
        {0x7D50, 0x50FE},
        {0x7F3A, 0x5141},
        {0x8A23, 0x5142},
        {0x517C, 0x5143},
        {0x614A, 0x5144},
        {0x7B9D, 0x5145},
        {0x84B9, 0x5146},
        {0x8B19, 0x5147},
        {0x938C, 0x5148},
        {0x4EAC, 0x5149},
        {0x50BE, 0x514A},
        {0x52C1, 0x514B},
        {0x52CD, 0x514C},
        {0x537F, 0x514D},
        {0x54FD, 0x514E},
        {0x5883, 0x514F},
        {0x5E9A, 0x5150},
        {0x5F91, 0x5151},
        {0x6176, 0x5152},
        {0x66BB, 0x5153},
        {0x6243, 0x5154},
        {0x64CE, 0x5155},
        {0x656C, 0x5156},
        {0x666F, 0x5157},
        {0x66F4, 0x5158},
        {0x6897, 0x5159},
        {0x6AA0, 0x515A},
        {0x6D87, 0x515B},
        {0x7085, 0x515C},
        {0x71B2, 0x515D},
        {0x749F, 0x515E},
        {0x74CA, 0x515F},
        {0x754A, 0x5160},
        {0x75D9, 0x5161},
        {0x786C, 0x5162},
        {0x78EC, 0x5163},
        {0x7ADF, 0x5164},
        {0x7AF6, 0x5165},
        {0x7D45, 0x5166},
        {0x7D93, 0x5167},
        {0x8015, 0x5168},
        {0x803F, 0x5169},
        {0x811B, 0x516A},
        {0x8396, 0x516B},
        {0x8B66, 0x516C},
        {0x8F15, 0x516D},
        {0x9015, 0x516E},
        {0x93E1, 0x516F},
        {0x9803, 0x5170},
        {0x9838, 0x5171},
        {0x9A5A, 0x5172},
        {0x9BE8, 0x5173},
        {0x4FC2, 0x5174},
        {0x5553, 0x5175},
        {0x5951, 0x5176},
        {0x5B63, 0x5177},
        {0x5C46, 0x5178},
        {0x60B8, 0x5179},
        {0x6212, 0x517A},
        {0x6842, 0x517B},
        {0x68B0, 0x517C},
        {0x6EAA, 0x517D},
        {0x754C, 0x517E},
        {0x7678, 0x517F},
        {0x78CE, 0x5180},
        {0xF8FC, 0x5181},
        {0x7A3D, 0x5182},
        {0x7CFB, 0x5183},
        {0x7E6B, 0x5184},
        {0x7E7C, 0x5185},
        {0x8A08, 0x5186},
        {0x8AA1, 0x5187},
        {0x968E, 0x5188},
        {0x8C3F, 0x5189},
        {0x96DE, 0x518A},
        {0x9DC4, 0x518B},
        {0x53E9, 0x518C},
        {0x53E4, 0x518D},
        {0x544A, 0x518E},
        {0x5471, 0x518F},
        {0x56FA, 0x5190},
        {0x59D1, 0x5191},
        {0x5B64, 0x5192},
        {0x5EAB, 0x5193},
        {0x62F7, 0x5194},
        {0x6537, 0x5195},
        {0x6545, 0x5196},
        {0x6572, 0x5197},
        {0x67AF, 0x5198},
        {0x6772, 0x5199},
        {0x6CBD, 0x519A},
        {0x75FC, 0x519B},
        {0x7690, 0x519C},
        {0x8831, 0x519D},
        {0x77BD, 0x519E},
        {0x7A3F, 0x519F},
        {0x777E, 0x51A0},
        {0x8003, 0x51A1},
        {0x80A1, 0x51A2},
        {0x818F, 0x51A3},
        {0x82E6, 0x51A4},
        {0x85C1, 0x51A5},
        {0x88B4, 0x51A6},
        {0x8A41, 0x51A7},
        {0x8AA5, 0x51A8},
        {0xF903, 0x51A9},
        {0x8F9C, 0x51AA},
        {0x932E, 0x51AB},
        {0x96C7, 0x51AC},
        {0x9867, 0x51AD},
        {0x9AD8, 0x51AE},
        {0x9F13, 0x51AF},
        {0x54ED, 0x51B0},
        {0x659B, 0x51B1},
        {0x66F2, 0x51B2},
        {0x688F, 0x51B3},
        {0x7A40, 0x51B4},
        {0x8C37, 0x51B5},
        {0x9D60, 0x51B6},
        {0x56F0, 0x51B7},
        {0x5764, 0x51B8},
        {0x5D11, 0x51B9},
        {0x6606, 0x51BA},
        {0x68B1, 0x51BB},
        {0x68CD, 0x51BC},
        {0x6EFE, 0x51BD},
        {0x889E, 0x51BE},
        {0x6C68, 0x51BF},
        {0xF904, 0x51C0},
        {0x9AA8, 0x51C1},
        {0x4F9B, 0x51C2},
        {0x516C, 0x51C3},
        {0x5171, 0x51C4},
        {0x529F, 0x51C5},
        {0x5B54, 0x51C6},
        {0x5DE5, 0x51C7},
        {0x8CA2, 0x51C8},
        {0x606D, 0x51C9},
        {0x6050, 0x51CA},
        {0x62F1, 0x51CB},
        {0x63A7, 0x51CC},
        {0x653B, 0x51CD},
        {0x6831, 0x51CE},
        {0x69D3, 0x51CF},
        {0x7A7A, 0x51D0},
        {0x7B9C, 0x51D1},
        {0x5BE1, 0x51D2},
        {0x6208, 0x51D3},
        {0x679C, 0x51D4},
        {0x74DC, 0x51D5},
        {0x79D1, 0x51D6},
        {0x83D3, 0x51D7},
        {0x874C, 0x51D8},
        {0x8A87, 0x51D9},
        {0x8AB2, 0x51DA},
        {0x904E, 0x51DB},
        {0x9846, 0x51DC},
        {0x5ED3, 0x51DD},
        {0x69E8, 0x51DE},
        {0x85FF, 0x51DF},
        {0x90ED, 0x51E0},
        {0x970D, 0x51E1},
        {0xF905, 0x51E2},
        {0x51A0, 0x51E3},
        {0x5B98, 0x51E4},
        {0x5BEC, 0x51E5},
        {0x6163, 0x51E6},
        {0x68FA, 0x51E7},
        {0x74D8, 0x51E8},
        {0x6B3E, 0x51E9},
        {0x704C, 0x51EA},
        {0x76E5, 0x51EB},
        {0x7BA1, 0x51EC},
        {0x7F50, 0x51ED},
        {0x83C5, 0x51EE},
        {0x89C0, 0x51EF},
        {0x8CAB, 0x51F0},
        {0x95DC, 0x51F1},
        {0x9928, 0x51F2},
        {0x9E1B, 0x51F3},
        {0x522E, 0x51F4},
        {0x605D, 0x51F5},
        {0x62EC, 0x51F6},
        {0x9002, 0x51F7},
        {0x5149, 0x51F8},
        {0x5321, 0x51F9},
        {0x58D9, 0x51FA},
        {0x5EE3, 0x51FB},
        {0x66E0, 0x51FC},
        {0x6D38, 0x51FD},
        {0x72C2, 0x51FE},
        {0x73D6, 0x5241},
        {0x7B50, 0x5242},
        {0x80F1, 0x5243},
        {0x945B, 0x5244},
        {0x5366, 0x5245},
        {0x639B, 0x5246},
        {0x7F6B, 0x5247},
        {0x4E56, 0x5248},
        {0x5080, 0x5249},
        {0x584A, 0x524A},
        {0x58DE, 0x524B},
        {0x602A, 0x524C},
        {0x6127, 0x524D},
        {0x62D0, 0x524E},
        {0x69D0, 0x524F},
        {0x9B41, 0x5250},
        {0x5B8F, 0x5251},
        {0x7D18, 0x5252},
        {0x80B1, 0x5253},
        {0x8F5F, 0x5254},
        {0x4EA4, 0x5255},
        {0x50D1, 0x5256},
        {0x54AC, 0x5257},
        {0x55AC, 0x5258},
        {0x5B0C, 0x5259},
        {0x5DA0, 0x525A},
        {0x5DE7, 0x525B},
        {0x654E, 0x525C},
        {0x652A, 0x525D},
        {0x6821, 0x525E},
        {0x6A4B, 0x525F},
        {0x72E1, 0x5260},
        {0x768E, 0x5261},
        {0x77EF, 0x5262},
        {0x7D5E, 0x5263},
        {0x7FF9, 0x5264},
        {0x81A0, 0x5265},
        {0x854E, 0x5266},
        {0x86DF, 0x5267},
        {0x8F03, 0x5268},
        {0x8F4E, 0x5269},
        {0x90CA, 0x526A},
        {0x9278, 0x526B},
        {0x9903, 0x526C},
        {0x9A55, 0x526D},
        {0x9BAB, 0x526E},
        {0x4E18, 0x526F},
        {0x4E45, 0x5270},
        {0x4E5D, 0x5271},
        {0x4EC7, 0x5272},
        {0x4F5D, 0x5273},
        {0x4FF1, 0x5274},
        {0x50B4, 0x5275},
        {0x5177, 0x5276},
        {0x52FE, 0x5277},
        {0x5340, 0x5278},
        {0x53E3, 0x5279},
        {0x53E5, 0x527A},
        {0x548E, 0x527B},
        {0x5614, 0x527C},
        {0x57A2, 0x527D},
        {0x5ABE, 0x527E},
        {0x5AD7, 0x527F},
        {0x5BC7, 0x5280},
        {0x5D87, 0x5281},
        {0x5ED0, 0x5282},
        {0x61FC, 0x5283},
        {0x62D8, 0x5284},
        {0x6551, 0x5285},
        {0xF8FB, 0x5286},
        {0x67B8, 0x5287},
        {0x67E9, 0x5288},
        {0x69CB, 0x5289},
        {0x6B50, 0x528A},
        {0x6BC6, 0x528B},
        {0x6BEC, 0x528C},
        {0x6C42, 0x528D},
        {0x6E9D, 0x528E},
        {0x7078, 0x528F},
        {0x72D7, 0x5290},
        {0x7396, 0x5291},
        {0x7403, 0x5292},
        {0x750C, 0x5293},
        {0x77BF, 0x5294},
        {0x77E9, 0x5295},
        {0x7A76, 0x5296},
        {0x7D7F, 0x5297},
        {0x8CFC, 0x5298},
        {0x81FC, 0x5299},
        {0x8205, 0x529A},
        {0x820A, 0x529B},
        {0x82DF, 0x529C},
        {0x8862, 0x529D},
        {0x89AF, 0x529E},
        {0x8B33, 0x529F},
        {0x8EC0, 0x52A0},
        {0x9011, 0x52A1},
        {0x90B1, 0x52A2},
        {0x9264, 0x52A3},
        {0x98B6, 0x52A4},
        {0x99D2, 0x52A5},
        {0x9A45, 0x52A6},
        {0x9CE9, 0x52A7},
        {0x9DD7, 0x52A8},
        {0x9F9C, 0x52A9},
        {0x570B, 0x52AA},
        {0x5C40, 0x52AB},
        {0x63AC, 0x52AC},
        {0x83CA, 0x52AD},
        {0x97A0, 0x52AE},
        {0x9EB4, 0x52AF},
        {0x7A98, 0x52B0},
        {0x7FA4, 0x52B1},
        {0x8ECD, 0x52B2},
        {0x541B, 0x52B3},
        {0x90E1, 0x52B4},
        {0x5800, 0x52B5},
        {0x5C48, 0x52B6},
        {0x6398, 0x52B7},
        {0x7A9F, 0x52B8},
        {0x5BAE, 0x52B9},
        {0x5F13, 0x52BA},
        {0x7A79, 0x52BB},
        {0x7AAE, 0x52BC},
        {0x8EAC, 0x52BD},
        {0x5026, 0x52BE},
        {0x5238, 0x52BF},
        {0x52F8, 0x52C0},
        {0x5377, 0x52C1},
        {0x5708, 0x52C2},
        {0x62F3, 0x52C3},
        {0x6B0A, 0x52C4},
        {0x7737, 0x52C5},
        {0x53A5, 0x52C6},
        {0x8E76, 0x52C7},
        {0x95D5, 0x52C8},
        {0x673A, 0x52C9},
        {0x6AC3, 0x52CA},
        {0x6F70, 0x52CB},
        {0x8A6D, 0x52CC},
        {0x8DEA, 0x52CD},
        {0x8ECC, 0x52CE},
        {0x994B, 0x52CF},
        {0x6B78, 0x52D0},
        {0x8CB4, 0x52D1},
        {0x9B3C, 0x52D2},
        {0xF907, 0x52D3},
        {0x53EB, 0x52D4},
        {0x572D, 0x52D5},
        {0x594E, 0x52D6},
        {0x63C6, 0x52D7},
        {0x73EA, 0x52D8},
        {0x7845, 0x52D9},
        {0x7ABA, 0x52DA},
        {0x8475, 0x52DB},
        {0x7CFE, 0x52DC},
        {0x898F, 0x52DD},
        {0x8D73, 0x52DE},
        {0x9035, 0x52DF},
        {0x95A8, 0x52E0},
        {0x5747, 0x52E1},
        {0x7B60, 0x52E2},
        {0x83CC, 0x52E3},
        {0x921E, 0x52E4},
        {0xF908, 0x52E5},
        {0x6A58, 0x52E6},
        {0x514B, 0x52E7},
        {0x524B, 0x52E8},
        {0x5287, 0x52E9},
        {0x621F, 0x52EA},
        {0x6975, 0x52EB},
        {0x68D8, 0x52EC},
        {0x9699, 0x52ED},
        {0x50C5, 0x52EE},
        {0x52E4, 0x52EF},
        {0x5DF9, 0x52F0},
        {0x61C3, 0x52F1},
        {0x65A4, 0x52F2},
        {0x6839, 0x52F3},
        {0x69FF, 0x52F4},
        {0x6F0C, 0x52F5},
        {0x747E, 0x52F6},
        {0x7B4B, 0x52F7},
        {0x82B9, 0x52F8},
        {0x83EB, 0x52F9},
        {0x89B2, 0x52FA},
        {0x8B39, 0x52FB},
        {0x8FD1, 0x52FC},
        {0x9949, 0x52FD},
        {0xF909, 0x52FE},
        {0x4ECA, 0x5341},
        {0x64D2, 0x5342},
        {0x6A8E, 0x5343},
        {0x7434, 0x5344},
        {0x7981, 0x5345},
        {0x79BD, 0x5346},
        {0x887F, 0x5347},
        {0x887E, 0x5348},
        {0x895F, 0x5349},
        {0xF90A, 0x534A},
        {0x9326, 0x534B},
        {0x53CA, 0x534C},
        {0x5C8C, 0x534D},
        {0x6025, 0x534E},
        {0x6271, 0x534F},
        {0x6C72, 0x5350},
        {0x7B08, 0x5351},
        {0x7D1A, 0x5352},
        {0x7D66, 0x5353},
        {0x4E98, 0x5354},
        {0x5162, 0x5355},
        {0x77DC, 0x5356},
        {0x80AF, 0x5357},
        {0x4F01, 0x5358},
        {0x4F0E, 0x5359},
        {0x5176, 0x535A},
        {0x5180, 0x535B},
        {0x55DC, 0x535C},
        {0x5668, 0x535D},
        {0x573B, 0x535E},
        {0x57FA, 0x535F},
        {0x5914, 0x5360},
        {0x5947, 0x5361},
        {0x5993, 0x5362},
        {0x5BC4, 0x5363},
        {0x5C90, 0x5364},
        {0x8C48, 0x5365},
        {0x5D0E, 0x5366},
        {0x5E7E, 0x5367},
        {0x5DF1, 0x5368},
        {0x5FCC, 0x5369},
        {0x6280, 0x536A},
        {0x65D7, 0x536B},
        {0x65E3, 0x536C},
        {0x671F, 0x536D},
        {0x675E, 0x536E},
        {0x68CB, 0x536F},
        {0x68C4, 0x5370},
        {0x6A5F, 0x5371},
        {0x6B3A, 0x5372},
        {0x6C23, 0x5373},
        {0x6C7D, 0x5374},
        {0x6C82, 0x5375},
        {0x6DC7, 0x5376},
        {0x7426, 0x5377},
        {0x742A, 0x5378},
        {0x74A3, 0x5379},
        {0x7578, 0x537A},
        {0x757F, 0x537B},
        {0x7881, 0x537C},
        {0x78EF, 0x537D},
        {0x7947, 0x537E},
        {0x7948, 0x537F},
        {0x797A, 0x5380},
        {0x7B95, 0x5381},
        {0x7D00, 0x5382},
        {0x7DBA, 0x5383},
        {0xF8FA, 0x5384},
        {0x8006, 0x5385},
        {0x802D, 0x5386},
        {0x808C, 0x5387},
        {0x671E, 0x5388},
        {0x8A18, 0x5389},
        {0x8B4F, 0x538A},
        {0x8D77, 0x538B},
        {0x9321, 0x538C},
        {0x98E2, 0x538D},
        {0x9951, 0x538E},
        {0x9A0E, 0x538F},
        {0x9A0F, 0x5390},
        {0x9A65, 0x5391},
        {0x9C2D, 0x5392},
        {0x9E92, 0x5393},
        {0x7DCA, 0x5394},
        {0x4F76, 0x5395},
        {0x5409, 0x5396},
        {0x62EE, 0x5397},
        {0x6854, 0x5398},
        {0x91D1, 0x5399},
        {0xF8F9, 0x539A},
        {0x55AB, 0x539B},
        {0x513A, 0x539C},
        {0x61E6, 0x539D},
        {0x62CF, 0x539E},
        {0x62FF, 0x539F},
        {0x7CEF, 0x53A0},
        {0x90A3, 0x53A1},
        {0x8AFE, 0x53A2},
        {0x6696, 0x53A3},
        {0x7156, 0x53A4},
        {0x96E3, 0x53A5},
        {0x637A, 0x53A6},
        {0x634F, 0x53A7},
        {0x5357, 0x53A8},
        {0x5583, 0x53A9},
        {0x7537, 0x53AA},
        {0x7D0D, 0x53AB},
        {0x56CA, 0x53AC},
        {0x5A18, 0x53AD},
        {0x66E9, 0x53AE},
        {0x4E43, 0x53AF},
        {0x5167, 0x53B0},
        {0x5948, 0x53B1},
        {0x67F0, 0x53B2},
        {0x8010, 0x53B3},
        {0x8FFA, 0x53B4},
        {0x5973, 0x53B5},
        {0x5E74, 0x53B6},
        {0x79CA, 0x53B7},
        {0x5FF5, 0x53B8},
        {0x606C, 0x53B9},
        {0x62C8, 0x53BA},
        {0x637B, 0x53BB},
        {0x4F5E, 0x53BC},
        {0x5BE7, 0x53BD},
        {0xF8F8, 0x53BE},
        {0x52AA, 0x53BF},
        {0x5974, 0x53C0},
        {0x5B65, 0x53C1},
        {0x5F29, 0x53C2},
        {0x6012, 0x53C3},
        {0x7459, 0x53C4},
        {0x6FC3, 0x53C5},
        {0x81BF, 0x53C6},
        {0x8FB2, 0x53C7},
        {0x60F1, 0x53C8},
        {0x8166, 0x53C9},
        {0x5C3F, 0x53CA},
        {0xF8F7, 0x53CB},
        {0x5AE9, 0x53CC},
        {0x8A25, 0x53CD},
        {0x7D10, 0x53CE},
        {0x80FD, 0x53CF},
        {0x5C3C, 0x53D0},
        {0x6CE5, 0x53D1},
        {0x533F, 0x53D2},
        {0x6EBA, 0x53D3},
        {0x591A, 0x53D4},
        {0x8336, 0x53D5},
        {0x4E39, 0x53D6},
        {0x4F46, 0x53D7},
        {0x55AE, 0x53D8},
        {0x5718, 0x53D9},
        {0x58C7, 0x53DA},
        {0x65B7, 0x53DB},
        {0x65E6, 0x53DC},
        {0x6A80, 0x53DD},
        {0x6BB5, 0x53DE},
        {0x6E4D, 0x53DF},
        {0x77ED, 0x53E0},
        {0x7AEF, 0x53E1},
        {0x7C1E, 0x53E2},
        {0x7DDE, 0x53E3},
        {0x86CB, 0x53E4},
        {0x8892, 0x53E5},
        {0x9132, 0x53E6},
        {0x935B, 0x53E7},
        {0x977C, 0x53E8},
        {0x601B, 0x53E9},
        {0x64BB, 0x53EA},
        {0x737A, 0x53EB},
        {0x75B8, 0x53EC},
        {0x9054, 0x53ED},
        {0x95E5, 0x53EE},
        {0x97C3, 0x53EF},
        {0x5556, 0x53F0},
        {0x64D4, 0x53F1},
        {0x66C7, 0x53F2},
        {0x6DE1, 0x53F3},
        {0x6F6D, 0x53F4},
        {0x6FB9, 0x53F5},
        {0x75F0, 0x53F6},
        {0x8043, 0x53F7},
        {0x81BD, 0x53F8},
        {0x8983, 0x53F9},
        {0x8AC7, 0x53FA},
        {0x8B5A, 0x53FB},
        {0x6C93, 0x53FC},
        {0x7B54, 0x53FD},
        {0x8E0F, 0x53FE},
        {0x905D, 0x5441},
        {0x515A, 0x5442},
        {0x5802, 0x5443},
        {0x5858, 0x5444},
        {0x5E62, 0x5445},
        {0x5510, 0x5446},
        {0x649E, 0x5447},
        {0x68E0, 0x5448},
        {0x7576, 0x5449},
        {0x7CD6, 0x544A},
        {0x87F7, 0x544B},
        {0x9EE8, 0x544C},
        {0x4EE3, 0x544D},
        {0x5788, 0x544E},
        {0x5927, 0x544F},
        {0x5C0D, 0x5450},
        {0x5CB1, 0x5451},
        {0x5E36, 0x5452},
        {0x5F85, 0x5453},
        {0x6234, 0x5454},
        {0x64E1, 0x5455},
        {0x73B3, 0x5456},
        {0x7893, 0x5457},
        {0x81FA, 0x5458},
        {0x888B, 0x5459},
        {0x8CB8, 0x545A},
        {0x968A, 0x545B},
        {0x9EDB, 0x545C},
        {0x5B85, 0x545D},
        {0x5FB7, 0x545E},
        {0x60B3, 0x545F},
        {0x5012, 0x5460},
        {0x5200, 0x5461},
        {0x5230, 0x5462},
        {0x5716, 0x5463},
        {0x5835, 0x5464},
        {0x5857, 0x5465},
        {0x5C0E, 0x5466},
        {0x5C60, 0x5467},
        {0x5CF6, 0x5468},
        {0x5EA6, 0x5469},
        {0x5F92, 0x546A},
        {0x60BC, 0x546B},
        {0x6311, 0x546C},
        {0x6417, 0x546D},
        {0x6843, 0x546E},
        {0x68F9, 0x546F},
        {0x6DD8, 0x5470},
        {0x6E21, 0x5471},
        {0x6ED4, 0x5472},
        {0x6FE4, 0x5473},
        {0x71FE, 0x5474},
        {0x76DC, 0x5475},
        {0x7779, 0x5476},
        {0x79B1, 0x5477},
        {0x7A3B, 0x5478},
        {0x8404, 0x5479},
        {0x83DF, 0x547A},
        {0x8CED, 0x547B},
        {0x8DF3, 0x547C},
        {0x8E48, 0x547D},
        {0x9003, 0x547E},
        {0x9014, 0x547F},
        {0x9053, 0x5480},
        {0x90FD, 0x5481},
        {0x934D, 0x5482},
        {0x9676, 0x5483},
        {0x97DC, 0x5484},
        {0x6BD2, 0x5485},
        {0x7006, 0x5486},
        {0x7258, 0x5487},
        {0x72A2, 0x5488},
        {0x7368, 0x5489},
        {0x7763, 0x548A},
        {0x79BF, 0x548B},
        {0x7BE4, 0x548C},
        {0x7E9B, 0x548D},
        {0x8B80, 0x548E},
        {0x58A9, 0x548F},
        {0x60C7, 0x5490},
        {0x6566, 0x5491},
        {0x66BE, 0x5492},
        {0x6C8C, 0x5493},
        {0x71C9, 0x5494},
        {0x8C5A, 0x5495},
        {0x9813, 0x5496},
        {0x5484, 0x5497},
        {0x4E6D, 0x5498},
        {0x7A81, 0x5499},
        {0x4EDD, 0x549A},
        {0x51AC, 0x549B},
        {0x51CD, 0x549C},
        {0x52D5, 0x549D},
        {0x540C, 0x549E},
        {0x578C, 0x549F},
        {0x61A7, 0x54A0},
        {0x6771, 0x54A1},
        {0x6850, 0x54A2},
        {0x68DF, 0x54A3},
        {0x6D1E, 0x54A4},
        {0x6F7C, 0x54A5},
        {0x7AE5, 0x54A6},
        {0x75BC, 0x54A7},
        {0x77B3, 0x54A8},
        {0x8463, 0x54A9},
        {0x80F4, 0x54AA},
        {0x9285, 0x54AB},
        {0x515C, 0x54AC},
        {0x6597, 0x54AD},
        {0x675C, 0x54AE},
        {0x6793, 0x54AF},
        {0x75D8, 0x54B0},
        {0x7AC7, 0x54B1},
        {0x8373, 0x54B2},
        {0x809A, 0x54B3},
        {0x86AA, 0x54B4},
        {0xF95A, 0x54B5},
        {0x8C46, 0x54B6},
        {0x982D, 0x54B7},
        {0x5C6F, 0x54B8},
        {0x81C0, 0x54B9},
        {0x9041, 0x54BA},
        {0x906F, 0x54BB},
        {0x920D, 0x54BC},
        {0x5F97, 0x54BD},
        {0x6A59, 0x54BE},
        {0x6ED5, 0x54BF},
        {0x706F, 0x54C0},
        {0x71C8, 0x54C1},
        {0x767B, 0x54C2},
        {0x7B49, 0x54C3},
        {0x85E4, 0x54C4},
        {0x8B04, 0x54C5},
        {0x9127, 0x54C6},
        {0x9419, 0x54C7},
        {0x9A30, 0x54C8},
        {0x5587, 0x54C9},
        {0x61F6, 0x54CA},
        {0x7669, 0x54CB},
        {0x7F85, 0x54CC},
        {0x863F, 0x54CD},
        {0x87BA, 0x54CE},
        {0x88F8, 0x54CF},
        {0x908F, 0x54D0},
        {0xF95C, 0x54D1},
        {0x6D1B, 0x54D2},
        {0x70D9, 0x54D3},
        {0x7296, 0x54D4},
        {0x73DE, 0x54D5},
        {0x7D61, 0x54D6},
        {0x843D, 0x54D7},
        {0x916A, 0x54D8},
        {0x99F1, 0x54D9},
        {0x4E82, 0x54DA},
        {0x5375, 0x54DB},
        {0x5E71, 0x54DC},
        {0x6B04, 0x54DD},
        {0x6B12, 0x54DE},
        {0x703E, 0x54DF},
        {0x721B, 0x54E0},
        {0x862D, 0x54E1},
        {0x9E1E, 0x54E2},
        {0x524C, 0x54E3},
        {0x57D3, 0x54E4},
        {0x8FA3, 0x54E5},
        {0x5D50, 0x54E6},
        {0x64E5, 0x54E7},
        {0x652C, 0x54E8},
        {0x6B16, 0x54E9},
        {0x6FEB, 0x54EA},
        {0x7C43, 0x54EB},
        {0x7E9C, 0x54EC},
        {0x85CD, 0x54ED},
        {0x8964, 0x54EE},
        {0x89BD, 0x54EF},
        {0x62C9, 0x54F0},
        {0x81D8, 0x54F1},
        {0x881F, 0x54F2},
        {0x5ECA, 0x54F3},
        {0x6717, 0x54F4},
        {0x6994, 0x54F5},
        {0x6D6A, 0x54F6},
        {0x72FC, 0x54F7},
        {0x7405, 0x54F8},
        {0x746F, 0x54F9},
        {0x8782, 0x54FA},
        {0x90DE, 0x54FB},
        {0x4F86, 0x54FC},
        {0x840A, 0x54FD},
        {0x51B7, 0x54FE},
        {0x63A0, 0x5541},
        {0x7565, 0x5542},
        {0x4EAE, 0x5543},
        {0x5169, 0x5544},
        {0x5006, 0x5545},
        {0x51C9, 0x5546},
        {0x6881, 0x5547},
        {0x6DBC, 0x5548},
        {0x6A11, 0x5549},
        {0x7CAE, 0x554A},
        {0x7CB1, 0x554B},
        {0x7CE7, 0x554C},
        {0x826F, 0x554D},
        {0x8AD2, 0x554E},
        {0x8F1B, 0x554F},
        {0x91CF, 0x5550},
        {0x9B4E, 0x5551},
        {0x4FB6, 0x5552},
        {0x52F5, 0x5553},
        {0x5442, 0x5554},
        {0x5EEC, 0x5555},
        {0x623E, 0x5556},
        {0x65C5, 0x5557},
        {0x6ADA, 0x5558},
        {0x6FFE, 0x5559},
        {0x7658, 0x555A},
        {0x792A, 0x555B},
        {0x8182, 0x555C},
        {0x85DC, 0x555D},
        {0x616E, 0x555E},
        {0x8823, 0x555F},
        {0x8821, 0x5560},
        {0x9462, 0x5561},
        {0x95AD, 0x5562},
        {0x9A62, 0x5563},
        {0x9A6A, 0x5564},
        {0x9E97, 0x5565},
        {0x9ECE, 0x5566},
        {0x529B, 0x5567},
        {0x6B77, 0x5568},
        {0x66C6, 0x5569},
        {0x6ADF, 0x556A},
        {0x701D, 0x556B},
        {0x792B, 0x556C},
        {0x8F62, 0x556D},
        {0x9742, 0x556E},
        {0x6190, 0x556F},
        {0x6200, 0x5570},
        {0x6523, 0x5571},
        {0x6F23, 0x5572},
        {0x7149, 0x5573},
        {0x7DF4, 0x5574},
        {0x806F, 0x5575},
        {0x84EE, 0x5576},
        {0x8F26, 0x5577},
        {0x9023, 0x5578},
        {0x934A, 0x5579},
        {0x51BD, 0x557A},
        {0x52A3, 0x557B},
        {0x5217, 0x557C},
        {0x6D0C, 0x557D},
        {0x70C8, 0x557E},
        {0x88C2, 0x557F},
        {0x5EC9, 0x5580},
        {0x6582, 0x5581},
        {0x6BAE, 0x5582},
        {0x6FC2, 0x5583},
        {0x7C3E, 0x5584},
        {0x7375, 0x5585},
        {0x9B23, 0x5586},
        {0x4EE4, 0x5587},
        {0x4F36, 0x5588},
        {0x56F9, 0x5589},
        {0x5DBA, 0x558A},
        {0x601C, 0x558B},
        {0x6624, 0x558C},
        {0x6CE0, 0x558D},
        {0x73B2, 0x558E},
        {0x7F9A, 0x558F},
        {0x7FCE, 0x5590},
        {0x82D3, 0x5591},
        {0x86C9, 0x5592},
        {0x901E, 0x5593},
        {0x96F6, 0x5594},
        {0x9748, 0x5595},
        {0x9234, 0x5596},
        {0x9818, 0x5597},
        {0x9F61, 0x5598},
        {0x4F8B, 0x5599},
        {0x79AE, 0x559A},
        {0x91B4, 0x559B},
        {0x96B7, 0x559C},
        {0x52DE, 0x559D},
        {0x6488, 0x559E},
        {0x6AD3, 0x559F},
        {0x6F66, 0x55A0},
        {0x7210, 0x55A1},
        {0x7018, 0x55A2},
        {0x76E7, 0x55A3},
        {0x8001, 0x55A4},
        {0x826B, 0x55A5},
        {0x8606, 0x55A6},
        {0x865C, 0x55A7},
        {0x8DEF, 0x55A8},
        {0x8F05, 0x55A9},
        {0x8F64, 0x55AA},
        {0x9732, 0x55AB},
        {0x9B6F, 0x55AC},
        {0x9DFA, 0x55AD},
        {0x9E75, 0x55AE},
        {0x6F09, 0x55AF},
        {0x788C, 0x55B0},
        {0xF8F6, 0x55B1},
        {0x7DA0, 0x55B2},
        {0x8F46, 0x55B3},
        {0x9304, 0x55B4},
        {0x9E93, 0x55B5},
        {0x9E7F, 0x55B6},
        {0x8AD6, 0x55B7},
        {0x58DF, 0x55B8},
        {0x5F04, 0x55B9},
        {0x6727, 0x55BA},
        {0x7027, 0x55BB},
        {0x74CF, 0x55BC},
        {0x7C60, 0x55BD},
        {0x807E, 0x55BE},
        {0x5121, 0x55BF},
        {0x7262, 0x55C0},
        {0x78CA, 0x55C1},
        {0x7C5F, 0x55C2},
        {0x857E, 0x55C3},
        {0x8A84, 0x55C4},
        {0x8CF4, 0x55C5},
        {0x8CC2, 0x55C6},
        {0x96F7, 0x55C7},
        {0x4E86, 0x55C8},
        {0x50DA, 0x55C9},
        {0xF8F5, 0x55CA},
        {0x5BEE, 0x55CB},
        {0x5ED6, 0x55CC},
        {0x71CE, 0x55CD},
        {0x7642, 0x55CE},
        {0x77AD, 0x55CF},
        {0x6599, 0x55D0},
        {0x804A, 0x55D1},
        {0x84FC, 0x55D2},
        {0x907C, 0x55D3},
        {0x9F8D, 0x55D4},
        {0x50C2, 0x55D5},
        {0x58D8, 0x55D6},
        {0x5C62, 0x55D7},
        {0x6A13, 0x55D8},
        {0x6DDA, 0x55D9},
        {0x6F0F, 0x55DA},
        {0x7D2F, 0x55DB},
        {0x7E37, 0x55DC},
        {0x8938, 0x55DD},
        {0x964B, 0x55DE},
        {0x9ACF, 0x55DF},
        {0x5289, 0x55E0},
        {0x67F3, 0x55E1},
        {0x69B4, 0x55E2},
        {0x6D41, 0x55E3},
        {0x6E9C, 0x55E4},
        {0x7409, 0x55E5},
        {0x7460, 0x55E6},
        {0x7559, 0x55E7},
        {0x7624, 0x55E8},
        {0x786B, 0x55E9},
        {0x8B2C, 0x55EA},
        {0x985E, 0x55EB},
        {0x516D, 0x55EC},
        {0x622E, 0x55ED},
        {0x9678, 0x55EE},
        {0x502B, 0x55EF},
        {0x5D19, 0x55F0},
        {0x6DEA, 0x55F1},
        {0x7DB8, 0x55F2},
        {0x8F2A, 0x55F3},
        {0x5F8B, 0x55F4},
        {0x6144, 0x55F5},
        {0x6817, 0x55F6},
        {0xF961, 0x55F7},
        {0x7ABF, 0x55F8},
        {0x9686, 0x55F9},
        {0x808B, 0x55FA},
        {0x52D2, 0x55FB},
        {0x51DB, 0x55FC},
        {0x5EE9, 0x55FD},
        {0x51CC, 0x55FE},
        {0x695E, 0x5641},
        {0x7A1C, 0x5642},
        {0x7DBE, 0x5643},
        {0x83F1, 0x5644},
        {0x9675, 0x5645},
        {0x4FDA, 0x5646},
        {0x5229, 0x5647},
        {0x5398, 0x5648},
        {0x540F, 0x5649},
        {0x5C65, 0x564A},
        {0x60A7, 0x564B},
        {0xF8F4, 0x564C},
        {0x674E, 0x564D},
        {0x68A8, 0x564E},
        {0x6F13, 0x564F},
        {0x7281, 0x5650},
        {0x72F8, 0x5651},
        {0x7406, 0x5652},
        {0x7483, 0x5653},
        {0x75E2, 0x5654},
        {0x79BB, 0x5655},
        {0x7F79, 0x5656},
        {0x7C6C, 0x5657},
        {0x87AD, 0x5658},
        {0x88CF, 0x5659},
        {0x91CC, 0x565A},
        {0x91D0, 0x565B},
        {0x96E2, 0x565C},
        {0x9B51, 0x565D},
        {0x9BC9, 0x565E},
        {0x541D, 0x565F},
        {0x71D0, 0x5660},
        {0x7498, 0x5661},
        {0x85FA, 0x5662},
        {0x8EAA, 0x5663},
        {0x96A3, 0x5664},
        {0x9C57, 0x5665},
        {0x9E9F, 0x5666},
        {0x6797, 0x5667},
        {0x6DCB, 0x5668},
        {0x7433, 0x5669},
        {0x75F3, 0x566A},
        {0x81E8, 0x566B},
        {0x9716, 0x566C},
        {0x5CA6, 0x566D},
        {0x782C, 0x566E},
        {0x7ACB, 0x566F},
        {0x7B20, 0x5670},
        {0x7C92, 0x5671},
        {0x5ABD, 0x5672},
        {0x6469, 0x5673},
        {0x746A, 0x5674},
        {0x75F2, 0x5675},
        {0x78E8, 0x5676},
        {0x87C7, 0x5677},
        {0x99AC, 0x5678},
        {0x9B54, 0x5679},
        {0x9EBB, 0x567A},
        {0x5BDE, 0x567B},
        {0x5E55, 0x567C},
        {0x6F20, 0x567D},
        {0x819C, 0x567E},
        {0x83AB, 0x567F},
        {0x5A29, 0x5680},
        {0x5DD2, 0x5681},
        {0x5F4E, 0x5682},
        {0x6162, 0x5683},
        {0x633D, 0x5684},
        {0x6669, 0x5685},
        {0x66FC, 0x5686},
        {0x6EFF, 0x5687},
        {0x6F2B, 0x5688},
        {0x7063, 0x5689},
        {0x779E, 0x568A},
        {0x842C, 0x568B},
        {0x8513, 0x568C},
        {0x883B, 0x568D},
        {0x8B3E, 0x568E},
        {0x8F13, 0x568F},
        {0x93DD, 0x5690},
        {0x9945, 0x5691},
        {0x9B18, 0x5692},
        {0x9C3B, 0x5693},
        {0x62B9, 0x5694},
        {0x672B, 0x5695},
        {0x6CAB, 0x5696},
        {0x896A, 0x5697},
        {0x977A, 0x5698},
        {0x4EA1, 0x5699},
        {0x5984, 0x569A},
        {0x5FD8, 0x569B},
        {0x5FD9, 0x569C},
        {0x671B, 0x569D},
        {0x7DB2, 0x569E},
        {0x7F54, 0x569F},
        {0x8292, 0x56A0},
        {0x832B, 0x56A1},
        {0x83BD, 0x56A2},
        {0x9099, 0x56A3},
        {0x9B4D, 0x56A4},
        {0x57CB, 0x56A5},
        {0x59B9, 0x56A6},
        {0x5A92, 0x56A7},
        {0x5BD0, 0x56A8},
        {0x6627, 0x56A9},
        {0x679A, 0x56AA},
        {0x6885, 0x56AB},
        {0x6BCF, 0x56AC},
        {0x7164, 0x56AD},
        {0x771B, 0x56AE},
        {0x7F75, 0x56AF},
        {0x82FA, 0x56B0},
        {0x8CB7, 0x56B1},
        {0x8CE3, 0x56B2},
        {0x9081, 0x56B3},
        {0x9B45, 0x56B4},
        {0x8108, 0x56B5},
        {0x8109, 0x56B6},
        {0x8C8A, 0x56B7},
        {0x964C, 0x56B8},
        {0x9A40, 0x56B9},
        {0x9EA5, 0x56BA},
        {0x5B5F, 0x56BB},
        {0x6C13, 0x56BC},
        {0x731B, 0x56BD},
        {0x76DF, 0x56BE},
        {0x76F2, 0x56BF},
        {0x840C, 0x56C0},
        {0x51AA, 0x56C1},
        {0x8993, 0x56C2},
        {0x4FDB, 0x56C3},
        {0x514D, 0x56C4},
        {0x52C9, 0x56C5},
        {0x5195, 0x56C6},
        {0x68C9, 0x56C7},
        {0x7704, 0x56C8},
        {0x7720, 0x56C9},
        {0x7DBF, 0x56CA},
        {0x7DEC, 0x56CB},
        {0x9762, 0x56CC},
        {0x9EB5, 0x56CD},
        {0x6EC5, 0x56CE},
        {0x8511, 0x56CF},
        {0x547D, 0x56D0},
        {0x51A5, 0x56D1},
        {0x540D, 0x56D2},
        {0x9CF4, 0x56D3},
        {0x660E, 0x56D4},
        {0x669D, 0x56D5},
        {0x6E9F, 0x56D6},
        {0x76BF, 0x56D7},
        {0x8317, 0x56D8},
        {0x879F, 0x56D9},
        {0x9169, 0x56DA},
        {0x9298, 0x56DB},
        {0x8882, 0x56DC},
        {0x4FAE, 0x56DD},
        {0x52DF, 0x56DE},
        {0x5E3D, 0x56DF},
        {0x59C6, 0x56E0},
        {0x6155, 0x56E1},
        {0x6478, 0x56E2},
        {0x66AE, 0x56E3},
        {0x5192, 0x56E4},
        {0x67D0, 0x56E5},
        {0x6A21, 0x56E6},
        {0x6BCD, 0x56E7},
        {0x6BDB, 0x56E8},
        {0x725F, 0x56E9},
        {0x7261, 0x56EA},
        {0x7738, 0x56EB},
        {0x77DB, 0x56EC},
        {0x8004, 0x56ED},
        {0x8017, 0x56EE},
        {0x8305, 0x56EF},
        {0x8B00, 0x56F0},
        {0x8B28, 0x56F1},
        {0x8C8C, 0x56F2},
        {0x927E, 0x56F3},
        {0x6728, 0x56F4},
        {0x6C90, 0x56F5},
        {0x7267, 0x56F6},
        {0x76EE, 0x56F7},
        {0x7766, 0x56F8},
        {0x7A46, 0x56F9},
        {0x6B7F, 0x56FA},
        {0x6C92, 0x56FB},
        {0x5922, 0x56FC},
        {0x6726, 0x56FD},
        {0x6FDB, 0x56FE},
        {0x77C7, 0x5741},
        {0x8499, 0x5742},
        {0x536F, 0x5743},
        {0x5893, 0x5744},
        {0x5999, 0x5745},
        {0x5EDF, 0x5746},
        {0x63CF, 0x5747},
        {0x6634, 0x5748},
        {0x6773, 0x5749},
        {0x6E3A, 0x574A},
        {0x732B, 0x574B},
        {0x82D7, 0x574C},
        {0x9328, 0x574D},
        {0x52D9, 0x574E},
        {0x5DEB, 0x574F},
        {0x61CB, 0x5750},
        {0x620A, 0x5751},
        {0x62C7, 0x5752},
        {0x64AB, 0x5753},
        {0x65E0, 0x5754},
        {0x6B66, 0x5755},
        {0x6BCB, 0x5756},
        {0x7121, 0x5757},
        {0x755D, 0x5758},
        {0x7E46, 0x5759},
        {0x821E, 0x575A},
        {0x8302, 0x575B},
        {0x856A, 0x575C},
        {0x8AA3, 0x575D},
        {0x8CBF, 0x575E},
        {0x9727, 0x575F},
        {0x9D61, 0x5760},
        {0x58A8, 0x5761},
        {0x9ED8, 0x5762},
        {0x520E, 0x5763},
        {0x543B, 0x5764},
        {0x6587, 0x5765},
        {0x6C76, 0x5766},
        {0x7D0B, 0x5767},
        {0x7D0A, 0x5768},
        {0x868A, 0x5769},
        {0x9580, 0x576A},
        {0x554F, 0x576B},
        {0x805E, 0x576C},
        {0x52FF, 0x576D},
        {0x7269, 0x576E},
        {0x5473, 0x576F},
        {0x5A9A, 0x5770},
        {0x5C3E, 0x5771},
        {0x5D4B, 0x5772},
        {0x9761, 0x5773},
        {0x5F4C, 0x5774},
        {0x5FAE, 0x5775},
        {0x672A, 0x5776},
        {0x6E3C, 0x5777},
        {0x7030, 0x5778},
        {0x7709, 0x5779},
        {0x7C73, 0x577A},
        {0x7CDC, 0x577B},
        {0x7F8E, 0x577C},
        {0x8587, 0x577D},
        {0x8B0E, 0x577E},
        {0x8FF7, 0x577F},
        {0x60B6, 0x5780},
        {0x610D, 0x5781},
        {0x61AB, 0x5782},
        {0x654F, 0x5783},
        {0x65FC, 0x5784},
        {0x65FB, 0x5785},
        {0x6C11, 0x5786},
        {0x6CEF, 0x5787},
        {0x739F, 0x5788},
        {0x73C9, 0x5789},
        {0x9594, 0x578A},
        {0x95A9, 0x578B},
        {0x5BC6, 0x578C},
        {0x871C, 0x578D},
        {0x8B10, 0x578E},
        {0xF8F3, 0x578F},
        {0x525D, 0x5790},
        {0x535A, 0x5791},
        {0x62CD, 0x5792},
        {0x640F, 0x5793},
        {0x64B2, 0x5794},
        {0x6734, 0x5795},
        {0x6A38, 0x5796},
        {0x6B02, 0x5797},
        {0x6CCA, 0x5798},
        {0x7254, 0x5799},
        {0x73C0, 0x579A},
        {0x749E, 0x579B},
        {0x7B94, 0x579C},
        {0x7E1B, 0x579D},
        {0x7C95, 0x579E},
        {0x818A, 0x579F},
        {0x8236, 0x57A0},
        {0x8584, 0x57A1},
        {0x8FEB, 0x57A2},
        {0x96F9, 0x57A3},
        {0x99C1, 0x57A4},
        {0x4F34, 0x57A5},
        {0x534A, 0x57A6},
        {0x53CD, 0x57A7},
        {0x53DB, 0x57A8},
        {0x62CC, 0x57A9},
        {0x642C, 0x57AA},
        {0x6500, 0x57AB},
        {0x6591, 0x57AC},
        {0x69C3, 0x57AD},
        {0x6F58, 0x57AE},
        {0x6CEE, 0x57AF},
        {0x73ED, 0x57B0},
        {0x7554, 0x57B1},
        {0x76E4, 0x57B2},
        {0x78FB, 0x57B3},
        {0x792C, 0x57B4},
        {0x7D46, 0x57B5},
        {0x80D6, 0x57B6},
        {0x87E0, 0x57B7},
        {0x822C, 0x57B8},
        {0x8FD4, 0x57B9},
        {0x9812, 0x57BA},
        {0x98EF, 0x57BB},
        {0x52C3, 0x57BC},
        {0x62D4, 0x57BD},
        {0x6F51, 0x57BE},
        {0x64A5, 0x57BF},
        {0x767C, 0x57C0},
        {0x8DCB, 0x57C1},
        {0x91B1, 0x57C2},
        {0x9262, 0x57C3},
        {0x9AEE, 0x57C4},
        {0x9B43, 0x57C5},
        {0x5023, 0x57C6},
        {0x508D, 0x57C7},
        {0x574A, 0x57C8},
        {0x59A8, 0x57C9},
        {0x5C28, 0x57CA},
        {0x5E47, 0x57CB},
        {0x5F77, 0x57CC},
        {0x623F, 0x57CD},
        {0x653E, 0x57CE},
        {0x65B9, 0x57CF},
        {0x65C1, 0x57D0},
        {0x6609, 0x57D1},
        {0x699C, 0x57D2},
        {0x7D21, 0x57D3},
        {0x80AA, 0x57D4},
        {0x8180, 0x57D5},
        {0x822B, 0x57D6},
        {0x82B3, 0x57D7},
        {0x84A1, 0x57D8},
        {0x868C, 0x57D9},
        {0x8A2A, 0x57DA},
        {0x8B17, 0x57DB},
        {0x90A6, 0x57DC},
        {0x9632, 0x57DD},
        {0x9AE3, 0x57DE},
        {0x9B74, 0x57DF},
        {0x9F90, 0x57E0},
        {0x4FF3, 0x57E1},
        {0x500D, 0x57E2},
        {0xF963, 0x57E3},
        {0x57F9, 0x57E4},
        {0x5F98, 0x57E5},
        {0x62DC, 0x57E6},
        {0x6392, 0x57E7},
        {0x676F, 0x57E8},
        {0x6E43, 0x57E9},
        {0x76C3, 0x57EA},
        {0x80DA, 0x57EB},
        {0x80CC, 0x57EC},
        {0x88F5, 0x57ED},
        {0x88F4, 0x57EE},
        {0x8919, 0x57EF},
        {0x8CE0, 0x57F0},
        {0x8F29, 0x57F1},
        {0x914D, 0x57F2},
        {0x966A, 0x57F3},
        {0x4F2F, 0x57F4},
        {0x4F70, 0x57F5},
        {0x5E1B, 0x57F6},
        {0x67CF, 0x57F7},
        {0x6822, 0x57F8},
        {0x767D, 0x57F9},
        {0x767E, 0x57FA},
        {0x9B44, 0x57FB},
        {0x6A0A, 0x57FC},
        {0xF8F2, 0x57FD},
        {0x7169, 0x57FE},
        {0x756A, 0x5841},
        {0xF964, 0x5842},
        {0x7E41, 0x5843},
        {0x7FFB, 0x5844},
        {0x8543, 0x5845},
        {0x85E9, 0x5846},
        {0x98DC, 0x5847},
        {0x4F10, 0x5848},
        {0x7B4F, 0x5849},
        {0x7F70, 0x584A},
        {0x95A5, 0x584B},
        {0x51E1, 0x584C},
        {0x5E06, 0x584D},
        {0x68B5, 0x584E},
        {0x6C3E, 0x584F},
        {0x6C4E, 0x5850},
        {0x6CDB, 0x5851},
        {0x72AF, 0x5852},
        {0x7BC4, 0x5853},
        {0x8303, 0x5854},
        {0x6CD5, 0x5855},
        {0x743A, 0x5856},
        {0x50FB, 0x5857},
        {0x5288, 0x5858},
        {0x58C1, 0x5859},
        {0x64D8, 0x585A},
        {0x74A7, 0x585B},
        {0x7656, 0x585C},
        {0x78A7, 0x585D},
        {0x8F9F, 0x585E},
        {0x95E2, 0x585F},
        {0x9739, 0x5860},
        {0xF965, 0x5861},
        {0x535E, 0x5862},
        {0x5F01, 0x5863},
        {0x6C74, 0x5864},
        {0x8FAE, 0x5865},
        {0x8B8A, 0x5866},
        {0x8FA8, 0x5867},
        {0x8FAF, 0x5868},
        {0xF8F1, 0x5869},
        {0x908A, 0x586A},
        {0x99E2, 0x586B},
        {0x5225, 0x586C},
        {0x5F46, 0x586D},
        {0x77A5, 0x586E},
        {0x9C49, 0x586F},
        {0x9F08, 0x5870},
        {0x4E19, 0x5871},
        {0x5002, 0x5872},
        {0x5175, 0x5873},
        {0x5C5B, 0x5874},
        {0x5E77, 0x5875},
        {0x661E, 0x5876},
        {0x663A, 0x5877},
        {0x67C4, 0x5878},
        {0x70B3, 0x5879},
        {0x7501, 0x587A},
        {0x75C5, 0x587B},
        {0x7ADD, 0x587C},
        {0x79C9, 0x587D},
        {0x8F27, 0x587E},
        {0x8FF8, 0x587F},
        {0x9920, 0x5880},
        {0x4FDD, 0x5881},
        {0x5821, 0x5882},
        {0x5831, 0x5883},
        {0x5BF6, 0x5884},
        {0x666E, 0x5885},
        {0x6B65, 0x5886},
        {0x6E7A, 0x5887},
        {0x6D11, 0x5888},
        {0x6F7D, 0x5889},
        {0x752B, 0x588A},
        {0x88DC, 0x588B},
        {0x8913, 0x588C},
        {0x8B5C, 0x588D},
        {0x8F14, 0x588E},
        {0x9D07, 0x588F},
        {0x9EFC, 0x5890},
        {0x4F0F, 0x5891},
        {0x50D5, 0x5892},
        {0x5310, 0x5893},
        {0x535C, 0x5894},
        {0x5B93, 0x5895},
        {0x5FA9, 0x5896},
        {0x798F, 0x5897},
        {0x670D, 0x5898},
        {0x8179, 0x5899},
        {0x832F, 0x589A},
        {0x8514, 0x589B},
        {0x8986, 0x589C},
        {0x8760, 0x589D},
        {0x8907, 0x589E},
        {0x8F3B, 0x589F},
        {0x99A5, 0x58A0},
        {0x9C12, 0x58A1},
        {0x672C, 0x58A2},
        {0x4E76, 0x58A3},
        {0x4E30, 0x58A4},
        {0x4FF8, 0x58A5},
        {0x5949, 0x58A6},
        {0x5C01, 0x58A7},
        {0x5CF0, 0x58A8},
        {0x5CEF, 0x58A9},
        {0x6367, 0x58AA},
        {0x742B, 0x58AB},
        {0x68D2, 0x58AC},
        {0x70FD, 0x58AD},
        {0x7E2B, 0x58AE},
        {0x8451, 0x58AF},
        {0x84EC, 0x58B0},
        {0x8702, 0x58B1},
        {0x9022, 0x58B2},
        {0x92D2, 0x58B3},
        {0x9CF3, 0x58B4},
        {0x4EC6, 0x58B5},
        {0x4ED8, 0x58B6},
        {0x5085, 0x58B7},
        {0x5256, 0x58B8},
        {0x526F, 0x58B9},
        {0x5426, 0x58BA},
        {0x57E0, 0x58BB},
        {0x592B, 0x58BC},
        {0x5A66, 0x58BD},
        {0x5B75, 0x58BE},
        {0x5BCC, 0x58BF},
        {0x5E9C, 0x58C0},
        {0xF966, 0x58C1},
        {0x6276, 0x58C2},
        {0x6577, 0x58C3},
        {0x65A7, 0x58C4},
        {0x6D6E, 0x58C5},
        {0x6EA5, 0x58C6},
        {0x7236, 0x58C7},
        {0x7C3F, 0x58C8},
        {0x7F36, 0x58C9},
        {0x7B26, 0x58CA},
        {0x7F58, 0x58CB},
        {0x8151, 0x58CC},
        {0x8150, 0x58CD},
        {0x819A, 0x58CE},
        {0x8299, 0x58CF},
        {0x82FB, 0x58D0},
        {0x8709, 0x58D1},
        {0x8A03, 0x58D2},
        {0x8CA0, 0x58D3},
        {0x8CE6, 0x58D4},
        {0x8CFB, 0x58D5},
        {0x8D74, 0x58D6},
        {0x8DBA, 0x58D7},
        {0x90E8, 0x58D8},
        {0x91DC, 0x58D9},
        {0x961C, 0x58DA},
        {0x9644, 0x58DB},
        {0x982B, 0x58DC},
        {0x99D9, 0x58DD},
        {0x9B92, 0x58DE},
        {0x9CE7, 0x58DF},
        {0x5317, 0x58E0},
        {0x5206, 0x58E1},
        {0x5674, 0x58E2},
        {0xF8F0, 0x58E3},
        {0x58B3, 0x58E4},
        {0x5954, 0x58E5},
        {0x596E, 0x58E6},
        {0x5FFF, 0x58E7},
        {0x61A4, 0x58E8},
        {0x626E, 0x58E9},
        {0x6C7E, 0x58EA},
        {0x711A, 0x58EB},
        {0x76C6, 0x58EC},
        {0x7C89, 0x58ED},
        {0x7CDE, 0x58EE},
        {0x7D1B, 0x58EF},
        {0x82AC, 0x58F0},
        {0x8561, 0x58F1},
        {0x96F0, 0x58F2},
        {0xF967, 0x58F3},
        {0x4F5B, 0x58F4},
        {0xF8EF, 0x58F5},
        {0x5F17, 0x58F6},
        {0x62C2, 0x58F7},
        {0x9AF4, 0x58F8},
        {0x9EFB, 0x58F9},
        {0x5D29, 0x58FA},
        {0x670B, 0x58FB},
        {0x68DA, 0x58FC},
        {0x787C, 0x58FD},
        {0x7E43, 0x58FE},
        {0x9D6C, 0x5941},
        {0x4E15, 0x5942},
        {0x5099, 0x5943},
        {0x5315, 0x5944},
        {0x532A, 0x5945},
        {0x5351, 0x5946},
        {0x5983, 0x5947},
        {0x59A3, 0x5948},
        {0x5A62, 0x5949},
        {0x5E87, 0x594A},
        {0x60B2, 0x594B},
        {0x618A, 0x594C},
        {0x6249, 0x594D},
        {0x6279, 0x594E},
        {0x6590, 0x594F},
        {0xF8EE, 0x5950},
        {0x69A7, 0x5951},
        {0x6C98, 0x5952},
        {0xF968, 0x5953},
        {0x6CB8, 0x5954},
        {0x6BD4, 0x5955},
        {0x6BD8, 0x5956},
        {0x7435, 0x5957},
        {0x75FA, 0x5958},
        {0x7765, 0x5959},
        {0x7812, 0x595A},
        {0x7891, 0x595B},
        {0x79D8, 0x595C},
        {0x7BE6, 0x595D},
        {0x7DCB, 0x595E},
        {0x7FE1, 0x595F},
        {0x80A5, 0x5960},
        {0x8153, 0x5961},
        {0x813E, 0x5962},
        {0x81C2, 0x5963},
        {0x83F2, 0x5964},
        {0x871A, 0x5965},
        {0x88E8, 0x5966},
        {0x8AB9, 0x5967},
        {0x8B6C, 0x5968},
        {0x8CBB, 0x5969},
        {0x8F61, 0x596A},
        {0x9119, 0x596B},
        {0x975E, 0x596C},
        {0x98DB, 0x596D},
        {0x9AC0, 0x596E},
        {0x9F3B, 0x596F},
        {0x5B2A, 0x5970},
        {0x8CD3, 0x5971},
        {0x5F6C, 0x5972},
        {0x64EF, 0x5973},
        {0x658C, 0x5974},
        {0x6AB3, 0x5975},
        {0x6BAF, 0x5976},
        {0x6FF1, 0x5977},
        {0x7015, 0x5978},
        {0x725D, 0x5979},
        {0x860B, 0x597A},
        {0x8CA7, 0x597B},
        {0xF8ED, 0x597C},
        {0x983B, 0x597D},
        {0x9870, 0x597E},
        {0x9B22, 0x597F},
        {0x6191, 0x5980},
        {0x6C37, 0x5981},
        {0x8058, 0x5982},
        {0x9A01, 0x5983},
        {0x4E4D, 0x5984},
        {0x4E8B, 0x5985},
        {0x4E9B, 0x5986},
        {0x4ED5, 0x5987},
        {0x4F3C, 0x5988},
        {0x4F3A, 0x5989},
        {0x820D, 0x598A},
        {0x4F7F, 0x598B},
        {0x50FF, 0x598C},
        {0x53F2, 0x598D},
        {0x53F8, 0x598E},
        {0x56DB, 0x598F},
        {0x5506, 0x5990},
        {0x55E3, 0x5991},
        {0x58EB, 0x5992},
        {0x5962, 0x5993},
        {0x59D2, 0x5994},
        {0x5A11, 0x5995},
        {0x5BEB, 0x5996},
        {0x5BFA, 0x5997},
        {0x5DF3, 0x5998},
        {0x5E2B, 0x5999},
        {0xF8EC, 0x599A},
        {0x5F99, 0x599B},
        {0x601D, 0x599C},
        {0x6368, 0x599D},
        {0x8D66, 0x599E},
        {0x65AF, 0x599F},
        {0x659C, 0x59A0},
        {0x67FB, 0x59A1},
        {0x68AD, 0x59A2},
        {0x6942, 0x59A3},
        {0x69CE, 0x59A4},
        {0x6C99, 0x59A5},
        {0x6CD7, 0x59A6},
        {0x6E23, 0x59A7},
        {0x7009, 0x59A8},
        {0x90AA, 0x59A9},
        {0x7345, 0x59AA},
        {0x7940, 0x59AB},
        {0x793E, 0x59AC},
        {0x7960, 0x59AD},
        {0x6B7B, 0x59AE},
        {0x7802, 0x59AF},
        {0x79C1, 0x59B0},
        {0x7B25, 0x59B1},
        {0x7BE9, 0x59B2},
        {0x84D1, 0x59B3},
        {0x7D17, 0x59B4},
        {0x7D72, 0x59B5},
        {0x838E, 0x59B6},
        {0x86C7, 0x59B7},
        {0x88DF, 0x59B8},
        {0x8A50, 0x59B9},
        {0x8A5E, 0x59BA},
        {0x8B1D, 0x59BB},
        {0x8CDC, 0x59BC},
        {0x5C04, 0x59BD},
        {0x8FAD, 0x59BE},
        {0x8086, 0x59BF},
        {0x98FC, 0x59C0},
        {0x99DF, 0x59C1},
        {0x524A, 0x59C2},
        {0xF969, 0x59C3},
        {0x69CA, 0x59C4},
        {0x6714, 0x59C5},
        {0xF96A, 0x59C6},
        {0x9460, 0x59C7},
        {0x5098, 0x59C8},
        {0x522A, 0x59C9},
        {0x5C71, 0x59CA},
        {0x6563, 0x59CB},
        {0x6C55, 0x59CC},
        {0x73CA, 0x59CD},
        {0x7523, 0x59CE},
        {0x759D, 0x59CF},
        {0x7B97, 0x59D0},
        {0x849C, 0x59D1},
        {0x9178, 0x59D2},
        {0x6492, 0x59D3},
        {0x6BBA, 0x59D4},
        {0x4E77, 0x59D5},
        {0x85A9, 0x59D6},
        {0x4E09, 0x59D7},
        {0xF96B, 0x59D8},
        {0x6749, 0x59D9},
        {0x68EE, 0x59DA},
        {0x6E17, 0x59DB},
        {0x886B, 0x59DC},
        {0x829F, 0x59DD},
        {0x8518, 0x59DE},
        {0x6B43, 0x59DF},
        {0x63F7, 0x59E0},
        {0x6F81, 0x59E1},
        {0x98AF, 0x59E2},
        {0x9364, 0x59E3},
        {0x970E, 0x59E4},
        {0x4E0A, 0x59E5},
        {0x50B7, 0x59E6},
        {0x50CF, 0x59E7},
        {0x511F, 0x59E8},
        {0x5546, 0x59E9},
        {0x55AA, 0x59EA},
        {0x5617, 0x59EB},
        {0x723D, 0x59EC},
        {0x5B40, 0x59ED},
        {0x5C19, 0x59EE},
        {0x5E8A, 0x59EF},
        {0x5EA0, 0x59F0},
        {0x5EC2, 0x59F1},
        {0x5E38, 0x59F2},
        {0x60F3, 0x59F3},
        {0x76F8, 0x59F4},
        {0x6851, 0x59F5},
        {0x6A61, 0x59F6},
        {0x6BA4, 0x59F7},
        {0x6E58, 0x59F8},
        {0x72C0, 0x59F9},
        {0x7240, 0x59FA},
        {0x7965, 0x59FB},
        {0x7BB1, 0x59FC},
        {0x7FD4, 0x59FD},
        {0x88F3, 0x59FE},
        {0x89F4, 0x5A41},
        {0x8C61, 0x5A42},
        {0x8CDE, 0x5A43},
        {0x8A73, 0x5A44},
        {0x971C, 0x5A45},
        {0x585E, 0x5A46},
        {0x74BD, 0x5A47},
        {0x8CFD, 0x5A48},
        {0x9C13, 0x5A49},
        {0xF96C, 0x5A4A},
        {0x7A61, 0x5A4B},
        {0x7D22, 0x5A4C},
        {0x8272, 0x5A4D},
        {0x7272, 0x5A4E},
        {0x751F, 0x5A4F},
        {0x7525, 0x5A50},
        {0xF96D, 0x5A51},
        {0x7B19, 0x5A52},
        {0x566C, 0x5A53},
        {0x58FB, 0x5A54},
        {0x5885, 0x5A55},
        {0x5A7F, 0x5A56},
        {0x7280, 0x5A57},
        {0x5DBC, 0x5A58},
        {0x5E8F, 0x5A59},
        {0x5EB6, 0x5A5A},
        {0x5F90, 0x5A5B},
        {0x6055, 0x5A5C},
        {0x6292, 0x5A5D},
        {0x654D, 0x5A5E},
        {0x6691, 0x5A5F},
        {0x66D9, 0x5A60},
        {0x66F8, 0x5A61},
        {0x6816, 0x5A62},
        {0x68F2, 0x5A63},
        {0x745E, 0x5A64},
        {0x7D6E, 0x5A65},
        {0x7DD6, 0x5A66},
        {0x7F72, 0x5A67},
        {0x80E5, 0x5A68},
        {0x8212, 0x5A69},
        {0x85AF, 0x5A6A},
        {0x897F, 0x5A6B},
        {0x8A93, 0x5A6C},
        {0x92E4, 0x5A6D},
        {0x901D, 0x5A6E},
        {0x9ECD, 0x5A6F},
        {0xF8EB, 0x5A70},
        {0x9F20, 0x5A71},
        {0x5915, 0x5A72},
        {0x596D, 0x5A73},
        {0xF8EA, 0x5A74},
        {0x5E2D, 0x5A75},
        {0x60DC, 0x5A76},
        {0x6614, 0x5A77},
        {0x6673, 0x5A78},
        {0x6790, 0x5A79},
        {0x6C50, 0x5A7A},
        {0x6DC5, 0x5A7B},
        {0x6F5F, 0x5A7C},
        {0x77F3, 0x5A7D},
        {0x78A9, 0x5A7E},
        {0x84C6, 0x5A7F},
        {0x91CB, 0x5A80},
        {0x932B, 0x5A81},
        {0x5148, 0x5A82},
        {0x4ED9, 0x5A83},
        {0x50CA, 0x5A84},
        {0xF8E9, 0x5A85},
        {0x5584, 0x5A86},
        {0x5BA3, 0x5A87},
        {0x5C20, 0x5A88},
        {0x6103, 0x5A89},
        {0x6247, 0x5A8A},
        {0x65CB, 0x5A8B},
        {0xF8E8, 0x5A8C},
        {0x717D, 0x5A8D},
        {0x71F9, 0x5A8E},
        {0x79AA, 0x5A8F},
        {0x7444, 0x5A90},
        {0x7487, 0x5A91},
        {0x74BF, 0x5A92},
        {0x766C, 0x5A93},
        {0x7DDA, 0x5A94},
        {0x7E55, 0x5A95},
        {0x7FA8, 0x5A96},
        {0x817A, 0x5A97},
        {0x81B3, 0x5A98},
        {0x8239, 0x5A99},
        {0x861A, 0x5A9A},
        {0x87EC, 0x5A9B},
        {0x8A75, 0x5A9C},
        {0x8DE3, 0x5A9D},
        {0x9078, 0x5A9E},
        {0x9291, 0x5A9F},
        {0xF8E7, 0x5AA0},
        {0x9BAE, 0x5AA1},
        {0x5070, 0x5AA2},
        {0x5368, 0x5AA3},
        {0x820C, 0x5AA4},
        {0xF8E6, 0x5AA5},
        {0x5C51, 0x5AA6},
        {0x6308, 0x5AA7},
        {0x6954, 0x5AA8},
        {0x6D29, 0x5AA9},
        {0x6E2B, 0x5AAA},
        {0x859B, 0x5AAB},
        {0x8A2D, 0x5AAC},
        {0x8AAA, 0x5AAD},
        {0x96EA, 0x5AAE},
        {0x6BB2, 0x5AAF},
        {0x7E96, 0x5AB0},
        {0x87FE, 0x5AB1},
        {0x8D0D, 0x5AB2},
        {0x66B9, 0x5AB3},
        {0x9583, 0x5AB4},
        {0x71EE, 0x5AB5},
        {0x651D, 0x5AB6},
        {0x6D89, 0x5AB7},
        {0xF96E, 0x5AB8},
        {0x57CE, 0x5AB9},
        {0x59D3, 0x5ABA},
        {0x6027, 0x5ABB},
        {0x60FA, 0x5ABC},
        {0x6210, 0x5ABD},
        {0x661F, 0x5ABE},
        {0x665F, 0x5ABF},
        {0x7329, 0x5AC0},
        {0x76DB, 0x5AC1},
        {0x7701, 0x5AC2},
        {0x7B6C, 0x5AC3},
        {0x8056, 0x5AC4},
        {0x8072, 0x5AC5},
        {0x8165, 0x5AC6},
        {0x8AA0, 0x5AC7},
        {0x9192, 0x5AC8},
        {0x4E16, 0x5AC9},
        {0x52E2, 0x5ACA},
        {0x6B72, 0x5ACB},
        {0x6D17, 0x5ACC},
        {0x7A05, 0x5ACD},
        {0x7B39, 0x5ACE},
        {0x7D30, 0x5ACF},
        {0xF96F, 0x5AD0},
        {0x8CB0, 0x5AD1},
        {0x53EC, 0x5AD2},
        {0x562F, 0x5AD3},
        {0x5851, 0x5AD4},
        {0x5C0F, 0x5AD5},
        {0x5C11, 0x5AD6},
        {0x5BB5, 0x5AD7},
        {0x5DE2, 0x5AD8},
        {0x6383, 0x5AD9},
        {0x6414, 0x5ADA},
        {0x6240, 0x5ADB},
        {0x662D, 0x5ADC},
        {0x68B3, 0x5ADD},
        {0x6CBC, 0x5ADE},
        {0x6D88, 0x5ADF},
        {0x6EAF, 0x5AE0},
        {0x701F, 0x5AE1},
        {0x70A4, 0x5AE2},
        {0x71D2, 0x5AE3},
        {0x7526, 0x5AE4},
        {0x758E, 0x5AE5},
        {0x758F, 0x5AE6},
        {0x7B11, 0x5AE7},
        {0x7C2B, 0x5AE8},
        {0x7D20, 0x5AE9},
        {0x7D39, 0x5AEA},
        {0x8258, 0x5AEB},
        {0x852C, 0x5AEC},
        {0x856D, 0x5AED},
        {0x8607, 0x5AEE},
        {0x8A34, 0x5AEF},
        {0x900D, 0x5AF0},
        {0x9061, 0x5AF1},
        {0x90B5, 0x5AF2},
        {0x92B7, 0x5AF3},
        {0x9704, 0x5AF4},
        {0x97F6, 0x5AF5},
        {0x9A37, 0x5AF6},
        {0x4FD7, 0x5AF7},
        {0x5C6C, 0x5AF8},
        {0x675F, 0x5AF9},
        {0x7C9F, 0x5AFA},
        {0x7E8C, 0x5AFB},
        {0x901F, 0x5AFC},
        {0x5B6B, 0x5AFD},
        {0x640D, 0x5AFE},
        {0x905C, 0x5B41},
        {0x7387, 0x5B42},
        {0x87C0, 0x5B43},
        {0x5B8B, 0x5B44},
        {0x677E, 0x5B45},
        {0x8A1F, 0x5B46},
        {0x8AA6, 0x5B47},
        {0x9001, 0x5B48},
        {0x980C, 0x5B49},
        {0x5237, 0x5B4A},
        {0xF970, 0x5B4B},
        {0x7051, 0x5B4C},
        {0x7463, 0x5B4D},
        {0x788E, 0x5B4E},
        {0x9396, 0x5B4F},
        {0x8870, 0x5B50},
        {0x91D7, 0x5B51},
        {0x4FEE, 0x5B52},
        {0x53D7, 0x5B53},
        {0x53DF, 0x5B54},
        {0x56DA, 0x5B55},
        {0x55FD, 0x5B56},
        {0x5782, 0x5B57},
        {0x58FD, 0x5B58},
        {0x5AC2, 0x5B59},
        {0x5B88, 0x5B5A},
        {0xF8E5, 0x5B5B},
        {0x5CAB, 0x5B5C},
        {0x5E25, 0x5B5D},
        {0x620D, 0x5B5E},
        {0x6101, 0x5B5F},
        {0x624B, 0x5B60},
        {0x6388, 0x5B61},
        {0x641C, 0x5B62},
        {0x6536, 0x5B63},
        {0x6578, 0x5B64},
        {0x666C, 0x5B65},
        {0x6A39, 0x5B66},
        {0x6B8A, 0x5B67},
        {0x71E7, 0x5B68},
        {0x6C34, 0x5B69},
        {0x6D19, 0x5B6A},
        {0x6EB2, 0x5B6B},
        {0x6F31, 0x5B6C},
        {0x72E9, 0x5B6D},
        {0x7378, 0x5B6E},
        {0x795F, 0x5B6F},
        {0x7626, 0x5B70},
        {0x7761, 0x5B71},
        {0xF8E4, 0x5B72},
        {0x79C0, 0x5B73},
        {0x7A57, 0x5B74},
        {0x7AEA, 0x5B75},
        {0x7CB9, 0x5B76},
        {0x7D8F, 0x5B77},
        {0x7DAC, 0x5B78},
        {0x7E61, 0x5B79},
        {0x7F9E, 0x5B7A},
        {0x8129, 0x5B7B},
        {0x8331, 0x5B7C},
        {0x8490, 0x5B7D},
        {0x84DA, 0x5B7E},
        {0x85EA, 0x5B7F},
        {0x8896, 0x5B80},
        {0x8AB0, 0x5B81},
        {0x8F38, 0x5B82},
        {0x9042, 0x5B83},
        {0x9083, 0x5B84},
        {0x916C, 0x5B85},
        {0x9296, 0x5B86},
        {0x92B9, 0x5B87},
        {0x968B, 0x5B88},
        {0x96A8, 0x5B89},
        {0x96D6, 0x5B8A},
        {0x9700, 0x5B8B},
        {0x9808, 0x5B8C},
        {0x9996, 0x5B8D},
        {0x9AD3, 0x5B8E},
        {0x9B1A, 0x5B8F},
        {0x53D4, 0x5B90},
        {0x587E, 0x5B91},
        {0x5919, 0x5B92},
        {0x5B70, 0x5B93},
        {0x5BBF, 0x5B94},
        {0x6DD1, 0x5B95},
        {0x719F, 0x5B96},
        {0x8085, 0x5B97},
        {0x83FD, 0x5B98},
        {0x5FAA, 0x5B99},
        {0x6042, 0x5B9A},
        {0x65EC, 0x5B9B},
        {0x696F, 0x5B9C},
        {0x6B89, 0x5B9D},
        {0x6D35, 0x5B9E},
        {0x6DF3, 0x5B9F},
        {0x73E3, 0x5BA0},
        {0x76FE, 0x5BA1},
        {0x77AC, 0x5BA2},
        {0x7B4D, 0x5BA3},
        {0x7D14, 0x5BA4},
        {0x8123, 0x5BA5},
        {0x821C, 0x5BA6},
        {0x8340, 0x5BA7},
        {0x8A62, 0x5BA8},
        {0x5DE1, 0x5BA9},
        {0x9187, 0x5BAA},
        {0x931E, 0x5BAB},
        {0x9806, 0x5BAC},
        {0x99B4, 0x5BAD},
        {0x9D89, 0x5BAE},
        {0x620C, 0x5BAF},
        {0x8853, 0x5BB0},
        {0x8FF0, 0x5BB1},
        {0x5D07, 0x5BB2},
        {0x5D27, 0x5BB3},
        {0x5D69, 0x5BB4},
        {0x745F, 0x5BB5},
        {0x819D, 0x5BB6},
        {0x8671, 0x5BB7},
        {0x8768, 0x5BB8},
        {0x62FE, 0x5BB9},
        {0x6FD5, 0x5BBA},
        {0x7FD2, 0x5BBB},
        {0x8936, 0x5BBC},
        {0x8972, 0x5BBD},
        {0x4E1E, 0x5BBE},
        {0x4E58, 0x5BBF},
        {0x50E7, 0x5BC0},
        {0x5347, 0x5BC1},
        {0x627F, 0x5BC2},
        {0x6607, 0x5BC3},
        {0x52DD, 0x5BC4},
        {0x7E69, 0x5BC5},
        {0x8805, 0x5BC6},
        {0x965E, 0x5BC7},
        {0x4F8D, 0x5BC8},
        {0x5319, 0x5BC9},
        {0x557B, 0x5BCA},
        {0x5636, 0x5BCB},
        {0x59CB, 0x5BCC},
        {0x5AA4, 0x5BCD},
        {0xF8E3, 0x5BCE},
        {0x5C38, 0x5BCF},
        {0x5C4D, 0x5BD0},
        {0x5E02, 0x5BD1},
        {0x5F11, 0x5BD2},
        {0x6043, 0x5BD3},
        {0x65BD, 0x5BD4},
        {0x662F, 0x5BD5},
        {0x6642, 0x5BD6},
        {0x67BE, 0x5BD7},
        {0x67F4, 0x5BD8},
        {0x731C, 0x5BD9},
        {0x77E2, 0x5BDA},
        {0x793A, 0x5BDB},
        {0x8996, 0x5BDC},
        {0x7DE6, 0x5BDD},
        {0x7FC5, 0x5BDE},
        {0x8494, 0x5BDF},
        {0x84CD, 0x5BE0},
        {0x8A69, 0x5BE1},
        {0x8A66, 0x5BE2},
        {0x8AE1, 0x5BE3},
        {0x8C7A, 0x5BE4},
        {0x57F4, 0x5BE5},
        {0x5BD4, 0x5BE6},
        {0x5F0F, 0x5BE7},
        {0x606F, 0x5BE8},
        {0x62ED, 0x5BE9},
        {0x690D, 0x5BEA},
        {0x6B96, 0x5BEB},
        {0x6E5C, 0x5BEC},
        {0x7184, 0x5BED},
        {0x8B58, 0x5BEE},
        {0x8EFE, 0x5BEF},
        {0x98DF, 0x5BF0},
        {0x98FE, 0x5BF1},
        {0x4F38, 0x5BF2},
        {0x4FE1, 0x5BF3},
        {0x547B, 0x5BF4},
        {0x5A20, 0x5BF5},
        {0x5BB8, 0x5BF6},
        {0x613C, 0x5BF7},
        {0x65B0, 0x5BF8},
        {0x6668, 0x5BF9},
        {0x71FC, 0x5BFA},
        {0x7533, 0x5BFB},
        {0x77E7, 0x5BFC},
        {0x795E, 0x5BFD},
        {0x7D33, 0x5BFE},
        {0x814E, 0x5C41},
        {0x81E3, 0x5C42},
        {0x8398, 0x5C43},
        {0x85AA, 0x5C44},
        {0x8703, 0x5C45},
        {0x8A0A, 0x5C46},
        {0x8EAB, 0x5C47},
        {0x8F9B, 0x5C48},
        {0xF971, 0x5C49},
        {0x8FC5, 0x5C4A},
        {0x5931, 0x5C4B},
        {0x5BA4, 0x5C4C},
        {0x5BE6, 0x5C4D},
        {0x6089, 0x5C4E},
        {0xF8E2, 0x5C4F},
        {0x5BE9, 0x5C50},
        {0x5C0B, 0x5C51},
        {0x5FC3, 0x5C52},
        {0xF972, 0x5C53},
        {0x6C81, 0x5C54},
        {0x6DF1, 0x5C55},
        {0x700B, 0x5C56},
        {0x751A, 0x5C57},
        {0x82AF, 0x5C58},
        {0x4EC0, 0x5C59},
        {0x5341, 0x5C5A},
        {0xF973, 0x5C5B},
        {0x96D9, 0x5C5C},
        {0x6C0F, 0x5C5D},
        {0x4E9E, 0x5C5E},
        {0x4FC4, 0x5C5F},
        {0x5152, 0x5C60},
        {0x5A25, 0x5C61},
        {0x5CE8, 0x5C62},
        {0x6211, 0x5C63},
        {0x7259, 0x5C64},
        {0x82BD, 0x5C65},
        {0x86FE, 0x5C66},
        {0x8859, 0x5C67},
        {0x8A1D, 0x5C68},
        {0x963F, 0x5C69},
        {0x96C5, 0x5C6A},
        {0x9913, 0x5C6B},
        {0x9D09, 0x5C6C},
        {0x9D5D, 0x5C6D},
        {0x580A, 0x5C6E},
        {0x5CB3, 0x5C6F},
        {0x5DBD, 0x5C70},
        {0x6115, 0x5C71},
        {0x60E1, 0x5C72},
        {0x63E1, 0x5C73},
        {0x6A02, 0x5C74},
        {0x6E25, 0x5C75},
        {0x843C, 0x5C76},
        {0x984E, 0x5C77},
        {0x9F77, 0x5C78},
        {0x5B89, 0x5C79},
        {0x5CB8, 0x5C7A},
        {0x6309, 0x5C7B},
        {0x664F, 0x5C7C},
        {0x6848, 0x5C7D},
        {0x773C, 0x5C7E},
        {0x96C1, 0x5C7F},
        {0x8D0B, 0x5C80},
        {0x978D, 0x5C81},
        {0x9854, 0x5C82},
        {0x9D08, 0x5C83},
        {0x621E, 0x5C84},
        {0x65A1, 0x5C85},
        {0x8B01, 0x5C86},
        {0x8ECB, 0x5C87},
        {0x904F, 0x5C88},
        {0x95BC, 0x5C89},
        {0x5D52, 0x5C8A},
        {0x5DD6, 0x5C8B},
        {0x5EB5, 0x5C8C},
        {0x6697, 0x5C8D},
        {0x764C, 0x5C8E},
        {0x83F4, 0x5C8F},
        {0x8AF3, 0x5C90},
        {0x95C7, 0x5C91},
        {0x9EEF, 0x5C92},
        {0x58D3, 0x5C93},
        {0x62BC, 0x5C94},
        {0x72CE, 0x5C95},
        {0x9D28, 0x5C96},
        {0x4EF0, 0x5C97},
        {0x592E, 0x5C98},
        {0x600F, 0x5C99},
        {0x663B, 0x5C9A},
        {0x6B83, 0x5C9B},
        {0x79E7, 0x5C9C},
        {0x9785, 0x5C9D},
        {0x9D26, 0x5C9E},
        {0x5393, 0x5C9F},
        {0x57C3, 0x5CA0},
        {0x5D16, 0x5CA1},
        {0x611B, 0x5CA2},
        {0x6B38, 0x5CA3},
        {0x6DAF, 0x5CA4},
        {0x769A, 0x5CA5},
        {0x66D6, 0x5CA6},
        {0x788D, 0x5CA7},
        {0x7919, 0x5CA8},
        {0x827E, 0x5CA9},
        {0x54C0, 0x5CAA},
        {0x9698, 0x5CAB},
        {0x9744, 0x5CAC},
        {0x9749, 0x5CAD},
        {0x5384, 0x5CAE},
        {0x6396, 0x5CAF},
        {0x6DB2, 0x5CB0},
        {0x814B, 0x5CB1},
        {0x9628, 0x5CB2},
        {0x984D, 0x5CB3},
        {0x6AFB, 0x5CB4},
        {0x7F4C, 0x5CB5},
        {0x9DAF, 0x5CB6},
        {0x9E1A, 0x5CB7},
        {0x4E5F, 0x5CB8},
        {0x503B, 0x5CB9},
        {0x51B6, 0x5CBA},
        {0x591C, 0x5CBB},
        {0xF8E1, 0x5CBC},
        {0x63F6, 0x5CBD},
        {0x6930, 0x5CBE},
        {0x723A, 0x5CBF},
        {0x8036, 0x5CC0},
        {0xF974, 0x5CC1},
        {0x60F9, 0x5CC2},
        {0x91CE, 0x5CC3},
        {0x5F31, 0x5CC4},
        {0x7BDB, 0x5CC5},
        {0x7C65, 0x5CC6},
        {0x7D04, 0x5CC7},
        {0x82E5, 0x5CC8},
        {0x846F, 0x5CC9},
        {0x85E5, 0x5CCA},
        {0x8E8D, 0x5CCB},
        {0x4F6F, 0x5CCC},
        {0x58E4, 0x5CCD},
        {0x5B43, 0x5CCE},
        {0x6059, 0x5CCF},
        {0x63DA, 0x5CD0},
        {0x6518, 0x5CD1},
        {0x656D, 0x5CD2},
        {0x6698, 0x5CD3},
        {0x694A, 0x5CD4},
        {0x6A23, 0x5CD5},
        {0x6D0B, 0x5CD6},
        {0x7001, 0x5CD7},
        {0x716C, 0x5CD8},
        {0x7A70, 0x5CD9},
        {0x75D2, 0x5CDA},
        {0x760D, 0x5CDB},
        {0x7F8A, 0x5CDC},
        {0x7F98, 0x5CDD},
        {0x8944, 0x5CDE},
        {0x8B93, 0x5CDF},
        {0x91C0, 0x5CE0},
        {0x967D, 0x5CE1},
        {0x990A, 0x5CE2},
        {0x5704, 0x5CE3},
        {0x5FA1, 0x5CE4},
        {0x6554, 0x5CE5},
        {0x65BC, 0x5CE6},
        {0x6F01, 0x5CE7},
        {0x79A6, 0x5CE8},
        {0x8A9E, 0x5CE9},
        {0x99AD, 0x5CEA},
        {0x9B5A, 0x5CEB},
        {0x9F6C, 0x5CEC},
        {0x5104, 0x5CED},
        {0x61B6, 0x5CEE},
        {0x6291, 0x5CEF},
        {0x6A8D, 0x5CF0},
        {0x81C6, 0x5CF1},
        {0x5043, 0x5CF2},
        {0x5830, 0x5CF3},
        {0x5F66, 0x5CF4},
        {0x7109, 0x5CF5},
        {0x8A00, 0x5CF6},
        {0x8AFA, 0x5CF7},
        {0x5B7C, 0x5CF8},
        {0x513C, 0x5CF9},
        {0x56B4, 0x5CFA},
        {0x5944, 0x5CFB},
        {0x63A9, 0x5CFC},
        {0x6DF9, 0x5CFD},
        {0x5DAA, 0x5CFE},
        {0x696D, 0x5D41},
        {0x605A, 0x5D42},
        {0x4E88, 0x5D43},
        {0x4F59, 0x5D44},
        {0x5982, 0x5D45},
        {0x6B5F, 0x5D46},
        {0x6C5D, 0x5D47},
        {0x8207, 0x5D48},
        {0x9918, 0x5D49},
        {0x4EA6, 0x5D4A},
        {0x57DF, 0x5D4B},
        {0xF8E0, 0x5D4C},
        {0x5F79, 0x5D4D},
        {0x6613, 0x5D4E},
        {0x75AB, 0x5D4F},
        {0x7E79, 0x5D50},
        {0x8B6F, 0x5D51},
        {0x9006, 0x5D52},
        {0x9A5B, 0x5D53},
        {0x56A5, 0x5D54},
        {0x5827, 0x5D55},
        {0x59F8, 0x5D56},
        {0x5A1F, 0x5D57},
        {0x5BB4, 0x5D58},
        {0x5EF6, 0x5D59},
        {0x6350, 0x5D5A},
        {0xF991, 0x5D5B},
        {0x693D, 0x5D5C},
        {0x6CBF, 0x5D5D},
        {0x6D93, 0x5D5E},
        {0x6D8E, 0x5D5F},
        {0x6DF5, 0x5D60},
        {0x6F14, 0x5D61},
        {0x70DF, 0x5D62},
        {0x7136, 0x5D63},
        {0x7159, 0x5D64},
        {0x71C3, 0x5D65},
        {0x71D5, 0x5D66},
        {0x784F, 0x5D67},
        {0x786F, 0x5D68},
        {0x7B75, 0x5D69},
        {0x7DE3, 0x5D6A},
        {0xF8DF, 0x5D6B},
        {0x81D9, 0x5D6C},
        {0x8815, 0x5D6D},
        {0x884D, 0x5D6E},
        {0x8B8C, 0x5D6F},
        {0x8EDF, 0x5D70},
        {0x925B, 0x5D71},
        {0x9CF6, 0x5D72},
        {0xF99E, 0x5D73},
        {0x6085, 0x5D74},
        {0x6D85, 0x5D75},
        {0x71B1, 0x5D76},
        {0xF9A1, 0x5D77},
        {0x95B1, 0x5D78},
        {0x53AD, 0x5D79},
        {0x5869, 0x5D7A},
        {0x67D3, 0x5D7B},
        {0x708E, 0x5D7C},
        {0x7130, 0x5D7D},
        {0x9E7D, 0x5D7E},
        {0x82D2, 0x5D7F},
        {0x8276, 0x5D80},
        {0x95BB, 0x5D81},
        {0x995C, 0x5D82},
        {0x9AE5, 0x5D83},
        {0x66C4, 0x5D84},
        {0x71C1, 0x5D85},
        {0x8449, 0x5D86},
        {0x584B, 0x5D87},
        {0x5B30, 0x5D88},
        {0x5F71, 0x5D89},
        {0x6620, 0x5D8A},
        {0x668E, 0x5D8B},
        {0x6979, 0x5D8C},
        {0x69AE, 0x5D8D},
        {0x6C38, 0x5D8E},
        {0x6CF3, 0x5D8F},
        {0x6F41, 0x5D90},
        {0x701B, 0x5D91},
        {0x71DF, 0x5D92},
        {0x745B, 0x5D93},
        {0xF9AE, 0x5D94},
        {0x74D4, 0x5D95},
        {0x76C8, 0x5D96},
        {0x7E93, 0x5D97},
        {0x82F1, 0x5D98},
        {0x8A60, 0x5D99},
        {0x8FCE, 0x5D9A},
        {0x502A, 0x5D9B},
        {0x5208, 0x5D9C},
        {0x53E1, 0x5D9D},
        {0x66F3, 0x5D9E},
        {0x6FCA, 0x5D9F},
        {0x730A, 0x5DA0},
        {0x7768, 0x5DA1},
        {0x777F, 0x5DA2},
        {0x7FF3, 0x5DA3},
        {0x82AE, 0x5DA4},
        {0x854B, 0x5DA5},
        {0x85DD, 0x5DA6},
        {0x8602, 0x5DA7},
        {0x88D4, 0x5DA8},
        {0x8A63, 0x5DA9},
        {0x8B7D, 0x5DAA},
        {0x8C6B, 0x5DAB},
        {0x92B3, 0x5DAC},
        {0x9713, 0x5DAD},
        {0x9810, 0x5DAE},
        {0x4E94, 0x5DAF},
        {0x4F0D, 0x5DB0},
        {0x50B2, 0x5DB1},
        {0x5348, 0x5DB2},
        {0x5433, 0x5DB3},
        {0x55DA, 0x5DB4},
        {0x58BA, 0x5DB5},
        {0x5967, 0x5DB6},
        {0x5A1B, 0x5DB7},
        {0x5BE4, 0x5DB8},
        {0x609F, 0x5DB9},
        {0xF9B9, 0x5DBA},
        {0x65FF, 0x5DBB},
        {0x6664, 0x5DBC},
        {0x68A7, 0x5DBD},
        {0x6C5A, 0x5DBE},
        {0x70CF, 0x5DBF},
        {0x7352, 0x5DC0},
        {0x8708, 0x5DC1},
        {0x8AA4, 0x5DC2},
        {0x9068, 0x5DC3},
        {0x543E, 0x5DC4},
        {0x5C4B, 0x5DC5},
        {0x6C83, 0x5DC6},
        {0x7344, 0x5DC7},
        {0x7389, 0x5DC8},
        {0x923A, 0x5DC9},
        {0x5ABC, 0x5DCA},
        {0x6EAB, 0x5DCB},
        {0x7465, 0x5DCC},
        {0x761F, 0x5DCD},
        {0x7A69, 0x5DCE},
        {0x8580, 0x5DCF},
        {0x860A, 0x5DD0},
        {0x9C2E, 0x5DD1},
        {0x5140, 0x5DD2},
        {0x58C5, 0x5DD3},
        {0x74EE, 0x5DD4},
        {0x7670, 0x5DD5},
        {0x64C1, 0x5DD6},
        {0x7515, 0x5DD7},
        {0x7FC1, 0x5DD8},
        {0x9095, 0x5DD9},
        {0x96CD, 0x5DDA},
        {0x6E26, 0x5DDB},
        {0x74E6, 0x5DDC},
        {0x7AA9, 0x5DDD},
        {0x86D9, 0x5DDE},
        {0x8778, 0x5DDF},
        {0x8A1B, 0x5DE0},
        {0x81E5, 0x5DE1},
        {0x5A49, 0x5DE2},
        {0x5B8C, 0x5DE3},
        {0x5B9B, 0x5DE4},
        {0x6D63, 0x5DE5},
        {0x73A9, 0x5DE6},
        {0x742C, 0x5DE7},
        {0x7897, 0x5DE8},
        {0x7DE9, 0x5DE9},
        {0x7FEB, 0x5DEA},
        {0x8155, 0x5DEB},
        {0x839E, 0x5DEC},
        {0x8C4C, 0x5DED},
        {0x962E, 0x5DEE},
        {0x9811, 0x5DEF},
        {0x66F0, 0x5DF0},
        {0x5F80, 0x5DF1},
        {0x65FA, 0x5DF2},
        {0x6789, 0x5DF3},
        {0x6C6A, 0x5DF4},
        {0x738B, 0x5DF5},
        {0x502D, 0x5DF6},
        {0x6B6A, 0x5DF7},
        {0x77EE, 0x5DF8},
        {0x5916, 0x5DF9},
        {0x5DCD, 0x5DFA},
        {0x7325, 0x5DFB},
        {0x754F, 0x5DFC},
        {0x50E5, 0x5DFD},
        {0x51F9, 0x5DFE},
        {0x582F, 0x5E41},
        {0x592D, 0x5E42},
        {0x5996, 0x5E43},
        {0x59DA, 0x5E44},
        {0x5DA2, 0x5E45},
        {0x62D7, 0x5E46},
        {0x6416, 0x5E47},
        {0x64FE, 0x5E48},
        {0x66DC, 0x5E49},
        {0x8170, 0x5E4A},
        {0xF9BF, 0x5E4B},
        {0x6A48, 0x5E4C},
        {0x7464, 0x5E4D},
        {0x7A88, 0x5E4E},
        {0x7AAF, 0x5E4F},
        {0x7E47, 0x5E50},
        {0x7E5E, 0x5E51},
        {0x8000, 0x5E52},
        {0x8558, 0x5E53},
        {0x87EF, 0x5E54},
        {0x8981, 0x5E55},
        {0x8B20, 0x5E56},
        {0x9059, 0x5E57},
        {0x9080, 0x5E58},
        {0x9952, 0x5E59},
        {0x8FB1, 0x5E5A},
        {0x617E, 0x5E5B},
        {0x6B32, 0x5E5C},
        {0x6D74, 0x5E5D},
        {0x8925, 0x5E5E},
        {0x50AD, 0x5E5F},
        {0x52C7, 0x5E60},
        {0x5BB9, 0x5E61},
        {0x5EB8, 0x5E62},
        {0x5197, 0x5E63},
        {0x6995, 0x5E64},
        {0x6E67, 0x5E65},
        {0x6EB6, 0x5E66},
        {0x7194, 0x5E67},
        {0x7462, 0x5E68},
        {0x7528, 0x5E69},
        {0x8073, 0x5E6A},
        {0x8202, 0x5E6B},
        {0x8338, 0x5E6C},
        {0x84C9, 0x5E6D},
        {0x86F9, 0x5E6E},
        {0x8E0A, 0x5E6F},
        {0x9394, 0x5E70},
        {0x93DE, 0x5E71},
        {0x4F51, 0x5E72},
        {0x5076, 0x5E73},
        {0x512A, 0x5E74},
        {0x53C8, 0x5E75},
        {0x53CB, 0x5E76},
        {0x53F3, 0x5E77},
        {0x5401, 0x5E78},
        {0x5B87, 0x5E79},
        {0x5BD3, 0x5E7A},
        {0x5C24, 0x5E7B},
        {0x4E8E, 0x5E7C},
        {0x611A, 0x5E7D},
        {0x6182, 0x5E7E},
        {0x725B, 0x5E7F},
        {0x76C2, 0x5E80},
        {0x7950, 0x5E81},
        {0x7991, 0x5E82},
        {0x79B9, 0x5E83},
        {0x7FBD, 0x5E84},
        {0x828B, 0x5E85},
        {0x865E, 0x5E86},
        {0x8FC2, 0x5E87},
        {0x9047, 0x5E88},
        {0x90F5, 0x5E89},
        {0x9685, 0x5E8A},
        {0x96E8, 0x5E8B},
        {0x96E9, 0x5E8C},
        {0x65ED, 0x5E8D},
        {0x6631, 0x5E8E},
        {0x715C, 0x5E8F},
        {0x7A36, 0x5E90},
        {0x90C1, 0x5E91},
        {0x980A, 0x5E92},
        {0x4E91, 0x5E93},
        {0xF9C5, 0x5E94},
        {0x6B9E, 0x5E95},
        {0x8018, 0x5E96},
        {0x82B8, 0x5E97},
        {0x904B, 0x5E98},
        {0x9695, 0x5E99},
        {0x96F2, 0x5E9A},
        {0x97FB, 0x5E9B},
        {0x71A8, 0x5E9C},
        {0x851A, 0x5E9D},
        {0x9B31, 0x5E9E},
        {0x718A, 0x5E9F},
        {0x96C4, 0x5EA0},
        {0x5143, 0x5EA1},
        {0x539F, 0x5EA2},
        {0x54E1, 0x5EA3},
        {0x5712, 0x5EA4},
        {0x5713, 0x5EA5},
        {0x7230, 0x5EA6},
        {0x57A3, 0x5EA7},
        {0x5A9B, 0x5EA8},
        {0x5BC3, 0x5EA9},
        {0x6028, 0x5EAA},
        {0x613F, 0x5EAB},
        {0x63F4, 0x5EAC},
        {0x6E90, 0x5EAD},
        {0x733F, 0x5EAE},
        {0x7457, 0x5EAF},
        {0x82D1, 0x5EB0},
        {0x873F, 0x5EB1},
        {0x8881, 0x5EB2},
        {0x8F45, 0x5EB3},
        {0x9060, 0x5EB4},
        {0x9662, 0x5EB5},
        {0x9858, 0x5EB6},
        {0x9D1B, 0x5EB7},
        {0x6708, 0x5EB8},
        {0x8D8A, 0x5EB9},
        {0x925E, 0x5EBA},
        {0x4F4D, 0x5EBB},
        {0x5049, 0x5EBC},
        {0x50DE, 0x5EBD},
        {0x5371, 0x5EBE},
        {0x570D, 0x5EBF},
        {0x59D4, 0x5EC0},
        {0x5C09, 0x5EC1},
        {0x5E43, 0x5EC2},
        {0x6170, 0x5EC3},
        {0x5A01, 0x5EC4},
        {0x6E2D, 0x5EC5},
        {0x7232, 0x5EC6},
        {0x744B, 0x5EC7},
        {0x7DEF, 0x5EC8},
        {0x80C3, 0x5EC9},
        {0x840E, 0x5ECA},
        {0x8466, 0x5ECB},
        {0x875F, 0x5ECC},
        {0x885B, 0x5ECD},
        {0x885E, 0x5ECE},
        {0x8B02, 0x5ECF},
        {0x9055, 0x5ED0},
        {0x97CB, 0x5ED1},
        {0x9B4F, 0x5ED2},
        {0x4E73, 0x5ED3},
        {0x6538, 0x5ED4},
        {0x4F91, 0x5ED5},
        {0x5112, 0x5ED6},
        {0x516A, 0x5ED7},
        {0x5E7C, 0x5ED8},
        {0x552F, 0x5ED9},
        {0x55A9, 0x5EDA},
        {0x56FF, 0x5EDB},
        {0x5B7A, 0x5EDC},
        {0x5BA5, 0x5EDD},
        {0x5E37, 0x5EDE},
        {0x5E7D, 0x5EDF},
        {0x5EBE, 0x5EE0},
        {0x60A0, 0x5EE1},
        {0x60DF, 0x5EE2},
        {0x6109, 0x5EE3},
        {0x6108, 0x5EE4},
        {0x63C4, 0x5EE5},
        {0x6709, 0x5EE6},
        {0x67D4, 0x5EE7},
        {0x67DA, 0x5EE8},
        {0x6961, 0x5EE9},
        {0x6CB9, 0x5EEA},
        {0x6E38, 0x5EEB},
        {0x6FE1, 0x5EEC},
        {0x7336, 0x5EED},
        {0x745C, 0x5EEE},
        {0x7531, 0x5EEF},
        {0x7652, 0x5EF0},
        {0x7DAD, 0x5EF1},
        {0x81FE, 0x5EF2},
        {0x8438, 0x5EF3},
        {0x8564, 0x5EF4},
        {0x88D5, 0x5EF5},
        {0x8A98, 0x5EF6},
        {0x8ADB, 0x5EF7},
        {0x8AED, 0x5EF8},
        {0x8E42, 0x5EF9},
        {0x8E30, 0x5EFA},
        {0x904A, 0x5EFB},
        {0x903E, 0x5EFC},
        {0x907A, 0x5EFD},
        {0x9149, 0x5EFE},
        {0x91C9, 0x5F41},
        {0x936E, 0x5F42},
        {0x9EDD, 0x5F43},
        {0x6BD3, 0x5F44},
        {0x8089, 0x5F45},
        {0x80B2, 0x5F46},
        {0x9B3B, 0x5F47},
        {0x5141, 0x5F48},
        {0x596B, 0x5F49},
        {0x5C39, 0x5F4A},
        {0x6F64, 0x5F4B},
        {0x73A7, 0x5F4C},
        {0x80E4, 0x5F4D},
        {0x958F, 0x5F4E},
        {0x807F, 0x5F4F},
        {0x620E, 0x5F50},
        {0x7D68, 0x5F51},
        {0x878D, 0x5F52},
        {0x57A0, 0x5F53},
        {0x6069, 0x5F54},
        {0x6147, 0x5F55},
        {0x6ABC, 0x5F56},
        {0x6BB7, 0x5F57},
        {0x73E2, 0x5F58},
        {0x9280, 0x5F59},
        {0x8ABE, 0x5F5A},
        {0x96B1, 0x5F5B},
        {0x9F66, 0x5F5C},
        {0x4E59, 0x5F5D},
        {0x541F, 0x5F5E},
        {0x6DEB, 0x5F5F},
        {0x852D, 0x5F60},
        {0x9670, 0x5F61},
        {0x98EE, 0x5F62},
        {0x97F3, 0x5F63},
        {0x6339, 0x5F64},
        {0x63D6, 0x5F65},
        {0x6CE3, 0x5F66},
        {0x9091, 0x5F67},
        {0x51DD, 0x5F68},
        {0x61C9, 0x5F69},
        {0x81BA, 0x5F6A},
        {0x9DF9, 0x5F6B},
        {0x4F9D, 0x5F6C},
        {0x501A, 0x5F6D},
        {0x5100, 0x5F6E},
        {0x7591, 0x5F6F},
        {0x77E3, 0x5F70},
        {0x5B9C, 0x5F71},
        {0x610F, 0x5F72},
        {0x61FF, 0x5F73},
        {0x64EC, 0x5F74},
        {0x6BC5, 0x5F75},
        {0x7FA9, 0x5F76},
        {0x8264, 0x5F77},
        {0x87FB, 0x5F78},
        {0x8863, 0x5F79},
        {0x8ABC, 0x5F7A},
        {0x8B70, 0x5F7B},
        {0x91AB, 0x5F7C},
        {0x4E8C, 0x5F7D},
        {0x4EE5, 0x5F7E},
        {0x4F0A, 0x5F7F},
        {0x5937, 0x5F80},
        {0x59E8, 0x5F81},
        {0x5DF2, 0x5F82},
        {0x8CB3, 0x5F83},
        {0x5F1B, 0x5F84},
        {0x5F5B, 0x5F85},
        {0x6021, 0x5F86},
        {0xF9E0, 0x5F87},
        {0x682E, 0x5F88},
        {0x723E, 0x5F89},
        {0x73E5, 0x5F8A},
        {0x7570, 0x5F8B},
        {0x75CD, 0x5F8C},
        {0x79FB, 0x5F8D},
        {0x800C, 0x5F8E},
        {0x8033, 0x5F8F},
        {0x8351, 0x5F90},
        {0x98F4, 0x5F91},
        {0x990C, 0x5F92},
        {0x9823, 0x5F93},
        {0x7037, 0x5F94},
        {0x7FFC, 0x5F95},
        {0x76CA, 0x5F96},
        {0x7FCA, 0x5F97},
        {0x7FCC, 0x5F98},
        {0x4EBA, 0x5F99},
        {0x4EC1, 0x5F9A},
        {0x4EDE, 0x5F9B},
        {0x5203, 0x5F9C},
        {0x5370, 0x5F9D},
        {0x54BD, 0x5F9E},
        {0x56E0, 0x5F9F},
        {0x59FB, 0x5FA0},
        {0x5BC5, 0x5FA1},
        {0x5F15, 0x5FA2},
        {0x5FCD, 0x5FA3},
        {0x6E6E, 0x5FA4},
        {0x8A8D, 0x5FA5},
        {0x976D, 0x5FA6},
        {0x9777, 0x5FA7},
        {0x4E00, 0x5FA8},
        {0x4F7E, 0x5FA9},
        {0x58F9, 0x5FAA},
        {0x65E5, 0x5FAB},
        {0x6EA2, 0x5FAC},
        {0x9038, 0x5FAD},
        {0x93B0, 0x5FAE},
        {0x99B9, 0x5FAF},
        {0x4EFB, 0x5FB0},
        {0x58EC, 0x5FB1},
        {0x598A, 0x5FB2},
        {0x59D9, 0x5FB3},
        {0x7A14, 0x5FB4},
        {0x834F, 0x5FB5},
        {0x8CC3, 0x5FB6},
        {0x5165, 0x5FB7},
        {0x4ECD, 0x5FB8},
        {0x5B55, 0x5FB9},
        {0x5269, 0x5FBA},
        {0x4ED4, 0x5FBB},
        {0x523A, 0x5FBC},
        {0x54A8, 0x5FBD},
        {0x59C9, 0x5FBE},
        {0x59FF, 0x5FBF},
        {0x5B50, 0x5FC0},
        {0x5B5C, 0x5FC1},
        {0x5B57, 0x5FC2},
        {0x6063, 0x5FC3},
        {0x6148, 0x5FC4},
        {0x6ECB, 0x5FC5},
        {0x7099, 0x5FC6},
        {0x716E, 0x5FC7},
        {0x7386, 0x5FC8},
        {0x74F7, 0x5FC9},
        {0x75B5, 0x5FCA},
        {0x7725, 0x5FCB},
        {0x78C1, 0x5FCC},
        {0x7CA2, 0x5FCD},
        {0x7D2B, 0x5FCE},
        {0x8005, 0x5FCF},
        {0x8014, 0x5FD0},
        {0x81EA, 0x5FD1},
        {0x8517, 0x5FD2},
        {0x85C9, 0x5FD3},
        {0x89DC, 0x5FD4},
        {0x8AEE, 0x5FD5},
        {0x8CC7, 0x5FD6},
        {0x8D6D, 0x5FD7},
        {0x96CC, 0x5FD8},
        {0x4F5C, 0x5FD9},
        {0x52FA, 0x5FDA},
        {0x56BC, 0x5FDB},
        {0x65AB, 0x5FDC},
        {0x6628, 0x5FDD},
        {0x67DE, 0x5FDE},
        {0x707C, 0x5FDF},
        {0x70B8, 0x5FE0},
        {0x7235, 0x5FE1},
        {0x7DBD, 0x5FE2},
        {0x828D, 0x5FE3},
        {0x914C, 0x5FE4},
        {0x96C0, 0x5FE5},
        {0x9D72, 0x5FE6},
        {0x68E7, 0x5FE7},
        {0x6B98, 0x5FE8},
        {0x6F7A, 0x5FE9},
        {0x76DE, 0x5FEA},
        {0x5C91, 0x5FEB},
        {0x66AB, 0x5FEC},
        {0x6F5B, 0x5FED},
        {0x6F5C, 0x5FEE},
        {0x7BB4, 0x5FEF},
        {0x7C2A, 0x5FF0},
        {0x8695, 0x5FF1},
        {0x8836, 0x5FF2},
        {0x96DC, 0x5FF3},
        {0x4E08, 0x5FF4},
        {0x4ED7, 0x5FF5},
        {0x5320, 0x5FF6},
        {0x5834, 0x5FF7},
        {0x58BB, 0x5FF8},
        {0x596C, 0x5FF9},
        {0x5D82, 0x5FFA},
        {0x5E33, 0x5FFB},
        {0x5E84, 0x5FFC},
        {0x5F35, 0x5FFD},
        {0x638C, 0x5FFE},
        {0x66B2, 0x6041},
        {0x6756, 0x6042},
        {0x6A1F, 0x6043},
        {0x6AA3, 0x6044},
        {0x6B0C, 0x6045},
        {0x6F3F, 0x6046},
        {0x58EF, 0x6047},
        {0x5C07, 0x6048},
        {0x7246, 0x6049},
        {0xF9FA, 0x604A},
        {0x7350, 0x604B},
        {0x748B, 0x604C},
        {0x7634, 0x604D},
        {0x7AE0, 0x604E},
        {0x7CA7, 0x604F},
        {0x8178, 0x6050},
        {0x81DF, 0x6051},
        {0x838A, 0x6052},
        {0x846C, 0x6053},
        {0x8523, 0x6054},
        {0x8594, 0x6055},
        {0x85CF, 0x6056},
        {0x88C5, 0x6057},
        {0x88DD, 0x6058},
        {0x8D13, 0x6059},
        {0x91AC, 0x605A},
        {0x9577, 0x605B},
        {0x969C, 0x605C},
        {0x518D, 0x605D},
        {0x54C9, 0x605E},
        {0x5728, 0x605F},
        {0x5BB0, 0x6060},
        {0x624D, 0x6061},
        {0x6750, 0x6062},
        {0x683D, 0x6063},
        {0x6893, 0x6064},
        {0x6ED3, 0x6065},
        {0x707D, 0x6066},
        {0x7E94, 0x6067},
        {0x88C1, 0x6068},
        {0x8CA1, 0x6069},
        {0x8F09, 0x606A},
        {0x9F4B, 0x606B},
        {0x9F4E, 0x606C},
        {0x722D, 0x606D},
        {0x7B8F, 0x606E},
        {0x8ACD, 0x606F},
        {0x931A, 0x6070},
        {0x4F4E, 0x6071},
        {0x4F47, 0x6072},
        {0x5132, 0x6073},
        {0x5480, 0x6074},
        {0x59D0, 0x6075},
        {0x5E95, 0x6076},
        {0x62B5, 0x6077},
        {0x6775, 0x6078},
        {0x67E2, 0x6079},
        {0x696E, 0x607A},
        {0x6A17, 0x607B},
        {0x6CAE, 0x607C},
        {0x6E1A, 0x607D},
        {0x72D9, 0x607E},
        {0x732A, 0x607F},
        {0x75BD, 0x6080},
        {0x7BB8, 0x6081},
        {0x82E7, 0x6082},
        {0x8457, 0x6083},
        {0x85F7, 0x6084},
        {0x86C6, 0x6085},
        {0x8A5B, 0x6086},
        {0x8C6C, 0x6087},
        {0x8CAF, 0x6088},
        {0x8E87, 0x6089},
        {0x9019, 0x608A},
        {0x90B8, 0x608B},
        {0x52E3, 0x608C},
        {0x5AE1, 0x608D},
        {0x5BC2, 0x608E},
        {0x6458, 0x608F},
        {0x6575, 0x6090},
        {0x6EF4, 0x6091},
        {0x72C4, 0x6092},
        {0x7684, 0x6093},
        {0x7A4D, 0x6094},
        {0x7B1B, 0x6095},
        {0x7C4D, 0x6096},
        {0x7CF4, 0x6097},
        {0x7E3E, 0x6098},
        {0x837B, 0x6099},
        {0x8B2B, 0x609A},
        {0x8CCA, 0x609B},
        {0x8D64, 0x609C},
        {0x8DE1, 0x609D},
        {0x8E5F, 0x609E},
        {0x8FEA, 0x609F},
        {0x8FF9, 0x60A0},
        {0x9069, 0x60A1},
        {0x50B3, 0x60A2},
        {0x5168, 0x60A3},
        {0x5178, 0x60A4},
        {0x524D, 0x60A5},
        {0x526A, 0x60A6},
        {0x56C0, 0x60A7},
        {0x5861, 0x60A8},
        {0x5960, 0x60A9},
        {0x5C08, 0x60AA},
        {0x5C55, 0x60AB},
        {0x5DD3, 0x60AC},
        {0x5EDB, 0x60AD},
        {0x609B, 0x60AE},
        {0x6230, 0x60AF},
        {0x6813, 0x60B0},
        {0x6BBF, 0x60B1},
        {0x6C08, 0x60B2},
        {0x6FB1, 0x60B3},
        {0x714E, 0x60B4},
        {0x7530, 0x60B5},
        {0x7538, 0x60B6},
        {0x7672, 0x60B7},
        {0x78DA, 0x60B8},
        {0x7B8B, 0x60B9},
        {0x7BAD, 0x60BA},
        {0x7BC6, 0x60BB},
        {0x7E8F, 0x60BC},
        {0x7FE6, 0x60BD},
        {0x8A6E, 0x60BE},
        {0x8F3E, 0x60BF},
        {0x8F49, 0x60C0},
        {0x923F, 0x60C1},
        {0x9293, 0x60C2},
        {0x9322, 0x60C3},
        {0x96FB, 0x60C4},
        {0x985A, 0x60C5},
        {0x986B, 0x60C6},
        {0x991E, 0x60C7},
        {0x5207, 0x60C8},
        {0x622A, 0x60C9},
        {0x6298, 0x60CA},
        {0x6D59, 0x60CB},
        {0x7A83, 0x60CC},
        {0x7ACA, 0x60CD},
        {0x7BC0, 0x60CE},
        {0x7D76, 0x60CF},
        {0x5360, 0x60D0},
        {0x5CBE, 0x60D1},
        {0x5E97, 0x60D2},
        {0x6F38, 0x60D3},
        {0x70B9, 0x60D4},
        {0x9EDE, 0x60D5},
        {0x7C98, 0x60D6},
        {0x9711, 0x60D7},
        {0x63A5, 0x60D8},
        {0x647A, 0x60D9},
        {0x6904, 0x60DA},
        {0x8776, 0x60DB},
        {0x4E01, 0x60DC},
        {0x4E95, 0x60DD},
        {0x4EAD, 0x60DE},
        {0x505C, 0x60DF},
        {0x5075, 0x60E0},
        {0x5448, 0x60E1},
        {0x59C3, 0x60E2},
        {0x5E40, 0x60E3},
        {0x5EF7, 0x60E4},
        {0x5F81, 0x60E5},
        {0x5B9A, 0x60E6},
        {0x5EAD, 0x60E7},
        {0x60C5, 0x60E8},
        {0x633A, 0x60E9},
        {0x653F, 0x60EA},
        {0x6574, 0x60EB},
        {0x65CC, 0x60EC},
        {0x6676, 0x60ED},
        {0x6678, 0x60EE},
        {0x6883, 0x60EF},
        {0x6968, 0x60F0},
        {0x6B63, 0x60F1},
        {0x6C40, 0x60F2},
        {0x6DE8, 0x60F3},
        {0x6E1F, 0x60F4},
        {0x753A, 0x60F5},
        {0x775B, 0x60F6},
        {0x7887, 0x60F7},
        {0x798E, 0x60F8},
        {0x7A0B, 0x60F9},
        {0x7A7D, 0x60FA},
        {0x9756, 0x60FB},
        {0x7CBE, 0x60FC},
        {0x8247, 0x60FD},
        {0x8A02, 0x60FE},
        {0x8AEA, 0x6141},
        {0x8C9E, 0x6142},
        {0x912D, 0x6143},
        {0x914A, 0x6144},
        {0x91D8, 0x6145},
        {0x9266, 0x6146},
        {0x9320, 0x6147},
        {0x9706, 0x6148},
        {0x975C, 0x6149},
        {0x9802, 0x614A},
        {0x9F0E, 0x614B},
        {0x5236, 0x614C},
        {0x5291, 0x614D},
        {0x557C, 0x614E},
        {0x5824, 0x614F},
        {0x5E1D, 0x6150},
        {0x5F1F, 0x6151},
        {0x608C, 0x6152},
        {0x63D0, 0x6153},
        {0x6662, 0x6154},
        {0x68AF, 0x6155},
        {0x6FDF, 0x6156},
        {0x7445, 0x6157},
        {0x81CD, 0x6158},
        {0x796D, 0x6159},
        {0x7B2C, 0x615A},
        {0x85BA, 0x615B},
        {0x88FD, 0x615C},
        {0x8AF8, 0x615D},
        {0x8E36, 0x615E},
        {0x8E44, 0x615F},
        {0x918D, 0x6160},
        {0x9664, 0x6161},
        {0x969B, 0x6162},
        {0x973D, 0x6163},
        {0x984C, 0x6164},
        {0x9F4A, 0x6165},
        {0x4FCE, 0x6166},
        {0x51CB, 0x6167},
        {0x5146, 0x6168},
        {0x52A9, 0x6169},
        {0xF8DE, 0x616A},
        {0x5632, 0x616B},
        {0x566A, 0x616C},
        {0x5F14, 0x616D},
        {0x5F6B, 0x616E},
        {0x63AA, 0x616F},
        {0x64CD, 0x6170},
        {0x65E9, 0x6171},
        {0x6641, 0x6172},
        {0x66FA, 0x6173},
        {0x66F9, 0x6174},
        {0x671D, 0x6175},
        {0x689D, 0x6176},
        {0x68D7, 0x6177},
        {0x69FD, 0x6178},
        {0x6F15, 0x6179},
        {0x6F6E, 0x617A},
        {0x7167, 0x617B},
        {0x71E5, 0x617C},
        {0x722A, 0x617D},
        {0x7681, 0x617E},
        {0x773A, 0x617F},
        {0x7956, 0x6180},
        {0x795A, 0x6181},
        {0x79DF, 0x6182},
        {0x7A20, 0x6183},
        {0x7A95, 0x6184},
        {0x7AC8, 0x6185},
        {0x7B0A, 0x6186},
        {0x7C97, 0x6187},
        {0x7CDF, 0x6188},
        {0x7CF6, 0x6189},
        {0x7D44, 0x618A},
        {0x7D5B, 0x618B},
        {0x7E70, 0x618C},
        {0x8087, 0x618D},
        {0x85FB, 0x618E},
        {0x86A4, 0x618F},
        {0x8A54, 0x6190},
        {0x8ABF, 0x6191},
        {0x8D99, 0x6192},
        {0x8E81, 0x6193},
        {0x9020, 0x6194},
        {0x906D, 0x6195},
        {0x91E3, 0x6196},
        {0x963B, 0x6197},
        {0x9BDB, 0x6198},
        {0x9CE5, 0x6199},
        {0x65CF, 0x619A},
        {0x7C07, 0x619B},
        {0x8DB3, 0x619C},
        {0x93C3, 0x619D},
        {0x5B58, 0x619E},
        {0x5C0A, 0x619F},
        {0x5352, 0x61A0},
        {0x62D9, 0x61A1},
        {0x731D, 0x61A2},
        {0x5027, 0x61A3},
        {0x5B97, 0x61A4},
        {0x5F9E, 0x61A5},
        {0x616B, 0x61A6},
        {0x68D5, 0x61A7},
        {0x6A05, 0x61A8},
        {0x6DD9, 0x61A9},
        {0x742E, 0x61AA},
        {0x7A2E, 0x61AB},
        {0x7D42, 0x61AC},
        {0x7D9C, 0x61AD},
        {0x7E31, 0x61AE},
        {0x816B, 0x61AF},
        {0x8E35, 0x61B0},
        {0x8E64, 0x61B1},
        {0x937E, 0x61B2},
        {0x9418, 0x61B3},
        {0x4F50, 0x61B4},
        {0x5750, 0x61B5},
        {0x5DE6, 0x61B6},
        {0x5EA7, 0x61B7},
        {0x632B, 0x61B8},
        {0x7F6A, 0x61B9},
        {0x4E3B, 0x61BA},
        {0x4F4F, 0x61BB},
        {0x4F8F, 0x61BC},
        {0x505A, 0x61BD},
        {0x5EDA, 0x61BE},
        {0x546A, 0x61BF},
        {0x5468, 0x61C0},
        {0x55FE, 0x61C1},
        {0x594F, 0x61C2},
        {0x5B99, 0x61C3},
        {0x5DDE, 0x61C4},
        {0x665D, 0x61C5},
        {0x6731, 0x61C6},
        {0x67F1, 0x61C7},
        {0x682A, 0x61C8},
        {0x70B7, 0x61C9},
        {0x6CE8, 0x61CA},
        {0x6D32, 0x61CB},
        {0x9152, 0x61CC},
        {0x73E0, 0x61CD},
        {0x7587, 0x61CE},
        {0x851F, 0x61CF},
        {0x7C4C, 0x61D0},
        {0x7D02, 0x61D1},
        {0x7D2C, 0x61D2},
        {0x7DA2, 0x61D3},
        {0x8098, 0x61D4},
        {0x80C4, 0x61D5},
        {0x821F, 0x61D6},
        {0x86DB, 0x61D7},
        {0x8A3B, 0x61D8},
        {0x8A85, 0x61D9},
        {0x8D70, 0x61DA},
        {0x8E8A, 0x61DB},
        {0x8F33, 0x61DC},
        {0x914E, 0x61DD},
        {0x9031, 0x61DE},
        {0x9444, 0x61DF},
        {0x99D0, 0x61E0},
        {0x7AF9, 0x61E1},
        {0x7CA5, 0x61E2},
        {0x4FCA, 0x61E3},
        {0x5101, 0x61E4},
        {0x51C6, 0x61E5},
        {0x57C8, 0x61E6},
        {0x5CFB, 0x61E7},
        {0x6659, 0x61E8},
        {0x6A3D, 0x61E9},
        {0x6D5A, 0x61EA},
        {0x6E96, 0x61EB},
        {0x6FEC, 0x61EC},
        {0x756F, 0x61ED},
        {0x7AE3, 0x61EE},
        {0x8822, 0x61EF},
        {0x9021, 0x61F0},
        {0x9075, 0x61F1},
        {0x96BC, 0x61F2},
        {0x99FF, 0x61F3},
        {0x8301, 0x61F4},
        {0x4E2D, 0x61F5},
        {0x4EF2, 0x61F6},
        {0x8846, 0x61F7},
        {0x91CD, 0x61F8},
        {0xF8DD, 0x61F9},
        {0x537D, 0x61FA},
        {0x6ADB, 0x61FB},
        {0x696B, 0x61FC},
        {0x6C41, 0x61FD},
        {0x847A, 0x61FE},
        {0x589E, 0x6241},
        {0x618E, 0x6242},
        {0x62EF, 0x6243},
        {0x70DD, 0x6244},
        {0x66FE, 0x6245},
        {0x7511, 0x6246},
        {0x75C7, 0x6247},
        {0x84B8, 0x6248},
        {0x8A3C, 0x6249},
        {0x8B49, 0x624A},
        {0x8D08, 0x624B},
        {0x4E4B, 0x624C},
        {0x53EA, 0x624D},
        {0x54AB, 0x624E},
        {0x5730, 0x624F},
        {0x5740, 0x6250},
        {0x5FD7, 0x6251},
        {0x6301, 0x6252},
        {0x6307, 0x6253},
        {0x646F, 0x6254},
        {0x652F, 0x6255},
        {0x65E8, 0x6256},
        {0x667A, 0x6257},
        {0x679D, 0x6258},
        {0x67B3, 0x6259},
        {0x6B62, 0x625A},
        {0x6C60, 0x625B},
        {0x6F2C, 0x625C},
        {0x75E3, 0x625D},
        {0x77E5, 0x625E},
        {0x7825, 0x625F},
        {0x7957, 0x6260},
        {0x7949, 0x6261},
        {0x7D19, 0x6262},
        {0x80A2, 0x6263},
        {0x8102, 0x6264},
        {0x81F3, 0x6265},
        {0x829D, 0x6266},
        {0x8718, 0x6267},
        {0x8A8C, 0x6268},
        {0xF9FC, 0x6269},
        {0x8D04, 0x626A},
        {0x8DBE, 0x626B},
        {0x9072, 0x626C},
        {0x76F4, 0x626D},
        {0x7A19, 0x626E},
        {0x7A37, 0x626F},
        {0x7E54, 0x6270},
        {0x8077, 0x6271},
        {0x8FB0, 0x6272},
        {0x55D4, 0x6273},
        {0x5875, 0x6274},
        {0x632F, 0x6275},
        {0x6649, 0x6276},
        {0x699B, 0x6277},
        {0x6D25, 0x6278},
        {0x6EB1, 0x6279},
        {0x73CD, 0x627A},
        {0x7468, 0x627B},
        {0x74A1, 0x627C},
        {0x75B9, 0x627D},
        {0x76E1, 0x627E},
        {0x771E, 0x627F},
        {0x778B, 0x6280},
        {0x79E6, 0x6281},
        {0x7E09, 0x6282},
        {0x8A3A, 0x6283},
        {0x8CD1, 0x6284},
        {0x8EEB, 0x6285},
        {0x9032, 0x6286},
        {0x93AD, 0x6287},
        {0x9663, 0x6288},
        {0x9673, 0x6289},
        {0x9707, 0x628A},
        {0x53F1, 0x628B},
        {0x7A92, 0x628C},
        {0x59EA, 0x628D},
        {0x5AC9, 0x628E},
        {0x5E19, 0x628F},
        {0x684E, 0x6290},
        {0x75BE, 0x6291},
        {0x79E9, 0x6292},
        {0x81A3, 0x6293},
        {0x86ED, 0x6294},
        {0x8CEA, 0x6295},
        {0x8DCC, 0x6296},
        {0x8FED, 0x6297},
        {0x659F, 0x6298},
        {0x6715, 0x6299},
        {0x57F7, 0x629A},
        {0x96C6, 0x629B},
        {0x7DDD, 0x629C},
        {0x8F2F, 0x629D},
        {0x5FB5, 0x629E},
        {0x61F2, 0x629F},
        {0x6F84, 0x62A0},
        {0x4E14, 0x62A1},
        {0x501F, 0x62A2},
        {0x7B9A, 0x62A3},
        {0x53C9, 0x62A4},
        {0x55DF, 0x62A5},
        {0x5DEE, 0x62A6},
        {0x5D6F, 0x62A7},
        {0x6B21, 0x62A8},
        {0x6B64, 0x62A9},
        {0x78CB, 0x62AA},
        {0xF9FE, 0x62AB},
        {0x8E49, 0x62AC},
        {0x906E, 0x62AD},
        {0x8ECA, 0x62AE},
        {0x6349, 0x62AF},
        {0x643E, 0x62B0},
        {0x7740, 0x62B1},
        {0x7A84, 0x62B2},
        {0x932F, 0x62B3},
        {0x947F, 0x62B4},
        {0x9F6A, 0x62B5},
        {0x64B0, 0x62B6},
        {0x6FAF, 0x62B7},
        {0x71E6, 0x62B8},
        {0x74A8, 0x62B9},
        {0x74DA, 0x62BA},
        {0x7AC4, 0x62BB},
        {0x7E82, 0x62BC},
        {0x7CB2, 0x62BD},
        {0x7E98, 0x62BE},
        {0x8B9A, 0x62BF},
        {0x8D0A, 0x62C0},
        {0x947D, 0x62C1},
        {0xF8DC, 0x62C2},
        {0x9910, 0x62C3},
        {0x994C, 0x62C4},
        {0x5239, 0x62C5},
        {0x5BDF, 0x62C6},
        {0x64E6, 0x62C7},
        {0x672D, 0x62C8},
        {0x50ED, 0x62C9},
        {0x53C3, 0x62CA},
        {0x5879, 0x62CB},
        {0x6158, 0x62CC},
        {0x6159, 0x62CD},
        {0x615A, 0x62CE},
        {0x61FA, 0x62CF},
        {0x65AC, 0x62D0},
        {0x7AD9, 0x62D1},
        {0x8B92, 0x62D2},
        {0x5021, 0x62D3},
        {0x5009, 0x62D4},
        {0x5231, 0x62D5},
        {0x5275, 0x62D6},
        {0x5531, 0x62D7},
        {0x5A3C, 0x62D8},
        {0x5EE0, 0x62D9},
        {0x5F70, 0x62DA},
        {0x60B5, 0x62DB},
        {0x655E, 0x62DC},
        {0x660C, 0x62DD},
        {0x6636, 0x62DE},
        {0x66A2, 0x62DF},
        {0x69CD, 0x62E0},
        {0x6C05, 0x62E1},
        {0x6EC4, 0x62E2},
        {0x6F32, 0x62E3},
        {0x7621, 0x62E4},
        {0x7A93, 0x62E5},
        {0x8139, 0x62E6},
        {0x8259, 0x62E7},
        {0x83D6, 0x62E8},
        {0x84BC, 0x62E9},
        {0x50B5, 0x62EA},
        {0x57F0, 0x62EB},
        {0x5F69, 0x62EC},
        {0x63A1, 0x62ED},
        {0x7826, 0x62EE},
        {0x7DB5, 0x62EF},
        {0x83DC, 0x62F0},
        {0x8521, 0x62F1},
        {0x91C7, 0x62F2},
        {0x91F5, 0x62F3},
        {0x518A, 0x62F4},
        {0x67F5, 0x62F5},
        {0x7B56, 0x62F6},
        {0x7C00, 0x62F7},
        {0x8CAC, 0x62F8},
        {0x51C4, 0x62F9},
        {0x59BB, 0x62FA},
        {0x60BD, 0x62FB},
        {0x8655, 0x62FC},
        {0xF9FF, 0x62FD},
        {0x5254, 0x62FE},
        {0x5C3A, 0x6341},
        {0x617D, 0x6342},
        {0x621A, 0x6343},
        {0x62D3, 0x6344},
        {0x64F2, 0x6345},
        {0x65A5, 0x6346},
        {0x6ECC, 0x6347},
        {0x7620, 0x6348},
        {0x810A, 0x6349},
        {0x8734, 0x634A},
        {0x8E91, 0x634B},
        {0x965F, 0x634C},
        {0x96BB, 0x634D},
        {0x4EDF, 0x634E},
        {0x5343, 0x634F},
        {0x5598, 0x6350},
        {0x5929, 0x6351},
        {0x5DDD, 0x6352},
        {0x64C5, 0x6353},
        {0x6CC9, 0x6354},
        {0x6DFA, 0x6355},
        {0x6FFA, 0x6356},
        {0x7A7F, 0x6357},
        {0x821B, 0x6358},
        {0x85A6, 0x6359},
        {0x8CE4, 0x635A},
        {0x8E10, 0x635B},
        {0x9077, 0x635C},
        {0x91E7, 0x635D},
        {0x95E1, 0x635E},
        {0x9621, 0x635F},
        {0x97C6, 0x6360},
        {0x51F8, 0x6361},
        {0x5FB9, 0x6362},
        {0x54F2, 0x6363},
        {0x5586, 0x6364},
        {0x64A4, 0x6365},
        {0x6F88, 0x6366},
        {0x7DB4, 0x6367},
        {0x8F4D, 0x6368},
        {0x9435, 0x6369},
        {0x50C9, 0x636A},
        {0x5C16, 0x636B},
        {0x6CBE, 0x636C},
        {0x6DFB, 0x636D},
        {0x751B, 0x636E},
        {0x77BB, 0x636F},
        {0x7C37, 0x6370},
        {0x7C64, 0x6371},
        {0x8AC2, 0x6372},
        {0x59BE, 0x6373},
        {0x5E16, 0x6374},
        {0x6377, 0x6375},
        {0x7252, 0x6376},
        {0x758A, 0x6377},
        {0x776B, 0x6378},
        {0x8ADC, 0x6379},
        {0x8CBC, 0x637A},
        {0x8F12, 0x637B},
        {0x5EF3, 0x637C},
        {0x6674, 0x637D},
        {0x6DF8, 0x637E},
        {0x807D, 0x637F},
        {0x83C1, 0x6380},
        {0x873B, 0x6381},
        {0x8ACB, 0x6382},
        {0x9751, 0x6383},
        {0x9BD6, 0x6384},
        {0xFA00, 0x6385},
        {0x5243, 0x6386},
        {0x66FF, 0x6387},
        {0x6D95, 0x6388},
        {0x6EEF, 0x6389},
        {0x780C, 0x638A},
        {0x7DE0, 0x638B},
        {0x8AE6, 0x638C},
        {0x902E, 0x638D},
        {0x905E, 0x638E},
        {0x9746, 0x638F},
        {0x9AD4, 0x6390},
        {0x521D, 0x6391},
        {0x54E8, 0x6392},
        {0x5CED, 0x6393},
        {0x6194, 0x6394},
        {0x6284, 0x6395},
        {0x62DB, 0x6396},
        {0x68A2, 0x6397},
        {0x6912, 0x6398},
        {0x695A, 0x6399},
        {0x6A35, 0x639A},
        {0x7092, 0x639B},
        {0x7126, 0x639C},
        {0x785D, 0x639D},
        {0x7901, 0x639E},
        {0x790E, 0x639F},
        {0x79D2, 0x63A0},
        {0x7A0D, 0x63A1},
        {0x7D83, 0x63A2},
        {0x8096, 0x63A3},
        {0x8349, 0x63A4},
        {0x8549, 0x63A5},
        {0x8C82, 0x63A6},
        {0x8D85, 0x63A7},
        {0x9162, 0x63A8},
        {0x918B, 0x63A9},
        {0x91AE, 0x63AA},
        {0x9214, 0x63AB},
        {0x9798, 0x63AC},
        {0x4FC3, 0x63AD},
        {0x56D1, 0x63AE},
        {0xF8DB, 0x63AF},
        {0x71ED, 0x63B0},
        {0x77D7, 0x63B1},
        {0x8700, 0x63B2},
        {0x89F8, 0x63B3},
        {0x8E85, 0x63B4},
        {0x9AD1, 0x63B5},
        {0x5BF8, 0x63B6},
        {0x5FD6, 0x63B7},
        {0x6751, 0x63B8},
        {0x53E2, 0x63B9},
        {0x585A, 0x63BA},
        {0x5BF5, 0x63BB},
        {0x6031, 0x63BC},
        {0x6460, 0x63BD},
        {0x7E3D, 0x63BE},
        {0x8070, 0x63BF},
        {0x8471, 0x63C0},
        {0x9283, 0x63C1},
        {0x64AE, 0x63C2},
        {0x50AC, 0x63C3},
        {0x5D14, 0x63C4},
        {0x6467, 0x63C5},
        {0x6700, 0x63C6},
        {0x589C, 0x63C7},
        {0x62BD, 0x63C8},
        {0x63A8, 0x63C9},
        {0x690E, 0x63CA},
        {0x6978, 0x63CB},
        {0xF8DA, 0x63CC},
        {0x6A1E, 0x63CD},
        {0x6E6B, 0x63CE},
        {0x7503, 0x63CF},
        {0x76BA, 0x63D0},
        {0x79CB, 0x63D1},
        {0x7B92, 0x63D2},
        {0x82BB, 0x63D3},
        {0x8429, 0x63D4},
        {0x8DA8, 0x63D5},
        {0x8FFD, 0x63D6},
        {0x9112, 0x63D7},
        {0x914B, 0x63D8},
        {0x919C, 0x63D9},
        {0x9318, 0x63DA},
        {0x9310, 0x63DB},
        {0x96DB, 0x63DC},
        {0x97A6, 0x63DD},
        {0x9C0D, 0x63DE},
        {0x9E81, 0x63DF},
        {0x9EA4, 0x63E0},
        {0x4E11, 0x63E1},
        {0xF8D9, 0x63E2},
        {0x795D, 0x63E3},
        {0x755C, 0x63E4},
        {0x7AFA, 0x63E5},
        {0x7B51, 0x63E6},
        {0x7BC9, 0x63E7},
        {0x7E2E, 0x63E8},
        {0x8233, 0x63E9},
        {0x84C4, 0x63EA},
        {0x8E74, 0x63EB},
        {0x8EF8, 0x63EC},
        {0x9010, 0x63ED},
        {0x6625, 0x63EE},
        {0x693F, 0x63EF},
        {0x51FA, 0x63F0},
        {0x9EDC, 0x63F1},
        {0x5145, 0x63F2},
        {0x51B2, 0x63F3},
        {0x5FE0, 0x63F4},
        {0x6C96, 0x63F5},
        {0x87F2, 0x63F6},
        {0x885D, 0x63F7},
        {0x8877, 0x63F8},
        {0x60B4, 0x63F9},
        {0x81B5, 0x63FA},
        {0x8403, 0x63FB},
        {0x53D6, 0x63FC},
        {0x5439, 0x63FD},
        {0x5634, 0x63FE},
        {0x5A36, 0x6441},
        {0x5C31, 0x6442},
        {0x6A47, 0x6443},
        {0x708A, 0x6444},
        {0x7FE0, 0x6445},
        {0x805A, 0x6446},
        {0x8106, 0x6447},
        {0x81ED, 0x6448},
        {0xF8D8, 0x6449},
        {0x8DA3, 0x644A},
        {0x9189, 0x644B},
        {0x9A5F, 0x644C},
        {0x9DF2, 0x644D},
        {0x4EC4, 0x644E},
        {0x5074, 0x644F},
        {0x60FB, 0x6450},
        {0x6E2C, 0x6451},
        {0x5C64, 0x6452},
        {0x4F88, 0x6453},
        {0x5024, 0x6454},
        {0x55E4, 0x6455},
        {0x5CD9, 0x6456},
        {0x5DF5, 0x6457},
        {0x5E5F, 0x6458},
        {0x5FB4, 0x6459},
        {0x6894, 0x645A},
        {0x6CBB, 0x645B},
        {0x6DC4, 0x645C},
        {0x71BE, 0x645D},
        {0x75D4, 0x645E},
        {0x75F4, 0x645F},
        {0x7661, 0x6460},
        {0x96C9, 0x6461},
        {0x7A1A, 0x6462},
        {0x7DC7, 0x6463},
        {0x7DFB, 0x6464},
        {0x7F6E, 0x6465},
        {0x6065, 0x6466},
        {0x81F4, 0x6467},
        {0x8F1C, 0x6468},
        {0x99B3, 0x6469},
        {0x9D44, 0x646A},
        {0x9F52, 0x646B},
        {0x5247, 0x646C},
        {0x52C5, 0x646D},
        {0x98ED, 0x646E},
        {0x89AA, 0x646F},
        {0x4E03, 0x6470},
        {0x67D2, 0x6471},
        {0x6F06, 0x6472},
        {0x4FB5, 0x6473},
        {0x5BE2, 0x6474},
        {0x5FF1, 0x6475},
        {0x6795, 0x6476},
        {0x6C88, 0x6477},
        {0x6D78, 0x6478},
        {0x7827, 0x6479},
        {0x91DD, 0x647A},
        {0x937C, 0x647B},
        {0x87C4, 0x647C},
        {0x79E4, 0x647D},
        {0x7A31, 0x647E},
        {0x5FEB, 0x647F},
        {0x4ED6, 0x6480},
        {0x553E, 0x6481},
        {0x58AE, 0x6482},
        {0x59A5, 0x6483},
        {0x60F0, 0x6484},
        {0x6253, 0x6485},
        {0x6736, 0x6486},
        {0x6955, 0x6487},
        {0x8235, 0x6488},
        {0x9640, 0x6489},
        {0x99DD, 0x648A},
        {0x502C, 0x648B},
        {0x5353, 0x648C},
        {0x5544, 0x648D},
        {0xFA01, 0x648E},
        {0x6258, 0x648F},
        {0x62C6, 0x6490},
        {0xFA02, 0x6491},
        {0x64E2, 0x6492},
        {0x67DD, 0x6493},
        {0x6A50, 0x6494},
        {0x6FC1, 0x6495},
        {0x6FEF, 0x6496},
        {0x7422, 0x6497},
        {0x8A17, 0x6498},
        {0x9438, 0x6499},
        {0x5451, 0x649A},
        {0x5606, 0x649B},
        {0x5766, 0x649C},
        {0x5F48, 0x649D},
        {0x619A, 0x649E},
        {0x6B4E, 0x649F},
        {0x7058, 0x64A0},
        {0x70AD, 0x64A1},
        {0x7DBB, 0x64A2},
        {0x8A95, 0x64A3},
        {0x596A, 0x64A4},
        {0x812B, 0x64A5},
        {0x63A2, 0x64A6},
        {0x803D, 0x64A7},
        {0x8CAA, 0x64A8},
        {0x5854, 0x64A9},
        {0x642D, 0x64AA},
        {0x69BB, 0x64AB},
        {0x5B95, 0x64AC},
        {0x5E11, 0x64AD},
        {0x6E6F, 0x64AE},
        {0x8569, 0x64AF},
        {0x514C, 0x64B0},
        {0x53F0, 0x64B1},
        {0x592A, 0x64B2},
        {0x6020, 0x64B3},
        {0x614B, 0x64B4},
        {0x6B86, 0x64B5},
        {0x6C70, 0x64B6},
        {0x6CF0, 0x64B7},
        {0x7B1E, 0x64B8},
        {0x80CE, 0x64B9},
        {0x82D4, 0x64BA},
        {0x8DC6, 0x64BB},
        {0x90B0, 0x64BC},
        {0x98B1, 0x64BD},
        {0x99C4, 0x64BE},
        {0xFA04, 0x64BF},
        {0x64C7, 0x64C0},
        {0x6FA4, 0x64C1},
        {0xF8D7, 0x64C2},
        {0x6491, 0x64C3},
        {0x6504, 0x64C4},
        {0x514E, 0x64C5},
        {0x5410, 0x64C6},
        {0x571F, 0x64C7},
        {0x8A0E, 0x64C8},
        {0x615F, 0x64C9},
        {0x6876, 0x64CA},
        {0xFA05, 0x64CB},
        {0x75DB, 0x64CC},
        {0x7B52, 0x64CD},
        {0x7D71, 0x64CE},
        {0x901A, 0x64CF},
        {0x5806, 0x64D0},
        {0x817F, 0x64D1},
        {0x892A, 0x64D2},
        {0x9000, 0x64D3},
        {0x9839, 0x64D4},
        {0x5078, 0x64D5},
        {0x5957, 0x64D6},
        {0x59AC, 0x64D7},
        {0x6295, 0x64D8},
        {0x900F, 0x64D9},
        {0x9B2A, 0x64DA},
        {0x615D, 0x64DB},
        {0x7279, 0x64DC},
        {0x5A46, 0x64DD},
        {0x5761, 0x64DE},
        {0x5DF4, 0x64DF},
        {0x628A, 0x64E0},
        {0x64AD, 0x64E1},
        {0x6777, 0x64E2},
        {0x6CE2, 0x64E3},
        {0x6D3E, 0x64E4},
        {0x722C, 0x64E5},
        {0x7436, 0x64E6},
        {0x7834, 0x64E7},
        {0x7F77, 0x64E8},
        {0x82AD, 0x64E9},
        {0x8DDB, 0x64EA},
        {0x9817, 0x64EB},
        {0x5742, 0x64EC},
        {0x5224, 0x64ED},
        {0x677F, 0x64EE},
        {0x7248, 0x64EF},
        {0x8CA9, 0x64F0},
        {0x8FA6, 0x64F1},
        {0x74E3, 0x64F2},
        {0x962A, 0x64F3},
        {0x516B, 0x64F4},
        {0x53ED, 0x64F5},
        {0x634C, 0x64F6},
        {0x4F69, 0x64F7},
        {0x5504, 0x64F8},
        {0x6096, 0x64F9},
        {0x6C9B, 0x64FA},
        {0x6D7F, 0x64FB},
        {0x724C, 0x64FC},
        {0x72FD, 0x64FD},
        {0x7A17, 0x64FE},
        {0x8C9D, 0x6541},
        {0x6557, 0x6542},
        {0x8987, 0x6543},
        {0x5F6D, 0x6544},
        {0x6F8E, 0x6545},
        {0x70F9, 0x6546},
        {0x81A8, 0x6547},
        {0x610E, 0x6548},
        {0x4FBF, 0x6549},
        {0x504F, 0x654A},
        {0x6241, 0x654B},
        {0x7247, 0x654C},
        {0x7BC7, 0x654D},
        {0x7DE8, 0x654E},
        {0x7FE9, 0x654F},
        {0x8759, 0x6550},
        {0x904D, 0x6551},
        {0x97AD, 0x6552},
        {0x8CB6, 0x6553},
        {0x576A, 0x6554},
        {0x5E73, 0x6555},
        {0x840D, 0x6556},
        {0x8A55, 0x6557},
        {0x5420, 0x6558},
        {0x5B16, 0x6559},
        {0x5E63, 0x655A},
        {0x5EE2, 0x655B},
        {0x5F0A, 0x655C},
        {0x6583, 0x655D},
        {0x80BA, 0x655E},
        {0x853D, 0x655F},
        {0x9589, 0x6560},
        {0x965B, 0x6561},
        {0x4F48, 0x6562},
        {0x5305, 0x6563},
        {0x530D, 0x6564},
        {0x530F, 0x6565},
        {0x5486, 0x6566},
        {0x54FA, 0x6567},
        {0x5703, 0x6568},
        {0x5E96, 0x6569},
        {0x5E03, 0x656A},
        {0x6016, 0x656B},
        {0x62B1, 0x656C},
        {0x629B, 0x656D},
        {0x6355, 0x656E},
        {0x6CE1, 0x656F},
        {0x6D66, 0x6570},
        {0x70AE, 0x6571},
        {0x75B1, 0x6572},
        {0x7832, 0x6573},
        {0x80DE, 0x6574},
        {0x812F, 0x6575},
        {0x8216, 0x6576},
        {0x8461, 0x6577},
        {0x84B2, 0x6578},
        {0x888D, 0x6579},
        {0x8912, 0x657A},
        {0x924B, 0x657B},
        {0x92EA, 0x657C},
        {0x9784, 0x657D},
        {0x98FD, 0x657E},
        {0x9B91, 0x657F},
        {0x5E45, 0x6580},
        {0x66B4, 0x6581},
        {0x7011, 0x6582},
        {0x7206, 0x6583},
        {0x4FF5, 0x6584},
        {0x527D, 0x6585},
        {0x5F6A, 0x6586},
        {0x6153, 0x6587},
        {0x6753, 0x6588},
        {0x6A19, 0x6589},
        {0x6F02, 0x658A},
        {0x74E2, 0x658B},
        {0x7968, 0x658C},
        {0x8868, 0x658D},
        {0x8C79, 0x658E},
        {0x98C4, 0x658F},
        {0xF8D6, 0x6590},
        {0x54C1, 0x6591},
        {0x7A1F, 0x6592},
        {0x99AE, 0x6593},
        {0x6953, 0x6594},
        {0x8AF7, 0x6595},
        {0x8C4A, 0x6596},
        {0x98A8, 0x6597},
        {0x5F7C, 0x6598},
        {0x62AB, 0x6599},
        {0x75B2, 0x659A},
        {0x76AE, 0x659B},
        {0x84D6, 0x659C},
        {0x88AB, 0x659D},
        {0x907F, 0x659E},
        {0x5339, 0x659F},
        {0x5F3C, 0x65A0},
        {0x5FC5, 0x65A1},
        {0x6CCC, 0x65A2},
        {0x7562, 0x65A3},
        {0x758B, 0x65A4},
        {0x7B46, 0x65A5},
        {0x8E55, 0x65A6},
        {0x4E4F, 0x65A7},
        {0x903C, 0x65A8},
        {0x4E0B, 0x65A9},
        {0x4F55, 0x65AA},
        {0x590F, 0x65AB},
        {0x5EC8, 0x65AC},
        {0x6630, 0x65AD},
        {0x6CB3, 0x65AE},
        {0x7455, 0x65AF},
        {0x8766, 0x65B0},
        {0x8377, 0x65B1},
        {0x8CC0, 0x65B2},
        {0x9050, 0x65B3},
        {0x971E, 0x65B4},
        {0x9C15, 0x65B5},
        {0x58D1, 0x65B6},
        {0x5B78, 0x65B7},
        {0x7627, 0x65B8},
        {0x8650, 0x65B9},
        {0x8B14, 0x65BA},
        {0x9DB4, 0x65BB},
        {0x5BD2, 0x65BC},
        {0x6068, 0x65BD},
        {0x608D, 0x65BE},
        {0x65F1, 0x65BF},
        {0x6C57, 0x65C0},
        {0x6F22, 0x65C1},
        {0x6FA3, 0x65C2},
        {0x7F55, 0x65C3},
        {0x7FF0, 0x65C4},
        {0xF8D5, 0x65C5},
        {0x9592, 0x65C6},
        {0x9591, 0x65C7},
        {0x9650, 0x65C8},
        {0x97D3, 0x65C9},
        {0x9DF3, 0x65CA},
        {0x5272, 0x65CB},
        {0x8F44, 0x65CC},
        {0x51FD, 0x65CD},
        {0x542B, 0x65CE},
        {0x54B8, 0x65CF},
        {0x5563, 0x65D0},
        {0x558A, 0x65D1},
        {0x6ABB, 0x65D2},
        {0x6DB5, 0x65D3},
        {0x7DD8, 0x65D4},
        {0x8266, 0x65D5},
        {0x9677, 0x65D6},
        {0x5408, 0x65D7},
        {0x54C8, 0x65D8},
        {0x76D2, 0x65D9},
        {0x86E4, 0x65DA},
        {0x95A4, 0x65DB},
        {0x965C, 0x65DC},
        {0x4EA2, 0x65DD},
        {0x4F09, 0x65DE},
        {0x59EE, 0x65DF},
        {0x5DF7, 0x65E0},
        {0x6052, 0x65E1},
        {0x6297, 0x65E2},
        {0x676D, 0x65E3},
        {0x6841, 0x65E4},
        {0x6C86, 0x65E5},
        {0x6E2F, 0x65E6},
        {0x7095, 0x65E7},
        {0x7F38, 0x65E8},
        {0x809B, 0x65E9},
        {0x822A, 0x65EA},
        {0xFA09, 0x65EB},
        {0x9805, 0x65EC},
        {0x4EA5, 0x65ED},
        {0x5055, 0x65EE},
        {0x54B3, 0x65EF},
        {0x595A, 0x65F0},
        {0x5793, 0x65F1},
        {0x5B69, 0x65F2},
        {0x5BB3, 0x65F3},
        {0x5EE8, 0x65F4},
        {0x61C8, 0x65F5},
        {0x6977, 0x65F6},
        {0x6D77, 0x65F7},
        {0x87F9, 0x65F8},
        {0x89E3, 0x65F9},
        {0x8A72, 0x65FA},
        {0x8AE7, 0x65FB},
        {0x9082, 0x65FC},
        {0x99ED, 0x65FD},
        {0x9AB8, 0x65FE},
        {0x52BE, 0x6641},
        {0x6838, 0x6642},
        {0x5016, 0x6643},
        {0x5E78, 0x6644},
        {0x674F, 0x6645},
        {0x884C, 0x6646},
        {0x4EAB, 0x6647},
        {0x5411, 0x6648},
        {0x56AE, 0x6649},
        {0x9115, 0x664A},
        {0x73E6, 0x664B},
        {0x97FF, 0x664C},
        {0x9909, 0x664D},
        {0x9957, 0x664E},
        {0x9999, 0x664F},
        {0x5653, 0x6650},
        {0x589F, 0x6651},
        {0x865B, 0x6652},
        {0x8A31, 0x6653},
        {0x61B2, 0x6654},
        {0x8ED2, 0x6655},
        {0x737B, 0x6656},
        {0x6B47, 0x6657},
        {0x96AA, 0x6658},
        {0x9A57, 0x6659},
        {0x5955, 0x665A},
        {0x7200, 0x665B},
        {0x8D6B, 0x665C},
        {0x9769, 0x665D},
        {0x5CF4, 0x665E},
        {0x5F26, 0x665F},
        {0x61F8, 0x6660},
        {0x70AB, 0x6661},
        {0x73FE, 0x6662},
        {0x7384, 0x6663},
        {0x7729, 0x6664},
        {0x7D43, 0x6665},
        {0x7D62, 0x6666},
        {0x7E23, 0x6667},
        {0x8237, 0x6668},
        {0x8852, 0x6669},
        {0xFA0A, 0x666A},
        {0x8CE2, 0x666B},
        {0x9249, 0x666C},
        {0x986F, 0x666D},
        {0x5B51, 0x666E},
        {0x7A74, 0x666F},
        {0x8840, 0x6670},
        {0x9801, 0x6671},
        {0x5ACC, 0x6672},
        {0xF8D4, 0x6673},
        {0x4FE0, 0x6674},
        {0x5354, 0x6675},
        {0x593E, 0x6676},
        {0x5CFD, 0x6677},
        {0x633E, 0x6678},
        {0x6D79, 0x6679},
        {0x72F9, 0x667A},
        {0x7BCB, 0x667B},
        {0x8107, 0x667C},
        {0x8105, 0x667D},
        {0x83A2, 0x667E},
        {0xF8D3, 0x667F},
        {0x92CF, 0x6680},
        {0x9830, 0x6681},
        {0x4EA8, 0x6682},
        {0x5211, 0x6683},
        {0x578B, 0x6684},
        {0x5F62, 0x6685},
        {0x5144, 0x6686},
        {0x7005, 0x6687},
        {0x70AF, 0x6688},
        {0x73E9, 0x6689},
        {0x834A, 0x668A},
        {0x87A2, 0x668B},
        {0x8861, 0x668C},
        {0x90A2, 0x668D},
        {0x93A3, 0x668E},
        {0x99A8, 0x668F},
        {0x516E, 0x6690},
        {0x5F57, 0x6691},
        {0x60E0, 0x6692},
        {0x6167, 0x6693},
        {0x8559, 0x6694},
        {0x91AF, 0x6695},
        {0x978B, 0x6696},
        {0x4E4E, 0x6697},
        {0x4E92, 0x6698},
        {0x8C6A, 0x6699},
        {0x547C, 0x669A},
        {0x58FA, 0x669B},
        {0x58D5, 0x669C},
        {0x597D, 0x669D},
        {0x5F27, 0x669E},
        {0x660A, 0x669F},
        {0x6236, 0x66A0},
        {0x6BEB, 0x66A1},
        {0x6D69, 0x66A2},
        {0x6DCF, 0x66A3},
        {0x6E56, 0x66A4},
        {0x6EF8, 0x66A5},
        {0x6F94, 0x66A6},
        {0x6FE9, 0x66A7},
        {0x6FE0, 0x66A8},
        {0x705D, 0x66A9},
        {0x72D0, 0x66AA},
        {0x745A, 0x66AB},
        {0x74E0, 0x66AC},
        {0x7693, 0x66AD},
        {0x769E, 0x66AE},
        {0x795C, 0x66AF},
        {0x7CCA, 0x66B0},
        {0x7E1E, 0x66B1},
        {0x80E1, 0x66B2},
        {0x846B, 0x66B3},
        {0x864E, 0x66B4},
        {0x865F, 0x66B5},
        {0x8774, 0x66B6},
        {0x8B77, 0x66B7},
        {0x6248, 0x66B8},
        {0x9190, 0x66B9},
        {0x93AC, 0x66BA},
        {0x9800, 0x66BB},
        {0x9865, 0x66BC},
        {0x60D1, 0x66BD},
        {0x6216, 0x66BE},
        {0x9177, 0x66BF},
        {0x5A5A, 0x66C0},
        {0x660F, 0x66C1},
        {0x6DF7, 0x66C2},
        {0x6E3E, 0x66C3},
        {0x743F, 0x66C4},
        {0x9B42, 0x66C5},
        {0x5FFD, 0x66C6},
        {0x60DA, 0x66C7},
        {0x7B0F, 0x66C8},
        {0x9DBB, 0x66C9},
        {0x5F18, 0x66CA},
        {0x54C4, 0x66CB},
        {0x6C5E, 0x66CC},
        {0x6CD3, 0x66CD},
        {0x6D2A, 0x66CE},
        {0x9D3B, 0x66CF},
        {0x7D05, 0x66D0},
        {0x8679, 0x66D1},
        {0x8A0C, 0x66D2},
        {0x5316, 0x66D3},
        {0x5B05, 0x66D4},
        {0x6A3A, 0x66D5},
        {0x706B, 0x66D6},
        {0x798D, 0x66D7},
        {0x7575, 0x66D8},
        {0x79BE, 0x66D9},
        {0x548C, 0x66DA},
        {0x82B1, 0x66DB},
        {0x83EF, 0x66DC},
        {0x8A71, 0x66DD},
        {0x9774, 0x66DE},
        {0x8CA8, 0x66DF},
        {0xFA0B, 0x66E0},
        {0x64F4, 0x66E1},
        {0x652B, 0x66E2},
        {0x78BA, 0x66E3},
        {0x78BB, 0x66E4},
        {0x7A6B, 0x66E5},
        {0x944A, 0x66E6},
        {0x4E38, 0x66E7},
        {0x559A, 0x66E8},
        {0x571C, 0x66E9},
        {0x5BA6, 0x66EA},
        {0x5E7B, 0x66EB},
        {0x60A3, 0x66EC},
        {0x61FD, 0x66ED},
        {0x63DB, 0x66EE},
        {0x6853, 0x66EF},
        {0x6B61, 0x66F0},
        {0x6E19, 0x66F1},
        {0x7165, 0x66F2},
        {0x74B0, 0x66F3},
        {0x7D08, 0x66F4},
        {0x9084, 0x66F5},
        {0x9A69, 0x66F6},
        {0x9C25, 0x66F7},
        {0x9B1F, 0x66F8},
        {0x6D3B, 0x66F9},
        {0x6ED1, 0x66FA},
        {0x733E, 0x66FB},
        {0x8C41, 0x66FC},
        {0x95CA, 0x66FD},
        {0x51F0, 0x66FE},
        {0x5A93, 0x6741},
        {0x5FA8, 0x6742},
        {0x6033, 0x6743},
        {0x604D, 0x6744},
        {0x614C, 0x6745},
        {0x60F6, 0x6746},
        {0x6643, 0x6747},
        {0x6CC1, 0x6748},
        {0x6EC9, 0x6749},
        {0x714C, 0x674A},
        {0x7687, 0x674B},
        {0x7BC1, 0x674C},
        {0x8352, 0x674D},
        {0x8757, 0x674E},
        {0x9051, 0x674F},
        {0x968D, 0x6750},
        {0x9EC3, 0x6751},
        {0x56DE, 0x6752},
        {0x5EFB, 0x6753},
        {0x5F8A, 0x6754},
        {0x6062, 0x6755},
        {0x6094, 0x6756},
        {0x61F7, 0x6757},
        {0x6666, 0x6758},
        {0x6703, 0x6759},
        {0x6A9C, 0x675A},
        {0x6DEE, 0x675B},
        {0x6FAE, 0x675C},
        {0x7070, 0x675D},
        {0x736A, 0x675E},
        {0x7E6A, 0x675F},
        {0x81BE, 0x6760},
        {0x86D4, 0x6761},
        {0x8AA8, 0x6762},
        {0x8CC4, 0x6763},
        {0x5283, 0x6764},
        {0x7372, 0x6765},
        {0x6A6B, 0x6766},
        {0x54EE, 0x6767},
        {0x5686, 0x6768},
        {0x56C2, 0x6769},
        {0x5B5D, 0x676A},
        {0x6548, 0x676B},
        {0x66C9, 0x676C},
        {0x689F, 0x676D},
        {0x723B, 0x676E},
        {0x80B4, 0x676F},
        {0x9175, 0x6770},
        {0x4FAF, 0x6771},
        {0x5019, 0x6772},
        {0x539A, 0x6773},
        {0x540E, 0x6774},
        {0x543C, 0x6775},
        {0x5589, 0x6776},
        {0x55C5, 0x6777},
        {0x5F8C, 0x6778},
        {0x673D, 0x6779},
        {0x7334, 0x677A},
        {0x9005, 0x677B},
        {0x7BCC, 0x677C},
        {0x52F3, 0x677D},
        {0x5864, 0x677E},
        {0x58CE, 0x677F},
        {0x6688, 0x6780},
        {0x7104, 0x6781},
        {0x718F, 0x6782},
        {0x71FB, 0x6783},
        {0x85B0, 0x6784},
        {0x8A13, 0x6785},
        {0x85A8, 0x6786},
        {0x55A7, 0x6787},
        {0x8431, 0x6788},
        {0x5349, 0x6789},
        {0x5599, 0x678A},
        {0x6BC1, 0x678B},
        {0x5F59, 0x678C},
        {0x5FBD, 0x678D},
        {0x63EE, 0x678E},
        {0x6689, 0x678F},
        {0x7147, 0x6790},
        {0x8AF1, 0x6791},
        {0x8F1D, 0x6792},
        {0x9EBE, 0x6793},
        {0x4F11, 0x6794},
        {0x643A, 0x6795},
        {0x70CB, 0x6796},
        {0x7566, 0x6797},
        {0x8667, 0x6798},
        {0x6064, 0x6799},
        {0x8B4E, 0x679A},
        {0x9DF8, 0x679B},
        {0x51F6, 0x679C},
        {0x5308, 0x679D},
        {0x5147, 0x679E},
        {0x6D36, 0x679F},
        {0x80F8, 0x67A0},
        {0x9ED1, 0x67A1},
        {0x5FFB, 0x67A2},
        {0x6615, 0x67A3},
        {0x6B23, 0x67A4},
        {0x75D5, 0x67A5},
        {0x5403, 0x67A6},
        {0x5C79, 0x67A7},
        {0x7D07, 0x67A8},
        {0x8FC4, 0x67A9},
        {0x6B20, 0x67AA},
        {0x6B46, 0x67AB},
        {0x6B3D, 0x67AC},
        {0x5438, 0x67AD},
        {0x6070, 0x67AE},
        {0x6D3D, 0x67AF},
        {0x8208, 0x67B0},
        {0x50D6, 0x67B1},
        {0x559C, 0x67B2},
        {0x566B, 0x67B3},
        {0x59EC, 0x67B4},
        {0x5B09, 0x67B5},
        {0x5E0C, 0x67B6},
        {0x66E6, 0x67B7},
        {0x6199, 0x67B8},
        {0x6231, 0x67B9},
        {0x72A7, 0x67BA},
        {0x7199, 0x67BB},
        {0x51DE, 0x67BC},
        {0x71B9, 0x67BD},
        {0x79A7, 0x67BE},
        {0x7A00, 0x67BF},
        {0x7FB2, 0x67C0},
        {0x8A70, 0x67C1},
        {0x9821, 0x67C2},
        {0x67B7, 0x6841},
        {0x73C2, 0x6842},
        {0x75C2, 0x6843},
        {0x6164, 0x6844},
        {0x4F83, 0x6845},
        {0x67EC, 0x6846},
        {0x687F, 0x6847},
        {0x78F5, 0x6848},
        {0x874E, 0x6849},
        {0x6221, 0x684A},
        {0x77B0, 0x684B},
        {0x90AF, 0x684C},
        {0x9452, 0x684D},
        {0x5808, 0x684E},
        {0x757A, 0x684F},
        {0x7D73, 0x6850},
        {0x7F8C, 0x6851},
        {0x8221, 0x6852},
        {0x9C47, 0x6853},
        {0x584F, 0x6854},
        {0xF900, 0x6855},
        {0x93A7, 0x6856},
        {0x5580, 0x6857},
        {0x5028, 0x6858},
        {0x795B, 0x6859},
        {0x8E1E, 0x685A},
        {0x9245, 0x685B},
        {0x6957, 0x685C},
        {0x8171, 0x685D},
        {0x6840, 0x685E},
        {0x5292, 0x685F},
        {0x9210, 0x6860},
        {0x8FF2, 0x6861},
        {0x8188, 0x6862},
        {0x6289, 0x6863},
        {0x9257, 0x6864},
        {0x4FD3, 0x6865},
        {0x501E, 0x6866},
        {0x5106, 0x6867},
        {0x5770, 0x6868},
        {0x61AC, 0x6869},
        {0x70F1, 0x686A},
        {0x74A5, 0x686B},
        {0x583A, 0x686C},
        {0x68E8, 0x686D},
        {0x5C3B, 0x686E},
        {0x66A0, 0x686F},
        {0x69C1, 0x6870},
        {0x7F94, 0x6871},
        {0x82FD, 0x6872},
        {0x83F0, 0x6873},
        {0x7428, 0x6874},
        {0x9BE4, 0x6875},
        {0x73D9, 0x6876},
        {0x86A3, 0x6877},
        {0x978F, 0x6878},
        {0x4E32, 0x6879},
        {0x8DE8, 0x687A},
        {0x934B, 0x687B},
        {0x742F, 0x687C},
        {0x4F8A, 0x687D},
        {0x709A, 0x687E},
        {0x5775, 0x687F},
        {0x8009, 0x6880},
        {0x92B6, 0x6881},
        {0x97AB, 0x6882},
        {0x88D9, 0x6883},
        {0x828E, 0x6884},
        {0x6372, 0x6885},
        {0x6DC3, 0x6886},
        {0x7357, 0x6887},
        {0x8568, 0x6888},
        {0xF906, 0x6889},
        {0x6677, 0x688A},
        {0x69FB, 0x688B},
        {0x7AC5, 0x688C},
        {0x52FB, 0x688D},
        {0x7547, 0x688E},
        {0x52A4, 0x688F},
        {0x5997, 0x6890},
        {0x6611, 0x6891},
        {0x82A9, 0x6892},
        {0x4F0B, 0x6893},
        {0x57FC, 0x6894},
        {0x7398, 0x6895},
        {0x7482, 0x6896},
        {0x7941, 0x6897},
        {0x7F88, 0x6898},
        {0x9324, 0x6899},
        {0xF90B, 0x689A},
        {0xF90C, 0x689B},
        {0x5A1C, 0x689C},
        {0xF90D, 0x689D},
        {0xF90E, 0x689E},
        {0xF90F, 0x689F},
        {0xF910, 0x68A0},
        {0xF911, 0x68A1},
        {0xF912, 0x68A2},
        {0xF913, 0x68A3},
        {0xF914, 0x68A4},
        {0xF915, 0x68A5},
        {0xF916, 0x68A6},
        {0xF917, 0x68A7},
        {0xF918, 0x68A8},
        {0xF919, 0x68A9},
        {0xF91A, 0x68AA},
        {0xF91B, 0x68AB},
        {0xF91C, 0x68AC},
        {0xF91D, 0x68AD},
        {0xF91E, 0x68AE},
        {0xF91F, 0x68AF},
        {0xF920, 0x68B0},
        {0xF921, 0x68B1},
        {0x678F, 0x68B2},
        {0x6960, 0x68B3},
        {0x6E73, 0x68B4},
        {0xF922, 0x68B5},
        {0xF923, 0x68B6},
        {0xF924, 0x68B7},
        {0xF925, 0x68B8},
        {0xF926, 0x68B9},
        {0xF927, 0x68BA},
        {0x8872, 0x68BB},
        {0xF928, 0x68BC},
        {0xF929, 0x68BD},
        {0xF92A, 0x68BE},
        {0xF92B, 0x68BF},
        {0xF92C, 0x68C0},
        {0xF92D, 0x68C1},
        {0xF92E, 0x68C2},
        {0x649A, 0x68C3},
        {0x5BD7, 0x68C4},
        {0xF92F, 0x68C5},
        {0xF930, 0x68C6},
        {0xF931, 0x68C7},
        {0xF932, 0x68C8},
        {0xF933, 0x68C9},
        {0xF934, 0x68CA},
        {0xF935, 0x68CB},
        {0xF936, 0x68CC},
        {0xF937, 0x68CD},
        {0xF938, 0x68CE},
        {0x99D1, 0x68CF},
        {0xF939, 0x68D0},
        {0xF93A, 0x68D1},
        {0xF93B, 0x68D2},
        {0xF93C, 0x68D3},
        {0xF93D, 0x68D4},
        {0xF93E, 0x68D5},
        {0xF93F, 0x68D6},
        {0xF940, 0x68D7},
        {0xF941, 0x68D8},
        {0xF942, 0x68D9},
        {0xF943, 0x68DA},
        {0xF944, 0x68DB},
        {0xF945, 0x68DC},
        {0xF946, 0x68DD},
        {0xF947, 0x68DE},
        {0xF948, 0x68DF},
        {0xF949, 0x68E0},
        {0xF94A, 0x68E1},
        {0xF94B, 0x68E2},
        {0xF94C, 0x68E3},
        {0xF94D, 0x68E4},
        {0xF94E, 0x68E5},
        {0xF94F, 0x68E6},
        {0xF950, 0x68E7},
        {0xF951, 0x68E8},
        {0x677B, 0x68E9},
        {0xF952, 0x68EA},
        {0xF953, 0x68EB},
        {0xF954, 0x68EC},
        {0xF955, 0x68ED},
        {0xF956, 0x68EE},
        {0xF957, 0x68EF},
        {0xF958, 0x68F0},
        {0xF959, 0x68F1},
        {0x4EB6, 0x68F2},
        {0x5F56, 0x68F3},
        {0x6FBE, 0x68F4},
        {0x574D, 0x68F5},
        {0x61BA, 0x68F6},
        {0x6E5B, 0x68F7},
        {0x8541, 0x68F8},
        {0x931F, 0x68F9},
        {0x7553, 0x68FA},
        {0x6207, 0x68FB},
        {0x87B3, 0x68FC},
        {0x576E, 0x68FD},
        {0x5D8B, 0x68FE},
        {0x6389, 0x6941},
        {0x6AC2, 0x6942},
        {0x89A9, 0x6943},
        {0x65FD, 0x6944},
        {0x711E, 0x6945},
        {0x9017, 0x6946},
        {0x829A, 0x6947},
        {0x5D9D, 0x6948},
        {0xF95B, 0x6949},
        {0xF95D, 0x694A},
        {0xF95E, 0x694B},
        {0x5D0D, 0x694C},
        {0x5FA0, 0x694D},
        {0x5137, 0x694E},
        {0x7489, 0x694F},
        {0xF95F, 0x6950},
        {0x5CBA, 0x6951},
        {0x7B2D, 0x6952},
        {0x8046, 0x6953},
        {0x6FA7, 0x6954},
        {0xF960, 0x6955},
        {0x64C4, 0x6956},
        {0x6F5E, 0x6957},
        {0x797F, 0x6958},
        {0x83C9, 0x6959},
        {0x7028, 0x695A},
        {0x8CDA, 0x695B},
        {0x9B27, 0x695C},
        {0x5A41, 0x695D},
        {0x763B, 0x695E},
        {0x851E, 0x695F},
        {0x93E4, 0x6960},
        {0x65D2, 0x6961},
        {0x700F, 0x6962},
        {0x4F96, 0x6963},
        {0x51DC, 0x6964},
        {0x550E, 0x6965},
        {0x6D6C, 0x6966},
        {0xF962, 0x6967},
        {0x7FB8, 0x6968},
        {0x8389, 0x6969},
        {0x88E1, 0x696A},
        {0x6F7E, 0x696B},
        {0x78BC, 0x696C},
        {0x9088, 0x696D},
        {0x4E07, 0x696E},
        {0x534D, 0x696F},
        {0x551C, 0x6970},
        {0x8309, 0x6971},
        {0x8F1E, 0x6972},
        {0x6C94, 0x6973},
        {0x6927, 0x6974},
        {0x7791, 0x6975},
        {0x84C2, 0x6976},
        {0x6479, 0x6977},
        {0x7441, 0x6978},
        {0x82BC, 0x6979},
        {0x9DA9, 0x697A},
        {0x7AD7, 0x697B},
        {0x61AE, 0x697C},
        {0x6959, 0x697D},
        {0x73F7, 0x697E},
        {0x5011, 0x697F},
        {0x96EF, 0x6980},
        {0x6C95, 0x6981},
        {0x68B6, 0x6982},
        {0x6963, 0x6983},
        {0x6E44, 0x6984},
        {0x9EF4, 0x6985},
        {0x5CB7, 0x6986},
        {0x7DE1, 0x6987},
        {0x7622, 0x6988},
        {0x76FC, 0x6989},
        {0x78D0, 0x698A},
        {0x6E24, 0x698B},
        {0x678B, 0x698C},
        {0x6EC2, 0x698D},
        {0x78C5, 0x698E},
        {0x7119, 0x698F},
        {0x5E61, 0x6990},
        {0x71D4, 0x6991},
        {0x6A97, 0x6992},
        {0x8617, 0x6993},
        {0x68C5, 0x6994},
        {0x9A08, 0x6995},
        {0x73E4, 0x6996},
        {0x83E9, 0x6997},
        {0x8F39, 0x6998},
        {0x71A2, 0x6999},
        {0x4E0D, 0x699A},
        {0x4FEF, 0x699B},
        {0x5490, 0x699C},
        {0x5B5A, 0x699D},
        {0x8240, 0x699E},
        {0x83A9, 0x699F},
        {0x5429, 0x69A0},
        {0x6610, 0x69A1},
        {0x8CC1, 0x69A2},
        {0x5F7F, 0x69A3},
        {0x6787, 0x69A4},
        {0x6BD6, 0x69A5},
        {0x6BD7, 0x69A6},
        {0x79D5, 0x69A7},
        {0x7C83, 0x69A8},
        {0x56AC, 0x69A9},
        {0x6D5C, 0x69AA},
        {0x73AD, 0x69AB},
        {0x4FDF, 0x69AC},
        {0x67F6, 0x69AD},
        {0x9E9D, 0x69AE},
        {0x9730, 0x69AF},
        {0x715E, 0x69B0},
        {0x9212, 0x69B1},
        {0x5CE0, 0x69B2},
        {0x55C7, 0x69B3},
        {0x637F, 0x69B4},
        {0x7B6E, 0x69B5},
        {0x5B0B, 0x69B6},
        {0x657E, 0x69B7},
        {0x6E32, 0x69B8},
        {0x7401, 0x69B9},
        {0x9425, 0x69BA},
        {0x994D, 0x69BB},
        {0x6CC4, 0x69BC},
        {0x893B, 0x69BD},
        {0x9F67, 0x69BE},
        {0x5261, 0x69BF},
        {0x965D, 0x69C0},
        {0x5BAC, 0x69C1},
        {0x73F9, 0x69C2},
        {0x7619, 0x69C3},
        {0x7BE0, 0x69C4},
        {0x6D91, 0x69C5},
        {0x8B16, 0x69C6},
        {0x8D16, 0x69C7},
        {0x5DFD, 0x69C8},
        {0x84C0, 0x69C9},
        {0x98E1, 0x69CA},
        {0x609A, 0x69CB},
        {0x6DDE, 0x69CC},
        {0x5CC0, 0x69CD},
        {0x7407, 0x69CE},
        {0x74B2, 0x69CF},
        {0x8B90, 0x69D0},
        {0x96A7, 0x69D1},
        {0x6F5A, 0x69D2},
        {0x7421, 0x69D3},
        {0x74B9, 0x69D4},
        {0x5F87, 0x69D5},
        {0x6812, 0x69D6},
        {0x6A53, 0x69D7},
        {0x84F4, 0x69D8},
        {0x8563, 0x69D9},
        {0x8AC4, 0x69DA},
        {0x9265, 0x69DB},
        {0x5C4E, 0x69DC},
        {0x8C55, 0x69DD},
        {0x7BD2, 0x69DE},
        {0x8755, 0x69DF},
        {0x4F81, 0x69E0},
        {0x85CE, 0x69E1},
        {0x8AF6, 0x69E2},
        {0x555E, 0x69E3},
        {0x83AA, 0x69E4},
        {0x5E44, 0x69E5},
        {0x9102, 0x69E6},
        {0x9354, 0x69E7},
        {0x9C10, 0x69E8},
        {0x9B9F, 0x69E9},
        {0x5535, 0x69EA},
        {0x5CA9, 0x69EB},
        {0x627C, 0x69EC},
        {0x7E0A, 0x69ED},
        {0xF975, 0x69EE},
        {0xF976, 0x69EF},
        {0x84BB, 0x69F0},
        {0xF977, 0x69F1},
        {0xF978, 0x69F2},
        {0xF979, 0x69F3},
        {0xF97A, 0x69F4},
        {0x79B3, 0x69F5},
        {0xF97B, 0x69F6},
        {0xF97C, 0x69F7},
        {0xF97D, 0x69F8},
        {0xF97E, 0x69F9},
        {0x7600, 0x69FA},
        {0x8616, 0x69FB},
        {0x4FFA, 0x69FC},
        {0x5186, 0x69FD},
        {0xF97F, 0x69FE},
        {0xF980, 0x6A41},
        {0xF981, 0x6A42},
        {0xF982, 0x6A43},
        {0xF983, 0x6A44},
        {0xF984, 0x6A45},
        {0x74B5, 0x6A46},
        {0x7916, 0x6A47},
        {0xF985, 0x6A48},
        {0x8245, 0x6A49},
        {0x8339, 0x6A4A},
        {0x8F3F, 0x6A4B},
        {0x8F5D, 0x6A4C},
        {0xF986, 0x6A4D},
        {0xF987, 0x6A4E},
        {0xF988, 0x6A4F},
        {0xF989, 0x6A50},
        {0xF98A, 0x6A51},
        {0xF98B, 0x6A52},
        {0xF98C, 0x6A53},
        {0xF98D, 0x6A54},
        {0xF98E, 0x6A55},
        {0xF98F, 0x6A56},
        {0xF990, 0x6A57},
        {0x633B, 0x6A58},
        {0x6C87, 0x6A59},
        {0xF992, 0x6A5A},
        {0xF993, 0x6A5B},
        {0xF994, 0x6A5C},
        {0xF995, 0x6A5D},
        {0xF996, 0x6A5E},
        {0x7E2F, 0x6A5F},
        {0xF997, 0x6A60},
        {0xF998, 0x6A61},
        {0xF999, 0x6A62},
        {0xF99A, 0x6A63},
        {0xF99B, 0x6A64},
        {0xF99C, 0x6A65},
        {0xF99D, 0x6A66},
        {0xF99F, 0x6A67},
        {0xF9A0, 0x6A68},
        {0xF9A2, 0x6A69},
        {0xF9A3, 0x6A6A},
        {0xF9A4, 0x6A6B},
        {0xF9A5, 0x6A6C},
        {0x7430, 0x6A6D},
        {0xF9A6, 0x6A6E},
        {0xF9A7, 0x6A6F},
        {0xF9A8, 0x6A70},
        {0xF9A9, 0x6A71},
        {0xF9AA, 0x6A72},
        {0xF9AB, 0x6A73},
        {0x5DB8, 0x6A74},
        {0xF9AC, 0x6A75},
        {0x6E36, 0x6A76},
        {0x6FDA, 0x6A77},
        {0x702F, 0x6A78},
        {0x7150, 0x6A79},
        {0x7370, 0x6A7A},
        {0xF9AD, 0x6A7B},
        {0x7A4E, 0x6A7C},
        {0xF9AF, 0x6A7D},
        {0xF9B0, 0x6A7E},
        {0xF9B1, 0x6A7F},
        {0x9348, 0x6A80},
        {0xF9B2, 0x6A81},
        {0x9719, 0x6A82},
        {0xF9B3, 0x6A83},
        {0xF9B4, 0x6A84},
        {0x4E42, 0x6A85},
        {0xF9B5, 0x6A86},
        {0x6C6D, 0x6A87},
        {0x7A62, 0x6A88},
        {0xF9B6, 0x6A89},
        {0xF9B7, 0x6A8A},
        {0xF9B8, 0x6A8B},
        {0x4FC9, 0x6A8C},
        {0x5862, 0x6A8D},
        {0x61CA, 0x6A8E},
        {0x6556, 0x6A8F},
        {0x6FB3, 0x6A90},
        {0x71AC, 0x6A91},
        {0x7B7D, 0x6A92},
        {0x9C32, 0x6A93},
        {0x9F07, 0x6A94},
        {0x7E15, 0x6A95},
        {0x9954, 0x6A96},
        {0x7AAA, 0x6A97},
        {0x68A1, 0x6A98},
        {0x6900, 0x6A99},
        {0x7413, 0x6A9A},
        {0x8118, 0x6A9B},
        {0x5A03, 0x6A9C},
        {0x5D6C, 0x6A9D},
        {0xF9BA, 0x6A9E},
        {0xF9BB, 0x6A9F},
        {0x5BE5, 0x6AA0},
        {0xF9BC, 0x6AA1},
        {0xF9BD, 0x6AA2},
        {0x6493, 0x6AA3},
        {0xF9BE, 0x6AA4},
        {0xF9C0, 0x6AA5},
        {0x71FF, 0x6AA6},
        {0xF9C1, 0x6AA7},
        {0xF9C2, 0x6AA8},
        {0xF9C3, 0x6AA9},
        {0x7E1F, 0x6AAA},
        {0x4FD1, 0x6AAB},
        {0x57C7, 0x6AAC},
        {0x5889, 0x6AAD},
        {0x6142, 0x6AAE},
        {0x6D8C, 0x6AAF},
        {0x752C, 0x6AB0},
        {0xF9C4, 0x6AB1},
        {0x65F4, 0x6AB2},
        {0x7397, 0x6AB3},
        {0x7440, 0x6AB4},
        {0x7D06, 0x6AB5},
        {0x85D5, 0x6AB6},
        {0x91EA, 0x6AB7},
        {0x52D6, 0x6AB8},
        {0x5F67, 0x6AB9},
        {0x682F, 0x6ABA},
        {0x6A52, 0x6ABB},
        {0x6F90, 0x6ABC},
        {0x7189, 0x6ABD},
        {0x8553, 0x6ABE},
        {0x4E90, 0x6ABF},
        {0x5AC4, 0x6AC0},
        {0x6C85, 0x6AC1},
        {0x6D39, 0x6AC2},
        {0x6E72, 0x6AC3},
        {0xF9C6, 0x6AC4},
        {0x6690, 0x6AC5},
        {0x853F, 0x6AC6},
        {0x8918, 0x6AC7},
        {0xF9C7, 0x6AC8},
        {0xF9C8, 0x6AC9},
        {0xF9C9, 0x6ACA},
        {0x6962, 0x6ACB},
        {0x6D27, 0x6ACC},
        {0xF9CA, 0x6ACD},
        {0xF9CB, 0x6ACE},
        {0x7337, 0x6ACF},
        {0xF9CC, 0x6AD0},
        {0xF9CD, 0x6AD1},
        {0xF9CE, 0x6AD2},
        {0xF9CF, 0x6AD3},
        {0xF9D0, 0x6AD4},
        {0xF9D1, 0x6AD5},
        {0x5809, 0x6AD6},
        {0xF9D2, 0x6AD7},
        {0xF9D3, 0x6AD8},
        {0xF9D4, 0x6AD9},
        {0xF9D5, 0x6ADA},
        {0xF9D6, 0x6ADB},
        {0x8D07, 0x6ADC},
        {0xF9D7, 0x6ADD},
        {0x9217, 0x6ADE},
        {0xF9D8, 0x6ADF},
        {0xF9D9, 0x6AE0},
        {0xF9DA, 0x6AE1},
        {0xF9DB, 0x6AE2},
        {0x701C, 0x6AE3},
        {0xF9DC, 0x6AE4},
        {0x6905, 0x6AE5},
        {0x858F, 0x6AE6},
        {0xF9DD, 0x6AE7},
        {0xF9DE, 0x6AE8},
        {0xF9DF, 0x6AE9},
        {0xF9E1, 0x6AEA},
        {0xF9E2, 0x6AEB},
        {0xF9E3, 0x6AEC},
        {0xF9E4, 0x6AED},
        {0xF9E5, 0x6AEE},
        {0xF9E6, 0x6AEF},
        {0x8084, 0x6AF0},
        {0x82E1, 0x6AF1},
        {0xF9E7, 0x6AF2},
        {0xF9E8, 0x6AF3},
        {0x8CBD, 0x6AF4},
        {0x9087, 0x6AF5},
        {0xF9E9, 0x6AF6},
        {0xF9EA, 0x6AF7},
        {0xF9EB, 0x6AF8},
        {0xF9EC, 0x6AF9},
        {0x8B1A, 0x6AFA},
        {0xF9ED, 0x6AFB},
        {0xF9EE, 0x6AFC},
        {0xF9EF, 0x6AFD},
        {0x7D6A, 0x6AFE},
        {0x8335, 0x6B41},
        {0xF9F0, 0x6B42},
        {0x8693, 0x6B43},
        {0xF9F1, 0x6B44},
        {0xF9F2, 0x6B45},
        {0xF9F3, 0x6B46},
        {0x4F5A, 0x6B47},
        {0x6041, 0x6B48},
        {0xF9F4, 0x6B49},
        {0xF9F5, 0x6B4A},
        {0xF9F6, 0x6B4B},
        {0x5344, 0x6B4C},
        {0xF9F7, 0x6B4D},
        {0xF9F8, 0x6B4E},
        {0xF9F9, 0x6B4F},
        {0x82BF, 0x6B50},
        {0x8328, 0x6B51},
        {0x5B71, 0x6B52},
        {0x81E7, 0x6B53},
        {0x6E3D, 0x6B54},
        {0x7E21, 0x6B55},
        {0x7D35, 0x6B56},
        {0x83F9, 0x6B57},
        {0x96CE, 0x6B58},
        {0x9F5F, 0x6B59},
        {0x540A, 0x6B5A},
        {0xF9FB, 0x6B5B},
        {0x7FDF, 0x6B5C},
        {0x93D1, 0x6B5D},
        {0x4F43, 0x6B5E},
        {0x4F7A, 0x6B5F},
        {0x587C, 0x6B60},
        {0x7420, 0x6B61},
        {0x7551, 0x6B62},
        {0x7B4C, 0x6B63},
        {0x942B, 0x6B64},
        {0x7664, 0x6B65},
        {0x9B8E, 0x6B66},
        {0x67FE, 0x6B67},
        {0x6A89, 0x6B68},
        {0x6DC0, 0x6B69},
        {0x6E5E, 0x6B6A},
        {0x701E, 0x6B6B},
        {0x70A1, 0x6B6C},
        {0x738E, 0x6B6D},
        {0x73FD, 0x6B6E},
        {0x7D8E, 0x6B6F},
        {0x92CC, 0x6B70},
        {0x74AA, 0x6B71},
        {0x96D5, 0x6B72},
        {0x60B0, 0x6B73},
        {0x8E2A, 0x6B74},
        {0x59DD, 0x6B75},
        {0x6E4A, 0x6B76},
        {0x6F8D, 0x6B77},
        {0x5BEF, 0x6B78},
        {0x710C, 0x6B79},
        {0x96CB, 0x6B7A},
        {0x7E52, 0x6B7B},
        {0x6C9A, 0x6B7C},
        {0x82B7, 0x6B7D},
        {0x5507, 0x6B7E},
        {0x6422, 0x6B7F},
        {0x664B, 0x6B80},
        {0x686D, 0x6B81},
        {0x6B84, 0x6B82},
        {0x755B, 0x6B83},
        {0x7E1D, 0x6B84},
        {0x81FB, 0x6B85},
        {0x852F, 0x6B86},
        {0x8897, 0x6B87},
        {0x4F84, 0x6B88},
        {0x74C6, 0x6B89},
        {0xF9FD, 0x6B8A},
        {0x6F57, 0x6B8B},
        {0x93F6, 0x6B8C},
        {0x4F98, 0x6B8D},
        {0x7C12, 0x6B8E},
        {0x7D2E, 0x6B8F},
        {0x8B96, 0x6B90},
        {0x6134, 0x6B91},
        {0x7316, 0x6B92},
        {0x5BC0, 0x6B93},
        {0x5BE8, 0x6B94},
        {0x501C, 0x6B95},
        {0x8E60, 0x6B96},
        {0x7394, 0x6B97},
        {0x8F1F, 0x6B98},
        {0x7C3D, 0x6B99},
        {0x8A79, 0x6B9A},
        {0x581E, 0x6B9B},
        {0x527F, 0x6B9C},
        {0x8278, 0x6B9D},
        {0x82D5, 0x6B9E},
        {0x90A8, 0x6B9F},
        {0x60A4, 0x6BA0},
        {0x6181, 0x6BA1},
        {0x8525, 0x6BA2},
        {0x8ACF, 0x6BA3},
        {0x939A, 0x6BA4},
        {0x9A36, 0x6BA5},
        {0x8E59, 0x6BA6},
        {0x7443, 0x6BA7},
        {0x672E, 0x6BA8},
        {0x8D05, 0x6BA9},
        {0x53A0, 0x6BAA},
        {0x7A49, 0x6BAB},
        {0x86A9, 0x6BAC},
        {0x741B, 0x6BAD},
        {0x54A4, 0x6BAE},
        {0x62D6, 0x6BAF},
        {0x99B1, 0x6BB0},
        {0x577C, 0x6BB1},
        {0x666B, 0x6BB2},
        {0x7438, 0x6BB3},
        {0x7708, 0x6BB4},
        {0xFA03, 0x6BB5},
        {0x69CC, 0x6BB6},
        {0x95D6, 0x6BB7},
        {0x64FA, 0x6BB8},
        {0x9211, 0x6BB9},
        {0x9A19, 0x6BBA},
        {0x67B0, 0x6BBB},
        {0xFA06, 0x6BBC},
        {0x82DE, 0x6BBD},
        {0x900B, 0x6BBE},
        {0x66DD, 0x6BBF},
        {0xFA07, 0x6BC0},
        {0x98C7, 0x6BC1},
        {0x9A43, 0x6BC2},
        {0x9642, 0x6BC3},
        {0x73CC, 0x6BC4},
        {0x82FE, 0x6BC5},
        {0x999D, 0x6BC6},
        {0x53A6, 0x6BC7},
        {0x701A, 0x6BC8},
        {0x929C, 0x6BC9},
        {0x9E79, 0x6BCA},
        {0x95D4, 0x6BCB},
        {0x5AE6, 0x6BCC},
        {0xFA08, 0x6BCD},
        {0x7023, 0x6BCE},
        {0x8347, 0x6BCF},
        {0x6AF6, 0x6BD0},
        {0x4FD4, 0x6BD1},
        {0x774D, 0x6BD2},
        {0x6CEB, 0x6BD3},
        {0x73B9, 0x6BD4},
        {0x665B, 0x6BD5},
        {0x6CC2, 0x6BD6},
        {0x6ECE, 0x6BD7},
        {0x7050, 0x6BD8},
        {0x7192, 0x6BD9},
        {0x7469, 0x6BDA},
        {0x9008, 0x6BDB},
        {0x66B3, 0x6BDC},
        {0x8E4A, 0x6BDD},
        {0x5CB5, 0x6BDE},
        {0x6667, 0x6BDF},
        {0x7425, 0x6BE0},
        {0x82A6, 0x6BE1},
        {0x84BF, 0x6BE2},
        {0x70D8, 0x6BE3},
        {0x8B41, 0x6BE4},
        {0x5950, 0x6BE5},
        {0x6665, 0x6BE6},
        {0x5E4C, 0x6BE7},
        {0x6130, 0x6BE8},
        {0x6644, 0x6BE9},
        {0x69A5, 0x6BEA},
        {0x6E5F, 0x6BEB},
        {0x6F62, 0x6BEC},
        {0x749C, 0x6BED},
        {0x7C27, 0x6BEE},
        {0x532F, 0x6BEF},
        {0x8334, 0x6BF0},
        {0x5B96, 0x6BF1},
        {0x9404, 0x6BF2},
        {0x6585, 0x6BF3},
        {0x6D8D, 0x6BF4},
        {0x6DC6, 0x6BF5},
        {0x9A4D, 0x6BF6},
        {0x5E3F, 0x6BF7},
        {0x7166, 0x6BF8},
        {0x73DD, 0x6BF9},
        {0x52DB, 0x6BFA},
        {0x6684, 0x6BFB},
        {0x714A, 0x6BFC},
        {0x7098, 0x6BFD},
        {0x8A16, 0x6BFE},
        {0x7FD5, 0x6C41},
        {0x56CD, 0x6C42},
        {0x6198, 0x6C43},
        {0x665E, 0x6C44},
        {0x71BA, 0x6C45},
        {0x3164, 0x8441},
        {0x3133, 0x8444},
        {0x3135, 0x8446},
        {0x3136, 0x8447},
        {0x313A, 0x844A},
        {0x313B, 0x844B},
        {0x313C, 0x844C},
        {0x313D, 0x844D},
        {0x313E, 0x844E},
        {0x313F, 0x844F},
        {0x3140, 0x8450},
        {0x3144, 0x8454},
        {0x314F, 0x8461},
        {0x3150, 0x8481},
        {0x3151, 0x84A1},
        {0x3152, 0x84C1},
        {0x3153, 0x84E1},
        {0x3154, 0x8541},
        {0x3155, 0x8561},
        {0x3156, 0x8581},
        {0x3157, 0x85A1},
        {0x3158, 0x85C1},
        {0x3159, 0x85E1},
        {0x315A, 0x8641},
        {0x315B, 0x8661},
        {0x315C, 0x8681},
        {0x315D, 0x86A1},
        {0x315E, 0x86C1},
        {0x315F, 0x86E1},
        {0x3160, 0x8741},
        {0x3161, 0x8761},
        {0x3162, 0x8781},
        {0x3163, 0x87A1},
        {0x3131, 0x8841},
        {0x3400, 0x8861},
        {0x3401, 0x8862},
        {0x3D2E, 0x8863},
        {0x3402, 0x8865},
        {0x3403, 0x8868},
        {0x3404, 0x8869},
        {0x3405, 0x886A},
        {0x3406, 0x886B},
        {0x3D2F, 0x886C},
        {0x3407, 0x8871},
        {0x3408, 0x8873},
        {0x3409, 0x8874},
        {0x340A, 0x8875},
        {0x340B, 0x8876},
        {0x340C, 0x8877},
        {0x340D, 0x8878},
        {0x340E, 0x8879},
        {0x340F, 0x887B},
        {0x3410, 0x887C},
        {0x3411, 0x887D},
        {0x3412, 0x8881},
        {0x3413, 0x8882},
        {0x3414, 0x8885},
        {0x3415, 0x8889},
        {0x3416, 0x8891},
        {0x3417, 0x8893},
        {0x3418, 0x8895},
        {0x3419, 0x8896},
        {0x341A, 0x8897},
        {0x341B, 0x88A1},
        {0x341C, 0x88A2},
        {0x341D, 0x88A5},
        {0x341E, 0x88A9},
        {0x341F, 0x88B5},
        {0x3420, 0x88B7},
        {0x3421, 0x88C1},
        {0x3422, 0x88C5},
        {0x3423, 0x88C9},
        {0x3424, 0x88E1},
        {0x3425, 0x88E2},
        {0x3426, 0x88E5},
        {0x3427, 0x88E8},
        {0x3428, 0x88E9},
        {0x3D40, 0x88EA},
        {0x3429, 0x88EB},
        {0x342A, 0x88F1},
        {0x342B, 0x88F3},
        {0x342C, 0x88F5},
        {0x342D, 0x88F6},
        {0x342E, 0x88F7},
        {0x342F, 0x88F8},
        {0x3D41, 0x88F9},
        {0x3430, 0x88FB},
        {0x3431, 0x88FC},
        {0x3432, 0x88FD},
        {0x3433, 0x8941},
        {0x3434, 0x8945},
        {0x3D43, 0x8948},
        {0x3435, 0x8949},
        {0x3436, 0x8951},
        {0x3437, 0x8953},
        {0x3438, 0x8955},
        {0x3439, 0x8956},
        {0x343A, 0x8957},
        {0x343B, 0x8961},
        {0x343C, 0x8962},
        {0x343D, 0x8963},
        {0x343E, 0x8965},
        {0x343F, 0x8968},
        {0x3440, 0x8969},
        {0x3441, 0x8971},
        {0x3442, 0x8973},
        {0x3443, 0x8975},
        {0x3444, 0x8976},
        {0x3445, 0x8977},
        {0x3446, 0x897B},
        {0x3447, 0x8981},
        {0x3448, 0x8985},
        {0x3449, 0x8989},
        {0x344A, 0x8993},
        {0x344B, 0x8995},
        {0x344C, 0x89A1},
        {0x344D, 0x89A2},
        {0x344E, 0x89A5},
        {0x344F, 0x89A8},
        {0x3450, 0x89A9},
        {0x3D51, 0x89AA},
        {0x3451, 0x89AB},
        {0x3452, 0x89AD},
        {0x3453, 0x89B0},
        {0x3454, 0x89B1},
        {0x3455, 0x89B3},
        {0x3456, 0x89B5},
        {0x3457, 0x89B7},
        {0x3458, 0x89B8},
        {0x3D56, 0x89BC},
        {0x3459, 0x89C1},
        {0x345A, 0x89C2},
        {0x345B, 0x89C5},
        {0x345C, 0x89C9},
        {0x345D, 0x89CB},
        {0x345E, 0x89D1},
        {0x345F, 0x89D3},
        {0x3460, 0x89D5},
        {0x3461, 0x89D7},
        {0x3462, 0x89E1},
        {0x3D5A, 0x89E2},
        {0x3463, 0x89E5},
        {0x3464, 0x89E9},
        {0x3D5D, 0x89F1},
        {0x3465, 0x89F3},
        {0x3D5E, 0x89F5},
        {0x3466, 0x89F6},
        {0x3467, 0x89F7},
        {0x3468, 0x8A41},
        {0x3469, 0x8A42},
        {0x346A, 0x8A45},
        {0x346B, 0x8A49},
        {0x346C, 0x8A51},
        {0x346D, 0x8A53},
        {0x346E, 0x8A55},
        {0x346F, 0x8A57},
        {0x3470, 0x8A61},
        {0x3471, 0x8A65},
        {0x3472, 0x8A69},
        {0x3473, 0x8A73},
        {0x3474, 0x8A75},
        {0x3475, 0x8A81},
        {0x3476, 0x8A82},
        {0x3477, 0x8A85},
        {0x3478, 0x8A88},
        {0x3479, 0x8A89},
        {0x347A, 0x8A8A},
        {0x347B, 0x8A8B},
        {0x347C, 0x8A90},
        {0x347D, 0x8A91},
        {0x347E, 0x8A93},
        {0x347F, 0x8A95},
        {0x3480, 0x8A97},
        {0x3481, 0x8A98},
        {0x3482, 0x8AA1},
        {0x3483, 0x8AA2},
        {0x3484, 0x8AA5},
        {0x3485, 0x8AA9},
        {0x3D6B, 0x8AB5},
        {0x3486, 0x8AB6},
        {0x3487, 0x8AB7},
        {0x3488, 0x8AC1},
        {0x3489, 0x8AD5},
        {0x348A, 0x8AE1},
        {0x348B, 0x8AE2},
        {0x348C, 0x8AE5},
        {0x348D, 0x8AE9},
        {0x348E, 0x8AF1},
        {0x348F, 0x8AF3},
        {0x3490, 0x8AF5},
        {0x3D77, 0x8AF7},
        {0x3491, 0x8B41},
        {0x3492, 0x8B45},
        {0x3493, 0x8B49},
        {0x3D7A, 0x8B51},
        {0x3494, 0x8B61},
        {0x3495, 0x8B62},
        {0x3496, 0x8B65},
        {0x3497, 0x8B68},
        {0x3498, 0x8B69},
        {0x3499, 0x8B6A},
        {0x3D7F, 0x8B6B},
        {0x349A, 0x8B71},
        {0x349B, 0x8B73},
        {0x349C, 0x8B75},
        {0x349D, 0x8B77},
        {0x3D84, 0x8B79},
        {0x3D85, 0x8B7B},
        {0x349E, 0x8B81},
        {0x3D8E, 0x8B95},
        {0x349F, 0x8BA1},
        {0x34A0, 0x8BA2},
        {0x34A1, 0x8BA5},
        {0x34A2, 0x8BA8},
        {0x34A3, 0x8BA9},
        {0x34A4, 0x8BAB},
        {0x3D91, 0x8BAD},
        {0x34A5, 0x8BB1},
        {0x34A6, 0x8BB3},
        {0x34A7, 0x8BB5},
        {0x3D92, 0x8BB6},
        {0x34A8, 0x8BB7},
        {0x34A9, 0x8BB8},
        {0x3D94, 0x8BBB},
        {0x34AA, 0x8BBC},
        {0x3132, 0x8C41},
        {0x34AB, 0x8C61},
        {0x34AC, 0x8C62},
        {0x34AD, 0x8C63},
        {0x34AE, 0x8C65},
        {0x34AF, 0x8C69},
        {0x34B0, 0x8C6B},
        {0x34B1, 0x8C71},
        {0x34B2, 0x8C73},
        {0x34B3, 0x8C75},
        {0x34B4, 0x8C76},
        {0x34B5, 0x8C77},
        {0x3D97, 0x8C78},
        {0x34B6, 0x8C7B},
        {0x34B7, 0x8C81},
        {0x34B8, 0x8C82},
        {0x34B9, 0x8C85},
        {0x34BA, 0x8C89},
        {0x34BB, 0x8C91},
        {0x34BC, 0x8C93},
        {0x34BD, 0x8C95},
        {0x34BE, 0x8C96},
        {0x34BF, 0x8C97},
        {0x34C0, 0x8CA1},
        {0x34C1, 0x8CA2},
        {0x34C2, 0x8CA9},
        {0x3DA3, 0x8CC1},
        {0x34C3, 0x8CE1},
        {0x34C4, 0x8CE2},
        {0x34C5, 0x8CE3},
        {0x34C6, 0x8CE5},
        {0x34C7, 0x8CE9},
        {0x34C8, 0x8CF1},
        {0x34C9, 0x8CF3},
        {0x34CA, 0x8CF5},
        {0x34CB, 0x8CF6},
        {0x34CC, 0x8CF7},
        {0x34CD, 0x8D41},
        {0x34CE, 0x8D42},
        {0x34CF, 0x8D45},
        {0x34D0, 0x8D51},
        {0x34D1, 0x8D55},
        {0x34D2, 0x8D57},
        {0x34D3, 0x8D61},
        {0x34D4, 0x8D65},
        {0x34D5, 0x8D69},
        {0x3DB2, 0x8D71},
        {0x34D6, 0x8D75},
        {0x34D7, 0x8D76},
        {0x34D8, 0x8D7B},
        {0x34D9, 0x8D81},
        {0x34DA, 0x8DA1},
        {0x34DB, 0x8DA2},
        {0x34DC, 0x8DA5},
        {0x34DD, 0x8DA7},
        {0x3DB7, 0x8DA8},
        {0x34DE, 0x8DA9},
        {0x34DF, 0x8DB1},
        {0x34E0, 0x8DB3},
        {0x34E1, 0x8DB5},
        {0x34E2, 0x8DB7},
        {0x34E3, 0x8DB8},
        {0x34E4, 0x8DB9},
        {0x34E5, 0x8DC1},
        {0x34E6, 0x8DC2},
        {0x3DBD, 0x8DC5},
        {0x34E7, 0x8DC9},
        {0x3DBF, 0x8DD1},
        {0x3DC1, 0x8DD5},
        {0x34E8, 0x8DD6},
        {0x34E9, 0x8DD7},
        {0x34EA, 0x8DE1},
        {0x34EB, 0x8DE2},
        {0x3DC2, 0x8DE5},
        {0x34EC, 0x8DF7},
        {0x34ED, 0x8E41},
        {0x34EE, 0x8E45},
        {0x34EF, 0x8E49},
        {0x34F0, 0x8E51},
        {0x34F1, 0x8E53},
        {0x3DCA, 0x8E55},
        {0x34F2, 0x8E57},
        {0x34F3, 0x8E61},
        {0x3DD1, 0x8E78},
        {0x34F4, 0x8E81},
        {0x34F5, 0x8E82},
        {0x34F6, 0x8E85},
        {0x3DD2, 0x8E88},
        {0x34F7, 0x8E89},
        {0x34F8, 0x8E90},
        {0x34F9, 0x8E91},
        {0x34FA, 0x8E93},
        {0x34FB, 0x8E95},
        {0x34FC, 0x8E97},
        {0x34FD, 0x8E98},
        {0x34FE, 0x8EA1},
        {0x3DD6, 0x8EA5},
        {0x34FF, 0x8EA9},
        {0x3DD9, 0x8EB5},
        {0x3500, 0x8EB6},
        {0x3501, 0x8EB7},
        {0x3502, 0x8EC1},
        {0x3503, 0x8EC2},
        {0x3504, 0x8EC5},
        {0x3505, 0x8EC9},
        {0x3506, 0x8ED1},
        {0x3507, 0x8ED3},
        {0x3508, 0x8ED6},
        {0x3509, 0x8EE1},
        {0x3DDD, 0x8EE2},
        {0x350A, 0x8EE5},
        {0x350B, 0x8EE9},
        {0x350C, 0x8EF1},
        {0x350D, 0x8EF3},
        {0x3DE0, 0x8EF7},
        {0x350E, 0x8F41},
        {0x350F, 0x8F61},
        {0x3510, 0x8F62},
        {0x3511, 0x8F65},
        {0x3512, 0x8F67},
        {0x3513, 0x8F69},
        {0x3514, 0x8F6B},
        {0x3515, 0x8F70},
        {0x3516, 0x8F71},
        {0x3517, 0x8F73},
        {0x3518, 0x8F75},
        {0x3519, 0x8F77},
        {0x351A, 0x8F7B},
        {0x3DE9, 0x8F81},
        {0x351B, 0x8FA1},
        {0x351C, 0x8FA2},
        {0x351D, 0x8FA5},
        {0x351E, 0x8FA9},
        {0x351F, 0x8FB1},
        {0x3520, 0x8FB3},
        {0x3521, 0x8FB5},
        {0x3DF2, 0x8FB6},
        {0x3522, 0x8FB7},
        {0x3134, 0x9041},
        {0x3523, 0x9061},
        {0x3524, 0x9062},
        {0x3525, 0x9063},
        {0x3526, 0x9065},
        {0x3527, 0x9068},
        {0x3528, 0x9069},
        {0x3529, 0x906A},
        {0x352A, 0x906B},
        {0x352B, 0x9071},
        {0x352C, 0x9073},
        {0x352D, 0x9075},
        {0x352E, 0x9076},
        {0x352F, 0x9077},
        {0x3530, 0x9078},
        {0x3531, 0x9079},
        {0x3532, 0x907B},
        {0x3533, 0x907D},
        {0x3534, 0x9081},
        {0x3535, 0x9082},
        {0x3536, 0x9085},
        {0x3DF9, 0x9088},
        {0x3537, 0x9089},
        {0x3538, 0x9091},
        {0x3539, 0x9093},
        {0x353A, 0x9095},
        {0x353B, 0x9096},
        {0x353C, 0x9097},
        {0x353D, 0x90A1},
        {0x353E, 0x90A2},
        {0x353F, 0x90A5},
        {0x3540, 0x90A9},
        {0x3541, 0x90B1},
        {0x3542, 0x90B7},
        {0x3E00, 0x90C1},
        {0x3543, 0x90E1},
        {0x3544, 0x90E2},
        {0x3545, 0x90E4},
        {0x3546, 0x90E5},
        {0x3E03, 0x90E8},
        {0x3547, 0x90E9},
        {0x3548, 0x90EB},
        {0x3549, 0x90EC},
        {0x354A, 0x90F1},
        {0x354B, 0x90F3},
        {0x354C, 0x90F5},
        {0x354D, 0x90F6},
        {0x354E, 0x90F7},
        {0x3E05, 0x90F8},
        {0x354F, 0x90FD},
        {0x3550, 0x9141},
        {0x3551, 0x9142},
        {0x3552, 0x9145},
        {0x3553, 0x9149},
        {0x3554, 0x9151},
        {0x3555, 0x9153},
        {0x3556, 0x9155},
        {0x3557, 0x9156},
        {0x3558, 0x9157},
        {0x3559, 0x9161},
        {0x355A, 0x9162},
        {0x355B, 0x9165},
        {0x3E0F, 0x9168},
        {0x355C, 0x9169},
        {0x355D, 0x9171},
        {0x355E, 0x9173},
        {0x3E11, 0x9175},
        {0x355F, 0x9176},
        {0x3560, 0x9177},
        {0x3561, 0x917A},
        {0x3E12, 0x917B},
        {0x3562, 0x9181},
        {0x3563, 0x9185},
        {0x3E1A, 0x9195},
        {0x3564, 0x91A1},
        {0x3565, 0x91A2},
        {0x3E1C, 0x91A3},
        {0x3566, 0x91A5},
        {0x3567, 0x91A9},
        {0x3568, 0x91AB},
        {0x3569, 0x91B1},
        {0x356A, 0x91B3},
        {0x356B, 0x91B5},
        {0x356C, 0x91B7},
        {0x356D, 0x91BC},
        {0x356E, 0x91BD},
        {0x356F, 0x91C1},
        {0x3570, 0x91C5},
        {0x3571, 0x91C9},
        {0x3E27, 0x91D5},
        {0x3572, 0x91D6},
        {0x3E29, 0x91E1},
        {0x3573, 0x9241},
        {0x3574, 0x9245},
        {0x3575, 0x9249},
        {0x3576, 0x9251},
        {0x3577, 0x9253},
        {0x3578, 0x9255},
        {0x3579, 0x9261},
        {0x357A, 0x9262},
        {0x357B, 0x9265},
        {0x357C, 0x9269},
        {0x357D, 0x9273},
        {0x357E, 0x9275},
        {0x357F, 0x9277},
        {0x3580, 0x9281},
        {0x3581, 0x9282},
        {0x3582, 0x9285},
        {0x3583, 0x9288},
        {0x3584, 0x9289},
        {0x3585, 0x9291},
        {0x3586, 0x9293},
        {0x3587, 0x9295},
        {0x3588, 0x9297},
        {0x3589, 0x92A1},
        {0x3E3F, 0x92B5},
        {0x358A, 0x92B6},
        {0x358B, 0x92C1},
        {0x358C, 0x92E1},
        {0x358D, 0x92E5},
        {0x358E, 0x92E9},
        {0x358F, 0x92F1},
        {0x3590, 0x92F3},
        {0x3591, 0x9341},
        {0x3592, 0x9342},
        {0x3593, 0x9349},
        {0x3594, 0x9351},
        {0x3595, 0x9353},
        {0x3596, 0x9357},
        {0x3597, 0x9361},
        {0x3598, 0x9362},
        {0x3599, 0x9365},
        {0x359A, 0x9369},
        {0x359B, 0x936A},
        {0x359C, 0x936B},
        {0x359D, 0x9371},
        {0x359E, 0x9373},
        {0x359F, 0x9375},
        {0x35A0, 0x9377},
        {0x35A1, 0x9378},
        {0x3E56, 0x9379},
        {0x35A2, 0x937C},
        {0x35A3, 0x9381},
        {0x35A4, 0x9385},
        {0x35A5, 0x9389},
        {0x3E5E, 0x9397},
        {0x35A6, 0x93A1},
        {0x35A7, 0x93A2},
        {0x35A8, 0x93A5},
        {0x35A9, 0x93A9},
        {0x3E60, 0x93AA},
        {0x35AA, 0x93AB},
        {0x35AB, 0x93B1},
        {0x35AC, 0x93B3},
        {0x35AD, 0x93B5},
        {0x35AE, 0x93B7},
        {0x3E64, 0x93BA},
        {0x35AF, 0x93BC},
        {0x3137, 0x9441},
        {0x35B0, 0x9461},
        {0x35B1, 0x9462},
        {0x35B2, 0x9463},
        {0x35B3, 0x9465},
        {0x35B4, 0x9468},
        {0x35B5, 0x9469},
        {0x35B6, 0x946A},
        {0x35B7, 0x946B},
        {0x35B8, 0x946C},
        {0x35B9, 0x9470},
        {0x35BA, 0x9471},
        {0x35BB, 0x9473},
        {0x35BC, 0x9475},
        {0x35BD, 0x9476},
        {0x35BE, 0x9477},
        {0x35BF, 0x9478},
        {0x35C0, 0x9479},
        {0x35C1, 0x947D},
        {0x35C2, 0x9481},
        {0x35C3, 0x9482},
        {0x35C4, 0x9485},
        {0x35C5, 0x9489},
        {0x35C6, 0x9491},
        {0x35C7, 0x9493},
        {0x35C8, 0x9495},
        {0x35C9, 0x9496},
        {0x35CA, 0x9497},
        {0x35CB, 0x94A1},
        {0x3E74, 0x94B7},
        {0x3E75, 0x94C1},
        {0x35CC, 0x94E1},
        {0x35CD, 0x94E2},
        {0x35CE, 0x94E3},
        {0x35CF, 0x94E5},
        {0x35D0, 0x94E8},
        {0x35D1, 0x94E9},
        {0x35D2, 0x94EB},
        {0x35D3, 0x94EC},
        {0x35D4, 0x94F1},
        {0x35D5, 0x94F3},
        {0x35D6, 0x94F5},
        {0x3E7A, 0x94F6},
        {0x35D7, 0x94F7},
        {0x3E7B, 0x94F8},
        {0x35D8, 0x94F9},
        {0x35D9, 0x94FC},
        {0x35DA, 0x9541},
        {0x35DB, 0x9542},
        {0x35DC, 0x9545},
        {0x35DD, 0x9549},
        {0x35DE, 0x9551},
        {0x35DF, 0x9553},
        {0x35E0, 0x9555},
        {0x35E1, 0x9556},
        {0x35E2, 0x9557},
        {0x35E3, 0x9561},
        {0x35E4, 0x9565},
        {0x35E5, 0x9569},
        {0x3E85, 0x9571},
        {0x35E6, 0x9576},
        {0x35E7, 0x9577},
        {0x35E8, 0x9581},
        {0x35E9, 0x9585},
        {0x35EA, 0x95A1},
        {0x35EB, 0x95A2},
        {0x35EC, 0x95A5},
        {0x35ED, 0x95A8},
        {0x35EE, 0x95A9},
        {0x35EF, 0x95AB},
        {0x35F0, 0x95AD},
        {0x3E91, 0x95B0},
        {0x35F1, 0x95B1},
        {0x35F2, 0x95B3},
        {0x35F3, 0x95B5},
        {0x35F4, 0x95B7},
        {0x35F5, 0x95B9},
        {0x35F6, 0x95BB},
        {0x35F7, 0x95C1},
        {0x35F8, 0x95C5},
        {0x35F9, 0x95C9},
        {0x35FA, 0x95E1},
        {0x3E9C, 0x95E5},
        {0x3EA1, 0x95F5},
        {0x35FB, 0x95F6},
        {0x35FC, 0x9641},
        {0x35FD, 0x9645},
        {0x35FE, 0x9649},
        {0x35FF, 0x9651},
        {0x3600, 0x9653},
        {0x3601, 0x9655},
        {0x3EA5, 0x9656},
        {0x3602, 0x9661},
        {0x3603, 0x9681},
        {0x3604, 0x9682},
        {0x3605, 0x9685},
        {0x3EB0, 0x9688},
        {0x3606, 0x9689},
        {0x3607, 0x9691},
        {0x3608, 0x9693},
        {0x3609, 0x9695},
        {0x360A, 0x9697},
        {0x360B, 0x96A1},
        {0x3EBB, 0x96B5},
        {0x360C, 0x96B6},
        {0x360D, 0x96C1},
        {0x360E, 0x96D7},
        {0x360F, 0x96E1},
        {0x3610, 0x96E5},
        {0x3611, 0x96E9},
        {0x3EC7, 0x96F1},
        {0x3612, 0x96F3},
        {0x3613, 0x96F5},
        {0x3614, 0x96F7},
        {0x3615, 0x9741},
        {0x3EC9, 0x9742},
        {0x3616, 0x9745},
        {0x3617, 0x9749},
        {0x3618, 0x9751},
        {0x3619, 0x9757},
        {0x361A, 0x9761},
        {0x361B, 0x9762},
        {0x361C, 0x9765},
        {0x361D, 0x9768},
        {0x361E, 0x9769},
        {0x361F, 0x976B},
        {0x3ECD, 0x976C},
        {0x3620, 0x9771},
        {0x3621, 0x9773},
        {0x3622, 0x9775},
        {0x3623, 0x9777},
        {0x3624, 0x9781},
        {0x3625, 0x97A1},
        {0x3626, 0x97A2},
        {0x3627, 0x97A5},
        {0x3628, 0x97A8},
        {0x3629, 0x97A9},
        {0x362A, 0x97B1},
        {0x362B, 0x97B3},
        {0x362C, 0x97B5},
        {0x362D, 0x97B6},
        {0x362E, 0x97B7},
        {0x362F, 0x97B8},
        {0x3ED9, 0x97BC},
        {0x3138, 0x9841},
        {0x3630, 0x9861},
        {0x3631, 0x9862},
        {0x3EDB, 0x9863},
        {0x3632, 0x9865},
        {0x3EDC, 0x9868},
        {0x3633, 0x9869},
        {0x3EE0, 0x9870},
        {0x3634, 0x9871},
        {0x3635, 0x9873},
        {0x3636, 0x9875},
        {0x3637, 0x9876},
        {0x3638, 0x9877},
        {0x3639, 0x987D},
        {0x363A, 0x9881},
        {0x363B, 0x9882},
        {0x363C, 0x9885},
        {0x363D, 0x9889},
        {0x363E, 0x9891},
        {0x363F, 0x9893},
        {0x3640, 0x9895},
        {0x3641, 0x9896},
        {0x3642, 0x9897},
        {0x3EE4, 0x98A1},
        {0x3EE8, 0x98C1},
        {0x3643, 0x98E1},
        {0x3644, 0x98E2},
        {0x3645, 0x98E5},
        {0x3646, 0x98E9},
        {0x3647, 0x98EB},
        {0x3648, 0x98EC},
        {0x3649, 0x98F1},
        {0x364A, 0x98F3},
        {0x364B, 0x98F5},
        {0x364C, 0x98F6},
        {0x364D, 0x98F7},
        {0x364E, 0x98FD},
        {0x364F, 0x9941},
        {0x3650, 0x9942},
        {0x3651, 0x9945},
        {0x3652, 0x9949},
        {0x3653, 0x9951},
        {0x3654, 0x9953},
        {0x3655, 0x9955},
        {0x3656, 0x9956},
        {0x3657, 0x9957},
        {0x3658, 0x9961},
        {0x3659, 0x9976},
        {0x3EF4, 0x9981},
        {0x365A, 0x99A1},
        {0x365B, 0x99A2},
        {0x365C, 0x99A5},
        {0x365D, 0x99A9},
        {0x365E, 0x99B7},
        {0x365F, 0x99C1},
        {0x3660, 0x99C9},
        {0x3661, 0x99E1},
        {0x3662, 0x9A41},
        {0x3663, 0x9A45},
        {0x3F12, 0x9A61},
        {0x3664, 0x9A81},
        {0x3665, 0x9A82},
        {0x3666, 0x9A85},
        {0x3667, 0x9A89},
        {0x3668, 0x9A90},
        {0x3669, 0x9A91},
        {0x366A, 0x9A97},
        {0x3F1A, 0x9AA1},
        {0x366B, 0x9AC1},
        {0x366C, 0x9AE1},
        {0x366D, 0x9AE5},
        {0x366E, 0x9AE9},
        {0x366F, 0x9AF1},
        {0x3670, 0x9AF3},
        {0x3671, 0x9AF7},
        {0x3F27, 0x9B41},
        {0x3672, 0x9B61},
        {0x3673, 0x9B62},
        {0x3674, 0x9B65},
        {0x3675, 0x9B68},
        {0x3676, 0x9B69},
        {0x3677, 0x9B71},
        {0x3678, 0x9B73},
        {0x3679, 0x9B75},
        {0x367A, 0x9B81},
        {0x367B, 0x9B85},
        {0x367C, 0x9B89},
        {0x367D, 0x9B91},
        {0x367E, 0x9B93},
        {0x367F, 0x9BA1},
        {0x3680, 0x9BA5},
        {0x3681, 0x9BA9},
        {0x3682, 0x9BB1},
        {0x3683, 0x9BB3},
        {0x3684, 0x9BB5},
        {0x3685, 0x9BB7},
        {0x3139, 0x9C41},
        {0x3686, 0x9C61},
        {0x3687, 0x9C62},
        {0x3688, 0x9C65},
        {0x3689, 0x9C69},
        {0x368A, 0x9C71},
        {0x368B, 0x9C73},
        {0x368C, 0x9C75},
        {0x368D, 0x9C76},
        {0x368E, 0x9C77},
        {0x368F, 0x9C78},
        {0x3690, 0x9C7C},
        {0x3691, 0x9C7D},
        {0x3692, 0x9C81},
        {0x3693, 0x9C82},
        {0x3694, 0x9C85},
        {0x3695, 0x9C89},
        {0x3696, 0x9C91},
        {0x3697, 0x9C93},
        {0x3698, 0x9C95},
        {0x3699, 0x9C96},
        {0x369A, 0x9C97},
        {0x369B, 0x9CA1},
        {0x369C, 0x9CA2},
        {0x369D, 0x9CA5},
        {0x369E, 0x9CB5},
        {0x369F, 0x9CB7},
        {0x3F41, 0x9CC1},
        {0x36A0, 0x9CE1},
        {0x36A1, 0x9CE2},
        {0x36A2, 0x9CE5},
        {0x36A3, 0x9CE9},
        {0x36A4, 0x9CF1},
        {0x36A5, 0x9CF3},
        {0x36A6, 0x9CF5},
        {0x36A7, 0x9CF6},
        {0x36A8, 0x9CF7},
        {0x36A9, 0x9CFD},
        {0x36AA, 0x9D41},
        {0x36AB, 0x9D42},
        {0x36AC, 0x9D45},
        {0x3F49, 0x9D48},
        {0x36AD, 0x9D49},
        {0x36AE, 0x9D51},
        {0x36AF, 0x9D53},
        {0x36B0, 0x9D55},
        {0x36B1, 0x9D57},
        {0x36B2, 0x9D61},
        {0x36B3, 0x9D62},
        {0x36B4, 0x9D65},
        {0x36B5, 0x9D69},
        {0x36B6, 0x9D71},
        {0x36B7, 0x9D73},
        {0x36B8, 0x9D75},
        {0x36B9, 0x9D76},
        {0x36BA, 0x9D77},
        {0x36BB, 0x9D81},
        {0x36BC, 0x9D85},
        {0x36BD, 0x9D93},
        {0x36BE, 0x9D95},
        {0x36BF, 0x9DA1},
        {0x36C0, 0x9DA2},
        {0x36C1, 0x9DA5},
        {0x36C2, 0x9DA9},
        {0x36C3, 0x9DB1},
        {0x36C4, 0x9DB3},
        {0x36C5, 0x9DB5},
        {0x36C6, 0x9DB7},
        {0x36C7, 0x9DC1},
        {0x36C8, 0x9DC5},
        {0x36C9, 0x9DD7},
        {0x3F63, 0x9DE1},
        {0x36CA, 0x9DF6},
        {0x36CB, 0x9E41},
        {0x36CC, 0x9E45},
        {0x36CD, 0x9E49},
        {0x36CE, 0x9E51},
        {0x36CF, 0x9E53},
        {0x36D0, 0x9E55},
        {0x36D1, 0x9E57},
        {0x36D2, 0x9E61},
        {0x36D3, 0x9E65},
        {0x36D4, 0x9E69},
        {0x3F6E, 0x9E71},
        {0x36D5, 0x9E73},
        {0x36D6, 0x9E75},
        {0x36D7, 0x9E77},
        {0x36D8, 0x9E81},
        {0x36D9, 0x9E82},
        {0x36DA, 0x9E85},
        {0x36DB, 0x9E89},
        {0x36DC, 0x9E91},
        {0x36DD, 0x9E93},
        {0x36DE, 0x9E95},
        {0x36DF, 0x9E97},
        {0x36E0, 0x9EA1},
        {0x3F79, 0x9EB5},
        {0x36E1, 0x9EB6},
        {0x36E2, 0x9EC1},
        {0x36E3, 0x9EE1},
        {0x36E4, 0x9EE2},
        {0x36E5, 0x9EE5},
        {0x36E6, 0x9EE9},
        {0x36E7, 0x9EF1},
        {0x36E8, 0x9EF5},
        {0x36E9, 0x9EF7},
        {0x36EA, 0x9F41},
        {0x36EB, 0x9F42},
        {0x36EC, 0x9F45},
        {0x36ED, 0x9F49},
        {0x36EE, 0x9F51},
        {0x36EF, 0x9F53},
        {0x36F0, 0x9F55},
        {0x36F1, 0x9F57},
        {0x36F2, 0x9F61},
        {0x36F3, 0x9F62},
        {0x36F4, 0x9F65},
        {0x36F5, 0x9F69},
        {0x36F6, 0x9F71},
        {0x36F7, 0x9F73},
        {0x36F8, 0x9F75},
        {0x36F9, 0x9F77},
        {0x36FA, 0x9F78},
        {0x36FB, 0x9F7B},
        {0x36FC, 0x9F7C},
        {0x3F8C, 0x9F81},
        {0x36FD, 0x9FA1},
        {0x36FE, 0x9FA2},
        {0x36FF, 0x9FA5},
        {0x3700, 0x9FA9},
        {0x3701, 0x9FB1},
        {0x3702, 0x9FB3},
        {0x3703, 0x9FB5},
        {0x3704, 0x9FB7},
        {0x3141, 0xA041},
        {0x3705, 0xA061},
        {0x3706, 0xA062},
        {0x3707, 0xA065},
        {0x3708, 0xA067},
        {0x3709, 0xA068},
        {0x370A, 0xA069},
        {0x370B, 0xA06A},
        {0x370C, 0xA06B},
        {0x370D, 0xA071},
        {0x370E, 0xA073},
        {0x370F, 0xA075},
        {0x3710, 0xA077},
        {0x3711, 0xA078},
        {0x3F9D, 0xA079},
        {0x3712, 0xA07B},
        {0x3713, 0xA07D},
        {0x3714, 0xA081},
        {0x3715, 0xA082},
        {0x3716, 0xA085},
        {0x3717, 0xA089},
        {0x3718, 0xA091},
        {0x3719, 0xA093},
        {0x371A, 0xA095},
        {0x371B, 0xA096},
        {0x371C, 0xA097},
        {0x371D, 0xA098},
        {0x3FA2, 0xA099},
        {0x371E, 0xA0A1},
        {0x371F, 0xA0A2},
        {0x3720, 0xA0A9},
        {0x3721, 0xA0B7},
        {0x3FAA, 0xA0C1},
        {0x3722, 0xA0E1},
        {0x3723, 0xA0E2},
        {0x3724, 0xA0E5},
        {0x3725, 0xA0E9},
        {0x3726, 0xA0EB},
        {0x3727, 0xA0F1},
        {0x3728, 0xA0F3},
        {0x3729, 0xA0F5},
        {0x372A, 0xA0F7},
        {0x372B, 0xA0F8},
        {0x372C, 0xA0FD},
        {0x372D, 0xA141},
        {0x372E, 0xA142},
        {0x372F, 0xA145},
        {0x3730, 0xA149},
        {0x3731, 0xA151},
        {0x3732, 0xA153},
        {0x3733, 0xA155},
        {0x3734, 0xA156},
        {0x3735, 0xA157},
        {0x3FB3, 0xA159},
        {0x3FB4, 0xA15B},
        {0x3736, 0xA161},
        {0x3737, 0xA162},
        {0x3738, 0xA165},
        {0x3739, 0xA169},
        {0x3FB7, 0xA171},
        {0x373A, 0xA175},
        {0x373B, 0xA176},
        {0x373C, 0xA177},
        {0x373D, 0xA179},
        {0x373E, 0xA181},
        {0x373F, 0xA1A1},
        {0x3740, 0xA1A2},
        {0x3741, 0xA1A4},
        {0x3742, 0xA1A5},
        {0x3FC5, 0xA1A8},
        {0x3743, 0xA1A9},
        {0x3744, 0xA1AB},
        {0x3745, 0xA1B1},
        {0x3746, 0xA1B3},
        {0x3747, 0xA1B5},
        {0x3748, 0xA1B7},
        {0x3FC9, 0xA1BD},
        {0x3749, 0xA1C1},
        {0x374A, 0xA1C5},
        {0x374B, 0xA1D6},
        {0x374C, 0xA1D7},
        {0x3FD0, 0xA1E1},
        {0x374D, 0xA241},
        {0x374E, 0xA245},
        {0x374F, 0xA249},
        {0x3750, 0xA253},
        {0x3751, 0xA255},
        {0x3752, 0xA257},
        {0x3753, 0xA261},
        {0x3754, 0xA265},
        {0x3755, 0xA269},
        {0x3756, 0xA273},
        {0x3757, 0xA275},
        {0x3758, 0xA281},
        {0x3759, 0xA282},
        {0x375A, 0xA283},
        {0x375B, 0xA285},
        {0x375C, 0xA288},
        {0x375D, 0xA289},
        {0x375E, 0xA28A},
        {0x375F, 0xA28B},
        {0x3760, 0xA291},
        {0x3761, 0xA293},
        {0x3762, 0xA295},
        {0x3763, 0xA297},
        {0x3764, 0xA29B},
        {0x3765, 0xA29D},
        {0x3766, 0xA2A1},
        {0x3767, 0xA2A5},
        {0x3768, 0xA2A9},
        {0x3769, 0xA2B3},
        {0x376A, 0xA2B5},
        {0x376B, 0xA2C1},
        {0x376C, 0xA2E1},
        {0x376D, 0xA2E5},
        {0x376E, 0xA2E9},
        {0x376F, 0xA341},
        {0x3770, 0xA345},
        {0x3771, 0xA349},
        {0x3772, 0xA351},
        {0x3773, 0xA355},
        {0x3774, 0xA361},
        {0x3FF7, 0xA362},
        {0x3775, 0xA365},
        {0x3776, 0xA369},
        {0x3777, 0xA371},
        {0x3778, 0xA375},
        {0x3FFD, 0xA377},
        {0x3FFF, 0xA381},
        {0x4001, 0xA385},
        {0x3779, 0xA3A1},
        {0x377A, 0xA3A2},
        {0x377B, 0xA3A5},
        {0x377C, 0xA3A8},
        {0x377D, 0xA3A9},
        {0x377E, 0xA3AB},
        {0x377F, 0xA3B1},
        {0x3780, 0xA3B3},
        {0x3781, 0xA3B5},
        {0x3782, 0xA3B6},
        {0x3783, 0xA3B7},
        {0x400A, 0xA3B8},
        {0x3784, 0xA3B9},
        {0x3785, 0xA3BB},
        {0x3142, 0xA441},
        {0x3786, 0xA461},
        {0x3787, 0xA462},
        {0x3788, 0xA463},
        {0x3789, 0xA464},
        {0x378A, 0xA465},
        {0x378B, 0xA468},
        {0x378C, 0xA469},
        {0x378D, 0xA46A},
        {0x378E, 0xA46B},
        {0x378F, 0xA46C},
        {0x3790, 0xA471},
        {0x3791, 0xA473},
        {0x3792, 0xA475},
        {0x400E, 0xA476},
        {0x3793, 0xA477},
        {0x3794, 0xA47B},
        {0x3795, 0xA481},
        {0x3796, 0xA482},
        {0x3797, 0xA485},
        {0x4012, 0xA488},
        {0x3798, 0xA489},
        {0x3799, 0xA491},
        {0x379A, 0xA493},
        {0x379B, 0xA495},
        {0x379C, 0xA496},
        {0x379D, 0xA497},
        {0x379E, 0xA49B},
        {0x379F, 0xA4A1},
        {0x37A0, 0xA4A2},
        {0x37A1, 0xA4A5},
        {0x4015, 0xA4B1},
        {0x37A2, 0xA4B3},
        {0x4019, 0xA4C1},
        {0x37A3, 0xA4E1},
        {0x37A4, 0xA4E2},
        {0x37A5, 0xA4E5},
        {0x37A6, 0xA4E8},
        {0x37A7, 0xA4E9},
        {0x37A8, 0xA4EB},
        {0x37A9, 0xA4F1},
        {0x37AA, 0xA4F3},
        {0x37AB, 0xA4F5},
        {0x4020, 0xA4F6},
        {0x37AC, 0xA4F7},
        {0x37AD, 0xA4F8},
        {0x4021, 0xA4FA},
        {0x37AE, 0xA541},
        {0x37AF, 0xA542},
        {0x37B0, 0xA545},
        {0x37B1, 0xA548},
        {0x37B2, 0xA549},
        {0x37B3, 0xA551},
        {0x37B4, 0xA553},
        {0x37B5, 0xA555},
        {0x37B6, 0xA556},
        {0x37B7, 0xA557},
        {0x4025, 0xA55B},
        {0x37B8, 0xA561},
        {0x37B9, 0xA562},
        {0x37BA, 0xA565},
        {0x37BB, 0xA569},
        {0x4028, 0xA571},
        {0x37BC, 0xA573},
        {0x37BD, 0xA575},
        {0x37BE, 0xA576},
        {0x37BF, 0xA577},
        {0x4029, 0xA578},
        {0x402A, 0xA579},
        {0x402B, 0xA57A},
        {0x37C0, 0xA57B},
        {0x37C1, 0xA581},
        {0x37C2, 0xA585},
        {0x37C3, 0xA5A1},
        {0x37C4, 0xA5A2},
        {0x37C5, 0xA5A3},
        {0x37C6, 0xA5A5},
        {0x37C7, 0xA5A9},
        {0x37C8, 0xA5B1},
        {0x37C9, 0xA5B3},
        {0x37CA, 0xA5B5},
        {0x37CB, 0xA5B7},
        {0x37CC, 0xA5C1},
        {0x37CD, 0xA5C5},
        {0x403F, 0xA5D5},
        {0x37CE, 0xA5D6},
        {0x37CF, 0xA5E1},
        {0x37D0, 0xA5F6},
        {0x37D1, 0xA641},
        {0x37D2, 0xA642},
        {0x37D3, 0xA645},
        {0x37D4, 0xA649},
        {0x37D5, 0xA651},
        {0x37D6, 0xA653},
        {0x37D7, 0xA661},
        {0x37D8, 0xA665},
        {0x37D9, 0xA681},
        {0x37DA, 0xA682},
        {0x37DB, 0xA685},
        {0x37DC, 0xA688},
        {0x37DD, 0xA689},
        {0x37DE, 0xA68A},
        {0x37DF, 0xA68B},
        {0x37E0, 0xA691},
        {0x37E1, 0xA693},
        {0x37E2, 0xA695},
        {0x37E3, 0xA697},
        {0x4053, 0xA699},
        {0x37E4, 0xA69B},
        {0x37E5, 0xA69C},
        {0x37E6, 0xA6A1},
        {0x37E7, 0xA6A9},
        {0x37E8, 0xA6B6},
        {0x405D, 0xA6BA},
        {0x37E9, 0xA6C1},
        {0x37EA, 0xA6E1},
        {0x37EB, 0xA6E2},
        {0x37EC, 0xA6E5},
        {0x37ED, 0xA6E9},
        {0x37EE, 0xA6F7},
        {0x37EF, 0xA741},
        {0x37F0, 0xA745},
        {0x37F1, 0xA749},
        {0x37F2, 0xA751},
        {0x37F3, 0xA755},
        {0x37F4, 0xA757},
        {0x37F5, 0xA761},
        {0x37F6, 0xA762},
        {0x37F7, 0xA765},
        {0x37F8, 0xA769},
        {0x4071, 0xA76D},
        {0x37F9, 0xA771},
        {0x37FA, 0xA773},
        {0x37FB, 0xA775},
        {0x4073, 0xA777},
        {0x4077, 0xA781},
        {0x37FC, 0xA7A1},
        {0x37FD, 0xA7A2},
        {0x37FE, 0xA7A5},
        {0x407F, 0xA7A8},
        {0x37FF, 0xA7A9},
        {0x3800, 0xA7AB},
        {0x3801, 0xA7B1},
        {0x3802, 0xA7B3},
        {0x3803, 0xA7B5},
        {0x3804, 0xA7B7},
        {0x3805, 0xA7B8},
        {0x3806, 0xA7B9},
        {0x3143, 0xA841},
        {0x3807, 0xA861},
        {0x3808, 0xA862},
        {0x3809, 0xA865},
        {0x380A, 0xA869},
        {0x380B, 0xA86B},
        {0x380C, 0xA871},
        {0x380D, 0xA873},
        {0x380E, 0xA875},
        {0x380F, 0xA876},
        {0x3810, 0xA877},
        {0x3811, 0xA87D},
        {0x3812, 0xA881},
        {0x3813, 0xA882},
        {0x3814, 0xA885},
        {0x3815, 0xA889},
        {0x3816, 0xA891},
        {0x3817, 0xA893},
        {0x3818, 0xA895},
        {0x3819, 0xA896},
        {0x381A, 0xA897},
        {0x381B, 0xA8A1},
        {0x381C, 0xA8A2},
        {0x408B, 0xA8A5},
        {0x381D, 0xA8B1},
        {0x408C, 0xA8C1},
        {0x381E, 0xA8E1},
        {0x381F, 0xA8E2},
        {0x3820, 0xA8E5},
        {0x3821, 0xA8E8},
        {0x3822, 0xA8E9},
        {0x3823, 0xA8F1},
        {0x3824, 0xA8F5},
        {0x3825, 0xA8F6},
        {0x3826, 0xA8F7},
        {0x3827, 0xA941},
        {0x4090, 0xA942},
        {0x4091, 0xA945},
        {0x4093, 0xA949},
        {0x4096, 0xA955},
        {0x3828, 0xA957},
        {0x3829, 0xA961},
        {0x382A, 0xA962},
        {0x382B, 0xA971},
        {0x382C, 0xA973},
        {0x382D, 0xA975},
        {0x382E, 0xA976},
        {0x382F, 0xA977},
        {0x409C, 0xA981},
        {0x3830, 0xA9A1},
        {0x3831, 0xA9A2},
        {0x3832, 0xA9A5},
        {0x3833, 0xA9A9},
        {0x3834, 0xA9B1},
        {0x3835, 0xA9B3},
        {0x3836, 0xA9B7},
        {0x40A3, 0xA9C1},
        {0x40A6, 0xA9E1},
        {0x3837, 0xAA41},
        {0x3838, 0xAA61},
        {0x40AB, 0xAA71},
        {0x3839, 0xAA77},
        {0x383A, 0xAA81},
        {0x383B, 0xAA82},
        {0x383C, 0xAA85},
        {0x383D, 0xAA89},
        {0x40AE, 0xAA8A},
        {0x383E, 0xAA91},
        {0x40AF, 0xAA93},
        {0x383F, 0xAA95},
        {0x3840, 0xAA97},
        {0x40B0, 0xAAA1},
        {0x40B2, 0xAAC1},
        {0x40B3, 0xAAE1},
        {0x3841, 0xAB41},
        {0x3842, 0xAB57},
        {0x3843, 0xAB61},
        {0x40B7, 0xAB62},
        {0x3844, 0xAB65},
        {0x3845, 0xAB69},
        {0x3846, 0xAB71},
        {0x3847, 0xAB73},
        {0x40BA, 0xAB81},
        {0x3848, 0xABA1},
        {0x3849, 0xABA2},
        {0x384A, 0xABA5},
        {0x384B, 0xABA9},
        {0x384C, 0xABB1},
        {0x384D, 0xABB3},
        {0x384E, 0xABB5},
        {0x384F, 0xABB7},
        {0x3145, 0xAC41},
        {0x3850, 0xAC61},
        {0x3851, 0xAC62},
        {0x40C0, 0xAC63},
        {0x3852, 0xAC64},
        {0x3853, 0xAC65},
        {0x3854, 0xAC68},
        {0x3855, 0xAC69},
        {0x3856, 0xAC6A},
        {0x3857, 0xAC6B},
        {0x40C1, 0xAC6C},
        {0x40C4, 0xAC70},
        {0x3858, 0xAC71},
        {0x3859, 0xAC73},
        {0x385A, 0xAC75},
        {0x385B, 0xAC76},
        {0x385C, 0xAC77},
        {0x40C6, 0xAC79},
        {0x385D, 0xAC7B},
        {0x40C9, 0xAC7D},
        {0x385E, 0xAC81},
        {0x385F, 0xAC82},
        {0x3860, 0xAC85},
        {0x40CB, 0xAC88},
        {0x3861, 0xAC89},
        {0x3862, 0xAC91},
        {0x3863, 0xAC93},
        {0x3864, 0xAC95},
        {0x3865, 0xAC96},
        {0x3866, 0xAC97},
        {0x3867, 0xACA1},
        {0x3868, 0xACA2},
        {0x3869, 0xACA5},
        {0x386A, 0xACA9},
        {0x386B, 0xACB1},
        {0x386C, 0xACB3},
        {0x386D, 0xACB5},
        {0x386E, 0xACB7},
        {0x386F, 0xACC1},
        {0x3870, 0xACC5},
        {0x3871, 0xACC9},
        {0x3872, 0xACD1},
        {0x3873, 0xACD7},
        {0x3874, 0xACE1},
        {0x3875, 0xACE2},
        {0x3876, 0xACE3},
        {0x3877, 0xACE4},
        {0x3878, 0xACE5},
        {0x3879, 0xACE8},
        {0x387A, 0xACE9},
        {0x40D2, 0xACEA},
        {0x387B, 0xACEB},
        {0x387C, 0xACEC},
        {0x387D, 0xACF1},
        {0x387E, 0xACF3},
        {0x387F, 0xACF5},
        {0x3880, 0xACF6},
        {0x3881, 0xACF7},
        {0x3882, 0xACFC},
        {0x3883, 0xAD41},
        {0x3884, 0xAD42},
        {0x3885, 0xAD45},
        {0x40D6, 0xAD48},
        {0x3886, 0xAD49},
        {0x3887, 0xAD51},
        {0x3888, 0xAD53},
        {0x3889, 0xAD55},
        {0x388A, 0xAD56},
        {0x388B, 0xAD57},
        {0x40D8, 0xAD5B},
        {0x388C, 0xAD61},
        {0x388D, 0xAD62},
        {0x40DA, 0xAD64},
        {0x388E, 0xAD65},
        {0x388F, 0xAD69},
        {0x3890, 0xAD71},
        {0x3891, 0xAD73},
        {0x3892, 0xAD75},
        {0x3893, 0xAD76},
        {0x3894, 0xAD77},
        {0x3895, 0xAD81},
        {0x3896, 0xAD85},
        {0x3897, 0xAD89},
        {0x3898, 0xAD97},
        {0x3899, 0xADA1},
        {0x389A, 0xADA2},
        {0x389B, 0xADA3},
        {0x389C, 0xADA5},
        {0x40E4, 0xADA8},
        {0x389D, 0xADA9},
        {0x389E, 0xADAB},
        {0x389F, 0xADB1},
        {0x38A0, 0xADB3},
        {0x38A1, 0xADB5},
        {0x38A2, 0xADB7},
        {0x38A3, 0xADBB},
        {0x38A4, 0xADC1},
        {0x38A5, 0xADC2},
        {0x38A6, 0xADC5},
        {0x38A7, 0xADC9},
        {0x40EC, 0xADD5},
        {0x38A8, 0xADD7},
        {0x38A9, 0xADE1},
        {0x38AA, 0xADE5},
        {0x38AB, 0xADE9},
        {0x38AC, 0xADF1},
        {0x38AD, 0xADF5},
        {0x38AE, 0xADF6},
        {0x38AF, 0xAE41},
        {0x38B0, 0xAE45},
        {0x38B1, 0xAE49},
        {0x38B2, 0xAE51},
        {0x38B3, 0xAE53},
        {0x38B4, 0xAE55},
        {0x38B5, 0xAE61},
        {0x38B6, 0xAE62},
        {0x38B7, 0xAE65},
        {0x38B8, 0xAE69},
        {0x38B9, 0xAE71},
        {0x38BA, 0xAE73},
        {0x38BB, 0xAE75},
        {0x38BC, 0xAE77},
        {0x38BD, 0xAE81},
        {0x38BE, 0xAE82},
        {0x38BF, 0xAE85},
        {0x38C0, 0xAE88},
        {0x38C1, 0xAE89},
        {0x38C2, 0xAE91},
        {0x38C3, 0xAE93},
        {0x38C4, 0xAE95},
        {0x38C5, 0xAE97},
        {0x38C6, 0xAE99},
        {0x38C7, 0xAE9B},
        {0x38C8, 0xAE9C},
        {0x38C9, 0xAEA1},
        {0x38CA, 0xAEB6},
        {0x38CB, 0xAEC1},
        {0x38CC, 0xAEC2},
        {0x38CD, 0xAEC5},
        {0x38CE, 0xAEC9},
        {0x38CF, 0xAED1},
        {0x38D0, 0xAED7},
        {0x38D1, 0xAEE1},
        {0x38D2, 0xAEE2},
        {0x38D3, 0xAEE5},
        {0x38D4, 0xAEE9},
        {0x38D5, 0xAEF1},
        {0x38D6, 0xAEF3},
        {0x38D7, 0xAEF5},
        {0x38D8, 0xAEF7},
        {0x38D9, 0xAF41},
        {0x38DA, 0xAF42},
        {0x410B, 0xAF45},
        {0x38DB, 0xAF49},
        {0x38DC, 0xAF51},
        {0x38DD, 0xAF55},
        {0x38DE, 0xAF57},
        {0x38DF, 0xAF61},
        {0x38E0, 0xAF62},
        {0x38E1, 0xAF65},
        {0x38E2, 0xAF69},
        {0x38E3, 0xAF6A},
        {0x4113, 0xAF70},
        {0x38E4, 0xAF71},
        {0x38E5, 0xAF73},
        {0x38E6, 0xAF75},
        {0x38E7, 0xAF77},
        {0x4117, 0xAF81},
        {0x38E8, 0xAFA1},
        {0x38E9, 0xAFA2},
        {0x38EA, 0xAFA5},
        {0x38EB, 0xAFA8},
        {0x38EC, 0xAFA9},
        {0x4122, 0xAFAB},
        {0x38ED, 0xAFB0},
        {0x38EE, 0xAFB1},
        {0x38EF, 0xAFB3},
        {0x38F0, 0xAFB5},
        {0x38F1, 0xAFB7},
        {0x38F2, 0xAFBC},
        {0x3146, 0xB041},
        {0x38F3, 0xB061},
        {0x38F4, 0xB062},
        {0x38F5, 0xB064},
        {0x38F6, 0xB065},
        {0x38F7, 0xB069},
        {0x4129, 0xB06B},
        {0x38F8, 0xB071},
        {0x38F9, 0xB073},
        {0x412A, 0xB075},
        {0x38FA, 0xB076},
        {0x38FB, 0xB077},
        {0x38FC, 0xB07D},
        {0x38FD, 0xB081},
        {0x38FE, 0xB082},
        {0x38FF, 0xB085},
        {0x3900, 0xB089},
        {0x3901, 0xB091},
        {0x3902, 0xB093},
        {0x412E, 0xB095},
        {0x3903, 0xB096},
        {0x3904, 0xB097},
        {0x4130, 0xB0A1},
        {0x4137, 0xB0B5},
        {0x3905, 0xB0B7},
        {0x4138, 0xB0C1},
        {0x3906, 0xB0E1},
        {0x3907, 0xB0E2},
        {0x3908, 0xB0E5},
        {0x3909, 0xB0E9},
        {0x390A, 0xB0EB},
        {0x390B, 0xB0F1},
        {0x390C, 0xB0F3},
        {0x413F, 0xB0F5},
        {0x390D, 0xB0F6},
        {0x390E, 0xB0F7},
        {0x390F, 0xB141},
        {0x4141, 0xB142},
        {0x3910, 0xB145},
        {0x3911, 0xB149},
        {0x4147, 0xB157},
        {0x4149, 0xB161},
        {0x4153, 0xB181},
        {0x3912, 0xB185},
        {0x3913, 0xB1A1},
        {0x3914, 0xB1A2},
        {0x3915, 0xB1A5},
        {0x3916, 0xB1A8},
        {0x3917, 0xB1A9},
        {0x3918, 0xB1AB},
        {0x3919, 0xB1B1},
        {0x391A, 0xB1B3},
        {0x391B, 0xB1B7},
        {0x391C, 0xB1C1},
        {0x391D, 0xB1C2},
        {0x391E, 0xB1C5},
        {0x415D, 0xB1C9},
        {0x391F, 0xB1D6},
        {0x3920, 0xB1E1},
        {0x3921, 0xB1F6},
        {0x3922, 0xB241},
        {0x3923, 0xB245},
        {0x3924, 0xB249},
        {0x3925, 0xB251},
        {0x3926, 0xB253},
        {0x4169, 0xB255},
        {0x3927, 0xB261},
        {0x3928, 0xB281},
        {0x3929, 0xB282},
        {0x392A, 0xB285},
        {0x392B, 0xB289},
        {0x392C, 0xB291},
        {0x392D, 0xB293},
        {0x4175, 0xB295},
        {0x392E, 0xB297},
        {0x392F, 0xB2A1},
        {0x417D, 0xB2B5},
        {0x3930, 0xB2B6},
        {0x3931, 0xB2C1},
        {0x3932, 0xB2E1},
        {0x3933, 0xB2E5},
        {0x418F, 0xB2FD},
        {0x4190, 0xB341},
        {0x3934, 0xB357},
        {0x3935, 0xB361},
        {0x3936, 0xB362},
        {0x3937, 0xB365},
        {0x3938, 0xB369},
        {0x3939, 0xB36B},
        {0x393A, 0xB370},
        {0x393B, 0xB371},
        {0x393C, 0xB373},
        {0x393D, 0xB381},
        {0x393E, 0xB385},
        {0x393F, 0xB389},
        {0x3940, 0xB391},
        {0x3941, 0xB3A1},
        {0x3942, 0xB3A2},
        {0x3943, 0xB3A5},
        {0x3944, 0xB3A9},
        {0x3945, 0xB3B1},
        {0x3946, 0xB3B3},
        {0x3947, 0xB3B5},
        {0x41A1, 0xB3B6},
        {0x3948, 0xB3B7},
        {0x41A2, 0xB3B9},
        {0x3147, 0xB441},
        {0x3949, 0xB461},
        {0x394A, 0xB462},
        {0x394B, 0xB465},
        {0x394C, 0xB466},
        {0x394D, 0xB467},
        {0x394E, 0xB469},
        {0x394F, 0xB46A},
        {0x3950, 0xB46B},
        {0x41A6, 0xB46C},
        {0x3951, 0xB470},
        {0x3952, 0xB471},
        {0x3953, 0xB473},
        {0x3954, 0xB475},
        {0x3955, 0xB476},
        {0x3956, 0xB477},
        {0x3957, 0xB47B},
        {0x3958, 0xB47C},
        {0x41AB, 0xB47D},
        {0x3959, 0xB481},
        {0x395A, 0xB482},
        {0x395B, 0xB485},
        {0x395C, 0xB489},
        {0x395D, 0xB491},
        {0x395E, 0xB493},
        {0x395F, 0xB495},
        {0x3960, 0xB496},
        {0x3961, 0xB497},
        {0x3962, 0xB4A1},
        {0x3963, 0xB4A2},
        {0x3964, 0xB4A5},
        {0x3965, 0xB4A9},
        {0x3966, 0xB4AC},
        {0x3967, 0xB4B1},
        {0x3968, 0xB4B3},
        {0x3969, 0xB4B5},
        {0x41B1, 0xB4B6},
        {0x396A, 0xB4B7},
        {0x396B, 0xB4BB},
        {0x396C, 0xB4BD},
        {0x396D, 0xB4C1},
        {0x396E, 0xB4C5},
        {0x396F, 0xB4C9},
        {0x3970, 0xB4D3},
        {0x41B7, 0xB4D5},
        {0x3971, 0xB4E1},
        {0x3972, 0xB4E2},
        {0x41BA, 0xB4E3},
        {0x3973, 0xB4E5},
        {0x3974, 0xB4E6},
        {0x3975, 0xB4E8},
        {0x3976, 0xB4E9},
        {0x3977, 0xB4EA},
        {0x3978, 0xB4EB},
        {0x3979, 0xB4F1},
        {0x397A, 0xB4F3},
        {0x397B, 0xB4F4},
        {0x397C, 0xB4F5},
        {0x397D, 0xB4F6},
        {0x397E, 0xB4F7},
        {0x397F, 0xB4F8},
        {0x3980, 0xB4FA},
        {0x3981, 0xB4FC},
        {0x3982, 0xB541},
        {0x3983, 0xB542},
        {0x3984, 0xB545},
        {0x3985, 0xB549},
        {0x3986, 0xB551},
        {0x3987, 0xB553},
        {0x3988, 0xB555},
        {0x3989, 0xB557},
        {0x398A, 0xB561},
        {0x398B, 0xB562},
        {0x398C, 0xB563},
        {0x398D, 0xB565},
        {0x41C2, 0xB566},
        {0x41C3, 0xB568},
        {0x398E, 0xB569},
        {0x398F, 0xB56B},
        {0x3990, 0xB56C},
        {0x3991, 0xB571},
        {0x3992, 0xB573},
        {0x3993, 0xB574},
        {0x3994, 0xB575},
        {0x3995, 0xB576},
        {0x3996, 0xB577},
        {0x3997, 0xB57B},
        {0x3998, 0xB57C},
        {0x3999, 0xB57D},
        {0x399A, 0xB581},
        {0x399B, 0xB585},
        {0x399C, 0xB589},
        {0x399D, 0xB591},
        {0x399E, 0xB593},
        {0x399F, 0xB595},
        {0x39A0, 0xB596},
        {0x41C8, 0xB597},
        {0x39A1, 0xB5A1},
        {0x39A2, 0xB5A2},
        {0x39A3, 0xB5A5},
        {0x41CC, 0xB5A8},
        {0x39A4, 0xB5A9},
        {0x39A5, 0xB5AA},
        {0x39A6, 0xB5AB},
        {0x39A7, 0xB5AD},
        {0x39A8, 0xB5B0},
        {0x39A9, 0xB5B1},
        {0x39AA, 0xB5B3},
        {0x39AB, 0xB5B5},
        {0x39AC, 0xB5B7},
        {0x41CF, 0xB5B8},
        {0x39AD, 0xB5B9},
        {0x39AE, 0xB5C1},
        {0x39AF, 0xB5C2},
        {0x39B0, 0xB5C5},
        {0x39B1, 0xB5C9},
        {0x39B2, 0xB5D1},
        {0x39B3, 0xB5D3},
        {0x39B4, 0xB5D5},
        {0x39B5, 0xB5D6},
        {0x39B6, 0xB5D7},
        {0x39B7, 0xB5E1},
        {0x39B8, 0xB5E2},
        {0x39B9, 0xB5E5},
        {0x39BA, 0xB5F1},
        {0x39BB, 0xB5F5},
        {0x39BC, 0xB5F7},
        {0x39BD, 0xB641},
        {0x39BE, 0xB642},
        {0x39BF, 0xB645},
        {0x39C0, 0xB649},
        {0x39C1, 0xB651},
        {0x39C2, 0xB653},
        {0x39C3, 0xB655},
        {0x39C4, 0xB657},
        {0x39C5, 0xB661},
        {0x39C6, 0xB662},
        {0x39C7, 0xB665},
        {0x39C8, 0xB669},
        {0x39C9, 0xB671},
        {0x39CA, 0xB673},
        {0x39CB, 0xB675},
        {0x39CC, 0xB677},
        {0x39CD, 0xB681},
        {0x39CE, 0xB682},
        {0x39CF, 0xB685},
        {0x41E0, 0xB688},
        {0x39D0, 0xB689},
        {0x39D1, 0xB68A},
        {0x39D2, 0xB68B},
        {0x39D3, 0xB691},
        {0x39D4, 0xB693},
        {0x39D5, 0xB695},
        {0x39D6, 0xB697},
        {0x39D7, 0xB6A1},
        {0x39D8, 0xB6A2},
        {0x39D9, 0xB6A5},
        {0x39DA, 0xB6A9},
        {0x39DB, 0xB6B1},
        {0x39DC, 0xB6B3},
        {0x41E8, 0xB6B5},
        {0x39DD, 0xB6B6},
        {0x39DE, 0xB6B7},
        {0x39DF, 0xB6C1},
        {0x39E0, 0xB6C2},
        {0x39E1, 0xB6C5},
        {0x39E2, 0xB6C9},
        {0x39E3, 0xB6D1},
        {0x39E4, 0xB6D3},
        {0x39E5, 0xB6D7},
        {0x39E6, 0xB6E1},
        {0x39E7, 0xB6E2},
        {0x39E8, 0xB6E5},
        {0x41EF, 0xB6E8},
        {0x39E9, 0xB6E9},
        {0x39EA, 0xB6F1},
        {0x39EB, 0xB6F3},
        {0x39EC, 0xB6F5},
        {0x39ED, 0xB6F7},
        {0x39EE, 0xB741},
        {0x39EF, 0xB742},
        {0x39F0, 0xB745},
        {0x39F1, 0xB749},
        {0x39F2, 0xB751},
        {0x39F3, 0xB753},
        {0x39F4, 0xB755},
        {0x39F5, 0xB757},
        {0x41F6, 0xB758},
        {0x39F6, 0xB759},
        {0x39F7, 0xB761},
        {0x39F8, 0xB762},
        {0x39F9, 0xB765},
        {0x39FA, 0xB769},
        {0x39FB, 0xB76F},
        {0x39FC, 0xB771},
        {0x39FD, 0xB773},
        {0x39FE, 0xB775},
        {0x39FF, 0xB777},
        {0x3A00, 0xB778},
        {0x3A01, 0xB779},
        {0x3A02, 0xB77A},
        {0x3A03, 0xB77B},
        {0x3A04, 0xB77C},
        {0x3A05, 0xB77D},
        {0x3A06, 0xB781},
        {0x3A07, 0xB785},
        {0x3A08, 0xB789},
        {0x3A09, 0xB791},
        {0x3A0A, 0xB795},
        {0x3A0B, 0xB7A1},
        {0x3A0C, 0xB7A2},
        {0x3A0D, 0xB7A5},
        {0x4203, 0xB7A8},
        {0x3A0E, 0xB7A9},
        {0x3A0F, 0xB7AA},
        {0x3A10, 0xB7AB},
        {0x3A11, 0xB7B0},
        {0x3A12, 0xB7B1},
        {0x3A13, 0xB7B3},
        {0x3A14, 0xB7B5},
        {0x3A15, 0xB7B6},
        {0x3A16, 0xB7B7},
        {0x3A17, 0xB7B8},
        {0x3A18, 0xB7BC},
        {0x3148, 0xB841},
        {0x3A19, 0xB861},
        {0x3A1A, 0xB862},
        {0x3A1B, 0xB865},
        {0x3A1C, 0xB867},
        {0x3A1D, 0xB868},
        {0x3A1E, 0xB869},
        {0x3A1F, 0xB86B},
        {0x3A20, 0xB871},
        {0x3A21, 0xB873},
        {0x3A22, 0xB875},
        {0x3A23, 0xB876},
        {0x3A24, 0xB877},
        {0x3A25, 0xB878},
        {0x420D, 0xB879},
        {0x420F, 0xB87C},
        {0x3A26, 0xB881},
        {0x3A27, 0xB882},
        {0x3A28, 0xB885},
        {0x3A29, 0xB889},
        {0x3A2A, 0xB891},
        {0x3A2B, 0xB893},
        {0x3A2C, 0xB895},
        {0x3A2D, 0xB896},
        {0x3A2E, 0xB897},
        {0x3A2F, 0xB8A1},
        {0x3A30, 0xB8A2},
        {0x3A31, 0xB8A5},
        {0x3A32, 0xB8A7},
        {0x3A33, 0xB8A9},
        {0x3A34, 0xB8B1},
        {0x3A35, 0xB8B7},
        {0x3A36, 0xB8C1},
        {0x3A37, 0xB8C5},
        {0x3A38, 0xB8C9},
        {0x3A39, 0xB8E1},
        {0x3A3A, 0xB8E2},
        {0x3A3B, 0xB8E5},
        {0x421E, 0xB8E8},
        {0x3A3C, 0xB8E9},
        {0x3A3D, 0xB8EB},
        {0x3A3E, 0xB8F1},
        {0x3A3F, 0xB8F3},
        {0x3A40, 0xB8F5},
        {0x4220, 0xB8F6},
        {0x3A41, 0xB8F7},
        {0x3A42, 0xB8F8},
        {0x4222, 0xB8FD},
        {0x3A43, 0xB941},
        {0x3A44, 0xB942},
        {0x3A45, 0xB945},
        {0x3A46, 0xB949},
        {0x3A47, 0xB951},
        {0x3A48, 0xB953},
        {0x3A49, 0xB955},
        {0x3A4A, 0xB957},
        {0x3A4B, 0xB961},
        {0x4226, 0xB962},
        {0x3A4C, 0xB965},
        {0x3A4D, 0xB969},
        {0x3A4E, 0xB971},
        {0x3A4F, 0xB973},
        {0x422C, 0xB975},
        {0x3A50, 0xB976},
        {0x3A51, 0xB977},
        {0x3A52, 0xB981},
        {0x3A53, 0xB9A1},
        {0x3A54, 0xB9A2},
        {0x3A55, 0xB9A5},
        {0x3A56, 0xB9A9},
        {0x3A57, 0xB9AB},
        {0x3A58, 0xB9B1},
        {0x3A59, 0xB9B3},
        {0x3A5A, 0xB9B5},
        {0x3A5B, 0xB9B7},
        {0x3A5C, 0xB9B8},
        {0x3A5D, 0xB9B9},
        {0x3A5E, 0xB9BD},
        {0x3A5F, 0xB9C1},
        {0x3A60, 0xB9C2},
        {0x4238, 0xB9C5},
        {0x3A61, 0xB9C9},
        {0x423C, 0xB9D1},
        {0x3A62, 0xB9D3},
        {0x3A63, 0xB9D5},
        {0x423D, 0xB9D6},
        {0x3A64, 0xB9D7},
        {0x3A65, 0xB9E1},
        {0x423F, 0xB9E5},
        {0x4241, 0xB9E9},
        {0x4242, 0xB9F1},
        {0x3A66, 0xB9F6},
        {0x3A67, 0xB9F7},
        {0x3A68, 0xBA41},
        {0x3A69, 0xBA45},
        {0x3A6A, 0xBA49},
        {0x3A6B, 0xBA51},
        {0x3A6C, 0xBA53},
        {0x3A6D, 0xBA55},
        {0x3A6E, 0xBA57},
        {0x3A6F, 0xBA61},
        {0x3A70, 0xBA62},
        {0x3A71, 0xBA65},
        {0x4248, 0xBA69},
        {0x4249, 0xBA71},
        {0x424A, 0xBA73},
        {0x3A72, 0xBA77},
        {0x3A73, 0xBA81},
        {0x3A74, 0xBA82},
        {0x3A75, 0xBA85},
        {0x3A76, 0xBA89},
        {0x3A77, 0xBA8A},
        {0x3A78, 0xBA8B},
        {0x3A79, 0xBA91},
        {0x3A7A, 0xBA93},
        {0x3A7B, 0xBA95},
        {0x3A7C, 0xBA97},
        {0x3A7D, 0xBAA1},
        {0x4256, 0xBAB5},
        {0x3A7E, 0xBAB6},
        {0x3A7F, 0xBAC1},
        {0x3A80, 0xBAE1},
        {0x3A81, 0xBAE2},
        {0x3A82, 0xBAE5},
        {0x3A83, 0xBAE9},
        {0x3A84, 0xBAF1},
        {0x3A85, 0xBAF3},
        {0x3A86, 0xBAF5},
        {0x3A87, 0xBB41},
        {0x4263, 0xBB42},
        {0x3A88, 0xBB45},
        {0x3A89, 0xBB49},
        {0x3A8A, 0xBB51},
        {0x3A8B, 0xBB61},
        {0x3A8C, 0xBB62},
        {0x3A8D, 0xBB65},
        {0x3A8E, 0xBB69},
        {0x3A8F, 0xBB71},
        {0x3A90, 0xBB73},
        {0x3A91, 0xBB75},
        {0x3A92, 0xBB77},
        {0x426C, 0xBB81},
        {0x3A93, 0xBBA1},
        {0x3A94, 0xBBA2},
        {0x3A95, 0xBBA5},
        {0x3A96, 0xBBA8},
        {0x3A97, 0xBBA9},
        {0x3A98, 0xBBAB},
        {0x3A99, 0xBBB1},
        {0x3A9A, 0xBBB3},
        {0x3A9B, 0xBBB5},
        {0x4276, 0xBBB6},
        {0x3A9C, 0xBBB7},
        {0x3A9D, 0xBBB8},
        {0x3A9E, 0xBBBB},
        {0x3A9F, 0xBBBC},
        {0x3149, 0xBC41},
        {0x3AA0, 0xBC61},
        {0x3AA1, 0xBC62},
        {0x3AA2, 0xBC65},
        {0x3AA3, 0xBC67},
        {0x3AA4, 0xBC69},
        {0x3AA5, 0xBC6C},
        {0x3AA6, 0xBC71},
        {0x3AA7, 0xBC73},
        {0x3AA8, 0xBC75},
        {0x3AA9, 0xBC76},
        {0x3AAA, 0xBC77},
        {0x3AAB, 0xBC81},
        {0x3AAC, 0xBC82},
        {0x3AAD, 0xBC85},
        {0x3AAE, 0xBC89},
        {0x3AAF, 0xBC91},
        {0x3AB0, 0xBC93},
        {0x3AB1, 0xBC95},
        {0x3AB2, 0xBC96},
        {0x3AB3, 0xBC97},
        {0x3AB4, 0xBCA1},
        {0x3AB5, 0xBCA5},
        {0x3AB6, 0xBCB7},
        {0x4285, 0xBCC1},
        {0x3AB7, 0xBCE1},
        {0x3AB8, 0xBCE2},
        {0x3AB9, 0xBCE5},
        {0x3ABA, 0xBCE9},
        {0x4287, 0xBCEC},
        {0x3ABB, 0xBCF1},
        {0x3ABC, 0xBCF3},
        {0x3ABD, 0xBCF5},
        {0x3ABE, 0xBCF6},
        {0x3ABF, 0xBCF7},
        {0x3AC0, 0xBD41},
        {0x428E, 0xBD49},
        {0x3AC1, 0xBD57},
        {0x3AC2, 0xBD61},
        {0x429A, 0xBD75},
        {0x3AC3, 0xBD76},
        {0x429C, 0xBD81},
        {0x3AC4, 0xBDA1},
        {0x3AC5, 0xBDA2},
        {0x3AC6, 0xBDA5},
        {0x3AC7, 0xBDA9},
        {0x3AC8, 0xBDB1},
        {0x3AC9, 0xBDB3},
        {0x3ACA, 0xBDB5},
        {0x3ACB, 0xBDB7},
        {0x42A7, 0xBDB8},
        {0x3ACC, 0xBDB9},
        {0x3ACD, 0xBDC1},
        {0x3ACE, 0xBDC2},
        {0x3ACF, 0xBDC9},
        {0x3AD0, 0xBDD6},
        {0x3AD1, 0xBDE1},
        {0x3AD2, 0xBDF6},
        {0x3AD3, 0xBE41},
        {0x3AD4, 0xBE45},
        {0x3AD5, 0xBE49},
        {0x3AD6, 0xBE51},
        {0x3AD7, 0xBE53},
        {0x42B9, 0xBE61},
        {0x3AD8, 0xBE77},
        {0x3AD9, 0xBE81},
        {0x3ADA, 0xBE82},
        {0x3ADB, 0xBE85},
        {0x3ADC, 0xBE89},
        {0x3ADD, 0xBE91},
        {0x3ADE, 0xBE93},
        {0x3ADF, 0xBE97},
        {0x3AE0, 0xBEA1},
        {0x3AE1, 0xBEB6},
        {0x3AE2, 0xBEB7},
        {0x42CB, 0xBEC1},
        {0x3AE3, 0xBEE1},
        {0x3AE4, 0xBF41},
        {0x3AE5, 0xBF61},
        {0x3AE6, 0xBF71},
        {0x42E7, 0xBF73},
        {0x3AE7, 0xBF75},
        {0x3AE8, 0xBF77},
        {0x42E9, 0xBF81},
        {0x3AE9, 0xBFA1},
        {0x3AEA, 0xBFA2},
        {0x3AEB, 0xBFA5},
        {0x3AEC, 0xBFA9},
        {0x3AED, 0xBFB1},
        {0x3AEE, 0xBFB3},
        {0x42F3, 0xBFB5},
        {0x3AEF, 0xBFB7},
        {0x3AF0, 0xBFB8},
        {0x42F4, 0xBFBC},
        {0x3AF1, 0xBFBD},
        {0x314A, 0xC041},
        {0x3AF2, 0xC061},
        {0x3AF3, 0xC062},
        {0x3AF4, 0xC065},
        {0x3AF5, 0xC067},
        {0x42F5, 0xC068},
        {0x3AF6, 0xC069},
        {0x3AF7, 0xC071},
        {0x3AF8, 0xC073},
        {0x3AF9, 0xC075},
        {0x3AFA, 0xC076},
        {0x3AFB, 0xC077},
        {0x3AFC, 0xC078},
        {0x42F7, 0xC079},
        {0x42F8, 0xC07C},
        {0x3AFD, 0xC081},
        {0x3AFE, 0xC082},
        {0x3AFF, 0xC085},
        {0x3B00, 0xC089},
        {0x3B01, 0xC091},
        {0x3B02, 0xC093},
        {0x3B03, 0xC095},
        {0x3B04, 0xC096},
        {0x3B05, 0xC097},
        {0x3B06, 0xC0A1},
        {0x3B07, 0xC0A5},
        {0x3B08, 0xC0A7},
        {0x3B09, 0xC0A9},
        {0x3B0A, 0xC0B1},
        {0x42FD, 0xC0B3},
        {0x3B0B, 0xC0B7},
        {0x4300, 0xC0C1},
        {0x3B0C, 0xC0E1},
        {0x3B0D, 0xC0E2},
        {0x3B0E, 0xC0E5},
        {0x3B0F, 0xC0E9},
        {0x3B10, 0xC0F1},
        {0x3B11, 0xC0F3},
        {0x3B12, 0xC0F5},
        {0x3B13, 0xC0F6},
        {0x3B14, 0xC0F7},
        {0x3B15, 0xC141},
        {0x3B16, 0xC142},
        {0x3B17, 0xC145},
        {0x3B18, 0xC149},
        {0x3B19, 0xC151},
        {0x3B1A, 0xC153},
        {0x3B1B, 0xC155},
        {0x3B1C, 0xC157},
        {0x3B1D, 0xC161},
        {0x3B1E, 0xC165},
        {0x430E, 0xC175},
        {0x3B1F, 0xC176},
        {0x430F, 0xC177},
        {0x3B20, 0xC181},
        {0x3B21, 0xC185},
        {0x3B22, 0xC197},
        {0x3B23, 0xC1A1},
        {0x3B24, 0xC1A2},
        {0x3B25, 0xC1A5},
        {0x3B26, 0xC1A9},
        {0x3B27, 0xC1B1},
        {0x3B28, 0xC1B3},
        {0x3B29, 0xC1B5},
        {0x3B2A, 0xC1B7},
        {0x3B2B, 0xC1C1},
        {0x3B2C, 0xC1C5},
        {0x3B2D, 0xC1C9},
        {0x3B2E, 0xC1D7},
        {0x431B, 0xC1E1},
        {0x3B2F, 0xC241},
        {0x3B30, 0xC245},
        {0x3B31, 0xC249},
        {0x3B32, 0xC251},
        {0x3B33, 0xC253},
        {0x3B34, 0xC255},
        {0x3B35, 0xC257},
        {0x3B36, 0xC261},
        {0x3B37, 0xC271},
        {0x3B38, 0xC281},
        {0x3B39, 0xC282},
        {0x3B3A, 0xC285},
        {0x3B3B, 0xC289},
        {0x3B3C, 0xC291},
        {0x3B3D, 0xC293},
        {0x3B3E, 0xC295},
        {0x3B3F, 0xC297},
        {0x3B40, 0xC2A1},
        {0x432E, 0xC2B5},
        {0x3B41, 0xC2B6},
        {0x3B42, 0xC2C1},
        {0x3B43, 0xC2C5},
        {0x3B44, 0xC2E1},
        {0x3B45, 0xC2E5},
        {0x3B46, 0xC2E9},
        {0x3B47, 0xC2F1},
        {0x3B48, 0xC2F3},
        {0x3B49, 0xC2F5},
        {0x3B4A, 0xC2F7},
        {0x3B4B, 0xC341},
        {0x3B4C, 0xC345},
        {0x3B4D, 0xC349},
        {0x3B4E, 0xC351},
        {0x3B4F, 0xC357},
        {0x3B50, 0xC361},
        {0x3B51, 0xC362},
        {0x3B52, 0xC365},
        {0x3B53, 0xC369},
        {0x3B54, 0xC371},
        {0x3B55, 0xC373},
        {0x3B56, 0xC375},
        {0x3B57, 0xC377},
        {0x433F, 0xC381},
        {0x3B58, 0xC3A1},
        {0x3B59, 0xC3A2},
        {0x3B5A, 0xC3A5},
        {0x3B5B, 0xC3A8},
        {0x3B5C, 0xC3A9},
        {0x3B5D, 0xC3AA},
        {0x3B5E, 0xC3B1},
        {0x3B5F, 0xC3B3},
        {0x3B60, 0xC3B5},
        {0x3B61, 0xC3B7},
        {0x314B, 0xC441},
        {0x3B62, 0xC461},
        {0x3B63, 0xC462},
        {0x3B64, 0xC465},
        {0x434C, 0xC468},
        {0x3B65, 0xC469},
        {0x3B66, 0xC471},
        {0x3B67, 0xC473},
        {0x3B68, 0xC475},
        {0x3B69, 0xC477},
        {0x3B6A, 0xC481},
        {0x3B6B, 0xC482},
        {0x3B6C, 0xC485},
        {0x4350, 0xC488},
        {0x3B6D, 0xC489},
        {0x3B6E, 0xC491},
        {0x3B6F, 0xC493},
        {0x3B70, 0xC495},
        {0x3B71, 0xC496},
        {0x3B72, 0xC497},
        {0x4351, 0xC49B},
        {0x3B73, 0xC4A1},
        {0x3B74, 0xC4A2},
        {0x3B75, 0xC4B7},
        {0x4358, 0xC4C1},
        {0x3B76, 0xC4E1},
        {0x3B77, 0xC4E2},
        {0x3B78, 0xC4E5},
        {0x3B79, 0xC4E8},
        {0x3B7A, 0xC4E9},
        {0x3B7B, 0xC4F1},
        {0x3B7C, 0xC4F3},
        {0x3B7D, 0xC4F5},
        {0x3B7E, 0xC4F6},
        {0x3B7F, 0xC4F7},
        {0x435B, 0xC4FB},
        {0x3B80, 0xC541},
        {0x3B81, 0xC542},
        {0x3B82, 0xC545},
        {0x3B83, 0xC549},
        {0x3B84, 0xC551},
        {0x3B85, 0xC553},
        {0x3B86, 0xC555},
        {0x3B87, 0xC557},
        {0x435F, 0xC55B},
        {0x3B88, 0xC561},
        {0x3B89, 0xC565},
        {0x3B8A, 0xC569},
        {0x3B8B, 0xC571},
        {0x3B8C, 0xC573},
        {0x3B8D, 0xC575},
        {0x3B8E, 0xC576},
        {0x3B8F, 0xC577},
        {0x3B90, 0xC581},
        {0x3B91, 0xC5A1},
        {0x3B92, 0xC5A2},
        {0x3B93, 0xC5A5},
        {0x3B94, 0xC5A9},
        {0x3B95, 0xC5B1},
        {0x3B96, 0xC5B3},
        {0x3B97, 0xC5B5},
        {0x3B98, 0xC5B7},
        {0x3B99, 0xC5C1},
        {0x3B9A, 0xC5C2},
        {0x3B9B, 0xC5C5},
        {0x3B9C, 0xC5C9},
        {0x3B9D, 0xC5D1},
        {0x3B9E, 0xC5D7},
        {0x3B9F, 0xC5E1},
        {0x4370, 0xC5E2},
        {0x4371, 0xC5E5},
        {0x4376, 0xC5F5},
        {0x3BA0, 0xC5F7},
        {0x3BA1, 0xC641},
        {0x4378, 0xC645},
        {0x3BA2, 0xC649},
        {0x437C, 0xC657},
        {0x3BA3, 0xC661},
        {0x3BA4, 0xC681},
        {0x3BA5, 0xC682},
        {0x3BA6, 0xC685},
        {0x3BA7, 0xC689},
        {0x3BA8, 0xC691},
        {0x3BA9, 0xC693},
        {0x3BAA, 0xC695},
        {0x3BAB, 0xC697},
        {0x3BAC, 0xC6A1},
        {0x3BAD, 0xC6A5},
        {0x3BAE, 0xC6A9},
        {0x3BAF, 0xC6B7},
        {0x3BB0, 0xC6C1},
        {0x3BB1, 0xC6D7},
        {0x3BB2, 0xC6E1},
        {0x3BB3, 0xC6E2},
        {0x3BB4, 0xC6E5},
        {0x3BB5, 0xC6E9},
        {0x3BB6, 0xC6F1},
        {0x3BB7, 0xC6F3},
        {0x3BB8, 0xC6F5},
        {0x3BB9, 0xC6F7},
        {0x3BBA, 0xC741},
        {0x3BBB, 0xC745},
        {0x3BBC, 0xC749},
        {0x3BBD, 0xC751},
        {0x3BBE, 0xC761},
        {0x3BBF, 0xC762},
        {0x3BC0, 0xC765},
        {0x3BC1, 0xC769},
        {0x3BC2, 0xC771},
        {0x3BC3, 0xC773},
        {0x3BC4, 0xC777},
        {0x439B, 0xC781},
        {0x3BC5, 0xC7A1},
        {0x3BC6, 0xC7A2},
        {0x3BC7, 0xC7A5},
        {0x3BC8, 0xC7A9},
        {0x3BC9, 0xC7B1},
        {0x3BCA, 0xC7B3},
        {0x3BCB, 0xC7B5},
        {0x3BCC, 0xC7B7},
        {0x314C, 0xC841},
        {0x3BCD, 0xC861},
        {0x3BCE, 0xC862},
        {0x3BCF, 0xC865},
        {0x3BD0, 0xC869},
        {0x3BD1, 0xC86A},
        {0x3BD2, 0xC871},
        {0x3BD3, 0xC873},
        {0x3BD4, 0xC875},
        {0x3BD5, 0xC876},
        {0x3BD6, 0xC877},
        {0x3BD7, 0xC881},
        {0x3BD8, 0xC882},
        {0x3BD9, 0xC885},
        {0x3BDA, 0xC889},
        {0x3BDB, 0xC891},
        {0x3BDC, 0xC893},
        {0x3BDD, 0xC895},
        {0x3BDE, 0xC896},
        {0x3BDF, 0xC897},
        {0x3BE0, 0xC8A1},
        {0x3BE1, 0xC8B7},
        {0x43B4, 0xC8C1},
        {0x3BE2, 0xC8E1},
        {0x3BE3, 0xC8E2},
        {0x3BE4, 0xC8E5},
        {0x3BE5, 0xC8E9},
        {0x3BE6, 0xC8EB},
        {0x3BE7, 0xC8F1},
        {0x3BE8, 0xC8F3},
        {0x3BE9, 0xC8F5},
        {0x3BEA, 0xC8F6},
        {0x3BEB, 0xC8F7},
        {0x3BEC, 0xC941},
        {0x3BED, 0xC942},
        {0x3BEE, 0xC945},
        {0x3BEF, 0xC949},
        {0x3BF0, 0xC951},
        {0x3BF1, 0xC953},
        {0x3BF2, 0xC955},
        {0x43BB, 0xC956},
        {0x3BF3, 0xC957},
        {0x3BF4, 0xC961},
        {0x43BD, 0xC962},
        {0x3BF5, 0xC965},
        {0x3BF6, 0xC976},
        {0x3BF7, 0xC981},
        {0x3BF8, 0xC985},
        {0x3BF9, 0xC9A1},
        {0x3BFA, 0xC9A2},
        {0x3BFB, 0xC9A5},
        {0x3BFC, 0xC9A9},
        {0x3BFD, 0xC9B1},
        {0x3BFE, 0xC9B3},
        {0x3BFF, 0xC9B5},
        {0x3C00, 0xC9B7},
        {0x3C01, 0xC9BC},
        {0x3C02, 0xC9C1},
        {0x3C03, 0xC9C5},
        {0x3C04, 0xC9E1},
        {0x3C05, 0xCA41},
        {0x3C06, 0xCA45},
        {0x3C07, 0xCA55},
        {0x3C08, 0xCA57},
        {0x3C09, 0xCA61},
        {0x3C0A, 0xCA81},
        {0x3C0B, 0xCA82},
        {0x3C0C, 0xCA85},
        {0x3C0D, 0xCA89},
        {0x3C0E, 0xCA91},
        {0x3C0F, 0xCA93},
        {0x3C10, 0xCA95},
        {0x3C11, 0xCA97},
        {0x3C12, 0xCAA1},
        {0x3C13, 0xCAB6},
        {0x3C14, 0xCAC1},
        {0x43F3, 0xCAD5},
        {0x3C15, 0xCAE1},
        {0x3C16, 0xCAE2},
        {0x3C17, 0xCAE5},
        {0x3C18, 0xCAE9},
        {0x3C19, 0xCAF1},
        {0x3C1A, 0xCAF3},
        {0x43F7, 0xCAF5},
        {0x3C1B, 0xCAF7},
        {0x3C1C, 0xCB41},
        {0x3C1D, 0xCB45},
        {0x3C1E, 0xCB49},
        {0x3C1F, 0xCB51},
        {0x3C20, 0xCB57},
        {0x3C21, 0xCB61},
        {0x3C22, 0xCB62},
        {0x3C23, 0xCB65},
        {0x3C24, 0xCB68},
        {0x3C25, 0xCB69},
        {0x3C26, 0xCB6B},
        {0x3C27, 0xCB71},
        {0x3C28, 0xCB73},
        {0x3C29, 0xCB75},
        {0x43FE, 0xCB77},
        {0x3C2A, 0xCB81},
        {0x3C2B, 0xCB85},
        {0x3C2C, 0xCB89},
        {0x3C2D, 0xCB91},
        {0x3C2E, 0xCB93},
        {0x4401, 0xCB95},
        {0x3C2F, 0xCBA1},
        {0x3C30, 0xCBA2},
        {0x3C31, 0xCBA5},
        {0x3C32, 0xCBA9},
        {0x3C33, 0xCBB1},
        {0x3C34, 0xCBB3},
        {0x3C35, 0xCBB5},
        {0x3C36, 0xCBB7},
        {0x4405, 0xCBBC},
        {0x314D, 0xCC41},
        {0x3C37, 0xCC61},
        {0x3C38, 0xCC62},
        {0x3C39, 0xCC63},
        {0x3C3A, 0xCC65},
        {0x3C3B, 0xCC69},
        {0x3C3C, 0xCC6B},
        {0x3C3D, 0xCC71},
        {0x3C3E, 0xCC73},
        {0x3C3F, 0xCC75},
        {0x3C40, 0xCC76},
        {0x3C41, 0xCC77},
        {0x3C42, 0xCC7B},
        {0x4408, 0xCC7C},
        {0x3C43, 0xCC81},
        {0x3C44, 0xCC82},
        {0x3C45, 0xCC85},
        {0x3C46, 0xCC89},
        {0x3C47, 0xCC91},
        {0x3C48, 0xCC93},
        {0x3C49, 0xCC95},
        {0x3C4A, 0xCC96},
        {0x3C4B, 0xCC97},
        {0x3C4C, 0xCCA1},
        {0x3C4D, 0xCCA2},
        {0x4410, 0xCCB7},
        {0x4411, 0xCCC1},
        {0x3C4E, 0xCCE1},
        {0x3C4F, 0xCCE2},
        {0x3C50, 0xCCE5},
        {0x3C51, 0xCCE9},
        {0x3C52, 0xCCF1},
        {0x3C53, 0xCCF3},
        {0x3C54, 0xCCF5},
        {0x3C55, 0xCCF6},
        {0x3C56, 0xCCF7},
        {0x3C57, 0xCD41},
        {0x3C58, 0xCD42},
        {0x3C59, 0xCD45},
        {0x3C5A, 0xCD49},
        {0x3C5B, 0xCD51},
        {0x3C5C, 0xCD53},
        {0x3C5D, 0xCD55},
        {0x3C5E, 0xCD57},
        {0x4417, 0xCD5C},
        {0x3C5F, 0xCD61},
        {0x4418, 0xCD62},
        {0x3C60, 0xCD65},
        {0x3C61, 0xCD69},
        {0x3C62, 0xCD71},
        {0x3C63, 0xCD73},
        {0x441B, 0xCD75},
        {0x3C64, 0xCD76},
        {0x3C65, 0xCD77},
        {0x3C66, 0xCD81},
        {0x3C67, 0xCD89},
        {0x3C68, 0xCD93},
        {0x3C69, 0xCD95},
        {0x3C6A, 0xCDA1},
        {0x3C6B, 0xCDA2},
        {0x3C6C, 0xCDA5},
        {0x3C6D, 0xCDA9},
        {0x3C6E, 0xCDB1},
        {0x3C6F, 0xCDB3},
        {0x3C70, 0xCDB5},
        {0x3C71, 0xCDB7},
        {0x3C72, 0xCDC1},
        {0x3C73, 0xCDD7},
        {0x442C, 0xCDE1},
        {0x3C74, 0xCE41},
        {0x3C75, 0xCE45},
        {0x3C76, 0xCE61},
        {0x3C77, 0xCE65},
        {0x3C78, 0xCE69},
        {0x3C79, 0xCE73},
        {0x3C7A, 0xCE75},
        {0x3C7B, 0xCE81},
        {0x3C7C, 0xCE82},
        {0x3C7D, 0xCE85},
        {0x3C7E, 0xCE88},
        {0x3C7F, 0xCE89},
        {0x3C80, 0xCE8B},
        {0x3C81, 0xCE91},
        {0x3C82, 0xCE93},
        {0x3C83, 0xCE95},
        {0x3C84, 0xCE97},
        {0x3C85, 0xCEA1},
        {0x3C86, 0xCEB7},
        {0x443F, 0xCEC1},
        {0x3C87, 0xCEE1},
        {0x3C88, 0xCEE5},
        {0x3C89, 0xCEE9},
        {0x3C8A, 0xCEF1},
        {0x3C8B, 0xCEF5},
        {0x3C8C, 0xCF41},
        {0x444A, 0xCF42},
        {0x3C8D, 0xCF45},
        {0x3C8E, 0xCF49},
        {0x3C8F, 0xCF51},
        {0x3C90, 0xCF55},
        {0x3C91, 0xCF57},
        {0x3C92, 0xCF61},
        {0x444D, 0xCF62},
        {0x3C93, 0xCF65},
        {0x3C94, 0xCF69},
        {0x444F, 0xCF6D},
        {0x3C95, 0xCF71},
        {0x3C96, 0xCF73},
        {0x3C97, 0xCF75},
        {0x4450, 0xCF77},
        {0x4451, 0xCF81},
        {0x4453, 0xCF85},
        {0x3C98, 0xCFA1},
        {0x3C99, 0xCFA2},
        {0x3C9A, 0xCFA5},
        {0x3C9B, 0xCFA9},
        {0x3C9C, 0xCFB1},
        {0x3C9D, 0xCFB3},
        {0x3C9E, 0xCFB5},
        {0x3C9F, 0xCFB7},
        {0x314E, 0xD041},
        {0x3CA0, 0xD061},
        {0x3CA1, 0xD062},
        {0x3CA2, 0xD065},
        {0x445C, 0xD068},
        {0x3CA3, 0xD069},
        {0x445D, 0xD06A},
        {0x3CA4, 0xD06E},
        {0x3CA5, 0xD071},
        {0x3CA6, 0xD073},
        {0x3CA7, 0xD075},
        {0x4461, 0xD076},
        {0x3CA8, 0xD077},
        {0x4463, 0xD07B},
        {0x3CA9, 0xD081},
        {0x3CAA, 0xD082},
        {0x3CAB, 0xD085},
        {0x3CAC, 0xD089},
        {0x3CAD, 0xD091},
        {0x3CAE, 0xD093},
        {0x3CAF, 0xD095},
        {0x3CB0, 0xD096},
        {0x3CB1, 0xD097},
        {0x3CB2, 0xD0A1},
        {0x3CB3, 0xD0B7},
        {0x446D, 0xD0C1},
        {0x3CB4, 0xD0E1},
        {0x3CB5, 0xD0E2},
        {0x3CB6, 0xD0E5},
        {0x446F, 0xD0E8},
        {0x3CB7, 0xD0E9},
        {0x3CB8, 0xD0EB},
        {0x3CB9, 0xD0F1},
        {0x3CBA, 0xD0F3},
        {0x3CBB, 0xD0F5},
        {0x3CBC, 0xD0F7},
        {0x3CBD, 0xD141},
        {0x3CBE, 0xD142},
        {0x3CBF, 0xD145},
        {0x3CC0, 0xD149},
        {0x3CC1, 0xD151},
        {0x3CC2, 0xD153},
        {0x3CC3, 0xD155},
        {0x3CC4, 0xD157},
        {0x3CC5, 0xD161},
        {0x3CC6, 0xD162},
        {0x3CC7, 0xD165},
        {0x3CC8, 0xD169},
        {0x3CC9, 0xD171},
        {0x3CCA, 0xD173},
        {0x3CCB, 0xD175},
        {0x3CCC, 0xD176},
        {0x3CCD, 0xD177},
        {0x3CCE, 0xD181},
        {0x3CCF, 0xD185},
        {0x3CD0, 0xD189},
        {0x447A, 0xD191},
        {0x3CD1, 0xD193},
        {0x3CD2, 0xD1A1},
        {0x3CD3, 0xD1A2},
        {0x3CD4, 0xD1A5},
        {0x3CD5, 0xD1A9},
        {0x3CD6, 0xD1AE},
        {0x3CD7, 0xD1B1},
        {0x3CD8, 0xD1B3},
        {0x3CD9, 0xD1B5},
        {0x3CDA, 0xD1B7},
        {0x3CDB, 0xD1BB},
        {0x3CDC, 0xD1C1},
        {0x3CDD, 0xD1C2},
        {0x3CDE, 0xD1C5},
        {0x3CDF, 0xD1C9},
        {0x3CE0, 0xD1D5},
        {0x3CE1, 0xD1D7},
        {0x3CE2, 0xD1E1},
        {0x3CE3, 0xD1E2},
        {0x3CE4, 0xD1E5},
        {0x3CE5, 0xD1F5},
        {0x3CE6, 0xD1F7},
        {0x3CE7, 0xD241},
        {0x3CE8, 0xD242},
        {0x3CE9, 0xD245},
        {0x3CEA, 0xD249},
        {0x3CEB, 0xD253},
        {0x3CEC, 0xD255},
        {0x3CED, 0xD257},
        {0x3CEE, 0xD261},
        {0x4490, 0xD262},
        {0x3CEF, 0xD265},
        {0x3CF0, 0xD269},
        {0x4492, 0xD271},
        {0x3CF1, 0xD273},
        {0x3CF2, 0xD275},
        {0x3CF3, 0xD281},
        {0x3CF4, 0xD282},
        {0x3CF5, 0xD285},
        {0x3CF6, 0xD289},
        {0x3CF7, 0xD28E},
        {0x3CF8, 0xD291},
        {0x4499, 0xD293},
        {0x3CF9, 0xD295},
        {0x3CFA, 0xD297},
        {0x3CFB, 0xD2A1},
        {0x3CFC, 0xD2A5},
        {0x3CFD, 0xD2A9},
        {0x3CFE, 0xD2B1},
        {0x3CFF, 0xD2B7},
        {0x3D00, 0xD2C1},
        {0x3D01, 0xD2C2},
        {0x3D02, 0xD2C5},
        {0x3D03, 0xD2C9},
        {0x44A1, 0xD2D1},
        {0x3D04, 0xD2D7},
        {0x3D05, 0xD2E1},
        {0x3D06, 0xD2E2},
        {0x3D07, 0xD2E5},
        {0x3D08, 0xD2E9},
        {0x3D09, 0xD2F1},
        {0x3D0A, 0xD2F3},
        {0x3D0B, 0xD2F5},
        {0x3D0C, 0xD2F7},
        {0x3D0D, 0xD341},
        {0x3D0E, 0xD342},
        {0x3D0F, 0xD345},
        {0x3D10, 0xD349},
        {0x3D11, 0xD351},
        {0x3D12, 0xD355},
        {0x3D13, 0xD357},
        {0x3D14, 0xD361},
        {0x3D15, 0xD362},
        {0x3D16, 0xD365},
        {0x3D17, 0xD367},
        {0x3D18, 0xD368},
        {0x3D19, 0xD369},
        {0x3D1A, 0xD36A},
        {0x3D1B, 0xD371},
        {0x3D1C, 0xD373},
        {0x3D1D, 0xD375},
        {0x3D1E, 0xD377},
        {0x3D1F, 0xD37B},
        {0x3D20, 0xD381},
        {0x44B1, 0xD382},
        {0x3D21, 0xD385},
        {0x3D22, 0xD389},
        {0x3D23, 0xD391},
        {0x3D24, 0xD393},
        {0x3D25, 0xD397},
        {0x3D26, 0xD3A1},
        {0x3D27, 0xD3A2},
        {0x3D28, 0xD3A5},
        {0x3D29, 0xD3A9},
        {0x3D2A, 0xD3B1},
        {0x3D2B, 0xD3B3},
        {0x3D2C, 0xD3B5},
        {0x3D2D, 0xD3B7},
        {0xE000, 0xD441},
        {0xE001, 0xD442},
        {0xE002, 0xD443},
        {0xE003, 0xD444},
        {0xE004, 0xD445},
        {0xE005, 0xD446},
        {0xE006, 0xD447},
        {0xE007, 0xD448},
        {0xE008, 0xD449},
        {0xE009, 0xD44A},
        {0xE00A, 0xD44B},
        {0xE00B, 0xD44C},
        {0xE00C, 0xD44D},
        {0xE00D, 0xD44E},
        {0xE00E, 0xD44F},
        {0xE00F, 0xD450},
        {0xE010, 0xD451},
        {0xE011, 0xD452},
        {0xE012, 0xD453},
        {0xE013, 0xD454},
        {0xE014, 0xD455},
        {0xE015, 0xD456},
        {0xE016, 0xD457},
        {0xE017, 0xD458},
        {0xE018, 0xD459},
        {0xE019, 0xD45A},
        {0xE01A, 0xD45B},
        {0xE01B, 0xD45C},
        {0xE01C, 0xD45D},
        {0xE01D, 0xD45E},
        {0xE01E, 0xD45F},
        {0xE01F, 0xD460},
        {0xE020, 0xD461},
        {0xE021, 0xD462},
        {0xE022, 0xD463},
        {0xE023, 0xD464},
        {0xE024, 0xD465},
        {0xE025, 0xD466},
        {0xE026, 0xD467},
        {0xE027, 0xD468},
        {0xE028, 0xD469},
        {0xE029, 0xD46A},
        {0xE02A, 0xD46B},
        {0xE02B, 0xD46C},
        {0xE02C, 0xD46D},
        {0xE02D, 0xD46E},
        {0xE02E, 0xD46F},
        {0xE02F, 0xD470},
        {0xE030, 0xD471},
        {0xE031, 0xD472},
        {0xE032, 0xD473},
        {0xE033, 0xD474},
        {0xE034, 0xD475},
        {0xE035, 0xD476},
        {0xE036, 0xD477},
        {0xE037, 0xD478},
        {0xE038, 0xD479},
        {0xE039, 0xD47A},
        {0xE03A, 0xD47B},
        {0xE03B, 0xD47C},
        {0xE03C, 0xD47D},
        {0xE03D, 0xD47E},
        {0xE03E, 0xD47F},
        {0xE03F, 0xD481},
        {0xE040, 0xD482},
        {0xE041, 0xD483},
        {0xE042, 0xD484},
        {0xE043, 0xD485},
        {0xE044, 0xD486},
        {0xE045, 0xD487},
        {0xE046, 0xD488},
        {0xE047, 0xD489},
        {0xE048, 0xD48A},
        {0xE049, 0xD48B},
        {0xE04A, 0xD48C},
        {0xE04B, 0xD48D},
        {0xE04C, 0xD48E},
        {0xE04D, 0xD48F},
        {0xE04E, 0xD490},
        {0xE04F, 0xD491},
        {0xE050, 0xD492},
        {0xE051, 0xD493},
        {0xE052, 0xD494},
        {0xE053, 0xD495},
        {0xE054, 0xD496},
        {0xE055, 0xD497},
        {0xE056, 0xD498},
        {0xE057, 0xD499},
        {0xE058, 0xD49A},
        {0xE059, 0xD49B},
        {0xE05A, 0xD49C},
        {0xE05B, 0xD49D},
        {0xE05C, 0xD49E},
        {0xE05D, 0xD49F},
        {0xE05E, 0xD4A0},
        {0xE05F, 0xD4A1},
        {0xE060, 0xD4A2},
        {0xE061, 0xD4A3},
        {0xE062, 0xD4A4},
        {0xE063, 0xD4A5},
        {0xE064, 0xD4A6},
        {0xE065, 0xD4A7},
        {0xE066, 0xD4A8},
        {0xE067, 0xD4A9},
        {0xE068, 0xD4AA},
        {0xE069, 0xD4AB},
        {0xE06A, 0xD4AC},
        {0xE06B, 0xD4AD},
        {0xE06C, 0xD4AE},
        {0xE06D, 0xD4AF},
        {0xE06E, 0xD4B0},
        {0xE06F, 0xD4B1},
        {0xE070, 0xD4B2},
        {0xE071, 0xD4B3},
        {0xE072, 0xD4B4},
        {0xE073, 0xD4B5},
        {0xE074, 0xD4B6},
        {0xE075, 0xD4B7},
        {0xE076, 0xD4B8},
        {0xE077, 0xD4B9},
        {0xE078, 0xD4BA},
        {0xE079, 0xD4BB},
        {0xE07A, 0xD4BC},
        {0xE07B, 0xD4BD},
        {0xE07C, 0xD4BE},
        {0xE07D, 0xD4BF},
        {0xE07E, 0xD4C0},
        {0xE07F, 0xD4C1},
        {0xE080, 0xD4C2},
        {0xE081, 0xD4C3},
        {0xE082, 0xD4C4},
        {0xE083, 0xD4C5},
        {0xE084, 0xD4C6},
        {0xE085, 0xD4C7},
        {0xE086, 0xD4C8},
        {0xE087, 0xD4C9},
        {0xE088, 0xD4CA},
        {0xE089, 0xD4CB},
        {0xE08A, 0xD4CC},
        {0xE08B, 0xD4CD},
        {0xE08C, 0xD4CE},
        {0xE08D, 0xD4CF},
        {0xE08E, 0xD4D0},
        {0xE08F, 0xD4D1},
        {0xE090, 0xD4D2},
        {0xE091, 0xD4D3},
        {0xE092, 0xD4D4},
        {0xE093, 0xD4D5},
        {0xE094, 0xD4D6},
        {0xE095, 0xD4D7},
        {0xE096, 0xD4D8},
        {0xE097, 0xD4D9},
        {0xE098, 0xD4DA},
        {0xE099, 0xD4DB},
        {0xE09A, 0xD4DC},
        {0xE09B, 0xD4DD},
        {0xE09C, 0xD4DE},
        {0xE09D, 0xD4DF},
        {0xE09E, 0xD4E0},
        {0xE09F, 0xD4E1},
        {0xE0A0, 0xD4E2},
        {0xE0A1, 0xD4E3},
        {0xE0A2, 0xD4E4},
        {0xE0A3, 0xD4E5},
        {0xE0A4, 0xD4E6},
        {0xE0A5, 0xD4E7},
        {0xE0A6, 0xD4E8},
        {0xE0A7, 0xD4E9},
        {0xE0A8, 0xD4EA},
        {0xE0A9, 0xD4EB},
        {0xE0AA, 0xD4EC},
        {0xE0AB, 0xD4ED},
        {0xE0AC, 0xD4EE},
        {0xE0AD, 0xD4EF},
        {0xE0AE, 0xD4F0},
        {0xE0AF, 0xD4F1},
        {0xE0B0, 0xD4F2},
        {0xE0B1, 0xD4F3},
        {0xE0B2, 0xD4F4},
        {0xE0B3, 0xD4F5},
        {0xE0B4, 0xD4F6},
        {0xE0B5, 0xD4F7},
        {0xE0B6, 0xD4F8},
        {0xE0B7, 0xD4F9},
        {0xE0B8, 0xD4FA},
        {0xE0B9, 0xD4FB},
        {0xE0BA, 0xD4FC},
        {0xE0BB, 0xD4FD},
        {0xE0BC, 0xD541},
        {0xE0BD, 0xD542},
        {0xE0BE, 0xD543},
        {0xE0BF, 0xD544},
        {0xE0C0, 0xD545},
        {0xE0C1, 0xD546},
        {0xE0C2, 0xD547},
        {0xE0C3, 0xD548},
        {0xE0C4, 0xD549},
        {0xE0C5, 0xD54A},
        {0xE0C6, 0xD54B},
        {0xE0C7, 0xD54C},
        {0xE0C8, 0xD54D},
        {0xE0C9, 0xD54E},
        {0xE0CA, 0xD54F},
        {0xE0CB, 0xD550},
        {0xE0CC, 0xD551},
        {0xE0CD, 0xD552},
        {0xE0CE, 0xD553},
        {0xE0CF, 0xD554},
        {0xE0D0, 0xD555},
        {0xE0D1, 0xD556},
        {0xE0D2, 0xD557},
        {0xE0D3, 0xD558},
        {0xE0D4, 0xD559},
        {0xE0D5, 0xD55A},
        {0xE0D6, 0xD55B},
        {0xE0D7, 0xD55C},
        {0xE0D8, 0xD55D},
        {0xE0D9, 0xD55E},
        {0xE0DA, 0xD55F},
        {0xE0DB, 0xD560},
        {0xE0DC, 0xD561},
        {0xE0DD, 0xD562},
        {0xE0DE, 0xD563},
        {0xE0DF, 0xD564},
        {0xE0E0, 0xD565},
        {0xE0E1, 0xD566},
        {0xE0E2, 0xD567},
        {0xE0E3, 0xD568},
        {0xE0E4, 0xD569},
        {0xE0E5, 0xD56A},
        {0xE0E6, 0xD56B},
        {0xE0E7, 0xD56C},
        {0xE0E8, 0xD56D},
        {0xE0E9, 0xD56E},
        {0xE0EA, 0xD56F},
        {0xE0EB, 0xD570},
        {0xE0EC, 0xD571},
        {0xE0ED, 0xD572},
        {0xE0EE, 0xD573},
        {0xE0EF, 0xD574},
        {0xE0F0, 0xD575},
        {0xE0F1, 0xD576},
        {0xE0F2, 0xD577},
        {0xE0F3, 0xD578},
        {0xE0F4, 0xD579},
        {0xE0F5, 0xD57A},
        {0xE0F6, 0xD57B},
        {0xE0F7, 0xD57C},
        {0xE0F8, 0xD57D},
        {0xE0F9, 0xD57E},
        {0xE0FA, 0xD57F},
        {0xE0FB, 0xD581},
        {0xE0FC, 0xD582},
        {0xE0FD, 0xD583},
        {0xE0FE, 0xD584},
        {0xE0FF, 0xD585},
        {0xE100, 0xD586},
        {0xE101, 0xD587},
        {0xE102, 0xD588},
        {0xE103, 0xD589},
        {0xE104, 0xD58A},
        {0xE105, 0xD58B},
        {0xE106, 0xD58C},
        {0xE107, 0xD58D},
        {0xE108, 0xD58E},
        {0xE109, 0xD58F},
        {0xE10A, 0xD590},
        {0xE10B, 0xD591},
        {0xE10C, 0xD592},
        {0xE10D, 0xD593},
        {0xE10E, 0xD594},
        {0xE10F, 0xD595},
        {0xE110, 0xD596},
        {0xE111, 0xD597},
        {0xE112, 0xD598},
        {0xE113, 0xD599},
        {0xE114, 0xD59A},
        {0xE115, 0xD59B},
        {0xE116, 0xD59C},
        {0xE117, 0xD59D},
        {0xE118, 0xD59E},
        {0xE119, 0xD59F},
        {0xE11A, 0xD5A0},
        {0xE11B, 0xD5A1},
        {0xE11C, 0xD5A2},
        {0xE11D, 0xD5A3},
        {0xE11E, 0xD5A4},
        {0xE11F, 0xD5A5},
        {0xE120, 0xD5A6},
        {0xE121, 0xD5A7},
        {0xE122, 0xD5A8},
        {0xE123, 0xD5A9},
        {0xE124, 0xD5AA},
        {0xE125, 0xD5AB},
        {0xE126, 0xD5AC},
        {0xE127, 0xD5AD},
        {0xE128, 0xD5AE},
        {0xE129, 0xD5AF},
        {0xE12A, 0xD5B0},
        {0xE12B, 0xD5B1},
        {0xE12C, 0xD5B2},
        {0xE12D, 0xD5B3},
        {0xE12E, 0xD5B4},
        {0xE12F, 0xD5B5},
        {0xE130, 0xD5B6},
        {0xE131, 0xD5B7},
        {0xE132, 0xD5B8},
        {0xE133, 0xD5B9},
        {0xE134, 0xD5BA},
        {0xE135, 0xD5BB},
        {0xE136, 0xD5BC},
        {0xE137, 0xD5BD},
        {0xE138, 0xD5BE},
        {0xE139, 0xD5BF},
        {0xE13A, 0xD5C0},
        {0xE13B, 0xD5C1},
        {0xE13C, 0xD5C2},
        {0xE13D, 0xD5C3},
        {0xE13E, 0xD5C4},
        {0xE13F, 0xD5C5},
        {0xE140, 0xD5C6},
        {0xE141, 0xD5C7},
        {0xE142, 0xD5C8},
        {0xE143, 0xD5C9},
        {0xE144, 0xD5CA},
        {0xE145, 0xD5CB},
        {0xE146, 0xD5CC},
        {0xE147, 0xD5CD},
        {0xE148, 0xD5CE},
        {0xE149, 0xD5CF},
        {0xE14A, 0xD5D0},
        {0xE14B, 0xD5D1},
        {0xE14C, 0xD5D2},
        {0xE14D, 0xD5D3},
        {0xE14E, 0xD5D4},
        {0xE14F, 0xD5D5},
        {0xE150, 0xD5D6},
        {0xE151, 0xD5D7},
        {0xE152, 0xD5D8},
        {0xE153, 0xD5D9},
        {0xE154, 0xD5DA},
        {0xE155, 0xD5DB},
        {0xE156, 0xD5DC},
        {0xE157, 0xD5DD},
        {0xE158, 0xD5DE},
        {0xE159, 0xD5DF},
        {0xE15A, 0xD5E0},
        {0xE15B, 0xD5E1},
        {0xE15C, 0xD5E2},
        {0xE15D, 0xD5E3},
        {0xE15E, 0xD5E4},
        {0xE15F, 0xD5E5},
        {0xE160, 0xD5E6},
        {0xE161, 0xD5E7},
        {0xE162, 0xD5E8},
        {0xE163, 0xD5E9},
        {0xE164, 0xD5EA},
        {0xE165, 0xD5EB},
        {0xE166, 0xD5EC},
        {0xE167, 0xD5ED},
        {0xE168, 0xD5EE},
        {0xE169, 0xD5EF},
        {0xE16A, 0xD5F0},
        {0xE16B, 0xD5F1},
        {0xE16C, 0xD5F2},
        {0xE16D, 0xD5F3},
        {0xE16E, 0xD5F4},
        {0xE16F, 0xD5F5},
        {0xE170, 0xD5F6},
        {0xE171, 0xD5F7},
        {0xE172, 0xD5F8},
        {0xE173, 0xD5F9},
        {0xE174, 0xD5FA},
        {0xE175, 0xD5FB},
        {0xE176, 0xD5FC},
        {0xE177, 0xD5FD},
        {0xE178, 0xD641},
        {0xE179, 0xD642},
        {0xE17A, 0xD643},
        {0xE17B, 0xD644},
        {0xE17C, 0xD645},
        {0xE17D, 0xD646},
        {0xE17E, 0xD647},
        {0xE17F, 0xD648},
        {0xE180, 0xD649},
        {0xE181, 0xD64A},
        {0xE182, 0xD64B},
        {0xE183, 0xD64C},
        {0xE184, 0xD64D},
        {0xE185, 0xD64E},
        {0xE186, 0xD64F},
        {0xE187, 0xD650},
        {0xE188, 0xD651},
        {0xE189, 0xD652},
        {0xE18A, 0xD653},
        {0xE18B, 0xD654},
        {0xE18C, 0xD655},
        {0xE18D, 0xD656},
        {0xE18E, 0xD657},
        {0xE18F, 0xD658},
        {0xE190, 0xD659},
        {0xE191, 0xD65A},
        {0xE192, 0xD65B},
        {0xE193, 0xD65C},
        {0xE194, 0xD65D},
        {0xE195, 0xD65E},
        {0xE196, 0xD65F},
        {0xE197, 0xD660},
        {0xE198, 0xD661},
        {0xE199, 0xD662},
        {0xE19A, 0xD663},
        {0xE19B, 0xD664},
        {0xE19C, 0xD665},
        {0xE19D, 0xD666},
        {0xE19E, 0xD667},
        {0xE19F, 0xD668},
        {0xE1A0, 0xD669},
        {0xE1A1, 0xD66A},
        {0xE1A2, 0xD66B},
        {0xE1A3, 0xD66C},
        {0xE1A4, 0xD66D},
        {0xE1A5, 0xD66E},
        {0xE1A6, 0xD66F},
        {0xE1A7, 0xD670},
        {0xE1A8, 0xD671},
        {0xE1A9, 0xD672},
        {0xE1AA, 0xD673},
        {0xE1AB, 0xD674},
        {0xE1AC, 0xD675},
        {0xE1AD, 0xD676},
        {0xE1AE, 0xD677},
        {0xE1AF, 0xD678},
        {0xE1B0, 0xD679},
        {0xE1B1, 0xD67A},
        {0xE1B2, 0xD67B},
        {0xE1B3, 0xD67C},
        {0xE1B4, 0xD67D},
        {0xE1B5, 0xD67E},
        {0xE1B6, 0xD67F},
        {0xE1B7, 0xD681},
        {0xE1B8, 0xD682},
        {0xE1B9, 0xD683},
        {0xE1BA, 0xD684},
        {0xE1BB, 0xD685},
        {0xE1BC, 0xD686},
        {0xE1BD, 0xD687},
        {0xE1BE, 0xD688},
        {0xE1BF, 0xD689},
        {0xE1C0, 0xD68A},
        {0xE1C1, 0xD68B},
        {0xE1C2, 0xD68C},
        {0xE1C3, 0xD68D},
        {0xE1C4, 0xD68E},
        {0xE1C5, 0xD68F},
        {0xE1C6, 0xD690},
        {0xE1C7, 0xD691},
        {0xE1C8, 0xD692},
        {0xE1C9, 0xD693},
        {0xE1CA, 0xD694},
        {0xE1CB, 0xD695},
        {0xE1CC, 0xD696},
        {0xE1CD, 0xD697},
        {0xE1CE, 0xD698},
        {0xE1CF, 0xD699},
        {0xE1D0, 0xD69A},
        {0xE1D1, 0xD69B},
        {0xE1D2, 0xD69C},
        {0xE1D3, 0xD69D},
        {0xE1D4, 0xD69E},
        {0xE1D5, 0xD69F},
        {0xE1D6, 0xD6A0},
        {0xE1D7, 0xD6A1},
        {0xE1D8, 0xD6A2},
        {0xE1D9, 0xD6A3},
        {0xE1DA, 0xD6A4},
        {0xE1DB, 0xD6A5},
        {0xE1DC, 0xD6A6},
        {0xE1DD, 0xD6A7},
        {0xE1DE, 0xD6A8},
        {0xE1DF, 0xD6A9},
        {0xE1E0, 0xD6AA},
        {0xE1E1, 0xD6AB},
        {0xE1E2, 0xD6AC},
        {0xE1E3, 0xD6AD},
        {0xE1E4, 0xD6AE},
        {0xE1E5, 0xD6AF},
        {0xE1E6, 0xD6B0},
        {0xE1E7, 0xD6B1},
        {0xE1E8, 0xD6B2},
        {0xE1E9, 0xD6B3},
        {0xE1EA, 0xD6B4},
        {0xE1EB, 0xD6B5},
        {0xE1EC, 0xD6B6},
        {0xE1ED, 0xD6B7},
        {0xE1EE, 0xD6B8},
        {0xE1EF, 0xD6B9},
        {0xE1F0, 0xD6BA},
        {0xE1F1, 0xD6BB},
        {0xE1F2, 0xD6BC},
        {0xE1F3, 0xD6BD},
        {0xE1F4, 0xD6BE},
        {0xE1F5, 0xD6BF},
        {0xE1F6, 0xD6C0},
        {0xE1F7, 0xD6C1},
        {0xE1F8, 0xD6C2},
        {0xE1F9, 0xD6C3},
        {0xE1FA, 0xD6C4},
        {0xE1FB, 0xD6C5},
        {0xE1FC, 0xD6C6},
        {0xE1FD, 0xD6C7},
        {0xE1FE, 0xD6C8},
        {0xE1FF, 0xD6C9},
        {0xE200, 0xD6CA},
        {0xE201, 0xD6CB},
        {0xE202, 0xD6CC},
        {0xE203, 0xD6CD},
        {0xE204, 0xD6CE},
        {0xE205, 0xD6CF},
        {0xE206, 0xD6D0},
        {0xE207, 0xD6D1},
        {0xE208, 0xD6D2},
        {0xE209, 0xD6D3},
        {0xE20A, 0xD6D4},
        {0xE20B, 0xD6D5},
        {0xE20C, 0xD6D6},
        {0xE20D, 0xD6D7},
        {0xE20E, 0xD6D8},
        {0xE20F, 0xD6D9},
        {0xE210, 0xD6DA},
        {0xE211, 0xD6DB},
        {0xE212, 0xD6DC},
        {0xE213, 0xD6DD},
        {0xE214, 0xD6DE},
        {0xE215, 0xD6DF},
        {0xE216, 0xD6E0},
        {0xE217, 0xD6E1},
        {0xE218, 0xD6E2},
        {0xE219, 0xD6E3},
        {0xE21A, 0xD6E4},
        {0xE21B, 0xD6E5},
        {0xE21C, 0xD6E6},
        {0xE21D, 0xD6E7},
        {0xE21E, 0xD6E8},
        {0xE21F, 0xD6E9},
        {0xE220, 0xD6EA},
        {0xE221, 0xD6EB},
        {0xE222, 0xD6EC},
        {0xE223, 0xD6ED},
        {0xE224, 0xD6EE},
        {0xE225, 0xD6EF},
        {0xE226, 0xD6F0},
        {0xE227, 0xD6F1},
        {0xE228, 0xD6F2},
        {0xE229, 0xD6F3},
        {0xE22A, 0xD6F4},
        {0xE22B, 0xD6F5},
        {0xE22C, 0xD6F6},
        {0xE22D, 0xD6F7},
        {0xE22E, 0xD6F8},
        {0xE22F, 0xD6F9},
        {0xE230, 0xD6FA},
        {0xE231, 0xD6FB},
        {0xE232, 0xD6FC},
        {0xE233, 0xD6FD},
        {0xE234, 0xD741},
        {0xE235, 0xD742},
        {0xE236, 0xD743},
        {0xE237, 0xD744},
        {0xE238, 0xD745},
        {0xE239, 0xD746},
        {0xE23A, 0xD747},
        {0xE23B, 0xD748},
        {0xE23C, 0xD749},
        {0xE23D, 0xD74A},
        {0xE23E, 0xD74B},
        {0xE23F, 0xD74C},
        {0xE240, 0xD74D},
        {0xE241, 0xD74E},
        {0xE242, 0xD74F},
        {0xE243, 0xD750},
        {0xE244, 0xD751},
        {0xE245, 0xD752},
        {0xE246, 0xD753},
        {0xE247, 0xD754},
        {0xE248, 0xD755},
        {0xE249, 0xD756},
        {0xE24A, 0xD757},
        {0xE24B, 0xD758},
        {0xE24C, 0xD759},
        {0xE24D, 0xD75A},
        {0xE24E, 0xD75B},
        {0xE24F, 0xD75C},
        {0xE250, 0xD75D},
        {0xE251, 0xD75E},
        {0xE252, 0xD75F},
        {0xE253, 0xD760},
        {0xE254, 0xD761},
        {0xE255, 0xD762},
        {0xE256, 0xD763},
        {0xE257, 0xD764},
        {0xE258, 0xD765},
        {0xE259, 0xD766},
        {0xE25A, 0xD767},
        {0xE25B, 0xD768},
        {0xE25C, 0xD769},
        {0xE25D, 0xD76A},
        {0xE25E, 0xD76B},
        {0xE25F, 0xD76C},
        {0xE260, 0xD76D},
        {0xE261, 0xD76E},
        {0xE262, 0xD76F},
        {0xE263, 0xD770},
        {0xE264, 0xD771},
        {0xE265, 0xD772},
        {0xE266, 0xD773},
        {0xE267, 0xD774},
        {0xE268, 0xD775},
        {0xE269, 0xD776},
        {0xE26A, 0xD777},
        {0xE26B, 0xD778},
        {0xE26C, 0xD779},
        {0xE26D, 0xD77A},
        {0xE26E, 0xD77B},
        {0xE26F, 0xD77C},
        {0xE270, 0xD77D},
        {0xE271, 0xD77E},
        {0xE272, 0xD77F},
        {0xE273, 0xD781},
        {0xE274, 0xD782},
        {0xE275, 0xD783},
        {0xE276, 0xD784},
        {0xE277, 0xD785},
        {0xE278, 0xD786},
        {0xE279, 0xD787},
        {0xE27A, 0xD788},
        {0xE27B, 0xD789},
        {0xE27C, 0xD78A},
        {0xE27D, 0xD78B},
        {0xE27E, 0xD78C},
        {0xE27F, 0xD78D},
        {0xE280, 0xD78E},
        {0xE281, 0xD78F},
        {0xE282, 0xD790},
        {0xE283, 0xD791},
        {0xE284, 0xD792},
        {0xE285, 0xD793},
        {0xE286, 0xD794},
        {0xE287, 0xD795},
        {0xE288, 0xD796},
        {0xE289, 0xD797},
        {0xE28A, 0xD798},
        {0xE28B, 0xD799},
        {0xE28C, 0xD79A},
        {0xE28D, 0xD79B},
        {0xE28E, 0xD79C},
        {0xE28F, 0xD79D},
        {0xE290, 0xD79E},
        {0xE291, 0xD79F},
        {0xE292, 0xD7A0},
        {0xE293, 0xD7A1},
        {0xE294, 0xD7A2},
        {0xE295, 0xD7A3},
        {0xE296, 0xD7A4},
        {0xE297, 0xD7A5},
        {0xE298, 0xD7A6},
        {0xE299, 0xD7A7},
        {0xE29A, 0xD7A8},
        {0xE29B, 0xD7A9},
        {0xE29C, 0xD7AA},
        {0xE29D, 0xD7AB},
        {0xE29E, 0xD7AC},
        {0xE29F, 0xD7AD},
        {0xE2A0, 0xD7AE},
        {0xE2A1, 0xD7AF},
        {0xE2A2, 0xD7B0},
        {0xE2A3, 0xD7B1},
        {0xE2A4, 0xD7B2},
        {0xE2A5, 0xD7B3},
        {0xE2A6, 0xD7B4},
        {0xE2A7, 0xD7B5},
        {0xE2A8, 0xD7B6},
        {0xE2A9, 0xD7B7},
        {0xE2AA, 0xD7B8},
        {0xE2AB, 0xD7B9},
        {0xE2AC, 0xD7BA},
        {0xE2AD, 0xD7BB},
        {0xE2AE, 0xD7BC},
        {0xE2AF, 0xD7BD},
        {0xE2B0, 0xD7BE},
        {0xE2B1, 0xD7BF},
        {0xE2B2, 0xD7C0},
        {0xE2B3, 0xD7C1},
        {0xE2B4, 0xD7C2},
        {0xE2B5, 0xD7C3},
        {0xE2B6, 0xD7C4},
        {0xE2B7, 0xD7C5},
        {0xE2B8, 0xD7C6},
        {0xE2B9, 0xD7C7},
        {0xE2BA, 0xD7C8},
        {0xE2BB, 0xD7C9},
        {0xE2BC, 0xD7CA},
        {0xE2BD, 0xD7CB},
        {0xE2BE, 0xD7CC},
        {0xE2BF, 0xD7CD},
        {0xE2C0, 0xD7CE},
        {0xE2C1, 0xD7CF},
        {0xE2C2, 0xD7D0},
        {0xE2C3, 0xD7D1},
        {0xE2C4, 0xD7D2},
        {0xE2C5, 0xD7D3},
        {0xE2C6, 0xD7D4},
        {0xE2C7, 0xD7D5},
        {0xE2C8, 0xD7D6},
        {0xE2C9, 0xD7D7},
        {0xE2CA, 0xD7D8},
        {0xE2CB, 0xD7D9},
        {0xE2CC, 0xD7DA},
        {0xE2CD, 0xD7DB},
        {0xE2CE, 0xD7DC},
        {0xE2CF, 0xD7DD},
        {0xE2D0, 0xD7DE},
        {0xE2D1, 0xD7DF},
        {0xE2D2, 0xD7E0},
        {0xE2D3, 0xD7E1},
        {0xE2D4, 0xD7E2},
        {0xE2D5, 0xD7E3},
        {0xE2D6, 0xD7E4},
        {0xE2D7, 0xD7E5},
        {0xE2D8, 0xD7E6},
        {0xE2D9, 0xD7E7},
        {0xE2DA, 0xD7E8},
        {0xE2DB, 0xD7E9},
        {0xE2DC, 0xD7EA},
        {0xE2DD, 0xD7EB},
        {0xE2DE, 0xD7EC},
        {0xE2DF, 0xD7ED},
        {0xE2E0, 0xD7EE},
        {0xE2E1, 0xD7EF},
        {0xE2E2, 0xD7F0},
        {0xE2E3, 0xD7F1},
        {0xE2E4, 0xD7F2},
        {0xE2E5, 0xD7F3},
        {0xE2E6, 0xD7F4},
        {0xE2E7, 0xD7F5},
        {0xE2E8, 0xD7F6},
        {0xE2E9, 0xD7F7},
        {0xE2EA, 0xD7F8},
        {0xE2EB, 0xD7F9},
        {0xE2EC, 0xD7FA},
        {0xE2ED, 0xD7FB},
        {0xE2EE, 0xD7FC},
        {0xE2EF, 0xD7FD},
        {0xE2F0, 0xD841},
        {0xE2F1, 0xD842},
        {0xE2F2, 0xD843},
        {0xE2F3, 0xD844},
        {0xE2F4, 0xD845},
        {0xE2F5, 0xD846},
        {0xE2F6, 0xD847},
        {0xE2F7, 0xD848},
        {0xE2F8, 0xD849},
        {0xE2F9, 0xD84A},
        {0xE2FA, 0xD84B},
        {0xE2FB, 0xD84C},
        {0xE2FC, 0xD84D},
        {0xE2FD, 0xD84E},
        {0xE2FE, 0xD84F},
        {0xE2FF, 0xD850},
        {0xE300, 0xD851},
        {0xE301, 0xD852},
        {0xE302, 0xD853},
        {0xE303, 0xD854},
        {0xE304, 0xD855},
        {0xE305, 0xD856},
        {0xE306, 0xD857},
        {0xE307, 0xD858},
        {0xE308, 0xD859},
        {0xE309, 0xD85A},
        {0xE30A, 0xD85B},
        {0xE30B, 0xD85C},
        {0xE30C, 0xD85D},
        {0xE30D, 0xD85E},
        {0xE30E, 0xD85F},
        {0xE30F, 0xD860},
        {0xE310, 0xD861},
        {0xE311, 0xD862},
        {0xE312, 0xD863},
        {0xE313, 0xD864},
        {0xE314, 0xD865},
        {0xE315, 0xD866},
        {0xE316, 0xD867},
        {0xE317, 0xD868},
        {0xE318, 0xD869},
        {0xE319, 0xD86A},
        {0xE31A, 0xD86B},
        {0xE31B, 0xD86C},
        {0xE31C, 0xD86D},
        {0xE31D, 0xD86E},
        {0xE31E, 0xD86F},
        {0xE31F, 0xD870},
        {0xE320, 0xD871},
        {0xE321, 0xD872},
        {0xE322, 0xD873},
        {0xE323, 0xD874},
        {0xE324, 0xD875},
        {0xE325, 0xD876},
        {0xE326, 0xD877},
        {0xE327, 0xD878},
        {0xE328, 0xD879},
        {0xE329, 0xD87A},
        {0xE32A, 0xD87B},
        {0xE32B, 0xD87C},
        {0xE32C, 0xD87D},
        {0xE32D, 0xD87E},
        {0xE32E, 0xD87F},
        {0xE32F, 0xD881},
        {0xE330, 0xD882},
        {0xE331, 0xD883},
        {0xE332, 0xD884},
        {0xE333, 0xD885},
        {0xE334, 0xD886},
        {0xE335, 0xD887},
        {0xE336, 0xD888},
        {0xE337, 0xD889},
        {0xE338, 0xD88A},
        {0xE339, 0xD88B},
        {0xE33A, 0xD88C},
        {0xE33B, 0xD88D},
        {0xE33C, 0xD88E},
        {0xE33D, 0xD88F},
        {0xE33E, 0xD890},
        {0xE33F, 0xD891},
        {0xE340, 0xD892},
        {0xE341, 0xD893},
        {0xE342, 0xD894},
        {0xE343, 0xD895},
        {0xE344, 0xD896},
        {0xE345, 0xD897},
        {0xE346, 0xD898},
        {0xE347, 0xD899},
        {0xE348, 0xD89A},
        {0xE349, 0xD89B},
        {0xE34A, 0xD89C},
        {0xE34B, 0xD89D},
        {0xE34C, 0xD89E},
        {0xE34D, 0xD89F},
        {0xE34E, 0xD8A0},
        {0xE34F, 0xD8A1},
        {0xE350, 0xD8A2},
        {0xE351, 0xD8A3},
        {0xE352, 0xD8A4},
        {0xE353, 0xD8A5},
        {0xE354, 0xD8A6},
        {0xE355, 0xD8A7},
        {0xE356, 0xD8A8},
        {0xE357, 0xD8A9},
        {0xE358, 0xD8AA},
        {0xE359, 0xD8AB},
        {0xE35A, 0xD8AC},
        {0xE35B, 0xD8AD},
        {0xE35C, 0xD8AE},
        {0xE35D, 0xD8AF},
        {0xE35E, 0xD8B0},
        {0xE35F, 0xD8B1},
        {0xE360, 0xD8B2},
        {0xE361, 0xD8B3},
        {0xE362, 0xD8B4},
        {0xE363, 0xD8B5},
        {0xE364, 0xD8B6},
        {0xE365, 0xD8B7},
        {0xE366, 0xD8B8},
        {0xE367, 0xD8B9},
        {0xE368, 0xD8BA},
        {0xE369, 0xD8BB},
        {0xE36A, 0xD8BC},
        {0xE36B, 0xD8BD},
        {0xE36C, 0xD8BE},
        {0xE36D, 0xD8BF},
        {0xE36E, 0xD8C0},
        {0xE36F, 0xD8C1},
        {0xE370, 0xD8C2},
        {0xE371, 0xD8C3},
        {0xE372, 0xD8C4},
        {0xE373, 0xD8C5},
        {0xE374, 0xD8C6},
        {0xE375, 0xD8C7},
        {0xE376, 0xD8C8},
        {0xE377, 0xD8C9},
        {0xE378, 0xD8CA},
        {0xE379, 0xD8CB},
        {0xE37A, 0xD8CC},
        {0xE37B, 0xD8CD},
        {0xE37C, 0xD8CE},
        {0xE37D, 0xD8CF},
        {0xE37E, 0xD8D0},
        {0xE37F, 0xD8D1},
        {0xE380, 0xD8D2},
        {0xE381, 0xD8D3},
        {0xE382, 0xD8D4},
        {0xE383, 0xD8D5},
        {0xE384, 0xD8D6},
        {0xE385, 0xD8D7},
        {0xE386, 0xD8D8},
        {0xE387, 0xD8D9},
        {0xE388, 0xD8DA},
        {0xE389, 0xD8DB},
        {0xE38A, 0xD8DC},
        {0xE38B, 0xD8DD},
        {0xE38C, 0xD8DE},
        {0xE38D, 0xD8DF},
        {0xE38E, 0xD8E0},
        {0xE38F, 0xD8E1},
        {0xE390, 0xD8E2},
        {0xE391, 0xD8E3},
        {0xE392, 0xD8E4},
        {0xE393, 0xD8E5},
        {0xE394, 0xD8E6},
        {0xE395, 0xD8E7},
        {0xE396, 0xD8E8},
        {0xE397, 0xD8E9},
        {0xE398, 0xD8EA},
        {0xE399, 0xD8EB},
        {0xE39A, 0xD8EC},
        {0xE39B, 0xD8ED},
        {0xE39C, 0xD8EE},
        {0xE39D, 0xD8EF},
        {0xE39E, 0xD8F0},
        {0xE39F, 0xD8F1},
        {0xE3A0, 0xD8F2},
        {0xE3A1, 0xD8F3},
        {0xE3A2, 0xD8F4},
        {0xE3A3, 0xD8F5},
        {0xE3A4, 0xD8F6},
        {0xE3A5, 0xD8F7},
        {0xE3A6, 0xD8F8},
        {0xE3A7, 0xD8F9},
        {0xE3A8, 0xD8FA},
        {0xE3A9, 0xD8FB},
        {0xE3AA, 0xD8FC},
        {0xE3AB, 0xD8FD},
        {0xE3AC, 0xD941},
        {0xE3AD, 0xD942},
        {0xE3AE, 0xD943},
        {0xE3AF, 0xD944},
        {0xE3B0, 0xD945},
        {0xE3B1, 0xD946},
        {0xE3B2, 0xD947},
        {0xE3B3, 0xD948},
        {0xE3B4, 0xD949},
        {0xE3B5, 0xD94A},
        {0xE3B6, 0xD94B},
        {0xE3B7, 0xD94C},
        {0xE3B8, 0xD94D},
        {0xE3B9, 0xD94E},
        {0xE3BA, 0xD94F},
        {0xE3BB, 0xD950},
        {0xE3BC, 0xD951},
        {0xE3BD, 0xD952},
        {0xE3BE, 0xD953},
        {0xE3BF, 0xD954},
        {0xE3C0, 0xD955},
        {0xE3C1, 0xD956},
        {0xE3C2, 0xD957},
        {0xE3C3, 0xD958},
        {0xE3C4, 0xD959},
        {0xE3C5, 0xD95A},
        {0xE3C6, 0xD95B},
        {0xE3C7, 0xD95C},
        {0xE3C8, 0xD95D},
        {0xE3C9, 0xD95E},
        {0xE3CA, 0xD95F},
        {0xE3CB, 0xD960},
        {0xE3CC, 0xD961},
        {0xE3CD, 0xD962},
        {0xE3CE, 0xD963},
        {0xE3CF, 0xD964},
        {0xE3D0, 0xD965},
        {0xE3D1, 0xD966},
        {0xE3D2, 0xD967},
        {0xE3D3, 0xD968},
        {0xE3D4, 0xD969},
        {0xE3D5, 0xD96A},
        {0xE3D6, 0xD96B},
        {0xE3D7, 0xD96C},
        {0xE3D8, 0xD96D},
        {0xE3D9, 0xD96E},
        {0xE3DA, 0xD96F},
        {0xE3DB, 0xD970},
        {0xE3DC, 0xD971},
        {0xE3DD, 0xD972},
        {0xE3DE, 0xD973},
        {0xE3DF, 0xD974},
        {0xE3E0, 0xD975},
        {0xE3E1, 0xD976},
        {0xE3E2, 0xD977},
        {0xE3E3, 0xD978},
        {0xE3E4, 0xD979},
        {0xE3E5, 0xD97A},
        {0xE3E6, 0xD97B},
        {0xE3E7, 0xD97C},
        {0xE3E8, 0xD97D},
        {0xE3E9, 0xD97E},
        {0xE3EA, 0xD97F},
        {0xE3EB, 0xD981},
        {0xE3EC, 0xD982},
        {0xE3ED, 0xD983},
        {0xE3EE, 0xD984},
        {0xE3EF, 0xD985},
        {0xE3F0, 0xD986},
        {0xE3F1, 0xD987},
        {0xE3F2, 0xD988},
        {0xE3F3, 0xD989},
        {0xE3F4, 0xD98A},
        {0xE3F5, 0xD98B},
        {0xE3F6, 0xD98C},
        {0xE3F7, 0xD98D},
        {0xE3F8, 0xD98E},
        {0xE3F9, 0xD98F},
        {0xE3FA, 0xD990},
        {0xE3FB, 0xD991},
        {0xE3FC, 0xD992},
        {0xE3FD, 0xD993},
        {0xE3FE, 0xD994},
        {0xE3FF, 0xD995},
        {0xE400, 0xD996},
        {0xE401, 0xD997},
        {0xE402, 0xD998},
        {0xE403, 0xD999},
        {0xE404, 0xD99A},
        {0xE405, 0xD99B},
        {0xE406, 0xD99C},
        {0xE407, 0xD99D},
        {0xE408, 0xD99E},
        {0xE409, 0xD99F},
        {0xE40A, 0xD9A0},
        {0xE40B, 0xD9A1},
        {0xE40C, 0xD9A2},
        {0xE40D, 0xD9A3},
        {0xE40E, 0xD9A4},
        {0xE40F, 0xD9A5},
        {0xE410, 0xD9A6},
        {0xE411, 0xD9A7},
        {0xE412, 0xD9A8},
        {0xE413, 0xD9A9},
        {0xE414, 0xD9AA},
        {0xE415, 0xD9AB},
        {0xE416, 0xD9AC},
        {0xE417, 0xD9AD},
        {0xE418, 0xD9AE},
        {0xE419, 0xD9AF},
        {0xE41A, 0xD9B0},
        {0xE41B, 0xD9B1},
        {0xE41C, 0xD9B2},
        {0xE41D, 0xD9B3},
        {0xE41E, 0xD9B4},
        {0xE41F, 0xD9B5},
        {0xE420, 0xD9B6},
        {0xE421, 0xD9B7},
        {0xE422, 0xD9B8},
        {0xE423, 0xD9B9},
        {0xE424, 0xD9BA},
        {0xE425, 0xD9BB},
        {0xE426, 0xD9BC},
        {0xE427, 0xD9BD},
        {0xE428, 0xD9BE},
        {0xE429, 0xD9BF},
        {0xE42A, 0xD9C0},
        {0xE42B, 0xD9C1},
        {0xE42C, 0xD9C2},
        {0xE42D, 0xD9C3},
        {0xE42E, 0xD9C4},
        {0xE42F, 0xD9C5},
        {0xE430, 0xD9C6},
        {0xE431, 0xD9C7},
        {0xE432, 0xD9C8},
        {0xE433, 0xD9C9},
        {0xE434, 0xD9CA},
        {0xE435, 0xD9CB},
        {0xE436, 0xD9CC},
        {0xE437, 0xD9CD},
        {0xE438, 0xD9CE},
        {0xE439, 0xD9CF},
        {0xE43A, 0xD9D0},
        {0xE43B, 0xD9D1},
        {0xE43C, 0xD9D2},
        {0xE43D, 0xD9D3},
        {0xE43E, 0xD9D4},
        {0xE43F, 0xD9D5},
        {0xE440, 0xD9D6},
        {0xE441, 0xD9D7},
        {0xE442, 0xD9D8},
        {0xE443, 0xD9D9},
        {0xE444, 0xD9DA},
        {0xE445, 0xD9DB},
        {0xE446, 0xD9DC},
        {0xE447, 0xD9DD},
        {0xE448, 0xD9DE},
        {0xE449, 0xD9DF},
        {0xE44A, 0xD9E0},
        {0xE44B, 0xD9E1},
        {0xE44C, 0xD9E2},
        {0xE44D, 0xD9E3},
        {0xE44E, 0xD9E4},
        {0xE44F, 0xD9E5},
        {0xE450, 0xD9E6},
        {0xE451, 0xD9E7},
        {0xE452, 0xD9E8},
        {0xE453, 0xD9E9},
        {0xE454, 0xD9EA},
        {0xE455, 0xD9EB},
        {0xE456, 0xD9EC},
        {0xE457, 0xD9ED},
        {0xE458, 0xD9EE},
        {0xE459, 0xD9EF},
        {0xE45A, 0xD9F0},
        {0xE45B, 0xD9F1},
        {0xE45C, 0xD9F2},
        {0xE45D, 0xD9F3},
        {0xE45E, 0xD9F4},
        {0xE45F, 0xD9F5},
        {0xE460, 0xD9F6},
        {0xE461, 0xD9F7},
        {0xE462, 0xD9F8},
        {0xE463, 0xD9F9},
        {0xE464, 0xD9FA},
        {0xE465, 0xD9FB},
        {0xE466, 0xD9FC},
        {0xE467, 0xD9FD},
        {0xE468, 0xDA41},
        {0xE469, 0xDA42},
        {0xE46A, 0xDA43},
        {0xE46B, 0xDA44},
        {0xE46C, 0xDA45},
        {0xE46D, 0xDA46},
        {0xE46E, 0xDA47},
        {0xE46F, 0xDA48},
        {0xE470, 0xDA49},
        {0xE471, 0xDA4A},
        {0xE472, 0xDA4B},
        {0xE473, 0xDA4C},
        {0xE474, 0xDA4D},
        {0xE475, 0xDA4E},
        {0xE476, 0xDA4F},
        {0xE477, 0xDA50},
        {0xE478, 0xDA51},
        {0xE479, 0xDA52},
        {0xE47A, 0xDA53},
        {0xE47B, 0xDA54},
        {0xE47C, 0xDA55},
        {0xE47D, 0xDA56},
        {0xE47E, 0xDA57},
        {0xE47F, 0xDA58},
        {0xE480, 0xDA59},
        {0xE481, 0xDA5A},
        {0xE482, 0xDA5B},
        {0xE483, 0xDA5C},
        {0xE484, 0xDA5D},
        {0xE485, 0xDA5E},
        {0xE486, 0xDA5F},
        {0xE487, 0xDA60},
        {0xE488, 0xDA61},
        {0xE489, 0xDA62},
        {0xE48A, 0xDA63},
        {0xE48B, 0xDA64},
        {0xE48C, 0xDA65},
        {0xE48D, 0xDA66},
        {0xE48E, 0xDA67},
        {0xE48F, 0xDA68},
        {0xE490, 0xDA69},
        {0xE491, 0xDA6A},
        {0xE492, 0xDA6B},
        {0xE493, 0xDA6C},
        {0xE494, 0xDA6D},
        {0xE495, 0xDA6E},
        {0xE496, 0xDA6F},
        {0xE497, 0xDA70},
        {0xE498, 0xDA71},
        {0xE499, 0xDA72},
        {0xE49A, 0xDA73},
        {0xE49B, 0xDA74},
        {0xE49C, 0xDA75},
        {0xE49D, 0xDA76},
        {0xE49E, 0xDA77},
        {0xE49F, 0xDA78},
        {0xE4A0, 0xDA79},
        {0xE4A1, 0xDA7A},
        {0xE4A2, 0xDA7B},
        {0xE4A3, 0xDA7C},
        {0xE4A4, 0xDA7D},
        {0xE4A5, 0xDA7E},
        {0xE4A6, 0xDA7F},
        {0xE4A7, 0xDA81},
        {0xE4A8, 0xDA82},
        {0xE4A9, 0xDA83},
        {0xE4AA, 0xDA84},
        {0xE4AB, 0xDA85},
        {0xE4AC, 0xDA86},
        {0xE4AD, 0xDA87},
        {0xE4AE, 0xDA88},
        {0xE4AF, 0xDA89},
        {0xE4B0, 0xDA8A},
        {0xE4B1, 0xDA8B},
        {0xE4B2, 0xDA8C},
        {0xE4B3, 0xDA8D},
        {0xE4B4, 0xDA8E},
        {0xE4B5, 0xDA8F},
        {0xE4B6, 0xDA90},
        {0xE4B7, 0xDA91},
        {0xE4B8, 0xDA92},
        {0xE4B9, 0xDA93},
        {0xE4BA, 0xDA94},
        {0xE4BB, 0xDA95},
        {0xE4BC, 0xDA96},
        {0xE4BD, 0xDA97},
        {0xE4BE, 0xDA98},
        {0xE4BF, 0xDA99},
        {0xE4C0, 0xDA9A},
        {0xE4C1, 0xDA9B},
        {0xE4C2, 0xDA9C},
        {0xE4C3, 0xDA9D},
        {0xE4C4, 0xDA9E},
        {0xE4C5, 0xDA9F},
        {0xE4C6, 0xDAA0},
        {0xE4C7, 0xDAA1},
        {0xE4C8, 0xDAA2},
        {0xE4C9, 0xDAA3},
        {0xE4CA, 0xDAA4},
        {0xE4CB, 0xDAA5},
        {0xE4CC, 0xDAA6},
        {0xE4CD, 0xDAA7},
        {0xE4CE, 0xDAA8},
        {0xE4CF, 0xDAA9},
        {0xE4D0, 0xDAAA},
        {0xE4D1, 0xDAAB},
        {0xE4D2, 0xDAAC},
        {0xE4D3, 0xDAAD},
        {0xE4D4, 0xDAAE},
        {0xE4D5, 0xDAAF},
        {0xE4D6, 0xDAB0},
        {0xE4D7, 0xDAB1},
        {0xE4D8, 0xDAB2},
        {0xE4D9, 0xDAB3},
        {0xE4DA, 0xDAB4},
        {0xE4DB, 0xDAB5},
        {0xE4DC, 0xDAB6},
        {0xE4DD, 0xDAB7},
        {0xE4DE, 0xDAB8},
        {0xE4DF, 0xDAB9},
        {0xE4E0, 0xDABA},
        {0xE4E1, 0xDABB},
        {0xE4E2, 0xDABC},
        {0xE4E3, 0xDABD},
        {0xE4E4, 0xDABE},
        {0xE4E5, 0xDABF},
        {0xE4E6, 0xDAC0},
        {0xE4E7, 0xDAC1},
        {0xE4E8, 0xDAC2},
        {0xE4E9, 0xDAC3},
        {0xE4EA, 0xDAC4},
        {0xE4EB, 0xDAC5},
        {0xE4EC, 0xDAC6},
        {0xE4ED, 0xDAC7},
        {0xE4EE, 0xDAC8},
        {0xE4EF, 0xDAC9},
        {0xE4F0, 0xDACA},
        {0xE4F1, 0xDACB},
        {0xE4F2, 0xDACC},
        {0xE4F3, 0xDACD},
        {0xE4F4, 0xDACE},
        {0xE4F5, 0xDACF},
        {0xE4F6, 0xDAD0},
        {0xE4F7, 0xDAD1},
        {0xE4F8, 0xDAD2},
        {0xE4F9, 0xDAD3},
        {0xE4FA, 0xDAD4},
        {0xE4FB, 0xDAD5},
        {0xE4FC, 0xDAD6},
        {0xE4FD, 0xDAD7},
        {0xE4FE, 0xDAD8},
        {0xE4FF, 0xDAD9},
        {0xE500, 0xDADA},
        {0xE501, 0xDADB},
        {0xE502, 0xDADC},
        {0xE503, 0xDADD},
        {0xE504, 0xDADE},
        {0xE505, 0xDADF},
        {0xE506, 0xDAE0},
        {0xE507, 0xDAE1},
        {0xE508, 0xDAE2},
        {0xE509, 0xDAE3},
        {0xE50A, 0xDAE4},
        {0xE50B, 0xDAE5},
        {0xE50C, 0xDAE6},
        {0xE50D, 0xDAE7},
        {0xE50E, 0xDAE8},
        {0xE50F, 0xDAE9},
        {0xE510, 0xDAEA},
        {0xE511, 0xDAEB},
        {0xE512, 0xDAEC},
        {0xE513, 0xDAED},
        {0xE514, 0xDAEE},
        {0xE515, 0xDAEF},
        {0xE516, 0xDAF0},
        {0xE517, 0xDAF1},
        {0xE518, 0xDAF2},
        {0xE519, 0xDAF3},
        {0xE51A, 0xDAF4},
        {0xE51B, 0xDAF5},
        {0xE51C, 0xDAF6},
        {0xE51D, 0xDAF7},
        {0xE51E, 0xDAF8},
        {0xE51F, 0xDAF9},
        {0xE520, 0xDAFA},
        {0xE521, 0xDAFB},
        {0xE522, 0xDAFC},
        {0xE523, 0xDAFD},
        {0xE524, 0xDB41},
        {0xE525, 0xDB42},
        {0xE526, 0xDB43},
        {0xE527, 0xDB44},
        {0xE528, 0xDB45},
        {0xE529, 0xDB46},
        {0xE52A, 0xDB47},
        {0xE52B, 0xDB48},
        {0xE52C, 0xDB49},
        {0xE52D, 0xDB4A},
        {0xE52E, 0xDB4B},
        {0xE52F, 0xDB4C},
        {0xE530, 0xDB4D},
        {0xE531, 0xDB4E},
        {0xE532, 0xDB4F},
        {0xE533, 0xDB50},
        {0xE534, 0xDB51},
        {0xE535, 0xDB52},
        {0xE536, 0xDB53},
        {0xE537, 0xDB54},
        {0xE538, 0xDB55},
        {0xE539, 0xDB56},
        {0xE53A, 0xDB57},
        {0xE53B, 0xDB58},
        {0xE53C, 0xDB59},
        {0xE53D, 0xDB5A},
        {0xE53E, 0xDB5B},
        {0xE53F, 0xDB5C},
        {0xE540, 0xDB5D},
        {0xE541, 0xDB5E},
        {0xE542, 0xDB5F},
        {0xE543, 0xDB60},
        {0xE544, 0xDB61},
        {0xE545, 0xDB62},
        {0xE546, 0xDB63},
        {0xE547, 0xDB64},
        {0xE548, 0xDB65},
        {0xE549, 0xDB66},
        {0xE54A, 0xDB67},
        {0xE54B, 0xDB68},
        {0xE54C, 0xDB69},
        {0xE54D, 0xDB6A},
        {0xE54E, 0xDB6B},
        {0xE54F, 0xDB6C},
        {0xE550, 0xDB6D},
        {0xE551, 0xDB6E},
        {0xE552, 0xDB6F},
        {0xE553, 0xDB70},
        {0xE554, 0xDB71},
        {0xE555, 0xDB72},
        {0xE556, 0xDB73},
        {0xE557, 0xDB74},
        {0xE558, 0xDB75},
        {0xE559, 0xDB76},
        {0xE55A, 0xDB77},
        {0xE55B, 0xDB78},
        {0xE55C, 0xDB79},
        {0xE55D, 0xDB7A},
        {0xE55E, 0xDB7B},
        {0xE55F, 0xDB7C},
        {0xE560, 0xDB7D},
        {0xE561, 0xDB7E},
        {0xE562, 0xDB7F},
        {0xE563, 0xDB81},
        {0xE564, 0xDB82},
        {0xE565, 0xDB83},
        {0xE566, 0xDB84},
        {0xE567, 0xDB85},
        {0xE568, 0xDB86},
        {0xE569, 0xDB87},
        {0xE56A, 0xDB88},
        {0xE56B, 0xDB89},
        {0xE56C, 0xDB8A},
        {0xE56D, 0xDB8B},
        {0xE56E, 0xDB8C},
        {0xE56F, 0xDB8D},
        {0xE570, 0xDB8E},
        {0xE571, 0xDB8F},
        {0xE572, 0xDB90},
        {0xE573, 0xDB91},
        {0xE574, 0xDB92},
        {0xE575, 0xDB93},
        {0xE576, 0xDB94},
        {0xE577, 0xDB95},
        {0xE578, 0xDB96},
        {0xE579, 0xDB97},
        {0xE57A, 0xDB98},
        {0xE57B, 0xDB99},
        {0xE57C, 0xDB9A},
        {0xE57D, 0xDB9B},
        {0xE57E, 0xDB9C},
        {0xE57F, 0xDB9D},
        {0xE580, 0xDB9E},
        {0xE581, 0xDB9F},
        {0xE582, 0xDBA0},
        {0xE583, 0xDBA1},
        {0xE584, 0xDBA2},
        {0xE585, 0xDBA3},
        {0xE586, 0xDBA4},
        {0xE587, 0xDBA5},
        {0xE588, 0xDBA6},
        {0xE589, 0xDBA7},
        {0xE58A, 0xDBA8},
        {0xE58B, 0xDBA9},
        {0xE58C, 0xDBAA},
        {0xE58D, 0xDBAB},
        {0xE58E, 0xDBAC},
        {0xE58F, 0xDBAD},
        {0xE590, 0xDBAE},
        {0xE591, 0xDBAF},
        {0xE592, 0xDBB0},
        {0xE593, 0xDBB1},
        {0xE594, 0xDBB2},
        {0xE595, 0xDBB3},
        {0xE596, 0xDBB4},
        {0xE597, 0xDBB5},
        {0xE598, 0xDBB6},
        {0xE599, 0xDBB7},
        {0xE59A, 0xDBB8},
        {0xE59B, 0xDBB9},
        {0xE59C, 0xDBBA},
        {0xE59D, 0xDBBB},
        {0xE59E, 0xDBBC},
        {0xE59F, 0xDBBD},
        {0xE5A0, 0xDBBE},
        {0xE5A1, 0xDBBF},
        {0xE5A2, 0xDBC0},
        {0xE5A3, 0xDBC1},
        {0xE5A4, 0xDBC2},
        {0xE5A5, 0xDBC3},
        {0xE5A6, 0xDBC4},
        {0xE5A7, 0xDBC5},
        {0xE5A8, 0xDBC6},
        {0xE5A9, 0xDBC7},
        {0xE5AA, 0xDBC8},
        {0xE5AB, 0xDBC9},
        {0xE5AC, 0xDBCA},
        {0xE5AD, 0xDBCB},
        {0xE5AE, 0xDBCC},
        {0xE5AF, 0xDBCD},
        {0xE5B0, 0xDBCE},
        {0xE5B1, 0xDBCF},
        {0xE5B2, 0xDBD0},
        {0xE5B3, 0xDBD1},
        {0xE5B4, 0xDBD2},
        {0xE5B5, 0xDBD3},
        {0xE5B6, 0xDBD4},
        {0xE5B7, 0xDBD5},
        {0xE5B8, 0xDBD6},
        {0xE5B9, 0xDBD7},
        {0xE5BA, 0xDBD8},
        {0xE5BB, 0xDBD9},
        {0xE5BC, 0xDBDA},
        {0xE5BD, 0xDBDB},
        {0xE5BE, 0xDBDC},
        {0xE5BF, 0xDBDD},
        {0xE5C0, 0xDBDE},
        {0xE5C1, 0xDBDF},
        {0xE5C2, 0xDBE0},
        {0xE5C3, 0xDBE1},
        {0xE5C4, 0xDBE2},
        {0xE5C5, 0xDBE3},
        {0xE5C6, 0xDBE4},
        {0xE5C7, 0xDBE5},
        {0xE5C8, 0xDBE6},
        {0xE5C9, 0xDBE7},
        {0xE5CA, 0xDBE8},
        {0xE5CB, 0xDBE9},
        {0xE5CC, 0xDBEA},
        {0xE5CD, 0xDBEB},
        {0xE5CE, 0xDBEC},
        {0xE5CF, 0xDBED},
        {0xE5D0, 0xDBEE},
        {0xE5D1, 0xDBEF},
        {0xE5D2, 0xDBF0},
        {0xE5D3, 0xDBF1},
        {0xE5D4, 0xDBF2},
        {0xE5D5, 0xDBF3},
        {0xE5D6, 0xDBF4},
        {0xE5D7, 0xDBF5},
        {0xE5D8, 0xDBF6},
        {0xE5D9, 0xDBF7},
        {0xE5DA, 0xDBF8},
        {0xE5DB, 0xDBF9},
        {0xE5DC, 0xDBFA},
        {0xE5DD, 0xDBFB},
        {0xE5DE, 0xDBFC},
        {0xE5DF, 0xDBFD},
        {0xE5E0, 0xDC41},
        {0xE5E1, 0xDC42},
        {0xE5E2, 0xDC43},
        {0xE5E3, 0xDC44},
        {0xE5E4, 0xDC45},
        {0xE5E5, 0xDC46},
        {0xE5E6, 0xDC47},
        {0xE5E7, 0xDC48},
        {0xE5E8, 0xDC49},
        {0xE5E9, 0xDC4A},
        {0xE5EA, 0xDC4B},
        {0xE5EB, 0xDC4C},
        {0xE5EC, 0xDC4D},
        {0xE5ED, 0xDC4E},
        {0xE5EE, 0xDC4F},
        {0xE5EF, 0xDC50},
        {0xE5F0, 0xDC51},
        {0xE5F1, 0xDC52},
        {0xE5F2, 0xDC53},
        {0xE5F3, 0xDC54},
        {0xE5F4, 0xDC55},
        {0xE5F5, 0xDC56},
        {0xE5F6, 0xDC57},
        {0xE5F7, 0xDC58},
        {0xE5F8, 0xDC59},
        {0xE5F9, 0xDC5A},
        {0xE5FA, 0xDC5B},
        {0xE5FB, 0xDC5C},
        {0xE5FC, 0xDC5D},
        {0xE5FD, 0xDC5E},
        {0xE5FE, 0xDC5F},
        {0xE5FF, 0xDC60},
        {0xE600, 0xDC61},
        {0xE601, 0xDC62},
        {0xE602, 0xDC63},
        {0xE603, 0xDC64},
        {0xE604, 0xDC65},
        {0xE605, 0xDC66},
        {0xE606, 0xDC67},
        {0xE607, 0xDC68},
        {0xE608, 0xDC69},
        {0xE609, 0xDC6A},
        {0xE60A, 0xDC6B},
        {0xE60B, 0xDC6C},
        {0xE60C, 0xDC6D},
        {0xE60D, 0xDC6E},
        {0xE60E, 0xDC6F},
        {0xE60F, 0xDC70},
        {0xE610, 0xDC71},
        {0xE611, 0xDC72},
        {0xE612, 0xDC73},
        {0xE613, 0xDC74},
        {0xE614, 0xDC75},
        {0xE615, 0xDC76},
        {0xE616, 0xDC77},
        {0xE617, 0xDC78},
        {0xE618, 0xDC79},
        {0xE619, 0xDC7A},
        {0xE61A, 0xDC7B},
        {0xE61B, 0xDC7C},
        {0xE61C, 0xDC7D},
        {0xE61D, 0xDC7E},
        {0xE61E, 0xDC7F},
        {0xE61F, 0xDC81},
        {0xE620, 0xDC82},
        {0xE621, 0xDC83},
        {0xE622, 0xDC84},
        {0xE623, 0xDC85},
        {0xE624, 0xDC86},
        {0xE625, 0xDC87},
        {0xE626, 0xDC88},
        {0xE627, 0xDC89},
        {0xE628, 0xDC8A},
        {0xE629, 0xDC8B},
        {0xE62A, 0xDC8C},
        {0xE62B, 0xDC8D},
        {0xE62C, 0xDC8E},
        {0xE62D, 0xDC8F},
        {0xE62E, 0xDC90},
        {0xE62F, 0xDC91},
        {0xE630, 0xDC92},
        {0xE631, 0xDC93},
        {0xE632, 0xDC94},
        {0xE633, 0xDC95},
        {0xE634, 0xDC96},
        {0xE635, 0xDC97},
        {0xE636, 0xDC98},
        {0xE637, 0xDC99},
        {0xE638, 0xDC9A},
        {0xE639, 0xDC9B},
        {0xE63A, 0xDC9C},
        {0xE63B, 0xDC9D},
        {0xE63C, 0xDC9E},
        {0xE63D, 0xDC9F},
        {0xE63E, 0xDCA0},
        {0xE63F, 0xDCA1},
        {0xE640, 0xDCA2},
        {0xE641, 0xDCA3},
        {0xE642, 0xDCA4},
        {0xE643, 0xDCA5},
        {0xE644, 0xDCA6},
        {0xE645, 0xDCA7},
        {0xE646, 0xDCA8},
        {0xE647, 0xDCA9},
        {0xE648, 0xDCAA},
        {0xE649, 0xDCAB},
        {0xE64A, 0xDCAC},
        {0xE64B, 0xDCAD},
        {0xE64C, 0xDCAE},
        {0xE64D, 0xDCAF},
        {0xE64E, 0xDCB0},
        {0xE64F, 0xDCB1},
        {0xE650, 0xDCB2},
        {0xE651, 0xDCB3},
        {0xE652, 0xDCB4},
        {0xE653, 0xDCB5},
        {0xE654, 0xDCB6},
        {0xE655, 0xDCB7},
        {0xE656, 0xDCB8},
        {0xE657, 0xDCB9},
        {0xE658, 0xDCBA},
        {0xE659, 0xDCBB},
        {0xE65A, 0xDCBC},
        {0xE65B, 0xDCBD},
        {0xE65C, 0xDCBE},
        {0xE65D, 0xDCBF},
        {0xE65E, 0xDCC0},
        {0xE65F, 0xDCC1},
        {0xE660, 0xDCC2},
        {0xE661, 0xDCC3},
        {0xE662, 0xDCC4},
        {0xE663, 0xDCC5},
        {0xE664, 0xDCC6},
        {0xE665, 0xDCC7},
        {0xE666, 0xDCC8},
        {0xE667, 0xDCC9},
        {0xE668, 0xDCCA},
        {0xE669, 0xDCCB},
        {0xE66A, 0xDCCC},
        {0xE66B, 0xDCCD},
        {0xE66C, 0xDCCE},
        {0xE66D, 0xDCCF},
        {0xE66E, 0xDCD0},
        {0xE66F, 0xDCD1},
        {0xE670, 0xDCD2},
        {0xE671, 0xDCD3},
        {0xE672, 0xDCD4},
        {0xE673, 0xDCD5},
        {0xE674, 0xDCD6},
        {0xE675, 0xDCD7},
        {0xE676, 0xDCD8},
        {0xE677, 0xDCD9},
        {0xE678, 0xDCDA},
        {0xE679, 0xDCDB},
        {0xE67A, 0xDCDC},
        {0xE67B, 0xDCDD},
        {0xE67C, 0xDCDE},
        {0xE67D, 0xDCDF},
        {0xE67E, 0xDCE0},
        {0xE67F, 0xDCE1},
        {0xE680, 0xDCE2},
        {0xE681, 0xDCE3},
        {0xE682, 0xDCE4},
        {0xE683, 0xDCE5},
        {0xE684, 0xDCE6},
        {0xE685, 0xDCE7},
        {0xE686, 0xDCE8},
        {0xE687, 0xDCE9},
        {0xE688, 0xDCEA},
        {0xE689, 0xDCEB},
        {0xE68A, 0xDCEC},
        {0xE68B, 0xDCED},
        {0xE68C, 0xDCEE},
        {0xE68D, 0xDCEF},
        {0xE68E, 0xDCF0},
        {0xE68F, 0xDCF1},
        {0xE690, 0xDCF2},
        {0xE691, 0xDCF3},
        {0xE692, 0xDCF4},
        {0xE693, 0xDCF5},
        {0xE694, 0xDCF6},
        {0xE695, 0xDCF7},
        {0xE696, 0xDCF8},
        {0xE697, 0xDCF9},
        {0xE698, 0xDCFA},
        {0xE699, 0xDCFB},
        {0xE69A, 0xDCFC},
        {0xE69B, 0xDCFD},
        {0xE69C, 0xDD41},
        {0xE69D, 0xDD42},
        {0xE69E, 0xDD43},
        {0xE69F, 0xDD44},
        {0xE6A0, 0xDD45},
        {0xE6A1, 0xDD46},
        {0xE6A2, 0xDD47},
        {0xE6A3, 0xDD48},
        {0xE6A4, 0xDD49},
        {0xE6A5, 0xDD4A},
        {0xE6A6, 0xDD4B},
        {0xE6A7, 0xDD4C},
        {0xE6A8, 0xDD4D},
        {0xE6A9, 0xDD4E},
        {0xE6AA, 0xDD4F},
        {0xE6AB, 0xDD50},
        {0xE6AC, 0xDD51},
        {0xE6AD, 0xDD52},
        {0xE6AE, 0xDD53},
        {0xE6AF, 0xDD54},
        {0xE6B0, 0xDD55},
        {0xE6B1, 0xDD56},
        {0xE6B2, 0xDD57},
        {0xE6B3, 0xDD58},
        {0xE6B4, 0xDD59},
        {0xE6B5, 0xDD5A},
        {0xE6B6, 0xDD5B},
        {0xE6B7, 0xDD5C},
        {0xE6B8, 0xDD5D},
        {0xE6B9, 0xDD5E},
        {0xE6BA, 0xDD5F},
        {0xE6BB, 0xDD60},
        {0xE6BC, 0xDD61},
        {0xE6BD, 0xDD62},
        {0xE6BE, 0xDD63},
        {0xE6BF, 0xDD64},
        {0xE6C0, 0xDD65},
        {0xE6C1, 0xDD66},
        {0xE6C2, 0xDD67},
        {0xE6C3, 0xDD68},
        {0xE6C4, 0xDD69},
        {0xE6C5, 0xDD6A},
        {0xE6C6, 0xDD6B},
        {0xE6C7, 0xDD6C},
        {0xE6C8, 0xDD6D},
        {0xE6C9, 0xDD6E},
        {0xE6CA, 0xDD6F},
        {0xE6CB, 0xDD70},
        {0xE6CC, 0xDD71},
        {0xE6CD, 0xDD72},
        {0xE6CE, 0xDD73},
        {0xE6CF, 0xDD74},
        {0xE6D0, 0xDD75},
        {0xE6D1, 0xDD76},
        {0xE6D2, 0xDD77},
        {0xE6D3, 0xDD78},
        {0xE6D4, 0xDD79},
        {0xE6D5, 0xDD7A},
        {0xE6D6, 0xDD7B},
        {0xE6D7, 0xDD7C},
        {0xE6D8, 0xDD7D},
        {0xE6D9, 0xDD7E},
        {0xE6DA, 0xDD7F},
        {0xE6DB, 0xDD81},
        {0xE6DC, 0xDD82},
        {0xE6DD, 0xDD83},
        {0xE6DE, 0xDD84},
        {0xE6DF, 0xDD85},
        {0xE6E0, 0xDD86},
        {0xE6E1, 0xDD87},
        {0xE6E2, 0xDD88},
        {0xE6E3, 0xDD89},
        {0xE6E4, 0xDD8A},
        {0xE6E5, 0xDD8B},
        {0xE6E6, 0xDD8C},
        {0xE6E7, 0xDD8D},
        {0xE6E8, 0xDD8E},
        {0xE6E9, 0xDD8F},
        {0xE6EA, 0xDD90},
        {0xE6EB, 0xDD91},
        {0xE6EC, 0xDD92},
        {0xE6ED, 0xDD93},
        {0xE6EE, 0xDD94},
        {0xE6EF, 0xDD95},
        {0xE6F0, 0xDD96},
        {0xE6F1, 0xDD97},
        {0xE6F2, 0xDD98},
        {0xE6F3, 0xDD99},
        {0xE6F4, 0xDD9A},
        {0xE6F5, 0xDD9B},
        {0xE6F6, 0xDD9C},
        {0xE6F7, 0xDD9D},
        {0xE6F8, 0xDD9E},
        {0xE6F9, 0xDD9F},
        {0xE6FA, 0xDDA0},
        {0xE6FB, 0xDDA1},
        {0xE6FC, 0xDDA2},
        {0xE6FD, 0xDDA3},
        {0xE6FE, 0xDDA4},
        {0xE6FF, 0xDDA5},
        {0xE700, 0xDDA6},
        {0xE701, 0xDDA7},
        {0xE702, 0xDDA8},
        {0xE703, 0xDDA9},
        {0xE704, 0xDDAA},
        {0xE705, 0xDDAB},
        {0xE706, 0xDDAC},
        {0xE707, 0xDDAD},
        {0xE708, 0xDDAE},
        {0xE709, 0xDDAF},
        {0xE70A, 0xDDB0},
        {0xE70B, 0xDDB1},
        {0xE70C, 0xDDB2},
        {0xE70D, 0xDDB3},
        {0xE70E, 0xDDB4},
        {0xE70F, 0xDDB5},
        {0xE710, 0xDDB6},
        {0xE711, 0xDDB7},
        {0xE712, 0xDDB8},
        {0xE713, 0xDDB9},
        {0xE714, 0xDDBA},
        {0xE715, 0xDDBB},
        {0xE716, 0xDDBC},
        {0xE717, 0xDDBD},
        {0xE718, 0xDDBE},
        {0xE719, 0xDDBF},
        {0xE71A, 0xDDC0},
        {0xE71B, 0xDDC1},
        {0xE71C, 0xDDC2},
        {0xE71D, 0xDDC3},
        {0xE71E, 0xDDC4},
        {0xE71F, 0xDDC5},
        {0xE720, 0xDDC6},
        {0xE721, 0xDDC7},
        {0xE722, 0xDDC8},
        {0xE723, 0xDDC9},
        {0xE724, 0xDDCA},
        {0xE725, 0xDDCB},
        {0xE726, 0xDDCC},
        {0xE727, 0xDDCD},
        {0xE728, 0xDDCE},
        {0xE729, 0xDDCF},
        {0xE72A, 0xDDD0},
        {0xE72B, 0xDDD1},
        {0xE72C, 0xDDD2}
};

#endif
