/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed
 * under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


#ifndef	_JFP_UCS2_TO_EUC16_H
#define	_JFP_UCS2_TO_EUC16_H

/*
 * UCS-2 to 16bit EUC wide character conversion
 * for iconv modules or STREAMS modules.
 * Please define one of these macros before including this header.
 * This list can grow in the future.
 *	JFP_U2E_STREAMS			STREAMS modules
 *	JFP_U2E_ICONV			basic iconv
 *	JFP_U2E_ICONV_JAVA		JDK conversion class compatible iconv
 *	JFP_U2E_ICONV_RFC1468		RFC1468 strict iconv
 *	JFP_U2E_ICONV_UNICODEINC	iconv based on Unicode Inc's table
 *	JFP_U2E_ICONV_MS932		iconv based on MS's conversion
 *	JFP_U2E_ICONV_X0213		iconv based on JIS X 0213
 * (When JFP_U2E_ICONV_* is defined, JFP_U2E_ICONV will be defined
 *  automatically in this header.)
 */

/*
 * Make "if defined(JFP_U2E_ICONV)" applicable to any iconv module.
 */
#if	defined(JFP_U2E_ICONV_JAVA) \
		|| defined(JFP_U2E_ICONV_RFC1468) \
		|| defined(JFP_U2E_ICONV_UNICODEINC) \
		|| defined(JFP_U2E_ICONV_MS932) \
		|| defined(JFP_U2E_ICONV_X0213)
#define	JFP_U2E_ICONV
#endif

/*
 * Check if required macro is defined.
 */
#if	! (defined(JFP_U2E_STREAMS) || defined(JFP_U2E_ICONV))
#error	"Please define JFP_U2E_STREAMS or JFP_U2E_ICONV_xxx."
#endif

#include	<jfp_ucs2_common.h>

typedef	unsigned short	_jfp_euc16_t;

#ifndef	NULL
#define	NULL	0
#endif	/* !NULL */


/*
 * Default destination (aka replacement character)
 * 	U2E_NODEST_COL2: for 2 column width character
 * 	U2E_NODEST_COL1: for 1 column width character
 * 	U2E_NODEST_COLX: for unknown (or undefined) column width character
 */
#if	defined(JFP_U2E_STREAMS)
#define		U2E_NODEST_COL2	0xa2ae	/* Geta Mark */
#define		U2E_NODEST_COL1	0x003f	/* Question Mark */
#define		U2E_NODEST_COLX	U2E_NODEST_COL2	/* tentative */
#elif	defined(JFP_U2E_ICONV)
#define		U2E_NODEST_COL2	0x003f	/* Question Mark */
#define		U2E_NODEST_COL1	0x003f	/* Question Mark */
#define		U2E_NODEST_COLX	0x003f	/* Question Mark */
#endif

/*
 * This value indicates the UCS-2 value needs special handling which
 * cannot be held on the table.
 */
#define		DO_SPECIAL	(0xffff)

/*
 * JIS X 0201 Roman
 */
#define		JISROMAN(x)	(x)

/*
 * JIS X 0201 Kana (aka Hankaku Kana)
 */
#define		JISKANA(x)	(x)

/*
 * JIS X 0208
 */
#define		JISX0208(x)	(x)

/*
 * JIS X 0212
 */
#if	defined(JFP_U2E_ICONV_RFC1468)
#define		JISX0212(x)	U2E_NODEST_COL2
#else	/* ! defined(JFP_U2E_ICONV_RFC1468) */
#define		JISX0212(x)	(x)
#endif	/* defined(JFP_U2E_ICONV_RFC1468) */

/*
 * C1 control characters
 */
#if	defined(JFP_U2E_STREAMS)
#define		C1CTRL(x)	(x)
#else	/* ! defined(JFP_U2E_STREAMS) */
#define		C1CTRL(x)	U2E_NODEST_COLX
#endif	/* defined(JFP_U2E_STREAMS) */

/*
 * Vendor defined characters
 */
#if	defined(JFP_U2E_ICONV_RFC1468) || defined(JFP_U2E_ICONV_JAVA)
#define		NEC13(x)	U2E_NODEST_COL2
#define		IBM(x)		U2E_NODEST_COL2
#else	/* ! (defined(JFP_U2E_ICONV_RFC1468) || defined(JFP_U2E_ICONV_JAVA)) */
#define		NEC13(x)	(x)
#define		IBM(x)		(x)
#endif	/* defined(JFP_U2E_ICONV_RFC1468) || defined(JFP_U2E_ICONV_JAVA) */

/*
 * User defined characters
 */
#if	defined(JFP_U2E_ICONV_RFC1468) || defined(JFP_U2E_ICONV_JAVA)
#define		UDC(x)		U2E_NODEST_COL2
#else	/* ! (defined(JFP_U2E_ICONV_RFC1468) || defined(JFP_U2E_ICONV_JAVA)) */
#define		UDC(x)		(x)
#endif	/* defined(JFP_U2E_ICONV_RFC1468) || defined(JFP_U2E_ICONV_JAVA) */

/*
 * JIS X 0213
 */
#if	defined(JFP_U2E_ICONV_X0213)
#define		IFX0213(x, y)	(x)
#define		JISX0213_1(x)	(x)
#define		JISX0213_2(x)	(x)
#else	/* ! JFP_U2E_ICONV_X0213 */
#define		IFX0213(x, y)	(y)
#endif	/* JFP_U2E_ICONV_X0213 */

/*
 * Some characters converted to different character depending on
 * conversion policy used.
 */
#if	defined(JFP_U2E_STREAMS)
#define		U2E_005C_DEST	(0x005c)	/* backslash */
#define		U2E_007E_DEST	(0x007e)	/* tilde */
#define		U2E_00A2_DEST	(0xa1f1)	/* Cent sign */
#define		U2E_00A3_DEST	(0xa1f2)	/* Pound sign */
#define		U2E_00A5_DEST	U2E_NODEST_COL1	/* Yen sign */
#define		U2E_00A6_DEST	JISX0212(0xa243)/* Broken bar */
#define		U2E_00AC_DEST	(0xa2cc)	/* not sign */
#define		U2E_2016_DEST	(0xa1c2)	/* double vertical line */
#define		U2E_203E_DEST	U2E_NODEST_COL1	/* overline */
#define		U2E_2116_DEST	(0xa271)	/* numero sign */
#define		U2E_2212_DEST	(0xa1dd)	/* minus sign */
#define		U2E_2225_DEST	U2E_NODEST_COLX	/* parallel to */
#define		U2E_301C_DEST	(0xa1c1)	/* wave dash */
#define		U2E_FF0D_DEST	U2E_NODEST_COL2	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	(0xa1c0)	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	(0xa237)	/* fullwidth tilde */
#define		U2E_FFE0_DEST	U2E_NODEST_COL2	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	U2E_NODEST_COL2	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	U2E_NODEST_COL2	/* fullwidth not sign */
#define		U2E_FFE4_DEST	U2E_NODEST_COL2	/* fullwidth vert. broken bar */
#elif	defined(JFP_U2E_ICONV_JAVA)
#define		U2E_005C_DEST	(0x005c)	/* backslash */
#define		U2E_007E_DEST	(0x007e)	/* tilde */
#define		U2E_00A2_DEST	(0xa1f1)	/* Cent sign */
#define		U2E_00A3_DEST	(0xa1f2)	/* Pound sign */
#define		U2E_00A5_DEST	(0x005c)	/* Yen sign */
#define		U2E_00A6_DEST	JISX0212(0xa243)/* Broken bar */
#define		U2E_00AC_DEST	(0xa2cc)	/* not sign */
#define		U2E_2016_DEST	(0xa1c2)	/* double vertical line */
#define		U2E_203E_DEST	U2E_NODEST_COL1	/* overline */
#define		U2E_2116_DEST	JISX0212(0xa271)/* numero sign */
#define		U2E_2212_DEST	(0xa1dd)	/* minus sign */
#define		U2E_2225_DEST	U2E_NODEST_COLX	/* parallel to */
#define		U2E_301C_DEST	(0xa1c1)	/* wave dash */
#define		U2E_FF0D_DEST	U2E_NODEST_COL2	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	(0xa1c0)	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	U2E_NODEST_COL2	/* fullwidth tilde */
#define		U2E_FFE0_DEST	U2E_NODEST_COL2	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	U2E_NODEST_COL2	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	U2E_NODEST_COL2	/* fullwidth not sign */
#define		U2E_FFE4_DEST	U2E_NODEST_COLX	/* fullwidth vert. broken bar */
#elif	defined(JFP_U2E_ICONV_RFC1468)
#define		U2E_005C_DEST	(0x005c)	/* backslash */
#define		U2E_007E_DEST	(0x007e)	/* tilde */
#define		U2E_00A2_DEST	(0xa1f1)	/* Cent sign */
#define		U2E_00A3_DEST	(0xa1f2)	/* Pound sign */
#define		U2E_00A5_DEST	U2E_NODEST_COL1	/* Yen sign */
#define		U2E_00A6_DEST	U2E_NODEST_COLX	/* Broken bar */
#define		U2E_00AC_DEST	(0xa2cc)	/* not sign */
#define		U2E_2016_DEST	(0xa1c2)	/* double vertical line */
#define		U2E_2116_DEST	U2E_NODEST_COLX	/* numero sign */
#define		U2E_203E_DEST	U2E_NODEST_COL1	/* overline */
#define		U2E_2212_DEST	(0xa1dd)	/* minus sign */
#define		U2E_2225_DEST	U2E_NODEST_COLX	/* parallel to */
#define		U2E_301C_DEST	(0xa1c1)	/* wave dash */
#define		U2E_FF0D_DEST	U2E_NODEST_COL2	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	(0xa1c0)	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	U2E_NODEST_COL2	/* fullwidth tilde */
#define		U2E_FFE0_DEST	U2E_NODEST_COL2	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	U2E_NODEST_COL2	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	U2E_NODEST_COL2	/* fullwidth not sign */
#define		U2E_FFE4_DEST	U2E_NODEST_COLX	/* fullwidth vert. broken bar */
#elif	defined(JFP_U2E_ICONV_UNICODEINC)
#define		U2E_005C_DEST	(0xa1c0)	/* backslash */
#define		U2E_007E_DEST	(0xa237)	/* tilde */
#define		U2E_00A2_DEST	(0xa1f1)	/* Cent sign */
#define		U2E_00A3_DEST	(0xa1f2)	/* Pound sign */
#define		U2E_00A5_DEST	(0x005c)	/* Yen sign */
#define		U2E_00A6_DEST	JISX0212(0xa243)/* Broken bar */
#define		U2E_00AC_DEST	(0xa2cc)	/* not sign */
#define		U2E_2016_DEST	(0xa1c2)	/* double vertical line */
#define		U2E_203E_DEST	(0x007e)	/* overline */
#define		U2E_2116_DEST	(0xa271)	/* numero sign */
#define		U2E_2212_DEST	(0xa1dd)	/* minus sign */
#define		U2E_2225_DEST	U2E_NODEST_COLX	/* parallel to */
#define		U2E_301C_DEST	(0xa1c1)	/* wave dash */
#define		U2E_FF0D_DEST	U2E_NODEST_COL2	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	U2E_NODEST_COL2	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	U2E_NODEST_COL2	/* fullwidth tilde */
#define		U2E_FFE0_DEST	U2E_NODEST_COL2	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	U2E_NODEST_COL2	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	U2E_NODEST_COL2	/* fullwidth not sign */
#define		U2E_FFE4_DEST	U2E_NODEST_COLX	/* fullwidth vert. broken bar */
#elif	defined(JFP_U2E_ICONV_MS932)
#define		U2E_005C_DEST	(0x005c)	/* backslash */
#define		U2E_007E_DEST	(0x007e)	/* tilde */
#define		U2E_00A2_DEST	U2E_NODEST_COLX	/* Cent sign */
#define		U2E_00A3_DEST	U2E_NODEST_COLX	/* Pound sign */
#define		U2E_00A5_DEST	(0x005c)	/* Yen sign */
#define		U2E_00A6_DEST	U2E_NODEST_COLX	/* Broken bar */
#define		U2E_00AC_DEST	U2E_NODEST_COLX	/* not sign */
#define		U2E_2016_DEST	U2E_NODEST_COLX	/* double vertical line */
#define		U2E_203E_DEST	(0x007e)	/* overline */
#define		U2E_2116_DEST	(0xade2)	/* numero sign */
#define		U2E_2212_DEST	U2E_NODEST_COLX	/* minus sign */
#define		U2E_2225_DEST	(0xa1c2)	/* parallel to */
#define		U2E_301C_DEST	U2E_NODEST_COLX	/* wave dash */
#define		U2E_FF0D_DEST	(0xa1dd)	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	(0xa1c0)	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	(0xa1c1)	/* fullwidth tilde */
#define		U2E_FFE0_DEST	(0xa1f1)	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	(0xa1f2)	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	(0xa2cc)	/* fullwidth not sign */
#define		U2E_FFE4_DEST	JISX0212(0xa243)/* fullwidth vert. broken bar */
#elif	defined(JFP_U2E_ICONV_X0213)
#define		U2E_005C_DEST	(0x005c)	/* backslash */
#define		U2E_007E_DEST	(0x007e)	/* tilde */
#define		U2E_00A2_DEST	(0xa1f1)	/* Cent sign */
#define		U2E_00A3_DEST	(0xa1f2)	/* Pound sign */
#define		U2E_00A5_DEST	U2E_NODEST_COL1	/* Yen sign */
#define		U2E_00A6_DEST	JISX0213_1(0xa9a5)/* Broken bar */
#define		U2E_00AC_DEST	(0xa2cc)	/* not sign */
#define		U2E_2016_DEST	(0xa1c2)	/* double vertical line */
#define		U2E_203E_DEST	U2E_NODEST_COL1	/* overline */
#define		U2E_2116_DEST	JISX0213_1(0xade2)	/* numero sign */
#define		U2E_2212_DEST	(0xa1dd)	/* minus sign */
#define		U2E_2225_DEST	(0xa2d4)	/* parallel to */
#define		U2E_301C_DEST	(0xa1c1)	/* wave dash */
#define		U2E_FF0D_DEST	U2E_NODEST_COL2	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	(0xa1c0)	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	(0xa237)	/* fullwidth tilde */
#define		U2E_FFE0_DEST	U2E_NODEST_COL2	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	U2E_NODEST_COL2	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	U2E_NODEST_COL2	/* fullwidth not sign */
#define		U2E_FFE4_DEST	U2E_NODEST_COLX	/* fullwidth vert. broken bar */
#elif	defined(JFP_U2E_ICONV)
#define		U2E_005C_DEST	(0x005c)	/* backslash */
#define		U2E_007E_DEST	(0x007e)	/* tilde */
#define		U2E_00A2_DEST	(0xa1f1)	/* Cent sign */
#define		U2E_00A3_DEST	(0xa1f2)	/* Pound sign */
#define		U2E_00A5_DEST	U2E_NODEST_COL1	/* Yen sign */
#define		U2E_00A6_DEST	JISX0212(0xa243)/* Broken bar */
#define		U2E_00AC_DEST	(0xa2cc)	/* not sign */
#define		U2E_2016_DEST	(0xa1c2)	/* double vertical line */
#define		U2E_203E_DEST	U2E_NODEST_COL1	/* overline */
#define		U2E_2116_DEST	(0xa271)	/* numero sign */
#define		U2E_2212_DEST	(0xa1dd)	/* minus sign */
#define		U2E_2225_DEST	U2E_NODEST_COLX	/* parallel to */
#define		U2E_301C_DEST	(0xa1c1)	/* wave dash */
#define		U2E_FF0D_DEST	U2E_NODEST_COL2	/* fullwidth hyphen-minus */
#define		U2E_FF3C_DEST	(0xa1c0)	/* fullwidth reverse solidus */
#define		U2E_FF5E_DEST	(0xa237)	/* fullwidth tilde */
#define		U2E_FFE0_DEST	U2E_NODEST_COL2	/* fullwidth Cent sign */
#define		U2E_FFE1_DEST	U2E_NODEST_COL2	/* fullwidth Pound sign */
#define		U2E_FFE2_DEST	U2E_NODEST_COL2	/* fullwidth not sign */
#define		U2E_FFE4_DEST	U2E_NODEST_COLX	/* fullwidth vert. broken bar */
#endif

/*
 * Tables
 */

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_00[] = {
	/* U+0000 */	JISROMAN(0x0000),
	/* U+0001 */	JISROMAN(0x0001),
	/* U+0002 */	JISROMAN(0x0002),
	/* U+0003 */	JISROMAN(0x0003),
	/* U+0004 */	JISROMAN(0x0004),
	/* U+0005 */	JISROMAN(0x0005),
	/* U+0006 */	JISROMAN(0x0006),
	/* U+0007 */	JISROMAN(0x0007),
	/* U+0008 */	JISROMAN(0x0008),
	/* U+0009 */	JISROMAN(0x0009),
	/* U+000A */	JISROMAN(0x000a),
	/* U+000B */	JISROMAN(0x000b),
	/* U+000C */	JISROMAN(0x000c),
	/* U+000D */	JISROMAN(0x000d),
	/* U+000E */	JISROMAN(0x000e),
	/* U+000F */	JISROMAN(0x000f),
	/* U+0010 */	JISROMAN(0x0010),
	/* U+0011 */	JISROMAN(0x0011),
	/* U+0012 */	JISROMAN(0x0012),
	/* U+0013 */	JISROMAN(0x0013),
	/* U+0014 */	JISROMAN(0x0014),
	/* U+0015 */	JISROMAN(0x0015),
	/* U+0016 */	JISROMAN(0x0016),
	/* U+0017 */	JISROMAN(0x0017),
	/* U+0018 */	JISROMAN(0x0018),
	/* U+0019 */	JISROMAN(0x0019),
	/* U+001A */	JISROMAN(0x001a),
	/* U+001B */	JISROMAN(0x001b),
	/* U+001C */	JISROMAN(0x001c),
	/* U+001D */	JISROMAN(0x001d),
	/* U+001E */	JISROMAN(0x001e),
	/* U+001F */	JISROMAN(0x001f),
	/* U+0020 */	JISROMAN(0x0020),
	/* U+0021 */	JISROMAN(0x0021),
	/* U+0022 */	JISROMAN(0x0022),
	/* U+0023 */	JISROMAN(0x0023),
	/* U+0024 */	JISROMAN(0x0024),
	/* U+0025 */	JISROMAN(0x0025),
	/* U+0026 */	JISROMAN(0x0026),
	/* U+0027 */	JISROMAN(0x0027),
	/* U+0028 */	JISROMAN(0x0028),
	/* U+0029 */	JISROMAN(0x0029),
	/* U+002A */	JISROMAN(0x002a),
	/* U+002B */	JISROMAN(0x002b),
	/* U+002C */	JISROMAN(0x002c),
	/* U+002D */	JISROMAN(0x002d),
	/* U+002E */	JISROMAN(0x002e),
	/* U+002F */	JISROMAN(0x002f),
	/* U+0030 */	JISROMAN(0x0030),
	/* U+0031 */	JISROMAN(0x0031),
	/* U+0032 */	JISROMAN(0x0032),
	/* U+0033 */	JISROMAN(0x0033),
	/* U+0034 */	JISROMAN(0x0034),
	/* U+0035 */	JISROMAN(0x0035),
	/* U+0036 */	JISROMAN(0x0036),
	/* U+0037 */	JISROMAN(0x0037),
	/* U+0038 */	JISROMAN(0x0038),
	/* U+0039 */	JISROMAN(0x0039),
	/* U+003A */	JISROMAN(0x003a),
	/* U+003B */	JISROMAN(0x003b),
	/* U+003C */	JISROMAN(0x003c),
	/* U+003D */	JISROMAN(0x003d),
	/* U+003E */	JISROMAN(0x003e),
	/* U+003F */	JISROMAN(0x003f),
	/* U+0040 */	JISROMAN(0x0040),
	/* U+0041 */	JISROMAN(0x0041),
	/* U+0042 */	JISROMAN(0x0042),
	/* U+0043 */	JISROMAN(0x0043),
	/* U+0044 */	JISROMAN(0x0044),
	/* U+0045 */	JISROMAN(0x0045),
	/* U+0046 */	JISROMAN(0x0046),
	/* U+0047 */	JISROMAN(0x0047),
	/* U+0048 */	JISROMAN(0x0048),
	/* U+0049 */	JISROMAN(0x0049),
	/* U+004A */	JISROMAN(0x004a),
	/* U+004B */	JISROMAN(0x004b),
	/* U+004C */	JISROMAN(0x004c),
	/* U+004D */	JISROMAN(0x004d),
	/* U+004E */	JISROMAN(0x004e),
	/* U+004F */	JISROMAN(0x004f),
	/* U+0050 */	JISROMAN(0x0050),
	/* U+0051 */	JISROMAN(0x0051),
	/* U+0052 */	JISROMAN(0x0052),
	/* U+0053 */	JISROMAN(0x0053),
	/* U+0054 */	JISROMAN(0x0054),
	/* U+0055 */	JISROMAN(0x0055),
	/* U+0056 */	JISROMAN(0x0056),
	/* U+0057 */	JISROMAN(0x0057),
	/* U+0058 */	JISROMAN(0x0058),
	/* U+0059 */	JISROMAN(0x0059),
	/* U+005A */	JISROMAN(0x005a),
	/* U+005B */	JISROMAN(0x005b),
	/* U+005C */	U2E_005C_DEST,
	/* U+005D */	JISROMAN(0x005d),
	/* U+005E */	JISROMAN(0x005e),
	/* U+005F */	JISROMAN(0x005f),
	/* U+0060 */	JISROMAN(0x0060),
	/* U+0061 */	JISROMAN(0x0061),
	/* U+0062 */	JISROMAN(0x0062),
	/* U+0063 */	JISROMAN(0x0063),
	/* U+0064 */	JISROMAN(0x0064),
	/* U+0065 */	JISROMAN(0x0065),
	/* U+0066 */	JISROMAN(0x0066),
	/* U+0067 */	JISROMAN(0x0067),
	/* U+0068 */	JISROMAN(0x0068),
	/* U+0069 */	JISROMAN(0x0069),
	/* U+006A */	JISROMAN(0x006a),
	/* U+006B */	JISROMAN(0x006b),
	/* U+006C */	JISROMAN(0x006c),
	/* U+006D */	JISROMAN(0x006d),
	/* U+006E */	JISROMAN(0x006e),
	/* U+006F */	JISROMAN(0x006f),
	/* U+0070 */	JISROMAN(0x0070),
	/* U+0071 */	JISROMAN(0x0071),
	/* U+0072 */	JISROMAN(0x0072),
	/* U+0073 */	JISROMAN(0x0073),
	/* U+0074 */	JISROMAN(0x0074),
	/* U+0075 */	JISROMAN(0x0075),
	/* U+0076 */	JISROMAN(0x0076),
	/* U+0077 */	JISROMAN(0x0077),
	/* U+0078 */	JISROMAN(0x0078),
	/* U+0079 */	JISROMAN(0x0079),
	/* U+007A */	JISROMAN(0x007a),
	/* U+007B */	JISROMAN(0x007b),
	/* U+007C */	JISROMAN(0x007c),
	/* U+007D */	JISROMAN(0x007d),
	/* U+007E */	U2E_007E_DEST,
	/* U+007F */	JISROMAN(0x007f),
	/* U+0080 */	U2E_NODEST_COLX,
	/* U+0081 */	U2E_NODEST_COLX,
	/* U+0082 */	U2E_NODEST_COLX,
	/* U+0083 */	U2E_NODEST_COLX,
	/* U+0084 */	U2E_NODEST_COLX,
	/* U+0085 */	U2E_NODEST_COLX,
	/* U+0086 */	U2E_NODEST_COLX,
	/* U+0087 */	U2E_NODEST_COLX,
	/* U+0088 */	U2E_NODEST_COLX,
	/* U+0089 */	U2E_NODEST_COLX,
	/* U+008A */	U2E_NODEST_COLX,
	/* U+008B */	U2E_NODEST_COLX,
	/* U+008C */	U2E_NODEST_COLX,
	/* U+008D */	U2E_NODEST_COLX,
	/* U+008E */	U2E_NODEST_COLX,
	/* U+008F */	U2E_NODEST_COLX,
	/* U+0090 */	U2E_NODEST_COLX,
	/* U+0091 */	U2E_NODEST_COLX,
	/* U+0092 */	U2E_NODEST_COLX,
	/* U+0093 */	U2E_NODEST_COLX,
	/* U+0094 */	U2E_NODEST_COLX,
	/* U+0095 */	U2E_NODEST_COLX,
	/* U+0096 */	U2E_NODEST_COLX,
	/* U+0097 */	U2E_NODEST_COLX,
	/* U+0098 */	U2E_NODEST_COLX,
	/* U+0099 */	U2E_NODEST_COLX,
	/* U+009A */	U2E_NODEST_COLX,
	/* U+009B */	U2E_NODEST_COLX,
	/* U+009C */	U2E_NODEST_COLX,
	/* U+009D */	U2E_NODEST_COLX,
	/* U+009E */	U2E_NODEST_COLX,
	/* U+009F */	U2E_NODEST_COLX,
	/* U+00A0 */	IFX0213(JISX0213_1(0xa9a2),	U2E_NODEST_COLX),
	/* U+00A1 */	IFX0213(JISX0213_1(0xa9a3),	JISX0212(0xa242)),
	/* U+00A2 */	U2E_00A2_DEST,
	/* U+00A3 */	U2E_00A3_DEST,
	/* U+00A4 */	IFX0213(JISX0213_1(0xa9a4),	JISX0212(0xa270)),
	/* U+00A5 */	U2E_00A5_DEST,
	/* U+00A6 */	U2E_00A6_DEST,
	/* U+00A7 */	JISX0208(0xa1f8),
	/* U+00A8 */	JISX0208(0xa1af),
	/* U+00A9 */	IFX0213(JISX0213_1(0xa9a6),	JISX0212(0xa26d)),
	/* U+00AA */	IFX0213(JISX0213_1(0xa9a7),	JISX0212(0xa26c)),
	/* U+00AB */	IFX0213(JISX0213_1(0xa9a8),	U2E_NODEST_COLX),
	/* U+00AC */	U2E_00AC_DEST,
	/* U+00AD */	IFX0213(JISX0213_1(0xa9a9),	U2E_NODEST_COLX),
	/* U+00AE */	IFX0213(JISX0213_1(0xa9aa),	JISX0212(0xa26e)),
	/* U+00AF */	IFX0213(JISX0213_1(0xa9ab),	JISX0212(0xa234)),
	/* U+00B0 */	JISX0208(0xa1eb),
	/* U+00B1 */	JISX0208(0xa1de),
	/* U+00B2 */	IFX0213(JISX0213_1(0xa9ac),	U2E_NODEST_COLX),
	/* U+00B3 */	IFX0213(JISX0213_1(0xa9ad),	U2E_NODEST_COLX),
	/* U+00B4 */	JISX0208(0xa1ad),
	/* U+00B5 */	U2E_NODEST_COLX,
	/* U+00B6 */	JISX0208(0xa2f9),
	/* U+00B7 */	IFX0213(JISX0213_1(0xa9ae),	U2E_NODEST_COLX),
	/* U+00B8 */	IFX0213(JISX0213_1(0xa9af),	JISX0212(0xa231)),
	/* U+00B9 */	IFX0213(JISX0213_1(0xa9b0),	U2E_NODEST_COLX),
	/* U+00BA */	IFX0213(JISX0213_1(0xa9b1),	JISX0212(0xa26b)),
	/* U+00BB */	IFX0213(JISX0213_1(0xa9b2),	U2E_NODEST_COLX),
	/* U+00BC */	IFX0213(JISX0213_1(0xa9b3),	U2E_NODEST_COLX),
	/* U+00BD */	IFX0213(JISX0213_1(0xa9b4),	U2E_NODEST_COLX),
	/* U+00BE */	IFX0213(JISX0213_1(0xa9b5),	U2E_NODEST_COLX),
	/* U+00BF */	IFX0213(JISX0213_1(0xa9b6),	JISX0212(0xa244)),
	/* U+00C0 */	IFX0213(JISX0213_1(0xa9b7),	JISX0212(0xaa22)),
	/* U+00C1 */	IFX0213(JISX0213_1(0xa9b8),	JISX0212(0xaa21)),
	/* U+00C2 */	IFX0213(JISX0213_1(0xa9b9),	JISX0212(0xaa24)),
	/* U+00C3 */	IFX0213(JISX0213_1(0xa9ba),	JISX0212(0xaa2a)),
	/* U+00C4 */	IFX0213(JISX0213_1(0xa9bb),	JISX0212(0xaa23)),
	/* U+00C5 */	IFX0213(JISX0213_1(0xa9bc),	JISX0212(0xaa29)),
	/* U+00C6 */	IFX0213(JISX0213_1(0xa9bd),	JISX0212(0xa921)),
	/* U+00C7 */	IFX0213(JISX0213_1(0xa9be),	JISX0212(0xaa2e)),
	/* U+00C8 */	IFX0213(JISX0213_1(0xa9bf),	JISX0212(0xaa32)),
	/* U+00C9 */	IFX0213(JISX0213_1(0xa9c0),	JISX0212(0xaa31)),
	/* U+00CA */	IFX0213(JISX0213_1(0xa9c1),	JISX0212(0xaa34)),
	/* U+00CB */	IFX0213(JISX0213_1(0xa9c2),	JISX0212(0xaa33)),
	/* U+00CC */	IFX0213(JISX0213_1(0xa9c3),	JISX0212(0xaa40)),
	/* U+00CD */	IFX0213(JISX0213_1(0xa9c4),	JISX0212(0xaa3f)),
	/* U+00CE */	IFX0213(JISX0213_1(0xa9c5),	JISX0212(0xaa42)),
	/* U+00CF */	IFX0213(JISX0213_1(0xa9c6),	JISX0212(0xaa41)),
	/* U+00D0 */	IFX0213(JISX0213_1(0xa9c7),	U2E_NODEST_COLX),
	/* U+00D1 */	IFX0213(JISX0213_1(0xa9c8),	JISX0212(0xaa50)),
	/* U+00D2 */	IFX0213(JISX0213_1(0xa9c9),	JISX0212(0xaa52)),
	/* U+00D3 */	IFX0213(JISX0213_1(0xa9ca),	JISX0212(0xaa51)),
	/* U+00D4 */	IFX0213(JISX0213_1(0xa9cb),	JISX0212(0xaa54)),
	/* U+00D5 */	IFX0213(JISX0213_1(0xa9cc),	JISX0212(0xaa58)),
	/* U+00D6 */	IFX0213(JISX0213_1(0xa9cd),	JISX0212(0xaa53)),
	/* U+00D7 */	JISX0208(0xa1df),
	/* U+00D8 */	IFX0213(JISX0213_1(0xa9ce),	JISX0212(0xa92c)),
	/* U+00D9 */	IFX0213(JISX0213_1(0xa9cf),	JISX0212(0xaa63)),
	/* U+00DA */	IFX0213(JISX0213_1(0xa9d0),	JISX0212(0xaa62)),
	/* U+00DB */	IFX0213(JISX0213_1(0xa9d1),	JISX0212(0xaa65)),
	/* U+00DC */	IFX0213(JISX0213_1(0xa9d2),	JISX0212(0xaa64)),
	/* U+00DD */	IFX0213(JISX0213_1(0xa9d3),	JISX0212(0xaa72)),
	/* U+00DE */	IFX0213(JISX0213_1(0xa9d4),	JISX0212(0xa930)),
	/* U+00DF */	IFX0213(JISX0213_1(0xa9d5),	JISX0212(0xa94e)),
	/* U+00E0 */	IFX0213(JISX0213_1(0xa9d6),	JISX0212(0xab22)),
	/* U+00E1 */	IFX0213(JISX0213_1(0xa9d7),	JISX0212(0xab21)),
	/* U+00E2 */	IFX0213(JISX0213_1(0xa9d8),	JISX0212(0xab24)),
	/* U+00E3 */	IFX0213(JISX0213_1(0xa9d9),	JISX0212(0xab2a)),
	/* U+00E4 */	IFX0213(JISX0213_1(0xa9da),	JISX0212(0xab23)),
	/* U+00E5 */	IFX0213(JISX0213_1(0xa9db),	JISX0212(0xab29)),
	/* U+00E6 */	IFX0213(JISX0213_1(0xa9dc),	JISX0212(0xa941)),
	/* U+00E7 */	IFX0213(JISX0213_1(0xa9dd),	JISX0212(0xab2e)),
	/* U+00E8 */	IFX0213(JISX0213_1(0xa9de),	JISX0212(0xab32)),
	/* U+00E9 */	IFX0213(JISX0213_1(0xa9df),	JISX0212(0xab31)),
	/* U+00EA */	IFX0213(JISX0213_1(0xa9e0),	JISX0212(0xab34)),
	/* U+00EB */	IFX0213(JISX0213_1(0xa9e1),	JISX0212(0xab33)),
	/* U+00EC */	IFX0213(JISX0213_1(0xa9e2),	JISX0212(0xab40)),
	/* U+00ED */	IFX0213(JISX0213_1(0xa9e3),	JISX0212(0xab3f)),
	/* U+00EE */	IFX0213(JISX0213_1(0xa9e4),	JISX0212(0xab42)),
	/* U+00EF */	IFX0213(JISX0213_1(0xa9e5),	JISX0212(0xab41)),
	/* U+00F0 */	IFX0213(JISX0213_1(0xa9e6),	JISX0212(0xa943)),
	/* U+00F1 */	IFX0213(JISX0213_1(0xa9e7),	JISX0212(0xab50)),
	/* U+00F2 */	IFX0213(JISX0213_1(0xa9e8),	JISX0212(0xab52)),
	/* U+00F3 */	IFX0213(JISX0213_1(0xa9e9),	JISX0212(0xab51)),
	/* U+00F4 */	IFX0213(JISX0213_1(0xa9ea),	JISX0212(0xab54)),
	/* U+00F5 */	IFX0213(JISX0213_1(0xa9eb),	JISX0212(0xab58)),
	/* U+00F6 */	IFX0213(JISX0213_1(0xa9ec),	JISX0212(0xab53)),
	/* U+00F7 */	JISX0208(0xa1e0),
	/* U+00F8 */	IFX0213(JISX0213_1(0xa9ed),	JISX0212(0xa94c)),
	/* U+00F9 */	IFX0213(JISX0213_1(0xa9ee),	JISX0212(0xab63)),
	/* U+00FA */	IFX0213(JISX0213_1(0xa9ef),	JISX0212(0xab62)),
	/* U+00FB */	IFX0213(JISX0213_1(0xa9f0),	JISX0212(0xab65)),
	/* U+00FC */	IFX0213(JISX0213_1(0xa9f1),	JISX0212(0xab64)),
	/* U+00FD */	IFX0213(JISX0213_1(0xa9f2),	JISX0212(0xab72)),
	/* U+00FE */	IFX0213(JISX0213_1(0xa9f3),	JISX0212(0xa950)),
	/* U+00FF */	IFX0213(JISX0213_1(0xa9f4),	JISX0212(0xab73)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_01[] = {
	/* U+0100 */	IFX0213(JISX0213_1(0xa9f5),	JISX0212(0xaa27)),
	/* U+0101 */	IFX0213(JISX0213_1(0xa9fa),	JISX0212(0xab27)),
	/* U+0102 */	IFX0213(JISX0213_1(0xaaba),	JISX0212(0xaa25)),
	/* U+0103 */	IFX0213(JISX0213_1(0xaac9),	JISX0212(0xab25)),
	/* U+0104 */	IFX0213(JISX0213_1(0xaaa1),	JISX0212(0xaa28)),
	/* U+0105 */	IFX0213(JISX0213_1(0xaaac),	JISX0212(0xab28)),
	/* U+0106 */	IFX0213(JISX0213_1(0xaabc),	JISX0212(0xaa2b)),
	/* U+0107 */	IFX0213(JISX0213_1(0xaacb),	JISX0212(0xab2b)),
	/* U+0108 */	IFX0213(JISX0213_1(0xaad9),	JISX0212(0xaa2c)),
	/* U+0109 */	IFX0213(JISX0213_1(0xaadf),	JISX0212(0xab2c)),
	/* U+010A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa2f)),
	/* U+010B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab2f)),
	/* U+010C */	IFX0213(JISX0213_1(0xaabd),	JISX0212(0xaa2d)),
	/* U+010D */	IFX0213(JISX0213_1(0xaacc),	JISX0212(0xab2d)),
	/* U+010E */	IFX0213(JISX0213_1(0xaac0),	JISX0212(0xaa30)),
	/* U+010F */	IFX0213(JISX0213_1(0xaacf),	JISX0212(0xab30)),
	/* U+0110 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa922)),
	/* U+0111 */	IFX0213(JISX0213_1(0xaad0),	JISX0212(0xa942)),
	/* U+0112 */	IFX0213(JISX0213_1(0xa9f8),	JISX0212(0xaa37)),
	/* U+0113 */	IFX0213(JISX0213_1(0xa9fd),	JISX0212(0xab37)),
	/* U+0114 */	U2E_NODEST_COLX,
	/* U+0115 */	U2E_NODEST_COLX,
	/* U+0116 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa36)),
	/* U+0117 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab36)),
	/* U+0118 */	IFX0213(JISX0213_1(0xaabe),	JISX0212(0xaa38)),
	/* U+0119 */	IFX0213(JISX0213_1(0xaacd),	JISX0212(0xab38)),
	/* U+011A */	IFX0213(JISX0213_1(0xaabf),	JISX0212(0xaa35)),
	/* U+011B */	IFX0213(JISX0213_1(0xaace),	JISX0212(0xab35)),
	/* U+011C */	IFX0213(JISX0213_1(0xaada),	JISX0212(0xaa3a)),
	/* U+011D */	IFX0213(JISX0213_1(0xaae0),	JISX0212(0xab3a)),
	/* U+011E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa3b)),
	/* U+011F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab3b)),
	/* U+0120 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa3d)),
	/* U+0121 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab3d)),
	/* U+0122 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa3c)),
	/* U+0123 */	U2E_NODEST_COLX,
	/* U+0124 */	IFX0213(JISX0213_1(0xaadb),	JISX0212(0xaa3e)),
	/* U+0125 */	IFX0213(JISX0213_1(0xaae1),	JISX0212(0xab3e)),
	/* U+0126 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa924)),
	/* U+0127 */	IFX0213(JISX0213_1(0xaafd),	JISX0212(0xa944)),
	/* U+0128 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa47)),
	/* U+0129 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab47)),
	/* U+012A */	IFX0213(JISX0213_1(0xa9f6),	JISX0212(0xaa45)),
	/* U+012B */	IFX0213(JISX0213_1(0xa9fb),	JISX0212(0xab45)),
	/* U+012C */	U2E_NODEST_COLX,
	/* U+012D */	U2E_NODEST_COLX,
	/* U+012E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa46)),
	/* U+012F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab46)),
	/* U+0130 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa44)),
	/* U+0131 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa945)),
	/* U+0132 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa926)),
	/* U+0133 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa946)),
	/* U+0134 */	IFX0213(JISX0213_1(0xaadc),	JISX0212(0xaa48)),
	/* U+0135 */	IFX0213(JISX0213_1(0xaae2),	JISX0212(0xab48)),
	/* U+0136 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa49)),
	/* U+0137 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab49)),
	/* U+0138 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa947)),
	/* U+0139 */	IFX0213(JISX0213_1(0xaabb),	JISX0212(0xaa4a)),
	/* U+013A */	IFX0213(JISX0213_1(0xaaca),	JISX0212(0xab4a)),
	/* U+013B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa4c)),
	/* U+013C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab4c)),
	/* U+013D */	IFX0213(JISX0213_1(0xaaa4),	JISX0212(0xaa4b)),
	/* U+013E */	IFX0213(JISX0213_1(0xaaaf),	JISX0212(0xab4b)),
	/* U+013F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa929)),
	/* U+0140 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa949)),
	/* U+0141 */	IFX0213(JISX0213_1(0xaaa3),	JISX0212(0xa928)),
	/* U+0142 */	IFX0213(JISX0213_1(0xaaae),	JISX0212(0xa948)),
	/* U+0143 */	IFX0213(JISX0213_1(0xaac1),	JISX0212(0xaa4d)),
	/* U+0144 */	IFX0213(JISX0213_1(0xaad1),	JISX0212(0xab4d)),
	/* U+0145 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa4f)),
	/* U+0146 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab4f)),
	/* U+0147 */	IFX0213(JISX0213_1(0xaac2),	JISX0212(0xaa4e)),
	/* U+0148 */	IFX0213(JISX0213_1(0xaad2),	JISX0212(0xab4e)),
	/* U+0149 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa94a)),
	/* U+014A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa92b)),
	/* U+014B */	IFX0213(JISX0213_1(0xaafa),	JISX0212(0xa94b)),
	/* U+014C */	IFX0213(JISX0213_1(0xa9f9),	JISX0212(0xaa57)),
	/* U+014D */	IFX0213(JISX0213_1(0xa9fe),	JISX0212(0xab57)),
	/* U+014E */	U2E_NODEST_COLX,
	/* U+014F */	U2E_NODEST_COLX,
	/* U+0150 */	IFX0213(JISX0213_1(0xaac3),	JISX0212(0xaa56)),
	/* U+0151 */	IFX0213(JISX0213_1(0xaad3),	JISX0212(0xab56)),
	/* U+0152 */	IFX0213(JISX0213_1(0xabab),	JISX0212(0xa92d)),
	/* U+0153 */	IFX0213(JISX0213_1(0xabaa),	JISX0212(0xa94d)),
	/* U+0154 */	IFX0213(JISX0213_1(0xaab9),	JISX0212(0xaa59)),
	/* U+0155 */	IFX0213(JISX0213_1(0xaac8),	JISX0212(0xab59)),
	/* U+0156 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa5b)),
	/* U+0157 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab5b)),
	/* U+0158 */	IFX0213(JISX0213_1(0xaac4),	JISX0212(0xaa5a)),
	/* U+0159 */	IFX0213(JISX0213_1(0xaad4),	JISX0212(0xab5a)),
	/* U+015A */	IFX0213(JISX0213_1(0xaaa5),	JISX0212(0xaa5c)),
	/* U+015B */	IFX0213(JISX0213_1(0xaab0),	JISX0212(0xab5c)),
	/* U+015C */	IFX0213(JISX0213_1(0xaadd),	JISX0212(0xaa5d)),
	/* U+015D */	IFX0213(JISX0213_1(0xaae3),	JISX0212(0xab5d)),
	/* U+015E */	IFX0213(JISX0213_1(0xaaa7),	JISX0212(0xaa5f)),
	/* U+015F */	IFX0213(JISX0213_1(0xaab3),	JISX0212(0xab5f)),
	/* U+0160 */	IFX0213(JISX0213_1(0xaaa6),	JISX0212(0xaa5e)),
	/* U+0161 */	IFX0213(JISX0213_1(0xaab2),	JISX0212(0xab5e)),
	/* U+0162 */	IFX0213(JISX0213_1(0xaac7),	JISX0212(0xaa61)),
	/* U+0163 */	IFX0213(JISX0213_1(0xaad7),	JISX0212(0xab61)),
	/* U+0164 */	IFX0213(JISX0213_1(0xaaa8),	JISX0212(0xaa60)),
	/* U+0165 */	IFX0213(JISX0213_1(0xaab4),	JISX0212(0xab60)),
	/* U+0166 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa92f)),
	/* U+0167 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa94f)),
	/* U+0168 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa6c)),
	/* U+0169 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab6c)),
	/* U+016A */	IFX0213(JISX0213_1(0xa9f7),	JISX0212(0xaa69)),
	/* U+016B */	IFX0213(JISX0213_1(0xa9fc),	JISX0212(0xab69)),
	/* U+016C */	IFX0213(JISX0213_1(0xaade),	JISX0212(0xaa66)),
	/* U+016D */	IFX0213(JISX0213_1(0xaae4),	JISX0212(0xab66)),
	/* U+016E */	IFX0213(JISX0213_1(0xaac5),	JISX0212(0xaa6b)),
	/* U+016F */	IFX0213(JISX0213_1(0xaad5),	JISX0212(0xab6b)),
	/* U+0170 */	IFX0213(JISX0213_1(0xaac6),	JISX0212(0xaa68)),
	/* U+0171 */	IFX0213(JISX0213_1(0xaad6),	JISX0212(0xab68)),
	/* U+0172 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa6a)),
	/* U+0173 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab6a)),
	/* U+0174 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa71)),
	/* U+0175 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab71)),
	/* U+0176 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa74)),
	/* U+0177 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab74)),
	/* U+0178 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa73)),
	/* U+0179 */	IFX0213(JISX0213_1(0xaaa9),	JISX0212(0xaa75)),
	/* U+017A */	IFX0213(JISX0213_1(0xaab5),	JISX0212(0xab75)),
	/* U+017B */	IFX0213(JISX0213_1(0xaaab),	JISX0212(0xaa77)),
	/* U+017C */	IFX0213(JISX0213_1(0xaab8),	JISX0212(0xab77)),
	/* U+017D */	IFX0213(JISX0213_1(0xaaaa),	JISX0212(0xaa76)),
	/* U+017E */	IFX0213(JISX0213_1(0xaab7),	JISX0212(0xab76)),
	/* U+017F */	U2E_NODEST_COLX,
	/* U+0180 */	U2E_NODEST_COLX,
	/* U+0181 */	U2E_NODEST_COLX,
	/* U+0182 */	U2E_NODEST_COLX,
	/* U+0183 */	U2E_NODEST_COLX,
	/* U+0184 */	U2E_NODEST_COLX,
	/* U+0185 */	U2E_NODEST_COLX,
	/* U+0186 */	U2E_NODEST_COLX,
	/* U+0187 */	U2E_NODEST_COLX,
	/* U+0188 */	U2E_NODEST_COLX,
	/* U+0189 */	U2E_NODEST_COLX,
	/* U+018A */	U2E_NODEST_COLX,
	/* U+018B */	U2E_NODEST_COLX,
	/* U+018C */	U2E_NODEST_COLX,
	/* U+018D */	U2E_NODEST_COLX,
	/* U+018E */	U2E_NODEST_COLX,
	/* U+018F */	U2E_NODEST_COLX,
	/* U+0190 */	U2E_NODEST_COLX,
	/* U+0191 */	U2E_NODEST_COLX,
	/* U+0192 */	U2E_NODEST_COLX,
	/* U+0193 */	IFX0213(JISX0213_1(0xaba9),	U2E_NODEST_COLX),
	/* U+0194 */	U2E_NODEST_COLX,
	/* U+0195 */	U2E_NODEST_COLX,
	/* U+0196 */	U2E_NODEST_COLX,
	/* U+0197 */	U2E_NODEST_COLX,
	/* U+0198 */	U2E_NODEST_COLX,
	/* U+0199 */	U2E_NODEST_COLX,
	/* U+019A */	U2E_NODEST_COLX,
	/* U+019B */	U2E_NODEST_COLX,
	/* U+019C */	U2E_NODEST_COLX,
	/* U+019D */	U2E_NODEST_COLX,
	/* U+019E */	U2E_NODEST_COLX,
	/* U+019F */	U2E_NODEST_COLX,
	/* U+01A0 */	U2E_NODEST_COLX,
	/* U+01A1 */	U2E_NODEST_COLX,
	/* U+01A2 */	U2E_NODEST_COLX,
	/* U+01A3 */	U2E_NODEST_COLX,
	/* U+01A4 */	U2E_NODEST_COLX,
	/* U+01A5 */	U2E_NODEST_COLX,
	/* U+01A6 */	U2E_NODEST_COLX,
	/* U+01A7 */	U2E_NODEST_COLX,
	/* U+01A8 */	U2E_NODEST_COLX,
	/* U+01A9 */	U2E_NODEST_COLX,
	/* U+01AA */	U2E_NODEST_COLX,
	/* U+01AB */	U2E_NODEST_COLX,
	/* U+01AC */	U2E_NODEST_COLX,
	/* U+01AD */	U2E_NODEST_COLX,
	/* U+01AE */	U2E_NODEST_COLX,
	/* U+01AF */	U2E_NODEST_COLX,
	/* U+01B0 */	U2E_NODEST_COLX,
	/* U+01B1 */	U2E_NODEST_COLX,
	/* U+01B2 */	U2E_NODEST_COLX,
	/* U+01B3 */	U2E_NODEST_COLX,
	/* U+01B4 */	U2E_NODEST_COLX,
	/* U+01B5 */	U2E_NODEST_COLX,
	/* U+01B6 */	U2E_NODEST_COLX,
	/* U+01B7 */	U2E_NODEST_COLX,
	/* U+01B8 */	U2E_NODEST_COLX,
	/* U+01B9 */	U2E_NODEST_COLX,
	/* U+01BA */	U2E_NODEST_COLX,
	/* U+01BB */	U2E_NODEST_COLX,
	/* U+01BC */	U2E_NODEST_COLX,
	/* U+01BD */	U2E_NODEST_COLX,
	/* U+01BE */	U2E_NODEST_COLX,
	/* U+01BF */	U2E_NODEST_COLX,
	/* U+01C0 */	U2E_NODEST_COLX,
	/* U+01C1 */	U2E_NODEST_COLX,
	/* U+01C2 */	IFX0213(JISX0213_1(0xaba4),	U2E_NODEST_COLX),
	/* U+01C3 */	U2E_NODEST_COLX,
	/* U+01C4 */	U2E_NODEST_COLX,
	/* U+01C5 */	U2E_NODEST_COLX,
	/* U+01C6 */	U2E_NODEST_COLX,
	/* U+01C7 */	U2E_NODEST_COLX,
	/* U+01C8 */	U2E_NODEST_COLX,
	/* U+01C9 */	U2E_NODEST_COLX,
	/* U+01CA */	U2E_NODEST_COLX,
	/* U+01CB */	U2E_NODEST_COLX,
	/* U+01CC */	U2E_NODEST_COLX,
	/* U+01CD */	IFX0213(JISX0213_1(0xa8ef),	JISX0212(0xaa26)),
	/* U+01CE */	IFX0213(JISX0213_1(0xa8f0),	JISX0212(0xab26)),
	/* U+01CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa43)),
	/* U+01D0 */	IFX0213(JISX0213_1(0xa8f1),	JISX0212(0xab43)),
	/* U+01D1 */	IFX0213(JISX0213_1(0xa8f6),	JISX0212(0xaa55)),
	/* U+01D2 */	IFX0213(JISX0213_1(0xa8f7),	JISX0212(0xab55)),
	/* U+01D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa67)),
	/* U+01D4 */	IFX0213(JISX0213_1(0xa8f8),	JISX0212(0xab67)),
	/* U+01D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa70)),
	/* U+01D6 */	IFX0213(JISX0213_1(0xa8f9),	JISX0212(0xab70)),
	/* U+01D7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa6d)),
	/* U+01D8 */	IFX0213(JISX0213_1(0xa8fa),	JISX0212(0xab6d)),
	/* U+01D9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa6f)),
	/* U+01DA */	IFX0213(JISX0213_1(0xa8fb),	JISX0212(0xab6f)),
	/* U+01DB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xaa6e)),
	/* U+01DC */	IFX0213(JISX0213_1(0xa8fc),	JISX0212(0xab6e)),
	/* U+01DD */	U2E_NODEST_COLX,
	/* U+01DE */	U2E_NODEST_COLX,
	/* U+01DF */	U2E_NODEST_COLX,
	/* U+01E0 */	U2E_NODEST_COLX,
	/* U+01E1 */	U2E_NODEST_COLX,
	/* U+01E2 */	U2E_NODEST_COLX,
	/* U+01E3 */	U2E_NODEST_COLX,
	/* U+01E4 */	U2E_NODEST_COLX,
	/* U+01E5 */	U2E_NODEST_COLX,
	/* U+01E6 */	U2E_NODEST_COLX,
	/* U+01E7 */	U2E_NODEST_COLX,
	/* U+01E8 */	U2E_NODEST_COLX,
	/* U+01E9 */	U2E_NODEST_COLX,
	/* U+01EA */	U2E_NODEST_COLX,
	/* U+01EB */	U2E_NODEST_COLX,
	/* U+01EC */	U2E_NODEST_COLX,
	/* U+01ED */	U2E_NODEST_COLX,
	/* U+01EE */	U2E_NODEST_COLX,
	/* U+01EF */	U2E_NODEST_COLX,
	/* U+01F0 */	U2E_NODEST_COLX,
	/* U+01F1 */	U2E_NODEST_COLX,
	/* U+01F2 */	U2E_NODEST_COLX,
	/* U+01F3 */	U2E_NODEST_COLX,
	/* U+01F4 */	U2E_NODEST_COLX,
	/* U+01F5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xab39)),
	/* U+01F6 */	U2E_NODEST_COLX,
	/* U+01F7 */	U2E_NODEST_COLX,
	/* U+01F8 */	IFX0213(JISX0213_1(0xa8f4),	U2E_NODEST_COLX),
	/* U+01F9 */	IFX0213(JISX0213_1(0xa8f5),	U2E_NODEST_COLX),
	/* U+01FA */	U2E_NODEST_COLX,
	/* U+01FB */	U2E_NODEST_COLX,
	/* U+01FC */	U2E_NODEST_COLX,
	/* U+01FD */	IFX0213(JISX0213_1(0xabc5),	U2E_NODEST_COLX),
	/* U+01FE */	U2E_NODEST_COLX,
	/* U+01FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_02[] = {
	/* U+0200 */	U2E_NODEST_COLX,
	/* U+0201 */	U2E_NODEST_COLX,
	/* U+0202 */	U2E_NODEST_COLX,
	/* U+0203 */	U2E_NODEST_COLX,
	/* U+0204 */	U2E_NODEST_COLX,
	/* U+0205 */	U2E_NODEST_COLX,
	/* U+0206 */	U2E_NODEST_COLX,
	/* U+0207 */	U2E_NODEST_COLX,
	/* U+0208 */	U2E_NODEST_COLX,
	/* U+0209 */	U2E_NODEST_COLX,
	/* U+020A */	U2E_NODEST_COLX,
	/* U+020B */	U2E_NODEST_COLX,
	/* U+020C */	U2E_NODEST_COLX,
	/* U+020D */	U2E_NODEST_COLX,
	/* U+020E */	U2E_NODEST_COLX,
	/* U+020F */	U2E_NODEST_COLX,
	/* U+0210 */	U2E_NODEST_COLX,
	/* U+0211 */	U2E_NODEST_COLX,
	/* U+0212 */	U2E_NODEST_COLX,
	/* U+0213 */	U2E_NODEST_COLX,
	/* U+0214 */	U2E_NODEST_COLX,
	/* U+0215 */	U2E_NODEST_COLX,
	/* U+0216 */	U2E_NODEST_COLX,
	/* U+0217 */	U2E_NODEST_COLX,
	/* U+0218 */	U2E_NODEST_COLX,
	/* U+0219 */	U2E_NODEST_COLX,
	/* U+021A */	U2E_NODEST_COLX,
	/* U+021B */	U2E_NODEST_COLX,
	/* U+021C */	U2E_NODEST_COLX,
	/* U+021D */	U2E_NODEST_COLX,
	/* U+021E */	U2E_NODEST_COLX,
	/* U+021F */	U2E_NODEST_COLX,
	/* U+0220 */	U2E_NODEST_COLX,
	/* U+0221 */	U2E_NODEST_COLX,
	/* U+0222 */	U2E_NODEST_COLX,
	/* U+0223 */	U2E_NODEST_COLX,
	/* U+0224 */	U2E_NODEST_COLX,
	/* U+0225 */	U2E_NODEST_COLX,
	/* U+0226 */	U2E_NODEST_COLX,
	/* U+0227 */	U2E_NODEST_COLX,
	/* U+0228 */	U2E_NODEST_COLX,
	/* U+0229 */	U2E_NODEST_COLX,
	/* U+022A */	U2E_NODEST_COLX,
	/* U+022B */	U2E_NODEST_COLX,
	/* U+022C */	U2E_NODEST_COLX,
	/* U+022D */	U2E_NODEST_COLX,
	/* U+022E */	U2E_NODEST_COLX,
	/* U+022F */	U2E_NODEST_COLX,
	/* U+0230 */	U2E_NODEST_COLX,
	/* U+0231 */	U2E_NODEST_COLX,
	/* U+0232 */	U2E_NODEST_COLX,
	/* U+0233 */	U2E_NODEST_COLX,
	/* U+0234 */	U2E_NODEST_COLX,
	/* U+0235 */	U2E_NODEST_COLX,
	/* U+0236 */	U2E_NODEST_COLX,
	/* U+0237 */	U2E_NODEST_COLX,
	/* U+0238 */	U2E_NODEST_COLX,
	/* U+0239 */	U2E_NODEST_COLX,
	/* U+023A */	U2E_NODEST_COLX,
	/* U+023B */	U2E_NODEST_COLX,
	/* U+023C */	U2E_NODEST_COLX,
	/* U+023D */	U2E_NODEST_COLX,
	/* U+023E */	U2E_NODEST_COLX,
	/* U+023F */	U2E_NODEST_COLX,
	/* U+0240 */	U2E_NODEST_COLX,
	/* U+0241 */	U2E_NODEST_COLX,
	/* U+0242 */	U2E_NODEST_COLX,
	/* U+0243 */	U2E_NODEST_COLX,
	/* U+0244 */	U2E_NODEST_COLX,
	/* U+0245 */	U2E_NODEST_COLX,
	/* U+0246 */	U2E_NODEST_COLX,
	/* U+0247 */	U2E_NODEST_COLX,
	/* U+0248 */	U2E_NODEST_COLX,
	/* U+0249 */	U2E_NODEST_COLX,
	/* U+024A */	U2E_NODEST_COLX,
	/* U+024B */	U2E_NODEST_COLX,
	/* U+024C */	U2E_NODEST_COLX,
	/* U+024D */	U2E_NODEST_COLX,
	/* U+024E */	U2E_NODEST_COLX,
	/* U+024F */	U2E_NODEST_COLX,
	/* U+0250 */	IFX0213(JISX0213_1(0xabb3),	U2E_NODEST_COLX),
	/* U+0251 */	IFX0213(JISX0213_1(0xabb9),	U2E_NODEST_COLX),
	/* U+0252 */	IFX0213(JISX0213_1(0xabba),	U2E_NODEST_COLX),
	/* U+0253 */	IFX0213(JISX0213_1(0xaba5),	U2E_NODEST_COLX),
	/* U+0254 */	IFX0213(JISX0213_1(0xabb8),	U2E_NODEST_COLX),
	/* U+0255 */	IFX0213(JISX0213_1(0xabbf),	U2E_NODEST_COLX),
	/* U+0256 */	IFX0213(JISX0213_1(0xaaee),	U2E_NODEST_COLX),
	/* U+0257 */	IFX0213(JISX0213_1(0xaba6),	U2E_NODEST_COLX),
	/* U+0258 */	IFX0213(JISX0213_1(0xabae),	U2E_NODEST_COLX),
	/* U+0259 */	IFX0213(JISX0213_1(0xabb0),	U2E_NODEST_COLX),
	/* U+025A */	IFX0213(JISX0213_1(0xabc3),	U2E_NODEST_COLX),
	/* U+025B */	U2E_NODEST_COLX,
	/* U+025C */	IFX0213(JISX0213_1(0xabb1),	U2E_NODEST_COLX),
	/* U+025D */	U2E_NODEST_COLX,
	/* U+025E */	IFX0213(JISX0213_1(0xabb2),	U2E_NODEST_COLX),
	/* U+025F */	IFX0213(JISX0213_1(0xaaf5),	U2E_NODEST_COLX),
	/* U+0260 */	IFX0213(JISX0213_1(0xaba8),	U2E_NODEST_COLX),
	/* U+0261 */	IFX0213(JISX0213_1(0xaaf9),	U2E_NODEST_COLX),
	/* U+0262 */	U2E_NODEST_COLX,
	/* U+0263 */	U2E_NODEST_COLX,
	/* U+0264 */	IFX0213(JISX0213_1(0xabb6),	U2E_NODEST_COLX),
	/* U+0265 */	IFX0213(JISX0213_1(0xabbc),	U2E_NODEST_COLX),
	/* U+0266 */	IFX0213(JISX0213_1(0xaba2),	U2E_NODEST_COLX),
	/* U+0267 */	IFX0213(JISX0213_1(0xabc2),	U2E_NODEST_COLX),
	/* U+0268 */	IFX0213(JISX0213_1(0xabac),	U2E_NODEST_COLX),
	/* U+0269 */	U2E_NODEST_COLX,
	/* U+026A */	U2E_NODEST_COLX,
	/* U+026B */	U2E_NODEST_COLX,
	/* U+026C */	IFX0213(JISX0213_1(0xaaea),	U2E_NODEST_COLX),
	/* U+026D */	IFX0213(JISX0213_1(0xaaf4),	U2E_NODEST_COLX),
	/* U+026E */	IFX0213(JISX0213_1(0xaaeb),	U2E_NODEST_COLX),
	/* U+026F */	IFX0213(JISX0213_1(0xabb4),	U2E_NODEST_COLX),
	/* U+0270 */	IFX0213(JISX0213_1(0xaafb),	U2E_NODEST_COLX),
	/* U+0271 */	IFX0213(JISX0213_1(0xaae5),	U2E_NODEST_COLX),
	/* U+0272 */	IFX0213(JISX0213_1(0xaaf6),	U2E_NODEST_COLX),
	/* U+0273 */	IFX0213(JISX0213_1(0xaaef),	U2E_NODEST_COLX),
	/* U+0274 */	U2E_NODEST_COLX,
	/* U+0275 */	IFX0213(JISX0213_1(0xabaf),	U2E_NODEST_COLX),
	/* U+0276 */	U2E_NODEST_COLX,
	/* U+0277 */	U2E_NODEST_COLX,
	/* U+0278 */	U2E_NODEST_COLX,
	/* U+0279 */	IFX0213(JISX0213_1(0xaaec),	U2E_NODEST_COLX),
	/* U+027A */	IFX0213(JISX0213_1(0xabc1),	U2E_NODEST_COLX),
	/* U+027B */	IFX0213(JISX0213_1(0xaaf3),	U2E_NODEST_COLX),
	/* U+027C */	U2E_NODEST_COLX,
	/* U+027D */	IFX0213(JISX0213_1(0xaaf0),	U2E_NODEST_COLX),
	/* U+027E */	IFX0213(JISX0213_1(0xaae7),	U2E_NODEST_COLX),
	/* U+027F */	U2E_NODEST_COLX,
	/* U+0280 */	U2E_NODEST_COLX,
	/* U+0281 */	IFX0213(JISX0213_1(0xaafc),	U2E_NODEST_COLX),
	/* U+0282 */	IFX0213(JISX0213_1(0xaaf1),	U2E_NODEST_COLX),
	/* U+0283 */	IFX0213(JISX0213_1(0xaae8),	U2E_NODEST_COLX),
	/* U+0284 */	IFX0213(JISX0213_1(0xaba7),	U2E_NODEST_COLX),
	/* U+0285 */	U2E_NODEST_COLX,
	/* U+0286 */	U2E_NODEST_COLX,
	/* U+0287 */	U2E_NODEST_COLX,
	/* U+0288 */	IFX0213(JISX0213_1(0xaaed),	U2E_NODEST_COLX),
	/* U+0289 */	IFX0213(JISX0213_1(0xabad),	U2E_NODEST_COLX),
	/* U+028A */	IFX0213(JISX0213_1(0xabb5),	U2E_NODEST_COLX),
	/* U+028B */	IFX0213(JISX0213_1(0xaae6),	U2E_NODEST_COLX),
	/* U+028C */	IFX0213(JISX0213_1(0xabb7),	U2E_NODEST_COLX),
	/* U+028D */	IFX0213(JISX0213_1(0xabbb),	U2E_NODEST_COLX),
	/* U+028E */	IFX0213(JISX0213_1(0xaaf8),	U2E_NODEST_COLX),
	/* U+028F */	U2E_NODEST_COLX,
	/* U+0290 */	IFX0213(JISX0213_1(0xaaf2),	U2E_NODEST_COLX),
	/* U+0291 */	IFX0213(JISX0213_1(0xabc0),	U2E_NODEST_COLX),
	/* U+0292 */	IFX0213(JISX0213_1(0xaae9),	U2E_NODEST_COLX),
	/* U+0293 */	U2E_NODEST_COLX,
	/* U+0294 */	IFX0213(JISX0213_1(0xaba1),	U2E_NODEST_COLX),
	/* U+0295 */	IFX0213(JISX0213_1(0xaafe),	U2E_NODEST_COLX),
	/* U+0296 */	U2E_NODEST_COLX,
	/* U+0297 */	U2E_NODEST_COLX,
	/* U+0298 */	IFX0213(JISX0213_1(0xaba3),	U2E_NODEST_COLX),
	/* U+0299 */	U2E_NODEST_COLX,
	/* U+029A */	U2E_NODEST_COLX,
	/* U+029B */	U2E_NODEST_COLX,
	/* U+029C */	U2E_NODEST_COLX,
	/* U+029D */	IFX0213(JISX0213_1(0xaaf7),	U2E_NODEST_COLX),
	/* U+029E */	U2E_NODEST_COLX,
	/* U+029F */	U2E_NODEST_COLX,
	/* U+02A0 */	U2E_NODEST_COLX,
	/* U+02A1 */	IFX0213(JISX0213_1(0xabbe),	U2E_NODEST_COLX),
	/* U+02A2 */	IFX0213(JISX0213_1(0xabbd),	U2E_NODEST_COLX),
	/* U+02A3 */	U2E_NODEST_COLX,
	/* U+02A4 */	U2E_NODEST_COLX,
	/* U+02A5 */	U2E_NODEST_COLX,
	/* U+02A6 */	U2E_NODEST_COLX,
	/* U+02A7 */	U2E_NODEST_COLX,
	/* U+02A8 */	U2E_NODEST_COLX,
	/* U+02A9 */	U2E_NODEST_COLX,
	/* U+02AA */	U2E_NODEST_COLX,
	/* U+02AB */	U2E_NODEST_COLX,
	/* U+02AC */	U2E_NODEST_COLX,
	/* U+02AD */	U2E_NODEST_COLX,
	/* U+02AE */	U2E_NODEST_COLX,
	/* U+02AF */	U2E_NODEST_COLX,
	/* U+02B0 */	U2E_NODEST_COLX,
	/* U+02B1 */	U2E_NODEST_COLX,
	/* U+02B2 */	U2E_NODEST_COLX,
	/* U+02B3 */	U2E_NODEST_COLX,
	/* U+02B4 */	U2E_NODEST_COLX,
	/* U+02B5 */	U2E_NODEST_COLX,
	/* U+02B6 */	U2E_NODEST_COLX,
	/* U+02B7 */	U2E_NODEST_COLX,
	/* U+02B8 */	U2E_NODEST_COLX,
	/* U+02B9 */	U2E_NODEST_COLX,
	/* U+02BA */	U2E_NODEST_COLX,
	/* U+02BB */	U2E_NODEST_COLX,
	/* U+02BC */	U2E_NODEST_COLX,
	/* U+02BD */	U2E_NODEST_COLX,
	/* U+02BE */	U2E_NODEST_COLX,
	/* U+02BF */	U2E_NODEST_COLX,
	/* U+02C0 */	U2E_NODEST_COLX,
	/* U+02C1 */	U2E_NODEST_COLX,
	/* U+02C2 */	U2E_NODEST_COLX,
	/* U+02C3 */	U2E_NODEST_COLX,
	/* U+02C4 */	U2E_NODEST_COLX,
	/* U+02C5 */	U2E_NODEST_COLX,
	/* U+02C6 */	U2E_NODEST_COLX,
	/* U+02C7 */	IFX0213(JISX0213_1(0xaab1),	JISX0212(0xa230)),
	/* U+02C8 */	IFX0213(JISX0213_1(0xabd3),	U2E_NODEST_COLX),
	/* U+02C9 */	U2E_NODEST_COLX,
	/* U+02CA */	U2E_NODEST_COLX,
	/* U+02CB */	U2E_NODEST_COLX,
	/* U+02CC */	IFX0213(JISX0213_1(0xabd4),	U2E_NODEST_COLX),
	/* U+02CD */	U2E_NODEST_COLX,
	/* U+02CE */	U2E_NODEST_COLX,
	/* U+02CF */	U2E_NODEST_COLX,
	/* U+02D0 */	IFX0213(JISX0213_1(0xabd5),	U2E_NODEST_COLX),
	/* U+02D1 */	IFX0213(JISX0213_1(0xabd6),	U2E_NODEST_COLX),
	/* U+02D2 */	U2E_NODEST_COLX,
	/* U+02D3 */	U2E_NODEST_COLX,
	/* U+02D4 */	U2E_NODEST_COLX,
	/* U+02D5 */	U2E_NODEST_COLX,
	/* U+02D6 */	U2E_NODEST_COLX,
	/* U+02D7 */	U2E_NODEST_COLX,
	/* U+02D8 */	IFX0213(JISX0213_1(0xaaa2),	JISX0212(0xa22f)),
	/* U+02D9 */	IFX0213(JISX0213_1(0xaad8),	JISX0212(0xa232)),
	/* U+02DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa236)),
	/* U+02DB */	IFX0213(JISX0213_1(0xaaad),	JISX0212(0xa235)),
	/* U+02DC */	U2E_NODEST_COLX,
	/* U+02DD */	IFX0213(JISX0213_1(0xaab6),	JISX0212(0xa233)),
	/* U+02DE */	IFX0213(JISX0213_1(0xabf1),	U2E_NODEST_COLX),
	/* U+02DF */	U2E_NODEST_COLX,
	/* U+02E0 */	U2E_NODEST_COLX,
	/* U+02E1 */	U2E_NODEST_COLX,
	/* U+02E2 */	U2E_NODEST_COLX,
	/* U+02E3 */	U2E_NODEST_COLX,
	/* U+02E4 */	U2E_NODEST_COLX,
	/* U+02E5 */	IFX0213(JISX0213_1(0xabe0),	U2E_NODEST_COLX),
	/* U+02E6 */	IFX0213(JISX0213_1(0xabe1),	U2E_NODEST_COLX),
	/* U+02E7 */	IFX0213(JISX0213_1(0xabe2),	U2E_NODEST_COLX),
	/* U+02E8 */	IFX0213(JISX0213_1(0xabe3),	U2E_NODEST_COLX),
	/* U+02E9 */	IFX0213(JISX0213_1(0xabe4),	U2E_NODEST_COLX),
	/* U+02EA */	U2E_NODEST_COLX,
	/* U+02EB */	U2E_NODEST_COLX,
	/* U+02EC */	U2E_NODEST_COLX,
	/* U+02ED */	U2E_NODEST_COLX,
	/* U+02EE */	U2E_NODEST_COLX,
	/* U+02EF */	U2E_NODEST_COLX,
	/* U+02F0 */	U2E_NODEST_COLX,
	/* U+02F1 */	U2E_NODEST_COLX,
	/* U+02F2 */	U2E_NODEST_COLX,
	/* U+02F3 */	U2E_NODEST_COLX,
	/* U+02F4 */	U2E_NODEST_COLX,
	/* U+02F5 */	U2E_NODEST_COLX,
	/* U+02F6 */	U2E_NODEST_COLX,
	/* U+02F7 */	U2E_NODEST_COLX,
	/* U+02F8 */	U2E_NODEST_COLX,
	/* U+02F9 */	U2E_NODEST_COLX,
	/* U+02FA */	U2E_NODEST_COLX,
	/* U+02FB */	U2E_NODEST_COLX,
	/* U+02FC */	U2E_NODEST_COLX,
	/* U+02FD */	U2E_NODEST_COLX,
	/* U+02FE */	U2E_NODEST_COLX,
	/* U+02FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_03[] = {
	/* U+0300 */	IFX0213(JISX0213_1(0xabdc),	U2E_NODEST_COLX),
	/* U+0301 */	IFX0213(JISX0213_1(0xabda),	U2E_NODEST_COLX),
	/* U+0302 */	IFX0213(JISX0213_1(0xabdf),	U2E_NODEST_COLX),
	/* U+0303 */	IFX0213(JISX0213_1(0xabfd),	U2E_NODEST_COLX),
	/* U+0304 */	IFX0213(JISX0213_1(0xabdb),	U2E_NODEST_COLX),
	/* U+0305 */	U2E_NODEST_COLX,
	/* U+0306 */	IFX0213(JISX0213_1(0xabd7),	U2E_NODEST_COLX),
	/* U+0307 */	U2E_NODEST_COLX,
	/* U+0308 */	IFX0213(JISX0213_1(0xabed),	U2E_NODEST_COLX),
	/* U+0309 */	U2E_NODEST_COLX,
	/* U+030A */	U2E_NODEST_COLX,
	/* U+030B */	IFX0213(JISX0213_1(0xabd9),	U2E_NODEST_COLX),
	/* U+030C */	IFX0213(JISX0213_1(0xabde),	U2E_NODEST_COLX),
	/* U+030D */	U2E_NODEST_COLX,
	/* U+030E */	U2E_NODEST_COLX,
	/* U+030F */	IFX0213(JISX0213_1(0xabdd),	U2E_NODEST_COLX),
	/* U+0310 */	U2E_NODEST_COLX,
	/* U+0311 */	U2E_NODEST_COLX,
	/* U+0312 */	U2E_NODEST_COLX,
	/* U+0313 */	U2E_NODEST_COLX,
	/* U+0314 */	U2E_NODEST_COLX,
	/* U+0315 */	U2E_NODEST_COLX,
	/* U+0316 */	U2E_NODEST_COLX,
	/* U+0317 */	U2E_NODEST_COLX,
	/* U+0318 */	IFX0213(JISX0213_1(0xabf8),	U2E_NODEST_COLX),
	/* U+0319 */	IFX0213(JISX0213_1(0xabf9),	U2E_NODEST_COLX),
	/* U+031A */	IFX0213(JISX0213_1(0xabfe),	U2E_NODEST_COLX),
	/* U+031B */	U2E_NODEST_COLX,
	/* U+031C */	IFX0213(JISX0213_1(0xabea),	U2E_NODEST_COLX),
	/* U+031D */	IFX0213(JISX0213_1(0xabf6),	U2E_NODEST_COLX),
	/* U+031E */	IFX0213(JISX0213_1(0xabf7),	U2E_NODEST_COLX),
	/* U+031F */	IFX0213(JISX0213_1(0xabeb),	U2E_NODEST_COLX),
	/* U+0320 */	IFX0213(JISX0213_1(0xabec),	U2E_NODEST_COLX),
	/* U+0321 */	U2E_NODEST_COLX,
	/* U+0322 */	U2E_NODEST_COLX,
	/* U+0323 */	U2E_NODEST_COLX,
	/* U+0324 */	IFX0213(JISX0213_1(0xabf2),	U2E_NODEST_COLX),
	/* U+0325 */	IFX0213(JISX0213_1(0xabe7),	U2E_NODEST_COLX),
	/* U+0326 */	U2E_NODEST_COLX,
	/* U+0327 */	U2E_NODEST_COLX,
	/* U+0328 */	U2E_NODEST_COLX,
	/* U+0329 */	IFX0213(JISX0213_1(0xabef),	U2E_NODEST_COLX),
	/* U+032A */	IFX0213(JISX0213_1(0xabfa),	U2E_NODEST_COLX),
	/* U+032B */	U2E_NODEST_COLX,
	/* U+032C */	IFX0213(JISX0213_1(0xabe8),	U2E_NODEST_COLX),
	/* U+032D */	U2E_NODEST_COLX,
	/* U+032E */	U2E_NODEST_COLX,
	/* U+032F */	IFX0213(JISX0213_1(0xabf0),	U2E_NODEST_COLX),
	/* U+0330 */	IFX0213(JISX0213_1(0xabf3),	U2E_NODEST_COLX),
	/* U+0331 */	U2E_NODEST_COLX,
	/* U+0332 */	U2E_NODEST_COLX,
	/* U+0333 */	U2E_NODEST_COLX,
	/* U+0334 */	IFX0213(JISX0213_1(0xabf5),	U2E_NODEST_COLX),
	/* U+0335 */	U2E_NODEST_COLX,
	/* U+0336 */	U2E_NODEST_COLX,
	/* U+0337 */	U2E_NODEST_COLX,
	/* U+0338 */	U2E_NODEST_COLX,
	/* U+0339 */	IFX0213(JISX0213_1(0xabe9),	U2E_NODEST_COLX),
	/* U+033A */	IFX0213(JISX0213_1(0xabfb),	U2E_NODEST_COLX),
	/* U+033B */	IFX0213(JISX0213_1(0xabfc),	U2E_NODEST_COLX),
	/* U+033C */	IFX0213(JISX0213_1(0xabf4),	U2E_NODEST_COLX),
	/* U+033D */	IFX0213(JISX0213_1(0xabee),	U2E_NODEST_COLX),
	/* U+033E */	U2E_NODEST_COLX,
	/* U+033F */	U2E_NODEST_COLX,
	/* U+0340 */	U2E_NODEST_COLX,
	/* U+0341 */	U2E_NODEST_COLX,
	/* U+0342 */	U2E_NODEST_COLX,
	/* U+0343 */	U2E_NODEST_COLX,
	/* U+0344 */	U2E_NODEST_COLX,
	/* U+0345 */	U2E_NODEST_COLX,
	/* U+0346 */	U2E_NODEST_COLX,
	/* U+0347 */	U2E_NODEST_COLX,
	/* U+0348 */	U2E_NODEST_COLX,
	/* U+0349 */	U2E_NODEST_COLX,
	/* U+034A */	U2E_NODEST_COLX,
	/* U+034B */	U2E_NODEST_COLX,
	/* U+034C */	U2E_NODEST_COLX,
	/* U+034D */	U2E_NODEST_COLX,
	/* U+034E */	U2E_NODEST_COLX,
	/* U+034F */	U2E_NODEST_COLX,
	/* U+0350 */	U2E_NODEST_COLX,
	/* U+0351 */	U2E_NODEST_COLX,
	/* U+0352 */	U2E_NODEST_COLX,
	/* U+0353 */	U2E_NODEST_COLX,
	/* U+0354 */	U2E_NODEST_COLX,
	/* U+0355 */	U2E_NODEST_COLX,
	/* U+0356 */	U2E_NODEST_COLX,
	/* U+0357 */	U2E_NODEST_COLX,
	/* U+0358 */	U2E_NODEST_COLX,
	/* U+0359 */	U2E_NODEST_COLX,
	/* U+035A */	U2E_NODEST_COLX,
	/* U+035B */	U2E_NODEST_COLX,
	/* U+035C */	U2E_NODEST_COLX,
	/* U+035D */	U2E_NODEST_COLX,
	/* U+035E */	U2E_NODEST_COLX,
	/* U+035F */	U2E_NODEST_COLX,
	/* U+0360 */	U2E_NODEST_COLX,
	/* U+0361 */	IFX0213(JISX0213_1(0xabd2),	U2E_NODEST_COLX),
	/* U+0362 */	U2E_NODEST_COLX,
	/* U+0363 */	U2E_NODEST_COLX,
	/* U+0364 */	U2E_NODEST_COLX,
	/* U+0365 */	U2E_NODEST_COLX,
	/* U+0366 */	U2E_NODEST_COLX,
	/* U+0367 */	U2E_NODEST_COLX,
	/* U+0368 */	U2E_NODEST_COLX,
	/* U+0369 */	U2E_NODEST_COLX,
	/* U+036A */	U2E_NODEST_COLX,
	/* U+036B */	U2E_NODEST_COLX,
	/* U+036C */	U2E_NODEST_COLX,
	/* U+036D */	U2E_NODEST_COLX,
	/* U+036E */	U2E_NODEST_COLX,
	/* U+036F */	U2E_NODEST_COLX,
	/* U+0370 */	U2E_NODEST_COLX,
	/* U+0371 */	U2E_NODEST_COLX,
	/* U+0372 */	U2E_NODEST_COLX,
	/* U+0373 */	U2E_NODEST_COLX,
	/* U+0374 */	U2E_NODEST_COLX,
	/* U+0375 */	U2E_NODEST_COLX,
	/* U+0376 */	U2E_NODEST_COLX,
	/* U+0377 */	U2E_NODEST_COLX,
	/* U+0378 */	U2E_NODEST_COLX,
	/* U+0379 */	U2E_NODEST_COLX,
	/* U+037A */	U2E_NODEST_COLX,
	/* U+037B */	U2E_NODEST_COLX,
	/* U+037C */	U2E_NODEST_COLX,
	/* U+037D */	U2E_NODEST_COLX,
	/* U+037E */	U2E_NODEST_COLX,
	/* U+037F */	U2E_NODEST_COLX,
	/* U+0380 */	U2E_NODEST_COLX,
	/* U+0381 */	U2E_NODEST_COLX,
	/* U+0382 */	U2E_NODEST_COLX,
	/* U+0383 */	U2E_NODEST_COLX,
	/* U+0384 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa238)),
	/* U+0385 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa239)),
	/* U+0386 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa661)),
	/* U+0387 */	U2E_NODEST_COLX,
	/* U+0388 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa662)),
	/* U+0389 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa663)),
	/* U+038A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa664)),
	/* U+038B */	U2E_NODEST_COLX,
	/* U+038C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa667)),
	/* U+038D */	U2E_NODEST_COLX,
	/* U+038E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa669)),
	/* U+038F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa66c)),
	/* U+0390 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa676)),
	/* U+0391 */	JISX0208(0xa6a1),
	/* U+0392 */	JISX0208(0xa6a2),
	/* U+0393 */	JISX0208(0xa6a3),
	/* U+0394 */	JISX0208(0xa6a4),
	/* U+0395 */	JISX0208(0xa6a5),
	/* U+0396 */	JISX0208(0xa6a6),
	/* U+0397 */	JISX0208(0xa6a7),
	/* U+0398 */	JISX0208(0xa6a8),
	/* U+0399 */	JISX0208(0xa6a9),
	/* U+039A */	JISX0208(0xa6aa),
	/* U+039B */	JISX0208(0xa6ab),
	/* U+039C */	JISX0208(0xa6ac),
	/* U+039D */	JISX0208(0xa6ad),
	/* U+039E */	JISX0208(0xa6ae),
	/* U+039F */	JISX0208(0xa6af),
	/* U+03A0 */	JISX0208(0xa6b0),
	/* U+03A1 */	JISX0208(0xa6b1),
	/* U+03A2 */	U2E_NODEST_COLX,
	/* U+03A3 */	JISX0208(0xa6b2),
	/* U+03A4 */	JISX0208(0xa6b3),
	/* U+03A5 */	JISX0208(0xa6b4),
	/* U+03A6 */	JISX0208(0xa6b5),
	/* U+03A7 */	JISX0208(0xa6b6),
	/* U+03A8 */	JISX0208(0xa6b7),
	/* U+03A9 */	JISX0208(0xa6b8),
	/* U+03AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa665)),
	/* U+03AB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa66a)),
	/* U+03AC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa671)),
	/* U+03AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa672)),
	/* U+03AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa673)),
	/* U+03AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa674)),
	/* U+03B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa67b)),
	/* U+03B1 */	JISX0208(0xa6c1),
	/* U+03B2 */	JISX0208(0xa6c2),
	/* U+03B3 */	JISX0208(0xa6c3),
	/* U+03B4 */	JISX0208(0xa6c4),
	/* U+03B5 */	JISX0208(0xa6c5),
	/* U+03B6 */	JISX0208(0xa6c6),
	/* U+03B7 */	JISX0208(0xa6c7),
	/* U+03B8 */	JISX0208(0xa6c8),
	/* U+03B9 */	JISX0208(0xa6c9),
	/* U+03BA */	JISX0208(0xa6ca),
	/* U+03BB */	JISX0208(0xa6cb),
	/* U+03BC */	JISX0208(0xa6cc),
	/* U+03BD */	JISX0208(0xa6cd),
	/* U+03BE */	JISX0208(0xa6ce),
	/* U+03BF */	JISX0208(0xa6cf),
	/* U+03C0 */	JISX0208(0xa6d0),
	/* U+03C1 */	JISX0208(0xa6d1),
	/* U+03C2 */	IFX0213(JISX0213_1(0xa6d9),	JISX0212(0xa678)),
	/* U+03C3 */	JISX0208(0xa6d2),
	/* U+03C4 */	JISX0208(0xa6d3),
	/* U+03C5 */	JISX0208(0xa6d4),
	/* U+03C6 */	JISX0208(0xa6d5),
	/* U+03C7 */	JISX0208(0xa6d6),
	/* U+03C8 */	JISX0208(0xa6d7),
	/* U+03C9 */	JISX0208(0xa6d8),
	/* U+03CA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa675)),
	/* U+03CB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa67a)),
	/* U+03CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa677)),
	/* U+03CD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa679)),
	/* U+03CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa67c)),
	/* U+03CF */	U2E_NODEST_COLX,
	/* U+03D0 */	U2E_NODEST_COLX,
	/* U+03D1 */	U2E_NODEST_COLX,
	/* U+03D2 */	U2E_NODEST_COLX,
	/* U+03D3 */	U2E_NODEST_COLX,
	/* U+03D4 */	U2E_NODEST_COLX,
	/* U+03D5 */	U2E_NODEST_COLX,
	/* U+03D6 */	U2E_NODEST_COLX,
	/* U+03D7 */	U2E_NODEST_COLX,
	/* U+03D8 */	U2E_NODEST_COLX,
	/* U+03D9 */	U2E_NODEST_COLX,
	/* U+03DA */	U2E_NODEST_COLX,
	/* U+03DB */	U2E_NODEST_COLX,
	/* U+03DC */	U2E_NODEST_COLX,
	/* U+03DD */	U2E_NODEST_COLX,
	/* U+03DE */	U2E_NODEST_COLX,
	/* U+03DF */	U2E_NODEST_COLX,
	/* U+03E0 */	U2E_NODEST_COLX,
	/* U+03E1 */	U2E_NODEST_COLX,
	/* U+03E2 */	U2E_NODEST_COLX,
	/* U+03E3 */	U2E_NODEST_COLX,
	/* U+03E4 */	U2E_NODEST_COLX,
	/* U+03E5 */	U2E_NODEST_COLX,
	/* U+03E6 */	U2E_NODEST_COLX,
	/* U+03E7 */	U2E_NODEST_COLX,
	/* U+03E8 */	U2E_NODEST_COLX,
	/* U+03E9 */	U2E_NODEST_COLX,
	/* U+03EA */	U2E_NODEST_COLX,
	/* U+03EB */	U2E_NODEST_COLX,
	/* U+03EC */	U2E_NODEST_COLX,
	/* U+03ED */	U2E_NODEST_COLX,
	/* U+03EE */	U2E_NODEST_COLX,
	/* U+03EF */	U2E_NODEST_COLX,
	/* U+03F0 */	U2E_NODEST_COLX,
	/* U+03F1 */	U2E_NODEST_COLX,
	/* U+03F2 */	U2E_NODEST_COLX,
	/* U+03F3 */	U2E_NODEST_COLX,
	/* U+03F4 */	U2E_NODEST_COLX,
	/* U+03F5 */	U2E_NODEST_COLX,
	/* U+03F6 */	U2E_NODEST_COLX,
	/* U+03F7 */	U2E_NODEST_COLX,
	/* U+03F8 */	U2E_NODEST_COLX,
	/* U+03F9 */	U2E_NODEST_COLX,
	/* U+03FA */	U2E_NODEST_COLX,
	/* U+03FB */	U2E_NODEST_COLX,
	/* U+03FC */	U2E_NODEST_COLX,
	/* U+03FD */	U2E_NODEST_COLX,
	/* U+03FE */	U2E_NODEST_COLX,
	/* U+03FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_04[] = {
	/* U+0400 */	U2E_NODEST_COLX,
	/* U+0401 */	JISX0208(0xa7a7),
	/* U+0402 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa742)),
	/* U+0403 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa743)),
	/* U+0404 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa744)),
	/* U+0405 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa745)),
	/* U+0406 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa746)),
	/* U+0407 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa747)),
	/* U+0408 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa748)),
	/* U+0409 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa749)),
	/* U+040A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa74a)),
	/* U+040B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa74b)),
	/* U+040C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa74c)),
	/* U+040D */	U2E_NODEST_COLX,
	/* U+040E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa74d)),
	/* U+040F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa74e)),
	/* U+0410 */	JISX0208(0xa7a1),
	/* U+0411 */	JISX0208(0xa7a2),
	/* U+0412 */	JISX0208(0xa7a3),
	/* U+0413 */	JISX0208(0xa7a4),
	/* U+0414 */	JISX0208(0xa7a5),
	/* U+0415 */	JISX0208(0xa7a6),
	/* U+0416 */	JISX0208(0xa7a8),
	/* U+0417 */	JISX0208(0xa7a9),
	/* U+0418 */	JISX0208(0xa7aa),
	/* U+0419 */	JISX0208(0xa7ab),
	/* U+041A */	JISX0208(0xa7ac),
	/* U+041B */	JISX0208(0xa7ad),
	/* U+041C */	JISX0208(0xa7ae),
	/* U+041D */	JISX0208(0xa7af),
	/* U+041E */	JISX0208(0xa7b0),
	/* U+041F */	JISX0208(0xa7b1),
	/* U+0420 */	JISX0208(0xa7b2),
	/* U+0421 */	JISX0208(0xa7b3),
	/* U+0422 */	JISX0208(0xa7b4),
	/* U+0423 */	JISX0208(0xa7b5),
	/* U+0424 */	JISX0208(0xa7b6),
	/* U+0425 */	JISX0208(0xa7b7),
	/* U+0426 */	JISX0208(0xa7b8),
	/* U+0427 */	JISX0208(0xa7b9),
	/* U+0428 */	JISX0208(0xa7ba),
	/* U+0429 */	JISX0208(0xa7bb),
	/* U+042A */	JISX0208(0xa7bc),
	/* U+042B */	JISX0208(0xa7bd),
	/* U+042C */	JISX0208(0xa7be),
	/* U+042D */	JISX0208(0xa7bf),
	/* U+042E */	JISX0208(0xa7c0),
	/* U+042F */	JISX0208(0xa7c1),
	/* U+0430 */	JISX0208(0xa7d1),
	/* U+0431 */	JISX0208(0xa7d2),
	/* U+0432 */	JISX0208(0xa7d3),
	/* U+0433 */	JISX0208(0xa7d4),
	/* U+0434 */	JISX0208(0xa7d5),
	/* U+0435 */	JISX0208(0xa7d6),
	/* U+0436 */	JISX0208(0xa7d8),
	/* U+0437 */	JISX0208(0xa7d9),
	/* U+0438 */	JISX0208(0xa7da),
	/* U+0439 */	JISX0208(0xa7db),
	/* U+043A */	JISX0208(0xa7dc),
	/* U+043B */	JISX0208(0xa7dd),
	/* U+043C */	JISX0208(0xa7de),
	/* U+043D */	JISX0208(0xa7df),
	/* U+043E */	JISX0208(0xa7e0),
	/* U+043F */	JISX0208(0xa7e1),
	/* U+0440 */	JISX0208(0xa7e2),
	/* U+0441 */	JISX0208(0xa7e3),
	/* U+0442 */	JISX0208(0xa7e4),
	/* U+0443 */	JISX0208(0xa7e5),
	/* U+0444 */	JISX0208(0xa7e6),
	/* U+0445 */	JISX0208(0xa7e7),
	/* U+0446 */	JISX0208(0xa7e8),
	/* U+0447 */	JISX0208(0xa7e9),
	/* U+0448 */	JISX0208(0xa7ea),
	/* U+0449 */	JISX0208(0xa7eb),
	/* U+044A */	JISX0208(0xa7ec),
	/* U+044B */	JISX0208(0xa7ed),
	/* U+044C */	JISX0208(0xa7ee),
	/* U+044D */	JISX0208(0xa7ef),
	/* U+044E */	JISX0208(0xa7f0),
	/* U+044F */	JISX0208(0xa7f1),
	/* U+0450 */	U2E_NODEST_COLX,
	/* U+0451 */	JISX0208(0xa7d7),
	/* U+0452 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa772)),
	/* U+0453 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa773)),
	/* U+0454 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa774)),
	/* U+0455 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa775)),
	/* U+0456 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa776)),
	/* U+0457 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa777)),
	/* U+0458 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa778)),
	/* U+0459 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa779)),
	/* U+045A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa77a)),
	/* U+045B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa77b)),
	/* U+045C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa77c)),
	/* U+045D */	U2E_NODEST_COLX,
	/* U+045E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa77d)),
	/* U+045F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa77e)),
	/* U+0460 */	U2E_NODEST_COLX,
	/* U+0461 */	U2E_NODEST_COLX,
	/* U+0462 */	U2E_NODEST_COLX,
	/* U+0463 */	U2E_NODEST_COLX,
	/* U+0464 */	U2E_NODEST_COLX,
	/* U+0465 */	U2E_NODEST_COLX,
	/* U+0466 */	U2E_NODEST_COLX,
	/* U+0467 */	U2E_NODEST_COLX,
	/* U+0468 */	U2E_NODEST_COLX,
	/* U+0469 */	U2E_NODEST_COLX,
	/* U+046A */	U2E_NODEST_COLX,
	/* U+046B */	U2E_NODEST_COLX,
	/* U+046C */	U2E_NODEST_COLX,
	/* U+046D */	U2E_NODEST_COLX,
	/* U+046E */	U2E_NODEST_COLX,
	/* U+046F */	U2E_NODEST_COLX,
	/* U+0470 */	U2E_NODEST_COLX,
	/* U+0471 */	U2E_NODEST_COLX,
	/* U+0472 */	U2E_NODEST_COLX,
	/* U+0473 */	U2E_NODEST_COLX,
	/* U+0474 */	U2E_NODEST_COLX,
	/* U+0475 */	U2E_NODEST_COLX,
	/* U+0476 */	U2E_NODEST_COLX,
	/* U+0477 */	U2E_NODEST_COLX,
	/* U+0478 */	U2E_NODEST_COLX,
	/* U+0479 */	U2E_NODEST_COLX,
	/* U+047A */	U2E_NODEST_COLX,
	/* U+047B */	U2E_NODEST_COLX,
	/* U+047C */	U2E_NODEST_COLX,
	/* U+047D */	U2E_NODEST_COLX,
	/* U+047E */	U2E_NODEST_COLX,
	/* U+047F */	U2E_NODEST_COLX,
	/* U+0480 */	U2E_NODEST_COLX,
	/* U+0481 */	U2E_NODEST_COLX,
	/* U+0482 */	U2E_NODEST_COLX,
	/* U+0483 */	U2E_NODEST_COLX,
	/* U+0484 */	U2E_NODEST_COLX,
	/* U+0485 */	U2E_NODEST_COLX,
	/* U+0486 */	U2E_NODEST_COLX,
	/* U+0487 */	U2E_NODEST_COLX,
	/* U+0488 */	U2E_NODEST_COLX,
	/* U+0489 */	U2E_NODEST_COLX,
	/* U+048A */	U2E_NODEST_COLX,
	/* U+048B */	U2E_NODEST_COLX,
	/* U+048C */	U2E_NODEST_COLX,
	/* U+048D */	U2E_NODEST_COLX,
	/* U+048E */	U2E_NODEST_COLX,
	/* U+048F */	U2E_NODEST_COLX,
	/* U+0490 */	U2E_NODEST_COLX,
	/* U+0491 */	U2E_NODEST_COLX,
	/* U+0492 */	U2E_NODEST_COLX,
	/* U+0493 */	U2E_NODEST_COLX,
	/* U+0494 */	U2E_NODEST_COLX,
	/* U+0495 */	U2E_NODEST_COLX,
	/* U+0496 */	U2E_NODEST_COLX,
	/* U+0497 */	U2E_NODEST_COLX,
	/* U+0498 */	U2E_NODEST_COLX,
	/* U+0499 */	U2E_NODEST_COLX,
	/* U+049A */	U2E_NODEST_COLX,
	/* U+049B */	U2E_NODEST_COLX,
	/* U+049C */	U2E_NODEST_COLX,
	/* U+049D */	U2E_NODEST_COLX,
	/* U+049E */	U2E_NODEST_COLX,
	/* U+049F */	U2E_NODEST_COLX,
	/* U+04A0 */	U2E_NODEST_COLX,
	/* U+04A1 */	U2E_NODEST_COLX,
	/* U+04A2 */	U2E_NODEST_COLX,
	/* U+04A3 */	U2E_NODEST_COLX,
	/* U+04A4 */	U2E_NODEST_COLX,
	/* U+04A5 */	U2E_NODEST_COLX,
	/* U+04A6 */	U2E_NODEST_COLX,
	/* U+04A7 */	U2E_NODEST_COLX,
	/* U+04A8 */	U2E_NODEST_COLX,
	/* U+04A9 */	U2E_NODEST_COLX,
	/* U+04AA */	U2E_NODEST_COLX,
	/* U+04AB */	U2E_NODEST_COLX,
	/* U+04AC */	U2E_NODEST_COLX,
	/* U+04AD */	U2E_NODEST_COLX,
	/* U+04AE */	U2E_NODEST_COLX,
	/* U+04AF */	U2E_NODEST_COLX,
	/* U+04B0 */	U2E_NODEST_COLX,
	/* U+04B1 */	U2E_NODEST_COLX,
	/* U+04B2 */	U2E_NODEST_COLX,
	/* U+04B3 */	U2E_NODEST_COLX,
	/* U+04B4 */	U2E_NODEST_COLX,
	/* U+04B5 */	U2E_NODEST_COLX,
	/* U+04B6 */	U2E_NODEST_COLX,
	/* U+04B7 */	U2E_NODEST_COLX,
	/* U+04B8 */	U2E_NODEST_COLX,
	/* U+04B9 */	U2E_NODEST_COLX,
	/* U+04BA */	U2E_NODEST_COLX,
	/* U+04BB */	U2E_NODEST_COLX,
	/* U+04BC */	U2E_NODEST_COLX,
	/* U+04BD */	U2E_NODEST_COLX,
	/* U+04BE */	U2E_NODEST_COLX,
	/* U+04BF */	U2E_NODEST_COLX,
	/* U+04C0 */	U2E_NODEST_COLX,
	/* U+04C1 */	U2E_NODEST_COLX,
	/* U+04C2 */	U2E_NODEST_COLX,
	/* U+04C3 */	U2E_NODEST_COLX,
	/* U+04C4 */	U2E_NODEST_COLX,
	/* U+04C5 */	U2E_NODEST_COLX,
	/* U+04C6 */	U2E_NODEST_COLX,
	/* U+04C7 */	U2E_NODEST_COLX,
	/* U+04C8 */	U2E_NODEST_COLX,
	/* U+04C9 */	U2E_NODEST_COLX,
	/* U+04CA */	U2E_NODEST_COLX,
	/* U+04CB */	U2E_NODEST_COLX,
	/* U+04CC */	U2E_NODEST_COLX,
	/* U+04CD */	U2E_NODEST_COLX,
	/* U+04CE */	U2E_NODEST_COLX,
	/* U+04CF */	U2E_NODEST_COLX,
	/* U+04D0 */	U2E_NODEST_COLX,
	/* U+04D1 */	U2E_NODEST_COLX,
	/* U+04D2 */	U2E_NODEST_COLX,
	/* U+04D3 */	U2E_NODEST_COLX,
	/* U+04D4 */	U2E_NODEST_COLX,
	/* U+04D5 */	U2E_NODEST_COLX,
	/* U+04D6 */	U2E_NODEST_COLX,
	/* U+04D7 */	U2E_NODEST_COLX,
	/* U+04D8 */	U2E_NODEST_COLX,
	/* U+04D9 */	U2E_NODEST_COLX,
	/* U+04DA */	U2E_NODEST_COLX,
	/* U+04DB */	U2E_NODEST_COLX,
	/* U+04DC */	U2E_NODEST_COLX,
	/* U+04DD */	U2E_NODEST_COLX,
	/* U+04DE */	U2E_NODEST_COLX,
	/* U+04DF */	U2E_NODEST_COLX,
	/* U+04E0 */	U2E_NODEST_COLX,
	/* U+04E1 */	U2E_NODEST_COLX,
	/* U+04E2 */	U2E_NODEST_COLX,
	/* U+04E3 */	U2E_NODEST_COLX,
	/* U+04E4 */	U2E_NODEST_COLX,
	/* U+04E5 */	U2E_NODEST_COLX,
	/* U+04E6 */	U2E_NODEST_COLX,
	/* U+04E7 */	U2E_NODEST_COLX,
	/* U+04E8 */	U2E_NODEST_COLX,
	/* U+04E9 */	U2E_NODEST_COLX,
	/* U+04EA */	U2E_NODEST_COLX,
	/* U+04EB */	U2E_NODEST_COLX,
	/* U+04EC */	U2E_NODEST_COLX,
	/* U+04ED */	U2E_NODEST_COLX,
	/* U+04EE */	U2E_NODEST_COLX,
	/* U+04EF */	U2E_NODEST_COLX,
	/* U+04F0 */	U2E_NODEST_COLX,
	/* U+04F1 */	U2E_NODEST_COLX,
	/* U+04F2 */	U2E_NODEST_COLX,
	/* U+04F3 */	U2E_NODEST_COLX,
	/* U+04F4 */	U2E_NODEST_COLX,
	/* U+04F5 */	U2E_NODEST_COLX,
	/* U+04F6 */	U2E_NODEST_COLX,
	/* U+04F7 */	U2E_NODEST_COLX,
	/* U+04F8 */	U2E_NODEST_COLX,
	/* U+04F9 */	U2E_NODEST_COLX,
	/* U+04FA */	U2E_NODEST_COLX,
	/* U+04FB */	U2E_NODEST_COLX,
	/* U+04FC */	U2E_NODEST_COLX,
	/* U+04FD */	U2E_NODEST_COLX,
	/* U+04FE */	U2E_NODEST_COLX,
	/* U+04FF */	U2E_NODEST_COLX,
};

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_05[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_06[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_07[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_08[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_09[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_0A[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_0B[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_0C[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_0D[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_0E[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_0F[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_10[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_11[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_12[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_13[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_14[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_15[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_16[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_17[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_18[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_19[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_1A[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_1B[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_1C[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_1D[] eliminated */

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_1E[] = {
	/* U+1E00 */	U2E_NODEST_COLX,
	/* U+1E01 */	U2E_NODEST_COLX,
	/* U+1E02 */	U2E_NODEST_COLX,
	/* U+1E03 */	U2E_NODEST_COLX,
	/* U+1E04 */	U2E_NODEST_COLX,
	/* U+1E05 */	U2E_NODEST_COLX,
	/* U+1E06 */	U2E_NODEST_COLX,
	/* U+1E07 */	U2E_NODEST_COLX,
	/* U+1E08 */	U2E_NODEST_COLX,
	/* U+1E09 */	U2E_NODEST_COLX,
	/* U+1E0A */	U2E_NODEST_COLX,
	/* U+1E0B */	U2E_NODEST_COLX,
	/* U+1E0C */	U2E_NODEST_COLX,
	/* U+1E0D */	U2E_NODEST_COLX,
	/* U+1E0E */	U2E_NODEST_COLX,
	/* U+1E0F */	U2E_NODEST_COLX,
	/* U+1E10 */	U2E_NODEST_COLX,
	/* U+1E11 */	U2E_NODEST_COLX,
	/* U+1E12 */	U2E_NODEST_COLX,
	/* U+1E13 */	U2E_NODEST_COLX,
	/* U+1E14 */	U2E_NODEST_COLX,
	/* U+1E15 */	U2E_NODEST_COLX,
	/* U+1E16 */	U2E_NODEST_COLX,
	/* U+1E17 */	U2E_NODEST_COLX,
	/* U+1E18 */	U2E_NODEST_COLX,
	/* U+1E19 */	U2E_NODEST_COLX,
	/* U+1E1A */	U2E_NODEST_COLX,
	/* U+1E1B */	U2E_NODEST_COLX,
	/* U+1E1C */	U2E_NODEST_COLX,
	/* U+1E1D */	U2E_NODEST_COLX,
	/* U+1E1E */	U2E_NODEST_COLX,
	/* U+1E1F */	U2E_NODEST_COLX,
	/* U+1E20 */	U2E_NODEST_COLX,
	/* U+1E21 */	U2E_NODEST_COLX,
	/* U+1E22 */	U2E_NODEST_COLX,
	/* U+1E23 */	U2E_NODEST_COLX,
	/* U+1E24 */	U2E_NODEST_COLX,
	/* U+1E25 */	U2E_NODEST_COLX,
	/* U+1E26 */	U2E_NODEST_COLX,
	/* U+1E27 */	U2E_NODEST_COLX,
	/* U+1E28 */	U2E_NODEST_COLX,
	/* U+1E29 */	U2E_NODEST_COLX,
	/* U+1E2A */	U2E_NODEST_COLX,
	/* U+1E2B */	U2E_NODEST_COLX,
	/* U+1E2C */	U2E_NODEST_COLX,
	/* U+1E2D */	U2E_NODEST_COLX,
	/* U+1E2E */	U2E_NODEST_COLX,
	/* U+1E2F */	U2E_NODEST_COLX,
	/* U+1E30 */	U2E_NODEST_COLX,
	/* U+1E31 */	U2E_NODEST_COLX,
	/* U+1E32 */	U2E_NODEST_COLX,
	/* U+1E33 */	U2E_NODEST_COLX,
	/* U+1E34 */	U2E_NODEST_COLX,
	/* U+1E35 */	U2E_NODEST_COLX,
	/* U+1E36 */	U2E_NODEST_COLX,
	/* U+1E37 */	U2E_NODEST_COLX,
	/* U+1E38 */	U2E_NODEST_COLX,
	/* U+1E39 */	U2E_NODEST_COLX,
	/* U+1E3A */	U2E_NODEST_COLX,
	/* U+1E3B */	U2E_NODEST_COLX,
	/* U+1E3C */	U2E_NODEST_COLX,
	/* U+1E3D */	U2E_NODEST_COLX,
	/* U+1E3E */	IFX0213(JISX0213_1(0xa8f2),	U2E_NODEST_COLX),
	/* U+1E3F */	IFX0213(JISX0213_1(0xa8f3),	U2E_NODEST_COLX),
	/* U+1E40 */	U2E_NODEST_COLX,
	/* U+1E41 */	U2E_NODEST_COLX,
	/* U+1E42 */	U2E_NODEST_COLX,
	/* U+1E43 */	U2E_NODEST_COLX,
	/* U+1E44 */	U2E_NODEST_COLX,
	/* U+1E45 */	U2E_NODEST_COLX,
	/* U+1E46 */	U2E_NODEST_COLX,
	/* U+1E47 */	U2E_NODEST_COLX,
	/* U+1E48 */	U2E_NODEST_COLX,
	/* U+1E49 */	U2E_NODEST_COLX,
	/* U+1E4A */	U2E_NODEST_COLX,
	/* U+1E4B */	U2E_NODEST_COLX,
	/* U+1E4C */	U2E_NODEST_COLX,
	/* U+1E4D */	U2E_NODEST_COLX,
	/* U+1E4E */	U2E_NODEST_COLX,
	/* U+1E4F */	U2E_NODEST_COLX,
	/* U+1E50 */	U2E_NODEST_COLX,
	/* U+1E51 */	U2E_NODEST_COLX,
	/* U+1E52 */	U2E_NODEST_COLX,
	/* U+1E53 */	U2E_NODEST_COLX,
	/* U+1E54 */	U2E_NODEST_COLX,
	/* U+1E55 */	U2E_NODEST_COLX,
	/* U+1E56 */	U2E_NODEST_COLX,
	/* U+1E57 */	U2E_NODEST_COLX,
	/* U+1E58 */	U2E_NODEST_COLX,
	/* U+1E59 */	U2E_NODEST_COLX,
	/* U+1E5A */	U2E_NODEST_COLX,
	/* U+1E5B */	U2E_NODEST_COLX,
	/* U+1E5C */	U2E_NODEST_COLX,
	/* U+1E5D */	U2E_NODEST_COLX,
	/* U+1E5E */	U2E_NODEST_COLX,
	/* U+1E5F */	U2E_NODEST_COLX,
	/* U+1E60 */	U2E_NODEST_COLX,
	/* U+1E61 */	U2E_NODEST_COLX,
	/* U+1E62 */	U2E_NODEST_COLX,
	/* U+1E63 */	U2E_NODEST_COLX,
	/* U+1E64 */	U2E_NODEST_COLX,
	/* U+1E65 */	U2E_NODEST_COLX,
	/* U+1E66 */	U2E_NODEST_COLX,
	/* U+1E67 */	U2E_NODEST_COLX,
	/* U+1E68 */	U2E_NODEST_COLX,
	/* U+1E69 */	U2E_NODEST_COLX,
	/* U+1E6A */	U2E_NODEST_COLX,
	/* U+1E6B */	U2E_NODEST_COLX,
	/* U+1E6C */	U2E_NODEST_COLX,
	/* U+1E6D */	U2E_NODEST_COLX,
	/* U+1E6E */	U2E_NODEST_COLX,
	/* U+1E6F */	U2E_NODEST_COLX,
	/* U+1E70 */	U2E_NODEST_COLX,
	/* U+1E71 */	U2E_NODEST_COLX,
	/* U+1E72 */	U2E_NODEST_COLX,
	/* U+1E73 */	U2E_NODEST_COLX,
	/* U+1E74 */	U2E_NODEST_COLX,
	/* U+1E75 */	U2E_NODEST_COLX,
	/* U+1E76 */	U2E_NODEST_COLX,
	/* U+1E77 */	U2E_NODEST_COLX,
	/* U+1E78 */	U2E_NODEST_COLX,
	/* U+1E79 */	U2E_NODEST_COLX,
	/* U+1E7A */	U2E_NODEST_COLX,
	/* U+1E7B */	U2E_NODEST_COLX,
	/* U+1E7C */	U2E_NODEST_COLX,
	/* U+1E7D */	U2E_NODEST_COLX,
	/* U+1E7E */	U2E_NODEST_COLX,
	/* U+1E7F */	U2E_NODEST_COLX,
	/* U+1E80 */	U2E_NODEST_COLX,
	/* U+1E81 */	U2E_NODEST_COLX,
	/* U+1E82 */	U2E_NODEST_COLX,
	/* U+1E83 */	U2E_NODEST_COLX,
	/* U+1E84 */	U2E_NODEST_COLX,
	/* U+1E85 */	U2E_NODEST_COLX,
	/* U+1E86 */	U2E_NODEST_COLX,
	/* U+1E87 */	U2E_NODEST_COLX,
	/* U+1E88 */	U2E_NODEST_COLX,
	/* U+1E89 */	U2E_NODEST_COLX,
	/* U+1E8A */	U2E_NODEST_COLX,
	/* U+1E8B */	U2E_NODEST_COLX,
	/* U+1E8C */	U2E_NODEST_COLX,
	/* U+1E8D */	U2E_NODEST_COLX,
	/* U+1E8E */	U2E_NODEST_COLX,
	/* U+1E8F */	U2E_NODEST_COLX,
	/* U+1E90 */	U2E_NODEST_COLX,
	/* U+1E91 */	U2E_NODEST_COLX,
	/* U+1E92 */	U2E_NODEST_COLX,
	/* U+1E93 */	U2E_NODEST_COLX,
	/* U+1E94 */	U2E_NODEST_COLX,
	/* U+1E95 */	U2E_NODEST_COLX,
	/* U+1E96 */	U2E_NODEST_COLX,
	/* U+1E97 */	U2E_NODEST_COLX,
	/* U+1E98 */	U2E_NODEST_COLX,
	/* U+1E99 */	U2E_NODEST_COLX,
	/* U+1E9A */	U2E_NODEST_COLX,
	/* U+1E9B */	U2E_NODEST_COLX,
	/* U+1E9C */	U2E_NODEST_COLX,
	/* U+1E9D */	U2E_NODEST_COLX,
	/* U+1E9E */	U2E_NODEST_COLX,
	/* U+1E9F */	U2E_NODEST_COLX,
	/* U+1EA0 */	U2E_NODEST_COLX,
	/* U+1EA1 */	U2E_NODEST_COLX,
	/* U+1EA2 */	U2E_NODEST_COLX,
	/* U+1EA3 */	U2E_NODEST_COLX,
	/* U+1EA4 */	U2E_NODEST_COLX,
	/* U+1EA5 */	U2E_NODEST_COLX,
	/* U+1EA6 */	U2E_NODEST_COLX,
	/* U+1EA7 */	U2E_NODEST_COLX,
	/* U+1EA8 */	U2E_NODEST_COLX,
	/* U+1EA9 */	U2E_NODEST_COLX,
	/* U+1EAA */	U2E_NODEST_COLX,
	/* U+1EAB */	U2E_NODEST_COLX,
	/* U+1EAC */	U2E_NODEST_COLX,
	/* U+1EAD */	U2E_NODEST_COLX,
	/* U+1EAE */	U2E_NODEST_COLX,
	/* U+1EAF */	U2E_NODEST_COLX,
	/* U+1EB0 */	U2E_NODEST_COLX,
	/* U+1EB1 */	U2E_NODEST_COLX,
	/* U+1EB2 */	U2E_NODEST_COLX,
	/* U+1EB3 */	U2E_NODEST_COLX,
	/* U+1EB4 */	U2E_NODEST_COLX,
	/* U+1EB5 */	U2E_NODEST_COLX,
	/* U+1EB6 */	U2E_NODEST_COLX,
	/* U+1EB7 */	U2E_NODEST_COLX,
	/* U+1EB8 */	U2E_NODEST_COLX,
	/* U+1EB9 */	U2E_NODEST_COLX,
	/* U+1EBA */	U2E_NODEST_COLX,
	/* U+1EBB */	U2E_NODEST_COLX,
	/* U+1EBC */	U2E_NODEST_COLX,
	/* U+1EBD */	U2E_NODEST_COLX,
	/* U+1EBE */	U2E_NODEST_COLX,
	/* U+1EBF */	U2E_NODEST_COLX,
	/* U+1EC0 */	U2E_NODEST_COLX,
	/* U+1EC1 */	U2E_NODEST_COLX,
	/* U+1EC2 */	U2E_NODEST_COLX,
	/* U+1EC3 */	U2E_NODEST_COLX,
	/* U+1EC4 */	U2E_NODEST_COLX,
	/* U+1EC5 */	U2E_NODEST_COLX,
	/* U+1EC6 */	U2E_NODEST_COLX,
	/* U+1EC7 */	U2E_NODEST_COLX,
	/* U+1EC8 */	U2E_NODEST_COLX,
	/* U+1EC9 */	U2E_NODEST_COLX,
	/* U+1ECA */	U2E_NODEST_COLX,
	/* U+1ECB */	U2E_NODEST_COLX,
	/* U+1ECC */	U2E_NODEST_COLX,
	/* U+1ECD */	U2E_NODEST_COLX,
	/* U+1ECE */	U2E_NODEST_COLX,
	/* U+1ECF */	U2E_NODEST_COLX,
	/* U+1ED0 */	U2E_NODEST_COLX,
	/* U+1ED1 */	U2E_NODEST_COLX,
	/* U+1ED2 */	U2E_NODEST_COLX,
	/* U+1ED3 */	U2E_NODEST_COLX,
	/* U+1ED4 */	U2E_NODEST_COLX,
	/* U+1ED5 */	U2E_NODEST_COLX,
	/* U+1ED6 */	U2E_NODEST_COLX,
	/* U+1ED7 */	U2E_NODEST_COLX,
	/* U+1ED8 */	U2E_NODEST_COLX,
	/* U+1ED9 */	U2E_NODEST_COLX,
	/* U+1EDA */	U2E_NODEST_COLX,
	/* U+1EDB */	U2E_NODEST_COLX,
	/* U+1EDC */	U2E_NODEST_COLX,
	/* U+1EDD */	U2E_NODEST_COLX,
	/* U+1EDE */	U2E_NODEST_COLX,
	/* U+1EDF */	U2E_NODEST_COLX,
	/* U+1EE0 */	U2E_NODEST_COLX,
	/* U+1EE1 */	U2E_NODEST_COLX,
	/* U+1EE2 */	U2E_NODEST_COLX,
	/* U+1EE3 */	U2E_NODEST_COLX,
	/* U+1EE4 */	U2E_NODEST_COLX,
	/* U+1EE5 */	U2E_NODEST_COLX,
	/* U+1EE6 */	U2E_NODEST_COLX,
	/* U+1EE7 */	U2E_NODEST_COLX,
	/* U+1EE8 */	U2E_NODEST_COLX,
	/* U+1EE9 */	U2E_NODEST_COLX,
	/* U+1EEA */	U2E_NODEST_COLX,
	/* U+1EEB */	U2E_NODEST_COLX,
	/* U+1EEC */	U2E_NODEST_COLX,
	/* U+1EED */	U2E_NODEST_COLX,
	/* U+1EEE */	U2E_NODEST_COLX,
	/* U+1EEF */	U2E_NODEST_COLX,
	/* U+1EF0 */	U2E_NODEST_COLX,
	/* U+1EF1 */	U2E_NODEST_COLX,
	/* U+1EF2 */	U2E_NODEST_COLX,
	/* U+1EF3 */	U2E_NODEST_COLX,
	/* U+1EF4 */	U2E_NODEST_COLX,
	/* U+1EF5 */	U2E_NODEST_COLX,
	/* U+1EF6 */	U2E_NODEST_COLX,
	/* U+1EF7 */	U2E_NODEST_COLX,
	/* U+1EF8 */	U2E_NODEST_COLX,
	/* U+1EF9 */	U2E_NODEST_COLX,
	/* U+1EFA */	U2E_NODEST_COLX,
	/* U+1EFB */	U2E_NODEST_COLX,
	/* U+1EFC */	U2E_NODEST_COLX,
	/* U+1EFD */	U2E_NODEST_COLX,
	/* U+1EFE */	U2E_NODEST_COLX,
	/* U+1EFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_1F[] = {
	/* U+1F00 */	U2E_NODEST_COLX,
	/* U+1F01 */	U2E_NODEST_COLX,
	/* U+1F02 */	U2E_NODEST_COLX,
	/* U+1F03 */	U2E_NODEST_COLX,
	/* U+1F04 */	U2E_NODEST_COLX,
	/* U+1F05 */	U2E_NODEST_COLX,
	/* U+1F06 */	U2E_NODEST_COLX,
	/* U+1F07 */	U2E_NODEST_COLX,
	/* U+1F08 */	U2E_NODEST_COLX,
	/* U+1F09 */	U2E_NODEST_COLX,
	/* U+1F0A */	U2E_NODEST_COLX,
	/* U+1F0B */	U2E_NODEST_COLX,
	/* U+1F0C */	U2E_NODEST_COLX,
	/* U+1F0D */	U2E_NODEST_COLX,
	/* U+1F0E */	U2E_NODEST_COLX,
	/* U+1F0F */	U2E_NODEST_COLX,
	/* U+1F10 */	U2E_NODEST_COLX,
	/* U+1F11 */	U2E_NODEST_COLX,
	/* U+1F12 */	U2E_NODEST_COLX,
	/* U+1F13 */	U2E_NODEST_COLX,
	/* U+1F14 */	U2E_NODEST_COLX,
	/* U+1F15 */	U2E_NODEST_COLX,
	/* U+1F16 */	U2E_NODEST_COLX,
	/* U+1F17 */	U2E_NODEST_COLX,
	/* U+1F18 */	U2E_NODEST_COLX,
	/* U+1F19 */	U2E_NODEST_COLX,
	/* U+1F1A */	U2E_NODEST_COLX,
	/* U+1F1B */	U2E_NODEST_COLX,
	/* U+1F1C */	U2E_NODEST_COLX,
	/* U+1F1D */	U2E_NODEST_COLX,
	/* U+1F1E */	U2E_NODEST_COLX,
	/* U+1F1F */	U2E_NODEST_COLX,
	/* U+1F20 */	U2E_NODEST_COLX,
	/* U+1F21 */	U2E_NODEST_COLX,
	/* U+1F22 */	U2E_NODEST_COLX,
	/* U+1F23 */	U2E_NODEST_COLX,
	/* U+1F24 */	U2E_NODEST_COLX,
	/* U+1F25 */	U2E_NODEST_COLX,
	/* U+1F26 */	U2E_NODEST_COLX,
	/* U+1F27 */	U2E_NODEST_COLX,
	/* U+1F28 */	U2E_NODEST_COLX,
	/* U+1F29 */	U2E_NODEST_COLX,
	/* U+1F2A */	U2E_NODEST_COLX,
	/* U+1F2B */	U2E_NODEST_COLX,
	/* U+1F2C */	U2E_NODEST_COLX,
	/* U+1F2D */	U2E_NODEST_COLX,
	/* U+1F2E */	U2E_NODEST_COLX,
	/* U+1F2F */	U2E_NODEST_COLX,
	/* U+1F30 */	U2E_NODEST_COLX,
	/* U+1F31 */	U2E_NODEST_COLX,
	/* U+1F32 */	U2E_NODEST_COLX,
	/* U+1F33 */	U2E_NODEST_COLX,
	/* U+1F34 */	U2E_NODEST_COLX,
	/* U+1F35 */	U2E_NODEST_COLX,
	/* U+1F36 */	U2E_NODEST_COLX,
	/* U+1F37 */	U2E_NODEST_COLX,
	/* U+1F38 */	U2E_NODEST_COLX,
	/* U+1F39 */	U2E_NODEST_COLX,
	/* U+1F3A */	U2E_NODEST_COLX,
	/* U+1F3B */	U2E_NODEST_COLX,
	/* U+1F3C */	U2E_NODEST_COLX,
	/* U+1F3D */	U2E_NODEST_COLX,
	/* U+1F3E */	U2E_NODEST_COLX,
	/* U+1F3F */	U2E_NODEST_COLX,
	/* U+1F40 */	U2E_NODEST_COLX,
	/* U+1F41 */	U2E_NODEST_COLX,
	/* U+1F42 */	U2E_NODEST_COLX,
	/* U+1F43 */	U2E_NODEST_COLX,
	/* U+1F44 */	U2E_NODEST_COLX,
	/* U+1F45 */	U2E_NODEST_COLX,
	/* U+1F46 */	U2E_NODEST_COLX,
	/* U+1F47 */	U2E_NODEST_COLX,
	/* U+1F48 */	U2E_NODEST_COLX,
	/* U+1F49 */	U2E_NODEST_COLX,
	/* U+1F4A */	U2E_NODEST_COLX,
	/* U+1F4B */	U2E_NODEST_COLX,
	/* U+1F4C */	U2E_NODEST_COLX,
	/* U+1F4D */	U2E_NODEST_COLX,
	/* U+1F4E */	U2E_NODEST_COLX,
	/* U+1F4F */	U2E_NODEST_COLX,
	/* U+1F50 */	U2E_NODEST_COLX,
	/* U+1F51 */	U2E_NODEST_COLX,
	/* U+1F52 */	U2E_NODEST_COLX,
	/* U+1F53 */	U2E_NODEST_COLX,
	/* U+1F54 */	U2E_NODEST_COLX,
	/* U+1F55 */	U2E_NODEST_COLX,
	/* U+1F56 */	U2E_NODEST_COLX,
	/* U+1F57 */	U2E_NODEST_COLX,
	/* U+1F58 */	U2E_NODEST_COLX,
	/* U+1F59 */	U2E_NODEST_COLX,
	/* U+1F5A */	U2E_NODEST_COLX,
	/* U+1F5B */	U2E_NODEST_COLX,
	/* U+1F5C */	U2E_NODEST_COLX,
	/* U+1F5D */	U2E_NODEST_COLX,
	/* U+1F5E */	U2E_NODEST_COLX,
	/* U+1F5F */	U2E_NODEST_COLX,
	/* U+1F60 */	U2E_NODEST_COLX,
	/* U+1F61 */	U2E_NODEST_COLX,
	/* U+1F62 */	U2E_NODEST_COLX,
	/* U+1F63 */	U2E_NODEST_COLX,
	/* U+1F64 */	U2E_NODEST_COLX,
	/* U+1F65 */	U2E_NODEST_COLX,
	/* U+1F66 */	U2E_NODEST_COLX,
	/* U+1F67 */	U2E_NODEST_COLX,
	/* U+1F68 */	U2E_NODEST_COLX,
	/* U+1F69 */	U2E_NODEST_COLX,
	/* U+1F6A */	U2E_NODEST_COLX,
	/* U+1F6B */	U2E_NODEST_COLX,
	/* U+1F6C */	U2E_NODEST_COLX,
	/* U+1F6D */	U2E_NODEST_COLX,
	/* U+1F6E */	U2E_NODEST_COLX,
	/* U+1F6F */	U2E_NODEST_COLX,
	/* U+1F70 */	IFX0213(JISX0213_1(0xabc6),	U2E_NODEST_COLX),
	/* U+1F71 */	IFX0213(JISX0213_1(0xabc7),	U2E_NODEST_COLX),
	/* U+1F72 */	IFX0213(JISX0213_1(0xabd0),	U2E_NODEST_COLX),
	/* U+1F73 */	IFX0213(JISX0213_1(0xabd1),	U2E_NODEST_COLX),
	/* U+1F74 */	U2E_NODEST_COLX,
	/* U+1F75 */	U2E_NODEST_COLX,
	/* U+1F76 */	U2E_NODEST_COLX,
	/* U+1F77 */	U2E_NODEST_COLX,
	/* U+1F78 */	U2E_NODEST_COLX,
	/* U+1F79 */	U2E_NODEST_COLX,
	/* U+1F7A */	U2E_NODEST_COLX,
	/* U+1F7B */	U2E_NODEST_COLX,
	/* U+1F7C */	U2E_NODEST_COLX,
	/* U+1F7D */	U2E_NODEST_COLX,
	/* U+1F7E */	U2E_NODEST_COLX,
	/* U+1F7F */	U2E_NODEST_COLX,
	/* U+1F80 */	U2E_NODEST_COLX,
	/* U+1F81 */	U2E_NODEST_COLX,
	/* U+1F82 */	U2E_NODEST_COLX,
	/* U+1F83 */	U2E_NODEST_COLX,
	/* U+1F84 */	U2E_NODEST_COLX,
	/* U+1F85 */	U2E_NODEST_COLX,
	/* U+1F86 */	U2E_NODEST_COLX,
	/* U+1F87 */	U2E_NODEST_COLX,
	/* U+1F88 */	U2E_NODEST_COLX,
	/* U+1F89 */	U2E_NODEST_COLX,
	/* U+1F8A */	U2E_NODEST_COLX,
	/* U+1F8B */	U2E_NODEST_COLX,
	/* U+1F8C */	U2E_NODEST_COLX,
	/* U+1F8D */	U2E_NODEST_COLX,
	/* U+1F8E */	U2E_NODEST_COLX,
	/* U+1F8F */	U2E_NODEST_COLX,
	/* U+1F90 */	U2E_NODEST_COLX,
	/* U+1F91 */	U2E_NODEST_COLX,
	/* U+1F92 */	U2E_NODEST_COLX,
	/* U+1F93 */	U2E_NODEST_COLX,
	/* U+1F94 */	U2E_NODEST_COLX,
	/* U+1F95 */	U2E_NODEST_COLX,
	/* U+1F96 */	U2E_NODEST_COLX,
	/* U+1F97 */	U2E_NODEST_COLX,
	/* U+1F98 */	U2E_NODEST_COLX,
	/* U+1F99 */	U2E_NODEST_COLX,
	/* U+1F9A */	U2E_NODEST_COLX,
	/* U+1F9B */	U2E_NODEST_COLX,
	/* U+1F9C */	U2E_NODEST_COLX,
	/* U+1F9D */	U2E_NODEST_COLX,
	/* U+1F9E */	U2E_NODEST_COLX,
	/* U+1F9F */	U2E_NODEST_COLX,
	/* U+1FA0 */	U2E_NODEST_COLX,
	/* U+1FA1 */	U2E_NODEST_COLX,
	/* U+1FA2 */	U2E_NODEST_COLX,
	/* U+1FA3 */	U2E_NODEST_COLX,
	/* U+1FA4 */	U2E_NODEST_COLX,
	/* U+1FA5 */	U2E_NODEST_COLX,
	/* U+1FA6 */	U2E_NODEST_COLX,
	/* U+1FA7 */	U2E_NODEST_COLX,
	/* U+1FA8 */	U2E_NODEST_COLX,
	/* U+1FA9 */	U2E_NODEST_COLX,
	/* U+1FAA */	U2E_NODEST_COLX,
	/* U+1FAB */	U2E_NODEST_COLX,
	/* U+1FAC */	U2E_NODEST_COLX,
	/* U+1FAD */	U2E_NODEST_COLX,
	/* U+1FAE */	U2E_NODEST_COLX,
	/* U+1FAF */	U2E_NODEST_COLX,
	/* U+1FB0 */	U2E_NODEST_COLX,
	/* U+1FB1 */	U2E_NODEST_COLX,
	/* U+1FB2 */	U2E_NODEST_COLX,
	/* U+1FB3 */	U2E_NODEST_COLX,
	/* U+1FB4 */	U2E_NODEST_COLX,
	/* U+1FB5 */	U2E_NODEST_COLX,
	/* U+1FB6 */	U2E_NODEST_COLX,
	/* U+1FB7 */	U2E_NODEST_COLX,
	/* U+1FB8 */	U2E_NODEST_COLX,
	/* U+1FB9 */	U2E_NODEST_COLX,
	/* U+1FBA */	U2E_NODEST_COLX,
	/* U+1FBB */	U2E_NODEST_COLX,
	/* U+1FBC */	U2E_NODEST_COLX,
	/* U+1FBD */	U2E_NODEST_COLX,
	/* U+1FBE */	U2E_NODEST_COLX,
	/* U+1FBF */	U2E_NODEST_COLX,
	/* U+1FC0 */	U2E_NODEST_COLX,
	/* U+1FC1 */	U2E_NODEST_COLX,
	/* U+1FC2 */	U2E_NODEST_COLX,
	/* U+1FC3 */	U2E_NODEST_COLX,
	/* U+1FC4 */	U2E_NODEST_COLX,
	/* U+1FC5 */	U2E_NODEST_COLX,
	/* U+1FC6 */	U2E_NODEST_COLX,
	/* U+1FC7 */	U2E_NODEST_COLX,
	/* U+1FC8 */	U2E_NODEST_COLX,
	/* U+1FC9 */	U2E_NODEST_COLX,
	/* U+1FCA */	U2E_NODEST_COLX,
	/* U+1FCB */	U2E_NODEST_COLX,
	/* U+1FCC */	U2E_NODEST_COLX,
	/* U+1FCD */	U2E_NODEST_COLX,
	/* U+1FCE */	U2E_NODEST_COLX,
	/* U+1FCF */	U2E_NODEST_COLX,
	/* U+1FD0 */	U2E_NODEST_COLX,
	/* U+1FD1 */	U2E_NODEST_COLX,
	/* U+1FD2 */	U2E_NODEST_COLX,
	/* U+1FD3 */	U2E_NODEST_COLX,
	/* U+1FD4 */	U2E_NODEST_COLX,
	/* U+1FD5 */	U2E_NODEST_COLX,
	/* U+1FD6 */	U2E_NODEST_COLX,
	/* U+1FD7 */	U2E_NODEST_COLX,
	/* U+1FD8 */	U2E_NODEST_COLX,
	/* U+1FD9 */	U2E_NODEST_COLX,
	/* U+1FDA */	U2E_NODEST_COLX,
	/* U+1FDB */	U2E_NODEST_COLX,
	/* U+1FDC */	U2E_NODEST_COLX,
	/* U+1FDD */	U2E_NODEST_COLX,
	/* U+1FDE */	U2E_NODEST_COLX,
	/* U+1FDF */	U2E_NODEST_COLX,
	/* U+1FE0 */	U2E_NODEST_COLX,
	/* U+1FE1 */	U2E_NODEST_COLX,
	/* U+1FE2 */	U2E_NODEST_COLX,
	/* U+1FE3 */	U2E_NODEST_COLX,
	/* U+1FE4 */	U2E_NODEST_COLX,
	/* U+1FE5 */	U2E_NODEST_COLX,
	/* U+1FE6 */	U2E_NODEST_COLX,
	/* U+1FE7 */	U2E_NODEST_COLX,
	/* U+1FE8 */	U2E_NODEST_COLX,
	/* U+1FE9 */	U2E_NODEST_COLX,
	/* U+1FEA */	U2E_NODEST_COLX,
	/* U+1FEB */	U2E_NODEST_COLX,
	/* U+1FEC */	U2E_NODEST_COLX,
	/* U+1FED */	U2E_NODEST_COLX,
	/* U+1FEE */	U2E_NODEST_COLX,
	/* U+1FEF */	U2E_NODEST_COLX,
	/* U+1FF0 */	U2E_NODEST_COLX,
	/* U+1FF1 */	U2E_NODEST_COLX,
	/* U+1FF2 */	U2E_NODEST_COLX,
	/* U+1FF3 */	U2E_NODEST_COLX,
	/* U+1FF4 */	U2E_NODEST_COLX,
	/* U+1FF5 */	U2E_NODEST_COLX,
	/* U+1FF6 */	U2E_NODEST_COLX,
	/* U+1FF7 */	U2E_NODEST_COLX,
	/* U+1FF8 */	U2E_NODEST_COLX,
	/* U+1FF9 */	U2E_NODEST_COLX,
	/* U+1FFA */	U2E_NODEST_COLX,
	/* U+1FFB */	U2E_NODEST_COLX,
	/* U+1FFC */	U2E_NODEST_COLX,
	/* U+1FFD */	U2E_NODEST_COLX,
	/* U+1FFE */	U2E_NODEST_COLX,
	/* U+1FFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_20[] = {
	/* U+2000 */	U2E_NODEST_COLX,
	/* U+2001 */	U2E_NODEST_COLX,
	/* U+2002 */	U2E_NODEST_COLX,
	/* U+2003 */	U2E_NODEST_COLX,
	/* U+2004 */	U2E_NODEST_COLX,
	/* U+2005 */	U2E_NODEST_COLX,
	/* U+2006 */	U2E_NODEST_COLX,
	/* U+2007 */	U2E_NODEST_COLX,
	/* U+2008 */	U2E_NODEST_COLX,
	/* U+2009 */	U2E_NODEST_COLX,
	/* U+200A */	U2E_NODEST_COLX,
	/* U+200B */	U2E_NODEST_COLX,
	/* U+200C */	U2E_NODEST_COLX,
	/* U+200D */	U2E_NODEST_COLX,
	/* U+200E */	U2E_NODEST_COLX,
	/* U+200F */	U2E_NODEST_COLX,
	/* U+2010 */	JISX0208(0xa1be),
	/* U+2011 */	U2E_NODEST_COLX,
	/* U+2012 */	U2E_NODEST_COLX,
	/* U+2013 */	IFX0213(JISX0213_1(0xa3fc),	U2E_NODEST_COLX),
	/* U+2014 */	U2E_NODEST_COLX,
	/* U+2015 */	JISX0208(0xa1bd),
	/* U+2016 */	U2E_2016_DEST,
	/* U+2017 */	U2E_NODEST_COLX,
	/* U+2018 */	JISX0208(0xa1c6),
	/* U+2019 */	JISX0208(0xa1c7),
	/* U+201A */	U2E_NODEST_COLX,
	/* U+201B */	U2E_NODEST_COLX,
	/* U+201C */	JISX0208(0xa1c8),
	/* U+201D */	JISX0208(0xa1c9),
	/* U+201E */	U2E_NODEST_COLX,
	/* U+201F */	U2E_NODEST_COLX,
	/* U+2020 */	JISX0208(0xa2f7),
	/* U+2021 */	JISX0208(0xa2f8),
	/* U+2022 */	IFX0213(JISX0213_1(0xa3c0),	U2E_NODEST_COLX),
	/* U+2023 */	U2E_NODEST_COLX,
	/* U+2024 */	U2E_NODEST_COLX,
	/* U+2025 */	JISX0208(0xa1c5),
	/* U+2026 */	JISX0208(0xa1c4),
	/* U+2027 */	U2E_NODEST_COLX,
	/* U+2028 */	U2E_NODEST_COLX,
	/* U+2029 */	U2E_NODEST_COLX,
	/* U+202A */	U2E_NODEST_COLX,
	/* U+202B */	U2E_NODEST_COLX,
	/* U+202C */	U2E_NODEST_COLX,
	/* U+202D */	U2E_NODEST_COLX,
	/* U+202E */	U2E_NODEST_COLX,
	/* U+202F */	U2E_NODEST_COLX,
	/* U+2030 */	JISX0208(0xa2f3),
	/* U+2031 */	U2E_NODEST_COLX,
	/* U+2032 */	JISX0208(0xa1ec),
	/* U+2033 */	JISX0208(0xa1ed),
	/* U+2034 */	U2E_NODEST_COLX,
	/* U+2035 */	U2E_NODEST_COLX,
	/* U+2036 */	U2E_NODEST_COLX,
	/* U+2037 */	U2E_NODEST_COLX,
	/* U+2038 */	U2E_NODEST_COLX,
	/* U+2039 */	U2E_NODEST_COLX,
	/* U+203A */	U2E_NODEST_COLX,
	/* U+203B */	JISX0208(0xa2a8),
	/* U+203C */	IFX0213(JISX0213_1(0xa8eb),	U2E_NODEST_COLX),
	/* U+203D */	U2E_NODEST_COLX,
	/* U+203E */	U2E_203E_DEST,
	/* U+203F */	IFX0213(JISX0213_1(0xabd8),	U2E_NODEST_COLX),
	/* U+2040 */	U2E_NODEST_COLX,
	/* U+2041 */	U2E_NODEST_COLX,
	/* U+2042 */	IFX0213(JISX0213_1(0xacfe),	U2E_NODEST_COLX),
	/* U+2043 */	U2E_NODEST_COLX,
	/* U+2044 */	U2E_NODEST_COLX,
	/* U+2045 */	U2E_NODEST_COLX,
	/* U+2046 */	U2E_NODEST_COLX,
	/* U+2047 */	IFX0213(JISX0213_1(0xa8ec),	U2E_NODEST_COLX),
	/* U+2048 */	IFX0213(JISX0213_1(0xa8ed),	U2E_NODEST_COLX),
	/* U+2049 */	IFX0213(JISX0213_1(0xa8ee),	U2E_NODEST_COLX),
	/* U+204A */	U2E_NODEST_COLX,
	/* U+204B */	U2E_NODEST_COLX,
	/* U+204C */	U2E_NODEST_COLX,
	/* U+204D */	U2E_NODEST_COLX,
	/* U+204E */	U2E_NODEST_COLX,
	/* U+204F */	U2E_NODEST_COLX,
	/* U+2050 */	U2E_NODEST_COLX,
	/* U+2051 */	IFX0213(JISX0213_1(0xacfd),	U2E_NODEST_COLX),
	/* U+2052 */	U2E_NODEST_COLX,
	/* U+2053 */	U2E_NODEST_COLX,
	/* U+2054 */	U2E_NODEST_COLX,
	/* U+2055 */	U2E_NODEST_COLX,
	/* U+2056 */	U2E_NODEST_COLX,
	/* U+2057 */	U2E_NODEST_COLX,
	/* U+2058 */	U2E_NODEST_COLX,
	/* U+2059 */	U2E_NODEST_COLX,
	/* U+205A */	U2E_NODEST_COLX,
	/* U+205B */	U2E_NODEST_COLX,
	/* U+205C */	U2E_NODEST_COLX,
	/* U+205D */	U2E_NODEST_COLX,
	/* U+205E */	U2E_NODEST_COLX,
	/* U+205F */	U2E_NODEST_COLX,
	/* U+2060 */	U2E_NODEST_COLX,
	/* U+2061 */	U2E_NODEST_COLX,
	/* U+2062 */	U2E_NODEST_COLX,
	/* U+2063 */	U2E_NODEST_COLX,
	/* U+2064 */	U2E_NODEST_COLX,
	/* U+2065 */	U2E_NODEST_COLX,
	/* U+2066 */	U2E_NODEST_COLX,
	/* U+2067 */	U2E_NODEST_COLX,
	/* U+2068 */	U2E_NODEST_COLX,
	/* U+2069 */	U2E_NODEST_COLX,
	/* U+206A */	U2E_NODEST_COLX,
	/* U+206B */	U2E_NODEST_COLX,
	/* U+206C */	U2E_NODEST_COLX,
	/* U+206D */	U2E_NODEST_COLX,
	/* U+206E */	U2E_NODEST_COLX,
	/* U+206F */	U2E_NODEST_COLX,
	/* U+2070 */	U2E_NODEST_COLX,
	/* U+2071 */	U2E_NODEST_COLX,
	/* U+2072 */	U2E_NODEST_COLX,
	/* U+2073 */	U2E_NODEST_COLX,
	/* U+2074 */	U2E_NODEST_COLX,
	/* U+2075 */	U2E_NODEST_COLX,
	/* U+2076 */	U2E_NODEST_COLX,
	/* U+2077 */	U2E_NODEST_COLX,
	/* U+2078 */	U2E_NODEST_COLX,
	/* U+2079 */	U2E_NODEST_COLX,
	/* U+207A */	U2E_NODEST_COLX,
	/* U+207B */	U2E_NODEST_COLX,
	/* U+207C */	U2E_NODEST_COLX,
	/* U+207D */	U2E_NODEST_COLX,
	/* U+207E */	U2E_NODEST_COLX,
	/* U+207F */	U2E_NODEST_COLX,
	/* U+2080 */	U2E_NODEST_COLX,
	/* U+2081 */	U2E_NODEST_COLX,
	/* U+2082 */	U2E_NODEST_COLX,
	/* U+2083 */	U2E_NODEST_COLX,
	/* U+2084 */	U2E_NODEST_COLX,
	/* U+2085 */	U2E_NODEST_COLX,
	/* U+2086 */	U2E_NODEST_COLX,
	/* U+2087 */	U2E_NODEST_COLX,
	/* U+2088 */	U2E_NODEST_COLX,
	/* U+2089 */	U2E_NODEST_COLX,
	/* U+208A */	U2E_NODEST_COLX,
	/* U+208B */	U2E_NODEST_COLX,
	/* U+208C */	U2E_NODEST_COLX,
	/* U+208D */	U2E_NODEST_COLX,
	/* U+208E */	U2E_NODEST_COLX,
	/* U+208F */	U2E_NODEST_COLX,
	/* U+2090 */	U2E_NODEST_COLX,
	/* U+2091 */	U2E_NODEST_COLX,
	/* U+2092 */	U2E_NODEST_COLX,
	/* U+2093 */	U2E_NODEST_COLX,
	/* U+2094 */	U2E_NODEST_COLX,
	/* U+2095 */	U2E_NODEST_COLX,
	/* U+2096 */	U2E_NODEST_COLX,
	/* U+2097 */	U2E_NODEST_COLX,
	/* U+2098 */	U2E_NODEST_COLX,
	/* U+2099 */	U2E_NODEST_COLX,
	/* U+209A */	U2E_NODEST_COLX,
	/* U+209B */	U2E_NODEST_COLX,
	/* U+209C */	U2E_NODEST_COLX,
	/* U+209D */	U2E_NODEST_COLX,
	/* U+209E */	U2E_NODEST_COLX,
	/* U+209F */	U2E_NODEST_COLX,
	/* U+20A0 */	U2E_NODEST_COLX,
	/* U+20A1 */	U2E_NODEST_COLX,
	/* U+20A2 */	U2E_NODEST_COLX,
	/* U+20A3 */	U2E_NODEST_COLX,
	/* U+20A4 */	U2E_NODEST_COLX,
	/* U+20A5 */	U2E_NODEST_COLX,
	/* U+20A6 */	U2E_NODEST_COLX,
	/* U+20A7 */	U2E_NODEST_COLX,
	/* U+20A8 */	U2E_NODEST_COLX,
	/* U+20A9 */	U2E_NODEST_COLX,
	/* U+20AA */	U2E_NODEST_COLX,
	/* U+20AB */	U2E_NODEST_COLX,
	/* U+20AC */	IFX0213(JISX0213_1(0xa9a1),	U2E_NODEST_COLX),
	/* U+20AD */	U2E_NODEST_COLX,
	/* U+20AE */	U2E_NODEST_COLX,
	/* U+20AF */	U2E_NODEST_COLX,
	/* U+20B0 */	U2E_NODEST_COLX,
	/* U+20B1 */	U2E_NODEST_COLX,
	/* U+20B2 */	U2E_NODEST_COLX,
	/* U+20B3 */	U2E_NODEST_COLX,
	/* U+20B4 */	U2E_NODEST_COLX,
	/* U+20B5 */	U2E_NODEST_COLX,
	/* U+20B6 */	U2E_NODEST_COLX,
	/* U+20B7 */	U2E_NODEST_COLX,
	/* U+20B8 */	U2E_NODEST_COLX,
	/* U+20B9 */	U2E_NODEST_COLX,
	/* U+20BA */	U2E_NODEST_COLX,
	/* U+20BB */	U2E_NODEST_COLX,
	/* U+20BC */	U2E_NODEST_COLX,
	/* U+20BD */	U2E_NODEST_COLX,
	/* U+20BE */	U2E_NODEST_COLX,
	/* U+20BF */	U2E_NODEST_COLX,
	/* U+20C0 */	U2E_NODEST_COLX,
	/* U+20C1 */	U2E_NODEST_COLX,
	/* U+20C2 */	U2E_NODEST_COLX,
	/* U+20C3 */	U2E_NODEST_COLX,
	/* U+20C4 */	U2E_NODEST_COLX,
	/* U+20C5 */	U2E_NODEST_COLX,
	/* U+20C6 */	U2E_NODEST_COLX,
	/* U+20C7 */	U2E_NODEST_COLX,
	/* U+20C8 */	U2E_NODEST_COLX,
	/* U+20C9 */	U2E_NODEST_COLX,
	/* U+20CA */	U2E_NODEST_COLX,
	/* U+20CB */	U2E_NODEST_COLX,
	/* U+20CC */	U2E_NODEST_COLX,
	/* U+20CD */	U2E_NODEST_COLX,
	/* U+20CE */	U2E_NODEST_COLX,
	/* U+20CF */	U2E_NODEST_COLX,
	/* U+20D0 */	U2E_NODEST_COLX,
	/* U+20D1 */	U2E_NODEST_COLX,
	/* U+20D2 */	U2E_NODEST_COLX,
	/* U+20D3 */	U2E_NODEST_COLX,
	/* U+20D4 */	U2E_NODEST_COLX,
	/* U+20D5 */	U2E_NODEST_COLX,
	/* U+20D6 */	U2E_NODEST_COLX,
	/* U+20D7 */	U2E_NODEST_COLX,
	/* U+20D8 */	U2E_NODEST_COLX,
	/* U+20D9 */	U2E_NODEST_COLX,
	/* U+20DA */	U2E_NODEST_COLX,
	/* U+20DB */	U2E_NODEST_COLX,
	/* U+20DC */	U2E_NODEST_COLX,
	/* U+20DD */	U2E_NODEST_COLX,
	/* U+20DE */	U2E_NODEST_COLX,
	/* U+20DF */	U2E_NODEST_COLX,
	/* U+20E0 */	U2E_NODEST_COLX,
	/* U+20E1 */	U2E_NODEST_COLX,
	/* U+20E2 */	U2E_NODEST_COLX,
	/* U+20E3 */	U2E_NODEST_COLX,
	/* U+20E4 */	U2E_NODEST_COLX,
	/* U+20E5 */	U2E_NODEST_COLX,
	/* U+20E6 */	U2E_NODEST_COLX,
	/* U+20E7 */	U2E_NODEST_COLX,
	/* U+20E8 */	U2E_NODEST_COLX,
	/* U+20E9 */	U2E_NODEST_COLX,
	/* U+20EA */	U2E_NODEST_COLX,
	/* U+20EB */	U2E_NODEST_COLX,
	/* U+20EC */	U2E_NODEST_COLX,
	/* U+20ED */	U2E_NODEST_COLX,
	/* U+20EE */	U2E_NODEST_COLX,
	/* U+20EF */	U2E_NODEST_COLX,
	/* U+20F0 */	U2E_NODEST_COLX,
	/* U+20F1 */	U2E_NODEST_COLX,
	/* U+20F2 */	U2E_NODEST_COLX,
	/* U+20F3 */	U2E_NODEST_COLX,
	/* U+20F4 */	U2E_NODEST_COLX,
	/* U+20F5 */	U2E_NODEST_COLX,
	/* U+20F6 */	U2E_NODEST_COLX,
	/* U+20F7 */	U2E_NODEST_COLX,
	/* U+20F8 */	U2E_NODEST_COLX,
	/* U+20F9 */	U2E_NODEST_COLX,
	/* U+20FA */	U2E_NODEST_COLX,
	/* U+20FB */	U2E_NODEST_COLX,
	/* U+20FC */	U2E_NODEST_COLX,
	/* U+20FD */	U2E_NODEST_COLX,
	/* U+20FE */	U2E_NODEST_COLX,
	/* U+20FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_21[] = {
	/* U+2100 */	U2E_NODEST_COLX,
	/* U+2101 */	U2E_NODEST_COLX,
	/* U+2102 */	U2E_NODEST_COLX,
	/* U+2103 */	JISX0208(0xa1ee),
	/* U+2104 */	U2E_NODEST_COLX,
	/* U+2105 */	U2E_NODEST_COLX,
	/* U+2106 */	U2E_NODEST_COLX,
	/* U+2107 */	U2E_NODEST_COLX,
	/* U+2108 */	U2E_NODEST_COLX,
	/* U+2109 */	U2E_NODEST_COLX,
	/* U+210A */	U2E_NODEST_COLX,
	/* U+210B */	U2E_NODEST_COLX,
	/* U+210C */	U2E_NODEST_COLX,
	/* U+210D */	U2E_NODEST_COLX,
	/* U+210E */	U2E_NODEST_COLX,
	/* U+210F */	IFX0213(JISX0213_1(0xa3dd),	U2E_NODEST_COLX),
	/* U+2110 */	U2E_NODEST_COLX,
	/* U+2111 */	U2E_NODEST_COLX,
	/* U+2112 */	U2E_NODEST_COLX,
	/* U+2113 */	IFX0213(JISX0213_1(0xa3df),	U2E_NODEST_COLX),
	/* U+2114 */	U2E_NODEST_COLX,
	/* U+2115 */	U2E_NODEST_COLX,
	/* U+2116 */	U2E_2116_DEST,
	/* U+2117 */	U2E_NODEST_COLX,
	/* U+2118 */	U2E_NODEST_COLX,
	/* U+2119 */	U2E_NODEST_COLX,
	/* U+211A */	U2E_NODEST_COLX,
	/* U+211B */	U2E_NODEST_COLX,
	/* U+211C */	U2E_NODEST_COLX,
	/* U+211D */	U2E_NODEST_COLX,
	/* U+211E */	U2E_NODEST_COLX,
	/* U+211F */	U2E_NODEST_COLX,
	/* U+2120 */	U2E_NODEST_COLX,
	/* U+2121 */	IFX0213(JISX0213_1(0xade4),	NEC13(0xade4)),
	/* U+2122 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xa26f)),
	/* U+2123 */	U2E_NODEST_COLX,
	/* U+2124 */	U2E_NODEST_COLX,
	/* U+2125 */	U2E_NODEST_COLX,
	/* U+2126 */	U2E_NODEST_COLX,
	/* U+2127 */	IFX0213(JISX0213_1(0xa3e0),	U2E_NODEST_COLX),
	/* U+2128 */	U2E_NODEST_COLX,
	/* U+2129 */	U2E_NODEST_COLX,
	/* U+212A */	U2E_NODEST_COLX,
	/* U+212B */	JISX0208(0xa2f2),
	/* U+212C */	U2E_NODEST_COLX,
	/* U+212D */	U2E_NODEST_COLX,
	/* U+212E */	U2E_NODEST_COLX,
	/* U+212F */	U2E_NODEST_COLX,
	/* U+2130 */	U2E_NODEST_COLX,
	/* U+2131 */	U2E_NODEST_COLX,
	/* U+2132 */	U2E_NODEST_COLX,
	/* U+2133 */	U2E_NODEST_COLX,
	/* U+2134 */	U2E_NODEST_COLX,
	/* U+2135 */	IFX0213(JISX0213_1(0xa3dc),	U2E_NODEST_COLX),
	/* U+2136 */	U2E_NODEST_COLX,
	/* U+2137 */	U2E_NODEST_COLX,
	/* U+2138 */	U2E_NODEST_COLX,
	/* U+2139 */	U2E_NODEST_COLX,
	/* U+213A */	U2E_NODEST_COLX,
	/* U+213B */	U2E_NODEST_COLX,
	/* U+213C */	U2E_NODEST_COLX,
	/* U+213D */	U2E_NODEST_COLX,
	/* U+213E */	U2E_NODEST_COLX,
	/* U+213F */	U2E_NODEST_COLX,
	/* U+2140 */	U2E_NODEST_COLX,
	/* U+2141 */	U2E_NODEST_COLX,
	/* U+2142 */	U2E_NODEST_COLX,
	/* U+2143 */	U2E_NODEST_COLX,
	/* U+2144 */	U2E_NODEST_COLX,
	/* U+2145 */	U2E_NODEST_COLX,
	/* U+2146 */	U2E_NODEST_COLX,
	/* U+2147 */	U2E_NODEST_COLX,
	/* U+2148 */	U2E_NODEST_COLX,
	/* U+2149 */	U2E_NODEST_COLX,
	/* U+214A */	U2E_NODEST_COLX,
	/* U+214B */	U2E_NODEST_COLX,
	/* U+214C */	U2E_NODEST_COLX,
	/* U+214D */	U2E_NODEST_COLX,
	/* U+214E */	U2E_NODEST_COLX,
	/* U+214F */	U2E_NODEST_COLX,
	/* U+2150 */	U2E_NODEST_COLX,
	/* U+2151 */	U2E_NODEST_COLX,
	/* U+2152 */	U2E_NODEST_COLX,
	/* U+2153 */	IFX0213(JISX0213_1(0xa7f8),	U2E_NODEST_COLX),
	/* U+2154 */	IFX0213(JISX0213_1(0xa7f9),	U2E_NODEST_COLX),
	/* U+2155 */	IFX0213(JISX0213_1(0xa7fa),	U2E_NODEST_COLX),
	/* U+2156 */	U2E_NODEST_COLX,
	/* U+2157 */	U2E_NODEST_COLX,
	/* U+2158 */	U2E_NODEST_COLX,
	/* U+2159 */	U2E_NODEST_COLX,
	/* U+215A */	U2E_NODEST_COLX,
	/* U+215B */	U2E_NODEST_COLX,
	/* U+215C */	U2E_NODEST_COLX,
	/* U+215D */	U2E_NODEST_COLX,
	/* U+215E */	U2E_NODEST_COLX,
	/* U+215F */	U2E_NODEST_COLX,
	/* U+2160 */	IFX0213(JISX0213_1(0xadb5),	NEC13(0xadb5)),
	/* U+2161 */	IFX0213(JISX0213_1(0xadb6),	NEC13(0xadb6)),
	/* U+2162 */	IFX0213(JISX0213_1(0xadb7),	NEC13(0xadb7)),
	/* U+2163 */	IFX0213(JISX0213_1(0xadb8),	NEC13(0xadb8)),
	/* U+2164 */	IFX0213(JISX0213_1(0xadb9),	NEC13(0xadb9)),
	/* U+2165 */	IFX0213(JISX0213_1(0xadba),	NEC13(0xadba)),
	/* U+2166 */	IFX0213(JISX0213_1(0xadbb),	NEC13(0xadbb)),
	/* U+2167 */	IFX0213(JISX0213_1(0xadbc),	NEC13(0xadbc)),
	/* U+2168 */	IFX0213(JISX0213_1(0xadbd),	NEC13(0xadbd)),
	/* U+2169 */	IFX0213(JISX0213_1(0xadbe),	NEC13(0xadbe)),
	/* U+216A */	IFX0213(JISX0213_1(0xadbf),	U2E_NODEST_COLX),
	/* U+216B */	IFX0213(JISX0213_1(0xadd7),	U2E_NODEST_COLX),
	/* U+216C */	U2E_NODEST_COLX,
	/* U+216D */	U2E_NODEST_COLX,
	/* U+216E */	U2E_NODEST_COLX,
	/* U+216F */	U2E_NODEST_COLX,
	/* U+2170 */	IFX0213(JISX0213_1(0xacb5),	IBM(0xf373)),
	/* U+2171 */	IFX0213(JISX0213_1(0xacb6),	IBM(0xf374)),
	/* U+2172 */	IFX0213(JISX0213_1(0xacb7),	IBM(0xf375)),
	/* U+2173 */	IFX0213(JISX0213_1(0xacb8),	IBM(0xf376)),
	/* U+2174 */	IFX0213(JISX0213_1(0xacb9),	IBM(0xf377)),
	/* U+2175 */	IFX0213(JISX0213_1(0xacba),	IBM(0xf378)),
	/* U+2176 */	IFX0213(JISX0213_1(0xacbb),	IBM(0xf379)),
	/* U+2177 */	IFX0213(JISX0213_1(0xacbc),	IBM(0xf37a)),
	/* U+2178 */	IFX0213(JISX0213_1(0xacbd),	IBM(0xf37b)),
	/* U+2179 */	IFX0213(JISX0213_1(0xacbe),	IBM(0xf37c)),
	/* U+217A */	IFX0213(JISX0213_1(0xacbf),	U2E_NODEST_COLX),
	/* U+217B */	IFX0213(JISX0213_1(0xacc0),	U2E_NODEST_COLX),
	/* U+217C */	U2E_NODEST_COLX,
	/* U+217D */	U2E_NODEST_COLX,
	/* U+217E */	U2E_NODEST_COLX,
	/* U+217F */	U2E_NODEST_COLX,
	/* U+2180 */	U2E_NODEST_COLX,
	/* U+2181 */	U2E_NODEST_COLX,
	/* U+2182 */	U2E_NODEST_COLX,
	/* U+2183 */	U2E_NODEST_COLX,
	/* U+2184 */	U2E_NODEST_COLX,
	/* U+2185 */	U2E_NODEST_COLX,
	/* U+2186 */	U2E_NODEST_COLX,
	/* U+2187 */	U2E_NODEST_COLX,
	/* U+2188 */	U2E_NODEST_COLX,
	/* U+2189 */	U2E_NODEST_COLX,
	/* U+218A */	U2E_NODEST_COLX,
	/* U+218B */	U2E_NODEST_COLX,
	/* U+218C */	U2E_NODEST_COLX,
	/* U+218D */	U2E_NODEST_COLX,
	/* U+218E */	U2E_NODEST_COLX,
	/* U+218F */	U2E_NODEST_COLX,
	/* U+2190 */	JISX0208(0xa2ab),
	/* U+2191 */	JISX0208(0xa2ac),
	/* U+2192 */	JISX0208(0xa2aa),
	/* U+2193 */	JISX0208(0xa2ad),
	/* U+2194 */	IFX0213(JISX0213_1(0xa2f1),	U2E_NODEST_COLX),
	/* U+2195 */	U2E_NODEST_COLX,
	/* U+2196 */	IFX0213(JISX0213_1(0xa3a7),	U2E_NODEST_COLX),
	/* U+2197 */	IFX0213(JISX0213_1(0xa3a5),	U2E_NODEST_COLX),
	/* U+2198 */	IFX0213(JISX0213_1(0xa3a6),	U2E_NODEST_COLX),
	/* U+2199 */	IFX0213(JISX0213_1(0xa3a8),	U2E_NODEST_COLX),
	/* U+219A */	U2E_NODEST_COLX,
	/* U+219B */	U2E_NODEST_COLX,
	/* U+219C */	U2E_NODEST_COLX,
	/* U+219D */	U2E_NODEST_COLX,
	/* U+219E */	U2E_NODEST_COLX,
	/* U+219F */	U2E_NODEST_COLX,
	/* U+21A0 */	U2E_NODEST_COLX,
	/* U+21A1 */	U2E_NODEST_COLX,
	/* U+21A2 */	U2E_NODEST_COLX,
	/* U+21A3 */	U2E_NODEST_COLX,
	/* U+21A4 */	U2E_NODEST_COLX,
	/* U+21A5 */	U2E_NODEST_COLX,
	/* U+21A6 */	U2E_NODEST_COLX,
	/* U+21A7 */	U2E_NODEST_COLX,
	/* U+21A8 */	U2E_NODEST_COLX,
	/* U+21A9 */	U2E_NODEST_COLX,
	/* U+21AA */	U2E_NODEST_COLX,
	/* U+21AB */	U2E_NODEST_COLX,
	/* U+21AC */	U2E_NODEST_COLX,
	/* U+21AD */	U2E_NODEST_COLX,
	/* U+21AE */	U2E_NODEST_COLX,
	/* U+21AF */	U2E_NODEST_COLX,
	/* U+21B0 */	U2E_NODEST_COLX,
	/* U+21B1 */	U2E_NODEST_COLX,
	/* U+21B2 */	U2E_NODEST_COLX,
	/* U+21B3 */	U2E_NODEST_COLX,
	/* U+21B4 */	U2E_NODEST_COLX,
	/* U+21B5 */	U2E_NODEST_COLX,
	/* U+21B6 */	U2E_NODEST_COLX,
	/* U+21B7 */	U2E_NODEST_COLX,
	/* U+21B8 */	U2E_NODEST_COLX,
	/* U+21B9 */	U2E_NODEST_COLX,
	/* U+21BA */	U2E_NODEST_COLX,
	/* U+21BB */	U2E_NODEST_COLX,
	/* U+21BC */	U2E_NODEST_COLX,
	/* U+21BD */	U2E_NODEST_COLX,
	/* U+21BE */	U2E_NODEST_COLX,
	/* U+21BF */	U2E_NODEST_COLX,
	/* U+21C0 */	U2E_NODEST_COLX,
	/* U+21C1 */	U2E_NODEST_COLX,
	/* U+21C2 */	U2E_NODEST_COLX,
	/* U+21C3 */	U2E_NODEST_COLX,
	/* U+21C4 */	IFX0213(JISX0213_1(0xa3a9),	U2E_NODEST_COLX),
	/* U+21C5 */	U2E_NODEST_COLX,
	/* U+21C6 */	U2E_NODEST_COLX,
	/* U+21C7 */	U2E_NODEST_COLX,
	/* U+21C8 */	U2E_NODEST_COLX,
	/* U+21C9 */	U2E_NODEST_COLX,
	/* U+21CA */	U2E_NODEST_COLX,
	/* U+21CB */	U2E_NODEST_COLX,
	/* U+21CC */	U2E_NODEST_COLX,
	/* U+21CD */	U2E_NODEST_COLX,
	/* U+21CE */	U2E_NODEST_COLX,
	/* U+21CF */	U2E_NODEST_COLX,
	/* U+21D0 */	U2E_NODEST_COLX,
	/* U+21D1 */	U2E_NODEST_COLX,
	/* U+21D2 */	JISX0208(0xa2cd),
	/* U+21D3 */	U2E_NODEST_COLX,
	/* U+21D4 */	JISX0208(0xa2ce),
	/* U+21D5 */	U2E_NODEST_COLX,
	/* U+21D6 */	U2E_NODEST_COLX,
	/* U+21D7 */	U2E_NODEST_COLX,
	/* U+21D8 */	U2E_NODEST_COLX,
	/* U+21D9 */	U2E_NODEST_COLX,
	/* U+21DA */	U2E_NODEST_COLX,
	/* U+21DB */	U2E_NODEST_COLX,
	/* U+21DC */	U2E_NODEST_COLX,
	/* U+21DD */	U2E_NODEST_COLX,
	/* U+21DE */	U2E_NODEST_COLX,
	/* U+21DF */	U2E_NODEST_COLX,
	/* U+21E0 */	U2E_NODEST_COLX,
	/* U+21E1 */	U2E_NODEST_COLX,
	/* U+21E2 */	U2E_NODEST_COLX,
	/* U+21E3 */	U2E_NODEST_COLX,
	/* U+21E4 */	U2E_NODEST_COLX,
	/* U+21E5 */	U2E_NODEST_COLX,
	/* U+21E6 */	IFX0213(JISX0213_1(0xa3ab),	U2E_NODEST_COLX),
	/* U+21E7 */	IFX0213(JISX0213_1(0xa3ac),	U2E_NODEST_COLX),
	/* U+21E8 */	IFX0213(JISX0213_1(0xa3aa),	U2E_NODEST_COLX),
	/* U+21E9 */	IFX0213(JISX0213_1(0xa3ad),	U2E_NODEST_COLX),
	/* U+21EA */	U2E_NODEST_COLX,
	/* U+21EB */	U2E_NODEST_COLX,
	/* U+21EC */	U2E_NODEST_COLX,
	/* U+21ED */	U2E_NODEST_COLX,
	/* U+21EE */	U2E_NODEST_COLX,
	/* U+21EF */	U2E_NODEST_COLX,
	/* U+21F0 */	U2E_NODEST_COLX,
	/* U+21F1 */	U2E_NODEST_COLX,
	/* U+21F2 */	U2E_NODEST_COLX,
	/* U+21F3 */	U2E_NODEST_COLX,
	/* U+21F4 */	U2E_NODEST_COLX,
	/* U+21F5 */	U2E_NODEST_COLX,
	/* U+21F6 */	U2E_NODEST_COLX,
	/* U+21F7 */	U2E_NODEST_COLX,
	/* U+21F8 */	U2E_NODEST_COLX,
	/* U+21F9 */	U2E_NODEST_COLX,
	/* U+21FA */	U2E_NODEST_COLX,
	/* U+21FB */	U2E_NODEST_COLX,
	/* U+21FC */	U2E_NODEST_COLX,
	/* U+21FD */	U2E_NODEST_COLX,
	/* U+21FE */	U2E_NODEST_COLX,
	/* U+21FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_22[] = {
	/* U+2200 */	JISX0208(0xa2cf),
	/* U+2201 */	U2E_NODEST_COLX,
	/* U+2202 */	JISX0208(0xa2df),
	/* U+2203 */	JISX0208(0xa2d0),
	/* U+2204 */	U2E_NODEST_COLX,
	/* U+2205 */	IFX0213(JISX0213_1(0xa2c7),	U2E_NODEST_COLX),
	/* U+2206 */	U2E_NODEST_COLX,
	/* U+2207 */	JISX0208(0xa2e0),
	/* U+2208 */	JISX0208(0xa2ba),
	/* U+2209 */	IFX0213(JISX0213_1(0xa2c6),	U2E_NODEST_COLX),
	/* U+220A */	U2E_NODEST_COLX,
	/* U+220B */	JISX0208(0xa2bb),
	/* U+220C */	U2E_NODEST_COLX,
	/* U+220D */	U2E_NODEST_COLX,
	/* U+220E */	U2E_NODEST_COLX,
	/* U+220F */	U2E_NODEST_COLX,
	/* U+2210 */	U2E_NODEST_COLX,
	/* U+2211 */	IFX0213(U2E_NODEST_COLX,	NEC13(0xadf4)),
	/* U+2212 */	U2E_2212_DEST,
	/* U+2213 */	IFX0213(JISX0213_1(0xa3db),	U2E_NODEST_COLX),
	/* U+2214 */	U2E_NODEST_COLX,
	/* U+2215 */	U2E_NODEST_COLX,
	/* U+2216 */	U2E_NODEST_COLX,
	/* U+2217 */	U2E_NODEST_COLX,
	/* U+2218 */	U2E_NODEST_COLX,
	/* U+2219 */	U2E_NODEST_COLX,
	/* U+221A */	JISX0208(0xa2e5),
	/* U+221B */	U2E_NODEST_COLX,
	/* U+221C */	U2E_NODEST_COLX,
	/* U+221D */	JISX0208(0xa2e7),
	/* U+221E */	JISX0208(0xa1e7),
	/* U+221F */	IFX0213(JISX0213_1(0xadf8),	NEC13(0xadf8)),
	/* U+2220 */	JISX0208(0xa2dc),
	/* U+2221 */	U2E_NODEST_COLX,
	/* U+2222 */	U2E_NODEST_COLX,
	/* U+2223 */	U2E_NODEST_COLX,
	/* U+2224 */	U2E_NODEST_COLX,
	/* U+2225 */	U2E_2225_DEST,
	/* U+2226 */	IFX0213(JISX0213_1(0xa2d5),	U2E_NODEST_COLX),
	/* U+2227 */	JISX0208(0xa2ca),
	/* U+2228 */	JISX0208(0xa2cb),
	/* U+2229 */	JISX0208(0xa2c1),
	/* U+222A */	JISX0208(0xa2c0),
	/* U+222B */	JISX0208(0xa2e9),
	/* U+222C */	JISX0208(0xa2ea),
	/* U+222D */	U2E_NODEST_COLX,
	/* U+222E */	IFX0213(JISX0213_1(0xadf3),	NEC13(0xadf3)),
	/* U+222F */	U2E_NODEST_COLX,
	/* U+2230 */	U2E_NODEST_COLX,
	/* U+2231 */	U2E_NODEST_COLX,
	/* U+2232 */	U2E_NODEST_COLX,
	/* U+2233 */	U2E_NODEST_COLX,
	/* U+2234 */	JISX0208(0xa1e8),
	/* U+2235 */	JISX0208(0xa2e8),
	/* U+2236 */	U2E_NODEST_COLX,
	/* U+2237 */	U2E_NODEST_COLX,
	/* U+2238 */	U2E_NODEST_COLX,
	/* U+2239 */	U2E_NODEST_COLX,
	/* U+223A */	U2E_NODEST_COLX,
	/* U+223B */	U2E_NODEST_COLX,
	/* U+223C */	U2E_NODEST_COLX,
	/* U+223D */	JISX0208(0xa2e6),
	/* U+223E */	U2E_NODEST_COLX,
	/* U+223F */	U2E_NODEST_COLX,
	/* U+2240 */	U2E_NODEST_COLX,
	/* U+2241 */	U2E_NODEST_COLX,
	/* U+2242 */	U2E_NODEST_COLX,
	/* U+2243 */	IFX0213(JISX0213_1(0xa2ec),	U2E_NODEST_COLX),
	/* U+2244 */	U2E_NODEST_COLX,
	/* U+2245 */	IFX0213(JISX0213_1(0xa2ed),	U2E_NODEST_COLX),
	/* U+2246 */	U2E_NODEST_COLX,
	/* U+2247 */	U2E_NODEST_COLX,
	/* U+2248 */	IFX0213(JISX0213_1(0xa2ee),	U2E_NODEST_COLX),
	/* U+2249 */	U2E_NODEST_COLX,
	/* U+224A */	U2E_NODEST_COLX,
	/* U+224B */	U2E_NODEST_COLX,
	/* U+224C */	U2E_NODEST_COLX,
	/* U+224D */	U2E_NODEST_COLX,
	/* U+224E */	U2E_NODEST_COLX,
	/* U+224F */	U2E_NODEST_COLX,
	/* U+2250 */	U2E_NODEST_COLX,
	/* U+2251 */	U2E_NODEST_COLX,
	/* U+2252 */	JISX0208(0xa2e2),
	/* U+2253 */	U2E_NODEST_COLX,
	/* U+2254 */	U2E_NODEST_COLX,
	/* U+2255 */	U2E_NODEST_COLX,
	/* U+2256 */	U2E_NODEST_COLX,
	/* U+2257 */	U2E_NODEST_COLX,
	/* U+2258 */	U2E_NODEST_COLX,
	/* U+2259 */	U2E_NODEST_COLX,
	/* U+225A */	U2E_NODEST_COLX,
	/* U+225B */	U2E_NODEST_COLX,
	/* U+225C */	U2E_NODEST_COLX,
	/* U+225D */	U2E_NODEST_COLX,
	/* U+225E */	U2E_NODEST_COLX,
	/* U+225F */	U2E_NODEST_COLX,
	/* U+2260 */	JISX0208(0xa1e2),
	/* U+2261 */	JISX0208(0xa2e1),
	/* U+2262 */	IFX0213(JISX0213_1(0xa2eb),	U2E_NODEST_COLX),
	/* U+2263 */	U2E_NODEST_COLX,
	/* U+2264 */	U2E_NODEST_COLX,
	/* U+2265 */	U2E_NODEST_COLX,
	/* U+2266 */	JISX0208(0xa1e5),
	/* U+2267 */	JISX0208(0xa1e6),
	/* U+2268 */	U2E_NODEST_COLX,
	/* U+2269 */	U2E_NODEST_COLX,
	/* U+226A */	JISX0208(0xa2e3),
	/* U+226B */	JISX0208(0xa2e4),
	/* U+226C */	U2E_NODEST_COLX,
	/* U+226D */	U2E_NODEST_COLX,
	/* U+226E */	U2E_NODEST_COLX,
	/* U+226F */	U2E_NODEST_COLX,
	/* U+2270 */	U2E_NODEST_COLX,
	/* U+2271 */	U2E_NODEST_COLX,
	/* U+2272 */	U2E_NODEST_COLX,
	/* U+2273 */	U2E_NODEST_COLX,
	/* U+2274 */	U2E_NODEST_COLX,
	/* U+2275 */	U2E_NODEST_COLX,
	/* U+2276 */	IFX0213(JISX0213_1(0xa2ef),	U2E_NODEST_COLX),
	/* U+2277 */	IFX0213(JISX0213_1(0xa2f0),	U2E_NODEST_COLX),
	/* U+2278 */	U2E_NODEST_COLX,
	/* U+2279 */	U2E_NODEST_COLX,
	/* U+227A */	U2E_NODEST_COLX,
	/* U+227B */	U2E_NODEST_COLX,
	/* U+227C */	U2E_NODEST_COLX,
	/* U+227D */	U2E_NODEST_COLX,
	/* U+227E */	U2E_NODEST_COLX,
	/* U+227F */	U2E_NODEST_COLX,
	/* U+2280 */	U2E_NODEST_COLX,
	/* U+2281 */	U2E_NODEST_COLX,
	/* U+2282 */	JISX0208(0xa2be),
	/* U+2283 */	JISX0208(0xa2bf),
	/* U+2284 */	IFX0213(JISX0213_1(0xa2c2),	U2E_NODEST_COLX),
	/* U+2285 */	IFX0213(JISX0213_1(0xa2c3),	U2E_NODEST_COLX),
	/* U+2286 */	JISX0208(0xa2bc),
	/* U+2287 */	JISX0208(0xa2bd),
	/* U+2288 */	U2E_NODEST_COLX,
	/* U+2289 */	U2E_NODEST_COLX,
	/* U+228A */	IFX0213(JISX0213_1(0xa2c4),	U2E_NODEST_COLX),
	/* U+228B */	IFX0213(JISX0213_1(0xa2c5),	U2E_NODEST_COLX),
	/* U+228C */	U2E_NODEST_COLX,
	/* U+228D */	U2E_NODEST_COLX,
	/* U+228E */	U2E_NODEST_COLX,
	/* U+228F */	U2E_NODEST_COLX,
	/* U+2290 */	U2E_NODEST_COLX,
	/* U+2291 */	U2E_NODEST_COLX,
	/* U+2292 */	U2E_NODEST_COLX,
	/* U+2293 */	U2E_NODEST_COLX,
	/* U+2294 */	U2E_NODEST_COLX,
	/* U+2295 */	IFX0213(JISX0213_1(0xa2d1),	U2E_NODEST_COLX),
	/* U+2296 */	IFX0213(JISX0213_1(0xa2d2),	U2E_NODEST_COLX),
	/* U+2297 */	IFX0213(JISX0213_1(0xa2d3),	U2E_NODEST_COLX),
	/* U+2298 */	U2E_NODEST_COLX,
	/* U+2299 */	U2E_NODEST_COLX,
	/* U+229A */	U2E_NODEST_COLX,
	/* U+229B */	U2E_NODEST_COLX,
	/* U+229C */	U2E_NODEST_COLX,
	/* U+229D */	U2E_NODEST_COLX,
	/* U+229E */	U2E_NODEST_COLX,
	/* U+229F */	U2E_NODEST_COLX,
	/* U+22A0 */	U2E_NODEST_COLX,
	/* U+22A1 */	U2E_NODEST_COLX,
	/* U+22A2 */	U2E_NODEST_COLX,
	/* U+22A3 */	U2E_NODEST_COLX,
	/* U+22A4 */	U2E_NODEST_COLX,
	/* U+22A5 */	JISX0208(0xa2dd),
	/* U+22A6 */	U2E_NODEST_COLX,
	/* U+22A7 */	U2E_NODEST_COLX,
	/* U+22A8 */	U2E_NODEST_COLX,
	/* U+22A9 */	U2E_NODEST_COLX,
	/* U+22AA */	U2E_NODEST_COLX,
	/* U+22AB */	U2E_NODEST_COLX,
	/* U+22AC */	U2E_NODEST_COLX,
	/* U+22AD */	U2E_NODEST_COLX,
	/* U+22AE */	U2E_NODEST_COLX,
	/* U+22AF */	U2E_NODEST_COLX,
	/* U+22B0 */	U2E_NODEST_COLX,
	/* U+22B1 */	U2E_NODEST_COLX,
	/* U+22B2 */	U2E_NODEST_COLX,
	/* U+22B3 */	U2E_NODEST_COLX,
	/* U+22B4 */	U2E_NODEST_COLX,
	/* U+22B5 */	U2E_NODEST_COLX,
	/* U+22B6 */	U2E_NODEST_COLX,
	/* U+22B7 */	U2E_NODEST_COLX,
	/* U+22B8 */	U2E_NODEST_COLX,
	/* U+22B9 */	U2E_NODEST_COLX,
	/* U+22BA */	U2E_NODEST_COLX,
	/* U+22BB */	U2E_NODEST_COLX,
	/* U+22BC */	U2E_NODEST_COLX,
	/* U+22BD */	U2E_NODEST_COLX,
	/* U+22BE */	U2E_NODEST_COLX,
	/* U+22BF */	IFX0213(JISX0213_1(0xadf9),	NEC13(0xadf9)),
	/* U+22C0 */	U2E_NODEST_COLX,
	/* U+22C1 */	U2E_NODEST_COLX,
	/* U+22C2 */	U2E_NODEST_COLX,
	/* U+22C3 */	U2E_NODEST_COLX,
	/* U+22C4 */	U2E_NODEST_COLX,
	/* U+22C5 */	U2E_NODEST_COLX,
	/* U+22C6 */	U2E_NODEST_COLX,
	/* U+22C7 */	U2E_NODEST_COLX,
	/* U+22C8 */	U2E_NODEST_COLX,
	/* U+22C9 */	U2E_NODEST_COLX,
	/* U+22CA */	U2E_NODEST_COLX,
	/* U+22CB */	U2E_NODEST_COLX,
	/* U+22CC */	U2E_NODEST_COLX,
	/* U+22CD */	U2E_NODEST_COLX,
	/* U+22CE */	U2E_NODEST_COLX,
	/* U+22CF */	U2E_NODEST_COLX,
	/* U+22D0 */	U2E_NODEST_COLX,
	/* U+22D1 */	U2E_NODEST_COLX,
	/* U+22D2 */	U2E_NODEST_COLX,
	/* U+22D3 */	U2E_NODEST_COLX,
	/* U+22D4 */	U2E_NODEST_COLX,
	/* U+22D5 */	U2E_NODEST_COLX,
	/* U+22D6 */	U2E_NODEST_COLX,
	/* U+22D7 */	U2E_NODEST_COLX,
	/* U+22D8 */	U2E_NODEST_COLX,
	/* U+22D9 */	U2E_NODEST_COLX,
	/* U+22DA */	IFX0213(JISX0213_1(0xa7f6),	U2E_NODEST_COLX),
	/* U+22DB */	IFX0213(JISX0213_1(0xa7f7),	U2E_NODEST_COLX),
	/* U+22DC */	U2E_NODEST_COLX,
	/* U+22DD */	U2E_NODEST_COLX,
	/* U+22DE */	U2E_NODEST_COLX,
	/* U+22DF */	U2E_NODEST_COLX,
	/* U+22E0 */	U2E_NODEST_COLX,
	/* U+22E1 */	U2E_NODEST_COLX,
	/* U+22E2 */	U2E_NODEST_COLX,
	/* U+22E3 */	U2E_NODEST_COLX,
	/* U+22E4 */	U2E_NODEST_COLX,
	/* U+22E5 */	U2E_NODEST_COLX,
	/* U+22E6 */	U2E_NODEST_COLX,
	/* U+22E7 */	U2E_NODEST_COLX,
	/* U+22E8 */	U2E_NODEST_COLX,
	/* U+22E9 */	U2E_NODEST_COLX,
	/* U+22EA */	U2E_NODEST_COLX,
	/* U+22EB */	U2E_NODEST_COLX,
	/* U+22EC */	U2E_NODEST_COLX,
	/* U+22ED */	U2E_NODEST_COLX,
	/* U+22EE */	U2E_NODEST_COLX,
	/* U+22EF */	U2E_NODEST_COLX,
	/* U+22F0 */	U2E_NODEST_COLX,
	/* U+22F1 */	U2E_NODEST_COLX,
	/* U+22F2 */	U2E_NODEST_COLX,
	/* U+22F3 */	U2E_NODEST_COLX,
	/* U+22F4 */	U2E_NODEST_COLX,
	/* U+22F5 */	U2E_NODEST_COLX,
	/* U+22F6 */	U2E_NODEST_COLX,
	/* U+22F7 */	U2E_NODEST_COLX,
	/* U+22F8 */	U2E_NODEST_COLX,
	/* U+22F9 */	U2E_NODEST_COLX,
	/* U+22FA */	U2E_NODEST_COLX,
	/* U+22FB */	U2E_NODEST_COLX,
	/* U+22FC */	U2E_NODEST_COLX,
	/* U+22FD */	U2E_NODEST_COLX,
	/* U+22FE */	U2E_NODEST_COLX,
	/* U+22FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_23[] = {
	/* U+2300 */	U2E_NODEST_COLX,
	/* U+2301 */	U2E_NODEST_COLX,
	/* U+2302 */	U2E_NODEST_COLX,
	/* U+2303 */	U2E_NODEST_COLX,
	/* U+2304 */	U2E_NODEST_COLX,
	/* U+2305 */	IFX0213(JISX0213_1(0xa2c8),	U2E_NODEST_COLX),
	/* U+2306 */	IFX0213(JISX0213_1(0xa2c9),	U2E_NODEST_COLX),
	/* U+2307 */	U2E_NODEST_COLX,
	/* U+2308 */	U2E_NODEST_COLX,
	/* U+2309 */	U2E_NODEST_COLX,
	/* U+230A */	U2E_NODEST_COLX,
	/* U+230B */	U2E_NODEST_COLX,
	/* U+230C */	U2E_NODEST_COLX,
	/* U+230D */	U2E_NODEST_COLX,
	/* U+230E */	U2E_NODEST_COLX,
	/* U+230F */	U2E_NODEST_COLX,
	/* U+2310 */	U2E_NODEST_COLX,
	/* U+2311 */	U2E_NODEST_COLX,
	/* U+2312 */	JISX0208(0xa2de),
	/* U+2313 */	U2E_NODEST_COLX,
	/* U+2314 */	U2E_NODEST_COLX,
	/* U+2315 */	U2E_NODEST_COLX,
	/* U+2316 */	U2E_NODEST_COLX,
	/* U+2317 */	U2E_NODEST_COLX,
	/* U+2318 */	IFX0213(JISX0213_1(0xa7fc),	U2E_NODEST_COLX),
	/* U+2319 */	U2E_NODEST_COLX,
	/* U+231A */	U2E_NODEST_COLX,
	/* U+231B */	U2E_NODEST_COLX,
	/* U+231C */	U2E_NODEST_COLX,
	/* U+231D */	U2E_NODEST_COLX,
	/* U+231E */	U2E_NODEST_COLX,
	/* U+231F */	U2E_NODEST_COLX,
	/* U+2320 */	U2E_NODEST_COLX,
	/* U+2321 */	U2E_NODEST_COLX,
	/* U+2322 */	U2E_NODEST_COLX,
	/* U+2323 */	U2E_NODEST_COLX,
	/* U+2324 */	U2E_NODEST_COLX,
	/* U+2325 */	U2E_NODEST_COLX,
	/* U+2326 */	U2E_NODEST_COLX,
	/* U+2327 */	U2E_NODEST_COLX,
	/* U+2328 */	U2E_NODEST_COLX,
	/* U+2329 */	U2E_NODEST_COLX,
	/* U+232A */	U2E_NODEST_COLX,
	/* U+232B */	U2E_NODEST_COLX,
	/* U+232C */	U2E_NODEST_COLX,
	/* U+232D */	U2E_NODEST_COLX,
	/* U+232E */	U2E_NODEST_COLX,
	/* U+232F */	U2E_NODEST_COLX,
	/* U+2330 */	U2E_NODEST_COLX,
	/* U+2331 */	U2E_NODEST_COLX,
	/* U+2332 */	U2E_NODEST_COLX,
	/* U+2333 */	U2E_NODEST_COLX,
	/* U+2334 */	U2E_NODEST_COLX,
	/* U+2335 */	U2E_NODEST_COLX,
	/* U+2336 */	U2E_NODEST_COLX,
	/* U+2337 */	U2E_NODEST_COLX,
	/* U+2338 */	U2E_NODEST_COLX,
	/* U+2339 */	U2E_NODEST_COLX,
	/* U+233A */	U2E_NODEST_COLX,
	/* U+233B */	U2E_NODEST_COLX,
	/* U+233C */	U2E_NODEST_COLX,
	/* U+233D */	U2E_NODEST_COLX,
	/* U+233E */	U2E_NODEST_COLX,
	/* U+233F */	U2E_NODEST_COLX,
	/* U+2340 */	U2E_NODEST_COLX,
	/* U+2341 */	U2E_NODEST_COLX,
	/* U+2342 */	U2E_NODEST_COLX,
	/* U+2343 */	U2E_NODEST_COLX,
	/* U+2344 */	U2E_NODEST_COLX,
	/* U+2345 */	U2E_NODEST_COLX,
	/* U+2346 */	U2E_NODEST_COLX,
	/* U+2347 */	U2E_NODEST_COLX,
	/* U+2348 */	U2E_NODEST_COLX,
	/* U+2349 */	U2E_NODEST_COLX,
	/* U+234A */	U2E_NODEST_COLX,
	/* U+234B */	U2E_NODEST_COLX,
	/* U+234C */	U2E_NODEST_COLX,
	/* U+234D */	U2E_NODEST_COLX,
	/* U+234E */	U2E_NODEST_COLX,
	/* U+234F */	U2E_NODEST_COLX,
	/* U+2350 */	U2E_NODEST_COLX,
	/* U+2351 */	U2E_NODEST_COLX,
	/* U+2352 */	U2E_NODEST_COLX,
	/* U+2353 */	U2E_NODEST_COLX,
	/* U+2354 */	U2E_NODEST_COLX,
	/* U+2355 */	U2E_NODEST_COLX,
	/* U+2356 */	U2E_NODEST_COLX,
	/* U+2357 */	U2E_NODEST_COLX,
	/* U+2358 */	U2E_NODEST_COLX,
	/* U+2359 */	U2E_NODEST_COLX,
	/* U+235A */	U2E_NODEST_COLX,
	/* U+235B */	U2E_NODEST_COLX,
	/* U+235C */	U2E_NODEST_COLX,
	/* U+235D */	U2E_NODEST_COLX,
	/* U+235E */	U2E_NODEST_COLX,
	/* U+235F */	U2E_NODEST_COLX,
	/* U+2360 */	U2E_NODEST_COLX,
	/* U+2361 */	U2E_NODEST_COLX,
	/* U+2362 */	U2E_NODEST_COLX,
	/* U+2363 */	U2E_NODEST_COLX,
	/* U+2364 */	U2E_NODEST_COLX,
	/* U+2365 */	U2E_NODEST_COLX,
	/* U+2366 */	U2E_NODEST_COLX,
	/* U+2367 */	U2E_NODEST_COLX,
	/* U+2368 */	U2E_NODEST_COLX,
	/* U+2369 */	U2E_NODEST_COLX,
	/* U+236A */	U2E_NODEST_COLX,
	/* U+236B */	U2E_NODEST_COLX,
	/* U+236C */	U2E_NODEST_COLX,
	/* U+236D */	U2E_NODEST_COLX,
	/* U+236E */	U2E_NODEST_COLX,
	/* U+236F */	U2E_NODEST_COLX,
	/* U+2370 */	U2E_NODEST_COLX,
	/* U+2371 */	U2E_NODEST_COLX,
	/* U+2372 */	U2E_NODEST_COLX,
	/* U+2373 */	U2E_NODEST_COLX,
	/* U+2374 */	U2E_NODEST_COLX,
	/* U+2375 */	U2E_NODEST_COLX,
	/* U+2376 */	U2E_NODEST_COLX,
	/* U+2377 */	U2E_NODEST_COLX,
	/* U+2378 */	U2E_NODEST_COLX,
	/* U+2379 */	U2E_NODEST_COLX,
	/* U+237A */	U2E_NODEST_COLX,
	/* U+237B */	U2E_NODEST_COLX,
	/* U+237C */	U2E_NODEST_COLX,
	/* U+237D */	U2E_NODEST_COLX,
	/* U+237E */	U2E_NODEST_COLX,
	/* U+237F */	U2E_NODEST_COLX,
	/* U+2380 */	U2E_NODEST_COLX,
	/* U+2381 */	U2E_NODEST_COLX,
	/* U+2382 */	U2E_NODEST_COLX,
	/* U+2383 */	U2E_NODEST_COLX,
	/* U+2384 */	U2E_NODEST_COLX,
	/* U+2385 */	U2E_NODEST_COLX,
	/* U+2386 */	U2E_NODEST_COLX,
	/* U+2387 */	U2E_NODEST_COLX,
	/* U+2388 */	U2E_NODEST_COLX,
	/* U+2389 */	U2E_NODEST_COLX,
	/* U+238A */	U2E_NODEST_COLX,
	/* U+238B */	U2E_NODEST_COLX,
	/* U+238C */	U2E_NODEST_COLX,
	/* U+238D */	U2E_NODEST_COLX,
	/* U+238E */	U2E_NODEST_COLX,
	/* U+238F */	U2E_NODEST_COLX,
	/* U+2390 */	U2E_NODEST_COLX,
	/* U+2391 */	U2E_NODEST_COLX,
	/* U+2392 */	U2E_NODEST_COLX,
	/* U+2393 */	U2E_NODEST_COLX,
	/* U+2394 */	U2E_NODEST_COLX,
	/* U+2395 */	U2E_NODEST_COLX,
	/* U+2396 */	U2E_NODEST_COLX,
	/* U+2397 */	U2E_NODEST_COLX,
	/* U+2398 */	U2E_NODEST_COLX,
	/* U+2399 */	U2E_NODEST_COLX,
	/* U+239A */	U2E_NODEST_COLX,
	/* U+239B */	U2E_NODEST_COLX,
	/* U+239C */	U2E_NODEST_COLX,
	/* U+239D */	U2E_NODEST_COLX,
	/* U+239E */	U2E_NODEST_COLX,
	/* U+239F */	U2E_NODEST_COLX,
	/* U+23A0 */	U2E_NODEST_COLX,
	/* U+23A1 */	U2E_NODEST_COLX,
	/* U+23A2 */	U2E_NODEST_COLX,
	/* U+23A3 */	U2E_NODEST_COLX,
	/* U+23A4 */	U2E_NODEST_COLX,
	/* U+23A5 */	U2E_NODEST_COLX,
	/* U+23A6 */	U2E_NODEST_COLX,
	/* U+23A7 */	U2E_NODEST_COLX,
	/* U+23A8 */	U2E_NODEST_COLX,
	/* U+23A9 */	U2E_NODEST_COLX,
	/* U+23AA */	U2E_NODEST_COLX,
	/* U+23AB */	U2E_NODEST_COLX,
	/* U+23AC */	U2E_NODEST_COLX,
	/* U+23AD */	U2E_NODEST_COLX,
	/* U+23AE */	U2E_NODEST_COLX,
	/* U+23AF */	U2E_NODEST_COLX,
	/* U+23B0 */	U2E_NODEST_COLX,
	/* U+23B1 */	U2E_NODEST_COLX,
	/* U+23B2 */	U2E_NODEST_COLX,
	/* U+23B3 */	U2E_NODEST_COLX,
	/* U+23B4 */	U2E_NODEST_COLX,
	/* U+23B5 */	U2E_NODEST_COLX,
	/* U+23B6 */	U2E_NODEST_COLX,
	/* U+23B7 */	U2E_NODEST_COLX,
	/* U+23B8 */	U2E_NODEST_COLX,
	/* U+23B9 */	U2E_NODEST_COLX,
	/* U+23BA */	U2E_NODEST_COLX,
	/* U+23BB */	U2E_NODEST_COLX,
	/* U+23BC */	U2E_NODEST_COLX,
	/* U+23BD */	U2E_NODEST_COLX,
	/* U+23BE */	IFX0213(JISX0213_1(0xa7c2),	U2E_NODEST_COLX),
	/* U+23BF */	IFX0213(JISX0213_1(0xa7c3),	U2E_NODEST_COLX),
	/* U+23C0 */	IFX0213(JISX0213_1(0xa7c4),	U2E_NODEST_COLX),
	/* U+23C1 */	IFX0213(JISX0213_1(0xa7c5),	U2E_NODEST_COLX),
	/* U+23C2 */	IFX0213(JISX0213_1(0xa7c6),	U2E_NODEST_COLX),
	/* U+23C3 */	IFX0213(JISX0213_1(0xa7c7),	U2E_NODEST_COLX),
	/* U+23C4 */	IFX0213(JISX0213_1(0xa7c8),	U2E_NODEST_COLX),
	/* U+23C5 */	IFX0213(JISX0213_1(0xa7c9),	U2E_NODEST_COLX),
	/* U+23C6 */	IFX0213(JISX0213_1(0xa7ca),	U2E_NODEST_COLX),
	/* U+23C7 */	IFX0213(JISX0213_1(0xa7cb),	U2E_NODEST_COLX),
	/* U+23C8 */	IFX0213(JISX0213_1(0xa7cc),	U2E_NODEST_COLX),
	/* U+23C9 */	IFX0213(JISX0213_1(0xa7cd),	U2E_NODEST_COLX),
	/* U+23CA */	IFX0213(JISX0213_1(0xa7ce),	U2E_NODEST_COLX),
	/* U+23CB */	IFX0213(JISX0213_1(0xa7cf),	U2E_NODEST_COLX),
	/* U+23CC */	IFX0213(JISX0213_1(0xa7d0),	U2E_NODEST_COLX),
	/* U+23CD */	U2E_NODEST_COLX,
	/* U+23CE */	IFX0213(JISX0213_1(0xa7fe),	U2E_NODEST_COLX),
	/* U+23CF */	U2E_NODEST_COLX,
	/* U+23D0 */	U2E_NODEST_COLX,
	/* U+23D1 */	U2E_NODEST_COLX,
	/* U+23D2 */	U2E_NODEST_COLX,
	/* U+23D3 */	U2E_NODEST_COLX,
	/* U+23D4 */	U2E_NODEST_COLX,
	/* U+23D5 */	U2E_NODEST_COLX,
	/* U+23D6 */	U2E_NODEST_COLX,
	/* U+23D7 */	U2E_NODEST_COLX,
	/* U+23D8 */	U2E_NODEST_COLX,
	/* U+23D9 */	U2E_NODEST_COLX,
	/* U+23DA */	U2E_NODEST_COLX,
	/* U+23DB */	U2E_NODEST_COLX,
	/* U+23DC */	U2E_NODEST_COLX,
	/* U+23DD */	U2E_NODEST_COLX,
	/* U+23DE */	U2E_NODEST_COLX,
	/* U+23DF */	U2E_NODEST_COLX,
	/* U+23E0 */	U2E_NODEST_COLX,
	/* U+23E1 */	U2E_NODEST_COLX,
	/* U+23E2 */	U2E_NODEST_COLX,
	/* U+23E3 */	U2E_NODEST_COLX,
	/* U+23E4 */	U2E_NODEST_COLX,
	/* U+23E5 */	U2E_NODEST_COLX,
	/* U+23E6 */	U2E_NODEST_COLX,
	/* U+23E7 */	U2E_NODEST_COLX,
	/* U+23E8 */	U2E_NODEST_COLX,
	/* U+23E9 */	U2E_NODEST_COLX,
	/* U+23EA */	U2E_NODEST_COLX,
	/* U+23EB */	U2E_NODEST_COLX,
	/* U+23EC */	U2E_NODEST_COLX,
	/* U+23ED */	U2E_NODEST_COLX,
	/* U+23EE */	U2E_NODEST_COLX,
	/* U+23EF */	U2E_NODEST_COLX,
	/* U+23F0 */	U2E_NODEST_COLX,
	/* U+23F1 */	U2E_NODEST_COLX,
	/* U+23F2 */	U2E_NODEST_COLX,
	/* U+23F3 */	U2E_NODEST_COLX,
	/* U+23F4 */	U2E_NODEST_COLX,
	/* U+23F5 */	U2E_NODEST_COLX,
	/* U+23F6 */	U2E_NODEST_COLX,
	/* U+23F7 */	U2E_NODEST_COLX,
	/* U+23F8 */	U2E_NODEST_COLX,
	/* U+23F9 */	U2E_NODEST_COLX,
	/* U+23FA */	U2E_NODEST_COLX,
	/* U+23FB */	U2E_NODEST_COLX,
	/* U+23FC */	U2E_NODEST_COLX,
	/* U+23FD */	U2E_NODEST_COLX,
	/* U+23FE */	U2E_NODEST_COLX,
	/* U+23FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_24[] = {
	/* U+2400 */	U2E_NODEST_COLX,
	/* U+2401 */	U2E_NODEST_COLX,
	/* U+2402 */	U2E_NODEST_COLX,
	/* U+2403 */	U2E_NODEST_COLX,
	/* U+2404 */	U2E_NODEST_COLX,
	/* U+2405 */	U2E_NODEST_COLX,
	/* U+2406 */	U2E_NODEST_COLX,
	/* U+2407 */	U2E_NODEST_COLX,
	/* U+2408 */	U2E_NODEST_COLX,
	/* U+2409 */	U2E_NODEST_COLX,
	/* U+240A */	U2E_NODEST_COLX,
	/* U+240B */	U2E_NODEST_COLX,
	/* U+240C */	U2E_NODEST_COLX,
	/* U+240D */	U2E_NODEST_COLX,
	/* U+240E */	U2E_NODEST_COLX,
	/* U+240F */	U2E_NODEST_COLX,
	/* U+2410 */	U2E_NODEST_COLX,
	/* U+2411 */	U2E_NODEST_COLX,
	/* U+2412 */	U2E_NODEST_COLX,
	/* U+2413 */	U2E_NODEST_COLX,
	/* U+2414 */	U2E_NODEST_COLX,
	/* U+2415 */	U2E_NODEST_COLX,
	/* U+2416 */	U2E_NODEST_COLX,
	/* U+2417 */	U2E_NODEST_COLX,
	/* U+2418 */	U2E_NODEST_COLX,
	/* U+2419 */	U2E_NODEST_COLX,
	/* U+241A */	U2E_NODEST_COLX,
	/* U+241B */	U2E_NODEST_COLX,
	/* U+241C */	U2E_NODEST_COLX,
	/* U+241D */	U2E_NODEST_COLX,
	/* U+241E */	U2E_NODEST_COLX,
	/* U+241F */	U2E_NODEST_COLX,
	/* U+2420 */	U2E_NODEST_COLX,
	/* U+2421 */	U2E_NODEST_COLX,
	/* U+2422 */	U2E_NODEST_COLX,
	/* U+2423 */	IFX0213(JISX0213_1(0xa7fd),	U2E_NODEST_COLX),
	/* U+2424 */	U2E_NODEST_COLX,
	/* U+2425 */	U2E_NODEST_COLX,
	/* U+2426 */	U2E_NODEST_COLX,
	/* U+2427 */	U2E_NODEST_COLX,
	/* U+2428 */	U2E_NODEST_COLX,
	/* U+2429 */	U2E_NODEST_COLX,
	/* U+242A */	U2E_NODEST_COLX,
	/* U+242B */	U2E_NODEST_COLX,
	/* U+242C */	U2E_NODEST_COLX,
	/* U+242D */	U2E_NODEST_COLX,
	/* U+242E */	U2E_NODEST_COLX,
	/* U+242F */	U2E_NODEST_COLX,
	/* U+2430 */	U2E_NODEST_COLX,
	/* U+2431 */	U2E_NODEST_COLX,
	/* U+2432 */	U2E_NODEST_COLX,
	/* U+2433 */	U2E_NODEST_COLX,
	/* U+2434 */	U2E_NODEST_COLX,
	/* U+2435 */	U2E_NODEST_COLX,
	/* U+2436 */	U2E_NODEST_COLX,
	/* U+2437 */	U2E_NODEST_COLX,
	/* U+2438 */	U2E_NODEST_COLX,
	/* U+2439 */	U2E_NODEST_COLX,
	/* U+243A */	U2E_NODEST_COLX,
	/* U+243B */	U2E_NODEST_COLX,
	/* U+243C */	U2E_NODEST_COLX,
	/* U+243D */	U2E_NODEST_COLX,
	/* U+243E */	U2E_NODEST_COLX,
	/* U+243F */	U2E_NODEST_COLX,
	/* U+2440 */	U2E_NODEST_COLX,
	/* U+2441 */	U2E_NODEST_COLX,
	/* U+2442 */	U2E_NODEST_COLX,
	/* U+2443 */	U2E_NODEST_COLX,
	/* U+2444 */	U2E_NODEST_COLX,
	/* U+2445 */	U2E_NODEST_COLX,
	/* U+2446 */	U2E_NODEST_COLX,
	/* U+2447 */	U2E_NODEST_COLX,
	/* U+2448 */	U2E_NODEST_COLX,
	/* U+2449 */	U2E_NODEST_COLX,
	/* U+244A */	U2E_NODEST_COLX,
	/* U+244B */	U2E_NODEST_COLX,
	/* U+244C */	U2E_NODEST_COLX,
	/* U+244D */	U2E_NODEST_COLX,
	/* U+244E */	U2E_NODEST_COLX,
	/* U+244F */	U2E_NODEST_COLX,
	/* U+2450 */	U2E_NODEST_COLX,
	/* U+2451 */	U2E_NODEST_COLX,
	/* U+2452 */	U2E_NODEST_COLX,
	/* U+2453 */	U2E_NODEST_COLX,
	/* U+2454 */	U2E_NODEST_COLX,
	/* U+2455 */	U2E_NODEST_COLX,
	/* U+2456 */	U2E_NODEST_COLX,
	/* U+2457 */	U2E_NODEST_COLX,
	/* U+2458 */	U2E_NODEST_COLX,
	/* U+2459 */	U2E_NODEST_COLX,
	/* U+245A */	U2E_NODEST_COLX,
	/* U+245B */	U2E_NODEST_COLX,
	/* U+245C */	U2E_NODEST_COLX,
	/* U+245D */	U2E_NODEST_COLX,
	/* U+245E */	U2E_NODEST_COLX,
	/* U+245F */	U2E_NODEST_COLX,
	/* U+2460 */	IFX0213(JISX0213_1(0xada1),	NEC13(0xada1)),
	/* U+2461 */	IFX0213(JISX0213_1(0xada2),	NEC13(0xada2)),
	/* U+2462 */	IFX0213(JISX0213_1(0xada3),	NEC13(0xada3)),
	/* U+2463 */	IFX0213(JISX0213_1(0xada4),	NEC13(0xada4)),
	/* U+2464 */	IFX0213(JISX0213_1(0xada5),	NEC13(0xada5)),
	/* U+2465 */	IFX0213(JISX0213_1(0xada6),	NEC13(0xada6)),
	/* U+2466 */	IFX0213(JISX0213_1(0xada7),	NEC13(0xada7)),
	/* U+2467 */	IFX0213(JISX0213_1(0xada8),	NEC13(0xada8)),
	/* U+2468 */	IFX0213(JISX0213_1(0xada9),	NEC13(0xada9)),
	/* U+2469 */	IFX0213(JISX0213_1(0xadaa),	NEC13(0xadaa)),
	/* U+246A */	IFX0213(JISX0213_1(0xadab),	NEC13(0xadab)),
	/* U+246B */	IFX0213(JISX0213_1(0xadac),	NEC13(0xadac)),
	/* U+246C */	IFX0213(JISX0213_1(0xadad),	NEC13(0xadad)),
	/* U+246D */	IFX0213(JISX0213_1(0xadae),	NEC13(0xadae)),
	/* U+246E */	IFX0213(JISX0213_1(0xadaf),	NEC13(0xadaf)),
	/* U+246F */	IFX0213(JISX0213_1(0xadb0),	NEC13(0xadb0)),
	/* U+2470 */	IFX0213(JISX0213_1(0xadb1),	NEC13(0xadb1)),
	/* U+2471 */	IFX0213(JISX0213_1(0xadb2),	NEC13(0xadb2)),
	/* U+2472 */	IFX0213(JISX0213_1(0xadb3),	NEC13(0xadb3)),
	/* U+2473 */	IFX0213(JISX0213_1(0xadb4),	NEC13(0xadb4)),
	/* U+2474 */	U2E_NODEST_COLX,
	/* U+2475 */	U2E_NODEST_COLX,
	/* U+2476 */	U2E_NODEST_COLX,
	/* U+2477 */	U2E_NODEST_COLX,
	/* U+2478 */	U2E_NODEST_COLX,
	/* U+2479 */	U2E_NODEST_COLX,
	/* U+247A */	U2E_NODEST_COLX,
	/* U+247B */	U2E_NODEST_COLX,
	/* U+247C */	U2E_NODEST_COLX,
	/* U+247D */	U2E_NODEST_COLX,
	/* U+247E */	U2E_NODEST_COLX,
	/* U+247F */	U2E_NODEST_COLX,
	/* U+2480 */	U2E_NODEST_COLX,
	/* U+2481 */	U2E_NODEST_COLX,
	/* U+2482 */	U2E_NODEST_COLX,
	/* U+2483 */	U2E_NODEST_COLX,
	/* U+2484 */	U2E_NODEST_COLX,
	/* U+2485 */	U2E_NODEST_COLX,
	/* U+2486 */	U2E_NODEST_COLX,
	/* U+2487 */	U2E_NODEST_COLX,
	/* U+2488 */	U2E_NODEST_COLX,
	/* U+2489 */	U2E_NODEST_COLX,
	/* U+248A */	U2E_NODEST_COLX,
	/* U+248B */	U2E_NODEST_COLX,
	/* U+248C */	U2E_NODEST_COLX,
	/* U+248D */	U2E_NODEST_COLX,
	/* U+248E */	U2E_NODEST_COLX,
	/* U+248F */	U2E_NODEST_COLX,
	/* U+2490 */	U2E_NODEST_COLX,
	/* U+2491 */	U2E_NODEST_COLX,
	/* U+2492 */	U2E_NODEST_COLX,
	/* U+2493 */	U2E_NODEST_COLX,
	/* U+2494 */	U2E_NODEST_COLX,
	/* U+2495 */	U2E_NODEST_COLX,
	/* U+2496 */	U2E_NODEST_COLX,
	/* U+2497 */	U2E_NODEST_COLX,
	/* U+2498 */	U2E_NODEST_COLX,
	/* U+2499 */	U2E_NODEST_COLX,
	/* U+249A */	U2E_NODEST_COLX,
	/* U+249B */	U2E_NODEST_COLX,
	/* U+249C */	U2E_NODEST_COLX,
	/* U+249D */	U2E_NODEST_COLX,
	/* U+249E */	U2E_NODEST_COLX,
	/* U+249F */	U2E_NODEST_COLX,
	/* U+24A0 */	U2E_NODEST_COLX,
	/* U+24A1 */	U2E_NODEST_COLX,
	/* U+24A2 */	U2E_NODEST_COLX,
	/* U+24A3 */	U2E_NODEST_COLX,
	/* U+24A4 */	U2E_NODEST_COLX,
	/* U+24A5 */	U2E_NODEST_COLX,
	/* U+24A6 */	U2E_NODEST_COLX,
	/* U+24A7 */	U2E_NODEST_COLX,
	/* U+24A8 */	U2E_NODEST_COLX,
	/* U+24A9 */	U2E_NODEST_COLX,
	/* U+24AA */	U2E_NODEST_COLX,
	/* U+24AB */	U2E_NODEST_COLX,
	/* U+24AC */	U2E_NODEST_COLX,
	/* U+24AD */	U2E_NODEST_COLX,
	/* U+24AE */	U2E_NODEST_COLX,
	/* U+24AF */	U2E_NODEST_COLX,
	/* U+24B0 */	U2E_NODEST_COLX,
	/* U+24B1 */	U2E_NODEST_COLX,
	/* U+24B2 */	U2E_NODEST_COLX,
	/* U+24B3 */	U2E_NODEST_COLX,
	/* U+24B4 */	U2E_NODEST_COLX,
	/* U+24B5 */	U2E_NODEST_COLX,
	/* U+24B6 */	U2E_NODEST_COLX,
	/* U+24B7 */	U2E_NODEST_COLX,
	/* U+24B8 */	U2E_NODEST_COLX,
	/* U+24B9 */	U2E_NODEST_COLX,
	/* U+24BA */	U2E_NODEST_COLX,
	/* U+24BB */	U2E_NODEST_COLX,
	/* U+24BC */	U2E_NODEST_COLX,
	/* U+24BD */	U2E_NODEST_COLX,
	/* U+24BE */	U2E_NODEST_COLX,
	/* U+24BF */	U2E_NODEST_COLX,
	/* U+24C0 */	U2E_NODEST_COLX,
	/* U+24C1 */	U2E_NODEST_COLX,
	/* U+24C2 */	U2E_NODEST_COLX,
	/* U+24C3 */	U2E_NODEST_COLX,
	/* U+24C4 */	U2E_NODEST_COLX,
	/* U+24C5 */	U2E_NODEST_COLX,
	/* U+24C6 */	U2E_NODEST_COLX,
	/* U+24C7 */	U2E_NODEST_COLX,
	/* U+24C8 */	U2E_NODEST_COLX,
	/* U+24C9 */	U2E_NODEST_COLX,
	/* U+24CA */	U2E_NODEST_COLX,
	/* U+24CB */	U2E_NODEST_COLX,
	/* U+24CC */	U2E_NODEST_COLX,
	/* U+24CD */	U2E_NODEST_COLX,
	/* U+24CE */	U2E_NODEST_COLX,
	/* U+24CF */	U2E_NODEST_COLX,
	/* U+24D0 */	IFX0213(JISX0213_1(0xacc1),	U2E_NODEST_COLX),
	/* U+24D1 */	IFX0213(JISX0213_1(0xacc2),	U2E_NODEST_COLX),
	/* U+24D2 */	IFX0213(JISX0213_1(0xacc3),	U2E_NODEST_COLX),
	/* U+24D3 */	IFX0213(JISX0213_1(0xacc4),	U2E_NODEST_COLX),
	/* U+24D4 */	IFX0213(JISX0213_1(0xacc5),	U2E_NODEST_COLX),
	/* U+24D5 */	IFX0213(JISX0213_1(0xacc6),	U2E_NODEST_COLX),
	/* U+24D6 */	IFX0213(JISX0213_1(0xacc7),	U2E_NODEST_COLX),
	/* U+24D7 */	IFX0213(JISX0213_1(0xacc8),	U2E_NODEST_COLX),
	/* U+24D8 */	IFX0213(JISX0213_1(0xacc9),	U2E_NODEST_COLX),
	/* U+24D9 */	IFX0213(JISX0213_1(0xacca),	U2E_NODEST_COLX),
	/* U+24DA */	IFX0213(JISX0213_1(0xaccb),	U2E_NODEST_COLX),
	/* U+24DB */	IFX0213(JISX0213_1(0xaccc),	U2E_NODEST_COLX),
	/* U+24DC */	IFX0213(JISX0213_1(0xaccd),	U2E_NODEST_COLX),
	/* U+24DD */	IFX0213(JISX0213_1(0xacce),	U2E_NODEST_COLX),
	/* U+24DE */	IFX0213(JISX0213_1(0xaccf),	U2E_NODEST_COLX),
	/* U+24DF */	IFX0213(JISX0213_1(0xacd0),	U2E_NODEST_COLX),
	/* U+24E0 */	IFX0213(JISX0213_1(0xacd1),	U2E_NODEST_COLX),
	/* U+24E1 */	IFX0213(JISX0213_1(0xacd2),	U2E_NODEST_COLX),
	/* U+24E2 */	IFX0213(JISX0213_1(0xacd3),	U2E_NODEST_COLX),
	/* U+24E3 */	IFX0213(JISX0213_1(0xacd4),	U2E_NODEST_COLX),
	/* U+24E4 */	IFX0213(JISX0213_1(0xacd5),	U2E_NODEST_COLX),
	/* U+24E5 */	IFX0213(JISX0213_1(0xacd6),	U2E_NODEST_COLX),
	/* U+24E6 */	IFX0213(JISX0213_1(0xacd7),	U2E_NODEST_COLX),
	/* U+24E7 */	IFX0213(JISX0213_1(0xacd8),	U2E_NODEST_COLX),
	/* U+24E8 */	IFX0213(JISX0213_1(0xacd9),	U2E_NODEST_COLX),
	/* U+24E9 */	IFX0213(JISX0213_1(0xacda),	U2E_NODEST_COLX),
	/* U+24EA */	U2E_NODEST_COLX,
	/* U+24EB */	IFX0213(JISX0213_1(0xacab),	U2E_NODEST_COLX),
	/* U+24EC */	IFX0213(JISX0213_1(0xacac),	U2E_NODEST_COLX),
	/* U+24ED */	IFX0213(JISX0213_1(0xacad),	U2E_NODEST_COLX),
	/* U+24EE */	IFX0213(JISX0213_1(0xacae),	U2E_NODEST_COLX),
	/* U+24EF */	IFX0213(JISX0213_1(0xacaf),	U2E_NODEST_COLX),
	/* U+24F0 */	IFX0213(JISX0213_1(0xacb0),	U2E_NODEST_COLX),
	/* U+24F1 */	IFX0213(JISX0213_1(0xacb1),	U2E_NODEST_COLX),
	/* U+24F2 */	IFX0213(JISX0213_1(0xacb2),	U2E_NODEST_COLX),
	/* U+24F3 */	IFX0213(JISX0213_1(0xacb3),	U2E_NODEST_COLX),
	/* U+24F4 */	IFX0213(JISX0213_1(0xacb4),	U2E_NODEST_COLX),
	/* U+24F5 */	IFX0213(JISX0213_1(0xa6da),	U2E_NODEST_COLX),
	/* U+24F6 */	IFX0213(JISX0213_1(0xa6db),	U2E_NODEST_COLX),
	/* U+24F7 */	IFX0213(JISX0213_1(0xa6dc),	U2E_NODEST_COLX),
	/* U+24F8 */	IFX0213(JISX0213_1(0xa6dd),	U2E_NODEST_COLX),
	/* U+24F9 */	IFX0213(JISX0213_1(0xa6de),	U2E_NODEST_COLX),
	/* U+24FA */	IFX0213(JISX0213_1(0xa6df),	U2E_NODEST_COLX),
	/* U+24FB */	IFX0213(JISX0213_1(0xa6e0),	U2E_NODEST_COLX),
	/* U+24FC */	IFX0213(JISX0213_1(0xa6e1),	U2E_NODEST_COLX),
	/* U+24FD */	IFX0213(JISX0213_1(0xa6e2),	U2E_NODEST_COLX),
	/* U+24FE */	IFX0213(JISX0213_1(0xa6e3),	U2E_NODEST_COLX),
	/* U+24FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_25[] = {
	/* U+2500 */	JISX0208(0xa8a1),
	/* U+2501 */	JISX0208(0xa8ac),
	/* U+2502 */	JISX0208(0xa8a2),
	/* U+2503 */	JISX0208(0xa8ad),
	/* U+2504 */	U2E_NODEST_COLX,
	/* U+2505 */	U2E_NODEST_COLX,
	/* U+2506 */	U2E_NODEST_COLX,
	/* U+2507 */	U2E_NODEST_COLX,
	/* U+2508 */	U2E_NODEST_COLX,
	/* U+2509 */	U2E_NODEST_COLX,
	/* U+250A */	U2E_NODEST_COLX,
	/* U+250B */	U2E_NODEST_COLX,
	/* U+250C */	JISX0208(0xa8a3),
	/* U+250D */	U2E_NODEST_COLX,
	/* U+250E */	U2E_NODEST_COLX,
	/* U+250F */	JISX0208(0xa8ae),
	/* U+2510 */	JISX0208(0xa8a4),
	/* U+2511 */	U2E_NODEST_COLX,
	/* U+2512 */	U2E_NODEST_COLX,
	/* U+2513 */	JISX0208(0xa8af),
	/* U+2514 */	JISX0208(0xa8a6),
	/* U+2515 */	U2E_NODEST_COLX,
	/* U+2516 */	U2E_NODEST_COLX,
	/* U+2517 */	JISX0208(0xa8b1),
	/* U+2518 */	JISX0208(0xa8a5),
	/* U+2519 */	U2E_NODEST_COLX,
	/* U+251A */	U2E_NODEST_COLX,
	/* U+251B */	JISX0208(0xa8b0),
	/* U+251C */	JISX0208(0xa8a7),
	/* U+251D */	JISX0208(0xa8bc),
	/* U+251E */	U2E_NODEST_COLX,
	/* U+251F */	U2E_NODEST_COLX,
	/* U+2520 */	JISX0208(0xa8b7),
	/* U+2521 */	U2E_NODEST_COLX,
	/* U+2522 */	U2E_NODEST_COLX,
	/* U+2523 */	JISX0208(0xa8b2),
	/* U+2524 */	JISX0208(0xa8a9),
	/* U+2525 */	JISX0208(0xa8be),
	/* U+2526 */	U2E_NODEST_COLX,
	/* U+2527 */	U2E_NODEST_COLX,
	/* U+2528 */	JISX0208(0xa8b9),
	/* U+2529 */	U2E_NODEST_COLX,
	/* U+252A */	U2E_NODEST_COLX,
	/* U+252B */	JISX0208(0xa8b4),
	/* U+252C */	JISX0208(0xa8a8),
	/* U+252D */	U2E_NODEST_COLX,
	/* U+252E */	U2E_NODEST_COLX,
	/* U+252F */	JISX0208(0xa8b8),
	/* U+2530 */	JISX0208(0xa8bd),
	/* U+2531 */	U2E_NODEST_COLX,
	/* U+2532 */	U2E_NODEST_COLX,
	/* U+2533 */	JISX0208(0xa8b3),
	/* U+2534 */	JISX0208(0xa8aa),
	/* U+2535 */	U2E_NODEST_COLX,
	/* U+2536 */	U2E_NODEST_COLX,
	/* U+2537 */	JISX0208(0xa8ba),
	/* U+2538 */	JISX0208(0xa8bf),
	/* U+2539 */	U2E_NODEST_COLX,
	/* U+253A */	U2E_NODEST_COLX,
	/* U+253B */	JISX0208(0xa8b5),
	/* U+253C */	JISX0208(0xa8ab),
	/* U+253D */	U2E_NODEST_COLX,
	/* U+253E */	U2E_NODEST_COLX,
	/* U+253F */	JISX0208(0xa8bb),
	/* U+2540 */	U2E_NODEST_COLX,
	/* U+2541 */	U2E_NODEST_COLX,
	/* U+2542 */	JISX0208(0xa8c0),
	/* U+2543 */	U2E_NODEST_COLX,
	/* U+2544 */	U2E_NODEST_COLX,
	/* U+2545 */	U2E_NODEST_COLX,
	/* U+2546 */	U2E_NODEST_COLX,
	/* U+2547 */	U2E_NODEST_COLX,
	/* U+2548 */	U2E_NODEST_COLX,
	/* U+2549 */	U2E_NODEST_COLX,
	/* U+254A */	U2E_NODEST_COLX,
	/* U+254B */	JISX0208(0xa8b6),
	/* U+254C */	U2E_NODEST_COLX,
	/* U+254D */	U2E_NODEST_COLX,
	/* U+254E */	U2E_NODEST_COLX,
	/* U+254F */	U2E_NODEST_COLX,
	/* U+2550 */	U2E_NODEST_COLX,
	/* U+2551 */	U2E_NODEST_COLX,
	/* U+2552 */	U2E_NODEST_COLX,
	/* U+2553 */	U2E_NODEST_COLX,
	/* U+2554 */	U2E_NODEST_COLX,
	/* U+2555 */	U2E_NODEST_COLX,
	/* U+2556 */	U2E_NODEST_COLX,
	/* U+2557 */	U2E_NODEST_COLX,
	/* U+2558 */	U2E_NODEST_COLX,
	/* U+2559 */	U2E_NODEST_COLX,
	/* U+255A */	U2E_NODEST_COLX,
	/* U+255B */	U2E_NODEST_COLX,
	/* U+255C */	U2E_NODEST_COLX,
	/* U+255D */	U2E_NODEST_COLX,
	/* U+255E */	U2E_NODEST_COLX,
	/* U+255F */	U2E_NODEST_COLX,
	/* U+2560 */	U2E_NODEST_COLX,
	/* U+2561 */	U2E_NODEST_COLX,
	/* U+2562 */	U2E_NODEST_COLX,
	/* U+2563 */	U2E_NODEST_COLX,
	/* U+2564 */	U2E_NODEST_COLX,
	/* U+2565 */	U2E_NODEST_COLX,
	/* U+2566 */	U2E_NODEST_COLX,
	/* U+2567 */	U2E_NODEST_COLX,
	/* U+2568 */	U2E_NODEST_COLX,
	/* U+2569 */	U2E_NODEST_COLX,
	/* U+256A */	U2E_NODEST_COLX,
	/* U+256B */	U2E_NODEST_COLX,
	/* U+256C */	U2E_NODEST_COLX,
	/* U+256D */	U2E_NODEST_COLX,
	/* U+256E */	U2E_NODEST_COLX,
	/* U+256F */	U2E_NODEST_COLX,
	/* U+2570 */	U2E_NODEST_COLX,
	/* U+2571 */	U2E_NODEST_COLX,
	/* U+2572 */	U2E_NODEST_COLX,
	/* U+2573 */	U2E_NODEST_COLX,
	/* U+2574 */	U2E_NODEST_COLX,
	/* U+2575 */	U2E_NODEST_COLX,
	/* U+2576 */	U2E_NODEST_COLX,
	/* U+2577 */	U2E_NODEST_COLX,
	/* U+2578 */	U2E_NODEST_COLX,
	/* U+2579 */	U2E_NODEST_COLX,
	/* U+257A */	U2E_NODEST_COLX,
	/* U+257B */	U2E_NODEST_COLX,
	/* U+257C */	U2E_NODEST_COLX,
	/* U+257D */	U2E_NODEST_COLX,
	/* U+257E */	U2E_NODEST_COLX,
	/* U+257F */	U2E_NODEST_COLX,
	/* U+2580 */	U2E_NODEST_COLX,
	/* U+2581 */	U2E_NODEST_COLX,
	/* U+2582 */	U2E_NODEST_COLX,
	/* U+2583 */	U2E_NODEST_COLX,
	/* U+2584 */	U2E_NODEST_COLX,
	/* U+2585 */	U2E_NODEST_COLX,
	/* U+2586 */	U2E_NODEST_COLX,
	/* U+2587 */	U2E_NODEST_COLX,
	/* U+2588 */	U2E_NODEST_COLX,
	/* U+2589 */	U2E_NODEST_COLX,
	/* U+258A */	U2E_NODEST_COLX,
	/* U+258B */	U2E_NODEST_COLX,
	/* U+258C */	U2E_NODEST_COLX,
	/* U+258D */	U2E_NODEST_COLX,
	/* U+258E */	U2E_NODEST_COLX,
	/* U+258F */	U2E_NODEST_COLX,
	/* U+2590 */	U2E_NODEST_COLX,
	/* U+2591 */	U2E_NODEST_COLX,
	/* U+2592 */	U2E_NODEST_COLX,
	/* U+2593 */	U2E_NODEST_COLX,
	/* U+2594 */	U2E_NODEST_COLX,
	/* U+2595 */	U2E_NODEST_COLX,
	/* U+2596 */	U2E_NODEST_COLX,
	/* U+2597 */	U2E_NODEST_COLX,
	/* U+2598 */	U2E_NODEST_COLX,
	/* U+2599 */	U2E_NODEST_COLX,
	/* U+259A */	U2E_NODEST_COLX,
	/* U+259B */	U2E_NODEST_COLX,
	/* U+259C */	U2E_NODEST_COLX,
	/* U+259D */	U2E_NODEST_COLX,
	/* U+259E */	U2E_NODEST_COLX,
	/* U+259F */	U2E_NODEST_COLX,
	/* U+25A0 */	JISX0208(0xa2a3),
	/* U+25A1 */	JISX0208(0xa2a2),
	/* U+25A2 */	U2E_NODEST_COLX,
	/* U+25A3 */	U2E_NODEST_COLX,
	/* U+25A4 */	U2E_NODEST_COLX,
	/* U+25A5 */	U2E_NODEST_COLX,
	/* U+25A6 */	U2E_NODEST_COLX,
	/* U+25A7 */	U2E_NODEST_COLX,
	/* U+25A8 */	U2E_NODEST_COLX,
	/* U+25A9 */	U2E_NODEST_COLX,
	/* U+25AA */	U2E_NODEST_COLX,
	/* U+25AB */	U2E_NODEST_COLX,
	/* U+25AC */	U2E_NODEST_COLX,
	/* U+25AD */	U2E_NODEST_COLX,
	/* U+25AE */	U2E_NODEST_COLX,
	/* U+25AF */	U2E_NODEST_COLX,
	/* U+25B0 */	U2E_NODEST_COLX,
	/* U+25B1 */	IFX0213(JISX0213_1(0xa6ed),	U2E_NODEST_COLX),
	/* U+25B2 */	JISX0208(0xa2a5),
	/* U+25B3 */	JISX0208(0xa2a4),
	/* U+25B4 */	U2E_NODEST_COLX,
	/* U+25B5 */	U2E_NODEST_COLX,
	/* U+25B6 */	IFX0213(JISX0213_1(0xa3a2),	U2E_NODEST_COLX),
	/* U+25B7 */	IFX0213(JISX0213_1(0xa3a1),	U2E_NODEST_COLX),
	/* U+25B8 */	U2E_NODEST_COLX,
	/* U+25B9 */	U2E_NODEST_COLX,
	/* U+25BA */	U2E_NODEST_COLX,
	/* U+25BB */	U2E_NODEST_COLX,
	/* U+25BC */	JISX0208(0xa2a7),
	/* U+25BD */	JISX0208(0xa2a6),
	/* U+25BE */	U2E_NODEST_COLX,
	/* U+25BF */	U2E_NODEST_COLX,
	/* U+25C0 */	IFX0213(JISX0213_1(0xa3a4),	U2E_NODEST_COLX),
	/* U+25C1 */	IFX0213(JISX0213_1(0xa3a3),	U2E_NODEST_COLX),
	/* U+25C2 */	U2E_NODEST_COLX,
	/* U+25C3 */	U2E_NODEST_COLX,
	/* U+25C4 */	U2E_NODEST_COLX,
	/* U+25C5 */	U2E_NODEST_COLX,
	/* U+25C6 */	JISX0208(0xa2a1),
	/* U+25C7 */	JISX0208(0xa1fe),
	/* U+25C8 */	U2E_NODEST_COLX,
	/* U+25C9 */	IFX0213(JISX0213_1(0xa3bb),	U2E_NODEST_COLX),
	/* U+25CA */	U2E_NODEST_COLX,
	/* U+25CB */	JISX0208(0xa1fb),
	/* U+25CC */	U2E_NODEST_COLX,
	/* U+25CD */	U2E_NODEST_COLX,
	/* U+25CE */	JISX0208(0xa1fd),
	/* U+25CF */	JISX0208(0xa1fc),
	/* U+25D0 */	IFX0213(JISX0213_1(0xa8e7),	U2E_NODEST_COLX),
	/* U+25D1 */	IFX0213(JISX0213_1(0xa8e8),	U2E_NODEST_COLX),
	/* U+25D2 */	IFX0213(JISX0213_1(0xa8e9),	U2E_NODEST_COLX),
	/* U+25D3 */	IFX0213(JISX0213_1(0xa8ea),	U2E_NODEST_COLX),
	/* U+25D4 */	U2E_NODEST_COLX,
	/* U+25D5 */	U2E_NODEST_COLX,
	/* U+25D6 */	U2E_NODEST_COLX,
	/* U+25D7 */	U2E_NODEST_COLX,
	/* U+25D8 */	U2E_NODEST_COLX,
	/* U+25D9 */	U2E_NODEST_COLX,
	/* U+25DA */	U2E_NODEST_COLX,
	/* U+25DB */	U2E_NODEST_COLX,
	/* U+25DC */	U2E_NODEST_COLX,
	/* U+25DD */	U2E_NODEST_COLX,
	/* U+25DE */	U2E_NODEST_COLX,
	/* U+25DF */	U2E_NODEST_COLX,
	/* U+25E0 */	U2E_NODEST_COLX,
	/* U+25E1 */	U2E_NODEST_COLX,
	/* U+25E2 */	U2E_NODEST_COLX,
	/* U+25E3 */	U2E_NODEST_COLX,
	/* U+25E4 */	U2E_NODEST_COLX,
	/* U+25E5 */	U2E_NODEST_COLX,
	/* U+25E6 */	IFX0213(JISX0213_1(0xa3bf),	U2E_NODEST_COLX),
	/* U+25E7 */	U2E_NODEST_COLX,
	/* U+25E8 */	U2E_NODEST_COLX,
	/* U+25E9 */	U2E_NODEST_COLX,
	/* U+25EA */	U2E_NODEST_COLX,
	/* U+25EB */	U2E_NODEST_COLX,
	/* U+25EC */	U2E_NODEST_COLX,
	/* U+25ED */	U2E_NODEST_COLX,
	/* U+25EE */	U2E_NODEST_COLX,
	/* U+25EF */	JISX0208(0xa2fe),
	/* U+25F0 */	U2E_NODEST_COLX,
	/* U+25F1 */	U2E_NODEST_COLX,
	/* U+25F2 */	U2E_NODEST_COLX,
	/* U+25F3 */	U2E_NODEST_COLX,
	/* U+25F4 */	U2E_NODEST_COLX,
	/* U+25F5 */	U2E_NODEST_COLX,
	/* U+25F6 */	U2E_NODEST_COLX,
	/* U+25F7 */	U2E_NODEST_COLX,
	/* U+25F8 */	U2E_NODEST_COLX,
	/* U+25F9 */	U2E_NODEST_COLX,
	/* U+25FA */	U2E_NODEST_COLX,
	/* U+25FB */	U2E_NODEST_COLX,
	/* U+25FC */	U2E_NODEST_COLX,
	/* U+25FD */	U2E_NODEST_COLX,
	/* U+25FE */	U2E_NODEST_COLX,
	/* U+25FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_26[] = {
	/* U+2600 */	IFX0213(JISX0213_1(0xa6e8),	U2E_NODEST_COLX),
	/* U+2601 */	IFX0213(JISX0213_1(0xa6e9),	U2E_NODEST_COLX),
	/* U+2602 */	IFX0213(JISX0213_1(0xa6ea),	U2E_NODEST_COLX),
	/* U+2603 */	IFX0213(JISX0213_1(0xa6eb),	U2E_NODEST_COLX),
	/* U+2604 */	U2E_NODEST_COLX,
	/* U+2605 */	JISX0208(0xa1fa),
	/* U+2606 */	JISX0208(0xa1f9),
	/* U+2607 */	U2E_NODEST_COLX,
	/* U+2608 */	U2E_NODEST_COLX,
	/* U+2609 */	U2E_NODEST_COLX,
	/* U+260A */	U2E_NODEST_COLX,
	/* U+260B */	U2E_NODEST_COLX,
	/* U+260C */	U2E_NODEST_COLX,
	/* U+260D */	U2E_NODEST_COLX,
	/* U+260E */	IFX0213(JISX0213_1(0xa6e7),	U2E_NODEST_COLX),
	/* U+260F */	U2E_NODEST_COLX,
	/* U+2610 */	U2E_NODEST_COLX,
	/* U+2611 */	U2E_NODEST_COLX,
	/* U+2612 */	U2E_NODEST_COLX,
	/* U+2613 */	U2E_NODEST_COLX,
	/* U+2614 */	U2E_NODEST_COLX,
	/* U+2615 */	U2E_NODEST_COLX,
	/* U+2616 */	IFX0213(JISX0213_1(0xa6e4),	U2E_NODEST_COLX),
	/* U+2617 */	IFX0213(JISX0213_1(0xa6e5),	U2E_NODEST_COLX),
	/* U+2618 */	U2E_NODEST_COLX,
	/* U+2619 */	U2E_NODEST_COLX,
	/* U+261A */	U2E_NODEST_COLX,
	/* U+261B */	U2E_NODEST_COLX,
	/* U+261C */	U2E_NODEST_COLX,
	/* U+261D */	U2E_NODEST_COLX,
	/* U+261E */	IFX0213(JISX0213_1(0xadfe),	U2E_NODEST_COLX),
	/* U+261F */	U2E_NODEST_COLX,
	/* U+2620 */	U2E_NODEST_COLX,
	/* U+2621 */	U2E_NODEST_COLX,
	/* U+2622 */	U2E_NODEST_COLX,
	/* U+2623 */	U2E_NODEST_COLX,
	/* U+2624 */	U2E_NODEST_COLX,
	/* U+2625 */	U2E_NODEST_COLX,
	/* U+2626 */	U2E_NODEST_COLX,
	/* U+2627 */	U2E_NODEST_COLX,
	/* U+2628 */	U2E_NODEST_COLX,
	/* U+2629 */	U2E_NODEST_COLX,
	/* U+262A */	U2E_NODEST_COLX,
	/* U+262B */	U2E_NODEST_COLX,
	/* U+262C */	U2E_NODEST_COLX,
	/* U+262D */	U2E_NODEST_COLX,
	/* U+262E */	U2E_NODEST_COLX,
	/* U+262F */	U2E_NODEST_COLX,
	/* U+2630 */	U2E_NODEST_COLX,
	/* U+2631 */	U2E_NODEST_COLX,
	/* U+2632 */	U2E_NODEST_COLX,
	/* U+2633 */	U2E_NODEST_COLX,
	/* U+2634 */	U2E_NODEST_COLX,
	/* U+2635 */	U2E_NODEST_COLX,
	/* U+2636 */	U2E_NODEST_COLX,
	/* U+2637 */	U2E_NODEST_COLX,
	/* U+2638 */	U2E_NODEST_COLX,
	/* U+2639 */	U2E_NODEST_COLX,
	/* U+263A */	U2E_NODEST_COLX,
	/* U+263B */	U2E_NODEST_COLX,
	/* U+263C */	U2E_NODEST_COLX,
	/* U+263D */	U2E_NODEST_COLX,
	/* U+263E */	U2E_NODEST_COLX,
	/* U+263F */	U2E_NODEST_COLX,
	/* U+2640 */	JISX0208(0xa1ea),
	/* U+2641 */	U2E_NODEST_COLX,
	/* U+2642 */	JISX0208(0xa1e9),
	/* U+2643 */	U2E_NODEST_COLX,
	/* U+2644 */	U2E_NODEST_COLX,
	/* U+2645 */	U2E_NODEST_COLX,
	/* U+2646 */	U2E_NODEST_COLX,
	/* U+2647 */	U2E_NODEST_COLX,
	/* U+2648 */	U2E_NODEST_COLX,
	/* U+2649 */	U2E_NODEST_COLX,
	/* U+264A */	U2E_NODEST_COLX,
	/* U+264B */	U2E_NODEST_COLX,
	/* U+264C */	U2E_NODEST_COLX,
	/* U+264D */	U2E_NODEST_COLX,
	/* U+264E */	U2E_NODEST_COLX,
	/* U+264F */	U2E_NODEST_COLX,
	/* U+2650 */	U2E_NODEST_COLX,
	/* U+2651 */	U2E_NODEST_COLX,
	/* U+2652 */	U2E_NODEST_COLX,
	/* U+2653 */	U2E_NODEST_COLX,
	/* U+2654 */	U2E_NODEST_COLX,
	/* U+2655 */	U2E_NODEST_COLX,
	/* U+2656 */	U2E_NODEST_COLX,
	/* U+2657 */	U2E_NODEST_COLX,
	/* U+2658 */	U2E_NODEST_COLX,
	/* U+2659 */	U2E_NODEST_COLX,
	/* U+265A */	U2E_NODEST_COLX,
	/* U+265B */	U2E_NODEST_COLX,
	/* U+265C */	U2E_NODEST_COLX,
	/* U+265D */	U2E_NODEST_COLX,
	/* U+265E */	U2E_NODEST_COLX,
	/* U+265F */	U2E_NODEST_COLX,
	/* U+2660 */	IFX0213(JISX0213_1(0xa6ba),	U2E_NODEST_COLX),
	/* U+2661 */	IFX0213(JISX0213_1(0xa6bd),	U2E_NODEST_COLX),
	/* U+2662 */	IFX0213(JISX0213_1(0xa6bb),	U2E_NODEST_COLX),
	/* U+2663 */	IFX0213(JISX0213_1(0xa6c0),	U2E_NODEST_COLX),
	/* U+2664 */	IFX0213(JISX0213_1(0xa6b9),	U2E_NODEST_COLX),
	/* U+2665 */	IFX0213(JISX0213_1(0xa6be),	U2E_NODEST_COLX),
	/* U+2666 */	IFX0213(JISX0213_1(0xa6bc),	U2E_NODEST_COLX),
	/* U+2667 */	IFX0213(JISX0213_1(0xa6bf),	U2E_NODEST_COLX),
	/* U+2668 */	IFX0213(JISX0213_1(0xa6ec),	U2E_NODEST_COLX),
	/* U+2669 */	IFX0213(JISX0213_1(0xa2fd),	U2E_NODEST_COLX),
	/* U+266A */	JISX0208(0xa2f6),
	/* U+266B */	IFX0213(JISX0213_1(0xa2fb),	U2E_NODEST_COLX),
	/* U+266C */	IFX0213(JISX0213_1(0xa2fc),	U2E_NODEST_COLX),
	/* U+266D */	JISX0208(0xa2f5),
	/* U+266E */	IFX0213(JISX0213_1(0xa2fa),	U2E_NODEST_COLX),
	/* U+266F */	JISX0208(0xa2f4),
	/* U+2670 */	U2E_NODEST_COLX,
	/* U+2671 */	U2E_NODEST_COLX,
	/* U+2672 */	U2E_NODEST_COLX,
	/* U+2673 */	U2E_NODEST_COLX,
	/* U+2674 */	U2E_NODEST_COLX,
	/* U+2675 */	U2E_NODEST_COLX,
	/* U+2676 */	U2E_NODEST_COLX,
	/* U+2677 */	U2E_NODEST_COLX,
	/* U+2678 */	U2E_NODEST_COLX,
	/* U+2679 */	U2E_NODEST_COLX,
	/* U+267A */	U2E_NODEST_COLX,
	/* U+267B */	U2E_NODEST_COLX,
	/* U+267C */	U2E_NODEST_COLX,
	/* U+267D */	U2E_NODEST_COLX,
	/* U+267E */	U2E_NODEST_COLX,
	/* U+267F */	U2E_NODEST_COLX,
	/* U+2680 */	U2E_NODEST_COLX,
	/* U+2681 */	U2E_NODEST_COLX,
	/* U+2682 */	U2E_NODEST_COLX,
	/* U+2683 */	U2E_NODEST_COLX,
	/* U+2684 */	U2E_NODEST_COLX,
	/* U+2685 */	U2E_NODEST_COLX,
	/* U+2686 */	U2E_NODEST_COLX,
	/* U+2687 */	U2E_NODEST_COLX,
	/* U+2688 */	U2E_NODEST_COLX,
	/* U+2689 */	U2E_NODEST_COLX,
	/* U+268A */	U2E_NODEST_COLX,
	/* U+268B */	U2E_NODEST_COLX,
	/* U+268C */	U2E_NODEST_COLX,
	/* U+268D */	U2E_NODEST_COLX,
	/* U+268E */	U2E_NODEST_COLX,
	/* U+268F */	U2E_NODEST_COLX,
	/* U+2690 */	U2E_NODEST_COLX,
	/* U+2691 */	U2E_NODEST_COLX,
	/* U+2692 */	U2E_NODEST_COLX,
	/* U+2693 */	U2E_NODEST_COLX,
	/* U+2694 */	U2E_NODEST_COLX,
	/* U+2695 */	U2E_NODEST_COLX,
	/* U+2696 */	U2E_NODEST_COLX,
	/* U+2697 */	U2E_NODEST_COLX,
	/* U+2698 */	U2E_NODEST_COLX,
	/* U+2699 */	U2E_NODEST_COLX,
	/* U+269A */	U2E_NODEST_COLX,
	/* U+269B */	U2E_NODEST_COLX,
	/* U+269C */	U2E_NODEST_COLX,
	/* U+269D */	U2E_NODEST_COLX,
	/* U+269E */	U2E_NODEST_COLX,
	/* U+269F */	U2E_NODEST_COLX,
	/* U+26A0 */	U2E_NODEST_COLX,
	/* U+26A1 */	U2E_NODEST_COLX,
	/* U+26A2 */	U2E_NODEST_COLX,
	/* U+26A3 */	U2E_NODEST_COLX,
	/* U+26A4 */	U2E_NODEST_COLX,
	/* U+26A5 */	U2E_NODEST_COLX,
	/* U+26A6 */	U2E_NODEST_COLX,
	/* U+26A7 */	U2E_NODEST_COLX,
	/* U+26A8 */	U2E_NODEST_COLX,
	/* U+26A9 */	U2E_NODEST_COLX,
	/* U+26AA */	U2E_NODEST_COLX,
	/* U+26AB */	U2E_NODEST_COLX,
	/* U+26AC */	U2E_NODEST_COLX,
	/* U+26AD */	U2E_NODEST_COLX,
	/* U+26AE */	U2E_NODEST_COLX,
	/* U+26AF */	U2E_NODEST_COLX,
	/* U+26B0 */	U2E_NODEST_COLX,
	/* U+26B1 */	U2E_NODEST_COLX,
	/* U+26B2 */	U2E_NODEST_COLX,
	/* U+26B3 */	U2E_NODEST_COLX,
	/* U+26B4 */	U2E_NODEST_COLX,
	/* U+26B5 */	U2E_NODEST_COLX,
	/* U+26B6 */	U2E_NODEST_COLX,
	/* U+26B7 */	U2E_NODEST_COLX,
	/* U+26B8 */	U2E_NODEST_COLX,
	/* U+26B9 */	U2E_NODEST_COLX,
	/* U+26BA */	U2E_NODEST_COLX,
	/* U+26BB */	U2E_NODEST_COLX,
	/* U+26BC */	U2E_NODEST_COLX,
	/* U+26BD */	U2E_NODEST_COLX,
	/* U+26BE */	U2E_NODEST_COLX,
	/* U+26BF */	U2E_NODEST_COLX,
	/* U+26C0 */	U2E_NODEST_COLX,
	/* U+26C1 */	U2E_NODEST_COLX,
	/* U+26C2 */	U2E_NODEST_COLX,
	/* U+26C3 */	U2E_NODEST_COLX,
	/* U+26C4 */	U2E_NODEST_COLX,
	/* U+26C5 */	U2E_NODEST_COLX,
	/* U+26C6 */	U2E_NODEST_COLX,
	/* U+26C7 */	U2E_NODEST_COLX,
	/* U+26C8 */	U2E_NODEST_COLX,
	/* U+26C9 */	U2E_NODEST_COLX,
	/* U+26CA */	U2E_NODEST_COLX,
	/* U+26CB */	U2E_NODEST_COLX,
	/* U+26CC */	U2E_NODEST_COLX,
	/* U+26CD */	U2E_NODEST_COLX,
	/* U+26CE */	U2E_NODEST_COLX,
	/* U+26CF */	U2E_NODEST_COLX,
	/* U+26D0 */	U2E_NODEST_COLX,
	/* U+26D1 */	U2E_NODEST_COLX,
	/* U+26D2 */	U2E_NODEST_COLX,
	/* U+26D3 */	U2E_NODEST_COLX,
	/* U+26D4 */	U2E_NODEST_COLX,
	/* U+26D5 */	U2E_NODEST_COLX,
	/* U+26D6 */	U2E_NODEST_COLX,
	/* U+26D7 */	U2E_NODEST_COLX,
	/* U+26D8 */	U2E_NODEST_COLX,
	/* U+26D9 */	U2E_NODEST_COLX,
	/* U+26DA */	U2E_NODEST_COLX,
	/* U+26DB */	U2E_NODEST_COLX,
	/* U+26DC */	U2E_NODEST_COLX,
	/* U+26DD */	U2E_NODEST_COLX,
	/* U+26DE */	U2E_NODEST_COLX,
	/* U+26DF */	U2E_NODEST_COLX,
	/* U+26E0 */	U2E_NODEST_COLX,
	/* U+26E1 */	U2E_NODEST_COLX,
	/* U+26E2 */	U2E_NODEST_COLX,
	/* U+26E3 */	U2E_NODEST_COLX,
	/* U+26E4 */	U2E_NODEST_COLX,
	/* U+26E5 */	U2E_NODEST_COLX,
	/* U+26E6 */	U2E_NODEST_COLX,
	/* U+26E7 */	U2E_NODEST_COLX,
	/* U+26E8 */	U2E_NODEST_COLX,
	/* U+26E9 */	U2E_NODEST_COLX,
	/* U+26EA */	U2E_NODEST_COLX,
	/* U+26EB */	U2E_NODEST_COLX,
	/* U+26EC */	U2E_NODEST_COLX,
	/* U+26ED */	U2E_NODEST_COLX,
	/* U+26EE */	U2E_NODEST_COLX,
	/* U+26EF */	U2E_NODEST_COLX,
	/* U+26F0 */	U2E_NODEST_COLX,
	/* U+26F1 */	U2E_NODEST_COLX,
	/* U+26F2 */	U2E_NODEST_COLX,
	/* U+26F3 */	U2E_NODEST_COLX,
	/* U+26F4 */	U2E_NODEST_COLX,
	/* U+26F5 */	U2E_NODEST_COLX,
	/* U+26F6 */	U2E_NODEST_COLX,
	/* U+26F7 */	U2E_NODEST_COLX,
	/* U+26F8 */	U2E_NODEST_COLX,
	/* U+26F9 */	U2E_NODEST_COLX,
	/* U+26FA */	U2E_NODEST_COLX,
	/* U+26FB */	U2E_NODEST_COLX,
	/* U+26FC */	U2E_NODEST_COLX,
	/* U+26FD */	U2E_NODEST_COLX,
	/* U+26FE */	U2E_NODEST_COLX,
	/* U+26FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_27[] = {
	/* U+2700 */	U2E_NODEST_COLX,
	/* U+2701 */	U2E_NODEST_COLX,
	/* U+2702 */	U2E_NODEST_COLX,
	/* U+2703 */	U2E_NODEST_COLX,
	/* U+2704 */	U2E_NODEST_COLX,
	/* U+2705 */	U2E_NODEST_COLX,
	/* U+2706 */	U2E_NODEST_COLX,
	/* U+2707 */	U2E_NODEST_COLX,
	/* U+2708 */	U2E_NODEST_COLX,
	/* U+2709 */	U2E_NODEST_COLX,
	/* U+270A */	U2E_NODEST_COLX,
	/* U+270B */	U2E_NODEST_COLX,
	/* U+270C */	U2E_NODEST_COLX,
	/* U+270D */	U2E_NODEST_COLX,
	/* U+270E */	U2E_NODEST_COLX,
	/* U+270F */	U2E_NODEST_COLX,
	/* U+2710 */	U2E_NODEST_COLX,
	/* U+2711 */	U2E_NODEST_COLX,
	/* U+2712 */	U2E_NODEST_COLX,
	/* U+2713 */	IFX0213(JISX0213_1(0xa7fb),	U2E_NODEST_COLX),
	/* U+2714 */	U2E_NODEST_COLX,
	/* U+2715 */	U2E_NODEST_COLX,
	/* U+2716 */	U2E_NODEST_COLX,
	/* U+2717 */	U2E_NODEST_COLX,
	/* U+2718 */	U2E_NODEST_COLX,
	/* U+2719 */	U2E_NODEST_COLX,
	/* U+271A */	U2E_NODEST_COLX,
	/* U+271B */	U2E_NODEST_COLX,
	/* U+271C */	U2E_NODEST_COLX,
	/* U+271D */	U2E_NODEST_COLX,
	/* U+271E */	U2E_NODEST_COLX,
	/* U+271F */	U2E_NODEST_COLX,
	/* U+2720 */	U2E_NODEST_COLX,
	/* U+2721 */	U2E_NODEST_COLX,
	/* U+2722 */	U2E_NODEST_COLX,
	/* U+2723 */	U2E_NODEST_COLX,
	/* U+2724 */	U2E_NODEST_COLX,
	/* U+2725 */	U2E_NODEST_COLX,
	/* U+2726 */	U2E_NODEST_COLX,
	/* U+2727 */	U2E_NODEST_COLX,
	/* U+2728 */	U2E_NODEST_COLX,
	/* U+2729 */	U2E_NODEST_COLX,
	/* U+272A */	U2E_NODEST_COLX,
	/* U+272B */	U2E_NODEST_COLX,
	/* U+272C */	U2E_NODEST_COLX,
	/* U+272D */	U2E_NODEST_COLX,
	/* U+272E */	U2E_NODEST_COLX,
	/* U+272F */	U2E_NODEST_COLX,
	/* U+2730 */	U2E_NODEST_COLX,
	/* U+2731 */	U2E_NODEST_COLX,
	/* U+2732 */	U2E_NODEST_COLX,
	/* U+2733 */	U2E_NODEST_COLX,
	/* U+2734 */	U2E_NODEST_COLX,
	/* U+2735 */	U2E_NODEST_COLX,
	/* U+2736 */	U2E_NODEST_COLX,
	/* U+2737 */	U2E_NODEST_COLX,
	/* U+2738 */	U2E_NODEST_COLX,
	/* U+2739 */	U2E_NODEST_COLX,
	/* U+273A */	U2E_NODEST_COLX,
	/* U+273B */	U2E_NODEST_COLX,
	/* U+273C */	U2E_NODEST_COLX,
	/* U+273D */	U2E_NODEST_COLX,
	/* U+273E */	U2E_NODEST_COLX,
	/* U+273F */	U2E_NODEST_COLX,
	/* U+2740 */	U2E_NODEST_COLX,
	/* U+2741 */	U2E_NODEST_COLX,
	/* U+2742 */	U2E_NODEST_COLX,
	/* U+2743 */	U2E_NODEST_COLX,
	/* U+2744 */	U2E_NODEST_COLX,
	/* U+2745 */	U2E_NODEST_COLX,
	/* U+2746 */	U2E_NODEST_COLX,
	/* U+2747 */	U2E_NODEST_COLX,
	/* U+2748 */	U2E_NODEST_COLX,
	/* U+2749 */	U2E_NODEST_COLX,
	/* U+274A */	U2E_NODEST_COLX,
	/* U+274B */	U2E_NODEST_COLX,
	/* U+274C */	U2E_NODEST_COLX,
	/* U+274D */	U2E_NODEST_COLX,
	/* U+274E */	U2E_NODEST_COLX,
	/* U+274F */	U2E_NODEST_COLX,
	/* U+2750 */	U2E_NODEST_COLX,
	/* U+2751 */	U2E_NODEST_COLX,
	/* U+2752 */	U2E_NODEST_COLX,
	/* U+2753 */	U2E_NODEST_COLX,
	/* U+2754 */	U2E_NODEST_COLX,
	/* U+2755 */	U2E_NODEST_COLX,
	/* U+2756 */	IFX0213(JISX0213_1(0xadfd),	U2E_NODEST_COLX),
	/* U+2757 */	U2E_NODEST_COLX,
	/* U+2758 */	U2E_NODEST_COLX,
	/* U+2759 */	U2E_NODEST_COLX,
	/* U+275A */	U2E_NODEST_COLX,
	/* U+275B */	U2E_NODEST_COLX,
	/* U+275C */	U2E_NODEST_COLX,
	/* U+275D */	U2E_NODEST_COLX,
	/* U+275E */	U2E_NODEST_COLX,
	/* U+275F */	U2E_NODEST_COLX,
	/* U+2760 */	U2E_NODEST_COLX,
	/* U+2761 */	U2E_NODEST_COLX,
	/* U+2762 */	U2E_NODEST_COLX,
	/* U+2763 */	U2E_NODEST_COLX,
	/* U+2764 */	U2E_NODEST_COLX,
	/* U+2765 */	U2E_NODEST_COLX,
	/* U+2766 */	U2E_NODEST_COLX,
	/* U+2767 */	U2E_NODEST_COLX,
	/* U+2768 */	U2E_NODEST_COLX,
	/* U+2769 */	U2E_NODEST_COLX,
	/* U+276A */	U2E_NODEST_COLX,
	/* U+276B */	U2E_NODEST_COLX,
	/* U+276C */	U2E_NODEST_COLX,
	/* U+276D */	U2E_NODEST_COLX,
	/* U+276E */	U2E_NODEST_COLX,
	/* U+276F */	U2E_NODEST_COLX,
	/* U+2770 */	U2E_NODEST_COLX,
	/* U+2771 */	U2E_NODEST_COLX,
	/* U+2772 */	U2E_NODEST_COLX,
	/* U+2773 */	U2E_NODEST_COLX,
	/* U+2774 */	U2E_NODEST_COLX,
	/* U+2775 */	U2E_NODEST_COLX,
	/* U+2776 */	IFX0213(JISX0213_1(0xaca1),	U2E_NODEST_COLX),
	/* U+2777 */	IFX0213(JISX0213_1(0xaca2),	U2E_NODEST_COLX),
	/* U+2778 */	IFX0213(JISX0213_1(0xaca3),	U2E_NODEST_COLX),
	/* U+2779 */	IFX0213(JISX0213_1(0xaca4),	U2E_NODEST_COLX),
	/* U+277A */	IFX0213(JISX0213_1(0xaca5),	U2E_NODEST_COLX),
	/* U+277B */	IFX0213(JISX0213_1(0xaca6),	U2E_NODEST_COLX),
	/* U+277C */	IFX0213(JISX0213_1(0xaca7),	U2E_NODEST_COLX),
	/* U+277D */	IFX0213(JISX0213_1(0xaca8),	U2E_NODEST_COLX),
	/* U+277E */	IFX0213(JISX0213_1(0xaca9),	U2E_NODEST_COLX),
	/* U+277F */	IFX0213(JISX0213_1(0xacaa),	U2E_NODEST_COLX),
	/* U+2780 */	U2E_NODEST_COLX,
	/* U+2781 */	U2E_NODEST_COLX,
	/* U+2782 */	U2E_NODEST_COLX,
	/* U+2783 */	U2E_NODEST_COLX,
	/* U+2784 */	U2E_NODEST_COLX,
	/* U+2785 */	U2E_NODEST_COLX,
	/* U+2786 */	U2E_NODEST_COLX,
	/* U+2787 */	U2E_NODEST_COLX,
	/* U+2788 */	U2E_NODEST_COLX,
	/* U+2789 */	U2E_NODEST_COLX,
	/* U+278A */	U2E_NODEST_COLX,
	/* U+278B */	U2E_NODEST_COLX,
	/* U+278C */	U2E_NODEST_COLX,
	/* U+278D */	U2E_NODEST_COLX,
	/* U+278E */	U2E_NODEST_COLX,
	/* U+278F */	U2E_NODEST_COLX,
	/* U+2790 */	U2E_NODEST_COLX,
	/* U+2791 */	U2E_NODEST_COLX,
	/* U+2792 */	U2E_NODEST_COLX,
	/* U+2793 */	U2E_NODEST_COLX,
	/* U+2794 */	U2E_NODEST_COLX,
	/* U+2795 */	U2E_NODEST_COLX,
	/* U+2796 */	U2E_NODEST_COLX,
	/* U+2797 */	U2E_NODEST_COLX,
	/* U+2798 */	U2E_NODEST_COLX,
	/* U+2799 */	U2E_NODEST_COLX,
	/* U+279A */	U2E_NODEST_COLX,
	/* U+279B */	U2E_NODEST_COLX,
	/* U+279C */	U2E_NODEST_COLX,
	/* U+279D */	U2E_NODEST_COLX,
	/* U+279E */	U2E_NODEST_COLX,
	/* U+279F */	U2E_NODEST_COLX,
	/* U+27A0 */	U2E_NODEST_COLX,
	/* U+27A1 */	U2E_NODEST_COLX,
	/* U+27A2 */	U2E_NODEST_COLX,
	/* U+27A3 */	U2E_NODEST_COLX,
	/* U+27A4 */	U2E_NODEST_COLX,
	/* U+27A5 */	U2E_NODEST_COLX,
	/* U+27A6 */	U2E_NODEST_COLX,
	/* U+27A7 */	U2E_NODEST_COLX,
	/* U+27A8 */	U2E_NODEST_COLX,
	/* U+27A9 */	U2E_NODEST_COLX,
	/* U+27AA */	U2E_NODEST_COLX,
	/* U+27AB */	U2E_NODEST_COLX,
	/* U+27AC */	U2E_NODEST_COLX,
	/* U+27AD */	U2E_NODEST_COLX,
	/* U+27AE */	U2E_NODEST_COLX,
	/* U+27AF */	U2E_NODEST_COLX,
	/* U+27B0 */	U2E_NODEST_COLX,
	/* U+27B1 */	U2E_NODEST_COLX,
	/* U+27B2 */	U2E_NODEST_COLX,
	/* U+27B3 */	U2E_NODEST_COLX,
	/* U+27B4 */	U2E_NODEST_COLX,
	/* U+27B5 */	U2E_NODEST_COLX,
	/* U+27B6 */	U2E_NODEST_COLX,
	/* U+27B7 */	U2E_NODEST_COLX,
	/* U+27B8 */	U2E_NODEST_COLX,
	/* U+27B9 */	U2E_NODEST_COLX,
	/* U+27BA */	U2E_NODEST_COLX,
	/* U+27BB */	U2E_NODEST_COLX,
	/* U+27BC */	U2E_NODEST_COLX,
	/* U+27BD */	U2E_NODEST_COLX,
	/* U+27BE */	U2E_NODEST_COLX,
	/* U+27BF */	U2E_NODEST_COLX,
	/* U+27C0 */	U2E_NODEST_COLX,
	/* U+27C1 */	U2E_NODEST_COLX,
	/* U+27C2 */	U2E_NODEST_COLX,
	/* U+27C3 */	U2E_NODEST_COLX,
	/* U+27C4 */	U2E_NODEST_COLX,
	/* U+27C5 */	U2E_NODEST_COLX,
	/* U+27C6 */	U2E_NODEST_COLX,
	/* U+27C7 */	U2E_NODEST_COLX,
	/* U+27C8 */	U2E_NODEST_COLX,
	/* U+27C9 */	U2E_NODEST_COLX,
	/* U+27CA */	U2E_NODEST_COLX,
	/* U+27CB */	U2E_NODEST_COLX,
	/* U+27CC */	U2E_NODEST_COLX,
	/* U+27CD */	U2E_NODEST_COLX,
	/* U+27CE */	U2E_NODEST_COLX,
	/* U+27CF */	U2E_NODEST_COLX,
	/* U+27D0 */	U2E_NODEST_COLX,
	/* U+27D1 */	U2E_NODEST_COLX,
	/* U+27D2 */	U2E_NODEST_COLX,
	/* U+27D3 */	U2E_NODEST_COLX,
	/* U+27D4 */	U2E_NODEST_COLX,
	/* U+27D5 */	U2E_NODEST_COLX,
	/* U+27D6 */	U2E_NODEST_COLX,
	/* U+27D7 */	U2E_NODEST_COLX,
	/* U+27D8 */	U2E_NODEST_COLX,
	/* U+27D9 */	U2E_NODEST_COLX,
	/* U+27DA */	U2E_NODEST_COLX,
	/* U+27DB */	U2E_NODEST_COLX,
	/* U+27DC */	U2E_NODEST_COLX,
	/* U+27DD */	U2E_NODEST_COLX,
	/* U+27DE */	U2E_NODEST_COLX,
	/* U+27DF */	U2E_NODEST_COLX,
	/* U+27E0 */	U2E_NODEST_COLX,
	/* U+27E1 */	U2E_NODEST_COLX,
	/* U+27E2 */	U2E_NODEST_COLX,
	/* U+27E3 */	U2E_NODEST_COLX,
	/* U+27E4 */	U2E_NODEST_COLX,
	/* U+27E5 */	U2E_NODEST_COLX,
	/* U+27E6 */	U2E_NODEST_COLX,
	/* U+27E7 */	U2E_NODEST_COLX,
	/* U+27E8 */	U2E_NODEST_COLX,
	/* U+27E9 */	U2E_NODEST_COLX,
	/* U+27EA */	U2E_NODEST_COLX,
	/* U+27EB */	U2E_NODEST_COLX,
	/* U+27EC */	U2E_NODEST_COLX,
	/* U+27ED */	U2E_NODEST_COLX,
	/* U+27EE */	U2E_NODEST_COLX,
	/* U+27EF */	U2E_NODEST_COLX,
	/* U+27F0 */	U2E_NODEST_COLX,
	/* U+27F1 */	U2E_NODEST_COLX,
	/* U+27F2 */	U2E_NODEST_COLX,
	/* U+27F3 */	U2E_NODEST_COLX,
	/* U+27F4 */	U2E_NODEST_COLX,
	/* U+27F5 */	U2E_NODEST_COLX,
	/* U+27F6 */	U2E_NODEST_COLX,
	/* U+27F7 */	U2E_NODEST_COLX,
	/* U+27F8 */	U2E_NODEST_COLX,
	/* U+27F9 */	U2E_NODEST_COLX,
	/* U+27FA */	U2E_NODEST_COLX,
	/* U+27FB */	U2E_NODEST_COLX,
	/* U+27FC */	U2E_NODEST_COLX,
	/* U+27FD */	U2E_NODEST_COLX,
	/* U+27FE */	U2E_NODEST_COLX,
	/* U+27FF */	U2E_NODEST_COLX,
};

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_28[] eliminated */

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_29[] = {
	/* U+2900 */	U2E_NODEST_COLX,
	/* U+2901 */	U2E_NODEST_COLX,
	/* U+2902 */	U2E_NODEST_COLX,
	/* U+2903 */	U2E_NODEST_COLX,
	/* U+2904 */	U2E_NODEST_COLX,
	/* U+2905 */	U2E_NODEST_COLX,
	/* U+2906 */	U2E_NODEST_COLX,
	/* U+2907 */	U2E_NODEST_COLX,
	/* U+2908 */	U2E_NODEST_COLX,
	/* U+2909 */	U2E_NODEST_COLX,
	/* U+290A */	U2E_NODEST_COLX,
	/* U+290B */	U2E_NODEST_COLX,
	/* U+290C */	U2E_NODEST_COLX,
	/* U+290D */	U2E_NODEST_COLX,
	/* U+290E */	U2E_NODEST_COLX,
	/* U+290F */	U2E_NODEST_COLX,
	/* U+2910 */	U2E_NODEST_COLX,
	/* U+2911 */	U2E_NODEST_COLX,
	/* U+2912 */	U2E_NODEST_COLX,
	/* U+2913 */	U2E_NODEST_COLX,
	/* U+2914 */	U2E_NODEST_COLX,
	/* U+2915 */	U2E_NODEST_COLX,
	/* U+2916 */	U2E_NODEST_COLX,
	/* U+2917 */	U2E_NODEST_COLX,
	/* U+2918 */	U2E_NODEST_COLX,
	/* U+2919 */	U2E_NODEST_COLX,
	/* U+291A */	U2E_NODEST_COLX,
	/* U+291B */	U2E_NODEST_COLX,
	/* U+291C */	U2E_NODEST_COLX,
	/* U+291D */	U2E_NODEST_COLX,
	/* U+291E */	U2E_NODEST_COLX,
	/* U+291F */	U2E_NODEST_COLX,
	/* U+2920 */	U2E_NODEST_COLX,
	/* U+2921 */	U2E_NODEST_COLX,
	/* U+2922 */	U2E_NODEST_COLX,
	/* U+2923 */	U2E_NODEST_COLX,
	/* U+2924 */	U2E_NODEST_COLX,
	/* U+2925 */	U2E_NODEST_COLX,
	/* U+2926 */	U2E_NODEST_COLX,
	/* U+2927 */	U2E_NODEST_COLX,
	/* U+2928 */	U2E_NODEST_COLX,
	/* U+2929 */	U2E_NODEST_COLX,
	/* U+292A */	U2E_NODEST_COLX,
	/* U+292B */	U2E_NODEST_COLX,
	/* U+292C */	U2E_NODEST_COLX,
	/* U+292D */	U2E_NODEST_COLX,
	/* U+292E */	U2E_NODEST_COLX,
	/* U+292F */	U2E_NODEST_COLX,
	/* U+2930 */	U2E_NODEST_COLX,
	/* U+2931 */	U2E_NODEST_COLX,
	/* U+2932 */	U2E_NODEST_COLX,
	/* U+2933 */	U2E_NODEST_COLX,
	/* U+2934 */	IFX0213(JISX0213_1(0xa3ae),	U2E_NODEST_COLX),
	/* U+2935 */	IFX0213(JISX0213_1(0xa3af),	U2E_NODEST_COLX),
	/* U+2936 */	U2E_NODEST_COLX,
	/* U+2937 */	U2E_NODEST_COLX,
	/* U+2938 */	U2E_NODEST_COLX,
	/* U+2939 */	U2E_NODEST_COLX,
	/* U+293A */	U2E_NODEST_COLX,
	/* U+293B */	U2E_NODEST_COLX,
	/* U+293C */	U2E_NODEST_COLX,
	/* U+293D */	U2E_NODEST_COLX,
	/* U+293E */	U2E_NODEST_COLX,
	/* U+293F */	U2E_NODEST_COLX,
	/* U+2940 */	U2E_NODEST_COLX,
	/* U+2941 */	U2E_NODEST_COLX,
	/* U+2942 */	U2E_NODEST_COLX,
	/* U+2943 */	U2E_NODEST_COLX,
	/* U+2944 */	U2E_NODEST_COLX,
	/* U+2945 */	U2E_NODEST_COLX,
	/* U+2946 */	U2E_NODEST_COLX,
	/* U+2947 */	U2E_NODEST_COLX,
	/* U+2948 */	U2E_NODEST_COLX,
	/* U+2949 */	U2E_NODEST_COLX,
	/* U+294A */	U2E_NODEST_COLX,
	/* U+294B */	U2E_NODEST_COLX,
	/* U+294C */	U2E_NODEST_COLX,
	/* U+294D */	U2E_NODEST_COLX,
	/* U+294E */	U2E_NODEST_COLX,
	/* U+294F */	U2E_NODEST_COLX,
	/* U+2950 */	U2E_NODEST_COLX,
	/* U+2951 */	U2E_NODEST_COLX,
	/* U+2952 */	U2E_NODEST_COLX,
	/* U+2953 */	U2E_NODEST_COLX,
	/* U+2954 */	U2E_NODEST_COLX,
	/* U+2955 */	U2E_NODEST_COLX,
	/* U+2956 */	U2E_NODEST_COLX,
	/* U+2957 */	U2E_NODEST_COLX,
	/* U+2958 */	U2E_NODEST_COLX,
	/* U+2959 */	U2E_NODEST_COLX,
	/* U+295A */	U2E_NODEST_COLX,
	/* U+295B */	U2E_NODEST_COLX,
	/* U+295C */	U2E_NODEST_COLX,
	/* U+295D */	U2E_NODEST_COLX,
	/* U+295E */	U2E_NODEST_COLX,
	/* U+295F */	U2E_NODEST_COLX,
	/* U+2960 */	U2E_NODEST_COLX,
	/* U+2961 */	U2E_NODEST_COLX,
	/* U+2962 */	U2E_NODEST_COLX,
	/* U+2963 */	U2E_NODEST_COLX,
	/* U+2964 */	U2E_NODEST_COLX,
	/* U+2965 */	U2E_NODEST_COLX,
	/* U+2966 */	U2E_NODEST_COLX,
	/* U+2967 */	U2E_NODEST_COLX,
	/* U+2968 */	U2E_NODEST_COLX,
	/* U+2969 */	U2E_NODEST_COLX,
	/* U+296A */	U2E_NODEST_COLX,
	/* U+296B */	U2E_NODEST_COLX,
	/* U+296C */	U2E_NODEST_COLX,
	/* U+296D */	U2E_NODEST_COLX,
	/* U+296E */	U2E_NODEST_COLX,
	/* U+296F */	U2E_NODEST_COLX,
	/* U+2970 */	U2E_NODEST_COLX,
	/* U+2971 */	U2E_NODEST_COLX,
	/* U+2972 */	U2E_NODEST_COLX,
	/* U+2973 */	U2E_NODEST_COLX,
	/* U+2974 */	U2E_NODEST_COLX,
	/* U+2975 */	U2E_NODEST_COLX,
	/* U+2976 */	U2E_NODEST_COLX,
	/* U+2977 */	U2E_NODEST_COLX,
	/* U+2978 */	U2E_NODEST_COLX,
	/* U+2979 */	U2E_NODEST_COLX,
	/* U+297A */	U2E_NODEST_COLX,
	/* U+297B */	U2E_NODEST_COLX,
	/* U+297C */	U2E_NODEST_COLX,
	/* U+297D */	U2E_NODEST_COLX,
	/* U+297E */	U2E_NODEST_COLX,
	/* U+297F */	U2E_NODEST_COLX,
	/* U+2980 */	U2E_NODEST_COLX,
	/* U+2981 */	U2E_NODEST_COLX,
	/* U+2982 */	U2E_NODEST_COLX,
	/* U+2983 */	U2E_NODEST_COLX,
	/* U+2984 */	U2E_NODEST_COLX,
	/* U+2985 */	U2E_NODEST_COLX,
	/* U+2986 */	U2E_NODEST_COLX,
	/* U+2987 */	U2E_NODEST_COLX,
	/* U+2988 */	U2E_NODEST_COLX,
	/* U+2989 */	U2E_NODEST_COLX,
	/* U+298A */	U2E_NODEST_COLX,
	/* U+298B */	U2E_NODEST_COLX,
	/* U+298C */	U2E_NODEST_COLX,
	/* U+298D */	U2E_NODEST_COLX,
	/* U+298E */	U2E_NODEST_COLX,
	/* U+298F */	U2E_NODEST_COLX,
	/* U+2990 */	U2E_NODEST_COLX,
	/* U+2991 */	U2E_NODEST_COLX,
	/* U+2992 */	U2E_NODEST_COLX,
	/* U+2993 */	U2E_NODEST_COLX,
	/* U+2994 */	U2E_NODEST_COLX,
	/* U+2995 */	U2E_NODEST_COLX,
	/* U+2996 */	U2E_NODEST_COLX,
	/* U+2997 */	U2E_NODEST_COLX,
	/* U+2998 */	U2E_NODEST_COLX,
	/* U+2999 */	U2E_NODEST_COLX,
	/* U+299A */	U2E_NODEST_COLX,
	/* U+299B */	U2E_NODEST_COLX,
	/* U+299C */	U2E_NODEST_COLX,
	/* U+299D */	U2E_NODEST_COLX,
	/* U+299E */	U2E_NODEST_COLX,
	/* U+299F */	U2E_NODEST_COLX,
	/* U+29A0 */	U2E_NODEST_COLX,
	/* U+29A1 */	U2E_NODEST_COLX,
	/* U+29A2 */	U2E_NODEST_COLX,
	/* U+29A3 */	U2E_NODEST_COLX,
	/* U+29A4 */	U2E_NODEST_COLX,
	/* U+29A5 */	U2E_NODEST_COLX,
	/* U+29A6 */	U2E_NODEST_COLX,
	/* U+29A7 */	U2E_NODEST_COLX,
	/* U+29A8 */	U2E_NODEST_COLX,
	/* U+29A9 */	U2E_NODEST_COLX,
	/* U+29AA */	U2E_NODEST_COLX,
	/* U+29AB */	U2E_NODEST_COLX,
	/* U+29AC */	U2E_NODEST_COLX,
	/* U+29AD */	U2E_NODEST_COLX,
	/* U+29AE */	U2E_NODEST_COLX,
	/* U+29AF */	U2E_NODEST_COLX,
	/* U+29B0 */	U2E_NODEST_COLX,
	/* U+29B1 */	U2E_NODEST_COLX,
	/* U+29B2 */	U2E_NODEST_COLX,
	/* U+29B3 */	U2E_NODEST_COLX,
	/* U+29B4 */	U2E_NODEST_COLX,
	/* U+29B5 */	U2E_NODEST_COLX,
	/* U+29B6 */	U2E_NODEST_COLX,
	/* U+29B7 */	U2E_NODEST_COLX,
	/* U+29B8 */	U2E_NODEST_COLX,
	/* U+29B9 */	U2E_NODEST_COLX,
	/* U+29BA */	U2E_NODEST_COLX,
	/* U+29BB */	U2E_NODEST_COLX,
	/* U+29BC */	U2E_NODEST_COLX,
	/* U+29BD */	U2E_NODEST_COLX,
	/* U+29BE */	U2E_NODEST_COLX,
	/* U+29BF */	IFX0213(JISX0213_1(0xa3ba),	U2E_NODEST_COLX),
	/* U+29C0 */	U2E_NODEST_COLX,
	/* U+29C1 */	U2E_NODEST_COLX,
	/* U+29C2 */	U2E_NODEST_COLX,
	/* U+29C3 */	U2E_NODEST_COLX,
	/* U+29C4 */	U2E_NODEST_COLX,
	/* U+29C5 */	U2E_NODEST_COLX,
	/* U+29C6 */	U2E_NODEST_COLX,
	/* U+29C7 */	U2E_NODEST_COLX,
	/* U+29C8 */	U2E_NODEST_COLX,
	/* U+29C9 */	U2E_NODEST_COLX,
	/* U+29CA */	U2E_NODEST_COLX,
	/* U+29CB */	U2E_NODEST_COLX,
	/* U+29CC */	U2E_NODEST_COLX,
	/* U+29CD */	U2E_NODEST_COLX,
	/* U+29CE */	U2E_NODEST_COLX,
	/* U+29CF */	U2E_NODEST_COLX,
	/* U+29D0 */	U2E_NODEST_COLX,
	/* U+29D1 */	U2E_NODEST_COLX,
	/* U+29D2 */	U2E_NODEST_COLX,
	/* U+29D3 */	U2E_NODEST_COLX,
	/* U+29D4 */	U2E_NODEST_COLX,
	/* U+29D5 */	U2E_NODEST_COLX,
	/* U+29D6 */	U2E_NODEST_COLX,
	/* U+29D7 */	U2E_NODEST_COLX,
	/* U+29D8 */	U2E_NODEST_COLX,
	/* U+29D9 */	U2E_NODEST_COLX,
	/* U+29DA */	U2E_NODEST_COLX,
	/* U+29DB */	U2E_NODEST_COLX,
	/* U+29DC */	U2E_NODEST_COLX,
	/* U+29DD */	U2E_NODEST_COLX,
	/* U+29DE */	U2E_NODEST_COLX,
	/* U+29DF */	U2E_NODEST_COLX,
	/* U+29E0 */	U2E_NODEST_COLX,
	/* U+29E1 */	U2E_NODEST_COLX,
	/* U+29E2 */	U2E_NODEST_COLX,
	/* U+29E3 */	U2E_NODEST_COLX,
	/* U+29E4 */	U2E_NODEST_COLX,
	/* U+29E5 */	U2E_NODEST_COLX,
	/* U+29E6 */	U2E_NODEST_COLX,
	/* U+29E7 */	U2E_NODEST_COLX,
	/* U+29E8 */	U2E_NODEST_COLX,
	/* U+29E9 */	U2E_NODEST_COLX,
	/* U+29EA */	U2E_NODEST_COLX,
	/* U+29EB */	U2E_NODEST_COLX,
	/* U+29EC */	U2E_NODEST_COLX,
	/* U+29ED */	U2E_NODEST_COLX,
	/* U+29EE */	U2E_NODEST_COLX,
	/* U+29EF */	U2E_NODEST_COLX,
	/* U+29F0 */	U2E_NODEST_COLX,
	/* U+29F1 */	U2E_NODEST_COLX,
	/* U+29F2 */	U2E_NODEST_COLX,
	/* U+29F3 */	U2E_NODEST_COLX,
	/* U+29F4 */	U2E_NODEST_COLX,
	/* U+29F5 */	U2E_NODEST_COLX,
	/* U+29F6 */	U2E_NODEST_COLX,
	/* U+29F7 */	U2E_NODEST_COLX,
	/* U+29F8 */	U2E_NODEST_COLX,
	/* U+29F9 */	U2E_NODEST_COLX,
	/* U+29FA */	IFX0213(JISX0213_1(0xa3fd),	U2E_NODEST_COLX),
	/* U+29FB */	IFX0213(JISX0213_1(0xa3fe),	U2E_NODEST_COLX),
	/* U+29FC */	U2E_NODEST_COLX,
	/* U+29FD */	U2E_NODEST_COLX,
	/* U+29FE */	U2E_NODEST_COLX,
	/* U+29FF */	U2E_NODEST_COLX,
};

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_2A[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_2B[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_2C[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_2D[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_2E[] eliminated */

/* static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_2F[] eliminated */

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_30[] = {
	/* U+3000 */	JISX0208(0xa1a1),
	/* U+3001 */	JISX0208(0xa1a2),
	/* U+3002 */	JISX0208(0xa1a3),
	/* U+3003 */	JISX0208(0xa1b7),
	/* U+3004 */	U2E_NODEST_COLX,
	/* U+3005 */	JISX0208(0xa1b9),
	/* U+3006 */	JISX0208(0xa1ba),
	/* U+3007 */	JISX0208(0xa1bb),
	/* U+3008 */	JISX0208(0xa1d2),
	/* U+3009 */	JISX0208(0xa1d3),
	/* U+300A */	JISX0208(0xa1d4),
	/* U+300B */	JISX0208(0xa1d5),
	/* U+300C */	JISX0208(0xa1d6),
	/* U+300D */	JISX0208(0xa1d7),
	/* U+300E */	JISX0208(0xa1d8),
	/* U+300F */	JISX0208(0xa1d9),
	/* U+3010 */	JISX0208(0xa1da),
	/* U+3011 */	JISX0208(0xa1db),
	/* U+3012 */	JISX0208(0xa2a9),
	/* U+3013 */	JISX0208(0xa2ae),
	/* U+3014 */	JISX0208(0xa1cc),
	/* U+3015 */	JISX0208(0xa1cd),
	/* U+3016 */	IFX0213(JISX0213_1(0xa2da),	U2E_NODEST_COLX),
	/* U+3017 */	IFX0213(JISX0213_1(0xa2db),	U2E_NODEST_COLX),
	/* U+3018 */	IFX0213(JISX0213_1(0xa2d8),	U2E_NODEST_COLX),
	/* U+3019 */	IFX0213(JISX0213_1(0xa2d9),	U2E_NODEST_COLX),
	/* U+301A */	U2E_NODEST_COLX,
	/* U+301B */	U2E_NODEST_COLX,
	/* U+301C */	U2E_301C_DEST,
	/* U+301D */	IFX0213(JISX0213_1(0xade0),	NEC13(0xade0)),
	/* U+301E */	U2E_NODEST_COLX,
	/* U+301F */	IFX0213(JISX0213_1(0xade1),	NEC13(0xade1)),
	/* U+3020 */	IFX0213(JISX0213_1(0xa6e6),	U2E_NODEST_COLX),
	/* U+3021 */	U2E_NODEST_COLX,
	/* U+3022 */	U2E_NODEST_COLX,
	/* U+3023 */	U2E_NODEST_COLX,
	/* U+3024 */	U2E_NODEST_COLX,
	/* U+3025 */	U2E_NODEST_COLX,
	/* U+3026 */	U2E_NODEST_COLX,
	/* U+3027 */	U2E_NODEST_COLX,
	/* U+3028 */	U2E_NODEST_COLX,
	/* U+3029 */	U2E_NODEST_COLX,
	/* U+302A */	U2E_NODEST_COLX,
	/* U+302B */	U2E_NODEST_COLX,
	/* U+302C */	U2E_NODEST_COLX,
	/* U+302D */	U2E_NODEST_COLX,
	/* U+302E */	U2E_NODEST_COLX,
	/* U+302F */	U2E_NODEST_COLX,
	/* U+3030 */	U2E_NODEST_COLX,
	/* U+3031 */	U2E_NODEST_COLX,
	/* U+3032 */	U2E_NODEST_COLX,
	/* U+3033 */	IFX0213(JISX0213_1(0xa2b3),	U2E_NODEST_COLX),
	/* U+3034 */	IFX0213(JISX0213_1(0xa2b4),	U2E_NODEST_COLX),
	/* U+3035 */	IFX0213(JISX0213_1(0xa2b5),	U2E_NODEST_COLX),
	/* U+3036 */	U2E_NODEST_COLX,
	/* U+3037 */	U2E_NODEST_COLX,
	/* U+3038 */	U2E_NODEST_COLX,
	/* U+3039 */	U2E_NODEST_COLX,
	/* U+303A */	U2E_NODEST_COLX,
	/* U+303B */	IFX0213(JISX0213_1(0xa2b6),	U2E_NODEST_COLX),
	/* U+303C */	IFX0213(JISX0213_1(0xa2b7),	U2E_NODEST_COLX),
	/* U+303D */	IFX0213(JISX0213_1(0xa3bc),	U2E_NODEST_COLX),
	/* U+303E */	U2E_NODEST_COLX,
	/* U+303F */	U2E_NODEST_COLX,
	/* U+3040 */	U2E_NODEST_COLX,
	/* U+3041 */	JISX0208(0xa4a1),
	/* U+3042 */	JISX0208(0xa4a2),
	/* U+3043 */	JISX0208(0xa4a3),
	/* U+3044 */	JISX0208(0xa4a4),
	/* U+3045 */	JISX0208(0xa4a5),
	/* U+3046 */	JISX0208(0xa4a6),
	/* U+3047 */	JISX0208(0xa4a7),
	/* U+3048 */	JISX0208(0xa4a8),
	/* U+3049 */	JISX0208(0xa4a9),
	/* U+304A */	JISX0208(0xa4aa),
	/* U+304B */	JISX0208(0xa4ab),
	/* U+304C */	JISX0208(0xa4ac),
	/* U+304D */	JISX0208(0xa4ad),
	/* U+304E */	JISX0208(0xa4ae),
	/* U+304F */	JISX0208(0xa4af),
	/* U+3050 */	JISX0208(0xa4b0),
	/* U+3051 */	JISX0208(0xa4b1),
	/* U+3052 */	JISX0208(0xa4b2),
	/* U+3053 */	JISX0208(0xa4b3),
	/* U+3054 */	JISX0208(0xa4b4),
	/* U+3055 */	JISX0208(0xa4b5),
	/* U+3056 */	JISX0208(0xa4b6),
	/* U+3057 */	JISX0208(0xa4b7),
	/* U+3058 */	JISX0208(0xa4b8),
	/* U+3059 */	JISX0208(0xa4b9),
	/* U+305A */	JISX0208(0xa4ba),
	/* U+305B */	JISX0208(0xa4bb),
	/* U+305C */	JISX0208(0xa4bc),
	/* U+305D */	JISX0208(0xa4bd),
	/* U+305E */	JISX0208(0xa4be),
	/* U+305F */	JISX0208(0xa4bf),
	/* U+3060 */	JISX0208(0xa4c0),
	/* U+3061 */	JISX0208(0xa4c1),
	/* U+3062 */	JISX0208(0xa4c2),
	/* U+3063 */	JISX0208(0xa4c3),
	/* U+3064 */	JISX0208(0xa4c4),
	/* U+3065 */	JISX0208(0xa4c5),
	/* U+3066 */	JISX0208(0xa4c6),
	/* U+3067 */	JISX0208(0xa4c7),
	/* U+3068 */	JISX0208(0xa4c8),
	/* U+3069 */	JISX0208(0xa4c9),
	/* U+306A */	JISX0208(0xa4ca),
	/* U+306B */	JISX0208(0xa4cb),
	/* U+306C */	JISX0208(0xa4cc),
	/* U+306D */	JISX0208(0xa4cd),
	/* U+306E */	JISX0208(0xa4ce),
	/* U+306F */	JISX0208(0xa4cf),
	/* U+3070 */	JISX0208(0xa4d0),
	/* U+3071 */	JISX0208(0xa4d1),
	/* U+3072 */	JISX0208(0xa4d2),
	/* U+3073 */	JISX0208(0xa4d3),
	/* U+3074 */	JISX0208(0xa4d4),
	/* U+3075 */	JISX0208(0xa4d5),
	/* U+3076 */	JISX0208(0xa4d6),
	/* U+3077 */	JISX0208(0xa4d7),
	/* U+3078 */	JISX0208(0xa4d8),
	/* U+3079 */	JISX0208(0xa4d9),
	/* U+307A */	JISX0208(0xa4da),
	/* U+307B */	JISX0208(0xa4db),
	/* U+307C */	JISX0208(0xa4dc),
	/* U+307D */	JISX0208(0xa4dd),
	/* U+307E */	JISX0208(0xa4de),
	/* U+307F */	JISX0208(0xa4df),
	/* U+3080 */	JISX0208(0xa4e0),
	/* U+3081 */	JISX0208(0xa4e1),
	/* U+3082 */	JISX0208(0xa4e2),
	/* U+3083 */	JISX0208(0xa4e3),
	/* U+3084 */	JISX0208(0xa4e4),
	/* U+3085 */	JISX0208(0xa4e5),
	/* U+3086 */	JISX0208(0xa4e6),
	/* U+3087 */	JISX0208(0xa4e7),
	/* U+3088 */	JISX0208(0xa4e8),
	/* U+3089 */	JISX0208(0xa4e9),
	/* U+308A */	JISX0208(0xa4ea),
	/* U+308B */	JISX0208(0xa4eb),
	/* U+308C */	JISX0208(0xa4ec),
	/* U+308D */	JISX0208(0xa4ed),
	/* U+308E */	JISX0208(0xa4ee),
	/* U+308F */	JISX0208(0xa4ef),
	/* U+3090 */	JISX0208(0xa4f0),
	/* U+3091 */	JISX0208(0xa4f1),
	/* U+3092 */	JISX0208(0xa4f2),
	/* U+3093 */	JISX0208(0xa4f3),
	/* U+3094 */	IFX0213(JISX0213_1(0xa4f4),	U2E_NODEST_COLX),
	/* U+3095 */	IFX0213(JISX0213_1(0xa4f5),	U2E_NODEST_COLX),
	/* U+3096 */	IFX0213(JISX0213_1(0xa4f6),	U2E_NODEST_COLX),
	/* U+3097 */	U2E_NODEST_COLX,
	/* U+3098 */	U2E_NODEST_COLX,
	/* U+3099 */	U2E_NODEST_COLX,
	/* U+309A */	U2E_NODEST_COLX,
	/* U+309B */	JISX0208(0xa1ab),
	/* U+309C */	JISX0208(0xa1ac),
	/* U+309D */	JISX0208(0xa1b5),
	/* U+309E */	JISX0208(0xa1b6),
	/* U+309F */	IFX0213(JISX0213_1(0xa2b9),	U2E_NODEST_COLX),
	/* U+30A0 */	IFX0213(JISX0213_1(0xa3fb),	U2E_NODEST_COLX),
	/* U+30A1 */	JISX0208(0xa5a1),
	/* U+30A2 */	JISX0208(0xa5a2),
	/* U+30A3 */	JISX0208(0xa5a3),
	/* U+30A4 */	JISX0208(0xa5a4),
	/* U+30A5 */	JISX0208(0xa5a5),
	/* U+30A6 */	JISX0208(0xa5a6),
	/* U+30A7 */	JISX0208(0xa5a7),
	/* U+30A8 */	JISX0208(0xa5a8),
	/* U+30A9 */	JISX0208(0xa5a9),
	/* U+30AA */	JISX0208(0xa5aa),
	/* U+30AB */	JISX0208(0xa5ab),
	/* U+30AC */	JISX0208(0xa5ac),
	/* U+30AD */	JISX0208(0xa5ad),
	/* U+30AE */	JISX0208(0xa5ae),
	/* U+30AF */	JISX0208(0xa5af),
	/* U+30B0 */	JISX0208(0xa5b0),
	/* U+30B1 */	JISX0208(0xa5b1),
	/* U+30B2 */	JISX0208(0xa5b2),
	/* U+30B3 */	JISX0208(0xa5b3),
	/* U+30B4 */	JISX0208(0xa5b4),
	/* U+30B5 */	JISX0208(0xa5b5),
	/* U+30B6 */	JISX0208(0xa5b6),
	/* U+30B7 */	JISX0208(0xa5b7),
	/* U+30B8 */	JISX0208(0xa5b8),
	/* U+30B9 */	JISX0208(0xa5b9),
	/* U+30BA */	JISX0208(0xa5ba),
	/* U+30BB */	JISX0208(0xa5bb),
	/* U+30BC */	JISX0208(0xa5bc),
	/* U+30BD */	JISX0208(0xa5bd),
	/* U+30BE */	JISX0208(0xa5be),
	/* U+30BF */	JISX0208(0xa5bf),
	/* U+30C0 */	JISX0208(0xa5c0),
	/* U+30C1 */	JISX0208(0xa5c1),
	/* U+30C2 */	JISX0208(0xa5c2),
	/* U+30C3 */	JISX0208(0xa5c3),
	/* U+30C4 */	JISX0208(0xa5c4),
	/* U+30C5 */	JISX0208(0xa5c5),
	/* U+30C6 */	JISX0208(0xa5c6),
	/* U+30C7 */	JISX0208(0xa5c7),
	/* U+30C8 */	JISX0208(0xa5c8),
	/* U+30C9 */	JISX0208(0xa5c9),
	/* U+30CA */	JISX0208(0xa5ca),
	/* U+30CB */	JISX0208(0xa5cb),
	/* U+30CC */	JISX0208(0xa5cc),
	/* U+30CD */	JISX0208(0xa5cd),
	/* U+30CE */	JISX0208(0xa5ce),
	/* U+30CF */	JISX0208(0xa5cf),
	/* U+30D0 */	JISX0208(0xa5d0),
	/* U+30D1 */	JISX0208(0xa5d1),
	/* U+30D2 */	JISX0208(0xa5d2),
	/* U+30D3 */	JISX0208(0xa5d3),
	/* U+30D4 */	JISX0208(0xa5d4),
	/* U+30D5 */	JISX0208(0xa5d5),
	/* U+30D6 */	JISX0208(0xa5d6),
	/* U+30D7 */	JISX0208(0xa5d7),
	/* U+30D8 */	JISX0208(0xa5d8),
	/* U+30D9 */	JISX0208(0xa5d9),
	/* U+30DA */	JISX0208(0xa5da),
	/* U+30DB */	JISX0208(0xa5db),
	/* U+30DC */	JISX0208(0xa5dc),
	/* U+30DD */	JISX0208(0xa5dd),
	/* U+30DE */	JISX0208(0xa5de),
	/* U+30DF */	JISX0208(0xa5df),
	/* U+30E0 */	JISX0208(0xa5e0),
	/* U+30E1 */	JISX0208(0xa5e1),
	/* U+30E2 */	JISX0208(0xa5e2),
	/* U+30E3 */	JISX0208(0xa5e3),
	/* U+30E4 */	JISX0208(0xa5e4),
	/* U+30E5 */	JISX0208(0xa5e5),
	/* U+30E6 */	JISX0208(0xa5e6),
	/* U+30E7 */	JISX0208(0xa5e7),
	/* U+30E8 */	JISX0208(0xa5e8),
	/* U+30E9 */	JISX0208(0xa5e9),
	/* U+30EA */	JISX0208(0xa5ea),
	/* U+30EB */	JISX0208(0xa5eb),
	/* U+30EC */	JISX0208(0xa5ec),
	/* U+30ED */	JISX0208(0xa5ed),
	/* U+30EE */	JISX0208(0xa5ee),
	/* U+30EF */	JISX0208(0xa5ef),
	/* U+30F0 */	JISX0208(0xa5f0),
	/* U+30F1 */	JISX0208(0xa5f1),
	/* U+30F2 */	JISX0208(0xa5f2),
	/* U+30F3 */	JISX0208(0xa5f3),
	/* U+30F4 */	JISX0208(0xa5f4),
	/* U+30F5 */	JISX0208(0xa5f5),
	/* U+30F6 */	JISX0208(0xa5f6),
	/* U+30F7 */	IFX0213(JISX0213_1(0xa7f2),	U2E_NODEST_COLX),
	/* U+30F8 */	IFX0213(JISX0213_1(0xa7f3),	U2E_NODEST_COLX),
	/* U+30F9 */	IFX0213(JISX0213_1(0xa7f4),	U2E_NODEST_COLX),
	/* U+30FA */	IFX0213(JISX0213_1(0xa7f5),	U2E_NODEST_COLX),
	/* U+30FB */	JISX0208(0xa1a6),
	/* U+30FC */	JISX0208(0xa1bc),
	/* U+30FD */	JISX0208(0xa1b3),
	/* U+30FE */	JISX0208(0xa1b4),
	/* U+30FF */	IFX0213(JISX0213_1(0xa2b8),	U2E_NODEST_COLX),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_31[] = {
	/* U+3100 */	U2E_NODEST_COLX,
	/* U+3101 */	U2E_NODEST_COLX,
	/* U+3102 */	U2E_NODEST_COLX,
	/* U+3103 */	U2E_NODEST_COLX,
	/* U+3104 */	U2E_NODEST_COLX,
	/* U+3105 */	U2E_NODEST_COLX,
	/* U+3106 */	U2E_NODEST_COLX,
	/* U+3107 */	U2E_NODEST_COLX,
	/* U+3108 */	U2E_NODEST_COLX,
	/* U+3109 */	U2E_NODEST_COLX,
	/* U+310A */	U2E_NODEST_COLX,
	/* U+310B */	U2E_NODEST_COLX,
	/* U+310C */	U2E_NODEST_COLX,
	/* U+310D */	U2E_NODEST_COLX,
	/* U+310E */	U2E_NODEST_COLX,
	/* U+310F */	U2E_NODEST_COLX,
	/* U+3110 */	U2E_NODEST_COLX,
	/* U+3111 */	U2E_NODEST_COLX,
	/* U+3112 */	U2E_NODEST_COLX,
	/* U+3113 */	U2E_NODEST_COLX,
	/* U+3114 */	U2E_NODEST_COLX,
	/* U+3115 */	U2E_NODEST_COLX,
	/* U+3116 */	U2E_NODEST_COLX,
	/* U+3117 */	U2E_NODEST_COLX,
	/* U+3118 */	U2E_NODEST_COLX,
	/* U+3119 */	U2E_NODEST_COLX,
	/* U+311A */	U2E_NODEST_COLX,
	/* U+311B */	U2E_NODEST_COLX,
	/* U+311C */	U2E_NODEST_COLX,
	/* U+311D */	U2E_NODEST_COLX,
	/* U+311E */	U2E_NODEST_COLX,
	/* U+311F */	U2E_NODEST_COLX,
	/* U+3120 */	U2E_NODEST_COLX,
	/* U+3121 */	U2E_NODEST_COLX,
	/* U+3122 */	U2E_NODEST_COLX,
	/* U+3123 */	U2E_NODEST_COLX,
	/* U+3124 */	U2E_NODEST_COLX,
	/* U+3125 */	U2E_NODEST_COLX,
	/* U+3126 */	U2E_NODEST_COLX,
	/* U+3127 */	U2E_NODEST_COLX,
	/* U+3128 */	U2E_NODEST_COLX,
	/* U+3129 */	U2E_NODEST_COLX,
	/* U+312A */	U2E_NODEST_COLX,
	/* U+312B */	U2E_NODEST_COLX,
	/* U+312C */	U2E_NODEST_COLX,
	/* U+312D */	U2E_NODEST_COLX,
	/* U+312E */	U2E_NODEST_COLX,
	/* U+312F */	U2E_NODEST_COLX,
	/* U+3130 */	U2E_NODEST_COLX,
	/* U+3131 */	U2E_NODEST_COLX,
	/* U+3132 */	U2E_NODEST_COLX,
	/* U+3133 */	U2E_NODEST_COLX,
	/* U+3134 */	U2E_NODEST_COLX,
	/* U+3135 */	U2E_NODEST_COLX,
	/* U+3136 */	U2E_NODEST_COLX,
	/* U+3137 */	U2E_NODEST_COLX,
	/* U+3138 */	U2E_NODEST_COLX,
	/* U+3139 */	U2E_NODEST_COLX,
	/* U+313A */	U2E_NODEST_COLX,
	/* U+313B */	U2E_NODEST_COLX,
	/* U+313C */	U2E_NODEST_COLX,
	/* U+313D */	U2E_NODEST_COLX,
	/* U+313E */	U2E_NODEST_COLX,
	/* U+313F */	U2E_NODEST_COLX,
	/* U+3140 */	U2E_NODEST_COLX,
	/* U+3141 */	U2E_NODEST_COLX,
	/* U+3142 */	U2E_NODEST_COLX,
	/* U+3143 */	U2E_NODEST_COLX,
	/* U+3144 */	U2E_NODEST_COLX,
	/* U+3145 */	U2E_NODEST_COLX,
	/* U+3146 */	U2E_NODEST_COLX,
	/* U+3147 */	U2E_NODEST_COLX,
	/* U+3148 */	U2E_NODEST_COLX,
	/* U+3149 */	U2E_NODEST_COLX,
	/* U+314A */	U2E_NODEST_COLX,
	/* U+314B */	U2E_NODEST_COLX,
	/* U+314C */	U2E_NODEST_COLX,
	/* U+314D */	U2E_NODEST_COLX,
	/* U+314E */	U2E_NODEST_COLX,
	/* U+314F */	U2E_NODEST_COLX,
	/* U+3150 */	U2E_NODEST_COLX,
	/* U+3151 */	U2E_NODEST_COLX,
	/* U+3152 */	U2E_NODEST_COLX,
	/* U+3153 */	U2E_NODEST_COLX,
	/* U+3154 */	U2E_NODEST_COLX,
	/* U+3155 */	U2E_NODEST_COLX,
	/* U+3156 */	U2E_NODEST_COLX,
	/* U+3157 */	U2E_NODEST_COLX,
	/* U+3158 */	U2E_NODEST_COLX,
	/* U+3159 */	U2E_NODEST_COLX,
	/* U+315A */	U2E_NODEST_COLX,
	/* U+315B */	U2E_NODEST_COLX,
	/* U+315C */	U2E_NODEST_COLX,
	/* U+315D */	U2E_NODEST_COLX,
	/* U+315E */	U2E_NODEST_COLX,
	/* U+315F */	U2E_NODEST_COLX,
	/* U+3160 */	U2E_NODEST_COLX,
	/* U+3161 */	U2E_NODEST_COLX,
	/* U+3162 */	U2E_NODEST_COLX,
	/* U+3163 */	U2E_NODEST_COLX,
	/* U+3164 */	U2E_NODEST_COLX,
	/* U+3165 */	U2E_NODEST_COLX,
	/* U+3166 */	U2E_NODEST_COLX,
	/* U+3167 */	U2E_NODEST_COLX,
	/* U+3168 */	U2E_NODEST_COLX,
	/* U+3169 */	U2E_NODEST_COLX,
	/* U+316A */	U2E_NODEST_COLX,
	/* U+316B */	U2E_NODEST_COLX,
	/* U+316C */	U2E_NODEST_COLX,
	/* U+316D */	U2E_NODEST_COLX,
	/* U+316E */	U2E_NODEST_COLX,
	/* U+316F */	U2E_NODEST_COLX,
	/* U+3170 */	U2E_NODEST_COLX,
	/* U+3171 */	U2E_NODEST_COLX,
	/* U+3172 */	U2E_NODEST_COLX,
	/* U+3173 */	U2E_NODEST_COLX,
	/* U+3174 */	U2E_NODEST_COLX,
	/* U+3175 */	U2E_NODEST_COLX,
	/* U+3176 */	U2E_NODEST_COLX,
	/* U+3177 */	U2E_NODEST_COLX,
	/* U+3178 */	U2E_NODEST_COLX,
	/* U+3179 */	U2E_NODEST_COLX,
	/* U+317A */	U2E_NODEST_COLX,
	/* U+317B */	U2E_NODEST_COLX,
	/* U+317C */	U2E_NODEST_COLX,
	/* U+317D */	U2E_NODEST_COLX,
	/* U+317E */	U2E_NODEST_COLX,
	/* U+317F */	U2E_NODEST_COLX,
	/* U+3180 */	U2E_NODEST_COLX,
	/* U+3181 */	U2E_NODEST_COLX,
	/* U+3182 */	U2E_NODEST_COLX,
	/* U+3183 */	U2E_NODEST_COLX,
	/* U+3184 */	U2E_NODEST_COLX,
	/* U+3185 */	U2E_NODEST_COLX,
	/* U+3186 */	U2E_NODEST_COLX,
	/* U+3187 */	U2E_NODEST_COLX,
	/* U+3188 */	U2E_NODEST_COLX,
	/* U+3189 */	U2E_NODEST_COLX,
	/* U+318A */	U2E_NODEST_COLX,
	/* U+318B */	U2E_NODEST_COLX,
	/* U+318C */	U2E_NODEST_COLX,
	/* U+318D */	U2E_NODEST_COLX,
	/* U+318E */	U2E_NODEST_COLX,
	/* U+318F */	U2E_NODEST_COLX,
	/* U+3190 */	U2E_NODEST_COLX,
	/* U+3191 */	U2E_NODEST_COLX,
	/* U+3192 */	U2E_NODEST_COLX,
	/* U+3193 */	U2E_NODEST_COLX,
	/* U+3194 */	U2E_NODEST_COLX,
	/* U+3195 */	U2E_NODEST_COLX,
	/* U+3196 */	U2E_NODEST_COLX,
	/* U+3197 */	U2E_NODEST_COLX,
	/* U+3198 */	U2E_NODEST_COLX,
	/* U+3199 */	U2E_NODEST_COLX,
	/* U+319A */	U2E_NODEST_COLX,
	/* U+319B */	U2E_NODEST_COLX,
	/* U+319C */	U2E_NODEST_COLX,
	/* U+319D */	U2E_NODEST_COLX,
	/* U+319E */	U2E_NODEST_COLX,
	/* U+319F */	U2E_NODEST_COLX,
	/* U+31A0 */	U2E_NODEST_COLX,
	/* U+31A1 */	U2E_NODEST_COLX,
	/* U+31A2 */	U2E_NODEST_COLX,
	/* U+31A3 */	U2E_NODEST_COLX,
	/* U+31A4 */	U2E_NODEST_COLX,
	/* U+31A5 */	U2E_NODEST_COLX,
	/* U+31A6 */	U2E_NODEST_COLX,
	/* U+31A7 */	U2E_NODEST_COLX,
	/* U+31A8 */	U2E_NODEST_COLX,
	/* U+31A9 */	U2E_NODEST_COLX,
	/* U+31AA */	U2E_NODEST_COLX,
	/* U+31AB */	U2E_NODEST_COLX,
	/* U+31AC */	U2E_NODEST_COLX,
	/* U+31AD */	U2E_NODEST_COLX,
	/* U+31AE */	U2E_NODEST_COLX,
	/* U+31AF */	U2E_NODEST_COLX,
	/* U+31B0 */	U2E_NODEST_COLX,
	/* U+31B1 */	U2E_NODEST_COLX,
	/* U+31B2 */	U2E_NODEST_COLX,
	/* U+31B3 */	U2E_NODEST_COLX,
	/* U+31B4 */	U2E_NODEST_COLX,
	/* U+31B5 */	U2E_NODEST_COLX,
	/* U+31B6 */	U2E_NODEST_COLX,
	/* U+31B7 */	U2E_NODEST_COLX,
	/* U+31B8 */	U2E_NODEST_COLX,
	/* U+31B9 */	U2E_NODEST_COLX,
	/* U+31BA */	U2E_NODEST_COLX,
	/* U+31BB */	U2E_NODEST_COLX,
	/* U+31BC */	U2E_NODEST_COLX,
	/* U+31BD */	U2E_NODEST_COLX,
	/* U+31BE */	U2E_NODEST_COLX,
	/* U+31BF */	U2E_NODEST_COLX,
	/* U+31C0 */	U2E_NODEST_COLX,
	/* U+31C1 */	U2E_NODEST_COLX,
	/* U+31C2 */	U2E_NODEST_COLX,
	/* U+31C3 */	U2E_NODEST_COLX,
	/* U+31C4 */	U2E_NODEST_COLX,
	/* U+31C5 */	U2E_NODEST_COLX,
	/* U+31C6 */	U2E_NODEST_COLX,
	/* U+31C7 */	U2E_NODEST_COLX,
	/* U+31C8 */	U2E_NODEST_COLX,
	/* U+31C9 */	U2E_NODEST_COLX,
	/* U+31CA */	U2E_NODEST_COLX,
	/* U+31CB */	U2E_NODEST_COLX,
	/* U+31CC */	U2E_NODEST_COLX,
	/* U+31CD */	U2E_NODEST_COLX,
	/* U+31CE */	U2E_NODEST_COLX,
	/* U+31CF */	U2E_NODEST_COLX,
	/* U+31D0 */	U2E_NODEST_COLX,
	/* U+31D1 */	U2E_NODEST_COLX,
	/* U+31D2 */	U2E_NODEST_COLX,
	/* U+31D3 */	U2E_NODEST_COLX,
	/* U+31D4 */	U2E_NODEST_COLX,
	/* U+31D5 */	U2E_NODEST_COLX,
	/* U+31D6 */	U2E_NODEST_COLX,
	/* U+31D7 */	U2E_NODEST_COLX,
	/* U+31D8 */	U2E_NODEST_COLX,
	/* U+31D9 */	U2E_NODEST_COLX,
	/* U+31DA */	U2E_NODEST_COLX,
	/* U+31DB */	U2E_NODEST_COLX,
	/* U+31DC */	U2E_NODEST_COLX,
	/* U+31DD */	U2E_NODEST_COLX,
	/* U+31DE */	U2E_NODEST_COLX,
	/* U+31DF */	U2E_NODEST_COLX,
	/* U+31E0 */	U2E_NODEST_COLX,
	/* U+31E1 */	U2E_NODEST_COLX,
	/* U+31E2 */	U2E_NODEST_COLX,
	/* U+31E3 */	U2E_NODEST_COLX,
	/* U+31E4 */	U2E_NODEST_COLX,
	/* U+31E5 */	U2E_NODEST_COLX,
	/* U+31E6 */	U2E_NODEST_COLX,
	/* U+31E7 */	U2E_NODEST_COLX,
	/* U+31E8 */	U2E_NODEST_COLX,
	/* U+31E9 */	U2E_NODEST_COLX,
	/* U+31EA */	U2E_NODEST_COLX,
	/* U+31EB */	U2E_NODEST_COLX,
	/* U+31EC */	U2E_NODEST_COLX,
	/* U+31ED */	U2E_NODEST_COLX,
	/* U+31EE */	U2E_NODEST_COLX,
	/* U+31EF */	U2E_NODEST_COLX,
	/* U+31F0 */	IFX0213(JISX0213_1(0xa6ee),	U2E_NODEST_COLX),
	/* U+31F1 */	IFX0213(JISX0213_1(0xa6ef),	U2E_NODEST_COLX),
	/* U+31F2 */	IFX0213(JISX0213_1(0xa6f0),	U2E_NODEST_COLX),
	/* U+31F3 */	IFX0213(JISX0213_1(0xa6f1),	U2E_NODEST_COLX),
	/* U+31F4 */	IFX0213(JISX0213_1(0xa6f2),	U2E_NODEST_COLX),
	/* U+31F5 */	IFX0213(JISX0213_1(0xa6f3),	U2E_NODEST_COLX),
	/* U+31F6 */	IFX0213(JISX0213_1(0xa6f4),	U2E_NODEST_COLX),
	/* U+31F7 */	IFX0213(JISX0213_1(0xa6f5),	U2E_NODEST_COLX),
	/* U+31F8 */	IFX0213(JISX0213_1(0xa6f6),	U2E_NODEST_COLX),
	/* U+31F9 */	IFX0213(JISX0213_1(0xa6f7),	U2E_NODEST_COLX),
	/* U+31FA */	IFX0213(JISX0213_1(0xa6f9),	U2E_NODEST_COLX),
	/* U+31FB */	IFX0213(JISX0213_1(0xa6fa),	U2E_NODEST_COLX),
	/* U+31FC */	IFX0213(JISX0213_1(0xa6fb),	U2E_NODEST_COLX),
	/* U+31FD */	IFX0213(JISX0213_1(0xa6fc),	U2E_NODEST_COLX),
	/* U+31FE */	IFX0213(JISX0213_1(0xa6fd),	U2E_NODEST_COLX),
	/* U+31FF */	IFX0213(JISX0213_1(0xa6fe),	U2E_NODEST_COLX),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_32[] = {
	/* U+3200 */	U2E_NODEST_COLX,
	/* U+3201 */	U2E_NODEST_COLX,
	/* U+3202 */	U2E_NODEST_COLX,
	/* U+3203 */	U2E_NODEST_COLX,
	/* U+3204 */	U2E_NODEST_COLX,
	/* U+3205 */	U2E_NODEST_COLX,
	/* U+3206 */	U2E_NODEST_COLX,
	/* U+3207 */	U2E_NODEST_COLX,
	/* U+3208 */	U2E_NODEST_COLX,
	/* U+3209 */	U2E_NODEST_COLX,
	/* U+320A */	U2E_NODEST_COLX,
	/* U+320B */	U2E_NODEST_COLX,
	/* U+320C */	U2E_NODEST_COLX,
	/* U+320D */	U2E_NODEST_COLX,
	/* U+320E */	U2E_NODEST_COLX,
	/* U+320F */	U2E_NODEST_COLX,
	/* U+3210 */	U2E_NODEST_COLX,
	/* U+3211 */	U2E_NODEST_COLX,
	/* U+3212 */	U2E_NODEST_COLX,
	/* U+3213 */	U2E_NODEST_COLX,
	/* U+3214 */	U2E_NODEST_COLX,
	/* U+3215 */	U2E_NODEST_COLX,
	/* U+3216 */	U2E_NODEST_COLX,
	/* U+3217 */	U2E_NODEST_COLX,
	/* U+3218 */	U2E_NODEST_COLX,
	/* U+3219 */	U2E_NODEST_COLX,
	/* U+321A */	U2E_NODEST_COLX,
	/* U+321B */	U2E_NODEST_COLX,
	/* U+321C */	U2E_NODEST_COLX,
	/* U+321D */	U2E_NODEST_COLX,
	/* U+321E */	U2E_NODEST_COLX,
	/* U+321F */	U2E_NODEST_COLX,
	/* U+3220 */	U2E_NODEST_COLX,
	/* U+3221 */	U2E_NODEST_COLX,
	/* U+3222 */	U2E_NODEST_COLX,
	/* U+3223 */	U2E_NODEST_COLX,
	/* U+3224 */	U2E_NODEST_COLX,
	/* U+3225 */	U2E_NODEST_COLX,
	/* U+3226 */	U2E_NODEST_COLX,
	/* U+3227 */	U2E_NODEST_COLX,
	/* U+3228 */	U2E_NODEST_COLX,
	/* U+3229 */	U2E_NODEST_COLX,
	/* U+322A */	U2E_NODEST_COLX,
	/* U+322B */	U2E_NODEST_COLX,
	/* U+322C */	U2E_NODEST_COLX,
	/* U+322D */	U2E_NODEST_COLX,
	/* U+322E */	U2E_NODEST_COLX,
	/* U+322F */	U2E_NODEST_COLX,
	/* U+3230 */	U2E_NODEST_COLX,
	/* U+3231 */	IFX0213(JISX0213_1(0xadea),	NEC13(0xadea)),
	/* U+3232 */	IFX0213(JISX0213_1(0xadeb),	NEC13(0xadeb)),
	/* U+3233 */	U2E_NODEST_COLX,
	/* U+3234 */	U2E_NODEST_COLX,
	/* U+3235 */	U2E_NODEST_COLX,
	/* U+3236 */	U2E_NODEST_COLX,
	/* U+3237 */	U2E_NODEST_COLX,
	/* U+3238 */	U2E_NODEST_COLX,
	/* U+3239 */	IFX0213(JISX0213_1(0xadec),	NEC13(0xadec)),
	/* U+323A */	U2E_NODEST_COLX,
	/* U+323B */	U2E_NODEST_COLX,
	/* U+323C */	U2E_NODEST_COLX,
	/* U+323D */	U2E_NODEST_COLX,
	/* U+323E */	U2E_NODEST_COLX,
	/* U+323F */	U2E_NODEST_COLX,
	/* U+3240 */	U2E_NODEST_COLX,
	/* U+3241 */	U2E_NODEST_COLX,
	/* U+3242 */	U2E_NODEST_COLX,
	/* U+3243 */	U2E_NODEST_COLX,
	/* U+3244 */	U2E_NODEST_COLX,
	/* U+3245 */	U2E_NODEST_COLX,
	/* U+3246 */	U2E_NODEST_COLX,
	/* U+3247 */	U2E_NODEST_COLX,
	/* U+3248 */	U2E_NODEST_COLX,
	/* U+3249 */	U2E_NODEST_COLX,
	/* U+324A */	U2E_NODEST_COLX,
	/* U+324B */	U2E_NODEST_COLX,
	/* U+324C */	U2E_NODEST_COLX,
	/* U+324D */	U2E_NODEST_COLX,
	/* U+324E */	U2E_NODEST_COLX,
	/* U+324F */	U2E_NODEST_COLX,
	/* U+3250 */	U2E_NODEST_COLX,
	/* U+3251 */	IFX0213(JISX0213_1(0xa8c1),	U2E_NODEST_COLX),
	/* U+3252 */	IFX0213(JISX0213_1(0xa8c2),	U2E_NODEST_COLX),
	/* U+3253 */	IFX0213(JISX0213_1(0xa8c3),	U2E_NODEST_COLX),
	/* U+3254 */	IFX0213(JISX0213_1(0xa8c4),	U2E_NODEST_COLX),
	/* U+3255 */	IFX0213(JISX0213_1(0xa8c5),	U2E_NODEST_COLX),
	/* U+3256 */	IFX0213(JISX0213_1(0xa8c6),	U2E_NODEST_COLX),
	/* U+3257 */	IFX0213(JISX0213_1(0xa8c7),	U2E_NODEST_COLX),
	/* U+3258 */	IFX0213(JISX0213_1(0xa8c8),	U2E_NODEST_COLX),
	/* U+3259 */	IFX0213(JISX0213_1(0xa8c9),	U2E_NODEST_COLX),
	/* U+325A */	IFX0213(JISX0213_1(0xa8ca),	U2E_NODEST_COLX),
	/* U+325B */	IFX0213(JISX0213_1(0xa8cb),	U2E_NODEST_COLX),
	/* U+325C */	IFX0213(JISX0213_1(0xa8cc),	U2E_NODEST_COLX),
	/* U+325D */	IFX0213(JISX0213_1(0xa8cd),	U2E_NODEST_COLX),
	/* U+325E */	IFX0213(JISX0213_1(0xa8ce),	U2E_NODEST_COLX),
	/* U+325F */	IFX0213(JISX0213_1(0xa8cf),	U2E_NODEST_COLX),
	/* U+3260 */	U2E_NODEST_COLX,
	/* U+3261 */	U2E_NODEST_COLX,
	/* U+3262 */	U2E_NODEST_COLX,
	/* U+3263 */	U2E_NODEST_COLX,
	/* U+3264 */	U2E_NODEST_COLX,
	/* U+3265 */	U2E_NODEST_COLX,
	/* U+3266 */	U2E_NODEST_COLX,
	/* U+3267 */	U2E_NODEST_COLX,
	/* U+3268 */	U2E_NODEST_COLX,
	/* U+3269 */	U2E_NODEST_COLX,
	/* U+326A */	U2E_NODEST_COLX,
	/* U+326B */	U2E_NODEST_COLX,
	/* U+326C */	U2E_NODEST_COLX,
	/* U+326D */	U2E_NODEST_COLX,
	/* U+326E */	U2E_NODEST_COLX,
	/* U+326F */	U2E_NODEST_COLX,
	/* U+3270 */	U2E_NODEST_COLX,
	/* U+3271 */	U2E_NODEST_COLX,
	/* U+3272 */	U2E_NODEST_COLX,
	/* U+3273 */	U2E_NODEST_COLX,
	/* U+3274 */	U2E_NODEST_COLX,
	/* U+3275 */	U2E_NODEST_COLX,
	/* U+3276 */	U2E_NODEST_COLX,
	/* U+3277 */	U2E_NODEST_COLX,
	/* U+3278 */	U2E_NODEST_COLX,
	/* U+3279 */	U2E_NODEST_COLX,
	/* U+327A */	U2E_NODEST_COLX,
	/* U+327B */	U2E_NODEST_COLX,
	/* U+327C */	U2E_NODEST_COLX,
	/* U+327D */	U2E_NODEST_COLX,
	/* U+327E */	U2E_NODEST_COLX,
	/* U+327F */	U2E_NODEST_COLX,
	/* U+3280 */	U2E_NODEST_COLX,
	/* U+3281 */	U2E_NODEST_COLX,
	/* U+3282 */	U2E_NODEST_COLX,
	/* U+3283 */	U2E_NODEST_COLX,
	/* U+3284 */	U2E_NODEST_COLX,
	/* U+3285 */	U2E_NODEST_COLX,
	/* U+3286 */	U2E_NODEST_COLX,
	/* U+3287 */	U2E_NODEST_COLX,
	/* U+3288 */	U2E_NODEST_COLX,
	/* U+3289 */	U2E_NODEST_COLX,
	/* U+328A */	U2E_NODEST_COLX,
	/* U+328B */	U2E_NODEST_COLX,
	/* U+328C */	U2E_NODEST_COLX,
	/* U+328D */	U2E_NODEST_COLX,
	/* U+328E */	U2E_NODEST_COLX,
	/* U+328F */	U2E_NODEST_COLX,
	/* U+3290 */	U2E_NODEST_COLX,
	/* U+3291 */	U2E_NODEST_COLX,
	/* U+3292 */	U2E_NODEST_COLX,
	/* U+3293 */	U2E_NODEST_COLX,
	/* U+3294 */	U2E_NODEST_COLX,
	/* U+3295 */	U2E_NODEST_COLX,
	/* U+3296 */	U2E_NODEST_COLX,
	/* U+3297 */	U2E_NODEST_COLX,
	/* U+3298 */	U2E_NODEST_COLX,
	/* U+3299 */	U2E_NODEST_COLX,
	/* U+329A */	U2E_NODEST_COLX,
	/* U+329B */	U2E_NODEST_COLX,
	/* U+329C */	U2E_NODEST_COLX,
	/* U+329D */	U2E_NODEST_COLX,
	/* U+329E */	U2E_NODEST_COLX,
	/* U+329F */	U2E_NODEST_COLX,
	/* U+32A0 */	U2E_NODEST_COLX,
	/* U+32A1 */	U2E_NODEST_COLX,
	/* U+32A2 */	U2E_NODEST_COLX,
	/* U+32A3 */	U2E_NODEST_COLX,
	/* U+32A4 */	IFX0213(JISX0213_1(0xade5),	NEC13(0xade5)),
	/* U+32A5 */	IFX0213(JISX0213_1(0xade6),	NEC13(0xade6)),
	/* U+32A6 */	IFX0213(JISX0213_1(0xade7),	NEC13(0xade7)),
	/* U+32A7 */	IFX0213(JISX0213_1(0xade8),	NEC13(0xade8)),
	/* U+32A8 */	IFX0213(JISX0213_1(0xade9),	NEC13(0xade9)),
	/* U+32A9 */	U2E_NODEST_COLX,
	/* U+32AA */	U2E_NODEST_COLX,
	/* U+32AB */	U2E_NODEST_COLX,
	/* U+32AC */	U2E_NODEST_COLX,
	/* U+32AD */	U2E_NODEST_COLX,
	/* U+32AE */	U2E_NODEST_COLX,
	/* U+32AF */	U2E_NODEST_COLX,
	/* U+32B0 */	U2E_NODEST_COLX,
	/* U+32B1 */	IFX0213(JISX0213_1(0xa8d0),	U2E_NODEST_COLX),
	/* U+32B2 */	IFX0213(JISX0213_1(0xa8d1),	U2E_NODEST_COLX),
	/* U+32B3 */	IFX0213(JISX0213_1(0xa8d2),	U2E_NODEST_COLX),
	/* U+32B4 */	IFX0213(JISX0213_1(0xa8d3),	U2E_NODEST_COLX),
	/* U+32B5 */	IFX0213(JISX0213_1(0xa8d4),	U2E_NODEST_COLX),
	/* U+32B6 */	IFX0213(JISX0213_1(0xa8d5),	U2E_NODEST_COLX),
	/* U+32B7 */	IFX0213(JISX0213_1(0xa8d6),	U2E_NODEST_COLX),
	/* U+32B8 */	IFX0213(JISX0213_1(0xa8d7),	U2E_NODEST_COLX),
	/* U+32B9 */	IFX0213(JISX0213_1(0xa8d8),	U2E_NODEST_COLX),
	/* U+32BA */	IFX0213(JISX0213_1(0xa8d9),	U2E_NODEST_COLX),
	/* U+32BB */	IFX0213(JISX0213_1(0xa8da),	U2E_NODEST_COLX),
	/* U+32BC */	IFX0213(JISX0213_1(0xa8db),	U2E_NODEST_COLX),
	/* U+32BD */	IFX0213(JISX0213_1(0xa8dc),	U2E_NODEST_COLX),
	/* U+32BE */	IFX0213(JISX0213_1(0xa8dd),	U2E_NODEST_COLX),
	/* U+32BF */	IFX0213(JISX0213_1(0xa8de),	U2E_NODEST_COLX),
	/* U+32C0 */	U2E_NODEST_COLX,
	/* U+32C1 */	U2E_NODEST_COLX,
	/* U+32C2 */	U2E_NODEST_COLX,
	/* U+32C3 */	U2E_NODEST_COLX,
	/* U+32C4 */	U2E_NODEST_COLX,
	/* U+32C5 */	U2E_NODEST_COLX,
	/* U+32C6 */	U2E_NODEST_COLX,
	/* U+32C7 */	U2E_NODEST_COLX,
	/* U+32C8 */	U2E_NODEST_COLX,
	/* U+32C9 */	U2E_NODEST_COLX,
	/* U+32CA */	U2E_NODEST_COLX,
	/* U+32CB */	U2E_NODEST_COLX,
	/* U+32CC */	U2E_NODEST_COLX,
	/* U+32CD */	U2E_NODEST_COLX,
	/* U+32CE */	U2E_NODEST_COLX,
	/* U+32CF */	U2E_NODEST_COLX,
	/* U+32D0 */	IFX0213(JISX0213_1(0xacdb),	U2E_NODEST_COLX),
	/* U+32D1 */	IFX0213(JISX0213_1(0xacdc),	U2E_NODEST_COLX),
	/* U+32D2 */	IFX0213(JISX0213_1(0xacdd),	U2E_NODEST_COLX),
	/* U+32D3 */	IFX0213(JISX0213_1(0xacde),	U2E_NODEST_COLX),
	/* U+32D4 */	IFX0213(JISX0213_1(0xacdf),	U2E_NODEST_COLX),
	/* U+32D5 */	IFX0213(JISX0213_1(0xace0),	U2E_NODEST_COLX),
	/* U+32D6 */	IFX0213(JISX0213_1(0xace1),	U2E_NODEST_COLX),
	/* U+32D7 */	IFX0213(JISX0213_1(0xace2),	U2E_NODEST_COLX),
	/* U+32D8 */	IFX0213(JISX0213_1(0xace3),	U2E_NODEST_COLX),
	/* U+32D9 */	IFX0213(JISX0213_1(0xace4),	U2E_NODEST_COLX),
	/* U+32DA */	IFX0213(JISX0213_1(0xace5),	U2E_NODEST_COLX),
	/* U+32DB */	IFX0213(JISX0213_1(0xace6),	U2E_NODEST_COLX),
	/* U+32DC */	IFX0213(JISX0213_1(0xace7),	U2E_NODEST_COLX),
	/* U+32DD */	IFX0213(JISX0213_1(0xace8),	U2E_NODEST_COLX),
	/* U+32DE */	IFX0213(JISX0213_1(0xace9),	U2E_NODEST_COLX),
	/* U+32DF */	IFX0213(JISX0213_1(0xacea),	U2E_NODEST_COLX),
	/* U+32E0 */	IFX0213(JISX0213_1(0xaceb),	U2E_NODEST_COLX),
	/* U+32E1 */	IFX0213(JISX0213_1(0xacec),	U2E_NODEST_COLX),
	/* U+32E2 */	IFX0213(JISX0213_1(0xaced),	U2E_NODEST_COLX),
	/* U+32E3 */	IFX0213(JISX0213_1(0xacee),	U2E_NODEST_COLX),
	/* U+32E4 */	U2E_NODEST_COLX,
	/* U+32E5 */	IFX0213(JISX0213_1(0xacf1),	U2E_NODEST_COLX),
	/* U+32E6 */	U2E_NODEST_COLX,
	/* U+32E7 */	U2E_NODEST_COLX,
	/* U+32E8 */	U2E_NODEST_COLX,
	/* U+32E9 */	IFX0213(JISX0213_1(0xacf0),	U2E_NODEST_COLX),
	/* U+32EA */	U2E_NODEST_COLX,
	/* U+32EB */	U2E_NODEST_COLX,
	/* U+32EC */	IFX0213(JISX0213_1(0xacf3),	U2E_NODEST_COLX),
	/* U+32ED */	IFX0213(JISX0213_1(0xacf2),	U2E_NODEST_COLX),
	/* U+32EE */	U2E_NODEST_COLX,
	/* U+32EF */	U2E_NODEST_COLX,
	/* U+32F0 */	U2E_NODEST_COLX,
	/* U+32F1 */	U2E_NODEST_COLX,
	/* U+32F2 */	U2E_NODEST_COLX,
	/* U+32F3 */	U2E_NODEST_COLX,
	/* U+32F4 */	U2E_NODEST_COLX,
	/* U+32F5 */	U2E_NODEST_COLX,
	/* U+32F6 */	U2E_NODEST_COLX,
	/* U+32F7 */	U2E_NODEST_COLX,
	/* U+32F8 */	U2E_NODEST_COLX,
	/* U+32F9 */	U2E_NODEST_COLX,
	/* U+32FA */	IFX0213(JISX0213_1(0xacef),	U2E_NODEST_COLX),
	/* U+32FB */	U2E_NODEST_COLX,
	/* U+32FC */	U2E_NODEST_COLX,
	/* U+32FD */	U2E_NODEST_COLX,
	/* U+32FE */	U2E_NODEST_COLX,
	/* U+32FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_33[] = {
	/* U+3300 */	U2E_NODEST_COLX,
	/* U+3301 */	U2E_NODEST_COLX,
	/* U+3302 */	U2E_NODEST_COLX,
	/* U+3303 */	IFX0213(JISX0213_1(0xadc6),	NEC13(0xadc6)),
	/* U+3304 */	U2E_NODEST_COLX,
	/* U+3305 */	U2E_NODEST_COLX,
	/* U+3306 */	U2E_NODEST_COLX,
	/* U+3307 */	U2E_NODEST_COLX,
	/* U+3308 */	U2E_NODEST_COLX,
	/* U+3309 */	U2E_NODEST_COLX,
	/* U+330A */	U2E_NODEST_COLX,
	/* U+330B */	U2E_NODEST_COLX,
	/* U+330C */	U2E_NODEST_COLX,
	/* U+330D */	IFX0213(JISX0213_1(0xadca),	NEC13(0xadca)),
	/* U+330E */	U2E_NODEST_COLX,
	/* U+330F */	U2E_NODEST_COLX,
	/* U+3310 */	U2E_NODEST_COLX,
	/* U+3311 */	U2E_NODEST_COLX,
	/* U+3312 */	U2E_NODEST_COLX,
	/* U+3313 */	U2E_NODEST_COLX,
	/* U+3314 */	IFX0213(JISX0213_1(0xadc1),	NEC13(0xadc1)),
	/* U+3315 */	U2E_NODEST_COLX,
	/* U+3316 */	U2E_NODEST_COLX,
	/* U+3317 */	U2E_NODEST_COLX,
	/* U+3318 */	IFX0213(JISX0213_1(0xadc4),	NEC13(0xadc4)),
	/* U+3319 */	U2E_NODEST_COLX,
	/* U+331A */	U2E_NODEST_COLX,
	/* U+331B */	U2E_NODEST_COLX,
	/* U+331C */	U2E_NODEST_COLX,
	/* U+331D */	U2E_NODEST_COLX,
	/* U+331E */	U2E_NODEST_COLX,
	/* U+331F */	U2E_NODEST_COLX,
	/* U+3320 */	U2E_NODEST_COLX,
	/* U+3321 */	U2E_NODEST_COLX,
	/* U+3322 */	IFX0213(JISX0213_1(0xadc2),	NEC13(0xadc2)),
	/* U+3323 */	IFX0213(JISX0213_1(0xadcc),	NEC13(0xadcc)),
	/* U+3324 */	U2E_NODEST_COLX,
	/* U+3325 */	U2E_NODEST_COLX,
	/* U+3326 */	IFX0213(JISX0213_1(0xadcb),	NEC13(0xadcb)),
	/* U+3327 */	IFX0213(JISX0213_1(0xadc5),	NEC13(0xadc5)),
	/* U+3328 */	U2E_NODEST_COLX,
	/* U+3329 */	U2E_NODEST_COLX,
	/* U+332A */	U2E_NODEST_COLX,
	/* U+332B */	IFX0213(JISX0213_1(0xadcd),	NEC13(0xadcd)),
	/* U+332C */	U2E_NODEST_COLX,
	/* U+332D */	U2E_NODEST_COLX,
	/* U+332E */	U2E_NODEST_COLX,
	/* U+332F */	U2E_NODEST_COLX,
	/* U+3330 */	U2E_NODEST_COLX,
	/* U+3331 */	U2E_NODEST_COLX,
	/* U+3332 */	U2E_NODEST_COLX,
	/* U+3333 */	U2E_NODEST_COLX,
	/* U+3334 */	U2E_NODEST_COLX,
	/* U+3335 */	U2E_NODEST_COLX,
	/* U+3336 */	IFX0213(JISX0213_1(0xadc7),	NEC13(0xadc7)),
	/* U+3337 */	U2E_NODEST_COLX,
	/* U+3338 */	U2E_NODEST_COLX,
	/* U+3339 */	U2E_NODEST_COLX,
	/* U+333A */	U2E_NODEST_COLX,
	/* U+333B */	IFX0213(JISX0213_1(0xadcf),	NEC13(0xadcf)),
	/* U+333C */	U2E_NODEST_COLX,
	/* U+333D */	U2E_NODEST_COLX,
	/* U+333E */	U2E_NODEST_COLX,
	/* U+333F */	U2E_NODEST_COLX,
	/* U+3340 */	U2E_NODEST_COLX,
	/* U+3341 */	U2E_NODEST_COLX,
	/* U+3342 */	U2E_NODEST_COLX,
	/* U+3343 */	U2E_NODEST_COLX,
	/* U+3344 */	U2E_NODEST_COLX,
	/* U+3345 */	U2E_NODEST_COLX,
	/* U+3346 */	U2E_NODEST_COLX,
	/* U+3347 */	U2E_NODEST_COLX,
	/* U+3348 */	U2E_NODEST_COLX,
	/* U+3349 */	IFX0213(JISX0213_1(0xadc0),	NEC13(0xadc0)),
	/* U+334A */	IFX0213(JISX0213_1(0xadce),	NEC13(0xadce)),
	/* U+334B */	U2E_NODEST_COLX,
	/* U+334C */	U2E_NODEST_COLX,
	/* U+334D */	IFX0213(JISX0213_1(0xadc3),	NEC13(0xadc3)),
	/* U+334E */	U2E_NODEST_COLX,
	/* U+334F */	U2E_NODEST_COLX,
	/* U+3350 */	U2E_NODEST_COLX,
	/* U+3351 */	IFX0213(JISX0213_1(0xadc8),	NEC13(0xadc8)),
	/* U+3352 */	U2E_NODEST_COLX,
	/* U+3353 */	U2E_NODEST_COLX,
	/* U+3354 */	U2E_NODEST_COLX,
	/* U+3355 */	U2E_NODEST_COLX,
	/* U+3356 */	U2E_NODEST_COLX,
	/* U+3357 */	IFX0213(JISX0213_1(0xadc9),	NEC13(0xadc9)),
	/* U+3358 */	U2E_NODEST_COLX,
	/* U+3359 */	U2E_NODEST_COLX,
	/* U+335A */	U2E_NODEST_COLX,
	/* U+335B */	U2E_NODEST_COLX,
	/* U+335C */	U2E_NODEST_COLX,
	/* U+335D */	U2E_NODEST_COLX,
	/* U+335E */	U2E_NODEST_COLX,
	/* U+335F */	U2E_NODEST_COLX,
	/* U+3360 */	U2E_NODEST_COLX,
	/* U+3361 */	U2E_NODEST_COLX,
	/* U+3362 */	U2E_NODEST_COLX,
	/* U+3363 */	U2E_NODEST_COLX,
	/* U+3364 */	U2E_NODEST_COLX,
	/* U+3365 */	U2E_NODEST_COLX,
	/* U+3366 */	U2E_NODEST_COLX,
	/* U+3367 */	U2E_NODEST_COLX,
	/* U+3368 */	U2E_NODEST_COLX,
	/* U+3369 */	U2E_NODEST_COLX,
	/* U+336A */	U2E_NODEST_COLX,
	/* U+336B */	U2E_NODEST_COLX,
	/* U+336C */	U2E_NODEST_COLX,
	/* U+336D */	U2E_NODEST_COLX,
	/* U+336E */	U2E_NODEST_COLX,
	/* U+336F */	U2E_NODEST_COLX,
	/* U+3370 */	U2E_NODEST_COLX,
	/* U+3371 */	U2E_NODEST_COLX,
	/* U+3372 */	U2E_NODEST_COLX,
	/* U+3373 */	U2E_NODEST_COLX,
	/* U+3374 */	U2E_NODEST_COLX,
	/* U+3375 */	U2E_NODEST_COLX,
	/* U+3376 */	U2E_NODEST_COLX,
	/* U+3377 */	U2E_NODEST_COLX,
	/* U+3378 */	U2E_NODEST_COLX,
	/* U+3379 */	U2E_NODEST_COLX,
	/* U+337A */	U2E_NODEST_COLX,
	/* U+337B */	IFX0213(JISX0213_1(0xaddf),	NEC13(0xaddf)),
	/* U+337C */	IFX0213(JISX0213_1(0xadef),	NEC13(0xadef)),
	/* U+337D */	IFX0213(JISX0213_1(0xadee),	NEC13(0xadee)),
	/* U+337E */	IFX0213(JISX0213_1(0xaded),	NEC13(0xaded)),
	/* U+337F */	U2E_NODEST_COLX,
	/* U+3380 */	U2E_NODEST_COLX,
	/* U+3381 */	U2E_NODEST_COLX,
	/* U+3382 */	U2E_NODEST_COLX,
	/* U+3383 */	U2E_NODEST_COLX,
	/* U+3384 */	U2E_NODEST_COLX,
	/* U+3385 */	U2E_NODEST_COLX,
	/* U+3386 */	U2E_NODEST_COLX,
	/* U+3387 */	U2E_NODEST_COLX,
	/* U+3388 */	U2E_NODEST_COLX,
	/* U+3389 */	U2E_NODEST_COLX,
	/* U+338A */	U2E_NODEST_COLX,
	/* U+338B */	U2E_NODEST_COLX,
	/* U+338C */	U2E_NODEST_COLX,
	/* U+338D */	U2E_NODEST_COLX,
	/* U+338E */	IFX0213(JISX0213_1(0xadd3),	NEC13(0xadd3)),
	/* U+338F */	IFX0213(JISX0213_1(0xadd4),	NEC13(0xadd4)),
	/* U+3390 */	U2E_NODEST_COLX,
	/* U+3391 */	U2E_NODEST_COLX,
	/* U+3392 */	U2E_NODEST_COLX,
	/* U+3393 */	U2E_NODEST_COLX,
	/* U+3394 */	U2E_NODEST_COLX,
	/* U+3395 */	U2E_NODEST_COLX,
	/* U+3396 */	U2E_NODEST_COLX,
	/* U+3397 */	U2E_NODEST_COLX,
	/* U+3398 */	U2E_NODEST_COLX,
	/* U+3399 */	U2E_NODEST_COLX,
	/* U+339A */	U2E_NODEST_COLX,
	/* U+339B */	U2E_NODEST_COLX,
	/* U+339C */	IFX0213(JISX0213_1(0xadd0),	NEC13(0xadd0)),
	/* U+339D */	IFX0213(JISX0213_1(0xadd1),	NEC13(0xadd1)),
	/* U+339E */	IFX0213(JISX0213_1(0xadd2),	NEC13(0xadd2)),
	/* U+339F */	U2E_NODEST_COLX,
	/* U+33A0 */	U2E_NODEST_COLX,
	/* U+33A1 */	IFX0213(JISX0213_1(0xadd6),	NEC13(0xadd6)),
	/* U+33A2 */	U2E_NODEST_COLX,
	/* U+33A3 */	U2E_NODEST_COLX,
	/* U+33A4 */	U2E_NODEST_COLX,
	/* U+33A5 */	U2E_NODEST_COLX,
	/* U+33A6 */	U2E_NODEST_COLX,
	/* U+33A7 */	U2E_NODEST_COLX,
	/* U+33A8 */	U2E_NODEST_COLX,
	/* U+33A9 */	U2E_NODEST_COLX,
	/* U+33AA */	U2E_NODEST_COLX,
	/* U+33AB */	U2E_NODEST_COLX,
	/* U+33AC */	U2E_NODEST_COLX,
	/* U+33AD */	U2E_NODEST_COLX,
	/* U+33AE */	U2E_NODEST_COLX,
	/* U+33AF */	U2E_NODEST_COLX,
	/* U+33B0 */	U2E_NODEST_COLX,
	/* U+33B1 */	U2E_NODEST_COLX,
	/* U+33B2 */	U2E_NODEST_COLX,
	/* U+33B3 */	U2E_NODEST_COLX,
	/* U+33B4 */	U2E_NODEST_COLX,
	/* U+33B5 */	U2E_NODEST_COLX,
	/* U+33B6 */	U2E_NODEST_COLX,
	/* U+33B7 */	U2E_NODEST_COLX,
	/* U+33B8 */	U2E_NODEST_COLX,
	/* U+33B9 */	U2E_NODEST_COLX,
	/* U+33BA */	U2E_NODEST_COLX,
	/* U+33BB */	U2E_NODEST_COLX,
	/* U+33BC */	U2E_NODEST_COLX,
	/* U+33BD */	U2E_NODEST_COLX,
	/* U+33BE */	U2E_NODEST_COLX,
	/* U+33BF */	U2E_NODEST_COLX,
	/* U+33C0 */	U2E_NODEST_COLX,
	/* U+33C1 */	U2E_NODEST_COLX,
	/* U+33C2 */	U2E_NODEST_COLX,
	/* U+33C3 */	U2E_NODEST_COLX,
	/* U+33C4 */	IFX0213(JISX0213_1(0xadd5),	NEC13(0xadd5)),
	/* U+33C5 */	U2E_NODEST_COLX,
	/* U+33C6 */	U2E_NODEST_COLX,
	/* U+33C7 */	U2E_NODEST_COLX,
	/* U+33C8 */	U2E_NODEST_COLX,
	/* U+33C9 */	U2E_NODEST_COLX,
	/* U+33CA */	U2E_NODEST_COLX,
	/* U+33CB */	IFX0213(JISX0213_1(0xa3de),	U2E_NODEST_COLX),
	/* U+33CC */	U2E_NODEST_COLX,
	/* U+33CD */	IFX0213(JISX0213_1(0xade3),	NEC13(0xade3)),
	/* U+33CE */	U2E_NODEST_COLX,
	/* U+33CF */	U2E_NODEST_COLX,
	/* U+33D0 */	U2E_NODEST_COLX,
	/* U+33D1 */	U2E_NODEST_COLX,
	/* U+33D2 */	U2E_NODEST_COLX,
	/* U+33D3 */	U2E_NODEST_COLX,
	/* U+33D4 */	U2E_NODEST_COLX,
	/* U+33D5 */	U2E_NODEST_COLX,
	/* U+33D6 */	U2E_NODEST_COLX,
	/* U+33D7 */	U2E_NODEST_COLX,
	/* U+33D8 */	U2E_NODEST_COLX,
	/* U+33D9 */	U2E_NODEST_COLX,
	/* U+33DA */	U2E_NODEST_COLX,
	/* U+33DB */	U2E_NODEST_COLX,
	/* U+33DC */	U2E_NODEST_COLX,
	/* U+33DD */	U2E_NODEST_COLX,
	/* U+33DE */	U2E_NODEST_COLX,
	/* U+33DF */	U2E_NODEST_COLX,
	/* U+33E0 */	U2E_NODEST_COLX,
	/* U+33E1 */	U2E_NODEST_COLX,
	/* U+33E2 */	U2E_NODEST_COLX,
	/* U+33E3 */	U2E_NODEST_COLX,
	/* U+33E4 */	U2E_NODEST_COLX,
	/* U+33E5 */	U2E_NODEST_COLX,
	/* U+33E6 */	U2E_NODEST_COLX,
	/* U+33E7 */	U2E_NODEST_COLX,
	/* U+33E8 */	U2E_NODEST_COLX,
	/* U+33E9 */	U2E_NODEST_COLX,
	/* U+33EA */	U2E_NODEST_COLX,
	/* U+33EB */	U2E_NODEST_COLX,
	/* U+33EC */	U2E_NODEST_COLX,
	/* U+33ED */	U2E_NODEST_COLX,
	/* U+33EE */	U2E_NODEST_COLX,
	/* U+33EF */	U2E_NODEST_COLX,
	/* U+33F0 */	U2E_NODEST_COLX,
	/* U+33F1 */	U2E_NODEST_COLX,
	/* U+33F2 */	U2E_NODEST_COLX,
	/* U+33F3 */	U2E_NODEST_COLX,
	/* U+33F4 */	U2E_NODEST_COLX,
	/* U+33F5 */	U2E_NODEST_COLX,
	/* U+33F6 */	U2E_NODEST_COLX,
	/* U+33F7 */	U2E_NODEST_COLX,
	/* U+33F8 */	U2E_NODEST_COLX,
	/* U+33F9 */	U2E_NODEST_COLX,
	/* U+33FA */	U2E_NODEST_COLX,
	/* U+33FB */	U2E_NODEST_COLX,
	/* U+33FC */	U2E_NODEST_COLX,
	/* U+33FD */	U2E_NODEST_COLX,
	/* U+33FE */	U2E_NODEST_COLX,
	/* U+33FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_34[] = {
	/* U+3400 */	U2E_NODEST_COLX,
	/* U+3401 */	U2E_NODEST_COLX,
	/* U+3402 */	IFX0213(JISX0213_1(0xaea3),	U2E_NODEST_COLX),
	/* U+3403 */	U2E_NODEST_COLX,
	/* U+3404 */	U2E_NODEST_COLX,
	/* U+3405 */	U2E_NODEST_COLX,
	/* U+3406 */	IFX0213(JISX0213_2(0xa12d),	U2E_NODEST_COLX),
	/* U+3407 */	U2E_NODEST_COLX,
	/* U+3408 */	U2E_NODEST_COLX,
	/* U+3409 */	U2E_NODEST_COLX,
	/* U+340A */	U2E_NODEST_COLX,
	/* U+340B */	U2E_NODEST_COLX,
	/* U+340C */	U2E_NODEST_COLX,
	/* U+340D */	U2E_NODEST_COLX,
	/* U+340E */	U2E_NODEST_COLX,
	/* U+340F */	U2E_NODEST_COLX,
	/* U+3410 */	U2E_NODEST_COLX,
	/* U+3411 */	U2E_NODEST_COLX,
	/* U+3412 */	U2E_NODEST_COLX,
	/* U+3413 */	U2E_NODEST_COLX,
	/* U+3414 */	U2E_NODEST_COLX,
	/* U+3415 */	U2E_NODEST_COLX,
	/* U+3416 */	U2E_NODEST_COLX,
	/* U+3417 */	U2E_NODEST_COLX,
	/* U+3418 */	U2E_NODEST_COLX,
	/* U+3419 */	U2E_NODEST_COLX,
	/* U+341A */	U2E_NODEST_COLX,
	/* U+341B */	U2E_NODEST_COLX,
	/* U+341C */	U2E_NODEST_COLX,
	/* U+341D */	U2E_NODEST_COLX,
	/* U+341E */	U2E_NODEST_COLX,
	/* U+341F */	U2E_NODEST_COLX,
	/* U+3420 */	U2E_NODEST_COLX,
	/* U+3421 */	U2E_NODEST_COLX,
	/* U+3422 */	U2E_NODEST_COLX,
	/* U+3423 */	U2E_NODEST_COLX,
	/* U+3424 */	U2E_NODEST_COLX,
	/* U+3425 */	U2E_NODEST_COLX,
	/* U+3426 */	U2E_NODEST_COLX,
	/* U+3427 */	U2E_NODEST_COLX,
	/* U+3428 */	U2E_NODEST_COLX,
	/* U+3429 */	U2E_NODEST_COLX,
	/* U+342A */	U2E_NODEST_COLX,
	/* U+342B */	U2E_NODEST_COLX,
	/* U+342C */	IFX0213(JISX0213_2(0xa132),	U2E_NODEST_COLX),
	/* U+342D */	U2E_NODEST_COLX,
	/* U+342E */	IFX0213(JISX0213_2(0xa133),	U2E_NODEST_COLX),
	/* U+342F */	U2E_NODEST_COLX,
	/* U+3430 */	U2E_NODEST_COLX,
	/* U+3431 */	U2E_NODEST_COLX,
	/* U+3432 */	U2E_NODEST_COLX,
	/* U+3433 */	U2E_NODEST_COLX,
	/* U+3434 */	U2E_NODEST_COLX,
	/* U+3435 */	U2E_NODEST_COLX,
	/* U+3436 */	U2E_NODEST_COLX,
	/* U+3437 */	U2E_NODEST_COLX,
	/* U+3438 */	U2E_NODEST_COLX,
	/* U+3439 */	U2E_NODEST_COLX,
	/* U+343A */	U2E_NODEST_COLX,
	/* U+343B */	U2E_NODEST_COLX,
	/* U+343C */	U2E_NODEST_COLX,
	/* U+343D */	U2E_NODEST_COLX,
	/* U+343E */	U2E_NODEST_COLX,
	/* U+343F */	U2E_NODEST_COLX,
	/* U+3440 */	U2E_NODEST_COLX,
	/* U+3441 */	U2E_NODEST_COLX,
	/* U+3442 */	U2E_NODEST_COLX,
	/* U+3443 */	U2E_NODEST_COLX,
	/* U+3444 */	U2E_NODEST_COLX,
	/* U+3445 */	U2E_NODEST_COLX,
	/* U+3446 */	U2E_NODEST_COLX,
	/* U+3447 */	U2E_NODEST_COLX,
	/* U+3448 */	U2E_NODEST_COLX,
	/* U+3449 */	U2E_NODEST_COLX,
	/* U+344A */	U2E_NODEST_COLX,
	/* U+344B */	U2E_NODEST_COLX,
	/* U+344C */	U2E_NODEST_COLX,
	/* U+344D */	U2E_NODEST_COLX,
	/* U+344E */	U2E_NODEST_COLX,
	/* U+344F */	U2E_NODEST_COLX,
	/* U+3450 */	U2E_NODEST_COLX,
	/* U+3451 */	U2E_NODEST_COLX,
	/* U+3452 */	U2E_NODEST_COLX,
	/* U+3453 */	U2E_NODEST_COLX,
	/* U+3454 */	U2E_NODEST_COLX,
	/* U+3455 */	U2E_NODEST_COLX,
	/* U+3456 */	U2E_NODEST_COLX,
	/* U+3457 */	U2E_NODEST_COLX,
	/* U+3458 */	U2E_NODEST_COLX,
	/* U+3459 */	U2E_NODEST_COLX,
	/* U+345A */	U2E_NODEST_COLX,
	/* U+345B */	U2E_NODEST_COLX,
	/* U+345C */	U2E_NODEST_COLX,
	/* U+345D */	U2E_NODEST_COLX,
	/* U+345E */	U2E_NODEST_COLX,
	/* U+345F */	U2E_NODEST_COLX,
	/* U+3460 */	U2E_NODEST_COLX,
	/* U+3461 */	U2E_NODEST_COLX,
	/* U+3462 */	U2E_NODEST_COLX,
	/* U+3463 */	U2E_NODEST_COLX,
	/* U+3464 */	U2E_NODEST_COLX,
	/* U+3465 */	U2E_NODEST_COLX,
	/* U+3466 */	U2E_NODEST_COLX,
	/* U+3467 */	U2E_NODEST_COLX,
	/* U+3468 */	IFX0213(JISX0213_2(0xa15e),	U2E_NODEST_COLX),
	/* U+3469 */	U2E_NODEST_COLX,
	/* U+346A */	IFX0213(JISX0213_2(0xa156),	U2E_NODEST_COLX),
	/* U+346B */	U2E_NODEST_COLX,
	/* U+346C */	U2E_NODEST_COLX,
	/* U+346D */	U2E_NODEST_COLX,
	/* U+346E */	U2E_NODEST_COLX,
	/* U+346F */	U2E_NODEST_COLX,
	/* U+3470 */	U2E_NODEST_COLX,
	/* U+3471 */	U2E_NODEST_COLX,
	/* U+3472 */	U2E_NODEST_COLX,
	/* U+3473 */	U2E_NODEST_COLX,
	/* U+3474 */	U2E_NODEST_COLX,
	/* U+3475 */	U2E_NODEST_COLX,
	/* U+3476 */	U2E_NODEST_COLX,
	/* U+3477 */	U2E_NODEST_COLX,
	/* U+3478 */	U2E_NODEST_COLX,
	/* U+3479 */	U2E_NODEST_COLX,
	/* U+347A */	U2E_NODEST_COLX,
	/* U+347B */	U2E_NODEST_COLX,
	/* U+347C */	U2E_NODEST_COLX,
	/* U+347D */	U2E_NODEST_COLX,
	/* U+347E */	U2E_NODEST_COLX,
	/* U+347F */	U2E_NODEST_COLX,
	/* U+3480 */	U2E_NODEST_COLX,
	/* U+3481 */	U2E_NODEST_COLX,
	/* U+3482 */	U2E_NODEST_COLX,
	/* U+3483 */	U2E_NODEST_COLX,
	/* U+3484 */	U2E_NODEST_COLX,
	/* U+3485 */	U2E_NODEST_COLX,
	/* U+3486 */	U2E_NODEST_COLX,
	/* U+3487 */	U2E_NODEST_COLX,
	/* U+3488 */	U2E_NODEST_COLX,
	/* U+3489 */	U2E_NODEST_COLX,
	/* U+348A */	U2E_NODEST_COLX,
	/* U+348B */	U2E_NODEST_COLX,
	/* U+348C */	U2E_NODEST_COLX,
	/* U+348D */	U2E_NODEST_COLX,
	/* U+348E */	U2E_NODEST_COLX,
	/* U+348F */	U2E_NODEST_COLX,
	/* U+3490 */	U2E_NODEST_COLX,
	/* U+3491 */	U2E_NODEST_COLX,
	/* U+3492 */	IFX0213(JISX0213_2(0xa17e),	U2E_NODEST_COLX),
	/* U+3493 */	U2E_NODEST_COLX,
	/* U+3494 */	U2E_NODEST_COLX,
	/* U+3495 */	U2E_NODEST_COLX,
	/* U+3496 */	U2E_NODEST_COLX,
	/* U+3497 */	U2E_NODEST_COLX,
	/* U+3498 */	U2E_NODEST_COLX,
	/* U+3499 */	U2E_NODEST_COLX,
	/* U+349A */	U2E_NODEST_COLX,
	/* U+349B */	U2E_NODEST_COLX,
	/* U+349C */	U2E_NODEST_COLX,
	/* U+349D */	U2E_NODEST_COLX,
	/* U+349E */	U2E_NODEST_COLX,
	/* U+349F */	U2E_NODEST_COLX,
	/* U+34A0 */	U2E_NODEST_COLX,
	/* U+34A1 */	U2E_NODEST_COLX,
	/* U+34A2 */	U2E_NODEST_COLX,
	/* U+34A3 */	U2E_NODEST_COLX,
	/* U+34A4 */	U2E_NODEST_COLX,
	/* U+34A5 */	U2E_NODEST_COLX,
	/* U+34A6 */	U2E_NODEST_COLX,
	/* U+34A7 */	U2E_NODEST_COLX,
	/* U+34A8 */	U2E_NODEST_COLX,
	/* U+34A9 */	U2E_NODEST_COLX,
	/* U+34AA */	U2E_NODEST_COLX,
	/* U+34AB */	U2E_NODEST_COLX,
	/* U+34AC */	U2E_NODEST_COLX,
	/* U+34AD */	U2E_NODEST_COLX,
	/* U+34AE */	U2E_NODEST_COLX,
	/* U+34AF */	U2E_NODEST_COLX,
	/* U+34B0 */	U2E_NODEST_COLX,
	/* U+34B1 */	U2E_NODEST_COLX,
	/* U+34B2 */	U2E_NODEST_COLX,
	/* U+34B3 */	U2E_NODEST_COLX,
	/* U+34B4 */	U2E_NODEST_COLX,
	/* U+34B5 */	IFX0213(JISX0213_1(0xaed3),	U2E_NODEST_COLX),
	/* U+34B6 */	U2E_NODEST_COLX,
	/* U+34B7 */	U2E_NODEST_COLX,
	/* U+34B8 */	U2E_NODEST_COLX,
	/* U+34B9 */	U2E_NODEST_COLX,
	/* U+34BA */	U2E_NODEST_COLX,
	/* U+34BB */	U2E_NODEST_COLX,
	/* U+34BC */	IFX0213(JISX0213_2(0xa32b),	U2E_NODEST_COLX),
	/* U+34BD */	U2E_NODEST_COLX,
	/* U+34BE */	U2E_NODEST_COLX,
	/* U+34BF */	U2E_NODEST_COLX,
	/* U+34C0 */	U2E_NODEST_COLX,
	/* U+34C1 */	IFX0213(JISX0213_2(0xf468),	U2E_NODEST_COLX),
	/* U+34C2 */	U2E_NODEST_COLX,
	/* U+34C3 */	U2E_NODEST_COLX,
	/* U+34C4 */	U2E_NODEST_COLX,
	/* U+34C5 */	U2E_NODEST_COLX,
	/* U+34C6 */	U2E_NODEST_COLX,
	/* U+34C7 */	IFX0213(JISX0213_2(0xa32f),	U2E_NODEST_COLX),
	/* U+34C8 */	U2E_NODEST_COLX,
	/* U+34C9 */	U2E_NODEST_COLX,
	/* U+34CA */	U2E_NODEST_COLX,
	/* U+34CB */	U2E_NODEST_COLX,
	/* U+34CC */	U2E_NODEST_COLX,
	/* U+34CD */	U2E_NODEST_COLX,
	/* U+34CE */	U2E_NODEST_COLX,
	/* U+34CF */	U2E_NODEST_COLX,
	/* U+34D0 */	U2E_NODEST_COLX,
	/* U+34D1 */	U2E_NODEST_COLX,
	/* U+34D2 */	U2E_NODEST_COLX,
	/* U+34D3 */	U2E_NODEST_COLX,
	/* U+34D4 */	U2E_NODEST_COLX,
	/* U+34D5 */	U2E_NODEST_COLX,
	/* U+34D6 */	U2E_NODEST_COLX,
	/* U+34D7 */	U2E_NODEST_COLX,
	/* U+34D8 */	U2E_NODEST_COLX,
	/* U+34D9 */	U2E_NODEST_COLX,
	/* U+34DA */	U2E_NODEST_COLX,
	/* U+34DB */	IFX0213(JISX0213_1(0xaedb),	U2E_NODEST_COLX),
	/* U+34DC */	U2E_NODEST_COLX,
	/* U+34DD */	U2E_NODEST_COLX,
	/* U+34DE */	U2E_NODEST_COLX,
	/* U+34DF */	U2E_NODEST_COLX,
	/* U+34E0 */	U2E_NODEST_COLX,
	/* U+34E1 */	U2E_NODEST_COLX,
	/* U+34E2 */	U2E_NODEST_COLX,
	/* U+34E3 */	U2E_NODEST_COLX,
	/* U+34E4 */	U2E_NODEST_COLX,
	/* U+34E5 */	U2E_NODEST_COLX,
	/* U+34E6 */	U2E_NODEST_COLX,
	/* U+34E7 */	U2E_NODEST_COLX,
	/* U+34E8 */	U2E_NODEST_COLX,
	/* U+34E9 */	U2E_NODEST_COLX,
	/* U+34EA */	U2E_NODEST_COLX,
	/* U+34EB */	U2E_NODEST_COLX,
	/* U+34EC */	U2E_NODEST_COLX,
	/* U+34ED */	U2E_NODEST_COLX,
	/* U+34EE */	U2E_NODEST_COLX,
	/* U+34EF */	U2E_NODEST_COLX,
	/* U+34F0 */	U2E_NODEST_COLX,
	/* U+34F1 */	U2E_NODEST_COLX,
	/* U+34F2 */	U2E_NODEST_COLX,
	/* U+34F3 */	U2E_NODEST_COLX,
	/* U+34F4 */	U2E_NODEST_COLX,
	/* U+34F5 */	U2E_NODEST_COLX,
	/* U+34F6 */	U2E_NODEST_COLX,
	/* U+34F7 */	U2E_NODEST_COLX,
	/* U+34F8 */	U2E_NODEST_COLX,
	/* U+34F9 */	U2E_NODEST_COLX,
	/* U+34FA */	U2E_NODEST_COLX,
	/* U+34FB */	U2E_NODEST_COLX,
	/* U+34FC */	U2E_NODEST_COLX,
	/* U+34FD */	U2E_NODEST_COLX,
	/* U+34FE */	U2E_NODEST_COLX,
	/* U+34FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_35[] = {
	/* U+3500 */	U2E_NODEST_COLX,
	/* U+3501 */	U2E_NODEST_COLX,
	/* U+3502 */	U2E_NODEST_COLX,
	/* U+3503 */	U2E_NODEST_COLX,
	/* U+3504 */	U2E_NODEST_COLX,
	/* U+3505 */	U2E_NODEST_COLX,
	/* U+3506 */	U2E_NODEST_COLX,
	/* U+3507 */	U2E_NODEST_COLX,
	/* U+3508 */	U2E_NODEST_COLX,
	/* U+3509 */	U2E_NODEST_COLX,
	/* U+350A */	U2E_NODEST_COLX,
	/* U+350B */	U2E_NODEST_COLX,
	/* U+350C */	U2E_NODEST_COLX,
	/* U+350D */	U2E_NODEST_COLX,
	/* U+350E */	U2E_NODEST_COLX,
	/* U+350F */	U2E_NODEST_COLX,
	/* U+3510 */	U2E_NODEST_COLX,
	/* U+3511 */	U2E_NODEST_COLX,
	/* U+3512 */	U2E_NODEST_COLX,
	/* U+3513 */	U2E_NODEST_COLX,
	/* U+3514 */	U2E_NODEST_COLX,
	/* U+3515 */	U2E_NODEST_COLX,
	/* U+3516 */	U2E_NODEST_COLX,
	/* U+3517 */	U2E_NODEST_COLX,
	/* U+3518 */	U2E_NODEST_COLX,
	/* U+3519 */	U2E_NODEST_COLX,
	/* U+351A */	U2E_NODEST_COLX,
	/* U+351B */	U2E_NODEST_COLX,
	/* U+351C */	U2E_NODEST_COLX,
	/* U+351D */	U2E_NODEST_COLX,
	/* U+351E */	U2E_NODEST_COLX,
	/* U+351F */	IFX0213(JISX0213_2(0xa348),	U2E_NODEST_COLX),
	/* U+3520 */	U2E_NODEST_COLX,
	/* U+3521 */	U2E_NODEST_COLX,
	/* U+3522 */	U2E_NODEST_COLX,
	/* U+3523 */	U2E_NODEST_COLX,
	/* U+3524 */	U2E_NODEST_COLX,
	/* U+3525 */	U2E_NODEST_COLX,
	/* U+3526 */	U2E_NODEST_COLX,
	/* U+3527 */	U2E_NODEST_COLX,
	/* U+3528 */	U2E_NODEST_COLX,
	/* U+3529 */	U2E_NODEST_COLX,
	/* U+352A */	U2E_NODEST_COLX,
	/* U+352B */	U2E_NODEST_COLX,
	/* U+352C */	U2E_NODEST_COLX,
	/* U+352D */	U2E_NODEST_COLX,
	/* U+352E */	U2E_NODEST_COLX,
	/* U+352F */	U2E_NODEST_COLX,
	/* U+3530 */	U2E_NODEST_COLX,
	/* U+3531 */	U2E_NODEST_COLX,
	/* U+3532 */	U2E_NODEST_COLX,
	/* U+3533 */	U2E_NODEST_COLX,
	/* U+3534 */	U2E_NODEST_COLX,
	/* U+3535 */	U2E_NODEST_COLX,
	/* U+3536 */	U2E_NODEST_COLX,
	/* U+3537 */	U2E_NODEST_COLX,
	/* U+3538 */	U2E_NODEST_COLX,
	/* U+3539 */	U2E_NODEST_COLX,
	/* U+353A */	U2E_NODEST_COLX,
	/* U+353B */	U2E_NODEST_COLX,
	/* U+353C */	U2E_NODEST_COLX,
	/* U+353D */	U2E_NODEST_COLX,
	/* U+353E */	U2E_NODEST_COLX,
	/* U+353F */	U2E_NODEST_COLX,
	/* U+3540 */	U2E_NODEST_COLX,
	/* U+3541 */	U2E_NODEST_COLX,
	/* U+3542 */	U2E_NODEST_COLX,
	/* U+3543 */	U2E_NODEST_COLX,
	/* U+3544 */	U2E_NODEST_COLX,
	/* U+3545 */	U2E_NODEST_COLX,
	/* U+3546 */	U2E_NODEST_COLX,
	/* U+3547 */	U2E_NODEST_COLX,
	/* U+3548 */	U2E_NODEST_COLX,
	/* U+3549 */	U2E_NODEST_COLX,
	/* U+354A */	U2E_NODEST_COLX,
	/* U+354B */	U2E_NODEST_COLX,
	/* U+354C */	U2E_NODEST_COLX,
	/* U+354D */	U2E_NODEST_COLX,
	/* U+354E */	U2E_NODEST_COLX,
	/* U+354F */	U2E_NODEST_COLX,
	/* U+3550 */	U2E_NODEST_COLX,
	/* U+3551 */	U2E_NODEST_COLX,
	/* U+3552 */	U2E_NODEST_COLX,
	/* U+3553 */	U2E_NODEST_COLX,
	/* U+3554 */	U2E_NODEST_COLX,
	/* U+3555 */	U2E_NODEST_COLX,
	/* U+3556 */	U2E_NODEST_COLX,
	/* U+3557 */	U2E_NODEST_COLX,
	/* U+3558 */	U2E_NODEST_COLX,
	/* U+3559 */	U2E_NODEST_COLX,
	/* U+355A */	U2E_NODEST_COLX,
	/* U+355B */	U2E_NODEST_COLX,
	/* U+355C */	U2E_NODEST_COLX,
	/* U+355D */	IFX0213(JISX0213_2(0xa35d),	U2E_NODEST_COLX),
	/* U+355E */	IFX0213(JISX0213_2(0xa35e),	U2E_NODEST_COLX),
	/* U+355F */	U2E_NODEST_COLX,
	/* U+3560 */	U2E_NODEST_COLX,
	/* U+3561 */	U2E_NODEST_COLX,
	/* U+3562 */	U2E_NODEST_COLX,
	/* U+3563 */	IFX0213(JISX0213_2(0xa361),	U2E_NODEST_COLX),
	/* U+3564 */	U2E_NODEST_COLX,
	/* U+3565 */	U2E_NODEST_COLX,
	/* U+3566 */	U2E_NODEST_COLX,
	/* U+3567 */	U2E_NODEST_COLX,
	/* U+3568 */	U2E_NODEST_COLX,
	/* U+3569 */	U2E_NODEST_COLX,
	/* U+356A */	U2E_NODEST_COLX,
	/* U+356B */	U2E_NODEST_COLX,
	/* U+356C */	U2E_NODEST_COLX,
	/* U+356D */	U2E_NODEST_COLX,
	/* U+356E */	IFX0213(JISX0213_2(0xa367),	U2E_NODEST_COLX),
	/* U+356F */	U2E_NODEST_COLX,
	/* U+3570 */	U2E_NODEST_COLX,
	/* U+3571 */	U2E_NODEST_COLX,
	/* U+3572 */	U2E_NODEST_COLX,
	/* U+3573 */	U2E_NODEST_COLX,
	/* U+3574 */	U2E_NODEST_COLX,
	/* U+3575 */	U2E_NODEST_COLX,
	/* U+3576 */	U2E_NODEST_COLX,
	/* U+3577 */	U2E_NODEST_COLX,
	/* U+3578 */	U2E_NODEST_COLX,
	/* U+3579 */	U2E_NODEST_COLX,
	/* U+357A */	U2E_NODEST_COLX,
	/* U+357B */	U2E_NODEST_COLX,
	/* U+357C */	U2E_NODEST_COLX,
	/* U+357D */	U2E_NODEST_COLX,
	/* U+357E */	U2E_NODEST_COLX,
	/* U+357F */	U2E_NODEST_COLX,
	/* U+3580 */	U2E_NODEST_COLX,
	/* U+3581 */	U2E_NODEST_COLX,
	/* U+3582 */	U2E_NODEST_COLX,
	/* U+3583 */	U2E_NODEST_COLX,
	/* U+3584 */	U2E_NODEST_COLX,
	/* U+3585 */	U2E_NODEST_COLX,
	/* U+3586 */	U2E_NODEST_COLX,
	/* U+3587 */	U2E_NODEST_COLX,
	/* U+3588 */	U2E_NODEST_COLX,
	/* U+3589 */	U2E_NODEST_COLX,
	/* U+358A */	U2E_NODEST_COLX,
	/* U+358B */	U2E_NODEST_COLX,
	/* U+358C */	U2E_NODEST_COLX,
	/* U+358D */	U2E_NODEST_COLX,
	/* U+358E */	U2E_NODEST_COLX,
	/* U+358F */	U2E_NODEST_COLX,
	/* U+3590 */	U2E_NODEST_COLX,
	/* U+3591 */	U2E_NODEST_COLX,
	/* U+3592 */	U2E_NODEST_COLX,
	/* U+3593 */	U2E_NODEST_COLX,
	/* U+3594 */	U2E_NODEST_COLX,
	/* U+3595 */	U2E_NODEST_COLX,
	/* U+3596 */	U2E_NODEST_COLX,
	/* U+3597 */	U2E_NODEST_COLX,
	/* U+3598 */	U2E_NODEST_COLX,
	/* U+3599 */	U2E_NODEST_COLX,
	/* U+359A */	U2E_NODEST_COLX,
	/* U+359B */	U2E_NODEST_COLX,
	/* U+359C */	U2E_NODEST_COLX,
	/* U+359D */	U2E_NODEST_COLX,
	/* U+359E */	U2E_NODEST_COLX,
	/* U+359F */	U2E_NODEST_COLX,
	/* U+35A0 */	U2E_NODEST_COLX,
	/* U+35A1 */	U2E_NODEST_COLX,
	/* U+35A2 */	U2E_NODEST_COLX,
	/* U+35A3 */	U2E_NODEST_COLX,
	/* U+35A4 */	U2E_NODEST_COLX,
	/* U+35A5 */	U2E_NODEST_COLX,
	/* U+35A6 */	IFX0213(JISX0213_2(0xa423),	U2E_NODEST_COLX),
	/* U+35A7 */	U2E_NODEST_COLX,
	/* U+35A8 */	IFX0213(JISX0213_2(0xa426),	U2E_NODEST_COLX),
	/* U+35A9 */	U2E_NODEST_COLX,
	/* U+35AA */	U2E_NODEST_COLX,
	/* U+35AB */	U2E_NODEST_COLX,
	/* U+35AC */	U2E_NODEST_COLX,
	/* U+35AD */	U2E_NODEST_COLX,
	/* U+35AE */	U2E_NODEST_COLX,
	/* U+35AF */	U2E_NODEST_COLX,
	/* U+35B0 */	U2E_NODEST_COLX,
	/* U+35B1 */	U2E_NODEST_COLX,
	/* U+35B2 */	U2E_NODEST_COLX,
	/* U+35B3 */	U2E_NODEST_COLX,
	/* U+35B4 */	U2E_NODEST_COLX,
	/* U+35B5 */	U2E_NODEST_COLX,
	/* U+35B6 */	U2E_NODEST_COLX,
	/* U+35B7 */	U2E_NODEST_COLX,
	/* U+35B8 */	U2E_NODEST_COLX,
	/* U+35B9 */	U2E_NODEST_COLX,
	/* U+35BA */	U2E_NODEST_COLX,
	/* U+35BB */	U2E_NODEST_COLX,
	/* U+35BC */	U2E_NODEST_COLX,
	/* U+35BD */	U2E_NODEST_COLX,
	/* U+35BE */	U2E_NODEST_COLX,
	/* U+35BF */	U2E_NODEST_COLX,
	/* U+35C0 */	U2E_NODEST_COLX,
	/* U+35C1 */	U2E_NODEST_COLX,
	/* U+35C2 */	U2E_NODEST_COLX,
	/* U+35C3 */	U2E_NODEST_COLX,
	/* U+35C4 */	U2E_NODEST_COLX,
	/* U+35C5 */	IFX0213(JISX0213_2(0xa42f),	U2E_NODEST_COLX),
	/* U+35C6 */	U2E_NODEST_COLX,
	/* U+35C7 */	U2E_NODEST_COLX,
	/* U+35C8 */	U2E_NODEST_COLX,
	/* U+35C9 */	U2E_NODEST_COLX,
	/* U+35CA */	U2E_NODEST_COLX,
	/* U+35CB */	U2E_NODEST_COLX,
	/* U+35CC */	U2E_NODEST_COLX,
	/* U+35CD */	U2E_NODEST_COLX,
	/* U+35CE */	U2E_NODEST_COLX,
	/* U+35CF */	U2E_NODEST_COLX,
	/* U+35D0 */	U2E_NODEST_COLX,
	/* U+35D1 */	U2E_NODEST_COLX,
	/* U+35D2 */	U2E_NODEST_COLX,
	/* U+35D3 */	U2E_NODEST_COLX,
	/* U+35D4 */	U2E_NODEST_COLX,
	/* U+35D5 */	U2E_NODEST_COLX,
	/* U+35D6 */	U2E_NODEST_COLX,
	/* U+35D7 */	U2E_NODEST_COLX,
	/* U+35D8 */	U2E_NODEST_COLX,
	/* U+35D9 */	U2E_NODEST_COLX,
	/* U+35DA */	IFX0213(JISX0213_2(0xa438),	U2E_NODEST_COLX),
	/* U+35DB */	U2E_NODEST_COLX,
	/* U+35DC */	U2E_NODEST_COLX,
	/* U+35DD */	U2E_NODEST_COLX,
	/* U+35DE */	U2E_NODEST_COLX,
	/* U+35DF */	U2E_NODEST_COLX,
	/* U+35E0 */	U2E_NODEST_COLX,
	/* U+35E1 */	U2E_NODEST_COLX,
	/* U+35E2 */	U2E_NODEST_COLX,
	/* U+35E3 */	U2E_NODEST_COLX,
	/* U+35E4 */	U2E_NODEST_COLX,
	/* U+35E5 */	U2E_NODEST_COLX,
	/* U+35E6 */	U2E_NODEST_COLX,
	/* U+35E7 */	U2E_NODEST_COLX,
	/* U+35E8 */	U2E_NODEST_COLX,
	/* U+35E9 */	U2E_NODEST_COLX,
	/* U+35EA */	U2E_NODEST_COLX,
	/* U+35EB */	U2E_NODEST_COLX,
	/* U+35EC */	U2E_NODEST_COLX,
	/* U+35ED */	U2E_NODEST_COLX,
	/* U+35EE */	U2E_NODEST_COLX,
	/* U+35EF */	U2E_NODEST_COLX,
	/* U+35F0 */	U2E_NODEST_COLX,
	/* U+35F1 */	U2E_NODEST_COLX,
	/* U+35F2 */	U2E_NODEST_COLX,
	/* U+35F3 */	U2E_NODEST_COLX,
	/* U+35F4 */	IFX0213(JISX0213_2(0xa442),	U2E_NODEST_COLX),
	/* U+35F5 */	U2E_NODEST_COLX,
	/* U+35F6 */	U2E_NODEST_COLX,
	/* U+35F7 */	U2E_NODEST_COLX,
	/* U+35F8 */	U2E_NODEST_COLX,
	/* U+35F9 */	U2E_NODEST_COLX,
	/* U+35FA */	U2E_NODEST_COLX,
	/* U+35FB */	U2E_NODEST_COLX,
	/* U+35FC */	U2E_NODEST_COLX,
	/* U+35FD */	U2E_NODEST_COLX,
	/* U+35FE */	U2E_NODEST_COLX,
	/* U+35FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_36[] = {
	/* U+3600 */	U2E_NODEST_COLX,
	/* U+3601 */	U2E_NODEST_COLX,
	/* U+3602 */	U2E_NODEST_COLX,
	/* U+3603 */	U2E_NODEST_COLX,
	/* U+3604 */	U2E_NODEST_COLX,
	/* U+3605 */	IFX0213(JISX0213_2(0xa44a),	U2E_NODEST_COLX),
	/* U+3606 */	U2E_NODEST_COLX,
	/* U+3607 */	U2E_NODEST_COLX,
	/* U+3608 */	U2E_NODEST_COLX,
	/* U+3609 */	U2E_NODEST_COLX,
	/* U+360A */	U2E_NODEST_COLX,
	/* U+360B */	U2E_NODEST_COLX,
	/* U+360C */	U2E_NODEST_COLX,
	/* U+360D */	U2E_NODEST_COLX,
	/* U+360E */	U2E_NODEST_COLX,
	/* U+360F */	U2E_NODEST_COLX,
	/* U+3610 */	U2E_NODEST_COLX,
	/* U+3611 */	U2E_NODEST_COLX,
	/* U+3612 */	U2E_NODEST_COLX,
	/* U+3613 */	U2E_NODEST_COLX,
	/* U+3614 */	U2E_NODEST_COLX,
	/* U+3615 */	U2E_NODEST_COLX,
	/* U+3616 */	U2E_NODEST_COLX,
	/* U+3617 */	U2E_NODEST_COLX,
	/* U+3618 */	U2E_NODEST_COLX,
	/* U+3619 */	U2E_NODEST_COLX,
	/* U+361A */	U2E_NODEST_COLX,
	/* U+361B */	U2E_NODEST_COLX,
	/* U+361C */	U2E_NODEST_COLX,
	/* U+361D */	U2E_NODEST_COLX,
	/* U+361E */	U2E_NODEST_COLX,
	/* U+361F */	U2E_NODEST_COLX,
	/* U+3620 */	U2E_NODEST_COLX,
	/* U+3621 */	U2E_NODEST_COLX,
	/* U+3622 */	U2E_NODEST_COLX,
	/* U+3623 */	U2E_NODEST_COLX,
	/* U+3624 */	U2E_NODEST_COLX,
	/* U+3625 */	U2E_NODEST_COLX,
	/* U+3626 */	U2E_NODEST_COLX,
	/* U+3627 */	U2E_NODEST_COLX,
	/* U+3628 */	U2E_NODEST_COLX,
	/* U+3629 */	U2E_NODEST_COLX,
	/* U+362A */	U2E_NODEST_COLX,
	/* U+362B */	U2E_NODEST_COLX,
	/* U+362C */	U2E_NODEST_COLX,
	/* U+362D */	U2E_NODEST_COLX,
	/* U+362E */	U2E_NODEST_COLX,
	/* U+362F */	U2E_NODEST_COLX,
	/* U+3630 */	U2E_NODEST_COLX,
	/* U+3631 */	U2E_NODEST_COLX,
	/* U+3632 */	U2E_NODEST_COLX,
	/* U+3633 */	U2E_NODEST_COLX,
	/* U+3634 */	U2E_NODEST_COLX,
	/* U+3635 */	U2E_NODEST_COLX,
	/* U+3636 */	U2E_NODEST_COLX,
	/* U+3637 */	U2E_NODEST_COLX,
	/* U+3638 */	U2E_NODEST_COLX,
	/* U+3639 */	U2E_NODEST_COLX,
	/* U+363A */	U2E_NODEST_COLX,
	/* U+363B */	U2E_NODEST_COLX,
	/* U+363C */	U2E_NODEST_COLX,
	/* U+363D */	U2E_NODEST_COLX,
	/* U+363E */	U2E_NODEST_COLX,
	/* U+363F */	U2E_NODEST_COLX,
	/* U+3640 */	U2E_NODEST_COLX,
	/* U+3641 */	U2E_NODEST_COLX,
	/* U+3642 */	U2E_NODEST_COLX,
	/* U+3643 */	U2E_NODEST_COLX,
	/* U+3644 */	U2E_NODEST_COLX,
	/* U+3645 */	U2E_NODEST_COLX,
	/* U+3646 */	U2E_NODEST_COLX,
	/* U+3647 */	U2E_NODEST_COLX,
	/* U+3648 */	U2E_NODEST_COLX,
	/* U+3649 */	U2E_NODEST_COLX,
	/* U+364A */	IFX0213(JISX0213_2(0xa479),	U2E_NODEST_COLX),
	/* U+364B */	U2E_NODEST_COLX,
	/* U+364C */	U2E_NODEST_COLX,
	/* U+364D */	U2E_NODEST_COLX,
	/* U+364E */	U2E_NODEST_COLX,
	/* U+364F */	U2E_NODEST_COLX,
	/* U+3650 */	U2E_NODEST_COLX,
	/* U+3651 */	U2E_NODEST_COLX,
	/* U+3652 */	U2E_NODEST_COLX,
	/* U+3653 */	U2E_NODEST_COLX,
	/* U+3654 */	U2E_NODEST_COLX,
	/* U+3655 */	U2E_NODEST_COLX,
	/* U+3656 */	U2E_NODEST_COLX,
	/* U+3657 */	U2E_NODEST_COLX,
	/* U+3658 */	U2E_NODEST_COLX,
	/* U+3659 */	U2E_NODEST_COLX,
	/* U+365A */	U2E_NODEST_COLX,
	/* U+365B */	U2E_NODEST_COLX,
	/* U+365C */	U2E_NODEST_COLX,
	/* U+365D */	U2E_NODEST_COLX,
	/* U+365E */	U2E_NODEST_COLX,
	/* U+365F */	U2E_NODEST_COLX,
	/* U+3660 */	U2E_NODEST_COLX,
	/* U+3661 */	U2E_NODEST_COLX,
	/* U+3662 */	U2E_NODEST_COLX,
	/* U+3663 */	U2E_NODEST_COLX,
	/* U+3664 */	U2E_NODEST_COLX,
	/* U+3665 */	U2E_NODEST_COLX,
	/* U+3666 */	U2E_NODEST_COLX,
	/* U+3667 */	U2E_NODEST_COLX,
	/* U+3668 */	U2E_NODEST_COLX,
	/* U+3669 */	U2E_NODEST_COLX,
	/* U+366A */	U2E_NODEST_COLX,
	/* U+366B */	U2E_NODEST_COLX,
	/* U+366C */	U2E_NODEST_COLX,
	/* U+366D */	U2E_NODEST_COLX,
	/* U+366E */	U2E_NODEST_COLX,
	/* U+366F */	U2E_NODEST_COLX,
	/* U+3670 */	U2E_NODEST_COLX,
	/* U+3671 */	U2E_NODEST_COLX,
	/* U+3672 */	U2E_NODEST_COLX,
	/* U+3673 */	U2E_NODEST_COLX,
	/* U+3674 */	U2E_NODEST_COLX,
	/* U+3675 */	U2E_NODEST_COLX,
	/* U+3676 */	U2E_NODEST_COLX,
	/* U+3677 */	U2E_NODEST_COLX,
	/* U+3678 */	U2E_NODEST_COLX,
	/* U+3679 */	U2E_NODEST_COLX,
	/* U+367A */	U2E_NODEST_COLX,
	/* U+367B */	U2E_NODEST_COLX,
	/* U+367C */	U2E_NODEST_COLX,
	/* U+367D */	U2E_NODEST_COLX,
	/* U+367E */	U2E_NODEST_COLX,
	/* U+367F */	U2E_NODEST_COLX,
	/* U+3680 */	U2E_NODEST_COLX,
	/* U+3681 */	U2E_NODEST_COLX,
	/* U+3682 */	U2E_NODEST_COLX,
	/* U+3683 */	U2E_NODEST_COLX,
	/* U+3684 */	U2E_NODEST_COLX,
	/* U+3685 */	U2E_NODEST_COLX,
	/* U+3686 */	U2E_NODEST_COLX,
	/* U+3687 */	U2E_NODEST_COLX,
	/* U+3688 */	U2E_NODEST_COLX,
	/* U+3689 */	U2E_NODEST_COLX,
	/* U+368A */	U2E_NODEST_COLX,
	/* U+368B */	U2E_NODEST_COLX,
	/* U+368C */	U2E_NODEST_COLX,
	/* U+368D */	U2E_NODEST_COLX,
	/* U+368E */	U2E_NODEST_COLX,
	/* U+368F */	U2E_NODEST_COLX,
	/* U+3690 */	U2E_NODEST_COLX,
	/* U+3691 */	IFX0213(JISX0213_2(0xa53f),	U2E_NODEST_COLX),
	/* U+3692 */	U2E_NODEST_COLX,
	/* U+3693 */	U2E_NODEST_COLX,
	/* U+3694 */	U2E_NODEST_COLX,
	/* U+3695 */	U2E_NODEST_COLX,
	/* U+3696 */	IFX0213(JISX0213_2(0xa543),	U2E_NODEST_COLX),
	/* U+3697 */	U2E_NODEST_COLX,
	/* U+3698 */	U2E_NODEST_COLX,
	/* U+3699 */	IFX0213(JISX0213_2(0xa541),	U2E_NODEST_COLX),
	/* U+369A */	U2E_NODEST_COLX,
	/* U+369B */	U2E_NODEST_COLX,
	/* U+369C */	U2E_NODEST_COLX,
	/* U+369D */	U2E_NODEST_COLX,
	/* U+369E */	U2E_NODEST_COLX,
	/* U+369F */	U2E_NODEST_COLX,
	/* U+36A0 */	U2E_NODEST_COLX,
	/* U+36A1 */	U2E_NODEST_COLX,
	/* U+36A2 */	U2E_NODEST_COLX,
	/* U+36A3 */	U2E_NODEST_COLX,
	/* U+36A4 */	U2E_NODEST_COLX,
	/* U+36A5 */	U2E_NODEST_COLX,
	/* U+36A6 */	U2E_NODEST_COLX,
	/* U+36A7 */	U2E_NODEST_COLX,
	/* U+36A8 */	U2E_NODEST_COLX,
	/* U+36A9 */	U2E_NODEST_COLX,
	/* U+36AA */	U2E_NODEST_COLX,
	/* U+36AB */	U2E_NODEST_COLX,
	/* U+36AC */	U2E_NODEST_COLX,
	/* U+36AD */	U2E_NODEST_COLX,
	/* U+36AE */	U2E_NODEST_COLX,
	/* U+36AF */	U2E_NODEST_COLX,
	/* U+36B0 */	U2E_NODEST_COLX,
	/* U+36B1 */	U2E_NODEST_COLX,
	/* U+36B2 */	U2E_NODEST_COLX,
	/* U+36B3 */	U2E_NODEST_COLX,
	/* U+36B4 */	U2E_NODEST_COLX,
	/* U+36B5 */	U2E_NODEST_COLX,
	/* U+36B6 */	U2E_NODEST_COLX,
	/* U+36B7 */	U2E_NODEST_COLX,
	/* U+36B8 */	U2E_NODEST_COLX,
	/* U+36B9 */	U2E_NODEST_COLX,
	/* U+36BA */	U2E_NODEST_COLX,
	/* U+36BB */	U2E_NODEST_COLX,
	/* U+36BC */	U2E_NODEST_COLX,
	/* U+36BD */	U2E_NODEST_COLX,
	/* U+36BE */	U2E_NODEST_COLX,
	/* U+36BF */	U2E_NODEST_COLX,
	/* U+36C0 */	U2E_NODEST_COLX,
	/* U+36C1 */	U2E_NODEST_COLX,
	/* U+36C2 */	U2E_NODEST_COLX,
	/* U+36C3 */	U2E_NODEST_COLX,
	/* U+36C4 */	U2E_NODEST_COLX,
	/* U+36C5 */	U2E_NODEST_COLX,
	/* U+36C6 */	U2E_NODEST_COLX,
	/* U+36C7 */	U2E_NODEST_COLX,
	/* U+36C8 */	U2E_NODEST_COLX,
	/* U+36C9 */	U2E_NODEST_COLX,
	/* U+36CA */	U2E_NODEST_COLX,
	/* U+36CB */	U2E_NODEST_COLX,
	/* U+36CC */	U2E_NODEST_COLX,
	/* U+36CD */	U2E_NODEST_COLX,
	/* U+36CE */	U2E_NODEST_COLX,
	/* U+36CF */	IFX0213(JISX0213_2(0xa557),	U2E_NODEST_COLX),
	/* U+36D0 */	U2E_NODEST_COLX,
	/* U+36D1 */	U2E_NODEST_COLX,
	/* U+36D2 */	U2E_NODEST_COLX,
	/* U+36D3 */	U2E_NODEST_COLX,
	/* U+36D4 */	U2E_NODEST_COLX,
	/* U+36D5 */	U2E_NODEST_COLX,
	/* U+36D6 */	U2E_NODEST_COLX,
	/* U+36D7 */	U2E_NODEST_COLX,
	/* U+36D8 */	U2E_NODEST_COLX,
	/* U+36D9 */	U2E_NODEST_COLX,
	/* U+36DA */	U2E_NODEST_COLX,
	/* U+36DB */	U2E_NODEST_COLX,
	/* U+36DC */	U2E_NODEST_COLX,
	/* U+36DD */	U2E_NODEST_COLX,
	/* U+36DE */	U2E_NODEST_COLX,
	/* U+36DF */	U2E_NODEST_COLX,
	/* U+36E0 */	U2E_NODEST_COLX,
	/* U+36E1 */	U2E_NODEST_COLX,
	/* U+36E2 */	U2E_NODEST_COLX,
	/* U+36E3 */	U2E_NODEST_COLX,
	/* U+36E4 */	U2E_NODEST_COLX,
	/* U+36E5 */	U2E_NODEST_COLX,
	/* U+36E6 */	U2E_NODEST_COLX,
	/* U+36E7 */	U2E_NODEST_COLX,
	/* U+36E8 */	U2E_NODEST_COLX,
	/* U+36E9 */	U2E_NODEST_COLX,
	/* U+36EA */	U2E_NODEST_COLX,
	/* U+36EB */	U2E_NODEST_COLX,
	/* U+36EC */	U2E_NODEST_COLX,
	/* U+36ED */	U2E_NODEST_COLX,
	/* U+36EE */	U2E_NODEST_COLX,
	/* U+36EF */	U2E_NODEST_COLX,
	/* U+36F0 */	U2E_NODEST_COLX,
	/* U+36F1 */	U2E_NODEST_COLX,
	/* U+36F2 */	U2E_NODEST_COLX,
	/* U+36F3 */	U2E_NODEST_COLX,
	/* U+36F4 */	U2E_NODEST_COLX,
	/* U+36F5 */	U2E_NODEST_COLX,
	/* U+36F6 */	U2E_NODEST_COLX,
	/* U+36F7 */	U2E_NODEST_COLX,
	/* U+36F8 */	U2E_NODEST_COLX,
	/* U+36F9 */	U2E_NODEST_COLX,
	/* U+36FA */	U2E_NODEST_COLX,
	/* U+36FB */	U2E_NODEST_COLX,
	/* U+36FC */	U2E_NODEST_COLX,
	/* U+36FD */	U2E_NODEST_COLX,
	/* U+36FE */	U2E_NODEST_COLX,
	/* U+36FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_37[] = {
	/* U+3700 */	U2E_NODEST_COLX,
	/* U+3701 */	U2E_NODEST_COLX,
	/* U+3702 */	U2E_NODEST_COLX,
	/* U+3703 */	U2E_NODEST_COLX,
	/* U+3704 */	U2E_NODEST_COLX,
	/* U+3705 */	U2E_NODEST_COLX,
	/* U+3706 */	U2E_NODEST_COLX,
	/* U+3707 */	U2E_NODEST_COLX,
	/* U+3708 */	U2E_NODEST_COLX,
	/* U+3709 */	U2E_NODEST_COLX,
	/* U+370A */	U2E_NODEST_COLX,
	/* U+370B */	U2E_NODEST_COLX,
	/* U+370C */	U2E_NODEST_COLX,
	/* U+370D */	U2E_NODEST_COLX,
	/* U+370E */	U2E_NODEST_COLX,
	/* U+370F */	U2E_NODEST_COLX,
	/* U+3710 */	U2E_NODEST_COLX,
	/* U+3711 */	U2E_NODEST_COLX,
	/* U+3712 */	U2E_NODEST_COLX,
	/* U+3713 */	U2E_NODEST_COLX,
	/* U+3714 */	U2E_NODEST_COLX,
	/* U+3715 */	U2E_NODEST_COLX,
	/* U+3716 */	U2E_NODEST_COLX,
	/* U+3717 */	U2E_NODEST_COLX,
	/* U+3718 */	U2E_NODEST_COLX,
	/* U+3719 */	U2E_NODEST_COLX,
	/* U+371A */	U2E_NODEST_COLX,
	/* U+371B */	U2E_NODEST_COLX,
	/* U+371C */	U2E_NODEST_COLX,
	/* U+371D */	U2E_NODEST_COLX,
	/* U+371E */	U2E_NODEST_COLX,
	/* U+371F */	U2E_NODEST_COLX,
	/* U+3720 */	U2E_NODEST_COLX,
	/* U+3721 */	U2E_NODEST_COLX,
	/* U+3722 */	U2E_NODEST_COLX,
	/* U+3723 */	U2E_NODEST_COLX,
	/* U+3724 */	U2E_NODEST_COLX,
	/* U+3725 */	U2E_NODEST_COLX,
	/* U+3726 */	U2E_NODEST_COLX,
	/* U+3727 */	U2E_NODEST_COLX,
	/* U+3728 */	U2E_NODEST_COLX,
	/* U+3729 */	U2E_NODEST_COLX,
	/* U+372A */	U2E_NODEST_COLX,
	/* U+372B */	U2E_NODEST_COLX,
	/* U+372C */	U2E_NODEST_COLX,
	/* U+372D */	U2E_NODEST_COLX,
	/* U+372E */	U2E_NODEST_COLX,
	/* U+372F */	U2E_NODEST_COLX,
	/* U+3730 */	U2E_NODEST_COLX,
	/* U+3731 */	U2E_NODEST_COLX,
	/* U+3732 */	U2E_NODEST_COLX,
	/* U+3733 */	U2E_NODEST_COLX,
	/* U+3734 */	U2E_NODEST_COLX,
	/* U+3735 */	U2E_NODEST_COLX,
	/* U+3736 */	U2E_NODEST_COLX,
	/* U+3737 */	U2E_NODEST_COLX,
	/* U+3738 */	U2E_NODEST_COLX,
	/* U+3739 */	U2E_NODEST_COLX,
	/* U+373A */	U2E_NODEST_COLX,
	/* U+373B */	U2E_NODEST_COLX,
	/* U+373C */	U2E_NODEST_COLX,
	/* U+373D */	U2E_NODEST_COLX,
	/* U+373E */	U2E_NODEST_COLX,
	/* U+373F */	U2E_NODEST_COLX,
	/* U+3740 */	U2E_NODEST_COLX,
	/* U+3741 */	U2E_NODEST_COLX,
	/* U+3742 */	U2E_NODEST_COLX,
	/* U+3743 */	U2E_NODEST_COLX,
	/* U+3744 */	U2E_NODEST_COLX,
	/* U+3745 */	U2E_NODEST_COLX,
	/* U+3746 */	U2E_NODEST_COLX,
	/* U+3747 */	U2E_NODEST_COLX,
	/* U+3748 */	U2E_NODEST_COLX,
	/* U+3749 */	U2E_NODEST_COLX,
	/* U+374A */	U2E_NODEST_COLX,
	/* U+374B */	U2E_NODEST_COLX,
	/* U+374C */	U2E_NODEST_COLX,
	/* U+374D */	U2E_NODEST_COLX,
	/* U+374E */	U2E_NODEST_COLX,
	/* U+374F */	U2E_NODEST_COLX,
	/* U+3750 */	U2E_NODEST_COLX,
	/* U+3751 */	U2E_NODEST_COLX,
	/* U+3752 */	U2E_NODEST_COLX,
	/* U+3753 */	U2E_NODEST_COLX,
	/* U+3754 */	U2E_NODEST_COLX,
	/* U+3755 */	U2E_NODEST_COLX,
	/* U+3756 */	U2E_NODEST_COLX,
	/* U+3757 */	U2E_NODEST_COLX,
	/* U+3758 */	U2E_NODEST_COLX,
	/* U+3759 */	U2E_NODEST_COLX,
	/* U+375A */	U2E_NODEST_COLX,
	/* U+375B */	U2E_NODEST_COLX,
	/* U+375C */	U2E_NODEST_COLX,
	/* U+375D */	U2E_NODEST_COLX,
	/* U+375E */	U2E_NODEST_COLX,
	/* U+375F */	U2E_NODEST_COLX,
	/* U+3760 */	U2E_NODEST_COLX,
	/* U+3761 */	IFX0213(JISX0213_2(0xa823),	U2E_NODEST_COLX),
	/* U+3762 */	IFX0213(JISX0213_2(0xa825),	U2E_NODEST_COLX),
	/* U+3763 */	U2E_NODEST_COLX,
	/* U+3764 */	U2E_NODEST_COLX,
	/* U+3765 */	U2E_NODEST_COLX,
	/* U+3766 */	U2E_NODEST_COLX,
	/* U+3767 */	U2E_NODEST_COLX,
	/* U+3768 */	U2E_NODEST_COLX,
	/* U+3769 */	U2E_NODEST_COLX,
	/* U+376A */	U2E_NODEST_COLX,
	/* U+376B */	IFX0213(JISX0213_2(0xa829),	U2E_NODEST_COLX),
	/* U+376C */	IFX0213(JISX0213_2(0xa828),	U2E_NODEST_COLX),
	/* U+376D */	U2E_NODEST_COLX,
	/* U+376E */	U2E_NODEST_COLX,
	/* U+376F */	U2E_NODEST_COLX,
	/* U+3770 */	U2E_NODEST_COLX,
	/* U+3771 */	U2E_NODEST_COLX,
	/* U+3772 */	U2E_NODEST_COLX,
	/* U+3773 */	U2E_NODEST_COLX,
	/* U+3774 */	U2E_NODEST_COLX,
	/* U+3775 */	IFX0213(JISX0213_2(0xa82c),	U2E_NODEST_COLX),
	/* U+3776 */	U2E_NODEST_COLX,
	/* U+3777 */	U2E_NODEST_COLX,
	/* U+3778 */	U2E_NODEST_COLX,
	/* U+3779 */	U2E_NODEST_COLX,
	/* U+377A */	U2E_NODEST_COLX,
	/* U+377B */	U2E_NODEST_COLX,
	/* U+377C */	U2E_NODEST_COLX,
	/* U+377D */	U2E_NODEST_COLX,
	/* U+377E */	U2E_NODEST_COLX,
	/* U+377F */	U2E_NODEST_COLX,
	/* U+3780 */	U2E_NODEST_COLX,
	/* U+3781 */	U2E_NODEST_COLX,
	/* U+3782 */	U2E_NODEST_COLX,
	/* U+3783 */	U2E_NODEST_COLX,
	/* U+3784 */	U2E_NODEST_COLX,
	/* U+3785 */	U2E_NODEST_COLX,
	/* U+3786 */	U2E_NODEST_COLX,
	/* U+3787 */	U2E_NODEST_COLX,
	/* U+3788 */	U2E_NODEST_COLX,
	/* U+3789 */	U2E_NODEST_COLX,
	/* U+378A */	U2E_NODEST_COLX,
	/* U+378B */	U2E_NODEST_COLX,
	/* U+378C */	U2E_NODEST_COLX,
	/* U+378D */	IFX0213(JISX0213_1(0xcfdf),	U2E_NODEST_COLX),
	/* U+378E */	U2E_NODEST_COLX,
	/* U+378F */	U2E_NODEST_COLX,
	/* U+3790 */	U2E_NODEST_COLX,
	/* U+3791 */	U2E_NODEST_COLX,
	/* U+3792 */	U2E_NODEST_COLX,
	/* U+3793 */	U2E_NODEST_COLX,
	/* U+3794 */	U2E_NODEST_COLX,
	/* U+3795 */	U2E_NODEST_COLX,
	/* U+3796 */	U2E_NODEST_COLX,
	/* U+3797 */	U2E_NODEST_COLX,
	/* U+3798 */	U2E_NODEST_COLX,
	/* U+3799 */	U2E_NODEST_COLX,
	/* U+379A */	U2E_NODEST_COLX,
	/* U+379B */	U2E_NODEST_COLX,
	/* U+379C */	U2E_NODEST_COLX,
	/* U+379D */	U2E_NODEST_COLX,
	/* U+379E */	U2E_NODEST_COLX,
	/* U+379F */	U2E_NODEST_COLX,
	/* U+37A0 */	U2E_NODEST_COLX,
	/* U+37A1 */	U2E_NODEST_COLX,
	/* U+37A2 */	U2E_NODEST_COLX,
	/* U+37A3 */	U2E_NODEST_COLX,
	/* U+37A4 */	U2E_NODEST_COLX,
	/* U+37A5 */	U2E_NODEST_COLX,
	/* U+37A6 */	U2E_NODEST_COLX,
	/* U+37A7 */	U2E_NODEST_COLX,
	/* U+37A8 */	U2E_NODEST_COLX,
	/* U+37A9 */	U2E_NODEST_COLX,
	/* U+37AA */	U2E_NODEST_COLX,
	/* U+37AB */	U2E_NODEST_COLX,
	/* U+37AC */	U2E_NODEST_COLX,
	/* U+37AD */	U2E_NODEST_COLX,
	/* U+37AE */	U2E_NODEST_COLX,
	/* U+37AF */	U2E_NODEST_COLX,
	/* U+37B0 */	U2E_NODEST_COLX,
	/* U+37B1 */	U2E_NODEST_COLX,
	/* U+37B2 */	U2E_NODEST_COLX,
	/* U+37B3 */	U2E_NODEST_COLX,
	/* U+37B4 */	U2E_NODEST_COLX,
	/* U+37B5 */	U2E_NODEST_COLX,
	/* U+37B6 */	U2E_NODEST_COLX,
	/* U+37B7 */	U2E_NODEST_COLX,
	/* U+37B8 */	U2E_NODEST_COLX,
	/* U+37B9 */	U2E_NODEST_COLX,
	/* U+37BA */	U2E_NODEST_COLX,
	/* U+37BB */	U2E_NODEST_COLX,
	/* U+37BC */	U2E_NODEST_COLX,
	/* U+37BD */	U2E_NODEST_COLX,
	/* U+37BE */	U2E_NODEST_COLX,
	/* U+37BF */	U2E_NODEST_COLX,
	/* U+37C0 */	U2E_NODEST_COLX,
	/* U+37C1 */	IFX0213(JISX0213_2(0xa83e),	U2E_NODEST_COLX),
	/* U+37C2 */	U2E_NODEST_COLX,
	/* U+37C3 */	U2E_NODEST_COLX,
	/* U+37C4 */	U2E_NODEST_COLX,
	/* U+37C5 */	U2E_NODEST_COLX,
	/* U+37C6 */	U2E_NODEST_COLX,
	/* U+37C7 */	U2E_NODEST_COLX,
	/* U+37C8 */	U2E_NODEST_COLX,
	/* U+37C9 */	U2E_NODEST_COLX,
	/* U+37CA */	U2E_NODEST_COLX,
	/* U+37CB */	U2E_NODEST_COLX,
	/* U+37CC */	U2E_NODEST_COLX,
	/* U+37CD */	U2E_NODEST_COLX,
	/* U+37CE */	U2E_NODEST_COLX,
	/* U+37CF */	U2E_NODEST_COLX,
	/* U+37D0 */	U2E_NODEST_COLX,
	/* U+37D1 */	U2E_NODEST_COLX,
	/* U+37D2 */	U2E_NODEST_COLX,
	/* U+37D3 */	U2E_NODEST_COLX,
	/* U+37D4 */	U2E_NODEST_COLX,
	/* U+37D5 */	U2E_NODEST_COLX,
	/* U+37D6 */	U2E_NODEST_COLX,
	/* U+37D7 */	U2E_NODEST_COLX,
	/* U+37D8 */	U2E_NODEST_COLX,
	/* U+37D9 */	U2E_NODEST_COLX,
	/* U+37DA */	U2E_NODEST_COLX,
	/* U+37DB */	U2E_NODEST_COLX,
	/* U+37DC */	U2E_NODEST_COLX,
	/* U+37DD */	U2E_NODEST_COLX,
	/* U+37DE */	U2E_NODEST_COLX,
	/* U+37DF */	U2E_NODEST_COLX,
	/* U+37E0 */	U2E_NODEST_COLX,
	/* U+37E1 */	U2E_NODEST_COLX,
	/* U+37E2 */	IFX0213(JISX0213_1(0xcfef),	U2E_NODEST_COLX),
	/* U+37E3 */	U2E_NODEST_COLX,
	/* U+37E4 */	U2E_NODEST_COLX,
	/* U+37E5 */	U2E_NODEST_COLX,
	/* U+37E6 */	U2E_NODEST_COLX,
	/* U+37E7 */	U2E_NODEST_COLX,
	/* U+37E8 */	IFX0213(JISX0213_2(0xa856),	U2E_NODEST_COLX),
	/* U+37E9 */	U2E_NODEST_COLX,
	/* U+37EA */	U2E_NODEST_COLX,
	/* U+37EB */	U2E_NODEST_COLX,
	/* U+37EC */	U2E_NODEST_COLX,
	/* U+37ED */	U2E_NODEST_COLX,
	/* U+37EE */	U2E_NODEST_COLX,
	/* U+37EF */	U2E_NODEST_COLX,
	/* U+37F0 */	U2E_NODEST_COLX,
	/* U+37F1 */	U2E_NODEST_COLX,
	/* U+37F2 */	U2E_NODEST_COLX,
	/* U+37F3 */	U2E_NODEST_COLX,
	/* U+37F4 */	IFX0213(JISX0213_2(0xa859),	U2E_NODEST_COLX),
	/* U+37F5 */	U2E_NODEST_COLX,
	/* U+37F6 */	U2E_NODEST_COLX,
	/* U+37F7 */	U2E_NODEST_COLX,
	/* U+37F8 */	U2E_NODEST_COLX,
	/* U+37F9 */	U2E_NODEST_COLX,
	/* U+37FA */	U2E_NODEST_COLX,
	/* U+37FB */	U2E_NODEST_COLX,
	/* U+37FC */	U2E_NODEST_COLX,
	/* U+37FD */	IFX0213(JISX0213_2(0xa85c),	U2E_NODEST_COLX),
	/* U+37FE */	U2E_NODEST_COLX,
	/* U+37FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_38[] = {
	/* U+3800 */	IFX0213(JISX0213_2(0xa85e),	U2E_NODEST_COLX),
	/* U+3801 */	U2E_NODEST_COLX,
	/* U+3802 */	U2E_NODEST_COLX,
	/* U+3803 */	U2E_NODEST_COLX,
	/* U+3804 */	U2E_NODEST_COLX,
	/* U+3805 */	U2E_NODEST_COLX,
	/* U+3806 */	U2E_NODEST_COLX,
	/* U+3807 */	U2E_NODEST_COLX,
	/* U+3808 */	U2E_NODEST_COLX,
	/* U+3809 */	U2E_NODEST_COLX,
	/* U+380A */	U2E_NODEST_COLX,
	/* U+380B */	U2E_NODEST_COLX,
	/* U+380C */	U2E_NODEST_COLX,
	/* U+380D */	U2E_NODEST_COLX,
	/* U+380E */	U2E_NODEST_COLX,
	/* U+380F */	U2E_NODEST_COLX,
	/* U+3810 */	U2E_NODEST_COLX,
	/* U+3811 */	U2E_NODEST_COLX,
	/* U+3812 */	U2E_NODEST_COLX,
	/* U+3813 */	U2E_NODEST_COLX,
	/* U+3814 */	U2E_NODEST_COLX,
	/* U+3815 */	U2E_NODEST_COLX,
	/* U+3816 */	U2E_NODEST_COLX,
	/* U+3817 */	U2E_NODEST_COLX,
	/* U+3818 */	U2E_NODEST_COLX,
	/* U+3819 */	U2E_NODEST_COLX,
	/* U+381A */	U2E_NODEST_COLX,
	/* U+381B */	U2E_NODEST_COLX,
	/* U+381C */	U2E_NODEST_COLX,
	/* U+381D */	U2E_NODEST_COLX,
	/* U+381E */	U2E_NODEST_COLX,
	/* U+381F */	U2E_NODEST_COLX,
	/* U+3820 */	U2E_NODEST_COLX,
	/* U+3821 */	U2E_NODEST_COLX,
	/* U+3822 */	U2E_NODEST_COLX,
	/* U+3823 */	U2E_NODEST_COLX,
	/* U+3824 */	U2E_NODEST_COLX,
	/* U+3825 */	U2E_NODEST_COLX,
	/* U+3826 */	U2E_NODEST_COLX,
	/* U+3827 */	U2E_NODEST_COLX,
	/* U+3828 */	U2E_NODEST_COLX,
	/* U+3829 */	U2E_NODEST_COLX,
	/* U+382A */	U2E_NODEST_COLX,
	/* U+382B */	U2E_NODEST_COLX,
	/* U+382C */	U2E_NODEST_COLX,
	/* U+382D */	U2E_NODEST_COLX,
	/* U+382E */	U2E_NODEST_COLX,
	/* U+382F */	IFX0213(JISX0213_2(0xa86f),	U2E_NODEST_COLX),
	/* U+3830 */	U2E_NODEST_COLX,
	/* U+3831 */	U2E_NODEST_COLX,
	/* U+3832 */	U2E_NODEST_COLX,
	/* U+3833 */	U2E_NODEST_COLX,
	/* U+3834 */	U2E_NODEST_COLX,
	/* U+3835 */	U2E_NODEST_COLX,
	/* U+3836 */	IFX0213(JISX0213_2(0xa871),	U2E_NODEST_COLX),
	/* U+3837 */	U2E_NODEST_COLX,
	/* U+3838 */	U2E_NODEST_COLX,
	/* U+3839 */	U2E_NODEST_COLX,
	/* U+383A */	U2E_NODEST_COLX,
	/* U+383B */	U2E_NODEST_COLX,
	/* U+383C */	U2E_NODEST_COLX,
	/* U+383D */	U2E_NODEST_COLX,
	/* U+383E */	U2E_NODEST_COLX,
	/* U+383F */	U2E_NODEST_COLX,
	/* U+3840 */	IFX0213(JISX0213_2(0xa874),	U2E_NODEST_COLX),
	/* U+3841 */	U2E_NODEST_COLX,
	/* U+3842 */	U2E_NODEST_COLX,
	/* U+3843 */	U2E_NODEST_COLX,
	/* U+3844 */	U2E_NODEST_COLX,
	/* U+3845 */	U2E_NODEST_COLX,
	/* U+3846 */	U2E_NODEST_COLX,
	/* U+3847 */	U2E_NODEST_COLX,
	/* U+3848 */	U2E_NODEST_COLX,
	/* U+3849 */	U2E_NODEST_COLX,
	/* U+384A */	U2E_NODEST_COLX,
	/* U+384B */	U2E_NODEST_COLX,
	/* U+384C */	U2E_NODEST_COLX,
	/* U+384D */	U2E_NODEST_COLX,
	/* U+384E */	U2E_NODEST_COLX,
	/* U+384F */	U2E_NODEST_COLX,
	/* U+3850 */	U2E_NODEST_COLX,
	/* U+3851 */	U2E_NODEST_COLX,
	/* U+3852 */	U2E_NODEST_COLX,
	/* U+3853 */	U2E_NODEST_COLX,
	/* U+3854 */	U2E_NODEST_COLX,
	/* U+3855 */	U2E_NODEST_COLX,
	/* U+3856 */	U2E_NODEST_COLX,
	/* U+3857 */	U2E_NODEST_COLX,
	/* U+3858 */	U2E_NODEST_COLX,
	/* U+3859 */	U2E_NODEST_COLX,
	/* U+385A */	U2E_NODEST_COLX,
	/* U+385B */	U2E_NODEST_COLX,
	/* U+385C */	IFX0213(JISX0213_2(0xa879),	U2E_NODEST_COLX),
	/* U+385D */	U2E_NODEST_COLX,
	/* U+385E */	U2E_NODEST_COLX,
	/* U+385F */	U2E_NODEST_COLX,
	/* U+3860 */	U2E_NODEST_COLX,
	/* U+3861 */	IFX0213(JISX0213_2(0xa87b),	U2E_NODEST_COLX),
	/* U+3862 */	U2E_NODEST_COLX,
	/* U+3863 */	U2E_NODEST_COLX,
	/* U+3864 */	U2E_NODEST_COLX,
	/* U+3865 */	U2E_NODEST_COLX,
	/* U+3866 */	U2E_NODEST_COLX,
	/* U+3867 */	U2E_NODEST_COLX,
	/* U+3868 */	U2E_NODEST_COLX,
	/* U+3869 */	U2E_NODEST_COLX,
	/* U+386A */	U2E_NODEST_COLX,
	/* U+386B */	U2E_NODEST_COLX,
	/* U+386C */	U2E_NODEST_COLX,
	/* U+386D */	U2E_NODEST_COLX,
	/* U+386E */	U2E_NODEST_COLX,
	/* U+386F */	U2E_NODEST_COLX,
	/* U+3870 */	U2E_NODEST_COLX,
	/* U+3871 */	U2E_NODEST_COLX,
	/* U+3872 */	U2E_NODEST_COLX,
	/* U+3873 */	U2E_NODEST_COLX,
	/* U+3874 */	U2E_NODEST_COLX,
	/* U+3875 */	U2E_NODEST_COLX,
	/* U+3876 */	U2E_NODEST_COLX,
	/* U+3877 */	U2E_NODEST_COLX,
	/* U+3878 */	U2E_NODEST_COLX,
	/* U+3879 */	U2E_NODEST_COLX,
	/* U+387A */	U2E_NODEST_COLX,
	/* U+387B */	U2E_NODEST_COLX,
	/* U+387C */	U2E_NODEST_COLX,
	/* U+387D */	U2E_NODEST_COLX,
	/* U+387E */	U2E_NODEST_COLX,
	/* U+387F */	U2E_NODEST_COLX,
	/* U+3880 */	U2E_NODEST_COLX,
	/* U+3881 */	U2E_NODEST_COLX,
	/* U+3882 */	U2E_NODEST_COLX,
	/* U+3883 */	U2E_NODEST_COLX,
	/* U+3884 */	U2E_NODEST_COLX,
	/* U+3885 */	U2E_NODEST_COLX,
	/* U+3886 */	U2E_NODEST_COLX,
	/* U+3887 */	U2E_NODEST_COLX,
	/* U+3888 */	U2E_NODEST_COLX,
	/* U+3889 */	U2E_NODEST_COLX,
	/* U+388A */	U2E_NODEST_COLX,
	/* U+388B */	U2E_NODEST_COLX,
	/* U+388C */	U2E_NODEST_COLX,
	/* U+388D */	U2E_NODEST_COLX,
	/* U+388E */	U2E_NODEST_COLX,
	/* U+388F */	U2E_NODEST_COLX,
	/* U+3890 */	U2E_NODEST_COLX,
	/* U+3891 */	U2E_NODEST_COLX,
	/* U+3892 */	U2E_NODEST_COLX,
	/* U+3893 */	U2E_NODEST_COLX,
	/* U+3894 */	U2E_NODEST_COLX,
	/* U+3895 */	U2E_NODEST_COLX,
	/* U+3896 */	U2E_NODEST_COLX,
	/* U+3897 */	U2E_NODEST_COLX,
	/* U+3898 */	U2E_NODEST_COLX,
	/* U+3899 */	U2E_NODEST_COLX,
	/* U+389A */	U2E_NODEST_COLX,
	/* U+389B */	U2E_NODEST_COLX,
	/* U+389C */	U2E_NODEST_COLX,
	/* U+389D */	U2E_NODEST_COLX,
	/* U+389E */	U2E_NODEST_COLX,
	/* U+389F */	U2E_NODEST_COLX,
	/* U+38A0 */	U2E_NODEST_COLX,
	/* U+38A1 */	U2E_NODEST_COLX,
	/* U+38A2 */	U2E_NODEST_COLX,
	/* U+38A3 */	U2E_NODEST_COLX,
	/* U+38A4 */	U2E_NODEST_COLX,
	/* U+38A5 */	U2E_NODEST_COLX,
	/* U+38A6 */	U2E_NODEST_COLX,
	/* U+38A7 */	U2E_NODEST_COLX,
	/* U+38A8 */	U2E_NODEST_COLX,
	/* U+38A9 */	U2E_NODEST_COLX,
	/* U+38AA */	U2E_NODEST_COLX,
	/* U+38AB */	U2E_NODEST_COLX,
	/* U+38AC */	U2E_NODEST_COLX,
	/* U+38AD */	U2E_NODEST_COLX,
	/* U+38AE */	U2E_NODEST_COLX,
	/* U+38AF */	U2E_NODEST_COLX,
	/* U+38B0 */	U2E_NODEST_COLX,
	/* U+38B1 */	U2E_NODEST_COLX,
	/* U+38B2 */	U2E_NODEST_COLX,
	/* U+38B3 */	U2E_NODEST_COLX,
	/* U+38B4 */	U2E_NODEST_COLX,
	/* U+38B5 */	U2E_NODEST_COLX,
	/* U+38B6 */	U2E_NODEST_COLX,
	/* U+38B7 */	U2E_NODEST_COLX,
	/* U+38B8 */	U2E_NODEST_COLX,
	/* U+38B9 */	U2E_NODEST_COLX,
	/* U+38BA */	U2E_NODEST_COLX,
	/* U+38BB */	U2E_NODEST_COLX,
	/* U+38BC */	U2E_NODEST_COLX,
	/* U+38BD */	U2E_NODEST_COLX,
	/* U+38BE */	U2E_NODEST_COLX,
	/* U+38BF */	U2E_NODEST_COLX,
	/* U+38C0 */	U2E_NODEST_COLX,
	/* U+38C1 */	U2E_NODEST_COLX,
	/* U+38C2 */	U2E_NODEST_COLX,
	/* U+38C3 */	U2E_NODEST_COLX,
	/* U+38C4 */	U2E_NODEST_COLX,
	/* U+38C5 */	U2E_NODEST_COLX,
	/* U+38C6 */	U2E_NODEST_COLX,
	/* U+38C7 */	U2E_NODEST_COLX,
	/* U+38C8 */	U2E_NODEST_COLX,
	/* U+38C9 */	U2E_NODEST_COLX,
	/* U+38CA */	U2E_NODEST_COLX,
	/* U+38CB */	U2E_NODEST_COLX,
	/* U+38CC */	U2E_NODEST_COLX,
	/* U+38CD */	U2E_NODEST_COLX,
	/* U+38CE */	U2E_NODEST_COLX,
	/* U+38CF */	U2E_NODEST_COLX,
	/* U+38D0 */	U2E_NODEST_COLX,
	/* U+38D1 */	U2E_NODEST_COLX,
	/* U+38D2 */	U2E_NODEST_COLX,
	/* U+38D3 */	U2E_NODEST_COLX,
	/* U+38D4 */	U2E_NODEST_COLX,
	/* U+38D5 */	U2E_NODEST_COLX,
	/* U+38D6 */	U2E_NODEST_COLX,
	/* U+38D7 */	U2E_NODEST_COLX,
	/* U+38D8 */	U2E_NODEST_COLX,
	/* U+38D9 */	U2E_NODEST_COLX,
	/* U+38DA */	U2E_NODEST_COLX,
	/* U+38DB */	U2E_NODEST_COLX,
	/* U+38DC */	U2E_NODEST_COLX,
	/* U+38DD */	U2E_NODEST_COLX,
	/* U+38DE */	U2E_NODEST_COLX,
	/* U+38DF */	U2E_NODEST_COLX,
	/* U+38E0 */	U2E_NODEST_COLX,
	/* U+38E1 */	U2E_NODEST_COLX,
	/* U+38E2 */	U2E_NODEST_COLX,
	/* U+38E3 */	U2E_NODEST_COLX,
	/* U+38E4 */	U2E_NODEST_COLX,
	/* U+38E5 */	U2E_NODEST_COLX,
	/* U+38E6 */	U2E_NODEST_COLX,
	/* U+38E7 */	U2E_NODEST_COLX,
	/* U+38E8 */	U2E_NODEST_COLX,
	/* U+38E9 */	U2E_NODEST_COLX,
	/* U+38EA */	U2E_NODEST_COLX,
	/* U+38EB */	U2E_NODEST_COLX,
	/* U+38EC */	U2E_NODEST_COLX,
	/* U+38ED */	U2E_NODEST_COLX,
	/* U+38EE */	U2E_NODEST_COLX,
	/* U+38EF */	U2E_NODEST_COLX,
	/* U+38F0 */	U2E_NODEST_COLX,
	/* U+38F1 */	U2E_NODEST_COLX,
	/* U+38F2 */	U2E_NODEST_COLX,
	/* U+38F3 */	U2E_NODEST_COLX,
	/* U+38F4 */	U2E_NODEST_COLX,
	/* U+38F5 */	U2E_NODEST_COLX,
	/* U+38F6 */	U2E_NODEST_COLX,
	/* U+38F7 */	U2E_NODEST_COLX,
	/* U+38F8 */	U2E_NODEST_COLX,
	/* U+38F9 */	U2E_NODEST_COLX,
	/* U+38FA */	IFX0213(JISX0213_2(0xac3b),	U2E_NODEST_COLX),
	/* U+38FB */	U2E_NODEST_COLX,
	/* U+38FC */	U2E_NODEST_COLX,
	/* U+38FD */	U2E_NODEST_COLX,
	/* U+38FE */	U2E_NODEST_COLX,
	/* U+38FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_39[] = {
	/* U+3900 */	U2E_NODEST_COLX,
	/* U+3901 */	U2E_NODEST_COLX,
	/* U+3902 */	U2E_NODEST_COLX,
	/* U+3903 */	U2E_NODEST_COLX,
	/* U+3904 */	U2E_NODEST_COLX,
	/* U+3905 */	U2E_NODEST_COLX,
	/* U+3906 */	U2E_NODEST_COLX,
	/* U+3907 */	U2E_NODEST_COLX,
	/* U+3908 */	U2E_NODEST_COLX,
	/* U+3909 */	U2E_NODEST_COLX,
	/* U+390A */	U2E_NODEST_COLX,
	/* U+390B */	U2E_NODEST_COLX,
	/* U+390C */	U2E_NODEST_COLX,
	/* U+390D */	U2E_NODEST_COLX,
	/* U+390E */	U2E_NODEST_COLX,
	/* U+390F */	U2E_NODEST_COLX,
	/* U+3910 */	U2E_NODEST_COLX,
	/* U+3911 */	U2E_NODEST_COLX,
	/* U+3912 */	U2E_NODEST_COLX,
	/* U+3913 */	U2E_NODEST_COLX,
	/* U+3914 */	U2E_NODEST_COLX,
	/* U+3915 */	U2E_NODEST_COLX,
	/* U+3916 */	U2E_NODEST_COLX,
	/* U+3917 */	IFX0213(JISX0213_2(0xac46),	U2E_NODEST_COLX),
	/* U+3918 */	U2E_NODEST_COLX,
	/* U+3919 */	U2E_NODEST_COLX,
	/* U+391A */	IFX0213(JISX0213_2(0xac4a),	U2E_NODEST_COLX),
	/* U+391B */	U2E_NODEST_COLX,
	/* U+391C */	U2E_NODEST_COLX,
	/* U+391D */	U2E_NODEST_COLX,
	/* U+391E */	U2E_NODEST_COLX,
	/* U+391F */	U2E_NODEST_COLX,
	/* U+3920 */	U2E_NODEST_COLX,
	/* U+3921 */	U2E_NODEST_COLX,
	/* U+3922 */	U2E_NODEST_COLX,
	/* U+3923 */	U2E_NODEST_COLX,
	/* U+3924 */	U2E_NODEST_COLX,
	/* U+3925 */	U2E_NODEST_COLX,
	/* U+3926 */	U2E_NODEST_COLX,
	/* U+3927 */	U2E_NODEST_COLX,
	/* U+3928 */	U2E_NODEST_COLX,
	/* U+3929 */	U2E_NODEST_COLX,
	/* U+392A */	U2E_NODEST_COLX,
	/* U+392B */	U2E_NODEST_COLX,
	/* U+392C */	U2E_NODEST_COLX,
	/* U+392D */	U2E_NODEST_COLX,
	/* U+392E */	U2E_NODEST_COLX,
	/* U+392F */	U2E_NODEST_COLX,
	/* U+3930 */	U2E_NODEST_COLX,
	/* U+3931 */	U2E_NODEST_COLX,
	/* U+3932 */	U2E_NODEST_COLX,
	/* U+3933 */	U2E_NODEST_COLX,
	/* U+3934 */	U2E_NODEST_COLX,
	/* U+3935 */	U2E_NODEST_COLX,
	/* U+3936 */	U2E_NODEST_COLX,
	/* U+3937 */	U2E_NODEST_COLX,
	/* U+3938 */	U2E_NODEST_COLX,
	/* U+3939 */	U2E_NODEST_COLX,
	/* U+393A */	U2E_NODEST_COLX,
	/* U+393B */	U2E_NODEST_COLX,
	/* U+393C */	U2E_NODEST_COLX,
	/* U+393D */	U2E_NODEST_COLX,
	/* U+393E */	U2E_NODEST_COLX,
	/* U+393F */	U2E_NODEST_COLX,
	/* U+3940 */	U2E_NODEST_COLX,
	/* U+3941 */	U2E_NODEST_COLX,
	/* U+3942 */	U2E_NODEST_COLX,
	/* U+3943 */	U2E_NODEST_COLX,
	/* U+3944 */	U2E_NODEST_COLX,
	/* U+3945 */	U2E_NODEST_COLX,
	/* U+3946 */	U2E_NODEST_COLX,
	/* U+3947 */	U2E_NODEST_COLX,
	/* U+3948 */	U2E_NODEST_COLX,
	/* U+3949 */	U2E_NODEST_COLX,
	/* U+394A */	U2E_NODEST_COLX,
	/* U+394B */	U2E_NODEST_COLX,
	/* U+394C */	U2E_NODEST_COLX,
	/* U+394D */	U2E_NODEST_COLX,
	/* U+394E */	U2E_NODEST_COLX,
	/* U+394F */	U2E_NODEST_COLX,
	/* U+3950 */	U2E_NODEST_COLX,
	/* U+3951 */	U2E_NODEST_COLX,
	/* U+3952 */	U2E_NODEST_COLX,
	/* U+3953 */	U2E_NODEST_COLX,
	/* U+3954 */	U2E_NODEST_COLX,
	/* U+3955 */	U2E_NODEST_COLX,
	/* U+3956 */	U2E_NODEST_COLX,
	/* U+3957 */	U2E_NODEST_COLX,
	/* U+3958 */	U2E_NODEST_COLX,
	/* U+3959 */	U2E_NODEST_COLX,
	/* U+395A */	U2E_NODEST_COLX,
	/* U+395B */	U2E_NODEST_COLX,
	/* U+395C */	U2E_NODEST_COLX,
	/* U+395D */	U2E_NODEST_COLX,
	/* U+395E */	U2E_NODEST_COLX,
	/* U+395F */	U2E_NODEST_COLX,
	/* U+3960 */	U2E_NODEST_COLX,
	/* U+3961 */	U2E_NODEST_COLX,
	/* U+3962 */	U2E_NODEST_COLX,
	/* U+3963 */	U2E_NODEST_COLX,
	/* U+3964 */	U2E_NODEST_COLX,
	/* U+3965 */	U2E_NODEST_COLX,
	/* U+3966 */	U2E_NODEST_COLX,
	/* U+3967 */	U2E_NODEST_COLX,
	/* U+3968 */	U2E_NODEST_COLX,
	/* U+3969 */	U2E_NODEST_COLX,
	/* U+396A */	U2E_NODEST_COLX,
	/* U+396B */	U2E_NODEST_COLX,
	/* U+396C */	U2E_NODEST_COLX,
	/* U+396D */	U2E_NODEST_COLX,
	/* U+396E */	U2E_NODEST_COLX,
	/* U+396F */	IFX0213(JISX0213_2(0xac60),	U2E_NODEST_COLX),
	/* U+3970 */	U2E_NODEST_COLX,
	/* U+3971 */	U2E_NODEST_COLX,
	/* U+3972 */	U2E_NODEST_COLX,
	/* U+3973 */	U2E_NODEST_COLX,
	/* U+3974 */	U2E_NODEST_COLX,
	/* U+3975 */	U2E_NODEST_COLX,
	/* U+3976 */	U2E_NODEST_COLX,
	/* U+3977 */	U2E_NODEST_COLX,
	/* U+3978 */	U2E_NODEST_COLX,
	/* U+3979 */	U2E_NODEST_COLX,
	/* U+397A */	U2E_NODEST_COLX,
	/* U+397B */	U2E_NODEST_COLX,
	/* U+397C */	U2E_NODEST_COLX,
	/* U+397D */	U2E_NODEST_COLX,
	/* U+397E */	U2E_NODEST_COLX,
	/* U+397F */	U2E_NODEST_COLX,
	/* U+3980 */	U2E_NODEST_COLX,
	/* U+3981 */	U2E_NODEST_COLX,
	/* U+3982 */	U2E_NODEST_COLX,
	/* U+3983 */	U2E_NODEST_COLX,
	/* U+3984 */	U2E_NODEST_COLX,
	/* U+3985 */	U2E_NODEST_COLX,
	/* U+3986 */	U2E_NODEST_COLX,
	/* U+3987 */	U2E_NODEST_COLX,
	/* U+3988 */	U2E_NODEST_COLX,
	/* U+3989 */	U2E_NODEST_COLX,
	/* U+398A */	U2E_NODEST_COLX,
	/* U+398B */	U2E_NODEST_COLX,
	/* U+398C */	U2E_NODEST_COLX,
	/* U+398D */	U2E_NODEST_COLX,
	/* U+398E */	U2E_NODEST_COLX,
	/* U+398F */	U2E_NODEST_COLX,
	/* U+3990 */	U2E_NODEST_COLX,
	/* U+3991 */	U2E_NODEST_COLX,
	/* U+3992 */	U2E_NODEST_COLX,
	/* U+3993 */	U2E_NODEST_COLX,
	/* U+3994 */	U2E_NODEST_COLX,
	/* U+3995 */	U2E_NODEST_COLX,
	/* U+3996 */	U2E_NODEST_COLX,
	/* U+3997 */	U2E_NODEST_COLX,
	/* U+3998 */	U2E_NODEST_COLX,
	/* U+3999 */	U2E_NODEST_COLX,
	/* U+399A */	U2E_NODEST_COLX,
	/* U+399B */	U2E_NODEST_COLX,
	/* U+399C */	U2E_NODEST_COLX,
	/* U+399D */	U2E_NODEST_COLX,
	/* U+399E */	U2E_NODEST_COLX,
	/* U+399F */	U2E_NODEST_COLX,
	/* U+39A0 */	U2E_NODEST_COLX,
	/* U+39A1 */	U2E_NODEST_COLX,
	/* U+39A2 */	U2E_NODEST_COLX,
	/* U+39A3 */	U2E_NODEST_COLX,
	/* U+39A4 */	U2E_NODEST_COLX,
	/* U+39A5 */	U2E_NODEST_COLX,
	/* U+39A6 */	U2E_NODEST_COLX,
	/* U+39A7 */	U2E_NODEST_COLX,
	/* U+39A8 */	U2E_NODEST_COLX,
	/* U+39A9 */	U2E_NODEST_COLX,
	/* U+39AA */	U2E_NODEST_COLX,
	/* U+39AB */	U2E_NODEST_COLX,
	/* U+39AC */	U2E_NODEST_COLX,
	/* U+39AD */	U2E_NODEST_COLX,
	/* U+39AE */	U2E_NODEST_COLX,
	/* U+39AF */	U2E_NODEST_COLX,
	/* U+39B0 */	U2E_NODEST_COLX,
	/* U+39B1 */	U2E_NODEST_COLX,
	/* U+39B2 */	U2E_NODEST_COLX,
	/* U+39B3 */	U2E_NODEST_COLX,
	/* U+39B4 */	U2E_NODEST_COLX,
	/* U+39B5 */	U2E_NODEST_COLX,
	/* U+39B6 */	U2E_NODEST_COLX,
	/* U+39B7 */	U2E_NODEST_COLX,
	/* U+39B8 */	U2E_NODEST_COLX,
	/* U+39B9 */	U2E_NODEST_COLX,
	/* U+39BA */	U2E_NODEST_COLX,
	/* U+39BB */	U2E_NODEST_COLX,
	/* U+39BC */	U2E_NODEST_COLX,
	/* U+39BD */	U2E_NODEST_COLX,
	/* U+39BE */	U2E_NODEST_COLX,
	/* U+39BF */	U2E_NODEST_COLX,
	/* U+39C0 */	U2E_NODEST_COLX,
	/* U+39C1 */	U2E_NODEST_COLX,
	/* U+39C2 */	U2E_NODEST_COLX,
	/* U+39C3 */	U2E_NODEST_COLX,
	/* U+39C4 */	U2E_NODEST_COLX,
	/* U+39C5 */	U2E_NODEST_COLX,
	/* U+39C6 */	U2E_NODEST_COLX,
	/* U+39C7 */	U2E_NODEST_COLX,
	/* U+39C8 */	U2E_NODEST_COLX,
	/* U+39C9 */	U2E_NODEST_COLX,
	/* U+39CA */	U2E_NODEST_COLX,
	/* U+39CB */	U2E_NODEST_COLX,
	/* U+39CC */	U2E_NODEST_COLX,
	/* U+39CD */	U2E_NODEST_COLX,
	/* U+39CE */	U2E_NODEST_COLX,
	/* U+39CF */	U2E_NODEST_COLX,
	/* U+39D0 */	U2E_NODEST_COLX,
	/* U+39D1 */	U2E_NODEST_COLX,
	/* U+39D2 */	U2E_NODEST_COLX,
	/* U+39D3 */	U2E_NODEST_COLX,
	/* U+39D4 */	U2E_NODEST_COLX,
	/* U+39D5 */	U2E_NODEST_COLX,
	/* U+39D6 */	U2E_NODEST_COLX,
	/* U+39D7 */	U2E_NODEST_COLX,
	/* U+39D8 */	U2E_NODEST_COLX,
	/* U+39D9 */	U2E_NODEST_COLX,
	/* U+39DA */	U2E_NODEST_COLX,
	/* U+39DB */	U2E_NODEST_COLX,
	/* U+39DC */	U2E_NODEST_COLX,
	/* U+39DD */	U2E_NODEST_COLX,
	/* U+39DE */	U2E_NODEST_COLX,
	/* U+39DF */	U2E_NODEST_COLX,
	/* U+39E0 */	U2E_NODEST_COLX,
	/* U+39E1 */	U2E_NODEST_COLX,
	/* U+39E2 */	U2E_NODEST_COLX,
	/* U+39E3 */	U2E_NODEST_COLX,
	/* U+39E4 */	U2E_NODEST_COLX,
	/* U+39E5 */	U2E_NODEST_COLX,
	/* U+39E6 */	U2E_NODEST_COLX,
	/* U+39E7 */	U2E_NODEST_COLX,
	/* U+39E8 */	U2E_NODEST_COLX,
	/* U+39E9 */	U2E_NODEST_COLX,
	/* U+39EA */	U2E_NODEST_COLX,
	/* U+39EB */	U2E_NODEST_COLX,
	/* U+39EC */	U2E_NODEST_COLX,
	/* U+39ED */	U2E_NODEST_COLX,
	/* U+39EE */	U2E_NODEST_COLX,
	/* U+39EF */	U2E_NODEST_COLX,
	/* U+39F0 */	U2E_NODEST_COLX,
	/* U+39F1 */	U2E_NODEST_COLX,
	/* U+39F2 */	U2E_NODEST_COLX,
	/* U+39F3 */	U2E_NODEST_COLX,
	/* U+39F4 */	U2E_NODEST_COLX,
	/* U+39F5 */	U2E_NODEST_COLX,
	/* U+39F6 */	U2E_NODEST_COLX,
	/* U+39F7 */	U2E_NODEST_COLX,
	/* U+39F8 */	U2E_NODEST_COLX,
	/* U+39F9 */	U2E_NODEST_COLX,
	/* U+39FA */	U2E_NODEST_COLX,
	/* U+39FB */	U2E_NODEST_COLX,
	/* U+39FC */	U2E_NODEST_COLX,
	/* U+39FD */	U2E_NODEST_COLX,
	/* U+39FE */	U2E_NODEST_COLX,
	/* U+39FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_3A[] = {
	/* U+3A00 */	U2E_NODEST_COLX,
	/* U+3A01 */	U2E_NODEST_COLX,
	/* U+3A02 */	U2E_NODEST_COLX,
	/* U+3A03 */	U2E_NODEST_COLX,
	/* U+3A04 */	U2E_NODEST_COLX,
	/* U+3A05 */	U2E_NODEST_COLX,
	/* U+3A06 */	U2E_NODEST_COLX,
	/* U+3A07 */	U2E_NODEST_COLX,
	/* U+3A08 */	U2E_NODEST_COLX,
	/* U+3A09 */	U2E_NODEST_COLX,
	/* U+3A0A */	U2E_NODEST_COLX,
	/* U+3A0B */	U2E_NODEST_COLX,
	/* U+3A0C */	U2E_NODEST_COLX,
	/* U+3A0D */	U2E_NODEST_COLX,
	/* U+3A0E */	U2E_NODEST_COLX,
	/* U+3A0F */	U2E_NODEST_COLX,
	/* U+3A10 */	U2E_NODEST_COLX,
	/* U+3A11 */	U2E_NODEST_COLX,
	/* U+3A12 */	U2E_NODEST_COLX,
	/* U+3A13 */	U2E_NODEST_COLX,
	/* U+3A14 */	U2E_NODEST_COLX,
	/* U+3A15 */	U2E_NODEST_COLX,
	/* U+3A16 */	U2E_NODEST_COLX,
	/* U+3A17 */	U2E_NODEST_COLX,
	/* U+3A18 */	U2E_NODEST_COLX,
	/* U+3A19 */	U2E_NODEST_COLX,
	/* U+3A1A */	U2E_NODEST_COLX,
	/* U+3A1B */	U2E_NODEST_COLX,
	/* U+3A1C */	U2E_NODEST_COLX,
	/* U+3A1D */	U2E_NODEST_COLX,
	/* U+3A1E */	U2E_NODEST_COLX,
	/* U+3A1F */	U2E_NODEST_COLX,
	/* U+3A20 */	U2E_NODEST_COLX,
	/* U+3A21 */	U2E_NODEST_COLX,
	/* U+3A22 */	U2E_NODEST_COLX,
	/* U+3A23 */	U2E_NODEST_COLX,
	/* U+3A24 */	U2E_NODEST_COLX,
	/* U+3A25 */	U2E_NODEST_COLX,
	/* U+3A26 */	U2E_NODEST_COLX,
	/* U+3A27 */	U2E_NODEST_COLX,
	/* U+3A28 */	U2E_NODEST_COLX,
	/* U+3A29 */	U2E_NODEST_COLX,
	/* U+3A2A */	U2E_NODEST_COLX,
	/* U+3A2B */	U2E_NODEST_COLX,
	/* U+3A2C */	U2E_NODEST_COLX,
	/* U+3A2D */	U2E_NODEST_COLX,
	/* U+3A2E */	U2E_NODEST_COLX,
	/* U+3A2F */	U2E_NODEST_COLX,
	/* U+3A30 */	U2E_NODEST_COLX,
	/* U+3A31 */	U2E_NODEST_COLX,
	/* U+3A32 */	U2E_NODEST_COLX,
	/* U+3A33 */	U2E_NODEST_COLX,
	/* U+3A34 */	U2E_NODEST_COLX,
	/* U+3A35 */	U2E_NODEST_COLX,
	/* U+3A36 */	U2E_NODEST_COLX,
	/* U+3A37 */	U2E_NODEST_COLX,
	/* U+3A38 */	U2E_NODEST_COLX,
	/* U+3A39 */	U2E_NODEST_COLX,
	/* U+3A3A */	U2E_NODEST_COLX,
	/* U+3A3B */	U2E_NODEST_COLX,
	/* U+3A3C */	U2E_NODEST_COLX,
	/* U+3A3D */	U2E_NODEST_COLX,
	/* U+3A3E */	U2E_NODEST_COLX,
	/* U+3A3F */	U2E_NODEST_COLX,
	/* U+3A40 */	U2E_NODEST_COLX,
	/* U+3A41 */	U2E_NODEST_COLX,
	/* U+3A42 */	U2E_NODEST_COLX,
	/* U+3A43 */	U2E_NODEST_COLX,
	/* U+3A44 */	U2E_NODEST_COLX,
	/* U+3A45 */	U2E_NODEST_COLX,
	/* U+3A46 */	U2E_NODEST_COLX,
	/* U+3A47 */	U2E_NODEST_COLX,
	/* U+3A48 */	U2E_NODEST_COLX,
	/* U+3A49 */	U2E_NODEST_COLX,
	/* U+3A4A */	U2E_NODEST_COLX,
	/* U+3A4B */	U2E_NODEST_COLX,
	/* U+3A4C */	U2E_NODEST_COLX,
	/* U+3A4D */	U2E_NODEST_COLX,
	/* U+3A4E */	U2E_NODEST_COLX,
	/* U+3A4F */	U2E_NODEST_COLX,
	/* U+3A50 */	U2E_NODEST_COLX,
	/* U+3A51 */	U2E_NODEST_COLX,
	/* U+3A52 */	U2E_NODEST_COLX,
	/* U+3A53 */	U2E_NODEST_COLX,
	/* U+3A54 */	U2E_NODEST_COLX,
	/* U+3A55 */	U2E_NODEST_COLX,
	/* U+3A56 */	U2E_NODEST_COLX,
	/* U+3A57 */	U2E_NODEST_COLX,
	/* U+3A58 */	U2E_NODEST_COLX,
	/* U+3A59 */	U2E_NODEST_COLX,
	/* U+3A5A */	U2E_NODEST_COLX,
	/* U+3A5B */	U2E_NODEST_COLX,
	/* U+3A5C */	U2E_NODEST_COLX,
	/* U+3A5D */	U2E_NODEST_COLX,
	/* U+3A5E */	U2E_NODEST_COLX,
	/* U+3A5F */	U2E_NODEST_COLX,
	/* U+3A60 */	U2E_NODEST_COLX,
	/* U+3A61 */	U2E_NODEST_COLX,
	/* U+3A62 */	U2E_NODEST_COLX,
	/* U+3A63 */	U2E_NODEST_COLX,
	/* U+3A64 */	U2E_NODEST_COLX,
	/* U+3A65 */	U2E_NODEST_COLX,
	/* U+3A66 */	U2E_NODEST_COLX,
	/* U+3A67 */	U2E_NODEST_COLX,
	/* U+3A68 */	U2E_NODEST_COLX,
	/* U+3A69 */	U2E_NODEST_COLX,
	/* U+3A6A */	U2E_NODEST_COLX,
	/* U+3A6B */	U2E_NODEST_COLX,
	/* U+3A6C */	U2E_NODEST_COLX,
	/* U+3A6D */	U2E_NODEST_COLX,
	/* U+3A6E */	IFX0213(JISX0213_2(0xad5b),	U2E_NODEST_COLX),
	/* U+3A6F */	U2E_NODEST_COLX,
	/* U+3A70 */	U2E_NODEST_COLX,
	/* U+3A71 */	U2E_NODEST_COLX,
	/* U+3A72 */	U2E_NODEST_COLX,
	/* U+3A73 */	IFX0213(JISX0213_2(0xad5f),	U2E_NODEST_COLX),
	/* U+3A74 */	U2E_NODEST_COLX,
	/* U+3A75 */	U2E_NODEST_COLX,
	/* U+3A76 */	U2E_NODEST_COLX,
	/* U+3A77 */	U2E_NODEST_COLX,
	/* U+3A78 */	U2E_NODEST_COLX,
	/* U+3A79 */	U2E_NODEST_COLX,
	/* U+3A7A */	U2E_NODEST_COLX,
	/* U+3A7B */	U2E_NODEST_COLX,
	/* U+3A7C */	U2E_NODEST_COLX,
	/* U+3A7D */	U2E_NODEST_COLX,
	/* U+3A7E */	U2E_NODEST_COLX,
	/* U+3A7F */	U2E_NODEST_COLX,
	/* U+3A80 */	U2E_NODEST_COLX,
	/* U+3A81 */	U2E_NODEST_COLX,
	/* U+3A82 */	U2E_NODEST_COLX,
	/* U+3A83 */	U2E_NODEST_COLX,
	/* U+3A84 */	U2E_NODEST_COLX,
	/* U+3A85 */	U2E_NODEST_COLX,
	/* U+3A86 */	U2E_NODEST_COLX,
	/* U+3A87 */	U2E_NODEST_COLX,
	/* U+3A88 */	U2E_NODEST_COLX,
	/* U+3A89 */	U2E_NODEST_COLX,
	/* U+3A8A */	U2E_NODEST_COLX,
	/* U+3A8B */	U2E_NODEST_COLX,
	/* U+3A8C */	U2E_NODEST_COLX,
	/* U+3A8D */	U2E_NODEST_COLX,
	/* U+3A8E */	U2E_NODEST_COLX,
	/* U+3A8F */	U2E_NODEST_COLX,
	/* U+3A90 */	U2E_NODEST_COLX,
	/* U+3A91 */	U2E_NODEST_COLX,
	/* U+3A92 */	U2E_NODEST_COLX,
	/* U+3A93 */	U2E_NODEST_COLX,
	/* U+3A94 */	U2E_NODEST_COLX,
	/* U+3A95 */	U2E_NODEST_COLX,
	/* U+3A96 */	U2E_NODEST_COLX,
	/* U+3A97 */	U2E_NODEST_COLX,
	/* U+3A98 */	U2E_NODEST_COLX,
	/* U+3A99 */	U2E_NODEST_COLX,
	/* U+3A9A */	U2E_NODEST_COLX,
	/* U+3A9B */	U2E_NODEST_COLX,
	/* U+3A9C */	U2E_NODEST_COLX,
	/* U+3A9D */	U2E_NODEST_COLX,
	/* U+3A9E */	U2E_NODEST_COLX,
	/* U+3A9F */	U2E_NODEST_COLX,
	/* U+3AA0 */	U2E_NODEST_COLX,
	/* U+3AA1 */	U2E_NODEST_COLX,
	/* U+3AA2 */	U2E_NODEST_COLX,
	/* U+3AA3 */	U2E_NODEST_COLX,
	/* U+3AA4 */	U2E_NODEST_COLX,
	/* U+3AA5 */	U2E_NODEST_COLX,
	/* U+3AA6 */	U2E_NODEST_COLX,
	/* U+3AA7 */	U2E_NODEST_COLX,
	/* U+3AA8 */	U2E_NODEST_COLX,
	/* U+3AA9 */	U2E_NODEST_COLX,
	/* U+3AAA */	U2E_NODEST_COLX,
	/* U+3AAB */	U2E_NODEST_COLX,
	/* U+3AAC */	U2E_NODEST_COLX,
	/* U+3AAD */	U2E_NODEST_COLX,
	/* U+3AAE */	U2E_NODEST_COLX,
	/* U+3AAF */	U2E_NODEST_COLX,
	/* U+3AB0 */	U2E_NODEST_COLX,
	/* U+3AB1 */	U2E_NODEST_COLX,
	/* U+3AB2 */	U2E_NODEST_COLX,
	/* U+3AB3 */	U2E_NODEST_COLX,
	/* U+3AB4 */	U2E_NODEST_COLX,
	/* U+3AB5 */	U2E_NODEST_COLX,
	/* U+3AB6 */	U2E_NODEST_COLX,
	/* U+3AB7 */	U2E_NODEST_COLX,
	/* U+3AB8 */	U2E_NODEST_COLX,
	/* U+3AB9 */	U2E_NODEST_COLX,
	/* U+3ABA */	U2E_NODEST_COLX,
	/* U+3ABB */	U2E_NODEST_COLX,
	/* U+3ABC */	U2E_NODEST_COLX,
	/* U+3ABD */	U2E_NODEST_COLX,
	/* U+3ABE */	U2E_NODEST_COLX,
	/* U+3ABF */	U2E_NODEST_COLX,
	/* U+3AC0 */	U2E_NODEST_COLX,
	/* U+3AC1 */	U2E_NODEST_COLX,
	/* U+3AC2 */	U2E_NODEST_COLX,
	/* U+3AC3 */	U2E_NODEST_COLX,
	/* U+3AC4 */	U2E_NODEST_COLX,
	/* U+3AC5 */	U2E_NODEST_COLX,
	/* U+3AC6 */	U2E_NODEST_COLX,
	/* U+3AC7 */	U2E_NODEST_COLX,
	/* U+3AC8 */	U2E_NODEST_COLX,
	/* U+3AC9 */	U2E_NODEST_COLX,
	/* U+3ACA */	U2E_NODEST_COLX,
	/* U+3ACB */	U2E_NODEST_COLX,
	/* U+3ACC */	U2E_NODEST_COLX,
	/* U+3ACD */	U2E_NODEST_COLX,
	/* U+3ACE */	U2E_NODEST_COLX,
	/* U+3ACF */	U2E_NODEST_COLX,
	/* U+3AD0 */	U2E_NODEST_COLX,
	/* U+3AD1 */	U2E_NODEST_COLX,
	/* U+3AD2 */	U2E_NODEST_COLX,
	/* U+3AD3 */	U2E_NODEST_COLX,
	/* U+3AD4 */	U2E_NODEST_COLX,
	/* U+3AD5 */	U2E_NODEST_COLX,
	/* U+3AD6 */	IFX0213(JISX0213_2(0xad71),	U2E_NODEST_COLX),
	/* U+3AD7 */	IFX0213(JISX0213_2(0xae36),	U2E_NODEST_COLX),
	/* U+3AD8 */	U2E_NODEST_COLX,
	/* U+3AD9 */	U2E_NODEST_COLX,
	/* U+3ADA */	U2E_NODEST_COLX,
	/* U+3ADB */	U2E_NODEST_COLX,
	/* U+3ADC */	U2E_NODEST_COLX,
	/* U+3ADD */	U2E_NODEST_COLX,
	/* U+3ADE */	U2E_NODEST_COLX,
	/* U+3ADF */	U2E_NODEST_COLX,
	/* U+3AE0 */	U2E_NODEST_COLX,
	/* U+3AE1 */	U2E_NODEST_COLX,
	/* U+3AE2 */	U2E_NODEST_COLX,
	/* U+3AE3 */	U2E_NODEST_COLX,
	/* U+3AE4 */	U2E_NODEST_COLX,
	/* U+3AE5 */	U2E_NODEST_COLX,
	/* U+3AE6 */	U2E_NODEST_COLX,
	/* U+3AE7 */	U2E_NODEST_COLX,
	/* U+3AE8 */	U2E_NODEST_COLX,
	/* U+3AE9 */	U2E_NODEST_COLX,
	/* U+3AEA */	IFX0213(JISX0213_2(0xad7c),	U2E_NODEST_COLX),
	/* U+3AEB */	U2E_NODEST_COLX,
	/* U+3AEC */	U2E_NODEST_COLX,
	/* U+3AED */	U2E_NODEST_COLX,
	/* U+3AEE */	U2E_NODEST_COLX,
	/* U+3AEF */	U2E_NODEST_COLX,
	/* U+3AF0 */	U2E_NODEST_COLX,
	/* U+3AF1 */	U2E_NODEST_COLX,
	/* U+3AF2 */	U2E_NODEST_COLX,
	/* U+3AF3 */	U2E_NODEST_COLX,
	/* U+3AF4 */	U2E_NODEST_COLX,
	/* U+3AF5 */	U2E_NODEST_COLX,
	/* U+3AF6 */	U2E_NODEST_COLX,
	/* U+3AF7 */	U2E_NODEST_COLX,
	/* U+3AF8 */	U2E_NODEST_COLX,
	/* U+3AF9 */	U2E_NODEST_COLX,
	/* U+3AFA */	U2E_NODEST_COLX,
	/* U+3AFB */	U2E_NODEST_COLX,
	/* U+3AFC */	U2E_NODEST_COLX,
	/* U+3AFD */	U2E_NODEST_COLX,
	/* U+3AFE */	U2E_NODEST_COLX,
	/* U+3AFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_3B[] = {
	/* U+3B00 */	U2E_NODEST_COLX,
	/* U+3B01 */	U2E_NODEST_COLX,
	/* U+3B02 */	U2E_NODEST_COLX,
	/* U+3B03 */	U2E_NODEST_COLX,
	/* U+3B04 */	U2E_NODEST_COLX,
	/* U+3B05 */	U2E_NODEST_COLX,
	/* U+3B06 */	U2E_NODEST_COLX,
	/* U+3B07 */	U2E_NODEST_COLX,
	/* U+3B08 */	U2E_NODEST_COLX,
	/* U+3B09 */	U2E_NODEST_COLX,
	/* U+3B0A */	U2E_NODEST_COLX,
	/* U+3B0B */	U2E_NODEST_COLX,
	/* U+3B0C */	U2E_NODEST_COLX,
	/* U+3B0D */	U2E_NODEST_COLX,
	/* U+3B0E */	IFX0213(JISX0213_2(0xae2e),	U2E_NODEST_COLX),
	/* U+3B0F */	U2E_NODEST_COLX,
	/* U+3B10 */	U2E_NODEST_COLX,
	/* U+3B11 */	U2E_NODEST_COLX,
	/* U+3B12 */	U2E_NODEST_COLX,
	/* U+3B13 */	U2E_NODEST_COLX,
	/* U+3B14 */	U2E_NODEST_COLX,
	/* U+3B15 */	U2E_NODEST_COLX,
	/* U+3B16 */	U2E_NODEST_COLX,
	/* U+3B17 */	U2E_NODEST_COLX,
	/* U+3B18 */	U2E_NODEST_COLX,
	/* U+3B19 */	U2E_NODEST_COLX,
	/* U+3B1A */	IFX0213(JISX0213_2(0xae32),	U2E_NODEST_COLX),
	/* U+3B1B */	U2E_NODEST_COLX,
	/* U+3B1C */	IFX0213(JISX0213_2(0xae34),	U2E_NODEST_COLX),
	/* U+3B1D */	U2E_NODEST_COLX,
	/* U+3B1E */	U2E_NODEST_COLX,
	/* U+3B1F */	U2E_NODEST_COLX,
	/* U+3B20 */	U2E_NODEST_COLX,
	/* U+3B21 */	U2E_NODEST_COLX,
	/* U+3B22 */	IFX0213(JISX0213_1(0xf5c9),	U2E_NODEST_COLX),
	/* U+3B23 */	U2E_NODEST_COLX,
	/* U+3B24 */	U2E_NODEST_COLX,
	/* U+3B25 */	U2E_NODEST_COLX,
	/* U+3B26 */	U2E_NODEST_COLX,
	/* U+3B27 */	U2E_NODEST_COLX,
	/* U+3B28 */	U2E_NODEST_COLX,
	/* U+3B29 */	U2E_NODEST_COLX,
	/* U+3B2A */	U2E_NODEST_COLX,
	/* U+3B2B */	U2E_NODEST_COLX,
	/* U+3B2C */	U2E_NODEST_COLX,
	/* U+3B2D */	U2E_NODEST_COLX,
	/* U+3B2E */	U2E_NODEST_COLX,
	/* U+3B2F */	U2E_NODEST_COLX,
	/* U+3B30 */	U2E_NODEST_COLX,
	/* U+3B31 */	U2E_NODEST_COLX,
	/* U+3B32 */	U2E_NODEST_COLX,
	/* U+3B33 */	U2E_NODEST_COLX,
	/* U+3B34 */	U2E_NODEST_COLX,
	/* U+3B35 */	U2E_NODEST_COLX,
	/* U+3B36 */	U2E_NODEST_COLX,
	/* U+3B37 */	U2E_NODEST_COLX,
	/* U+3B38 */	U2E_NODEST_COLX,
	/* U+3B39 */	U2E_NODEST_COLX,
	/* U+3B3A */	U2E_NODEST_COLX,
	/* U+3B3B */	U2E_NODEST_COLX,
	/* U+3B3C */	U2E_NODEST_COLX,
	/* U+3B3D */	U2E_NODEST_COLX,
	/* U+3B3E */	U2E_NODEST_COLX,
	/* U+3B3F */	U2E_NODEST_COLX,
	/* U+3B40 */	U2E_NODEST_COLX,
	/* U+3B41 */	U2E_NODEST_COLX,
	/* U+3B42 */	U2E_NODEST_COLX,
	/* U+3B43 */	U2E_NODEST_COLX,
	/* U+3B44 */	U2E_NODEST_COLX,
	/* U+3B45 */	U2E_NODEST_COLX,
	/* U+3B46 */	U2E_NODEST_COLX,
	/* U+3B47 */	U2E_NODEST_COLX,
	/* U+3B48 */	U2E_NODEST_COLX,
	/* U+3B49 */	U2E_NODEST_COLX,
	/* U+3B4A */	U2E_NODEST_COLX,
	/* U+3B4B */	U2E_NODEST_COLX,
	/* U+3B4C */	U2E_NODEST_COLX,
	/* U+3B4D */	U2E_NODEST_COLX,
	/* U+3B4E */	U2E_NODEST_COLX,
	/* U+3B4F */	U2E_NODEST_COLX,
	/* U+3B50 */	U2E_NODEST_COLX,
	/* U+3B51 */	U2E_NODEST_COLX,
	/* U+3B52 */	U2E_NODEST_COLX,
	/* U+3B53 */	U2E_NODEST_COLX,
	/* U+3B54 */	U2E_NODEST_COLX,
	/* U+3B55 */	U2E_NODEST_COLX,
	/* U+3B56 */	U2E_NODEST_COLX,
	/* U+3B57 */	U2E_NODEST_COLX,
	/* U+3B58 */	U2E_NODEST_COLX,
	/* U+3B59 */	U2E_NODEST_COLX,
	/* U+3B5A */	U2E_NODEST_COLX,
	/* U+3B5B */	U2E_NODEST_COLX,
	/* U+3B5C */	U2E_NODEST_COLX,
	/* U+3B5D */	U2E_NODEST_COLX,
	/* U+3B5E */	U2E_NODEST_COLX,
	/* U+3B5F */	U2E_NODEST_COLX,
	/* U+3B60 */	U2E_NODEST_COLX,
	/* U+3B61 */	U2E_NODEST_COLX,
	/* U+3B62 */	U2E_NODEST_COLX,
	/* U+3B63 */	U2E_NODEST_COLX,
	/* U+3B64 */	U2E_NODEST_COLX,
	/* U+3B65 */	U2E_NODEST_COLX,
	/* U+3B66 */	U2E_NODEST_COLX,
	/* U+3B67 */	U2E_NODEST_COLX,
	/* U+3B68 */	U2E_NODEST_COLX,
	/* U+3B69 */	U2E_NODEST_COLX,
	/* U+3B6A */	U2E_NODEST_COLX,
	/* U+3B6B */	U2E_NODEST_COLX,
	/* U+3B6C */	U2E_NODEST_COLX,
	/* U+3B6D */	IFX0213(JISX0213_2(0xae6d),	U2E_NODEST_COLX),
	/* U+3B6E */	U2E_NODEST_COLX,
	/* U+3B6F */	U2E_NODEST_COLX,
	/* U+3B70 */	U2E_NODEST_COLX,
	/* U+3B71 */	U2E_NODEST_COLX,
	/* U+3B72 */	U2E_NODEST_COLX,
	/* U+3B73 */	U2E_NODEST_COLX,
	/* U+3B74 */	U2E_NODEST_COLX,
	/* U+3B75 */	U2E_NODEST_COLX,
	/* U+3B76 */	U2E_NODEST_COLX,
	/* U+3B77 */	IFX0213(JISX0213_2(0xae65),	U2E_NODEST_COLX),
	/* U+3B78 */	U2E_NODEST_COLX,
	/* U+3B79 */	U2E_NODEST_COLX,
	/* U+3B7A */	U2E_NODEST_COLX,
	/* U+3B7B */	U2E_NODEST_COLX,
	/* U+3B7C */	U2E_NODEST_COLX,
	/* U+3B7D */	U2E_NODEST_COLX,
	/* U+3B7E */	U2E_NODEST_COLX,
	/* U+3B7F */	U2E_NODEST_COLX,
	/* U+3B80 */	U2E_NODEST_COLX,
	/* U+3B81 */	U2E_NODEST_COLX,
	/* U+3B82 */	U2E_NODEST_COLX,
	/* U+3B83 */	U2E_NODEST_COLX,
	/* U+3B84 */	U2E_NODEST_COLX,
	/* U+3B85 */	U2E_NODEST_COLX,
	/* U+3B86 */	U2E_NODEST_COLX,
	/* U+3B87 */	IFX0213(JISX0213_2(0xaf28),	U2E_NODEST_COLX),
	/* U+3B88 */	IFX0213(JISX0213_2(0xaf29),	U2E_NODEST_COLX),
	/* U+3B89 */	U2E_NODEST_COLX,
	/* U+3B8A */	U2E_NODEST_COLX,
	/* U+3B8B */	U2E_NODEST_COLX,
	/* U+3B8C */	U2E_NODEST_COLX,
	/* U+3B8D */	IFX0213(JISX0213_2(0xaf2c),	U2E_NODEST_COLX),
	/* U+3B8E */	U2E_NODEST_COLX,
	/* U+3B8F */	U2E_NODEST_COLX,
	/* U+3B90 */	U2E_NODEST_COLX,
	/* U+3B91 */	U2E_NODEST_COLX,
	/* U+3B92 */	U2E_NODEST_COLX,
	/* U+3B93 */	U2E_NODEST_COLX,
	/* U+3B94 */	U2E_NODEST_COLX,
	/* U+3B95 */	U2E_NODEST_COLX,
	/* U+3B96 */	U2E_NODEST_COLX,
	/* U+3B97 */	U2E_NODEST_COLX,
	/* U+3B98 */	U2E_NODEST_COLX,
	/* U+3B99 */	U2E_NODEST_COLX,
	/* U+3B9A */	U2E_NODEST_COLX,
	/* U+3B9B */	U2E_NODEST_COLX,
	/* U+3B9C */	U2E_NODEST_COLX,
	/* U+3B9D */	U2E_NODEST_COLX,
	/* U+3B9E */	U2E_NODEST_COLX,
	/* U+3B9F */	U2E_NODEST_COLX,
	/* U+3BA0 */	U2E_NODEST_COLX,
	/* U+3BA1 */	U2E_NODEST_COLX,
	/* U+3BA2 */	U2E_NODEST_COLX,
	/* U+3BA3 */	U2E_NODEST_COLX,
	/* U+3BA4 */	IFX0213(JISX0213_2(0xaf34),	U2E_NODEST_COLX),
	/* U+3BA5 */	U2E_NODEST_COLX,
	/* U+3BA6 */	U2E_NODEST_COLX,
	/* U+3BA7 */	U2E_NODEST_COLX,
	/* U+3BA8 */	U2E_NODEST_COLX,
	/* U+3BA9 */	U2E_NODEST_COLX,
	/* U+3BAA */	U2E_NODEST_COLX,
	/* U+3BAB */	U2E_NODEST_COLX,
	/* U+3BAC */	U2E_NODEST_COLX,
	/* U+3BAD */	U2E_NODEST_COLX,
	/* U+3BAE */	U2E_NODEST_COLX,
	/* U+3BAF */	U2E_NODEST_COLX,
	/* U+3BB0 */	U2E_NODEST_COLX,
	/* U+3BB1 */	U2E_NODEST_COLX,
	/* U+3BB2 */	U2E_NODEST_COLX,
	/* U+3BB3 */	U2E_NODEST_COLX,
	/* U+3BB4 */	U2E_NODEST_COLX,
	/* U+3BB5 */	U2E_NODEST_COLX,
	/* U+3BB6 */	IFX0213(JISX0213_1(0xf5fe),	U2E_NODEST_COLX),
	/* U+3BB7 */	U2E_NODEST_COLX,
	/* U+3BB8 */	U2E_NODEST_COLX,
	/* U+3BB9 */	U2E_NODEST_COLX,
	/* U+3BBA */	U2E_NODEST_COLX,
	/* U+3BBB */	U2E_NODEST_COLX,
	/* U+3BBC */	U2E_NODEST_COLX,
	/* U+3BBD */	U2E_NODEST_COLX,
	/* U+3BBE */	U2E_NODEST_COLX,
	/* U+3BBF */	U2E_NODEST_COLX,
	/* U+3BC0 */	U2E_NODEST_COLX,
	/* U+3BC1 */	U2E_NODEST_COLX,
	/* U+3BC2 */	U2E_NODEST_COLX,
	/* U+3BC3 */	IFX0213(JISX0213_1(0xf6a1),	U2E_NODEST_COLX),
	/* U+3BC4 */	U2E_NODEST_COLX,
	/* U+3BC5 */	U2E_NODEST_COLX,
	/* U+3BC6 */	U2E_NODEST_COLX,
	/* U+3BC7 */	U2E_NODEST_COLX,
	/* U+3BC8 */	U2E_NODEST_COLX,
	/* U+3BC9 */	U2E_NODEST_COLX,
	/* U+3BCA */	U2E_NODEST_COLX,
	/* U+3BCB */	U2E_NODEST_COLX,
	/* U+3BCC */	U2E_NODEST_COLX,
	/* U+3BCD */	IFX0213(JISX0213_2(0xaf48),	U2E_NODEST_COLX),
	/* U+3BCE */	U2E_NODEST_COLX,
	/* U+3BCF */	U2E_NODEST_COLX,
	/* U+3BD0 */	U2E_NODEST_COLX,
	/* U+3BD1 */	U2E_NODEST_COLX,
	/* U+3BD2 */	U2E_NODEST_COLX,
	/* U+3BD3 */	U2E_NODEST_COLX,
	/* U+3BD4 */	U2E_NODEST_COLX,
	/* U+3BD5 */	U2E_NODEST_COLX,
	/* U+3BD6 */	U2E_NODEST_COLX,
	/* U+3BD7 */	U2E_NODEST_COLX,
	/* U+3BD8 */	U2E_NODEST_COLX,
	/* U+3BD9 */	U2E_NODEST_COLX,
	/* U+3BDA */	U2E_NODEST_COLX,
	/* U+3BDB */	U2E_NODEST_COLX,
	/* U+3BDC */	U2E_NODEST_COLX,
	/* U+3BDD */	U2E_NODEST_COLX,
	/* U+3BDE */	U2E_NODEST_COLX,
	/* U+3BDF */	U2E_NODEST_COLX,
	/* U+3BE0 */	U2E_NODEST_COLX,
	/* U+3BE1 */	U2E_NODEST_COLX,
	/* U+3BE2 */	U2E_NODEST_COLX,
	/* U+3BE3 */	U2E_NODEST_COLX,
	/* U+3BE4 */	U2E_NODEST_COLX,
	/* U+3BE5 */	U2E_NODEST_COLX,
	/* U+3BE6 */	U2E_NODEST_COLX,
	/* U+3BE7 */	U2E_NODEST_COLX,
	/* U+3BE8 */	U2E_NODEST_COLX,
	/* U+3BE9 */	U2E_NODEST_COLX,
	/* U+3BEA */	U2E_NODEST_COLX,
	/* U+3BEB */	U2E_NODEST_COLX,
	/* U+3BEC */	U2E_NODEST_COLX,
	/* U+3BED */	U2E_NODEST_COLX,
	/* U+3BEE */	U2E_NODEST_COLX,
	/* U+3BEF */	U2E_NODEST_COLX,
	/* U+3BF0 */	IFX0213(JISX0213_2(0xaf5d),	U2E_NODEST_COLX),
	/* U+3BF1 */	U2E_NODEST_COLX,
	/* U+3BF2 */	U2E_NODEST_COLX,
	/* U+3BF3 */	U2E_NODEST_COLX,
	/* U+3BF4 */	U2E_NODEST_COLX,
	/* U+3BF5 */	U2E_NODEST_COLX,
	/* U+3BF6 */	U2E_NODEST_COLX,
	/* U+3BF7 */	U2E_NODEST_COLX,
	/* U+3BF8 */	U2E_NODEST_COLX,
	/* U+3BF9 */	U2E_NODEST_COLX,
	/* U+3BFA */	U2E_NODEST_COLX,
	/* U+3BFB */	U2E_NODEST_COLX,
	/* U+3BFC */	U2E_NODEST_COLX,
	/* U+3BFD */	U2E_NODEST_COLX,
	/* U+3BFE */	U2E_NODEST_COLX,
	/* U+3BFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_3C[] = {
	/* U+3C00 */	U2E_NODEST_COLX,
	/* U+3C01 */	U2E_NODEST_COLX,
	/* U+3C02 */	U2E_NODEST_COLX,
	/* U+3C03 */	U2E_NODEST_COLX,
	/* U+3C04 */	U2E_NODEST_COLX,
	/* U+3C05 */	U2E_NODEST_COLX,
	/* U+3C06 */	U2E_NODEST_COLX,
	/* U+3C07 */	U2E_NODEST_COLX,
	/* U+3C08 */	U2E_NODEST_COLX,
	/* U+3C09 */	U2E_NODEST_COLX,
	/* U+3C0A */	U2E_NODEST_COLX,
	/* U+3C0B */	U2E_NODEST_COLX,
	/* U+3C0C */	U2E_NODEST_COLX,
	/* U+3C0D */	U2E_NODEST_COLX,
	/* U+3C0E */	U2E_NODEST_COLX,
	/* U+3C0F */	IFX0213(JISX0213_1(0xf6ba),	U2E_NODEST_COLX),
	/* U+3C10 */	U2E_NODEST_COLX,
	/* U+3C11 */	U2E_NODEST_COLX,
	/* U+3C12 */	U2E_NODEST_COLX,
	/* U+3C13 */	U2E_NODEST_COLX,
	/* U+3C14 */	U2E_NODEST_COLX,
	/* U+3C15 */	U2E_NODEST_COLX,
	/* U+3C16 */	U2E_NODEST_COLX,
	/* U+3C17 */	U2E_NODEST_COLX,
	/* U+3C18 */	U2E_NODEST_COLX,
	/* U+3C19 */	U2E_NODEST_COLX,
	/* U+3C1A */	U2E_NODEST_COLX,
	/* U+3C1B */	U2E_NODEST_COLX,
	/* U+3C1C */	U2E_NODEST_COLX,
	/* U+3C1D */	U2E_NODEST_COLX,
	/* U+3C1E */	U2E_NODEST_COLX,
	/* U+3C1F */	U2E_NODEST_COLX,
	/* U+3C20 */	U2E_NODEST_COLX,
	/* U+3C21 */	U2E_NODEST_COLX,
	/* U+3C22 */	U2E_NODEST_COLX,
	/* U+3C23 */	U2E_NODEST_COLX,
	/* U+3C24 */	U2E_NODEST_COLX,
	/* U+3C25 */	U2E_NODEST_COLX,
	/* U+3C26 */	IFX0213(JISX0213_2(0xaf77),	U2E_NODEST_COLX),
	/* U+3C27 */	U2E_NODEST_COLX,
	/* U+3C28 */	U2E_NODEST_COLX,
	/* U+3C29 */	U2E_NODEST_COLX,
	/* U+3C2A */	U2E_NODEST_COLX,
	/* U+3C2B */	U2E_NODEST_COLX,
	/* U+3C2C */	U2E_NODEST_COLX,
	/* U+3C2D */	U2E_NODEST_COLX,
	/* U+3C2E */	U2E_NODEST_COLX,
	/* U+3C2F */	U2E_NODEST_COLX,
	/* U+3C30 */	U2E_NODEST_COLX,
	/* U+3C31 */	U2E_NODEST_COLX,
	/* U+3C32 */	U2E_NODEST_COLX,
	/* U+3C33 */	U2E_NODEST_COLX,
	/* U+3C34 */	U2E_NODEST_COLX,
	/* U+3C35 */	U2E_NODEST_COLX,
	/* U+3C36 */	U2E_NODEST_COLX,
	/* U+3C37 */	U2E_NODEST_COLX,
	/* U+3C38 */	U2E_NODEST_COLX,
	/* U+3C39 */	U2E_NODEST_COLX,
	/* U+3C3A */	U2E_NODEST_COLX,
	/* U+3C3B */	U2E_NODEST_COLX,
	/* U+3C3C */	U2E_NODEST_COLX,
	/* U+3C3D */	U2E_NODEST_COLX,
	/* U+3C3E */	U2E_NODEST_COLX,
	/* U+3C3F */	U2E_NODEST_COLX,
	/* U+3C40 */	U2E_NODEST_COLX,
	/* U+3C41 */	U2E_NODEST_COLX,
	/* U+3C42 */	U2E_NODEST_COLX,
	/* U+3C43 */	U2E_NODEST_COLX,
	/* U+3C44 */	U2E_NODEST_COLX,
	/* U+3C45 */	U2E_NODEST_COLX,
	/* U+3C46 */	U2E_NODEST_COLX,
	/* U+3C47 */	U2E_NODEST_COLX,
	/* U+3C48 */	U2E_NODEST_COLX,
	/* U+3C49 */	U2E_NODEST_COLX,
	/* U+3C4A */	U2E_NODEST_COLX,
	/* U+3C4B */	U2E_NODEST_COLX,
	/* U+3C4C */	U2E_NODEST_COLX,
	/* U+3C4D */	U2E_NODEST_COLX,
	/* U+3C4E */	U2E_NODEST_COLX,
	/* U+3C4F */	U2E_NODEST_COLX,
	/* U+3C50 */	U2E_NODEST_COLX,
	/* U+3C51 */	U2E_NODEST_COLX,
	/* U+3C52 */	U2E_NODEST_COLX,
	/* U+3C53 */	U2E_NODEST_COLX,
	/* U+3C54 */	U2E_NODEST_COLX,
	/* U+3C55 */	U2E_NODEST_COLX,
	/* U+3C56 */	U2E_NODEST_COLX,
	/* U+3C57 */	U2E_NODEST_COLX,
	/* U+3C58 */	U2E_NODEST_COLX,
	/* U+3C59 */	U2E_NODEST_COLX,
	/* U+3C5A */	U2E_NODEST_COLX,
	/* U+3C5B */	U2E_NODEST_COLX,
	/* U+3C5C */	U2E_NODEST_COLX,
	/* U+3C5D */	U2E_NODEST_COLX,
	/* U+3C5E */	U2E_NODEST_COLX,
	/* U+3C5F */	U2E_NODEST_COLX,
	/* U+3C60 */	U2E_NODEST_COLX,
	/* U+3C61 */	U2E_NODEST_COLX,
	/* U+3C62 */	U2E_NODEST_COLX,
	/* U+3C63 */	U2E_NODEST_COLX,
	/* U+3C64 */	U2E_NODEST_COLX,
	/* U+3C65 */	U2E_NODEST_COLX,
	/* U+3C66 */	U2E_NODEST_COLX,
	/* U+3C67 */	U2E_NODEST_COLX,
	/* U+3C68 */	U2E_NODEST_COLX,
	/* U+3C69 */	U2E_NODEST_COLX,
	/* U+3C6A */	U2E_NODEST_COLX,
	/* U+3C6B */	U2E_NODEST_COLX,
	/* U+3C6C */	U2E_NODEST_COLX,
	/* U+3C6D */	U2E_NODEST_COLX,
	/* U+3C6E */	U2E_NODEST_COLX,
	/* U+3C6F */	U2E_NODEST_COLX,
	/* U+3C70 */	U2E_NODEST_COLX,
	/* U+3C71 */	U2E_NODEST_COLX,
	/* U+3C72 */	U2E_NODEST_COLX,
	/* U+3C73 */	U2E_NODEST_COLX,
	/* U+3C74 */	U2E_NODEST_COLX,
	/* U+3C75 */	U2E_NODEST_COLX,
	/* U+3C76 */	U2E_NODEST_COLX,
	/* U+3C77 */	U2E_NODEST_COLX,
	/* U+3C78 */	U2E_NODEST_COLX,
	/* U+3C79 */	U2E_NODEST_COLX,
	/* U+3C7A */	U2E_NODEST_COLX,
	/* U+3C7B */	U2E_NODEST_COLX,
	/* U+3C7C */	U2E_NODEST_COLX,
	/* U+3C7D */	U2E_NODEST_COLX,
	/* U+3C7E */	U2E_NODEST_COLX,
	/* U+3C7F */	U2E_NODEST_COLX,
	/* U+3C80 */	U2E_NODEST_COLX,
	/* U+3C81 */	U2E_NODEST_COLX,
	/* U+3C82 */	U2E_NODEST_COLX,
	/* U+3C83 */	U2E_NODEST_COLX,
	/* U+3C84 */	U2E_NODEST_COLX,
	/* U+3C85 */	U2E_NODEST_COLX,
	/* U+3C86 */	U2E_NODEST_COLX,
	/* U+3C87 */	U2E_NODEST_COLX,
	/* U+3C88 */	U2E_NODEST_COLX,
	/* U+3C89 */	U2E_NODEST_COLX,
	/* U+3C8A */	U2E_NODEST_COLX,
	/* U+3C8B */	U2E_NODEST_COLX,
	/* U+3C8C */	U2E_NODEST_COLX,
	/* U+3C8D */	U2E_NODEST_COLX,
	/* U+3C8E */	U2E_NODEST_COLX,
	/* U+3C8F */	U2E_NODEST_COLX,
	/* U+3C90 */	U2E_NODEST_COLX,
	/* U+3C91 */	U2E_NODEST_COLX,
	/* U+3C92 */	U2E_NODEST_COLX,
	/* U+3C93 */	U2E_NODEST_COLX,
	/* U+3C94 */	U2E_NODEST_COLX,
	/* U+3C95 */	U2E_NODEST_COLX,
	/* U+3C96 */	U2E_NODEST_COLX,
	/* U+3C97 */	U2E_NODEST_COLX,
	/* U+3C98 */	U2E_NODEST_COLX,
	/* U+3C99 */	U2E_NODEST_COLX,
	/* U+3C9A */	U2E_NODEST_COLX,
	/* U+3C9B */	U2E_NODEST_COLX,
	/* U+3C9C */	U2E_NODEST_COLX,
	/* U+3C9D */	U2E_NODEST_COLX,
	/* U+3C9E */	U2E_NODEST_COLX,
	/* U+3C9F */	U2E_NODEST_COLX,
	/* U+3CA0 */	U2E_NODEST_COLX,
	/* U+3CA1 */	U2E_NODEST_COLX,
	/* U+3CA2 */	U2E_NODEST_COLX,
	/* U+3CA3 */	U2E_NODEST_COLX,
	/* U+3CA4 */	U2E_NODEST_COLX,
	/* U+3CA5 */	U2E_NODEST_COLX,
	/* U+3CA6 */	U2E_NODEST_COLX,
	/* U+3CA7 */	U2E_NODEST_COLX,
	/* U+3CA8 */	U2E_NODEST_COLX,
	/* U+3CA9 */	U2E_NODEST_COLX,
	/* U+3CAA */	U2E_NODEST_COLX,
	/* U+3CAB */	U2E_NODEST_COLX,
	/* U+3CAC */	U2E_NODEST_COLX,
	/* U+3CAD */	U2E_NODEST_COLX,
	/* U+3CAE */	U2E_NODEST_COLX,
	/* U+3CAF */	U2E_NODEST_COLX,
	/* U+3CB0 */	U2E_NODEST_COLX,
	/* U+3CB1 */	U2E_NODEST_COLX,
	/* U+3CB2 */	U2E_NODEST_COLX,
	/* U+3CB3 */	U2E_NODEST_COLX,
	/* U+3CB4 */	U2E_NODEST_COLX,
	/* U+3CB5 */	U2E_NODEST_COLX,
	/* U+3CB6 */	U2E_NODEST_COLX,
	/* U+3CB7 */	U2E_NODEST_COLX,
	/* U+3CB8 */	U2E_NODEST_COLX,
	/* U+3CB9 */	U2E_NODEST_COLX,
	/* U+3CBA */	U2E_NODEST_COLX,
	/* U+3CBB */	U2E_NODEST_COLX,
	/* U+3CBC */	U2E_NODEST_COLX,
	/* U+3CBD */	U2E_NODEST_COLX,
	/* U+3CBE */	U2E_NODEST_COLX,
	/* U+3CBF */	U2E_NODEST_COLX,
	/* U+3CC0 */	U2E_NODEST_COLX,
	/* U+3CC1 */	U2E_NODEST_COLX,
	/* U+3CC2 */	U2E_NODEST_COLX,
	/* U+3CC3 */	IFX0213(JISX0213_2(0xee3b),	U2E_NODEST_COLX),
	/* U+3CC4 */	U2E_NODEST_COLX,
	/* U+3CC5 */	U2E_NODEST_COLX,
	/* U+3CC6 */	U2E_NODEST_COLX,
	/* U+3CC7 */	U2E_NODEST_COLX,
	/* U+3CC8 */	U2E_NODEST_COLX,
	/* U+3CC9 */	U2E_NODEST_COLX,
	/* U+3CCA */	U2E_NODEST_COLX,
	/* U+3CCB */	U2E_NODEST_COLX,
	/* U+3CCC */	U2E_NODEST_COLX,
	/* U+3CCD */	U2E_NODEST_COLX,
	/* U+3CCE */	U2E_NODEST_COLX,
	/* U+3CCF */	U2E_NODEST_COLX,
	/* U+3CD0 */	U2E_NODEST_COLX,
	/* U+3CD1 */	U2E_NODEST_COLX,
	/* U+3CD2 */	IFX0213(JISX0213_2(0xee42),	U2E_NODEST_COLX),
	/* U+3CD3 */	U2E_NODEST_COLX,
	/* U+3CD4 */	U2E_NODEST_COLX,
	/* U+3CD5 */	U2E_NODEST_COLX,
	/* U+3CD6 */	U2E_NODEST_COLX,
	/* U+3CD7 */	U2E_NODEST_COLX,
	/* U+3CD8 */	U2E_NODEST_COLX,
	/* U+3CD9 */	U2E_NODEST_COLX,
	/* U+3CDA */	U2E_NODEST_COLX,
	/* U+3CDB */	U2E_NODEST_COLX,
	/* U+3CDC */	U2E_NODEST_COLX,
	/* U+3CDD */	U2E_NODEST_COLX,
	/* U+3CDE */	U2E_NODEST_COLX,
	/* U+3CDF */	U2E_NODEST_COLX,
	/* U+3CE0 */	U2E_NODEST_COLX,
	/* U+3CE1 */	U2E_NODEST_COLX,
	/* U+3CE2 */	U2E_NODEST_COLX,
	/* U+3CE3 */	U2E_NODEST_COLX,
	/* U+3CE4 */	U2E_NODEST_COLX,
	/* U+3CE5 */	U2E_NODEST_COLX,
	/* U+3CE6 */	U2E_NODEST_COLX,
	/* U+3CE7 */	U2E_NODEST_COLX,
	/* U+3CE8 */	U2E_NODEST_COLX,
	/* U+3CE9 */	U2E_NODEST_COLX,
	/* U+3CEA */	U2E_NODEST_COLX,
	/* U+3CEB */	U2E_NODEST_COLX,
	/* U+3CEC */	U2E_NODEST_COLX,
	/* U+3CED */	U2E_NODEST_COLX,
	/* U+3CEE */	U2E_NODEST_COLX,
	/* U+3CEF */	U2E_NODEST_COLX,
	/* U+3CF0 */	U2E_NODEST_COLX,
	/* U+3CF1 */	U2E_NODEST_COLX,
	/* U+3CF2 */	U2E_NODEST_COLX,
	/* U+3CF3 */	U2E_NODEST_COLX,
	/* U+3CF4 */	U2E_NODEST_COLX,
	/* U+3CF5 */	U2E_NODEST_COLX,
	/* U+3CF6 */	U2E_NODEST_COLX,
	/* U+3CF7 */	U2E_NODEST_COLX,
	/* U+3CF8 */	U2E_NODEST_COLX,
	/* U+3CF9 */	U2E_NODEST_COLX,
	/* U+3CFA */	U2E_NODEST_COLX,
	/* U+3CFB */	U2E_NODEST_COLX,
	/* U+3CFC */	U2E_NODEST_COLX,
	/* U+3CFD */	U2E_NODEST_COLX,
	/* U+3CFE */	U2E_NODEST_COLX,
	/* U+3CFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_3D[] = {
	/* U+3D00 */	U2E_NODEST_COLX,
	/* U+3D01 */	U2E_NODEST_COLX,
	/* U+3D02 */	U2E_NODEST_COLX,
	/* U+3D03 */	U2E_NODEST_COLX,
	/* U+3D04 */	U2E_NODEST_COLX,
	/* U+3D05 */	U2E_NODEST_COLX,
	/* U+3D06 */	U2E_NODEST_COLX,
	/* U+3D07 */	U2E_NODEST_COLX,
	/* U+3D08 */	U2E_NODEST_COLX,
	/* U+3D09 */	U2E_NODEST_COLX,
	/* U+3D0A */	U2E_NODEST_COLX,
	/* U+3D0B */	U2E_NODEST_COLX,
	/* U+3D0C */	U2E_NODEST_COLX,
	/* U+3D0D */	U2E_NODEST_COLX,
	/* U+3D0E */	U2E_NODEST_COLX,
	/* U+3D0F */	U2E_NODEST_COLX,
	/* U+3D10 */	U2E_NODEST_COLX,
	/* U+3D11 */	IFX0213(JISX0213_2(0xee71),	U2E_NODEST_COLX),
	/* U+3D12 */	U2E_NODEST_COLX,
	/* U+3D13 */	U2E_NODEST_COLX,
	/* U+3D14 */	U2E_NODEST_COLX,
	/* U+3D15 */	U2E_NODEST_COLX,
	/* U+3D16 */	U2E_NODEST_COLX,
	/* U+3D17 */	U2E_NODEST_COLX,
	/* U+3D18 */	U2E_NODEST_COLX,
	/* U+3D19 */	U2E_NODEST_COLX,
	/* U+3D1A */	U2E_NODEST_COLX,
	/* U+3D1B */	U2E_NODEST_COLX,
	/* U+3D1C */	U2E_NODEST_COLX,
	/* U+3D1D */	U2E_NODEST_COLX,
	/* U+3D1E */	IFX0213(JISX0213_2(0xee7e),	U2E_NODEST_COLX),
	/* U+3D1F */	U2E_NODEST_COLX,
	/* U+3D20 */	U2E_NODEST_COLX,
	/* U+3D21 */	U2E_NODEST_COLX,
	/* U+3D22 */	U2E_NODEST_COLX,
	/* U+3D23 */	U2E_NODEST_COLX,
	/* U+3D24 */	U2E_NODEST_COLX,
	/* U+3D25 */	U2E_NODEST_COLX,
	/* U+3D26 */	U2E_NODEST_COLX,
	/* U+3D27 */	U2E_NODEST_COLX,
	/* U+3D28 */	U2E_NODEST_COLX,
	/* U+3D29 */	U2E_NODEST_COLX,
	/* U+3D2A */	U2E_NODEST_COLX,
	/* U+3D2B */	U2E_NODEST_COLX,
	/* U+3D2C */	U2E_NODEST_COLX,
	/* U+3D2D */	U2E_NODEST_COLX,
	/* U+3D2E */	U2E_NODEST_COLX,
	/* U+3D2F */	U2E_NODEST_COLX,
	/* U+3D30 */	U2E_NODEST_COLX,
	/* U+3D31 */	U2E_NODEST_COLX,
	/* U+3D32 */	U2E_NODEST_COLX,
	/* U+3D33 */	U2E_NODEST_COLX,
	/* U+3D34 */	U2E_NODEST_COLX,
	/* U+3D35 */	U2E_NODEST_COLX,
	/* U+3D36 */	U2E_NODEST_COLX,
	/* U+3D37 */	U2E_NODEST_COLX,
	/* U+3D38 */	U2E_NODEST_COLX,
	/* U+3D39 */	U2E_NODEST_COLX,
	/* U+3D3A */	U2E_NODEST_COLX,
	/* U+3D3B */	U2E_NODEST_COLX,
	/* U+3D3C */	U2E_NODEST_COLX,
	/* U+3D3D */	U2E_NODEST_COLX,
	/* U+3D3E */	U2E_NODEST_COLX,
	/* U+3D3F */	U2E_NODEST_COLX,
	/* U+3D40 */	U2E_NODEST_COLX,
	/* U+3D41 */	U2E_NODEST_COLX,
	/* U+3D42 */	U2E_NODEST_COLX,
	/* U+3D43 */	U2E_NODEST_COLX,
	/* U+3D44 */	U2E_NODEST_COLX,
	/* U+3D45 */	U2E_NODEST_COLX,
	/* U+3D46 */	U2E_NODEST_COLX,
	/* U+3D47 */	U2E_NODEST_COLX,
	/* U+3D48 */	U2E_NODEST_COLX,
	/* U+3D49 */	U2E_NODEST_COLX,
	/* U+3D4A */	U2E_NODEST_COLX,
	/* U+3D4B */	U2E_NODEST_COLX,
	/* U+3D4C */	U2E_NODEST_COLX,
	/* U+3D4D */	U2E_NODEST_COLX,
	/* U+3D4E */	U2E_NODEST_COLX,
	/* U+3D4F */	U2E_NODEST_COLX,
	/* U+3D50 */	U2E_NODEST_COLX,
	/* U+3D51 */	U2E_NODEST_COLX,
	/* U+3D52 */	U2E_NODEST_COLX,
	/* U+3D53 */	U2E_NODEST_COLX,
	/* U+3D54 */	U2E_NODEST_COLX,
	/* U+3D55 */	U2E_NODEST_COLX,
	/* U+3D56 */	U2E_NODEST_COLX,
	/* U+3D57 */	U2E_NODEST_COLX,
	/* U+3D58 */	U2E_NODEST_COLX,
	/* U+3D59 */	U2E_NODEST_COLX,
	/* U+3D5A */	U2E_NODEST_COLX,
	/* U+3D5B */	U2E_NODEST_COLX,
	/* U+3D5C */	U2E_NODEST_COLX,
	/* U+3D5D */	U2E_NODEST_COLX,
	/* U+3D5E */	U2E_NODEST_COLX,
	/* U+3D5F */	U2E_NODEST_COLX,
	/* U+3D60 */	U2E_NODEST_COLX,
	/* U+3D61 */	U2E_NODEST_COLX,
	/* U+3D62 */	U2E_NODEST_COLX,
	/* U+3D63 */	U2E_NODEST_COLX,
	/* U+3D64 */	IFX0213(JISX0213_2(0xef40),	U2E_NODEST_COLX),
	/* U+3D65 */	U2E_NODEST_COLX,
	/* U+3D66 */	U2E_NODEST_COLX,
	/* U+3D67 */	U2E_NODEST_COLX,
	/* U+3D68 */	U2E_NODEST_COLX,
	/* U+3D69 */	U2E_NODEST_COLX,
	/* U+3D6A */	U2E_NODEST_COLX,
	/* U+3D6B */	U2E_NODEST_COLX,
	/* U+3D6C */	U2E_NODEST_COLX,
	/* U+3D6D */	U2E_NODEST_COLX,
	/* U+3D6E */	U2E_NODEST_COLX,
	/* U+3D6F */	U2E_NODEST_COLX,
	/* U+3D70 */	U2E_NODEST_COLX,
	/* U+3D71 */	U2E_NODEST_COLX,
	/* U+3D72 */	U2E_NODEST_COLX,
	/* U+3D73 */	U2E_NODEST_COLX,
	/* U+3D74 */	U2E_NODEST_COLX,
	/* U+3D75 */	U2E_NODEST_COLX,
	/* U+3D76 */	U2E_NODEST_COLX,
	/* U+3D77 */	U2E_NODEST_COLX,
	/* U+3D78 */	U2E_NODEST_COLX,
	/* U+3D79 */	U2E_NODEST_COLX,
	/* U+3D7A */	U2E_NODEST_COLX,
	/* U+3D7B */	U2E_NODEST_COLX,
	/* U+3D7C */	U2E_NODEST_COLX,
	/* U+3D7D */	U2E_NODEST_COLX,
	/* U+3D7E */	U2E_NODEST_COLX,
	/* U+3D7F */	U2E_NODEST_COLX,
	/* U+3D80 */	U2E_NODEST_COLX,
	/* U+3D81 */	U2E_NODEST_COLX,
	/* U+3D82 */	U2E_NODEST_COLX,
	/* U+3D83 */	U2E_NODEST_COLX,
	/* U+3D84 */	U2E_NODEST_COLX,
	/* U+3D85 */	U2E_NODEST_COLX,
	/* U+3D86 */	U2E_NODEST_COLX,
	/* U+3D87 */	U2E_NODEST_COLX,
	/* U+3D88 */	U2E_NODEST_COLX,
	/* U+3D89 */	U2E_NODEST_COLX,
	/* U+3D8A */	U2E_NODEST_COLX,
	/* U+3D8B */	U2E_NODEST_COLX,
	/* U+3D8C */	U2E_NODEST_COLX,
	/* U+3D8D */	U2E_NODEST_COLX,
	/* U+3D8E */	U2E_NODEST_COLX,
	/* U+3D8F */	U2E_NODEST_COLX,
	/* U+3D90 */	U2E_NODEST_COLX,
	/* U+3D91 */	U2E_NODEST_COLX,
	/* U+3D92 */	U2E_NODEST_COLX,
	/* U+3D93 */	U2E_NODEST_COLX,
	/* U+3D94 */	U2E_NODEST_COLX,
	/* U+3D95 */	U2E_NODEST_COLX,
	/* U+3D96 */	U2E_NODEST_COLX,
	/* U+3D97 */	U2E_NODEST_COLX,
	/* U+3D98 */	U2E_NODEST_COLX,
	/* U+3D99 */	U2E_NODEST_COLX,
	/* U+3D9A */	IFX0213(JISX0213_2(0xef54),	U2E_NODEST_COLX),
	/* U+3D9B */	U2E_NODEST_COLX,
	/* U+3D9C */	U2E_NODEST_COLX,
	/* U+3D9D */	U2E_NODEST_COLX,
	/* U+3D9E */	U2E_NODEST_COLX,
	/* U+3D9F */	U2E_NODEST_COLX,
	/* U+3DA0 */	U2E_NODEST_COLX,
	/* U+3DA1 */	U2E_NODEST_COLX,
	/* U+3DA2 */	U2E_NODEST_COLX,
	/* U+3DA3 */	U2E_NODEST_COLX,
	/* U+3DA4 */	U2E_NODEST_COLX,
	/* U+3DA5 */	U2E_NODEST_COLX,
	/* U+3DA6 */	U2E_NODEST_COLX,
	/* U+3DA7 */	U2E_NODEST_COLX,
	/* U+3DA8 */	U2E_NODEST_COLX,
	/* U+3DA9 */	U2E_NODEST_COLX,
	/* U+3DAA */	U2E_NODEST_COLX,
	/* U+3DAB */	U2E_NODEST_COLX,
	/* U+3DAC */	U2E_NODEST_COLX,
	/* U+3DAD */	U2E_NODEST_COLX,
	/* U+3DAE */	U2E_NODEST_COLX,
	/* U+3DAF */	U2E_NODEST_COLX,
	/* U+3DB0 */	U2E_NODEST_COLX,
	/* U+3DB1 */	U2E_NODEST_COLX,
	/* U+3DB2 */	U2E_NODEST_COLX,
	/* U+3DB3 */	U2E_NODEST_COLX,
	/* U+3DB4 */	U2E_NODEST_COLX,
	/* U+3DB5 */	U2E_NODEST_COLX,
	/* U+3DB6 */	U2E_NODEST_COLX,
	/* U+3DB7 */	U2E_NODEST_COLX,
	/* U+3DB8 */	U2E_NODEST_COLX,
	/* U+3DB9 */	U2E_NODEST_COLX,
	/* U+3DBA */	U2E_NODEST_COLX,
	/* U+3DBB */	U2E_NODEST_COLX,
	/* U+3DBC */	U2E_NODEST_COLX,
	/* U+3DBD */	U2E_NODEST_COLX,
	/* U+3DBE */	U2E_NODEST_COLX,
	/* U+3DBF */	U2E_NODEST_COLX,
	/* U+3DC0 */	IFX0213(JISX0213_2(0xef70),	U2E_NODEST_COLX),
	/* U+3DC1 */	U2E_NODEST_COLX,
	/* U+3DC2 */	U2E_NODEST_COLX,
	/* U+3DC3 */	U2E_NODEST_COLX,
	/* U+3DC4 */	U2E_NODEST_COLX,
	/* U+3DC5 */	U2E_NODEST_COLX,
	/* U+3DC6 */	U2E_NODEST_COLX,
	/* U+3DC7 */	U2E_NODEST_COLX,
	/* U+3DC8 */	U2E_NODEST_COLX,
	/* U+3DC9 */	U2E_NODEST_COLX,
	/* U+3DCA */	U2E_NODEST_COLX,
	/* U+3DCB */	U2E_NODEST_COLX,
	/* U+3DCC */	U2E_NODEST_COLX,
	/* U+3DCD */	U2E_NODEST_COLX,
	/* U+3DCE */	U2E_NODEST_COLX,
	/* U+3DCF */	U2E_NODEST_COLX,
	/* U+3DD0 */	U2E_NODEST_COLX,
	/* U+3DD1 */	U2E_NODEST_COLX,
	/* U+3DD2 */	U2E_NODEST_COLX,
	/* U+3DD3 */	U2E_NODEST_COLX,
	/* U+3DD4 */	IFX0213(JISX0213_2(0xef77),	U2E_NODEST_COLX),
	/* U+3DD5 */	U2E_NODEST_COLX,
	/* U+3DD6 */	U2E_NODEST_COLX,
	/* U+3DD7 */	U2E_NODEST_COLX,
	/* U+3DD8 */	U2E_NODEST_COLX,
	/* U+3DD9 */	U2E_NODEST_COLX,
	/* U+3DDA */	U2E_NODEST_COLX,
	/* U+3DDB */	U2E_NODEST_COLX,
	/* U+3DDC */	U2E_NODEST_COLX,
	/* U+3DDD */	U2E_NODEST_COLX,
	/* U+3DDE */	U2E_NODEST_COLX,
	/* U+3DDF */	U2E_NODEST_COLX,
	/* U+3DE0 */	U2E_NODEST_COLX,
	/* U+3DE1 */	U2E_NODEST_COLX,
	/* U+3DE2 */	U2E_NODEST_COLX,
	/* U+3DE3 */	U2E_NODEST_COLX,
	/* U+3DE4 */	U2E_NODEST_COLX,
	/* U+3DE5 */	U2E_NODEST_COLX,
	/* U+3DE6 */	U2E_NODEST_COLX,
	/* U+3DE7 */	U2E_NODEST_COLX,
	/* U+3DE8 */	U2E_NODEST_COLX,
	/* U+3DE9 */	U2E_NODEST_COLX,
	/* U+3DEA */	U2E_NODEST_COLX,
	/* U+3DEB */	U2E_NODEST_COLX,
	/* U+3DEC */	U2E_NODEST_COLX,
	/* U+3DED */	U2E_NODEST_COLX,
	/* U+3DEE */	U2E_NODEST_COLX,
	/* U+3DEF */	U2E_NODEST_COLX,
	/* U+3DF0 */	U2E_NODEST_COLX,
	/* U+3DF1 */	U2E_NODEST_COLX,
	/* U+3DF2 */	U2E_NODEST_COLX,
	/* U+3DF3 */	U2E_NODEST_COLX,
	/* U+3DF4 */	U2E_NODEST_COLX,
	/* U+3DF5 */	U2E_NODEST_COLX,
	/* U+3DF6 */	U2E_NODEST_COLX,
	/* U+3DF7 */	U2E_NODEST_COLX,
	/* U+3DF8 */	U2E_NODEST_COLX,
	/* U+3DF9 */	U2E_NODEST_COLX,
	/* U+3DFA */	U2E_NODEST_COLX,
	/* U+3DFB */	U2E_NODEST_COLX,
	/* U+3DFC */	U2E_NODEST_COLX,
	/* U+3DFD */	U2E_NODEST_COLX,
	/* U+3DFE */	U2E_NODEST_COLX,
	/* U+3DFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_3E[] = {
	/* U+3E00 */	U2E_NODEST_COLX,
	/* U+3E01 */	U2E_NODEST_COLX,
	/* U+3E02 */	U2E_NODEST_COLX,
	/* U+3E03 */	U2E_NODEST_COLX,
	/* U+3E04 */	U2E_NODEST_COLX,
	/* U+3E05 */	IFX0213(JISX0213_2(0xf028),	U2E_NODEST_COLX),
	/* U+3E06 */	U2E_NODEST_COLX,
	/* U+3E07 */	U2E_NODEST_COLX,
	/* U+3E08 */	U2E_NODEST_COLX,
	/* U+3E09 */	U2E_NODEST_COLX,
	/* U+3E0A */	U2E_NODEST_COLX,
	/* U+3E0B */	U2E_NODEST_COLX,
	/* U+3E0C */	U2E_NODEST_COLX,
	/* U+3E0D */	U2E_NODEST_COLX,
	/* U+3E0E */	U2E_NODEST_COLX,
	/* U+3E0F */	U2E_NODEST_COLX,
	/* U+3E10 */	U2E_NODEST_COLX,
	/* U+3E11 */	U2E_NODEST_COLX,
	/* U+3E12 */	U2E_NODEST_COLX,
	/* U+3E13 */	U2E_NODEST_COLX,
	/* U+3E14 */	U2E_NODEST_COLX,
	/* U+3E15 */	U2E_NODEST_COLX,
	/* U+3E16 */	U2E_NODEST_COLX,
	/* U+3E17 */	U2E_NODEST_COLX,
	/* U+3E18 */	U2E_NODEST_COLX,
	/* U+3E19 */	U2E_NODEST_COLX,
	/* U+3E1A */	U2E_NODEST_COLX,
	/* U+3E1B */	U2E_NODEST_COLX,
	/* U+3E1C */	U2E_NODEST_COLX,
	/* U+3E1D */	U2E_NODEST_COLX,
	/* U+3E1E */	U2E_NODEST_COLX,
	/* U+3E1F */	U2E_NODEST_COLX,
	/* U+3E20 */	U2E_NODEST_COLX,
	/* U+3E21 */	U2E_NODEST_COLX,
	/* U+3E22 */	U2E_NODEST_COLX,
	/* U+3E23 */	U2E_NODEST_COLX,
	/* U+3E24 */	U2E_NODEST_COLX,
	/* U+3E25 */	U2E_NODEST_COLX,
	/* U+3E26 */	U2E_NODEST_COLX,
	/* U+3E27 */	U2E_NODEST_COLX,
	/* U+3E28 */	U2E_NODEST_COLX,
	/* U+3E29 */	U2E_NODEST_COLX,
	/* U+3E2A */	U2E_NODEST_COLX,
	/* U+3E2B */	U2E_NODEST_COLX,
	/* U+3E2C */	U2E_NODEST_COLX,
	/* U+3E2D */	U2E_NODEST_COLX,
	/* U+3E2E */	U2E_NODEST_COLX,
	/* U+3E2F */	U2E_NODEST_COLX,
	/* U+3E30 */	U2E_NODEST_COLX,
	/* U+3E31 */	U2E_NODEST_COLX,
	/* U+3E32 */	U2E_NODEST_COLX,
	/* U+3E33 */	U2E_NODEST_COLX,
	/* U+3E34 */	U2E_NODEST_COLX,
	/* U+3E35 */	U2E_NODEST_COLX,
	/* U+3E36 */	U2E_NODEST_COLX,
	/* U+3E37 */	U2E_NODEST_COLX,
	/* U+3E38 */	U2E_NODEST_COLX,
	/* U+3E39 */	U2E_NODEST_COLX,
	/* U+3E3A */	U2E_NODEST_COLX,
	/* U+3E3B */	U2E_NODEST_COLX,
	/* U+3E3C */	U2E_NODEST_COLX,
	/* U+3E3D */	U2E_NODEST_COLX,
	/* U+3E3E */	U2E_NODEST_COLX,
	/* U+3E3F */	IFX0213(JISX0213_1(0xf7e6),	U2E_NODEST_COLX),
	/* U+3E40 */	U2E_NODEST_COLX,
	/* U+3E41 */	U2E_NODEST_COLX,
	/* U+3E42 */	U2E_NODEST_COLX,
	/* U+3E43 */	U2E_NODEST_COLX,
	/* U+3E44 */	U2E_NODEST_COLX,
	/* U+3E45 */	U2E_NODEST_COLX,
	/* U+3E46 */	U2E_NODEST_COLX,
	/* U+3E47 */	U2E_NODEST_COLX,
	/* U+3E48 */	U2E_NODEST_COLX,
	/* U+3E49 */	U2E_NODEST_COLX,
	/* U+3E4A */	U2E_NODEST_COLX,
	/* U+3E4B */	U2E_NODEST_COLX,
	/* U+3E4C */	U2E_NODEST_COLX,
	/* U+3E4D */	U2E_NODEST_COLX,
	/* U+3E4E */	U2E_NODEST_COLX,
	/* U+3E4F */	U2E_NODEST_COLX,
	/* U+3E50 */	U2E_NODEST_COLX,
	/* U+3E51 */	U2E_NODEST_COLX,
	/* U+3E52 */	U2E_NODEST_COLX,
	/* U+3E53 */	U2E_NODEST_COLX,
	/* U+3E54 */	U2E_NODEST_COLX,
	/* U+3E55 */	U2E_NODEST_COLX,
	/* U+3E56 */	U2E_NODEST_COLX,
	/* U+3E57 */	U2E_NODEST_COLX,
	/* U+3E58 */	U2E_NODEST_COLX,
	/* U+3E59 */	U2E_NODEST_COLX,
	/* U+3E5A */	U2E_NODEST_COLX,
	/* U+3E5B */	U2E_NODEST_COLX,
	/* U+3E5C */	U2E_NODEST_COLX,
	/* U+3E5D */	U2E_NODEST_COLX,
	/* U+3E5E */	U2E_NODEST_COLX,
	/* U+3E5F */	U2E_NODEST_COLX,
	/* U+3E60 */	IFX0213(JISX0213_2(0xf03f),	U2E_NODEST_COLX),
	/* U+3E61 */	U2E_NODEST_COLX,
	/* U+3E62 */	U2E_NODEST_COLX,
	/* U+3E63 */	U2E_NODEST_COLX,
	/* U+3E64 */	U2E_NODEST_COLX,
	/* U+3E65 */	U2E_NODEST_COLX,
	/* U+3E66 */	IFX0213(JISX0213_2(0xf041),	U2E_NODEST_COLX),
	/* U+3E67 */	U2E_NODEST_COLX,
	/* U+3E68 */	IFX0213(JISX0213_2(0xf042),	U2E_NODEST_COLX),
	/* U+3E69 */	U2E_NODEST_COLX,
	/* U+3E6A */	U2E_NODEST_COLX,
	/* U+3E6B */	U2E_NODEST_COLX,
	/* U+3E6C */	U2E_NODEST_COLX,
	/* U+3E6D */	U2E_NODEST_COLX,
	/* U+3E6E */	U2E_NODEST_COLX,
	/* U+3E6F */	U2E_NODEST_COLX,
	/* U+3E70 */	U2E_NODEST_COLX,
	/* U+3E71 */	U2E_NODEST_COLX,
	/* U+3E72 */	U2E_NODEST_COLX,
	/* U+3E73 */	U2E_NODEST_COLX,
	/* U+3E74 */	U2E_NODEST_COLX,
	/* U+3E75 */	U2E_NODEST_COLX,
	/* U+3E76 */	U2E_NODEST_COLX,
	/* U+3E77 */	U2E_NODEST_COLX,
	/* U+3E78 */	U2E_NODEST_COLX,
	/* U+3E79 */	U2E_NODEST_COLX,
	/* U+3E7A */	U2E_NODEST_COLX,
	/* U+3E7B */	U2E_NODEST_COLX,
	/* U+3E7C */	U2E_NODEST_COLX,
	/* U+3E7D */	U2E_NODEST_COLX,
	/* U+3E7E */	U2E_NODEST_COLX,
	/* U+3E7F */	U2E_NODEST_COLX,
	/* U+3E80 */	U2E_NODEST_COLX,
	/* U+3E81 */	U2E_NODEST_COLX,
	/* U+3E82 */	U2E_NODEST_COLX,
	/* U+3E83 */	IFX0213(JISX0213_2(0xf049),	U2E_NODEST_COLX),
	/* U+3E84 */	U2E_NODEST_COLX,
	/* U+3E85 */	U2E_NODEST_COLX,
	/* U+3E86 */	U2E_NODEST_COLX,
	/* U+3E87 */	U2E_NODEST_COLX,
	/* U+3E88 */	U2E_NODEST_COLX,
	/* U+3E89 */	U2E_NODEST_COLX,
	/* U+3E8A */	U2E_NODEST_COLX,
	/* U+3E8B */	U2E_NODEST_COLX,
	/* U+3E8C */	U2E_NODEST_COLX,
	/* U+3E8D */	U2E_NODEST_COLX,
	/* U+3E8E */	U2E_NODEST_COLX,
	/* U+3E8F */	U2E_NODEST_COLX,
	/* U+3E90 */	U2E_NODEST_COLX,
	/* U+3E91 */	U2E_NODEST_COLX,
	/* U+3E92 */	U2E_NODEST_COLX,
	/* U+3E93 */	U2E_NODEST_COLX,
	/* U+3E94 */	IFX0213(JISX0213_2(0xf050),	U2E_NODEST_COLX),
	/* U+3E95 */	U2E_NODEST_COLX,
	/* U+3E96 */	U2E_NODEST_COLX,
	/* U+3E97 */	U2E_NODEST_COLX,
	/* U+3E98 */	U2E_NODEST_COLX,
	/* U+3E99 */	U2E_NODEST_COLX,
	/* U+3E9A */	U2E_NODEST_COLX,
	/* U+3E9B */	U2E_NODEST_COLX,
	/* U+3E9C */	U2E_NODEST_COLX,
	/* U+3E9D */	U2E_NODEST_COLX,
	/* U+3E9E */	U2E_NODEST_COLX,
	/* U+3E9F */	U2E_NODEST_COLX,
	/* U+3EA0 */	U2E_NODEST_COLX,
	/* U+3EA1 */	U2E_NODEST_COLX,
	/* U+3EA2 */	U2E_NODEST_COLX,
	/* U+3EA3 */	U2E_NODEST_COLX,
	/* U+3EA4 */	U2E_NODEST_COLX,
	/* U+3EA5 */	U2E_NODEST_COLX,
	/* U+3EA6 */	U2E_NODEST_COLX,
	/* U+3EA7 */	U2E_NODEST_COLX,
	/* U+3EA8 */	U2E_NODEST_COLX,
	/* U+3EA9 */	U2E_NODEST_COLX,
	/* U+3EAA */	U2E_NODEST_COLX,
	/* U+3EAB */	U2E_NODEST_COLX,
	/* U+3EAC */	U2E_NODEST_COLX,
	/* U+3EAD */	U2E_NODEST_COLX,
	/* U+3EAE */	U2E_NODEST_COLX,
	/* U+3EAF */	U2E_NODEST_COLX,
	/* U+3EB0 */	U2E_NODEST_COLX,
	/* U+3EB1 */	U2E_NODEST_COLX,
	/* U+3EB2 */	U2E_NODEST_COLX,
	/* U+3EB3 */	U2E_NODEST_COLX,
	/* U+3EB4 */	U2E_NODEST_COLX,
	/* U+3EB5 */	U2E_NODEST_COLX,
	/* U+3EB6 */	U2E_NODEST_COLX,
	/* U+3EB7 */	U2E_NODEST_COLX,
	/* U+3EB8 */	U2E_NODEST_COLX,
	/* U+3EB9 */	U2E_NODEST_COLX,
	/* U+3EBA */	U2E_NODEST_COLX,
	/* U+3EBB */	U2E_NODEST_COLX,
	/* U+3EBC */	U2E_NODEST_COLX,
	/* U+3EBD */	U2E_NODEST_COLX,
	/* U+3EBE */	U2E_NODEST_COLX,
	/* U+3EBF */	U2E_NODEST_COLX,
	/* U+3EC0 */	U2E_NODEST_COLX,
	/* U+3EC1 */	U2E_NODEST_COLX,
	/* U+3EC2 */	U2E_NODEST_COLX,
	/* U+3EC3 */	U2E_NODEST_COLX,
	/* U+3EC4 */	U2E_NODEST_COLX,
	/* U+3EC5 */	U2E_NODEST_COLX,
	/* U+3EC6 */	U2E_NODEST_COLX,
	/* U+3EC7 */	U2E_NODEST_COLX,
	/* U+3EC8 */	U2E_NODEST_COLX,
	/* U+3EC9 */	U2E_NODEST_COLX,
	/* U+3ECA */	U2E_NODEST_COLX,
	/* U+3ECB */	U2E_NODEST_COLX,
	/* U+3ECC */	U2E_NODEST_COLX,
	/* U+3ECD */	U2E_NODEST_COLX,
	/* U+3ECE */	U2E_NODEST_COLX,
	/* U+3ECF */	U2E_NODEST_COLX,
	/* U+3ED0 */	U2E_NODEST_COLX,
	/* U+3ED1 */	U2E_NODEST_COLX,
	/* U+3ED2 */	U2E_NODEST_COLX,
	/* U+3ED3 */	U2E_NODEST_COLX,
	/* U+3ED4 */	U2E_NODEST_COLX,
	/* U+3ED5 */	U2E_NODEST_COLX,
	/* U+3ED6 */	U2E_NODEST_COLX,
	/* U+3ED7 */	U2E_NODEST_COLX,
	/* U+3ED8 */	U2E_NODEST_COLX,
	/* U+3ED9 */	U2E_NODEST_COLX,
	/* U+3EDA */	U2E_NODEST_COLX,
	/* U+3EDB */	U2E_NODEST_COLX,
	/* U+3EDC */	U2E_NODEST_COLX,
	/* U+3EDD */	U2E_NODEST_COLX,
	/* U+3EDE */	U2E_NODEST_COLX,
	/* U+3EDF */	U2E_NODEST_COLX,
	/* U+3EE0 */	U2E_NODEST_COLX,
	/* U+3EE1 */	U2E_NODEST_COLX,
	/* U+3EE2 */	U2E_NODEST_COLX,
	/* U+3EE3 */	U2E_NODEST_COLX,
	/* U+3EE4 */	U2E_NODEST_COLX,
	/* U+3EE5 */	U2E_NODEST_COLX,
	/* U+3EE6 */	U2E_NODEST_COLX,
	/* U+3EE7 */	U2E_NODEST_COLX,
	/* U+3EE8 */	U2E_NODEST_COLX,
	/* U+3EE9 */	U2E_NODEST_COLX,
	/* U+3EEA */	U2E_NODEST_COLX,
	/* U+3EEB */	U2E_NODEST_COLX,
	/* U+3EEC */	U2E_NODEST_COLX,
	/* U+3EED */	U2E_NODEST_COLX,
	/* U+3EEE */	U2E_NODEST_COLX,
	/* U+3EEF */	U2E_NODEST_COLX,
	/* U+3EF0 */	U2E_NODEST_COLX,
	/* U+3EF1 */	U2E_NODEST_COLX,
	/* U+3EF2 */	U2E_NODEST_COLX,
	/* U+3EF3 */	U2E_NODEST_COLX,
	/* U+3EF4 */	U2E_NODEST_COLX,
	/* U+3EF5 */	U2E_NODEST_COLX,
	/* U+3EF6 */	U2E_NODEST_COLX,
	/* U+3EF7 */	U2E_NODEST_COLX,
	/* U+3EF8 */	U2E_NODEST_COLX,
	/* U+3EF9 */	U2E_NODEST_COLX,
	/* U+3EFA */	U2E_NODEST_COLX,
	/* U+3EFB */	U2E_NODEST_COLX,
	/* U+3EFC */	U2E_NODEST_COLX,
	/* U+3EFD */	U2E_NODEST_COLX,
	/* U+3EFE */	U2E_NODEST_COLX,
	/* U+3EFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_3F[] = {
	/* U+3F00 */	U2E_NODEST_COLX,
	/* U+3F01 */	U2E_NODEST_COLX,
	/* U+3F02 */	U2E_NODEST_COLX,
	/* U+3F03 */	U2E_NODEST_COLX,
	/* U+3F04 */	U2E_NODEST_COLX,
	/* U+3F05 */	U2E_NODEST_COLX,
	/* U+3F06 */	U2E_NODEST_COLX,
	/* U+3F07 */	U2E_NODEST_COLX,
	/* U+3F08 */	U2E_NODEST_COLX,
	/* U+3F09 */	U2E_NODEST_COLX,
	/* U+3F0A */	U2E_NODEST_COLX,
	/* U+3F0B */	U2E_NODEST_COLX,
	/* U+3F0C */	U2E_NODEST_COLX,
	/* U+3F0D */	U2E_NODEST_COLX,
	/* U+3F0E */	U2E_NODEST_COLX,
	/* U+3F0F */	U2E_NODEST_COLX,
	/* U+3F10 */	U2E_NODEST_COLX,
	/* U+3F11 */	U2E_NODEST_COLX,
	/* U+3F12 */	U2E_NODEST_COLX,
	/* U+3F13 */	U2E_NODEST_COLX,
	/* U+3F14 */	U2E_NODEST_COLX,
	/* U+3F15 */	U2E_NODEST_COLX,
	/* U+3F16 */	U2E_NODEST_COLX,
	/* U+3F17 */	U2E_NODEST_COLX,
	/* U+3F18 */	U2E_NODEST_COLX,
	/* U+3F19 */	U2E_NODEST_COLX,
	/* U+3F1A */	U2E_NODEST_COLX,
	/* U+3F1B */	U2E_NODEST_COLX,
	/* U+3F1C */	U2E_NODEST_COLX,
	/* U+3F1D */	U2E_NODEST_COLX,
	/* U+3F1E */	U2E_NODEST_COLX,
	/* U+3F1F */	U2E_NODEST_COLX,
	/* U+3F20 */	U2E_NODEST_COLX,
	/* U+3F21 */	U2E_NODEST_COLX,
	/* U+3F22 */	U2E_NODEST_COLX,
	/* U+3F23 */	U2E_NODEST_COLX,
	/* U+3F24 */	U2E_NODEST_COLX,
	/* U+3F25 */	U2E_NODEST_COLX,
	/* U+3F26 */	U2E_NODEST_COLX,
	/* U+3F27 */	U2E_NODEST_COLX,
	/* U+3F28 */	U2E_NODEST_COLX,
	/* U+3F29 */	U2E_NODEST_COLX,
	/* U+3F2A */	U2E_NODEST_COLX,
	/* U+3F2B */	U2E_NODEST_COLX,
	/* U+3F2C */	U2E_NODEST_COLX,
	/* U+3F2D */	U2E_NODEST_COLX,
	/* U+3F2E */	U2E_NODEST_COLX,
	/* U+3F2F */	U2E_NODEST_COLX,
	/* U+3F30 */	U2E_NODEST_COLX,
	/* U+3F31 */	U2E_NODEST_COLX,
	/* U+3F32 */	U2E_NODEST_COLX,
	/* U+3F33 */	U2E_NODEST_COLX,
	/* U+3F34 */	U2E_NODEST_COLX,
	/* U+3F35 */	U2E_NODEST_COLX,
	/* U+3F36 */	U2E_NODEST_COLX,
	/* U+3F37 */	U2E_NODEST_COLX,
	/* U+3F38 */	U2E_NODEST_COLX,
	/* U+3F39 */	U2E_NODEST_COLX,
	/* U+3F3A */	U2E_NODEST_COLX,
	/* U+3F3B */	U2E_NODEST_COLX,
	/* U+3F3C */	U2E_NODEST_COLX,
	/* U+3F3D */	U2E_NODEST_COLX,
	/* U+3F3E */	U2E_NODEST_COLX,
	/* U+3F3F */	U2E_NODEST_COLX,
	/* U+3F40 */	U2E_NODEST_COLX,
	/* U+3F41 */	U2E_NODEST_COLX,
	/* U+3F42 */	U2E_NODEST_COLX,
	/* U+3F43 */	U2E_NODEST_COLX,
	/* U+3F44 */	U2E_NODEST_COLX,
	/* U+3F45 */	U2E_NODEST_COLX,
	/* U+3F46 */	U2E_NODEST_COLX,
	/* U+3F47 */	U2E_NODEST_COLX,
	/* U+3F48 */	U2E_NODEST_COLX,
	/* U+3F49 */	U2E_NODEST_COLX,
	/* U+3F4A */	U2E_NODEST_COLX,
	/* U+3F4B */	U2E_NODEST_COLX,
	/* U+3F4C */	U2E_NODEST_COLX,
	/* U+3F4D */	U2E_NODEST_COLX,
	/* U+3F4E */	U2E_NODEST_COLX,
	/* U+3F4F */	U2E_NODEST_COLX,
	/* U+3F50 */	U2E_NODEST_COLX,
	/* U+3F51 */	U2E_NODEST_COLX,
	/* U+3F52 */	U2E_NODEST_COLX,
	/* U+3F53 */	U2E_NODEST_COLX,
	/* U+3F54 */	U2E_NODEST_COLX,
	/* U+3F55 */	U2E_NODEST_COLX,
	/* U+3F56 */	U2E_NODEST_COLX,
	/* U+3F57 */	IFX0213(JISX0213_2(0xf134),	U2E_NODEST_COLX),
	/* U+3F58 */	U2E_NODEST_COLX,
	/* U+3F59 */	U2E_NODEST_COLX,
	/* U+3F5A */	U2E_NODEST_COLX,
	/* U+3F5B */	U2E_NODEST_COLX,
	/* U+3F5C */	U2E_NODEST_COLX,
	/* U+3F5D */	U2E_NODEST_COLX,
	/* U+3F5E */	U2E_NODEST_COLX,
	/* U+3F5F */	U2E_NODEST_COLX,
	/* U+3F60 */	U2E_NODEST_COLX,
	/* U+3F61 */	U2E_NODEST_COLX,
	/* U+3F62 */	U2E_NODEST_COLX,
	/* U+3F63 */	U2E_NODEST_COLX,
	/* U+3F64 */	U2E_NODEST_COLX,
	/* U+3F65 */	U2E_NODEST_COLX,
	/* U+3F66 */	U2E_NODEST_COLX,
	/* U+3F67 */	U2E_NODEST_COLX,
	/* U+3F68 */	U2E_NODEST_COLX,
	/* U+3F69 */	U2E_NODEST_COLX,
	/* U+3F6A */	U2E_NODEST_COLX,
	/* U+3F6B */	U2E_NODEST_COLX,
	/* U+3F6C */	U2E_NODEST_COLX,
	/* U+3F6D */	U2E_NODEST_COLX,
	/* U+3F6E */	U2E_NODEST_COLX,
	/* U+3F6F */	U2E_NODEST_COLX,
	/* U+3F70 */	U2E_NODEST_COLX,
	/* U+3F71 */	U2E_NODEST_COLX,
	/* U+3F72 */	IFX0213(JISX0213_1(0xf8cd),	U2E_NODEST_COLX),
	/* U+3F73 */	U2E_NODEST_COLX,
	/* U+3F74 */	U2E_NODEST_COLX,
	/* U+3F75 */	IFX0213(JISX0213_2(0xf146),	U2E_NODEST_COLX),
	/* U+3F76 */	U2E_NODEST_COLX,
	/* U+3F77 */	IFX0213(JISX0213_2(0xf148),	U2E_NODEST_COLX),
	/* U+3F78 */	U2E_NODEST_COLX,
	/* U+3F79 */	U2E_NODEST_COLX,
	/* U+3F7A */	U2E_NODEST_COLX,
	/* U+3F7B */	U2E_NODEST_COLX,
	/* U+3F7C */	U2E_NODEST_COLX,
	/* U+3F7D */	U2E_NODEST_COLX,
	/* U+3F7E */	U2E_NODEST_COLX,
	/* U+3F7F */	U2E_NODEST_COLX,
	/* U+3F80 */	U2E_NODEST_COLX,
	/* U+3F81 */	U2E_NODEST_COLX,
	/* U+3F82 */	U2E_NODEST_COLX,
	/* U+3F83 */	U2E_NODEST_COLX,
	/* U+3F84 */	U2E_NODEST_COLX,
	/* U+3F85 */	U2E_NODEST_COLX,
	/* U+3F86 */	U2E_NODEST_COLX,
	/* U+3F87 */	U2E_NODEST_COLX,
	/* U+3F88 */	U2E_NODEST_COLX,
	/* U+3F89 */	U2E_NODEST_COLX,
	/* U+3F8A */	U2E_NODEST_COLX,
	/* U+3F8B */	U2E_NODEST_COLX,
	/* U+3F8C */	U2E_NODEST_COLX,
	/* U+3F8D */	U2E_NODEST_COLX,
	/* U+3F8E */	U2E_NODEST_COLX,
	/* U+3F8F */	U2E_NODEST_COLX,
	/* U+3F90 */	U2E_NODEST_COLX,
	/* U+3F91 */	U2E_NODEST_COLX,
	/* U+3F92 */	U2E_NODEST_COLX,
	/* U+3F93 */	U2E_NODEST_COLX,
	/* U+3F94 */	U2E_NODEST_COLX,
	/* U+3F95 */	U2E_NODEST_COLX,
	/* U+3F96 */	U2E_NODEST_COLX,
	/* U+3F97 */	U2E_NODEST_COLX,
	/* U+3F98 */	U2E_NODEST_COLX,
	/* U+3F99 */	U2E_NODEST_COLX,
	/* U+3F9A */	U2E_NODEST_COLX,
	/* U+3F9B */	U2E_NODEST_COLX,
	/* U+3F9C */	U2E_NODEST_COLX,
	/* U+3F9D */	U2E_NODEST_COLX,
	/* U+3F9E */	U2E_NODEST_COLX,
	/* U+3F9F */	U2E_NODEST_COLX,
	/* U+3FA0 */	U2E_NODEST_COLX,
	/* U+3FA1 */	U2E_NODEST_COLX,
	/* U+3FA2 */	U2E_NODEST_COLX,
	/* U+3FA3 */	U2E_NODEST_COLX,
	/* U+3FA4 */	U2E_NODEST_COLX,
	/* U+3FA5 */	U2E_NODEST_COLX,
	/* U+3FA6 */	U2E_NODEST_COLX,
	/* U+3FA7 */	U2E_NODEST_COLX,
	/* U+3FA8 */	U2E_NODEST_COLX,
	/* U+3FA9 */	U2E_NODEST_COLX,
	/* U+3FAA */	U2E_NODEST_COLX,
	/* U+3FAB */	U2E_NODEST_COLX,
	/* U+3FAC */	U2E_NODEST_COLX,
	/* U+3FAD */	U2E_NODEST_COLX,
	/* U+3FAE */	IFX0213(JISX0213_2(0xf15c),	U2E_NODEST_COLX),
	/* U+3FAF */	U2E_NODEST_COLX,
	/* U+3FB0 */	U2E_NODEST_COLX,
	/* U+3FB1 */	U2E_NODEST_COLX,
	/* U+3FB2 */	U2E_NODEST_COLX,
	/* U+3FB3 */	U2E_NODEST_COLX,
	/* U+3FB4 */	U2E_NODEST_COLX,
	/* U+3FB5 */	U2E_NODEST_COLX,
	/* U+3FB6 */	U2E_NODEST_COLX,
	/* U+3FB7 */	U2E_NODEST_COLX,
	/* U+3FB8 */	U2E_NODEST_COLX,
	/* U+3FB9 */	U2E_NODEST_COLX,
	/* U+3FBA */	U2E_NODEST_COLX,
	/* U+3FBB */	U2E_NODEST_COLX,
	/* U+3FBC */	U2E_NODEST_COLX,
	/* U+3FBD */	U2E_NODEST_COLX,
	/* U+3FBE */	U2E_NODEST_COLX,
	/* U+3FBF */	U2E_NODEST_COLX,
	/* U+3FC0 */	U2E_NODEST_COLX,
	/* U+3FC1 */	U2E_NODEST_COLX,
	/* U+3FC2 */	U2E_NODEST_COLX,
	/* U+3FC3 */	U2E_NODEST_COLX,
	/* U+3FC4 */	U2E_NODEST_COLX,
	/* U+3FC5 */	U2E_NODEST_COLX,
	/* U+3FC6 */	U2E_NODEST_COLX,
	/* U+3FC7 */	U2E_NODEST_COLX,
	/* U+3FC8 */	U2E_NODEST_COLX,
	/* U+3FC9 */	IFX0213(JISX0213_2(0xf167),	U2E_NODEST_COLX),
	/* U+3FCA */	U2E_NODEST_COLX,
	/* U+3FCB */	U2E_NODEST_COLX,
	/* U+3FCC */	U2E_NODEST_COLX,
	/* U+3FCD */	U2E_NODEST_COLX,
	/* U+3FCE */	U2E_NODEST_COLX,
	/* U+3FCF */	U2E_NODEST_COLX,
	/* U+3FD0 */	U2E_NODEST_COLX,
	/* U+3FD1 */	U2E_NODEST_COLX,
	/* U+3FD2 */	U2E_NODEST_COLX,
	/* U+3FD3 */	U2E_NODEST_COLX,
	/* U+3FD4 */	U2E_NODEST_COLX,
	/* U+3FD5 */	U2E_NODEST_COLX,
	/* U+3FD6 */	U2E_NODEST_COLX,
	/* U+3FD7 */	IFX0213(JISX0213_2(0xf16c),	U2E_NODEST_COLX),
	/* U+3FD8 */	U2E_NODEST_COLX,
	/* U+3FD9 */	U2E_NODEST_COLX,
	/* U+3FDA */	U2E_NODEST_COLX,
	/* U+3FDB */	U2E_NODEST_COLX,
	/* U+3FDC */	U2E_NODEST_COLX,
	/* U+3FDD */	U2E_NODEST_COLX,
	/* U+3FDE */	U2E_NODEST_COLX,
	/* U+3FDF */	U2E_NODEST_COLX,
	/* U+3FE0 */	U2E_NODEST_COLX,
	/* U+3FE1 */	U2E_NODEST_COLX,
	/* U+3FE2 */	U2E_NODEST_COLX,
	/* U+3FE3 */	U2E_NODEST_COLX,
	/* U+3FE4 */	U2E_NODEST_COLX,
	/* U+3FE5 */	U2E_NODEST_COLX,
	/* U+3FE6 */	U2E_NODEST_COLX,
	/* U+3FE7 */	U2E_NODEST_COLX,
	/* U+3FE8 */	U2E_NODEST_COLX,
	/* U+3FE9 */	U2E_NODEST_COLX,
	/* U+3FEA */	U2E_NODEST_COLX,
	/* U+3FEB */	U2E_NODEST_COLX,
	/* U+3FEC */	U2E_NODEST_COLX,
	/* U+3FED */	U2E_NODEST_COLX,
	/* U+3FEE */	U2E_NODEST_COLX,
	/* U+3FEF */	U2E_NODEST_COLX,
	/* U+3FF0 */	U2E_NODEST_COLX,
	/* U+3FF1 */	U2E_NODEST_COLX,
	/* U+3FF2 */	U2E_NODEST_COLX,
	/* U+3FF3 */	U2E_NODEST_COLX,
	/* U+3FF4 */	U2E_NODEST_COLX,
	/* U+3FF5 */	U2E_NODEST_COLX,
	/* U+3FF6 */	U2E_NODEST_COLX,
	/* U+3FF7 */	U2E_NODEST_COLX,
	/* U+3FF8 */	U2E_NODEST_COLX,
	/* U+3FF9 */	U2E_NODEST_COLX,
	/* U+3FFA */	U2E_NODEST_COLX,
	/* U+3FFB */	U2E_NODEST_COLX,
	/* U+3FFC */	U2E_NODEST_COLX,
	/* U+3FFD */	U2E_NODEST_COLX,
	/* U+3FFE */	U2E_NODEST_COLX,
	/* U+3FFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_40[] = {
	/* U+4000 */	U2E_NODEST_COLX,
	/* U+4001 */	U2E_NODEST_COLX,
	/* U+4002 */	U2E_NODEST_COLX,
	/* U+4003 */	U2E_NODEST_COLX,
	/* U+4004 */	U2E_NODEST_COLX,
	/* U+4005 */	U2E_NODEST_COLX,
	/* U+4006 */	U2E_NODEST_COLX,
	/* U+4007 */	U2E_NODEST_COLX,
	/* U+4008 */	U2E_NODEST_COLX,
	/* U+4009 */	U2E_NODEST_COLX,
	/* U+400A */	U2E_NODEST_COLX,
	/* U+400B */	U2E_NODEST_COLX,
	/* U+400C */	U2E_NODEST_COLX,
	/* U+400D */	U2E_NODEST_COLX,
	/* U+400E */	U2E_NODEST_COLX,
	/* U+400F */	U2E_NODEST_COLX,
	/* U+4010 */	U2E_NODEST_COLX,
	/* U+4011 */	U2E_NODEST_COLX,
	/* U+4012 */	U2E_NODEST_COLX,
	/* U+4013 */	U2E_NODEST_COLX,
	/* U+4014 */	U2E_NODEST_COLX,
	/* U+4015 */	U2E_NODEST_COLX,
	/* U+4016 */	U2E_NODEST_COLX,
	/* U+4017 */	U2E_NODEST_COLX,
	/* U+4018 */	U2E_NODEST_COLX,
	/* U+4019 */	U2E_NODEST_COLX,
	/* U+401A */	U2E_NODEST_COLX,
	/* U+401B */	U2E_NODEST_COLX,
	/* U+401C */	U2E_NODEST_COLX,
	/* U+401D */	U2E_NODEST_COLX,
	/* U+401E */	U2E_NODEST_COLX,
	/* U+401F */	U2E_NODEST_COLX,
	/* U+4020 */	U2E_NODEST_COLX,
	/* U+4021 */	U2E_NODEST_COLX,
	/* U+4022 */	U2E_NODEST_COLX,
	/* U+4023 */	U2E_NODEST_COLX,
	/* U+4024 */	U2E_NODEST_COLX,
	/* U+4025 */	U2E_NODEST_COLX,
	/* U+4026 */	U2E_NODEST_COLX,
	/* U+4027 */	U2E_NODEST_COLX,
	/* U+4028 */	U2E_NODEST_COLX,
	/* U+4029 */	U2E_NODEST_COLX,
	/* U+402A */	U2E_NODEST_COLX,
	/* U+402B */	U2E_NODEST_COLX,
	/* U+402C */	U2E_NODEST_COLX,
	/* U+402D */	U2E_NODEST_COLX,
	/* U+402E */	U2E_NODEST_COLX,
	/* U+402F */	U2E_NODEST_COLX,
	/* U+4030 */	U2E_NODEST_COLX,
	/* U+4031 */	U2E_NODEST_COLX,
	/* U+4032 */	U2E_NODEST_COLX,
	/* U+4033 */	U2E_NODEST_COLX,
	/* U+4034 */	U2E_NODEST_COLX,
	/* U+4035 */	U2E_NODEST_COLX,
	/* U+4036 */	U2E_NODEST_COLX,
	/* U+4037 */	U2E_NODEST_COLX,
	/* U+4038 */	U2E_NODEST_COLX,
	/* U+4039 */	IFX0213(JISX0213_2(0xf222),	U2E_NODEST_COLX),
	/* U+403A */	U2E_NODEST_COLX,
	/* U+403B */	U2E_NODEST_COLX,
	/* U+403C */	U2E_NODEST_COLX,
	/* U+403D */	U2E_NODEST_COLX,
	/* U+403E */	U2E_NODEST_COLX,
	/* U+403F */	U2E_NODEST_COLX,
	/* U+4040 */	U2E_NODEST_COLX,
	/* U+4041 */	U2E_NODEST_COLX,
	/* U+4042 */	U2E_NODEST_COLX,
	/* U+4043 */	U2E_NODEST_COLX,
	/* U+4044 */	U2E_NODEST_COLX,
	/* U+4045 */	U2E_NODEST_COLX,
	/* U+4046 */	U2E_NODEST_COLX,
	/* U+4047 */	U2E_NODEST_COLX,
	/* U+4048 */	U2E_NODEST_COLX,
	/* U+4049 */	U2E_NODEST_COLX,
	/* U+404A */	U2E_NODEST_COLX,
	/* U+404B */	U2E_NODEST_COLX,
	/* U+404C */	U2E_NODEST_COLX,
	/* U+404D */	U2E_NODEST_COLX,
	/* U+404E */	U2E_NODEST_COLX,
	/* U+404F */	U2E_NODEST_COLX,
	/* U+4050 */	U2E_NODEST_COLX,
	/* U+4051 */	U2E_NODEST_COLX,
	/* U+4052 */	U2E_NODEST_COLX,
	/* U+4053 */	U2E_NODEST_COLX,
	/* U+4054 */	U2E_NODEST_COLX,
	/* U+4055 */	U2E_NODEST_COLX,
	/* U+4056 */	U2E_NODEST_COLX,
	/* U+4057 */	U2E_NODEST_COLX,
	/* U+4058 */	IFX0213(JISX0213_2(0xf22d),	U2E_NODEST_COLX),
	/* U+4059 */	U2E_NODEST_COLX,
	/* U+405A */	U2E_NODEST_COLX,
	/* U+405B */	U2E_NODEST_COLX,
	/* U+405C */	U2E_NODEST_COLX,
	/* U+405D */	U2E_NODEST_COLX,
	/* U+405E */	U2E_NODEST_COLX,
	/* U+405F */	U2E_NODEST_COLX,
	/* U+4060 */	U2E_NODEST_COLX,
	/* U+4061 */	U2E_NODEST_COLX,
	/* U+4062 */	U2E_NODEST_COLX,
	/* U+4063 */	U2E_NODEST_COLX,
	/* U+4064 */	U2E_NODEST_COLX,
	/* U+4065 */	U2E_NODEST_COLX,
	/* U+4066 */	U2E_NODEST_COLX,
	/* U+4067 */	U2E_NODEST_COLX,
	/* U+4068 */	U2E_NODEST_COLX,
	/* U+4069 */	U2E_NODEST_COLX,
	/* U+406A */	U2E_NODEST_COLX,
	/* U+406B */	U2E_NODEST_COLX,
	/* U+406C */	U2E_NODEST_COLX,
	/* U+406D */	U2E_NODEST_COLX,
	/* U+406E */	U2E_NODEST_COLX,
	/* U+406F */	U2E_NODEST_COLX,
	/* U+4070 */	U2E_NODEST_COLX,
	/* U+4071 */	U2E_NODEST_COLX,
	/* U+4072 */	U2E_NODEST_COLX,
	/* U+4073 */	U2E_NODEST_COLX,
	/* U+4074 */	U2E_NODEST_COLX,
	/* U+4075 */	U2E_NODEST_COLX,
	/* U+4076 */	U2E_NODEST_COLX,
	/* U+4077 */	U2E_NODEST_COLX,
	/* U+4078 */	U2E_NODEST_COLX,
	/* U+4079 */	U2E_NODEST_COLX,
	/* U+407A */	U2E_NODEST_COLX,
	/* U+407B */	U2E_NODEST_COLX,
	/* U+407C */	U2E_NODEST_COLX,
	/* U+407D */	U2E_NODEST_COLX,
	/* U+407E */	U2E_NODEST_COLX,
	/* U+407F */	U2E_NODEST_COLX,
	/* U+4080 */	U2E_NODEST_COLX,
	/* U+4081 */	U2E_NODEST_COLX,
	/* U+4082 */	U2E_NODEST_COLX,
	/* U+4083 */	U2E_NODEST_COLX,
	/* U+4084 */	U2E_NODEST_COLX,
	/* U+4085 */	U2E_NODEST_COLX,
	/* U+4086 */	U2E_NODEST_COLX,
	/* U+4087 */	U2E_NODEST_COLX,
	/* U+4088 */	U2E_NODEST_COLX,
	/* U+4089 */	U2E_NODEST_COLX,
	/* U+408A */	U2E_NODEST_COLX,
	/* U+408B */	U2E_NODEST_COLX,
	/* U+408C */	U2E_NODEST_COLX,
	/* U+408D */	U2E_NODEST_COLX,
	/* U+408E */	U2E_NODEST_COLX,
	/* U+408F */	U2E_NODEST_COLX,
	/* U+4090 */	U2E_NODEST_COLX,
	/* U+4091 */	U2E_NODEST_COLX,
	/* U+4092 */	U2E_NODEST_COLX,
	/* U+4093 */	IFX0213(JISX0213_2(0xf239),	U2E_NODEST_COLX),
	/* U+4094 */	U2E_NODEST_COLX,
	/* U+4095 */	U2E_NODEST_COLX,
	/* U+4096 */	U2E_NODEST_COLX,
	/* U+4097 */	U2E_NODEST_COLX,
	/* U+4098 */	U2E_NODEST_COLX,
	/* U+4099 */	U2E_NODEST_COLX,
	/* U+409A */	U2E_NODEST_COLX,
	/* U+409B */	U2E_NODEST_COLX,
	/* U+409C */	U2E_NODEST_COLX,
	/* U+409D */	U2E_NODEST_COLX,
	/* U+409E */	U2E_NODEST_COLX,
	/* U+409F */	U2E_NODEST_COLX,
	/* U+40A0 */	U2E_NODEST_COLX,
	/* U+40A1 */	U2E_NODEST_COLX,
	/* U+40A2 */	U2E_NODEST_COLX,
	/* U+40A3 */	U2E_NODEST_COLX,
	/* U+40A4 */	U2E_NODEST_COLX,
	/* U+40A5 */	U2E_NODEST_COLX,
	/* U+40A6 */	U2E_NODEST_COLX,
	/* U+40A7 */	U2E_NODEST_COLX,
	/* U+40A8 */	U2E_NODEST_COLX,
	/* U+40A9 */	U2E_NODEST_COLX,
	/* U+40AA */	U2E_NODEST_COLX,
	/* U+40AB */	U2E_NODEST_COLX,
	/* U+40AC */	U2E_NODEST_COLX,
	/* U+40AD */	U2E_NODEST_COLX,
	/* U+40AE */	U2E_NODEST_COLX,
	/* U+40AF */	U2E_NODEST_COLX,
	/* U+40B0 */	U2E_NODEST_COLX,
	/* U+40B1 */	U2E_NODEST_COLX,
	/* U+40B2 */	U2E_NODEST_COLX,
	/* U+40B3 */	U2E_NODEST_COLX,
	/* U+40B4 */	U2E_NODEST_COLX,
	/* U+40B5 */	U2E_NODEST_COLX,
	/* U+40B6 */	U2E_NODEST_COLX,
	/* U+40B7 */	U2E_NODEST_COLX,
	/* U+40B8 */	U2E_NODEST_COLX,
	/* U+40B9 */	U2E_NODEST_COLX,
	/* U+40BA */	U2E_NODEST_COLX,
	/* U+40BB */	U2E_NODEST_COLX,
	/* U+40BC */	U2E_NODEST_COLX,
	/* U+40BD */	U2E_NODEST_COLX,
	/* U+40BE */	U2E_NODEST_COLX,
	/* U+40BF */	U2E_NODEST_COLX,
	/* U+40C0 */	U2E_NODEST_COLX,
	/* U+40C1 */	U2E_NODEST_COLX,
	/* U+40C2 */	U2E_NODEST_COLX,
	/* U+40C3 */	U2E_NODEST_COLX,
	/* U+40C4 */	U2E_NODEST_COLX,
	/* U+40C5 */	U2E_NODEST_COLX,
	/* U+40C6 */	U2E_NODEST_COLX,
	/* U+40C7 */	U2E_NODEST_COLX,
	/* U+40C8 */	U2E_NODEST_COLX,
	/* U+40C9 */	U2E_NODEST_COLX,
	/* U+40CA */	U2E_NODEST_COLX,
	/* U+40CB */	U2E_NODEST_COLX,
	/* U+40CC */	U2E_NODEST_COLX,
	/* U+40CD */	U2E_NODEST_COLX,
	/* U+40CE */	U2E_NODEST_COLX,
	/* U+40CF */	U2E_NODEST_COLX,
	/* U+40D0 */	U2E_NODEST_COLX,
	/* U+40D1 */	U2E_NODEST_COLX,
	/* U+40D2 */	U2E_NODEST_COLX,
	/* U+40D3 */	U2E_NODEST_COLX,
	/* U+40D4 */	U2E_NODEST_COLX,
	/* U+40D5 */	U2E_NODEST_COLX,
	/* U+40D6 */	U2E_NODEST_COLX,
	/* U+40D7 */	U2E_NODEST_COLX,
	/* U+40D8 */	U2E_NODEST_COLX,
	/* U+40D9 */	U2E_NODEST_COLX,
	/* U+40DA */	U2E_NODEST_COLX,
	/* U+40DB */	U2E_NODEST_COLX,
	/* U+40DC */	U2E_NODEST_COLX,
	/* U+40DD */	U2E_NODEST_COLX,
	/* U+40DE */	U2E_NODEST_COLX,
	/* U+40DF */	U2E_NODEST_COLX,
	/* U+40E0 */	U2E_NODEST_COLX,
	/* U+40E1 */	U2E_NODEST_COLX,
	/* U+40E2 */	U2E_NODEST_COLX,
	/* U+40E3 */	U2E_NODEST_COLX,
	/* U+40E4 */	U2E_NODEST_COLX,
	/* U+40E5 */	U2E_NODEST_COLX,
	/* U+40E6 */	U2E_NODEST_COLX,
	/* U+40E7 */	U2E_NODEST_COLX,
	/* U+40E8 */	U2E_NODEST_COLX,
	/* U+40E9 */	U2E_NODEST_COLX,
	/* U+40EA */	U2E_NODEST_COLX,
	/* U+40EB */	U2E_NODEST_COLX,
	/* U+40EC */	U2E_NODEST_COLX,
	/* U+40ED */	U2E_NODEST_COLX,
	/* U+40EE */	U2E_NODEST_COLX,
	/* U+40EF */	U2E_NODEST_COLX,
	/* U+40F0 */	U2E_NODEST_COLX,
	/* U+40F1 */	U2E_NODEST_COLX,
	/* U+40F2 */	U2E_NODEST_COLX,
	/* U+40F3 */	U2E_NODEST_COLX,
	/* U+40F4 */	U2E_NODEST_COLX,
	/* U+40F5 */	U2E_NODEST_COLX,
	/* U+40F6 */	U2E_NODEST_COLX,
	/* U+40F7 */	U2E_NODEST_COLX,
	/* U+40F8 */	U2E_NODEST_COLX,
	/* U+40F9 */	U2E_NODEST_COLX,
	/* U+40FA */	U2E_NODEST_COLX,
	/* U+40FB */	U2E_NODEST_COLX,
	/* U+40FC */	U2E_NODEST_COLX,
	/* U+40FD */	U2E_NODEST_COLX,
	/* U+40FE */	U2E_NODEST_COLX,
	/* U+40FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_41[] = {
	/* U+4100 */	U2E_NODEST_COLX,
	/* U+4101 */	U2E_NODEST_COLX,
	/* U+4102 */	U2E_NODEST_COLX,
	/* U+4103 */	U2E_NODEST_COLX,
	/* U+4104 */	U2E_NODEST_COLX,
	/* U+4105 */	IFX0213(JISX0213_2(0xf264),	U2E_NODEST_COLX),
	/* U+4106 */	U2E_NODEST_COLX,
	/* U+4107 */	U2E_NODEST_COLX,
	/* U+4108 */	U2E_NODEST_COLX,
	/* U+4109 */	U2E_NODEST_COLX,
	/* U+410A */	U2E_NODEST_COLX,
	/* U+410B */	U2E_NODEST_COLX,
	/* U+410C */	U2E_NODEST_COLX,
	/* U+410D */	U2E_NODEST_COLX,
	/* U+410E */	U2E_NODEST_COLX,
	/* U+410F */	U2E_NODEST_COLX,
	/* U+4110 */	U2E_NODEST_COLX,
	/* U+4111 */	U2E_NODEST_COLX,
	/* U+4112 */	U2E_NODEST_COLX,
	/* U+4113 */	U2E_NODEST_COLX,
	/* U+4114 */	U2E_NODEST_COLX,
	/* U+4115 */	U2E_NODEST_COLX,
	/* U+4116 */	U2E_NODEST_COLX,
	/* U+4117 */	U2E_NODEST_COLX,
	/* U+4118 */	U2E_NODEST_COLX,
	/* U+4119 */	U2E_NODEST_COLX,
	/* U+411A */	U2E_NODEST_COLX,
	/* U+411B */	U2E_NODEST_COLX,
	/* U+411C */	U2E_NODEST_COLX,
	/* U+411D */	U2E_NODEST_COLX,
	/* U+411E */	U2E_NODEST_COLX,
	/* U+411F */	U2E_NODEST_COLX,
	/* U+4120 */	U2E_NODEST_COLX,
	/* U+4121 */	U2E_NODEST_COLX,
	/* U+4122 */	U2E_NODEST_COLX,
	/* U+4123 */	U2E_NODEST_COLX,
	/* U+4124 */	U2E_NODEST_COLX,
	/* U+4125 */	U2E_NODEST_COLX,
	/* U+4126 */	U2E_NODEST_COLX,
	/* U+4127 */	U2E_NODEST_COLX,
	/* U+4128 */	U2E_NODEST_COLX,
	/* U+4129 */	U2E_NODEST_COLX,
	/* U+412A */	U2E_NODEST_COLX,
	/* U+412B */	U2E_NODEST_COLX,
	/* U+412C */	U2E_NODEST_COLX,
	/* U+412D */	U2E_NODEST_COLX,
	/* U+412E */	U2E_NODEST_COLX,
	/* U+412F */	U2E_NODEST_COLX,
	/* U+4130 */	U2E_NODEST_COLX,
	/* U+4131 */	U2E_NODEST_COLX,
	/* U+4132 */	U2E_NODEST_COLX,
	/* U+4133 */	U2E_NODEST_COLX,
	/* U+4134 */	U2E_NODEST_COLX,
	/* U+4135 */	U2E_NODEST_COLX,
	/* U+4136 */	U2E_NODEST_COLX,
	/* U+4137 */	U2E_NODEST_COLX,
	/* U+4138 */	U2E_NODEST_COLX,
	/* U+4139 */	U2E_NODEST_COLX,
	/* U+413A */	U2E_NODEST_COLX,
	/* U+413B */	U2E_NODEST_COLX,
	/* U+413C */	U2E_NODEST_COLX,
	/* U+413D */	U2E_NODEST_COLX,
	/* U+413E */	U2E_NODEST_COLX,
	/* U+413F */	U2E_NODEST_COLX,
	/* U+4140 */	U2E_NODEST_COLX,
	/* U+4141 */	U2E_NODEST_COLX,
	/* U+4142 */	U2E_NODEST_COLX,
	/* U+4143 */	U2E_NODEST_COLX,
	/* U+4144 */	U2E_NODEST_COLX,
	/* U+4145 */	U2E_NODEST_COLX,
	/* U+4146 */	U2E_NODEST_COLX,
	/* U+4147 */	U2E_NODEST_COLX,
	/* U+4148 */	IFX0213(JISX0213_2(0xf274),	U2E_NODEST_COLX),
	/* U+4149 */	U2E_NODEST_COLX,
	/* U+414A */	U2E_NODEST_COLX,
	/* U+414B */	U2E_NODEST_COLX,
	/* U+414C */	U2E_NODEST_COLX,
	/* U+414D */	U2E_NODEST_COLX,
	/* U+414E */	U2E_NODEST_COLX,
	/* U+414F */	IFX0213(JISX0213_2(0xf277),	U2E_NODEST_COLX),
	/* U+4150 */	U2E_NODEST_COLX,
	/* U+4151 */	U2E_NODEST_COLX,
	/* U+4152 */	U2E_NODEST_COLX,
	/* U+4153 */	U2E_NODEST_COLX,
	/* U+4154 */	U2E_NODEST_COLX,
	/* U+4155 */	U2E_NODEST_COLX,
	/* U+4156 */	U2E_NODEST_COLX,
	/* U+4157 */	U2E_NODEST_COLX,
	/* U+4158 */	U2E_NODEST_COLX,
	/* U+4159 */	U2E_NODEST_COLX,
	/* U+415A */	U2E_NODEST_COLX,
	/* U+415B */	U2E_NODEST_COLX,
	/* U+415C */	U2E_NODEST_COLX,
	/* U+415D */	U2E_NODEST_COLX,
	/* U+415E */	U2E_NODEST_COLX,
	/* U+415F */	U2E_NODEST_COLX,
	/* U+4160 */	U2E_NODEST_COLX,
	/* U+4161 */	U2E_NODEST_COLX,
	/* U+4162 */	U2E_NODEST_COLX,
	/* U+4163 */	IFX0213(JISX0213_2(0xf27d),	U2E_NODEST_COLX),
	/* U+4164 */	U2E_NODEST_COLX,
	/* U+4165 */	U2E_NODEST_COLX,
	/* U+4166 */	U2E_NODEST_COLX,
	/* U+4167 */	U2E_NODEST_COLX,
	/* U+4168 */	U2E_NODEST_COLX,
	/* U+4169 */	U2E_NODEST_COLX,
	/* U+416A */	U2E_NODEST_COLX,
	/* U+416B */	U2E_NODEST_COLX,
	/* U+416C */	U2E_NODEST_COLX,
	/* U+416D */	U2E_NODEST_COLX,
	/* U+416E */	U2E_NODEST_COLX,
	/* U+416F */	U2E_NODEST_COLX,
	/* U+4170 */	U2E_NODEST_COLX,
	/* U+4171 */	U2E_NODEST_COLX,
	/* U+4172 */	U2E_NODEST_COLX,
	/* U+4173 */	U2E_NODEST_COLX,
	/* U+4174 */	U2E_NODEST_COLX,
	/* U+4175 */	U2E_NODEST_COLX,
	/* U+4176 */	U2E_NODEST_COLX,
	/* U+4177 */	U2E_NODEST_COLX,
	/* U+4178 */	U2E_NODEST_COLX,
	/* U+4179 */	U2E_NODEST_COLX,
	/* U+417A */	U2E_NODEST_COLX,
	/* U+417B */	U2E_NODEST_COLX,
	/* U+417C */	U2E_NODEST_COLX,
	/* U+417D */	U2E_NODEST_COLX,
	/* U+417E */	U2E_NODEST_COLX,
	/* U+417F */	U2E_NODEST_COLX,
	/* U+4180 */	U2E_NODEST_COLX,
	/* U+4181 */	U2E_NODEST_COLX,
	/* U+4182 */	U2E_NODEST_COLX,
	/* U+4183 */	U2E_NODEST_COLX,
	/* U+4184 */	U2E_NODEST_COLX,
	/* U+4185 */	U2E_NODEST_COLX,
	/* U+4186 */	U2E_NODEST_COLX,
	/* U+4187 */	U2E_NODEST_COLX,
	/* U+4188 */	U2E_NODEST_COLX,
	/* U+4189 */	U2E_NODEST_COLX,
	/* U+418A */	U2E_NODEST_COLX,
	/* U+418B */	U2E_NODEST_COLX,
	/* U+418C */	U2E_NODEST_COLX,
	/* U+418D */	U2E_NODEST_COLX,
	/* U+418E */	U2E_NODEST_COLX,
	/* U+418F */	U2E_NODEST_COLX,
	/* U+4190 */	U2E_NODEST_COLX,
	/* U+4191 */	U2E_NODEST_COLX,
	/* U+4192 */	U2E_NODEST_COLX,
	/* U+4193 */	U2E_NODEST_COLX,
	/* U+4194 */	U2E_NODEST_COLX,
	/* U+4195 */	U2E_NODEST_COLX,
	/* U+4196 */	U2E_NODEST_COLX,
	/* U+4197 */	U2E_NODEST_COLX,
	/* U+4198 */	U2E_NODEST_COLX,
	/* U+4199 */	U2E_NODEST_COLX,
	/* U+419A */	U2E_NODEST_COLX,
	/* U+419B */	U2E_NODEST_COLX,
	/* U+419C */	U2E_NODEST_COLX,
	/* U+419D */	U2E_NODEST_COLX,
	/* U+419E */	U2E_NODEST_COLX,
	/* U+419F */	U2E_NODEST_COLX,
	/* U+41A0 */	U2E_NODEST_COLX,
	/* U+41A1 */	U2E_NODEST_COLX,
	/* U+41A2 */	U2E_NODEST_COLX,
	/* U+41A3 */	U2E_NODEST_COLX,
	/* U+41A4 */	U2E_NODEST_COLX,
	/* U+41A5 */	U2E_NODEST_COLX,
	/* U+41A6 */	U2E_NODEST_COLX,
	/* U+41A7 */	U2E_NODEST_COLX,
	/* U+41A8 */	U2E_NODEST_COLX,
	/* U+41A9 */	U2E_NODEST_COLX,
	/* U+41AA */	U2E_NODEST_COLX,
	/* U+41AB */	U2E_NODEST_COLX,
	/* U+41AC */	U2E_NODEST_COLX,
	/* U+41AD */	U2E_NODEST_COLX,
	/* U+41AE */	U2E_NODEST_COLX,
	/* U+41AF */	U2E_NODEST_COLX,
	/* U+41B0 */	U2E_NODEST_COLX,
	/* U+41B1 */	U2E_NODEST_COLX,
	/* U+41B2 */	U2E_NODEST_COLX,
	/* U+41B3 */	U2E_NODEST_COLX,
	/* U+41B4 */	IFX0213(JISX0213_2(0xf333),	U2E_NODEST_COLX),
	/* U+41B5 */	U2E_NODEST_COLX,
	/* U+41B6 */	U2E_NODEST_COLX,
	/* U+41B7 */	U2E_NODEST_COLX,
	/* U+41B8 */	U2E_NODEST_COLX,
	/* U+41B9 */	U2E_NODEST_COLX,
	/* U+41BA */	U2E_NODEST_COLX,
	/* U+41BB */	U2E_NODEST_COLX,
	/* U+41BC */	U2E_NODEST_COLX,
	/* U+41BD */	U2E_NODEST_COLX,
	/* U+41BE */	U2E_NODEST_COLX,
	/* U+41BF */	IFX0213(JISX0213_2(0xf337),	U2E_NODEST_COLX),
	/* U+41C0 */	U2E_NODEST_COLX,
	/* U+41C1 */	U2E_NODEST_COLX,
	/* U+41C2 */	U2E_NODEST_COLX,
	/* U+41C3 */	U2E_NODEST_COLX,
	/* U+41C4 */	U2E_NODEST_COLX,
	/* U+41C5 */	U2E_NODEST_COLX,
	/* U+41C6 */	U2E_NODEST_COLX,
	/* U+41C7 */	U2E_NODEST_COLX,
	/* U+41C8 */	U2E_NODEST_COLX,
	/* U+41C9 */	U2E_NODEST_COLX,
	/* U+41CA */	U2E_NODEST_COLX,
	/* U+41CB */	U2E_NODEST_COLX,
	/* U+41CC */	U2E_NODEST_COLX,
	/* U+41CD */	U2E_NODEST_COLX,
	/* U+41CE */	U2E_NODEST_COLX,
	/* U+41CF */	U2E_NODEST_COLX,
	/* U+41D0 */	U2E_NODEST_COLX,
	/* U+41D1 */	U2E_NODEST_COLX,
	/* U+41D2 */	U2E_NODEST_COLX,
	/* U+41D3 */	U2E_NODEST_COLX,
	/* U+41D4 */	U2E_NODEST_COLX,
	/* U+41D5 */	U2E_NODEST_COLX,
	/* U+41D6 */	U2E_NODEST_COLX,
	/* U+41D7 */	U2E_NODEST_COLX,
	/* U+41D8 */	U2E_NODEST_COLX,
	/* U+41D9 */	U2E_NODEST_COLX,
	/* U+41DA */	U2E_NODEST_COLX,
	/* U+41DB */	U2E_NODEST_COLX,
	/* U+41DC */	U2E_NODEST_COLX,
	/* U+41DD */	U2E_NODEST_COLX,
	/* U+41DE */	U2E_NODEST_COLX,
	/* U+41DF */	U2E_NODEST_COLX,
	/* U+41E0 */	U2E_NODEST_COLX,
	/* U+41E1 */	U2E_NODEST_COLX,
	/* U+41E2 */	U2E_NODEST_COLX,
	/* U+41E3 */	U2E_NODEST_COLX,
	/* U+41E4 */	U2E_NODEST_COLX,
	/* U+41E5 */	U2E_NODEST_COLX,
	/* U+41E6 */	IFX0213(JISX0213_2(0xf347),	U2E_NODEST_COLX),
	/* U+41E7 */	U2E_NODEST_COLX,
	/* U+41E8 */	U2E_NODEST_COLX,
	/* U+41E9 */	U2E_NODEST_COLX,
	/* U+41EA */	U2E_NODEST_COLX,
	/* U+41EB */	U2E_NODEST_COLX,
	/* U+41EC */	U2E_NODEST_COLX,
	/* U+41ED */	U2E_NODEST_COLX,
	/* U+41EE */	IFX0213(JISX0213_2(0xf34b),	U2E_NODEST_COLX),
	/* U+41EF */	U2E_NODEST_COLX,
	/* U+41F0 */	U2E_NODEST_COLX,
	/* U+41F1 */	U2E_NODEST_COLX,
	/* U+41F2 */	U2E_NODEST_COLX,
	/* U+41F3 */	IFX0213(JISX0213_2(0xf348),	U2E_NODEST_COLX),
	/* U+41F4 */	U2E_NODEST_COLX,
	/* U+41F5 */	U2E_NODEST_COLX,
	/* U+41F6 */	U2E_NODEST_COLX,
	/* U+41F7 */	U2E_NODEST_COLX,
	/* U+41F8 */	U2E_NODEST_COLX,
	/* U+41F9 */	U2E_NODEST_COLX,
	/* U+41FA */	U2E_NODEST_COLX,
	/* U+41FB */	U2E_NODEST_COLX,
	/* U+41FC */	U2E_NODEST_COLX,
	/* U+41FD */	U2E_NODEST_COLX,
	/* U+41FE */	U2E_NODEST_COLX,
	/* U+41FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_42[] = {
	/* U+4200 */	U2E_NODEST_COLX,
	/* U+4201 */	U2E_NODEST_COLX,
	/* U+4202 */	U2E_NODEST_COLX,
	/* U+4203 */	U2E_NODEST_COLX,
	/* U+4204 */	U2E_NODEST_COLX,
	/* U+4205 */	U2E_NODEST_COLX,
	/* U+4206 */	U2E_NODEST_COLX,
	/* U+4207 */	IFX0213(JISX0213_2(0xf353),	U2E_NODEST_COLX),
	/* U+4208 */	U2E_NODEST_COLX,
	/* U+4209 */	U2E_NODEST_COLX,
	/* U+420A */	U2E_NODEST_COLX,
	/* U+420B */	U2E_NODEST_COLX,
	/* U+420C */	U2E_NODEST_COLX,
	/* U+420D */	U2E_NODEST_COLX,
	/* U+420E */	IFX0213(JISX0213_2(0xf357),	U2E_NODEST_COLX),
	/* U+420F */	U2E_NODEST_COLX,
	/* U+4210 */	U2E_NODEST_COLX,
	/* U+4211 */	U2E_NODEST_COLX,
	/* U+4212 */	U2E_NODEST_COLX,
	/* U+4213 */	U2E_NODEST_COLX,
	/* U+4214 */	U2E_NODEST_COLX,
	/* U+4215 */	U2E_NODEST_COLX,
	/* U+4216 */	U2E_NODEST_COLX,
	/* U+4217 */	U2E_NODEST_COLX,
	/* U+4218 */	U2E_NODEST_COLX,
	/* U+4219 */	U2E_NODEST_COLX,
	/* U+421A */	U2E_NODEST_COLX,
	/* U+421B */	U2E_NODEST_COLX,
	/* U+421C */	U2E_NODEST_COLX,
	/* U+421D */	U2E_NODEST_COLX,
	/* U+421E */	U2E_NODEST_COLX,
	/* U+421F */	U2E_NODEST_COLX,
	/* U+4220 */	U2E_NODEST_COLX,
	/* U+4221 */	U2E_NODEST_COLX,
	/* U+4222 */	U2E_NODEST_COLX,
	/* U+4223 */	U2E_NODEST_COLX,
	/* U+4224 */	U2E_NODEST_COLX,
	/* U+4225 */	U2E_NODEST_COLX,
	/* U+4226 */	U2E_NODEST_COLX,
	/* U+4227 */	U2E_NODEST_COLX,
	/* U+4228 */	U2E_NODEST_COLX,
	/* U+4229 */	U2E_NODEST_COLX,
	/* U+422A */	U2E_NODEST_COLX,
	/* U+422B */	U2E_NODEST_COLX,
	/* U+422C */	U2E_NODEST_COLX,
	/* U+422D */	U2E_NODEST_COLX,
	/* U+422E */	U2E_NODEST_COLX,
	/* U+422F */	U2E_NODEST_COLX,
	/* U+4230 */	U2E_NODEST_COLX,
	/* U+4231 */	U2E_NODEST_COLX,
	/* U+4232 */	U2E_NODEST_COLX,
	/* U+4233 */	U2E_NODEST_COLX,
	/* U+4234 */	U2E_NODEST_COLX,
	/* U+4235 */	U2E_NODEST_COLX,
	/* U+4236 */	U2E_NODEST_COLX,
	/* U+4237 */	U2E_NODEST_COLX,
	/* U+4238 */	U2E_NODEST_COLX,
	/* U+4239 */	U2E_NODEST_COLX,
	/* U+423A */	U2E_NODEST_COLX,
	/* U+423B */	U2E_NODEST_COLX,
	/* U+423C */	U2E_NODEST_COLX,
	/* U+423D */	U2E_NODEST_COLX,
	/* U+423E */	U2E_NODEST_COLX,
	/* U+423F */	U2E_NODEST_COLX,
	/* U+4240 */	U2E_NODEST_COLX,
	/* U+4241 */	U2E_NODEST_COLX,
	/* U+4242 */	U2E_NODEST_COLX,
	/* U+4243 */	U2E_NODEST_COLX,
	/* U+4244 */	U2E_NODEST_COLX,
	/* U+4245 */	U2E_NODEST_COLX,
	/* U+4246 */	U2E_NODEST_COLX,
	/* U+4247 */	U2E_NODEST_COLX,
	/* U+4248 */	U2E_NODEST_COLX,
	/* U+4249 */	U2E_NODEST_COLX,
	/* U+424A */	U2E_NODEST_COLX,
	/* U+424B */	U2E_NODEST_COLX,
	/* U+424C */	U2E_NODEST_COLX,
	/* U+424D */	U2E_NODEST_COLX,
	/* U+424E */	U2E_NODEST_COLX,
	/* U+424F */	U2E_NODEST_COLX,
	/* U+4250 */	U2E_NODEST_COLX,
	/* U+4251 */	U2E_NODEST_COLX,
	/* U+4252 */	U2E_NODEST_COLX,
	/* U+4253 */	U2E_NODEST_COLX,
	/* U+4254 */	U2E_NODEST_COLX,
	/* U+4255 */	U2E_NODEST_COLX,
	/* U+4256 */	U2E_NODEST_COLX,
	/* U+4257 */	U2E_NODEST_COLX,
	/* U+4258 */	U2E_NODEST_COLX,
	/* U+4259 */	U2E_NODEST_COLX,
	/* U+425A */	U2E_NODEST_COLX,
	/* U+425B */	U2E_NODEST_COLX,
	/* U+425C */	U2E_NODEST_COLX,
	/* U+425D */	U2E_NODEST_COLX,
	/* U+425E */	U2E_NODEST_COLX,
	/* U+425F */	U2E_NODEST_COLX,
	/* U+4260 */	U2E_NODEST_COLX,
	/* U+4261 */	U2E_NODEST_COLX,
	/* U+4262 */	U2E_NODEST_COLX,
	/* U+4263 */	U2E_NODEST_COLX,
	/* U+4264 */	IFX0213(JISX0213_1(0xf9ed),	U2E_NODEST_COLX),
	/* U+4265 */	U2E_NODEST_COLX,
	/* U+4266 */	U2E_NODEST_COLX,
	/* U+4267 */	U2E_NODEST_COLX,
	/* U+4268 */	U2E_NODEST_COLX,
	/* U+4269 */	U2E_NODEST_COLX,
	/* U+426A */	U2E_NODEST_COLX,
	/* U+426B */	U2E_NODEST_COLX,
	/* U+426C */	U2E_NODEST_COLX,
	/* U+426D */	U2E_NODEST_COLX,
	/* U+426E */	U2E_NODEST_COLX,
	/* U+426F */	U2E_NODEST_COLX,
	/* U+4270 */	U2E_NODEST_COLX,
	/* U+4271 */	U2E_NODEST_COLX,
	/* U+4272 */	U2E_NODEST_COLX,
	/* U+4273 */	U2E_NODEST_COLX,
	/* U+4274 */	U2E_NODEST_COLX,
	/* U+4275 */	U2E_NODEST_COLX,
	/* U+4276 */	U2E_NODEST_COLX,
	/* U+4277 */	U2E_NODEST_COLX,
	/* U+4278 */	U2E_NODEST_COLX,
	/* U+4279 */	U2E_NODEST_COLX,
	/* U+427A */	U2E_NODEST_COLX,
	/* U+427B */	U2E_NODEST_COLX,
	/* U+427C */	U2E_NODEST_COLX,
	/* U+427D */	U2E_NODEST_COLX,
	/* U+427E */	U2E_NODEST_COLX,
	/* U+427F */	U2E_NODEST_COLX,
	/* U+4280 */	U2E_NODEST_COLX,
	/* U+4281 */	U2E_NODEST_COLX,
	/* U+4282 */	U2E_NODEST_COLX,
	/* U+4283 */	U2E_NODEST_COLX,
	/* U+4284 */	U2E_NODEST_COLX,
	/* U+4285 */	U2E_NODEST_COLX,
	/* U+4286 */	U2E_NODEST_COLX,
	/* U+4287 */	U2E_NODEST_COLX,
	/* U+4288 */	U2E_NODEST_COLX,
	/* U+4289 */	U2E_NODEST_COLX,
	/* U+428A */	U2E_NODEST_COLX,
	/* U+428B */	U2E_NODEST_COLX,
	/* U+428C */	U2E_NODEST_COLX,
	/* U+428D */	U2E_NODEST_COLX,
	/* U+428E */	U2E_NODEST_COLX,
	/* U+428F */	U2E_NODEST_COLX,
	/* U+4290 */	U2E_NODEST_COLX,
	/* U+4291 */	U2E_NODEST_COLX,
	/* U+4292 */	U2E_NODEST_COLX,
	/* U+4293 */	U2E_NODEST_COLX,
	/* U+4294 */	U2E_NODEST_COLX,
	/* U+4295 */	U2E_NODEST_COLX,
	/* U+4296 */	U2E_NODEST_COLX,
	/* U+4297 */	U2E_NODEST_COLX,
	/* U+4298 */	U2E_NODEST_COLX,
	/* U+4299 */	U2E_NODEST_COLX,
	/* U+429A */	U2E_NODEST_COLX,
	/* U+429B */	U2E_NODEST_COLX,
	/* U+429C */	U2E_NODEST_COLX,
	/* U+429D */	U2E_NODEST_COLX,
	/* U+429E */	U2E_NODEST_COLX,
	/* U+429F */	U2E_NODEST_COLX,
	/* U+42A0 */	U2E_NODEST_COLX,
	/* U+42A1 */	U2E_NODEST_COLX,
	/* U+42A2 */	U2E_NODEST_COLX,
	/* U+42A3 */	U2E_NODEST_COLX,
	/* U+42A4 */	U2E_NODEST_COLX,
	/* U+42A5 */	U2E_NODEST_COLX,
	/* U+42A6 */	U2E_NODEST_COLX,
	/* U+42A7 */	U2E_NODEST_COLX,
	/* U+42A8 */	U2E_NODEST_COLX,
	/* U+42A9 */	U2E_NODEST_COLX,
	/* U+42AA */	U2E_NODEST_COLX,
	/* U+42AB */	U2E_NODEST_COLX,
	/* U+42AC */	U2E_NODEST_COLX,
	/* U+42AD */	U2E_NODEST_COLX,
	/* U+42AE */	U2E_NODEST_COLX,
	/* U+42AF */	U2E_NODEST_COLX,
	/* U+42B0 */	U2E_NODEST_COLX,
	/* U+42B1 */	U2E_NODEST_COLX,
	/* U+42B2 */	U2E_NODEST_COLX,
	/* U+42B3 */	U2E_NODEST_COLX,
	/* U+42B4 */	U2E_NODEST_COLX,
	/* U+42B5 */	U2E_NODEST_COLX,
	/* U+42B6 */	U2E_NODEST_COLX,
	/* U+42B7 */	U2E_NODEST_COLX,
	/* U+42B8 */	U2E_NODEST_COLX,
	/* U+42B9 */	U2E_NODEST_COLX,
	/* U+42BA */	U2E_NODEST_COLX,
	/* U+42BB */	U2E_NODEST_COLX,
	/* U+42BC */	U2E_NODEST_COLX,
	/* U+42BD */	U2E_NODEST_COLX,
	/* U+42BE */	U2E_NODEST_COLX,
	/* U+42BF */	U2E_NODEST_COLX,
	/* U+42C0 */	U2E_NODEST_COLX,
	/* U+42C1 */	U2E_NODEST_COLX,
	/* U+42C2 */	U2E_NODEST_COLX,
	/* U+42C3 */	U2E_NODEST_COLX,
	/* U+42C4 */	U2E_NODEST_COLX,
	/* U+42C5 */	U2E_NODEST_COLX,
	/* U+42C6 */	IFX0213(JISX0213_2(0xf42b),	U2E_NODEST_COLX),
	/* U+42C7 */	U2E_NODEST_COLX,
	/* U+42C8 */	U2E_NODEST_COLX,
	/* U+42C9 */	U2E_NODEST_COLX,
	/* U+42CA */	U2E_NODEST_COLX,
	/* U+42CB */	U2E_NODEST_COLX,
	/* U+42CC */	U2E_NODEST_COLX,
	/* U+42CD */	U2E_NODEST_COLX,
	/* U+42CE */	U2E_NODEST_COLX,
	/* U+42CF */	U2E_NODEST_COLX,
	/* U+42D0 */	U2E_NODEST_COLX,
	/* U+42D1 */	U2E_NODEST_COLX,
	/* U+42D2 */	U2E_NODEST_COLX,
	/* U+42D3 */	U2E_NODEST_COLX,
	/* U+42D4 */	U2E_NODEST_COLX,
	/* U+42D5 */	U2E_NODEST_COLX,
	/* U+42D6 */	IFX0213(JISX0213_2(0xf436),	U2E_NODEST_COLX),
	/* U+42D7 */	U2E_NODEST_COLX,
	/* U+42D8 */	U2E_NODEST_COLX,
	/* U+42D9 */	U2E_NODEST_COLX,
	/* U+42DA */	U2E_NODEST_COLX,
	/* U+42DB */	U2E_NODEST_COLX,
	/* U+42DC */	U2E_NODEST_COLX,
	/* U+42DD */	IFX0213(JISX0213_2(0xf43b),	U2E_NODEST_COLX),
	/* U+42DE */	U2E_NODEST_COLX,
	/* U+42DF */	U2E_NODEST_COLX,
	/* U+42E0 */	U2E_NODEST_COLX,
	/* U+42E1 */	U2E_NODEST_COLX,
	/* U+42E2 */	U2E_NODEST_COLX,
	/* U+42E3 */	U2E_NODEST_COLX,
	/* U+42E4 */	U2E_NODEST_COLX,
	/* U+42E5 */	U2E_NODEST_COLX,
	/* U+42E6 */	U2E_NODEST_COLX,
	/* U+42E7 */	U2E_NODEST_COLX,
	/* U+42E8 */	U2E_NODEST_COLX,
	/* U+42E9 */	U2E_NODEST_COLX,
	/* U+42EA */	U2E_NODEST_COLX,
	/* U+42EB */	U2E_NODEST_COLX,
	/* U+42EC */	U2E_NODEST_COLX,
	/* U+42ED */	U2E_NODEST_COLX,
	/* U+42EE */	U2E_NODEST_COLX,
	/* U+42EF */	U2E_NODEST_COLX,
	/* U+42F0 */	U2E_NODEST_COLX,
	/* U+42F1 */	U2E_NODEST_COLX,
	/* U+42F2 */	U2E_NODEST_COLX,
	/* U+42F3 */	U2E_NODEST_COLX,
	/* U+42F4 */	U2E_NODEST_COLX,
	/* U+42F5 */	U2E_NODEST_COLX,
	/* U+42F6 */	U2E_NODEST_COLX,
	/* U+42F7 */	U2E_NODEST_COLX,
	/* U+42F8 */	U2E_NODEST_COLX,
	/* U+42F9 */	U2E_NODEST_COLX,
	/* U+42FA */	U2E_NODEST_COLX,
	/* U+42FB */	U2E_NODEST_COLX,
	/* U+42FC */	U2E_NODEST_COLX,
	/* U+42FD */	U2E_NODEST_COLX,
	/* U+42FE */	U2E_NODEST_COLX,
	/* U+42FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_43[] = {
	/* U+4300 */	U2E_NODEST_COLX,
	/* U+4301 */	U2E_NODEST_COLX,
	/* U+4302 */	IFX0213(JISX0213_2(0xf44e),	U2E_NODEST_COLX),
	/* U+4303 */	U2E_NODEST_COLX,
	/* U+4304 */	U2E_NODEST_COLX,
	/* U+4305 */	U2E_NODEST_COLX,
	/* U+4306 */	U2E_NODEST_COLX,
	/* U+4307 */	U2E_NODEST_COLX,
	/* U+4308 */	U2E_NODEST_COLX,
	/* U+4309 */	U2E_NODEST_COLX,
	/* U+430A */	U2E_NODEST_COLX,
	/* U+430B */	U2E_NODEST_COLX,
	/* U+430C */	U2E_NODEST_COLX,
	/* U+430D */	U2E_NODEST_COLX,
	/* U+430E */	U2E_NODEST_COLX,
	/* U+430F */	U2E_NODEST_COLX,
	/* U+4310 */	U2E_NODEST_COLX,
	/* U+4311 */	U2E_NODEST_COLX,
	/* U+4312 */	U2E_NODEST_COLX,
	/* U+4313 */	U2E_NODEST_COLX,
	/* U+4314 */	U2E_NODEST_COLX,
	/* U+4315 */	U2E_NODEST_COLX,
	/* U+4316 */	U2E_NODEST_COLX,
	/* U+4317 */	U2E_NODEST_COLX,
	/* U+4318 */	U2E_NODEST_COLX,
	/* U+4319 */	U2E_NODEST_COLX,
	/* U+431A */	U2E_NODEST_COLX,
	/* U+431B */	U2E_NODEST_COLX,
	/* U+431C */	U2E_NODEST_COLX,
	/* U+431D */	U2E_NODEST_COLX,
	/* U+431E */	U2E_NODEST_COLX,
	/* U+431F */	U2E_NODEST_COLX,
	/* U+4320 */	U2E_NODEST_COLX,
	/* U+4321 */	U2E_NODEST_COLX,
	/* U+4322 */	U2E_NODEST_COLX,
	/* U+4323 */	U2E_NODEST_COLX,
	/* U+4324 */	U2E_NODEST_COLX,
	/* U+4325 */	U2E_NODEST_COLX,
	/* U+4326 */	U2E_NODEST_COLX,
	/* U+4327 */	U2E_NODEST_COLX,
	/* U+4328 */	U2E_NODEST_COLX,
	/* U+4329 */	U2E_NODEST_COLX,
	/* U+432A */	U2E_NODEST_COLX,
	/* U+432B */	IFX0213(JISX0213_2(0xf45d),	U2E_NODEST_COLX),
	/* U+432C */	U2E_NODEST_COLX,
	/* U+432D */	U2E_NODEST_COLX,
	/* U+432E */	U2E_NODEST_COLX,
	/* U+432F */	U2E_NODEST_COLX,
	/* U+4330 */	U2E_NODEST_COLX,
	/* U+4331 */	U2E_NODEST_COLX,
	/* U+4332 */	U2E_NODEST_COLX,
	/* U+4333 */	U2E_NODEST_COLX,
	/* U+4334 */	U2E_NODEST_COLX,
	/* U+4335 */	U2E_NODEST_COLX,
	/* U+4336 */	U2E_NODEST_COLX,
	/* U+4337 */	U2E_NODEST_COLX,
	/* U+4338 */	U2E_NODEST_COLX,
	/* U+4339 */	U2E_NODEST_COLX,
	/* U+433A */	U2E_NODEST_COLX,
	/* U+433B */	U2E_NODEST_COLX,
	/* U+433C */	U2E_NODEST_COLX,
	/* U+433D */	U2E_NODEST_COLX,
	/* U+433E */	U2E_NODEST_COLX,
	/* U+433F */	U2E_NODEST_COLX,
	/* U+4340 */	U2E_NODEST_COLX,
	/* U+4341 */	U2E_NODEST_COLX,
	/* U+4342 */	U2E_NODEST_COLX,
	/* U+4343 */	IFX0213(JISX0213_2(0xf461),	U2E_NODEST_COLX),
	/* U+4344 */	U2E_NODEST_COLX,
	/* U+4345 */	U2E_NODEST_COLX,
	/* U+4346 */	U2E_NODEST_COLX,
	/* U+4347 */	U2E_NODEST_COLX,
	/* U+4348 */	U2E_NODEST_COLX,
	/* U+4349 */	U2E_NODEST_COLX,
	/* U+434A */	U2E_NODEST_COLX,
	/* U+434B */	U2E_NODEST_COLX,
	/* U+434C */	U2E_NODEST_COLX,
	/* U+434D */	U2E_NODEST_COLX,
	/* U+434E */	U2E_NODEST_COLX,
	/* U+434F */	U2E_NODEST_COLX,
	/* U+4350 */	U2E_NODEST_COLX,
	/* U+4351 */	U2E_NODEST_COLX,
	/* U+4352 */	U2E_NODEST_COLX,
	/* U+4353 */	U2E_NODEST_COLX,
	/* U+4354 */	U2E_NODEST_COLX,
	/* U+4355 */	U2E_NODEST_COLX,
	/* U+4356 */	U2E_NODEST_COLX,
	/* U+4357 */	U2E_NODEST_COLX,
	/* U+4358 */	U2E_NODEST_COLX,
	/* U+4359 */	U2E_NODEST_COLX,
	/* U+435A */	U2E_NODEST_COLX,
	/* U+435B */	U2E_NODEST_COLX,
	/* U+435C */	U2E_NODEST_COLX,
	/* U+435D */	U2E_NODEST_COLX,
	/* U+435E */	U2E_NODEST_COLX,
	/* U+435F */	U2E_NODEST_COLX,
	/* U+4360 */	U2E_NODEST_COLX,
	/* U+4361 */	U2E_NODEST_COLX,
	/* U+4362 */	U2E_NODEST_COLX,
	/* U+4363 */	U2E_NODEST_COLX,
	/* U+4364 */	U2E_NODEST_COLX,
	/* U+4365 */	U2E_NODEST_COLX,
	/* U+4366 */	U2E_NODEST_COLX,
	/* U+4367 */	U2E_NODEST_COLX,
	/* U+4368 */	U2E_NODEST_COLX,
	/* U+4369 */	U2E_NODEST_COLX,
	/* U+436A */	U2E_NODEST_COLX,
	/* U+436B */	U2E_NODEST_COLX,
	/* U+436C */	U2E_NODEST_COLX,
	/* U+436D */	U2E_NODEST_COLX,
	/* U+436E */	U2E_NODEST_COLX,
	/* U+436F */	U2E_NODEST_COLX,
	/* U+4370 */	U2E_NODEST_COLX,
	/* U+4371 */	U2E_NODEST_COLX,
	/* U+4372 */	U2E_NODEST_COLX,
	/* U+4373 */	U2E_NODEST_COLX,
	/* U+4374 */	U2E_NODEST_COLX,
	/* U+4375 */	U2E_NODEST_COLX,
	/* U+4376 */	U2E_NODEST_COLX,
	/* U+4377 */	U2E_NODEST_COLX,
	/* U+4378 */	U2E_NODEST_COLX,
	/* U+4379 */	U2E_NODEST_COLX,
	/* U+437A */	U2E_NODEST_COLX,
	/* U+437B */	U2E_NODEST_COLX,
	/* U+437C */	U2E_NODEST_COLX,
	/* U+437D */	U2E_NODEST_COLX,
	/* U+437E */	U2E_NODEST_COLX,
	/* U+437F */	U2E_NODEST_COLX,
	/* U+4380 */	U2E_NODEST_COLX,
	/* U+4381 */	U2E_NODEST_COLX,
	/* U+4382 */	U2E_NODEST_COLX,
	/* U+4383 */	U2E_NODEST_COLX,
	/* U+4384 */	U2E_NODEST_COLX,
	/* U+4385 */	U2E_NODEST_COLX,
	/* U+4386 */	U2E_NODEST_COLX,
	/* U+4387 */	U2E_NODEST_COLX,
	/* U+4388 */	U2E_NODEST_COLX,
	/* U+4389 */	U2E_NODEST_COLX,
	/* U+438A */	U2E_NODEST_COLX,
	/* U+438B */	U2E_NODEST_COLX,
	/* U+438C */	U2E_NODEST_COLX,
	/* U+438D */	U2E_NODEST_COLX,
	/* U+438E */	U2E_NODEST_COLX,
	/* U+438F */	U2E_NODEST_COLX,
	/* U+4390 */	U2E_NODEST_COLX,
	/* U+4391 */	U2E_NODEST_COLX,
	/* U+4392 */	U2E_NODEST_COLX,
	/* U+4393 */	U2E_NODEST_COLX,
	/* U+4394 */	U2E_NODEST_COLX,
	/* U+4395 */	U2E_NODEST_COLX,
	/* U+4396 */	U2E_NODEST_COLX,
	/* U+4397 */	U2E_NODEST_COLX,
	/* U+4398 */	U2E_NODEST_COLX,
	/* U+4399 */	U2E_NODEST_COLX,
	/* U+439A */	U2E_NODEST_COLX,
	/* U+439B */	U2E_NODEST_COLX,
	/* U+439C */	U2E_NODEST_COLX,
	/* U+439D */	U2E_NODEST_COLX,
	/* U+439E */	U2E_NODEST_COLX,
	/* U+439F */	U2E_NODEST_COLX,
	/* U+43A0 */	U2E_NODEST_COLX,
	/* U+43A1 */	U2E_NODEST_COLX,
	/* U+43A2 */	U2E_NODEST_COLX,
	/* U+43A3 */	U2E_NODEST_COLX,
	/* U+43A4 */	U2E_NODEST_COLX,
	/* U+43A5 */	U2E_NODEST_COLX,
	/* U+43A6 */	U2E_NODEST_COLX,
	/* U+43A7 */	U2E_NODEST_COLX,
	/* U+43A8 */	U2E_NODEST_COLX,
	/* U+43A9 */	U2E_NODEST_COLX,
	/* U+43AA */	U2E_NODEST_COLX,
	/* U+43AB */	U2E_NODEST_COLX,
	/* U+43AC */	U2E_NODEST_COLX,
	/* U+43AD */	U2E_NODEST_COLX,
	/* U+43AE */	U2E_NODEST_COLX,
	/* U+43AF */	U2E_NODEST_COLX,
	/* U+43B0 */	U2E_NODEST_COLX,
	/* U+43B1 */	U2E_NODEST_COLX,
	/* U+43B2 */	U2E_NODEST_COLX,
	/* U+43B3 */	U2E_NODEST_COLX,
	/* U+43B4 */	U2E_NODEST_COLX,
	/* U+43B5 */	U2E_NODEST_COLX,
	/* U+43B6 */	U2E_NODEST_COLX,
	/* U+43B7 */	U2E_NODEST_COLX,
	/* U+43B8 */	U2E_NODEST_COLX,
	/* U+43B9 */	U2E_NODEST_COLX,
	/* U+43BA */	U2E_NODEST_COLX,
	/* U+43BB */	U2E_NODEST_COLX,
	/* U+43BC */	U2E_NODEST_COLX,
	/* U+43BD */	U2E_NODEST_COLX,
	/* U+43BE */	U2E_NODEST_COLX,
	/* U+43BF */	U2E_NODEST_COLX,
	/* U+43C0 */	U2E_NODEST_COLX,
	/* U+43C1 */	U2E_NODEST_COLX,
	/* U+43C2 */	U2E_NODEST_COLX,
	/* U+43C3 */	U2E_NODEST_COLX,
	/* U+43C4 */	U2E_NODEST_COLX,
	/* U+43C5 */	U2E_NODEST_COLX,
	/* U+43C6 */	U2E_NODEST_COLX,
	/* U+43C7 */	U2E_NODEST_COLX,
	/* U+43C8 */	U2E_NODEST_COLX,
	/* U+43C9 */	U2E_NODEST_COLX,
	/* U+43CA */	U2E_NODEST_COLX,
	/* U+43CB */	U2E_NODEST_COLX,
	/* U+43CC */	U2E_NODEST_COLX,
	/* U+43CD */	U2E_NODEST_COLX,
	/* U+43CE */	U2E_NODEST_COLX,
	/* U+43CF */	U2E_NODEST_COLX,
	/* U+43D0 */	U2E_NODEST_COLX,
	/* U+43D1 */	U2E_NODEST_COLX,
	/* U+43D2 */	U2E_NODEST_COLX,
	/* U+43D3 */	U2E_NODEST_COLX,
	/* U+43D4 */	U2E_NODEST_COLX,
	/* U+43D5 */	U2E_NODEST_COLX,
	/* U+43D6 */	U2E_NODEST_COLX,
	/* U+43D7 */	U2E_NODEST_COLX,
	/* U+43D8 */	U2E_NODEST_COLX,
	/* U+43D9 */	U2E_NODEST_COLX,
	/* U+43DA */	U2E_NODEST_COLX,
	/* U+43DB */	U2E_NODEST_COLX,
	/* U+43DC */	U2E_NODEST_COLX,
	/* U+43DD */	U2E_NODEST_COLX,
	/* U+43DE */	U2E_NODEST_COLX,
	/* U+43DF */	U2E_NODEST_COLX,
	/* U+43E0 */	U2E_NODEST_COLX,
	/* U+43E1 */	U2E_NODEST_COLX,
	/* U+43E2 */	U2E_NODEST_COLX,
	/* U+43E3 */	U2E_NODEST_COLX,
	/* U+43E4 */	U2E_NODEST_COLX,
	/* U+43E5 */	U2E_NODEST_COLX,
	/* U+43E6 */	U2E_NODEST_COLX,
	/* U+43E7 */	U2E_NODEST_COLX,
	/* U+43E8 */	U2E_NODEST_COLX,
	/* U+43E9 */	U2E_NODEST_COLX,
	/* U+43EA */	U2E_NODEST_COLX,
	/* U+43EB */	U2E_NODEST_COLX,
	/* U+43EC */	U2E_NODEST_COLX,
	/* U+43ED */	U2E_NODEST_COLX,
	/* U+43EE */	IFX0213(JISX0213_2(0xf53e),	U2E_NODEST_COLX),
	/* U+43EF */	U2E_NODEST_COLX,
	/* U+43F0 */	IFX0213(JISX0213_2(0xf542),	U2E_NODEST_COLX),
	/* U+43F1 */	U2E_NODEST_COLX,
	/* U+43F2 */	U2E_NODEST_COLX,
	/* U+43F3 */	U2E_NODEST_COLX,
	/* U+43F4 */	U2E_NODEST_COLX,
	/* U+43F5 */	U2E_NODEST_COLX,
	/* U+43F6 */	U2E_NODEST_COLX,
	/* U+43F7 */	U2E_NODEST_COLX,
	/* U+43F8 */	U2E_NODEST_COLX,
	/* U+43F9 */	U2E_NODEST_COLX,
	/* U+43FA */	U2E_NODEST_COLX,
	/* U+43FB */	U2E_NODEST_COLX,
	/* U+43FC */	U2E_NODEST_COLX,
	/* U+43FD */	U2E_NODEST_COLX,
	/* U+43FE */	U2E_NODEST_COLX,
	/* U+43FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_44[] = {
	/* U+4400 */	U2E_NODEST_COLX,
	/* U+4401 */	U2E_NODEST_COLX,
	/* U+4402 */	U2E_NODEST_COLX,
	/* U+4403 */	U2E_NODEST_COLX,
	/* U+4404 */	U2E_NODEST_COLX,
	/* U+4405 */	U2E_NODEST_COLX,
	/* U+4406 */	U2E_NODEST_COLX,
	/* U+4407 */	U2E_NODEST_COLX,
	/* U+4408 */	IFX0213(JISX0213_2(0xf548),	U2E_NODEST_COLX),
	/* U+4409 */	U2E_NODEST_COLX,
	/* U+440A */	U2E_NODEST_COLX,
	/* U+440B */	U2E_NODEST_COLX,
	/* U+440C */	U2E_NODEST_COLX,
	/* U+440D */	U2E_NODEST_COLX,
	/* U+440E */	U2E_NODEST_COLX,
	/* U+440F */	U2E_NODEST_COLX,
	/* U+4410 */	U2E_NODEST_COLX,
	/* U+4411 */	U2E_NODEST_COLX,
	/* U+4412 */	U2E_NODEST_COLX,
	/* U+4413 */	U2E_NODEST_COLX,
	/* U+4414 */	U2E_NODEST_COLX,
	/* U+4415 */	U2E_NODEST_COLX,
	/* U+4416 */	U2E_NODEST_COLX,
	/* U+4417 */	IFX0213(JISX0213_2(0xf54a),	U2E_NODEST_COLX),
	/* U+4418 */	U2E_NODEST_COLX,
	/* U+4419 */	U2E_NODEST_COLX,
	/* U+441A */	U2E_NODEST_COLX,
	/* U+441B */	U2E_NODEST_COLX,
	/* U+441C */	IFX0213(JISX0213_2(0xf54c),	U2E_NODEST_COLX),
	/* U+441D */	U2E_NODEST_COLX,
	/* U+441E */	U2E_NODEST_COLX,
	/* U+441F */	U2E_NODEST_COLX,
	/* U+4420 */	U2E_NODEST_COLX,
	/* U+4421 */	U2E_NODEST_COLX,
	/* U+4422 */	IFX0213(JISX0213_2(0xf54f),	U2E_NODEST_COLX),
	/* U+4423 */	U2E_NODEST_COLX,
	/* U+4424 */	U2E_NODEST_COLX,
	/* U+4425 */	U2E_NODEST_COLX,
	/* U+4426 */	U2E_NODEST_COLX,
	/* U+4427 */	U2E_NODEST_COLX,
	/* U+4428 */	U2E_NODEST_COLX,
	/* U+4429 */	U2E_NODEST_COLX,
	/* U+442A */	U2E_NODEST_COLX,
	/* U+442B */	U2E_NODEST_COLX,
	/* U+442C */	U2E_NODEST_COLX,
	/* U+442D */	U2E_NODEST_COLX,
	/* U+442E */	U2E_NODEST_COLX,
	/* U+442F */	U2E_NODEST_COLX,
	/* U+4430 */	U2E_NODEST_COLX,
	/* U+4431 */	U2E_NODEST_COLX,
	/* U+4432 */	U2E_NODEST_COLX,
	/* U+4433 */	U2E_NODEST_COLX,
	/* U+4434 */	U2E_NODEST_COLX,
	/* U+4435 */	U2E_NODEST_COLX,
	/* U+4436 */	U2E_NODEST_COLX,
	/* U+4437 */	U2E_NODEST_COLX,
	/* U+4438 */	U2E_NODEST_COLX,
	/* U+4439 */	U2E_NODEST_COLX,
	/* U+443A */	U2E_NODEST_COLX,
	/* U+443B */	U2E_NODEST_COLX,
	/* U+443C */	U2E_NODEST_COLX,
	/* U+443D */	U2E_NODEST_COLX,
	/* U+443E */	U2E_NODEST_COLX,
	/* U+443F */	U2E_NODEST_COLX,
	/* U+4440 */	U2E_NODEST_COLX,
	/* U+4441 */	U2E_NODEST_COLX,
	/* U+4442 */	U2E_NODEST_COLX,
	/* U+4443 */	U2E_NODEST_COLX,
	/* U+4444 */	U2E_NODEST_COLX,
	/* U+4445 */	U2E_NODEST_COLX,
	/* U+4446 */	U2E_NODEST_COLX,
	/* U+4447 */	U2E_NODEST_COLX,
	/* U+4448 */	U2E_NODEST_COLX,
	/* U+4449 */	U2E_NODEST_COLX,
	/* U+444A */	U2E_NODEST_COLX,
	/* U+444B */	U2E_NODEST_COLX,
	/* U+444C */	U2E_NODEST_COLX,
	/* U+444D */	U2E_NODEST_COLX,
	/* U+444E */	U2E_NODEST_COLX,
	/* U+444F */	U2E_NODEST_COLX,
	/* U+4450 */	U2E_NODEST_COLX,
	/* U+4451 */	U2E_NODEST_COLX,
	/* U+4452 */	U2E_NODEST_COLX,
	/* U+4453 */	IFX0213(JISX0213_1(0xfad9),	U2E_NODEST_COLX),
	/* U+4454 */	U2E_NODEST_COLX,
	/* U+4455 */	U2E_NODEST_COLX,
	/* U+4456 */	U2E_NODEST_COLX,
	/* U+4457 */	U2E_NODEST_COLX,
	/* U+4458 */	U2E_NODEST_COLX,
	/* U+4459 */	U2E_NODEST_COLX,
	/* U+445A */	U2E_NODEST_COLX,
	/* U+445B */	IFX0213(JISX0213_1(0xfada),	U2E_NODEST_COLX),
	/* U+445C */	U2E_NODEST_COLX,
	/* U+445D */	U2E_NODEST_COLX,
	/* U+445E */	U2E_NODEST_COLX,
	/* U+445F */	U2E_NODEST_COLX,
	/* U+4460 */	U2E_NODEST_COLX,
	/* U+4461 */	U2E_NODEST_COLX,
	/* U+4462 */	U2E_NODEST_COLX,
	/* U+4463 */	U2E_NODEST_COLX,
	/* U+4464 */	U2E_NODEST_COLX,
	/* U+4465 */	U2E_NODEST_COLX,
	/* U+4466 */	U2E_NODEST_COLX,
	/* U+4467 */	U2E_NODEST_COLX,
	/* U+4468 */	U2E_NODEST_COLX,
	/* U+4469 */	U2E_NODEST_COLX,
	/* U+446A */	U2E_NODEST_COLX,
	/* U+446B */	U2E_NODEST_COLX,
	/* U+446C */	U2E_NODEST_COLX,
	/* U+446D */	U2E_NODEST_COLX,
	/* U+446E */	U2E_NODEST_COLX,
	/* U+446F */	U2E_NODEST_COLX,
	/* U+4470 */	U2E_NODEST_COLX,
	/* U+4471 */	U2E_NODEST_COLX,
	/* U+4472 */	U2E_NODEST_COLX,
	/* U+4473 */	U2E_NODEST_COLX,
	/* U+4474 */	U2E_NODEST_COLX,
	/* U+4475 */	U2E_NODEST_COLX,
	/* U+4476 */	IFX0213(JISX0213_2(0xf56c),	U2E_NODEST_COLX),
	/* U+4477 */	U2E_NODEST_COLX,
	/* U+4478 */	U2E_NODEST_COLX,
	/* U+4479 */	U2E_NODEST_COLX,
	/* U+447A */	IFX0213(JISX0213_2(0xf56e),	U2E_NODEST_COLX),
	/* U+447B */	U2E_NODEST_COLX,
	/* U+447C */	U2E_NODEST_COLX,
	/* U+447D */	U2E_NODEST_COLX,
	/* U+447E */	U2E_NODEST_COLX,
	/* U+447F */	U2E_NODEST_COLX,
	/* U+4480 */	U2E_NODEST_COLX,
	/* U+4481 */	U2E_NODEST_COLX,
	/* U+4482 */	U2E_NODEST_COLX,
	/* U+4483 */	U2E_NODEST_COLX,
	/* U+4484 */	U2E_NODEST_COLX,
	/* U+4485 */	U2E_NODEST_COLX,
	/* U+4486 */	U2E_NODEST_COLX,
	/* U+4487 */	U2E_NODEST_COLX,
	/* U+4488 */	U2E_NODEST_COLX,
	/* U+4489 */	U2E_NODEST_COLX,
	/* U+448A */	U2E_NODEST_COLX,
	/* U+448B */	U2E_NODEST_COLX,
	/* U+448C */	U2E_NODEST_COLX,
	/* U+448D */	U2E_NODEST_COLX,
	/* U+448E */	U2E_NODEST_COLX,
	/* U+448F */	U2E_NODEST_COLX,
	/* U+4490 */	U2E_NODEST_COLX,
	/* U+4491 */	IFX0213(JISX0213_2(0xf577),	U2E_NODEST_COLX),
	/* U+4492 */	U2E_NODEST_COLX,
	/* U+4493 */	U2E_NODEST_COLX,
	/* U+4494 */	U2E_NODEST_COLX,
	/* U+4495 */	U2E_NODEST_COLX,
	/* U+4496 */	U2E_NODEST_COLX,
	/* U+4497 */	U2E_NODEST_COLX,
	/* U+4498 */	U2E_NODEST_COLX,
	/* U+4499 */	U2E_NODEST_COLX,
	/* U+449A */	U2E_NODEST_COLX,
	/* U+449B */	U2E_NODEST_COLX,
	/* U+449C */	U2E_NODEST_COLX,
	/* U+449D */	U2E_NODEST_COLX,
	/* U+449E */	U2E_NODEST_COLX,
	/* U+449F */	U2E_NODEST_COLX,
	/* U+44A0 */	U2E_NODEST_COLX,
	/* U+44A1 */	U2E_NODEST_COLX,
	/* U+44A2 */	U2E_NODEST_COLX,
	/* U+44A3 */	U2E_NODEST_COLX,
	/* U+44A4 */	U2E_NODEST_COLX,
	/* U+44A5 */	U2E_NODEST_COLX,
	/* U+44A6 */	U2E_NODEST_COLX,
	/* U+44A7 */	U2E_NODEST_COLX,
	/* U+44A8 */	U2E_NODEST_COLX,
	/* U+44A9 */	U2E_NODEST_COLX,
	/* U+44AA */	U2E_NODEST_COLX,
	/* U+44AB */	U2E_NODEST_COLX,
	/* U+44AC */	U2E_NODEST_COLX,
	/* U+44AD */	U2E_NODEST_COLX,
	/* U+44AE */	U2E_NODEST_COLX,
	/* U+44AF */	U2E_NODEST_COLX,
	/* U+44B0 */	U2E_NODEST_COLX,
	/* U+44B1 */	U2E_NODEST_COLX,
	/* U+44B2 */	U2E_NODEST_COLX,
	/* U+44B3 */	IFX0213(JISX0213_2(0xf635),	U2E_NODEST_COLX),
	/* U+44B4 */	U2E_NODEST_COLX,
	/* U+44B5 */	U2E_NODEST_COLX,
	/* U+44B6 */	U2E_NODEST_COLX,
	/* U+44B7 */	U2E_NODEST_COLX,
	/* U+44B8 */	U2E_NODEST_COLX,
	/* U+44B9 */	U2E_NODEST_COLX,
	/* U+44BA */	U2E_NODEST_COLX,
	/* U+44BB */	U2E_NODEST_COLX,
	/* U+44BC */	U2E_NODEST_COLX,
	/* U+44BD */	U2E_NODEST_COLX,
	/* U+44BE */	IFX0213(JISX0213_2(0xf632),	U2E_NODEST_COLX),
	/* U+44BF */	U2E_NODEST_COLX,
	/* U+44C0 */	U2E_NODEST_COLX,
	/* U+44C1 */	U2E_NODEST_COLX,
	/* U+44C2 */	U2E_NODEST_COLX,
	/* U+44C3 */	U2E_NODEST_COLX,
	/* U+44C4 */	U2E_NODEST_COLX,
	/* U+44C5 */	U2E_NODEST_COLX,
	/* U+44C6 */	U2E_NODEST_COLX,
	/* U+44C7 */	U2E_NODEST_COLX,
	/* U+44C8 */	U2E_NODEST_COLX,
	/* U+44C9 */	U2E_NODEST_COLX,
	/* U+44CA */	U2E_NODEST_COLX,
	/* U+44CB */	U2E_NODEST_COLX,
	/* U+44CC */	U2E_NODEST_COLX,
	/* U+44CD */	U2E_NODEST_COLX,
	/* U+44CE */	U2E_NODEST_COLX,
	/* U+44CF */	U2E_NODEST_COLX,
	/* U+44D0 */	U2E_NODEST_COLX,
	/* U+44D1 */	U2E_NODEST_COLX,
	/* U+44D2 */	U2E_NODEST_COLX,
	/* U+44D3 */	U2E_NODEST_COLX,
	/* U+44D4 */	IFX0213(JISX0213_2(0xf634),	U2E_NODEST_COLX),
	/* U+44D5 */	U2E_NODEST_COLX,
	/* U+44D6 */	U2E_NODEST_COLX,
	/* U+44D7 */	U2E_NODEST_COLX,
	/* U+44D8 */	U2E_NODEST_COLX,
	/* U+44D9 */	U2E_NODEST_COLX,
	/* U+44DA */	U2E_NODEST_COLX,
	/* U+44DB */	U2E_NODEST_COLX,
	/* U+44DC */	U2E_NODEST_COLX,
	/* U+44DD */	U2E_NODEST_COLX,
	/* U+44DE */	U2E_NODEST_COLX,
	/* U+44DF */	U2E_NODEST_COLX,
	/* U+44E0 */	U2E_NODEST_COLX,
	/* U+44E1 */	U2E_NODEST_COLX,
	/* U+44E2 */	U2E_NODEST_COLX,
	/* U+44E3 */	U2E_NODEST_COLX,
	/* U+44E4 */	U2E_NODEST_COLX,
	/* U+44E5 */	U2E_NODEST_COLX,
	/* U+44E6 */	U2E_NODEST_COLX,
	/* U+44E7 */	U2E_NODEST_COLX,
	/* U+44E8 */	U2E_NODEST_COLX,
	/* U+44E9 */	U2E_NODEST_COLX,
	/* U+44EA */	U2E_NODEST_COLX,
	/* U+44EB */	U2E_NODEST_COLX,
	/* U+44EC */	U2E_NODEST_COLX,
	/* U+44ED */	U2E_NODEST_COLX,
	/* U+44EE */	U2E_NODEST_COLX,
	/* U+44EF */	U2E_NODEST_COLX,
	/* U+44F0 */	U2E_NODEST_COLX,
	/* U+44F1 */	U2E_NODEST_COLX,
	/* U+44F2 */	U2E_NODEST_COLX,
	/* U+44F3 */	U2E_NODEST_COLX,
	/* U+44F4 */	U2E_NODEST_COLX,
	/* U+44F5 */	U2E_NODEST_COLX,
	/* U+44F6 */	U2E_NODEST_COLX,
	/* U+44F7 */	U2E_NODEST_COLX,
	/* U+44F8 */	U2E_NODEST_COLX,
	/* U+44F9 */	U2E_NODEST_COLX,
	/* U+44FA */	U2E_NODEST_COLX,
	/* U+44FB */	U2E_NODEST_COLX,
	/* U+44FC */	U2E_NODEST_COLX,
	/* U+44FD */	U2E_NODEST_COLX,
	/* U+44FE */	U2E_NODEST_COLX,
	/* U+44FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_45[] = {
	/* U+4500 */	U2E_NODEST_COLX,
	/* U+4501 */	U2E_NODEST_COLX,
	/* U+4502 */	U2E_NODEST_COLX,
	/* U+4503 */	U2E_NODEST_COLX,
	/* U+4504 */	U2E_NODEST_COLX,
	/* U+4505 */	U2E_NODEST_COLX,
	/* U+4506 */	U2E_NODEST_COLX,
	/* U+4507 */	U2E_NODEST_COLX,
	/* U+4508 */	IFX0213(JISX0213_2(0xf659),	U2E_NODEST_COLX),
	/* U+4509 */	U2E_NODEST_COLX,
	/* U+450A */	U2E_NODEST_COLX,
	/* U+450B */	U2E_NODEST_COLX,
	/* U+450C */	U2E_NODEST_COLX,
	/* U+450D */	IFX0213(JISX0213_2(0xf654),	U2E_NODEST_COLX),
	/* U+450E */	U2E_NODEST_COLX,
	/* U+450F */	U2E_NODEST_COLX,
	/* U+4510 */	U2E_NODEST_COLX,
	/* U+4511 */	U2E_NODEST_COLX,
	/* U+4512 */	U2E_NODEST_COLX,
	/* U+4513 */	U2E_NODEST_COLX,
	/* U+4514 */	U2E_NODEST_COLX,
	/* U+4515 */	U2E_NODEST_COLX,
	/* U+4516 */	U2E_NODEST_COLX,
	/* U+4517 */	U2E_NODEST_COLX,
	/* U+4518 */	U2E_NODEST_COLX,
	/* U+4519 */	U2E_NODEST_COLX,
	/* U+451A */	U2E_NODEST_COLX,
	/* U+451B */	U2E_NODEST_COLX,
	/* U+451C */	U2E_NODEST_COLX,
	/* U+451D */	U2E_NODEST_COLX,
	/* U+451E */	U2E_NODEST_COLX,
	/* U+451F */	U2E_NODEST_COLX,
	/* U+4520 */	U2E_NODEST_COLX,
	/* U+4521 */	U2E_NODEST_COLX,
	/* U+4522 */	U2E_NODEST_COLX,
	/* U+4523 */	U2E_NODEST_COLX,
	/* U+4524 */	U2E_NODEST_COLX,
	/* U+4525 */	IFX0213(JISX0213_2(0xf66d),	U2E_NODEST_COLX),
	/* U+4526 */	U2E_NODEST_COLX,
	/* U+4527 */	U2E_NODEST_COLX,
	/* U+4528 */	U2E_NODEST_COLX,
	/* U+4529 */	U2E_NODEST_COLX,
	/* U+452A */	U2E_NODEST_COLX,
	/* U+452B */	U2E_NODEST_COLX,
	/* U+452C */	U2E_NODEST_COLX,
	/* U+452D */	U2E_NODEST_COLX,
	/* U+452E */	U2E_NODEST_COLX,
	/* U+452F */	U2E_NODEST_COLX,
	/* U+4530 */	U2E_NODEST_COLX,
	/* U+4531 */	U2E_NODEST_COLX,
	/* U+4532 */	U2E_NODEST_COLX,
	/* U+4533 */	U2E_NODEST_COLX,
	/* U+4534 */	U2E_NODEST_COLX,
	/* U+4535 */	U2E_NODEST_COLX,
	/* U+4536 */	U2E_NODEST_COLX,
	/* U+4537 */	U2E_NODEST_COLX,
	/* U+4538 */	U2E_NODEST_COLX,
	/* U+4539 */	U2E_NODEST_COLX,
	/* U+453A */	U2E_NODEST_COLX,
	/* U+453B */	U2E_NODEST_COLX,
	/* U+453C */	U2E_NODEST_COLX,
	/* U+453D */	U2E_NODEST_COLX,
	/* U+453E */	U2E_NODEST_COLX,
	/* U+453F */	U2E_NODEST_COLX,
	/* U+4540 */	U2E_NODEST_COLX,
	/* U+4541 */	U2E_NODEST_COLX,
	/* U+4542 */	U2E_NODEST_COLX,
	/* U+4543 */	IFX0213(JISX0213_2(0xf66e),	U2E_NODEST_COLX),
	/* U+4544 */	U2E_NODEST_COLX,
	/* U+4545 */	U2E_NODEST_COLX,
	/* U+4546 */	U2E_NODEST_COLX,
	/* U+4547 */	U2E_NODEST_COLX,
	/* U+4548 */	U2E_NODEST_COLX,
	/* U+4549 */	U2E_NODEST_COLX,
	/* U+454A */	U2E_NODEST_COLX,
	/* U+454B */	U2E_NODEST_COLX,
	/* U+454C */	U2E_NODEST_COLX,
	/* U+454D */	U2E_NODEST_COLX,
	/* U+454E */	U2E_NODEST_COLX,
	/* U+454F */	U2E_NODEST_COLX,
	/* U+4550 */	U2E_NODEST_COLX,
	/* U+4551 */	U2E_NODEST_COLX,
	/* U+4552 */	U2E_NODEST_COLX,
	/* U+4553 */	U2E_NODEST_COLX,
	/* U+4554 */	U2E_NODEST_COLX,
	/* U+4555 */	U2E_NODEST_COLX,
	/* U+4556 */	U2E_NODEST_COLX,
	/* U+4557 */	U2E_NODEST_COLX,
	/* U+4558 */	U2E_NODEST_COLX,
	/* U+4559 */	U2E_NODEST_COLX,
	/* U+455A */	U2E_NODEST_COLX,
	/* U+455B */	U2E_NODEST_COLX,
	/* U+455C */	U2E_NODEST_COLX,
	/* U+455D */	U2E_NODEST_COLX,
	/* U+455E */	U2E_NODEST_COLX,
	/* U+455F */	U2E_NODEST_COLX,
	/* U+4560 */	U2E_NODEST_COLX,
	/* U+4561 */	U2E_NODEST_COLX,
	/* U+4562 */	U2E_NODEST_COLX,
	/* U+4563 */	U2E_NODEST_COLX,
	/* U+4564 */	U2E_NODEST_COLX,
	/* U+4565 */	U2E_NODEST_COLX,
	/* U+4566 */	U2E_NODEST_COLX,
	/* U+4567 */	U2E_NODEST_COLX,
	/* U+4568 */	U2E_NODEST_COLX,
	/* U+4569 */	U2E_NODEST_COLX,
	/* U+456A */	U2E_NODEST_COLX,
	/* U+456B */	U2E_NODEST_COLX,
	/* U+456C */	U2E_NODEST_COLX,
	/* U+456D */	U2E_NODEST_COLX,
	/* U+456E */	U2E_NODEST_COLX,
	/* U+456F */	U2E_NODEST_COLX,
	/* U+4570 */	U2E_NODEST_COLX,
	/* U+4571 */	U2E_NODEST_COLX,
	/* U+4572 */	U2E_NODEST_COLX,
	/* U+4573 */	U2E_NODEST_COLX,
	/* U+4574 */	U2E_NODEST_COLX,
	/* U+4575 */	U2E_NODEST_COLX,
	/* U+4576 */	U2E_NODEST_COLX,
	/* U+4577 */	U2E_NODEST_COLX,
	/* U+4578 */	U2E_NODEST_COLX,
	/* U+4579 */	U2E_NODEST_COLX,
	/* U+457A */	U2E_NODEST_COLX,
	/* U+457B */	U2E_NODEST_COLX,
	/* U+457C */	U2E_NODEST_COLX,
	/* U+457D */	U2E_NODEST_COLX,
	/* U+457E */	U2E_NODEST_COLX,
	/* U+457F */	U2E_NODEST_COLX,
	/* U+4580 */	U2E_NODEST_COLX,
	/* U+4581 */	U2E_NODEST_COLX,
	/* U+4582 */	U2E_NODEST_COLX,
	/* U+4583 */	U2E_NODEST_COLX,
	/* U+4584 */	U2E_NODEST_COLX,
	/* U+4585 */	U2E_NODEST_COLX,
	/* U+4586 */	U2E_NODEST_COLX,
	/* U+4587 */	U2E_NODEST_COLX,
	/* U+4588 */	U2E_NODEST_COLX,
	/* U+4589 */	U2E_NODEST_COLX,
	/* U+458A */	U2E_NODEST_COLX,
	/* U+458B */	U2E_NODEST_COLX,
	/* U+458C */	U2E_NODEST_COLX,
	/* U+458D */	U2E_NODEST_COLX,
	/* U+458E */	U2E_NODEST_COLX,
	/* U+458F */	U2E_NODEST_COLX,
	/* U+4590 */	U2E_NODEST_COLX,
	/* U+4591 */	U2E_NODEST_COLX,
	/* U+4592 */	U2E_NODEST_COLX,
	/* U+4593 */	U2E_NODEST_COLX,
	/* U+4594 */	U2E_NODEST_COLX,
	/* U+4595 */	U2E_NODEST_COLX,
	/* U+4596 */	U2E_NODEST_COLX,
	/* U+4597 */	U2E_NODEST_COLX,
	/* U+4598 */	U2E_NODEST_COLX,
	/* U+4599 */	U2E_NODEST_COLX,
	/* U+459A */	U2E_NODEST_COLX,
	/* U+459B */	U2E_NODEST_COLX,
	/* U+459C */	U2E_NODEST_COLX,
	/* U+459D */	IFX0213(JISX0213_1(0xfbd1),	U2E_NODEST_COLX),
	/* U+459E */	U2E_NODEST_COLX,
	/* U+459F */	U2E_NODEST_COLX,
	/* U+45A0 */	U2E_NODEST_COLX,
	/* U+45A1 */	U2E_NODEST_COLX,
	/* U+45A2 */	U2E_NODEST_COLX,
	/* U+45A3 */	U2E_NODEST_COLX,
	/* U+45A4 */	U2E_NODEST_COLX,
	/* U+45A5 */	U2E_NODEST_COLX,
	/* U+45A6 */	U2E_NODEST_COLX,
	/* U+45A7 */	U2E_NODEST_COLX,
	/* U+45A8 */	U2E_NODEST_COLX,
	/* U+45A9 */	U2E_NODEST_COLX,
	/* U+45AA */	U2E_NODEST_COLX,
	/* U+45AB */	U2E_NODEST_COLX,
	/* U+45AC */	U2E_NODEST_COLX,
	/* U+45AD */	U2E_NODEST_COLX,
	/* U+45AE */	U2E_NODEST_COLX,
	/* U+45AF */	U2E_NODEST_COLX,
	/* U+45B0 */	U2E_NODEST_COLX,
	/* U+45B1 */	U2E_NODEST_COLX,
	/* U+45B2 */	U2E_NODEST_COLX,
	/* U+45B3 */	U2E_NODEST_COLX,
	/* U+45B4 */	U2E_NODEST_COLX,
	/* U+45B5 */	U2E_NODEST_COLX,
	/* U+45B6 */	U2E_NODEST_COLX,
	/* U+45B7 */	U2E_NODEST_COLX,
	/* U+45B8 */	IFX0213(JISX0213_2(0xf74f),	U2E_NODEST_COLX),
	/* U+45B9 */	U2E_NODEST_COLX,
	/* U+45BA */	U2E_NODEST_COLX,
	/* U+45BB */	U2E_NODEST_COLX,
	/* U+45BC */	U2E_NODEST_COLX,
	/* U+45BD */	U2E_NODEST_COLX,
	/* U+45BE */	U2E_NODEST_COLX,
	/* U+45BF */	U2E_NODEST_COLX,
	/* U+45C0 */	U2E_NODEST_COLX,
	/* U+45C1 */	U2E_NODEST_COLX,
	/* U+45C2 */	U2E_NODEST_COLX,
	/* U+45C3 */	U2E_NODEST_COLX,
	/* U+45C4 */	U2E_NODEST_COLX,
	/* U+45C5 */	U2E_NODEST_COLX,
	/* U+45C6 */	U2E_NODEST_COLX,
	/* U+45C7 */	U2E_NODEST_COLX,
	/* U+45C8 */	U2E_NODEST_COLX,
	/* U+45C9 */	U2E_NODEST_COLX,
	/* U+45CA */	U2E_NODEST_COLX,
	/* U+45CB */	U2E_NODEST_COLX,
	/* U+45CC */	U2E_NODEST_COLX,
	/* U+45CD */	U2E_NODEST_COLX,
	/* U+45CE */	U2E_NODEST_COLX,
	/* U+45CF */	U2E_NODEST_COLX,
	/* U+45D0 */	U2E_NODEST_COLX,
	/* U+45D1 */	U2E_NODEST_COLX,
	/* U+45D2 */	U2E_NODEST_COLX,
	/* U+45D3 */	U2E_NODEST_COLX,
	/* U+45D4 */	U2E_NODEST_COLX,
	/* U+45D5 */	U2E_NODEST_COLX,
	/* U+45D6 */	U2E_NODEST_COLX,
	/* U+45D7 */	U2E_NODEST_COLX,
	/* U+45D8 */	U2E_NODEST_COLX,
	/* U+45D9 */	U2E_NODEST_COLX,
	/* U+45DA */	U2E_NODEST_COLX,
	/* U+45DB */	U2E_NODEST_COLX,
	/* U+45DC */	U2E_NODEST_COLX,
	/* U+45DD */	U2E_NODEST_COLX,
	/* U+45DE */	U2E_NODEST_COLX,
	/* U+45DF */	U2E_NODEST_COLX,
	/* U+45E0 */	U2E_NODEST_COLX,
	/* U+45E1 */	U2E_NODEST_COLX,
	/* U+45E2 */	U2E_NODEST_COLX,
	/* U+45E3 */	U2E_NODEST_COLX,
	/* U+45E4 */	U2E_NODEST_COLX,
	/* U+45E5 */	IFX0213(JISX0213_2(0xf76c),	U2E_NODEST_COLX),
	/* U+45E6 */	U2E_NODEST_COLX,
	/* U+45E7 */	U2E_NODEST_COLX,
	/* U+45E8 */	U2E_NODEST_COLX,
	/* U+45E9 */	U2E_NODEST_COLX,
	/* U+45EA */	IFX0213(JISX0213_1(0xfbe0),	U2E_NODEST_COLX),
	/* U+45EB */	U2E_NODEST_COLX,
	/* U+45EC */	U2E_NODEST_COLX,
	/* U+45ED */	U2E_NODEST_COLX,
	/* U+45EE */	U2E_NODEST_COLX,
	/* U+45EF */	U2E_NODEST_COLX,
	/* U+45F0 */	U2E_NODEST_COLX,
	/* U+45F1 */	U2E_NODEST_COLX,
	/* U+45F2 */	U2E_NODEST_COLX,
	/* U+45F3 */	U2E_NODEST_COLX,
	/* U+45F4 */	U2E_NODEST_COLX,
	/* U+45F5 */	U2E_NODEST_COLX,
	/* U+45F6 */	U2E_NODEST_COLX,
	/* U+45F7 */	U2E_NODEST_COLX,
	/* U+45F8 */	U2E_NODEST_COLX,
	/* U+45F9 */	U2E_NODEST_COLX,
	/* U+45FA */	U2E_NODEST_COLX,
	/* U+45FB */	U2E_NODEST_COLX,
	/* U+45FC */	U2E_NODEST_COLX,
	/* U+45FD */	U2E_NODEST_COLX,
	/* U+45FE */	U2E_NODEST_COLX,
	/* U+45FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_46[] = {
	/* U+4600 */	U2E_NODEST_COLX,
	/* U+4601 */	U2E_NODEST_COLX,
	/* U+4602 */	U2E_NODEST_COLX,
	/* U+4603 */	U2E_NODEST_COLX,
	/* U+4604 */	U2E_NODEST_COLX,
	/* U+4605 */	U2E_NODEST_COLX,
	/* U+4606 */	U2E_NODEST_COLX,
	/* U+4607 */	U2E_NODEST_COLX,
	/* U+4608 */	U2E_NODEST_COLX,
	/* U+4609 */	U2E_NODEST_COLX,
	/* U+460A */	U2E_NODEST_COLX,
	/* U+460B */	U2E_NODEST_COLX,
	/* U+460C */	U2E_NODEST_COLX,
	/* U+460D */	U2E_NODEST_COLX,
	/* U+460E */	U2E_NODEST_COLX,
	/* U+460F */	IFX0213(JISX0213_2(0xf824),	U2E_NODEST_COLX),
	/* U+4610 */	U2E_NODEST_COLX,
	/* U+4611 */	U2E_NODEST_COLX,
	/* U+4612 */	U2E_NODEST_COLX,
	/* U+4613 */	U2E_NODEST_COLX,
	/* U+4614 */	U2E_NODEST_COLX,
	/* U+4615 */	U2E_NODEST_COLX,
	/* U+4616 */	U2E_NODEST_COLX,
	/* U+4617 */	U2E_NODEST_COLX,
	/* U+4618 */	U2E_NODEST_COLX,
	/* U+4619 */	U2E_NODEST_COLX,
	/* U+461A */	U2E_NODEST_COLX,
	/* U+461B */	U2E_NODEST_COLX,
	/* U+461C */	U2E_NODEST_COLX,
	/* U+461D */	U2E_NODEST_COLX,
	/* U+461E */	U2E_NODEST_COLX,
	/* U+461F */	U2E_NODEST_COLX,
	/* U+4620 */	U2E_NODEST_COLX,
	/* U+4621 */	U2E_NODEST_COLX,
	/* U+4622 */	U2E_NODEST_COLX,
	/* U+4623 */	U2E_NODEST_COLX,
	/* U+4624 */	U2E_NODEST_COLX,
	/* U+4625 */	U2E_NODEST_COLX,
	/* U+4626 */	U2E_NODEST_COLX,
	/* U+4627 */	U2E_NODEST_COLX,
	/* U+4628 */	U2E_NODEST_COLX,
	/* U+4629 */	U2E_NODEST_COLX,
	/* U+462A */	U2E_NODEST_COLX,
	/* U+462B */	U2E_NODEST_COLX,
	/* U+462C */	U2E_NODEST_COLX,
	/* U+462D */	U2E_NODEST_COLX,
	/* U+462E */	U2E_NODEST_COLX,
	/* U+462F */	U2E_NODEST_COLX,
	/* U+4630 */	U2E_NODEST_COLX,
	/* U+4631 */	U2E_NODEST_COLX,
	/* U+4632 */	U2E_NODEST_COLX,
	/* U+4633 */	U2E_NODEST_COLX,
	/* U+4634 */	U2E_NODEST_COLX,
	/* U+4635 */	U2E_NODEST_COLX,
	/* U+4636 */	U2E_NODEST_COLX,
	/* U+4637 */	U2E_NODEST_COLX,
	/* U+4638 */	U2E_NODEST_COLX,
	/* U+4639 */	U2E_NODEST_COLX,
	/* U+463A */	U2E_NODEST_COLX,
	/* U+463B */	U2E_NODEST_COLX,
	/* U+463C */	U2E_NODEST_COLX,
	/* U+463D */	U2E_NODEST_COLX,
	/* U+463E */	U2E_NODEST_COLX,
	/* U+463F */	U2E_NODEST_COLX,
	/* U+4640 */	U2E_NODEST_COLX,
	/* U+4641 */	IFX0213(JISX0213_2(0xf83a),	U2E_NODEST_COLX),
	/* U+4642 */	U2E_NODEST_COLX,
	/* U+4643 */	U2E_NODEST_COLX,
	/* U+4644 */	U2E_NODEST_COLX,
	/* U+4645 */	U2E_NODEST_COLX,
	/* U+4646 */	U2E_NODEST_COLX,
	/* U+4647 */	U2E_NODEST_COLX,
	/* U+4648 */	U2E_NODEST_COLX,
	/* U+4649 */	U2E_NODEST_COLX,
	/* U+464A */	U2E_NODEST_COLX,
	/* U+464B */	U2E_NODEST_COLX,
	/* U+464C */	U2E_NODEST_COLX,
	/* U+464D */	U2E_NODEST_COLX,
	/* U+464E */	U2E_NODEST_COLX,
	/* U+464F */	U2E_NODEST_COLX,
	/* U+4650 */	U2E_NODEST_COLX,
	/* U+4651 */	U2E_NODEST_COLX,
	/* U+4652 */	U2E_NODEST_COLX,
	/* U+4653 */	U2E_NODEST_COLX,
	/* U+4654 */	U2E_NODEST_COLX,
	/* U+4655 */	U2E_NODEST_COLX,
	/* U+4656 */	U2E_NODEST_COLX,
	/* U+4657 */	U2E_NODEST_COLX,
	/* U+4658 */	U2E_NODEST_COLX,
	/* U+4659 */	U2E_NODEST_COLX,
	/* U+465A */	U2E_NODEST_COLX,
	/* U+465B */	U2E_NODEST_COLX,
	/* U+465C */	U2E_NODEST_COLX,
	/* U+465D */	U2E_NODEST_COLX,
	/* U+465E */	U2E_NODEST_COLX,
	/* U+465F */	U2E_NODEST_COLX,
	/* U+4660 */	U2E_NODEST_COLX,
	/* U+4661 */	U2E_NODEST_COLX,
	/* U+4662 */	U2E_NODEST_COLX,
	/* U+4663 */	U2E_NODEST_COLX,
	/* U+4664 */	U2E_NODEST_COLX,
	/* U+4665 */	IFX0213(JISX0213_2(0xf843),	U2E_NODEST_COLX),
	/* U+4666 */	U2E_NODEST_COLX,
	/* U+4667 */	U2E_NODEST_COLX,
	/* U+4668 */	U2E_NODEST_COLX,
	/* U+4669 */	U2E_NODEST_COLX,
	/* U+466A */	U2E_NODEST_COLX,
	/* U+466B */	U2E_NODEST_COLX,
	/* U+466C */	U2E_NODEST_COLX,
	/* U+466D */	U2E_NODEST_COLX,
	/* U+466E */	U2E_NODEST_COLX,
	/* U+466F */	U2E_NODEST_COLX,
	/* U+4670 */	U2E_NODEST_COLX,
	/* U+4671 */	U2E_NODEST_COLX,
	/* U+4672 */	U2E_NODEST_COLX,
	/* U+4673 */	U2E_NODEST_COLX,
	/* U+4674 */	U2E_NODEST_COLX,
	/* U+4675 */	U2E_NODEST_COLX,
	/* U+4676 */	U2E_NODEST_COLX,
	/* U+4677 */	U2E_NODEST_COLX,
	/* U+4678 */	U2E_NODEST_COLX,
	/* U+4679 */	U2E_NODEST_COLX,
	/* U+467A */	U2E_NODEST_COLX,
	/* U+467B */	U2E_NODEST_COLX,
	/* U+467C */	U2E_NODEST_COLX,
	/* U+467D */	U2E_NODEST_COLX,
	/* U+467E */	U2E_NODEST_COLX,
	/* U+467F */	U2E_NODEST_COLX,
	/* U+4680 */	U2E_NODEST_COLX,
	/* U+4681 */	U2E_NODEST_COLX,
	/* U+4682 */	U2E_NODEST_COLX,
	/* U+4683 */	U2E_NODEST_COLX,
	/* U+4684 */	U2E_NODEST_COLX,
	/* U+4685 */	U2E_NODEST_COLX,
	/* U+4686 */	U2E_NODEST_COLX,
	/* U+4687 */	U2E_NODEST_COLX,
	/* U+4688 */	U2E_NODEST_COLX,
	/* U+4689 */	U2E_NODEST_COLX,
	/* U+468A */	U2E_NODEST_COLX,
	/* U+468B */	U2E_NODEST_COLX,
	/* U+468C */	U2E_NODEST_COLX,
	/* U+468D */	U2E_NODEST_COLX,
	/* U+468E */	U2E_NODEST_COLX,
	/* U+468F */	U2E_NODEST_COLX,
	/* U+4690 */	U2E_NODEST_COLX,
	/* U+4691 */	U2E_NODEST_COLX,
	/* U+4692 */	U2E_NODEST_COLX,
	/* U+4693 */	U2E_NODEST_COLX,
	/* U+4694 */	U2E_NODEST_COLX,
	/* U+4695 */	U2E_NODEST_COLX,
	/* U+4696 */	U2E_NODEST_COLX,
	/* U+4697 */	U2E_NODEST_COLX,
	/* U+4698 */	U2E_NODEST_COLX,
	/* U+4699 */	U2E_NODEST_COLX,
	/* U+469A */	U2E_NODEST_COLX,
	/* U+469B */	U2E_NODEST_COLX,
	/* U+469C */	U2E_NODEST_COLX,
	/* U+469D */	U2E_NODEST_COLX,
	/* U+469E */	U2E_NODEST_COLX,
	/* U+469F */	U2E_NODEST_COLX,
	/* U+46A0 */	U2E_NODEST_COLX,
	/* U+46A1 */	IFX0213(JISX0213_2(0xf84e),	U2E_NODEST_COLX),
	/* U+46A2 */	U2E_NODEST_COLX,
	/* U+46A3 */	U2E_NODEST_COLX,
	/* U+46A4 */	U2E_NODEST_COLX,
	/* U+46A5 */	U2E_NODEST_COLX,
	/* U+46A6 */	U2E_NODEST_COLX,
	/* U+46A7 */	U2E_NODEST_COLX,
	/* U+46A8 */	U2E_NODEST_COLX,
	/* U+46A9 */	U2E_NODEST_COLX,
	/* U+46AA */	U2E_NODEST_COLX,
	/* U+46AB */	U2E_NODEST_COLX,
	/* U+46AC */	U2E_NODEST_COLX,
	/* U+46AD */	U2E_NODEST_COLX,
	/* U+46AE */	U2E_NODEST_COLX,
	/* U+46AF */	IFX0213(JISX0213_2(0xf853),	U2E_NODEST_COLX),
	/* U+46B0 */	U2E_NODEST_COLX,
	/* U+46B1 */	U2E_NODEST_COLX,
	/* U+46B2 */	U2E_NODEST_COLX,
	/* U+46B3 */	U2E_NODEST_COLX,
	/* U+46B4 */	U2E_NODEST_COLX,
	/* U+46B5 */	U2E_NODEST_COLX,
	/* U+46B6 */	U2E_NODEST_COLX,
	/* U+46B7 */	U2E_NODEST_COLX,
	/* U+46B8 */	U2E_NODEST_COLX,
	/* U+46B9 */	U2E_NODEST_COLX,
	/* U+46BA */	U2E_NODEST_COLX,
	/* U+46BB */	U2E_NODEST_COLX,
	/* U+46BC */	U2E_NODEST_COLX,
	/* U+46BD */	U2E_NODEST_COLX,
	/* U+46BE */	U2E_NODEST_COLX,
	/* U+46BF */	U2E_NODEST_COLX,
	/* U+46C0 */	U2E_NODEST_COLX,
	/* U+46C1 */	U2E_NODEST_COLX,
	/* U+46C2 */	U2E_NODEST_COLX,
	/* U+46C3 */	U2E_NODEST_COLX,
	/* U+46C4 */	U2E_NODEST_COLX,
	/* U+46C5 */	U2E_NODEST_COLX,
	/* U+46C6 */	U2E_NODEST_COLX,
	/* U+46C7 */	U2E_NODEST_COLX,
	/* U+46C8 */	U2E_NODEST_COLX,
	/* U+46C9 */	U2E_NODEST_COLX,
	/* U+46CA */	U2E_NODEST_COLX,
	/* U+46CB */	U2E_NODEST_COLX,
	/* U+46CC */	U2E_NODEST_COLX,
	/* U+46CD */	U2E_NODEST_COLX,
	/* U+46CE */	U2E_NODEST_COLX,
	/* U+46CF */	U2E_NODEST_COLX,
	/* U+46D0 */	U2E_NODEST_COLX,
	/* U+46D1 */	U2E_NODEST_COLX,
	/* U+46D2 */	U2E_NODEST_COLX,
	/* U+46D3 */	U2E_NODEST_COLX,
	/* U+46D4 */	U2E_NODEST_COLX,
	/* U+46D5 */	U2E_NODEST_COLX,
	/* U+46D6 */	U2E_NODEST_COLX,
	/* U+46D7 */	U2E_NODEST_COLX,
	/* U+46D8 */	U2E_NODEST_COLX,
	/* U+46D9 */	U2E_NODEST_COLX,
	/* U+46DA */	U2E_NODEST_COLX,
	/* U+46DB */	U2E_NODEST_COLX,
	/* U+46DC */	U2E_NODEST_COLX,
	/* U+46DD */	U2E_NODEST_COLX,
	/* U+46DE */	U2E_NODEST_COLX,
	/* U+46DF */	U2E_NODEST_COLX,
	/* U+46E0 */	U2E_NODEST_COLX,
	/* U+46E1 */	U2E_NODEST_COLX,
	/* U+46E2 */	U2E_NODEST_COLX,
	/* U+46E3 */	U2E_NODEST_COLX,
	/* U+46E4 */	U2E_NODEST_COLX,
	/* U+46E5 */	U2E_NODEST_COLX,
	/* U+46E6 */	U2E_NODEST_COLX,
	/* U+46E7 */	U2E_NODEST_COLX,
	/* U+46E8 */	U2E_NODEST_COLX,
	/* U+46E9 */	U2E_NODEST_COLX,
	/* U+46EA */	U2E_NODEST_COLX,
	/* U+46EB */	U2E_NODEST_COLX,
	/* U+46EC */	U2E_NODEST_COLX,
	/* U+46ED */	U2E_NODEST_COLX,
	/* U+46EE */	U2E_NODEST_COLX,
	/* U+46EF */	U2E_NODEST_COLX,
	/* U+46F0 */	U2E_NODEST_COLX,
	/* U+46F1 */	U2E_NODEST_COLX,
	/* U+46F2 */	U2E_NODEST_COLX,
	/* U+46F3 */	U2E_NODEST_COLX,
	/* U+46F4 */	U2E_NODEST_COLX,
	/* U+46F5 */	U2E_NODEST_COLX,
	/* U+46F6 */	U2E_NODEST_COLX,
	/* U+46F7 */	U2E_NODEST_COLX,
	/* U+46F8 */	U2E_NODEST_COLX,
	/* U+46F9 */	U2E_NODEST_COLX,
	/* U+46FA */	U2E_NODEST_COLX,
	/* U+46FB */	U2E_NODEST_COLX,
	/* U+46FC */	U2E_NODEST_COLX,
	/* U+46FD */	U2E_NODEST_COLX,
	/* U+46FE */	U2E_NODEST_COLX,
	/* U+46FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_47[] = {
	/* U+4700 */	U2E_NODEST_COLX,
	/* U+4701 */	U2E_NODEST_COLX,
	/* U+4702 */	U2E_NODEST_COLX,
	/* U+4703 */	U2E_NODEST_COLX,
	/* U+4704 */	U2E_NODEST_COLX,
	/* U+4705 */	U2E_NODEST_COLX,
	/* U+4706 */	U2E_NODEST_COLX,
	/* U+4707 */	U2E_NODEST_COLX,
	/* U+4708 */	U2E_NODEST_COLX,
	/* U+4709 */	U2E_NODEST_COLX,
	/* U+470A */	U2E_NODEST_COLX,
	/* U+470B */	U2E_NODEST_COLX,
	/* U+470C */	IFX0213(JISX0213_2(0xf86b),	U2E_NODEST_COLX),
	/* U+470D */	U2E_NODEST_COLX,
	/* U+470E */	U2E_NODEST_COLX,
	/* U+470F */	U2E_NODEST_COLX,
	/* U+4710 */	U2E_NODEST_COLX,
	/* U+4711 */	U2E_NODEST_COLX,
	/* U+4712 */	U2E_NODEST_COLX,
	/* U+4713 */	U2E_NODEST_COLX,
	/* U+4714 */	U2E_NODEST_COLX,
	/* U+4715 */	U2E_NODEST_COLX,
	/* U+4716 */	U2E_NODEST_COLX,
	/* U+4717 */	U2E_NODEST_COLX,
	/* U+4718 */	U2E_NODEST_COLX,
	/* U+4719 */	U2E_NODEST_COLX,
	/* U+471A */	U2E_NODEST_COLX,
	/* U+471B */	U2E_NODEST_COLX,
	/* U+471C */	U2E_NODEST_COLX,
	/* U+471D */	U2E_NODEST_COLX,
	/* U+471E */	U2E_NODEST_COLX,
	/* U+471F */	U2E_NODEST_COLX,
	/* U+4720 */	U2E_NODEST_COLX,
	/* U+4721 */	U2E_NODEST_COLX,
	/* U+4722 */	U2E_NODEST_COLX,
	/* U+4723 */	U2E_NODEST_COLX,
	/* U+4724 */	U2E_NODEST_COLX,
	/* U+4725 */	U2E_NODEST_COLX,
	/* U+4726 */	U2E_NODEST_COLX,
	/* U+4727 */	U2E_NODEST_COLX,
	/* U+4728 */	U2E_NODEST_COLX,
	/* U+4729 */	U2E_NODEST_COLX,
	/* U+472A */	U2E_NODEST_COLX,
	/* U+472B */	U2E_NODEST_COLX,
	/* U+472C */	U2E_NODEST_COLX,
	/* U+472D */	U2E_NODEST_COLX,
	/* U+472E */	U2E_NODEST_COLX,
	/* U+472F */	U2E_NODEST_COLX,
	/* U+4730 */	U2E_NODEST_COLX,
	/* U+4731 */	U2E_NODEST_COLX,
	/* U+4732 */	U2E_NODEST_COLX,
	/* U+4733 */	U2E_NODEST_COLX,
	/* U+4734 */	U2E_NODEST_COLX,
	/* U+4735 */	U2E_NODEST_COLX,
	/* U+4736 */	U2E_NODEST_COLX,
	/* U+4737 */	U2E_NODEST_COLX,
	/* U+4738 */	U2E_NODEST_COLX,
	/* U+4739 */	U2E_NODEST_COLX,
	/* U+473A */	U2E_NODEST_COLX,
	/* U+473B */	U2E_NODEST_COLX,
	/* U+473C */	U2E_NODEST_COLX,
	/* U+473D */	U2E_NODEST_COLX,
	/* U+473E */	U2E_NODEST_COLX,
	/* U+473F */	U2E_NODEST_COLX,
	/* U+4740 */	U2E_NODEST_COLX,
	/* U+4741 */	U2E_NODEST_COLX,
	/* U+4742 */	U2E_NODEST_COLX,
	/* U+4743 */	U2E_NODEST_COLX,
	/* U+4744 */	U2E_NODEST_COLX,
	/* U+4745 */	U2E_NODEST_COLX,
	/* U+4746 */	U2E_NODEST_COLX,
	/* U+4747 */	U2E_NODEST_COLX,
	/* U+4748 */	U2E_NODEST_COLX,
	/* U+4749 */	U2E_NODEST_COLX,
	/* U+474A */	U2E_NODEST_COLX,
	/* U+474B */	U2E_NODEST_COLX,
	/* U+474C */	U2E_NODEST_COLX,
	/* U+474D */	U2E_NODEST_COLX,
	/* U+474E */	U2E_NODEST_COLX,
	/* U+474F */	U2E_NODEST_COLX,
	/* U+4750 */	U2E_NODEST_COLX,
	/* U+4751 */	U2E_NODEST_COLX,
	/* U+4752 */	U2E_NODEST_COLX,
	/* U+4753 */	U2E_NODEST_COLX,
	/* U+4754 */	U2E_NODEST_COLX,
	/* U+4755 */	U2E_NODEST_COLX,
	/* U+4756 */	U2E_NODEST_COLX,
	/* U+4757 */	U2E_NODEST_COLX,
	/* U+4758 */	U2E_NODEST_COLX,
	/* U+4759 */	U2E_NODEST_COLX,
	/* U+475A */	U2E_NODEST_COLX,
	/* U+475B */	U2E_NODEST_COLX,
	/* U+475C */	U2E_NODEST_COLX,
	/* U+475D */	U2E_NODEST_COLX,
	/* U+475E */	U2E_NODEST_COLX,
	/* U+475F */	U2E_NODEST_COLX,
	/* U+4760 */	U2E_NODEST_COLX,
	/* U+4761 */	U2E_NODEST_COLX,
	/* U+4762 */	U2E_NODEST_COLX,
	/* U+4763 */	U2E_NODEST_COLX,
	/* U+4764 */	IFX0213(JISX0213_2(0xf929),	U2E_NODEST_COLX),
	/* U+4765 */	U2E_NODEST_COLX,
	/* U+4766 */	U2E_NODEST_COLX,
	/* U+4767 */	U2E_NODEST_COLX,
	/* U+4768 */	U2E_NODEST_COLX,
	/* U+4769 */	U2E_NODEST_COLX,
	/* U+476A */	U2E_NODEST_COLX,
	/* U+476B */	U2E_NODEST_COLX,
	/* U+476C */	U2E_NODEST_COLX,
	/* U+476D */	U2E_NODEST_COLX,
	/* U+476E */	U2E_NODEST_COLX,
	/* U+476F */	U2E_NODEST_COLX,
	/* U+4770 */	U2E_NODEST_COLX,
	/* U+4771 */	U2E_NODEST_COLX,
	/* U+4772 */	U2E_NODEST_COLX,
	/* U+4773 */	U2E_NODEST_COLX,
	/* U+4774 */	U2E_NODEST_COLX,
	/* U+4775 */	U2E_NODEST_COLX,
	/* U+4776 */	U2E_NODEST_COLX,
	/* U+4777 */	U2E_NODEST_COLX,
	/* U+4778 */	U2E_NODEST_COLX,
	/* U+4779 */	U2E_NODEST_COLX,
	/* U+477A */	U2E_NODEST_COLX,
	/* U+477B */	U2E_NODEST_COLX,
	/* U+477C */	U2E_NODEST_COLX,
	/* U+477D */	U2E_NODEST_COLX,
	/* U+477E */	U2E_NODEST_COLX,
	/* U+477F */	U2E_NODEST_COLX,
	/* U+4780 */	U2E_NODEST_COLX,
	/* U+4781 */	U2E_NODEST_COLX,
	/* U+4782 */	U2E_NODEST_COLX,
	/* U+4783 */	U2E_NODEST_COLX,
	/* U+4784 */	U2E_NODEST_COLX,
	/* U+4785 */	U2E_NODEST_COLX,
	/* U+4786 */	U2E_NODEST_COLX,
	/* U+4787 */	U2E_NODEST_COLX,
	/* U+4788 */	U2E_NODEST_COLX,
	/* U+4789 */	U2E_NODEST_COLX,
	/* U+478A */	U2E_NODEST_COLX,
	/* U+478B */	U2E_NODEST_COLX,
	/* U+478C */	U2E_NODEST_COLX,
	/* U+478D */	U2E_NODEST_COLX,
	/* U+478E */	U2E_NODEST_COLX,
	/* U+478F */	U2E_NODEST_COLX,
	/* U+4790 */	U2E_NODEST_COLX,
	/* U+4791 */	U2E_NODEST_COLX,
	/* U+4792 */	U2E_NODEST_COLX,
	/* U+4793 */	U2E_NODEST_COLX,
	/* U+4794 */	U2E_NODEST_COLX,
	/* U+4795 */	U2E_NODEST_COLX,
	/* U+4796 */	U2E_NODEST_COLX,
	/* U+4797 */	U2E_NODEST_COLX,
	/* U+4798 */	U2E_NODEST_COLX,
	/* U+4799 */	U2E_NODEST_COLX,
	/* U+479A */	U2E_NODEST_COLX,
	/* U+479B */	U2E_NODEST_COLX,
	/* U+479C */	U2E_NODEST_COLX,
	/* U+479D */	U2E_NODEST_COLX,
	/* U+479E */	U2E_NODEST_COLX,
	/* U+479F */	U2E_NODEST_COLX,
	/* U+47A0 */	U2E_NODEST_COLX,
	/* U+47A1 */	U2E_NODEST_COLX,
	/* U+47A2 */	U2E_NODEST_COLX,
	/* U+47A3 */	U2E_NODEST_COLX,
	/* U+47A4 */	U2E_NODEST_COLX,
	/* U+47A5 */	U2E_NODEST_COLX,
	/* U+47A6 */	U2E_NODEST_COLX,
	/* U+47A7 */	U2E_NODEST_COLX,
	/* U+47A8 */	U2E_NODEST_COLX,
	/* U+47A9 */	U2E_NODEST_COLX,
	/* U+47AA */	U2E_NODEST_COLX,
	/* U+47AB */	U2E_NODEST_COLX,
	/* U+47AC */	U2E_NODEST_COLX,
	/* U+47AD */	U2E_NODEST_COLX,
	/* U+47AE */	U2E_NODEST_COLX,
	/* U+47AF */	U2E_NODEST_COLX,
	/* U+47B0 */	U2E_NODEST_COLX,
	/* U+47B1 */	U2E_NODEST_COLX,
	/* U+47B2 */	U2E_NODEST_COLX,
	/* U+47B3 */	U2E_NODEST_COLX,
	/* U+47B4 */	U2E_NODEST_COLX,
	/* U+47B5 */	U2E_NODEST_COLX,
	/* U+47B6 */	U2E_NODEST_COLX,
	/* U+47B7 */	U2E_NODEST_COLX,
	/* U+47B8 */	U2E_NODEST_COLX,
	/* U+47B9 */	U2E_NODEST_COLX,
	/* U+47BA */	U2E_NODEST_COLX,
	/* U+47BB */	U2E_NODEST_COLX,
	/* U+47BC */	U2E_NODEST_COLX,
	/* U+47BD */	U2E_NODEST_COLX,
	/* U+47BE */	U2E_NODEST_COLX,
	/* U+47BF */	U2E_NODEST_COLX,
	/* U+47C0 */	U2E_NODEST_COLX,
	/* U+47C1 */	U2E_NODEST_COLX,
	/* U+47C2 */	U2E_NODEST_COLX,
	/* U+47C3 */	U2E_NODEST_COLX,
	/* U+47C4 */	U2E_NODEST_COLX,
	/* U+47C5 */	U2E_NODEST_COLX,
	/* U+47C6 */	U2E_NODEST_COLX,
	/* U+47C7 */	U2E_NODEST_COLX,
	/* U+47C8 */	U2E_NODEST_COLX,
	/* U+47C9 */	U2E_NODEST_COLX,
	/* U+47CA */	U2E_NODEST_COLX,
	/* U+47CB */	U2E_NODEST_COLX,
	/* U+47CC */	U2E_NODEST_COLX,
	/* U+47CD */	U2E_NODEST_COLX,
	/* U+47CE */	U2E_NODEST_COLX,
	/* U+47CF */	U2E_NODEST_COLX,
	/* U+47D0 */	U2E_NODEST_COLX,
	/* U+47D1 */	U2E_NODEST_COLX,
	/* U+47D2 */	U2E_NODEST_COLX,
	/* U+47D3 */	U2E_NODEST_COLX,
	/* U+47D4 */	U2E_NODEST_COLX,
	/* U+47D5 */	U2E_NODEST_COLX,
	/* U+47D6 */	U2E_NODEST_COLX,
	/* U+47D7 */	U2E_NODEST_COLX,
	/* U+47D8 */	U2E_NODEST_COLX,
	/* U+47D9 */	U2E_NODEST_COLX,
	/* U+47DA */	U2E_NODEST_COLX,
	/* U+47DB */	U2E_NODEST_COLX,
	/* U+47DC */	U2E_NODEST_COLX,
	/* U+47DD */	U2E_NODEST_COLX,
	/* U+47DE */	U2E_NODEST_COLX,
	/* U+47DF */	U2E_NODEST_COLX,
	/* U+47E0 */	U2E_NODEST_COLX,
	/* U+47E1 */	U2E_NODEST_COLX,
	/* U+47E2 */	U2E_NODEST_COLX,
	/* U+47E3 */	U2E_NODEST_COLX,
	/* U+47E4 */	U2E_NODEST_COLX,
	/* U+47E5 */	U2E_NODEST_COLX,
	/* U+47E6 */	U2E_NODEST_COLX,
	/* U+47E7 */	U2E_NODEST_COLX,
	/* U+47E8 */	U2E_NODEST_COLX,
	/* U+47E9 */	U2E_NODEST_COLX,
	/* U+47EA */	U2E_NODEST_COLX,
	/* U+47EB */	U2E_NODEST_COLX,
	/* U+47EC */	U2E_NODEST_COLX,
	/* U+47ED */	U2E_NODEST_COLX,
	/* U+47EE */	U2E_NODEST_COLX,
	/* U+47EF */	U2E_NODEST_COLX,
	/* U+47F0 */	U2E_NODEST_COLX,
	/* U+47F1 */	U2E_NODEST_COLX,
	/* U+47F2 */	U2E_NODEST_COLX,
	/* U+47F3 */	U2E_NODEST_COLX,
	/* U+47F4 */	U2E_NODEST_COLX,
	/* U+47F5 */	U2E_NODEST_COLX,
	/* U+47F6 */	U2E_NODEST_COLX,
	/* U+47F7 */	U2E_NODEST_COLX,
	/* U+47F8 */	U2E_NODEST_COLX,
	/* U+47F9 */	U2E_NODEST_COLX,
	/* U+47FA */	U2E_NODEST_COLX,
	/* U+47FB */	U2E_NODEST_COLX,
	/* U+47FC */	U2E_NODEST_COLX,
	/* U+47FD */	IFX0213(JISX0213_2(0xf93f),	U2E_NODEST_COLX),
	/* U+47FE */	U2E_NODEST_COLX,
	/* U+47FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_48[] = {
	/* U+4800 */	U2E_NODEST_COLX,
	/* U+4801 */	U2E_NODEST_COLX,
	/* U+4802 */	U2E_NODEST_COLX,
	/* U+4803 */	U2E_NODEST_COLX,
	/* U+4804 */	U2E_NODEST_COLX,
	/* U+4805 */	U2E_NODEST_COLX,
	/* U+4806 */	U2E_NODEST_COLX,
	/* U+4807 */	U2E_NODEST_COLX,
	/* U+4808 */	U2E_NODEST_COLX,
	/* U+4809 */	U2E_NODEST_COLX,
	/* U+480A */	U2E_NODEST_COLX,
	/* U+480B */	U2E_NODEST_COLX,
	/* U+480C */	U2E_NODEST_COLX,
	/* U+480D */	U2E_NODEST_COLX,
	/* U+480E */	U2E_NODEST_COLX,
	/* U+480F */	U2E_NODEST_COLX,
	/* U+4810 */	U2E_NODEST_COLX,
	/* U+4811 */	U2E_NODEST_COLX,
	/* U+4812 */	U2E_NODEST_COLX,
	/* U+4813 */	U2E_NODEST_COLX,
	/* U+4814 */	U2E_NODEST_COLX,
	/* U+4815 */	U2E_NODEST_COLX,
	/* U+4816 */	IFX0213(JISX0213_2(0xf949),	U2E_NODEST_COLX),
	/* U+4817 */	U2E_NODEST_COLX,
	/* U+4818 */	U2E_NODEST_COLX,
	/* U+4819 */	U2E_NODEST_COLX,
	/* U+481A */	U2E_NODEST_COLX,
	/* U+481B */	U2E_NODEST_COLX,
	/* U+481C */	U2E_NODEST_COLX,
	/* U+481D */	U2E_NODEST_COLX,
	/* U+481E */	U2E_NODEST_COLX,
	/* U+481F */	U2E_NODEST_COLX,
	/* U+4820 */	U2E_NODEST_COLX,
	/* U+4821 */	U2E_NODEST_COLX,
	/* U+4822 */	U2E_NODEST_COLX,
	/* U+4823 */	U2E_NODEST_COLX,
	/* U+4824 */	U2E_NODEST_COLX,
	/* U+4825 */	U2E_NODEST_COLX,
	/* U+4826 */	U2E_NODEST_COLX,
	/* U+4827 */	U2E_NODEST_COLX,
	/* U+4828 */	U2E_NODEST_COLX,
	/* U+4829 */	U2E_NODEST_COLX,
	/* U+482A */	U2E_NODEST_COLX,
	/* U+482B */	U2E_NODEST_COLX,
	/* U+482C */	U2E_NODEST_COLX,
	/* U+482D */	U2E_NODEST_COLX,
	/* U+482E */	U2E_NODEST_COLX,
	/* U+482F */	U2E_NODEST_COLX,
	/* U+4830 */	U2E_NODEST_COLX,
	/* U+4831 */	U2E_NODEST_COLX,
	/* U+4832 */	U2E_NODEST_COLX,
	/* U+4833 */	U2E_NODEST_COLX,
	/* U+4834 */	U2E_NODEST_COLX,
	/* U+4835 */	U2E_NODEST_COLX,
	/* U+4836 */	U2E_NODEST_COLX,
	/* U+4837 */	U2E_NODEST_COLX,
	/* U+4838 */	U2E_NODEST_COLX,
	/* U+4839 */	U2E_NODEST_COLX,
	/* U+483A */	U2E_NODEST_COLX,
	/* U+483B */	U2E_NODEST_COLX,
	/* U+483C */	U2E_NODEST_COLX,
	/* U+483D */	U2E_NODEST_COLX,
	/* U+483E */	U2E_NODEST_COLX,
	/* U+483F */	U2E_NODEST_COLX,
	/* U+4840 */	U2E_NODEST_COLX,
	/* U+4841 */	U2E_NODEST_COLX,
	/* U+4842 */	U2E_NODEST_COLX,
	/* U+4843 */	U2E_NODEST_COLX,
	/* U+4844 */	IFX0213(JISX0213_1(0xfccb),	U2E_NODEST_COLX),
	/* U+4845 */	U2E_NODEST_COLX,
	/* U+4846 */	U2E_NODEST_COLX,
	/* U+4847 */	U2E_NODEST_COLX,
	/* U+4848 */	U2E_NODEST_COLX,
	/* U+4849 */	U2E_NODEST_COLX,
	/* U+484A */	U2E_NODEST_COLX,
	/* U+484B */	U2E_NODEST_COLX,
	/* U+484C */	U2E_NODEST_COLX,
	/* U+484D */	U2E_NODEST_COLX,
	/* U+484E */	IFX0213(JISX0213_2(0xf95c),	U2E_NODEST_COLX),
	/* U+484F */	U2E_NODEST_COLX,
	/* U+4850 */	U2E_NODEST_COLX,
	/* U+4851 */	U2E_NODEST_COLX,
	/* U+4852 */	U2E_NODEST_COLX,
	/* U+4853 */	U2E_NODEST_COLX,
	/* U+4854 */	U2E_NODEST_COLX,
	/* U+4855 */	U2E_NODEST_COLX,
	/* U+4856 */	U2E_NODEST_COLX,
	/* U+4857 */	U2E_NODEST_COLX,
	/* U+4858 */	U2E_NODEST_COLX,
	/* U+4859 */	U2E_NODEST_COLX,
	/* U+485A */	U2E_NODEST_COLX,
	/* U+485B */	U2E_NODEST_COLX,
	/* U+485C */	U2E_NODEST_COLX,
	/* U+485D */	U2E_NODEST_COLX,
	/* U+485E */	U2E_NODEST_COLX,
	/* U+485F */	U2E_NODEST_COLX,
	/* U+4860 */	U2E_NODEST_COLX,
	/* U+4861 */	U2E_NODEST_COLX,
	/* U+4862 */	U2E_NODEST_COLX,
	/* U+4863 */	U2E_NODEST_COLX,
	/* U+4864 */	U2E_NODEST_COLX,
	/* U+4865 */	U2E_NODEST_COLX,
	/* U+4866 */	U2E_NODEST_COLX,
	/* U+4867 */	U2E_NODEST_COLX,
	/* U+4868 */	U2E_NODEST_COLX,
	/* U+4869 */	U2E_NODEST_COLX,
	/* U+486A */	U2E_NODEST_COLX,
	/* U+486B */	U2E_NODEST_COLX,
	/* U+486C */	U2E_NODEST_COLX,
	/* U+486D */	U2E_NODEST_COLX,
	/* U+486E */	U2E_NODEST_COLX,
	/* U+486F */	U2E_NODEST_COLX,
	/* U+4870 */	U2E_NODEST_COLX,
	/* U+4871 */	U2E_NODEST_COLX,
	/* U+4872 */	U2E_NODEST_COLX,
	/* U+4873 */	U2E_NODEST_COLX,
	/* U+4874 */	U2E_NODEST_COLX,
	/* U+4875 */	U2E_NODEST_COLX,
	/* U+4876 */	U2E_NODEST_COLX,
	/* U+4877 */	U2E_NODEST_COLX,
	/* U+4878 */	U2E_NODEST_COLX,
	/* U+4879 */	U2E_NODEST_COLX,
	/* U+487A */	U2E_NODEST_COLX,
	/* U+487B */	U2E_NODEST_COLX,
	/* U+487C */	U2E_NODEST_COLX,
	/* U+487D */	U2E_NODEST_COLX,
	/* U+487E */	U2E_NODEST_COLX,
	/* U+487F */	U2E_NODEST_COLX,
	/* U+4880 */	U2E_NODEST_COLX,
	/* U+4881 */	U2E_NODEST_COLX,
	/* U+4882 */	U2E_NODEST_COLX,
	/* U+4883 */	U2E_NODEST_COLX,
	/* U+4884 */	U2E_NODEST_COLX,
	/* U+4885 */	U2E_NODEST_COLX,
	/* U+4886 */	U2E_NODEST_COLX,
	/* U+4887 */	U2E_NODEST_COLX,
	/* U+4888 */	U2E_NODEST_COLX,
	/* U+4889 */	U2E_NODEST_COLX,
	/* U+488A */	U2E_NODEST_COLX,
	/* U+488B */	U2E_NODEST_COLX,
	/* U+488C */	U2E_NODEST_COLX,
	/* U+488D */	U2E_NODEST_COLX,
	/* U+488E */	U2E_NODEST_COLX,
	/* U+488F */	U2E_NODEST_COLX,
	/* U+4890 */	U2E_NODEST_COLX,
	/* U+4891 */	U2E_NODEST_COLX,
	/* U+4892 */	U2E_NODEST_COLX,
	/* U+4893 */	U2E_NODEST_COLX,
	/* U+4894 */	U2E_NODEST_COLX,
	/* U+4895 */	U2E_NODEST_COLX,
	/* U+4896 */	U2E_NODEST_COLX,
	/* U+4897 */	U2E_NODEST_COLX,
	/* U+4898 */	U2E_NODEST_COLX,
	/* U+4899 */	U2E_NODEST_COLX,
	/* U+489A */	U2E_NODEST_COLX,
	/* U+489B */	U2E_NODEST_COLX,
	/* U+489C */	U2E_NODEST_COLX,
	/* U+489D */	U2E_NODEST_COLX,
	/* U+489E */	U2E_NODEST_COLX,
	/* U+489F */	U2E_NODEST_COLX,
	/* U+48A0 */	U2E_NODEST_COLX,
	/* U+48A1 */	U2E_NODEST_COLX,
	/* U+48A2 */	U2E_NODEST_COLX,
	/* U+48A3 */	U2E_NODEST_COLX,
	/* U+48A4 */	U2E_NODEST_COLX,
	/* U+48A5 */	U2E_NODEST_COLX,
	/* U+48A6 */	U2E_NODEST_COLX,
	/* U+48A7 */	U2E_NODEST_COLX,
	/* U+48A8 */	U2E_NODEST_COLX,
	/* U+48A9 */	U2E_NODEST_COLX,
	/* U+48AA */	U2E_NODEST_COLX,
	/* U+48AB */	U2E_NODEST_COLX,
	/* U+48AC */	U2E_NODEST_COLX,
	/* U+48AD */	U2E_NODEST_COLX,
	/* U+48AE */	U2E_NODEST_COLX,
	/* U+48AF */	U2E_NODEST_COLX,
	/* U+48B0 */	U2E_NODEST_COLX,
	/* U+48B1 */	U2E_NODEST_COLX,
	/* U+48B2 */	U2E_NODEST_COLX,
	/* U+48B3 */	U2E_NODEST_COLX,
	/* U+48B4 */	U2E_NODEST_COLX,
	/* U+48B5 */	IFX0213(JISX0213_2(0xfa27),	U2E_NODEST_COLX),
	/* U+48B6 */	U2E_NODEST_COLX,
	/* U+48B7 */	U2E_NODEST_COLX,
	/* U+48B8 */	U2E_NODEST_COLX,
	/* U+48B9 */	U2E_NODEST_COLX,
	/* U+48BA */	U2E_NODEST_COLX,
	/* U+48BB */	U2E_NODEST_COLX,
	/* U+48BC */	U2E_NODEST_COLX,
	/* U+48BD */	U2E_NODEST_COLX,
	/* U+48BE */	U2E_NODEST_COLX,
	/* U+48BF */	U2E_NODEST_COLX,
	/* U+48C0 */	U2E_NODEST_COLX,
	/* U+48C1 */	U2E_NODEST_COLX,
	/* U+48C2 */	U2E_NODEST_COLX,
	/* U+48C3 */	U2E_NODEST_COLX,
	/* U+48C4 */	U2E_NODEST_COLX,
	/* U+48C5 */	U2E_NODEST_COLX,
	/* U+48C6 */	U2E_NODEST_COLX,
	/* U+48C7 */	U2E_NODEST_COLX,
	/* U+48C8 */	U2E_NODEST_COLX,
	/* U+48C9 */	U2E_NODEST_COLX,
	/* U+48CA */	U2E_NODEST_COLX,
	/* U+48CB */	U2E_NODEST_COLX,
	/* U+48CC */	U2E_NODEST_COLX,
	/* U+48CD */	U2E_NODEST_COLX,
	/* U+48CE */	U2E_NODEST_COLX,
	/* U+48CF */	U2E_NODEST_COLX,
	/* U+48D0 */	U2E_NODEST_COLX,
	/* U+48D1 */	U2E_NODEST_COLX,
	/* U+48D2 */	U2E_NODEST_COLX,
	/* U+48D3 */	U2E_NODEST_COLX,
	/* U+48D4 */	U2E_NODEST_COLX,
	/* U+48D5 */	U2E_NODEST_COLX,
	/* U+48D6 */	U2E_NODEST_COLX,
	/* U+48D7 */	U2E_NODEST_COLX,
	/* U+48D8 */	U2E_NODEST_COLX,
	/* U+48D9 */	U2E_NODEST_COLX,
	/* U+48DA */	U2E_NODEST_COLX,
	/* U+48DB */	U2E_NODEST_COLX,
	/* U+48DC */	U2E_NODEST_COLX,
	/* U+48DD */	U2E_NODEST_COLX,
	/* U+48DE */	U2E_NODEST_COLX,
	/* U+48DF */	U2E_NODEST_COLX,
	/* U+48E0 */	U2E_NODEST_COLX,
	/* U+48E1 */	U2E_NODEST_COLX,
	/* U+48E2 */	U2E_NODEST_COLX,
	/* U+48E3 */	U2E_NODEST_COLX,
	/* U+48E4 */	U2E_NODEST_COLX,
	/* U+48E5 */	U2E_NODEST_COLX,
	/* U+48E6 */	U2E_NODEST_COLX,
	/* U+48E7 */	U2E_NODEST_COLX,
	/* U+48E8 */	U2E_NODEST_COLX,
	/* U+48E9 */	U2E_NODEST_COLX,
	/* U+48EA */	U2E_NODEST_COLX,
	/* U+48EB */	U2E_NODEST_COLX,
	/* U+48EC */	U2E_NODEST_COLX,
	/* U+48ED */	U2E_NODEST_COLX,
	/* U+48EE */	U2E_NODEST_COLX,
	/* U+48EF */	U2E_NODEST_COLX,
	/* U+48F0 */	U2E_NODEST_COLX,
	/* U+48F1 */	U2E_NODEST_COLX,
	/* U+48F2 */	U2E_NODEST_COLX,
	/* U+48F3 */	U2E_NODEST_COLX,
	/* U+48F4 */	U2E_NODEST_COLX,
	/* U+48F5 */	U2E_NODEST_COLX,
	/* U+48F6 */	U2E_NODEST_COLX,
	/* U+48F7 */	U2E_NODEST_COLX,
	/* U+48F8 */	U2E_NODEST_COLX,
	/* U+48F9 */	U2E_NODEST_COLX,
	/* U+48FA */	U2E_NODEST_COLX,
	/* U+48FB */	U2E_NODEST_COLX,
	/* U+48FC */	U2E_NODEST_COLX,
	/* U+48FD */	U2E_NODEST_COLX,
	/* U+48FE */	U2E_NODEST_COLX,
	/* U+48FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_49[] = {
	/* U+4900 */	U2E_NODEST_COLX,
	/* U+4901 */	U2E_NODEST_COLX,
	/* U+4902 */	U2E_NODEST_COLX,
	/* U+4903 */	U2E_NODEST_COLX,
	/* U+4904 */	U2E_NODEST_COLX,
	/* U+4905 */	U2E_NODEST_COLX,
	/* U+4906 */	U2E_NODEST_COLX,
	/* U+4907 */	U2E_NODEST_COLX,
	/* U+4908 */	U2E_NODEST_COLX,
	/* U+4909 */	U2E_NODEST_COLX,
	/* U+490A */	U2E_NODEST_COLX,
	/* U+490B */	U2E_NODEST_COLX,
	/* U+490C */	U2E_NODEST_COLX,
	/* U+490D */	U2E_NODEST_COLX,
	/* U+490E */	U2E_NODEST_COLX,
	/* U+490F */	U2E_NODEST_COLX,
	/* U+4910 */	U2E_NODEST_COLX,
	/* U+4911 */	U2E_NODEST_COLX,
	/* U+4912 */	U2E_NODEST_COLX,
	/* U+4913 */	U2E_NODEST_COLX,
	/* U+4914 */	U2E_NODEST_COLX,
	/* U+4915 */	U2E_NODEST_COLX,
	/* U+4916 */	U2E_NODEST_COLX,
	/* U+4917 */	U2E_NODEST_COLX,
	/* U+4918 */	U2E_NODEST_COLX,
	/* U+4919 */	U2E_NODEST_COLX,
	/* U+491A */	U2E_NODEST_COLX,
	/* U+491B */	U2E_NODEST_COLX,
	/* U+491C */	U2E_NODEST_COLX,
	/* U+491D */	U2E_NODEST_COLX,
	/* U+491E */	U2E_NODEST_COLX,
	/* U+491F */	U2E_NODEST_COLX,
	/* U+4920 */	U2E_NODEST_COLX,
	/* U+4921 */	U2E_NODEST_COLX,
	/* U+4922 */	U2E_NODEST_COLX,
	/* U+4923 */	U2E_NODEST_COLX,
	/* U+4924 */	U2E_NODEST_COLX,
	/* U+4925 */	U2E_NODEST_COLX,
	/* U+4926 */	U2E_NODEST_COLX,
	/* U+4927 */	U2E_NODEST_COLX,
	/* U+4928 */	U2E_NODEST_COLX,
	/* U+4929 */	U2E_NODEST_COLX,
	/* U+492A */	U2E_NODEST_COLX,
	/* U+492B */	U2E_NODEST_COLX,
	/* U+492C */	U2E_NODEST_COLX,
	/* U+492D */	U2E_NODEST_COLX,
	/* U+492E */	U2E_NODEST_COLX,
	/* U+492F */	U2E_NODEST_COLX,
	/* U+4930 */	U2E_NODEST_COLX,
	/* U+4931 */	U2E_NODEST_COLX,
	/* U+4932 */	U2E_NODEST_COLX,
	/* U+4933 */	U2E_NODEST_COLX,
	/* U+4934 */	U2E_NODEST_COLX,
	/* U+4935 */	U2E_NODEST_COLX,
	/* U+4936 */	U2E_NODEST_COLX,
	/* U+4937 */	U2E_NODEST_COLX,
	/* U+4938 */	U2E_NODEST_COLX,
	/* U+4939 */	U2E_NODEST_COLX,
	/* U+493A */	U2E_NODEST_COLX,
	/* U+493B */	U2E_NODEST_COLX,
	/* U+493C */	U2E_NODEST_COLX,
	/* U+493D */	U2E_NODEST_COLX,
	/* U+493E */	U2E_NODEST_COLX,
	/* U+493F */	U2E_NODEST_COLX,
	/* U+4940 */	U2E_NODEST_COLX,
	/* U+4941 */	U2E_NODEST_COLX,
	/* U+4942 */	U2E_NODEST_COLX,
	/* U+4943 */	U2E_NODEST_COLX,
	/* U+4944 */	U2E_NODEST_COLX,
	/* U+4945 */	U2E_NODEST_COLX,
	/* U+4946 */	U2E_NODEST_COLX,
	/* U+4947 */	U2E_NODEST_COLX,
	/* U+4948 */	U2E_NODEST_COLX,
	/* U+4949 */	U2E_NODEST_COLX,
	/* U+494A */	U2E_NODEST_COLX,
	/* U+494B */	U2E_NODEST_COLX,
	/* U+494C */	U2E_NODEST_COLX,
	/* U+494D */	U2E_NODEST_COLX,
	/* U+494E */	U2E_NODEST_COLX,
	/* U+494F */	U2E_NODEST_COLX,
	/* U+4950 */	U2E_NODEST_COLX,
	/* U+4951 */	U2E_NODEST_COLX,
	/* U+4952 */	U2E_NODEST_COLX,
	/* U+4953 */	U2E_NODEST_COLX,
	/* U+4954 */	U2E_NODEST_COLX,
	/* U+4955 */	U2E_NODEST_COLX,
	/* U+4956 */	U2E_NODEST_COLX,
	/* U+4957 */	U2E_NODEST_COLX,
	/* U+4958 */	U2E_NODEST_COLX,
	/* U+4959 */	U2E_NODEST_COLX,
	/* U+495A */	U2E_NODEST_COLX,
	/* U+495B */	U2E_NODEST_COLX,
	/* U+495C */	U2E_NODEST_COLX,
	/* U+495D */	U2E_NODEST_COLX,
	/* U+495E */	U2E_NODEST_COLX,
	/* U+495F */	U2E_NODEST_COLX,
	/* U+4960 */	U2E_NODEST_COLX,
	/* U+4961 */	U2E_NODEST_COLX,
	/* U+4962 */	U2E_NODEST_COLX,
	/* U+4963 */	U2E_NODEST_COLX,
	/* U+4964 */	U2E_NODEST_COLX,
	/* U+4965 */	U2E_NODEST_COLX,
	/* U+4966 */	U2E_NODEST_COLX,
	/* U+4967 */	U2E_NODEST_COLX,
	/* U+4968 */	U2E_NODEST_COLX,
	/* U+4969 */	U2E_NODEST_COLX,
	/* U+496A */	U2E_NODEST_COLX,
	/* U+496B */	U2E_NODEST_COLX,
	/* U+496C */	U2E_NODEST_COLX,
	/* U+496D */	U2E_NODEST_COLX,
	/* U+496E */	U2E_NODEST_COLX,
	/* U+496F */	U2E_NODEST_COLX,
	/* U+4970 */	U2E_NODEST_COLX,
	/* U+4971 */	U2E_NODEST_COLX,
	/* U+4972 */	U2E_NODEST_COLX,
	/* U+4973 */	U2E_NODEST_COLX,
	/* U+4974 */	U2E_NODEST_COLX,
	/* U+4975 */	U2E_NODEST_COLX,
	/* U+4976 */	U2E_NODEST_COLX,
	/* U+4977 */	U2E_NODEST_COLX,
	/* U+4978 */	U2E_NODEST_COLX,
	/* U+4979 */	U2E_NODEST_COLX,
	/* U+497A */	U2E_NODEST_COLX,
	/* U+497B */	U2E_NODEST_COLX,
	/* U+497C */	U2E_NODEST_COLX,
	/* U+497D */	U2E_NODEST_COLX,
	/* U+497E */	U2E_NODEST_COLX,
	/* U+497F */	U2E_NODEST_COLX,
	/* U+4980 */	U2E_NODEST_COLX,
	/* U+4981 */	U2E_NODEST_COLX,
	/* U+4982 */	U2E_NODEST_COLX,
	/* U+4983 */	U2E_NODEST_COLX,
	/* U+4984 */	U2E_NODEST_COLX,
	/* U+4985 */	U2E_NODEST_COLX,
	/* U+4986 */	U2E_NODEST_COLX,
	/* U+4987 */	U2E_NODEST_COLX,
	/* U+4988 */	U2E_NODEST_COLX,
	/* U+4989 */	U2E_NODEST_COLX,
	/* U+498A */	U2E_NODEST_COLX,
	/* U+498B */	U2E_NODEST_COLX,
	/* U+498C */	U2E_NODEST_COLX,
	/* U+498D */	U2E_NODEST_COLX,
	/* U+498E */	U2E_NODEST_COLX,
	/* U+498F */	U2E_NODEST_COLX,
	/* U+4990 */	U2E_NODEST_COLX,
	/* U+4991 */	U2E_NODEST_COLX,
	/* U+4992 */	U2E_NODEST_COLX,
	/* U+4993 */	U2E_NODEST_COLX,
	/* U+4994 */	U2E_NODEST_COLX,
	/* U+4995 */	U2E_NODEST_COLX,
	/* U+4996 */	U2E_NODEST_COLX,
	/* U+4997 */	U2E_NODEST_COLX,
	/* U+4998 */	U2E_NODEST_COLX,
	/* U+4999 */	U2E_NODEST_COLX,
	/* U+499A */	U2E_NODEST_COLX,
	/* U+499B */	U2E_NODEST_COLX,
	/* U+499C */	U2E_NODEST_COLX,
	/* U+499D */	U2E_NODEST_COLX,
	/* U+499E */	U2E_NODEST_COLX,
	/* U+499F */	U2E_NODEST_COLX,
	/* U+49A0 */	U2E_NODEST_COLX,
	/* U+49A1 */	U2E_NODEST_COLX,
	/* U+49A2 */	U2E_NODEST_COLX,
	/* U+49A3 */	U2E_NODEST_COLX,
	/* U+49A4 */	U2E_NODEST_COLX,
	/* U+49A5 */	U2E_NODEST_COLX,
	/* U+49A6 */	U2E_NODEST_COLX,
	/* U+49A7 */	U2E_NODEST_COLX,
	/* U+49A8 */	U2E_NODEST_COLX,
	/* U+49A9 */	U2E_NODEST_COLX,
	/* U+49AA */	U2E_NODEST_COLX,
	/* U+49AB */	U2E_NODEST_COLX,
	/* U+49AC */	U2E_NODEST_COLX,
	/* U+49AD */	U2E_NODEST_COLX,
	/* U+49AE */	U2E_NODEST_COLX,
	/* U+49AF */	U2E_NODEST_COLX,
	/* U+49B0 */	IFX0213(JISX0213_1(0xfdd8),	U2E_NODEST_COLX),
	/* U+49B1 */	U2E_NODEST_COLX,
	/* U+49B2 */	U2E_NODEST_COLX,
	/* U+49B3 */	U2E_NODEST_COLX,
	/* U+49B4 */	U2E_NODEST_COLX,
	/* U+49B5 */	U2E_NODEST_COLX,
	/* U+49B6 */	U2E_NODEST_COLX,
	/* U+49B7 */	U2E_NODEST_COLX,
	/* U+49B8 */	U2E_NODEST_COLX,
	/* U+49B9 */	U2E_NODEST_COLX,
	/* U+49BA */	U2E_NODEST_COLX,
	/* U+49BB */	U2E_NODEST_COLX,
	/* U+49BC */	U2E_NODEST_COLX,
	/* U+49BD */	U2E_NODEST_COLX,
	/* U+49BE */	U2E_NODEST_COLX,
	/* U+49BF */	U2E_NODEST_COLX,
	/* U+49C0 */	U2E_NODEST_COLX,
	/* U+49C1 */	U2E_NODEST_COLX,
	/* U+49C2 */	U2E_NODEST_COLX,
	/* U+49C3 */	U2E_NODEST_COLX,
	/* U+49C4 */	U2E_NODEST_COLX,
	/* U+49C5 */	U2E_NODEST_COLX,
	/* U+49C6 */	U2E_NODEST_COLX,
	/* U+49C7 */	U2E_NODEST_COLX,
	/* U+49C8 */	U2E_NODEST_COLX,
	/* U+49C9 */	U2E_NODEST_COLX,
	/* U+49CA */	U2E_NODEST_COLX,
	/* U+49CB */	U2E_NODEST_COLX,
	/* U+49CC */	U2E_NODEST_COLX,
	/* U+49CD */	U2E_NODEST_COLX,
	/* U+49CE */	U2E_NODEST_COLX,
	/* U+49CF */	U2E_NODEST_COLX,
	/* U+49D0 */	U2E_NODEST_COLX,
	/* U+49D1 */	U2E_NODEST_COLX,
	/* U+49D2 */	U2E_NODEST_COLX,
	/* U+49D3 */	U2E_NODEST_COLX,
	/* U+49D4 */	U2E_NODEST_COLX,
	/* U+49D5 */	U2E_NODEST_COLX,
	/* U+49D6 */	U2E_NODEST_COLX,
	/* U+49D7 */	U2E_NODEST_COLX,
	/* U+49D8 */	U2E_NODEST_COLX,
	/* U+49D9 */	U2E_NODEST_COLX,
	/* U+49DA */	U2E_NODEST_COLX,
	/* U+49DB */	U2E_NODEST_COLX,
	/* U+49DC */	U2E_NODEST_COLX,
	/* U+49DD */	U2E_NODEST_COLX,
	/* U+49DE */	U2E_NODEST_COLX,
	/* U+49DF */	U2E_NODEST_COLX,
	/* U+49E0 */	U2E_NODEST_COLX,
	/* U+49E1 */	U2E_NODEST_COLX,
	/* U+49E2 */	U2E_NODEST_COLX,
	/* U+49E3 */	U2E_NODEST_COLX,
	/* U+49E4 */	U2E_NODEST_COLX,
	/* U+49E5 */	U2E_NODEST_COLX,
	/* U+49E6 */	U2E_NODEST_COLX,
	/* U+49E7 */	IFX0213(JISX0213_2(0xfb6a),	U2E_NODEST_COLX),
	/* U+49E8 */	U2E_NODEST_COLX,
	/* U+49E9 */	U2E_NODEST_COLX,
	/* U+49EA */	U2E_NODEST_COLX,
	/* U+49EB */	U2E_NODEST_COLX,
	/* U+49EC */	U2E_NODEST_COLX,
	/* U+49ED */	U2E_NODEST_COLX,
	/* U+49EE */	U2E_NODEST_COLX,
	/* U+49EF */	U2E_NODEST_COLX,
	/* U+49F0 */	U2E_NODEST_COLX,
	/* U+49F1 */	U2E_NODEST_COLX,
	/* U+49F2 */	U2E_NODEST_COLX,
	/* U+49F3 */	U2E_NODEST_COLX,
	/* U+49F4 */	U2E_NODEST_COLX,
	/* U+49F5 */	U2E_NODEST_COLX,
	/* U+49F6 */	U2E_NODEST_COLX,
	/* U+49F7 */	U2E_NODEST_COLX,
	/* U+49F8 */	U2E_NODEST_COLX,
	/* U+49F9 */	U2E_NODEST_COLX,
	/* U+49FA */	IFX0213(JISX0213_2(0xfb70),	U2E_NODEST_COLX),
	/* U+49FB */	U2E_NODEST_COLX,
	/* U+49FC */	U2E_NODEST_COLX,
	/* U+49FD */	U2E_NODEST_COLX,
	/* U+49FE */	U2E_NODEST_COLX,
	/* U+49FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_4A[] = {
	/* U+4A00 */	U2E_NODEST_COLX,
	/* U+4A01 */	U2E_NODEST_COLX,
	/* U+4A02 */	U2E_NODEST_COLX,
	/* U+4A03 */	U2E_NODEST_COLX,
	/* U+4A04 */	IFX0213(JISX0213_2(0xfb75),	U2E_NODEST_COLX),
	/* U+4A05 */	U2E_NODEST_COLX,
	/* U+4A06 */	U2E_NODEST_COLX,
	/* U+4A07 */	U2E_NODEST_COLX,
	/* U+4A08 */	U2E_NODEST_COLX,
	/* U+4A09 */	U2E_NODEST_COLX,
	/* U+4A0A */	U2E_NODEST_COLX,
	/* U+4A0B */	U2E_NODEST_COLX,
	/* U+4A0C */	U2E_NODEST_COLX,
	/* U+4A0D */	U2E_NODEST_COLX,
	/* U+4A0E */	U2E_NODEST_COLX,
	/* U+4A0F */	U2E_NODEST_COLX,
	/* U+4A10 */	U2E_NODEST_COLX,
	/* U+4A11 */	U2E_NODEST_COLX,
	/* U+4A12 */	U2E_NODEST_COLX,
	/* U+4A13 */	U2E_NODEST_COLX,
	/* U+4A14 */	U2E_NODEST_COLX,
	/* U+4A15 */	U2E_NODEST_COLX,
	/* U+4A16 */	U2E_NODEST_COLX,
	/* U+4A17 */	U2E_NODEST_COLX,
	/* U+4A18 */	U2E_NODEST_COLX,
	/* U+4A19 */	U2E_NODEST_COLX,
	/* U+4A1A */	U2E_NODEST_COLX,
	/* U+4A1B */	U2E_NODEST_COLX,
	/* U+4A1C */	U2E_NODEST_COLX,
	/* U+4A1D */	U2E_NODEST_COLX,
	/* U+4A1E */	U2E_NODEST_COLX,
	/* U+4A1F */	U2E_NODEST_COLX,
	/* U+4A20 */	U2E_NODEST_COLX,
	/* U+4A21 */	U2E_NODEST_COLX,
	/* U+4A22 */	U2E_NODEST_COLX,
	/* U+4A23 */	U2E_NODEST_COLX,
	/* U+4A24 */	U2E_NODEST_COLX,
	/* U+4A25 */	U2E_NODEST_COLX,
	/* U+4A26 */	U2E_NODEST_COLX,
	/* U+4A27 */	U2E_NODEST_COLX,
	/* U+4A28 */	U2E_NODEST_COLX,
	/* U+4A29 */	IFX0213(JISX0213_2(0xfb78),	U2E_NODEST_COLX),
	/* U+4A2A */	U2E_NODEST_COLX,
	/* U+4A2B */	U2E_NODEST_COLX,
	/* U+4A2C */	U2E_NODEST_COLX,
	/* U+4A2D */	U2E_NODEST_COLX,
	/* U+4A2E */	U2E_NODEST_COLX,
	/* U+4A2F */	U2E_NODEST_COLX,
	/* U+4A30 */	U2E_NODEST_COLX,
	/* U+4A31 */	U2E_NODEST_COLX,
	/* U+4A32 */	U2E_NODEST_COLX,
	/* U+4A33 */	U2E_NODEST_COLX,
	/* U+4A34 */	U2E_NODEST_COLX,
	/* U+4A35 */	U2E_NODEST_COLX,
	/* U+4A36 */	U2E_NODEST_COLX,
	/* U+4A37 */	U2E_NODEST_COLX,
	/* U+4A38 */	U2E_NODEST_COLX,
	/* U+4A39 */	U2E_NODEST_COLX,
	/* U+4A3A */	U2E_NODEST_COLX,
	/* U+4A3B */	U2E_NODEST_COLX,
	/* U+4A3C */	U2E_NODEST_COLX,
	/* U+4A3D */	U2E_NODEST_COLX,
	/* U+4A3E */	U2E_NODEST_COLX,
	/* U+4A3F */	U2E_NODEST_COLX,
	/* U+4A40 */	U2E_NODEST_COLX,
	/* U+4A41 */	U2E_NODEST_COLX,
	/* U+4A42 */	U2E_NODEST_COLX,
	/* U+4A43 */	U2E_NODEST_COLX,
	/* U+4A44 */	U2E_NODEST_COLX,
	/* U+4A45 */	U2E_NODEST_COLX,
	/* U+4A46 */	U2E_NODEST_COLX,
	/* U+4A47 */	U2E_NODEST_COLX,
	/* U+4A48 */	U2E_NODEST_COLX,
	/* U+4A49 */	U2E_NODEST_COLX,
	/* U+4A4A */	U2E_NODEST_COLX,
	/* U+4A4B */	U2E_NODEST_COLX,
	/* U+4A4C */	U2E_NODEST_COLX,
	/* U+4A4D */	U2E_NODEST_COLX,
	/* U+4A4E */	U2E_NODEST_COLX,
	/* U+4A4F */	U2E_NODEST_COLX,
	/* U+4A50 */	U2E_NODEST_COLX,
	/* U+4A51 */	U2E_NODEST_COLX,
	/* U+4A52 */	U2E_NODEST_COLX,
	/* U+4A53 */	U2E_NODEST_COLX,
	/* U+4A54 */	U2E_NODEST_COLX,
	/* U+4A55 */	U2E_NODEST_COLX,
	/* U+4A56 */	U2E_NODEST_COLX,
	/* U+4A57 */	U2E_NODEST_COLX,
	/* U+4A58 */	U2E_NODEST_COLX,
	/* U+4A59 */	U2E_NODEST_COLX,
	/* U+4A5A */	U2E_NODEST_COLX,
	/* U+4A5B */	U2E_NODEST_COLX,
	/* U+4A5C */	U2E_NODEST_COLX,
	/* U+4A5D */	U2E_NODEST_COLX,
	/* U+4A5E */	U2E_NODEST_COLX,
	/* U+4A5F */	U2E_NODEST_COLX,
	/* U+4A60 */	U2E_NODEST_COLX,
	/* U+4A61 */	U2E_NODEST_COLX,
	/* U+4A62 */	U2E_NODEST_COLX,
	/* U+4A63 */	U2E_NODEST_COLX,
	/* U+4A64 */	U2E_NODEST_COLX,
	/* U+4A65 */	U2E_NODEST_COLX,
	/* U+4A66 */	U2E_NODEST_COLX,
	/* U+4A67 */	U2E_NODEST_COLX,
	/* U+4A68 */	U2E_NODEST_COLX,
	/* U+4A69 */	U2E_NODEST_COLX,
	/* U+4A6A */	U2E_NODEST_COLX,
	/* U+4A6B */	U2E_NODEST_COLX,
	/* U+4A6C */	U2E_NODEST_COLX,
	/* U+4A6D */	U2E_NODEST_COLX,
	/* U+4A6E */	U2E_NODEST_COLX,
	/* U+4A6F */	U2E_NODEST_COLX,
	/* U+4A70 */	U2E_NODEST_COLX,
	/* U+4A71 */	U2E_NODEST_COLX,
	/* U+4A72 */	U2E_NODEST_COLX,
	/* U+4A73 */	U2E_NODEST_COLX,
	/* U+4A74 */	U2E_NODEST_COLX,
	/* U+4A75 */	U2E_NODEST_COLX,
	/* U+4A76 */	U2E_NODEST_COLX,
	/* U+4A77 */	U2E_NODEST_COLX,
	/* U+4A78 */	U2E_NODEST_COLX,
	/* U+4A79 */	U2E_NODEST_COLX,
	/* U+4A7A */	U2E_NODEST_COLX,
	/* U+4A7B */	U2E_NODEST_COLX,
	/* U+4A7C */	U2E_NODEST_COLX,
	/* U+4A7D */	U2E_NODEST_COLX,
	/* U+4A7E */	U2E_NODEST_COLX,
	/* U+4A7F */	U2E_NODEST_COLX,
	/* U+4A80 */	U2E_NODEST_COLX,
	/* U+4A81 */	U2E_NODEST_COLX,
	/* U+4A82 */	U2E_NODEST_COLX,
	/* U+4A83 */	U2E_NODEST_COLX,
	/* U+4A84 */	U2E_NODEST_COLX,
	/* U+4A85 */	U2E_NODEST_COLX,
	/* U+4A86 */	U2E_NODEST_COLX,
	/* U+4A87 */	U2E_NODEST_COLX,
	/* U+4A88 */	U2E_NODEST_COLX,
	/* U+4A89 */	U2E_NODEST_COLX,
	/* U+4A8A */	U2E_NODEST_COLX,
	/* U+4A8B */	U2E_NODEST_COLX,
	/* U+4A8C */	U2E_NODEST_COLX,
	/* U+4A8D */	U2E_NODEST_COLX,
	/* U+4A8E */	U2E_NODEST_COLX,
	/* U+4A8F */	U2E_NODEST_COLX,
	/* U+4A90 */	U2E_NODEST_COLX,
	/* U+4A91 */	U2E_NODEST_COLX,
	/* U+4A92 */	U2E_NODEST_COLX,
	/* U+4A93 */	U2E_NODEST_COLX,
	/* U+4A94 */	U2E_NODEST_COLX,
	/* U+4A95 */	U2E_NODEST_COLX,
	/* U+4A96 */	U2E_NODEST_COLX,
	/* U+4A97 */	U2E_NODEST_COLX,
	/* U+4A98 */	U2E_NODEST_COLX,
	/* U+4A99 */	U2E_NODEST_COLX,
	/* U+4A9A */	U2E_NODEST_COLX,
	/* U+4A9B */	U2E_NODEST_COLX,
	/* U+4A9C */	U2E_NODEST_COLX,
	/* U+4A9D */	U2E_NODEST_COLX,
	/* U+4A9E */	U2E_NODEST_COLX,
	/* U+4A9F */	U2E_NODEST_COLX,
	/* U+4AA0 */	U2E_NODEST_COLX,
	/* U+4AA1 */	U2E_NODEST_COLX,
	/* U+4AA2 */	U2E_NODEST_COLX,
	/* U+4AA3 */	U2E_NODEST_COLX,
	/* U+4AA4 */	U2E_NODEST_COLX,
	/* U+4AA5 */	U2E_NODEST_COLX,
	/* U+4AA6 */	U2E_NODEST_COLX,
	/* U+4AA7 */	U2E_NODEST_COLX,
	/* U+4AA8 */	U2E_NODEST_COLX,
	/* U+4AA9 */	U2E_NODEST_COLX,
	/* U+4AAA */	U2E_NODEST_COLX,
	/* U+4AAB */	U2E_NODEST_COLX,
	/* U+4AAC */	U2E_NODEST_COLX,
	/* U+4AAD */	U2E_NODEST_COLX,
	/* U+4AAE */	U2E_NODEST_COLX,
	/* U+4AAF */	U2E_NODEST_COLX,
	/* U+4AB0 */	U2E_NODEST_COLX,
	/* U+4AB1 */	U2E_NODEST_COLX,
	/* U+4AB2 */	U2E_NODEST_COLX,
	/* U+4AB3 */	U2E_NODEST_COLX,
	/* U+4AB4 */	U2E_NODEST_COLX,
	/* U+4AB5 */	U2E_NODEST_COLX,
	/* U+4AB6 */	U2E_NODEST_COLX,
	/* U+4AB7 */	U2E_NODEST_COLX,
	/* U+4AB8 */	U2E_NODEST_COLX,
	/* U+4AB9 */	U2E_NODEST_COLX,
	/* U+4ABA */	U2E_NODEST_COLX,
	/* U+4ABB */	U2E_NODEST_COLX,
	/* U+4ABC */	IFX0213(JISX0213_2(0xfc37),	U2E_NODEST_COLX),
	/* U+4ABD */	U2E_NODEST_COLX,
	/* U+4ABE */	U2E_NODEST_COLX,
	/* U+4ABF */	U2E_NODEST_COLX,
	/* U+4AC0 */	U2E_NODEST_COLX,
	/* U+4AC1 */	U2E_NODEST_COLX,
	/* U+4AC2 */	U2E_NODEST_COLX,
	/* U+4AC3 */	U2E_NODEST_COLX,
	/* U+4AC4 */	U2E_NODEST_COLX,
	/* U+4AC5 */	U2E_NODEST_COLX,
	/* U+4AC6 */	U2E_NODEST_COLX,
	/* U+4AC7 */	U2E_NODEST_COLX,
	/* U+4AC8 */	U2E_NODEST_COLX,
	/* U+4AC9 */	U2E_NODEST_COLX,
	/* U+4ACA */	U2E_NODEST_COLX,
	/* U+4ACB */	U2E_NODEST_COLX,
	/* U+4ACC */	U2E_NODEST_COLX,
	/* U+4ACD */	U2E_NODEST_COLX,
	/* U+4ACE */	U2E_NODEST_COLX,
	/* U+4ACF */	U2E_NODEST_COLX,
	/* U+4AD0 */	U2E_NODEST_COLX,
	/* U+4AD1 */	U2E_NODEST_COLX,
	/* U+4AD2 */	U2E_NODEST_COLX,
	/* U+4AD3 */	U2E_NODEST_COLX,
	/* U+4AD4 */	U2E_NODEST_COLX,
	/* U+4AD5 */	U2E_NODEST_COLX,
	/* U+4AD6 */	U2E_NODEST_COLX,
	/* U+4AD7 */	U2E_NODEST_COLX,
	/* U+4AD8 */	U2E_NODEST_COLX,
	/* U+4AD9 */	U2E_NODEST_COLX,
	/* U+4ADA */	U2E_NODEST_COLX,
	/* U+4ADB */	U2E_NODEST_COLX,
	/* U+4ADC */	U2E_NODEST_COLX,
	/* U+4ADD */	U2E_NODEST_COLX,
	/* U+4ADE */	U2E_NODEST_COLX,
	/* U+4ADF */	U2E_NODEST_COLX,
	/* U+4AE0 */	U2E_NODEST_COLX,
	/* U+4AE1 */	U2E_NODEST_COLX,
	/* U+4AE2 */	U2E_NODEST_COLX,
	/* U+4AE3 */	U2E_NODEST_COLX,
	/* U+4AE4 */	U2E_NODEST_COLX,
	/* U+4AE5 */	U2E_NODEST_COLX,
	/* U+4AE6 */	U2E_NODEST_COLX,
	/* U+4AE7 */	U2E_NODEST_COLX,
	/* U+4AE8 */	U2E_NODEST_COLX,
	/* U+4AE9 */	U2E_NODEST_COLX,
	/* U+4AEA */	U2E_NODEST_COLX,
	/* U+4AEB */	U2E_NODEST_COLX,
	/* U+4AEC */	U2E_NODEST_COLX,
	/* U+4AED */	U2E_NODEST_COLX,
	/* U+4AEE */	U2E_NODEST_COLX,
	/* U+4AEF */	U2E_NODEST_COLX,
	/* U+4AF0 */	U2E_NODEST_COLX,
	/* U+4AF1 */	U2E_NODEST_COLX,
	/* U+4AF2 */	U2E_NODEST_COLX,
	/* U+4AF3 */	U2E_NODEST_COLX,
	/* U+4AF4 */	U2E_NODEST_COLX,
	/* U+4AF5 */	U2E_NODEST_COLX,
	/* U+4AF6 */	U2E_NODEST_COLX,
	/* U+4AF7 */	U2E_NODEST_COLX,
	/* U+4AF8 */	U2E_NODEST_COLX,
	/* U+4AF9 */	U2E_NODEST_COLX,
	/* U+4AFA */	U2E_NODEST_COLX,
	/* U+4AFB */	U2E_NODEST_COLX,
	/* U+4AFC */	U2E_NODEST_COLX,
	/* U+4AFD */	U2E_NODEST_COLX,
	/* U+4AFE */	U2E_NODEST_COLX,
	/* U+4AFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_4B[] = {
	/* U+4B00 */	U2E_NODEST_COLX,
	/* U+4B01 */	U2E_NODEST_COLX,
	/* U+4B02 */	U2E_NODEST_COLX,
	/* U+4B03 */	U2E_NODEST_COLX,
	/* U+4B04 */	U2E_NODEST_COLX,
	/* U+4B05 */	U2E_NODEST_COLX,
	/* U+4B06 */	U2E_NODEST_COLX,
	/* U+4B07 */	U2E_NODEST_COLX,
	/* U+4B08 */	U2E_NODEST_COLX,
	/* U+4B09 */	U2E_NODEST_COLX,
	/* U+4B0A */	U2E_NODEST_COLX,
	/* U+4B0B */	U2E_NODEST_COLX,
	/* U+4B0C */	U2E_NODEST_COLX,
	/* U+4B0D */	U2E_NODEST_COLX,
	/* U+4B0E */	U2E_NODEST_COLX,
	/* U+4B0F */	U2E_NODEST_COLX,
	/* U+4B10 */	U2E_NODEST_COLX,
	/* U+4B11 */	U2E_NODEST_COLX,
	/* U+4B12 */	U2E_NODEST_COLX,
	/* U+4B13 */	U2E_NODEST_COLX,
	/* U+4B14 */	U2E_NODEST_COLX,
	/* U+4B15 */	U2E_NODEST_COLX,
	/* U+4B16 */	U2E_NODEST_COLX,
	/* U+4B17 */	U2E_NODEST_COLX,
	/* U+4B18 */	U2E_NODEST_COLX,
	/* U+4B19 */	U2E_NODEST_COLX,
	/* U+4B1A */	U2E_NODEST_COLX,
	/* U+4B1B */	U2E_NODEST_COLX,
	/* U+4B1C */	U2E_NODEST_COLX,
	/* U+4B1D */	U2E_NODEST_COLX,
	/* U+4B1E */	U2E_NODEST_COLX,
	/* U+4B1F */	U2E_NODEST_COLX,
	/* U+4B20 */	U2E_NODEST_COLX,
	/* U+4B21 */	U2E_NODEST_COLX,
	/* U+4B22 */	U2E_NODEST_COLX,
	/* U+4B23 */	U2E_NODEST_COLX,
	/* U+4B24 */	U2E_NODEST_COLX,
	/* U+4B25 */	U2E_NODEST_COLX,
	/* U+4B26 */	U2E_NODEST_COLX,
	/* U+4B27 */	U2E_NODEST_COLX,
	/* U+4B28 */	U2E_NODEST_COLX,
	/* U+4B29 */	U2E_NODEST_COLX,
	/* U+4B2A */	U2E_NODEST_COLX,
	/* U+4B2B */	U2E_NODEST_COLX,
	/* U+4B2C */	U2E_NODEST_COLX,
	/* U+4B2D */	U2E_NODEST_COLX,
	/* U+4B2E */	U2E_NODEST_COLX,
	/* U+4B2F */	U2E_NODEST_COLX,
	/* U+4B30 */	U2E_NODEST_COLX,
	/* U+4B31 */	U2E_NODEST_COLX,
	/* U+4B32 */	U2E_NODEST_COLX,
	/* U+4B33 */	U2E_NODEST_COLX,
	/* U+4B34 */	U2E_NODEST_COLX,
	/* U+4B35 */	U2E_NODEST_COLX,
	/* U+4B36 */	U2E_NODEST_COLX,
	/* U+4B37 */	U2E_NODEST_COLX,
	/* U+4B38 */	U2E_NODEST_COLX,
	/* U+4B39 */	U2E_NODEST_COLX,
	/* U+4B3A */	U2E_NODEST_COLX,
	/* U+4B3B */	IFX0213(JISX0213_2(0xfc55),	U2E_NODEST_COLX),
	/* U+4B3C */	U2E_NODEST_COLX,
	/* U+4B3D */	U2E_NODEST_COLX,
	/* U+4B3E */	U2E_NODEST_COLX,
	/* U+4B3F */	U2E_NODEST_COLX,
	/* U+4B40 */	U2E_NODEST_COLX,
	/* U+4B41 */	U2E_NODEST_COLX,
	/* U+4B42 */	U2E_NODEST_COLX,
	/* U+4B43 */	U2E_NODEST_COLX,
	/* U+4B44 */	U2E_NODEST_COLX,
	/* U+4B45 */	U2E_NODEST_COLX,
	/* U+4B46 */	U2E_NODEST_COLX,
	/* U+4B47 */	U2E_NODEST_COLX,
	/* U+4B48 */	U2E_NODEST_COLX,
	/* U+4B49 */	U2E_NODEST_COLX,
	/* U+4B4A */	U2E_NODEST_COLX,
	/* U+4B4B */	U2E_NODEST_COLX,
	/* U+4B4C */	U2E_NODEST_COLX,
	/* U+4B4D */	U2E_NODEST_COLX,
	/* U+4B4E */	U2E_NODEST_COLX,
	/* U+4B4F */	U2E_NODEST_COLX,
	/* U+4B50 */	U2E_NODEST_COLX,
	/* U+4B51 */	U2E_NODEST_COLX,
	/* U+4B52 */	U2E_NODEST_COLX,
	/* U+4B53 */	U2E_NODEST_COLX,
	/* U+4B54 */	U2E_NODEST_COLX,
	/* U+4B55 */	U2E_NODEST_COLX,
	/* U+4B56 */	U2E_NODEST_COLX,
	/* U+4B57 */	U2E_NODEST_COLX,
	/* U+4B58 */	U2E_NODEST_COLX,
	/* U+4B59 */	U2E_NODEST_COLX,
	/* U+4B5A */	U2E_NODEST_COLX,
	/* U+4B5B */	U2E_NODEST_COLX,
	/* U+4B5C */	U2E_NODEST_COLX,
	/* U+4B5D */	U2E_NODEST_COLX,
	/* U+4B5E */	U2E_NODEST_COLX,
	/* U+4B5F */	U2E_NODEST_COLX,
	/* U+4B60 */	U2E_NODEST_COLX,
	/* U+4B61 */	U2E_NODEST_COLX,
	/* U+4B62 */	U2E_NODEST_COLX,
	/* U+4B63 */	U2E_NODEST_COLX,
	/* U+4B64 */	U2E_NODEST_COLX,
	/* U+4B65 */	U2E_NODEST_COLX,
	/* U+4B66 */	U2E_NODEST_COLX,
	/* U+4B67 */	U2E_NODEST_COLX,
	/* U+4B68 */	U2E_NODEST_COLX,
	/* U+4B69 */	U2E_NODEST_COLX,
	/* U+4B6A */	U2E_NODEST_COLX,
	/* U+4B6B */	U2E_NODEST_COLX,
	/* U+4B6C */	U2E_NODEST_COLX,
	/* U+4B6D */	U2E_NODEST_COLX,
	/* U+4B6E */	U2E_NODEST_COLX,
	/* U+4B6F */	U2E_NODEST_COLX,
	/* U+4B70 */	U2E_NODEST_COLX,
	/* U+4B71 */	U2E_NODEST_COLX,
	/* U+4B72 */	U2E_NODEST_COLX,
	/* U+4B73 */	U2E_NODEST_COLX,
	/* U+4B74 */	U2E_NODEST_COLX,
	/* U+4B75 */	U2E_NODEST_COLX,
	/* U+4B76 */	U2E_NODEST_COLX,
	/* U+4B77 */	U2E_NODEST_COLX,
	/* U+4B78 */	U2E_NODEST_COLX,
	/* U+4B79 */	U2E_NODEST_COLX,
	/* U+4B7A */	U2E_NODEST_COLX,
	/* U+4B7B */	U2E_NODEST_COLX,
	/* U+4B7C */	U2E_NODEST_COLX,
	/* U+4B7D */	U2E_NODEST_COLX,
	/* U+4B7E */	U2E_NODEST_COLX,
	/* U+4B7F */	U2E_NODEST_COLX,
	/* U+4B80 */	U2E_NODEST_COLX,
	/* U+4B81 */	U2E_NODEST_COLX,
	/* U+4B82 */	U2E_NODEST_COLX,
	/* U+4B83 */	U2E_NODEST_COLX,
	/* U+4B84 */	U2E_NODEST_COLX,
	/* U+4B85 */	U2E_NODEST_COLX,
	/* U+4B86 */	U2E_NODEST_COLX,
	/* U+4B87 */	U2E_NODEST_COLX,
	/* U+4B88 */	U2E_NODEST_COLX,
	/* U+4B89 */	U2E_NODEST_COLX,
	/* U+4B8A */	U2E_NODEST_COLX,
	/* U+4B8B */	U2E_NODEST_COLX,
	/* U+4B8C */	U2E_NODEST_COLX,
	/* U+4B8D */	U2E_NODEST_COLX,
	/* U+4B8E */	U2E_NODEST_COLX,
	/* U+4B8F */	U2E_NODEST_COLX,
	/* U+4B90 */	U2E_NODEST_COLX,
	/* U+4B91 */	U2E_NODEST_COLX,
	/* U+4B92 */	U2E_NODEST_COLX,
	/* U+4B93 */	U2E_NODEST_COLX,
	/* U+4B94 */	U2E_NODEST_COLX,
	/* U+4B95 */	U2E_NODEST_COLX,
	/* U+4B96 */	U2E_NODEST_COLX,
	/* U+4B97 */	U2E_NODEST_COLX,
	/* U+4B98 */	U2E_NODEST_COLX,
	/* U+4B99 */	U2E_NODEST_COLX,
	/* U+4B9A */	U2E_NODEST_COLX,
	/* U+4B9B */	U2E_NODEST_COLX,
	/* U+4B9C */	U2E_NODEST_COLX,
	/* U+4B9D */	U2E_NODEST_COLX,
	/* U+4B9E */	U2E_NODEST_COLX,
	/* U+4B9F */	U2E_NODEST_COLX,
	/* U+4BA0 */	U2E_NODEST_COLX,
	/* U+4BA1 */	U2E_NODEST_COLX,
	/* U+4BA2 */	U2E_NODEST_COLX,
	/* U+4BA3 */	U2E_NODEST_COLX,
	/* U+4BA4 */	U2E_NODEST_COLX,
	/* U+4BA5 */	U2E_NODEST_COLX,
	/* U+4BA6 */	U2E_NODEST_COLX,
	/* U+4BA7 */	U2E_NODEST_COLX,
	/* U+4BA8 */	U2E_NODEST_COLX,
	/* U+4BA9 */	U2E_NODEST_COLX,
	/* U+4BAA */	U2E_NODEST_COLX,
	/* U+4BAB */	U2E_NODEST_COLX,
	/* U+4BAC */	U2E_NODEST_COLX,
	/* U+4BAD */	U2E_NODEST_COLX,
	/* U+4BAE */	U2E_NODEST_COLX,
	/* U+4BAF */	U2E_NODEST_COLX,
	/* U+4BB0 */	U2E_NODEST_COLX,
	/* U+4BB1 */	U2E_NODEST_COLX,
	/* U+4BB2 */	U2E_NODEST_COLX,
	/* U+4BB3 */	U2E_NODEST_COLX,
	/* U+4BB4 */	U2E_NODEST_COLX,
	/* U+4BB5 */	U2E_NODEST_COLX,
	/* U+4BB6 */	U2E_NODEST_COLX,
	/* U+4BB7 */	U2E_NODEST_COLX,
	/* U+4BB8 */	U2E_NODEST_COLX,
	/* U+4BB9 */	U2E_NODEST_COLX,
	/* U+4BBA */	U2E_NODEST_COLX,
	/* U+4BBB */	U2E_NODEST_COLX,
	/* U+4BBC */	U2E_NODEST_COLX,
	/* U+4BBD */	U2E_NODEST_COLX,
	/* U+4BBE */	U2E_NODEST_COLX,
	/* U+4BBF */	U2E_NODEST_COLX,
	/* U+4BC0 */	U2E_NODEST_COLX,
	/* U+4BC1 */	U2E_NODEST_COLX,
	/* U+4BC2 */	IFX0213(JISX0213_2(0xfd26),	U2E_NODEST_COLX),
	/* U+4BC3 */	U2E_NODEST_COLX,
	/* U+4BC4 */	U2E_NODEST_COLX,
	/* U+4BC5 */	U2E_NODEST_COLX,
	/* U+4BC6 */	U2E_NODEST_COLX,
	/* U+4BC7 */	U2E_NODEST_COLX,
	/* U+4BC8 */	U2E_NODEST_COLX,
	/* U+4BC9 */	U2E_NODEST_COLX,
	/* U+4BCA */	IFX0213(JISX0213_2(0xfd28),	U2E_NODEST_COLX),
	/* U+4BCB */	U2E_NODEST_COLX,
	/* U+4BCC */	U2E_NODEST_COLX,
	/* U+4BCD */	U2E_NODEST_COLX,
	/* U+4BCE */	U2E_NODEST_COLX,
	/* U+4BCF */	U2E_NODEST_COLX,
	/* U+4BD0 */	U2E_NODEST_COLX,
	/* U+4BD1 */	U2E_NODEST_COLX,
	/* U+4BD2 */	IFX0213(JISX0213_2(0xfd2a),	U2E_NODEST_COLX),
	/* U+4BD3 */	U2E_NODEST_COLX,
	/* U+4BD4 */	U2E_NODEST_COLX,
	/* U+4BD5 */	U2E_NODEST_COLX,
	/* U+4BD6 */	U2E_NODEST_COLX,
	/* U+4BD7 */	U2E_NODEST_COLX,
	/* U+4BD8 */	U2E_NODEST_COLX,
	/* U+4BD9 */	U2E_NODEST_COLX,
	/* U+4BDA */	U2E_NODEST_COLX,
	/* U+4BDB */	U2E_NODEST_COLX,
	/* U+4BDC */	U2E_NODEST_COLX,
	/* U+4BDD */	U2E_NODEST_COLX,
	/* U+4BDE */	U2E_NODEST_COLX,
	/* U+4BDF */	U2E_NODEST_COLX,
	/* U+4BE0 */	U2E_NODEST_COLX,
	/* U+4BE1 */	U2E_NODEST_COLX,
	/* U+4BE2 */	U2E_NODEST_COLX,
	/* U+4BE3 */	U2E_NODEST_COLX,
	/* U+4BE4 */	U2E_NODEST_COLX,
	/* U+4BE5 */	U2E_NODEST_COLX,
	/* U+4BE6 */	U2E_NODEST_COLX,
	/* U+4BE7 */	U2E_NODEST_COLX,
	/* U+4BE8 */	IFX0213(JISX0213_2(0xfd31),	U2E_NODEST_COLX),
	/* U+4BE9 */	U2E_NODEST_COLX,
	/* U+4BEA */	U2E_NODEST_COLX,
	/* U+4BEB */	U2E_NODEST_COLX,
	/* U+4BEC */	U2E_NODEST_COLX,
	/* U+4BED */	U2E_NODEST_COLX,
	/* U+4BEE */	U2E_NODEST_COLX,
	/* U+4BEF */	U2E_NODEST_COLX,
	/* U+4BF0 */	U2E_NODEST_COLX,
	/* U+4BF1 */	U2E_NODEST_COLX,
	/* U+4BF2 */	U2E_NODEST_COLX,
	/* U+4BF3 */	U2E_NODEST_COLX,
	/* U+4BF4 */	U2E_NODEST_COLX,
	/* U+4BF5 */	U2E_NODEST_COLX,
	/* U+4BF6 */	U2E_NODEST_COLX,
	/* U+4BF7 */	U2E_NODEST_COLX,
	/* U+4BF8 */	U2E_NODEST_COLX,
	/* U+4BF9 */	U2E_NODEST_COLX,
	/* U+4BFA */	U2E_NODEST_COLX,
	/* U+4BFB */	U2E_NODEST_COLX,
	/* U+4BFC */	U2E_NODEST_COLX,
	/* U+4BFD */	U2E_NODEST_COLX,
	/* U+4BFE */	U2E_NODEST_COLX,
	/* U+4BFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_4C[] = {
	/* U+4C00 */	U2E_NODEST_COLX,
	/* U+4C01 */	U2E_NODEST_COLX,
	/* U+4C02 */	U2E_NODEST_COLX,
	/* U+4C03 */	U2E_NODEST_COLX,
	/* U+4C04 */	U2E_NODEST_COLX,
	/* U+4C05 */	U2E_NODEST_COLX,
	/* U+4C06 */	U2E_NODEST_COLX,
	/* U+4C07 */	U2E_NODEST_COLX,
	/* U+4C08 */	U2E_NODEST_COLX,
	/* U+4C09 */	U2E_NODEST_COLX,
	/* U+4C0A */	U2E_NODEST_COLX,
	/* U+4C0B */	U2E_NODEST_COLX,
	/* U+4C0C */	U2E_NODEST_COLX,
	/* U+4C0D */	U2E_NODEST_COLX,
	/* U+4C0E */	U2E_NODEST_COLX,
	/* U+4C0F */	U2E_NODEST_COLX,
	/* U+4C10 */	U2E_NODEST_COLX,
	/* U+4C11 */	U2E_NODEST_COLX,
	/* U+4C12 */	U2E_NODEST_COLX,
	/* U+4C13 */	U2E_NODEST_COLX,
	/* U+4C14 */	U2E_NODEST_COLX,
	/* U+4C15 */	U2E_NODEST_COLX,
	/* U+4C16 */	U2E_NODEST_COLX,
	/* U+4C17 */	IFX0213(JISX0213_1(0xfebe),	U2E_NODEST_COLX),
	/* U+4C18 */	U2E_NODEST_COLX,
	/* U+4C19 */	U2E_NODEST_COLX,
	/* U+4C1A */	U2E_NODEST_COLX,
	/* U+4C1B */	U2E_NODEST_COLX,
	/* U+4C1C */	U2E_NODEST_COLX,
	/* U+4C1D */	U2E_NODEST_COLX,
	/* U+4C1E */	U2E_NODEST_COLX,
	/* U+4C1F */	U2E_NODEST_COLX,
	/* U+4C20 */	IFX0213(JISX0213_2(0xfd3f),	U2E_NODEST_COLX),
	/* U+4C21 */	U2E_NODEST_COLX,
	/* U+4C22 */	U2E_NODEST_COLX,
	/* U+4C23 */	U2E_NODEST_COLX,
	/* U+4C24 */	U2E_NODEST_COLX,
	/* U+4C25 */	U2E_NODEST_COLX,
	/* U+4C26 */	U2E_NODEST_COLX,
	/* U+4C27 */	U2E_NODEST_COLX,
	/* U+4C28 */	U2E_NODEST_COLX,
	/* U+4C29 */	U2E_NODEST_COLX,
	/* U+4C2A */	U2E_NODEST_COLX,
	/* U+4C2B */	U2E_NODEST_COLX,
	/* U+4C2C */	U2E_NODEST_COLX,
	/* U+4C2D */	U2E_NODEST_COLX,
	/* U+4C2E */	U2E_NODEST_COLX,
	/* U+4C2F */	U2E_NODEST_COLX,
	/* U+4C30 */	U2E_NODEST_COLX,
	/* U+4C31 */	U2E_NODEST_COLX,
	/* U+4C32 */	U2E_NODEST_COLX,
	/* U+4C33 */	U2E_NODEST_COLX,
	/* U+4C34 */	U2E_NODEST_COLX,
	/* U+4C35 */	U2E_NODEST_COLX,
	/* U+4C36 */	U2E_NODEST_COLX,
	/* U+4C37 */	U2E_NODEST_COLX,
	/* U+4C38 */	U2E_NODEST_COLX,
	/* U+4C39 */	U2E_NODEST_COLX,
	/* U+4C3A */	U2E_NODEST_COLX,
	/* U+4C3B */	U2E_NODEST_COLX,
	/* U+4C3C */	U2E_NODEST_COLX,
	/* U+4C3D */	U2E_NODEST_COLX,
	/* U+4C3E */	U2E_NODEST_COLX,
	/* U+4C3F */	U2E_NODEST_COLX,
	/* U+4C40 */	U2E_NODEST_COLX,
	/* U+4C41 */	U2E_NODEST_COLX,
	/* U+4C42 */	U2E_NODEST_COLX,
	/* U+4C43 */	U2E_NODEST_COLX,
	/* U+4C44 */	U2E_NODEST_COLX,
	/* U+4C45 */	U2E_NODEST_COLX,
	/* U+4C46 */	U2E_NODEST_COLX,
	/* U+4C47 */	U2E_NODEST_COLX,
	/* U+4C48 */	U2E_NODEST_COLX,
	/* U+4C49 */	U2E_NODEST_COLX,
	/* U+4C4A */	U2E_NODEST_COLX,
	/* U+4C4B */	U2E_NODEST_COLX,
	/* U+4C4C */	U2E_NODEST_COLX,
	/* U+4C4D */	U2E_NODEST_COLX,
	/* U+4C4E */	U2E_NODEST_COLX,
	/* U+4C4F */	U2E_NODEST_COLX,
	/* U+4C50 */	U2E_NODEST_COLX,
	/* U+4C51 */	U2E_NODEST_COLX,
	/* U+4C52 */	U2E_NODEST_COLX,
	/* U+4C53 */	U2E_NODEST_COLX,
	/* U+4C54 */	U2E_NODEST_COLX,
	/* U+4C55 */	U2E_NODEST_COLX,
	/* U+4C56 */	U2E_NODEST_COLX,
	/* U+4C57 */	U2E_NODEST_COLX,
	/* U+4C58 */	U2E_NODEST_COLX,
	/* U+4C59 */	U2E_NODEST_COLX,
	/* U+4C5A */	U2E_NODEST_COLX,
	/* U+4C5B */	U2E_NODEST_COLX,
	/* U+4C5C */	U2E_NODEST_COLX,
	/* U+4C5D */	U2E_NODEST_COLX,
	/* U+4C5E */	U2E_NODEST_COLX,
	/* U+4C5F */	U2E_NODEST_COLX,
	/* U+4C60 */	U2E_NODEST_COLX,
	/* U+4C61 */	U2E_NODEST_COLX,
	/* U+4C62 */	U2E_NODEST_COLX,
	/* U+4C63 */	U2E_NODEST_COLX,
	/* U+4C64 */	U2E_NODEST_COLX,
	/* U+4C65 */	U2E_NODEST_COLX,
	/* U+4C66 */	U2E_NODEST_COLX,
	/* U+4C67 */	U2E_NODEST_COLX,
	/* U+4C68 */	U2E_NODEST_COLX,
	/* U+4C69 */	U2E_NODEST_COLX,
	/* U+4C6A */	U2E_NODEST_COLX,
	/* U+4C6B */	U2E_NODEST_COLX,
	/* U+4C6C */	U2E_NODEST_COLX,
	/* U+4C6D */	U2E_NODEST_COLX,
	/* U+4C6E */	U2E_NODEST_COLX,
	/* U+4C6F */	U2E_NODEST_COLX,
	/* U+4C70 */	U2E_NODEST_COLX,
	/* U+4C71 */	U2E_NODEST_COLX,
	/* U+4C72 */	U2E_NODEST_COLX,
	/* U+4C73 */	U2E_NODEST_COLX,
	/* U+4C74 */	U2E_NODEST_COLX,
	/* U+4C75 */	U2E_NODEST_COLX,
	/* U+4C76 */	U2E_NODEST_COLX,
	/* U+4C77 */	U2E_NODEST_COLX,
	/* U+4C78 */	U2E_NODEST_COLX,
	/* U+4C79 */	U2E_NODEST_COLX,
	/* U+4C7A */	U2E_NODEST_COLX,
	/* U+4C7B */	U2E_NODEST_COLX,
	/* U+4C7C */	U2E_NODEST_COLX,
	/* U+4C7D */	U2E_NODEST_COLX,
	/* U+4C7E */	U2E_NODEST_COLX,
	/* U+4C7F */	U2E_NODEST_COLX,
	/* U+4C80 */	U2E_NODEST_COLX,
	/* U+4C81 */	U2E_NODEST_COLX,
	/* U+4C82 */	U2E_NODEST_COLX,
	/* U+4C83 */	U2E_NODEST_COLX,
	/* U+4C84 */	U2E_NODEST_COLX,
	/* U+4C85 */	U2E_NODEST_COLX,
	/* U+4C86 */	U2E_NODEST_COLX,
	/* U+4C87 */	U2E_NODEST_COLX,
	/* U+4C88 */	U2E_NODEST_COLX,
	/* U+4C89 */	U2E_NODEST_COLX,
	/* U+4C8A */	U2E_NODEST_COLX,
	/* U+4C8B */	U2E_NODEST_COLX,
	/* U+4C8C */	U2E_NODEST_COLX,
	/* U+4C8D */	U2E_NODEST_COLX,
	/* U+4C8E */	U2E_NODEST_COLX,
	/* U+4C8F */	U2E_NODEST_COLX,
	/* U+4C90 */	U2E_NODEST_COLX,
	/* U+4C91 */	U2E_NODEST_COLX,
	/* U+4C92 */	U2E_NODEST_COLX,
	/* U+4C93 */	U2E_NODEST_COLX,
	/* U+4C94 */	U2E_NODEST_COLX,
	/* U+4C95 */	U2E_NODEST_COLX,
	/* U+4C96 */	U2E_NODEST_COLX,
	/* U+4C97 */	U2E_NODEST_COLX,
	/* U+4C98 */	U2E_NODEST_COLX,
	/* U+4C99 */	U2E_NODEST_COLX,
	/* U+4C9A */	U2E_NODEST_COLX,
	/* U+4C9B */	U2E_NODEST_COLX,
	/* U+4C9C */	U2E_NODEST_COLX,
	/* U+4C9D */	U2E_NODEST_COLX,
	/* U+4C9E */	U2E_NODEST_COLX,
	/* U+4C9F */	U2E_NODEST_COLX,
	/* U+4CA0 */	U2E_NODEST_COLX,
	/* U+4CA1 */	U2E_NODEST_COLX,
	/* U+4CA2 */	U2E_NODEST_COLX,
	/* U+4CA3 */	U2E_NODEST_COLX,
	/* U+4CA4 */	U2E_NODEST_COLX,
	/* U+4CA5 */	U2E_NODEST_COLX,
	/* U+4CA6 */	U2E_NODEST_COLX,
	/* U+4CA7 */	U2E_NODEST_COLX,
	/* U+4CA8 */	U2E_NODEST_COLX,
	/* U+4CA9 */	U2E_NODEST_COLX,
	/* U+4CAA */	U2E_NODEST_COLX,
	/* U+4CAB */	U2E_NODEST_COLX,
	/* U+4CAC */	U2E_NODEST_COLX,
	/* U+4CAD */	U2E_NODEST_COLX,
	/* U+4CAE */	U2E_NODEST_COLX,
	/* U+4CAF */	U2E_NODEST_COLX,
	/* U+4CB0 */	U2E_NODEST_COLX,
	/* U+4CB1 */	U2E_NODEST_COLX,
	/* U+4CB2 */	U2E_NODEST_COLX,
	/* U+4CB3 */	U2E_NODEST_COLX,
	/* U+4CB4 */	U2E_NODEST_COLX,
	/* U+4CB5 */	U2E_NODEST_COLX,
	/* U+4CB6 */	U2E_NODEST_COLX,
	/* U+4CB7 */	U2E_NODEST_COLX,
	/* U+4CB8 */	U2E_NODEST_COLX,
	/* U+4CB9 */	U2E_NODEST_COLX,
	/* U+4CBA */	U2E_NODEST_COLX,
	/* U+4CBB */	U2E_NODEST_COLX,
	/* U+4CBC */	U2E_NODEST_COLX,
	/* U+4CBD */	U2E_NODEST_COLX,
	/* U+4CBE */	U2E_NODEST_COLX,
	/* U+4CBF */	U2E_NODEST_COLX,
	/* U+4CC0 */	U2E_NODEST_COLX,
	/* U+4CC1 */	U2E_NODEST_COLX,
	/* U+4CC2 */	U2E_NODEST_COLX,
	/* U+4CC3 */	U2E_NODEST_COLX,
	/* U+4CC4 */	IFX0213(JISX0213_2(0xfe2a),	U2E_NODEST_COLX),
	/* U+4CC5 */	U2E_NODEST_COLX,
	/* U+4CC6 */	U2E_NODEST_COLX,
	/* U+4CC7 */	U2E_NODEST_COLX,
	/* U+4CC8 */	U2E_NODEST_COLX,
	/* U+4CC9 */	U2E_NODEST_COLX,
	/* U+4CCA */	U2E_NODEST_COLX,
	/* U+4CCB */	U2E_NODEST_COLX,
	/* U+4CCC */	U2E_NODEST_COLX,
	/* U+4CCD */	U2E_NODEST_COLX,
	/* U+4CCE */	U2E_NODEST_COLX,
	/* U+4CCF */	U2E_NODEST_COLX,
	/* U+4CD0 */	U2E_NODEST_COLX,
	/* U+4CD1 */	IFX0213(JISX0213_2(0xfe2d),	U2E_NODEST_COLX),
	/* U+4CD2 */	U2E_NODEST_COLX,
	/* U+4CD3 */	U2E_NODEST_COLX,
	/* U+4CD4 */	U2E_NODEST_COLX,
	/* U+4CD5 */	U2E_NODEST_COLX,
	/* U+4CD6 */	U2E_NODEST_COLX,
	/* U+4CD7 */	U2E_NODEST_COLX,
	/* U+4CD8 */	U2E_NODEST_COLX,
	/* U+4CD9 */	U2E_NODEST_COLX,
	/* U+4CDA */	U2E_NODEST_COLX,
	/* U+4CDB */	U2E_NODEST_COLX,
	/* U+4CDC */	U2E_NODEST_COLX,
	/* U+4CDD */	U2E_NODEST_COLX,
	/* U+4CDE */	U2E_NODEST_COLX,
	/* U+4CDF */	U2E_NODEST_COLX,
	/* U+4CE0 */	U2E_NODEST_COLX,
	/* U+4CE1 */	U2E_NODEST_COLX,
	/* U+4CE2 */	U2E_NODEST_COLX,
	/* U+4CE3 */	U2E_NODEST_COLX,
	/* U+4CE4 */	U2E_NODEST_COLX,
	/* U+4CE5 */	U2E_NODEST_COLX,
	/* U+4CE6 */	U2E_NODEST_COLX,
	/* U+4CE7 */	U2E_NODEST_COLX,
	/* U+4CE8 */	U2E_NODEST_COLX,
	/* U+4CE9 */	U2E_NODEST_COLX,
	/* U+4CEA */	U2E_NODEST_COLX,
	/* U+4CEB */	U2E_NODEST_COLX,
	/* U+4CEC */	U2E_NODEST_COLX,
	/* U+4CED */	U2E_NODEST_COLX,
	/* U+4CEE */	U2E_NODEST_COLX,
	/* U+4CEF */	U2E_NODEST_COLX,
	/* U+4CF0 */	U2E_NODEST_COLX,
	/* U+4CF1 */	U2E_NODEST_COLX,
	/* U+4CF2 */	U2E_NODEST_COLX,
	/* U+4CF3 */	U2E_NODEST_COLX,
	/* U+4CF4 */	U2E_NODEST_COLX,
	/* U+4CF5 */	U2E_NODEST_COLX,
	/* U+4CF6 */	U2E_NODEST_COLX,
	/* U+4CF7 */	U2E_NODEST_COLX,
	/* U+4CF8 */	U2E_NODEST_COLX,
	/* U+4CF9 */	U2E_NODEST_COLX,
	/* U+4CFA */	U2E_NODEST_COLX,
	/* U+4CFB */	U2E_NODEST_COLX,
	/* U+4CFC */	U2E_NODEST_COLX,
	/* U+4CFD */	U2E_NODEST_COLX,
	/* U+4CFE */	U2E_NODEST_COLX,
	/* U+4CFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_4D[] = {
	/* U+4D00 */	U2E_NODEST_COLX,
	/* U+4D01 */	U2E_NODEST_COLX,
	/* U+4D02 */	U2E_NODEST_COLX,
	/* U+4D03 */	U2E_NODEST_COLX,
	/* U+4D04 */	U2E_NODEST_COLX,
	/* U+4D05 */	U2E_NODEST_COLX,
	/* U+4D06 */	U2E_NODEST_COLX,
	/* U+4D07 */	IFX0213(JISX0213_2(0xfe4b),	U2E_NODEST_COLX),
	/* U+4D08 */	U2E_NODEST_COLX,
	/* U+4D09 */	U2E_NODEST_COLX,
	/* U+4D0A */	U2E_NODEST_COLX,
	/* U+4D0B */	U2E_NODEST_COLX,
	/* U+4D0C */	U2E_NODEST_COLX,
	/* U+4D0D */	U2E_NODEST_COLX,
	/* U+4D0E */	U2E_NODEST_COLX,
	/* U+4D0F */	U2E_NODEST_COLX,
	/* U+4D10 */	U2E_NODEST_COLX,
	/* U+4D11 */	U2E_NODEST_COLX,
	/* U+4D12 */	U2E_NODEST_COLX,
	/* U+4D13 */	U2E_NODEST_COLX,
	/* U+4D14 */	U2E_NODEST_COLX,
	/* U+4D15 */	U2E_NODEST_COLX,
	/* U+4D16 */	U2E_NODEST_COLX,
	/* U+4D17 */	U2E_NODEST_COLX,
	/* U+4D18 */	U2E_NODEST_COLX,
	/* U+4D19 */	U2E_NODEST_COLX,
	/* U+4D1A */	U2E_NODEST_COLX,
	/* U+4D1B */	U2E_NODEST_COLX,
	/* U+4D1C */	U2E_NODEST_COLX,
	/* U+4D1D */	U2E_NODEST_COLX,
	/* U+4D1E */	U2E_NODEST_COLX,
	/* U+4D1F */	U2E_NODEST_COLX,
	/* U+4D20 */	U2E_NODEST_COLX,
	/* U+4D21 */	U2E_NODEST_COLX,
	/* U+4D22 */	U2E_NODEST_COLX,
	/* U+4D23 */	U2E_NODEST_COLX,
	/* U+4D24 */	U2E_NODEST_COLX,
	/* U+4D25 */	U2E_NODEST_COLX,
	/* U+4D26 */	U2E_NODEST_COLX,
	/* U+4D27 */	U2E_NODEST_COLX,
	/* U+4D28 */	U2E_NODEST_COLX,
	/* U+4D29 */	U2E_NODEST_COLX,
	/* U+4D2A */	U2E_NODEST_COLX,
	/* U+4D2B */	U2E_NODEST_COLX,
	/* U+4D2C */	U2E_NODEST_COLX,
	/* U+4D2D */	U2E_NODEST_COLX,
	/* U+4D2E */	U2E_NODEST_COLX,
	/* U+4D2F */	U2E_NODEST_COLX,
	/* U+4D30 */	U2E_NODEST_COLX,
	/* U+4D31 */	U2E_NODEST_COLX,
	/* U+4D32 */	U2E_NODEST_COLX,
	/* U+4D33 */	U2E_NODEST_COLX,
	/* U+4D34 */	U2E_NODEST_COLX,
	/* U+4D35 */	U2E_NODEST_COLX,
	/* U+4D36 */	U2E_NODEST_COLX,
	/* U+4D37 */	U2E_NODEST_COLX,
	/* U+4D38 */	U2E_NODEST_COLX,
	/* U+4D39 */	U2E_NODEST_COLX,
	/* U+4D3A */	U2E_NODEST_COLX,
	/* U+4D3B */	U2E_NODEST_COLX,
	/* U+4D3C */	U2E_NODEST_COLX,
	/* U+4D3D */	U2E_NODEST_COLX,
	/* U+4D3E */	U2E_NODEST_COLX,
	/* U+4D3F */	U2E_NODEST_COLX,
	/* U+4D40 */	U2E_NODEST_COLX,
	/* U+4D41 */	U2E_NODEST_COLX,
	/* U+4D42 */	U2E_NODEST_COLX,
	/* U+4D43 */	U2E_NODEST_COLX,
	/* U+4D44 */	U2E_NODEST_COLX,
	/* U+4D45 */	U2E_NODEST_COLX,
	/* U+4D46 */	U2E_NODEST_COLX,
	/* U+4D47 */	U2E_NODEST_COLX,
	/* U+4D48 */	U2E_NODEST_COLX,
	/* U+4D49 */	U2E_NODEST_COLX,
	/* U+4D4A */	U2E_NODEST_COLX,
	/* U+4D4B */	U2E_NODEST_COLX,
	/* U+4D4C */	U2E_NODEST_COLX,
	/* U+4D4D */	U2E_NODEST_COLX,
	/* U+4D4E */	U2E_NODEST_COLX,
	/* U+4D4F */	U2E_NODEST_COLX,
	/* U+4D50 */	U2E_NODEST_COLX,
	/* U+4D51 */	U2E_NODEST_COLX,
	/* U+4D52 */	U2E_NODEST_COLX,
	/* U+4D53 */	U2E_NODEST_COLX,
	/* U+4D54 */	U2E_NODEST_COLX,
	/* U+4D55 */	U2E_NODEST_COLX,
	/* U+4D56 */	U2E_NODEST_COLX,
	/* U+4D57 */	U2E_NODEST_COLX,
	/* U+4D58 */	U2E_NODEST_COLX,
	/* U+4D59 */	U2E_NODEST_COLX,
	/* U+4D5A */	U2E_NODEST_COLX,
	/* U+4D5B */	U2E_NODEST_COLX,
	/* U+4D5C */	U2E_NODEST_COLX,
	/* U+4D5D */	U2E_NODEST_COLX,
	/* U+4D5E */	U2E_NODEST_COLX,
	/* U+4D5F */	U2E_NODEST_COLX,
	/* U+4D60 */	U2E_NODEST_COLX,
	/* U+4D61 */	U2E_NODEST_COLX,
	/* U+4D62 */	U2E_NODEST_COLX,
	/* U+4D63 */	U2E_NODEST_COLX,
	/* U+4D64 */	U2E_NODEST_COLX,
	/* U+4D65 */	U2E_NODEST_COLX,
	/* U+4D66 */	U2E_NODEST_COLX,
	/* U+4D67 */	U2E_NODEST_COLX,
	/* U+4D68 */	U2E_NODEST_COLX,
	/* U+4D69 */	U2E_NODEST_COLX,
	/* U+4D6A */	U2E_NODEST_COLX,
	/* U+4D6B */	U2E_NODEST_COLX,
	/* U+4D6C */	U2E_NODEST_COLX,
	/* U+4D6D */	U2E_NODEST_COLX,
	/* U+4D6E */	U2E_NODEST_COLX,
	/* U+4D6F */	U2E_NODEST_COLX,
	/* U+4D70 */	U2E_NODEST_COLX,
	/* U+4D71 */	U2E_NODEST_COLX,
	/* U+4D72 */	U2E_NODEST_COLX,
	/* U+4D73 */	U2E_NODEST_COLX,
	/* U+4D74 */	U2E_NODEST_COLX,
	/* U+4D75 */	U2E_NODEST_COLX,
	/* U+4D76 */	U2E_NODEST_COLX,
	/* U+4D77 */	IFX0213(JISX0213_2(0xfe60),	U2E_NODEST_COLX),
	/* U+4D78 */	U2E_NODEST_COLX,
	/* U+4D79 */	U2E_NODEST_COLX,
	/* U+4D7A */	U2E_NODEST_COLX,
	/* U+4D7B */	U2E_NODEST_COLX,
	/* U+4D7C */	U2E_NODEST_COLX,
	/* U+4D7D */	U2E_NODEST_COLX,
	/* U+4D7E */	U2E_NODEST_COLX,
	/* U+4D7F */	U2E_NODEST_COLX,
	/* U+4D80 */	U2E_NODEST_COLX,
	/* U+4D81 */	U2E_NODEST_COLX,
	/* U+4D82 */	U2E_NODEST_COLX,
	/* U+4D83 */	U2E_NODEST_COLX,
	/* U+4D84 */	U2E_NODEST_COLX,
	/* U+4D85 */	U2E_NODEST_COLX,
	/* U+4D86 */	U2E_NODEST_COLX,
	/* U+4D87 */	U2E_NODEST_COLX,
	/* U+4D88 */	U2E_NODEST_COLX,
	/* U+4D89 */	U2E_NODEST_COLX,
	/* U+4D8A */	U2E_NODEST_COLX,
	/* U+4D8B */	U2E_NODEST_COLX,
	/* U+4D8C */	U2E_NODEST_COLX,
	/* U+4D8D */	U2E_NODEST_COLX,
	/* U+4D8E */	U2E_NODEST_COLX,
	/* U+4D8F */	U2E_NODEST_COLX,
	/* U+4D90 */	U2E_NODEST_COLX,
	/* U+4D91 */	U2E_NODEST_COLX,
	/* U+4D92 */	U2E_NODEST_COLX,
	/* U+4D93 */	U2E_NODEST_COLX,
	/* U+4D94 */	U2E_NODEST_COLX,
	/* U+4D95 */	U2E_NODEST_COLX,
	/* U+4D96 */	U2E_NODEST_COLX,
	/* U+4D97 */	U2E_NODEST_COLX,
	/* U+4D98 */	U2E_NODEST_COLX,
	/* U+4D99 */	U2E_NODEST_COLX,
	/* U+4D9A */	U2E_NODEST_COLX,
	/* U+4D9B */	U2E_NODEST_COLX,
	/* U+4D9C */	U2E_NODEST_COLX,
	/* U+4D9D */	U2E_NODEST_COLX,
	/* U+4D9E */	U2E_NODEST_COLX,
	/* U+4D9F */	U2E_NODEST_COLX,
	/* U+4DA0 */	U2E_NODEST_COLX,
	/* U+4DA1 */	U2E_NODEST_COLX,
	/* U+4DA2 */	U2E_NODEST_COLX,
	/* U+4DA3 */	U2E_NODEST_COLX,
	/* U+4DA4 */	U2E_NODEST_COLX,
	/* U+4DA5 */	U2E_NODEST_COLX,
	/* U+4DA6 */	U2E_NODEST_COLX,
	/* U+4DA7 */	U2E_NODEST_COLX,
	/* U+4DA8 */	U2E_NODEST_COLX,
	/* U+4DA9 */	U2E_NODEST_COLX,
	/* U+4DAA */	U2E_NODEST_COLX,
	/* U+4DAB */	U2E_NODEST_COLX,
	/* U+4DAC */	U2E_NODEST_COLX,
	/* U+4DAD */	U2E_NODEST_COLX,
	/* U+4DAE */	U2E_NODEST_COLX,
	/* U+4DAF */	U2E_NODEST_COLX,
	/* U+4DB0 */	U2E_NODEST_COLX,
	/* U+4DB1 */	U2E_NODEST_COLX,
	/* U+4DB2 */	U2E_NODEST_COLX,
	/* U+4DB3 */	U2E_NODEST_COLX,
	/* U+4DB4 */	U2E_NODEST_COLX,
	/* U+4DB5 */	U2E_NODEST_COLX,
	/* U+4DB6 */	U2E_NODEST_COLX,
	/* U+4DB7 */	U2E_NODEST_COLX,
	/* U+4DB8 */	U2E_NODEST_COLX,
	/* U+4DB9 */	U2E_NODEST_COLX,
	/* U+4DBA */	U2E_NODEST_COLX,
	/* U+4DBB */	U2E_NODEST_COLX,
	/* U+4DBC */	U2E_NODEST_COLX,
	/* U+4DBD */	U2E_NODEST_COLX,
	/* U+4DBE */	U2E_NODEST_COLX,
	/* U+4DBF */	U2E_NODEST_COLX,
	/* U+4DC0 */	U2E_NODEST_COLX,
	/* U+4DC1 */	U2E_NODEST_COLX,
	/* U+4DC2 */	U2E_NODEST_COLX,
	/* U+4DC3 */	U2E_NODEST_COLX,
	/* U+4DC4 */	U2E_NODEST_COLX,
	/* U+4DC5 */	U2E_NODEST_COLX,
	/* U+4DC6 */	U2E_NODEST_COLX,
	/* U+4DC7 */	U2E_NODEST_COLX,
	/* U+4DC8 */	U2E_NODEST_COLX,
	/* U+4DC9 */	U2E_NODEST_COLX,
	/* U+4DCA */	U2E_NODEST_COLX,
	/* U+4DCB */	U2E_NODEST_COLX,
	/* U+4DCC */	U2E_NODEST_COLX,
	/* U+4DCD */	U2E_NODEST_COLX,
	/* U+4DCE */	U2E_NODEST_COLX,
	/* U+4DCF */	U2E_NODEST_COLX,
	/* U+4DD0 */	U2E_NODEST_COLX,
	/* U+4DD1 */	U2E_NODEST_COLX,
	/* U+4DD2 */	U2E_NODEST_COLX,
	/* U+4DD3 */	U2E_NODEST_COLX,
	/* U+4DD4 */	U2E_NODEST_COLX,
	/* U+4DD5 */	U2E_NODEST_COLX,
	/* U+4DD6 */	U2E_NODEST_COLX,
	/* U+4DD7 */	U2E_NODEST_COLX,
	/* U+4DD8 */	U2E_NODEST_COLX,
	/* U+4DD9 */	U2E_NODEST_COLX,
	/* U+4DDA */	U2E_NODEST_COLX,
	/* U+4DDB */	U2E_NODEST_COLX,
	/* U+4DDC */	U2E_NODEST_COLX,
	/* U+4DDD */	U2E_NODEST_COLX,
	/* U+4DDE */	U2E_NODEST_COLX,
	/* U+4DDF */	U2E_NODEST_COLX,
	/* U+4DE0 */	U2E_NODEST_COLX,
	/* U+4DE1 */	U2E_NODEST_COLX,
	/* U+4DE2 */	U2E_NODEST_COLX,
	/* U+4DE3 */	U2E_NODEST_COLX,
	/* U+4DE4 */	U2E_NODEST_COLX,
	/* U+4DE5 */	U2E_NODEST_COLX,
	/* U+4DE6 */	U2E_NODEST_COLX,
	/* U+4DE7 */	U2E_NODEST_COLX,
	/* U+4DE8 */	U2E_NODEST_COLX,
	/* U+4DE9 */	U2E_NODEST_COLX,
	/* U+4DEA */	U2E_NODEST_COLX,
	/* U+4DEB */	U2E_NODEST_COLX,
	/* U+4DEC */	U2E_NODEST_COLX,
	/* U+4DED */	U2E_NODEST_COLX,
	/* U+4DEE */	U2E_NODEST_COLX,
	/* U+4DEF */	U2E_NODEST_COLX,
	/* U+4DF0 */	U2E_NODEST_COLX,
	/* U+4DF1 */	U2E_NODEST_COLX,
	/* U+4DF2 */	U2E_NODEST_COLX,
	/* U+4DF3 */	U2E_NODEST_COLX,
	/* U+4DF4 */	U2E_NODEST_COLX,
	/* U+4DF5 */	U2E_NODEST_COLX,
	/* U+4DF6 */	U2E_NODEST_COLX,
	/* U+4DF7 */	U2E_NODEST_COLX,
	/* U+4DF8 */	U2E_NODEST_COLX,
	/* U+4DF9 */	U2E_NODEST_COLX,
	/* U+4DFA */	U2E_NODEST_COLX,
	/* U+4DFB */	U2E_NODEST_COLX,
	/* U+4DFC */	U2E_NODEST_COLX,
	/* U+4DFD */	U2E_NODEST_COLX,
	/* U+4DFE */	U2E_NODEST_COLX,
	/* U+4DFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_4E[] = {
	/* U+4E00 */	JISX0208(0xb0ec),
	/* U+4E01 */	JISX0208(0xc3fa),
	/* U+4E02 */	IFX0213(JISX0213_2(0xa122),	JISX0212(0xb021)),
	/* U+4E03 */	JISX0208(0xbcb7),
	/* U+4E04 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb022)),
	/* U+4E05 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb023)),
	/* U+4E06 */	U2E_NODEST_COLX,
	/* U+4E07 */	JISX0208(0xcbfc),
	/* U+4E08 */	JISX0208(0xbee6),
	/* U+4E09 */	JISX0208(0xbbb0),
	/* U+4E0A */	JISX0208(0xbee5),
	/* U+4E0B */	JISX0208(0xb2bc),
	/* U+4E0C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb024)),
	/* U+4E0D */	JISX0208(0xc9d4),
	/* U+4E0E */	JISX0208(0xcdbf),
	/* U+4E0F */	IFX0213(JISX0213_2(0xa123),	U2E_NODEST_COLX),
	/* U+4E10 */	JISX0208(0xd0a2),
	/* U+4E11 */	JISX0208(0xb1af),
	/* U+4E12 */	IFX0213(JISX0213_2(0xa124),	JISX0212(0xb025)),
	/* U+4E13 */	U2E_NODEST_COLX,
	/* U+4E14 */	JISX0208(0xb3ee),
	/* U+4E15 */	JISX0208(0xd0a3),
	/* U+4E16 */	JISX0208(0xc0a4),
	/* U+4E17 */	JISX0208(0xd2c2),
	/* U+4E18 */	JISX0208(0xb5d6),
	/* U+4E19 */	JISX0208(0xcaba),
	/* U+4E1A */	U2E_NODEST_COLX,
	/* U+4E1B */	U2E_NODEST_COLX,
	/* U+4E1C */	U2E_NODEST_COLX,
	/* U+4E1D */	U2E_NODEST_COLX,
	/* U+4E1E */	JISX0208(0xbee7),
	/* U+4E1F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb026)),
	/* U+4E20 */	U2E_NODEST_COLX,
	/* U+4E21 */	JISX0208(0xcebe),
	/* U+4E22 */	U2E_NODEST_COLX,
	/* U+4E23 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb027)),
	/* U+4E24 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb028)),
	/* U+4E25 */	U2E_NODEST_COLX,
	/* U+4E26 */	JISX0208(0xcac2),
	/* U+4E27 */	U2E_NODEST_COLX,
	/* U+4E28 */	IFX0213(JISX0213_1(0xaea4),	JISX0212(0xb029)),
	/* U+4E29 */	IFX0213(JISX0213_2(0xa125),	U2E_NODEST_COLX),
	/* U+4E2A */	JISX0208(0xd0a4),
	/* U+4E2B */	IFX0213(JISX0213_2(0xa126),	JISX0212(0xb02a)),
	/* U+4E2C */	IFX0213(JISX0213_2(0xf02e),	U2E_NODEST_COLX),
	/* U+4E2D */	JISX0208(0xc3e6),
	/* U+4E2E */	IFX0213(JISX0213_2(0xa127),	JISX0212(0xb02b)),
	/* U+4E2F */	IFX0213(JISX0213_1(0xaea5),	JISX0212(0xb02c)),
	/* U+4E30 */	IFX0213(JISX0213_1(0xaea6),	JISX0212(0xb02d)),
	/* U+4E31 */	JISX0208(0xd0a5),
	/* U+4E32 */	JISX0208(0xb6fa),
	/* U+4E33 */	U2E_NODEST_COLX,
	/* U+4E34 */	U2E_NODEST_COLX,
	/* U+4E35 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb02e)),
	/* U+4E36 */	JISX0208(0xd0a6),
	/* U+4E37 */	U2E_NODEST_COLX,
	/* U+4E38 */	JISX0208(0xb4dd),
	/* U+4E39 */	JISX0208(0xc3b0),
	/* U+4E3A */	U2E_NODEST_COLX,
	/* U+4E3B */	JISX0208(0xbce7),
	/* U+4E3C */	JISX0208(0xd0a7),
	/* U+4E3D */	U2E_NODEST_COLX,
	/* U+4E3E */	U2E_NODEST_COLX,
	/* U+4E3F */	JISX0208(0xd0a8),
	/* U+4E40 */	IFX0213(JISX0213_2(0xa128),	JISX0212(0xb02f)),
	/* U+4E41 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb030)),
	/* U+4E42 */	JISX0208(0xd0a9),
	/* U+4E43 */	JISX0208(0xc7b5),
	/* U+4E44 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb031)),
	/* U+4E45 */	JISX0208(0xb5d7),
	/* U+4E46 */	U2E_NODEST_COLX,
	/* U+4E47 */	IFX0213(JISX0213_2(0xa129),	JISX0212(0xb032)),
	/* U+4E48 */	IFX0213(JISX0213_2(0xa12a),	U2E_NODEST_COLX),
	/* U+4E49 */	U2E_NODEST_COLX,
	/* U+4E4A */	U2E_NODEST_COLX,
	/* U+4E4B */	JISX0208(0xc7b7),
	/* U+4E4C */	U2E_NODEST_COLX,
	/* U+4E4D */	JISX0208(0xc6e3),
	/* U+4E4E */	JISX0208(0xb8c3),
	/* U+4E4F */	JISX0208(0xcbb3),
	/* U+4E50 */	U2E_NODEST_COLX,
	/* U+4E51 */	IFX0213(JISX0213_2(0xa12c),	JISX0212(0xb033)),
	/* U+4E52 */	U2E_NODEST_COLX,
	/* U+4E53 */	U2E_NODEST_COLX,
	/* U+4E54 */	U2E_NODEST_COLX,
	/* U+4E55 */	JISX0208(0xe9c9),
	/* U+4E56 */	JISX0208(0xd0aa),
	/* U+4E57 */	JISX0208(0xbee8),
	/* U+4E58 */	JISX0208(0xd0ab),
	/* U+4E59 */	JISX0208(0xb2b5),
	/* U+4E5A */	IFX0213(JISX0213_2(0xa12f),	JISX0212(0xb034)),
	/* U+4E5B */	U2E_NODEST_COLX,
	/* U+4E5C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb035)),
	/* U+4E5D */	JISX0208(0xb6e5),
	/* U+4E5E */	JISX0208(0xb8f0),
	/* U+4E5F */	JISX0208(0xcce9),
	/* U+4E60 */	U2E_NODEST_COLX,
	/* U+4E61 */	U2E_NODEST_COLX,
	/* U+4E62 */	JISX0208(0xd6a6),
	/* U+4E63 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb036)),
	/* U+4E64 */	U2E_NODEST_COLX,
	/* U+4E65 */	U2E_NODEST_COLX,
	/* U+4E66 */	U2E_NODEST_COLX,
	/* U+4E67 */	U2E_NODEST_COLX,
	/* U+4E68 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb037)),
	/* U+4E69 */	IFX0213(JISX0213_2(0xa130),	JISX0212(0xb038)),
	/* U+4E6A */	U2E_NODEST_COLX,
	/* U+4E6B */	U2E_NODEST_COLX,
	/* U+4E6C */	U2E_NODEST_COLX,
	/* U+4E6D */	U2E_NODEST_COLX,
	/* U+4E6E */	U2E_NODEST_COLX,
	/* U+4E6F */	U2E_NODEST_COLX,
	/* U+4E70 */	U2E_NODEST_COLX,
	/* U+4E71 */	JISX0208(0xcdf0),
	/* U+4E72 */	U2E_NODEST_COLX,
	/* U+4E73 */	JISX0208(0xc6fd),
	/* U+4E74 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb039)),
	/* U+4E75 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb03a)),
	/* U+4E76 */	U2E_NODEST_COLX,
	/* U+4E77 */	U2E_NODEST_COLX,
	/* U+4E78 */	U2E_NODEST_COLX,
	/* U+4E79 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb03b)),
	/* U+4E7A */	U2E_NODEST_COLX,
	/* U+4E7B */	U2E_NODEST_COLX,
	/* U+4E7C */	U2E_NODEST_COLX,
	/* U+4E7D */	U2E_NODEST_COLX,
	/* U+4E7E */	JISX0208(0xb4a5),
	/* U+4E7F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb03c)),
	/* U+4E80 */	JISX0208(0xb5b5),
	/* U+4E81 */	U2E_NODEST_COLX,
	/* U+4E82 */	JISX0208(0xd0ac),
	/* U+4E83 */	U2E_NODEST_COLX,
	/* U+4E84 */	U2E_NODEST_COLX,
	/* U+4E85 */	JISX0208(0xd0ad),
	/* U+4E86 */	JISX0208(0xcebb),
	/* U+4E87 */	U2E_NODEST_COLX,
	/* U+4E88 */	JISX0208(0xcdbd),
	/* U+4E89 */	JISX0208(0xc1e8),
	/* U+4E8A */	JISX0208(0xd0af),
	/* U+4E8B */	JISX0208(0xbbf6),
	/* U+4E8C */	JISX0208(0xc6f3),
	/* U+4E8D */	IFX0213(JISX0213_1(0xaea7),	JISX0212(0xb03d)),
	/* U+4E8E */	JISX0208(0xd0b2),
	/* U+4E8F */	U2E_NODEST_COLX,
	/* U+4E90 */	U2E_NODEST_COLX,
	/* U+4E91 */	JISX0208(0xb1be),
	/* U+4E92 */	JISX0208(0xb8df),
	/* U+4E93 */	U2E_NODEST_COLX,
	/* U+4E94 */	JISX0208(0xb8de),
	/* U+4E95 */	JISX0208(0xb0e6),
	/* U+4E96 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb03e)),
	/* U+4E97 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb03f)),
	/* U+4E98 */	JISX0208(0xcfcb),
	/* U+4E99 */	JISX0208(0xcfca),
	/* U+4E9A */	U2E_NODEST_COLX,
	/* U+4E9B */	JISX0208(0xbab3),
	/* U+4E9C */	JISX0208(0xb0a1),
	/* U+4E9D */	IFX0213(JISX0213_2(0xa131),	JISX0212(0xb040)),
	/* U+4E9E */	JISX0208(0xd0b3),
	/* U+4E9F */	JISX0208(0xd0b4),
	/* U+4EA0 */	JISX0208(0xd0b5),
	/* U+4EA1 */	JISX0208(0xcbb4),
	/* U+4EA2 */	JISX0208(0xd0b6),
	/* U+4EA3 */	U2E_NODEST_COLX,
	/* U+4EA4 */	JISX0208(0xb8f2),
	/* U+4EA5 */	JISX0208(0xb0e7),
	/* U+4EA6 */	JISX0208(0xcbf2),
	/* U+4EA7 */	U2E_NODEST_COLX,
	/* U+4EA8 */	JISX0208(0xb5fc),
	/* U+4EA9 */	U2E_NODEST_COLX,
	/* U+4EAA */	U2E_NODEST_COLX,
	/* U+4EAB */	JISX0208(0xb5fd),
	/* U+4EAC */	JISX0208(0xb5fe),
	/* U+4EAD */	JISX0208(0xc4e2),
	/* U+4EAE */	JISX0208(0xcebc),
	/* U+4EAF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb041)),
	/* U+4EB0 */	JISX0208(0xd0b7),
	/* U+4EB1 */	U2E_NODEST_COLX,
	/* U+4EB2 */	U2E_NODEST_COLX,
	/* U+4EB3 */	JISX0208(0xd0b8),
	/* U+4EB4 */	U2E_NODEST_COLX,
	/* U+4EB5 */	U2E_NODEST_COLX,
	/* U+4EB6 */	JISX0208(0xd0b9),
	/* U+4EB7 */	U2E_NODEST_COLX,
	/* U+4EB8 */	U2E_NODEST_COLX,
	/* U+4EB9 */	IFX0213(JISX0213_2(0xa134),	JISX0212(0xb042)),
	/* U+4EBA */	JISX0208(0xbfcd),
	/* U+4EBB */	IFX0213(JISX0213_2(0xa135),	U2E_NODEST_COLX),
	/* U+4EBC */	IFX0213(JISX0213_2(0xa137),	U2E_NODEST_COLX),
	/* U+4EBD */	U2E_NODEST_COLX,
	/* U+4EBE */	U2E_NODEST_COLX,
	/* U+4EBF */	U2E_NODEST_COLX,
	/* U+4EC0 */	JISX0208(0xbdba),
	/* U+4EC1 */	JISX0208(0xbfce),
	/* U+4EC2 */	JISX0208(0xd0be),
	/* U+4EC3 */	IFX0213(JISX0213_2(0xa138),	JISX0212(0xb043)),
	/* U+4EC4 */	JISX0208(0xd0bc),
	/* U+4EC5 */	U2E_NODEST_COLX,
	/* U+4EC6 */	JISX0208(0xd0bd),
	/* U+4EC7 */	JISX0208(0xb5d8),
	/* U+4EC8 */	IFX0213(JISX0213_2(0xa139),	U2E_NODEST_COLX),
	/* U+4EC9 */	U2E_NODEST_COLX,
	/* U+4ECA */	JISX0208(0xbaa3),
	/* U+4ECB */	JISX0208(0xb2f0),
	/* U+4ECC */	U2E_NODEST_COLX,
	/* U+4ECD */	JISX0208(0xd0bb),
	/* U+4ECE */	JISX0208(0xd0ba),
	/* U+4ECF */	JISX0208(0xcaa9),
	/* U+4ED0 */	IFX0213(JISX0213_2(0xa13a),	JISX0212(0xb044)),
	/* U+4ED1 */	U2E_NODEST_COLX,
	/* U+4ED2 */	U2E_NODEST_COLX,
	/* U+4ED3 */	U2E_NODEST_COLX,
	/* U+4ED4 */	JISX0208(0xbbc6),
	/* U+4ED5 */	JISX0208(0xbbc5),
	/* U+4ED6 */	JISX0208(0xc2be),
	/* U+4ED7 */	JISX0208(0xd0bf),
	/* U+4ED8 */	JISX0208(0xc9d5),
	/* U+4ED9 */	JISX0208(0xc0e7),
	/* U+4EDA */	IFX0213(JISX0213_2(0xa13c),	JISX0212(0xb045)),
	/* U+4EDB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb046)),
	/* U+4EDC */	U2E_NODEST_COLX,
	/* U+4EDD */	JISX0208(0xa1b8),
	/* U+4EDE */	JISX0208(0xd0c0),
	/* U+4EDF */	JISX0208(0xd0c2),
	/* U+4EE0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb047)),
	/* U+4EE1 */	IFX0213(JISX0213_1(0xaea8),	JISX0212(0xb048)),
	/* U+4EE2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb049)),
	/* U+4EE3 */	JISX0208(0xc2e5),
	/* U+4EE4 */	JISX0208(0xcee1),
	/* U+4EE5 */	JISX0208(0xb0ca),
	/* U+4EE6 */	U2E_NODEST_COLX,
	/* U+4EE7 */	U2E_NODEST_COLX,
	/* U+4EE8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb04a)),
	/* U+4EE9 */	U2E_NODEST_COLX,
	/* U+4EEA */	U2E_NODEST_COLX,
	/* U+4EEB */	IFX0213(JISX0213_2(0xa13b),	U2E_NODEST_COLX),
	/* U+4EEC */	U2E_NODEST_COLX,
	/* U+4EED */	JISX0208(0xd0c1),
	/* U+4EEE */	JISX0208(0xb2be),
	/* U+4EEF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb04b)),
	/* U+4EF0 */	JISX0208(0xb6c4),
	/* U+4EF1 */	IFX0213(JISX0213_2(0xa13d),	JISX0212(0xb04c)),
	/* U+4EF2 */	JISX0208(0xc3e7),
	/* U+4EF3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb04d)),
	/* U+4EF4 */	U2E_NODEST_COLX,
	/* U+4EF5 */	IFX0213(JISX0213_2(0xa13e),	JISX0212(0xb04e)),
	/* U+4EF6 */	JISX0208(0xb7ef),
	/* U+4EF7 */	JISX0208(0xd0c3),
	/* U+4EF8 */	U2E_NODEST_COLX,
	/* U+4EF9 */	U2E_NODEST_COLX,
	/* U+4EFA */	U2E_NODEST_COLX,
	/* U+4EFB */	JISX0208(0xc7a4),
	/* U+4EFC */	IFX0213(U2E_NODEST_COLX,	IBM(0xf42f)),
	/* U+4EFD */	IFX0213(JISX0213_1(0xaea9),	JISX0212(0xb04f)),
	/* U+4EFE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb050)),
	/* U+4EFF */	IFX0213(JISX0213_1(0xaeaa),	JISX0212(0xb051)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_4F[] = {
	/* U+4F00 */	IFX0213(JISX0213_2(0xa13f),	JISX0212(0xb052)),
	/* U+4F01 */	JISX0208(0xb4eb),
	/* U+4F02 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb053)),
	/* U+4F03 */	IFX0213(JISX0213_1(0xaeab),	JISX0212(0xb054)),
	/* U+4F04 */	U2E_NODEST_COLX,
	/* U+4F05 */	U2E_NODEST_COLX,
	/* U+4F06 */	U2E_NODEST_COLX,
	/* U+4F07 */	U2E_NODEST_COLX,
	/* U+4F08 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb055)),
	/* U+4F09 */	JISX0208(0xd0c4),
	/* U+4F0A */	JISX0208(0xb0cb),
	/* U+4F0B */	IFX0213(JISX0213_1(0xaeac),	JISX0212(0xb056)),
	/* U+4F0C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb057)),
	/* U+4F0D */	JISX0208(0xb8e0),
	/* U+4F0E */	JISX0208(0xb4ec),
	/* U+4F0F */	JISX0208(0xc9fa),
	/* U+4F10 */	JISX0208(0xc8b2),
	/* U+4F11 */	JISX0208(0xb5d9),
	/* U+4F12 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb058)),
	/* U+4F13 */	U2E_NODEST_COLX,
	/* U+4F14 */	U2E_NODEST_COLX,
	/* U+4F15 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb059)),
	/* U+4F16 */	IFX0213(JISX0213_2(0xa140),	JISX0212(0xb05a)),
	/* U+4F17 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb05b)),
	/* U+4F18 */	U2E_NODEST_COLX,
	/* U+4F19 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb05c)),
	/* U+4F1A */	JISX0208(0xb2f1),
	/* U+4F1B */	U2E_NODEST_COLX,
	/* U+4F1C */	JISX0208(0xd0e7),
	/* U+4F1D */	JISX0208(0xc5c1),
	/* U+4F1E */	U2E_NODEST_COLX,
	/* U+4F1F */	U2E_NODEST_COLX,
	/* U+4F20 */	U2E_NODEST_COLX,
	/* U+4F21 */	U2E_NODEST_COLX,
	/* U+4F22 */	U2E_NODEST_COLX,
	/* U+4F23 */	U2E_NODEST_COLX,
	/* U+4F24 */	U2E_NODEST_COLX,
	/* U+4F25 */	U2E_NODEST_COLX,
	/* U+4F26 */	U2E_NODEST_COLX,
	/* U+4F27 */	U2E_NODEST_COLX,
	/* U+4F28 */	U2E_NODEST_COLX,
	/* U+4F29 */	U2E_NODEST_COLX,
	/* U+4F2A */	U2E_NODEST_COLX,
	/* U+4F2B */	U2E_NODEST_COLX,
	/* U+4F2C */	U2E_NODEST_COLX,
	/* U+4F2D */	U2E_NODEST_COLX,
	/* U+4F2E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb05d)),
	/* U+4F2F */	JISX0208(0xc7ec),
	/* U+4F30 */	JISX0208(0xd0c6),
	/* U+4F31 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb05e)),
	/* U+4F32 */	U2E_NODEST_COLX,
	/* U+4F33 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb060)),
	/* U+4F34 */	JISX0208(0xc8bc),
	/* U+4F35 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb061)),
	/* U+4F36 */	JISX0208(0xcee2),
	/* U+4F37 */	IFX0213(JISX0213_2(0xa142),	JISX0212(0xb062)),
	/* U+4F38 */	JISX0208(0xbfad),
	/* U+4F39 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb063)),
	/* U+4F3A */	JISX0208(0xbbc7),
	/* U+4F3B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb064)),
	/* U+4F3C */	JISX0208(0xbbf7),
	/* U+4F3D */	JISX0208(0xb2c0),
	/* U+4F3E */	IFX0213(JISX0213_2(0xa143),	JISX0212(0xb065)),
	/* U+4F3F */	U2E_NODEST_COLX,
	/* U+4F40 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb066)),
	/* U+4F41 */	U2E_NODEST_COLX,
	/* U+4F42 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb067)),
	/* U+4F43 */	JISX0208(0xc4d1),
	/* U+4F44 */	U2E_NODEST_COLX,
	/* U+4F45 */	U2E_NODEST_COLX,
	/* U+4F46 */	JISX0208(0xc3a2),
	/* U+4F47 */	JISX0208(0xd0ca),
	/* U+4F48 */	IFX0213(JISX0213_1(0xaeae),	JISX0212(0xb068)),
	/* U+4F49 */	IFX0213(JISX0213_1(0xaeaf),	JISX0212(0xb069)),
	/* U+4F4A */	U2E_NODEST_COLX,
	/* U+4F4B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb06a)),
	/* U+4F4C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb06b)),
	/* U+4F4D */	JISX0208(0xb0cc),
	/* U+4F4E */	JISX0208(0xc4e3),
	/* U+4F4F */	JISX0208(0xbdbb),
	/* U+4F50 */	JISX0208(0xbab4),
	/* U+4F51 */	JISX0208(0xcda4),
	/* U+4F52 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb06c)),
	/* U+4F53 */	JISX0208(0xc2ce),
	/* U+4F54 */	IFX0213(JISX0213_2(0xa144),	JISX0212(0xb06d)),
	/* U+4F55 */	JISX0208(0xb2bf),
	/* U+4F56 */	IFX0213(JISX0213_1(0xaeb0),	JISX0212(0xb06e)),
	/* U+4F57 */	JISX0208(0xd0c9),
	/* U+4F58 */	IFX0213(JISX0213_2(0xa145),	JISX0212(0xb06f)),
	/* U+4F59 */	JISX0208(0xcdbe),
	/* U+4F5A */	JISX0208(0xd0c5),
	/* U+4F5B */	JISX0208(0xd0c7),
	/* U+4F5C */	JISX0208(0xbaee),
	/* U+4F5D */	JISX0208(0xd0c8),
	/* U+4F5E */	JISX0208(0xd5a4),
	/* U+4F5F */	IFX0213(JISX0213_1(0xaeb1),	JISX0212(0xb070)),
	/* U+4F60 */	IFX0213(JISX0213_1(0xaead),	JISX0212(0xb05f)),
	/* U+4F61 */	U2E_NODEST_COLX,
	/* U+4F62 */	U2E_NODEST_COLX,
	/* U+4F63 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb071)),
	/* U+4F64 */	IFX0213(JISX0213_2(0xa141),	U2E_NODEST_COLX),
	/* U+4F65 */	U2E_NODEST_COLX,
	/* U+4F66 */	U2E_NODEST_COLX,
	/* U+4F67 */	U2E_NODEST_COLX,
	/* U+4F68 */	U2E_NODEST_COLX,
	/* U+4F69 */	JISX0208(0xd0d0),
	/* U+4F6A */	IFX0213(JISX0213_1(0xaeb2),	JISX0212(0xb072)),
	/* U+4F6B */	U2E_NODEST_COLX,
	/* U+4F6C */	IFX0213(JISX0213_1(0xaeb3),	JISX0212(0xb073)),
	/* U+4F6D */	U2E_NODEST_COLX,
	/* U+4F6E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb074)),
	/* U+4F6F */	JISX0208(0xd0d3),
	/* U+4F70 */	JISX0208(0xd0d1),
	/* U+4F71 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb075)),
	/* U+4F72 */	U2E_NODEST_COLX,
	/* U+4F73 */	JISX0208(0xb2c2),
	/* U+4F74 */	U2E_NODEST_COLX,
	/* U+4F75 */	JISX0208(0xcabb),
	/* U+4F76 */	JISX0208(0xd0cb),
	/* U+4F77 */	IFX0213(JISX0213_2(0xa147),	JISX0212(0xb076)),
	/* U+4F78 */	IFX0213(JISX0213_2(0xa148),	JISX0212(0xb077)),
	/* U+4F79 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb078)),
	/* U+4F7A */	IFX0213(JISX0213_2(0xa149),	JISX0212(0xb079)),
	/* U+4F7B */	JISX0208(0xd0cf),
	/* U+4F7C */	JISX0208(0xb8f3),
	/* U+4F7D */	IFX0213(JISX0213_2(0xa14a),	JISX0212(0xb07a)),
	/* U+4F7E */	IFX0213(JISX0213_1(0xaeb4),	JISX0212(0xb07b)),
	/* U+4F7F */	JISX0208(0xbbc8),
	/* U+4F80 */	U2E_NODEST_COLX,
	/* U+4F81 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb07c)),
	/* U+4F82 */	IFX0213(JISX0213_2(0xa14b),	JISX0212(0xb07d)),
	/* U+4F83 */	JISX0208(0xb4a6),
	/* U+4F84 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb07e)),
	/* U+4F85 */	IFX0213(JISX0213_2(0xa14c),	JISX0212(0xb121)),
	/* U+4F86 */	JISX0208(0xd0d4),
	/* U+4F87 */	U2E_NODEST_COLX,
	/* U+4F88 */	JISX0208(0xd0cc),
	/* U+4F89 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb122)),
	/* U+4F8A */	IFX0213(JISX0213_1(0xaeb5),	JISX0212(0xb123)),
	/* U+4F8B */	JISX0208(0xcee3),
	/* U+4F8C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb124)),
	/* U+4F8D */	JISX0208(0xbbf8),
	/* U+4F8E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb125)),
	/* U+4F8F */	JISX0208(0xd0cd),
	/* U+4F90 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb126)),
	/* U+4F91 */	JISX0208(0xd0d2),
	/* U+4F92 */	IFX0213(JISX0213_2(0xa14d),	JISX0212(0xb127)),
	/* U+4F93 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb128)),
	/* U+4F94 */	IFX0213(JISX0213_1(0xaeb6),	JISX0212(0xb129)),
	/* U+4F95 */	U2E_NODEST_COLX,
	/* U+4F96 */	JISX0208(0xd0d5),
	/* U+4F97 */	IFX0213(JISX0213_1(0xaeb7),	JISX0212(0xb12a)),
	/* U+4F98 */	JISX0208(0xd0ce),
	/* U+4F99 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb12b)),
	/* U+4F9A */	IFX0213(JISX0213_2(0xa14e),	JISX0212(0xb12c)),
	/* U+4F9B */	JISX0208(0xb6a1),
	/* U+4F9C */	U2E_NODEST_COLX,
	/* U+4F9D */	JISX0208(0xb0cd),
	/* U+4F9E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb12d)),
	/* U+4F9F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb12e)),
	/* U+4FA0 */	JISX0208(0xb6a2),
	/* U+4FA1 */	JISX0208(0xb2c1),
	/* U+4FA2 */	U2E_NODEST_COLX,
	/* U+4FA3 */	U2E_NODEST_COLX,
	/* U+4FA4 */	U2E_NODEST_COLX,
	/* U+4FA5 */	U2E_NODEST_COLX,
	/* U+4FA6 */	U2E_NODEST_COLX,
	/* U+4FA7 */	U2E_NODEST_COLX,
	/* U+4FA8 */	U2E_NODEST_COLX,
	/* U+4FA9 */	U2E_NODEST_COLX,
	/* U+4FAA */	U2E_NODEST_COLX,
	/* U+4FAB */	JISX0208(0xd5a5),
	/* U+4FAC */	U2E_NODEST_COLX,
	/* U+4FAD */	JISX0208(0xcbf9),
	/* U+4FAE */	JISX0208(0xc9ee),
	/* U+4FAF */	JISX0208(0xb8f4),
	/* U+4FB0 */	U2E_NODEST_COLX,
	/* U+4FB1 */	U2E_NODEST_COLX,
	/* U+4FB2 */	IFX0213(JISX0213_2(0xa150),	JISX0212(0xb12f)),
	/* U+4FB3 */	U2E_NODEST_COLX,
	/* U+4FB4 */	U2E_NODEST_COLX,
	/* U+4FB5 */	JISX0208(0xbfaf),
	/* U+4FB6 */	JISX0208(0xceb7),
	/* U+4FB7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb130)),
	/* U+4FB8 */	U2E_NODEST_COLX,
	/* U+4FB9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb131)),
	/* U+4FBA */	U2E_NODEST_COLX,
	/* U+4FBB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb132)),
	/* U+4FBC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb133)),
	/* U+4FBD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb134)),
	/* U+4FBE */	IFX0213(JISX0213_2(0xa151),	JISX0212(0xb135)),
	/* U+4FBF */	JISX0208(0xcad8),
	/* U+4FC0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb136)),
	/* U+4FC1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb137)),
	/* U+4FC2 */	JISX0208(0xb7b8),
	/* U+4FC3 */	JISX0208(0xc2a5),
	/* U+4FC4 */	JISX0208(0xb2e4),
	/* U+4FC5 */	IFX0213(JISX0213_2(0xa152),	JISX0212(0xb138)),
	/* U+4FC6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb139)),
	/* U+4FC7 */	U2E_NODEST_COLX,
	/* U+4FC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb13a)),
	/* U+4FC9 */	IFX0213(JISX0213_1(0xaeb9),	JISX0212(0xb13b)),
	/* U+4FCA */	JISX0208(0xbdd3),
	/* U+4FCB */	IFX0213(JISX0213_2(0xa153),	JISX0212(0xb13c)),
	/* U+4FCC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb13d)),
	/* U+4FCD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb13e)),
	/* U+4FCE */	JISX0208(0xd0d9),
	/* U+4FCF */	IFX0213(JISX0213_2(0xa154),	JISX0212(0xb13f)),
	/* U+4FD0 */	JISX0208(0xd0de),
	/* U+4FD1 */	JISX0208(0xd0dc),
	/* U+4FD2 */	IFX0213(JISX0213_2(0xa155),	JISX0212(0xb140)),
	/* U+4FD3 */	U2E_NODEST_COLX,
	/* U+4FD4 */	JISX0208(0xd0d7),
	/* U+4FD5 */	U2E_NODEST_COLX,
	/* U+4FD6 */	U2E_NODEST_COLX,
	/* U+4FD7 */	JISX0208(0xc2af),
	/* U+4FD8 */	JISX0208(0xd0da),
	/* U+4FD9 */	U2E_NODEST_COLX,
	/* U+4FDA */	JISX0208(0xd0dd),
	/* U+4FDB */	JISX0208(0xd0db),
	/* U+4FDC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb141)),
	/* U+4FDD */	JISX0208(0xcadd),
	/* U+4FDE */	U2E_NODEST_COLX,
	/* U+4FDF */	JISX0208(0xd0d8),
	/* U+4FE0 */	IFX0213(JISX0213_1(0xaeba),	JISX0212(0xb142)),
	/* U+4FE1 */	JISX0208(0xbfae),
	/* U+4FE2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb143)),
	/* U+4FE3 */	JISX0208(0xcbf3),
	/* U+4FE4 */	JISX0208(0xd0df),
	/* U+4FE5 */	JISX0208(0xd0e0),
	/* U+4FE6 */	IFX0213(JISX0213_2(0xa14f),	U2E_NODEST_COLX),
	/* U+4FE7 */	U2E_NODEST_COLX,
	/* U+4FE8 */	U2E_NODEST_COLX,
	/* U+4FE9 */	U2E_NODEST_COLX,
	/* U+4FEA */	U2E_NODEST_COLX,
	/* U+4FEB */	U2E_NODEST_COLX,
	/* U+4FEC */	U2E_NODEST_COLX,
	/* U+4FED */	U2E_NODEST_COLX,
	/* U+4FEE */	JISX0208(0xbda4),
	/* U+4FEF */	JISX0208(0xd0ed),
	/* U+4FF0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb144)),
	/* U+4FF1 */	IFX0213(JISX0213_1(0xaea1),	U2E_NODEST_COLX),
	/* U+4FF2 */	IFX0213(JISX0213_2(0xa157),	JISX0212(0xb145)),
	/* U+4FF3 */	JISX0208(0xc7d0),
	/* U+4FF4 */	U2E_NODEST_COLX,
	/* U+4FF5 */	JISX0208(0xc9b6),
	/* U+4FF6 */	JISX0208(0xd0e8),
	/* U+4FF7 */	U2E_NODEST_COLX,
	/* U+4FF8 */	JISX0208(0xcaf0),
	/* U+4FF9 */	U2E_NODEST_COLX,
	/* U+4FFA */	JISX0208(0xb2b6),
	/* U+4FFB */	U2E_NODEST_COLX,
	/* U+4FFC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb146)),
	/* U+4FFD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb147)),
	/* U+4FFE */	JISX0208(0xd0ec),
	/* U+4FFF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb148)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_50[] = {
	/* U+5000 */	IFX0213(JISX0213_2(0xa158),	JISX0212(0xb149)),
	/* U+5001 */	IFX0213(JISX0213_1(0xaebb),	JISX0212(0xb14a)),
	/* U+5002 */	IFX0213(JISX0213_1(0xaebc),	U2E_NODEST_COLX),
	/* U+5003 */	U2E_NODEST_COLX,
	/* U+5004 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb14b)),
	/* U+5005 */	JISX0208(0xd0e6),
	/* U+5006 */	JISX0208(0xd0ef),
	/* U+5007 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb14c)),
	/* U+5008 */	U2E_NODEST_COLX,
	/* U+5009 */	JISX0208(0xc1d2),
	/* U+500A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb14d)),
	/* U+500B */	JISX0208(0xb8c4),
	/* U+500C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb14e)),
	/* U+500D */	JISX0208(0xc7dc),
	/* U+500E */	IFX0213(JISX0213_1(0xaebd),	JISX0212(0xb14f)),
	/* U+500F */	JISX0208(0xe0c7),
	/* U+5010 */	IFX0213(JISX0213_2(0xa159),	JISX0212(0xb150)),
	/* U+5011 */	JISX0208(0xd0ee),
	/* U+5012 */	JISX0208(0xc5dd),
	/* U+5013 */	IFX0213(JISX0213_2(0xa15a),	JISX0212(0xb151)),
	/* U+5014 */	JISX0208(0xd0e3),
	/* U+5015 */	U2E_NODEST_COLX,
	/* U+5016 */	JISX0208(0xb8f6),
	/* U+5017 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb152)),
	/* U+5018 */	IFX0213(JISX0213_1(0xaebe),	JISX0212(0xb153)),
	/* U+5019 */	JISX0208(0xb8f5),
	/* U+501A */	JISX0208(0xd0e1),
	/* U+501B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb154)),
	/* U+501C */	IFX0213(JISX0213_2(0xa15b),	JISX0212(0xb155)),
	/* U+501D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb156)),
	/* U+501E */	IFX0213(JISX0213_2(0xa15c),	JISX0212(0xb157)),
	/* U+501F */	JISX0208(0xbcda),
	/* U+5020 */	U2E_NODEST_COLX,
	/* U+5021 */	JISX0208(0xd0e9),
	/* U+5022 */	IFX0213(JISX0213_2(0xa15d),	JISX0212(0xb158)),
	/* U+5023 */	JISX0208(0xcaef),
	/* U+5024 */	JISX0208(0xc3cd),
	/* U+5025 */	JISX0208(0xd0e5),
	/* U+5026 */	JISX0208(0xb7f1),
	/* U+5027 */	IFX0213(JISX0213_1(0xaebf),	JISX0212(0xb159)),
	/* U+5028 */	JISX0208(0xd0e2),
	/* U+5029 */	JISX0208(0xd0ea),
	/* U+502A */	JISX0208(0xd0e4),
	/* U+502B */	JISX0208(0xced1),
	/* U+502C */	JISX0208(0xd0eb),
	/* U+502D */	JISX0208(0xcfc1),
	/* U+502E */	IFX0213(JISX0213_1(0xaec0),	JISX0212(0xb15a)),
	/* U+502F */	U2E_NODEST_COLX,
	/* U+5030 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb15b)),
	/* U+5031 */	U2E_NODEST_COLX,
	/* U+5032 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb15c)),
	/* U+5033 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb15d)),
	/* U+5034 */	U2E_NODEST_COLX,
	/* U+5035 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb15e)),
	/* U+5036 */	JISX0208(0xb6e6),
	/* U+5037 */	U2E_NODEST_COLX,
	/* U+5038 */	U2E_NODEST_COLX,
	/* U+5039 */	JISX0208(0xb7f0),
	/* U+503A */	U2E_NODEST_COLX,
	/* U+503B */	IFX0213(JISX0213_1(0xaec2),	JISX0212(0xb176)),
	/* U+503C */	U2E_NODEST_COLX,
	/* U+503D */	U2E_NODEST_COLX,
	/* U+503E */	U2E_NODEST_COLX,
	/* U+503F */	U2E_NODEST_COLX,
	/* U+5040 */	IFX0213(JISX0213_1(0xaec1),	JISX0212(0xb15f)),
	/* U+5041 */	IFX0213(JISX0213_1(0xaec3),	JISX0212(0xb160)),
	/* U+5042 */	IFX0213(JISX0213_2(0xa15f),	JISX0212(0xb161)),
	/* U+5043 */	JISX0208(0xd0f0),
	/* U+5044 */	U2E_NODEST_COLX,
	/* U+5045 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb162)),
	/* U+5046 */	IFX0213(JISX0213_2(0xa160),	JISX0212(0xb163)),
	/* U+5047 */	JISX0208(0xd0f1),
	/* U+5048 */	JISX0208(0xd0f5),
	/* U+5049 */	JISX0208(0xb0ce),
	/* U+504A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb164)),
	/* U+504B */	U2E_NODEST_COLX,
	/* U+504C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb165)),
	/* U+504D */	U2E_NODEST_COLX,
	/* U+504E */	IFX0213(JISX0213_2(0xa161),	JISX0212(0xb166)),
	/* U+504F */	JISX0208(0xcad0),
	/* U+5050 */	JISX0208(0xd0f4),
	/* U+5051 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb167)),
	/* U+5052 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb168)),
	/* U+5053 */	IFX0213(JISX0213_2(0xa162),	JISX0212(0xb169)),
	/* U+5054 */	U2E_NODEST_COLX,
	/* U+5055 */	JISX0208(0xd0f3),
	/* U+5056 */	JISX0208(0xd0f7),
	/* U+5057 */	IFX0213(JISX0213_2(0xa163),	JISX0212(0xb16a)),
	/* U+5058 */	U2E_NODEST_COLX,
	/* U+5059 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb16b)),
	/* U+505A */	JISX0208(0xd0f6),
	/* U+505B */	U2E_NODEST_COLX,
	/* U+505C */	JISX0208(0xc4e4),
	/* U+505D */	U2E_NODEST_COLX,
	/* U+505E */	U2E_NODEST_COLX,
	/* U+505F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb16c)),
	/* U+5060 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb16d)),
	/* U+5061 */	U2E_NODEST_COLX,
	/* U+5062 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb16e)),
	/* U+5063 */	IFX0213(JISX0213_2(0xa164),	JISX0212(0xb16f)),
	/* U+5064 */	U2E_NODEST_COLX,
	/* U+5065 */	JISX0208(0xb7f2),
	/* U+5066 */	IFX0213(JISX0213_2(0xa165),	JISX0212(0xb170)),
	/* U+5067 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb171)),
	/* U+5068 */	U2E_NODEST_COLX,
	/* U+5069 */	U2E_NODEST_COLX,
	/* U+506A */	IFX0213(JISX0213_2(0xa166),	JISX0212(0xb172)),
	/* U+506B */	U2E_NODEST_COLX,
	/* U+506C */	JISX0208(0xd0f8),
	/* U+506D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb173)),
	/* U+506E */	U2E_NODEST_COLX,
	/* U+506F */	U2E_NODEST_COLX,
	/* U+5070 */	IFX0213(JISX0213_2(0xa167),	JISX0212(0xb174)),
	/* U+5071 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb175)),
	/* U+5072 */	JISX0208(0xbcc5),
	/* U+5073 */	U2E_NODEST_COLX,
	/* U+5074 */	JISX0208(0xc2a6),
	/* U+5075 */	JISX0208(0xc4e5),
	/* U+5076 */	JISX0208(0xb6f6),
	/* U+5077 */	U2E_NODEST_COLX,
	/* U+5078 */	JISX0208(0xd0f9),
	/* U+5079 */	U2E_NODEST_COLX,
	/* U+507A */	U2E_NODEST_COLX,
	/* U+507B */	U2E_NODEST_COLX,
	/* U+507C */	U2E_NODEST_COLX,
	/* U+507D */	JISX0208(0xb5b6),
	/* U+507E */	U2E_NODEST_COLX,
	/* U+507F */	U2E_NODEST_COLX,
	/* U+5080 */	JISX0208(0xd0fa),
	/* U+5081 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb177)),
	/* U+5082 */	U2E_NODEST_COLX,
	/* U+5083 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb178)),
	/* U+5084 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb179)),
	/* U+5085 */	JISX0208(0xd0fc),
	/* U+5086 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb17a)),
	/* U+5087 */	U2E_NODEST_COLX,
	/* U+5088 */	IFX0213(JISX0213_2(0xa169),	U2E_NODEST_COLX),
	/* U+5089 */	U2E_NODEST_COLX,
	/* U+508A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb17b)),
	/* U+508B */	U2E_NODEST_COLX,
	/* U+508C */	U2E_NODEST_COLX,
	/* U+508D */	JISX0208(0xcbb5),
	/* U+508E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb17c)),
	/* U+508F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb17d)),
	/* U+5090 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb17e)),
	/* U+5091 */	JISX0208(0xb7e6),
	/* U+5092 */	IFX0213(JISX0213_2(0xa16a),	JISX0212(0xb221)),
	/* U+5093 */	IFX0213(JISX0213_2(0xa16b),	JISX0212(0xb222)),
	/* U+5094 */	IFX0213(JISX0213_1(0xaec4),	JISX0212(0xb223)),
	/* U+5095 */	IFX0213(JISX0213_2(0xa16c),	U2E_NODEST_COLX),
	/* U+5096 */	IFX0213(JISX0213_2(0xa16d),	JISX0212(0xb224)),
	/* U+5097 */	U2E_NODEST_COLX,
	/* U+5098 */	JISX0208(0xbbb1),
	/* U+5099 */	JISX0208(0xc8f7),
	/* U+509A */	JISX0208(0xd0fb),
	/* U+509B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb225)),
	/* U+509C */	IFX0213(JISX0213_2(0xa16e),	JISX0212(0xb226)),
	/* U+509D */	U2E_NODEST_COLX,
	/* U+509E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb227)),
	/* U+509F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb228)),
	/* U+50A0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb229)),
	/* U+50A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb22a)),
	/* U+50A2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb22b)),
	/* U+50A3 */	IFX0213(JISX0213_2(0xa168),	U2E_NODEST_COLX),
	/* U+50A4 */	U2E_NODEST_COLX,
	/* U+50A5 */	U2E_NODEST_COLX,
	/* U+50A6 */	U2E_NODEST_COLX,
	/* U+50A7 */	U2E_NODEST_COLX,
	/* U+50A8 */	U2E_NODEST_COLX,
	/* U+50A9 */	U2E_NODEST_COLX,
	/* U+50AA */	IFX0213(JISX0213_2(0xa16f),	JISX0212(0xb22c)),
	/* U+50AB */	U2E_NODEST_COLX,
	/* U+50AC */	JISX0208(0xbac5),
	/* U+50AD */	JISX0208(0xcdc3),
	/* U+50AE */	U2E_NODEST_COLX,
	/* U+50AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb22d)),
	/* U+50B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb22e)),
	/* U+50B1 */	IFX0213(JISX0213_2(0xa171),	U2E_NODEST_COLX),
	/* U+50B2 */	JISX0208(0xd0fe),
	/* U+50B3 */	JISX0208(0xd1a3),
	/* U+50B4 */	JISX0208(0xd0fd),
	/* U+50B5 */	JISX0208(0xbac4),
	/* U+50B6 */	U2E_NODEST_COLX,
	/* U+50B7 */	JISX0208(0xbdfd),
	/* U+50B8 */	U2E_NODEST_COLX,
	/* U+50B9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb22f)),
	/* U+50BA */	IFX0213(JISX0213_2(0xa172),	JISX0212(0xb230)),
	/* U+50BB */	IFX0213(JISX0213_2(0xa173),	U2E_NODEST_COLX),
	/* U+50BC */	U2E_NODEST_COLX,
	/* U+50BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb231)),
	/* U+50BE */	JISX0208(0xb7b9),
	/* U+50BF */	U2E_NODEST_COLX,
	/* U+50C0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb232)),
	/* U+50C1 */	U2E_NODEST_COLX,
	/* U+50C2 */	JISX0208(0xd1a4),
	/* U+50C3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb233)),
	/* U+50C4 */	IFX0213(JISX0213_2(0xa174),	JISX0212(0xb234)),
	/* U+50C5 */	JISX0208(0xb6cf),
	/* U+50C6 */	U2E_NODEST_COLX,
	/* U+50C7 */	IFX0213(JISX0213_2(0xa175),	JISX0212(0xb235)),
	/* U+50C8 */	U2E_NODEST_COLX,
	/* U+50C9 */	JISX0208(0xd1a1),
	/* U+50CA */	JISX0208(0xd1a2),
	/* U+50CB */	U2E_NODEST_COLX,
	/* U+50CC */	IFX0213(JISX0213_1(0xaec5),	JISX0212(0xb236)),
	/* U+50CD */	JISX0208(0xc6af),
	/* U+50CE */	IFX0213(JISX0213_2(0xa178),	JISX0212(0xb237)),
	/* U+50CF */	JISX0208(0xc1fc),
	/* U+50D0 */	IFX0213(JISX0213_1(0xaec7),	JISX0212(0xb238)),
	/* U+50D1 */	JISX0208(0xb6a3),
	/* U+50D2 */	U2E_NODEST_COLX,
	/* U+50D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb239)),
	/* U+50D4 */	IFX0213(JISX0213_2(0xa17a),	JISX0212(0xb23a)),
	/* U+50D5 */	JISX0208(0xcbcd),
	/* U+50D6 */	JISX0208(0xd1a5),
	/* U+50D7 */	U2E_NODEST_COLX,
	/* U+50D8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb23b)),
	/* U+50D9 */	IFX0213(JISX0213_2(0xa17b),	U2E_NODEST_COLX),
	/* U+50DA */	JISX0208(0xcebd),
	/* U+50DB */	U2E_NODEST_COLX,
	/* U+50DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb23c)),
	/* U+50DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb23d)),
	/* U+50DE */	JISX0208(0xd1a6),
	/* U+50DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb23e)),
	/* U+50E0 */	U2E_NODEST_COLX,
	/* U+50E1 */	IFX0213(JISX0213_2(0xa17c),	U2E_NODEST_COLX),
	/* U+50E2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb23f)),
	/* U+50E3 */	JISX0208(0xd1a9),
	/* U+50E4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb240)),
	/* U+50E5 */	JISX0208(0xd1a7),
	/* U+50E6 */	IFX0213(JISX0213_1(0xaec8),	JISX0212(0xb241)),
	/* U+50E7 */	JISX0208(0xc1ce),
	/* U+50E8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb242)),
	/* U+50E9 */	IFX0213(JISX0213_2(0xa17d),	JISX0212(0xb243)),
	/* U+50EA */	U2E_NODEST_COLX,
	/* U+50EB */	U2E_NODEST_COLX,
	/* U+50EC */	U2E_NODEST_COLX,
	/* U+50ED */	JISX0208(0xd1a8),
	/* U+50EE */	JISX0208(0xd1aa),
	/* U+50EF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb244)),
	/* U+50F0 */	U2E_NODEST_COLX,
	/* U+50F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb245)),
	/* U+50F2 */	IFX0213(JISX0213_1(0xaec6),	JISX0212(0xb251)),
	/* U+50F3 */	IFX0213(JISX0213_2(0xa176),	U2E_NODEST_COLX),
	/* U+50F4 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf430)),
	/* U+50F5 */	JISX0208(0xd1ac),
	/* U+50F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb246)),
	/* U+50F7 */	U2E_NODEST_COLX,
	/* U+50F8 */	U2E_NODEST_COLX,
	/* U+50F9 */	JISX0208(0xd1ab),
	/* U+50FA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb247)),
	/* U+50FB */	JISX0208(0xcac8),
	/* U+50FC */	U2E_NODEST_COLX,
	/* U+50FD */	U2E_NODEST_COLX,
	/* U+50FE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb248)),
	/* U+50FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_51[] = {
	/* U+5100 */	JISX0208(0xb5b7),
	/* U+5101 */	JISX0208(0xd1ae),
	/* U+5102 */	JISX0208(0xd1af),
	/* U+5103 */	IFX0213(JISX0213_1(0xaecb),	JISX0212(0xb249)),
	/* U+5104 */	JISX0208(0xb2af),
	/* U+5105 */	U2E_NODEST_COLX,
	/* U+5106 */	IFX0213(JISX0213_1(0xaeca),	JISX0212(0xb24a)),
	/* U+5107 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb24b)),
	/* U+5108 */	IFX0213(JISX0213_2(0xa321),	JISX0212(0xb24c)),
	/* U+5109 */	JISX0208(0xd1ad),
	/* U+510A */	U2E_NODEST_COLX,
	/* U+510B */	IFX0213(JISX0213_1(0xaecc),	JISX0212(0xb24d)),
	/* U+510C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb24e)),
	/* U+510D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb24f)),
	/* U+510E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb250)),
	/* U+510F */	U2E_NODEST_COLX,
	/* U+5110 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb252)),
	/* U+5111 */	U2E_NODEST_COLX,
	/* U+5112 */	JISX0208(0xbcf4),
	/* U+5113 */	U2E_NODEST_COLX,
	/* U+5114 */	JISX0208(0xd1b2),
	/* U+5115 */	JISX0208(0xd1b1),
	/* U+5116 */	JISX0208(0xd1b0),
	/* U+5117 */	IFX0213(JISX0213_2(0xa323),	JISX0212(0xb253)),
	/* U+5118 */	JISX0208(0xd0d6),
	/* U+5119 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb254)),
	/* U+511A */	JISX0208(0xd1b3),
	/* U+511B */	IFX0213(JISX0213_2(0xa324),	JISX0212(0xb255)),
	/* U+511C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb256)),
	/* U+511D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb257)),
	/* U+511E */	IFX0213(JISX0213_1(0xaecd),	JISX0212(0xb258)),
	/* U+511F */	JISX0208(0xbdfe),
	/* U+5120 */	U2E_NODEST_COLX,
	/* U+5121 */	JISX0208(0xd1b4),
	/* U+5122 */	U2E_NODEST_COLX,
	/* U+5123 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb259)),
	/* U+5124 */	U2E_NODEST_COLX,
	/* U+5125 */	U2E_NODEST_COLX,
	/* U+5126 */	U2E_NODEST_COLX,
	/* U+5127 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb25a)),
	/* U+5128 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb25b)),
	/* U+5129 */	U2E_NODEST_COLX,
	/* U+512A */	JISX0208(0xcda5),
	/* U+512B */	U2E_NODEST_COLX,
	/* U+512C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb25c)),
	/* U+512D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb25d)),
	/* U+512E */	U2E_NODEST_COLX,
	/* U+512F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb25e)),
	/* U+5130 */	U2E_NODEST_COLX,
	/* U+5131 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb25f)),
	/* U+5132 */	JISX0208(0xccd9),
	/* U+5133 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb260)),
	/* U+5134 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb261)),
	/* U+5135 */	IFX0213(JISX0213_1(0xaece),	JISX0212(0xb262)),
	/* U+5136 */	U2E_NODEST_COLX,
	/* U+5137 */	JISX0208(0xd1b6),
	/* U+5138 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb263)),
	/* U+5139 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb264)),
	/* U+513A */	JISX0208(0xd1b5),
	/* U+513B */	JISX0208(0xd1b8),
	/* U+513C */	JISX0208(0xd1b7),
	/* U+513D */	U2E_NODEST_COLX,
	/* U+513E */	U2E_NODEST_COLX,
	/* U+513F */	JISX0208(0xd1b9),
	/* U+5140 */	JISX0208(0xd1ba),
	/* U+5141 */	JISX0208(0xb0f4),
	/* U+5142 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb265)),
	/* U+5143 */	JISX0208(0xb8b5),
	/* U+5144 */	JISX0208(0xb7bb),
	/* U+5145 */	JISX0208(0xbdbc),
	/* U+5146 */	JISX0208(0xc3fb),
	/* U+5147 */	JISX0208(0xb6a4),
	/* U+5148 */	JISX0208(0xc0e8),
	/* U+5149 */	JISX0208(0xb8f7),
	/* U+514A */	IFX0213(JISX0213_1(0xaecf),	JISX0212(0xb266)),
	/* U+514B */	JISX0208(0xb9ee),
	/* U+514C */	JISX0208(0xd1bc),
	/* U+514D */	JISX0208(0xccc8),
	/* U+514E */	JISX0208(0xc5c6),
	/* U+514F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb267)),
	/* U+5150 */	JISX0208(0xbbf9),
	/* U+5151 */	U2E_NODEST_COLX,
	/* U+5152 */	JISX0208(0xd1bb),
	/* U+5153 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb268)),
	/* U+5154 */	JISX0208(0xd1bd),
	/* U+5155 */	IFX0213(JISX0213_1(0xaed1),	JISX0212(0xb269)),
	/* U+5156 */	U2E_NODEST_COLX,
	/* U+5157 */	IFX0213(JISX0213_1(0xaed2),	JISX0212(0xb26a)),
	/* U+5158 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb26b)),
	/* U+5159 */	U2E_NODEST_COLX,
	/* U+515A */	JISX0208(0xc5de),
	/* U+515B */	U2E_NODEST_COLX,
	/* U+515C */	JISX0208(0xb3f5),
	/* U+515D */	U2E_NODEST_COLX,
	/* U+515E */	U2E_NODEST_COLX,
	/* U+515F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb26c)),
	/* U+5160 */	IFX0213(JISX0213_2(0xa326),	U2E_NODEST_COLX),
	/* U+5161 */	U2E_NODEST_COLX,
	/* U+5162 */	JISX0208(0xd1be),
	/* U+5163 */	U2E_NODEST_COLX,
	/* U+5164 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb26d)),
	/* U+5165 */	JISX0208(0xc6fe),
	/* U+5166 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb26e)),
	/* U+5167 */	U2E_NODEST_COLX,
	/* U+5168 */	JISX0208(0xc1b4),
	/* U+5169 */	JISX0208(0xd1c0),
	/* U+516A */	JISX0208(0xd1c1),
	/* U+516B */	JISX0208(0xc8ac),
	/* U+516C */	JISX0208(0xb8f8),
	/* U+516D */	JISX0208(0xcfbb),
	/* U+516E */	JISX0208(0xd1c2),
	/* U+516F */	U2E_NODEST_COLX,
	/* U+5170 */	U2E_NODEST_COLX,
	/* U+5171 */	JISX0208(0xb6a6),
	/* U+5172 */	U2E_NODEST_COLX,
	/* U+5173 */	IFX0213(JISX0213_2(0xa328),	U2E_NODEST_COLX),
	/* U+5174 */	U2E_NODEST_COLX,
	/* U+5175 */	JISX0208(0xcabc),
	/* U+5176 */	JISX0208(0xc2b6),
	/* U+5177 */	JISX0208(0xb6f1),
	/* U+5178 */	JISX0208(0xc5b5),
	/* U+5179 */	U2E_NODEST_COLX,
	/* U+517A */	U2E_NODEST_COLX,
	/* U+517B */	IFX0213(JISX0213_2(0xf474),	U2E_NODEST_COLX),
	/* U+517C */	JISX0208(0xb7f3),
	/* U+517D */	U2E_NODEST_COLX,
	/* U+517E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb26f)),
	/* U+517F */	U2E_NODEST_COLX,
	/* U+5180 */	JISX0208(0xd1c3),
	/* U+5181 */	U2E_NODEST_COLX,
	/* U+5182 */	JISX0208(0xd1c4),
	/* U+5183 */	IFX0213(JISX0213_2(0xa329),	JISX0212(0xb270)),
	/* U+5184 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb271)),
	/* U+5185 */	JISX0208(0xc6e2),
	/* U+5186 */	JISX0208(0xb1df),
	/* U+5187 */	U2E_NODEST_COLX,
	/* U+5188 */	U2E_NODEST_COLX,
	/* U+5189 */	JISX0208(0xd1c7),
	/* U+518A */	JISX0208(0xbafd),
	/* U+518B */	IFX0213(JISX0213_2(0xa32a),	JISX0212(0xb272)),
	/* U+518C */	JISX0208(0xd1c6),
	/* U+518D */	JISX0208(0xbac6),
	/* U+518E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb273)),
	/* U+518F */	JISX0208(0xd1c8),
	/* U+5190 */	JISX0208(0xe6ee),
	/* U+5191 */	JISX0208(0xd1c9),
	/* U+5192 */	JISX0208(0xcbc1),
	/* U+5193 */	JISX0208(0xd1ca),
	/* U+5194 */	U2E_NODEST_COLX,
	/* U+5195 */	JISX0208(0xd1cb),
	/* U+5196 */	JISX0208(0xd1cc),
	/* U+5197 */	JISX0208(0xbee9),
	/* U+5198 */	IFX0213(JISX0213_2(0xa32c),	JISX0212(0xb274)),
	/* U+5199 */	JISX0208(0xbccc),
	/* U+519A */	U2E_NODEST_COLX,
	/* U+519B */	U2E_NODEST_COLX,
	/* U+519C */	U2E_NODEST_COLX,
	/* U+519D */	IFX0213(JISX0213_1(0xaed4),	JISX0212(0xb275)),
	/* U+519E */	U2E_NODEST_COLX,
	/* U+519F */	U2E_NODEST_COLX,
	/* U+51A0 */	JISX0208(0xb4a7),
	/* U+51A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb276)),
	/* U+51A2 */	JISX0208(0xd1cf),
	/* U+51A3 */	IFX0213(JISX0213_2(0xa32d),	JISX0212(0xb277)),
	/* U+51A4 */	JISX0208(0xd1cd),
	/* U+51A5 */	JISX0208(0xccbd),
	/* U+51A6 */	JISX0208(0xd1ce),
	/* U+51A7 */	U2E_NODEST_COLX,
	/* U+51A8 */	JISX0208(0xc9da),
	/* U+51A9 */	JISX0208(0xd1d0),
	/* U+51AA */	JISX0208(0xd1d1),
	/* U+51AB */	JISX0208(0xd1d2),
	/* U+51AC */	JISX0208(0xc5df),
	/* U+51AD */	IFX0213(JISX0213_2(0xa32e),	JISX0212(0xb278)),
	/* U+51AE */	U2E_NODEST_COLX,
	/* U+51AF */	U2E_NODEST_COLX,
	/* U+51B0 */	JISX0208(0xd1d6),
	/* U+51B1 */	JISX0208(0xd1d4),
	/* U+51B2 */	JISX0208(0xd1d5),
	/* U+51B3 */	JISX0208(0xd1d3),
	/* U+51B4 */	JISX0208(0xbae3),
	/* U+51B5 */	JISX0208(0xd1d7),
	/* U+51B6 */	JISX0208(0xccea),
	/* U+51B7 */	JISX0208(0xcee4),
	/* U+51B8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb279)),
	/* U+51B9 */	U2E_NODEST_COLX,
	/* U+51BA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb27a)),
	/* U+51BB */	U2E_NODEST_COLX,
	/* U+51BC */	IFX0213(JISX0213_2(0xa330),	JISX0212(0xb27b)),
	/* U+51BD */	JISX0208(0xd1d8),
	/* U+51BE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb27c)),
	/* U+51BF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb27d)),
	/* U+51C0 */	U2E_NODEST_COLX,
	/* U+51C1 */	U2E_NODEST_COLX,
	/* U+51C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb27e)),
	/* U+51C3 */	IFX0213(JISX0213_1(0xaed5),	U2E_NODEST_COLX),
	/* U+51C4 */	JISX0208(0xc0a8),
	/* U+51C5 */	JISX0208(0xd1d9),
	/* U+51C6 */	JISX0208(0xbdda),
	/* U+51C7 */	U2E_NODEST_COLX,
	/* U+51C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb321)),
	/* U+51C9 */	JISX0208(0xd1da),
	/* U+51CA */	IFX0213(JISX0213_1(0xaed6),	U2E_NODEST_COLX),
	/* U+51CB */	JISX0208(0xc3fc),
	/* U+51CC */	JISX0208(0xcebf),
	/* U+51CD */	JISX0208(0xc5e0),
	/* U+51CE */	U2E_NODEST_COLX,
	/* U+51CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb322)),
	/* U+51D0 */	U2E_NODEST_COLX,
	/* U+51D1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb323)),
	/* U+51D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb324)),
	/* U+51D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb325)),
	/* U+51D4 */	U2E_NODEST_COLX,
	/* U+51D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb326)),
	/* U+51D6 */	JISX0208(0xd2c5),
	/* U+51D7 */	U2E_NODEST_COLX,
	/* U+51D8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb327)),
	/* U+51D9 */	U2E_NODEST_COLX,
	/* U+51DA */	U2E_NODEST_COLX,
	/* U+51DB */	JISX0208(0xd1db),
	/* U+51DC */	JISX0208(0xf4a5),
	/* U+51DD */	JISX0208(0xb6c5),
	/* U+51DE */	IFX0213(JISX0213_1(0xaed7),	JISX0212(0xb328)),
	/* U+51DF */	U2E_NODEST_COLX,
	/* U+51E0 */	JISX0208(0xd1dc),
	/* U+51E1 */	JISX0208(0xcbde),
	/* U+51E2 */	IFX0213(JISX0213_1(0xaed8),	JISX0212(0xb329)),
	/* U+51E3 */	U2E_NODEST_COLX,
	/* U+51E4 */	U2E_NODEST_COLX,
	/* U+51E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb32a)),
	/* U+51E6 */	JISX0208(0xbde8),
	/* U+51E7 */	JISX0208(0xc2fc),
	/* U+51E8 */	U2E_NODEST_COLX,
	/* U+51E9 */	JISX0208(0xd1de),
	/* U+51EA */	JISX0208(0xc6e4),
	/* U+51EB */	U2E_NODEST_COLX,
	/* U+51EC */	IFX0213(U2E_NODEST_COLX,	IBM(0xf431)),
	/* U+51ED */	JISX0208(0xd1df),
	/* U+51EE */	IFX0213(JISX0213_1(0xaed9),	JISX0212(0xb32b)),
	/* U+51EF */	U2E_NODEST_COLX,
	/* U+51F0 */	JISX0208(0xd1e0),
	/* U+51F1 */	JISX0208(0xb3ae),
	/* U+51F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb32c)),
	/* U+51F3 */	IFX0213(JISX0213_2(0xa333),	JISX0212(0xb32d)),
	/* U+51F4 */	IFX0213(JISX0213_2(0xa334),	JISX0212(0xb32e)),
	/* U+51F5 */	JISX0208(0xd1e1),
	/* U+51F6 */	JISX0208(0xb6a7),
	/* U+51F7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb32f)),
	/* U+51F8 */	JISX0208(0xc6cc),
	/* U+51F9 */	JISX0208(0xb1fa),
	/* U+51FA */	JISX0208(0xbdd0),
	/* U+51FB */	U2E_NODEST_COLX,
	/* U+51FC */	U2E_NODEST_COLX,
	/* U+51FD */	JISX0208(0xc8a1),
	/* U+51FE */	JISX0208(0xd1e2),
	/* U+51FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_52[] = {
	/* U+5200 */	JISX0208(0xc5e1),
	/* U+5201 */	IFX0213(JISX0213_1(0xaeda),	JISX0212(0xb330)),
	/* U+5202 */	IFX0213(JISX0213_2(0xa335),	JISX0212(0xb331)),
	/* U+5203 */	JISX0208(0xbfcf),
	/* U+5204 */	JISX0208(0xd1e3),
	/* U+5205 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb332)),
	/* U+5206 */	JISX0208(0xcaac),
	/* U+5207 */	JISX0208(0xc0da),
	/* U+5208 */	JISX0208(0xb4a2),
	/* U+5209 */	U2E_NODEST_COLX,
	/* U+520A */	JISX0208(0xb4a9),
	/* U+520B */	JISX0208(0xd1e4),
	/* U+520C */	U2E_NODEST_COLX,
	/* U+520D */	U2E_NODEST_COLX,
	/* U+520E */	JISX0208(0xd1e6),
	/* U+520F */	U2E_NODEST_COLX,
	/* U+5210 */	U2E_NODEST_COLX,
	/* U+5211 */	JISX0208(0xb7ba),
	/* U+5212 */	IFX0213(JISX0213_2(0xa336),	JISX0212(0xb333)),
	/* U+5213 */	IFX0213(JISX0213_1(0xaedc),	JISX0212(0xb334)),
	/* U+5214 */	JISX0208(0xd1e5),
	/* U+5215 */	IFX0213(JISX0213_1(0xaedd),	JISX0212(0xb335)),
	/* U+5216 */	IFX0213(JISX0213_2(0xa337),	JISX0212(0xb336)),
	/* U+5217 */	JISX0208(0xcef3),
	/* U+5218 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb337)),
	/* U+5219 */	U2E_NODEST_COLX,
	/* U+521A */	U2E_NODEST_COLX,
	/* U+521B */	U2E_NODEST_COLX,
	/* U+521C */	U2E_NODEST_COLX,
	/* U+521D */	JISX0208(0xbde9),
	/* U+521E */	U2E_NODEST_COLX,
	/* U+521F */	U2E_NODEST_COLX,
	/* U+5220 */	U2E_NODEST_COLX,
	/* U+5221 */	U2E_NODEST_COLX,
	/* U+5222 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb338)),
	/* U+5223 */	U2E_NODEST_COLX,
	/* U+5224 */	JISX0208(0xc8bd),
	/* U+5225 */	JISX0208(0xcacc),
	/* U+5226 */	U2E_NODEST_COLX,
	/* U+5227 */	JISX0208(0xd1e7),
	/* U+5228 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb339)),
	/* U+5229 */	JISX0208(0xcdf8),
	/* U+522A */	JISX0208(0xd1e8),
	/* U+522B */	U2E_NODEST_COLX,
	/* U+522C */	U2E_NODEST_COLX,
	/* U+522D */	U2E_NODEST_COLX,
	/* U+522E */	JISX0208(0xd1e9),
	/* U+522F */	U2E_NODEST_COLX,
	/* U+5230 */	JISX0208(0xc5fe),
	/* U+5231 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb33a)),
	/* U+5232 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb33b)),
	/* U+5233 */	JISX0208(0xd1ea),
	/* U+5234 */	U2E_NODEST_COLX,
	/* U+5235 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb33c)),
	/* U+5236 */	JISX0208(0xc0a9),
	/* U+5237 */	JISX0208(0xbafe),
	/* U+5238 */	JISX0208(0xb7f4),
	/* U+5239 */	JISX0208(0xd1eb),
	/* U+523A */	JISX0208(0xbbc9),
	/* U+523B */	JISX0208(0xb9ef),
	/* U+523C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb33d)),
	/* U+523D */	U2E_NODEST_COLX,
	/* U+523E */	U2E_NODEST_COLX,
	/* U+523F */	U2E_NODEST_COLX,
	/* U+5240 */	U2E_NODEST_COLX,
	/* U+5241 */	U2E_NODEST_COLX,
	/* U+5242 */	U2E_NODEST_COLX,
	/* U+5243 */	JISX0208(0xc4e6),
	/* U+5244 */	JISX0208(0xd1ed),
	/* U+5245 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb33e)),
	/* U+5246 */	U2E_NODEST_COLX,
	/* U+5247 */	JISX0208(0xc2a7),
	/* U+5248 */	U2E_NODEST_COLX,
	/* U+5249 */	IFX0213(JISX0213_1(0xaede),	JISX0212(0xb33f)),
	/* U+524A */	JISX0208(0xbaef),
	/* U+524B */	JISX0208(0xd1ee),
	/* U+524C */	JISX0208(0xd1ef),
	/* U+524D */	JISX0208(0xc1b0),
	/* U+524E */	U2E_NODEST_COLX,
	/* U+524F */	JISX0208(0xd1ec),
	/* U+5250 */	U2E_NODEST_COLX,
	/* U+5251 */	U2E_NODEST_COLX,
	/* U+5252 */	U2E_NODEST_COLX,
	/* U+5253 */	U2E_NODEST_COLX,
	/* U+5254 */	JISX0208(0xd1f1),
	/* U+5255 */	IFX0213(JISX0213_2(0xa339),	JISX0212(0xb340)),
	/* U+5256 */	JISX0208(0xcbb6),
	/* U+5257 */	IFX0213(JISX0213_1(0xaedf),	JISX0212(0xb341)),
	/* U+5258 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb342)),
	/* U+5259 */	U2E_NODEST_COLX,
	/* U+525A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb343)),
	/* U+525B */	JISX0208(0xb9e4),
	/* U+525C */	IFX0213(JISX0213_2(0xa33a),	JISX0212(0xb344)),
	/* U+525D */	IFX0213(JISX0213_1(0xaffe),	U2E_NODEST_COLX),
	/* U+525E */	JISX0208(0xd1f0),
	/* U+525F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb345)),
	/* U+5260 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb346)),
	/* U+5261 */	IFX0213(JISX0213_1(0xaee0),	JISX0212(0xb347)),
	/* U+5262 */	U2E_NODEST_COLX,
	/* U+5263 */	JISX0208(0xb7f5),
	/* U+5264 */	JISX0208(0xbade),
	/* U+5265 */	JISX0208(0xc7ed),
	/* U+5266 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb348)),
	/* U+5267 */	U2E_NODEST_COLX,
	/* U+5268 */	U2E_NODEST_COLX,
	/* U+5269 */	JISX0208(0xd1f4),
	/* U+526A */	JISX0208(0xd1f2),
	/* U+526B */	U2E_NODEST_COLX,
	/* U+526C */	IFX0213(JISX0213_2(0xa33b),	U2E_NODEST_COLX),
	/* U+526D */	U2E_NODEST_COLX,
	/* U+526E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb349)),
	/* U+526F */	JISX0208(0xc9fb),
	/* U+5270 */	JISX0208(0xbeea),
	/* U+5271 */	JISX0208(0xd1fb),
	/* U+5272 */	JISX0208(0xb3e4),
	/* U+5273 */	JISX0208(0xd1f5),
	/* U+5274 */	JISX0208(0xd1f3),
	/* U+5275 */	JISX0208(0xc1cf),
	/* U+5276 */	U2E_NODEST_COLX,
	/* U+5277 */	IFX0213(JISX0213_2(0xa33c),	JISX0212(0xb34a)),
	/* U+5278 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb34b)),
	/* U+5279 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb34c)),
	/* U+527A */	U2E_NODEST_COLX,
	/* U+527B */	U2E_NODEST_COLX,
	/* U+527C */	U2E_NODEST_COLX,
	/* U+527D */	JISX0208(0xd1f7),
	/* U+527E */	U2E_NODEST_COLX,
	/* U+527F */	JISX0208(0xd1f6),
	/* U+5280 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb34d)),
	/* U+5281 */	U2E_NODEST_COLX,
	/* U+5282 */	IFX0213(JISX0213_2(0xa33e),	JISX0212(0xb34e)),
	/* U+5283 */	JISX0208(0xb3c4),
	/* U+5284 */	IFX0213(JISX0213_2(0xa33d),	U2E_NODEST_COLX),
	/* U+5285 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb34f)),
	/* U+5286 */	U2E_NODEST_COLX,
	/* U+5287 */	JISX0208(0xb7e0),
	/* U+5288 */	JISX0208(0xd1fc),
	/* U+5289 */	JISX0208(0xcead),
	/* U+528A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb350)),
	/* U+528B */	U2E_NODEST_COLX,
	/* U+528C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb351)),
	/* U+528D */	JISX0208(0xd1f8),
	/* U+528E */	U2E_NODEST_COLX,
	/* U+528F */	U2E_NODEST_COLX,
	/* U+5290 */	U2E_NODEST_COLX,
	/* U+5291 */	JISX0208(0xd1fd),
	/* U+5292 */	JISX0208(0xd1fa),
	/* U+5293 */	IFX0213(JISX0213_1(0xaee1),	JISX0212(0xb352)),
	/* U+5294 */	JISX0208(0xd1f9),
	/* U+5295 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb353)),
	/* U+5296 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb354)),
	/* U+5297 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb355)),
	/* U+5298 */	IFX0213(JISX0213_2(0xa340),	JISX0212(0xb356)),
	/* U+5299 */	U2E_NODEST_COLX,
	/* U+529A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb357)),
	/* U+529B */	JISX0208(0xcecf),
	/* U+529C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb358)),
	/* U+529D */	U2E_NODEST_COLX,
	/* U+529E */	U2E_NODEST_COLX,
	/* U+529F */	JISX0208(0xb8f9),
	/* U+52A0 */	JISX0208(0xb2c3),
	/* U+52A1 */	U2E_NODEST_COLX,
	/* U+52A2 */	U2E_NODEST_COLX,
	/* U+52A3 */	JISX0208(0xcef4),
	/* U+52A4 */	IFX0213(JISX0213_2(0xa342),	JISX0212(0xb359)),
	/* U+52A5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb35a)),
	/* U+52A6 */	IFX0213(JISX0213_2(0xa343),	JISX0212(0xb35b)),
	/* U+52A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb35c)),
	/* U+52A8 */	U2E_NODEST_COLX,
	/* U+52A9 */	JISX0208(0xbdf5),
	/* U+52AA */	JISX0208(0xc5d8),
	/* U+52AB */	JISX0208(0xb9e5),
	/* U+52AC */	JISX0208(0xd2a2),
	/* U+52AD */	JISX0208(0xd2a3),
	/* U+52AE */	U2E_NODEST_COLX,
	/* U+52AF */	IFX0213(JISX0213_2(0xa344),	JISX0212(0xb35d)),
	/* U+52B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb35e)),
	/* U+52B1 */	JISX0208(0xcee5),
	/* U+52B2 */	U2E_NODEST_COLX,
	/* U+52B3 */	U2E_NODEST_COLX,
	/* U+52B4 */	JISX0208(0xcfab),
	/* U+52B5 */	JISX0208(0xd2a5),
	/* U+52B6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb35f)),
	/* U+52B7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb360)),
	/* U+52B8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb361)),
	/* U+52B9 */	JISX0208(0xb8fa),
	/* U+52BA */	IFX0213(JISX0213_2(0xa345),	JISX0212(0xb362)),
	/* U+52BB */	IFX0213(JISX0213_2(0xa346),	JISX0212(0xb363)),
	/* U+52BC */	JISX0208(0xd2a4),
	/* U+52BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb364)),
	/* U+52BE */	JISX0208(0xb3af),
	/* U+52BF */	U2E_NODEST_COLX,
	/* U+52C0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb365)),
	/* U+52C1 */	JISX0208(0xd2a6),
	/* U+52C2 */	U2E_NODEST_COLX,
	/* U+52C3 */	JISX0208(0xcbd6),
	/* U+52C4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb366)),
	/* U+52C5 */	JISX0208(0xc4bc),
	/* U+52C6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb367)),
	/* U+52C7 */	JISX0208(0xcda6),
	/* U+52C8 */	IFX0213(JISX0213_1(0xaee2),	JISX0212(0xb368)),
	/* U+52C9 */	JISX0208(0xcad9),
	/* U+52CA */	IFX0213(JISX0213_2(0xa347),	U2E_NODEST_COLX),
	/* U+52CB */	U2E_NODEST_COLX,
	/* U+52CC */	IFX0213(JISX0213_1(0xaee4),	JISX0212(0xb369)),
	/* U+52CD */	JISX0208(0xd2a7),
	/* U+52CE */	U2E_NODEST_COLX,
	/* U+52CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb36a)),
	/* U+52D0 */	IFX0213(JISX0213_1(0xaee5),	U2E_NODEST_COLX),
	/* U+52D1 */	IFX0213(JISX0213_2(0xa349),	JISX0212(0xb36b)),
	/* U+52D2 */	JISX0208(0xf0d5),
	/* U+52D3 */	U2E_NODEST_COLX,
	/* U+52D4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb36c)),
	/* U+52D5 */	JISX0208(0xc6b0),
	/* U+52D6 */	IFX0213(JISX0213_1(0xaee6),	JISX0212(0xb36d)),
	/* U+52D7 */	JISX0208(0xd2a8),
	/* U+52D8 */	JISX0208(0xb4aa),
	/* U+52D9 */	JISX0208(0xccb3),
	/* U+52DA */	U2E_NODEST_COLX,
	/* U+52DB */	IFX0213(JISX0213_1(0xaee7),	JISX0212(0xb36e)),
	/* U+52DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb36f)),
	/* U+52DD */	JISX0208(0xbea1),
	/* U+52DE */	JISX0208(0xd2a9),
	/* U+52DF */	JISX0208(0xcae7),
	/* U+52E0 */	JISX0208(0xd2ad),
	/* U+52E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb370)),
	/* U+52E2 */	JISX0208(0xc0aa),
	/* U+52E3 */	JISX0208(0xd2aa),
	/* U+52E4 */	JISX0208(0xb6d0),
	/* U+52E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb371)),
	/* U+52E6 */	JISX0208(0xd2ab),
	/* U+52E7 */	JISX0208(0xb4ab),
	/* U+52E8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb372)),
	/* U+52E9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb373)),
	/* U+52EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb374)),
	/* U+52EB */	U2E_NODEST_COLX,
	/* U+52EC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb375)),
	/* U+52ED */	U2E_NODEST_COLX,
	/* U+52EE */	U2E_NODEST_COLX,
	/* U+52EF */	U2E_NODEST_COLX,
	/* U+52F0 */	IFX0213(JISX0213_1(0xaee9),	JISX0212(0xb376)),
	/* U+52F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb377)),
	/* U+52F2 */	JISX0208(0xb7ae),
	/* U+52F3 */	JISX0208(0xd2ae),
	/* U+52F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb378)),
	/* U+52F5 */	JISX0208(0xd2af),
	/* U+52F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb379)),
	/* U+52F7 */	IFX0213(JISX0213_2(0xa34b),	JISX0212(0xb37a)),
	/* U+52F8 */	JISX0208(0xd2b0),
	/* U+52F9 */	JISX0208(0xd2b1),
	/* U+52FA */	JISX0208(0xbcdb),
	/* U+52FB */	IFX0213(JISX0213_1(0xaeea),	U2E_NODEST_COLX),
	/* U+52FC */	U2E_NODEST_COLX,
	/* U+52FD */	U2E_NODEST_COLX,
	/* U+52FE */	JISX0208(0xb8fb),
	/* U+52FF */	JISX0208(0xccde),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_53[] = {
	/* U+5300 */	IFX0213(JISX0213_1(0xaeeb),	JISX0212(0xb37b)),
	/* U+5301 */	JISX0208(0xcce8),
	/* U+5302 */	JISX0208(0xc6f7),
	/* U+5303 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb37c)),
	/* U+5304 */	U2E_NODEST_COLX,
	/* U+5305 */	JISX0208(0xcaf1),
	/* U+5306 */	JISX0208(0xd2b2),
	/* U+5307 */	IFX0213(JISX0213_1(0xaeec),	IBM(0xf432)),
	/* U+5308 */	JISX0208(0xd2b3),
	/* U+5309 */	U2E_NODEST_COLX,
	/* U+530A */	IFX0213(JISX0213_2(0xa34c),	JISX0212(0xb37d)),
	/* U+530B */	IFX0213(JISX0213_2(0xa34d),	JISX0212(0xb37e)),
	/* U+530C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb421)),
	/* U+530D */	JISX0208(0xd2b5),
	/* U+530E */	U2E_NODEST_COLX,
	/* U+530F */	JISX0208(0xd2b7),
	/* U+5310 */	JISX0208(0xd2b6),
	/* U+5311 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb422)),
	/* U+5312 */	U2E_NODEST_COLX,
	/* U+5313 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb423)),
	/* U+5314 */	U2E_NODEST_COLX,
	/* U+5315 */	JISX0208(0xd2b8),
	/* U+5316 */	JISX0208(0xb2bd),
	/* U+5317 */	JISX0208(0xcbcc),
	/* U+5318 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb424)),
	/* U+5319 */	JISX0208(0xbafc),
	/* U+531A */	JISX0208(0xd2b9),
	/* U+531B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb425)),
	/* U+531C */	IFX0213(JISX0213_1(0xaeed),	JISX0212(0xb426)),
	/* U+531D */	JISX0208(0xc1d9),
	/* U+531E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb427)),
	/* U+531F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb428)),
	/* U+5320 */	JISX0208(0xbea2),
	/* U+5321 */	JISX0208(0xb6a9),
	/* U+5322 */	U2E_NODEST_COLX,
	/* U+5323 */	JISX0208(0xd2ba),
	/* U+5324 */	IFX0213(JISX0213_2(0xa34e),	IBM(0xf433)),
	/* U+5325 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb429)),
	/* U+5326 */	U2E_NODEST_COLX,
	/* U+5327 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb42a)),
	/* U+5328 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb42b)),
	/* U+5329 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb42c)),
	/* U+532A */	JISX0208(0xc8db),
	/* U+532B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb42d)),
	/* U+532C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb42e)),
	/* U+532D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb42f)),
	/* U+532E */	U2E_NODEST_COLX,
	/* U+532F */	JISX0208(0xd2bb),
	/* U+5330 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb430)),
	/* U+5331 */	JISX0208(0xd2bc),
	/* U+5332 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb431)),
	/* U+5333 */	JISX0208(0xd2bd),
	/* U+5334 */	U2E_NODEST_COLX,
	/* U+5335 */	IFX0213(JISX0213_2(0xa34f),	JISX0212(0xb432)),
	/* U+5336 */	U2E_NODEST_COLX,
	/* U+5337 */	U2E_NODEST_COLX,
	/* U+5338 */	JISX0208(0xd2be),
	/* U+5339 */	JISX0208(0xc9a4),
	/* U+533A */	JISX0208(0xb6e8),
	/* U+533B */	JISX0208(0xb0e5),
	/* U+533C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb433)),
	/* U+533D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb434)),
	/* U+533E */	IFX0213(JISX0213_2(0xa350),	JISX0212(0xb435)),
	/* U+533F */	JISX0208(0xc6bf),
	/* U+5340 */	JISX0208(0xd2bf),
	/* U+5341 */	JISX0208(0xbdbd),
	/* U+5342 */	IFX0213(JISX0213_2(0xa351),	JISX0212(0xb436)),
	/* U+5343 */	JISX0208(0xc0e9),
	/* U+5344 */	U2E_NODEST_COLX,
	/* U+5345 */	JISX0208(0xd2c1),
	/* U+5346 */	JISX0208(0xd2c0),
	/* U+5347 */	JISX0208(0xbea3),
	/* U+5348 */	JISX0208(0xb8e1),
	/* U+5349 */	JISX0208(0xd2c3),
	/* U+534A */	JISX0208(0xc8be),
	/* U+534B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb438)),
	/* U+534C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb437)),
	/* U+534D */	JISX0208(0xd2c4),
	/* U+534E */	U2E_NODEST_COLX,
	/* U+534F */	U2E_NODEST_COLX,
	/* U+5350 */	U2E_NODEST_COLX,
	/* U+5351 */	JISX0208(0xc8dc),
	/* U+5352 */	JISX0208(0xc2b4),
	/* U+5353 */	JISX0208(0xc2ee),
	/* U+5354 */	JISX0208(0xb6a8),
	/* U+5355 */	U2E_NODEST_COLX,
	/* U+5356 */	U2E_NODEST_COLX,
	/* U+5357 */	JISX0208(0xc6ee),
	/* U+5358 */	JISX0208(0xc3b1),
	/* U+5359 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb439)),
	/* U+535A */	JISX0208(0xc7ee),
	/* U+535B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb43a)),
	/* U+535C */	JISX0208(0xcbce),
	/* U+535D */	U2E_NODEST_COLX,
	/* U+535E */	JISX0208(0xd2c6),
	/* U+535F */	U2E_NODEST_COLX,
	/* U+5360 */	JISX0208(0xc0ea),
	/* U+5361 */	IFX0213(JISX0213_1(0xaeef),	JISX0212(0xb43b)),
	/* U+5362 */	U2E_NODEST_COLX,
	/* U+5363 */	IFX0213(JISX0213_1(0xaef0),	JISX0212(0xb43c)),
	/* U+5364 */	U2E_NODEST_COLX,
	/* U+5365 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb43d)),
	/* U+5366 */	JISX0208(0xb7b5),
	/* U+5367 */	IFX0213(JISX0213_2(0xa354),	U2E_NODEST_COLX),
	/* U+5368 */	U2E_NODEST_COLX,
	/* U+5369 */	JISX0208(0xd2c7),
	/* U+536A */	U2E_NODEST_COLX,
	/* U+536B */	U2E_NODEST_COLX,
	/* U+536C */	IFX0213(JISX0213_2(0xa355),	JISX0212(0xb43e)),
	/* U+536D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb43f)),
	/* U+536E */	JISX0208(0xd2c8),
	/* U+536F */	JISX0208(0xb1ac),
	/* U+5370 */	JISX0208(0xb0f5),
	/* U+5371 */	JISX0208(0xb4ed),
	/* U+5372 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb440)),
	/* U+5373 */	JISX0208(0xc2a8),
	/* U+5374 */	JISX0208(0xb5d1),
	/* U+5375 */	JISX0208(0xcdf1),
	/* U+5376 */	U2E_NODEST_COLX,
	/* U+5377 */	JISX0208(0xd2cb),
	/* U+5378 */	JISX0208(0xb2b7),
	/* U+5379 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb441)),
	/* U+537A */	IFX0213(JISX0213_2(0xa356),	U2E_NODEST_COLX),
	/* U+537B */	JISX0208(0xd2ca),
	/* U+537C */	U2E_NODEST_COLX,
	/* U+537D */	IFX0213(JISX0213_1(0xaef1),	U2E_NODEST_COLX),
	/* U+537E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb442)),
	/* U+537F */	JISX0208(0xb6aa),
	/* U+5380 */	U2E_NODEST_COLX,
	/* U+5381 */	U2E_NODEST_COLX,
	/* U+5382 */	JISX0208(0xd2cc),
	/* U+5383 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb443)),
	/* U+5384 */	JISX0208(0xccf1),
	/* U+5385 */	U2E_NODEST_COLX,
	/* U+5386 */	U2E_NODEST_COLX,
	/* U+5387 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb444)),
	/* U+5388 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb445)),
	/* U+5389 */	U2E_NODEST_COLX,
	/* U+538A */	U2E_NODEST_COLX,
	/* U+538B */	U2E_NODEST_COLX,
	/* U+538C */	U2E_NODEST_COLX,
	/* U+538D */	U2E_NODEST_COLX,
	/* U+538E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb446)),
	/* U+538F */	U2E_NODEST_COLX,
	/* U+5390 */	U2E_NODEST_COLX,
	/* U+5391 */	U2E_NODEST_COLX,
	/* U+5392 */	U2E_NODEST_COLX,
	/* U+5393 */	IFX0213(JISX0213_1(0xaef2),	JISX0212(0xb447)),
	/* U+5394 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb448)),
	/* U+5395 */	U2E_NODEST_COLX,
	/* U+5396 */	JISX0208(0xd2cd),
	/* U+5397 */	U2E_NODEST_COLX,
	/* U+5398 */	JISX0208(0xced2),
	/* U+5399 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb449)),
	/* U+539A */	JISX0208(0xb8fc),
	/* U+539B */	U2E_NODEST_COLX,
	/* U+539C */	U2E_NODEST_COLX,
	/* U+539D */	IFX0213(JISX0213_1(0xaef3),	JISX0212(0xb44a)),
	/* U+539E */	U2E_NODEST_COLX,
	/* U+539F */	JISX0208(0xb8b6),
	/* U+53A0 */	JISX0208(0xd2ce),
	/* U+53A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb44b)),
	/* U+53A2 */	U2E_NODEST_COLX,
	/* U+53A3 */	U2E_NODEST_COLX,
	/* U+53A4 */	IFX0213(JISX0213_2(0xa357),	JISX0212(0xb44c)),
	/* U+53A5 */	JISX0208(0xd2d0),
	/* U+53A6 */	JISX0208(0xd2cf),
	/* U+53A7 */	U2E_NODEST_COLX,
	/* U+53A8 */	JISX0208(0xbfdf),
	/* U+53A9 */	JISX0208(0xb1b9),
	/* U+53AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb44d)),
	/* U+53AB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb44e)),
	/* U+53AC */	U2E_NODEST_COLX,
	/* U+53AD */	JISX0208(0xb1de),
	/* U+53AE */	JISX0208(0xd2d1),
	/* U+53AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb44f)),
	/* U+53B0 */	JISX0208(0xd2d2),
	/* U+53B1 */	U2E_NODEST_COLX,
	/* U+53B2 */	IFX0213(JISX0213_1(0xaef4),	JISX0212(0xb450)),
	/* U+53B3 */	JISX0208(0xb8b7),
	/* U+53B4 */	IFX0213(JISX0213_2(0xa358),	JISX0212(0xb451)),
	/* U+53B5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb452)),
	/* U+53B6 */	JISX0208(0xd2d3),
	/* U+53B7 */	IFX0213(JISX0213_2(0xa35a),	JISX0212(0xb453)),
	/* U+53B8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb454)),
	/* U+53B9 */	U2E_NODEST_COLX,
	/* U+53BA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb455)),
	/* U+53BB */	JISX0208(0xb5ee),
	/* U+53BC */	U2E_NODEST_COLX,
	/* U+53BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb456)),
	/* U+53BE */	U2E_NODEST_COLX,
	/* U+53BF */	U2E_NODEST_COLX,
	/* U+53C0 */	IFX0213(JISX0213_2(0xa35b),	JISX0212(0xb457)),
	/* U+53C1 */	U2E_NODEST_COLX,
	/* U+53C2 */	JISX0208(0xbbb2),
	/* U+53C3 */	JISX0208(0xd2d4),
	/* U+53C4 */	U2E_NODEST_COLX,
	/* U+53C5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb458)),
	/* U+53C6 */	U2E_NODEST_COLX,
	/* U+53C7 */	U2E_NODEST_COLX,
	/* U+53C8 */	JISX0208(0xcbf4),
	/* U+53C9 */	JISX0208(0xbab5),
	/* U+53CA */	JISX0208(0xb5da),
	/* U+53CB */	JISX0208(0xcda7),
	/* U+53CC */	JISX0208(0xc1d0),
	/* U+53CD */	JISX0208(0xc8bf),
	/* U+53CE */	JISX0208(0xbcfd),
	/* U+53CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb459)),
	/* U+53D0 */	U2E_NODEST_COLX,
	/* U+53D1 */	U2E_NODEST_COLX,
	/* U+53D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb45a)),
	/* U+53D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb45b)),
	/* U+53D4 */	JISX0208(0xbdc7),
	/* U+53D5 */	IFX0213(JISX0213_2(0xa35f),	JISX0212(0xb45c)),
	/* U+53D6 */	JISX0208(0xbce8),
	/* U+53D7 */	JISX0208(0xbcf5),
	/* U+53D8 */	U2E_NODEST_COLX,
	/* U+53D9 */	JISX0208(0xbdf6),
	/* U+53DA */	IFX0213(JISX0213_2(0xa360),	JISX0212(0xb45d)),
	/* U+53DB */	JISX0208(0xc8c0),
	/* U+53DC */	U2E_NODEST_COLX,
	/* U+53DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb45e)),
	/* U+53DE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb45f)),
	/* U+53DF */	JISX0208(0xd2d7),
	/* U+53E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb460)),
	/* U+53E1 */	JISX0208(0xb1c3),
	/* U+53E2 */	JISX0208(0xc1d1),
	/* U+53E3 */	JISX0208(0xb8fd),
	/* U+53E4 */	JISX0208(0xb8c5),
	/* U+53E5 */	JISX0208(0xb6e7),
	/* U+53E6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb461)),
	/* U+53E7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb462)),
	/* U+53E8 */	JISX0208(0xd2db),
	/* U+53E9 */	JISX0208(0xc3a1),
	/* U+53EA */	JISX0208(0xc2fe),
	/* U+53EB */	JISX0208(0xb6ab),
	/* U+53EC */	JISX0208(0xbea4),
	/* U+53ED */	JISX0208(0xd2dc),
	/* U+53EE */	JISX0208(0xd2da),
	/* U+53EF */	JISX0208(0xb2c4),
	/* U+53F0 */	JISX0208(0xc2e6),
	/* U+53F1 */	JISX0208(0xbcb8),
	/* U+53F2 */	JISX0208(0xbbcb),
	/* U+53F3 */	JISX0208(0xb1a6),
	/* U+53F4 */	IFX0213(JISX0213_2(0xa362),	U2E_NODEST_COLX),
	/* U+53F5 */	IFX0213(JISX0213_2(0xa363),	JISX0212(0xb463)),
	/* U+53F6 */	JISX0208(0xb3f0),
	/* U+53F7 */	JISX0208(0xb9e6),
	/* U+53F8 */	JISX0208(0xbbca),
	/* U+53F9 */	U2E_NODEST_COLX,
	/* U+53FA */	JISX0208(0xd2dd),
	/* U+53FB */	U2E_NODEST_COLX,
	/* U+53FC */	U2E_NODEST_COLX,
	/* U+53FD */	U2E_NODEST_COLX,
	/* U+53FE */	U2E_NODEST_COLX,
	/* U+53FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_54[] = {
	/* U+5400 */	U2E_NODEST_COLX,
	/* U+5401 */	JISX0208(0xd2de),
	/* U+5402 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb464)),
	/* U+5403 */	JISX0208(0xb5c9),
	/* U+5404 */	JISX0208(0xb3c6),
	/* U+5405 */	U2E_NODEST_COLX,
	/* U+5406 */	U2E_NODEST_COLX,
	/* U+5407 */	U2E_NODEST_COLX,
	/* U+5408 */	JISX0208(0xb9e7),
	/* U+5409 */	JISX0208(0xb5c8),
	/* U+540A */	JISX0208(0xc4df),
	/* U+540B */	JISX0208(0xb1a5),
	/* U+540C */	JISX0208(0xc6b1),
	/* U+540D */	JISX0208(0xccbe),
	/* U+540E */	JISX0208(0xb9a1),
	/* U+540F */	JISX0208(0xcdf9),
	/* U+5410 */	JISX0208(0xc5c7),
	/* U+5411 */	JISX0208(0xb8fe),
	/* U+5412 */	IFX0213(JISX0213_1(0xaef5),	U2E_NODEST_COLX),
	/* U+5413 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb465)),
	/* U+5414 */	U2E_NODEST_COLX,
	/* U+5415 */	U2E_NODEST_COLX,
	/* U+5416 */	U2E_NODEST_COLX,
	/* U+5417 */	U2E_NODEST_COLX,
	/* U+5418 */	U2E_NODEST_COLX,
	/* U+5419 */	U2E_NODEST_COLX,
	/* U+541A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb466)),
	/* U+541B */	JISX0208(0xb7af),
	/* U+541C */	U2E_NODEST_COLX,
	/* U+541D */	JISX0208(0xd2e7),
	/* U+541E */	IFX0213(JISX0213_1(0xcffe),	U2E_NODEST_COLX),
	/* U+541F */	JISX0208(0xb6e3),
	/* U+5420 */	JISX0208(0xcbca),
	/* U+5421 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb467)),
	/* U+5422 */	U2E_NODEST_COLX,
	/* U+5423 */	U2E_NODEST_COLX,
	/* U+5424 */	IFX0213(JISX0213_2(0xa365),	U2E_NODEST_COLX),
	/* U+5425 */	U2E_NODEST_COLX,
	/* U+5426 */	JISX0208(0xc8dd),
	/* U+5427 */	IFX0213(JISX0213_1(0xaef6),	JISX0212(0xb468)),
	/* U+5428 */	IFX0213(JISX0213_2(0xa366),	JISX0212(0xb469)),
	/* U+5429 */	JISX0208(0xd2e6),
	/* U+542A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb46a)),
	/* U+542B */	JISX0208(0xb4de),
	/* U+542C */	JISX0208(0xd2e1),
	/* U+542D */	JISX0208(0xd2e2),
	/* U+542E */	JISX0208(0xd2e4),
	/* U+542F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb46b)),
	/* U+5430 */	U2E_NODEST_COLX,
	/* U+5431 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb46c)),
	/* U+5432 */	U2E_NODEST_COLX,
	/* U+5433 */	U2E_NODEST_COLX,
	/* U+5434 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb46d)),
	/* U+5435 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb46e)),
	/* U+5436 */	JISX0208(0xd2e5),
	/* U+5437 */	U2E_NODEST_COLX,
	/* U+5438 */	JISX0208(0xb5db),
	/* U+5439 */	JISX0208(0xbfe1),
	/* U+543A */	U2E_NODEST_COLX,
	/* U+543B */	JISX0208(0xcaad),
	/* U+543C */	JISX0208(0xd2e3),
	/* U+543D */	JISX0208(0xd2df),
	/* U+543E */	JISX0208(0xb8e3),
	/* U+543F */	U2E_NODEST_COLX,
	/* U+5440 */	JISX0208(0xd2e0),
	/* U+5441 */	U2E_NODEST_COLX,
	/* U+5442 */	JISX0208(0xcfa4),
	/* U+5443 */	IFX0213(JISX0213_2(0xa368),	JISX0212(0xb46f)),
	/* U+5444 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb470)),
	/* U+5445 */	U2E_NODEST_COLX,
	/* U+5446 */	JISX0208(0xcaf2),
	/* U+5447 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb471)),
	/* U+5448 */	JISX0208(0xc4e8),
	/* U+5449 */	JISX0208(0xb8e2),
	/* U+544A */	JISX0208(0xb9f0),
	/* U+544B */	U2E_NODEST_COLX,
	/* U+544C */	U2E_NODEST_COLX,
	/* U+544D */	IFX0213(JISX0213_1(0xaef7),	JISX0212(0xb472)),
	/* U+544E */	JISX0208(0xd2e8),
	/* U+544F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb473)),
	/* U+5450 */	U2E_NODEST_COLX,
	/* U+5451 */	JISX0208(0xc6dd),
	/* U+5452 */	U2E_NODEST_COLX,
	/* U+5453 */	U2E_NODEST_COLX,
	/* U+5454 */	U2E_NODEST_COLX,
	/* U+5455 */	IFX0213(JISX0213_2(0xa364),	U2E_NODEST_COLX),
	/* U+5456 */	U2E_NODEST_COLX,
	/* U+5457 */	U2E_NODEST_COLX,
	/* U+5458 */	U2E_NODEST_COLX,
	/* U+5459 */	U2E_NODEST_COLX,
	/* U+545A */	U2E_NODEST_COLX,
	/* U+545B */	U2E_NODEST_COLX,
	/* U+545C */	U2E_NODEST_COLX,
	/* U+545D */	U2E_NODEST_COLX,
	/* U+545E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb474)),
	/* U+545F */	JISX0208(0xd2ec),
	/* U+5460 */	U2E_NODEST_COLX,
	/* U+5461 */	U2E_NODEST_COLX,
	/* U+5462 */	IFX0213(JISX0213_2(0xa369),	JISX0212(0xb475)),
	/* U+5463 */	U2E_NODEST_COLX,
	/* U+5464 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb476)),
	/* U+5465 */	U2E_NODEST_COLX,
	/* U+5466 */	IFX0213(JISX0213_2(0xa36a),	JISX0212(0xb477)),
	/* U+5467 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb478)),
	/* U+5468 */	JISX0208(0xbcfe),
	/* U+5469 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb479)),
	/* U+546A */	JISX0208(0xbcf6),
	/* U+546B */	IFX0213(JISX0213_1(0xaef9),	JISX0212(0xb47a)),
	/* U+546C */	IFX0213(JISX0213_2(0xa36b),	U2E_NODEST_COLX),
	/* U+546D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb47b)),
	/* U+546E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb47c)),
	/* U+546F */	U2E_NODEST_COLX,
	/* U+5470 */	JISX0208(0xd2ef),
	/* U+5471 */	JISX0208(0xd2ed),
	/* U+5472 */	U2E_NODEST_COLX,
	/* U+5473 */	JISX0208(0xcca3),
	/* U+5474 */	IFX0213(JISX0213_1(0xaefa),	JISX0212(0xb47d)),
	/* U+5475 */	JISX0208(0xd2ea),
	/* U+5476 */	JISX0208(0xd2f3),
	/* U+5477 */	JISX0208(0xd2ee),
	/* U+5478 */	U2E_NODEST_COLX,
	/* U+5479 */	U2E_NODEST_COLX,
	/* U+547A */	U2E_NODEST_COLX,
	/* U+547B */	JISX0208(0xd2f1),
	/* U+547C */	JISX0208(0xb8c6),
	/* U+547D */	JISX0208(0xccbf),
	/* U+547E */	U2E_NODEST_COLX,
	/* U+547F */	IFX0213(JISX0213_1(0xaefb),	JISX0212(0xb47e)),
	/* U+5480 */	JISX0208(0xd2f2),
	/* U+5481 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb521)),
	/* U+5482 */	U2E_NODEST_COLX,
	/* U+5483 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb522)),
	/* U+5484 */	JISX0208(0xd2f4),
	/* U+5485 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb523)),
	/* U+5486 */	JISX0208(0xd2f6),
	/* U+5487 */	U2E_NODEST_COLX,
	/* U+5488 */	IFX0213(JISX0213_1(0xaefc),	JISX0212(0xb524)),
	/* U+5489 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb525)),
	/* U+548A */	IFX0213(JISX0213_2(0xa36c),	IBM(0xf435)),
	/* U+548B */	JISX0208(0xbaf0),
	/* U+548C */	JISX0208(0xcfc2),
	/* U+548D */	IFX0213(JISX0213_2(0xa36d),	JISX0212(0xb526)),
	/* U+548E */	JISX0208(0xd2eb),
	/* U+548F */	JISX0208(0xd2e9),
	/* U+5490 */	JISX0208(0xd2f5),
	/* U+5491 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb527)),
	/* U+5492 */	JISX0208(0xd2f0),
	/* U+5493 */	U2E_NODEST_COLX,
	/* U+5494 */	U2E_NODEST_COLX,
	/* U+5495 */	IFX0213(JISX0213_2(0xa36e),	JISX0212(0xb528)),
	/* U+5496 */	IFX0213(JISX0213_1(0xaefd),	JISX0212(0xb529)),
	/* U+5497 */	U2E_NODEST_COLX,
	/* U+5498 */	U2E_NODEST_COLX,
	/* U+5499 */	U2E_NODEST_COLX,
	/* U+549A */	U2E_NODEST_COLX,
	/* U+549B */	U2E_NODEST_COLX,
	/* U+549C */	IFX0213(JISX0213_1(0xaef8),	JISX0212(0xb52a)),
	/* U+549D */	U2E_NODEST_COLX,
	/* U+549E */	U2E_NODEST_COLX,
	/* U+549F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb52b)),
	/* U+54A0 */	IFX0213(JISX0213_2(0xa36f),	U2E_NODEST_COLX),
	/* U+54A1 */	IFX0213(JISX0213_1(0xaefe),	JISX0212(0xb52c)),
	/* U+54A2 */	JISX0208(0xd2f8),
	/* U+54A3 */	U2E_NODEST_COLX,
	/* U+54A4 */	JISX0208(0xd3a3),
	/* U+54A5 */	JISX0208(0xd2fa),
	/* U+54A6 */	IFX0213(JISX0213_2(0xa370),	JISX0212(0xb52d)),
	/* U+54A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb52e)),
	/* U+54A8 */	JISX0208(0xd2fe),
	/* U+54A9 */	IFX0213(JISX0213_1(0xafa1),	JISX0212(0xb52f)),
	/* U+54AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb530)),
	/* U+54AB */	JISX0208(0xd3a1),
	/* U+54AC */	JISX0208(0xd2fb),
	/* U+54AD */	IFX0213(JISX0213_2(0xa371),	JISX0212(0xb531)),
	/* U+54AE */	IFX0213(JISX0213_2(0xa372),	JISX0212(0xb532)),
	/* U+54AF */	JISX0208(0xd3be),
	/* U+54B0 */	U2E_NODEST_COLX,
	/* U+54B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb533)),
	/* U+54B2 */	JISX0208(0xbae9),
	/* U+54B3 */	JISX0208(0xb3b1),
	/* U+54B4 */	U2E_NODEST_COLX,
	/* U+54B5 */	U2E_NODEST_COLX,
	/* U+54B6 */	U2E_NODEST_COLX,
	/* U+54B7 */	IFX0213(JISX0213_2(0xa373),	JISX0212(0xb534)),
	/* U+54B8 */	JISX0208(0xd2f9),
	/* U+54B9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb535)),
	/* U+54BA */	IFX0213(JISX0213_2(0xa374),	JISX0212(0xb536)),
	/* U+54BB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb537)),
	/* U+54BC */	JISX0208(0xd3a5),
	/* U+54BD */	JISX0208(0xb0f6),
	/* U+54BE */	JISX0208(0xd3a4),
	/* U+54BF */	IFX0213(JISX0213_2(0xa375),	JISX0212(0xb538)),
	/* U+54C0 */	JISX0208(0xb0a5),
	/* U+54C1 */	JISX0208(0xc9ca),
	/* U+54C2 */	JISX0208(0xd3a2),
	/* U+54C3 */	IFX0213(JISX0213_2(0xa376),	U2E_NODEST_COLX),
	/* U+54C4 */	JISX0208(0xd2fc),
	/* U+54C5 */	U2E_NODEST_COLX,
	/* U+54C6 */	IFX0213(JISX0213_1(0xafa2),	JISX0212(0xb539)),
	/* U+54C7 */	JISX0208(0xd2f7),
	/* U+54C8 */	JISX0208(0xd2fd),
	/* U+54C9 */	JISX0208(0xbac8),
	/* U+54CA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb53a)),
	/* U+54CB */	U2E_NODEST_COLX,
	/* U+54CC */	U2E_NODEST_COLX,
	/* U+54CD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb53b)),
	/* U+54CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb53c)),
	/* U+54CF */	U2E_NODEST_COLX,
	/* U+54D0 */	U2E_NODEST_COLX,
	/* U+54D1 */	U2E_NODEST_COLX,
	/* U+54D2 */	U2E_NODEST_COLX,
	/* U+54D3 */	U2E_NODEST_COLX,
	/* U+54D4 */	U2E_NODEST_COLX,
	/* U+54D5 */	U2E_NODEST_COLX,
	/* U+54D6 */	U2E_NODEST_COLX,
	/* U+54D7 */	U2E_NODEST_COLX,
	/* U+54D8 */	JISX0208(0xd3a6),
	/* U+54D9 */	U2E_NODEST_COLX,
	/* U+54DA */	U2E_NODEST_COLX,
	/* U+54DB */	U2E_NODEST_COLX,
	/* U+54DC */	U2E_NODEST_COLX,
	/* U+54DD */	U2E_NODEST_COLX,
	/* U+54DE */	U2E_NODEST_COLX,
	/* U+54DF */	U2E_NODEST_COLX,
	/* U+54E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb53d)),
	/* U+54E1 */	JISX0208(0xb0f7),
	/* U+54E2 */	JISX0208(0xd3af),
	/* U+54E3 */	U2E_NODEST_COLX,
	/* U+54E4 */	U2E_NODEST_COLX,
	/* U+54E5 */	JISX0208(0xd3a7),
	/* U+54E6 */	JISX0208(0xd3a8),
	/* U+54E7 */	U2E_NODEST_COLX,
	/* U+54E8 */	JISX0208(0xbea5),
	/* U+54E9 */	JISX0208(0xcbe9),
	/* U+54EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb53e)),
	/* U+54EB */	U2E_NODEST_COLX,
	/* U+54EC */	IFX0213(JISX0213_2(0xa378),	JISX0212(0xb53f)),
	/* U+54ED */	JISX0208(0xd3ad),
	/* U+54EE */	JISX0208(0xd3ac),
	/* U+54EF */	IFX0213(JISX0213_2(0xa379),	JISX0212(0xb540)),
	/* U+54F0 */	U2E_NODEST_COLX,
	/* U+54F1 */	IFX0213(JISX0213_2(0xa37a),	U2E_NODEST_COLX),
	/* U+54F2 */	JISX0208(0xc5af),
	/* U+54F3 */	IFX0213(JISX0213_2(0xa37b),	U2E_NODEST_COLX),
	/* U+54F4 */	U2E_NODEST_COLX,
	/* U+54F5 */	U2E_NODEST_COLX,
	/* U+54F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb541)),
	/* U+54F7 */	U2E_NODEST_COLX,
	/* U+54F8 */	U2E_NODEST_COLX,
	/* U+54F9 */	U2E_NODEST_COLX,
	/* U+54FA */	JISX0208(0xd3ae),
	/* U+54FB */	U2E_NODEST_COLX,
	/* U+54FC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb542)),
	/* U+54FD */	JISX0208(0xd3ab),
	/* U+54FE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb543)),
	/* U+54FF */	IFX0213(JISX0213_1(0xafa3),	JISX0212(0xb544)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_55[] = {
	/* U+5500 */	IFX0213(JISX0213_2(0xa37c),	JISX0212(0xb545)),
	/* U+5501 */	IFX0213(JISX0213_2(0xa37d),	JISX0212(0xb546)),
	/* U+5502 */	U2E_NODEST_COLX,
	/* U+5503 */	U2E_NODEST_COLX,
	/* U+5504 */	JISX0208(0xb1b4),
	/* U+5505 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb547)),
	/* U+5506 */	JISX0208(0xbab6),
	/* U+5507 */	JISX0208(0xbfb0),
	/* U+5508 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb548)),
	/* U+5509 */	IFX0213(JISX0213_2(0xa37e),	JISX0212(0xb549)),
	/* U+550A */	U2E_NODEST_COLX,
	/* U+550B */	U2E_NODEST_COLX,
	/* U+550C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb54a)),
	/* U+550D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb54b)),
	/* U+550E */	IFX0213(JISX0213_1(0xafa4),	JISX0212(0xb54c)),
	/* U+550F */	JISX0208(0xd3a9),
	/* U+5510 */	JISX0208(0xc5e2),
	/* U+5511 */	U2E_NODEST_COLX,
	/* U+5512 */	U2E_NODEST_COLX,
	/* U+5513 */	U2E_NODEST_COLX,
	/* U+5514 */	JISX0208(0xd3aa),
	/* U+5515 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb54d)),
	/* U+5516 */	JISX0208(0xb0a2),
	/* U+5517 */	U2E_NODEST_COLX,
	/* U+5518 */	U2E_NODEST_COLX,
	/* U+5519 */	U2E_NODEST_COLX,
	/* U+551A */	U2E_NODEST_COLX,
	/* U+551B */	U2E_NODEST_COLX,
	/* U+551C */	U2E_NODEST_COLX,
	/* U+551D */	U2E_NODEST_COLX,
	/* U+551E */	U2E_NODEST_COLX,
	/* U+551F */	U2E_NODEST_COLX,
	/* U+5520 */	U2E_NODEST_COLX,
	/* U+5521 */	U2E_NODEST_COLX,
	/* U+5522 */	U2E_NODEST_COLX,
	/* U+5523 */	U2E_NODEST_COLX,
	/* U+5524 */	U2E_NODEST_COLX,
	/* U+5525 */	U2E_NODEST_COLX,
	/* U+5526 */	U2E_NODEST_COLX,
	/* U+5527 */	U2E_NODEST_COLX,
	/* U+5528 */	U2E_NODEST_COLX,
	/* U+5529 */	U2E_NODEST_COLX,
	/* U+552A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb54e)),
	/* U+552B */	IFX0213(JISX0213_1(0xafa5),	JISX0212(0xb54f)),
	/* U+552C */	U2E_NODEST_COLX,
	/* U+552D */	U2E_NODEST_COLX,
	/* U+552E */	JISX0208(0xd3b4),
	/* U+552F */	JISX0208(0xcda3),
	/* U+5530 */	U2E_NODEST_COLX,
	/* U+5531 */	JISX0208(0xbea7),
	/* U+5532 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb550)),
	/* U+5533 */	JISX0208(0xd3ba),
	/* U+5534 */	U2E_NODEST_COLX,
	/* U+5535 */	IFX0213(JISX0213_1(0xafa6),	JISX0212(0xb551)),
	/* U+5536 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb552)),
	/* U+5537 */	U2E_NODEST_COLX,
	/* U+5538 */	JISX0208(0xd3b9),
	/* U+5539 */	JISX0208(0xd3b0),
	/* U+553A */	U2E_NODEST_COLX,
	/* U+553B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb553)),
	/* U+553C */	IFX0213(JISX0213_2(0xa421),	JISX0212(0xb554)),
	/* U+553D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb555)),
	/* U+553E */	JISX0208(0xc2c3),
	/* U+553F */	U2E_NODEST_COLX,
	/* U+5540 */	JISX0208(0xd3b1),
	/* U+5541 */	IFX0213(JISX0213_2(0xa422),	JISX0212(0xb556)),
	/* U+5542 */	U2E_NODEST_COLX,
	/* U+5543 */	U2E_NODEST_COLX,
	/* U+5544 */	JISX0208(0xc2ef),
	/* U+5545 */	JISX0208(0xd3b6),
	/* U+5546 */	JISX0208(0xbea6),
	/* U+5547 */	IFX0213(JISX0213_2(0xa424),	JISX0212(0xb557)),
	/* U+5548 */	U2E_NODEST_COLX,
	/* U+5549 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb558)),
	/* U+554A */	IFX0213(JISX0213_2(0xa425),	JISX0212(0xb559)),
	/* U+554B */	U2E_NODEST_COLX,
	/* U+554C */	JISX0208(0xd3b3),
	/* U+554D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb55a)),
	/* U+554E */	U2E_NODEST_COLX,
	/* U+554F */	JISX0208(0xcce4),
	/* U+5550 */	IFX0213(JISX0213_1(0xafa7),	JISX0212(0xb55b)),
	/* U+5551 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb55c)),
	/* U+5552 */	U2E_NODEST_COLX,
	/* U+5553 */	JISX0208(0xb7bc),
	/* U+5554 */	U2E_NODEST_COLX,
	/* U+5555 */	U2E_NODEST_COLX,
	/* U+5556 */	JISX0208(0xd3b7),
	/* U+5557 */	JISX0208(0xd3b8),
	/* U+5558 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb55d)),
	/* U+5559 */	U2E_NODEST_COLX,
	/* U+555A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb55e)),
	/* U+555B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb55f)),
	/* U+555C */	JISX0208(0xd3b5),
	/* U+555D */	JISX0208(0xd3bb),
	/* U+555E */	IFX0213(JISX0213_1(0xafa8),	JISX0212(0xb560)),
	/* U+555F */	U2E_NODEST_COLX,
	/* U+5560 */	IFX0213(JISX0213_2(0xa427),	JISX0212(0xb561)),
	/* U+5561 */	IFX0213(JISX0213_2(0xa428),	JISX0212(0xb562)),
	/* U+5562 */	U2E_NODEST_COLX,
	/* U+5563 */	JISX0208(0xd3b2),
	/* U+5564 */	IFX0213(JISX0213_2(0xa429),	JISX0212(0xb563)),
	/* U+5565 */	U2E_NODEST_COLX,
	/* U+5566 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb564)),
	/* U+5567 */	U2E_NODEST_COLX,
	/* U+5568 */	U2E_NODEST_COLX,
	/* U+5569 */	U2E_NODEST_COLX,
	/* U+556A */	U2E_NODEST_COLX,
	/* U+556B */	U2E_NODEST_COLX,
	/* U+556C */	U2E_NODEST_COLX,
	/* U+556D */	U2E_NODEST_COLX,
	/* U+556E */	U2E_NODEST_COLX,
	/* U+556F */	U2E_NODEST_COLX,
	/* U+5570 */	U2E_NODEST_COLX,
	/* U+5571 */	U2E_NODEST_COLX,
	/* U+5572 */	U2E_NODEST_COLX,
	/* U+5573 */	U2E_NODEST_COLX,
	/* U+5574 */	U2E_NODEST_COLX,
	/* U+5575 */	U2E_NODEST_COLX,
	/* U+5576 */	U2E_NODEST_COLX,
	/* U+5577 */	U2E_NODEST_COLX,
	/* U+5578 */	U2E_NODEST_COLX,
	/* U+5579 */	U2E_NODEST_COLX,
	/* U+557A */	U2E_NODEST_COLX,
	/* U+557B */	JISX0208(0xd3c1),
	/* U+557C */	JISX0208(0xd3c6),
	/* U+557D */	IFX0213(JISX0213_2(0xa42b),	U2E_NODEST_COLX),
	/* U+557E */	JISX0208(0xd3c2),
	/* U+557F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb565)),
	/* U+5580 */	JISX0208(0xd3bd),
	/* U+5581 */	IFX0213(JISX0213_1(0xafa9),	JISX0212(0xb566)),
	/* U+5582 */	IFX0213(JISX0213_2(0xa42c),	JISX0212(0xb567)),
	/* U+5583 */	JISX0208(0xd3c7),
	/* U+5584 */	JISX0208(0xc1b1),
	/* U+5585 */	U2E_NODEST_COLX,
	/* U+5586 */	IFX0213(JISX0213_1(0xafaa),	JISX0212(0xb568)),
	/* U+5587 */	JISX0208(0xd3c9),
	/* U+5588 */	IFX0213(JISX0213_2(0xa42d),	JISX0212(0xb569)),
	/* U+5589 */	JISX0208(0xb9a2),
	/* U+558A */	JISX0208(0xd3bf),
	/* U+558B */	JISX0208(0xc3fd),
	/* U+558C */	U2E_NODEST_COLX,
	/* U+558D */	U2E_NODEST_COLX,
	/* U+558E */	IFX0213(JISX0213_1(0xafab),	JISX0212(0xb56a)),
	/* U+558F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb56b)),
	/* U+5590 */	U2E_NODEST_COLX,
	/* U+5591 */	IFX0213(JISX0213_2(0xa42e),	JISX0212(0xb56c)),
	/* U+5592 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb56d)),
	/* U+5593 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb56e)),
	/* U+5594 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb56f)),
	/* U+5595 */	U2E_NODEST_COLX,
	/* U+5596 */	U2E_NODEST_COLX,
	/* U+5597 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb570)),
	/* U+5598 */	JISX0208(0xd3c3),
	/* U+5599 */	JISX0208(0xd3bc),
	/* U+559A */	JISX0208(0xb4ad),
	/* U+559B */	U2E_NODEST_COLX,
	/* U+559C */	JISX0208(0xb4ee),
	/* U+559D */	JISX0208(0xb3e5),
	/* U+559E */	JISX0208(0xd3c4),
	/* U+559F */	JISX0208(0xd3c0),
	/* U+55A0 */	U2E_NODEST_COLX,
	/* U+55A1 */	U2E_NODEST_COLX,
	/* U+55A2 */	U2E_NODEST_COLX,
	/* U+55A3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb571)),
	/* U+55A4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb572)),
	/* U+55A5 */	U2E_NODEST_COLX,
	/* U+55A6 */	U2E_NODEST_COLX,
	/* U+55A7 */	JISX0208(0xb7f6),
	/* U+55A8 */	JISX0208(0xd3ca),
	/* U+55A9 */	JISX0208(0xd3c8),
	/* U+55AA */	JISX0208(0xc1d3),
	/* U+55AB */	JISX0208(0xb5ca),
	/* U+55AC */	JISX0208(0xb6ac),
	/* U+55AD */	IFX0213(JISX0213_1(0xafad),	JISX0212(0xb573)),
	/* U+55AE */	JISX0208(0xd3c5),
	/* U+55AF */	U2E_NODEST_COLX,
	/* U+55B0 */	JISX0208(0xb6f4),
	/* U+55B1 */	U2E_NODEST_COLX,
	/* U+55B2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb574)),
	/* U+55B3 */	U2E_NODEST_COLX,
	/* U+55B4 */	U2E_NODEST_COLX,
	/* U+55B5 */	U2E_NODEST_COLX,
	/* U+55B6 */	JISX0208(0xb1c4),
	/* U+55B7 */	U2E_NODEST_COLX,
	/* U+55B8 */	U2E_NODEST_COLX,
	/* U+55B9 */	U2E_NODEST_COLX,
	/* U+55BA */	U2E_NODEST_COLX,
	/* U+55BB */	U2E_NODEST_COLX,
	/* U+55BC */	U2E_NODEST_COLX,
	/* U+55BD */	U2E_NODEST_COLX,
	/* U+55BE */	U2E_NODEST_COLX,
	/* U+55BF */	IFX0213(JISX0213_2(0xa433),	JISX0212(0xb575)),
	/* U+55C0 */	U2E_NODEST_COLX,
	/* U+55C1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb576)),
	/* U+55C2 */	U2E_NODEST_COLX,
	/* U+55C3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb577)),
	/* U+55C4 */	JISX0208(0xd3ce),
	/* U+55C5 */	JISX0208(0xd3cc),
	/* U+55C6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb578)),
	/* U+55C7 */	JISX0208(0xd4a7),
	/* U+55C8 */	U2E_NODEST_COLX,
	/* U+55C9 */	IFX0213(JISX0213_2(0xa434),	JISX0212(0xb579)),
	/* U+55CA */	U2E_NODEST_COLX,
	/* U+55CB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb57a)),
	/* U+55CC */	IFX0213(JISX0213_2(0xa435),	JISX0212(0xb57b)),
	/* U+55CD */	U2E_NODEST_COLX,
	/* U+55CE */	IFX0213(JISX0213_1(0xafae),	JISX0212(0xb57c)),
	/* U+55CF */	U2E_NODEST_COLX,
	/* U+55D0 */	U2E_NODEST_COLX,
	/* U+55D1 */	IFX0213(JISX0213_2(0xa436),	JISX0212(0xb57d)),
	/* U+55D2 */	IFX0213(JISX0213_2(0xa430),	JISX0212(0xb57e)),
	/* U+55D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb621)),
	/* U+55D4 */	JISX0208(0xd3d1),
	/* U+55D5 */	U2E_NODEST_COLX,
	/* U+55D6 */	U2E_NODEST_COLX,
	/* U+55D7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb622)),
	/* U+55D8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb623)),
	/* U+55D9 */	U2E_NODEST_COLX,
	/* U+55DA */	JISX0208(0xd3cb),
	/* U+55DB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb624)),
	/* U+55DC */	JISX0208(0xd3cf),
	/* U+55DD */	IFX0213(JISX0213_2(0xa437),	U2E_NODEST_COLX),
	/* U+55DE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb625)),
	/* U+55DF */	JISX0208(0xd3cd),
	/* U+55E0 */	U2E_NODEST_COLX,
	/* U+55E1 */	U2E_NODEST_COLX,
	/* U+55E2 */	IFX0213(JISX0213_2(0xa439),	JISX0212(0xb626)),
	/* U+55E3 */	JISX0208(0xbbcc),
	/* U+55E4 */	JISX0208(0xd3d0),
	/* U+55E5 */	U2E_NODEST_COLX,
	/* U+55E6 */	U2E_NODEST_COLX,
	/* U+55E7 */	U2E_NODEST_COLX,
	/* U+55E8 */	U2E_NODEST_COLX,
	/* U+55E9 */	IFX0213(JISX0213_2(0xa43b),	JISX0212(0xb627)),
	/* U+55EA */	U2E_NODEST_COLX,
	/* U+55EB */	U2E_NODEST_COLX,
	/* U+55EC */	U2E_NODEST_COLX,
	/* U+55ED */	U2E_NODEST_COLX,
	/* U+55EE */	U2E_NODEST_COLX,
	/* U+55EF */	U2E_NODEST_COLX,
	/* U+55F0 */	U2E_NODEST_COLX,
	/* U+55F1 */	U2E_NODEST_COLX,
	/* U+55F2 */	U2E_NODEST_COLX,
	/* U+55F3 */	U2E_NODEST_COLX,
	/* U+55F4 */	U2E_NODEST_COLX,
	/* U+55F5 */	U2E_NODEST_COLX,
	/* U+55F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb628)),
	/* U+55F7 */	JISX0208(0xd3d3),
	/* U+55F8 */	U2E_NODEST_COLX,
	/* U+55F9 */	JISX0208(0xd3d8),
	/* U+55FA */	U2E_NODEST_COLX,
	/* U+55FB */	U2E_NODEST_COLX,
	/* U+55FC */	U2E_NODEST_COLX,
	/* U+55FD */	JISX0208(0xd3d6),
	/* U+55FE */	JISX0208(0xd3d5),
	/* U+55FF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb629)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_56[] = {
	/* U+5600 */	U2E_NODEST_COLX,
	/* U+5601 */	U2E_NODEST_COLX,
	/* U+5602 */	U2E_NODEST_COLX,
	/* U+5603 */	U2E_NODEST_COLX,
	/* U+5604 */	U2E_NODEST_COLX,
	/* U+5605 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb62a)),
	/* U+5606 */	JISX0208(0xc3b2),
	/* U+5607 */	IFX0213(JISX0213_2(0xa43e),	U2E_NODEST_COLX),
	/* U+5608 */	IFX0213(JISX0213_1(0xafb0),	JISX0212(0xb62b)),
	/* U+5609 */	JISX0208(0xb2c5),
	/* U+560A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb62c)),
	/* U+560B */	U2E_NODEST_COLX,
	/* U+560C */	U2E_NODEST_COLX,
	/* U+560D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb62d)),
	/* U+560E */	IFX0213(JISX0213_1(0xafb1),	JISX0212(0xb62e)),
	/* U+560F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb62f)),
	/* U+5610 */	IFX0213(JISX0213_2(0xa43f),	JISX0212(0xb630)),
	/* U+5611 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb631)),
	/* U+5612 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb632)),
	/* U+5613 */	U2E_NODEST_COLX,
	/* U+5614 */	JISX0208(0xd3d2),
	/* U+5615 */	U2E_NODEST_COLX,
	/* U+5616 */	JISX0208(0xd3d4),
	/* U+5617 */	JISX0208(0xbea8),
	/* U+5618 */	JISX0208(0xb1b3),
	/* U+5619 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb633)),
	/* U+561A */	U2E_NODEST_COLX,
	/* U+561B */	JISX0208(0xd3d7),
	/* U+561C */	U2E_NODEST_COLX,
	/* U+561D */	U2E_NODEST_COLX,
	/* U+561E */	U2E_NODEST_COLX,
	/* U+561F */	U2E_NODEST_COLX,
	/* U+5620 */	U2E_NODEST_COLX,
	/* U+5621 */	U2E_NODEST_COLX,
	/* U+5622 */	U2E_NODEST_COLX,
	/* U+5623 */	U2E_NODEST_COLX,
	/* U+5624 */	U2E_NODEST_COLX,
	/* U+5625 */	U2E_NODEST_COLX,
	/* U+5626 */	U2E_NODEST_COLX,
	/* U+5627 */	U2E_NODEST_COLX,
	/* U+5628 */	IFX0213(JISX0213_2(0xa43c),	U2E_NODEST_COLX),
	/* U+5629 */	JISX0208(0xb2de),
	/* U+562A */	U2E_NODEST_COLX,
	/* U+562B */	U2E_NODEST_COLX,
	/* U+562C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb634)),
	/* U+562D */	U2E_NODEST_COLX,
	/* U+562E */	U2E_NODEST_COLX,
	/* U+562F */	JISX0208(0xd3e2),
	/* U+5630 */	IFX0213(JISX0213_2(0xa440),	JISX0212(0xb635)),
	/* U+5631 */	JISX0208(0xbefc),
	/* U+5632 */	JISX0208(0xd3de),
	/* U+5633 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb636)),
	/* U+5634 */	JISX0208(0xd3dc),
	/* U+5635 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb637)),
	/* U+5636 */	JISX0208(0xd3dd),
	/* U+5637 */	IFX0213(JISX0213_2(0xa441),	JISX0212(0xb638)),
	/* U+5638 */	JISX0208(0xd3df),
	/* U+5639 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb639)),
	/* U+563A */	U2E_NODEST_COLX,
	/* U+563B */	IFX0213(JISX0213_1(0xafb2),	JISX0212(0xb63a)),
	/* U+563C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb63b)),
	/* U+563D */	IFX0213(JISX0213_2(0xa443),	JISX0212(0xb63c)),
	/* U+563E */	U2E_NODEST_COLX,
	/* U+563F */	IFX0213(JISX0213_2(0xa444),	JISX0212(0xb63d)),
	/* U+5640 */	IFX0213(JISX0213_2(0xa445),	JISX0212(0xb63e)),
	/* U+5641 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb63f)),
	/* U+5642 */	JISX0208(0xb1bd),
	/* U+5643 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb640)),
	/* U+5644 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb641)),
	/* U+5645 */	U2E_NODEST_COLX,
	/* U+5646 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb642)),
	/* U+5647 */	IFX0213(JISX0213_2(0xa446),	U2E_NODEST_COLX),
	/* U+5648 */	U2E_NODEST_COLX,
	/* U+5649 */	IFX0213(JISX0213_1(0xafb3),	JISX0212(0xb643)),
	/* U+564A */	U2E_NODEST_COLX,
	/* U+564B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb644)),
	/* U+564C */	JISX0208(0xc1b9),
	/* U+564D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb645)),
	/* U+564E */	JISX0208(0xd3d9),
	/* U+564F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb646)),
	/* U+5650 */	JISX0208(0xd3da),
	/* U+5651 */	U2E_NODEST_COLX,
	/* U+5652 */	U2E_NODEST_COLX,
	/* U+5653 */	IFX0213(JISX0213_1(0xf4a7),	U2E_NODEST_COLX),
	/* U+5654 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb647)),
	/* U+5655 */	U2E_NODEST_COLX,
	/* U+5656 */	U2E_NODEST_COLX,
	/* U+5657 */	U2E_NODEST_COLX,
	/* U+5658 */	U2E_NODEST_COLX,
	/* U+5659 */	U2E_NODEST_COLX,
	/* U+565A */	U2E_NODEST_COLX,
	/* U+565B */	JISX0208(0xb3fa),
	/* U+565C */	U2E_NODEST_COLX,
	/* U+565D */	U2E_NODEST_COLX,
	/* U+565E */	IFX0213(JISX0213_2(0xa447),	JISX0212(0xb648)),
	/* U+565F */	U2E_NODEST_COLX,
	/* U+5660 */	IFX0213(JISX0213_2(0xa448),	JISX0212(0xb649)),
	/* U+5661 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb64a)),
	/* U+5662 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb64b)),
	/* U+5663 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb64c)),
	/* U+5664 */	JISX0208(0xd3e1),
	/* U+5665 */	U2E_NODEST_COLX,
	/* U+5666 */	IFX0213(JISX0213_1(0xafb5),	JISX0212(0xb64d)),
	/* U+5667 */	U2E_NODEST_COLX,
	/* U+5668 */	JISX0208(0xb4ef),
	/* U+5669 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb64e)),
	/* U+566A */	JISX0208(0xd3e4),
	/* U+566B */	JISX0208(0xd3e0),
	/* U+566C */	JISX0208(0xd3e3),
	/* U+566D */	IFX0213(JISX0213_2(0xa449),	JISX0212(0xb64f)),
	/* U+566E */	U2E_NODEST_COLX,
	/* U+566F */	IFX0213(JISX0213_1(0xafb7),	JISX0212(0xb650)),
	/* U+5670 */	U2E_NODEST_COLX,
	/* U+5671 */	IFX0213(JISX0213_1(0xafb8),	JISX0212(0xb651)),
	/* U+5672 */	IFX0213(JISX0213_1(0xafb9),	JISX0212(0xb652)),
	/* U+5673 */	U2E_NODEST_COLX,
	/* U+5674 */	JISX0208(0xcaae),
	/* U+5675 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb653)),
	/* U+5676 */	IFX0213(JISX0213_1(0xafb4),	U2E_NODEST_COLX),
	/* U+5677 */	U2E_NODEST_COLX,
	/* U+5678 */	JISX0208(0xc6d5),
	/* U+5679 */	U2E_NODEST_COLX,
	/* U+567A */	JISX0208(0xc8b8),
	/* U+567B */	U2E_NODEST_COLX,
	/* U+567C */	U2E_NODEST_COLX,
	/* U+567D */	U2E_NODEST_COLX,
	/* U+567E */	U2E_NODEST_COLX,
	/* U+567F */	U2E_NODEST_COLX,
	/* U+5680 */	JISX0208(0xd3e6),
	/* U+5681 */	U2E_NODEST_COLX,
	/* U+5682 */	U2E_NODEST_COLX,
	/* U+5683 */	U2E_NODEST_COLX,
	/* U+5684 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb654)),
	/* U+5685 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb655)),
	/* U+5686 */	JISX0208(0xd3e5),
	/* U+5687 */	JISX0208(0xb3c5),
	/* U+5688 */	IFX0213(JISX0213_2(0xa44b),	JISX0212(0xb656)),
	/* U+5689 */	U2E_NODEST_COLX,
	/* U+568A */	JISX0208(0xd3e7),
	/* U+568B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb657)),
	/* U+568C */	IFX0213(JISX0213_2(0xa44c),	JISX0212(0xb658)),
	/* U+568D */	U2E_NODEST_COLX,
	/* U+568E */	U2E_NODEST_COLX,
	/* U+568F */	JISX0208(0xd3ea),
	/* U+5690 */	U2E_NODEST_COLX,
	/* U+5691 */	U2E_NODEST_COLX,
	/* U+5692 */	U2E_NODEST_COLX,
	/* U+5693 */	U2E_NODEST_COLX,
	/* U+5694 */	JISX0208(0xd3e9),
	/* U+5695 */	IFX0213(JISX0213_2(0xa44d),	JISX0212(0xb659)),
	/* U+5696 */	U2E_NODEST_COLX,
	/* U+5697 */	U2E_NODEST_COLX,
	/* U+5698 */	U2E_NODEST_COLX,
	/* U+5699 */	IFX0213(JISX0213_1(0xafba),	JISX0212(0xb65a)),
	/* U+569A */	IFX0213(JISX0213_2(0xa44e),	JISX0212(0xb65b)),
	/* U+569B */	U2E_NODEST_COLX,
	/* U+569C */	U2E_NODEST_COLX,
	/* U+569D */	IFX0213(JISX0213_2(0xa44f),	JISX0212(0xb65c)),
	/* U+569E */	IFX0213(JISX0213_1(0xafbb),	JISX0212(0xb65d)),
	/* U+569F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb65e)),
	/* U+56A0 */	JISX0208(0xd3e8),
	/* U+56A1 */	U2E_NODEST_COLX,
	/* U+56A2 */	JISX0208(0xc7b9),
	/* U+56A3 */	U2E_NODEST_COLX,
	/* U+56A4 */	U2E_NODEST_COLX,
	/* U+56A5 */	JISX0208(0xd3eb),
	/* U+56A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb65f)),
	/* U+56A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb660)),
	/* U+56A8 */	IFX0213(JISX0213_2(0xa450),	JISX0212(0xb661)),
	/* U+56A9 */	IFX0213(JISX0213_1(0xafbc),	JISX0212(0xb662)),
	/* U+56AA */	U2E_NODEST_COLX,
	/* U+56AB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb663)),
	/* U+56AC */	IFX0213(JISX0213_1(0xafbd),	JISX0212(0xb664)),
	/* U+56AD */	IFX0213(JISX0213_2(0xa451),	JISX0212(0xb665)),
	/* U+56AE */	JISX0208(0xd3ec),
	/* U+56AF */	U2E_NODEST_COLX,
	/* U+56B0 */	U2E_NODEST_COLX,
	/* U+56B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb666)),
	/* U+56B2 */	IFX0213(JISX0213_2(0xa452),	U2E_NODEST_COLX),
	/* U+56B3 */	IFX0213(JISX0213_1(0xafbe),	JISX0212(0xb667)),
	/* U+56B4 */	JISX0208(0xd3ee),
	/* U+56B5 */	U2E_NODEST_COLX,
	/* U+56B6 */	JISX0208(0xd3ed),
	/* U+56B7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb668)),
	/* U+56B8 */	U2E_NODEST_COLX,
	/* U+56B9 */	U2E_NODEST_COLX,
	/* U+56BA */	U2E_NODEST_COLX,
	/* U+56BB */	U2E_NODEST_COLX,
	/* U+56BC */	JISX0208(0xd3f0),
	/* U+56BD */	U2E_NODEST_COLX,
	/* U+56BE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb669)),
	/* U+56BF */	U2E_NODEST_COLX,
	/* U+56C0 */	JISX0208(0xd3f3),
	/* U+56C1 */	JISX0208(0xd3f1),
	/* U+56C2 */	JISX0208(0xd3ef),
	/* U+56C3 */	JISX0208(0xd3f2),
	/* U+56C4 */	U2E_NODEST_COLX,
	/* U+56C5 */	IFX0213(JISX0213_2(0xa453),	JISX0212(0xb66a)),
	/* U+56C6 */	U2E_NODEST_COLX,
	/* U+56C7 */	U2E_NODEST_COLX,
	/* U+56C8 */	JISX0208(0xd3f4),
	/* U+56C9 */	IFX0213(JISX0213_1(0xafbf),	JISX0212(0xb66b)),
	/* U+56CA */	IFX0213(JISX0213_1(0xafc0),	JISX0212(0xb66c)),
	/* U+56CB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb66d)),
	/* U+56CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb670)),
	/* U+56CD */	IFX0213(JISX0213_2(0xa454),	JISX0212(0xb671)),
	/* U+56CE */	JISX0208(0xd3f5),
	/* U+56CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb66e)),
	/* U+56D0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb66f)),
	/* U+56D1 */	JISX0208(0xd3f6),
	/* U+56D2 */	U2E_NODEST_COLX,
	/* U+56D3 */	JISX0208(0xd3f7),
	/* U+56D4 */	U2E_NODEST_COLX,
	/* U+56D5 */	U2E_NODEST_COLX,
	/* U+56D6 */	U2E_NODEST_COLX,
	/* U+56D7 */	JISX0208(0xd3f8),
	/* U+56D8 */	JISX0208(0xd1c5),
	/* U+56D9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb672)),
	/* U+56DA */	JISX0208(0xbcfc),
	/* U+56DB */	JISX0208(0xbbcd),
	/* U+56DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb673)),
	/* U+56DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb674)),
	/* U+56DE */	JISX0208(0xb2f3),
	/* U+56DF */	IFX0213(JISX0213_2(0xa455),	JISX0212(0xb675)),
	/* U+56E0 */	JISX0208(0xb0f8),
	/* U+56E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb676)),
	/* U+56E2 */	U2E_NODEST_COLX,
	/* U+56E3 */	JISX0208(0xc3c4),
	/* U+56E4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb677)),
	/* U+56E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb678)),
	/* U+56E6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb679)),
	/* U+56E7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb67a)),
	/* U+56E8 */	IFX0213(JISX0213_2(0xa456),	JISX0212(0xb67b)),
	/* U+56E9 */	U2E_NODEST_COLX,
	/* U+56EA */	U2E_NODEST_COLX,
	/* U+56EB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb67d)),
	/* U+56EC */	U2E_NODEST_COLX,
	/* U+56ED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb67e)),
	/* U+56EE */	JISX0208(0xd3f9),
	/* U+56EF */	U2E_NODEST_COLX,
	/* U+56F0 */	JISX0208(0xbaa4),
	/* U+56F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb67c)),
	/* U+56F2 */	JISX0208(0xb0cf),
	/* U+56F3 */	JISX0208(0xbfde),
	/* U+56F4 */	U2E_NODEST_COLX,
	/* U+56F5 */	U2E_NODEST_COLX,
	/* U+56F6 */	IFX0213(JISX0213_2(0xa457),	JISX0212(0xb721)),
	/* U+56F7 */	IFX0213(JISX0213_2(0xa458),	JISX0212(0xb722)),
	/* U+56F8 */	U2E_NODEST_COLX,
	/* U+56F9 */	JISX0208(0xd3fa),
	/* U+56FA */	JISX0208(0xb8c7),
	/* U+56FB */	U2E_NODEST_COLX,
	/* U+56FC */	U2E_NODEST_COLX,
	/* U+56FD */	JISX0208(0xb9f1),
	/* U+56FE */	U2E_NODEST_COLX,
	/* U+56FF */	JISX0208(0xd3fc),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_57[] = {
	/* U+5700 */	JISX0208(0xd3fb),
	/* U+5701 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb723)),
	/* U+5702 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb724)),
	/* U+5703 */	JISX0208(0xcae0),
	/* U+5704 */	JISX0208(0xd3fd),
	/* U+5705 */	U2E_NODEST_COLX,
	/* U+5706 */	U2E_NODEST_COLX,
	/* U+5707 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb725)),
	/* U+5708 */	JISX0208(0xd4a1),
	/* U+5709 */	JISX0208(0xd3fe),
	/* U+570A */	IFX0213(JISX0213_1(0xafc1),	JISX0212(0xb726)),
	/* U+570B */	JISX0208(0xd4a2),
	/* U+570C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb727)),
	/* U+570D */	JISX0208(0xd4a3),
	/* U+570E */	U2E_NODEST_COLX,
	/* U+570F */	JISX0208(0xb7f7),
	/* U+5710 */	U2E_NODEST_COLX,
	/* U+5711 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb728)),
	/* U+5712 */	JISX0208(0xb1e0),
	/* U+5713 */	JISX0208(0xd4a4),
	/* U+5714 */	U2E_NODEST_COLX,
	/* U+5715 */	IFX0213(JISX0213_2(0xa45a),	JISX0212(0xb729)),
	/* U+5716 */	JISX0208(0xd4a6),
	/* U+5717 */	U2E_NODEST_COLX,
	/* U+5718 */	JISX0208(0xd4a5),
	/* U+5719 */	U2E_NODEST_COLX,
	/* U+571A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb72a)),
	/* U+571B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb72b)),
	/* U+571C */	JISX0208(0xd4a8),
	/* U+571D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb72c)),
	/* U+571E */	U2E_NODEST_COLX,
	/* U+571F */	JISX0208(0xc5da),
	/* U+5720 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb72d)),
	/* U+5721 */	IFX0213(JISX0213_1(0xafc3),	U2E_NODEST_COLX),
	/* U+5722 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb72e)),
	/* U+5723 */	IFX0213(JISX0213_2(0xa45b),	JISX0212(0xb72f)),
	/* U+5724 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb730)),
	/* U+5725 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb731)),
	/* U+5726 */	JISX0208(0xd4a9),
	/* U+5727 */	JISX0208(0xb0b5),
	/* U+5728 */	JISX0208(0xbadf),
	/* U+5729 */	IFX0213(JISX0213_2(0xa45d),	JISX0212(0xb732)),
	/* U+572A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb733)),
	/* U+572B */	U2E_NODEST_COLX,
	/* U+572C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb734)),
	/* U+572D */	JISX0208(0xb7bd),
	/* U+572E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb735)),
	/* U+572F */	IFX0213(JISX0213_1(0xafc4),	JISX0212(0xb736)),
	/* U+5730 */	JISX0208(0xc3cf),
	/* U+5731 */	U2E_NODEST_COLX,
	/* U+5732 */	U2E_NODEST_COLX,
	/* U+5733 */	IFX0213(JISX0213_1(0xafc5),	JISX0212(0xb737)),
	/* U+5734 */	IFX0213(JISX0213_1(0xafc6),	JISX0212(0xb738)),
	/* U+5735 */	U2E_NODEST_COLX,
	/* U+5736 */	U2E_NODEST_COLX,
	/* U+5737 */	JISX0208(0xd4aa),
	/* U+5738 */	JISX0208(0xd4ab),
	/* U+5739 */	U2E_NODEST_COLX,
	/* U+573A */	U2E_NODEST_COLX,
	/* U+573B */	JISX0208(0xd4ad),
	/* U+573C */	U2E_NODEST_COLX,
	/* U+573D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb739)),
	/* U+573E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb73a)),
	/* U+573F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb73b)),
	/* U+5740 */	JISX0208(0xd4ae),
	/* U+5741 */	U2E_NODEST_COLX,
	/* U+5742 */	JISX0208(0xbae4),
	/* U+5743 */	U2E_NODEST_COLX,
	/* U+5744 */	U2E_NODEST_COLX,
	/* U+5745 */	IFX0213(JISX0213_2(0xa45f),	JISX0212(0xb73c)),
	/* U+5746 */	IFX0213(JISX0213_2(0xa460),	JISX0212(0xb73d)),
	/* U+5747 */	JISX0208(0xb6d1),
	/* U+5748 */	U2E_NODEST_COLX,
	/* U+5749 */	U2E_NODEST_COLX,
	/* U+574A */	JISX0208(0xcbb7),
	/* U+574B */	U2E_NODEST_COLX,
	/* U+574C */	IFX0213(JISX0213_2(0xa461),	JISX0212(0xb73e)),
	/* U+574D */	IFX0213(JISX0213_2(0xa462),	JISX0212(0xb73f)),
	/* U+574E */	JISX0208(0xd4ac),
	/* U+574F */	JISX0208(0xd4af),
	/* U+5750 */	JISX0208(0xbac1),
	/* U+5751 */	JISX0208(0xb9a3),
	/* U+5752 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb740)),
	/* U+5753 */	U2E_NODEST_COLX,
	/* U+5754 */	U2E_NODEST_COLX,
	/* U+5755 */	U2E_NODEST_COLX,
	/* U+5756 */	U2E_NODEST_COLX,
	/* U+5757 */	U2E_NODEST_COLX,
	/* U+5758 */	U2E_NODEST_COLX,
	/* U+5759 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf436)),
	/* U+575A */	U2E_NODEST_COLX,
	/* U+575B */	U2E_NODEST_COLX,
	/* U+575C */	U2E_NODEST_COLX,
	/* U+575D */	U2E_NODEST_COLX,
	/* U+575E */	U2E_NODEST_COLX,
	/* U+575F */	U2E_NODEST_COLX,
	/* U+5760 */	U2E_NODEST_COLX,
	/* U+5761 */	JISX0208(0xd4b3),
	/* U+5762 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb741)),
	/* U+5763 */	U2E_NODEST_COLX,
	/* U+5764 */	JISX0208(0xbaa5),
	/* U+5765 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb742)),
	/* U+5766 */	JISX0208(0xc3b3),
	/* U+5767 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb743)),
	/* U+5768 */	IFX0213(JISX0213_2(0xa464),	JISX0212(0xb744)),
	/* U+5769 */	JISX0208(0xd4b0),
	/* U+576A */	JISX0208(0xc4da),
	/* U+576B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb745)),
	/* U+576C */	U2E_NODEST_COLX,
	/* U+576D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb746)),
	/* U+576E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb747)),
	/* U+576F */	IFX0213(JISX0213_2(0xa465),	JISX0212(0xb748)),
	/* U+5770 */	IFX0213(JISX0213_1(0xafc7),	JISX0212(0xb749)),
	/* U+5771 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb74a)),
	/* U+5772 */	U2E_NODEST_COLX,
	/* U+5773 */	IFX0213(JISX0213_2(0xa466),	JISX0212(0xb74b)),
	/* U+5774 */	IFX0213(JISX0213_2(0xa467),	JISX0212(0xb74c)),
	/* U+5775 */	IFX0213(JISX0213_2(0xa468),	JISX0212(0xb74d)),
	/* U+5776 */	U2E_NODEST_COLX,
	/* U+5777 */	IFX0213(JISX0213_1(0xafc8),	JISX0212(0xb74e)),
	/* U+5778 */	U2E_NODEST_COLX,
	/* U+5779 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb74f)),
	/* U+577A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb750)),
	/* U+577B */	IFX0213(JISX0213_2(0xa469),	JISX0212(0xb751)),
	/* U+577C */	IFX0213(JISX0213_1(0xafc9),	JISX0212(0xb752)),
	/* U+577D */	U2E_NODEST_COLX,
	/* U+577E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb753)),
	/* U+577F */	JISX0208(0xd4b4),
	/* U+5780 */	U2E_NODEST_COLX,
	/* U+5781 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb754)),
	/* U+5782 */	JISX0208(0xbfe2),
	/* U+5783 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb755)),
	/* U+5784 */	U2E_NODEST_COLX,
	/* U+5785 */	U2E_NODEST_COLX,
	/* U+5786 */	U2E_NODEST_COLX,
	/* U+5787 */	U2E_NODEST_COLX,
	/* U+5788 */	JISX0208(0xd4b2),
	/* U+5789 */	JISX0208(0xd4b5),
	/* U+578A */	U2E_NODEST_COLX,
	/* U+578B */	JISX0208(0xb7bf),
	/* U+578C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb756)),
	/* U+578D */	U2E_NODEST_COLX,
	/* U+578E */	U2E_NODEST_COLX,
	/* U+578F */	U2E_NODEST_COLX,
	/* U+5790 */	U2E_NODEST_COLX,
	/* U+5791 */	U2E_NODEST_COLX,
	/* U+5792 */	U2E_NODEST_COLX,
	/* U+5793 */	JISX0208(0xd4b6),
	/* U+5794 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb757)),
	/* U+5795 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb760)),
	/* U+5796 */	U2E_NODEST_COLX,
	/* U+5797 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb758)),
	/* U+5798 */	U2E_NODEST_COLX,
	/* U+5799 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb759)),
	/* U+579A */	IFX0213(JISX0213_2(0xa46d),	JISX0212(0xb75a)),
	/* U+579B */	U2E_NODEST_COLX,
	/* U+579C */	IFX0213(JISX0213_1(0xafca),	JISX0212(0xb75b)),
	/* U+579D */	IFX0213(JISX0213_2(0xa46e),	JISX0212(0xb75c)),
	/* U+579E */	IFX0213(JISX0213_2(0xa46f),	JISX0212(0xb75d)),
	/* U+579F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb75e)),
	/* U+57A0 */	JISX0208(0xd4b7),
	/* U+57A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb75f)),
	/* U+57A2 */	JISX0208(0xb9a4),
	/* U+57A3 */	JISX0208(0xb3c0),
	/* U+57A4 */	JISX0208(0xd4b9),
	/* U+57A5 */	U2E_NODEST_COLX,
	/* U+57A6 */	U2E_NODEST_COLX,
	/* U+57A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb761)),
	/* U+57A8 */	IFX0213(JISX0213_2(0xa470),	JISX0212(0xb762)),
	/* U+57A9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb763)),
	/* U+57AA */	JISX0208(0xd4ba),
	/* U+57AB */	U2E_NODEST_COLX,
	/* U+57AC */	IFX0213(JISX0213_2(0xa46c),	JISX0212(0xb764)),
	/* U+57AD */	U2E_NODEST_COLX,
	/* U+57AE */	U2E_NODEST_COLX,
	/* U+57AF */	U2E_NODEST_COLX,
	/* U+57B0 */	JISX0208(0xd4bb),
	/* U+57B1 */	U2E_NODEST_COLX,
	/* U+57B2 */	U2E_NODEST_COLX,
	/* U+57B3 */	JISX0208(0xd4b8),
	/* U+57B4 */	U2E_NODEST_COLX,
	/* U+57B5 */	U2E_NODEST_COLX,
	/* U+57B6 */	U2E_NODEST_COLX,
	/* U+57B7 */	U2E_NODEST_COLX,
	/* U+57B8 */	IFX0213(JISX0213_1(0xafcd),	JISX0212(0xb765)),
	/* U+57B9 */	U2E_NODEST_COLX,
	/* U+57BA */	U2E_NODEST_COLX,
	/* U+57BB */	U2E_NODEST_COLX,
	/* U+57BC */	U2E_NODEST_COLX,
	/* U+57BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb766)),
	/* U+57BE */	U2E_NODEST_COLX,
	/* U+57BF */	U2E_NODEST_COLX,
	/* U+57C0 */	JISX0208(0xd4b1),
	/* U+57C1 */	U2E_NODEST_COLX,
	/* U+57C2 */	U2E_NODEST_COLX,
	/* U+57C3 */	JISX0208(0xd4bc),
	/* U+57C4 */	U2E_NODEST_COLX,
	/* U+57C5 */	U2E_NODEST_COLX,
	/* U+57C6 */	JISX0208(0xd4bd),
	/* U+57C7 */	IFX0213(JISX0213_1(0xafce),	JISX0212(0xb767)),
	/* U+57C8 */	IFX0213(JISX0213_1(0xafcf),	JISX0212(0xb768)),
	/* U+57C9 */	U2E_NODEST_COLX,
	/* U+57CA */	U2E_NODEST_COLX,
	/* U+57CB */	JISX0208(0xcbe4),
	/* U+57CC */	IFX0213(JISX0213_2(0xa473),	JISX0212(0xb769)),
	/* U+57CD */	U2E_NODEST_COLX,
	/* U+57CE */	JISX0208(0xbeeb),
	/* U+57CF */	IFX0213(JISX0213_1(0xafd0),	JISX0212(0xb76a)),
	/* U+57D0 */	U2E_NODEST_COLX,
	/* U+57D1 */	U2E_NODEST_COLX,
	/* U+57D2 */	JISX0208(0xd4bf),
	/* U+57D3 */	JISX0208(0xd4c0),
	/* U+57D4 */	JISX0208(0xd4be),
	/* U+57D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb76b)),
	/* U+57D6 */	JISX0208(0xd4c2),
	/* U+57D7 */	IFX0213(JISX0213_2(0xa471),	U2E_NODEST_COLX),
	/* U+57D8 */	U2E_NODEST_COLX,
	/* U+57D9 */	U2E_NODEST_COLX,
	/* U+57DA */	U2E_NODEST_COLX,
	/* U+57DB */	U2E_NODEST_COLX,
	/* U+57DC */	JISX0208(0xc7b8),
	/* U+57DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb76c)),
	/* U+57DE */	IFX0213(JISX0213_2(0xa476),	JISX0212(0xb76d)),
	/* U+57DF */	JISX0208(0xb0e8),
	/* U+57E0 */	JISX0208(0xc9d6),
	/* U+57E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb77e)),
	/* U+57E2 */	U2E_NODEST_COLX,
	/* U+57E3 */	JISX0208(0xd4c3),
	/* U+57E4 */	IFX0213(JISX0213_1(0xafd1),	JISX0212(0xb76e)),
	/* U+57E5 */	U2E_NODEST_COLX,
	/* U+57E6 */	IFX0213(JISX0213_2(0xa477),	JISX0212(0xb76f)),
	/* U+57E7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb770)),
	/* U+57E8 */	U2E_NODEST_COLX,
	/* U+57E9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb771)),
	/* U+57EA */	U2E_NODEST_COLX,
	/* U+57EB */	U2E_NODEST_COLX,
	/* U+57EC */	U2E_NODEST_COLX,
	/* U+57ED */	IFX0213(JISX0213_1(0xafd2),	JISX0212(0xb772)),
	/* U+57EE */	U2E_NODEST_COLX,
	/* U+57EF */	U2E_NODEST_COLX,
	/* U+57F0 */	IFX0213(JISX0213_2(0xa478),	JISX0212(0xb773)),
	/* U+57F1 */	U2E_NODEST_COLX,
	/* U+57F2 */	U2E_NODEST_COLX,
	/* U+57F3 */	U2E_NODEST_COLX,
	/* U+57F4 */	JISX0208(0xbefd),
	/* U+57F5 */	IFX0213(JISX0213_1(0xafd3),	JISX0212(0xb774)),
	/* U+57F6 */	IFX0213(JISX0213_1(0xafd4),	JISX0212(0xb775)),
	/* U+57F7 */	JISX0208(0xbcb9),
	/* U+57F8 */	IFX0213(JISX0213_2(0xa47a),	JISX0212(0xb776)),
	/* U+57F9 */	JISX0208(0xc7dd),
	/* U+57FA */	JISX0208(0xb4f0),
	/* U+57FB */	IFX0213(JISX0213_2(0xa47b),	U2E_NODEST_COLX),
	/* U+57FC */	JISX0208(0xbaeb),
	/* U+57FD */	IFX0213(JISX0213_2(0xa47c),	JISX0212(0xb777)),
	/* U+57FE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb778)),
	/* U+57FF */	IFX0213(JISX0213_1(0xafd5),	JISX0212(0xb779)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_58[] = {
	/* U+5800 */	JISX0208(0xcbd9),
	/* U+5801 */	U2E_NODEST_COLX,
	/* U+5802 */	JISX0208(0xc6b2),
	/* U+5803 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb77a)),
	/* U+5804 */	IFX0213(JISX0213_2(0xa47d),	JISX0212(0xb77b)),
	/* U+5805 */	JISX0208(0xb7f8),
	/* U+5806 */	JISX0208(0xc2cf),
	/* U+5807 */	U2E_NODEST_COLX,
	/* U+5808 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb77c)),
	/* U+5809 */	IFX0213(JISX0213_1(0xafd6),	JISX0212(0xb77d)),
	/* U+580A */	JISX0208(0xd4c1),
	/* U+580B */	JISX0208(0xd4c4),
	/* U+580C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb821)),
	/* U+580D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb822)),
	/* U+580E */	U2E_NODEST_COLX,
	/* U+580F */	U2E_NODEST_COLX,
	/* U+5810 */	U2E_NODEST_COLX,
	/* U+5811 */	U2E_NODEST_COLX,
	/* U+5812 */	U2E_NODEST_COLX,
	/* U+5813 */	U2E_NODEST_COLX,
	/* U+5814 */	U2E_NODEST_COLX,
	/* U+5815 */	JISX0208(0xc2c4),
	/* U+5816 */	U2E_NODEST_COLX,
	/* U+5817 */	U2E_NODEST_COLX,
	/* U+5818 */	U2E_NODEST_COLX,
	/* U+5819 */	JISX0208(0xd4c5),
	/* U+581A */	U2E_NODEST_COLX,
	/* U+581B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb823)),
	/* U+581C */	U2E_NODEST_COLX,
	/* U+581D */	JISX0208(0xd4c6),
	/* U+581E */	IFX0213(JISX0213_2(0xa47e),	JISX0212(0xb824)),
	/* U+581F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb825)),
	/* U+5820 */	IFX0213(JISX0213_2(0xa521),	JISX0212(0xb826)),
	/* U+5821 */	JISX0208(0xd4c8),
	/* U+5822 */	U2E_NODEST_COLX,
	/* U+5823 */	U2E_NODEST_COLX,
	/* U+5824 */	JISX0208(0xc4e9),
	/* U+5825 */	U2E_NODEST_COLX,
	/* U+5826 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb827)),
	/* U+5827 */	IFX0213(JISX0213_2(0xa522),	JISX0212(0xb828)),
	/* U+5828 */	U2E_NODEST_COLX,
	/* U+5829 */	U2E_NODEST_COLX,
	/* U+582A */	JISX0208(0xb4ae),
	/* U+582B */	U2E_NODEST_COLX,
	/* U+582C */	U2E_NODEST_COLX,
	/* U+582D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb829)),
	/* U+582E */	U2E_NODEST_COLX,
	/* U+582F */	JISX0208(0xf4a1),
	/* U+5830 */	JISX0208(0xb1e1),
	/* U+5831 */	JISX0208(0xcaf3),
	/* U+5832 */	IFX0213(JISX0213_2(0xa523),	JISX0212(0xb82a)),
	/* U+5833 */	U2E_NODEST_COLX,
	/* U+5834 */	JISX0208(0xbeec),
	/* U+5835 */	JISX0208(0xc5c8),
	/* U+5836 */	U2E_NODEST_COLX,
	/* U+5837 */	U2E_NODEST_COLX,
	/* U+5838 */	U2E_NODEST_COLX,
	/* U+5839 */	IFX0213(JISX0213_2(0xa524),	JISX0212(0xb82b)),
	/* U+583A */	JISX0208(0xbae6),
	/* U+583B */	U2E_NODEST_COLX,
	/* U+583C */	U2E_NODEST_COLX,
	/* U+583D */	JISX0208(0xd4ce),
	/* U+583E */	U2E_NODEST_COLX,
	/* U+583F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb82c)),
	/* U+5840 */	JISX0208(0xcabd),
	/* U+5841 */	JISX0208(0xcedd),
	/* U+5842 */	U2E_NODEST_COLX,
	/* U+5843 */	U2E_NODEST_COLX,
	/* U+5844 */	U2E_NODEST_COLX,
	/* U+5845 */	U2E_NODEST_COLX,
	/* U+5846 */	U2E_NODEST_COLX,
	/* U+5847 */	U2E_NODEST_COLX,
	/* U+5848 */	U2E_NODEST_COLX,
	/* U+5849 */	IFX0213(JISX0213_2(0xa526),	JISX0212(0xb82d)),
	/* U+584A */	JISX0208(0xb2f4),
	/* U+584B */	JISX0208(0xd4ca),
	/* U+584C */	IFX0213(JISX0213_2(0xa527),	JISX0212(0xb82e)),
	/* U+584D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb82f)),
	/* U+584E */	U2E_NODEST_COLX,
	/* U+584F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb830)),
	/* U+5850 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb831)),
	/* U+5851 */	JISX0208(0xc1ba),
	/* U+5852 */	JISX0208(0xd4cd),
	/* U+5853 */	U2E_NODEST_COLX,
	/* U+5854 */	JISX0208(0xc5e3),
	/* U+5855 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb832)),
	/* U+5856 */	U2E_NODEST_COLX,
	/* U+5857 */	JISX0208(0xc5c9),
	/* U+5858 */	JISX0208(0xc5e4),
	/* U+5859 */	JISX0208(0xc8b9),
	/* U+585A */	JISX0208(0xc4cd),
	/* U+585B */	U2E_NODEST_COLX,
	/* U+585C */	U2E_NODEST_COLX,
	/* U+585D */	U2E_NODEST_COLX,
	/* U+585E */	JISX0208(0xbac9),
	/* U+585F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb833)),
	/* U+5860 */	U2E_NODEST_COLX,
	/* U+5861 */	IFX0213(JISX0213_1(0xafd8),	JISX0212(0xb834)),
	/* U+5862 */	JISX0208(0xd4c9),
	/* U+5863 */	U2E_NODEST_COLX,
	/* U+5864 */	IFX0213(JISX0213_1(0xafd9),	JISX0212(0xb835)),
	/* U+5865 */	U2E_NODEST_COLX,
	/* U+5866 */	U2E_NODEST_COLX,
	/* U+5867 */	IFX0213(JISX0213_2(0xa528),	JISX0212(0xb836)),
	/* U+5868 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb837)),
	/* U+5869 */	JISX0208(0xb1f6),
	/* U+586A */	U2E_NODEST_COLX,
	/* U+586B */	JISX0208(0xc5b6),
	/* U+586C */	U2E_NODEST_COLX,
	/* U+586D */	U2E_NODEST_COLX,
	/* U+586E */	U2E_NODEST_COLX,
	/* U+586F */	U2E_NODEST_COLX,
	/* U+5870 */	JISX0208(0xd4cb),
	/* U+5871 */	U2E_NODEST_COLX,
	/* U+5872 */	JISX0208(0xd4c7),
	/* U+5873 */	U2E_NODEST_COLX,
	/* U+5874 */	U2E_NODEST_COLX,
	/* U+5875 */	JISX0208(0xbfd0),
	/* U+5876 */	U2E_NODEST_COLX,
	/* U+5877 */	U2E_NODEST_COLX,
	/* U+5878 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb838)),
	/* U+5879 */	JISX0208(0xd4cf),
	/* U+587A */	U2E_NODEST_COLX,
	/* U+587B */	U2E_NODEST_COLX,
	/* U+587C */	IFX0213(JISX0213_1(0xafdb),	JISX0212(0xb839)),
	/* U+587D */	U2E_NODEST_COLX,
	/* U+587E */	JISX0208(0xbdce),
	/* U+587F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb83a)),
	/* U+5880 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb83b)),
	/* U+5881 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb83c)),
	/* U+5882 */	U2E_NODEST_COLX,
	/* U+5883 */	JISX0208(0xb6ad),
	/* U+5884 */	U2E_NODEST_COLX,
	/* U+5885 */	JISX0208(0xd4d0),
	/* U+5886 */	U2E_NODEST_COLX,
	/* U+5887 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb83d)),
	/* U+5888 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb83e)),
	/* U+5889 */	IFX0213(JISX0213_1(0xafdc),	JISX0212(0xb83f)),
	/* U+588A */	IFX0213(JISX0213_2(0xa529),	JISX0212(0xb840)),
	/* U+588B */	IFX0213(JISX0213_2(0xa52a),	U2E_NODEST_COLX),
	/* U+588C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb841)),
	/* U+588D */	IFX0213(JISX0213_2(0xa52b),	JISX0212(0xb842)),
	/* U+588E */	U2E_NODEST_COLX,
	/* U+588F */	IFX0213(JISX0213_2(0xa52c),	JISX0212(0xb843)),
	/* U+5890 */	IFX0213(JISX0213_2(0xa52d),	JISX0212(0xb844)),
	/* U+5891 */	U2E_NODEST_COLX,
	/* U+5892 */	U2E_NODEST_COLX,
	/* U+5893 */	JISX0208(0xcae8),
	/* U+5894 */	IFX0213(JISX0213_2(0xa52e),	JISX0212(0xb845)),
	/* U+5895 */	U2E_NODEST_COLX,
	/* U+5896 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb846)),
	/* U+5897 */	JISX0208(0xc1fd),
	/* U+5898 */	U2E_NODEST_COLX,
	/* U+5899 */	U2E_NODEST_COLX,
	/* U+589A */	U2E_NODEST_COLX,
	/* U+589B */	U2E_NODEST_COLX,
	/* U+589C */	JISX0208(0xc4c6),
	/* U+589D */	IFX0213(JISX0213_2(0xa52f),	JISX0212(0xb847)),
	/* U+589E */	IFX0213(JISX0213_1(0xafdd),	IBM(0xf439)),
	/* U+589F */	JISX0208(0xd4d2),
	/* U+58A0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb848)),
	/* U+58A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb849)),
	/* U+58A2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb84a)),
	/* U+58A3 */	U2E_NODEST_COLX,
	/* U+58A4 */	U2E_NODEST_COLX,
	/* U+58A5 */	U2E_NODEST_COLX,
	/* U+58A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb84b)),
	/* U+58A7 */	U2E_NODEST_COLX,
	/* U+58A8 */	JISX0208(0xcbcf),
	/* U+58A9 */	IFX0213(JISX0213_1(0xafdf),	JISX0212(0xb84c)),
	/* U+58AA */	IFX0213(JISX0213_2(0xa530),	U2E_NODEST_COLX),
	/* U+58AB */	JISX0208(0xd4d3),
	/* U+58AC */	U2E_NODEST_COLX,
	/* U+58AD */	U2E_NODEST_COLX,
	/* U+58AE */	JISX0208(0xd4d8),
	/* U+58AF */	U2E_NODEST_COLX,
	/* U+58B0 */	U2E_NODEST_COLX,
	/* U+58B1 */	IFX0213(JISX0213_2(0xa531),	JISX0212(0xb84d)),
	/* U+58B2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb84e)),
	/* U+58B3 */	JISX0208(0xcaaf),
	/* U+58B4 */	U2E_NODEST_COLX,
	/* U+58B5 */	U2E_NODEST_COLX,
	/* U+58B6 */	U2E_NODEST_COLX,
	/* U+58B7 */	U2E_NODEST_COLX,
	/* U+58B8 */	JISX0208(0xd4d7),
	/* U+58B9 */	JISX0208(0xd4d1),
	/* U+58BA */	JISX0208(0xd4d4),
	/* U+58BB */	JISX0208(0xd4d6),
	/* U+58BC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb850)),
	/* U+58BD */	U2E_NODEST_COLX,
	/* U+58BE */	JISX0208(0xbaa6),
	/* U+58BF */	U2E_NODEST_COLX,
	/* U+58C0 */	U2E_NODEST_COLX,
	/* U+58C1 */	JISX0208(0xcac9),
	/* U+58C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb851)),
	/* U+58C3 */	IFX0213(JISX0213_2(0xa533),	U2E_NODEST_COLX),
	/* U+58C4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb84f)),
	/* U+58C5 */	JISX0208(0xd4d9),
	/* U+58C6 */	U2E_NODEST_COLX,
	/* U+58C7 */	JISX0208(0xc3c5),
	/* U+58C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb852)),
	/* U+58C9 */	U2E_NODEST_COLX,
	/* U+58CA */	JISX0208(0xb2f5),
	/* U+58CB */	U2E_NODEST_COLX,
	/* U+58CC */	JISX0208(0xbeed),
	/* U+58CD */	IFX0213(JISX0213_2(0xa534),	JISX0212(0xb853)),
	/* U+58CE */	IFX0213(JISX0213_1(0xafe2),	JISX0212(0xb854)),
	/* U+58CF */	U2E_NODEST_COLX,
	/* U+58D0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb855)),
	/* U+58D1 */	JISX0208(0xd4db),
	/* U+58D2 */	IFX0213(JISX0213_1(0xafe1),	JISX0212(0xb856)),
	/* U+58D3 */	JISX0208(0xd4da),
	/* U+58D4 */	IFX0213(JISX0213_1(0xafe3),	JISX0212(0xb857)),
	/* U+58D5 */	JISX0208(0xb9e8),
	/* U+58D6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb858)),
	/* U+58D7 */	JISX0208(0xd4dc),
	/* U+58D8 */	JISX0208(0xd4de),
	/* U+58D9 */	JISX0208(0xd4dd),
	/* U+58DA */	IFX0213(JISX0213_1(0xafe4),	JISX0212(0xb859)),
	/* U+58DB */	U2E_NODEST_COLX,
	/* U+58DC */	JISX0208(0xd4e0),
	/* U+58DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb85a)),
	/* U+58DE */	JISX0208(0xd4d5),
	/* U+58DF */	JISX0208(0xd4e2),
	/* U+58E0 */	IFX0213(JISX0213_1(0xafe5),	U2E_NODEST_COLX),
	/* U+58E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb85b)),
	/* U+58E2 */	IFX0213(JISX0213_2(0xa535),	JISX0212(0xb85c)),
	/* U+58E3 */	U2E_NODEST_COLX,
	/* U+58E4 */	JISX0208(0xd4e1),
	/* U+58E5 */	JISX0208(0xd4df),
	/* U+58E6 */	U2E_NODEST_COLX,
	/* U+58E7 */	U2E_NODEST_COLX,
	/* U+58E8 */	U2E_NODEST_COLX,
	/* U+58E9 */	IFX0213(JISX0213_1(0xafe6),	JISX0212(0xb85d)),
	/* U+58EA */	U2E_NODEST_COLX,
	/* U+58EB */	JISX0208(0xbbce),
	/* U+58EC */	JISX0208(0xbfd1),
	/* U+58ED */	U2E_NODEST_COLX,
	/* U+58EE */	JISX0208(0xc1d4),
	/* U+58EF */	JISX0208(0xd4e3),
	/* U+58F0 */	JISX0208(0xc0bc),
	/* U+58F1 */	JISX0208(0xb0ed),
	/* U+58F2 */	JISX0208(0xc7e4),
	/* U+58F3 */	IFX0213(JISX0213_2(0xa536),	JISX0212(0xb85e)),
	/* U+58F4 */	IFX0213(JISX0213_2(0xa537),	U2E_NODEST_COLX),
	/* U+58F5 */	U2E_NODEST_COLX,
	/* U+58F6 */	U2E_NODEST_COLX,
	/* U+58F7 */	JISX0208(0xc4db),
	/* U+58F8 */	U2E_NODEST_COLX,
	/* U+58F9 */	JISX0208(0xd4e5),
	/* U+58FA */	JISX0208(0xd4e4),
	/* U+58FB */	JISX0208(0xd4e6),
	/* U+58FC */	JISX0208(0xd4e7),
	/* U+58FD */	JISX0208(0xd4e8),
	/* U+58FE */	U2E_NODEST_COLX,
	/* U+58FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_59[] = {
	/* U+5900 */	U2E_NODEST_COLX,
	/* U+5901 */	U2E_NODEST_COLX,
	/* U+5902 */	JISX0208(0xd4e9),
	/* U+5903 */	U2E_NODEST_COLX,
	/* U+5904 */	U2E_NODEST_COLX,
	/* U+5905 */	IFX0213(JISX0213_2(0xa538),	JISX0212(0xb85f)),
	/* U+5906 */	IFX0213(JISX0213_2(0xa539),	JISX0212(0xb860)),
	/* U+5907 */	U2E_NODEST_COLX,
	/* U+5908 */	U2E_NODEST_COLX,
	/* U+5909 */	JISX0208(0xcad1),
	/* U+590A */	JISX0208(0xd4ea),
	/* U+590B */	IFX0213(JISX0213_2(0xa53a),	JISX0212(0xb861)),
	/* U+590C */	IFX0213(JISX0213_1(0xafe7),	JISX0212(0xb862)),
	/* U+590D */	IFX0213(JISX0213_2(0xa53b),	U2E_NODEST_COLX),
	/* U+590E */	U2E_NODEST_COLX,
	/* U+590F */	JISX0208(0xb2c6),
	/* U+5910 */	JISX0208(0xd4eb),
	/* U+5911 */	U2E_NODEST_COLX,
	/* U+5912 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb863)),
	/* U+5913 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb864)),
	/* U+5914 */	IFX0213(JISX0213_2(0xa53c),	JISX0212(0xb865)),
	/* U+5915 */	JISX0208(0xcdbc),
	/* U+5916 */	JISX0208(0xb3b0),
	/* U+5917 */	U2E_NODEST_COLX,
	/* U+5918 */	JISX0208(0xd2c9),
	/* U+5919 */	JISX0208(0xbdc8),
	/* U+591A */	JISX0208(0xc2bf),
	/* U+591B */	JISX0208(0xd4ec),
	/* U+591C */	JISX0208(0xcceb),
	/* U+591D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb867)),
	/* U+591E */	U2E_NODEST_COLX,
	/* U+591F */	U2E_NODEST_COLX,
	/* U+5920 */	U2E_NODEST_COLX,
	/* U+5921 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb868)),
	/* U+5922 */	JISX0208(0xccb4),
	/* U+5923 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb869)),
	/* U+5924 */	IFX0213(JISX0213_2(0xa53d),	JISX0212(0xb86a)),
	/* U+5925 */	JISX0208(0xd4ee),
	/* U+5926 */	U2E_NODEST_COLX,
	/* U+5927 */	JISX0208(0xc2e7),
	/* U+5928 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb86b)),
	/* U+5929 */	JISX0208(0xc5b7),
	/* U+592A */	JISX0208(0xc2c0),
	/* U+592B */	JISX0208(0xc9d7),
	/* U+592C */	JISX0208(0xd4ef),
	/* U+592D */	JISX0208(0xd4f0),
	/* U+592E */	JISX0208(0xb1fb),
	/* U+592F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb86c)),
	/* U+5930 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb86d)),
	/* U+5931 */	JISX0208(0xbcba),
	/* U+5932 */	JISX0208(0xd4f1),
	/* U+5933 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb86e)),
	/* U+5934 */	U2E_NODEST_COLX,
	/* U+5935 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb86f)),
	/* U+5936 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb870)),
	/* U+5937 */	JISX0208(0xb0d0),
	/* U+5938 */	JISX0208(0xd4f2),
	/* U+5939 */	U2E_NODEST_COLX,
	/* U+593A */	U2E_NODEST_COLX,
	/* U+593B */	U2E_NODEST_COLX,
	/* U+593C */	U2E_NODEST_COLX,
	/* U+593D */	IFX0213(JISX0213_2(0xa540),	U2E_NODEST_COLX),
	/* U+593E */	JISX0208(0xd4f3),
	/* U+593F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb871)),
	/* U+5940 */	U2E_NODEST_COLX,
	/* U+5941 */	U2E_NODEST_COLX,
	/* U+5942 */	U2E_NODEST_COLX,
	/* U+5943 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb872)),
	/* U+5944 */	JISX0208(0xb1e2),
	/* U+5945 */	U2E_NODEST_COLX,
	/* U+5946 */	IFX0213(JISX0213_2(0xa542),	JISX0212(0xb873)),
	/* U+5947 */	JISX0208(0xb4f1),
	/* U+5948 */	JISX0208(0xc6e0),
	/* U+5949 */	JISX0208(0xcaf4),
	/* U+594A */	U2E_NODEST_COLX,
	/* U+594B */	U2E_NODEST_COLX,
	/* U+594C */	U2E_NODEST_COLX,
	/* U+594D */	U2E_NODEST_COLX,
	/* U+594E */	JISX0208(0xd4f7),
	/* U+594F */	JISX0208(0xc1d5),
	/* U+5950 */	JISX0208(0xd4f6),
	/* U+5951 */	JISX0208(0xb7c0),
	/* U+5952 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb874)),
	/* U+5953 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb875)),
	/* U+5954 */	JISX0208(0xcbdb),
	/* U+5955 */	JISX0208(0xd4f5),
	/* U+5956 */	U2E_NODEST_COLX,
	/* U+5957 */	JISX0208(0xc5e5),
	/* U+5958 */	JISX0208(0xd4f9),
	/* U+5959 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb876)),
	/* U+595A */	JISX0208(0xd4f8),
	/* U+595B */	IFX0213(JISX0213_2(0xa545),	JISX0212(0xb877)),
	/* U+595C */	U2E_NODEST_COLX,
	/* U+595D */	IFX0213(JISX0213_1(0xafe9),	JISX0212(0xb878)),
	/* U+595E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb879)),
	/* U+595F */	IFX0213(JISX0213_2(0xa546),	JISX0212(0xb87a)),
	/* U+5960 */	JISX0208(0xd4fb),
	/* U+5961 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb87b)),
	/* U+5962 */	JISX0208(0xd4fa),
	/* U+5963 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb87c)),
	/* U+5964 */	U2E_NODEST_COLX,
	/* U+5965 */	JISX0208(0xb1fc),
	/* U+5966 */	U2E_NODEST_COLX,
	/* U+5967 */	JISX0208(0xd4fc),
	/* U+5968 */	JISX0208(0xbea9),
	/* U+5969 */	JISX0208(0xd4fe),
	/* U+596A */	JISX0208(0xc3a5),
	/* U+596B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb87d)),
	/* U+596C */	JISX0208(0xd4fd),
	/* U+596D */	IFX0213(JISX0213_1(0xafea),	JISX0212(0xb87e)),
	/* U+596E */	JISX0208(0xcab3),
	/* U+596F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb921)),
	/* U+5970 */	U2E_NODEST_COLX,
	/* U+5971 */	U2E_NODEST_COLX,
	/* U+5972 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb922)),
	/* U+5973 */	JISX0208(0xbdf7),
	/* U+5974 */	JISX0208(0xc5db),
	/* U+5975 */	IFX0213(JISX0213_2(0xa548),	JISX0212(0xb923)),
	/* U+5976 */	IFX0213(JISX0213_2(0xa549),	JISX0212(0xb924)),
	/* U+5977 */	U2E_NODEST_COLX,
	/* U+5978 */	JISX0208(0xd5a1),
	/* U+5979 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb925)),
	/* U+597A */	U2E_NODEST_COLX,
	/* U+597B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb926)),
	/* U+597C */	IFX0213(JISX0213_2(0xa54a),	JISX0212(0xb927)),
	/* U+597D */	JISX0208(0xb9a5),
	/* U+597E */	U2E_NODEST_COLX,
	/* U+597F */	U2E_NODEST_COLX,
	/* U+5980 */	U2E_NODEST_COLX,
	/* U+5981 */	JISX0208(0xd5a2),
	/* U+5982 */	JISX0208(0xc7a1),
	/* U+5983 */	JISX0208(0xc8de),
	/* U+5984 */	JISX0208(0xccd1),
	/* U+5985 */	U2E_NODEST_COLX,
	/* U+5986 */	U2E_NODEST_COLX,
	/* U+5987 */	U2E_NODEST_COLX,
	/* U+5988 */	U2E_NODEST_COLX,
	/* U+5989 */	U2E_NODEST_COLX,
	/* U+598A */	JISX0208(0xc7a5),
	/* U+598B */	IFX0213(JISX0213_1(0xafeb),	JISX0212(0xb928)),
	/* U+598C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb929)),
	/* U+598D */	JISX0208(0xd5ab),
	/* U+598E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb92a)),
	/* U+598F */	U2E_NODEST_COLX,
	/* U+5990 */	U2E_NODEST_COLX,
	/* U+5991 */	U2E_NODEST_COLX,
	/* U+5992 */	IFX0213(JISX0213_1(0xafec),	JISX0212(0xb92b)),
	/* U+5993 */	JISX0208(0xb5b8),
	/* U+5994 */	U2E_NODEST_COLX,
	/* U+5995 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb92c)),
	/* U+5996 */	JISX0208(0xcdc5),
	/* U+5997 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb92d)),
	/* U+5998 */	U2E_NODEST_COLX,
	/* U+5999 */	JISX0208(0xccaf),
	/* U+599A */	U2E_NODEST_COLX,
	/* U+599B */	JISX0208(0xd6ac),
	/* U+599C */	U2E_NODEST_COLX,
	/* U+599D */	JISX0208(0xd5a3),
	/* U+599E */	U2E_NODEST_COLX,
	/* U+599F */	IFX0213(JISX0213_2(0xa54b),	JISX0212(0xb92e)),
	/* U+59A0 */	U2E_NODEST_COLX,
	/* U+59A1 */	U2E_NODEST_COLX,
	/* U+59A2 */	U2E_NODEST_COLX,
	/* U+59A3 */	JISX0208(0xd5a6),
	/* U+59A4 */	IFX0213(JISX0213_1(0xafed),	JISX0212(0xb92f)),
	/* U+59A5 */	JISX0208(0xc2c5),
	/* U+59A6 */	U2E_NODEST_COLX,
	/* U+59A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb930)),
	/* U+59A8 */	JISX0208(0xcbb8),
	/* U+59A9 */	U2E_NODEST_COLX,
	/* U+59AA */	U2E_NODEST_COLX,
	/* U+59AB */	U2E_NODEST_COLX,
	/* U+59AC */	JISX0208(0xc5ca),
	/* U+59AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb931)),
	/* U+59AE */	IFX0213(JISX0213_2(0xa54c),	JISX0212(0xb932)),
	/* U+59AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb933)),
	/* U+59B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb934)),
	/* U+59B1 */	U2E_NODEST_COLX,
	/* U+59B2 */	JISX0208(0xd5a7),
	/* U+59B3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb935)),
	/* U+59B4 */	U2E_NODEST_COLX,
	/* U+59B5 */	U2E_NODEST_COLX,
	/* U+59B6 */	U2E_NODEST_COLX,
	/* U+59B7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb936)),
	/* U+59B8 */	U2E_NODEST_COLX,
	/* U+59B9 */	JISX0208(0xcbe5),
	/* U+59BA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb937)),
	/* U+59BB */	JISX0208(0xbaca),
	/* U+59BC */	IFX0213(JISX0213_2(0xa54d),	JISX0212(0xb938)),
	/* U+59BD */	U2E_NODEST_COLX,
	/* U+59BE */	JISX0208(0xbeaa),
	/* U+59BF */	U2E_NODEST_COLX,
	/* U+59C0 */	U2E_NODEST_COLX,
	/* U+59C1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb939)),
	/* U+59C2 */	U2E_NODEST_COLX,
	/* U+59C3 */	IFX0213(JISX0213_1(0xafee),	JISX0212(0xb93a)),
	/* U+59C4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb93b)),
	/* U+59C5 */	U2E_NODEST_COLX,
	/* U+59C6 */	JISX0208(0xd5a8),
	/* U+59C7 */	U2E_NODEST_COLX,
	/* U+59C8 */	IFX0213(JISX0213_2(0xa54e),	JISX0212(0xb93c)),
	/* U+59C9 */	JISX0208(0xbbd0),
	/* U+59CA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb93d)),
	/* U+59CB */	JISX0208(0xbbcf),
	/* U+59CC */	U2E_NODEST_COLX,
	/* U+59CD */	IFX0213(JISX0213_2(0xa54f),	JISX0212(0xb93e)),
	/* U+59CE */	U2E_NODEST_COLX,
	/* U+59CF */	U2E_NODEST_COLX,
	/* U+59D0 */	JISX0208(0xb0b9),
	/* U+59D1 */	JISX0208(0xb8c8),
	/* U+59D2 */	IFX0213(JISX0213_1(0xafef),	JISX0212(0xb93f)),
	/* U+59D3 */	JISX0208(0xc0ab),
	/* U+59D4 */	JISX0208(0xb0d1),
	/* U+59D5 */	U2E_NODEST_COLX,
	/* U+59D6 */	U2E_NODEST_COLX,
	/* U+59D7 */	U2E_NODEST_COLX,
	/* U+59D8 */	U2E_NODEST_COLX,
	/* U+59D9 */	JISX0208(0xd5ac),
	/* U+59DA */	JISX0208(0xd5ad),
	/* U+59DB */	U2E_NODEST_COLX,
	/* U+59DC */	JISX0208(0xd5aa),
	/* U+59DD */	IFX0213(JISX0213_1(0xaff0),	JISX0212(0xb940)),
	/* U+59DE */	IFX0213(JISX0213_2(0xa550),	JISX0212(0xb941)),
	/* U+59DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb942)),
	/* U+59E0 */	U2E_NODEST_COLX,
	/* U+59E1 */	U2E_NODEST_COLX,
	/* U+59E2 */	U2E_NODEST_COLX,
	/* U+59E3 */	IFX0213(JISX0213_2(0xa551),	JISX0212(0xb943)),
	/* U+59E4 */	IFX0213(JISX0213_2(0xa552),	JISX0212(0xb944)),
	/* U+59E5 */	JISX0208(0xb1b8),
	/* U+59E6 */	JISX0208(0xb4af),
	/* U+59E7 */	IFX0213(JISX0213_2(0xa553),	JISX0212(0xb945)),
	/* U+59E8 */	JISX0208(0xd5a9),
	/* U+59E9 */	U2E_NODEST_COLX,
	/* U+59EA */	JISX0208(0xccc5),
	/* U+59EB */	JISX0208(0xc9b1),
	/* U+59EC */	U2E_NODEST_COLX,
	/* U+59ED */	U2E_NODEST_COLX,
	/* U+59EE */	IFX0213(JISX0213_2(0xa554),	JISX0212(0xb946)),
	/* U+59EF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb947)),
	/* U+59F0 */	U2E_NODEST_COLX,
	/* U+59F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb948)),
	/* U+59F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb949)),
	/* U+59F3 */	U2E_NODEST_COLX,
	/* U+59F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb94a)),
	/* U+59F5 */	U2E_NODEST_COLX,
	/* U+59F6 */	JISX0208(0xb0a8),
	/* U+59F7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb94b)),
	/* U+59F8 */	IFX0213(JISX0213_1(0xfefa),	U2E_NODEST_COLX),
	/* U+59F9 */	U2E_NODEST_COLX,
	/* U+59FA */	U2E_NODEST_COLX,
	/* U+59FB */	JISX0208(0xb0f9),
	/* U+59FC */	U2E_NODEST_COLX,
	/* U+59FD */	U2E_NODEST_COLX,
	/* U+59FE */	U2E_NODEST_COLX,
	/* U+59FF */	JISX0208(0xbbd1),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_5A[] = {
	/* U+5A00 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb94c)),
	/* U+5A01 */	JISX0208(0xb0d2),
	/* U+5A02 */	U2E_NODEST_COLX,
	/* U+5A03 */	JISX0208(0xb0a3),
	/* U+5A04 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb94d)),
	/* U+5A05 */	U2E_NODEST_COLX,
	/* U+5A06 */	U2E_NODEST_COLX,
	/* U+5A07 */	U2E_NODEST_COLX,
	/* U+5A08 */	U2E_NODEST_COLX,
	/* U+5A09 */	JISX0208(0xd5b2),
	/* U+5A0A */	U2E_NODEST_COLX,
	/* U+5A0B */	U2E_NODEST_COLX,
	/* U+5A0C */	IFX0213(JISX0213_2(0xa558),	JISX0212(0xb94e)),
	/* U+5A0D */	IFX0213(JISX0213_2(0xa559),	JISX0212(0xb94f)),
	/* U+5A0E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb950)),
	/* U+5A0F */	U2E_NODEST_COLX,
	/* U+5A10 */	U2E_NODEST_COLX,
	/* U+5A11 */	JISX0208(0xd5b0),
	/* U+5A12 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb951)),
	/* U+5A13 */	IFX0213(JISX0213_1(0xaff1),	JISX0212(0xb952)),
	/* U+5A14 */	U2E_NODEST_COLX,
	/* U+5A15 */	U2E_NODEST_COLX,
	/* U+5A16 */	U2E_NODEST_COLX,
	/* U+5A17 */	IFX0213(JISX0213_2(0xa55a),	U2E_NODEST_COLX),
	/* U+5A18 */	JISX0208(0xccbc),
	/* U+5A19 */	U2E_NODEST_COLX,
	/* U+5A1A */	JISX0208(0xd5b3),
	/* U+5A1B */	U2E_NODEST_COLX,
	/* U+5A1C */	JISX0208(0xd5b1),
	/* U+5A1D */	U2E_NODEST_COLX,
	/* U+5A1E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb953)),
	/* U+5A1F */	JISX0208(0xd5af),
	/* U+5A20 */	JISX0208(0xbfb1),
	/* U+5A21 */	U2E_NODEST_COLX,
	/* U+5A22 */	U2E_NODEST_COLX,
	/* U+5A23 */	IFX0213(JISX0213_1(0xaff2),	JISX0212(0xb954)),
	/* U+5A24 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb955)),
	/* U+5A25 */	JISX0208(0xd5ae),
	/* U+5A26 */	U2E_NODEST_COLX,
	/* U+5A27 */	IFX0213(JISX0213_2(0xa55b),	JISX0212(0xb956)),
	/* U+5A28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb957)),
	/* U+5A29 */	JISX0208(0xcada),
	/* U+5A2A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb958)),
	/* U+5A2B */	U2E_NODEST_COLX,
	/* U+5A2C */	U2E_NODEST_COLX,
	/* U+5A2D */	IFX0213(JISX0213_2(0xa55c),	JISX0212(0xb959)),
	/* U+5A2E */	U2E_NODEST_COLX,
	/* U+5A2F */	JISX0208(0xb8e4),
	/* U+5A30 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb95a)),
	/* U+5A31 */	U2E_NODEST_COLX,
	/* U+5A32 */	U2E_NODEST_COLX,
	/* U+5A33 */	U2E_NODEST_COLX,
	/* U+5A34 */	U2E_NODEST_COLX,
	/* U+5A35 */	JISX0208(0xd5b7),
	/* U+5A36 */	JISX0208(0xd5b8),
	/* U+5A37 */	U2E_NODEST_COLX,
	/* U+5A38 */	U2E_NODEST_COLX,
	/* U+5A39 */	U2E_NODEST_COLX,
	/* U+5A3A */	U2E_NODEST_COLX,
	/* U+5A3B */	U2E_NODEST_COLX,
	/* U+5A3C */	JISX0208(0xbeab),
	/* U+5A3D */	U2E_NODEST_COLX,
	/* U+5A3E */	U2E_NODEST_COLX,
	/* U+5A3F */	U2E_NODEST_COLX,
	/* U+5A40 */	JISX0208(0xd5b4),
	/* U+5A41 */	JISX0208(0xcfac),
	/* U+5A42 */	U2E_NODEST_COLX,
	/* U+5A43 */	U2E_NODEST_COLX,
	/* U+5A44 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb95b)),
	/* U+5A45 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb95c)),
	/* U+5A46 */	JISX0208(0xc7cc),
	/* U+5A47 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb95d)),
	/* U+5A48 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb95e)),
	/* U+5A49 */	JISX0208(0xd5b6),
	/* U+5A4A */	U2E_NODEST_COLX,
	/* U+5A4B */	U2E_NODEST_COLX,
	/* U+5A4C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb95f)),
	/* U+5A4D */	U2E_NODEST_COLX,
	/* U+5A4E */	U2E_NODEST_COLX,
	/* U+5A4F */	U2E_NODEST_COLX,
	/* U+5A50 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb960)),
	/* U+5A51 */	U2E_NODEST_COLX,
	/* U+5A52 */	U2E_NODEST_COLX,
	/* U+5A53 */	U2E_NODEST_COLX,
	/* U+5A54 */	U2E_NODEST_COLX,
	/* U+5A55 */	IFX0213(JISX0213_2(0xa55d),	JISX0212(0xb961)),
	/* U+5A56 */	U2E_NODEST_COLX,
	/* U+5A57 */	U2E_NODEST_COLX,
	/* U+5A58 */	U2E_NODEST_COLX,
	/* U+5A59 */	U2E_NODEST_COLX,
	/* U+5A5A */	JISX0208(0xbaa7),
	/* U+5A5B */	U2E_NODEST_COLX,
	/* U+5A5C */	U2E_NODEST_COLX,
	/* U+5A5D */	U2E_NODEST_COLX,
	/* U+5A5E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb962)),
	/* U+5A5F */	U2E_NODEST_COLX,
	/* U+5A60 */	U2E_NODEST_COLX,
	/* U+5A61 */	U2E_NODEST_COLX,
	/* U+5A62 */	JISX0208(0xd5b9),
	/* U+5A63 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb963)),
	/* U+5A64 */	U2E_NODEST_COLX,
	/* U+5A65 */	IFX0213(JISX0213_2(0xa55e),	JISX0212(0xb964)),
	/* U+5A66 */	JISX0208(0xc9d8),
	/* U+5A67 */	IFX0213(JISX0213_1(0xaff3),	JISX0212(0xb965)),
	/* U+5A68 */	U2E_NODEST_COLX,
	/* U+5A69 */	U2E_NODEST_COLX,
	/* U+5A6A */	JISX0208(0xd5ba),
	/* U+5A6B */	U2E_NODEST_COLX,
	/* U+5A6C */	JISX0208(0xd5b5),
	/* U+5A6D */	IFX0213(JISX0213_1(0xaff4),	JISX0212(0xb966)),
	/* U+5A6E */	U2E_NODEST_COLX,
	/* U+5A6F */	U2E_NODEST_COLX,
	/* U+5A70 */	U2E_NODEST_COLX,
	/* U+5A71 */	U2E_NODEST_COLX,
	/* U+5A72 */	U2E_NODEST_COLX,
	/* U+5A73 */	U2E_NODEST_COLX,
	/* U+5A74 */	U2E_NODEST_COLX,
	/* U+5A75 */	U2E_NODEST_COLX,
	/* U+5A76 */	U2E_NODEST_COLX,
	/* U+5A77 */	IFX0213(JISX0213_1(0xaff5),	JISX0212(0xb967)),
	/* U+5A78 */	U2E_NODEST_COLX,
	/* U+5A79 */	U2E_NODEST_COLX,
	/* U+5A7A */	IFX0213(JISX0213_2(0xa55f),	JISX0212(0xb968)),
	/* U+5A7B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb969)),
	/* U+5A7C */	U2E_NODEST_COLX,
	/* U+5A7D */	U2E_NODEST_COLX,
	/* U+5A7E */	IFX0213(JISX0213_1(0xaff6),	JISX0212(0xb96a)),
	/* U+5A7F */	JISX0208(0xccbb),
	/* U+5A80 */	U2E_NODEST_COLX,
	/* U+5A81 */	U2E_NODEST_COLX,
	/* U+5A82 */	U2E_NODEST_COLX,
	/* U+5A83 */	U2E_NODEST_COLX,
	/* U+5A84 */	IFX0213(JISX0213_1(0xaff7),	U2E_NODEST_COLX),
	/* U+5A85 */	U2E_NODEST_COLX,
	/* U+5A86 */	U2E_NODEST_COLX,
	/* U+5A87 */	U2E_NODEST_COLX,
	/* U+5A88 */	U2E_NODEST_COLX,
	/* U+5A89 */	U2E_NODEST_COLX,
	/* U+5A8A */	U2E_NODEST_COLX,
	/* U+5A8B */	IFX0213(JISX0213_2(0xa560),	JISX0212(0xb96b)),
	/* U+5A8C */	U2E_NODEST_COLX,
	/* U+5A8D */	U2E_NODEST_COLX,
	/* U+5A8E */	U2E_NODEST_COLX,
	/* U+5A8F */	U2E_NODEST_COLX,
	/* U+5A90 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb96c)),
	/* U+5A91 */	U2E_NODEST_COLX,
	/* U+5A92 */	JISX0208(0xc7de),
	/* U+5A93 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb96d)),
	/* U+5A94 */	U2E_NODEST_COLX,
	/* U+5A95 */	U2E_NODEST_COLX,
	/* U+5A96 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb96e)),
	/* U+5A97 */	U2E_NODEST_COLX,
	/* U+5A98 */	U2E_NODEST_COLX,
	/* U+5A99 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb96f)),
	/* U+5A9A */	JISX0208(0xd5bb),
	/* U+5A9B */	JISX0208(0xc9b2),
	/* U+5A9C */	IFX0213(JISX0213_2(0xa561),	JISX0212(0xb970)),
	/* U+5A9D */	U2E_NODEST_COLX,
	/* U+5A9E */	IFX0213(JISX0213_1(0xaff8),	JISX0212(0xb971)),
	/* U+5A9F */	IFX0213(JISX0213_2(0xa562),	JISX0212(0xb972)),
	/* U+5AA0 */	IFX0213(JISX0213_2(0xa563),	JISX0212(0xb973)),
	/* U+5AA1 */	U2E_NODEST_COLX,
	/* U+5AA2 */	IFX0213(JISX0213_2(0xa564),	JISX0212(0xb974)),
	/* U+5AA3 */	U2E_NODEST_COLX,
	/* U+5AA4 */	U2E_NODEST_COLX,
	/* U+5AA5 */	U2E_NODEST_COLX,
	/* U+5AA6 */	U2E_NODEST_COLX,
	/* U+5AA7 */	IFX0213(JISX0213_1(0xaff9),	JISX0212(0xb975)),
	/* U+5AA8 */	U2E_NODEST_COLX,
	/* U+5AA9 */	U2E_NODEST_COLX,
	/* U+5AAA */	U2E_NODEST_COLX,
	/* U+5AAB */	U2E_NODEST_COLX,
	/* U+5AAC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb976)),
	/* U+5AAD */	U2E_NODEST_COLX,
	/* U+5AAE */	U2E_NODEST_COLX,
	/* U+5AAF */	U2E_NODEST_COLX,
	/* U+5AB0 */	U2E_NODEST_COLX,
	/* U+5AB1 */	IFX0213(JISX0213_2(0xa565),	JISX0212(0xb977)),
	/* U+5AB2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb978)),
	/* U+5AB3 */	IFX0213(JISX0213_2(0xa566),	JISX0212(0xb979)),
	/* U+5AB4 */	U2E_NODEST_COLX,
	/* U+5AB5 */	IFX0213(JISX0213_2(0xa567),	JISX0212(0xb97a)),
	/* U+5AB6 */	U2E_NODEST_COLX,
	/* U+5AB7 */	U2E_NODEST_COLX,
	/* U+5AB8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb97b)),
	/* U+5AB9 */	U2E_NODEST_COLX,
	/* U+5ABA */	IFX0213(JISX0213_2(0xa568),	JISX0212(0xb97c)),
	/* U+5ABB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xb97d)),
	/* U+5ABC */	JISX0208(0xd5bc),
	/* U+5ABD */	JISX0208(0xd5c0),
	/* U+5ABE */	JISX0208(0xd5bd),
	/* U+5ABF */	IFX0213(JISX0213_2(0xa569),	JISX0212(0xb97e)),
	/* U+5AC0 */	U2E_NODEST_COLX,
	/* U+5AC1 */	JISX0208(0xb2c7),
	/* U+5AC2 */	JISX0208(0xd5bf),
	/* U+5AC3 */	U2E_NODEST_COLX,
	/* U+5AC4 */	IFX0213(JISX0213_1(0xaffa),	JISX0212(0xba21)),
	/* U+5AC5 */	U2E_NODEST_COLX,
	/* U+5AC6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba22)),
	/* U+5AC7 */	U2E_NODEST_COLX,
	/* U+5AC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba23)),
	/* U+5AC9 */	JISX0208(0xbcbb),
	/* U+5ACA */	U2E_NODEST_COLX,
	/* U+5ACB */	JISX0208(0xd5be),
	/* U+5ACC */	JISX0208(0xb7f9),
	/* U+5ACD */	U2E_NODEST_COLX,
	/* U+5ACE */	U2E_NODEST_COLX,
	/* U+5ACF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba24)),
	/* U+5AD0 */	JISX0208(0xd5cc),
	/* U+5AD1 */	U2E_NODEST_COLX,
	/* U+5AD2 */	U2E_NODEST_COLX,
	/* U+5AD3 */	U2E_NODEST_COLX,
	/* U+5AD4 */	U2E_NODEST_COLX,
	/* U+5AD5 */	U2E_NODEST_COLX,
	/* U+5AD6 */	JISX0208(0xd5c5),
	/* U+5AD7 */	JISX0208(0xd5c2),
	/* U+5AD8 */	U2E_NODEST_COLX,
	/* U+5AD9 */	U2E_NODEST_COLX,
	/* U+5ADA */	IFX0213(JISX0213_2(0xa56a),	JISX0212(0xba25)),
	/* U+5ADB */	U2E_NODEST_COLX,
	/* U+5ADC */	IFX0213(JISX0213_2(0xa56b),	JISX0212(0xba26)),
	/* U+5ADD */	U2E_NODEST_COLX,
	/* U+5ADE */	U2E_NODEST_COLX,
	/* U+5ADF */	U2E_NODEST_COLX,
	/* U+5AE0 */	IFX0213(JISX0213_2(0xa56c),	JISX0212(0xba27)),
	/* U+5AE1 */	JISX0208(0xc3e4),
	/* U+5AE2 */	U2E_NODEST_COLX,
	/* U+5AE3 */	JISX0208(0xd5c1),
	/* U+5AE4 */	U2E_NODEST_COLX,
	/* U+5AE5 */	IFX0213(JISX0213_2(0xa56d),	JISX0212(0xba28)),
	/* U+5AE6 */	JISX0208(0xd5c3),
	/* U+5AE7 */	U2E_NODEST_COLX,
	/* U+5AE8 */	U2E_NODEST_COLX,
	/* U+5AE9 */	JISX0208(0xd5c4),
	/* U+5AEA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba29)),
	/* U+5AEB */	U2E_NODEST_COLX,
	/* U+5AEC */	U2E_NODEST_COLX,
	/* U+5AED */	U2E_NODEST_COLX,
	/* U+5AEE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba2a)),
	/* U+5AEF */	U2E_NODEST_COLX,
	/* U+5AF0 */	IFX0213(JISX0213_2(0xa56e),	U2E_NODEST_COLX),
	/* U+5AF1 */	U2E_NODEST_COLX,
	/* U+5AF2 */	U2E_NODEST_COLX,
	/* U+5AF3 */	U2E_NODEST_COLX,
	/* U+5AF4 */	U2E_NODEST_COLX,
	/* U+5AF5 */	IFX0213(JISX0213_2(0xa570),	JISX0212(0xba2b)),
	/* U+5AF6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba2c)),
	/* U+5AF7 */	U2E_NODEST_COLX,
	/* U+5AF8 */	U2E_NODEST_COLX,
	/* U+5AF9 */	U2E_NODEST_COLX,
	/* U+5AFA */	JISX0208(0xd5c6),
	/* U+5AFB */	JISX0208(0xd5c7),
	/* U+5AFC */	U2E_NODEST_COLX,
	/* U+5AFD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba2d)),
	/* U+5AFE */	IFX0213(JISX0213_2(0xa56f),	U2E_NODEST_COLX),
	/* U+5AFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_5B[] = {
	/* U+5B00 */	IFX0213(JISX0213_2(0xa571),	JISX0212(0xba2e)),
	/* U+5B01 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba2f)),
	/* U+5B02 */	U2E_NODEST_COLX,
	/* U+5B03 */	U2E_NODEST_COLX,
	/* U+5B04 */	U2E_NODEST_COLX,
	/* U+5B05 */	U2E_NODEST_COLX,
	/* U+5B06 */	U2E_NODEST_COLX,
	/* U+5B07 */	U2E_NODEST_COLX,
	/* U+5B08 */	IFX0213(JISX0213_2(0xa572),	JISX0212(0xba30)),
	/* U+5B09 */	JISX0208(0xb4f2),
	/* U+5B0A */	U2E_NODEST_COLX,
	/* U+5B0B */	JISX0208(0xd5c9),
	/* U+5B0C */	JISX0208(0xd5c8),
	/* U+5B0D */	U2E_NODEST_COLX,
	/* U+5B0E */	U2E_NODEST_COLX,
	/* U+5B0F */	U2E_NODEST_COLX,
	/* U+5B10 */	U2E_NODEST_COLX,
	/* U+5B11 */	U2E_NODEST_COLX,
	/* U+5B12 */	U2E_NODEST_COLX,
	/* U+5B13 */	U2E_NODEST_COLX,
	/* U+5B14 */	U2E_NODEST_COLX,
	/* U+5B15 */	U2E_NODEST_COLX,
	/* U+5B16 */	JISX0208(0xd5ca),
	/* U+5B17 */	IFX0213(JISX0213_2(0xa573),	JISX0212(0xba31)),
	/* U+5B18 */	U2E_NODEST_COLX,
	/* U+5B19 */	IFX0213(JISX0213_1(0xaffc),	JISX0212(0xba33)),
	/* U+5B1A */	U2E_NODEST_COLX,
	/* U+5B1B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba34)),
	/* U+5B1C */	U2E_NODEST_COLX,
	/* U+5B1D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba35)),
	/* U+5B1E */	U2E_NODEST_COLX,
	/* U+5B1F */	U2E_NODEST_COLX,
	/* U+5B20 */	U2E_NODEST_COLX,
	/* U+5B21 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba36)),
	/* U+5B22 */	JISX0208(0xbeee),
	/* U+5B23 */	U2E_NODEST_COLX,
	/* U+5B24 */	U2E_NODEST_COLX,
	/* U+5B25 */	IFX0213(JISX0213_1(0xaffd),	JISX0212(0xba37)),
	/* U+5B26 */	U2E_NODEST_COLX,
	/* U+5B27 */	U2E_NODEST_COLX,
	/* U+5B28 */	U2E_NODEST_COLX,
	/* U+5B29 */	U2E_NODEST_COLX,
	/* U+5B2A */	JISX0208(0xd5cd),
	/* U+5B2B */	U2E_NODEST_COLX,
	/* U+5B2C */	JISX0208(0xc4dc),
	/* U+5B2D */	IFX0213(JISX0213_2(0xa575),	JISX0212(0xba38)),
	/* U+5B2E */	U2E_NODEST_COLX,
	/* U+5B2F */	U2E_NODEST_COLX,
	/* U+5B30 */	JISX0208(0xb1c5),
	/* U+5B31 */	U2E_NODEST_COLX,
	/* U+5B32 */	JISX0208(0xd5cb),
	/* U+5B33 */	U2E_NODEST_COLX,
	/* U+5B34 */	IFX0213(JISX0213_2(0xa574),	JISX0212(0xba32)),
	/* U+5B35 */	U2E_NODEST_COLX,
	/* U+5B36 */	JISX0208(0xd5ce),
	/* U+5B37 */	U2E_NODEST_COLX,
	/* U+5B38 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba39)),
	/* U+5B39 */	U2E_NODEST_COLX,
	/* U+5B3A */	U2E_NODEST_COLX,
	/* U+5B3B */	U2E_NODEST_COLX,
	/* U+5B3C */	U2E_NODEST_COLX,
	/* U+5B3D */	U2E_NODEST_COLX,
	/* U+5B3E */	JISX0208(0xd5cf),
	/* U+5B3F */	U2E_NODEST_COLX,
	/* U+5B40 */	JISX0208(0xd5d2),
	/* U+5B41 */	IFX0213(JISX0213_1(0xcfd5),	JISX0212(0xba3a)),
	/* U+5B42 */	U2E_NODEST_COLX,
	/* U+5B43 */	JISX0208(0xd5d0),
	/* U+5B44 */	U2E_NODEST_COLX,
	/* U+5B45 */	JISX0208(0xd5d1),
	/* U+5B46 */	U2E_NODEST_COLX,
	/* U+5B47 */	U2E_NODEST_COLX,
	/* U+5B48 */	U2E_NODEST_COLX,
	/* U+5B49 */	U2E_NODEST_COLX,
	/* U+5B4A */	U2E_NODEST_COLX,
	/* U+5B4B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba3b)),
	/* U+5B4C */	IFX0213(JISX0213_2(0xa576),	JISX0212(0xba3c)),
	/* U+5B4D */	U2E_NODEST_COLX,
	/* U+5B4E */	U2E_NODEST_COLX,
	/* U+5B4F */	U2E_NODEST_COLX,
	/* U+5B50 */	JISX0208(0xbbd2),
	/* U+5B51 */	JISX0208(0xd5d3),
	/* U+5B52 */	IFX0213(JISX0213_2(0xa577),	JISX0212(0xba3d)),
	/* U+5B53 */	U2E_NODEST_COLX,
	/* U+5B54 */	JISX0208(0xb9a6),
	/* U+5B55 */	JISX0208(0xd5d4),
	/* U+5B56 */	IFX0213(JISX0213_1(0xcfd6),	JISX0212(0xba3e)),
	/* U+5B57 */	JISX0208(0xbbfa),
	/* U+5B58 */	JISX0208(0xc2b8),
	/* U+5B59 */	U2E_NODEST_COLX,
	/* U+5B5A */	JISX0208(0xd5d5),
	/* U+5B5B */	JISX0208(0xd5d6),
	/* U+5B5C */	JISX0208(0xbbda),
	/* U+5B5D */	JISX0208(0xb9a7),
	/* U+5B5E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba3f)),
	/* U+5B5F */	JISX0208(0xccd2),
	/* U+5B60 */	U2E_NODEST_COLX,
	/* U+5B61 */	U2E_NODEST_COLX,
	/* U+5B62 */	U2E_NODEST_COLX,
	/* U+5B63 */	JISX0208(0xb5a8),
	/* U+5B64 */	JISX0208(0xb8c9),
	/* U+5B65 */	JISX0208(0xd5d7),
	/* U+5B66 */	JISX0208(0xb3d8),
	/* U+5B67 */	U2E_NODEST_COLX,
	/* U+5B68 */	IFX0213(JISX0213_2(0xa578),	JISX0212(0xba40)),
	/* U+5B69 */	JISX0208(0xd5d8),
	/* U+5B6A */	U2E_NODEST_COLX,
	/* U+5B6B */	JISX0208(0xc2b9),
	/* U+5B6C */	U2E_NODEST_COLX,
	/* U+5B6D */	U2E_NODEST_COLX,
	/* U+5B6E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba41)),
	/* U+5B6F */	IFX0213(JISX0213_2(0xa579),	JISX0212(0xba42)),
	/* U+5B70 */	JISX0208(0xd5d9),
	/* U+5B71 */	JISX0208(0xd6a3),
	/* U+5B72 */	U2E_NODEST_COLX,
	/* U+5B73 */	JISX0208(0xd5da),
	/* U+5B74 */	U2E_NODEST_COLX,
	/* U+5B75 */	JISX0208(0xd5db),
	/* U+5B76 */	U2E_NODEST_COLX,
	/* U+5B77 */	U2E_NODEST_COLX,
	/* U+5B78 */	JISX0208(0xd5dc),
	/* U+5B79 */	U2E_NODEST_COLX,
	/* U+5B7A */	JISX0208(0xd5de),
	/* U+5B7B */	U2E_NODEST_COLX,
	/* U+5B7C */	IFX0213(JISX0213_2(0xa57a),	JISX0212(0xba43)),
	/* U+5B7D */	IFX0213(JISX0213_1(0xcfd7),	JISX0212(0xba44)),
	/* U+5B7E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba45)),
	/* U+5B7F */	IFX0213(JISX0213_2(0xa57b),	JISX0212(0xba46)),
	/* U+5B80 */	JISX0208(0xd5df),
	/* U+5B81 */	IFX0213(JISX0213_2(0xa57c),	JISX0212(0xba47)),
	/* U+5B82 */	U2E_NODEST_COLX,
	/* U+5B83 */	JISX0208(0xd5e0),
	/* U+5B84 */	IFX0213(JISX0213_2(0xa57d),	JISX0212(0xba48)),
	/* U+5B85 */	JISX0208(0xc2f0),
	/* U+5B86 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba49)),
	/* U+5B87 */	JISX0208(0xb1a7),
	/* U+5B88 */	JISX0208(0xbce9),
	/* U+5B89 */	JISX0208(0xb0c2),
	/* U+5B8A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba4a)),
	/* U+5B8B */	JISX0208(0xc1d7),
	/* U+5B8C */	JISX0208(0xb4b0),
	/* U+5B8D */	JISX0208(0xbcb5),
	/* U+5B8E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba4b)),
	/* U+5B8F */	JISX0208(0xb9a8),
	/* U+5B90 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba4c)),
	/* U+5B91 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba4d)),
	/* U+5B92 */	U2E_NODEST_COLX,
	/* U+5B93 */	IFX0213(JISX0213_1(0xcfd8),	JISX0212(0xba4e)),
	/* U+5B94 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba4f)),
	/* U+5B95 */	JISX0208(0xc5e6),
	/* U+5B96 */	IFX0213(JISX0213_2(0xa821),	JISX0212(0xba50)),
	/* U+5B97 */	JISX0208(0xbda1),
	/* U+5B98 */	JISX0208(0xb4b1),
	/* U+5B99 */	JISX0208(0xc3e8),
	/* U+5B9A */	JISX0208(0xc4ea),
	/* U+5B9B */	JISX0208(0xb0b8),
	/* U+5B9C */	JISX0208(0xb5b9),
	/* U+5B9D */	JISX0208(0xcaf5),
	/* U+5B9E */	U2E_NODEST_COLX,
	/* U+5B9F */	JISX0208(0xbcc2),
	/* U+5BA0 */	U2E_NODEST_COLX,
	/* U+5BA1 */	U2E_NODEST_COLX,
	/* U+5BA2 */	JISX0208(0xb5d2),
	/* U+5BA3 */	JISX0208(0xc0eb),
	/* U+5BA4 */	JISX0208(0xbcbc),
	/* U+5BA5 */	JISX0208(0xcda8),
	/* U+5BA6 */	JISX0208(0xd5e1),
	/* U+5BA7 */	U2E_NODEST_COLX,
	/* U+5BA8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba51)),
	/* U+5BA9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba52)),
	/* U+5BAA */	U2E_NODEST_COLX,
	/* U+5BAB */	U2E_NODEST_COLX,
	/* U+5BAC */	IFX0213(JISX0213_2(0xa822),	JISX0212(0xba53)),
	/* U+5BAD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba54)),
	/* U+5BAE */	JISX0208(0xb5dc),
	/* U+5BAF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba55)),
	/* U+5BB0 */	JISX0208(0xbacb),
	/* U+5BB1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba56)),
	/* U+5BB2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba57)),
	/* U+5BB3 */	JISX0208(0xb3b2),
	/* U+5BB4 */	JISX0208(0xb1e3),
	/* U+5BB5 */	JISX0208(0xbeac),
	/* U+5BB6 */	JISX0208(0xb2c8),
	/* U+5BB7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba58)),
	/* U+5BB8 */	JISX0208(0xd5e2),
	/* U+5BB9 */	JISX0208(0xcdc6),
	/* U+5BBA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba59)),
	/* U+5BBB */	U2E_NODEST_COLX,
	/* U+5BBC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba5a)),
	/* U+5BBD */	U2E_NODEST_COLX,
	/* U+5BBE */	U2E_NODEST_COLX,
	/* U+5BBF */	JISX0208(0xbdc9),
	/* U+5BC0 */	IFX0213(JISX0213_2(0xa824),	JISX0212(0xba5b)),
	/* U+5BC1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba5c)),
	/* U+5BC2 */	JISX0208(0xbce4),
	/* U+5BC3 */	JISX0208(0xd5e3),
	/* U+5BC4 */	JISX0208(0xb4f3),
	/* U+5BC5 */	JISX0208(0xc6d2),
	/* U+5BC6 */	JISX0208(0xcca9),
	/* U+5BC7 */	JISX0208(0xd5e4),
	/* U+5BC8 */	U2E_NODEST_COLX,
	/* U+5BC9 */	JISX0208(0xd5e5),
	/* U+5BCA */	U2E_NODEST_COLX,
	/* U+5BCB */	U2E_NODEST_COLX,
	/* U+5BCC */	JISX0208(0xc9d9),
	/* U+5BCD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba5d)),
	/* U+5BCE */	IFX0213(JISX0213_2(0xa826),	U2E_NODEST_COLX),
	/* U+5BCF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba5e)),
	/* U+5BD0 */	JISX0208(0xd5e7),
	/* U+5BD1 */	U2E_NODEST_COLX,
	/* U+5BD2 */	JISX0208(0xb4a8),
	/* U+5BD3 */	JISX0208(0xb6f7),
	/* U+5BD4 */	JISX0208(0xd5e6),
	/* U+5BD5 */	U2E_NODEST_COLX,
	/* U+5BD6 */	IFX0213(JISX0213_2(0xa827),	JISX0212(0xba5f)),
	/* U+5BD7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba60)),
	/* U+5BD8 */	IFX0213(JISX0213_1(0xcfd9),	JISX0212(0xba61)),
	/* U+5BD9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba62)),
	/* U+5BDA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba63)),
	/* U+5BDB */	JISX0208(0xb4b2),
	/* U+5BDC */	U2E_NODEST_COLX,
	/* U+5BDD */	JISX0208(0xbfb2),
	/* U+5BDE */	JISX0208(0xd5eb),
	/* U+5BDF */	JISX0208(0xbba1),
	/* U+5BE0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba64)),
	/* U+5BE1 */	JISX0208(0xb2c9),
	/* U+5BE2 */	JISX0208(0xd5ea),
	/* U+5BE3 */	U2E_NODEST_COLX,
	/* U+5BE4 */	JISX0208(0xd5e8),
	/* U+5BE5 */	JISX0208(0xd5ec),
	/* U+5BE6 */	JISX0208(0xd5e9),
	/* U+5BE7 */	JISX0208(0xc7ab),
	/* U+5BE8 */	JISX0208(0xdccd),
	/* U+5BE9 */	JISX0208(0xbfb3),
	/* U+5BEA */	U2E_NODEST_COLX,
	/* U+5BEB */	JISX0208(0xd5ed),
	/* U+5BEC */	IFX0213(JISX0213_1(0xcfda),	IBM(0xf43a)),
	/* U+5BED */	U2E_NODEST_COLX,
	/* U+5BEE */	JISX0208(0xcec0),
	/* U+5BEF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba65)),
	/* U+5BF0 */	JISX0208(0xd5ee),
	/* U+5BF1 */	IFX0213(JISX0213_2(0xa82a),	JISX0212(0xba66)),
	/* U+5BF2 */	U2E_NODEST_COLX,
	/* U+5BF3 */	JISX0208(0xd5f0),
	/* U+5BF4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba67)),
	/* U+5BF5 */	JISX0208(0xc3fe),
	/* U+5BF6 */	JISX0208(0xd5ef),
	/* U+5BF7 */	U2E_NODEST_COLX,
	/* U+5BF8 */	JISX0208(0xc0a3),
	/* U+5BF9 */	U2E_NODEST_COLX,
	/* U+5BFA */	JISX0208(0xbbfb),
	/* U+5BFB */	U2E_NODEST_COLX,
	/* U+5BFC */	U2E_NODEST_COLX,
	/* U+5BFD */	IFX0213(JISX0213_2(0xa82b),	JISX0212(0xba68)),
	/* U+5BFE */	JISX0208(0xc2d0),
	/* U+5BFF */	JISX0208(0xbcf7),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_5C[] = {
	/* U+5C00 */	U2E_NODEST_COLX,
	/* U+5C01 */	JISX0208(0xc9f5),
	/* U+5C02 */	JISX0208(0xc0ec),
	/* U+5C03 */	IFX0213(JISX0213_2(0xa82d),	U2E_NODEST_COLX),
	/* U+5C04 */	JISX0208(0xbccd),
	/* U+5C05 */	JISX0208(0xd5f1),
	/* U+5C06 */	JISX0208(0xbead),
	/* U+5C07 */	JISX0208(0xd5f2),
	/* U+5C08 */	JISX0208(0xd5f3),
	/* U+5C09 */	JISX0208(0xb0d3),
	/* U+5C0A */	JISX0208(0xc2ba),
	/* U+5C0B */	JISX0208(0xbfd2),
	/* U+5C0C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba69)),
	/* U+5C0D */	JISX0208(0xd5f4),
	/* U+5C0E */	JISX0208(0xc6b3),
	/* U+5C0F */	JISX0208(0xbeae),
	/* U+5C10 */	U2E_NODEST_COLX,
	/* U+5C11 */	JISX0208(0xbeaf),
	/* U+5C12 */	IFX0213(JISX0213_1(0xcfdb),	U2E_NODEST_COLX),
	/* U+5C13 */	JISX0208(0xd5f5),
	/* U+5C14 */	U2E_NODEST_COLX,
	/* U+5C15 */	U2E_NODEST_COLX,
	/* U+5C16 */	JISX0208(0xc0ed),
	/* U+5C17 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba6a)),
	/* U+5C18 */	U2E_NODEST_COLX,
	/* U+5C19 */	U2E_NODEST_COLX,
	/* U+5C1A */	JISX0208(0xbeb0),
	/* U+5C1B */	U2E_NODEST_COLX,
	/* U+5C1C */	U2E_NODEST_COLX,
	/* U+5C1D */	U2E_NODEST_COLX,
	/* U+5C1E */	IFX0213(JISX0213_1(0xcfdc),	JISX0212(0xba6b)),
	/* U+5C1F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba6c)),
	/* U+5C20 */	JISX0208(0xd5f6),
	/* U+5C21 */	U2E_NODEST_COLX,
	/* U+5C22 */	JISX0208(0xd5f7),
	/* U+5C23 */	IFX0213(JISX0213_1(0xcfdd),	JISX0212(0xba6d)),
	/* U+5C24 */	JISX0208(0xcce0),
	/* U+5C25 */	U2E_NODEST_COLX,
	/* U+5C26 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba6e)),
	/* U+5C27 */	U2E_NODEST_COLX,
	/* U+5C28 */	JISX0208(0xd5f8),
	/* U+5C29 */	IFX0213(JISX0213_2(0xa82e),	JISX0212(0xba6f)),
	/* U+5C2A */	U2E_NODEST_COLX,
	/* U+5C2B */	IFX0213(JISX0213_1(0xcfde),	JISX0212(0xba70)),
	/* U+5C2C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba71)),
	/* U+5C2D */	JISX0208(0xb6c6),
	/* U+5C2E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba72)),
	/* U+5C2F */	U2E_NODEST_COLX,
	/* U+5C30 */	IFX0213(JISX0213_2(0xa82f),	JISX0212(0xba73)),
	/* U+5C31 */	JISX0208(0xbda2),
	/* U+5C32 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba74)),
	/* U+5C33 */	U2E_NODEST_COLX,
	/* U+5C34 */	U2E_NODEST_COLX,
	/* U+5C35 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba75)),
	/* U+5C36 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba76)),
	/* U+5C37 */	U2E_NODEST_COLX,
	/* U+5C38 */	JISX0208(0xd5f9),
	/* U+5C39 */	JISX0208(0xd5fa),
	/* U+5C3A */	JISX0208(0xbcdc),
	/* U+5C3B */	JISX0208(0xbfac),
	/* U+5C3C */	JISX0208(0xc6f4),
	/* U+5C3D */	JISX0208(0xbfd4),
	/* U+5C3E */	JISX0208(0xc8f8),
	/* U+5C3F */	JISX0208(0xc7a2),
	/* U+5C40 */	JISX0208(0xb6c9),
	/* U+5C41 */	JISX0208(0xd5fb),
	/* U+5C42 */	U2E_NODEST_COLX,
	/* U+5C43 */	U2E_NODEST_COLX,
	/* U+5C44 */	U2E_NODEST_COLX,
	/* U+5C45 */	JISX0208(0xb5ef),
	/* U+5C46 */	JISX0208(0xd5fc),
	/* U+5C47 */	U2E_NODEST_COLX,
	/* U+5C48 */	JISX0208(0xb6fe),
	/* U+5C49 */	U2E_NODEST_COLX,
	/* U+5C4A */	JISX0208(0xc6cf),
	/* U+5C4B */	JISX0208(0xb2b0),
	/* U+5C4C */	U2E_NODEST_COLX,
	/* U+5C4D */	JISX0208(0xbbd3),
	/* U+5C4E */	JISX0208(0xd5fd),
	/* U+5C4F */	JISX0208(0xd6a2),
	/* U+5C50 */	JISX0208(0xd6a1),
	/* U+5C51 */	JISX0208(0xb6fd),
	/* U+5C52 */	U2E_NODEST_COLX,
	/* U+5C53 */	JISX0208(0xd5fe),
	/* U+5C54 */	U2E_NODEST_COLX,
	/* U+5C55 */	JISX0208(0xc5b8),
	/* U+5C56 */	U2E_NODEST_COLX,
	/* U+5C57 */	U2E_NODEST_COLX,
	/* U+5C58 */	U2E_NODEST_COLX,
	/* U+5C59 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba77)),
	/* U+5C5A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba78)),
	/* U+5C5B */	IFX0213(JISX0213_1(0xfefb),	U2E_NODEST_COLX),
	/* U+5C5C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xba79)),
	/* U+5C5D */	U2E_NODEST_COLX,
	/* U+5C5E */	JISX0208(0xc2b0),
	/* U+5C5F */	IFX0213(JISX0213_2(0xa831),	U2E_NODEST_COLX),
	/* U+5C60 */	JISX0208(0xc5cb),
	/* U+5C61 */	JISX0208(0xbcc8),
	/* U+5C62 */	IFX0213(JISX0213_1(0xcfe0),	JISX0212(0xba7a)),
	/* U+5C63 */	IFX0213(JISX0213_2(0xa832),	JISX0212(0xba7b)),
	/* U+5C64 */	JISX0208(0xc1d8),
	/* U+5C65 */	JISX0208(0xcdfa),
	/* U+5C66 */	U2E_NODEST_COLX,
	/* U+5C67 */	IFX0213(JISX0213_2(0xa833),	JISX0212(0xba7c)),
	/* U+5C68 */	IFX0213(JISX0213_2(0xa834),	JISX0212(0xba7d)),
	/* U+5C69 */	IFX0213(JISX0213_2(0xa835),	JISX0212(0xba7e)),
	/* U+5C6A */	U2E_NODEST_COLX,
	/* U+5C6B */	U2E_NODEST_COLX,
	/* U+5C6C */	JISX0208(0xd6a4),
	/* U+5C6D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb21)),
	/* U+5C6E */	JISX0208(0xd6a5),
	/* U+5C6F */	JISX0208(0xc6d6),
	/* U+5C70 */	IFX0213(JISX0213_2(0xa836),	JISX0212(0xbb22)),
	/* U+5C71 */	JISX0208(0xbbb3),
	/* U+5C72 */	U2E_NODEST_COLX,
	/* U+5C73 */	U2E_NODEST_COLX,
	/* U+5C74 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb23)),
	/* U+5C75 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb24)),
	/* U+5C76 */	JISX0208(0xd6a7),
	/* U+5C77 */	U2E_NODEST_COLX,
	/* U+5C78 */	U2E_NODEST_COLX,
	/* U+5C79 */	JISX0208(0xd6a8),
	/* U+5C7A */	IFX0213(JISX0213_1(0xcfe4),	JISX0212(0xbb25)),
	/* U+5C7B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb26)),
	/* U+5C7C */	IFX0213(JISX0213_2(0xa839),	JISX0212(0xbb27)),
	/* U+5C7D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb28)),
	/* U+5C7E */	U2E_NODEST_COLX,
	/* U+5C7F */	U2E_NODEST_COLX,
	/* U+5C80 */	U2E_NODEST_COLX,
	/* U+5C81 */	U2E_NODEST_COLX,
	/* U+5C82 */	U2E_NODEST_COLX,
	/* U+5C83 */	U2E_NODEST_COLX,
	/* U+5C84 */	U2E_NODEST_COLX,
	/* U+5C85 */	U2E_NODEST_COLX,
	/* U+5C86 */	U2E_NODEST_COLX,
	/* U+5C87 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb29)),
	/* U+5C88 */	IFX0213(JISX0213_2(0xa83c),	JISX0212(0xbb2a)),
	/* U+5C89 */	U2E_NODEST_COLX,
	/* U+5C8A */	IFX0213(JISX0213_2(0xa83d),	JISX0212(0xbb2b)),
	/* U+5C8B */	U2E_NODEST_COLX,
	/* U+5C8C */	JISX0208(0xd6a9),
	/* U+5C8D */	U2E_NODEST_COLX,
	/* U+5C8E */	U2E_NODEST_COLX,
	/* U+5C8F */	IFX0213(JISX0213_1(0xcfe5),	JISX0212(0xbb2c)),
	/* U+5C90 */	JISX0208(0xb4f4),
	/* U+5C91 */	JISX0208(0xd6aa),
	/* U+5C92 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb2d)),
	/* U+5C93 */	U2E_NODEST_COLX,
	/* U+5C94 */	JISX0208(0xd6ab),
	/* U+5C95 */	U2E_NODEST_COLX,
	/* U+5C96 */	U2E_NODEST_COLX,
	/* U+5C97 */	U2E_NODEST_COLX,
	/* U+5C98 */	U2E_NODEST_COLX,
	/* U+5C99 */	U2E_NODEST_COLX,
	/* U+5C9A */	U2E_NODEST_COLX,
	/* U+5C9B */	U2E_NODEST_COLX,
	/* U+5C9C */	U2E_NODEST_COLX,
	/* U+5C9D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb2e)),
	/* U+5C9E */	U2E_NODEST_COLX,
	/* U+5C9F */	IFX0213(JISX0213_1(0xcfe6),	JISX0212(0xbb2f)),
	/* U+5CA0 */	IFX0213(JISX0213_2(0xa841),	JISX0212(0xbb30)),
	/* U+5CA1 */	JISX0208(0xb2ac),
	/* U+5CA2 */	IFX0213(JISX0213_2(0xa842),	JISX0212(0xbb31)),
	/* U+5CA3 */	IFX0213(JISX0213_1(0xcfe7),	JISX0212(0xbb32)),
	/* U+5CA4 */	U2E_NODEST_COLX,
	/* U+5CA5 */	U2E_NODEST_COLX,
	/* U+5CA6 */	IFX0213(JISX0213_2(0xa843),	JISX0212(0xbb33)),
	/* U+5CA7 */	IFX0213(JISX0213_2(0xa844),	U2E_NODEST_COLX),
	/* U+5CA8 */	JISX0208(0xc1bb),
	/* U+5CA9 */	JISX0208(0xb4e4),
	/* U+5CAA */	IFX0213(JISX0213_1(0xcfe8),	JISX0212(0xbb34)),
	/* U+5CAB */	JISX0208(0xd6ad),
	/* U+5CAC */	JISX0208(0xcca8),
	/* U+5CAD */	IFX0213(JISX0213_2(0xa846),	U2E_NODEST_COLX),
	/* U+5CAE */	U2E_NODEST_COLX,
	/* U+5CAF */	U2E_NODEST_COLX,
	/* U+5CB0 */	U2E_NODEST_COLX,
	/* U+5CB1 */	JISX0208(0xc2d2),
	/* U+5CB2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb35)),
	/* U+5CB3 */	JISX0208(0xb3d9),
	/* U+5CB4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb36)),
	/* U+5CB5 */	IFX0213(JISX0213_2(0xa847),	JISX0212(0xbb37)),
	/* U+5CB6 */	JISX0208(0xd6af),
	/* U+5CB7 */	JISX0208(0xd6b1),
	/* U+5CB8 */	JISX0208(0xb4df),
	/* U+5CB9 */	U2E_NODEST_COLX,
	/* U+5CBA */	IFX0213(JISX0213_1(0xcfe9),	JISX0212(0xbb38)),
	/* U+5CBB */	JISX0208(0xd6ae),
	/* U+5CBC */	JISX0208(0xd6b0),
	/* U+5CBD */	U2E_NODEST_COLX,
	/* U+5CBE */	JISX0208(0xd6b3),
	/* U+5CBF */	U2E_NODEST_COLX,
	/* U+5CC0 */	U2E_NODEST_COLX,
	/* U+5CC1 */	U2E_NODEST_COLX,
	/* U+5CC2 */	U2E_NODEST_COLX,
	/* U+5CC3 */	U2E_NODEST_COLX,
	/* U+5CC4 */	U2E_NODEST_COLX,
	/* U+5CC5 */	JISX0208(0xd6b2),
	/* U+5CC6 */	U2E_NODEST_COLX,
	/* U+5CC7 */	JISX0208(0xd6b4),
	/* U+5CC8 */	U2E_NODEST_COLX,
	/* U+5CC9 */	IFX0213(JISX0213_2(0xa849),	JISX0212(0xbb39)),
	/* U+5CCA */	U2E_NODEST_COLX,
	/* U+5CCB */	IFX0213(JISX0213_1(0xcfea),	JISX0212(0xbb3a)),
	/* U+5CCC */	U2E_NODEST_COLX,
	/* U+5CCD */	U2E_NODEST_COLX,
	/* U+5CCE */	U2E_NODEST_COLX,
	/* U+5CCF */	U2E_NODEST_COLX,
	/* U+5CD0 */	IFX0213(JISX0213_1(0xcfeb),	U2E_NODEST_COLX),
	/* U+5CD1 */	U2E_NODEST_COLX,
	/* U+5CD2 */	IFX0213(JISX0213_1(0xcfec),	JISX0212(0xbb3b)),
	/* U+5CD3 */	U2E_NODEST_COLX,
	/* U+5CD4 */	U2E_NODEST_COLX,
	/* U+5CD5 */	U2E_NODEST_COLX,
	/* U+5CD6 */	U2E_NODEST_COLX,
	/* U+5CD7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb3d)),
	/* U+5CD8 */	U2E_NODEST_COLX,
	/* U+5CD9 */	JISX0208(0xd6b5),
	/* U+5CDA */	U2E_NODEST_COLX,
	/* U+5CDB */	U2E_NODEST_COLX,
	/* U+5CDC */	U2E_NODEST_COLX,
	/* U+5CDD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb3c)),
	/* U+5CDE */	U2E_NODEST_COLX,
	/* U+5CDF */	U2E_NODEST_COLX,
	/* U+5CE0 */	JISX0208(0xc6bd),
	/* U+5CE1 */	JISX0208(0xb6ae),
	/* U+5CE2 */	U2E_NODEST_COLX,
	/* U+5CE3 */	U2E_NODEST_COLX,
	/* U+5CE4 */	U2E_NODEST_COLX,
	/* U+5CE5 */	U2E_NODEST_COLX,
	/* U+5CE6 */	U2E_NODEST_COLX,
	/* U+5CE7 */	U2E_NODEST_COLX,
	/* U+5CE8 */	JISX0208(0xb2e5),
	/* U+5CE9 */	JISX0208(0xd6b6),
	/* U+5CEA */	JISX0208(0xd6bb),
	/* U+5CEB */	U2E_NODEST_COLX,
	/* U+5CEC */	U2E_NODEST_COLX,
	/* U+5CED */	JISX0208(0xd6b9),
	/* U+5CEE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb3e)),
	/* U+5CEF */	JISX0208(0xcaf7),
	/* U+5CF0 */	JISX0208(0xcaf6),
	/* U+5CF1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb3f)),
	/* U+5CF2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb40)),
	/* U+5CF3 */	U2E_NODEST_COLX,
	/* U+5CF4 */	IFX0213(JISX0213_1(0xcfed),	JISX0212(0xbb41)),
	/* U+5CF5 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf43b)),
	/* U+5CF6 */	JISX0208(0xc5e7),
	/* U+5CF7 */	U2E_NODEST_COLX,
	/* U+5CF8 */	U2E_NODEST_COLX,
	/* U+5CF9 */	U2E_NODEST_COLX,
	/* U+5CFA */	JISX0208(0xd6b8),
	/* U+5CFB */	JISX0208(0xbdd4),
	/* U+5CFC */	U2E_NODEST_COLX,
	/* U+5CFD */	JISX0208(0xd6b7),
	/* U+5CFE */	U2E_NODEST_COLX,
	/* U+5CFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_5D[] = {
	/* U+5D00 */	U2E_NODEST_COLX,
	/* U+5D01 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb42)),
	/* U+5D02 */	U2E_NODEST_COLX,
	/* U+5D03 */	U2E_NODEST_COLX,
	/* U+5D04 */	U2E_NODEST_COLX,
	/* U+5D05 */	U2E_NODEST_COLX,
	/* U+5D06 */	IFX0213(JISX0213_2(0xa84c),	JISX0212(0xbb43)),
	/* U+5D07 */	JISX0208(0xbff2),
	/* U+5D08 */	U2E_NODEST_COLX,
	/* U+5D09 */	U2E_NODEST_COLX,
	/* U+5D0A */	U2E_NODEST_COLX,
	/* U+5D0B */	JISX0208(0xd6bc),
	/* U+5D0C */	U2E_NODEST_COLX,
	/* U+5D0D */	IFX0213(JISX0213_1(0xcff0),	JISX0212(0xbb44)),
	/* U+5D0E */	JISX0208(0xbaea),
	/* U+5D0F */	U2E_NODEST_COLX,
	/* U+5D10 */	IFX0213(JISX0213_2(0xa84d),	U2E_NODEST_COLX),
	/* U+5D11 */	JISX0208(0xd6c2),
	/* U+5D12 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb45)),
	/* U+5D13 */	U2E_NODEST_COLX,
	/* U+5D14 */	JISX0208(0xd6c3),
	/* U+5D15 */	JISX0208(0xd6bd),
	/* U+5D16 */	JISX0208(0xb3b3),
	/* U+5D17 */	JISX0208(0xd6be),
	/* U+5D18 */	JISX0208(0xd6c7),
	/* U+5D19 */	JISX0208(0xd6c6),
	/* U+5D1A */	JISX0208(0xd6c5),
	/* U+5D1B */	JISX0208(0xd6c1),
	/* U+5D1C */	U2E_NODEST_COLX,
	/* U+5D1D */	IFX0213(JISX0213_2(0xa84f),	U2E_NODEST_COLX),
	/* U+5D1E */	U2E_NODEST_COLX,
	/* U+5D1F */	JISX0208(0xd6c0),
	/* U+5D20 */	IFX0213(JISX0213_2(0xa850),	U2E_NODEST_COLX),
	/* U+5D21 */	U2E_NODEST_COLX,
	/* U+5D22 */	JISX0208(0xd6c4),
	/* U+5D23 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb47)),
	/* U+5D24 */	IFX0213(JISX0213_2(0xa851),	JISX0212(0xbb48)),
	/* U+5D25 */	U2E_NODEST_COLX,
	/* U+5D26 */	IFX0213(JISX0213_2(0xa852),	JISX0212(0xbb49)),
	/* U+5D27 */	IFX0213(JISX0213_1(0xcff1),	JISX0212(0xbb4a)),
	/* U+5D28 */	U2E_NODEST_COLX,
	/* U+5D29 */	JISX0208(0xcaf8),
	/* U+5D2A */	U2E_NODEST_COLX,
	/* U+5D2B */	IFX0213(JISX0213_2(0xa84e),	JISX0212(0xbb46)),
	/* U+5D2C */	U2E_NODEST_COLX,
	/* U+5D2D */	U2E_NODEST_COLX,
	/* U+5D2E */	U2E_NODEST_COLX,
	/* U+5D2F */	U2E_NODEST_COLX,
	/* U+5D30 */	U2E_NODEST_COLX,
	/* U+5D31 */	IFX0213(JISX0213_2(0xa853),	JISX0212(0xbb4b)),
	/* U+5D32 */	U2E_NODEST_COLX,
	/* U+5D33 */	U2E_NODEST_COLX,
	/* U+5D34 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb4c)),
	/* U+5D35 */	U2E_NODEST_COLX,
	/* U+5D36 */	U2E_NODEST_COLX,
	/* U+5D37 */	U2E_NODEST_COLX,
	/* U+5D38 */	U2E_NODEST_COLX,
	/* U+5D39 */	IFX0213(JISX0213_2(0xa854),	JISX0212(0xbb4d)),
	/* U+5D3A */	U2E_NODEST_COLX,
	/* U+5D3B */	U2E_NODEST_COLX,
	/* U+5D3C */	U2E_NODEST_COLX,
	/* U+5D3D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb4e)),
	/* U+5D3E */	U2E_NODEST_COLX,
	/* U+5D3F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb4f)),
	/* U+5D40 */	U2E_NODEST_COLX,
	/* U+5D41 */	U2E_NODEST_COLX,
	/* U+5D42 */	IFX0213(JISX0213_2(0xa855),	JISX0212(0xbb50)),
	/* U+5D43 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb51)),
	/* U+5D44 */	U2E_NODEST_COLX,
	/* U+5D45 */	U2E_NODEST_COLX,
	/* U+5D46 */	IFX0213(JISX0213_1(0xcff3),	JISX0212(0xbb52)),
	/* U+5D47 */	IFX0213(JISX0213_1(0xcff4),	U2E_NODEST_COLX),
	/* U+5D48 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb53)),
	/* U+5D49 */	U2E_NODEST_COLX,
	/* U+5D4A */	IFX0213(JISX0213_1(0xcff6),	JISX0212(0xbb57)),
	/* U+5D4B */	JISX0208(0xd6cb),
	/* U+5D4C */	JISX0208(0xd6c8),
	/* U+5D4D */	U2E_NODEST_COLX,
	/* U+5D4E */	JISX0208(0xd6ca),
	/* U+5D4F */	U2E_NODEST_COLX,
	/* U+5D50 */	JISX0208(0xcdf2),
	/* U+5D51 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb55)),
	/* U+5D52 */	JISX0208(0xd6c9),
	/* U+5D53 */	IFX0213(JISX0213_1(0xcff5),	IBM(0xf43c)),
	/* U+5D54 */	U2E_NODEST_COLX,
	/* U+5D55 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb54)),
	/* U+5D56 */	U2E_NODEST_COLX,
	/* U+5D57 */	U2E_NODEST_COLX,
	/* U+5D58 */	U2E_NODEST_COLX,
	/* U+5D59 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb56)),
	/* U+5D5A */	U2E_NODEST_COLX,
	/* U+5D5B */	U2E_NODEST_COLX,
	/* U+5D5C */	JISX0208(0xd6bf),
	/* U+5D5D */	U2E_NODEST_COLX,
	/* U+5D5E */	U2E_NODEST_COLX,
	/* U+5D5F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb58)),
	/* U+5D60 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb59)),
	/* U+5D61 */	IFX0213(JISX0213_2(0xa857),	JISX0212(0xbb5a)),
	/* U+5D62 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb5b)),
	/* U+5D63 */	U2E_NODEST_COLX,
	/* U+5D64 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb5c)),
	/* U+5D65 */	U2E_NODEST_COLX,
	/* U+5D66 */	U2E_NODEST_COLX,
	/* U+5D67 */	U2E_NODEST_COLX,
	/* U+5D68 */	U2E_NODEST_COLX,
	/* U+5D69 */	JISX0208(0xbff3),
	/* U+5D6A */	IFX0213(JISX0213_2(0xa858),	JISX0212(0xbb5d)),
	/* U+5D6B */	U2E_NODEST_COLX,
	/* U+5D6C */	JISX0208(0xd6cc),
	/* U+5D6D */	IFX0213(JISX0213_1(0xcff7),	JISX0212(0xbb5e)),
	/* U+5D6E */	U2E_NODEST_COLX,
	/* U+5D6F */	JISX0208(0xbab7),
	/* U+5D70 */	IFX0213(JISX0213_2(0xa85a),	JISX0212(0xbb5f)),
	/* U+5D71 */	U2E_NODEST_COLX,
	/* U+5D72 */	U2E_NODEST_COLX,
	/* U+5D73 */	JISX0208(0xd6cd),
	/* U+5D74 */	U2E_NODEST_COLX,
	/* U+5D75 */	U2E_NODEST_COLX,
	/* U+5D76 */	JISX0208(0xd6ce),
	/* U+5D77 */	U2E_NODEST_COLX,
	/* U+5D78 */	U2E_NODEST_COLX,
	/* U+5D79 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb60)),
	/* U+5D7A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb61)),
	/* U+5D7B */	U2E_NODEST_COLX,
	/* U+5D7C */	U2E_NODEST_COLX,
	/* U+5D7D */	U2E_NODEST_COLX,
	/* U+5D7E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb62)),
	/* U+5D7F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb63)),
	/* U+5D80 */	U2E_NODEST_COLX,
	/* U+5D81 */	IFX0213(JISX0213_1(0xcff8),	JISX0212(0xbb64)),
	/* U+5D82 */	JISX0208(0xd6d1),
	/* U+5D83 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb65)),
	/* U+5D84 */	JISX0208(0xd6d0),
	/* U+5D85 */	U2E_NODEST_COLX,
	/* U+5D86 */	U2E_NODEST_COLX,
	/* U+5D87 */	JISX0208(0xd6cf),
	/* U+5D88 */	IFX0213(JISX0213_2(0xa85d),	JISX0212(0xbb66)),
	/* U+5D89 */	U2E_NODEST_COLX,
	/* U+5D8A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb67)),
	/* U+5D8B */	JISX0208(0xc5e8),
	/* U+5D8C */	JISX0208(0xd6ba),
	/* U+5D8D */	U2E_NODEST_COLX,
	/* U+5D8E */	U2E_NODEST_COLX,
	/* U+5D8F */	U2E_NODEST_COLX,
	/* U+5D90 */	JISX0208(0xd6d7),
	/* U+5D91 */	U2E_NODEST_COLX,
	/* U+5D92 */	IFX0213(JISX0213_2(0xa85f),	JISX0212(0xbb68)),
	/* U+5D93 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb69)),
	/* U+5D94 */	IFX0213(JISX0213_2(0xa860),	JISX0212(0xbb6a)),
	/* U+5D95 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb6b)),
	/* U+5D96 */	U2E_NODEST_COLX,
	/* U+5D97 */	IFX0213(JISX0213_2(0xa861),	U2E_NODEST_COLX),
	/* U+5D98 */	U2E_NODEST_COLX,
	/* U+5D99 */	IFX0213(JISX0213_2(0xa862),	JISX0212(0xbb6c)),
	/* U+5D9A */	U2E_NODEST_COLX,
	/* U+5D9B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb6d)),
	/* U+5D9C */	U2E_NODEST_COLX,
	/* U+5D9D */	JISX0208(0xd6d3),
	/* U+5D9E */	U2E_NODEST_COLX,
	/* U+5D9F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb6e)),
	/* U+5DA0 */	IFX0213(JISX0213_1(0xcff9),	JISX0212(0xbb6f)),
	/* U+5DA1 */	U2E_NODEST_COLX,
	/* U+5DA2 */	JISX0208(0xd6d2),
	/* U+5DA3 */	U2E_NODEST_COLX,
	/* U+5DA4 */	IFX0213(JISX0213_1(0xcffa),	U2E_NODEST_COLX),
	/* U+5DA5 */	U2E_NODEST_COLX,
	/* U+5DA6 */	U2E_NODEST_COLX,
	/* U+5DA7 */	IFX0213(JISX0213_1(0xcffb),	JISX0212(0xbb70)),
	/* U+5DA8 */	U2E_NODEST_COLX,
	/* U+5DA9 */	U2E_NODEST_COLX,
	/* U+5DAA */	U2E_NODEST_COLX,
	/* U+5DAB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb71)),
	/* U+5DAC */	JISX0208(0xd6d4),
	/* U+5DAD */	U2E_NODEST_COLX,
	/* U+5DAE */	JISX0208(0xd6d5),
	/* U+5DAF */	U2E_NODEST_COLX,
	/* U+5DB0 */	IFX0213(JISX0213_2(0xa863),	JISX0212(0xbb72)),
	/* U+5DB1 */	U2E_NODEST_COLX,
	/* U+5DB2 */	IFX0213(JISX0213_2(0xa864),	JISX0212(0xe674)),
	/* U+5DB3 */	U2E_NODEST_COLX,
	/* U+5DB4 */	IFX0213(JISX0213_2(0xa865),	JISX0212(0xbb73)),
	/* U+5DB5 */	U2E_NODEST_COLX,
	/* U+5DB6 */	U2E_NODEST_COLX,
	/* U+5DB7 */	JISX0208(0xd6d8),
	/* U+5DB8 */	IFX0213(JISX0213_1(0xcffc),	JISX0212(0xbb74)),
	/* U+5DB9 */	IFX0213(JISX0213_2(0xa867),	JISX0212(0xbb75)),
	/* U+5DBA */	JISX0208(0xcee6),
	/* U+5DBB */	U2E_NODEST_COLX,
	/* U+5DBC */	JISX0208(0xd6d9),
	/* U+5DBD */	JISX0208(0xd6d6),
	/* U+5DBE */	U2E_NODEST_COLX,
	/* U+5DBF */	U2E_NODEST_COLX,
	/* U+5DC0 */	U2E_NODEST_COLX,
	/* U+5DC1 */	U2E_NODEST_COLX,
	/* U+5DC2 */	U2E_NODEST_COLX,
	/* U+5DC3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb76)),
	/* U+5DC4 */	U2E_NODEST_COLX,
	/* U+5DC5 */	U2E_NODEST_COLX,
	/* U+5DC6 */	U2E_NODEST_COLX,
	/* U+5DC7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb77)),
	/* U+5DC8 */	U2E_NODEST_COLX,
	/* U+5DC9 */	JISX0208(0xd6da),
	/* U+5DCA */	U2E_NODEST_COLX,
	/* U+5DCB */	IFX0213(JISX0213_1(0xcffd),	JISX0212(0xbb78)),
	/* U+5DCC */	JISX0208(0xb4e0),
	/* U+5DCD */	JISX0208(0xd6db),
	/* U+5DCE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb7a)),
	/* U+5DCF */	U2E_NODEST_COLX,
	/* U+5DD0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb79)),
	/* U+5DD1 */	IFX0213(JISX0213_2(0xa868),	U2E_NODEST_COLX),
	/* U+5DD2 */	JISX0208(0xd6dd),
	/* U+5DD3 */	JISX0208(0xd6dc),
	/* U+5DD4 */	U2E_NODEST_COLX,
	/* U+5DD5 */	U2E_NODEST_COLX,
	/* U+5DD6 */	JISX0208(0xd6de),
	/* U+5DD7 */	IFX0213(JISX0213_2(0xa869),	U2E_NODEST_COLX),
	/* U+5DD8 */	IFX0213(JISX0213_2(0xa86a),	JISX0212(0xbb7b)),
	/* U+5DD9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbb7c)),
	/* U+5DDA */	U2E_NODEST_COLX,
	/* U+5DDB */	JISX0208(0xd6df),
	/* U+5DDC */	U2E_NODEST_COLX,
	/* U+5DDD */	JISX0208(0xc0ee),
	/* U+5DDE */	JISX0208(0xbda3),
	/* U+5DDF */	U2E_NODEST_COLX,
	/* U+5DE0 */	IFX0213(JISX0213_2(0xa86b),	JISX0212(0xbb7d)),
	/* U+5DE1 */	JISX0208(0xbde4),
	/* U+5DE2 */	IFX0213(JISX0213_1(0xf4a8),	U2E_NODEST_COLX),
	/* U+5DE3 */	JISX0208(0xc1e3),
	/* U+5DE4 */	IFX0213(JISX0213_2(0xa86d),	JISX0212(0xbb7e)),
	/* U+5DE5 */	JISX0208(0xb9a9),
	/* U+5DE6 */	JISX0208(0xbab8),
	/* U+5DE7 */	JISX0208(0xb9aa),
	/* U+5DE8 */	JISX0208(0xb5f0),
	/* U+5DE9 */	IFX0213(JISX0213_2(0xa86e),	JISX0212(0xbc21)),
	/* U+5DEA */	U2E_NODEST_COLX,
	/* U+5DEB */	JISX0208(0xd6e0),
	/* U+5DEC */	U2E_NODEST_COLX,
	/* U+5DED */	U2E_NODEST_COLX,
	/* U+5DEE */	JISX0208(0xbab9),
	/* U+5DEF */	U2E_NODEST_COLX,
	/* U+5DF0 */	U2E_NODEST_COLX,
	/* U+5DF1 */	JISX0208(0xb8ca),
	/* U+5DF2 */	JISX0208(0xd6e1),
	/* U+5DF3 */	JISX0208(0xcca6),
	/* U+5DF4 */	JISX0208(0xc7c3),
	/* U+5DF5 */	JISX0208(0xd6e2),
	/* U+5DF6 */	U2E_NODEST_COLX,
	/* U+5DF7 */	JISX0208(0xb9ab),
	/* U+5DF8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc22)),
	/* U+5DF9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc23)),
	/* U+5DFA */	U2E_NODEST_COLX,
	/* U+5DFB */	JISX0208(0xb4ac),
	/* U+5DFC */	U2E_NODEST_COLX,
	/* U+5DFD */	JISX0208(0xc3a7),
	/* U+5DFE */	JISX0208(0xb6d2),
	/* U+5DFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_5E[] = {
	/* U+5E00 */	IFX0213(JISX0213_2(0xa870),	JISX0212(0xbc24)),
	/* U+5E01 */	U2E_NODEST_COLX,
	/* U+5E02 */	JISX0208(0xbbd4),
	/* U+5E03 */	JISX0208(0xc9db),
	/* U+5E04 */	U2E_NODEST_COLX,
	/* U+5E05 */	U2E_NODEST_COLX,
	/* U+5E06 */	JISX0208(0xc8c1),
	/* U+5E07 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc25)),
	/* U+5E08 */	U2E_NODEST_COLX,
	/* U+5E09 */	U2E_NODEST_COLX,
	/* U+5E0A */	U2E_NODEST_COLX,
	/* U+5E0B */	JISX0208(0xd6e3),
	/* U+5E0C */	JISX0208(0xb4f5),
	/* U+5E0D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc26)),
	/* U+5E0E */	U2E_NODEST_COLX,
	/* U+5E0F */	U2E_NODEST_COLX,
	/* U+5E10 */	U2E_NODEST_COLX,
	/* U+5E11 */	JISX0208(0xd6e6),
	/* U+5E12 */	IFX0213(JISX0213_2(0xa872),	JISX0212(0xbc27)),
	/* U+5E13 */	U2E_NODEST_COLX,
	/* U+5E14 */	IFX0213(JISX0213_1(0xf4a9),	JISX0212(0xbc28)),
	/* U+5E15 */	IFX0213(JISX0213_2(0xa873),	JISX0212(0xbc29)),
	/* U+5E16 */	JISX0208(0xc4a1),
	/* U+5E17 */	U2E_NODEST_COLX,
	/* U+5E18 */	IFX0213(JISX0213_1(0xf4aa),	JISX0212(0xbc2a)),
	/* U+5E19 */	JISX0208(0xd6e5),
	/* U+5E1A */	JISX0208(0xd6e4),
	/* U+5E1B */	JISX0208(0xd6e7),
	/* U+5E1C */	U2E_NODEST_COLX,
	/* U+5E1D */	JISX0208(0xc4eb),
	/* U+5E1E */	U2E_NODEST_COLX,
	/* U+5E1F */	IFX0213(JISX0213_2(0xa875),	JISX0212(0xbc2b)),
	/* U+5E20 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc2c)),
	/* U+5E21 */	U2E_NODEST_COLX,
	/* U+5E22 */	U2E_NODEST_COLX,
	/* U+5E23 */	U2E_NODEST_COLX,
	/* U+5E24 */	U2E_NODEST_COLX,
	/* U+5E25 */	JISX0208(0xbfe3),
	/* U+5E26 */	U2E_NODEST_COLX,
	/* U+5E27 */	U2E_NODEST_COLX,
	/* U+5E28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc2e)),
	/* U+5E29 */	U2E_NODEST_COLX,
	/* U+5E2A */	U2E_NODEST_COLX,
	/* U+5E2B */	JISX0208(0xbbd5),
	/* U+5E2C */	U2E_NODEST_COLX,
	/* U+5E2D */	JISX0208(0xc0ca),
	/* U+5E2E */	IFX0213(JISX0213_2(0xa876),	JISX0212(0xbc2d)),
	/* U+5E2F */	JISX0208(0xc2d3),
	/* U+5E30 */	JISX0208(0xb5a2),
	/* U+5E31 */	U2E_NODEST_COLX,
	/* U+5E32 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc2f)),
	/* U+5E33 */	JISX0208(0xc4a2),
	/* U+5E34 */	U2E_NODEST_COLX,
	/* U+5E35 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc30)),
	/* U+5E36 */	JISX0208(0xd6e8),
	/* U+5E37 */	JISX0208(0xd6e9),
	/* U+5E38 */	JISX0208(0xbeef),
	/* U+5E39 */	U2E_NODEST_COLX,
	/* U+5E3A */	U2E_NODEST_COLX,
	/* U+5E3B */	U2E_NODEST_COLX,
	/* U+5E3C */	U2E_NODEST_COLX,
	/* U+5E3D */	JISX0208(0xcbb9),
	/* U+5E3E */	IFX0213(JISX0213_2(0xa877),	JISX0212(0xbc31)),
	/* U+5E3F */	U2E_NODEST_COLX,
	/* U+5E40 */	JISX0208(0xd6ec),
	/* U+5E41 */	U2E_NODEST_COLX,
	/* U+5E42 */	U2E_NODEST_COLX,
	/* U+5E43 */	JISX0208(0xd6eb),
	/* U+5E44 */	JISX0208(0xd6ea),
	/* U+5E45 */	JISX0208(0xc9fd),
	/* U+5E46 */	U2E_NODEST_COLX,
	/* U+5E47 */	JISX0208(0xd6f3),
	/* U+5E48 */	U2E_NODEST_COLX,
	/* U+5E49 */	IFX0213(JISX0213_2(0xa878),	JISX0212(0xbc34)),
	/* U+5E4A */	U2E_NODEST_COLX,
	/* U+5E4B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc32)),
	/* U+5E4C */	JISX0208(0xcbda),
	/* U+5E4D */	U2E_NODEST_COLX,
	/* U+5E4E */	JISX0208(0xd6ed),
	/* U+5E4F */	U2E_NODEST_COLX,
	/* U+5E50 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc33)),
	/* U+5E51 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc35)),
	/* U+5E52 */	U2E_NODEST_COLX,
	/* U+5E53 */	U2E_NODEST_COLX,
	/* U+5E54 */	JISX0208(0xd6ef),
	/* U+5E55 */	JISX0208(0xcbeb),
	/* U+5E56 */	IFX0213(JISX0213_2(0xa87a),	JISX0212(0xbc36)),
	/* U+5E57 */	JISX0208(0xd6ee),
	/* U+5E58 */	IFX0213(JISX0213_1(0xf4ab),	JISX0212(0xbc37)),
	/* U+5E59 */	U2E_NODEST_COLX,
	/* U+5E5A */	U2E_NODEST_COLX,
	/* U+5E5B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc38)),
	/* U+5E5C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc39)),
	/* U+5E5D */	U2E_NODEST_COLX,
	/* U+5E5E */	IFX0213(JISX0213_1(0xf4ac),	JISX0212(0xbc3a)),
	/* U+5E5F */	JISX0208(0xd6f0),
	/* U+5E60 */	U2E_NODEST_COLX,
	/* U+5E61 */	JISX0208(0xc8a8),
	/* U+5E62 */	JISX0208(0xd6f1),
	/* U+5E63 */	JISX0208(0xcabe),
	/* U+5E64 */	JISX0208(0xd6f2),
	/* U+5E65 */	U2E_NODEST_COLX,
	/* U+5E66 */	U2E_NODEST_COLX,
	/* U+5E67 */	U2E_NODEST_COLX,
	/* U+5E68 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc3b)),
	/* U+5E69 */	U2E_NODEST_COLX,
	/* U+5E6A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc3c)),
	/* U+5E6B */	IFX0213(JISX0213_2(0xa87c),	JISX0212(0xbc3d)),
	/* U+5E6C */	IFX0213(JISX0213_2(0xa87d),	JISX0212(0xbc3e)),
	/* U+5E6D */	IFX0213(JISX0213_2(0xa87e),	JISX0212(0xbc3f)),
	/* U+5E6E */	IFX0213(JISX0213_2(0xac21),	JISX0212(0xbc40)),
	/* U+5E6F */	U2E_NODEST_COLX,
	/* U+5E70 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc41)),
	/* U+5E71 */	U2E_NODEST_COLX,
	/* U+5E72 */	JISX0208(0xb4b3),
	/* U+5E73 */	JISX0208(0xcabf),
	/* U+5E74 */	JISX0208(0xc7af),
	/* U+5E75 */	JISX0208(0xd6f4),
	/* U+5E76 */	JISX0208(0xd6f5),
	/* U+5E77 */	IFX0213(JISX0213_1(0xfefc),	U2E_NODEST_COLX),
	/* U+5E78 */	JISX0208(0xb9ac),
	/* U+5E79 */	JISX0208(0xb4b4),
	/* U+5E7A */	JISX0208(0xd6f6),
	/* U+5E7B */	JISX0208(0xb8b8),
	/* U+5E7C */	JISX0208(0xcdc4),
	/* U+5E7D */	JISX0208(0xcda9),
	/* U+5E7E */	JISX0208(0xb4f6),
	/* U+5E7F */	JISX0208(0xd6f8),
	/* U+5E80 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc42)),
	/* U+5E81 */	JISX0208(0xc4a3),
	/* U+5E82 */	U2E_NODEST_COLX,
	/* U+5E83 */	JISX0208(0xb9ad),
	/* U+5E84 */	JISX0208(0xbeb1),
	/* U+5E85 */	U2E_NODEST_COLX,
	/* U+5E86 */	U2E_NODEST_COLX,
	/* U+5E87 */	JISX0208(0xc8df),
	/* U+5E88 */	U2E_NODEST_COLX,
	/* U+5E89 */	U2E_NODEST_COLX,
	/* U+5E8A */	JISX0208(0xbeb2),
	/* U+5E8B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc43)),
	/* U+5E8C */	U2E_NODEST_COLX,
	/* U+5E8D */	U2E_NODEST_COLX,
	/* U+5E8E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc44)),
	/* U+5E8F */	JISX0208(0xbdf8),
	/* U+5E90 */	U2E_NODEST_COLX,
	/* U+5E91 */	U2E_NODEST_COLX,
	/* U+5E92 */	U2E_NODEST_COLX,
	/* U+5E93 */	U2E_NODEST_COLX,
	/* U+5E94 */	U2E_NODEST_COLX,
	/* U+5E95 */	JISX0208(0xc4ec),
	/* U+5E96 */	JISX0208(0xcaf9),
	/* U+5E97 */	JISX0208(0xc5b9),
	/* U+5E98 */	U2E_NODEST_COLX,
	/* U+5E99 */	U2E_NODEST_COLX,
	/* U+5E9A */	JISX0208(0xb9ae),
	/* U+5E9B */	U2E_NODEST_COLX,
	/* U+5E9C */	JISX0208(0xc9dc),
	/* U+5E9D */	U2E_NODEST_COLX,
	/* U+5E9E */	U2E_NODEST_COLX,
	/* U+5E9F */	U2E_NODEST_COLX,
	/* U+5EA0 */	JISX0208(0xd6f9),
	/* U+5EA1 */	U2E_NODEST_COLX,
	/* U+5EA2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc45)),
	/* U+5EA3 */	U2E_NODEST_COLX,
	/* U+5EA4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc46)),
	/* U+5EA5 */	IFX0213(JISX0213_2(0xac23),	JISX0212(0xbc47)),
	/* U+5EA6 */	JISX0208(0xc5d9),
	/* U+5EA7 */	JISX0208(0xbac2),
	/* U+5EA8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc48)),
	/* U+5EA9 */	U2E_NODEST_COLX,
	/* U+5EAA */	IFX0213(JISX0213_2(0xac24),	JISX0212(0xbc49)),
	/* U+5EAB */	JISX0208(0xb8cb),
	/* U+5EAC */	IFX0213(JISX0213_2(0xac25),	JISX0212(0xbc4a)),
	/* U+5EAD */	JISX0208(0xc4ed),
	/* U+5EAE */	U2E_NODEST_COLX,
	/* U+5EAF */	U2E_NODEST_COLX,
	/* U+5EB0 */	U2E_NODEST_COLX,
	/* U+5EB1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc4b)),
	/* U+5EB2 */	U2E_NODEST_COLX,
	/* U+5EB3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc4c)),
	/* U+5EB4 */	U2E_NODEST_COLX,
	/* U+5EB5 */	JISX0208(0xb0c3),
	/* U+5EB6 */	JISX0208(0xbdee),
	/* U+5EB7 */	JISX0208(0xb9af),
	/* U+5EB8 */	JISX0208(0xcdc7),
	/* U+5EB9 */	IFX0213(JISX0213_2(0xac26),	U2E_NODEST_COLX),
	/* U+5EBA */	U2E_NODEST_COLX,
	/* U+5EBB */	U2E_NODEST_COLX,
	/* U+5EBC */	U2E_NODEST_COLX,
	/* U+5EBD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc4d)),
	/* U+5EBE */	IFX0213(JISX0213_1(0xf4ad),	JISX0212(0xbc4e)),
	/* U+5EBF */	IFX0213(JISX0213_2(0xac27),	JISX0212(0xbc4f)),
	/* U+5EC0 */	U2E_NODEST_COLX,
	/* U+5EC1 */	JISX0208(0xd6fa),
	/* U+5EC2 */	JISX0208(0xd6fb),
	/* U+5EC3 */	JISX0208(0xc7d1),
	/* U+5EC4 */	U2E_NODEST_COLX,
	/* U+5EC5 */	U2E_NODEST_COLX,
	/* U+5EC6 */	IFX0213(JISX0213_2(0xac28),	JISX0212(0xbc50)),
	/* U+5EC7 */	U2E_NODEST_COLX,
	/* U+5EC8 */	JISX0208(0xd6fc),
	/* U+5EC9 */	JISX0208(0xcef7),
	/* U+5ECA */	JISX0208(0xcfad),
	/* U+5ECB */	IFX0213(JISX0213_1(0xf4af),	JISX0212(0xbc52)),
	/* U+5ECC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc51)),
	/* U+5ECD */	U2E_NODEST_COLX,
	/* U+5ECE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc53)),
	/* U+5ECF */	JISX0208(0xd6fe),
	/* U+5ED0 */	JISX0208(0xd6fd),
	/* U+5ED1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc54)),
	/* U+5ED2 */	IFX0213(JISX0213_2(0xac29),	JISX0212(0xbc55)),
	/* U+5ED3 */	JISX0208(0xb3c7),
	/* U+5ED4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc56)),
	/* U+5ED5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc57)),
	/* U+5ED6 */	JISX0208(0xd7a1),
	/* U+5ED7 */	U2E_NODEST_COLX,
	/* U+5ED8 */	U2E_NODEST_COLX,
	/* U+5ED9 */	IFX0213(JISX0213_2(0xac2a),	U2E_NODEST_COLX),
	/* U+5EDA */	JISX0208(0xd7a4),
	/* U+5EDB */	JISX0208(0xd7a5),
	/* U+5EDC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc58)),
	/* U+5EDD */	JISX0208(0xd7a3),
	/* U+5EDE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc59)),
	/* U+5EDF */	JISX0208(0xc9c0),
	/* U+5EE0 */	JISX0208(0xbeb3),
	/* U+5EE1 */	JISX0208(0xd7a7),
	/* U+5EE2 */	JISX0208(0xd7a6),
	/* U+5EE3 */	JISX0208(0xd7a2),
	/* U+5EE4 */	U2E_NODEST_COLX,
	/* U+5EE5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc5a)),
	/* U+5EE6 */	U2E_NODEST_COLX,
	/* U+5EE7 */	U2E_NODEST_COLX,
	/* U+5EE8 */	JISX0208(0xd7a8),
	/* U+5EE9 */	JISX0208(0xd7a9),
	/* U+5EEA */	U2E_NODEST_COLX,
	/* U+5EEB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc5b)),
	/* U+5EEC */	JISX0208(0xd7aa),
	/* U+5EED */	U2E_NODEST_COLX,
	/* U+5EEE */	U2E_NODEST_COLX,
	/* U+5EEF */	U2E_NODEST_COLX,
	/* U+5EF0 */	JISX0208(0xd7ad),
	/* U+5EF1 */	JISX0208(0xd7ab),
	/* U+5EF2 */	U2E_NODEST_COLX,
	/* U+5EF3 */	JISX0208(0xd7ac),
	/* U+5EF4 */	JISX0208(0xd7ae),
	/* U+5EF5 */	U2E_NODEST_COLX,
	/* U+5EF6 */	JISX0208(0xb1e4),
	/* U+5EF7 */	JISX0208(0xc4ee),
	/* U+5EF8 */	JISX0208(0xd7af),
	/* U+5EF9 */	IFX0213(JISX0213_1(0xf4b0),	U2E_NODEST_COLX),
	/* U+5EFA */	JISX0208(0xb7fa),
	/* U+5EFB */	JISX0208(0xb2f6),
	/* U+5EFC */	JISX0208(0xc7b6),
	/* U+5EFD */	IFX0213(JISX0213_2(0xac2c),	U2E_NODEST_COLX),
	/* U+5EFE */	JISX0208(0xd7b0),
	/* U+5EFF */	JISX0208(0xc6fb),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_5F[] = {
	/* U+5F00 */	IFX0213(JISX0213_1(0xf4b1),	U2E_NODEST_COLX),
	/* U+5F01 */	JISX0208(0xcadb),
	/* U+5F02 */	IFX0213(JISX0213_1(0xf4b2),	JISX0212(0xbc5c)),
	/* U+5F03 */	JISX0208(0xd7b1),
	/* U+5F04 */	JISX0208(0xcfae),
	/* U+5F05 */	U2E_NODEST_COLX,
	/* U+5F06 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc5d)),
	/* U+5F07 */	IFX0213(JISX0213_1(0xf4b3),	JISX0212(0xbc5e)),
	/* U+5F08 */	IFX0213(JISX0213_2(0xac2d),	JISX0212(0xbc5f)),
	/* U+5F09 */	JISX0208(0xd7b2),
	/* U+5F0A */	JISX0208(0xcac0),
	/* U+5F0B */	JISX0208(0xd7b5),
	/* U+5F0C */	JISX0208(0xd0a1),
	/* U+5F0D */	JISX0208(0xd0b1),
	/* U+5F0E */	IFX0213(JISX0213_2(0xac2e),	JISX0212(0xbc60)),
	/* U+5F0F */	JISX0208(0xbcb0),
	/* U+5F10 */	JISX0208(0xc6f5),
	/* U+5F11 */	JISX0208(0xd7b6),
	/* U+5F12 */	U2E_NODEST_COLX,
	/* U+5F13 */	JISX0208(0xb5dd),
	/* U+5F14 */	JISX0208(0xc4a4),
	/* U+5F15 */	JISX0208(0xb0fa),
	/* U+5F16 */	JISX0208(0xd7b7),
	/* U+5F17 */	JISX0208(0xcaa6),
	/* U+5F18 */	JISX0208(0xb9b0),
	/* U+5F19 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc61)),
	/* U+5F1A */	U2E_NODEST_COLX,
	/* U+5F1B */	JISX0208(0xc3d0),
	/* U+5F1C */	IFX0213(JISX0213_2(0xac2f),	JISX0212(0xbc62)),
	/* U+5F1D */	IFX0213(JISX0213_1(0xf4b4),	JISX0212(0xbc63)),
	/* U+5F1E */	IFX0213(JISX0213_2(0xac31),	U2E_NODEST_COLX),
	/* U+5F1F */	JISX0208(0xc4ef),
	/* U+5F20 */	U2E_NODEST_COLX,
	/* U+5F21 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc64)),
	/* U+5F22 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc65)),
	/* U+5F23 */	IFX0213(JISX0213_1(0xf4b5),	JISX0212(0xbc66)),
	/* U+5F24 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc67)),
	/* U+5F25 */	JISX0208(0xccef),
	/* U+5F26 */	JISX0208(0xb8b9),
	/* U+5F27 */	JISX0208(0xb8cc),
	/* U+5F28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc68)),
	/* U+5F29 */	JISX0208(0xd7b8),
	/* U+5F2A */	U2E_NODEST_COLX,
	/* U+5F2B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc69)),
	/* U+5F2C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc6a)),
	/* U+5F2D */	JISX0208(0xd7b9),
	/* U+5F2E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc6b)),
	/* U+5F2F */	JISX0208(0xd7bf),
	/* U+5F30 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc6c)),
	/* U+5F31 */	JISX0208(0xbce5),
	/* U+5F32 */	U2E_NODEST_COLX,
	/* U+5F33 */	U2E_NODEST_COLX,
	/* U+5F34 */	IFX0213(JISX0213_1(0xf4b6),	JISX0212(0xbc6d)),
	/* U+5F35 */	JISX0208(0xc4a5),
	/* U+5F36 */	IFX0213(JISX0213_1(0xf4b7),	JISX0212(0xbc6e)),
	/* U+5F37 */	JISX0208(0xb6af),
	/* U+5F38 */	JISX0208(0xd7ba),
	/* U+5F39 */	U2E_NODEST_COLX,
	/* U+5F3A */	U2E_NODEST_COLX,
	/* U+5F3B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc6f)),
	/* U+5F3C */	JISX0208(0xc9ab),
	/* U+5F3D */	IFX0213(JISX0213_1(0xf4b8),	JISX0212(0xbc70)),
	/* U+5F3E */	JISX0208(0xc3c6),
	/* U+5F3F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc71)),
	/* U+5F40 */	IFX0213(JISX0213_1(0xf4b9),	JISX0212(0xbc72)),
	/* U+5F41 */	JISX0208(0xd7bb),
	/* U+5F42 */	U2E_NODEST_COLX,
	/* U+5F43 */	U2E_NODEST_COLX,
	/* U+5F44 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc73)),
	/* U+5F45 */	IFX0213(JISX0213_1(0xf4ba),	JISX0212(0xbc74)),
	/* U+5F46 */	U2E_NODEST_COLX,
	/* U+5F47 */	IFX0213(JISX0213_2(0xac32),	JISX0212(0xbc75)),
	/* U+5F48 */	JISX0208(0xd7bc),
	/* U+5F49 */	U2E_NODEST_COLX,
	/* U+5F4A */	JISX0208(0xb6b0),
	/* U+5F4B */	U2E_NODEST_COLX,
	/* U+5F4C */	JISX0208(0xd7bd),
	/* U+5F4D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc76)),
	/* U+5F4E */	JISX0208(0xd7be),
	/* U+5F4F */	U2E_NODEST_COLX,
	/* U+5F50 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc77)),
	/* U+5F51 */	JISX0208(0xd7c0),
	/* U+5F52 */	U2E_NODEST_COLX,
	/* U+5F53 */	JISX0208(0xc5f6),
	/* U+5F54 */	IFX0213(JISX0213_1(0xf4bb),	JISX0212(0xbc78)),
	/* U+5F55 */	U2E_NODEST_COLX,
	/* U+5F56 */	JISX0208(0xd7c1),
	/* U+5F57 */	JISX0208(0xd7c2),
	/* U+5F58 */	IFX0213(JISX0213_1(0xf4bc),	JISX0212(0xbc79)),
	/* U+5F59 */	JISX0208(0xd7c3),
	/* U+5F5A */	U2E_NODEST_COLX,
	/* U+5F5B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc7a)),
	/* U+5F5C */	JISX0208(0xd7b4),
	/* U+5F5D */	JISX0208(0xd7b3),
	/* U+5F5E */	U2E_NODEST_COLX,
	/* U+5F5F */	U2E_NODEST_COLX,
	/* U+5F60 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbc7b)),
	/* U+5F61 */	JISX0208(0xd7c4),
	/* U+5F62 */	JISX0208(0xb7c1),
	/* U+5F63 */	IFX0213(JISX0213_2(0xac33),	JISX0212(0xbc7c)),
	/* U+5F64 */	IFX0213(JISX0213_1(0xf4bd),	JISX0212(0xbc7d)),
	/* U+5F65 */	U2E_NODEST_COLX,
	/* U+5F66 */	JISX0208(0xc9a7),
	/* U+5F67 */	IFX0213(JISX0213_1(0xf4be),	JISX0212(0xbc7e)),
	/* U+5F68 */	U2E_NODEST_COLX,
	/* U+5F69 */	JISX0208(0xbacc),
	/* U+5F6A */	JISX0208(0xc9b7),
	/* U+5F6B */	JISX0208(0xc4a6),
	/* U+5F6C */	JISX0208(0xc9cb),
	/* U+5F6D */	JISX0208(0xd7c5),
	/* U+5F6E */	U2E_NODEST_COLX,
	/* U+5F6F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd21)),
	/* U+5F70 */	JISX0208(0xbeb4),
	/* U+5F71 */	JISX0208(0xb1c6),
	/* U+5F72 */	IFX0213(JISX0213_2(0xac34),	JISX0212(0xbd22)),
	/* U+5F73 */	JISX0208(0xd7c6),
	/* U+5F74 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd23)),
	/* U+5F75 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd24)),
	/* U+5F76 */	U2E_NODEST_COLX,
	/* U+5F77 */	JISX0208(0xd7c7),
	/* U+5F78 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd25)),
	/* U+5F79 */	JISX0208(0xccf2),
	/* U+5F7A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd26)),
	/* U+5F7B */	U2E_NODEST_COLX,
	/* U+5F7C */	JISX0208(0xc8e0),
	/* U+5F7D */	IFX0213(JISX0213_1(0xf4bf),	JISX0212(0xbd27)),
	/* U+5F7E */	IFX0213(JISX0213_2(0xac35),	JISX0212(0xbd28)),
	/* U+5F7F */	JISX0208(0xd7ca),
	/* U+5F80 */	JISX0208(0xb1fd),
	/* U+5F81 */	JISX0208(0xc0ac),
	/* U+5F82 */	JISX0208(0xd7c9),
	/* U+5F83 */	JISX0208(0xd7c8),
	/* U+5F84 */	JISX0208(0xb7c2),
	/* U+5F85 */	JISX0208(0xc2d4),
	/* U+5F86 */	U2E_NODEST_COLX,
	/* U+5F87 */	JISX0208(0xd7ce),
	/* U+5F88 */	JISX0208(0xd7cc),
	/* U+5F89 */	IFX0213(JISX0213_1(0xf4c0),	JISX0212(0xbd29)),
	/* U+5F8A */	JISX0208(0xd7cb),
	/* U+5F8B */	JISX0208(0xcea7),
	/* U+5F8C */	JISX0208(0xb8e5),
	/* U+5F8D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd2a)),
	/* U+5F8E */	U2E_NODEST_COLX,
	/* U+5F8F */	IFX0213(JISX0213_2(0xac36),	JISX0212(0xbd2b)),
	/* U+5F90 */	JISX0208(0xbdf9),
	/* U+5F91 */	JISX0208(0xd7cd),
	/* U+5F92 */	JISX0208(0xc5cc),
	/* U+5F93 */	JISX0208(0xbdbe),
	/* U+5F94 */	U2E_NODEST_COLX,
	/* U+5F95 */	U2E_NODEST_COLX,
	/* U+5F96 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd2c)),
	/* U+5F97 */	JISX0208(0xc6c0),
	/* U+5F98 */	JISX0208(0xd7d1),
	/* U+5F99 */	JISX0208(0xd7d0),
	/* U+5F9A */	U2E_NODEST_COLX,
	/* U+5F9B */	U2E_NODEST_COLX,
	/* U+5F9C */	IFX0213(JISX0213_1(0xf4c1),	JISX0212(0xbd2d)),
	/* U+5F9D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd2e)),
	/* U+5F9E */	JISX0208(0xd7cf),
	/* U+5F9F */	U2E_NODEST_COLX,
	/* U+5FA0 */	JISX0208(0xd7d2),
	/* U+5FA1 */	JISX0208(0xb8e6),
	/* U+5FA2 */	IFX0213(JISX0213_2(0xac37),	JISX0212(0xbd2f)),
	/* U+5FA3 */	U2E_NODEST_COLX,
	/* U+5FA4 */	IFX0213(JISX0213_2(0xac38),	JISX0212(0xbd32)),
	/* U+5FA5 */	U2E_NODEST_COLX,
	/* U+5FA6 */	U2E_NODEST_COLX,
	/* U+5FA7 */	IFX0213(JISX0213_1(0xf4c2),	JISX0212(0xbd30)),
	/* U+5FA8 */	JISX0208(0xd7d3),
	/* U+5FA9 */	JISX0208(0xc9fc),
	/* U+5FAA */	JISX0208(0xbddb),
	/* U+5FAB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd31)),
	/* U+5FAC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd33)),
	/* U+5FAD */	JISX0208(0xd7d4),
	/* U+5FAE */	JISX0208(0xc8f9),
	/* U+5FAF */	IFX0213(JISX0213_1(0xf4c3),	JISX0212(0xbd34)),
	/* U+5FB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd35)),
	/* U+5FB1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd36)),
	/* U+5FB2 */	U2E_NODEST_COLX,
	/* U+5FB3 */	JISX0208(0xc6c1),
	/* U+5FB4 */	JISX0208(0xc4a7),
	/* U+5FB5 */	IFX0213(JISX0213_1(0xf4c4),	U2E_NODEST_COLX),
	/* U+5FB6 */	U2E_NODEST_COLX,
	/* U+5FB7 */	IFX0213(JISX0213_1(0xf4c5),	IBM(0xf43e)),
	/* U+5FB8 */	IFX0213(JISX0213_2(0xac39),	JISX0212(0xbd37)),
	/* U+5FB9 */	JISX0208(0xc5b0),
	/* U+5FBA */	U2E_NODEST_COLX,
	/* U+5FBB */	U2E_NODEST_COLX,
	/* U+5FBC */	JISX0208(0xd7d5),
	/* U+5FBD */	JISX0208(0xb5ab),
	/* U+5FBE */	U2E_NODEST_COLX,
	/* U+5FBF */	U2E_NODEST_COLX,
	/* U+5FC0 */	U2E_NODEST_COLX,
	/* U+5FC1 */	U2E_NODEST_COLX,
	/* U+5FC2 */	U2E_NODEST_COLX,
	/* U+5FC3 */	JISX0208(0xbfb4),
	/* U+5FC4 */	IFX0213(JISX0213_2(0xac3a),	JISX0212(0xbd38)),
	/* U+5FC5 */	JISX0208(0xc9ac),
	/* U+5FC6 */	U2E_NODEST_COLX,
	/* U+5FC7 */	IFX0213(JISX0213_2(0xac3c),	JISX0212(0xbd39)),
	/* U+5FC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd3a)),
	/* U+5FC9 */	IFX0213(JISX0213_1(0xf4c6),	JISX0212(0xbd3b)),
	/* U+5FCA */	U2E_NODEST_COLX,
	/* U+5FCB */	IFX0213(JISX0213_2(0xac3d),	JISX0212(0xbd3c)),
	/* U+5FCC */	JISX0208(0xb4f7),
	/* U+5FCD */	JISX0208(0xc7a6),
	/* U+5FCE */	U2E_NODEST_COLX,
	/* U+5FCF */	U2E_NODEST_COLX,
	/* U+5FD0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd3d)),
	/* U+5FD1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd3e)),
	/* U+5FD2 */	IFX0213(JISX0213_2(0xac3e),	JISX0212(0xbd3f)),
	/* U+5FD3 */	IFX0213(JISX0213_2(0xac3f),	JISX0212(0xbd40)),
	/* U+5FD4 */	IFX0213(JISX0213_2(0xac40),	JISX0212(0xbd41)),
	/* U+5FD5 */	U2E_NODEST_COLX,
	/* U+5FD6 */	JISX0208(0xd7d6),
	/* U+5FD7 */	JISX0208(0xbbd6),
	/* U+5FD8 */	JISX0208(0xcbba),
	/* U+5FD9 */	JISX0208(0xcbbb),
	/* U+5FDA */	U2E_NODEST_COLX,
	/* U+5FDB */	U2E_NODEST_COLX,
	/* U+5FDC */	JISX0208(0xb1fe),
	/* U+5FDD */	JISX0208(0xd7db),
	/* U+5FDE */	IFX0213(JISX0213_1(0xf4c7),	JISX0212(0xbd42)),
	/* U+5FDF */	U2E_NODEST_COLX,
	/* U+5FE0 */	JISX0208(0xc3e9),
	/* U+5FE1 */	IFX0213(JISX0213_1(0xf4c8),	JISX0212(0xbd43)),
	/* U+5FE2 */	IFX0213(JISX0213_2(0xac41),	JISX0212(0xbd44)),
	/* U+5FE3 */	U2E_NODEST_COLX,
	/* U+5FE4 */	JISX0208(0xd7d8),
	/* U+5FE5 */	U2E_NODEST_COLX,
	/* U+5FE6 */	U2E_NODEST_COLX,
	/* U+5FE7 */	U2E_NODEST_COLX,
	/* U+5FE8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd45)),
	/* U+5FE9 */	IFX0213(JISX0213_1(0xf4c9),	JISX0212(0xbd46)),
	/* U+5FEA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd47)),
	/* U+5FEB */	JISX0208(0xb2f7),
	/* U+5FEC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd48)),
	/* U+5FED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd49)),
	/* U+5FEE */	IFX0213(JISX0213_2(0xac42),	JISX0212(0xbd4a)),
	/* U+5FEF */	IFX0213(JISX0213_2(0xac43),	JISX0212(0xbd4b)),
	/* U+5FF0 */	JISX0208(0xd8ad),
	/* U+5FF1 */	JISX0208(0xd7da),
	/* U+5FF2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd4c)),
	/* U+5FF3 */	IFX0213(JISX0213_2(0xac44),	JISX0212(0xbd4d)),
	/* U+5FF4 */	U2E_NODEST_COLX,
	/* U+5FF5 */	JISX0208(0xc7b0),
	/* U+5FF6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd4e)),
	/* U+5FF7 */	U2E_NODEST_COLX,
	/* U+5FF8 */	JISX0208(0xd7d9),
	/* U+5FF9 */	U2E_NODEST_COLX,
	/* U+5FFA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd4f)),
	/* U+5FFB */	JISX0208(0xd7d7),
	/* U+5FFC */	IFX0213(JISX0213_2(0xac45),	JISX0212(0xbd50)),
	/* U+5FFD */	JISX0208(0xb9fa),
	/* U+5FFE */	U2E_NODEST_COLX,
	/* U+5FFF */	JISX0208(0xd7dd),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_60[] = {
	/* U+6000 */	U2E_NODEST_COLX,
	/* U+6001 */	U2E_NODEST_COLX,
	/* U+6002 */	U2E_NODEST_COLX,
	/* U+6003 */	U2E_NODEST_COLX,
	/* U+6004 */	U2E_NODEST_COLX,
	/* U+6005 */	U2E_NODEST_COLX,
	/* U+6006 */	U2E_NODEST_COLX,
	/* U+6007 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd51)),
	/* U+6008 */	U2E_NODEST_COLX,
	/* U+6009 */	U2E_NODEST_COLX,
	/* U+600A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd52)),
	/* U+600B */	U2E_NODEST_COLX,
	/* U+600C */	U2E_NODEST_COLX,
	/* U+600D */	IFX0213(JISX0213_1(0xf4ca),	JISX0212(0xbd53)),
	/* U+600E */	JISX0208(0xd7e3),
	/* U+600F */	JISX0208(0xd7e9),
	/* U+6010 */	JISX0208(0xd7e1),
	/* U+6011 */	U2E_NODEST_COLX,
	/* U+6012 */	JISX0208(0xc5dc),
	/* U+6013 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd54)),
	/* U+6014 */	IFX0213(JISX0213_1(0xf4cb),	JISX0212(0xbd55)),
	/* U+6015 */	JISX0208(0xd7e6),
	/* U+6016 */	JISX0208(0xc9dd),
	/* U+6017 */	IFX0213(JISX0213_2(0xac47),	JISX0212(0xbd56)),
	/* U+6018 */	IFX0213(JISX0213_1(0xf4cc),	JISX0212(0xbd57)),
	/* U+6019 */	JISX0208(0xd7e0),
	/* U+601A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd58)),
	/* U+601B */	JISX0208(0xd7e5),
	/* U+601C */	JISX0208(0xcee7),
	/* U+601D */	JISX0208(0xbbd7),
	/* U+601E */	U2E_NODEST_COLX,
	/* U+601F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd59)),
	/* U+6020 */	JISX0208(0xc2d5),
	/* U+6021 */	JISX0208(0xd7de),
	/* U+6022 */	IFX0213(JISX0213_2(0xac48),	U2E_NODEST_COLX),
	/* U+6023 */	U2E_NODEST_COLX,
	/* U+6024 */	IFX0213(JISX0213_2(0xac49),	JISX0212(0xbd5a)),
	/* U+6025 */	JISX0208(0xb5de),
	/* U+6026 */	JISX0208(0xd7e8),
	/* U+6027 */	JISX0208(0xc0ad),
	/* U+6028 */	JISX0208(0xb1e5),
	/* U+6029 */	JISX0208(0xd7e2),
	/* U+602A */	JISX0208(0xb2f8),
	/* U+602B */	JISX0208(0xd7e7),
	/* U+602C */	U2E_NODEST_COLX,
	/* U+602D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd5b)),
	/* U+602E */	U2E_NODEST_COLX,
	/* U+602F */	JISX0208(0xb6b1),
	/* U+6030 */	U2E_NODEST_COLX,
	/* U+6031 */	JISX0208(0xd7e4),
	/* U+6032 */	U2E_NODEST_COLX,
	/* U+6033 */	IFX0213(JISX0213_1(0xf4cd),	JISX0212(0xbd5c)),
	/* U+6034 */	U2E_NODEST_COLX,
	/* U+6035 */	IFX0213(JISX0213_1(0xf4ce),	JISX0212(0xbd5d)),
	/* U+6036 */	U2E_NODEST_COLX,
	/* U+6037 */	U2E_NODEST_COLX,
	/* U+6038 */	U2E_NODEST_COLX,
	/* U+6039 */	U2E_NODEST_COLX,
	/* U+603A */	JISX0208(0xd7ea),
	/* U+603B */	U2E_NODEST_COLX,
	/* U+603C */	U2E_NODEST_COLX,
	/* U+603D */	U2E_NODEST_COLX,
	/* U+603E */	U2E_NODEST_COLX,
	/* U+603F */	U2E_NODEST_COLX,
	/* U+6040 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd5e)),
	/* U+6041 */	JISX0208(0xd7ec),
	/* U+6042 */	JISX0208(0xd7f6),
	/* U+6043 */	JISX0208(0xd7f4),
	/* U+6044 */	U2E_NODEST_COLX,
	/* U+6045 */	U2E_NODEST_COLX,
	/* U+6046 */	JISX0208(0xd7f1),
	/* U+6047 */	IFX0213(JISX0213_1(0xf4cf),	JISX0212(0xbd5f)),
	/* U+6048 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd60)),
	/* U+6049 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd61)),
	/* U+604A */	JISX0208(0xd7f0),
	/* U+604B */	JISX0208(0xcef8),
	/* U+604C */	IFX0213(JISX0213_2(0xac4b),	JISX0212(0xbd62)),
	/* U+604D */	JISX0208(0xd7f2),
	/* U+604E */	U2E_NODEST_COLX,
	/* U+604F */	U2E_NODEST_COLX,
	/* U+6050 */	JISX0208(0xb6b2),
	/* U+6051 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd63)),
	/* U+6052 */	JISX0208(0xb9b1),
	/* U+6053 */	U2E_NODEST_COLX,
	/* U+6054 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd64)),
	/* U+6055 */	JISX0208(0xbdfa),
	/* U+6056 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd65)),
	/* U+6057 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd66)),
	/* U+6058 */	U2E_NODEST_COLX,
	/* U+6059 */	JISX0208(0xd7f9),
	/* U+605A */	JISX0208(0xd7eb),
	/* U+605B */	U2E_NODEST_COLX,
	/* U+605C */	U2E_NODEST_COLX,
	/* U+605D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd67)),
	/* U+605E */	U2E_NODEST_COLX,
	/* U+605F */	JISX0208(0xd7ef),
	/* U+6060 */	JISX0208(0xd7df),
	/* U+6061 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd68)),
	/* U+6062 */	JISX0208(0xb2fa),
	/* U+6063 */	JISX0208(0xd7f3),
	/* U+6064 */	JISX0208(0xd7f5),
	/* U+6065 */	JISX0208(0xc3d1),
	/* U+6066 */	U2E_NODEST_COLX,
	/* U+6067 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd69)),
	/* U+6068 */	JISX0208(0xbaa8),
	/* U+6069 */	JISX0208(0xb2b8),
	/* U+606A */	JISX0208(0xd7ed),
	/* U+606B */	JISX0208(0xd7f8),
	/* U+606C */	JISX0208(0xd7f7),
	/* U+606D */	JISX0208(0xb6b3),
	/* U+606E */	U2E_NODEST_COLX,
	/* U+606F */	JISX0208(0xc2a9),
	/* U+6070 */	JISX0208(0xb3e6),
	/* U+6071 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd6a)),
	/* U+6072 */	U2E_NODEST_COLX,
	/* U+6073 */	U2E_NODEST_COLX,
	/* U+6074 */	U2E_NODEST_COLX,
	/* U+6075 */	JISX0208(0xb7c3),
	/* U+6076 */	U2E_NODEST_COLX,
	/* U+6077 */	JISX0208(0xd7ee),
	/* U+6078 */	U2E_NODEST_COLX,
	/* U+6079 */	U2E_NODEST_COLX,
	/* U+607A */	U2E_NODEST_COLX,
	/* U+607B */	U2E_NODEST_COLX,
	/* U+607C */	U2E_NODEST_COLX,
	/* U+607D */	U2E_NODEST_COLX,
	/* U+607E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd6b)),
	/* U+607F */	IFX0213(JISX0213_2(0xac4c),	JISX0212(0xbd6c)),
	/* U+6080 */	U2E_NODEST_COLX,
	/* U+6081 */	JISX0208(0xd7fa),
	/* U+6082 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd6d)),
	/* U+6083 */	JISX0208(0xd7fd),
	/* U+6084 */	JISX0208(0xd8a1),
	/* U+6085 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf43f)),
	/* U+6086 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd6e)),
	/* U+6087 */	U2E_NODEST_COLX,
	/* U+6088 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd6f)),
	/* U+6089 */	JISX0208(0xbcbd),
	/* U+608A */	IFX0213(JISX0213_2(0xac4d),	JISX0212(0xbd70)),
	/* U+608B */	JISX0208(0xd8a7),
	/* U+608C */	JISX0208(0xc4f0),
	/* U+608D */	JISX0208(0xd7fb),
	/* U+608E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd71)),
	/* U+608F */	U2E_NODEST_COLX,
	/* U+6090 */	U2E_NODEST_COLX,
	/* U+6091 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd72)),
	/* U+6092 */	JISX0208(0xd8a5),
	/* U+6093 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd73)),
	/* U+6094 */	JISX0208(0xb2f9),
	/* U+6095 */	IFX0213(JISX0213_2(0xac4e),	JISX0212(0xbd74)),
	/* U+6096 */	JISX0208(0xd8a3),
	/* U+6097 */	JISX0208(0xd8a4),
	/* U+6098 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd75)),
	/* U+6099 */	U2E_NODEST_COLX,
	/* U+609A */	JISX0208(0xd7fe),
	/* U+609B */	JISX0208(0xd8a2),
	/* U+609C */	U2E_NODEST_COLX,
	/* U+609D */	IFX0213(JISX0213_1(0xf4d1),	JISX0212(0xbd76)),
	/* U+609E */	IFX0213(JISX0213_1(0xf4d2),	JISX0212(0xbd77)),
	/* U+609F */	JISX0208(0xb8e7),
	/* U+60A0 */	JISX0208(0xcdaa),
	/* U+60A1 */	U2E_NODEST_COLX,
	/* U+60A2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd78)),
	/* U+60A3 */	JISX0208(0xb4b5),
	/* U+60A4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd79)),
	/* U+60A5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd7a)),
	/* U+60A6 */	JISX0208(0xb1d9),
	/* U+60A7 */	JISX0208(0xd8a6),
	/* U+60A8 */	IFX0213(JISX0213_2(0xac4f),	JISX0212(0xbd7b)),
	/* U+60A9 */	JISX0208(0xc7ba),
	/* U+60AA */	JISX0208(0xb0ad),
	/* U+60AB */	U2E_NODEST_COLX,
	/* U+60AC */	U2E_NODEST_COLX,
	/* U+60AD */	U2E_NODEST_COLX,
	/* U+60AE */	U2E_NODEST_COLX,
	/* U+60AF */	U2E_NODEST_COLX,
	/* U+60B0 */	IFX0213(JISX0213_2(0xac51),	JISX0212(0xbd7c)),
	/* U+60B1 */	IFX0213(JISX0213_2(0xac52),	JISX0212(0xbd7d)),
	/* U+60B2 */	JISX0208(0xc8e1),
	/* U+60B3 */	JISX0208(0xd7dc),
	/* U+60B4 */	JISX0208(0xd8ac),
	/* U+60B5 */	JISX0208(0xd8b0),
	/* U+60B6 */	JISX0208(0xcce5),
	/* U+60B7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbd7e)),
	/* U+60B8 */	JISX0208(0xd8a9),
	/* U+60B9 */	U2E_NODEST_COLX,
	/* U+60BA */	U2E_NODEST_COLX,
	/* U+60BB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe21)),
	/* U+60BC */	JISX0208(0xc5e9),
	/* U+60BD */	JISX0208(0xd8ae),
	/* U+60BE */	IFX0213(JISX0213_2(0xac53),	JISX0212(0xbe22)),
	/* U+60BF */	U2E_NODEST_COLX,
	/* U+60C0 */	U2E_NODEST_COLX,
	/* U+60C1 */	U2E_NODEST_COLX,
	/* U+60C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe23)),
	/* U+60C3 */	U2E_NODEST_COLX,
	/* U+60C4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe24)),
	/* U+60C5 */	JISX0208(0xbef0),
	/* U+60C6 */	JISX0208(0xd8af),
	/* U+60C7 */	JISX0208(0xc6d7),
	/* U+60C8 */	IFX0213(JISX0213_2(0xac54),	JISX0212(0xbe25)),
	/* U+60C9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe26)),
	/* U+60CA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe27)),
	/* U+60CB */	IFX0213(JISX0213_1(0xf4d3),	JISX0212(0xbe28)),
	/* U+60CC */	U2E_NODEST_COLX,
	/* U+60CD */	U2E_NODEST_COLX,
	/* U+60CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe29)),
	/* U+60CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe2a)),
	/* U+60D0 */	U2E_NODEST_COLX,
	/* U+60D1 */	JISX0208(0xcfc7),
	/* U+60D2 */	U2E_NODEST_COLX,
	/* U+60D3 */	JISX0208(0xd8ab),
	/* U+60D4 */	IFX0213(JISX0213_1(0xf4d4),	JISX0212(0xbe2b)),
	/* U+60D5 */	IFX0213(JISX0213_1(0xf4d5),	JISX0212(0xbe2c)),
	/* U+60D6 */	U2E_NODEST_COLX,
	/* U+60D7 */	U2E_NODEST_COLX,
	/* U+60D8 */	JISX0208(0xd8b1),
	/* U+60D9 */	IFX0213(JISX0213_2(0xac55),	JISX0212(0xbe2d)),
	/* U+60DA */	JISX0208(0xb9fb),
	/* U+60DB */	IFX0213(JISX0213_2(0xac56),	JISX0212(0xbe2e)),
	/* U+60DC */	JISX0208(0xc0cb),
	/* U+60DD */	IFX0213(JISX0213_1(0xf4d6),	JISX0212(0xbe2f)),
	/* U+60DE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe30)),
	/* U+60DF */	JISX0208(0xb0d4),
	/* U+60E0 */	JISX0208(0xd8aa),
	/* U+60E1 */	JISX0208(0xd8a8),
	/* U+60E2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe31)),
	/* U+60E3 */	JISX0208(0xc1da),
	/* U+60E4 */	U2E_NODEST_COLX,
	/* U+60E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe32)),
	/* U+60E6 */	U2E_NODEST_COLX,
	/* U+60E7 */	JISX0208(0xd7fc),
	/* U+60E8 */	JISX0208(0xbbb4),
	/* U+60E9 */	U2E_NODEST_COLX,
	/* U+60EA */	U2E_NODEST_COLX,
	/* U+60EB */	U2E_NODEST_COLX,
	/* U+60EC */	U2E_NODEST_COLX,
	/* U+60ED */	U2E_NODEST_COLX,
	/* U+60EE */	IFX0213(JISX0213_2(0xac57),	U2E_NODEST_COLX),
	/* U+60EF */	U2E_NODEST_COLX,
	/* U+60F0 */	JISX0208(0xc2c6),
	/* U+60F1 */	JISX0208(0xd8bd),
	/* U+60F2 */	IFX0213(JISX0213_2(0xac58),	JISX0212(0xbe33)),
	/* U+60F3 */	JISX0208(0xc1db),
	/* U+60F4 */	JISX0208(0xd8b8),
	/* U+60F5 */	IFX0213(JISX0213_2(0xac59),	JISX0212(0xbe34)),
	/* U+60F6 */	JISX0208(0xd8b5),
	/* U+60F7 */	JISX0208(0xd8b6),
	/* U+60F8 */	IFX0213(JISX0213_1(0xf4d7),	JISX0212(0xbe35)),
	/* U+60F9 */	JISX0208(0xbce6),
	/* U+60FA */	JISX0208(0xd8b9),
	/* U+60FB */	JISX0208(0xd8bc),
	/* U+60FC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe36)),
	/* U+60FD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe37)),
	/* U+60FE */	U2E_NODEST_COLX,
	/* U+60FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_61[] = {
	/* U+6100 */	JISX0208(0xd8b7),
	/* U+6101 */	JISX0208(0xbda5),
	/* U+6102 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe38)),
	/* U+6103 */	JISX0208(0xd8ba),
	/* U+6104 */	U2E_NODEST_COLX,
	/* U+6105 */	U2E_NODEST_COLX,
	/* U+6106 */	JISX0208(0xd8b4),
	/* U+6107 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe39)),
	/* U+6108 */	JISX0208(0xccfc),
	/* U+6109 */	JISX0208(0xccfb),
	/* U+610A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe3a)),
	/* U+610B */	U2E_NODEST_COLX,
	/* U+610C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe3b)),
	/* U+610D */	JISX0208(0xd8be),
	/* U+610E */	JISX0208(0xd8bf),
	/* U+610F */	JISX0208(0xb0d5),
	/* U+6110 */	IFX0213(JISX0213_2(0xac5a),	JISX0212(0xbe3c)),
	/* U+6111 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe3d)),
	/* U+6112 */	IFX0213(JISX0213_2(0xac5b),	JISX0212(0xbe3e)),
	/* U+6113 */	IFX0213(JISX0213_2(0xac5c),	JISX0212(0xbe3f)),
	/* U+6114 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe40)),
	/* U+6115 */	JISX0208(0xd8b3),
	/* U+6116 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe41)),
	/* U+6117 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe42)),
	/* U+6118 */	U2E_NODEST_COLX,
	/* U+6119 */	IFX0213(JISX0213_2(0xac5d),	JISX0212(0xbe43)),
	/* U+611A */	JISX0208(0xb6f2),
	/* U+611B */	JISX0208(0xb0a6),
	/* U+611C */	IFX0213(JISX0213_1(0xf4d8),	JISX0212(0xbe44)),
	/* U+611D */	U2E_NODEST_COLX,
	/* U+611E */	IFX0213(JISX0213_2(0xac5e),	JISX0212(0xbe45)),
	/* U+611F */	JISX0208(0xb4b6),
	/* U+6120 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf440)),
	/* U+6121 */	JISX0208(0xd8bb),
	/* U+6122 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe46)),
	/* U+6123 */	U2E_NODEST_COLX,
	/* U+6124 */	U2E_NODEST_COLX,
	/* U+6125 */	U2E_NODEST_COLX,
	/* U+6126 */	U2E_NODEST_COLX,
	/* U+6127 */	JISX0208(0xd8c3),
	/* U+6128 */	JISX0208(0xd8c2),
	/* U+6129 */	U2E_NODEST_COLX,
	/* U+612A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe47)),
	/* U+612B */	IFX0213(JISX0213_1(0xf4d9),	JISX0212(0xbe48)),
	/* U+612C */	JISX0208(0xd8c7),
	/* U+612D */	U2E_NODEST_COLX,
	/* U+612E */	U2E_NODEST_COLX,
	/* U+612F */	U2E_NODEST_COLX,
	/* U+6130 */	IFX0213(JISX0213_1(0xf4da),	JISX0212(0xbe49)),
	/* U+6131 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe4a)),
	/* U+6132 */	U2E_NODEST_COLX,
	/* U+6133 */	U2E_NODEST_COLX,
	/* U+6134 */	JISX0208(0xd8c8),
	/* U+6135 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe4b)),
	/* U+6136 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe4c)),
	/* U+6137 */	IFX0213(JISX0213_1(0xf4db),	JISX0212(0xbe4d)),
	/* U+6138 */	U2E_NODEST_COLX,
	/* U+6139 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe4e)),
	/* U+613A */	IFX0213(JISX0213_2(0xac5f),	U2E_NODEST_COLX),
	/* U+613B */	U2E_NODEST_COLX,
	/* U+613C */	JISX0208(0xd8c6),
	/* U+613D */	JISX0208(0xd8c9),
	/* U+613E */	JISX0208(0xd8c1),
	/* U+613F */	JISX0208(0xd8c5),
	/* U+6140 */	U2E_NODEST_COLX,
	/* U+6141 */	IFX0213(JISX0213_2(0xac61),	JISX0212(0xbe4f)),
	/* U+6142 */	JISX0208(0xd8ca),
	/* U+6143 */	U2E_NODEST_COLX,
	/* U+6144 */	JISX0208(0xd8cb),
	/* U+6145 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe50)),
	/* U+6146 */	IFX0213(JISX0213_2(0xac62),	JISX0212(0xbe51)),
	/* U+6147 */	JISX0208(0xd8c0),
	/* U+6148 */	JISX0208(0xbbfc),
	/* U+6149 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe52)),
	/* U+614A */	JISX0208(0xd8c4),
	/* U+614B */	JISX0208(0xc2d6),
	/* U+614C */	JISX0208(0xb9b2),
	/* U+614D */	JISX0208(0xd8b2),
	/* U+614E */	JISX0208(0xbfb5),
	/* U+614F */	U2E_NODEST_COLX,
	/* U+6150 */	U2E_NODEST_COLX,
	/* U+6151 */	U2E_NODEST_COLX,
	/* U+6152 */	U2E_NODEST_COLX,
	/* U+6153 */	JISX0208(0xd8d8),
	/* U+6154 */	U2E_NODEST_COLX,
	/* U+6155 */	JISX0208(0xcae9),
	/* U+6156 */	U2E_NODEST_COLX,
	/* U+6157 */	U2E_NODEST_COLX,
	/* U+6158 */	JISX0208(0xd8ce),
	/* U+6159 */	JISX0208(0xd8cf),
	/* U+615A */	JISX0208(0xd8d0),
	/* U+615B */	U2E_NODEST_COLX,
	/* U+615C */	U2E_NODEST_COLX,
	/* U+615D */	JISX0208(0xd8d7),
	/* U+615E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe53)),
	/* U+615F */	JISX0208(0xd8d6),
	/* U+6160 */	IFX0213(JISX0213_2(0xac63),	JISX0212(0xbe54)),
	/* U+6161 */	U2E_NODEST_COLX,
	/* U+6162 */	JISX0208(0xcbfd),
	/* U+6163 */	JISX0208(0xb4b7),
	/* U+6164 */	U2E_NODEST_COLX,
	/* U+6165 */	JISX0208(0xd8d4),
	/* U+6166 */	U2E_NODEST_COLX,
	/* U+6167 */	JISX0208(0xb7c5),
	/* U+6168 */	JISX0208(0xb3b4),
	/* U+6169 */	U2E_NODEST_COLX,
	/* U+616A */	U2E_NODEST_COLX,
	/* U+616B */	JISX0208(0xd8d1),
	/* U+616C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe55)),
	/* U+616D */	U2E_NODEST_COLX,
	/* U+616E */	JISX0208(0xceb8),
	/* U+616F */	JISX0208(0xd8d3),
	/* U+6170 */	JISX0208(0xb0d6),
	/* U+6171 */	JISX0208(0xd8d5),
	/* U+6172 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe56)),
	/* U+6173 */	JISX0208(0xd8cc),
	/* U+6174 */	JISX0208(0xd8d2),
	/* U+6175 */	JISX0208(0xd8d9),
	/* U+6176 */	JISX0208(0xb7c4),
	/* U+6177 */	JISX0208(0xd8cd),
	/* U+6178 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe57)),
	/* U+6179 */	U2E_NODEST_COLX,
	/* U+617A */	U2E_NODEST_COLX,
	/* U+617B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe58)),
	/* U+617C */	IFX0213(JISX0213_2(0xac64),	JISX0212(0xbe59)),
	/* U+617D */	U2E_NODEST_COLX,
	/* U+617E */	JISX0208(0xcddd),
	/* U+617F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe5a)),
	/* U+6180 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe5b)),
	/* U+6181 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe5c)),
	/* U+6182 */	JISX0208(0xcdab),
	/* U+6183 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe5d)),
	/* U+6184 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe5e)),
	/* U+6185 */	U2E_NODEST_COLX,
	/* U+6186 */	U2E_NODEST_COLX,
	/* U+6187 */	JISX0208(0xd8dc),
	/* U+6188 */	U2E_NODEST_COLX,
	/* U+6189 */	U2E_NODEST_COLX,
	/* U+618A */	JISX0208(0xd8e0),
	/* U+618B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe5f)),
	/* U+618C */	U2E_NODEST_COLX,
	/* U+618D */	IFX0213(JISX0213_1(0xf4dd),	JISX0212(0xbe60)),
	/* U+618E */	JISX0208(0xc1fe),
	/* U+618F */	U2E_NODEST_COLX,
	/* U+6190 */	JISX0208(0xcef9),
	/* U+6191 */	JISX0208(0xd8e1),
	/* U+6192 */	IFX0213(JISX0213_2(0xac66),	JISX0212(0xbe61)),
	/* U+6193 */	IFX0213(JISX0213_2(0xac67),	JISX0212(0xbe62)),
	/* U+6194 */	JISX0208(0xd8de),
	/* U+6195 */	U2E_NODEST_COLX,
	/* U+6196 */	JISX0208(0xd8db),
	/* U+6197 */	IFX0213(JISX0213_2(0xac68),	JISX0212(0xbe63)),
	/* U+6198 */	IFX0213(JISX0213_2(0xac69),	JISX0212(0xbe64)),
	/* U+6199 */	JISX0208(0xd8da),
	/* U+619A */	JISX0208(0xd8df),
	/* U+619B */	U2E_NODEST_COLX,
	/* U+619C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe65)),
	/* U+619D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe66)),
	/* U+619E */	U2E_NODEST_COLX,
	/* U+619F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe67)),
	/* U+61A0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe68)),
	/* U+61A1 */	U2E_NODEST_COLX,
	/* U+61A2 */	U2E_NODEST_COLX,
	/* U+61A3 */	U2E_NODEST_COLX,
	/* U+61A4 */	JISX0208(0xcab0),
	/* U+61A5 */	IFX0213(JISX0213_2(0xac6a),	JISX0212(0xbe69)),
	/* U+61A6 */	U2E_NODEST_COLX,
	/* U+61A7 */	JISX0208(0xc6b4),
	/* U+61A8 */	IFX0213(JISX0213_2(0xac6b),	JISX0212(0xbe6a)),
	/* U+61A9 */	JISX0208(0xb7c6),
	/* U+61AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe6b)),
	/* U+61AB */	JISX0208(0xd8e2),
	/* U+61AC */	JISX0208(0xd8dd),
	/* U+61AD */	IFX0213(JISX0213_2(0xac6c),	JISX0212(0xbe6c)),
	/* U+61AE */	JISX0208(0xd8e3),
	/* U+61AF */	U2E_NODEST_COLX,
	/* U+61B0 */	U2E_NODEST_COLX,
	/* U+61B1 */	U2E_NODEST_COLX,
	/* U+61B2 */	JISX0208(0xb7fb),
	/* U+61B3 */	U2E_NODEST_COLX,
	/* U+61B4 */	U2E_NODEST_COLX,
	/* U+61B5 */	U2E_NODEST_COLX,
	/* U+61B6 */	JISX0208(0xb2b1),
	/* U+61B7 */	U2E_NODEST_COLX,
	/* U+61B8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe6d)),
	/* U+61B9 */	IFX0213(JISX0213_1(0xf4e0),	JISX0212(0xbe6e)),
	/* U+61BA */	JISX0208(0xd8eb),
	/* U+61BB */	U2E_NODEST_COLX,
	/* U+61BC */	IFX0213(JISX0213_1(0xf4df),	JISX0212(0xbe6f)),
	/* U+61BD */	U2E_NODEST_COLX,
	/* U+61BE */	JISX0208(0xb4b8),
	/* U+61BF */	U2E_NODEST_COLX,
	/* U+61C0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe70)),
	/* U+61C1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe71)),
	/* U+61C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe72)),
	/* U+61C3 */	JISX0208(0xd8e9),
	/* U+61C4 */	U2E_NODEST_COLX,
	/* U+61C5 */	U2E_NODEST_COLX,
	/* U+61C6 */	JISX0208(0xd8ea),
	/* U+61C7 */	JISX0208(0xbaa9),
	/* U+61C8 */	JISX0208(0xd8e8),
	/* U+61C9 */	JISX0208(0xd8e6),
	/* U+61CA */	JISX0208(0xd8e5),
	/* U+61CB */	JISX0208(0xd8ec),
	/* U+61CC */	JISX0208(0xd8e4),
	/* U+61CD */	JISX0208(0xd8ee),
	/* U+61CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe73)),
	/* U+61CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe74)),
	/* U+61D0 */	JISX0208(0xb2fb),
	/* U+61D1 */	U2E_NODEST_COLX,
	/* U+61D2 */	U2E_NODEST_COLX,
	/* U+61D3 */	U2E_NODEST_COLX,
	/* U+61D4 */	U2E_NODEST_COLX,
	/* U+61D5 */	IFX0213(JISX0213_2(0xac6e),	JISX0212(0xbe75)),
	/* U+61D6 */	U2E_NODEST_COLX,
	/* U+61D7 */	U2E_NODEST_COLX,
	/* U+61D8 */	U2E_NODEST_COLX,
	/* U+61D9 */	U2E_NODEST_COLX,
	/* U+61DA */	U2E_NODEST_COLX,
	/* U+61DB */	U2E_NODEST_COLX,
	/* U+61DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe76)),
	/* U+61DD */	IFX0213(JISX0213_2(0xac6f),	JISX0212(0xbe77)),
	/* U+61DE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe78)),
	/* U+61DF */	IFX0213(JISX0213_2(0xac70),	JISX0212(0xbe79)),
	/* U+61E0 */	U2E_NODEST_COLX,
	/* U+61E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe7a)),
	/* U+61E2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe7b)),
	/* U+61E3 */	JISX0208(0xd8f0),
	/* U+61E4 */	U2E_NODEST_COLX,
	/* U+61E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe7e)),
	/* U+61E6 */	JISX0208(0xd8ef),
	/* U+61E7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe7c)),
	/* U+61E8 */	U2E_NODEST_COLX,
	/* U+61E9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbe7d)),
	/* U+61EA */	U2E_NODEST_COLX,
	/* U+61EB */	U2E_NODEST_COLX,
	/* U+61EC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf21)),
	/* U+61ED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf22)),
	/* U+61EE */	U2E_NODEST_COLX,
	/* U+61EF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf23)),
	/* U+61F0 */	U2E_NODEST_COLX,
	/* U+61F1 */	U2E_NODEST_COLX,
	/* U+61F2 */	JISX0208(0xc4a8),
	/* U+61F3 */	U2E_NODEST_COLX,
	/* U+61F4 */	JISX0208(0xd8f3),
	/* U+61F5 */	IFX0213(JISX0213_2(0xac71),	U2E_NODEST_COLX),
	/* U+61F6 */	JISX0208(0xd8f1),
	/* U+61F7 */	JISX0208(0xd8e7),
	/* U+61F8 */	JISX0208(0xb7fc),
	/* U+61F9 */	U2E_NODEST_COLX,
	/* U+61FA */	JISX0208(0xd8f2),
	/* U+61FB */	U2E_NODEST_COLX,
	/* U+61FC */	JISX0208(0xd8f6),
	/* U+61FD */	JISX0208(0xd8f5),
	/* U+61FE */	JISX0208(0xd8f7),
	/* U+61FF */	JISX0208(0xd8f4),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_62[] = {
	/* U+6200 */	JISX0208(0xd8f8),
	/* U+6201 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf24)),
	/* U+6202 */	U2E_NODEST_COLX,
	/* U+6203 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf25)),
	/* U+6204 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf26)),
	/* U+6205 */	U2E_NODEST_COLX,
	/* U+6206 */	U2E_NODEST_COLX,
	/* U+6207 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf27)),
	/* U+6208 */	JISX0208(0xd8f9),
	/* U+6209 */	JISX0208(0xd8fa),
	/* U+620A */	JISX0208(0xcaea),
	/* U+620B */	U2E_NODEST_COLX,
	/* U+620C */	JISX0208(0xd8fc),
	/* U+620D */	JISX0208(0xd8fb),
	/* U+620E */	JISX0208(0xbdbf),
	/* U+620F */	U2E_NODEST_COLX,
	/* U+6210 */	JISX0208(0xc0ae),
	/* U+6211 */	JISX0208(0xb2e6),
	/* U+6212 */	JISX0208(0xb2fc),
	/* U+6213 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf28)),
	/* U+6214 */	JISX0208(0xd8fd),
	/* U+6215 */	IFX0213(JISX0213_2(0xac73),	JISX0212(0xbf29)),
	/* U+6216 */	JISX0208(0xb0bf),
	/* U+6217 */	U2E_NODEST_COLX,
	/* U+6218 */	U2E_NODEST_COLX,
	/* U+6219 */	U2E_NODEST_COLX,
	/* U+621A */	JISX0208(0xc0cc),
	/* U+621B */	JISX0208(0xd8fe),
	/* U+621C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf2a)),
	/* U+621D */	JISX0208(0xecc3),
	/* U+621E */	JISX0208(0xd9a1),
	/* U+621F */	JISX0208(0xb7e1),
	/* U+6220 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf2b)),
	/* U+6221 */	JISX0208(0xd9a2),
	/* U+6222 */	IFX0213(JISX0213_1(0xf4e2),	JISX0212(0xbf2c)),
	/* U+6223 */	IFX0213(JISX0213_2(0xac74),	JISX0212(0xbf2d)),
	/* U+6224 */	U2E_NODEST_COLX,
	/* U+6225 */	U2E_NODEST_COLX,
	/* U+6226 */	JISX0208(0xc0ef),
	/* U+6227 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf2e)),
	/* U+6228 */	U2E_NODEST_COLX,
	/* U+6229 */	IFX0213(JISX0213_2(0xac75),	JISX0212(0xbf2f)),
	/* U+622A */	JISX0208(0xd9a3),
	/* U+622B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf30)),
	/* U+622C */	U2E_NODEST_COLX,
	/* U+622D */	U2E_NODEST_COLX,
	/* U+622E */	JISX0208(0xd9a4),
	/* U+622F */	JISX0208(0xb5ba),
	/* U+6230 */	JISX0208(0xd9a5),
	/* U+6231 */	U2E_NODEST_COLX,
	/* U+6232 */	JISX0208(0xd9a6),
	/* U+6233 */	JISX0208(0xd9a7),
	/* U+6234 */	JISX0208(0xc2d7),
	/* U+6235 */	U2E_NODEST_COLX,
	/* U+6236 */	U2E_NODEST_COLX,
	/* U+6237 */	U2E_NODEST_COLX,
	/* U+6238 */	JISX0208(0xb8cd),
	/* U+6239 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf31)),
	/* U+623A */	U2E_NODEST_COLX,
	/* U+623B */	JISX0208(0xcce1),
	/* U+623C */	U2E_NODEST_COLX,
	/* U+623D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf32)),
	/* U+623E */	IFX0213(JISX0213_1(0xf4e3),	U2E_NODEST_COLX),
	/* U+623F */	JISX0208(0xcbbc),
	/* U+6240 */	JISX0208(0xbdea),
	/* U+6241 */	JISX0208(0xd9a8),
	/* U+6242 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf33)),
	/* U+6243 */	IFX0213(JISX0213_1(0xf4e4),	JISX0212(0xbf34)),
	/* U+6244 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf35)),
	/* U+6245 */	U2E_NODEST_COLX,
	/* U+6246 */	IFX0213(JISX0213_2(0xac76),	JISX0212(0xbf36)),
	/* U+6247 */	JISX0208(0xc0f0),
	/* U+6248 */	JISX0208(0xeebd),
	/* U+6249 */	JISX0208(0xc8e2),
	/* U+624A */	U2E_NODEST_COLX,
	/* U+624B */	JISX0208(0xbcea),
	/* U+624C */	IFX0213(JISX0213_2(0xac77),	JISX0212(0xbf37)),
	/* U+624D */	JISX0208(0xbacd),
	/* U+624E */	JISX0208(0xd9a9),
	/* U+624F */	U2E_NODEST_COLX,
	/* U+6250 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf38)),
	/* U+6251 */	IFX0213(JISX0213_2(0xac78),	JISX0212(0xbf39)),
	/* U+6252 */	IFX0213(JISX0213_2(0xac79),	JISX0212(0xbf3a)),
	/* U+6253 */	JISX0208(0xc2c7),
	/* U+6254 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf3b)),
	/* U+6255 */	JISX0208(0xcaa7),
	/* U+6256 */	IFX0213(JISX0213_1(0xf4e5),	JISX0212(0xbf3c)),
	/* U+6257 */	U2E_NODEST_COLX,
	/* U+6258 */	JISX0208(0xc2f1),
	/* U+6259 */	U2E_NODEST_COLX,
	/* U+625A */	IFX0213(JISX0213_1(0xf4e6),	JISX0212(0xbf3d)),
	/* U+625B */	JISX0208(0xd9ac),
	/* U+625C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf3e)),
	/* U+625D */	U2E_NODEST_COLX,
	/* U+625E */	JISX0208(0xd9aa),
	/* U+625F */	U2E_NODEST_COLX,
	/* U+6260 */	JISX0208(0xd9ad),
	/* U+6261 */	IFX0213(JISX0213_2(0xac7a),	U2E_NODEST_COLX),
	/* U+6262 */	U2E_NODEST_COLX,
	/* U+6263 */	JISX0208(0xd9ab),
	/* U+6264 */	IFX0213(JISX0213_2(0xac7b),	JISX0212(0xbf3f)),
	/* U+6265 */	U2E_NODEST_COLX,
	/* U+6266 */	U2E_NODEST_COLX,
	/* U+6267 */	U2E_NODEST_COLX,
	/* U+6268 */	JISX0208(0xd9ae),
	/* U+6269 */	U2E_NODEST_COLX,
	/* U+626A */	U2E_NODEST_COLX,
	/* U+626B */	U2E_NODEST_COLX,
	/* U+626C */	U2E_NODEST_COLX,
	/* U+626D */	IFX0213(JISX0213_2(0xac7d),	JISX0212(0xbf40)),
	/* U+626E */	JISX0208(0xcab1),
	/* U+626F */	IFX0213(JISX0213_1(0xf4e7),	JISX0212(0xbf41)),
	/* U+6270 */	U2E_NODEST_COLX,
	/* U+6271 */	JISX0208(0xb0b7),
	/* U+6272 */	U2E_NODEST_COLX,
	/* U+6273 */	IFX0213(JISX0213_2(0xac7e),	JISX0212(0xbf42)),
	/* U+6274 */	U2E_NODEST_COLX,
	/* U+6275 */	U2E_NODEST_COLX,
	/* U+6276 */	JISX0208(0xc9de),
	/* U+6277 */	U2E_NODEST_COLX,
	/* U+6278 */	U2E_NODEST_COLX,
	/* U+6279 */	JISX0208(0xc8e3),
	/* U+627A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf43)),
	/* U+627B */	IFX0213(JISX0213_2(0xac7c),	U2E_NODEST_COLX),
	/* U+627C */	JISX0208(0xd9af),
	/* U+627D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf44)),
	/* U+627E */	JISX0208(0xd9b2),
	/* U+627F */	JISX0208(0xbeb5),
	/* U+6280 */	JISX0208(0xb5bb),
	/* U+6281 */	U2E_NODEST_COLX,
	/* U+6282 */	JISX0208(0xd9b0),
	/* U+6283 */	JISX0208(0xd9b7),
	/* U+6284 */	JISX0208(0xbeb6),
	/* U+6285 */	IFX0213(JISX0213_1(0xf4e8),	U2E_NODEST_COLX),
	/* U+6286 */	U2E_NODEST_COLX,
	/* U+6287 */	U2E_NODEST_COLX,
	/* U+6288 */	U2E_NODEST_COLX,
	/* U+6289 */	JISX0208(0xd9b1),
	/* U+628A */	JISX0208(0xc7c4),
	/* U+628B */	U2E_NODEST_COLX,
	/* U+628C */	U2E_NODEST_COLX,
	/* U+628D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf45)),
	/* U+628E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf46)),
	/* U+628F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf47)),
	/* U+6290 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf48)),
	/* U+6291 */	JISX0208(0xcdde),
	/* U+6292 */	JISX0208(0xd9b3),
	/* U+6293 */	JISX0208(0xd9b4),
	/* U+6294 */	JISX0208(0xd9b8),
	/* U+6295 */	JISX0208(0xc5ea),
	/* U+6296 */	JISX0208(0xd9b5),
	/* U+6297 */	JISX0208(0xb9b3),
	/* U+6298 */	JISX0208(0xc0de),
	/* U+6299 */	IFX0213(JISX0213_2(0xad21),	U2E_NODEST_COLX),
	/* U+629A */	U2E_NODEST_COLX,
	/* U+629B */	JISX0208(0xd9c6),
	/* U+629C */	JISX0208(0xc8b4),
	/* U+629D */	U2E_NODEST_COLX,
	/* U+629E */	JISX0208(0xc2f2),
	/* U+629F */	U2E_NODEST_COLX,
	/* U+62A0 */	U2E_NODEST_COLX,
	/* U+62A1 */	U2E_NODEST_COLX,
	/* U+62A2 */	U2E_NODEST_COLX,
	/* U+62A3 */	U2E_NODEST_COLX,
	/* U+62A4 */	U2E_NODEST_COLX,
	/* U+62A5 */	U2E_NODEST_COLX,
	/* U+62A6 */	IFX0213(JISX0213_2(0xad22),	JISX0212(0xbf49)),
	/* U+62A7 */	U2E_NODEST_COLX,
	/* U+62A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf4a)),
	/* U+62A9 */	U2E_NODEST_COLX,
	/* U+62AA */	U2E_NODEST_COLX,
	/* U+62AB */	JISX0208(0xc8e4),
	/* U+62AC */	JISX0208(0xdaad),
	/* U+62AD */	U2E_NODEST_COLX,
	/* U+62AE */	U2E_NODEST_COLX,
	/* U+62AF */	U2E_NODEST_COLX,
	/* U+62B0 */	U2E_NODEST_COLX,
	/* U+62B1 */	JISX0208(0xcafa),
	/* U+62B2 */	U2E_NODEST_COLX,
	/* U+62B3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf4b)),
	/* U+62B4 */	U2E_NODEST_COLX,
	/* U+62B5 */	JISX0208(0xc4f1),
	/* U+62B6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf4c)),
	/* U+62B7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf4d)),
	/* U+62B8 */	U2E_NODEST_COLX,
	/* U+62B9 */	JISX0208(0xcbf5),
	/* U+62BA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf4e)),
	/* U+62BB */	JISX0208(0xd9bb),
	/* U+62BC */	JISX0208(0xb2a1),
	/* U+62BD */	JISX0208(0xc3ea),
	/* U+62BE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf4f)),
	/* U+62BF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf50)),
	/* U+62C0 */	U2E_NODEST_COLX,
	/* U+62C1 */	U2E_NODEST_COLX,
	/* U+62C2 */	JISX0208(0xd9c4),
	/* U+62C3 */	U2E_NODEST_COLX,
	/* U+62C4 */	IFX0213(JISX0213_1(0xf4e9),	JISX0212(0xbf51)),
	/* U+62C5 */	JISX0208(0xc3b4),
	/* U+62C6 */	JISX0208(0xd9be),
	/* U+62C7 */	JISX0208(0xd9c5),
	/* U+62C8 */	JISX0208(0xd9c0),
	/* U+62C9 */	JISX0208(0xd9c7),
	/* U+62CA */	JISX0208(0xd9c3),
	/* U+62CB */	U2E_NODEST_COLX,
	/* U+62CC */	JISX0208(0xd9c2),
	/* U+62CD */	JISX0208(0xc7ef),
	/* U+62CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf52)),
	/* U+62CF */	JISX0208(0xd9bc),
	/* U+62D0 */	JISX0208(0xb2fd),
	/* U+62D1 */	JISX0208(0xd9ba),
	/* U+62D2 */	JISX0208(0xb5f1),
	/* U+62D3 */	JISX0208(0xc2f3),
	/* U+62D4 */	JISX0208(0xd9b6),
	/* U+62D5 */	IFX0213(JISX0213_2(0xad23),	JISX0212(0xbf53)),
	/* U+62D6 */	IFX0213(JISX0213_1(0xf4ea),	JISX0212(0xbf54)),
	/* U+62D7 */	JISX0208(0xd9b9),
	/* U+62D8 */	JISX0208(0xb9b4),
	/* U+62D9 */	JISX0208(0xc0db),
	/* U+62DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf55)),
	/* U+62DB */	JISX0208(0xbeb7),
	/* U+62DC */	JISX0208(0xd9c1),
	/* U+62DD */	JISX0208(0xc7d2),
	/* U+62DE */	U2E_NODEST_COLX,
	/* U+62DF */	U2E_NODEST_COLX,
	/* U+62E0 */	JISX0208(0xb5f2),
	/* U+62E1 */	JISX0208(0xb3c8),
	/* U+62E2 */	U2E_NODEST_COLX,
	/* U+62E3 */	U2E_NODEST_COLX,
	/* U+62E4 */	U2E_NODEST_COLX,
	/* U+62E5 */	U2E_NODEST_COLX,
	/* U+62E6 */	U2E_NODEST_COLX,
	/* U+62E7 */	U2E_NODEST_COLX,
	/* U+62E8 */	U2E_NODEST_COLX,
	/* U+62E9 */	U2E_NODEST_COLX,
	/* U+62EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf56)),
	/* U+62EB */	U2E_NODEST_COLX,
	/* U+62EC */	JISX0208(0xb3e7),
	/* U+62ED */	JISX0208(0xbfa1),
	/* U+62EE */	JISX0208(0xd9c9),
	/* U+62EF */	JISX0208(0xd9ce),
	/* U+62F0 */	U2E_NODEST_COLX,
	/* U+62F1 */	JISX0208(0xd9ca),
	/* U+62F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf57)),
	/* U+62F3 */	JISX0208(0xb7fd),
	/* U+62F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf58)),
	/* U+62F5 */	JISX0208(0xd9cf),
	/* U+62F6 */	JISX0208(0xbba2),
	/* U+62F7 */	JISX0208(0xb9e9),
	/* U+62F8 */	U2E_NODEST_COLX,
	/* U+62F9 */	U2E_NODEST_COLX,
	/* U+62FA */	U2E_NODEST_COLX,
	/* U+62FB */	U2E_NODEST_COLX,
	/* U+62FC */	IFX0213(JISX0213_1(0xf4eb),	JISX0212(0xbf59)),
	/* U+62FD */	IFX0213(JISX0213_2(0xad25),	JISX0212(0xbf5a)),
	/* U+62FE */	JISX0208(0xbda6),
	/* U+62FF */	JISX0208(0xd9bd),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_63[] = {
	/* U+6300 */	U2E_NODEST_COLX,
	/* U+6301 */	JISX0208(0xbbfd),
	/* U+6302 */	JISX0208(0xd9cc),
	/* U+6303 */	IFX0213(JISX0213_2(0xad26),	JISX0212(0xbf5b)),
	/* U+6304 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf5c)),
	/* U+6305 */	U2E_NODEST_COLX,
	/* U+6306 */	U2E_NODEST_COLX,
	/* U+6307 */	JISX0208(0xbbd8),
	/* U+6308 */	JISX0208(0xd9cd),
	/* U+6309 */	JISX0208(0xb0c4),
	/* U+630A */	IFX0213(JISX0213_1(0xf4ec),	JISX0212(0xbf5d)),
	/* U+630B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf5e)),
	/* U+630C */	JISX0208(0xd9c8),
	/* U+630D */	IFX0213(JISX0213_2(0xad27),	JISX0212(0xbf5f)),
	/* U+630E */	U2E_NODEST_COLX,
	/* U+630F */	U2E_NODEST_COLX,
	/* U+6310 */	IFX0213(JISX0213_2(0xad28),	JISX0212(0xbf60)),
	/* U+6311 */	JISX0208(0xc4a9),
	/* U+6312 */	U2E_NODEST_COLX,
	/* U+6313 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf61)),
	/* U+6314 */	U2E_NODEST_COLX,
	/* U+6315 */	U2E_NODEST_COLX,
	/* U+6316 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf62)),
	/* U+6317 */	U2E_NODEST_COLX,
	/* U+6318 */	IFX0213(JISX0213_1(0xf4ed),	JISX0212(0xbf63)),
	/* U+6319 */	JISX0208(0xb5f3),
	/* U+631A */	U2E_NODEST_COLX,
	/* U+631B */	U2E_NODEST_COLX,
	/* U+631C */	U2E_NODEST_COLX,
	/* U+631D */	U2E_NODEST_COLX,
	/* U+631E */	U2E_NODEST_COLX,
	/* U+631F */	JISX0208(0xb6b4),
	/* U+6320 */	U2E_NODEST_COLX,
	/* U+6321 */	U2E_NODEST_COLX,
	/* U+6322 */	U2E_NODEST_COLX,
	/* U+6323 */	U2E_NODEST_COLX,
	/* U+6324 */	U2E_NODEST_COLX,
	/* U+6325 */	U2E_NODEST_COLX,
	/* U+6326 */	U2E_NODEST_COLX,
	/* U+6327 */	JISX0208(0xd9cb),
	/* U+6328 */	JISX0208(0xb0a7),
	/* U+6329 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf64)),
	/* U+632A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf65)),
	/* U+632B */	JISX0208(0xbac3),
	/* U+632C */	U2E_NODEST_COLX,
	/* U+632D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf66)),
	/* U+632E */	U2E_NODEST_COLX,
	/* U+632F */	JISX0208(0xbfb6),
	/* U+6330 */	U2E_NODEST_COLX,
	/* U+6331 */	U2E_NODEST_COLX,
	/* U+6332 */	IFX0213(JISX0213_2(0xad2b),	U2E_NODEST_COLX),
	/* U+6333 */	U2E_NODEST_COLX,
	/* U+6334 */	U2E_NODEST_COLX,
	/* U+6335 */	IFX0213(JISX0213_2(0xad2c),	JISX0212(0xbf67)),
	/* U+6336 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf68)),
	/* U+6337 */	U2E_NODEST_COLX,
	/* U+6338 */	U2E_NODEST_COLX,
	/* U+6339 */	IFX0213(JISX0213_1(0xf4ee),	JISX0212(0xbf69)),
	/* U+633A */	JISX0208(0xc4f2),
	/* U+633B */	IFX0213(JISX0213_2(0xad2d),	U2E_NODEST_COLX),
	/* U+633C */	IFX0213(JISX0213_2(0xad2e),	JISX0212(0xbf6a)),
	/* U+633D */	JISX0208(0xc8d4),
	/* U+633E */	JISX0208(0xd9d1),
	/* U+633F */	JISX0208(0xc1de),
	/* U+6340 */	U2E_NODEST_COLX,
	/* U+6341 */	IFX0213(JISX0213_2(0xad2f),	JISX0212(0xbf6b)),
	/* U+6342 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf6c)),
	/* U+6343 */	IFX0213(JISX0213_1(0xf4ef),	JISX0212(0xbf6d)),
	/* U+6344 */	IFX0213(JISX0213_2(0xad30),	JISX0212(0xbf6e)),
	/* U+6345 */	U2E_NODEST_COLX,
	/* U+6346 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf6f)),
	/* U+6347 */	U2E_NODEST_COLX,
	/* U+6348 */	U2E_NODEST_COLX,
	/* U+6349 */	JISX0208(0xc2aa),
	/* U+634A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf70)),
	/* U+634B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf71)),
	/* U+634C */	JISX0208(0xbbab),
	/* U+634D */	JISX0208(0xd9d2),
	/* U+634E */	IFX0213(JISX0213_2(0xad31),	JISX0212(0xbf72)),
	/* U+634F */	JISX0208(0xd9d4),
	/* U+6350 */	JISX0208(0xd9d0),
	/* U+6351 */	U2E_NODEST_COLX,
	/* U+6352 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf73)),
	/* U+6353 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf74)),
	/* U+6354 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf75)),
	/* U+6355 */	JISX0208(0xcae1),
	/* U+6356 */	U2E_NODEST_COLX,
	/* U+6357 */	JISX0208(0xc4bd),
	/* U+6358 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf76)),
	/* U+6359 */	IFX0213(JISX0213_2(0xad33),	U2E_NODEST_COLX),
	/* U+635A */	U2E_NODEST_COLX,
	/* U+635B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf77)),
	/* U+635C */	JISX0208(0xc1dc),
	/* U+635D */	U2E_NODEST_COLX,
	/* U+635E */	U2E_NODEST_COLX,
	/* U+635F */	U2E_NODEST_COLX,
	/* U+6360 */	U2E_NODEST_COLX,
	/* U+6361 */	U2E_NODEST_COLX,
	/* U+6362 */	U2E_NODEST_COLX,
	/* U+6363 */	U2E_NODEST_COLX,
	/* U+6364 */	U2E_NODEST_COLX,
	/* U+6365 */	IFX0213(JISX0213_1(0xf4f0),	JISX0212(0xbf78)),
	/* U+6366 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf79)),
	/* U+6367 */	JISX0208(0xcafb),
	/* U+6368 */	JISX0208(0xbcce),
	/* U+6369 */	JISX0208(0xd9e0),
	/* U+636A */	U2E_NODEST_COLX,
	/* U+636B */	JISX0208(0xd9df),
	/* U+636C */	IFX0213(JISX0213_2(0xad36),	JISX0212(0xbf7a)),
	/* U+636D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf7b)),
	/* U+636E */	JISX0208(0xbff8),
	/* U+636F */	U2E_NODEST_COLX,
	/* U+6370 */	U2E_NODEST_COLX,
	/* U+6371 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf7c)),
	/* U+6372 */	JISX0208(0xb7fe),
	/* U+6373 */	U2E_NODEST_COLX,
	/* U+6374 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf7d)),
	/* U+6375 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xbf7e)),
	/* U+6376 */	JISX0208(0xd9d9),
	/* U+6377 */	JISX0208(0xbeb9),
	/* U+6378 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc021)),
	/* U+6379 */	U2E_NODEST_COLX,
	/* U+637A */	JISX0208(0xc6e8),
	/* U+637B */	JISX0208(0xc7b1),
	/* U+637C */	IFX0213(JISX0213_1(0xf4f1),	JISX0212(0xc022)),
	/* U+637D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc023)),
	/* U+637E */	U2E_NODEST_COLX,
	/* U+637F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc024)),
	/* U+6380 */	JISX0208(0xd9d7),
	/* U+6381 */	U2E_NODEST_COLX,
	/* U+6382 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc025)),
	/* U+6383 */	JISX0208(0xc1dd),
	/* U+6384 */	IFX0213(JISX0213_2(0xad37),	JISX0212(0xc026)),
	/* U+6385 */	U2E_NODEST_COLX,
	/* U+6386 */	U2E_NODEST_COLX,
	/* U+6387 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc027)),
	/* U+6388 */	JISX0208(0xbcf8),
	/* U+6389 */	JISX0208(0xd9dc),
	/* U+638A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc028)),
	/* U+638B */	U2E_NODEST_COLX,
	/* U+638C */	JISX0208(0xbeb8),
	/* U+638D */	U2E_NODEST_COLX,
	/* U+638E */	JISX0208(0xd9d6),
	/* U+638F */	JISX0208(0xd9db),
	/* U+6390 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc029)),
	/* U+6391 */	U2E_NODEST_COLX,
	/* U+6392 */	JISX0208(0xc7d3),
	/* U+6393 */	U2E_NODEST_COLX,
	/* U+6394 */	IFX0213(JISX0213_2(0xad3a),	JISX0212(0xc02a)),
	/* U+6395 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc02b)),
	/* U+6396 */	JISX0208(0xd9d5),
	/* U+6397 */	U2E_NODEST_COLX,
	/* U+6398 */	JISX0208(0xb7a1),
	/* U+6399 */	IFX0213(JISX0213_2(0xad38),	JISX0212(0xc02c)),
	/* U+639A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc02d)),
	/* U+639B */	JISX0208(0xb3dd),
	/* U+639C */	U2E_NODEST_COLX,
	/* U+639D */	U2E_NODEST_COLX,
	/* U+639E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc02e)),
	/* U+639F */	JISX0208(0xd9dd),
	/* U+63A0 */	JISX0208(0xceab),
	/* U+63A1 */	JISX0208(0xbace),
	/* U+63A2 */	JISX0208(0xc3b5),
	/* U+63A3 */	JISX0208(0xd9da),
	/* U+63A4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc02f)),
	/* U+63A5 */	JISX0208(0xc0dc),
	/* U+63A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc030)),
	/* U+63A7 */	JISX0208(0xb9b5),
	/* U+63A8 */	JISX0208(0xbfe4),
	/* U+63A9 */	JISX0208(0xb1e6),
	/* U+63AA */	JISX0208(0xc1bc),
	/* U+63AB */	JISX0208(0xd9d8),
	/* U+63AC */	JISX0208(0xb5c5),
	/* U+63AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc031)),
	/* U+63AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc032)),
	/* U+63AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc033)),
	/* U+63B0 */	U2E_NODEST_COLX,
	/* U+63B1 */	U2E_NODEST_COLX,
	/* U+63B2 */	JISX0208(0xb7c7),
	/* U+63B3 */	U2E_NODEST_COLX,
	/* U+63B4 */	JISX0208(0xc4cf),
	/* U+63B5 */	JISX0208(0xd9de),
	/* U+63B6 */	U2E_NODEST_COLX,
	/* U+63B7 */	U2E_NODEST_COLX,
	/* U+63B8 */	U2E_NODEST_COLX,
	/* U+63B9 */	U2E_NODEST_COLX,
	/* U+63BA */	U2E_NODEST_COLX,
	/* U+63BB */	JISX0208(0xc1df),
	/* U+63BC */	U2E_NODEST_COLX,
	/* U+63BD */	IFX0213(JISX0213_2(0xad3b),	JISX0212(0xc034)),
	/* U+63BE */	JISX0208(0xd9e1),
	/* U+63BF */	U2E_NODEST_COLX,
	/* U+63C0 */	JISX0208(0xd9e3),
	/* U+63C1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc035)),
	/* U+63C2 */	U2E_NODEST_COLX,
	/* U+63C3 */	JISX0208(0xc2b7),
	/* U+63C4 */	JISX0208(0xd9e9),
	/* U+63C5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc036)),
	/* U+63C6 */	JISX0208(0xd9e4),
	/* U+63C7 */	U2E_NODEST_COLX,
	/* U+63C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc037)),
	/* U+63C9 */	JISX0208(0xd9e6),
	/* U+63CA */	U2E_NODEST_COLX,
	/* U+63CB */	U2E_NODEST_COLX,
	/* U+63CC */	U2E_NODEST_COLX,
	/* U+63CD */	U2E_NODEST_COLX,
	/* U+63CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc038)),
	/* U+63CF */	JISX0208(0xc9c1),
	/* U+63D0 */	JISX0208(0xc4f3),
	/* U+63D1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc039)),
	/* U+63D2 */	JISX0208(0xd9e7),
	/* U+63D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc03a)),
	/* U+63D4 */	IFX0213(JISX0213_2(0xad3d),	JISX0212(0xc03b)),
	/* U+63D5 */	IFX0213(JISX0213_2(0xad3e),	JISX0212(0xc03c)),
	/* U+63D6 */	JISX0208(0xcdac),
	/* U+63D7 */	U2E_NODEST_COLX,
	/* U+63D8 */	U2E_NODEST_COLX,
	/* U+63D9 */	U2E_NODEST_COLX,
	/* U+63DA */	JISX0208(0xcdc8),
	/* U+63DB */	JISX0208(0xb4b9),
	/* U+63DC */	IFX0213(JISX0213_2(0xad3f),	JISX0212(0xc03d)),
	/* U+63DD */	U2E_NODEST_COLX,
	/* U+63DE */	U2E_NODEST_COLX,
	/* U+63DF */	U2E_NODEST_COLX,
	/* U+63E0 */	IFX0213(JISX0213_2(0xad40),	JISX0212(0xc03e)),
	/* U+63E1 */	JISX0208(0xb0ae),
	/* U+63E2 */	U2E_NODEST_COLX,
	/* U+63E3 */	JISX0208(0xd9e5),
	/* U+63E4 */	U2E_NODEST_COLX,
	/* U+63E5 */	IFX0213(JISX0213_1(0xf4f2),	JISX0212(0xc03f)),
	/* U+63E6 */	U2E_NODEST_COLX,
	/* U+63E7 */	U2E_NODEST_COLX,
	/* U+63E8 */	U2E_NODEST_COLX,
	/* U+63E9 */	JISX0208(0xd9e2),
	/* U+63EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc040)),
	/* U+63EB */	IFX0213(JISX0213_2(0xad41),	U2E_NODEST_COLX),
	/* U+63EC */	IFX0213(JISX0213_2(0xad42),	JISX0212(0xc041)),
	/* U+63ED */	IFX0213(JISX0213_1(0xf4f3),	U2E_NODEST_COLX),
	/* U+63EE */	JISX0208(0xb4f8),
	/* U+63EF */	U2E_NODEST_COLX,
	/* U+63F0 */	U2E_NODEST_COLX,
	/* U+63F1 */	U2E_NODEST_COLX,
	/* U+63F2 */	IFX0213(JISX0213_2(0xad43),	JISX0212(0xc042)),
	/* U+63F3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc043)),
	/* U+63F4 */	JISX0208(0xb1e7),
	/* U+63F5 */	IFX0213(JISX0213_1(0xf4f4),	JISX0212(0xc044)),
	/* U+63F6 */	JISX0208(0xd9e8),
	/* U+63F7 */	IFX0213(JISX0213_2(0xad3c),	U2E_NODEST_COLX),
	/* U+63F8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc045)),
	/* U+63F9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc046)),
	/* U+63FA */	JISX0208(0xcdc9),
	/* U+63FB */	U2E_NODEST_COLX,
	/* U+63FC */	U2E_NODEST_COLX,
	/* U+63FD */	U2E_NODEST_COLX,
	/* U+63FE */	U2E_NODEST_COLX,
	/* U+63FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_64[] = {
	/* U+6400 */	U2E_NODEST_COLX,
	/* U+6401 */	U2E_NODEST_COLX,
	/* U+6402 */	U2E_NODEST_COLX,
	/* U+6403 */	U2E_NODEST_COLX,
	/* U+6404 */	U2E_NODEST_COLX,
	/* U+6405 */	U2E_NODEST_COLX,
	/* U+6406 */	JISX0208(0xd9ec),
	/* U+6407 */	U2E_NODEST_COLX,
	/* U+6408 */	U2E_NODEST_COLX,
	/* U+6409 */	IFX0213(JISX0213_2(0xad44),	JISX0212(0xc047)),
	/* U+640A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc048)),
	/* U+640B */	U2E_NODEST_COLX,
	/* U+640C */	U2E_NODEST_COLX,
	/* U+640D */	JISX0208(0xc2bb),
	/* U+640E */	U2E_NODEST_COLX,
	/* U+640F */	JISX0208(0xd9f3),
	/* U+6410 */	IFX0213(JISX0213_1(0xf4f5),	JISX0212(0xc049)),
	/* U+6411 */	U2E_NODEST_COLX,
	/* U+6412 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc04a)),
	/* U+6413 */	JISX0208(0xd9ed),
	/* U+6414 */	IFX0213(JISX0213_1(0xf4f6),	JISX0212(0xc04b)),
	/* U+6415 */	U2E_NODEST_COLX,
	/* U+6416 */	JISX0208(0xd9ea),
	/* U+6417 */	JISX0208(0xd9f1),
	/* U+6418 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc04c)),
	/* U+6419 */	U2E_NODEST_COLX,
	/* U+641A */	U2E_NODEST_COLX,
	/* U+641B */	U2E_NODEST_COLX,
	/* U+641C */	JISX0208(0xd9d3),
	/* U+641D */	U2E_NODEST_COLX,
	/* U+641E */	IFX0213(JISX0213_2(0xad45),	JISX0212(0xc04d)),
	/* U+641F */	U2E_NODEST_COLX,
	/* U+6420 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc04e)),
	/* U+6421 */	U2E_NODEST_COLX,
	/* U+6422 */	IFX0213(JISX0213_1(0xf4f7),	JISX0212(0xc04f)),
	/* U+6423 */	U2E_NODEST_COLX,
	/* U+6424 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc050)),
	/* U+6425 */	IFX0213(JISX0213_2(0xad46),	JISX0212(0xc051)),
	/* U+6426 */	JISX0208(0xd9ee),
	/* U+6427 */	U2E_NODEST_COLX,
	/* U+6428 */	JISX0208(0xd9f2),
	/* U+6429 */	IFX0213(JISX0213_2(0xad47),	JISX0212(0xc052)),
	/* U+642A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc053)),
	/* U+642B */	U2E_NODEST_COLX,
	/* U+642C */	JISX0208(0xc8c2),
	/* U+642D */	JISX0208(0xc5eb),
	/* U+642E */	U2E_NODEST_COLX,
	/* U+642F */	IFX0213(JISX0213_2(0xad48),	JISX0212(0xc054)),
	/* U+6430 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc055)),
	/* U+6431 */	U2E_NODEST_COLX,
	/* U+6432 */	U2E_NODEST_COLX,
	/* U+6433 */	U2E_NODEST_COLX,
	/* U+6434 */	JISX0208(0xd9eb),
	/* U+6435 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc056)),
	/* U+6436 */	JISX0208(0xd9ef),
	/* U+6437 */	U2E_NODEST_COLX,
	/* U+6438 */	U2E_NODEST_COLX,
	/* U+6439 */	U2E_NODEST_COLX,
	/* U+643A */	JISX0208(0xb7c8),
	/* U+643B */	U2E_NODEST_COLX,
	/* U+643C */	U2E_NODEST_COLX,
	/* U+643D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc057)),
	/* U+643E */	JISX0208(0xbaf1),
	/* U+643F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc058)),
	/* U+6440 */	U2E_NODEST_COLX,
	/* U+6441 */	U2E_NODEST_COLX,
	/* U+6442 */	JISX0208(0xc0dd),
	/* U+6443 */	U2E_NODEST_COLX,
	/* U+6444 */	U2E_NODEST_COLX,
	/* U+6445 */	U2E_NODEST_COLX,
	/* U+6446 */	U2E_NODEST_COLX,
	/* U+6447 */	U2E_NODEST_COLX,
	/* U+6448 */	U2E_NODEST_COLX,
	/* U+6449 */	U2E_NODEST_COLX,
	/* U+644A */	U2E_NODEST_COLX,
	/* U+644B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc059)),
	/* U+644C */	U2E_NODEST_COLX,
	/* U+644D */	U2E_NODEST_COLX,
	/* U+644E */	JISX0208(0xd9f7),
	/* U+644F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc05a)),
	/* U+6450 */	U2E_NODEST_COLX,
	/* U+6451 */	IFX0213(JISX0213_1(0xf4f9),	JISX0212(0xc05b)),
	/* U+6452 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc05c)),
	/* U+6453 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc05d)),
	/* U+6454 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc05e)),
	/* U+6455 */	U2E_NODEST_COLX,
	/* U+6456 */	U2E_NODEST_COLX,
	/* U+6457 */	U2E_NODEST_COLX,
	/* U+6458 */	JISX0208(0xc5a6),
	/* U+6459 */	U2E_NODEST_COLX,
	/* U+645A */	IFX0213(JISX0213_2(0xad49),	JISX0212(0xc05f)),
	/* U+645B */	IFX0213(JISX0213_2(0xad4a),	JISX0212(0xc060)),
	/* U+645C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc061)),
	/* U+645D */	IFX0213(JISX0213_2(0xad4b),	JISX0212(0xc062)),
	/* U+645E */	U2E_NODEST_COLX,
	/* U+645F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc063)),
	/* U+6460 */	IFX0213(JISX0213_1(0xf4fa),	JISX0212(0xc064)),
	/* U+6461 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc065)),
	/* U+6462 */	U2E_NODEST_COLX,
	/* U+6463 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc066)),
	/* U+6464 */	U2E_NODEST_COLX,
	/* U+6465 */	U2E_NODEST_COLX,
	/* U+6466 */	U2E_NODEST_COLX,
	/* U+6467 */	JISX0208(0xd9f4),
	/* U+6468 */	U2E_NODEST_COLX,
	/* U+6469 */	JISX0208(0xcbe0),
	/* U+646A */	U2E_NODEST_COLX,
	/* U+646B */	U2E_NODEST_COLX,
	/* U+646C */	U2E_NODEST_COLX,
	/* U+646D */	IFX0213(JISX0213_1(0xf4fb),	JISX0212(0xc067)),
	/* U+646E */	U2E_NODEST_COLX,
	/* U+646F */	JISX0208(0xd9f5),
	/* U+6470 */	U2E_NODEST_COLX,
	/* U+6471 */	U2E_NODEST_COLX,
	/* U+6472 */	U2E_NODEST_COLX,
	/* U+6473 */	IFX0213(JISX0213_2(0xad4c),	JISX0212(0xc068)),
	/* U+6474 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc069)),
	/* U+6475 */	U2E_NODEST_COLX,
	/* U+6476 */	JISX0208(0xd9f6),
	/* U+6477 */	U2E_NODEST_COLX,
	/* U+6478 */	JISX0208(0xccce),
	/* U+6479 */	IFX0213(JISX0213_1(0xf4f8),	U2E_NODEST_COLX),
	/* U+647A */	JISX0208(0xc0a2),
	/* U+647B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc06a)),
	/* U+647C */	U2E_NODEST_COLX,
	/* U+647D */	IFX0213(JISX0213_2(0xad4d),	JISX0212(0xc06b)),
	/* U+647E */	U2E_NODEST_COLX,
	/* U+647F */	U2E_NODEST_COLX,
	/* U+6480 */	U2E_NODEST_COLX,
	/* U+6481 */	U2E_NODEST_COLX,
	/* U+6482 */	U2E_NODEST_COLX,
	/* U+6483 */	JISX0208(0xb7e2),
	/* U+6484 */	U2E_NODEST_COLX,
	/* U+6485 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc06c)),
	/* U+6486 */	U2E_NODEST_COLX,
	/* U+6487 */	IFX0213(JISX0213_2(0xad4e),	JISX0212(0xc06d)),
	/* U+6488 */	JISX0208(0xd9fd),
	/* U+6489 */	U2E_NODEST_COLX,
	/* U+648A */	U2E_NODEST_COLX,
	/* U+648B */	U2E_NODEST_COLX,
	/* U+648C */	U2E_NODEST_COLX,
	/* U+648D */	U2E_NODEST_COLX,
	/* U+648E */	U2E_NODEST_COLX,
	/* U+648F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc06e)),
	/* U+6490 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc06f)),
	/* U+6491 */	IFX0213(JISX0213_2(0xad4f),	JISX0212(0xc070)),
	/* U+6492 */	JISX0208(0xbbb5),
	/* U+6493 */	JISX0208(0xd9fa),
	/* U+6494 */	U2E_NODEST_COLX,
	/* U+6495 */	JISX0208(0xd9f9),
	/* U+6496 */	U2E_NODEST_COLX,
	/* U+6497 */	U2E_NODEST_COLX,
	/* U+6498 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc071)),
	/* U+6499 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc072)),
	/* U+649A */	JISX0208(0xc7b2),
	/* U+649B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc073)),
	/* U+649C */	U2E_NODEST_COLX,
	/* U+649D */	IFX0213(JISX0213_2(0xad50),	JISX0212(0xc074)),
	/* U+649E */	JISX0208(0xc6b5),
	/* U+649F */	IFX0213(JISX0213_2(0xad51),	JISX0212(0xc075)),
	/* U+64A0 */	U2E_NODEST_COLX,
	/* U+64A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc076)),
	/* U+64A2 */	U2E_NODEST_COLX,
	/* U+64A3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc077)),
	/* U+64A4 */	JISX0208(0xc5b1),
	/* U+64A5 */	JISX0208(0xd9fb),
	/* U+64A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc078)),
	/* U+64A7 */	U2E_NODEST_COLX,
	/* U+64A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc079)),
	/* U+64A9 */	JISX0208(0xd9fc),
	/* U+64AA */	U2E_NODEST_COLX,
	/* U+64AB */	JISX0208(0xc9ef),
	/* U+64AC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc07a)),
	/* U+64AD */	JISX0208(0xc7c5),
	/* U+64AE */	JISX0208(0xbba3),
	/* U+64AF */	U2E_NODEST_COLX,
	/* U+64B0 */	JISX0208(0xc0f1),
	/* U+64B1 */	U2E_NODEST_COLX,
	/* U+64B2 */	JISX0208(0xcbd0),
	/* U+64B3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc07b)),
	/* U+64B4 */	U2E_NODEST_COLX,
	/* U+64B5 */	U2E_NODEST_COLX,
	/* U+64B6 */	U2E_NODEST_COLX,
	/* U+64B7 */	U2E_NODEST_COLX,
	/* U+64B8 */	U2E_NODEST_COLX,
	/* U+64B9 */	JISX0208(0xb3c9),
	/* U+64BA */	U2E_NODEST_COLX,
	/* U+64BB */	JISX0208(0xdaa5),
	/* U+64BC */	JISX0208(0xd9fe),
	/* U+64BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc07c)),
	/* U+64BE */	IFX0213(JISX0213_1(0xf4fd),	JISX0212(0xc07d)),
	/* U+64BF */	IFX0213(JISX0213_1(0xf4fe),	JISX0212(0xc07e)),
	/* U+64C0 */	U2E_NODEST_COLX,
	/* U+64C1 */	JISX0208(0xcdca),
	/* U+64C2 */	JISX0208(0xdaa7),
	/* U+64C3 */	U2E_NODEST_COLX,
	/* U+64C4 */	IFX0213(JISX0213_1(0xf5a1),	JISX0212(0xc121)),
	/* U+64C5 */	JISX0208(0xdaa3),
	/* U+64C6 */	U2E_NODEST_COLX,
	/* U+64C7 */	JISX0208(0xdaa4),
	/* U+64C8 */	U2E_NODEST_COLX,
	/* U+64C9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc122)),
	/* U+64CA */	IFX0213(JISX0213_1(0xf5a2),	JISX0212(0xc123)),
	/* U+64CB */	IFX0213(JISX0213_2(0xad52),	JISX0212(0xc124)),
	/* U+64CC */	IFX0213(JISX0213_2(0xad53),	JISX0212(0xc125)),
	/* U+64CD */	JISX0208(0xc1e0),
	/* U+64CE */	IFX0213(JISX0213_1(0xf4fc),	JISX0212(0xc126)),
	/* U+64CF */	U2E_NODEST_COLX,
	/* U+64D0 */	IFX0213(JISX0213_1(0xf5a3),	JISX0212(0xc127)),
	/* U+64D1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc128)),
	/* U+64D2 */	JISX0208(0xdaa2),
	/* U+64D3 */	U2E_NODEST_COLX,
	/* U+64D4 */	JISX0208(0xd9bf),
	/* U+64D5 */	IFX0213(JISX0213_2(0xad54),	JISX0212(0xc129)),
	/* U+64D6 */	U2E_NODEST_COLX,
	/* U+64D7 */	IFX0213(JISX0213_2(0xad55),	JISX0212(0xc12a)),
	/* U+64D8 */	JISX0208(0xdaa6),
	/* U+64D9 */	U2E_NODEST_COLX,
	/* U+64DA */	JISX0208(0xdaa1),
	/* U+64DB */	U2E_NODEST_COLX,
	/* U+64DC */	U2E_NODEST_COLX,
	/* U+64DD */	U2E_NODEST_COLX,
	/* U+64DE */	U2E_NODEST_COLX,
	/* U+64DF */	U2E_NODEST_COLX,
	/* U+64E0 */	JISX0208(0xdaab),
	/* U+64E1 */	JISX0208(0xdaac),
	/* U+64E2 */	JISX0208(0xc5a7),
	/* U+64E3 */	JISX0208(0xdaae),
	/* U+64E4 */	IFX0213(JISX0213_2(0xad57),	JISX0212(0xc12b)),
	/* U+64E5 */	IFX0213(JISX0213_2(0xad58),	JISX0212(0xc12c)),
	/* U+64E6 */	JISX0208(0xbba4),
	/* U+64E7 */	JISX0208(0xdaa9),
	/* U+64E8 */	U2E_NODEST_COLX,
	/* U+64E9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc12d)),
	/* U+64EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc12e)),
	/* U+64EB */	U2E_NODEST_COLX,
	/* U+64EC */	JISX0208(0xb5bc),
	/* U+64ED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc12f)),
	/* U+64EE */	U2E_NODEST_COLX,
	/* U+64EF */	JISX0208(0xdaaf),
	/* U+64F0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc130)),
	/* U+64F1 */	JISX0208(0xdaa8),
	/* U+64F2 */	JISX0208(0xdab3),
	/* U+64F3 */	U2E_NODEST_COLX,
	/* U+64F4 */	JISX0208(0xdab2),
	/* U+64F5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc131)),
	/* U+64F6 */	JISX0208(0xdab1),
	/* U+64F7 */	IFX0213(JISX0213_1(0xf5a4),	JISX0212(0xc132)),
	/* U+64F8 */	U2E_NODEST_COLX,
	/* U+64F9 */	U2E_NODEST_COLX,
	/* U+64FA */	JISX0208(0xdab4),
	/* U+64FB */	IFX0213(JISX0213_1(0xf5a5),	JISX0212(0xc133)),
	/* U+64FC */	U2E_NODEST_COLX,
	/* U+64FD */	JISX0208(0xdab6),
	/* U+64FE */	JISX0208(0xbef1),
	/* U+64FF */	IFX0213(JISX0213_2(0xad59),	JISX0212(0xc134)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_65[] = {
	/* U+6500 */	JISX0208(0xdab5),
	/* U+6501 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc135)),
	/* U+6502 */	U2E_NODEST_COLX,
	/* U+6503 */	U2E_NODEST_COLX,
	/* U+6504 */	IFX0213(JISX0213_2(0xad5a),	JISX0212(0xc136)),
	/* U+6505 */	JISX0208(0xdab9),
	/* U+6506 */	U2E_NODEST_COLX,
	/* U+6507 */	U2E_NODEST_COLX,
	/* U+6508 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc137)),
	/* U+6509 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc138)),
	/* U+650A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc139)),
	/* U+650B */	U2E_NODEST_COLX,
	/* U+650C */	U2E_NODEST_COLX,
	/* U+650D */	U2E_NODEST_COLX,
	/* U+650E */	U2E_NODEST_COLX,
	/* U+650F */	IFX0213(JISX0213_2(0xad5c),	JISX0212(0xc13a)),
	/* U+6510 */	U2E_NODEST_COLX,
	/* U+6511 */	U2E_NODEST_COLX,
	/* U+6512 */	U2E_NODEST_COLX,
	/* U+6513 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc13b)),
	/* U+6514 */	IFX0213(JISX0213_2(0xad5d),	JISX0212(0xc13c)),
	/* U+6515 */	U2E_NODEST_COLX,
	/* U+6516 */	IFX0213(JISX0213_2(0xad5e),	JISX0212(0xc13d)),
	/* U+6517 */	U2E_NODEST_COLX,
	/* U+6518 */	JISX0208(0xdab7),
	/* U+6519 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc13e)),
	/* U+651A */	U2E_NODEST_COLX,
	/* U+651B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc13f)),
	/* U+651C */	JISX0208(0xdab8),
	/* U+651D */	JISX0208(0xd9f0),
	/* U+651E */	IFX0213(JISX0213_2(0xad60),	JISX0212(0xc140)),
	/* U+651F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc141)),
	/* U+6520 */	U2E_NODEST_COLX,
	/* U+6521 */	U2E_NODEST_COLX,
	/* U+6522 */	IFX0213(JISX0213_1(0xf5a6),	JISX0212(0xc142)),
	/* U+6523 */	JISX0208(0xdabb),
	/* U+6524 */	JISX0208(0xdaba),
	/* U+6525 */	U2E_NODEST_COLX,
	/* U+6526 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc143)),
	/* U+6527 */	U2E_NODEST_COLX,
	/* U+6528 */	U2E_NODEST_COLX,
	/* U+6529 */	IFX0213(JISX0213_1(0xf5a7),	JISX0212(0xc144)),
	/* U+652A */	JISX0208(0xd9f8),
	/* U+652B */	JISX0208(0xdabc),
	/* U+652C */	JISX0208(0xdab0),
	/* U+652D */	U2E_NODEST_COLX,
	/* U+652E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc145)),
	/* U+652F */	JISX0208(0xbbd9),
	/* U+6530 */	U2E_NODEST_COLX,
	/* U+6531 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc146)),
	/* U+6532 */	IFX0213(JISX0213_2(0xad61),	U2E_NODEST_COLX),
	/* U+6533 */	U2E_NODEST_COLX,
	/* U+6534 */	JISX0208(0xdabd),
	/* U+6535 */	JISX0208(0xdabe),
	/* U+6536 */	JISX0208(0xdac0),
	/* U+6537 */	JISX0208(0xdabf),
	/* U+6538 */	JISX0208(0xdac1),
	/* U+6539 */	JISX0208(0xb2fe),
	/* U+653A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc147)),
	/* U+653B */	JISX0208(0xb9b6),
	/* U+653C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc148)),
	/* U+653D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc149)),
	/* U+653E */	JISX0208(0xcafc),
	/* U+653F */	JISX0208(0xc0af),
	/* U+6540 */	U2E_NODEST_COLX,
	/* U+6541 */	U2E_NODEST_COLX,
	/* U+6542 */	U2E_NODEST_COLX,
	/* U+6543 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc14a)),
	/* U+6544 */	IFX0213(JISX0213_2(0xad62),	U2E_NODEST_COLX),
	/* U+6545 */	JISX0208(0xb8ce),
	/* U+6546 */	U2E_NODEST_COLX,
	/* U+6547 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc14b)),
	/* U+6548 */	JISX0208(0xdac3),
	/* U+6549 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc14c)),
	/* U+654A */	U2E_NODEST_COLX,
	/* U+654B */	U2E_NODEST_COLX,
	/* U+654C */	U2E_NODEST_COLX,
	/* U+654D */	JISX0208(0xdac6),
	/* U+654E */	IFX0213(U2E_NODEST_COLX,	IBM(0xf441)),
	/* U+654F */	JISX0208(0xc9d2),
	/* U+6550 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc14d)),
	/* U+6551 */	JISX0208(0xb5df),
	/* U+6552 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc14e)),
	/* U+6553 */	U2E_NODEST_COLX,
	/* U+6554 */	IFX0213(JISX0213_2(0xad63),	JISX0212(0xc14f)),
	/* U+6555 */	JISX0208(0xdac5),
	/* U+6556 */	JISX0208(0xdac4),
	/* U+6557 */	JISX0208(0xc7d4),
	/* U+6558 */	JISX0208(0xdac7),
	/* U+6559 */	JISX0208(0xb6b5),
	/* U+655A */	U2E_NODEST_COLX,
	/* U+655B */	U2E_NODEST_COLX,
	/* U+655C */	U2E_NODEST_COLX,
	/* U+655D */	JISX0208(0xdac9),
	/* U+655E */	JISX0208(0xdac8),
	/* U+655F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc150)),
	/* U+6560 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc151)),
	/* U+6561 */	U2E_NODEST_COLX,
	/* U+6562 */	JISX0208(0xb4ba),
	/* U+6563 */	JISX0208(0xbbb6),
	/* U+6564 */	U2E_NODEST_COLX,
	/* U+6565 */	U2E_NODEST_COLX,
	/* U+6566 */	JISX0208(0xc6d8),
	/* U+6567 */	IFX0213(JISX0213_1(0xf5a9),	JISX0212(0xc152)),
	/* U+6568 */	U2E_NODEST_COLX,
	/* U+6569 */	U2E_NODEST_COLX,
	/* U+656A */	U2E_NODEST_COLX,
	/* U+656B */	IFX0213(JISX0213_2(0xad64),	JISX0212(0xc153)),
	/* U+656C */	JISX0208(0xb7c9),
	/* U+656D */	U2E_NODEST_COLX,
	/* U+656E */	U2E_NODEST_COLX,
	/* U+656F */	U2E_NODEST_COLX,
	/* U+6570 */	JISX0208(0xbff4),
	/* U+6571 */	U2E_NODEST_COLX,
	/* U+6572 */	JISX0208(0xdaca),
	/* U+6573 */	U2E_NODEST_COLX,
	/* U+6574 */	JISX0208(0xc0b0),
	/* U+6575 */	JISX0208(0xc5a8),
	/* U+6576 */	U2E_NODEST_COLX,
	/* U+6577 */	JISX0208(0xc9df),
	/* U+6578 */	JISX0208(0xdacb),
	/* U+6579 */	U2E_NODEST_COLX,
	/* U+657A */	IFX0213(JISX0213_2(0xad65),	JISX0212(0xc154)),
	/* U+657B */	U2E_NODEST_COLX,
	/* U+657C */	U2E_NODEST_COLX,
	/* U+657D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc155)),
	/* U+657E */	U2E_NODEST_COLX,
	/* U+657F */	U2E_NODEST_COLX,
	/* U+6580 */	U2E_NODEST_COLX,
	/* U+6581 */	IFX0213(JISX0213_2(0xad66),	JISX0212(0xc156)),
	/* U+6582 */	JISX0208(0xdacc),
	/* U+6583 */	JISX0208(0xdacd),
	/* U+6584 */	IFX0213(JISX0213_2(0xad67),	U2E_NODEST_COLX),
	/* U+6585 */	IFX0213(JISX0213_2(0xad68),	JISX0212(0xc157)),
	/* U+6586 */	U2E_NODEST_COLX,
	/* U+6587 */	JISX0208(0xcab8),
	/* U+6588 */	JISX0208(0xd5dd),
	/* U+6589 */	JISX0208(0xc0c6),
	/* U+658A */	IFX0213(JISX0213_2(0xad69),	JISX0212(0xc158)),
	/* U+658B */	U2E_NODEST_COLX,
	/* U+658C */	JISX0208(0xc9cc),
	/* U+658D */	U2E_NODEST_COLX,
	/* U+658E */	JISX0208(0xbad8),
	/* U+658F */	U2E_NODEST_COLX,
	/* U+6590 */	JISX0208(0xc8e5),
	/* U+6591 */	JISX0208(0xc8c3),
	/* U+6592 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc159)),
	/* U+6593 */	U2E_NODEST_COLX,
	/* U+6594 */	U2E_NODEST_COLX,
	/* U+6595 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc15a)),
	/* U+6596 */	U2E_NODEST_COLX,
	/* U+6597 */	JISX0208(0xc5cd),
	/* U+6598 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc15b)),
	/* U+6599 */	JISX0208(0xcec1),
	/* U+659A */	U2E_NODEST_COLX,
	/* U+659B */	JISX0208(0xdacf),
	/* U+659C */	JISX0208(0xbcd0),
	/* U+659D */	IFX0213(JISX0213_1(0xf5aa),	JISX0212(0xc15c)),
	/* U+659E */	U2E_NODEST_COLX,
	/* U+659F */	JISX0208(0xdad0),
	/* U+65A0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc15d)),
	/* U+65A1 */	JISX0208(0xb0b6),
	/* U+65A2 */	U2E_NODEST_COLX,
	/* U+65A3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc15e)),
	/* U+65A4 */	JISX0208(0xb6d4),
	/* U+65A5 */	JISX0208(0xc0cd),
	/* U+65A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc15f)),
	/* U+65A7 */	JISX0208(0xc9e0),
	/* U+65A8 */	U2E_NODEST_COLX,
	/* U+65A9 */	U2E_NODEST_COLX,
	/* U+65AA */	U2E_NODEST_COLX,
	/* U+65AB */	JISX0208(0xdad1),
	/* U+65AC */	JISX0208(0xbbc2),
	/* U+65AD */	JISX0208(0xc3c7),
	/* U+65AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc160)),
	/* U+65AF */	JISX0208(0xbbdb),
	/* U+65B0 */	JISX0208(0xbfb7),
	/* U+65B1 */	U2E_NODEST_COLX,
	/* U+65B2 */	IFX0213(JISX0213_2(0xad6a),	JISX0212(0xc161)),
	/* U+65B3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc162)),
	/* U+65B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc163)),
	/* U+65B5 */	IFX0213(JISX0213_2(0xad6b),	U2E_NODEST_COLX),
	/* U+65B6 */	U2E_NODEST_COLX,
	/* U+65B7 */	JISX0208(0xdad2),
	/* U+65B8 */	IFX0213(JISX0213_2(0xad6c),	U2E_NODEST_COLX),
	/* U+65B9 */	JISX0208(0xcafd),
	/* U+65BA */	U2E_NODEST_COLX,
	/* U+65BB */	U2E_NODEST_COLX,
	/* U+65BC */	JISX0208(0xb1f7),
	/* U+65BD */	JISX0208(0xbbdc),
	/* U+65BE */	U2E_NODEST_COLX,
	/* U+65BF */	IFX0213(JISX0213_2(0xad6d),	JISX0212(0xc164)),
	/* U+65C0 */	U2E_NODEST_COLX,
	/* U+65C1 */	JISX0208(0xdad5),
	/* U+65C2 */	IFX0213(JISX0213_2(0xad6e),	JISX0212(0xc165)),
	/* U+65C3 */	JISX0208(0xdad3),
	/* U+65C4 */	JISX0208(0xdad6),
	/* U+65C5 */	JISX0208(0xceb9),
	/* U+65C6 */	JISX0208(0xdad4),
	/* U+65C7 */	U2E_NODEST_COLX,
	/* U+65C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc166)),
	/* U+65C9 */	IFX0213(JISX0213_2(0xad6f),	JISX0212(0xc167)),
	/* U+65CA */	U2E_NODEST_COLX,
	/* U+65CB */	JISX0208(0xc0fb),
	/* U+65CC */	JISX0208(0xdad7),
	/* U+65CD */	U2E_NODEST_COLX,
	/* U+65CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc168)),
	/* U+65CF */	JISX0208(0xc2b2),
	/* U+65D0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc169)),
	/* U+65D1 */	U2E_NODEST_COLX,
	/* U+65D2 */	JISX0208(0xdad8),
	/* U+65D3 */	U2E_NODEST_COLX,
	/* U+65D4 */	IFX0213(JISX0213_2(0xad70),	JISX0212(0xc16a)),
	/* U+65D5 */	U2E_NODEST_COLX,
	/* U+65D6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc16b)),
	/* U+65D7 */	JISX0208(0xb4fa),
	/* U+65D8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc16c)),
	/* U+65D9 */	JISX0208(0xdada),
	/* U+65DA */	U2E_NODEST_COLX,
	/* U+65DB */	JISX0208(0xdad9),
	/* U+65DC */	U2E_NODEST_COLX,
	/* U+65DD */	U2E_NODEST_COLX,
	/* U+65DE */	U2E_NODEST_COLX,
	/* U+65DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc16d)),
	/* U+65E0 */	JISX0208(0xdadb),
	/* U+65E1 */	JISX0208(0xdadc),
	/* U+65E2 */	JISX0208(0xb4fb),
	/* U+65E3 */	U2E_NODEST_COLX,
	/* U+65E4 */	U2E_NODEST_COLX,
	/* U+65E5 */	JISX0208(0xc6fc),
	/* U+65E6 */	JISX0208(0xc3b6),
	/* U+65E7 */	JISX0208(0xb5ec),
	/* U+65E8 */	JISX0208(0xbbdd),
	/* U+65E9 */	JISX0208(0xc1e1),
	/* U+65EA */	U2E_NODEST_COLX,
	/* U+65EB */	U2E_NODEST_COLX,
	/* U+65EC */	JISX0208(0xbddc),
	/* U+65ED */	JISX0208(0xb0b0),
	/* U+65EE */	U2E_NODEST_COLX,
	/* U+65EF */	U2E_NODEST_COLX,
	/* U+65F0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc16e)),
	/* U+65F1 */	JISX0208(0xdadd),
	/* U+65F2 */	IFX0213(JISX0213_2(0xad72),	JISX0212(0xc16f)),
	/* U+65F3 */	U2E_NODEST_COLX,
	/* U+65F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc170)),
	/* U+65F5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc171)),
	/* U+65F6 */	U2E_NODEST_COLX,
	/* U+65F7 */	U2E_NODEST_COLX,
	/* U+65F8 */	U2E_NODEST_COLX,
	/* U+65F9 */	IFX0213(JISX0213_2(0xad73),	JISX0212(0xc172)),
	/* U+65FA */	JISX0208(0xb2a2),
	/* U+65FB */	JISX0208(0xdae1),
	/* U+65FC */	IFX0213(JISX0213_2(0xad74),	U2E_NODEST_COLX),
	/* U+65FD */	U2E_NODEST_COLX,
	/* U+65FE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc173)),
	/* U+65FF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc174)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_66[] = {
	/* U+6600 */	IFX0213(JISX0213_1(0xf5ac),	JISX0212(0xc175)),
	/* U+6601 */	U2E_NODEST_COLX,
	/* U+6602 */	JISX0208(0xb9b7),
	/* U+6603 */	JISX0208(0xdae0),
	/* U+6604 */	IFX0213(JISX0213_2(0xad75),	JISX0212(0xc176)),
	/* U+6605 */	U2E_NODEST_COLX,
	/* U+6606 */	JISX0208(0xbaab),
	/* U+6607 */	JISX0208(0xbeba),
	/* U+6608 */	IFX0213(JISX0213_2(0xad76),	JISX0212(0xc177)),
	/* U+6609 */	IFX0213(JISX0213_1(0xf5ad),	JISX0212(0xc178)),
	/* U+660A */	JISX0208(0xdadf),
	/* U+660B */	U2E_NODEST_COLX,
	/* U+660C */	JISX0208(0xbebb),
	/* U+660D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc179)),
	/* U+660E */	JISX0208(0xccc0),
	/* U+660F */	JISX0208(0xbaaa),
	/* U+6610 */	U2E_NODEST_COLX,
	/* U+6611 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc17a)),
	/* U+6612 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc17b)),
	/* U+6613 */	JISX0208(0xb0d7),
	/* U+6614 */	JISX0208(0xc0ce),
	/* U+6615 */	IFX0213(JISX0213_1(0xf5ae),	JISX0212(0xc17c)),
	/* U+6616 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc17d)),
	/* U+6617 */	U2E_NODEST_COLX,
	/* U+6618 */	U2E_NODEST_COLX,
	/* U+6619 */	U2E_NODEST_COLX,
	/* U+661A */	U2E_NODEST_COLX,
	/* U+661B */	U2E_NODEST_COLX,
	/* U+661C */	JISX0208(0xdae6),
	/* U+661D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc17e)),
	/* U+661E */	IFX0213(JISX0213_1(0xf5af),	JISX0212(0xc221)),
	/* U+661F */	JISX0208(0xc0b1),
	/* U+6620 */	JISX0208(0xb1c7),
	/* U+6621 */	IFX0213(JISX0213_2(0xad77),	JISX0212(0xc222)),
	/* U+6622 */	IFX0213(JISX0213_1(0xf5b1),	JISX0212(0xc223)),
	/* U+6623 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc224)),
	/* U+6624 */	IFX0213(JISX0213_1(0xf5b2),	JISX0212(0xc225)),
	/* U+6625 */	JISX0208(0xbdd5),
	/* U+6626 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc226)),
	/* U+6627 */	JISX0208(0xcbe6),
	/* U+6628 */	JISX0208(0xbaf2),
	/* U+6629 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc227)),
	/* U+662A */	IFX0213(JISX0213_2(0xad78),	JISX0212(0xc228)),
	/* U+662B */	IFX0213(JISX0213_1(0xf5b3),	JISX0212(0xc229)),
	/* U+662C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc22a)),
	/* U+662D */	JISX0208(0xbebc),
	/* U+662E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc22b)),
	/* U+662F */	JISX0208(0xc0a7),
	/* U+6630 */	IFX0213(JISX0213_1(0xf5b4),	JISX0212(0xc22c)),
	/* U+6631 */	IFX0213(JISX0213_1(0xf5b5),	JISX0212(0xc22d)),
	/* U+6632 */	U2E_NODEST_COLX,
	/* U+6633 */	IFX0213(JISX0213_1(0xf5b6),	JISX0212(0xc22e)),
	/* U+6634 */	JISX0208(0xdae5),
	/* U+6635 */	JISX0208(0xdae3),
	/* U+6636 */	JISX0208(0xdae4),
	/* U+6637 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc230)),
	/* U+6638 */	U2E_NODEST_COLX,
	/* U+6639 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc22f)),
	/* U+663A */	IFX0213(JISX0213_1(0xf5b0),	U2E_NODEST_COLX),
	/* U+663B */	IFX0213(U2E_NODEST_COLX,	IBM(0xf442)),
	/* U+663C */	JISX0208(0xc3eb),
	/* U+663D */	U2E_NODEST_COLX,
	/* U+663E */	U2E_NODEST_COLX,
	/* U+663F */	JISX0208(0xdba6),
	/* U+6640 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc231)),
	/* U+6641 */	JISX0208(0xdaea),
	/* U+6642 */	JISX0208(0xbbfe),
	/* U+6643 */	JISX0208(0xb9b8),
	/* U+6644 */	JISX0208(0xdae8),
	/* U+6645 */	IFX0213(JISX0213_2(0xad79),	JISX0212(0xc232)),
	/* U+6646 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc233)),
	/* U+6647 */	U2E_NODEST_COLX,
	/* U+6648 */	IFX0213(JISX0213_1(0xf5b8),	U2E_NODEST_COLX),
	/* U+6649 */	JISX0208(0xdae9),
	/* U+664A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc234)),
	/* U+664B */	JISX0208(0xbfb8),
	/* U+664C */	IFX0213(JISX0213_1(0xf5b9),	JISX0212(0xc235)),
	/* U+664D */	U2E_NODEST_COLX,
	/* U+664E */	IFX0213(JISX0213_2(0xad7b),	JISX0212(0xc237)),
	/* U+664F */	JISX0208(0xdae7),
	/* U+6650 */	U2E_NODEST_COLX,
	/* U+6651 */	IFX0213(JISX0213_2(0xad7a),	JISX0212(0xc236)),
	/* U+6652 */	JISX0208(0xbbaf),
	/* U+6653 */	U2E_NODEST_COLX,
	/* U+6654 */	U2E_NODEST_COLX,
	/* U+6655 */	U2E_NODEST_COLX,
	/* U+6656 */	U2E_NODEST_COLX,
	/* U+6657 */	IFX0213(JISX0213_2(0xad7e),	JISX0212(0xc238)),
	/* U+6658 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc239)),
	/* U+6659 */	IFX0213(JISX0213_1(0xf5bb),	JISX0212(0xc23a)),
	/* U+665A */	IFX0213(JISX0213_1(0xf5bc),	U2E_NODEST_COLX),
	/* U+665B */	IFX0213(JISX0213_2(0xae21),	JISX0212(0xc23b)),
	/* U+665C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc23c)),
	/* U+665D */	JISX0208(0xdaec),
	/* U+665E */	JISX0208(0xdaeb),
	/* U+665F */	JISX0208(0xdaf0),
	/* U+6660 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc23d)),
	/* U+6661 */	IFX0213(JISX0213_1(0xf5bd),	JISX0212(0xc23e)),
	/* U+6662 */	JISX0208(0xdaf1),
	/* U+6663 */	IFX0213(JISX0213_2(0xae22),	U2E_NODEST_COLX),
	/* U+6664 */	JISX0208(0xdaed),
	/* U+6665 */	IFX0213(JISX0213_1(0xf5be),	IBM(0xf443)),
	/* U+6666 */	JISX0208(0xb3a2),
	/* U+6667 */	JISX0208(0xdaee),
	/* U+6668 */	JISX0208(0xdaef),
	/* U+6669 */	JISX0208(0xc8d5),
	/* U+666A */	IFX0213(JISX0213_2(0xae25),	JISX0212(0xc240)),
	/* U+666B */	IFX0213(JISX0213_2(0xae26),	JISX0212(0xc241)),
	/* U+666C */	IFX0213(JISX0213_2(0xae27),	JISX0212(0xc242)),
	/* U+666D */	IFX0213(JISX0213_2(0xae28),	U2E_NODEST_COLX),
	/* U+666E */	JISX0208(0xc9e1),
	/* U+666F */	JISX0208(0xb7ca),
	/* U+6670 */	JISX0208(0xdaf2),
	/* U+6671 */	U2E_NODEST_COLX,
	/* U+6672 */	U2E_NODEST_COLX,
	/* U+6673 */	IFX0213(JISX0213_1(0xf5bf),	JISX0212(0xc244)),
	/* U+6674 */	JISX0208(0xc0b2),
	/* U+6675 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc245)),
	/* U+6676 */	JISX0208(0xbebd),
	/* U+6677 */	IFX0213(JISX0213_1(0xf5c0),	JISX0212(0xc247)),
	/* U+6678 */	IFX0213(JISX0213_1(0xf5c1),	JISX0212(0xc248)),
	/* U+6679 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc249)),
	/* U+667A */	JISX0208(0xc3d2),
	/* U+667B */	IFX0213(JISX0213_2(0xae29),	JISX0212(0xc24a)),
	/* U+667C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc24c)),
	/* U+667D */	U2E_NODEST_COLX,
	/* U+667E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc243)),
	/* U+667F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc246)),
	/* U+6680 */	IFX0213(JISX0213_2(0xae2a),	JISX0212(0xc24b)),
	/* U+6681 */	JISX0208(0xb6c7),
	/* U+6682 */	U2E_NODEST_COLX,
	/* U+6683 */	JISX0208(0xdaf3),
	/* U+6684 */	JISX0208(0xdaf7),
	/* U+6685 */	U2E_NODEST_COLX,
	/* U+6686 */	U2E_NODEST_COLX,
	/* U+6687 */	JISX0208(0xb2cb),
	/* U+6688 */	JISX0208(0xdaf4),
	/* U+6689 */	JISX0208(0xdaf6),
	/* U+668A */	U2E_NODEST_COLX,
	/* U+668B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc24d)),
	/* U+668C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc24e)),
	/* U+668D */	IFX0213(JISX0213_1(0xf5c2),	JISX0212(0xc24f)),
	/* U+668E */	JISX0208(0xdaf5),
	/* U+668F */	U2E_NODEST_COLX,
	/* U+6690 */	IFX0213(JISX0213_2(0xae2b),	JISX0212(0xc250)),
	/* U+6691 */	JISX0208(0xbdeb),
	/* U+6692 */	IFX0213(JISX0213_2(0xae2c),	JISX0212(0xc251)),
	/* U+6693 */	U2E_NODEST_COLX,
	/* U+6694 */	U2E_NODEST_COLX,
	/* U+6695 */	U2E_NODEST_COLX,
	/* U+6696 */	JISX0208(0xc3c8),
	/* U+6697 */	JISX0208(0xb0c5),
	/* U+6698 */	JISX0208(0xdaf8),
	/* U+6699 */	IFX0213(JISX0213_2(0xae2d),	JISX0212(0xc252)),
	/* U+669A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc253)),
	/* U+669B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc254)),
	/* U+669C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc255)),
	/* U+669D */	JISX0208(0xdaf9),
	/* U+669E */	U2E_NODEST_COLX,
	/* U+669F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc256)),
	/* U+66A0 */	IFX0213(JISX0213_1(0xf5c4),	JISX0212(0xc257)),
	/* U+66A1 */	U2E_NODEST_COLX,
	/* U+66A2 */	JISX0208(0xc4aa),
	/* U+66A3 */	U2E_NODEST_COLX,
	/* U+66A4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc258)),
	/* U+66A5 */	U2E_NODEST_COLX,
	/* U+66A6 */	JISX0208(0xcef1),
	/* U+66A7 */	U2E_NODEST_COLX,
	/* U+66A8 */	U2E_NODEST_COLX,
	/* U+66A9 */	U2E_NODEST_COLX,
	/* U+66AA */	U2E_NODEST_COLX,
	/* U+66AB */	JISX0208(0xbbc3),
	/* U+66AC */	U2E_NODEST_COLX,
	/* U+66AD */	IFX0213(JISX0213_2(0xae2f),	JISX0212(0xc259)),
	/* U+66AE */	JISX0208(0xcaeb),
	/* U+66AF */	U2E_NODEST_COLX,
	/* U+66B0 */	U2E_NODEST_COLX,
	/* U+66B1 */	IFX0213(JISX0213_2(0xae30),	JISX0212(0xc25a)),
	/* U+66B2 */	IFX0213(JISX0213_1(0xf5c5),	JISX0212(0xc25b)),
	/* U+66B3 */	U2E_NODEST_COLX,
	/* U+66B4 */	JISX0208(0xcbbd),
	/* U+66B5 */	IFX0213(JISX0213_2(0xae31),	JISX0212(0xc25c)),
	/* U+66B6 */	U2E_NODEST_COLX,
	/* U+66B7 */	U2E_NODEST_COLX,
	/* U+66B8 */	JISX0208(0xdba2),
	/* U+66B9 */	JISX0208(0xdafb),
	/* U+66BA */	U2E_NODEST_COLX,
	/* U+66BB */	IFX0213(JISX0213_1(0xf5c6),	JISX0212(0xc25d)),
	/* U+66BC */	JISX0208(0xdafe),
	/* U+66BD */	U2E_NODEST_COLX,
	/* U+66BE */	JISX0208(0xdafd),
	/* U+66BF */	IFX0213(JISX0213_2(0xae33),	JISX0212(0xc25e)),
	/* U+66C0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc25f)),
	/* U+66C1 */	JISX0208(0xdafa),
	/* U+66C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc260)),
	/* U+66C3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc261)),
	/* U+66C4 */	JISX0208(0xdba1),
	/* U+66C5 */	U2E_NODEST_COLX,
	/* U+66C6 */	IFX0213(JISX0213_1(0xf5c7),	U2E_NODEST_COLX),
	/* U+66C7 */	JISX0208(0xc6de),
	/* U+66C8 */	IFX0213(JISX0213_1(0xf5c8),	JISX0212(0xc262)),
	/* U+66C9 */	JISX0208(0xdafc),
	/* U+66CA */	U2E_NODEST_COLX,
	/* U+66CB */	U2E_NODEST_COLX,
	/* U+66CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc263)),
	/* U+66CD */	U2E_NODEST_COLX,
	/* U+66CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc264)),
	/* U+66CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc265)),
	/* U+66D0 */	U2E_NODEST_COLX,
	/* U+66D1 */	U2E_NODEST_COLX,
	/* U+66D2 */	U2E_NODEST_COLX,
	/* U+66D3 */	U2E_NODEST_COLX,
	/* U+66D4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc266)),
	/* U+66D5 */	U2E_NODEST_COLX,
	/* U+66D6 */	JISX0208(0xdba3),
	/* U+66D7 */	U2E_NODEST_COLX,
	/* U+66D8 */	U2E_NODEST_COLX,
	/* U+66D9 */	JISX0208(0xbdec),
	/* U+66DA */	JISX0208(0xdba4),
	/* U+66DB */	IFX0213(JISX0213_1(0xf5ca),	JISX0212(0xc267)),
	/* U+66DC */	JISX0208(0xcdcb),
	/* U+66DD */	JISX0208(0xc7f8),
	/* U+66DE */	U2E_NODEST_COLX,
	/* U+66DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc268)),
	/* U+66E0 */	JISX0208(0xdba5),
	/* U+66E1 */	U2E_NODEST_COLX,
	/* U+66E2 */	U2E_NODEST_COLX,
	/* U+66E3 */	U2E_NODEST_COLX,
	/* U+66E4 */	U2E_NODEST_COLX,
	/* U+66E5 */	U2E_NODEST_COLX,
	/* U+66E6 */	JISX0208(0xdba7),
	/* U+66E7 */	U2E_NODEST_COLX,
	/* U+66E8 */	IFX0213(JISX0213_1(0xf5cb),	JISX0212(0xc269)),
	/* U+66E9 */	JISX0208(0xdba8),
	/* U+66EA */	U2E_NODEST_COLX,
	/* U+66EB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc26a)),
	/* U+66EC */	IFX0213(JISX0213_2(0xae35),	JISX0212(0xc26b)),
	/* U+66ED */	U2E_NODEST_COLX,
	/* U+66EE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc26c)),
	/* U+66EF */	U2E_NODEST_COLX,
	/* U+66F0 */	JISX0208(0xdba9),
	/* U+66F1 */	U2E_NODEST_COLX,
	/* U+66F2 */	JISX0208(0xb6ca),
	/* U+66F3 */	JISX0208(0xb1c8),
	/* U+66F4 */	JISX0208(0xb9b9),
	/* U+66F5 */	JISX0208(0xdbaa),
	/* U+66F6 */	U2E_NODEST_COLX,
	/* U+66F7 */	JISX0208(0xdbab),
	/* U+66F8 */	JISX0208(0xbdf1),
	/* U+66F9 */	JISX0208(0xc1e2),
	/* U+66FA */	IFX0213(JISX0213_1(0xf5cc),	JISX0212(0xc26d)),
	/* U+66FB */	IFX0213(JISX0213_1(0xf5b7),	JISX0212(0xc23f)),
	/* U+66FC */	JISX0208(0xd2d8),
	/* U+66FD */	JISX0208(0xc1be),
	/* U+66FE */	JISX0208(0xc1bd),
	/* U+66FF */	JISX0208(0xc2d8),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_67[] = {
	/* U+6700 */	JISX0208(0xbac7),
	/* U+6701 */	IFX0213(JISX0213_2(0xae37),	U2E_NODEST_COLX),
	/* U+6702 */	U2E_NODEST_COLX,
	/* U+6703 */	JISX0208(0xd0f2),
	/* U+6704 */	U2E_NODEST_COLX,
	/* U+6705 */	IFX0213(JISX0213_2(0xae38),	JISX0212(0xc26e)),
	/* U+6706 */	U2E_NODEST_COLX,
	/* U+6707 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc26f)),
	/* U+6708 */	JISX0208(0xb7ee),
	/* U+6709 */	JISX0208(0xcdad),
	/* U+670A */	U2E_NODEST_COLX,
	/* U+670B */	JISX0208(0xcafe),
	/* U+670C */	U2E_NODEST_COLX,
	/* U+670D */	JISX0208(0xc9fe),
	/* U+670E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc270)),
	/* U+670F */	JISX0208(0xdbac),
	/* U+6710 */	U2E_NODEST_COLX,
	/* U+6711 */	U2E_NODEST_COLX,
	/* U+6712 */	IFX0213(JISX0213_2(0xae39),	U2E_NODEST_COLX),
	/* U+6713 */	IFX0213(JISX0213_1(0xf5cd),	JISX0212(0xc271)),
	/* U+6714 */	JISX0208(0xbaf3),
	/* U+6715 */	JISX0208(0xc4bf),
	/* U+6716 */	JISX0208(0xdbad),
	/* U+6717 */	JISX0208(0xcfaf),
	/* U+6718 */	U2E_NODEST_COLX,
	/* U+6719 */	IFX0213(JISX0213_2(0xae3b),	JISX0212(0xc272)),
	/* U+671A */	U2E_NODEST_COLX,
	/* U+671B */	JISX0208(0xcbbe),
	/* U+671C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc273)),
	/* U+671D */	JISX0208(0xc4ab),
	/* U+671E */	JISX0208(0xdbae),
	/* U+671F */	JISX0208(0xb4fc),
	/* U+6720 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc274)),
	/* U+6721 */	U2E_NODEST_COLX,
	/* U+6722 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc275)),
	/* U+6723 */	U2E_NODEST_COLX,
	/* U+6724 */	U2E_NODEST_COLX,
	/* U+6725 */	U2E_NODEST_COLX,
	/* U+6726 */	JISX0208(0xdbaf),
	/* U+6727 */	JISX0208(0xdbb0),
	/* U+6728 */	JISX0208(0xccda),
	/* U+6729 */	U2E_NODEST_COLX,
	/* U+672A */	JISX0208(0xcca4),
	/* U+672B */	JISX0208(0xcbf6),
	/* U+672C */	JISX0208(0xcbdc),
	/* U+672D */	JISX0208(0xbba5),
	/* U+672E */	JISX0208(0xdbb2),
	/* U+672F */	U2E_NODEST_COLX,
	/* U+6730 */	U2E_NODEST_COLX,
	/* U+6731 */	JISX0208(0xbceb),
	/* U+6732 */	U2E_NODEST_COLX,
	/* U+6733 */	IFX0213(JISX0213_1(0xf5cf),	JISX0212(0xc276)),
	/* U+6734 */	JISX0208(0xcbd1),
	/* U+6735 */	U2E_NODEST_COLX,
	/* U+6736 */	JISX0208(0xdbb4),
	/* U+6737 */	JISX0208(0xdbb7),
	/* U+6738 */	JISX0208(0xdbb6),
	/* U+6739 */	U2E_NODEST_COLX,
	/* U+673A */	JISX0208(0xb4f9),
	/* U+673B */	U2E_NODEST_COLX,
	/* U+673C */	U2E_NODEST_COLX,
	/* U+673D */	JISX0208(0xb5e0),
	/* U+673E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc277)),
	/* U+673F */	JISX0208(0xdbb3),
	/* U+6740 */	U2E_NODEST_COLX,
	/* U+6741 */	JISX0208(0xdbb5),
	/* U+6742 */	U2E_NODEST_COLX,
	/* U+6743 */	U2E_NODEST_COLX,
	/* U+6744 */	U2E_NODEST_COLX,
	/* U+6745 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc278)),
	/* U+6746 */	JISX0208(0xdbb8),
	/* U+6747 */	IFX0213(JISX0213_1(0xf5d1),	JISX0212(0xc279)),
	/* U+6748 */	IFX0213(JISX0213_1(0xf5d2),	JISX0212(0xc27a)),
	/* U+6749 */	JISX0208(0xbff9),
	/* U+674A */	U2E_NODEST_COLX,
	/* U+674B */	U2E_NODEST_COLX,
	/* U+674C */	IFX0213(JISX0213_2(0xae3e),	JISX0212(0xc27b)),
	/* U+674D */	IFX0213(JISX0213_2(0xae3f),	U2E_NODEST_COLX),
	/* U+674E */	JISX0208(0xcdfb),
	/* U+674F */	JISX0208(0xb0c9),
	/* U+6750 */	JISX0208(0xbae0),
	/* U+6751 */	JISX0208(0xc2bc),
	/* U+6752 */	U2E_NODEST_COLX,
	/* U+6753 */	JISX0208(0xbcdd),
	/* U+6754 */	IFX0213(JISX0213_2(0xae40),	JISX0212(0xc27c)),
	/* U+6755 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc27d)),
	/* U+6756 */	JISX0208(0xbef3),
	/* U+6757 */	U2E_NODEST_COLX,
	/* U+6758 */	U2E_NODEST_COLX,
	/* U+6759 */	JISX0208(0xdbbb),
	/* U+675A */	U2E_NODEST_COLX,
	/* U+675B */	U2E_NODEST_COLX,
	/* U+675C */	JISX0208(0xc5ce),
	/* U+675D */	IFX0213(JISX0213_2(0xae41),	JISX0212(0xc27e)),
	/* U+675E */	JISX0208(0xdbb9),
	/* U+675F */	JISX0208(0xc2ab),
	/* U+6760 */	JISX0208(0xdbba),
	/* U+6761 */	JISX0208(0xbef2),
	/* U+6762 */	JISX0208(0xccdd),
	/* U+6763 */	JISX0208(0xdbbc),
	/* U+6764 */	JISX0208(0xdbbd),
	/* U+6765 */	JISX0208(0xcde8),
	/* U+6766 */	IFX0213(JISX0213_1(0xf5d0),	JISX0212(0xc321)),
	/* U+6767 */	U2E_NODEST_COLX,
	/* U+6768 */	U2E_NODEST_COLX,
	/* U+6769 */	U2E_NODEST_COLX,
	/* U+676A */	JISX0208(0xdbc2),
	/* U+676B */	U2E_NODEST_COLX,
	/* U+676C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc322)),
	/* U+676D */	JISX0208(0xb9ba),
	/* U+676E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc323)),
	/* U+676F */	JISX0208(0xc7d5),
	/* U+6770 */	JISX0208(0xdbbf),
	/* U+6771 */	JISX0208(0xc5ec),
	/* U+6772 */	JISX0208(0xdade),
	/* U+6773 */	JISX0208(0xdae2),
	/* U+6774 */	IFX0213(JISX0213_2(0xae45),	JISX0212(0xc324)),
	/* U+6775 */	JISX0208(0xb5cf),
	/* U+6776 */	IFX0213(JISX0213_2(0xae46),	JISX0212(0xc325)),
	/* U+6777 */	JISX0208(0xc7c7),
	/* U+6778 */	U2E_NODEST_COLX,
	/* U+6779 */	U2E_NODEST_COLX,
	/* U+677A */	U2E_NODEST_COLX,
	/* U+677B */	IFX0213(JISX0213_1(0xf5d3),	JISX0212(0xc326)),
	/* U+677C */	JISX0208(0xdbc1),
	/* U+677D */	U2E_NODEST_COLX,
	/* U+677E */	JISX0208(0xbebe),
	/* U+677F */	JISX0208(0xc8c4),
	/* U+6780 */	U2E_NODEST_COLX,
	/* U+6781 */	IFX0213(JISX0213_1(0xf5d4),	JISX0212(0xc327)),
	/* U+6782 */	U2E_NODEST_COLX,
	/* U+6783 */	U2E_NODEST_COLX,
	/* U+6784 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc328)),
	/* U+6785 */	JISX0208(0xdbc7),
	/* U+6786 */	U2E_NODEST_COLX,
	/* U+6787 */	JISX0208(0xc8fa),
	/* U+6788 */	U2E_NODEST_COLX,
	/* U+6789 */	JISX0208(0xdbbe),
	/* U+678A */	U2E_NODEST_COLX,
	/* U+678B */	JISX0208(0xdbc4),
	/* U+678C */	JISX0208(0xdbc3),
	/* U+678D */	U2E_NODEST_COLX,
	/* U+678E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc329)),
	/* U+678F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc32a)),
	/* U+6790 */	JISX0208(0xc0cf),
	/* U+6791 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc32b)),
	/* U+6792 */	IFX0213(JISX0213_2(0xae48),	U2E_NODEST_COLX),
	/* U+6793 */	IFX0213(JISX0213_1(0xf5d5),	JISX0212(0xc32c)),
	/* U+6794 */	U2E_NODEST_COLX,
	/* U+6795 */	JISX0208(0xcbed),
	/* U+6796 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc32d)),
	/* U+6797 */	JISX0208(0xced3),
	/* U+6798 */	IFX0213(JISX0213_1(0xf5d6),	JISX0212(0xc32e)),
	/* U+6799 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc32f)),
	/* U+679A */	JISX0208(0xcbe7),
	/* U+679B */	IFX0213(JISX0213_1(0xf5d7),	JISX0212(0xc330)),
	/* U+679C */	JISX0208(0xb2cc),
	/* U+679D */	JISX0208(0xbbde),
	/* U+679E */	U2E_NODEST_COLX,
	/* U+679F */	U2E_NODEST_COLX,
	/* U+67A0 */	JISX0208(0xcfc8),
	/* U+67A1 */	JISX0208(0xdbc6),
	/* U+67A2 */	JISX0208(0xbff5),
	/* U+67A3 */	U2E_NODEST_COLX,
	/* U+67A4 */	U2E_NODEST_COLX,
	/* U+67A5 */	U2E_NODEST_COLX,
	/* U+67A6 */	JISX0208(0xdbc5),
	/* U+67A7 */	U2E_NODEST_COLX,
	/* U+67A8 */	U2E_NODEST_COLX,
	/* U+67A9 */	JISX0208(0xdbc0),
	/* U+67AA */	U2E_NODEST_COLX,
	/* U+67AB */	U2E_NODEST_COLX,
	/* U+67AC */	U2E_NODEST_COLX,
	/* U+67AD */	U2E_NODEST_COLX,
	/* U+67AE */	U2E_NODEST_COLX,
	/* U+67AF */	JISX0208(0xb8cf),
	/* U+67B0 */	IFX0213(JISX0213_2(0xae4c),	JISX0212(0xc331)),
	/* U+67B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc332)),
	/* U+67B2 */	IFX0213(JISX0213_2(0xae4d),	JISX0212(0xc333)),
	/* U+67B3 */	JISX0208(0xdbcc),
	/* U+67B4 */	JISX0208(0xdbca),
	/* U+67B5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc334)),
	/* U+67B6 */	JISX0208(0xb2cd),
	/* U+67B7 */	JISX0208(0xdbc8),
	/* U+67B8 */	JISX0208(0xdbce),
	/* U+67B9 */	JISX0208(0xdbd4),
	/* U+67BA */	U2E_NODEST_COLX,
	/* U+67BB */	IFX0213(JISX0213_1(0xf5d8),	JISX0212(0xc335)),
	/* U+67BC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc336)),
	/* U+67BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc337)),
	/* U+67BE */	U2E_NODEST_COLX,
	/* U+67BF */	U2E_NODEST_COLX,
	/* U+67C0 */	IFX0213(JISX0213_1(0xf5da),	JISX0212(0xc339)),
	/* U+67C1 */	JISX0208(0xc2c8),
	/* U+67C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc33a)),
	/* U+67C3 */	IFX0213(JISX0213_2(0xae4e),	JISX0212(0xc33b)),
	/* U+67C4 */	JISX0208(0xcac1),
	/* U+67C5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc33c)),
	/* U+67C6 */	JISX0208(0xdbd6),
	/* U+67C7 */	U2E_NODEST_COLX,
	/* U+67C8 */	IFX0213(JISX0213_2(0xae4f),	JISX0212(0xc33d)),
	/* U+67C9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc33e)),
	/* U+67CA */	JISX0208(0xc9a2),
	/* U+67CB */	U2E_NODEST_COLX,
	/* U+67CC */	U2E_NODEST_COLX,
	/* U+67CD */	U2E_NODEST_COLX,
	/* U+67CE */	JISX0208(0xdbd5),
	/* U+67CF */	JISX0208(0xc7f0),
	/* U+67D0 */	JISX0208(0xcbbf),
	/* U+67D1 */	JISX0208(0xb4bb),
	/* U+67D2 */	IFX0213(JISX0213_2(0xae50),	JISX0212(0xc33f)),
	/* U+67D3 */	JISX0208(0xc0f7),
	/* U+67D4 */	JISX0208(0xbdc0),
	/* U+67D5 */	U2E_NODEST_COLX,
	/* U+67D6 */	U2E_NODEST_COLX,
	/* U+67D7 */	IFX0213(JISX0213_1(0xf5db),	JISX0212(0xc340)),
	/* U+67D8 */	JISX0208(0xc4d3),
	/* U+67D9 */	IFX0213(JISX0213_2(0xae51),	JISX0212(0xc341)),
	/* U+67DA */	JISX0208(0xcdae),
	/* U+67DB */	IFX0213(JISX0213_2(0xae52),	U2E_NODEST_COLX),
	/* U+67DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc342)),
	/* U+67DD */	JISX0208(0xdbd1),
	/* U+67DE */	JISX0208(0xdbd0),
	/* U+67DF */	U2E_NODEST_COLX,
	/* U+67E0 */	U2E_NODEST_COLX,
	/* U+67E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc343)),
	/* U+67E2 */	JISX0208(0xdbd2),
	/* U+67E3 */	U2E_NODEST_COLX,
	/* U+67E4 */	JISX0208(0xdbcf),
	/* U+67E5 */	U2E_NODEST_COLX,
	/* U+67E6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc344)),
	/* U+67E7 */	JISX0208(0xdbd7),
	/* U+67E8 */	U2E_NODEST_COLX,
	/* U+67E9 */	JISX0208(0xdbcd),
	/* U+67EA */	U2E_NODEST_COLX,
	/* U+67EB */	U2E_NODEST_COLX,
	/* U+67EC */	JISX0208(0xdbcb),
	/* U+67ED */	U2E_NODEST_COLX,
	/* U+67EE */	JISX0208(0xdbd3),
	/* U+67EF */	JISX0208(0xdbc9),
	/* U+67F0 */	IFX0213(JISX0213_2(0xae53),	JISX0212(0xc345)),
	/* U+67F1 */	JISX0208(0xc3ec),
	/* U+67F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc346)),
	/* U+67F3 */	JISX0208(0xccf8),
	/* U+67F4 */	JISX0208(0xbcc6),
	/* U+67F5 */	JISX0208(0xbaf4),
	/* U+67F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc347)),
	/* U+67F7 */	IFX0213(JISX0213_2(0xae54),	JISX0212(0xc348)),
	/* U+67F8 */	U2E_NODEST_COLX,
	/* U+67F9 */	IFX0213(JISX0213_1(0xf5d9),	JISX0212(0xc338)),
	/* U+67FA */	U2E_NODEST_COLX,
	/* U+67FB */	JISX0208(0xbaba),
	/* U+67FC */	IFX0213(JISX0213_1(0xf5dc),	U2E_NODEST_COLX),
	/* U+67FD */	U2E_NODEST_COLX,
	/* U+67FE */	JISX0208(0xcbef),
	/* U+67FF */	JISX0208(0xb3c1),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_68[] = {
	/* U+6800 */	U2E_NODEST_COLX,
	/* U+6801 */	IFX0213(JISX0213_1(0xf5dd),	IBM(0xf446)),
	/* U+6802 */	JISX0208(0xc4ce),
	/* U+6803 */	JISX0208(0xc6ca),
	/* U+6804 */	JISX0208(0xb1c9),
	/* U+6805 */	U2E_NODEST_COLX,
	/* U+6806 */	U2E_NODEST_COLX,
	/* U+6807 */	U2E_NODEST_COLX,
	/* U+6808 */	U2E_NODEST_COLX,
	/* U+6809 */	U2E_NODEST_COLX,
	/* U+680A */	U2E_NODEST_COLX,
	/* U+680B */	U2E_NODEST_COLX,
	/* U+680C */	U2E_NODEST_COLX,
	/* U+680D */	U2E_NODEST_COLX,
	/* U+680E */	U2E_NODEST_COLX,
	/* U+680F */	U2E_NODEST_COLX,
	/* U+6810 */	IFX0213(JISX0213_2(0xae4b),	U2E_NODEST_COLX),
	/* U+6811 */	U2E_NODEST_COLX,
	/* U+6812 */	U2E_NODEST_COLX,
	/* U+6813 */	JISX0208(0xc0f2),
	/* U+6814 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc34a)),
	/* U+6815 */	U2E_NODEST_COLX,
	/* U+6816 */	JISX0208(0xc0b4),
	/* U+6817 */	JISX0208(0xb7aa),
	/* U+6818 */	IFX0213(JISX0213_2(0xae58),	U2E_NODEST_COLX),
	/* U+6819 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc34b)),
	/* U+681A */	U2E_NODEST_COLX,
	/* U+681B */	U2E_NODEST_COLX,
	/* U+681C */	U2E_NODEST_COLX,
	/* U+681D */	IFX0213(JISX0213_1(0xf5df),	JISX0212(0xc34c)),
	/* U+681E */	JISX0208(0xdbd9),
	/* U+681F */	IFX0213(JISX0213_2(0xae59),	JISX0212(0xc34d)),
	/* U+6820 */	U2E_NODEST_COLX,
	/* U+6821 */	JISX0208(0xb9bb),
	/* U+6822 */	JISX0208(0xb3fc),
	/* U+6823 */	U2E_NODEST_COLX,
	/* U+6824 */	U2E_NODEST_COLX,
	/* U+6825 */	U2E_NODEST_COLX,
	/* U+6826 */	U2E_NODEST_COLX,
	/* U+6827 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc34f)),
	/* U+6828 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc34e)),
	/* U+6829 */	JISX0208(0xdbdb),
	/* U+682A */	JISX0208(0xb3f4),
	/* U+682B */	JISX0208(0xdbe1),
	/* U+682C */	IFX0213(JISX0213_1(0xf5e0),	JISX0212(0xc350)),
	/* U+682D */	IFX0213(JISX0213_2(0xae5a),	JISX0212(0xc351)),
	/* U+682E */	U2E_NODEST_COLX,
	/* U+682F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc352)),
	/* U+6830 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc353)),
	/* U+6831 */	IFX0213(JISX0213_1(0xf5e1),	JISX0212(0xc354)),
	/* U+6832 */	JISX0208(0xdbde),
	/* U+6833 */	IFX0213(JISX0213_2(0xae5c),	JISX0212(0xc355)),
	/* U+6834 */	JISX0208(0xc0f3),
	/* U+6835 */	U2E_NODEST_COLX,
	/* U+6836 */	U2E_NODEST_COLX,
	/* U+6837 */	U2E_NODEST_COLX,
	/* U+6838 */	JISX0208(0xb3cb),
	/* U+6839 */	JISX0208(0xbaac),
	/* U+683A */	U2E_NODEST_COLX,
	/* U+683B */	IFX0213(JISX0213_2(0xae5d),	JISX0212(0xc356)),
	/* U+683C */	JISX0208(0xb3ca),
	/* U+683D */	JISX0208(0xbacf),
	/* U+683E */	IFX0213(JISX0213_2(0xae5e),	U2E_NODEST_COLX),
	/* U+683F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc357)),
	/* U+6840 */	JISX0208(0xdbdc),
	/* U+6841 */	JISX0208(0xb7e5),
	/* U+6842 */	JISX0208(0xb7cb),
	/* U+6843 */	JISX0208(0xc5ed),
	/* U+6844 */	IFX0213(JISX0213_2(0xae5f),	JISX0212(0xc358)),
	/* U+6845 */	IFX0213(JISX0213_2(0xae60),	JISX0212(0xc359)),
	/* U+6846 */	JISX0208(0xdbda),
	/* U+6847 */	U2E_NODEST_COLX,
	/* U+6848 */	JISX0208(0xb0c6),
	/* U+6849 */	IFX0213(JISX0213_2(0xae61),	U2E_NODEST_COLX),
	/* U+684A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc35a)),
	/* U+684B */	U2E_NODEST_COLX,
	/* U+684C */	IFX0213(JISX0213_2(0xae62),	JISX0212(0xc35b)),
	/* U+684D */	JISX0208(0xdbdd),
	/* U+684E */	JISX0208(0xdbdf),
	/* U+684F */	U2E_NODEST_COLX,
	/* U+6850 */	JISX0208(0xb6cd),
	/* U+6851 */	JISX0208(0xb7ac),
	/* U+6852 */	IFX0213(JISX0213_1(0xf5de),	JISX0212(0xc349)),
	/* U+6853 */	JISX0208(0xb4bc),
	/* U+6854 */	JISX0208(0xb5cb),
	/* U+6855 */	IFX0213(JISX0213_2(0xae63),	JISX0212(0xc35c)),
	/* U+6856 */	U2E_NODEST_COLX,
	/* U+6857 */	IFX0213(JISX0213_2(0xae64),	JISX0212(0xc35d)),
	/* U+6858 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc35e)),
	/* U+6859 */	JISX0208(0xdbe2),
	/* U+685A */	U2E_NODEST_COLX,
	/* U+685B */	IFX0213(JISX0213_1(0xf5e2),	JISX0212(0xc35f)),
	/* U+685C */	JISX0208(0xbaf9),
	/* U+685D */	JISX0208(0xcbf1),
	/* U+685E */	U2E_NODEST_COLX,
	/* U+685F */	JISX0208(0xbbb7),
	/* U+6860 */	U2E_NODEST_COLX,
	/* U+6861 */	U2E_NODEST_COLX,
	/* U+6862 */	U2E_NODEST_COLX,
	/* U+6863 */	JISX0208(0xdbe3),
	/* U+6864 */	U2E_NODEST_COLX,
	/* U+6865 */	U2E_NODEST_COLX,
	/* U+6866 */	U2E_NODEST_COLX,
	/* U+6867 */	JISX0208(0xc9b0),
	/* U+6868 */	U2E_NODEST_COLX,
	/* U+6869 */	U2E_NODEST_COLX,
	/* U+686A */	U2E_NODEST_COLX,
	/* U+686B */	IFX0213(JISX0213_2(0xae66),	JISX0212(0xc360)),
	/* U+686C */	U2E_NODEST_COLX,
	/* U+686D */	U2E_NODEST_COLX,
	/* U+686E */	IFX0213(JISX0213_2(0xae67),	JISX0212(0xc361)),
	/* U+686F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc362)),
	/* U+6870 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc363)),
	/* U+6871 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc364)),
	/* U+6872 */	IFX0213(JISX0213_1(0xf5e3),	JISX0212(0xc365)),
	/* U+6873 */	U2E_NODEST_COLX,
	/* U+6874 */	JISX0208(0xdbef),
	/* U+6875 */	IFX0213(JISX0213_1(0xf5e4),	JISX0212(0xc366)),
	/* U+6876 */	JISX0208(0xb2b3),
	/* U+6877 */	JISX0208(0xdbe4),
	/* U+6878 */	U2E_NODEST_COLX,
	/* U+6879 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc367)),
	/* U+687A */	IFX0213(JISX0213_2(0xae68),	JISX0212(0xc368)),
	/* U+687B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc369)),
	/* U+687C */	IFX0213(JISX0213_2(0xae69),	JISX0212(0xc36a)),
	/* U+687D */	U2E_NODEST_COLX,
	/* U+687E */	JISX0208(0xdbf5),
	/* U+687F */	JISX0208(0xdbe5),
	/* U+6880 */	U2E_NODEST_COLX,
	/* U+6881 */	JISX0208(0xcec2),
	/* U+6882 */	IFX0213(JISX0213_2(0xae6a),	JISX0212(0xc36b)),
	/* U+6883 */	JISX0208(0xdbec),
	/* U+6884 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc36c)),
	/* U+6885 */	JISX0208(0xc7df),
	/* U+6886 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc36d)),
	/* U+6887 */	U2E_NODEST_COLX,
	/* U+6888 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc36e)),
	/* U+6889 */	U2E_NODEST_COLX,
	/* U+688A */	U2E_NODEST_COLX,
	/* U+688B */	U2E_NODEST_COLX,
	/* U+688C */	U2E_NODEST_COLX,
	/* U+688D */	JISX0208(0xdbf4),
	/* U+688E */	U2E_NODEST_COLX,
	/* U+688F */	JISX0208(0xdbe7),
	/* U+6890 */	IFX0213(JISX0213_2(0xae6b),	U2E_NODEST_COLX),
	/* U+6891 */	U2E_NODEST_COLX,
	/* U+6892 */	U2E_NODEST_COLX,
	/* U+6893 */	JISX0208(0xb0b4),
	/* U+6894 */	JISX0208(0xdbe9),
	/* U+6895 */	U2E_NODEST_COLX,
	/* U+6896 */	IFX0213(JISX0213_2(0xae6c),	JISX0212(0xc36f)),
	/* U+6897 */	JISX0208(0xb9bc),
	/* U+6898 */	IFX0213(JISX0213_2(0xae6e),	JISX0212(0xc370)),
	/* U+6899 */	IFX0213(JISX0213_2(0xae6f),	U2E_NODEST_COLX),
	/* U+689A */	IFX0213(JISX0213_2(0xae70),	JISX0212(0xc371)),
	/* U+689B */	JISX0208(0xdbeb),
	/* U+689C */	IFX0213(JISX0213_2(0xae71),	JISX0212(0xc372)),
	/* U+689D */	JISX0208(0xdbea),
	/* U+689E */	U2E_NODEST_COLX,
	/* U+689F */	JISX0208(0xdbe6),
	/* U+68A0 */	JISX0208(0xdbf1),
	/* U+68A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc373)),
	/* U+68A2 */	JISX0208(0xbebf),
	/* U+68A3 */	IFX0213(JISX0213_1(0xf5e6),	JISX0212(0xc374)),
	/* U+68A4 */	U2E_NODEST_COLX,
	/* U+68A5 */	IFX0213(JISX0213_1(0xf5e7),	JISX0212(0xc375)),
	/* U+68A6 */	JISX0208(0xd4ed),
	/* U+68A7 */	JISX0208(0xb8e8),
	/* U+68A8 */	JISX0208(0xcdfc),
	/* U+68A9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc376)),
	/* U+68AA */	IFX0213(JISX0213_2(0xae72),	JISX0212(0xc377)),
	/* U+68AB */	IFX0213(JISX0213_2(0xae73),	U2E_NODEST_COLX),
	/* U+68AC */	U2E_NODEST_COLX,
	/* U+68AD */	JISX0208(0xdbe8),
	/* U+68AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc378)),
	/* U+68AF */	JISX0208(0xc4f4),
	/* U+68B0 */	JISX0208(0xb3a3),
	/* U+68B1 */	JISX0208(0xbaad),
	/* U+68B2 */	IFX0213(JISX0213_1(0xf5e8),	JISX0212(0xc379)),
	/* U+68B3 */	JISX0208(0xdbe0),
	/* U+68B4 */	IFX0213(JISX0213_2(0xae74),	U2E_NODEST_COLX),
	/* U+68B5 */	JISX0208(0xdbf0),
	/* U+68B6 */	JISX0208(0xb3e1),
	/* U+68B7 */	U2E_NODEST_COLX,
	/* U+68B8 */	U2E_NODEST_COLX,
	/* U+68B9 */	JISX0208(0xdbee),
	/* U+68BA */	JISX0208(0xdbf2),
	/* U+68BB */	IFX0213(JISX0213_2(0xae75),	JISX0212(0xc37a)),
	/* U+68BC */	JISX0208(0xc5ee),
	/* U+68BD */	U2E_NODEST_COLX,
	/* U+68BE */	U2E_NODEST_COLX,
	/* U+68BF */	U2E_NODEST_COLX,
	/* U+68C0 */	U2E_NODEST_COLX,
	/* U+68C1 */	U2E_NODEST_COLX,
	/* U+68C2 */	U2E_NODEST_COLX,
	/* U+68C3 */	IFX0213(JISX0213_2(0xae7a),	U2E_NODEST_COLX),
	/* U+68C4 */	JISX0208(0xb4fe),
	/* U+68C5 */	IFX0213(JISX0213_2(0xae7b),	JISX0212(0xc37b)),
	/* U+68C6 */	JISX0208(0xdcb2),
	/* U+68C7 */	U2E_NODEST_COLX,
	/* U+68C8 */	IFX0213(JISX0213_1(0xf5e9),	JISX0212(0xc37c)),
	/* U+68C9 */	JISX0208(0xccc9),
	/* U+68CA */	JISX0208(0xdbf7),
	/* U+68CB */	JISX0208(0xb4fd),
	/* U+68CC */	IFX0213(JISX0213_2(0xae7c),	JISX0212(0xc37d)),
	/* U+68CD */	JISX0208(0xdbfe),
	/* U+68CE */	U2E_NODEST_COLX,
	/* U+68CF */	IFX0213(JISX0213_2(0xae7d),	JISX0212(0xc37e)),
	/* U+68D0 */	IFX0213(JISX0213_1(0xf5ea),	JISX0212(0xc421)),
	/* U+68D1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc422)),
	/* U+68D2 */	JISX0208(0xcbc0),
	/* U+68D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc423)),
	/* U+68D4 */	JISX0208(0xdca1),
	/* U+68D5 */	JISX0208(0xdca3),
	/* U+68D6 */	IFX0213(JISX0213_2(0xae7e),	JISX0212(0xc424)),
	/* U+68D7 */	JISX0208(0xdca7),
	/* U+68D8 */	JISX0208(0xdbf9),
	/* U+68D9 */	IFX0213(JISX0213_2(0xaf21),	JISX0212(0xc425)),
	/* U+68DA */	JISX0208(0xc3aa),
	/* U+68DB */	U2E_NODEST_COLX,
	/* U+68DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc426)),
	/* U+68DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc427)),
	/* U+68DE */	U2E_NODEST_COLX,
	/* U+68DF */	JISX0208(0xc5ef),
	/* U+68E0 */	JISX0208(0xdcab),
	/* U+68E1 */	JISX0208(0xdbfc),
	/* U+68E2 */	U2E_NODEST_COLX,
	/* U+68E3 */	JISX0208(0xdca8),
	/* U+68E4 */	IFX0213(JISX0213_2(0xaf22),	U2E_NODEST_COLX),
	/* U+68E5 */	IFX0213(JISX0213_2(0xaf23),	JISX0212(0xc428)),
	/* U+68E6 */	U2E_NODEST_COLX,
	/* U+68E7 */	JISX0208(0xdca2),
	/* U+68E8 */	IFX0213(JISX0213_1(0xf5eb),	JISX0212(0xc429)),
	/* U+68E9 */	U2E_NODEST_COLX,
	/* U+68EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc42a)),
	/* U+68EB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc42b)),
	/* U+68EC */	IFX0213(JISX0213_2(0xaf24),	JISX0212(0xc42c)),
	/* U+68ED */	IFX0213(JISX0213_1(0xf5ec),	JISX0212(0xc42d)),
	/* U+68EE */	JISX0208(0xbfb9),
	/* U+68EF */	JISX0208(0xdcac),
	/* U+68F0 */	IFX0213(JISX0213_1(0xf5ed),	JISX0212(0xc42e)),
	/* U+68F1 */	IFX0213(JISX0213_1(0xf5ee),	JISX0212(0xc42f)),
	/* U+68F2 */	JISX0208(0xc0b3),
	/* U+68F3 */	U2E_NODEST_COLX,
	/* U+68F4 */	U2E_NODEST_COLX,
	/* U+68F5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc430)),
	/* U+68F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc431)),
	/* U+68F7 */	IFX0213(JISX0213_2(0xaf25),	U2E_NODEST_COLX),
	/* U+68F8 */	U2E_NODEST_COLX,
	/* U+68F9 */	JISX0208(0xdcaa),
	/* U+68FA */	JISX0208(0xb4bd),
	/* U+68FB */	IFX0213(JISX0213_2(0xae76),	JISX0212(0xc432)),
	/* U+68FC */	IFX0213(JISX0213_1(0xf5ef),	JISX0212(0xc433)),
	/* U+68FD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc434)),
	/* U+68FE */	U2E_NODEST_COLX,
	/* U+68FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_69[] = {
	/* U+6900 */	JISX0208(0xcfd0),
	/* U+6901 */	JISX0208(0xdbf6),
	/* U+6902 */	U2E_NODEST_COLX,
	/* U+6903 */	IFX0213(JISX0213_2(0xaf26),	U2E_NODEST_COLX),
	/* U+6904 */	JISX0208(0xdca6),
	/* U+6905 */	JISX0208(0xb0d8),
	/* U+6906 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc435)),
	/* U+6907 */	IFX0213(JISX0213_2(0xaf27),	U2E_NODEST_COLX),
	/* U+6908 */	JISX0208(0xdbf8),
	/* U+6909 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc436)),
	/* U+690A */	IFX0213(JISX0213_1(0xf5f0),	JISX0212(0xc437)),
	/* U+690B */	JISX0208(0xccba),
	/* U+690C */	JISX0208(0xdbfd),
	/* U+690D */	JISX0208(0xbfa2),
	/* U+690E */	JISX0208(0xc4c7),
	/* U+690F */	JISX0208(0xdbf3),
	/* U+6910 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc438)),
	/* U+6911 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc439)),
	/* U+6912 */	JISX0208(0xdca5),
	/* U+6913 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc43a)),
	/* U+6914 */	U2E_NODEST_COLX,
	/* U+6915 */	U2E_NODEST_COLX,
	/* U+6916 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc43b)),
	/* U+6917 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc43c)),
	/* U+6918 */	U2E_NODEST_COLX,
	/* U+6919 */	JISX0208(0xbffa),
	/* U+691A */	JISX0208(0xdcaf),
	/* U+691B */	JISX0208(0xb3f1),
	/* U+691C */	JISX0208(0xb8a1),
	/* U+691D */	U2E_NODEST_COLX,
	/* U+691E */	U2E_NODEST_COLX,
	/* U+691F */	U2E_NODEST_COLX,
	/* U+6920 */	U2E_NODEST_COLX,
	/* U+6921 */	JISX0208(0xdcb1),
	/* U+6922 */	JISX0208(0xdbfa),
	/* U+6923 */	JISX0208(0xdcb0),
	/* U+6924 */	U2E_NODEST_COLX,
	/* U+6925 */	JISX0208(0xdca9),
	/* U+6926 */	JISX0208(0xdbfb),
	/* U+6927 */	U2E_NODEST_COLX,
	/* U+6928 */	JISX0208(0xdcad),
	/* U+6929 */	U2E_NODEST_COLX,
	/* U+692A */	JISX0208(0xdcae),
	/* U+692B */	U2E_NODEST_COLX,
	/* U+692C */	U2E_NODEST_COLX,
	/* U+692D */	U2E_NODEST_COLX,
	/* U+692E */	U2E_NODEST_COLX,
	/* U+692F */	U2E_NODEST_COLX,
	/* U+6930 */	JISX0208(0xdcbf),
	/* U+6931 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc43d)),
	/* U+6932 */	U2E_NODEST_COLX,
	/* U+6933 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc43e)),
	/* U+6934 */	JISX0208(0xc6ce),
	/* U+6935 */	IFX0213(JISX0213_1(0xf5f3),	JISX0212(0xc43f)),
	/* U+6936 */	JISX0208(0xdca4),
	/* U+6937 */	U2E_NODEST_COLX,
	/* U+6938 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc440)),
	/* U+6939 */	JISX0208(0xdcbb),
	/* U+693A */	U2E_NODEST_COLX,
	/* U+693B */	IFX0213(JISX0213_2(0xaf2b),	JISX0212(0xc441)),
	/* U+693C */	U2E_NODEST_COLX,
	/* U+693D */	JISX0208(0xdcbd),
	/* U+693E */	U2E_NODEST_COLX,
	/* U+693F */	JISX0208(0xc4d8),
	/* U+6940 */	U2E_NODEST_COLX,
	/* U+6941 */	U2E_NODEST_COLX,
	/* U+6942 */	IFX0213(JISX0213_1(0xf5f4),	JISX0212(0xc442)),
	/* U+6943 */	U2E_NODEST_COLX,
	/* U+6944 */	U2E_NODEST_COLX,
	/* U+6945 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc443)),
	/* U+6946 */	IFX0213(JISX0213_2(0xaf2d),	U2E_NODEST_COLX),
	/* U+6947 */	U2E_NODEST_COLX,
	/* U+6948 */	U2E_NODEST_COLX,
	/* U+6949 */	IFX0213(JISX0213_1(0xf5f1),	JISX0212(0xc444)),
	/* U+694A */	JISX0208(0xcdcc),
	/* U+694B */	U2E_NODEST_COLX,
	/* U+694C */	U2E_NODEST_COLX,
	/* U+694D */	U2E_NODEST_COLX,
	/* U+694E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc445)),
	/* U+694F */	U2E_NODEST_COLX,
	/* U+6950 */	U2E_NODEST_COLX,
	/* U+6951 */	U2E_NODEST_COLX,
	/* U+6952 */	U2E_NODEST_COLX,
	/* U+6953 */	JISX0208(0xc9f6),
	/* U+6954 */	JISX0208(0xdcb8),
	/* U+6955 */	JISX0208(0xc2ca),
	/* U+6956 */	U2E_NODEST_COLX,
	/* U+6957 */	IFX0213(JISX0213_1(0xf5f5),	JISX0212(0xc446)),
	/* U+6958 */	U2E_NODEST_COLX,
	/* U+6959 */	JISX0208(0xdcbe),
	/* U+695A */	JISX0208(0xc1bf),
	/* U+695B */	IFX0213(JISX0213_2(0xf263),	JISX0212(0xc447)),
	/* U+695C */	JISX0208(0xdcb5),
	/* U+695D */	JISX0208(0xdcc2),
	/* U+695E */	JISX0208(0xdcc1),
	/* U+695F */	U2E_NODEST_COLX,
	/* U+6960 */	JISX0208(0xc6ef),
	/* U+6961 */	JISX0208(0xdcc0),
	/* U+6962 */	JISX0208(0xc6ea),
	/* U+6963 */	IFX0213(JISX0213_1(0xf5f6),	JISX0212(0xc448)),
	/* U+6964 */	IFX0213(JISX0213_1(0xf5f7),	JISX0212(0xc449)),
	/* U+6965 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc44a)),
	/* U+6966 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc44b)),
	/* U+6967 */	U2E_NODEST_COLX,
	/* U+6968 */	IFX0213(JISX0213_1(0xf5f8),	JISX0212(0xc44c)),
	/* U+6969 */	IFX0213(JISX0213_2(0xaf2e),	JISX0212(0xc44d)),
	/* U+696A */	JISX0208(0xdcc4),
	/* U+696B */	JISX0208(0xdcb7),
	/* U+696C */	IFX0213(JISX0213_2(0xaf2f),	JISX0212(0xc44e)),
	/* U+696D */	JISX0208(0xb6c8),
	/* U+696E */	JISX0208(0xdcba),
	/* U+696F */	JISX0208(0xbddd),
	/* U+6970 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc44f)),
	/* U+6971 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc450)),
	/* U+6972 */	IFX0213(JISX0213_2(0xaf30),	JISX0212(0xc451)),
	/* U+6973 */	JISX0208(0xc7e0),
	/* U+6974 */	JISX0208(0xdcbc),
	/* U+6975 */	JISX0208(0xb6cb),
	/* U+6976 */	U2E_NODEST_COLX,
	/* U+6977 */	JISX0208(0xdcb4),
	/* U+6978 */	JISX0208(0xdcb6),
	/* U+6979 */	JISX0208(0xdcb3),
	/* U+697A */	IFX0213(JISX0213_2(0xaf31),	JISX0212(0xc452)),
	/* U+697B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc453)),
	/* U+697C */	JISX0208(0xcfb0),
	/* U+697D */	JISX0208(0xb3da),
	/* U+697E */	JISX0208(0xdcb9),
	/* U+697F */	IFX0213(JISX0213_2(0xaf32),	JISX0212(0xc454)),
	/* U+6980 */	IFX0213(JISX0213_1(0xf5f9),	JISX0212(0xc455)),
	/* U+6981 */	JISX0208(0xdcc3),
	/* U+6982 */	JISX0208(0xb3b5),
	/* U+6983 */	U2E_NODEST_COLX,
	/* U+6984 */	U2E_NODEST_COLX,
	/* U+6985 */	U2E_NODEST_COLX,
	/* U+6986 */	U2E_NODEST_COLX,
	/* U+6987 */	U2E_NODEST_COLX,
	/* U+6988 */	U2E_NODEST_COLX,
	/* U+6989 */	U2E_NODEST_COLX,
	/* U+698A */	JISX0208(0xbae7),
	/* U+698B */	U2E_NODEST_COLX,
	/* U+698C */	U2E_NODEST_COLX,
	/* U+698D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc456)),
	/* U+698E */	JISX0208(0xb1dd),
	/* U+698F */	U2E_NODEST_COLX,
	/* U+6990 */	U2E_NODEST_COLX,
	/* U+6991 */	JISX0208(0xdcd4),
	/* U+6992 */	IFX0213(JISX0213_2(0xaf33),	JISX0212(0xc457)),
	/* U+6993 */	U2E_NODEST_COLX,
	/* U+6994 */	JISX0208(0xcfb1),
	/* U+6995 */	JISX0208(0xdcd7),
	/* U+6996 */	IFX0213(JISX0213_2(0xaf35),	JISX0212(0xc458)),
	/* U+6997 */	U2E_NODEST_COLX,
	/* U+6998 */	IFX0213(JISX0213_2(0xaf36),	JISX0212(0xc459)),
	/* U+6999 */	U2E_NODEST_COLX,
	/* U+699A */	U2E_NODEST_COLX,
	/* U+699B */	JISX0208(0xbfba),
	/* U+699C */	JISX0208(0xdcd6),
	/* U+699D */	U2E_NODEST_COLX,
	/* U+699E */	U2E_NODEST_COLX,
	/* U+699F */	U2E_NODEST_COLX,
	/* U+69A0 */	JISX0208(0xdcd5),
	/* U+69A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc45a)),
	/* U+69A2 */	U2E_NODEST_COLX,
	/* U+69A3 */	U2E_NODEST_COLX,
	/* U+69A4 */	U2E_NODEST_COLX,
	/* U+69A5 */	IFX0213(JISX0213_1(0xf5fb),	JISX0212(0xc45b)),
	/* U+69A6 */	IFX0213(JISX0213_2(0xaf37),	JISX0212(0xc45c)),
	/* U+69A7 */	JISX0208(0xdcd2),
	/* U+69A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc45d)),
	/* U+69A9 */	U2E_NODEST_COLX,
	/* U+69AA */	U2E_NODEST_COLX,
	/* U+69AB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc45e)),
	/* U+69AC */	U2E_NODEST_COLX,
	/* U+69AD */	IFX0213(JISX0213_1(0xf5fc),	JISX0212(0xc45f)),
	/* U+69AE */	JISX0208(0xdcc6),
	/* U+69AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc460)),
	/* U+69B0 */	IFX0213(JISX0213_2(0xaf38),	U2E_NODEST_COLX),
	/* U+69B1 */	JISX0208(0xdce3),
	/* U+69B2 */	JISX0208(0xdcc5),
	/* U+69B3 */	U2E_NODEST_COLX,
	/* U+69B4 */	JISX0208(0xdcd8),
	/* U+69B5 */	U2E_NODEST_COLX,
	/* U+69B6 */	U2E_NODEST_COLX,
	/* U+69B7 */	IFX0213(JISX0213_2(0xaf39),	JISX0212(0xc461)),
	/* U+69B8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc462)),
	/* U+69B9 */	U2E_NODEST_COLX,
	/* U+69BA */	IFX0213(JISX0213_2(0xaf3a),	JISX0212(0xc463)),
	/* U+69BB */	JISX0208(0xdcd0),
	/* U+69BC */	IFX0213(JISX0213_2(0xaf3b),	JISX0212(0xc464)),
	/* U+69BD */	U2E_NODEST_COLX,
	/* U+69BE */	JISX0208(0xdccb),
	/* U+69BF */	JISX0208(0xdcc8),
	/* U+69C0 */	IFX0213(JISX0213_2(0xaf3c),	U2E_NODEST_COLX),
	/* U+69C1 */	JISX0208(0xdcc9),
	/* U+69C2 */	U2E_NODEST_COLX,
	/* U+69C3 */	JISX0208(0xdcd1),
	/* U+69C4 */	U2E_NODEST_COLX,
	/* U+69C5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc465)),
	/* U+69C6 */	U2E_NODEST_COLX,
	/* U+69C7 */	JISX0208(0xf4a2),
	/* U+69C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc466)),
	/* U+69C9 */	U2E_NODEST_COLX,
	/* U+69CA */	JISX0208(0xdcce),
	/* U+69CB */	JISX0208(0xb9bd),
	/* U+69CC */	JISX0208(0xc4c8),
	/* U+69CD */	JISX0208(0xc1e4),
	/* U+69CE */	JISX0208(0xdccc),
	/* U+69CF */	IFX0213(JISX0213_1(0xf5fd),	U2E_NODEST_COLX),
	/* U+69D0 */	JISX0208(0xdcc7),
	/* U+69D1 */	IFX0213(JISX0213_2(0xaf3d),	JISX0212(0xc467)),
	/* U+69D2 */	U2E_NODEST_COLX,
	/* U+69D3 */	JISX0208(0xdcca),
	/* U+69D4 */	U2E_NODEST_COLX,
	/* U+69D5 */	U2E_NODEST_COLX,
	/* U+69D6 */	IFX0213(JISX0213_2(0xaf3e),	JISX0212(0xc468)),
	/* U+69D7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc469)),
	/* U+69D8 */	JISX0208(0xcdcd),
	/* U+69D9 */	JISX0208(0xcbea),
	/* U+69DA */	U2E_NODEST_COLX,
	/* U+69DB */	U2E_NODEST_COLX,
	/* U+69DC */	U2E_NODEST_COLX,
	/* U+69DD */	JISX0208(0xdccf),
	/* U+69DE */	JISX0208(0xdcd9),
	/* U+69DF */	U2E_NODEST_COLX,
	/* U+69E0 */	U2E_NODEST_COLX,
	/* U+69E1 */	U2E_NODEST_COLX,
	/* U+69E2 */	IFX0213(JISX0213_1(0xf6a2),	JISX0212(0xc46a)),
	/* U+69E3 */	IFX0213(JISX0213_2(0xaf44),	U2E_NODEST_COLX),
	/* U+69E4 */	U2E_NODEST_COLX,
	/* U+69E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc46b)),
	/* U+69E6 */	U2E_NODEST_COLX,
	/* U+69E7 */	JISX0208(0xdce1),
	/* U+69E8 */	JISX0208(0xdcda),
	/* U+69E9 */	IFX0213(JISX0213_1(0xf6a3),	U2E_NODEST_COLX),
	/* U+69EA */	IFX0213(JISX0213_1(0xf6a4),	U2E_NODEST_COLX),
	/* U+69EB */	JISX0208(0xdce7),
	/* U+69EC */	U2E_NODEST_COLX,
	/* U+69ED */	JISX0208(0xdce5),
	/* U+69EE */	IFX0213(JISX0213_2(0xaf45),	JISX0212(0xc46c)),
	/* U+69EF */	IFX0213(JISX0213_2(0xaf46),	JISX0212(0xc46d)),
	/* U+69F0 */	U2E_NODEST_COLX,
	/* U+69F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc46e)),
	/* U+69F2 */	JISX0208(0xdce0),
	/* U+69F3 */	IFX0213(JISX0213_2(0xaf47),	JISX0212(0xc46f)),
	/* U+69F4 */	IFX0213(JISX0213_2(0xaf49),	U2E_NODEST_COLX),
	/* U+69F5 */	IFX0213(JISX0213_1(0xf6a5),	JISX0212(0xc470)),
	/* U+69F6 */	IFX0213(JISX0213_1(0xf6a6),	U2E_NODEST_COLX),
	/* U+69F7 */	U2E_NODEST_COLX,
	/* U+69F8 */	U2E_NODEST_COLX,
	/* U+69F9 */	JISX0208(0xdcdf),
	/* U+69FA */	U2E_NODEST_COLX,
	/* U+69FB */	JISX0208(0xc4d0),
	/* U+69FC */	U2E_NODEST_COLX,
	/* U+69FD */	JISX0208(0xc1e5),
	/* U+69FE */	IFX0213(JISX0213_2(0xaf4a),	JISX0212(0xc471)),
	/* U+69FF */	JISX0208(0xdcdd),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_6A[] = {
	/* U+6A00 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc472)),
	/* U+6A01 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc473)),
	/* U+6A02 */	JISX0208(0xdcdb),
	/* U+6A03 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc474)),
	/* U+6A04 */	U2E_NODEST_COLX,
	/* U+6A05 */	JISX0208(0xdce2),
	/* U+6A06 */	U2E_NODEST_COLX,
	/* U+6A07 */	U2E_NODEST_COLX,
	/* U+6A08 */	U2E_NODEST_COLX,
	/* U+6A09 */	U2E_NODEST_COLX,
	/* U+6A0A */	JISX0208(0xdce8),
	/* U+6A0B */	JISX0208(0xc8f5),
	/* U+6A0C */	JISX0208(0xdcee),
	/* U+6A0D */	U2E_NODEST_COLX,
	/* U+6A0E */	U2E_NODEST_COLX,
	/* U+6A0F */	IFX0213(JISX0213_1(0xf6a7),	JISX0212(0xc475)),
	/* U+6A10 */	U2E_NODEST_COLX,
	/* U+6A11 */	IFX0213(JISX0213_2(0xaf4b),	JISX0212(0xc476)),
	/* U+6A12 */	JISX0208(0xdce9),
	/* U+6A13 */	JISX0208(0xdcec),
	/* U+6A14 */	JISX0208(0xdce6),
	/* U+6A15 */	IFX0213(JISX0213_1(0xf6a8),	JISX0212(0xc477)),
	/* U+6A16 */	U2E_NODEST_COLX,
	/* U+6A17 */	JISX0208(0xc3f4),
	/* U+6A18 */	U2E_NODEST_COLX,
	/* U+6A19 */	JISX0208(0xc9b8),
	/* U+6A1A */	IFX0213(JISX0213_2(0xaf4c),	JISX0212(0xc478)),
	/* U+6A1B */	JISX0208(0xdcdc),
	/* U+6A1C */	U2E_NODEST_COLX,
	/* U+6A1D */	IFX0213(JISX0213_2(0xaf4d),	JISX0212(0xc479)),
	/* U+6A1E */	JISX0208(0xdce4),
	/* U+6A1F */	JISX0208(0xbec0),
	/* U+6A20 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc47a)),
	/* U+6A21 */	JISX0208(0xcccf),
	/* U+6A22 */	JISX0208(0xdcf8),
	/* U+6A23 */	JISX0208(0xdceb),
	/* U+6A24 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc47b)),
	/* U+6A25 */	U2E_NODEST_COLX,
	/* U+6A26 */	U2E_NODEST_COLX,
	/* U+6A27 */	U2E_NODEST_COLX,
	/* U+6A28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc47c)),
	/* U+6A29 */	JISX0208(0xb8a2),
	/* U+6A2A */	JISX0208(0xb2a3),
	/* U+6A2B */	JISX0208(0xb3df),
	/* U+6A2C */	U2E_NODEST_COLX,
	/* U+6A2D */	U2E_NODEST_COLX,
	/* U+6A2E */	JISX0208(0xdcd3),
	/* U+6A2F */	U2E_NODEST_COLX,
	/* U+6A30 */	IFX0213(JISX0213_2(0xaf41),	JISX0212(0xc47d)),
	/* U+6A31 */	U2E_NODEST_COLX,
	/* U+6A32 */	IFX0213(JISX0213_2(0xaf4f),	JISX0212(0xc47e)),
	/* U+6A33 */	IFX0213(JISX0213_2(0xaf50),	U2E_NODEST_COLX),
	/* U+6A34 */	IFX0213(JISX0213_2(0xaf51),	JISX0212(0xc521)),
	/* U+6A35 */	JISX0208(0xbec1),
	/* U+6A36 */	JISX0208(0xdcf0),
	/* U+6A37 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc522)),
	/* U+6A38 */	JISX0208(0xdcf7),
	/* U+6A39 */	JISX0208(0xbcf9),
	/* U+6A3A */	JISX0208(0xb3f2),
	/* U+6A3B */	IFX0213(JISX0213_1(0xf6aa),	JISX0212(0xc523)),
	/* U+6A3C */	U2E_NODEST_COLX,
	/* U+6A3D */	JISX0208(0xc3ae),
	/* U+6A3E */	IFX0213(JISX0213_1(0xf6ab),	JISX0212(0xc524)),
	/* U+6A3F */	IFX0213(JISX0213_2(0xaf52),	JISX0212(0xc525)),
	/* U+6A40 */	U2E_NODEST_COLX,
	/* U+6A41 */	U2E_NODEST_COLX,
	/* U+6A42 */	U2E_NODEST_COLX,
	/* U+6A43 */	U2E_NODEST_COLX,
	/* U+6A44 */	JISX0208(0xdced),
	/* U+6A45 */	IFX0213(JISX0213_1(0xf6ac),	JISX0212(0xc526)),
	/* U+6A46 */	IFX0213(JISX0213_2(0xaf53),	JISX0212(0xc527)),
	/* U+6A47 */	JISX0208(0xdcf2),
	/* U+6A48 */	JISX0208(0xdcf6),
	/* U+6A49 */	IFX0213(JISX0213_2(0xaf54),	JISX0212(0xc528)),
	/* U+6A4A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc529)),
	/* U+6A4B */	JISX0208(0xb6b6),
	/* U+6A4C */	U2E_NODEST_COLX,
	/* U+6A4D */	U2E_NODEST_COLX,
	/* U+6A4E */	IFX0213(JISX0213_2(0xaf56),	JISX0212(0xc52a)),
	/* U+6A4F */	U2E_NODEST_COLX,
	/* U+6A50 */	IFX0213(JISX0213_1(0xf6ad),	JISX0212(0xc52b)),
	/* U+6A51 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc52c)),
	/* U+6A52 */	IFX0213(JISX0213_2(0xaf57),	JISX0212(0xc52d)),
	/* U+6A53 */	U2E_NODEST_COLX,
	/* U+6A54 */	U2E_NODEST_COLX,
	/* U+6A55 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc52e)),
	/* U+6A56 */	IFX0213(JISX0213_1(0xf6ae),	JISX0212(0xc52f)),
	/* U+6A57 */	U2E_NODEST_COLX,
	/* U+6A58 */	JISX0208(0xb5cc),
	/* U+6A59 */	JISX0208(0xdcf4),
	/* U+6A5A */	U2E_NODEST_COLX,
	/* U+6A5B */	IFX0213(JISX0213_1(0xf6af),	JISX0212(0xc530)),
	/* U+6A5C */	U2E_NODEST_COLX,
	/* U+6A5D */	U2E_NODEST_COLX,
	/* U+6A5E */	U2E_NODEST_COLX,
	/* U+6A5F */	JISX0208(0xb5a1),
	/* U+6A60 */	U2E_NODEST_COLX,
	/* U+6A61 */	JISX0208(0xc6cb),
	/* U+6A62 */	JISX0208(0xdcf3),
	/* U+6A63 */	U2E_NODEST_COLX,
	/* U+6A64 */	IFX0213(JISX0213_2(0xaf58),	JISX0212(0xc531)),
	/* U+6A65 */	U2E_NODEST_COLX,
	/* U+6A66 */	JISX0208(0xdcf5),
	/* U+6A67 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc532)),
	/* U+6A68 */	U2E_NODEST_COLX,
	/* U+6A69 */	U2E_NODEST_COLX,
	/* U+6A6A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc533)),
	/* U+6A6B */	IFX0213(JISX0213_1(0xf6b0),	IBM(0xf449)),
	/* U+6A6C */	U2E_NODEST_COLX,
	/* U+6A6D */	U2E_NODEST_COLX,
	/* U+6A6E */	U2E_NODEST_COLX,
	/* U+6A6F */	U2E_NODEST_COLX,
	/* U+6A70 */	U2E_NODEST_COLX,
	/* U+6A71 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc534)),
	/* U+6A72 */	JISX0208(0xdcef),
	/* U+6A73 */	IFX0213(JISX0213_1(0xf6b1),	JISX0212(0xc535)),
	/* U+6A74 */	U2E_NODEST_COLX,
	/* U+6A75 */	U2E_NODEST_COLX,
	/* U+6A76 */	U2E_NODEST_COLX,
	/* U+6A77 */	U2E_NODEST_COLX,
	/* U+6A78 */	JISX0208(0xdcf1),
	/* U+6A79 */	U2E_NODEST_COLX,
	/* U+6A7A */	IFX0213(JISX0213_2(0xaf55),	U2E_NODEST_COLX),
	/* U+6A7B */	U2E_NODEST_COLX,
	/* U+6A7C */	U2E_NODEST_COLX,
	/* U+6A7D */	U2E_NODEST_COLX,
	/* U+6A7E */	IFX0213(JISX0213_2(0xaf5a),	JISX0212(0xc536)),
	/* U+6A7F */	JISX0208(0xb3e0),
	/* U+6A80 */	JISX0208(0xc3c9),
	/* U+6A81 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc537)),
	/* U+6A82 */	U2E_NODEST_COLX,
	/* U+6A83 */	IFX0213(JISX0213_2(0xaf5b),	JISX0212(0xc538)),
	/* U+6A84 */	JISX0208(0xdcfc),
	/* U+6A85 */	U2E_NODEST_COLX,
	/* U+6A86 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc539)),
	/* U+6A87 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc53a)),
	/* U+6A88 */	U2E_NODEST_COLX,
	/* U+6A89 */	IFX0213(JISX0213_1(0xf6b3),	JISX0212(0xc53b)),
	/* U+6A8A */	U2E_NODEST_COLX,
	/* U+6A8B */	IFX0213(JISX0213_2(0xaf5c),	JISX0212(0xc53c)),
	/* U+6A8C */	U2E_NODEST_COLX,
	/* U+6A8D */	JISX0208(0xdcfa),
	/* U+6A8E */	JISX0208(0xb8e9),
	/* U+6A8F */	U2E_NODEST_COLX,
	/* U+6A90 */	JISX0208(0xdcf9),
	/* U+6A91 */	IFX0213(JISX0213_2(0xaf5e),	JISX0212(0xc53d)),
	/* U+6A92 */	U2E_NODEST_COLX,
	/* U+6A93 */	U2E_NODEST_COLX,
	/* U+6A94 */	IFX0213(JISX0213_1(0xf6b4),	U2E_NODEST_COLX),
	/* U+6A95 */	U2E_NODEST_COLX,
	/* U+6A96 */	U2E_NODEST_COLX,
	/* U+6A97 */	JISX0208(0xdda1),
	/* U+6A98 */	U2E_NODEST_COLX,
	/* U+6A99 */	U2E_NODEST_COLX,
	/* U+6A9A */	U2E_NODEST_COLX,
	/* U+6A9B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc53e)),
	/* U+6A9C */	JISX0208(0xdbd8),
	/* U+6A9D */	IFX0213(JISX0213_1(0xf6b5),	JISX0212(0xc53f)),
	/* U+6A9E */	IFX0213(JISX0213_1(0xf6b6),	JISX0212(0xc540)),
	/* U+6A9F */	IFX0213(JISX0213_2(0xaf5f),	JISX0212(0xc541)),
	/* U+6AA0 */	JISX0208(0xdcfb),
	/* U+6AA1 */	IFX0213(JISX0213_2(0xaf60),	U2E_NODEST_COLX),
	/* U+6AA2 */	JISX0208(0xdcfd),
	/* U+6AA3 */	JISX0208(0xdcfe),
	/* U+6AA4 */	U2E_NODEST_COLX,
	/* U+6AA5 */	IFX0213(JISX0213_1(0xf6b7),	JISX0212(0xc542)),
	/* U+6AA6 */	U2E_NODEST_COLX,
	/* U+6AA7 */	U2E_NODEST_COLX,
	/* U+6AA8 */	U2E_NODEST_COLX,
	/* U+6AA9 */	U2E_NODEST_COLX,
	/* U+6AAA */	JISX0208(0xddac),
	/* U+6AAB */	IFX0213(JISX0213_2(0xaf62),	JISX0212(0xc543)),
	/* U+6AAC */	JISX0208(0xdda8),
	/* U+6AAD */	U2E_NODEST_COLX,
	/* U+6AAE */	JISX0208(0xdbed),
	/* U+6AAF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc544)),
	/* U+6AB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc545)),
	/* U+6AB1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc546)),
	/* U+6AB2 */	U2E_NODEST_COLX,
	/* U+6AB3 */	JISX0208(0xdda7),
	/* U+6AB4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc547)),
	/* U+6AB5 */	U2E_NODEST_COLX,
	/* U+6AB6 */	U2E_NODEST_COLX,
	/* U+6AB7 */	U2E_NODEST_COLX,
	/* U+6AB8 */	JISX0208(0xdda6),
	/* U+6AB9 */	U2E_NODEST_COLX,
	/* U+6ABA */	U2E_NODEST_COLX,
	/* U+6ABB */	JISX0208(0xdda3),
	/* U+6ABC */	U2E_NODEST_COLX,
	/* U+6ABD */	IFX0213(JISX0213_2(0xaf63),	JISX0212(0xc548)),
	/* U+6ABE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc549)),
	/* U+6ABF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc54a)),
	/* U+6AC0 */	U2E_NODEST_COLX,
	/* U+6AC1 */	JISX0208(0xdcea),
	/* U+6AC2 */	JISX0208(0xdda5),
	/* U+6AC3 */	JISX0208(0xdda4),
	/* U+6AC4 */	U2E_NODEST_COLX,
	/* U+6AC5 */	U2E_NODEST_COLX,
	/* U+6AC6 */	IFX0213(JISX0213_2(0xaf64),	JISX0212(0xc54b)),
	/* U+6AC7 */	U2E_NODEST_COLX,
	/* U+6AC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc54d)),
	/* U+6AC9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc54c)),
	/* U+6ACA */	U2E_NODEST_COLX,
	/* U+6ACB */	U2E_NODEST_COLX,
	/* U+6ACC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc54e)),
	/* U+6ACD */	U2E_NODEST_COLX,
	/* U+6ACE */	U2E_NODEST_COLX,
	/* U+6ACF */	U2E_NODEST_COLX,
	/* U+6AD0 */	IFX0213(JISX0213_2(0xaf66),	JISX0212(0xc54f)),
	/* U+6AD1 */	JISX0208(0xddaa),
	/* U+6AD2 */	U2E_NODEST_COLX,
	/* U+6AD3 */	JISX0208(0xcfa6),
	/* U+6AD4 */	IFX0213(JISX0213_2(0xaf65),	JISX0212(0xc550)),
	/* U+6AD5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc551)),
	/* U+6AD6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc552)),
	/* U+6AD7 */	U2E_NODEST_COLX,
	/* U+6AD8 */	U2E_NODEST_COLX,
	/* U+6AD9 */	U2E_NODEST_COLX,
	/* U+6ADA */	JISX0208(0xddad),
	/* U+6ADB */	JISX0208(0xb6fb),
	/* U+6ADC */	IFX0213(JISX0213_2(0xaf67),	JISX0212(0xc553)),
	/* U+6ADD */	IFX0213(JISX0213_2(0xaf68),	JISX0212(0xc554)),
	/* U+6ADE */	JISX0208(0xdda9),
	/* U+6ADF */	JISX0208(0xddab),
	/* U+6AE0 */	U2E_NODEST_COLX,
	/* U+6AE1 */	U2E_NODEST_COLX,
	/* U+6AE2 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf44a)),
	/* U+6AE3 */	U2E_NODEST_COLX,
	/* U+6AE4 */	IFX0213(JISX0213_1(0xf6b8),	JISX0212(0xc555)),
	/* U+6AE5 */	U2E_NODEST_COLX,
	/* U+6AE6 */	U2E_NODEST_COLX,
	/* U+6AE7 */	IFX0213(JISX0213_1(0xf6b9),	JISX0212(0xc556)),
	/* U+6AE8 */	JISX0208(0xc8a7),
	/* U+6AE9 */	U2E_NODEST_COLX,
	/* U+6AEA */	JISX0208(0xddae),
	/* U+6AEB */	U2E_NODEST_COLX,
	/* U+6AEC */	IFX0213(JISX0213_2(0xaf6b),	JISX0212(0xc557)),
	/* U+6AED */	U2E_NODEST_COLX,
	/* U+6AEE */	U2E_NODEST_COLX,
	/* U+6AEF */	U2E_NODEST_COLX,
	/* U+6AF0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc558)),
	/* U+6AF1 */	IFX0213(JISX0213_2(0xaf6c),	JISX0212(0xc559)),
	/* U+6AF2 */	IFX0213(JISX0213_2(0xaf6d),	JISX0212(0xc55a)),
	/* U+6AF3 */	IFX0213(JISX0213_2(0xaf6e),	U2E_NODEST_COLX),
	/* U+6AF4 */	U2E_NODEST_COLX,
	/* U+6AF5 */	U2E_NODEST_COLX,
	/* U+6AF6 */	U2E_NODEST_COLX,
	/* U+6AF7 */	U2E_NODEST_COLX,
	/* U+6AF8 */	U2E_NODEST_COLX,
	/* U+6AF9 */	U2E_NODEST_COLX,
	/* U+6AFA */	JISX0208(0xddb2),
	/* U+6AFB */	JISX0208(0xddaf),
	/* U+6AFC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc55b)),
	/* U+6AFD */	IFX0213(JISX0213_2(0xaf6f),	JISX0212(0xc55c)),
	/* U+6AFE */	U2E_NODEST_COLX,
	/* U+6AFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_6B[] = {
	/* U+6B00 */	U2E_NODEST_COLX,
	/* U+6B01 */	U2E_NODEST_COLX,
	/* U+6B02 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc55d)),
	/* U+6B03 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc55e)),
	/* U+6B04 */	JISX0208(0xcdf3),
	/* U+6B05 */	JISX0208(0xddb0),
	/* U+6B06 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc55f)),
	/* U+6B07 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc560)),
	/* U+6B08 */	U2E_NODEST_COLX,
	/* U+6B09 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc561)),
	/* U+6B0A */	JISX0208(0xdcde),
	/* U+6B0B */	IFX0213(JISX0213_2(0xaf71),	U2E_NODEST_COLX),
	/* U+6B0C */	U2E_NODEST_COLX,
	/* U+6B0D */	U2E_NODEST_COLX,
	/* U+6B0E */	U2E_NODEST_COLX,
	/* U+6B0F */	IFX0213(JISX0213_2(0xaf72),	JISX0212(0xc562)),
	/* U+6B10 */	IFX0213(JISX0213_2(0xaf73),	JISX0212(0xc563)),
	/* U+6B11 */	IFX0213(JISX0213_2(0xaf74),	JISX0212(0xc564)),
	/* U+6B12 */	JISX0208(0xddb3),
	/* U+6B13 */	U2E_NODEST_COLX,
	/* U+6B14 */	U2E_NODEST_COLX,
	/* U+6B15 */	U2E_NODEST_COLX,
	/* U+6B16 */	JISX0208(0xddb4),
	/* U+6B17 */	IFX0213(JISX0213_2(0xaf76),	JISX0212(0xc565)),
	/* U+6B18 */	U2E_NODEST_COLX,
	/* U+6B19 */	U2E_NODEST_COLX,
	/* U+6B1A */	U2E_NODEST_COLX,
	/* U+6B1B */	IFX0213(JISX0213_1(0xf6bc),	JISX0212(0xc566)),
	/* U+6B1C */	U2E_NODEST_COLX,
	/* U+6B1D */	JISX0208(0xb1b5),
	/* U+6B1E */	IFX0213(JISX0213_1(0xf6bd),	JISX0212(0xc567)),
	/* U+6B1F */	JISX0208(0xddb6),
	/* U+6B20 */	JISX0208(0xb7e7),
	/* U+6B21 */	JISX0208(0xbca1),
	/* U+6B22 */	U2E_NODEST_COLX,
	/* U+6B23 */	JISX0208(0xb6d5),
	/* U+6B24 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc568)),
	/* U+6B25 */	U2E_NODEST_COLX,
	/* U+6B26 */	U2E_NODEST_COLX,
	/* U+6B27 */	JISX0208(0xb2a4),
	/* U+6B28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc569)),
	/* U+6B29 */	U2E_NODEST_COLX,
	/* U+6B2A */	U2E_NODEST_COLX,
	/* U+6B2B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc56a)),
	/* U+6B2C */	IFX0213(JISX0213_1(0xf6be),	JISX0212(0xc56b)),
	/* U+6B2D */	U2E_NODEST_COLX,
	/* U+6B2E */	U2E_NODEST_COLX,
	/* U+6B2F */	IFX0213(JISX0213_2(0xaf78),	JISX0212(0xc56c)),
	/* U+6B30 */	U2E_NODEST_COLX,
	/* U+6B31 */	U2E_NODEST_COLX,
	/* U+6B32 */	JISX0208(0xcddf),
	/* U+6B33 */	U2E_NODEST_COLX,
	/* U+6B34 */	U2E_NODEST_COLX,
	/* U+6B35 */	IFX0213(JISX0213_1(0xf6bf),	JISX0212(0xc56d)),
	/* U+6B36 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc56e)),
	/* U+6B37 */	JISX0208(0xddb8),
	/* U+6B38 */	JISX0208(0xddb7),
	/* U+6B39 */	JISX0208(0xddba),
	/* U+6B3A */	JISX0208(0xb5bd),
	/* U+6B3B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc56f)),
	/* U+6B3C */	U2E_NODEST_COLX,
	/* U+6B3D */	JISX0208(0xb6d6),
	/* U+6B3E */	JISX0208(0xb4be),
	/* U+6B3F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc570)),
	/* U+6B40 */	U2E_NODEST_COLX,
	/* U+6B41 */	U2E_NODEST_COLX,
	/* U+6B42 */	U2E_NODEST_COLX,
	/* U+6B43 */	JISX0208(0xddbd),
	/* U+6B44 */	U2E_NODEST_COLX,
	/* U+6B45 */	U2E_NODEST_COLX,
	/* U+6B46 */	IFX0213(JISX0213_1(0xf6c0),	JISX0212(0xc571)),
	/* U+6B47 */	JISX0208(0xddbc),
	/* U+6B48 */	U2E_NODEST_COLX,
	/* U+6B49 */	JISX0208(0xddbe),
	/* U+6B4A */	IFX0213(JISX0213_2(0xaf79),	JISX0212(0xc572)),
	/* U+6B4B */	U2E_NODEST_COLX,
	/* U+6B4C */	JISX0208(0xb2ce),
	/* U+6B4D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc573)),
	/* U+6B4E */	JISX0208(0xc3b7),
	/* U+6B4F */	U2E_NODEST_COLX,
	/* U+6B50 */	JISX0208(0xddbf),
	/* U+6B51 */	U2E_NODEST_COLX,
	/* U+6B52 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc574)),
	/* U+6B53 */	JISX0208(0xb4bf),
	/* U+6B54 */	JISX0208(0xddc1),
	/* U+6B55 */	U2E_NODEST_COLX,
	/* U+6B56 */	IFX0213(JISX0213_1(0xf6c1),	JISX0212(0xc575)),
	/* U+6B57 */	U2E_NODEST_COLX,
	/* U+6B58 */	IFX0213(JISX0213_2(0xaf7a),	JISX0212(0xc576)),
	/* U+6B59 */	JISX0208(0xddc0),
	/* U+6B5A */	U2E_NODEST_COLX,
	/* U+6B5B */	JISX0208(0xddc2),
	/* U+6B5C */	U2E_NODEST_COLX,
	/* U+6B5D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc577)),
	/* U+6B5E */	U2E_NODEST_COLX,
	/* U+6B5F */	JISX0208(0xddc3),
	/* U+6B60 */	IFX0213(JISX0213_1(0xf6c2),	JISX0212(0xc578)),
	/* U+6B61 */	JISX0208(0xddc4),
	/* U+6B62 */	JISX0208(0xbbdf),
	/* U+6B63 */	JISX0208(0xc0b5),
	/* U+6B64 */	JISX0208(0xbaa1),
	/* U+6B65 */	IFX0213(JISX0213_1(0xf6c3),	U2E_NODEST_COLX),
	/* U+6B66 */	JISX0208(0xc9f0),
	/* U+6B67 */	IFX0213(JISX0213_1(0xf6c4),	JISX0212(0xc579)),
	/* U+6B68 */	U2E_NODEST_COLX,
	/* U+6B69 */	JISX0208(0xcae2),
	/* U+6B6A */	JISX0208(0xcfc4),
	/* U+6B6B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc57a)),
	/* U+6B6C */	IFX0213(JISX0213_2(0xaf7b),	U2E_NODEST_COLX),
	/* U+6B6D */	U2E_NODEST_COLX,
	/* U+6B6E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc57b)),
	/* U+6B6F */	JISX0208(0xbbf5),
	/* U+6B70 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc57c)),
	/* U+6B71 */	U2E_NODEST_COLX,
	/* U+6B72 */	U2E_NODEST_COLX,
	/* U+6B73 */	JISX0208(0xbad0),
	/* U+6B74 */	JISX0208(0xcef2),
	/* U+6B75 */	IFX0213(JISX0213_2(0xaf7c),	JISX0212(0xc57d)),
	/* U+6B76 */	U2E_NODEST_COLX,
	/* U+6B77 */	IFX0213(JISX0213_1(0xf6c5),	U2E_NODEST_COLX),
	/* U+6B78 */	JISX0208(0xddc5),
	/* U+6B79 */	JISX0208(0xddc6),
	/* U+6B7A */	IFX0213(JISX0213_2(0xaf7d),	U2E_NODEST_COLX),
	/* U+6B7B */	JISX0208(0xbbe0),
	/* U+6B7C */	U2E_NODEST_COLX,
	/* U+6B7D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc57e)),
	/* U+6B7E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc621)),
	/* U+6B7F */	JISX0208(0xddc7),
	/* U+6B80 */	JISX0208(0xddc8),
	/* U+6B81 */	IFX0213(JISX0213_2(0xaf7e),	U2E_NODEST_COLX),
	/* U+6B82 */	IFX0213(JISX0213_1(0xf6c6),	JISX0212(0xc622)),
	/* U+6B83 */	JISX0208(0xddca),
	/* U+6B84 */	JISX0208(0xddc9),
	/* U+6B85 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc623)),
	/* U+6B86 */	JISX0208(0xcbd8),
	/* U+6B87 */	U2E_NODEST_COLX,
	/* U+6B88 */	U2E_NODEST_COLX,
	/* U+6B89 */	JISX0208(0xbdde),
	/* U+6B8A */	JISX0208(0xbcec),
	/* U+6B8B */	JISX0208(0xbbc4),
	/* U+6B8C */	U2E_NODEST_COLX,
	/* U+6B8D */	JISX0208(0xddcb),
	/* U+6B8E */	U2E_NODEST_COLX,
	/* U+6B8F */	U2E_NODEST_COLX,
	/* U+6B90 */	U2E_NODEST_COLX,
	/* U+6B91 */	U2E_NODEST_COLX,
	/* U+6B92 */	U2E_NODEST_COLX,
	/* U+6B93 */	U2E_NODEST_COLX,
	/* U+6B94 */	U2E_NODEST_COLX,
	/* U+6B95 */	JISX0208(0xddcd),
	/* U+6B96 */	JISX0208(0xbfa3),
	/* U+6B97 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc624)),
	/* U+6B98 */	JISX0208(0xddcc),
	/* U+6B99 */	U2E_NODEST_COLX,
	/* U+6B9A */	U2E_NODEST_COLX,
	/* U+6B9B */	IFX0213(JISX0213_2(0xee21),	JISX0212(0xc625)),
	/* U+6B9C */	U2E_NODEST_COLX,
	/* U+6B9D */	U2E_NODEST_COLX,
	/* U+6B9E */	JISX0208(0xddce),
	/* U+6B9F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc626)),
	/* U+6BA0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc627)),
	/* U+6BA1 */	U2E_NODEST_COLX,
	/* U+6BA2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc628)),
	/* U+6BA3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc629)),
	/* U+6BA4 */	JISX0208(0xddcf),
	/* U+6BA5 */	U2E_NODEST_COLX,
	/* U+6BA6 */	U2E_NODEST_COLX,
	/* U+6BA7 */	U2E_NODEST_COLX,
	/* U+6BA8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc62a)),
	/* U+6BA9 */	IFX0213(JISX0213_1(0xf6c7),	JISX0212(0xc62b)),
	/* U+6BAA */	JISX0208(0xddd0),
	/* U+6BAB */	JISX0208(0xddd1),
	/* U+6BAC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc62c)),
	/* U+6BAD */	IFX0213(JISX0213_1(0xf6c8),	JISX0212(0xc62d)),
	/* U+6BAE */	IFX0213(JISX0213_2(0xee22),	JISX0212(0xc62e)),
	/* U+6BAF */	JISX0208(0xddd2),
	/* U+6BB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc62f)),
	/* U+6BB1 */	JISX0208(0xddd4),
	/* U+6BB2 */	JISX0208(0xddd3),
	/* U+6BB3 */	JISX0208(0xddd5),
	/* U+6BB4 */	JISX0208(0xb2a5),
	/* U+6BB5 */	JISX0208(0xc3ca),
	/* U+6BB6 */	U2E_NODEST_COLX,
	/* U+6BB7 */	JISX0208(0xddd6),
	/* U+6BB8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc630)),
	/* U+6BB9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc631)),
	/* U+6BBA */	JISX0208(0xbba6),
	/* U+6BBB */	JISX0208(0xb3cc),
	/* U+6BBC */	JISX0208(0xddd7),
	/* U+6BBD */	IFX0213(JISX0213_2(0xee24),	JISX0212(0xc632)),
	/* U+6BBE */	IFX0213(JISX0213_2(0xee25),	JISX0212(0xc633)),
	/* U+6BBF */	JISX0208(0xc5c2),
	/* U+6BC0 */	JISX0208(0xd4cc),
	/* U+6BC1 */	U2E_NODEST_COLX,
	/* U+6BC2 */	U2E_NODEST_COLX,
	/* U+6BC3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc634)),
	/* U+6BC4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc635)),
	/* U+6BC5 */	JISX0208(0xb5a3),
	/* U+6BC6 */	JISX0208(0xddd8),
	/* U+6BC7 */	IFX0213(JISX0213_2(0xee26),	U2E_NODEST_COLX),
	/* U+6BC8 */	IFX0213(JISX0213_2(0xee27),	U2E_NODEST_COLX),
	/* U+6BC9 */	IFX0213(JISX0213_2(0xee28),	JISX0212(0xc636)),
	/* U+6BCA */	U2E_NODEST_COLX,
	/* U+6BCB */	JISX0208(0xddd9),
	/* U+6BCC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc637)),
	/* U+6BCD */	JISX0208(0xcaec),
	/* U+6BCE */	JISX0208(0xcbe8),
	/* U+6BCF */	IFX0213(JISX0213_1(0xf6ca),	U2E_NODEST_COLX),
	/* U+6BD0 */	U2E_NODEST_COLX,
	/* U+6BD1 */	U2E_NODEST_COLX,
	/* U+6BD2 */	JISX0208(0xc6c7),
	/* U+6BD3 */	JISX0208(0xddda),
	/* U+6BD4 */	JISX0208(0xc8e6),
	/* U+6BD5 */	U2E_NODEST_COLX,
	/* U+6BD6 */	IFX0213(JISX0213_1(0xf6cb),	JISX0212(0xc638)),
	/* U+6BD7 */	IFX0213(JISX0213_1(0xf6cc),	U2E_NODEST_COLX),
	/* U+6BD8 */	JISX0208(0xc8fb),
	/* U+6BD9 */	U2E_NODEST_COLX,
	/* U+6BDA */	IFX0213(JISX0213_2(0xee29),	JISX0212(0xc639)),
	/* U+6BDB */	JISX0208(0xccd3),
	/* U+6BDC */	U2E_NODEST_COLX,
	/* U+6BDD */	U2E_NODEST_COLX,
	/* U+6BDE */	U2E_NODEST_COLX,
	/* U+6BDF */	JISX0208(0xdddb),
	/* U+6BE0 */	U2E_NODEST_COLX,
	/* U+6BE1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc63a)),
	/* U+6BE2 */	U2E_NODEST_COLX,
	/* U+6BE3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc63b)),
	/* U+6BE4 */	U2E_NODEST_COLX,
	/* U+6BE5 */	U2E_NODEST_COLX,
	/* U+6BE6 */	IFX0213(JISX0213_2(0xee2a),	JISX0212(0xc63c)),
	/* U+6BE7 */	IFX0213(JISX0213_2(0xee2b),	JISX0212(0xc63d)),
	/* U+6BE8 */	U2E_NODEST_COLX,
	/* U+6BE9 */	U2E_NODEST_COLX,
	/* U+6BEA */	U2E_NODEST_COLX,
	/* U+6BEB */	JISX0208(0xdddd),
	/* U+6BEC */	JISX0208(0xdddc),
	/* U+6BED */	U2E_NODEST_COLX,
	/* U+6BEE */	IFX0213(JISX0213_2(0xee2c),	JISX0212(0xc63e)),
	/* U+6BEF */	JISX0208(0xdddf),
	/* U+6BF0 */	U2E_NODEST_COLX,
	/* U+6BF1 */	IFX0213(JISX0213_2(0xee2d),	JISX0212(0xc63f)),
	/* U+6BF2 */	U2E_NODEST_COLX,
	/* U+6BF3 */	JISX0208(0xddde),
	/* U+6BF4 */	U2E_NODEST_COLX,
	/* U+6BF5 */	U2E_NODEST_COLX,
	/* U+6BF6 */	U2E_NODEST_COLX,
	/* U+6BF7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc640)),
	/* U+6BF8 */	U2E_NODEST_COLX,
	/* U+6BF9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc641)),
	/* U+6BFA */	U2E_NODEST_COLX,
	/* U+6BFB */	U2E_NODEST_COLX,
	/* U+6BFC */	U2E_NODEST_COLX,
	/* U+6BFD */	U2E_NODEST_COLX,
	/* U+6BFE */	U2E_NODEST_COLX,
	/* U+6BFF */	IFX0213(JISX0213_1(0xf6cd),	JISX0212(0xc642)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_6C[] = {
	/* U+6C00 */	U2E_NODEST_COLX,
	/* U+6C01 */	U2E_NODEST_COLX,
	/* U+6C02 */	IFX0213(JISX0213_2(0xee2e),	JISX0212(0xc643)),
	/* U+6C03 */	U2E_NODEST_COLX,
	/* U+6C04 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc644)),
	/* U+6C05 */	IFX0213(JISX0213_1(0xf6ce),	JISX0212(0xc645)),
	/* U+6C06 */	U2E_NODEST_COLX,
	/* U+6C07 */	U2E_NODEST_COLX,
	/* U+6C08 */	JISX0208(0xdde1),
	/* U+6C09 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc646)),
	/* U+6C0A */	IFX0213(JISX0213_2(0xee2f),	U2E_NODEST_COLX),
	/* U+6C0B */	U2E_NODEST_COLX,
	/* U+6C0C */	U2E_NODEST_COLX,
	/* U+6C0D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc647)),
	/* U+6C0E */	IFX0213(JISX0213_2(0xee30),	JISX0212(0xc648)),
	/* U+6C0F */	JISX0208(0xbbe1),
	/* U+6C10 */	IFX0213(JISX0213_1(0xf6cf),	JISX0212(0xc649)),
	/* U+6C11 */	JISX0208(0xccb1),
	/* U+6C12 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc64a)),
	/* U+6C13 */	JISX0208(0xdde2),
	/* U+6C14 */	JISX0208(0xdde3),
	/* U+6C15 */	U2E_NODEST_COLX,
	/* U+6C16 */	U2E_NODEST_COLX,
	/* U+6C17 */	JISX0208(0xb5a4),
	/* U+6C18 */	U2E_NODEST_COLX,
	/* U+6C19 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc64b)),
	/* U+6C1A */	U2E_NODEST_COLX,
	/* U+6C1B */	JISX0208(0xdde4),
	/* U+6C1C */	U2E_NODEST_COLX,
	/* U+6C1D */	U2E_NODEST_COLX,
	/* U+6C1E */	U2E_NODEST_COLX,
	/* U+6C1F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc64c)),
	/* U+6C20 */	U2E_NODEST_COLX,
	/* U+6C21 */	U2E_NODEST_COLX,
	/* U+6C22 */	U2E_NODEST_COLX,
	/* U+6C23 */	JISX0208(0xdde6),
	/* U+6C24 */	JISX0208(0xdde5),
	/* U+6C25 */	U2E_NODEST_COLX,
	/* U+6C26 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc64d)),
	/* U+6C27 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc64e)),
	/* U+6C28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc64f)),
	/* U+6C29 */	U2E_NODEST_COLX,
	/* U+6C2A */	U2E_NODEST_COLX,
	/* U+6C2B */	U2E_NODEST_COLX,
	/* U+6C2C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc650)),
	/* U+6C2D */	U2E_NODEST_COLX,
	/* U+6C2E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc651)),
	/* U+6C2F */	U2E_NODEST_COLX,
	/* U+6C30 */	U2E_NODEST_COLX,
	/* U+6C31 */	U2E_NODEST_COLX,
	/* U+6C32 */	U2E_NODEST_COLX,
	/* U+6C33 */	IFX0213(JISX0213_1(0xf6d0),	JISX0212(0xc652)),
	/* U+6C34 */	JISX0208(0xbfe5),
	/* U+6C35 */	IFX0213(JISX0213_2(0xee31),	JISX0212(0xc653)),
	/* U+6C36 */	IFX0213(JISX0213_2(0xee32),	JISX0212(0xc654)),
	/* U+6C37 */	JISX0208(0xc9b9),
	/* U+6C38 */	JISX0208(0xb1ca),
	/* U+6C39 */	U2E_NODEST_COLX,
	/* U+6C3A */	IFX0213(JISX0213_2(0xee33),	JISX0212(0xc655)),
	/* U+6C3B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc656)),
	/* U+6C3C */	U2E_NODEST_COLX,
	/* U+6C3D */	U2E_NODEST_COLX,
	/* U+6C3E */	JISX0208(0xc8c5),
	/* U+6C3F */	IFX0213(JISX0213_2(0xee35),	JISX0212(0xc657)),
	/* U+6C40 */	JISX0208(0xc4f5),
	/* U+6C41 */	JISX0208(0xbdc1),
	/* U+6C42 */	JISX0208(0xb5e1),
	/* U+6C43 */	U2E_NODEST_COLX,
	/* U+6C44 */	U2E_NODEST_COLX,
	/* U+6C45 */	U2E_NODEST_COLX,
	/* U+6C46 */	U2E_NODEST_COLX,
	/* U+6C47 */	U2E_NODEST_COLX,
	/* U+6C48 */	U2E_NODEST_COLX,
	/* U+6C49 */	U2E_NODEST_COLX,
	/* U+6C4A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc658)),
	/* U+6C4B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc659)),
	/* U+6C4C */	U2E_NODEST_COLX,
	/* U+6C4D */	IFX0213(JISX0213_2(0xee36),	JISX0212(0xc65a)),
	/* U+6C4E */	JISX0208(0xc8c6),
	/* U+6C4F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc65b)),
	/* U+6C50 */	JISX0208(0xbcae),
	/* U+6C51 */	U2E_NODEST_COLX,
	/* U+6C52 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc65c)),
	/* U+6C53 */	U2E_NODEST_COLX,
	/* U+6C54 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc65d)),
	/* U+6C55 */	JISX0208(0xdde8),
	/* U+6C56 */	U2E_NODEST_COLX,
	/* U+6C57 */	JISX0208(0xb4c0),
	/* U+6C58 */	U2E_NODEST_COLX,
	/* U+6C59 */	IFX0213(JISX0213_1(0xf6d1),	JISX0212(0xc65e)),
	/* U+6C5A */	JISX0208(0xb1f8),
	/* U+6C5B */	IFX0213(JISX0213_2(0xee37),	JISX0212(0xc65f)),
	/* U+6C5C */	IFX0213(JISX0213_1(0xf6d2),	JISX0212(0xc660)),
	/* U+6C5D */	JISX0208(0xc6f2),
	/* U+6C5E */	JISX0208(0xdde7),
	/* U+6C5F */	JISX0208(0xb9be),
	/* U+6C60 */	JISX0208(0xc3d3),
	/* U+6C61 */	U2E_NODEST_COLX,
	/* U+6C62 */	JISX0208(0xdde9),
	/* U+6C63 */	U2E_NODEST_COLX,
	/* U+6C64 */	U2E_NODEST_COLX,
	/* U+6C65 */	U2E_NODEST_COLX,
	/* U+6C66 */	U2E_NODEST_COLX,
	/* U+6C67 */	IFX0213(JISX0213_2(0xee4f),	JISX0212(0xc736)),
	/* U+6C68 */	JISX0208(0xddf1),
	/* U+6C69 */	U2E_NODEST_COLX,
	/* U+6C6A */	JISX0208(0xddea),
	/* U+6C6B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc661)),
	/* U+6C6C */	U2E_NODEST_COLX,
	/* U+6C6D */	IFX0213(JISX0213_2(0xee38),	JISX0212(0xc662)),
	/* U+6C6E */	U2E_NODEST_COLX,
	/* U+6C6F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc663)),
	/* U+6C70 */	JISX0208(0xc2c1),
	/* U+6C71 */	U2E_NODEST_COLX,
	/* U+6C72 */	JISX0208(0xb5e2),
	/* U+6C73 */	JISX0208(0xddf2),
	/* U+6C74 */	IFX0213(JISX0213_1(0xf6d4),	JISX0212(0xc664)),
	/* U+6C75 */	U2E_NODEST_COLX,
	/* U+6C76 */	IFX0213(JISX0213_1(0xf6d5),	JISX0212(0xc665)),
	/* U+6C77 */	U2E_NODEST_COLX,
	/* U+6C78 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc666)),
	/* U+6C79 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc667)),
	/* U+6C7A */	JISX0208(0xb7e8),
	/* U+6C7B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc668)),
	/* U+6C7C */	U2E_NODEST_COLX,
	/* U+6C7D */	JISX0208(0xb5a5),
	/* U+6C7E */	JISX0208(0xddf0),
	/* U+6C7F */	U2E_NODEST_COLX,
	/* U+6C80 */	U2E_NODEST_COLX,
	/* U+6C81 */	JISX0208(0xddee),
	/* U+6C82 */	JISX0208(0xddeb),
	/* U+6C83 */	JISX0208(0xcde0),
	/* U+6C84 */	IFX0213(JISX0213_2(0xee39),	U2E_NODEST_COLX),
	/* U+6C85 */	IFX0213(JISX0213_1(0xf6d6),	JISX0212(0xc669)),
	/* U+6C86 */	IFX0213(JISX0213_1(0xf6d7),	JISX0212(0xc66a)),
	/* U+6C87 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc66b)),
	/* U+6C88 */	JISX0208(0xc4c0),
	/* U+6C89 */	IFX0213(JISX0213_2(0xee3a),	JISX0212(0xc66c)),
	/* U+6C8A */	U2E_NODEST_COLX,
	/* U+6C8B */	U2E_NODEST_COLX,
	/* U+6C8C */	JISX0208(0xc6d9),
	/* U+6C8D */	JISX0208(0xddec),
	/* U+6C8E */	U2E_NODEST_COLX,
	/* U+6C8F */	U2E_NODEST_COLX,
	/* U+6C90 */	JISX0208(0xddf4),
	/* U+6C91 */	U2E_NODEST_COLX,
	/* U+6C92 */	JISX0208(0xddf3),
	/* U+6C93 */	JISX0208(0xb7a3),
	/* U+6C94 */	IFX0213(JISX0213_2(0xee3c),	JISX0212(0xc66d)),
	/* U+6C95 */	IFX0213(JISX0213_2(0xee3d),	JISX0212(0xc66e)),
	/* U+6C96 */	JISX0208(0xb2ad),
	/* U+6C97 */	IFX0213(JISX0213_2(0xee3e),	JISX0212(0xc66f)),
	/* U+6C98 */	IFX0213(JISX0213_1(0xf6d8),	JISX0212(0xc670)),
	/* U+6C99 */	JISX0208(0xbabb),
	/* U+6C9A */	JISX0208(0xdded),
	/* U+6C9B */	JISX0208(0xddef),
	/* U+6C9C */	IFX0213(JISX0213_1(0xf6d9),	JISX0212(0xc671)),
	/* U+6C9D */	U2E_NODEST_COLX,
	/* U+6C9E */	U2E_NODEST_COLX,
	/* U+6C9F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc672)),
	/* U+6CA0 */	U2E_NODEST_COLX,
	/* U+6CA1 */	JISX0208(0xcbd7),
	/* U+6CA2 */	JISX0208(0xc2f4),
	/* U+6CA3 */	U2E_NODEST_COLX,
	/* U+6CA4 */	U2E_NODEST_COLX,
	/* U+6CA5 */	U2E_NODEST_COLX,
	/* U+6CA6 */	U2E_NODEST_COLX,
	/* U+6CA7 */	U2E_NODEST_COLX,
	/* U+6CA8 */	U2E_NODEST_COLX,
	/* U+6CA9 */	U2E_NODEST_COLX,
	/* U+6CAA */	IFX0213(JISX0213_1(0xf6d3),	U2E_NODEST_COLX),
	/* U+6CAB */	JISX0208(0xcbf7),
	/* U+6CAC */	U2E_NODEST_COLX,
	/* U+6CAD */	IFX0213(JISX0213_2(0xee3f),	U2E_NODEST_COLX),
	/* U+6CAE */	JISX0208(0xddfc),
	/* U+6CAF */	U2E_NODEST_COLX,
	/* U+6CB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc673)),
	/* U+6CB1 */	JISX0208(0xddfd),
	/* U+6CB2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc674)),
	/* U+6CB3 */	JISX0208(0xb2cf),
	/* U+6CB4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc675)),
	/* U+6CB5 */	U2E_NODEST_COLX,
	/* U+6CB6 */	U2E_NODEST_COLX,
	/* U+6CB7 */	U2E_NODEST_COLX,
	/* U+6CB8 */	JISX0208(0xcaa8),
	/* U+6CB9 */	JISX0208(0xccfd),
	/* U+6CBA */	JISX0208(0xdea1),
	/* U+6CBB */	JISX0208(0xbca3),
	/* U+6CBC */	JISX0208(0xbec2),
	/* U+6CBD */	JISX0208(0xddf8),
	/* U+6CBE */	JISX0208(0xddfe),
	/* U+6CBF */	JISX0208(0xb1e8),
	/* U+6CC0 */	U2E_NODEST_COLX,
	/* U+6CC1 */	JISX0208(0xb6b7),
	/* U+6CC2 */	IFX0213(JISX0213_2(0xee40),	JISX0212(0xc676)),
	/* U+6CC3 */	U2E_NODEST_COLX,
	/* U+6CC4 */	JISX0208(0xddf5),
	/* U+6CC5 */	JISX0208(0xddfa),
	/* U+6CC6 */	IFX0213(JISX0213_1(0xf6db),	JISX0212(0xc677)),
	/* U+6CC7 */	U2E_NODEST_COLX,
	/* U+6CC8 */	U2E_NODEST_COLX,
	/* U+6CC9 */	JISX0208(0xc0f4),
	/* U+6CCA */	JISX0208(0xc7f1),
	/* U+6CCB */	U2E_NODEST_COLX,
	/* U+6CCC */	JISX0208(0xc8e7),
	/* U+6CCD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc678)),
	/* U+6CCE */	U2E_NODEST_COLX,
	/* U+6CCF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc679)),
	/* U+6CD0 */	IFX0213(JISX0213_2(0xee41),	JISX0212(0xc67a)),
	/* U+6CD1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc67b)),
	/* U+6CD2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc67c)),
	/* U+6CD3 */	JISX0208(0xddf7),
	/* U+6CD4 */	IFX0213(JISX0213_1(0xf6dc),	JISX0212(0xc67d)),
	/* U+6CD5 */	JISX0208(0xcba1),
	/* U+6CD6 */	IFX0213(JISX0213_2(0xee43),	JISX0212(0xc67e)),
	/* U+6CD7 */	JISX0208(0xddf9),
	/* U+6CD8 */	U2E_NODEST_COLX,
	/* U+6CD9 */	JISX0208(0xdea4),
	/* U+6CDA */	IFX0213(JISX0213_2(0xee44),	JISX0212(0xc721)),
	/* U+6CDB */	JISX0208(0xdea2),
	/* U+6CDC */	IFX0213(JISX0213_2(0xee45),	JISX0212(0xc722)),
	/* U+6CDD */	JISX0208(0xddfb),
	/* U+6CDE */	U2E_NODEST_COLX,
	/* U+6CDF */	U2E_NODEST_COLX,
	/* U+6CE0 */	IFX0213(JISX0213_1(0xf6dd),	JISX0212(0xc723)),
	/* U+6CE1 */	JISX0208(0xcba2),
	/* U+6CE2 */	JISX0208(0xc7c8),
	/* U+6CE3 */	JISX0208(0xb5e3),
	/* U+6CE4 */	U2E_NODEST_COLX,
	/* U+6CE5 */	JISX0208(0xc5a5),
	/* U+6CE6 */	U2E_NODEST_COLX,
	/* U+6CE7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc724)),
	/* U+6CE8 */	JISX0208(0xc3ed),
	/* U+6CE9 */	IFX0213(JISX0213_2(0xee46),	JISX0212(0xc725)),
	/* U+6CEA */	JISX0208(0xdea5),
	/* U+6CEB */	IFX0213(JISX0213_1(0xf6de),	JISX0212(0xc726)),
	/* U+6CEC */	IFX0213(JISX0213_2(0xee47),	JISX0212(0xc727)),
	/* U+6CED */	IFX0213(JISX0213_2(0xee48),	U2E_NODEST_COLX),
	/* U+6CEE */	IFX0213(JISX0213_1(0xf6df),	JISX0212(0xc728)),
	/* U+6CEF */	JISX0208(0xdea3),
	/* U+6CF0 */	JISX0208(0xc2d9),
	/* U+6CF1 */	JISX0208(0xddf6),
	/* U+6CF2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc729)),
	/* U+6CF3 */	JISX0208(0xb1cb),
	/* U+6CF4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc72a)),
	/* U+6CF5 */	U2E_NODEST_COLX,
	/* U+6CF6 */	U2E_NODEST_COLX,
	/* U+6CF7 */	U2E_NODEST_COLX,
	/* U+6CF8 */	U2E_NODEST_COLX,
	/* U+6CF9 */	U2E_NODEST_COLX,
	/* U+6CFA */	U2E_NODEST_COLX,
	/* U+6CFB */	IFX0213(JISX0213_1(0xf6da),	U2E_NODEST_COLX),
	/* U+6CFC */	U2E_NODEST_COLX,
	/* U+6CFD */	U2E_NODEST_COLX,
	/* U+6CFE */	U2E_NODEST_COLX,
	/* U+6CFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_6D[] = {
	/* U+6D00 */	IFX0213(JISX0213_2(0xee4a),	U2E_NODEST_COLX),
	/* U+6D01 */	U2E_NODEST_COLX,
	/* U+6D02 */	U2E_NODEST_COLX,
	/* U+6D03 */	U2E_NODEST_COLX,
	/* U+6D04 */	IFX0213(JISX0213_1(0xf6e1),	JISX0212(0xc72b)),
	/* U+6D05 */	U2E_NODEST_COLX,
	/* U+6D06 */	U2E_NODEST_COLX,
	/* U+6D07 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc72c)),
	/* U+6D08 */	U2E_NODEST_COLX,
	/* U+6D09 */	U2E_NODEST_COLX,
	/* U+6D0A */	IFX0213(JISX0213_2(0xee4b),	JISX0212(0xc72d)),
	/* U+6D0B */	JISX0208(0xcdce),
	/* U+6D0C */	JISX0208(0xdeb0),
	/* U+6D0D */	U2E_NODEST_COLX,
	/* U+6D0E */	IFX0213(JISX0213_1(0xf6e2),	JISX0212(0xc72e)),
	/* U+6D0F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc72f)),
	/* U+6D10 */	U2E_NODEST_COLX,
	/* U+6D11 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc730)),
	/* U+6D12 */	JISX0208(0xdeaf),
	/* U+6D13 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc731)),
	/* U+6D14 */	U2E_NODEST_COLX,
	/* U+6D15 */	U2E_NODEST_COLX,
	/* U+6D16 */	U2E_NODEST_COLX,
	/* U+6D17 */	JISX0208(0xc0f6),
	/* U+6D18 */	U2E_NODEST_COLX,
	/* U+6D19 */	JISX0208(0xdeac),
	/* U+6D1A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc732)),
	/* U+6D1B */	JISX0208(0xcdec),
	/* U+6D1C */	U2E_NODEST_COLX,
	/* U+6D1D */	U2E_NODEST_COLX,
	/* U+6D1E */	JISX0208(0xc6b6),
	/* U+6D1F */	JISX0208(0xdea6),
	/* U+6D20 */	U2E_NODEST_COLX,
	/* U+6D21 */	U2E_NODEST_COLX,
	/* U+6D22 */	U2E_NODEST_COLX,
	/* U+6D23 */	U2E_NODEST_COLX,
	/* U+6D24 */	IFX0213(JISX0213_2(0xee4c),	U2E_NODEST_COLX),
	/* U+6D25 */	JISX0208(0xc4c5),
	/* U+6D26 */	IFX0213(JISX0213_2(0xee4d),	JISX0212(0xc733)),
	/* U+6D27 */	IFX0213(JISX0213_2(0xee4e),	JISX0212(0xc734)),
	/* U+6D28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc735)),
	/* U+6D29 */	JISX0208(0xb1cc),
	/* U+6D2A */	JISX0208(0xb9bf),
	/* U+6D2B */	JISX0208(0xdea9),
	/* U+6D2C */	U2E_NODEST_COLX,
	/* U+6D2D */	U2E_NODEST_COLX,
	/* U+6D2E */	IFX0213(JISX0213_1(0xf6e3),	JISX0212(0xc737)),
	/* U+6D2F */	IFX0213(JISX0213_2(0xee50),	JISX0212(0xc738)),
	/* U+6D30 */	U2E_NODEST_COLX,
	/* U+6D31 */	IFX0213(JISX0213_1(0xf6e4),	JISX0212(0xc739)),
	/* U+6D32 */	JISX0208(0xbda7),
	/* U+6D33 */	JISX0208(0xdeae),
	/* U+6D34 */	IFX0213(JISX0213_2(0xee65),	U2E_NODEST_COLX),
	/* U+6D35 */	JISX0208(0xdead),
	/* U+6D36 */	JISX0208(0xdea8),
	/* U+6D37 */	U2E_NODEST_COLX,
	/* U+6D38 */	JISX0208(0xdeab),
	/* U+6D39 */	IFX0213(JISX0213_1(0xf6e5),	JISX0212(0xc73a)),
	/* U+6D3A */	U2E_NODEST_COLX,
	/* U+6D3B */	JISX0208(0xb3e8),
	/* U+6D3C */	IFX0213(JISX0213_2(0xee51),	JISX0212(0xc73b)),
	/* U+6D3D */	JISX0208(0xdeaa),
	/* U+6D3E */	JISX0208(0xc7c9),
	/* U+6D3F */	IFX0213(JISX0213_1(0xf6e6),	JISX0212(0xc73c)),
	/* U+6D40 */	U2E_NODEST_COLX,
	/* U+6D41 */	JISX0208(0xceae),
	/* U+6D42 */	U2E_NODEST_COLX,
	/* U+6D43 */	U2E_NODEST_COLX,
	/* U+6D44 */	JISX0208(0xbef4),
	/* U+6D45 */	JISX0208(0xc0f5),
	/* U+6D46 */	U2E_NODEST_COLX,
	/* U+6D47 */	U2E_NODEST_COLX,
	/* U+6D48 */	U2E_NODEST_COLX,
	/* U+6D49 */	U2E_NODEST_COLX,
	/* U+6D4A */	U2E_NODEST_COLX,
	/* U+6D4B */	U2E_NODEST_COLX,
	/* U+6D4C */	U2E_NODEST_COLX,
	/* U+6D4D */	U2E_NODEST_COLX,
	/* U+6D4E */	U2E_NODEST_COLX,
	/* U+6D4F */	U2E_NODEST_COLX,
	/* U+6D50 */	U2E_NODEST_COLX,
	/* U+6D51 */	U2E_NODEST_COLX,
	/* U+6D52 */	U2E_NODEST_COLX,
	/* U+6D53 */	U2E_NODEST_COLX,
	/* U+6D54 */	U2E_NODEST_COLX,
	/* U+6D55 */	U2E_NODEST_COLX,
	/* U+6D56 */	U2E_NODEST_COLX,
	/* U+6D57 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc73d)),
	/* U+6D58 */	IFX0213(JISX0213_1(0xf6e7),	U2E_NODEST_COLX),
	/* U+6D59 */	JISX0208(0xdeb6),
	/* U+6D5A */	JISX0208(0xdeb4),
	/* U+6D5B */	IFX0213(JISX0213_2(0xee52),	U2E_NODEST_COLX),
	/* U+6D5C */	JISX0208(0xc9cd),
	/* U+6D5D */	U2E_NODEST_COLX,
	/* U+6D5E */	IFX0213(JISX0213_2(0xee53),	JISX0212(0xc73e)),
	/* U+6D5F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc73f)),
	/* U+6D60 */	IFX0213(JISX0213_2(0xee54),	U2E_NODEST_COLX),
	/* U+6D61 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc740)),
	/* U+6D62 */	U2E_NODEST_COLX,
	/* U+6D63 */	JISX0208(0xdeb1),
	/* U+6D64 */	JISX0208(0xdeb3),
	/* U+6D65 */	IFX0213(JISX0213_1(0xf6e8),	JISX0212(0xc741)),
	/* U+6D66 */	JISX0208(0xb1ba),
	/* U+6D67 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc742)),
	/* U+6D68 */	U2E_NODEST_COLX,
	/* U+6D69 */	JISX0208(0xb9c0),
	/* U+6D6A */	JISX0208(0xcfb2),
	/* U+6D6B */	U2E_NODEST_COLX,
	/* U+6D6C */	JISX0208(0xb3bd),
	/* U+6D6D */	U2E_NODEST_COLX,
	/* U+6D6E */	JISX0208(0xc9e2),
	/* U+6D6F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc743)),
	/* U+6D70 */	IFX0213(JISX0213_2(0xee55),	JISX0212(0xc744)),
	/* U+6D71 */	U2E_NODEST_COLX,
	/* U+6D72 */	U2E_NODEST_COLX,
	/* U+6D73 */	U2E_NODEST_COLX,
	/* U+6D74 */	JISX0208(0xcde1),
	/* U+6D75 */	U2E_NODEST_COLX,
	/* U+6D76 */	U2E_NODEST_COLX,
	/* U+6D77 */	JISX0208(0xb3a4),
	/* U+6D78 */	JISX0208(0xbfbb),
	/* U+6D79 */	JISX0208(0xdeb5),
	/* U+6D7A */	U2E_NODEST_COLX,
	/* U+6D7B */	U2E_NODEST_COLX,
	/* U+6D7C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc745)),
	/* U+6D7D */	U2E_NODEST_COLX,
	/* U+6D7E */	U2E_NODEST_COLX,
	/* U+6D7F */	U2E_NODEST_COLX,
	/* U+6D80 */	IFX0213(JISX0213_2(0xee56),	U2E_NODEST_COLX),
	/* U+6D81 */	IFX0213(JISX0213_2(0xee57),	U2E_NODEST_COLX),
	/* U+6D82 */	IFX0213(JISX0213_1(0xf6ea),	JISX0212(0xc746)),
	/* U+6D83 */	U2E_NODEST_COLX,
	/* U+6D84 */	U2E_NODEST_COLX,
	/* U+6D85 */	JISX0208(0xdeba),
	/* U+6D86 */	U2E_NODEST_COLX,
	/* U+6D87 */	IFX0213(JISX0213_1(0xf6eb),	JISX0212(0xc747)),
	/* U+6D88 */	JISX0208(0xbec3),
	/* U+6D89 */	IFX0213(JISX0213_1(0xf6ec),	U2E_NODEST_COLX),
	/* U+6D8A */	IFX0213(JISX0213_2(0xee58),	U2E_NODEST_COLX),
	/* U+6D8B */	U2E_NODEST_COLX,
	/* U+6D8C */	JISX0208(0xcdb0),
	/* U+6D8D */	IFX0213(JISX0213_2(0xee59),	U2E_NODEST_COLX),
	/* U+6D8E */	JISX0208(0xdeb7),
	/* U+6D8F */	U2E_NODEST_COLX,
	/* U+6D90 */	U2E_NODEST_COLX,
	/* U+6D91 */	IFX0213(JISX0213_2(0xee5a),	JISX0212(0xc748)),
	/* U+6D92 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc749)),
	/* U+6D93 */	JISX0208(0xdeb2),
	/* U+6D94 */	IFX0213(JISX0213_1(0xf6ed),	JISX0212(0xc74a)),
	/* U+6D95 */	JISX0208(0xdeb8),
	/* U+6D96 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc74b)),
	/* U+6D97 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc74c)),
	/* U+6D98 */	IFX0213(JISX0213_2(0xee5b),	JISX0212(0xc74d)),
	/* U+6D99 */	JISX0208(0xcede),
	/* U+6D9A */	U2E_NODEST_COLX,
	/* U+6D9B */	JISX0208(0xc5f3),
	/* U+6D9C */	JISX0208(0xc6c2),
	/* U+6D9D */	U2E_NODEST_COLX,
	/* U+6D9E */	U2E_NODEST_COLX,
	/* U+6D9F */	U2E_NODEST_COLX,
	/* U+6DA0 */	U2E_NODEST_COLX,
	/* U+6DA1 */	U2E_NODEST_COLX,
	/* U+6DA2 */	U2E_NODEST_COLX,
	/* U+6DA3 */	U2E_NODEST_COLX,
	/* U+6DA4 */	U2E_NODEST_COLX,
	/* U+6DA5 */	U2E_NODEST_COLX,
	/* U+6DA6 */	U2E_NODEST_COLX,
	/* U+6DA7 */	U2E_NODEST_COLX,
	/* U+6DA8 */	U2E_NODEST_COLX,
	/* U+6DA9 */	U2E_NODEST_COLX,
	/* U+6DAA */	IFX0213(JISX0213_1(0xf6ee),	JISX0212(0xc74e)),
	/* U+6DAB */	IFX0213(JISX0213_2(0xee61),	U2E_NODEST_COLX),
	/* U+6DAC */	IFX0213(JISX0213_1(0xf6ef),	JISX0212(0xc74f)),
	/* U+6DAD */	U2E_NODEST_COLX,
	/* U+6DAE */	IFX0213(JISX0213_2(0xee62),	U2E_NODEST_COLX),
	/* U+6DAF */	JISX0208(0xb3b6),
	/* U+6DB0 */	U2E_NODEST_COLX,
	/* U+6DB1 */	U2E_NODEST_COLX,
	/* U+6DB2 */	JISX0208(0xb1d5),
	/* U+6DB3 */	U2E_NODEST_COLX,
	/* U+6DB4 */	IFX0213(JISX0213_2(0xee63),	JISX0212(0xc750)),
	/* U+6DB5 */	JISX0208(0xdebe),
	/* U+6DB6 */	U2E_NODEST_COLX,
	/* U+6DB7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc751)),
	/* U+6DB8 */	JISX0208(0xdec1),
	/* U+6DB9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc752)),
	/* U+6DBA */	U2E_NODEST_COLX,
	/* U+6DBB */	U2E_NODEST_COLX,
	/* U+6DBC */	JISX0208(0xcec3),
	/* U+6DBD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc753)),
	/* U+6DBE */	U2E_NODEST_COLX,
	/* U+6DBF */	IFX0213(JISX0213_1(0xf6f0),	JISX0212(0xc754)),
	/* U+6DC0 */	JISX0208(0xcde4),
	/* U+6DC1 */	U2E_NODEST_COLX,
	/* U+6DC2 */	IFX0213(JISX0213_2(0xee64),	U2E_NODEST_COLX),
	/* U+6DC3 */	U2E_NODEST_COLX,
	/* U+6DC4 */	IFX0213(JISX0213_1(0xf6f1),	JISX0212(0xc755)),
	/* U+6DC5 */	JISX0208(0xdec8),
	/* U+6DC6 */	JISX0208(0xdec2),
	/* U+6DC7 */	JISX0208(0xdebf),
	/* U+6DC8 */	IFX0213(JISX0213_2(0xee66),	JISX0212(0xc756)),
	/* U+6DC9 */	U2E_NODEST_COLX,
	/* U+6DCA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc757)),
	/* U+6DCB */	JISX0208(0xced4),
	/* U+6DCC */	JISX0208(0xdec5),
	/* U+6DCD */	U2E_NODEST_COLX,
	/* U+6DCE */	IFX0213(JISX0213_2(0xee67),	JISX0212(0xc758)),
	/* U+6DCF */	IFX0213(JISX0213_2(0xee68),	JISX0212(0xc759)),
	/* U+6DD0 */	IFX0213(JISX0213_2(0xee69),	U2E_NODEST_COLX),
	/* U+6DD1 */	JISX0208(0xbdca),
	/* U+6DD2 */	JISX0208(0xdec7),
	/* U+6DD3 */	U2E_NODEST_COLX,
	/* U+6DD4 */	U2E_NODEST_COLX,
	/* U+6DD5 */	JISX0208(0xdecc),
	/* U+6DD6 */	IFX0213(JISX0213_1(0xf6f2),	JISX0212(0xc75a)),
	/* U+6DD7 */	U2E_NODEST_COLX,
	/* U+6DD8 */	JISX0208(0xc5f1),
	/* U+6DD9 */	JISX0208(0xdeca),
	/* U+6DDA */	IFX0213(JISX0213_1(0xf6f3),	U2E_NODEST_COLX),
	/* U+6DDB */	IFX0213(JISX0213_1(0xf6f4),	JISX0212(0xc75b)),
	/* U+6DDC */	U2E_NODEST_COLX,
	/* U+6DDD */	IFX0213(JISX0213_1(0xf6f5),	JISX0212(0xc75c)),
	/* U+6DDE */	JISX0208(0xdec4),
	/* U+6DDF */	IFX0213(JISX0213_2(0xee6a),	JISX0212(0xc75d)),
	/* U+6DE0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc75e)),
	/* U+6DE1 */	JISX0208(0xc3b8),
	/* U+6DE2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc75f)),
	/* U+6DE3 */	U2E_NODEST_COLX,
	/* U+6DE4 */	JISX0208(0xdecb),
	/* U+6DE5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc760)),
	/* U+6DE6 */	JISX0208(0xdec0),
	/* U+6DE7 */	U2E_NODEST_COLX,
	/* U+6DE8 */	JISX0208(0xdec6),
	/* U+6DE9 */	IFX0213(JISX0213_2(0xee6b),	JISX0212(0xc761)),
	/* U+6DEA */	JISX0208(0xdecd),
	/* U+6DEB */	JISX0208(0xb0fc),
	/* U+6DEC */	JISX0208(0xdec3),
	/* U+6DED */	U2E_NODEST_COLX,
	/* U+6DEE */	JISX0208(0xdece),
	/* U+6DEF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc762)),
	/* U+6DF0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc763)),
	/* U+6DF1 */	JISX0208(0xbfbc),
	/* U+6DF2 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf44c)),
	/* U+6DF3 */	JISX0208(0xbddf),
	/* U+6DF4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc764)),
	/* U+6DF5 */	JISX0208(0xcaa5),
	/* U+6DF6 */	IFX0213(JISX0213_2(0xee6c),	JISX0212(0xc765)),
	/* U+6DF7 */	JISX0208(0xbaae),
	/* U+6DF8 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf44b)),
	/* U+6DF9 */	JISX0208(0xdebb),
	/* U+6DFA */	JISX0208(0xdec9),
	/* U+6DFB */	JISX0208(0xc5ba),
	/* U+6DFC */	IFX0213(JISX0213_1(0xf6f6),	JISX0212(0xc766)),
	/* U+6DFD */	U2E_NODEST_COLX,
	/* U+6DFE */	U2E_NODEST_COLX,
	/* U+6DFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_6E[] = {
	/* U+6E00 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc767)),
	/* U+6E01 */	U2E_NODEST_COLX,
	/* U+6E02 */	U2E_NODEST_COLX,
	/* U+6E03 */	U2E_NODEST_COLX,
	/* U+6E04 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc768)),
	/* U+6E05 */	JISX0208(0xc0b6),
	/* U+6E06 */	U2E_NODEST_COLX,
	/* U+6E07 */	JISX0208(0xb3e9),
	/* U+6E08 */	JISX0208(0xbad1),
	/* U+6E09 */	JISX0208(0xbec4),
	/* U+6E0A */	JISX0208(0xdebd),
	/* U+6E0B */	JISX0208(0xbdc2),
	/* U+6E0C */	U2E_NODEST_COLX,
	/* U+6E0D */	U2E_NODEST_COLX,
	/* U+6E0E */	U2E_NODEST_COLX,
	/* U+6E0F */	U2E_NODEST_COLX,
	/* U+6E10 */	U2E_NODEST_COLX,
	/* U+6E11 */	U2E_NODEST_COLX,
	/* U+6E12 */	U2E_NODEST_COLX,
	/* U+6E13 */	JISX0208(0xb7cc),
	/* U+6E14 */	U2E_NODEST_COLX,
	/* U+6E15 */	JISX0208(0xdebc),
	/* U+6E16 */	U2E_NODEST_COLX,
	/* U+6E17 */	IFX0213(JISX0213_2(0xee5d),	U2E_NODEST_COLX),
	/* U+6E18 */	U2E_NODEST_COLX,
	/* U+6E19 */	JISX0208(0xded2),
	/* U+6E1A */	JISX0208(0xbded),
	/* U+6E1B */	JISX0208(0xb8ba),
	/* U+6E1C */	U2E_NODEST_COLX,
	/* U+6E1D */	JISX0208(0xdee1),
	/* U+6E1E */	IFX0213(JISX0213_2(0xee6e),	JISX0212(0xc769)),
	/* U+6E1F */	JISX0208(0xdedb),
	/* U+6E20 */	JISX0208(0xb5f4),
	/* U+6E21 */	JISX0208(0xc5cf),
	/* U+6E22 */	IFX0213(JISX0213_2(0xee6f),	JISX0212(0xc76a)),
	/* U+6E23 */	JISX0208(0xded6),
	/* U+6E24 */	JISX0208(0xdedf),
	/* U+6E25 */	JISX0208(0xb0af),
	/* U+6E26 */	JISX0208(0xb1b2),
	/* U+6E27 */	IFX0213(JISX0213_2(0xee70),	JISX0212(0xc76b)),
	/* U+6E28 */	U2E_NODEST_COLX,
	/* U+6E29 */	JISX0208(0xb2b9),
	/* U+6E2A */	U2E_NODEST_COLX,
	/* U+6E2B */	JISX0208(0xded8),
	/* U+6E2C */	JISX0208(0xc2ac),
	/* U+6E2D */	JISX0208(0xdecf),
	/* U+6E2E */	JISX0208(0xded1),
	/* U+6E2F */	JISX0208(0xb9c1),
	/* U+6E30 */	U2E_NODEST_COLX,
	/* U+6E31 */	U2E_NODEST_COLX,
	/* U+6E32 */	IFX0213(JISX0213_2(0xee72),	JISX0212(0xc76c)),
	/* U+6E33 */	U2E_NODEST_COLX,
	/* U+6E34 */	IFX0213(JISX0213_1(0xf6f8),	U2E_NODEST_COLX),
	/* U+6E35 */	U2E_NODEST_COLX,
	/* U+6E36 */	IFX0213(JISX0213_2(0xee6d),	JISX0212(0xc76d)),
	/* U+6E37 */	U2E_NODEST_COLX,
	/* U+6E38 */	JISX0208(0xdee2),
	/* U+6E39 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc76e)),
	/* U+6E3A */	JISX0208(0xdedd),
	/* U+6E3B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc76f)),
	/* U+6E3C */	IFX0213(JISX0213_2(0xee73),	JISX0212(0xc770)),
	/* U+6E3D */	U2E_NODEST_COLX,
	/* U+6E3E */	JISX0208(0xded5),
	/* U+6E3F */	U2E_NODEST_COLX,
	/* U+6E40 */	U2E_NODEST_COLX,
	/* U+6E41 */	U2E_NODEST_COLX,
	/* U+6E42 */	U2E_NODEST_COLX,
	/* U+6E43 */	JISX0208(0xdedc),
	/* U+6E44 */	IFX0213(JISX0213_1(0xf6f9),	JISX0212(0xc771)),
	/* U+6E45 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc772)),
	/* U+6E46 */	U2E_NODEST_COLX,
	/* U+6E47 */	U2E_NODEST_COLX,
	/* U+6E48 */	IFX0213(JISX0213_2(0xee74),	JISX0212(0xc773)),
	/* U+6E49 */	IFX0213(JISX0213_2(0xee75),	JISX0212(0xc774)),
	/* U+6E4A */	JISX0208(0xccab),
	/* U+6E4B */	IFX0213(JISX0213_2(0xee76),	JISX0212(0xc775)),
	/* U+6E4C */	IFX0213(JISX0213_2(0xee77),	U2E_NODEST_COLX),
	/* U+6E4D */	JISX0208(0xdeda),
	/* U+6E4E */	JISX0208(0xdede),
	/* U+6E4F */	IFX0213(JISX0213_2(0xee78),	JISX0212(0xc776)),
	/* U+6E50 */	U2E_NODEST_COLX,
	/* U+6E51 */	IFX0213(JISX0213_2(0xee79),	JISX0212(0xc777)),
	/* U+6E52 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc778)),
	/* U+6E53 */	IFX0213(JISX0213_2(0xee7a),	JISX0212(0xc779)),
	/* U+6E54 */	IFX0213(JISX0213_2(0xee7b),	JISX0212(0xc77a)),
	/* U+6E55 */	U2E_NODEST_COLX,
	/* U+6E56 */	JISX0208(0xb8d0),
	/* U+6E57 */	IFX0213(JISX0213_2(0xee7c),	JISX0212(0xc77b)),
	/* U+6E58 */	JISX0208(0xbec5),
	/* U+6E59 */	U2E_NODEST_COLX,
	/* U+6E5A */	U2E_NODEST_COLX,
	/* U+6E5B */	JISX0208(0xc3b9),
	/* U+6E5C */	IFX0213(JISX0213_1(0xf6fa),	JISX0212(0xc77c)),
	/* U+6E5D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc77d)),
	/* U+6E5E */	IFX0213(JISX0213_1(0xf6fb),	JISX0212(0xc77e)),
	/* U+6E5F */	JISX0208(0xded4),
	/* U+6E60 */	U2E_NODEST_COLX,
	/* U+6E61 */	U2E_NODEST_COLX,
	/* U+6E62 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc821)),
	/* U+6E63 */	IFX0213(JISX0213_2(0xee7d),	JISX0212(0xc822)),
	/* U+6E64 */	U2E_NODEST_COLX,
	/* U+6E65 */	U2E_NODEST_COLX,
	/* U+6E66 */	U2E_NODEST_COLX,
	/* U+6E67 */	JISX0208(0xcdaf),
	/* U+6E68 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc823)),
	/* U+6E69 */	U2E_NODEST_COLX,
	/* U+6E6A */	U2E_NODEST_COLX,
	/* U+6E6B */	JISX0208(0xded7),
	/* U+6E6C */	U2E_NODEST_COLX,
	/* U+6E6D */	U2E_NODEST_COLX,
	/* U+6E6E */	JISX0208(0xded0),
	/* U+6E6F */	JISX0208(0xc5f2),
	/* U+6E70 */	U2E_NODEST_COLX,
	/* U+6E71 */	U2E_NODEST_COLX,
	/* U+6E72 */	JISX0208(0xded3),
	/* U+6E73 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc824)),
	/* U+6E74 */	U2E_NODEST_COLX,
	/* U+6E75 */	U2E_NODEST_COLX,
	/* U+6E76 */	JISX0208(0xded9),
	/* U+6E77 */	U2E_NODEST_COLX,
	/* U+6E78 */	U2E_NODEST_COLX,
	/* U+6E79 */	U2E_NODEST_COLX,
	/* U+6E7A */	U2E_NODEST_COLX,
	/* U+6E7B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc825)),
	/* U+6E7C */	U2E_NODEST_COLX,
	/* U+6E7D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc826)),
	/* U+6E7E */	JISX0208(0xcfd1),
	/* U+6E7F */	JISX0208(0xbcbe),
	/* U+6E80 */	JISX0208(0xcbfe),
	/* U+6E81 */	U2E_NODEST_COLX,
	/* U+6E82 */	JISX0208(0xdee3),
	/* U+6E83 */	U2E_NODEST_COLX,
	/* U+6E84 */	U2E_NODEST_COLX,
	/* U+6E85 */	U2E_NODEST_COLX,
	/* U+6E86 */	U2E_NODEST_COLX,
	/* U+6E87 */	U2E_NODEST_COLX,
	/* U+6E88 */	U2E_NODEST_COLX,
	/* U+6E89 */	U2E_NODEST_COLX,
	/* U+6E8A */	U2E_NODEST_COLX,
	/* U+6E8B */	U2E_NODEST_COLX,
	/* U+6E8C */	JISX0208(0xc8ae),
	/* U+6E8D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc827)),
	/* U+6E8E */	U2E_NODEST_COLX,
	/* U+6E8F */	JISX0208(0xdeef),
	/* U+6E90 */	JISX0208(0xb8bb),
	/* U+6E91 */	U2E_NODEST_COLX,
	/* U+6E92 */	U2E_NODEST_COLX,
	/* U+6E93 */	IFX0213(JISX0213_2(0xef21),	JISX0212(0xc828)),
	/* U+6E94 */	U2E_NODEST_COLX,
	/* U+6E95 */	U2E_NODEST_COLX,
	/* U+6E96 */	JISX0208(0xbde0),
	/* U+6E97 */	U2E_NODEST_COLX,
	/* U+6E98 */	JISX0208(0xdee5),
	/* U+6E99 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc829)),
	/* U+6E9A */	U2E_NODEST_COLX,
	/* U+6E9B */	U2E_NODEST_COLX,
	/* U+6E9C */	JISX0208(0xceaf),
	/* U+6E9D */	JISX0208(0xb9c2),
	/* U+6E9E */	U2E_NODEST_COLX,
	/* U+6E9F */	JISX0208(0xdef2),
	/* U+6EA0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc82a)),
	/* U+6EA1 */	U2E_NODEST_COLX,
	/* U+6EA2 */	JISX0208(0xb0ee),
	/* U+6EA3 */	U2E_NODEST_COLX,
	/* U+6EA4 */	U2E_NODEST_COLX,
	/* U+6EA5 */	JISX0208(0xdef0),
	/* U+6EA6 */	U2E_NODEST_COLX,
	/* U+6EA7 */	IFX0213(JISX0213_2(0xef22),	JISX0212(0xc82b)),
	/* U+6EA8 */	U2E_NODEST_COLX,
	/* U+6EA9 */	U2E_NODEST_COLX,
	/* U+6EAA */	JISX0208(0xdee4),
	/* U+6EAB */	IFX0213(JISX0213_1(0xf6fc),	U2E_NODEST_COLX),
	/* U+6EAC */	U2E_NODEST_COLX,
	/* U+6EAD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc82c)),
	/* U+6EAE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc82d)),
	/* U+6EAF */	JISX0208(0xdeea),
	/* U+6EB0 */	U2E_NODEST_COLX,
	/* U+6EB1 */	IFX0213(JISX0213_1(0xf6fd),	JISX0212(0xc82e)),
	/* U+6EB2 */	JISX0208(0xdeec),
	/* U+6EB3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc82f)),
	/* U+6EB4 */	IFX0213(JISX0213_2(0xef23),	U2E_NODEST_COLX),
	/* U+6EB5 */	U2E_NODEST_COLX,
	/* U+6EB6 */	JISX0208(0xcdcf),
	/* U+6EB7 */	JISX0208(0xdee7),
	/* U+6EB8 */	U2E_NODEST_COLX,
	/* U+6EB9 */	U2E_NODEST_COLX,
	/* U+6EBA */	JISX0208(0xc5ae),
	/* U+6EBB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc830)),
	/* U+6EBC */	U2E_NODEST_COLX,
	/* U+6EBD */	JISX0208(0xdee9),
	/* U+6EBE */	U2E_NODEST_COLX,
	/* U+6EBF */	IFX0213(JISX0213_2(0xef24),	JISX0212(0xc831)),
	/* U+6EC0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc832)),
	/* U+6EC1 */	IFX0213(JISX0213_1(0xf6fe),	JISX0212(0xc833)),
	/* U+6EC2 */	JISX0208(0xdef1),
	/* U+6EC3 */	IFX0213(JISX0213_2(0xef25),	JISX0212(0xc834)),
	/* U+6EC4 */	JISX0208(0xdeeb),
	/* U+6EC5 */	JISX0208(0xccc7),
	/* U+6EC6 */	U2E_NODEST_COLX,
	/* U+6EC7 */	IFX0213(JISX0213_1(0xf7a1),	JISX0212(0xc835)),
	/* U+6EC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc836)),
	/* U+6EC9 */	JISX0208(0xdee6),
	/* U+6ECA */	IFX0213(JISX0213_2(0xef26),	JISX0212(0xc837)),
	/* U+6ECB */	JISX0208(0xbca2),
	/* U+6ECC */	JISX0208(0xdefe),
	/* U+6ECD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc838)),
	/* U+6ECE */	IFX0213(JISX0213_1(0xf7a2),	JISX0212(0xc839)),
	/* U+6ECF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc83a)),
	/* U+6ED0 */	U2E_NODEST_COLX,
	/* U+6ED1 */	JISX0208(0xb3ea),
	/* U+6ED2 */	U2E_NODEST_COLX,
	/* U+6ED3 */	JISX0208(0xdee8),
	/* U+6ED4 */	JISX0208(0xdeed),
	/* U+6ED5 */	JISX0208(0xdeee),
	/* U+6ED6 */	U2E_NODEST_COLX,
	/* U+6ED7 */	U2E_NODEST_COLX,
	/* U+6ED8 */	U2E_NODEST_COLX,
	/* U+6ED9 */	IFX0213(JISX0213_2(0xef27),	U2E_NODEST_COLX),
	/* U+6EDA */	U2E_NODEST_COLX,
	/* U+6EDB */	U2E_NODEST_COLX,
	/* U+6EDC */	U2E_NODEST_COLX,
	/* U+6EDD */	JISX0208(0xc2ec),
	/* U+6EDE */	JISX0208(0xc2da),
	/* U+6EDF */	U2E_NODEST_COLX,
	/* U+6EE0 */	U2E_NODEST_COLX,
	/* U+6EE1 */	U2E_NODEST_COLX,
	/* U+6EE2 */	U2E_NODEST_COLX,
	/* U+6EE3 */	U2E_NODEST_COLX,
	/* U+6EE4 */	U2E_NODEST_COLX,
	/* U+6EE5 */	U2E_NODEST_COLX,
	/* U+6EE6 */	U2E_NODEST_COLX,
	/* U+6EE7 */	U2E_NODEST_COLX,
	/* U+6EE8 */	U2E_NODEST_COLX,
	/* U+6EE9 */	U2E_NODEST_COLX,
	/* U+6EEA */	U2E_NODEST_COLX,
	/* U+6EEB */	IFX0213(JISX0213_2(0xef29),	JISX0212(0xc83b)),
	/* U+6EEC */	JISX0208(0xdef6),
	/* U+6EED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc83c)),
	/* U+6EEE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc83d)),
	/* U+6EEF */	JISX0208(0xdefc),
	/* U+6EF0 */	U2E_NODEST_COLX,
	/* U+6EF1 */	U2E_NODEST_COLX,
	/* U+6EF2 */	JISX0208(0xdefa),
	/* U+6EF3 */	U2E_NODEST_COLX,
	/* U+6EF4 */	JISX0208(0xc5a9),
	/* U+6EF5 */	U2E_NODEST_COLX,
	/* U+6EF6 */	U2E_NODEST_COLX,
	/* U+6EF7 */	JISX0208(0xdfa3),
	/* U+6EF8 */	JISX0208(0xdef7),
	/* U+6EF9 */	IFX0213(JISX0213_2(0xef2a),	JISX0212(0xc83e)),
	/* U+6EFA */	U2E_NODEST_COLX,
	/* U+6EFB */	IFX0213(JISX0213_2(0xef2b),	JISX0212(0xc83f)),
	/* U+6EFC */	U2E_NODEST_COLX,
	/* U+6EFD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc840)),
	/* U+6EFE */	JISX0208(0xdef8),
	/* U+6EFF */	JISX0208(0xdee0),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_6F[] = {
	/* U+6F00 */	U2E_NODEST_COLX,
	/* U+6F01 */	JISX0208(0xb5f9),
	/* U+6F02 */	JISX0208(0xc9ba),
	/* U+6F03 */	U2E_NODEST_COLX,
	/* U+6F04 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc841)),
	/* U+6F05 */	U2E_NODEST_COLX,
	/* U+6F06 */	JISX0208(0xbcbf),
	/* U+6F07 */	U2E_NODEST_COLX,
	/* U+6F08 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc842)),
	/* U+6F09 */	JISX0208(0xb9f7),
	/* U+6F0A */	IFX0213(JISX0213_2(0xef2c),	JISX0212(0xc843)),
	/* U+6F0B */	U2E_NODEST_COLX,
	/* U+6F0C */	IFX0213(JISX0213_2(0xef2d),	JISX0212(0xc844)),
	/* U+6F0D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc845)),
	/* U+6F0E */	U2E_NODEST_COLX,
	/* U+6F0F */	JISX0208(0xcfb3),
	/* U+6F10 */	IFX0213(JISX0213_1(0xf7a3),	U2E_NODEST_COLX),
	/* U+6F11 */	JISX0208(0xdef4),
	/* U+6F12 */	U2E_NODEST_COLX,
	/* U+6F13 */	JISX0208(0xdfa2),
	/* U+6F14 */	JISX0208(0xb1e9),
	/* U+6F15 */	JISX0208(0xc1e6),
	/* U+6F16 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc846)),
	/* U+6F17 */	U2E_NODEST_COLX,
	/* U+6F18 */	IFX0213(JISX0213_2(0xef2e),	JISX0212(0xc847)),
	/* U+6F19 */	U2E_NODEST_COLX,
	/* U+6F1A */	IFX0213(JISX0213_1(0xf7a4),	JISX0212(0xc848)),
	/* U+6F1B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc849)),
	/* U+6F1C */	U2E_NODEST_COLX,
	/* U+6F1D */	U2E_NODEST_COLX,
	/* U+6F1E */	U2E_NODEST_COLX,
	/* U+6F1F */	U2E_NODEST_COLX,
	/* U+6F20 */	JISX0208(0xc7f9),
	/* U+6F21 */	U2E_NODEST_COLX,
	/* U+6F22 */	JISX0208(0xb4c1),
	/* U+6F23 */	JISX0208(0xcefa),
	/* U+6F24 */	U2E_NODEST_COLX,
	/* U+6F25 */	IFX0213(JISX0213_2(0xef2f),	U2E_NODEST_COLX),
	/* U+6F26 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc84a)),
	/* U+6F27 */	U2E_NODEST_COLX,
	/* U+6F28 */	U2E_NODEST_COLX,
	/* U+6F29 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc84b)),
	/* U+6F2A */	IFX0213(JISX0213_1(0xf7a6),	JISX0212(0xc84c)),
	/* U+6F2B */	JISX0208(0xcca1),
	/* U+6F2C */	JISX0208(0xc4d2),
	/* U+6F2D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc853)),
	/* U+6F2E */	U2E_NODEST_COLX,
	/* U+6F2F */	IFX0213(JISX0213_1(0xf7a7),	JISX0212(0xc84d)),
	/* U+6F30 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc84e)),
	/* U+6F31 */	JISX0208(0xdefb),
	/* U+6F32 */	JISX0208(0xdefd),
	/* U+6F33 */	IFX0213(JISX0213_1(0xf7a8),	JISX0212(0xc84f)),
	/* U+6F34 */	U2E_NODEST_COLX,
	/* U+6F35 */	IFX0213(JISX0213_2(0xef28),	U2E_NODEST_COLX),
	/* U+6F36 */	IFX0213(JISX0213_2(0xef30),	JISX0212(0xc850)),
	/* U+6F37 */	U2E_NODEST_COLX,
	/* U+6F38 */	JISX0208(0xc1b2),
	/* U+6F39 */	U2E_NODEST_COLX,
	/* U+6F3A */	U2E_NODEST_COLX,
	/* U+6F3B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc851)),
	/* U+6F3C */	IFX0213(JISX0213_2(0xef31),	JISX0212(0xc852)),
	/* U+6F3D */	U2E_NODEST_COLX,
	/* U+6F3E */	JISX0208(0xdfa1),
	/* U+6F3F */	JISX0208(0xdef9),
	/* U+6F40 */	U2E_NODEST_COLX,
	/* U+6F41 */	JISX0208(0xdef3),
	/* U+6F42 */	U2E_NODEST_COLX,
	/* U+6F43 */	U2E_NODEST_COLX,
	/* U+6F44 */	U2E_NODEST_COLX,
	/* U+6F45 */	JISX0208(0xb4c3),
	/* U+6F46 */	U2E_NODEST_COLX,
	/* U+6F47 */	U2E_NODEST_COLX,
	/* U+6F48 */	U2E_NODEST_COLX,
	/* U+6F49 */	U2E_NODEST_COLX,
	/* U+6F4A */	U2E_NODEST_COLX,
	/* U+6F4B */	U2E_NODEST_COLX,
	/* U+6F4C */	U2E_NODEST_COLX,
	/* U+6F4D */	U2E_NODEST_COLX,
	/* U+6F4E */	U2E_NODEST_COLX,
	/* U+6F4F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc854)),
	/* U+6F50 */	U2E_NODEST_COLX,
	/* U+6F51 */	IFX0213(JISX0213_1(0xf7a9),	JISX0212(0xc855)),
	/* U+6F52 */	IFX0213(JISX0213_2(0xef33),	JISX0212(0xc856)),
	/* U+6F53 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc857)),
	/* U+6F54 */	JISX0208(0xb7e9),
	/* U+6F55 */	U2E_NODEST_COLX,
	/* U+6F56 */	U2E_NODEST_COLX,
	/* U+6F57 */	IFX0213(JISX0213_2(0xef34),	JISX0212(0xc858)),
	/* U+6F58 */	JISX0208(0xdfaf),
	/* U+6F59 */	IFX0213(JISX0213_1(0xf7aa),	JISX0212(0xc859)),
	/* U+6F5A */	IFX0213(JISX0213_2(0xef35),	JISX0212(0xc85a)),
	/* U+6F5B */	JISX0208(0xdfaa),
	/* U+6F5C */	JISX0208(0xc0f8),
	/* U+6F5D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc85b)),
	/* U+6F5E */	IFX0213(JISX0213_1(0xf7ab),	JISX0212(0xc85c)),
	/* U+6F5F */	JISX0208(0xb3e3),
	/* U+6F60 */	IFX0213(JISX0213_2(0xef36),	U2E_NODEST_COLX),
	/* U+6F61 */	IFX0213(JISX0213_1(0xf7ac),	JISX0212(0xc85d)),
	/* U+6F62 */	IFX0213(JISX0213_1(0xf7ad),	JISX0212(0xc85e)),
	/* U+6F63 */	U2E_NODEST_COLX,
	/* U+6F64 */	JISX0208(0xbde1),
	/* U+6F65 */	U2E_NODEST_COLX,
	/* U+6F66 */	JISX0208(0xdfb3),
	/* U+6F67 */	U2E_NODEST_COLX,
	/* U+6F68 */	IFX0213(JISX0213_2(0xef37),	JISX0212(0xc85f)),
	/* U+6F69 */	U2E_NODEST_COLX,
	/* U+6F6A */	U2E_NODEST_COLX,
	/* U+6F6B */	U2E_NODEST_COLX,
	/* U+6F6C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc860)),
	/* U+6F6D */	JISX0208(0xdfac),
	/* U+6F6E */	JISX0208(0xc4ac),
	/* U+6F6F */	JISX0208(0xdfa9),
	/* U+6F70 */	JISX0208(0xc4d9),
	/* U+6F71 */	U2E_NODEST_COLX,
	/* U+6F72 */	U2E_NODEST_COLX,
	/* U+6F73 */	U2E_NODEST_COLX,
	/* U+6F74 */	JISX0208(0xdfcc),
	/* U+6F75 */	U2E_NODEST_COLX,
	/* U+6F76 */	U2E_NODEST_COLX,
	/* U+6F77 */	U2E_NODEST_COLX,
	/* U+6F78 */	JISX0208(0xdfa6),
	/* U+6F79 */	U2E_NODEST_COLX,
	/* U+6F7A */	JISX0208(0xdfa5),
	/* U+6F7B */	U2E_NODEST_COLX,
	/* U+6F7C */	JISX0208(0xdfae),
	/* U+6F7D */	IFX0213(JISX0213_2(0xef39),	JISX0212(0xc861)),
	/* U+6F7E */	IFX0213(JISX0213_1(0xf7ae),	JISX0212(0xc862)),
	/* U+6F7F */	U2E_NODEST_COLX,
	/* U+6F80 */	JISX0208(0xdfa8),
	/* U+6F81 */	JISX0208(0xdfa7),
	/* U+6F82 */	JISX0208(0xdfad),
	/* U+6F83 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc863)),
	/* U+6F84 */	JISX0208(0xc0a1),
	/* U+6F85 */	U2E_NODEST_COLX,
	/* U+6F86 */	JISX0208(0xdfa4),
	/* U+6F87 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc864)),
	/* U+6F88 */	IFX0213(JISX0213_1(0xf7af),	JISX0212(0xc865)),
	/* U+6F89 */	U2E_NODEST_COLX,
	/* U+6F8A */	U2E_NODEST_COLX,
	/* U+6F8B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc866)),
	/* U+6F8C */	IFX0213(JISX0213_1(0xf7b0),	JISX0212(0xc867)),
	/* U+6F8D */	IFX0213(JISX0213_1(0xf7b1),	JISX0212(0xc868)),
	/* U+6F8E */	JISX0208(0xdfb0),
	/* U+6F8F */	U2E_NODEST_COLX,
	/* U+6F90 */	IFX0213(JISX0213_2(0xef3a),	JISX0212(0xc869)),
	/* U+6F91 */	JISX0208(0xdfb1),
	/* U+6F92 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc86a)),
	/* U+6F93 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc86b)),
	/* U+6F94 */	IFX0213(JISX0213_1(0xf7b2),	JISX0212(0xc86c)),
	/* U+6F95 */	U2E_NODEST_COLX,
	/* U+6F96 */	IFX0213(JISX0213_2(0xef3b),	JISX0212(0xc86d)),
	/* U+6F97 */	JISX0208(0xb4c2),
	/* U+6F98 */	IFX0213(JISX0213_2(0xef38),	U2E_NODEST_COLX),
	/* U+6F99 */	U2E_NODEST_COLX,
	/* U+6F9A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc86e)),
	/* U+6F9B */	U2E_NODEST_COLX,
	/* U+6F9C */	U2E_NODEST_COLX,
	/* U+6F9D */	U2E_NODEST_COLX,
	/* U+6F9E */	U2E_NODEST_COLX,
	/* U+6F9F */	IFX0213(JISX0213_2(0xef3d),	JISX0212(0xc86f)),
	/* U+6FA0 */	IFX0213(JISX0213_1(0xf7b3),	JISX0212(0xc870)),
	/* U+6FA1 */	JISX0208(0xdfb6),
	/* U+6FA2 */	U2E_NODEST_COLX,
	/* U+6FA3 */	JISX0208(0xdfb5),
	/* U+6FA4 */	JISX0208(0xdfb7),
	/* U+6FA5 */	IFX0213(JISX0213_2(0xef3e),	JISX0212(0xc871)),
	/* U+6FA6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc872)),
	/* U+6FA7 */	IFX0213(JISX0213_1(0xf7b4),	JISX0212(0xc873)),
	/* U+6FA8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc874)),
	/* U+6FA9 */	U2E_NODEST_COLX,
	/* U+6FAA */	JISX0208(0xdfba),
	/* U+6FAB */	U2E_NODEST_COLX,
	/* U+6FAC */	U2E_NODEST_COLX,
	/* U+6FAD */	U2E_NODEST_COLX,
	/* U+6FAE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc875)),
	/* U+6FAF */	IFX0213(JISX0213_2(0xef3f),	JISX0212(0xc876)),
	/* U+6FB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc877)),
	/* U+6FB1 */	JISX0208(0xc5c3),
	/* U+6FB2 */	U2E_NODEST_COLX,
	/* U+6FB3 */	JISX0208(0xdfb4),
	/* U+6FB4 */	U2E_NODEST_COLX,
	/* U+6FB5 */	IFX0213(JISX0213_2(0xef41),	JISX0212(0xc878)),
	/* U+6FB6 */	IFX0213(JISX0213_1(0xf7b5),	JISX0212(0xc879)),
	/* U+6FB7 */	U2E_NODEST_COLX,
	/* U+6FB8 */	U2E_NODEST_COLX,
	/* U+6FB9 */	JISX0208(0xdfb8),
	/* U+6FBA */	U2E_NODEST_COLX,
	/* U+6FBB */	U2E_NODEST_COLX,
	/* U+6FBC */	IFX0213(JISX0213_1(0xf7b6),	JISX0212(0xc87a)),
	/* U+6FBD */	U2E_NODEST_COLX,
	/* U+6FBE */	IFX0213(JISX0213_2(0xef3c),	U2E_NODEST_COLX),
	/* U+6FBF */	U2E_NODEST_COLX,
	/* U+6FC0 */	JISX0208(0xb7e3),
	/* U+6FC1 */	JISX0208(0xc2f9),
	/* U+6FC2 */	JISX0208(0xdfb2),
	/* U+6FC3 */	JISX0208(0xc7bb),
	/* U+6FC4 */	U2E_NODEST_COLX,
	/* U+6FC5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc87b)),
	/* U+6FC6 */	JISX0208(0xdfb9),
	/* U+6FC7 */	IFX0213(JISX0213_1(0xf7b7),	JISX0212(0xc87c)),
	/* U+6FC8 */	IFX0213(JISX0213_2(0xef42),	JISX0212(0xc87d)),
	/* U+6FC9 */	IFX0213(JISX0213_2(0xef43),	U2E_NODEST_COLX),
	/* U+6FCA */	IFX0213(JISX0213_1(0xf7b8),	JISX0212(0xc87e)),
	/* U+6FCB */	U2E_NODEST_COLX,
	/* U+6FCC */	U2E_NODEST_COLX,
	/* U+6FCD */	U2E_NODEST_COLX,
	/* U+6FCE */	U2E_NODEST_COLX,
	/* U+6FCF */	U2E_NODEST_COLX,
	/* U+6FD0 */	U2E_NODEST_COLX,
	/* U+6FD1 */	U2E_NODEST_COLX,
	/* U+6FD2 */	U2E_NODEST_COLX,
	/* U+6FD3 */	U2E_NODEST_COLX,
	/* U+6FD4 */	JISX0208(0xdfbe),
	/* U+6FD5 */	JISX0208(0xdfbc),
	/* U+6FD6 */	U2E_NODEST_COLX,
	/* U+6FD7 */	U2E_NODEST_COLX,
	/* U+6FD8 */	JISX0208(0xdfbf),
	/* U+6FD9 */	U2E_NODEST_COLX,
	/* U+6FDA */	IFX0213(JISX0213_2(0xef44),	JISX0212(0xc921)),
	/* U+6FDB */	JISX0208(0xdfc2),
	/* U+6FDC */	U2E_NODEST_COLX,
	/* U+6FDD */	U2E_NODEST_COLX,
	/* U+6FDE */	IFX0213(JISX0213_2(0xef45),	JISX0212(0xc922)),
	/* U+6FDF */	JISX0208(0xdfbb),
	/* U+6FE0 */	JISX0208(0xb9ea),
	/* U+6FE1 */	JISX0208(0xc7a8),
	/* U+6FE2 */	U2E_NODEST_COLX,
	/* U+6FE3 */	U2E_NODEST_COLX,
	/* U+6FE4 */	JISX0208(0xdeb9),
	/* U+6FE5 */	U2E_NODEST_COLX,
	/* U+6FE6 */	U2E_NODEST_COLX,
	/* U+6FE7 */	U2E_NODEST_COLX,
	/* U+6FE8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc923)),
	/* U+6FE9 */	IFX0213(JISX0213_2(0xef46),	JISX0212(0xc924)),
	/* U+6FEA */	U2E_NODEST_COLX,
	/* U+6FEB */	JISX0208(0xcdf4),
	/* U+6FEC */	JISX0208(0xdfbd),
	/* U+6FED */	U2E_NODEST_COLX,
	/* U+6FEE */	JISX0208(0xdfc1),
	/* U+6FEF */	JISX0208(0xc2f5),
	/* U+6FF0 */	IFX0213(JISX0213_1(0xf7ba),	JISX0212(0xc925)),
	/* U+6FF1 */	JISX0208(0xdfc0),
	/* U+6FF2 */	U2E_NODEST_COLX,
	/* U+6FF3 */	JISX0208(0xdfab),
	/* U+6FF4 */	U2E_NODEST_COLX,
	/* U+6FF5 */	IFX0213(JISX0213_1(0xf7bb),	JISX0212(0xc926)),
	/* U+6FF6 */	JISX0208(0xefe9),
	/* U+6FF7 */	U2E_NODEST_COLX,
	/* U+6FF8 */	U2E_NODEST_COLX,
	/* U+6FF9 */	IFX0213(JISX0213_1(0xf7b9),	JISX0212(0xc927)),
	/* U+6FFA */	JISX0208(0xdfc5),
	/* U+6FFB */	U2E_NODEST_COLX,
	/* U+6FFC */	IFX0213(JISX0213_2(0xef48),	JISX0212(0xc928)),
	/* U+6FFD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc929)),
	/* U+6FFE */	JISX0208(0xdfc9),
	/* U+6FFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_70[] = {
	/* U+7000 */	IFX0213(JISX0213_2(0xef49),	JISX0212(0xc92a)),
	/* U+7001 */	JISX0208(0xdfc7),
	/* U+7002 */	U2E_NODEST_COLX,
	/* U+7003 */	U2E_NODEST_COLX,
	/* U+7004 */	U2E_NODEST_COLX,
	/* U+7005 */	IFX0213(JISX0213_1(0xf7bc),	JISX0212(0xc92b)),
	/* U+7006 */	IFX0213(JISX0213_1(0xf7bd),	JISX0212(0xc92c)),
	/* U+7007 */	IFX0213(JISX0213_2(0xef4a),	JISX0212(0xc92d)),
	/* U+7008 */	U2E_NODEST_COLX,
	/* U+7009 */	JISX0208(0xdfc3),
	/* U+700A */	IFX0213(JISX0213_2(0xef4b),	U2E_NODEST_COLX),
	/* U+700B */	JISX0208(0xdfc4),
	/* U+700C */	U2E_NODEST_COLX,
	/* U+700D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc92e)),
	/* U+700E */	U2E_NODEST_COLX,
	/* U+700F */	JISX0208(0xdfc8),
	/* U+7010 */	U2E_NODEST_COLX,
	/* U+7011 */	JISX0208(0xdfc6),
	/* U+7012 */	U2E_NODEST_COLX,
	/* U+7013 */	U2E_NODEST_COLX,
	/* U+7014 */	U2E_NODEST_COLX,
	/* U+7015 */	JISX0208(0xc9ce),
	/* U+7016 */	IFX0213(JISX0213_2(0xef6c),	U2E_NODEST_COLX),
	/* U+7017 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc92f)),
	/* U+7018 */	JISX0208(0xdfce),
	/* U+7019 */	U2E_NODEST_COLX,
	/* U+701A */	JISX0208(0xdfcb),
	/* U+701B */	JISX0208(0xdfca),
	/* U+701C */	U2E_NODEST_COLX,
	/* U+701D */	JISX0208(0xdfcd),
	/* U+701E */	JISX0208(0xc6d4),
	/* U+701F */	JISX0208(0xdfcf),
	/* U+7020 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc930)),
	/* U+7021 */	U2E_NODEST_COLX,
	/* U+7022 */	U2E_NODEST_COLX,
	/* U+7023 */	IFX0213(JISX0213_2(0xef4c),	JISX0212(0xc931)),
	/* U+7024 */	U2E_NODEST_COLX,
	/* U+7025 */	U2E_NODEST_COLX,
	/* U+7026 */	JISX0208(0xc3f5),
	/* U+7027 */	JISX0208(0xc2ed),
	/* U+7028 */	IFX0213(JISX0213_1(0xf7be),	IBM(0xf44d)),
	/* U+7029 */	U2E_NODEST_COLX,
	/* U+702A */	U2E_NODEST_COLX,
	/* U+702B */	U2E_NODEST_COLX,
	/* U+702C */	JISX0208(0xc0a5),
	/* U+702D */	U2E_NODEST_COLX,
	/* U+702E */	U2E_NODEST_COLX,
	/* U+702F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc932)),
	/* U+7030 */	JISX0208(0xdfd0),
	/* U+7031 */	U2E_NODEST_COLX,
	/* U+7032 */	JISX0208(0xdfd2),
	/* U+7033 */	U2E_NODEST_COLX,
	/* U+7034 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc933)),
	/* U+7035 */	U2E_NODEST_COLX,
	/* U+7036 */	U2E_NODEST_COLX,
	/* U+7037 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc934)),
	/* U+7038 */	U2E_NODEST_COLX,
	/* U+7039 */	IFX0213(JISX0213_2(0xef4e),	JISX0212(0xc935)),
	/* U+703A */	IFX0213(JISX0213_2(0xef4f),	U2E_NODEST_COLX),
	/* U+703B */	U2E_NODEST_COLX,
	/* U+703C */	IFX0213(JISX0213_2(0xef50),	JISX0212(0xc936)),
	/* U+703D */	U2E_NODEST_COLX,
	/* U+703E */	JISX0208(0xdfd1),
	/* U+703F */	U2E_NODEST_COLX,
	/* U+7040 */	U2E_NODEST_COLX,
	/* U+7041 */	U2E_NODEST_COLX,
	/* U+7042 */	U2E_NODEST_COLX,
	/* U+7043 */	IFX0213(JISX0213_2(0xef51),	JISX0212(0xc937)),
	/* U+7044 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc938)),
	/* U+7045 */	U2E_NODEST_COLX,
	/* U+7046 */	U2E_NODEST_COLX,
	/* U+7047 */	IFX0213(JISX0213_2(0xef52),	U2E_NODEST_COLX),
	/* U+7048 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc939)),
	/* U+7049 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc93a)),
	/* U+704A */	IFX0213(JISX0213_1(0xf7bf),	JISX0212(0xc93b)),
	/* U+704B */	IFX0213(JISX0213_2(0xef53),	JISX0212(0xc93c)),
	/* U+704C */	JISX0208(0xdef5),
	/* U+704D */	U2E_NODEST_COLX,
	/* U+704E */	IFX0213(JISX0213_1(0xf7c2),	JISX0212(0xc941)),
	/* U+704F */	U2E_NODEST_COLX,
	/* U+7050 */	U2E_NODEST_COLX,
	/* U+7051 */	JISX0208(0xdfd3),
	/* U+7052 */	U2E_NODEST_COLX,
	/* U+7053 */	U2E_NODEST_COLX,
	/* U+7054 */	IFX0213(JISX0213_2(0xef55),	JISX0212(0xc93d)),
	/* U+7055 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc93e)),
	/* U+7056 */	U2E_NODEST_COLX,
	/* U+7057 */	U2E_NODEST_COLX,
	/* U+7058 */	JISX0208(0xc6e7),
	/* U+7059 */	U2E_NODEST_COLX,
	/* U+705A */	U2E_NODEST_COLX,
	/* U+705B */	U2E_NODEST_COLX,
	/* U+705C */	U2E_NODEST_COLX,
	/* U+705D */	IFX0213(JISX0213_1(0xf7c0),	JISX0212(0xc93f)),
	/* U+705E */	IFX0213(JISX0213_1(0xf7c1),	JISX0212(0xc940)),
	/* U+705F */	U2E_NODEST_COLX,
	/* U+7060 */	U2E_NODEST_COLX,
	/* U+7061 */	U2E_NODEST_COLX,
	/* U+7062 */	U2E_NODEST_COLX,
	/* U+7063 */	JISX0208(0xdfd4),
	/* U+7064 */	IFX0213(JISX0213_1(0xf7c3),	JISX0212(0xc942)),
	/* U+7065 */	IFX0213(JISX0213_2(0xef56),	JISX0212(0xc943)),
	/* U+7066 */	U2E_NODEST_COLX,
	/* U+7067 */	U2E_NODEST_COLX,
	/* U+7068 */	U2E_NODEST_COLX,
	/* U+7069 */	IFX0213(JISX0213_2(0xef57),	U2E_NODEST_COLX),
	/* U+706A */	U2E_NODEST_COLX,
	/* U+706B */	JISX0208(0xb2d0),
	/* U+706C */	IFX0213(JISX0213_2(0xef58),	JISX0212(0xc944)),
	/* U+706D */	U2E_NODEST_COLX,
	/* U+706E */	IFX0213(JISX0213_2(0xef59),	JISX0212(0xc945)),
	/* U+706F */	JISX0208(0xc5f4),
	/* U+7070 */	JISX0208(0xb3a5),
	/* U+7071 */	U2E_NODEST_COLX,
	/* U+7072 */	U2E_NODEST_COLX,
	/* U+7073 */	U2E_NODEST_COLX,
	/* U+7074 */	U2E_NODEST_COLX,
	/* U+7075 */	IFX0213(JISX0213_1(0xf7c4),	JISX0212(0xc946)),
	/* U+7076 */	IFX0213(JISX0213_2(0xef5a),	JISX0212(0xc947)),
	/* U+7077 */	U2E_NODEST_COLX,
	/* U+7078 */	JISX0208(0xb5e4),
	/* U+7079 */	U2E_NODEST_COLX,
	/* U+707A */	U2E_NODEST_COLX,
	/* U+707B */	U2E_NODEST_COLX,
	/* U+707C */	JISX0208(0xbcde),
	/* U+707D */	JISX0208(0xbad2),
	/* U+707E */	IFX0213(JISX0213_2(0xef5b),	JISX0212(0xc948)),
	/* U+707F */	U2E_NODEST_COLX,
	/* U+7080 */	U2E_NODEST_COLX,
	/* U+7081 */	IFX0213(JISX0213_2(0xef5c),	JISX0212(0xc949)),
	/* U+7082 */	U2E_NODEST_COLX,
	/* U+7083 */	U2E_NODEST_COLX,
	/* U+7084 */	U2E_NODEST_COLX,
	/* U+7085 */	IFX0213(JISX0213_1(0xf7c5),	JISX0212(0xc94a)),
	/* U+7086 */	IFX0213(JISX0213_2(0xef5d),	JISX0212(0xc94b)),
	/* U+7087 */	U2E_NODEST_COLX,
	/* U+7088 */	U2E_NODEST_COLX,
	/* U+7089 */	JISX0208(0xcfa7),
	/* U+708A */	JISX0208(0xbfe6),
	/* U+708B */	U2E_NODEST_COLX,
	/* U+708C */	U2E_NODEST_COLX,
	/* U+708D */	U2E_NODEST_COLX,
	/* U+708E */	JISX0208(0xb1ea),
	/* U+708F */	U2E_NODEST_COLX,
	/* U+7090 */	U2E_NODEST_COLX,
	/* U+7091 */	U2E_NODEST_COLX,
	/* U+7092 */	JISX0208(0xdfd6),
	/* U+7093 */	U2E_NODEST_COLX,
	/* U+7094 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc94c)),
	/* U+7095 */	IFX0213(JISX0213_2(0xef5e),	JISX0212(0xc94d)),
	/* U+7096 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc94e)),
	/* U+7097 */	IFX0213(JISX0213_2(0xef5f),	JISX0212(0xc94f)),
	/* U+7098 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc950)),
	/* U+7099 */	JISX0208(0xdfd5),
	/* U+709A */	U2E_NODEST_COLX,
	/* U+709B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc951)),
	/* U+709C */	U2E_NODEST_COLX,
	/* U+709D */	U2E_NODEST_COLX,
	/* U+709E */	U2E_NODEST_COLX,
	/* U+709F */	IFX0213(JISX0213_2(0xef62),	U2E_NODEST_COLX),
	/* U+70A0 */	U2E_NODEST_COLX,
	/* U+70A1 */	U2E_NODEST_COLX,
	/* U+70A2 */	U2E_NODEST_COLX,
	/* U+70A3 */	U2E_NODEST_COLX,
	/* U+70A4 */	IFX0213(JISX0213_1(0xf7c6),	JISX0212(0xc952)),
	/* U+70A5 */	U2E_NODEST_COLX,
	/* U+70A6 */	U2E_NODEST_COLX,
	/* U+70A7 */	U2E_NODEST_COLX,
	/* U+70A8 */	U2E_NODEST_COLX,
	/* U+70A9 */	U2E_NODEST_COLX,
	/* U+70AA */	U2E_NODEST_COLX,
	/* U+70AB */	IFX0213(JISX0213_1(0xf7c7),	JISX0212(0xc953)),
	/* U+70AC */	JISX0208(0xdfd9),
	/* U+70AD */	JISX0208(0xc3ba),
	/* U+70AE */	JISX0208(0xdfdc),
	/* U+70AF */	JISX0208(0xdfd7),
	/* U+70B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc954)),
	/* U+70B1 */	IFX0213(JISX0213_2(0xef63),	JISX0212(0xc955)),
	/* U+70B2 */	U2E_NODEST_COLX,
	/* U+70B3 */	JISX0208(0xdfdb),
	/* U+70B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc956)),
	/* U+70B5 */	U2E_NODEST_COLX,
	/* U+70B6 */	U2E_NODEST_COLX,
	/* U+70B7 */	IFX0213(JISX0213_1(0xf7c8),	JISX0212(0xc957)),
	/* U+70B8 */	JISX0208(0xdfda),
	/* U+70B9 */	JISX0208(0xc5c0),
	/* U+70BA */	JISX0208(0xb0d9),
	/* U+70BB */	IFX0213(JISX0213_2(0xef60),	IBM(0xf42e)),
	/* U+70BC */	U2E_NODEST_COLX,
	/* U+70BD */	U2E_NODEST_COLX,
	/* U+70BE */	U2E_NODEST_COLX,
	/* U+70BF */	U2E_NODEST_COLX,
	/* U+70C0 */	U2E_NODEST_COLX,
	/* U+70C1 */	U2E_NODEST_COLX,
	/* U+70C2 */	U2E_NODEST_COLX,
	/* U+70C3 */	U2E_NODEST_COLX,
	/* U+70C4 */	U2E_NODEST_COLX,
	/* U+70C5 */	U2E_NODEST_COLX,
	/* U+70C6 */	U2E_NODEST_COLX,
	/* U+70C7 */	U2E_NODEST_COLX,
	/* U+70C8 */	JISX0208(0xcef5),
	/* U+70C9 */	U2E_NODEST_COLX,
	/* U+70CA */	IFX0213(JISX0213_2(0xef66),	JISX0212(0xc958)),
	/* U+70CB */	JISX0208(0xdfde),
	/* U+70CC */	U2E_NODEST_COLX,
	/* U+70CD */	U2E_NODEST_COLX,
	/* U+70CE */	U2E_NODEST_COLX,
	/* U+70CF */	JISX0208(0xb1a8),
	/* U+70D0 */	U2E_NODEST_COLX,
	/* U+70D1 */	IFX0213(JISX0213_2(0xef67),	JISX0212(0xc959)),
	/* U+70D2 */	U2E_NODEST_COLX,
	/* U+70D3 */	IFX0213(JISX0213_2(0xef68),	JISX0212(0xc95a)),
	/* U+70D4 */	IFX0213(JISX0213_1(0xf7c9),	JISX0212(0xc95b)),
	/* U+70D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc95c)),
	/* U+70D6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc95d)),
	/* U+70D7 */	U2E_NODEST_COLX,
	/* U+70D8 */	IFX0213(JISX0213_1(0xf7ca),	JISX0212(0xc95e)),
	/* U+70D9 */	JISX0208(0xdfe0),
	/* U+70DA */	U2E_NODEST_COLX,
	/* U+70DB */	U2E_NODEST_COLX,
	/* U+70DC */	IFX0213(JISX0213_2(0xef69),	JISX0212(0xc95f)),
	/* U+70DD */	JISX0208(0xdfdf),
	/* U+70DE */	U2E_NODEST_COLX,
	/* U+70DF */	JISX0208(0xdfdd),
	/* U+70E0 */	U2E_NODEST_COLX,
	/* U+70E1 */	U2E_NODEST_COLX,
	/* U+70E2 */	U2E_NODEST_COLX,
	/* U+70E3 */	U2E_NODEST_COLX,
	/* U+70E4 */	IFX0213(JISX0213_1(0xf7cb),	JISX0212(0xc960)),
	/* U+70E5 */	U2E_NODEST_COLX,
	/* U+70E6 */	U2E_NODEST_COLX,
	/* U+70E7 */	U2E_NODEST_COLX,
	/* U+70E8 */	U2E_NODEST_COLX,
	/* U+70E9 */	U2E_NODEST_COLX,
	/* U+70EA */	U2E_NODEST_COLX,
	/* U+70EB */	U2E_NODEST_COLX,
	/* U+70EC */	IFX0213(JISX0213_2(0xef65),	U2E_NODEST_COLX),
	/* U+70ED */	U2E_NODEST_COLX,
	/* U+70EE */	U2E_NODEST_COLX,
	/* U+70EF */	U2E_NODEST_COLX,
	/* U+70F0 */	U2E_NODEST_COLX,
	/* U+70F1 */	JISX0208(0xdfd8),
	/* U+70F2 */	U2E_NODEST_COLX,
	/* U+70F3 */	U2E_NODEST_COLX,
	/* U+70F4 */	U2E_NODEST_COLX,
	/* U+70F5 */	U2E_NODEST_COLX,
	/* U+70F6 */	U2E_NODEST_COLX,
	/* U+70F7 */	U2E_NODEST_COLX,
	/* U+70F8 */	U2E_NODEST_COLX,
	/* U+70F9 */	JISX0208(0xcba3),
	/* U+70FA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc961)),
	/* U+70FB */	U2E_NODEST_COLX,
	/* U+70FC */	U2E_NODEST_COLX,
	/* U+70FD */	JISX0208(0xdfe2),
	/* U+70FE */	U2E_NODEST_COLX,
	/* U+70FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_71[] = {
	/* U+7100 */	U2E_NODEST_COLX,
	/* U+7101 */	U2E_NODEST_COLX,
	/* U+7102 */	U2E_NODEST_COLX,
	/* U+7103 */	IFX0213(JISX0213_2(0xef6a),	JISX0212(0xc962)),
	/* U+7104 */	IFX0213(JISX0213_2(0xef6b),	JISX0212(0xc963)),
	/* U+7105 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc964)),
	/* U+7106 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc965)),
	/* U+7107 */	IFX0213(JISX0213_2(0xef6d),	JISX0212(0xc966)),
	/* U+7108 */	IFX0213(JISX0213_2(0xef6e),	U2E_NODEST_COLX),
	/* U+7109 */	JISX0208(0xdfe1),
	/* U+710A */	U2E_NODEST_COLX,
	/* U+710B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc967)),
	/* U+710C */	IFX0213(JISX0213_2(0xef6f),	JISX0212(0xc968)),
	/* U+710D */	U2E_NODEST_COLX,
	/* U+710E */	U2E_NODEST_COLX,
	/* U+710F */	IFX0213(JISX0213_1(0xf7cc),	JISX0212(0xc969)),
	/* U+7110 */	U2E_NODEST_COLX,
	/* U+7111 */	U2E_NODEST_COLX,
	/* U+7112 */	U2E_NODEST_COLX,
	/* U+7113 */	U2E_NODEST_COLX,
	/* U+7114 */	JISX0208(0xb1eb),
	/* U+7115 */	U2E_NODEST_COLX,
	/* U+7116 */	U2E_NODEST_COLX,
	/* U+7117 */	U2E_NODEST_COLX,
	/* U+7118 */	U2E_NODEST_COLX,
	/* U+7119 */	JISX0208(0xdfe4),
	/* U+711A */	JISX0208(0xcab2),
	/* U+711B */	U2E_NODEST_COLX,
	/* U+711C */	JISX0208(0xdfe3),
	/* U+711D */	U2E_NODEST_COLX,
	/* U+711E */	IFX0213(JISX0213_1(0xf7ce),	JISX0212(0xc96a)),
	/* U+711F */	U2E_NODEST_COLX,
	/* U+7120 */	IFX0213(JISX0213_1(0xf7cf),	JISX0212(0xc96b)),
	/* U+7121 */	JISX0208(0xccb5),
	/* U+7122 */	U2E_NODEST_COLX,
	/* U+7123 */	U2E_NODEST_COLX,
	/* U+7124 */	U2E_NODEST_COLX,
	/* U+7125 */	U2E_NODEST_COLX,
	/* U+7126 */	JISX0208(0xbec7),
	/* U+7127 */	U2E_NODEST_COLX,
	/* U+7128 */	U2E_NODEST_COLX,
	/* U+7129 */	U2E_NODEST_COLX,
	/* U+712A */	U2E_NODEST_COLX,
	/* U+712B */	IFX0213(JISX0213_1(0xf7cd),	JISX0212(0xc96c)),
	/* U+712C */	U2E_NODEST_COLX,
	/* U+712D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc96d)),
	/* U+712E */	IFX0213(JISX0213_1(0xf7d0),	U2E_NODEST_COLX),
	/* U+712F */	IFX0213(JISX0213_2(0xef71),	JISX0212(0xc96e)),
	/* U+7130 */	IFX0213(JISX0213_1(0xf7d1),	JISX0212(0xc96f)),
	/* U+7131 */	IFX0213(JISX0213_2(0xef72),	JISX0212(0xc970)),
	/* U+7132 */	U2E_NODEST_COLX,
	/* U+7133 */	U2E_NODEST_COLX,
	/* U+7134 */	U2E_NODEST_COLX,
	/* U+7135 */	U2E_NODEST_COLX,
	/* U+7136 */	JISX0208(0xc1b3),
	/* U+7137 */	U2E_NODEST_COLX,
	/* U+7138 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc971)),
	/* U+7139 */	U2E_NODEST_COLX,
	/* U+713A */	U2E_NODEST_COLX,
	/* U+713B */	U2E_NODEST_COLX,
	/* U+713C */	JISX0208(0xbec6),
	/* U+713D */	U2E_NODEST_COLX,
	/* U+713E */	U2E_NODEST_COLX,
	/* U+713F */	U2E_NODEST_COLX,
	/* U+7140 */	U2E_NODEST_COLX,
	/* U+7141 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc972)),
	/* U+7142 */	U2E_NODEST_COLX,
	/* U+7143 */	U2E_NODEST_COLX,
	/* U+7144 */	U2E_NODEST_COLX,
	/* U+7145 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc973)),
	/* U+7146 */	IFX0213(JISX0213_1(0xf7d2),	JISX0212(0xc974)),
	/* U+7147 */	IFX0213(JISX0213_1(0xf7d3),	JISX0212(0xc975)),
	/* U+7148 */	U2E_NODEST_COLX,
	/* U+7149 */	JISX0208(0xcefb),
	/* U+714A */	IFX0213(JISX0213_2(0xef74),	JISX0212(0xc976)),
	/* U+714B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc977)),
	/* U+714C */	JISX0208(0xdfea),
	/* U+714D */	U2E_NODEST_COLX,
	/* U+714E */	JISX0208(0xc0f9),
	/* U+714F */	U2E_NODEST_COLX,
	/* U+7150 */	IFX0213(JISX0213_2(0xef73),	JISX0212(0xc978)),
	/* U+7151 */	IFX0213(JISX0213_1(0xf7d4),	U2E_NODEST_COLX),
	/* U+7152 */	IFX0213(JISX0213_1(0xf7d6),	JISX0212(0xc979)),
	/* U+7153 */	IFX0213(JISX0213_2(0xef75),	U2E_NODEST_COLX),
	/* U+7154 */	U2E_NODEST_COLX,
	/* U+7155 */	JISX0208(0xdfe6),
	/* U+7156 */	JISX0208(0xdfeb),
	/* U+7157 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc97a)),
	/* U+7158 */	U2E_NODEST_COLX,
	/* U+7159 */	JISX0208(0xb1ec),
	/* U+715A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xc97b)),
	/* U+715B */	U2E_NODEST_COLX,
	/* U+715C */	IFX0213(JISX0213_1(0xf7d7),	JISX0212(0xc97c)),
	/* U+715D */	U2E_NODEST_COLX,
	/* U+715E */	IFX0213(JISX0213_2(0xef76),	JISX0212(0xc97d)),
	/* U+715F */	U2E_NODEST_COLX,
	/* U+7160 */	IFX0213(JISX0213_1(0xf7d8),	JISX0212(0xc97e)),
	/* U+7161 */	U2E_NODEST_COLX,
	/* U+7162 */	JISX0208(0xdfe9),
	/* U+7163 */	U2E_NODEST_COLX,
	/* U+7164 */	JISX0208(0xc7e1),
	/* U+7165 */	JISX0208(0xdfe5),
	/* U+7166 */	JISX0208(0xdfe8),
	/* U+7167 */	JISX0208(0xbec8),
	/* U+7168 */	IFX0213(JISX0213_1(0xf7d9),	JISX0212(0xca21)),
	/* U+7169 */	JISX0208(0xc8d1),
	/* U+716A */	U2E_NODEST_COLX,
	/* U+716B */	U2E_NODEST_COLX,
	/* U+716C */	JISX0208(0xdfec),
	/* U+716D */	U2E_NODEST_COLX,
	/* U+716E */	JISX0208(0xbcd1),
	/* U+716F */	U2E_NODEST_COLX,
	/* U+7170 */	U2E_NODEST_COLX,
	/* U+7171 */	U2E_NODEST_COLX,
	/* U+7172 */	U2E_NODEST_COLX,
	/* U+7173 */	U2E_NODEST_COLX,
	/* U+7174 */	U2E_NODEST_COLX,
	/* U+7175 */	U2E_NODEST_COLX,
	/* U+7176 */	U2E_NODEST_COLX,
	/* U+7177 */	U2E_NODEST_COLX,
	/* U+7178 */	U2E_NODEST_COLX,
	/* U+7179 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca22)),
	/* U+717A */	U2E_NODEST_COLX,
	/* U+717B */	U2E_NODEST_COLX,
	/* U+717C */	U2E_NODEST_COLX,
	/* U+717D */	JISX0208(0xc0fa),
	/* U+717E */	U2E_NODEST_COLX,
	/* U+717F */	U2E_NODEST_COLX,
	/* U+7180 */	IFX0213(JISX0213_2(0xef79),	JISX0212(0xca23)),
	/* U+7181 */	U2E_NODEST_COLX,
	/* U+7182 */	U2E_NODEST_COLX,
	/* U+7183 */	U2E_NODEST_COLX,
	/* U+7184 */	JISX0208(0xdfef),
	/* U+7185 */	IFX0213(JISX0213_1(0xf7db),	JISX0212(0xca24)),
	/* U+7186 */	U2E_NODEST_COLX,
	/* U+7187 */	IFX0213(JISX0213_1(0xf7dc),	JISX0212(0xca25)),
	/* U+7188 */	JISX0208(0xdfe7),
	/* U+7189 */	U2E_NODEST_COLX,
	/* U+718A */	JISX0208(0xb7a7),
	/* U+718B */	U2E_NODEST_COLX,
	/* U+718C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca26)),
	/* U+718D */	U2E_NODEST_COLX,
	/* U+718E */	U2E_NODEST_COLX,
	/* U+718F */	JISX0208(0xdfed),
	/* U+7190 */	U2E_NODEST_COLX,
	/* U+7191 */	U2E_NODEST_COLX,
	/* U+7192 */	IFX0213(JISX0213_1(0xf7dd),	JISX0212(0xca27)),
	/* U+7193 */	U2E_NODEST_COLX,
	/* U+7194 */	JISX0208(0xcdd0),
	/* U+7195 */	JISX0208(0xdff0),
	/* U+7196 */	IFX0213(JISX0213_2(0xef78),	U2E_NODEST_COLX),
	/* U+7197 */	U2E_NODEST_COLX,
	/* U+7198 */	U2E_NODEST_COLX,
	/* U+7199 */	JISX0208(0xf4a6),
	/* U+719A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca28)),
	/* U+719B */	IFX0213(JISX0213_2(0xef7a),	JISX0212(0xca29)),
	/* U+719C */	U2E_NODEST_COLX,
	/* U+719D */	U2E_NODEST_COLX,
	/* U+719E */	U2E_NODEST_COLX,
	/* U+719F */	JISX0208(0xbdcf),
	/* U+71A0 */	IFX0213(JISX0213_2(0xef7b),	JISX0212(0xca2a)),
	/* U+71A1 */	U2E_NODEST_COLX,
	/* U+71A2 */	IFX0213(JISX0213_2(0xef7c),	JISX0212(0xca2b)),
	/* U+71A3 */	U2E_NODEST_COLX,
	/* U+71A4 */	U2E_NODEST_COLX,
	/* U+71A5 */	U2E_NODEST_COLX,
	/* U+71A6 */	U2E_NODEST_COLX,
	/* U+71A7 */	U2E_NODEST_COLX,
	/* U+71A8 */	JISX0208(0xdff1),
	/* U+71A9 */	U2E_NODEST_COLX,
	/* U+71AA */	U2E_NODEST_COLX,
	/* U+71AB */	U2E_NODEST_COLX,
	/* U+71AC */	JISX0208(0xdff2),
	/* U+71AD */	U2E_NODEST_COLX,
	/* U+71AE */	IFX0213(JISX0213_2(0xef7d),	U2E_NODEST_COLX),
	/* U+71AF */	IFX0213(JISX0213_2(0xef7e),	JISX0212(0xca2c)),
	/* U+71B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca2d)),
	/* U+71B1 */	JISX0208(0xc7ae),
	/* U+71B2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca2e)),
	/* U+71B3 */	IFX0213(JISX0213_2(0xf021),	JISX0212(0xca2f)),
	/* U+71B4 */	U2E_NODEST_COLX,
	/* U+71B5 */	U2E_NODEST_COLX,
	/* U+71B6 */	U2E_NODEST_COLX,
	/* U+71B7 */	U2E_NODEST_COLX,
	/* U+71B8 */	U2E_NODEST_COLX,
	/* U+71B9 */	JISX0208(0xdff4),
	/* U+71BA */	IFX0213(JISX0213_1(0xf7df),	JISX0212(0xca30)),
	/* U+71BB */	U2E_NODEST_COLX,
	/* U+71BC */	U2E_NODEST_COLX,
	/* U+71BD */	U2E_NODEST_COLX,
	/* U+71BE */	JISX0208(0xdff5),
	/* U+71BF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca31)),
	/* U+71C0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca32)),
	/* U+71C1 */	IFX0213(JISX0213_1(0xf7de),	JISX0212(0xca33)),
	/* U+71C2 */	U2E_NODEST_COLX,
	/* U+71C3 */	JISX0208(0xc7b3),
	/* U+71C4 */	IFX0213(JISX0213_1(0xf7e0),	JISX0212(0xca34)),
	/* U+71C5 */	U2E_NODEST_COLX,
	/* U+71C6 */	U2E_NODEST_COLX,
	/* U+71C7 */	U2E_NODEST_COLX,
	/* U+71C8 */	JISX0208(0xc5f5),
	/* U+71C9 */	JISX0208(0xdff7),
	/* U+71CA */	U2E_NODEST_COLX,
	/* U+71CB */	IFX0213(JISX0213_2(0xf023),	JISX0212(0xca35)),
	/* U+71CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca36)),
	/* U+71CD */	U2E_NODEST_COLX,
	/* U+71CE */	JISX0208(0xdff9),
	/* U+71CF */	U2E_NODEST_COLX,
	/* U+71D0 */	JISX0208(0xced5),
	/* U+71D1 */	U2E_NODEST_COLX,
	/* U+71D2 */	JISX0208(0xdff6),
	/* U+71D3 */	IFX0213(JISX0213_2(0xf024),	JISX0212(0xca37)),
	/* U+71D4 */	JISX0208(0xdff8),
	/* U+71D5 */	JISX0208(0xb1ed),
	/* U+71D6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca38)),
	/* U+71D7 */	JISX0208(0xdff3),
	/* U+71D8 */	U2E_NODEST_COLX,
	/* U+71D9 */	IFX0213(JISX0213_2(0xf025),	JISX0212(0xca39)),
	/* U+71DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca3a)),
	/* U+71DB */	U2E_NODEST_COLX,
	/* U+71DC */	IFX0213(JISX0213_2(0xf026),	JISX0212(0xca3b)),
	/* U+71DD */	U2E_NODEST_COLX,
	/* U+71DE */	U2E_NODEST_COLX,
	/* U+71DF */	JISX0208(0xd3db),
	/* U+71E0 */	JISX0208(0xdffa),
	/* U+71E1 */	U2E_NODEST_COLX,
	/* U+71E2 */	U2E_NODEST_COLX,
	/* U+71E3 */	U2E_NODEST_COLX,
	/* U+71E4 */	U2E_NODEST_COLX,
	/* U+71E5 */	JISX0208(0xc1e7),
	/* U+71E6 */	JISX0208(0xbbb8),
	/* U+71E7 */	JISX0208(0xdffc),
	/* U+71E8 */	U2E_NODEST_COLX,
	/* U+71E9 */	U2E_NODEST_COLX,
	/* U+71EA */	U2E_NODEST_COLX,
	/* U+71EB */	U2E_NODEST_COLX,
	/* U+71EC */	JISX0208(0xdffb),
	/* U+71ED */	JISX0208(0xbfa4),
	/* U+71EE */	JISX0208(0xd2d9),
	/* U+71EF */	U2E_NODEST_COLX,
	/* U+71F0 */	U2E_NODEST_COLX,
	/* U+71F1 */	U2E_NODEST_COLX,
	/* U+71F2 */	U2E_NODEST_COLX,
	/* U+71F3 */	U2E_NODEST_COLX,
	/* U+71F4 */	U2E_NODEST_COLX,
	/* U+71F5 */	JISX0208(0xdffd),
	/* U+71F6 */	U2E_NODEST_COLX,
	/* U+71F7 */	U2E_NODEST_COLX,
	/* U+71F8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca3c)),
	/* U+71F9 */	JISX0208(0xe0a1),
	/* U+71FA */	U2E_NODEST_COLX,
	/* U+71FB */	JISX0208(0xdfee),
	/* U+71FC */	JISX0208(0xdffe),
	/* U+71FD */	U2E_NODEST_COLX,
	/* U+71FE */	IFX0213(JISX0213_1(0xf7e1),	JISX0212(0xca3d)),
	/* U+71FF */	JISX0208(0xe0a2),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_72[] = {
	/* U+7200 */	IFX0213(JISX0213_1(0xf7e2),	JISX0212(0xca3e)),
	/* U+7201 */	U2E_NODEST_COLX,
	/* U+7202 */	U2E_NODEST_COLX,
	/* U+7203 */	U2E_NODEST_COLX,
	/* U+7204 */	U2E_NODEST_COLX,
	/* U+7205 */	U2E_NODEST_COLX,
	/* U+7206 */	JISX0208(0xc7fa),
	/* U+7207 */	IFX0213(JISX0213_2(0xf027),	JISX0212(0xca3f)),
	/* U+7208 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca40)),
	/* U+7209 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca41)),
	/* U+720A */	U2E_NODEST_COLX,
	/* U+720B */	U2E_NODEST_COLX,
	/* U+720C */	U2E_NODEST_COLX,
	/* U+720D */	JISX0208(0xe0a3),
	/* U+720E */	U2E_NODEST_COLX,
	/* U+720F */	U2E_NODEST_COLX,
	/* U+7210 */	JISX0208(0xe0a4),
	/* U+7211 */	U2E_NODEST_COLX,
	/* U+7212 */	U2E_NODEST_COLX,
	/* U+7213 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca42)),
	/* U+7214 */	U2E_NODEST_COLX,
	/* U+7215 */	IFX0213(JISX0213_1(0xf7e3),	U2E_NODEST_COLX),
	/* U+7216 */	U2E_NODEST_COLX,
	/* U+7217 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca43)),
	/* U+7218 */	U2E_NODEST_COLX,
	/* U+7219 */	U2E_NODEST_COLX,
	/* U+721A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca44)),
	/* U+721B */	JISX0208(0xe0a5),
	/* U+721C */	U2E_NODEST_COLX,
	/* U+721D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca45)),
	/* U+721E */	U2E_NODEST_COLX,
	/* U+721F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca46)),
	/* U+7220 */	U2E_NODEST_COLX,
	/* U+7221 */	U2E_NODEST_COLX,
	/* U+7222 */	U2E_NODEST_COLX,
	/* U+7223 */	U2E_NODEST_COLX,
	/* U+7224 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca47)),
	/* U+7225 */	U2E_NODEST_COLX,
	/* U+7226 */	U2E_NODEST_COLX,
	/* U+7227 */	U2E_NODEST_COLX,
	/* U+7228 */	JISX0208(0xe0a6),
	/* U+7229 */	U2E_NODEST_COLX,
	/* U+722A */	JISX0208(0xc4de),
	/* U+722B */	IFX0213(JISX0213_2(0xf02a),	JISX0212(0xca48)),
	/* U+722C */	JISX0208(0xe0a8),
	/* U+722D */	JISX0208(0xe0a7),
	/* U+722E */	U2E_NODEST_COLX,
	/* U+722F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca49)),
	/* U+7230 */	JISX0208(0xe0a9),
	/* U+7231 */	U2E_NODEST_COLX,
	/* U+7232 */	JISX0208(0xe0aa),
	/* U+7233 */	U2E_NODEST_COLX,
	/* U+7234 */	IFX0213(JISX0213_2(0xf02b),	JISX0212(0xca4a)),
	/* U+7235 */	JISX0208(0xbcdf),
	/* U+7236 */	JISX0208(0xc9e3),
	/* U+7237 */	U2E_NODEST_COLX,
	/* U+7238 */	IFX0213(JISX0213_2(0xf02c),	JISX0212(0xca4b)),
	/* U+7239 */	IFX0213(JISX0213_2(0xf02d),	JISX0212(0xca4c)),
	/* U+723A */	JISX0208(0xccec),
	/* U+723B */	JISX0208(0xe0ab),
	/* U+723C */	JISX0208(0xe0ac),
	/* U+723D */	JISX0208(0xc1d6),
	/* U+723E */	JISX0208(0xbca4),
	/* U+723F */	JISX0208(0xe0ad),
	/* U+7240 */	JISX0208(0xe0ae),
	/* U+7241 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca4d)),
	/* U+7242 */	IFX0213(JISX0213_2(0xf02f),	JISX0212(0xca4e)),
	/* U+7243 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca4f)),
	/* U+7244 */	U2E_NODEST_COLX,
	/* U+7245 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca50)),
	/* U+7246 */	JISX0208(0xe0af),
	/* U+7247 */	JISX0208(0xcad2),
	/* U+7248 */	JISX0208(0xc8c7),
	/* U+7249 */	U2E_NODEST_COLX,
	/* U+724A */	U2E_NODEST_COLX,
	/* U+724B */	JISX0208(0xe0b0),
	/* U+724C */	JISX0208(0xc7d7),
	/* U+724D */	U2E_NODEST_COLX,
	/* U+724E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca51)),
	/* U+724F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca52)),
	/* U+7250 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca53)),
	/* U+7251 */	U2E_NODEST_COLX,
	/* U+7252 */	JISX0208(0xc4ad),
	/* U+7253 */	IFX0213(JISX0213_2(0xf030),	JISX0212(0xca54)),
	/* U+7254 */	U2E_NODEST_COLX,
	/* U+7255 */	IFX0213(JISX0213_1(0xf7e4),	JISX0212(0xca55)),
	/* U+7256 */	IFX0213(JISX0213_1(0xf7e5),	JISX0212(0xca56)),
	/* U+7257 */	IFX0213(JISX0213_2(0xf031),	U2E_NODEST_COLX),
	/* U+7258 */	JISX0208(0xe0b1),
	/* U+7259 */	JISX0208(0xb2e7),
	/* U+725A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca57)),
	/* U+725B */	JISX0208(0xb5ed),
	/* U+725C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca58)),
	/* U+725D */	JISX0208(0xccc6),
	/* U+725E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca59)),
	/* U+725F */	JISX0208(0xccb6),
	/* U+7260 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca5a)),
	/* U+7261 */	JISX0208(0xb2b4),
	/* U+7262 */	JISX0208(0xcfb4),
	/* U+7263 */	IFX0213(JISX0213_2(0xf032),	JISX0212(0xca5b)),
	/* U+7264 */	U2E_NODEST_COLX,
	/* U+7265 */	U2E_NODEST_COLX,
	/* U+7266 */	U2E_NODEST_COLX,
	/* U+7267 */	JISX0208(0xcbd2),
	/* U+7268 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca5c)),
	/* U+7269 */	JISX0208(0xcaaa),
	/* U+726A */	U2E_NODEST_COLX,
	/* U+726B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca5d)),
	/* U+726C */	U2E_NODEST_COLX,
	/* U+726D */	U2E_NODEST_COLX,
	/* U+726E */	IFX0213(JISX0213_2(0xf034),	JISX0212(0xca5e)),
	/* U+726F */	IFX0213(JISX0213_2(0xf035),	JISX0212(0xca5f)),
	/* U+7270 */	U2E_NODEST_COLX,
	/* U+7271 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca60)),
	/* U+7272 */	JISX0208(0xc0b7),
	/* U+7273 */	U2E_NODEST_COLX,
	/* U+7274 */	JISX0208(0xe0b2),
	/* U+7275 */	U2E_NODEST_COLX,
	/* U+7276 */	U2E_NODEST_COLX,
	/* U+7277 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca61)),
	/* U+7278 */	IFX0213(JISX0213_2(0xf036),	JISX0212(0xca62)),
	/* U+7279 */	JISX0208(0xc6c3),
	/* U+727A */	U2E_NODEST_COLX,
	/* U+727B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca63)),
	/* U+727C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca64)),
	/* U+727D */	JISX0208(0xb8a3),
	/* U+727E */	JISX0208(0xe0b3),
	/* U+727F */	IFX0213(JISX0213_2(0xf037),	JISX0212(0xca65)),
	/* U+7280 */	JISX0208(0xbad4),
	/* U+7281 */	JISX0208(0xe0b5),
	/* U+7282 */	JISX0208(0xe0b4),
	/* U+7283 */	U2E_NODEST_COLX,
	/* U+7284 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca66)),
	/* U+7285 */	U2E_NODEST_COLX,
	/* U+7286 */	U2E_NODEST_COLX,
	/* U+7287 */	JISX0208(0xe0b6),
	/* U+7288 */	U2E_NODEST_COLX,
	/* U+7289 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca67)),
	/* U+728A */	U2E_NODEST_COLX,
	/* U+728B */	U2E_NODEST_COLX,
	/* U+728C */	U2E_NODEST_COLX,
	/* U+728D */	IFX0213(JISX0213_1(0xf7e7),	JISX0212(0xca68)),
	/* U+728E */	IFX0213(JISX0213_2(0xf038),	JISX0212(0xca69)),
	/* U+728F */	U2E_NODEST_COLX,
	/* U+7290 */	U2E_NODEST_COLX,
	/* U+7291 */	U2E_NODEST_COLX,
	/* U+7292 */	JISX0208(0xe0b7),
	/* U+7293 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca6a)),
	/* U+7294 */	U2E_NODEST_COLX,
	/* U+7295 */	U2E_NODEST_COLX,
	/* U+7296 */	JISX0208(0xe0b8),
	/* U+7297 */	U2E_NODEST_COLX,
	/* U+7298 */	U2E_NODEST_COLX,
	/* U+7299 */	U2E_NODEST_COLX,
	/* U+729A */	U2E_NODEST_COLX,
	/* U+729B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca6b)),
	/* U+729C */	U2E_NODEST_COLX,
	/* U+729D */	U2E_NODEST_COLX,
	/* U+729E */	IFX0213(JISX0213_1(0xf7e8),	U2E_NODEST_COLX),
	/* U+729F */	U2E_NODEST_COLX,
	/* U+72A0 */	JISX0208(0xb5be),
	/* U+72A1 */	U2E_NODEST_COLX,
	/* U+72A2 */	JISX0208(0xe0b9),
	/* U+72A3 */	U2E_NODEST_COLX,
	/* U+72A4 */	U2E_NODEST_COLX,
	/* U+72A5 */	U2E_NODEST_COLX,
	/* U+72A6 */	U2E_NODEST_COLX,
	/* U+72A7 */	JISX0208(0xe0ba),
	/* U+72A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca6c)),
	/* U+72A9 */	U2E_NODEST_COLX,
	/* U+72AA */	U2E_NODEST_COLX,
	/* U+72AB */	U2E_NODEST_COLX,
	/* U+72AC */	JISX0208(0xb8a4),
	/* U+72AD */	IFX0213(JISX0213_2(0xf03a),	JISX0212(0xca6d)),
	/* U+72AE */	IFX0213(JISX0213_2(0xf03b),	JISX0212(0xca6e)),
	/* U+72AF */	JISX0208(0xc8c8),
	/* U+72B0 */	IFX0213(JISX0213_2(0xf03c),	U2E_NODEST_COLX),
	/* U+72B1 */	IFX0213(JISX0213_2(0xf03d),	JISX0212(0xca6f)),
	/* U+72B2 */	JISX0208(0xe0bc),
	/* U+72B3 */	U2E_NODEST_COLX,
	/* U+72B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca70)),
	/* U+72B5 */	U2E_NODEST_COLX,
	/* U+72B6 */	JISX0208(0xbef5),
	/* U+72B7 */	U2E_NODEST_COLX,
	/* U+72B8 */	U2E_NODEST_COLX,
	/* U+72B9 */	JISX0208(0xe0bb),
	/* U+72BA */	U2E_NODEST_COLX,
	/* U+72BB */	U2E_NODEST_COLX,
	/* U+72BC */	U2E_NODEST_COLX,
	/* U+72BD */	U2E_NODEST_COLX,
	/* U+72BE */	IFX0213(JISX0213_1(0xf7e9),	JISX0212(0xca71)),
	/* U+72BF */	U2E_NODEST_COLX,
	/* U+72C0 */	IFX0213(JISX0213_1(0xf7ea),	U2E_NODEST_COLX),
	/* U+72C1 */	IFX0213(JISX0213_2(0xf03e),	JISX0212(0xca72)),
	/* U+72C2 */	JISX0208(0xb6b8),
	/* U+72C3 */	JISX0208(0xe0bd),
	/* U+72C4 */	JISX0208(0xe0bf),
	/* U+72C5 */	U2E_NODEST_COLX,
	/* U+72C6 */	JISX0208(0xe0be),
	/* U+72C7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca73)),
	/* U+72C8 */	U2E_NODEST_COLX,
	/* U+72C9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca74)),
	/* U+72CA */	U2E_NODEST_COLX,
	/* U+72CB */	U2E_NODEST_COLX,
	/* U+72CC */	IFX0213(JISX0213_2(0xf040),	JISX0212(0xca75)),
	/* U+72CD */	U2E_NODEST_COLX,
	/* U+72CE */	JISX0208(0xe0c0),
	/* U+72CF */	U2E_NODEST_COLX,
	/* U+72D0 */	JISX0208(0xb8d1),
	/* U+72D1 */	U2E_NODEST_COLX,
	/* U+72D2 */	JISX0208(0xe0c1),
	/* U+72D3 */	U2E_NODEST_COLX,
	/* U+72D4 */	U2E_NODEST_COLX,
	/* U+72D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca76)),
	/* U+72D6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca77)),
	/* U+72D7 */	JISX0208(0xb6e9),
	/* U+72D8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca78)),
	/* U+72D9 */	JISX0208(0xc1c0),
	/* U+72DA */	U2E_NODEST_COLX,
	/* U+72DB */	JISX0208(0xb9fd),
	/* U+72DC */	U2E_NODEST_COLX,
	/* U+72DD */	U2E_NODEST_COLX,
	/* U+72DE */	U2E_NODEST_COLX,
	/* U+72DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca79)),
	/* U+72E0 */	JISX0208(0xe0c3),
	/* U+72E1 */	JISX0208(0xe0c4),
	/* U+72E2 */	JISX0208(0xe0c2),
	/* U+72E3 */	U2E_NODEST_COLX,
	/* U+72E4 */	U2E_NODEST_COLX,
	/* U+72E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca7a)),
	/* U+72E6 */	U2E_NODEST_COLX,
	/* U+72E7 */	U2E_NODEST_COLX,
	/* U+72E8 */	U2E_NODEST_COLX,
	/* U+72E9 */	JISX0208(0xbced),
	/* U+72EA */	U2E_NODEST_COLX,
	/* U+72EB */	U2E_NODEST_COLX,
	/* U+72EC */	JISX0208(0xc6c8),
	/* U+72ED */	JISX0208(0xb6b9),
	/* U+72EE */	U2E_NODEST_COLX,
	/* U+72EF */	U2E_NODEST_COLX,
	/* U+72F0 */	U2E_NODEST_COLX,
	/* U+72F1 */	U2E_NODEST_COLX,
	/* U+72F2 */	U2E_NODEST_COLX,
	/* U+72F3 */	IFX0213(JISX0213_2(0xf043),	JISX0212(0xca7b)),
	/* U+72F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xca7c)),
	/* U+72F5 */	U2E_NODEST_COLX,
	/* U+72F6 */	U2E_NODEST_COLX,
	/* U+72F7 */	JISX0208(0xe0c6),
	/* U+72F8 */	JISX0208(0xc3ac),
	/* U+72F9 */	JISX0208(0xe0c5),
	/* U+72FA */	IFX0213(JISX0213_2(0xf044),	JISX0212(0xca7d)),
	/* U+72FB */	IFX0213(JISX0213_1(0xf7eb),	JISX0212(0xca7e)),
	/* U+72FC */	JISX0208(0xcfb5),
	/* U+72FD */	JISX0208(0xc7e2),
	/* U+72FE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb21)),
	/* U+72FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_73[] = {
	/* U+7300 */	U2E_NODEST_COLX,
	/* U+7301 */	U2E_NODEST_COLX,
	/* U+7302 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb22)),
	/* U+7303 */	U2E_NODEST_COLX,
	/* U+7304 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb23)),
	/* U+7305 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb24)),
	/* U+7306 */	U2E_NODEST_COLX,
	/* U+7307 */	IFX0213(JISX0213_2(0xf045),	JISX0212(0xcb25)),
	/* U+7308 */	U2E_NODEST_COLX,
	/* U+7309 */	U2E_NODEST_COLX,
	/* U+730A */	JISX0208(0xe0c9),
	/* U+730B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb26)),
	/* U+730C */	U2E_NODEST_COLX,
	/* U+730D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb27)),
	/* U+730E */	U2E_NODEST_COLX,
	/* U+730F */	U2E_NODEST_COLX,
	/* U+7310 */	U2E_NODEST_COLX,
	/* U+7311 */	U2E_NODEST_COLX,
	/* U+7312 */	IFX0213(JISX0213_2(0xf046),	JISX0212(0xcb28)),
	/* U+7313 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb29)),
	/* U+7314 */	U2E_NODEST_COLX,
	/* U+7315 */	U2E_NODEST_COLX,
	/* U+7316 */	JISX0208(0xe0cb),
	/* U+7317 */	JISX0208(0xe0c8),
	/* U+7318 */	IFX0213(JISX0213_2(0xf047),	JISX0212(0xcb2a)),
	/* U+7319 */	IFX0213(JISX0213_2(0xf048),	JISX0212(0xcb2b)),
	/* U+731A */	U2E_NODEST_COLX,
	/* U+731B */	JISX0208(0xccd4),
	/* U+731C */	JISX0208(0xe0ca),
	/* U+731D */	JISX0208(0xe0cc),
	/* U+731E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb2c)),
	/* U+731F */	JISX0208(0xcec4),
	/* U+7320 */	U2E_NODEST_COLX,
	/* U+7321 */	U2E_NODEST_COLX,
	/* U+7322 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb2d)),
	/* U+7323 */	U2E_NODEST_COLX,
	/* U+7324 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb2e)),
	/* U+7325 */	JISX0208(0xe0d0),
	/* U+7326 */	U2E_NODEST_COLX,
	/* U+7327 */	IFX0213(JISX0213_1(0xf7ed),	JISX0212(0xcb2f)),
	/* U+7328 */	IFX0213(JISX0213_1(0xf7ee),	JISX0212(0xcb30)),
	/* U+7329 */	JISX0208(0xe0cf),
	/* U+732A */	JISX0208(0xc3f6),
	/* U+732B */	JISX0208(0xc7ad),
	/* U+732C */	IFX0213(JISX0213_2(0xf04b),	JISX0212(0xcb31)),
	/* U+732D */	U2E_NODEST_COLX,
	/* U+732E */	JISX0208(0xb8a5),
	/* U+732F */	JISX0208(0xe0ce),
	/* U+7330 */	U2E_NODEST_COLX,
	/* U+7331 */	IFX0213(JISX0213_2(0xf04c),	JISX0212(0xcb32)),
	/* U+7332 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb33)),
	/* U+7333 */	IFX0213(JISX0213_2(0xf04d),	U2E_NODEST_COLX),
	/* U+7334 */	JISX0208(0xe0cd),
	/* U+7335 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb34)),
	/* U+7336 */	JISX0208(0xcdb1),
	/* U+7337 */	JISX0208(0xcdb2),
	/* U+7338 */	U2E_NODEST_COLX,
	/* U+7339 */	IFX0213(JISX0213_2(0xf04a),	U2E_NODEST_COLX),
	/* U+733A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb35)),
	/* U+733B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb36)),
	/* U+733C */	U2E_NODEST_COLX,
	/* U+733D */	IFX0213(JISX0213_2(0xf04e),	JISX0212(0xcb37)),
	/* U+733E */	JISX0208(0xe0d1),
	/* U+733F */	JISX0208(0xb1ee),
	/* U+7340 */	U2E_NODEST_COLX,
	/* U+7341 */	U2E_NODEST_COLX,
	/* U+7342 */	U2E_NODEST_COLX,
	/* U+7343 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb38)),
	/* U+7344 */	JISX0208(0xb9f6),
	/* U+7345 */	JISX0208(0xbbe2),
	/* U+7346 */	U2E_NODEST_COLX,
	/* U+7347 */	U2E_NODEST_COLX,
	/* U+7348 */	U2E_NODEST_COLX,
	/* U+7349 */	U2E_NODEST_COLX,
	/* U+734A */	U2E_NODEST_COLX,
	/* U+734B */	U2E_NODEST_COLX,
	/* U+734C */	U2E_NODEST_COLX,
	/* U+734D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb39)),
	/* U+734E */	JISX0208(0xe0d2),
	/* U+734F */	JISX0208(0xe0d3),
	/* U+7350 */	IFX0213(JISX0213_1(0xf7f0),	JISX0212(0xcb3a)),
	/* U+7351 */	U2E_NODEST_COLX,
	/* U+7352 */	IFX0213(JISX0213_2(0xf04f),	JISX0212(0xcb3b)),
	/* U+7353 */	U2E_NODEST_COLX,
	/* U+7354 */	U2E_NODEST_COLX,
	/* U+7355 */	U2E_NODEST_COLX,
	/* U+7356 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb3c)),
	/* U+7357 */	JISX0208(0xe0d5),
	/* U+7358 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb3d)),
	/* U+7359 */	U2E_NODEST_COLX,
	/* U+735A */	U2E_NODEST_COLX,
	/* U+735B */	U2E_NODEST_COLX,
	/* U+735C */	U2E_NODEST_COLX,
	/* U+735D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb3e)),
	/* U+735E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb3f)),
	/* U+735F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb40)),
	/* U+7360 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb41)),
	/* U+7361 */	U2E_NODEST_COLX,
	/* U+7362 */	U2E_NODEST_COLX,
	/* U+7363 */	JISX0208(0xbdc3),
	/* U+7364 */	U2E_NODEST_COLX,
	/* U+7365 */	U2E_NODEST_COLX,
	/* U+7366 */	IFX0213(JISX0213_1(0xf7f1),	JISX0212(0xcb42)),
	/* U+7367 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb43)),
	/* U+7368 */	JISX0208(0xe0d7),
	/* U+7369 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb44)),
	/* U+736A */	JISX0208(0xe0d6),
	/* U+736B */	IFX0213(JISX0213_2(0xf051),	JISX0212(0xcb45)),
	/* U+736C */	IFX0213(JISX0213_2(0xf052),	JISX0212(0xcb46)),
	/* U+736D */	U2E_NODEST_COLX,
	/* U+736E */	IFX0213(JISX0213_2(0xf054),	JISX0212(0xcb47)),
	/* U+736F */	IFX0213(JISX0213_2(0xf055),	JISX0212(0xcb48)),
	/* U+7370 */	JISX0208(0xe0d8),
	/* U+7371 */	IFX0213(JISX0213_2(0xf056),	JISX0212(0xcb49)),
	/* U+7372 */	JISX0208(0xb3cd),
	/* U+7373 */	U2E_NODEST_COLX,
	/* U+7374 */	U2E_NODEST_COLX,
	/* U+7375 */	JISX0208(0xe0da),
	/* U+7376 */	U2E_NODEST_COLX,
	/* U+7377 */	IFX0213(JISX0213_2(0xf057),	JISX0212(0xcb4a)),
	/* U+7378 */	JISX0208(0xe0d9),
	/* U+7379 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb4b)),
	/* U+737A */	JISX0208(0xe0dc),
	/* U+737B */	JISX0208(0xe0db),
	/* U+737C */	IFX0213(JISX0213_1(0xf7f2),	JISX0212(0xcb4c)),
	/* U+737D */	U2E_NODEST_COLX,
	/* U+737E */	U2E_NODEST_COLX,
	/* U+737F */	U2E_NODEST_COLX,
	/* U+7380 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb4d)),
	/* U+7381 */	IFX0213(JISX0213_2(0xf058),	JISX0212(0xcb4e)),
	/* U+7382 */	U2E_NODEST_COLX,
	/* U+7383 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb4f)),
	/* U+7384 */	JISX0208(0xb8bc),
	/* U+7385 */	IFX0213(JISX0213_2(0xf059),	JISX0212(0xcb50)),
	/* U+7386 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb51)),
	/* U+7387 */	JISX0208(0xcea8),
	/* U+7388 */	U2E_NODEST_COLX,
	/* U+7389 */	JISX0208(0xb6cc),
	/* U+738A */	IFX0213(JISX0213_2(0xf05a),	U2E_NODEST_COLX),
	/* U+738B */	JISX0208(0xb2a6),
	/* U+738C */	U2E_NODEST_COLX,
	/* U+738D */	U2E_NODEST_COLX,
	/* U+738E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb52)),
	/* U+738F */	U2E_NODEST_COLX,
	/* U+7390 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb53)),
	/* U+7391 */	U2E_NODEST_COLX,
	/* U+7392 */	U2E_NODEST_COLX,
	/* U+7393 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb54)),
	/* U+7394 */	IFX0213(JISX0213_2(0xf05b),	U2E_NODEST_COLX),
	/* U+7395 */	IFX0213(JISX0213_1(0xf7f3),	JISX0212(0xcb55)),
	/* U+7396 */	JISX0208(0xb6ea),
	/* U+7397 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb56)),
	/* U+7398 */	IFX0213(JISX0213_2(0xf05c),	JISX0212(0xcb57)),
	/* U+7399 */	U2E_NODEST_COLX,
	/* U+739A */	U2E_NODEST_COLX,
	/* U+739B */	U2E_NODEST_COLX,
	/* U+739C */	IFX0213(JISX0213_2(0xf05d),	JISX0212(0xcb58)),
	/* U+739D */	U2E_NODEST_COLX,
	/* U+739E */	IFX0213(JISX0213_2(0xf05e),	JISX0212(0xcb59)),
	/* U+739F */	IFX0213(JISX0213_1(0xf7f4),	JISX0212(0xcb5a)),
	/* U+73A0 */	IFX0213(JISX0213_1(0xf7f5),	JISX0212(0xcb5b)),
	/* U+73A1 */	U2E_NODEST_COLX,
	/* U+73A2 */	IFX0213(JISX0213_1(0xf7f6),	JISX0212(0xcb5c)),
	/* U+73A3 */	U2E_NODEST_COLX,
	/* U+73A4 */	U2E_NODEST_COLX,
	/* U+73A5 */	IFX0213(JISX0213_2(0xf05f),	JISX0212(0xcb5d)),
	/* U+73A6 */	IFX0213(JISX0213_1(0xf7f7),	JISX0212(0xcb5e)),
	/* U+73A7 */	U2E_NODEST_COLX,
	/* U+73A8 */	IFX0213(JISX0213_2(0xf060),	U2E_NODEST_COLX),
	/* U+73A9 */	JISX0208(0xb4e1),
	/* U+73AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb5f)),
	/* U+73AB */	IFX0213(JISX0213_1(0xf7f8),	JISX0212(0xcb60)),
	/* U+73AC */	U2E_NODEST_COLX,
	/* U+73AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb61)),
	/* U+73AE */	U2E_NODEST_COLX,
	/* U+73AF */	U2E_NODEST_COLX,
	/* U+73B0 */	U2E_NODEST_COLX,
	/* U+73B1 */	U2E_NODEST_COLX,
	/* U+73B2 */	JISX0208(0xcee8),
	/* U+73B3 */	JISX0208(0xe0de),
	/* U+73B4 */	U2E_NODEST_COLX,
	/* U+73B5 */	IFX0213(JISX0213_2(0xf061),	JISX0212(0xcb62)),
	/* U+73B6 */	U2E_NODEST_COLX,
	/* U+73B7 */	IFX0213(JISX0213_2(0xf062),	JISX0212(0xcb63)),
	/* U+73B8 */	U2E_NODEST_COLX,
	/* U+73B9 */	IFX0213(JISX0213_2(0xf063),	JISX0212(0xcb64)),
	/* U+73BA */	U2E_NODEST_COLX,
	/* U+73BB */	JISX0208(0xe0e0),
	/* U+73BC */	IFX0213(JISX0213_2(0xf064),	JISX0212(0xcb65)),
	/* U+73BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb66)),
	/* U+73BE */	U2E_NODEST_COLX,
	/* U+73BF */	IFX0213(JISX0213_2(0xf065),	JISX0212(0xcb67)),
	/* U+73C0 */	JISX0208(0xe0e1),
	/* U+73C1 */	U2E_NODEST_COLX,
	/* U+73C2 */	JISX0208(0xb2d1),
	/* U+73C3 */	U2E_NODEST_COLX,
	/* U+73C4 */	U2E_NODEST_COLX,
	/* U+73C5 */	IFX0213(JISX0213_2(0xf066),	JISX0212(0xcb68)),
	/* U+73C6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb69)),
	/* U+73C7 */	U2E_NODEST_COLX,
	/* U+73C8 */	JISX0208(0xe0dd),
	/* U+73C9 */	IFX0213(JISX0213_1(0xf7f9),	JISX0212(0xcb6a)),
	/* U+73CA */	JISX0208(0xbbb9),
	/* U+73CB */	IFX0213(JISX0213_2(0xf067),	JISX0212(0xcb6b)),
	/* U+73CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb6c)),
	/* U+73CD */	JISX0208(0xc4c1),
	/* U+73CE */	JISX0208(0xe0df),
	/* U+73CF */	IFX0213(JISX0213_1(0xf7fa),	JISX0212(0xcb6d)),
	/* U+73D0 */	U2E_NODEST_COLX,
	/* U+73D1 */	U2E_NODEST_COLX,
	/* U+73D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb6e)),
	/* U+73D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb6f)),
	/* U+73D4 */	U2E_NODEST_COLX,
	/* U+73D5 */	U2E_NODEST_COLX,
	/* U+73D6 */	IFX0213(JISX0213_1(0xf7fb),	JISX0212(0xcb70)),
	/* U+73D7 */	U2E_NODEST_COLX,
	/* U+73D8 */	U2E_NODEST_COLX,
	/* U+73D9 */	IFX0213(JISX0213_1(0xf7fc),	JISX0212(0xcb71)),
	/* U+73DA */	U2E_NODEST_COLX,
	/* U+73DB */	U2E_NODEST_COLX,
	/* U+73DC */	U2E_NODEST_COLX,
	/* U+73DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb72)),
	/* U+73DE */	JISX0208(0xe0e4),
	/* U+73DF */	U2E_NODEST_COLX,
	/* U+73E0 */	JISX0208(0xbcee),
	/* U+73E1 */	IFX0213(JISX0213_2(0xf068),	JISX0212(0xcb73)),
	/* U+73E2 */	U2E_NODEST_COLX,
	/* U+73E3 */	IFX0213(JISX0213_1(0xf7fd),	JISX0212(0xcb74)),
	/* U+73E4 */	U2E_NODEST_COLX,
	/* U+73E5 */	JISX0208(0xe0e2),
	/* U+73E6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb75)),
	/* U+73E7 */	IFX0213(JISX0213_2(0xf069),	JISX0212(0xcb76)),
	/* U+73E8 */	U2E_NODEST_COLX,
	/* U+73E9 */	IFX0213(JISX0213_1(0xf7fe),	JISX0212(0xcb77)),
	/* U+73EA */	JISX0208(0xb7be),
	/* U+73EB */	U2E_NODEST_COLX,
	/* U+73EC */	U2E_NODEST_COLX,
	/* U+73ED */	JISX0208(0xc8c9),
	/* U+73EE */	JISX0208(0xe0e3),
	/* U+73EF */	U2E_NODEST_COLX,
	/* U+73F0 */	U2E_NODEST_COLX,
	/* U+73F1 */	JISX0208(0xe0fe),
	/* U+73F2 */	U2E_NODEST_COLX,
	/* U+73F3 */	U2E_NODEST_COLX,
	/* U+73F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb78)),
	/* U+73F5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb79)),
	/* U+73F6 */	U2E_NODEST_COLX,
	/* U+73F7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb7a)),
	/* U+73F8 */	JISX0208(0xe0e9),
	/* U+73F9 */	IFX0213(JISX0213_2(0xf06a),	JISX0212(0xcb7b)),
	/* U+73FA */	IFX0213(JISX0213_2(0xf06c),	JISX0212(0xcb7c)),
	/* U+73FB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb7d)),
	/* U+73FC */	U2E_NODEST_COLX,
	/* U+73FD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcb7e)),
	/* U+73FE */	JISX0208(0xb8bd),
	/* U+73FF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc21)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_74[] = {
	/* U+7400 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc22)),
	/* U+7401 */	IFX0213(JISX0213_2(0xf06d),	JISX0212(0xcc23)),
	/* U+7402 */	U2E_NODEST_COLX,
	/* U+7403 */	JISX0208(0xb5e5),
	/* U+7404 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc24)),
	/* U+7405 */	JISX0208(0xe0e6),
	/* U+7406 */	JISX0208(0xcdfd),
	/* U+7407 */	IFX0213(JISX0213_1(0xf8a1),	JISX0212(0xcc25)),
	/* U+7408 */	U2E_NODEST_COLX,
	/* U+7409 */	JISX0208(0xceb0),
	/* U+740A */	IFX0213(JISX0213_1(0xf8a2),	JISX0212(0xcc26)),
	/* U+740B */	U2E_NODEST_COLX,
	/* U+740C */	U2E_NODEST_COLX,
	/* U+740D */	U2E_NODEST_COLX,
	/* U+740E */	U2E_NODEST_COLX,
	/* U+740F */	U2E_NODEST_COLX,
	/* U+7410 */	U2E_NODEST_COLX,
	/* U+7411 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc27)),
	/* U+7412 */	U2E_NODEST_COLX,
	/* U+7413 */	IFX0213(JISX0213_2(0xf06b),	U2E_NODEST_COLX),
	/* U+7414 */	U2E_NODEST_COLX,
	/* U+7415 */	U2E_NODEST_COLX,
	/* U+7416 */	U2E_NODEST_COLX,
	/* U+7417 */	U2E_NODEST_COLX,
	/* U+7418 */	U2E_NODEST_COLX,
	/* U+7419 */	U2E_NODEST_COLX,
	/* U+741A */	IFX0213(JISX0213_1(0xf8a3),	JISX0212(0xcc28)),
	/* U+741B */	IFX0213(JISX0213_1(0xf8a4),	JISX0212(0xcc29)),
	/* U+741C */	U2E_NODEST_COLX,
	/* U+741D */	U2E_NODEST_COLX,
	/* U+741E */	U2E_NODEST_COLX,
	/* U+741F */	U2E_NODEST_COLX,
	/* U+7420 */	U2E_NODEST_COLX,
	/* U+7421 */	U2E_NODEST_COLX,
	/* U+7422 */	JISX0208(0xc2f6),
	/* U+7423 */	U2E_NODEST_COLX,
	/* U+7424 */	IFX0213(JISX0213_2(0xf06e),	JISX0212(0xcc2a)),
	/* U+7425 */	JISX0208(0xe0e8),
	/* U+7426 */	IFX0213(JISX0213_1(0xf8a6),	JISX0212(0xcc2b)),
	/* U+7427 */	U2E_NODEST_COLX,
	/* U+7428 */	IFX0213(JISX0213_1(0xf8a7),	JISX0212(0xcc2c)),
	/* U+7429 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc2d)),
	/* U+742A */	IFX0213(JISX0213_1(0xf8a8),	JISX0212(0xcc2e)),
	/* U+742B */	IFX0213(JISX0213_1(0xf8a9),	JISX0212(0xcc2f)),
	/* U+742C */	IFX0213(JISX0213_1(0xf8aa),	JISX0212(0xcc30)),
	/* U+742D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc31)),
	/* U+742E */	IFX0213(JISX0213_1(0xf8ab),	JISX0212(0xcc32)),
	/* U+742F */	IFX0213(JISX0213_1(0xf8ac),	JISX0212(0xcc33)),
	/* U+7430 */	IFX0213(JISX0213_1(0xf8ad),	JISX0212(0xcc34)),
	/* U+7431 */	IFX0213(JISX0213_2(0xf06f),	JISX0212(0xcc35)),
	/* U+7432 */	JISX0208(0xe0ea),
	/* U+7433 */	JISX0208(0xced6),
	/* U+7434 */	JISX0208(0xb6d7),
	/* U+7435 */	JISX0208(0xc8fc),
	/* U+7436 */	JISX0208(0xc7ca),
	/* U+7437 */	U2E_NODEST_COLX,
	/* U+7438 */	U2E_NODEST_COLX,
	/* U+7439 */	IFX0213(JISX0213_2(0xf070),	JISX0212(0xcc36)),
	/* U+743A */	JISX0208(0xe0eb),
	/* U+743B */	U2E_NODEST_COLX,
	/* U+743C */	U2E_NODEST_COLX,
	/* U+743D */	U2E_NODEST_COLX,
	/* U+743E */	U2E_NODEST_COLX,
	/* U+743F */	JISX0208(0xe0ed),
	/* U+7440 */	IFX0213(JISX0213_2(0xf072),	JISX0212(0xcc37)),
	/* U+7441 */	JISX0208(0xe0f0),
	/* U+7442 */	U2E_NODEST_COLX,
	/* U+7443 */	IFX0213(JISX0213_2(0xf073),	JISX0212(0xcc38)),
	/* U+7444 */	IFX0213(JISX0213_1(0xf8ae),	JISX0212(0xcc39)),
	/* U+7445 */	U2E_NODEST_COLX,
	/* U+7446 */	IFX0213(JISX0213_1(0xf8af),	JISX0212(0xcc3a)),
	/* U+7447 */	IFX0213(JISX0213_1(0xf8b0),	JISX0212(0xcc3b)),
	/* U+7448 */	U2E_NODEST_COLX,
	/* U+7449 */	U2E_NODEST_COLX,
	/* U+744A */	U2E_NODEST_COLX,
	/* U+744B */	IFX0213(JISX0213_1(0xf8b1),	JISX0212(0xcc3c)),
	/* U+744C */	U2E_NODEST_COLX,
	/* U+744D */	IFX0213(JISX0213_2(0xf074),	JISX0212(0xcc3d)),
	/* U+744E */	U2E_NODEST_COLX,
	/* U+744F */	U2E_NODEST_COLX,
	/* U+7450 */	U2E_NODEST_COLX,
	/* U+7451 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc3e)),
	/* U+7452 */	IFX0213(JISX0213_2(0xf075),	JISX0212(0xcc3f)),
	/* U+7453 */	IFX0213(JISX0213_2(0xf071),	U2E_NODEST_COLX),
	/* U+7454 */	U2E_NODEST_COLX,
	/* U+7455 */	JISX0208(0xe0ec),
	/* U+7456 */	U2E_NODEST_COLX,
	/* U+7457 */	IFX0213(JISX0213_1(0xf8b2),	JISX0212(0xcc40)),
	/* U+7458 */	U2E_NODEST_COLX,
	/* U+7459 */	JISX0208(0xe0ef),
	/* U+745A */	JISX0208(0xb8ea),
	/* U+745B */	JISX0208(0xb1cd),
	/* U+745C */	JISX0208(0xe0f1),
	/* U+745D */	IFX0213(JISX0213_2(0xf076),	JISX0212(0xcc41)),
	/* U+745E */	JISX0208(0xbff0),
	/* U+745F */	JISX0208(0xe0ee),
	/* U+7460 */	JISX0208(0xcedc),
	/* U+7461 */	U2E_NODEST_COLX,
	/* U+7462 */	IFX0213(JISX0213_1(0xf8b3),	JISX0212(0xcc42)),
	/* U+7463 */	JISX0208(0xe0f4),
	/* U+7464 */	JISX0208(0xf4a4),
	/* U+7465 */	U2E_NODEST_COLX,
	/* U+7466 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc43)),
	/* U+7467 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc44)),
	/* U+7468 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc45)),
	/* U+7469 */	JISX0208(0xe0f2),
	/* U+746A */	JISX0208(0xe0f5),
	/* U+746B */	IFX0213(JISX0213_1(0xf8b4),	JISX0212(0xcc46)),
	/* U+746C */	U2E_NODEST_COLX,
	/* U+746D */	IFX0213(JISX0213_1(0xf8b5),	JISX0212(0xcc47)),
	/* U+746E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc48)),
	/* U+746F */	JISX0208(0xe0e7),
	/* U+7470 */	JISX0208(0xe0f3),
	/* U+7471 */	IFX0213(JISX0213_2(0xf077),	JISX0212(0xcc49)),
	/* U+7472 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc4a)),
	/* U+7473 */	JISX0208(0xbabc),
	/* U+7474 */	U2E_NODEST_COLX,
	/* U+7475 */	U2E_NODEST_COLX,
	/* U+7476 */	JISX0208(0xe0f6),
	/* U+7477 */	U2E_NODEST_COLX,
	/* U+7478 */	U2E_NODEST_COLX,
	/* U+7479 */	U2E_NODEST_COLX,
	/* U+747A */	U2E_NODEST_COLX,
	/* U+747B */	U2E_NODEST_COLX,
	/* U+747C */	U2E_NODEST_COLX,
	/* U+747D */	U2E_NODEST_COLX,
	/* U+747E */	JISX0208(0xe0f7),
	/* U+747F */	U2E_NODEST_COLX,
	/* U+7480 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc4b)),
	/* U+7481 */	IFX0213(JISX0213_2(0xf078),	JISX0212(0xcc4c)),
	/* U+7482 */	U2E_NODEST_COLX,
	/* U+7483 */	JISX0208(0xcdfe),
	/* U+7484 */	U2E_NODEST_COLX,
	/* U+7485 */	IFX0213(JISX0213_2(0xf079),	JISX0212(0xcc4d)),
	/* U+7486 */	IFX0213(JISX0213_1(0xf8b6),	JISX0212(0xcc4e)),
	/* U+7487 */	IFX0213(JISX0213_1(0xf8b7),	JISX0212(0xcc4f)),
	/* U+7488 */	IFX0213(JISX0213_2(0xf07a),	U2E_NODEST_COLX),
	/* U+7489 */	IFX0213(JISX0213_1(0xf8b8),	JISX0212(0xcc50)),
	/* U+748A */	U2E_NODEST_COLX,
	/* U+748B */	JISX0208(0xe0f8),
	/* U+748C */	U2E_NODEST_COLX,
	/* U+748D */	U2E_NODEST_COLX,
	/* U+748E */	U2E_NODEST_COLX,
	/* U+748F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc51)),
	/* U+7490 */	IFX0213(JISX0213_1(0xf8bd),	JISX0212(0xcc52)),
	/* U+7491 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc53)),
	/* U+7492 */	IFX0213(JISX0213_2(0xf07c),	JISX0212(0xcc54)),
	/* U+7493 */	U2E_NODEST_COLX,
	/* U+7494 */	U2E_NODEST_COLX,
	/* U+7495 */	U2E_NODEST_COLX,
	/* U+7496 */	U2E_NODEST_COLX,
	/* U+7497 */	IFX0213(JISX0213_2(0xf07d),	U2E_NODEST_COLX),
	/* U+7498 */	IFX0213(JISX0213_1(0xf8b9),	JISX0212(0xcc55)),
	/* U+7499 */	IFX0213(JISX0213_2(0xf07e),	JISX0212(0xcc56)),
	/* U+749A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc57)),
	/* U+749B */	U2E_NODEST_COLX,
	/* U+749C */	IFX0213(JISX0213_1(0xf8ba),	JISX0212(0xcc58)),
	/* U+749D */	U2E_NODEST_COLX,
	/* U+749E */	JISX0208(0xe0f9),
	/* U+749F */	IFX0213(JISX0213_1(0xf8bb),	JISX0212(0xcc59)),
	/* U+74A0 */	IFX0213(JISX0213_2(0xf121),	JISX0212(0xcc5a)),
	/* U+74A1 */	IFX0213(JISX0213_2(0xf122),	JISX0212(0xcc5b)),
	/* U+74A2 */	JISX0208(0xe0e5),
	/* U+74A3 */	IFX0213(JISX0213_1(0xf8bc),	JISX0212(0xcc5c)),
	/* U+74A4 */	U2E_NODEST_COLX,
	/* U+74A5 */	IFX0213(JISX0213_2(0xf123),	U2E_NODEST_COLX),
	/* U+74A6 */	IFX0213(JISX0213_1(0xf8be),	JISX0212(0xcc5d)),
	/* U+74A7 */	JISX0208(0xe0fa),
	/* U+74A8 */	IFX0213(JISX0213_1(0xf8bf),	JISX0212(0xcc5e)),
	/* U+74A9 */	IFX0213(JISX0213_1(0xf8c0),	JISX0212(0xcc5f)),
	/* U+74AA */	IFX0213(JISX0213_2(0xf124),	JISX0212(0xcc60)),
	/* U+74AB */	IFX0213(JISX0213_2(0xf125),	JISX0212(0xcc61)),
	/* U+74AC */	U2E_NODEST_COLX,
	/* U+74AD */	U2E_NODEST_COLX,
	/* U+74AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc62)),
	/* U+74AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc63)),
	/* U+74B0 */	JISX0208(0xb4c4),
	/* U+74B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc64)),
	/* U+74B2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc65)),
	/* U+74B3 */	U2E_NODEST_COLX,
	/* U+74B4 */	U2E_NODEST_COLX,
	/* U+74B5 */	IFX0213(JISX0213_1(0xf8c1),	JISX0212(0xcc66)),
	/* U+74B6 */	U2E_NODEST_COLX,
	/* U+74B7 */	U2E_NODEST_COLX,
	/* U+74B8 */	U2E_NODEST_COLX,
	/* U+74B9 */	IFX0213(JISX0213_2(0xf126),	JISX0212(0xcc67)),
	/* U+74BA */	IFX0213(JISX0213_2(0xf128),	U2E_NODEST_COLX),
	/* U+74BB */	IFX0213(JISX0213_2(0xf127),	JISX0212(0xcc68)),
	/* U+74BC */	U2E_NODEST_COLX,
	/* U+74BD */	JISX0208(0xbca5),
	/* U+74BE */	U2E_NODEST_COLX,
	/* U+74BF */	IFX0213(JISX0213_1(0xf8c2),	JISX0212(0xcc69)),
	/* U+74C0 */	U2E_NODEST_COLX,
	/* U+74C1 */	U2E_NODEST_COLX,
	/* U+74C2 */	U2E_NODEST_COLX,
	/* U+74C3 */	U2E_NODEST_COLX,
	/* U+74C4 */	U2E_NODEST_COLX,
	/* U+74C5 */	U2E_NODEST_COLX,
	/* U+74C6 */	U2E_NODEST_COLX,
	/* U+74C7 */	U2E_NODEST_COLX,
	/* U+74C8 */	IFX0213(JISX0213_1(0xf8c3),	JISX0212(0xcc6a)),
	/* U+74C9 */	IFX0213(JISX0213_1(0xf8c4),	JISX0212(0xcc6b)),
	/* U+74CA */	JISX0208(0xe0fb),
	/* U+74CB */	U2E_NODEST_COLX,
	/* U+74CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc6c)),
	/* U+74CD */	U2E_NODEST_COLX,
	/* U+74CE */	U2E_NODEST_COLX,
	/* U+74CF */	JISX0208(0xe0fc),
	/* U+74D0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc6d)),
	/* U+74D1 */	U2E_NODEST_COLX,
	/* U+74D2 */	U2E_NODEST_COLX,
	/* U+74D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc6e)),
	/* U+74D4 */	JISX0208(0xe0fd),
	/* U+74D5 */	U2E_NODEST_COLX,
	/* U+74D6 */	IFX0213(JISX0213_2(0xf129),	U2E_NODEST_COLX),
	/* U+74D7 */	U2E_NODEST_COLX,
	/* U+74D8 */	IFX0213(JISX0213_2(0xf12a),	JISX0212(0xcc6f)),
	/* U+74D9 */	U2E_NODEST_COLX,
	/* U+74DA */	IFX0213(JISX0213_1(0xf8c5),	JISX0212(0xcc70)),
	/* U+74DB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc71)),
	/* U+74DC */	JISX0208(0xb1bb),
	/* U+74DD */	U2E_NODEST_COLX,
	/* U+74DE */	IFX0213(JISX0213_2(0xf12b),	JISX0212(0xcc72)),
	/* U+74DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc73)),
	/* U+74E0 */	JISX0208(0xe1a1),
	/* U+74E1 */	U2E_NODEST_COLX,
	/* U+74E2 */	JISX0208(0xc9bb),
	/* U+74E3 */	JISX0208(0xe1a2),
	/* U+74E4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc74)),
	/* U+74E5 */	U2E_NODEST_COLX,
	/* U+74E6 */	JISX0208(0xb4a4),
	/* U+74E7 */	JISX0208(0xe1a3),
	/* U+74E8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc75)),
	/* U+74E9 */	JISX0208(0xe1a4),
	/* U+74EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc76)),
	/* U+74EB */	IFX0213(JISX0213_2(0xf12d),	JISX0212(0xcc77)),
	/* U+74EC */	U2E_NODEST_COLX,
	/* U+74ED */	U2E_NODEST_COLX,
	/* U+74EE */	JISX0208(0xe1a5),
	/* U+74EF */	IFX0213(JISX0213_2(0xf12c),	JISX0212(0xcc78)),
	/* U+74F0 */	JISX0208(0xe1a7),
	/* U+74F1 */	JISX0208(0xe1a8),
	/* U+74F2 */	JISX0208(0xe1a6),
	/* U+74F3 */	U2E_NODEST_COLX,
	/* U+74F4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc79)),
	/* U+74F5 */	U2E_NODEST_COLX,
	/* U+74F6 */	JISX0208(0xc9d3),
	/* U+74F7 */	JISX0208(0xe1aa),
	/* U+74F8 */	JISX0208(0xe1a9),
	/* U+74F9 */	U2E_NODEST_COLX,
	/* U+74FA */	IFX0213(JISX0213_2(0xf12f),	JISX0212(0xcc7a)),
	/* U+74FB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc7b)),
	/* U+74FC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc7c)),
	/* U+74FD */	U2E_NODEST_COLX,
	/* U+74FE */	U2E_NODEST_COLX,
	/* U+74FF */	IFX0213(JISX0213_1(0xf8c6),	JISX0212(0xcc7d)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_75[] = {
	/* U+7500 */	U2E_NODEST_COLX,
	/* U+7501 */	IFX0213(JISX0213_1(0xf8c7),	IBM(0xf450)),
	/* U+7502 */	U2E_NODEST_COLX,
	/* U+7503 */	JISX0208(0xe1ac),
	/* U+7504 */	JISX0208(0xe1ab),
	/* U+7505 */	JISX0208(0xe1ad),
	/* U+7506 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcc7e)),
	/* U+7507 */	U2E_NODEST_COLX,
	/* U+7508 */	U2E_NODEST_COLX,
	/* U+7509 */	U2E_NODEST_COLX,
	/* U+750A */	U2E_NODEST_COLX,
	/* U+750B */	U2E_NODEST_COLX,
	/* U+750C */	JISX0208(0xe1ae),
	/* U+750D */	JISX0208(0xe1b0),
	/* U+750E */	JISX0208(0xe1af),
	/* U+750F */	U2E_NODEST_COLX,
	/* U+7510 */	U2E_NODEST_COLX,
	/* U+7511 */	JISX0208(0xb9f9),
	/* U+7512 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd21)),
	/* U+7513 */	JISX0208(0xe1b2),
	/* U+7514 */	U2E_NODEST_COLX,
	/* U+7515 */	JISX0208(0xe1b1),
	/* U+7516 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd22)),
	/* U+7517 */	IFX0213(JISX0213_1(0xf8c8),	JISX0212(0xcd23)),
	/* U+7518 */	JISX0208(0xb4c5),
	/* U+7519 */	U2E_NODEST_COLX,
	/* U+751A */	JISX0208(0xbfd3),
	/* U+751B */	U2E_NODEST_COLX,
	/* U+751C */	JISX0208(0xc5bc),
	/* U+751D */	U2E_NODEST_COLX,
	/* U+751E */	JISX0208(0xe1b3),
	/* U+751F */	JISX0208(0xc0b8),
	/* U+7520 */	IFX0213(JISX0213_2(0xf131),	JISX0212(0xcd24)),
	/* U+7521 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd25)),
	/* U+7522 */	U2E_NODEST_COLX,
	/* U+7523 */	JISX0208(0xbbba),
	/* U+7524 */	IFX0213(JISX0213_2(0xf132),	JISX0212(0xcd26)),
	/* U+7525 */	JISX0208(0xb1f9),
	/* U+7526 */	JISX0208(0xe1b4),
	/* U+7527 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd27)),
	/* U+7528 */	JISX0208(0xcdd1),
	/* U+7529 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd28)),
	/* U+752A */	IFX0213(JISX0213_2(0xf133),	JISX0212(0xcd29)),
	/* U+752B */	JISX0208(0xcae3),
	/* U+752C */	JISX0208(0xe1b5),
	/* U+752D */	U2E_NODEST_COLX,
	/* U+752E */	U2E_NODEST_COLX,
	/* U+752F */	IFX0213(JISX0213_1(0xf8c9),	JISX0212(0xcd2a)),
	/* U+7530 */	JISX0208(0xc5c4),
	/* U+7531 */	JISX0208(0xcdb3),
	/* U+7532 */	JISX0208(0xb9c3),
	/* U+7533 */	JISX0208(0xbfbd),
	/* U+7534 */	U2E_NODEST_COLX,
	/* U+7535 */	U2E_NODEST_COLX,
	/* U+7536 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd2b)),
	/* U+7537 */	JISX0208(0xc3cb),
	/* U+7538 */	JISX0208(0xd2b4),
	/* U+7539 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd2c)),
	/* U+753A */	JISX0208(0xc4ae),
	/* U+753B */	JISX0208(0xb2e8),
	/* U+753C */	JISX0208(0xe1b6),
	/* U+753D */	IFX0213(JISX0213_2(0xf136),	JISX0212(0xcd2d)),
	/* U+753E */	IFX0213(JISX0213_2(0xf137),	JISX0212(0xcd2e)),
	/* U+753F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd2f)),
	/* U+7540 */	IFX0213(JISX0213_2(0xf138),	JISX0212(0xcd30)),
	/* U+7541 */	U2E_NODEST_COLX,
	/* U+7542 */	U2E_NODEST_COLX,
	/* U+7543 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd31)),
	/* U+7544 */	JISX0208(0xe1b7),
	/* U+7545 */	U2E_NODEST_COLX,
	/* U+7546 */	JISX0208(0xe1bc),
	/* U+7547 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd32)),
	/* U+7548 */	IFX0213(JISX0213_2(0xf139),	JISX0212(0xcd33)),
	/* U+7549 */	JISX0208(0xe1ba),
	/* U+754A */	JISX0208(0xe1b9),
	/* U+754B */	JISX0208(0xdac2),
	/* U+754C */	JISX0208(0xb3a6),
	/* U+754D */	JISX0208(0xe1b8),
	/* U+754E */	IFX0213(JISX0213_2(0xf13a),	JISX0212(0xcd34)),
	/* U+754F */	JISX0208(0xb0da),
	/* U+7550 */	IFX0213(JISX0213_2(0xf13b),	JISX0212(0xcd35)),
	/* U+7551 */	JISX0208(0xc8aa),
	/* U+7552 */	IFX0213(JISX0213_2(0xf13c),	JISX0212(0xcd36)),
	/* U+7553 */	U2E_NODEST_COLX,
	/* U+7554 */	JISX0208(0xc8ca),
	/* U+7555 */	U2E_NODEST_COLX,
	/* U+7556 */	U2E_NODEST_COLX,
	/* U+7557 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd37)),
	/* U+7558 */	U2E_NODEST_COLX,
	/* U+7559 */	JISX0208(0xceb1),
	/* U+755A */	JISX0208(0xe1bd),
	/* U+755B */	JISX0208(0xe1bb),
	/* U+755C */	JISX0208(0xc3dc),
	/* U+755D */	JISX0208(0xc0a6),
	/* U+755E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd38)),
	/* U+755F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd39)),
	/* U+7560 */	JISX0208(0xc8ab),
	/* U+7561 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd3a)),
	/* U+7562 */	JISX0208(0xc9ad),
	/* U+7563 */	U2E_NODEST_COLX,
	/* U+7564 */	JISX0208(0xe1bf),
	/* U+7565 */	JISX0208(0xceac),
	/* U+7566 */	JISX0208(0xb7cd),
	/* U+7567 */	JISX0208(0xe1c0),
	/* U+7568 */	U2E_NODEST_COLX,
	/* U+7569 */	JISX0208(0xe1be),
	/* U+756A */	JISX0208(0xc8d6),
	/* U+756B */	JISX0208(0xe1c1),
	/* U+756C */	IFX0213(JISX0213_2(0xf13d),	U2E_NODEST_COLX),
	/* U+756D */	JISX0208(0xe1c2),
	/* U+756E */	U2E_NODEST_COLX,
	/* U+756F */	IFX0213(JISX0213_1(0xf8ca),	JISX0212(0xcd3b)),
	/* U+7570 */	JISX0208(0xb0db),
	/* U+7571 */	IFX0213(JISX0213_2(0xf13f),	JISX0212(0xcd3c)),
	/* U+7572 */	IFX0213(JISX0213_2(0xf13e),	U2E_NODEST_COLX),
	/* U+7573 */	JISX0208(0xbef6),
	/* U+7574 */	JISX0208(0xe1c7),
	/* U+7575 */	U2E_NODEST_COLX,
	/* U+7576 */	JISX0208(0xe1c4),
	/* U+7577 */	JISX0208(0xc6ed),
	/* U+7578 */	JISX0208(0xe1c3),
	/* U+7579 */	IFX0213(JISX0213_1(0xf8cb),	JISX0212(0xcd3d)),
	/* U+757A */	IFX0213(JISX0213_2(0xf140),	JISX0212(0xcd3e)),
	/* U+757B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd3f)),
	/* U+757C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd40)),
	/* U+757D */	IFX0213(JISX0213_2(0xf141),	JISX0212(0xcd41)),
	/* U+757E */	IFX0213(JISX0213_2(0xf142),	JISX0212(0xcd42)),
	/* U+757F */	JISX0208(0xb5a6),
	/* U+7580 */	U2E_NODEST_COLX,
	/* U+7581 */	IFX0213(JISX0213_2(0xf143),	JISX0212(0xcd43)),
	/* U+7582 */	JISX0208(0xe1ca),
	/* U+7583 */	U2E_NODEST_COLX,
	/* U+7584 */	U2E_NODEST_COLX,
	/* U+7585 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd44)),
	/* U+7586 */	JISX0208(0xe1c5),
	/* U+7587 */	JISX0208(0xe1c6),
	/* U+7588 */	U2E_NODEST_COLX,
	/* U+7589 */	JISX0208(0xe1c9),
	/* U+758A */	JISX0208(0xe1c8),
	/* U+758B */	JISX0208(0xc9a5),
	/* U+758C */	IFX0213(JISX0213_2(0xf145),	U2E_NODEST_COLX),
	/* U+758D */	U2E_NODEST_COLX,
	/* U+758E */	JISX0208(0xc1c2),
	/* U+758F */	JISX0208(0xc1c1),
	/* U+7590 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd45)),
	/* U+7591 */	JISX0208(0xb5bf),
	/* U+7592 */	IFX0213(JISX0213_1(0xf8cc),	JISX0212(0xcd46)),
	/* U+7593 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd47)),
	/* U+7594 */	JISX0208(0xe1cb),
	/* U+7595 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd48)),
	/* U+7596 */	U2E_NODEST_COLX,
	/* U+7597 */	U2E_NODEST_COLX,
	/* U+7598 */	U2E_NODEST_COLX,
	/* U+7599 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd49)),
	/* U+759A */	JISX0208(0xe1cc),
	/* U+759B */	U2E_NODEST_COLX,
	/* U+759C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd4a)),
	/* U+759D */	JISX0208(0xe1cd),
	/* U+759E */	U2E_NODEST_COLX,
	/* U+759F */	U2E_NODEST_COLX,
	/* U+75A0 */	U2E_NODEST_COLX,
	/* U+75A1 */	U2E_NODEST_COLX,
	/* U+75A2 */	IFX0213(JISX0213_2(0xf147),	JISX0212(0xcd4b)),
	/* U+75A3 */	JISX0208(0xe1cf),
	/* U+75A4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd4c)),
	/* U+75A5 */	JISX0208(0xe1ce),
	/* U+75A6 */	U2E_NODEST_COLX,
	/* U+75A7 */	U2E_NODEST_COLX,
	/* U+75A8 */	U2E_NODEST_COLX,
	/* U+75A9 */	U2E_NODEST_COLX,
	/* U+75AA */	U2E_NODEST_COLX,
	/* U+75AB */	JISX0208(0xb1d6),
	/* U+75AC */	U2E_NODEST_COLX,
	/* U+75AD */	U2E_NODEST_COLX,
	/* U+75AE */	U2E_NODEST_COLX,
	/* U+75AF */	U2E_NODEST_COLX,
	/* U+75B0 */	IFX0213(JISX0213_2(0xf149),	U2E_NODEST_COLX),
	/* U+75B1 */	JISX0208(0xe1d7),
	/* U+75B2 */	JISX0208(0xc8e8),
	/* U+75B3 */	JISX0208(0xe1d1),
	/* U+75B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd4d)),
	/* U+75B5 */	JISX0208(0xe1d3),
	/* U+75B6 */	U2E_NODEST_COLX,
	/* U+75B7 */	IFX0213(JISX0213_2(0xf14a),	U2E_NODEST_COLX),
	/* U+75B8 */	JISX0208(0xe1d5),
	/* U+75B9 */	JISX0208(0xbfbe),
	/* U+75BA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd4e)),
	/* U+75BB */	U2E_NODEST_COLX,
	/* U+75BC */	JISX0208(0xe1d6),
	/* U+75BD */	JISX0208(0xe1d4),
	/* U+75BE */	JISX0208(0xbcc0),
	/* U+75BF */	IFX0213(JISX0213_2(0xf14b),	JISX0212(0xcd4f)),
	/* U+75C0 */	IFX0213(JISX0213_2(0xf14c),	JISX0212(0xcd50)),
	/* U+75C1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd51)),
	/* U+75C2 */	JISX0208(0xe1d0),
	/* U+75C3 */	JISX0208(0xe1d2),
	/* U+75C4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd52)),
	/* U+75C5 */	JISX0208(0xc9c2),
	/* U+75C6 */	IFX0213(JISX0213_2(0xf14d),	JISX0212(0xcd53)),
	/* U+75C7 */	JISX0208(0xbec9),
	/* U+75C8 */	U2E_NODEST_COLX,
	/* U+75C9 */	U2E_NODEST_COLX,
	/* U+75CA */	JISX0208(0xe1d9),
	/* U+75CB */	U2E_NODEST_COLX,
	/* U+75CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd54)),
	/* U+75CD */	JISX0208(0xe1d8),
	/* U+75CE */	IFX0213(JISX0213_1(0xf8ce),	JISX0212(0xcd55)),
	/* U+75CF */	IFX0213(JISX0213_2(0xf14e),	JISX0212(0xcd56)),
	/* U+75D0 */	U2E_NODEST_COLX,
	/* U+75D1 */	U2E_NODEST_COLX,
	/* U+75D2 */	JISX0208(0xe1da),
	/* U+75D3 */	IFX0213(JISX0213_2(0xf14f),	U2E_NODEST_COLX),
	/* U+75D4 */	JISX0208(0xbca6),
	/* U+75D5 */	JISX0208(0xbaaf),
	/* U+75D6 */	U2E_NODEST_COLX,
	/* U+75D7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd57)),
	/* U+75D8 */	JISX0208(0xc5f7),
	/* U+75D9 */	JISX0208(0xe1db),
	/* U+75DA */	U2E_NODEST_COLX,
	/* U+75DB */	JISX0208(0xc4cb),
	/* U+75DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd58)),
	/* U+75DD */	IFX0213(JISX0213_2(0xf150),	U2E_NODEST_COLX),
	/* U+75DE */	JISX0208(0xe1dd),
	/* U+75DF */	IFX0213(JISX0213_2(0xf151),	JISX0212(0xcd59)),
	/* U+75E0 */	IFX0213(JISX0213_2(0xf152),	JISX0212(0xcd5a)),
	/* U+75E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd5b)),
	/* U+75E2 */	JISX0208(0xcea1),
	/* U+75E3 */	JISX0208(0xe1dc),
	/* U+75E4 */	IFX0213(JISX0213_1(0xf8cf),	JISX0212(0xcd5c)),
	/* U+75E5 */	U2E_NODEST_COLX,
	/* U+75E6 */	U2E_NODEST_COLX,
	/* U+75E7 */	IFX0213(JISX0213_2(0xf153),	JISX0212(0xcd5d)),
	/* U+75E8 */	U2E_NODEST_COLX,
	/* U+75E9 */	JISX0208(0xc1e9),
	/* U+75EA */	U2E_NODEST_COLX,
	/* U+75EB */	U2E_NODEST_COLX,
	/* U+75EC */	IFX0213(JISX0213_2(0xf154),	JISX0212(0xcd5e)),
	/* U+75ED */	U2E_NODEST_COLX,
	/* U+75EE */	IFX0213(JISX0213_2(0xf155),	JISX0212(0xcd5f)),
	/* U+75EF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd60)),
	/* U+75F0 */	JISX0208(0xe1e2),
	/* U+75F1 */	IFX0213(JISX0213_2(0xf156),	JISX0212(0xcd61)),
	/* U+75F2 */	JISX0208(0xe1e4),
	/* U+75F3 */	JISX0208(0xe1e5),
	/* U+75F4 */	JISX0208(0xc3d4),
	/* U+75F5 */	U2E_NODEST_COLX,
	/* U+75F6 */	U2E_NODEST_COLX,
	/* U+75F7 */	U2E_NODEST_COLX,
	/* U+75F8 */	U2E_NODEST_COLX,
	/* U+75F9 */	IFX0213(JISX0213_2(0xf157),	JISX0212(0xcd62)),
	/* U+75FA */	JISX0208(0xe1e3),
	/* U+75FB */	U2E_NODEST_COLX,
	/* U+75FC */	JISX0208(0xe1e0),
	/* U+75FD */	U2E_NODEST_COLX,
	/* U+75FE */	JISX0208(0xe1de),
	/* U+75FF */	JISX0208(0xe1df),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_76[] = {
	/* U+7600 */	IFX0213(JISX0213_1(0xf8d0),	JISX0212(0xcd63)),
	/* U+7601 */	JISX0208(0xe1e1),
	/* U+7602 */	IFX0213(JISX0213_1(0xf8d1),	JISX0212(0xcd64)),
	/* U+7603 */	IFX0213(JISX0213_2(0xf158),	JISX0212(0xcd65)),
	/* U+7604 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd66)),
	/* U+7605 */	U2E_NODEST_COLX,
	/* U+7606 */	U2E_NODEST_COLX,
	/* U+7607 */	IFX0213(JISX0213_2(0xf15a),	JISX0212(0xcd67)),
	/* U+7608 */	IFX0213(JISX0213_1(0xf8d2),	JISX0212(0xcd68)),
	/* U+7609 */	JISX0208(0xe1e8),
	/* U+760A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd69)),
	/* U+760B */	JISX0208(0xe1e6),
	/* U+760C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd6a)),
	/* U+760D */	JISX0208(0xe1e7),
	/* U+760E */	U2E_NODEST_COLX,
	/* U+760F */	IFX0213(JISX0213_2(0xf15b),	JISX0212(0xcd6b)),
	/* U+7610 */	U2E_NODEST_COLX,
	/* U+7611 */	U2E_NODEST_COLX,
	/* U+7612 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd6c)),
	/* U+7613 */	IFX0213(JISX0213_2(0xf15e),	JISX0212(0xcd6d)),
	/* U+7614 */	U2E_NODEST_COLX,
	/* U+7615 */	IFX0213(JISX0213_1(0xf8d3),	JISX0212(0xcd6e)),
	/* U+7616 */	IFX0213(JISX0213_1(0xf8d4),	JISX0212(0xcd6f)),
	/* U+7617 */	U2E_NODEST_COLX,
	/* U+7618 */	IFX0213(JISX0213_2(0xf159),	U2E_NODEST_COLX),
	/* U+7619 */	IFX0213(JISX0213_1(0xf8d5),	JISX0212(0xcd70)),
	/* U+761A */	U2E_NODEST_COLX,
	/* U+761B */	IFX0213(JISX0213_2(0xf15f),	JISX0212(0xcd71)),
	/* U+761C */	IFX0213(JISX0213_2(0xf160),	JISX0212(0xcd72)),
	/* U+761D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd73)),
	/* U+761E */	IFX0213(JISX0213_1(0xf8d6),	JISX0212(0xcd74)),
	/* U+761F */	JISX0208(0xe1e9),
	/* U+7620 */	JISX0208(0xe1eb),
	/* U+7621 */	JISX0208(0xe1ec),
	/* U+7622 */	JISX0208(0xe1ed),
	/* U+7623 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd75)),
	/* U+7624 */	JISX0208(0xe1ee),
	/* U+7625 */	IFX0213(JISX0213_2(0xf162),	JISX0212(0xcd76)),
	/* U+7626 */	IFX0213(JISX0213_1(0xfefd),	JISX0212(0xcd77)),
	/* U+7627 */	JISX0208(0xe1ea),
	/* U+7628 */	IFX0213(JISX0213_2(0xf163),	U2E_NODEST_COLX),
	/* U+7629 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd78)),
	/* U+762A */	U2E_NODEST_COLX,
	/* U+762B */	U2E_NODEST_COLX,
	/* U+762C */	U2E_NODEST_COLX,
	/* U+762D */	IFX0213(JISX0213_1(0xf8d7),	JISX0212(0xcd79)),
	/* U+762E */	U2E_NODEST_COLX,
	/* U+762F */	U2E_NODEST_COLX,
	/* U+7630 */	JISX0208(0xe1f0),
	/* U+7631 */	U2E_NODEST_COLX,
	/* U+7632 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd7a)),
	/* U+7633 */	IFX0213(JISX0213_2(0xf165),	JISX0212(0xcd7b)),
	/* U+7634 */	JISX0208(0xe1ef),
	/* U+7635 */	IFX0213(JISX0213_1(0xf8d8),	JISX0212(0xcd7c)),
	/* U+7636 */	U2E_NODEST_COLX,
	/* U+7637 */	U2E_NODEST_COLX,
	/* U+7638 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd7d)),
	/* U+7639 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcd7e)),
	/* U+763A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce21)),
	/* U+763B */	JISX0208(0xe1f1),
	/* U+763C */	IFX0213(JISX0213_2(0xf164),	JISX0212(0xce22)),
	/* U+763D */	U2E_NODEST_COLX,
	/* U+763E */	U2E_NODEST_COLX,
	/* U+763F */	U2E_NODEST_COLX,
	/* U+7640 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce24)),
	/* U+7641 */	IFX0213(JISX0213_2(0xf168),	JISX0212(0xce25)),
	/* U+7642 */	JISX0208(0xcec5),
	/* U+7643 */	IFX0213(JISX0213_1(0xf8d9),	JISX0212(0xce26)),
	/* U+7644 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce27)),
	/* U+7645 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce28)),
	/* U+7646 */	JISX0208(0xe1f4),
	/* U+7647 */	JISX0208(0xe1f2),
	/* U+7648 */	JISX0208(0xe1f3),
	/* U+7649 */	IFX0213(JISX0213_2(0xf16a),	JISX0212(0xce29)),
	/* U+764A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce23)),
	/* U+764B */	IFX0213(JISX0213_1(0xf8da),	JISX0212(0xce2a)),
	/* U+764C */	JISX0208(0xb4e2),
	/* U+764D */	U2E_NODEST_COLX,
	/* U+764E */	U2E_NODEST_COLX,
	/* U+764F */	U2E_NODEST_COLX,
	/* U+7650 */	U2E_NODEST_COLX,
	/* U+7651 */	U2E_NODEST_COLX,
	/* U+7652 */	JISX0208(0xccfe),
	/* U+7653 */	U2E_NODEST_COLX,
	/* U+7654 */	U2E_NODEST_COLX,
	/* U+7655 */	IFX0213(JISX0213_2(0xf16b),	JISX0212(0xce2b)),
	/* U+7656 */	JISX0208(0xcaca),
	/* U+7657 */	U2E_NODEST_COLX,
	/* U+7658 */	JISX0208(0xe1f6),
	/* U+7659 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce2c)),
	/* U+765A */	U2E_NODEST_COLX,
	/* U+765B */	U2E_NODEST_COLX,
	/* U+765C */	JISX0208(0xe1f5),
	/* U+765D */	U2E_NODEST_COLX,
	/* U+765E */	U2E_NODEST_COLX,
	/* U+765F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce2d)),
	/* U+7660 */	U2E_NODEST_COLX,
	/* U+7661 */	JISX0208(0xe1f7),
	/* U+7662 */	JISX0208(0xe1f8),
	/* U+7663 */	U2E_NODEST_COLX,
	/* U+7664 */	IFX0213(JISX0213_1(0xf8db),	JISX0212(0xce2e)),
	/* U+7665 */	IFX0213(JISX0213_1(0xf8dc),	JISX0212(0xce2f)),
	/* U+7666 */	U2E_NODEST_COLX,
	/* U+7667 */	JISX0208(0xe1fc),
	/* U+7668 */	JISX0208(0xe1f9),
	/* U+7669 */	JISX0208(0xe1fa),
	/* U+766A */	JISX0208(0xe1fb),
	/* U+766B */	U2E_NODEST_COLX,
	/* U+766C */	JISX0208(0xe1fd),
	/* U+766D */	IFX0213(JISX0213_1(0xf8dd),	JISX0212(0xce30)),
	/* U+766E */	IFX0213(JISX0213_2(0xf16d),	JISX0212(0xce31)),
	/* U+766F */	IFX0213(JISX0213_1(0xf8de),	JISX0212(0xce32)),
	/* U+7670 */	JISX0208(0xe1fe),
	/* U+7671 */	IFX0213(JISX0213_1(0xf8df),	JISX0212(0xce33)),
	/* U+7672 */	JISX0208(0xe2a1),
	/* U+7673 */	U2E_NODEST_COLX,
	/* U+7674 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce34)),
	/* U+7675 */	U2E_NODEST_COLX,
	/* U+7676 */	JISX0208(0xe2a2),
	/* U+7677 */	U2E_NODEST_COLX,
	/* U+7678 */	JISX0208(0xe2a3),
	/* U+7679 */	U2E_NODEST_COLX,
	/* U+767A */	JISX0208(0xc8af),
	/* U+767B */	JISX0208(0xc5d0),
	/* U+767C */	JISX0208(0xe2a4),
	/* U+767D */	JISX0208(0xc7f2),
	/* U+767E */	JISX0208(0xc9b4),
	/* U+767F */	U2E_NODEST_COLX,
	/* U+7680 */	JISX0208(0xe2a5),
	/* U+7681 */	IFX0213(JISX0213_1(0xf8e0),	JISX0212(0xce35)),
	/* U+7682 */	IFX0213(U2E_NODEST_COLX,	IBM(0xf451)),
	/* U+7683 */	JISX0208(0xe2a6),
	/* U+7684 */	JISX0208(0xc5aa),
	/* U+7685 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce36)),
	/* U+7686 */	JISX0208(0xb3a7),
	/* U+7687 */	JISX0208(0xb9c4),
	/* U+7688 */	JISX0208(0xe2a7),
	/* U+7689 */	U2E_NODEST_COLX,
	/* U+768A */	U2E_NODEST_COLX,
	/* U+768B */	JISX0208(0xe2a8),
	/* U+768C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce37)),
	/* U+768D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce38)),
	/* U+768E */	JISX0208(0xe2a9),
	/* U+768F */	U2E_NODEST_COLX,
	/* U+7690 */	JISX0208(0xbba9),
	/* U+7691 */	U2E_NODEST_COLX,
	/* U+7692 */	U2E_NODEST_COLX,
	/* U+7693 */	JISX0208(0xe2ab),
	/* U+7694 */	U2E_NODEST_COLX,
	/* U+7695 */	IFX0213(JISX0213_2(0xf16e),	JISX0212(0xce39)),
	/* U+7696 */	JISX0208(0xe2aa),
	/* U+7697 */	U2E_NODEST_COLX,
	/* U+7698 */	U2E_NODEST_COLX,
	/* U+7699 */	JISX0208(0xe2ac),
	/* U+769A */	JISX0208(0xe2ad),
	/* U+769B */	IFX0213(JISX0213_1(0xf8e1),	JISX0212(0xce3a)),
	/* U+769C */	IFX0213(JISX0213_2(0xf16f),	JISX0212(0xce3b)),
	/* U+769D */	IFX0213(JISX0213_1(0xf8e2),	JISX0212(0xce3c)),
	/* U+769E */	IFX0213(JISX0213_1(0xf8e3),	IBM(0xf452)),
	/* U+769F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce3d)),
	/* U+76A0 */	IFX0213(JISX0213_2(0xf171),	JISX0212(0xce3e)),
	/* U+76A1 */	IFX0213(JISX0213_2(0xf170),	U2E_NODEST_COLX),
	/* U+76A2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce3f)),
	/* U+76A3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce40)),
	/* U+76A4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce41)),
	/* U+76A5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce42)),
	/* U+76A6 */	IFX0213(JISX0213_1(0xf8e4),	JISX0212(0xce43)),
	/* U+76A7 */	IFX0213(JISX0213_2(0xf172),	JISX0212(0xce44)),
	/* U+76A8 */	IFX0213(JISX0213_2(0xf173),	JISX0212(0xce45)),
	/* U+76A9 */	U2E_NODEST_COLX,
	/* U+76AA */	IFX0213(JISX0213_1(0xf8e5),	JISX0212(0xce46)),
	/* U+76AB */	U2E_NODEST_COLX,
	/* U+76AC */	U2E_NODEST_COLX,
	/* U+76AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce47)),
	/* U+76AE */	JISX0208(0xc8e9),
	/* U+76AF */	IFX0213(JISX0213_2(0xf174),	U2E_NODEST_COLX),
	/* U+76B0 */	JISX0208(0xe2ae),
	/* U+76B1 */	U2E_NODEST_COLX,
	/* U+76B2 */	U2E_NODEST_COLX,
	/* U+76B3 */	U2E_NODEST_COLX,
	/* U+76B4 */	JISX0208(0xe2af),
	/* U+76B5 */	U2E_NODEST_COLX,
	/* U+76B6 */	IFX0213(JISX0213_1(0xf8e6),	U2E_NODEST_COLX),
	/* U+76B7 */	JISX0208(0xf3e9),
	/* U+76B8 */	JISX0208(0xe2b0),
	/* U+76B9 */	JISX0208(0xe2b1),
	/* U+76BA */	JISX0208(0xe2b2),
	/* U+76BB */	U2E_NODEST_COLX,
	/* U+76BC */	U2E_NODEST_COLX,
	/* U+76BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce48)),
	/* U+76BE */	U2E_NODEST_COLX,
	/* U+76BF */	JISX0208(0xbbae),
	/* U+76C0 */	U2E_NODEST_COLX,
	/* U+76C1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce49)),
	/* U+76C2 */	JISX0208(0xe2b3),
	/* U+76C3 */	JISX0208(0xc7d6),
	/* U+76C4 */	U2E_NODEST_COLX,
	/* U+76C5 */	IFX0213(JISX0213_1(0xf8e7),	JISX0212(0xce4a)),
	/* U+76C6 */	JISX0208(0xcbdf),
	/* U+76C7 */	U2E_NODEST_COLX,
	/* U+76C8 */	JISX0208(0xb1ce),
	/* U+76C9 */	IFX0213(JISX0213_2(0xf176),	JISX0212(0xce4b)),
	/* U+76CA */	JISX0208(0xb1d7),
	/* U+76CB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce4c)),
	/* U+76CC */	IFX0213(JISX0213_1(0xf8e8),	JISX0212(0xce4d)),
	/* U+76CD */	JISX0208(0xe2b4),
	/* U+76CE */	IFX0213(JISX0213_1(0xf8e9),	JISX0212(0xce4e)),
	/* U+76CF */	U2E_NODEST_COLX,
	/* U+76D0 */	U2E_NODEST_COLX,
	/* U+76D1 */	U2E_NODEST_COLX,
	/* U+76D2 */	JISX0208(0xe2b6),
	/* U+76D3 */	U2E_NODEST_COLX,
	/* U+76D4 */	IFX0213(JISX0213_1(0xf8ea),	JISX0212(0xce4f)),
	/* U+76D5 */	U2E_NODEST_COLX,
	/* U+76D6 */	JISX0208(0xe2b5),
	/* U+76D7 */	JISX0208(0xc5f0),
	/* U+76D8 */	U2E_NODEST_COLX,
	/* U+76D9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce50)),
	/* U+76DA */	U2E_NODEST_COLX,
	/* U+76DB */	JISX0208(0xc0b9),
	/* U+76DC */	JISX0208(0xddb9),
	/* U+76DD */	U2E_NODEST_COLX,
	/* U+76DE */	JISX0208(0xe2b7),
	/* U+76DF */	JISX0208(0xccc1),
	/* U+76E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce51)),
	/* U+76E1 */	JISX0208(0xe2b8),
	/* U+76E2 */	U2E_NODEST_COLX,
	/* U+76E3 */	JISX0208(0xb4c6),
	/* U+76E4 */	JISX0208(0xc8d7),
	/* U+76E5 */	JISX0208(0xe2b9),
	/* U+76E6 */	IFX0213(JISX0213_1(0xf8eb),	JISX0212(0xce52)),
	/* U+76E7 */	JISX0208(0xe2ba),
	/* U+76E8 */	IFX0213(JISX0213_2(0xf178),	JISX0212(0xce53)),
	/* U+76E9 */	U2E_NODEST_COLX,
	/* U+76EA */	JISX0208(0xe2bb),
	/* U+76EB */	U2E_NODEST_COLX,
	/* U+76EC */	IFX0213(JISX0213_2(0xf179),	JISX0212(0xce54)),
	/* U+76ED */	U2E_NODEST_COLX,
	/* U+76EE */	JISX0208(0xccdc),
	/* U+76EF */	U2E_NODEST_COLX,
	/* U+76F0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce55)),
	/* U+76F1 */	IFX0213(JISX0213_1(0xf8ec),	JISX0212(0xce56)),
	/* U+76F2 */	JISX0208(0xccd5),
	/* U+76F3 */	U2E_NODEST_COLX,
	/* U+76F4 */	JISX0208(0xc4be),
	/* U+76F5 */	U2E_NODEST_COLX,
	/* U+76F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce57)),
	/* U+76F7 */	U2E_NODEST_COLX,
	/* U+76F8 */	JISX0208(0xc1ea),
	/* U+76F9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce58)),
	/* U+76FA */	U2E_NODEST_COLX,
	/* U+76FB */	JISX0208(0xe2bd),
	/* U+76FC */	IFX0213(JISX0213_1(0xf8ed),	JISX0212(0xce59)),
	/* U+76FD */	U2E_NODEST_COLX,
	/* U+76FE */	JISX0208(0xbde2),
	/* U+76FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_77[] = {
	/* U+7700 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce5a)),
	/* U+7701 */	JISX0208(0xbeca),
	/* U+7702 */	U2E_NODEST_COLX,
	/* U+7703 */	U2E_NODEST_COLX,
	/* U+7704 */	JISX0208(0xe2c0),
	/* U+7705 */	U2E_NODEST_COLX,
	/* U+7706 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce5b)),
	/* U+7707 */	JISX0208(0xe2bf),
	/* U+7708 */	JISX0208(0xe2be),
	/* U+7709 */	JISX0208(0xc8fd),
	/* U+770A */	IFX0213(JISX0213_1(0xf8ee),	JISX0212(0xce5c)),
	/* U+770B */	JISX0208(0xb4c7),
	/* U+770C */	JISX0208(0xb8a9),
	/* U+770D */	U2E_NODEST_COLX,
	/* U+770E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce5d)),
	/* U+770F */	U2E_NODEST_COLX,
	/* U+7710 */	U2E_NODEST_COLX,
	/* U+7711 */	U2E_NODEST_COLX,
	/* U+7712 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce5e)),
	/* U+7713 */	U2E_NODEST_COLX,
	/* U+7714 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce5f)),
	/* U+7715 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce60)),
	/* U+7716 */	U2E_NODEST_COLX,
	/* U+7717 */	IFX0213(JISX0213_2(0xf17b),	JISX0212(0xce61)),
	/* U+7718 */	U2E_NODEST_COLX,
	/* U+7719 */	IFX0213(JISX0213_1(0xf8ef),	JISX0212(0xce62)),
	/* U+771A */	IFX0213(JISX0213_2(0xf17c),	JISX0212(0xce63)),
	/* U+771B */	JISX0208(0xe2c6),
	/* U+771C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce64)),
	/* U+771D */	U2E_NODEST_COLX,
	/* U+771E */	JISX0208(0xe2c3),
	/* U+771F */	JISX0208(0xbfbf),
	/* U+7720 */	JISX0208(0xccb2),
	/* U+7721 */	U2E_NODEST_COLX,
	/* U+7722 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce65)),
	/* U+7723 */	U2E_NODEST_COLX,
	/* U+7724 */	JISX0208(0xe2c2),
	/* U+7725 */	JISX0208(0xe2c4),
	/* U+7726 */	JISX0208(0xe2c5),
	/* U+7727 */	U2E_NODEST_COLX,
	/* U+7728 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce66)),
	/* U+7729 */	JISX0208(0xe2c1),
	/* U+772A */	U2E_NODEST_COLX,
	/* U+772B */	U2E_NODEST_COLX,
	/* U+772C */	U2E_NODEST_COLX,
	/* U+772D */	IFX0213(JISX0213_2(0xf17d),	JISX0212(0xce67)),
	/* U+772E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce68)),
	/* U+772F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce69)),
	/* U+7730 */	U2E_NODEST_COLX,
	/* U+7731 */	U2E_NODEST_COLX,
	/* U+7732 */	U2E_NODEST_COLX,
	/* U+7733 */	U2E_NODEST_COLX,
	/* U+7734 */	IFX0213(JISX0213_1(0xf8f0),	JISX0212(0xce6a)),
	/* U+7735 */	IFX0213(JISX0213_2(0xf17e),	JISX0212(0xce6b)),
	/* U+7736 */	IFX0213(JISX0213_1(0xf8f1),	JISX0212(0xce6c)),
	/* U+7737 */	JISX0208(0xe2c7),
	/* U+7738 */	JISX0208(0xe2c8),
	/* U+7739 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce6d)),
	/* U+773A */	JISX0208(0xc4af),
	/* U+773B */	U2E_NODEST_COLX,
	/* U+773C */	JISX0208(0xb4e3),
	/* U+773D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce6e)),
	/* U+773E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce6f)),
	/* U+773F */	U2E_NODEST_COLX,
	/* U+7740 */	JISX0208(0xc3e5),
	/* U+7741 */	U2E_NODEST_COLX,
	/* U+7742 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce70)),
	/* U+7743 */	U2E_NODEST_COLX,
	/* U+7744 */	U2E_NODEST_COLX,
	/* U+7745 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce71)),
	/* U+7746 */	IFX0213(JISX0213_1(0xf8f2),	JISX0212(0xce72)),
	/* U+7747 */	JISX0208(0xe2c9),
	/* U+7748 */	U2E_NODEST_COLX,
	/* U+7749 */	U2E_NODEST_COLX,
	/* U+774A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce73)),
	/* U+774B */	U2E_NODEST_COLX,
	/* U+774C */	U2E_NODEST_COLX,
	/* U+774D */	IFX0213(JISX0213_1(0xf8f3),	JISX0212(0xce74)),
	/* U+774E */	IFX0213(JISX0213_1(0xf8f4),	JISX0212(0xce75)),
	/* U+774F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce76)),
	/* U+7750 */	U2E_NODEST_COLX,
	/* U+7751 */	U2E_NODEST_COLX,
	/* U+7752 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce77)),
	/* U+7753 */	U2E_NODEST_COLX,
	/* U+7754 */	U2E_NODEST_COLX,
	/* U+7755 */	U2E_NODEST_COLX,
	/* U+7756 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce78)),
	/* U+7757 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce79)),
	/* U+7758 */	IFX0213(JISX0213_2(0xf225),	U2E_NODEST_COLX),
	/* U+7759 */	U2E_NODEST_COLX,
	/* U+775A */	JISX0208(0xe2ca),
	/* U+775B */	JISX0208(0xe2cd),
	/* U+775C */	IFX0213(JISX0213_1(0xf8f5),	JISX0212(0xce7a)),
	/* U+775D */	U2E_NODEST_COLX,
	/* U+775E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xce7b)),
	/* U+775F */	IFX0213(JISX0213_1(0xf8f6),	JISX0212(0xce7c)),
	/* U+7760 */	IFX0213(JISX0213_2(0xf226),	JISX0212(0xce7d)),
	/* U+7761 */	JISX0208(0xbfe7),
	/* U+7762 */	IFX0213(JISX0213_1(0xf8f7),	JISX0212(0xce7e)),
	/* U+7763 */	JISX0208(0xc6c4),
	/* U+7764 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf21)),
	/* U+7765 */	JISX0208(0xe2ce),
	/* U+7766 */	JISX0208(0xcbd3),
	/* U+7767 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf22)),
	/* U+7768 */	JISX0208(0xe2cb),
	/* U+7769 */	U2E_NODEST_COLX,
	/* U+776A */	IFX0213(JISX0213_2(0xf227),	JISX0212(0xcf23)),
	/* U+776B */	JISX0208(0xe2cc),
	/* U+776C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf24)),
	/* U+776D */	U2E_NODEST_COLX,
	/* U+776E */	U2E_NODEST_COLX,
	/* U+776F */	U2E_NODEST_COLX,
	/* U+7770 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf25)),
	/* U+7771 */	U2E_NODEST_COLX,
	/* U+7772 */	IFX0213(JISX0213_2(0xf229),	JISX0212(0xcf26)),
	/* U+7773 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf27)),
	/* U+7774 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf28)),
	/* U+7775 */	U2E_NODEST_COLX,
	/* U+7776 */	U2E_NODEST_COLX,
	/* U+7777 */	U2E_NODEST_COLX,
	/* U+7778 */	U2E_NODEST_COLX,
	/* U+7779 */	JISX0208(0xe2d1),
	/* U+777A */	IFX0213(JISX0213_1(0xf8f8),	JISX0212(0xcf29)),
	/* U+777B */	U2E_NODEST_COLX,
	/* U+777C */	IFX0213(JISX0213_2(0xf22a),	U2E_NODEST_COLX),
	/* U+777D */	IFX0213(JISX0213_2(0xf22b),	JISX0212(0xcf2a)),
	/* U+777E */	JISX0208(0xe2d0),
	/* U+777F */	JISX0208(0xe2cf),
	/* U+7780 */	IFX0213(JISX0213_1(0xf8f9),	JISX0212(0xcf2b)),
	/* U+7781 */	U2E_NODEST_COLX,
	/* U+7782 */	U2E_NODEST_COLX,
	/* U+7783 */	U2E_NODEST_COLX,
	/* U+7784 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf2c)),
	/* U+7785 */	U2E_NODEST_COLX,
	/* U+7786 */	U2E_NODEST_COLX,
	/* U+7787 */	U2E_NODEST_COLX,
	/* U+7788 */	U2E_NODEST_COLX,
	/* U+7789 */	U2E_NODEST_COLX,
	/* U+778A */	U2E_NODEST_COLX,
	/* U+778B */	JISX0208(0xe2d3),
	/* U+778C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf2d)),
	/* U+778D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf2e)),
	/* U+778E */	JISX0208(0xe2d2),
	/* U+778F */	U2E_NODEST_COLX,
	/* U+7790 */	U2E_NODEST_COLX,
	/* U+7791 */	JISX0208(0xe2d4),
	/* U+7792 */	U2E_NODEST_COLX,
	/* U+7793 */	U2E_NODEST_COLX,
	/* U+7794 */	IFX0213(JISX0213_1(0xf8fa),	JISX0212(0xcf2f)),
	/* U+7795 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf30)),
	/* U+7796 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf31)),
	/* U+7797 */	U2E_NODEST_COLX,
	/* U+7798 */	U2E_NODEST_COLX,
	/* U+7799 */	U2E_NODEST_COLX,
	/* U+779A */	IFX0213(JISX0213_2(0xf22e),	JISX0212(0xcf32)),
	/* U+779B */	U2E_NODEST_COLX,
	/* U+779C */	U2E_NODEST_COLX,
	/* U+779D */	U2E_NODEST_COLX,
	/* U+779E */	JISX0208(0xe2d6),
	/* U+779F */	IFX0213(JISX0213_2(0xf22f),	JISX0212(0xcf33)),
	/* U+77A0 */	JISX0208(0xe2d5),
	/* U+77A1 */	U2E_NODEST_COLX,
	/* U+77A2 */	IFX0213(JISX0213_2(0xf230),	JISX0212(0xcf34)),
	/* U+77A3 */	U2E_NODEST_COLX,
	/* U+77A4 */	IFX0213(JISX0213_2(0xf231),	U2E_NODEST_COLX),
	/* U+77A5 */	JISX0208(0xcacd),
	/* U+77A6 */	U2E_NODEST_COLX,
	/* U+77A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf35)),
	/* U+77A8 */	U2E_NODEST_COLX,
	/* U+77A9 */	IFX0213(JISX0213_2(0xf232),	U2E_NODEST_COLX),
	/* U+77AA */	IFX0213(JISX0213_1(0xf8fb),	JISX0212(0xcf36)),
	/* U+77AB */	U2E_NODEST_COLX,
	/* U+77AC */	JISX0208(0xbdd6),
	/* U+77AD */	JISX0208(0xcec6),
	/* U+77AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf37)),
	/* U+77AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf38)),
	/* U+77B0 */	JISX0208(0xe2d7),
	/* U+77B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf39)),
	/* U+77B2 */	U2E_NODEST_COLX,
	/* U+77B3 */	JISX0208(0xc6b7),
	/* U+77B4 */	U2E_NODEST_COLX,
	/* U+77B5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf3a)),
	/* U+77B6 */	JISX0208(0xe2d8),
	/* U+77B7 */	U2E_NODEST_COLX,
	/* U+77B8 */	U2E_NODEST_COLX,
	/* U+77B9 */	JISX0208(0xe2d9),
	/* U+77BA */	U2E_NODEST_COLX,
	/* U+77BB */	JISX0208(0xe2dd),
	/* U+77BC */	JISX0208(0xe2db),
	/* U+77BD */	JISX0208(0xe2dc),
	/* U+77BE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf3b)),
	/* U+77BF */	JISX0208(0xe2da),
	/* U+77C0 */	U2E_NODEST_COLX,
	/* U+77C1 */	U2E_NODEST_COLX,
	/* U+77C2 */	U2E_NODEST_COLX,
	/* U+77C3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf3c)),
	/* U+77C4 */	U2E_NODEST_COLX,
	/* U+77C5 */	U2E_NODEST_COLX,
	/* U+77C6 */	U2E_NODEST_COLX,
	/* U+77C7 */	JISX0208(0xe2de),
	/* U+77C8 */	U2E_NODEST_COLX,
	/* U+77C9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf3d)),
	/* U+77CA */	U2E_NODEST_COLX,
	/* U+77CB */	U2E_NODEST_COLX,
	/* U+77CC */	U2E_NODEST_COLX,
	/* U+77CD */	JISX0208(0xe2df),
	/* U+77CE */	U2E_NODEST_COLX,
	/* U+77CF */	U2E_NODEST_COLX,
	/* U+77D0 */	U2E_NODEST_COLX,
	/* U+77D1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf3e)),
	/* U+77D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf3f)),
	/* U+77D3 */	U2E_NODEST_COLX,
	/* U+77D4 */	U2E_NODEST_COLX,
	/* U+77D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf40)),
	/* U+77D6 */	U2E_NODEST_COLX,
	/* U+77D7 */	JISX0208(0xe2e0),
	/* U+77D8 */	U2E_NODEST_COLX,
	/* U+77D9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf41)),
	/* U+77DA */	JISX0208(0xe2e1),
	/* U+77DB */	JISX0208(0xccb7),
	/* U+77DC */	JISX0208(0xe2e2),
	/* U+77DD */	U2E_NODEST_COLX,
	/* U+77DE */	IFX0213(JISX0213_2(0xf233),	JISX0212(0xcf42)),
	/* U+77DF */	IFX0213(JISX0213_2(0xf234),	JISX0212(0xcf43)),
	/* U+77E0 */	IFX0213(JISX0213_1(0xf8fc),	JISX0212(0xcf44)),
	/* U+77E1 */	U2E_NODEST_COLX,
	/* U+77E2 */	JISX0208(0xccf0),
	/* U+77E3 */	JISX0208(0xe2e3),
	/* U+77E4 */	IFX0213(JISX0213_2(0xf235),	JISX0212(0xcf45)),
	/* U+77E5 */	JISX0208(0xc3ce),
	/* U+77E6 */	IFX0213(JISX0213_2(0xf236),	JISX0212(0xcf46)),
	/* U+77E7 */	JISX0208(0xc7ea),
	/* U+77E8 */	U2E_NODEST_COLX,
	/* U+77E9 */	JISX0208(0xb6eb),
	/* U+77EA */	IFX0213(JISX0213_2(0xf237),	JISX0212(0xcf47)),
	/* U+77EB */	U2E_NODEST_COLX,
	/* U+77EC */	IFX0213(JISX0213_2(0xf238),	JISX0212(0xcf48)),
	/* U+77ED */	JISX0208(0xc3bb),
	/* U+77EE */	JISX0208(0xe2e4),
	/* U+77EF */	JISX0208(0xb6ba),
	/* U+77F0 */	IFX0213(JISX0213_2(0xf23a),	JISX0212(0xcf49)),
	/* U+77F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf4a)),
	/* U+77F2 */	U2E_NODEST_COLX,
	/* U+77F3 */	JISX0208(0xc0d0),
	/* U+77F4 */	IFX0213(JISX0213_2(0xf23b),	JISX0212(0xcf4b)),
	/* U+77F5 */	U2E_NODEST_COLX,
	/* U+77F6 */	U2E_NODEST_COLX,
	/* U+77F7 */	U2E_NODEST_COLX,
	/* U+77F8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf4c)),
	/* U+77F9 */	U2E_NODEST_COLX,
	/* U+77FA */	U2E_NODEST_COLX,
	/* U+77FB */	IFX0213(JISX0213_2(0xf23c),	JISX0212(0xcf4d)),
	/* U+77FC */	JISX0208(0xe2e5),
	/* U+77FD */	U2E_NODEST_COLX,
	/* U+77FE */	U2E_NODEST_COLX,
	/* U+77FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_78[] = {
	/* U+7800 */	U2E_NODEST_COLX,
	/* U+7801 */	U2E_NODEST_COLX,
	/* U+7802 */	JISX0208(0xbabd),
	/* U+7803 */	U2E_NODEST_COLX,
	/* U+7804 */	U2E_NODEST_COLX,
	/* U+7805 */	IFX0213(JISX0213_2(0xf23e),	JISX0212(0xcf4e)),
	/* U+7806 */	IFX0213(JISX0213_2(0xf23f),	JISX0212(0xcf4f)),
	/* U+7807 */	U2E_NODEST_COLX,
	/* U+7808 */	U2E_NODEST_COLX,
	/* U+7809 */	IFX0213(JISX0213_2(0xf240),	JISX0212(0xcf50)),
	/* U+780A */	U2E_NODEST_COLX,
	/* U+780B */	U2E_NODEST_COLX,
	/* U+780C */	JISX0208(0xe2e6),
	/* U+780D */	IFX0213(JISX0213_2(0xf241),	JISX0212(0xcf51)),
	/* U+780E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf52)),
	/* U+780F */	U2E_NODEST_COLX,
	/* U+7810 */	U2E_NODEST_COLX,
	/* U+7811 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf53)),
	/* U+7812 */	JISX0208(0xe2e7),
	/* U+7813 */	U2E_NODEST_COLX,
	/* U+7814 */	JISX0208(0xb8a6),
	/* U+7815 */	JISX0208(0xbad5),
	/* U+7816 */	U2E_NODEST_COLX,
	/* U+7817 */	U2E_NODEST_COLX,
	/* U+7818 */	U2E_NODEST_COLX,
	/* U+7819 */	IFX0213(JISX0213_2(0xf242),	U2E_NODEST_COLX),
	/* U+781A */	U2E_NODEST_COLX,
	/* U+781B */	U2E_NODEST_COLX,
	/* U+781C */	U2E_NODEST_COLX,
	/* U+781D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf54)),
	/* U+781E */	U2E_NODEST_COLX,
	/* U+781F */	U2E_NODEST_COLX,
	/* U+7820 */	JISX0208(0xe2e9),
	/* U+7821 */	IFX0213(JISX0213_2(0xf243),	JISX0212(0xcf55)),
	/* U+7822 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf56)),
	/* U+7823 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf57)),
	/* U+7824 */	U2E_NODEST_COLX,
	/* U+7825 */	JISX0208(0xc5d6),
	/* U+7826 */	JISX0208(0xbad6),
	/* U+7827 */	JISX0208(0xb5ce),
	/* U+7828 */	U2E_NODEST_COLX,
	/* U+7829 */	U2E_NODEST_COLX,
	/* U+782A */	U2E_NODEST_COLX,
	/* U+782B */	U2E_NODEST_COLX,
	/* U+782C */	IFX0213(JISX0213_2(0xf244),	U2E_NODEST_COLX),
	/* U+782D */	IFX0213(JISX0213_1(0xf8fd),	JISX0212(0xcf58)),
	/* U+782E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf59)),
	/* U+782F */	U2E_NODEST_COLX,
	/* U+7830 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf5a)),
	/* U+7831 */	U2E_NODEST_COLX,
	/* U+7832 */	JISX0208(0xcba4),
	/* U+7833 */	U2E_NODEST_COLX,
	/* U+7834 */	JISX0208(0xc7cb),
	/* U+7835 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf5b)),
	/* U+7836 */	U2E_NODEST_COLX,
	/* U+7837 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf5c)),
	/* U+7838 */	U2E_NODEST_COLX,
	/* U+7839 */	U2E_NODEST_COLX,
	/* U+783A */	JISX0208(0xc5d7),
	/* U+783B */	U2E_NODEST_COLX,
	/* U+783C */	U2E_NODEST_COLX,
	/* U+783D */	U2E_NODEST_COLX,
	/* U+783E */	U2E_NODEST_COLX,
	/* U+783F */	JISX0208(0xb9dc),
	/* U+7840 */	U2E_NODEST_COLX,
	/* U+7841 */	U2E_NODEST_COLX,
	/* U+7842 */	U2E_NODEST_COLX,
	/* U+7843 */	IFX0213(JISX0213_1(0xf9a1),	JISX0212(0xcf5d)),
	/* U+7844 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf5e)),
	/* U+7845 */	JISX0208(0xe2eb),
	/* U+7846 */	U2E_NODEST_COLX,
	/* U+7847 */	IFX0213(JISX0213_2(0xf245),	JISX0212(0xcf5f)),
	/* U+7848 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf60)),
	/* U+7849 */	U2E_NODEST_COLX,
	/* U+784A */	U2E_NODEST_COLX,
	/* U+784B */	U2E_NODEST_COLX,
	/* U+784C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf61)),
	/* U+784D */	U2E_NODEST_COLX,
	/* U+784E */	IFX0213(JISX0213_1(0xf9a2),	JISX0212(0xcf62)),
	/* U+784F */	IFX0213(JISX0213_1(0xf9a3),	U2E_NODEST_COLX),
	/* U+7850 */	U2E_NODEST_COLX,
	/* U+7851 */	IFX0213(JISX0213_1(0xf9a4),	U2E_NODEST_COLX),
	/* U+7852 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf63)),
	/* U+7853 */	U2E_NODEST_COLX,
	/* U+7854 */	U2E_NODEST_COLX,
	/* U+7855 */	U2E_NODEST_COLX,
	/* U+7856 */	U2E_NODEST_COLX,
	/* U+7857 */	U2E_NODEST_COLX,
	/* U+7858 */	U2E_NODEST_COLX,
	/* U+7859 */	U2E_NODEST_COLX,
	/* U+785A */	U2E_NODEST_COLX,
	/* U+785B */	U2E_NODEST_COLX,
	/* U+785C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf64)),
	/* U+785D */	JISX0208(0xbecb),
	/* U+785E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf65)),
	/* U+785F */	U2E_NODEST_COLX,
	/* U+7860 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf66)),
	/* U+7861 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf67)),
	/* U+7862 */	U2E_NODEST_COLX,
	/* U+7863 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf68)),
	/* U+7864 */	IFX0213(JISX0213_2(0xf246),	JISX0212(0xcf69)),
	/* U+7865 */	U2E_NODEST_COLX,
	/* U+7866 */	U2E_NODEST_COLX,
	/* U+7867 */	U2E_NODEST_COLX,
	/* U+7868 */	IFX0213(JISX0213_1(0xf9a5),	JISX0212(0xcf6a)),
	/* U+7869 */	U2E_NODEST_COLX,
	/* U+786A */	IFX0213(JISX0213_2(0xf247),	JISX0212(0xcf6b)),
	/* U+786B */	JISX0208(0xceb2),
	/* U+786C */	JISX0208(0xb9c5),
	/* U+786D */	U2E_NODEST_COLX,
	/* U+786E */	IFX0213(JISX0213_1(0xf9a6),	JISX0212(0xcf6c)),
	/* U+786F */	JISX0208(0xb8a7),
	/* U+7870 */	U2E_NODEST_COLX,
	/* U+7871 */	U2E_NODEST_COLX,
	/* U+7872 */	JISX0208(0xc8a3),
	/* U+7873 */	U2E_NODEST_COLX,
	/* U+7874 */	JISX0208(0xe2ed),
	/* U+7875 */	U2E_NODEST_COLX,
	/* U+7876 */	U2E_NODEST_COLX,
	/* U+7877 */	U2E_NODEST_COLX,
	/* U+7878 */	U2E_NODEST_COLX,
	/* U+7879 */	U2E_NODEST_COLX,
	/* U+787A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf6d)),
	/* U+787B */	U2E_NODEST_COLX,
	/* U+787C */	JISX0208(0xe2ef),
	/* U+787D */	U2E_NODEST_COLX,
	/* U+787E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf6e)),
	/* U+787F */	U2E_NODEST_COLX,
	/* U+7880 */	U2E_NODEST_COLX,
	/* U+7881 */	JISX0208(0xb8eb),
	/* U+7882 */	U2E_NODEST_COLX,
	/* U+7883 */	U2E_NODEST_COLX,
	/* U+7884 */	U2E_NODEST_COLX,
	/* U+7885 */	U2E_NODEST_COLX,
	/* U+7886 */	JISX0208(0xe2ee),
	/* U+7887 */	JISX0208(0xc4f6),
	/* U+7888 */	U2E_NODEST_COLX,
	/* U+7889 */	U2E_NODEST_COLX,
	/* U+788A */	IFX0213(JISX0213_2(0xf249),	JISX0212(0xcf6f)),
	/* U+788B */	U2E_NODEST_COLX,
	/* U+788C */	JISX0208(0xe2f1),
	/* U+788D */	JISX0208(0xb3b7),
	/* U+788E */	JISX0208(0xe2ec),
	/* U+788F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf70)),
	/* U+7890 */	U2E_NODEST_COLX,
	/* U+7891 */	JISX0208(0xc8ea),
	/* U+7892 */	U2E_NODEST_COLX,
	/* U+7893 */	JISX0208(0xb1b0),
	/* U+7894 */	IFX0213(JISX0213_2(0xf24a),	JISX0212(0xcf71)),
	/* U+7895 */	JISX0208(0xbaec),
	/* U+7896 */	U2E_NODEST_COLX,
	/* U+7897 */	JISX0208(0xcfd2),
	/* U+7898 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf72)),
	/* U+7899 */	U2E_NODEST_COLX,
	/* U+789A */	JISX0208(0xe2f0),
	/* U+789B */	U2E_NODEST_COLX,
	/* U+789C */	U2E_NODEST_COLX,
	/* U+789D */	IFX0213(JISX0213_2(0xf24c),	JISX0212(0xcf74)),
	/* U+789E */	IFX0213(JISX0213_2(0xf24d),	JISX0212(0xcf75)),
	/* U+789F */	IFX0213(JISX0213_2(0xf24e),	JISX0212(0xcf76)),
	/* U+78A0 */	U2E_NODEST_COLX,
	/* U+78A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf73)),
	/* U+78A2 */	U2E_NODEST_COLX,
	/* U+78A3 */	JISX0208(0xe2f2),
	/* U+78A4 */	IFX0213(JISX0213_2(0xf24b),	JISX0212(0xcf77)),
	/* U+78A5 */	U2E_NODEST_COLX,
	/* U+78A6 */	U2E_NODEST_COLX,
	/* U+78A7 */	JISX0208(0xcacb),
	/* U+78A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf78)),
	/* U+78A9 */	JISX0208(0xc0d9),
	/* U+78AA */	JISX0208(0xe2f4),
	/* U+78AB */	U2E_NODEST_COLX,
	/* U+78AC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf79)),
	/* U+78AD */	IFX0213(JISX0213_1(0xf9aa),	JISX0212(0xcf7a)),
	/* U+78AE */	U2E_NODEST_COLX,
	/* U+78AF */	JISX0208(0xe2f5),
	/* U+78B0 */	IFX0213(JISX0213_1(0xf9a8),	JISX0212(0xcf7b)),
	/* U+78B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf7c)),
	/* U+78B2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf7d)),
	/* U+78B3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xcf7e)),
	/* U+78B4 */	U2E_NODEST_COLX,
	/* U+78B5 */	JISX0208(0xe2f3),
	/* U+78B6 */	U2E_NODEST_COLX,
	/* U+78B7 */	U2E_NODEST_COLX,
	/* U+78B8 */	U2E_NODEST_COLX,
	/* U+78B9 */	U2E_NODEST_COLX,
	/* U+78BA */	JISX0208(0xb3ce),
	/* U+78BB */	IFX0213(JISX0213_2(0xf24f),	JISX0212(0xd021)),
	/* U+78BC */	JISX0208(0xe2fb),
	/* U+78BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd022)),
	/* U+78BE */	JISX0208(0xe2fa),
	/* U+78BF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd023)),
	/* U+78C0 */	U2E_NODEST_COLX,
	/* U+78C1 */	JISX0208(0xbca7),
	/* U+78C2 */	U2E_NODEST_COLX,
	/* U+78C3 */	U2E_NODEST_COLX,
	/* U+78C4 */	U2E_NODEST_COLX,
	/* U+78C5 */	JISX0208(0xe2fc),
	/* U+78C6 */	JISX0208(0xe2f7),
	/* U+78C7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd024)),
	/* U+78C8 */	IFX0213(JISX0213_2(0xf250),	JISX0212(0xd025)),
	/* U+78C9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd026)),
	/* U+78CA */	JISX0208(0xe2fd),
	/* U+78CB */	JISX0208(0xe2f8),
	/* U+78CC */	IFX0213(JISX0213_2(0xf251),	JISX0212(0xd027)),
	/* U+78CD */	U2E_NODEST_COLX,
	/* U+78CE */	IFX0213(JISX0213_2(0xf252),	JISX0212(0xd028)),
	/* U+78CF */	U2E_NODEST_COLX,
	/* U+78D0 */	JISX0208(0xc8d8),
	/* U+78D1 */	JISX0208(0xe2f6),
	/* U+78D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd029)),
	/* U+78D3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd02a)),
	/* U+78D4 */	JISX0208(0xe2f9),
	/* U+78D5 */	IFX0213(JISX0213_2(0xf253),	JISX0212(0xd02b)),
	/* U+78D6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd02c)),
	/* U+78D7 */	U2E_NODEST_COLX,
	/* U+78D8 */	U2E_NODEST_COLX,
	/* U+78D9 */	U2E_NODEST_COLX,
	/* U+78DA */	JISX0208(0xe3a2),
	/* U+78DB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd02e)),
	/* U+78DC */	U2E_NODEST_COLX,
	/* U+78DD */	U2E_NODEST_COLX,
	/* U+78DE */	U2E_NODEST_COLX,
	/* U+78DF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd02f)),
	/* U+78E0 */	IFX0213(JISX0213_2(0xf254),	JISX0212(0xd030)),
	/* U+78E1 */	IFX0213(JISX0213_2(0xf255),	JISX0212(0xd031)),
	/* U+78E2 */	U2E_NODEST_COLX,
	/* U+78E3 */	U2E_NODEST_COLX,
	/* U+78E4 */	IFX0213(JISX0213_1(0xf9ab),	JISX0212(0xd02d)),
	/* U+78E5 */	U2E_NODEST_COLX,
	/* U+78E6 */	IFX0213(JISX0213_2(0xf256),	JISX0212(0xd032)),
	/* U+78E7 */	JISX0208(0xe3a1),
	/* U+78E8 */	JISX0208(0xcbe1),
	/* U+78E9 */	U2E_NODEST_COLX,
	/* U+78EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd033)),
	/* U+78EB */	U2E_NODEST_COLX,
	/* U+78EC */	JISX0208(0xe2fe),
	/* U+78ED */	U2E_NODEST_COLX,
	/* U+78EE */	U2E_NODEST_COLX,
	/* U+78EF */	JISX0208(0xb0eb),
	/* U+78F0 */	U2E_NODEST_COLX,
	/* U+78F1 */	U2E_NODEST_COLX,
	/* U+78F2 */	IFX0213(JISX0213_1(0xf9ac),	JISX0212(0xd034)),
	/* U+78F3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd035)),
	/* U+78F4 */	JISX0208(0xe3a4),
	/* U+78F5 */	U2E_NODEST_COLX,
	/* U+78F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd037)),
	/* U+78F7 */	IFX0213(JISX0213_1(0xf9ae),	JISX0212(0xd038)),
	/* U+78F8 */	U2E_NODEST_COLX,
	/* U+78F9 */	IFX0213(JISX0213_2(0xf257),	U2E_NODEST_COLX),
	/* U+78FA */	IFX0213(JISX0213_2(0xf258),	JISX0212(0xd039)),
	/* U+78FB */	IFX0213(JISX0213_2(0xf259),	JISX0212(0xd03a)),
	/* U+78FC */	U2E_NODEST_COLX,
	/* U+78FD */	JISX0208(0xe3a3),
	/* U+78FE */	IFX0213(JISX0213_2(0xf25a),	U2E_NODEST_COLX),
	/* U+78FF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd03b)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_79[] = {
	/* U+7900 */	IFX0213(JISX0213_1(0xf9ad),	JISX0212(0xd036)),
	/* U+7901 */	JISX0208(0xbecc),
	/* U+7902 */	U2E_NODEST_COLX,
	/* U+7903 */	U2E_NODEST_COLX,
	/* U+7904 */	U2E_NODEST_COLX,
	/* U+7905 */	U2E_NODEST_COLX,
	/* U+7906 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd03c)),
	/* U+7907 */	JISX0208(0xe3a5),
	/* U+7908 */	U2E_NODEST_COLX,
	/* U+7909 */	U2E_NODEST_COLX,
	/* U+790A */	U2E_NODEST_COLX,
	/* U+790B */	U2E_NODEST_COLX,
	/* U+790C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd03d)),
	/* U+790D */	U2E_NODEST_COLX,
	/* U+790E */	JISX0208(0xc1c3),
	/* U+790F */	U2E_NODEST_COLX,
	/* U+7910 */	IFX0213(JISX0213_2(0xf25c),	JISX0212(0xd03e)),
	/* U+7911 */	JISX0208(0xe3a7),
	/* U+7912 */	JISX0208(0xe3a6),
	/* U+7913 */	U2E_NODEST_COLX,
	/* U+7914 */	U2E_NODEST_COLX,
	/* U+7915 */	U2E_NODEST_COLX,
	/* U+7916 */	U2E_NODEST_COLX,
	/* U+7917 */	U2E_NODEST_COLX,
	/* U+7918 */	U2E_NODEST_COLX,
	/* U+7919 */	JISX0208(0xe3a8),
	/* U+791A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd03f)),
	/* U+791B */	IFX0213(JISX0213_2(0xf25d),	U2E_NODEST_COLX),
	/* U+791C */	IFX0213(JISX0213_1(0xf9af),	JISX0212(0xd040)),
	/* U+791D */	U2E_NODEST_COLX,
	/* U+791E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd041)),
	/* U+791F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd042)),
	/* U+7920 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd043)),
	/* U+7921 */	U2E_NODEST_COLX,
	/* U+7922 */	U2E_NODEST_COLX,
	/* U+7923 */	U2E_NODEST_COLX,
	/* U+7924 */	U2E_NODEST_COLX,
	/* U+7925 */	IFX0213(JISX0213_2(0xf25f),	JISX0212(0xd044)),
	/* U+7926 */	JISX0208(0xe2e8),
	/* U+7927 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd045)),
	/* U+7928 */	U2E_NODEST_COLX,
	/* U+7929 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd046)),
	/* U+792A */	JISX0208(0xe2ea),
	/* U+792B */	JISX0208(0xe3aa),
	/* U+792C */	JISX0208(0xe3a9),
	/* U+792D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd047)),
	/* U+792E */	IFX0213(JISX0213_1(0xf9b0),	U2E_NODEST_COLX),
	/* U+792F */	U2E_NODEST_COLX,
	/* U+7930 */	IFX0213(JISX0213_2(0xf25e),	IBM(0xf454)),
	/* U+7931 */	IFX0213(JISX0213_1(0xf9b1),	JISX0212(0xd048)),
	/* U+7932 */	U2E_NODEST_COLX,
	/* U+7933 */	U2E_NODEST_COLX,
	/* U+7934 */	IFX0213(JISX0213_1(0xf9b2),	JISX0212(0xd049)),
	/* U+7935 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd04a)),
	/* U+7936 */	U2E_NODEST_COLX,
	/* U+7937 */	U2E_NODEST_COLX,
	/* U+7938 */	U2E_NODEST_COLX,
	/* U+7939 */	U2E_NODEST_COLX,
	/* U+793A */	JISX0208(0xbca8),
	/* U+793B */	IFX0213(JISX0213_2(0xf260),	JISX0212(0xd04b)),
	/* U+793C */	JISX0208(0xcee9),
	/* U+793D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd04c)),
	/* U+793E */	JISX0208(0xbcd2),
	/* U+793F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd04d)),
	/* U+7940 */	JISX0208(0xe3ab),
	/* U+7941 */	JISX0208(0xb7b7),
	/* U+7942 */	U2E_NODEST_COLX,
	/* U+7943 */	U2E_NODEST_COLX,
	/* U+7944 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd04e)),
	/* U+7945 */	IFX0213(JISX0213_1(0xf9b5),	JISX0212(0xd04f)),
	/* U+7946 */	IFX0213(JISX0213_1(0xf9b6),	JISX0212(0xd050)),
	/* U+7947 */	JISX0208(0xb5c0),
	/* U+7948 */	JISX0208(0xb5a7),
	/* U+7949 */	JISX0208(0xbbe3),
	/* U+794A */	IFX0213(JISX0213_2(0xf261),	JISX0212(0xd051)),
	/* U+794B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd052)),
	/* U+794C */	U2E_NODEST_COLX,
	/* U+794D */	U2E_NODEST_COLX,
	/* U+794E */	U2E_NODEST_COLX,
	/* U+794F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd053)),
	/* U+7950 */	JISX0208(0xcdb4),
	/* U+7951 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd054)),
	/* U+7952 */	U2E_NODEST_COLX,
	/* U+7953 */	JISX0208(0xe3b1),
	/* U+7954 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd055)),
	/* U+7955 */	JISX0208(0xe3b0),
	/* U+7956 */	JISX0208(0xc1c4),
	/* U+7957 */	JISX0208(0xe3ad),
	/* U+7958 */	IFX0213(JISX0213_2(0xf262),	JISX0212(0xd056)),
	/* U+7959 */	U2E_NODEST_COLX,
	/* U+795A */	JISX0208(0xe3af),
	/* U+795B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd057)),
	/* U+795C */	IFX0213(JISX0213_1(0xf9ba),	JISX0212(0xd058)),
	/* U+795D */	JISX0208(0xbdcb),
	/* U+795E */	JISX0208(0xbfc0),
	/* U+795F */	JISX0208(0xe3ae),
	/* U+7960 */	JISX0208(0xe3ac),
	/* U+7961 */	U2E_NODEST_COLX,
	/* U+7962 */	JISX0208(0xc7aa),
	/* U+7963 */	U2E_NODEST_COLX,
	/* U+7964 */	U2E_NODEST_COLX,
	/* U+7965 */	JISX0208(0xbecd),
	/* U+7966 */	U2E_NODEST_COLX,
	/* U+7967 */	IFX0213(JISX0213_2(0xf265),	JISX0212(0xd059)),
	/* U+7968 */	JISX0208(0xc9bc),
	/* U+7969 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd05a)),
	/* U+796A */	U2E_NODEST_COLX,
	/* U+796B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd05b)),
	/* U+796C */	U2E_NODEST_COLX,
	/* U+796D */	JISX0208(0xbad7),
	/* U+796E */	U2E_NODEST_COLX,
	/* U+796F */	U2E_NODEST_COLX,
	/* U+7970 */	U2E_NODEST_COLX,
	/* U+7971 */	U2E_NODEST_COLX,
	/* U+7972 */	IFX0213(JISX0213_2(0xf266),	JISX0212(0xd05c)),
	/* U+7973 */	U2E_NODEST_COLX,
	/* U+7974 */	U2E_NODEST_COLX,
	/* U+7975 */	U2E_NODEST_COLX,
	/* U+7976 */	U2E_NODEST_COLX,
	/* U+7977 */	JISX0208(0xc5f8),
	/* U+7978 */	U2E_NODEST_COLX,
	/* U+7979 */	IFX0213(JISX0213_1(0xf9be),	JISX0212(0xd05d)),
	/* U+797A */	JISX0208(0xe3b2),
	/* U+797B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd05e)),
	/* U+797C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd05f)),
	/* U+797D */	U2E_NODEST_COLX,
	/* U+797E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd060)),
	/* U+797F */	JISX0208(0xe3b3),
	/* U+7980 */	JISX0208(0xe3c9),
	/* U+7981 */	JISX0208(0xb6d8),
	/* U+7982 */	U2E_NODEST_COLX,
	/* U+7983 */	U2E_NODEST_COLX,
	/* U+7984 */	JISX0208(0xcfbd),
	/* U+7985 */	JISX0208(0xc1b5),
	/* U+7986 */	U2E_NODEST_COLX,
	/* U+7987 */	U2E_NODEST_COLX,
	/* U+7988 */	U2E_NODEST_COLX,
	/* U+7989 */	U2E_NODEST_COLX,
	/* U+798A */	JISX0208(0xe3b4),
	/* U+798B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd061)),
	/* U+798C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd062)),
	/* U+798D */	JISX0208(0xb2d2),
	/* U+798E */	JISX0208(0xc4f7),
	/* U+798F */	JISX0208(0xcaa1),
	/* U+7990 */	U2E_NODEST_COLX,
	/* U+7991 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd063)),
	/* U+7992 */	U2E_NODEST_COLX,
	/* U+7993 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd064)),
	/* U+7994 */	IFX0213(JISX0213_2(0xf267),	JISX0212(0xd065)),
	/* U+7995 */	IFX0213(JISX0213_2(0xf268),	JISX0212(0xd066)),
	/* U+7996 */	IFX0213(JISX0213_2(0xf269),	JISX0212(0xd067)),
	/* U+7997 */	U2E_NODEST_COLX,
	/* U+7998 */	IFX0213(JISX0213_1(0xf9c2),	JISX0212(0xd068)),
	/* U+7999 */	U2E_NODEST_COLX,
	/* U+799A */	U2E_NODEST_COLX,
	/* U+799B */	IFX0213(JISX0213_2(0xf26a),	JISX0212(0xd069)),
	/* U+799C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd06a)),
	/* U+799D */	JISX0208(0xe3b5),
	/* U+799E */	U2E_NODEST_COLX,
	/* U+799F */	U2E_NODEST_COLX,
	/* U+79A0 */	U2E_NODEST_COLX,
	/* U+79A1 */	IFX0213(JISX0213_2(0xf26b),	JISX0212(0xd06b)),
	/* U+79A2 */	U2E_NODEST_COLX,
	/* U+79A3 */	U2E_NODEST_COLX,
	/* U+79A4 */	U2E_NODEST_COLX,
	/* U+79A5 */	U2E_NODEST_COLX,
	/* U+79A6 */	JISX0208(0xb5fa),
	/* U+79A7 */	JISX0208(0xe3b6),
	/* U+79A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd06c)),
	/* U+79A9 */	IFX0213(JISX0213_2(0xf26c),	JISX0212(0xd06d)),
	/* U+79AA */	JISX0208(0xe3b8),
	/* U+79AB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd06e)),
	/* U+79AC */	U2E_NODEST_COLX,
	/* U+79AD */	U2E_NODEST_COLX,
	/* U+79AE */	JISX0208(0xe3b9),
	/* U+79AF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd06f)),
	/* U+79B0 */	JISX0208(0xc7a9),
	/* U+79B1 */	IFX0213(JISX0213_1(0xf9c3),	JISX0212(0xd070)),
	/* U+79B2 */	U2E_NODEST_COLX,
	/* U+79B3 */	JISX0208(0xe3ba),
	/* U+79B4 */	IFX0213(JISX0213_2(0xf26d),	JISX0212(0xd071)),
	/* U+79B5 */	U2E_NODEST_COLX,
	/* U+79B6 */	U2E_NODEST_COLX,
	/* U+79B7 */	U2E_NODEST_COLX,
	/* U+79B8 */	IFX0213(JISX0213_1(0xf9c4),	JISX0212(0xd072)),
	/* U+79B9 */	JISX0208(0xe3bb),
	/* U+79BA */	JISX0208(0xe3bc),
	/* U+79BB */	IFX0213(JISX0213_2(0xf26e),	JISX0212(0xd073)),
	/* U+79BC */	U2E_NODEST_COLX,
	/* U+79BD */	JISX0208(0xb6d9),
	/* U+79BE */	JISX0208(0xb2d3),
	/* U+79BF */	JISX0208(0xc6c5),
	/* U+79C0 */	JISX0208(0xbda8),
	/* U+79C1 */	JISX0208(0xbbe4),
	/* U+79C2 */	IFX0213(JISX0213_2(0xf26f),	JISX0212(0xd074)),
	/* U+79C3 */	U2E_NODEST_COLX,
	/* U+79C4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd075)),
	/* U+79C5 */	U2E_NODEST_COLX,
	/* U+79C6 */	U2E_NODEST_COLX,
	/* U+79C7 */	IFX0213(JISX0213_2(0xf270),	JISX0212(0xd076)),
	/* U+79C8 */	IFX0213(JISX0213_1(0xf9c5),	JISX0212(0xd077)),
	/* U+79C9 */	JISX0208(0xe3bd),
	/* U+79CA */	IFX0213(JISX0213_1(0xf9c6),	JISX0212(0xd078)),
	/* U+79CB */	JISX0208(0xbda9),
	/* U+79CC */	IFX0213(JISX0213_2(0xf271),	U2E_NODEST_COLX),
	/* U+79CD */	IFX0213(JISX0213_2(0xf272),	U2E_NODEST_COLX),
	/* U+79CE */	U2E_NODEST_COLX,
	/* U+79CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd079)),
	/* U+79D0 */	U2E_NODEST_COLX,
	/* U+79D1 */	JISX0208(0xb2ca),
	/* U+79D2 */	JISX0208(0xc9c3),
	/* U+79D3 */	U2E_NODEST_COLX,
	/* U+79D4 */	IFX0213(JISX0213_1(0xf9c8),	JISX0212(0xd07a)),
	/* U+79D5 */	JISX0208(0xe3be),
	/* U+79D6 */	IFX0213(JISX0213_2(0xf273),	JISX0212(0xd07b)),
	/* U+79D7 */	U2E_NODEST_COLX,
	/* U+79D8 */	JISX0208(0xc8eb),
	/* U+79D9 */	U2E_NODEST_COLX,
	/* U+79DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd07c)),
	/* U+79DB */	U2E_NODEST_COLX,
	/* U+79DC */	U2E_NODEST_COLX,
	/* U+79DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd07d)),
	/* U+79DE */	IFX0213(JISX0213_1(0xf9c9),	JISX0212(0xd07e)),
	/* U+79DF */	JISX0208(0xc1c5),
	/* U+79E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd121)),
	/* U+79E1 */	JISX0208(0xe3c1),
	/* U+79E2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd122)),
	/* U+79E3 */	JISX0208(0xe3c2),
	/* U+79E4 */	JISX0208(0xc7e9),
	/* U+79E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd123)),
	/* U+79E6 */	JISX0208(0xbfc1),
	/* U+79E7 */	JISX0208(0xe3bf),
	/* U+79E8 */	U2E_NODEST_COLX,
	/* U+79E9 */	JISX0208(0xc3e1),
	/* U+79EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd124)),
	/* U+79EB */	IFX0213(JISX0213_1(0xf9ca),	JISX0212(0xd125)),
	/* U+79EC */	JISX0208(0xe3c0),
	/* U+79ED */	IFX0213(JISX0213_1(0xf9cb),	JISX0212(0xd126)),
	/* U+79EE */	U2E_NODEST_COLX,
	/* U+79EF */	U2E_NODEST_COLX,
	/* U+79F0 */	JISX0208(0xbece),
	/* U+79F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd127)),
	/* U+79F2 */	U2E_NODEST_COLX,
	/* U+79F3 */	U2E_NODEST_COLX,
	/* U+79F4 */	U2E_NODEST_COLX,
	/* U+79F5 */	U2E_NODEST_COLX,
	/* U+79F6 */	U2E_NODEST_COLX,
	/* U+79F7 */	U2E_NODEST_COLX,
	/* U+79F8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd128)),
	/* U+79F9 */	U2E_NODEST_COLX,
	/* U+79FA */	U2E_NODEST_COLX,
	/* U+79FB */	JISX0208(0xb0dc),
	/* U+79FC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd129)),
	/* U+79FD */	U2E_NODEST_COLX,
	/* U+79FE */	U2E_NODEST_COLX,
	/* U+79FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_7A[] = {
	/* U+7A00 */	JISX0208(0xb5a9),
	/* U+7A01 */	U2E_NODEST_COLX,
	/* U+7A02 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd12a)),
	/* U+7A03 */	IFX0213(JISX0213_1(0xf9cc),	JISX0212(0xd12b)),
	/* U+7A04 */	U2E_NODEST_COLX,
	/* U+7A05 */	U2E_NODEST_COLX,
	/* U+7A06 */	U2E_NODEST_COLX,
	/* U+7A07 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd12c)),
	/* U+7A08 */	JISX0208(0xe3c3),
	/* U+7A09 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd12d)),
	/* U+7A0A */	IFX0213(JISX0213_2(0xf278),	JISX0212(0xd12e)),
	/* U+7A0B */	JISX0208(0xc4f8),
	/* U+7A0C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd12f)),
	/* U+7A0D */	JISX0208(0xe3c4),
	/* U+7A0E */	JISX0208(0xc0c7),
	/* U+7A0F */	U2E_NODEST_COLX,
	/* U+7A10 */	U2E_NODEST_COLX,
	/* U+7A11 */	IFX0213(JISX0213_2(0xf279),	JISX0212(0xd130)),
	/* U+7A12 */	U2E_NODEST_COLX,
	/* U+7A13 */	U2E_NODEST_COLX,
	/* U+7A14 */	JISX0208(0xccad),
	/* U+7A15 */	IFX0213(JISX0213_2(0xf27a),	JISX0212(0xd131)),
	/* U+7A16 */	U2E_NODEST_COLX,
	/* U+7A17 */	JISX0208(0xc9a3),
	/* U+7A18 */	JISX0208(0xe3c5),
	/* U+7A19 */	JISX0208(0xe3c6),
	/* U+7A1A */	JISX0208(0xc3d5),
	/* U+7A1B */	IFX0213(JISX0213_2(0xf27b),	JISX0212(0xd132)),
	/* U+7A1C */	JISX0208(0xcec7),
	/* U+7A1D */	U2E_NODEST_COLX,
	/* U+7A1E */	IFX0213(JISX0213_2(0xf27c),	JISX0212(0xd133)),
	/* U+7A1F */	JISX0208(0xe3c8),
	/* U+7A20 */	JISX0208(0xe3c7),
	/* U+7A21 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd134)),
	/* U+7A22 */	U2E_NODEST_COLX,
	/* U+7A23 */	U2E_NODEST_COLX,
	/* U+7A24 */	U2E_NODEST_COLX,
	/* U+7A25 */	U2E_NODEST_COLX,
	/* U+7A26 */	U2E_NODEST_COLX,
	/* U+7A27 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd135)),
	/* U+7A28 */	U2E_NODEST_COLX,
	/* U+7A29 */	U2E_NODEST_COLX,
	/* U+7A2A */	U2E_NODEST_COLX,
	/* U+7A2B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd136)),
	/* U+7A2C */	U2E_NODEST_COLX,
	/* U+7A2D */	IFX0213(JISX0213_2(0xf27e),	JISX0212(0xd137)),
	/* U+7A2E */	JISX0208(0xbcef),
	/* U+7A2F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd138)),
	/* U+7A30 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd139)),
	/* U+7A31 */	JISX0208(0xe3ca),
	/* U+7A32 */	JISX0208(0xb0f0),
	/* U+7A33 */	U2E_NODEST_COLX,
	/* U+7A34 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd13a)),
	/* U+7A35 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd13b)),
	/* U+7A36 */	U2E_NODEST_COLX,
	/* U+7A37 */	JISX0208(0xe3cd),
	/* U+7A38 */	IFX0213(JISX0213_2(0xf321),	JISX0212(0xd13c)),
	/* U+7A39 */	IFX0213(JISX0213_1(0xf9ce),	JISX0212(0xd13d)),
	/* U+7A3A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd13e)),
	/* U+7A3B */	JISX0208(0xe3cb),
	/* U+7A3C */	JISX0208(0xb2d4),
	/* U+7A3D */	JISX0208(0xb7ce),
	/* U+7A3E */	JISX0208(0xe3cc),
	/* U+7A3F */	JISX0208(0xb9c6),
	/* U+7A40 */	JISX0208(0xb9f2),
	/* U+7A41 */	U2E_NODEST_COLX,
	/* U+7A42 */	JISX0208(0xcae6),
	/* U+7A43 */	JISX0208(0xe3ce),
	/* U+7A44 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd13f)),
	/* U+7A45 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd140)),
	/* U+7A46 */	JISX0208(0xcbd4),
	/* U+7A47 */	IFX0213(JISX0213_2(0xf322),	JISX0212(0xd141)),
	/* U+7A48 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd142)),
	/* U+7A49 */	JISX0208(0xe3d0),
	/* U+7A4A */	U2E_NODEST_COLX,
	/* U+7A4B */	U2E_NODEST_COLX,
	/* U+7A4C */	IFX0213(JISX0213_2(0xf323),	JISX0212(0xd143)),
	/* U+7A4D */	JISX0208(0xc0d1),
	/* U+7A4E */	JISX0208(0xb1cf),
	/* U+7A4F */	JISX0208(0xb2ba),
	/* U+7A50 */	JISX0208(0xb0ac),
	/* U+7A51 */	U2E_NODEST_COLX,
	/* U+7A52 */	U2E_NODEST_COLX,
	/* U+7A53 */	U2E_NODEST_COLX,
	/* U+7A54 */	U2E_NODEST_COLX,
	/* U+7A55 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd144)),
	/* U+7A56 */	IFX0213(JISX0213_2(0xf324),	JISX0212(0xd145)),
	/* U+7A57 */	JISX0208(0xe3cf),
	/* U+7A58 */	U2E_NODEST_COLX,
	/* U+7A59 */	IFX0213(JISX0213_2(0xf325),	JISX0212(0xd146)),
	/* U+7A5A */	U2E_NODEST_COLX,
	/* U+7A5B */	U2E_NODEST_COLX,
	/* U+7A5C */	IFX0213(JISX0213_2(0xf326),	JISX0212(0xd147)),
	/* U+7A5D */	IFX0213(JISX0213_1(0xf9cf),	JISX0212(0xd148)),
	/* U+7A5E */	U2E_NODEST_COLX,
	/* U+7A5F */	IFX0213(JISX0213_2(0xf327),	JISX0212(0xd149)),
	/* U+7A60 */	IFX0213(JISX0213_2(0xf328),	JISX0212(0xd14a)),
	/* U+7A61 */	JISX0208(0xe3d1),
	/* U+7A62 */	JISX0208(0xe3d2),
	/* U+7A63 */	JISX0208(0xbef7),
	/* U+7A64 */	U2E_NODEST_COLX,
	/* U+7A65 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd14b)),
	/* U+7A66 */	U2E_NODEST_COLX,
	/* U+7A67 */	IFX0213(JISX0213_2(0xf329),	JISX0212(0xd14c)),
	/* U+7A68 */	U2E_NODEST_COLX,
	/* U+7A69 */	JISX0208(0xe3d3),
	/* U+7A6A */	IFX0213(JISX0213_2(0xf32a),	JISX0212(0xd14d)),
	/* U+7A6B */	JISX0208(0xb3cf),
	/* U+7A6C */	U2E_NODEST_COLX,
	/* U+7A6D */	IFX0213(JISX0213_1(0xf9d0),	JISX0212(0xd14e)),
	/* U+7A6E */	U2E_NODEST_COLX,
	/* U+7A6F */	U2E_NODEST_COLX,
	/* U+7A70 */	JISX0208(0xe3d5),
	/* U+7A71 */	U2E_NODEST_COLX,
	/* U+7A72 */	U2E_NODEST_COLX,
	/* U+7A73 */	U2E_NODEST_COLX,
	/* U+7A74 */	JISX0208(0xb7ea),
	/* U+7A75 */	IFX0213(JISX0213_2(0xf32b),	JISX0212(0xd14f)),
	/* U+7A76 */	JISX0208(0xb5e6),
	/* U+7A77 */	U2E_NODEST_COLX,
	/* U+7A78 */	IFX0213(JISX0213_2(0xf32c),	JISX0212(0xd150)),
	/* U+7A79 */	JISX0208(0xe3d6),
	/* U+7A7A */	JISX0208(0xb6f5),
	/* U+7A7B */	U2E_NODEST_COLX,
	/* U+7A7C */	U2E_NODEST_COLX,
	/* U+7A7D */	JISX0208(0xe3d7),
	/* U+7A7E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd151)),
	/* U+7A7F */	JISX0208(0xc0fc),
	/* U+7A80 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd152)),
	/* U+7A81 */	JISX0208(0xc6cd),
	/* U+7A82 */	IFX0213(JISX0213_2(0xf32d),	JISX0212(0xd153)),
	/* U+7A83 */	JISX0208(0xc0e0),
	/* U+7A84 */	JISX0208(0xbaf5),
	/* U+7A85 */	IFX0213(JISX0213_1(0xf9d2),	JISX0212(0xd154)),
	/* U+7A86 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd155)),
	/* U+7A87 */	U2E_NODEST_COLX,
	/* U+7A88 */	JISX0208(0xe3d8),
	/* U+7A89 */	U2E_NODEST_COLX,
	/* U+7A8A */	IFX0213(JISX0213_2(0xf32e),	JISX0212(0xd156)),
	/* U+7A8B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd157)),
	/* U+7A8C */	U2E_NODEST_COLX,
	/* U+7A8D */	U2E_NODEST_COLX,
	/* U+7A8E */	U2E_NODEST_COLX,
	/* U+7A8F */	U2E_NODEST_COLX,
	/* U+7A90 */	IFX0213(JISX0213_2(0xf32f),	JISX0212(0xd158)),
	/* U+7A91 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd159)),
	/* U+7A92 */	JISX0208(0xc3e2),
	/* U+7A93 */	JISX0208(0xc1eb),
	/* U+7A94 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd15a)),
	/* U+7A95 */	JISX0208(0xe3da),
	/* U+7A96 */	JISX0208(0xe3dc),
	/* U+7A97 */	JISX0208(0xe3d9),
	/* U+7A98 */	JISX0208(0xe3db),
	/* U+7A99 */	U2E_NODEST_COLX,
	/* U+7A9A */	U2E_NODEST_COLX,
	/* U+7A9B */	U2E_NODEST_COLX,
	/* U+7A9C */	U2E_NODEST_COLX,
	/* U+7A9D */	U2E_NODEST_COLX,
	/* U+7A9E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd15b)),
	/* U+7A9F */	JISX0208(0xb7a2),
	/* U+7AA0 */	IFX0213(JISX0213_1(0xf9d3),	JISX0212(0xd15c)),
	/* U+7AA1 */	U2E_NODEST_COLX,
	/* U+7AA2 */	U2E_NODEST_COLX,
	/* U+7AA3 */	IFX0213(JISX0213_2(0xf330),	JISX0212(0xd15d)),
	/* U+7AA4 */	U2E_NODEST_COLX,
	/* U+7AA5 */	U2E_NODEST_COLX,
	/* U+7AA6 */	U2E_NODEST_COLX,
	/* U+7AA7 */	U2E_NODEST_COLX,
	/* U+7AA8 */	U2E_NODEST_COLX,
	/* U+7AA9 */	JISX0208(0xe3dd),
	/* U+7AAA */	JISX0208(0xb7a6),
	/* U+7AAB */	U2E_NODEST_COLX,
	/* U+7AAC */	IFX0213(JISX0213_2(0xf331),	JISX0212(0xd15e)),
	/* U+7AAD */	U2E_NODEST_COLX,
	/* U+7AAE */	JISX0208(0xb5e7),
	/* U+7AAF */	JISX0208(0xcdd2),
	/* U+7AB0 */	JISX0208(0xe3df),
	/* U+7AB1 */	U2E_NODEST_COLX,
	/* U+7AB2 */	U2E_NODEST_COLX,
	/* U+7AB3 */	IFX0213(JISX0213_1(0xf9d5),	JISX0212(0xd15f)),
	/* U+7AB4 */	U2E_NODEST_COLX,
	/* U+7AB5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd160)),
	/* U+7AB6 */	JISX0208(0xe3e0),
	/* U+7AB7 */	U2E_NODEST_COLX,
	/* U+7AB8 */	U2E_NODEST_COLX,
	/* U+7AB9 */	IFX0213(JISX0213_2(0xf334),	JISX0212(0xd161)),
	/* U+7ABA */	JISX0208(0xb1ae),
	/* U+7ABB */	IFX0213(JISX0213_1(0xf9d6),	JISX0212(0xd162)),
	/* U+7ABC */	IFX0213(JISX0213_2(0xf335),	JISX0212(0xd163)),
	/* U+7ABD */	U2E_NODEST_COLX,
	/* U+7ABE */	IFX0213(JISX0213_2(0xf336),	U2E_NODEST_COLX),
	/* U+7ABF */	JISX0208(0xe3e3),
	/* U+7AC0 */	U2E_NODEST_COLX,
	/* U+7AC1 */	U2E_NODEST_COLX,
	/* U+7AC2 */	U2E_NODEST_COLX,
	/* U+7AC3 */	JISX0208(0xb3f6),
	/* U+7AC4 */	JISX0208(0xe3e2),
	/* U+7AC5 */	JISX0208(0xe3e1),
	/* U+7AC6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd164)),
	/* U+7AC7 */	JISX0208(0xe3e5),
	/* U+7AC8 */	JISX0208(0xe3de),
	/* U+7AC9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd165)),
	/* U+7ACA */	JISX0208(0xe3e6),
	/* U+7ACB */	JISX0208(0xcea9),
	/* U+7ACC */	IFX0213(JISX0213_2(0xf338),	JISX0212(0xd166)),
	/* U+7ACD */	JISX0208(0xe3e7),
	/* U+7ACE */	IFX0213(JISX0213_1(0xf9d7),	JISX0212(0xd167)),
	/* U+7ACF */	JISX0208(0xe3e8),
	/* U+7AD0 */	U2E_NODEST_COLX,
	/* U+7AD1 */	IFX0213(JISX0213_2(0xf339),	JISX0212(0xd168)),
	/* U+7AD2 */	JISX0208(0xd4f4),
	/* U+7AD3 */	JISX0208(0xe3ea),
	/* U+7AD4 */	U2E_NODEST_COLX,
	/* U+7AD5 */	JISX0208(0xe3e9),
	/* U+7AD6 */	U2E_NODEST_COLX,
	/* U+7AD7 */	U2E_NODEST_COLX,
	/* U+7AD8 */	U2E_NODEST_COLX,
	/* U+7AD9 */	JISX0208(0xe3eb),
	/* U+7ADA */	JISX0208(0xe3ec),
	/* U+7ADB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd169)),
	/* U+7ADC */	JISX0208(0xceb5),
	/* U+7ADD */	JISX0208(0xe3ed),
	/* U+7ADE */	U2E_NODEST_COLX,
	/* U+7ADF */	JISX0208(0xf0ef),
	/* U+7AE0 */	JISX0208(0xbecf),
	/* U+7AE1 */	JISX0208(0xe3ee),
	/* U+7AE2 */	JISX0208(0xe3ef),
	/* U+7AE3 */	JISX0208(0xbdd7),
	/* U+7AE4 */	U2E_NODEST_COLX,
	/* U+7AE5 */	JISX0208(0xc6b8),
	/* U+7AE6 */	JISX0208(0xe3f0),
	/* U+7AE7 */	IFX0213(JISX0213_2(0xf33a),	IBM(0xf459)),
	/* U+7AE8 */	IFX0213(JISX0213_2(0xf33b),	JISX0212(0xd16a)),
	/* U+7AE9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd16b)),
	/* U+7AEA */	JISX0208(0xc3a8),
	/* U+7AEB */	IFX0213(JISX0213_1(0xf9d8),	JISX0212(0xd16c)),
	/* U+7AEC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd16d)),
	/* U+7AED */	JISX0208(0xe3f1),
	/* U+7AEE */	U2E_NODEST_COLX,
	/* U+7AEF */	JISX0208(0xc3bc),
	/* U+7AF0 */	JISX0208(0xe3f2),
	/* U+7AF1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd16e)),
	/* U+7AF2 */	U2E_NODEST_COLX,
	/* U+7AF3 */	U2E_NODEST_COLX,
	/* U+7AF4 */	IFX0213(JISX0213_2(0xf33c),	JISX0212(0xd16f)),
	/* U+7AF5 */	U2E_NODEST_COLX,
	/* U+7AF6 */	JISX0208(0xb6a5),
	/* U+7AF7 */	U2E_NODEST_COLX,
	/* U+7AF8 */	JISX0208(0xd1bf),
	/* U+7AF9 */	JISX0208(0xc3dd),
	/* U+7AFA */	JISX0208(0xbcb3),
	/* U+7AFB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd170)),
	/* U+7AFC */	U2E_NODEST_COLX,
	/* U+7AFD */	IFX0213(JISX0213_1(0xf9d9),	JISX0212(0xd171)),
	/* U+7AFE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd172)),
	/* U+7AFF */	JISX0208(0xb4c8),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_7B[] = {
	/* U+7B00 */	U2E_NODEST_COLX,
	/* U+7B01 */	U2E_NODEST_COLX,
	/* U+7B02 */	JISX0208(0xe3f3),
	/* U+7B03 */	U2E_NODEST_COLX,
	/* U+7B04 */	JISX0208(0xe4a2),
	/* U+7B05 */	U2E_NODEST_COLX,
	/* U+7B06 */	JISX0208(0xe3f6),
	/* U+7B07 */	IFX0213(JISX0213_2(0xf33f),	JISX0212(0xd173)),
	/* U+7B08 */	JISX0208(0xb5e8),
	/* U+7B09 */	U2E_NODEST_COLX,
	/* U+7B0A */	JISX0208(0xe3f5),
	/* U+7B0B */	JISX0208(0xe4a4),
	/* U+7B0C */	U2E_NODEST_COLX,
	/* U+7B0D */	U2E_NODEST_COLX,
	/* U+7B0E */	U2E_NODEST_COLX,
	/* U+7B0F */	JISX0208(0xe3f4),
	/* U+7B10 */	U2E_NODEST_COLX,
	/* U+7B11 */	JISX0208(0xbed0),
	/* U+7B12 */	IFX0213(JISX0213_1(0xf9da),	U2E_NODEST_COLX),
	/* U+7B13 */	U2E_NODEST_COLX,
	/* U+7B14 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd174)),
	/* U+7B15 */	U2E_NODEST_COLX,
	/* U+7B16 */	U2E_NODEST_COLX,
	/* U+7B17 */	U2E_NODEST_COLX,
	/* U+7B18 */	JISX0208(0xe3f8),
	/* U+7B19 */	JISX0208(0xe3f9),
	/* U+7B1A */	U2E_NODEST_COLX,
	/* U+7B1B */	JISX0208(0xc5ab),
	/* U+7B1C */	U2E_NODEST_COLX,
	/* U+7B1D */	U2E_NODEST_COLX,
	/* U+7B1E */	JISX0208(0xe3fa),
	/* U+7B1F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd175)),
	/* U+7B20 */	JISX0208(0xb3de),
	/* U+7B21 */	U2E_NODEST_COLX,
	/* U+7B22 */	U2E_NODEST_COLX,
	/* U+7B23 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd176)),
	/* U+7B24 */	U2E_NODEST_COLX,
	/* U+7B25 */	JISX0208(0xbfda),
	/* U+7B26 */	JISX0208(0xc9e4),
	/* U+7B27 */	IFX0213(JISX0213_2(0xf342),	JISX0212(0xd177)),
	/* U+7B28 */	JISX0208(0xe3fc),
	/* U+7B29 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd178)),
	/* U+7B2A */	IFX0213(JISX0213_2(0xf343),	JISX0212(0xd179)),
	/* U+7B2B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd17a)),
	/* U+7B2C */	JISX0208(0xc2e8),
	/* U+7B2D */	IFX0213(JISX0213_1(0xf9db),	JISX0212(0xd17b)),
	/* U+7B2E */	IFX0213(JISX0213_2(0xf344),	JISX0212(0xd17c)),
	/* U+7B2F */	IFX0213(JISX0213_2(0xf345),	JISX0212(0xd17d)),
	/* U+7B30 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd17e)),
	/* U+7B31 */	IFX0213(JISX0213_2(0xf346),	JISX0212(0xd221)),
	/* U+7B32 */	U2E_NODEST_COLX,
	/* U+7B33 */	JISX0208(0xe3f7),
	/* U+7B34 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd222)),
	/* U+7B35 */	JISX0208(0xe3fb),
	/* U+7B36 */	JISX0208(0xe3fd),
	/* U+7B37 */	U2E_NODEST_COLX,
	/* U+7B38 */	U2E_NODEST_COLX,
	/* U+7B39 */	JISX0208(0xbafb),
	/* U+7B3A */	U2E_NODEST_COLX,
	/* U+7B3B */	IFX0213(JISX0213_1(0xf9dc),	U2E_NODEST_COLX),
	/* U+7B3C */	U2E_NODEST_COLX,
	/* U+7B3D */	IFX0213(JISX0213_2(0xf341),	JISX0212(0xd223)),
	/* U+7B3E */	U2E_NODEST_COLX,
	/* U+7B3F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd224)),
	/* U+7B40 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd225)),
	/* U+7B41 */	IFX0213(JISX0213_2(0xf34a),	JISX0212(0xd226)),
	/* U+7B42 */	U2E_NODEST_COLX,
	/* U+7B43 */	U2E_NODEST_COLX,
	/* U+7B44 */	U2E_NODEST_COLX,
	/* U+7B45 */	JISX0208(0xe4a6),
	/* U+7B46 */	JISX0208(0xc9ae),
	/* U+7B47 */	IFX0213(JISX0213_1(0xf9dd),	JISX0212(0xd227)),
	/* U+7B48 */	JISX0208(0xc8a6),
	/* U+7B49 */	JISX0208(0xc5f9),
	/* U+7B4A */	U2E_NODEST_COLX,
	/* U+7B4B */	JISX0208(0xb6da),
	/* U+7B4C */	JISX0208(0xe4a5),
	/* U+7B4D */	JISX0208(0xe4a3),
	/* U+7B4E */	IFX0213(JISX0213_1(0xf9de),	JISX0212(0xd228)),
	/* U+7B4F */	JISX0208(0xc8b5),
	/* U+7B50 */	JISX0208(0xe3fe),
	/* U+7B51 */	JISX0208(0xc3de),
	/* U+7B52 */	JISX0208(0xc5fb),
	/* U+7B53 */	U2E_NODEST_COLX,
	/* U+7B54 */	JISX0208(0xc5fa),
	/* U+7B55 */	IFX0213(JISX0213_2(0xf34c),	JISX0212(0xd229)),
	/* U+7B56 */	JISX0208(0xbaf6),
	/* U+7B57 */	U2E_NODEST_COLX,
	/* U+7B58 */	U2E_NODEST_COLX,
	/* U+7B59 */	U2E_NODEST_COLX,
	/* U+7B5A */	U2E_NODEST_COLX,
	/* U+7B5B */	U2E_NODEST_COLX,
	/* U+7B5C */	U2E_NODEST_COLX,
	/* U+7B5D */	JISX0208(0xe4b8),
	/* U+7B5E */	U2E_NODEST_COLX,
	/* U+7B5F */	U2E_NODEST_COLX,
	/* U+7B60 */	IFX0213(JISX0213_1(0xf9df),	JISX0212(0xd22a)),
	/* U+7B61 */	U2E_NODEST_COLX,
	/* U+7B62 */	U2E_NODEST_COLX,
	/* U+7B63 */	U2E_NODEST_COLX,
	/* U+7B64 */	IFX0213(JISX0213_2(0xf34e),	JISX0212(0xd22b)),
	/* U+7B65 */	JISX0208(0xe4a8),
	/* U+7B66 */	IFX0213(JISX0213_2(0xf34f),	JISX0212(0xd22c)),
	/* U+7B67 */	JISX0208(0xe4aa),
	/* U+7B68 */	U2E_NODEST_COLX,
	/* U+7B69 */	IFX0213(JISX0213_2(0xf350),	JISX0212(0xd22d)),
	/* U+7B6A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd22e)),
	/* U+7B6B */	U2E_NODEST_COLX,
	/* U+7B6C */	JISX0208(0xe4ad),
	/* U+7B6D */	IFX0213(JISX0213_1(0xf9e0),	JISX0212(0xd22f)),
	/* U+7B6E */	JISX0208(0xe4ae),
	/* U+7B6F */	IFX0213(JISX0213_1(0xf9e1),	JISX0212(0xd230)),
	/* U+7B70 */	JISX0208(0xe4ab),
	/* U+7B71 */	JISX0208(0xe4ac),
	/* U+7B72 */	IFX0213(JISX0213_1(0xf9e2),	JISX0212(0xd231)),
	/* U+7B73 */	IFX0213(JISX0213_2(0xf351),	JISX0212(0xd232)),
	/* U+7B74 */	JISX0208(0xe4a9),
	/* U+7B75 */	JISX0208(0xe4a7),
	/* U+7B76 */	U2E_NODEST_COLX,
	/* U+7B77 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd233)),
	/* U+7B78 */	U2E_NODEST_COLX,
	/* U+7B79 */	IFX0213(JISX0213_2(0xf34d),	U2E_NODEST_COLX),
	/* U+7B7A */	JISX0208(0xe4a1),
	/* U+7B7B */	U2E_NODEST_COLX,
	/* U+7B7C */	U2E_NODEST_COLX,
	/* U+7B7D */	U2E_NODEST_COLX,
	/* U+7B7E */	U2E_NODEST_COLX,
	/* U+7B7F */	IFX0213(JISX0213_2(0xf349),	U2E_NODEST_COLX),
	/* U+7B80 */	U2E_NODEST_COLX,
	/* U+7B81 */	U2E_NODEST_COLX,
	/* U+7B82 */	U2E_NODEST_COLX,
	/* U+7B83 */	U2E_NODEST_COLX,
	/* U+7B84 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd234)),
	/* U+7B85 */	U2E_NODEST_COLX,
	/* U+7B86 */	JISX0208(0xcacf),
	/* U+7B87 */	JISX0208(0xb2d5),
	/* U+7B88 */	U2E_NODEST_COLX,
	/* U+7B89 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd235)),
	/* U+7B8A */	U2E_NODEST_COLX,
	/* U+7B8B */	JISX0208(0xe4b5),
	/* U+7B8C */	U2E_NODEST_COLX,
	/* U+7B8D */	JISX0208(0xe4b2),
	/* U+7B8E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd236)),
	/* U+7B8F */	JISX0208(0xe4b7),
	/* U+7B90 */	IFX0213(JISX0213_2(0xf354),	JISX0212(0xd237)),
	/* U+7B91 */	IFX0213(JISX0213_2(0xf355),	JISX0212(0xd238)),
	/* U+7B92 */	JISX0208(0xe4b6),
	/* U+7B93 */	U2E_NODEST_COLX,
	/* U+7B94 */	JISX0208(0xc7f3),
	/* U+7B95 */	JISX0208(0xcca7),
	/* U+7B96 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd239)),
	/* U+7B97 */	JISX0208(0xbbbb),
	/* U+7B98 */	JISX0208(0xe4b0),
	/* U+7B99 */	JISX0208(0xe4b9),
	/* U+7B9A */	JISX0208(0xe4b4),
	/* U+7B9B */	IFX0213(JISX0213_2(0xf356),	JISX0212(0xd23a)),
	/* U+7B9C */	JISX0208(0xe4b3),
	/* U+7B9D */	JISX0208(0xe4af),
	/* U+7B9E */	IFX0213(JISX0213_1(0xf9e3),	JISX0212(0xd23b)),
	/* U+7B9F */	JISX0208(0xe4b1),
	/* U+7BA0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd23c)),
	/* U+7BA1 */	JISX0208(0xb4c9),
	/* U+7BA2 */	U2E_NODEST_COLX,
	/* U+7BA3 */	U2E_NODEST_COLX,
	/* U+7BA4 */	U2E_NODEST_COLX,
	/* U+7BA5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd23d)),
	/* U+7BA6 */	U2E_NODEST_COLX,
	/* U+7BA7 */	U2E_NODEST_COLX,
	/* U+7BA8 */	U2E_NODEST_COLX,
	/* U+7BA9 */	U2E_NODEST_COLX,
	/* U+7BAA */	JISX0208(0xc3bd),
	/* U+7BAB */	U2E_NODEST_COLX,
	/* U+7BAC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd23e)),
	/* U+7BAD */	JISX0208(0xc0fd),
	/* U+7BAE */	U2E_NODEST_COLX,
	/* U+7BAF */	IFX0213(JISX0213_2(0xf358),	JISX0212(0xd23f)),
	/* U+7BB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd240)),
	/* U+7BB1 */	JISX0208(0xc8a2),
	/* U+7BB2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd241)),
	/* U+7BB3 */	U2E_NODEST_COLX,
	/* U+7BB4 */	JISX0208(0xe4be),
	/* U+7BB5 */	IFX0213(JISX0213_2(0xf359),	JISX0212(0xd242)),
	/* U+7BB6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd243)),
	/* U+7BB7 */	U2E_NODEST_COLX,
	/* U+7BB8 */	JISX0208(0xc8a4),
	/* U+7BB9 */	U2E_NODEST_COLX,
	/* U+7BBA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd244)),
	/* U+7BBB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd245)),
	/* U+7BBC */	IFX0213(JISX0213_2(0xf35a),	JISX0212(0xd246)),
	/* U+7BBD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd247)),
	/* U+7BBE */	U2E_NODEST_COLX,
	/* U+7BBF */	U2E_NODEST_COLX,
	/* U+7BC0 */	JISX0208(0xc0e1),
	/* U+7BC1 */	JISX0208(0xe4bb),
	/* U+7BC2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd248)),
	/* U+7BC3 */	U2E_NODEST_COLX,
	/* U+7BC4 */	JISX0208(0xc8cf),
	/* U+7BC5 */	IFX0213(JISX0213_2(0xf35b),	JISX0212(0xd249)),
	/* U+7BC6 */	JISX0208(0xe4bf),
	/* U+7BC7 */	JISX0208(0xcad3),
	/* U+7BC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd24a)),
	/* U+7BC9 */	JISX0208(0xc3db),
	/* U+7BCA */	IFX0213(JISX0213_2(0xf35c),	JISX0212(0xd24b)),
	/* U+7BCB */	JISX0208(0xe4ba),
	/* U+7BCC */	JISX0208(0xe4bc),
	/* U+7BCD */	U2E_NODEST_COLX,
	/* U+7BCE */	U2E_NODEST_COLX,
	/* U+7BCF */	JISX0208(0xe4bd),
	/* U+7BD0 */	U2E_NODEST_COLX,
	/* U+7BD1 */	U2E_NODEST_COLX,
	/* U+7BD2 */	U2E_NODEST_COLX,
	/* U+7BD3 */	U2E_NODEST_COLX,
	/* U+7BD4 */	IFX0213(JISX0213_2(0xf35f),	JISX0212(0xd24c)),
	/* U+7BD5 */	U2E_NODEST_COLX,
	/* U+7BD6 */	IFX0213(JISX0213_2(0xf360),	JISX0212(0xd24d)),
	/* U+7BD7 */	IFX0213(JISX0213_1(0xf9e5),	JISX0212(0xd24e)),
	/* U+7BD8 */	U2E_NODEST_COLX,
	/* U+7BD9 */	IFX0213(JISX0213_1(0xf9e6),	JISX0212(0xd24f)),
	/* U+7BDA */	IFX0213(JISX0213_2(0xf361),	JISX0212(0xd250)),
	/* U+7BDB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd251)),
	/* U+7BDC */	U2E_NODEST_COLX,
	/* U+7BDD */	JISX0208(0xe4c0),
	/* U+7BDE */	U2E_NODEST_COLX,
	/* U+7BDF */	U2E_NODEST_COLX,
	/* U+7BE0 */	JISX0208(0xbcc4),
	/* U+7BE1 */	U2E_NODEST_COLX,
	/* U+7BE2 */	U2E_NODEST_COLX,
	/* U+7BE3 */	U2E_NODEST_COLX,
	/* U+7BE4 */	JISX0208(0xc6c6),
	/* U+7BE5 */	JISX0208(0xe4c5),
	/* U+7BE6 */	JISX0208(0xe4c4),
	/* U+7BE7 */	U2E_NODEST_COLX,
	/* U+7BE8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd252)),
	/* U+7BE9 */	JISX0208(0xe4c1),
	/* U+7BEA */	IFX0213(JISX0213_2(0xf362),	JISX0212(0xd253)),
	/* U+7BEB */	U2E_NODEST_COLX,
	/* U+7BEC */	U2E_NODEST_COLX,
	/* U+7BED */	JISX0208(0xcfb6),
	/* U+7BEE */	U2E_NODEST_COLX,
	/* U+7BEF */	U2E_NODEST_COLX,
	/* U+7BF0 */	IFX0213(JISX0213_2(0xf363),	U2E_NODEST_COLX),
	/* U+7BF1 */	U2E_NODEST_COLX,
	/* U+7BF2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd254)),
	/* U+7BF3 */	JISX0208(0xe4ca),
	/* U+7BF4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd255)),
	/* U+7BF5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd256)),
	/* U+7BF6 */	JISX0208(0xe4ce),
	/* U+7BF7 */	JISX0208(0xe4cb),
	/* U+7BF8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd257)),
	/* U+7BF9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd258)),
	/* U+7BFA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd259)),
	/* U+7BFB */	U2E_NODEST_COLX,
	/* U+7BFC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd25a)),
	/* U+7BFD */	U2E_NODEST_COLX,
	/* U+7BFE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd25b)),
	/* U+7BFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_7C[] = {
	/* U+7C00 */	JISX0208(0xe4c7),
	/* U+7C01 */	IFX0213(JISX0213_1(0xf9e7),	JISX0212(0xd25c)),
	/* U+7C02 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd25d)),
	/* U+7C03 */	IFX0213(JISX0213_2(0xf364),	JISX0212(0xd25e)),
	/* U+7C04 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd25f)),
	/* U+7C05 */	U2E_NODEST_COLX,
	/* U+7C06 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd260)),
	/* U+7C07 */	JISX0208(0xe4c8),
	/* U+7C08 */	U2E_NODEST_COLX,
	/* U+7C09 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd261)),
	/* U+7C0A */	U2E_NODEST_COLX,
	/* U+7C0B */	IFX0213(JISX0213_2(0xf365),	JISX0212(0xd262)),
	/* U+7C0C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd263)),
	/* U+7C0D */	JISX0208(0xe4cd),
	/* U+7C0E */	IFX0213(JISX0213_2(0xf366),	JISX0212(0xd264)),
	/* U+7C0F */	IFX0213(JISX0213_2(0xf367),	JISX0212(0xd265)),
	/* U+7C10 */	U2E_NODEST_COLX,
	/* U+7C11 */	JISX0208(0xe4c2),
	/* U+7C12 */	JISX0208(0xd2d5),
	/* U+7C13 */	JISX0208(0xe4c9),
	/* U+7C14 */	JISX0208(0xe4c3),
	/* U+7C15 */	U2E_NODEST_COLX,
	/* U+7C16 */	U2E_NODEST_COLX,
	/* U+7C17 */	JISX0208(0xe4cc),
	/* U+7C18 */	U2E_NODEST_COLX,
	/* U+7C19 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd266)),
	/* U+7C1A */	U2E_NODEST_COLX,
	/* U+7C1B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd267)),
	/* U+7C1C */	U2E_NODEST_COLX,
	/* U+7C1D */	U2E_NODEST_COLX,
	/* U+7C1E */	IFX0213(JISX0213_1(0xf9e9),	U2E_NODEST_COLX),
	/* U+7C1F */	JISX0208(0xe4d2),
	/* U+7C20 */	IFX0213(JISX0213_1(0xf9ea),	JISX0212(0xd268)),
	/* U+7C21 */	JISX0208(0xb4ca),
	/* U+7C22 */	U2E_NODEST_COLX,
	/* U+7C23 */	JISX0208(0xe4cf),
	/* U+7C24 */	U2E_NODEST_COLX,
	/* U+7C25 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd269)),
	/* U+7C26 */	IFX0213(JISX0213_2(0xf368),	JISX0212(0xd26a)),
	/* U+7C27 */	JISX0208(0xe4d0),
	/* U+7C28 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd26b)),
	/* U+7C29 */	U2E_NODEST_COLX,
	/* U+7C2A */	JISX0208(0xe4d1),
	/* U+7C2B */	JISX0208(0xe4d4),
	/* U+7C2C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd26c)),
	/* U+7C2D */	U2E_NODEST_COLX,
	/* U+7C2E */	U2E_NODEST_COLX,
	/* U+7C2F */	U2E_NODEST_COLX,
	/* U+7C30 */	U2E_NODEST_COLX,
	/* U+7C31 */	IFX0213(JISX0213_1(0xf9e8),	JISX0212(0xd26d)),
	/* U+7C32 */	U2E_NODEST_COLX,
	/* U+7C33 */	IFX0213(JISX0213_1(0xf9eb),	JISX0212(0xd26e)),
	/* U+7C34 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd26f)),
	/* U+7C35 */	U2E_NODEST_COLX,
	/* U+7C36 */	IFX0213(JISX0213_1(0xf9ec),	JISX0212(0xd270)),
	/* U+7C37 */	JISX0208(0xe4d3),
	/* U+7C38 */	JISX0208(0xc8f6),
	/* U+7C39 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd271)),
	/* U+7C3A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd272)),
	/* U+7C3B */	U2E_NODEST_COLX,
	/* U+7C3C */	U2E_NODEST_COLX,
	/* U+7C3D */	JISX0208(0xe4d5),
	/* U+7C3E */	JISX0208(0xcefc),
	/* U+7C3F */	JISX0208(0xcaed),
	/* U+7C40 */	JISX0208(0xe4da),
	/* U+7C41 */	U2E_NODEST_COLX,
	/* U+7C42 */	U2E_NODEST_COLX,
	/* U+7C43 */	JISX0208(0xe4d7),
	/* U+7C44 */	U2E_NODEST_COLX,
	/* U+7C45 */	IFX0213(JISX0213_2(0xf369),	U2E_NODEST_COLX),
	/* U+7C46 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd273)),
	/* U+7C47 */	U2E_NODEST_COLX,
	/* U+7C48 */	U2E_NODEST_COLX,
	/* U+7C49 */	U2E_NODEST_COLX,
	/* U+7C4A */	IFX0213(JISX0213_2(0xf36a),	JISX0212(0xd274)),
	/* U+7C4B */	U2E_NODEST_COLX,
	/* U+7C4C */	JISX0208(0xe4d6),
	/* U+7C4D */	JISX0208(0xc0d2),
	/* U+7C4E */	U2E_NODEST_COLX,
	/* U+7C4F */	JISX0208(0xe4d9),
	/* U+7C50 */	JISX0208(0xe4db),
	/* U+7C51 */	IFX0213(JISX0213_2(0xf36b),	JISX0212(0xd276)),
	/* U+7C52 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd277)),
	/* U+7C53 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd278)),
	/* U+7C54 */	JISX0208(0xe4d8),
	/* U+7C55 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd275)),
	/* U+7C56 */	JISX0208(0xe4df),
	/* U+7C57 */	IFX0213(JISX0213_2(0xf36c),	U2E_NODEST_COLX),
	/* U+7C58 */	JISX0208(0xe4dc),
	/* U+7C59 */	IFX0213(JISX0213_1(0xf9ef),	JISX0212(0xd279)),
	/* U+7C5A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd27a)),
	/* U+7C5B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd27b)),
	/* U+7C5C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd27c)),
	/* U+7C5D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd27d)),
	/* U+7C5E */	IFX0213(JISX0213_2(0xf36d),	JISX0212(0xd27e)),
	/* U+7C5F */	JISX0208(0xe4dd),
	/* U+7C60 */	JISX0208(0xe4c6),
	/* U+7C61 */	IFX0213(JISX0213_2(0xf36e),	JISX0212(0xd321)),
	/* U+7C62 */	U2E_NODEST_COLX,
	/* U+7C63 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd322)),
	/* U+7C64 */	JISX0208(0xe4de),
	/* U+7C65 */	JISX0208(0xe4e0),
	/* U+7C66 */	U2E_NODEST_COLX,
	/* U+7C67 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd323)),
	/* U+7C68 */	U2E_NODEST_COLX,
	/* U+7C69 */	IFX0213(JISX0213_2(0xf36f),	JISX0212(0xd324)),
	/* U+7C6A */	U2E_NODEST_COLX,
	/* U+7C6B */	U2E_NODEST_COLX,
	/* U+7C6C */	JISX0208(0xe4e1),
	/* U+7C6D */	IFX0213(JISX0213_1(0xf9f0),	JISX0212(0xd325)),
	/* U+7C6E */	IFX0213(JISX0213_2(0xf370),	JISX0212(0xd326)),
	/* U+7C6F */	IFX0213(JISX0213_2(0xf371),	U2E_NODEST_COLX),
	/* U+7C70 */	IFX0213(JISX0213_2(0xf372),	JISX0212(0xd327)),
	/* U+7C71 */	U2E_NODEST_COLX,
	/* U+7C72 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd328)),
	/* U+7C73 */	JISX0208(0xcac6),
	/* U+7C74 */	U2E_NODEST_COLX,
	/* U+7C75 */	JISX0208(0xe4e2),
	/* U+7C76 */	U2E_NODEST_COLX,
	/* U+7C77 */	U2E_NODEST_COLX,
	/* U+7C78 */	U2E_NODEST_COLX,
	/* U+7C79 */	IFX0213(JISX0213_1(0xf9f1),	JISX0212(0xd329)),
	/* U+7C7A */	U2E_NODEST_COLX,
	/* U+7C7B */	U2E_NODEST_COLX,
	/* U+7C7C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd32a)),
	/* U+7C7D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd32b)),
	/* U+7C7E */	JISX0208(0xcce2),
	/* U+7C7F */	U2E_NODEST_COLX,
	/* U+7C80 */	U2E_NODEST_COLX,
	/* U+7C81 */	JISX0208(0xb6ce),
	/* U+7C82 */	JISX0208(0xb7a9),
	/* U+7C83 */	JISX0208(0xe4e3),
	/* U+7C84 */	U2E_NODEST_COLX,
	/* U+7C85 */	U2E_NODEST_COLX,
	/* U+7C86 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd32c)),
	/* U+7C87 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd32d)),
	/* U+7C88 */	U2E_NODEST_COLX,
	/* U+7C89 */	JISX0208(0xcab4),
	/* U+7C8A */	U2E_NODEST_COLX,
	/* U+7C8B */	JISX0208(0xbfe8),
	/* U+7C8C */	U2E_NODEST_COLX,
	/* U+7C8D */	JISX0208(0xccb0),
	/* U+7C8E */	U2E_NODEST_COLX,
	/* U+7C8F */	IFX0213(JISX0213_1(0xf9f2),	JISX0212(0xd32e)),
	/* U+7C90 */	JISX0208(0xe4e4),
	/* U+7C91 */	U2E_NODEST_COLX,
	/* U+7C92 */	JISX0208(0xceb3),
	/* U+7C93 */	U2E_NODEST_COLX,
	/* U+7C94 */	IFX0213(JISX0213_1(0xf9f3),	JISX0212(0xd32f)),
	/* U+7C95 */	JISX0208(0xc7f4),
	/* U+7C96 */	U2E_NODEST_COLX,
	/* U+7C97 */	JISX0208(0xc1c6),
	/* U+7C98 */	JISX0208(0xc7b4),
	/* U+7C99 */	U2E_NODEST_COLX,
	/* U+7C9A */	U2E_NODEST_COLX,
	/* U+7C9B */	JISX0208(0xbdcd),
	/* U+7C9C */	U2E_NODEST_COLX,
	/* U+7C9D */	U2E_NODEST_COLX,
	/* U+7C9E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd330)),
	/* U+7C9F */	JISX0208(0xb0c0),
	/* U+7CA0 */	IFX0213(JISX0213_1(0xf9f4),	JISX0212(0xd331)),
	/* U+7CA1 */	JISX0208(0xe4e9),
	/* U+7CA2 */	JISX0208(0xe4e7),
	/* U+7CA3 */	U2E_NODEST_COLX,
	/* U+7CA4 */	JISX0208(0xe4e5),
	/* U+7CA5 */	JISX0208(0xb4a1),
	/* U+7CA6 */	IFX0213(JISX0213_2(0xf376),	JISX0212(0xd332)),
	/* U+7CA7 */	JISX0208(0xbed1),
	/* U+7CA8 */	JISX0208(0xe4ea),
	/* U+7CA9 */	U2E_NODEST_COLX,
	/* U+7CAA */	U2E_NODEST_COLX,
	/* U+7CAB */	JISX0208(0xe4e8),
	/* U+7CAC */	U2E_NODEST_COLX,
	/* U+7CAD */	JISX0208(0xe4e6),
	/* U+7CAE */	JISX0208(0xe4ee),
	/* U+7CAF */	U2E_NODEST_COLX,
	/* U+7CB0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd333)),
	/* U+7CB1 */	JISX0208(0xe4ed),
	/* U+7CB2 */	JISX0208(0xe4ec),
	/* U+7CB3 */	JISX0208(0xe4eb),
	/* U+7CB4 */	U2E_NODEST_COLX,
	/* U+7CB5 */	U2E_NODEST_COLX,
	/* U+7CB6 */	IFX0213(JISX0213_2(0xf378),	JISX0212(0xd334)),
	/* U+7CB7 */	IFX0213(JISX0213_2(0xf379),	JISX0212(0xd335)),
	/* U+7CB8 */	U2E_NODEST_COLX,
	/* U+7CB9 */	JISX0208(0xe4ef),
	/* U+7CBA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd336)),
	/* U+7CBB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd337)),
	/* U+7CBC */	IFX0213(JISX0213_1(0xf9f5),	JISX0212(0xd338)),
	/* U+7CBD */	JISX0208(0xe4f0),
	/* U+7CBE */	JISX0208(0xc0ba),
	/* U+7CBF */	IFX0213(JISX0213_2(0xf37a),	JISX0212(0xd339)),
	/* U+7CC0 */	JISX0208(0xe4f1),
	/* U+7CC1 */	U2E_NODEST_COLX,
	/* U+7CC2 */	JISX0208(0xe4f3),
	/* U+7CC3 */	U2E_NODEST_COLX,
	/* U+7CC4 */	IFX0213(JISX0213_2(0xf37c),	JISX0212(0xd33a)),
	/* U+7CC5 */	JISX0208(0xe4f2),
	/* U+7CC6 */	U2E_NODEST_COLX,
	/* U+7CC7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd33b)),
	/* U+7CC8 */	IFX0213(JISX0213_2(0xf37e),	JISX0212(0xd33c)),
	/* U+7CC9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd33d)),
	/* U+7CCA */	JISX0208(0xb8d2),
	/* U+7CCB */	U2E_NODEST_COLX,
	/* U+7CCC */	U2E_NODEST_COLX,
	/* U+7CCD */	IFX0213(JISX0213_2(0xf421),	JISX0212(0xd33e)),
	/* U+7CCE */	JISX0208(0xc1b8),
	/* U+7CCF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd33f)),
	/* U+7CD0 */	U2E_NODEST_COLX,
	/* U+7CD1 */	U2E_NODEST_COLX,
	/* U+7CD2 */	JISX0208(0xe4f5),
	/* U+7CD3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd340)),
	/* U+7CD4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd341)),
	/* U+7CD5 */	IFX0213(JISX0213_1(0xf9f6),	JISX0212(0xd342)),
	/* U+7CD6 */	JISX0208(0xc5fc),
	/* U+7CD7 */	IFX0213(JISX0213_2(0xf423),	JISX0212(0xd343)),
	/* U+7CD8 */	JISX0208(0xe4f4),
	/* U+7CD9 */	IFX0213(JISX0213_1(0xf9f7),	JISX0212(0xd344)),
	/* U+7CDA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd345)),
	/* U+7CDB */	U2E_NODEST_COLX,
	/* U+7CDC */	JISX0208(0xe4f6),
	/* U+7CDD */	IFX0213(JISX0213_1(0xf9f8),	JISX0212(0xd346)),
	/* U+7CDE */	JISX0208(0xcab5),
	/* U+7CDF */	JISX0208(0xc1ec),
	/* U+7CE0 */	JISX0208(0xb9c7),
	/* U+7CE1 */	U2E_NODEST_COLX,
	/* U+7CE2 */	JISX0208(0xe4f7),
	/* U+7CE3 */	U2E_NODEST_COLX,
	/* U+7CE4 */	U2E_NODEST_COLX,
	/* U+7CE5 */	U2E_NODEST_COLX,
	/* U+7CE6 */	IFX0213(JISX0213_2(0xf425),	JISX0212(0xd347)),
	/* U+7CE7 */	JISX0208(0xcec8),
	/* U+7CE8 */	U2E_NODEST_COLX,
	/* U+7CE9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd348)),
	/* U+7CEA */	U2E_NODEST_COLX,
	/* U+7CEB */	IFX0213(JISX0213_2(0xf426),	JISX0212(0xd349)),
	/* U+7CEC */	U2E_NODEST_COLX,
	/* U+7CED */	U2E_NODEST_COLX,
	/* U+7CEE */	U2E_NODEST_COLX,
	/* U+7CEF */	JISX0208(0xe4f9),
	/* U+7CF0 */	U2E_NODEST_COLX,
	/* U+7CF1 */	U2E_NODEST_COLX,
	/* U+7CF2 */	JISX0208(0xe4fa),
	/* U+7CF3 */	U2E_NODEST_COLX,
	/* U+7CF4 */	JISX0208(0xe4fb),
	/* U+7CF5 */	IFX0213(JISX0213_2(0xf428),	JISX0212(0xd34a)),
	/* U+7CF6 */	JISX0208(0xe4fc),
	/* U+7CF7 */	U2E_NODEST_COLX,
	/* U+7CF8 */	JISX0208(0xbbe5),
	/* U+7CF9 */	U2E_NODEST_COLX,
	/* U+7CFA */	JISX0208(0xe4fd),
	/* U+7CFB */	JISX0208(0xb7cf),
	/* U+7CFC */	U2E_NODEST_COLX,
	/* U+7CFD */	U2E_NODEST_COLX,
	/* U+7CFE */	JISX0208(0xb5ea),
	/* U+7CFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_7D[] = {
	/* U+7D00 */	JISX0208(0xb5aa),
	/* U+7D01 */	U2E_NODEST_COLX,
	/* U+7D02 */	JISX0208(0xe5a1),
	/* U+7D03 */	IFX0213(JISX0213_2(0xf429),	JISX0212(0xd34b)),
	/* U+7D04 */	JISX0208(0xccf3),
	/* U+7D05 */	JISX0208(0xb9c8),
	/* U+7D06 */	JISX0208(0xe4fe),
	/* U+7D07 */	IFX0213(JISX0213_1(0xf9f9),	JISX0212(0xd34c)),
	/* U+7D08 */	IFX0213(JISX0213_1(0xf9fa),	JISX0212(0xd34d)),
	/* U+7D09 */	IFX0213(JISX0213_2(0xf42a),	JISX0212(0xd34e)),
	/* U+7D0A */	JISX0208(0xe5a4),
	/* U+7D0B */	JISX0208(0xcce6),
	/* U+7D0C */	U2E_NODEST_COLX,
	/* U+7D0D */	JISX0208(0xc7bc),
	/* U+7D0E */	U2E_NODEST_COLX,
	/* U+7D0F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd34f)),
	/* U+7D10 */	JISX0208(0xc9b3),
	/* U+7D11 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd350)),
	/* U+7D12 */	IFX0213(JISX0213_2(0xf42c),	JISX0212(0xd351)),
	/* U+7D13 */	IFX0213(JISX0213_1(0xf9fb),	JISX0212(0xd352)),
	/* U+7D14 */	JISX0208(0xbde3),
	/* U+7D15 */	JISX0208(0xe5a3),
	/* U+7D16 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd353)),
	/* U+7D17 */	JISX0208(0xbcd3),
	/* U+7D18 */	JISX0208(0xb9c9),
	/* U+7D19 */	JISX0208(0xbbe6),
	/* U+7D1A */	JISX0208(0xb5e9),
	/* U+7D1B */	JISX0208(0xcab6),
	/* U+7D1C */	JISX0208(0xe5a2),
	/* U+7D1D */	IFX0213(JISX0213_1(0xf9fc),	JISX0212(0xd354)),
	/* U+7D1E */	IFX0213(JISX0213_2(0xf42d),	JISX0212(0xd355)),
	/* U+7D1F */	U2E_NODEST_COLX,
	/* U+7D20 */	JISX0208(0xc1c7),
	/* U+7D21 */	JISX0208(0xcbc2),
	/* U+7D22 */	JISX0208(0xbaf7),
	/* U+7D23 */	IFX0213(JISX0213_1(0xf9fd),	JISX0212(0xd356)),
	/* U+7D24 */	U2E_NODEST_COLX,
	/* U+7D25 */	U2E_NODEST_COLX,
	/* U+7D26 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd357)),
	/* U+7D27 */	U2E_NODEST_COLX,
	/* U+7D28 */	U2E_NODEST_COLX,
	/* U+7D29 */	U2E_NODEST_COLX,
	/* U+7D2A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd358)),
	/* U+7D2B */	JISX0208(0xbbe7),
	/* U+7D2C */	JISX0208(0xc4dd),
	/* U+7D2D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd359)),
	/* U+7D2E */	JISX0208(0xe5a7),
	/* U+7D2F */	JISX0208(0xcedf),
	/* U+7D30 */	JISX0208(0xbad9),
	/* U+7D31 */	IFX0213(JISX0213_1(0xf9fe),	JISX0212(0xd35a)),
	/* U+7D32 */	JISX0208(0xe5a8),
	/* U+7D33 */	JISX0208(0xbfc2),
	/* U+7D34 */	U2E_NODEST_COLX,
	/* U+7D35 */	JISX0208(0xe5aa),
	/* U+7D36 */	U2E_NODEST_COLX,
	/* U+7D37 */	U2E_NODEST_COLX,
	/* U+7D38 */	U2E_NODEST_COLX,
	/* U+7D39 */	JISX0208(0xbed2),
	/* U+7D3A */	JISX0208(0xbab0),
	/* U+7D3B */	U2E_NODEST_COLX,
	/* U+7D3C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd35b)),
	/* U+7D3D */	IFX0213(JISX0213_2(0xf430),	JISX0212(0xd35c)),
	/* U+7D3E */	IFX0213(JISX0213_2(0xf431),	JISX0212(0xd35d)),
	/* U+7D3F */	JISX0208(0xe5a9),
	/* U+7D40 */	IFX0213(JISX0213_2(0xf432),	JISX0212(0xd35e)),
	/* U+7D41 */	IFX0213(JISX0213_1(0xfaa1),	JISX0212(0xd35f)),
	/* U+7D42 */	JISX0208(0xbdaa),
	/* U+7D43 */	JISX0208(0xb8be),
	/* U+7D44 */	JISX0208(0xc1c8),
	/* U+7D45 */	JISX0208(0xe5a5),
	/* U+7D46 */	JISX0208(0xe5ab),
	/* U+7D47 */	IFX0213(JISX0213_2(0xf433),	JISX0212(0xd360)),
	/* U+7D48 */	IFX0213(JISX0213_1(0xfaa2),	JISX0212(0xd361)),
	/* U+7D49 */	U2E_NODEST_COLX,
	/* U+7D4A */	U2E_NODEST_COLX,
	/* U+7D4B */	JISX0208(0xe5a6),
	/* U+7D4C */	JISX0208(0xb7d0),
	/* U+7D4D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd362)),
	/* U+7D4E */	JISX0208(0xe5ae),
	/* U+7D4F */	JISX0208(0xe5b2),
	/* U+7D50 */	JISX0208(0xb7eb),
	/* U+7D51 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd363)),
	/* U+7D52 */	U2E_NODEST_COLX,
	/* U+7D53 */	IFX0213(JISX0213_1(0xfaa3),	JISX0212(0xd364)),
	/* U+7D54 */	U2E_NODEST_COLX,
	/* U+7D55 */	U2E_NODEST_COLX,
	/* U+7D56 */	JISX0208(0xe5ad),
	/* U+7D57 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd365)),
	/* U+7D58 */	U2E_NODEST_COLX,
	/* U+7D59 */	IFX0213(JISX0213_2(0xf437),	JISX0212(0xd366)),
	/* U+7D5A */	IFX0213(JISX0213_2(0xf438),	JISX0212(0xd367)),
	/* U+7D5B */	JISX0208(0xe5b6),
	/* U+7D5C */	IFX0213(JISX0213_1(0xfaa4),	JISX0212(0xd368)),
	/* U+7D5D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd369)),
	/* U+7D5E */	JISX0208(0xb9ca),
	/* U+7D5F */	U2E_NODEST_COLX,
	/* U+7D60 */	U2E_NODEST_COLX,
	/* U+7D61 */	JISX0208(0xcded),
	/* U+7D62 */	JISX0208(0xb0bc),
	/* U+7D63 */	JISX0208(0xe5b3),
	/* U+7D64 */	U2E_NODEST_COLX,
	/* U+7D65 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd36a)),
	/* U+7D66 */	JISX0208(0xb5eb),
	/* U+7D67 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd36b)),
	/* U+7D68 */	JISX0208(0xe5b0),
	/* U+7D69 */	U2E_NODEST_COLX,
	/* U+7D6A */	IFX0213(JISX0213_2(0xf439),	JISX0212(0xd36c)),
	/* U+7D6B */	U2E_NODEST_COLX,
	/* U+7D6C */	U2E_NODEST_COLX,
	/* U+7D6D */	U2E_NODEST_COLX,
	/* U+7D6E */	JISX0208(0xe5b1),
	/* U+7D6F */	U2E_NODEST_COLX,
	/* U+7D70 */	IFX0213(JISX0213_2(0xf43a),	JISX0212(0xd36d)),
	/* U+7D71 */	JISX0208(0xc5fd),
	/* U+7D72 */	JISX0208(0xe5af),
	/* U+7D73 */	JISX0208(0xe5ac),
	/* U+7D74 */	U2E_NODEST_COLX,
	/* U+7D75 */	JISX0208(0xb3a8),
	/* U+7D76 */	JISX0208(0xc0e4),
	/* U+7D77 */	U2E_NODEST_COLX,
	/* U+7D78 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd36e)),
	/* U+7D79 */	JISX0208(0xb8a8),
	/* U+7D7A */	IFX0213(JISX0213_1(0xfaa5),	JISX0212(0xd36f)),
	/* U+7D7B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd370)),
	/* U+7D7C */	U2E_NODEST_COLX,
	/* U+7D7D */	JISX0208(0xe5b8),
	/* U+7D7E */	U2E_NODEST_COLX,
	/* U+7D7F */	IFX0213(JISX0213_2(0xf43c),	JISX0212(0xd371)),
	/* U+7D80 */	U2E_NODEST_COLX,
	/* U+7D81 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd372)),
	/* U+7D82 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd373)),
	/* U+7D83 */	IFX0213(JISX0213_1(0xfaa6),	JISX0212(0xd374)),
	/* U+7D84 */	U2E_NODEST_COLX,
	/* U+7D85 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd375)),
	/* U+7D86 */	IFX0213(JISX0213_2(0xf43e),	JISX0212(0xd376)),
	/* U+7D87 */	U2E_NODEST_COLX,
	/* U+7D88 */	IFX0213(JISX0213_2(0xf43f),	JISX0212(0xd377)),
	/* U+7D89 */	JISX0208(0xe5b5),
	/* U+7D8A */	U2E_NODEST_COLX,
	/* U+7D8B */	IFX0213(JISX0213_1(0xfaa7),	JISX0212(0xd378)),
	/* U+7D8C */	IFX0213(JISX0213_2(0xf440),	JISX0212(0xd379)),
	/* U+7D8D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd37a)),
	/* U+7D8E */	U2E_NODEST_COLX,
	/* U+7D8F */	JISX0208(0xe5b7),
	/* U+7D90 */	U2E_NODEST_COLX,
	/* U+7D91 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd37b)),
	/* U+7D92 */	U2E_NODEST_COLX,
	/* U+7D93 */	JISX0208(0xe5b4),
	/* U+7D94 */	U2E_NODEST_COLX,
	/* U+7D95 */	U2E_NODEST_COLX,
	/* U+7D96 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd37c)),
	/* U+7D97 */	IFX0213(JISX0213_2(0xf441),	JISX0212(0xd37d)),
	/* U+7D98 */	U2E_NODEST_COLX,
	/* U+7D99 */	JISX0208(0xb7d1),
	/* U+7D9A */	JISX0208(0xc2b3),
	/* U+7D9B */	JISX0208(0xe5b9),
	/* U+7D9C */	JISX0208(0xc1ee),
	/* U+7D9D */	IFX0213(JISX0213_2(0xf443),	JISX0212(0xd37e)),
	/* U+7D9E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd421)),
	/* U+7D9F */	JISX0208(0xe5c6),
	/* U+7DA0 */	IFX0213(JISX0213_1(0xfaa8),	IBM(0xf45c)),
	/* U+7DA1 */	U2E_NODEST_COLX,
	/* U+7DA2 */	JISX0208(0xe5c2),
	/* U+7DA3 */	JISX0208(0xe5bc),
	/* U+7DA4 */	U2E_NODEST_COLX,
	/* U+7DA5 */	U2E_NODEST_COLX,
	/* U+7DA6 */	IFX0213(JISX0213_1(0xfaa9),	JISX0212(0xd422)),
	/* U+7DA7 */	IFX0213(JISX0213_2(0xf444),	JISX0212(0xd423)),
	/* U+7DA8 */	U2E_NODEST_COLX,
	/* U+7DA9 */	U2E_NODEST_COLX,
	/* U+7DAA */	IFX0213(JISX0213_2(0xf445),	JISX0212(0xd424)),
	/* U+7DAB */	JISX0208(0xe5c0),
	/* U+7DAC */	JISX0208(0xbcfa),
	/* U+7DAD */	JISX0208(0xb0dd),
	/* U+7DAE */	JISX0208(0xe5bb),
	/* U+7DAF */	JISX0208(0xe5c3),
	/* U+7DB0 */	JISX0208(0xe5c7),
	/* U+7DB1 */	JISX0208(0xb9cb),
	/* U+7DB2 */	JISX0208(0xccd6),
	/* U+7DB3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd425)),
	/* U+7DB4 */	JISX0208(0xc4d6),
	/* U+7DB5 */	JISX0208(0xe5bd),
	/* U+7DB6 */	IFX0213(JISX0213_2(0xf446),	JISX0212(0xd426)),
	/* U+7DB7 */	IFX0213(JISX0213_2(0xf447),	JISX0212(0xd427)),
	/* U+7DB8 */	JISX0208(0xe5c5),
	/* U+7DB9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd428)),
	/* U+7DBA */	JISX0208(0xe5ba),
	/* U+7DBB */	JISX0208(0xc3be),
	/* U+7DBC */	U2E_NODEST_COLX,
	/* U+7DBD */	JISX0208(0xe5bf),
	/* U+7DBE */	JISX0208(0xb0bd),
	/* U+7DBF */	JISX0208(0xccca),
	/* U+7DC0 */	IFX0213(JISX0213_2(0xf448),	U2E_NODEST_COLX),
	/* U+7DC1 */	U2E_NODEST_COLX,
	/* U+7DC2 */	IFX0213(JISX0213_1(0xfaaa),	JISX0212(0xd429)),
	/* U+7DC3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd42a)),
	/* U+7DC4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd42b)),
	/* U+7DC5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd42c)),
	/* U+7DC6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd42d)),
	/* U+7DC7 */	JISX0208(0xe5be),
	/* U+7DC8 */	U2E_NODEST_COLX,
	/* U+7DC9 */	U2E_NODEST_COLX,
	/* U+7DCA */	JISX0208(0xb6db),
	/* U+7DCB */	JISX0208(0xc8ec),
	/* U+7DCC */	IFX0213(JISX0213_1(0xfaab),	JISX0212(0xd42e)),
	/* U+7DCD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd42f)),
	/* U+7DCE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd430)),
	/* U+7DCF */	JISX0208(0xc1ed),
	/* U+7DD0 */	U2E_NODEST_COLX,
	/* U+7DD1 */	JISX0208(0xced0),
	/* U+7DD2 */	JISX0208(0xbdef),
	/* U+7DD3 */	U2E_NODEST_COLX,
	/* U+7DD4 */	U2E_NODEST_COLX,
	/* U+7DD5 */	JISX0208(0xe5ee),
	/* U+7DD6 */	IFX0213(JISX0213_1(0xfaac),	IBM(0xf45d)),
	/* U+7DD7 */	IFX0213(JISX0213_2(0xf449),	JISX0212(0xd431)),
	/* U+7DD8 */	JISX0208(0xe5c8),
	/* U+7DD9 */	IFX0213(JISX0213_2(0xf44a),	JISX0212(0xd432)),
	/* U+7DDA */	JISX0208(0xc0fe),
	/* U+7DDB */	U2E_NODEST_COLX,
	/* U+7DDC */	JISX0208(0xe5c4),
	/* U+7DDD */	JISX0208(0xe5c9),
	/* U+7DDE */	JISX0208(0xe5cb),
	/* U+7DDF */	U2E_NODEST_COLX,
	/* U+7DE0 */	JISX0208(0xc4f9),
	/* U+7DE1 */	JISX0208(0xe5ce),
	/* U+7DE2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd434)),
	/* U+7DE3 */	IFX0213(JISX0213_1(0xfaad),	U2E_NODEST_COLX),
	/* U+7DE4 */	JISX0208(0xe5ca),
	/* U+7DE5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd435)),
	/* U+7DE6 */	IFX0213(JISX0213_2(0xf44b),	JISX0212(0xd436)),
	/* U+7DE7 */	U2E_NODEST_COLX,
	/* U+7DE8 */	JISX0208(0xcad4),
	/* U+7DE9 */	JISX0208(0xb4cb),
	/* U+7DEA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd437)),
	/* U+7DEB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd438)),
	/* U+7DEC */	JISX0208(0xcccb),
	/* U+7DED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd439)),
	/* U+7DEE */	U2E_NODEST_COLX,
	/* U+7DEF */	JISX0208(0xb0de),
	/* U+7DF0 */	U2E_NODEST_COLX,
	/* U+7DF1 */	IFX0213(JISX0213_2(0xf44c),	JISX0212(0xd43a)),
	/* U+7DF2 */	JISX0208(0xe5cd),
	/* U+7DF3 */	U2E_NODEST_COLX,
	/* U+7DF4 */	JISX0208(0xcefd),
	/* U+7DF5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd43b)),
	/* U+7DF6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd43c)),
	/* U+7DF7 */	U2E_NODEST_COLX,
	/* U+7DF8 */	U2E_NODEST_COLX,
	/* U+7DF9 */	IFX0213(JISX0213_2(0xf44d),	JISX0212(0xd43d)),
	/* U+7DFA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd43e)),
	/* U+7DFB */	JISX0208(0xe5cc),
	/* U+7DFC */	U2E_NODEST_COLX,
	/* U+7DFD */	U2E_NODEST_COLX,
	/* U+7DFE */	U2E_NODEST_COLX,
	/* U+7DFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_7E[] = {
	/* U+7E00 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd433)),
	/* U+7E01 */	JISX0208(0xb1ef),
	/* U+7E02 */	U2E_NODEST_COLX,
	/* U+7E03 */	U2E_NODEST_COLX,
	/* U+7E04 */	JISX0208(0xc6ec),
	/* U+7E05 */	JISX0208(0xe5cf),
	/* U+7E06 */	U2E_NODEST_COLX,
	/* U+7E07 */	U2E_NODEST_COLX,
	/* U+7E08 */	IFX0213(JISX0213_1(0xfab0),	JISX0212(0xd43f)),
	/* U+7E09 */	JISX0208(0xe5d6),
	/* U+7E0A */	JISX0208(0xe5d0),
	/* U+7E0B */	JISX0208(0xe5d7),
	/* U+7E0C */	U2E_NODEST_COLX,
	/* U+7E0D */	U2E_NODEST_COLX,
	/* U+7E0E */	U2E_NODEST_COLX,
	/* U+7E0F */	U2E_NODEST_COLX,
	/* U+7E10 */	IFX0213(JISX0213_2(0xf451),	JISX0212(0xd440)),
	/* U+7E11 */	IFX0213(JISX0213_1(0xfab1),	JISX0212(0xd441)),
	/* U+7E12 */	JISX0208(0xe5d3),
	/* U+7E13 */	U2E_NODEST_COLX,
	/* U+7E14 */	U2E_NODEST_COLX,
	/* U+7E15 */	IFX0213(JISX0213_1(0xfab2),	JISX0212(0xd442)),
	/* U+7E16 */	U2E_NODEST_COLX,
	/* U+7E17 */	IFX0213(JISX0213_2(0xf452),	JISX0212(0xd443)),
	/* U+7E18 */	U2E_NODEST_COLX,
	/* U+7E19 */	U2E_NODEST_COLX,
	/* U+7E1A */	U2E_NODEST_COLX,
	/* U+7E1B */	JISX0208(0xc7fb),
	/* U+7E1C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd444)),
	/* U+7E1D */	IFX0213(JISX0213_2(0xf453),	JISX0212(0xd445)),
	/* U+7E1E */	JISX0208(0xbcca),
	/* U+7E1F */	JISX0208(0xe5d5),
	/* U+7E20 */	IFX0213(JISX0213_2(0xf454),	JISX0212(0xd446)),
	/* U+7E21 */	JISX0208(0xe5d2),
	/* U+7E22 */	JISX0208(0xe5d8),
	/* U+7E23 */	JISX0208(0xe5d1),
	/* U+7E24 */	U2E_NODEST_COLX,
	/* U+7E25 */	U2E_NODEST_COLX,
	/* U+7E26 */	JISX0208(0xbdc4),
	/* U+7E27 */	IFX0213(JISX0213_2(0xf455),	JISX0212(0xd447)),
	/* U+7E28 */	IFX0213(JISX0213_1(0xfaaf),	JISX0212(0xd448)),
	/* U+7E29 */	U2E_NODEST_COLX,
	/* U+7E2A */	U2E_NODEST_COLX,
	/* U+7E2B */	JISX0208(0xcba5),
	/* U+7E2C */	IFX0213(JISX0213_2(0xf456),	JISX0212(0xd449)),
	/* U+7E2D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd44a)),
	/* U+7E2E */	JISX0208(0xbdcc),
	/* U+7E2F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd44b)),
	/* U+7E30 */	U2E_NODEST_COLX,
	/* U+7E31 */	JISX0208(0xe5d4),
	/* U+7E32 */	JISX0208(0xe5e0),
	/* U+7E33 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd44c)),
	/* U+7E34 */	U2E_NODEST_COLX,
	/* U+7E35 */	JISX0208(0xe5dc),
	/* U+7E36 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd44d)),
	/* U+7E37 */	JISX0208(0xe5df),
	/* U+7E38 */	U2E_NODEST_COLX,
	/* U+7E39 */	JISX0208(0xe5dd),
	/* U+7E3A */	JISX0208(0xe5e1),
	/* U+7E3B */	JISX0208(0xe5db),
	/* U+7E3C */	U2E_NODEST_COLX,
	/* U+7E3D */	JISX0208(0xe5c1),
	/* U+7E3E */	JISX0208(0xc0d3),
	/* U+7E3F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd44e)),
	/* U+7E40 */	U2E_NODEST_COLX,
	/* U+7E41 */	JISX0208(0xc8cb),
	/* U+7E42 */	U2E_NODEST_COLX,
	/* U+7E43 */	JISX0208(0xe5de),
	/* U+7E44 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd44f)),
	/* U+7E45 */	IFX0213(JISX0213_2(0xf457),	JISX0212(0xd450)),
	/* U+7E46 */	JISX0208(0xe5d9),
	/* U+7E47 */	IFX0213(JISX0213_1(0xfab4),	JISX0212(0xd451)),
	/* U+7E48 */	U2E_NODEST_COLX,
	/* U+7E49 */	U2E_NODEST_COLX,
	/* U+7E4A */	JISX0208(0xc1a1),
	/* U+7E4B */	JISX0208(0xb7d2),
	/* U+7E4C */	U2E_NODEST_COLX,
	/* U+7E4D */	JISX0208(0xbdab),
	/* U+7E4E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd452)),
	/* U+7E4F */	U2E_NODEST_COLX,
	/* U+7E50 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd453)),
	/* U+7E51 */	U2E_NODEST_COLX,
	/* U+7E52 */	IFX0213(JISX0213_1(0xfab5),	JISX0212(0xd454)),
	/* U+7E53 */	U2E_NODEST_COLX,
	/* U+7E54 */	JISX0208(0xbfa5),
	/* U+7E55 */	JISX0208(0xc1b6),
	/* U+7E56 */	JISX0208(0xe5e4),
	/* U+7E57 */	U2E_NODEST_COLX,
	/* U+7E58 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd455)),
	/* U+7E59 */	JISX0208(0xe5e6),
	/* U+7E5A */	JISX0208(0xe5e7),
	/* U+7E5B */	U2E_NODEST_COLX,
	/* U+7E5C */	U2E_NODEST_COLX,
	/* U+7E5D */	JISX0208(0xe5e3),
	/* U+7E5E */	JISX0208(0xe5e5),
	/* U+7E5F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd456)),
	/* U+7E60 */	U2E_NODEST_COLX,
	/* U+7E61 */	IFX0213(JISX0213_1(0xfab6),	JISX0212(0xd457)),
	/* U+7E62 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd458)),
	/* U+7E63 */	U2E_NODEST_COLX,
	/* U+7E64 */	U2E_NODEST_COLX,
	/* U+7E65 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd459)),
	/* U+7E66 */	JISX0208(0xe5da),
	/* U+7E67 */	JISX0208(0xe5e2),
	/* U+7E68 */	U2E_NODEST_COLX,
	/* U+7E69 */	JISX0208(0xe5ea),
	/* U+7E6A */	JISX0208(0xe5e9),
	/* U+7E6B */	IFX0213(JISX0213_1(0xfefe),	JISX0212(0xd45a)),
	/* U+7E6C */	U2E_NODEST_COLX,
	/* U+7E6D */	JISX0208(0xcbfa),
	/* U+7E6E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd45b)),
	/* U+7E6F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd45c)),
	/* U+7E70 */	JISX0208(0xb7ab),
	/* U+7E71 */	U2E_NODEST_COLX,
	/* U+7E72 */	U2E_NODEST_COLX,
	/* U+7E73 */	IFX0213(JISX0213_2(0xf458),	JISX0212(0xd45d)),
	/* U+7E74 */	U2E_NODEST_COLX,
	/* U+7E75 */	IFX0213(JISX0213_2(0xf459),	U2E_NODEST_COLX),
	/* U+7E76 */	U2E_NODEST_COLX,
	/* U+7E77 */	U2E_NODEST_COLX,
	/* U+7E78 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd45e)),
	/* U+7E79 */	JISX0208(0xe5e8),
	/* U+7E7A */	U2E_NODEST_COLX,
	/* U+7E7B */	JISX0208(0xe5ec),
	/* U+7E7C */	JISX0208(0xe5eb),
	/* U+7E7D */	JISX0208(0xe5ef),
	/* U+7E7E */	IFX0213(JISX0213_2(0xf45a),	JISX0212(0xd45f)),
	/* U+7E7F */	JISX0208(0xe5f1),
	/* U+7E80 */	U2E_NODEST_COLX,
	/* U+7E81 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd460)),
	/* U+7E82 */	JISX0208(0xbbbc),
	/* U+7E83 */	JISX0208(0xe5ed),
	/* U+7E84 */	U2E_NODEST_COLX,
	/* U+7E85 */	U2E_NODEST_COLX,
	/* U+7E86 */	IFX0213(JISX0213_2(0xf45b),	JISX0212(0xd461)),
	/* U+7E87 */	IFX0213(JISX0213_2(0xf45c),	JISX0212(0xd462)),
	/* U+7E88 */	JISX0208(0xe5f2),
	/* U+7E89 */	JISX0208(0xe5f3),
	/* U+7E8A */	IFX0213(JISX0213_1(0xfab7),	JISX0212(0xd463)),
	/* U+7E8B */	U2E_NODEST_COLX,
	/* U+7E8C */	JISX0208(0xe5f4),
	/* U+7E8D */	IFX0213(JISX0213_1(0xfab8),	JISX0212(0xd464)),
	/* U+7E8E */	JISX0208(0xe5fa),
	/* U+7E8F */	JISX0208(0xc5bb),
	/* U+7E90 */	JISX0208(0xe5f6),
	/* U+7E91 */	IFX0213(JISX0213_2(0xf45e),	JISX0212(0xd465)),
	/* U+7E92 */	JISX0208(0xe5f5),
	/* U+7E93 */	JISX0208(0xe5f7),
	/* U+7E94 */	JISX0208(0xe5f8),
	/* U+7E95 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd466)),
	/* U+7E96 */	JISX0208(0xe5f9),
	/* U+7E97 */	U2E_NODEST_COLX,
	/* U+7E98 */	IFX0213(JISX0213_2(0xf45f),	JISX0212(0xd467)),
	/* U+7E99 */	U2E_NODEST_COLX,
	/* U+7E9A */	IFX0213(JISX0213_2(0xf460),	JISX0212(0xd468)),
	/* U+7E9B */	JISX0208(0xe5fb),
	/* U+7E9C */	JISX0208(0xe5fc),
	/* U+7E9D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd469)),
	/* U+7E9E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd46a)),
	/* U+7E9F */	U2E_NODEST_COLX,
	/* U+7EA0 */	U2E_NODEST_COLX,
	/* U+7EA1 */	U2E_NODEST_COLX,
	/* U+7EA2 */	U2E_NODEST_COLX,
	/* U+7EA3 */	U2E_NODEST_COLX,
	/* U+7EA4 */	U2E_NODEST_COLX,
	/* U+7EA5 */	U2E_NODEST_COLX,
	/* U+7EA6 */	U2E_NODEST_COLX,
	/* U+7EA7 */	U2E_NODEST_COLX,
	/* U+7EA8 */	U2E_NODEST_COLX,
	/* U+7EA9 */	U2E_NODEST_COLX,
	/* U+7EAA */	U2E_NODEST_COLX,
	/* U+7EAB */	U2E_NODEST_COLX,
	/* U+7EAC */	U2E_NODEST_COLX,
	/* U+7EAD */	U2E_NODEST_COLX,
	/* U+7EAE */	U2E_NODEST_COLX,
	/* U+7EAF */	U2E_NODEST_COLX,
	/* U+7EB0 */	U2E_NODEST_COLX,
	/* U+7EB1 */	U2E_NODEST_COLX,
	/* U+7EB2 */	U2E_NODEST_COLX,
	/* U+7EB3 */	U2E_NODEST_COLX,
	/* U+7EB4 */	U2E_NODEST_COLX,
	/* U+7EB5 */	U2E_NODEST_COLX,
	/* U+7EB6 */	U2E_NODEST_COLX,
	/* U+7EB7 */	U2E_NODEST_COLX,
	/* U+7EB8 */	U2E_NODEST_COLX,
	/* U+7EB9 */	U2E_NODEST_COLX,
	/* U+7EBA */	U2E_NODEST_COLX,
	/* U+7EBB */	U2E_NODEST_COLX,
	/* U+7EBC */	U2E_NODEST_COLX,
	/* U+7EBD */	U2E_NODEST_COLX,
	/* U+7EBE */	U2E_NODEST_COLX,
	/* U+7EBF */	U2E_NODEST_COLX,
	/* U+7EC0 */	U2E_NODEST_COLX,
	/* U+7EC1 */	U2E_NODEST_COLX,
	/* U+7EC2 */	U2E_NODEST_COLX,
	/* U+7EC3 */	U2E_NODEST_COLX,
	/* U+7EC4 */	U2E_NODEST_COLX,
	/* U+7EC5 */	U2E_NODEST_COLX,
	/* U+7EC6 */	U2E_NODEST_COLX,
	/* U+7EC7 */	U2E_NODEST_COLX,
	/* U+7EC8 */	U2E_NODEST_COLX,
	/* U+7EC9 */	U2E_NODEST_COLX,
	/* U+7ECA */	U2E_NODEST_COLX,
	/* U+7ECB */	U2E_NODEST_COLX,
	/* U+7ECC */	U2E_NODEST_COLX,
	/* U+7ECD */	U2E_NODEST_COLX,
	/* U+7ECE */	U2E_NODEST_COLX,
	/* U+7ECF */	U2E_NODEST_COLX,
	/* U+7ED0 */	U2E_NODEST_COLX,
	/* U+7ED1 */	U2E_NODEST_COLX,
	/* U+7ED2 */	U2E_NODEST_COLX,
	/* U+7ED3 */	U2E_NODEST_COLX,
	/* U+7ED4 */	U2E_NODEST_COLX,
	/* U+7ED5 */	U2E_NODEST_COLX,
	/* U+7ED6 */	U2E_NODEST_COLX,
	/* U+7ED7 */	U2E_NODEST_COLX,
	/* U+7ED8 */	U2E_NODEST_COLX,
	/* U+7ED9 */	U2E_NODEST_COLX,
	/* U+7EDA */	U2E_NODEST_COLX,
	/* U+7EDB */	U2E_NODEST_COLX,
	/* U+7EDC */	U2E_NODEST_COLX,
	/* U+7EDD */	U2E_NODEST_COLX,
	/* U+7EDE */	U2E_NODEST_COLX,
	/* U+7EDF */	U2E_NODEST_COLX,
	/* U+7EE0 */	U2E_NODEST_COLX,
	/* U+7EE1 */	U2E_NODEST_COLX,
	/* U+7EE2 */	U2E_NODEST_COLX,
	/* U+7EE3 */	U2E_NODEST_COLX,
	/* U+7EE4 */	U2E_NODEST_COLX,
	/* U+7EE5 */	U2E_NODEST_COLX,
	/* U+7EE6 */	U2E_NODEST_COLX,
	/* U+7EE7 */	U2E_NODEST_COLX,
	/* U+7EE8 */	U2E_NODEST_COLX,
	/* U+7EE9 */	U2E_NODEST_COLX,
	/* U+7EEA */	U2E_NODEST_COLX,
	/* U+7EEB */	U2E_NODEST_COLX,
	/* U+7EEC */	U2E_NODEST_COLX,
	/* U+7EED */	U2E_NODEST_COLX,
	/* U+7EEE */	U2E_NODEST_COLX,
	/* U+7EEF */	U2E_NODEST_COLX,
	/* U+7EF0 */	U2E_NODEST_COLX,
	/* U+7EF1 */	U2E_NODEST_COLX,
	/* U+7EF2 */	U2E_NODEST_COLX,
	/* U+7EF3 */	U2E_NODEST_COLX,
	/* U+7EF4 */	U2E_NODEST_COLX,
	/* U+7EF5 */	U2E_NODEST_COLX,
	/* U+7EF6 */	U2E_NODEST_COLX,
	/* U+7EF7 */	U2E_NODEST_COLX,
	/* U+7EF8 */	U2E_NODEST_COLX,
	/* U+7EF9 */	U2E_NODEST_COLX,
	/* U+7EFA */	U2E_NODEST_COLX,
	/* U+7EFB */	U2E_NODEST_COLX,
	/* U+7EFC */	U2E_NODEST_COLX,
	/* U+7EFD */	U2E_NODEST_COLX,
	/* U+7EFE */	U2E_NODEST_COLX,
	/* U+7EFF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_7F[] = {
	/* U+7F00 */	U2E_NODEST_COLX,
	/* U+7F01 */	U2E_NODEST_COLX,
	/* U+7F02 */	U2E_NODEST_COLX,
	/* U+7F03 */	U2E_NODEST_COLX,
	/* U+7F04 */	U2E_NODEST_COLX,
	/* U+7F05 */	U2E_NODEST_COLX,
	/* U+7F06 */	U2E_NODEST_COLX,
	/* U+7F07 */	U2E_NODEST_COLX,
	/* U+7F08 */	U2E_NODEST_COLX,
	/* U+7F09 */	U2E_NODEST_COLX,
	/* U+7F0A */	U2E_NODEST_COLX,
	/* U+7F0B */	U2E_NODEST_COLX,
	/* U+7F0C */	U2E_NODEST_COLX,
	/* U+7F0D */	U2E_NODEST_COLX,
	/* U+7F0E */	U2E_NODEST_COLX,
	/* U+7F0F */	U2E_NODEST_COLX,
	/* U+7F10 */	U2E_NODEST_COLX,
	/* U+7F11 */	U2E_NODEST_COLX,
	/* U+7F12 */	U2E_NODEST_COLX,
	/* U+7F13 */	U2E_NODEST_COLX,
	/* U+7F14 */	U2E_NODEST_COLX,
	/* U+7F15 */	U2E_NODEST_COLX,
	/* U+7F16 */	U2E_NODEST_COLX,
	/* U+7F17 */	U2E_NODEST_COLX,
	/* U+7F18 */	U2E_NODEST_COLX,
	/* U+7F19 */	U2E_NODEST_COLX,
	/* U+7F1A */	U2E_NODEST_COLX,
	/* U+7F1B */	U2E_NODEST_COLX,
	/* U+7F1C */	U2E_NODEST_COLX,
	/* U+7F1D */	U2E_NODEST_COLX,
	/* U+7F1E */	U2E_NODEST_COLX,
	/* U+7F1F */	U2E_NODEST_COLX,
	/* U+7F20 */	U2E_NODEST_COLX,
	/* U+7F21 */	U2E_NODEST_COLX,
	/* U+7F22 */	U2E_NODEST_COLX,
	/* U+7F23 */	U2E_NODEST_COLX,
	/* U+7F24 */	U2E_NODEST_COLX,
	/* U+7F25 */	U2E_NODEST_COLX,
	/* U+7F26 */	U2E_NODEST_COLX,
	/* U+7F27 */	U2E_NODEST_COLX,
	/* U+7F28 */	U2E_NODEST_COLX,
	/* U+7F29 */	U2E_NODEST_COLX,
	/* U+7F2A */	U2E_NODEST_COLX,
	/* U+7F2B */	U2E_NODEST_COLX,
	/* U+7F2C */	U2E_NODEST_COLX,
	/* U+7F2D */	U2E_NODEST_COLX,
	/* U+7F2E */	U2E_NODEST_COLX,
	/* U+7F2F */	U2E_NODEST_COLX,
	/* U+7F30 */	U2E_NODEST_COLX,
	/* U+7F31 */	U2E_NODEST_COLX,
	/* U+7F32 */	U2E_NODEST_COLX,
	/* U+7F33 */	U2E_NODEST_COLX,
	/* U+7F34 */	U2E_NODEST_COLX,
	/* U+7F35 */	U2E_NODEST_COLX,
	/* U+7F36 */	JISX0208(0xb4cc),
	/* U+7F37 */	U2E_NODEST_COLX,
	/* U+7F38 */	JISX0208(0xe5fd),
	/* U+7F39 */	U2E_NODEST_COLX,
	/* U+7F3A */	JISX0208(0xe5fe),
	/* U+7F3B */	IFX0213(JISX0213_2(0xf463),	JISX0212(0xd46c)),
	/* U+7F3C */	IFX0213(JISX0213_2(0xf462),	JISX0212(0xd46b)),
	/* U+7F3D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd46d)),
	/* U+7F3E */	IFX0213(JISX0213_2(0xf464),	JISX0212(0xd46e)),
	/* U+7F3F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd46f)),
	/* U+7F40 */	U2E_NODEST_COLX,
	/* U+7F41 */	U2E_NODEST_COLX,
	/* U+7F42 */	U2E_NODEST_COLX,
	/* U+7F43 */	IFX0213(JISX0213_2(0xf465),	JISX0212(0xd470)),
	/* U+7F44 */	IFX0213(JISX0213_2(0xf466),	JISX0212(0xd471)),
	/* U+7F45 */	JISX0208(0xe6a1),
	/* U+7F46 */	U2E_NODEST_COLX,
	/* U+7F47 */	IFX0213(JISX0213_1(0xfab9),	JISX0212(0xd472)),
	/* U+7F48 */	U2E_NODEST_COLX,
	/* U+7F49 */	U2E_NODEST_COLX,
	/* U+7F4A */	U2E_NODEST_COLX,
	/* U+7F4B */	U2E_NODEST_COLX,
	/* U+7F4C */	JISX0208(0xe6a2),
	/* U+7F4D */	JISX0208(0xe6a3),
	/* U+7F4E */	JISX0208(0xe6a4),
	/* U+7F4F */	IFX0213(JISX0213_2(0xf467),	JISX0212(0xd473)),
	/* U+7F50 */	JISX0208(0xe6a5),
	/* U+7F51 */	JISX0208(0xe6a6),
	/* U+7F52 */	IFX0213(JISX0213_2(0xf46a),	JISX0212(0xd474)),
	/* U+7F53 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd475)),
	/* U+7F54 */	JISX0208(0xe6a8),
	/* U+7F55 */	JISX0208(0xe6a7),
	/* U+7F56 */	U2E_NODEST_COLX,
	/* U+7F57 */	U2E_NODEST_COLX,
	/* U+7F58 */	JISX0208(0xe6a9),
	/* U+7F59 */	U2E_NODEST_COLX,
	/* U+7F5A */	U2E_NODEST_COLX,
	/* U+7F5B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd476)),
	/* U+7F5C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd477)),
	/* U+7F5D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd478)),
	/* U+7F5E */	U2E_NODEST_COLX,
	/* U+7F5F */	JISX0208(0xe6aa),
	/* U+7F60 */	JISX0208(0xe6ab),
	/* U+7F61 */	IFX0213(JISX0213_2(0xf46c),	JISX0212(0xd479)),
	/* U+7F62 */	U2E_NODEST_COLX,
	/* U+7F63 */	IFX0213(JISX0213_2(0xf46d),	JISX0212(0xd47a)),
	/* U+7F64 */	IFX0213(JISX0213_2(0xf46e),	JISX0212(0xd47b)),
	/* U+7F65 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd47c)),
	/* U+7F66 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd47d)),
	/* U+7F67 */	JISX0208(0xe6ae),
	/* U+7F68 */	JISX0208(0xe6ac),
	/* U+7F69 */	JISX0208(0xe6ad),
	/* U+7F6A */	JISX0208(0xbae1),
	/* U+7F6B */	JISX0208(0xb7d3),
	/* U+7F6C */	U2E_NODEST_COLX,
	/* U+7F6D */	IFX0213(JISX0213_2(0xf46f),	JISX0212(0xd47e)),
	/* U+7F6E */	JISX0208(0xc3d6),
	/* U+7F6F */	U2E_NODEST_COLX,
	/* U+7F70 */	JISX0208(0xc8b3),
	/* U+7F71 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd521)),
	/* U+7F72 */	JISX0208(0xbdf0),
	/* U+7F73 */	U2E_NODEST_COLX,
	/* U+7F74 */	U2E_NODEST_COLX,
	/* U+7F75 */	JISX0208(0xc7cd),
	/* U+7F76 */	U2E_NODEST_COLX,
	/* U+7F77 */	JISX0208(0xc8ed),
	/* U+7F78 */	JISX0208(0xe6af),
	/* U+7F79 */	JISX0208(0xd8ed),
	/* U+7F7A */	U2E_NODEST_COLX,
	/* U+7F7B */	U2E_NODEST_COLX,
	/* U+7F7C */	U2E_NODEST_COLX,
	/* U+7F7D */	IFX0213(JISX0213_2(0xf470),	JISX0212(0xd522)),
	/* U+7F7E */	IFX0213(JISX0213_2(0xf471),	JISX0212(0xd523)),
	/* U+7F7F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd524)),
	/* U+7F80 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd525)),
	/* U+7F81 */	U2E_NODEST_COLX,
	/* U+7F82 */	JISX0208(0xe6b0),
	/* U+7F83 */	JISX0208(0xe6b2),
	/* U+7F84 */	U2E_NODEST_COLX,
	/* U+7F85 */	JISX0208(0xcde5),
	/* U+7F86 */	JISX0208(0xe6b1),
	/* U+7F87 */	JISX0208(0xe6b4),
	/* U+7F88 */	JISX0208(0xe6b3),
	/* U+7F89 */	U2E_NODEST_COLX,
	/* U+7F8A */	JISX0208(0xcdd3),
	/* U+7F8B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd526)),
	/* U+7F8C */	JISX0208(0xe6b5),
	/* U+7F8D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd527)),
	/* U+7F8E */	JISX0208(0xc8fe),
	/* U+7F8F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd528)),
	/* U+7F90 */	IFX0213(JISX0213_2(0xf473),	JISX0212(0xd529)),
	/* U+7F91 */	IFX0213(JISX0213_1(0xfabb),	JISX0212(0xd52a)),
	/* U+7F92 */	U2E_NODEST_COLX,
	/* U+7F93 */	U2E_NODEST_COLX,
	/* U+7F94 */	JISX0208(0xe6b6),
	/* U+7F95 */	U2E_NODEST_COLX,
	/* U+7F96 */	IFX0213(JISX0213_2(0xf476),	JISX0212(0xd52b)),
	/* U+7F97 */	IFX0213(JISX0213_1(0xfabc),	JISX0212(0xd52c)),
	/* U+7F98 */	U2E_NODEST_COLX,
	/* U+7F99 */	U2E_NODEST_COLX,
	/* U+7F9A */	JISX0208(0xe6b9),
	/* U+7F9B */	U2E_NODEST_COLX,
	/* U+7F9C */	IFX0213(JISX0213_2(0xf477),	JISX0212(0xd52d)),
	/* U+7F9D */	JISX0208(0xe6b8),
	/* U+7F9E */	JISX0208(0xe6b7),
	/* U+7F9F */	U2E_NODEST_COLX,
	/* U+7FA0 */	U2E_NODEST_COLX,
	/* U+7FA1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd52e)),
	/* U+7FA2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd52f)),
	/* U+7FA3 */	JISX0208(0xe6ba),
	/* U+7FA4 */	JISX0208(0xb7b2),
	/* U+7FA5 */	U2E_NODEST_COLX,
	/* U+7FA6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd530)),
	/* U+7FA7 */	U2E_NODEST_COLX,
	/* U+7FA8 */	JISX0208(0xc1a2),
	/* U+7FA9 */	JISX0208(0xb5c1),
	/* U+7FAA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd531)),
	/* U+7FAB */	U2E_NODEST_COLX,
	/* U+7FAC */	U2E_NODEST_COLX,
	/* U+7FAD */	IFX0213(JISX0213_2(0xf478),	JISX0212(0xd532)),
	/* U+7FAE */	JISX0208(0xe6be),
	/* U+7FAF */	JISX0208(0xe6bb),
	/* U+7FB0 */	U2E_NODEST_COLX,
	/* U+7FB1 */	U2E_NODEST_COLX,
	/* U+7FB2 */	JISX0208(0xe6bc),
	/* U+7FB3 */	U2E_NODEST_COLX,
	/* U+7FB4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd533)),
	/* U+7FB5 */	U2E_NODEST_COLX,
	/* U+7FB6 */	JISX0208(0xe6bf),
	/* U+7FB7 */	U2E_NODEST_COLX,
	/* U+7FB8 */	JISX0208(0xe6c0),
	/* U+7FB9 */	JISX0208(0xe6bd),
	/* U+7FBA */	U2E_NODEST_COLX,
	/* U+7FBB */	U2E_NODEST_COLX,
	/* U+7FBC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd534)),
	/* U+7FBD */	JISX0208(0xb1a9),
	/* U+7FBE */	U2E_NODEST_COLX,
	/* U+7FBF */	IFX0213(JISX0213_1(0xfabd),	JISX0212(0xd535)),
	/* U+7FC0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd536)),
	/* U+7FC1 */	JISX0208(0xb2a7),
	/* U+7FC2 */	U2E_NODEST_COLX,
	/* U+7FC3 */	IFX0213(JISX0213_2(0xf47a),	JISX0212(0xd537)),
	/* U+7FC4 */	U2E_NODEST_COLX,
	/* U+7FC5 */	JISX0208(0xe6c2),
	/* U+7FC6 */	JISX0208(0xe6c3),
	/* U+7FC7 */	U2E_NODEST_COLX,
	/* U+7FC8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd538)),
	/* U+7FC9 */	U2E_NODEST_COLX,
	/* U+7FCA */	JISX0208(0xe6c4),
	/* U+7FCB */	U2E_NODEST_COLX,
	/* U+7FCC */	JISX0208(0xcde2),
	/* U+7FCD */	U2E_NODEST_COLX,
	/* U+7FCE */	IFX0213(JISX0213_1(0xfabe),	JISX0212(0xd539)),
	/* U+7FCF */	IFX0213(JISX0213_2(0xf47b),	JISX0212(0xd53a)),
	/* U+7FD0 */	U2E_NODEST_COLX,
	/* U+7FD1 */	U2E_NODEST_COLX,
	/* U+7FD2 */	JISX0208(0xbdac),
	/* U+7FD3 */	U2E_NODEST_COLX,
	/* U+7FD4 */	JISX0208(0xe6c6),
	/* U+7FD5 */	JISX0208(0xe6c5),
	/* U+7FD6 */	U2E_NODEST_COLX,
	/* U+7FD7 */	U2E_NODEST_COLX,
	/* U+7FD8 */	U2E_NODEST_COLX,
	/* U+7FD9 */	U2E_NODEST_COLX,
	/* U+7FDA */	U2E_NODEST_COLX,
	/* U+7FDB */	IFX0213(JISX0213_1(0xfabf),	JISX0212(0xd53b)),
	/* U+7FDC */	U2E_NODEST_COLX,
	/* U+7FDD */	U2E_NODEST_COLX,
	/* U+7FDE */	U2E_NODEST_COLX,
	/* U+7FDF */	IFX0213(JISX0213_1(0xfac0),	JISX0212(0xd53c)),
	/* U+7FE0 */	JISX0208(0xbfe9),
	/* U+7FE1 */	JISX0208(0xe6c7),
	/* U+7FE2 */	U2E_NODEST_COLX,
	/* U+7FE3 */	IFX0213(JISX0213_2(0xf47c),	JISX0212(0xd53d)),
	/* U+7FE4 */	U2E_NODEST_COLX,
	/* U+7FE5 */	IFX0213(JISX0213_2(0xf47d),	JISX0212(0xd53e)),
	/* U+7FE6 */	JISX0208(0xe6c8),
	/* U+7FE7 */	U2E_NODEST_COLX,
	/* U+7FE8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd53f)),
	/* U+7FE9 */	JISX0208(0xe6c9),
	/* U+7FEA */	U2E_NODEST_COLX,
	/* U+7FEB */	JISX0208(0xb4e5),
	/* U+7FEC */	IFX0213(JISX0213_1(0xfac1),	JISX0212(0xd540)),
	/* U+7FED */	U2E_NODEST_COLX,
	/* U+7FEE */	IFX0213(JISX0213_1(0xfac2),	JISX0212(0xd541)),
	/* U+7FEF */	IFX0213(JISX0213_2(0xf47e),	JISX0212(0xd542)),
	/* U+7FF0 */	JISX0208(0xb4cd),
	/* U+7FF1 */	U2E_NODEST_COLX,
	/* U+7FF2 */	IFX0213(JISX0213_2(0xf521),	JISX0212(0xd543)),
	/* U+7FF3 */	JISX0208(0xe6ca),
	/* U+7FF4 */	U2E_NODEST_COLX,
	/* U+7FF5 */	U2E_NODEST_COLX,
	/* U+7FF6 */	U2E_NODEST_COLX,
	/* U+7FF7 */	U2E_NODEST_COLX,
	/* U+7FF8 */	U2E_NODEST_COLX,
	/* U+7FF9 */	JISX0208(0xe6cb),
	/* U+7FFA */	IFX0213(JISX0213_1(0xfac3),	JISX0212(0xd544)),
	/* U+7FFB */	JISX0208(0xcbdd),
	/* U+7FFC */	JISX0208(0xcde3),
	/* U+7FFD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd545)),
	/* U+7FFE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd546)),
	/* U+7FFF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd547)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_80[] = {
	/* U+8000 */	JISX0208(0xcdd4),
	/* U+8001 */	JISX0208(0xcfb7),
	/* U+8002 */	IFX0213(JISX0213_2(0xf522),	U2E_NODEST_COLX),
	/* U+8003 */	JISX0208(0xb9cd),
	/* U+8004 */	JISX0208(0xe6ce),
	/* U+8005 */	JISX0208(0xbcd4),
	/* U+8006 */	JISX0208(0xe6cd),
	/* U+8007 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd548)),
	/* U+8008 */	IFX0213(JISX0213_2(0xf524),	JISX0212(0xd549)),
	/* U+8009 */	U2E_NODEST_COLX,
	/* U+800A */	IFX0213(JISX0213_2(0xf523),	JISX0212(0xd54a)),
	/* U+800B */	JISX0208(0xe6cf),
	/* U+800C */	JISX0208(0xbca9),
	/* U+800D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd54b)),
	/* U+800E */	IFX0213(JISX0213_2(0xf525),	JISX0212(0xd54c)),
	/* U+800F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd54d)),
	/* U+8010 */	JISX0208(0xc2d1),
	/* U+8011 */	IFX0213(JISX0213_2(0xf526),	JISX0212(0xd54e)),
	/* U+8012 */	JISX0208(0xe6d0),
	/* U+8013 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd54f)),
	/* U+8014 */	IFX0213(JISX0213_1(0xfac5),	JISX0212(0xd550)),
	/* U+8015 */	JISX0208(0xb9cc),
	/* U+8016 */	IFX0213(JISX0213_2(0xf527),	JISX0212(0xd551)),
	/* U+8017 */	JISX0208(0xccd7),
	/* U+8018 */	JISX0208(0xe6d1),
	/* U+8019 */	JISX0208(0xe6d2),
	/* U+801A */	U2E_NODEST_COLX,
	/* U+801B */	U2E_NODEST_COLX,
	/* U+801C */	JISX0208(0xe6d3),
	/* U+801D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd552)),
	/* U+801E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd553)),
	/* U+801F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd554)),
	/* U+8020 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd555)),
	/* U+8021 */	JISX0208(0xe6d4),
	/* U+8022 */	U2E_NODEST_COLX,
	/* U+8023 */	U2E_NODEST_COLX,
	/* U+8024 */	IFX0213(JISX0213_2(0xf528),	JISX0212(0xd556)),
	/* U+8025 */	U2E_NODEST_COLX,
	/* U+8026 */	IFX0213(JISX0213_1(0xfac6),	JISX0212(0xd557)),
	/* U+8027 */	U2E_NODEST_COLX,
	/* U+8028 */	JISX0208(0xe6d5),
	/* U+8029 */	U2E_NODEST_COLX,
	/* U+802A */	U2E_NODEST_COLX,
	/* U+802B */	U2E_NODEST_COLX,
	/* U+802C */	IFX0213(JISX0213_2(0xf529),	JISX0212(0xd558)),
	/* U+802D */	U2E_NODEST_COLX,
	/* U+802E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd559)),
	/* U+802F */	U2E_NODEST_COLX,
	/* U+8030 */	IFX0213(JISX0213_2(0xf52a),	JISX0212(0xd55a)),
	/* U+8031 */	U2E_NODEST_COLX,
	/* U+8032 */	U2E_NODEST_COLX,
	/* U+8033 */	JISX0208(0xbcaa),
	/* U+8034 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd55b)),
	/* U+8035 */	IFX0213(JISX0213_1(0xfac7),	JISX0212(0xd55c)),
	/* U+8036 */	JISX0208(0xcced),
	/* U+8037 */	IFX0213(JISX0213_1(0xfac8),	JISX0212(0xd55d)),
	/* U+8038 */	U2E_NODEST_COLX,
	/* U+8039 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd55e)),
	/* U+803A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd55f)),
	/* U+803B */	JISX0208(0xe6d7),
	/* U+803C */	IFX0213(JISX0213_1(0xfac9),	JISX0212(0xd560)),
	/* U+803D */	JISX0208(0xc3bf),
	/* U+803E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd561)),
	/* U+803F */	JISX0208(0xe6d6),
	/* U+8040 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd562)),
	/* U+8041 */	U2E_NODEST_COLX,
	/* U+8042 */	U2E_NODEST_COLX,
	/* U+8043 */	IFX0213(JISX0213_2(0xf52b),	U2E_NODEST_COLX),
	/* U+8044 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd563)),
	/* U+8045 */	U2E_NODEST_COLX,
	/* U+8046 */	JISX0208(0xe6d9),
	/* U+8047 */	U2E_NODEST_COLX,
	/* U+8048 */	U2E_NODEST_COLX,
	/* U+8049 */	U2E_NODEST_COLX,
	/* U+804A */	JISX0208(0xe6d8),
	/* U+804B */	U2E_NODEST_COLX,
	/* U+804C */	U2E_NODEST_COLX,
	/* U+804D */	U2E_NODEST_COLX,
	/* U+804E */	U2E_NODEST_COLX,
	/* U+804F */	U2E_NODEST_COLX,
	/* U+8050 */	U2E_NODEST_COLX,
	/* U+8051 */	U2E_NODEST_COLX,
	/* U+8052 */	JISX0208(0xe6da),
	/* U+8053 */	U2E_NODEST_COLX,
	/* U+8054 */	U2E_NODEST_COLX,
	/* U+8055 */	U2E_NODEST_COLX,
	/* U+8056 */	JISX0208(0xc0bb),
	/* U+8057 */	U2E_NODEST_COLX,
	/* U+8058 */	JISX0208(0xe6db),
	/* U+8059 */	U2E_NODEST_COLX,
	/* U+805A */	JISX0208(0xe6dc),
	/* U+805B */	U2E_NODEST_COLX,
	/* U+805C */	U2E_NODEST_COLX,
	/* U+805D */	U2E_NODEST_COLX,
	/* U+805E */	JISX0208(0xcab9),
	/* U+805F */	JISX0208(0xe6dd),
	/* U+8060 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd564)),
	/* U+8061 */	JISX0208(0xc1ef),
	/* U+8062 */	JISX0208(0xe6de),
	/* U+8063 */	U2E_NODEST_COLX,
	/* U+8064 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd565)),
	/* U+8065 */	U2E_NODEST_COLX,
	/* U+8066 */	IFX0213(JISX0213_2(0xf52c),	JISX0212(0xd566)),
	/* U+8067 */	U2E_NODEST_COLX,
	/* U+8068 */	JISX0208(0xe6df),
	/* U+8069 */	U2E_NODEST_COLX,
	/* U+806A */	U2E_NODEST_COLX,
	/* U+806B */	U2E_NODEST_COLX,
	/* U+806C */	U2E_NODEST_COLX,
	/* U+806D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd567)),
	/* U+806E */	U2E_NODEST_COLX,
	/* U+806F */	JISX0208(0xcefe),
	/* U+8070 */	JISX0208(0xe6e2),
	/* U+8071 */	IFX0213(JISX0213_2(0xf52d),	JISX0212(0xd568)),
	/* U+8072 */	JISX0208(0xe6e1),
	/* U+8073 */	JISX0208(0xe6e0),
	/* U+8074 */	JISX0208(0xc4b0),
	/* U+8075 */	IFX0213(JISX0213_2(0xf52e),	JISX0212(0xd569)),
	/* U+8076 */	JISX0208(0xe6e3),
	/* U+8077 */	JISX0208(0xbfa6),
	/* U+8078 */	U2E_NODEST_COLX,
	/* U+8079 */	JISX0208(0xe6e4),
	/* U+807A */	U2E_NODEST_COLX,
	/* U+807B */	IFX0213(JISX0213_2(0xf52f),	U2E_NODEST_COLX),
	/* U+807C */	U2E_NODEST_COLX,
	/* U+807D */	JISX0208(0xe6e5),
	/* U+807E */	JISX0208(0xcfb8),
	/* U+807F */	JISX0208(0xe6e6),
	/* U+8080 */	U2E_NODEST_COLX,
	/* U+8081 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd56a)),
	/* U+8082 */	U2E_NODEST_COLX,
	/* U+8083 */	U2E_NODEST_COLX,
	/* U+8084 */	JISX0208(0xe6e7),
	/* U+8085 */	JISX0208(0xe6e9),
	/* U+8086 */	JISX0208(0xe6e8),
	/* U+8087 */	JISX0208(0xc8a5),
	/* U+8088 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd56b)),
	/* U+8089 */	JISX0208(0xc6f9),
	/* U+808A */	U2E_NODEST_COLX,
	/* U+808B */	JISX0208(0xcfbe),
	/* U+808C */	JISX0208(0xc8a9),
	/* U+808D */	U2E_NODEST_COLX,
	/* U+808E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd56c)),
	/* U+808F */	U2E_NODEST_COLX,
	/* U+8090 */	U2E_NODEST_COLX,
	/* U+8091 */	U2E_NODEST_COLX,
	/* U+8092 */	U2E_NODEST_COLX,
	/* U+8093 */	JISX0208(0xe6eb),
	/* U+8094 */	U2E_NODEST_COLX,
	/* U+8095 */	U2E_NODEST_COLX,
	/* U+8096 */	JISX0208(0xbed3),
	/* U+8097 */	U2E_NODEST_COLX,
	/* U+8098 */	JISX0208(0xc9aa),
	/* U+8099 */	IFX0213(JISX0213_2(0xf530),	U2E_NODEST_COLX),
	/* U+809A */	JISX0208(0xe6ec),
	/* U+809B */	JISX0208(0xe6ea),
	/* U+809C */	IFX0213(JISX0213_2(0xf531),	JISX0212(0xd56d)),
	/* U+809D */	JISX0208(0xb4ce),
	/* U+809E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd56e)),
	/* U+809F */	U2E_NODEST_COLX,
	/* U+80A0 */	U2E_NODEST_COLX,
	/* U+80A1 */	JISX0208(0xb8d4),
	/* U+80A2 */	JISX0208(0xbbe8),
	/* U+80A3 */	U2E_NODEST_COLX,
	/* U+80A4 */	U2E_NODEST_COLX,
	/* U+80A5 */	JISX0208(0xc8ee),
	/* U+80A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd56f)),
	/* U+80A7 */	IFX0213(JISX0213_2(0xf533),	JISX0212(0xd570)),
	/* U+80A8 */	U2E_NODEST_COLX,
	/* U+80A9 */	JISX0208(0xb8aa),
	/* U+80AA */	JISX0208(0xcbc3),
	/* U+80AB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd571)),
	/* U+80AC */	JISX0208(0xe6ef),
	/* U+80AD */	JISX0208(0xe6ed),
	/* U+80AE */	U2E_NODEST_COLX,
	/* U+80AF */	JISX0208(0xb9ce),
	/* U+80B0 */	U2E_NODEST_COLX,
	/* U+80B1 */	JISX0208(0xb9cf),
	/* U+80B2 */	JISX0208(0xb0e9),
	/* U+80B3 */	U2E_NODEST_COLX,
	/* U+80B4 */	JISX0208(0xbae8),
	/* U+80B5 */	U2E_NODEST_COLX,
	/* U+80B6 */	U2E_NODEST_COLX,
	/* U+80B7 */	U2E_NODEST_COLX,
	/* U+80B8 */	IFX0213(JISX0213_2(0xf534),	JISX0212(0xd572)),
	/* U+80B9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd573)),
	/* U+80BA */	JISX0208(0xc7d9),
	/* U+80BB */	U2E_NODEST_COLX,
	/* U+80BC */	U2E_NODEST_COLX,
	/* U+80BD */	U2E_NODEST_COLX,
	/* U+80BE */	U2E_NODEST_COLX,
	/* U+80BF */	U2E_NODEST_COLX,
	/* U+80C0 */	U2E_NODEST_COLX,
	/* U+80C1 */	U2E_NODEST_COLX,
	/* U+80C2 */	U2E_NODEST_COLX,
	/* U+80C3 */	JISX0208(0xb0df),
	/* U+80C4 */	JISX0208(0xe6f4),
	/* U+80C5 */	IFX0213(JISX0213_2(0xf536),	U2E_NODEST_COLX),
	/* U+80C6 */	JISX0208(0xc3c0),
	/* U+80C7 */	U2E_NODEST_COLX,
	/* U+80C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd574)),
	/* U+80C9 */	U2E_NODEST_COLX,
	/* U+80CA */	IFX0213(JISX0213_1(0xfaca),	U2E_NODEST_COLX),
	/* U+80CB */	U2E_NODEST_COLX,
	/* U+80CC */	JISX0208(0xc7d8),
	/* U+80CD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd575)),
	/* U+80CE */	JISX0208(0xc2db),
	/* U+80CF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd576)),
	/* U+80D0 */	U2E_NODEST_COLX,
	/* U+80D1 */	U2E_NODEST_COLX,
	/* U+80D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd577)),
	/* U+80D3 */	U2E_NODEST_COLX,
	/* U+80D4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd578)),
	/* U+80D5 */	IFX0213(JISX0213_2(0xf537),	JISX0212(0xd579)),
	/* U+80D6 */	JISX0208(0xe6f6),
	/* U+80D7 */	IFX0213(JISX0213_1(0xfacb),	JISX0212(0xd57a)),
	/* U+80D8 */	IFX0213(JISX0213_2(0xf538),	JISX0212(0xd57b)),
	/* U+80D9 */	JISX0208(0xe6f2),
	/* U+80DA */	JISX0208(0xe6f5),
	/* U+80DB */	JISX0208(0xe6f0),
	/* U+80DC */	U2E_NODEST_COLX,
	/* U+80DD */	JISX0208(0xe6f3),
	/* U+80DE */	JISX0208(0xcba6),
	/* U+80DF */	U2E_NODEST_COLX,
	/* U+80E0 */	IFX0213(JISX0213_1(0xfacc),	JISX0212(0xd57c)),
	/* U+80E1 */	JISX0208(0xb8d5),
	/* U+80E2 */	U2E_NODEST_COLX,
	/* U+80E3 */	U2E_NODEST_COLX,
	/* U+80E4 */	JISX0208(0xb0fd),
	/* U+80E5 */	JISX0208(0xe6f1),
	/* U+80E6 */	IFX0213(JISX0213_2(0xf539),	U2E_NODEST_COLX),
	/* U+80E7 */	U2E_NODEST_COLX,
	/* U+80E8 */	U2E_NODEST_COLX,
	/* U+80E9 */	U2E_NODEST_COLX,
	/* U+80EA */	U2E_NODEST_COLX,
	/* U+80EB */	U2E_NODEST_COLX,
	/* U+80EC */	U2E_NODEST_COLX,
	/* U+80ED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd57d)),
	/* U+80EE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd57e)),
	/* U+80EF */	JISX0208(0xe6f8),
	/* U+80F0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd621)),
	/* U+80F1 */	JISX0208(0xe6f9),
	/* U+80F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd622)),
	/* U+80F3 */	IFX0213(JISX0213_1(0xfacd),	JISX0212(0xd623)),
	/* U+80F4 */	JISX0208(0xc6b9),
	/* U+80F5 */	IFX0213(JISX0213_2(0xf53c),	U2E_NODEST_COLX),
	/* U+80F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd624)),
	/* U+80F7 */	U2E_NODEST_COLX,
	/* U+80F8 */	JISX0208(0xb6bb),
	/* U+80F9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd625)),
	/* U+80FA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd626)),
	/* U+80FB */	IFX0213(JISX0213_2(0xf53d),	U2E_NODEST_COLX),
	/* U+80FC */	JISX0208(0xe7a6),
	/* U+80FD */	JISX0208(0xc7bd),
	/* U+80FE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd627)),
	/* U+80FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_81[] = {
	/* U+8100 */	U2E_NODEST_COLX,
	/* U+8101 */	U2E_NODEST_COLX,
	/* U+8102 */	JISX0208(0xbbe9),
	/* U+8103 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd628)),
	/* U+8104 */	U2E_NODEST_COLX,
	/* U+8105 */	JISX0208(0xb6bc),
	/* U+8106 */	JISX0208(0xc0c8),
	/* U+8107 */	JISX0208(0xcfc6),
	/* U+8108 */	JISX0208(0xccae),
	/* U+8109 */	JISX0208(0xe6f7),
	/* U+810A */	JISX0208(0xc0d4),
	/* U+810B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd629)),
	/* U+810C */	U2E_NODEST_COLX,
	/* U+810D */	IFX0213(JISX0213_2(0xf53b),	U2E_NODEST_COLX),
	/* U+810E */	U2E_NODEST_COLX,
	/* U+810F */	U2E_NODEST_COLX,
	/* U+8110 */	U2E_NODEST_COLX,
	/* U+8111 */	U2E_NODEST_COLX,
	/* U+8112 */	U2E_NODEST_COLX,
	/* U+8113 */	U2E_NODEST_COLX,
	/* U+8114 */	U2E_NODEST_COLX,
	/* U+8115 */	U2E_NODEST_COLX,
	/* U+8116 */	IFX0213(JISX0213_2(0xf540),	JISX0212(0xd62a)),
	/* U+8117 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd62b)),
	/* U+8118 */	IFX0213(JISX0213_1(0xface),	JISX0212(0xd62c)),
	/* U+8119 */	U2E_NODEST_COLX,
	/* U+811A */	JISX0208(0xb5d3),
	/* U+811B */	JISX0208(0xe6fa),
	/* U+811C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd62d)),
	/* U+811D */	U2E_NODEST_COLX,
	/* U+811E */	IFX0213(JISX0213_2(0xf541),	JISX0212(0xd62e)),
	/* U+811F */	U2E_NODEST_COLX,
	/* U+8120 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd62f)),
	/* U+8121 */	U2E_NODEST_COLX,
	/* U+8122 */	U2E_NODEST_COLX,
	/* U+8123 */	JISX0208(0xe6fc),
	/* U+8124 */	IFX0213(JISX0213_2(0xf543),	JISX0212(0xd630)),
	/* U+8125 */	U2E_NODEST_COLX,
	/* U+8126 */	U2E_NODEST_COLX,
	/* U+8127 */	IFX0213(JISX0213_2(0xf544),	JISX0212(0xd631)),
	/* U+8128 */	U2E_NODEST_COLX,
	/* U+8129 */	JISX0208(0xe6fb),
	/* U+812A */	U2E_NODEST_COLX,
	/* U+812B */	U2E_NODEST_COLX,
	/* U+812C */	IFX0213(JISX0213_2(0xf545),	JISX0212(0xd632)),
	/* U+812D */	U2E_NODEST_COLX,
	/* U+812E */	U2E_NODEST_COLX,
	/* U+812F */	JISX0208(0xe6fd),
	/* U+8130 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd633)),
	/* U+8131 */	JISX0208(0xc3a6),
	/* U+8132 */	U2E_NODEST_COLX,
	/* U+8133 */	JISX0208(0xc7be),
	/* U+8134 */	U2E_NODEST_COLX,
	/* U+8135 */	IFX0213(JISX0213_2(0xf53f),	JISX0212(0xd634)),
	/* U+8136 */	U2E_NODEST_COLX,
	/* U+8137 */	U2E_NODEST_COLX,
	/* U+8138 */	U2E_NODEST_COLX,
	/* U+8139 */	JISX0208(0xc4b1),
	/* U+813A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd635)),
	/* U+813B */	U2E_NODEST_COLX,
	/* U+813C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd636)),
	/* U+813D */	IFX0213(JISX0213_2(0xf547),	U2E_NODEST_COLX),
	/* U+813E */	JISX0208(0xe7a3),
	/* U+813F */	U2E_NODEST_COLX,
	/* U+8140 */	U2E_NODEST_COLX,
	/* U+8141 */	U2E_NODEST_COLX,
	/* U+8142 */	U2E_NODEST_COLX,
	/* U+8143 */	U2E_NODEST_COLX,
	/* U+8144 */	U2E_NODEST_COLX,
	/* U+8145 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd637)),
	/* U+8146 */	JISX0208(0xe7a2),
	/* U+8147 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd638)),
	/* U+8148 */	U2E_NODEST_COLX,
	/* U+8149 */	U2E_NODEST_COLX,
	/* U+814A */	IFX0213(JISX0213_1(0xfacf),	JISX0212(0xd639)),
	/* U+814B */	JISX0208(0xe6fe),
	/* U+814C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd63a)),
	/* U+814D */	U2E_NODEST_COLX,
	/* U+814E */	JISX0208(0xbfd5),
	/* U+814F */	U2E_NODEST_COLX,
	/* U+8150 */	JISX0208(0xc9e5),
	/* U+8151 */	JISX0208(0xe7a5),
	/* U+8152 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd63b)),
	/* U+8153 */	JISX0208(0xe7a4),
	/* U+8154 */	JISX0208(0xb9d0),
	/* U+8155 */	JISX0208(0xcfd3),
	/* U+8156 */	U2E_NODEST_COLX,
	/* U+8157 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd63c)),
	/* U+8158 */	U2E_NODEST_COLX,
	/* U+8159 */	U2E_NODEST_COLX,
	/* U+815A */	U2E_NODEST_COLX,
	/* U+815B */	U2E_NODEST_COLX,
	/* U+815C */	U2E_NODEST_COLX,
	/* U+815D */	U2E_NODEST_COLX,
	/* U+815E */	U2E_NODEST_COLX,
	/* U+815F */	JISX0208(0xe7b5),
	/* U+8160 */	IFX0213(JISX0213_1(0xfad0),	JISX0212(0xd63d)),
	/* U+8161 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd63e)),
	/* U+8162 */	U2E_NODEST_COLX,
	/* U+8163 */	U2E_NODEST_COLX,
	/* U+8164 */	U2E_NODEST_COLX,
	/* U+8165 */	JISX0208(0xe7a9),
	/* U+8166 */	JISX0208(0xe7aa),
	/* U+8167 */	IFX0213(JISX0213_1(0xfad1),	JISX0212(0xd63f)),
	/* U+8168 */	IFX0213(JISX0213_1(0xfad2),	JISX0212(0xd640)),
	/* U+8169 */	IFX0213(JISX0213_2(0xf549),	JISX0212(0xd641)),
	/* U+816A */	U2E_NODEST_COLX,
	/* U+816B */	JISX0208(0xbcf0),
	/* U+816C */	U2E_NODEST_COLX,
	/* U+816D */	IFX0213(JISX0213_1(0xfad3),	JISX0212(0xd642)),
	/* U+816E */	JISX0208(0xe7a8),
	/* U+816F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd643)),
	/* U+8170 */	JISX0208(0xb9f8),
	/* U+8171 */	JISX0208(0xe7a7),
	/* U+8172 */	U2E_NODEST_COLX,
	/* U+8173 */	U2E_NODEST_COLX,
	/* U+8174 */	JISX0208(0xe7ab),
	/* U+8175 */	U2E_NODEST_COLX,
	/* U+8176 */	U2E_NODEST_COLX,
	/* U+8177 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd644)),
	/* U+8178 */	JISX0208(0xc4b2),
	/* U+8179 */	JISX0208(0xcaa2),
	/* U+817A */	JISX0208(0xc1a3),
	/* U+817B */	U2E_NODEST_COLX,
	/* U+817C */	U2E_NODEST_COLX,
	/* U+817D */	U2E_NODEST_COLX,
	/* U+817E */	U2E_NODEST_COLX,
	/* U+817F */	JISX0208(0xc2dc),
	/* U+8180 */	JISX0208(0xe7af),
	/* U+8181 */	IFX0213(JISX0213_2(0xf54b),	JISX0212(0xd645)),
	/* U+8182 */	JISX0208(0xe7b0),
	/* U+8183 */	JISX0208(0xe7ac),
	/* U+8184 */	IFX0213(JISX0213_2(0xf54d),	JISX0212(0xd647)),
	/* U+8185 */	IFX0213(JISX0213_2(0xf54e),	JISX0212(0xd648)),
	/* U+8186 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd649)),
	/* U+8187 */	U2E_NODEST_COLX,
	/* U+8188 */	JISX0208(0xe7ad),
	/* U+8189 */	U2E_NODEST_COLX,
	/* U+818A */	JISX0208(0xe7ae),
	/* U+818B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd64a)),
	/* U+818C */	U2E_NODEST_COLX,
	/* U+818D */	U2E_NODEST_COLX,
	/* U+818E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd64b)),
	/* U+818F */	JISX0208(0xb9d1),
	/* U+8190 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd646)),
	/* U+8191 */	U2E_NODEST_COLX,
	/* U+8192 */	U2E_NODEST_COLX,
	/* U+8193 */	JISX0208(0xe7b6),
	/* U+8194 */	U2E_NODEST_COLX,
	/* U+8195 */	JISX0208(0xe7b2),
	/* U+8196 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd64c)),
	/* U+8197 */	U2E_NODEST_COLX,
	/* U+8198 */	IFX0213(JISX0213_2(0xf550),	JISX0212(0xd64d)),
	/* U+8199 */	U2E_NODEST_COLX,
	/* U+819A */	JISX0208(0xc9e6),
	/* U+819B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd64e)),
	/* U+819C */	JISX0208(0xcbec),
	/* U+819D */	JISX0208(0xc9a8),
	/* U+819E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd64f)),
	/* U+819F */	U2E_NODEST_COLX,
	/* U+81A0 */	JISX0208(0xe7b1),
	/* U+81A1 */	U2E_NODEST_COLX,
	/* U+81A2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd650)),
	/* U+81A3 */	JISX0208(0xe7b4),
	/* U+81A4 */	JISX0208(0xe7b3),
	/* U+81A5 */	U2E_NODEST_COLX,
	/* U+81A6 */	U2E_NODEST_COLX,
	/* U+81A7 */	U2E_NODEST_COLX,
	/* U+81A8 */	JISX0208(0xcbc4),
	/* U+81A9 */	JISX0208(0xe7b7),
	/* U+81AA */	U2E_NODEST_COLX,
	/* U+81AB */	U2E_NODEST_COLX,
	/* U+81AC */	U2E_NODEST_COLX,
	/* U+81AD */	U2E_NODEST_COLX,
	/* U+81AE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd651)),
	/* U+81AF */	U2E_NODEST_COLX,
	/* U+81B0 */	JISX0208(0xe7b8),
	/* U+81B1 */	U2E_NODEST_COLX,
	/* U+81B2 */	IFX0213(JISX0213_2(0xf551),	JISX0212(0xd652)),
	/* U+81B3 */	JISX0208(0xc1b7),
	/* U+81B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd653)),
	/* U+81B5 */	JISX0208(0xe7b9),
	/* U+81B6 */	U2E_NODEST_COLX,
	/* U+81B7 */	U2E_NODEST_COLX,
	/* U+81B8 */	JISX0208(0xe7bb),
	/* U+81B9 */	U2E_NODEST_COLX,
	/* U+81BA */	JISX0208(0xe7bf),
	/* U+81BB */	IFX0213(JISX0213_1(0xfad4),	JISX0212(0xd654)),
	/* U+81BC */	U2E_NODEST_COLX,
	/* U+81BD */	JISX0208(0xe7bc),
	/* U+81BE */	JISX0208(0xe7ba),
	/* U+81BF */	JISX0208(0xc7bf),
	/* U+81C0 */	JISX0208(0xe7bd),
	/* U+81C1 */	IFX0213(JISX0213_2(0xf552),	U2E_NODEST_COLX),
	/* U+81C2 */	JISX0208(0xe7be),
	/* U+81C3 */	IFX0213(JISX0213_2(0xf553),	JISX0212(0xd656)),
	/* U+81C4 */	U2E_NODEST_COLX,
	/* U+81C5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd657)),
	/* U+81C6 */	JISX0208(0xb2b2),
	/* U+81C7 */	U2E_NODEST_COLX,
	/* U+81C8 */	JISX0208(0xe7c5),
	/* U+81C9 */	JISX0208(0xe7c0),
	/* U+81CA */	IFX0213(JISX0213_1(0xfad5),	JISX0212(0xd658)),
	/* U+81CB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd655)),
	/* U+81CC */	U2E_NODEST_COLX,
	/* U+81CD */	JISX0208(0xe7c1),
	/* U+81CE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd659)),
	/* U+81CF */	IFX0213(JISX0213_1(0xfad6),	JISX0212(0xd65a)),
	/* U+81D0 */	U2E_NODEST_COLX,
	/* U+81D1 */	JISX0208(0xe7c2),
	/* U+81D2 */	U2E_NODEST_COLX,
	/* U+81D3 */	JISX0208(0xc2a1),
	/* U+81D4 */	U2E_NODEST_COLX,
	/* U+81D5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd65b)),
	/* U+81D6 */	IFX0213(JISX0213_2(0xf554),	U2E_NODEST_COLX),
	/* U+81D7 */	IFX0213(JISX0213_1(0xfad7),	JISX0212(0xd65c)),
	/* U+81D8 */	JISX0208(0xe7c4),
	/* U+81D9 */	JISX0208(0xe7c3),
	/* U+81DA */	JISX0208(0xe7c6),
	/* U+81DB */	IFX0213(JISX0213_2(0xf555),	JISX0212(0xd65d)),
	/* U+81DC */	U2E_NODEST_COLX,
	/* U+81DD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd65e)),
	/* U+81DE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd65f)),
	/* U+81DF */	JISX0208(0xe7c7),
	/* U+81E0 */	JISX0208(0xe7c8),
	/* U+81E1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd660)),
	/* U+81E2 */	U2E_NODEST_COLX,
	/* U+81E3 */	JISX0208(0xbfc3),
	/* U+81E4 */	IFX0213(JISX0213_2(0xf557),	JISX0212(0xd661)),
	/* U+81E5 */	JISX0208(0xb2e9),
	/* U+81E6 */	U2E_NODEST_COLX,
	/* U+81E7 */	JISX0208(0xe7c9),
	/* U+81E8 */	JISX0208(0xced7),
	/* U+81E9 */	U2E_NODEST_COLX,
	/* U+81EA */	JISX0208(0xbcab),
	/* U+81EB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd662)),
	/* U+81EC */	IFX0213(JISX0213_2(0xf559),	JISX0212(0xd663)),
	/* U+81ED */	JISX0208(0xbdad),
	/* U+81EE */	U2E_NODEST_COLX,
	/* U+81EF */	U2E_NODEST_COLX,
	/* U+81F0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd664)),
	/* U+81F1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd665)),
	/* U+81F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd666)),
	/* U+81F3 */	JISX0208(0xbbea),
	/* U+81F4 */	JISX0208(0xc3d7),
	/* U+81F5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd667)),
	/* U+81F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd668)),
	/* U+81F7 */	U2E_NODEST_COLX,
	/* U+81F8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd669)),
	/* U+81F9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd66a)),
	/* U+81FA */	JISX0208(0xe7ca),
	/* U+81FB */	JISX0208(0xe7cb),
	/* U+81FC */	JISX0208(0xb1b1),
	/* U+81FD */	IFX0213(JISX0213_2(0xf55b),	JISX0212(0xd66b)),
	/* U+81FE */	JISX0208(0xe7cc),
	/* U+81FF */	IFX0213(JISX0213_2(0xf55c),	JISX0212(0xd66c)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_82[] = {
	/* U+8200 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd66d)),
	/* U+8201 */	JISX0208(0xe7cd),
	/* U+8202 */	JISX0208(0xe7ce),
	/* U+8203 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd66e)),
	/* U+8204 */	IFX0213(JISX0213_2(0xf55e),	U2E_NODEST_COLX),
	/* U+8205 */	JISX0208(0xe7cf),
	/* U+8206 */	U2E_NODEST_COLX,
	/* U+8207 */	JISX0208(0xe7d0),
	/* U+8208 */	JISX0208(0xb6bd),
	/* U+8209 */	JISX0208(0xdaaa),
	/* U+820A */	JISX0208(0xe7d1),
	/* U+820B */	U2E_NODEST_COLX,
	/* U+820C */	JISX0208(0xc0e5),
	/* U+820D */	JISX0208(0xe7d2),
	/* U+820E */	JISX0208(0xbccb),
	/* U+820F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd66f)),
	/* U+8210 */	JISX0208(0xe7d3),
	/* U+8211 */	U2E_NODEST_COLX,
	/* U+8212 */	JISX0208(0xd0b0),
	/* U+8213 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd670)),
	/* U+8214 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd671)),
	/* U+8215 */	U2E_NODEST_COLX,
	/* U+8216 */	JISX0208(0xe7d4),
	/* U+8217 */	JISX0208(0xcade),
	/* U+8218 */	JISX0208(0xb4dc),
	/* U+8219 */	IFX0213(JISX0213_2(0xf560),	JISX0212(0xd672)),
	/* U+821A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd673)),
	/* U+821B */	JISX0208(0xc1a4),
	/* U+821C */	JISX0208(0xbdd8),
	/* U+821D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd674)),
	/* U+821E */	JISX0208(0xc9f1),
	/* U+821F */	JISX0208(0xbdae),
	/* U+8220 */	U2E_NODEST_COLX,
	/* U+8221 */	IFX0213(JISX0213_2(0xf561),	JISX0212(0xd675)),
	/* U+8222 */	IFX0213(JISX0213_2(0xf562),	JISX0212(0xd676)),
	/* U+8223 */	U2E_NODEST_COLX,
	/* U+8224 */	U2E_NODEST_COLX,
	/* U+8225 */	U2E_NODEST_COLX,
	/* U+8226 */	U2E_NODEST_COLX,
	/* U+8227 */	U2E_NODEST_COLX,
	/* U+8228 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd677)),
	/* U+8229 */	JISX0208(0xe7d5),
	/* U+822A */	JISX0208(0xb9d2),
	/* U+822B */	JISX0208(0xe7d6),
	/* U+822C */	JISX0208(0xc8cc),
	/* U+822D */	U2E_NODEST_COLX,
	/* U+822E */	JISX0208(0xe7e4),
	/* U+822F */	U2E_NODEST_COLX,
	/* U+8230 */	U2E_NODEST_COLX,
	/* U+8231 */	U2E_NODEST_COLX,
	/* U+8232 */	IFX0213(JISX0213_2(0xf564),	JISX0212(0xd678)),
	/* U+8233 */	JISX0208(0xe7d8),
	/* U+8234 */	IFX0213(JISX0213_2(0xf565),	JISX0212(0xd679)),
	/* U+8235 */	JISX0208(0xc2c9),
	/* U+8236 */	JISX0208(0xc7f5),
	/* U+8237 */	JISX0208(0xb8bf),
	/* U+8238 */	JISX0208(0xe7d7),
	/* U+8239 */	JISX0208(0xc1a5),
	/* U+823A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd67a)),
	/* U+823B */	U2E_NODEST_COLX,
	/* U+823C */	IFX0213(JISX0213_2(0xf566),	U2E_NODEST_COLX),
	/* U+823D */	U2E_NODEST_COLX,
	/* U+823E */	U2E_NODEST_COLX,
	/* U+823F */	U2E_NODEST_COLX,
	/* U+8240 */	JISX0208(0xe7d9),
	/* U+8241 */	U2E_NODEST_COLX,
	/* U+8242 */	U2E_NODEST_COLX,
	/* U+8243 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd67b)),
	/* U+8244 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd67c)),
	/* U+8245 */	IFX0213(JISX0213_2(0xf569),	JISX0212(0xd67d)),
	/* U+8246 */	IFX0213(JISX0213_2(0xf567),	JISX0212(0xd67e)),
	/* U+8247 */	JISX0208(0xc4fa),
	/* U+8248 */	U2E_NODEST_COLX,
	/* U+8249 */	IFX0213(JISX0213_2(0xf568),	U2E_NODEST_COLX),
	/* U+824A */	U2E_NODEST_COLX,
	/* U+824B */	IFX0213(JISX0213_2(0xf56b),	JISX0212(0xd721)),
	/* U+824C */	U2E_NODEST_COLX,
	/* U+824D */	U2E_NODEST_COLX,
	/* U+824E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd722)),
	/* U+824F */	IFX0213(JISX0213_2(0xf56d),	JISX0212(0xd723)),
	/* U+8250 */	U2E_NODEST_COLX,
	/* U+8251 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd724)),
	/* U+8252 */	U2E_NODEST_COLX,
	/* U+8253 */	U2E_NODEST_COLX,
	/* U+8254 */	U2E_NODEST_COLX,
	/* U+8255 */	U2E_NODEST_COLX,
	/* U+8256 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd725)),
	/* U+8257 */	IFX0213(JISX0213_2(0xf56f),	U2E_NODEST_COLX),
	/* U+8258 */	JISX0208(0xe7db),
	/* U+8259 */	JISX0208(0xe7da),
	/* U+825A */	JISX0208(0xe7dd),
	/* U+825B */	U2E_NODEST_COLX,
	/* U+825C */	IFX0213(JISX0213_2(0xf571),	JISX0212(0xd726)),
	/* U+825D */	JISX0208(0xe7dc),
	/* U+825E */	U2E_NODEST_COLX,
	/* U+825F */	JISX0208(0xe7de),
	/* U+8260 */	IFX0213(JISX0213_1(0xfadb),	JISX0212(0xd727)),
	/* U+8261 */	U2E_NODEST_COLX,
	/* U+8262 */	JISX0208(0xe7e0),
	/* U+8263 */	IFX0213(JISX0213_2(0xf572),	JISX0212(0xd728)),
	/* U+8264 */	JISX0208(0xe7df),
	/* U+8265 */	U2E_NODEST_COLX,
	/* U+8266 */	JISX0208(0xb4cf),
	/* U+8267 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd729)),
	/* U+8268 */	JISX0208(0xe7e1),
	/* U+8269 */	U2E_NODEST_COLX,
	/* U+826A */	JISX0208(0xe7e2),
	/* U+826B */	JISX0208(0xe7e3),
	/* U+826C */	U2E_NODEST_COLX,
	/* U+826D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd72a)),
	/* U+826E */	JISX0208(0xbab1),
	/* U+826F */	JISX0208(0xcec9),
	/* U+8270 */	U2E_NODEST_COLX,
	/* U+8271 */	JISX0208(0xe7e5),
	/* U+8272 */	JISX0208(0xbfa7),
	/* U+8273 */	U2E_NODEST_COLX,
	/* U+8274 */	IFX0213(JISX0213_1(0xfadc),	JISX0212(0xd72b)),
	/* U+8275 */	U2E_NODEST_COLX,
	/* U+8276 */	JISX0208(0xb1f0),
	/* U+8277 */	JISX0208(0xe7e6),
	/* U+8278 */	JISX0208(0xe7e7),
	/* U+8279 */	IFX0213(JISX0213_2(0xf576),	U2E_NODEST_COLX),
	/* U+827A */	U2E_NODEST_COLX,
	/* U+827B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd72c)),
	/* U+827C */	U2E_NODEST_COLX,
	/* U+827D */	IFX0213(JISX0213_2(0xf578),	JISX0212(0xd72d)),
	/* U+827E */	JISX0208(0xe7e8),
	/* U+827F */	IFX0213(JISX0213_2(0xf579),	JISX0212(0xd72e)),
	/* U+8280 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd72f)),
	/* U+8281 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd730)),
	/* U+8282 */	U2E_NODEST_COLX,
	/* U+8283 */	IFX0213(JISX0213_2(0xf57a),	JISX0212(0xd731)),
	/* U+8284 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd732)),
	/* U+8285 */	U2E_NODEST_COLX,
	/* U+8286 */	U2E_NODEST_COLX,
	/* U+8287 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd733)),
	/* U+8288 */	U2E_NODEST_COLX,
	/* U+8289 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd734)),
	/* U+828A */	IFX0213(JISX0213_2(0xf57b),	JISX0212(0xd735)),
	/* U+828B */	JISX0208(0xb0f2),
	/* U+828C */	U2E_NODEST_COLX,
	/* U+828D */	JISX0208(0xe7e9),
	/* U+828E */	IFX0213(JISX0213_1(0xfade),	JISX0212(0xd736)),
	/* U+828F */	U2E_NODEST_COLX,
	/* U+8290 */	U2E_NODEST_COLX,
	/* U+8291 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd737)),
	/* U+8292 */	JISX0208(0xe7ea),
	/* U+8293 */	IFX0213(JISX0213_2(0xf57c),	U2E_NODEST_COLX),
	/* U+8294 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd738)),
	/* U+8295 */	U2E_NODEST_COLX,
	/* U+8296 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd739)),
	/* U+8297 */	U2E_NODEST_COLX,
	/* U+8298 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd73a)),
	/* U+8299 */	JISX0208(0xc9e7),
	/* U+829A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd73b)),
	/* U+829B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd73c)),
	/* U+829C */	U2E_NODEST_COLX,
	/* U+829D */	JISX0208(0xbcc7),
	/* U+829E */	U2E_NODEST_COLX,
	/* U+829F */	JISX0208(0xe7ec),
	/* U+82A0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd73d)),
	/* U+82A1 */	IFX0213(JISX0213_1(0xfadf),	JISX0212(0xd73e)),
	/* U+82A2 */	U2E_NODEST_COLX,
	/* U+82A3 */	IFX0213(JISX0213_1(0xfae0),	JISX0212(0xd73f)),
	/* U+82A4 */	IFX0213(JISX0213_1(0xfae1),	JISX0212(0xd740)),
	/* U+82A5 */	JISX0208(0xb3a9),
	/* U+82A6 */	JISX0208(0xb0b2),
	/* U+82A7 */	IFX0213(JISX0213_2(0xf57d),	JISX0212(0xd741)),
	/* U+82A8 */	IFX0213(JISX0213_2(0xf57e),	JISX0212(0xd742)),
	/* U+82A9 */	IFX0213(JISX0213_1(0xfae2),	JISX0212(0xd743)),
	/* U+82AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd744)),
	/* U+82AB */	JISX0208(0xe7eb),
	/* U+82AC */	JISX0208(0xe7ee),
	/* U+82AD */	JISX0208(0xc7ce),
	/* U+82AE */	IFX0213(JISX0213_1(0xfae3),	JISX0212(0xd745)),
	/* U+82AF */	JISX0208(0xbfc4),
	/* U+82B0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd746)),
	/* U+82B1 */	JISX0208(0xb2d6),
	/* U+82B2 */	IFX0213(JISX0213_2(0xf621),	JISX0212(0xd747)),
	/* U+82B3 */	JISX0208(0xcba7),
	/* U+82B4 */	IFX0213(JISX0213_2(0xf622),	JISX0212(0xd748)),
	/* U+82B5 */	U2E_NODEST_COLX,
	/* U+82B6 */	U2E_NODEST_COLX,
	/* U+82B7 */	IFX0213(JISX0213_1(0xfae4),	JISX0212(0xd749)),
	/* U+82B8 */	JISX0208(0xb7dd),
	/* U+82B9 */	JISX0208(0xb6dc),
	/* U+82BA */	IFX0213(JISX0213_2(0xf623),	JISX0212(0xd74a)),
	/* U+82BB */	JISX0208(0xe7ed),
	/* U+82BC */	IFX0213(JISX0213_2(0xf624),	JISX0212(0xd74b)),
	/* U+82BD */	JISX0208(0xb2ea),
	/* U+82BE */	IFX0213(JISX0213_1(0xfae5),	JISX0212(0xd74c)),
	/* U+82BF */	IFX0213(JISX0213_1(0xfae6),	JISX0212(0xd74d)),
	/* U+82C0 */	U2E_NODEST_COLX,
	/* U+82C1 */	U2E_NODEST_COLX,
	/* U+82C2 */	U2E_NODEST_COLX,
	/* U+82C3 */	U2E_NODEST_COLX,
	/* U+82C4 */	U2E_NODEST_COLX,
	/* U+82C5 */	JISX0208(0xb4a3),
	/* U+82C6 */	IFX0213(JISX0213_1(0xfae7),	JISX0212(0xd74e)),
	/* U+82C7 */	U2E_NODEST_COLX,
	/* U+82C8 */	U2E_NODEST_COLX,
	/* U+82C9 */	U2E_NODEST_COLX,
	/* U+82CA */	U2E_NODEST_COLX,
	/* U+82CB */	U2E_NODEST_COLX,
	/* U+82CC */	U2E_NODEST_COLX,
	/* U+82CD */	U2E_NODEST_COLX,
	/* U+82CE */	U2E_NODEST_COLX,
	/* U+82CF */	U2E_NODEST_COLX,
	/* U+82D0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd74f)),
	/* U+82D1 */	JISX0208(0xb1f1),
	/* U+82D2 */	JISX0208(0xe7f2),
	/* U+82D3 */	JISX0208(0xceea),
	/* U+82D4 */	JISX0208(0xc2dd),
	/* U+82D5 */	IFX0213(JISX0213_1(0xfae8),	JISX0212(0xd750)),
	/* U+82D6 */	U2E_NODEST_COLX,
	/* U+82D7 */	JISX0208(0xc9c4),
	/* U+82D8 */	U2E_NODEST_COLX,
	/* U+82D9 */	JISX0208(0xe7fe),
	/* U+82DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd751)),
	/* U+82DB */	JISX0208(0xb2d7),
	/* U+82DC */	JISX0208(0xe7fc),
	/* U+82DD */	U2E_NODEST_COLX,
	/* U+82DE */	JISX0208(0xe7fa),
	/* U+82DF */	JISX0208(0xe7f1),
	/* U+82E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd752)),
	/* U+82E1 */	JISX0208(0xe7ef),
	/* U+82E2 */	IFX0213(JISX0213_2(0xf625),	JISX0212(0xd753)),
	/* U+82E3 */	JISX0208(0xe7f0),
	/* U+82E4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd754)),
	/* U+82E5 */	JISX0208(0xbce3),
	/* U+82E6 */	JISX0208(0xb6ec),
	/* U+82E7 */	JISX0208(0xc3f7),
	/* U+82E8 */	IFX0213(JISX0213_2(0xf626),	JISX0212(0xd755)),
	/* U+82E9 */	U2E_NODEST_COLX,
	/* U+82EA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd756)),
	/* U+82EB */	JISX0208(0xc6d1),
	/* U+82EC */	U2E_NODEST_COLX,
	/* U+82ED */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd757)),
	/* U+82EE */	U2E_NODEST_COLX,
	/* U+82EF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd758)),
	/* U+82F0 */	U2E_NODEST_COLX,
	/* U+82F1 */	JISX0208(0xb1d1),
	/* U+82F2 */	U2E_NODEST_COLX,
	/* U+82F3 */	JISX0208(0xe7f4),
	/* U+82F4 */	JISX0208(0xe7f3),
	/* U+82F5 */	U2E_NODEST_COLX,
	/* U+82F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd759)),
	/* U+82F7 */	IFX0213(JISX0213_2(0xf627),	JISX0212(0xd75a)),
	/* U+82F8 */	U2E_NODEST_COLX,
	/* U+82F9 */	JISX0208(0xe7f9),
	/* U+82FA */	JISX0208(0xe7f5),
	/* U+82FB */	JISX0208(0xe7f8),
	/* U+82FC */	U2E_NODEST_COLX,
	/* U+82FD */	IFX0213(JISX0213_1(0xfae9),	JISX0212(0xd75b)),
	/* U+82FE */	IFX0213(JISX0213_1(0xfaea),	JISX0212(0xd75c)),
	/* U+82FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_83[] = {
	/* U+8300 */	IFX0213(JISX0213_1(0xfaeb),	JISX0212(0xd75d)),
	/* U+8301 */	IFX0213(JISX0213_1(0xfaec),	JISX0212(0xd75e)),
	/* U+8302 */	JISX0208(0xccd0),
	/* U+8303 */	JISX0208(0xe7f7),
	/* U+8304 */	JISX0208(0xb2d8),
	/* U+8305 */	JISX0208(0xb3fd),
	/* U+8306 */	JISX0208(0xe7fb),
	/* U+8307 */	IFX0213(JISX0213_2(0xf628),	JISX0212(0xd75f)),
	/* U+8308 */	IFX0213(JISX0213_2(0xf629),	JISX0212(0xd760)),
	/* U+8309 */	JISX0208(0xe7fd),
	/* U+830A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd761)),
	/* U+830B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd762)),
	/* U+830C */	IFX0213(JISX0213_2(0xf62a),	U2E_NODEST_COLX),
	/* U+830D */	U2E_NODEST_COLX,
	/* U+830E */	JISX0208(0xb7d4),
	/* U+830F */	U2E_NODEST_COLX,
	/* U+8310 */	U2E_NODEST_COLX,
	/* U+8311 */	U2E_NODEST_COLX,
	/* U+8312 */	U2E_NODEST_COLX,
	/* U+8313 */	U2E_NODEST_COLX,
	/* U+8314 */	U2E_NODEST_COLX,
	/* U+8315 */	U2E_NODEST_COLX,
	/* U+8316 */	JISX0208(0xe8a3),
	/* U+8317 */	JISX0208(0xe8ac),
	/* U+8318 */	JISX0208(0xe8ad),
	/* U+8319 */	U2E_NODEST_COLX,
	/* U+831A */	U2E_NODEST_COLX,
	/* U+831B */	IFX0213(JISX0213_2(0xf62c),	JISX0212(0xd764)),
	/* U+831C */	JISX0208(0xb0ab),
	/* U+831D */	IFX0213(JISX0213_2(0xf62d),	JISX0212(0xd765)),
	/* U+831E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd766)),
	/* U+831F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd767)),
	/* U+8320 */	U2E_NODEST_COLX,
	/* U+8321 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd768)),
	/* U+8322 */	IFX0213(JISX0213_1(0xfaee),	JISX0212(0xd769)),
	/* U+8323 */	JISX0208(0xe8b4),
	/* U+8324 */	U2E_NODEST_COLX,
	/* U+8325 */	U2E_NODEST_COLX,
	/* U+8326 */	U2E_NODEST_COLX,
	/* U+8327 */	U2E_NODEST_COLX,
	/* U+8328 */	JISX0208(0xb0f1),
	/* U+8329 */	U2E_NODEST_COLX,
	/* U+832A */	U2E_NODEST_COLX,
	/* U+832B */	JISX0208(0xe8ab),
	/* U+832C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd76a)),
	/* U+832D */	IFX0213(JISX0213_1(0xfaef),	JISX0212(0xd76b)),
	/* U+832E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd76c)),
	/* U+832F */	JISX0208(0xe8aa),
	/* U+8330 */	IFX0213(JISX0213_2(0xf62e),	JISX0212(0xd76d)),
	/* U+8331 */	JISX0208(0xe8a5),
	/* U+8332 */	JISX0208(0xe8a4),
	/* U+8333 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd76e)),
	/* U+8334 */	JISX0208(0xe8a2),
	/* U+8335 */	JISX0208(0xe8a1),
	/* U+8336 */	JISX0208(0xc3e3),
	/* U+8337 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd76f)),
	/* U+8338 */	JISX0208(0xc2fb),
	/* U+8339 */	JISX0208(0xe8a7),
	/* U+833A */	IFX0213(JISX0213_1(0xfaf0),	JISX0212(0xd770)),
	/* U+833B */	U2E_NODEST_COLX,
	/* U+833C */	IFX0213(JISX0213_2(0xf62f),	JISX0212(0xd771)),
	/* U+833D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd772)),
	/* U+833E */	U2E_NODEST_COLX,
	/* U+833F */	U2E_NODEST_COLX,
	/* U+8340 */	JISX0208(0xe8a6),
	/* U+8341 */	U2E_NODEST_COLX,
	/* U+8342 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd773)),
	/* U+8343 */	IFX0213(JISX0213_1(0xfaf1),	JISX0212(0xd774)),
	/* U+8344 */	IFX0213(JISX0213_2(0xf630),	JISX0212(0xd775)),
	/* U+8345 */	JISX0208(0xe8a9),
	/* U+8346 */	U2E_NODEST_COLX,
	/* U+8347 */	IFX0213(JISX0213_1(0xfaf2),	JISX0212(0xd776)),
	/* U+8348 */	U2E_NODEST_COLX,
	/* U+8349 */	JISX0208(0xc1f0),
	/* U+834A */	JISX0208(0xb7d5),
	/* U+834B */	U2E_NODEST_COLX,
	/* U+834C */	U2E_NODEST_COLX,
	/* U+834D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd777)),
	/* U+834E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd778)),
	/* U+834F */	JISX0208(0xb1c1),
	/* U+8350 */	JISX0208(0xe8a8),
	/* U+8351 */	IFX0213(JISX0213_1(0xfaf3),	JISX0212(0xd779)),
	/* U+8352 */	JISX0208(0xb9d3),
	/* U+8353 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd83e)),
	/* U+8354 */	IFX0213(JISX0213_2(0xf62b),	JISX0212(0xd763)),
	/* U+8355 */	IFX0213(JISX0213_1(0xfaf4),	JISX0212(0xd77a)),
	/* U+8356 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd77b)),
	/* U+8357 */	IFX0213(JISX0213_2(0xf631),	JISX0212(0xd77c)),
	/* U+8358 */	JISX0208(0xc1f1),
	/* U+8359 */	U2E_NODEST_COLX,
	/* U+835A */	U2E_NODEST_COLX,
	/* U+835B */	U2E_NODEST_COLX,
	/* U+835C */	U2E_NODEST_COLX,
	/* U+835D */	U2E_NODEST_COLX,
	/* U+835E */	U2E_NODEST_COLX,
	/* U+835F */	U2E_NODEST_COLX,
	/* U+8360 */	U2E_NODEST_COLX,
	/* U+8361 */	U2E_NODEST_COLX,
	/* U+8362 */	IFX0213(JISX0213_1(0xfaed),	IBM(0xf45f)),
	/* U+8363 */	IFX0213(JISX0213_2(0xae4a),	U2E_NODEST_COLX),
	/* U+8364 */	U2E_NODEST_COLX,
	/* U+8365 */	U2E_NODEST_COLX,
	/* U+8366 */	U2E_NODEST_COLX,
	/* U+8367 */	U2E_NODEST_COLX,
	/* U+8368 */	U2E_NODEST_COLX,
	/* U+8369 */	U2E_NODEST_COLX,
	/* U+836A */	U2E_NODEST_COLX,
	/* U+836B */	U2E_NODEST_COLX,
	/* U+836C */	U2E_NODEST_COLX,
	/* U+836D */	U2E_NODEST_COLX,
	/* U+836E */	U2E_NODEST_COLX,
	/* U+836F */	U2E_NODEST_COLX,
	/* U+8370 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd77d)),
	/* U+8371 */	U2E_NODEST_COLX,
	/* U+8372 */	U2E_NODEST_COLX,
	/* U+8373 */	JISX0208(0xe8ba),
	/* U+8374 */	U2E_NODEST_COLX,
	/* U+8375 */	JISX0208(0xe8bb),
	/* U+8376 */	U2E_NODEST_COLX,
	/* U+8377 */	JISX0208(0xb2d9),
	/* U+8378 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd77e)),
	/* U+8379 */	U2E_NODEST_COLX,
	/* U+837A */	U2E_NODEST_COLX,
	/* U+837B */	JISX0208(0xb2ae),
	/* U+837C */	JISX0208(0xe8b8),
	/* U+837D */	IFX0213(JISX0213_1(0xfaf5),	JISX0212(0xd821)),
	/* U+837E */	U2E_NODEST_COLX,
	/* U+837F */	IFX0213(JISX0213_2(0xf633),	JISX0212(0xd822)),
	/* U+8380 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd823)),
	/* U+8381 */	U2E_NODEST_COLX,
	/* U+8382 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd824)),
	/* U+8383 */	U2E_NODEST_COLX,
	/* U+8384 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd825)),
	/* U+8385 */	JISX0208(0xe8ae),
	/* U+8386 */	IFX0213(JISX0213_1(0xfaf6),	JISX0212(0xd826)),
	/* U+8387 */	JISX0208(0xe8b6),
	/* U+8388 */	U2E_NODEST_COLX,
	/* U+8389 */	JISX0208(0xe8bd),
	/* U+838A */	JISX0208(0xe8b7),
	/* U+838B */	U2E_NODEST_COLX,
	/* U+838C */	U2E_NODEST_COLX,
	/* U+838D */	IFX0213(JISX0213_2(0xf636),	JISX0212(0xd827)),
	/* U+838E */	JISX0208(0xe8b5),
	/* U+838F */	U2E_NODEST_COLX,
	/* U+8390 */	U2E_NODEST_COLX,
	/* U+8391 */	U2E_NODEST_COLX,
	/* U+8392 */	IFX0213(JISX0213_1(0xfaf7),	JISX0212(0xd828)),
	/* U+8393 */	JISX0208(0xe7f6),
	/* U+8394 */	IFX0213(JISX0213_2(0xf637),	JISX0212(0xd829)),
	/* U+8395 */	IFX0213(JISX0213_2(0xf638),	JISX0212(0xd82a)),
	/* U+8396 */	JISX0208(0xe8b3),
	/* U+8397 */	U2E_NODEST_COLX,
	/* U+8398 */	IFX0213(JISX0213_1(0xfaf8),	JISX0212(0xd82b)),
	/* U+8399 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd82c)),
	/* U+839A */	JISX0208(0xe8af),
	/* U+839B */	IFX0213(JISX0213_2(0xf639),	JISX0212(0xd82d)),
	/* U+839C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd82e)),
	/* U+839D */	IFX0213(JISX0213_2(0xf63a),	JISX0212(0xd82f)),
	/* U+839E */	JISX0208(0xb4d0),
	/* U+839F */	JISX0208(0xe8b1),
	/* U+83A0 */	JISX0208(0xe8bc),
	/* U+83A1 */	U2E_NODEST_COLX,
	/* U+83A2 */	JISX0208(0xe8b2),
	/* U+83A3 */	U2E_NODEST_COLX,
	/* U+83A4 */	U2E_NODEST_COLX,
	/* U+83A5 */	U2E_NODEST_COLX,
	/* U+83A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd830)),
	/* U+83A7 */	IFX0213(JISX0213_1(0xfaf9),	JISX0212(0xd831)),
	/* U+83A8 */	JISX0208(0xe8be),
	/* U+83A9 */	IFX0213(JISX0213_1(0xfafa),	JISX0212(0xd832)),
	/* U+83AA */	JISX0208(0xe8b0),
	/* U+83AB */	JISX0208(0xc7fc),
	/* U+83AC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd833)),
	/* U+83AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd84c)),
	/* U+83AE */	U2E_NODEST_COLX,
	/* U+83AF */	U2E_NODEST_COLX,
	/* U+83B0 */	U2E_NODEST_COLX,
	/* U+83B1 */	JISX0208(0xcde9),
	/* U+83B2 */	U2E_NODEST_COLX,
	/* U+83B3 */	U2E_NODEST_COLX,
	/* U+83B4 */	U2E_NODEST_COLX,
	/* U+83B5 */	JISX0208(0xe8b9),
	/* U+83B6 */	U2E_NODEST_COLX,
	/* U+83B7 */	U2E_NODEST_COLX,
	/* U+83B8 */	U2E_NODEST_COLX,
	/* U+83B9 */	U2E_NODEST_COLX,
	/* U+83BA */	U2E_NODEST_COLX,
	/* U+83BB */	U2E_NODEST_COLX,
	/* U+83BC */	U2E_NODEST_COLX,
	/* U+83BD */	JISX0208(0xe8cf),
	/* U+83BE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd834)),
	/* U+83BF */	IFX0213(JISX0213_1(0xfafb),	JISX0212(0xd835)),
	/* U+83C0 */	IFX0213(JISX0213_1(0xfafc),	JISX0212(0xd836)),
	/* U+83C1 */	JISX0208(0xe8c7),
	/* U+83C2 */	U2E_NODEST_COLX,
	/* U+83C3 */	U2E_NODEST_COLX,
	/* U+83C4 */	U2E_NODEST_COLX,
	/* U+83C5 */	JISX0208(0xbffb),
	/* U+83C6 */	U2E_NODEST_COLX,
	/* U+83C7 */	IFX0213(JISX0213_1(0xfafd),	JISX0212(0xd837)),
	/* U+83C8 */	U2E_NODEST_COLX,
	/* U+83C9 */	IFX0213(JISX0213_2(0xf63b),	JISX0212(0xd838)),
	/* U+83CA */	JISX0208(0xb5c6),
	/* U+83CB */	U2E_NODEST_COLX,
	/* U+83CC */	JISX0208(0xb6dd),
	/* U+83CD */	U2E_NODEST_COLX,
	/* U+83CE */	JISX0208(0xe8c2),
	/* U+83CF */	IFX0213(JISX0213_1(0xfafe),	JISX0212(0xd839)),
	/* U+83D0 */	IFX0213(JISX0213_2(0xf63c),	JISX0212(0xd83a)),
	/* U+83D1 */	IFX0213(JISX0213_1(0xfba1),	JISX0212(0xd83b)),
	/* U+83D2 */	U2E_NODEST_COLX,
	/* U+83D3 */	JISX0208(0xb2db),
	/* U+83D4 */	IFX0213(JISX0213_2(0xf63d),	JISX0212(0xd83c)),
	/* U+83D5 */	U2E_NODEST_COLX,
	/* U+83D6 */	JISX0208(0xbed4),
	/* U+83D7 */	U2E_NODEST_COLX,
	/* U+83D8 */	JISX0208(0xe8c5),
	/* U+83D9 */	U2E_NODEST_COLX,
	/* U+83DA */	U2E_NODEST_COLX,
	/* U+83DB */	U2E_NODEST_COLX,
	/* U+83DC */	JISX0208(0xbada),
	/* U+83DD */	IFX0213(JISX0213_2(0xf63e),	JISX0212(0xd83d)),
	/* U+83DE */	U2E_NODEST_COLX,
	/* U+83DF */	JISX0208(0xc5d1),
	/* U+83E0 */	JISX0208(0xe8ca),
	/* U+83E1 */	IFX0213(JISX0213_1(0xfba2),	U2E_NODEST_COLX),
	/* U+83E2 */	U2E_NODEST_COLX,
	/* U+83E3 */	U2E_NODEST_COLX,
	/* U+83E4 */	U2E_NODEST_COLX,
	/* U+83E5 */	IFX0213(JISX0213_2(0xf63f),	U2E_NODEST_COLX),
	/* U+83E6 */	U2E_NODEST_COLX,
	/* U+83E7 */	U2E_NODEST_COLX,
	/* U+83E8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd83f)),
	/* U+83E9 */	JISX0208(0xcaee),
	/* U+83EA */	IFX0213(JISX0213_1(0xfba3),	JISX0212(0xd840)),
	/* U+83EB */	JISX0208(0xe8c1),
	/* U+83EC */	U2E_NODEST_COLX,
	/* U+83ED */	U2E_NODEST_COLX,
	/* U+83EE */	U2E_NODEST_COLX,
	/* U+83EF */	JISX0208(0xb2da),
	/* U+83F0 */	JISX0208(0xb8d6),
	/* U+83F1 */	JISX0208(0xc9a9),
	/* U+83F2 */	JISX0208(0xe8cb),
	/* U+83F3 */	U2E_NODEST_COLX,
	/* U+83F4 */	JISX0208(0xe8bf),
	/* U+83F5 */	U2E_NODEST_COLX,
	/* U+83F6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd841)),
	/* U+83F7 */	JISX0208(0xe8c8),
	/* U+83F8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd842)),
	/* U+83F9 */	IFX0213(JISX0213_2(0xf640),	JISX0212(0xd843)),
	/* U+83FA */	U2E_NODEST_COLX,
	/* U+83FB */	JISX0208(0xe8d2),
	/* U+83FC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd844)),
	/* U+83FD */	JISX0208(0xe8c3),
	/* U+83FE */	U2E_NODEST_COLX,
	/* U+83FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_84[] = {
	/* U+8400 */	U2E_NODEST_COLX,
	/* U+8401 */	IFX0213(JISX0213_1(0xfba4),	JISX0212(0xd845)),
	/* U+8402 */	U2E_NODEST_COLX,
	/* U+8403 */	JISX0208(0xe8c4),
	/* U+8404 */	JISX0208(0xc6ba),
	/* U+8405 */	U2E_NODEST_COLX,
	/* U+8406 */	IFX0213(JISX0213_1(0xfba5),	JISX0212(0xd846)),
	/* U+8407 */	JISX0208(0xe8c9),
	/* U+8408 */	U2E_NODEST_COLX,
	/* U+8409 */	U2E_NODEST_COLX,
	/* U+840A */	IFX0213(JISX0213_1(0xfba6),	JISX0212(0xd847)),
	/* U+840B */	JISX0208(0xe8c6),
	/* U+840C */	JISX0208(0xcba8),
	/* U+840D */	JISX0208(0xe8cc),
	/* U+840E */	JISX0208(0xb0e0),
	/* U+840F */	IFX0213(JISX0213_2(0xf641),	JISX0212(0xd848)),
	/* U+8410 */	U2E_NODEST_COLX,
	/* U+8411 */	IFX0213(JISX0213_2(0xf642),	JISX0212(0xd849)),
	/* U+8412 */	U2E_NODEST_COLX,
	/* U+8413 */	JISX0208(0xe8c0),
	/* U+8414 */	U2E_NODEST_COLX,
	/* U+8415 */	IFX0213(JISX0213_2(0xf643),	JISX0212(0xd84a)),
	/* U+8416 */	U2E_NODEST_COLX,
	/* U+8417 */	IFX0213(JISX0213_2(0xf645),	U2E_NODEST_COLX),
	/* U+8418 */	U2E_NODEST_COLX,
	/* U+8419 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd84b)),
	/* U+841A */	U2E_NODEST_COLX,
	/* U+841B */	U2E_NODEST_COLX,
	/* U+841C */	U2E_NODEST_COLX,
	/* U+841D */	U2E_NODEST_COLX,
	/* U+841E */	U2E_NODEST_COLX,
	/* U+841F */	U2E_NODEST_COLX,
	/* U+8420 */	JISX0208(0xe8ce),
	/* U+8421 */	U2E_NODEST_COLX,
	/* U+8422 */	JISX0208(0xe8cd),
	/* U+8423 */	U2E_NODEST_COLX,
	/* U+8424 */	U2E_NODEST_COLX,
	/* U+8425 */	U2E_NODEST_COLX,
	/* U+8426 */	U2E_NODEST_COLX,
	/* U+8427 */	U2E_NODEST_COLX,
	/* U+8428 */	U2E_NODEST_COLX,
	/* U+8429 */	JISX0208(0xc7eb),
	/* U+842A */	JISX0208(0xe8d4),
	/* U+842B */	U2E_NODEST_COLX,
	/* U+842C */	JISX0208(0xe8df),
	/* U+842D */	U2E_NODEST_COLX,
	/* U+842E */	U2E_NODEST_COLX,
	/* U+842F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd84d)),
	/* U+8430 */	U2E_NODEST_COLX,
	/* U+8431 */	JISX0208(0xb3fe),
	/* U+8432 */	U2E_NODEST_COLX,
	/* U+8433 */	U2E_NODEST_COLX,
	/* U+8434 */	U2E_NODEST_COLX,
	/* U+8435 */	JISX0208(0xe8e2),
	/* U+8436 */	U2E_NODEST_COLX,
	/* U+8437 */	U2E_NODEST_COLX,
	/* U+8438 */	JISX0208(0xe8d0),
	/* U+8439 */	IFX0213(JISX0213_2(0xf646),	JISX0212(0xd84e)),
	/* U+843A */	U2E_NODEST_COLX,
	/* U+843B */	U2E_NODEST_COLX,
	/* U+843C */	JISX0208(0xe8d5),
	/* U+843D */	JISX0208(0xcdee),
	/* U+843E */	U2E_NODEST_COLX,
	/* U+843F */	U2E_NODEST_COLX,
	/* U+8440 */	U2E_NODEST_COLX,
	/* U+8441 */	U2E_NODEST_COLX,
	/* U+8442 */	U2E_NODEST_COLX,
	/* U+8443 */	U2E_NODEST_COLX,
	/* U+8444 */	U2E_NODEST_COLX,
	/* U+8445 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd84f)),
	/* U+8446 */	JISX0208(0xe8de),
	/* U+8447 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd850)),
	/* U+8448 */	IFX0213(JISX0213_1(0xfba8),	JISX0212(0xd851)),
	/* U+8449 */	JISX0208(0xcdd5),
	/* U+844A */	IFX0213(JISX0213_2(0xf647),	JISX0212(0xd852)),
	/* U+844B */	U2E_NODEST_COLX,
	/* U+844C */	U2E_NODEST_COLX,
	/* U+844D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd853)),
	/* U+844E */	JISX0208(0xceaa),
	/* U+844F */	IFX0213(JISX0213_2(0xf648),	JISX0212(0xd854)),
	/* U+8450 */	U2E_NODEST_COLX,
	/* U+8451 */	IFX0213(JISX0213_2(0xf649),	JISX0212(0xd855)),
	/* U+8452 */	IFX0213(JISX0213_2(0xf64a),	JISX0212(0xd856)),
	/* U+8453 */	U2E_NODEST_COLX,
	/* U+8454 */	U2E_NODEST_COLX,
	/* U+8455 */	U2E_NODEST_COLX,
	/* U+8456 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd857)),
	/* U+8457 */	JISX0208(0xc3f8),
	/* U+8458 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd858)),
	/* U+8459 */	IFX0213(JISX0213_2(0xf64b),	JISX0212(0xd859)),
	/* U+845A */	IFX0213(JISX0213_2(0xf64c),	JISX0212(0xd85a)),
	/* U+845B */	JISX0208(0xb3eb),
	/* U+845C */	IFX0213(JISX0213_2(0xf64d),	JISX0212(0xd85b)),
	/* U+845D */	U2E_NODEST_COLX,
	/* U+845E */	U2E_NODEST_COLX,
	/* U+845F */	IFX0213(JISX0213_1(0xfba9),	U2E_NODEST_COLX),
	/* U+8460 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd85c)),
	/* U+8461 */	JISX0208(0xc9f2),
	/* U+8462 */	JISX0208(0xe8e4),
	/* U+8463 */	JISX0208(0xc6a1),
	/* U+8464 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd85d)),
	/* U+8465 */	IFX0213(JISX0213_2(0xf64f),	JISX0212(0xd85e)),
	/* U+8466 */	JISX0208(0xb0b1),
	/* U+8467 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd85f)),
	/* U+8468 */	U2E_NODEST_COLX,
	/* U+8469 */	JISX0208(0xe8dd),
	/* U+846A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd860)),
	/* U+846B */	JISX0208(0xe8d9),
	/* U+846C */	JISX0208(0xc1f2),
	/* U+846D */	JISX0208(0xe8d3),
	/* U+846E */	JISX0208(0xe8db),
	/* U+846F */	JISX0208(0xe8e0),
	/* U+8470 */	IFX0213(JISX0213_1(0xfbaa),	JISX0212(0xd861)),
	/* U+8471 */	JISX0208(0xc7ac),
	/* U+8472 */	U2E_NODEST_COLX,
	/* U+8473 */	IFX0213(JISX0213_1(0xfbab),	JISX0212(0xd862)),
	/* U+8474 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd863)),
	/* U+8475 */	JISX0208(0xb0aa),
	/* U+8476 */	IFX0213(JISX0213_2(0xf650),	JISX0212(0xd864)),
	/* U+8477 */	JISX0208(0xe8d8),
	/* U+8478 */	IFX0213(JISX0213_2(0xf651),	JISX0212(0xd865)),
	/* U+8479 */	JISX0208(0xe8e1),
	/* U+847A */	JISX0208(0xc9f8),
	/* U+847B */	U2E_NODEST_COLX,
	/* U+847C */	IFX0213(JISX0213_2(0xf652),	JISX0212(0xd866)),
	/* U+847D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd867)),
	/* U+847E */	U2E_NODEST_COLX,
	/* U+847F */	U2E_NODEST_COLX,
	/* U+8480 */	U2E_NODEST_COLX,
	/* U+8481 */	IFX0213(JISX0213_2(0xf653),	JISX0212(0xd868)),
	/* U+8482 */	JISX0208(0xe8dc),
	/* U+8483 */	U2E_NODEST_COLX,
	/* U+8484 */	JISX0208(0xe8d7),
	/* U+8485 */	IFX0213(JISX0213_1(0xfbac),	JISX0212(0xd869)),
	/* U+8486 */	U2E_NODEST_COLX,
	/* U+8487 */	U2E_NODEST_COLX,
	/* U+8488 */	U2E_NODEST_COLX,
	/* U+8489 */	U2E_NODEST_COLX,
	/* U+848A */	U2E_NODEST_COLX,
	/* U+848B */	JISX0208(0xbed5),
	/* U+848C */	U2E_NODEST_COLX,
	/* U+848D */	U2E_NODEST_COLX,
	/* U+848E */	U2E_NODEST_COLX,
	/* U+848F */	U2E_NODEST_COLX,
	/* U+8490 */	JISX0208(0xbdaf),
	/* U+8491 */	U2E_NODEST_COLX,
	/* U+8492 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd86a)),
	/* U+8493 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd86b)),
	/* U+8494 */	JISX0208(0xbcac),
	/* U+8495 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd86c)),
	/* U+8496 */	U2E_NODEST_COLX,
	/* U+8497 */	IFX0213(JISX0213_2(0xf656),	U2E_NODEST_COLX),
	/* U+8498 */	U2E_NODEST_COLX,
	/* U+8499 */	JISX0208(0xccd8),
	/* U+849A */	U2E_NODEST_COLX,
	/* U+849B */	U2E_NODEST_COLX,
	/* U+849C */	JISX0208(0xc9c7),
	/* U+849D */	U2E_NODEST_COLX,
	/* U+849E */	IFX0213(JISX0213_1(0xfbad),	JISX0212(0xd86d)),
	/* U+849F */	JISX0208(0xe8e7),
	/* U+84A0 */	U2E_NODEST_COLX,
	/* U+84A1 */	JISX0208(0xe8f0),
	/* U+84A2 */	U2E_NODEST_COLX,
	/* U+84A3 */	U2E_NODEST_COLX,
	/* U+84A4 */	U2E_NODEST_COLX,
	/* U+84A5 */	U2E_NODEST_COLX,
	/* U+84A6 */	IFX0213(JISX0213_2(0xf657),	JISX0212(0xd86e)),
	/* U+84A7 */	U2E_NODEST_COLX,
	/* U+84A8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd86f)),
	/* U+84A9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd870)),
	/* U+84AA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd871)),
	/* U+84AB */	U2E_NODEST_COLX,
	/* U+84AC */	U2E_NODEST_COLX,
	/* U+84AD */	JISX0208(0xe8da),
	/* U+84AE */	U2E_NODEST_COLX,
	/* U+84AF */	IFX0213(JISX0213_1(0xfbae),	JISX0212(0xd872)),
	/* U+84B0 */	U2E_NODEST_COLX,
	/* U+84B1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd873)),
	/* U+84B2 */	JISX0208(0xb3f7),
	/* U+84B3 */	U2E_NODEST_COLX,
	/* U+84B4 */	IFX0213(JISX0213_1(0xfbaf),	JISX0212(0xd874)),
	/* U+84B5 */	U2E_NODEST_COLX,
	/* U+84B6 */	U2E_NODEST_COLX,
	/* U+84B7 */	U2E_NODEST_COLX,
	/* U+84B8 */	JISX0208(0xbef8),
	/* U+84B9 */	JISX0208(0xe8e5),
	/* U+84BA */	IFX0213(JISX0213_1(0xfbb0),	JISX0212(0xd875)),
	/* U+84BB */	JISX0208(0xe8ea),
	/* U+84BC */	JISX0208(0xc1f3),
	/* U+84BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd876)),
	/* U+84BE */	IFX0213(JISX0213_2(0xf658),	JISX0212(0xd877)),
	/* U+84BF */	JISX0208(0xe8e6),
	/* U+84C0 */	IFX0213(JISX0213_1(0xfbb1),	JISX0212(0xd878)),
	/* U+84C1 */	JISX0208(0xe8ed),
	/* U+84C2 */	IFX0213(JISX0213_1(0xfbb2),	JISX0212(0xd879)),
	/* U+84C3 */	U2E_NODEST_COLX,
	/* U+84C4 */	JISX0208(0xc3df),
	/* U+84C5 */	U2E_NODEST_COLX,
	/* U+84C6 */	JISX0208(0xe8ee),
	/* U+84C7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd87a)),
	/* U+84C8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd87b)),
	/* U+84C9 */	JISX0208(0xcdd6),
	/* U+84CA */	JISX0208(0xe8e3),
	/* U+84CB */	JISX0208(0xb3b8),
	/* U+84CC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd87c)),
	/* U+84CD */	JISX0208(0xe8e9),
	/* U+84CE */	IFX0213(JISX0213_2(0xf65a),	U2E_NODEST_COLX),
	/* U+84CF */	IFX0213(JISX0213_2(0xf65b),	JISX0212(0xd87d)),
	/* U+84D0 */	JISX0208(0xe8ec),
	/* U+84D1 */	JISX0208(0xccac),
	/* U+84D2 */	U2E_NODEST_COLX,
	/* U+84D3 */	IFX0213(JISX0213_2(0xf65c),	JISX0212(0xd87e)),
	/* U+84D4 */	U2E_NODEST_COLX,
	/* U+84D5 */	U2E_NODEST_COLX,
	/* U+84D6 */	JISX0208(0xe8ef),
	/* U+84D7 */	U2E_NODEST_COLX,
	/* U+84D8 */	U2E_NODEST_COLX,
	/* U+84D9 */	JISX0208(0xe8e8),
	/* U+84DA */	JISX0208(0xe8eb),
	/* U+84DB */	U2E_NODEST_COLX,
	/* U+84DC */	IFX0213(JISX0213_2(0xf655),	JISX0212(0xd921)),
	/* U+84DD */	U2E_NODEST_COLX,
	/* U+84DE */	U2E_NODEST_COLX,
	/* U+84DF */	U2E_NODEST_COLX,
	/* U+84E0 */	U2E_NODEST_COLX,
	/* U+84E1 */	U2E_NODEST_COLX,
	/* U+84E2 */	U2E_NODEST_COLX,
	/* U+84E3 */	U2E_NODEST_COLX,
	/* U+84E4 */	U2E_NODEST_COLX,
	/* U+84E5 */	U2E_NODEST_COLX,
	/* U+84E6 */	U2E_NODEST_COLX,
	/* U+84E7 */	IFX0213(JISX0213_2(0xf65e),	JISX0212(0xd922)),
	/* U+84E8 */	U2E_NODEST_COLX,
	/* U+84E9 */	U2E_NODEST_COLX,
	/* U+84EA */	IFX0213(JISX0213_2(0xf65f),	JISX0212(0xd923)),
	/* U+84EB */	U2E_NODEST_COLX,
	/* U+84EC */	JISX0208(0xcba9),
	/* U+84ED */	U2E_NODEST_COLX,
	/* U+84EE */	JISX0208(0xcfa1),
	/* U+84EF */	IFX0213(JISX0213_2(0xf660),	JISX0212(0xd924)),
	/* U+84F0 */	IFX0213(JISX0213_2(0xf661),	JISX0212(0xd925)),
	/* U+84F1 */	IFX0213(JISX0213_2(0xf662),	JISX0212(0xd926)),
	/* U+84F2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd927)),
	/* U+84F3 */	U2E_NODEST_COLX,
	/* U+84F4 */	JISX0208(0xe8f3),
	/* U+84F5 */	U2E_NODEST_COLX,
	/* U+84F6 */	U2E_NODEST_COLX,
	/* U+84F7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd928)),
	/* U+84F8 */	U2E_NODEST_COLX,
	/* U+84F9 */	U2E_NODEST_COLX,
	/* U+84FA */	IFX0213(JISX0213_2(0xf663),	JISX0212(0xd92a)),
	/* U+84FB */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd92b)),
	/* U+84FC */	JISX0208(0xe8fa),
	/* U+84FD */	IFX0213(JISX0213_2(0xf664),	JISX0212(0xd92c)),
	/* U+84FE */	U2E_NODEST_COLX,
	/* U+84FF */	JISX0208(0xe8f2),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_85[] = {
	/* U+8500 */	JISX0208(0xbcc3),
	/* U+8501 */	U2E_NODEST_COLX,
	/* U+8502 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd92d)),
	/* U+8503 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd92e)),
	/* U+8504 */	U2E_NODEST_COLX,
	/* U+8505 */	U2E_NODEST_COLX,
	/* U+8506 */	JISX0208(0xe8d1),
	/* U+8507 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd92f)),
	/* U+8508 */	U2E_NODEST_COLX,
	/* U+8509 */	U2E_NODEST_COLX,
	/* U+850A */	U2E_NODEST_COLX,
	/* U+850B */	U2E_NODEST_COLX,
	/* U+850C */	IFX0213(JISX0213_2(0xf665),	JISX0212(0xd930)),
	/* U+850D */	U2E_NODEST_COLX,
	/* U+850E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd931)),
	/* U+850F */	U2E_NODEST_COLX,
	/* U+8510 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd932)),
	/* U+8511 */	JISX0208(0xcace),
	/* U+8512 */	U2E_NODEST_COLX,
	/* U+8513 */	JISX0208(0xcca2),
	/* U+8514 */	JISX0208(0xe8f9),
	/* U+8515 */	JISX0208(0xe8f8),
	/* U+8516 */	U2E_NODEST_COLX,
	/* U+8517 */	JISX0208(0xe8f4),
	/* U+8518 */	JISX0208(0xe8f5),
	/* U+8519 */	U2E_NODEST_COLX,
	/* U+851A */	JISX0208(0xb1b6),
	/* U+851B */	IFX0213(JISX0213_2(0xf666),	U2E_NODEST_COLX),
	/* U+851C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd933)),
	/* U+851D */	U2E_NODEST_COLX,
	/* U+851E */	IFX0213(JISX0213_1(0xfbb5),	JISX0212(0xd934)),
	/* U+851F */	JISX0208(0xe8f7),
	/* U+8520 */	U2E_NODEST_COLX,
	/* U+8521 */	JISX0208(0xe8f1),
	/* U+8522 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd935)),
	/* U+8523 */	IFX0213(JISX0213_1(0xfbb6),	JISX0212(0xd936)),
	/* U+8524 */	IFX0213(JISX0213_2(0xf667),	JISX0212(0xd937)),
	/* U+8525 */	IFX0213(JISX0213_2(0xf668),	JISX0212(0xd938)),
	/* U+8526 */	JISX0208(0xc4d5),
	/* U+8527 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd939)),
	/* U+8528 */	U2E_NODEST_COLX,
	/* U+8529 */	U2E_NODEST_COLX,
	/* U+852A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd93a)),
	/* U+852B */	IFX0213(JISX0213_2(0xf669),	JISX0212(0xd93b)),
	/* U+852C */	JISX0208(0xe8f6),
	/* U+852D */	JISX0208(0xb0fe),
	/* U+852E */	U2E_NODEST_COLX,
	/* U+852F */	IFX0213(JISX0213_1(0xfbb7),	JISX0212(0xd93c)),
	/* U+8530 */	U2E_NODEST_COLX,
	/* U+8531 */	U2E_NODEST_COLX,
	/* U+8532 */	IFX0213(JISX0213_1(0xfbb4),	JISX0212(0xd929)),
	/* U+8533 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd93d)),
	/* U+8534 */	IFX0213(JISX0213_2(0xf66a),	JISX0212(0xd93e)),
	/* U+8535 */	JISX0208(0xc2a2),
	/* U+8536 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd93f)),
	/* U+8537 */	U2E_NODEST_COLX,
	/* U+8538 */	U2E_NODEST_COLX,
	/* U+8539 */	U2E_NODEST_COLX,
	/* U+853A */	U2E_NODEST_COLX,
	/* U+853B */	U2E_NODEST_COLX,
	/* U+853C */	U2E_NODEST_COLX,
	/* U+853D */	JISX0208(0xcac3),
	/* U+853E */	IFX0213(JISX0213_2(0xf66f),	U2E_NODEST_COLX),
	/* U+853F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd940)),
	/* U+8540 */	JISX0208(0xe8fb),
	/* U+8541 */	JISX0208(0xe9a1),
	/* U+8542 */	U2E_NODEST_COLX,
	/* U+8543 */	JISX0208(0xc8d9),
	/* U+8544 */	U2E_NODEST_COLX,
	/* U+8545 */	U2E_NODEST_COLX,
	/* U+8546 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd941)),
	/* U+8547 */	U2E_NODEST_COLX,
	/* U+8548 */	JISX0208(0xe8fe),
	/* U+8549 */	JISX0208(0xbed6),
	/* U+854A */	JISX0208(0xbcc9),
	/* U+854B */	JISX0208(0xe9a3),
	/* U+854C */	U2E_NODEST_COLX,
	/* U+854D */	U2E_NODEST_COLX,
	/* U+854E */	JISX0208(0xb6be),
	/* U+854F */	IFX0213(JISX0213_2(0xf66b),	JISX0212(0xd942)),
	/* U+8550 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd943)),
	/* U+8551 */	IFX0213(JISX0213_2(0xf670),	JISX0212(0xd944)),
	/* U+8552 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd945)),
	/* U+8553 */	IFX0213(JISX0213_2(0xf671),	JISX0212(0xd946)),
	/* U+8554 */	U2E_NODEST_COLX,
	/* U+8555 */	JISX0208(0xe9a4),
	/* U+8556 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd947)),
	/* U+8557 */	JISX0208(0xc9f9),
	/* U+8558 */	JISX0208(0xe8fd),
	/* U+8559 */	IFX0213(JISX0213_1(0xfbb8),	JISX0212(0xd948)),
	/* U+855A */	JISX0208(0xe8d6),
	/* U+855B */	U2E_NODEST_COLX,
	/* U+855C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd949)),
	/* U+855D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd94a)),
	/* U+855E */	IFX0213(JISX0213_2(0xf672),	JISX0212(0xd94b)),
	/* U+855F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd94c)),
	/* U+8560 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd94d)),
	/* U+8561 */	IFX0213(JISX0213_2(0xf673),	JISX0212(0xd94e)),
	/* U+8562 */	IFX0213(JISX0213_2(0xf674),	JISX0212(0xd94f)),
	/* U+8563 */	JISX0208(0xe8fc),
	/* U+8564 */	IFX0213(JISX0213_1(0xfbb9),	JISX0212(0xd950)),
	/* U+8565 */	U2E_NODEST_COLX,
	/* U+8566 */	U2E_NODEST_COLX,
	/* U+8567 */	U2E_NODEST_COLX,
	/* U+8568 */	JISX0208(0xcfcf),
	/* U+8569 */	JISX0208(0xc6a2),
	/* U+856A */	JISX0208(0xc9f3),
	/* U+856B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd951)),
	/* U+856C */	U2E_NODEST_COLX,
	/* U+856D */	JISX0208(0xe9ab),
	/* U+856E */	U2E_NODEST_COLX,
	/* U+856F */	IFX0213(JISX0213_2(0xf66c),	JISX0212(0xd952)),
	/* U+8570 */	U2E_NODEST_COLX,
	/* U+8571 */	U2E_NODEST_COLX,
	/* U+8572 */	U2E_NODEST_COLX,
	/* U+8573 */	U2E_NODEST_COLX,
	/* U+8574 */	U2E_NODEST_COLX,
	/* U+8575 */	U2E_NODEST_COLX,
	/* U+8576 */	U2E_NODEST_COLX,
	/* U+8577 */	JISX0208(0xe9b1),
	/* U+8578 */	U2E_NODEST_COLX,
	/* U+8579 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd953)),
	/* U+857A */	IFX0213(JISX0213_1(0xfbbc),	JISX0212(0xd954)),
	/* U+857B */	IFX0213(JISX0213_2(0xf676),	JISX0212(0xd955)),
	/* U+857C */	U2E_NODEST_COLX,
	/* U+857D */	IFX0213(JISX0213_2(0xf677),	JISX0212(0xd956)),
	/* U+857E */	JISX0208(0xe9b2),
	/* U+857F */	IFX0213(JISX0213_2(0xf678),	JISX0212(0xd957)),
	/* U+8580 */	JISX0208(0xe9a5),
	/* U+8581 */	IFX0213(JISX0213_2(0xf679),	JISX0212(0xd958)),
	/* U+8582 */	U2E_NODEST_COLX,
	/* U+8583 */	U2E_NODEST_COLX,
	/* U+8584 */	JISX0208(0xc7f6),
	/* U+8585 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd959)),
	/* U+8586 */	IFX0213(JISX0213_2(0xf67a),	JISX0212(0xd95a)),
	/* U+8587 */	JISX0208(0xe9af),
	/* U+8588 */	JISX0208(0xe9a7),
	/* U+8589 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd95b)),
	/* U+858A */	JISX0208(0xe9a9),
	/* U+858B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd95c)),
	/* U+858C */	IFX0213(JISX0213_1(0xfbbd),	JISX0212(0xd95d)),
	/* U+858D */	U2E_NODEST_COLX,
	/* U+858E */	U2E_NODEST_COLX,
	/* U+858F */	IFX0213(JISX0213_1(0xfbbe),	JISX0212(0xd95e)),
	/* U+8590 */	JISX0208(0xe9b3),
	/* U+8591 */	JISX0208(0xe9a8),
	/* U+8592 */	U2E_NODEST_COLX,
	/* U+8593 */	IFX0213(JISX0213_2(0xf67b),	JISX0212(0xd95f)),
	/* U+8594 */	JISX0208(0xe9ac),
	/* U+8595 */	U2E_NODEST_COLX,
	/* U+8596 */	U2E_NODEST_COLX,
	/* U+8597 */	JISX0208(0xb1f2),
	/* U+8598 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd960)),
	/* U+8599 */	JISX0208(0xc6e5),
	/* U+859A */	U2E_NODEST_COLX,
	/* U+859B */	JISX0208(0xe9ad),
	/* U+859C */	JISX0208(0xe9b0),
	/* U+859D */	IFX0213(JISX0213_2(0xf67c),	JISX0212(0xd961)),
	/* U+859E */	U2E_NODEST_COLX,
	/* U+859F */	IFX0213(JISX0213_2(0xf67d),	JISX0212(0xd962)),
	/* U+85A0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd963)),
	/* U+85A1 */	U2E_NODEST_COLX,
	/* U+85A2 */	IFX0213(JISX0213_1(0xfbbf),	JISX0212(0xd964)),
	/* U+85A3 */	U2E_NODEST_COLX,
	/* U+85A4 */	JISX0208(0xe9a6),
	/* U+85A5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd965)),
	/* U+85A6 */	JISX0208(0xc1a6),
	/* U+85A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd966)),
	/* U+85A8 */	JISX0208(0xe9aa),
	/* U+85A9 */	JISX0208(0xbba7),
	/* U+85AA */	JISX0208(0xbfc5),
	/* U+85AB */	JISX0208(0xb7b0),
	/* U+85AC */	JISX0208(0xccf4),
	/* U+85AD */	IFX0213(JISX0213_1(0xfbbb),	JISX0212(0xd974)),
	/* U+85AE */	JISX0208(0xccf9),
	/* U+85AF */	JISX0208(0xbdf2),
	/* U+85B0 */	IFX0213(JISX0213_1(0xfbc0),	IBM(0xf461)),
	/* U+85B1 */	U2E_NODEST_COLX,
	/* U+85B2 */	U2E_NODEST_COLX,
	/* U+85B3 */	U2E_NODEST_COLX,
	/* U+85B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd967)),
	/* U+85B5 */	U2E_NODEST_COLX,
	/* U+85B6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd968)),
	/* U+85B7 */	IFX0213(JISX0213_2(0xf723),	JISX0212(0xd969)),
	/* U+85B8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd96a)),
	/* U+85B9 */	JISX0208(0xe9b7),
	/* U+85BA */	JISX0208(0xe9b5),
	/* U+85BB */	U2E_NODEST_COLX,
	/* U+85BC */	IFX0213(JISX0213_2(0xf724),	JISX0212(0xd96b)),
	/* U+85BD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd96c)),
	/* U+85BE */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd96d)),
	/* U+85BF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd96e)),
	/* U+85C0 */	U2E_NODEST_COLX,
	/* U+85C1 */	JISX0208(0xcfce),
	/* U+85C2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd96f)),
	/* U+85C3 */	U2E_NODEST_COLX,
	/* U+85C4 */	U2E_NODEST_COLX,
	/* U+85C5 */	U2E_NODEST_COLX,
	/* U+85C6 */	U2E_NODEST_COLX,
	/* U+85C7 */	IFX0213(JISX0213_2(0xf725),	JISX0212(0xd970)),
	/* U+85C8 */	U2E_NODEST_COLX,
	/* U+85C9 */	JISX0208(0xe9b4),
	/* U+85CA */	IFX0213(JISX0213_2(0xf726),	JISX0212(0xd971)),
	/* U+85CB */	IFX0213(JISX0213_1(0xfbc1),	JISX0212(0xd972)),
	/* U+85CC */	U2E_NODEST_COLX,
	/* U+85CD */	JISX0208(0xcdf5),
	/* U+85CE */	IFX0213(JISX0213_1(0xfbc2),	JISX0212(0xd973)),
	/* U+85CF */	JISX0208(0xe9b6),
	/* U+85D0 */	JISX0208(0xe9b8),
	/* U+85D1 */	U2E_NODEST_COLX,
	/* U+85D2 */	U2E_NODEST_COLX,
	/* U+85D3 */	U2E_NODEST_COLX,
	/* U+85D4 */	U2E_NODEST_COLX,
	/* U+85D5 */	JISX0208(0xe9b9),
	/* U+85D6 */	U2E_NODEST_COLX,
	/* U+85D7 */	U2E_NODEST_COLX,
	/* U+85D8 */	IFX0213(JISX0213_2(0xf727),	JISX0212(0xd975)),
	/* U+85D9 */	IFX0213(JISX0213_2(0xf728),	U2E_NODEST_COLX),
	/* U+85DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd976)),
	/* U+85DB */	U2E_NODEST_COLX,
	/* U+85DC */	JISX0208(0xe9bc),
	/* U+85DD */	JISX0208(0xe9ba),
	/* U+85DE */	U2E_NODEST_COLX,
	/* U+85DF */	IFX0213(JISX0213_2(0xf729),	JISX0212(0xd977)),
	/* U+85E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd978)),
	/* U+85E1 */	IFX0213(JISX0213_2(0xf72a),	U2E_NODEST_COLX),
	/* U+85E2 */	U2E_NODEST_COLX,
	/* U+85E3 */	U2E_NODEST_COLX,
	/* U+85E4 */	JISX0208(0xc6a3),
	/* U+85E5 */	JISX0208(0xe9bb),
	/* U+85E6 */	IFX0213(JISX0213_2(0xf72b),	JISX0212(0xd979)),
	/* U+85E7 */	U2E_NODEST_COLX,
	/* U+85E8 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd97a)),
	/* U+85E9 */	JISX0208(0xc8cd),
	/* U+85EA */	JISX0208(0xe9ae),
	/* U+85EB */	U2E_NODEST_COLX,
	/* U+85EC */	U2E_NODEST_COLX,
	/* U+85ED */	IFX0213(JISX0213_1(0xfbc3),	JISX0212(0xd97b)),
	/* U+85EE */	U2E_NODEST_COLX,
	/* U+85EF */	U2E_NODEST_COLX,
	/* U+85F0 */	U2E_NODEST_COLX,
	/* U+85F1 */	U2E_NODEST_COLX,
	/* U+85F2 */	U2E_NODEST_COLX,
	/* U+85F3 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd97c)),
	/* U+85F4 */	U2E_NODEST_COLX,
	/* U+85F5 */	U2E_NODEST_COLX,
	/* U+85F6 */	IFX0213(JISX0213_2(0xf72c),	JISX0212(0xd97d)),
	/* U+85F7 */	JISX0208(0xbdf3),
	/* U+85F8 */	U2E_NODEST_COLX,
	/* U+85F9 */	JISX0208(0xe9bd),
	/* U+85FA */	JISX0208(0xe9c2),
	/* U+85FB */	JISX0208(0xc1f4),
	/* U+85FC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xd97e)),
	/* U+85FD */	U2E_NODEST_COLX,
	/* U+85FE */	JISX0208(0xe9c1),
	/* U+85FF */	IFX0213(JISX0213_1(0xfbc5),	JISX0212(0xda21)),
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_86[] = {
	/* U+8600 */	IFX0213(JISX0213_2(0xf72d),	JISX0212(0xda22)),
	/* U+8601 */	U2E_NODEST_COLX,
	/* U+8602 */	JISX0208(0xe9a2),
	/* U+8603 */	U2E_NODEST_COLX,
	/* U+8604 */	IFX0213(JISX0213_1(0xfbc6),	JISX0212(0xda23)),
	/* U+8605 */	IFX0213(JISX0213_1(0xfbc7),	JISX0212(0xda24)),
	/* U+8606 */	JISX0208(0xe9c3),
	/* U+8607 */	JISX0208(0xc1c9),
	/* U+8608 */	U2E_NODEST_COLX,
	/* U+8609 */	U2E_NODEST_COLX,
	/* U+860A */	JISX0208(0xe9be),
	/* U+860B */	JISX0208(0xe9c0),
	/* U+860C */	U2E_NODEST_COLX,
	/* U+860D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda25)),
	/* U+860E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda26)),
	/* U+860F */	U2E_NODEST_COLX,
	/* U+8610 */	IFX0213(JISX0213_1(0xfbc8),	JISX0212(0xda27)),
	/* U+8611 */	IFX0213(JISX0213_2(0xf72e),	JISX0212(0xda28)),
	/* U+8612 */	IFX0213(JISX0213_1(0xfbc4),	JISX0212(0xda29)),
	/* U+8613 */	JISX0208(0xe9bf),
	/* U+8614 */	U2E_NODEST_COLX,
	/* U+8615 */	U2E_NODEST_COLX,
	/* U+8616 */	JISX0208(0xddb1),
	/* U+8617 */	JISX0208(0xdda2),
	/* U+8618 */	IFX0213(JISX0213_1(0xfbca),	JISX0212(0xda2a)),
	/* U+8619 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda2b)),
	/* U+861A */	JISX0208(0xe9c5),
	/* U+861B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda2c)),
	/* U+861C */	U2E_NODEST_COLX,
	/* U+861D */	U2E_NODEST_COLX,
	/* U+861E */	IFX0213(JISX0213_2(0xf72f),	JISX0212(0xda2d)),
	/* U+861F */	U2E_NODEST_COLX,
	/* U+8620 */	U2E_NODEST_COLX,
	/* U+8621 */	IFX0213(JISX0213_2(0xf730),	JISX0212(0xda2e)),
	/* U+8622 */	JISX0208(0xe9c4),
	/* U+8623 */	U2E_NODEST_COLX,
	/* U+8624 */	IFX0213(JISX0213_2(0xf731),	U2E_NODEST_COLX),
	/* U+8625 */	U2E_NODEST_COLX,
	/* U+8626 */	U2E_NODEST_COLX,
	/* U+8627 */	IFX0213(JISX0213_2(0xf732),	JISX0212(0xda2f)),
	/* U+8628 */	U2E_NODEST_COLX,
	/* U+8629 */	IFX0213(JISX0213_1(0xfbcb),	JISX0212(0xda30)),
	/* U+862A */	U2E_NODEST_COLX,
	/* U+862B */	U2E_NODEST_COLX,
	/* U+862C */	U2E_NODEST_COLX,
	/* U+862D */	JISX0208(0xcdf6),
	/* U+862E */	U2E_NODEST_COLX,
	/* U+862F */	JISX0208(0xe2bc),
	/* U+8630 */	JISX0208(0xe9c6),
	/* U+8631 */	U2E_NODEST_COLX,
	/* U+8632 */	U2E_NODEST_COLX,
	/* U+8633 */	U2E_NODEST_COLX,
	/* U+8634 */	U2E_NODEST_COLX,
	/* U+8635 */	U2E_NODEST_COLX,
	/* U+8636 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda31)),
	/* U+8637 */	U2E_NODEST_COLX,
	/* U+8638 */	IFX0213(JISX0213_1(0xfbcc),	JISX0212(0xda32)),
	/* U+8639 */	IFX0213(JISX0213_2(0xf734),	U2E_NODEST_COLX),
	/* U+863A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda33)),
	/* U+863B */	U2E_NODEST_COLX,
	/* U+863C */	IFX0213(JISX0213_2(0xf735),	JISX0212(0xda34)),
	/* U+863D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda35)),
	/* U+863E */	U2E_NODEST_COLX,
	/* U+863F */	JISX0208(0xe9c7),
	/* U+8640 */	IFX0213(JISX0213_2(0xf737),	JISX0212(0xda36)),
	/* U+8641 */	IFX0213(JISX0213_1(0xafe8),	JISX0212(0xb866)),
	/* U+8642 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda37)),
	/* U+8643 */	U2E_NODEST_COLX,
	/* U+8644 */	U2E_NODEST_COLX,
	/* U+8645 */	U2E_NODEST_COLX,
	/* U+8646 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda38)),
	/* U+8647 */	U2E_NODEST_COLX,
	/* U+8648 */	U2E_NODEST_COLX,
	/* U+8649 */	U2E_NODEST_COLX,
	/* U+864A */	U2E_NODEST_COLX,
	/* U+864B */	U2E_NODEST_COLX,
	/* U+864C */	U2E_NODEST_COLX,
	/* U+864D */	JISX0208(0xe9c8),
	/* U+864E */	JISX0208(0xb8d7),
	/* U+864F */	U2E_NODEST_COLX,
	/* U+8650 */	JISX0208(0xb5d4),
	/* U+8651 */	U2E_NODEST_COLX,
	/* U+8652 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda39)),
	/* U+8653 */	IFX0213(JISX0213_2(0xf739),	JISX0212(0xda3a)),
	/* U+8654 */	JISX0208(0xe9ca),
	/* U+8655 */	JISX0208(0xd1dd),
	/* U+8656 */	IFX0213(JISX0213_2(0xf73a),	JISX0212(0xda3b)),
	/* U+8657 */	IFX0213(JISX0213_1(0xfbcd),	JISX0212(0xda3c)),
	/* U+8658 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda3d)),
	/* U+8659 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda3e)),
	/* U+865A */	JISX0208(0xb5f5),
	/* U+865B */	IFX0213(JISX0213_1(0xfbce),	U2E_NODEST_COLX),
	/* U+865C */	JISX0208(0xceba),
	/* U+865D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda3f)),
	/* U+865E */	JISX0208(0xb6f3),
	/* U+865F */	JISX0208(0xe9cb),
	/* U+8660 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda40)),
	/* U+8661 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda41)),
	/* U+8662 */	IFX0213(JISX0213_1(0xfbd0),	JISX0212(0xda42)),
	/* U+8663 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda43)),
	/* U+8664 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda44)),
	/* U+8665 */	U2E_NODEST_COLX,
	/* U+8666 */	U2E_NODEST_COLX,
	/* U+8667 */	JISX0208(0xe9cc),
	/* U+8668 */	U2E_NODEST_COLX,
	/* U+8669 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda45)),
	/* U+866A */	U2E_NODEST_COLX,
	/* U+866B */	JISX0208(0xc3ee),
	/* U+866C */	IFX0213(JISX0213_1(0xfbd2),	JISX0212(0xda46)),
	/* U+866D */	U2E_NODEST_COLX,
	/* U+866E */	U2E_NODEST_COLX,
	/* U+866F */	IFX0213(JISX0213_2(0xf73b),	JISX0212(0xda47)),
	/* U+8670 */	U2E_NODEST_COLX,
	/* U+8671 */	JISX0208(0xe9cd),
	/* U+8672 */	U2E_NODEST_COLX,
	/* U+8673 */	U2E_NODEST_COLX,
	/* U+8674 */	U2E_NODEST_COLX,
	/* U+8675 */	IFX0213(JISX0213_1(0xfbd3),	JISX0212(0xda48)),
	/* U+8676 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda49)),
	/* U+8677 */	IFX0213(JISX0213_2(0xf73c),	JISX0212(0xda4a)),
	/* U+8678 */	U2E_NODEST_COLX,
	/* U+8679 */	JISX0208(0xc6fa),
	/* U+867A */	IFX0213(JISX0213_2(0xf73d),	JISX0212(0xda4b)),
	/* U+867B */	JISX0208(0xb0ba),
	/* U+867C */	U2E_NODEST_COLX,
	/* U+867D */	U2E_NODEST_COLX,
	/* U+867E */	U2E_NODEST_COLX,
	/* U+867F */	U2E_NODEST_COLX,
	/* U+8680 */	U2E_NODEST_COLX,
	/* U+8681 */	U2E_NODEST_COLX,
	/* U+8682 */	U2E_NODEST_COLX,
	/* U+8683 */	U2E_NODEST_COLX,
	/* U+8684 */	U2E_NODEST_COLX,
	/* U+8685 */	U2E_NODEST_COLX,
	/* U+8686 */	U2E_NODEST_COLX,
	/* U+8687 */	IFX0213(JISX0213_2(0xf73e),	U2E_NODEST_COLX),
	/* U+8688 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda6d)),
	/* U+8689 */	IFX0213(JISX0213_2(0xf73f),	U2E_NODEST_COLX),
	/* U+868A */	JISX0208(0xb2e3),
	/* U+868B */	JISX0208(0xe9d2),
	/* U+868C */	JISX0208(0xe9d3),
	/* U+868D */	IFX0213(JISX0213_2(0xf740),	JISX0212(0xda4c)),
	/* U+868E */	U2E_NODEST_COLX,
	/* U+868F */	U2E_NODEST_COLX,
	/* U+8690 */	U2E_NODEST_COLX,
	/* U+8691 */	IFX0213(JISX0213_2(0xf741),	JISX0212(0xda4d)),
	/* U+8692 */	U2E_NODEST_COLX,
	/* U+8693 */	JISX0208(0xe9ce),
	/* U+8694 */	U2E_NODEST_COLX,
	/* U+8695 */	JISX0208(0xbbbd),
	/* U+8696 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda4e)),
	/* U+8697 */	U2E_NODEST_COLX,
	/* U+8698 */	IFX0213(JISX0213_1(0xfbd4),	JISX0212(0xda4f)),
	/* U+8699 */	U2E_NODEST_COLX,
	/* U+869A */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda50)),
	/* U+869B */	U2E_NODEST_COLX,
	/* U+869C */	IFX0213(JISX0213_2(0xf742),	JISX0212(0xda51)),
	/* U+869D */	IFX0213(JISX0213_2(0xf743),	U2E_NODEST_COLX),
	/* U+869E */	U2E_NODEST_COLX,
	/* U+869F */	U2E_NODEST_COLX,
	/* U+86A0 */	U2E_NODEST_COLX,
	/* U+86A1 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda52)),
	/* U+86A2 */	U2E_NODEST_COLX,
	/* U+86A3 */	JISX0208(0xe9cf),
	/* U+86A4 */	JISX0208(0xc7c2),
	/* U+86A5 */	U2E_NODEST_COLX,
	/* U+86A6 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda53)),
	/* U+86A7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda54)),
	/* U+86A8 */	IFX0213(JISX0213_2(0xf744),	JISX0212(0xda55)),
	/* U+86A9 */	JISX0208(0xe9d0),
	/* U+86AA */	JISX0208(0xe9d1),
	/* U+86AB */	JISX0208(0xe9db),
	/* U+86AC */	U2E_NODEST_COLX,
	/* U+86AD */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda56)),
	/* U+86AE */	U2E_NODEST_COLX,
	/* U+86AF */	JISX0208(0xe9d5),
	/* U+86B0 */	JISX0208(0xe9d8),
	/* U+86B1 */	IFX0213(JISX0213_2(0xf746),	JISX0212(0xda57)),
	/* U+86B2 */	U2E_NODEST_COLX,
	/* U+86B3 */	IFX0213(JISX0213_2(0xf747),	JISX0212(0xda58)),
	/* U+86B4 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda59)),
	/* U+86B5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda5a)),
	/* U+86B6 */	JISX0208(0xe9d4),
	/* U+86B7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda5b)),
	/* U+86B8 */	IFX0213(JISX0213_1(0xfbd5),	JISX0212(0xda5c)),
	/* U+86B9 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda5d)),
	/* U+86BA */	U2E_NODEST_COLX,
	/* U+86BB */	U2E_NODEST_COLX,
	/* U+86BC */	U2E_NODEST_COLX,
	/* U+86BD */	U2E_NODEST_COLX,
	/* U+86BE */	U2E_NODEST_COLX,
	/* U+86BF */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda5e)),
	/* U+86C0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda5f)),
	/* U+86C1 */	IFX0213(JISX0213_2(0xf748),	JISX0212(0xda60)),
	/* U+86C2 */	U2E_NODEST_COLX,
	/* U+86C3 */	IFX0213(JISX0213_2(0xf749),	JISX0212(0xda61)),
	/* U+86C4 */	JISX0208(0xe9d6),
	/* U+86C5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda62)),
	/* U+86C6 */	JISX0208(0xe9d7),
	/* U+86C7 */	JISX0208(0xbcd8),
	/* U+86C8 */	U2E_NODEST_COLX,
	/* U+86C9 */	JISX0208(0xe9d9),
	/* U+86CA */	U2E_NODEST_COLX,
	/* U+86CB */	JISX0208(0xc3c1),
	/* U+86CC */	U2E_NODEST_COLX,
	/* U+86CD */	JISX0208(0xb7d6),
	/* U+86CE */	JISX0208(0xb3c2),
	/* U+86CF */	U2E_NODEST_COLX,
	/* U+86D0 */	U2E_NODEST_COLX,
	/* U+86D1 */	IFX0213(JISX0213_2(0xf74a),	JISX0212(0xda63)),
	/* U+86D2 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda64)),
	/* U+86D3 */	U2E_NODEST_COLX,
	/* U+86D4 */	JISX0208(0xe9dc),
	/* U+86D5 */	IFX0213(JISX0213_2(0xf74b),	JISX0212(0xda65)),
	/* U+86D6 */	U2E_NODEST_COLX,
	/* U+86D7 */	IFX0213(JISX0213_2(0xf74c),	JISX0212(0xda66)),
	/* U+86D8 */	U2E_NODEST_COLX,
	/* U+86D9 */	JISX0208(0xb3bf),
	/* U+86DA */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda67)),
	/* U+86DB */	JISX0208(0xe9e1),
	/* U+86DC */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda68)),
	/* U+86DD */	U2E_NODEST_COLX,
	/* U+86DE */	JISX0208(0xe9dd),
	/* U+86DF */	JISX0208(0xe9e0),
	/* U+86E0 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda69)),
	/* U+86E1 */	U2E_NODEST_COLX,
	/* U+86E2 */	U2E_NODEST_COLX,
	/* U+86E3 */	IFX0213(JISX0213_2(0xf74d),	JISX0212(0xda6a)),
	/* U+86E4 */	JISX0208(0xc8ba),
	/* U+86E5 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda6b)),
	/* U+86E6 */	IFX0213(JISX0213_2(0xf74e),	U2E_NODEST_COLX),
	/* U+86E7 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda6c)),
	/* U+86E8 */	U2E_NODEST_COLX,
	/* U+86E9 */	JISX0208(0xe9de),
	/* U+86EA */	U2E_NODEST_COLX,
	/* U+86EB */	U2E_NODEST_COLX,
	/* U+86EC */	JISX0208(0xe9df),
	/* U+86ED */	JISX0208(0xc9c8),
	/* U+86EE */	JISX0208(0xc8da),
	/* U+86EF */	JISX0208(0xe9e2),
	/* U+86F0 */	U2E_NODEST_COLX,
	/* U+86F1 */	U2E_NODEST_COLX,
	/* U+86F2 */	U2E_NODEST_COLX,
	/* U+86F3 */	U2E_NODEST_COLX,
	/* U+86F4 */	U2E_NODEST_COLX,
	/* U+86F5 */	U2E_NODEST_COLX,
	/* U+86F6 */	U2E_NODEST_COLX,
	/* U+86F7 */	U2E_NODEST_COLX,
	/* U+86F8 */	JISX0208(0xc2fd),
	/* U+86F9 */	JISX0208(0xe9ec),
	/* U+86FA */	IFX0213(JISX0213_1(0xfbd6),	JISX0212(0xda6e)),
	/* U+86FB */	JISX0208(0xe9e8),
	/* U+86FC */	IFX0213(JISX0213_1(0xfbd7),	JISX0212(0xda6f)),
	/* U+86FD */	IFX0213(JISX0213_1(0xfbd8),	JISX0212(0xda70)),
	/* U+86FE */	JISX0208(0xb2eb),
	/* U+86FF */	U2E_NODEST_COLX,
};

static const _jfp_euc16_t _jfp_tbl_ucs2_to_euc16_block_87[] = {
	/* U+8700 */	JISX0208(0xe9e6),
	/* U+8701 */	U2E_NODEST_COLX,
	/* U+8702 */	JISX0208(0xcbaa),
	/* U+8703 */	JISX0208(0xe9e7),
	/* U+8704 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda71)),
	/* U+8705 */	IFX0213(JISX0213_2(0xf750),	JISX0212(0xda72)),
	/* U+8706 */	JISX0208(0xe9e4),
	/* U+8707 */	IFX0213(JISX0213_2(0xf751),	JISX0212(0xda73)),
	/* U+8708 */	JISX0208(0xe9e5),
	/* U+8709 */	JISX0208(0xe9ea),
	/* U+870A */	JISX0208(0xe9ed),
	/* U+870B */	IFX0213(JISX0213_1(0xfbd9),	JISX0212(0xda74)),
	/* U+870C */	U2E_NODEST_COLX,
	/* U+870D */	JISX0208(0xe9eb),
	/* U+870E */	IFX0213(JISX0213_2(0xf752),	JISX0212(0xda75)),
	/* U+870F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda76)),
	/* U+8710 */	IFX0213(JISX0213_2(0xf753),	JISX0212(0xda77)),
	/* U+8711 */	JISX0208(0xe9e9),
	/* U+8712 */	JISX0208(0xe9e3),
	/* U+8713 */	IFX0213(JISX0213_2(0xf754),	JISX0212(0xda78)),
	/* U+8714 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda79)),
	/* U+8715 */	U2E_NODEST_COLX,
	/* U+8716 */	U2E_NODEST_COLX,
	/* U+8717 */	U2E_NODEST_COLX,
	/* U+8718 */	JISX0208(0xc3d8),
	/* U+8719 */	IFX0213(JISX0213_2(0xf755),	JISX0212(0xda7a)),
	/* U+871A */	JISX0208(0xe9f4),
	/* U+871B */	U2E_NODEST_COLX,
	/* U+871C */	JISX0208(0xccaa),
	/* U+871D */	U2E_NODEST_COLX,
	/* U+871E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xda7b)),
	/* U+871F */	IFX0213(JISX0213_2(0xf756),	JISX0212(0xda7c)),
	/* U+8720 */	U2E_NODEST_COLX,
	/* U+8721 */	IFX0213(JISX0213_2(0xf757),	JISX0212(0xda7d)),
	/* U+8722 */	U2E_NODEST_COLX,
	/* U+8723 */	IFX0213(JISX0213_2(0xf758),	JISX0212(0xda7e)),
	/* U+8724 */	U2E_NODEST_COLX,
	/* U+8725 */	JISX0208(0xe9f2),
	/* U+8726 */	U2E_NODEST_COLX,
	/* U+8727 */	U2E_NODEST_COLX,
	/* U+8728 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb21)),
	/* U+8729 */	JISX0208(0xe9f3),
	/* U+872A */	U2E_NODEST_COLX,
	/* U+872B */	U2E_NODEST_COLX,
	/* U+872C */	U2E_NODEST_COLX,
	/* U+872D */	U2E_NODEST_COLX,
	/* U+872E */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb22)),
	/* U+872F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb23)),
	/* U+8730 */	U2E_NODEST_COLX,
	/* U+8731 */	IFX0213(JISX0213_2(0xf759),	JISX0212(0xdb24)),
	/* U+8732 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb25)),
	/* U+8733 */	U2E_NODEST_COLX,
	/* U+8734 */	JISX0208(0xe9ee),
	/* U+8735 */	U2E_NODEST_COLX,
	/* U+8736 */	U2E_NODEST_COLX,
	/* U+8737 */	JISX0208(0xe9f0),
	/* U+8738 */	U2E_NODEST_COLX,
	/* U+8739 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb26)),
	/* U+873A */	IFX0213(JISX0213_2(0xf75a),	JISX0212(0xdb27)),
	/* U+873B */	JISX0208(0xe9f1),
	/* U+873C */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb28)),
	/* U+873D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb29)),
	/* U+873E */	IFX0213(JISX0213_2(0xf75b),	JISX0212(0xdb2a)),
	/* U+873F */	JISX0208(0xe9ef),
	/* U+8740 */	IFX0213(JISX0213_2(0xf75c),	JISX0212(0xdb2b)),
	/* U+8741 */	U2E_NODEST_COLX,
	/* U+8742 */	U2E_NODEST_COLX,
	/* U+8743 */	IFX0213(JISX0213_2(0xf75d),	JISX0212(0xdb2c)),
	/* U+8744 */	U2E_NODEST_COLX,
	/* U+8745 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb2d)),
	/* U+8746 */	U2E_NODEST_COLX,
	/* U+8747 */	U2E_NODEST_COLX,
	/* U+8748 */	U2E_NODEST_COLX,
	/* U+8749 */	JISX0208(0xc0e6),
	/* U+874A */	U2E_NODEST_COLX,
	/* U+874B */	JISX0208(0xcfb9),
	/* U+874C */	JISX0208(0xe9f8),
	/* U+874D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb2e)),
	/* U+874E */	JISX0208(0xe9f9),
	/* U+874F */	U2E_NODEST_COLX,
	/* U+8750 */	U2E_NODEST_COLX,
	/* U+8751 */	IFX0213(JISX0213_2(0xf75e),	U2E_NODEST_COLX),
	/* U+8752 */	U2E_NODEST_COLX,
	/* U+8753 */	JISX0208(0xeaa1),
	/* U+8754 */	U2E_NODEST_COLX,
	/* U+8755 */	JISX0208(0xbfaa),
	/* U+8756 */	U2E_NODEST_COLX,
	/* U+8757 */	JISX0208(0xe9fb),
	/* U+8758 */	IFX0213(JISX0213_2(0xf75f),	JISX0212(0xdb2f)),
	/* U+8759 */	JISX0208(0xe9fe),
	/* U+875A */	U2E_NODEST_COLX,
	/* U+875B */	U2E_NODEST_COLX,
	/* U+875C */	U2E_NODEST_COLX,
	/* U+875D */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb30)),
	/* U+875E */	U2E_NODEST_COLX,
	/* U+875F */	JISX0208(0xe9f6),
	/* U+8760 */	JISX0208(0xe9f5),
	/* U+8761 */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb31)),
	/* U+8762 */	U2E_NODEST_COLX,
	/* U+8763 */	JISX0208(0xeaa2),
	/* U+8764 */	IFX0213(JISX0213_2(0xf760),	JISX0212(0xdb32)),
	/* U+8765 */	IFX0213(JISX0213_2(0xf761),	JISX0212(0xdb33)),
	/* U+8766 */	JISX0208(0xb2dc),
	/* U+8767 */	U2E_NODEST_COLX,
	/* U+8768 */	JISX0208(0xe9fc),
	/* U+8769 */	U2E_NODEST_COLX,
	/* U+876A */	JISX0208(0xeaa3),
	/* U+876B */	U2E_NODEST_COLX,
	/* U+876C */	U2E_NODEST_COLX,
	/* U+876D */	U2E_NODEST_COLX,
	/* U+876E */	JISX0208(0xe9fd),
	/* U+876F */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb34)),
	/* U+8770 */	U2E_NODEST_COLX,
	/* U+8771 */	IFX0213(JISX0213_1(0xfbda),	JISX0212(0xdb35)),
	/* U+8772 */	IFX0213(JISX0213_2(0xf762),	JISX0212(0xdb36)),
	/* U+8773 */	U2E_NODEST_COLX,
	/* U+8774 */	JISX0208(0xe9fa),
	/* U+8775 */	U2E_NODEST_COLX,
	/* U+8776 */	JISX0208(0xc4b3),
	/* U+8777 */	U2E_NODEST_COLX,
	/* U+8778 */	JISX0208(0xe9f7),
	/* U+8779 */	U2E_NODEST_COLX,
	/* U+877A */	U2E_NODEST_COLX,
	/* U+877B */	IFX0213(U2E_NODEST_COLX,	JISX0212(0xdb37)),
	/* U+877C */	IFX0213(JISX0213_2(0xf763),	U2E_NODEST_COLX),
	/* U+877D */	U2E_NODEST_COLX,
	/* U+877E */	U2E_NODEST_COLX,
	/* U+877F */	JISX0208(0xc7e8),
	/*