/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed
 * under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


#ifndef	_JFP_JIS_TO_UCS2_H
#define	_JFP_JIS_TO_UCS2_H

/*
 * JIS to UCS-2 conversion
 * for iconv modules or STREAMS modules.
 * Please define one of these macros before including this header.
 * This list can grow in the future.
 *	JFP_J2U_STREAMS			STREAMS modules
 *	JFP_J2U_ICONV			basic iconv
 *	JFP_J2U_ICONV_JAVA		JDK conversion class compatible iconv
 *	JFP_J2U_ICONV_RFC1468		RFC1468 strict iconv
 *	JFP_J2U_ICONV_UNICODEINC	iconv based on Unicode Inc's table
 *	JFP_J2U_ICONV_MS932		iconv based on NT's mapping
 *	JFP_J2U_ICONV_X0213		iconv based on JIS X 0213
 * (When JFP_J2U_ICONV_* is defined, JFP_J2U_ICONV will be defined
 *  automatically in this header.)
 */

/*
 * Make "if defined(JFP_J2U_ICONV)" applicable to any iconv module.
 */
#if	defined(JFP_J2U_ICONV_JAVA) \
		|| defined(JFP_J2U_ICONV_RFC1468) \
		|| defined(JFP_J2U_ICONV_UNICODEINC) \
		|| defined(JFP_J2U_ICONV_MS932) \
		|| defined(JFP_J2U_ICONV_X0213)
#define	JFP_J2U_ICONV
#endif

/*
 * Check if required macro is defined.
 */
#if	! (defined(JFP_J2U_STREAMS) || defined(JFP_J2U_ICONV))
#error	"Please define JFP_J2U_STREAMS or JFP_J2U_ICONV_xxx."
#endif

#include	<jfp_ucs2_common.h>

#ifndef	NULL
#define	NULL	0
#endif	/* !NULL */

/*
 * Default destination (aka replacement character)
 * 	J2U_NODEST_COL2: for 2 column width character
 * 	J2U_NODEST_COL1: for 1 column width character
 * 	J2U_NODEST_COLX: for unknown (or undefined) column width character
 */
#define		J2U_NODEST_COL2	0xfffd
#define		J2U_NODEST_COL1	0xfffd
#define		J2U_NODEST_COLX	0xfffd


/*
 * C1 control characters
 */
#if	defined(JFP_J2U_STREAMS)
#define		C1CTRL(x)	(x)
#else	/* ! defined(JFP_J2U_STREAMS) */
#define		C1CTRL(x)	J2U_NODEST_COLX
#endif	/* defined(JFP_J2U_STREAMS) */

/*
 * Vendor defined characters
 */
#if	defined(JFP_J2U_ICONV_RFC1468) || defined(JFP_J2U_ICONV_JAVA)
#define		NEC13(x)	J2U_NODEST_COL2
#define		IBM(x)		J2U_NODEST_COL2
#else	/* ! (defined(JFP_J2U_ICONV_RFC1468) || defined(JFP_J2U_ICONV_JAVA)) */
#define		NEC13(x)	(x)
#define		IBM(x)		(x)
#endif	/* defined(JFP_J2U_ICONV_RFC1468) || defined(JFP_J2U_ICONV_JAVA) */

/*
 * User defined characters
 */
#if	defined(JFP_J2U_ICONV_RFC1468) || defined(JFP_J2U_ICONV_JAVA)
#define		UDC(x)		J2U_NODEST_COL2
#else	/* ! (defined(JFP_J2U_ICONV_RFC1468) || defined(JFP_J2U_ICONV_JAVA)) */
#define		UDC(x)		(x)
#endif	/* defined(JFP_J2U_ICONV_RFC1468) || defined(JFP_J2U_ICONV_JAVA) */

/*
 * JIS X 0213 (but not in JIS X 0208) character mapped to BMP character
 */
#if	defined(JFP_J2U_ICONV_X0213)
#define		X0213(x)		(x)
#else	/* ! defined(JFP_J2U_ICONV_X0213) */
#define		X0213(x)		J2U_NODEST_COL2
#endif	/* defined(JFP_J2U_ICONV_X0213) */

/*
 * JIS X 0213 character mapped to non-BMP character
 * Hight-surrogate for the character is given as (x).
 * When user of the table get it, need to look up separate table
 * to get low-surrogate (or UTF-32) value.
 */
#if	defined(JFP_J2U_ICONV_X0213)
#define		X0213NB(x)	(x)
#else	/* ! defined(JFP_J2U_ICONV_X0213) */
#define		X0213NB(x)	J2U_NODEST_COL2
#endif	/* defined(JFP_J2U_ICONV_X0213) */

/*
 * JIS X 0213 character mapped to what composed by two Unicode characters
 * When user of the table get X0213COMPOSE2, need to look up separate
 * table to get actual set of characters mapped.
 */
#if	defined(JFP_J2U_ICONV_X0213)
#define		X0213COMPOSE2	(0xffff)
#else	/* ! defined(JFP_J2U_ICONV_X0213) */
#define		X0213COMPOSE2	J2U_NODEST_COL2
#endif	/* defined(JFP_J2U_ICONV_X0213) */

/*
 * Some characters converted to different character depending on
 * conversion policy used.
 */
#if	defined(JFP_J2U_STREAMS)
#define		J201U_5C_DEST	(0x005c)	/* X 201 Yen sign */
#define		J201U_7E_DEST	(0x007e)	/* X 201 overline */
#define		J208U_0132_DEST	(0xff3c)	/* X 208 reverse solidus */
#define		J212U_0223_DEST	J2U_NODEST_COL1	/* X 212 tilde */
#define		J213U_0218_DEST	J2U_NODEST_COL1	/* X 213 tilde */
#elif	defined(JFP_J2U_ICONV_JAVA)
#define		J201U_5C_DEST	(0x005c)	/* X 201 Yen sign */
#define		J201U_7E_DEST	(0x007e)	/* X 201 overline */
#define		J208U_0132_DEST	(0xff3c)	/* X 208 reverse solidus */
#define		J212U_0223_DEST	J2U_NODEST_COL1	/* X 212 tilde */
#define		J213U_0218_DEST	J2U_NODEST_COL1	/* X 213 tilde */
#elif	defined(JFP_J2U_ICONV_UNICODEINC)
#define		J201U_5C_DEST	(0x00a5)	/* X 201 Yen sign */
#define		J201U_7E_DEST	(0x203e)	/* X 201 overline */
#define		J208U_0132_DEST	(0x005c)	/* X 208 reverse solidus */
#define		J212U_0223_DEST	(0x007e)	/* X 212 tilde */
#define		J213U_0218_DEST	J2U_NODEST_COL2	/* X 213 tilde */
#elif	defined(JFP_J2U_ICONV_X0213)
#define		J201U_5C_DEST	(0x005c)	/* X 201 Yen sign */
#define		J201U_7E_DEST	(0x007e)	/* X 201 overline */
#define		J208U_0132_DEST	(0xff3c)	/* X 208 reverse solidus */
#define		J212U_0223_DEST	J2U_NODEST_COL2	/* X 212 tilde */
#define		J213U_0218_DEST	(0xff5e)	/* X 213 tilde */
#elif	defined(JFP_J2U_ICONV)
#define		J201U_5C_DEST	(0x005c)	/* X 201 Yen sign */
#define		J201U_7E_DEST	(0x007e)	/* X 201 overline */
#define		J208U_0132_DEST	(0xff3c)	/* X 208 reverse solidus */
#define		J212U_0223_DEST	(0xff5e)	/* X 212 tilde */
#define		J213U_0218_DEST	J2U_NODEST_COL2	/* X 213 tilde */
#endif

/*
 * Tables
 */
static const _jfp_ucs2_t _jfp_tbl_jisx0201roman_to_ucs2[] = {
/* JIS X 0201 Roman */
    /* 00               01               02               03               */
       0x0000,          0x0001,          0x0002,          0x0003,
    /* 04               05               06               07               */
       0x0004,          0x0005,          0x0006,          0x0007,
    /* 08               09               0A               0B               */
       0x0008,          0x0009,          0x000a,          0x000b,
    /* 0C               0D               0E               0F               */
       0x000c,          0x000d,          0x000e,          0x000f,
    /* 10               11               12               13               */
       0x0010,          0x0011,          0x0012,          0x0013,
    /* 14               15               16               17               */
       0x0014,          0x0015,          0x0016,          0x0017,
    /* 18               19               1A               1B               */
       0x0018,          0x0019,          0x001a,          0x001b,
    /* 1C               1D               1E               1F               */
       0x001c,          0x001d,          0x001e,          0x001f,
    /* 20               21               22               23               */
       0x0020,          0x0021,          0x0022,          0x0023,
    /* 24               25               26               27               */
       0x0024,          0x0025,          0x0026,          0x0027,
    /* 28               29               2A               2B               */
       0x0028,          0x0029,          0x002a,          0x002b,
    /* 2C               2D               2E               2F               */
       0x002c,          0x002d,          0x002e,          0x002f,
    /* 30               31               32               33               */
       0x0030,          0x0031,          0x0032,          0x0033,
    /* 34               35               36               37               */
       0x0034,          0x0035,          0x0036,          0x0037,
    /* 38               39               3A               3B               */
       0x0038,          0x0039,          0x003a,          0x003b,
    /* 3C               3D               3E               3F               */
       0x003c,          0x003d,          0x003e,          0x003f,
    /* 40               41               42               43               */
       0x0040,          0x0041,          0x0042,          0x0043,
    /* 44               45               46               47               */
       0x0044,          0x0045,          0x0046,          0x0047,
    /* 48               49               4A               4B               */
       0x0048,          0x0049,          0x004a,          0x004b,
    /* 4C               4D               4E               4F               */
       0x004c,          0x004d,          0x004e,          0x004f,
    /* 50               51               52               53               */
       0x0050,          0x0051,          0x0052,          0x0053,
    /* 54               55               56               57               */
       0x0054,          0x0055,          0x0056,          0x0057,
    /* 58               59               5A               5B               */
       0x0058,          0x0059,          0x005a,          0x005b,
    /* 5C               5D               5E               5F               */
       J201U_5C_DEST,   0x005d,          0x005e,          0x005f,
    /* 60               61               62               63               */
       0x0060,          0x0061,          0x0062,          0x0063,
    /* 64               65               66               67               */
       0x0064,          0x0065,          0x0066,          0x0067,
    /* 68               69               6A               6B               */
       0x0068,          0x0069,          0x006a,          0x006b,
    /* 6C               6D               6E               6F               */
       0x006c,          0x006d,          0x006e,          0x006f,
    /* 70               71               72               73               */
       0x0070,          0x0071,          0x0072,          0x0073,
    /* 74               75               76               77               */
       0x0074,          0x0075,          0x0076,          0x0077,
    /* 78               79               7A               7B               */
       0x0078,          0x0079,          0x007a,          0x007b,
    /* 7C               7D               7E               7F               */
       0x007c,          0x007d,          J201U_7E_DEST,   0x007f,
};

static const _jfp_ucs2_t _jfp_tbl_c1control_to_ucs2[] = {
/* C1 control characters */
    /* 80               81               82               83               */
       C1CTRL(0x0080),  C1CTRL(0x0081),  C1CTRL(0x0082),  C1CTRL(0x0083),
    /* 84               85               86               87               */
       C1CTRL(0x0084),  C1CTRL(0x0085),  C1CTRL(0x0086),  C1CTRL(0x0087),
    /* 88               89               8A               8B               */
       C1CTRL(0x0088),  C1CTRL(0x0089),  C1CTRL(0x008a),  C1CTRL(0x008b),
    /* 8C               8D               8E               8F               */
       C1CTRL(0x008c),  C1CTRL(0x008d),  C1CTRL(0x008e),  C1CTRL(0x008f),
    /* 90               91               92               93               */
       C1CTRL(0x0090),  C1CTRL(0x0091),  C1CTRL(0x0092),  C1CTRL(0x0093),
    /* 94               95               96               97               */
       C1CTRL(0x0094),  C1CTRL(0x0095),  C1CTRL(0x0096),  C1CTRL(0x0097),
    /* 98               99               9A               9B               */
       C1CTRL(0x0098),  C1CTRL(0x0099),  C1CTRL(0x009a),  C1CTRL(0x009b),
    /* 9C               9D               9E               9F               */
       C1CTRL(0x009c),  C1CTRL(0x009d),  C1CTRL(0x009e),  C1CTRL(0x009f),
};

static const _jfp_ucs2_t _jfp_tbl_jisx0201kana_to_ucs2[] = {
/* JIS X 0201 Kana */
    /*                  A1               A2               A3               */
                        0xff61,          0xff62,          0xff63,
    /* A4               A4               A4               A4               */
       0xff64,          0xff65,          0xff66,          0xff67,
    /* A8               A8               A8               A8               */
       0xff68,          0xff69,          0xff6a,          0xff6b,
    /* AC               AC               AC               AC               */
       0xff6c,          0xff6d,          0xff6e,          0xff6f,
    /* B0               B0               B0               B0               */
       0xff70,          0xff71,          0xff72,          0xff73,
    /* B4               B4               B4               B4               */
       0xff74,          0xff75,          0xff76,          0xff77,
    /* B8               B8               B8               B8               */
       0xff78,          0xff79,          0xff7a,          0xff7b,
    /* BC               BC               BC               BC               */
       0xff7c,          0xff7d,          0xff7e,          0xff7f,
    /* C0               C0               C0               C0               */
       0xff80,          0xff81,          0xff82,          0xff83,
    /* C4               C4               C4               C4               */
       0xff84,          0xff85,          0xff86,          0xff87,
    /* C8               C8               C8               C8               */
       0xff88,          0xff89,          0xff8a,          0xff8b,
    /* CC               CC               CC               CC               */
       0xff8c,          0xff8d,          0xff8e,          0xff8f,
    /* D0               D0               D0               D0               */
       0xff90,          0xff91,          0xff92,          0xff93,
    /* D4               D4               D4               D4               */
       0xff94,          0xff95,          0xff96,          0xff97,
    /* D8               D8               D8               D8               */
       0xff98,          0xff99,          0xff9a,          0xff9b,
    /* DC               DC               DC               DC               */
       0xff9c,          0xff9d,          0xff9e,          0xff9f,
};

static const _jfp_ucs2_t _jfp_tbl_jisx0208_to_ucs2[] = {
/* JIS X 0208 (/ 0213 plane 1) row 1 */
    /*                   1                2                3               */
                        0x3000,          0x3001,          0x3002,
    /*  4                5                6                7               */
       0xff0c,          0xff0e,          0x30fb,          0xff1a,
    /*  8                9               10               11               */
       0xff1b,          0xff1f,          0xff01,          0x309b,
    /* 12               13               14               15               */
       0x309c,          0x00b4,          0xff40,          0x00a8,
    /* 16               17               18               19               */
       0xff3e,          0xffe3,          0xff3f,          0x30fd,
    /* 20               21               22               23               */
       0x30fe,          0x309d,          0x309e,          0x3003,
    /* 24               25               26               27               */
       0x4edd,          0x3005,          0x3006,          0x3007,
    /* 28               29               30               31               */
       0x30fc,          0x2015,          0x2010,          0xff0f,
#if	defined(JFP_J2U_ICONV_MS932)
    /* 32               33               34               35               */
       J208U_0132_DEST, 0xff5e,          0x2225,          0xff5c,
#else	/* !defined(JFP_J2U_ICONV_MS932) */
    /* 32               33               34               35               */
       J208U_0132_DEST, 0x301c,          0x2016,          0xff5c,
#endif	/* defined(JFP_J2U_ICONV_MS932) */
    /* 36               37               38               39               */
       0x2026,          0x2025,          0x2018,          0x2019,
    /* 40               41               42               43               */
       0x201c,          0x201d,          0xff08,          0xff09,
    /* 44               45               46               47               */
       0x3014,          0x3015,          0xff3b,          0xff3d,
    /* 48               49               50               51               */
       0xff5b,          0xff5d,          0x3008,          0x3009,
    /* 52               53               54               55               */
       0x300a,          0x300b,          0x300c,          0x300d,
    /* 56               57               58               59               */
       0x300e,          0x300f,          0x3010,          0x3011,
#if	defined(JFP_J2U_ICONV_MS932)
    /* 60               61               62               63               */
       0xff0b,          0xff0d,          0x00b1,          0x00d7,
#else	/* !defined(JFP_J2U_ICONV_MS932) */
    /* 60               61               62               63               */
       0xff0b,          0x2212,          0x00b1,          0x00d7,
#endif	/* defined(JFP_J2U_ICONV_MS932) */
    /* 64               65               66               67               */
       0x00f7,          0xff1d,          0x2260,          0xff1c,
    /* 68               69               70               71               */
       0xff1e,          0x2266,          0x2267,          0x221e,
    /* 72               73               74               75               */
       0x2234,          0x2642,          0x2640,          0x00b0,
    /* 76               77               78               79               */
       0x2032,          0x2033,          0x2103,          0xffe5,
#if	defined(JFP_J2U_ICONV_MS932)
    /* 80               81               82               83               */
       0xff04,          0xffe0,          0xffe1,          0xff05,
#else	/* !defined(JFP_J2U_ICONV_MS932) */
    /* 80               81               82               83               */
       0xff04,          0x00a2,          0x00a3,          0xff05,
#endif	/* defined(JFP_J2U_ICONV_MS932) */
    /* 84               85               86               87               */
       0xff03,          0xff06,          0xff0a,          0xff20,
    /* 88               89               90               91               */
       0x00a7,          0x2606,          0x2605,          0x25cb,
    /* 92               93               94                                */
       0x25cf,          0x25ce,          0x25c7,
/* JIS X 0208 (/ 0213 plane 1) row 2 */
    /*                   1                2                3               */
                        0x25c6,          0x25a1,          0x25a0,
    /*  4                5                6                7               */
       0x25b3,          0x25b2,          0x25bd,          0x25bc,
    /*  8                9               10               11               */
       0x203b,          0x3012,          0x2192,          0x2190,
    /* 12               13               14               15               */
       0x2191,          0x2193,          0x3013,          X0213(0x0027),
    /* 16               17               18               19               */
       X0213(0x0022),   X0213(0x002d),   J213U_0218_DEST, X0213(0x3033),
    /* 20               21               22               23               */
       X0213(0x3034),   X0213(0x3035),   X0213(0x303b),   X0213(0x303c),
    /* 24               25               26               27               */
       X0213(0x30ff),   X0213(0x309f),   0x2208,          0x220b,
    /* 28               29               30               31               */
       0x2286,          0x2287,          0x2282,          0x2283,
    /* 32               33               34               35               */
       0x222a,          0x2229,          X0213(0x2284),   X0213(0x2285),
    /* 36               37               38               39               */
       X0213(0x228a),   X0213(0x228b),   X0213(0x2209),   X0213(0x2205),
    /* 40               41               42               43               */
       X0213(0x2305),   X0213(0x2306),   0x2227,          0x2228,
#if	defined(JFP_J2U_ICONV_MS932)
    /* 44               45               46               47               */
       0xffe2,          0x21d2,          0x21d4,          0x2200,
#else	/* !defined(JFP_J2U_ICONV_MS932) */
    /* 44               45               46               47               */
       0x00ac,          0x21d2,          0x21d4,          0x2200,
#endif	/* defined(JFP_J2U_ICONV_MS932) */
    /* 48               49               50               51               */
       0x2203,          X0213(0x2295),   X0213(0x2296),   X0213(0x2297),
    /* 52               53               54               55               */
       X0213(0x2225),   X0213(0x2226),   X0213(0xff5f),   X0213(0xff60),
    /* 56               57               58               59               */
       X0213(0x3018),   X0213(0x3019),   X0213(0x3016),   X0213(0x3017),
    /* 60               61               62               63               */
       0x2220,          0x22a5,          0x2312,          0x2202,
    /* 64               65               66               67               */
       0x2207,          0x2261,          0x2252,          0x226a,
    /* 68               69               70               71               */
       0x226b,          0x221a,          0x223d,          0x221d,
    /* 72               73               74               75               */
       0x2235,          0x222b,          0x222c,          X0213(0x2262),
    /* 76               77               78               79               */
       X0213(0x2243),   X0213(0x2245),   X0213(0x2248),   X0213(0x2276),
    /* 80               81               82               83               */
       X0213(0x2277),   X0213(0x2194),   0x212b,          0x2030,
    /* 84               85               86               87               */
       0x266f,          0x266d,          0x266a,          0x2020,
    /* 88               89               90               91               */
       0x2021,          0x00b6,          X0213(0x266e),   X0213(0x266b),
    /* 92               93               94                                */
       X0213(0x266c),   X0213(0x2669),   0x25ef,
/* JIS X 0208 (/ 0213 plane 1) row 3 */
    /*                   1                2                3               */
                        X0213(0x25b7),   X0213(0x25b6),   X0213(0x25c1),
    /*  4                5                6                7               */
       X0213(0x25c0),   X0213(0x2197),   X0213(0x2198),   X0213(0x2196),
    /*  8                9               10               11               */
       X0213(0x2199),   X0213(0x21c4),   X0213(0x21e8),   X0213(0x21e6),
    /* 12               13               14               15               */
       X0213(0x21e7),   X0213(0x21e9),   X0213(0x2934),   X0213(0x2935),
    /* 16               17               18               19               */
       0xff10,          0xff11,          0xff12,          0xff13,
    /* 20               21               22               23               */
       0xff14,          0xff15,          0xff16,          0xff17,
    /* 24               25               26               27               */
       0xff18,          0xff19,          X0213(0x29bf),   X0213(0x25c9),
    /* 28               29               30               31               */
       X0213(0x303d),   X0213(0xfe46),   X0213(0xfe45),   X0213(0x25e6),
    /* 32               33               34               35               */
       X0213(0x2022),   0xff21,          0xff22,          0xff23,
    /* 36               37               38               39               */
       0xff24,          0xff25,          0xff26,          0xff27,
    /* 40               41               42               43               */
       0xff28,          0xff29,          0xff2a,          0xff2b,
    /* 44               45               46               47               */
       0xff2c,          0xff2d,          0xff2e,          0xff2f,
    /* 48               49               50               51               */
       0xff30,          0xff31,          0xff32,          0xff33,
    /* 52               53               54               55               */
       0xff34,          0xff35,          0xff36,          0xff37,
    /* 56               57               58               59               */
       0xff38,          0xff39,          0xff3a,          X0213(0x2213),
    /* 60               61               62               63               */
       X0213(0x2135),   X0213(0x210f),   X0213(0x33cb),   X0213(0x2113),
    /* 64               65               66               67               */
       X0213(0x2127),   0xff41,          0xff42,          0xff43,
    /* 68               69               70               71               */
       0xff44,          0xff45,          0xff46,          0xff47,
    /* 72               73               74               75               */
       0xff48,          0xff49,          0xff4a,          0xff4b,
    /* 76               77               78               79               */
       0xff4c,          0xff4d,          0xff4e,          0xff4f,
    /* 80               81               82               83               */
       0xff50,          0xff51,          0xff52,          0xff53,
    /* 84               85               86               87               */
       0xff54,          0xff55,          0xff56,          0xff57,
    /* 88               89               90               91               */
       0xff58,          0xff59,          0xff5a,          X0213(0x30a0),
    /* 92               93               94                                */
       X0213(0x2013),   X0213(0x29fa),   X0213(0x29fb),
/* JIS X 0208 (/ 0213 plane 1) row 4 */
    /*                   1                2                3               */
                        0x3041,          0x3042,          0x3043,
    /*  4                5                6                7               */
       0x3044,          0x3045,          0x3046,          0x3047,
    /*  8                9               10               11               */
       0x3048,          0x3049,          0x304a,          0x304b,
    /* 12               13               14               15               */
       0x304c,          0x304d,          0x304e,          0x304f,
    /* 16               17               18               19               */
       0x3050,          0x3051,          0x3052,          0x3053,
    /* 20               21               22               23               */
       0x3054,          0x3055,          0x3056,          0x3057,
    /* 24               25               26               27               */
       0x3058,          0x3059,          0x305a,          0x305b,
    /* 28               29               30               31               */
       0x305c,          0x305d,          0x305e,          0x305f,
    /* 32               33               34               35               */
       0x3060,          0x3061,          0x3062,          0x3063,
    /* 36               37               38               39               */
       0x3064,          0x3065,          0x3066,          0x3067,
    /* 40               41               42               43               */
       0x3068,          0x3069,          0x306a,          0x306b,
    /* 44               45               46               47               */
       0x306c,          0x306d,          0x306e,          0x306f,
    /* 48               49               50               51               */
       0x3070,          0x3071,          0x3072,          0x3073,
    /* 52               53               54               55               */
       0x3074,          0x3075,          0x3076,          0x3077,
    /* 56               57               58               59               */
       0x3078,          0x3079,          0x307a,          0x307b,
    /* 60               61               62               63               */
       0x307c,          0x307d,          0x307e,          0x307f,
    /* 64               65               66               67               */
       0x3080,          0x3081,          0x3082,          0x3083,
    /* 68               69               70               71               */
       0x3084,          0x3085,          0x3086,          0x3087,
    /* 72               73               74               75               */
       0x3088,          0x3089,          0x308a,          0x308b,
    /* 76               77               78               79               */
       0x308c,          0x308d,          0x308e,          0x308f,
    /* 80               81               82               83               */
       0x3090,          0x3091,          0x3092,          0x3093,
    /* 84               85               86               87               */
       X0213(0x3094),   X0213(0x3095),   X0213(0x3096),   X0213COMPOSE2,
    /* 88               89               90               91               */
       X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0208 (/ 0213 plane 1) row 5 */
    /*                   1                2                3               */
                        0x30a1,          0x30a2,          0x30a3,
    /*  4                5                6                7               */
       0x30a4,          0x30a5,          0x30a6,          0x30a7,
    /*  8                9               10               11               */
       0x30a8,          0x30a9,          0x30aa,          0x30ab,
    /* 12               13               14               15               */
       0x30ac,          0x30ad,          0x30ae,          0x30af,
    /* 16               17               18               19               */
       0x30b0,          0x30b1,          0x30b2,          0x30b3,
    /* 20               21               22               23               */
       0x30b4,          0x30b5,          0x30b6,          0x30b7,
    /* 24               25               26               27               */
       0x30b8,          0x30b9,          0x30ba,          0x30bb,
    /* 28               29               30               31               */
       0x30bc,          0x30bd,          0x30be,          0x30bf,
    /* 32               33               34               35               */
       0x30c0,          0x30c1,          0x30c2,          0x30c3,
    /* 36               37               38               39               */
       0x30c4,          0x30c5,          0x30c6,          0x30c7,
    /* 40               41               42               43               */
       0x30c8,          0x30c9,          0x30ca,          0x30cb,
    /* 44               45               46               47               */
       0x30cc,          0x30cd,          0x30ce,          0x30cf,
    /* 48               49               50               51               */
       0x30d0,          0x30d1,          0x30d2,          0x30d3,
    /* 52               53               54               55               */
       0x30d4,          0x30d5,          0x30d6,          0x30d7,
    /* 56               57               58               59               */
       0x30d8,          0x30d9,          0x30da,          0x30db,
    /* 60               61               62               63               */
       0x30dc,          0x30dd,          0x30de,          0x30df,
    /* 64               65               66               67               */
       0x30e0,          0x30e1,          0x30e2,          0x30e3,
    /* 68               69               70               71               */
       0x30e4,          0x30e5,          0x30e6,          0x30e7,
    /* 72               73               74               75               */
       0x30e8,          0x30e9,          0x30ea,          0x30eb,
    /* 76               77               78               79               */
       0x30ec,          0x30ed,          0x30ee,          0x30ef,
    /* 80               81               82               83               */
       0x30f0,          0x30f1,          0x30f2,          0x30f3,
    /* 84               85               86               87               */
       0x30f4,          0x30f5,          0x30f6,          X0213COMPOSE2,
    /* 88               89               90               91               */
       X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,
    /* 92               93               94                                */
       X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,
/* JIS X 0208 (/ 0213 plane 1) row 6 */
    /*                   1                2                3               */
                        0x0391,          0x0392,          0x0393,
    /*  4                5                6                7               */
       0x0394,          0x0395,          0x0396,          0x0397,
    /*  8                9               10               11               */
       0x0398,          0x0399,          0x039a,          0x039b,
    /* 12               13               14               15               */
       0x039c,          0x039d,          0x039e,          0x039f,
    /* 16               17               18               19               */
       0x03a0,          0x03a1,          0x03a3,          0x03a4,
    /* 20               21               22               23               */
       0x03a5,          0x03a6,          0x03a7,          0x03a8,
    /* 24               25               26               27               */
       0x03a9,          X0213(0x2664),   X0213(0x2660),   X0213(0x2662),
    /* 28               29               30               31               */
       X0213(0x2666),   X0213(0x2661),   X0213(0x2665),   X0213(0x2667),
    /* 32               33               34               35               */
       X0213(0x2663),   0x03b1,          0x03b2,          0x03b3,
    /* 36               37               38               39               */
       0x03b4,          0x03b5,          0x03b6,          0x03b7,
    /* 40               41               42               43               */
       0x03b8,          0x03b9,          0x03ba,          0x03bb,
    /* 44               45               46               47               */
       0x03bc,          0x03bd,          0x03be,          0x03bf,
    /* 48               49               50               51               */
       0x03c0,          0x03c1,          0x03c3,          0x03c4,
    /* 52               53               54               55               */
       0x03c5,          0x03c6,          0x03c7,          0x03c8,
    /* 56               57               58               59               */
       0x03c9,          X0213(0x03c2),   X0213(0x24f5),   X0213(0x24f6),
    /* 60               61               62               63               */
       X0213(0x24f7),   X0213(0x24f8),   X0213(0x24f9),   X0213(0x24fa),
    /* 64               65               66               67               */
       X0213(0x24fb),   X0213(0x24fc),   X0213(0x24fd),   X0213(0x24fe),
    /* 68               69               70               71               */
       X0213(0x2616),   X0213(0x2617),   X0213(0x3020),   X0213(0x260e),
    /* 72               73               74               75               */
       X0213(0x2600),   X0213(0x2601),   X0213(0x2602),   X0213(0x2603),
    /* 76               77               78               79               */
       X0213(0x2668),   X0213(0x25b1),   X0213(0x31f0),   X0213(0x31f1),
    /* 80               81               82               83               */
       X0213(0x31f2),   X0213(0x31f3),   X0213(0x31f4),   X0213(0x31f5),
    /* 84               85               86               87               */
       X0213(0x31f6),   X0213(0x31f7),   X0213(0x31f8),   X0213(0x31f9),
    /* 88               89               90               91               */
       X0213COMPOSE2,   X0213(0x31fa),   X0213(0x31fb),   X0213(0x31fc),
    /* 92               93               94                                */
       X0213(0x31fd),   X0213(0x31fe),   X0213(0x31ff),
/* JIS X 0208 (/ 0213 plane 1) row 7 */
    /*                   1                2                3               */
                        0x0410,          0x0411,          0x0412,
    /*  4                5                6                7               */
       0x0413,          0x0414,          0x0415,          0x0401,
    /*  8                9               10               11               */
       0x0416,          0x0417,          0x0418,          0x0419,
    /* 12               13               14               15               */
       0x041a,          0x041b,          0x041c,          0x041d,
    /* 16               17               18               19               */
       0x041e,          0x041f,          0x0420,          0x0421,
    /* 20               21               22               23               */
       0x0422,          0x0423,          0x0424,          0x0425,
    /* 24               25               26               27               */
       0x0426,          0x0427,          0x0428,          0x0429,
    /* 28               29               30               31               */
       0x042a,          0x042b,          0x042c,          0x042d,
    /* 32               33               34               35               */
       0x042e,          0x042f,          X0213(0x23be),   X0213(0x23bf),
    /* 36               37               38               39               */
       X0213(0x23c0),   X0213(0x23c1),   X0213(0x23c2),   X0213(0x23c3),
    /* 40               41               42               43               */
       X0213(0x23c4),   X0213(0x23c5),   X0213(0x23c6),   X0213(0x23c7),
    /* 44               45               46               47               */
       X0213(0x23c8),   X0213(0x23c9),   X0213(0x23ca),   X0213(0x23cb),
    /* 48               49               50               51               */
       X0213(0x23cc),   0x0430,          0x0431,          0x0432,
    /* 52               53               54               55               */
       0x0433,          0x0434,          0x0435,          0x0451,
    /* 56               57               58               59               */
       0x0436,          0x0437,          0x0438,          0x0439,
    /* 60               61               62               63               */
       0x043a,          0x043b,          0x043c,          0x043d,
    /* 64               65               66               67               */
       0x043e,          0x043f,          0x0440,          0x0441,
    /* 68               69               70               71               */
       0x0442,          0x0443,          0x0444,          0x0445,
    /* 72               73               74               75               */
       0x0446,          0x0447,          0x0448,          0x0449,
    /* 76               77               78               79               */
       0x044a,          0x044b,          0x044c,          0x044d,
    /* 80               81               82               83               */
       0x044e,          0x044f,          X0213(0x30f7),   X0213(0x30f8),
    /* 84               85               86               87               */
       X0213(0x30f9),   X0213(0x30fa),   X0213(0x22da),   X0213(0x22db),
    /* 88               89               90               91               */
       X0213(0x2153),   X0213(0x2154),   X0213(0x2155),   X0213(0x2713),
    /* 92               93               94                                */
       X0213(0x2318),   X0213(0x2423),   X0213(0x23ce),
/* JIS X 0208 (/ 0213 plane 1) row 8 */
    /*                   1                2                3               */
                        0x2500,          0x2502,          0x250c,
    /*  4                5                6                7               */
       0x2510,          0x2518,          0x2514,          0x251c,
    /*  8                9               10               11               */
       0x252c,          0x2524,          0x2534,          0x253c,
    /* 12               13               14               15               */
       0x2501,          0x2503,          0x250f,          0x2513,
    /* 16               17               18               19               */
       0x251b,          0x2517,          0x2523,          0x2533,
    /* 20               21               22               23               */
       0x252b,          0x253b,          0x254b,          0x2520,
    /* 24               25               26               27               */
       0x252f,          0x2528,          0x2537,          0x253f,
    /* 28               29               30               31               */
       0x251d,          0x2530,          0x2525,          0x2538,
    /* 32               33               34               35               */
       0x2542,          X0213(0x3251),   X0213(0x3252),   X0213(0x3253),
    /* 36               37               38               39               */
       X0213(0x3254),   X0213(0x3255),   X0213(0x3256),   X0213(0x3257),
    /* 40               41               42               43               */
       X0213(0x3258),   X0213(0x3259),   X0213(0x325a),   X0213(0x325b),
    /* 44               45               46               47               */
       X0213(0x325c),   X0213(0x325d),   X0213(0x325e),   X0213(0x325f),
    /* 48               49               50               51               */
       X0213(0x32b1),   X0213(0x32b2),   X0213(0x32b3),   X0213(0x32b4),
    /* 52               53               54               55               */
       X0213(0x32b5),   X0213(0x32b6),   X0213(0x32b7),   X0213(0x32b8),
    /* 56               57               58               59               */
       X0213(0x32b9),   X0213(0x32ba),   X0213(0x32bb),   X0213(0x32bc),
    /* 60               61               62               63               */
       X0213(0x32bd),   X0213(0x32be),   X0213(0x32bf),   J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, X0213(0x25d0),
    /* 72               73               74               75               */
       X0213(0x25d1),   X0213(0x25d2),   X0213(0x25d3),   X0213(0x203c),
    /* 76               77               78               79               */
       X0213(0x2047),   X0213(0x2048),   X0213(0x2049),   X0213(0x01cd),
    /* 80               81               82               83               */
       X0213(0x01ce),   X0213(0x01d0),   X0213(0x1e3e),   X0213(0x1e3f),
    /* 84               85               86               87               */
       X0213(0x01f8),   X0213(0x01f9),   X0213(0x01d1),   X0213(0x01d2),
    /* 88               89               90               91               */
       X0213(0x01d4),   X0213(0x01d6),   X0213(0x01d8),   X0213(0x01da),
    /* 92               93               94                                */
       X0213(0x01dc),   J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0208 (/ 0213 plane 1) row 9 */
    /*                   1                2                3               */
                        X0213(0x20ac),   X0213(0x00a0),   X0213(0x00a1),
    /*  4                5                6                7               */
       X0213(0x00a4),   X0213(0x00a6),   X0213(0x00a9),   X0213(0x00aa),
    /*  8                9               10               11               */
       X0213(0x00ab),   X0213(0x00ad),   X0213(0x00ae),   X0213(0x00af),
    /* 12               13               14               15               */
       X0213(0x00b2),   X0213(0x00b3),   X0213(0x00b7),   X0213(0x00b8),
    /* 16               17               18               19               */
       X0213(0x00b9),   X0213(0x00ba),   X0213(0x00bb),   X0213(0x00bc),
    /* 20               21               22               23               */
       X0213(0x00bd),   X0213(0x00be),   X0213(0x00bf),   X0213(0x00c0),
    /* 24               25               26               27               */
       X0213(0x00c1),   X0213(0x00c2),   X0213(0x00c3),   X0213(0x00c4),
    /* 28               29               30               31               */
       X0213(0x00c5),   X0213(0x00c6),   X0213(0x00c7),   X0213(0x00c8),
    /* 32               33               34               35               */
       X0213(0x00c9),   X0213(0x00ca),   X0213(0x00cb),   X0213(0x00cc),
    /* 36               37               38               39               */
       X0213(0x00cd),   X0213(0x00ce),   X0213(0x00cf),   X0213(0x00d0),
    /* 40               41               42               43               */
       X0213(0x00d1),   X0213(0x00d2),   X0213(0x00d3),   X0213(0x00d4),
    /* 44               45               46               47               */
       X0213(0x00d5),   X0213(0x00d6),   X0213(0x00d8),   X0213(0x00d9),
    /* 48               49               50               51               */
       X0213(0x00da),   X0213(0x00db),   X0213(0x00dc),   X0213(0x00dd),
    /* 52               53               54               55               */
       X0213(0x00de),   X0213(0x00df),   X0213(0x00e0),   X0213(0x00e1),
    /* 56               57               58               59               */
       X0213(0x00e2),   X0213(0x00e3),   X0213(0x00e4),   X0213(0x00e5),
    /* 60               61               62               63               */
       X0213(0x00e6),   X0213(0x00e7),   X0213(0x00e8),   X0213(0x00e9),
    /* 64               65               66               67               */
       X0213(0x00ea),   X0213(0x00eb),   X0213(0x00ec),   X0213(0x00ed),
    /* 68               69               70               71               */
       X0213(0x00ee),   X0213(0x00ef),   X0213(0x00f0),   X0213(0x00f1),
    /* 72               73               74               75               */
       X0213(0x00f2),   X0213(0x00f3),   X0213(0x00f4),   X0213(0x00f5),
    /* 76               77               78               79               */
       X0213(0x00f6),   X0213(0x00f8),   X0213(0x00f9),   X0213(0x00fa),
    /* 80               81               82               83               */
       X0213(0x00fb),   X0213(0x00fc),   X0213(0x00fd),   X0213(0x00fe),
    /* 84               85               86               87               */
       X0213(0x00ff),   X0213(0x0100),   X0213(0x012a),   X0213(0x016a),
    /* 88               89               90               91               */
       X0213(0x0112),   X0213(0x014c),   X0213(0x0101),   X0213(0x012b),
    /* 92               93               94                                */
       X0213(0x016b),   X0213(0x0113),   X0213(0x014d),
/* JIS X 0208 (/ 0213 plane 1) row 10 */
    /*                   1                2                3               */
                        X0213(0x0104),   X0213(0x02d8),   X0213(0x0141),
    /*  4                5                6                7               */
       X0213(0x013d),   X0213(0x015a),   X0213(0x0160),   X0213(0x015e),
    /*  8                9               10               11               */
       X0213(0x0164),   X0213(0x0179),   X0213(0x017d),   X0213(0x017b),
    /* 12               13               14               15               */
       X0213(0x0105),   X0213(0x02db),   X0213(0x0142),   X0213(0x013e),
    /* 16               17               18               19               */
       X0213(0x015b),   X0213(0x02c7),   X0213(0x0161),   X0213(0x015f),
    /* 20               21               22               23               */
       X0213(0x0165),   X0213(0x017a),   X0213(0x02dd),   X0213(0x017e),
    /* 24               25               26               27               */
       X0213(0x017c),   X0213(0x0154),   X0213(0x0102),   X0213(0x0139),
    /* 28               29               30               31               */
       X0213(0x0106),   X0213(0x010c),   X0213(0x0118),   X0213(0x011a),
    /* 32               33               34               35               */
       X0213(0x010e),   X0213(0x0143),   X0213(0x0147),   X0213(0x0150),
    /* 36               37               38               39               */
       X0213(0x0158),   X0213(0x016e),   X0213(0x0170),   X0213(0x0162),
    /* 40               41               42               43               */
       X0213(0x0155),   X0213(0x0103),   X0213(0x013a),   X0213(0x0107),
    /* 44               45               46               47               */
       X0213(0x010d),   X0213(0x0119),   X0213(0x011b),   X0213(0x010f),
    /* 48               49               50               51               */
       X0213(0x0111),   X0213(0x0144),   X0213(0x0148),   X0213(0x0151),
    /* 52               53               54               55               */
       X0213(0x0159),   X0213(0x016f),   X0213(0x0171),   X0213(0x0163),
    /* 56               57               58               59               */
       X0213(0x02d9),   X0213(0x0108),   X0213(0x011c),   X0213(0x0124),
    /* 60               61               62               63               */
       X0213(0x0134),   X0213(0x015c),   X0213(0x016c),   X0213(0x0109),
    /* 64               65               66               67               */
       X0213(0x011d),   X0213(0x0125),   X0213(0x0135),   X0213(0x015d),
    /* 68               69               70               71               */
       X0213(0x016d),   X0213(0x0271),   X0213(0x028b),   X0213(0x027e),
    /* 72               73               74               75               */
       X0213(0x0283),   X0213(0x0292),   X0213(0x026c),   X0213(0x026e),
    /* 76               77               78               79               */
       X0213(0x0279),   X0213(0x0288),   X0213(0x0256),   X0213(0x0273),
    /* 80               81               82               83               */
       X0213(0x027d),   X0213(0x0282),   X0213(0x0290),   X0213(0x027b),
    /* 84               85               86               87               */
       X0213(0x026d),   X0213(0x025f),   X0213(0x0272),   X0213(0x029d),
    /* 88               89               90               91               */
       X0213(0x028e),   X0213(0x0261),   X0213(0x014b),   X0213(0x0270),
    /* 92               93               94                                */
       X0213(0x0281),   X0213(0x0127),   X0213(0x0295),
/* JIS X 0208 (/ 0213 plane 1) row 11 */
    /*                   1                2                3               */
                        X0213(0x0294),   X0213(0x0266),   X0213(0x0298),
    /*  4                5                6                7               */
       X0213(0x01c2),   X0213(0x0253),   X0213(0x0257),   X0213(0x0284),
    /*  8                9               10               11               */
       X0213(0x0260),   X0213(0x0193),   X0213(0x0153),   X0213(0x0152),
    /* 12               13               14               15               */
       X0213(0x0268),   X0213(0x0289),   X0213(0x0258),   X0213(0x0275),
    /* 16               17               18               19               */
       X0213(0x0259),   X0213(0x025c),   X0213(0x025e),   X0213(0x0250),
    /* 20               21               22               23               */
       X0213(0x026f),   X0213(0x028a),   X0213(0x0264),   X0213(0x028c),
    /* 24               25               26               27               */
       X0213(0x0254),   X0213(0x0251),   X0213(0x0252),   X0213(0x028d),
    /* 28               29               30               31               */
       X0213(0x0265),   X0213(0x02a2),   X0213(0x02a1),   X0213(0x0255),
    /* 32               33               34               35               */
       X0213(0x0291),   X0213(0x027a),   X0213(0x0267),   X0213(0x025a),
    /* 36               37               38               39               */
       X0213COMPOSE2,   X0213(0x01fd),   X0213(0x1f70),   X0213(0x1f71),
    /* 40               41               42               43               */
       X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,
    /* 44               45               46               47               */
       X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,   X0213COMPOSE2,
    /* 48               49               50               51               */
       X0213(0x1f72),   X0213(0x1f73),   X0213(0x0361),   X0213(0x02c8),
    /* 52               53               54               55               */
       X0213(0x02cc),   X0213(0x02d0),   X0213(0x02d1),   X0213(0x0306),
    /* 56               57               58               59               */
       X0213(0x203f),   X0213(0x030b),   X0213(0x0301),   X0213(0x0304),
    /* 60               61               62               63               */
       X0213(0x0300),   X0213(0x030f),   X0213(0x030c),   X0213(0x0302),
    /* 64               65               66               67               */
       X0213(0x02e5),   X0213(0x02e6),   X0213(0x02e7),   X0213(0x02e8),
    /* 68               69               70               71               */
       X0213(0x02e9),   X0213COMPOSE2,   X0213COMPOSE2,   X0213(0x0325),
    /* 72               73               74               75               */
       X0213(0x032c),   X0213(0x0339),   X0213(0x031c),   X0213(0x031f),
    /* 76               77               78               79               */
       X0213(0x0320),   X0213(0x0308),   X0213(0x033d),   X0213(0x0329),
    /* 80               81               82               83               */
       X0213(0x032f),   X0213(0x02de),   X0213(0x0324),   X0213(0x0330),
    /* 84               85               86               87               */
       X0213(0x033c),   X0213(0x0334),   X0213(0x031d),   X0213(0x031e),
    /* 88               89               90               91               */
       X0213(0x0318),   X0213(0x0319),   X0213(0x032a),   X0213(0x033a),
    /* 92               93               94                                */
       X0213(0x033b),   X0213(0x0303),   X0213(0x031a),
/* JIS X 0208 (/ 0213 plane 1) row 12 */
    /*                   1                2                3               */
                        X0213(0x2776),   X0213(0x2777),   X0213(0x2778),
    /*  4                5                6                7               */
       X0213(0x2779),   X0213(0x277a),   X0213(0x277b),   X0213(0x277c),
    /*  8                9               10               11               */
       X0213(0x277d),   X0213(0x277e),   X0213(0x277f),   X0213(0x24eb),
    /* 12               13               14               15               */
       X0213(0x24ec),   X0213(0x24ed),   X0213(0x24ee),   X0213(0x24ef),
    /* 16               17               18               19               */
       X0213(0x24f0),   X0213(0x24f1),   X0213(0x24f2),   X0213(0x24f3),
    /* 20               21               22               23               */
       X0213(0x24f4),   X0213(0x2170),   X0213(0x2171),   X0213(0x2172),
    /* 24               25               26               27               */
       X0213(0x2173),   X0213(0x2174),   X0213(0x2175),   X0213(0x2176),
    /* 28               29               30               31               */
       X0213(0x2177),   X0213(0x2178),   X0213(0x2179),   X0213(0x217a),
    /* 32               33               34               35               */
       X0213(0x217b),   X0213(0x24d0),   X0213(0x24d1),   X0213(0x24d2),
    /* 36               37               38               39               */
       X0213(0x24d3),   X0213(0x24d4),   X0213(0x24d5),   X0213(0x24d6),
    /* 40               41               42               43               */
       X0213(0x24d7),   X0213(0x24d8),   X0213(0x24d9),   X0213(0x24da),
    /* 44               45               46               47               */
       X0213(0x24db),   X0213(0x24dc),   X0213(0x24dd),   X0213(0x24de),
    /* 48               49               50               51               */
       X0213(0x24df),   X0213(0x24e0),   X0213(0x24e1),   X0213(0x24e2),
    /* 52               53               54               55               */
       X0213(0x24e3),   X0213(0x24e4),   X0213(0x24e5),   X0213(0x24e6),
    /* 56               57               58               59               */
       X0213(0x24e7),   X0213(0x24e8),   X0213(0x24e9),   X0213(0x32d0),
    /* 60               61               62               63               */
       X0213(0x32d1),   X0213(0x32d2),   X0213(0x32d3),   X0213(0x32d4),
    /* 64               65               66               67               */
       X0213(0x32d5),   X0213(0x32d6),   X0213(0x32d7),   X0213(0x32d8),
    /* 68               69               70               71               */
       X0213(0x32d9),   X0213(0x32da),   X0213(0x32db),   X0213(0x32dc),
    /* 72               73               74               75               */
       X0213(0x32dd),   X0213(0x32de),   X0213(0x32df),   X0213(0x32e0),
    /* 76               77               78               79               */
       X0213(0x32e1),   X0213(0x32e2),   X0213(0x32e3),   X0213(0x32fa),
    /* 80               81               82               83               */
       X0213(0x32e9),   X0213(0x32e5),   X0213(0x32ed),   X0213(0x32ec),
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, X0213(0x2051),   X0213(0x2042),
#if	defined(JFP_J2U_ICONV_X0213)
/* JIS X 0213 plane 1 row 13 */
    /*                   1                2                3               */
                        X0213(0x2460),   X0213(0x2461),   X0213(0x2462),
    /*  4                5                6                7               */
       X0213(0x2463),   X0213(0x2464),   X0213(0x2465),   X0213(0x2466),
    /*  8                9               10               11               */
       X0213(0x2467),   X0213(0x2468),   X0213(0x2469),   X0213(0x246a),
    /* 12               13               14               15               */
       X0213(0x246b),   X0213(0x246c),   X0213(0x246d),   X0213(0x246e),
    /* 16               17               18               19               */
       X0213(0x246f),   X0213(0x2470),   X0213(0x2471),   X0213(0x2472),
    /* 20               21               22               23               */
       X0213(0x2473),   X0213(0x2160),   X0213(0x2161),   X0213(0x2162),
    /* 24               25               26               27               */
       X0213(0x2163),   X0213(0x2164),   X0213(0x2165),   X0213(0x2166),
    /* 28               29               30               31               */
       X0213(0x2167),   X0213(0x2168),   X0213(0x2169),   X0213(0x216a),
    /* 32               33               34               35               */
       X0213(0x3349),   X0213(0x3314),   X0213(0x3322),   X0213(0x334d),
    /* 36               37               38               39               */
       X0213(0x3318),   X0213(0x3327),   X0213(0x3303),   X0213(0x3336),
    /* 40               41               42               43               */
       X0213(0x3351),   X0213(0x3357),   X0213(0x330d),   X0213(0x3326),
    /* 44               45               46               47               */
       X0213(0x3323),   X0213(0x332b),   X0213(0x334a),   X0213(0x333b),
    /* 48               49               50               51               */
       X0213(0x339c),   X0213(0x339d),   X0213(0x339e),   X0213(0x338e),
    /* 52               53               54               55               */
       X0213(0x338f),   X0213(0x33c4),   X0213(0x33a1),   X0213(0x216b),
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, X0213(0x337b),
    /* 64               65               66               67               */
       X0213(0x301d),   X0213(0x301f),   X0213(0x2116),   X0213(0x33cd),
    /* 68               69               70               71               */
       X0213(0x2121),   X0213(0x32a4),   X0213(0x32a5),   X0213(0x32a6),
    /* 72               73               74               75               */
       X0213(0x32a7),   X0213(0x32a8),   X0213(0x3231),   X0213(0x3232),
    /* 76               77               78               79               */
       X0213(0x3239),   X0213(0x337e),   X0213(0x337d),   X0213(0x337c),
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, X0213(0x222e),
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       X0213(0x221f),   X0213(0x22bf),   J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, X0213(0x2756),   X0213(0x261e),
#else	/* !defined(JFP_J2U_ICONV_X0213) */
/* JIS X 0208 row 13 */
    /*                   1                2                3               */
                        NEC13(0x2460),   NEC13(0x2461),   NEC13(0x2462),
    /*  4                5                6                7               */
       NEC13(0x2463),   NEC13(0x2464),   NEC13(0x2465),   NEC13(0x2466),
    /*  8                9               10               11               */
       NEC13(0x2467),   NEC13(0x2468),   NEC13(0x2469),   NEC13(0x246a),
    /* 12               13               14               15               */
       NEC13(0x246b),   NEC13(0x246c),   NEC13(0x246d),   NEC13(0x246e),
    /* 16               17               18               19               */
       NEC13(0x246f),   NEC13(0x2470),   NEC13(0x2471),   NEC13(0x2472),
    /* 20               21               22               23               */
       NEC13(0x2473),   NEC13(0x2160),   NEC13(0x2161),   NEC13(0x2162),
    /* 24               25               26               27               */
       NEC13(0x2163),   NEC13(0x2164),   NEC13(0x2165),   NEC13(0x2166),
    /* 28               29               30               31               */
       NEC13(0x2167),   NEC13(0x2168),   NEC13(0x2169),   J2U_NODEST_COL2,
    /* 32               33               34               35               */
       NEC13(0x3349),   NEC13(0x3314),   NEC13(0x3322),   NEC13(0x334d),
    /* 36               37               38               39               */
       NEC13(0x3318),   NEC13(0x3327),   NEC13(0x3303),   NEC13(0x3336),
    /* 40               41               42               43               */
       NEC13(0x3351),   NEC13(0x3357),   NEC13(0x330d),   NEC13(0x3326),
    /* 44               45               46               47               */
       NEC13(0x3323),   NEC13(0x332b),   NEC13(0x334a),   NEC13(0x333b),
    /* 48               49               50               51               */
       NEC13(0x339c),   NEC13(0x339d),   NEC13(0x339e),   NEC13(0x338e),
    /* 52               53               54               55               */
       NEC13(0x338f),   NEC13(0x33c4),   NEC13(0x33a1),   J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, NEC13(0x337b),
    /* 64               65               66               67               */
       NEC13(0x301d),   NEC13(0x301f),   NEC13(0x2116),   NEC13(0x33cd),
    /* 68               69               70               71               */
       NEC13(0x2121),   NEC13(0x32a4),   NEC13(0x32a5),   NEC13(0x32a6),
    /* 72               73               74               75               */
       NEC13(0x32a7),   NEC13(0x32a8),   NEC13(0x3231),   NEC13(0x3232),
    /* 76               77               78               79               */
       NEC13(0x3239),   NEC13(0x337e),   NEC13(0x337d),   NEC13(0x337c),
    /* 80               81               82               83               */
       NEC13(0x2252),   NEC13(0x2261),   NEC13(0x222b),   NEC13(0x222e),
    /* 84               85               86               87               */
       NEC13(0x2211),   NEC13(0x221a),   NEC13(0x22a5),   NEC13(0x2220),
    /* 88               89               90               91               */
       NEC13(0x221f),   NEC13(0x22bf),   NEC13(0x2235),   NEC13(0x2229),
    /* 92               93               94                                */
       NEC13(0x222a),   J2U_NODEST_COL2, J2U_NODEST_COL2,
#endif	/* defined(JFP_J2U_ICONV_X0213) */
/* JIS X 0208 (/ 0213 plane 1) row 14 */
    /*                   1                2                3               */
                        X0213(0x4ff1),   X0213NB(0xd840), X0213(0x3402),
    /*  4                5                6                7               */
       X0213(0x4e28),   X0213(0x4e2f),   X0213(0x4e30),   X0213(0x4e8d),
    /*  8                9               10               11               */
       X0213(0x4ee1),   X0213(0x4efd),   X0213(0x4eff),   X0213(0x4f03),
    /* 12               13               14               15               */
       X0213(0x4f0b),   X0213(0x4f60),   X0213(0x4f48),   X0213(0x4f49),
    /* 16               17               18               19               */
       X0213(0x4f56),   X0213(0x4f5f),   X0213(0x4f6a),   X0213(0x4f6c),
    /* 20               21               22               23               */
       X0213(0x4f7e),   X0213(0x4f8a),   X0213(0x4f94),   X0213(0x4f97),
    /* 24               25               26               27               */
       X0213(0xfa30),   X0213(0x4fc9),   X0213(0x4fe0),   X0213(0x5001),
    /* 28               29               30               31               */
       X0213(0x5002),   X0213(0x500e),   X0213(0x5018),   X0213(0x5027),
    /* 32               33               34               35               */
       X0213(0x502e),   X0213(0x5040),   X0213(0x503b),   X0213(0x5041),
    /* 36               37               38               39               */
       X0213(0x5094),   X0213(0x50cc),   X0213(0x50f2),   X0213(0x50d0),
    /* 40               41               42               43               */
       X0213(0x50e6),   X0213(0xfa31),   X0213(0x5106),   X0213(0x5103),
    /* 44               45               46               47               */
       X0213(0x510b),   X0213(0x511e),   X0213(0x5135),   X0213(0x514a),
    /* 48               49               50               51               */
       X0213(0xfa32),   X0213(0x5155),   X0213(0x5157),   X0213(0x34b5),
    /* 52               53               54               55               */
       X0213(0x519d),   X0213(0x51c3),   X0213(0x51ca),   X0213(0x51de),
    /* 56               57               58               59               */
       X0213(0x51e2),   X0213(0x51ee),   X0213(0x5201),   X0213(0x34db),
    /* 60               61               62               63               */
       X0213(0x5213),   X0213(0x5215),   X0213(0x5249),   X0213(0x5257),
    /* 64               65               66               67               */
       X0213(0x5261),   X0213(0x5293),   X0213(0x52c8),   X0213(0xfa33),
    /* 68               69               70               71               */
       X0213(0x52cc),   X0213(0x52d0),   X0213(0x52d6),   X0213(0x52db),
    /* 72               73               74               75               */
       X0213(0xfa34),   X0213(0x52f0),   X0213(0x52fb),   X0213(0x5300),
    /* 76               77               78               79               */
       X0213(0x5307),   X0213(0x531c),   X0213(0xfa35),   X0213(0x5361),
    /* 80               81               82               83               */
       X0213(0x5363),   X0213(0x537d),   X0213(0x5393),   X0213(0x539d),
    /* 84               85               86               87               */
       X0213(0x53b2),   X0213(0x5412),   X0213(0x5427),   X0213(0x544d),
    /* 88               89               90               91               */
       X0213(0x549c),   X0213(0x546b),   X0213(0x5474),   X0213(0x547f),
    /* 92               93               94                                */
       X0213(0x5488),   X0213(0x5496),   X0213(0x54a1),
/* JIS X 0208 (/ 0213 plane 1) row 15 */
    /*                   1                2                3               */
                        X0213(0x54a9),   X0213(0x54c6),   X0213(0x54ff),
    /*  4                5                6                7               */
       X0213(0x550e),   X0213(0x552b),   X0213(0x5535),   X0213(0x5550),
    /*  8                9               10               11               */
       X0213(0x555e),   X0213(0x5581),   X0213(0x5586),   X0213(0x558e),
    /* 12               13               14               15               */
       X0213(0xfa36),   X0213(0x55ad),   X0213(0x55ce),   X0213(0xfa37),
    /* 16               17               18               19               */
       X0213(0x5608),   X0213(0x560e),   X0213(0x563b),   X0213(0x5649),
    /* 20               21               22               23               */
       X0213(0x5676),   X0213(0x5666),   X0213(0xfa38),   X0213(0x566f),
    /* 24               25               26               27               */
       X0213(0x5671),   X0213(0x5672),   X0213(0x5699),   X0213(0x569e),
    /* 28               29               30               31               */
       X0213(0x56a9),   X0213(0x56ac),   X0213(0x56b3),   X0213(0x56c9),
    /* 32               33               34               35               */
       X0213(0x56ca),   X0213(0x570a),   X0213NB(0xd844), X0213(0x5721),
    /* 36               37               38               39               */
       X0213(0x572f),   X0213(0x5733),   X0213(0x5734),   X0213(0x5770),
    /* 40               41               42               43               */
       X0213(0x5777),   X0213(0x577c),   X0213(0x579c),   X0213(0xfa0f),
    /* 44               45               46               47               */
       X0213NB(0xd844), X0213(0x57b8),   X0213(0x57c7),   X0213(0x57c8),
    /* 48               49               50               51               */
       X0213(0x57cf),   X0213(0x57e4),   X0213(0x57ed),   X0213(0x57f5),
    /* 52               53               54               55               */
       X0213(0x57f6),   X0213(0x57ff),   X0213(0x5809),   X0213(0xfa10),
    /* 56               57               58               59               */
       X0213(0x5861),   X0213(0x5864),   X0213(0xfa39),   X0213(0x587c),
    /* 60               61               62               63               */
       X0213(0x5889),   X0213(0x589e),   X0213(0xfa3a),   X0213(0x58a9),
    /* 64               65               66               67               */
       X0213NB(0xd845), X0213(0x58d2),   X0213(0x58ce),   X0213(0x58d4),
    /* 68               69               70               71               */
       X0213(0x58da),   X0213(0x58e0),   X0213(0x58e9),   X0213(0x590c),
    /* 72               73               74               75               */
       X0213(0x8641),   X0213(0x595d),   X0213(0x596d),   X0213(0x598b),
    /* 76               77               78               79               */
       X0213(0x5992),   X0213(0x59a4),   X0213(0x59c3),   X0213(0x59d2),
    /* 80               81               82               83               */
       X0213(0x59dd),   X0213(0x5a13),   X0213(0x5a23),   X0213(0x5a67),
    /* 84               85               86               87               */
       X0213(0x5a6d),   X0213(0x5a77),   X0213(0x5a7e),   X0213(0x5a84),
    /* 88               89               90               91               */
       X0213(0x5a9e),   X0213(0x5aa7),   X0213(0x5ac4),   X0213NB(0xd846),
    /* 92               93               94                                */
       X0213(0x5b19),   X0213(0x5b25),   X0213(0x525d),
/* JIS X 0208 (/ 0213 plane 1) row 16 */
    /*                   1                2                3               */
                        0x4e9c,          0x5516,          0x5a03,
    /*  4                5                6                7               */
       0x963f,          0x54c0,          0x611b,          0x6328,
    /*  8                9               10               11               */
       0x59f6,          0x9022,          0x8475,          0x831c,
    /* 12               13               14               15               */
       0x7a50,          0x60aa,          0x63e1,          0x6e25,
    /* 16               17               18               19               */
       0x65ed,          0x8466,          0x82a6,          0x9bf5,
    /* 20               21               22               23               */
       0x6893,          0x5727,          0x65a1,          0x6271,
    /* 24               25               26               27               */
       0x5b9b,          0x59d0,          0x867b,          0x98f4,
    /* 28               29               30               31               */
       0x7d62,          0x7dbe,          0x9b8e,          0x6216,
    /* 32               33               34               35               */
       0x7c9f,          0x88b7,          0x5b89,          0x5eb5,
    /* 36               37               38               39               */
       0x6309,          0x6697,          0x6848,          0x95c7,
    /* 40               41               42               43               */
       0x978d,          0x674f,          0x4ee5,          0x4f0a,
    /* 44               45               46               47               */
       0x4f4d,          0x4f9d,          0x5049,          0x56f2,
    /* 48               49               50               51               */
       0x5937,          0x59d4,          0x5a01,          0x5c09,
    /* 52               53               54               55               */
       0x60df,          0x610f,          0x6170,          0x6613,
    /* 56               57               58               59               */
       0x6905,          0x70ba,          0x754f,          0x7570,
    /* 60               61               62               63               */
       0x79fb,          0x7dad,          0x7def,          0x80c3,
    /* 64               65               66               67               */
       0x840e,          0x8863,          0x8b02,          0x9055,
    /* 68               69               70               71               */
       0x907a,          0x533b,          0x4e95,          0x4ea5,
    /* 72               73               74               75               */
       0x57df,          0x80b2,          0x90c1,          0x78ef,
    /* 76               77               78               79               */
       0x4e00,          0x58f1,          0x6ea2,          0x9038,
    /* 80               81               82               83               */
       0x7a32,          0x8328,          0x828b,          0x9c2f,
    /* 84               85               86               87               */
       0x5141,          0x5370,          0x54bd,          0x54e1,
    /* 88               89               90               91               */
       0x56e0,          0x59fb,          0x5f15,          0x98f2,
    /* 92               93               94                                */
       0x6deb,          0x80e4,          0x852d,
/* JIS X 0208 (/ 0213 plane 1) row 17 */
    /*                   1                2                3               */
                        0x9662,          0x9670,          0x96a0,
    /*  4                5                6                7               */
       0x97fb,          0x540b,          0x53f3,          0x5b87,
    /*  8                9               10               11               */
       0x70cf,          0x7fbd,          0x8fc2,          0x96e8,
    /* 12               13               14               15               */
       0x536f,          0x9d5c,          0x7aba,          0x4e11,
    /* 16               17               18               19               */
       0x7893,          0x81fc,          0x6e26,          0x5618,
    /* 20               21               22               23               */
       0x5504,          0x6b1d,          0x851a,          0x9c3b,
    /* 24               25               26               27               */
       0x59e5,          0x53a9,          0x6d66,          0x74dc,
    /* 28               29               30               31               */
       0x958f,          0x5642,          0x4e91,          0x904b,
    /* 32               33               34               35               */
       0x96f2,          0x834f,          0x990c,          0x53e1,
    /* 36               37               38               39               */
       0x55b6,          0x5b30,          0x5f71,          0x6620,
    /* 40               41               42               43               */
       0x66f3,          0x6804,          0x6c38,          0x6cf3,
    /* 44               45               46               47               */
       0x6d29,          0x745b,          0x76c8,          0x7a4e,
    /* 48               49               50               51               */
       0x9834,          0x82f1,          0x885b,          0x8a60,
    /* 52               53               54               55               */
       0x92ed,          0x6db2,          0x75ab,          0x76ca,
    /* 56               57               58               59               */
       0x99c5,          0x60a6,          0x8b01,          0x8d8a,
    /* 60               61               62               63               */
       0x95b2,          0x698e,          0x53ad,          0x5186,
    /* 64               65               66               67               */
       0x5712,          0x5830,          0x5944,          0x5bb4,
    /* 68               69               70               71               */
       0x5ef6,          0x6028,          0x63a9,          0x63f4,
    /* 72               73               74               75               */
       0x6cbf,          0x6f14,          0x708e,          0x7114,
    /* 76               77               78               79               */
       0x7159,          0x71d5,          0x733f,          0x7e01,
    /* 80               81               82               83               */
       0x8276,          0x82d1,          0x8597,          0x9060,
    /* 84               85               86               87               */
       0x925b,          0x9d1b,          0x5869,          0x65bc,
    /* 88               89               90               91               */
       0x6c5a,          0x7525,          0x51f9,          0x592e,
    /* 92               93               94                                */
       0x5965,          0x5f80,          0x5fdc,
/* JIS X 0208 (/ 0213 plane 1) row 18 */
    /*                   1                2                3               */
                        0x62bc,          0x65fa,          0x6a2a,
    /*  4                5                6                7               */
       0x6b27,          0x6bb4,          0x738b,          0x7fc1,
    /*  8                9               10               11               */
       0x8956,          0x9d2c,          0x9d0e,          0x9ec4,
    /* 12               13               14               15               */
       0x5ca1,          0x6c96,          0x837b,          0x5104,
    /* 16               17               18               19               */
       0x5c4b,          0x61b6,          0x81c6,          0x6876,
    /* 20               21               22               23               */
       0x7261,          0x4e59,          0x4ffa,          0x5378,
    /* 24               25               26               27               */
       0x6069,          0x6e29,          0x7a4f,          0x97f3,
    /* 28               29               30               31               */
       0x4e0b,          0x5316,          0x4eee,          0x4f55,
    /* 32               33               34               35               */
       0x4f3d,          0x4fa1,          0x4f73,          0x52a0,
    /* 36               37               38               39               */
       0x53ef,          0x5609,          0x590f,          0x5ac1,
    /* 40               41               42               43               */
       0x5bb6,          0x5be1,          0x79d1,          0x6687,
    /* 44               45               46               47               */
       0x679c,          0x67b6,          0x6b4c,          0x6cb3,
    /* 48               49               50               51               */
       0x706b,          0x73c2,          0x798d,          0x79be,
    /* 52               53               54               55               */
       0x7a3c,          0x7b87,          0x82b1,          0x82db,
    /* 56               57               58               59               */
       0x8304,          0x8377,          0x83ef,          0x83d3,
    /* 60               61               62               63               */
       0x8766,          0x8ab2,          0x5629,          0x8ca8,
    /* 64               65               66               67               */
       0x8fe6,          0x904e,          0x971e,          0x868a,
    /* 68               69               70               71               */
       0x4fc4,          0x5ce8,          0x6211,          0x7259,
    /* 72               73               74               75               */
       0x753b,          0x81e5,          0x82bd,          0x86fe,
    /* 76               77               78               79               */
       0x8cc0,          0x96c5,          0x9913,          0x99d5,
    /* 80               81               82               83               */
       0x4ecb,          0x4f1a,          0x89e3,          0x56de,
    /* 84               85               86               87               */
       0x584a,          0x58ca,          0x5efb,          0x5feb,
    /* 88               89               90               91               */
       0x602a,          0x6094,          0x6062,          0x61d0,
    /* 92               93               94                                */
       0x6212,          0x62d0,          0x6539,
/* JIS X 0208 (/ 0213 plane 1) row 19 */
    /*                   1                2                3               */
                        0x9b41,          0x6666,          0x68b0,
    /*  4                5                6                7               */
       0x6d77,          0x7070,          0x754c,          0x7686,
    /*  8                9               10               11               */
       0x7d75,          0x82a5,          0x87f9,          0x958b,
    /* 12               13               14               15               */
       0x968e,          0x8c9d,          0x51f1,          0x52be,
    /* 16               17               18               19               */
       0x5916,          0x54b3,          0x5bb3,          0x5d16,
    /* 20               21               22               23               */
       0x6168,          0x6982,          0x6daf,          0x788d,
    /* 24               25               26               27               */
       0x84cb,          0x8857,          0x8a72,          0x93a7,
    /* 28               29               30               31               */
       0x9ab8,          0x6d6c,          0x99a8,          0x86d9,
    /* 32               33               34               35               */
       0x57a3,          0x67ff,          0x86ce,          0x920e,
    /* 36               37               38               39               */
       0x5283,          0x5687,          0x5404,          0x5ed3,
    /* 40               41               42               43               */
       0x62e1,          0x64b9,          0x683c,          0x6838,
    /* 44               45               46               47               */
       0x6bbb,          0x7372,          0x78ba,          0x7a6b,
    /* 48               49               50               51               */
       0x899a,          0x89d2,          0x8d6b,          0x8f03,
    /* 52               53               54               55               */
       0x90ed,          0x95a3,          0x9694,          0x9769,
    /* 56               57               58               59               */
       0x5b66,          0x5cb3,          0x697d,          0x984d,
    /* 60               61               62               63               */
       0x984e,          0x639b,          0x7b20,          0x6a2b,
    /* 64               65               66               67               */
       0x6a7f,          0x68b6,          0x9c0d,          0x6f5f,
    /* 68               69               70               71               */
       0x5272,          0x559d,          0x6070,          0x62ec,
    /* 72               73               74               75               */
       0x6d3b,          0x6e07,          0x6ed1,          0x845b,
    /* 76               77               78               79               */
       0x8910,          0x8f44,          0x4e14,          0x9c39,
    /* 80               81               82               83               */
       0x53f6,          0x691b,          0x6a3a,          0x9784,
    /* 84               85               86               87               */
       0x682a,          0x515c,          0x7ac3,          0x84b2,
    /* 88               89               90               91               */
       0x91dc,          0x938c,          0x565b,          0x9d28,
    /* 92               93               94                                */
       0x6822,          0x8305,          0x8431,
/* JIS X 0208 (/ 0213 plane 1) row 20 */
    /*                   1                2                3               */
                        0x7ca5,          0x5208,          0x82c5,
    /*  4                5                6                7               */
       0x74e6,          0x4e7e,          0x4f83,          0x51a0,
    /*  8                9               10               11               */
       0x5bd2,          0x520a,          0x52d8,          0x52e7,
    /* 12               13               14               15               */
       0x5dfb,          0x559a,          0x582a,          0x59e6,
    /* 16               17               18               19               */
       0x5b8c,          0x5b98,          0x5bdb,          0x5e72,
    /* 20               21               22               23               */
       0x5e79,          0x60a3,          0x611f,          0x6163,
    /* 24               25               26               27               */
       0x61be,          0x63db,          0x6562,          0x67d1,
    /* 28               29               30               31               */
       0x6853,          0x68fa,          0x6b3e,          0x6b53,
    /* 32               33               34               35               */
       0x6c57,          0x6f22,          0x6f97,          0x6f45,
    /* 36               37               38               39               */
       0x74b0,          0x7518,          0x76e3,          0x770b,
    /* 40               41               42               43               */
       0x7aff,          0x7ba1,          0x7c21,          0x7de9,
    /* 44               45               46               47               */
       0x7f36,          0x7ff0,          0x809d,          0x8266,
    /* 48               49               50               51               */
       0x839e,          0x89b3,          0x8acc,          0x8cab,
    /* 52               53               54               55               */
       0x9084,          0x9451,          0x9593,          0x9591,
    /* 56               57               58               59               */
       0x95a2,          0x9665,          0x97d3,          0x9928,
    /* 60               61               62               63               */
       0x8218,          0x4e38,          0x542b,          0x5cb8,
    /* 64               65               66               67               */
       0x5dcc,          0x73a9,          0x764c,          0x773c,
    /* 68               69               70               71               */
       0x5ca9,          0x7feb,          0x8d0b,          0x96c1,
    /* 72               73               74               75               */
       0x9811,          0x9854,          0x9858,          0x4f01,
    /* 76               77               78               79               */
       0x4f0e,          0x5371,          0x559c,          0x5668,
    /* 80               81               82               83               */
       0x57fa,          0x5947,          0x5b09,          0x5bc4,
    /* 84               85               86               87               */
       0x5c90,          0x5e0c,          0x5e7e,          0x5fcc,
    /* 88               89               90               91               */
       0x63ee,          0x673a,          0x65d7,          0x65e2,
    /* 92               93               94                                */
       0x671f,          0x68cb,          0x68c4,
/* JIS X 0208 (/ 0213 plane 1) row 21 */
    /*                   1                2                3               */
                        0x6a5f,          0x5e30,          0x6bc5,
    /*  4                5                6                7               */
       0x6c17,          0x6c7d,          0x757f,          0x7948,
    /*  8                9               10               11               */
       0x5b63,          0x7a00,          0x7d00,          0x5fbd,
    /* 12               13               14               15               */
       0x898f,          0x8a18,          0x8cb4,          0x8d77,
    /* 16               17               18               19               */
       0x8ecc,          0x8f1d,          0x98e2,          0x9a0e,
    /* 20               21               22               23               */
       0x9b3c,          0x4e80,          0x507d,          0x5100,
    /* 24               25               26               27               */
       0x5993,          0x5b9c,          0x622f,          0x6280,
    /* 28               29               30               31               */
       0x64ec,          0x6b3a,          0x72a0,          0x7591,
    /* 32               33               34               35               */
       0x7947,          0x7fa9,          0x87fb,          0x8abc,
    /* 36               37               38               39               */
       0x8b70,          0x63ac,          0x83ca,          0x97a0,
    /* 40               41               42               43               */
       0x5409,          0x5403,          0x55ab,          0x6854,
    /* 44               45               46               47               */
       0x6a58,          0x8a70,          0x7827,          0x6775,
    /* 48               49               50               51               */
       0x9ecd,          0x5374,          0x5ba2,          0x811a,
    /* 52               53               54               55               */
       0x8650,          0x9006,          0x4e18,          0x4e45,
    /* 56               57               58               59               */
       0x4ec7,          0x4f11,          0x53ca,          0x5438,
    /* 60               61               62               63               */
       0x5bae,          0x5f13,          0x6025,          0x6551,
    /* 64               65               66               67               */
       0x673d,          0x6c42,          0x6c72,          0x6ce3,
    /* 68               69               70               71               */
       0x7078,          0x7403,          0x7a76,          0x7aae,
    /* 72               73               74               75               */
       0x7b08,          0x7d1a,          0x7cfe,          0x7d66,
    /* 76               77               78               79               */
       0x65e7,          0x725b,          0x53bb,          0x5c45,
    /* 80               81               82               83               */
       0x5de8,          0x62d2,          0x62e0,          0x6319,
    /* 84               85               86               87               */
       0x6e20,          0x865a,          0x8a31,          0x8ddd,
    /* 88               89               90               91               */
       0x92f8,          0x6f01,          0x79a6,          0x9b5a,
    /* 92               93               94                                */
       0x4ea8,          0x4eab,          0x4eac,
/* JIS X 0208 (/ 0213 plane 1) row 22 */
    /*                   1                2                3               */
                        0x4f9b,          0x4fa0,          0x50d1,
    /*  4                5                6                7               */
       0x5147,          0x7af6,          0x5171,          0x51f6,
    /*  8                9               10               11               */
       0x5354,          0x5321,          0x537f,          0x53eb,
    /* 12               13               14               15               */
       0x55ac,          0x5883,          0x5ce1,          0x5f37,
    /* 16               17               18               19               */
       0x5f4a,          0x602f,          0x6050,          0x606d,
    /* 20               21               22               23               */
       0x631f,          0x6559,          0x6a4b,          0x6cc1,
    /* 24               25               26               27               */
       0x72c2,          0x72ed,          0x77ef,          0x80f8,
    /* 28               29               30               31               */
       0x8105,          0x8208,          0x854e,          0x90f7,
    /* 32               33               34               35               */
       0x93e1,          0x97ff,          0x9957,          0x9a5a,
    /* 36               37               38               39               */
       0x4ef0,          0x51dd,          0x5c2d,          0x6681,
    /* 40               41               42               43               */
       0x696d,          0x5c40,          0x66f2,          0x6975,
    /* 44               45               46               47               */
       0x7389,          0x6850,          0x7c81,          0x50c5,
    /* 48               49               50               51               */
       0x52e4,          0x5747,          0x5dfe,          0x9326,
    /* 52               53               54               55               */
       0x65a4,          0x6b23,          0x6b3d,          0x7434,
    /* 56               57               58               59               */
       0x7981,          0x79bd,          0x7b4b,          0x7dca,
    /* 60               61               62               63               */
       0x82b9,          0x83cc,          0x887f,          0x895f,
    /* 64               65               66               67               */
       0x8b39,          0x8fd1,          0x91d1,          0x541f,
    /* 68               69               70               71               */
       0x9280,          0x4e5d,          0x5036,          0x53e5,
    /* 72               73               74               75               */
       0x533a,          0x72d7,          0x7396,          0x77e9,
    /* 76               77               78               79               */
       0x82e6,          0x8eaf,          0x99c6,          0x99c8,
    /* 80               81               82               83               */
       0x99d2,          0x5177,          0x611a,          0x865e,
    /* 84               85               86               87               */
       0x55b0,          0x7a7a,          0x5076,          0x5bd3,
    /* 88               89               90               91               */
       0x9047,          0x9685,          0x4e32,          0x6adb,
    /* 92               93               94                                */
       0x91e7,          0x5c51,          0x5c48,
/* JIS X 0208 (/ 0213 plane 1) row 23 */
    /*                   1                2                3               */
                        0x6398,          0x7a9f,          0x6c93,
    /*  4                5                6                7               */
       0x9774,          0x8f61,          0x7aaa,          0x718a,
    /*  8                9               10               11               */
       0x9688,          0x7c82,          0x6817,          0x7e70,
    /* 12               13               14               15               */
       0x6851,          0x936c,          0x52f2,          0x541b,
    /* 16               17               18               19               */
       0x85ab,          0x8a13,          0x7fa4,          0x8ecd,
    /* 20               21               22               23               */
       0x90e1,          0x5366,          0x8888,          0x7941,
    /* 24               25               26               27               */
       0x4fc2,          0x50be,          0x5211,          0x5144,
    /* 28               29               30               31               */
       0x5553,          0x572d,          0x73ea,          0x578b,
    /* 32               33               34               35               */
       0x5951,          0x5f62,          0x5f84,          0x6075,
    /* 36               37               38               39               */
       0x6176,          0x6167,          0x61a9,          0x63b2,
    /* 40               41               42               43               */
       0x643a,          0x656c,          0x666f,          0x6842,
    /* 44               45               46               47               */
       0x6e13,          0x7566,          0x7a3d,          0x7cfb,
    /* 48               49               50               51               */
       0x7d4c,          0x7d99,          0x7e4b,          0x7f6b,
    /* 52               53               54               55               */
       0x830e,          0x834a,          0x86cd,          0x8a08,
    /* 56               57               58               59               */
       0x8a63,          0x8b66,          0x8efd,          0x981a,
    /* 60               61               62               63               */
       0x9d8f,          0x82b8,          0x8fce,          0x9be8,
    /* 64               65               66               67               */
       0x5287,          0x621f,          0x6483,          0x6fc0,
    /* 68               69               70               71               */
       0x9699,          0x6841,          0x5091,          0x6b20,
    /* 72               73               74               75               */
       0x6c7a,          0x6f54,          0x7a74,          0x7d50,
    /* 76               77               78               79               */
       0x8840,          0x8a23,          0x6708,          0x4ef6,
    /* 80               81               82               83               */
       0x5039,          0x5026,          0x5065,          0x517c,
    /* 84               85               86               87               */
       0x5238,          0x5263,          0x55a7,          0x570f,
    /* 88               89               90               91               */
       0x5805,          0x5acc,          0x5efa,          0x61b2,
    /* 92               93               94                                */
       0x61f8,          0x62f3,          0x6372,
/* JIS X 0208 (/ 0213 plane 1) row 24 */
    /*                   1                2                3               */
                        0x691c,          0x6a29,          0x727d,
    /*  4                5                6                7               */
       0x72ac,          0x732e,          0x7814,          0x786f,
    /*  8                9               10               11               */
       0x7d79,          0x770c,          0x80a9,          0x898b,
    /* 12               13               14               15               */
       0x8b19,          0x8ce2,          0x8ed2,          0x9063,
    /* 16               17               18               19               */
       0x9375,          0x967a,          0x9855,          0x9a13,
    /* 20               21               22               23               */
       0x9e78,          0x5143,          0x539f,          0x53b3,
    /* 24               25               26               27               */
       0x5e7b,          0x5f26,          0x6e1b,          0x6e90,
    /* 28               29               30               31               */
       0x7384,          0x73fe,          0x7d43,          0x8237,
    /* 32               33               34               35               */
       0x8a00,          0x8afa,          0x9650,          0x4e4e,
    /* 36               37               38               39               */
       0x500b,          0x53e4,          0x547c,          0x56fa,
    /* 40               41               42               43               */
       0x59d1,          0x5b64,          0x5df1,          0x5eab,
    /* 44               45               46               47               */
       0x5f27,          0x6238,          0x6545,          0x67af,
    /* 48               49               50               51               */
       0x6e56,          0x72d0,          0x7cca,          0x88b4,
    /* 52               53               54               55               */
       0x80a1,          0x80e1,          0x83f0,          0x864e,
    /* 56               57               58               59               */
       0x8a87,          0x8de8,          0x9237,          0x96c7,
    /* 60               61               62               63               */
       0x9867,          0x9f13,          0x4e94,          0x4e92,
    /* 64               65               66               67               */
       0x4f0d,          0x5348,          0x5449,          0x543e,
    /* 68               69               70               71               */
       0x5a2f,          0x5f8c,          0x5fa1,          0x609f,
    /* 72               73               74               75               */
       0x68a7,          0x6a8e,          0x745a,          0x7881,
    /* 76               77               78               79               */
       0x8a9e,          0x8aa4,          0x8b77,          0x9190,
    /* 80               81               82               83               */
       0x4e5e,          0x9bc9,          0x4ea4,          0x4f7c,
    /* 84               85               86               87               */
       0x4faf,          0x5019,          0x5016,          0x5149,
    /* 88               89               90               91               */
       0x516c,          0x529f,          0x52b9,          0x52fe,
    /* 92               93               94                                */
       0x539a,          0x53e3,          0x5411,
/* JIS X 0208 (/ 0213 plane 1) row 25 */
    /*                   1                2                3               */
                        0x540e,          0x5589,          0x5751,
    /*  4                5                6                7               */
       0x57a2,          0x597d,          0x5b54,          0x5b5d,
    /*  8                9               10               11               */
       0x5b8f,          0x5de5,          0x5de7,          0x5df7,
    /* 12               13               14               15               */
       0x5e78,          0x5e83,          0x5e9a,          0x5eb7,
    /* 16               17               18               19               */
       0x5f18,          0x6052,          0x614c,          0x6297,
    /* 20               21               22               23               */
       0x62d8,          0x63a7,          0x653b,          0x6602,
    /* 24               25               26               27               */
       0x6643,          0x66f4,          0x676d,          0x6821,
    /* 28               29               30               31               */
       0x6897,          0x69cb,          0x6c5f,          0x6d2a,
    /* 32               33               34               35               */
       0x6d69,          0x6e2f,          0x6e9d,          0x7532,
    /* 36               37               38               39               */
       0x7687,          0x786c,          0x7a3f,          0x7ce0,
    /* 40               41               42               43               */
       0x7d05,          0x7d18,          0x7d5e,          0x7db1,
    /* 44               45               46               47               */
       0x8015,          0x8003,          0x80af,          0x80b1,
    /* 48               49               50               51               */
       0x8154,          0x818f,          0x822a,          0x8352,
    /* 52               53               54               55               */
       0x884c,          0x8861,          0x8b1b,          0x8ca2,
    /* 56               57               58               59               */
       0x8cfc,          0x90ca,          0x9175,          0x9271,
    /* 60               61               62               63               */
       0x783f,          0x92fc,          0x95a4,          0x964d,
    /* 64               65               66               67               */
       0x9805,          0x9999,          0x9ad8,          0x9d3b,
    /* 68               69               70               71               */
       0x525b,          0x52ab,          0x53f7,          0x5408,
    /* 72               73               74               75               */
       0x58d5,          0x62f7,          0x6fe0,          0x8c6a,
    /* 76               77               78               79               */
       0x8f5f,          0x9eb9,          0x514b,          0x523b,
    /* 80               81               82               83               */
       0x544a,          0x56fd,          0x7a40,          0x9177,
    /* 84               85               86               87               */
       0x9d60,          0x9ed2,          0x7344,          0x6f09,
    /* 88               89               90               91               */
       0x8170,          0x7511,          0x5ffd,          0x60da,
    /* 92               93               94                                */
       0x9aa8,          0x72db,          0x8fbc,
/* JIS X 0208 (/ 0213 plane 1) row 26 */
    /*                   1                2                3               */
                        0x6b64,          0x9803,          0x4eca,
    /*  4                5                6                7               */
       0x56f0,          0x5764,          0x58be,          0x5a5a,
    /*  8                9               10               11               */
       0x6068,          0x61c7,          0x660f,          0x6606,
    /* 12               13               14               15               */
       0x6839,          0x68b1,          0x6df7,          0x75d5,
    /* 16               17               18               19               */
       0x7d3a,          0x826e,          0x9b42,          0x4e9b,
    /* 20               21               22               23               */
       0x4f50,          0x53c9,          0x5506,          0x5d6f,
    /* 24               25               26               27               */
       0x5de6,          0x5dee,          0x67fb,          0x6c99,
    /* 28               29               30               31               */
       0x7473,          0x7802,          0x8a50,          0x9396,
    /* 32               33               34               35               */
       0x88df,          0x5750,          0x5ea7,          0x632b,
    /* 36               37               38               39               */
       0x50b5,          0x50ac,          0x518d,          0x6700,
    /* 40               41               42               43               */
       0x54c9,          0x585e,          0x59bb,          0x5bb0,
    /* 44               45               46               47               */
       0x5f69,          0x624d,          0x63a1,          0x683d,
    /* 48               49               50               51               */
       0x6b73,          0x6e08,          0x707d,          0x91c7,
    /* 52               53               54               55               */
       0x7280,          0x7815,          0x7826,          0x796d,
    /* 56               57               58               59               */
       0x658e,          0x7d30,          0x83dc,          0x88c1,
    /* 60               61               62               63               */
       0x8f09,          0x969b,          0x5264,          0x5728,
    /* 64               65               66               67               */
       0x6750,          0x7f6a,          0x8ca1,          0x51b4,
    /* 68               69               70               71               */
       0x5742,          0x962a,          0x583a,          0x698a,
    /* 72               73               74               75               */
       0x80b4,          0x54b2,          0x5d0e,          0x57fc,
    /* 76               77               78               79               */
       0x7895,          0x9dfa,          0x4f5c,          0x524a,
    /* 80               81               82               83               */
       0x548b,          0x643e,          0x6628,          0x6714,
    /* 84               85               86               87               */
       0x67f5,          0x7a84,          0x7b56,          0x7d22,
    /* 88               89               90               91               */
       0x932f,          0x685c,          0x9bad,          0x7b39,
    /* 92               93               94                                */
       0x5319,          0x518a,          0x5237,
/* JIS X 0208 (/ 0213 plane 1) row 27 */
    /*                   1                2                3               */
                        0x5bdf,          0x62f6,          0x64ae,
    /*  4                5                6                7               */
       0x64e6,          0x672d,          0x6bba,          0x85a9,
    /*  8                9               10               11               */
       0x96d1,          0x7690,          0x9bd6,          0x634c,
    /* 12               13               14               15               */
       0x9306,          0x9bab,          0x76bf,          0x6652,
    /* 16               17               18               19               */
       0x4e09,          0x5098,          0x53c2,          0x5c71,
    /* 20               21               22               23               */
       0x60e8,          0x6492,          0x6563,          0x685f,
    /* 24               25               26               27               */
       0x71e6,          0x73ca,          0x7523,          0x7b97,
    /* 28               29               30               31               */
       0x7e82,          0x8695,          0x8b83,          0x8cdb,
    /* 32               33               34               35               */
       0x9178,          0x9910,          0x65ac,          0x66ab,
    /* 36               37               38               39               */
       0x6b8b,          0x4ed5,          0x4ed4,          0x4f3a,
    /* 40               41               42               43               */
       0x4f7f,          0x523a,          0x53f8,          0x53f2,
    /* 44               45               46               47               */
       0x55e3,          0x56db,          0x58eb,          0x59cb,
    /* 48               49               50               51               */
       0x59c9,          0x59ff,          0x5b50,          0x5c4d,
    /* 52               53               54               55               */
       0x5e02,          0x5e2b,          0x5fd7,          0x601d,
    /* 56               57               58               59               */
       0x6307,          0x652f,          0x5b5c,          0x65af,
    /* 60               61               62               63               */
       0x65bd,          0x65e8,          0x679d,          0x6b62,
    /* 64               65               66               67               */
       0x6b7b,          0x6c0f,          0x7345,          0x7949,
    /* 68               69               70               71               */
       0x79c1,          0x7cf8,          0x7d19,          0x7d2b,
    /* 72               73               74               75               */
       0x80a2,          0x8102,          0x81f3,          0x8996,
    /* 76               77               78               79               */
       0x8a5e,          0x8a69,          0x8a66,          0x8a8c,
    /* 80               81               82               83               */
       0x8aee,          0x8cc7,          0x8cdc,          0x96cc,
    /* 84               85               86               87               */
       0x98fc,          0x6b6f,          0x4e8b,          0x4f3c,
    /* 88               89               90               91               */
       0x4f8d,          0x5150,          0x5b57,          0x5bfa,
    /* 92               93               94                                */
       0x6148,          0x6301,          0x6642,
/* JIS X 0208 (/ 0213 plane 1) row 28 */
    /*                   1                2                3               */
                        0x6b21,          0x6ecb,          0x6cbb,
    /*  4                5                6                7               */
       0x723e,          0x74bd,          0x75d4,          0x78c1,
    /*  8                9               10               11               */
       0x793a,          0x800c,          0x8033,          0x81ea,
    /* 12               13               14               15               */
       0x8494,          0x8f9e,          0x6c50,          0x9e7f,
    /* 16               17               18               19               */
       0x5f0f,          0x8b58,          0x9d2b,          0x7afa,
    /* 20               21               22               23               */
       0x8ef8,          0x5b8d,          0x96eb,          0x4e03,
    /* 24               25               26               27               */
       0x53f1,          0x57f7,          0x5931,          0x5ac9,
    /* 28               29               30               31               */
       0x5ba4,          0x6089,          0x6e7f,          0x6f06,
    /* 32               33               34               35               */
       0x75be,          0x8cea,          0x5b9f,          0x8500,
    /* 36               37               38               39               */
       0x7be0,          0x5072,          0x67f4,          0x829d,
    /* 40               41               42               43               */
       0x5c61,          0x854a,          0x7e1e,          0x820e,
    /* 44               45               46               47               */
       0x5199,          0x5c04,          0x6368,          0x8d66,
    /* 48               49               50               51               */
       0x659c,          0x716e,          0x793e,          0x7d17,
    /* 52               53               54               55               */
       0x8005,          0x8b1d,          0x8eca,          0x906e,
    /* 56               57               58               59               */
       0x86c7,          0x90aa,          0x501f,          0x52fa,
    /* 60               61               62               63               */
       0x5c3a,          0x6753,          0x707c,          0x7235,
    /* 64               65               66               67               */
       0x914c,          0x91c8,          0x932b,          0x82e5,
    /* 68               69               70               71               */
       0x5bc2,          0x5f31,          0x60f9,          0x4e3b,
    /* 72               73               74               75               */
       0x53d6,          0x5b88,          0x624b,          0x6731,
    /* 76               77               78               79               */
       0x6b8a,          0x72e9,          0x73e0,          0x7a2e,
    /* 80               81               82               83               */
       0x816b,          0x8da3,          0x9152,          0x9996,
    /* 84               85               86               87               */
       0x5112,          0x53d7,          0x546a,          0x5bff,
    /* 88               89               90               91               */
       0x6388,          0x6a39,          0x7dac,          0x9700,
    /* 92               93               94                                */
       0x56da,          0x53ce,          0x5468,
/* JIS X 0208 (/ 0213 plane 1) row 29 */
    /*                   1                2                3               */
                        0x5b97,          0x5c31,          0x5dde,
    /*  4                5                6                7               */
       0x4fee,          0x6101,          0x62fe,          0x6d32,
    /*  8                9               10               11               */
       0x79c0,          0x79cb,          0x7d42,          0x7e4d,
    /* 12               13               14               15               */
       0x7fd2,          0x81ed,          0x821f,          0x8490,
    /* 16               17               18               19               */
       0x8846,          0x8972,          0x8b90,          0x8e74,
    /* 20               21               22               23               */
       0x8f2f,          0x9031,          0x914b,          0x916c,
    /* 24               25               26               27               */
       0x96c6,          0x919c,          0x4ec0,          0x4f4f,
    /* 28               29               30               31               */
       0x5145,          0x5341,          0x5f93,          0x620e,
    /* 32               33               34               35               */
       0x67d4,          0x6c41,          0x6e0b,          0x7363,
    /* 36               37               38               39               */
       0x7e26,          0x91cd,          0x9283,          0x53d4,
    /* 40               41               42               43               */
       0x5919,          0x5bbf,          0x6dd1,          0x795d,
    /* 44               45               46               47               */
       0x7e2e,          0x7c9b,          0x587e,          0x719f,
    /* 48               49               50               51               */
       0x51fa,          0x8853,          0x8ff0,          0x4fca,
    /* 52               53               54               55               */
       0x5cfb,          0x6625,          0x77ac,          0x7ae3,
    /* 56               57               58               59               */
       0x821c,          0x99ff,          0x51c6,          0x5faa,
    /* 60               61               62               63               */
       0x65ec,          0x696f,          0x6b89,          0x6df3,
    /* 64               65               66               67               */
       0x6e96,          0x6f64,          0x76fe,          0x7d14,
    /* 68               69               70               71               */
       0x5de1,          0x9075,          0x9187,          0x9806,
    /* 72               73               74               75               */
       0x51e6,          0x521d,          0x6240,          0x6691,
    /* 76               77               78               79               */
       0x66d9,          0x6e1a,          0x5eb6,          0x7dd2,
    /* 80               81               82               83               */
       0x7f72,          0x66f8,          0x85af,          0x85f7,
    /* 84               85               86               87               */
       0x8af8,          0x52a9,          0x53d9,          0x5973,
    /* 88               89               90               91               */
       0x5e8f,          0x5f90,          0x6055,          0x92e4,
    /* 92               93               94                                */
       0x9664,          0x50b7,          0x511f,
/* JIS X 0208 (/ 0213 plane 1) row 30 */
    /*                   1                2                3               */
                        0x52dd,          0x5320,          0x5347,
    /*  4                5                6                7               */
       0x53ec,          0x54e8,          0x5546,          0x5531,
    /*  8                9               10               11               */
       0x5617,          0x5968,          0x59be,          0x5a3c,
    /* 12               13               14               15               */
       0x5bb5,          0x5c06,          0x5c0f,          0x5c11,
    /* 16               17               18               19               */
       0x5c1a,          0x5e84,          0x5e8a,          0x5ee0,
    /* 20               21               22               23               */
       0x5f70,          0x627f,          0x6284,          0x62db,
    /* 24               25               26               27               */
       0x638c,          0x6377,          0x6607,          0x660c,
    /* 28               29               30               31               */
       0x662d,          0x6676,          0x677e,          0x68a2,
    /* 32               33               34               35               */
       0x6a1f,          0x6a35,          0x6cbc,          0x6d88,
    /* 36               37               38               39               */
       0x6e09,          0x6e58,          0x713c,          0x7126,
    /* 40               41               42               43               */
       0x7167,          0x75c7,          0x7701,          0x785d,
    /* 44               45               46               47               */
       0x7901,          0x7965,          0x79f0,          0x7ae0,
    /* 48               49               50               51               */
       0x7b11,          0x7ca7,          0x7d39,          0x8096,
    /* 52               53               54               55               */
       0x83d6,          0x848b,          0x8549,          0x885d,
    /* 56               57               58               59               */
       0x88f3,          0x8a1f,          0x8a3c,          0x8a54,
    /* 60               61               62               63               */
       0x8a73,          0x8c61,          0x8cde,          0x91a4,
    /* 64               65               66               67               */
       0x9266,          0x937e,          0x9418,          0x969c,
    /* 68               69               70               71               */
       0x9798,          0x4e0a,          0x4e08,          0x4e1e,
    /* 72               73               74               75               */
       0x4e57,          0x5197,          0x5270,          0x57ce,
    /* 76               77               78               79               */
       0x5834,          0x58cc,          0x5b22,          0x5e38,
    /* 80               81               82               83               */
       0x60c5,          0x64fe,          0x6761,          0x6756,
    /* 84               85               86               87               */
       0x6d44,          0x72b6,          0x7573,          0x7a63,
    /* 88               89               90               91               */
       0x84b8,          0x8b72,          0x91b8,          0x9320,
    /* 92               93               94                                */
       0x5631,          0x57f4,          0x98fe,
/* JIS X 0208 (/ 0213 plane 1) row 31 */
    /*                   1                2                3               */
                        0x62ed,          0x690d,          0x6b96,
    /*  4                5                6                7               */
       0x71ed,          0x7e54,          0x8077,          0x8272,
    /*  8                9               10               11               */
       0x89e6,          0x98df,          0x8755,          0x8fb1,
    /* 12               13               14               15               */
       0x5c3b,          0x4f38,          0x4fe1,          0x4fb5,
    /* 16               17               18               19               */
       0x5507,          0x5a20,          0x5bdd,          0x5be9,
    /* 20               21               22               23               */
       0x5fc3,          0x614e,          0x632f,          0x65b0,
    /* 24               25               26               27               */
       0x664b,          0x68ee,          0x699b,          0x6d78,
    /* 28               29               30               31               */
       0x6df1,          0x7533,          0x75b9,          0x771f,
    /* 32               33               34               35               */
       0x795e,          0x79e6,          0x7d33,          0x81e3,
    /* 36               37               38               39               */
       0x82af,          0x85aa,          0x89aa,          0x8a3a,
    /* 40               41               42               43               */
       0x8eab,          0x8f9b,          0x9032,          0x91dd,
    /* 44               45               46               47               */
       0x9707,          0x4eba,          0x4ec1,          0x5203,
    /* 48               49               50               51               */
       0x5875,          0x58ec,          0x5c0b,          0x751a,
    /* 52               53               54               55               */
       0x5c3d,          0x814e,          0x8a0a,          0x8fc5,
    /* 56               57               58               59               */
       0x9663,          0x976d,          0x7b25,          0x8acf,
    /* 60               61               62               63               */
       0x9808,          0x9162,          0x56f3,          0x53a8,
    /* 64               65               66               67               */
       0x9017,          0x5439,          0x5782,          0x5e25,
    /* 68               69               70               71               */
       0x63a8,          0x6c34,          0x708a,          0x7761,
    /* 72               73               74               75               */
       0x7c8b,          0x7fe0,          0x8870,          0x9042,
    /* 76               77               78               79               */
       0x9154,          0x9310,          0x9318,          0x968f,
    /* 80               81               82               83               */
       0x745e,          0x9ac4,          0x5d07,          0x5d69,
    /* 84               85               86               87               */
       0x6570,          0x67a2,          0x8da8,          0x96db,
    /* 88               89               90               91               */
       0x636e,          0x6749,          0x6919,          0x83c5,
    /* 92               93               94                                */
       0x9817,          0x96c0,          0x88fe,
/* JIS X 0208 (/ 0213 plane 1) row 32 */
    /*                   1                2                3               */
                        0x6f84,          0x647a,          0x5bf8,
    /*  4                5                6                7               */
       0x4e16,          0x702c,          0x755d,          0x662f,
    /*  8                9               10               11               */
       0x51c4,          0x5236,          0x52e2,          0x59d3,
    /* 12               13               14               15               */
       0x5f81,          0x6027,          0x6210,          0x653f,
    /* 16               17               18               19               */
       0x6574,          0x661f,          0x6674,          0x68f2,
    /* 20               21               22               23               */
       0x6816,          0x6b63,          0x6e05,          0x7272,
    /* 24               25               26               27               */
       0x751f,          0x76db,          0x7cbe,          0x8056,
    /* 28               29               30               31               */
       0x58f0,          0x88fd,          0x897f,          0x8aa0,
    /* 32               33               34               35               */
       0x8a93,          0x8acb,          0x901d,          0x9192,
    /* 36               37               38               39               */
       0x9752,          0x9759,          0x6589,          0x7a0e,
    /* 40               41               42               43               */
       0x8106,          0x96bb,          0x5e2d,          0x60dc,
    /* 44               45               46               47               */
       0x621a,          0x65a5,          0x6614,          0x6790,
    /* 48               49               50               51               */
       0x77f3,          0x7a4d,          0x7c4d,          0x7e3e,
    /* 52               53               54               55               */
       0x810a,          0x8cac,          0x8d64,          0x8de1,
    /* 56               57               58               59               */
       0x8e5f,          0x78a9,          0x5207,          0x62d9,
    /* 60               61               62               63               */
       0x63a5,          0x6442,          0x6298,          0x8a2d,
    /* 64               65               66               67               */
       0x7a83,          0x7bc0,          0x8aac,          0x96ea,
    /* 68               69               70               71               */
       0x7d76,          0x820c,          0x8749,          0x4ed9,
    /* 72               73               74               75               */
       0x5148,          0x5343,          0x5360,          0x5ba3,
    /* 76               77               78               79               */
       0x5c02,          0x5c16,          0x5ddd,          0x6226,
    /* 80               81               82               83               */
       0x6247,          0x64b0,          0x6813,          0x6834,
    /* 84               85               86               87               */
       0x6cc9,          0x6d45,          0x6d17,          0x67d3,
    /* 88               89               90               91               */
       0x6f5c,          0x714e,          0x717d,          0x65cb,
    /* 92               93               94                                */
       0x7a7f,          0x7bad,          0x7dda,
/* JIS X 0208 (/ 0213 plane 1) row 33 */
    /*                   1                2                3               */
                        0x7e4a,          0x7fa8,          0x817a,
    /*  4                5                6                7               */
       0x821b,          0x8239,          0x85a6,          0x8a6e,
    /*  8                9               10               11               */
       0x8cce,          0x8df5,          0x9078,          0x9077,
    /* 12               13               14               15               */
       0x92ad,          0x9291,          0x9583,          0x9bae,
    /* 16               17               18               19               */
       0x524d,          0x5584,          0x6f38,          0x7136,
    /* 20               21               22               23               */
       0x5168,          0x7985,          0x7e55,          0x81b3,
    /* 24               25               26               27               */
       0x7cce,          0x564c,          0x5851,          0x5ca8,
    /* 28               29               30               31               */
       0x63aa,          0x66fe,          0x66fd,          0x695a,
    /* 32               33               34               35               */
       0x72d9,          0x758f,          0x758e,          0x790e,
    /* 36               37               38               39               */
       0x7956,          0x79df,          0x7c97,          0x7d20,
    /* 40               41               42               43               */
       0x7d44,          0x8607,          0x8a34,          0x963b,
    /* 44               45               46               47               */
       0x9061,          0x9f20,          0x50e7,          0x5275,
    /* 48               49               50               51               */
       0x53cc,          0x53e2,          0x5009,          0x55aa,
    /* 52               53               54               55               */
       0x58ee,          0x594f,          0x723d,          0x5b8b,
    /* 56               57               58               59               */
       0x5c64,          0x531d,          0x60e3,          0x60f3,
    /* 60               61               62               63               */
       0x635c,          0x6383,          0x633f,          0x63bb,
    /* 64               65               66               67               */
       0x64cd,          0x65e9,          0x66f9,          0x5de3,
    /* 68               69               70               71               */
       0x69cd,          0x69fd,          0x6f15,          0x71e5,
    /* 72               73               74               75               */
       0x4e89,          0x75e9,          0x76f8,          0x7a93,
    /* 76               77               78               79               */
       0x7cdf,          0x7dcf,          0x7d9c,          0x8061,
    /* 80               81               82               83               */
       0x8349,          0x8358,          0x846c,          0x84bc,
    /* 84               85               86               87               */
       0x85fb,          0x88c5,          0x8d70,          0x9001,
    /* 88               89               90               91               */
       0x906d,          0x9397,          0x971c,          0x9a12,
    /* 92               93               94                                */
       0x50cf,          0x5897,          0x618e,
/* JIS X 0208 (/ 0213 plane 1) row 34 */
    /*                   1                2                3               */
                        0x81d3,          0x8535,          0x8d08,
    /*  4                5                6                7               */
       0x9020,          0x4fc3,          0x5074,          0x5247,
    /*  8                9               10               11               */
       0x5373,          0x606f,          0x6349,          0x675f,
    /* 12               13               14               15               */
       0x6e2c,          0x8db3,          0x901f,          0x4fd7,
    /* 16               17               18               19               */
       0x5c5e,          0x8cca,          0x65cf,          0x7d9a,
    /* 20               21               22               23               */
       0x5352,          0x8896,          0x5176,          0x63c3,
    /* 24               25               26               27               */
       0x5b58,          0x5b6b,          0x5c0a,          0x640d,
    /* 28               29               30               31               */
       0x6751,          0x905c,          0x4ed6,          0x591a,
    /* 32               33               34               35               */
       0x592a,          0x6c70,          0x8a51,          0x553e,
    /* 36               37               38               39               */
       0x5815,          0x59a5,          0x60f0,          0x6253,
    /* 40               41               42               43               */
       0x67c1,          0x8235,          0x6955,          0x9640,
    /* 44               45               46               47               */
       0x99c4,          0x9a28,          0x4f53,          0x5806,
    /* 48               49               50               51               */
       0x5bfe,          0x8010,          0x5cb1,          0x5e2f,
    /* 52               53               54               55               */
       0x5f85,          0x6020,          0x614b,          0x6234,
    /* 56               57               58               59               */
       0x66ff,          0x6cf0,          0x6ede,          0x80ce,
    /* 60               61               62               63               */
       0x817f,          0x82d4,          0x888b,          0x8cb8,
    /* 64               65               66               67               */
       0x9000,          0x902e,          0x968a,          0x9edb,
    /* 68               69               70               71               */
       0x9bdb,          0x4ee3,          0x53f0,          0x5927,
    /* 72               73               74               75               */
       0x7b2c,          0x918d,          0x984c,          0x9df9,
    /* 76               77               78               79               */
       0x6edd,          0x7027,          0x5353,          0x5544,
    /* 80               81               82               83               */
       0x5b85,          0x6258,          0x629e,          0x62d3,
    /* 84               85               86               87               */
       0x6ca2,          0x6fef,          0x7422,          0x8a17,
    /* 88               89               90               91               */
       0x9438,          0x6fc1,          0x8afe,          0x8338,
    /* 92               93               94                                */
       0x51e7,          0x86f8,          0x53ea,
/* JIS X 0208 (/ 0213 plane 1) row 35 */
    /*                   1                2                3               */
                        0x53e9,          0x4f46,          0x9054,
    /*  4                5                6                7               */
       0x8fb0,          0x596a,          0x8131,          0x5dfd,
    /*  8                9               10               11               */
       0x7aea,          0x8fbf,          0x68da,          0x8c37,
    /* 12               13               14               15               */
       0x72f8,          0x9c48,          0x6a3d,          0x8ab0,
    /* 16               17               18               19               */
       0x4e39,          0x5358,          0x5606,          0x5766,
    /* 20               21               22               23               */
       0x62c5,          0x63a2,          0x65e6,          0x6b4e,
    /* 24               25               26               27               */
       0x6de1,          0x6e5b,          0x70ad,          0x77ed,
    /* 28               29               30               31               */
       0x7aef,          0x7baa,          0x7dbb,          0x803d,
    /* 32               33               34               35               */
       0x80c6,          0x86cb,          0x8a95,          0x935b,
    /* 36               37               38               39               */
       0x56e3,          0x58c7,          0x5f3e,          0x65ad,
    /* 40               41               42               43               */
       0x6696,          0x6a80,          0x6bb5,          0x7537,
    /* 44               45               46               47               */
       0x8ac7,          0x5024,          0x77e5,          0x5730,
    /* 48               49               50               51               */
       0x5f1b,          0x6065,          0x667a,          0x6c60,
    /* 52               53               54               55               */
       0x75f4,          0x7a1a,          0x7f6e,          0x81f4,
    /* 56               57               58               59               */
       0x8718,          0x9045,          0x99b3,          0x7bc9,
    /* 60               61               62               63               */
       0x755c,          0x7af9,          0x7b51,          0x84c4,
    /* 64               65               66               67               */
       0x9010,          0x79e9,          0x7a92,          0x8336,
    /* 68               69               70               71               */
       0x5ae1,          0x7740,          0x4e2d,          0x4ef2,
    /* 72               73               74               75               */
       0x5b99,          0x5fe0,          0x62bd,          0x663c,
    /* 76               77               78               79               */
       0x67f1,          0x6ce8,          0x866b,          0x8877,
    /* 80               81               82               83               */
       0x8a3b,          0x914e,          0x92f3,          0x99d0,
    /* 84               85               86               87               */
       0x6a17,          0x7026,          0x732a,          0x82e7,
    /* 88               89               90               91               */
       0x8457,          0x8caf,          0x4e01,          0x5146,
    /* 92               93               94                                */
       0x51cb,          0x558b,          0x5bf5,
/* JIS X 0208 (/ 0213 plane 1) row 36 */
    /*                   1                2                3               */
                        0x5e16,          0x5e33,          0x5e81,
    /*  4                5                6                7               */
       0x5f14,          0x5f35,          0x5f6b,          0x5fb4,
    /*  8                9               10               11               */
       0x61f2,          0x6311,          0x66a2,          0x671d,
    /* 12               13               14               15               */
       0x6f6e,          0x7252,          0x753a,          0x773a,
    /* 16               17               18               19               */
       0x8074,          0x8139,          0x8178,          0x8776,
    /* 20               21               22               23               */
       0x8abf,          0x8adc,          0x8d85,          0x8df3,
    /* 24               25               26               27               */
       0x929a,          0x9577,          0x9802,          0x9ce5,
    /* 28               29               30               31               */
       0x52c5,          0x6357,          0x76f4,          0x6715,
    /* 32               33               34               35               */
       0x6c88,          0x73cd,          0x8cc3,          0x93ae,
    /* 36               37               38               39               */
       0x9673,          0x6d25,          0x589c,          0x690e,
    /* 40               41               42               43               */
       0x69cc,          0x8ffd,          0x939a,          0x75db,
    /* 44               45               46               47               */
       0x901a,          0x585a,          0x6802,          0x63b4,
    /* 48               49               50               51               */
       0x69fb,          0x4f43,          0x6f2c,          0x67d8,
    /* 52               53               54               55               */
       0x8fbb,          0x8526,          0x7db4,          0x9354,
    /* 56               57               58               59               */
       0x693f,          0x6f70,          0x576a,          0x58f7,
    /* 60               61               62               63               */
       0x5b2c,          0x7d2c,          0x722a,          0x540a,
    /* 64               65               66               67               */
       0x91e3,          0x9db4,          0x4ead,          0x4f4e,
    /* 68               69               70               71               */
       0x505c,          0x5075,          0x5243,          0x8c9e,
    /* 72               73               74               75               */
       0x5448,          0x5824,          0x5b9a,          0x5e1d,
    /* 76               77               78               79               */
       0x5e95,          0x5ead,          0x5ef7,          0x5f1f,
    /* 80               81               82               83               */
       0x608c,          0x62b5,          0x633a,          0x63d0,
    /* 84               85               86               87               */
       0x68af,          0x6c40,          0x7887,          0x798e,
    /* 88               89               90               91               */
       0x7a0b,          0x7de0,          0x8247,          0x8a02,
    /* 92               93               94                                */
       0x8ae6,          0x8e44,          0x9013,
/* JIS X 0208 (/ 0213 plane 1) row 37 */
    /*                   1                2                3               */
                        0x90b8,          0x912d,          0x91d8,
    /*  4                5                6                7               */
       0x9f0e,          0x6ce5,          0x6458,          0x64e2,
    /*  8                9               10               11               */
       0x6575,          0x6ef4,          0x7684,          0x7b1b,
    /* 12               13               14               15               */
       0x9069,          0x93d1,          0x6eba,          0x54f2,
    /* 16               17               18               19               */
       0x5fb9,          0x64a4,          0x8f4d,          0x8fed,
    /* 20               21               22               23               */
       0x9244,          0x5178,          0x586b,          0x5929,
    /* 24               25               26               27               */
       0x5c55,          0x5e97,          0x6dfb,          0x7e8f,
    /* 28               29               30               31               */
       0x751c,          0x8cbc,          0x8ee2,          0x985b,
    /* 32               33               34               35               */
       0x70b9,          0x4f1d,          0x6bbf,          0x6fb1,
    /* 36               37               38               39               */
       0x7530,          0x96fb,          0x514e,          0x5410,
    /* 40               41               42               43               */
       0x5835,          0x5857,          0x59ac,          0x5c60,
    /* 44               45               46               47               */
       0x5f92,          0x6597,          0x675c,          0x6e21,
    /* 48               49               50               51               */
       0x767b,          0x83df,          0x8ced,          0x9014,
    /* 52               53               54               55               */
       0x90fd,          0x934d,          0x7825,          0x783a,
    /* 56               57               58               59               */
       0x52aa,          0x5ea6,          0x571f,          0x5974,
    /* 60               61               62               63               */
       0x6012,          0x5012,          0x515a,          0x51ac,
    /* 64               65               66               67               */
       0x51cd,          0x5200,          0x5510,          0x5854,
    /* 68               69               70               71               */
       0x5858,          0x5957,          0x5b95,          0x5cf6,
    /* 72               73               74               75               */
       0x5d8b,          0x60bc,          0x6295,          0x642d,
    /* 76               77               78               79               */
       0x6771,          0x6843,          0x68bc,          0x68df,
    /* 80               81               82               83               */
       0x76d7,          0x6dd8,          0x6e6f,          0x6d9b,
    /* 84               85               86               87               */
       0x706f,          0x71c8,          0x5f53,          0x75d8,
    /* 88               89               90               91               */
       0x7977,          0x7b49,          0x7b54,          0x7b52,
    /* 92               93               94                                */
       0x7cd6,          0x7d71,          0x5230,
/* JIS X 0208 (/ 0213 plane 1) row 38 */
    /*                   1                2                3               */
                        0x8463,          0x8569,          0x85e4,
    /*  4                5                6                7               */
       0x8a0e,          0x8b04,          0x8c46,          0x8e0f,
    /*  8                9               10               11               */
       0x9003,          0x900f,          0x9419,          0x9676,
    /* 12               13               14               15               */
       0x982d,          0x9a30,          0x95d8,          0x50cd,
    /* 16               17               18               19               */
       0x52d5,          0x540c,          0x5802,          0x5c0e,
    /* 20               21               22               23               */
       0x61a7,          0x649e,          0x6d1e,          0x77b3,
    /* 24               25               26               27               */
       0x7ae5,          0x80f4,          0x8404,          0x9053,
    /* 28               29               30               31               */
       0x9285,          0x5ce0,          0x9d07,          0x533f,
    /* 32               33               34               35               */
       0x5f97,          0x5fb3,          0x6d9c,          0x7279,
    /* 36               37               38               39               */
       0x7763,          0x79bf,          0x7be4,          0x6bd2,
    /* 40               41               42               43               */
       0x72ec,          0x8aad,          0x6803,          0x6a61,
    /* 44               45               46               47               */
       0x51f8,          0x7a81,          0x6934,          0x5c4a,
    /* 48               49               50               51               */
       0x9cf6,          0x82eb,          0x5bc5,          0x9149,
    /* 52               53               54               55               */
       0x701e,          0x5678,          0x5c6f,          0x60c7,
    /* 56               57               58               59               */
       0x6566,          0x6c8c,          0x8c5a,          0x9041,
    /* 60               61               62               63               */
       0x9813,          0x5451,          0x66c7,          0x920d,
    /* 64               65               66               67               */
       0x5948,          0x90a3,          0x5185,          0x4e4d,
    /* 68               69               70               71               */
       0x51ea,          0x8599,          0x8b0e,          0x7058,
    /* 72               73               74               75               */
       0x637a,          0x934b,          0x6962,          0x99b4,
    /* 76               77               78               79               */
       0x7e04,          0x7577,          0x5357,          0x6960,
    /* 80               81               82               83               */
       0x8edf,          0x96e3,          0x6c5d,          0x4e8c,
    /* 84               85               86               87               */
       0x5c3c,          0x5f10,          0x8fe9,          0x5302,
    /* 88               89               90               91               */
       0x8cd1,          0x8089,          0x8679,          0x5eff,
    /* 92               93               94                                */
       0x65e5,          0x4e73,          0x5165,
/* JIS X 0208 (/ 0213 plane 1) row 39 */
    /*                   1                2                3               */
                        0x5982,          0x5c3f,          0x97ee,
    /*  4                5                6                7               */
       0x4efb,          0x598a,          0x5fcd,          0x8a8d,
    /*  8                9               10               11               */
       0x6fe1,          0x79b0,          0x7962,          0x5be7,
    /* 12               13               14               15               */
       0x8471,          0x732b,          0x71b1,          0x5e74,
    /* 16               17               18               19               */
       0x5ff5,          0x637b,          0x649a,          0x71c3,
    /* 20               21               22               23               */
       0x7c98,          0x4e43,          0x5efc,          0x4e4b,
    /* 24               25               26               27               */
       0x57dc,          0x56a2,          0x60a9,          0x6fc3,
    /* 28               29               30               31               */
       0x7d0d,          0x80fd,          0x8133,          0x81bf,
    /* 32               33               34               35               */
       0x8fb2,          0x8997,          0x86a4,          0x5df4,
    /* 36               37               38               39               */
       0x628a,          0x64ad,          0x8987,          0x6777,
    /* 40               41               42               43               */
       0x6ce2,          0x6d3e,          0x7436,          0x7834,
    /* 44               45               46               47               */
       0x5a46,          0x7f75,          0x82ad,          0x99ac,
    /* 48               49               50               51               */
       0x4ff3,          0x5ec3,          0x62dd,          0x6392,
    /* 52               53               54               55               */
       0x6557,          0x676f,          0x76c3,          0x724c,
    /* 56               57               58               59               */
       0x80cc,          0x80ba,          0x8f29,          0x914d,
    /* 60               61               62               63               */
       0x500d,          0x57f9,          0x5a92,          0x6885,
    /* 64               65               66               67               */
       0x6973,          0x7164,          0x72fd,          0x8cb7,
    /* 68               69               70               71               */
       0x58f2,          0x8ce0,          0x966a,          0x9019,
    /* 72               73               74               75               */
       0x877f,          0x79e4,          0x77e7,          0x8429,
    /* 76               77               78               79               */
       0x4f2f,          0x5265,          0x535a,          0x62cd,
    /* 80               81               82               83               */
       0x67cf,          0x6cca,          0x767d,          0x7b94,
    /* 84               85               86               87               */
       0x7c95,          0x8236,          0x8584,          0x8feb,
    /* 88               89               90               91               */
       0x66dd,          0x6f20,          0x7206,          0x7e1b,
    /* 92               93               94                                */
       0x83ab,          0x99c1,          0x9ea6,
/* JIS X 0208 (/ 0213 plane 1) row 40 */
    /*                   1                2                3               */
                        0x51fd,          0x7bb1,          0x7872,
    /*  4                5                6                7               */
       0x7bb8,          0x8087,          0x7b48,          0x6ae8,
    /*  8                9               10               11               */
       0x5e61,          0x808c,          0x7551,          0x7560,
    /* 12               13               14               15               */
       0x516b,          0x9262,          0x6e8c,          0x767a,
    /* 16               17               18               19               */
       0x9197,          0x9aea,          0x4f10,          0x7f70,
    /* 20               21               22               23               */
       0x629c,          0x7b4f,          0x95a5,          0x9ce9,
    /* 24               25               26               27               */
       0x567a,          0x5859,          0x86e4,          0x96bc,
    /* 28               29               30               31               */
       0x4f34,          0x5224,          0x534a,          0x53cd,
    /* 32               33               34               35               */
       0x53db,          0x5e06,          0x642c,          0x6591,
    /* 36               37               38               39               */
       0x677f,          0x6c3e,          0x6c4e,          0x7248,
    /* 40               41               42               43               */
       0x72af,          0x73ed,          0x7554,          0x7e41,
    /* 44               45               46               47               */
       0x822c,          0x85e9,          0x8ca9,          0x7bc4,
    /* 48               49               50               51               */
       0x91c6,          0x7169,          0x9812,          0x98ef,
    /* 52               53               54               55               */
       0x633d,          0x6669,          0x756a,          0x76e4,
    /* 56               57               58               59               */
       0x78d0,          0x8543,          0x86ee,          0x532a,
    /* 60               61               62               63               */
       0x5351,          0x5426,          0x5983,          0x5e87,
    /* 64               65               66               67               */
       0x5f7c,          0x60b2,          0x6249,          0x6279,
    /* 68               69               70               71               */
       0x62ab,          0x6590,          0x6bd4,          0x6ccc,
    /* 72               73               74               75               */
       0x75b2,          0x76ae,          0x7891,          0x79d8,
    /* 76               77               78               79               */
       0x7dcb,          0x7f77,          0x80a5,          0x88ab,
    /* 80               81               82               83               */
       0x8ab9,          0x8cbb,          0x907f,          0x975e,
    /* 84               85               86               87               */
       0x98db,          0x6a0b,          0x7c38,          0x5099,
    /* 88               89               90               91               */
       0x5c3e,          0x5fae,          0x6787,          0x6bd8,
    /* 92               93               94                                */
       0x7435,          0x7709,          0x7f8e,
/* JIS X 0208 (/ 0213 plane 1) row 41 */
    /*                   1                2                3               */
                        0x9f3b,          0x67ca,          0x7a17,
    /*  4                5                6                7               */
       0x5339,          0x758b,          0x9aed,          0x5f66,
    /*  8                9               10               11               */
       0x819d,          0x83f1,          0x8098,          0x5f3c,
    /* 12               13               14               15               */
       0x5fc5,          0x7562,          0x7b46,          0x903c,
    /* 16               17               18               19               */
       0x6867,          0x59eb,          0x5a9b,          0x7d10,
    /* 20               21               22               23               */
       0x767e,          0x8b2c,          0x4ff5,          0x5f6a,
    /* 24               25               26               27               */
       0x6a19,          0x6c37,          0x6f02,          0x74e2,
    /* 28               29               30               31               */
       0x7968,          0x8868,          0x8a55,          0x8c79,
    /* 32               33               34               35               */
       0x5edf,          0x63cf,          0x75c5,          0x79d2,
    /* 36               37               38               39               */
       0x82d7,          0x9328,          0x92f2,          0x849c,
    /* 40               41               42               43               */
       0x86ed,          0x9c2d,          0x54c1,          0x5f6c,
    /* 44               45               46               47               */
       0x658c,          0x6d5c,          0x7015,          0x8ca7,
    /* 48               49               50               51               */
       0x8cd3,          0x983b,          0x654f,          0x74f6,
    /* 52               53               54               55               */
       0x4e0d,          0x4ed8,          0x57e0,          0x592b,
    /* 56               57               58               59               */
       0x5a66,          0x5bcc,          0x51a8,          0x5e03,
    /* 60               61               62               63               */
       0x5e9c,          0x6016,          0x6276,          0x6577,
    /* 64               65               66               67               */
       0x65a7,          0x666e,          0x6d6e,          0x7236,
    /* 68               69               70               71               */
       0x7b26,          0x8150,          0x819a,          0x8299,
    /* 72               73               74               75               */
       0x8b5c,          0x8ca0,          0x8ce6,          0x8d74,
    /* 76               77               78               79               */
       0x961c,          0x9644,          0x4fae,          0x64ab,
    /* 80               81               82               83               */
       0x6b66,          0x821e,          0x8461,          0x856a,
    /* 84               85               86               87               */
       0x90e8,          0x5c01,          0x6953,          0x98a8,
    /* 88               89               90               91               */
       0x847a,          0x8557,          0x4f0f,          0x526f,
    /* 92               93               94                                */
       0x5fa9,          0x5e45,          0x670d,
/* JIS X 0208 (/ 0213 plane 1) row 42 */
    /*                   1                2                3               */
                        0x798f,          0x8179,          0x8907,
    /*  4                5                6                7               */
       0x8986,          0x6df5,          0x5f17,          0x6255,
    /*  8                9               10               11               */
       0x6cb8,          0x4ecf,          0x7269,          0x9b92,
    /* 12               13               14               15               */
       0x5206,          0x543b,          0x5674,          0x58b3,
    /* 16               17               18               19               */
       0x61a4,          0x626e,          0x711a,          0x596e,
    /* 20               21               22               23               */
       0x7c89,          0x7cde,          0x7d1b,          0x96f0,
    /* 24               25               26               27               */
       0x6587,          0x805e,          0x4e19,          0x4f75,
    /* 28               29               30               31               */
       0x5175,          0x5840,          0x5e63,          0x5e73,
    /* 32               33               34               35               */
       0x5f0a,          0x67c4,          0x4e26,          0x853d,
    /* 36               37               38               39               */
       0x9589,          0x965b,          0x7c73,          0x9801,
    /* 40               41               42               43               */
       0x50fb,          0x58c1,          0x7656,          0x78a7,
    /* 44               45               46               47               */
       0x5225,          0x77a5,          0x8511,          0x7b86,
    /* 48               49               50               51               */
       0x504f,          0x5909,          0x7247,          0x7bc7,
    /* 52               53               54               55               */
       0x7de8,          0x8fba,          0x8fd4,          0x904d,
    /* 56               57               58               59               */
       0x4fbf,          0x52c9,          0x5a29,          0x5f01,
    /* 60               61               62               63               */
       0x97ad,          0x4fdd,          0x8217,          0x92ea,
    /* 64               65               66               67               */
       0x5703,          0x6355,          0x6b69,          0x752b,
    /* 68               69               70               71               */
       0x88dc,          0x8f14,          0x7a42,          0x52df,
    /* 72               73               74               75               */
       0x5893,          0x6155,          0x620a,          0x66ae,
    /* 76               77               78               79               */
       0x6bcd,          0x7c3f,          0x83e9,          0x5023,
    /* 80               81               82               83               */
       0x4ff8,          0x5305,          0x5446,          0x5831,
    /* 84               85               86               87               */
       0x5949,          0x5b9d,          0x5cf0,          0x5cef,
    /* 88               89               90               91               */
       0x5d29,          0x5e96,          0x62b1,          0x6367,
    /* 92               93               94                                */
       0x653e,          0x65b9,          0x670b,
/* JIS X 0208 (/ 0213 plane 1) row 43 */
    /*                   1                2                3               */
                        0x6cd5,          0x6ce1,          0x70f9,
    /*  4                5                6                7               */
       0x7832,          0x7e2b,          0x80de,          0x82b3,
    /*  8                9               10               11               */
       0x840c,          0x84ec,          0x8702,          0x8912,
    /* 12               13               14               15               */
       0x8a2a,          0x8c4a,          0x90a6,          0x92d2,
    /* 16               17               18               19               */
       0x98fd,          0x9cf3,          0x9d6c,          0x4e4f,
    /* 20               21               22               23               */
       0x4ea1,          0x508d,          0x5256,          0x574a,
    /* 24               25               26               27               */
       0x59a8,          0x5e3d,          0x5fd8,          0x5fd9,
    /* 28               29               30               31               */
       0x623f,          0x66b4,          0x671b,          0x67d0,
    /* 32               33               34               35               */
       0x68d2,          0x5192,          0x7d21,          0x80aa,
    /* 36               37               38               39               */
       0x81a8,          0x8b00,          0x8c8c,          0x8cbf,
    /* 40               41               42               43               */
       0x927e,          0x9632,          0x5420,          0x982c,
    /* 44               45               46               47               */
       0x5317,          0x50d5,          0x535c,          0x58a8,
    /* 48               49               50               51               */
       0x64b2,          0x6734,          0x7267,          0x7766,
    /* 52               53               54               55               */
       0x7a46,          0x91e6,          0x52c3,          0x6ca1,
    /* 56               57               58               59               */
       0x6b86,          0x5800,          0x5e4c,          0x5954,
    /* 60               61               62               63               */
       0x672c,          0x7ffb,          0x51e1,          0x76c6,
    /* 64               65               66               67               */
       0x6469,          0x78e8,          0x9b54,          0x9ebb,
    /* 68               69               70               71               */
       0x57cb,          0x59b9,          0x6627,          0x679a,
    /* 72               73               74               75               */
       0x6bce,          0x54e9,          0x69d9,          0x5e55,
    /* 76               77               78               79               */
       0x819c,          0x6795,          0x9baa,          0x67fe,
    /* 80               81               82               83               */
       0x9c52,          0x685d,          0x4ea6,          0x4fe3,
    /* 84               85               86               87               */
       0x53c8,          0x62b9,          0x672b,          0x6cab,
    /* 88               89               90               91               */
       0x8fc4,          0x4fad,          0x7e6d,          0x9ebf,
    /* 92               93               94                                */
       0x4e07,          0x6162,          0x6e80,
/* JIS X 0208 (/ 0213 plane 1) row 44 */
    /*                   1                2                3               */
                        0x6f2b,          0x8513,          0x5473,
    /*  4                5                6                7               */
       0x672a,          0x9b45,          0x5df3,          0x7b95,
    /*  8                9               10               11               */
       0x5cac,          0x5bc6,          0x871c,          0x6e4a,
    /* 12               13               14               15               */
       0x84d1,          0x7a14,          0x8108,          0x5999,
    /* 16               17               18               19               */
       0x7c8d,          0x6c11,          0x7720,          0x52d9,
    /* 20               21               22               23               */
       0x5922,          0x7121,          0x725f,          0x77db,
    /* 24               25               26               27               */
       0x9727,          0x9d61,          0x690b,          0x5a7f,
    /* 28               29               30               31               */
       0x5a18,          0x51a5,          0x540d,          0x547d,
    /* 32               33               34               35               */
       0x660e,          0x76df,          0x8ff7,          0x9298,
    /* 36               37               38               39               */
       0x9cf4,          0x59ea,          0x725d,          0x6ec5,
    /* 40               41               42               43               */
       0x514d,          0x68c9,          0x7dbf,          0x7dec,
    /* 44               45               46               47               */
       0x9762,          0x9eba,          0x6478,          0x6a21,
    /* 48               49               50               51               */
       0x8302,          0x5984,          0x5b5f,          0x6bdb,
    /* 52               53               54               55               */
       0x731b,          0x76f2,          0x7db2,          0x8017,
    /* 56               57               58               59               */
       0x8499,          0x5132,          0x6728,          0x9ed9,
    /* 60               61               62               63               */
       0x76ee,          0x6762,          0x52ff,          0x9905,
    /* 64               65               66               67               */
       0x5c24,          0x623b,          0x7c7e,          0x8cb0,
    /* 68               69               70               71               */
       0x554f,          0x60b6,          0x7d0b,          0x9580,
    /* 72               73               74               75               */
       0x5301,          0x4e5f,          0x51b6,          0x591c,
    /* 76               77               78               79               */
       0x723a,          0x8036,          0x91ce,          0x5f25,
    /* 80               81               82               83               */
       0x77e2,          0x5384,          0x5f79,          0x7d04,
    /* 84               85               86               87               */
       0x85ac,          0x8a33,          0x8e8d,          0x9756,
    /* 88               89               90               91               */
       0x67f3,          0x85ae,          0x9453,          0x6109,
    /* 92               93               94                                */
       0x6108,          0x6cb9,          0x7652,
/* JIS X 0208 (/ 0213 plane 1) row 45 */
    /*                   1                2                3               */
                        0x8aed,          0x8f38,          0x552f,
    /*  4                5                6                7               */
       0x4f51,          0x512a,          0x52c7,          0x53cb,
    /*  8                9               10               11               */
       0x5ba5,          0x5e7d,          0x60a0,          0x6182,
    /* 12               13               14               15               */
       0x63d6,          0x6709,          0x67da,          0x6e67,
    /* 16               17               18               19               */
       0x6d8c,          0x7336,          0x7337,          0x7531,
    /* 20               21               22               23               */
       0x7950,          0x88d5,          0x8a98,          0x904a,
    /* 24               25               26               27               */
       0x9091,          0x90f5,          0x96c4,          0x878d,
    /* 28               29               30               31               */
       0x5915,          0x4e88,          0x4f59,          0x4e0e,
    /* 32               33               34               35               */
       0x8a89,          0x8f3f,          0x9810,          0x50ad,
    /* 36               37               38               39               */
       0x5e7c,          0x5996,          0x5bb9,          0x5eb8,
    /* 40               41               42               43               */
       0x63da,          0x63fa,          0x64c1,          0x66dc,
    /* 44               45               46               47               */
       0x694a,          0x69d8,          0x6d0b,          0x6eb6,
    /* 48               49               50               51               */
       0x7194,          0x7528,          0x7aaf,          0x7f8a,
    /* 52               53               54               55               */
       0x8000,          0x8449,          0x84c9,          0x8981,
    /* 56               57               58               59               */
       0x8b21,          0x8e0a,          0x9065,          0x967d,
    /* 60               61               62               63               */
       0x990a,          0x617e,          0x6291,          0x6b32,
    /* 64               65               66               67               */
       0x6c83,          0x6d74,          0x7fcc,          0x7ffc,
    /* 68               69               70               71               */
       0x6dc0,          0x7f85,          0x87ba,          0x88f8,
    /* 72               73               74               75               */
       0x6765,          0x83b1,          0x983c,          0x96f7,
    /* 76               77               78               79               */
       0x6d1b,          0x7d61,          0x843d,          0x916a,
    /* 80               81               82               83               */
       0x4e71,          0x5375,          0x5d50,          0x6b04,
    /* 84               85               86               87               */
       0x6feb,          0x85cd,          0x862d,          0x89a7,
    /* 88               89               90               91               */
       0x5229,          0x540f,          0x5c65,          0x674e,
    /* 92               93               94                                */
       0x68a8,          0x7406,          0x7483,
/* JIS X 0208 (/ 0213 plane 1) row 46 */
    /*                   1                2                3               */
                        0x75e2,          0x88cf,          0x88e1,
    /*  4                5                6                7               */
       0x91cc,          0x96e2,          0x9678,          0x5f8b,
    /*  8                9               10               11               */
       0x7387,          0x7acb,          0x844e,          0x63a0,
    /* 12               13               14               15               */
       0x7565,          0x5289,          0x6d41,          0x6e9c,
    /* 16               17               18               19               */
       0x7409,          0x7559,          0x786b,          0x7c92,
    /* 20               21               22               23               */
       0x9686,          0x7adc,          0x9f8d,          0x4fb6,
    /* 24               25               26               27               */
       0x616e,          0x65c5,          0x865c,          0x4e86,
    /* 28               29               30               31               */
       0x4eae,          0x50da,          0x4e21,          0x51cc,
    /* 32               33               34               35               */
       0x5bee,          0x6599,          0x6881,          0x6dbc,
    /* 36               37               38               39               */
       0x731f,          0x7642,          0x77ad,          0x7a1c,
    /* 40               41               42               43               */
       0x7ce7,          0x826f,          0x8ad2,          0x907c,
    /* 44               45               46               47               */
       0x91cf,          0x9675,          0x9818,          0x529b,
    /* 48               49               50               51               */
       0x7dd1,          0x502b,          0x5398,          0x6797,
    /* 52               53               54               55               */
       0x6dcb,          0x71d0,          0x7433,          0x81e8,
    /* 56               57               58               59               */
       0x8f2a,          0x96a3,          0x9c57,          0x9e9f,
    /* 60               61               62               63               */
       0x7460,          0x5841,          0x6d99,          0x7d2f,
    /* 64               65               66               67               */
       0x985e,          0x4ee4,          0x4f36,          0x4f8b,
    /* 68               69               70               71               */
       0x51b7,          0x52b1,          0x5dba,          0x601c,
    /* 72               73               74               75               */
       0x73b2,          0x793c,          0x82d3,          0x9234,
    /* 76               77               78               79               */
       0x96b7,          0x96f6,          0x970a,          0x9e97,
    /* 80               81               82               83               */
       0x9f62,          0x66a6,          0x6b74,          0x5217,
    /* 84               85               86               87               */
       0x52a3,          0x70c8,          0x88c2,          0x5ec9,
    /* 88               89               90               91               */
       0x604b,          0x6190,          0x6f23,          0x7149,
    /* 92               93               94                                */
       0x7c3e,          0x7df4,          0x806f,
/* JIS X 0208 (/ 0213 plane 1) row 47 */
    /*                   1                2                3               */
                        0x84ee,          0x9023,          0x932c,
    /*  4                5                6                7               */
       0x5442,          0x9b6f,          0x6ad3,          0x7089,
    /*  8                9               10               11               */
       0x8cc2,          0x8def,          0x9732,          0x52b4,
    /* 12               13               14               15               */
       0x5a41,          0x5eca,          0x5f04,          0x6717,
    /* 16               17               18               19               */
       0x697c,          0x6994,          0x6d6a,          0x6f0f,
    /* 20               21               22               23               */
       0x7262,          0x72fc,          0x7bed,          0x8001,
    /* 24               25               26               27               */
       0x807e,          0x874b,          0x90ce,          0x516d,
    /* 28               29               30               31               */
       0x9e93,          0x7984,          0x808b,          0x9332,
    /* 32               33               34               35               */
       0x8ad6,          0x502d,          0x548c,          0x8a71,
    /* 36               37               38               39               */
       0x6b6a,          0x8cc4,          0x8107,          0x60d1,
    /* 40               41               42               43               */
       0x67a0,          0x9df2,          0x4e99,          0x4e98,
    /* 44               45               46               47               */
       0x9c10,          0x8a6b,          0x85c1,          0x8568,
    /* 48               49               50               51               */
       0x6900,          0x6e7e,          0x7897,          0x8155,
    /* 52               53               54               55               */
       X0213NB(0xd842), X0213(0x5b41),   X0213(0x5b56),   X0213(0x5b7d),
    /* 56               57               58               59               */
       X0213(0x5b93),   X0213(0x5bd8),   X0213(0x5bec),   X0213(0x5c12),
    /* 60               61               62               63               */
       X0213(0x5c1e),   X0213(0x5c23),   X0213(0x5c2b),   X0213(0x378d),
    /* 64               65               66               67               */
       X0213(0x5c62),   X0213(0xfa3b),   X0213(0xfa3c),   X0213NB(0xd845),
    /* 68               69               70               71               */
       X0213(0x5c7a),   X0213(0x5c8f),   X0213(0x5c9f),   X0213(0x5ca3),
    /* 72               73               74               75               */
       X0213(0x5caa),   X0213(0x5cba),   X0213(0x5ccb),   X0213(0x5cd0),
    /* 76               77               78               79               */
       X0213(0x5cd2),   X0213(0x5cf4),   X0213NB(0xd847), X0213(0x37e2),
    /* 80               81               82               83               */
       X0213(0x5d0d),   X0213(0x5d27),   X0213(0xfa11),   X0213(0x5d46),
    /* 84               85               86               87               */
       X0213(0x5d47),   X0213(0x5d53),   X0213(0x5d4a),   X0213(0x5d6d),
    /* 88               89               90               91               */
       X0213(0x5d81),   X0213(0x5da0),   X0213(0x5da4),   X0213(0x5da7),
    /* 92               93               94                                */
       X0213(0x5db8),   X0213(0x5dcb),   X0213(0x541e),
/* JIS X 0208 (/ 0213 plane 1) row 48 */
    /*                   1                2                3               */
                        0x5f0c,          0x4e10,          0x4e15,
    /*  4                5                6                7               */
       0x4e2a,          0x4e31,          0x4e36,          0x4e3c,
    /*  8                9               10               11               */
       0x4e3f,          0x4e42,          0x4e56,          0x4e58,
    /* 12               13               14               15               */
       0x4e82,          0x4e85,          0x8c6b,          0x4e8a,
    /* 16               17               18               19               */
       0x8212,          0x5f0d,          0x4e8e,          0x4e9e,
    /* 20               21               22               23               */
       0x4e9f,          0x4ea0,          0x4ea2,          0x4eb0,
    /* 24               25               26               27               */
       0x4eb3,          0x4eb6,          0x4ece,          0x4ecd,
    /* 28               29               30               31               */
       0x4ec4,          0x4ec6,          0x4ec2,          0x4ed7,
    /* 32               33               34               35               */
       0x4ede,          0x4eed,          0x4edf,          0x4ef7,
    /* 36               37               38               39               */
       0x4f09,          0x4f5a,          0x4f30,          0x4f5b,
    /* 40               41               42               43               */
       0x4f5d,          0x4f57,          0x4f47,          0x4f76,
    /* 44               45               46               47               */
       0x4f88,          0x4f8f,          0x4f98,          0x4f7b,
    /* 48               49               50               51               */
       0x4f69,          0x4f70,          0x4f91,          0x4f6f,
    /* 52               53               54               55               */
       0x4f86,          0x4f96,          0x5118,          0x4fd4,
    /* 56               57               58               59               */
       0x4fdf,          0x4fce,          0x4fd8,          0x4fdb,
    /* 60               61               62               63               */
       0x4fd1,          0x4fda,          0x4fd0,          0x4fe4,
    /* 64               65               66               67               */
       0x4fe5,          0x501a,          0x5028,          0x5014,
    /* 68               69               70               71               */
       0x502a,          0x5025,          0x5005,          0x4f1c,
    /* 72               73               74               75               */
       0x4ff6,          0x5021,          0x5029,          0x502c,
    /* 76               77               78               79               */
       0x4ffe,          0x4fef,          0x5011,          0x5006,
    /* 80               81               82               83               */
       0x5043,          0x5047,          0x6703,          0x5055,
    /* 84               85               86               87               */
       0x5050,          0x5048,          0x505a,          0x5056,
    /* 88               89               90               91               */
       0x506c,          0x5078,          0x5080,          0x509a,
    /* 92               93               94                                */
       0x5085,          0x50b4,          0x50b2,
/* JIS X 0208 (/ 0213 plane 1) row 49 */
    /*                   1                2                3               */
                        0x50c9,          0x50ca,          0x50b3,
    /*  4                5                6                7               */
       0x50c2,          0x50d6,          0x50de,          0x50e5,
    /*  8                9               10               11               */
       0x50ed,          0x50e3,          0x50ee,          0x50f9,
    /* 12               13               14               15               */
       0x50f5,          0x5109,          0x5101,          0x5102,
    /* 16               17               18               19               */
       0x5116,          0x5115,          0x5114,          0x511a,
    /* 20               21               22               23               */
       0x5121,          0x513a,          0x5137,          0x513c,
    /* 24               25               26               27               */
       0x513b,          0x513f,          0x5140,          0x5152,
    /* 28               29               30               31               */
       0x514c,          0x5154,          0x5162,          0x7af8,
    /* 32               33               34               35               */
       0x5169,          0x516a,          0x516e,          0x5180,
    /* 36               37               38               39               */
       0x5182,          0x56d8,          0x518c,          0x5189,
    /* 40               41               42               43               */
       0x518f,          0x5191,          0x5193,          0x5195,
    /* 44               45               46               47               */
       0x5196,          0x51a4,          0x51a6,          0x51a2,
    /* 48               49               50               51               */
       0x51a9,          0x51aa,          0x51ab,          0x51b3,
    /* 52               53               54               55               */
       0x51b1,          0x51b2,          0x51b0,          0x51b5,
    /* 56               57               58               59               */
       0x51bd,          0x51c5,          0x51c9,          0x51db,
    /* 60               61               62               63               */
       0x51e0,          0x8655,          0x51e9,          0x51ed,
    /* 64               65               66               67               */
       0x51f0,          0x51f5,          0x51fe,          0x5204,
    /* 68               69               70               71               */
       0x520b,          0x5214,          0x520e,          0x5227,
    /* 72               73               74               75               */
       0x522a,          0x522e,          0x5233,          0x5239,
    /* 76               77               78               79               */
       0x524f,          0x5244,          0x524b,          0x524c,
    /* 80               81               82               83               */
       0x525e,          0x5254,          0x526a,          0x5274,
    /* 84               85               86               87               */
       0x5269,          0x5273,          0x527f,          0x527d,
    /* 88               89               90               91               */
       0x528d,          0x5294,          0x5292,          0x5271,
    /* 92               93               94                                */
       0x5288,          0x5291,          0x8fa8,
/* JIS X 0208 (/ 0213 plane 1) row 50 */
    /*                   1                2                3               */
                        0x8fa7,          0x52ac,          0x52ad,
    /*  4                5                6                7               */
       0x52bc,          0x52b5,          0x52c1,          0x52cd,
    /*  8                9               10               11               */
       0x52d7,          0x52de,          0x52e3,          0x52e6,
    /* 12               13               14               15               */
       0x98ed,          0x52e0,          0x52f3,          0x52f5,
    /* 16               17               18               19               */
       0x52f8,          0x52f9,          0x5306,          0x5308,
    /* 20               21               22               23               */
       0x7538,          0x530d,          0x5310,          0x530f,
    /* 24               25               26               27               */
       0x5315,          0x531a,          0x5323,          0x532f,
    /* 28               29               30               31               */
       0x5331,          0x5333,          0x5338,          0x5340,
    /* 32               33               34               35               */
       0x5346,          0x5345,          0x4e17,          0x5349,
    /* 36               37               38               39               */
       0x534d,          0x51d6,          0x535e,          0x5369,
    /* 40               41               42               43               */
       0x536e,          0x5918,          0x537b,          0x5377,
    /* 44               45               46               47               */
       0x5382,          0x5396,          0x53a0,          0x53a6,
    /* 48               49               50               51               */
       0x53a5,          0x53ae,          0x53b0,          0x53b6,
    /* 52               53               54               55               */
       0x53c3,          0x7c12,          0x96d9,          0x53df,
    /* 56               57               58               59               */
       0x66fc,          0x71ee,          0x53ee,          0x53e8,
    /* 60               61               62               63               */
       0x53ed,          0x53fa,          0x5401,          0x543d,
    /* 64               65               66               67               */
       0x5440,          0x542c,          0x542d,          0x543c,
    /* 68               69               70               71               */
       0x542e,          0x5436,          0x5429,          0x541d,
    /* 72               73               74               75               */
       0x544e,          0x548f,          0x5475,          0x548e,
    /* 76               77               78               79               */
       0x545f,          0x5471,          0x5477,          0x5470,
    /* 80               81               82               83               */
       0x5492,          0x547b,          0x5480,          0x5476,
    /* 84               85               86               87               */
       0x5484,          0x5490,          0x5486,          0x54c7,
    /* 88               89               90               91               */
       0x54a2,          0x54b8,          0x54a5,          0x54ac,
    /* 92               93               94                                */
       0x54c4,          0x54c8,          0x54a8,
/* JIS X 0208 (/ 0213 plane 1) row 51 */
    /*                   1                2                3               */
                        0x54ab,          0x54c2,          0x54a4,
    /*  4                5                6                7               */
       0x54be,          0x54bc,          0x54d8,          0x54e5,
    /*  8                9               10               11               */
       0x54e6,          0x550f,          0x5514,          0x54fd,
    /* 12               13               14               15               */
       0x54ee,          0x54ed,          0x54fa,          0x54e2,
    /* 16               17               18               19               */
       0x5539,          0x5540,          0x5563,          0x554c,
    /* 20               21               22               23               */
       0x552e,          0x555c,          0x5545,          0x5556,
    /* 24               25               26               27               */
       0x5557,          0x5538,          0x5533,          0x555d,
    /* 28               29               30               31               */
       0x5599,          0x5580,          0x54af,          0x558a,
    /* 32               33               34               35               */
       0x559f,          0x557b,          0x557e,          0x5598,
    /* 36               37               38               39               */
       0x559e,          0x55ae,          0x557c,          0x5583,
    /* 40               41               42               43               */
       0x55a9,          0x5587,          0x55a8,          0x55da,
    /* 44               45               46               47               */
       0x55c5,          0x55df,          0x55c4,          0x55dc,
    /* 48               49               50               51               */
       0x55e4,          0x55d4,          0x5614,          0x55f7,
    /* 52               53               54               55               */
       0x5616,          0x55fe,          0x55fd,          0x561b,
    /* 56               57               58               59               */
       0x55f9,          0x564e,          0x5650,          0x71df,
    /* 60               61               62               63               */
       0x5634,          0x5636,          0x5632,          0x5638,
    /* 64               65               66               67               */
       0x566b,          0x5664,          0x562f,          0x566c,
    /* 68               69               70               71               */
       0x566a,          0x5686,          0x5680,          0x568a,
    /* 72               73               74               75               */
       0x56a0,          0x5694,          0x568f,          0x56a5,
    /* 76               77               78               79               */
       0x56ae,          0x56b6,          0x56b4,          0x56c2,
    /* 80               81               82               83               */
       0x56bc,          0x56c1,          0x56c3,          0x56c0,
    /* 84               85               86               87               */
       0x56c8,          0x56ce,          0x56d1,          0x56d3,
    /* 88               89               90               91               */
       0x56d7,          0x56ee,          0x56f9,          0x5700,
    /* 92               93               94                                */
       0x56ff,          0x5704,          0x5709,
/* JIS X 0208 (/ 0213 plane 1) row 52 */
    /*                   1                2                3               */
                        0x5708,          0x570b,          0x570d,
    /*  4                5                6                7               */
       0x5713,          0x5718,          0x5716,          0x55c7,
    /*  8                9               10               11               */
       0x571c,          0x5726,          0x5737,          0x5738,
    /* 12               13               14               15               */
       0x574e,          0x573b,          0x5740,          0x574f,
    /* 16               17               18               19               */
       0x5769,          0x57c0,          0x5788,          0x5761,
    /* 20               21               22               23               */
       0x577f,          0x5789,          0x5793,          0x57a0,
    /* 24               25               26               27               */
       0x57b3,          0x57a4,          0x57aa,          0x57b0,
    /* 28               29               30               31               */
       0x57c3,          0x57c6,          0x57d4,          0x57d2,
    /* 32               33               34               35               */
       0x57d3,          0x580a,          0x57d6,          0x57e3,
    /* 36               37               38               39               */
       0x580b,          0x5819,          0x581d,          0x5872,
    /* 40               41               42               43               */
       0x5821,          0x5862,          0x584b,          0x5870,
    /* 44               45               46               47               */
       0x6bc0,          0x5852,          0x583d,          0x5879,
    /* 48               49               50               51               */
       0x5885,          0x58b9,          0x589f,          0x58ab,
    /* 52               53               54               55               */
       0x58ba,          0x58de,          0x58bb,          0x58b8,
    /* 56               57               58               59               */
       0x58ae,          0x58c5,          0x58d3,          0x58d1,
    /* 60               61               62               63               */
       0x58d7,          0x58d9,          0x58d8,          0x58e5,
    /* 64               65               66               67               */
       0x58dc,          0x58e4,          0x58df,          0x58ef,
    /* 68               69               70               71               */
       0x58fa,          0x58f9,          0x58fb,          0x58fc,
    /* 72               73               74               75               */
       0x58fd,          0x5902,          0x590a,          0x5910,
    /* 76               77               78               79               */
       0x591b,          0x68a6,          0x5925,          0x592c,
    /* 80               81               82               83               */
       0x592d,          0x5932,          0x5938,          0x593e,
    /* 84               85               86               87               */
       0x7ad2,          0x5955,          0x5950,          0x594e,
    /* 88               89               90               91               */
       0x595a,          0x5958,          0x5962,          0x5960,
    /* 92               93               94                                */
       0x5967,          0x596c,          0x5969,
/* JIS X 0208 (/ 0213 plane 1) row 53 */
    /*                   1                2                3               */
                        0x5978,          0x5981,          0x599d,
    /*  4                5                6                7               */
       0x4f5e,          0x4fab,          0x59a3,          0x59b2,
    /*  8                9               10               11               */
       0x59c6,          0x59e8,          0x59dc,          0x598d,
    /* 12               13               14               15               */
       0x59d9,          0x59da,          0x5a25,          0x5a1f,
    /* 16               17               18               19               */
       0x5a11,          0x5a1c,          0x5a09,          0x5a1a,
    /* 20               21               22               23               */
       0x5a40,          0x5a6c,          0x5a49,          0x5a35,
    /* 24               25               26               27               */
       0x5a36,          0x5a62,          0x5a6a,          0x5a9a,
    /* 28               29               30               31               */
       0x5abc,          0x5abe,          0x5acb,          0x5ac2,
    /* 32               33               34               35               */
       0x5abd,          0x5ae3,          0x5ad7,          0x5ae6,
    /* 36               37               38               39               */
       0x5ae9,          0x5ad6,          0x5afa,          0x5afb,
    /* 40               41               42               43               */
       0x5b0c,          0x5b0b,          0x5b16,          0x5b32,
    /* 44               45               46               47               */
       0x5ad0,          0x5b2a,          0x5b36,          0x5b3e,
    /* 48               49               50               51               */
       0x5b43,          0x5b45,          0x5b40,          0x5b51,
    /* 52               53               54               55               */
       0x5b55,          0x5b5a,          0x5b5b,          0x5b65,
    /* 56               57               58               59               */
       0x5b69,          0x5b70,          0x5b73,          0x5b75,
    /* 60               61               62               63               */
       0x5b78,          0x6588,          0x5b7a,          0x5b80,
    /* 64               65               66               67               */
       0x5b83,          0x5ba6,          0x5bb8,          0x5bc3,
    /* 68               69               70               71               */
       0x5bc7,          0x5bc9,          0x5bd4,          0x5bd0,
    /* 72               73               74               75               */
       0x5be4,          0x5be6,          0x5be2,          0x5bde,
    /* 76               77               78               79               */
       0x5be5,          0x5beb,          0x5bf0,          0x5bf6,
    /* 80               81               82               83               */
       0x5bf3,          0x5c05,          0x5c07,          0x5c08,
    /* 84               85               86               87               */
       0x5c0d,          0x5c13,          0x5c20,          0x5c22,
    /* 88               89               90               91               */
       0x5c28,          0x5c38,          0x5c39,          0x5c41,
    /* 92               93               94                                */
       0x5c46,          0x5c4e,          0x5c53,
/* JIS X 0208 (/ 0213 plane 1) row 54 */
    /*                   1                2                3               */
                        0x5c50,          0x5c4f,          0x5b71,
    /*  4                5                6                7               */
       0x5c6c,          0x5c6e,          0x4e62,          0x5c76,
    /*  8                9               10               11               */
       0x5c79,          0x5c8c,          0x5c91,          0x5c94,
    /* 12               13               14               15               */
       0x599b,          0x5cab,          0x5cbb,          0x5cb6,
    /* 16               17               18               19               */
       0x5cbc,          0x5cb7,          0x5cc5,          0x5cbe,
    /* 20               21               22               23               */
       0x5cc7,          0x5cd9,          0x5ce9,          0x5cfd,
    /* 24               25               26               27               */
       0x5cfa,          0x5ced,          0x5d8c,          0x5cea,
    /* 28               29               30               31               */
       0x5d0b,          0x5d15,          0x5d17,          0x5d5c,
    /* 32               33               34               35               */
       0x5d1f,          0x5d1b,          0x5d11,          0x5d14,
    /* 36               37               38               39               */
       0x5d22,          0x5d1a,          0x5d19,          0x5d18,
    /* 40               41               42               43               */
       0x5d4c,          0x5d52,          0x5d4e,          0x5d4b,
    /* 44               45               46               47               */
       0x5d6c,          0x5d73,          0x5d76,          0x5d87,
    /* 48               49               50               51               */
       0x5d84,          0x5d82,          0x5da2,          0x5d9d,
    /* 52               53               54               55               */
       0x5dac,          0x5dae,          0x5dbd,          0x5d90,
    /* 56               57               58               59               */
       0x5db7,          0x5dbc,          0x5dc9,          0x5dcd,
    /* 60               61               62               63               */
       0x5dd3,          0x5dd2,          0x5dd6,          0x5ddb,
    /* 64               65               66               67               */
       0x5deb,          0x5df2,          0x5df5,          0x5e0b,
    /* 68               69               70               71               */
       0x5e1a,          0x5e19,          0x5e11,          0x5e1b,
    /* 72               73               74               75               */
       0x5e36,          0x5e37,          0x5e44,          0x5e43,
    /* 76               77               78               79               */
       0x5e40,          0x5e4e,          0x5e57,          0x5e54,
    /* 80               81               82               83               */
       0x5e5f,          0x5e62,          0x5e64,          0x5e47,
    /* 84               85               86               87               */
       0x5e75,          0x5e76,          0x5e7a,          0x9ebc,
    /* 88               89               90               91               */
       0x5e7f,          0x5ea0,          0x5ec1,          0x5ec2,
    /* 92               93               94                                */
       0x5ec8,          0x5ed0,          0x5ecf,
/* JIS X 0208 (/ 0213 plane 1) row 55 */
    /*                   1                2                3               */
                        0x5ed6,          0x5ee3,          0x5edd,
    /*  4                5                6                7               */
       0x5eda,          0x5edb,          0x5ee2,          0x5ee1,
    /*  8                9               10               11               */
       0x5ee8,          0x5ee9,          0x5eec,          0x5ef1,
    /* 12               13               14               15               */
       0x5ef3,          0x5ef0,          0x5ef4,          0x5ef8,
    /* 16               17               18               19               */
       0x5efe,          0x5f03,          0x5f09,          0x5f5d,
    /* 20               21               22               23               */
       0x5f5c,          0x5f0b,          0x5f11,          0x5f16,
    /* 24               25               26               27               */
       0x5f29,          0x5f2d,          0x5f38,          0x5f41,
    /* 28               29               30               31               */
       0x5f48,          0x5f4c,          0x5f4e,          0x5f2f,
    /* 32               33               34               35               */
       0x5f51,          0x5f56,          0x5f57,          0x5f59,
    /* 36               37               38               39               */
       0x5f61,          0x5f6d,          0x5f73,          0x5f77,
    /* 40               41               42               43               */
       0x5f83,          0x5f82,          0x5f7f,          0x5f8a,
    /* 44               45               46               47               */
       0x5f88,          0x5f91,          0x5f87,          0x5f9e,
    /* 48               49               50               51               */
       0x5f99,          0x5f98,          0x5fa0,          0x5fa8,
    /* 52               53               54               55               */
       0x5fad,          0x5fbc,          0x5fd6,          0x5ffb,
    /* 56               57               58               59               */
       0x5fe4,          0x5ff8,          0x5ff1,          0x5fdd,
    /* 60               61               62               63               */
       0x60b3,          0x5fff,          0x6021,          0x6060,
    /* 64               65               66               67               */
       0x6019,          0x6010,          0x6029,          0x600e,
    /* 68               69               70               71               */
       0x6031,          0x601b,          0x6015,          0x602b,
    /* 72               73               74               75               */
       0x6026,          0x600f,          0x603a,          0x605a,
    /* 76               77               78               79               */
       0x6041,          0x606a,          0x6077,          0x605f,
    /* 80               81               82               83               */
       0x604a,          0x6046,          0x604d,          0x6063,
    /* 84               85               86               87               */
       0x6043,          0x6064,          0x6042,          0x606c,
    /* 88               89               90               91               */
       0x606b,          0x6059,          0x6081,          0x608d,
    /* 92               93               94                                */
       0x60e7,          0x6083,          0x609a,
/* JIS X 0208 (/ 0213 plane 1) row 56 */
    /*                   1                2                3               */
                        0x6084,          0x609b,          0x6096,
    /*  4                5                6                7               */
       0x6097,          0x6092,          0x60a7,          0x608b,
    /*  8                9               10               11               */
       0x60e1,          0x60b8,          0x60e0,          0x60d3,
    /* 12               13               14               15               */
       0x60b4,          0x5ff0,          0x60bd,          0x60c6,
    /* 16               17               18               19               */
       0x60b5,          0x60d8,          0x614d,          0x6115,
    /* 20               21               22               23               */
       0x6106,          0x60f6,          0x60f7,          0x6100,
    /* 24               25               26               27               */
       0x60f4,          0x60fa,          0x6103,          0x6121,
    /* 28               29               30               31               */
       0x60fb,          0x60f1,          0x610d,          0x610e,
    /* 32               33               34               35               */
       0x6147,          0x613e,          0x6128,          0x6127,
    /* 36               37               38               39               */
       0x614a,          0x613f,          0x613c,          0x612c,
    /* 40               41               42               43               */
       0x6134,          0x613d,          0x6142,          0x6144,
    /* 44               45               46               47               */
       0x6173,          0x6177,          0x6158,          0x6159,
    /* 48               49               50               51               */
       0x615a,          0x616b,          0x6174,          0x616f,
    /* 52               53               54               55               */
       0x6165,          0x6171,          0x615f,          0x615d,
    /* 56               57               58               59               */
       0x6153,          0x6175,          0x6199,          0x6196,
    /* 60               61               62               63               */
       0x6187,          0x61ac,          0x6194,          0x619a,
    /* 64               65               66               67               */
       0x618a,          0x6191,          0x61ab,          0x61ae,
    /* 68               69               70               71               */
       0x61cc,          0x61ca,          0x61c9,          0x61f7,
    /* 72               73               74               75               */
       0x61c8,          0x61c3,          0x61c6,          0x61ba,
    /* 76               77               78               79               */
       0x61cb,          0x7f79,          0x61cd,          0x61e6,
    /* 80               81               82               83               */
       0x61e3,          0x61f6,          0x61fa,          0x61f4,
    /* 84               85               86               87               */
       0x61ff,          0x61fd,          0x61fc,          0x61fe,
    /* 88               89               90               91               */
       0x6200,          0x6208,          0x6209,          0x620d,
    /* 92               93               94                                */
       0x620c,          0x6214,          0x621b,
/* JIS X 0208 (/ 0213 plane 1) row 57 */
    /*                   1                2                3               */
                        0x621e,          0x6221,          0x622a,
    /*  4                5                6                7               */
       0x622e,          0x6230,          0x6232,          0x6233,
    /*  8                9               10               11               */
       0x6241,          0x624e,          0x625e,          0x6263,
    /* 12               13               14               15               */
       0x625b,          0x6260,          0x6268,          0x627c,
    /* 16               17               18               19               */
       0x6282,          0x6289,          0x627e,          0x6292,
    /* 20               21               22               23               */
       0x6293,          0x6296,          0x62d4,          0x6283,
    /* 24               25               26               27               */
       0x6294,          0x62d7,          0x62d1,          0x62bb,
    /* 28               29               30               31               */
       0x62cf,          0x62ff,          0x62c6,          0x64d4,
    /* 32               33               34               35               */
       0x62c8,          0x62dc,          0x62cc,          0x62ca,
    /* 36               37               38               39               */
       0x62c2,          0x62c7,          0x629b,          0x62c9,
    /* 40               41               42               43               */
       0x630c,          0x62ee,          0x62f1,          0x6327,
    /* 44               45               46               47               */
       0x6302,          0x6308,          0x62ef,          0x62f5,
    /* 48               49               50               51               */
       0x6350,          0x633e,          0x634d,          0x641c,
    /* 52               53               54               55               */
       0x634f,          0x6396,          0x638e,          0x6380,
    /* 56               57               58               59               */
       0x63ab,          0x6376,          0x63a3,          0x638f,
    /* 60               61               62               63               */
       0x6389,          0x639f,          0x63b5,          0x636b,
    /* 64               65               66               67               */
       0x6369,          0x63be,          0x63e9,          0x63c0,
    /* 68               69               70               71               */
       0x63c6,          0x63e3,          0x63c9,          0x63d2,
    /* 72               73               74               75               */
       0x63f6,          0x63c4,          0x6416,          0x6434,
    /* 76               77               78               79               */
       0x6406,          0x6413,          0x6426,          0x6436,
    /* 80               81               82               83               */
       0x651d,          0x6417,          0x6428,          0x640f,
    /* 84               85               86               87               */
       0x6467,          0x646f,          0x6476,          0x644e,
    /* 88               89               90               91               */
       0x652a,          0x6495,          0x6493,          0x64a5,
    /* 92               93               94                                */
       0x64a9,          0x6488,          0x64bc,
/* JIS X 0208 (/ 0213 plane 1) row 58 */
    /*                   1                2                3               */
                        0x64da,          0x64d2,          0x64c5,
    /*  4                5                6                7               */
       0x64c7,          0x64bb,          0x64d8,          0x64c2,
    /*  8                9               10               11               */
       0x64f1,          0x64e7,          0x8209,          0x64e0,
    /* 12               13               14               15               */
       0x64e1,          0x62ac,          0x64e3,          0x64ef,
    /* 16               17               18               19               */
       0x652c,          0x64f6,          0x64f4,          0x64f2,
    /* 20               21               22               23               */
       0x64fa,          0x6500,          0x64fd,          0x6518,
    /* 24               25               26               27               */
       0x651c,          0x6505,          0x6524,          0x6523,
    /* 28               29               30               31               */
       0x652b,          0x6534,          0x6535,          0x6537,
    /* 32               33               34               35               */
       0x6536,          0x6538,          0x754b,          0x6548,
    /* 36               37               38               39               */
       0x6556,          0x6555,          0x654d,          0x6558,
    /* 40               41               42               43               */
       0x655e,          0x655d,          0x6572,          0x6578,
    /* 44               45               46               47               */
       0x6582,          0x6583,          0x8b8a,          0x659b,
    /* 48               49               50               51               */
       0x659f,          0x65ab,          0x65b7,          0x65c3,
    /* 52               53               54               55               */
       0x65c6,          0x65c1,          0x65c4,          0x65cc,
    /* 56               57               58               59               */
       0x65d2,          0x65db,          0x65d9,          0x65e0,
    /* 60               61               62               63               */
       0x65e1,          0x65f1,          0x6772,          0x660a,
    /* 64               65               66               67               */
       0x6603,          0x65fb,          0x6773,          0x6635,
    /* 68               69               70               71               */
       0x6636,          0x6634,          0x661c,          0x664f,
    /* 72               73               74               75               */
       0x6644,          0x6649,          0x6641,          0x665e,
    /* 76               77               78               79               */
       0x665d,          0x6664,          0x6667,          0x6668,
    /* 80               81               82               83               */
       0x665f,          0x6662,          0x6670,          0x6683,
    /* 84               85               86               87               */
       0x6688,          0x668e,          0x6689,          0x6684,
    /* 88               89               90               91               */
       0x6698,          0x669d,          0x66c1,          0x66b9,
    /* 92               93               94                                */
       0x66c9,          0x66be,          0x66bc,
/* JIS X 0208 (/ 0213 plane 1) row 59 */
    /*                   1                2                3               */
                        0x66c4,          0x66b8,          0x66d6,
    /*  4                5                6                7               */
       0x66da,          0x66e0,          0x663f,          0x66e6,
    /*  8                9               10               11               */
       0x66e9,          0x66f0,          0x66f5,          0x66f7,
    /* 12               13               14               15               */
       0x670f,          0x6716,          0x671e,          0x6726,
    /* 16               17               18               19               */
       0x6727,          0x9738,          0x672e,          0x673f,
    /* 20               21               22               23               */
       0x6736,          0x6741,          0x6738,          0x6737,
    /* 24               25               26               27               */
       0x6746,          0x675e,          0x6760,          0x6759,
    /* 28               29               30               31               */
       0x6763,          0x6764,          0x6789,          0x6770,
    /* 32               33               34               35               */
       0x67a9,          0x677c,          0x676a,          0x678c,
    /* 36               37               38               39               */
       0x678b,          0x67a6,          0x67a1,          0x6785,
    /* 40               41               42               43               */
       0x67b7,          0x67ef,          0x67b4,          0x67ec,
    /* 44               45               46               47               */
       0x67b3,          0x67e9,          0x67b8,          0x67e4,
    /* 48               49               50               51               */
       0x67de,          0x67dd,          0x67e2,          0x67ee,
    /* 52               53               54               55               */
       0x67b9,          0x67ce,          0x67c6,          0x67e7,
    /* 56               57               58               59               */
       0x6a9c,          0x681e,          0x6846,          0x6829,
    /* 60               61               62               63               */
       0x6840,          0x684d,          0x6832,          0x684e,
    /* 64               65               66               67               */
       0x68b3,          0x682b,          0x6859,          0x6863,
    /* 68               69               70               71               */
       0x6877,          0x687f,          0x689f,          0x688f,
    /* 72               73               74               75               */
       0x68ad,          0x6894,          0x689d,          0x689b,
    /* 76               77               78               79               */
       0x6883,          0x6aae,          0x68b9,          0x6874,
    /* 80               81               82               83               */
       0x68b5,          0x68a0,          0x68ba,          0x690f,
    /* 84               85               86               87               */
       0x688d,          0x687e,          0x6901,          0x68ca,
    /* 88               89               90               91               */
       0x6908,          0x68d8,          0x6922,          0x6926,
    /* 92               93               94                                */
       0x68e1,          0x690c,          0x68cd,
/* JIS X 0208 (/ 0213 plane 1) row 60 */
    /*                   1                2                3               */
                        0x68d4,          0x68e7,          0x68d5,
    /*  4                5                6                7               */
       0x6936,          0x6912,          0x6904,          0x68d7,
    /*  8                9               10               11               */
       0x68e3,          0x6925,          0x68f9,          0x68e0,
    /* 12               13               14               15               */
       0x68ef,          0x6928,          0x692a,          0x691a,
    /* 16               17               18               19               */
       0x6923,          0x6921,          0x68c6,          0x6979,
    /* 20               21               22               23               */
       0x6977,          0x695c,          0x6978,          0x696b,
    /* 24               25               26               27               */
       0x6954,          0x697e,          0x696e,          0x6939,
    /* 28               29               30               31               */
       0x6974,          0x693d,          0x6959,          0x6930,
    /* 32               33               34               35               */
       0x6961,          0x695e,          0x695d,          0x6981,
    /* 36               37               38               39               */
       0x696a,          0x69b2,          0x69ae,          0x69d0,
    /* 40               41               42               43               */
       0x69bf,          0x69c1,          0x69d3,          0x69be,
    /* 44               45               46               47               */
       0x69ce,          0x5be8,          0x69ca,          0x69dd,
    /* 48               49               50               51               */
       0x69bb,          0x69c3,          0x69a7,          0x6a2e,
    /* 52               53               54               55               */
       0x6991,          0x69a0,          0x699c,          0x6995,
    /* 56               57               58               59               */
       0x69b4,          0x69de,          0x69e8,          0x6a02,
    /* 60               61               62               63               */
       0x6a1b,          0x69ff,          0x6b0a,          0x69f9,
    /* 64               65               66               67               */
       0x69f2,          0x69e7,          0x6a05,          0x69b1,
    /* 68               69               70               71               */
       0x6a1e,          0x69ed,          0x6a14,          0x69eb,
    /* 72               73               74               75               */
       0x6a0a,          0x6a12,          0x6ac1,          0x6a23,
    /* 76               77               78               79               */
       0x6a13,          0x6a44,          0x6a0c,          0x6a72,
    /* 80               81               82               83               */
       0x6a36,          0x6a78,          0x6a47,          0x6a62,
    /* 84               85               86               87               */
       0x6a59,          0x6a66,          0x6a48,          0x6a38,
    /* 88               89               90               91               */
       0x6a22,          0x6a90,          0x6a8d,          0x6aa0,
    /* 92               93               94                                */
       0x6a84,          0x6aa2,          0x6aa3,
/* JIS X 0208 (/ 0213 plane 1) row 61 */
    /*                   1                2                3               */
                        0x6a97,          0x8617,          0x6abb,
    /*  4                5                6                7               */
       0x6ac3,          0x6ac2,          0x6ab8,          0x6ab3,
    /*  8                9               10               11               */
       0x6aac,          0x6ade,          0x6ad1,          0x6adf,
    /* 12               13               14               15               */
       0x6aaa,          0x6ada,          0x6aea,          0x6afb,
    /* 16               17               18               19               */
       0x6b05,          0x8616,          0x6afa,          0x6b12,
    /* 20               21               22               23               */
       0x6b16,          0x9b31,          0x6b1f,          0x6b38,
    /* 24               25               26               27               */
       0x6b37,          0x76dc,          0x6b39,          0x98ee,
    /* 28               29               30               31               */
       0x6b47,          0x6b43,          0x6b49,          0x6b50,
    /* 32               33               34               35               */
       0x6b59,          0x6b54,          0x6b5b,          0x6b5f,
    /* 36               37               38               39               */
       0x6b61,          0x6b78,          0x6b79,          0x6b7f,
    /* 40               41               42               43               */
       0x6b80,          0x6b84,          0x6b83,          0x6b8d,
    /* 44               45               46               47               */
       0x6b98,          0x6b95,          0x6b9e,          0x6ba4,
    /* 48               49               50               51               */
       0x6baa,          0x6bab,          0x6baf,          0x6bb2,
    /* 52               53               54               55               */
       0x6bb1,          0x6bb3,          0x6bb7,          0x6bbc,
    /* 56               57               58               59               */
       0x6bc6,          0x6bcb,          0x6bd3,          0x6bdf,
    /* 60               61               62               63               */
       0x6bec,          0x6beb,          0x6bf3,          0x6bef,
    /* 64               65               66               67               */
       0x9ebe,          0x6c08,          0x6c13,          0x6c14,
    /* 68               69               70               71               */
       0x6c1b,          0x6c24,          0x6c23,          0x6c5e,
    /* 72               73               74               75               */
       0x6c55,          0x6c62,          0x6c6a,          0x6c82,
    /* 76               77               78               79               */
       0x6c8d,          0x6c9a,          0x6c81,          0x6c9b,
    /* 80               81               82               83               */
       0x6c7e,          0x6c68,          0x6c73,          0x6c92,
    /* 84               85               86               87               */
       0x6c90,          0x6cc4,          0x6cf1,          0x6cd3,
    /* 88               89               90               91               */
       0x6cbd,          0x6cd7,          0x6cc5,          0x6cdd,
    /* 92               93               94                                */
       0x6cae,          0x6cb1,          0x6cbe,
/* JIS X 0208 (/ 0213 plane 1) row 62 */
    /*                   1                2                3               */
                        0x6cba,          0x6cdb,          0x6cef,
    /*  4                5                6                7               */
       0x6cd9,          0x6cea,          0x6d1f,          0x884d,
    /*  8                9               10               11               */
       0x6d36,          0x6d2b,          0x6d3d,          0x6d38,
    /* 12               13               14               15               */
       0x6d19,          0x6d35,          0x6d33,          0x6d12,
    /* 16               17               18               19               */
       0x6d0c,          0x6d63,          0x6d93,          0x6d64,
    /* 20               21               22               23               */
       0x6d5a,          0x6d79,          0x6d59,          0x6d8e,
    /* 24               25               26               27               */
       0x6d95,          0x6fe4,          0x6d85,          0x6df9,
    /* 28               29               30               31               */
       0x6e15,          0x6e0a,          0x6db5,          0x6dc7,
    /* 32               33               34               35               */
       0x6de6,          0x6db8,          0x6dc6,          0x6dec,
    /* 36               37               38               39               */
       0x6dde,          0x6dcc,          0x6de8,          0x6dd2,
    /* 40               41               42               43               */
       0x6dc5,          0x6dfa,          0x6dd9,          0x6de4,
    /* 44               45               46               47               */
       0x6dd5,          0x6dea,          0x6dee,          0x6e2d,
    /* 48               49               50               51               */
       0x6e6e,          0x6e2e,          0x6e19,          0x6e72,
    /* 52               53               54               55               */
       0x6e5f,          0x6e3e,          0x6e23,          0x6e6b,
    /* 56               57               58               59               */
       0x6e2b,          0x6e76,          0x6e4d,          0x6e1f,
    /* 60               61               62               63               */
       0x6e43,          0x6e3a,          0x6e4e,          0x6e24,
    /* 64               65               66               67               */
       0x6eff,          0x6e1d,          0x6e38,          0x6e82,
    /* 68               69               70               71               */
       0x6eaa,          0x6e98,          0x6ec9,          0x6eb7,
    /* 72               73               74               75               */
       0x6ed3,          0x6ebd,          0x6eaf,          0x6ec4,
    /* 76               77               78               79               */
       0x6eb2,          0x6ed4,          0x6ed5,          0x6e8f,
    /* 80               81               82               83               */
       0x6ea5,          0x6ec2,          0x6e9f,          0x6f41,
    /* 84               85               86               87               */
       0x6f11,          0x704c,          0x6eec,          0x6ef8,
    /* 88               89               90               91               */
       0x6efe,          0x6f3f,          0x6ef2,          0x6f31,
    /* 92               93               94                                */
       0x6eef,          0x6f32,          0x6ecc,
/* JIS X 0208 (/ 0213 plane 1) row 63 */
    /*                   1                2                3               */
                        0x6f3e,          0x6f13,          0x6ef7,
    /*  4                5                6                7               */
       0x6f86,          0x6f7a,          0x6f78,          0x6f81,
    /*  8                9               10               11               */
       0x6f80,          0x6f6f,          0x6f5b,          0x6ff3,
    /* 12               13               14               15               */
       0x6f6d,          0x6f82,          0x6f7c,          0x6f58,
    /* 16               17               18               19               */
       0x6f8e,          0x6f91,          0x6fc2,          0x6f66,
    /* 20               21               22               23               */
       0x6fb3,          0x6fa3,          0x6fa1,          0x6fa4,
    /* 24               25               26               27               */
       0x6fb9,          0x6fc6,          0x6faa,          0x6fdf,
    /* 28               29               30               31               */
       0x6fd5,          0x6fec,          0x6fd4,          0x6fd8,
    /* 32               33               34               35               */
       0x6ff1,          0x6fee,          0x6fdb,          0x7009,
    /* 36               37               38               39               */
       0x700b,          0x6ffa,          0x7011,          0x7001,
    /* 40               41               42               43               */
       0x700f,          0x6ffe,          0x701b,          0x701a,
    /* 44               45               46               47               */
       0x6f74,          0x701d,          0x7018,          0x701f,
    /* 48               49               50               51               */
       0x7030,          0x703e,          0x7032,          0x7051,
    /* 52               53               54               55               */
       0x7063,          0x7099,          0x7092,          0x70af,
    /* 56               57               58               59               */
       0x70f1,          0x70ac,          0x70b8,          0x70b3,
    /* 60               61               62               63               */
       0x70ae,          0x70df,          0x70cb,          0x70dd,
    /* 64               65               66               67               */
       0x70d9,          0x7109,          0x70fd,          0x711c,
    /* 68               69               70               71               */
       0x7119,          0x7165,          0x7155,          0x7188,
    /* 72               73               74               75               */
       0x7166,          0x7162,          0x714c,          0x7156,
    /* 76               77               78               79               */
       0x716c,          0x718f,          0x71fb,          0x7184,
    /* 80               81               82               83               */
       0x7195,          0x71a8,          0x71ac,          0x71d7,
    /* 84               85               86               87               */
       0x71b9,          0x71be,          0x71d2,          0x71c9,
    /* 88               89               90               91               */
       0x71d4,          0x71ce,          0x71e0,          0x71ec,
    /* 92               93               94                                */
       0x71e7,          0x71f5,          0x71fc,
/* JIS X 0208 (/ 0213 plane 1) row 64 */
    /*                   1                2                3               */
                        0x71f9,          0x71ff,          0x720d,
    /*  4                5                6                7               */
       0x7210,          0x721b,          0x7228,          0x722d,
    /*  8                9               10               11               */
       0x722c,          0x7230,          0x7232,          0x723b,
    /* 12               13               14               15               */
       0x723c,          0x723f,          0x7240,          0x7246,
    /* 16               17               18               19               */
       0x724b,          0x7258,          0x7274,          0x727e,
    /* 20               21               22               23               */
       0x7282,          0x7281,          0x7287,          0x7292,
    /* 24               25               26               27               */
       0x7296,          0x72a2,          0x72a7,          0x72b9,
    /* 28               29               30               31               */
       0x72b2,          0x72c3,          0x72c6,          0x72c4,
    /* 32               33               34               35               */
       0x72ce,          0x72d2,          0x72e2,          0x72e0,
    /* 36               37               38               39               */
       0x72e1,          0x72f9,          0x72f7,          0x500f,
    /* 40               41               42               43               */
       0x7317,          0x730a,          0x731c,          0x7316,
    /* 44               45               46               47               */
       0x731d,          0x7334,          0x732f,          0x7329,
    /* 48               49               50               51               */
       0x7325,          0x733e,          0x734e,          0x734f,
    /* 52               53               54               55               */
       0x9ed8,          0x7357,          0x736a,          0x7368,
    /* 56               57               58               59               */
       0x7370,          0x7378,          0x7375,          0x737b,
    /* 60               61               62               63               */
       0x737a,          0x73c8,          0x73b3,          0x73ce,
    /* 64               65               66               67               */
       0x73bb,          0x73c0,          0x73e5,          0x73ee,
    /* 68               69               70               71               */
       0x73de,          0x74a2,          0x7405,          0x746f,
    /* 72               73               74               75               */
       0x7425,          0x73f8,          0x7432,          0x743a,
    /* 76               77               78               79               */
       0x7455,          0x743f,          0x745f,          0x7459,
    /* 80               81               82               83               */
       0x7441,          0x745c,          0x7469,          0x7470,
    /* 84               85               86               87               */
       0x7463,          0x746a,          0x7476,          0x747e,
    /* 88               89               90               91               */
       0x748b,          0x749e,          0x74a7,          0x74ca,
    /* 92               93               94                                */
       0x74cf,          0x74d4,          0x73f1,
/* JIS X 0208 (/ 0213 plane 1) row 65 */
    /*                   1                2                3               */
                        0x74e0,          0x74e3,          0x74e7,
    /*  4                5                6                7               */
       0x74e9,          0x74ee,          0x74f2,          0x74f0,
    /*  8                9               10               11               */
       0x74f1,          0x74f8,          0x74f7,          0x7504,
    /* 12               13               14               15               */
       0x7503,          0x7505,          0x750c,          0x750e,
    /* 16               17               18               19               */
       0x750d,          0x7515,          0x7513,          0x751e,
    /* 20               21               22               23               */
       0x7526,          0x752c,          0x753c,          0x7544,
    /* 24               25               26               27               */
       0x754d,          0x754a,          0x7549,          0x755b,
    /* 28               29               30               31               */
       0x7546,          0x755a,          0x7569,          0x7564,
    /* 32               33               34               35               */
       0x7567,          0x756b,          0x756d,          0x7578,
    /* 36               37               38               39               */
       0x7576,          0x7586,          0x7587,          0x7574,
    /* 40               41               42               43               */
       0x758a,          0x7589,          0x7582,          0x7594,
    /* 44               45               46               47               */
       0x759a,          0x759d,          0x75a5,          0x75a3,
    /* 48               49               50               51               */
       0x75c2,          0x75b3,          0x75c3,          0x75b5,
    /* 52               53               54               55               */
       0x75bd,          0x75b8,          0x75bc,          0x75b1,
    /* 56               57               58               59               */
       0x75cd,          0x75ca,          0x75d2,          0x75d9,
    /* 60               61               62               63               */
       0x75e3,          0x75de,          0x75fe,          0x75ff,
    /* 64               65               66               67               */
       0x75fc,          0x7601,          0x75f0,          0x75fa,
    /* 68               69               70               71               */
       0x75f2,          0x75f3,          0x760b,          0x760d,
    /* 72               73               74               75               */
       0x7609,          0x761f,          0x7627,          0x7620,
    /* 76               77               78               79               */
       0x7621,          0x7622,          0x7624,          0x7634,
    /* 80               81               82               83               */
       0x7630,          0x763b,          0x7647,          0x7648,
    /* 84               85               86               87               */
       0x7646,          0x765c,          0x7658,          0x7661,
    /* 88               89               90               91               */
       0x7662,          0x7668,          0x7669,          0x766a,
    /* 92               93               94                                */
       0x7667,          0x766c,          0x7670,
/* JIS X 0208 (/ 0213 plane 1) row 66 */
    /*                   1                2                3               */
                        0x7672,          0x7676,          0x7678,
    /*  4                5                6                7               */
       0x767c,          0x7680,          0x7683,          0x7688,
    /*  8                9               10               11               */
       0x768b,          0x768e,          0x7696,          0x7693,
    /* 12               13               14               15               */
       0x7699,          0x769a,          0x76b0,          0x76b4,
    /* 16               17               18               19               */
       0x76b8,          0x76b9,          0x76ba,          0x76c2,
    /* 20               21               22               23               */
       0x76cd,          0x76d6,          0x76d2,          0x76de,
    /* 24               25               26               27               */
       0x76e1,          0x76e5,          0x76e7,          0x76ea,
    /* 28               29               30               31               */
       0x862f,          0x76fb,          0x7708,          0x7707,
    /* 32               33               34               35               */
       0x7704,          0x7729,          0x7724,          0x771e,
    /* 36               37               38               39               */
       0x7725,          0x7726,          0x771b,          0x7737,
    /* 40               41               42               43               */
       0x7738,          0x7747,          0x775a,          0x7768,
    /* 44               45               46               47               */
       0x776b,          0x775b,          0x7765,          0x777f,
    /* 48               49               50               51               */
       0x777e,          0x7779,          0x778e,          0x778b,
    /* 52               53               54               55               */
       0x7791,          0x77a0,          0x779e,          0x77b0,
    /* 56               57               58               59               */
       0x77b6,          0x77b9,          0x77bf,          0x77bc,
    /* 60               61               62               63               */
       0x77bd,          0x77bb,          0x77c7,          0x77cd,
    /* 64               65               66               67               */
       0x77d7,          0x77da,          0x77dc,          0x77e3,
    /* 68               69               70               71               */
       0x77ee,          0x77fc,          0x780c,          0x7812,
    /* 72               73               74               75               */
       0x7926,          0x7820,          0x792a,          0x7845,
    /* 76               77               78               79               */
       0x788e,          0x7874,          0x7886,          0x787c,
    /* 80               81               82               83               */
       0x789a,          0x788c,          0x78a3,          0x78b5,
    /* 84               85               86               87               */
       0x78aa,          0x78af,          0x78d1,          0x78c6,
    /* 88               89               90               91               */
       0x78cb,          0x78d4,          0x78be,          0x78bc,
    /* 92               93               94                                */
       0x78c5,          0x78ca,          0x78ec,
/* JIS X 0208 (/ 0213 plane 1) row 67 */
    /*                   1                2                3               */
                        0x78e7,          0x78da,          0x78fd,
    /*  4                5                6                7               */
       0x78f4,          0x7907,          0x7912,          0x7911,
    /*  8                9               10               11               */
       0x7919,          0x792c,          0x792b,          0x7940,
    /* 12               13               14               15               */
       0x7960,          0x7957,          0x795f,          0x795a,
    /* 16               17               18               19               */
       0x7955,          0x7953,          0x797a,          0x797f,
    /* 20               21               22               23               */
       0x798a,          0x799d,          0x79a7,          0x9f4b,
    /* 24               25               26               27               */
       0x79aa,          0x79ae,          0x79b3,          0x79b9,
    /* 28               29               30               31               */
       0x79ba,          0x79c9,          0x79d5,          0x79e7,
    /* 32               33               34               35               */
       0x79ec,          0x79e1,          0x79e3,          0x7a08,
    /* 36               37               38               39               */
       0x7a0d,          0x7a18,          0x7a19,          0x7a20,
    /* 40               41               42               43               */
       0x7a1f,          0x7980,          0x7a31,          0x7a3b,
    /* 44               45               46               47               */
       0x7a3e,          0x7a37,          0x7a43,          0x7a57,
    /* 48               49               50               51               */
       0x7a49,          0x7a61,          0x7a62,          0x7a69,
    /* 52               53               54               55               */
       0x9f9d,          0x7a70,          0x7a79,          0x7a7d,
    /* 56               57               58               59               */
       0x7a88,          0x7a97,          0x7a95,          0x7a98,
    /* 60               61               62               63               */
       0x7a96,          0x7aa9,          0x7ac8,          0x7ab0,
    /* 64               65               66               67               */
       0x7ab6,          0x7ac5,          0x7ac4,          0x7abf,
    /* 68               69               70               71               */
       0x9083,          0x7ac7,          0x7aca,          0x7acd,
    /* 72               73               74               75               */
       0x7acf,          0x7ad5,          0x7ad3,          0x7ad9,
    /* 76               77               78               79               */
       0x7ada,          0x7add,          0x7ae1,          0x7ae2,
    /* 80               81               82               83               */
       0x7ae6,          0x7aed,          0x7af0,          0x7b02,
    /* 84               85               86               87               */
       0x7b0f,          0x7b0a,          0x7b06,          0x7b33,
    /* 88               89               90               91               */
       0x7b18,          0x7b19,          0x7b1e,          0x7b35,
    /* 92               93               94                                */
       0x7b28,          0x7b36,          0x7b50,
/* JIS X 0208 (/ 0213 plane 1) row 68 */
    /*                   1                2                3               */
                        0x7b7a,          0x7b04,          0x7b4d,
    /*  4                5                6                7               */
       0x7b0b,          0x7b4c,          0x7b45,          0x7b75,
    /*  8                9               10               11               */
       0x7b65,          0x7b74,          0x7b67,          0x7b70,
    /* 12               13               14               15               */
       0x7b71,          0x7b6c,          0x7b6e,          0x7b9d,
    /* 16               17               18               19               */
       0x7b98,          0x7b9f,          0x7b8d,          0x7b9c,
    /* 20               21               22               23               */
       0x7b9a,          0x7b8b,          0x7b92,          0x7b8f,
    /* 24               25               26               27               */
       0x7b5d,          0x7b99,          0x7bcb,          0x7bc1,
    /* 28               29               30               31               */
       0x7bcc,          0x7bcf,          0x7bb4,          0x7bc6,
    /* 32               33               34               35               */
       0x7bdd,          0x7be9,          0x7c11,          0x7c14,
    /* 36               37               38               39               */
       0x7be6,          0x7be5,          0x7c60,          0x7c00,
    /* 40               41               42               43               */
       0x7c07,          0x7c13,          0x7bf3,          0x7bf7,
    /* 44               45               46               47               */
       0x7c17,          0x7c0d,          0x7bf6,          0x7c23,
    /* 48               49               50               51               */
       0x7c27,          0x7c2a,          0x7c1f,          0x7c37,
    /* 52               53               54               55               */
       0x7c2b,          0x7c3d,          0x7c4c,          0x7c43,
    /* 56               57               58               59               */
       0x7c54,          0x7c4f,          0x7c40,          0x7c50,
    /* 60               61               62               63               */
       0x7c58,          0x7c5f,          0x7c64,          0x7c56,
    /* 64               65               66               67               */
       0x7c65,          0x7c6c,          0x7c75,          0x7c83,
    /* 68               69               70               71               */
       0x7c90,          0x7ca4,          0x7cad,          0x7ca2,
    /* 72               73               74               75               */
       0x7cab,          0x7ca1,          0x7ca8,          0x7cb3,
    /* 76               77               78               79               */
       0x7cb2,          0x7cb1,          0x7cae,          0x7cb9,
    /* 80               81               82               83               */
       0x7cbd,          0x7cc0,          0x7cc5,          0x7cc2,
    /* 84               85               86               87               */
       0x7cd8,          0x7cd2,          0x7cdc,          0x7ce2,
    /* 88               89               90               91               */
       0x9b3b,          0x7cef,          0x7cf2,          0x7cf4,
    /* 92               93               94                                */
       0x7cf6,          0x7cfa,          0x7d06,
/* JIS X 0208 (/ 0213 plane 1) row 69 */
    /*                   1                2                3               */
                        0x7d02,          0x7d1c,          0x7d15,
    /*  4                5                6                7               */
       0x7d0a,          0x7d45,          0x7d4b,          0x7d2e,
    /*  8                9               10               11               */
       0x7d32,          0x7d3f,          0x7d35,          0x7d46,
    /* 12               13               14               15               */
       0x7d73,          0x7d56,          0x7d4e,          0x7d72,
    /* 16               17               18               19               */
       0x7d68,          0x7d6e,          0x7d4f,          0x7d63,
    /* 20               21               22               23               */
       0x7d93,          0x7d89,          0x7d5b,          0x7d8f,
    /* 24               25               26               27               */
       0x7d7d,          0x7d9b,          0x7dba,          0x7dae,
    /* 28               29               30               31               */
       0x7da3,          0x7db5,          0x7dc7,          0x7dbd,
    /* 32               33               34               35               */
       0x7dab,          0x7e3d,          0x7da2,          0x7daf,
    /* 36               37               38               39               */
       0x7ddc,          0x7db8,          0x7d9f,          0x7db0,
    /* 40               41               42               43               */
       0x7dd8,          0x7ddd,          0x7de4,          0x7dde,
    /* 44               45               46               47               */
       0x7dfb,          0x7df2,          0x7de1,          0x7e05,
    /* 48               49               50               51               */
       0x7e0a,          0x7e23,          0x7e21,          0x7e12,
    /* 52               53               54               55               */
       0x7e31,          0x7e1f,          0x7e09,          0x7e0b,
    /* 56               57               58               59               */
       0x7e22,          0x7e46,          0x7e66,          0x7e3b,
    /* 60               61               62               63               */
       0x7e35,          0x7e39,          0x7e43,          0x7e37,
    /* 64               65               66               67               */
       0x7e32,          0x7e3a,          0x7e67,          0x7e5d,
    /* 68               69               70               71               */
       0x7e56,          0x7e5e,          0x7e59,          0x7e5a,
    /* 72               73               74               75               */
       0x7e79,          0x7e6a,          0x7e69,          0x7e7c,
    /* 76               77               78               79               */
       0x7e7b,          0x7e83,          0x7dd5,          0x7e7d,
    /* 80               81               82               83               */
       0x8fae,          0x7e7f,          0x7e88,          0x7e89,
    /* 84               85               86               87               */
       0x7e8c,          0x7e92,          0x7e90,          0x7e93,
    /* 88               89               90               91               */
       0x7e94,          0x7e96,          0x7e8e,          0x7e9b,
    /* 92               93               94                                */
       0x7e9c,          0x7f38,          0x7f3a,
/* JIS X 0208 (/ 0213 plane 1) row 70 */
    /*                   1                2                3               */
                        0x7f45,          0x7f4c,          0x7f4d,
    /*  4                5                6                7               */
       0x7f4e,          0x7f50,          0x7f51,          0x7f55,
    /*  8                9               10               11               */
       0x7f54,          0x7f58,          0x7f5f,          0x7f60,
    /* 12               13               14               15               */
       0x7f68,          0x7f69,          0x7f67,          0x7f78,
    /* 16               17               18               19               */
       0x7f82,          0x7f86,          0x7f83,          0x7f88,
    /* 20               21               22               23               */
       0x7f87,          0x7f8c,          0x7f94,          0x7f9e,
    /* 24               25               26               27               */
       0x7f9d,          0x7f9a,          0x7fa3,          0x7faf,
    /* 28               29               30               31               */
       0x7fb2,          0x7fb9,          0x7fae,          0x7fb6,
    /* 32               33               34               35               */
       0x7fb8,          0x8b71,          0x7fc5,          0x7fc6,
    /* 36               37               38               39               */
       0x7fca,          0x7fd5,          0x7fd4,          0x7fe1,
    /* 40               41               42               43               */
       0x7fe6,          0x7fe9,          0x7ff3,          0x7ff9,
    /* 44               45               46               47               */
       0x98dc,          0x8006,          0x8004,          0x800b,
    /* 48               49               50               51               */
       0x8012,          0x8018,          0x8019,          0x801c,
    /* 52               53               54               55               */
       0x8021,          0x8028,          0x803f,          0x803b,
    /* 56               57               58               59               */
       0x804a,          0x8046,          0x8052,          0x8058,
    /* 60               61               62               63               */
       0x805a,          0x805f,          0x8062,          0x8068,
    /* 64               65               66               67               */
       0x8073,          0x8072,          0x8070,          0x8076,
    /* 68               69               70               71               */
       0x8079,          0x807d,          0x807f,          0x8084,
    /* 72               73               74               75               */
       0x8086,          0x8085,          0x809b,          0x8093,
    /* 76               77               78               79               */
       0x809a,          0x80ad,          0x5190,          0x80ac,
    /* 80               81               82               83               */
       0x80db,          0x80e5,          0x80d9,          0x80dd,
    /* 84               85               86               87               */
       0x80c4,          0x80da,          0x80d6,          0x8109,
    /* 88               89               90               91               */
       0x80ef,          0x80f1,          0x811b,          0x8129,
    /* 92               93               94                                */
       0x8123,          0x812f,          0x814b,
/* JIS X 0208 (/ 0213 plane 1) row 71 */
    /*                   1                2                3               */
                        0x968b,          0x8146,          0x813e,
    /*  4                5                6                7               */
       0x8153,          0x8151,          0x80fc,          0x8171,
    /*  8                9               10               11               */
       0x816e,          0x8165,          0x8166,          0x8174,
    /* 12               13               14               15               */
       0x8183,          0x8188,          0x818a,          0x8180,
    /* 16               17               18               19               */
       0x8182,          0x81a0,          0x8195,          0x81a4,
    /* 20               21               22               23               */
       0x81a3,          0x815f,          0x8193,          0x81a9,
    /* 24               25               26               27               */
       0x81b0,          0x81b5,          0x81be,          0x81b8,
    /* 28               29               30               31               */
       0x81bd,          0x81c0,          0x81c2,          0x81ba,
    /* 32               33               34               35               */
       0x81c9,          0x81cd,          0x81d1,          0x81d9,
    /* 36               37               38               39               */
       0x81d8,          0x81c8,          0x81da,          0x81df,
    /* 40               41               42               43               */
       0x81e0,          0x81e7,          0x81fa,          0x81fb,
    /* 44               45               46               47               */
       0x81fe,          0x8201,          0x8202,          0x8205,
    /* 48               49               50               51               */
       0x8207,          0x820a,          0x820d,          0x8210,
    /* 52               53               54               55               */
       0x8216,          0x8229,          0x822b,          0x8238,
    /* 56               57               58               59               */
       0x8233,          0x8240,          0x8259,          0x8258,
    /* 60               61               62               63               */
       0x825d,          0x825a,          0x825f,          0x8264,
    /* 64               65               66               67               */
       0x8262,          0x8268,          0x826a,          0x826b,
    /* 68               69               70               71               */
       0x822e,          0x8271,          0x8277,          0x8278,
    /* 72               73               74               75               */
       0x827e,          0x828d,          0x8292,          0x82ab,
    /* 76               77               78               79               */
       0x829f,          0x82bb,          0x82ac,          0x82e1,
    /* 80               81               82               83               */
       0x82e3,          0x82df,          0x82d2,          0x82f4,
    /* 84               85               86               87               */
       0x82f3,          0x82fa,          0x8393,          0x8303,
    /* 88               89               90               91               */
       0x82fb,          0x82f9,          0x82de,          0x8306,
    /* 92               93               94                                */
       0x82dc,          0x8309,          0x82d9,
/* JIS X 0208 (/ 0213 plane 1) row 72 */
    /*                   1                2                3               */
                        0x8335,          0x8334,          0x8316,
    /*  4                5                6                7               */
       0x8332,          0x8331,          0x8340,          0x8339,
    /*  8                9               10               11               */
       0x8350,          0x8345,          0x832f,          0x832b,
    /* 12               13               14               15               */
       0x8317,          0x8318,          0x8385,          0x839a,
    /* 16               17               18               19               */
       0x83aa,          0x839f,          0x83a2,          0x8396,
    /* 20               21               22               23               */
       0x8323,          0x838e,          0x8387,          0x838a,
    /* 24               25               26               27               */
       0x837c,          0x83b5,          0x8373,          0x8375,
    /* 28               29               30               31               */
       0x83a0,          0x8389,          0x83a8,          0x83f4,
    /* 32               33               34               35               */
       0x8413,          0x83eb,          0x83ce,          0x83fd,
    /* 36               37               38               39               */
       0x8403,          0x83d8,          0x840b,          0x83c1,
    /* 40               41               42               43               */
       0x83f7,          0x8407,          0x83e0,          0x83f2,
    /* 44               45               46               47               */
       0x840d,          0x8422,          0x8420,          0x83bd,
    /* 48               49               50               51               */
       0x8438,          0x8506,          0x83fb,          0x846d,
    /* 52               53               54               55               */
       0x842a,          0x843c,          0x855a,          0x8484,
    /* 56               57               58               59               */
       0x8477,          0x846b,          0x84ad,          0x846e,
    /* 60               61               62               63               */
       0x8482,          0x8469,          0x8446,          0x842c,
    /* 64               65               66               67               */
       0x846f,          0x8479,          0x8435,          0x84ca,
    /* 68               69               70               71               */
       0x8462,          0x84b9,          0x84bf,          0x849f,
    /* 72               73               74               75               */
       0x84d9,          0x84cd,          0x84bb,          0x84da,
    /* 76               77               78               79               */
       0x84d0,          0x84c1,          0x84c6,          0x84d6,
    /* 80               81               82               83               */
       0x84a1,          0x8521,          0x84ff,          0x84f4,
    /* 84               85               86               87               */
       0x8517,          0x8518,          0x852c,          0x851f,
    /* 88               89               90               91               */
       0x8515,          0x8514,          0x84fc,          0x8540,
    /* 92               93               94                                */
       0x8563,          0x8558,          0x8548,
/* JIS X 0208 (/ 0213 plane 1) row 73 */
    /*                   1                2                3               */
                        0x8541,          0x8602,          0x854b,
    /*  4                5                6                7               */
       0x8555,          0x8580,          0x85a4,          0x8588,
    /*  8                9               10               11               */
       0x8591,          0x858a,          0x85a8,          0x856d,
    /* 12               13               14               15               */
       0x8594,          0x859b,          0x85ea,          0x8587,
    /* 16               17               18               19               */
       0x859c,          0x8577,          0x857e,          0x8590,
    /* 20               21               22               23               */
       0x85c9,          0x85ba,          0x85cf,          0x85b9,
    /* 24               25               26               27               */
       0x85d0,          0x85d5,          0x85dd,          0x85e5,
    /* 28               29               30               31               */
       0x85dc,          0x85f9,          0x860a,          0x8613,
    /* 32               33               34               35               */
       0x860b,          0x85fe,          0x85fa,          0x8606,
    /* 36               37               38               39               */
       0x8622,          0x861a,          0x8630,          0x863f,
    /* 40               41               42               43               */
       0x864d,          0x4e55,          0x8654,          0x865f,
    /* 44               45               46               47               */
       0x8667,          0x8671,          0x8693,          0x86a3,
    /* 48               49               50               51               */
       0x86a9,          0x86aa,          0x868b,          0x868c,
    /* 52               53               54               55               */
       0x86b6,          0x86af,          0x86c4,          0x86c6,
    /* 56               57               58               59               */
       0x86b0,          0x86c9,          0x8823,          0x86ab,
    /* 60               61               62               63               */
       0x86d4,          0x86de,          0x86e9,          0x86ec,
    /* 64               65               66               67               */
       0x86df,          0x86db,          0x86ef,          0x8712,
    /* 68               69               70               71               */
       0x8706,          0x8708,          0x8700,          0x8703,
    /* 72               73               74               75               */
       0x86fb,          0x8711,          0x8709,          0x870d,
    /* 76               77               78               79               */
       0x86f9,          0x870a,          0x8734,          0x873f,
    /* 80               81               82               83               */
       0x8737,          0x873b,          0x8725,          0x8729,
    /* 84               85               86               87               */
       0x871a,          0x8760,          0x875f,          0x8778,
    /* 88               89               90               91               */
       0x874c,          0x874e,          0x8774,          0x8757,
    /* 92               93               94                                */
       0x8768,          0x876e,          0x8759,
/* JIS X 0208 (/ 0213 plane 1) row 74 */
    /*                   1                2                3               */
                        0x8753,          0x8763,          0x876a,
    /*  4                5                6                7               */
       0x8805,          0x87a2,          0x879f,          0x8782,
    /*  8                9               10               11               */
       0x87af,          0x87cb,          0x87bd,          0x87c0,
    /* 12               13               14               15               */
       0x87d0,          0x96d6,          0x87ab,          0x87c4,
    /* 16               17               18               19               */
       0x87b3,          0x87c7,          0x87c6,          0x87bb,
    /* 20               21               22               23               */
       0x87ef,          0x87f2,          0x87e0,          0x880f,
    /* 24               25               26               27               */
       0x880d,          0x87fe,          0x87f6,          0x87f7,
    /* 28               29               30               31               */
       0x880e,          0x87d2,          0x8811,          0x8816,
    /* 32               33               34               35               */
       0x8815,          0x8822,          0x8821,          0x8831,
    /* 36               37               38               39               */
       0x8836,          0x8839,          0x8827,          0x883b,
    /* 40               41               42               43               */
       0x8844,          0x8842,          0x8852,          0x8859,
    /* 44               45               46               47               */
       0x885e,          0x8862,          0x886b,          0x8881,
    /* 48               49               50               51               */
       0x887e,          0x889e,          0x8875,          0x887d,
    /* 52               53               54               55               */
       0x88b5,          0x8872,          0x8882,          0x8897,
    /* 56               57               58               59               */
       0x8892,          0x88ae,          0x8899,          0x88a2,
    /* 60               61               62               63               */
       0x888d,          0x88a4,          0x88b0,          0x88bf,
    /* 64               65               66               67               */
       0x88b1,          0x88c3,          0x88c4,          0x88d4,
    /* 68               69               70               71               */
       0x88d8,          0x88d9,          0x88dd,          0x88f9,
    /* 72               73               74               75               */
       0x8902,          0x88fc,          0x88f4,          0x88e8,
    /* 76               77               78               79               */
       0x88f2,          0x8904,          0x890c,          0x890a,
    /* 80               81               82               83               */
       0x8913,          0x8943,          0x891e,          0x8925,
    /* 84               85               86               87               */
       0x892a,          0x892b,          0x8941,          0x8944,
    /* 88               89               90               91               */
       0x893b,          0x8936,          0x8938,          0x894c,
    /* 92               93               94                                */
       0x891d,          0x8960,          0x895e,
/* JIS X 0208 (/ 0213 plane 1) row 75 */
    /*                   1                2                3               */
                        0x8966,          0x8964,          0x896d,
    /*  4                5                6                7               */
       0x896a,          0x896f,          0x8974,          0x8977,
    /*  8                9               10               11               */
       0x897e,          0x8983,          0x8988,          0x898a,
    /* 12               13               14               15               */
       0x8993,          0x8998,          0x89a1,          0x89a9,
    /* 16               17               18               19               */
       0x89a6,          0x89ac,          0x89af,          0x89b2,
    /* 20               21               22               23               */
       0x89ba,          0x89bd,          0x89bf,          0x89c0,
    /* 24               25               26               27               */
       0x89da,          0x89dc,          0x89dd,          0x89e7,
    /* 28               29               30               31               */
       0x89f4,          0x89f8,          0x8a03,          0x8a16,
    /* 32               33               34               35               */
       0x8a10,          0x8a0c,          0x8a1b,          0x8a1d,
    /* 36               37               38               39               */
       0x8a25,          0x8a36,          0x8a41,          0x8a5b,
    /* 40               41               42               43               */
       0x8a52,          0x8a46,          0x8a48,          0x8a7c,
    /* 44               45               46               47               */
       0x8a6d,          0x8a6c,          0x8a62,          0x8a85,
    /* 48               49               50               51               */
       0x8a82,          0x8a84,          0x8aa8,          0x8aa1,
    /* 52               53               54               55               */
       0x8a91,          0x8aa5,          0x8aa6,          0x8a9a,
    /* 56               57               58               59               */
       0x8aa3,          0x8ac4,          0x8acd,          0x8ac2,
    /* 60               61               62               63               */
       0x8ada,          0x8aeb,          0x8af3,          0x8ae7,
    /* 64               65               66               67               */
       0x8ae4,          0x8af1,          0x8b14,          0x8ae0,
    /* 68               69               70               71               */
       0x8ae2,          0x8af7,          0x8ade,          0x8adb,
    /* 72               73               74               75               */
       0x8b0c,          0x8b07,          0x8b1a,          0x8ae1,
    /* 76               77               78               79               */
       0x8b16,          0x8b10,          0x8b17,          0x8b20,
    /* 80               81               82               83               */
       0x8b33,          0x97ab,          0x8b26,          0x8b2b,
    /* 84               85               86               87               */
       0x8b3e,          0x8b28,          0x8b41,          0x8b4c,
    /* 88               89               90               91               */
       0x8b4f,          0x8b4e,          0x8b49,          0x8b56,
    /* 92               93               94                                */
       0x8b5b,          0x8b5a,          0x8b6b,
/* JIS X 0208 (/ 0213 plane 1) row 76 */
    /*                   1                2                3               */
                        0x8b5f,          0x8b6c,          0x8b6f,
    /*  4                5                6                7               */
       0x8b74,          0x8b7d,          0x8b80,          0x8b8c,
    /*  8                9               10               11               */
       0x8b8e,          0x8b92,          0x8b93,          0x8b96,
    /* 12               13               14               15               */
       0x8b99,          0x8b9a,          0x8c3a,          0x8c41,
    /* 16               17               18               19               */
       0x8c3f,          0x8c48,          0x8c4c,          0x8c4e,
    /* 20               21               22               23               */
       0x8c50,          0x8c55,          0x8c62,          0x8c6c,
    /* 24               25               26               27               */
       0x8c78,          0x8c7a,          0x8c82,          0x8c89,
    /* 28               29               30               31               */
       0x8c85,          0x8c8a,          0x8c8d,          0x8c8e,
    /* 32               33               34               35               */
       0x8c94,          0x8c7c,          0x8c98,          0x621d,
    /* 36               37               38               39               */
       0x8cad,          0x8caa,          0x8cbd,          0x8cb2,
    /* 40               41               42               43               */
       0x8cb3,          0x8cae,          0x8cb6,          0x8cc8,
    /* 44               45               46               47               */
       0x8cc1,          0x8ce4,          0x8ce3,          0x8cda,
    /* 48               49               50               51               */
       0x8cfd,          0x8cfa,          0x8cfb,          0x8d04,
    /* 52               53               54               55               */
       0x8d05,          0x8d0a,          0x8d07,          0x8d0f,
    /* 56               57               58               59               */
       0x8d0d,          0x8d10,          0x9f4e,          0x8d13,
    /* 60               61               62               63               */
       0x8ccd,          0x8d14,          0x8d16,          0x8d67,
    /* 64               65               66               67               */
       0x8d6d,          0x8d71,          0x8d73,          0x8d81,
    /* 68               69               70               71               */
       0x8d99,          0x8dc2,          0x8dbe,          0x8dba,
    /* 72               73               74               75               */
       0x8dcf,          0x8dda,          0x8dd6,          0x8dcc,
    /* 76               77               78               79               */
       0x8ddb,          0x8dcb,          0x8dea,          0x8deb,
    /* 80               81               82               83               */
       0x8ddf,          0x8de3,          0x8dfc,          0x8e08,
    /* 84               85               86               87               */
       0x8e09,          0x8dff,          0x8e1d,          0x8e1e,
    /* 88               89               90               91               */
       0x8e10,          0x8e1f,          0x8e42,          0x8e35,
    /* 92               93               94                                */
       0x8e30,          0x8e34,          0x8e4a,
/* JIS X 0208 (/ 0213 plane 1) row 77 */
    /*                   1                2                3               */
                        0x8e47,          0x8e49,          0x8e4c,
    /*  4                5                6                7               */
       0x8e50,          0x8e48,          0x8e59,          0x8e64,
    /*  8                9               10               11               */
       0x8e60,          0x8e2a,          0x8e63,          0x8e55,
    /* 12               13               14               15               */
       0x8e76,          0x8e72,          0x8e7c,          0x8e81,
    /* 16               17               18               19               */
       0x8e87,          0x8e85,          0x8e84,          0x8e8b,
    /* 20               21               22               23               */
       0x8e8a,          0x8e93,          0x8e91,          0x8e94,
    /* 24               25               26               27               */
       0x8e99,          0x8eaa,          0x8ea1,          0x8eac,
    /* 28               29               30               31               */
       0x8eb0,          0x8ec6,          0x8eb1,          0x8ebe,
    /* 32               33               34               35               */
       0x8ec5,          0x8ec8,          0x8ecb,          0x8edb,
    /* 36               37               38               39               */
       0x8ee3,          0x8efc,          0x8efb,          0x8eeb,
    /* 40               41               42               43               */
       0x8efe,          0x8f0a,          0x8f05,          0x8f15,
    /* 44               45               46               47               */
       0x8f12,          0x8f19,          0x8f13,          0x8f1c,
    /* 48               49               50               51               */
       0x8f1f,          0x8f1b,          0x8f0c,          0x8f26,
    /* 52               53               54               55               */
       0x8f33,          0x8f3b,          0x8f39,          0x8f45,
    /* 56               57               58               59               */
       0x8f42,          0x8f3e,          0x8f4c,          0x8f49,
    /* 60               61               62               63               */
       0x8f46,          0x8f4e,          0x8f57,          0x8f5c,
    /* 64               65               66               67               */
       0x8f62,          0x8f63,          0x8f64,          0x8f9c,
    /* 68               69               70               71               */
       0x8f9f,          0x8fa3,          0x8fad,          0x8faf,
    /* 72               73               74               75               */
       0x8fb7,          0x8fda,          0x8fe5,          0x8fe2,
    /* 76               77               78               79               */
       0x8fea,          0x8fef,          0x9087,          0x8ff4,
    /* 80               81               82               83               */
       0x9005,          0x8ff9,          0x8ffa,          0x9011,
    /* 84               85               86               87               */
       0x9015,          0x9021,          0x900d,          0x901e,
    /* 88               89               90               91               */
       0x9016,          0x900b,          0x9027,          0x9036,
    /* 92               93               94                                */
       0x9035,          0x9039,          0x8ff8,
/* JIS X 0208 (/ 0213 plane 1) row 78 */
    /*                   1                2                3               */
                        0x904f,          0x9050,          0x9051,
    /*  4                5                6                7               */
       0x9052,          0x900e,          0x9049,          0x903e,
    /*  8                9               10               11               */
       0x9056,          0x9058,          0x905e,          0x9068,
    /* 12               13               14               15               */
       0x906f,          0x9076,          0x96a8,          0x9072,
    /* 16               17               18               19               */
       0x9082,          0x907d,          0x9081,          0x9080,
    /* 20               21               22               23               */
       0x908a,          0x9089,          0x908f,          0x90a8,
    /* 24               25               26               27               */
       0x90af,          0x90b1,          0x90b5,          0x90e2,
    /* 28               29               30               31               */
       0x90e4,          0x6248,          0x90db,          0x9102,
    /* 32               33               34               35               */
       0x9112,          0x9119,          0x9132,          0x9130,
    /* 36               37               38               39               */
       0x914a,          0x9156,          0x9158,          0x9163,
    /* 40               41               42               43               */
       0x9165,          0x9169,          0x9173,          0x9172,
    /* 44               45               46               47               */
       0x918b,          0x9189,          0x9182,          0x91a2,
    /* 48               49               50               51               */
       0x91ab,          0x91af,          0x91aa,          0x91b5,
    /* 52               53               54               55               */
       0x91b4,          0x91ba,          0x91c0,          0x91c1,
    /* 56               57               58               59               */
       0x91c9,          0x91cb,          0x91d0,          0x91d6,
    /* 60               61               62               63               */
       0x91df,          0x91e1,          0x91db,          0x91fc,
    /* 64               65               66               67               */
       0x91f5,          0x91f6,          0x921e,          0x91ff,
    /* 68               69               70               71               */
       0x9214,          0x922c,          0x9215,          0x9211,
    /* 72               73               74               75               */
       0x925e,          0x9257,          0x9245,          0x9249,
    /* 76               77               78               79               */
       0x9264,          0x9248,          0x9295,          0x923f,
    /* 80               81               82               83               */
       0x924b,          0x9250,          0x929c,          0x9296,
    /* 84               85               86               87               */
       0x9293,          0x929b,          0x925a,          0x92cf,
    /* 88               89               90               91               */
       0x92b9,          0x92b7,          0x92e9,          0x930f,
    /* 92               93               94                                */
       0x92fa,          0x9344,          0x932e,
/* JIS X 0208 (/ 0213 plane 1) row 79 */
    /*                   1                2                3               */
                        0x9319,          0x9322,          0x931a,
    /*  4                5                6                7               */
       0x9323,          0x933a,          0x9335,          0x933b,
    /*  8                9               10               11               */
       0x935c,          0x9360,          0x937c,          0x936e,
    /* 12               13               14               15               */
       0x9356,          0x93b0,          0x93ac,          0x93ad,
    /* 16               17               18               19               */
       0x9394,          0x93b9,          0x93d6,          0x93d7,
    /* 20               21               22               23               */
       0x93e8,          0x93e5,          0x93d8,          0x93c3,
    /* 24               25               26               27               */
       0x93dd,          0x93d0,          0x93c8,          0x93e4,
    /* 28               29               30               31               */
       0x941a,          0x9414,          0x9413,          0x9403,
    /* 32               33               34               35               */
       0x9407,          0x9410,          0x9436,          0x942b,
    /* 36               37               38               39               */
       0x9435,          0x9421,          0x943a,          0x9441,
    /* 40               41               42               43               */
       0x9452,          0x9444,          0x945b,          0x9460,
    /* 44               45               46               47               */
       0x9462,          0x945e,          0x946a,          0x9229,
    /* 48               49               50               51               */
       0x9470,          0x9475,          0x9477,          0x947d,
    /* 52               53               54               55               */
       0x945a,          0x947c,          0x947e,          0x9481,
    /* 56               57               58               59               */
       0x947f,          0x9582,          0x9587,          0x958a,
    /* 60               61               62               63               */
       0x9594,          0x9596,          0x9598,          0x9599,
    /* 64               65               66               67               */
       0x95a0,          0x95a8,          0x95a7,          0x95ad,
    /* 68               69               70               71               */
       0x95bc,          0x95bb,          0x95b9,          0x95be,
    /* 72               73               74               75               */
       0x95ca,          0x6ff6,          0x95c3,          0x95cd,
    /* 76               77               78               79               */
       0x95cc,          0x95d5,          0x95d4,          0x95d6,
    /* 80               81               82               83               */
       0x95dc,          0x95e1,          0x95e5,          0x95e2,
    /* 84               85               86               87               */
       0x9621,          0x9628,          0x962e,          0x962f,
    /* 88               89               90               91               */
       0x9642,          0x964c,          0x964f,          0x964b,
    /* 92               93               94                                */
       0x9677,          0x965c,          0x965e,
/* JIS X 0208 (/ 0213 plane 1) row 80 */
    /*                   1                2                3               */
                        0x965d,          0x965f,          0x9666,
    /*  4                5                6                7               */
       0x9672,          0x966c,          0x968d,          0x9698,
    /*  8                9               10               11               */
       0x9695,          0x9697,          0x96aa,          0x96a7,
    /* 12               13               14               15               */
       0x96b1,          0x96b2,          0x96b0,          0x96b4,
    /* 16               17               18               19               */
       0x96b6,          0x96b8,          0x96b9,          0x96ce,
    /* 20               21               22               23               */
       0x96cb,          0x96c9,          0x96cd,          0x894d,
    /* 24               25               26               27               */
       0x96dc,          0x970d,          0x96d5,          0x96f9,
    /* 28               29               30               31               */
       0x9704,          0x9706,          0x9708,          0x9713,
    /* 32               33               34               35               */
       0x970e,          0x9711,          0x970f,          0x9716,
    /* 36               37               38               39               */
       0x9719,          0x9724,          0x972a,          0x9730,
    /* 40               41               42               43               */
       0x9739,          0x973d,          0x973e,          0x9744,
    /* 44               45               46               47               */
       0x9746,          0x9748,          0x9742,          0x9749,
    /* 48               49               50               51               */
       0x975c,          0x9760,          0x9764,          0x9766,
    /* 52               53               54               55               */
       0x9768,          0x52d2,          0x976b,          0x9771,
    /* 56               57               58               59               */
       0x9779,          0x9785,          0x977c,          0x9781,
    /* 60               61               62               63               */
       0x977a,          0x9786,          0x978b,          0x978f,
    /* 64               65               66               67               */
       0x9790,          0x979c,          0x97a8,          0x97a6,
    /* 68               69               70               71               */
       0x97a3,          0x97b3,          0x97b4,          0x97c3,
    /* 72               73               74               75               */
       0x97c6,          0x97c8,          0x97cb,          0x97dc,
    /* 76               77               78               79               */
       0x97ed,          0x9f4f,          0x97f2,          0x7adf,
    /* 80               81               82               83               */
       0x97f6,          0x97f5,          0x980f,          0x980c,
    /* 84               85               86               87               */
       0x9838,          0x9824,          0x9821,          0x9837,
    /* 88               89               90               91               */
       0x983d,          0x9846,          0x984f,          0x984b,
    /* 92               93               94                                */
       0x986b,          0x986f,          0x9870,
/* JIS X 0208 (/ 0213 plane 1) row 81 */
    /*                   1                2                3               */
                        0x9871,          0x9874,          0x9873,
    /*  4                5                6                7               */
       0x98aa,          0x98af,          0x98b1,          0x98b6,
    /*  8                9               10               11               */
       0x98c4,          0x98c3,          0x98c6,          0x98e9,
    /* 12               13               14               15               */
       0x98eb,          0x9903,          0x9909,          0x9912,
    /* 16               17               18               19               */
       0x9914,          0x9918,          0x9921,          0x991d,
    /* 20               21               22               23               */
       0x991e,          0x9924,          0x9920,          0x992c,
    /* 24               25               26               27               */
       0x992e,          0x993d,          0x993e,          0x9942,
    /* 28               29               30               31               */
       0x9949,          0x9945,          0x9950,          0x994b,
    /* 32               33               34               35               */
       0x9951,          0x9952,          0x994c,          0x9955,
    /* 36               37               38               39               */
       0x9997,          0x9998,          0x99a5,          0x99ad,
    /* 40               41               42               43               */
       0x99ae,          0x99bc,          0x99df,          0x99db,
    /* 44               45               46               47               */
       0x99dd,          0x99d8,          0x99d1,          0x99ed,
    /* 48               49               50               51               */
       0x99ee,          0x99f1,          0x99f2,          0x99fb,
    /* 52               53               54               55               */
       0x99f8,          0x9a01,          0x9a0f,          0x9a05,
    /* 56               57               58               59               */
       0x99e2,          0x9a19,          0x9a2b,          0x9a37,
    /* 60               61               62               63               */
       0x9a45,          0x9a42,          0x9a40,          0x9a43,
    /* 64               65               66               67               */
       0x9a3e,          0x9a55,          0x9a4d,          0x9a5b,
    /* 68               69               70               71               */
       0x9a57,          0x9a5f,          0x9a62,          0x9a65,
    /* 72               73               74               75               */
       0x9a64,          0x9a69,          0x9a6b,          0x9a6a,
    /* 76               77               78               79               */
       0x9aad,          0x9ab0,          0x9abc,          0x9ac0,
    /* 80               81               82               83               */
       0x9acf,          0x9ad1,          0x9ad3,          0x9ad4,
    /* 84               85               86               87               */
       0x9ade,          0x9adf,          0x9ae2,          0x9ae3,
    /* 88               89               90               91               */
       0x9ae6,          0x9aef,          0x9aeb,          0x9aee,
    /* 92               93               94                                */
       0x9af4,          0x9af1,          0x9af7,
/* JIS X 0208 (/ 0213 plane 1) row 82 */
    /*                   1                2                3               */
                        0x9afb,          0x9b06,          0x9b18,
    /*  4                5                6                7               */
       0x9b1a,          0x9b1f,          0x9b22,          0x9b23,
    /*  8                9               10               11               */
       0x9b25,          0x9b27,          0x9b28,          0x9b29,
    /* 12               13               14               15               */
       0x9b2a,          0x9b2e,          0x9b2f,          0x9b32,
    /* 16               17               18               19               */
       0x9b44,          0x9b43,          0x9b4f,          0x9b4d,
    /* 20               21               22               23               */
       0x9b4e,          0x9b51,          0x9b58,          0x9b74,
    /* 24               25               26               27               */
       0x9b93,          0x9b83,          0x9b91,          0x9b96,
    /* 28               29               30               31               */
       0x9b97,          0x9b9f,          0x9ba0,          0x9ba8,
    /* 32               33               34               35               */
       0x9bb4,          0x9bc0,          0x9bca,          0x9bb9,
    /* 36               37               38               39               */
       0x9bc6,          0x9bcf,          0x9bd1,          0x9bd2,
    /* 40               41               42               43               */
       0x9be3,          0x9be2,          0x9be4,          0x9bd4,
    /* 44               45               46               47               */
       0x9be1,          0x9c3a,          0x9bf2,          0x9bf1,
    /* 48               49               50               51               */
       0x9bf0,          0x9c15,          0x9c14,          0x9c09,
    /* 52               53               54               55               */
       0x9c13,          0x9c0c,          0x9c06,          0x9c08,
    /* 56               57               58               59               */
       0x9c12,          0x9c0a,          0x9c04,          0x9c2e,
    /* 60               61               62               63               */
       0x9c1b,          0x9c25,          0x9c24,          0x9c21,
    /* 64               65               66               67               */
       0x9c30,          0x9c47,          0x9c32,          0x9c46,
    /* 68               69               70               71               */
       0x9c3e,          0x9c5a,          0x9c60,          0x9c67,
    /* 72               73               74               75               */
       0x9c76,          0x9c78,          0x9ce7,          0x9cec,
    /* 76               77               78               79               */
       0x9cf0,          0x9d09,          0x9d08,          0x9ceb,
    /* 80               81               82               83               */
       0x9d03,          0x9d06,          0x9d2a,          0x9d26,
    /* 84               85               86               87               */
       0x9daf,          0x9d23,          0x9d1f,          0x9d44,
    /* 88               89               90               91               */
       0x9d15,          0x9d12,          0x9d41,          0x9d3f,
    /* 92               93               94                                */
       0x9d3e,          0x9d46,          0x9d48,
/* JIS X 0208 (/ 0213 plane 1) row 83 */
    /*                   1                2                3               */
                        0x9d5d,          0x9d5e,          0x9d64,
    /*  4                5                6                7               */
       0x9d51,          0x9d50,          0x9d59,          0x9d72,
    /*  8                9               10               11               */
       0x9d89,          0x9d87,          0x9dab,          0x9d6f,
    /* 12               13               14               15               */
       0x9d7a,          0x9d9a,          0x9da4,          0x9da9,
    /* 16               17               18               19               */
       0x9db2,          0x9dc4,          0x9dc1,          0x9dbb,
    /* 20               21               22               23               */
       0x9db8,          0x9dba,          0x9dc6,          0x9dcf,
    /* 24               25               26               27               */
       0x9dc2,          0x9dd9,          0x9dd3,          0x9df8,
    /* 28               29               30               31               */
       0x9de6,          0x9ded,          0x9def,          0x9dfd,
    /* 32               33               34               35               */
       0x9e1a,          0x9e1b,          0x9e1e,          0x9e75,
    /* 36               37               38               39               */
       0x9e79,          0x9e7d,          0x9e81,          0x9e88,
    /* 40               41               42               43               */
       0x9e8b,          0x9e8c,          0x9e92,          0x9e95,
    /* 44               45               46               47               */
       0x9e91,          0x9e9d,          0x9ea5,          0x9ea9,
    /* 48               49               50               51               */
       0x9eb8,          0x9eaa,          0x9ead,          0x9761,
    /* 52               53               54               55               */
       0x9ecc,          0x9ece,          0x9ecf,          0x9ed0,
    /* 56               57               58               59               */
       0x9ed4,          0x9edc,          0x9ede,          0x9edd,
    /* 60               61               62               63               */
       0x9ee0,          0x9ee5,          0x9ee8,          0x9eef,
    /* 64               65               66               67               */
       0x9ef4,          0x9ef6,          0x9ef7,          0x9ef9,
    /* 68               69               70               71               */
       0x9efb,          0x9efc,          0x9efd,          0x9f07,
    /* 72               73               74               75               */
       0x9f08,          0x76b7,          0x9f15,          0x9f21,
    /* 76               77               78               79               */
       0x9f2c,          0x9f3e,          0x9f4a,          0x9f52,
    /* 80               81               82               83               */
       0x9f54,          0x9f63,          0x9f5f,          0x9f60,
    /* 84               85               86               87               */
       0x9f61,          0x9f66,          0x9f67,          0x9f6c,
    /* 88               89               90               91               */
       0x9f6a,          0x9f77,          0x9f72,          0x9f76,
    /* 92               93               94                                */
       0x9f95,          0x9f9c,          0x9fa0,
/* JIS X 0208 (/ 0213 plane 1) row 84 */
    /*                   1                2                3               */
                        0x582f,          0x69c7,          0x9059,
    /*  4                5                6                7               */
       0x7464,          0x51dc,          0x7199,          X0213(0x5653),
    /*  8                9               10               11               */
       X0213(0x5de2),   X0213(0x5e14),   X0213(0x5e18),   X0213(0x5e58),
    /* 12               13               14               15               */
       X0213(0x5e5e),   X0213(0x5ebe),   X0213(0xf928),   X0213(0x5ecb),
    /* 16               17               18               19               */
       X0213(0x5ef9),   X0213(0x5f00),   X0213(0x5f02),   X0213(0x5f07),
    /* 20               21               22               23               */
       X0213(0x5f1d),   X0213(0x5f23),   X0213(0x5f34),   X0213(0x5f36),
    /* 24               25               26               27               */
       X0213(0x5f3d),   X0213(0x5f40),   X0213(0x5f45),   X0213(0x5f54),
    /* 28               29               30               31               */
       X0213(0x5f58),   X0213(0x5f64),   X0213(0x5f67),   X0213(0x5f7d),
    /* 32               33               34               35               */
       X0213(0x5f89),   X0213(0x5f9c),   X0213(0x5fa7),   X0213(0x5faf),
    /* 36               37               38               39               */
       X0213(0x5fb5),   X0213(0x5fb7),   X0213(0x5fc9),   X0213(0x5fde),
    /* 40               41               42               43               */
       X0213(0x5fe1),   X0213(0x5fe9),   X0213(0x600d),   X0213(0x6014),
    /* 44               45               46               47               */
       X0213(0x6018),   X0213(0x6033),   X0213(0x6035),   X0213(0x6047),
    /* 48               49               50               51               */
       X0213(0xfa3d),   X0213(0x609d),   X0213(0x609e),   X0213(0x60cb),
    /* 52               53               54               55               */
       X0213(0x60d4),   X0213(0x60d5),   X0213(0x60dd),   X0213(0x60f8),
    /* 56               57               58               59               */
       X0213(0x611c),   X0213(0x612b),   X0213(0x6130),   X0213(0x6137),
    /* 60               61               62               63               */
       X0213(0xfa3e),   X0213(0x618d),   X0213(0xfa3f),   X0213(0x61bc),
    /* 64               65               66               67               */
       X0213(0x61b9),   X0213(0xfa40),   X0213(0x6222),   X0213(0x623e),
    /* 68               69               70               71               */
       X0213(0x6243),   X0213(0x6256),   X0213(0x625a),   X0213(0x626f),
    /* 72               73               74               75               */
       X0213(0x6285),   X0213(0x62c4),   X0213(0x62d6),   X0213(0x62fc),
    /* 76               77               78               79               */
       X0213(0x630a),   X0213(0x6318),   X0213(0x6339),   X0213(0x6343),
    /* 80               81               82               83               */
       X0213(0x6365),   X0213(0x637c),   X0213(0x63e5),   X0213(0x63ed),
    /* 84               85               86               87               */
       X0213(0x63f5),   X0213(0x6410),   X0213(0x6414),   X0213(0x6422),
    /* 88               89               90               91               */
       X0213(0x6479),   X0213(0x6451),   X0213(0x6460),   X0213(0x646d),
    /* 92               93               94                                */
       X0213(0x64ce),   X0213(0x64be),   X0213(0x64bf),
#if	defined(JFP_J2U_ICONV_X0213)
/* JIS X 0208 (/ 0213 plane 1) row 85 */
    /*                   1                2                3               */
                        X0213(0x64c4),   X0213(0x64ca),   X0213(0x64d0),
    /*  4                5                6                7               */
       X0213(0x64f7),   X0213(0x64fb),   X0213(0x6522),   X0213(0x6529),
    /*  8                9               10               11               */
       X0213(0xfa41),   X0213(0x6567),   X0213(0x659d),   X0213(0xfa42),
    /* 12               13               14               15               */
       X0213(0x6600),   X0213(0x6609),   X0213(0x6615),   X0213(0x661e),
    /* 16               17               18               19               */
       X0213(0x663a),   X0213(0x6622),   X0213(0x6624),   X0213(0x662b),
    /* 20               21               22               23               */
       X0213(0x6630),   X0213(0x6631),   X0213(0x6633),   X0213(0x66fb),
    /* 24               25               26               27               */
       X0213(0x6648),   X0213(0x664c),   X0213NB(0xd84c), X0213(0x6659),
    /* 28               29               30               31               */
       X0213(0x665a),   X0213(0x6661),   X0213(0x6665),   X0213(0x6673),
    /* 32               33               34               35               */
       X0213(0x6677),   X0213(0x6678),   X0213(0x668d),   X0213(0xfa43),
    /* 36               37               38               39               */
       X0213(0x66a0),   X0213(0x66b2),   X0213(0x66bb),   X0213(0x66c6),
    /* 40               41               42               43               */
       X0213(0x66c8),   X0213(0x3b22),   X0213(0x66db),   X0213(0x66e8),
    /* 44               45               46               47               */
       X0213(0x66fa),   X0213(0x6713),   X0213(0xf929),   X0213(0x6733),
    /* 48               49               50               51               */
       X0213(0x6766),   X0213(0x6747),   X0213(0x6748),   X0213(0x677b),
    /* 52               53               54               55               */
       X0213(0x6781),   X0213(0x6793),   X0213(0x6798),   X0213(0x679b),
    /* 56               57               58               59               */
       X0213(0x67bb),   X0213(0x67f9),   X0213(0x67c0),   X0213(0x67d7),
    /* 60               61               62               63               */
       X0213(0x67fc),   X0213(0x6801),   X0213(0x6852),   X0213(0x681d),
    /* 64               65               66               67               */
       X0213(0x682c),   X0213(0x6831),   X0213(0x685b),   X0213(0x6872),
    /* 68               69               70               71               */
       X0213(0x6875),   X0213(0xfa44),   X0213(0x68a3),   X0213(0x68a5),
    /* 72               73               74               75               */
       X0213(0x68b2),   X0213(0x68c8),   X0213(0x68d0),   X0213(0x68e8),
    /* 76               77               78               79               */
       X0213(0x68ed),   X0213(0x68f0),   X0213(0x68f1),   X0213(0x68fc),
    /* 80               81               82               83               */
       X0213(0x690a),   X0213(0x6949),   X0213NB(0xd84d), X0213(0x6935),
    /* 84               85               86               87               */
       X0213(0x6942),   X0213(0x6957),   X0213(0x6963),   X0213(0x6964),
    /* 88               89               90               91               */
       X0213(0x6968),   X0213(0x6980),   X0213(0xfa14),   X0213(0x69a5),
    /* 92               93               94                                */
       X0213(0x69ad),   X0213(0x69cf),   X0213(0x3bb6),
/* JIS X 0208 (/ 0213 plane 1) row 86 */
    /*                   1                2                3               */
                        X0213(0x3bc3),   X0213(0x69e2),   X0213(0x69e9),
    /*  4                5                6                7               */
       X0213(0x69ea),   X0213(0x69f5),   X0213(0x69f6),   X0213(0x6a0f),
    /*  8                9               10               11               */
       X0213(0x6a15),   X0213NB(0xd84d), X0213(0x6a3b),   X0213(0x6a3e),
    /* 12               13               14               15               */
       X0213(0x6a45),   X0213(0x6a50),   X0213(0x6a56),   X0213(0x6a5b),
    /* 16               17               18               19               */
       X0213(0x6a6b),   X0213(0x6a73),   X0213NB(0xd84d), X0213(0x6a89),
    /* 20               21               22               23               */
       X0213(0x6a94),   X0213(0x6a9d),   X0213(0x6a9e),   X0213(0x6aa5),
    /* 24               25               26               27               */
       X0213(0x6ae4),   X0213(0x6ae7),   X0213(0x3c0f),   X0213(0xf91d),
    /* 28               29               30               31               */
       X0213(0x6b1b),   X0213(0x6b1e),   X0213(0x6b2c),   X0213(0x6b35),
    /* 32               33               34               35               */
       X0213(0x6b46),   X0213(0x6b56),   X0213(0x6b60),   X0213(0x6b65),
    /* 36               37               38               39               */
       X0213(0x6b67),   X0213(0x6b77),   X0213(0x6b82),   X0213(0x6ba9),
    /* 40               41               42               43               */
       X0213(0x6bad),   X0213(0xf970),   X0213(0x6bcf),   X0213(0x6bd6),
    /* 44               45               46               47               */
       X0213(0x6bd7),   X0213(0x6bff),   X0213(0x6c05),   X0213(0x6c10),
    /* 48               49               50               51               */
       X0213(0x6c33),   X0213(0x6c59),   X0213(0x6c5c),   X0213(0x6caa),
    /* 52               53               54               55               */
       X0213(0x6c74),   X0213(0x6c76),   X0213(0x6c85),   X0213(0x6c86),
    /* 56               57               58               59               */
       X0213(0x6c98),   X0213(0x6c9c),   X0213(0x6cfb),   X0213(0x6cc6),
    /* 60               61               62               63               */
       X0213(0x6cd4),   X0213(0x6ce0),   X0213(0x6ceb),   X0213(0x6cee),
    /* 64               65               66               67               */
       X0213NB(0xd84f), X0213(0x6d04),   X0213(0x6d0e),   X0213(0x6d2e),
    /* 68               69               70               71               */
       X0213(0x6d31),   X0213(0x6d39),   X0213(0x6d3f),   X0213(0x6d58),
    /* 72               73               74               75               */
       X0213(0x6d65),   X0213(0xfa45),   X0213(0x6d82),   X0213(0x6d87),
    /* 76               77               78               79               */
       X0213(0x6d89),   X0213(0x6d94),   X0213(0x6daa),   X0213(0x6dac),
    /* 80               81               82               83               */
       X0213(0x6dbf),   X0213(0x6dc4),   X0213(0x6dd6),   X0213(0x6dda),
    /* 84               85               86               87               */
       X0213(0x6ddb),   X0213(0x6ddd),   X0213(0x6dfc),   X0213(0xfa46),
    /* 88               89               90               91               */
       X0213(0x6e34),   X0213(0x6e44),   X0213(0x6e5c),   X0213(0x6e5e),
    /* 92               93               94                                */
       X0213(0x6eab),   X0213(0x6eb1),   X0213(0x6ec1),
/* JIS X 0208 (/ 0213 plane 1) row 87 */
    /*                   1                2                3               */
                        X0213(0x6ec7),   X0213(0x6ece),   X0213(0x6f10),
    /*  4                5                6                7               */
       X0213(0x6f1a),   X0213(0xfa47),   X0213(0x6f2a),   X0213(0x6f2f),
    /*  8                9               10               11               */
       X0213(0x6f33),   X0213(0x6f51),   X0213(0x6f59),   X0213(0x6f5e),
    /* 12               13               14               15               */
       X0213(0x6f61),   X0213(0x6f62),   X0213(0x6f7e),   X0213(0x6f88),
    /* 16               17               18               19               */
       X0213(0x6f8c),   X0213(0x6f8d),   X0213(0x6f94),   X0213(0x6fa0),
    /* 20               21               22               23               */
       X0213(0x6fa7),   X0213(0x6fb6),   X0213(0x6fbc),   X0213(0x6fc7),
    /* 24               25               26               27               */
       X0213(0x6fca),   X0213(0x6ff9),   X0213(0x6ff0),   X0213(0x6ff5),
    /* 28               29               30               31               */
       X0213(0x7005),   X0213(0x7006),   X0213(0x7028),   X0213(0x704a),
    /* 32               33               34               35               */
       X0213(0x705d),   X0213(0x705e),   X0213(0x704e),   X0213(0x7064),
    /* 36               37               38               39               */
       X0213(0x7075),   X0213(0x7085),   X0213(0x70a4),   X0213(0x70ab),
    /* 40               41               42               43               */
       X0213(0x70b7),   X0213(0x70d4),   X0213(0x70d8),   X0213(0x70e4),
    /* 44               45               46               47               */
       X0213(0x710f),   X0213(0x712b),   X0213(0x711e),   X0213(0x7120),
    /* 48               49               50               51               */
       X0213(0x712e),   X0213(0x7130),   X0213(0x7146),   X0213(0x7147),
    /* 52               53               54               55               */
       X0213(0x7151),   X0213(0xfa48),   X0213(0x7152),   X0213(0x715c),
    /* 56               57               58               59               */
       X0213(0x7160),   X0213(0x7168),   X0213(0xfa15),   X0213(0x7185),
    /* 60               61               62               63               */
       X0213(0x7187),   X0213(0x7192),   X0213(0x71c1),   X0213(0x71ba),
    /* 64               65               66               67               */
       X0213(0x71c4),   X0213(0x71fe),   X0213(0x7200),   X0213(0x7215),
    /* 68               69               70               71               */
       X0213(0x7255),   X0213(0x7256),   X0213(0x3e3f),   X0213(0x728d),
    /* 72               73               74               75               */
       X0213(0x729e),   X0213(0x72be),   X0213(0x72c0),   X0213(0x72fb),
    /* 76               77               78               79               */
       X0213NB(0xd851), X0213(0x7327),   X0213(0x7328),   X0213(0xfa16),
    /* 80               81               82               83               */
       X0213(0x7350),   X0213(0x7366),   X0213(0x737c),   X0213(0x7395),
    /* 84               85               86               87               */
       X0213(0x739f),   X0213(0x73a0),   X0213(0x73a2),   X0213(0x73a6),
    /* 88               89               90               91               */
       X0213(0x73ab),   X0213(0x73c9),   X0213(0x73cf),   X0213(0x73d6),
    /* 92               93               94                                */
       X0213(0x73d9),   X0213(0x73e3),   X0213(0x73e9),
/* JIS X 0208 (/ 0213 plane 1) row 88 */
    /*                   1                2                3               */
                        X0213(0x7407),   X0213(0x740a),   X0213(0x741a),
    /*  4                5                6                7               */
       X0213(0x741b),   X0213(0xfa4a),   X0213(0x7426),   X0213(0x7428),
    /*  8                9               10               11               */
       X0213(0x742a),   X0213(0x742b),   X0213(0x742c),   X0213(0x742e),
    /* 12               13               14               15               */
       X0213(0x742f),   X0213(0x7430),   X0213(0x7444),   X0213(0x7446),
    /* 16               17               18               19               */
       X0213(0x7447),   X0213(0x744b),   X0213(0x7457),   X0213(0x7462),
    /* 20               21               22               23               */
       X0213(0x746b),   X0213(0x746d),   X0213(0x7486),   X0213(0x7487),
    /* 24               25               26               27               */
       X0213(0x7489),   X0213(0x7498),   X0213(0x749c),   X0213(0x749f),
    /* 28               29               30               31               */
       X0213(0x74a3),   X0213(0x7490),   X0213(0x74a6),   X0213(0x74a8),
    /* 32               33               34               35               */
       X0213(0x74a9),   X0213(0x74b5),   X0213(0x74bf),   X0213(0x74c8),
    /* 36               37               38               39               */
       X0213(0x74c9),   X0213(0x74da),   X0213(0x74ff),   X0213(0x7501),
    /* 40               41               42               43               */
       X0213(0x7517),   X0213(0x752f),   X0213(0x756f),   X0213(0x7579),
    /* 44               45               46               47               */
       X0213(0x7592),   X0213(0x3f72),   X0213(0x75ce),   X0213(0x75e4),
    /* 48               49               50               51               */
       X0213(0x7600),   X0213(0x7602),   X0213(0x7608),   X0213(0x7615),
    /* 52               53               54               55               */
       X0213(0x7616),   X0213(0x7619),   X0213(0x761e),   X0213(0x762d),
    /* 56               57               58               59               */
       X0213(0x7635),   X0213(0x7643),   X0213(0x764b),   X0213(0x7664),
    /* 60               61               62               63               */
       X0213(0x7665),   X0213(0x766d),   X0213(0x766f),   X0213(0x7671),
    /* 64               65               66               67               */
       X0213(0x7681),   X0213(0x769b),   X0213(0x769d),   X0213(0x769e),
    /* 68               69               70               71               */
       X0213(0x76a6),   X0213(0x76aa),   X0213(0x76b6),   X0213(0x76c5),
    /* 72               73               74               75               */
       X0213(0x76cc),   X0213(0x76ce),   X0213(0x76d4),   X0213(0x76e6),
    /* 76               77               78               79               */
       X0213(0x76f1),   X0213(0x76fc),   X0213(0x770a),   X0213(0x7719),
    /* 80               81               82               83               */
       X0213(0x7734),   X0213(0x7736),   X0213(0x7746),   X0213(0x774d),
    /* 84               85               86               87               */
       X0213(0x774e),   X0213(0x775c),   X0213(0x775f),   X0213(0x7762),
    /* 88               89               90               91               */
       X0213(0x777a),   X0213(0x7780),   X0213(0x7794),   X0213(0x77aa),
    /* 92               93               94                                */
       X0213(0x77e0),   X0213(0x782d),   X0213NB(0xd855),
/* JIS X 0208 (/ 0213 plane 1) row 89 */
    /*                   1                2                3               */
                        X0213(0x7843),   X0213(0x784e),   X0213(0x784f),
    /*  4                5                6                7               */
       X0213(0x7851),   X0213(0x7868),   X0213(0x786e),   X0213(0xfa4b),
    /*  8                9               10               11               */
       X0213(0x78b0),   X0213NB(0xd855), X0213(0x78ad),   X0213(0x78e4),
    /* 12               13               14               15               */
       X0213(0x78f2),   X0213(0x7900),   X0213(0x78f7),   X0213(0x791c),
    /* 16               17               18               19               */
       X0213(0x792e),   X0213(0x7931),   X0213(0x7934),   X0213(0xfa4c),
    /* 20               21               22               23               */
       X0213(0xfa4d),   X0213(0x7945),   X0213(0x7946),   X0213(0xfa4e),
    /* 24               25               26               27               */
       X0213(0xfa4f),   X0213(0xfa50),   X0213(0x795c),   X0213(0xfa51),
    /* 28               29               30               31               */
       X0213(0xfa19),   X0213(0xfa1a),   X0213(0x7979),   X0213(0xfa52),
    /* 32               33               34               35               */
       X0213(0xfa53),   X0213(0xfa1b),   X0213(0x7998),   X0213(0x79b1),
    /* 36               37               38               39               */
       X0213(0x79b8),   X0213(0x79c8),   X0213(0x79ca),   X0213NB(0xd855),
    /* 40               41               42               43               */
       X0213(0x79d4),   X0213(0x79de),   X0213(0x79eb),   X0213(0x79ed),
    /* 44               45               46               47               */
       X0213(0x7a03),   X0213(0xfa54),   X0213(0x7a39),   X0213(0x7a5d),
    /* 48               49               50               51               */
       X0213(0x7a6d),   X0213(0xfa55),   X0213(0x7a85),   X0213(0x7aa0),
    /* 52               53               54               55               */
       X0213NB(0xd856), X0213(0x7ab3),   X0213(0x7abb),   X0213(0x7ace),
    /* 56               57               58               59               */
       X0213(0x7aeb),   X0213(0x7afd),   X0213(0x7b12),   X0213(0x7b2d),
    /* 60               61               62               63               */
       X0213(0x7b3b),   X0213(0x7b47),   X0213(0x7b4e),   X0213(0x7b60),
    /* 64               65               66               67               */
       X0213(0x7b6d),   X0213(0x7b6f),   X0213(0x7b72),   X0213(0x7b9e),
    /* 68               69               70               71               */
       X0213(0xfa56),   X0213(0x7bd7),   X0213(0x7bd9),   X0213(0x7c01),
    /* 72               73               74               75               */
       X0213(0x7c31),   X0213(0x7c1e),   X0213(0x7c20),   X0213(0x7c33),
    /* 76               77               78               79               */
       X0213(0x7c36),   X0213(0x4264),   X0213NB(0xd857), X0213(0x7c59),
    /* 80               81               82               83               */
       X0213(0x7c6d),   X0213(0x7c79),   X0213(0x7c8f),   X0213(0x7c94),
    /* 84               85               86               87               */
       X0213(0x7ca0),   X0213(0x7cbc),   X0213(0x7cd5),   X0213(0x7cd9),
    /* 88               89               90               91               */
       X0213(0x7cdd),   X0213(0x7d07),   X0213(0x7d08),   X0213(0x7d13),
    /* 92               93               94                                */
       X0213(0x7d1d),   X0213(0x7d23),   X0213(0x7d31),
/* JIS X 0208 (/ 0213 plane 1) row 90 */
    /*                   1                2                3               */
                        X0213(0x7d41),   X0213(0x7d48),   X0213(0x7d53),
    /*  4                5                6                7               */
       X0213(0x7d5c),   X0213(0x7d7a),   X0213(0x7d83),   X0213(0x7d8b),
    /*  8                9               10               11               */
       X0213(0x7da0),   X0213(0x7da6),   X0213(0x7dc2),   X0213(0x7dcc),
    /* 12               13               14               15               */
       X0213(0x7dd6),   X0213(0x7de3),   X0213(0xfa57),   X0213(0x7e28),
    /* 16               17               18               19               */
       X0213(0x7e08),   X0213(0x7e11),   X0213(0x7e15),   X0213(0xfa59),
    /* 20               21               22               23               */
       X0213(0x7e47),   X0213(0x7e52),   X0213(0x7e61),   X0213(0x7e8a),
    /* 24               25               26               27               */
       X0213(0x7e8d),   X0213(0x7f47),   X0213(0xfa5a),   X0213(0x7f91),
    /* 28               29               30               31               */
       X0213(0x7f97),   X0213(0x7fbf),   X0213(0x7fce),   X0213(0x7fdb),
    /* 32               33               34               35               */
       X0213(0x7fdf),   X0213(0x7fec),   X0213(0x7fee),   X0213(0x7ffa),
    /* 36               37               38               39               */
       X0213(0xfa5b),   X0213(0x8014),   X0213(0x8026),   X0213(0x8035),
    /* 40               41               42               43               */
       X0213(0x8037),   X0213(0x803c),   X0213(0x80ca),   X0213(0x80d7),
    /* 44               45               46               47               */
       X0213(0x80e0),   X0213(0x80f3),   X0213(0x8118),   X0213(0x814a),
    /* 48               49               50               51               */
       X0213(0x8160),   X0213(0x8167),   X0213(0x8168),   X0213(0x816d),
    /* 52               53               54               55               */
       X0213(0x81bb),   X0213(0x81ca),   X0213(0x81cf),   X0213(0x81d7),
    /* 56               57               58               59               */
       X0213(0xfa5c),   X0213(0x4453),   X0213(0x445b),   X0213(0x8260),
    /* 60               61               62               63               */
       X0213(0x8274),   X0213NB(0xd85a), X0213(0x828e),   X0213(0x82a1),
    /* 64               65               66               67               */
       X0213(0x82a3),   X0213(0x82a4),   X0213(0x82a9),   X0213(0x82ae),
    /* 68               69               70               71               */
       X0213(0x82b7),   X0213(0x82be),   X0213(0x82bf),   X0213(0x82c6),
    /* 72               73               74               75               */
       X0213(0x82d5),   X0213(0x82fd),   X0213(0x82fe),   X0213(0x8300),
    /* 76               77               78               79               */
       X0213(0x8301),   X0213(0x8362),   X0213(0x8322),   X0213(0x832d),
    /* 80               81               82               83               */
       X0213(0x833a),   X0213(0x8343),   X0213(0x8347),   X0213(0x8351),
    /* 84               85               86               87               */
       X0213(0x8355),   X0213(0x837d),   X0213(0x8386),   X0213(0x8392),
    /* 88               89               90               91               */
       X0213(0x8398),   X0213(0x83a7),   X0213(0x83a9),   X0213(0x83bf),
    /* 92               93               94                                */
       X0213(0x83c0),   X0213(0x83c7),   X0213(0x83cf),
/* JIS X 0208 (/ 0213 plane 1) row 91 */
    /*                   1                2                3               */
                        X0213(0x83d1),   X0213(0x83e1),   X0213(0x83ea),
    /*  4                5                6                7               */
       X0213(0x8401),   X0213(0x8406),   X0213(0x840a),   X0213(0xfa5f),
    /*  8                9               10               11               */
       X0213(0x8448),   X0213(0x845f),   X0213(0x8470),   X0213(0x8473),
    /* 12               13               14               15               */
       X0213(0x8485),   X0213(0x849e),   X0213(0x84af),   X0213(0x84b4),
    /* 16               17               18               19               */
       X0213(0x84ba),   X0213(0x84c0),   X0213(0x84c2),   X0213NB(0xd85b),
    /* 20               21               22               23               */
       X0213(0x8532),   X0213(0x851e),   X0213(0x8523),   X0213(0x852f),
    /* 24               25               26               27               */
       X0213(0x8559),   X0213(0x8564),   X0213(0xfa1f),   X0213(0x85ad),
    /* 28               29               30               31               */
       X0213(0x857a),   X0213(0x858c),   X0213(0x858f),   X0213(0x85a2),
    /* 32               33               34               35               */
       X0213(0x85b0),   X0213(0x85cb),   X0213(0x85ce),   X0213(0x85ed),
    /* 36               37               38               39               */
       X0213(0x8612),   X0213(0x85ff),   X0213(0x8604),   X0213(0x8605),
    /* 40               41               42               43               */
       X0213(0x8610),   X0213NB(0xd85c), X0213(0x8618),   X0213(0x8629),
    /* 44               45               46               47               */
       X0213(0x8638),   X0213(0x8657),   X0213(0x865b),   X0213(0xf936),
    /* 48               49               50               51               */
       X0213(0x8662),   X0213(0x459d),   X0213(0x866c),   X0213(0x8675),
    /* 52               53               54               55               */
       X0213(0x8698),   X0213(0x86b8),   X0213(0x86fa),   X0213(0x86fc),
    /* 56               57               58               59               */
       X0213(0x86fd),   X0213(0x870b),   X0213(0x8771),   X0213(0x8787),
    /* 60               61               62               63               */
       X0213(0x8788),   X0213(0x87ac),   X0213(0x87ad),   X0213(0x87b5),
    /* 64               65               66               67               */
       X0213(0x45ea),   X0213(0x87d6),   X0213(0x87ec),   X0213(0x8806),
    /* 68               69               70               71               */
       X0213(0x880a),   X0213(0x8810),   X0213(0x8814),   X0213(0x881f),
    /* 72               73               74               75               */
       X0213(0x8898),   X0213(0x88aa),   X0213(0x88ca),   X0213(0x88ce),
    /* 76               77               78               79               */
       X0213NB(0xd85d), X0213(0x88f5),   X0213(0x891c),   X0213(0xfa60),
    /* 80               81               82               83               */
       X0213(0x8918),   X0213(0x8919),   X0213(0x891a),   X0213(0x8927),
    /* 84               85               86               87               */
       X0213(0x8930),   X0213(0x8932),   X0213(0x8939),   X0213(0x8940),
    /* 88               89               90               91               */
       X0213(0x8994),   X0213(0xfa61),   X0213(0x89d4),   X0213(0x89e5),
    /* 92               93               94                                */
       X0213(0x89f6),   X0213(0x8a12),   X0213(0x8a15),
/* JIS X 0208 (/ 0213 plane 1) row 92 */
    /*                   1                2                3               */
                        X0213(0x8a22),   X0213(0x8a37),   X0213(0x8a47),
    /*  4                5                6                7               */
       X0213(0x8a4e),   X0213(0x8a5d),   X0213(0x8a61),   X0213(0x8a75),
    /*  8                9               10               11               */
       X0213(0x8a79),   X0213(0x8aa7),   X0213(0x8ad0),   X0213(0x8adf),
    /* 12               13               14               15               */
       X0213(0x8af4),   X0213(0x8af6),   X0213(0xfa22),   X0213(0xfa62),
    /* 16               17               18               19               */
       X0213(0xfa63),   X0213(0x8b46),   X0213(0x8b54),   X0213(0x8b59),
    /* 20               21               22               23               */
       X0213(0x8b69),   X0213(0x8b9d),   X0213(0x8c49),   X0213(0x8c68),
    /* 24               25               26               27               */
       X0213(0xfa64),   X0213(0x8ce1),   X0213(0x8cf4),   X0213(0x8cf8),
    /* 28               29               30               31               */
       X0213(0x8cfe),   X0213(0xfa65),   X0213(0x8d12),   X0213(0x8d1b),
    /* 32               33               34               35               */
       X0213(0x8daf),   X0213(0x8dce),   X0213(0x8dd1),   X0213(0x8dd7),
    /* 36               37               38               39               */
       X0213(0x8e20),   X0213(0x8e23),   X0213(0x8e3d),   X0213(0x8e70),
    /* 40               41               42               43               */
       X0213(0x8e7b),   X0213NB(0xd860), X0213(0x8ec0),   X0213(0x4844),
    /* 44               45               46               47               */
       X0213(0x8efa),   X0213(0x8f1e),   X0213(0x8f2d),   X0213(0x8f36),
    /* 48               49               50               51               */
       X0213(0x8f54),   X0213NB(0xd860), X0213(0x8fa6),   X0213(0x8fb5),
    /* 52               53               54               55               */
       X0213(0x8fe4),   X0213(0x8fe8),   X0213(0x8fee),   X0213(0x9008),
    /* 56               57               58               59               */
       X0213(0x902d),   X0213(0xfa67),   X0213(0x9088),   X0213(0x9095),
    /* 60               61               62               63               */
       X0213(0x9097),   X0213(0x9099),   X0213(0x909b),   X0213(0x90a2),
    /* 64               65               66               67               */
       X0213(0x90b3),   X0213(0x90be),   X0213(0x90c4),   X0213(0x90c5),
    /* 68               69               70               71               */
       X0213(0x90c7),   X0213(0x90d7),   X0213(0x90dd),   X0213(0x90de),
    /* 72               73               74               75               */
       X0213(0x90ef),   X0213(0x90f4),   X0213(0xfa26),   X0213(0x9114),
    /* 76               77               78               79               */
       X0213(0x9115),   X0213(0x9116),   X0213(0x9122),   X0213(0x9123),
    /* 80               81               82               83               */
       X0213(0x9127),   X0213(0x912f),   X0213(0x9131),   X0213(0x9134),
    /* 84               85               86               87               */
       X0213(0x913d),   X0213(0x9148),   X0213(0x915b),   X0213(0x9183),
    /* 88               89               90               91               */
       X0213(0x919e),   X0213(0x91ac),   X0213(0x91b1),   X0213(0x91bc),
    /* 92               93               94                                */
       X0213(0x91d7),   X0213(0x91fb),   X0213(0x91e4),
/* JIS X 0208 (/ 0213 plane 1) row 93 */
    /*                   1                2                3               */
                        X0213(0x91e5),   X0213(0x91ed),   X0213(0x91f1),
    /*  4                5                6                7               */
       X0213(0x9207),   X0213(0x9210),   X0213(0x9238),   X0213(0x9239),
    /*  8                9               10               11               */
       X0213(0x923a),   X0213(0x923c),   X0213(0x9240),   X0213(0x9243),
    /* 12               13               14               15               */
       X0213(0x924f),   X0213(0x9278),   X0213(0x9288),   X0213(0x92c2),
    /* 16               17               18               19               */
       X0213(0x92cb),   X0213(0x92cc),   X0213(0x92d3),   X0213(0x92e0),
    /* 20               21               22               23               */
       X0213(0x92ff),   X0213(0x9304),   X0213(0x931f),   X0213(0x9321),
    /* 24               25               26               27               */
       X0213(0x9325),   X0213(0x9348),   X0213(0x9349),   X0213(0x934a),
    /* 28               29               30               31               */
       X0213(0x9364),   X0213(0x9365),   X0213(0x936a),   X0213(0x9370),
    /* 32               33               34               35               */
       X0213(0x939b),   X0213(0x93a3),   X0213(0x93ba),   X0213(0x93c6),
    /* 36               37               38               39               */
       X0213(0x93de),   X0213(0x93df),   X0213(0x9404),   X0213(0x93fd),
    /* 40               41               42               43               */
       X0213(0x9433),   X0213(0x944a),   X0213(0x9463),   X0213(0x946b),
    /* 44               45               46               47               */
       X0213(0x9471),   X0213(0x9472),   X0213(0x958e),   X0213(0x959f),
    /* 48               49               50               51               */
       X0213(0x95a6),   X0213(0x95a9),   X0213(0x95ac),   X0213(0x95b6),
    /* 52               53               54               55               */
       X0213(0x95bd),   X0213(0x95cb),   X0213(0x95d0),   X0213(0x95d3),
    /* 56               57               58               59               */
       X0213(0x49b0),   X0213(0x95da),   X0213(0x95de),   X0213(0x9658),
    /* 60               61               62               63               */
       X0213(0x9684),   X0213(0xf9dc),   X0213(0x969d),   X0213(0x96a4),
    /* 64               65               66               67               */
       X0213(0x96a5),   X0213(0x96d2),   X0213(0x96de),   X0213(0xfa68),
    /* 68               69               70               71               */
       X0213(0x96e9),   X0213(0x96ef),   X0213(0x9733),   X0213(0x973b),
    /* 72               73               74               75               */
       X0213(0x974d),   X0213(0x974e),   X0213(0x974f),   X0213(0x975a),
    /* 76               77               78               79               */
       X0213(0x976e),   X0213(0x9773),   X0213(0x9795),   X0213(0x97ae),
    /* 80               81               82               83               */
       X0213(0x97ba),   X0213(0x97c1),   X0213(0x97c9),   X0213(0x97de),
    /* 84               85               86               87               */
       X0213(0x97db),   X0213(0x97f4),   X0213(0xfa69),   X0213(0x980a),
    /* 88               89               90               91               */
       X0213(0x981e),   X0213(0x982b),   X0213(0x9830),   X0213(0xfa6a),
    /* 92               93               94                                */
       X0213(0x9852),   X0213(0x9853),   X0213(0x9856),
/* JIS X 0208 (/ 0213 plane 1) row 94 */
    /*                   1                2                3               */
                        X0213(0x9857),   X0213(0x9859),   X0213(0x985a),
    /*  4                5                6                7               */
       X0213(0xf9d0),   X0213(0x9865),   X0213(0x986c),   X0213(0x98ba),
    /*  8                9               10               11               */
       X0213(0x98c8),   X0213(0x98e7),   X0213(0x9958),   X0213(0x999e),
    /* 12               13               14               15               */
       X0213(0x9a02),   X0213(0x9a03),   X0213(0x9a24),   X0213(0x9a2d),
    /* 16               17               18               19               */
       X0213(0x9a2e),   X0213(0x9a38),   X0213(0x9a4a),   X0213(0x9a4e),
    /* 20               21               22               23               */
       X0213(0x9a52),   X0213(0x9ab6),   X0213(0x9ac1),   X0213(0x9ac3),
    /* 24               25               26               27               */
       X0213(0x9ace),   X0213(0x9ad6),   X0213(0x9af9),   X0213(0x9b02),
    /* 28               29               30               31               */
       X0213(0x9b08),   X0213(0x9b20),   X0213(0x4c17),   X0213(0x9b2d),
    /* 32               33               34               35               */
       X0213(0x9b5e),   X0213(0x9b79),   X0213(0x9b66),   X0213(0x9b72),
    /* 36               37               38               39               */
       X0213(0x9b75),   X0213(0x9b84),   X0213(0x9b8a),   X0213(0x9b8f),
    /* 40               41               42               43               */
       X0213(0x9b9e),   X0213(0x9ba7),   X0213(0x9bc1),   X0213(0x9bce),
    /* 44               45               46               47               */
       X0213(0x9be5),   X0213(0x9bf8),   X0213(0x9bfd),   X0213(0x9c00),
    /* 48               49               50               51               */
       X0213(0x9c23),   X0213(0x9c41),   X0213(0x9c4f),   X0213(0x9c50),
    /* 52               53               54               55               */
       X0213(0x9c53),   X0213(0x9c63),   X0213(0x9c65),   X0213(0x9c77),
    /* 56               57               58               59               */
       X0213(0x9d1d),   X0213(0x9d1e),   X0213(0x9d43),   X0213(0x9d47),
    /* 60               61               62               63               */
       X0213(0x9d52),   X0213(0x9d63),   X0213(0x9d70),   X0213(0x9d7c),
    /* 64               65               66               67               */
       X0213(0x9d8a),   X0213(0x9d96),   X0213(0x9dc0),   X0213(0x9dac),
    /* 68               69               70               71               */
       X0213(0x9dbc),   X0213(0x9dd7),   X0213NB(0xd868), X0213(0x9de7),
    /* 72               73               74               75               */
       X0213(0x9e07),   X0213(0x9e15),   X0213(0x9e7c),   X0213(0x9e9e),
    /* 76               77               78               79               */
       X0213(0x9ea4),   X0213(0x9eac),   X0213(0x9eaf),   X0213(0x9eb4),
    /* 80               81               82               83               */
       X0213(0x9eb5),   X0213(0x9ec3),   X0213(0x9ed1),   X0213(0x9f10),
    /* 84               85               86               87               */
       X0213(0x9f39),   X0213(0x9f57),   X0213(0x9f90),   X0213(0x9f94),
    /* 88               89               90               91               */
       X0213(0x9f97),   X0213(0x9fa2),   X0213(0x59f8),   X0213(0x5c5b),
    /* 92               93               94                                */
       X0213(0x5e77),   X0213(0x7626),   X0213(0x7e6b),
#else	/* !defined(JFP_J2U_ICONV_X0213) */
/* JIS X 0208 row 85 */
    /*                   1                2                3               */
                        UDC(0xe000),     UDC(0xe001),     UDC(0xe002),
    /*  4                5                6                7               */
       UDC(0xe003),     UDC(0xe004),     UDC(0xe005),     UDC(0xe006),
    /*  8                9               10               11               */
       UDC(0xe007),     UDC(0xe008),     UDC(0xe009),     UDC(0xe00a),
    /* 12               13               14               15               */
       UDC(0xe00b),     UDC(0xe00c),     UDC(0xe00d),     UDC(0xe00e),
    /* 16               17               18               19               */
       UDC(0xe00f),     UDC(0xe010),     UDC(0xe011),     UDC(0xe012),
    /* 20               21               22               23               */
       UDC(0xe013),     UDC(0xe014),     UDC(0xe015),     UDC(0xe016),
    /* 24               25               26               27               */
       UDC(0xe017),     UDC(0xe018),     UDC(0xe019),     UDC(0xe01a),
    /* 28               29               30               31               */
       UDC(0xe01b),     UDC(0xe01c),     UDC(0xe01d),     UDC(0xe01e),
    /* 32               33               34               35               */
       UDC(0xe01f),     UDC(0xe020),     UDC(0xe021),     UDC(0xe022),
    /* 36               37               38               39               */
       UDC(0xe023),     UDC(0xe024),     UDC(0xe025),     UDC(0xe026),
    /* 40               41               42               43               */
       UDC(0xe027),     UDC(0xe028),     UDC(0xe029),     UDC(0xe02a),
    /* 44               45               46               47               */
       UDC(0xe02b),     UDC(0xe02c),     UDC(0xe02d),     UDC(0xe02e),
    /* 48               49               50               51               */
       UDC(0xe02f),     UDC(0xe030),     UDC(0xe031),     UDC(0xe032),
    /* 52               53               54               55               */
       UDC(0xe033),     UDC(0xe034),     UDC(0xe035),     UDC(0xe036),
    /* 56               57               58               59               */
       UDC(0xe037),     UDC(0xe038),     UDC(0xe039),     UDC(0xe03a),
    /* 60               61               62               63               */
       UDC(0xe03b),     UDC(0xe03c),     UDC(0xe03d),     UDC(0xe03e),
    /* 64               65               66               67               */
       UDC(0xe03f),     UDC(0xe040),     UDC(0xe041),     UDC(0xe042),
    /* 68               69               70               71               */
       UDC(0xe043),     UDC(0xe044),     UDC(0xe045),     UDC(0xe046),
    /* 72               73               74               75               */
       UDC(0xe047),     UDC(0xe048),     UDC(0xe049),     UDC(0xe04a),
    /* 76               77               78               79               */
       UDC(0xe04b),     UDC(0xe04c),     UDC(0xe04d),     UDC(0xe04e),
    /* 80               81               82               83               */
       UDC(0xe04f),     UDC(0xe050),     UDC(0xe051),     UDC(0xe052),
    /* 84               85               86               87               */
       UDC(0xe053),     UDC(0xe054),     UDC(0xe055),     UDC(0xe056),
    /* 88               89               90               91               */
       UDC(0xe057),     UDC(0xe058),     UDC(0xe059),     UDC(0xe05a),
    /* 92               93               94                                */
       UDC(0xe05b),     UDC(0xe05c),     UDC(0xe05d),
/* JIS X 0208 row 86 */
    /*                   1                2                3               */
                        UDC(0xe05e),     UDC(0xe05f),     UDC(0xe060),
    /*  4                5                6                7               */
       UDC(0xe061),     UDC(0xe062),     UDC(0xe063),     UDC(0xe064),
    /*  8                9               10               11               */
       UDC(0xe065),     UDC(0xe066),     UDC(0xe067),     UDC(0xe068),
    /* 12               13               14               15               */
       UDC(0xe069),     UDC(0xe06a),     UDC(0xe06b),     UDC(0xe06c),
    /* 16               17               18               19               */
       UDC(0xe06d),     UDC(0xe06e),     UDC(0xe06f),     UDC(0xe070),
    /* 20               21               22               23               */
       UDC(0xe071),     UDC(0xe072),     UDC(0xe073),     UDC(0xe074),
    /* 24               25               26               27               */
       UDC(0xe075),     UDC(0xe076),     UDC(0xe077),     UDC(0xe078),
    /* 28               29               30               31               */
       UDC(0xe079),     UDC(0xe07a),     UDC(0xe07b),     UDC(0xe07c),
    /* 32               33               34               35               */
       UDC(0xe07d),     UDC(0xe07e),     UDC(0xe07f),     UDC(0xe080),
    /* 36               37               38               39               */
       UDC(0xe081),     UDC(0xe082),     UDC(0xe083),     UDC(0xe084),
    /* 40               41               42               43               */
       UDC(0xe085),     UDC(0xe086),     UDC(0xe087),     UDC(0xe088),
    /* 44               45               46               47               */
       UDC(0xe089),     UDC(0xe08a),     UDC(0xe08b),     UDC(0xe08c),
    /* 48               49               50               51               */
       UDC(0xe08d),     UDC(0xe08e),     UDC(0xe08f),     UDC(0xe090),
    /* 52               53               54               55               */
       UDC(0xe091),     UDC(0xe092),     UDC(0xe093),     UDC(0xe094),
    /* 56               57               58               59               */
       UDC(0xe095),     UDC(0xe096),     UDC(0xe097),     UDC(0xe098),
    /* 60               61               62               63               */
       UDC(0xe099),     UDC(0xe09a),     UDC(0xe09b),     UDC(0xe09c),
    /* 64               65               66               67               */
       UDC(0xe09d),     UDC(0xe09e),     UDC(0xe09f),     UDC(0xe0a0),
    /* 68               69               70               71               */
       UDC(0xe0a1),     UDC(0xe0a2),     UDC(0xe0a3),     UDC(0xe0a4),
    /* 72               73               74               75               */
       UDC(0xe0a5),     UDC(0xe0a6),     UDC(0xe0a7),     UDC(0xe0a8),
    /* 76               77               78               79               */
       UDC(0xe0a9),     UDC(0xe0aa),     UDC(0xe0ab),     UDC(0xe0ac),
    /* 80               81               82               83               */
       UDC(0xe0ad),     UDC(0xe0ae),     UDC(0xe0af),     UDC(0xe0b0),
    /* 84               85               86               87               */
       UDC(0xe0b1),     UDC(0xe0b2),     UDC(0xe0b3),     UDC(0xe0b4),
    /* 88               89               90               91               */
       UDC(0xe0b5),     UDC(0xe0b6),     UDC(0xe0b7),     UDC(0xe0b8),
    /* 92               93               94                                */
       UDC(0xe0b9),     UDC(0xe0ba),     UDC(0xe0bb),
/* JIS X 0208 row 87 */
    /*                   1                2                3               */
                        UDC(0xe0bc),     UDC(0xe0bd),     UDC(0xe0be),
    /*  4                5                6                7               */
       UDC(0xe0bf),     UDC(0xe0c0),     UDC(0xe0c1),     UDC(0xe0c2),
    /*  8                9               10               11               */
       UDC(0xe0c3),     UDC(0xe0c4),     UDC(0xe0c5),     UDC(0xe0c6),
    /* 12               13               14               15               */
       UDC(0xe0c7),     UDC(0xe0c8),     UDC(0xe0c9),     UDC(0xe0ca),
    /* 16               17               18               19               */
       UDC(0xe0cb),     UDC(0xe0cc),     UDC(0xe0cd),     UDC(0xe0ce),
    /* 20               21               22               23               */
       UDC(0xe0cf),     UDC(0xe0d0),     UDC(0xe0d1),     UDC(0xe0d2),
    /* 24               25               26               27               */
       UDC(0xe0d3),     UDC(0xe0d4),     UDC(0xe0d5),     UDC(0xe0d6),
    /* 28               29               30               31               */
       UDC(0xe0d7),     UDC(0xe0d8),     UDC(0xe0d9),     UDC(0xe0da),
    /* 32               33               34               35               */
       UDC(0xe0db),     UDC(0xe0dc),     UDC(0xe0dd),     UDC(0xe0de),
    /* 36               37               38               39               */
       UDC(0xe0df),     UDC(0xe0e0),     UDC(0xe0e1),     UDC(0xe0e2),
    /* 40               41               42               43               */
       UDC(0xe0e3),     UDC(0xe0e4),     UDC(0xe0e5),     UDC(0xe0e6),
    /* 44               45               46               47               */
       UDC(0xe0e7),     UDC(0xe0e8),     UDC(0xe0e9),     UDC(0xe0ea),
    /* 48               49               50               51               */
       UDC(0xe0eb),     UDC(0xe0ec),     UDC(0xe0ed),     UDC(0xe0ee),
    /* 52               53               54               55               */
       UDC(0xe0ef),     UDC(0xe0f0),     UDC(0xe0f1),     UDC(0xe0f2),
    /* 56               57               58               59               */
       UDC(0xe0f3),     UDC(0xe0f4),     UDC(0xe0f5),     UDC(0xe0f6),
    /* 60               61               62               63               */
       UDC(0xe0f7),     UDC(0xe0f8),     UDC(0xe0f9),     UDC(0xe0fa),
    /* 64               65               66               67               */
       UDC(0xe0fb),     UDC(0xe0fc),     UDC(0xe0fd),     UDC(0xe0fe),
    /* 68               69               70               71               */
       UDC(0xe0ff),     UDC(0xe100),     UDC(0xe101),     UDC(0xe102),
    /* 72               73               74               75               */
       UDC(0xe103),     UDC(0xe104),     UDC(0xe105),     UDC(0xe106),
    /* 76               77               78               79               */
       UDC(0xe107),     UDC(0xe108),     UDC(0xe109),     UDC(0xe10a),
    /* 80               81               82               83               */
       UDC(0xe10b),     UDC(0xe10c),     UDC(0xe10d),     UDC(0xe10e),
    /* 84               85               86               87               */
       UDC(0xe10f),     UDC(0xe110),     UDC(0xe111),     UDC(0xe112),
    /* 88               89               90               91               */
       UDC(0xe113),     UDC(0xe114),     UDC(0xe115),     UDC(0xe116),
    /* 92               93               94                                */
       UDC(0xe117),     UDC(0xe118),     UDC(0xe119),
/* JIS X 0208 row 88 */
    /*                   1                2                3               */
                        UDC(0xe11a),     UDC(0xe11b),     UDC(0xe11c),
    /*  4                5                6                7               */
       UDC(0xe11d),     UDC(0xe11e),     UDC(0xe11f),     UDC(0xe120),
    /*  8                9               10               11               */
       UDC(0xe121),     UDC(0xe122),     UDC(0xe123),     UDC(0xe124),
    /* 12               13               14               15               */
       UDC(0xe125),     UDC(0xe126),     UDC(0xe127),     UDC(0xe128),
    /* 16               17               18               19               */
       UDC(0xe129),     UDC(0xe12a),     UDC(0xe12b),     UDC(0xe12c),
    /* 20               21               22               23               */
       UDC(0xe12d),     UDC(0xe12e),     UDC(0xe12f),     UDC(0xe130),
    /* 24               25               26               27               */
       UDC(0xe131),     UDC(0xe132),     UDC(0xe133),     UDC(0xe134),
    /* 28               29               30               31               */
       UDC(0xe135),     UDC(0xe136),     UDC(0xe137),     UDC(0xe138),
    /* 32               33               34               35               */
       UDC(0xe139),     UDC(0xe13a),     UDC(0xe13b),     UDC(0xe13c),
    /* 36               37               38               39               */
       UDC(0xe13d),     UDC(0xe13e),     UDC(0xe13f),     UDC(0xe140),
    /* 40               41               42               43               */
       UDC(0xe141),     UDC(0xe142),     UDC(0xe143),     UDC(0xe144),
    /* 44               45               46               47               */
       UDC(0xe145),     UDC(0xe146),     UDC(0xe147),     UDC(0xe148),
    /* 48               49               50               51               */
       UDC(0xe149),     UDC(0xe14a),     UDC(0xe14b),     UDC(0xe14c),
    /* 52               53               54               55               */
       UDC(0xe14d),     UDC(0xe14e),     UDC(0xe14f),     UDC(0xe150),
    /* 56               57               58               59               */
       UDC(0xe151),     UDC(0xe152),     UDC(0xe153),     UDC(0xe154),
    /* 60               61               62               63               */
       UDC(0xe155),     UDC(0xe156),     UDC(0xe157),     UDC(0xe158),
    /* 64               65               66               67               */
       UDC(0xe159),     UDC(0xe15a),     UDC(0xe15b),     UDC(0xe15c),
    /* 68               69               70               71               */
       UDC(0xe15d),     UDC(0xe15e),     UDC(0xe15f),     UDC(0xe160),
    /* 72               73               74               75               */
       UDC(0xe161),     UDC(0xe162),     UDC(0xe163),     UDC(0xe164),
    /* 76               77               78               79               */
       UDC(0xe165),     UDC(0xe166),     UDC(0xe167),     UDC(0xe168),
    /* 80               81               82               83               */
       UDC(0xe169),     UDC(0xe16a),     UDC(0xe16b),     UDC(0xe16c),
    /* 84               85               86               87               */
       UDC(0xe16d),     UDC(0xe16e),     UDC(0xe16f),     UDC(0xe170),
    /* 88               89               90               91               */
       UDC(0xe171),     UDC(0xe172),     UDC(0xe173),     UDC(0xe174),
    /* 92               93               94                                */
       UDC(0xe175),     UDC(0xe176),     UDC(0xe177),
/* JIS X 0208 row 89 */
    /*                   1                2                3               */
                        UDC(0xe178),     UDC(0xe179),     UDC(0xe17a),
    /*  4                5                6                7               */
       UDC(0xe17b),     UDC(0xe17c),     UDC(0xe17d),     UDC(0xe17e),
    /*  8                9               10               11               */
       UDC(0xe17f),     UDC(0xe180),     UDC(0xe181),     UDC(0xe182),
    /* 12               13               14               15               */
       UDC(0xe183),     UDC(0xe184),     UDC(0xe185),     UDC(0xe186),
    /* 16               17               18               19               */
       UDC(0xe187),     UDC(0xe188),     UDC(0xe189),     UDC(0xe18a),
    /* 20               21               22               23               */
       UDC(0xe18b),     UDC(0xe18c),     UDC(0xe18d),     UDC(0xe18e),
    /* 24               25               26               27               */
       UDC(0xe18f),     UDC(0xe190),     UDC(0xe191),     UDC(0xe192),
    /* 28               29               30               31               */
       UDC(0xe193),     UDC(0xe194),     UDC(0xe195),     UDC(0xe196),
    /* 32               33               34               35               */
       UDC(0xe197),     UDC(0xe198),     UDC(0xe199),     UDC(0xe19a),
    /* 36               37               38               39               */
       UDC(0xe19b),     UDC(0xe19c),     UDC(0xe19d),     UDC(0xe19e),
    /* 40               41               42               43               */
       UDC(0xe19f),     UDC(0xe1a0),     UDC(0xe1a1),     UDC(0xe1a2),
    /* 44               45               46               47               */
       UDC(0xe1a3),     UDC(0xe1a4),     UDC(0xe1a5),     UDC(0xe1a6),
    /* 48               49               50               51               */
       UDC(0xe1a7),     UDC(0xe1a8),     UDC(0xe1a9),     UDC(0xe1aa),
    /* 52               53               54               55               */
       UDC(0xe1ab),     UDC(0xe1ac),     UDC(0xe1ad),     UDC(0xe1ae),
    /* 56               57               58               59               */
       UDC(0xe1af),     UDC(0xe1b0),     UDC(0xe1b1),     UDC(0xe1b2),
    /* 60               61               62               63               */
       UDC(0xe1b3),     UDC(0xe1b4),     UDC(0xe1b5),     UDC(0xe1b6),
    /* 64               65               66               67               */
       UDC(0xe1b7),     UDC(0xe1b8),     UDC(0xe1b9),     UDC(0xe1ba),
    /* 68               69               70               71               */
       UDC(0xe1bb),     UDC(0xe1bc),     UDC(0xe1bd),     UDC(0xe1be),
    /* 72               73               74               75               */
       UDC(0xe1bf),     UDC(0xe1c0),     UDC(0xe1c1),     UDC(0xe1c2),
    /* 76               77               78               79               */
       UDC(0xe1c3),     UDC(0xe1c4),     UDC(0xe1c5),     UDC(0xe1c6),
    /* 80               81               82               83               */
       UDC(0xe1c7),     UDC(0xe1c8),     UDC(0xe1c9),     UDC(0xe1ca),
    /* 84               85               86               87               */
       UDC(0xe1cb),     UDC(0xe1cc),     UDC(0xe1cd),     UDC(0xe1ce),
    /* 88               89               90               91               */
       UDC(0xe1cf),     UDC(0xe1d0),     UDC(0xe1d1),     UDC(0xe1d2),
    /* 92               93               94                                */
       UDC(0xe1d3),     UDC(0xe1d4),     UDC(0xe1d5),
/* JIS X 0208 row 90 */
    /*                   1                2                3               */
                        UDC(0xe1d6),     UDC(0xe1d7),     UDC(0xe1d8),
    /*  4                5                6                7               */
       UDC(0xe1d9),     UDC(0xe1da),     UDC(0xe1db),     UDC(0xe1dc),
    /*  8                9               10               11               */
       UDC(0xe1dd),     UDC(0xe1de),     UDC(0xe1df),     UDC(0xe1e0),
    /* 12               13               14               15               */
       UDC(0xe1e1),     UDC(0xe1e2),     UDC(0xe1e3),     UDC(0xe1e4),
    /* 16               17               18               19               */
       UDC(0xe1e5),     UDC(0xe1e6),     UDC(0xe1e7),     UDC(0xe1e8),
    /* 20               21               22               23               */
       UDC(0xe1e9),     UDC(0xe1ea),     UDC(0xe1eb),     UDC(0xe1ec),
    /* 24               25               26               27               */
       UDC(0xe1ed),     UDC(0xe1ee),     UDC(0xe1ef),     UDC(0xe1f0),
    /* 28               29               30               31               */
       UDC(0xe1f1),     UDC(0xe1f2),     UDC(0xe1f3),     UDC(0xe1f4),
    /* 32               33               34               35               */
       UDC(0xe1f5),     UDC(0xe1f6),     UDC(0xe1f7),     UDC(0xe1f8),
    /* 36               37               38               39               */
       UDC(0xe1f9),     UDC(0xe1fa),     UDC(0xe1fb),     UDC(0xe1fc),
    /* 40               41               42               43               */
       UDC(0xe1fd),     UDC(0xe1fe),     UDC(0xe1ff),     UDC(0xe200),
    /* 44               45               46               47               */
       UDC(0xe201),     UDC(0xe202),     UDC(0xe203),     UDC(0xe204),
    /* 48               49               50               51               */
       UDC(0xe205),     UDC(0xe206),     UDC(0xe207),     UDC(0xe208),
    /* 52               53               54               55               */
       UDC(0xe209),     UDC(0xe20a),     UDC(0xe20b),     UDC(0xe20c),
    /* 56               57               58               59               */
       UDC(0xe20d),     UDC(0xe20e),     UDC(0xe20f),     UDC(0xe210),
    /* 60               61               62               63               */
       UDC(0xe211),     UDC(0xe212),     UDC(0xe213),     UDC(0xe214),
    /* 64               65               66               67               */
       UDC(0xe215),     UDC(0xe216),     UDC(0xe217),     UDC(0xe218),
    /* 68               69               70               71               */
       UDC(0xe219),     UDC(0xe21a),     UDC(0xe21b),     UDC(0xe21c),
    /* 72               73               74               75               */
       UDC(0xe21d),     UDC(0xe21e),     UDC(0xe21f),     UDC(0xe220),
    /* 76               77               78               79               */
       UDC(0xe221),     UDC(0xe222),     UDC(0xe223),     UDC(0xe224),
    /* 80               81               82               83               */
       UDC(0xe225),     UDC(0xe226),     UDC(0xe227),     UDC(0xe228),
    /* 84               85               86               87               */
       UDC(0xe229),     UDC(0xe22a),     UDC(0xe22b),     UDC(0xe22c),
    /* 88               89               90               91               */
       UDC(0xe22d),     UDC(0xe22e),     UDC(0xe22f),     UDC(0xe230),
    /* 92               93               94                                */
       UDC(0xe231),     UDC(0xe232),     UDC(0xe233),
/* JIS X 0208 row 91 */
    /*                   1                2                3               */
                        UDC(0xe234),     UDC(0xe235),     UDC(0xe236),
    /*  4                5                6                7               */
       UDC(0xe237),     UDC(0xe238),     UDC(0xe239),     UDC(0xe23a),
    /*  8                9               10               11               */
       UDC(0xe23b),     UDC(0xe23c),     UDC(0xe23d),     UDC(0xe23e),
    /* 12               13               14               15               */
       UDC(0xe23f),     UDC(0xe240),     UDC(0xe241),     UDC(0xe242),
    /* 16               17               18               19               */
       UDC(0xe243),     UDC(0xe244),     UDC(0xe245),     UDC(0xe246),
    /* 20               21               22               23               */
       UDC(0xe247),     UDC(0xe248),     UDC(0xe249),     UDC(0xe24a),
    /* 24               25               26               27               */
       UDC(0xe24b),     UDC(0xe24c),     UDC(0xe24d),     UDC(0xe24e),
    /* 28               29               30               31               */
       UDC(0xe24f),     UDC(0xe250),     UDC(0xe251),     UDC(0xe252),
    /* 32               33               34               35               */
       UDC(0xe253),     UDC(0xe254),     UDC(0xe255),     UDC(0xe256),
    /* 36               37               38               39               */
       UDC(0xe257),     UDC(0xe258),     UDC(0xe259),     UDC(0xe25a),
    /* 40               41               42               43               */
       UDC(0xe25b),     UDC(0xe25c),     UDC(0xe25d),     UDC(0xe25e),
    /* 44               45               46               47               */
       UDC(0xe25f),     UDC(0xe260),     UDC(0xe261),     UDC(0xe262),
    /* 48               49               50               51               */
       UDC(0xe263),     UDC(0xe264),     UDC(0xe265),     UDC(0xe266),
    /* 52               53               54               55               */
       UDC(0xe267),     UDC(0xe268),     UDC(0xe269),     UDC(0xe26a),
    /* 56               57               58               59               */
       UDC(0xe26b),     UDC(0xe26c),     UDC(0xe26d),     UDC(0xe26e),
    /* 60               61               62               63               */
       UDC(0xe26f),     UDC(0xe270),     UDC(0xe271),     UDC(0xe272),
    /* 64               65               66               67               */
       UDC(0xe273),     UDC(0xe274),     UDC(0xe275),     UDC(0xe276),
    /* 68               69               70               71               */
       UDC(0xe277),     UDC(0xe278),     UDC(0xe279),     UDC(0xe27a),
    /* 72               73               74               75               */
       UDC(0xe27b),     UDC(0xe27c),     UDC(0xe27d),     UDC(0xe27e),
    /* 76               77               78               79               */
       UDC(0xe27f),     UDC(0xe280),     UDC(0xe281),     UDC(0xe282),
    /* 80               81               82               83               */
       UDC(0xe283),     UDC(0xe284),     UDC(0xe285),     UDC(0xe286),
    /* 84               85               86               87               */
       UDC(0xe287),     UDC(0xe288),     UDC(0xe289),     UDC(0xe28a),
    /* 88               89               90               91               */
       UDC(0xe28b),     UDC(0xe28c),     UDC(0xe28d),     UDC(0xe28e),
    /* 92               93               94                                */
       UDC(0xe28f),     UDC(0xe290),     UDC(0xe291),
/* JIS X 0208 row 92 */
    /*                   1                2                3               */
                        UDC(0xe292),     UDC(0xe293),     UDC(0xe294),
    /*  4                5                6                7               */
       UDC(0xe295),     UDC(0xe296),     UDC(0xe297),     UDC(0xe298),
    /*  8                9               10               11               */
       UDC(0xe299),     UDC(0xe29a),     UDC(0xe29b),     UDC(0xe29c),
    /* 12               13               14               15               */
       UDC(0xe29d),     UDC(0xe29e),     UDC(0xe29f),     UDC(0xe2a0),
    /* 16               17               18               19               */
       UDC(0xe2a1),     UDC(0xe2a2),     UDC(0xe2a3),     UDC(0xe2a4),
    /* 20               21               22               23               */
       UDC(0xe2a5),     UDC(0xe2a6),     UDC(0xe2a7),     UDC(0xe2a8),
    /* 24               25               26               27               */
       UDC(0xe2a9),     UDC(0xe2aa),     UDC(0xe2ab),     UDC(0xe2ac),
    /* 28               29               30               31               */
       UDC(0xe2ad),     UDC(0xe2ae),     UDC(0xe2af),     UDC(0xe2b0),
    /* 32               33               34               35               */
       UDC(0xe2b1),     UDC(0xe2b2),     UDC(0xe2b3),     UDC(0xe2b4),
    /* 36               37               38               39               */
       UDC(0xe2b5),     UDC(0xe2b6),     UDC(0xe2b7),     UDC(0xe2b8),
    /* 40               41               42               43               */
       UDC(0xe2b9),     UDC(0xe2ba),     UDC(0xe2bb),     UDC(0xe2bc),
    /* 44               45               46               47               */
       UDC(0xe2bd),     UDC(0xe2be),     UDC(0xe2bf),     UDC(0xe2c0),
    /* 48               49               50               51               */
       UDC(0xe2c1),     UDC(0xe2c2),     UDC(0xe2c3),     UDC(0xe2c4),
    /* 52               53               54               55               */
       UDC(0xe2c5),     UDC(0xe2c6),     UDC(0xe2c7),     UDC(0xe2c8),
    /* 56               57               58               59               */
       UDC(0xe2c9),     UDC(0xe2ca),     UDC(0xe2cb),     UDC(0xe2cc),
    /* 60               61               62               63               */
       UDC(0xe2cd),     UDC(0xe2ce),     UDC(0xe2cf),     UDC(0xe2d0),
    /* 64               65               66               67               */
       UDC(0xe2d1),     UDC(0xe2d2),     UDC(0xe2d3),     UDC(0xe2d4),
    /* 68               69               70               71               */
       UDC(0xe2d5),     UDC(0xe2d6),     UDC(0xe2d7),     UDC(0xe2d8),
    /* 72               73               74               75               */
       UDC(0xe2d9),     UDC(0xe2da),     UDC(0xe2db),     UDC(0xe2dc),
    /* 76               77               78               79               */
       UDC(0xe2dd),     UDC(0xe2de),     UDC(0xe2df),     UDC(0xe2e0),
    /* 80               81               82               83               */
       UDC(0xe2e1),     UDC(0xe2e2),     UDC(0xe2e3),     UDC(0xe2e4),
    /* 84               85               86               87               */
       UDC(0xe2e5),     UDC(0xe2e6),     UDC(0xe2e7),     UDC(0xe2e8),
    /* 88               89               90               91               */
       UDC(0xe2e9),     UDC(0xe2ea),     UDC(0xe2eb),     UDC(0xe2ec),
    /* 92               93               94                                */
       UDC(0xe2ed),     UDC(0xe2ee),     UDC(0xe2ef),
/* JIS X 0208 row 93 */
    /*                   1                2                3               */
                        UDC(0xe2f0),     UDC(0xe2f1),     UDC(0xe2f2),
    /*  4                5                6                7               */
       UDC(0xe2f3),     UDC(0xe2f4),     UDC(0xe2f5),     UDC(0xe2f6),
    /*  8                9               10               11               */
       UDC(0xe2f7),     UDC(0xe2f8),     UDC(0xe2f9),     UDC(0xe2fa),
    /* 12               13               14               15               */
       UDC(0xe2fb),     UDC(0xe2fc),     UDC(0xe2fd),     UDC(0xe2fe),
    /* 16               17               18               19               */
       UDC(0xe2ff),     UDC(0xe300),     UDC(0xe301),     UDC(0xe302),
    /* 20               21               22               23               */
       UDC(0xe303),     UDC(0xe304),     UDC(0xe305),     UDC(0xe306),
    /* 24               25               26               27               */
       UDC(0xe307),     UDC(0xe308),     UDC(0xe309),     UDC(0xe30a),
    /* 28               29               30               31               */
       UDC(0xe30b),     UDC(0xe30c),     UDC(0xe30d),     UDC(0xe30e),
    /* 32               33               34               35               */
       UDC(0xe30f),     UDC(0xe310),     UDC(0xe311),     UDC(0xe312),
    /* 36               37               38               39               */
       UDC(0xe313),     UDC(0xe314),     UDC(0xe315),     UDC(0xe316),
    /* 40               41               42               43               */
       UDC(0xe317),     UDC(0xe318),     UDC(0xe319),     UDC(0xe31a),
    /* 44               45               46               47               */
       UDC(0xe31b),     UDC(0xe31c),     UDC(0xe31d),     UDC(0xe31e),
    /* 48               49               50               51               */
       UDC(0xe31f),     UDC(0xe320),     UDC(0xe321),     UDC(0xe322),
    /* 52               53               54               55               */
       UDC(0xe323),     UDC(0xe324),     UDC(0xe325),     UDC(0xe326),
    /* 56               57               58               59               */
       UDC(0xe327),     UDC(0xe328),     UDC(0xe329),     UDC(0xe32a),
    /* 60               61               62               63               */
       UDC(0xe32b),     UDC(0xe32c),     UDC(0xe32d),     UDC(0xe32e),
    /* 64               65               66               67               */
       UDC(0xe32f),     UDC(0xe330),     UDC(0xe331),     UDC(0xe332),
    /* 68               69               70               71               */
       UDC(0xe333),     UDC(0xe334),     UDC(0xe335),     UDC(0xe336),
    /* 72               73               74               75               */
       UDC(0xe337),     UDC(0xe338),     UDC(0xe339),     UDC(0xe33a),
    /* 76               77               78               79               */
       UDC(0xe33b),     UDC(0xe33c),     UDC(0xe33d),     UDC(0xe33e),
    /* 80               81               82               83               */
       UDC(0xe33f),     UDC(0xe340),     UDC(0xe341),     UDC(0xe342),
    /* 84               85               86               87               */
       UDC(0xe343),     UDC(0xe344),     UDC(0xe345),     UDC(0xe346),
    /* 88               89               90               91               */
       UDC(0xe347),     UDC(0xe348),     UDC(0xe349),     UDC(0xe34a),
    /* 92               93               94                                */
       UDC(0xe34b),     UDC(0xe34c),     UDC(0xe34d),
/* JIS X 0208 row 94 */
    /*                   1                2                3               */
                        UDC(0xe34e),     UDC(0xe34f),     UDC(0xe350),
    /*  4                5                6                7               */
       UDC(0xe351),     UDC(0xe352),     UDC(0xe353),     UDC(0xe354),
    /*  8                9               10               11               */
       UDC(0xe355),     UDC(0xe356),     UDC(0xe357),     UDC(0xe358),
    /* 12               13               14               15               */
       UDC(0xe359),     UDC(0xe35a),     UDC(0xe35b),     UDC(0xe35c),
    /* 16               17               18               19               */
       UDC(0xe35d),     UDC(0xe35e),     UDC(0xe35f),     UDC(0xe360),
    /* 20               21               22               23               */
       UDC(0xe361),     UDC(0xe362),     UDC(0xe363),     UDC(0xe364),
    /* 24               25               26               27               */
       UDC(0xe365),     UDC(0xe366),     UDC(0xe367),     UDC(0xe368),
    /* 28               29               30               31               */
       UDC(0xe369),     UDC(0xe36a),     UDC(0xe36b),     UDC(0xe36c),
    /* 32               33               34               35               */
       UDC(0xe36d),     UDC(0xe36e),     UDC(0xe36f),     UDC(0xe370),
    /* 36               37               38               39               */
       UDC(0xe371),     UDC(0xe372),     UDC(0xe373),     UDC(0xe374),
    /* 40               41               42               43               */
       UDC(0xe375),     UDC(0xe376),     UDC(0xe377),     UDC(0xe378),
    /* 44               45               46               47               */
       UDC(0xe379),     UDC(0xe37a),     UDC(0xe37b),     UDC(0xe37c),
    /* 48               49               50               51               */
       UDC(0xe37d),     UDC(0xe37e),     UDC(0xe37f),     UDC(0xe380),
    /* 52               53               54               55               */
       UDC(0xe381),     UDC(0xe382),     UDC(0xe383),     UDC(0xe384),
    /* 56               57               58               59               */
       UDC(0xe385),     UDC(0xe386),     UDC(0xe387),     UDC(0xe388),
    /* 60               61               62               63               */
       UDC(0xe389),     UDC(0xe38a),     UDC(0xe38b),     UDC(0xe38c),
    /* 64               65               66               67               */
       UDC(0xe38d),     UDC(0xe38e),     UDC(0xe38f),     UDC(0xe390),
    /* 68               69               70               71               */
       UDC(0xe391),     UDC(0xe392),     UDC(0xe393),     UDC(0xe394),
    /* 72               73               74               75               */
       UDC(0xe395),     UDC(0xe396),     UDC(0xe397),     UDC(0xe398),
    /* 76               77               78               79               */
       UDC(0xe399),     UDC(0xe39a),     UDC(0xe39b),     UDC(0xe39c),
    /* 80               81               82               83               */
       UDC(0xe39d),     UDC(0xe39e),     UDC(0xe39f),     UDC(0xe3a0),
    /* 84               85               86               87               */
       UDC(0xe3a1),     UDC(0xe3a2),     UDC(0xe3a3),     UDC(0xe3a4),
    /* 88               89               90               91               */
       UDC(0xe3a5),     UDC(0xe3a6),     UDC(0xe3a7),     UDC(0xe3a8),
    /* 92               93               94                                */
       UDC(0xe3a9),     UDC(0xe3aa),     UDC(0xe3ab),
#endif	/* defined(JFP_J2U_ICONV_X0213) */
};

#if	defined(JFP_J2U_ICONV_X0213)
static const _jfp_ucs2_t _jfp_tbl_jisx0213p2_to_ucs2[] = {
/* JIS X 0213 plane 2 row 1 */
    /*                   1                2                3               */
                        X0213NB(0xd840), X0213(0x4e02),   X0213(0x4e0f),
    /*  4                5                6                7               */
       X0213(0x4e12),   X0213(0x4e29),   X0213(0x4e2b),   X0213(0x4e2e),
    /*  8                9               10               11               */
       X0213(0x4e40),   X0213(0x4e47),   X0213(0x4e48),   X0213NB(0xd840),
    /* 12               13               14               15               */
       X0213(0x4e51),   X0213(0x3406),   X0213NB(0xd840), X0213(0x4e5a),
    /* 16               17               18               19               */
       X0213(0x4e69),   X0213(0x4e9d),   X0213(0x342c),   X0213(0x342e),
    /* 20               21               22               23               */
       X0213(0x4eb9),   X0213(0x4ebb),   X0213NB(0xd840), X0213(0x4ebc),
    /* 24               25               26               27               */
       X0213(0x4ec3),   X0213(0x4ec8),   X0213(0x4ed0),   X0213(0x4eeb),
    /* 28               29               30               31               */
       X0213(0x4eda),   X0213(0x4ef1),   X0213(0x4ef5),   X0213(0x4f00),
    /* 32               33               34               35               */
       X0213(0x4f16),   X0213(0x4f64),   X0213(0x4f37),   X0213(0x4f3e),
    /* 36               37               38               39               */
       X0213(0x4f54),   X0213(0x4f58),   X0213NB(0xd840), X0213(0x4f77),
    /* 40               41               42               43               */
       X0213(0x4f78),   X0213(0x4f7a),   X0213(0x4f7d),   X0213(0x4f82),
    /* 44               45               46               47               */
       X0213(0x4f85),   X0213(0x4f92),   X0213(0x4f9a),   X0213(0x4fe6),
    /* 48               49               50               51               */
       X0213(0x4fb2),   X0213(0x4fbe),   X0213(0x4fc5),   X0213(0x4fcb),
    /* 52               53               54               55               */
       X0213(0x4fcf),   X0213(0x4fd2),   X0213(0x346a),   X0213(0x4ff2),
    /* 56               57               58               59               */
       X0213(0x5000),   X0213(0x5010),   X0213(0x5013),   X0213(0x501c),
    /* 60               61               62               63               */
       X0213(0x501e),   X0213(0x5022),   X0213(0x3468),   X0213(0x5042),
    /* 64               65               66               67               */
       X0213(0x5046),   X0213(0x504e),   X0213(0x5053),   X0213(0x5057),
    /* 68               69               70               71               */
       X0213(0x5063),   X0213(0x5066),   X0213(0x506a),   X0213(0x5070),
    /* 72               73               74               75               */
       X0213(0x50a3),   X0213(0x5088),   X0213(0x5092),   X0213(0x5093),
    /* 76               77               78               79               */
       X0213(0x5095),   X0213(0x5096),   X0213(0x509c),   X0213(0x50aa),
    /* 80               81               82               83               */
       X0213NB(0xd840), X0213(0x50b1),   X0213(0x50ba),   X0213(0x50bb),
    /* 84               85               86               87               */
       X0213(0x50c4),   X0213(0x50c7),   X0213(0x50f3),   X0213NB(0xd840),
    /* 88               89               90               91               */
       X0213(0x50ce),   X0213NB(0xd840), X0213(0x50d4),   X0213(0x50d9),
    /* 92               93               94                                */
       X0213(0x50e1),   X0213(0x50e9),   X0213(0x3492),
/* JIS X 0213 plane 2 row 2 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 3 */
    /*                   1                2                3               */
                        X0213(0x5108),   X0213NB(0xd840), X0213(0x5117),
    /*  4                5                6                7               */
       X0213(0x511b),   X0213NB(0xd841), X0213(0x5160),   X0213NB(0xd841),
    /*  8                9               10               11               */
       X0213(0x5173),   X0213(0x5183),   X0213(0x518b),   X0213(0x34bc),
    /* 12               13               14               15               */
       X0213(0x5198),   X0213(0x51a3),   X0213(0x51ad),   X0213(0x34c7),
    /* 16               17               18               19               */
       X0213(0x51bc),   X0213NB(0xd841), X0213NB(0xd841), X0213(0x51f3),
    /* 20               21               22               23               */
       X0213(0x51f4),   X0213(0x5202),   X0213(0x5212),   X0213(0x5216),
    /* 24               25               26               27               */
       X0213NB(0xd841), X0213(0x5255),   X0213(0x525c),   X0213(0x526c),
    /* 28               29               30               31               */
       X0213(0x5277),   X0213(0x5284),   X0213(0x5282),   X0213NB(0xd842),
    /* 32               33               34               35               */
       X0213(0x5298),   X0213NB(0xd842), X0213(0x52a4),   X0213(0x52a6),
    /* 36               37               38               39               */
       X0213(0x52af),   X0213(0x52ba),   X0213(0x52bb),   X0213(0x52ca),
    /* 40               41               42               43               */
       X0213(0x351f),   X0213(0x52d1),   X0213NB(0xd842), X0213(0x52f7),
    /* 44               45               46               47               */
       X0213(0x530a),   X0213(0x530b),   X0213(0x5324),   X0213(0x5335),
    /* 48               49               50               51               */
       X0213(0x533e),   X0213(0x5342),   X0213NB(0xd842), X0213NB(0xd842),
    /* 52               53               54               55               */
       X0213(0x5367),   X0213(0x536c),   X0213(0x537a),   X0213(0x53a4),
    /* 56               57               58               59               */
       X0213(0x53b4),   X0213NB(0xd842), X0213(0x53b7),   X0213(0x53c0),
    /* 60               61               62               63               */
       X0213NB(0xd842), X0213(0x355d),   X0213(0x355e),   X0213(0x53d5),
    /* 64               65               66               67               */
       X0213(0x53da),   X0213(0x3563),   X0213(0x53f4),   X0213(0x53f5),
    /* 68               69               70               71               */
       X0213(0x5455),   X0213(0x5424),   X0213(0x5428),   X0213(0x356e),
    /* 72               73               74               75               */
       X0213(0x5443),   X0213(0x5462),   X0213(0x5466),   X0213(0x546c),
    /* 76               77               78               79               */
       X0213(0x548a),   X0213(0x548d),   X0213(0x5495),   X0213(0x54a0),
    /* 80               81               82               83               */
       X0213(0x54a6),   X0213(0x54ad),   X0213(0x54ae),   X0213(0x54b7),
    /* 84               85               86               87               */
       X0213(0x54ba),   X0213(0x54bf),   X0213(0x54c3),   X0213NB(0xd843),
    /* 88               89               90               91               */
       X0213(0x54ec),   X0213(0x54ef),   X0213(0x54f1),   X0213(0x54f3),
    /* 92               93               94                                */
       X0213(0x5500),   X0213(0x5501),   X0213(0x5509),
/* JIS X 0213 plane 2 row 4 */
    /*                   1                2                3               */
                        X0213(0x553c),   X0213(0x5541),   X0213(0x35a6),
    /*  4                5                6                7               */
       X0213(0x5547),   X0213(0x554a),   X0213(0x35a8),   X0213(0x5560),
    /*  8                9               10               11               */
       X0213(0x5561),   X0213(0x5564),   X0213NB(0xd843), X0213(0x557d),
    /* 12               13               14               15               */
       X0213(0x5582),   X0213(0x5588),   X0213(0x5591),   X0213(0x35c5),
    /* 16               17               18               19               */
       X0213(0x55d2),   X0213NB(0xd843), X0213NB(0xd843), X0213(0x55bf),
    /* 20               21               22               23               */
       X0213(0x55c9),   X0213(0x55cc),   X0213(0x55d1),   X0213(0x55dd),
    /* 24               25               26               27               */
       X0213(0x35da),   X0213(0x55e2),   X0213NB(0xd843), X0213(0x55e9),
    /* 28               29               30               31               */
       X0213(0x5628),   X0213NB(0xd843), X0213(0x5607),   X0213(0x5610),
    /* 32               33               34               35               */
       X0213(0x5630),   X0213(0x5637),   X0213(0x35f4),   X0213(0x563d),
    /* 36               37               38               39               */
       X0213(0x563f),   X0213(0x5640),   X0213(0x5647),   X0213(0x565e),
    /* 40               41               42               43               */
       X0213(0x5660),   X0213(0x566d),   X0213(0x3605),   X0213(0x5688),
    /* 44               45               46               47               */
       X0213(0x568c),   X0213(0x5695),   X0213(0x569a),   X0213(0x569d),
    /* 48               49               50               51               */
       X0213(0x56a8),   X0213(0x56ad),   X0213(0x56b2),   X0213(0x56c5),
    /* 52               53               54               55               */
       X0213(0x56cd),   X0213(0x56df),   X0213(0x56e8),   X0213(0x56f6),
    /* 56               57               58               59               */
       X0213(0x56f7),   X0213NB(0xd844), X0213(0x5715),   X0213(0x5723),
    /* 60               61               62               63               */
       X0213NB(0xd844), X0213(0x5729),   X0213NB(0xd844), X0213(0x5745),
    /* 64               65               66               67               */
       X0213(0x5746),   X0213(0x574c),   X0213(0x574d),   X0213NB(0xd844),
    /* 68               69               70               71               */
       X0213(0x5768),   X0213(0x576f),   X0213(0x5773),   X0213(0x5774),
    /* 72               73               74               75               */
       X0213(0x5775),   X0213(0x577b),   X0213NB(0xd844), X0213NB(0xd844),
    /* 76               77               78               79               */
       X0213(0x57ac),   X0213(0x579a),   X0213(0x579d),   X0213(0x579e),
    /* 80               81               82               83               */
       X0213(0x57a8),   X0213(0x57d7),   X0213NB(0xd844), X0213(0x57cc),
    /* 84               85               86               87               */
       X0213NB(0xd844), X0213NB(0xd844), X0213(0x57de),   X0213(0x57e6),
    /* 88               89               90               91               */
       X0213(0x57f0),   X0213(0x364a),   X0213(0x57f8),   X0213(0x57fb),
    /* 92               93               94                                */
       X0213(0x57fd),   X0213(0x5804),   X0213(0x581e),
/* JIS X 0213 plane 2 row 5 */
    /*                   1                2                3               */
                        X0213(0x5820),   X0213(0x5827),   X0213(0x5832),
    /*  4                5                6                7               */
       X0213(0x5839),   X0213NB(0xd844), X0213(0x5849),   X0213(0x584c),
    /*  8                9               10               11               */
       X0213(0x5867),   X0213(0x588a),   X0213(0x588b),   X0213(0x588d),
    /* 12               13               14               15               */
       X0213(0x588f),   X0213(0x5890),   X0213(0x5894),   X0213(0x589d),
    /* 16               17               18               19               */
       X0213(0x58aa),   X0213(0x58b1),   X0213NB(0xd845), X0213(0x58c3),
    /* 20               21               22               23               */
       X0213(0x58cd),   X0213(0x58e2),   X0213(0x58f3),   X0213(0x58f4),
    /* 24               25               26               27               */
       X0213(0x5905),   X0213(0x5906),   X0213(0x590b),   X0213(0x590d),
    /* 28               29               30               31               */
       X0213(0x5914),   X0213(0x5924),   X0213NB(0xd845), X0213(0x3691),
    /* 32               33               34               35               */
       X0213(0x593d),   X0213(0x3699),   X0213(0x5946),   X0213(0x3696),
    /* 36               37               38               39               */
       X0213NB(0xd85b), X0213(0x595b),   X0213(0x595f),   X0213NB(0xd845),
    /* 40               41               42               43               */
       X0213(0x5975),   X0213(0x5976),   X0213(0x597c),   X0213(0x599f),
    /* 44               45               46               47               */
       X0213(0x59ae),   X0213(0x59bc),   X0213(0x59c8),   X0213(0x59cd),
    /* 48               49               50               51               */
       X0213(0x59de),   X0213(0x59e3),   X0213(0x59e4),   X0213(0x59e7),
    /* 52               53               54               55               */
       X0213(0x59ee),   X0213NB(0xd845), X0213NB(0xd845), X0213(0x36cf),
    /* 56               57               58               59               */
       X0213(0x5a0c),   X0213(0x5a0d),   X0213(0x5a17),   X0213(0x5a27),
    /* 60               61               62               63               */
       X0213(0x5a2d),   X0213(0x5a55),   X0213(0x5a65),   X0213(0x5a7a),
    /* 64               65               66               67               */
       X0213(0x5a8b),   X0213(0x5a9c),   X0213(0x5a9f),   X0213(0x5aa0),
    /* 68               69               70               71               */
       X0213(0x5aa2),   X0213(0x5ab1),   X0213(0x5ab3),   X0213(0x5ab5),
    /* 72               73               74               75               */
       X0213(0x5aba),   X0213(0x5abf),   X0213(0x5ada),   X0213(0x5adc),
    /* 76               77               78               79               */
       X0213(0x5ae0),   X0213(0x5ae5),   X0213(0x5af0),   X0213(0x5afe),
    /* 80               81               82               83               */
       X0213(0x5af5),   X0213(0x5b00),   X0213(0x5b08),   X0213(0x5b17),
    /* 84               85               86               87               */
       X0213(0x5b34),   X0213(0x5b2d),   X0213(0x5b4c),   X0213(0x5b52),
    /* 88               89               90               91               */
       X0213(0x5b68),   X0213(0x5b6f),   X0213(0x5b7c),   X0213(0x5b7f),
    /* 92               93               94                                */
       X0213(0x5b81),   X0213(0x5b84),   X0213NB(0xd846),
/* JIS X 0213 plane 2 row 6 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 7 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 8 */
    /*                   1                2                3               */
                        X0213(0x5b96),   X0213(0x5bac),   X0213(0x3761),
    /*  4                5                6                7               */
       X0213(0x5bc0),   X0213(0x3762),   X0213(0x5bce),   X0213(0x5bd6),
    /*  8                9               10               11               */
       X0213(0x376c),   X0213(0x376b),   X0213(0x5bf1),   X0213(0x5bfd),
    /* 12               13               14               15               */
       X0213(0x3775),   X0213(0x5c03),   X0213(0x5c29),   X0213(0x5c30),
    /* 16               17               18               19               */
       X0213NB(0xd847), X0213(0x5c5f),   X0213(0x5c63),   X0213(0x5c67),
    /* 20               21               22               23               */
       X0213(0x5c68),   X0213(0x5c69),   X0213(0x5c70),   X0213NB(0xd847),
    /* 24               25               26               27               */
       X0213NB(0xd847), X0213(0x5c7c),   X0213NB(0xd847), X0213NB(0xd847),
    /* 28               29               30               31               */
       X0213(0x5c88),   X0213(0x5c8a),   X0213(0x37c1),   X0213NB(0xd847),
    /* 32               33               34               35               */
       X0213NB(0xd847), X0213(0x5ca0),   X0213(0x5ca2),   X0213(0x5ca6),
    /* 36               37               38               39               */
       X0213(0x5ca7),   X0213NB(0xd847), X0213(0x5cad),   X0213(0x5cb5),
    /* 40               41               42               43               */
       X0213NB(0xd847), X0213(0x5cc9),   X0213NB(0xd847), X0213NB(0xd847),
    /* 44               45               46               47               */
       X0213(0x5d06),   X0213(0x5d10),   X0213(0x5d2b),   X0213(0x5d1d),
    /* 48               49               50               51               */
       X0213(0x5d20),   X0213(0x5d24),   X0213(0x5d26),   X0213(0x5d31),
    /* 52               53               54               55               */
       X0213(0x5d39),   X0213(0x5d42),   X0213(0x37e8),   X0213(0x5d61),
    /* 56               57               58               59               */
       X0213(0x5d6a),   X0213(0x37f4),   X0213(0x5d70),   X0213NB(0xd847),
    /* 60               61               62               63               */
       X0213(0x37fd),   X0213(0x5d88),   X0213(0x3800),   X0213(0x5d92),
    /* 64               65               66               67               */
       X0213(0x5d94),   X0213(0x5d97),   X0213(0x5d99),   X0213(0x5db0),
    /* 68               69               70               71               */
       X0213(0x5db2),   X0213(0x5db4),   X0213NB(0xd847), X0213(0x5db9),
    /* 72               73               74               75               */
       X0213(0x5dd1),   X0213(0x5dd7),   X0213(0x5dd8),   X0213(0x5de0),
    /* 76               77               78               79               */
       X0213NB(0xd847), X0213(0x5de4),   X0213(0x5de9),   X0213(0x382f),
    /* 80               81               82               83               */
       X0213(0x5e00),   X0213(0x3836),   X0213(0x5e12),   X0213(0x5e15),
    /* 84               85               86               87               */
       X0213(0x3840),   X0213(0x5e1f),   X0213(0x5e2e),   X0213(0x5e3e),
    /* 88               89               90               91               */
       X0213(0x5e49),   X0213(0x385c),   X0213(0x5e56),   X0213(0x3861),
    /* 92               93               94                                */
       X0213(0x5e6b),   X0213(0x5e6c),   X0213(0x5e6d),
/* JIS X 0213 plane 2 row 9 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 10 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 11 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 12 */
    /*                   1                2                3               */
                        X0213(0x5e6e),   X0213NB(0xd848), X0213(0x5ea5),
    /*  4                5                6                7               */
       X0213(0x5eaa),   X0213(0x5eac),   X0213(0x5eb9),   X0213(0x5ebf),
    /*  8                9               10               11               */
       X0213(0x5ec6),   X0213(0x5ed2),   X0213(0x5ed9),   X0213NB(0xd848),
    /* 12               13               14               15               */
       X0213(0x5efd),   X0213(0x5f08),   X0213(0x5f0e),   X0213(0x5f1c),
    /* 16               17               18               19               */
       X0213NB(0xd848), X0213(0x5f1e),   X0213(0x5f47),   X0213(0x5f63),
    /* 20               21               22               23               */
       X0213(0x5f72),   X0213(0x5f7e),   X0213(0x5f8f),   X0213(0x5fa2),
    /* 24               25               26               27               */
       X0213(0x5fa4),   X0213(0x5fb8),   X0213(0x5fc4),   X0213(0x38fa),
    /* 28               29               30               31               */
       X0213(0x5fc7),   X0213(0x5fcb),   X0213(0x5fd2),   X0213(0x5fd3),
    /* 32               33               34               35               */
       X0213(0x5fd4),   X0213(0x5fe2),   X0213(0x5fee),   X0213(0x5fef),
    /* 36               37               38               39               */
       X0213(0x5ff3),   X0213(0x5ffc),   X0213(0x3917),   X0213(0x6017),
    /* 40               41               42               43               */
       X0213(0x6022),   X0213(0x6024),   X0213(0x391a),   X0213(0x604c),
    /* 44               45               46               47               */
       X0213(0x607f),   X0213(0x608a),   X0213(0x6095),   X0213(0x60a8),
    /* 48               49               50               51               */
       X0213NB(0xd849), X0213(0x60b0),   X0213(0x60b1),   X0213(0x60be),
    /* 52               53               54               55               */
       X0213(0x60c8),   X0213(0x60d9),   X0213(0x60db),   X0213(0x60ee),
    /* 56               57               58               59               */
       X0213(0x60f2),   X0213(0x60f5),   X0213(0x6110),   X0213(0x6112),
    /* 60               61               62               63               */
       X0213(0x6113),   X0213(0x6119),   X0213(0x611e),   X0213(0x613a),
    /* 64               65               66               67               */
       X0213(0x396f),   X0213(0x6141),   X0213(0x6146),   X0213(0x6160),
    /* 68               69               70               71               */
       X0213(0x617c),   X0213NB(0xd84a), X0213(0x6192),   X0213(0x6193),
    /* 72               73               74               75               */
       X0213(0x6197),   X0213(0x6198),   X0213(0x61a5),   X0213(0x61a8),
    /* 76               77               78               79               */
       X0213(0x61ad),   X0213NB(0xd84a), X0213(0x61d5),   X0213(0x61dd),
    /* 80               81               82               83               */
       X0213(0x61df),   X0213(0x61f5),   X0213NB(0xd84a), X0213(0x6215),
    /* 84               85               86               87               */
       X0213(0x6223),   X0213(0x6229),   X0213(0x6246),   X0213(0x624c),
    /* 88               89               90               91               */
       X0213(0x6251),   X0213(0x6252),   X0213(0x6261),   X0213(0x6264),
    /* 92               93               94                                */
       X0213(0x627b),   X0213(0x626d),   X0213(0x6273),
/* JIS X 0213 plane 2 row 13 */
    /*                   1                2                3               */
                        X0213(0x6299),   X0213(0x62a6),   X0213(0x62d5),
    /*  4                5                6                7               */
       X0213NB(0xd84a), X0213(0x62fd),   X0213(0x6303),   X0213(0x630d),
    /*  8                9               10               11               */
       X0213(0x6310),   X0213NB(0xd84a), X0213NB(0xd84a), X0213(0x6332),
    /* 12               13               14               15               */
       X0213(0x6335),   X0213(0x633b),   X0213(0x633c),   X0213(0x6341),
    /* 16               17               18               19               */
       X0213(0x6344),   X0213(0x634e),   X0213NB(0xd84a), X0213(0x6359),
    /* 20               21               22               23               */
       X0213NB(0xd84b), X0213NB(0xd84a), X0213(0x636c),   X0213(0x6384),
    /* 24               25               26               27               */
       X0213(0x6399),   X0213NB(0xd84b), X0213(0x6394),   X0213(0x63bd),
    /* 28               29               30               31               */
       X0213(0x63f7),   X0213(0x63d4),   X0213(0x63d5),   X0213(0x63dc),
    /* 32               33               34               35               */
       X0213(0x63e0),   X0213(0x63eb),   X0213(0x63ec),   X0213(0x63f2),
    /* 36               37               38               39               */
       X0213(0x6409),   X0213(0x641e),   X0213(0x6425),   X0213(0x6429),
    /* 40               41               42               43               */
       X0213(0x642f),   X0213(0x645a),   X0213(0x645b),   X0213(0x645d),
    /* 44               45               46               47               */
       X0213(0x6473),   X0213(0x647d),   X0213(0x6487),   X0213(0x6491),
    /* 48               49               50               51               */
       X0213(0x649d),   X0213(0x649f),   X0213(0x64cb),   X0213(0x64cc),
    /* 52               53               54               55               */
       X0213(0x64d5),   X0213(0x64d7),   X0213NB(0xd84b), X0213(0x64e4),
    /* 56               57               58               59               */
       X0213(0x64e5),   X0213(0x64ff),   X0213(0x6504),   X0213(0x3a6e),
    /* 60               61               62               63               */
       X0213(0x650f),   X0213(0x6514),   X0213(0x6516),   X0213(0x3a73),
    /* 64               65               66               67               */
       X0213(0x651e),   X0213(0x6532),   X0213(0x6544),   X0213(0x6554),
    /* 68               69               70               71               */
       X0213(0x656b),   X0213(0x657a),   X0213(0x6581),   X0213(0x6584),
    /* 72               73               74               75               */
       X0213(0x6585),   X0213(0x658a),   X0213(0x65b2),   X0213(0x65b5),
    /* 76               77               78               79               */
       X0213(0x65b8),   X0213(0x65bf),   X0213(0x65c2),   X0213(0x65c9),
    /* 80               81               82               83               */
       X0213(0x65d4),   X0213(0x3ad6),   X0213(0x65f2),   X0213(0x65f9),
    /* 84               85               86               87               */
       X0213(0x65fc),   X0213(0x6604),   X0213(0x6608),   X0213(0x6621),
    /* 88               89               90               91               */
       X0213(0x662a),   X0213(0x6645),   X0213(0x6651),   X0213(0x664e),
    /* 92               93               94                                */
       X0213(0x3aea),   X0213NB(0xd84c), X0213(0x6657),
/* JIS X 0213 plane 2 row 14 */
    /*                   1                2                3               */
                        X0213(0x665b),   X0213(0x6663),   X0213NB(0xd84c),
    /*  4                5                6                7               */
       X0213NB(0xd84c), X0213(0x666a),   X0213(0x666b),   X0213(0x666c),
    /*  8                9               10               11               */
       X0213(0x666d),   X0213(0x667b),   X0213(0x6680),   X0213(0x6690),
    /* 12               13               14               15               */
       X0213(0x6692),   X0213(0x6699),   X0213(0x3b0e),   X0213(0x66ad),
    /* 16               17               18               19               */
       X0213(0x66b1),   X0213(0x66b5),   X0213(0x3b1a),   X0213(0x66bf),
    /* 20               21               22               23               */
       X0213(0x3b1c),   X0213(0x66ec),   X0213(0x3ad7),   X0213(0x6701),
    /* 24               25               26               27               */
       X0213(0x6705),   X0213(0x6712),   X0213NB(0xd84c), X0213(0x6719),
    /* 28               29               30               31               */
       X0213NB(0xd84c), X0213NB(0xd84c), X0213(0x674c),   X0213(0x674d),
    /* 32               33               34               35               */
       X0213(0x6754),   X0213(0x675d),   X0213NB(0xd84c), X0213NB(0xd84c),
    /* 36               37               38               39               */
       X0213NB(0xd84c), X0213(0x6774),   X0213(0x6776),   X0213NB(0xd84c),
    /* 40               41               42               43               */
       X0213(0x6792),   X0213NB(0xd84c), X0213(0x8363),   X0213(0x6810),
    /* 44               45               46               47               */
       X0213(0x67b0),   X0213(0x67b2),   X0213(0x67c3),   X0213(0x67c8),
    /* 48               49               50               51               */
       X0213(0x67d2),   X0213(0x67d9),   X0213(0x67db),   X0213(0x67f0),
    /* 52               53               54               55               */
       X0213(0x67f7),   X0213NB(0xd84d), X0213NB(0xd84d), X0213NB(0xd84d),
    /* 56               57               58               59               */
       X0213(0x6818),   X0213(0x681f),   X0213(0x682d),   X0213NB(0xd84d),
    /* 60               61               62               63               */
       X0213(0x6833),   X0213(0x683b),   X0213(0x683e),   X0213(0x6844),
    /* 64               65               66               67               */
       X0213(0x6845),   X0213(0x6849),   X0213(0x684c),   X0213(0x6855),
    /* 68               69               70               71               */
       X0213(0x6857),   X0213(0x3b77),   X0213(0x686b),   X0213(0x686e),
    /* 72               73               74               75               */
       X0213(0x687a),   X0213(0x687c),   X0213(0x6882),   X0213(0x6890),
    /* 76               77               78               79               */
       X0213(0x6896),   X0213(0x3b6d),   X0213(0x6898),   X0213(0x6899),
    /* 80               81               82               83               */
       X0213(0x689a),   X0213(0x689c),   X0213(0x68aa),   X0213(0x68ab),
    /* 84               85               86               87               */
       X0213(0x68b4),   X0213(0x68bb),   X0213(0x68fb),   X0213NB(0xd84d),
    /* 88               89               90               91               */
       X0213NB(0xd84d), X0213(0xfa13),   X0213(0x68c3),   X0213(0x68c5),
    /* 92               93               94                                */
       X0213(0x68cc),   X0213(0x68cf),   X0213(0x68d6),
/* JIS X 0213 plane 2 row 15 */
    /*                   1                2                3               */
                        X0213(0x68d9),   X0213(0x68e4),   X0213(0x68e5),
    /*  4                5                6                7               */
       X0213(0x68ec),   X0213(0x68f7),   X0213(0x6903),   X0213(0x6907),
    /*  8                9               10               11               */
       X0213(0x3b87),   X0213(0x3b88),   X0213NB(0xd84d), X0213(0x693b),
    /* 12               13               14               15               */
       X0213(0x3b8d),   X0213(0x6946),   X0213(0x6969),   X0213(0x696c),
    /* 16               17               18               19               */
       X0213(0x6972),   X0213(0x697a),   X0213(0x697f),   X0213(0x6992),
    /* 20               21               22               23               */
       X0213(0x3ba4),   X0213(0x6996),   X0213(0x6998),   X0213(0x69a6),
    /* 24               25               26               27               */
       X0213(0x69b0),   X0213(0x69b7),   X0213(0x69ba),   X0213(0x69bc),
    /* 28               29               30               31               */
       X0213(0x69c0),   X0213(0x69d1),   X0213(0x69d6),   X0213NB(0xd84d),
    /* 32               33               34               35               */
       X0213NB(0xd84d), X0213(0x6a30),   X0213NB(0xd84d), X0213NB(0xd84d),
    /* 36               37               38               39               */
       X0213(0x69e3),   X0213(0x69ee),   X0213(0x69ef),   X0213(0x69f3),
    /* 40               41               42               43               */
       X0213(0x3bcd),   X0213(0x69f4),   X0213(0x69fe),   X0213(0x6a11),
    /* 44               45               46               47               */
       X0213(0x6a1a),   X0213(0x6a1d),   X0213NB(0xd84d), X0213(0x6a32),
    /* 48               49               50               51               */
       X0213(0x6a33),   X0213(0x6a34),   X0213(0x6a3f),   X0213(0x6a46),
    /* 52               53               54               55               */
       X0213(0x6a49),   X0213(0x6a7a),   X0213(0x6a4e),   X0213(0x6a52),
    /* 56               57               58               59               */
       X0213(0x6a64),   X0213NB(0xd84d), X0213(0x6a7e),   X0213(0x6a83),
    /* 60               61               62               63               */
       X0213(0x6a8b),   X0213(0x3bf0),   X0213(0x6a91),   X0213(0x6a9f),
    /* 64               65               66               67               */
       X0213(0x6aa1),   X0213NB(0xd84d), X0213(0x6aab),   X0213(0x6abd),
    /* 68               69               70               71               */
       X0213(0x6ac6),   X0213(0x6ad4),   X0213(0x6ad0),   X0213(0x6adc),
    /* 72               73               74               75               */
       X0213(0x6add),   X0213NB(0xd84d), X0213NB(0xd84d), X0213(0x6aec),
    /* 76               77               78               79               */
       X0213(0x6af1),   X0213(0x6af2),   X0213(0x6af3),   X0213(0x6afd),
    /* 80               81               82               83               */
       X0213NB(0xd84e), X0213(0x6b0b),   X0213(0x6b0f),   X0213(0x6b10),
    /* 84               85               86               87               */
       X0213(0x6b11),   X0213NB(0xd84e), X0213(0x6b17),   X0213(0x3c26),
    /* 88               89               90               91               */
       X0213(0x6b2f),   X0213(0x6b4a),   X0213(0x6b58),   X0213(0x6b6c),
    /* 92               93               94                                */
       X0213(0x6b75),   X0213(0x6b7a),   X0213(0x6b81),
/* JIS X 0213 plane 2 row 16 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 17 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 18 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 19 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 20 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 21 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 22 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 23 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 24 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 25 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 26 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 27 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 28 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 29 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 30 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 31 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 32 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 33 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 34 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 35 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 36 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 37 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 38 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 39 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 40 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 41 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 42 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 43 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 44 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 45 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 46 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 47 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 48 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 49 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 50 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 51 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 52 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 53 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 54 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 55 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 56 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 57 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 58 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 59 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 60 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 61 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 62 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 63 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 64 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 65 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 66 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 67 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 68 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 69 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 70 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 71 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 72 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 73 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 74 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 75 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 76 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 77 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0213 plane 2 row 78 */
    /*                   1                2                3               */
                        X0213(0x6b9b),   X0213(0x6bae),   X0213NB(0xd84e),
    /*  4                5                6                7               */
       X0213(0x6bbd),   X0213(0x6bbe),   X0213(0x6bc7),   X0213(0x6bc8),
    /*  8                9               10               11               */
       X0213(0x6bc9),   X0213(0x6bda),   X0213(0x6be6),   X0213(0x6be7),
    /* 12               13               14               15               */
       X0213(0x6bee),   X0213(0x6bf1),   X0213(0x6c02),   X0213(0x6c0a),
    /* 16               17               18               19               */
       X0213(0x6c0e),   X0213(0x6c35),   X0213(0x6c36),   X0213(0x6c3a),
    /* 20               21               22               23               */
       X0213NB(0xd84f), X0213(0x6c3f),   X0213(0x6c4d),   X0213(0x6c5b),
    /* 24               25               26               27               */
       X0213(0x6c6d),   X0213(0x6c84),   X0213(0x6c89),   X0213(0x3cc3),
    /* 28               29               30               31               */
       X0213(0x6c94),   X0213(0x6c95),   X0213(0x6c97),   X0213(0x6cad),
    /* 32               33               34               35               */
       X0213(0x6cc2),   X0213(0x6cd0),   X0213(0x3cd2),   X0213(0x6cd6),
    /* 36               37               38               39               */
       X0213(0x6cda),   X0213(0x6cdc),   X0213(0x6ce9),   X0213(0x6cec),
    /* 40               41               42               43               */
       X0213(0x6ced),   X0213NB(0xd84f), X0213(0x6d00),   X0213(0x6d0a),
    /* 44               45               46               47               */
       X0213(0x6d24),   X0213(0x6d26),   X0213(0x6d27),   X0213(0x6c67),
    /* 48               49               50               51               */
       X0213(0x6d2f),   X0213(0x6d3c),   X0213(0x6d5b),   X0213(0x6d5e),
    /* 52               53               54               55               */
       X0213(0x6d60),   X0213(0x6d70),   X0213(0x6d80),   X0213(0x6d81),
    /* 56               57               58               59               */
       X0213(0x6d8a),   X0213(0x6d8d),   X0213(0x6d91),   X0213(0x6d98),
    /* 60               61               62               63               */
       X0213NB(0xd84f), X0213(0x6e17),   X0213NB(0xd84f), X0213NB(0xd84f),
    /* 64               65               66               67               */
       X0213NB(0xd84f), X0213(0x6dab),   X0213(0x6dae),   X0213(0x6db4),
    /* 68               69               70               71               */
       X0213(0x6dc2),   X0213(0x6d34),   X0213(0x6dc8),   X0213(0x6dce),
    /* 72               73               74               75               */
       X0213(0x6dcf),   X0213(0x6dd0),   X0213(0x6ddf),   X0213(0x6de9),
    /* 76               77               78               79               */
       X0213(0x6df6),   X0213(0x6e36),   X0213(0x6e1e),   X0213(0x6e22),
    /* 80               81               82               83               */
       X0213(0x6e27),   X0213(0x3d11),   X0213(0x6e32),   X0213(0x6e3c),
    /* 84               85               86               87               */
       X0213(0x6e48),   X0213(0x6e49),   X0213(0x6e4b),   X0213(0x6e4c),
    /* 88               89               90               91               */
       X0213(0x6e4f),   X0213(0x6e51),   X0213(0x6e53),   X0213(0x6e54),
    /* 92               93               94                                */
       X0213(0x6e57),   X0213(0x6e63),   X0213(0x3d1e),
/* JIS X 0213 plane 2 row 79 */
    /*                   1                2                3               */
                        X0213(0x6e93),   X0213(0x6ea7),   X0213(0x6eb4),
    /*  4                5                6                7               */
       X0213(0x6ebf),   X0213(0x6ec3),   X0213(0x6eca),   X0213(0x6ed9),
    /*  8                9               10               11               */
       X0213(0x6f35),   X0213(0x6eeb),   X0213(0x6ef9),   X0213(0x6efb),
    /* 12               13               14               15               */
       X0213(0x6f0a),   X0213(0x6f0c),   X0213(0x6f18),   X0213(0x6f25),
    /* 16               17               18               19               */
       X0213(0x6f36),   X0213(0x6f3c),   X0213NB(0xd84f), X0213(0x6f52),
    /* 20               21               22               23               */
       X0213(0x6f57),   X0213(0x6f5a),   X0213(0x6f60),   X0213(0x6f68),
    /* 24               25               26               27               */
       X0213(0x6f98),   X0213(0x6f7d),   X0213(0x6f90),   X0213(0x6f96),
    /* 28               29               30               31               */
       X0213(0x6fbe),   X0213(0x6f9f),   X0213(0x6fa5),   X0213(0x6faf),
    /* 32               33               34               35               */
       X0213(0x3d64),   X0213(0x6fb5),   X0213(0x6fc8),   X0213(0x6fc9),
    /* 36               37               38               39               */
       X0213(0x6fda),   X0213(0x6fde),   X0213(0x6fe9),   X0213NB(0xd850),
    /* 40               41               42               43               */
       X0213(0x6ffc),   X0213(0x7000),   X0213(0x7007),   X0213(0x700a),
    /* 44               45               46               47               */
       X0213(0x7023),   X0213NB(0xd850), X0213(0x7039),   X0213(0x703a),
    /* 48               49               50               51               */
       X0213(0x703c),   X0213(0x7043),   X0213(0x7047),   X0213(0x704b),
    /* 52               53               54               55               */
       X0213(0x3d9a),   X0213(0x7054),   X0213(0x7065),   X0213(0x7069),
    /* 56               57               58               59               */
       X0213(0x706c),   X0213(0x706e),   X0213(0x7076),   X0213(0x707e),
    /* 60               61               62               63               */
       X0213(0x7081),   X0213(0x7086),   X0213(0x7095),   X0213(0x7097),
    /* 64               65               66               67               */
       X0213(0x70bb),   X0213NB(0xd850), X0213(0x709f),   X0213(0x70b1),
    /* 68               69               70               71               */
       X0213NB(0xd850), X0213(0x70ec),   X0213(0x70ca),   X0213(0x70d1),
    /* 72               73               74               75               */
       X0213(0x70d3),   X0213(0x70dc),   X0213(0x7103),   X0213(0x7104),
    /* 76               77               78               79               */
       X0213(0x7016),   X0213(0x7107),   X0213(0x7108),   X0213(0x710c),
    /* 80               81               82               83               */
       X0213(0x3dc0),   X0213(0x712f),   X0213(0x7131),   X0213(0x7150),
    /* 84               85               86               87               */
       X0213(0x714a),   X0213(0x7153),   X0213(0x715e),   X0213(0x3dd4),
    /* 88               89               90               91               */
       X0213(0x7196),   X0213(0x7180),   X0213(0x719b),   X0213(0x71a0),
    /* 92               93               94                                */
       X0213(0x71a2),   X0213(0x71ae),   X0213(0x71af),
/* JIS X 0213 plane 2 row 80 */
    /*                   1                2                3               */
                        X0213(0x71b3),   X0213NB(0xd850), X0213(0x71cb),
    /*  4                5                6                7               */
       X0213(0x71d3),   X0213(0x71d9),   X0213(0x71dc),   X0213(0x7207),
    /*  8                9               10               11               */
       X0213(0x3e05),   X0213(0xfa49),   X0213(0x722b),   X0213(0x7234),
    /* 12               13               14               15               */
       X0213(0x7238),   X0213(0x7239),   X0213(0x4e2c),   X0213(0x7242),
    /* 16               17               18               19               */
       X0213(0x7253),   X0213(0x7257),   X0213(0x7263),   X0213NB(0xd851),
    /* 20               21               22               23               */
       X0213(0x726e),   X0213(0x726f),   X0213(0x7278),   X0213(0x727f),
    /* 24               25               26               27               */
       X0213(0x728e),   X0213NB(0xd851), X0213(0x72ad),   X0213(0x72ae),
    /* 28               29               30               31               */
       X0213(0x72b0),   X0213(0x72b1),   X0213(0x72c1),   X0213(0x3e60),
    /* 32               33               34               35               */
       X0213(0x72cc),   X0213(0x3e66),   X0213(0x3e68),   X0213(0x72f3),
    /* 36               37               38               39               */
       X0213(0x72fa),   X0213(0x7307),   X0213(0x7312),   X0213(0x7318),
    /* 40               41               42               43               */
       X0213(0x7319),   X0213(0x3e83),   X0213(0x7339),   X0213(0x732c),
    /* 44               45               46               47               */
       X0213(0x7331),   X0213(0x7333),   X0213(0x733d),   X0213(0x7352),
    /* 48               49               50               51               */
       X0213(0x3e94),   X0213(0x736b),   X0213(0x736c),   X0213NB(0xd852),
    /* 52               53               54               55               */
       X0213(0x736e),   X0213(0x736f),   X0213(0x7371),   X0213(0x7377),
    /* 56               57               58               59               */
       X0213(0x7381),   X0213(0x7385),   X0213(0x738a),   X0213(0x7394),
    /* 60               61               62               63               */
       X0213(0x7398),   X0213(0x739c),   X0213(0x739e),   X0213(0x73a5),
    /* 64               65               66               67               */
       X0213(0x73a8),   X0213(0x73b5),   X0213(0x73b7),   X0213(0x73b9),
    /* 68               69               70               71               */
       X0213(0x73bc),   X0213(0x73bf),   X0213(0x73c5),   X0213(0x73cb),
    /* 72               73               74               75               */
       X0213(0x73e1),   X0213(0x73e7),   X0213(0x73f9),   X0213(0x7413),
    /* 76               77               78               79               */
       X0213(0x73fa),   X0213(0x7401),   X0213(0x7424),   X0213(0x7431),
    /* 80               81               82               83               */
       X0213(0x7439),   X0213(0x7453),   X0213(0x7440),   X0213(0x7443),
    /* 84               85               86               87               */
       X0213(0x744d),   X0213(0x7452),   X0213(0x745d),   X0213(0x7471),
    /* 88               89               90               91               */
       X0213(0x7481),   X0213(0x7485),   X0213(0x7488),   X0213NB(0xd852),
    /* 92               93               94                                */
       X0213(0x7492),   X0213(0x7497),   X0213(0x7499),
/* JIS X 0213 plane 2 row 81 */
    /*                   1                2                3               */
                        X0213(0x74a0),   X0213(0x74a1),   X0213(0x74a5),
    /*  4                5                6                7               */
       X0213(0x74aa),   X0213(0x74ab),   X0213(0x74b9),   X0213(0x74bb),
    /*  8                9               10               11               */
       X0213(0x74ba),   X0213(0x74d6),   X0213(0x74d8),   X0213(0x74de),
    /* 12               13               14               15               */
       X0213(0x74ef),   X0213(0x74eb),   X0213NB(0xd852), X0213(0x74fa),
    /* 16               17               18               19               */
       X0213NB(0xd852), X0213(0x7520),   X0213(0x7524),   X0213(0x752a),
    /* 20               21               22               23               */
       X0213(0x3f57),   X0213NB(0xd853), X0213(0x753d),   X0213(0x753e),
    /* 24               25               26               27               */
       X0213(0x7540),   X0213(0x7548),   X0213(0x754e),   X0213(0x7550),
    /* 28               29               30               31               */
       X0213(0x7552),   X0213(0x756c),   X0213(0x7572),   X0213(0x7571),
    /* 32               33               34               35               */
       X0213(0x757a),   X0213(0x757d),   X0213(0x757e),   X0213(0x7581),
    /* 36               37               38               39               */
       X0213NB(0xd853), X0213(0x758c),   X0213(0x3f75),   X0213(0x75a2),
    /* 40               41               42               43               */
       X0213(0x3f77),   X0213(0x75b0),   X0213(0x75b7),   X0213(0x75bf),
    /* 44               45               46               47               */
       X0213(0x75c0),   X0213(0x75c6),   X0213(0x75cf),   X0213(0x75d3),
    /* 48               49               50               51               */
       X0213(0x75dd),   X0213(0x75df),   X0213(0x75e0),   X0213(0x75e7),
    /* 52               53               54               55               */
       X0213(0x75ec),   X0213(0x75ee),   X0213(0x75f1),   X0213(0x75f9),
    /* 56               57               58               59               */
       X0213(0x7603),   X0213(0x7618),   X0213(0x7607),   X0213(0x760f),
    /* 60               61               62               63               */
       X0213(0x3fae),   X0213NB(0xd853), X0213(0x7613),   X0213(0x761b),
    /* 64               65               66               67               */
       X0213(0x761c),   X0213NB(0xd853), X0213(0x7625),   X0213(0x7628),
    /* 68               69               70               71               */
       X0213(0x763c),   X0213(0x7633),   X0213NB(0xd853), X0213(0x3fc9),
    /* 72               73               74               75               */
       X0213(0x7641),   X0213NB(0xd853), X0213(0x7649),   X0213(0x7655),
    /* 76               77               78               79               */
       X0213(0x3fd7),   X0213(0x766e),   X0213(0x7695),   X0213(0x769c),
    /* 80               81               82               83               */
       X0213(0x76a1),   X0213(0x76a0),   X0213(0x76a7),   X0213(0x76a8),
    /* 84               85               86               87               */
       X0213(0x76af),   X0213NB(0xd854), X0213(0x76c9),   X0213NB(0xd854),
    /* 88               89               90               91               */
       X0213(0x76e8),   X0213(0x76ec),   X0213NB(0xd854), X0213(0x7717),
    /* 92               93               94                                */
       X0213(0x771a),   X0213(0x772d),   X0213(0x7735),
/* JIS X 0213 plane 2 row 82 */
    /*                   1                2                3               */
                        X0213NB(0xd854), X0213(0x4039),   X0213NB(0xd854),
    /*  4                5                6                7               */
       X0213NB(0xd854), X0213(0x7758),   X0213(0x7760),   X0213(0x776a),
    /*  8                9               10               11               */
       X0213NB(0xd854), X0213(0x7772),   X0213(0x777c),   X0213(0x777d),
    /* 12               13               14               15               */
       X0213NB(0xd854), X0213(0x4058),   X0213(0x779a),   X0213(0x779f),
    /* 16               17               18               19               */
       X0213(0x77a2),   X0213(0x77a4),   X0213(0x77a9),   X0213(0x77de),
    /* 20               21               22               23               */
       X0213(0x77df),   X0213(0x77e4),   X0213(0x77e6),   X0213(0x77ea),
    /* 24               25               26               27               */
       X0213(0x77ec),   X0213(0x4093),   X0213(0x77f0),   X0213(0x77f4),
    /* 28               29               30               31               */
       X0213(0x77fb),   X0213NB(0xd855), X0213(0x7805),   X0213(0x7806),
    /* 32               33               34               35               */
       X0213(0x7809),   X0213(0x780d),   X0213(0x7819),   X0213(0x7821),
    /* 36               37               38               39               */
       X0213(0x782c),   X0213(0x7847),   X0213(0x7864),   X0213(0x786a),
    /* 40               41               42               43               */
       X0213NB(0xd855), X0213(0x788a),   X0213(0x7894),   X0213(0x78a4),
    /* 44               45               46               47               */
       X0213(0x789d),   X0213(0x789e),   X0213(0x789f),   X0213(0x78bb),
    /* 48               49               50               51               */
       X0213(0x78c8),   X0213(0x78cc),   X0213(0x78ce),   X0213(0x78d5),
    /* 52               53               54               55               */
       X0213(0x78e0),   X0213(0x78e1),   X0213(0x78e6),   X0213(0x78f9),
    /* 56               57               58               59               */
       X0213(0x78fa),   X0213(0x78fb),   X0213(0x78fe),   X0213NB(0xd855),
    /* 60               61               62               63               */
       X0213(0x7910),   X0213(0x791b),   X0213(0x7930),   X0213(0x7925),
    /* 64               65               66               67               */
       X0213(0x793b),   X0213(0x794a),   X0213(0x7958),   X0213(0x695b),
    /* 68               69               70               71               */
       X0213(0x4105),   X0213(0x7967),   X0213(0x7972),   X0213(0x7994),
    /* 72               73               74               75               */
       X0213(0x7995),   X0213(0x7996),   X0213(0x799b),   X0213(0x79a1),
    /* 76               77               78               79               */
       X0213(0x79a9),   X0213(0x79b4),   X0213(0x79bb),   X0213(0x79c2),
    /* 80               81               82               83               */
       X0213(0x79c7),   X0213(0x79cc),   X0213(0x79cd),   X0213(0x79d6),
    /* 84               85               86               87               */
       X0213(0x4148),   X0213NB(0xd855), X0213NB(0xd855), X0213(0x414f),
    /* 88               89               90               91               */
       X0213(0x7a0a),   X0213(0x7a11),   X0213(0x7a15),   X0213(0x7a1b),
    /* 92               93               94                                */
       X0213(0x7a1e),   X0213(0x4163),   X0213(0x7a2d),
/* JIS X 0213 plane 2 row 83 */
    /*                   1                2                3               */
                        X0213(0x7a38),   X0213(0x7a47),   X0213(0x7a4c),
    /*  4                5                6                7               */
       X0213(0x7a56),   X0213(0x7a59),   X0213(0x7a5c),   X0213(0x7a5f),
    /*  8                9               10               11               */
       X0213(0x7a60),   X0213(0x7a67),   X0213(0x7a6a),   X0213(0x7a75),
    /* 12               13               14               15               */
       X0213(0x7a78),   X0213(0x7a82),   X0213(0x7a8a),   X0213(0x7a90),
    /* 16               17               18               19               */
       X0213(0x7aa3),   X0213(0x7aac),   X0213NB(0xd856), X0213(0x41b4),
    /* 20               21               22               23               */
       X0213(0x7ab9),   X0213(0x7abc),   X0213(0x7abe),   X0213(0x41bf),
    /* 24               25               26               27               */
       X0213(0x7acc),   X0213(0x7ad1),   X0213(0x7ae7),   X0213(0x7ae8),
    /* 28               29               30               31               */
       X0213(0x7af4),   X0213NB(0xd856), X0213NB(0xd856), X0213(0x7b07),
    /* 32               33               34               35               */
       X0213NB(0xd856), X0213(0x7b3d),   X0213(0x7b27),   X0213(0x7b2a),
    /* 36               37               38               39               */
       X0213(0x7b2e),   X0213(0x7b2f),   X0213(0x7b31),   X0213(0x41e6),
    /* 40               41               42               43               */
       X0213(0x41f3),   X0213(0x7b7f),   X0213(0x7b41),   X0213(0x41ee),
    /* 44               45               46               47               */
       X0213(0x7b55),   X0213(0x7b79),   X0213(0x7b64),   X0213(0x7b66),
    /* 48               49               50               51               */
       X0213(0x7b69),   X0213(0x7b73),   X0213NB(0xd856), X0213(0x4207),
    /* 52               53               54               55               */
       X0213(0x7b90),   X0213(0x7b91),   X0213(0x7b9b),   X0213(0x420e),
    /* 56               57               58               59               */
       X0213(0x7baf),   X0213(0x7bb5),   X0213(0x7bbc),   X0213(0x7bc5),
    /* 60               61               62               63               */
       X0213(0x7bca),   X0213NB(0xd857), X0213NB(0xd857), X0213(0x7bd4),
    /* 64               65               66               67               */
       X0213(0x7bd6),   X0213(0x7bda),   X0213(0x7bea),   X0213(0x7bf0),
    /* 68               69               70               71               */
       X0213(0x7c03),   X0213(0x7c0b),   X0213(0x7c0e),   X0213(0x7c0f),
    /* 72               73               74               75               */
       X0213(0x7c26),   X0213(0x7c45),   X0213(0x7c4a),   X0213(0x7c51),
    /* 76               77               78               79               */
       X0213(0x7c57),   X0213(0x7c5e),   X0213(0x7c61),   X0213(0x7c69),
    /* 80               81               82               83               */
       X0213(0x7c6e),   X0213(0x7c6f),   X0213(0x7c70),   X0213NB(0xd857),
    /* 84               85               86               87               */
       X0213NB(0xd857), X0213NB(0xd857), X0213(0x7ca6),   X0213NB(0xd857),
    /* 88               89               90               91               */
       X0213(0x7cb6),   X0213(0x7cb7),   X0213(0x7cbf),   X0213NB(0xd857),
    /* 92               93               94                                */
       X0213(0x7cc4),   X0213NB(0xd857), X0213(0x7cc8),
/* JIS X 0213 plane 2 row 84 */
    /*                   1                2                3               */
                        X0213(0x7ccd),   X0213NB(0xd857), X0213(0x7cd7),
    /*  4                5                6                7               */
       X0213NB(0xd857), X0213(0x7ce6),   X0213(0x7ceb),   X0213NB(0xd857),
    /*  8                9               10               11               */
       X0213(0x7cf5),   X0213(0x7d03),   X0213(0x7d09),   X0213(0x42c6),
    /* 12               13               14               15               */
       X0213(0x7d12),   X0213(0x7d1e),   X0213NB(0xd857), X0213NB(0xd857),
    /* 16               17               18               19               */
       X0213(0x7d3d),   X0213(0x7d3e),   X0213(0x7d40),   X0213(0x7d47),
    /* 20               21               22               23               */
       X0213NB(0xd858), X0213NB(0xd857), X0213(0x42d6),   X0213(0x7d59),
    /* 24               25               26               27               */
       X0213(0x7d5a),   X0213(0x7d6a),   X0213(0x7d70),   X0213(0x42dd),
    /* 28               29               30               31               */
       X0213(0x7d7f),   X0213NB(0xd858), X0213(0x7d86),   X0213(0x7d88),
    /* 32               33               34               35               */
       X0213(0x7d8c),   X0213(0x7d97),   X0213NB(0xd858), X0213(0x7d9d),
    /* 36               37               38               39               */
       X0213(0x7da7),   X0213(0x7daa),   X0213(0x7db6),   X0213(0x7db7),
    /* 40               41               42               43               */
       X0213(0x7dc0),   X0213(0x7dd7),   X0213(0x7dd9),   X0213(0x7de6),
    /* 44               45               46               47               */
       X0213(0x7df1),   X0213(0x7df9),   X0213(0x4302),   X0213NB(0xd858),
    /* 48               49               50               51               */
       X0213(0xfa58),   X0213(0x7e10),   X0213(0x7e17),   X0213(0x7e1d),
    /* 52               53               54               55               */
       X0213(0x7e20),   X0213(0x7e27),   X0213(0x7e2c),   X0213(0x7e45),
    /* 56               57               58               59               */
       X0213(0x7e73),   X0213(0x7e75),   X0213(0x7e7e),   X0213(0x7e86),
    /* 60               61               62               63               */
       X0213(0x7e87),   X0213(0x432b),   X0213(0x7e91),   X0213(0x7e98),
    /* 64               65               66               67               */
       X0213(0x7e9a),   X0213(0x4343),   X0213(0x7f3c),   X0213(0x7f3b),
    /* 68               69               70               71               */
       X0213(0x7f3e),   X0213(0x7f43),   X0213(0x7f44),   X0213(0x7f4f),
    /* 72               73               74               75               */
       X0213(0x34c1),   X0213NB(0xd858), X0213(0x7f52),   X0213NB(0xd858),
    /* 76               77               78               79               */
       X0213(0x7f61),   X0213(0x7f63),   X0213(0x7f64),   X0213(0x7f6d),
    /* 80               81               82               83               */
       X0213(0x7f7d),   X0213(0x7f7e),   X0213NB(0xd858), X0213(0x7f90),
    /* 84               85               86               87               */
       X0213(0x517b),   X0213NB(0xd84f), X0213(0x7f96),   X0213(0x7f9c),
    /* 88               89               90               91               */
       X0213(0x7fad),   X0213NB(0xd859), X0213(0x7fc3),   X0213(0x7fcf),
    /* 92               93               94                                */
       X0213(0x7fe3),   X0213(0x7fe5),   X0213(0x7fef),
/* JIS X 0213 plane 2 row 85 */
    /*                   1                2                3               */
                        X0213(0x7ff2),   X0213(0x8002),   X0213(0x800a),
    /*  4                5                6                7               */
       X0213(0x8008),   X0213(0x800e),   X0213(0x8011),   X0213(0x8016),
    /*  8                9               10               11               */
       X0213(0x8024),   X0213(0x802c),   X0213(0x8030),   X0213(0x8043),
    /* 12               13               14               15               */
       X0213(0x8066),   X0213(0x8071),   X0213(0x8075),   X0213(0x807b),
    /* 16               17               18               19               */
       X0213(0x8099),   X0213(0x809c),   X0213(0x90a4),   X0213(0x80a7),
    /* 20               21               22               23               */
       X0213(0x80b8),   X0213NB(0xd859), X0213(0x80c5),   X0213(0x80d5),
    /* 24               25               26               27               */
       X0213(0x80d8),   X0213(0x80e6),   X0213NB(0xd859), X0213(0x810d),
    /* 28               29               30               31               */
       X0213(0x80f5),   X0213(0x80fb),   X0213(0x43ee),   X0213(0x8135),
    /* 32               33               34               35               */
       X0213(0x8116),   X0213(0x811e),   X0213(0x43f0),   X0213(0x8124),
    /* 36               37               38               39               */
       X0213(0x8127),   X0213(0x812c),   X0213NB(0xd859), X0213(0x813d),
    /* 40               41               42               43               */
       X0213(0x4408),   X0213(0x8169),   X0213(0x4417),   X0213(0x8181),
    /* 44               45               46               47               */
       X0213(0x441c),   X0213(0x8184),   X0213(0x8185),   X0213(0x4422),
    /* 48               49               50               51               */
       X0213(0x8198),   X0213(0x81b2),   X0213(0x81c1),   X0213(0x81c3),
    /* 52               53               54               55               */
       X0213(0x81d6),   X0213(0x81db),   X0213NB(0xd85a), X0213(0x81e4),
    /* 56               57               58               59               */
       X0213NB(0xd85a), X0213(0x81ec),   X0213NB(0xd85a), X0213(0x81fd),
    /* 60               61               62               63               */
       X0213(0x81ff),   X0213NB(0xd85a), X0213(0x8204),   X0213NB(0xd85a),
    /* 64               65               66               67               */
       X0213(0x8219),   X0213(0x8221),   X0213(0x8222),   X0213NB(0xd85a),
    /* 68               69               70               71               */
       X0213(0x8232),   X0213(0x8234),   X0213(0x823c),   X0213(0x8246),
    /* 72               73               74               75               */
       X0213(0x8249),   X0213(0x8245),   X0213NB(0xd85a), X0213(0x824b),
    /* 76               77               78               79               */
       X0213(0x4476),   X0213(0x824f),   X0213(0x447a),   X0213(0x8257),
    /* 80               81               82               83               */
       X0213NB(0xd85a), X0213(0x825c),   X0213(0x8263),   X0213NB(0xd85a),
    /* 84               85               86               87               */
       X0213(0xfa5d),   X0213(0xfa5e),   X0213(0x8279),   X0213(0x4491),
    /* 88               89               90               91               */
       X0213(0x827d),   X0213(0x827f),   X0213(0x8283),   X0213(0x828a),
    /* 92               93               94                                */
       X0213(0x8293),   X0213(0x82a7),   X0213(0x82a8),
/* JIS X 0213 plane 2 row 86 */
    /*                   1                2                3               */
                        X0213(0x82b2),   X0213(0x82b4),   X0213(0x82ba),
    /*  4                5                6                7               */
       X0213(0x82bc),   X0213(0x82e2),   X0213(0x82e8),   X0213(0x82f7),
    /*  8                9               10               11               */
       X0213(0x8307),   X0213(0x8308),   X0213(0x830c),   X0213(0x8354),
    /* 12               13               14               15               */
       X0213(0x831b),   X0213(0x831d),   X0213(0x8330),   X0213(0x833c),
    /* 16               17               18               19               */
       X0213(0x8344),   X0213(0x8357),   X0213(0x44be),   X0213(0x837f),
    /* 20               21               22               23               */
       X0213(0x44d4),   X0213(0x44b3),   X0213(0x838d),   X0213(0x8394),
    /* 24               25               26               27               */
       X0213(0x8395),   X0213(0x839b),   X0213(0x839d),   X0213(0x83c9),
    /* 28               29               30               31               */
       X0213(0x83d0),   X0213(0x83d4),   X0213(0x83dd),   X0213(0x83e5),
    /* 32               33               34               35               */
       X0213(0x83f9),   X0213(0x840f),   X0213(0x8411),   X0213(0x8415),
    /* 36               37               38               39               */
       X0213NB(0xd85b), X0213(0x8417),   X0213(0x8439),   X0213(0x844a),
    /* 40               41               42               43               */
       X0213(0x844f),   X0213(0x8451),   X0213(0x8452),   X0213(0x8459),
    /* 44               45               46               47               */
       X0213(0x845a),   X0213(0x845c),   X0213NB(0xd85b), X0213(0x8465),
    /* 48               49               50               51               */
       X0213(0x8476),   X0213(0x8478),   X0213(0x847c),   X0213(0x8481),
    /* 52               53               54               55               */
       X0213(0x450d),   X0213(0x84dc),   X0213(0x8497),   X0213(0x84a6),
    /* 56               57               58               59               */
       X0213(0x84be),   X0213(0x4508),   X0213(0x84ce),   X0213(0x84cf),
    /* 60               61               62               63               */
       X0213(0x84d3),   X0213NB(0xd85b), X0213(0x84e7),   X0213(0x84ea),
    /* 64               65               66               67               */
       X0213(0x84ef),   X0213(0x84f0),   X0213(0x84f1),   X0213(0x84fa),
    /* 68               69               70               71               */
       X0213(0x84fd),   X0213(0x850c),   X0213(0x851b),   X0213(0x8524),
    /* 72               73               74               75               */
       X0213(0x8525),   X0213(0x852b),   X0213(0x8534),   X0213(0x854f),
    /* 76               77               78               79               */
       X0213(0x856f),   X0213(0x4525),   X0213(0x4543),   X0213(0x853e),
    /* 80               81               82               83               */
       X0213(0x8551),   X0213(0x8553),   X0213(0x855e),   X0213(0x8561),
    /* 84               85               86               87               */
       X0213(0x8562),   X0213NB(0xd85b), X0213(0x857b),   X0213(0x857d),
    /* 88               89               90               91               */
       X0213(0x857f),   X0213(0x8581),   X0213(0x8586),   X0213(0x8593),
    /* 92               93               94                                */
       X0213(0x859d),   X0213(0x859f),   X0213NB(0xd85b),
/* JIS X 0213 plane 2 row 87 */
    /*                   1                2                3               */
                        X0213NB(0xd85b), X0213NB(0xd85b), X0213(0x85b7),
    /*  4                5                6                7               */
       X0213(0x85bc),   X0213(0x85c7),   X0213(0x85ca),   X0213(0x85d8),
    /*  8                9               10               11               */
       X0213(0x85d9),   X0213(0x85df),   X0213(0x85e1),   X0213(0x85e6),
    /* 12               13               14               15               */
       X0213(0x85f6),   X0213(0x8600),   X0213(0x8611),   X0213(0x861e),
    /* 16               17               18               19               */
       X0213(0x8621),   X0213(0x8624),   X0213(0x8627),   X0213NB(0xd85c),
    /* 20               21               22               23               */
       X0213(0x8639),   X0213(0x863c),   X0213NB(0xd85c), X0213(0x8640),
    /* 24               25               26               27               */
       X0213(0xfa20),   X0213(0x8653),   X0213(0x8656),   X0213(0x866f),
    /* 28               29               30               31               */
       X0213(0x8677),   X0213(0x867a),   X0213(0x8687),   X0213(0x8689),
    /* 32               33               34               35               */
       X0213(0x868d),   X0213(0x8691),   X0213(0x869c),   X0213(0x869d),
    /* 36               37               38               39               */
       X0213(0x86a8),   X0213(0xfa21),   X0213(0x86b1),   X0213(0x86b3),
    /* 40               41               42               43               */
       X0213(0x86c1),   X0213(0x86c3),   X0213(0x86d1),   X0213(0x86d5),
    /* 44               45               46               47               */
       X0213(0x86d7),   X0213(0x86e3),   X0213(0x86e6),   X0213(0x45b8),
    /* 48               49               50               51               */
       X0213(0x8705),   X0213(0x8707),   X0213(0x870e),   X0213(0x8710),
    /* 52               53               54               55               */
       X0213(0x8713),   X0213(0x8719),   X0213(0x871f),   X0213(0x8721),
    /* 56               57               58               59               */
       X0213(0x8723),   X0213(0x8731),   X0213(0x873a),   X0213(0x873e),
    /* 60               61               62               63               */
       X0213(0x8740),   X0213(0x8743),   X0213(0x8751),   X0213(0x8758),
    /* 64               65               66               67               */
       X0213(0x8764),   X0213(0x8765),   X0213(0x8772),   X0213(0x877c),
    /* 68               69               70               71               */
       X0213NB(0xd85c), X0213NB(0xd85c), X0213(0x87a7),   X0213(0x8789),
    /* 72               73               74               75               */
       X0213(0x878b),   X0213(0x8793),   X0213(0x87a0),   X0213NB(0xd85c),
    /* 76               77               78               79               */
       X0213(0x45e5),   X0213(0x87be),   X0213NB(0xd85d), X0213(0x87c1),
    /* 80               81               82               83               */
       X0213(0x87ce),   X0213(0x87f5),   X0213(0x87df),   X0213NB(0xd85d),
    /* 84               85               86               87               */
       X0213(0x87e3),   X0213(0x87e5),   X0213(0x87e6),   X0213(0x87ea),
    /* 88               89               90               91               */
       X0213(0x87eb),   X0213(0x87ed),   X0213(0x8801),   X0213(0x8803),
    /* 92               93               94                                */
       X0213(0x880b),   X0213(0x8813),   X0213(0x8828),
/* JIS X 0213 plane 2 row 88 */
    /*                   1                2                3               */
                        X0213(0x882e),   X0213(0x8832),   X0213(0x883c),
    /*  4                5                6                7               */
       X0213(0x460f),   X0213(0x884a),   X0213(0x8858),   X0213(0x885f),
    /*  8                9               10               11               */
       X0213(0x8864),   X0213NB(0xd85d), X0213NB(0xd85d), X0213(0x8869),
    /* 12               13               14               15               */
       X0213NB(0xd85d), X0213(0x886f),   X0213(0x88a0),   X0213(0x88bc),
    /* 16               17               18               19               */
       X0213(0x88bd),   X0213(0x88be),   X0213(0x88c0),   X0213(0x88d2),
    /* 20               21               22               23               */
       X0213NB(0xd85d), X0213(0x88d1),   X0213(0x88d3),   X0213(0x88db),
    /* 24               25               26               27               */
       X0213(0x88f0),   X0213(0x88f1),   X0213(0x4641),   X0213(0x8901),
    /* 28               29               30               31               */
       X0213NB(0xd85d), X0213(0x8937),   X0213NB(0xd85d), X0213(0x8942),
    /* 32               33               34               35               */
       X0213(0x8945),   X0213(0x8949),   X0213NB(0xd85d), X0213(0x4665),
    /* 36               37               38               39               */
       X0213(0x8962),   X0213(0x8980),   X0213(0x8989),   X0213(0x8990),
    /* 40               41               42               43               */
       X0213(0x899f),   X0213(0x89b0),   X0213(0x89b7),   X0213(0x89d6),
    /* 44               45               46               47               */
       X0213(0x89d8),   X0213(0x89eb),   X0213(0x46a1),   X0213(0x89f1),
    /* 48               49               50               51               */
       X0213(0x89f3),   X0213(0x89fd),   X0213(0x89ff),   X0213(0x46af),
    /* 52               53               54               55               */
       X0213(0x8a11),   X0213(0x8a14),   X0213NB(0xd85e), X0213(0x8a21),
    /* 56               57               58               59               */
       X0213(0x8a35),   X0213(0x8a3e),   X0213(0x8a45),   X0213(0x8a4d),
    /* 60               61               62               63               */
       X0213(0x8a58),   X0213(0x8aae),   X0213(0x8a90),   X0213(0x8ab7),
    /* 64               65               66               67               */
       X0213(0x8abe),   X0213(0x8ad7),   X0213(0x8afc),   X0213NB(0xd85e),
    /* 68               69               70               71               */
       X0213(0x8b0a),   X0213(0x8b05),   X0213(0x8b0d),   X0213(0x8b1c),
    /* 72               73               74               75               */
       X0213(0x8b1f),   X0213(0x8b2d),   X0213(0x8b43),   X0213(0x470c),
    /* 76               77               78               79               */
       X0213(0x8b51),   X0213(0x8b5e),   X0213(0x8b76),   X0213(0x8b7f),
    /* 80               81               82               83               */
       X0213(0x8b81),   X0213(0x8b8b),   X0213(0x8b94),   X0213(0x8b95),
    /* 84               85               86               87               */
       X0213(0x8b9c),   X0213(0x8b9e),   X0213(0x8c39),   X0213NB(0xd85e),
    /* 88               89               90               91               */
       X0213(0x8c3d),   X0213NB(0xd85e), X0213NB(0xd85e), X0213(0x8c45),
    /* 92               93               94                                */
       X0213(0x8c47),   X0213(0x8c4f),   X0213(0x8c54),
/* JIS X 0213 plane 2 row 89 */
    /*                   1                2                3               */
                        X0213(0x8c57),   X0213(0x8c69),   X0213(0x8c6d),
    /*  4                5                6                7               */
       X0213(0x8c73),   X0213NB(0xd85f), X0213(0x8c93),   X0213(0x8c92),
    /*  8                9               10               11               */
       X0213(0x8c99),   X0213(0x4764),   X0213(0x8c9b),   X0213(0x8ca4),
    /* 12               13               14               15               */
       X0213(0x8cd6),   X0213(0x8cd5),   X0213(0x8cd9),   X0213NB(0xd85f),
    /* 16               17               18               19               */
       X0213(0x8cf0),   X0213(0x8cf1),   X0213NB(0xd85f), X0213(0x8d09),
    /* 20               21               22               23               */
       X0213(0x8d0e),   X0213(0x8d6c),   X0213(0x8d84),   X0213(0x8d95),
    /* 24               25               26               27               */
       X0213(0x8da6),   X0213NB(0xd85f), X0213(0x8dc6),   X0213(0x8dc8),
    /* 28               29               30               31               */
       X0213(0x8dd9),   X0213(0x8dec),   X0213(0x8e0c),   X0213(0x47fd),
    /* 32               33               34               35               */
       X0213(0x8dfd),   X0213(0x8e06),   X0213NB(0xd860), X0213(0x8e14),
    /* 36               37               38               39               */
       X0213(0x8e16),   X0213(0x8e21),   X0213(0x8e22),   X0213(0x8e27),
    /* 40               41               42               43               */
       X0213NB(0xd860), X0213(0x4816),   X0213(0x8e36),   X0213(0x8e39),
    /* 44               45               46               47               */
       X0213(0x8e4b),   X0213(0x8e54),   X0213(0x8e62),   X0213(0x8e6c),
    /* 48               49               50               51               */
       X0213(0x8e6d),   X0213(0x8e6f),   X0213(0x8e98),   X0213(0x8e9e),
    /* 52               53               54               55               */
       X0213(0x8eae),   X0213(0x8eb3),   X0213(0x8eb5),   X0213(0x8eb6),
    /* 56               57               58               59               */
       X0213(0x8ebb),   X0213NB(0xd860), X0213(0x8ed1),   X0213(0x8ed4),
    /* 60               61               62               63               */
       X0213(0x484e),   X0213(0x8ef9),   X0213NB(0xd860), X0213(0x8f00),
    /* 64               65               66               67               */
       X0213(0x8f08),   X0213(0x8f17),   X0213(0x8f2b),   X0213(0x8f40),
    /* 68               69               70               71               */
       X0213(0x8f4a),   X0213(0x8f58),   X0213NB(0xd861), X0213(0x8fa4),
    /* 72               73               74               75               */
       X0213(0x8fb4),   X0213(0xfa66),   X0213(0x8fb6),   X0213NB(0xd861),
    /* 76               77               78               79               */
       X0213(0x8fc1),   X0213(0x8fc6),   X0213(0xfa24),   X0213(0x8fca),
    /* 80               81               82               83               */
       X0213(0x8fcd),   X0213(0x8fd3),   X0213(0x8fd5),   X0213(0x8fe0),
    /* 84               85               86               87               */
       X0213(0x8ff1),   X0213(0x8ff5),   X0213(0x8ffb),   X0213(0x9002),
    /* 88               89               90               91               */
       X0213(0x900c),   X0213(0x9037),   X0213NB(0xd861), X0213(0x9043),
    /* 92               93               94                                */
       X0213(0x9044),   X0213(0x905d),   X0213NB(0xd861),
/* JIS X 0213 plane 2 row 90 */
    /*                   1                2                3               */
                        X0213NB(0xd861), X0213(0x9085),   X0213(0x908c),
    /*  4                5                6                7               */
       X0213(0x9090),   X0213(0x961d),   X0213(0x90a1),   X0213(0x48b5),
    /*  8                9               10               11               */
       X0213(0x90b0),   X0213(0x90b6),   X0213(0x90c3),   X0213(0x90c8),
    /* 12               13               14               15               */
       X0213NB(0xd861), X0213(0x90dc),   X0213(0x90df),   X0213NB(0xd861),
    /* 16               17               18               19               */
       X0213(0x90f6),   X0213(0x90f2),   X0213(0x9100),   X0213(0x90eb),
    /* 20               21               22               23               */
       X0213(0x90fe),   X0213(0x90ff),   X0213(0x9104),   X0213(0x9106),
    /* 24               25               26               27               */
       X0213(0x9118),   X0213(0x911c),   X0213(0x911e),   X0213(0x9137),
    /* 28               29               30               31               */
       X0213(0x9139),   X0213(0x913a),   X0213(0x9146),   X0213(0x9147),
    /* 32               33               34               35               */
       X0213(0x9157),   X0213(0x9159),   X0213(0x9161),   X0213(0x9164),
    /* 36               37               38               39               */
       X0213(0x9174),   X0213(0x9179),   X0213(0x9185),   X0213(0x918e),
    /* 40               41               42               43               */
       X0213(0x91a8),   X0213(0x91ae),   X0213(0x91b3),   X0213(0x91b6),
    /* 44               45               46               47               */
       X0213(0x91c3),   X0213(0x91c4),   X0213(0x91da),   X0213NB(0xd862),
    /* 48               49               50               51               */
       X0213NB(0xd862), X0213(0x91ec),   X0213(0x91ee),   X0213(0x9201),
    /* 52               53               54               55               */
       X0213(0x920a),   X0213(0x9216),   X0213(0x9217),   X0213NB(0xd862),
    /* 56               57               58               59               */
       X0213(0x9233),   X0213(0x9242),   X0213(0x9247),   X0213(0x924a),
    /* 60               61               62               63               */
       X0213(0x924e),   X0213(0x9251),   X0213(0x9256),   X0213(0x9259),
    /* 64               65               66               67               */
       X0213(0x9260),   X0213(0x9261),   X0213(0x9265),   X0213(0x9267),
    /* 68               69               70               71               */
       X0213(0x9268),   X0213NB(0xd862), X0213NB(0xd862), X0213(0x927c),
    /* 72               73               74               75               */
       X0213(0x927d),   X0213(0x927f),   X0213(0x9289),   X0213(0x928d),
    /* 76               77               78               79               */
       X0213(0x9297),   X0213(0x9299),   X0213(0x929f),   X0213(0x92a7),
    /* 80               81               82               83               */
       X0213(0x92ab),   X0213NB(0xd862), X0213NB(0xd862), X0213(0x92b2),
    /* 84               85               86               87               */
       X0213(0x92bf),   X0213(0x92c0),   X0213(0x92c6),   X0213(0x92ce),
    /* 88               89               90               91               */
       X0213(0x92d0),   X0213(0x92d7),   X0213(0x92d9),   X0213(0x92e5),
    /* 92               93               94                                */
       X0213(0x92e7),   X0213(0x9311),   X0213NB(0xd862),
/* JIS X 0213 plane 2 row 91 */
    /*                   1                2                3               */
                        X0213NB(0xd862), X0213(0x92f7),   X0213(0x92f9),
    /*  4                5                6                7               */
       X0213(0x92fb),   X0213(0x9302),   X0213(0x930d),   X0213(0x9315),
    /*  8                9               10               11               */
       X0213(0x931d),   X0213(0x931e),   X0213(0x9327),   X0213(0x9329),
    /* 12               13               14               15               */
       X0213NB(0xd862), X0213NB(0xd862), X0213(0x9347),   X0213(0x9351),
    /* 16               17               18               19               */
       X0213(0x9357),   X0213(0x935a),   X0213(0x936b),   X0213(0x9371),
    /* 20               21               22               23               */
       X0213(0x9373),   X0213(0x93a1),   X0213NB(0xd862), X0213NB(0xd862),
    /* 24               25               26               27               */
       X0213(0x9388),   X0213(0x938b),   X0213(0x938f),   X0213(0x939e),
    /* 28               29               30               31               */
       X0213(0x93f5),   X0213NB(0xd862), X0213NB(0xd862), X0213(0x93f1),
    /* 32               33               34               35               */
       X0213(0x93c1),   X0213(0x93c7),   X0213(0x93dc),   X0213(0x93e2),
    /* 36               37               38               39               */
       X0213(0x93e7),   X0213(0x9409),   X0213(0x940f),   X0213(0x9416),
    /* 40               41               42               43               */
       X0213(0x9417),   X0213(0x93fb),   X0213(0x9432),   X0213(0x9434),
    /* 44               45               46               47               */
       X0213(0x943b),   X0213(0x9445),   X0213NB(0xd862), X0213NB(0xd862),
    /* 48               49               50               51               */
       X0213(0x946d),   X0213(0x946f),   X0213(0x9578),   X0213(0x9579),
    /* 52               53               54               55               */
       X0213(0x9586),   X0213(0x958c),   X0213(0x958d),   X0213NB(0xd863),
    /* 56               57               58               59               */
       X0213(0x95ab),   X0213(0x95b4),   X0213NB(0xd863), X0213(0x95c8),
    /* 60               61               62               63               */
       X0213NB(0xd863), X0213NB(0xd863), X0213(0x962c),   X0213(0x9633),
    /* 64               65               66               67               */
       X0213(0x9634),   X0213NB(0xd863), X0213(0x963c),   X0213(0x9641),
    /* 68               69               70               71               */
       X0213(0x9661),   X0213NB(0xd863), X0213(0x9682),   X0213NB(0xd863),
    /* 72               73               74               75               */
       X0213(0x969a),   X0213NB(0xd863), X0213(0x49e7),   X0213(0x96a9),
    /* 76               77               78               79               */
       X0213(0x96af),   X0213(0x96b3),   X0213(0x96ba),   X0213(0x96bd),
    /* 80               81               82               83               */
       X0213(0x49fa),   X0213NB(0xd863), X0213(0x96d8),   X0213(0x96da),
    /* 84               85               86               87               */
       X0213(0x96dd),   X0213(0x4a04),   X0213(0x9714),   X0213(0x9723),
    /* 88               89               90               91               */
       X0213(0x4a29),   X0213(0x9736),   X0213(0x9741),   X0213(0x9747),
    /* 92               93               94                                */
       X0213(0x9755),   X0213(0x9757),   X0213(0x975b),
/* JIS X 0213 plane 2 row 92 */
    /*                   1                2                3               */
                        X0213(0x976a),   X0213NB(0xd864), X0213NB(0xd864),
    /*  4                5                6                7               */
       X0213(0x9796),   X0213(0x979a),   X0213(0x979e),   X0213(0x97a2),
    /*  8                9               10               11               */
       X0213(0x97b1),   X0213(0x97b2),   X0213(0x97be),   X0213(0x97cc),
    /* 12               13               14               15               */
       X0213(0x97d1),   X0213(0x97d4),   X0213(0x97d8),   X0213(0x97d9),
    /* 16               17               18               19               */
       X0213(0x97e1),   X0213(0x97f1),   X0213(0x9804),   X0213(0x980d),
    /* 20               21               22               23               */
       X0213(0x980e),   X0213(0x9814),   X0213(0x9816),   X0213(0x4abc),
    /* 24               25               26               27               */
       X0213NB(0xd865), X0213(0x9823),   X0213(0x9832),   X0213(0x9833),
    /* 28               29               30               31               */
       X0213(0x9825),   X0213(0x9847),   X0213(0x9866),   X0213(0x98ab),
    /* 32               33               34               35               */
       X0213(0x98ad),   X0213(0x98b0),   X0213NB(0xd865), X0213(0x98b7),
    /* 36               37               38               39               */
       X0213(0x98b8),   X0213(0x98bb),   X0213(0x98bc),   X0213(0x98bf),
    /* 40               41               42               43               */
       X0213(0x98c2),   X0213(0x98c7),   X0213(0x98cb),   X0213(0x98e0),
    /* 44               45               46               47               */
       X0213NB(0xd865), X0213(0x98e1),   X0213(0x98e3),   X0213(0x98e5),
    /* 48               49               50               51               */
       X0213(0x98ea),   X0213(0x98f0),   X0213(0x98f1),   X0213(0x98f3),
    /* 52               53               54               55               */
       X0213(0x9908),   X0213(0x4b3b),   X0213NB(0xd865), X0213(0x9916),
    /* 56               57               58               59               */
       X0213(0x9917),   X0213NB(0xd865), X0213(0x991a),   X0213(0x991b),
    /* 60               61               62               63               */
       X0213(0x991c),   X0213NB(0xd865), X0213(0x9931),   X0213(0x9932),
    /* 64               65               66               67               */
       X0213(0x9933),   X0213(0x993a),   X0213(0x993b),   X0213(0x993c),
    /* 68               69               70               71               */
       X0213(0x9940),   X0213(0x9941),   X0213(0x9946),   X0213(0x994d),
    /* 72               73               74               75               */
       X0213(0x994e),   X0213(0x995c),   X0213(0x995f),   X0213(0x9960),
    /* 76               77               78               79               */
       X0213(0x99a3),   X0213(0x99a6),   X0213(0x99b9),   X0213(0x99bd),
    /* 80               81               82               83               */
       X0213(0x99bf),   X0213(0x99c3),   X0213(0x99c9),   X0213(0x99d4),
    /* 84               85               86               87               */
       X0213(0x99d9),   X0213(0x99de),   X0213NB(0xd866), X0213(0x99f0),
    /* 88               89               90               91               */
       X0213(0x99f9),   X0213(0x99fc),   X0213(0x9a0a),   X0213(0x9a11),
    /* 92               93               94                                */
       X0213(0x9a16),   X0213(0x9a1a),   X0213(0x9a20),
/* JIS X 0213 plane 2 row 93 */
    /*                   1                2                3               */
                        X0213(0x9a31),   X0213(0x9a36),   X0213(0x9a44),
    /*  4                5                6                7               */
       X0213(0x9a4c),   X0213(0x9a58),   X0213(0x4bc2),   X0213(0x9aaf),
    /*  8                9               10               11               */
       X0213(0x4bca),   X0213(0x9ab7),   X0213(0x4bd2),   X0213(0x9ab9),
    /* 12               13               14               15               */
       X0213NB(0xd866), X0213(0x9ac6),   X0213(0x9ad0),   X0213(0x9ad2),
    /* 16               17               18               19               */
       X0213(0x9ad5),   X0213(0x4be8),   X0213(0x9adc),   X0213(0x9ae0),
    /* 20               21               22               23               */
       X0213(0x9ae5),   X0213(0x9ae9),   X0213(0x9b03),   X0213(0x9b0c),
    /* 24               25               26               27               */
       X0213(0x9b10),   X0213(0x9b12),   X0213(0x9b16),   X0213(0x9b1d),
    /* 28               29               30               31               */
       X0213(0x9b2b),   X0213(0x9b33),   X0213(0x9b3d),   X0213(0x4c20),
    /* 32               33               34               35               */
       X0213(0x9b4b),   X0213(0x9b63),   X0213(0x9b65),   X0213(0x9b6b),
    /* 36               37               38               39               */
       X0213(0x9b6c),   X0213(0x9b73),   X0213(0x9b76),   X0213(0x9b77),
    /* 40               41               42               43               */
       X0213(0x9ba6),   X0213(0x9bac),   X0213(0x9bb1),   X0213NB(0xd867),
    /* 44               45               46               47               */
       X0213NB(0xd867), X0213(0x9bb2),   X0213(0x9bb8),   X0213(0x9bbe),
    /* 48               49               50               51               */
       X0213(0x9bc7),   X0213(0x9bf3),   X0213(0x9bd8),   X0213(0x9bdd),
    /* 52               53               54               55               */
       X0213(0x9be7),   X0213(0x9bea),   X0213(0x9beb),   X0213(0x9bef),
    /* 56               57               58               59               */
       X0213(0x9bee),   X0213NB(0xd867), X0213(0x9bfa),   X0213NB(0xd867),
    /* 60               61               62               63               */
       X0213(0x9bf7),   X0213NB(0xd867), X0213(0x9c16),   X0213(0x9c18),
    /* 64               65               66               67               */
       X0213(0x9c19),   X0213(0x9c1a),   X0213(0x9c1d),   X0213(0x9c22),
    /* 68               69               70               71               */
       X0213(0x9c27),   X0213(0x9c29),   X0213(0x9c2a),   X0213NB(0xd867),
    /* 72               73               74               75               */
       X0213(0x9c31),   X0213(0x9c36),   X0213(0x9c37),   X0213(0x9c45),
    /* 76               77               78               79               */
       X0213(0x9c5c),   X0213NB(0xd867), X0213(0x9c49),   X0213(0x9c4a),
    /* 80               81               82               83               */
       X0213NB(0xd867), X0213(0x9c54),   X0213(0x9c58),   X0213(0x9c5b),
    /* 84               85               86               87               */
       X0213(0x9c5d),   X0213(0x9c5f),   X0213(0x9c69),   X0213(0x9c6a),
    /* 88               89               90               91               */
       X0213(0x9c6b),   X0213(0x9c6d),   X0213(0x9c6e),   X0213(0x9c70),
    /* 92               93               94                                */
       X0213(0x9c72),   X0213(0x9c75),   X0213(0x9c7a),
/* JIS X 0213 plane 2 row 94 */
    /*                   1                2                3               */
                        X0213(0x9ce6),   X0213(0x9cf2),   X0213(0x9d0b),
    /*  4                5                6                7               */
       X0213(0x9d02),   X0213NB(0xd867), X0213(0x9d11),   X0213(0x9d17),
    /*  8                9               10               11               */
       X0213(0x9d18),   X0213NB(0xd868), X0213(0x4cc4),   X0213NB(0xd868),
    /* 12               13               14               15               */
       X0213(0x9d32),   X0213(0x4cd1),   X0213(0x9d42),   X0213(0x9d4a),
    /* 16               17               18               19               */
       X0213(0x9d5f),   X0213(0x9d62),   X0213NB(0xd868), X0213(0x9d69),
    /* 20               21               22               23               */
       X0213(0x9d6b),   X0213NB(0xd868), X0213(0x9d73),   X0213(0x9d76),
    /* 24               25               26               27               */
       X0213(0x9d77),   X0213(0x9d7e),   X0213(0x9d84),   X0213(0x9d8d),
    /* 28               29               30               31               */
       X0213(0x9d99),   X0213(0x9da1),   X0213(0x9dbf),   X0213(0x9db5),
    /* 32               33               34               35               */
       X0213(0x9db9),   X0213(0x9dbd),   X0213(0x9dc3),   X0213(0x9dc7),
    /* 36               37               38               39               */
       X0213(0x9dc9),   X0213(0x9dd6),   X0213(0x9dda),   X0213(0x9ddf),
    /* 40               41               42               43               */
       X0213(0x9de0),   X0213(0x9de3),   X0213(0x9df4),   X0213(0x4d07),
    /* 44               45               46               47               */
       X0213(0x9e0a),   X0213(0x9e02),   X0213(0x9e0d),   X0213(0x9e19),
    /* 48               49               50               51               */
       X0213(0x9e1c),   X0213(0x9e1d),   X0213(0x9e7b),   X0213NB(0xd848),
    /* 52               53               54               55               */
       X0213(0x9e80),   X0213(0x9e85),   X0213(0x9e9b),   X0213(0x9ea8),
    /* 56               57               58               59               */
       X0213NB(0xd868), X0213(0x9ebd),   X0213NB(0xd869), X0213(0x9edf),
    /* 60               61               62               63               */
       X0213(0x9ee7),   X0213(0x9eee),   X0213(0x9eff),   X0213(0x9f02),
    /* 64               65               66               67               */
       X0213(0x4d77),   X0213(0x9f03),   X0213(0x9f17),   X0213(0x9f19),
    /* 68               69               70               71               */
       X0213(0x9f2f),   X0213(0x9f37),   X0213(0x9f3a),   X0213(0x9f3d),
    /* 72               73               74               75               */
       X0213(0x9f41),   X0213(0x9f45),   X0213(0x9f46),   X0213(0x9f53),
    /* 76               77               78               79               */
       X0213(0x9f55),   X0213(0x9f58),   X0213NB(0xd869), X0213(0x9f5d),
    /* 80               81               82               83               */
       X0213NB(0xd869), X0213(0x9f69),   X0213NB(0xd869), X0213(0x9f6d),
    /* 84               85               86               87               */
       X0213(0x9f70),   X0213(0x9f75),   X0213NB(0xd869), J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
};
#else	/* !defined(JFP_J2U_ICONV_X0213) */
static const _jfp_ucs2_t _jfp_tbl_jisx0212_to_ucs2[] = {
/* JIS X 0212 row 1 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 2 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, 0x02d8,
    /* 16               17               18               19               */
       0x02c7,          0x00b8,          0x02d9,          0x02dd,
    /* 20               21               22               23               */
       0x00af,          0x02db,          0x02da,          J212U_0223_DEST,
    /* 24               25               26               27               */
       0x0384,          0x0385,          J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
#if	defined(JFP_J2U_ICONV_MS932)
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, 0x00a1,          0xffe4,
#else	/* !defined(JFP_J2U_ICONV_MS932) */
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, 0x00a1,          0x00a6,
#endif	/* defined(JFP_J2U_ICONV_MS932) */
    /* 36               37               38               39               */
       0x00bf,          J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, 0x00ba,
    /* 76               77               78               79               */
       0x00aa,          0x00a9,          0x00ae,          0x2122,
    /* 80               81               82               83               */
       0x00a4,          0x2116,          J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 3 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 4 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 5 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 6 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, 0x0386,          0x0388,          0x0389,
    /* 68               69               70               71               */
       0x038a,          0x03aa,          J2U_NODEST_COL2, 0x038c,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, 0x038e,          0x03ab,          J2U_NODEST_COL2,
    /* 76               77               78               79               */
       0x038f,          J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, 0x03ac,          0x03ad,          0x03ae,
    /* 84               85               86               87               */
       0x03af,          0x03ca,          0x0390,          0x03cc,
    /* 88               89               90               91               */
       0x03c2,          0x03cd,          0x03cb,          0x03b0,
    /* 92               93               94                                */
       0x03ce,          J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 7 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, 0x0402,          0x0403,
    /* 36               37               38               39               */
       0x0404,          0x0405,          0x0406,          0x0407,
    /* 40               41               42               43               */
       0x0408,          0x0409,          0x040a,          0x040b,
    /* 44               45               46               47               */
       0x040c,          0x040e,          0x040f,          J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, 0x0452,          0x0453,
    /* 84               85               86               87               */
       0x0454,          0x0455,          0x0456,          0x0457,
    /* 88               89               90               91               */
       0x0458,          0x0459,          0x045a,          0x045b,
    /* 92               93               94                                */
       0x045c,          0x045e,          0x045f,
/* JIS X 0212 row 8 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 9 */
    /*                   1                2                3               */
                        0x00c6,          0x0110,          J2U_NODEST_COL2,
    /*  4                5                6                7               */
       0x0126,          J2U_NODEST_COL2, 0x0132,          J2U_NODEST_COL2,
    /*  8                9               10               11               */
       0x0141,          0x013f,          J2U_NODEST_COL2, 0x014a,
    /* 12               13               14               15               */
       0x00d8,          0x0152,          J2U_NODEST_COL2, 0x0166,
    /* 16               17               18               19               */
       0x00de,          J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, 0x00e6,          0x0111,          0x00f0,
    /* 36               37               38               39               */
       0x0127,          0x0131,          0x0133,          0x0138,
    /* 40               41               42               43               */
       0x0142,          0x0140,          0x0149,          0x014b,
    /* 44               45               46               47               */
       0x00f8,          0x0153,          0x00df,          0x0167,
    /* 48               49               50               51               */
       0x00fe,          J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 10 */
    /*                   1                2                3               */
                        0x00c1,          0x00c0,          0x00c4,
    /*  4                5                6                7               */
       0x00c2,          0x0102,          0x01cd,          0x0100,
    /*  8                9               10               11               */
       0x0104,          0x00c5,          0x00c3,          0x0106,
    /* 12               13               14               15               */
       0x0108,          0x010c,          0x00c7,          0x010a,
    /* 16               17               18               19               */
       0x010e,          0x00c9,          0x00c8,          0x00cb,
    /* 20               21               22               23               */
       0x00ca,          0x011a,          0x0116,          0x0112,
    /* 24               25               26               27               */
       0x0118,          J2U_NODEST_COL2, 0x011c,          0x011e,
    /* 28               29               30               31               */
       0x0122,          0x0120,          0x0124,          0x00cd,
    /* 32               33               34               35               */
       0x00cc,          0x00cf,          0x00ce,          0x01cf,
    /* 36               37               38               39               */
       0x0130,          0x012a,          0x012e,          0x0128,
    /* 40               41               42               43               */
       0x0134,          0x0136,          0x0139,          0x013d,
    /* 44               45               46               47               */
       0x013b,          0x0143,          0x0147,          0x0145,
    /* 48               49               50               51               */
       0x00d1,          0x00d3,          0x00d2,          0x00d6,
    /* 52               53               54               55               */
       0x00d4,          0x01d1,          0x0150,          0x014c,
    /* 56               57               58               59               */
       0x00d5,          0x0154,          0x0158,          0x0156,
    /* 60               61               62               63               */
       0x015a,          0x015c,          0x0160,          0x015e,
    /* 64               65               66               67               */
       0x0164,          0x0162,          0x00da,          0x00d9,
    /* 68               69               70               71               */
       0x00dc,          0x00db,          0x016c,          0x01d3,
    /* 72               73               74               75               */
       0x0170,          0x016a,          0x0172,          0x016e,
    /* 76               77               78               79               */
       0x0168,          0x01d7,          0x01db,          0x01d9,
    /* 80               81               82               83               */
       0x01d5,          0x0174,          0x00dd,          0x0178,
    /* 84               85               86               87               */
       0x0176,          0x0179,          0x017d,          0x017b,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 11 */
    /*                   1                2                3               */
                        0x00e1,          0x00e0,          0x00e4,
    /*  4                5                6                7               */
       0x00e2,          0x0103,          0x01ce,          0x0101,
    /*  8                9               10               11               */
       0x0105,          0x00e5,          0x00e3,          0x0107,
    /* 12               13               14               15               */
       0x0109,          0x010d,          0x00e7,          0x010b,
    /* 16               17               18               19               */
       0x010f,          0x00e9,          0x00e8,          0x00eb,
    /* 20               21               22               23               */
       0x00ea,          0x011b,          0x0117,          0x0113,
    /* 24               25               26               27               */
       0x0119,          0x01f5,          0x011d,          0x011f,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, 0x0121,          0x0125,          0x00ed,
    /* 32               33               34               35               */
       0x00ec,          0x00ef,          0x00ee,          0x01d0,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, 0x012b,          0x012f,          0x0129,
    /* 40               41               42               43               */
       0x0135,          0x0137,          0x013a,          0x013e,
    /* 44               45               46               47               */
       0x013c,          0x0144,          0x0148,          0x0146,
    /* 48               49               50               51               */
       0x00f1,          0x00f3,          0x00f2,          0x00f6,
    /* 52               53               54               55               */
       0x00f4,          0x01d2,          0x0151,          0x014d,
    /* 56               57               58               59               */
       0x00f5,          0x0155,          0x0159,          0x0157,
    /* 60               61               62               63               */
       0x015b,          0x015d,          0x0161,          0x015f,
    /* 64               65               66               67               */
       0x0165,          0x0163,          0x00fa,          0x00f9,
    /* 68               69               70               71               */
       0x00fc,          0x00fb,          0x016d,          0x01d4,
    /* 72               73               74               75               */
       0x0171,          0x016b,          0x0173,          0x016f,
    /* 76               77               78               79               */
       0x0169,          0x01d8,          0x01dc,          0x01da,
    /* 80               81               82               83               */
       0x01d6,          0x0175,          0x00fd,          0x00ff,
    /* 84               85               86               87               */
       0x0177,          0x017a,          0x017e,          0x017c,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 12 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 13 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 14 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 15 */
    /*                   1                2                3               */
                        J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  4                5                6                7               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /*  8                9               10               11               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 12               13               14               15               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 16               17               18               19               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 20               21               22               23               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 24               25               26               27               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 28               29               30               31               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 32               33               34               35               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 36               37               38               39               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 40               41               42               43               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 44               45               46               47               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 48               49               50               51               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 52               53               54               55               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 56               57               58               59               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 60               61               62               63               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 64               65               66               67               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 68               69               70               71               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 72               73               74               75               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 76               77               78               79               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 80               81               82               83               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 84               85               86               87               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 88               89               90               91               */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
    /* 92               93               94                                */
       J2U_NODEST_COL2, J2U_NODEST_COL2, J2U_NODEST_COL2,
/* JIS X 0212 row 16 */
    /*                   1                2                3               */
                        0x4e02,          0x4e04,          0x4e05,
    /*  4                5                6                7               */
       0x4e0c,          0x4e12,          0x4e1f,          0x4e23,
    /*  8                9               10               11               */
       0x4e24,          0x4e28,          0x4e2b,          0x4e2e,
    /* 12               13               14               15               */
       0x4e2f,          0x4e30,          0x4e35,          0x4e40,
    /* 16               17               18               19               */
       0x4e41,          0x4e44,          0x4e47,          0x4e51,
    /* 20               21               22               23               */
       0x4e5a,          0x4e5c,          0x4e63,          0x4e68,
    /* 24               25               26               27               */
       0x4e69,          0x4e74,          0x4e75,          0x4e79,
    /* 28               29               30               31               */
       0x4e7f,          0x4e8d,          0x4e96,          0x4e97,
    /* 32               33               34               35               */
       0x4e9d,          0x4eaf,          0x4eb9,          0x4ec3,
    /* 36               37               38               39               */
       0x4ed0,          0x4eda,          0x4edb,          0x4ee0,
    /* 40               41               42               43               */
       0x4ee1,          0x4ee2,          0x4ee8,          0x4eef,
    /* 44               45               46               47               */
       0x4ef1,          0x4ef3,          0x4ef5,          0x4efd,
    /* 48               49               50               51               */
       0x4efe,          0x4eff,          0x4f00,          0x4f02,
    /* 52               53               54               55               */
       0x4f03,          0x4f08,          0x4f0b,          0x4f0c,
    /* 56               57               58               59               */
       0x4f12,          0x4f15,          0x4f16,          0x4f17,
    /* 60               61               62               63               */
       0x4f19,          0x4f2e,          0x4f31,          0x4f60,
    /* 64               65               66               67               */
       0x4f33,          0x4f35,          0x4f37,          0x4f39,
    /* 68               69               70               71               */
       0x4f3b,          0x4f3e,          0x4f40,          0x4f42,
    /* 72               73               74               75               */
       0x4f48,          0x4f49,          0x4f4b,          0x4f4c,
    /* 76               77               78               79               */
       0x4f52,          0x4f54,          0x4f56,          0x4f58,
    /* 80               81               82               83               */
       0x4f5f,          0x4f63,          0x4f6a,          0x4f6c,
    /* 84               85               86               87               */
       0x4f6e,          0x4f71,          0x4f77,          0x4f78,
    /* 88               89               90               91               */
       0x4f79,          0x4f7a,          0x4f7d,          0x4f7e,
    /* 92               93               94                                */
       0x4f81,          0x4f82,          0x4f84,
/* JIS X 0212 row 17 */
    /*                   1                2                3               */
                        0x4f85,          0x4f89,          0x4f8a,
    /*  4                5                6                7               */
       0x4f8c,          0x4f8e,          0x4f90,          0x4f92,
    /*  8                9               10               11               */
       0x4f93,          0x4f94,          0x4f97,          0x4f99,
    /* 12               13               14               15               */
       0x4f9a,          0x4f9e,          0x4f9f,          0x4fb2,
    /* 16               17               18               19               */
       0x4fb7,          0x4fb9,          0x4fbb,          0x4fbc,
    /* 20               21               22               23               */
       0x4fbd,          0x4fbe,          0x4fc0,          0x4fc1,
    /* 24               25               26               27               */
       0x4fc5,          0x4fc6,          0x4fc8,          0x4fc9,
    /* 28               29               30               31               */
       0x4fcb,          0x4fcc,          0x4fcd,          0x4fcf,
    /* 32               33               34               35               */
       0x4fd2,          0x4fdc,          0x4fe0,          0x4fe2,
    /* 36               37               38               39               */
       0x4ff0,          0x4ff2,          0x4ffc,          0x4ffd,
    /* 40               41               42               43               */
       0x4fff,          0x5000,          0x5001,          0x5004,
    /* 44               45               46               47               */
       0x5007,          0x500a,          0x500c,          0x500e,
    /* 48               49               50               51               */
       0x5010,          0x5013,          0x5017,          0x5018,
    /* 52               53               54               55               */
       0x501b,          0x501c,          0x501d,          0x501e,
    /* 56               57               58               59               */
       0x5022,          0x5027,          0x502e,          0x5030,
    /* 60               61               62               63               */
       0x5032,          0x5033,          0x5035,          0x5040,
    /* 64               65               66               67               */
       0x5041,          0x5042,          0x5045,          0x5046,
    /* 68               69               70               71               */
       0x504a,          0x504c,          0x504e,          0x5051,
    /* 72               73               74               75               */
       0x5052,          0x5053,          0x5057,          0x5059,
    /* 76               77               78               79               */
       0x505f,          0x5060,          0x5062,          0x5063,
    /* 80               81               82               83               */
       0x5066,          0x5067,          0x506a,          0x506d,
    /* 84               85               86               87               */
       0x5070,          0x5071,          0x503b,          0x5081,
    /* 88               89               90               91               */
       0x5083,          0x5084,          0x5086,          0x508a,
    /* 92               93               94                                */
       0x508e,          0x508f,          0x5090,
/* JIS X 0212 row 18 */
    /*                   1                2                3               */
                        0x5092,          0x5093,          0x5094,
    /*  4                5                6                7               */
       0x5096,          0x509b,          0x509c,          0x509e,
    /*  8                9               10               11               */
       0x509f,          0x50a0,          0x50a1,          0x50a2,
    /* 12               13               14               15               */
       0x50aa,          0x50af,          0x50b0,          0x50b9,
    /* 16               17               18               19               */
       0x50ba,          0x50bd,          0x50c0,          0x50c3,
    /* 20               21               22               23               */
       0x50c4,          0x50c7,          0x50cc,          0x50ce,
    /* 24               25               26               27               */
       0x50d0,          0x50d3,          0x50d4,          0x50d8,
    /* 28               29               30               31               */
       0x50dc,          0x50dd,          0x50df,          0x50e2,
    /* 32               33               34               35               */
       0x50e4,          0x50e6,          0x50e8,          0x50e9,
    /* 36               37               38               39               */
       0x50ef,          0x50f1,          0x50f6,          0x50fa,
    /* 40               41               42               43               */
       0x50fe,          0x5103,          0x5106,          0x5107,
    /* 44               45               46               47               */
       0x5108,          0x510b,          0x510c,          0x510d,
    /* 48               49               50               51               */
       0x510e,          0x50f2,          0x5110,          0x5117,
    /* 52               53               54               55               */
       0x5119,          0x511b,          0x511c,          0x511d,
    /* 56               57               58               59               */
       0x511e,          0x5123,          0x5127,          0x5128,
    /* 60               61               62               63               */
       0x512c,          0x512d,          0x512f,          0x5131,
    /* 64               65               66               67               */
       0x5133,          0x5134,          0x5135,          0x5138,
    /* 68               69               70               71               */
       0x5139,          0x5142,          0x514a,          0x514f,
    /* 72               73               74               75               */
       0x5153,          0x5155,          0x5157,          0x5158,
    /* 76               77               78               79               */
       0x515f,          0x5164,          0x5166,          0x517e,
    /* 80               81               82               83               */
       0x5183,          0x5184,          0x518b,          0x518e,
    /* 84               85               86               87               */
       0x5198,          0x519d,          0x51a1,          0x51a3,
    /* 88               89               90               91               */
       0x51ad,          0x51b8,          0x51ba,          0x51bc,
    /* 92               93               94                                */
       0x51be,          0x51bf,          0x51c2,
/* JIS X 0212 row 19 */
    /*                   1                2                3               */
                        0x51c8,          0x51cf,          0x51d1,
    /*  4                5                6                7               */
       0x51d2,          0x51d3,          0x51d5,          0x51d8,
    /*  8                9               10               11               */
       0x51de,          0x51e2,          0x51e5,          0x51ee,
    /* 12               13               14               15               */
       0x51f2,          0x51f3,          0x51f4,          0x51f7,
    /* 16               17               18               19               */
       0x5201,          0x5202,          0x5205,          0x5212,
    /* 20               21               22               23               */
       0x5213,          0x5215,          0x5216,          0x5218,
    /* 24               25               26               27               */
       0x5222,          0x5228,          0x5231,          0x5232,
    /* 28               29               30               31               */
       0x5235,          0x523c,          0x5245,          0x5249,
    /* 32               33               34               35               */
       0x5255,          0x5257,          0x5258,          0x525a,
    /* 36               37               38               39               */
       0x525c,          0x525f,          0x5260,          0x5261,
    /* 40               41               42               43               */
       0x5266,          0x526e,          0x5277,          0x5278,
    /* 44               45               46               47               */
       0x5279,          0x5280,          0x5282,          0x5285,
    /* 48               49               50               51               */
       0x528a,          0x528c,          0x5293,          0x5295,
    /* 52               53               54               55               */
       0x5296,          0x5297,          0x5298,          0x529a,
    /* 56               57               58               59               */
       0x529c,          0x52a4,          0x52a5,          0x52a6,
    /* 60               61               62               63               */
       0x52a7,          0x52af,          0x52b0,          0x52b6,
    /* 64               65               66               67               */
       0x52b7,          0x52b8,          0x52ba,          0x52bb,
    /* 68               69               70               71               */
       0x52bd,          0x52c0,          0x52c4,          0x52c6,
    /* 72               73               74               75               */
       0x52c8,          0x52cc,          0x52cf,          0x52d1,
    /* 76               77               78               79               */
       0x52d4,          0x52d6,          0x52db,          0x52dc,
    /* 80               81               82               83               */
       0x52e1,          0x52e5,          0x52e8,          0x52e9,
    /* 84               85               86               87               */
       0x52ea,          0x52ec,          0x52f0,          0x52f1,
    /* 88               89               90               91               */
       0x52f4,          0x52f6,          0x52f7,          0x5300,
    /* 92               93               94                                */
       0x5303,          0x530a,          0x530b,
/* JIS X 0212 row 20 */
    /*                   1                2                3               */
                        0x530c,          0x5311,          0x5313,
    /*  4                5                6                7               */
       0x5318,          0x531b,          0x531c,          0x531e,
    /*  8                9               10               11               */
       0x531f,          0x5325,          0x5327,          0x5328,
    /* 12               13               14               15               */
       0x5329,          0x532b,          0x532c,          0x532d,
    /* 16               17               18               19               */
       0x5330,          0x5332,          0x5335,          0x533c,
    /* 20               21               22               23               */
       0x533d,          0x533e,          0x5342,          0x534c,
    /* 24               25               26               27               */
       0x534b,          0x5359,          0x535b,          0x5361,
    /* 28               29               30               31               */
       0x5363,          0x5365,          0x536c,          0x536d,
    /* 32               33               34               35               */
       0x5372,          0x5379,          0x537e,          0x5383,
    /* 36               37               38               39               */
       0x5387,          0x5388,          0x538e,          0x5393,
    /* 40               41               42               43               */
       0x5394,          0x5399,          0x539d,          0x53a1,
    /* 44               45               46               47               */
       0x53a4,          0x53aa,          0x53ab,          0x53af,
    /* 48               49               50               51               */
       0x53b2,          0x53b4,          0x53b5,          0x53b7,
    /* 52               53               54               55               */
       0x53b8,          0x53ba,          0x53bd,          0x53c0,
    /* 56               57               58               59               */
       0x53c5,          0x53cf,          0x53d2,          0x53d3,
    /* 60               61               62               63               */
       0x53d5,          0x53da,          0x53dd,          0x53de,
    /* 64               65               66               67               */
       0x53e0,          0x53e6,          0x53e7,          0x53f5,
    /* 68               69               70               71               */
       0x5402,          0x5413,          0x541a,          0x5421,
    /* 72               73               74               75               */
       0x5427,          0x5428,          0x542a,          0x542f,
    /* 76               77               78               79               */
       0x5431,          0x5434,          0x5435,          0x5443,
    /* 80               81               82               83               */
       0x5444,          0x5447,          0x544d,          0x544f,
    /* 84               85               86               87               */
       0x545e,          0x5462,          0x5464,          0x5466,
    /* 88               89               90               91               */
       0x5467,          0x5469,          0x546b,          0x546d,
    /* 92               93               94                                */
       0x546e,          0x5474,          0x547f,
/* JIS X 0212 row 21 */
    /*                   1                2                3               */
                        0x5481,          0x5483,          0x5485,
    /*  4                5                6                7               */
       0x5488,          0x5489,          0x548d,          0x5491,
    /*  8                9               10               11               */
       0x5495,          0x5496,          0x549c,          0x549f,
    /* 12               13               14               15               */
       0x54a1,          0x54a6,          0x54a7,          0x54a9,
    /* 16               17               18               19               */
       0x54aa,          0x54ad,          0x54ae,          0x54b1,
    /* 20               21               22               23               */
       0x54b7,          0x54b9,          0x54ba,          0x54bb,
    /* 24               25               26               27               */
       0x54bf,          0x54c6,          0x54ca,          0x54cd,
    /* 28               29               30               31               */
       0x54ce,          0x54e0,          0x54ea,          0x54ec,
    /* 32               33               34               35               */
       0x54ef,          0x54f6,          0x54fc,          0x54fe,
    /* 36               37               38               39               */
       0x54ff,          0x5500,          0x5501,          0x5505,
    /* 40               41               42               43               */
       0x5508,          0x5509,          0x550c,          0x550d,
    /* 44               45               46               47               */
       0x550e,          0x5515,          0x552a,          0x552b,
    /* 48               49               50               51               */
       0x5532,          0x5535,          0x5536,          0x553b,
    /* 52               53               54               55               */
       0x553c,          0x553d,          0x5541,          0x5547,
    /* 56               57               58               59               */
       0x5549,          0x554a,          0x554d,          0x5550,
    /* 60               61               62               63               */
       0x5551,          0x5558,          0x555a,          0x555b,
    /* 64               65               66               67               */
       0x555e,          0x5560,          0x5561,          0x5564,
    /* 68               69               70               71               */
       0x5566,          0x557f,          0x5581,          0x5582,
    /* 72               73               74               75               */
       0x5586,          0x5588,          0x558e,          0x558f,
    /* 76               77               78               79               */
       0x5591,          0x5592,          0x5593,          0x5594,
    /* 80               81               82               83               */
       0x5597,          0x55a3,          0x55a4,          0x55ad,
    /* 84               85               86               87               */
       0x55b2,          0x55bf,          0x55c1,          0x55c3,
    /* 88               89               90               91               */
       0x55c6,          0x55c9,          0x55cb,          0x55cc,
    /* 92               93               94                                */
       0x55ce,          0x55d1,          0x55d2,
/* JIS X 0212 row 22 */
    /*                   1                2                3               */
                        0x55d3,          0x55d7,          0x55d8,
    /*  4                5                6                7               */
       0x55db,          0x55de,          0x55e2,          0x55e9,
    /*  8                9               10               11               */
       0x55f6,          0x55ff,          0x5605,          0x5608,
    /* 12               13               14               15               */
       0x560a,          0x560d,          0x560e,          0x560f,
    /* 16               17               18               19               */
       0x5610,          0x5611,          0x5612,          0x5619,
    /* 20               21               22               23               */
       0x562c,          0x5630,          0x5633,          0x5635,
    /* 24               25               26               27               */
       0x5637,          0x5639,          0x563b,          0x563c,
    /* 28               29               30               31               */
       0x563d,          0x563f,          0x5640,          0x5641,
    /* 32               33               34               35               */
       0x5643,          0x5644,          0x5646,          0x5649,
    /* 36               37               38               39               */
       0x564b,          0x564d,          0x564f,          0x5654,
    /* 40               41               42               43               */
       0x565e,          0x5660,          0x5661,          0x5662,
    /* 44               45               46               47               */
       0x5663,          0x5666,          0x5669,          0x566d,
    /* 48               49               50               51               */
       0x566f,          0x5671,          0x5672,          0x5675,
    /* 52               53               54               55               */
       0x5684,          0x5685,          0x5688,          0x568b,
    /* 56               57               58               59               */
       0x568c,          0x5695,          0x5699,          0x569a,
    /* 60               61               62               63               */
       0x569d,          0x569e,          0x569f,          0x56a6,
    /* 64               65               66               67               */
       0x56a7,          0x56a8,          0x56a9,          0x56ab,
    /* 68               69               70               71               */
       0x56ac,          0x56ad,          0x56b1,          0x56b3,
    /* 72               73               74               75               */
       0x56b7,          0x56be,          0x56c5,          0x56c9,
    /* 76               77               78               79               */
       0x56ca,          0x56cb,          0x56cf,          0x56d0,
    /* 80               81               82               83               */
       0x56cc,          0x56cd,          0x56d9,          0x56dc,
    /* 84               85               86               87               */
       0x56dd,          0x56df,          0x56e1,          0x56e4,
    /* 88               89               90               91               */
       0x56e5,          0x56e6,          0x56e7,          0x56e8,
    /* 92               93               94                                */
       0x56f1,          0x56eb,          0x56ed,
/* JIS X 0212 row 23 */
    /*                   1                2                3               */
                        0x56f6,          0x56f7,          0x5701,
    /*  4                5                6                7               */
       0x5702,          0x5707,          0x570a,          0x570c,
    /*  8                9               10               11               */
       0x5711,          0x5715,          0x571a,          0x571b,
    /* 12               13               14               15               */
       0x571d,          0x5720,          0x5722,          0x5723,
    /* 16               17               18               19               */
       0x5724,          0x5725,          0x5729,          0x572a,
    /* 20               21               22               23               */
       0x572c,          0x572e,          0x572f,          0x5733,
    /* 24               25               26               27               */
       0x5734,          0x573d,          0x573e,          0x573f,
    /* 28               29               30               31               */
       0x5745,          0x5746,          0x574c,          0x574d,
    /* 32               33               34               35               */
       0x5752,          0x5762,          0x5765,          0x5767,
    /* 36               37               38               39               */
       0x5768,          0x576b,          0x576d,          0x576e,
    /* 40               41               42               43               */
       0x576f,          0x5770,          0x5771,          0x5773,
    /* 44               45               46               47               */
       0x5774,          0x5775,          0x5777,          0x5779,
    /* 48               49               50               51               */
       0x577a,          0x577b,          0x577c,          0x577e,
    /* 52               53               54               55               */
       0x5781,          0x5783,          0x578c,          0x5794,
    /* 56               57               58               59               */
       0x5797,          0x5799,          0x579a,          0x579c,
    /* 60               61               62               63               */
       0x579d,          0x579e,          0x579f,          0x57a1,
    /* 64               65               66               67               */
       0x5795,          0x57a7,          0x57a8,          0x57a9,
    /* 68               69               70               71               */
       0x57ac,          0x57b8,          0x57bd,          0x57c7,
    /* 72               73               74               75               */
       0x57c8,          0x57cc,          0x57cf,          0x57d5,
    /* 76               77               78               79               */
       0x57dd,          0x57de,          0x57e4,          0x57e6,
    /* 80               81               82               83               */
       0x57e7,          0x57e9,          0x57ed,          0x57f0,
    /* 84               85               86               87               */
       0x57f5,          0x57f6,          0x57f8,          0x57fd,
    /* 88               89               90               91               */
       0x57fe,          0x57ff,          0x5803,          0x5804,
    /* 92               93               94                                */
       0x5808,          0x5809,          0x57e1,
/* JIS X 0212 row 24 */
    /*                   1                2                3               */
                        0x580c,          0x580d,          0x581b,
    /*  4                5                6                7               */
       0x581e,          0x581f,          0x5820,          0x5826,
    /*  8                9               10               11               */
       0x5827,          0x582d,          0x5832,          0x5839,
    /* 12               13               14               15               */
       0x583f,          0x5849,          0x584c,          0x584d,
    /* 16               17               18               19               */
       0x584f,          0x5850,          0x5855,          0x585f,
    /* 20               21               22               23               */
       0x5861,          0x5864,          0x5867,          0x5868,
    /* 24               25               26               27               */
       0x5878,          0x587c,          0x587f,          0x5880,
    /* 28               29               30               31               */
       0x5881,          0x5887,          0x5888,          0x5889,
    /* 32               33               34               35               */
       0x588a,          0x588c,          0x588d,          0x588f,
    /* 36               37               38               39               */
       0x5890,          0x5894,          0x5896,          0x589d,
    /* 40               41               42               43               */
       0x58a0,          0x58a1,          0x58a2,          0x58a6,
    /* 44               45               46               47               */
       0x58a9,          0x58b1,          0x58b2,          0x58c4,
    /* 48               49               50               51               */
       0x58bc,          0x58c2,          0x58c8,          0x58cd,
    /* 52               53               54               55               */
       0x58ce,          0x58d0,          0x58d2,          0x58d4,
    /* 56               57               58               59               */
       0x58d6,          0x58da,          0x58dd,          0x58e1,
    /* 60               61               62               63               */
       0x58e2,          0x58e9,          0x58f3,          0x5905,
    /* 64               65               66               67               */
       0x5906,          0x590b,          0x590c,          0x5912,
    /* 68               69               70               71               */
       0x5913,          0x5914,          0x8641,          0x591d,
    /* 72               73               74               75               */
       0x5921,          0x5923,          0x5924,          0x5928,
    /* 76               77               78               79               */
       0x592f,          0x5930,          0x5933,          0x5935,
    /* 80               81               82               83               */
       0x5936,          0x593f,          0x5943,          0x5946,
    /* 84               85               86               87               */
       0x5952,          0x5953,          0x5959,          0x595b,
    /* 88               89               90               91               */
       0x595d,          0x595e,          0x595f,          0x5961,
    /* 92               93               94                                */
       0x5963,          0x596b,          0x596d,
/* JIS X 0212 row 25 */
    /*                   1                2                3               */
                        0x596f,          0x5972,          0x5975,
    /*  4                5                6                7               */
       0x5976,          0x5979,          0x597b,          0x597c,
    /*  8                9               10               11               */
       0x598b,          0x598c,          0x598e,          0x5992,
    /* 12               13               14               15               */
       0x5995,          0x5997,          0x599f,          0x59a4,
    /* 16               17               18               19               */
       0x59a7,          0x59ad,          0x59ae,          0x59af,
    /* 20               21               22               23               */
       0x59b0,          0x59b3,          0x59b7,          0x59ba,
    /* 24               25               26               27               */
       0x59bc,          0x59c1,          0x59c3,          0x59c4,
    /* 28               29               30               31               */
       0x59c8,          0x59ca,          0x59cd,          0x59d2,
    /* 32               33               34               35               */
       0x59dd,          0x59de,          0x59df,          0x59e3,
    /* 36               37               38               39               */
       0x59e4,          0x59e7,          0x59ee,          0x59ef,
    /* 40               41               42               43               */
       0x59f1,          0x59f2,          0x59f4,          0x59f7,
    /* 44               45               46               47               */
       0x5a00,          0x5a04,          0x5a0c,          0x5a0d,
    /* 48               49               50               51               */
       0x5a0e,          0x5a12,          0x5a13,          0x5a1e,
    /* 52               53               54               55               */
       0x5a23,          0x5a24,          0x5a27,          0x5a28,
    /* 56               57               58               59               */
       0x5a2a,          0x5a2d,          0x5a30,          0x5a44,
    /* 60               61               62               63               */
       0x5a45,          0x5a47,          0x5a48,          0x5a4c,
    /* 64               65               66               67               */
       0x5a50,          0x5a55,          0x5a5e,          0x5a63,
    /* 68               69               70               71               */
       0x5a65,          0x5a67,          0x5a6d,          0x5a77,
    /* 72               73               74               75               */
       0x5a7a,          0x5a7b,          0x5a7e,          0x5a8b,
    /* 76               77               78               79               */
       0x5a90,          0x5a93,          0x5a96,          0x5a99,
    /* 80               81               82               83               */
       0x5a9c,          0x5a9e,          0x5a9f,          0x5aa0,
    /* 84               85               86               87               */
       0x5aa2,          0x5aa7,          0x5aac,          0x5ab1,
    /* 88               89               90               91               */
       0x5ab2,          0x5ab3,          0x5ab5,          0x5ab8,
    /* 92               93               94                                */
       0x5aba,          0x5abb,          0x5abf,
/* JIS X 0212 row 26 */
    /*                   1                2                3               */
                        0x5ac4,          0x5ac6,          0x5ac8,
    /*  4                5                6                7               */
       0x5acf,          0x5ada,          0x5adc,          0x5ae0,
    /*  8                9               10               11               */
       0x5ae5,          0x5aea,          0x5aee,          0x5af5,
    /* 12               13               14               15               */
       0x5af6,          0x5afd,          0x5b00,          0x5b01,
    /* 16               17               18               19               */
       0x5b08,          0x5b17,          0x5b34,          0x5b19,
    /* 20               21               22               23               */
       0x5b1b,          0x5b1d,          0x5b21,          0x5b25,
    /* 24               25               26               27               */
       0x5b2d,          0x5b38,          0x5b41,          0x5b4b,
    /* 28               29               30               31               */
       0x5b4c,          0x5b52,          0x5b56,          0x5b5e,
    /* 32               33               34               35               */
       0x5b68,          0x5b6e,          0x5b6f,          0x5b7c,
    /* 36               37               38               39               */
       0x5b7d,          0x5b7e,          0x5b7f,          0x5b81,
    /* 40               41               42               43               */
       0x5b84,          0x5b86,          0x5b8a,          0x5b8e,
    /* 44               45               46               47               */
       0x5b90,          0x5b91,          0x5b93,          0x5b94,
    /* 48               49               50               51               */
       0x5b96,          0x5ba8,          0x5ba9,          0x5bac,
    /* 52               53               54               55               */
       0x5bad,          0x5baf,          0x5bb1,          0x5bb2,
    /* 56               57               58               59               */
       0x5bb7,          0x5bba,          0x5bbc,          0x5bc0,
    /* 60               61               62               63               */
       0x5bc1,          0x5bcd,          0x5bcf,          0x5bd6,
    /* 64               65               66               67               */
       0x5bd7,          0x5bd8,          0x5bd9,          0x5bda,
    /* 68               69               70               71               */
       0x5be0,          0x5bef,          0x5bf1,          0x5bf4,
    /* 72               73               74               75               */
       0x5bfd,          0x5c0c,          0x5c17,          0x5c1e,
    /* 76               77               78               79               */
       0x5c1f,          0x5c23,          0x5c26,          0x5c29,
    /* 80               81               82               83               */
       0x5c2b,          0x5c2c,          0x5c2e,          0x5c30,
    /* 84               85               86               87               */
       0x5c32,          0x5c35,          0x5c36,          0x5c59,
    /* 88               89               90               91               */
       0x5c5a,          0x5c5c,          0x5c62,          0x5c63,
    /* 92               93               94                                */
       0x5c67,          0x5c68,          0x5c69,
/* JIS X 0212 row 27 */
    /*                   1                2                3               */
                        0x5c6d,          0x5c70,          0x5c74,
    /*  4                5                6                7               */
       0x5c75,          0x5c7a,          0x5c7b,          0x5c7c,
    /*  8                9               10               11               */
       0x5c7d,          0x5c87,          0x5c88,          0x5c8a,
    /* 12               13               14               15               */
       0x5c8f,          0x5c92,          0x5c9d,          0x5c9f,
    /* 16               17               18               19               */
       0x5ca0,          0x5ca2,          0x5ca3,          0x5ca6,
    /* 20               21               22               23               */
       0x5caa,          0x5cb2,          0x5cb4,          0x5cb5,
    /* 24               25               26               27               */
       0x5cba,          0x5cc9,          0x5ccb,          0x5cd2,
    /* 28               29               30               31               */
       0x5cdd,          0x5cd7,          0x5cee,          0x5cf1,
    /* 32               33               34               35               */
       0x5cf2,          0x5cf4,          0x5d01,          0x5d06,
    /* 36               37               38               39               */
       0x5d0d,          0x5d12,          0x5d2b,          0x5d23,
    /* 40               41               42               43               */
       0x5d24,          0x5d26,          0x5d27,          0x5d31,
    /* 44               45               46               47               */
       0x5d34,          0x5d39,          0x5d3d,          0x5d3f,
    /* 48               49               50               51               */
       0x5d42,          0x5d43,          0x5d46,          0x5d48,
    /* 52               53               54               55               */
       0x5d55,          0x5d51,          0x5d59,          0x5d4a,
    /* 56               57               58               59               */
       0x5d5f,          0x5d60,          0x5d61,          0x5d62,
    /* 60               61               62               63               */
       0x5d64,          0x5d6a,          0x5d6d,          0x5d70,
    /* 64               65               66               67               */
       0x5d79,          0x5d7a,          0x5d7e,          0x5d7f,
    /* 68               69               70               71               */
       0x5d81,          0x5d83,          0x5d88,          0x5d8a,
    /* 72               73               74               75               */
       0x5d92,          0x5d93,          0x5d94,          0x5d95,
    /* 76               77               78               79               */
       0x5d99,          0x5d9b,          0x5d9f,          0x5da0,
    /* 80               81               82               83               */
       0x5da7,          0x5dab,          0x5db0,          0x5db4,
    /* 84               85               86               87               */
       0x5db8,          0x5db9,          0x5dc3,          0x5dc7,
    /* 88               89               90               91               */
       0x5dcb,          0x5dd0,          0x5dce,          0x5dd8,
    /* 92               93               94                                */
       0x5dd9,          0x5de0,          0x5de4,
/* JIS X 0212 row 28 */
    /*                   1                2                3               */
                        0x5de9,          0x5df8,          0x5df9,
    /*  4                5                6                7               */
       0x5e00,          0x5e07,          0x5e0d,          0x5e12,
    /*  8                9               10               11               */
       0x5e14,          0x5e15,          0x5e18,          0x5e1f,
    /* 12               13               14               15               */
       0x5e20,          0x5e2e,          0x5e28,          0x5e32,
    /* 16               17               18               19               */
       0x5e35,          0x5e3e,          0x5e4b,          0x5e50,
    /* 20               21               22               23               */
       0x5e49,          0x5e51,          0x5e56,          0x5e58,
    /* 24               25               26               27               */
       0x5e5b,          0x5e5c,          0x5e5e,          0x5e68,
    /* 28               29               30               31               */
       0x5e6a,          0x5e6b,          0x5e6c,          0x5e6d,
    /* 32               33               34               35               */
       0x5e6e,          0x5e70,          0x5e80,          0x5e8b,
    /* 36               37               38               39               */
       0x5e8e,          0x5ea2,          0x5ea4,          0x5ea5,
    /* 40               41               42               43               */
       0x5ea8,          0x5eaa,          0x5eac,          0x5eb1,
    /* 44               45               46               47               */
       0x5eb3,          0x5ebd,          0x5ebe,          0x5ebf,
    /* 48               49               50               51               */
       0x5ec6,          0x5ecc,          0x5ecb,          0x5ece,
    /* 52               53               54               55               */
       0x5ed1,          0x5ed2,          0x5ed4,          0x5ed5,
    /* 56               57               58               59               */
       0x5edc,          0x5ede,          0x5ee5,          0x5eeb,
    /* 60               61               62               63               */
       0x5f02,          0x5f06,          0x5f07,          0x5f08,
    /* 64               65               66               67               */
       0x5f0e,          0x5f19,          0x5f1c,          0x5f1d,
    /* 68               69               70               71               */
       0x5f21,          0x5f22,          0x5f23,          0x5f24,
    /* 72               73               74               75               */
       0x5f28,          0x5f2b,          0x5f2c,          0x5f2e,
    /* 76               77               78               79               */
       0x5f30,          0x5f34,          0x5f36,          0x5f3b,
    /* 80               81               82               83               */
       0x5f3d,          0x5f3f,          0x5f40,          0x5f44,
    /* 84               85               86               87               */
       0x5f45,          0x5f47,          0x5f4d,          0x5f50,
    /* 88               89               90               91               */
       0x5f54,          0x5f58,          0x5f5b,          0x5f60,
    /* 92               93               94                                */
       0x5f63,          0x5f64,          0x5f67,
/* JIS X 0212 row 29 */
    /*                   1                2                3               */
                        0x5f6f,          0x5f72,          0x5f74,
    /*  4                5                6                7               */
       0x5f75,          0x5f78,          0x5f7a,          0x5f7d,
    /*  8                9               10               11               */
       0x5f7e,          0x5f89,          0x5f8d,          0x5f8f,
    /* 12               13               14               15               */
       0x5f96,          0x5f9c,          0x5f9d,          0x5fa2,
    /* 16               17               18               19               */
       0x5fa7,          0x5fab,          0x5fa4,          0x5fac,
    /* 20               21               22               23               */
       0x5faf,          0x5fb0,          0x5fb1,          0x5fb8,
    /* 24               25               26               27               */
       0x5fc4,          0x5fc7,          0x5fc8,          0x5fc9,
    /* 28               29               30               31               */
       0x5fcb,          0x5fd0,          0x5fd1,          0x5fd2,
    /* 32               33               34               35               */
       0x5fd3,          0x5fd4,          0x5fde,          0x5fe1,
    /* 36               37               38               39               */
       0x5fe2,          0x5fe8,          0x5fe9,          0x5fea,
    /* 40               41               42               43               */
       0x5fec,          0x5fed,          0x5fee,          0x5fef,
    /* 44               45               46               47               */
       0x5ff2,          0x5ff3,          0x5ff6,          0x5ffa,
    /* 48               49               50               51               */
       0x5ffc,          0x6007,          0x600a,          0x600d,
    /* 52               53               54               55               */
       0x6013,          0x6014,          0x6017,          0x6018,
    /* 56               57               58               59               */
       0x601a,          0x601f,          0x6024,          0x602d,
    /* 60               61               62               63               */
       0x6033,          0x6035,          0x6040,          0x6047,
    /* 64               65               66               67               */
       0x6048,          0x6049,          0x604c,          0x6051,
    /* 68               69               70               71               */
       0x6054,          0x6056,          0x6057,          0x605d,
    /* 72               73               74               75               */
       0x6061,          0x6067,          0x6071,          0x607e,
    /* 76               77               78               79               */
       0x607f,          0x6082,          0x6086,          0x6088,
    /* 80               81               82               83               */
       0x608a,          0x608e,          0x6091,          0x6093,
    /* 84               85               86               87               */
       0x6095,          0x6098,          0x609d,          0x609e,
    /* 88               89               90               91               */
       0x60a2,          0x60a4,          0x60a5,          0x60a8,
    /* 92               93               94                                */
       0x60b0,          0x60b1,          0x60b7,
/* JIS X 0212 row 30 */
    /*                   1                2                3               */
                        0x60bb,          0x60be,          0x60c2,
    /*  4                5                6                7               */
       0x60c4,          0x60c8,          0x60c9,          0x60ca,
    /*  8                9               10               11               */
       0x60cb,          0x60ce,          0x60cf,          0x60d4,
    /* 12               13               14               15               */
       0x60d5,          0x60d9,          0x60db,          0x60dd,
    /* 16               17               18               19               */
       0x60de,          0x60e2,          0x60e5,          0x60f2,
    /* 20               21               22               23               */
       0x60f5,          0x60f8,          0x60fc,          0x60fd,
    /* 24               25               26               27               */
       0x6102,          0x6107,          0x610a,          0x610c,
    /* 28               29               30               31               */
       0x6110,          0x6111,          0x6112,          0x6113,
    /* 32               33               34               35               */
       0x6114,          0x6116,          0x6117,          0x6119,
    /* 36               37               38               39               */
       0x611c,          0x611e,          0x6122,          0x612a,
    /* 40               41               42               43               */
       0x612b,          0x6130,          0x6131,          0x6135,
    /* 44               45               46               47               */
       0x6136,          0x6137,          0x6139,          0x6141,
    /* 48               49               50               51               */
       0x6145,          0x6146,          0x6149,          0x615e,
    /* 52               53               54               55               */
       0x6160,          0x616c,          0x6172,          0x6178,
    /* 56               57               58               59               */
       0x617b,          0x617c,          0x617f,          0x6180,
    /* 60               61               62               63               */
       0x6181,          0x6183,          0x6184,          0x618b,
    /* 64               65               66               67               */
       0x618d,          0x6192,          0x6193,          0x6197,
    /* 68               69               70               71               */
       0x6198,          0x619c,          0x619d,          0x619f,
    /* 72               73               74               75               */
       0x61a0,          0x61a5,          0x61a8,          0x61aa,
    /* 76               77               78               79               */
       0x61ad,          0x61b8,          0x61b9,          0x61bc,
    /* 80               81               82               83               */
       0x61c0,          0x61c1,          0x61c2,          0x61ce,
    /* 84               85               86               87               */
       0x61cf,          0x61d5,          0x61dc,          0x61dd,
    /* 88               89               90               91               */
       0x61de,          0x61df,          0x61e1,          0x61e2,
    /* 92               93               94                                */
       0x61e7,          0x61e9,          0x61e5,
/* JIS X 0212 row 31 */
    /*                   1                2                3               */
                        0x61ec,          0x61ed,          0x61ef,
    /*  4                5                6                7               */
       0x6201,          0x6203,          0x6204,          0x6207,
    /*  8                9               10               11               */
       0x6213,          0x6215,          0x621c,          0x6220,
    /* 12               13               14               15               */
       0x6222,          0x6223,          0x6227,          0x6229,
    /* 16               17               18               19               */
       0x622b,          0x6239,          0x623d,          0x6242,
    /* 20               21               22               23               */
       0x6243,          0x6244,          0x6246,          0x624c,
    /* 24               25               26               27               */
       0x6250,          0x6251,          0x6252,          0x6254,
    /* 28               29               30               31               */
       0x6256,          0x625a,          0x625c,          0x6264,
    /* 32               33               34               35               */
       0x626d,          0x626f,          0x6273,          0x627a,
    /* 36               37               38               39               */
       0x627d,          0x628d,          0x628e,          0x628f,
    /* 40               41               42               43               */
       0x6290,          0x62a6,          0x62a8,          0x62b3,
    /* 44               45               46               47               */
       0x62b6,          0x62b7,          0x62ba,          0x62be,
    /* 48               49               50               51               */
       0x62bf,          0x62c4,          0x62ce,          0x62d5,
    /* 52               53               54               55               */
       0x62d6,          0x62da,          0x62ea,          0x62f2,
    /* 56               57               58               59               */
       0x62f4,          0x62fc,          0x62fd,          0x6303,
    /* 60               61               62               63               */
       0x6304,          0x630a,          0x630b,          0x630d,
    /* 64               65               66               67               */
       0x6310,          0x6313,          0x6316,          0x6318,
    /* 68               69               70               71               */
       0x6329,          0x632a,          0x632d,          0x6335,
    /* 72               73               74               75               */
       0x6336,          0x6339,          0x633c,          0x6341,
    /* 76               77               78               79               */
       0x6342,          0x6343,          0x6344,          0x6346,
    /* 80               81               82               83               */
       0x634a,          0x634b,          0x634e,          0x6352,
    /* 84               85               86               87               */
       0x6353,          0x6354,          0x6358,          0x635b,
    /* 88               89               90               91               */
       0x6365,          0x6366,          0x636c,          0x636d,
    /* 92               93               94                                */
       0x6371,          0x6374,          0x6375,
/* JIS X 0212 row 32 */
    /*                   1                2                3               */
                        0x6378,          0x637c,          0x637d,
    /*  4                5                6                7               */
       0x637f,          0x6382,          0x6384,          0x6387,
    /*  8                9               10               11               */
       0x638a,          0x6390,          0x6394,          0x6395,
    /* 12               13               14               15               */
       0x6399,          0x639a,          0x639e,          0x63a4,
    /* 16               17               18               19               */
       0x63a6,          0x63ad,          0x63ae,          0x63af,
    /* 20               21               22               23               */
       0x63bd,          0x63c1,          0x63c5,          0x63c8,
    /* 24               25               26               27               */
       0x63ce,          0x63d1,          0x63d3,          0x63d4,
    /* 28               29               30               31               */
       0x63d5,          0x63dc,          0x63e0,          0x63e5,
    /* 32               33               34               35               */
       0x63ea,          0x63ec,          0x63f2,          0x63f3,
    /* 36               37               38               39               */
       0x63f5,          0x63f8,          0x63f9,          0x6409,
    /* 40               41               42               43               */
       0x640a,          0x6410,          0x6412,          0x6414,
    /* 44               45               46               47               */
       0x6418,          0x641e,          0x6420,          0x6422,
    /* 48               49               50               51               */
       0x6424,          0x6425,          0x6429,          0x642a,
    /* 52               53               54               55               */
       0x642f,          0x6430,          0x6435,          0x643d,
    /* 56               57               58               59               */
       0x643f,          0x644b,          0x644f,          0x6451,
    /* 60               61               62               63               */
       0x6452,          0x6453,          0x6454,          0x645a,
    /* 64               65               66               67               */
       0x645b,          0x645c,          0x645d,          0x645f,
    /* 68               69               70               71               */
       0x6460,          0x6461,          0x6463,          0x646d,
    /* 72               73               74               75               */
       0x6473,          0x6474,          0x647b,          0x647d,
    /* 76               77               78               79               */
       0x6485,          0x6487,          0x648f,          0x6490,
    /* 80               81               82               83               */
       0x6491,          0x6498,          0x6499,          0x649b,
    /* 84               85               86               87               */
       0x649d,          0x649f,          0x64a1,          0x64a3,
    /* 88               89               90               91               */
       0x64a6,          0x64a8,          0x64ac,          0x64b3,
    /* 92               93               94                                */
       0x64bd,          0x64be,          0x64bf,
/* JIS X 0212 row 33 */
    /*                   1                2                3               */
                        0x64c4,          0x64c9,          0x64ca,
    /*  4                5                6                7               */
       0x64cb,          0x64cc,          0x64ce,          0x64d0,
    /*  8                9               10               11               */
       0x64d1,          0x64d5,          0x64d7,          0x64e4,
    /* 12               13               14               15               */
       0x64e5,          0x64e9,          0x64ea,          0x64ed,
    /* 16               17               18               19               */
       0x64f0,          0x64f5,          0x64f7,          0x64fb,
    /* 20               21               22               23               */
       0x64ff,          0x6501,          0x6504,          0x6508,
    /* 24               25               26               27               */
       0x6509,          0x650a,          0x650f,          0x6513,
    /* 28               29               30               31               */
       0x6514,          0x6516,          0x6519,          0x651b,
    /* 32               33               34               35               */
       0x651e,          0x651f,          0x6522,          0x6526,
    /* 36               37               38               39               */
       0x6529,          0x652e,          0x6531,          0x653a,
    /* 40               41               42               43               */
       0x653c,          0x653d,          0x6543,          0x6547,
    /* 44               45               46               47               */
       0x6549,          0x6550,          0x6552,          0x6554,
    /* 48               49               50               51               */
       0x655f,          0x6560,          0x6567,          0x656b,
    /* 52               53               54               55               */
       0x657a,          0x657d,          0x6581,          0x6585,
    /* 56               57               58               59               */
       0x658a,          0x6592,          0x6595,          0x6598,
    /* 60               61               62               63               */
       0x659d,          0x65a0,          0x65a3,          0x65a6,
    /* 64               65               66               67               */
       0x65ae,          0x65b2,          0x65b3,          0x65b4,
    /* 68               69               70               71               */
       0x65bf,          0x65c2,          0x65c8,          0x65c9,
    /* 72               73               74               75               */
       0x65ce,          0x65d0,          0x65d4,          0x65d6,
    /* 76               77               78               79               */
       0x65d8,          0x65df,          0x65f0,          0x65f2,
    /* 80               81               82               83               */
       0x65f4,          0x65f5,          0x65f9,          0x65fe,
    /* 84               85               86               87               */
       0x65ff,          0x6600,          0x6604,          0x6608,
    /* 88               89               90               91               */
       0x6609,          0x660d,          0x6611,          0x6612,
    /* 92               93               94                                */
       0x6615,          0x6616,          0x661d,
/* JIS X 0212 row 34 */
    /*                   1                2                3               */
                        0x661e,          0x6621,          0x6622,
    /*  4                5                6                7               */
       0x6623,          0x6624,          0x6626,          0x6629,
    /*  8                9               10               11               */
       0x662a,          0x662b,          0x662c,          0x662e,
    /* 12               13               14               15               */
       0x6630,          0x6631,          0x6633,          0x6639,
    /* 16               17               18               19               */
       0x6637,          0x6640,          0x6645,          0x6646,
    /* 20               21               22               23               */
       0x664a,          0x664c,          0x6651,          0x664e,
    /* 24               25               26               27               */
       0x6657,          0x6658,          0x6659,          0x665b,
    /* 28               29               30               31               */
       0x665c,          0x6660,          0x6661,          0x66fb,
    /* 32               33               34               35               */
       0x666a,          0x666b,          0x666c,          0x667e,
    /* 36               37               38               39               */
       0x6673,          0x6675,          0x667f,          0x6677,
    /* 40               41               42               43               */
       0x6678,          0x6679,          0x667b,          0x6680,
    /* 44               45               46               47               */
       0x667c,          0x668b,          0x668c,          0x668d,
    /* 48               49               50               51               */
       0x6690,          0x6692,          0x6699,          0x669a,
    /* 52               53               54               55               */
       0x669b,          0x669c,          0x669f,          0x66a0,
    /* 56               57               58               59               */
       0x66a4,          0x66ad,          0x66b1,          0x66b2,
    /* 60               61               62               63               */
       0x66b5,          0x66bb,          0x66bf,          0x66c0,
    /* 64               65               66               67               */
       0x66c2,          0x66c3,          0x66c8,          0x66cc,
    /* 68               69               70               71               */
       0x66ce,          0x66cf,          0x66d4,          0x66db,
    /* 72               73               74               75               */
       0x66df,          0x66e8,          0x66eb,          0x66ec,
    /* 76               77               78               79               */
       0x66ee,          0x66fa,          0x6705,          0x6707,
    /* 80               81               82               83               */
       0x670e,          0x6713,          0x6719,          0x671c,
    /* 84               85               86               87               */
       0x6720,          0x6722,          0x6733,          0x673e,
    /* 88               89               90               91               */
       0x6745,          0x6747,          0x6748,          0x674c,
    /* 92               93               94                                */
       0x6754,          0x6755,          0x675d,
/* JIS X 0212 row 35 */
    /*                   1                2                3               */
                        0x6766,          0x676c,          0x676e,
    /*  4                5                6                7               */
       0x6774,          0x6776,          0x677b,          0x6781,
    /*  8                9               10               11               */
       0x6784,          0x678e,          0x678f,          0x6791,
    /* 12               13               14               15               */
       0x6793,          0x6796,          0x6798,          0x6799,
    /* 16               17               18               19               */
       0x679b,          0x67b0,          0x67b1,          0x67b2,
    /* 20               21               22               23               */
       0x67b5,          0x67bb,          0x67bc,          0x67bd,
    /* 24               25               26               27               */
       0x67f9,          0x67c0,          0x67c2,          0x67c3,
    /* 28               29               30               31               */
       0x67c5,          0x67c8,          0x67c9,          0x67d2,
    /* 32               33               34               35               */
       0x67d7,          0x67d9,          0x67dc,          0x67e1,
    /* 36               37               38               39               */
       0x67e6,          0x67f0,          0x67f2,          0x67f6,
    /* 40               41               42               43               */
       0x67f7,          0x6852,          0x6814,          0x6819,
    /* 44               45               46               47               */
       0x681d,          0x681f,          0x6828,          0x6827,
    /* 48               49               50               51               */
       0x682c,          0x682d,          0x682f,          0x6830,
    /* 52               53               54               55               */
       0x6831,          0x6833,          0x683b,          0x683f,
    /* 56               57               58               59               */
       0x6844,          0x6845,          0x684a,          0x684c,
    /* 60               61               62               63               */
       0x6855,          0x6857,          0x6858,          0x685b,
    /* 64               65               66               67               */
       0x686b,          0x686e,          0x686f,          0x6870,
    /* 68               69               70               71               */
       0x6871,          0x6872,          0x6875,          0x6879,
    /* 72               73               74               75               */
       0x687a,          0x687b,          0x687c,          0x6882,
    /* 76               77               78               79               */
       0x6884,          0x6886,          0x6888,          0x6896,
    /* 80               81               82               83               */
       0x6898,          0x689a,          0x689c,          0x68a1,
    /* 84               85               86               87               */
       0x68a3,          0x68a5,          0x68a9,          0x68aa,
    /* 88               89               90               91               */
       0x68ae,          0x68b2,          0x68bb,          0x68c5,
    /* 92               93               94                                */
       0x68c8,          0x68cc,          0x68cf,
/* JIS X 0212 row 36 */
    /*                   1                2                3               */
                        0x68d0,          0x68d1,          0x68d3,
    /*  4                5                6                7               */
       0x68d6,          0x68d9,          0x68dc,          0x68dd,
    /*  8                9               10               11               */
       0x68e5,          0x68e8,          0x68ea,          0x68eb,
    /* 12               13               14               15               */
       0x68ec,          0x68ed,          0x68f0,          0x68f1,
    /* 16               17               18               19               */
       0x68f5,          0x68f6,          0x68fb,          0x68fc,
    /* 20               21               22               23               */
       0x68fd,          0x6906,          0x6909,          0x690a,
    /* 24               25               26               27               */
       0x6910,          0x6911,          0x6913,          0x6916,
    /* 28               29               30               31               */
       0x6917,          0x6931,          0x6933,          0x6935,
    /* 32               33               34               35               */
       0x6938,          0x693b,          0x6942,          0x6945,
    /* 36               37               38               39               */
       0x6949,          0x694e,          0x6957,          0x695b,
    /* 40               41               42               43               */
       0x6963,          0x6964,          0x6965,          0x6966,
    /* 44               45               46               47               */
       0x6968,          0x6969,          0x696c,          0x6970,
    /* 48               49               50               51               */
       0x6971,          0x6972,          0x697a,          0x697b,
    /* 52               53               54               55               */
       0x697f,          0x6980,          0x698d,          0x6992,
    /* 56               57               58               59               */
       0x6996,          0x6998,          0x69a1,          0x69a5,
    /* 60               61               62               63               */
       0x69a6,          0x69a8,          0x69ab,          0x69ad,
    /* 64               65               66               67               */
       0x69af,          0x69b7,          0x69b8,          0x69ba,
    /* 68               69               70               71               */
       0x69bc,          0x69c5,          0x69c8,          0x69d1,
    /* 72               73               74               75               */
       0x69d6,          0x69d7,          0x69e2,          0x69e5,
    /* 76               77               78               79               */
       0x69ee,          0x69ef,          0x69f1,          0x69f3,
    /* 80               81               82               83               */
       0x69f5,          0x69fe,          0x6a00,          0x6a01,
    /* 84               85               86               87               */
       0x6a03,          0x6a0f,          0x6a11,          0x6a15,
    /* 88               89               90               91               */
       0x6a1a,          0x6a1d,          0x6a20,          0x6a24,
    /* 92               93               94                                */
       0x6a28,          0x6a30,          0x6a32,
/* JIS X 0212 row 37 */
    /*                   1                2                3               */
                        0x6a34,          0x6a37,          0x6a3b,
    /*  4                5                6                7               */
       0x6a3e,          0x6a3f,          0x6a45,          0x6a46,
    /*  8                9               10               11               */
       0x6a49,          0x6a4a,          0x6a4e,          0x6a50,
    /* 12               13               14               15               */
       0x6a51,          0x6a52,          0x6a55,          0x6a56,
    /* 16               17               18               19               */
       0x6a5b,          0x6a64,          0x6a67,          0x6a6a,
    /* 20               21               22               23               */
       0x6a71,          0x6a73,          0x6a7e,          0x6a81,
    /* 24               25               26               27               */
       0x6a83,          0x6a86,          0x6a87,          0x6a89,
    /* 28               29               30               31               */
       0x6a8b,          0x6a91,          0x6a9b,          0x6a9d,
    /* 32               33               34               35               */
       0x6a9e,          0x6a9f,          0x6aa5,          0x6aab,
    /* 36               37               38               39               */
       0x6aaf,          0x6ab0,          0x6ab1,          0x6ab4,
    /* 40               41               42               43               */
       0x6abd,          0x6abe,          0x6abf,          0x6ac6,
    /* 44               45               46               47               */
       0x6ac9,          0x6ac8,          0x6acc,          0x6ad0,
    /* 48               49               50               51               */
       0x6ad4,          0x6ad5,          0x6ad6,          0x6adc,
    /* 52               53               54               55               */
       0x6add,          0x6ae4,          0x6ae7,          0x6aec,
    /* 56               57               58               59               */
       0x6af0,          0x6af1,          0x6af2,          0x6afc,
    /* 60               61               62               63               */
       0x6afd,          0x6b02,          0x6b03,          0x6b06,
    /* 64               65               66               67               */
       0x6b07,          0x6b09,          0x6b0f,          0x6b10,
    /* 68               69               70               71               */
       0x6b11,          0x6b17,          0x6b1b,          0x6b1e,
    /* 72               73               74               75               */
       0x6b24,          0x6b28,          0x6b2b,          0x6b2c,
    /* 76               77               78               79               */
       0x6b2f,          0x6b35,          0x6b36,          0x6b3b,
    /* 80               81               82               83               */
       0x6b3f,          0x6b46,          0x6b4a,          0x6b4d,
    /* 84               85               86               87               */
       0x6b52,          0x6b56,          0x6b58,          0x6b5d,
    /* 88               89               90               91               */
       0x6b60,          0x6b67,          0x6b6b,          0x6b6e,
    /* 92               93               94                                */
       0x6b70,          0x6b75,          0x6b7d,
/* JIS X 0212 row 38 */
    /*                   1                2                3               */
                        0x6b7e,          0x6b82,          0x6b85,
    /*  4                5                6                7               */
       0x6b97,          0x6b9b,          0x6b9f,          0x6ba0,
    /*  8                9               10               11               */
       0x6ba2,          0x6ba3,          0x6ba8,          0x6ba9,
    /* 12               13               14               15               */
       0x6bac,          0x6bad,          0x6bae,          0x6bb0,
    /* 16               17               18               19               */
       0x6bb8,          0x6bb9,          0x6bbd,          0x6bbe,
    /* 20               21               22               23               */
       0x6bc3,          0x6bc4,          0x6bc9,          0x6bcc,
    /* 24               25               26               27               */
       0x6bd6,          0x6bda,          0x6be1,          0x6be3,
    /* 28               29               30               31               */
       0x6be6,          0x6be7,          0x6bee,          0x6bf1,
    /* 32               33               34               35               */
       0x6bf7,          0x6bf9,          0x6bff,          0x6c02,
    /* 36               37               38               39               */
       0x6c04,          0x6c05,          0x6c09,          0x6c0d,
    /* 40               41               42               43               */
       0x6c0e,          0x6c10,          0x6c12,          0x6c19,
    /* 44               45               46               47               */
       0x6c1f,          0x6c26,          0x6c27,          0x6c28,
    /* 48               49               50               51               */
       0x6c2c,          0x6c2e,          0x6c33,          0x6c35,
    /* 52               53               54               55               */
       0x6c36,          0x6c3a,          0x6c3b,          0x6c3f,
    /* 56               57               58               59               */
       0x6c4a,          0x6c4b,          0x6c4d,          0x6c4f,
    /* 60               61               62               63               */
       0x6c52,          0x6c54,          0x6c59,          0x6c5b,
    /* 64               65               66               67               */
       0x6c5c,          0x6c6b,          0x6c6d,          0x6c6f,
    /* 68               69               70               71               */
       0x6c74,          0x6c76,          0x6c78,          0x6c79,
    /* 72               73               74               75               */
       0x6c7b,          0x6c85,          0x6c86,          0x6c87,
    /* 76               77               78               79               */
       0x6c89,          0x6c94,          0x6c95,          0x6c97,
    /* 80               81               82               83               */
       0x6c98,          0x6c9c,          0x6c9f,          0x6cb0,
    /* 84               85               86               87               */
       0x6cb2,          0x6cb4,          0x6cc2,          0x6cc6,
    /* 88               89               90               91               */
       0x6ccd,          0x6ccf,          0x6cd0,          0x6cd1,
    /* 92               93               94                                */
       0x6cd2,          0x6cd4,          0x6cd6,
/* JIS X 0212 row 39 */
    /*                   1                2                3               */
                        0x6cda,          0x6cdc,          0x6ce0,
    /*  4                5                6                7               */
       0x6ce7,          0x6ce9,          0x6ceb,          0x6cec,
    /*  8                9               10               11               */
       0x6cee,          0x6cf2,          0x6cf4,          0x6d04,
    /* 12               13               14               15               */
       0x6d07,          0x6d0a,          0x6d0e,          0x6d0f,
    /* 16               17               18               19               */
       0x6d11,          0x6d13,          0x6d1a,          0x6d26,
    /* 20               21               22               23               */
       0x6d27,          0x6d28,          0x6c67,          0x6d2e,
    /* 24               25               26               27               */
       0x6d2f,          0x6d31,          0x6d39,          0x6d3c,
    /* 28               29               30               31               */
       0x6d3f,          0x6d57,          0x6d5e,          0x6d5f,
    /* 32               33               34               35               */
       0x6d61,          0x6d65,          0x6d67,          0x6d6f,
    /* 36               37               38               39               */
       0x6d70,          0x6d7c,          0x6d82,          0x6d87,
    /* 40               41               42               43               */
       0x6d91,          0x6d92,          0x6d94,          0x6d96,
    /* 44               45               46               47               */
       0x6d97,          0x6d98,          0x6daa,          0x6dac,
    /* 48               49               50               51               */
       0x6db4,          0x6db7,          0x6db9,          0x6dbd,
    /* 52               53               54               55               */
       0x6dbf,          0x6dc4,          0x6dc8,          0x6dca,
    /* 56               57               58               59               */
       0x6dce,          0x6dcf,          0x6dd6,          0x6ddb,
    /* 60               61               62               63               */
       0x6ddd,          0x6ddf,          0x6de0,          0x6de2,
    /* 64               65               66               67               */
       0x6de5,          0x6de9,          0x6def,          0x6df0,
    /* 68               69               70               71               */
       0x6df4,          0x6df6,          0x6dfc,          0x6e00,
    /* 72               73               74               75               */
       0x6e04,          0x6e1e,          0x6e22,          0x6e27,
    /* 76               77               78               79               */
       0x6e32,          0x6e36,          0x6e39,          0x6e3b,
    /* 80               81               82               83               */
       0x6e3c,          0x6e44,          0x6e45,          0x6e48,
    /* 84               85               86               87               */
       0x6e49,          0x6e4b,          0x6e4f,          0x6e51,
    /* 88               89               90               91               */
       0x6e52,          0x6e53,          0x6e54,          0x6e57,
    /* 92               93               94                                */
       0x6e5c,          0x6e5d,          0x6e5e,
/* JIS X 0212 row 40 */
    /*                   1                2                3               */
                        0x6e62,          0x6e63,          0x6e68,
    /*  4                5                6                7               */
       0x6e73,          0x6e7b,          0x6e7d,          0x6e8d,
    /*  8                9               10               11               */
       0x6e93,          0x6e99,          0x6ea0,          0x6ea7,
    /* 12               13               14               15               */
       0x6ead,          0x6eae,          0x6eb1,          0x6eb3,
    /* 16               17               18               19               */
       0x6ebb,          0x6ebf,          0x6ec0,          0x6ec1,
    /* 20               21               22               23               */
       0x6ec3,          0x6ec7,          0x6ec8,          0x6eca,
    /* 24               25               26               27               */
       0x6ecd,          0x6ece,          0x6ecf,          0x6eeb,
    /* 28               29               30               31               */
       0x6eed,          0x6eee,          0x6ef9,          0x6efb,
    /* 32               33               34               35               */
       0x6efd,          0x6f04,          0x6f08,          0x6f0a,
    /* 36               37               38               39               */
       0x6f0c,          0x6f0d,          0x6f16,          0x6f18,
    /* 40               41               42               43               */
       0x6f1a,          0x6f1b,          0x6f26,          0x6f29,
    /* 44               45               46               47               */
       0x6f2a,          0x6f2f,          0x6f30,          0x6f33,
    /* 48               49               50               51               */
       0x6f36,          0x6f3b,          0x6f3c,          0x6f2d,
    /* 52               53               54               55               */
       0x6f4f,          0x6f51,          0x6f52,          0x6f53,
    /* 56               57               58               59               */
       0x6f57,          0x6f59,          0x6f5a,          0x6f5d,
    /* 60               61               62               63               */
       0x6f5e,          0x6f61,          0x6f62,          0x6f68,
    /* 64               65               66               67               */
       0x6f6c,          0x6f7d,          0x6f7e,          0x6f83,
    /* 68               69               70               71               */
       0x6f87,          0x6f88,          0x6f8b,          0x6f8c,
    /* 72               73               74               75               */
       0x6f8d,          0x6f90,          0x6f92,          0x6f93,
    /* 76               77               78               79               */
       0x6f94,          0x6f96,          0x6f9a,          0x6f9f,
    /* 80               81               82               83               */
       0x6fa0,          0x6fa5,          0x6fa6,          0x6fa7,
    /* 84               85               86               87               */
       0x6fa8,          0x6fae,          0x6faf,          0x6fb0,
    /* 88               89               90               91               */
       0x6fb5,          0x6fb6,          0x6fbc,          0x6fc5,
    /* 92               93               94                                */
       0x6fc7,          0x6fc8,          0x6fca,
/* JIS X 0212 row 41 */
    /*                   1                2                3               */
                        0x6fda,          0x6fde,          0x6fe8,
    /*  4                5                6                7               */
       0x6fe9,          0x6ff0,          0x6ff5,          0x6ff9,
    /*  8                9               10               11               */
       0x6ffc,          0x6ffd,          0x7000,          0x7005,
    /* 12               13               14               15               */
       0x7006,          0x7007,          0x700d,          0x7017,
    /* 16               17               18               19               */
       0x7020,          0x7023,          0x702f,          0x7034,
    /* 20               21               22               23               */
       0x7037,          0x7039,          0x703c,          0x7043,
    /* 24               25               26               27               */
       0x7044,          0x7048,          0x7049,          0x704a,
    /* 28               29               30               31               */
       0x704b,          0x7054,          0x7055,          0x705d,
    /* 32               33               34               35               */
       0x705e,          0x704e,          0x7064,          0x7065,
    /* 36               37               38               39               */
       0x706c,          0x706e,          0x7075,          0x7076,
    /* 40               41               42               43               */
       0x707e,          0x7081,          0x7085,          0x7086,
    /* 44               45               46               47               */
       0x7094,          0x7095,          0x7096,          0x7097,
    /* 48               49               50               51               */
       0x7098,          0x709b,          0x70a4,          0x70ab,
    /* 52               53               54               55               */
       0x70b0,          0x70b1,          0x70b4,          0x70b7,
    /* 56               57               58               59               */
       0x70ca,          0x70d1,          0x70d3,          0x70d4,
    /* 60               61               62               63               */
       0x70d5,          0x70d6,          0x70d8,          0x70dc,
    /* 64               65               66               67               */
       0x70e4,          0x70fa,          0x7103,          0x7104,
    /* 68               69               70               71               */
       0x7105,          0x7106,          0x7107,          0x710b,
    /* 72               73               74               75               */
       0x710c,          0x710f,          0x711e,          0x7120,
    /* 76               77               78               79               */
       0x712b,          0x712d,          0x712f,          0x7130,
    /* 80               81               82               83               */
       0x7131,          0x7138,          0x7141,          0x7145,
    /* 84               85               86               87               */
       0x7146,          0x7147,          0x714a,          0x714b,
    /* 88               89               90               91               */
       0x7150,          0x7152,          0x7157,          0x715a,
    /* 92               93               94                                */
       0x715c,          0x715e,          0x7160,
/* JIS X 0212 row 42 */
    /*                   1                2                3               */
                        0x7168,          0x7179,          0x7180,
    /*  4                5                6                7               */
       0x7185,          0x7187,          0x718c,          0x7192,
    /*  8                9               10               11               */
       0x719a,          0x719b,          0x71a0,          0x71a2,
    /* 12               13               14               15               */
       0x71af,          0x71b0,          0x71b2,          0x71b3,
    /* 16               17               18               19               */
       0x71ba,          0x71bf,          0x71c0,          0x71c1,
    /* 20               21               22               23               */
       0x71c4,          0x71cb,          0x71cc,          0x71d3,
    /* 24               25               26               27               */
       0x71d6,          0x71d9,          0x71da,          0x71dc,
    /* 28               29               30               31               */
       0x71f8,          0x71fe,          0x7200,          0x7207,
    /* 32               33               34               35               */
       0x7208,          0x7209,          0x7213,          0x7217,
    /* 36               37               38               39               */
       0x721a,          0x721d,          0x721f,          0x7224,
    /* 40               41               42               43               */
       0x722b,          0x722f,          0x7234,          0x7238,
    /* 44               45               46               47               */
       0x7239,          0x7241,          0x7242,          0x7243,
    /* 48               49               50               51               */
       0x7245,          0x724e,          0x724f,          0x7250,
    /* 52               53               54               55               */
       0x7253,          0x7255,          0x7256,          0x725a,
    /* 56               57               58               59               */
       0x725c,          0x725e,          0x7260,          0x7263,
    /* 60               61               62               63               */
       0x7268,          0x726b,          0x726e,          0x726f,
    /* 64               65               66               67               */
       0x7271,          0x7277,          0x7278,          0x727b,
    /* 68               69               70               71               */
       0x727c,          0x727f,          0x7284,          0x7289,
    /* 72               73               74               75               */
       0x728d,          0x728e,          0x7293,          0x729b,
    /* 76               77               78               79               */
       0x72a8,          0x72ad,          0x72ae,          0x72b1,
    /* 80               81               82               83               */
       0x72b4,          0x72be,          0x72c1,          0x72c7,
    /* 84               85               86               87               */
       0x72c9,          0x72cc,          0x72d5,          0x72d6,
    /* 88               89               90               91               */
       0x72d8,          0x72df,          0x72e5,          0x72f3,
    /* 92               93               94                                */
       0x72f4,          0x72fa,          0x72fb,
/* JIS X 0212 row 43 */
    /*                   1                2                3               */
                        0x72fe,          0x7302,          0x7304,
    /*  4                5                6                7               */
       0x7305,          0x7307,          0x730b,          0x730d,
    /*  8                9               10               11               */
       0x7312,          0x7313,          0x7318,          0x7319,
    /* 12               13               14               15               */
       0x731e,          0x7322,          0x7324,          0x7327,
    /* 16               17               18               19               */
       0x7328,          0x732c,          0x7331,          0x7332,
    /* 20               21               22               23               */
       0x7335,          0x733a,          0x733b,          0x733d,
    /* 24               25               26               27               */
       0x7343,          0x734d,          0x7350,          0x7352,
    /* 28               29               30               31               */
       0x7356,          0x7358,          0x735d,          0x735e,
    /* 32               33               34               35               */
       0x735f,          0x7360,          0x7366,          0x7367,
    /* 36               37               38               39               */
       0x7369,          0x736b,          0x736c,          0x736e,
    /* 40               41               42               43               */
       0x736f,          0x7371,          0x7377,          0x7379,
    /* 44               45               46               47               */
       0x737c,          0x7380,          0x7381,          0x7383,
    /* 48               49               50               51               */
       0x7385,          0x7386,          0x738e,          0x7390,
    /* 52               53               54               55               */
       0x7393,          0x7395,          0x7397,          0x7398,
    /* 56               57               58               59               */
       0x739c,          0x739e,          0x739f,          0x73a0,
    /* 60               61               62               63               */
       0x73a2,          0x73a5,          0x73a6,          0x73aa,
    /* 64               65               66               67               */
       0x73ab,          0x73ad,          0x73b5,          0x73b7,
    /* 68               69               70               71               */
       0x73b9,          0x73bc,          0x73bd,          0x73bf,
    /* 72               73               74               75               */
       0x73c5,          0x73c6,          0x73c9,          0x73cb,
    /* 76               77               78               79               */
       0x73cc,          0x73cf,          0x73d2,          0x73d3,
    /* 80               81               82               83               */
       0x73d6,          0x73d9,          0x73dd,          0x73e1,
    /* 84               85               86               87               */
       0x73e3,          0x73e6,          0x73e7,          0x73e9,
    /* 88               89               90               91               */
       0x73f4,          0x73f5,          0x73f7,          0x73f9,
    /* 92               93               94                                */
       0x73fa,          0x73fb,          0x73fd,
/* JIS X 0212 row 44 */
    /*                   1                2                3               */
                        0x73ff,          0x7400,          0x7401,
    /*  4                5                6                7               */
       0x7404,          0x7407,          0x740a,          0x7411,
    /*  8                9               10               11               */
       0x741a,          0x741b,          0x7424,          0x7426,
    /* 12               13               14               15               */
       0x7428,          0x7429,          0x742a,          0x742b,
    /* 16               17               18               19               */
       0x742c,          0x742d,          0x742e,          0x742f,
    /* 20               21               22               23               */
       0x7430,          0x7431,          0x7439,          0x7440,
    /* 24               25               26               27               */
       0x7443,          0x7444,          0x7446,          0x7447,
    /* 28               29               30               31               */
       0x744b,          0x744d,          0x7451,          0x7452,
    /* 32               33               34               35               */
       0x7457,          0x745d,          0x7462,          0x7466,
    /* 36               37               38               39               */
       0x7467,          0x7468,          0x746b,          0x746d,
    /* 40               41               42               43               */
       0x746e,          0x7471,          0x7472,          0x7480,
    /* 44               45               46               47               */
       0x7481,          0x7485,          0x7486,          0x7487,
    /* 48               49               50               51               */
       0x7489,          0x748f,          0x7490,          0x7491,
    /* 52               53               54               55               */
       0x7492,          0x7498,          0x7499,          0x749a,
    /* 56               57               58               59               */
       0x749c,          0x749f,          0x74a0,          0x74a1,
    /* 60               61               62               63               */
       0x74a3,          0x74a6,          0x74a8,          0x74a9,
    /* 64               65               66               67               */
       0x74aa,          0x74ab,          0x74ae,          0x74af,
    /* 68               69               70               71               */
       0x74b1,          0x74b2,          0x74b5,          0x74b9,
    /* 72               73               74               75               */
       0x74bb,          0x74bf,          0x74c8,          0x74c9,
    /* 76               77               78               79               */
       0x74cc,          0x74d0,          0x74d3,          0x74d8,
    /* 80               81               82               83               */
       0x74da,          0x74db,          0x74de,          0x74df,
    /* 84               85               86               87               */
       0x74e4,          0x74e8,          0x74ea,          0x74eb,
    /* 88               89               90               91               */
       0x74ef,          0x74f4,          0x74fa,          0x74fb,
    /* 92               93               94                                */
       0x74fc,          0x74ff,          0x7506,
/* JIS X 0212 row 45 */
    /*                   1                2                3               */
                        0x7512,          0x7516,          0x7517,
    /*  4                5                6                7               */
       0x7520,          0x7521,          0x7524,          0x7527,
    /*  8                9               10               11               */
       0x7529,          0x752a,          0x752f,          0x7536,
    /* 12               13               14               15               */
       0x7539,          0x753d,          0x753e,          0x753f,
    /* 16               17               18               19               */
       0x7540,          0x7543,          0x7547,          0x7548,
    /* 20               21               22               23               */
       0x754e,          0x7550,          0x7552,          0x7557,
    /* 24               25               26               27               */
       0x755e,          0x755f,          0x7561,          0x756f,
    /* 28               29               30               31               */
       0x7571,          0x7579,          0x757a,          0x757b,
    /* 32               33               34               35               */
       0x757c,          0x757d,          0x757e,          0x7581,
    /* 36               37               38               39               */
       0x7585,          0x7590,          0x7592,          0x7593,
    /* 40               41               42               43               */
       0x7595,          0x7599,          0x759c,          0x75a2,
    /* 44               45               46               47               */
       0x75a4,          0x75b4,          0x75ba,          0x75bf,
    /* 48               49               50               51               */
       0x75c0,          0x75c1,          0x75c4,          0x75c6,
    /* 52               53               54               55               */
       0x75cc,          0x75ce,          0x75cf,          0x75d7,
    /* 56               57               58               59               */
       0x75dc,          0x75df,          0x75e0,          0x75e1,
    /* 60               61               62               63               */
       0x75e4,          0x75e7,          0x75ec,          0x75ee,
    /* 64               65               66               67               */
       0x75ef,          0x75f1,          0x75f9,          0x7600,
    /* 68               69               70               71               */
       0x7602,          0x7603,          0x7604,          0x7607,
    /* 72               73               74               75               */
       0x7608,          0x760a,          0x760c,          0x760f,
    /* 76               77               78               79               */
       0x7612,          0x7613,          0x7615,          0x7616,
    /* 80               81               82               83               */
       0x7619,          0x761b,          0x761c,          0x761d,
    /* 84               85               86               87               */
       0x761e,          0x7623,          0x7625,          0x7626,
    /* 88               89               90               91               */
       0x7629,          0x762d,          0x7632,          0x7633,
    /* 92               93               94                                */
       0x7635,          0x7638,          0x7639,
/* JIS X 0212 row 46 */
    /*                   1                2                3               */
                        0x763a,          0x763c,          0x764a,
    /*  4                5                6                7               */
       0x7640,          0x7641,          0x7643,          0x7644,
    /*  8                9               10               11               */
       0x7645,          0x7649,          0x764b,          0x7655,
    /* 12               13               14               15               */
       0x7659,          0x765f,          0x7664,          0x7665,
    /* 16               17               18               19               */
       0x766d,          0x766e,          0x766f,          0x7671,
    /* 20               21               22               23               */
       0x7674,          0x7681,          0x7685,          0x768c,
    /* 24               25               26               27               */
       0x768d,          0x7695,          0x769b,          0x769c,
    /* 28               29               30               31               */
       0x769d,          0x769f,          0x76a0,          0x76a2,
    /* 32               33               34               35               */
       0x76a3,          0x76a4,          0x76a5,          0x76a6,
    /* 36               37               38               39               */
       0x76a7,          0x76a8,          0x76aa,          0x76ad,
    /* 40               41               42               43               */
       0x76bd,          0x76c1,          0x76c5,          0x76c9,
    /* 44               45               46               47               */
       0x76cb,          0x76cc,          0x76ce,          0x76d4,
    /* 48               49               50               51               */
       0x76d9,          0x76e0,          0x76e6,          0x76e8,
    /* 52               53               54               55               */
       0x76ec,          0x76f0,          0x76f1,          0x76f6,
    /* 56               57               58               59               */
       0x76f9,          0x76fc,          0x7700,          0x7706,
    /* 60               61               62               63               */
       0x770a,          0x770e,          0x7712,          0x7714,
    /* 64               65               66               67               */
       0x7715,          0x7717,          0x7719,          0x771a,
    /* 68               69               70               71               */
       0x771c,          0x7722,          0x7728,          0x772d,
    /* 72               73               74               75               */
       0x772e,          0x772f,          0x7734,          0x7735,
    /* 76               77               78               79               */
       0x7736,          0x7739,          0x773d,          0x773e,
    /* 80               81               82               83               */
       0x7742,          0x7745,          0x7746,          0x774a,
    /* 84               85               86               87               */
       0x774d,          0x774e,          0x774f,          0x7752,
    /* 88               89               90               91               */
       0x7756,          0x7757,          0x775c,          0x775e,
    /* 92               93               94                                */
       0x775f,          0x7760,          0x7762,
/* JIS X 0212 row 47 */
    /*                   1                2                3               */
                        0x7764,          0x7767,          0x776a,
    /*  4                5                6                7               */
       0x776c,          0x7770,          0x7772,          0x7773,
    /*  8                9               10               11               */
       0x7774,          0x777a,          0x777d,          0x7780,
    /* 12               13               14               15               */
       0x7784,          0x778c,          0x778d,          0x7794,
    /* 16               17               18               19               */
       0x7795,          0x7796,          0x779a,          0x779f,
    /* 20               21               22               23               */
       0x77a2,          0x77a7,          0x77aa,          0x77ae,
    /* 24               25               26               27               */
       0x77af,          0x77b1,          0x77b5,          0x77be,
    /* 28               29               30               31               */
       0x77c3,          0x77c9,          0x77d1,          0x77d2,
    /* 32               33               34               35               */
       0x77d5,          0x77d9,          0x77de,          0x77df,
    /* 36               37               38               39               */
       0x77e0,          0x77e4,          0x77e6,          0x77ea,
    /* 40               41               42               43               */
       0x77ec,          0x77f0,          0x77f1,          0x77f4,
    /* 44               45               46               47               */
       0x77f8,          0x77fb,          0x7805,          0x7806,
    /* 48               49               50               51               */
       0x7809,          0x780d,          0x780e,          0x7811,
    /* 52               53               54               55               */
       0x781d,          0x7821,          0x7822,          0x7823,
    /* 56               57               58               59               */
       0x782d,          0x782e,          0x7830,          0x7835,
    /* 60               61               62               63               */
       0x7837,          0x7843,          0x7844,          0x7847,
    /* 64               65               66               67               */
       0x7848,          0x784c,          0x784e,          0x7852,
    /* 68               69               70               71               */
       0x785c,          0x785e,          0x7860,          0x7861,
    /* 72               73               74               75               */
       0x7863,          0x7864,          0x7868,          0x786a,
    /* 76               77               78               79               */
       0x786e,          0x787a,          0x787e,          0x788a,
    /* 80               81               82               83               */
       0x788f,          0x7894,          0x7898,          0x78a1,
    /* 84               85               86               87               */
       0x789d,          0x789e,          0x789f,          0x78a4,
    /* 88               89               90               91               */
       0x78a8,          0x78ac,          0x78ad,          0x78b0,
    /* 92               93               94                                */
       0x78b1,          0x78b2,          0x78b3,
/* JIS X 0212 row 48 */
    /*                   1                2                3               */
                        0x78bb,          0x78bd,          0x78bf,
    /*  4                5                6                7               */
       0x78c7,          0x78c8,          0x78c9,          0x78cc,
    /*  8                9               10               11               */
       0x78ce,          0x78d2,          0x78d3,          0x78d5,
    /* 12               13               14               15               */
       0x78d6,          0x78e4,          0x78db,          0x78df,
    /* 16               17               18               19               */
       0x78e0,          0x78e1,          0x78e6,          0x78ea,
    /* 20               21               22               23               */
       0x78f2,          0x78f3,          0x7900,          0x78f6,
    /* 24               25               26               27               */
       0x78f7,          0x78fa,          0x78fb,          0x78ff,
    /* 28               29               30               31               */
       0x7906,          0x790c,          0x7910,          0x791a,
    /* 32               33               34               35               */
       0x791c,          0x791e,          0x791f,          0x7920,
    /* 36               37               38               39               */
       0x7925,          0x7927,          0x7929,          0x792d,
    /* 40               41               42               43               */
       0x7931,          0x7934,          0x7935,          0x793b,
    /* 44               45               46               47               */
       0x793d,          0x793f,          0x7944,          0x7945,
    /* 48               49               50               51               */
       0x7946,          0x794a,          0x794b,          0x794f,
    /* 52               53               54               55               */
       0x7951,          0x7954,          0x7958,          0x795b,
    /* 56               57               58               59               */
       0x795c,          0x7967,          0x7969,          0x796b,
    /* 60               61               62               63               */
       0x7972,          0x7979,          0x797b,          0x797c,
    /* 64               65               66               67               */
       0x797e,          0x798b,          0x798c,          0x7991,
    /* 68               69               70               71               */
       0x7993,          0x7994,          0x7995,          0x7996,
    /* 72               73               74               75               */
       0x7998,          0x799b,          0x799c,          0x79a1,
    /* 76               77               78               79               */
       0x79a8,          0x79a9,          0x79ab,          0x79af,
    /* 80               81               82               83               */
       0x79b1,          0x79b4,          0x79b8,          0x79bb,
    /* 84               85               86               87               */
       0x79c2,          0x79c4,          0x79c7,          0x79c8,
    /* 88               89               90               91               */
       0x79ca,          0x79cf,          0x79d4,          0x79d6,
    /* 92               93               94                                */
       0x79da,          0x79dd,          0x79de,
/* JIS X 0212 row 49 */
    /*                   1                2                3               */
                        0x79e0,          0x79e2,          0x79e5,
    /*  4                5                6                7               */
       0x79ea,          0x79eb,          0x79ed,          0x79f1,
    /*  8                9               10               11               */
       0x79f8,          0x79fc,          0x7a02,          0x7a03,
    /* 12               13               14               15               */
       0x7a07,          0x7a09,          0x7a0a,          0x7a0c,
    /* 16               17               18               19               */
       0x7a11,          0x7a15,          0x7a1b,          0x7a1e,
    /* 20               21               22               23               */
       0x7a21,          0x7a27,          0x7a2b,          0x7a2d,
    /* 24               25               26               27               */
       0x7a2f,          0x7a30,          0x7a34,          0x7a35,
    /* 28               29               30               31               */
       0x7a38,          0x7a39,          0x7a3a,          0x7a44,
    /* 32               33               34               35               */
       0x7a45,          0x7a47,          0x7a48,          0x7a4c,
    /* 36               37               38               39               */
       0x7a55,          0x7a56,          0x7a59,          0x7a5c,
    /* 40               41               42               43               */
       0x7a5d,          0x7a5f,          0x7a60,          0x7a65,
    /* 44               45               46               47               */
       0x7a67,          0x7a6a,          0x7a6d,          0x7a75,
    /* 48               49               50               51               */
       0x7a78,          0x7a7e,          0x7a80,          0x7a82,
    /* 52               53               54               55               */
       0x7a85,          0x7a86,          0x7a8a,          0x7a8b,
    /* 56               57               58               59               */
       0x7a90,          0x7a91,          0x7a94,          0x7a9e,
    /* 60               61               62               63               */
       0x7aa0,          0x7aa3,          0x7aac,          0x7ab3,
    /* 64               65               66               67               */
       0x7ab5,          0x7ab9,          0x7abb,          0x7abc,
    /* 68               69               70               71               */
       0x7ac6,          0x7ac9,          0x7acc,          0x7ace,
    /* 72               73               74               75               */
       0x7ad1,          0x7adb,          0x7ae8,          0x7ae9,
    /* 76               77               78               79               */
       0x7aeb,          0x7aec,          0x7af1,          0x7af4,
    /* 80               81               82               83               */
       0x7afb,          0x7afd,          0x7afe,          0x7b07,
    /* 84               85               86               87               */
       0x7b14,          0x7b1f,          0x7b23,          0x7b27,
    /* 88               89               90               91               */
       0x7b29,          0x7b2a,          0x7b2b,          0x7b2d,
    /* 92               93               94                                */
       0x7b2e,          0x7b2f,          0x7b30,
/* JIS X 0212 row 50 */
    /*                   1                2                3               */
                        0x7b31,          0x7b34,          0x7b3d,
    /*  4                5                6                7               */
       0x7b3f,          0x7b40,          0x7b41,          0x7b47,
    /*  8                9               10               11               */
       0x7b4e,          0x7b55,          0x7b60,          0x7b64,
    /* 12               13               14               15               */
       0x7b66,          0x7b69,          0x7b6a,          0x7b6d,
    /* 16               17               18               19               */
       0x7b6f,          0x7b72,          0x7b73,          0x7b77,
    /* 20               21               22               23               */
       0x7b84,          0x7b89,          0x7b8e,          0x7b90,
    /* 24               25               26               27               */
       0x7b91,          0x7b96,          0x7b9b,          0x7b9e,
    /* 28               29               30               31               */
       0x7ba0,          0x7ba5,          0x7bac,          0x7baf,
    /* 32               33               34               35               */
       0x7bb0,          0x7bb2,          0x7bb5,          0x7bb6,
    /* 36               37               38               39               */
       0x7bba,          0x7bbb,          0x7bbc,          0x7bbd,
    /* 40               41               42               43               */
       0x7bc2,          0x7bc5,          0x7bc8,          0x7bca,
    /* 44               45               46               47               */
       0x7bd4,          0x7bd6,          0x7bd7,          0x7bd9,
    /* 48               49               50               51               */
       0x7bda,          0x7bdb,          0x7be8,          0x7bea,
    /* 52               53               54               55               */
       0x7bf2,          0x7bf4,          0x7bf5,          0x7bf8,
    /* 56               57               58               59               */
       0x7bf9,          0x7bfa,          0x7bfc,          0x7bfe,
    /* 60               61               62               63               */
       0x7c01,          0x7c02,          0x7c03,          0x7c04,
    /* 64               65               66               67               */
       0x7c06,          0x7c09,          0x7c0b,          0x7c0c,
    /* 68               69               70               71               */
       0x7c0e,          0x7c0f,          0x7c19,          0x7c1b,
    /* 72               73               74               75               */
       0x7c20,          0x7c25,          0x7c26,          0x7c28,
    /* 76               77               78               79               */
       0x7c2c,          0x7c31,          0x7c33,          0x7c34,
    /* 80               81               82               83               */
       0x7c36,          0x7c39,          0x7c3a,          0x7c46,
    /* 84               85               86               87               */
       0x7c4a,          0x7c55,          0x7c51,          0x7c52,
    /* 88               89               90               91               */
       0x7c53,          0x7c59,          0x7c5a,          0x7c5b,
    /* 92               93               94                                */
       0x7c5c,          0x7c5d,          0x7c5e,
/* JIS X 0212 row 51 */
    /*                   1                2                3               */
                        0x7c61,          0x7c63,          0x7c67,
    /*  4                5                6                7               */
       0x7c69,          0x7c6d,          0x7c6e,          0x7c70,
    /*  8                9               10               11               */
       0x7c72,          0x7c79,          0x7c7c,          0x7c7d,
    /* 12               13               14               15               */
       0x7c86,          0x7c87,          0x7c8f,          0x7c94,
    /* 16               17               18               19               */
       0x7c9e,          0x7ca0,          0x7ca6,          0x7cb0,
    /* 20               21               22               23               */
       0x7cb6,          0x7cb7,          0x7cba,          0x7cbb,
    /* 24               25               26               27               */
       0x7cbc,          0x7cbf,          0x7cc4,          0x7cc7,
    /* 28               29               30               31               */
       0x7cc8,          0x7cc9,          0x7ccd,          0x7ccf,
    /* 32               33               34               35               */
       0x7cd3,          0x7cd4,          0x7cd5,          0x7cd7,
    /* 36               37               38               39               */
       0x7cd9,          0x7cda,          0x7cdd,          0x7ce6,
    /* 40               41               42               43               */
       0x7ce9,          0x7ceb,          0x7cf5,          0x7d03,
    /* 44               45               46               47               */
       0x7d07,          0x7d08,          0x7d09,          0x7d0f,
    /* 48               49               50               51               */
       0x7d11,          0x7d12,          0x7d13,          0x7d16,
    /* 52               53               54               55               */
       0x7d1d,          0x7d1e,          0x7d23,          0x7d26,
    /* 56               57               58               59               */
       0x7d2a,          0x7d2d,          0x7d31,          0x7d3c,
    /* 60               61               62               63               */
       0x7d3d,          0x7d3e,          0x7d40,          0x7d41,
    /* 64               65               66               67               */
       0x7d47,          0x7d48,          0x7d4d,          0x7d51,
    /* 68               69               70               71               */
       0x7d53,          0x7d57,          0x7d59,          0x7d5a,
    /* 72               73               74               75               */
       0x7d5c,          0x7d5d,          0x7d65,          0x7d67,
    /* 76               77               78               79               */
       0x7d6a,          0x7d70,          0x7d78,          0x7d7a,
    /* 80               81               82               83               */
       0x7d7b,          0x7d7f,          0x7d81,          0x7d82,
    /* 84               85               86               87               */
       0x7d83,          0x7d85,          0x7d86,          0x7d88,
    /* 88               89               90               91               */
       0x7d8b,          0x7d8c,          0x7d8d,          0x7d91,
    /* 92               93               94                                */
       0x7d96,          0x7d97,          0x7d9d,
/* JIS X 0212 row 52 */
    /*                   1                2                3               */
                        0x7d9e,          0x7da6,          0x7da7,
    /*  4                5                6                7               */
       0x7daa,          0x7db3,          0x7db6,          0x7db7,
    /*  8                9               10               11               */
       0x7db9,          0x7dc2,          0x7dc3,          0x7dc4,
    /* 12               13               14               15               */
       0x7dc5,          0x7dc6,          0x7dcc,          0x7dcd,
    /* 16               17               18               19               */
       0x7dce,          0x7dd7,          0x7dd9,          0x7e00,
    /* 20               21               22               23               */
       0x7de2,          0x7de5,          0x7de6,          0x7dea,
    /* 24               25               26               27               */
       0x7deb,          0x7ded,          0x7df1,          0x7df5,
    /* 28               29               30               31               */
       0x7df6,          0x7df9,          0x7dfa,          0x7e08,
    /* 32               33               34               35               */
       0x7e10,          0x7e11,          0x7e15,          0x7e17,
    /* 36               37               38               39               */
       0x7e1c,          0x7e1d,          0x7e20,          0x7e27,
    /* 40               41               42               43               */
       0x7e28,          0x7e2c,          0x7e2d,          0x7e2f,
    /* 44               45               46               47               */
       0x7e33,          0x7e36,          0x7e3f,          0x7e44,
    /* 48               49               50               51               */
       0x7e45,          0x7e47,          0x7e4e,          0x7e50,
    /* 52               53               54               55               */
       0x7e52,          0x7e58,          0x7e5f,          0x7e61,
    /* 56               57               58               59               */
       0x7e62,          0x7e65,          0x7e6b,          0x7e6e,
    /* 60               61               62               63               */
       0x7e6f,          0x7e73,          0x7e78,          0x7e7e,
    /* 64               65               66               67               */
       0x7e81,          0x7e86,          0x7e87,          0x7e8a,
    /* 68               69               70               71               */
       0x7e8d,          0x7e91,          0x7e95,          0x7e98,
    /* 72               73               74               75               */
       0x7e9a,          0x7e9d,          0x7e9e,          0x7f3c,
    /* 76               77               78               79               */
       0x7f3b,          0x7f3d,          0x7f3e,          0x7f3f,
    /* 80               81               82               83               */
       0x7f43,          0x7f44,          0x7f47,          0x7f4f,
    /* 84               85               86               87               */
       0x7f52,          0x7f53,          0x7f5b,          0x7f5c,
    /* 88               89               90               91               */
       0x7f5d,          0x7f61,          0x7f63,          0x7f64,
    /* 92               93               94                                */
       0x7f65,          0x7f66,          0x7f6d,
/* JIS X 0212 row 53 */
    /*                   1                2                3               */
                        0x7f71,          0x7f7d,          0x7f7e,
    /*  4                5                6                7               */
       0x7f7f,          0x7f80,          0x7f8b,          0x7f8d,
    /*  8                9               10               11               */
       0x7f8f,          0x7f90,          0x7f91,          0x7f96,
    /* 12               13               14               15               */
       0x7f97,          0x7f9c,          0x7fa1,          0x7fa2,
    /* 16               17               18               19               */
       0x7fa6,          0x7faa,          0x7fad,          0x7fb4,
    /* 20               21               22               23               */
       0x7fbc,          0x7fbf,          0x7fc0,          0x7fc3,
    /* 24               25               26               27               */
       0x7fc8,          0x7fce,          0x7fcf,          0x7fdb,
    /* 28               29               30               31               */
       0x7fdf,          0x7fe3,          0x7fe5,          0x7fe8,
    /* 32               33               34               35               */
       0x7fec,          0x7fee,          0x7fef,          0x7ff2,
    /* 36               37               38               39               */
       0x7ffa,          0x7ffd,          0x7ffe,          0x7fff,
    /* 40               41               42               43               */
       0x8007,          0x8008,          0x800a,          0x800d,
    /* 44               45               46               47               */
       0x800e,          0x800f,          0x8011,          0x8013,
    /* 48               49               50               51               */
       0x8014,          0x8016,          0x801d,          0x801e,
    /* 52               53               54               55               */
       0x801f,          0x8020,          0x8024,          0x8026,
    /* 56               57               58               59               */
       0x802c,          0x802e,          0x8030,          0x8034,
    /* 60               61               62               63               */
       0x8035,          0x8037,          0x8039,          0x803a,
    /* 64               65               66               67               */
       0x803c,          0x803e,          0x8040,          0x8044,
    /* 68               69               70               71               */
       0x8060,          0x8064,          0x8066,          0x806d,
    /* 72               73               74               75               */
       0x8071,          0x8075,          0x8081,          0x8088,
    /* 76               77               78               79               */
       0x808e,          0x809c,          0x809e,          0x80a6,
    /* 80               81               82               83               */
       0x80a7,          0x80ab,          0x80b8,          0x80b9,
    /* 84               85               86               87               */
       0x80c8,          0x80cd,          0x80cf,          0x80d2,
    /* 88               89               90               91               */
       0x80d4,          0x80d5,          0x80d7,          0x80d8,
    /* 92               93               94                                */
       0x80e0,          0x80ed,          0x80ee,
/* JIS X 0212 row 54 */
    /*                   1                2                3               */
                        0x80f0,          0x80f2,          0x80f3,
    /*  4                5                6                7               */
       0x80f6,          0x80f9,          0x80fa,          0x80fe,
    /*  8                9               10               11               */
       0x8103,          0x810b,          0x8116,          0x8117,
    /* 12               13               14               15               */
       0x8118,          0x811c,          0x811e,          0x8120,
    /* 16               17               18               19               */
       0x8124,          0x8127,          0x812c,          0x8130,
    /* 20               21               22               23               */
       0x8135,          0x813a,          0x813c,          0x8145,
    /* 24               25               26               27               */
       0x8147,          0x814a,          0x814c,          0x8152,
    /* 28               29               30               31               */
       0x8157,          0x8160,          0x8161,          0x8167,
    /* 32               33               34               35               */
       0x8168,          0x8169,          0x816d,          0x816f,
    /* 36               37               38               39               */
       0x8177,          0x8181,          0x8190,          0x8184,
    /* 40               41               42               43               */
       0x8185,          0x8186,          0x818b,          0x818e,
    /* 44               45               46               47               */
       0x8196,          0x8198,          0x819b,          0x819e,
    /* 48               49               50               51               */
       0x81a2,          0x81ae,          0x81b2,          0x81b4,
    /* 52               53               54               55               */
       0x81bb,          0x81cb,          0x81c3,          0x81c5,
    /* 56               57               58               59               */
       0x81ca,          0x81ce,          0x81cf,          0x81d5,
    /* 60               61               62               63               */
       0x81d7,          0x81db,          0x81dd,          0x81de,
    /* 64               65               66               67               */
       0x81e1,          0x81e4,          0x81eb,          0x81ec,
    /* 68               69               70               71               */
       0x81f0,          0x81f1,          0x81f2,          0x81f5,
    /* 72               73               74               75               */
       0x81f6,          0x81f8,          0x81f9,          0x81fd,
    /* 76               77               78               79               */
       0x81ff,          0x8200,          0x8203,          0x820f,
    /* 80               81               82               83               */
       0x8213,          0x8214,          0x8219,          0x821a,
    /* 84               85               86               87               */
       0x821d,          0x8221,          0x8222,          0x8228,
    /* 88               89               90               91               */
       0x8232,          0x8234,          0x823a,          0x8243,
    /* 92               93               94                                */
       0x8244,          0x8245,          0x8246,
/* JIS X 0212 row 55 */
    /*                   1                2                3               */
                        0x824b,          0x824e,          0x824f,
    /*  4                5                6                7               */
       0x8251,          0x8256,          0x825c,          0x8260,
    /*  8                9               10               11               */
       0x8263,          0x8267,          0x826d,          0x8274,
    /* 12               13               14               15               */
       0x827b,          0x827d,          0x827f,          0x8280,
    /* 16               17               18               19               */
       0x8281,          0x8283,          0x8284,          0x8287,
    /* 20               21               22               23               */
       0x8289,          0x828a,          0x828e,          0x8291,
    /* 24               25               26               27               */
       0x8294,          0x8296,          0x8298,          0x829a,
    /* 28               29               30               31               */
       0x829b,          0x82a0,          0x82a1,          0x82a3,
    /* 32               33               34               35               */
       0x82a4,          0x82a7,          0x82a8,          0x82a9,
    /* 36               37               38               39               */
       0x82aa,          0x82ae,          0x82b0,          0x82b2,
    /* 40               41               42               43               */
       0x82b4,          0x82b7,          0x82ba,          0x82bc,
    /* 44               45               46               47               */
       0x82be,          0x82bf,          0x82c6,          0x82d0,
    /* 48               49               50               51               */
       0x82d5,          0x82da,          0x82e0,          0x82e2,
    /* 52               53               54               55               */
       0x82e4,          0x82e8,          0x82ea,          0x82ed,
    /* 56               57               58               59               */
       0x82ef,          0x82f6,          0x82f7,          0x82fd,
    /* 60               61               62               63               */
       0x82fe,          0x8300,          0x8301,          0x8307,
    /* 64               65               66               67               */
       0x8308,          0x830a,          0x830b,          0x8354,
    /* 68               69               70               71               */
       0x831b,          0x831d,          0x831e,          0x831f,
    /* 72               73               74               75               */
       0x8321,          0x8322,          0x832c,          0x832d,
    /* 76               77               78               79               */
       0x832e,          0x8330,          0x8333,          0x8337,
    /* 80               81               82               83               */
       0x833a,          0x833c,          0x833d,          0x8342,
    /* 84               85               86               87               */
       0x8343,          0x8344,          0x8347,          0x834d,
    /* 88               89               90               91               */
       0x834e,          0x8351,          0x8355,          0x8356,
    /* 92               93               94                                */
       0x8357,          0x8370,          0x8378,
/* JIS X 0212 row 56 */
    /*                   1                2                3               */
                        0x837d,          0x837f,          0x8380,
    /*  4                5                6                7               */
       0x8382,          0x8384,          0x8386,          0x838d,
    /*  8                9               10               11               */
       0x8392,          0x8394,          0x8395,          0x8398,
    /* 12               13               14               15               */
       0x8399,          0x839b,          0x839c,          0x839d,
    /* 16               17               18               19               */
       0x83a6,          0x83a7,          0x83a9,          0x83ac,
    /* 20               21               22               23               */
       0x83be,          0x83bf,          0x83c0,          0x83c7,
    /* 24               25               26               27               */
       0x83c9,          0x83cf,          0x83d0,          0x83d1,
    /* 28               29               30               31               */
       0x83d4,          0x83dd,          0x8353,          0x83e8,
    /* 32               33               34               35               */
       0x83ea,          0x83f6,          0x83f8,          0x83f9,
    /* 36               37               38               39               */
       0x83fc,          0x8401,          0x8406,          0x840a,
    /* 40               41               42               43               */
       0x840f,          0x8411,          0x8415,          0x8419,
    /* 44               45               46               47               */
       0x83ad,          0x842f,          0x8439,          0x8445,
    /* 48               49               50               51               */
       0x8447,          0x8448,          0x844a,          0x844d,
    /* 52               53               54               55               */
       0x844f,          0x8451,          0x8452,          0x8456,
    /* 56               57               58               59               */
       0x8458,          0x8459,          0x845a,          0x845c,
    /* 60               61               62               63               */
       0x8460,          0x8464,          0x8465,          0x8467,
    /* 64               65               66               67               */
       0x846a,          0x8470,          0x8473,          0x8474,
    /* 68               69               70               71               */
       0x8476,          0x8478,          0x847c,          0x847d,
    /* 72               73               74               75               */
       0x8481,          0x8485,          0x8492,          0x8493,
    /* 76               77               78               79               */
       0x8495,          0x849e,          0x84a6,          0x84a8,
    /* 80               81               82               83               */
       0x84a9,          0x84aa,          0x84af,          0x84b1,
    /* 84               85               86               87               */
       0x84b4,          0x84ba,          0x84bd,          0x84be,
    /* 88               89               90               91               */
       0x84c0,          0x84c2,          0x84c7,          0x84c8,
    /* 92               93               94                                */
       0x84cc,          0x84cf,          0x84d3,
/* JIS X 0212 row 57 */
    /*                   1                2                3               */
                        0x84dc,          0x84e7,          0x84ea,
    /*  4                5                6                7               */
       0x84ef,          0x84f0,          0x84f1,          0x84f2,
    /*  8                9               10               11               */
       0x84f7,          0x8532,          0x84fa,          0x84fb,
    /* 12               13               14               15               */
       0x84fd,          0x8502,          0x8503,          0x8507,
    /* 16               17               18               19               */
       0x850c,          0x850e,          0x8510,          0x851c,
    /* 20               21               22               23               */
       0x851e,          0x8522,          0x8523,          0x8524,
    /* 24               25               26               27               */
       0x8525,          0x8527,          0x852a,          0x852b,
    /* 28               29               30               31               */
       0x852f,          0x8533,          0x8534,          0x8536,
    /* 32               33               34               35               */
       0x853f,          0x8546,          0x854f,          0x8550,
    /* 36               37               38               39               */
       0x8551,          0x8552,          0x8553,          0x8556,
    /* 40               41               42               43               */
       0x8559,          0x855c,          0x855d,          0x855e,
    /* 44               45               46               47               */
       0x855f,          0x8560,          0x8561,          0x8562,
    /* 48               49               50               51               */
       0x8564,          0x856b,          0x856f,          0x8579,
    /* 52               53               54               55               */
       0x857a,          0x857b,          0x857d,          0x857f,
    /* 56               57               58               59               */
       0x8581,          0x8585,          0x8586,          0x8589,
    /* 60               61               62               63               */
       0x858b,          0x858c,          0x858f,          0x8593,
    /* 64               65               66               67               */
       0x8598,          0x859d,          0x859f,          0x85a0,
    /* 68               69               70               71               */
       0x85a2,          0x85a5,          0x85a7,          0x85b4,
    /* 72               73               74               75               */
       0x85b6,          0x85b7,          0x85b8,          0x85bc,
    /* 76               77               78               79               */
       0x85bd,          0x85be,          0x85bf,          0x85c2,
    /* 80               81               82               83               */
       0x85c7,          0x85ca,          0x85cb,          0x85ce,
    /* 84               85               86               87               */
       0x85ad,          0x85d8,          0x85da,          0x85df,
    /* 88               89               90               91               */
       0x85e0,          0x85e6,          0x85e8,          0x85ed,
    /* 92               93               94                                */
       0x85f3,          0x85f6,          0x85fc,
/* JIS X 0212 row 58 */
    /*                   1                2                3               */
                        0x85ff,          0x8600,          0x8604,
    /*  4                5                6                7               */
       0x8605,          0x860d,          0x860e,          0x8610,
    /*  8                9               10               11               */
       0x8611,          0x8612,          0x8618,          0x8619,
    /* 12               13               14               15               */
       0x861b,          0x861e,          0x8621,          0x8627,
    /* 16               17               18               19               */
       0x8629,          0x8636,          0x8638,          0x863a,
    /* 20               21               22               23               */
       0x863c,          0x863d,          0x8640,          0x8642,
    /* 24               25               26               27               */
       0x8646,          0x8652,          0x8653,          0x8656,
    /* 28               29               30               31               */
       0x8657,          0x8658,          0x8659,          0x865d,
    /* 32               33               34               35               */
       0x8660,          0x8661,          0x8662,          0x8663,
    /* 36               37               38               39               */
       0x8664,          0x8669,          0x866c,          0x866f,
    /* 40               41               42               43               */
       0x8675,          0x8676,          0x8677,          0x867a,
    /* 44               45               46               47               */
       0x868d,          0x8691,          0x8696,          0x8698,
    /* 48               49               50               51               */
       0x869a,          0x869c,          0x86a1,          0x86a6,
    /* 52               53               54               55               */
       0x86a7,          0x86a8,          0x86ad,          0x86b1,
    /* 56               57               58               59               */
       0x86b3,          0x86b4,          0x86b5,          0x86b7,
    /* 60               61               62               63               */
       0x86b8,          0x86b9,          0x86bf,          0x86c0,
    /* 64               65               66               67               */
       0x86c1,          0x86c3,          0x86c5,          0x86d1,
    /* 68               69               70               71               */
       0x86d2,          0x86d5,          0x86d7,          0x86da,
    /* 72               73               74               75               */
       0x86dc,          0x86e0,          0x86e3,          0x86e5,
    /* 76               77               78               79               */
       0x86e7,          0x8688,          0x86fa,          0x86fc,
    /* 80               81               82               83               */
       0x86fd,          0x8704,          0x8705,          0x8707,
    /* 84               85               86               87               */
       0x870b,          0x870e,          0x870f,          0x8710,
    /* 88               89               90               91               */
       0x8713,          0x8714,          0x8719,          0x871e,
    /* 92               93               94                                */
       0x871f,          0x8721,          0x8723,
/* JIS X 0212 row 59 */
    /*                   1                2                3               */
                        0x8728,          0x872e,          0x872f,
    /*  4                5                6                7               */
       0x8731,          0x8732,          0x8739,          0x873a,
    /*  8                9               10               11               */
       0x873c,          0x873d,          0x873e,          0x8740,
    /* 12               13               14               15               */
       0x8743,          0x8745,          0x874d,          0x8758,
    /* 16               17               18               19               */
       0x875d,          0x8761,          0x8764,          0x8765,
    /* 20               21               22               23               */
       0x876f,          0x8771,          0x8772,          0x877b,
    /* 24               25               26               27               */
       0x8783,          0x8784,          0x8785,          0x8786,
    /* 28               29               30               31               */
       0x8787,          0x8788,          0x8789,          0x878b,
    /* 32               33               34               35               */
       0x878c,          0x8790,          0x8793,          0x8795,
    /* 36               37               38               39               */
       0x8797,          0x8798,          0x8799,          0x879e,
    /* 40               41               42               43               */
       0x87a0,          0x87a3,          0x87a7,          0x87ac,
    /* 44               45               46               47               */
       0x87ad,          0x87ae,          0x87b1,          0x87b5,
    /* 48               49               50               51               */
       0x87be,          0x87bf,          0x87c1,          0x87c8,
    /* 52               53               54               55               */
       0x87c9,          0x87ca,          0x87ce,          0x87d5,
    /* 56               57               58               59               */
       0x87d6,          0x87d9,          0x87da,          0x87dc,
    /* 60               61               62               63               */
       0x87df,          0x87e2,          0x87e3,          0x87e4,
    /* 64               65               66               67               */
       0x87ea,          0x87eb,          0x87ed,          0x87f1,
    /* 68               69               70               71               */
       0x87f3,          0x87f8,          0x87fa,          0x87ff,
    /* 72               73               74               75               */
       0x8801,          0x8803,          0x8806,          0x8809,
    /* 76               77               78               79               */
       0x880a,          0x880b,          0x8810,          0x8819,
    /* 80               81               82               83               */
       0x8812,          0x8813,          0x8814,          0x8818,
    /* 84               85               86               87               */
       0x881a,          0x881b,          0x881c,          0x881e,
    /* 88               89               90               91               */
       0x881f,          0x8828,          0x882d,          0x882e,
    /* 92               93               94                                */
       0x8830,          0x8832,          0x8835,
/* JIS X 0212 row 60 */
    /*                   1                2                3               */
                        0x883a,          0x883c,          0x8841,
    /*  4                5                6                7               */
       0x8843,          0x8845,          0x8848,          0x8849,
    /*  8                9               10               11               */
       0x884a,          0x884b,          0x884e,          0x8851,
    /* 12               13               14               15               */
       0x8855,          0x8856,          0x8858,          0x885a,
    /* 16               17               18               19               */
       0x885c,          0x885f,          0x8860,          0x8864,
    /* 20               21               22               23               */
       0x8869,          0x8871,          0x8879,          0x887b,
    /* 24               25               26               27               */
       0x8880,          0x8898,          0x889a,          0x889b,
    /* 28               29               30               31               */
       0x889c,          0x889f,          0x88a0,          0x88a8,
    /* 32               33               34               35               */
       0x88aa,          0x88ba,          0x88bd,          0x88be,
    /* 36               37               38               39               */
       0x88c0,          0x88ca,          0x88cb,          0x88cc,
    /* 40               41               42               43               */
       0x88cd,          0x88ce,          0x88d1,          0x88d2,
    /* 44               45               46               47               */
       0x88d3,          0x88db,          0x88de,          0x88e7,
    /* 48               49               50               51               */
       0x88ef,          0x88f0,          0x88f1,          0x88f5,
    /* 52               53               54               55               */
       0x88f7,          0x8901,          0x8906,          0x890d,
    /* 56               57               58               59               */
       0x890e,          0x890f,          0x8915,          0x8916,
    /* 60               61               62               63               */
       0x8918,          0x8919,          0x891a,          0x891c,
    /* 64               65               66               67               */
       0x8920,          0x8926,          0x8927,          0x8928,
    /* 68               69               70               71               */
       0x8930,          0x8931,          0x8932,          0x8935,
    /* 72               73               74               75               */
       0x8939,          0x893a,          0x893e,          0x8940,
    /* 76               77               78               79               */
       0x8942,          0x8945,          0x8946,          0x8949,
    /* 80               81               82               83               */
       0x894f,          0x8952,          0x8957,          0x895a,
    /* 84               85               86               87               */
       0x895b,          0x895c,          0x8961,          0x8962,
    /* 88               89               90               91               */
       0x8963,          0x896b,          0x896e,          0x8970,
    /* 92               93               94                                */
       0x8973,          0x8975,          0x897a,
/* JIS X 0212 row 61 */
    /*                   1                2                3               */
                        0x897b,          0x897c,          0x897d,
    /*  4                5                6                7               */
       0x8989,          0x898d,          0x8990,          0x8994,
    /*  8                9               10               11               */
       0x8995,          0x899b,          0x899c,          0x899f,
    /* 12               13               14               15               */
       0x89a0,          0x89a5,          0x89b0,          0x89b4,
    /* 16               17               18               19               */
       0x89b5,          0x89b6,          0x89b7,          0x89bc,
    /* 20               21               22               23               */
       0x89d4,          0x89d5,          0x89d6,          0x89d7,
    /* 24               25               26               27               */
       0x89d8,          0x89e5,          0x89e9,          0x89eb,
    /* 28               29               30               31               */
       0x89ed,          0x89f1,          0x89f3,          0x89f6,
    /* 32               33               34               35               */
       0x89f9,          0x89fd,          0x89ff,          0x8a04,
    /* 36               37               38               39               */
       0x8a05,          0x8a07,          0x8a0f,          0x8a11,
    /* 40               41               42               43               */
       0x8a12,          0x8a14,          0x8a15,          0x8a1e,
    /* 44               45               46               47               */
       0x8a20,          0x8a22,          0x8a24,          0x8a26,
    /* 48               49               50               51               */
       0x8a2b,          0x8a2c,          0x8a2f,          0x8a35,
    /* 52               53               54               55               */
       0x8a37,          0x8a3d,          0x8a3e,          0x8a40,
    /* 56               57               58               59               */
       0x8a43,          0x8a45,          0x8a47,          0x8a49,
    /* 60               61               62               63               */
       0x8a4d,          0x8a4e,          0x8a53,          0x8a56,
    /* 64               65               66               67               */
       0x8a57,          0x8a58,          0x8a5c,          0x8a5d,
    /* 68               69               70               71               */
       0x8a61,          0x8a65,          0x8a67,          0x8a75,
    /* 72               73               74               75               */
       0x8a76,          0x8a77,          0x8a79,          0x8a7a,
    /* 76               77               78               79               */
       0x8a7b,          0x8a7e,          0x8a7f,          0x8a80,
    /* 80               81               82               83               */
       0x8a83,          0x8a86,          0x8a8b,          0x8a8f,
    /* 84               85               86               87               */
       0x8a90,          0x8a92,          0x8a96,          0x8a97,
    /* 88               89               90               91               */
       0x8a99,          0x8a9f,          0x8aa7,          0x8aa9,
    /* 92               93               94                                */
       0x8aae,          0x8aaf,          0x8ab3,
/* JIS X 0212 row 62 */
    /*                   1                2                3               */
                        0x8ab6,          0x8ab7,          0x8abb,
    /*  4                5                6                7               */
       0x8abe,          0x8ac3,          0x8ac6,          0x8ac8,
    /*  8                9               10               11               */
       0x8ac9,          0x8aca,          0x8ad1,          0x8ad3,
    /* 12               13               14               15               */
       0x8ad4,          0x8ad5,          0x8ad7,          0x8add,
    /* 16               17               18               19               */
       0x8adf,          0x8aec,          0x8af0,          0x8af4,
    /* 20               21               22               23               */
       0x8af5,          0x8af6,          0x8afc,          0x8aff,
    /* 24               25               26               27               */
       0x8b05,          0x8b06,          0x8b0b,          0x8b11,
    /* 28               29               30               31               */
       0x8b1c,          0x8b1e,          0x8b1f,          0x8b0a,
    /* 32               33               34               35               */
       0x8b2d,          0x8b30,          0x8b37,          0x8b3c,
    /* 36               37               38               39               */
       0x8b42,          0x8b43,          0x8b44,          0x8b45,
    /* 40               41               42               43               */
       0x8b46,          0x8b48,          0x8b52,          0x8b53,
    /* 44               45               46               47               */
       0x8b54,          0x8b59,          0x8b4d,          0x8b5e,
    /* 48               49               50               51               */
       0x8b63,          0x8b6d,          0x8b76,          0x8b78,
    /* 52               53               54               55               */
       0x8b79,          0x8b7c,          0x8b7e,          0x8b81,
    /* 56               57               58               59               */
       0x8b84,          0x8b85,          0x8b8b,          0x8b8d,
    /* 60               61               62               63               */
       0x8b8f,          0x8b94,          0x8b95,          0x8b9c,
    /* 64               65               66               67               */
       0x8b9e,          0x8b9f,          0x8c38,          0x8c39,
    /* 68               69               70               71               */
       0x8c3d,          0x8c3e,          0x8c45,          0x8c47,
    /* 72               73               74               75               */
       0x8c49,          0x8c4b,          0x8c4f,          0x8c51,
    /* 76               77               78               79               */
       0x8c53,          0x8c54,          0x8c57,          0x8c58,
    /* 80               81               82               83               */
       0x8c5b,          0x8c5d,          0x8c59,          0x8c63,
    /* 84               85               86               87               */
       0x8c64,          0x8c66,          0x8c68,          0x8c69,
    /* 88               89               90               91               */
       0x8c6d,          0x8c73,          0x8c75,          0x8c76,
    /* 92               93               94                                */
       0x8c7b,          0x8c7e,          0x8c86,
/* JIS X 0212 row 63 */
    /*                   1                2                3               */
                        0x8c87,          0x8c8b,          0x8c90,
    /*  4                5                6                7               */
       0x8c92,          0x8c93,          0x8c99,          0x8c9b,
    /*  8                9               10               11               */
       0x8c9c,          0x8ca4,          0x8cb9,          0x8cba,
    /* 12               13               14               15               */
       0x8cc5,          0x8cc6,          0x8cc9,          0x8ccb,
    /* 16               17               18               19               */
       0x8ccf,          0x8cd6,          0x8cd5,          0x8cd9,
    /* 20               21               22               23               */
       0x8cdd,          0x8ce1,          0x8ce8,          0x8cec,
    /* 24               25               26               27               */
       0x8cef,          0x8cf0,          0x8cf2,          0x8cf5,
    /* 28               29               30               31               */
       0x8cf7,          0x8cf8,          0x8cfe,          0x8cff,
    /* 32               33               34               35               */
       0x8d01,          0x8d03,          0x8d09,          0x8d12,
    /* 36               37               38               39               */
       0x8d17,          0x8d1b,          0x8d65,          0x8d69,
    /* 40               41               42               43               */
       0x8d6c,          0x8d6e,          0x8d7f,          0x8d82,
    /* 44               45               46               47               */
       0x8d84,          0x8d88,          0x8d8d,          0x8d90,
    /* 48               49               50               51               */
       0x8d91,          0x8d95,          0x8d9e,          0x8d9f,
    /* 52               53               54               55               */
       0x8da0,          0x8da6,          0x8dab,          0x8dac,
    /* 56               57               58               59               */
       0x8daf,          0x8db2,          0x8db5,          0x8db7,
    /* 60               61               62               63               */
       0x8db9,          0x8dbb,          0x8dc0,          0x8dc5,
    /* 64               65               66               67               */
       0x8dc6,          0x8dc7,          0x8dc8,          0x8dca,
    /* 68               69               70               71               */
       0x8dce,          0x8dd1,          0x8dd4,          0x8dd5,
    /* 72               73               74               75               */
       0x8dd7,          0x8dd9,          0x8de4,          0x8de5,
    /* 76               77               78               79               */
       0x8de7,          0x8dec,          0x8df0,          0x8dbc,
    /* 80               81               82               83               */
       0x8df1,          0x8df2,          0x8df4,          0x8dfd,
    /* 84               85               86               87               */
       0x8e01,          0x8e04,          0x8e05,          0x8e06,
    /* 88               89               90               91               */
       0x8e0b,          0x8e11,          0x8e14,          0x8e16,
    /* 92               93               94                                */
       0x8e20,          0x8e21,          0x8e22,
/* JIS X 0212 row 64 */
    /*                   1                2                3               */
                        0x8e23,          0x8e26,          0x8e27,
    /*  4                5                6                7               */
       0x8e31,          0x8e33,          0x8e36,          0x8e37,
    /*  8                9               10               11               */
       0x8e38,          0x8e39,          0x8e3d,          0x8e40,
    /* 12               13               14               15               */
       0x8e41,          0x8e4b,          0x8e4d,          0x8e4e,
    /* 16               17               18               19               */
       0x8e4f,          0x8e54,          0x8e5b,          0x8e5c,
    /* 20               21               22               23               */
       0x8e5d,          0x8e5e,          0x8e61,          0x8e62,
    /* 24               25               26               27               */
       0x8e69,          0x8e6c,          0x8e6d,          0x8e6f,
    /* 28               29               30               31               */
       0x8e70,          0x8e71,          0x8e79,          0x8e7a,
    /* 32               33               34               35               */
       0x8e7b,          0x8e82,          0x8e83,          0x8e89,
    /* 36               37               38               39               */
       0x8e90,          0x8e92,          0x8e95,          0x8e9a,
    /* 40               41               42               43               */
       0x8e9b,          0x8e9d,          0x8e9e,          0x8ea2,
    /* 44               45               46               47               */
       0x8ea7,          0x8ea9,          0x8ead,          0x8eae,
    /* 48               49               50               51               */
       0x8eb3,          0x8eb5,          0x8eba,          0x8ebb,
    /* 52               53               54               55               */
       0x8ec0,          0x8ec1,          0x8ec3,          0x8ec4,
    /* 56               57               58               59               */
       0x8ec7,          0x8ecf,          0x8ed1,          0x8ed4,
    /* 60               61               62               63               */
       0x8edc,          0x8ee8,          0x8eee,          0x8ef0,
    /* 64               65               66               67               */
       0x8ef1,          0x8ef7,          0x8ef9,          0x8efa,
    /* 68               69               70               71               */
       0x8eed,          0x8f00,          0x8f02,          0x8f07,
    /* 72               73               74               75               */
       0x8f08,          0x8f0f,          0x8f10,          0x8f16,
    /* 76               77               78               79               */
       0x8f17,          0x8f18,          0x8f1e,          0x8f20,
    /* 80               81               82               83               */
       0x8f21,          0x8f23,          0x8f25,          0x8f27,
    /* 84               85               86               87               */
       0x8f28,          0x8f2c,          0x8f2d,          0x8f2e,
    /* 88               89               90               91               */
       0x8f34,          0x8f35,          0x8f36,          0x8f37,
    /* 92               93               94                                */
       0x8f3a,          0x8f40,          0x8f41,
/* JIS X 0212 row 65 */
    /*                   1                2                3               */
                        0x8f43,          0x8f47,          0x8f4f,
    /*  4                5                6                7               */
       0x8f51,          0x8f52,          0x8f53,          0x8f54,
    /*  8                9               10               11               */
       0x8f55,          0x8f58,          0x8f5d,          0x8f5e,
    /* 12               13               14               15               */
       0x8f65,          0x8f9d,          0x8fa0,          0x8fa1,
    /* 16               17               18               19               */
       0x8fa4,          0x8fa5,          0x8fa6,          0x8fb5,
    /* 20               21               22               23               */
       0x8fb6,          0x8fb8,          0x8fbe,          0x8fc0,
    /* 24               25               26               27               */
       0x8fc1,          0x8fc6,          0x8fca,          0x8fcb,
    /* 28               29               30               31               */
       0x8fcd,          0x8fd0,          0x8fd2,          0x8fd3,
    /* 32               33               34               35               */
       0x8fd5,          0x8fe0,          0x8fe3,          0x8fe4,
    /* 36               37               38               39               */
       0x8fe8,          0x8fee,          0x8ff1,          0x8ff5,
    /* 40               41               42               43               */
       0x8ff6,          0x8ffb,          0x8ffe,          0x9002,
    /* 44               45               46               47               */
       0x9004,          0x9008,          0x900c,          0x9018,
    /* 48               49               50               51               */
       0x901b,          0x9028,          0x9029,          0x902f,
    /* 52               53               54               55               */
       0x902a,          0x902c,          0x902d,          0x9033,
    /* 56               57               58               59               */
       0x9034,          0x9037,          0x903f,          0x9043,
    /* 60               61               62               63               */
       0x9044,          0x904c,          0x905b,          0x905d,
    /* 64               65               66               67               */
       0x9062,          0x9066,          0x9067,          0x906c,
    /* 68               69               70               71               */
       0x9070,          0x9074,          0x9079,          0x9085,
    /* 72               73               74               75               */
       0x9088,          0x908b,          0x908c,          0x908e,
    /* 76               77               78               79               */
       0x9090,          0x9095,          0x9097,          0x9098,
    /* 80               81               82               83               */
       0x9099,          0x909b,          0x90a0,          0x90a1,
    /* 84               85               86               87               */
       0x90a2,          0x90a5,          0x90b0,          0x90b2,
    /* 88               89               90               91               */
       0x90b3,          0x90b4,          0x90b6,          0x90bd,
    /* 92               93               94                                */
       0x90cc,          0x90be,          0x90c3,
/* JIS X 0212 row 66 */
    /*                   1                2                3               */
                        0x90c4,          0x90c5,          0x90c7,
    /*  4                5                6                7               */
       0x90c8,          0x90d5,          0x90d7,          0x90d8,
    /*  8                9               10               11               */
       0x90d9,          0x90dc,          0x90dd,          0x90df,
    /* 12               13               14               15               */
       0x90e5,          0x90d2,          0x90f6,          0x90eb,
    /* 16               17               18               19               */
       0x90ef,          0x90f0,          0x90f4,          0x90fe,
    /* 20               21               22               23               */
       0x90ff,          0x9100,          0x9104,          0x9105,
    /* 24               25               26               27               */
       0x9106,          0x9108,          0x910d,          0x9110,
    /* 28               29               30               31               */
       0x9114,          0x9116,          0x9117,          0x9118,
    /* 32               33               34               35               */
       0x911a,          0x911c,          0x911e,          0x9120,
    /* 36               37               38               39               */
       0x9125,          0x9122,          0x9123,          0x9127,
    /* 40               41               42               43               */
       0x9129,          0x912e,          0x912f,          0x9131,
    /* 44               45               46               47               */
       0x9134,          0x9136,          0x9137,          0x9139,
    /* 48               49               50               51               */
       0x913a,          0x913c,          0x913d,          0x9143,
    /* 52               53               54               55               */
       0x9147,          0x9148,          0x914f,          0x9153,
    /* 56               57               58               59               */
       0x9157,          0x9159,          0x915a,          0x915b,
    /* 60               61               62               63               */
       0x9161,          0x9164,          0x9167,          0x916d,
    /* 64               65               66               67               */
       0x9174,          0x9179,          0x917a,          0x917b,
    /* 68               69               70               71               */
       0x9181,          0x9183,          0x9185,          0x9186,
    /* 72               73               74               75               */
       0x918a,          0x918e,          0x9191,          0x9193,
    /* 76               77               78               79               */
       0x9194,          0x9195,          0x9198,          0x919e,
    /* 80               81               82               83               */
       0x91a1,          0x91a6,          0x91a8,          0x91ac,
    /* 84               85               86               87               */
       0x91ad,          0x91ae,          0x91b0,          0x91b1,
    /* 88               89               90               91               */
       0x91b2,          0x91b3,          0x91b6,          0x91bb,
    /* 92               93               94                                */
       0x91bc,          0x91bd,          0x91bf,
/* JIS X 0212 row 67 */
    /*                   1                2                3               */
                        0x91c2,          0x91c3,          0x91c5,
    /*  4                5                6                7               */
       0x91d3,          0x91d4,          0x91d7,          0x91d9,
    /*  8                9               10               11               */
       0x91da,          0x91de,          0x91e4,          0x91e5,
    /* 12               13               14               15               */
       0x91e9,          0x91ea,          0x91ec,          0x91ed,
    /* 16               17               18               19               */
       0x91ee,          0x91ef,          0x91f0,          0x91f1,
    /* 20               21               22               23               */
       0x91f7,          0x91f9,          0x91fb,          0x91fd,
    /* 24               25               26               27               */
       0x9200,          0x9201,          0x9204,          0x9205,
    /* 28               29               30               31               */
       0x9206,          0x9207,          0x9209,          0x920a,
    /* 32               33               34               35               */
       0x920c,          0x9210,          0x9212,          0x9213,
    /* 36               37               38               39               */
       0x9216,          0x9218,          0x921c,          0x921d,
    /* 40               41               42               43               */
       0x9223,          0x9224,          0x9225,          0x9226,
    /* 44               45               46               47               */
       0x9228,          0x922e,          0x922f,          0x9230,
    /* 48               49               50               51               */
       0x9233,          0x9235,          0x9236,          0x9238,
    /* 52               53               54               55               */
       0x9239,          0x923a,          0x923c,          0x923e,
    /* 56               57               58               59               */
       0x9240,          0x9242,          0x9243,          0x9246,
    /* 60               61               62               63               */
       0x9247,          0x924a,          0x924d,          0x924e,
    /* 64               65               66               67               */
       0x924f,          0x9251,          0x9258,          0x9259,
    /* 68               69               70               71               */
       0x925c,          0x925d,          0x9260,          0x9261,
    /* 72               73               74               75               */
       0x9265,          0x9267,          0x9268,          0x9269,
    /* 76               77               78               79               */
       0x926e,          0x926f,          0x9270,          0x9275,
    /* 80               81               82               83               */
       0x9276,          0x9277,          0x9278,          0x9279,
    /* 84               85               86               87               */
       0x927b,          0x927c,          0x927d,          0x927f,
    /* 88               89               90               91               */
       0x9288,          0x9289,          0x928a,          0x928d,
    /* 92               93               94                                */
       0x928e,          0x9292,          0x9297,
/* JIS X 0212 row 68 */
    /*                   1                2                3               */
                        0x9299,          0x929f,          0x92a0,
    /*  4                5                6                7               */
       0x92a4,          0x92a5,          0x92a7,          0x92a8,
    /*  8                9               10               11               */
       0x92ab,          0x92af,          0x92b2,          0x92b6,
    /* 12               13               14               15               */
       0x92b8,          0x92ba,          0x92bb,          0x92bc,
    /* 16               17               18               19               */
       0x92bd,          0x92bf,          0x92c0,          0x92c1,
    /* 20               21               22               23               */
       0x92c2,          0x92c3,          0x92c5,          0x92c6,
    /* 24               25               26               27               */
       0x92c7,          0x92c8,          0x92cb,          0x92cc,
    /* 28               29               30               31               */
       0x92cd,          0x92ce,          0x92d0,          0x92d3,
    /* 32               33               34               35               */
       0x92d5,          0x92d7,          0x92d8,          0x92d9,
    /* 36               37               38               39               */
       0x92dc,          0x92dd,          0x92df,          0x92e0,
    /* 40               41               42               43               */
       0x92e1,          0x92e3,          0x92e5,          0x92e7,
    /* 44               45               46               47               */
       0x92e8,          0x92ec,          0x92ee,          0x92f0,
    /* 48               49               50               51               */
       0x92f9,          0x92fb,          0x92ff,          0x9300,
    /* 52               53               54               55               */
       0x9302,          0x9308,          0x930d,          0x9311,
    /* 56               57               58               59               */
       0x9314,          0x9315,          0x931c,          0x931d,
    /* 60               61               62               63               */
       0x931e,          0x931f,          0x9321,          0x9324,
    /* 64               65               66               67               */
       0x9325,          0x9327,          0x9329,          0x932a,
    /* 68               69               70               71               */
       0x9333,          0x9334,          0x9336,          0x9337,
    /* 72               73               74               75               */
       0x9347,          0x9348,          0x9349,          0x9350,
    /* 76               77               78               79               */
       0x9351,          0x9352,          0x9355,          0x9357,
    /* 80               81               82               83               */
       0x9358,          0x935a,          0x935e,          0x9364,
    /* 84               85               86               87               */
       0x9365,          0x9367,          0x9369,          0x936a,
    /* 88               89               90               91               */
       0x936d,          0x936f,          0x9370,          0x9371,
    /* 92               93               94                                */
       0x9373,          0x9374,          0x9376,
/* JIS X 0212 row 69 */
    /*                   1                2                3               */
                        0x937a,          0x937d,          0x937f,
    /*  4                5                6                7               */
       0x9380,          0x9381,          0x9382,          0x9388,
    /*  8                9               10               11               */
       0x938a,          0x938b,          0x938d,          0x938f,
    /* 12               13               14               15               */
       0x9392,          0x9395,          0x9398,          0x939b,
    /* 16               17               18               19               */
       0x939e,          0x93a1,          0x93a3,          0x93a4,
    /* 20               21               22               23               */
       0x93a6,          0x93a8,          0x93ab,          0x93b4,
    /* 24               25               26               27               */
       0x93b5,          0x93b6,          0x93ba,          0x93a9,
    /* 28               29               30               31               */
       0x93c1,          0x93c4,          0x93c5,          0x93c6,
    /* 32               33               34               35               */
       0x93c7,          0x93c9,          0x93ca,          0x93cb,
    /* 36               37               38               39               */
       0x93cc,          0x93cd,          0x93d3,          0x93d9,
    /* 40               41               42               43               */
       0x93dc,          0x93de,          0x93df,          0x93e2,
    /* 44               45               46               47               */
       0x93e6,          0x93e7,          0x93f9,          0x93f7,
    /* 48               49               50               51               */
       0x93f8,          0x93fa,          0x93fb,          0x93fd,
    /* 52               53               54               55               */
       0x9401,          0x9402,          0x9404,          0x9408,
    /* 56               57               58               59               */
       0x9409,          0x940d,          0x940e,          0x940f,
    /* 60               61               62               63               */
       0x9415,          0x9416,          0x9417,          0x941f,
    /* 64               65               66               67               */
       0x942e,          0x942f,          0x9431,          0x9432,
    /* 68               69               70               71               */
       0x9433,          0x9434,          0x943b,          0x943f,
    /* 72               73               74               75               */
       0x943d,          0x9443,          0x9445,          0x9448,
    /* 76               77               78               79               */
       0x944a,          0x944c,          0x9455,          0x9459,
    /* 80               81               82               83               */
       0x945c,          0x945f,          0x9461,          0x9463,
    /* 84               85               86               87               */
       0x9468,          0x946b,          0x946d,          0x946e,
    /* 88               89               90               91               */
       0x946f,          0x9471,          0x9472,          0x9484,
    /* 92               93               94                                */
       0x9483,          0x9578,          0x9579,
/* JIS X 0212 row 70 */
    /*                   1                2                3               */
                        0x957e,          0x9584,          0x9588,
    /*  4                5                6                7               */
       0x958c,          0x958d,          0x958e,          0x959d,
    /*  8                9               10               11               */
       0x959e,          0x959f,          0x95a1,          0x95a6,
    /* 12               13               14               15               */
       0x95a9,          0x95ab,          0x95ac,          0x95b4,
    /* 16               17               18               19               */
       0x95b6,          0x95ba,          0x95bd,          0x95bf,
    /* 20               21               22               23               */
       0x95c6,          0x95c8,          0x95c9,          0x95cb,
    /* 24               25               26               27               */
       0x95d0,          0x95d1,          0x95d2,          0x95d3,
    /* 28               29               30               31               */
       0x95d9,          0x95da,          0x95dd,          0x95de,
    /* 32               33               34               35               */
       0x95df,          0x95e0,          0x95e4,          0x95e6,
    /* 36               37               38               39               */
       0x961d,          0x961e,          0x9622,          0x9624,
    /* 40               41               42               43               */
       0x9625,          0x9626,          0x962c,          0x9631,
    /* 44               45               46               47               */
       0x9633,          0x9637,          0x9638,          0x9639,
    /* 48               49               50               51               */
       0x963a,          0x963c,          0x963d,          0x9641,
    /* 52               53               54               55               */
       0x9652,          0x9654,          0x9656,          0x9657,
    /* 56               57               58               59               */
       0x9658,          0x9661,          0x966e,          0x9674,
    /* 60               61               62               63               */
       0x967b,          0x967c,          0x967e,          0x967f,
    /* 64               65               66               67               */
       0x9681,          0x9682,          0x9683,          0x9684,
    /* 68               69               70               71               */
       0x9689,          0x9691,          0x9696,          0x969a,
    /* 72               73               74               75               */
       0x969d,          0x969f,          0x96a4,          0x96a5,
    /* 76               77               78               79               */
       0x96a6,          0x96a9,          0x96ae,          0x96af,
    /* 80               81               82               83               */
       0x96b3,          0x96ba,          0x96ca,          0x96d2,
    /* 84               85               86               87               */
       0x5db2,          0x96d8,          0x96da,          0x96dd,
    /* 88               89               90               91               */
       0x96de,          0x96df,          0x96e9,          0x96ef,
    /* 92               93               94                                */
       0x96f1,          0x96fa,          0x9702,
/* JIS X 0212 row 71 */
    /*                   1                2                3               */
                        0x9703,          0x9705,          0x9709,
    /*  4                5                6                7               */
       0x971a,          0x971b,          0x971d,          0x9721,
    /*  8                9               10               11               */
       0x9722,          0x9723,          0x9728,          0x9731,
    /* 12               13               14               15               */
       0x9733,          0x9741,          0x9743,          0x974a,
    /* 16               17               18               19               */
       0x974e,          0x974f,          0x9755,          0x9757,
    /* 20               21               22               23               */
       0x9758,          0x975a,          0x975b,          0x9763,
    /* 24               25               26               27               */
       0x9767,          0x976a,          0x976e,          0x9773,
    /* 28               29               30               31               */
       0x9776,          0x9777,          0x9778,          0x977b,
    /* 32               33               34               35               */
       0x977d,          0x977f,          0x9780,          0x9789,
    /* 36               37               38               39               */
       0x9795,          0x9796,          0x9797,          0x9799,
    /* 40               41               42               43               */
       0x979a,          0x979e,          0x979f,          0x97a2,
    /* 44               45               46               47               */
       0x97ac,          0x97ae,          0x97b1,          0x97b2,
    /* 48               49               50               51               */
       0x97b5,          0x97b6,          0x97b8,          0x97b9,
    /* 52               53               54               55               */
       0x97ba,          0x97bc,          0x97be,          0x97bf,
    /* 56               57               58               59               */
       0x97c1,          0x97c4,          0x97c5,          0x97c7,
    /* 60               61               62               63               */
       0x97c9,          0x97ca,          0x97cc,          0x97cd,
    /* 64               65               66               67               */
       0x97ce,          0x97d0,          0x97d1,          0x97d4,
    /* 68               69               70               71               */
       0x97d7,          0x97d8,          0x97d9,          0x97dd,
    /* 72               73               74               75               */
       0x97de,          0x97e0,          0x97db,          0x97e1,
    /* 76               77               78               79               */
       0x97e4,          0x97ef,          0x97f1,          0x97f4,
    /* 80               81               82               83               */
       0x97f7,          0x97f8,          0x97fa,          0x9807,
    /* 84               85               86               87               */
       0x980a,          0x9819,          0x980d,          0x980e,
    /* 88               89               90               91               */
       0x9814,          0x9816,          0x981c,          0x981e,
    /* 92               93               94                                */
       0x9820,          0x9823,          0x9826,
/* JIS X 0212 row 72 */
    /*                   1                2                3               */
                        0x982b,          0x982e,          0x982f,
    /*  4                5                6                7               */
       0x9830,          0x9832,          0x9833,          0x9835,
    /*  8                9               10               11               */
       0x9825,          0x983e,          0x9844,          0x9847,
    /* 12               13               14               15               */
       0x984a,          0x9851,          0x9852,          0x9853,
    /* 16               17               18               19               */
       0x9856,          0x9857,          0x9859,          0x985a,
    /* 20               21               22               23               */
       0x9862,          0x9863,          0x9865,          0x9866,
    /* 24               25               26               27               */
       0x986a,          0x986c,          0x98ab,          0x98ad,
    /* 28               29               30               31               */
       0x98ae,          0x98b0,          0x98b4,          0x98b7,
    /* 32               33               34               35               */
       0x98b8,          0x98ba,          0x98bb,          0x98bf,
    /* 36               37               38               39               */
       0x98c2,          0x98c5,          0x98c8,          0x98cc,
    /* 40               41               42               43               */
       0x98e1,          0x98e3,          0x98e5,          0x98e6,
    /* 44               45               46               47               */
       0x98e7,          0x98ea,          0x98f3,          0x98f6,
    /* 48               49               50               51               */
       0x9902,          0x9907,          0x9908,          0x9911,
    /* 52               53               54               55               */
       0x9915,          0x9916,          0x9917,          0x991a,
    /* 56               57               58               59               */
       0x991b,          0x991c,          0x991f,          0x9922,
    /* 60               61               62               63               */
       0x9926,          0x9927,          0x992b,          0x9931,
    /* 64               65               66               67               */
       0x9932,          0x9933,          0x9934,          0x9935,
    /* 68               69               70               71               */
       0x9939,          0x993a,          0x993b,          0x993c,
    /* 72               73               74               75               */
       0x9940,          0x9941,          0x9946,          0x9947,
    /* 76               77               78               79               */
       0x9948,          0x994d,          0x994e,          0x9954,
    /* 80               81               82               83               */
       0x9958,          0x9959,          0x995b,          0x995c,
    /* 84               85               86               87               */
       0x995e,          0x995f,          0x9960,          0x999b,
    /* 88               89               90               91               */
       0x999d,          0x999f,          0x99a6,          0x99b0,
    /* 92               93               94                                */
       0x99b1,          0x99b2,          0x99b5,
/* JIS X 0212 row 73 */
    /*                   1                2                3               */
                        0x99b9,          0x99ba,          0x99bd,
    /*  4                5                6                7               */
       0x99bf,          0x99c3,          0x99c9,          0x99d3,
    /*  8                9               10               11               */
       0x99d4,          0x99d9,          0x99da,          0x99dc,
    /* 12               13               14               15               */
       0x99de,          0x99e7,          0x99ea,          0x99eb,
    /* 16               17               18               19               */
       0x99ec,          0x99f0,          0x99f4,          0x99f5,
    /* 20               21               22               23               */
       0x99f9,          0x99fd,          0x99fe,          0x9a02,
    /* 24               25               26               27               */
       0x9a03,          0x9a04,          0x9a0b,          0x9a0c,
    /* 28               29               30               31               */
       0x9a10,          0x9a11,          0x9a16,          0x9a1e,
    /* 32               33               34               35               */
       0x9a20,          0x9a22,          0x9a23,          0x9a24,
    /* 36               37               38               39               */
       0x9a27,          0x9a2d,          0x9a2e,          0x9a33,
    /* 40               41               42               43               */
       0x9a35,          0x9a36,          0x9a38,          0x9a47,
    /* 44               45               46               47               */
       0x9a41,          0x9a44,          0x9a4a,          0x9a4b,
    /* 48               49               50               51               */
       0x9a4c,          0x9a4e,          0x9a51,          0x9a54,
    /* 52               53               54               55               */
       0x9a56,          0x9a5d,          0x9aaa,          0x9aac,
    /* 56               57               58               59               */
       0x9aae,          0x9aaf,          0x9ab2,          0x9ab4,
    /* 60               61               62               63               */
       0x9ab5,          0x9ab6,          0x9ab9,          0x9abb,
    /* 64               65               66               67               */
       0x9abe,          0x9abf,          0x9ac1,          0x9ac3,
    /* 68               69               70               71               */
       0x9ac6,          0x9ac8,          0x9ace,          0x9ad0,
    /* 72               73               74               75               */
       0x9ad2,          0x9ad5,          0x9ad6,          0x9ad7,
    /* 76               77               78               79               */
       0x9adb,          0x9adc,          0x9ae0,          0x9ae4,
    /* 80               81               82               83               */
       0x9ae5,          0x9ae7,          0x9ae9,          0x9aec,
    /* 84               85               86               87               */
       0x9af2,          0x9af3,          0x9af5,          0x9af9,
    /* 88               89               90               91               */
       0x9afa,          0x9afd,          0x9aff,          0x9b00,
    /* 92               93               94                                */
       0x9b01,          0x9b02,          0x9b03,
/* JIS X 0212 row 74 */
    /*                   1                2                3               */
                        0x9b04,          0x9b05,          0x9b08,
    /*  4                5                6                7               */
       0x9b09,          0x9b0b,          0x9b0c,          0x9b0d,
    /*  8                9               10               11               */
       0x9b0e,          0x9b10,          0x9b12,          0x9b16,
    /* 12               13               14               15               */
       0x9b19,          0x9b1b,          0x9b1c,          0x9b20,
    /* 16               17               18               19               */
       0x9b26,          0x9b2b,          0x9b2d,          0x9b33,
    /* 20               21               22               23               */
       0x9b34,          0x9b35,          0x9b37,          0x9b39,
    /* 24               25               26               27               */
       0x9b3a,          0x9b3d,          0x9b48,          0x9b4b,
    /* 28               29               30               31               */
       0x9b4c,          0x9b55,          0x9b56,          0x9b57,
    /* 32               33               34               35               */
       0x9b5b,          0x9b5e,          0x9b61,          0x9b63,
    /* 36               37               38               39               */
       0x9b65,          0x9b66,          0x9b68,          0x9b6a,
    /* 40               41               42               43               */
       0x9b6b,          0x9b6c,          0x9b6d,          0x9b6e,
    /* 44               45               46               47               */
       0x9b73,          0x9b75,          0x9b77,          0x9b78,
    /* 48               49               50               51               */
       0x9b79,          0x9b7f,          0x9b80,          0x9b84,
    /* 52               53               54               55               */
       0x9b85,          0x9b86,          0x9b87,          0x9b89,
    /* 56               57               58               59               */
       0x9b8a,          0x9b8b,          0x9b8d,          0x9b8f,
    /* 60               61               62               63               */
       0x9b90,          0x9b94,          0x9b9a,          0x9b9d,
    /* 64               65               66               67               */
       0x9b9e,          0x9ba6,          0x9ba7,          0x9ba9,
    /* 68               69               70               71               */
       0x9bac,          0x9bb0,          0x9bb1,          0x9bb2,
    /* 72               73               74               75               */
       0x9bb7,          0x9bb8,          0x9bbb,          0x9bbc,
    /* 76               77               78               79               */
       0x9bbe,          0x9bbf,          0x9bc1,          0x9bc7,
    /* 80               81               82               83               */
       0x9bc8,          0x9bce,          0x9bd0,          0x9bd7,
    /* 84               85               86               87               */
       0x9bd8,          0x9bdd,          0x9bdf,          0x9be5,
    /* 88               89               90               91               */
       0x9be7,          0x9bea,          0x9beb,          0x9bef,
    /* 92               93               94                                */
       0x9bf3,          0x9bf7,          0x9bf8,
/* JIS X 0212 row 75 */
    /*                   1                2                3               */
                        0x9bf9,          0x9bfa,          0x9bfd,
    /*  4                5                6                7               */
       0x9bff,          0x9c00,          0x9c02,          0x9c0b,
    /*  8                9               10               11               */
       0x9c0f,          0x9c11,          0x9c16,          0x9c18,
    /* 12               13               14               15               */
       0x9c19,          0x9c1a,          0x9c1c,          0x9c1e,
    /* 16               17               18               19               */
       0x9c22,          0x9c23,          0x9c26,          0x9c27,
    /* 20               21               22               23               */
       0x9c28,          0x9c29,          0x9c2a,          0x9c31,
    /* 24               25               26               27               */
       0x9c35,          0x9c36,          0x9c37,          0x9c3d,
    /* 28               29               30               31               */
       0x9c41,          0x9c43,          0x9c44,          0x9c45,
    /* 32               33               34               35               */
       0x9c49,          0x9c4a,          0x9c4e,          0x9c4f,
    /* 36               37               38               39               */
       0x9c50,          0x9c53,          0x9c54,          0x9c56,
    /* 40               41               42               43               */
       0x9c58,          0x9c5b,          0x9c5d,          0x9c5e,
    /* 44               45               46               47               */
       0x9c5f,          0x9c63,          0x9c69,          0x9c6a,
    /* 48               49               50               51               */
       0x9c5c,          0x9c6b,          0x9c68,          0x9c6e,
    /* 52               53               54               55               */
       0x9c70,          0x9c72,          0x9c75,          0x9c77,
    /* 56               57               58               59               */
       0x9c7b,          0x9ce6,          0x9cf2,          0x9cf7,
    /* 60               61               62               63               */
       0x9cf9,          0x9d0b,          0x9d02,          0x9d11,
    /* 64               65               66               67               */
       0x9d17,          0x9d18,          0x9d1c,          0x9d1d,
    /* 68               69               70               71               */
       0x9d1e,          0x9d2f,          0x9d30,          0x9d32,
    /* 72               73               74               75               */
       0x9d33,          0x9d34,          0x9d3a,          0x9d3c,
    /* 76               77               78               79               */
       0x9d45,          0x9d3d,          0x9d42,          0x9d43,
    /* 80               81               82               83               */
       0x9d47,          0x9d4a,          0x9d53,          0x9d54,
    /* 84               85               86               87               */
       0x9d5f,          0x9d63,          0x9d62,          0x9d65,
    /* 88               89               90               91               */
       0x9d69,          0x9d6a,          0x9d6b,          0x9d70,
    /* 92               93               94                                */
       0x9d76,          0x9d77,          0x9d7b,
/* JIS X 0212 row 76 */
    /*                   1                2                3               */
                        0x9d7c,          0x9d7e,          0x9d83,
    /*  4                5                6                7               */
       0x9d84,          0x9d86,          0x9d8a,          0x9d8d,
    /*  8                9               10               11               */
       0x9d8e,          0x9d92,          0x9d93,          0x9d95,
    /* 12               13               14               15               */
       0x9d96,          0x9d97,          0x9d98,          0x9da1,
    /* 16               17               18               19               */
       0x9daa,          0x9dac,          0x9dae,          0x9db1,
    /* 20               21               22               23               */
       0x9db5,          0x9db9,          0x9dbc,          0x9dbf,
    /* 24               25               26               27               */
       0x9dc3,          0x9dc7,          0x9dc9,          0x9dca,
    /* 28               29               30               31               */
       0x9dd4,          0x9dd5,          0x9dd6,          0x9dd7,
    /* 32               33               34               35               */
       0x9dda,          0x9dde,          0x9ddf,          0x9de0,
    /* 36               37               38               39               */
       0x9de5,          0x9de7,          0x9de9,          0x9deb,
    /* 40               41               42               43               */
       0x9dee,          0x9df0,          0x9df3,          0x9df4,
    /* 44               45               46               47               */
       0x9dfe,          0x9e0a,          0x9e02,          0x9e07,
    /* 48               49               50               51               */
       0x9e0e,          0x9e10,          0x9e11,          0x9e12,
    /* 52               53               54               55               */
       0x9e15,          0x9e16,          0x9e19,          0x9e1c,
    /* 56               57               58               59               */
       0x9e1d,          0x9e7a,          0x9e7b,          0x9e7c,
    /* 60               61               62               63               */
       0x9e80,          0x9e82,          0x9e83,          0x9e84,
    /* 64               65               66               67               */
       0x9e85,          0x9e87,          0x9e8e,          0x9e8f,
    /* 68               69               70               71               */
       0x9e96,          0x9e98,          0x9e9b,          0x9e9e,
    /* 72               73               74               75               */
       0x9ea4,          0x9ea8,          0x9eac,          0x9eae,
    /* 76               77               78               79               */
       0x9eaf,          0x9eb0,          0x9eb3,          0x9eb4,
    /* 80               81               82               83               */
       0x9eb5,          0x9ec6,          0x9ec8,          0x9ecb,
    /* 84               85               86               87               */
       0x9ed5,          0x9edf,          0x9ee4,          0x9ee7,
    /* 88               89               90               91               */
       0x9eec,          0x9eed,          0x9eee,          0x9ef0,
    /* 92               93               94                                */
       0x9ef1,          0x9ef2,          0x9ef5,
/* JIS X 0212 row 77 */
    /*                   1                2                3               */
                        0x9ef8,          0x9eff,          0x9f02,
    /*  4                5                6                7               */
       0x9f03,          0x9f09,          0x9f0f,          0x9f10,
    /*  8                9               10               11               */
       0x9f11,          0x9f12,          0x9f14,          0x9f16,
    /* 12               13               14               15               */
       0x9f17,          0x9f19,          0x9f1a,          0x9f1b,
    /* 16               17               18               19               */
       0x9f1f,          0x9f22,          0x9f26,          0x9f2a,
    /* 20               21               22               23               */
       0x9f2b,          0x9f2f,          0x9f31,          0x9f32,
    /* 24               25               26               27               */
       0x9f34,          0x9f37,          0x9f39,          0x9f3a,
    /* 28               29               30               31               */
       0x9f3c,          0x9f3d,          0x9f3f,          0x9f41,
    /* 32               33               34               35               */
       0x9f43,          0x9f44,          0x9f45,          0x9f46,
    /* 36               37               38               39               */
       0x9f47,          0x9f53,          0x9f55,          0x9f56,
    /* 40               41               42               43               */
       0x9f57,          0x9f58,          0x9f5a,          0x9f5d,
    /* 44               45               46               47               */
       0x9f5e,          0x9f68,          0x9f69,          0x9f6d,
    /* 48               49               50               51               */
       0x9f6e,          0x9f6f,          0x9f70,          0x9f71,
    /* 52               53               54               55               */
       0x9f73,          0x9f75,          0x9f7a,          0x9f7d,
    /* 56               57        