/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 *  under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
*/
/*
 * Copyright(c) 2008 Sun Microsystems, Inc.
 * All rights reserved.
 */
#ifndef _VISCII_TCVN_H_
#define _VISCII_TCVN_H_



static const unsigned char viscii2tcvn_1[32] = {
    /*
    * 0x00 - Ox1f
    */
    0x00,  0x00,  0xba,  0x03,  0x00,  0xbf,  0xc3,  0x07,
    0x08,  0x09,  0x0a,  0x0b,  0x0c,  0x0d,  0x0e,  0x0f,
    0x10,  0x00,  0x00,  0x00,  0x14,  0x00,  0x00,  0x00,
    0x18,  0x15,  0x1a,  0x1b,  0x1c,  0x1d,  0x17,  0x1f,
};

static const unsigned char viscii2tcvn_2[128] = {
    /*
    * 0x80 - Oxff
    */
    0x84,  0xc0,  0xaf,  0x85,  0xc4,  0xc1,  0xc2,  0x86,
    0x89,  0x8b,  0xda,  0xc5,  0xcd,  0xd9,  0x8c,  0xff,
    0xdb,  0xe0,  0xf0,  0x97,  0x9c,  0x9b,  0x98,  0x99,
    0x91,  0x93,  0x96,  0x8e,  0x9e,  0x9f,  0x02,  0x13,
    0x94,  0xbe,  0xbb,  0xc6,  0xca,  0xc7,  0xc8,  0xcb,
    0xcf,  0xd1,  0xd5,  0xd2,  0xd3,  0xd4,  0xd6,  0xe8,
    0xe5,  0xe6,  0xe7,  0x9a,  0xa5,  0xe9,  0xea,  0xeb,
    0xde,  0x12,  0x11,  0x04,  0x05,  0xac,  0xed,  0xa6,
    0x80,  0x83,  0xa2,  0x82,  0x81,  0xa1,  0xbc,  0xbd,
    0x87,  0x8a,  0xa3,  0x88,  0x8d,  0x90,  0x8f,  0xfa,
    0xa7,  0xf8,  0x92,  0x95,  0xa4,  0xb9,  0xfb,  0xf5,
    0xf6,  0x9d,  0x01,  0xfc,  0xfe,  0x16,  0xec,  0xad,
    0xb5,  0xb8,  0xa9,  0xb7,  0xb6,  0xa8,  0xf7,  0xc9,
    0xcc,  0xd0,  0xaa,  0xce,  0xd7,  0xdd,  0xdc,  0xd8,
    0xae,  0xf9,  0xdf,  0xe3,  0xab,  0xe2,  0xe1,  0xe4,
    0xf4,  0xef,  0xf3,  0xf2,  0xf1,  0xfd,  0xee,  0x06,
};

#ifdef  __NEED_VISCII_2_TCVN__
static int viscii_2_tcvn(const unsigned char *in, unsigned char *out )
{
    unsigned char c = *in;
    if (c < 0x20)
        *out = (unsigned long) viscii2tcvn_1[c];
    else if (c < 0x80)
        *out = (unsigned long) c;
    else
        *out = (unsigned long) viscii2tcvn_2[c-0x80];
    return 1;
}
#endif


static const unsigned char tcvn2viscii_1[32] = {
    /*
    * 0x00 - Ox1f
    */
    0x00,  0xda,  0x9e,  0x03,  0xbb,  0xbc,  0xff,  0x07,
    0x08,  0x09,  0x0a,  0x0b,  0x0c,  0x0d,  0x0e,  0x0f,
    0x10,  0xba,  0xb9,  0x9f,  0x14,  0x19,  0xdd,  0x1e,
    0x18,  0x00,  0x1a,  0x1b,  0x1c,  0x1d,  0x00,  0x1f,
};

static const unsigned char tcvn2viscii_2[128] = {
    /*
    * 0x80 - Oxff
    */
    0xc0,  0xc4,  0xc3,  0xc1,  0x80,  0x83,  0x87,  0xc8,
    0xcb,  0x88,  0xc9,  0x89,  0x8e,  0xcc,  0x9b,  0xce,
    0xcd,  0x98,  0xd2,  0x99,  0xa0,  0xd3,  0x9a,  0x93,
    0x96,  0x97,  0xb3,  0x95,  0x94,  0xd9,  0x9c,  0x9d,
    0x00,  0xc5,  0xc2,  0xca,  0xd4,  0xb4,  0xbf,  0xd0,
    0xe5,  0xe2,  0xea,  0xf4,  0xbd,  0xdf,  0xf0,  0x82,
    0x00,  0x00,  0x00,  0x00,  0x00,  0xe0,  0xe4,  0xe3,
    0xe1,  0xd5,  0x02,  0xa2,  0xc6,  0xc7,  0xa1,  0x05,
    0x81,  0x85,  0x86,  0x06,  0x84,  0x8b,  0xa3,  0xa5,
    0xa6,  0xe7,  0xa4,  0xa7,  0xe8,  0x8c,  0xeb,  0xa8,
    0xe9,  0xa9,  0xab,  0xac,  0xad,  0xaa,  0xae,  0xec,
    0xef,  0x8d,  0x8a,  0x90,  0xee,  0xed,  0xb8,  0xf2,
    0x91,  0xf6,  0xf5,  0xf3,  0xf7,  0xb0,  0xb1,  0xb2,
    0xaf,  0xb5,  0xb6,  0xb7,  0xde,  0xbe,  0xfe,  0xf9,
    0x92,  0xfc,  0xfb,  0xfa,  0xf8,  0xd7,  0xd8,  0xe6,
    0xd1,  0xf1,  0xcf,  0xd6,  0xdb,  0xfd,  0xdc,  0x8f,

};

#ifdef __NEED_TCVN_2_VISCII__
static int tcvn_2_viscii (unsigned char in,  unsigned char *out)
{
    if (in < 0x20)
        *out = (unsigned long) tcvn2viscii_1[in];
    else if (in < 0x80)
        *out = (unsigned long) in;
    else
        *out = (unsigned long) tcvn2viscii_2[in-0x80];

    return 1;
}
#endif

#endif
