/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 *  ICU License - ICU 1.8.1 and later
 *
 *  COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1995-2005 International Business Machines Corporation and others
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 * --------------------------------------------------------------------------
 * All trademarks and registered trademarks mentioned herein are the property
 * of their respective owners.
 */
/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 * All rights reserved.
 */


#ifndef	_UCS2_CP935_H_
#define	_UCS2_CP935_H_

/* maxium mapping number from UCS to IBM Cp935 */
#define MAX_UCS_NUM             9523

lookup_table ucs2_cp935_tab[MAX_UCS_NUM] = {
        { 0x0000, 0x0000 },
        { 0x0001, 0x0001 },
        { 0x0002, 0x0002 },
        { 0x0003, 0x0003 },
        { 0x0004, 0x0037 },
        { 0x0005, 0x002D },
        { 0x0006, 0x002E },
        { 0x0007, 0x002F },
        { 0x0008, 0x0016 },
        { 0x0009, 0x0005 },
        { 0x000A, 0x0025 },
        { 0x000B, 0x000B },
        { 0x000C, 0x000C },
        { 0x000D, 0x000D },
        { 0x000E, 0x000E },
        { 0x000F, 0x000F },
        { 0x0010, 0x0010 },
        { 0x0011, 0x0011 },
        { 0x0012, 0x0012 },
        { 0x0013, 0x0013 },
        { 0x0014, 0x003C },
        { 0x0015, 0x003D },
        { 0x0016, 0x0032 },
        { 0x0017, 0x0026 },
        { 0x0018, 0x0018 },
        { 0x0019, 0x0019 },
        { 0x001A, 0x003F },
        { 0x001B, 0x0027 },
        { 0x001C, 0x001C },
        { 0x001D, 0x001D },
        { 0x001E, 0x001E },
        { 0x001F, 0x001F },
        { 0x0020, 0x0040 },
        { 0x0021, 0x005A },
        { 0x0022, 0x007F },
        { 0x0023, 0x007B },
        { 0x0024, 0x00E0 },
        { 0x0025, 0x006C },
        { 0x0026, 0x0050 },
        { 0x0027, 0x007D },
        { 0x0028, 0x004D },
        { 0x0029, 0x005D },
        { 0x002A, 0x005C },
        { 0x002B, 0x004E },
        { 0x002C, 0x006B },
        { 0x002D, 0x0060 },
        { 0x002E, 0x004B },
        { 0x002F, 0x0061 },
        { 0x0030, 0x00F0 },
        { 0x0031, 0x00F1 },
        { 0x0032, 0x00F2 },
        { 0x0033, 0x00F3 },
        { 0x0034, 0x00F4 },
        { 0x0035, 0x00F5 },
        { 0x0036, 0x00F6 },
        { 0x0037, 0x00F7 },
        { 0x0038, 0x00F8 },
        { 0x0039, 0x00F9 },
        { 0x003A, 0x007A },
        { 0x003B, 0x005E },
        { 0x003C, 0x004C },
        { 0x003D, 0x007E },
        { 0x003E, 0x006E },
        { 0x003F, 0x006F },
        { 0x0040, 0x007C },
        { 0x0041, 0x00C1 },
        { 0x0042, 0x00C2 },
        { 0x0043, 0x00C3 },
        { 0x0044, 0x00C4 },
        { 0x0045, 0x00C5 },
        { 0x0046, 0x00C6 },
        { 0x0047, 0x00C7 },
        { 0x0048, 0x00C8 },
        { 0x0049, 0x00C9 },
        { 0x004A, 0x00D1 },
        { 0x004B, 0x00D2 },
        { 0x004C, 0x00D3 },
        { 0x004D, 0x00D4 },
        { 0x004E, 0x00D5 },
        { 0x004F, 0x00D6 },
        { 0x0050, 0x00D7 },
        { 0x0051, 0x00D8 },
        { 0x0052, 0x00D9 },
        { 0x0053, 0x00E2 },
        { 0x0054, 0x00E3 },
        { 0x0055, 0x00E4 },
        { 0x0056, 0x00E5 },
        { 0x0057, 0x00E6 },
        { 0x0058, 0x00E7 },
        { 0x0059, 0x00E8 },
        { 0x005A, 0x00E9 },
        { 0x005B, 0x00BA },
        { 0x005C, 0x00B2 },
        { 0x005D, 0x00BB },
        { 0x005E, 0x00B0 },
        { 0x005F, 0x006D },
        { 0x0060, 0x0079 },
        { 0x0061, 0x0081 },
        { 0x0062, 0x0082 },
        { 0x0063, 0x0083 },
        { 0x0064, 0x0084 },
        { 0x0065, 0x0085 },
        { 0x0066, 0x0086 },
        { 0x0067, 0x0087 },
        { 0x0068, 0x0088 },
        { 0x0069, 0x0089 },
        { 0x006A, 0x0091 },
        { 0x006B, 0x0092 },
        { 0x006C, 0x0093 },
        { 0x006D, 0x0094 },
        { 0x006E, 0x0095 },
        { 0x006F, 0x0096 },
        { 0x0070, 0x0097 },
        { 0x0071, 0x0098 },
        { 0x0072, 0x0099 },
        { 0x0073, 0x00A2 },
        { 0x0074, 0x00A3 },
        { 0x0075, 0x00A4 },
        { 0x0076, 0x00A5 },
        { 0x0077, 0x00A6 },
        { 0x0078, 0x00A7 },
        { 0x0079, 0x00A8 },
        { 0x007A, 0x00A9 },
        { 0x007B, 0x00C0 },
        { 0x007C, 0x004F },
        { 0x007D, 0x00D0 },
        { 0x007E, 0x00A0 },
        { 0x007F, 0x0007 },
        { 0x0080, 0x0020 },
        { 0x0081, 0x0021 },
        { 0x0082, 0x0022 },
        { 0x0083, 0x0023 },
        { 0x0084, 0x0024 },
        { 0x0085, 0x0015 },
        { 0x0086, 0x0006 },
        { 0x0087, 0x0017 },
        { 0x0088, 0x0028 },
        { 0x0089, 0x0029 },
        { 0x008A, 0x002A },
        { 0x008B, 0x002B },
        { 0x008C, 0x002C },
        { 0x008D, 0x0009 },
        { 0x008E, 0x000A },
        { 0x008F, 0x001B },
        { 0x0090, 0x0030 },
        { 0x0091, 0x0031 },
        { 0x0092, 0x001A },
        { 0x0093, 0x0033 },
        { 0x0094, 0x0034 },
        { 0x0095, 0x0035 },
        { 0x0096, 0x0036 },
        { 0x0097, 0x0008 },
        { 0x0098, 0x0038 },
        { 0x0099, 0x0039 },
        { 0x009A, 0x003A },
        { 0x009B, 0x003B },
        { 0x009C, 0x0004 },
        { 0x009D, 0x0014 },
        { 0x009E, 0x003E },
        { 0x009F, 0x00FF },
        { 0x00A3, 0x004A },
        { 0x00A4, 0x4588 },
        { 0x00A5, 0x005B },
        { 0x00A6, 0x006A },
        { 0x00A7, 0x446A },
        { 0x00A8, 0x4460 },
        { 0x00AC, 0x005F },
        { 0x00B0, 0x44ED },
        { 0x00B1, 0x444B },
        { 0x00B4, 0x4450 },
	{ 0x00B7, 0x4345 },
        { 0x00D7, 0x447A },
        { 0x00E0, 0x4644 },
        { 0x00E1, 0x4642 },
        { 0x00E8, 0x4648 },
        { 0x00E9, 0x4646 },
        { 0x00EA, 0x465A },
        { 0x00EC, 0x464C },
        { 0x00ED, 0x464A },
        { 0x00F2, 0x4650 },
        { 0x00F3, 0x464E },
        { 0x00F7, 0x447B },
        { 0x00F9, 0x4654 },
        { 0x00FA, 0x4652 },
        { 0x00FC, 0x4659 },
        { 0x0101, 0x4641 },
        { 0x0113, 0x4645 },
        { 0x011B, 0x4647 },
        { 0x012B, 0x4649 },
        { 0x014D, 0x464D },
        { 0x016B, 0x4651 },
        { 0x01CE, 0x4643 },
        { 0x01D0, 0x464B },
        { 0x01D2, 0x464F },
        { 0x01D4, 0x4653 },
        { 0x01D6, 0x4655 },
        { 0x01D8, 0x4656 },
        { 0x01DA, 0x4657 },
        { 0x01DC, 0x4658 },
        { 0x02C7, 0x4546 },
        { 0x02C9, 0x4545 },
        { 0x0391, 0x4161 },
        { 0x0392, 0x4162 },
        { 0x0393, 0x4163 },
        { 0x0394, 0x4164 },
        { 0x0395, 0x4165 },
        { 0x0396, 0x4166 },
        { 0x0397, 0x4167 },
        { 0x0398, 0x4168 },
        { 0x0399, 0x4169 },
        { 0x039A, 0x416A },
        { 0x039B, 0x416B },
        { 0x039C, 0x416C },
        { 0x039D, 0x416D },
        { 0x039E, 0x416E },
        { 0x039F, 0x416F },
        { 0x03A0, 0x4170 },
        { 0x03A1, 0x4171 },
        { 0x03A3, 0x4172 },
        { 0x03A4, 0x4173 },
        { 0x03A5, 0x4174 },
        { 0x03A6, 0x4175 },
        { 0x03A7, 0x4176 },
        { 0x03A8, 0x4177 },
        { 0x03A9, 0x4178 },
        { 0x03B1, 0x4141 },
        { 0x03B2, 0x4142 },
        { 0x03B3, 0x4143 },
        { 0x03B4, 0x4144 },
        { 0x03B5, 0x4145 },
        { 0x03B6, 0x4146 },
        { 0x03B7, 0x4147 },
        { 0x03B8, 0x4148 },
        { 0x03B9, 0x4149 },
        { 0x03BA, 0x414A },
        { 0x03BB, 0x414B },
        { 0x03BC, 0x414C },
        { 0x03BD, 0x414D },
        { 0x03BE, 0x414E },
        { 0x03BF, 0x414F },
        { 0x03C0, 0x4150 },
        { 0x03C1, 0x4151 },
        { 0x03C3, 0x4152 },
        { 0x03C4, 0x4153 },
        { 0x03C5, 0x4154 },
        { 0x03C6, 0x4155 },
        { 0x03C7, 0x4156 },
        { 0x03C8, 0x4157 },
        { 0x03C9, 0x4158 },
        { 0x0401, 0x41C6 },
        { 0x0410, 0x41C0 },
        { 0x0411, 0x41C1 },
        { 0x0412, 0x41C2 },
        { 0x0413, 0x41C3 },
        { 0x0414, 0x41C4 },
        { 0x0415, 0x41C5 },
        { 0x0416, 0x41C7 },
        { 0x0417, 0x41C8 },
        { 0x0418, 0x41C9 },
        { 0x0419, 0x41CA },
        { 0x041A, 0x41CB },
        { 0x041B, 0x41CC },
        { 0x041C, 0x41CD },
        { 0x041D, 0x41CE },
        { 0x041E, 0x41CF },
        { 0x041F, 0x41D0 },
        { 0x0420, 0x41D1 },
        { 0x0421, 0x41D2 },
        { 0x0422, 0x41D3 },
        { 0x0423, 0x41D4 },
        { 0x0424, 0x41D5 },
        { 0x0425, 0x41D6 },
        { 0x0426, 0x41D7 },
        { 0x0427, 0x41D8 },
        { 0x0428, 0x41D9 },
        { 0x0429, 0x41DA },
        { 0x042A, 0x41DB },
        { 0x042B, 0x41DC },
        { 0x042C, 0x41DD },
        { 0x042D, 0x41DE },
        { 0x042E, 0x41DF },
        { 0x042F, 0x41E0 },
        { 0x0430, 0x4180 },
        { 0x0431, 0x4181 },
        { 0x0432, 0x4182 },
        { 0x0433, 0x4183 },
        { 0x0434, 0x4184 },
        { 0x0435, 0x4185 },
        { 0x0436, 0x4187 },
        { 0x0437, 0x4188 },
        { 0x0438, 0x4189 },
        { 0x0439, 0x418A },
        { 0x043A, 0x418B },
        { 0x043B, 0x418C },
        { 0x043C, 0x418D },
        { 0x043D, 0x418E },
        { 0x043E, 0x418F },
        { 0x043F, 0x4190 },
        { 0x0440, 0x4191 },
        { 0x0441, 0x4192 },
        { 0x0442, 0x4193 },
        { 0x0443, 0x4194 },
        { 0x0444, 0x4195 },
        { 0x0445, 0x4196 },
        { 0x0446, 0x4197 },
        { 0x0447, 0x4198 },
        { 0x0448, 0x4199 },
        { 0x0449, 0x419A },
        { 0x044A, 0x419B },
        { 0x044B, 0x419C },
        { 0x044C, 0x419D },
        { 0x044D, 0x419E },
        { 0x044E, 0x419F },
        { 0x044F, 0x41A0 },
        { 0x0451, 0x4186 },
        { 0x2010, 0x445A },
	{ 0x2014, 0x444A },
        { 0x2015, 0x444A },
        { 0x2016, 0x447C },
        { 0x2018, 0x4461 },
        { 0x2019, 0x4471 },
        { 0x201C, 0x4462 },
        { 0x201D, 0x4472 },
        { 0x2025, 0x447E },
        { 0x2026, 0x447F },
        { 0x2030, 0x458B },
        { 0x2032, 0x44EE },
        { 0x2033, 0x44EF },
        { 0x203B, 0x446B },
        { 0x203E, 0x00A1 },
        { 0x2103, 0x444E },
        { 0x2116, 0x446E },
        { 0x2121, 0x446F },
        { 0x2160, 0x41F1 },
        { 0x2161, 0x41F2 },
        { 0x2162, 0x41F3 },
        { 0x2163, 0x41F4 },
        { 0x2164, 0x41F5 },
        { 0x2165, 0x41F6 },
        { 0x2166, 0x41F7 },
        { 0x2167, 0x41F8 },
        { 0x2168, 0x41F9 },
        { 0x2169, 0x41FA },
        { 0x216A, 0x41FB },
        { 0x216B, 0x41FC },
        { 0x2170, 0x41B1 },
        { 0x2171, 0x41B2 },
        { 0x2172, 0x41B3 },
        { 0x2173, 0x41B4 },
        { 0x2174, 0x41B5 },
        { 0x2175, 0x41B6 },
        { 0x2176, 0x41B7 },
        { 0x2177, 0x41B8 },
        { 0x2178, 0x41B9 },
        { 0x2179, 0x41BA },
        { 0x2190, 0x44F1 },
        { 0x2191, 0x44F2 },
        { 0x2192, 0x44F0 },
        { 0x2193, 0x44F3 },
        { 0x2208, 0x4569 },
        { 0x220F, 0x4566 },
        { 0x2211, 0x4565 },
        { 0x221A, 0x456B },
        { 0x221D, 0x4577 },
        { 0x221E, 0x444D },
        { 0x2220, 0x456E },
        { 0x2225, 0x456D },
        { 0x2227, 0x4563 },
        { 0x2228, 0x4564 },
        { 0x2229, 0x4568 },
        { 0x222A, 0x4567 },
        { 0x222B, 0x4571 },
        { 0x222E, 0x4572 },
        { 0x2234, 0x4468 },
        { 0x2235, 0x4478 },
        { 0x2236, 0x4562 },
        { 0x2237, 0x456A },
        { 0x223D, 0x4576 },
        { 0x2248, 0x4575 },
        { 0x224C, 0x4574 },
        { 0x2260, 0x444C },
        { 0x2261, 0x4573 },
        { 0x2264, 0x4467 },
        { 0x2265, 0x4477 },
        { 0x226E, 0x4579 },
        { 0x226F, 0x457A },
        { 0x2299, 0x4570 },
        { 0x22A5, 0x456C },
        { 0x2312, 0x456F },
        { 0x2460, 0x45E1 },
        { 0x2461, 0x45E2 },
        { 0x2462, 0x45E3 },
        { 0x2463, 0x45E4 },
        { 0x2464, 0x45E5 },
        { 0x2465, 0x45E6 },
        { 0x2466, 0x45E7 },
        { 0x2467, 0x45E8 },
        { 0x2468, 0x45E9 },
        { 0x2469, 0x45EA },
        { 0x2474, 0x45C5 },
        { 0x2475, 0x45C6 },
        { 0x2476, 0x45C7 },
        { 0x2477, 0x45C8 },
        { 0x2478, 0x45C9 },
        { 0x2479, 0x45CA },
        { 0x247A, 0x45CB },
        { 0x247B, 0x45CC },
        { 0x247C, 0x45CD },
        { 0x247D, 0x45CE },
        { 0x247E, 0x45CF },
        { 0x247F, 0x45D0 },
        { 0x2480, 0x45D1 },
        { 0x2481, 0x45D2 },
        { 0x2482, 0x45D3 },
        { 0x2483, 0x45D4 },
        { 0x2484, 0x45D5 },
        { 0x2485, 0x45D6 },
        { 0x2486, 0x45D7 },
        { 0x2487, 0x45D8 },
        { 0x2488, 0x45B1 },
        { 0x2489, 0x45B2 },
        { 0x248A, 0x45B3 },
        { 0x248B, 0x45B4 },
        { 0x248C, 0x45B5 },
        { 0x248D, 0x45B6 },
        { 0x248E, 0x45B7 },
        { 0x248F, 0x45B8 },
        { 0x2490, 0x45B9 },
        { 0x2491, 0x45BA },
        { 0x2492, 0x45BB },
        { 0x2493, 0x45BC },
        { 0x2494, 0x45BD },
        { 0x2495, 0x45BE },
        { 0x2496, 0x45BF },
        { 0x2497, 0x45C0 },
        { 0x2498, 0x45C1 },
        { 0x2499, 0x45C2 },
        { 0x249A, 0x45C3 },
        { 0x249B, 0x45C4 },
        { 0x2500, 0x46A4 },
        { 0x2501, 0x46A5 },
        { 0x2502, 0x46A6 },
        { 0x2503, 0x46A7 },
        { 0x2504, 0x46A8 },
        { 0x2505, 0x46A9 },
        { 0x2506, 0x46AA },
        { 0x2507, 0x46AB },
        { 0x2508, 0x46AC },
        { 0x2509, 0x46AD },
        { 0x250A, 0x46AE },
        { 0x250B, 0x46AF },
        { 0x250C, 0x46B0 },
        { 0x250D, 0x46B1 },
        { 0x250E, 0x46B2 },
        { 0x250F, 0x46B3 },
        { 0x2510, 0x46B4 },
        { 0x2511, 0x46B5 },
        { 0x2512, 0x46B6 },
        { 0x2513, 0x46B7 },
        { 0x2514, 0x46B8 },
        { 0x2515, 0x46B9 },
        { 0x2516, 0x46BA },
        { 0x2517, 0x46BB },
        { 0x2518, 0x46BC },
        { 0x2519, 0x46BD },
        { 0x251A, 0x46BE },
        { 0x251B, 0x46BF },
        { 0x251C, 0x46C0 },
        { 0x251D, 0x46C1 },
        { 0x251E, 0x46C2 },
        { 0x251F, 0x46C3 },
        { 0x2520, 0x46C4 },
        { 0x2521, 0x46C5 },
        { 0x2522, 0x46C6 },
        { 0x2523, 0x46C7 },
        { 0x2524, 0x46C8 },
        { 0x2525, 0x46C9 },
        { 0x2526, 0x46CA },
        { 0x2527, 0x46CB },
        { 0x2528, 0x46CC },
        { 0x2529, 0x46CD },
        { 0x252A, 0x46CE },
        { 0x252B, 0x46CF },
        { 0x252C, 0x46D0 },
        { 0x252D, 0x46D1 },
        { 0x252E, 0x46D2 },
        { 0x252F, 0x46D3 },
        { 0x2530, 0x46D4 },
        { 0x2531, 0x46D5 },
        { 0x2532, 0x46D6 },
        { 0x2533, 0x46D7 },
        { 0x2534, 0x46D8 },
        { 0x2535, 0x46D9 },
        { 0x2536, 0x46DA },
        { 0x2537, 0x46DB },
        { 0x2538, 0x46DC },
        { 0x2539, 0x46DD },
        { 0x253A, 0x46DE },
        { 0x253B, 0x46DF },
        { 0x253C, 0x46E0 },
        { 0x253D, 0x46E1 },
        { 0x253E, 0x46E2 },
        { 0x253F, 0x46E3 },
        { 0x2540, 0x46E4 },
        { 0x2541, 0x46E5 },
        { 0x2542, 0x46E6 },
        { 0x2543, 0x46E7 },
        { 0x2544, 0x46E8 },
        { 0x2545, 0x46E9 },
        { 0x2546, 0x46EA },
        { 0x2547, 0x46EB },
        { 0x2548, 0x46EC },
        { 0x2549, 0x46ED },
        { 0x254A, 0x46EE },
        { 0x254B, 0x46EF },
        { 0x25A0, 0x44EA },
        { 0x25A1, 0x44E9 },
        { 0x25B2, 0x44E3 },
        { 0x25B3, 0x44E2 },
        { 0x25BC, 0x44EC },
        { 0x25BD, 0x44EB },
        { 0x25C6, 0x44E8 },
        { 0x25C7, 0x44E7 },
        { 0x25CB, 0x44E0 },
        { 0x25CE, 0x44E4 },
        { 0x25CF, 0x44E1 },
        { 0x2605, 0x44E6 },
        { 0x2606, 0x44E5 },
        { 0x2640, 0x4479 },
        { 0x2642, 0x4469 },
        { 0x3000, 0x4040 },
        { 0x3001, 0x4344 },
        { 0x3002, 0x4341 },
        { 0x3003, 0x445B },
        { 0x3005, 0x445D },
        { 0x3006, 0x445E },
        { 0x3007, 0x445F },
        { 0x3008, 0x4464 },
        { 0x3009, 0x4474 },
        { 0x300A, 0x4465 },
        { 0x300B, 0x4475 },
        { 0x300C, 0x4342 },
        { 0x300D, 0x4343 },
        { 0x300E, 0x4442 },
        { 0x300F, 0x4443 },
        { 0x3010, 0x4466 },
        { 0x3011, 0x4476 },
        { 0x3012, 0x446C },
        { 0x3013, 0x447D },
        { 0x3014, 0x4463 },
        { 0x3015, 0x4473 },
        { 0x3016, 0x455B },
        { 0x3017, 0x455C },
        { 0x3041, 0x4447 },
        { 0x3042, 0x4481 },
        { 0x3043, 0x4448 },
        { 0x3044, 0x4482 },
        { 0x3045, 0x4449 },
        { 0x3046, 0x4483 },
        { 0x3047, 0x4451 },
        { 0x3048, 0x4484 },
        { 0x3049, 0x4452 },
        { 0x304A, 0x4485 },
        { 0x304B, 0x4486 },
        { 0x304C, 0x44C0 },
        { 0x304D, 0x4487 },
        { 0x304E, 0x44C1 },
        { 0x304F, 0x4488 },
        { 0x3050, 0x44C2 },
        { 0x3051, 0x4489 },
        { 0x3052, 0x44C3 },
        { 0x3053, 0x448A },
        { 0x3054, 0x44C4 },
        { 0x3055, 0x448C },
        { 0x3056, 0x44C5 },
        { 0x3057, 0x448D },
        { 0x3058, 0x44C6 },
        { 0x3059, 0x448E },
        { 0x305A, 0x44C7 },
        { 0x305B, 0x448F },
        { 0x305C, 0x44C8 },
        { 0x305D, 0x4490 },
        { 0x305E, 0x44C9 },
        { 0x305F, 0x4491 },
        { 0x3060, 0x44CA },
        { 0x3061, 0x4492 },
        { 0x3062, 0x44CB },
        { 0x3063, 0x4456 },
        { 0x3064, 0x4493 },
        { 0x3065, 0x44CC },
        { 0x3066, 0x4494 },
        { 0x3067, 0x44CD },
        { 0x3068, 0x4495 },
        { 0x3069, 0x44CE },
        { 0x306A, 0x4496 },
        { 0x306B, 0x4497 },
        { 0x306C, 0x4498 },
        { 0x306D, 0x4499 },
        { 0x306E, 0x449A },
        { 0x306F, 0x449D },
        { 0x3070, 0x44CF },
        { 0x3071, 0x44D5 },
        { 0x3072, 0x449E },
        { 0x3073, 0x44D0 },
        { 0x3074, 0x44D6 },
        { 0x3075, 0x449F },
        { 0x3076, 0x44D1 },
        { 0x3077, 0x44D7 },
        { 0x3078, 0x44A2 },
        { 0x3079, 0x44D2 },
        { 0x307A, 0x44D8 },
        { 0x307B, 0x44A3 },
        { 0x307C, 0x44D3 },
        { 0x307D, 0x44D9 },
        { 0x307E, 0x44A4 },
        { 0x307F, 0x44A5 },
        { 0x3080, 0x44A6 },
        { 0x3081, 0x44A7 },
        { 0x3082, 0x44A8 },
        { 0x3083, 0x4453 },
        { 0x3084, 0x44A9 },
        { 0x3085, 0x4454 },
        { 0x3086, 0x44AA },
        { 0x3087, 0x4455 },
        { 0x3088, 0x44AC },
        { 0x3089, 0x44AD },
        { 0x308A, 0x44AE },
        { 0x308B, 0x44AF },
        { 0x308C, 0x44BA },
        { 0x308D, 0x44BB },
        { 0x308E, 0x4457 },
        { 0x308F, 0x44BC },
        { 0x3090, 0x44DA },
        { 0x3091, 0x44DB },
        { 0x3092, 0x4446 },
        { 0x3093, 0x44BD },
        { 0x309B, 0x43BE },
        { 0x309C, 0x43BF },
        { 0x309D, 0x44DC },
        { 0x309E, 0x44DD },
        { 0x30A1, 0x4347 },
        { 0x30A2, 0x4381 },
        { 0x30A3, 0x4348 },
        { 0x30A4, 0x4382 },
        { 0x30A5, 0x4349 },
        { 0x30A6, 0x4383 },
        { 0x30A7, 0x4351 },
        { 0x30A8, 0x4384 },
        { 0x30A9, 0x4352 },
        { 0x30AA, 0x4385 },
        { 0x30AB, 0x4386 },
        { 0x30AC, 0x43C0 },
        { 0x30AD, 0x4387 },
        { 0x30AE, 0x43C1 },
        { 0x30AF, 0x4388 },
        { 0x30B0, 0x43C2 },
        { 0x30B1, 0x4389 },
        { 0x30B2, 0x43C3 },
        { 0x30B3, 0x438A },
        { 0x30B4, 0x43C4 },
        { 0x30B5, 0x438C },
        { 0x30B6, 0x43C5 },
        { 0x30B7, 0x438D },
        { 0x30B8, 0x43C6 },
        { 0x30B9, 0x438E },
        { 0x30BA, 0x43C7 },
        { 0x30BB, 0x438F },
        { 0x30BC, 0x43C8 },
        { 0x30BD, 0x4390 },
        { 0x30BE, 0x43C9 },
        { 0x30BF, 0x4391 },
        { 0x30C0, 0x43CA },
        { 0x30C1, 0x4392 },
        { 0x30C2, 0x43CB },
        { 0x30C3, 0x4356 },
        { 0x30C4, 0x4393 },
        { 0x30C5, 0x43CC },
        { 0x30C6, 0x4394 },
        { 0x30C7, 0x43CD },
        { 0x30C8, 0x4395 },
        { 0x30C9, 0x43CE },
        { 0x30CA, 0x4396 },
        { 0x30CB, 0x4397 },
        { 0x30CC, 0x4398 },
        { 0x30CD, 0x4399 },
        { 0x30CE, 0x439A },
        { 0x30CF, 0x439D },
        { 0x30D0, 0x43CF },
        { 0x30D1, 0x43D5 },
        { 0x30D2, 0x439E },
        { 0x30D3, 0x43D0 },
        { 0x30D4, 0x43D6 },
        { 0x30D5, 0x439F },
        { 0x30D6, 0x43D1 },
        { 0x30D7, 0x43D7 },
        { 0x30D8, 0x43A2 },
        { 0x30D9, 0x43D2 },
        { 0x30DA, 0x43D8 },
        { 0x30DB, 0x43A3 },
        { 0x30DC, 0x43D3 },
        { 0x30DD, 0x43D9 },
        { 0x30DE, 0x43A4 },
        { 0x30DF, 0x43A5 },
        { 0x30E0, 0x43A6 },
        { 0x30E1, 0x43A7 },
        { 0x30E2, 0x43A8 },
        { 0x30E3, 0x4353 },
        { 0x30E4, 0x43A9 },
        { 0x30E5, 0x4354 },
        { 0x30E6, 0x43AA },
        { 0x30E7, 0x4355 },
        { 0x30E8, 0x43AC },
        { 0x30E9, 0x43AD },
        { 0x30EA, 0x43AE },
        { 0x30EB, 0x43AF },
        { 0x30EC, 0x43BA },
        { 0x30ED, 0x43BB },
        { 0x30EE, 0x4357 },
        { 0x30EF, 0x43BC },
        { 0x30F0, 0x43DA },
        { 0x30F1, 0x43DB },
        { 0x30F2, 0x4346 },
        { 0x30F3, 0x43BD },
        { 0x30F4, 0x43D4 },
        { 0x30F5, 0x4359 },
        { 0x30F6, 0x435A },
        { 0x30FB, 0x4345 },
        { 0x30FC, 0x4358 },
        { 0x30FD, 0x43DC },
        { 0x30FE, 0x43DD },
        { 0x3105, 0x4665 },
        { 0x3106, 0x4666 },
        { 0x3107, 0x4667 },
        { 0x3108, 0x4668 },
        { 0x3109, 0x4669 },
        { 0x310A, 0x466A },
        { 0x310B, 0x466B },
        { 0x310C, 0x466C },
        { 0x310D, 0x466D },
        { 0x310E, 0x466E },
        { 0x310F, 0x466F },
        { 0x3110, 0x4670 },
        { 0x3111, 0x4671 },
        { 0x3112, 0x4672 },
        { 0x3113, 0x4673 },
        { 0x3114, 0x4674 },
        { 0x3115, 0x4675 },
        { 0x3116, 0x4676 },
        { 0x3117, 0x4677 },
        { 0x3118, 0x4678 },
        { 0x3119, 0x4679 },
        { 0x311A, 0x467A },
        { 0x311B, 0x467B },
        { 0x311C, 0x467C },
        { 0x311D, 0x467D },
        { 0x311E, 0x467E },
        { 0x311F, 0x467F },
        { 0x3120, 0x4680 },
        { 0x3121, 0x4681 },
        { 0x3122, 0x4682 },
        { 0x3123, 0x4683 },
        { 0x3124, 0x4684 },
        { 0x3125, 0x4685 },
        { 0x3126, 0x4686 },
        { 0x3127, 0x4687 },
        { 0x3128, 0x4688 },
        { 0x3129, 0x4689 },
        { 0x3220, 0x45F1 },
        { 0x3221, 0x45F2 },
        { 0x3222, 0x45F3 },
        { 0x3223, 0x45F4 },
        { 0x3224, 0x45F5 },
        { 0x3225, 0x45F6 },
        { 0x3226, 0x45F7 },
        { 0x3227, 0x45F8 },
        { 0x3228, 0x45F9 },
        { 0x3229, 0x45FA },
        { 0x3231, 0x446D },
        { 0x4E00, 0x59BA },
        { 0x4E01, 0x4BA0 },
        { 0x4E03, 0x53DE },
        { 0x4E07, 0x5793 },
        { 0x4E08, 0x5B69 },
        { 0x4E09, 0x54FC },
        { 0x4E0A, 0x556F },
        { 0x4E0B, 0x5862 },
        { 0x4E0C, 0x5CA1 },
        { 0x4E0D, 0x49BA },
        { 0x4E0E, 0x5A8C },
        { 0x4E10, 0x5CA3 },
        { 0x4E11, 0x4A94 },
        { 0x4E13, 0x5C48 },
        { 0x4E14, 0x5472 },
        { 0x4E15, 0x5CA6 },
        { 0x4E16, 0x55BF },
        { 0x4E18, 0x5491 },
        { 0x4E19, 0x499C },
        { 0x4E1A, 0x59B4 },
        { 0x4E1B, 0x4AD3 },
        { 0x4E1C, 0x4BAA },
        { 0x4E1D, 0x565F },
        { 0x4E1E, 0x5CA8 },
        { 0x4E22, 0x4BA9 },
        { 0x4E24, 0x515D },
        { 0x4E25, 0x596F },
        { 0x4E27, 0x5545 },
        { 0x4E28, 0x5CAC },
        { 0x4E2A, 0x4CF5 },
        { 0x4E2B, 0x595E },
        { 0x4E2C, 0x627C },
        { 0x4E2D, 0x5BCF },
        { 0x4E30, 0x4C82 },
        { 0x4E32, 0x4AAD },
        { 0x4E34, 0x5179 },
        { 0x4E36, 0x5CBB },
        { 0x4E38, 0x5789 },
        { 0x4E39, 0x4B44 },
        { 0x4E3A, 0x57A9 },
        { 0x4E3B, 0x5BF6 },
        { 0x4E3D, 0x50F5 },
        { 0x4E3E, 0x4FD8 },
        { 0x4E3F, 0x5CAE },
        { 0x4E43, 0x52CA },
        { 0x4E45, 0x4FC2 },
        { 0x4E47, 0x5CB0 },
        { 0x4E48, 0x5254 },
        { 0x4E49, 0x59E4 },
        { 0x4E4B, 0x5BAD },
        { 0x4E4C, 0x57D9 },
        { 0x4E4D, 0x5B47 },
        { 0x4E4E, 0x4DF4 },
        { 0x4E4F, 0x4C46 },
        { 0x4E50, 0x50D5 },
        { 0x4E52, 0x53B8 },
        { 0x4E53, 0x5372 },
        { 0x4E54, 0x5467 },
        { 0x4E56, 0x4D74 },
        { 0x4E58, 0x4A6B },
        { 0x4E59, 0x59D1 },
        { 0x4E5C, 0x5CBE },
        { 0x4E5D, 0x4FC4 },
        { 0x4E5E, 0x53F1 },
        { 0x4E5F, 0x59B1 },
        { 0x4E60, 0x5850 },
        { 0x4E61, 0x5888 },
        { 0x4E66, 0x55E8 },
        { 0x4E69, 0x5CBF },
        { 0x4E70, 0x51F1 },
        { 0x4E71, 0x51D1 },
        { 0x4E73, 0x54E8 },
        { 0x4E7E, 0x544C },
        { 0x4E86, 0x516B },
        { 0x4E88, 0x5A89 },
        { 0x4E89, 0x5B9A },
        { 0x4E8B, 0x55C1 },
        { 0x4E8C, 0x4BFD },
        { 0x4E8D, 0x5CA0 },
        { 0x4E8E, 0x5A7A },
        { 0x4E8F, 0x5098 },
        { 0x4E91, 0x5AC5 },
        { 0x4E92, 0x4E45 },
        { 0x4E93, 0x5CC0 },
        { 0x4E94, 0x57E4 },
        { 0x4E95, 0x4FAD },
        { 0x4E98, 0x5CA7 },
        { 0x4E9A, 0x5967 },
        { 0x4E9B, 0x58A8 },
        { 0x4E9F, 0x5CBC },
        { 0x4EA0, 0x5D90 },
        { 0x4EA1, 0x5797 },
        { 0x4EA2, 0x505A },
        { 0x4EA4, 0x4F5B },
        { 0x4EA5, 0x4DA4 },
        { 0x4EA6, 0x59DF },
        { 0x4EA7, 0x49F9 },
        { 0x4EA8, 0x4DDF },
        { 0x4EA9, 0x52B5 },
        { 0x4EAB, 0x588E },
        { 0x4EAC, 0x4FA8 },
        { 0x4EAD, 0x5744 },
        { 0x4EAE, 0x5161 },
        { 0x4EB2, 0x5477 },
        { 0x4EB3, 0x5D92 },
        { 0x4EB5, 0x5D95 },
        { 0x4EBA, 0x54CA },
        { 0x4EBB, 0x5CE8 },
        { 0x4EBF, 0x59D9 },
        { 0x4EC0, 0x55B1 },
        { 0x4EC1, 0x54C9 },
        { 0x4EC2, 0x5CEB },
        { 0x4EC3, 0x5CE9 },
        { 0x4EC4, 0x5CC5 },
        { 0x4EC5, 0x4F97 },
        { 0x4EC6, 0x53CC },
        { 0x4EC7, 0x4A91 },
        { 0x4EC9, 0x5CEA },
        { 0x4ECA, 0x4F92 },
        { 0x4ECB, 0x4F8A },
        { 0x4ECD, 0x54D3 },
        { 0x4ECE, 0x4AD2 },
        { 0x4ED1, 0x51D7 },
        { 0x4ED3, 0x49D5 },
        { 0x4ED4, 0x5C70 },
        { 0x4ED5, 0x55CA },
        { 0x4ED6, 0x569C },
        { 0x4ED7, 0x5B6C },
        { 0x4ED8, 0x4CB5 },
        { 0x4ED9, 0x5869 },
        { 0x4EDD, 0x5D7A },
        { 0x4EDE, 0x5CEF },
        { 0x4EDF, 0x544A },
        { 0x4EE1, 0x5CED },
        { 0x4EE3, 0x4AF9 },
        { 0x4EE4, 0x518F },
        { 0x4EE5, 0x59D3 },
        { 0x4EE8, 0x5CEC },
        { 0x4EEA, 0x59C6 },
        { 0x4EEB, 0x5CEE },
        { 0x4EEC, 0x5267 },
        { 0x4EF0, 0x5997 },
        { 0x4EF2, 0x5BD8 },
        { 0x4EF3, 0x5CF1 },
        { 0x4EF5, 0x5CF4 },
        { 0x4EF6, 0x4EFD },
        { 0x4EF7, 0x4EDA },
        { 0x4EFB, 0x54CD },
        { 0x4EFD, 0x4C7D },
        { 0x4EFF, 0x4C62 },
        { 0x4F01, 0x53F2 },
        { 0x4F09, 0x5CF7 },
        { 0x4F0A, 0x59C0 },
        { 0x4F0D, 0x57E8 },
        { 0x4F0E, 0x4EBE },
        { 0x4F0F, 0x4C9D },
        { 0x4F10, 0x4C45 },
        { 0x4F11, 0x58DC },
        { 0x4F17, 0x5BD9 },
        { 0x4F18, 0x5A65 },
        { 0x4F19, 0x4E90 },
        { 0x4F1A, 0x4E82 },
        { 0x4F1B, 0x5CF0 },
        { 0x4F1E, 0x5541 },
        { 0x4F1F, 0x57AF },
        { 0x4F20, 0x4AAA },
        { 0x4F22, 0x5CF2 },
        { 0x4F24, 0x556B },
        { 0x4F25, 0x5CF5 },
        { 0x4F26, 0x51D6 },
        { 0x4F27, 0x5CF6 },
        { 0x4F2A, 0x57B0 },
        { 0x4F2B, 0x5CF8 },
        { 0x4F2F, 0x49AD },
        { 0x4F30, 0x4D60 },
        { 0x4F32, 0x5D43 },
        { 0x4F34, 0x48E8 },
        { 0x4F36, 0x5187 },
        { 0x4F38, 0x558D },
        { 0x4F3A, 0x5665 },
        { 0x4F3C, 0x5666 },
        { 0x4F3D, 0x5D44 },
        { 0x4F43, 0x4B89 },
        { 0x4F46, 0x4B4B },
        { 0x4F4D, 0x57BA },
        { 0x4F4E, 0x4B6D },
        { 0x4F4F, 0x5C41 },
        { 0x4F50, 0x5C95 },
        { 0x4F51, 0x5A73 },
        { 0x4F53, 0x56E4 },
        { 0x4F55, 0x4DCD },
        { 0x4F57, 0x5D42 },
        { 0x4F58, 0x5D7C },
        { 0x4F59, 0x5A81 },
        { 0x4F5A, 0x5CFC },
        { 0x4F5B, 0x4C91 },
        { 0x4F5C, 0x5C98 },
        { 0x4F5D, 0x5CFD },
        { 0x4F5E, 0x5CF9 },
        { 0x4F5F, 0x5D41 },
        { 0x4F60, 0x52E2 },
        { 0x4F63, 0x5A56 },
        { 0x4F64, 0x5CF3 },
        { 0x4F65, 0x5D7D },
        { 0x4F67, 0x5CFA },
        { 0x4F69, 0x5386 },
        { 0x4F6C, 0x50CF },
        { 0x4F6F, 0x5991 },
        { 0x4F70, 0x48DA },
        { 0x4F73, 0x4ED0 },
        { 0x4F74, 0x5D46 },
        { 0x4F76, 0x5D45 },
        { 0x4F7B, 0x5D4C },
        { 0x4F7C, 0x5D4E },
        { 0x4F7E, 0x5D4B },
        { 0x4F7F, 0x55B8 },
        { 0x4F83, 0x5D49 },
        { 0x4F84, 0x5BB5 },
        { 0x4F88, 0x4A7E },
        { 0x4F89, 0x5D48 },
        { 0x4F8B, 0x50FC },
        { 0x4F8D, 0x55CB },
        { 0x4F8F, 0x5D4A },
        { 0x4F91, 0x5D47 },
        { 0x4F94, 0x5D50 },
        { 0x4F97, 0x4BB0 },
        { 0x4F9B, 0x4D49 },
        { 0x4F9D, 0x59BF },
        { 0x4FA0, 0x5860 },
        { 0x4FA3, 0x51C1 },
        { 0x4FA5, 0x4F64 },
        { 0x4FA6, 0x5B8D },
        { 0x4FA7, 0x49DF },
        { 0x4FA8, 0x5468 },
        { 0x4FA9, 0x508C },
        { 0x4FAA, 0x5D4D },
        { 0x4FAC, 0x5D4F },
        { 0x4FAE, 0x57E9 },
        { 0x4FAF, 0x4DED },
        { 0x4FB5, 0x5476 },
        { 0x4FBF, 0x4984 },
        { 0x4FC3, 0x4AD8 },
        { 0x4FC4, 0x4BEC },
        { 0x4FC5, 0x5D54 },
        { 0x4FCA, 0x5041 },
        { 0x4FCE, 0x5D7E },
        { 0x4FCF, 0x546E },
        { 0x4FD0, 0x50FD },
        { 0x4FD1, 0x5D58 },
        { 0x4FD7, 0x5677 },
        { 0x4FD8, 0x4C9E },
        { 0x4FDA, 0x5D55 },
        { 0x4FDC, 0x5D57 },
        { 0x4FDD, 0x4943 },
        { 0x4FDE, 0x5A82 },
        { 0x4FDF, 0x5D59 },
        { 0x4FE1, 0x58C4 },
        { 0x4FE3, 0x5D56 },
        { 0x4FE6, 0x5D51 },
        { 0x4FE8, 0x5D52 },
        { 0x4FE9, 0x5149 },
        { 0x4FEA, 0x5D53 },
        { 0x4FED, 0x4EF2 },
        { 0x4FEE, 0x58DD },
        { 0x4FEF, 0x4CA8 },
        { 0x4FF1, 0x4FE2 },
        { 0x4FF3, 0x5D5D },
        { 0x4FF8, 0x5D5A },
        { 0x4FFA, 0x48B2 },
        { 0x4FFE, 0x5D62 },
        { 0x500C, 0x5D64 },
        { 0x500D, 0x4956 },
        { 0x500F, 0x5D5F },
        { 0x5012, 0x4B59 },
        { 0x5014, 0x4FF2 },
        { 0x5018, 0x56C7 },
        { 0x5019, 0x4DF1 },
        { 0x501A, 0x59CF },
        { 0x501C, 0x5D63 },
        { 0x501F, 0x4F89 },
        { 0x5021, 0x4A4B },
        { 0x5025, 0x5D65 },
        { 0x5026, 0x4FEA },
        { 0x5028, 0x5D66 },
        { 0x5029, 0x5D5B },
        { 0x502A, 0x52DE },
        { 0x502C, 0x5D5E },
        { 0x502D, 0x5D61 },
        { 0x502E, 0x5D60 },
        { 0x503A, 0x5B4E },
        { 0x503C, 0x5BB4 },
        { 0x503E, 0x5484 },
        { 0x5043, 0x5D68 },
        { 0x5047, 0x4ED8 },
        { 0x5048, 0x5D6A },
        { 0x504C, 0x5D5C },
        { 0x504E, 0x5D6B },
        { 0x504F, 0x53AA },
        { 0x5055, 0x5D69 },
        { 0x505A, 0x5C97 },
        { 0x505C, 0x5743 },
        { 0x5065, 0x4F41 },
        { 0x506C, 0x5D6C },
        { 0x5076, 0x535C },
        { 0x5077, 0x5755 },
        { 0x507B, 0x5D6D },
        { 0x507E, 0x5D67 },
        { 0x507F, 0x4A45 },
        { 0x5080, 0x509F },
        { 0x5085, 0x4CB4 },
        { 0x5088, 0x50FB },
        { 0x508D, 0x48F7 },
        { 0x50A3, 0x4AF5 },
        { 0x50A5, 0x5D6E },
        { 0x50A7, 0x5D6F },
        { 0x50A8, 0x4AA1 },
        { 0x50A9, 0x5D70 },
        { 0x50AC, 0x4ADE },
        { 0x50B2, 0x48C0 },
        { 0x50BA, 0x5D71 },
        { 0x50BB, 0x5555 },
        { 0x50CF, 0x5892 },
        { 0x50D6, 0x5D72 },
        { 0x50DA, 0x5165 },
        { 0x50E6, 0x5D76 },
        { 0x50E7, 0x554E },
        { 0x50EC, 0x5D75 },
        { 0x50ED, 0x5D74 },
        { 0x50EE, 0x5D77 },
        { 0x50F3, 0x567B },
        { 0x50F5, 0x4F49 },
        { 0x50FB, 0x53A6 },
        { 0x5106, 0x5D73 },
        { 0x5107, 0x5D78 },
        { 0x510B, 0x5D79 },
        { 0x5112, 0x54E4 },
        { 0x5121, 0x50DB },
        { 0x513F, 0x4BF8 },
        { 0x5140, 0x5CA2 },
        { 0x5141, 0x5AC9 },
        { 0x5143, 0x5AA9 },
        { 0x5144, 0x58D5 },
        { 0x5145, 0x4A85 },
        { 0x5146, 0x5B77 },
        { 0x5148, 0x5868 },
        { 0x5149, 0x4D83 },
        { 0x514B, 0x506B },
        { 0x514D, 0x5283 },
        { 0x5151, 0x4BD1 },
        { 0x5154, 0x5763 },
        { 0x5155, 0x5D8F },
        { 0x5156, 0x5D91 },
        { 0x515A, 0x4B53 },
        { 0x515C, 0x4BB4 },
        { 0x5162, 0x4FA3 },
        { 0x5165, 0x54EA },
        { 0x5168, 0x54AA },
        { 0x516B, 0x48CA },
        { 0x516C, 0x4D4B },
        { 0x516D, 0x519A },
        { 0x516E, 0x5D83 },
        { 0x5170, 0x50BB },
        { 0x5171, 0x4D52 },
        { 0x5173, 0x4D78 },
        { 0x5174, 0x58CA },
        { 0x5175, 0x4999 },
        { 0x5176, 0x53E3 },
        { 0x5177, 0x4FDE },
        { 0x5178, 0x4B85 },
        { 0x5179, 0x5C68 },
        { 0x517B, 0x5999 },
        { 0x517C, 0x4EE5 },
        { 0x517D, 0x55DD },
        { 0x5180, 0x4EBC },
        { 0x5181, 0x5D87 },
        { 0x5182, 0x5CE6 },
        { 0x5185, 0x52D9 },
        { 0x5188, 0x4CD3 },
        { 0x5189, 0x54BC },
        { 0x518C, 0x49E0 },
        { 0x518D, 0x5AD8 },
        { 0x5192, 0x5250 },
        { 0x5195, 0x5282 },
        { 0x5196, 0x5DA1 },
        { 0x5197, 0x54DE },
        { 0x5199, 0x58B3 },
        { 0x519B, 0x4FFB },
        { 0x519C, 0x5349 },
        { 0x51A0, 0x4D7A },
        { 0x51A2, 0x5DA2 },
        { 0x51A4, 0x5AA8 },
        { 0x51A5, 0x5DA3 },
        { 0x51AB, 0x5D9C },
        { 0x51AC, 0x4BAB },
        { 0x51AF, 0x4C8C },
        { 0x51B0, 0x499A },
        { 0x51B1, 0x5D9D },
        { 0x51B2, 0x4A86 },
        { 0x51B3, 0x4FF5 },
        { 0x51B5, 0x5097 },
        { 0x51B6, 0x59B0 },
        { 0x51B7, 0x50E3 },
        { 0x51BB, 0x4BB2 },
        { 0x51BC, 0x5D9F },
        { 0x51BD, 0x5D9E },
        { 0x51C0, 0x4FBA },
        { 0x51C4, 0x53DF },
        { 0x51C6, 0x5C5C },
        { 0x51C7, 0x5DA0 },
        { 0x51C9, 0x5159 },
        { 0x51CB, 0x4B93 },
        { 0x51CC, 0x5189 },
        { 0x51CF, 0x4EF4 },
        { 0x51D1, 0x4AD4 },
        { 0x51DB, 0x517D },
        { 0x51DD, 0x52FC },
        { 0x51E0, 0x4EB7 },
        { 0x51E1, 0x4C52 },
        { 0x51E4, 0x4C90 },
        { 0x51EB, 0x5D8D },
        { 0x51ED, 0x53BD },
        { 0x51EF, 0x504D },
        { 0x51F0, 0x4E6B },
        { 0x51F3, 0x4B6A },
        { 0x51F5, 0x5E69 },
        { 0x51F6, 0x58D6 },
        { 0x51F8, 0x5759 },
        { 0x51F9, 0x48BB },
        { 0x51FA, 0x4A97 },
        { 0x51FB, 0x4E98 },
        { 0x51FC, 0x5E6A },
        { 0x51FD, 0x4DAE },
        { 0x51FF, 0x5AE3 },
        { 0x5200, 0x4B56 },
        { 0x5201, 0x4B94 },
        { 0x5202, 0x5CD5 },
        { 0x5203, 0x54CF },
        { 0x5206, 0x4C76 },
        { 0x5207, 0x5470 },
        { 0x5208, 0x5CD6 },
        { 0x520A, 0x504F },
        { 0x520D, 0x5E5B },
        { 0x520E, 0x5CD7 },
        { 0x5211, 0x58CB },
        { 0x5212, 0x4E4E },
        { 0x5216, 0x665E },
        { 0x5217, 0x5170 },
        { 0x5218, 0x5196 },
        { 0x5219, 0x5AF1 },
        { 0x521A, 0x4CD4 },
        { 0x521B, 0x4AB3 },
        { 0x521D, 0x4A96 },
        { 0x5220, 0x555E },
        { 0x5224, 0x5370 },
        { 0x5228, 0x5379 },
        { 0x5229, 0x50FA },
        { 0x522B, 0x4991 },
        { 0x522D, 0x5CD8 },
        { 0x522E, 0x4D6E },
        { 0x5230, 0x4B5D },
        { 0x5233, 0x5CD9 },
        { 0x5236, 0x5BC5 },
        { 0x5237, 0x5642 },
        { 0x5238, 0x54AE },
        { 0x5239, 0x5552 },
        { 0x523A, 0x4ACB },
        { 0x523B, 0x506C },
        { 0x523D, 0x4D95 },
        { 0x523F, 0x5CDA },
        { 0x5240, 0x5CDB },
        { 0x5241, 0x4BE6 },
        { 0x5242, 0x4EC0 },
        { 0x5243, 0x56E9 },
        { 0x524A, 0x5898 },
        { 0x524C, 0x5CDC },
        { 0x524D, 0x5450 },
        { 0x5250, 0x4D70 },
        { 0x5251, 0x4F43 },
        { 0x5254, 0x56DD },
        { 0x5256, 0x53C9 },
        { 0x525C, 0x5CDF },
        { 0x525E, 0x5CDD },
        { 0x5261, 0x5CDE },
        { 0x5265, 0x48FD },
        { 0x5267, 0x4FE6 },
        { 0x5269, 0x55A2 },
        { 0x526A, 0x4EF3 },
        { 0x526F, 0x4CB0 },
        { 0x5272, 0x4CED },
        { 0x527D, 0x5CE1 },
        { 0x527F, 0x4F6B },
        { 0x5281, 0x5CE3 },
        { 0x5282, 0x5CE2 },
        { 0x5288, 0x539D },
        { 0x5290, 0x5CE4 },
        { 0x5293, 0x5CE5 },
        { 0x529B, 0x5146 },
        { 0x529D, 0x54AF },
        { 0x529E, 0x48EB },
        { 0x529F, 0x4D46 },
        { 0x52A0, 0x4ED2 },
        { 0x52A1, 0x57F0 },
        { 0x52A2, 0x5E5D },
        { 0x52A3, 0x5173 },
        { 0x52A8, 0x4BAE },
        { 0x52A9, 0x5BF9 },
        { 0x52AA, 0x534C },
        { 0x52AB, 0x4F79 },
        { 0x52AC, 0x5E5E },
        { 0x52AD, 0x5E5F },
        { 0x52B1, 0x50F7 },
        { 0x52B2, 0x4FA1 },
        { 0x52B3, 0x50CC },
        { 0x52BE, 0x5E60 },
        { 0x52BF, 0x55C5 },
        { 0x52C3, 0x49A9 },
        { 0x52C7, 0x5A62 },
        { 0x52C9, 0x5284 },
        { 0x52CB, 0x594B },
        { 0x52D0, 0x5E62 },
        { 0x52D2, 0x50D4 },
        { 0x52D6, 0x5E63 },
        { 0x52D8, 0x5051 },
        { 0x52DF, 0x52BB },
        { 0x52E4, 0x547A },
        { 0x52F0, 0x5E64 },
        { 0x52F9, 0x5D89 },
        { 0x52FA, 0x5577 },
        { 0x52FE, 0x4D54 },
        { 0x52FF, 0x57EF },
        { 0x5300, 0x5AC7 },
        { 0x5305, 0x48FB },
        { 0x5306, 0x4AD1 },
        { 0x5308, 0x58D8 },
        { 0x530D, 0x5D8A },
        { 0x530F, 0x5FCA },
        { 0x5310, 0x5D8C },
        { 0x5315, 0x5CAF },
        { 0x5316, 0x4E4F },
        { 0x5317, 0x4951 },
        { 0x5319, 0x4A77 },
        { 0x531A, 0x5CCD },
        { 0x531D, 0x5AD0 },
        { 0x5320, 0x4F53 },
        { 0x5321, 0x5090 },
        { 0x5323, 0x585B },
        { 0x5326, 0x5CCF },
        { 0x532A, 0x4C6B },
        { 0x532E, 0x5CD0 },
        { 0x5339, 0x53A4 },
        { 0x533A, 0x5499 },
        { 0x533B, 0x59BC },
        { 0x533E, 0x5CD1 },
        { 0x533F, 0x52E3 },
        { 0x5341, 0x55AD },
        { 0x5343, 0x5447 },
        { 0x5345, 0x5CA5 },
        { 0x5347, 0x559E },
        { 0x5348, 0x57E6 },
        { 0x5349, 0x4E7C },
        { 0x534A, 0x48EA },
        { 0x534E, 0x4E4A },
        { 0x534F, 0x58AC },
        { 0x5351, 0x4950 },
        { 0x5352, 0x5C85 },
        { 0x5353, 0x5C5F },
        { 0x5355, 0x4B45 },
        { 0x5356, 0x51F3 },
        { 0x5357, 0x52CE },
        { 0x535A, 0x49A8 },
        { 0x535C, 0x49B6 },
        { 0x535E, 0x4986 },
        { 0x535F, 0x6052 },
        { 0x5360, 0x5B5C },
        { 0x5361, 0x5048 },
        { 0x5362, 0x51AB },
        { 0x5363, 0x5CD4 },
        { 0x5364, 0x51B0 },
        { 0x5366, 0x5CD3 },
        { 0x5367, 0x57D3 },
        { 0x5369, 0x5DDF },
        { 0x536B, 0x57BF },
        { 0x536E, 0x5CB3 },
        { 0x536F, 0x524E },
        { 0x5370, 0x5A41 },
        { 0x5371, 0x57A2 },
        { 0x5373, 0x4EB3 },
        { 0x5374, 0x54B3 },
        { 0x5375, 0x51D0 },
        { 0x5377, 0x4FEC },
        { 0x5378, 0x58B5 },
        { 0x537A, 0x5DE0 },
        { 0x537F, 0x5485 },
        { 0x5382, 0x4A47 },
        { 0x5384, 0x4BF1 },
        { 0x5385, 0x56FB },
        { 0x5386, 0x50F9 },
        { 0x5389, 0x50F6 },
        { 0x538B, 0x5959 },
        { 0x538C, 0x5982 },
        { 0x538D, 0x5CC6 },
        { 0x5395, 0x49DD },
        { 0x5398, 0x50E4 },
        { 0x539A, 0x4DF0 },
        { 0x539D, 0x5CC7 },
        { 0x539F, 0x5AAC },
        { 0x53A2, 0x5882 },
        { 0x53A3, 0x5CC8 },
        { 0x53A5, 0x5CC9 },
        { 0x53A6, 0x5863 },
        { 0x53A8, 0x4A99 },
        { 0x53A9, 0x4FC6 },
        { 0x53AE, 0x5CCA },
        { 0x53B6, 0x5E6C },
        { 0x53BB, 0x54A4 },
        { 0x53BF, 0x5878 },
        { 0x53C1, 0x54FD },
        { 0x53C2, 0x49CD },
        { 0x53C8, 0x5A76 },
        { 0x53C9, 0x49E5 },
        { 0x53CA, 0x4EAF },
        { 0x53CB, 0x5A71 },
        { 0x53CC, 0x564B },
        { 0x53CD, 0x4C54 },
        { 0x53D1, 0x4C42 },
        { 0x53D4, 0x55E4 },
        { 0x53D6, 0x54A0 },
        { 0x53D7, 0x55DB },
        { 0x53D8, 0x4985 },
        { 0x53D9, 0x58EF },
        { 0x53DB, 0x5371 },
        { 0x53DF, 0x5E65 },
        { 0x53E0, 0x4B9F },
        { 0x53E3, 0x507A },
        { 0x53E4, 0x4D65 },
        { 0x53E5, 0x4FE3 },
        { 0x53E6, 0x518E },
        { 0x53E8, 0x6056 },
        { 0x53E9, 0x6055 },
        { 0x53EA, 0x5BBA },
        { 0x53EB, 0x4F70 },
        { 0x53EC, 0x5B79 },
        { 0x53ED, 0x48C7 },
        { 0x53EE, 0x4BA2 },
        { 0x53EF, 0x5069 },
        { 0x53F0, 0x56A7 },
        { 0x53F1, 0x6053 },
        { 0x53F2, 0x55B6 },
        { 0x53F3, 0x5A72 },
        { 0x53F5, 0x5CCE },
        { 0x53F6, 0x59B5 },
        { 0x53F7, 0x4DC4 },
        { 0x53F8, 0x565E },
        { 0x53F9, 0x56BD },
        { 0x53FB, 0x6057 },
        { 0x53FC, 0x4B91 },
        { 0x53FD, 0x6054 },
        { 0x5401, 0x5A96 },
        { 0x5403, 0x4A74 },
        { 0x5404, 0x4CF6 },
        { 0x5406, 0x605A },
        { 0x5408, 0x4DCE },
        { 0x5409, 0x4EA9 },
        { 0x540A, 0x4B96 },
        { 0x540C, 0x574C },
        { 0x540D, 0x529C },
        { 0x540E, 0x4DF2 },
        { 0x540F, 0x50F3 },
        { 0x5410, 0x5762 },
        { 0x5411, 0x5893 },
        { 0x5412, 0x6058 },
        { 0x5413, 0x5865 },
        { 0x5415, 0x51BF },
        { 0x5416, 0x6059 },
        { 0x5417, 0x51EF },
        { 0x541B, 0x4FFC },
        { 0x541D, 0x517F },
        { 0x541E, 0x576C },
        { 0x541F, 0x59F6 },
        { 0x5420, 0x4C6D },
        { 0x5421, 0x6061 },
        { 0x5423, 0x6064 },
        { 0x5426, 0x4C92 },
        { 0x5427, 0x48C8 },
        { 0x5428, 0x4BD5 },
        { 0x5429, 0x4C74 },
        { 0x542B, 0x4DAB },
        { 0x542C, 0x56FC },
        { 0x542D, 0x5074 },
        { 0x542E, 0x5651 },
        { 0x542F, 0x53F3 },
        { 0x5431, 0x5BA7 },
        { 0x5432, 0x6065 },
        { 0x5434, 0x57E1 },
        { 0x5435, 0x4A53 },
        { 0x5438, 0x57FB },
        { 0x5439, 0x4AB4 },
        { 0x543B, 0x57C6 },
        { 0x543C, 0x4DEF },
        { 0x543E, 0x57E0 },
        { 0x5440, 0x595D },
        { 0x5443, 0x6060 },
        { 0x5446, 0x4AF3 },
        { 0x5448, 0x4A6A },
        { 0x544A, 0x4CE5 },
        { 0x544B, 0x605B },
        { 0x5450, 0x52C4 },
        { 0x5452, 0x605C },
        { 0x5453, 0x605D },
        { 0x5454, 0x605E },
        { 0x5455, 0x535B },
        { 0x5456, 0x605F },
        { 0x5457, 0x6062 },
        { 0x5458, 0x5AB0 },
        { 0x5459, 0x6063 },
        { 0x545B, 0x545A },
        { 0x545C, 0x57D7 },
        { 0x5462, 0x52D7 },
        { 0x5464, 0x606A },
        { 0x5466, 0x606F },
        { 0x5468, 0x5BDB },
        { 0x5471, 0x6069 },
        { 0x5472, 0x607A },
        { 0x5473, 0x57B5 },
        { 0x5475, 0x4DC6 },
        { 0x5476, 0x606E },
        { 0x5477, 0x6068 },
        { 0x5478, 0x537E },
        { 0x547B, 0x558C },
        { 0x547C, 0x4DF3 },
        { 0x547D, 0x529D },
        { 0x5480, 0x4FD6 },
        { 0x5482, 0x6066 },
        { 0x5484, 0x606D },
        { 0x5486, 0x5378 },
        { 0x548B, 0x5B46 },
        { 0x548C, 0x4DCC },
        { 0x548E, 0x4FCB },
        { 0x548F, 0x5A5D },
        { 0x5490, 0x4CBF },
        { 0x5492, 0x5BE3 },
        { 0x5494, 0x6067 },
        { 0x5495, 0x4D5E },
        { 0x5496, 0x5047 },
        { 0x5499, 0x519D },
        { 0x549A, 0x606B },
        { 0x549B, 0x606C },
        { 0x549D, 0x6070 },
        { 0x54A3, 0x607B },
        { 0x54A4, 0x6086 },
        { 0x54A6, 0x6077 },
        { 0x54A7, 0x6076 },
        { 0x54A8, 0x5C69 },
        { 0x54A9, 0x6084 },
        { 0x54AA, 0x6085 },
        { 0x54AB, 0x638C },
        { 0x54AC, 0x59A6 },
        { 0x54AD, 0x6072 },
        { 0x54AF, 0x5049 },
        { 0x54B1, 0x5ADA },
        { 0x54B3, 0x5068 },
        { 0x54B4, 0x6074 },
        { 0x54B8, 0x586C },
        { 0x54BB, 0x607D },
        { 0x54BD, 0x596A },
        { 0x54BF, 0x607E },
        { 0x54C0, 0x48A6 },
        { 0x54C1, 0x53B6 },
        { 0x54C2, 0x6073 },
        { 0x54C4, 0x4DE4 },
        { 0x54C6, 0x4BDE },
        { 0x54C7, 0x577B },
        { 0x54C8, 0x4D9F },
        { 0x54C9, 0x5AD4 },
        { 0x54CC, 0x607F },
        { 0x54CD, 0x588D },
        { 0x54CE, 0x48A4 },
        { 0x54CF, 0x6088 },
        { 0x54D0, 0x6071 },
        { 0x54D1, 0x5966 },
        { 0x54D2, 0x6075 },
        { 0x54D3, 0x6078 },
        { 0x54D4, 0x6079 },
        { 0x54D5, 0x607C },
        { 0x54D7, 0x4E49 },
        { 0x54D9, 0x6081 },
        { 0x54DA, 0x6082 },
        { 0x54DC, 0x6083 },
        { 0x54DD, 0x6087 },
        { 0x54DE, 0x6089 },
        { 0x54DF, 0x5A54 },
        { 0x54E5, 0x4CE6 },
        { 0x54E6, 0x5356 },
        { 0x54E7, 0x608B },
        { 0x54E8, 0x557A },
        { 0x54E9, 0x5148 },
        { 0x54EA, 0x52C3 },
        { 0x54ED, 0x507E },
        { 0x54EE, 0x5899 },
        { 0x54F2, 0x5B7C },
        { 0x54F3, 0x608F },
        { 0x54FA, 0x49B7 },
        { 0x54FC, 0x4DDE },
        { 0x54FD, 0x608D },
        { 0x54FF, 0x5E61 },
        { 0x5501, 0x5985 },
        { 0x5506, 0x5695 },
        { 0x5507, 0x4ABC },
        { 0x5509, 0x48A5 },
        { 0x550F, 0x6092 },
        { 0x5510, 0x56C5 },
        { 0x5511, 0x6093 },
        { 0x5514, 0x608E },
        { 0x551B, 0x608A },
        { 0x5520, 0x608C },
        { 0x5522, 0x6090 },
        { 0x5523, 0x6091 },
        { 0x5524, 0x4E5D },
        { 0x5527, 0x6094 },
        { 0x552A, 0x6095 },
        { 0x552C, 0x4E43 },
        { 0x552E, 0x55DA },
        { 0x552F, 0x57A7 },
        { 0x5530, 0x60A6 },
        { 0x5531, 0x4A4A },
        { 0x5533, 0x60A5 },
        { 0x5537, 0x60A0 },
        { 0x553C, 0x609F },
        { 0x553E, 0x5779 },
        { 0x553F, 0x609D },
        { 0x5541, 0x609B },
        { 0x5543, 0x5070 },
        { 0x5544, 0x5C64 },
        { 0x5546, 0x556C },
        { 0x5549, 0x6099 },
        { 0x554A, 0x48A0 },
        { 0x5550, 0x609E },
        { 0x5555, 0x609C },
        { 0x5556, 0x60A1 },
        { 0x555C, 0x60A7 },
        { 0x5561, 0x4C68 },
        { 0x5564, 0x53A0 },
        { 0x5565, 0x5556 },
        { 0x5566, 0x50B1 },
        { 0x5567, 0x6096 },
        { 0x556A, 0x535E },
        { 0x556C, 0x5CC3 },
        { 0x556D, 0x609A },
        { 0x556E, 0x52F5 },
        { 0x5575, 0x60A2 },
        { 0x5576, 0x60A3 },
        { 0x5577, 0x60A4 },
        { 0x5578, 0x58A4 },
        { 0x557B, 0x60B3 },
        { 0x557C, 0x56E3 },
        { 0x557E, 0x60B0 },
        { 0x5580, 0x5046 },
        { 0x5581, 0x60AE },
        { 0x5582, 0x57B8 },
        { 0x5583, 0x60AA },
        { 0x5584, 0x5566 },
        { 0x5587, 0x50AD },
        { 0x5588, 0x60AD },
        { 0x5589, 0x4DEC },
        { 0x558A, 0x4DAF },
        { 0x558B, 0x60A8 },
        { 0x558F, 0x6097 },
        { 0x5591, 0x60B2 },
        { 0x5594, 0x60B7 },
        { 0x5598, 0x4AAC },
        { 0x5599, 0x60B8 },
        { 0x559C, 0x5852 },
        { 0x559D, 0x4DC7 },
        { 0x559F, 0x60AF },
        { 0x55A7, 0x58F9 },
        { 0x55B1, 0x60AB },
        { 0x55B3, 0x5AFA },
        { 0x55B5, 0x6098 },
        { 0x55B7, 0x5388 },
        { 0x55B9, 0x60AC },
        { 0x55BB, 0x5A98 },
        { 0x55BD, 0x60B5 },
        { 0x55BE, 0x60B6 },
        { 0x55C4, 0x60C3 },
        { 0x55C5, 0x58E0 },
        { 0x55C9, 0x60BB },
        { 0x55CC, 0x60C8 },
        { 0x55CD, 0x60C9 },
        { 0x55D1, 0x60BD },
        { 0x55D2, 0x60A9 },
        { 0x55D3, 0x5544 },
        { 0x55D4, 0x60C0 },
        { 0x55D6, 0x60B1 },
        { 0x55DC, 0x55C7 },
        { 0x55DD, 0x60C2 },
        { 0x55DF, 0x60B4 },
        { 0x55E1, 0x57CA },
        { 0x55E3, 0x5663 },
        { 0x55E4, 0x60CC },
        { 0x55E5, 0x60C5 },
        { 0x55E6, 0x60C1 },
        { 0x55E8, 0x60CA },
        { 0x55EA, 0x60B9 },
        { 0x55EB, 0x60BE },
        { 0x55EC, 0x60BF },
        { 0x55EF, 0x60C4 },
        { 0x55F2, 0x60C6 },
        { 0x55F3, 0x60C7 },
        { 0x55F5, 0x60CB },
        { 0x55F7, 0x60BA },
        { 0x55FD, 0x5674 },
        { 0x55FE, 0x60D4 },
        { 0x5600, 0x60D5 },
        { 0x5601, 0x60D1 },
        { 0x5608, 0x60CF },
        { 0x5609, 0x4ECD },
        { 0x560C, 0x60D0 },
        { 0x560E, 0x4CC1 },
        { 0x560F, 0x5CC4 },
        { 0x5618, 0x58E9 },
        { 0x561B, 0x51EE },
        { 0x561E, 0x60CE },
        { 0x561F, 0x60BC },
        { 0x5623, 0x60D3 },
        { 0x5624, 0x60D2 },
        { 0x5627, 0x60D6 },
        { 0x562C, 0x60DB },
        { 0x562D, 0x60D7 },
        { 0x5631, 0x5BF5 },
        { 0x5632, 0x4A50 },
        { 0x5634, 0x5C8D },
        { 0x5636, 0x565B },
        { 0x5639, 0x60D9 },
        { 0x563B, 0x57FA },
        { 0x563F, 0x4DD8 },
        { 0x564C, 0x60E0 },
        { 0x564D, 0x60DC },
        { 0x564E, 0x59AC },
        { 0x5654, 0x60E1 },
        { 0x5657, 0x60DA },
        { 0x5658, 0x60D8 },
        { 0x5659, 0x60DE },
        { 0x565C, 0x60DF },
        { 0x5662, 0x60DD },
        { 0x5664, 0x60E3 },
        { 0x5668, 0x53F6 },
        { 0x5669, 0x5CAB },
        { 0x566A, 0x5AEA },
        { 0x566B, 0x60E5 },
        { 0x566C, 0x55C8 },
        { 0x5671, 0x60E4 },
        { 0x5676, 0x4CC0 },
        { 0x567B, 0x60E6 },
        { 0x567C, 0x60E7 },
        { 0x5685, 0x60E8 },
        { 0x5686, 0x60E2 },
        { 0x568E, 0x4DBE },
        { 0x568F, 0x56E6 },
        { 0x5693, 0x60E9 },
        { 0x56A3, 0x589A },
        { 0x56AF, 0x60EA },
        { 0x56B7, 0x54C1 },
        { 0x56BC, 0x4F60 },
        { 0x56CA, 0x52D1 },
        { 0x56D4, 0x60EB },
        { 0x56D7, 0x60EC },
        { 0x56DA, 0x5495 },
        { 0x56DB, 0x5664 },
        { 0x56DD, 0x60ED },
        { 0x56DE, 0x4E78 },
        { 0x56DF, 0x5CB5 },
        { 0x56E0, 0x59F1 },
        { 0x56E1, 0x60EE },
        { 0x56E2, 0x5765 },
        { 0x56E4, 0x4BD9 },
        { 0x56EB, 0x60F0 },
        { 0x56ED, 0x5AAF },
        { 0x56F0, 0x50A6 },
        { 0x56F1, 0x4AD0 },
        { 0x56F4, 0x57A6 },
        { 0x56F5, 0x60EF },
        { 0x56F9, 0x60F1 },
        { 0x56FA, 0x4D6C },
        { 0x56FD, 0x4D9B },
        { 0x56FE, 0x575C },
        { 0x56FF, 0x60F2 },
        { 0x5703, 0x53D3 },
        { 0x5704, 0x60F3 },
        { 0x5706, 0x5AB1 },
        { 0x5708, 0x54A5 },
        { 0x5709, 0x60F5 },
        { 0x570A, 0x60F4 },
        { 0x571C, 0x60F6 },
        { 0x571F, 0x5761 },
        { 0x5723, 0x55A4 },
        { 0x5728, 0x5AD9 },
        { 0x5729, 0x5E77 },
        { 0x572A, 0x5E79 },
        { 0x572C, 0x5E78 },
        { 0x572D, 0x4D88 },
        { 0x572E, 0x5E7C },
        { 0x572F, 0x5E7D },
        { 0x5730, 0x4B78 },
        { 0x5733, 0x5E7A },
        { 0x5739, 0x5E7B },
        { 0x573A, 0x4A41 },
        { 0x573B, 0x5E7F },
        { 0x573E, 0x4E99 },
        { 0x5740, 0x5BB6 },
        { 0x5742, 0x5E81 },
        { 0x5747, 0x4FF8 },
        { 0x574A, 0x4C5B },
        { 0x574C, 0x5E70 },
        { 0x574D, 0x56AD },
        { 0x574E, 0x5052 },
        { 0x574F, 0x4E55 },
        { 0x5750, 0x5C99 },
        { 0x5751, 0x5073 },
        { 0x5757, 0x508A },
        { 0x575A, 0x4EE0 },
        { 0x575B, 0x56B2 },
        { 0x575C, 0x5E7E },
        { 0x575D, 0x48D2 },
        { 0x575E, 0x57EA },
        { 0x575F, 0x4C78 },
        { 0x5760, 0x5C59 },
        { 0x5761, 0x53C1 },
        { 0x5764, 0x50A3 },
        { 0x5766, 0x56B8 },
        { 0x5768, 0x5E88 },
        { 0x5769, 0x5E82 },
        { 0x576A, 0x53B9 },
        { 0x576B, 0x5E84 },
        { 0x576D, 0x5E89 },
        { 0x576F, 0x5398 },
        { 0x5773, 0x5E8B },
        { 0x5776, 0x5E8A },
        { 0x5777, 0x5060 },
        { 0x577B, 0x5E87 },
        { 0x577C, 0x5E86 },
        { 0x5782, 0x4AB8 },
        { 0x5783, 0x50AB },
        { 0x5784, 0x51A1 },
        { 0x5785, 0x5E83 },
        { 0x5786, 0x5E85 },
        { 0x578B, 0x58CC },
        { 0x578C, 0x5E8E },
        { 0x5792, 0x50DC },
        { 0x5793, 0x5E93 },
        { 0x579B, 0x4BE1 },
        { 0x57A0, 0x5E94 },
        { 0x57A1, 0x5E72 },
        { 0x57A2, 0x4D58 },
        { 0x57A3, 0x5AAA },
        { 0x57A4, 0x5E8D },
        { 0x57A6, 0x5071 },
        { 0x57A7, 0x5E91 },
        { 0x57A9, 0x5E71 },
        { 0x57AB, 0x4B87 },
        { 0x57AD, 0x5E8C },
        { 0x57AE, 0x5086 },
        { 0x57B2, 0x5E8F },
        { 0x57B4, 0x5E92 },
        { 0x57B8, 0x5E9A },
        { 0x57C2, 0x4D41 },
        { 0x57C3, 0x48A2 },
        { 0x57CB, 0x51F0 },
        { 0x57CE, 0x4A67 },
        { 0x57CF, 0x5E90 },
        { 0x57D2, 0x5E99 },
        { 0x57D4, 0x53D1 },
        { 0x57D5, 0x5E95 },
        { 0x57D8, 0x5E96 },
        { 0x57D9, 0x5E98 },
        { 0x57DA, 0x5E97 },
        { 0x57DD, 0x5E9F },
        { 0x57DF, 0x5A93 },
        { 0x57E0, 0x49B9 },
        { 0x57E4, 0x5E9E },
        { 0x57ED, 0x5EA3 },
        { 0x57EF, 0x5E9C },
        { 0x57F4, 0x5E9B },
        { 0x57F8, 0x5E9D },
        { 0x57F9, 0x5381 },
        { 0x57FA, 0x4E9A },
        { 0x57FD, 0x5EA2 },
        { 0x5800, 0x5EA4 },
        { 0x5802, 0x56C2 },
        { 0x5806, 0x4BD0 },
        { 0x5807, 0x5F60 },
        { 0x580B, 0x5EA0 },
        { 0x580D, 0x5EA1 },
        { 0x5811, 0x5455 },
        { 0x5815, 0x4BE8 },
        { 0x5819, 0x5EA6 },
        { 0x581E, 0x5EA5 },
        { 0x5820, 0x5EA8 },
        { 0x5821, 0x4944 },
        { 0x5824, 0x4B6C },
        { 0x582A, 0x5050 },
        { 0x5830, 0x597F },
        { 0x5835, 0x4BC1 },
        { 0x5844, 0x5EA7 },
        { 0x584C, 0x569B },
        { 0x584D, 0x6694 },
        { 0x5851, 0x567C },
        { 0x5854, 0x569F },
        { 0x5858, 0x56C0 },
        { 0x585E, 0x54FA },
        { 0x5865, 0x5EA9 },
        { 0x586B, 0x56ED },
        { 0x586C, 0x5EAA },
        { 0x587E, 0x5E73 },
        { 0x5880, 0x5EAE },
        { 0x5881, 0x5EAB },
        { 0x5883, 0x4FB2 },
        { 0x5885, 0x55FA },
        { 0x5889, 0x5EAC },
        { 0x5892, 0x556A },
        { 0x5893, 0x52B8 },
        { 0x5899, 0x545D },
        { 0x589A, 0x5EAD },
        { 0x589E, 0x5AF5 },
        { 0x589F, 0x58E5 },
        { 0x58A8, 0x52AA },
        { 0x58A9, 0x4BD4 },
        { 0x58BC, 0x5E74 },
        { 0x58C1, 0x497A },
        { 0x58C5, 0x5E75 },
        { 0x58D1, 0x5E76 },
        { 0x58D5, 0x4DBD },
        { 0x58E4, 0x54BF },
        { 0x58EB, 0x55BE },
        { 0x58EC, 0x54C8 },
        { 0x58EE, 0x5C53 },
        { 0x58F0, 0x559A },
        { 0x58F3, 0x5067 },
        { 0x58F6, 0x4DF7 },
        { 0x58F9, 0x59BB },
        { 0x5902, 0x61B9 },
        { 0x5904, 0x4AA5 },
        { 0x5907, 0x4958 },
        { 0x590D, 0x4CB3 },
        { 0x590F, 0x5864 },
        { 0x5914, 0x5D88 },
        { 0x5915, 0x5846 },
        { 0x5916, 0x5783 },
        { 0x5919, 0x5D8E },
        { 0x591A, 0x4BDF },
        { 0x591C, 0x59B8 },
        { 0x591F, 0x4D5B },
        { 0x5924, 0x61B8 },
        { 0x5925, 0x61B6 },
        { 0x5927, 0x4AF2 },
        { 0x5929, 0x56EB },
        { 0x592A, 0x56AA },
        { 0x592B, 0x4C93 },
        { 0x592D, 0x5CB1 },
        { 0x592E, 0x598C },
        { 0x592F, 0x4DBA },
        { 0x5931, 0x55A6 },
        { 0x5934, 0x5757 },
        { 0x5937, 0x59C3 },
        { 0x5938, 0x5085 },
        { 0x5939, 0x4ECF },
        { 0x593A, 0x4BE0 },
        { 0x593C, 0x5FC4 },
        { 0x5941, 0x5FC5 },
        { 0x5942, 0x5E5C },
        { 0x5944, 0x5979 },
        { 0x5947, 0x53E5 },
        { 0x5948, 0x52CD },
        { 0x5949, 0x4C8F },
        { 0x594B, 0x4C7C },
        { 0x594E, 0x509D },
        { 0x594F, 0x5C81 },
        { 0x5951, 0x53F4 },
        { 0x5954, 0x495C },
        { 0x5955, 0x5FC7 },
        { 0x5956, 0x4F51 },
        { 0x5957, 0x56D6 },
        { 0x5958, 0x5FC9 },
        { 0x595A, 0x5FC8 },
        { 0x5960, 0x4B8D },
        { 0x5962, 0x557D },
        { 0x5965, 0x48C1 },
        { 0x5973, 0x534E },
        { 0x5974, 0x534B },
        { 0x5976, 0x52CB },
        { 0x5978, 0x4EE8 },
        { 0x5979, 0x569E },
        { 0x597D, 0x4DC2 },
        { 0x5981, 0x639A },
        { 0x5982, 0x54E6 },
        { 0x5983, 0x639B },
        { 0x5984, 0x579E },
        { 0x5986, 0x5C51 },
        { 0x5987, 0x4CBD },
        { 0x5988, 0x51E7 },
        { 0x598A, 0x54D0 },
        { 0x598D, 0x639C },
        { 0x5992, 0x4BC9 },
        { 0x5993, 0x4ECA },
        { 0x5996, 0x599E },
        { 0x5997, 0x63A0 },
        { 0x5999, 0x528F },
        { 0x599E, 0x63A3 },
        { 0x59A3, 0x639F },
        { 0x59A4, 0x63A4 },
        { 0x59A5, 0x5777 },
        { 0x59A8, 0x4C61 },
        { 0x59A9, 0x639D },
        { 0x59AA, 0x639E },
        { 0x59AB, 0x63A2 },
        { 0x59AE, 0x52DC },
        { 0x59AF, 0x63A7 },
        { 0x59B2, 0x63A6 },
        { 0x59B9, 0x5263 },
        { 0x59BB, 0x53DD },
        { 0x59BE, 0x63A9 },
        { 0x59C6, 0x52B6 },
        { 0x59CA, 0x63A1 },
        { 0x59CB, 0x55BB },
        { 0x59D0, 0x4F84 },
        { 0x59D1, 0x4D63 },
        { 0x59D2, 0x63A5 },
        { 0x59D3, 0x58D4 },
        { 0x59D4, 0x57AE },
        { 0x59D7, 0x63A8 },
        { 0x59D8, 0x63AF },
        { 0x59DA, 0x59A5 },
        { 0x59DC, 0x4F4A },
        { 0x59DD, 0x63AC },
        { 0x59E3, 0x63AE },
        { 0x59E5, 0x50D0 },
        { 0x59E8, 0x59CB },
        { 0x59EC, 0x4EA6 },
        { 0x59F9, 0x63B0 },
        { 0x59FB, 0x59F5 },
        { 0x59FF, 0x5C6B },
        { 0x5A01, 0x579F },
        { 0x5A03, 0x577E },
        { 0x5A04, 0x51A5 },
        { 0x5A05, 0x63AA },
        { 0x5A06, 0x63AB },
        { 0x5A07, 0x4F5F },
        { 0x5A08, 0x63AD },
        { 0x5A09, 0x63B2 },
        { 0x5A0C, 0x63B1 },
        { 0x5A11, 0x63B5 },
        { 0x5A13, 0x63B7 },
        { 0x5A18, 0x52EE },
        { 0x5A1C, 0x52C7 },
        { 0x5A1F, 0x4FE9 },
        { 0x5A20, 0x5590 },
        { 0x5A23, 0x63B6 },
        { 0x5A25, 0x4BEF },
        { 0x5A29, 0x5285 },
        { 0x5A31, 0x5A8A },
        { 0x5A32, 0x63B3 },
        { 0x5A34, 0x63B4 },
        { 0x5A36, 0x54A1 },
        { 0x5A3C, 0x63BC },
        { 0x5A40, 0x63B8 },
        { 0x5A46, 0x53C4 },
        { 0x5A49, 0x5792 },
        { 0x5A4A, 0x63BA },
        { 0x5A55, 0x63BB },
        { 0x5A5A, 0x4E8A },
        { 0x5A62, 0x63BD },
        { 0x5A67, 0x63B9 },
        { 0x5A6A, 0x50B6 },
        { 0x5A74, 0x5A44 },
        { 0x5A75, 0x63BE },
        { 0x5A76, 0x5595 },
        { 0x5A77, 0x63C2 },
        { 0x5A7A, 0x63C3 },
        { 0x5A7F, 0x58F5 },
        { 0x5A92, 0x525D },
        { 0x5A9A, 0x5264 },
        { 0x5A9B, 0x63C1 },
        { 0x5AAA, 0x63C0 },
        { 0x5AB2, 0x63C6 },
        { 0x5AB3, 0x5851 },
        { 0x5AB5, 0x6695 },
        { 0x5AB8, 0x63C9 },
        { 0x5ABE, 0x63C4 },
        { 0x5AC1, 0x4EDD },
        { 0x5AC2, 0x5549 },
        { 0x5AC9, 0x4EB4 },
        { 0x5ACC, 0x5873 },
        { 0x5AD2, 0x63C7 },
        { 0x5AD4, 0x63C8 },
        { 0x5AD6, 0x63CD },
        { 0x5AD8, 0x63CF },
        { 0x5ADC, 0x63D0 },
        { 0x5AE0, 0x63CA },
        { 0x5AE1, 0x4B75 },
        { 0x5AE3, 0x63CB },
        { 0x5AE6, 0x63CE },
        { 0x5AE9, 0x52DA },
        { 0x5AEB, 0x63C5 },
        { 0x5AF1, 0x63CC },
        { 0x5B09, 0x63D1 },
        { 0x5B16, 0x63D3 },
        { 0x5B17, 0x63D2 },
        { 0x5B32, 0x63D4 },
        { 0x5B34, 0x5D99 },
        { 0x5B37, 0x63D5 },
        { 0x5B40, 0x63D6 },
        { 0x5B50, 0x5C73 },
        { 0x5B51, 0x63DC },
        { 0x5B53, 0x63DD },
        { 0x5B54, 0x5077 },
        { 0x5B55, 0x5ACF },
        { 0x5B57, 0x5C76 },
        { 0x5B58, 0x4AE5 },
        { 0x5B59, 0x5690 },
        { 0x5B5A, 0x63D9 },
        { 0x5B5B, 0x5CC2 },
        { 0x5B5C, 0x5C6E },
        { 0x5B5D, 0x58A1 },
        { 0x5B5F, 0x526F },
        { 0x5B62, 0x63DE },
        { 0x5B63, 0x4EBD },
        { 0x5B64, 0x4D62 },
        { 0x5B65, 0x63DA },
        { 0x5B66, 0x5947 },
        { 0x5B69, 0x4DA1 },
        { 0x5B6A, 0x51CE },
        { 0x5B6C, 0x5CAA },
        { 0x5B70, 0x55EA },
        { 0x5B71, 0x638F },
        { 0x5B73, 0x63DB },
        { 0x5B75, 0x4C96 },
        { 0x5B7A, 0x54E5 },
        { 0x5B7D, 0x52F4 },
        { 0x5B80, 0x6352 },
        { 0x5B81, 0x52FD },
        { 0x5B83, 0x569D },
        { 0x5B84, 0x6353 },
        { 0x5B85, 0x5B4C },
        { 0x5B87, 0x5A8F },
        { 0x5B88, 0x55D7 },
        { 0x5B89, 0x48B1 },
        { 0x5B8B, 0x566E },
        { 0x5B8C, 0x578B },
        { 0x5B8F, 0x4DE9 },
        { 0x5B93, 0x6355 },
        { 0x5B95, 0x6354 },
        { 0x5B97, 0x5C7A },
        { 0x5B98, 0x4D79 },
        { 0x5B99, 0x5BE5 },
        { 0x5B9A, 0x4BA7 },
        { 0x5B9B, 0x5791 },
        { 0x5B9C, 0x59CA },
        { 0x5B9D, 0x4946 },
        { 0x5B9E, 0x55B4 },
        { 0x5BA0, 0x4A89 },
        { 0x5BA1, 0x5594 },
        { 0x5BA2, 0x506D },
        { 0x5BA3, 0x58FA },
        { 0x5BA4, 0x55D1 },
        { 0x5BA5, 0x6356 },
        { 0x5BA6, 0x4E62 },
        { 0x5BAA, 0x587C },
        { 0x5BAB, 0x4D4C },
        { 0x5BB0, 0x5AD6 },
        { 0x5BB3, 0x4DA5 },
        { 0x5BB4, 0x5988 },
        { 0x5BB5, 0x589D },
        { 0x5BB6, 0x4ED1 },
        { 0x5BB8, 0x6357 },
        { 0x5BB9, 0x54DC },
        { 0x5BBD, 0x508E },
        { 0x5BBE, 0x4997 },
        { 0x5BBF, 0x567E },
        { 0x5BC2, 0x4EC4 },
        { 0x5BC4, 0x4EC3 },
        { 0x5BC5, 0x59F9 },
        { 0x5BC6, 0x527C },
        { 0x5BC7, 0x507C },
        { 0x5BCC, 0x4CBA },
        { 0x5BD0, 0x5262 },
        { 0x5BD2, 0x4DAD },
        { 0x5BD3, 0x5AA1 },
        { 0x5BDD, 0x547E },
        { 0x5BDE, 0x52AE },
        { 0x5BDF, 0x49EB },
        { 0x5BE1, 0x4D71 },
        { 0x5BE4, 0x635B },
        { 0x5BE5, 0x5168 },
        { 0x5BE8, 0x5B4F },
        { 0x5BEE, 0x635C },
        { 0x5BF0, 0x635E },
        { 0x5BF8, 0x4AE6 },
        { 0x5BF9, 0x4BD3 },
        { 0x5BFA, 0x5662 },
        { 0x5BFB, 0x5950 },
        { 0x5BFC, 0x4B5C },
        { 0x5BFF, 0x55D8 },
        { 0x5C01, 0x4C83 },
        { 0x5C04, 0x5585 },
        { 0x5C06, 0x4F4B },
        { 0x5C09, 0x57BD },
        { 0x5C0A, 0x5C91 },
        { 0x5C0F, 0x58A0 },
        { 0x5C11, 0x5579 },
        { 0x5C14, 0x4BFA },
        { 0x5C15, 0x63D7 },
        { 0x5C16, 0x4EE1 },
        { 0x5C18, 0x4A5E },
        { 0x5C1A, 0x5570 },
        { 0x5C1C, 0x63D8 },
        { 0x5C1D, 0x4A42 },
        { 0x5C22, 0x5FCB },
        { 0x5C24, 0x5A68 },
        { 0x5C25, 0x5FCC },
        { 0x5C27, 0x59A1 },
        { 0x5C2C, 0x5FCD },
        { 0x5C31, 0x4FCC },
        { 0x5C34, 0x5FCE },
        { 0x5C38, 0x55AB },
        { 0x5C39, 0x59FB },
        { 0x5C3A, 0x4A7F },
        { 0x5C3B, 0x638B },
        { 0x5C3C, 0x52E0 },
        { 0x5C3D, 0x4FA0 },
        { 0x5C3E, 0x57B1 },
        { 0x5C3F, 0x52F1 },
        { 0x5C40, 0x4FD5 },
        { 0x5C41, 0x53A7 },
        { 0x5C42, 0x49E2 },
        { 0x5C45, 0x4FD2 },
        { 0x5C48, 0x549D },
        { 0x5C49, 0x56EA },
        { 0x5C4A, 0x4F8D },
        { 0x5C4B, 0x57DC },
        { 0x5C4E, 0x55B9 },
        { 0x5C4F, 0x53C0 },
        { 0x5C50, 0x638D },
        { 0x5C51, 0x58BB },
        { 0x5C55, 0x5B59 },
        { 0x5C59, 0x638E },
        { 0x5C5E, 0x55F3 },
        { 0x5C60, 0x5760 },
        { 0x5C61, 0x51C4 },
        { 0x5C63, 0x6390 },
        { 0x5C65, 0x51C3 },
        { 0x5C66, 0x6391 },
        { 0x5C6E, 0x6399 },
        { 0x5C6F, 0x576D },
        { 0x5C71, 0x555D },
        { 0x5C79, 0x59D8 },
        { 0x5C7A, 0x6148 },
        { 0x5C7F, 0x5A8D },
        { 0x5C81, 0x568B },
        { 0x5C82, 0x53F0 },
        { 0x5C88, 0x614C },
        { 0x5C8C, 0x6147 },
        { 0x5C8D, 0x6149 },
        { 0x5C90, 0x614A },
        { 0x5C91, 0x614F },
        { 0x5C94, 0x49EC },
        { 0x5C96, 0x614B },
        { 0x5C97, 0x4CD9 },
        { 0x5C98, 0x614D },
        { 0x5C99, 0x614E },
        { 0x5C9A, 0x6150 },
        { 0x5C9B, 0x4B5A },
        { 0x5C9C, 0x6151 },
        { 0x5CA2, 0x6153 },
        { 0x5CA3, 0x6158 },
        { 0x5CA9, 0x5972 },
        { 0x5CAB, 0x6156 },
        { 0x5CAC, 0x6155 },
        { 0x5CAD, 0x518C },
        { 0x5CB1, 0x6157 },
        { 0x5CB3, 0x5ABF },
        { 0x5CB5, 0x6152 },
        { 0x5CB7, 0x615A },
        { 0x5CB8, 0x48B5 },
        { 0x5CBD, 0x6154 },
        { 0x5CBF, 0x509A },
        { 0x5CC1, 0x6159 },
        { 0x5CC4, 0x615B },
        { 0x5CCB, 0x615E },
        { 0x5CD2, 0x615C },
        { 0x5CD9, 0x5BC4 },
        { 0x5CE1, 0x585F },
        { 0x5CE4, 0x615D },
        { 0x5CE5, 0x615F },
        { 0x5CE6, 0x51CC },
        { 0x5CE8, 0x4BEA },
        { 0x5CEA, 0x5A99 },
        { 0x5CED, 0x546D },
        { 0x5CF0, 0x4C86 },
        { 0x5CFB, 0x4FFD },
        { 0x5D02, 0x6160 },
        { 0x5D03, 0x6161 },
        { 0x5D06, 0x6167 },
        { 0x5D07, 0x4A88 },
        { 0x5D0E, 0x53E8 },
        { 0x5D14, 0x4ADD },
        { 0x5D16, 0x5962 },
        { 0x5D1B, 0x6168 },
        { 0x5D1E, 0x6166 },
        { 0x5D24, 0x6165 },
        { 0x5D26, 0x6163 },
        { 0x5D27, 0x6162 },
        { 0x5D29, 0x4960 },
        { 0x5D2D, 0x5B58 },
        { 0x5D2E, 0x6164 },
        { 0x5D34, 0x616B },
        { 0x5D3D, 0x616C },
        { 0x5D3E, 0x616A },
        { 0x5D47, 0x689B },
        { 0x5D4A, 0x6173 },
        { 0x5D4B, 0x6172 },
        { 0x5D4C, 0x5456 },
        { 0x5D58, 0x6169 },
        { 0x5D5B, 0x616E },
        { 0x5D5D, 0x6170 },
        { 0x5D69, 0x6174 },
        { 0x5D6B, 0x6171 },
        { 0x5D6C, 0x616D },
        { 0x5D6F, 0x616F },
        { 0x5D74, 0x6175 },
        { 0x5D82, 0x6176 },
        { 0x5D99, 0x6177 },
        { 0x5D9D, 0x6178 },
        { 0x5DB7, 0x617A },
        { 0x5DC5, 0x617B },
        { 0x5DCD, 0x57A0 },
        { 0x5DDB, 0x647D },
        { 0x5DDD, 0x4AA7 },
        { 0x5DDE, 0x5BDC },
        { 0x5DE1, 0x5952 },
        { 0x5DE2, 0x4A52 },
        { 0x5DE5, 0x4D44 },
        { 0x5DE6, 0x5C94 },
        { 0x5DE7, 0x5469 },
        { 0x5DE8, 0x4FDD },
        { 0x5DE9, 0x4D4E },
        { 0x5DEB, 0x57D6 },
        { 0x5DEE, 0x49ED },
        { 0x5DEF, 0x5E6F },
        { 0x5DF1, 0x4EB9 },
        { 0x5DF2, 0x59D0 },
        { 0x5DF3, 0x5668 },
        { 0x5DF4, 0x48CC },
        { 0x5DF7, 0x5890 },
        { 0x5DFD, 0x5D84 },
        { 0x5DFE, 0x4F8E },
        { 0x5E01, 0x4972 },
        { 0x5E02, 0x55CF },
        { 0x5E03, 0x49BB },
        { 0x5E05, 0x5647 },
        { 0x5E06, 0x4C4B },
        { 0x5E08, 0x55A5 },
        { 0x5E0C, 0x5843 },
        { 0x5E0F, 0x60F7 },
        { 0x5E10, 0x5B6A },
        { 0x5E11, 0x60FA },
        { 0x5E14, 0x60F9 },
        { 0x5E15, 0x5361 },
        { 0x5E16, 0x56FA },
        { 0x5E18, 0x5151 },
        { 0x5E19, 0x60F8 },
        { 0x5E1A, 0x5BE2 },
        { 0x5E1B, 0x49AE },
        { 0x5E1C, 0x5BC3 },
        { 0x5E1D, 0x4B7B },
        { 0x5E26, 0x4AF7 },
        { 0x5E27, 0x5BA0 },
        { 0x5E2D, 0x584F },
        { 0x5E2E, 0x48EE },
        { 0x5E31, 0x60FB },
        { 0x5E37, 0x6141 },
        { 0x5E38, 0x4A43 },
        { 0x5E3B, 0x60FC },
        { 0x5E3C, 0x60FD },
        { 0x5E3D, 0x5251 },
        { 0x5E42, 0x527D },
        { 0x5E44, 0x6142 },
        { 0x5E45, 0x4C9A },
        { 0x5E4C, 0x4E6F },
        { 0x5E54, 0x6143 },
        { 0x5E55, 0x52BA },
        { 0x5E5B, 0x6144 },
        { 0x5E5E, 0x6145 },
        { 0x5E61, 0x6146 },
        { 0x5E62, 0x4AB0 },
        { 0x5E72, 0x4CC8 },
        { 0x5E73, 0x53BC },
        { 0x5E74, 0x52E9 },
        { 0x5E76, 0x49A1 },
        { 0x5E78, 0x58D1 },
        { 0x5E7A, 0x647B },
        { 0x5E7B, 0x4E63 },
        { 0x5E7C, 0x5A77 },
        { 0x5E7D, 0x5A64 },
        { 0x5E7F, 0x4D84 },
        { 0x5E80, 0x61CE },
        { 0x5E84, 0x5C4F },
        { 0x5E86, 0x548D },
        { 0x5E87, 0x4973 },
        { 0x5E8A, 0x4AB1 },
        { 0x5E8B, 0x61D0 },
        { 0x5E8F, 0x58F1 },
        { 0x5E90, 0x51AD },
        { 0x5E91, 0x61CF },
        { 0x5E93, 0x5083 },
        { 0x5E94, 0x5A46 },
        { 0x5E95, 0x4B77 },
        { 0x5E96, 0x61D1 },
        { 0x5E97, 0x4B8B },
        { 0x5E99, 0x528E },
        { 0x5E9A, 0x4CFC },
        { 0x5E9C, 0x4CAD },
        { 0x5E9E, 0x5373 },
        { 0x5E9F, 0x4C6F },
        { 0x5EA0, 0x61D3 },
        { 0x5EA5, 0x61D2 },
        { 0x5EA6, 0x4BC7 },
        { 0x5EA7, 0x5C9A },
        { 0x5EAD, 0x5745 },
        { 0x5EB3, 0x61D7 },
        { 0x5EB5, 0x61D5 },
        { 0x5EB6, 0x55FB },
        { 0x5EB7, 0x5055 },
        { 0x5EB8, 0x5A59 },
        { 0x5EB9, 0x61D4 },
        { 0x5EBE, 0x61D6 },
        { 0x5EC9, 0x514E },
        { 0x5ECA, 0x50C7 },
        { 0x5ED1, 0x61DA },
        { 0x5ED2, 0x61D9 },
        { 0x5ED3, 0x50A9 },
        { 0x5ED6, 0x516E },
        { 0x5EDB, 0x61DB },
        { 0x5EE8, 0x61DC },
        { 0x5EEA, 0x61DD },
        { 0x5EF4, 0x5E68 },
        { 0x5EF6, 0x5973 },
        { 0x5EF7, 0x5742 },
        { 0x5EFA, 0x4F48 },
        { 0x5EFE, 0x5FC2 },
        { 0x5EFF, 0x5CA4 },
        { 0x5F00, 0x504A },
        { 0x5F01, 0x5E6D },
        { 0x5F02, 0x59EB },
        { 0x5F03, 0x53F9 },
        { 0x5F04, 0x534A },
        { 0x5F08, 0x5FC3 },
        { 0x5F0A, 0x4977 },
        { 0x5F0B, 0x604E },
        { 0x5F0F, 0x55BC },
        { 0x5F11, 0x6051 },
        { 0x5F13, 0x4D4D },
        { 0x5F15, 0x59FC },
        { 0x5F17, 0x4CA4 },
        { 0x5F18, 0x4DEA },
        { 0x5F1B, 0x4A7A },
        { 0x5F1F, 0x4B7C },
        { 0x5F20, 0x5B65 },
        { 0x5F25, 0x5276 },
        { 0x5F26, 0x5872 },
        { 0x5F27, 0x4E41 },
        { 0x5F29, 0x6394 },
        { 0x5F2A, 0x6393 },
        { 0x5F2D, 0x6395 },
        { 0x5F2F, 0x5785 },
        { 0x5F31, 0x54F4 },
        { 0x5F39, 0x4B4F },
        { 0x5F3A, 0x545F },
        { 0x5F3C, 0x6397 },
        { 0x5F40, 0x66AF },
        { 0x5F50, 0x6387 },
        { 0x5F52, 0x4D8A },
        { 0x5F53, 0x4B51 },
        { 0x5F55, 0x51BB },
        { 0x5F56, 0x6389 },
        { 0x5F57, 0x6388 },
        { 0x5F58, 0x638A },
        { 0x5F5D, 0x59CC },
        { 0x5F61, 0x618B },
        { 0x5F62, 0x58CD },
        { 0x5F64, 0x574E },
        { 0x5F66, 0x5986 },
        { 0x5F69, 0x49C9 },
        { 0x5F6A, 0x498C },
        { 0x5F6C, 0x4993 },
        { 0x5F6D, 0x538E },
        { 0x5F70, 0x5B63 },
        { 0x5F71, 0x5A50 },
        { 0x5F73, 0x617C },
        { 0x5F77, 0x617D },
        { 0x5F79, 0x59DA },
        { 0x5F7B, 0x4A59 },
        { 0x5F7C, 0x496B },
        { 0x5F80, 0x579A },
        { 0x5F81, 0x5B98 },
        { 0x5F82, 0x617E },
        { 0x5F84, 0x4FB5 },
        { 0x5F85, 0x4AFC },
        { 0x5F87, 0x617F },
        { 0x5F88, 0x4DDB },
        { 0x5F89, 0x6181 },
        { 0x5F8A, 0x4E52 },
        { 0x5F8B, 0x51C8 },
        { 0x5F8C, 0x6182 },
        { 0x5F90, 0x58EB },
        { 0x5F92, 0x575D },
        { 0x5F95, 0x6183 },
        { 0x5F97, 0x4B63 },
        { 0x5F98, 0x5367 },
        { 0x5F99, 0x6184 },
        { 0x5F9C, 0x6185 },
        { 0x5FA1, 0x5A9A },
        { 0x5FA8, 0x6186 },
        { 0x5FAA, 0x594D },
        { 0x5FAD, 0x6187 },
        { 0x5FAE, 0x57A1 },
        { 0x5FB5, 0x6188 },
        { 0x5FB7, 0x4B62 },
        { 0x5FBC, 0x6189 },
        { 0x5FBD, 0x4E75 },
        { 0x5FC3, 0x58C3 },
        { 0x5FC4, 0x61DF },
        { 0x5FC5, 0x4978 },
        { 0x5FC6, 0x59E3 },
        { 0x5FC9, 0x61E0 },
        { 0x5FCC, 0x4EC8 },
        { 0x5FCD, 0x54CB },
        { 0x5FCF, 0x61E2 },
        { 0x5FD0, 0x66FD },
        { 0x5FD1, 0x66FC },
        { 0x5FD2, 0x604F },
        { 0x5FD6, 0x61E1 },
        { 0x5FD7, 0x5BBD },
        { 0x5FD8, 0x579D },
        { 0x5FD9, 0x5246 },
        { 0x5FDD, 0x6263 },
        { 0x5FE0, 0x5BD1 },
        { 0x5FE1, 0x61E6 },
        { 0x5FE4, 0x61E7 },
        { 0x5FE7, 0x5A67 },
        { 0x5FEA, 0x61EB },
        { 0x5FEB, 0x508D },
        { 0x5FED, 0x61EC },
        { 0x5FEE, 0x61E4 },
        { 0x5FF1, 0x4A60 },
        { 0x5FF5, 0x52ED },
        { 0x5FF8, 0x61ED },
        { 0x5FFB, 0x58C2 },
        { 0x5FFD, 0x4DF5 },
        { 0x5FFE, 0x61E8 },
        { 0x5FFF, 0x4C7E },
        { 0x6000, 0x4E53 },
        { 0x6001, 0x56AB },
        { 0x6002, 0x566B },
        { 0x6003, 0x61E3 },
        { 0x6004, 0x61E5 },
        { 0x6005, 0x61E9 },
        { 0x6006, 0x61EA },
        { 0x600A, 0x61F6 },
        { 0x600D, 0x61F3 },
        { 0x600E, 0x5AF4 },
        { 0x600F, 0x61F2 },
        { 0x6012, 0x534D },
        { 0x6014, 0x5B9B },
        { 0x6015, 0x5362 },
        { 0x6016, 0x49BF },
        { 0x6019, 0x61EE },
        { 0x601B, 0x61F1 },
        { 0x601C, 0x514F },
        { 0x601D, 0x565C },
        { 0x6020, 0x4B41 },
        { 0x6021, 0x61F8 },
        { 0x6025, 0x4EB0 },
        { 0x6026, 0x61F0 },
        { 0x6027, 0x58D3 },
        { 0x6028, 0x5AB8 },
        { 0x6029, 0x61F4 },
        { 0x602A, 0x4D76 },
        { 0x602B, 0x61F5 },
        { 0x602F, 0x5473 },
        { 0x6035, 0x61EF },
        { 0x603B, 0x5C7C },
        { 0x603C, 0x6741 },
        { 0x603F, 0x61F7 },
        { 0x6041, 0x6745 },
        { 0x6042, 0x61FD },
        { 0x6043, 0x55D0 },
        { 0x604B, 0x5155 },
        { 0x604D, 0x4E70 },
        { 0x6050, 0x5076 },
        { 0x6052, 0x4DE2 },
        { 0x6055, 0x5641 },
        { 0x6059, 0x6746 },
        { 0x605A, 0x6743 },
        { 0x605D, 0x6742 },
        { 0x6062, 0x4E76 },
        { 0x6063, 0x6747 },
        { 0x6064, 0x58F3 },
        { 0x6067, 0x6744 },
        { 0x6068, 0x4DDD },
        { 0x6069, 0x4BF6 },
        { 0x606A, 0x6241 },
        { 0x606B, 0x4BB1 },
        { 0x606C, 0x56F0 },
        { 0x606D, 0x4D47 },
        { 0x606F, 0x5842 },
        { 0x6070, 0x5441 },
        { 0x6073, 0x5072 },
        { 0x6076, 0x4BF0 },
        { 0x6078, 0x61F9 },
        { 0x6079, 0x61FA },
        { 0x607A, 0x61FC },
        { 0x607B, 0x61FB },
        { 0x607C, 0x52D4 },
        { 0x607D, 0x6242 },
        { 0x607F, 0x5A61 },
        { 0x6083, 0x6247 },
        { 0x6084, 0x5464 },
        { 0x6089, 0x5844 },
        { 0x608C, 0x6249 },
        { 0x608D, 0x4DB6 },
        { 0x6092, 0x6248 },
        { 0x6094, 0x4E7A },
        { 0x6096, 0x6243 },
        { 0x609A, 0x6244 },
        { 0x609B, 0x624A },
        { 0x609D, 0x6246 },
        { 0x609F, 0x57F1 },
        { 0x60A0, 0x5A66 },
        { 0x60A3, 0x4E5C },
        { 0x60A6, 0x5AC2 },
        { 0x60A8, 0x52F9 },
        { 0x60AB, 0x6748 },
        { 0x60AC, 0x58FB },
        { 0x60AD, 0x6245 },
        { 0x60AF, 0x5296 },
        { 0x60B1, 0x624D },
        { 0x60B2, 0x494F },
        { 0x60B4, 0x6252 },
        { 0x60B8, 0x4EC1 },
        { 0x60BB, 0x624C },
        { 0x60BC, 0x4B5F },
        { 0x60C5, 0x548A },
        { 0x60C6, 0x6250 },
        { 0x60CA, 0x4FA9 },
        { 0x60CB, 0x5790 },
        { 0x60D1, 0x4E94 },
        { 0x60D5, 0x56E7 },
        { 0x60D8, 0x624F },
        { 0x60DA, 0x6251 },
        { 0x60DC, 0x5847 },
        { 0x60DD, 0x624E },
        { 0x60DF, 0x57A8 },
        { 0x60E0, 0x4E7D },
        { 0x60E6, 0x4B8C },
        { 0x60E7, 0x4FE4 },
        { 0x60E8, 0x49D1 },
        { 0x60E9, 0x4A6D },
        { 0x60EB, 0x4959 },
        { 0x60EC, 0x624B },
        { 0x60ED, 0x49D0 },
        { 0x60EE, 0x4B4C },
        { 0x60EF, 0x4D7F },
        { 0x60F0, 0x4BE7 },
        { 0x60F3, 0x588C },
        { 0x60F4, 0x6257 },
        { 0x60F6, 0x4E6C },
        { 0x60F9, 0x54C6 },
        { 0x60FA, 0x58C9 },
        { 0x6100, 0x6258 },
        { 0x6101, 0x4A8F },
        { 0x6106, 0x6749 },
        { 0x6108, 0x5A9B },
        { 0x6109, 0x5A85 },
        { 0x610D, 0x674A },
        { 0x610E, 0x6259 },
        { 0x610F, 0x59E1 },
        { 0x6115, 0x6255 },
        { 0x611A, 0x5A7E },
        { 0x611F, 0x4CCF },
        { 0x6120, 0x6253 },
        { 0x6123, 0x6256 },
        { 0x6124, 0x4C7F },
        { 0x6126, 0x6254 },
        { 0x6127, 0x50A1 },
        { 0x612B, 0x625A },
        { 0x613F, 0x5AB7 },
        { 0x6148, 0x4AC7 },
        { 0x614A, 0x625B },
        { 0x614C, 0x4E65 },
        { 0x614E, 0x5598 },
        { 0x6151, 0x5586 },
        { 0x6155, 0x52BC },
        { 0x615D, 0x674B },
        { 0x6162, 0x51FC },
        { 0x6167, 0x4E7B },
        { 0x6168, 0x504E },
        { 0x6170, 0x57BE },
        { 0x6175, 0x625C },
        { 0x6177, 0x5056 },
        { 0x618B, 0x4990 },
        { 0x618E, 0x5AF6 },
        { 0x6194, 0x625E },
        { 0x619D, 0x674D },
        { 0x61A7, 0x625F },
        { 0x61A8, 0x4DA8 },
        { 0x61A9, 0x674C },
        { 0x61AC, 0x625D },
        { 0x61B7, 0x6260 },
        { 0x61BE, 0x4DB5 },
        { 0x61C2, 0x4BAD },
        { 0x61C8, 0x58B7 },
        { 0x61CA, 0x48C2 },
        { 0x61CB, 0x674E },
        { 0x61D1, 0x674F },
        { 0x61D2, 0x50C0 },
        { 0x61D4, 0x6261 },
        { 0x61E6, 0x5353 },
        { 0x61F5, 0x6262 },
        { 0x61FF, 0x5EB1 },
        { 0x6206, 0x6750 },
        { 0x6208, 0x4CE9 },
        { 0x620A, 0x57EB },
        { 0x620B, 0x65A6 },
        { 0x620C, 0x58E6 },
        { 0x620D, 0x55F8 },
        { 0x620E, 0x54D5 },
        { 0x620F, 0x5857 },
        { 0x6210, 0x4A69 },
        { 0x6211, 0x57D1 },
        { 0x6212, 0x4F85 },
        { 0x6215, 0x627E },
        { 0x6216, 0x4E93 },
        { 0x6217, 0x65A7 },
        { 0x6218, 0x5B5D },
        { 0x621A, 0x53DC },
        { 0x621B, 0x65A8 },
        { 0x621F, 0x65A9 },
        { 0x6221, 0x65AB },
        { 0x6222, 0x65AA },
        { 0x6224, 0x65AD },
        { 0x6225, 0x65AC },
        { 0x622A, 0x4F78 },
        { 0x622C, 0x65AE },
        { 0x622E, 0x51BD },
        { 0x6233, 0x4AC0 },
        { 0x6234, 0x4AF6 },
        { 0x6237, 0x4E47 },
        { 0x623D, 0x66E5 },
        { 0x623E, 0x66E4 },
        { 0x623F, 0x4C5F },
        { 0x6240, 0x569A },
        { 0x6241, 0x4983 },
        { 0x6243, 0x66E6 },
        { 0x6247, 0x5568 },
        { 0x6248, 0x66E7 },
        { 0x6249, 0x66E8 },
        { 0x624B, 0x55D5 },
        { 0x624C, 0x5FCF },
        { 0x624D, 0x49C4 },
        { 0x624E, 0x5AF9 },
        { 0x6251, 0x53CA },
        { 0x6252, 0x48C6 },
        { 0x6253, 0x4AF1 },
        { 0x6254, 0x54D2 },
        { 0x6258, 0x5770 },
        { 0x625B, 0x5058 },
        { 0x6263, 0x507B },
        { 0x6266, 0x5444 },
        { 0x6267, 0x5BB3 },
        { 0x6269, 0x50A8 },
        { 0x626A, 0x5FD0 },
        { 0x626B, 0x5548 },
        { 0x626C, 0x5990 },
        { 0x626D, 0x5344 },
        { 0x626E, 0x48E6 },
        { 0x626F, 0x4A56 },
        { 0x6270, 0x54C4 },
        { 0x6273, 0x48E1 },
        { 0x6276, 0x4C97 },
        { 0x6279, 0x539B },
        { 0x627C, 0x4BF2 },
        { 0x627E, 0x5B72 },
        { 0x627F, 0x4A70 },
        { 0x6280, 0x4EBB },
        { 0x6284, 0x4A4D },
        { 0x6289, 0x4FF0 },
        { 0x628A, 0x48D0 },
        { 0x6291, 0x59D5 },
        { 0x6292, 0x55E2 },
        { 0x6293, 0x5C45 },
        { 0x6295, 0x5756 },
        { 0x6296, 0x4BB5 },
        { 0x6297, 0x5059 },
        { 0x6298, 0x5B7B },
        { 0x629A, 0x4CA6 },
        { 0x629B, 0x5377 },
        { 0x629F, 0x5FD1 },
        { 0x62A0, 0x5079 },
        { 0x62A1, 0x51D4 },
        { 0x62A2, 0x5460 },
        { 0x62A4, 0x4E44 },
        { 0x62A5, 0x4948 },
        { 0x62A8, 0x538B },
        { 0x62AB, 0x539C },
        { 0x62AC, 0x56A6 },
        { 0x62B1, 0x4947 },
        { 0x62B5, 0x4B76 },
        { 0x62B9, 0x52A7 },
        { 0x62BB, 0x5FD2 },
        { 0x62BC, 0x595A },
        { 0x62BD, 0x4A8A },
        { 0x62BF, 0x5293 },
        { 0x62C2, 0x4C98 },
        { 0x62C4, 0x5BF3 },
        { 0x62C5, 0x4B43 },
        { 0x62C6, 0x49EF },
        { 0x62C7, 0x52B3 },
        { 0x62C8, 0x52E8 },
        { 0x62C9, 0x50AC },
        { 0x62CA, 0x5FD3 },
        { 0x62CC, 0x48E7 },
        { 0x62CD, 0x5364 },
        { 0x62CE, 0x5181 },
        { 0x62D0, 0x4D75 },
        { 0x62D2, 0x4FDB },
        { 0x62D3, 0x5778 },
        { 0x62D4, 0x48CD },
        { 0x62D6, 0x576F },
        { 0x62D7, 0x5FD5 },
        { 0x62D8, 0x4FCF },
        { 0x62D9, 0x5C5E },
        { 0x62DA, 0x5FD4 },
        { 0x62DB, 0x5B70 },
        { 0x62DC, 0x48DC },
        { 0x62DF, 0x52E1 },
        { 0x62E2, 0x51A2 },
        { 0x62E3, 0x4EEF },
        { 0x62E5, 0x5A55 },
        { 0x62E6, 0x50B8 },
        { 0x62E7, 0x5341 },
        { 0x62E8, 0x49A5 },
        { 0x62E9, 0x5AF0 },
        { 0x62EC, 0x50A7 },
        { 0x62ED, 0x55C2 },
        { 0x62EE, 0x5FD6 },
        { 0x62EF, 0x5B9D },
        { 0x62F1, 0x4D50 },
        { 0x62F3, 0x54AC },
        { 0x62F4, 0x5649 },
        { 0x62F6, 0x5FD8 },
        { 0x62F7, 0x505D },
        { 0x62FC, 0x53B3 },
        { 0x62FD, 0x5C47 },
        { 0x62FE, 0x55AF },
        { 0x62FF, 0x52C2 },
        { 0x6301, 0x4A76 },
        { 0x6302, 0x4D72 },
        { 0x6307, 0x5BB7 },
        { 0x6308, 0x65FB },
        { 0x6309, 0x48B3 },
        { 0x630E, 0x5087 },
        { 0x6311, 0x56F3 },
        { 0x6316, 0x577A },
        { 0x631A, 0x5BBE },
        { 0x631B, 0x51CD },
        { 0x631D, 0x57CD },
        { 0x631E, 0x56A1 },
        { 0x631F, 0x58AD },
        { 0x6320, 0x52D2 },
        { 0x6321, 0x4B52 },
        { 0x6322, 0x5FD7 },
        { 0x6323, 0x5B96 },
        { 0x6324, 0x4EB6 },
        { 0x6325, 0x4E73 },
        { 0x6328, 0x48A3 },
        { 0x632A, 0x5352 },
        { 0x632B, 0x4AEB },
        { 0x632F, 0x5B92 },
        { 0x6332, 0x65FC },
        { 0x6339, 0x5FD9 },
        { 0x633A, 0x5746 },
        { 0x633D, 0x578D },
        { 0x6342, 0x57E5 },
        { 0x6343, 0x5FDB },
        { 0x6345, 0x5751 },
        { 0x6346, 0x50A5 },
        { 0x6349, 0x5C5D },
        { 0x634B, 0x5FDA },
        { 0x634C, 0x48C5 },
        { 0x634D, 0x4DB3 },
        { 0x634E, 0x5573 },
        { 0x634F, 0x52F2 },
        { 0x6350, 0x4FE7 },
        { 0x6355, 0x49B5 },
        { 0x635E, 0x50CB },
        { 0x635F, 0x5691 },
        { 0x6361, 0x4EF0 },
        { 0x6362, 0x4E5B },
        { 0x6363, 0x4B57 },
        { 0x6367, 0x5396 },
        { 0x6369, 0x5FE5 },
        { 0x636D, 0x5FE2 },
        { 0x636E, 0x4FDC },
        { 0x6371, 0x5FDE },
        { 0x6376, 0x4AB6 },
        { 0x6377, 0x4F7D },
        { 0x637A, 0x5FDF },
        { 0x637B, 0x52EC },
        { 0x6380, 0x5866 },
        { 0x6382, 0x4B81 },
        { 0x6387, 0x4BDD },
        { 0x6388, 0x55D9 },
        { 0x6389, 0x4B95 },
        { 0x638A, 0x5FE4 },
        { 0x638C, 0x5B66 },
        { 0x638E, 0x5FE0 },
        { 0x638F, 0x56CC },
        { 0x6390, 0x53FD },
        { 0x6392, 0x5365 },
        { 0x6396, 0x59B3 },
        { 0x6398, 0x4FF1 },
        { 0x63A0, 0x51D2 },
        { 0x63A2, 0x56BC },
        { 0x63A3, 0x4A58 },
        { 0x63A5, 0x4F73 },
        { 0x63A7, 0x5078 },
        { 0x63A8, 0x5766 },
        { 0x63A9, 0x597A },
        { 0x63AA, 0x4AEA },
        { 0x63AC, 0x5FE3 },
        { 0x63AD, 0x5FDC },
        { 0x63AE, 0x5FE6 },
        { 0x63B0, 0x65FD },
        { 0x63B3, 0x51AF },
        { 0x63B4, 0x5FE1 },
        { 0x63B7, 0x5BBF },
        { 0x63B8, 0x4B47 },
        { 0x63BA, 0x49F3 },
        { 0x63BC, 0x5FE7 },
        { 0x63BE, 0x5FF1 },
        { 0x63C4, 0x5FEC },
        { 0x63C6, 0x5FF0 },
        { 0x63C9, 0x54DF },
        { 0x63CD, 0x5C82 },
        { 0x63CE, 0x5FEE },
        { 0x63CF, 0x5289 },
        { 0x63D0, 0x56E0 },
        { 0x63D2, 0x49E4 },
        { 0x63D6, 0x59BD },
        { 0x63DE, 0x5FED },
        { 0x63E0, 0x5FEA },
        { 0x63E1, 0x57D4 },
        { 0x63E3, 0x4AA6 },
        { 0x63E9, 0x504B },
        { 0x63EA, 0x4FBD },
        { 0x63ED, 0x4F72 },
        { 0x63F2, 0x5FE8 },
        { 0x63F4, 0x5AAD },
        { 0x63F6, 0x5FDD },
        { 0x63F8, 0x5FE9 },
        { 0x63FD, 0x50BE },
        { 0x63FF, 0x5FEB },
        { 0x6400, 0x49F2 },
        { 0x6401, 0x4CE8 },
        { 0x6402, 0x51A6 },
        { 0x6405, 0x4F61 },
        { 0x640B, 0x5FF4 },
        { 0x640C, 0x5FF7 },
        { 0x640F, 0x49AA },
        { 0x6410, 0x4AA3 },
        { 0x6413, 0x4AE9 },
        { 0x6414, 0x5546 },
        { 0x641B, 0x5FF5 },
        { 0x641C, 0x5671 },
        { 0x641E, 0x4CE2 },
        { 0x6420, 0x5FF6 },
        { 0x6421, 0x5FF9 },
        { 0x6426, 0x5FF8 },
        { 0x642A, 0x56C1 },
        { 0x642C, 0x48E0 },
        { 0x642D, 0x4AED },
        { 0x6434, 0x635A },
        { 0x643A, 0x58AE },
        { 0x643D, 0x49EA },
        { 0x643F, 0x6641 },
        { 0x6441, 0x5FF3 },
        { 0x6444, 0x5584 },
        { 0x6445, 0x5FF2 },
        { 0x6446, 0x48D9 },
        { 0x6447, 0x59A0 },
        { 0x6448, 0x4998 },
        { 0x644A, 0x56AE },
        { 0x6452, 0x5FEF },
        { 0x6454, 0x5644 },
        { 0x6458, 0x5B4A },
        { 0x645E, 0x5FFA },
        { 0x6467, 0x4ADC },
        { 0x6469, 0x52A5 },
        { 0x646D, 0x5FFC },
        { 0x6478, 0x529F },
        { 0x6479, 0x52A0 },
        { 0x647A, 0x6041 },
        { 0x6482, 0x516C },
        { 0x6484, 0x5FFB },
        { 0x6485, 0x4FEE },
        { 0x6487, 0x53B1 },
        { 0x6491, 0x4A65 },
        { 0x6492, 0x54F5 },
        { 0x6495, 0x565A },
        { 0x6496, 0x5FFD },
        { 0x6499, 0x6044 },
        { 0x649E, 0x5C52 },
        { 0x64A4, 0x4A57 },
        { 0x64A9, 0x5163 },
        { 0x64AC, 0x546B },
        { 0x64AD, 0x49A4 },
        { 0x64AE, 0x4AE8 },
        { 0x64B0, 0x5C4B },
        { 0x64B5, 0x52EB },
        { 0x64B7, 0x6042 },
        { 0x64B8, 0x6043 },
        { 0x64BA, 0x6045 },
        { 0x64BC, 0x4DB2 },
        { 0x64C0, 0x6046 },
        { 0x64C2, 0x50DD },
        { 0x64C5, 0x5563 },
        { 0x64CD, 0x49D8 },
        { 0x64CE, 0x5487 },
        { 0x64D0, 0x6047 },
        { 0x64D2, 0x547C },
        { 0x64D7, 0x6048 },
        { 0x64D8, 0x6642 },
        { 0x64DE, 0x5673 },
        { 0x64E2, 0x604A },
        { 0x64E4, 0x6049 },
        { 0x64E6, 0x49C0 },
        { 0x6500, 0x536A },
        { 0x6509, 0x604B },
        { 0x6512, 0x5ADB },
        { 0x6518, 0x54C0 },
        { 0x6525, 0x604C },
        { 0x652B, 0x4FEF },
        { 0x652E, 0x604D },
        { 0x652F, 0x5BA6 },
        { 0x6534, 0x65B6 },
        { 0x6535, 0x6656 },
        { 0x6536, 0x55D4 },
        { 0x6538, 0x5CFB },
        { 0x6539, 0x4CC3 },
        { 0x653B, 0x4D45 },
        { 0x653E, 0x4C65 },
        { 0x653F, 0x5B9F },
        { 0x6545, 0x4D6A },
        { 0x6548, 0x58A6 },
        { 0x6549, 0x6ACC },
        { 0x654C, 0x4B70 },
        { 0x654F, 0x5295 },
        { 0x6551, 0x4FC7 },
        { 0x6555, 0x6657 },
        { 0x6556, 0x48BC },
        { 0x6559, 0x4F6C },
        { 0x655B, 0x5152 },
        { 0x655D, 0x4976 },
        { 0x655E, 0x4A48 },
        { 0x6562, 0x4CD1 },
        { 0x6563, 0x5542 },
        { 0x6566, 0x4BD7 },
        { 0x656B, 0x6658 },
        { 0x656C, 0x4FB3 },
        { 0x6570, 0x55FC },
        { 0x6572, 0x5463 },
        { 0x6574, 0x5B9C },
        { 0x6577, 0x4C94 },
        { 0x6587, 0x57C3 },
        { 0x658B, 0x5B4B },
        { 0x658C, 0x4994 },
        { 0x6590, 0x66B2 },
        { 0x6591, 0x48DE },
        { 0x6593, 0x66B4 },
        { 0x6597, 0x4BB6 },
        { 0x6599, 0x516F },
        { 0x659B, 0x6B9B },
        { 0x659C, 0x58B0 },
        { 0x659F, 0x5B86 },
        { 0x65A1, 0x57D2 },
        { 0x65A4, 0x4F90 },
        { 0x65A5, 0x4A83 },
        { 0x65A7, 0x4CAA },
        { 0x65A9, 0x5B56 },
        { 0x65AB, 0x675D },
        { 0x65AD, 0x4BCE },
        { 0x65AF, 0x5659 },
        { 0x65B0, 0x58C1 },
        { 0x65B9, 0x4C5D },
        { 0x65BC, 0x66B5 },
        { 0x65BD, 0x55A8 },
        { 0x65C1, 0x5374 },
        { 0x65C3, 0x66B8 },
        { 0x65C4, 0x66B7 },
        { 0x65C5, 0x51C2 },
        { 0x65C6, 0x66B6 },
        { 0x65CB, 0x58FC },
        { 0x65CC, 0x66B9 },
        { 0x65CE, 0x66BA },
        { 0x65CF, 0x5C86 },
        { 0x65D2, 0x66BB },
        { 0x65D6, 0x66BC },
        { 0x65D7, 0x53EB },
        { 0x65E0, 0x57DD },
        { 0x65E2, 0x4EC7 },
        { 0x65E5, 0x54D4 },
        { 0x65E6, 0x4B49 },
        { 0x65E7, 0x4FC8 },
        { 0x65E8, 0x5BBB },
        { 0x65E9, 0x5AE6 },
        { 0x65EC, 0x594E },
        { 0x65ED, 0x58F0 },
        { 0x65EE, 0x65B7 },
        { 0x65EF, 0x65B8 },
        { 0x65F0, 0x65B9 },
        { 0x65F1, 0x4DB4 },
        { 0x65F6, 0x55B0 },
        { 0x65F7, 0x5096 },
        { 0x65FA, 0x579B },
        { 0x6600, 0x65BF },
        { 0x6602, 0x48B9 },
        { 0x6603, 0x65BD },
        { 0x6606, 0x50A4 },
        { 0x660A, 0x65BA },
        { 0x660C, 0x49FC },
        { 0x660E, 0x5298 },
        { 0x660F, 0x4E89 },
        { 0x6613, 0x59D6 },
        { 0x6614, 0x57F3 },
        { 0x6615, 0x65BE },
        { 0x6619, 0x65BB },
        { 0x661D, 0x65C2 },
        { 0x661F, 0x58C6 },
        { 0x6620, 0x5A53 },
        { 0x6625, 0x4AB9 },
        { 0x6627, 0x5261 },
        { 0x6628, 0x5C93 },
        { 0x662D, 0x5B71 },
        { 0x662F, 0x55C6 },
        { 0x6631, 0x65C4 },
        { 0x6634, 0x65C3 },
        { 0x6635, 0x65C6 },
        { 0x6636, 0x65C5 },
        { 0x663C, 0x5BE6 },
        { 0x663E, 0x5874 },
        { 0x6641, 0x65CA },
        { 0x6643, 0x4E6E },
        { 0x664B, 0x4F9B },
        { 0x664C, 0x556E },
        { 0x664F, 0x65CB },
        { 0x6652, 0x5559 },
        { 0x6653, 0x589F },
        { 0x6654, 0x65C9 },
        { 0x6655, 0x5ACD },
        { 0x6656, 0x65CC },
        { 0x6657, 0x65CE },
        { 0x665A, 0x578E },
        { 0x665F, 0x65C8 },
        { 0x6661, 0x65CD },
        { 0x6664, 0x57ED },
        { 0x6666, 0x4E7E },
        { 0x6668, 0x4A5F },
        { 0x666E, 0x53D4 },
        { 0x666F, 0x4FAF },
        { 0x6670, 0x57F9 },
        { 0x6674, 0x5488 },
        { 0x6676, 0x4FA6 },
        { 0x6677, 0x65CF },
        { 0x667A, 0x5BC6 },
        { 0x667E, 0x5160 },
        { 0x6682, 0x5ADC },
        { 0x6684, 0x65D0 },
        { 0x6687, 0x585E },
        { 0x668C, 0x65D1 },
        { 0x6691, 0x55ED },
        { 0x6696, 0x534F },
        { 0x6697, 0x48B4 },
        { 0x669D, 0x65D3 },
        { 0x66A7, 0x65D2 },
        { 0x66A8, 0x6ADE },
        { 0x66AE, 0x52B9 },
        { 0x66B4, 0x4949 },
        { 0x66B9, 0x637F },
        { 0x66BE, 0x65D4 },
        { 0x66D9, 0x55EE },
        { 0x66DB, 0x65D5 },
        { 0x66DC, 0x65D6 },
        { 0x66DD, 0x53D7 },
        { 0x66E6, 0x65D7 },
        { 0x66E9, 0x65D8 },
        { 0x66F0, 0x5ABA },
        { 0x66F2, 0x549B },
        { 0x66F3, 0x59B6 },
        { 0x66F4, 0x4CFB },
        { 0x66F7, 0x65C1 },
        { 0x66F9, 0x49DB },
        { 0x66FC, 0x51FB },
        { 0x66FE, 0x5AF7 },
        { 0x66FF, 0x56E5 },
        { 0x6700, 0x5C8F },
        { 0x6708, 0x5AC1 },
        { 0x6709, 0x5A70 },
        { 0x670A, 0x6663 },
        { 0x670B, 0x5394 },
        { 0x670D, 0x4C9F },
        { 0x6710, 0x6674 },
        { 0x6714, 0x5657 },
        { 0x6715, 0x667E },
        { 0x6717, 0x50C9 },
        { 0x671B, 0x579C },
        { 0x671D, 0x4A4F },
        { 0x671F, 0x53D9 },
        { 0x6726, 0x669D },
        { 0x6728, 0x52BD },
        { 0x672A, 0x57B3 },
        { 0x672B, 0x52A8 },
        { 0x672C, 0x495E },
        { 0x672D, 0x5AFC },
        { 0x672F, 0x55F4 },
        { 0x6731, 0x5BEB },
        { 0x6734, 0x53D2 },
        { 0x6735, 0x4BE3 },
        { 0x673A, 0x4E9B },
        { 0x673D, 0x58DF },
        { 0x6740, 0x5551 },
        { 0x6742, 0x5AD2 },
        { 0x6743, 0x54A7 },
        { 0x6746, 0x4CCA },
        { 0x6748, 0x64BD },
        { 0x6749, 0x555C },
        { 0x674C, 0x64BA },
        { 0x674E, 0x50ED },
        { 0x674F, 0x58D2 },
        { 0x6750, 0x49C3 },
        { 0x6751, 0x4AE4 },
        { 0x6753, 0x64BB },
        { 0x6756, 0x5B68 },
        { 0x675C, 0x4BC4 },
        { 0x675E, 0x64BC },
        { 0x675F, 0x55F7 },
        { 0x6760, 0x4CDB },
        { 0x6761, 0x56F4 },
        { 0x6765, 0x50B3 },
        { 0x6768, 0x598F },
        { 0x6769, 0x64BE },
        { 0x676A, 0x64C1 },
        { 0x676D, 0x4DBB },
        { 0x676F, 0x494D },
        { 0x6770, 0x4F7C },
        { 0x6772, 0x65BC },
        { 0x6773, 0x64C2 },
        { 0x6775, 0x64C5 },
        { 0x6777, 0x64CA },
        { 0x677C, 0x64CB },
        { 0x677E, 0x5669 },
        { 0x677F, 0x48E4 },
        { 0x6781, 0x4EAA },
        { 0x6784, 0x4D59 },
        { 0x6787, 0x64C0 },
        { 0x6789, 0x5798 },
        { 0x678B, 0x64C9 },
        { 0x6790, 0x57F5 },
        { 0x6795, 0x5B8E },
        { 0x6797, 0x5176 },
        { 0x6798, 0x64C3 },
        { 0x679A, 0x5256 },
        { 0x679C, 0x4D9C },
        { 0x679D, 0x5BA5 },
        { 0x679E, 0x64C7 },
        { 0x67A2, 0x55DF },
        { 0x67A3, 0x5AE5 },
        { 0x67A5, 0x64BF },
        { 0x67A7, 0x64C4 },
        { 0x67A8, 0x64C6 },
        { 0x67AA, 0x5459 },
        { 0x67AB, 0x4C84 },
        { 0x67AD, 0x64C8 },
        { 0x67AF, 0x507D },
        { 0x67B0, 0x64D1 },
        { 0x67B3, 0x64D6 },
        { 0x67B5, 0x64D4 },
        { 0x67B6, 0x4EDB },
        { 0x67B7, 0x4ECE },
        { 0x67B8, 0x64DA },
        { 0x67C1, 0x64DD },
        { 0x67C3, 0x64D9 },
        { 0x67C4, 0x499B },
        { 0x67CF, 0x48D7 },
        { 0x67D0, 0x52B2 },
        { 0x67D1, 0x4CCB },
        { 0x67D2, 0x53E1 },
        { 0x67D3, 0x54BD },
        { 0x67D4, 0x54E0 },
        { 0x67D8, 0x64CE },
        { 0x67D9, 0x64D3 },
        { 0x67DA, 0x64D5 },
        { 0x67DC, 0x4D92 },
        { 0x67DD, 0x64D7 },
        { 0x67DE, 0x5C96 },
        { 0x67E0, 0x52FA },
        { 0x67E2, 0x64DB },
        { 0x67E5, 0x49E8 },
        { 0x67E9, 0x64D0 },
        { 0x67EC, 0x4EEC },
        { 0x67EF, 0x5062 },
        { 0x67F0, 0x64CC },
        { 0x67F1, 0x5BF8 },
        { 0x67F3, 0x5199 },
        { 0x67F4, 0x49F0 },
        { 0x67FD, 0x64DE },
        { 0x67FF, 0x55C0 },
        { 0x6800, 0x64D8 },
        { 0x6805, 0x5B44 },
        { 0x6807, 0x498B },
        { 0x6808, 0x5B5B },
        { 0x6809, 0x64CD },
        { 0x680A, 0x64CF },
        { 0x680B, 0x4BAF },
        { 0x680C, 0x64D2 },
        { 0x680E, 0x64DC },
        { 0x680F, 0x50B7 },
        { 0x6811, 0x55F6 },
        { 0x6813, 0x5648 },
        { 0x6816, 0x53DB },
        { 0x6817, 0x50F4 },
        { 0x681D, 0x64E8 },
        { 0x6821, 0x58A2 },
        { 0x6829, 0x64F1 },
        { 0x682A, 0x5BE9 },
        { 0x6832, 0x64DF },
        { 0x6833, 0x64E0 },
        { 0x6837, 0x599A },
        { 0x6838, 0x4DCA },
        { 0x6839, 0x4CF8 },
        { 0x683C, 0x4CF0 },
        { 0x683D, 0x5AD3 },
        { 0x683E, 0x64EE },
        { 0x6840, 0x64ED },
        { 0x6841, 0x64EB },
        { 0x6842, 0x4D91 },
        { 0x6843, 0x56D1 },
        { 0x6844, 0x64E5 },
        { 0x6845, 0x57A5 },
        { 0x6846, 0x5093 },
        { 0x6848, 0x48B7 },
        { 0x6849, 0x64F0 },
        { 0x684A, 0x64EF },
        { 0x684C, 0x5C60 },
        { 0x684E, 0x64E3 },
        { 0x6850, 0x5749 },
        { 0x6851, 0x5543 },
        { 0x6853, 0x4E58 },
        { 0x6854, 0x4F7B },
        { 0x6855, 0x64E9 },
        { 0x6860, 0x64E1 },
        { 0x6861, 0x64E2 },
        { 0x6862, 0x64E4 },
        { 0x6863, 0x4B55 },
        { 0x6864, 0x64E6 },
        { 0x6865, 0x5465 },
        { 0x6866, 0x64EA },
        { 0x6867, 0x64EC },
        { 0x6868, 0x4F50 },
        { 0x6869, 0x5C4E },
        { 0x686B, 0x64F7 },
        { 0x6874, 0x64F4 },
        { 0x6876, 0x5750 },
        { 0x6877, 0x64F5 },
        { 0x6881, 0x515A },
        { 0x6883, 0x64E7 },
        { 0x6885, 0x5257 },
        { 0x6886, 0x48EF },
        { 0x688F, 0x64F3 },
        { 0x6893, 0x64F6 },
        { 0x6897, 0x4D43 },
        { 0x68A2, 0x5572 },
        { 0x68A6, 0x526E },
        { 0x68A7, 0x57DF },
        { 0x68A8, 0x50E5 },
        { 0x68AD, 0x5694 },
        { 0x68AF, 0x56DC },
        { 0x68B0, 0x58B4 },
        { 0x68B3, 0x55E0 },
        { 0x68B5, 0x64F2 },
        { 0x68C0, 0x4EEB },
        { 0x68C2, 0x64F8 },
        { 0x68C9, 0x527E },
        { 0x68CB, 0x53E4 },
        { 0x68CD, 0x4D98 },
        { 0x68D2, 0x48F3 },
        { 0x68D5, 0x5C78 },
        { 0x68D8, 0x4EAB },
        { 0x68DA, 0x5390 },
        { 0x68E0, 0x56C3 },
        { 0x68E3, 0x6546 },
        { 0x68EE, 0x554D },
        { 0x68F0, 0x6542 },
        { 0x68F1, 0x50E1 },
        { 0x68F5, 0x5063 },
        { 0x68F9, 0x64FD },
        { 0x68FA, 0x4D77 },
        { 0x68FC, 0x64FA },
        { 0x6901, 0x6544 },
        { 0x6905, 0x59CD },
        { 0x690B, 0x6543 },
        { 0x690D, 0x5BB1 },
        { 0x690E, 0x5C55 },
        { 0x6910, 0x6547 },
        { 0x6912, 0x4F57 },
        { 0x691F, 0x64FB },
        { 0x6920, 0x64FC },
        { 0x6924, 0x6541 },
        { 0x692D, 0x5776 },
        { 0x6930, 0x59AB },
        { 0x6934, 0x6552 },
        { 0x6939, 0x6549 },
        { 0x693D, 0x4AA9 },
        { 0x693F, 0x4ABA },
        { 0x6942, 0x654B },
        { 0x6954, 0x58A7 },
        { 0x6957, 0x6545 },
        { 0x695A, 0x4A9F },
        { 0x695D, 0x654C },
        { 0x695E, 0x50E2 },
        { 0x6960, 0x654A },
        { 0x6963, 0x6559 },
        { 0x6966, 0x6558 },
        { 0x696B, 0x654E },
        { 0x696E, 0x64F9 },
        { 0x6971, 0x6548 },
        { 0x6977, 0x504C },
        { 0x6978, 0x6551 },
        { 0x6979, 0x655A },
        { 0x697C, 0x51A4 },
        { 0x6980, 0x654F },
        { 0x6982, 0x4CC4 },
        { 0x6984, 0x654D },
        { 0x6986, 0x5A7C },
        { 0x6987, 0x6554 },
        { 0x6988, 0x6555 },
        { 0x6989, 0x6557 },
        { 0x698D, 0x6567 },
        { 0x6994, 0x50C5 },
        { 0x6995, 0x6565 },
        { 0x6998, 0x6550 },
        { 0x699B, 0x655B },
        { 0x699C, 0x48F0 },
        { 0x69A7, 0x655C },
        { 0x69A8, 0x5B45 },
        { 0x69AB, 0x655E },
        { 0x69AD, 0x655F },
        { 0x69B1, 0x6561 },
        { 0x69B4, 0x5192 },
        { 0x69B7, 0x54B5 },
        { 0x69BB, 0x655D },
        { 0x69C1, 0x6562 },
        { 0x69CA, 0x6563 },
        { 0x69CC, 0x6553 },
        { 0x69CE, 0x6556 },
        { 0x69D0, 0x4E51 },
        { 0x69D4, 0x6560 },
        { 0x69DB, 0x4EF6 },
        { 0x69DF, 0x6564 },
        { 0x69E0, 0x6566 },
        { 0x69ED, 0x656A },
        { 0x69F2, 0x656E },
        { 0x69FD, 0x49DA },
        { 0x69FF, 0x6568 },
        { 0x6A0A, 0x4C4E },
        { 0x6A17, 0x656B },
        { 0x6A18, 0x656C },
        { 0x6A1F, 0x5B61 },
        { 0x6A21, 0x52A2 },
        { 0x6A28, 0x6578 },
        { 0x6A2A, 0x4DE0 },
        { 0x6A2F, 0x6569 },
        { 0x6A31, 0x5A43 },
        { 0x6A35, 0x6574 },
        { 0x6A3D, 0x6577 },
        { 0x6A3E, 0x6570 },
        { 0x6A44, 0x656F },
        { 0x6A47, 0x5461 },
        { 0x6A50, 0x6572 },
        { 0x6A58, 0x6579 },
        { 0x6A59, 0x4A68 },
        { 0x6A5B, 0x6573 },
        { 0x6A61, 0x5891 },
        { 0x6A65, 0x656D },
        { 0x6A71, 0x4A98 },
        { 0x6A79, 0x6576 },
        { 0x6A7C, 0x657A },
        { 0x6A80, 0x56B3 },
        { 0x6A84, 0x584D },
        { 0x6A8E, 0x6575 },
        { 0x6A90, 0x657C },
        { 0x6A91, 0x657B },
        { 0x6A97, 0x657E },
        { 0x6AA0, 0x6571 },
        { 0x6AA9, 0x657D },
        { 0x6AAB, 0x657F },
        { 0x6AAC, 0x526A },
        { 0x6B20, 0x5457 },
        { 0x6B21, 0x4ACD },
        { 0x6B22, 0x4E56 },
        { 0x6B23, 0x58BF },
        { 0x6B24, 0x66A2 },
        { 0x6B27, 0x5357 },
        { 0x6B32, 0x5A9C },
        { 0x6B37, 0x66A3 },
        { 0x6B39, 0x66A4 },
        { 0x6B3A, 0x53DA },
        { 0x6B3E, 0x508F },
        { 0x6B43, 0x66A5 },
        { 0x6B46, 0x66A6 },
        { 0x6B47, 0x58A9 },
        { 0x6B49, 0x5458 },
        { 0x6B4C, 0x4CE7 },
        { 0x6B59, 0x66A7 },
        { 0x6B62, 0x5BB8 },
        { 0x6B63, 0x5B9E },
        { 0x6B64, 0x4ACA },
        { 0x6B65, 0x49BC },
        { 0x6B66, 0x57E3 },
        { 0x6B67, 0x53E6 },
        { 0x6B6A, 0x5782 },
        { 0x6B79, 0x4AF4 },
        { 0x6B7B, 0x5660 },
        { 0x6B7C, 0x4EDE },
        { 0x6B81, 0x6583 },
        { 0x6B82, 0x6584 },
        { 0x6B83, 0x598B },
        { 0x6B84, 0x6586 },
        { 0x6B86, 0x4AF8 },
        { 0x6B87, 0x6585 },
        { 0x6B89, 0x5953 },
        { 0x6B8A, 0x55E1 },
        { 0x6B8B, 0x49CF },
        { 0x6B8D, 0x6589 },
        { 0x6B92, 0x6587 },
        { 0x6B93, 0x6588 },
        { 0x6B96, 0x5BB2 },
        { 0x6B9A, 0x658A },
        { 0x6B9B, 0x658B },
        { 0x6BA1, 0x658C },
        { 0x6BAA, 0x658D },
        { 0x6BB3, 0x66AE },
        { 0x6BB4, 0x5359 },
        { 0x6BB5, 0x4BCD },
        { 0x6BB7, 0x59F2 },
        { 0x6BBF, 0x4B8F },
        { 0x6BC1, 0x4E79 },
        { 0x6BC2, 0x66B0 },
        { 0x6BC5, 0x59E2 },
        { 0x6BCB, 0x57E2 },
        { 0x6BCD, 0x52B7 },
        { 0x6BCF, 0x525F },
        { 0x6BD2, 0x4BBD },
        { 0x6BD3, 0x5CB8 },
        { 0x6BD4, 0x4968 },
        { 0x6BD5, 0x496F },
        { 0x6BD6, 0x4971 },
        { 0x6BD7, 0x539F },
        { 0x6BD9, 0x4970 },
        { 0x6BDB, 0x524B },
        { 0x6BE1, 0x5B51 },
        { 0x6BEA, 0x6644 },
        { 0x6BEB, 0x4DC0 },
        { 0x6BEF, 0x56B9 },
        { 0x6BF3, 0x6645 },
        { 0x6BF5, 0x6647 },
        { 0x6BF9, 0x6648 },
        { 0x6BFD, 0x6646 },
        { 0x6C05, 0x6649 },
        { 0x6C06, 0x664B },
        { 0x6C07, 0x664A },
        { 0x6C0D, 0x664C },
        { 0x6C0F, 0x55CE },
        { 0x6C10, 0x5CB4 },
        { 0x6C11, 0x5292 },
        { 0x6C13, 0x5245 },
        { 0x6C14, 0x53F7 },
        { 0x6C15, 0x664D },
        { 0x6C16, 0x52C9 },
        { 0x6C18, 0x664E },
        { 0x6C19, 0x664F },
        { 0x6C1A, 0x6650 },
        { 0x6C1B, 0x4C75 },
        { 0x6C1F, 0x4C9B },
        { 0x6C21, 0x6651 },
        { 0x6C22, 0x5483 },
        { 0x6C24, 0x6653 },
        { 0x6C26, 0x4DA3 },
        { 0x6C27, 0x5996 },
        { 0x6C28, 0x48B0 },
        { 0x6C29, 0x6652 },
        { 0x6C2A, 0x6654 },
        { 0x6C2E, 0x4B4A },
        { 0x6C2F, 0x51C7 },
        { 0x6C30, 0x5489 },
        { 0x6C32, 0x6655 },
        { 0x6C34, 0x564E },
        { 0x6C35, 0x627F },
        { 0x6C38, 0x5A60 },
        { 0x6C3D, 0x5D7B },
        { 0x6C40, 0x5741 },
        { 0x6C41, 0x5BAC },
        { 0x6C42, 0x5494 },
        { 0x6C46, 0x5D81 },
        { 0x6C47, 0x4E84 },
        { 0x6C49, 0x4DB9 },
        { 0x6C4A, 0x6283 },
        { 0x6C50, 0x584B },
        { 0x6C54, 0x6281 },
        { 0x6C55, 0x5567 },
        { 0x6C57, 0x4DB8 },
        { 0x6C5B, 0x5954 },
        { 0x6C5C, 0x6282 },
        { 0x6C5D, 0x54E9 },
        { 0x6C5E, 0x4D4F },
        { 0x6C5F, 0x4F4D },
        { 0x6C60, 0x4A78 },
        { 0x6C61, 0x57DA },
        { 0x6C64, 0x56BF },
        { 0x6C68, 0x6289 },
        { 0x6C69, 0x628A },
        { 0x6C6A, 0x5795 },
        { 0x6C70, 0x56AC },
        { 0x6C72, 0x4EB2 },
        { 0x6C74, 0x628B },
        { 0x6C76, 0x628C },
        { 0x6C79, 0x58D9 },
        { 0x6C7D, 0x53FA },
        { 0x6C7E, 0x4C7A },
        { 0x6C81, 0x547F },
        { 0x6C82, 0x59C9 },
        { 0x6C83, 0x57D5 },
        { 0x6C85, 0x6285 },
        { 0x6C86, 0x628D },
        { 0x6C88, 0x5593 },
        { 0x6C89, 0x4A61 },
        { 0x6C8C, 0x6288 },
        { 0x6C8F, 0x53E2 },
        { 0x6C90, 0x6286 },
        { 0x6C93, 0x6753 },
        { 0x6C94, 0x6287 },
        { 0x6C99, 0x5553 },
        { 0x6C9B, 0x5387 },
        { 0x6C9F, 0x4D55 },
        { 0x6CA1, 0x525B },
        { 0x6CA3, 0x6284 },
        { 0x6CA4, 0x535D },
        { 0x6CA5, 0x5144 },
        { 0x6CA6, 0x51D8 },
        { 0x6CA7, 0x49D6 },
        { 0x6CA9, 0x628E },
        { 0x6CAA, 0x4E46 },
        { 0x6CAB, 0x52AC },
        { 0x6CAD, 0x6291 },
        { 0x6CAE, 0x4FD9 },
        { 0x6CB1, 0x629C },
        { 0x6CB2, 0x6296 },
        { 0x6CB3, 0x4DD2 },
        { 0x6CB8, 0x4C70 },
        { 0x6CB9, 0x5A6D },
        { 0x6CBB, 0x5BCD },
        { 0x6CBC, 0x5B73 },
        { 0x6CBD, 0x4D61 },
        { 0x6CBE, 0x5B54 },
        { 0x6CBF, 0x5978 },
        { 0x6CC4, 0x58B8 },
        { 0x6CC5, 0x5497 },
        { 0x6CC9, 0x54A9 },
        { 0x6CCA, 0x49B3 },
        { 0x6CCC, 0x527A },
        { 0x6CD0, 0x628F },
        { 0x6CD3, 0x629D },
        { 0x6CD4, 0x6290 },
        { 0x6CD5, 0x4C48 },
        { 0x6CD6, 0x6298 },
        { 0x6CD7, 0x6295 },
        { 0x6CDB, 0x4C5A },
        { 0x6CDE, 0x5342 },
        { 0x6CE0, 0x6297 },
        { 0x6CE1, 0x537D },
        { 0x6CE2, 0x49A7 },
        { 0x6CE3, 0x53FB },
        { 0x6CE5, 0x52DF },
        { 0x6CE8, 0x5C42 },
        { 0x6CEA, 0x50E0 },
        { 0x6CEB, 0x629A },
        { 0x6CEE, 0x629B },
        { 0x6CEF, 0x629E },
        { 0x6CF0, 0x56A8 },
        { 0x6CF1, 0x6294 },
        { 0x6CF3, 0x5A5E },
        { 0x6CF5, 0x4963 },
        { 0x6CF6, 0x6754 },
        { 0x6CF7, 0x6292 },
        { 0x6CF8, 0x6293 },
        { 0x6CFA, 0x6299 },
        { 0x6CFB, 0x58B9 },
        { 0x6CFC, 0x53C2 },
        { 0x6CFD, 0x5AF2 },
        { 0x6CFE, 0x629F },
        { 0x6D01, 0x4F81 },
        { 0x6D04, 0x62A6 },
        { 0x6D07, 0x62A5 },
        { 0x6D0B, 0x5994 },
        { 0x6D0C, 0x62A2 },
        { 0x6D0E, 0x62A8 },
        { 0x6D12, 0x54F6 },
        { 0x6D17, 0x5854 },
        { 0x6D19, 0x62A7 },
        { 0x6D1A, 0x62AD },
        { 0x6D1B, 0x51E4 },
        { 0x6D1E, 0x4BB3 },
        { 0x6D25, 0x4F93 },
        { 0x6D27, 0x62A1 },
        { 0x6D2A, 0x4DE8 },
        { 0x6D2B, 0x62A9 },
        { 0x6D2E, 0x62AB },
        { 0x6D31, 0x4BFC },
        { 0x6D32, 0x5BDD },
        { 0x6D33, 0x62B1 },
        { 0x6D35, 0x62AC },
        { 0x6D39, 0x62A0 },
        { 0x6D3B, 0x4E8F },
        { 0x6D3C, 0x577D },
        { 0x6D3D, 0x5442 },
        { 0x6D3E, 0x5369 },
        { 0x6D41, 0x5198 },
        { 0x6D43, 0x62A3 },
        { 0x6D45, 0x5453 },
        { 0x6D46, 0x4F4C },
        { 0x6D47, 0x4F5D },
        { 0x6D48, 0x62A4 },
        { 0x6D4A, 0x5C67 },
        { 0x6D4B, 0x49E1 },
        { 0x6D4D, 0x62AA },
        { 0x6D4E, 0x4EC2 },
        { 0x6D4F, 0x62AE },
        { 0x6D51, 0x4E8C },
        { 0x6D52, 0x62AF },
        { 0x6D53, 0x5348 },
        { 0x6D54, 0x62B0 },
        { 0x6D59, 0x5B84 },
        { 0x6D5A, 0x5043 },
        { 0x6D5C, 0x62B9 },
        { 0x6D5E, 0x62B6 },
        { 0x6D60, 0x62BA },
        { 0x6D63, 0x62BC },
        { 0x6D66, 0x53D5 },
        { 0x6D69, 0x4DC5 },
        { 0x6D6A, 0x50CA },
        { 0x6D6E, 0x4CA0 },
        { 0x6D6F, 0x62B3 },
        { 0x6D74, 0x5AA0 },
        { 0x6D77, 0x4DA2 },
        { 0x6D78, 0x4F9F },
        { 0x6D7C, 0x62BB },
        { 0x6D82, 0x575F },
        { 0x6D85, 0x52F8 },
        { 0x6D88, 0x589C },
        { 0x6D89, 0x5587 },
        { 0x6D8C, 0x5A5F },
        { 0x6D8E, 0x5871 },
        { 0x6D91, 0x62B2 },
        { 0x6D93, 0x62B7 },
        { 0x6D94, 0x62B8 },
        { 0x6D95, 0x56E8 },
        { 0x6D9B, 0x56CD },
        { 0x6D9D, 0x50D3 },
        { 0x6D9E, 0x62B4 },
        { 0x6D9F, 0x5150 },
        { 0x6DA0, 0x62B5 },
        { 0x6DA1, 0x57CF },
        { 0x6DA3, 0x4E61 },
        { 0x6DA4, 0x4B73 },
        { 0x6DA6, 0x54F2 },
        { 0x6DA7, 0x4F47 },
        { 0x6DA8, 0x5B67 },
        { 0x6DA9, 0x554C },
        { 0x6DAA, 0x4CA1 },
        { 0x6DAB, 0x62C9 },
        { 0x6DAE, 0x62CB },
        { 0x6DAF, 0x5964 },
        { 0x6DB2, 0x59B9 },
        { 0x6DB5, 0x4DAC },
        { 0x6DB8, 0x4DD3 },
        { 0x6DBF, 0x62C2 },
        { 0x6DC0, 0x4B8E },
        { 0x6DC4, 0x5C6D },
        { 0x6DC5, 0x62BF },
        { 0x6DC6, 0x589E },
        { 0x6DC7, 0x62BE },
        { 0x6DCB, 0x517C },
        { 0x6DCC, 0x56C9 },
        { 0x6DD1, 0x55E6 },
        { 0x6DD6, 0x52D6 },
        { 0x6DD8, 0x56D3 },
        { 0x6DD9, 0x62C7 },
        { 0x6DDD, 0x62C6 },
        { 0x6DDE, 0x62C0 },
        { 0x6DE0, 0x62C3 },
        { 0x6DE1, 0x4B4D },
        { 0x6DE4, 0x5A79 },
        { 0x6DE6, 0x62C5 },
        { 0x6DEB, 0x59F8 },
        { 0x6DEC, 0x4AE2 },
        { 0x6DEE, 0x4E54 },
        { 0x6DF1, 0x558F },
        { 0x6DF3, 0x4ABD },
        { 0x6DF7, 0x4E8D },
        { 0x6DF9, 0x596D },
        { 0x6DFB, 0x56EC },
        { 0x6DFC, 0x6755 },
        { 0x6E05, 0x5486 },
        { 0x6E0A, 0x5AA7 },
        { 0x6E0C, 0x62CA },
        { 0x6E0D, 0x5C75 },
        { 0x6E0E, 0x62C1 },
        { 0x6E10, 0x4F45 },
        { 0x6E11, 0x62C4 },
        { 0x6E14, 0x5A87 },
        { 0x6E16, 0x62C8 },
        { 0x6E17, 0x5599 },
        { 0x6E1A, 0x62BD },
        { 0x6E1D, 0x5A86 },
        { 0x6E20, 0x549F },
        { 0x6E21, 0x4BC8 },
        { 0x6E23, 0x5AFB },
        { 0x6E24, 0x49B2 },
        { 0x6E25, 0x62D6 },
        { 0x6E29, 0x57C1 },
        { 0x6E2B, 0x62CC },
        { 0x6E2D, 0x57BB },
        { 0x6E2F, 0x4CDA },
        { 0x6E32, 0x62D5 },
        { 0x6E34, 0x506A },
        { 0x6E38, 0x5A6E },
        { 0x6E3A, 0x528D },
        { 0x6E43, 0x5368 },
        { 0x6E44, 0x62D7 },
        { 0x6E4D, 0x5764 },
        { 0x6E4E, 0x62CE },
        { 0x6E53, 0x62D3 },
        { 0x6E54, 0x62D4 },
        { 0x6E56, 0x4DFD },
        { 0x6E58, 0x5887 },
        { 0x6E5B, 0x5B5F },
        { 0x6E5F, 0x62D1 },
        { 0x6E6B, 0x62CF },
        { 0x6E6E, 0x62CD },
        { 0x6E7E, 0x5786 },
        { 0x6E7F, 0x55A9 },
        { 0x6E83, 0x50A2 },
        { 0x6E85, 0x4F46 },
        { 0x6E86, 0x62D2 },
        { 0x6E89, 0x4CC7 },
        { 0x6E8F, 0x62E6 },
        { 0x6E90, 0x5AB3 },
        { 0x6E98, 0x62DA },
        { 0x6E9C, 0x5190 },
        { 0x6E9F, 0x62E8 },
        { 0x6EA2, 0x59E6 },
        { 0x6EA5, 0x62DE },
        { 0x6EA7, 0x62DF },
        { 0x6EAA, 0x584A },
        { 0x6EAF, 0x567D },
        { 0x6EB1, 0x62D9 },
        { 0x6EB2, 0x62D0 },
        { 0x6EB4, 0x62E4 },
        { 0x6EB6, 0x54DB },
        { 0x6EB7, 0x62E2 },
        { 0x6EBA, 0x52E6 },
        { 0x6EBB, 0x62E1 },
        { 0x6EBD, 0x62E0 },
        { 0x6EC1, 0x4A9D },
        { 0x6EC2, 0x62E7 },
        { 0x6EC7, 0x4B82 },
        { 0x6ECB, 0x5C6C },
        { 0x6ECF, 0x62E5 },
        { 0x6ED1, 0x4E4C },
        { 0x6ED3, 0x5C72 },
        { 0x6ED4, 0x56CE },
        { 0x6ED5, 0x6699 },
        { 0x6ED7, 0x62E3 },
        { 0x6EDA, 0x4D97 },
        { 0x6EDE, 0x5BCC },
        { 0x6EDF, 0x62D8 },
        { 0x6EE0, 0x62DB },
        { 0x6EE1, 0x51F9 },
        { 0x6EE2, 0x62DD },
        { 0x6EE4, 0x51CA },
        { 0x6EE5, 0x50C3 },
        { 0x6EE6, 0x51CF },
        { 0x6EE8, 0x4996 },
        { 0x6EE9, 0x56B1 },
        { 0x6EF4, 0x4B6E },
        { 0x6EF9, 0x62EE },
        { 0x6F02, 0x53AE },
        { 0x6F06, 0x53E0 },
        { 0x6F09, 0x62F4 },
        { 0x6F0F, 0x51A8 },
        { 0x6F13, 0x50EB },
        { 0x6F14, 0x597D },
        { 0x6F15, 0x62ED },
        { 0x6F20, 0x52AD },
        { 0x6F24, 0x62EC },
        { 0x6F29, 0x62F5 },
        { 0x6F2A, 0x62F3 },
        { 0x6F2B, 0x51FD },
        { 0x6F2D, 0x62DC },
        { 0x6F2F, 0x62EF },
        { 0x6F31, 0x55FD },
        { 0x6F33, 0x5B64 },
        { 0x6F36, 0x62F0 },
        { 0x6F3E, 0x599B },
        { 0x6F46, 0x62EA },
        { 0x6F47, 0x62EB },
        { 0x6F4B, 0x62F1 },
        { 0x6F4D, 0x57AA },
        { 0x6F58, 0x536B },
        { 0x6F5C, 0x5451 },
        { 0x6F5E, 0x51B9 },
        { 0x6F62, 0x62E9 },
        { 0x6F66, 0x516A },
        { 0x6F6D, 0x56B5 },
        { 0x6F6E, 0x4A51 },
        { 0x6F72, 0x62FA },
        { 0x6F74, 0x62F2 },
        { 0x6F78, 0x62F9 },
        { 0x6F7A, 0x62FC },
        { 0x6F7C, 0x62FB },
        { 0x6F84, 0x4A6E },
        { 0x6F88, 0x4A5A },
        { 0x6F89, 0x62F6 },
        { 0x6F8C, 0x62F8 },
        { 0x6F8D, 0x62F7 },
        { 0x6F8E, 0x538D },
        { 0x6F9C, 0x50BC },
        { 0x6FA1, 0x5AE7 },
        { 0x6FA7, 0x6342 },
        { 0x6FB3, 0x48C3 },
        { 0x6FB6, 0x6344 },
        { 0x6FB9, 0x6343 },
        { 0x6FC0, 0x4EA3 },
        { 0x6FC2, 0x6345 },
        { 0x6FC9, 0x6341 },
        { 0x6FD1, 0x62FD },
        { 0x6FD2, 0x4995 },
        { 0x6FDE, 0x6348 },
        { 0x6FE0, 0x6349 },
        { 0x6FE1, 0x6346 },
        { 0x6FEE, 0x6347 },
        { 0x6FEF, 0x634A },
        { 0x7011, 0x53D8 },
        { 0x701A, 0x634B },
        { 0x701B, 0x634D },
        { 0x7023, 0x634C },
        { 0x7035, 0x634F },
        { 0x7039, 0x634E },
        { 0x704C, 0x4D81 },
        { 0x704F, 0x6350 },
        { 0x705E, 0x6351 },
        { 0x706B, 0x4E91 },
        { 0x706C, 0x66E0 },
        { 0x706D, 0x5291 },
        { 0x706F, 0x4B66 },
        { 0x7070, 0x4E72 },
        { 0x7075, 0x518A },
        { 0x7076, 0x5AED },
        { 0x7078, 0x4FC3 },
        { 0x707C, 0x5C66 },
        { 0x707E, 0x5AD5 },
        { 0x707F, 0x49D2 },
        { 0x7080, 0x66BD },
        { 0x7085, 0x65C0 },
        { 0x7089, 0x51AE },
        { 0x708A, 0x4AB5 },
        { 0x708E, 0x5977 },
        { 0x7092, 0x4A54 },
        { 0x7094, 0x54B1 },
        { 0x7095, 0x505B },
        { 0x7096, 0x66BF },
        { 0x7099, 0x5BCA },
        { 0x709C, 0x66BE },
        { 0x709D, 0x66C0 },
        { 0x70AB, 0x66C4 },
        { 0x70AC, 0x4FE5 },
        { 0x70AD, 0x56BE },
        { 0x70AE, 0x537A },
        { 0x70AF, 0x4FBB },
        { 0x70B1, 0x66C5 },
        { 0x70B3, 0x499F },
        { 0x70B7, 0x66C3 },
        { 0x70B8, 0x5B48 },
        { 0x70B9, 0x4B84 },
        { 0x70BB, 0x66C1 },
        { 0x70BC, 0x5156 },
        { 0x70BD, 0x4A84 },
        { 0x70C0, 0x66C2 },
        { 0x70C1, 0x5658 },
        { 0x70C2, 0x50C2 },
        { 0x70C3, 0x56FD },
        { 0x70C8, 0x5172 },
        { 0x70CA, 0x66C7 },
        { 0x70D8, 0x4DE5 },
        { 0x70D9, 0x50D2 },
        { 0x70DB, 0x5BF1 },
        { 0x70DF, 0x596C },
        { 0x70E4, 0x505E },
        { 0x70E6, 0x4C53 },
        { 0x70E7, 0x5575 },
        { 0x70E8, 0x66C6 },
        { 0x70E9, 0x4E83 },
        { 0x70EB, 0x56CB },
        { 0x70EC, 0x4F9E },
        { 0x70ED, 0x54C7 },
        { 0x70EF, 0x5849 },
        { 0x70F7, 0x578A },
        { 0x70F9, 0x538C },
        { 0x70FD, 0x4C8A },
        { 0x7109, 0x5969 },
        { 0x710A, 0x4DB7 },
        { 0x7110, 0x66C8 },
        { 0x7113, 0x66C9 },
        { 0x7115, 0x4E60 },
        { 0x7116, 0x66CA },
        { 0x7118, 0x66E1 },
        { 0x7119, 0x495A },
        { 0x711A, 0x4C79 },
        { 0x7126, 0x4F59 },
        { 0x712F, 0x66CB },
        { 0x7130, 0x5987 },
        { 0x7131, 0x66CC },
        { 0x7136, 0x54BA },
        { 0x7145, 0x66D0 },
        { 0x714A, 0x66D2 },
        { 0x714C, 0x4E6D },
        { 0x714E, 0x4EE4 },
        { 0x715C, 0x66CE },
        { 0x715E, 0x5557 },
        { 0x7164, 0x525A },
        { 0x7166, 0x66E2 },
        { 0x7167, 0x5B75 },
        { 0x7168, 0x66CF },
        { 0x716E, 0x5BF2 },
        { 0x7172, 0x66D1 },
        { 0x7173, 0x66CD },
        { 0x7178, 0x66D3 },
        { 0x717A, 0x66D4 },
        { 0x717D, 0x555F },
        { 0x7184, 0x5848 },
        { 0x718A, 0x58DB },
        { 0x718F, 0x594C },
        { 0x7194, 0x54DA },
        { 0x7198, 0x66D5 },
        { 0x7199, 0x57F4 },
        { 0x719F, 0x55EB },
        { 0x71A0, 0x66D9 },
        { 0x71A8, 0x66D8 },
        { 0x71AC, 0x48BD },
        { 0x71B3, 0x66D6 },
        { 0x71B5, 0x66D7 },
        { 0x71B9, 0x66E3 },
        { 0x71C3, 0x54BB },
        { 0x71CE, 0x5167 },
        { 0x71D4, 0x66DB },
        { 0x71D5, 0x5981 },
        { 0x71E0, 0x66DA },
        { 0x71E5, 0x5AEE },
        { 0x71E7, 0x66DC },
        { 0x71EE, 0x5E66 },
        { 0x71F9, 0x66DD },
        { 0x7206, 0x494C },
        { 0x721D, 0x66DE },
        { 0x7228, 0x66DF },
        { 0x722A, 0x5C46 },
        { 0x722C, 0x5360 },
        { 0x7230, 0x665C },
        { 0x7231, 0x48AD },
        { 0x7235, 0x4FF3 },
        { 0x7236, 0x4CB7 },
        { 0x7237, 0x59AE },
        { 0x7238, 0x48D5 },
        { 0x7239, 0x4B9A },
        { 0x723B, 0x5CB2 },
        { 0x723D, 0x564C },
        { 0x723F, 0x627D },
        { 0x7247, 0x53AB },
        { 0x7248, 0x48E5 },
        { 0x724C, 0x5366 },
        { 0x724D, 0x6659 },
        { 0x7252, 0x665A },
        { 0x7256, 0x665B },
        { 0x7259, 0x5960 },
        { 0x725B, 0x5343 },
        { 0x725D, 0x65F1 },
        { 0x725F, 0x52B1 },
        { 0x7261, 0x52B4 },
        { 0x7262, 0x50CD },
        { 0x7266, 0x65F2 },
        { 0x7267, 0x52C0 },
        { 0x7269, 0x57EE },
        { 0x726E, 0x65EF },
        { 0x726F, 0x65F3 },
        { 0x7272, 0x559D },
        { 0x7275, 0x5443 },
        { 0x7279, 0x56D7 },
        { 0x727A, 0x57FD },
        { 0x727E, 0x65F4 },
        { 0x727F, 0x65F5 },
        { 0x7280, 0x584C },
        { 0x7281, 0x50E6 },
        { 0x7284, 0x65F6 },
        { 0x728A, 0x4BBE },
        { 0x728B, 0x65F7 },
        { 0x728D, 0x65F8 },
        { 0x728F, 0x65F9 },
        { 0x7292, 0x65FA },
        { 0x729F, 0x65F0 },
        { 0x72AC, 0x54AD },
        { 0x72AD, 0x618C },
        { 0x72AF, 0x4C58 },
        { 0x72B0, 0x618D },
        { 0x72B4, 0x618E },
        { 0x72B6, 0x5C54 },
        { 0x72B7, 0x618F },
        { 0x72B8, 0x6190 },
        { 0x72B9, 0x5A6C },
        { 0x72C1, 0x6192 },
        { 0x72C2, 0x5092 },
        { 0x72C3, 0x6191 },
        { 0x72C4, 0x4B72 },
        { 0x72C8, 0x4957 },
        { 0x72CD, 0x6194 },
        { 0x72CE, 0x6193 },
        { 0x72D0, 0x4DFB },
        { 0x72D2, 0x6195 },
        { 0x72D7, 0x4D57 },
        { 0x72D9, 0x4FD0 },
        { 0x72DE, 0x52FB },
        { 0x72E0, 0x4DDC },
        { 0x72E1, 0x4F66 },
        { 0x72E8, 0x6196 },
        { 0x72E9, 0x6198 },
        { 0x72EC, 0x4BBF },
        { 0x72ED, 0x5861 },
        { 0x72EE, 0x55A7 },
        { 0x72EF, 0x6197 },
        { 0x72F0, 0x5B99 },
        { 0x72F1, 0x5A9D },
        { 0x72F2, 0x6199 },
        { 0x72F3, 0x619D },
        { 0x72F4, 0x619A },
        { 0x72F7, 0x619B },
        { 0x72F8, 0x50E9 },
        { 0x72FA, 0x619F },
        { 0x72FB, 0x61A0 },
        { 0x72FC, 0x50C6 },
        { 0x7301, 0x619C },
        { 0x7303, 0x619E },
        { 0x730A, 0x61A4 },
        { 0x730E, 0x5174 },
        { 0x7313, 0x61A2 },
        { 0x7315, 0x61A7 },
        { 0x7316, 0x49FD },
        { 0x7317, 0x61A1 },
        { 0x731B, 0x526D },
        { 0x731C, 0x49C1 },
        { 0x731D, 0x61A6 },
        { 0x731E, 0x61A5 },
        { 0x7321, 0x61A3 },
        { 0x7322, 0x61A8 },
        { 0x7325, 0x61AA },
        { 0x7329, 0x58C8 },
        { 0x732A, 0x5BEC },
        { 0x732B, 0x5248 },
        { 0x732C, 0x61AB },
        { 0x732E, 0x5877 },
        { 0x7331, 0x61AD },
        { 0x7334, 0x4DEE },
        { 0x7337, 0x6581 },
        { 0x7338, 0x61AC },
        { 0x7339, 0x61A9 },
        { 0x733E, 0x4E4B },
        { 0x733F, 0x5AB2 },
        { 0x734D, 0x61AF },
        { 0x7350, 0x61AE },
        { 0x7352, 0x6582 },
        { 0x7357, 0x61B0 },
        { 0x7360, 0x61B1 },
        { 0x736C, 0x61B2 },
        { 0x736D, 0x56A0 },
        { 0x736F, 0x61B3 },
        { 0x737E, 0x61B4 },
        { 0x7384, 0x58FD },
        { 0x7387, 0x51C9 },
        { 0x7389, 0x5A92 },
        { 0x738B, 0x5796 },
        { 0x738E, 0x6481 },
        { 0x7391, 0x6482 },
        { 0x7396, 0x4FC0 },
        { 0x739B, 0x51E9 },
        { 0x739F, 0x6485 },
        { 0x73A2, 0x6484 },
        { 0x73A9, 0x5787 },
        { 0x73AB, 0x5255 },
        { 0x73AE, 0x6483 },
        { 0x73AF, 0x4E57 },
        { 0x73B0, 0x5876 },
        { 0x73B2, 0x5182 },
        { 0x73B3, 0x648A },
        { 0x73B7, 0x6489 },
        { 0x73BA, 0x6495 },
        { 0x73BB, 0x49A2 },
        { 0x73C0, 0x648B },
        { 0x73C2, 0x6487 },
        { 0x73C8, 0x648D },
        { 0x73C9, 0x648C },
        { 0x73CA, 0x555A },
        { 0x73CD, 0x5B85 },
        { 0x73CF, 0x6486 },
        { 0x73D0, 0x4C49 },
        { 0x73D1, 0x6488 },
        { 0x73D9, 0x648F },
        { 0x73DE, 0x6494 },
        { 0x73E0, 0x5BE8 },
        { 0x73E5, 0x648E },
        { 0x73E7, 0x6493 },
        { 0x73E9, 0x6492 },
        { 0x73ED, 0x48DF },
        { 0x73F2, 0x6496 },
        { 0x7403, 0x5493 },
        { 0x7405, 0x50C4 },
        { 0x7406, 0x50EC },
        { 0x7409, 0x5191 },
        { 0x740A, 0x6491 },
        { 0x740F, 0x6497 },
        { 0x7410, 0x5697 },
        { 0x741A, 0x64A1 },
        { 0x741B, 0x64A0 },
        { 0x7422, 0x5C61 },
        { 0x7425, 0x649B },
        { 0x7426, 0x649A },
        { 0x7428, 0x649C },
        { 0x742A, 0x6498 },
        { 0x742C, 0x649F },
        { 0x742E, 0x649E },
        { 0x7430, 0x649D },
        { 0x7433, 0x5175 },
        { 0x7434, 0x5479 },
        { 0x7435, 0x539E },
        { 0x7436, 0x5363 },
        { 0x743C, 0x548E },
        { 0x7441, 0x64A2 },
        { 0x7455, 0x64A5 },
        { 0x7457, 0x64A4 },
        { 0x7459, 0x64A6 },
        { 0x745A, 0x4DF6 },
        { 0x745B, 0x6499 },
        { 0x745C, 0x64A3 },
        { 0x745E, 0x54EF },
        { 0x745F, 0x554A },
        { 0x746D, 0x64A8 },
        { 0x7470, 0x4D86 },
        { 0x7476, 0x599F },
        { 0x7477, 0x64A7 },
        { 0x747E, 0x64A9 },
        { 0x7480, 0x64AC },
        { 0x7481, 0x64AD },
        { 0x7483, 0x5147 },
        { 0x7487, 0x64AE },
        { 0x748B, 0x64AF },
        { 0x748E, 0x64AB },
        { 0x7490, 0x64B3 },
        { 0x749C, 0x64AA },
        { 0x749E, 0x64B0 },
        { 0x74A7, 0x64B4 },
        { 0x74A8, 0x64B1 },
        { 0x74A9, 0x64B2 },
        { 0x74BA, 0x64B6 },
        { 0x74D2, 0x64B5 },
        { 0x74DC, 0x4D6F },
        { 0x74DE, 0x68AB },
        { 0x74E0, 0x68AC },
        { 0x74E2, 0x53AF },
        { 0x74E3, 0x48E9 },
        { 0x74E4, 0x54BE },
        { 0x74E6, 0x577F },
        { 0x74EE, 0x57CC },
        { 0x74EF, 0x65B0 },
        { 0x74F4, 0x65B1 },
        { 0x74F6, 0x53BE },
        { 0x74F7, 0x4AC8 },
        { 0x74FF, 0x65B2 },
        { 0x7504, 0x5B88 },
        { 0x750D, 0x5F9A },
        { 0x750F, 0x65B3 },
        { 0x7511, 0x65B4 },
        { 0x7513, 0x65B5 },
        { 0x7518, 0x4CC9 },
        { 0x7519, 0x6050 },
        { 0x751A, 0x5596 },
        { 0x751C, 0x56EF },
        { 0x751F, 0x559B },
        { 0x7525, 0x559C },
        { 0x7528, 0x5A63 },
        { 0x7529, 0x5646 },
        { 0x752B, 0x4CA5 },
        { 0x752C, 0x68AD },
        { 0x752D, 0x4962 },
        { 0x752F, 0x6358 },
        { 0x7530, 0x56EE },
        { 0x7531, 0x5A69 },
        { 0x7532, 0x4ED6 },
        { 0x7533, 0x558B },
        { 0x7535, 0x4B88 },
        { 0x7537, 0x52CF },
        { 0x7538, 0x4B8A },
        { 0x753A, 0x67AD },
        { 0x753B, 0x4E4D },
        { 0x753E, 0x647E },
        { 0x7540, 0x67AE },
        { 0x7545, 0x4A49 },
        { 0x7548, 0x67B1 },
        { 0x754B, 0x67B0 },
        { 0x754C, 0x4F88 },
        { 0x754E, 0x67AF },
        { 0x754F, 0x57B6 },
        { 0x7554, 0x536F },
        { 0x7559, 0x5195 },
        { 0x755A, 0x5E6E },
        { 0x755B, 0x67B2 },
        { 0x755C, 0x58F2 },
        { 0x7565, 0x51D3 },
        { 0x7566, 0x53E7 },
        { 0x756A, 0x4C4C },
        { 0x7572, 0x67B3 },
        { 0x7574, 0x4A8C },
        { 0x7578, 0x4E9C },
        { 0x7579, 0x67B4 },
        { 0x757F, 0x647C },
        { 0x7583, 0x67B5 },
        { 0x7586, 0x4F4E },
        { 0x758B, 0x6983 },
        { 0x758F, 0x55E7 },
        { 0x7591, 0x59C8 },
        { 0x7592, 0x68D9 },
        { 0x7594, 0x68DA },
        { 0x7596, 0x68DB },
        { 0x7597, 0x5166 },
        { 0x7599, 0x4CEC },
        { 0x759A, 0x4FCD },
        { 0x759D, 0x68DD },
        { 0x759F, 0x5351 },
        { 0x75A0, 0x68DC },
        { 0x75A1, 0x5992 },
        { 0x75A3, 0x68DF },
        { 0x75A4, 0x48CB },
        { 0x75A5, 0x4F8B },
        { 0x75AB, 0x59DE },
        { 0x75AC, 0x68DE },
        { 0x75AE, 0x4AAE },
        { 0x75AF, 0x4C89 },
        { 0x75B0, 0x68E5 },
        { 0x75B1, 0x68E4 },
        { 0x75B2, 0x53A2 },
        { 0x75B3, 0x68E0 },
        { 0x75B4, 0x68E1 },
        { 0x75B5, 0x4AC2 },
        { 0x75B8, 0x68E2 },
        { 0x75B9, 0x5B8F },
        { 0x75BC, 0x56DA },
        { 0x75BD, 0x4FD1 },
        { 0x75BE, 0x4EB1 },
        { 0x75C2, 0x68E7 },
        { 0x75C3, 0x68E6 },
        { 0x75C4, 0x68E3 },
        { 0x75C5, 0x49A0 },
        { 0x75C7, 0x5BA1 },
        { 0x75C8, 0x5A58 },
        { 0x75C9, 0x4FB6 },
        { 0x75CA, 0x54AB },
        { 0x75CD, 0x68E9 },
        { 0x75D2, 0x5998 },
        { 0x75D4, 0x5BCB },
        { 0x75D5, 0x4DDA },
        { 0x75D6, 0x68E8 },
        { 0x75D8, 0x4BBA },
        { 0x75DB, 0x5754 },
        { 0x75DE, 0x53A5 },
        { 0x75E2, 0x5141 },
        { 0x75E3, 0x68EA },
        { 0x75E4, 0x68ED },
        { 0x75E6, 0x68EC },
        { 0x75E7, 0x68EF },
        { 0x75E8, 0x68EB },
        { 0x75EA, 0x4E5E },
        { 0x75EB, 0x68EE },
        { 0x75F0, 0x56B4 },
        { 0x75F1, 0x68F1 },
        { 0x75F4, 0x4A75 },
        { 0x75F9, 0x4974 },
        { 0x75FC, 0x68F2 },
        { 0x75FF, 0x68F3 },
        { 0x7600, 0x68F5 },
        { 0x7601, 0x4AE0 },
        { 0x7603, 0x68F0 },
        { 0x7605, 0x68F6 },
        { 0x760A, 0x68F9 },
        { 0x760C, 0x68F7 },
        { 0x7610, 0x68F4 },
        { 0x7615, 0x68FC },
        { 0x7617, 0x68F8 },
        { 0x7618, 0x68FB },
        { 0x7619, 0x68FD },
        { 0x761B, 0x6941 },
        { 0x761F, 0x57C0 },
        { 0x7620, 0x6944 },
        { 0x7622, 0x6943 },
        { 0x7624, 0x5197 },
        { 0x7625, 0x68FA },
        { 0x7626, 0x55DC },
        { 0x7629, 0x4AF0 },
        { 0x762A, 0x4992 },
        { 0x762B, 0x56B0 },
        { 0x762D, 0x6946 },
        { 0x7630, 0x6947 },
        { 0x7633, 0x694C },
        { 0x7634, 0x5B6E },
        { 0x7635, 0x6949 },
        { 0x7638, 0x54B2 },
        { 0x763C, 0x6942 },
        { 0x763E, 0x694B },
        { 0x763F, 0x6948 },
        { 0x7640, 0x6945 },
        { 0x7643, 0x694A },
        { 0x764C, 0x48A8 },
        { 0x764D, 0x694D },
        { 0x7654, 0x694F },
        { 0x7656, 0x6951 },
        { 0x765C, 0x6950 },
        { 0x765E, 0x694E },
        { 0x7663, 0x5942 },
        { 0x766B, 0x6952 },
        { 0x766F, 0x6953 },
        { 0x7678, 0x4D90 },
        { 0x767B, 0x4B67 },
        { 0x767D, 0x48D6 },
        { 0x767E, 0x48D8 },
        { 0x7682, 0x5AEC },
        { 0x7684, 0x4B64 },
        { 0x7686, 0x4F74 },
        { 0x7687, 0x4E6A },
        { 0x7688, 0x68A6 },
        { 0x768B, 0x4CDD },
        { 0x768E, 0x68A7 },
        { 0x7691, 0x48A7 },
        { 0x7693, 0x68A8 },
        { 0x7696, 0x578F },
        { 0x7699, 0x68A9 },
        { 0x76A4, 0x68AA },
        { 0x76AE, 0x53A3 },
        { 0x76B1, 0x5BE4 },
        { 0x76B2, 0x6985 },
        { 0x76B4, 0x6986 },
        { 0x76BF, 0x5294 },
        { 0x76C2, 0x5A7B },
        { 0x76C5, 0x5BD0 },
        { 0x76C6, 0x5389 },
        { 0x76C8, 0x5A4F },
        { 0x76CA, 0x59E5 },
        { 0x76CD, 0x67C0 },
        { 0x76CE, 0x48BA },
        { 0x76CF, 0x5B55 },
        { 0x76D0, 0x596E },
        { 0x76D1, 0x4EDF },
        { 0x76D2, 0x4DCF },
        { 0x76D4, 0x5099 },
        { 0x76D6, 0x4CC6 },
        { 0x76D7, 0x4B61 },
        { 0x76D8, 0x536C },
        { 0x76DB, 0x55A1 },
        { 0x76DF, 0x526B },
        { 0x76E5, 0x67C1 },
        { 0x76EE, 0x52BE },
        { 0x76EF, 0x4BA1 },
        { 0x76F1, 0x678D },
        { 0x76F2, 0x5244 },
        { 0x76F4, 0x5BB0 },
        { 0x76F8, 0x5881 },
        { 0x76F9, 0x6790 },
        { 0x76FC, 0x536E },
        { 0x76FE, 0x4BDB },
        { 0x7701, 0x55A0 },
        { 0x7704, 0x678E },
        { 0x7707, 0x6791 },
        { 0x7708, 0x6792 },
        { 0x7709, 0x525C },
        { 0x770B, 0x5054 },
        { 0x770D, 0x678F },
        { 0x7719, 0x6795 },
        { 0x771A, 0x6793 },
        { 0x771F, 0x5B87 },
        { 0x7720, 0x527F },
        { 0x7722, 0x6794 },
        { 0x7726, 0x6797 },
        { 0x7728, 0x5B43 },
        { 0x7729, 0x5943 },
        { 0x772D, 0x6796 },
        { 0x772F, 0x5270 },
        { 0x7735, 0x6798 },
        { 0x7736, 0x5095 },
        { 0x7737, 0x4FEB },
        { 0x7738, 0x6799 },
        { 0x773A, 0x56F6 },
        { 0x773C, 0x597B },
        { 0x7740, 0x5C65 },
        { 0x7741, 0x5B97 },
        { 0x7743, 0x679D },
        { 0x7747, 0x679C },
        { 0x7750, 0x679A },
        { 0x7751, 0x679B },
        { 0x775A, 0x679E },
        { 0x775B, 0x4FA5 },
        { 0x7761, 0x564F },
        { 0x7762, 0x67A0 },
        { 0x7763, 0x4BBC },
        { 0x7765, 0x67A1 },
        { 0x7766, 0x52BF },
        { 0x7768, 0x679F },
        { 0x776B, 0x4F7E },
        { 0x776C, 0x49C6 },
        { 0x7779, 0x4BC2 },
        { 0x777D, 0x67A4 },
        { 0x777E, 0x5CB9 },
        { 0x777F, 0x67A2 },
        { 0x7780, 0x67A5 },
        { 0x7784, 0x528A },
        { 0x7785, 0x4A93 },
        { 0x778C, 0x67A6 },
        { 0x778D, 0x67A3 },
        { 0x778E, 0x5859 },
        { 0x7791, 0x67A7 },
        { 0x7792, 0x51F6 },
        { 0x779F, 0x67A8 },
        { 0x77A0, 0x67A9 },
        { 0x77A2, 0x5FAA },
        { 0x77A5, 0x53B2 },
        { 0x77A7, 0x5466 },
        { 0x77A9, 0x5BF4 },
        { 0x77AA, 0x4B69 },
        { 0x77AC, 0x5652 },
        { 0x77B0, 0x67AA },
        { 0x77B3, 0x574B },
        { 0x77B5, 0x67AB },
        { 0x77BB, 0x5B50 },
        { 0x77BD, 0x67AC },
        { 0x77BF, 0x6BC3 },
        { 0x77CD, 0x5E67 },
        { 0x77D7, 0x4AA2 },
        { 0x77DB, 0x524C },
        { 0x77DC, 0x6987 },
        { 0x77E2, 0x55B7 },
        { 0x77E3, 0x59D2 },
        { 0x77E5, 0x5BA9 },
        { 0x77E7, 0x6893 },
        { 0x77E9, 0x4FD7 },
        { 0x77EB, 0x4F63 },
        { 0x77EC, 0x6894 },
        { 0x77ED, 0x4BCB },
        { 0x77EE, 0x48AA },
        { 0x77F3, 0x55AE },
        { 0x77F6, 0x6756 },
        { 0x77F8, 0x6757 },
        { 0x77FD, 0x57F8 },
        { 0x77FE, 0x4C4F },
        { 0x77FF, 0x5094 },
        { 0x7800, 0x6758 },
        { 0x7801, 0x51EA },
        { 0x7802, 0x5550 },
        { 0x7809, 0x6759 },
        { 0x780C, 0x53F5 },
        { 0x780D, 0x5053 },
        { 0x7811, 0x675C },
        { 0x7812, 0x5399 },
        { 0x7814, 0x5970 },
        { 0x7816, 0x5C49 },
        { 0x7817, 0x675A },
        { 0x7818, 0x675B },
        { 0x781A, 0x5983 },
        { 0x781C, 0x675F },
        { 0x781D, 0x6760 },
        { 0x781F, 0x6764 },
        { 0x7823, 0x6768 },
        { 0x7825, 0x6766 },
        { 0x7826, 0x676E },
        { 0x7827, 0x5B89 },
        { 0x7829, 0x6769 },
        { 0x782C, 0x6767 },
        { 0x782D, 0x675E },
        { 0x7830, 0x538A },
        { 0x7834, 0x53C5 },
        { 0x7837, 0x558A },
        { 0x7838, 0x5AD1 },
        { 0x7839, 0x6761 },
        { 0x783A, 0x6762 },
        { 0x783B, 0x6763 },
        { 0x783C, 0x6765 },
        { 0x783E, 0x50F8 },
        { 0x7840, 0x4AA0 },
        { 0x7845, 0x4D89 },
        { 0x7847, 0x6770 },
        { 0x784C, 0x6771 },
        { 0x784E, 0x676A },
        { 0x7850, 0x676F },
        { 0x7852, 0x57F7 },
        { 0x7855, 0x5656 },
        { 0x7856, 0x676C },
        { 0x7857, 0x676D },
        { 0x785D, 0x5896 },
        { 0x786A, 0x6772 },
        { 0x786B, 0x5193 },
        { 0x786C, 0x5A52 },
        { 0x786D, 0x676B },
        { 0x786E, 0x54B6 },
        { 0x7877, 0x4EEE },
        { 0x787C, 0x5391 },
        { 0x7887, 0x6776 },
        { 0x7889, 0x4B90 },
        { 0x788C, 0x51B4 },
        { 0x788D, 0x48AC },
        { 0x788E, 0x568A },
        { 0x7891, 0x494E },
        { 0x7893, 0x6774 },
        { 0x7897, 0x578C },
        { 0x7898, 0x4B83 },
        { 0x789A, 0x6775 },
        { 0x789B, 0x6773 },
        { 0x789C, 0x6777 },
        { 0x789F, 0x4B9B },
        { 0x78A1, 0x6778 },
        { 0x78A3, 0x6779 },
        { 0x78A5, 0x677C },
        { 0x78A7, 0x496C },
        { 0x78B0, 0x5397 },
        { 0x78B1, 0x4EED },
        { 0x78B2, 0x677A },
        { 0x78B3, 0x56BB },
        { 0x78B4, 0x49E9 },
        { 0x78B9, 0x677B },
        { 0x78BE, 0x52EA },
        { 0x78C1, 0x4AC4 },
        { 0x78C5, 0x48F4 },
        { 0x78C9, 0x677F },
        { 0x78CA, 0x50D9 },
        { 0x78CB, 0x4AE7 },
        { 0x78D0, 0x536D },
        { 0x78D4, 0x677D },
        { 0x78D5, 0x5064 },
        { 0x78D9, 0x677E },
        { 0x78E8, 0x52A4 },
        { 0x78EC, 0x6781 },
        { 0x78F2, 0x6782 },
        { 0x78F4, 0x6784 },
        { 0x78F7, 0x5177 },
        { 0x78FA, 0x4E67 },
        { 0x7901, 0x4F58 },
        { 0x7905, 0x6783 },
        { 0x7913, 0x6785 },
        { 0x791E, 0x6787 },
        { 0x7924, 0x6786 },
        { 0x7934, 0x6788 },
        { 0x793A, 0x55BD },
        { 0x793B, 0x66E9 },
        { 0x793C, 0x50F0 },
        { 0x793E, 0x5588 },
        { 0x7940, 0x66EA },
        { 0x7941, 0x53ED },
        { 0x7946, 0x66EB },
        { 0x7948, 0x53EC },
        { 0x7949, 0x66EC },
        { 0x7953, 0x66EF },
        { 0x7956, 0x5C87 },
        { 0x7957, 0x66F2 },
        { 0x795A, 0x66F0 },
        { 0x795B, 0x66ED },
        { 0x795C, 0x66EE },
        { 0x795D, 0x5C43 },
        { 0x795E, 0x5592 },
        { 0x795F, 0x568F },
        { 0x7960, 0x66F3 },
        { 0x7962, 0x66F1 },
        { 0x7965, 0x588A },
        { 0x7967, 0x66F5 },
        { 0x7968, 0x53B0 },
        { 0x796D, 0x4EBF },
        { 0x796F, 0x66F4 },
        { 0x7977, 0x4B5B },
        { 0x7978, 0x4E97 },
        { 0x797A, 0x66F6 },
        { 0x7980, 0x5D98 },
        { 0x7981, 0x4F9C },
        { 0x7984, 0x51BA },
        { 0x7985, 0x66F7 },
        { 0x798A, 0x66F8 },
        { 0x798F, 0x4CA2 },
        { 0x799A, 0x66F9 },
        { 0x79A7, 0x66FA },
        { 0x79B3, 0x66FB },
        { 0x79B9, 0x5A8E },
        { 0x79BA, 0x5CAD },
        { 0x79BB, 0x50EA },
        { 0x79BD, 0x547D },
        { 0x79BE, 0x4DCB },
        { 0x79C0, 0x58E2 },
        { 0x79C1, 0x565D },
        { 0x79C3, 0x575A },
        { 0x79C6, 0x4CD0 },
        { 0x79C9, 0x499D },
        { 0x79CB, 0x5490 },
        { 0x79CD, 0x5BD5 },
        { 0x79D1, 0x5066 },
        { 0x79D2, 0x528C },
        { 0x79D5, 0x6896 },
        { 0x79D8, 0x5278 },
        { 0x79DF, 0x5C83 },
        { 0x79E3, 0x6898 },
        { 0x79E4, 0x4A73 },
        { 0x79E6, 0x5478 },
        { 0x79E7, 0x598E },
        { 0x79E9, 0x5BC7 },
        { 0x79EB, 0x6899 },
        { 0x79ED, 0x6897 },
        { 0x79EF, 0x4E9E },
        { 0x79F0, 0x4A66 },
        { 0x79F8, 0x4F75 },
        { 0x79FB, 0x59C5 },
        { 0x79FD, 0x4E81 },
        { 0x7A00, 0x5841 },
        { 0x7A02, 0x689D },
        { 0x7A03, 0x689C },
        { 0x7A06, 0x689A },
        { 0x7A0B, 0x4A6C },
        { 0x7A0D, 0x5574 },
        { 0x7A0E, 0x5650 },
        { 0x7A14, 0x689F },
        { 0x7A17, 0x48DD },
        { 0x7A1A, 0x5BC8 },
        { 0x7A1E, 0x689E },
        { 0x7A20, 0x4A8E },
        { 0x7A23, 0x6BD4 },
        { 0x7A33, 0x57C7 },
        { 0x7A37, 0x68A1 },
        { 0x7A39, 0x68A0 },
        { 0x7A3B, 0x4B5E },
        { 0x7A3C, 0x4ED9 },
        { 0x7A3D, 0x4E9D },
        { 0x7A3F, 0x4CE4 },
        { 0x7A46, 0x52C1 },
        { 0x7A51, 0x68A2 },
        { 0x7A57, 0x568C },
        { 0x7A70, 0x68A5 },
        { 0x7A74, 0x5948 },
        { 0x7A76, 0x4FBE },
        { 0x7A77, 0x548F },
        { 0x7A78, 0x6956 },
        { 0x7A79, 0x6957 },
        { 0x7A7A, 0x5075 },
        { 0x7A7F, 0x4AA8 },
        { 0x7A80, 0x6958 },
        { 0x7A81, 0x575B },
        { 0x7A83, 0x5474 },
        { 0x7A84, 0x5B4D },
        { 0x7A86, 0x6959 },
        { 0x7A88, 0x695A },
        { 0x7A8D, 0x546F },
        { 0x7A91, 0x59A3 },
        { 0x7A92, 0x5BCE },
        { 0x7A95, 0x695B },
        { 0x7A96, 0x4F71 },
        { 0x7A97, 0x4AAF },
        { 0x7A98, 0x4FBC },
        { 0x7A9C, 0x4ADB },
        { 0x7A9D, 0x57D0 },
        { 0x7A9F, 0x507F },
        { 0x7AA0, 0x695D },
        { 0x7AA5, 0x509B },
        { 0x7AA6, 0x695C },
        { 0x7AA8, 0x695F },
        { 0x7AAC, 0x695E },
        { 0x7AAD, 0x6960 },
        { 0x7AB3, 0x6961 },
        { 0x7ABF, 0x519F },
        { 0x7ACB, 0x5142 },
        { 0x7AD6, 0x55F9 },
        { 0x7AD9, 0x5B5E },
        { 0x7ADE, 0x4FB9 },
        { 0x7ADF, 0x4FB8 },
        { 0x7AE0, 0x5B62 },
        { 0x7AE3, 0x5042 },
        { 0x7AE5, 0x574F },
        { 0x7AE6, 0x6955 },
        { 0x7AED, 0x4F7F },
        { 0x7AEF, 0x4BCA },
        { 0x7AF9, 0x5BF0 },
        { 0x7AFA, 0x6A63 },
        { 0x7AFD, 0x6A64 },
        { 0x7AFF, 0x4CCC },
        { 0x7B03, 0x6A66 },
        { 0x7B04, 0x6A67 },
        { 0x7B06, 0x48C9 },
        { 0x7B08, 0x6A65 },
        { 0x7B0A, 0x6A69 },
        { 0x7B0B, 0x5692 },
        { 0x7B0F, 0x6A6B },
        { 0x7B11, 0x58A5 },
        { 0x7B14, 0x496A },
        { 0x7B15, 0x6A68 },
        { 0x7B19, 0x6A6F },
        { 0x7B1B, 0x4B71 },
        { 0x7B1E, 0x6A77 },
        { 0x7B20, 0x6A72 },
        { 0x7B24, 0x6A74 },
        { 0x7B25, 0x6A73 },
        { 0x7B26, 0x4C9C },
        { 0x7B28, 0x495F },
        { 0x7B2A, 0x6A6E },
        { 0x7B2B, 0x6A6A },
        { 0x7B2C, 0x4B7A },
        { 0x7B2E, 0x6A70 },
        { 0x7B31, 0x6A71 },
        { 0x7B33, 0x6A75 },
        { 0x7B38, 0x6A6D },
        { 0x7B3A, 0x4EE2 },
        { 0x7B3C, 0x519E },
        { 0x7B3E, 0x6A76 },
        { 0x7B45, 0x6A7A },
        { 0x7B47, 0x6A6C },
        { 0x7B49, 0x4B68 },
        { 0x7B4B, 0x4F8F },
        { 0x7B4C, 0x6A7C },
        { 0x7B4F, 0x4C44 },
        { 0x7B50, 0x5091 },
        { 0x7B51, 0x5BFD },
        { 0x7B52, 0x5752 },
        { 0x7B54, 0x4AEF },
        { 0x7B56, 0x49DE },
        { 0x7B58, 0x6A78 },
        { 0x7B5A, 0x6A79 },
        { 0x7B5B, 0x5558 },
        { 0x7B5D, 0x6A7D },
        { 0x7B60, 0x6A7E },
        { 0x7B62, 0x6A82 },
        { 0x7B6E, 0x6A7F },
        { 0x7B71, 0x6A84 },
        { 0x7B72, 0x6A83 },
        { 0x7B75, 0x6A7B },
        { 0x7B77, 0x508B },
        { 0x7B79, 0x4A90 },
        { 0x7B7B, 0x6A81 },
        { 0x7B7E, 0x5449 },
        { 0x7B80, 0x4EF1 },
        { 0x7B85, 0x6A8C },
        { 0x7B8D, 0x4D5F },
        { 0x7B90, 0x6A85 },
        { 0x7B94, 0x49AC },
        { 0x7B95, 0x4E9F },
        { 0x7B97, 0x5684 },
        { 0x7B9C, 0x6A8E },
        { 0x7B9D, 0x6A8A },
        { 0x7BA1, 0x4D7C },
        { 0x7BA2, 0x6A8F },
        { 0x7BA6, 0x6A86 },
        { 0x7BA7, 0x6A87 },
        { 0x7BA8, 0x6A8B },
        { 0x7BA9, 0x51E0 },
        { 0x7BAA, 0x6A8D },
        { 0x7BAB, 0x6A90 },
        { 0x7BAC, 0x6A89 },
        { 0x7BAD, 0x4EFC },
        { 0x7BB1, 0x5885 },
        { 0x7BB4, 0x6A91 },
        { 0x7BB8, 0x6A88 },
        { 0x7BC1, 0x6A93 },
        { 0x7BC6, 0x5C4D },
        { 0x7BC7, 0x53A9 },
        { 0x7BCC, 0x6A94 },
        { 0x7BD1, 0x6A92 },
        { 0x7BD3, 0x51A7 },
        { 0x7BD9, 0x4CDC },
        { 0x7BDA, 0x6A96 },
        { 0x7BDD, 0x6A95 },
        { 0x7BE1, 0x4ADA },
        { 0x7BE5, 0x6A97 },
        { 0x7BE6, 0x6A98 },
        { 0x7BEA, 0x6A99 },
        { 0x7BEE, 0x50B9 },
        { 0x7BF1, 0x50E8 },
        { 0x7BF7, 0x5392 },
        { 0x7BFC, 0x6A9C },
        { 0x7BFE, 0x6A9B },
        { 0x7C07, 0x4AD7 },
        { 0x7C0B, 0x6A9F },
        { 0x7C0C, 0x6A9A },
        { 0x7C0F, 0x6A9D },
        { 0x7C16, 0x6A9E },
        { 0x7C1F, 0x6AA0 },
        { 0x7C26, 0x6AA2 },
        { 0x7C27, 0x4E69 },
        { 0x7C2A, 0x6AA1 },
        { 0x7C38, 0x6AA3 },
        { 0x7C3F, 0x49BD },
        { 0x7C40, 0x6AA5 },
        { 0x7C41, 0x6AA4 },
        { 0x7C4D, 0x4EAD },
        { 0x7C73, 0x5277 },
        { 0x7C74, 0x5D82 },
        { 0x7C7B, 0x50DF },
        { 0x7C7C, 0x6ACB },
        { 0x7C7D, 0x5C71 },
        { 0x7C89, 0x4C7B },
        { 0x7C91, 0x6ACD },
        { 0x7C92, 0x5143 },
        { 0x7C95, 0x53C8 },
        { 0x7C97, 0x4AD5 },
        { 0x7C98, 0x5B53 },
        { 0x7C9C, 0x6ACF },
        { 0x7C9D, 0x6ACE },
        { 0x7C9E, 0x6AD0 },
        { 0x7C9F, 0x567A },
        { 0x7CA2, 0x6AD1 },
        { 0x7CA4, 0x5AC0 },
        { 0x7CA5, 0x5BDF },
        { 0x7CAA, 0x4C81 },
        { 0x7CAE, 0x5158 },
        { 0x7CB1, 0x515B },
        { 0x7CB2, 0x6AD2 },
        { 0x7CB3, 0x4FAB },
        { 0x7CB9, 0x4AE1 },
        { 0x7CBC, 0x6AD3 },
        { 0x7CBD, 0x6AD4 },
        { 0x7CBE, 0x4FAA },
        { 0x7CC1, 0x6AD5 },
        { 0x7CC5, 0x6ADA },
        { 0x7CC7, 0x6AD6 },
        { 0x7CC8, 0x6AD9 },
        { 0x7CCA, 0x4DFC },
        { 0x7CCC, 0x6AD7 },
        { 0x7CCD, 0x6AD8 },
        { 0x7CD5, 0x4CE1 },
        { 0x7CD6, 0x56C6 },
        { 0x7CD7, 0x6ADB },
        { 0x7CD9, 0x49D9 },
        { 0x7CDC, 0x5273 },
        { 0x7CDF, 0x5AE2 },
        { 0x7CE0, 0x5057 },
        { 0x7CE8, 0x6ADC },
        { 0x7CEF, 0x5354 },
        { 0x7CF8, 0x6AE8 },
        { 0x7CFB, 0x5855 },
        { 0x7D0A, 0x57C8 },
        { 0x7D20, 0x5678 },
        { 0x7D22, 0x5698 },
        { 0x7D27, 0x4F95 },
        { 0x7D2B, 0x5C6F },
        { 0x7D2F, 0x50DA },
        { 0x7D6E, 0x58F4 },
        { 0x7D77, 0x6AE9 },
        { 0x7DA6, 0x6AEA },
        { 0x7DAE, 0x6AEB },
        { 0x7E3B, 0x6C84 },
        { 0x7E41, 0x4C51 },
        { 0x7E47, 0x6AEC },
        { 0x7E82, 0x5C8C },
        { 0x7E9B, 0x6AED },
        { 0x7E9F, 0x63F8 },
        { 0x7EA0, 0x4FBF },
        { 0x7EA1, 0x63F9 },
        { 0x7EA2, 0x4DEB },
        { 0x7EA3, 0x63FA },
        { 0x7EA4, 0x586B },
        { 0x7EA5, 0x63FB },
        { 0x7EA6, 0x5ABB },
        { 0x7EA7, 0x4EB5 },
        { 0x7EA8, 0x63FC },
        { 0x7EA9, 0x63FD },
        { 0x7EAA, 0x4ECC },
        { 0x7EAB, 0x54D1 },
        { 0x7EAC, 0x57B2 },
        { 0x7EAD, 0x6441 },
        { 0x7EAF, 0x4ABE },
        { 0x7EB0, 0x6442 },
        { 0x7EB1, 0x5554 },
        { 0x7EB2, 0x4CD8 },
        { 0x7EB3, 0x52C8 },
        { 0x7EB5, 0x5C7D },
        { 0x7EB6, 0x51D9 },
        { 0x7EB7, 0x4C77 },
        { 0x7EB8, 0x5BBC },
        { 0x7EB9, 0x57C5 },
        { 0x7EBA, 0x4C64 },
        { 0x7EBD, 0x5346 },
        { 0x7EBE, 0x6443 },
        { 0x7EBF, 0x587F },
        { 0x7EC0, 0x6444 },
        { 0x7EC1, 0x6445 },
        { 0x7EC2, 0x6446 },
        { 0x7EC3, 0x5157 },
        { 0x7EC4, 0x5C8A },
        { 0x7EC5, 0x5591 },
        { 0x7EC6, 0x5858 },
        { 0x7EC7, 0x5BAE },
        { 0x7EC8, 0x5BD4 },
        { 0x7EC9, 0x6447 },
        { 0x7ECA, 0x48EC },
        { 0x7ECB, 0x6448 },
        { 0x7ECC, 0x6449 },
        { 0x7ECD, 0x557C },
        { 0x7ECE, 0x59EE },
        { 0x7ECF, 0x4FAC },
        { 0x7ED0, 0x644A },
        { 0x7ED1, 0x48F2 },
        { 0x7ED2, 0x54DD },
        { 0x7ED3, 0x4F82 },
        { 0x7ED4, 0x644B },
        { 0x7ED5, 0x54C5 },
        { 0x7ED7, 0x644C },
        { 0x7ED8, 0x4E87 },
        { 0x7ED9, 0x4CF7 },
        { 0x7EDA, 0x5944 },
        { 0x7EDB, 0x644D },
        { 0x7EDC, 0x51E6 },
        { 0x7EDD, 0x4FF7 },
        { 0x7EDE, 0x4F6A },
        { 0x7EDF, 0x5753 },
        { 0x7EE0, 0x644E },
        { 0x7EE1, 0x644F },
        { 0x7EE2, 0x4FED },
        { 0x7EE3, 0x58E4 },
        { 0x7EE5, 0x5688 },
        { 0x7EE6, 0x56CF },
        { 0x7EE7, 0x4ECB },
        { 0x7EE8, 0x6450 },
        { 0x7EE9, 0x4EA7 },
        { 0x7EEA, 0x58F6 },
        { 0x7EEB, 0x6451 },
        { 0x7EED, 0x58F7 },
        { 0x7EEE, 0x6452 },
        { 0x7EEF, 0x6453 },
        { 0x7EF0, 0x4AC1 },
        { 0x7EF1, 0x6454 },
        { 0x7EF2, 0x6455 },
        { 0x7EF3, 0x559F },
        { 0x7EF4, 0x57AB },
        { 0x7EF5, 0x5281 },
        { 0x7EF6, 0x6457 },
        { 0x7EF7, 0x4961 },
        { 0x7EF8, 0x4A92 },
        { 0x7EFA, 0x6458 },
        { 0x7EFB, 0x6459 },
        { 0x7EFC, 0x5C7B },
        { 0x7EFD, 0x5B60 },
        { 0x7EFE, 0x645A },
        { 0x7EFF, 0x51CB },
        { 0x7F00, 0x5C5A },
        { 0x7F01, 0x645B },
        { 0x7F02, 0x645C },
        { 0x7F03, 0x645D },
        { 0x7F04, 0x4EE9 },
        { 0x7F05, 0x5286 },
        { 0x7F06, 0x50C1 },
        { 0x7F07, 0x645E },
        { 0x7F08, 0x645F },
        { 0x7F09, 0x4EA8 },
        { 0x7F0B, 0x6460 },
        { 0x7F0C, 0x6461 },
        { 0x7F0D, 0x6456 },
        { 0x7F0E, 0x4BCF },
        { 0x7F0F, 0x6462 },
        { 0x7F11, 0x6463 },
        { 0x7F12, 0x6464 },
        { 0x7F13, 0x4E5A },
        { 0x7F14, 0x4B7E },
        { 0x7F15, 0x51C5 },
        { 0x7F16, 0x4981 },
        { 0x7F17, 0x6465 },
        { 0x7F18, 0x5AB4 },
        { 0x7F19, 0x6466 },
        { 0x7F1A, 0x4CBE },
        { 0x7F1B, 0x6468 },
        { 0x7F1C, 0x6467 },
        { 0x7F1D, 0x4C8D },
        { 0x7F1F, 0x6469 },
        { 0x7F20, 0x49F7 },
        { 0x7F21, 0x646A },
        { 0x7F22, 0x646B },
        { 0x7F23, 0x646C },
        { 0x7F24, 0x646D },
        { 0x7F25, 0x646E },
        { 0x7F26, 0x646F },
        { 0x7F27, 0x6470 },
        { 0x7F28, 0x5A47 },
        { 0x7F29, 0x5696 },
        { 0x7F2A, 0x6471 },
        { 0x7F2B, 0x6472 },
        { 0x7F2C, 0x6473 },
        { 0x7F2D, 0x6474 },
        { 0x7F2E, 0x5569 },
        { 0x7F2F, 0x6475 },
        { 0x7F30, 0x6476 },
        { 0x7F31, 0x6477 },
        { 0x7F32, 0x6478 },
        { 0x7F33, 0x6479 },
        { 0x7F34, 0x4F69 },
        { 0x7F35, 0x647A },
        { 0x7F36, 0x6A5E },
        { 0x7F38, 0x4CD6 },
        { 0x7F3A, 0x54B0 },
        { 0x7F42, 0x6A5F },
        { 0x7F44, 0x6A60 },
        { 0x7F45, 0x6A61 },
        { 0x7F50, 0x4D7E },
        { 0x7F51, 0x5799 },
        { 0x7F54, 0x5CE7 },
        { 0x7F55, 0x4DB0 },
        { 0x7F57, 0x51DD },
        { 0x7F58, 0x67B6 },
        { 0x7F5A, 0x4C43 },
        { 0x7F5F, 0x67B8 },
        { 0x7F61, 0x67B7 },
        { 0x7F62, 0x48D4 },
        { 0x7F68, 0x67BA },
        { 0x7F69, 0x5B76 },
        { 0x7F6A, 0x5C90 },
        { 0x7F6E, 0x5BC2 },
        { 0x7F71, 0x67BC },
        { 0x7F72, 0x55EF },
        { 0x7F74, 0x67BB },
        { 0x7F79, 0x67BD },
        { 0x7F7E, 0x67BF },
        { 0x7F81, 0x67BE },
        { 0x7F8A, 0x5993 },
        { 0x7F8C, 0x545C },
        { 0x7F8E, 0x5260 },
        { 0x7F94, 0x4CE0 },
        { 0x7F9A, 0x5188 },
        { 0x7F9D, 0x6AC5 },
        { 0x7F9E, 0x58DE },
        { 0x7F9F, 0x6AC6 },
        { 0x7FA1, 0x587B },
        { 0x7FA4, 0x54B9 },
        { 0x7FA7, 0x6AC7 },
        { 0x7FAF, 0x6AC8 },
        { 0x7FB0, 0x6AC9 },
        { 0x7FB2, 0x6ACA },
        { 0x7FB8, 0x5D9B },
        { 0x7FB9, 0x4CFD },
        { 0x7FBC, 0x6392 },
        { 0x7FBD, 0x5A91 },
        { 0x7FBF, 0x6ADF },
        { 0x7FC1, 0x57CB },
        { 0x7FC5, 0x4A82 },
        { 0x7FCA, 0x6954 },
        { 0x7FCC, 0x59ED },
        { 0x7FCE, 0x6AE0 },
        { 0x7FD4, 0x5889 },
        { 0x7FD5, 0x6AE1 },
        { 0x7FD8, 0x546C },
        { 0x7FDF, 0x4B74 },
        { 0x7FE0, 0x4AE3 },
        { 0x7FE1, 0x6AE3 },
        { 0x7FE5, 0x6AE2 },
        { 0x7FE6, 0x6AE4 },
        { 0x7FE9, 0x6AE5 },
        { 0x7FEE, 0x6AE6 },
        { 0x7FF0, 0x4DB1 },
        { 0x7FF1, 0x48BE },
        { 0x7FF3, 0x6AE7 },
        { 0x7FFB, 0x4C4D },
        { 0x7FFC, 0x59EC },
        { 0x8000, 0x59AA },
        { 0x8001, 0x50CE },
        { 0x8003, 0x505C },
        { 0x8004, 0x6643 },
        { 0x8005, 0x5B7F },
        { 0x8006, 0x65C7 },
        { 0x800B, 0x6994 },
        { 0x800C, 0x4BF7 },
        { 0x800D, 0x5643 },
        { 0x8010, 0x52CC },
        { 0x8012, 0x6988 },
        { 0x8014, 0x6989 },
        { 0x8015, 0x4CFA },
        { 0x8016, 0x698A },
        { 0x8017, 0x4DC3 },
        { 0x8018, 0x5AC4 },
        { 0x8019, 0x48D1 },
        { 0x801C, 0x698B },
        { 0x8020, 0x698C },
        { 0x8022, 0x698D },
        { 0x8025, 0x698E },
        { 0x8026, 0x698F },
        { 0x8027, 0x6990 },
        { 0x8028, 0x6992 },
        { 0x8029, 0x6991 },
        { 0x802A, 0x5375 },
        { 0x8031, 0x6993 },
        { 0x8033, 0x4BF9 },
        { 0x8035, 0x6995 },
        { 0x8036, 0x59AD },
        { 0x8037, 0x5FC6 },
        { 0x8038, 0x566A },
        { 0x803B, 0x4A7C },
        { 0x803D, 0x4B42 },
        { 0x803F, 0x4D42 },
        { 0x8042, 0x52F3 },
        { 0x8043, 0x6996 },
        { 0x8046, 0x6997 },
        { 0x804A, 0x5164 },
        { 0x804B, 0x519C },
        { 0x804C, 0x5BAF },
        { 0x804D, 0x6998 },
        { 0x8052, 0x6999 },
        { 0x8054, 0x514A },
        { 0x8058, 0x53B7 },
        { 0x805A, 0x4FDA },
        { 0x8069, 0x699A },
        { 0x806A, 0x4ACE },
        { 0x8071, 0x699B },
        { 0x807F, 0x6752 },
        { 0x8080, 0x6751 },
        { 0x8083, 0x5681 },
        { 0x8084, 0x59DD },
        { 0x8086, 0x5661 },
        { 0x8087, 0x5B78 },
        { 0x8089, 0x54E1 },
        { 0x808B, 0x50DE },
        { 0x808C, 0x4EA0 },
        { 0x8093, 0x6661 },
        { 0x8096, 0x58A3 },
        { 0x8098, 0x5BE1 },
        { 0x809A, 0x4BC6 },
        { 0x809B, 0x4CD7 },
        { 0x809C, 0x6660 },
        { 0x809D, 0x4CCD },
        { 0x809F, 0x665F },
        { 0x80A0, 0x4A46 },
        { 0x80A1, 0x4D69 },
        { 0x80A2, 0x5BAA },
        { 0x80A4, 0x4C95 },
        { 0x80A5, 0x4C6A },
        { 0x80A9, 0x4EE6 },
        { 0x80AA, 0x4C5E },
        { 0x80AB, 0x6666 },
        { 0x80AD, 0x6667 },
        { 0x80AE, 0x48B8 },
        { 0x80AF, 0x506F },
        { 0x80B1, 0x6665 },
        { 0x80B2, 0x5A9E },
        { 0x80B4, 0x6668 },
        { 0x80B7, 0x6669 },
        { 0x80BA, 0x4C6E },
        { 0x80BC, 0x6662 },
        { 0x80BD, 0x6664 },
        { 0x80BE, 0x5597 },
        { 0x80BF, 0x5BD6 },
        { 0x80C0, 0x5B6D },
        { 0x80C1, 0x58B1 },
        { 0x80C2, 0x666F },
        { 0x80C3, 0x57B7 },
        { 0x80C4, 0x6670 },
        { 0x80C6, 0x4B48 },
        { 0x80CC, 0x4953 },
        { 0x80CD, 0x6672 },
        { 0x80CE, 0x56A4 },
        { 0x80D6, 0x5376 },
        { 0x80D7, 0x6673 },
        { 0x80D9, 0x6671 },
        { 0x80DA, 0x537F },
        { 0x80DB, 0x666E },
        { 0x80DC, 0x55A3 },
        { 0x80DD, 0x6675 },
        { 0x80DE, 0x48FA },
        { 0x80E1, 0x4DF9 },
        { 0x80E4, 0x5CB6 },
        { 0x80E5, 0x6984 },
        { 0x80E7, 0x666A },
        { 0x80E8, 0x666B },
        { 0x80E9, 0x666C },
        { 0x80EA, 0x666D },
        { 0x80EB, 0x6676 },
        { 0x80EC, 0x63BF },
        { 0x80ED, 0x6679 },
        { 0x80EF, 0x5089 },
        { 0x80F0, 0x59C7 },
        { 0x80F1, 0x6677 },
        { 0x80F2, 0x667C },
        { 0x80F3, 0x4CEB },
        { 0x80F4, 0x6678 },
        { 0x80F6, 0x4F5A },
        { 0x80F8, 0x58D7 },
        { 0x80FA, 0x48B6 },
        { 0x80FC, 0x667D },
        { 0x80FD, 0x52DB },
        { 0x8102, 0x5BAB },
        { 0x8106, 0x4ADF },
        { 0x8109, 0x51F5 },
        { 0x810A, 0x4EB8 },
        { 0x810D, 0x667A },
        { 0x810E, 0x667B },
        { 0x810F, 0x5ADF },
        { 0x8110, 0x53E9 },
        { 0x8111, 0x52D3 },
        { 0x8112, 0x667F },
        { 0x8113, 0x5347 },
        { 0x8114, 0x5D96 },
        { 0x8116, 0x49B0 },
        { 0x8118, 0x6685 },
        { 0x811A, 0x4F65 },
        { 0x811E, 0x6683 },
        { 0x812C, 0x6684 },
        { 0x812F, 0x4CAB },
        { 0x8131, 0x5771 },
        { 0x8132, 0x6686 },
        { 0x8136, 0x6682 },
        { 0x8138, 0x5153 },
        { 0x813E, 0x53A1 },
        { 0x8146, 0x56F2 },
        { 0x8148, 0x6687 },
        { 0x814A, 0x50AF },
        { 0x814B, 0x59B7 },
        { 0x814C, 0x6688 },
        { 0x8150, 0x4CAE },
        { 0x8151, 0x4CAC },
        { 0x8153, 0x6689 },
        { 0x8154, 0x545B },
        { 0x8155, 0x5794 },
        { 0x8159, 0x668B },
        { 0x815A, 0x668C },
        { 0x8160, 0x668E },
        { 0x8165, 0x58C7 },
        { 0x8167, 0x6693 },
        { 0x8169, 0x668F },
        { 0x816D, 0x6692 },
        { 0x816E, 0x54F8 },
        { 0x8170, 0x599D },
        { 0x8171, 0x668D },
        { 0x8174, 0x668A },
        { 0x8179, 0x4CB8 },
        { 0x817A, 0x5879 },
        { 0x817B, 0x52E4 },
        { 0x817C, 0x6690 },
        { 0x817D, 0x6691 },
        { 0x817E, 0x56D9 },
        { 0x817F, 0x5768 },
        { 0x8180, 0x48F1 },
        { 0x8182, 0x6697 },
        { 0x8188, 0x6696 },
        { 0x818A, 0x49B1 },
        { 0x818F, 0x4CDF },
        { 0x8191, 0x6698 },
        { 0x8198, 0x498D },
        { 0x819B, 0x56C4 },
        { 0x819C, 0x52A3 },
        { 0x819D, 0x5845 },
        { 0x81A3, 0x669A },
        { 0x81A6, 0x66A1 },
        { 0x81A8, 0x5393 },
        { 0x81AA, 0x669B },
        { 0x81B3, 0x5565 },
        { 0x81BA, 0x61DE },
        { 0x81BB, 0x669F },
        { 0x81C0, 0x576E },
        { 0x81C1, 0x66A0 },
        { 0x81C2, 0x497B },
        { 0x81C3, 0x5A57 },
        { 0x81C6, 0x59DB },
        { 0x81CA, 0x669E },
        { 0x81CC, 0x669C },
        { 0x81E3, 0x4A5C },
        { 0x81E7, 0x65AF },
        { 0x81EA, 0x5C74 },
        { 0x81EC, 0x6AAA },
        { 0x81ED, 0x4A95 },
        { 0x81F3, 0x5BC0 },
        { 0x81F4, 0x5BC1 },
        { 0x81FB, 0x5B8A },
        { 0x81FC, 0x4FC9 },
        { 0x81FE, 0x6AA6 },
        { 0x8200, 0x59A7 },
        { 0x8201, 0x6AA7 },
        { 0x8202, 0x6AA8 },
        { 0x8204, 0x6AA9 },
        { 0x8205, 0x4FCA },
        { 0x8206, 0x5A7F },
        { 0x820C, 0x5581 },
        { 0x820D, 0x5582 },
        { 0x8210, 0x6A62 },
        { 0x8212, 0x55E5 },
        { 0x8214, 0x56F1 },
        { 0x821B, 0x61B5 },
        { 0x821C, 0x5654 },
        { 0x821E, 0x57E7 },
        { 0x821F, 0x5BDA },
        { 0x8221, 0x6AAC },
        { 0x8222, 0x6AAD },
        { 0x8223, 0x6AAE },
        { 0x8228, 0x6AB1 },
        { 0x822A, 0x4DBC },
        { 0x822B, 0x6AB2 },
        { 0x822C, 0x48E2 },
        { 0x822D, 0x6AAF },
        { 0x822F, 0x6AB0 },
        { 0x8230, 0x4F42 },
        { 0x8231, 0x49D4 },
        { 0x8233, 0x6AB5 },
        { 0x8234, 0x6AB6 },
        { 0x8235, 0x4BE5 },
        { 0x8236, 0x49AF },
        { 0x8237, 0x586F },
        { 0x8238, 0x6AB3 },
        { 0x8239, 0x4AAB },
        { 0x823B, 0x6AB4 },
        { 0x823E, 0x6AB7 },
        { 0x8244, 0x6AB8 },
        { 0x8247, 0x5747 },
        { 0x8249, 0x6AB9 },
        { 0x824B, 0x6ABA },
        { 0x824F, 0x6ABB },
        { 0x8258, 0x5672 },
        { 0x825A, 0x6ABC },
        { 0x825F, 0x6ABD },
        { 0x8268, 0x6ABE },
        { 0x826E, 0x6ADD },
        { 0x826F, 0x515C },
        { 0x8270, 0x4EE7 },
        { 0x8272, 0x554B },
        { 0x8273, 0x597E },
        { 0x8274, 0x6396 },
        { 0x8279, 0x5EB2 },
        { 0x827A, 0x59D4 },
        { 0x827D, 0x5EB3 },
        { 0x827E, 0x48AB },
        { 0x827F, 0x5EB4 },
        { 0x8282, 0x4F7A },
        { 0x8284, 0x5EB8 },
        { 0x8288, 0x5CC1 },
        { 0x828A, 0x5EB6 },
        { 0x828B, 0x5A94 },
        { 0x828D, 0x5576 },
        { 0x828E, 0x5EB9 },
        { 0x828F, 0x5EB5 },
        { 0x8291, 0x5EBA },
        { 0x8292, 0x5242 },
        { 0x8297, 0x5EBB },
        { 0x8298, 0x5EC4 },
        { 0x8299, 0x5EBC },
        { 0x829C, 0x57DE },
        { 0x829D, 0x5BA4 },
        { 0x829F, 0x5ECE },
        { 0x82A1, 0x5ECC },
        { 0x82A4, 0x5ED1 },
        { 0x82A5, 0x4F87 },
        { 0x82A6, 0x51AA },
        { 0x82A8, 0x5EB7 },
        { 0x82A9, 0x5ECA },
        { 0x82AA, 0x5ECD },
        { 0x82AB, 0x5EBD },
        { 0x82AC, 0x4C72 },
        { 0x82AD, 0x48C4 },
        { 0x82AE, 0x5EC6 },
        { 0x82AF, 0x58BD },
        { 0x82B0, 0x5EC0 },
        { 0x82B1, 0x4E48 },
        { 0x82B3, 0x4C5C },
        { 0x82B4, 0x5ECB },
        { 0x82B7, 0x5EC5 },
        { 0x82B8, 0x5EBE },
        { 0x82B9, 0x547B },
        { 0x82BD, 0x595F },
        { 0x82BE, 0x5EBF },
        { 0x82C1, 0x5EC9 },
        { 0x82C4, 0x5ECF },
        { 0x82C7, 0x57AC },
        { 0x82C8, 0x5EC1 },
        { 0x82CA, 0x5EC2 },
        { 0x82CB, 0x5EC7 },
        { 0x82CC, 0x5EC8 },
        { 0x82CD, 0x49D3 },
        { 0x82CE, 0x5ED0 },
        { 0x82CF, 0x5675 },
        { 0x82D1, 0x5AB6 },
        { 0x82D2, 0x5EDA },
        { 0x82D3, 0x5EDE },
        { 0x82D4, 0x56A5 },
        { 0x82D5, 0x5EE5 },
        { 0x82D7, 0x5288 },
        { 0x82D8, 0x5EDB },
        { 0x82DB, 0x5061 },
        { 0x82DC, 0x5ED8 },
        { 0x82DE, 0x48F9 },
        { 0x82DF, 0x4D56 },
        { 0x82E0, 0x5EE4 },
        { 0x82E1, 0x5ED2 },
        { 0x82E3, 0x5EC3 },
        { 0x82E4, 0x5ED5 },
        { 0x82E5, 0x54F3 },
        { 0x82E6, 0x5081 },
        { 0x82EB, 0x555B },
        { 0x82EF, 0x495D },
        { 0x82F1, 0x5A42 },
        { 0x82F4, 0x5ED9 },
        { 0x82F7, 0x5ED4 },
        { 0x82F9, 0x53BA },
        { 0x82FB, 0x5EDD },
        { 0x8301, 0x5C62 },
        { 0x8302, 0x524F },
        { 0x8303, 0x4C56 },
        { 0x8304, 0x5471 },
        { 0x8305, 0x5249 },
        { 0x8306, 0x5EE1 },
        { 0x8307, 0x5ED7 },
        { 0x8308, 0x5EEA },
        { 0x8309, 0x5ED3 },
        { 0x830C, 0x5EDC },
        { 0x830E, 0x4FA4 },
        { 0x830F, 0x5ED6 },
        { 0x8311, 0x5EDF },
        { 0x8314, 0x5EE2 },
        { 0x8315, 0x5EE3 },
        { 0x8317, 0x5EF7 },
        { 0x831A, 0x5EE0 },
        { 0x831B, 0x5F42 },
        { 0x831C, 0x5EE6 },
        { 0x8327, 0x4EEA },
        { 0x8328, 0x4AC3 },
        { 0x832B, 0x5243 },
        { 0x832C, 0x49E6 },
        { 0x832D, 0x5EF9 },
        { 0x832F, 0x5EF1 },
        { 0x8331, 0x5EEE },
        { 0x8333, 0x5EFB },
        { 0x8334, 0x5EED },
        { 0x8335, 0x59EF },
        { 0x8336, 0x49E7 },
        { 0x8338, 0x54D6 },
        { 0x8339, 0x54E2 },
        { 0x833A, 0x5EFA },
        { 0x833C, 0x5EEC },
        { 0x8340, 0x5EF6 },
        { 0x8343, 0x5EF4 },
        { 0x8346, 0x4FA2 },
        { 0x8347, 0x5EF3 },
        { 0x8349, 0x49DC },
        { 0x834F, 0x5EF2 },
        { 0x8350, 0x4EF5 },
        { 0x8351, 0x5EE7 },
        { 0x8352, 0x4E64 },
        { 0x8354, 0x50F2 },
        { 0x835A, 0x4ED3 },
        { 0x835B, 0x5EE8 },
        { 0x835C, 0x5EE9 },
        { 0x835E, 0x5EF0 },
        { 0x835F, 0x5EF5 },
        { 0x8360, 0x5EF8 },
        { 0x8361, 0x4B54 },
        { 0x8363, 0x54D8 },
        { 0x8364, 0x4E88 },
        { 0x8365, 0x5EFD },
        { 0x8366, 0x5EFC },
        { 0x8367, 0x5A4B },
        { 0x8368, 0x5F41 },
        { 0x8369, 0x5F43 },
        { 0x836A, 0x5F45 },
        { 0x836B, 0x59F0 },
        { 0x836C, 0x5F44 },
        { 0x836D, 0x5F46 },
        { 0x836E, 0x5F47 },
        { 0x836F, 0x59A8 },
        { 0x8377, 0x4DC8 },
        { 0x8378, 0x5F49 },
        { 0x837B, 0x5F56 },
        { 0x837C, 0x5F51 },
        { 0x837D, 0x5F54 },
        { 0x8385, 0x5F50 },
        { 0x8386, 0x53CD },
        { 0x8389, 0x50F1 },
        { 0x838E, 0x554F },
        { 0x8392, 0x5EEB },
        { 0x8393, 0x5F4E },
        { 0x8398, 0x5F57 },
        { 0x839B, 0x5EEF },
        { 0x839C, 0x5F4F },
        { 0x839E, 0x5F58 },
        { 0x83A0, 0x5F4C },
        { 0x83A8, 0x5F59 },
        { 0x83A9, 0x5F53 },
        { 0x83AA, 0x5F4D },
        { 0x83AB, 0x52A9 },
        { 0x83B0, 0x5F48 },
        { 0x83B1, 0x50B2 },
        { 0x83B2, 0x514B },
        { 0x83B3, 0x5F4A },
        { 0x83B4, 0x5F4B },
        { 0x83B6, 0x5F52 },
        { 0x83B7, 0x4E92 },
        { 0x83B8, 0x5F55 },
        { 0x83B9, 0x5A48 },
        { 0x83BA, 0x5F5A },
        { 0x83BC, 0x5F5B },
        { 0x83BD, 0x5247 },
        { 0x83C0, 0x5F72 },
        { 0x83C1, 0x5F5C },
        { 0x83C5, 0x5F71 },
        { 0x83C7, 0x4D5D },
        { 0x83CA, 0x4FD4 },
        { 0x83CC, 0x4FF9 },
        { 0x83CF, 0x4DC9 },
        { 0x83D4, 0x5F6A },
        { 0x83D6, 0x5F65 },
        { 0x83D8, 0x5F5F },
        { 0x83DC, 0x49CA },
        { 0x83DD, 0x5F63 },
        { 0x83DF, 0x5F6B },
        { 0x83E0, 0x49A3 },
        { 0x83E1, 0x5F75 },
        { 0x83E5, 0x5F5E },
        { 0x83E9, 0x53CF },
        { 0x83EA, 0x5F70 },
        { 0x83F0, 0x5F74 },
        { 0x83F1, 0x5183 },
        { 0x83F2, 0x4C66 },
        { 0x83F8, 0x5F6E },
        { 0x83F9, 0x5F6F },
        { 0x83FD, 0x5F64 },
        { 0x8401, 0x5F5D },
        { 0x8403, 0x5F6D },
        { 0x8404, 0x56D0 },
        { 0x8406, 0x5F69 },
        { 0x840B, 0x5F62 },
        { 0x840C, 0x5268 },
        { 0x840D, 0x53BB },
        { 0x840E, 0x57AD },
        { 0x840F, 0x5F6C },
        { 0x8411, 0x5F68 },
        { 0x8418, 0x5F61 },
        { 0x841C, 0x5F66 },
        { 0x841D, 0x51DB },
        { 0x8424, 0x5A49 },
        { 0x8425, 0x5A4A },
        { 0x8426, 0x5F73 },
        { 0x8427, 0x5895 },
        { 0x8428, 0x54F7 },
        { 0x8431, 0x5F87 },
        { 0x8438, 0x5F67 },
        { 0x843C, 0x5F81 },
        { 0x843D, 0x51E3 },
        { 0x8446, 0x5F82 },
        { 0x8451, 0x5F77 },
        { 0x8457, 0x5BF7 },
        { 0x8459, 0x5F79 },
        { 0x845A, 0x5F78 },
        { 0x845B, 0x4CEF },
        { 0x845C, 0x5F76 },
        { 0x8461, 0x53CE },
        { 0x8463, 0x4BAC },
        { 0x8469, 0x5F83 },
        { 0x846B, 0x4DF8 },
        { 0x846C, 0x5AE0 },
        { 0x846D, 0x5F88 },
        { 0x8471, 0x4ACF },
        { 0x8473, 0x5F7A },
        { 0x8475, 0x509C },
        { 0x8476, 0x5F84 },
        { 0x8478, 0x5F7F },
        { 0x847A, 0x5F7D },
        { 0x8482, 0x4B79 },
        { 0x8487, 0x5F7B },
        { 0x8488, 0x5F7C },
        { 0x8489, 0x5F7E },
        { 0x848B, 0x4F4F },
        { 0x848C, 0x5F85 },
        { 0x848E, 0x5F86 },
        { 0x8497, 0x5F96 },
        { 0x8499, 0x5269 },
        { 0x849C, 0x5683 },
        { 0x84A1, 0x5F93 },
        { 0x84AF, 0x5CE0 },
        { 0x84B2, 0x53D0 },
        { 0x84B4, 0x5F95 },
        { 0x84B8, 0x5B95 },
        { 0x84B9, 0x5F94 },
        { 0x84BA, 0x5F91 },
        { 0x84BD, 0x5F8D },
        { 0x84BF, 0x5F90 },
        { 0x84C1, 0x5F89 },
        { 0x84C4, 0x58ED },
        { 0x84C9, 0x54D7 },
        { 0x84CA, 0x5F8F },
        { 0x84CD, 0x5F8A },
        { 0x84D0, 0x5F8B },
        { 0x84D1, 0x5693 },
        { 0x84D3, 0x5F8E },
        { 0x84D6, 0x496D },
        { 0x84DD, 0x50B5 },
        { 0x84DF, 0x4EBA },
        { 0x84E0, 0x5F92 },
        { 0x84E3, 0x5F98 },
        { 0x84E5, 0x5F97 },
        { 0x84E6, 0x5F8C },
        { 0x84EC, 0x538F },
        { 0x84F0, 0x5F9C },
        { 0x84FC, 0x5FA3 },
        { 0x84FF, 0x5FA2 },
        { 0x850C, 0x5F99 },
        { 0x8511, 0x5290 },
        { 0x8513, 0x51FA },
        { 0x8517, 0x5B82 },
        { 0x851A, 0x57B4 },
        { 0x851F, 0x5F9E },
        { 0x8521, 0x49CB },
        { 0x852B, 0x52E7 },
        { 0x852C, 0x55DE },
        { 0x8537, 0x545E },
        { 0x8538, 0x5F9B },
        { 0x8539, 0x5F9D },
        { 0x853A, 0x5F9F },
        { 0x853B, 0x5FA1 },
        { 0x853C, 0x48A9 },
        { 0x853D, 0x496E },
        { 0x8543, 0x5FAB },
        { 0x8548, 0x5FA5 },
        { 0x8549, 0x4F56 },
        { 0x854A, 0x54EE },
        { 0x8556, 0x5FA0 },
        { 0x8559, 0x5FA4 },
        { 0x855E, 0x5FA8 },
        { 0x8564, 0x5FA7 },
        { 0x8568, 0x5FA6 },
        { 0x8572, 0x5FAC },
        { 0x8574, 0x5ACB },
        { 0x8579, 0x5FB2 },
        { 0x857A, 0x5FA9 },
        { 0x857B, 0x5FAD },
        { 0x857E, 0x50D8 },
        { 0x8584, 0x4941 },
        { 0x8585, 0x5FB5 },
        { 0x8587, 0x5FB0 },
        { 0x858F, 0x5FB1 },
        { 0x859B, 0x5946 },
        { 0x859C, 0x5FB4 },
        { 0x85A4, 0x5FAE },
        { 0x85A8, 0x5FAF },
        { 0x85AA, 0x58BC },
        { 0x85AE, 0x5FB3 },
        { 0x85AF, 0x55EC },
        { 0x85B0, 0x5FB8 },
        { 0x85B7, 0x5FB7 },
        { 0x85B9, 0x5FB6 },
        { 0x85C1, 0x5FBA },
        { 0x85C9, 0x4F86 },
        { 0x85CF, 0x49D7 },
        { 0x85D0, 0x528B },
        { 0x85D3, 0x5FB9 },
        { 0x85D5, 0x535A },
        { 0x85DC, 0x5FBB },
        { 0x85E4, 0x56D8 },
        { 0x85E9, 0x4C4A },
        { 0x85FB, 0x5AE4 },
        { 0x85FF, 0x5FBC },
        { 0x8605, 0x5FBE },
        { 0x8611, 0x52A1 },
        { 0x8616, 0x5FC0 },
        { 0x8627, 0x5FBD },
        { 0x8629, 0x5FBF },
        { 0x8638, 0x5B5A },
        { 0x863C, 0x5FC1 },
        { 0x864D, 0x69AD },
        { 0x864E, 0x4E42 },
        { 0x864F, 0x51B1 },
        { 0x8650, 0x5350 },
        { 0x8651, 0x51C6 },
        { 0x8654, 0x69AE },
        { 0x865A, 0x58E8 },
        { 0x865E, 0x5A7D },
        { 0x8662, 0x665D },
        { 0x866B, 0x4A87 },
        { 0x866C, 0x69AF },
        { 0x866E, 0x69B0 },
        { 0x8671, 0x55AC },
        { 0x8679, 0x4DE6 },
        { 0x867A, 0x69B2 },
        { 0x867B, 0x69B4 },
        { 0x867C, 0x69B3 },
        { 0x867D, 0x5685 },
        { 0x867E, 0x585A },
        { 0x867F, 0x69B1 },
        { 0x8680, 0x55B3 },
        { 0x8681, 0x59CE },
        { 0x8682, 0x51EB },
        { 0x868A, 0x57C2 },
        { 0x868B, 0x69B7 },
        { 0x868C, 0x48F5 },
        { 0x868D, 0x69B6 },
        { 0x8693, 0x69BD },
        { 0x8695, 0x49CE },
        { 0x869C, 0x5961 },
        { 0x869D, 0x69B9 },
        { 0x86A3, 0x69BB },
        { 0x86A4, 0x5AE8 },
        { 0x86A7, 0x69BA },
        { 0x86A8, 0x69B5 },
        { 0x86A9, 0x69BE },
        { 0x86AA, 0x69BC },
        { 0x86AC, 0x69B8 },
        { 0x86AF, 0x69C6 },
        { 0x86B0, 0x69C3 },
        { 0x86B1, 0x69C5 },
        { 0x86B4, 0x69C9 },
        { 0x86B5, 0x69C1 },
        { 0x86B6, 0x69BF },
        { 0x86BA, 0x69C4 },
        { 0x86C0, 0x5BFA },
        { 0x86C4, 0x69C0 },
        { 0x86C6, 0x549A },
        { 0x86C7, 0x557F },
        { 0x86C9, 0x69C7 },
        { 0x86CA, 0x4D66 },
        { 0x86CB, 0x4B50 },
        { 0x86CE, 0x69C2 },
        { 0x86CF, 0x69C8 },
        { 0x86D0, 0x69CF },
        { 0x86D1, 0x69D5 },
        { 0x86D4, 0x4E77 },
        { 0x86D8, 0x69D4 },
        { 0x86D9, 0x577C },
        { 0x86DB, 0x5BEA },
        { 0x86DE, 0x69D1 },
        { 0x86DF, 0x69D3 },
        { 0x86E4, 0x4CF1 },
        { 0x86E9, 0x69CA },
        { 0x86ED, 0x69CD },
        { 0x86EE, 0x51F8 },
        { 0x86F0, 0x5B7D },
        { 0x86F1, 0x69CB },
        { 0x86F2, 0x69CC },
        { 0x86F3, 0x69CE },
        { 0x86F4, 0x69D2 },
        { 0x86F8, 0x69D8 },
        { 0x86F9, 0x5A5C },
        { 0x86FE, 0x4BE9 },
        { 0x8700, 0x55F0 },
        { 0x8702, 0x4C85 },
        { 0x8703, 0x69D6 },
        { 0x8707, 0x69D7 },
        { 0x8708, 0x69D9 },
        { 0x8709, 0x69DC },
        { 0x870A, 0x69DA },
        { 0x870D, 0x69DB },
        { 0x8712, 0x5971 },
        { 0x8713, 0x69D0 },
        { 0x8715, 0x5769 },
        { 0x8717, 0x57CE },
        { 0x8718, 0x5BA8 },
        { 0x871A, 0x69E2 },
        { 0x871C, 0x527B },
        { 0x871E, 0x69DF },
        { 0x8721, 0x50AE },
        { 0x8722, 0x69EB },
        { 0x8723, 0x69DD },
        { 0x8725, 0x69E0 },
        { 0x8729, 0x69E7 },
        { 0x872E, 0x69E1 },
        { 0x8731, 0x69E6 },
        { 0x8734, 0x69E5 },
        { 0x8737, 0x69E8 },
        { 0x873B, 0x69DE },
        { 0x873E, 0x69E3 },
        { 0x873F, 0x69E9 },
        { 0x8747, 0x5A4C },
        { 0x8748, 0x69E4 },
        { 0x8749, 0x49F4 },
        { 0x874C, 0x69F1 },
        { 0x874E, 0x58AA },
        { 0x8753, 0x69F4 },
        { 0x8757, 0x4E68 },
        { 0x8759, 0x69F8 },
        { 0x8760, 0x69EF },
        { 0x8763, 0x69F5 },
        { 0x8764, 0x69F7 },
        { 0x8765, 0x69F9 },
        { 0x876E, 0x69F2 },
        { 0x8770, 0x69F0 },
        { 0x8774, 0x4DFA },
        { 0x8776, 0x4B9C },
        { 0x877B, 0x69EE },
        { 0x877C, 0x69F6 },
        { 0x877D, 0x69EC },
        { 0x877E, 0x69ED },
        { 0x8782, 0x69EA },
        { 0x8783, 0x6A46 },
        { 0x8785, 0x6A43 },
        { 0x8788, 0x6A42 },
        { 0x878B, 0x69F3 },
        { 0x878D, 0x54D9 },
        { 0x8793, 0x69FA },
        { 0x8797, 0x6A45 },
        { 0x879F, 0x5299 },
        { 0x87A8, 0x69FC },
        { 0x87AB, 0x6A47 },
        { 0x87AC, 0x6A49 },
        { 0x87AD, 0x6A44 },
        { 0x87AF, 0x69FB },
        { 0x87B3, 0x6A4B },
        { 0x87B5, 0x6A4A },
        { 0x87BA, 0x51DC },
        { 0x87BD, 0x6A4E },
        { 0x87C0, 0x6A50 },
        { 0x87C6, 0x6A41 },
        { 0x87CA, 0x6A51 },
        { 0x87CB, 0x6A4C },
        { 0x87D1, 0x6A4F },
        { 0x87D2, 0x69FD },
        { 0x87D3, 0x6A4D },
        { 0x87DB, 0x6A52 },
        { 0x87E0, 0x6A54 },
        { 0x87E5, 0x6A48 },
        { 0x87EA, 0x6A53 },
        { 0x87EE, 0x6A55 },
        { 0x87F9, 0x58B6 },
        { 0x87FE, 0x6A58 },
        { 0x8803, 0x5D9A },
        { 0x880A, 0x6A59 },
        { 0x8813, 0x6A57 },
        { 0x8815, 0x54E3 },
        { 0x8816, 0x6A56 },
        { 0x881B, 0x6A5A },
        { 0x8821, 0x6A5B },
        { 0x8822, 0x4ABF },
        { 0x8832, 0x67C2 },
        { 0x8839, 0x6A5C },
        { 0x883C, 0x6A5D },
        { 0x8840, 0x594A },
        { 0x8844, 0x6AAB },
        { 0x8845, 0x58C5 },
        { 0x884C, 0x58CF },
        { 0x884D, 0x597C },
        { 0x8854, 0x586E },
        { 0x8857, 0x4F76 },
        { 0x8859, 0x5963 },
        { 0x8861, 0x4DE1 },
        { 0x8862, 0x618A },
        { 0x8863, 0x59C1 },
        { 0x8864, 0x6962 },
        { 0x8865, 0x49B8 },
        { 0x8868, 0x498E },
        { 0x8869, 0x6963 },
        { 0x886B, 0x5560 },
        { 0x886C, 0x4A64 },
        { 0x886E, 0x5D93 },
        { 0x8870, 0x5645 },
        { 0x8872, 0x6964 },
        { 0x8877, 0x5BD3 },
        { 0x887D, 0x6965 },
        { 0x887E, 0x6ABF },
        { 0x887F, 0x6966 },
        { 0x8881, 0x5AAB },
        { 0x8882, 0x6967 },
        { 0x8884, 0x48BF },
        { 0x8885, 0x6AC0 },
        { 0x8888, 0x6AC1 },
        { 0x888B, 0x4AFB },
        { 0x888D, 0x537B },
        { 0x8892, 0x56BA },
        { 0x8896, 0x58E3 },
        { 0x889C, 0x5781 },
        { 0x88A2, 0x6968 },
        { 0x88A4, 0x5D94 },
        { 0x88AB, 0x495B },
        { 0x88AD, 0x584E },
        { 0x88B1, 0x4CA3 },
        { 0x88B7, 0x696A },
        { 0x88BC, 0x696B },
        { 0x88C1, 0x49C2 },
        { 0x88C2, 0x5171 },
        { 0x88C5, 0x5C50 },
        { 0x88C6, 0x6969 },
        { 0x88C9, 0x696C },
        { 0x88CE, 0x696E },
        { 0x88D2, 0x5D97 },
        { 0x88D4, 0x59E0 },
        { 0x88D5, 0x5AA2 },
        { 0x88D8, 0x6AC2 },
        { 0x88D9, 0x54B8 },
        { 0x88DF, 0x6AC3 },
        { 0x88E2, 0x696D },
        { 0x88E3, 0x696F },
        { 0x88E4, 0x5084 },
        { 0x88E5, 0x6970 },
        { 0x88E8, 0x6974 },
        { 0x88F0, 0x6976 },
        { 0x88F1, 0x6971 },
        { 0x88F3, 0x5571 },
        { 0x88F4, 0x5382 },
        { 0x88F8, 0x51E2 },
        { 0x88F9, 0x4D9D },
        { 0x88FC, 0x6973 },
        { 0x88FE, 0x6975 },
        { 0x8902, 0x4D73 },
        { 0x890A, 0x697B },
        { 0x8910, 0x4DD5 },
        { 0x8912, 0x48FC },
        { 0x8913, 0x6979 },
        { 0x8919, 0x6978 },
        { 0x891A, 0x6972 },
        { 0x891B, 0x697A },
        { 0x8921, 0x6977 },
        { 0x8925, 0x54EB },
        { 0x892A, 0x576A },
        { 0x892B, 0x697D },
        { 0x8930, 0x635D },
        { 0x8934, 0x697C },
        { 0x8936, 0x697E },
        { 0x8941, 0x697F },
        { 0x8944, 0x5886 },
        { 0x895E, 0x6AC4 },
        { 0x895F, 0x4F94 },
        { 0x8966, 0x6981 },
        { 0x897B, 0x6982 },
        { 0x897F, 0x57F6 },
        { 0x8981, 0x59A9 },
        { 0x8983, 0x699C },
        { 0x8986, 0x4CB1 },
        { 0x89C1, 0x4EFA },
        { 0x89C2, 0x4D7B },
        { 0x89C4, 0x4D87 },
        { 0x89C5, 0x5279 },
        { 0x89C6, 0x55D2 },
        { 0x89C7, 0x65E7 },
        { 0x89C8, 0x50BF },
        { 0x89C9, 0x4FF4 },
        { 0x89CA, 0x65E8 },
        { 0x89CB, 0x65E9 },
        { 0x89CC, 0x65EA },
        { 0x89CE, 0x65EB },
        { 0x89CF, 0x65EC },
        { 0x89D0, 0x65ED },
        { 0x89D1, 0x65EE },
        { 0x89D2, 0x4F67 },
        { 0x89D6, 0x6B9C },
        { 0x89DA, 0x6B9E },
        { 0x89DC, 0x6B9F },
        { 0x89DE, 0x6B9D },
        { 0x89E3, 0x4F83 },
        { 0x89E5, 0x6BA0 },
        { 0x89E6, 0x4AA4 },
        { 0x89EB, 0x6BA1 },
        { 0x89EF, 0x6BA2 },
        { 0x89F3, 0x66B1 },
        { 0x8A00, 0x5974 },
        { 0x8A07, 0x5D8B },
        { 0x8A3E, 0x6BA3 },
        { 0x8A48, 0x67B9 },
        { 0x8A79, 0x5B52 },
        { 0x8A89, 0x5A9F },
        { 0x8A8A, 0x56DB },
        { 0x8A93, 0x55C3 },
        { 0x8B07, 0x6360 },
        { 0x8B26, 0x6BA4 },
        { 0x8B66, 0x4FAE },
        { 0x8B6C, 0x53A8 },
        { 0x8BA0, 0x5DA4 },
        { 0x8BA1, 0x4EC5 },
        { 0x8BA2, 0x4BA8 },
        { 0x8BA3, 0x4CBB },
        { 0x8BA4, 0x54CE },
        { 0x8BA5, 0x4EA4 },
        { 0x8BA6, 0x5DA5 },
        { 0x8BA7, 0x5DA6 },
        { 0x8BA8, 0x56D5 },
        { 0x8BA9, 0x54C2 },
        { 0x8BAA, 0x5DA7 },
        { 0x8BAB, 0x53FC },
        { 0x8BAD, 0x5955 },
        { 0x8BAE, 0x59E8 },
        { 0x8BAF, 0x5956 },
        { 0x8BB0, 0x4EC6 },
        { 0x8BB2, 0x4F52 },
        { 0x8BB3, 0x4E85 },
        { 0x8BB4, 0x5DA8 },
        { 0x8BB5, 0x5DA9 },
        { 0x8BB6, 0x5968 },
        { 0x8BB7, 0x5DAA },
        { 0x8BB8, 0x58EC },
        { 0x8BB9, 0x4BEE },
        { 0x8BBA, 0x51DA },
        { 0x8BBC, 0x566F },
        { 0x8BBD, 0x4C8E },
        { 0x8BBE, 0x5589 },
        { 0x8BBF, 0x4C63 },
        { 0x8BC0, 0x4FF6 },
        { 0x8BC1, 0x5BA3 },
        { 0x8BC2, 0x5DAB },
        { 0x8BC3, 0x5DAC },
        { 0x8BC4, 0x53BF },
        { 0x8BC5, 0x5C88 },
        { 0x8BC6, 0x55B5 },
        { 0x8BC8, 0x5B49 },
        { 0x8BC9, 0x567F },
        { 0x8BCA, 0x5B90 },
        { 0x8BCB, 0x5DAD },
        { 0x8BCC, 0x5BDE },
        { 0x8BCD, 0x4AC9 },
        { 0x8BCE, 0x5DAF },
        { 0x8BCF, 0x5DAE },
        { 0x8BD1, 0x59EA },
        { 0x8BD2, 0x5DB0 },
        { 0x8BD3, 0x5DB1 },
        { 0x8BD4, 0x5DB2 },
        { 0x8BD5, 0x55D3 },
        { 0x8BD6, 0x5DB3 },
        { 0x8BD7, 0x55AA },
        { 0x8BD8, 0x5DB4 },
        { 0x8BD9, 0x5DB5 },
        { 0x8BDA, 0x4A6F },
        { 0x8BDB, 0x5BEE },
        { 0x8BDC, 0x5DB6 },
        { 0x8BDD, 0x4E50 },
        { 0x8BDE, 0x4B4E },
        { 0x8BDF, 0x5DB7 },
        { 0x8BE0, 0x5DB8 },
        { 0x8BE1, 0x4D8F },
        { 0x8BE2, 0x594F },
        { 0x8BE3, 0x59E7 },
        { 0x8BE4, 0x5DB9 },
        { 0x8BE5, 0x4CC2 },
        { 0x8BE6, 0x588B },
        { 0x8BE7, 0x49EE },
        { 0x8BE8, 0x5DBA },
        { 0x8BE9, 0x5DBB },
        { 0x8BEB, 0x4F8C },
        { 0x8BEC, 0x57DB },
        { 0x8BED, 0x5A90 },
        { 0x8BEE, 0x5DBC },
        { 0x8BEF, 0x57F2 },
        { 0x8BF0, 0x5DBD },
        { 0x8BF1, 0x5A75 },
        { 0x8BF2, 0x4E86 },
        { 0x8BF3, 0x5DBE },
        { 0x8BF4, 0x5655 },
        { 0x8BF5, 0x5670 },
        { 0x8BF6, 0x5DBF },
        { 0x8BF7, 0x548C },
        { 0x8BF8, 0x5BED },
        { 0x8BF9, 0x5DC0 },
        { 0x8BFA, 0x5355 },
        { 0x8BFB, 0x4BC0 },
        { 0x8BFC, 0x5DC1 },
        { 0x8BFD, 0x4C6C },
        { 0x8BFE, 0x506E },
        { 0x8BFF, 0x5DC2 },
        { 0x8C00, 0x5DC3 },
        { 0x8C01, 0x564D },
        { 0x8C02, 0x5DC4 },
        { 0x8C03, 0x4B98 },
        { 0x8C04, 0x5DC5 },
        { 0x8C05, 0x5162 },
        { 0x8C06, 0x5C5B },
        { 0x8C07, 0x5DC6 },
        { 0x8C08, 0x56B7 },
        { 0x8C0A, 0x59E9 },
        { 0x8C0B, 0x52B0 },
        { 0x8C0C, 0x5DC7 },
        { 0x8C0D, 0x4B9E },
        { 0x8C0E, 0x4E71 },
        { 0x8C0F, 0x5DC8 },
        { 0x8C10, 0x58B2 },
        { 0x8C11, 0x5DC9 },
        { 0x8C12, 0x5DCA },
        { 0x8C13, 0x57BC },
        { 0x8C14, 0x5DCB },
        { 0x8C15, 0x5DCC },
        { 0x8C16, 0x5DCD },
        { 0x8C17, 0x49F6 },
        { 0x8C18, 0x5DD0 },
        { 0x8C19, 0x5DCE },
        { 0x8C1A, 0x5989 },
        { 0x8C1B, 0x5DCF },
        { 0x8C1C, 0x5275 },
        { 0x8C1D, 0x5DD1 },
        { 0x8C1F, 0x5DD2 },
        { 0x8C20, 0x5DD3 },
        { 0x8C21, 0x5DD4 },
        { 0x8C22, 0x58BA },
        { 0x8C23, 0x59A4 },
        { 0x8C24, 0x48F8 },
        { 0x8C25, 0x5DD5 },
        { 0x8C26, 0x544B },
        { 0x8C27, 0x5DD6 },
        { 0x8C28, 0x4F98 },
        { 0x8C29, 0x5241 },
        { 0x8C2A, 0x5DD7 },
        { 0x8C2B, 0x5DD8 },
        { 0x8C2C, 0x529E },
        { 0x8C2D, 0x56B6 },
        { 0x8C2E, 0x5DD9 },
        { 0x8C2F, 0x5DDA },
        { 0x8C30, 0x50BD },
        { 0x8C31, 0x53D6 },
        { 0x8C32, 0x5DDB },
        { 0x8C33, 0x5DDC },
        { 0x8C34, 0x5454 },
        { 0x8C35, 0x5DDD },
        { 0x8C36, 0x5DDE },
        { 0x8C37, 0x4D68 },
        { 0x8C41, 0x4E8E },
        { 0x8C46, 0x4BB8 },
        { 0x8C47, 0x6AF7 },
        { 0x8C49, 0x6AF8 },
        { 0x8C4C, 0x5784 },
        { 0x8C55, 0x6B59 },
        { 0x8C5A, 0x6681 },
        { 0x8C61, 0x5894 },
        { 0x8C62, 0x4E5F },
        { 0x8C6A, 0x4DBF },
        { 0x8C6B, 0x5AA4 },
        { 0x8C73, 0x6179 },
        { 0x8C78, 0x6B95 },
        { 0x8C79, 0x494A },
        { 0x8C7A, 0x49F1 },
        { 0x8C82, 0x6B96 },
        { 0x8C85, 0x6B98 },
        { 0x8C89, 0x4DD0 },
        { 0x8C8A, 0x6B97 },
        { 0x8C8C, 0x5252 },
        { 0x8C94, 0x6B9A },
        { 0x8C98, 0x6B99 },
        { 0x8D1D, 0x4954 },
        { 0x8D1E, 0x5B8B },
        { 0x8D1F, 0x4CB9 },
        { 0x8D21, 0x4D51 },
        { 0x8D22, 0x49C5 },
        { 0x8D23, 0x5AEF },
        { 0x8D24, 0x586D },
        { 0x8D25, 0x48DB },
        { 0x8D26, 0x5B6B },
        { 0x8D27, 0x4E96 },
        { 0x8D28, 0x5BC9 },
        { 0x8D29, 0x4C57 },
        { 0x8D2A, 0x56AF },
        { 0x8D2B, 0x53B5 },
        { 0x8D2C, 0x4982 },
        { 0x8D2D, 0x4D5A },
        { 0x8D2E, 0x5BFB },
        { 0x8D2F, 0x4D82 },
        { 0x8D30, 0x4C41 },
        { 0x8D31, 0x4EF9 },
        { 0x8D32, 0x65D9 },
        { 0x8D33, 0x65DA },
        { 0x8D34, 0x56F8 },
        { 0x8D35, 0x4D94 },
        { 0x8D36, 0x65DB },
        { 0x8D37, 0x4AFA },
        { 0x8D38, 0x5253 },
        { 0x8D39, 0x4C71 },
        { 0x8D3A, 0x4DD7 },
        { 0x8D3B, 0x65DC },
        { 0x8D3C, 0x5AF3 },
        { 0x8D3D, 0x65DD },
        { 0x8D3E, 0x4ED5 },
        { 0x8D3F, 0x4E7F },
        { 0x8D40, 0x65DE },
        { 0x8D41, 0x517E },
        { 0x8D42, 0x51B7 },
        { 0x8D43, 0x5ADE },
        { 0x8D44, 0x5C6A },
        { 0x8D45, 0x65DF },
        { 0x8D46, 0x65E0 },
        { 0x8D47, 0x65E3 },
        { 0x8D48, 0x65E1 },
        { 0x8D49, 0x65E2 },
        { 0x8D4A, 0x557E },
        { 0x8D4B, 0x4CB2 },
        { 0x8D4C, 0x4BC3 },
        { 0x8D4D, 0x65E4 },
        { 0x8D4E, 0x55E9 },
        { 0x8D4F, 0x556D },
        { 0x8D50, 0x4ACC },
        { 0x8D53, 0x61D8 },
        { 0x8D54, 0x5383 },
        { 0x8D55, 0x65E5 },
        { 0x8D56, 0x50B4 },
        { 0x8D58, 0x5C58 },
        { 0x8D59, 0x65E6 },
        { 0x8D5A, 0x5C4C },
        { 0x8D5B, 0x54FB },
        { 0x8D5C, 0x5CD2 },
        { 0x8D5D, 0x5CCC },
        { 0x8D5E, 0x5ADD },
        { 0x8D60, 0x5AF8 },
        { 0x8D61, 0x5564 },
        { 0x8D62, 0x5A4E },
        { 0x8D63, 0x4CD2 },
        { 0x8D64, 0x4A81 },
        { 0x8D66, 0x5583 },
        { 0x8D67, 0x6AF5 },
        { 0x8D6B, 0x4DD4 },
        { 0x8D6D, 0x6AF6 },
        { 0x8D70, 0x5C7F },
        { 0x8D73, 0x6AF0 },
        { 0x8D74, 0x4CAF },
        { 0x8D75, 0x5B74 },
        { 0x8D76, 0x4CCE },
        { 0x8D77, 0x53EF },
        { 0x8D81, 0x4A63 },
        { 0x8D84, 0x6AF1 },
        { 0x8D85, 0x4A4C },
        { 0x8D8A, 0x5ABC },
        { 0x8D8B, 0x5498 },
        { 0x8D91, 0x6AF3 },
        { 0x8D94, 0x6AF2 },
        { 0x8D9F, 0x56CA },
        { 0x8DA3, 0x54A3 },
        { 0x8DB1, 0x6AF4 },
        { 0x8DB3, 0x5C84 },
        { 0x8DB4, 0x535F },
        { 0x8DB5, 0x6B60 },
        { 0x8DB8, 0x6B5B },
        { 0x8DBA, 0x6B63 },
        { 0x8DBC, 0x6B62 },
        { 0x8DBE, 0x5BB9 },
        { 0x8DBF, 0x6B61 },
        { 0x8DC3, 0x5ABD },
        { 0x8DC4, 0x6B64 },
        { 0x8DC6, 0x6B6C },
        { 0x8DCB, 0x48CE },
        { 0x8DCC, 0x4B99 },
        { 0x8DCE, 0x6B69 },
        { 0x8DCF, 0x6B6A },
        { 0x8DD1, 0x537C },
        { 0x8DD6, 0x6B65 },
        { 0x8DD7, 0x6B66 },
        { 0x8DDA, 0x6B67 },
        { 0x8DDB, 0x6B6B },
        { 0x8DDD, 0x4FDF },
        { 0x8DDE, 0x6B68 },
        { 0x8DDF, 0x4CF9 },
        { 0x8DE3, 0x6B70 },
        { 0x8DE4, 0x6B73 },
        { 0x8DE8, 0x5088 },
        { 0x8DEA, 0x4D93 },
        { 0x8DEB, 0x6B5C },
        { 0x8DEC, 0x6B6D },
        { 0x8DEF, 0x51B6 },
        { 0x8DF3, 0x56F7 },
        { 0x8DF5, 0x4EF8 },
        { 0x8DF7, 0x6B6E },
        { 0x8DF8, 0x6B6F },
        { 0x8DF9, 0x6B71 },
        { 0x8DFA, 0x4BE4 },
        { 0x8DFB, 0x6B72 },
        { 0x8DFD, 0x6B75 },
        { 0x8E05, 0x6B5D },
        { 0x8E09, 0x6B74 },
        { 0x8E0A, 0x5A5B },
        { 0x8E0C, 0x4A8D },
        { 0x8E0F, 0x56A3 },
        { 0x8E14, 0x6B76 },
        { 0x8E1D, 0x6B77 },
        { 0x8E1E, 0x4FE0 },
        { 0x8E1F, 0x6B78 },
        { 0x8E22, 0x56DE },
        { 0x8E23, 0x6B7B },
        { 0x8E29, 0x49C7 },
        { 0x8E2A, 0x5C79 },
        { 0x8E2C, 0x6B79 },
        { 0x8E2E, 0x6B7A },
        { 0x8E2F, 0x6B7C },
        { 0x8E31, 0x6B83 },
        { 0x8E35, 0x6B81 },
        { 0x8E39, 0x6B7F },
        { 0x8E3A, 0x6B7D },
        { 0x8E3D, 0x6B82 },
        { 0x8E40, 0x6B7E },
        { 0x8E41, 0x6B85 },
        { 0x8E42, 0x6B86 },
        { 0x8E44, 0x56E2 },
        { 0x8E47, 0x635F },
        { 0x8E48, 0x4B58 },
        { 0x8E49, 0x6B84 },
        { 0x8E4A, 0x6B89 },
        { 0x8E4B, 0x56A2 },
        { 0x8E51, 0x6B87 },
        { 0x8E52, 0x6B88 },
        { 0x8E59, 0x6B5E },
        { 0x8E66, 0x4964 },
        { 0x8E69, 0x6B5F },
        { 0x8E6C, 0x4B65 },
        { 0x8E6D, 0x49E3 },
        { 0x8E6F, 0x6B8D },
        { 0x8E70, 0x6B8A },
        { 0x8E72, 0x4BD6 },
        { 0x8E74, 0x6B8E },
        { 0x8E76, 0x6B8B },
        { 0x8E7C, 0x6B8C },
        { 0x8E7F, 0x4AD9 },
        { 0x8E81, 0x5AE9 },
        { 0x8E85, 0x6B8F },
        { 0x8E87, 0x4A9A },
        { 0x8E8F, 0x6B90 },
        { 0x8E90, 0x6B92 },
        { 0x8E94, 0x6B91 },
        { 0x8E9C, 0x6B93 },
        { 0x8E9E, 0x6B94 },
        { 0x8EAB, 0x558E },
        { 0x8EAC, 0x4D4A },
        { 0x8EAF, 0x549C },
        { 0x8EB2, 0x4BE2 },
        { 0x8EBA, 0x56C8 },
        { 0x8ECE, 0x65A5 },
        { 0x8F66, 0x4A55 },
        { 0x8F67, 0x5AFD },
        { 0x8F68, 0x4D8D },
        { 0x8F69, 0x58F8 },
        { 0x8F6B, 0x658E },
        { 0x8F6C, 0x5C4A },
        { 0x8F6D, 0x658F },
        { 0x8F6E, 0x51D5 },
        { 0x8F6F, 0x54EC },
        { 0x8F70, 0x4DE3 },
        { 0x8F71, 0x6590 },
        { 0x8F72, 0x6591 },
        { 0x8F73, 0x6592 },
        { 0x8F74, 0x5BE0 },
        { 0x8F75, 0x6593 },
        { 0x8F76, 0x6594 },
        { 0x8F77, 0x6596 },
        { 0x8F78, 0x6595 },
        { 0x8F79, 0x6597 },
        { 0x8F7A, 0x6598 },
        { 0x8F7B, 0x5482 },
        { 0x8F7C, 0x6599 },
        { 0x8F7D, 0x5AD7 },
        { 0x8F7E, 0x659A },
        { 0x8F7F, 0x4F6E },
        { 0x8F81, 0x659B },
        { 0x8F82, 0x659C },
        { 0x8F83, 0x4F6F },
        { 0x8F84, 0x659D },
        { 0x8F85, 0x4CA7 },
        { 0x8F86, 0x515E },
        { 0x8F87, 0x659E },
        { 0x8F88, 0x4952 },
        { 0x8F89, 0x4E74 },
        { 0x8F8A, 0x4D96 },
        { 0x8F8B, 0x659F },
        { 0x8F8D, 0x65A0 },
        { 0x8F8E, 0x65A1 },
        { 0x8F8F, 0x65A2 },
        { 0x8F90, 0x4C99 },
        { 0x8F91, 0x4EAC },
        { 0x8F93, 0x55E3 },
        { 0x8F94, 0x60CD },
        { 0x8F95, 0x5AAE },
        { 0x8F96, 0x585D },
        { 0x8F97, 0x5B57 },
        { 0x8F98, 0x65A3 },
        { 0x8F99, 0x5B7E },
        { 0x8F9A, 0x65A4 },
        { 0x8F9B, 0x58C0 },
        { 0x8F9C, 0x4D5C },
        { 0x8F9E, 0x4AC6 },
        { 0x8F9F, 0x4979 },
        { 0x8FA3, 0x50B0 },
        { 0x8FA8, 0x4987 },
        { 0x8FA9, 0x4988 },
        { 0x8FAB, 0x4989 },
        { 0x8FB0, 0x4A5D },
        { 0x8FB1, 0x54E7 },
        { 0x8FB6, 0x6361 },
        { 0x8FB9, 0x497F },
        { 0x8FBD, 0x5169 },
        { 0x8FBE, 0x4AEE },
        { 0x8FC1, 0x5448 },
        { 0x8FC2, 0x5A78 },
        { 0x8FC4, 0x53F8 },
        { 0x8FC5, 0x5958 },
        { 0x8FC7, 0x4D9E },
        { 0x8FC8, 0x51F4 },
        { 0x8FCE, 0x5A4D },
        { 0x8FD0, 0x5ACA },
        { 0x8FD1, 0x4F9D },
        { 0x8FD3, 0x6362 },
        { 0x8FD4, 0x4C55 },
        { 0x8FD5, 0x6363 },
        { 0x8FD8, 0x4E59 },
        { 0x8FD9, 0x5B83 },
        { 0x8FDB, 0x4F99 },
        { 0x8FDC, 0x5AB5 },
        { 0x8FDD, 0x57A4 },
        { 0x8FDE, 0x514C },
        { 0x8FDF, 0x4A79 },
        { 0x8FE2, 0x56F5 },
        { 0x8FE4, 0x6366 },
        { 0x8FE5, 0x6364 },
        { 0x8FE6, 0x6368 },
        { 0x8FE8, 0x636A },
        { 0x8FE9, 0x6367 },
        { 0x8FEA, 0x4B6F },
        { 0x8FEB, 0x53C7 },
        { 0x8FED, 0x4B9D },
        { 0x8FEE, 0x6365 },
        { 0x8FF0, 0x55F5 },
        { 0x8FF3, 0x6369 },
        { 0x8FF7, 0x5274 },
        { 0x8FF8, 0x4965 },
        { 0x8FF9, 0x4EA2 },
        { 0x8FFD, 0x5C57 },
        { 0x9000, 0x576B },
        { 0x9001, 0x566D },
        { 0x9002, 0x55C9 },
        { 0x9003, 0x56D2 },
        { 0x9004, 0x636C },
        { 0x9005, 0x636B },
        { 0x9006, 0x52E5 },
        { 0x9009, 0x5941 },
        { 0x900A, 0x5957 },
        { 0x900B, 0x636D },
        { 0x900D, 0x6370 },
        { 0x900F, 0x5758 },
        { 0x9010, 0x5BEF },
        { 0x9011, 0x636F },
        { 0x9012, 0x4B7D },
        { 0x9014, 0x575E },
        { 0x9016, 0x6371 },
        { 0x9017, 0x4BB9 },
        { 0x901A, 0x5748 },
        { 0x901B, 0x4D85 },
        { 0x901D, 0x55C4 },
        { 0x901E, 0x4A71 },
        { 0x901F, 0x5679 },
        { 0x9020, 0x5AEB },
        { 0x9021, 0x6372 },
        { 0x9022, 0x4C8B },
        { 0x9026, 0x636E },
        { 0x902D, 0x6375 },
        { 0x902E, 0x4AFD },
        { 0x902F, 0x6376 },
        { 0x9035, 0x6373 },
        { 0x9036, 0x6374 },
        { 0x9038, 0x59DC },
        { 0x903B, 0x51DE },
        { 0x903C, 0x4966 },
        { 0x903E, 0x5A83 },
        { 0x9041, 0x4BDC },
        { 0x9042, 0x568D },
        { 0x9044, 0x6377 },
        { 0x9047, 0x5A97 },
        { 0x904D, 0x498A },
        { 0x904F, 0x4BF3 },
        { 0x9050, 0x637A },
        { 0x9051, 0x6378 },
        { 0x9052, 0x6379 },
        { 0x9053, 0x4B60 },
        { 0x9057, 0x59C4 },
        { 0x9058, 0x637C },
        { 0x905B, 0x637E },
        { 0x9062, 0x637D },
        { 0x9063, 0x5452 },
        { 0x9065, 0x59A2 },
        { 0x9068, 0x637B },
        { 0x906D, 0x5AE1 },
        { 0x906E, 0x5B7A },
        { 0x9074, 0x6381 },
        { 0x9075, 0x5C92 },
        { 0x907D, 0x6382 },
        { 0x907F, 0x497C },
        { 0x9080, 0x599C },
        { 0x9082, 0x6383 },
        { 0x9083, 0x6385 },
        { 0x9088, 0x6384 },
        { 0x908B, 0x6386 },
        { 0x9091, 0x59D7 },
        { 0x9093, 0x4B6B },
        { 0x9095, 0x647F },
        { 0x9097, 0x5DF4 },
        { 0x9099, 0x5DF7 },
        { 0x909B, 0x5DF5 },
        { 0x909D, 0x5DF6 },
        { 0x90A1, 0x5DF9 },
        { 0x90A2, 0x58CE },
        { 0x90A3, 0x52C6 },
        { 0x90A6, 0x48ED },
        { 0x90AA, 0x58AF },
        { 0x90AC, 0x5DF8 },
        { 0x90AE, 0x5A6A },
        { 0x90AF, 0x4DA9 },
        { 0x90B0, 0x5E42 },
        { 0x90B1, 0x5492 },
        { 0x90B3, 0x5DFB },
        { 0x90B4, 0x5DFA },
        { 0x90B5, 0x557B },
        { 0x90B6, 0x5DFC },
        { 0x90B8, 0x5E41 },
        { 0x90B9, 0x5C7E },
        { 0x90BA, 0x5DFD },
        { 0x90BB, 0x517A },
        { 0x90BE, 0x5E45 },
        { 0x90C1, 0x5A95 },
        { 0x90C4, 0x5E47 },
        { 0x90C5, 0x5E44 },
        { 0x90C7, 0x5E48 },
        { 0x90CA, 0x4F5C },
        { 0x90CE, 0x50C8 },
        { 0x90CF, 0x5E43 },
        { 0x90D0, 0x5E46 },
        { 0x90D1, 0x5BA2 },
        { 0x90D3, 0x5E49 },
        { 0x90D7, 0x5E4D },
        { 0x90DB, 0x5E4E },
        { 0x90DC, 0x5E4C },
        { 0x90DD, 0x4DC1 },
        { 0x90E1, 0x5044 },
        { 0x90E2, 0x5E4B },
        { 0x90E6, 0x5E4A },
        { 0x90E7, 0x5AC6 },
        { 0x90E8, 0x49BE },
        { 0x90EB, 0x5E4F },
        { 0x90ED, 0x4D9A },
        { 0x90EF, 0x5E50 },
        { 0x90F4, 0x4A5B },
        { 0x90F8, 0x4B46 },
        { 0x90FD, 0x4BBB },
        { 0x90FE, 0x5E51 },
        { 0x9102, 0x4BF4 },
        { 0x9104, 0x5E52 },
        { 0x9119, 0x4969 },
        { 0x911E, 0x5E54 },
        { 0x9122, 0x5E53 },
        { 0x9123, 0x5E55 },
        { 0x912F, 0x5E57 },
        { 0x9131, 0x5E56 },
        { 0x9139, 0x5E58 },
        { 0x9143, 0x5E59 },
        { 0x9146, 0x5E5A },
        { 0x9149, 0x5A6F },
        { 0x914A, 0x6AF9 },
        { 0x914B, 0x5496 },
        { 0x914C, 0x5C63 },
        { 0x914D, 0x5385 },
        { 0x914E, 0x6AFB },
        { 0x914F, 0x6AFC },
        { 0x9150, 0x6AFA },
        { 0x9152, 0x4FC5 },
        { 0x9157, 0x58EE },
        { 0x915A, 0x4C73 },
        { 0x915D, 0x5ACC },
        { 0x915E, 0x56A9 },
        { 0x9161, 0x6B42 },
        { 0x9162, 0x6B41 },
        { 0x9163, 0x4DA7 },
        { 0x9164, 0x6AFD },
        { 0x9165, 0x5676 },
        { 0x9169, 0x6B44 },
        { 0x916A, 0x50D1 },
        { 0x916C, 0x4A8B },
        { 0x916E, 0x574A },
        { 0x916F, 0x6B45 },
        { 0x9170, 0x6B43 },
        { 0x9171, 0x4F54 },
        { 0x9172, 0x6B48 },
        { 0x9174, 0x6B49 },
        { 0x9175, 0x4F6D },
        { 0x9176, 0x5258 },
        { 0x9177, 0x5082 },
        { 0x9178, 0x5682 },
        { 0x9179, 0x6B4A },
        { 0x917D, 0x6B46 },
        { 0x917E, 0x6B47 },
        { 0x917F, 0x52EF },
        { 0x9185, 0x6B4C },
        { 0x9187, 0x4ABB },
        { 0x9189, 0x5C8E },
        { 0x918B, 0x4AD6 },
        { 0x918C, 0x6B4B },
        { 0x918D, 0x6B4E },
        { 0x9190, 0x6B4D },
        { 0x9191, 0x6B4F },
        { 0x9192, 0x58D0 },
        { 0x919A, 0x5271 },
        { 0x919B, 0x54A8 },
        { 0x91A2, 0x6B50 },
        { 0x91A3, 0x6B51 },
        { 0x91AA, 0x6B52 },
        { 0x91AD, 0x6B53 },
        { 0x91AE, 0x6B54 },
        { 0x91AF, 0x6B55 },
        { 0x91B4, 0x6B57 },
        { 0x91B5, 0x6B56 },
        { 0x91BA, 0x6B58 },
        { 0x91C7, 0x49C8 },
        { 0x91C9, 0x5A74 },
        { 0x91CA, 0x55CC },
        { 0x91CC, 0x50EE },
        { 0x91CD, 0x5BD7 },
        { 0x91CE, 0x59AF },
        { 0x91CF, 0x515F },
        { 0x91D1, 0x4F91 },
        { 0x91DC, 0x4CA9 },
        { 0x9274, 0x4EF7 },
        { 0x928E, 0x6BC5 },
        { 0x92AE, 0x6BC6 },
        { 0x92C8, 0x6BC7 },
        { 0x933E, 0x6BC8 },
        { 0x936A, 0x6BC9 },
        { 0x938F, 0x6BCB },
        { 0x93CA, 0x6BCA },
        { 0x93D6, 0x6C8A },
        { 0x943E, 0x6BCC },
        { 0x946B, 0x6BCD },
        { 0x9485, 0x67C3 },
        { 0x9486, 0x67C4 },
        { 0x9487, 0x67C5 },
        { 0x9488, 0x5B8C },
        { 0x9489, 0x4BA3 },
        { 0x948A, 0x67C7 },
        { 0x948B, 0x67C6 },
        { 0x948C, 0x67C8 },
        { 0x948D, 0x67C9 },
        { 0x948E, 0x5445 },
        { 0x948F, 0x67CA },
        { 0x9490, 0x67CB },
        { 0x9492, 0x4C50 },
        { 0x9493, 0x4B97 },
        { 0x9494, 0x67CC },
        { 0x9495, 0x67CE },
        { 0x9497, 0x67CD },
        { 0x9499, 0x4CC5 },
        { 0x949A, 0x67CF },
        { 0x949B, 0x67D0 },
        { 0x949C, 0x67D1 },
        { 0x949D, 0x4BDA },
        { 0x949E, 0x4A4E },
        { 0x949F, 0x5BD2 },
        { 0x94A0, 0x52C5 },
        { 0x94A1, 0x4955 },
        { 0x94A2, 0x4CD5 },
        { 0x94A3, 0x67D2 },
        { 0x94A4, 0x67D3 },
        { 0x94A5, 0x5ABE },
        { 0x94A6, 0x5475 },
        { 0x94A7, 0x4FFA },
        { 0x94A8, 0x57D8 },
        { 0x94A9, 0x4D53 },
        { 0x94AA, 0x67D5 },
        { 0x94AB, 0x67D4 },
        { 0x94AC, 0x67D7 },
        { 0x94AD, 0x67D6 },
        { 0x94AE, 0x5345 },
        { 0x94AF, 0x67D8 },
        { 0x94B0, 0x67D9 },
        { 0x94B1, 0x544E },
        { 0x94B2, 0x67DA },
        { 0x94B3, 0x544F },
        { 0x94B4, 0x67DB },
        { 0x94B5, 0x49A6 },
        { 0x94B6, 0x67DC },
        { 0x94B7, 0x67DD },
        { 0x94B8, 0x67DE },
        { 0x94B9, 0x67DF },
        { 0x94BA, 0x67E0 },
        { 0x94BB, 0x5C8B },
        { 0x94BC, 0x67E1 },
        { 0x94BD, 0x67E2 },
        { 0x94BE, 0x4ED7 },
        { 0x94BF, 0x67E3 },
        { 0x94C0, 0x5A6B },
        { 0x94C1, 0x56F9 },
        { 0x94C2, 0x49AB },
        { 0x94C3, 0x5186 },
        { 0x94C4, 0x67E4 },
        { 0x94C5, 0x5446 },
        { 0x94C6, 0x524D },
        { 0x94C8, 0x67E5 },
        { 0x94C9, 0x67E6 },
        { 0x94CA, 0x67E7 },
        { 0x94CB, 0x67E8 },
        { 0x94CC, 0x67E9 },
        { 0x94CD, 0x67EA },
        { 0x94CE, 0x67EB },
        { 0x94D0, 0x67EC },
        { 0x94D1, 0x67ED },
        { 0x94D2, 0x67EE },
        { 0x94D5, 0x67EF },
        { 0x94D6, 0x67F0 },
        { 0x94D7, 0x67F1 },
        { 0x94D8, 0x67F3 },
        { 0x94D9, 0x67F2 },
        { 0x94DB, 0x67F4 },
        { 0x94DC, 0x574D },
        { 0x94DD, 0x51C0 },
        { 0x94DE, 0x67F5 },
        { 0x94DF, 0x67F6 },
        { 0x94E0, 0x67F7 },
        { 0x94E1, 0x5B41 },
        { 0x94E2, 0x67F8 },
        { 0x94E3, 0x5853 },
        { 0x94E4, 0x67F9 },
        { 0x94E5, 0x67FA },
        { 0x94E7, 0x67FB },
        { 0x94E8, 0x67FC },
        { 0x94E9, 0x6841 },
        { 0x94EA, 0x67FD },
        { 0x94EB, 0x6842 },
        { 0x94EC, 0x4CF4 },
        { 0x94ED, 0x529B },
        { 0x94EE, 0x6843 },
        { 0x94EF, 0x6844 },
        { 0x94F0, 0x4F62 },
        { 0x94F1, 0x59BE },
        { 0x94F2, 0x49F8 },
        { 0x94F3, 0x6845 },
        { 0x94F4, 0x6846 },
        { 0x94F5, 0x6847 },
        { 0x94F6, 0x59F7 },
        { 0x94F7, 0x6848 },
        { 0x94F8, 0x5BFC },
        { 0x94F9, 0x6849 },
        { 0x94FA, 0x53CB },
        { 0x94FC, 0x684A },
        { 0x94FD, 0x684B },
        { 0x94FE, 0x5154 },
        { 0x94FF, 0x684C },
        { 0x9500, 0x589B },
        { 0x9501, 0x5699 },
        { 0x9502, 0x684E },
        { 0x9503, 0x684D },
        { 0x9504, 0x4A9B },
        { 0x9505, 0x4D99 },
        { 0x9506, 0x684F },
        { 0x9507, 0x6850 },
        { 0x9508, 0x58E1 },
        { 0x9509, 0x6851 },
        { 0x950A, 0x6852 },
        { 0x950B, 0x4C87 },
        { 0x950C, 0x58BE },
        { 0x950D, 0x6853 },
        { 0x950E, 0x6854 },
        { 0x950F, 0x6855 },
        { 0x9510, 0x54F0 },
        { 0x9511, 0x56DF },
        { 0x9512, 0x6856 },
        { 0x9513, 0x6857 },
        { 0x9514, 0x6858 },
        { 0x9515, 0x6859 },
        { 0x9516, 0x685A },
        { 0x9517, 0x5B81 },
        { 0x9518, 0x685B },
        { 0x9519, 0x4AEC },
        { 0x951A, 0x524A },
        { 0x951B, 0x685C },
        { 0x951D, 0x685D },
        { 0x951E, 0x685E },
        { 0x951F, 0x685F },
        { 0x9521, 0x57FC },
        { 0x9522, 0x6860 },
        { 0x9523, 0x51DF },
        { 0x9524, 0x4AB7 },
        { 0x9525, 0x5C56 },
        { 0x9526, 0x4F96 },
        { 0x9528, 0x5867 },
        { 0x9529, 0x6863 },
        { 0x952A, 0x6861 },
        { 0x952B, 0x6862 },
        { 0x952C, 0x6864 },
        { 0x952D, 0x4BA6 },
        { 0x952E, 0x4EFB },
        { 0x952F, 0x4FE1 },
        { 0x9530, 0x526C },
        { 0x9531, 0x6865 },
        { 0x9532, 0x6866 },
        { 0x9534, 0x6867 },
        { 0x9535, 0x686F },
        { 0x9536, 0x6868 },
        { 0x9537, 0x6869 },
        { 0x9538, 0x686A },
        { 0x9539, 0x5462 },
        { 0x953A, 0x6892 },
        { 0x953B, 0x4BCC },
        { 0x953C, 0x686B },
        { 0x953E, 0x686C },
        { 0x953F, 0x686D },
        { 0x9540, 0x4BC5 },
        { 0x9541, 0x525E },
        { 0x9542, 0x686E },
        { 0x9544, 0x6870 },
        { 0x9545, 0x6871 },
        { 0x9546, 0x6872 },
        { 0x9547, 0x5B93 },
        { 0x9549, 0x6873 },
        { 0x954A, 0x52F6 },
        { 0x954C, 0x6874 },
        { 0x954D, 0x52F7 },
        { 0x954E, 0x6875 },
        { 0x954F, 0x6876 },
        { 0x9550, 0x4CE3 },
        { 0x9551, 0x48F6 },
        { 0x9552, 0x6877 },
        { 0x9553, 0x6878 },
        { 0x9554, 0x6879 },
        { 0x9556, 0x687A },
        { 0x9557, 0x687B },
        { 0x9558, 0x687C },
        { 0x9559, 0x687D },
        { 0x955B, 0x687E },
        { 0x955C, 0x4FB4 },
        { 0x955D, 0x6882 },
        { 0x955E, 0x687F },
        { 0x955F, 0x6881 },
        { 0x9561, 0x6883 },
        { 0x9562, 0x6884 },
        { 0x9563, 0x516D },
        { 0x9564, 0x6885 },
        { 0x9565, 0x6886 },
        { 0x9566, 0x6887 },
        { 0x9567, 0x6888 },
        { 0x9568, 0x6889 },
        { 0x9569, 0x688A },
        { 0x956A, 0x688B },
        { 0x956B, 0x688C },
        { 0x956C, 0x688D },
        { 0x956D, 0x50D7 },
        { 0x956F, 0x688E },
        { 0x9570, 0x514D },
        { 0x9571, 0x688F },
        { 0x9572, 0x6890 },
        { 0x9573, 0x6891 },
        { 0x9576, 0x5883 },
        { 0x957F, 0x4A44 },
        { 0x95E8, 0x5265 },
        { 0x95E9, 0x6265 },
        { 0x95EA, 0x5561 },
        { 0x95EB, 0x6266 },
        { 0x95ED, 0x4975 },
        { 0x95EE, 0x57C9 },
        { 0x95EF, 0x4AB2 },
        { 0x95F0, 0x54F1 },
        { 0x95F1, 0x6267 },
        { 0x95F2, 0x5870 },
        { 0x95F3, 0x6268 },
        { 0x95F4, 0x4EE3 },
        { 0x95F5, 0x6269 },
        { 0x95F6, 0x626A },
        { 0x95F7, 0x5266 },
        { 0x95F8, 0x5B42 },
        { 0x95F9, 0x52D5 },
        { 0x95FA, 0x4D8C },
        { 0x95FB, 0x57C4 },
        { 0x95FC, 0x626B },
        { 0x95FD, 0x5297 },
        { 0x95FE, 0x626C },
        { 0x9600, 0x4C47 },
        { 0x9601, 0x4CF2 },
        { 0x9602, 0x4DD1 },
        { 0x9603, 0x626D },
        { 0x9604, 0x626E },
        { 0x9605, 0x5AC3 },
        { 0x9606, 0x626F },
        { 0x9608, 0x6270 },
        { 0x9609, 0x596B },
        { 0x960A, 0x6271 },
        { 0x960B, 0x6272 },
        { 0x960C, 0x6273 },
        { 0x960D, 0x6274 },
        { 0x960E, 0x5976 },
        { 0x960F, 0x6275 },
        { 0x9610, 0x49FA },
        { 0x9611, 0x50BA },
        { 0x9612, 0x6276 },
        { 0x9614, 0x50AA },
        { 0x9615, 0x6277 },
        { 0x9616, 0x6278 },
        { 0x9617, 0x6279 },
        { 0x9619, 0x627A },
        { 0x961A, 0x627B },
        { 0x961C, 0x4CB6 },
        { 0x961D, 0x5DE1 },
        { 0x961F, 0x4BD2 },
        { 0x9621, 0x5DE3 },
        { 0x9622, 0x5DE2 },
        { 0x962A, 0x5DE5 },
        { 0x962E, 0x54ED },
        { 0x9631, 0x5DE4 },
        { 0x9632, 0x4C60 },
        { 0x9633, 0x5995 },
        { 0x9634, 0x59F4 },
        { 0x9635, 0x5B94 },
        { 0x9636, 0x4F77 },
        { 0x963B, 0x5C89 },
        { 0x963C, 0x5DE7 },
        { 0x963D, 0x5DE6 },
        { 0x963F, 0x48A1 },
        { 0x9640, 0x5773 },
        { 0x9642, 0x5DE8 },
        { 0x9644, 0x4CBC },
        { 0x9645, 0x4EC9 },
        { 0x9646, 0x51BC },
        { 0x9647, 0x51A3 },
        { 0x9648, 0x4A62 },
        { 0x9649, 0x5DE9 },
        { 0x964B, 0x51A9 },
        { 0x964C, 0x52AF },
        { 0x964D, 0x4F55 },
        { 0x9650, 0x587E },
        { 0x9654, 0x5DEA },
        { 0x9655, 0x5562 },
        { 0x965B, 0x497D },
        { 0x965F, 0x5DEB },
        { 0x9661, 0x4BB7 },
        { 0x9662, 0x5AB9 },
        { 0x9664, 0x4A9E },
        { 0x9667, 0x5DEC },
        { 0x9668, 0x5AC8 },
        { 0x9669, 0x5875 },
        { 0x966A, 0x5384 },
        { 0x966C, 0x5DED },
        { 0x9672, 0x5DEE },
        { 0x9674, 0x5DEF },
        { 0x9675, 0x518B },
        { 0x9676, 0x56D4 },
        { 0x9677, 0x587D },
        { 0x9685, 0x5A88 },
        { 0x9686, 0x51A0 },
        { 0x9688, 0x5DF0 },
        { 0x968B, 0x5686 },
        { 0x968D, 0x5DF1 },
        { 0x968F, 0x5687 },
        { 0x9690, 0x59FD },
        { 0x9694, 0x4CF3 },
        { 0x9697, 0x5DF2 },
        { 0x9698, 0x48AE },
        { 0x9699, 0x5856 },
        { 0x969C, 0x5B6F },
        { 0x96A7, 0x568E },
        { 0x96B0, 0x5DF3 },
        { 0x96B3, 0x6264 },
        { 0x96B6, 0x5145 },
        { 0x96B9, 0x6BBE },
        { 0x96BC, 0x6BBF },
        { 0x96BD, 0x6BC0 },
        { 0x96BE, 0x52D0 },
        { 0x96C0, 0x54B7 },
        { 0x96C1, 0x5984 },
        { 0x96C4, 0x58DA },
        { 0x96C5, 0x5965 },
        { 0x96C6, 0x4EAE },
        { 0x96C7, 0x4D6D },
        { 0x96C9, 0x6895 },
        { 0x96CC, 0x4AC5 },
        { 0x96CD, 0x5A5A },
        { 0x96CE, 0x6BC1 },
        { 0x96CF, 0x4A9C },
        { 0x96D2, 0x6BC2 },
        { 0x96D5, 0x4B92 },
        { 0x96E0, 0x6BC4 },
        { 0x96E8, 0x5A8B },
        { 0x96E9, 0x6BA6 },
        { 0x96EA, 0x5949 },
        { 0x96EF, 0x6BA8 },
        { 0x96F3, 0x6BA7 },
        { 0x96F6, 0x5184 },
        { 0x96F7, 0x50D6 },
        { 0x96F9, 0x4942 },
        { 0x96FE, 0x57EC },
        { 0x9700, 0x58E7 },
        { 0x9701, 0x6BAA },
        { 0x9704, 0x5897 },
        { 0x9706, 0x6BA9 },
        { 0x9707, 0x5B91 },
        { 0x9708, 0x6BAB },
        { 0x9709, 0x5259 },
        { 0x970D, 0x4E95 },
        { 0x970E, 0x6BAD },
        { 0x970F, 0x6BAC },
        { 0x9713, 0x52DD },
        { 0x9716, 0x5178 },
        { 0x971C, 0x564A },
        { 0x971E, 0x585C },
        { 0x972A, 0x6BAE },
        { 0x972D, 0x6BAF },
        { 0x9730, 0x6BB0 },
        { 0x9732, 0x51B5 },
        { 0x9738, 0x48D3 },
        { 0x9739, 0x539A },
        { 0x973E, 0x6BB1 },
        { 0x9752, 0x5481 },
        { 0x9753, 0x6BA5 },
        { 0x9756, 0x4FB7 },
        { 0x9759, 0x4FB1 },
        { 0x975B, 0x4B86 },
        { 0x975E, 0x4C67 },
        { 0x9760, 0x505F },
        { 0x9761, 0x5272 },
        { 0x9762, 0x5287 },
        { 0x9765, 0x5CCB },
        { 0x9769, 0x4CEE },
        { 0x9773, 0x4F9A },
        { 0x9774, 0x5945 },
        { 0x9776, 0x48CF },
        { 0x977C, 0x6C50 },
        { 0x9785, 0x6C51 },
        { 0x978B, 0x58AB },
        { 0x978D, 0x48AF },
        { 0x9791, 0x6C52 },
        { 0x9792, 0x6C53 },
        { 0x9794, 0x6C54 },
        { 0x9798, 0x546A },
        { 0x97A0, 0x4FCE },
        { 0x97A3, 0x6C57 },
        { 0x97AB, 0x6C56 },
        { 0x97AD, 0x497E },
        { 0x97AF, 0x6C55 },
        { 0x97B2, 0x6C58 },
        { 0x97B4, 0x6C59 },
        { 0x97E6, 0x57A3 },
        { 0x97E7, 0x54CC },
        { 0x97E9, 0x4DAA },
        { 0x97EA, 0x64B7 },
        { 0x97EB, 0x64B8 },
        { 0x97EC, 0x64B9 },
        { 0x97ED, 0x4FC1 },
        { 0x97F3, 0x59F3 },
        { 0x97F5, 0x5ACE },
        { 0x97F6, 0x5578 },
        { 0x9875, 0x59B2 },
        { 0x9876, 0x4BA4 },
        { 0x9877, 0x548B },
        { 0x9878, 0x699D },
        { 0x9879, 0x588F },
        { 0x987A, 0x5653 },
        { 0x987B, 0x58EA },
        { 0x987C, 0x6490 },
        { 0x987D, 0x5788 },
        { 0x987E, 0x4D6B },
        { 0x987F, 0x4BD8 },
        { 0x9880, 0x699E },
        { 0x9881, 0x48E3 },
        { 0x9882, 0x566C },
        { 0x9883, 0x699F },
        { 0x9884, 0x5AA3 },
        { 0x9885, 0x51AC },
        { 0x9886, 0x518D },
        { 0x9887, 0x53C3 },
        { 0x9888, 0x4FB0 },
        { 0x9889, 0x69A0 },
        { 0x988A, 0x4ED4 },
        { 0x988C, 0x69A1 },
        { 0x988D, 0x69A2 },
        { 0x988F, 0x69A3 },
        { 0x9890, 0x59C2 },
        { 0x9891, 0x53B4 },
        { 0x9893, 0x5767 },
        { 0x9894, 0x69A4 },
        { 0x9896, 0x5A51 },
        { 0x9897, 0x5065 },
        { 0x9898, 0x56E1 },
        { 0x989A, 0x69A5 },
        { 0x989B, 0x69A6 },
        { 0x989C, 0x5975 },
        { 0x989D, 0x4BED },
        { 0x989E, 0x69A7 },
        { 0x989F, 0x69A8 },
        { 0x98A0, 0x4B7F },
        { 0x98A1, 0x69A9 },
        { 0x98A2, 0x69AA },
        { 0x98A4, 0x49FB },
        { 0x98A5, 0x69AB },
        { 0x98A6, 0x69AC },
        { 0x98A7, 0x54A6 },
        { 0x98CE, 0x4C88 },
        { 0x98D1, 0x66A8 },
        { 0x98D2, 0x66A9 },
        { 0x98D3, 0x66AA },
        { 0x98D5, 0x66AB },
        { 0x98D8, 0x53AD },
        { 0x98D9, 0x66AC },
        { 0x98DA, 0x66AD },
        { 0x98DE, 0x4C69 },
        { 0x98DF, 0x55B2 },
        { 0x98E7, 0x61B7 },
        { 0x98E8, 0x6C6F },
        { 0x990D, 0x6C70 },
        { 0x9910, 0x49CC },
        { 0x992E, 0x6C71 },
        { 0x9954, 0x6C73 },
        { 0x9955, 0x6C72 },
        { 0x9963, 0x61BA },
        { 0x9965, 0x4EA1 },
        { 0x9967, 0x61BB },
        { 0x9968, 0x61BC },
        { 0x9969, 0x61BD },
        { 0x996A, 0x61BE },
        { 0x996B, 0x61BF },
        { 0x996C, 0x61C0 },
        { 0x996D, 0x4C59 },
        { 0x996E, 0x59FA },
        { 0x996F, 0x4F44 },
        { 0x9970, 0x55CD },
        { 0x9971, 0x4945 },
        { 0x9972, 0x5667 },
        { 0x9974, 0x61C1 },
        { 0x9975, 0x4BFB },
        { 0x9976, 0x54C3 },
        { 0x9977, 0x61C2 },
        { 0x997A, 0x4F68 },
        { 0x997C, 0x499E },
        { 0x997D, 0x61C3 },
        { 0x997F, 0x4BF5 },
        { 0x9980, 0x61C4 },
        { 0x9981, 0x52D8 },
        { 0x9984, 0x61C5 },
        { 0x9985, 0x587A },
        { 0x9986, 0x4D7D },
        { 0x9987, 0x61C6 },
        { 0x9988, 0x50A0 },
        { 0x998A, 0x61C7 },
        { 0x998B, 0x49F5 },
        { 0x998D, 0x61C8 },
        { 0x998F, 0x5194 },
        { 0x9990, 0x61C9 },
        { 0x9991, 0x61CA },
        { 0x9992, 0x51F7 },
        { 0x9993, 0x61CB },
        { 0x9994, 0x61CC },
        { 0x9995, 0x61CD },
        { 0x9996, 0x55D6 },
        { 0x9997, 0x5CB7 },
        { 0x9998, 0x5D86 },
        { 0x9999, 0x5884 },
        { 0x99A5, 0x68A4 },
        { 0x99A8, 0x5EAF },
        { 0x9A6C, 0x51EC },
        { 0x9A6D, 0x5AA5 },
        { 0x9A6E, 0x5774 },
        { 0x9A6F, 0x5951 },
        { 0x9A70, 0x4A7B },
        { 0x9A71, 0x549E },
        { 0x9A73, 0x49B4 },
        { 0x9A74, 0x51BE },
        { 0x9A75, 0x63DF },
        { 0x9A76, 0x55BA },
        { 0x9A77, 0x63E0 },
        { 0x9A78, 0x63E1 },
        { 0x9A79, 0x4FD3 },
        { 0x9A7A, 0x63E2 },
        { 0x9A7B, 0x5C44 },
        { 0x9A7C, 0x5775 },
        { 0x9A7D, 0x63E4 },
        { 0x9A7E, 0x4EDC },
        { 0x9A7F, 0x63E3 },
        { 0x9A80, 0x63E5 },
        { 0x9A81, 0x63E6 },
        { 0x9A82, 0x51ED },
        { 0x9A84, 0x4F5E },
        { 0x9A85, 0x63E7 },
        { 0x9A86, 0x51E5 },
        { 0x9A87, 0x4DA6 },
        { 0x9A88, 0x63E8 },
        { 0x9A8A, 0x63E9 },
        { 0x9A8B, 0x4A72 },
        { 0x9A8C, 0x598A },
        { 0x9A8F, 0x5045 },
        { 0x9A90, 0x63EA },
        { 0x9A91, 0x53EE },
        { 0x9A92, 0x63EB },
        { 0x9A93, 0x63EC },
        { 0x9A96, 0x63ED },
        { 0x9A97, 0x53AC },
        { 0x9A98, 0x63EE },
        { 0x9A9A, 0x5547 },
        { 0x9A9B, 0x63EF },
        { 0x9A9C, 0x63F0 },
        { 0x9A9D, 0x63F1 },
        { 0x9A9E, 0x6359 },
        { 0x9A9F, 0x63F2 },
        { 0x9AA0, 0x63F3 },
        { 0x9AA1, 0x51E1 },
        { 0x9AA2, 0x63F4 },
        { 0x9AA3, 0x63F5 },
        { 0x9AA4, 0x5BE7 },
        { 0x9AA5, 0x63F6 },
        { 0x9AA7, 0x63F7 },
        { 0x9AA8, 0x4D67 },
        { 0x9AB0, 0x6C5B },
        { 0x9AB1, 0x6C5A },
        { 0x9AB6, 0x6C5E },
        { 0x9AB7, 0x6C5C },
        { 0x9AB8, 0x4DA0 },
        { 0x9ABA, 0x6C5F },
        { 0x9ABC, 0x6C60 },
        { 0x9AC0, 0x6C62 },
        { 0x9AC1, 0x6C61 },
        { 0x9AC2, 0x6C64 },
        { 0x9AC5, 0x6C63 },
        { 0x9ACB, 0x6C65 },
        { 0x9ACC, 0x6C66 },
        { 0x9AD1, 0x6C67 },
        { 0x9AD3, 0x5689 },
        { 0x9AD8, 0x4CDE },
        { 0x9ADF, 0x6C74 },
        { 0x9AE1, 0x6C75 },
        { 0x9AE6, 0x6C76 },
        { 0x9AEB, 0x6C78 },
        { 0x9AED, 0x6C7A },
        { 0x9AEF, 0x6C77 },
        { 0x9AF9, 0x6C7B },
        { 0x9AFB, 0x6C79 },
        { 0x9B03, 0x5C77 },
        { 0x9B08, 0x6C7C },
        { 0x9B0F, 0x6C7D },
        { 0x9B13, 0x6C7E },
        { 0x9B1F, 0x6C7F },
        { 0x9B23, 0x6C81 },
        { 0x9B2F, 0x5E6B },
        { 0x9B32, 0x5CA9 },
        { 0x9B3B, 0x6398 },
        { 0x9B3C, 0x4D8E },
        { 0x9B41, 0x509E },
        { 0x9B42, 0x4E8B },
        { 0x9B43, 0x6C69 },
        { 0x9B44, 0x53C6 },
        { 0x9B45, 0x6C68 },
        { 0x9B47, 0x6C6A },
        { 0x9B48, 0x6C6C },
        { 0x9B49, 0x6C6B },
        { 0x9B4D, 0x6C6D },
        { 0x9B4F, 0x57B9 },
        { 0x9B51, 0x6C6E },
        { 0x9B54, 0x52A6 },
        { 0x9C7C, 0x5A84 },
        { 0x9C7F, 0x6BCE },
        { 0x9C81, 0x51B2 },
        { 0x9C82, 0x6BCF },
        { 0x9C85, 0x6BD0 },
        { 0x9C86, 0x6BD1 },
        { 0x9C87, 0x6BD2 },
        { 0x9C88, 0x6BD3 },
        { 0x9C8B, 0x6BD5 },
        { 0x9C8D, 0x494B },
        { 0x9C8E, 0x6BD6 },
        { 0x9C90, 0x6BD7 },
        { 0x9C91, 0x6BD8 },
        { 0x9C92, 0x6BD9 },
        { 0x9C94, 0x6BDA },
        { 0x9C95, 0x6BDB },
        { 0x9C9A, 0x6BDC },
        { 0x9C9B, 0x6BDD },
        { 0x9C9C, 0x586A },
        { 0x9C9E, 0x6BDE },
        { 0x9C9F, 0x6BDF },
        { 0x9CA0, 0x6BE0 },
        { 0x9CA1, 0x6BE1 },
        { 0x9CA2, 0x6BE2 },
        { 0x9CA3, 0x6BE3 },
        { 0x9CA4, 0x50EF },
        { 0x9CA5, 0x6BE4 },
        { 0x9CA6, 0x6BE5 },
        { 0x9CA7, 0x6BE6 },
        { 0x9CA8, 0x6BE7 },
        { 0x9CA9, 0x6BE8 },
        { 0x9CAB, 0x6BE9 },
        { 0x9CAD, 0x6BEA },
        { 0x9CAE, 0x6BEB },
        { 0x9CB0, 0x6BEC },
        { 0x9CB1, 0x6BED },
        { 0x9CB2, 0x6BEE },
        { 0x9CB3, 0x6BEF },
        { 0x9CB4, 0x6BF0 },
        { 0x9CB5, 0x6BF1 },
        { 0x9CB6, 0x6BF2 },
        { 0x9CB7, 0x6BF3 },
        { 0x9CB8, 0x4FA7 },
        { 0x9CBA, 0x6BF4 },
        { 0x9CBB, 0x6BF5 },
        { 0x9CBC, 0x6BF6 },
        { 0x9CBD, 0x6BF7 },
        { 0x9CC3, 0x54F9 },
        { 0x9CC4, 0x6BF8 },
        { 0x9CC5, 0x6BF9 },
        { 0x9CC6, 0x6BFA },
        { 0x9CC7, 0x6BFB },
        { 0x9CCA, 0x6BFC },
        { 0x9CCB, 0x6BFD },
        { 0x9CCC, 0x6C41 },
        { 0x9CCD, 0x6C42 },
        { 0x9CCE, 0x6C43 },
        { 0x9CCF, 0x6C44 },
        { 0x9CD0, 0x6C45 },
        { 0x9CD3, 0x6C46 },
        { 0x9CD4, 0x6C47 },
        { 0x9CD5, 0x6C48 },
        { 0x9CD6, 0x498F },
        { 0x9CD7, 0x6C49 },
        { 0x9CD8, 0x6C4A },
        { 0x9CD9, 0x6C4B },
        { 0x9CDC, 0x6C4C },
        { 0x9CDD, 0x6C4D },
        { 0x9CDE, 0x517B },
        { 0x9CDF, 0x6C4E },
        { 0x9CE2, 0x6C4F },
        { 0x9E1F, 0x52F0 },
        { 0x9E20, 0x68AE },
        { 0x9E21, 0x4EA5 },
        { 0x9E22, 0x68AF },
        { 0x9E23, 0x529A },
        { 0x9E25, 0x5358 },
        { 0x9E26, 0x595B },
        { 0x9E28, 0x68B0 },
        { 0x9E29, 0x68B1 },
        { 0x9E2A, 0x68B2 },
        { 0x9E2B, 0x68B3 },
        { 0x9E2C, 0x68B4 },
        { 0x9E2D, 0x595C },
        { 0x9E2F, 0x598D },
        { 0x9E31, 0x68B6 },
        { 0x9E32, 0x68B5 },
        { 0x9E33, 0x5AA6 },
        { 0x9E35, 0x5772 },
        { 0x9E36, 0x68B7 },
        { 0x9E37, 0x68B9 },
        { 0x9E38, 0x68B8 },
        { 0x9E39, 0x68BA },
        { 0x9E3A, 0x68BB },
        { 0x9E3D, 0x4CEA },
        { 0x9E3E, 0x68BC },
        { 0x9E3F, 0x4DE7 },
        { 0x9E41, 0x68BD },
        { 0x9E42, 0x68BE },
        { 0x9E43, 0x4FE8 },
        { 0x9E44, 0x68BF },
        { 0x9E45, 0x4BEB },
        { 0x9E46, 0x68C0 },
        { 0x9E47, 0x68C1 },
        { 0x9E48, 0x68C2 },
        { 0x9E49, 0x68C3 },
        { 0x9E4A, 0x54B4 },
        { 0x9E4B, 0x68C4 },
        { 0x9E4C, 0x68C5 },
        { 0x9E4E, 0x68C6 },
        { 0x9E4F, 0x5395 },
        { 0x9E51, 0x68C7 },
        { 0x9E55, 0x68C8 },
        { 0x9E57, 0x68C9 },
        { 0x9E58, 0x6C5D },
        { 0x9E5A, 0x68CA },
        { 0x9E5B, 0x68CB },
        { 0x9E5C, 0x68CC },
        { 0x9E5E, 0x68CD },
        { 0x9E63, 0x68CE },
        { 0x9E64, 0x4DD6 },
        { 0x9E66, 0x68CF },
        { 0x9E67, 0x68D0 },
        { 0x9E68, 0x68D1 },
        { 0x9E69, 0x68D2 },
        { 0x9E6A, 0x68D3 },
        { 0x9E6B, 0x68D4 },
        { 0x9E6C, 0x68D5 },
        { 0x9E6D, 0x68D7 },
        { 0x9E70, 0x5A45 },
        { 0x9E71, 0x68D6 },
        { 0x9E73, 0x68D8 },
        { 0x9E7E, 0x6B5A },
        { 0x9E7F, 0x51B8 },
        { 0x9E82, 0x6C85 },
        { 0x9E87, 0x6C86 },
        { 0x9E88, 0x6C87 },
        { 0x9E8B, 0x6C88 },
        { 0x9E92, 0x6C89 },
        { 0x9E93, 0x51B3 },
        { 0x9E9D, 0x6C8B },
        { 0x9E9F, 0x6C8C },
        { 0x9EA6, 0x51F2 },
        { 0x9EB4, 0x6AEF },
        { 0x9EB8, 0x6AEE },
        { 0x9EBB, 0x51E8 },
        { 0x9EBD, 0x6C82 },
        { 0x9EBE, 0x6C83 },
        { 0x9EC4, 0x4E66 },
        { 0x9EC9, 0x5D85 },
        { 0x9ECD, 0x55F1 },
        { 0x9ECE, 0x50E7 },
        { 0x9ECF, 0x68A3 },
        { 0x9ED1, 0x4DD9 },
        { 0x9ED4, 0x544D },
        { 0x9ED8, 0x52AB },
        { 0x9EDB, 0x6C8D },
        { 0x9EDC, 0x6C8E },
        { 0x9EDD, 0x6C8F },
        { 0x9EDF, 0x6C91 },
        { 0x9EE0, 0x6C90 },
        { 0x9EE2, 0x6C92 },
        { 0x9EE5, 0x6C95 },
        { 0x9EE7, 0x6C94 },
        { 0x9EE9, 0x6C93 },
        { 0x9EEA, 0x6C96 },
        { 0x9EEF, 0x6C97 },
        { 0x9EF9, 0x678A },
        { 0x9EFB, 0x678B },
        { 0x9EFC, 0x678C },
        { 0x9EFE, 0x6BBB },
        { 0x9F0B, 0x6BBC },
        { 0x9F0D, 0x6BBD },
        { 0x9F0E, 0x4BA5 },
        { 0x9F10, 0x5CBD },
        { 0x9F13, 0x4D64 },
        { 0x9F17, 0x5CBA },
        { 0x9F19, 0x5EB0 },
        { 0x9F20, 0x55F2 },
        { 0x9F22, 0x6C98 },
        { 0x9F2C, 0x6C99 },
        { 0x9F2F, 0x6C9A },
        { 0x9F37, 0x6C9C },
        { 0x9F39, 0x6C9B },
        { 0x9F3B, 0x4967 },
        { 0x9F3D, 0x6C9D },
        { 0x9F3E, 0x6C9E },
        { 0x9F44, 0x6C9F },
        { 0x9F50, 0x53EA },
        { 0x9F51, 0x66B3 },
        { 0x9F7F, 0x4A7D },
        { 0x9F80, 0x6BB2 },
        { 0x9F83, 0x6BB3 },
        { 0x9F84, 0x5185 },
        { 0x9F85, 0x6BB4 },
        { 0x9F86, 0x6BB5 },
        { 0x9F87, 0x6BB6 },
        { 0x9F88, 0x6BB7 },
        { 0x9F89, 0x6BB8 },
        { 0x9F8A, 0x6BB9 },
        { 0x9F8B, 0x54A2 },
        { 0x9F8C, 0x6BBA },
        { 0x9F99, 0x519B },
        { 0x9F9A, 0x4D48 },
        { 0x9F9B, 0x6789 },
        { 0x9F9F, 0x4D8B },
        { 0x9FA0, 0x5D7F },
        { 0xE000, 0x7641 },
        { 0xE001, 0x7642 },
        { 0xE002, 0x7643 },
        { 0xE003, 0x7644 },
        { 0xE004, 0x7645 },
        { 0xE005, 0x7646 },
        { 0xE006, 0x7647 },
        { 0xE007, 0x7648 },
        { 0xE008, 0x7649 },
        { 0xE009, 0x764A },
        { 0xE00A, 0x764B },
        { 0xE00B, 0x764C },
        { 0xE00C, 0x764D },
        { 0xE00D, 0x764E },
        { 0xE00E, 0x764F },
        { 0xE00F, 0x7650 },
        { 0xE010, 0x7651 },
        { 0xE011, 0x7652 },
        { 0xE012, 0x7653 },
        { 0xE013, 0x7654 },
        { 0xE014, 0x7655 },
        { 0xE015, 0x7656 },
        { 0xE016, 0x7657 },
        { 0xE017, 0x7658 },
        { 0xE018, 0x7659 },
        { 0xE019, 0x765A },
        { 0xE01A, 0x765B },
        { 0xE01B, 0x765C },
        { 0xE01C, 0x765D },
        { 0xE01D, 0x765E },
        { 0xE01E, 0x765F },
        { 0xE01F, 0x7660 },
        { 0xE020, 0x7661 },
        { 0xE021, 0x7662 },
        { 0xE022, 0x7663 },
        { 0xE023, 0x7664 },
        { 0xE024, 0x7665 },
        { 0xE025, 0x7666 },
        { 0xE026, 0x7667 },
        { 0xE027, 0x7668 },
        { 0xE028, 0x7669 },
        { 0xE029, 0x766A },
        { 0xE02A, 0x766B },
        { 0xE02B, 0x766C },
        { 0xE02C, 0x766D },
        { 0xE02D, 0x766E },
        { 0xE02E, 0x766F },
        { 0xE02F, 0x7670 },
        { 0xE030, 0x7671 },
        { 0xE031, 0x7672 },
        { 0xE032, 0x7673 },
        { 0xE033, 0x7674 },
        { 0xE034, 0x7675 },
        { 0xE035, 0x7676 },
        { 0xE036, 0x7677 },
        { 0xE037, 0x7678 },
        { 0xE038, 0x7679 },
        { 0xE039, 0x767A },
        { 0xE03A, 0x767B },
        { 0xE03B, 0x767C },
        { 0xE03C, 0x767D },
        { 0xE03D, 0x767E },
        { 0xE03E, 0x767F },
        { 0xE03F, 0x7681 },
        { 0xE040, 0x7682 },
        { 0xE041, 0x7683 },
        { 0xE042, 0x7684 },
        { 0xE043, 0x7685 },
        { 0xE044, 0x7686 },
        { 0xE045, 0x7687 },
        { 0xE046, 0x7688 },
        { 0xE047, 0x7689 },
        { 0xE048, 0x768A },
        { 0xE049, 0x768B },
        { 0xE04A, 0x768C },
        { 0xE04B, 0x768D },
        { 0xE04C, 0x768E },
        { 0xE04D, 0x768F },
        { 0xE04E, 0x7690 },
        { 0xE04F, 0x7691 },
        { 0xE050, 0x7692 },
        { 0xE051, 0x7693 },
        { 0xE052, 0x7694 },
        { 0xE053, 0x7695 },
        { 0xE054, 0x7696 },
        { 0xE055, 0x7697 },
        { 0xE056, 0x7698 },
        { 0xE057, 0x7699 },
        { 0xE058, 0x769A },
        { 0xE059, 0x769B },
        { 0xE05A, 0x769C },
        { 0xE05B, 0x769D },
        { 0xE05C, 0x769E },
        { 0xE05D, 0x769F },
        { 0xE05E, 0x76A0 },
        { 0xE05F, 0x76A1 },
        { 0xE060, 0x76A2 },
        { 0xE061, 0x76A3 },
        { 0xE062, 0x76A4 },
        { 0xE063, 0x76A5 },
        { 0xE064, 0x76A6 },
        { 0xE065, 0x76A7 },
        { 0xE066, 0x76A8 },
        { 0xE067, 0x76A9 },
        { 0xE068, 0x76AA },
        { 0xE069, 0x76AB },
        { 0xE06A, 0x76AC },
        { 0xE06B, 0x76AD },
        { 0xE06C, 0x76AE },
        { 0xE06D, 0x76AF },
        { 0xE06E, 0x76B0 },
        { 0xE06F, 0x76B1 },
        { 0xE070, 0x76B2 },
        { 0xE071, 0x76B3 },
        { 0xE072, 0x76B4 },
        { 0xE073, 0x76B5 },
        { 0xE074, 0x76B6 },
        { 0xE075, 0x76B7 },
        { 0xE076, 0x76B8 },
        { 0xE077, 0x76B9 },
        { 0xE078, 0x76BA },
        { 0xE079, 0x76BB },
        { 0xE07A, 0x76BC },
        { 0xE07B, 0x76BD },
        { 0xE07C, 0x76BE },
        { 0xE07D, 0x76BF },
        { 0xE07E, 0x76C0 },
        { 0xE07F, 0x76C1 },
        { 0xE080, 0x76C2 },
        { 0xE081, 0x76C3 },
        { 0xE082, 0x76C4 },
        { 0xE083, 0x76C5 },
        { 0xE084, 0x76C6 },
        { 0xE085, 0x76C7 },
        { 0xE086, 0x76C8 },
        { 0xE087, 0x76C9 },
        { 0xE088, 0x76CA },
        { 0xE089, 0x76CB },
        { 0xE08A, 0x76CC },
        { 0xE08B, 0x76CD },
        { 0xE08C, 0x76CE },
        { 0xE08D, 0x76CF },
        { 0xE08E, 0x76D0 },
        { 0xE08F, 0x76D1 },
        { 0xE090, 0x76D2 },
        { 0xE091, 0x76D3 },
        { 0xE092, 0x76D4 },
        { 0xE093, 0x76D5 },
        { 0xE094, 0x76D6 },
        { 0xE095, 0x76D7 },
        { 0xE096, 0x76D8 },
        { 0xE097, 0x76D9 },
        { 0xE098, 0x76DA },
        { 0xE099, 0x76DB },
        { 0xE09A, 0x76DC },
        { 0xE09B, 0x76DD },
        { 0xE09C, 0x76DE },
        { 0xE09D, 0x76DF },
        { 0xE09E, 0x76E0 },
        { 0xE09F, 0x76E1 },
        { 0xE0A0, 0x76E2 },
        { 0xE0A1, 0x76E3 },
        { 0xE0A2, 0x76E4 },
        { 0xE0A3, 0x76E5 },
        { 0xE0A4, 0x76E6 },
        { 0xE0A5, 0x76E7 },
        { 0xE0A6, 0x76E8 },
        { 0xE0A7, 0x76E9 },
        { 0xE0A8, 0x76EA },
        { 0xE0A9, 0x76EB },
        { 0xE0AA, 0x76EC },
        { 0xE0AB, 0x76ED },
        { 0xE0AC, 0x76EE },
        { 0xE0AD, 0x76EF },
        { 0xE0AE, 0x76F0 },
        { 0xE0AF, 0x76F1 },
        { 0xE0B0, 0x76F2 },
        { 0xE0B1, 0x76F3 },
        { 0xE0B2, 0x76F4 },
        { 0xE0B3, 0x76F5 },
        { 0xE0B4, 0x76F6 },
        { 0xE0B5, 0x76F7 },
        { 0xE0B6, 0x76F8 },
        { 0xE0B7, 0x76F9 },
        { 0xE0B8, 0x76FA },
        { 0xE0B9, 0x76FB },
        { 0xE0BA, 0x76FC },
        { 0xE0BB, 0x76FD },
        { 0xE0BC, 0x7741 },
        { 0xE0BD, 0x7742 },
        { 0xE0BE, 0x7743 },
        { 0xE0BF, 0x7744 },
        { 0xE0C0, 0x7745 },
        { 0xE0C1, 0x7746 },
        { 0xE0C2, 0x7747 },
        { 0xE0C3, 0x7748 },
        { 0xE0C4, 0x7749 },
        { 0xE0C5, 0x774A },
        { 0xE0C6, 0x774B },
        { 0xE0C7, 0x774C },
        { 0xE0C8, 0x774D },
        { 0xE0C9, 0x774E },
        { 0xE0CA, 0x774F },
        { 0xE0CB, 0x7750 },
        { 0xE0CC, 0x7751 },
        { 0xE0CD, 0x7752 },
        { 0xE0CE, 0x7753 },
        { 0xE0CF, 0x7754 },
        { 0xE0D0, 0x7755 },
        { 0xE0D1, 0x7756 },
        { 0xE0D2, 0x7757 },
        { 0xE0D3, 0x7758 },
        { 0xE0D4, 0x7759 },
        { 0xE0D5, 0x775A },
        { 0xE0D6, 0x775B },
        { 0xE0D7, 0x775C },
        { 0xE0D8, 0x775D },
        { 0xE0D9, 0x775E },
        { 0xE0DA, 0x775F },
        { 0xE0DB, 0x7760 },
        { 0xE0DC, 0x7761 },
        { 0xE0DD, 0x7762 },
        { 0xE0DE, 0x7763 },
        { 0xE0DF, 0x7764 },
        { 0xE0E0, 0x7765 },
        { 0xE0E1, 0x7766 },
        { 0xE0E2, 0x7767 },
        { 0xE0E3, 0x7768 },
        { 0xE0E4, 0x7769 },
        { 0xE0E5, 0x776A },
        { 0xE0E6, 0x776B },
        { 0xE0E7, 0x776C },
        { 0xE0E8, 0x776D },
        { 0xE0E9, 0x776E },
        { 0xE0EA, 0x776F },
        { 0xE0EB, 0x7770 },
        { 0xE0EC, 0x7771 },
        { 0xE0ED, 0x7772 },
        { 0xE0EE, 0x7773 },
        { 0xE0EF, 0x7774 },
        { 0xE0F0, 0x7775 },
        { 0xE0F1, 0x7776 },
        { 0xE0F2, 0x7777 },
        { 0xE0F3, 0x7778 },
        { 0xE0F4, 0x7779 },
        { 0xE0F5, 0x777A },
        { 0xE0F6, 0x777B },
        { 0xE0F7, 0x777C },
        { 0xE0F8, 0x777D },
        { 0xE0F9, 0x777E },
        { 0xE0FA, 0x777F },
        { 0xE0FB, 0x7781 },
        { 0xE0FC, 0x7782 },
        { 0xE0FD, 0x7783 },
        { 0xE0FE, 0x7784 },
        { 0xE0FF, 0x7785 },
        { 0xE100, 0x7786 },
        { 0xE101, 0x7787 },
        { 0xE102, 0x7788 },
        { 0xE103, 0x7789 },
        { 0xE104, 0x778A },
        { 0xE105, 0x778B },
        { 0xE106, 0x778C },
        { 0xE107, 0x778D },
        { 0xE108, 0x778E },
        { 0xE109, 0x778F },
        { 0xE10A, 0x7790 },
        { 0xE10B, 0x7791 },
        { 0xE10C, 0x7792 },
        { 0xE10D, 0x7793 },
        { 0xE10E, 0x7794 },
        { 0xE10F, 0x7795 },
        { 0xE110, 0x7796 },
        { 0xE111, 0x7797 },
        { 0xE112, 0x7798 },
        { 0xE113, 0x7799 },
        { 0xE114, 0x779A },
        { 0xE115, 0x779B },
        { 0xE116, 0x779C },
        { 0xE117, 0x779D },
        { 0xE118, 0x779E },
        { 0xE119, 0x779F },
        { 0xE11A, 0x77A0 },
        { 0xE11B, 0x77A1 },
        { 0xE11C, 0x77A2 },
        { 0xE11D, 0x77A3 },
        { 0xE11E, 0x77A4 },
        { 0xE11F, 0x77A5 },
        { 0xE120, 0x77A6 },
        { 0xE121, 0x77A7 },
        { 0xE122, 0x77A8 },
        { 0xE123, 0x77A9 },
        { 0xE124, 0x77AA },
        { 0xE125, 0x77AB },
        { 0xE126, 0x77AC },
        { 0xE127, 0x77AD },
        { 0xE128, 0x77AE },
        { 0xE129, 0x77AF },
        { 0xE12A, 0x77B0 },
        { 0xE12B, 0x77B1 },
        { 0xE12C, 0x77B2 },
        { 0xE12D, 0x77B3 },
        { 0xE12E, 0x77B4 },
        { 0xE12F, 0x77B5 },
        { 0xE130, 0x77B6 },
        { 0xE131, 0x77B7 },
        { 0xE132, 0x77B8 },
        { 0xE133, 0x77B9 },
        { 0xE134, 0x77BA },
        { 0xE135, 0x77BB },
        { 0xE136, 0x77BC },
        { 0xE137, 0x77BD },
        { 0xE138, 0x77BE },
        { 0xE139, 0x77BF },
        { 0xE13A, 0x77C0 },
        { 0xE13B, 0x77C1 },
        { 0xE13C, 0x77C2 },
        { 0xE13D, 0x77C3 },
        { 0xE13E, 0x77C4 },
        { 0xE13F, 0x77C5 },
        { 0xE140, 0x77C6 },
        { 0xE141, 0x77C7 },
        { 0xE142, 0x77C8 },
        { 0xE143, 0x77C9 },
        { 0xE144, 0x77CA },
        { 0xE145, 0x77CB },
        { 0xE146, 0x77CC },
        { 0xE147, 0x77CD },
        { 0xE148, 0x77CE },
        { 0xE149, 0x77CF },
        { 0xE14A, 0x77D0 },
        { 0xE14B, 0x77D1 },
        { 0xE14C, 0x77D2 },
        { 0xE14D, 0x77D3 },
        { 0xE14E, 0x77D4 },
        { 0xE14F, 0x77D5 },
        { 0xE150, 0x77D6 },
        { 0xE151, 0x77D7 },
        { 0xE152, 0x77D8 },
        { 0xE153, 0x77D9 },
        { 0xE154, 0x77DA },
        { 0xE155, 0x77DB },
        { 0xE156, 0x77DC },
        { 0xE157, 0x77DD },
        { 0xE158, 0x77DE },
        { 0xE159, 0x77DF },
        { 0xE15A, 0x77E0 },
        { 0xE15B, 0x77E1 },
        { 0xE15C, 0x77E2 },
        { 0xE15D, 0x77E3 },
        { 0xE15E, 0x77E4 },
        { 0xE15F, 0x77E5 },
        { 0xE160, 0x77E6 },
        { 0xE161, 0x77E7 },
        { 0xE162, 0x77E8 },
        { 0xE163, 0x77E9 },
        { 0xE164, 0x77EA },
        { 0xE165, 0x77EB },
        { 0xE166, 0x77EC },
        { 0xE167, 0x77ED },
        { 0xE168, 0x77EE },
        { 0xE169, 0x77EF },
        { 0xE16A, 0x77F0 },
        { 0xE16B, 0x77F1 },
        { 0xE16C, 0x77F2 },
        { 0xE16D, 0x77F3 },
        { 0xE16E, 0x77F4 },
        { 0xE16F, 0x77F5 },
        { 0xE170, 0x77F6 },
        { 0xE171, 0x77F7 },
        { 0xE172, 0x77F8 },
        { 0xE173, 0x77F9 },
        { 0xE174, 0x77FA },
        { 0xE175, 0x77FB },
        { 0xE176, 0x77FC },
        { 0xE177, 0x77FD },
        { 0xE178, 0x7841 },
        { 0xE179, 0x7842 },
        { 0xE17A, 0x7843 },
        { 0xE17B, 0x7844 },
        { 0xE17C, 0x7845 },
        { 0xE17D, 0x7846 },
        { 0xE17E, 0x7847 },
        { 0xE17F, 0x7848 },
        { 0xE180, 0x7849 },
        { 0xE181, 0x784A },
        { 0xE182, 0x784B },
        { 0xE183, 0x784C },
        { 0xE184, 0x784D },
        { 0xE185, 0x784E },
        { 0xE186, 0x784F },
        { 0xE187, 0x7850 },
        { 0xE188, 0x7851 },
        { 0xE189, 0x7852 },
        { 0xE18A, 0x7853 },
        { 0xE18B, 0x7854 },
        { 0xE18C, 0x7855 },
        { 0xE18D, 0x7856 },
        { 0xE18E, 0x7857 },
        { 0xE18F, 0x7858 },
        { 0xE190, 0x7859 },
        { 0xE191, 0x785A },
        { 0xE192, 0x785B },
        { 0xE193, 0x785C },
        { 0xE194, 0x785D },
        { 0xE195, 0x785E },
        { 0xE196, 0x785F },
        { 0xE197, 0x7860 },
        { 0xE198, 0x7861 },
        { 0xE199, 0x7862 },
        { 0xE19A, 0x7863 },
        { 0xE19B, 0x7864 },
        { 0xE19C, 0x7865 },
        { 0xE19D, 0x7866 },
        { 0xE19E, 0x7867 },
        { 0xE19F, 0x7868 },
        { 0xE1A0, 0x7869 },
        { 0xE1A1, 0x786A },
        { 0xE1A2, 0x786B },
        { 0xE1A3, 0x786C },
        { 0xE1A4, 0x786D },
        { 0xE1A5, 0x786E },
        { 0xE1A6, 0x786F },
        { 0xE1A7, 0x7870 },
        { 0xE1A8, 0x7871 },
        { 0xE1A9, 0x7872 },
        { 0xE1AA, 0x7873 },
        { 0xE1AB, 0x7874 },
        { 0xE1AC, 0x7875 },
        { 0xE1AD, 0x7876 },
        { 0xE1AE, 0x7877 },
        { 0xE1AF, 0x7878 },
        { 0xE1B0, 0x7879 },
        { 0xE1B1, 0x787A },
        { 0xE1B2, 0x787B },
        { 0xE1B3, 0x787C },
        { 0xE1B4, 0x787D },
        { 0xE1B5, 0x787E },
        { 0xE1B6, 0x787F },
        { 0xE1B7, 0x7881 },
        { 0xE1B8, 0x7882 },
        { 0xE1B9, 0x7883 },
        { 0xE1BA, 0x7884 },
        { 0xE1BB, 0x7885 },
        { 0xE1BC, 0x7886 },
        { 0xE1BD, 0x7887 },
        { 0xE1BE, 0x7888 },
        { 0xE1BF, 0x7889 },
        { 0xE1C0, 0x788A },
        { 0xE1C1, 0x788B },
        { 0xE1C2, 0x788C },
        { 0xE1C3, 0x788D },
        { 0xE1C4, 0x788E },
        { 0xE1C5, 0x788F },
        { 0xE1C6, 0x7890 },
        { 0xE1C7, 0x7891 },
        { 0xE1C8, 0x7892 },
        { 0xE1C9, 0x7893 },
        { 0xE1CA, 0x7894 },
        { 0xE1CB, 0x7895 },
        { 0xE1CC, 0x7896 },
        { 0xE1CD, 0x7897 },
        { 0xE1CE, 0x7898 },
        { 0xE1CF, 0x7899 },
        { 0xE1D0, 0x789A },
        { 0xE1D1, 0x789B },
        { 0xE1D2, 0x789C },
        { 0xE1D3, 0x789D },
        { 0xE1D4, 0x789E },
        { 0xE1D5, 0x789F },
        { 0xE1D6, 0x78A0 },
        { 0xE1D7, 0x78A1 },
        { 0xE1D8, 0x78A2 },
        { 0xE1D9, 0x78A3 },
        { 0xE1DA, 0x78A4 },
        { 0xE1DB, 0x78A5 },
        { 0xE1DC, 0x78A6 },
        { 0xE1DD, 0x78A7 },
        { 0xE1DE, 0x78A8 },
        { 0xE1DF, 0x78A9 },
        { 0xE1E0, 0x78AA },
        { 0xE1E1, 0x78AB },
        { 0xE1E2, 0x78AC },
        { 0xE1E3, 0x78AD },
        { 0xE1E4, 0x78AE },
        { 0xE1E5, 0x78AF },
        { 0xE1E6, 0x78B0 },
        { 0xE1E7, 0x78B1 },
        { 0xE1E8, 0x78B2 },
        { 0xE1E9, 0x78B3 },
        { 0xE1EA, 0x78B4 },
        { 0xE1EB, 0x78B5 },
        { 0xE1EC, 0x78B6 },
        { 0xE1ED, 0x78B7 },
        { 0xE1EE, 0x78B8 },
        { 0xE1EF, 0x78B9 },
        { 0xE1F0, 0x78BA },
        { 0xE1F1, 0x78BB },
        { 0xE1F2, 0x78BC },
        { 0xE1F3, 0x78BD },
        { 0xE1F4, 0x78BE },
        { 0xE1F5, 0x78BF },
        { 0xE1F6, 0x78C0 },
        { 0xE1F7, 0x78C1 },
        { 0xE1F8, 0x78C2 },
        { 0xE1F9, 0x78C3 },
        { 0xE1FA, 0x78C4 },
        { 0xE1FB, 0x78C5 },
        { 0xE1FC, 0x78C6 },
        { 0xE1FD, 0x78C7 },
        { 0xE1FE, 0x78C8 },
        { 0xE1FF, 0x78C9 },
        { 0xE200, 0x78CA },
        { 0xE201, 0x78CB },
        { 0xE202, 0x78CC },
        { 0xE203, 0x78CD },
        { 0xE204, 0x78CE },
        { 0xE205, 0x78CF },
        { 0xE206, 0x78D0 },
        { 0xE207, 0x78D1 },
        { 0xE208, 0x78D2 },
        { 0xE209, 0x78D3 },
        { 0xE20A, 0x78D4 },
        { 0xE20B, 0x78D5 },
        { 0xE20C, 0x78D6 },
        { 0xE20D, 0x78D7 },
        { 0xE20E, 0x78D8 },
        { 0xE20F, 0x78D9 },
        { 0xE210, 0x78DA },
        { 0xE211, 0x78DB },
        { 0xE212, 0x78DC },
        { 0xE213, 0x78DD },
        { 0xE214, 0x78DE },
        { 0xE215, 0x78DF },
        { 0xE216, 0x78E0 },
        { 0xE217, 0x78E1 },
        { 0xE218, 0x78E2 },
        { 0xE219, 0x78E3 },
        { 0xE21A, 0x78E4 },
        { 0xE21B, 0x78E5 },
        { 0xE21C, 0x78E6 },
        { 0xE21D, 0x78E7 },
        { 0xE21E, 0x78E8 },
        { 0xE21F, 0x78E9 },
        { 0xE220, 0x78EA },
        { 0xE221, 0x78EB },
        { 0xE222, 0x78EC },
        { 0xE223, 0x78ED },
        { 0xE224, 0x78EE },
        { 0xE225, 0x78EF },
        { 0xE226, 0x78F0 },
        { 0xE227, 0x78F1 },
        { 0xE228, 0x78F2 },
        { 0xE229, 0x78F3 },
        { 0xE22A, 0x78F4 },
        { 0xE22B, 0x78F5 },
        { 0xE22C, 0x78F6 },
        { 0xE22D, 0x78F7 },
        { 0xE22E, 0x78F8 },
        { 0xE22F, 0x78F9 },
        { 0xE230, 0x78FA },
        { 0xE231, 0x78FB },
        { 0xE232, 0x78FC },
        { 0xE233, 0x78FD },
        { 0xE234, 0x7941 },
        { 0xE235, 0x7942 },
        { 0xE236, 0x7943 },
        { 0xE237, 0x7944 },
        { 0xE238, 0x7945 },
        { 0xE239, 0x7946 },
        { 0xE23A, 0x7947 },
        { 0xE23B, 0x7948 },
        { 0xE23C, 0x7949 },
        { 0xE23D, 0x794A },
        { 0xE23E, 0x794B },
        { 0xE23F, 0x794C },
        { 0xE240, 0x794D },
        { 0xE241, 0x794E },
        { 0xE242, 0x794F },
        { 0xE243, 0x7950 },
        { 0xE244, 0x7951 },
        { 0xE245, 0x7952 },
        { 0xE246, 0x7953 },
        { 0xE247, 0x7954 },
        { 0xE248, 0x7955 },
        { 0xE249, 0x7956 },
        { 0xE24A, 0x7957 },
        { 0xE24B, 0x7958 },
        { 0xE24C, 0x7959 },
        { 0xE24D, 0x795A },
        { 0xE24E, 0x795B },
        { 0xE24F, 0x795C },
        { 0xE250, 0x795D },
        { 0xE251, 0x795E },
        { 0xE252, 0x795F },
        { 0xE253, 0x7960 },
        { 0xE254, 0x7961 },
        { 0xE255, 0x7962 },
        { 0xE256, 0x7963 },
        { 0xE257, 0x7964 },
        { 0xE258, 0x7965 },
        { 0xE259, 0x7966 },
        { 0xE25A, 0x7967 },
        { 0xE25B, 0x7968 },
        { 0xE25C, 0x7969 },
        { 0xE25D, 0x796A },
        { 0xE25E, 0x796B },
        { 0xE25F, 0x796C },
        { 0xE260, 0x796D },
        { 0xE261, 0x796E },
        { 0xE262, 0x796F },
        { 0xE263, 0x7970 },
        { 0xE264, 0x7971 },
        { 0xE265, 0x7972 },
        { 0xE266, 0x7973 },
        { 0xE267, 0x7974 },
        { 0xE268, 0x7975 },
        { 0xE269, 0x7976 },
        { 0xE26A, 0x7977 },
        { 0xE26B, 0x7978 },
        { 0xE26C, 0x7979 },
        { 0xE26D, 0x797A },
        { 0xE26E, 0x797B },
        { 0xE26F, 0x797C },
        { 0xE270, 0x797D },
        { 0xE271, 0x797E },
        { 0xE272, 0x797F },
        { 0xE273, 0x7981 },
        { 0xE274, 0x7982 },
        { 0xE275, 0x7983 },
        { 0xE276, 0x7984 },
        { 0xE277, 0x7985 },
        { 0xE278, 0x7986 },
        { 0xE279, 0x7987 },
        { 0xE27A, 0x7988 },
        { 0xE27B, 0x7989 },
        { 0xE27C, 0x798A },
        { 0xE27D, 0x798B },
        { 0xE27E, 0x798C },
        { 0xE27F, 0x798D },
        { 0xE280, 0x798E },
        { 0xE281, 0x798F },
        { 0xE282, 0x7990 },
        { 0xE283, 0x7991 },
        { 0xE284, 0x7992 },
        { 0xE285, 0x7993 },
        { 0xE286, 0x7994 },
        { 0xE287, 0x7995 },
        { 0xE288, 0x7996 },
        { 0xE289, 0x7997 },
        { 0xE28A, 0x7998 },
        { 0xE28B, 0x7999 },
        { 0xE28C, 0x799A },
        { 0xE28D, 0x799B },
        { 0xE28E, 0x799C },
        { 0xE28F, 0x799D },
        { 0xE290, 0x799E },
        { 0xE291, 0x799F },
        { 0xE292, 0x79A0 },
        { 0xE293, 0x79A1 },
        { 0xE294, 0x79A2 },
        { 0xE295, 0x79A3 },
        { 0xE296, 0x79A4 },
        { 0xE297, 0x79A5 },
        { 0xE298, 0x79A6 },
        { 0xE299, 0x79A7 },
        { 0xE29A, 0x79A8 },
        { 0xE29B, 0x79A9 },
        { 0xE29C, 0x79AA },
        { 0xE29D, 0x79AB },
        { 0xE29E, 0x79AC },
        { 0xE29F, 0x79AD },
        { 0xE2A0, 0x79AE },
        { 0xE2A1, 0x79AF },
        { 0xE2A2, 0x79B0 },
        { 0xE2A3, 0x79B1 },
        { 0xE2A4, 0x79B2 },
        { 0xE2A5, 0x79B3 },
        { 0xE2A6, 0x79B4 },
        { 0xE2A7, 0x79B5 },
        { 0xE2A8, 0x79B6 },
        { 0xE2A9, 0x79B7 },
        { 0xE2AA, 0x79B8 },
        { 0xE2AB, 0x79B9 },
        { 0xE2AC, 0x79BA },
        { 0xE2AD, 0x79BB },
        { 0xE2AE, 0x79BC },
        { 0xE2AF, 0x79BD },
        { 0xE2B0, 0x79BE },
        { 0xE2B1, 0x79BF },
        { 0xE2B2, 0x79C0 },
        { 0xE2B3, 0x79C1 },
        { 0xE2B4, 0x79C2 },
        { 0xE2B5, 0x79C3 },
        { 0xE2B6, 0x79C4 },
        { 0xE2B7, 0x79C5 },
        { 0xE2B8, 0x79C6 },
        { 0xE2B9, 0x79C7 },
        { 0xE2BA, 0x79C8 },
        { 0xE2BB, 0x79C9 },
        { 0xE2BC, 0x79CA },
        { 0xE2BD, 0x79CB },
        { 0xE2BE, 0x79CC },
        { 0xE2BF, 0x79CD },
        { 0xE2C0, 0x79CE },
        { 0xE2C1, 0x79CF },
        { 0xE2C2, 0x79D0 },
        { 0xE2C3, 0x79D1 },
        { 0xE2C4, 0x79D2 },
        { 0xE2C5, 0x79D3 },
        { 0xE2C6, 0x79D4 },
        { 0xE2C7, 0x79D5 },
        { 0xE2C8, 0x79D6 },
        { 0xE2C9, 0x79D7 },
        { 0xE2CA, 0x79D8 },
        { 0xE2CB, 0x79D9 },
        { 0xE2CC, 0x79DA },
        { 0xE2CD, 0x79DB },
        { 0xE2CE, 0x79DC },
        { 0xE2CF, 0x79DD },
        { 0xE2D0, 0x79DE },
        { 0xE2D1, 0x79DF },
        { 0xE2D2, 0x79E0 },
        { 0xE2D3, 0x79E1 },
        { 0xE2D4, 0x79E2 },
        { 0xE2D5, 0x79E3 },
        { 0xE2D6, 0x79E4 },
        { 0xE2D7, 0x79E5 },
        { 0xE2D8, 0x79E6 },
        { 0xE2D9, 0x79E7 },
        { 0xE2DA, 0x79E8 },
        { 0xE2DB, 0x79E9 },
        { 0xE2DC, 0x79EA },
        { 0xE2DD, 0x79EB },
        { 0xE2DE, 0x79EC },
        { 0xE2DF, 0x79ED },
        { 0xE2E0, 0x79EE },
        { 0xE2E1, 0x79EF },
        { 0xE2E2, 0x79F0 },
        { 0xE2E3, 0x79F1 },
        { 0xE2E4, 0x79F2 },
        { 0xE2E5, 0x79F3 },
        { 0xE2E6, 0x79F4 },
        { 0xE2E7, 0x79F5 },
        { 0xE2E8, 0x79F6 },
        { 0xE2E9, 0x79F7 },
        { 0xE2EA, 0x79F8 },
        { 0xE2EB, 0x79F9 },
        { 0xE2EC, 0x79FA },
        { 0xE2ED, 0x79FB },
        { 0xE2EE, 0x79FC },
        { 0xE2EF, 0x79FD },
        { 0xE2F0, 0x7A41 },
        { 0xE2F1, 0x7A42 },
        { 0xE2F2, 0x7A43 },
        { 0xE2F3, 0x7A44 },
        { 0xE2F4, 0x7A45 },
        { 0xE2F5, 0x7A46 },
        { 0xE2F6, 0x7A47 },
        { 0xE2F7, 0x7A48 },
        { 0xE2F8, 0x7A49 },
        { 0xE2F9, 0x7A4A },
        { 0xE2FA, 0x7A4B },
        { 0xE2FB, 0x7A4C },
        { 0xE2FC, 0x7A4D },
        { 0xE2FD, 0x7A4E },
        { 0xE2FE, 0x7A4F },
        { 0xE2FF, 0x7A50 },
        { 0xE300, 0x7A51 },
        { 0xE301, 0x7A52 },
        { 0xE302, 0x7A53 },
        { 0xE303, 0x7A54 },
        { 0xE304, 0x7A55 },
        { 0xE305, 0x7A56 },
        { 0xE306, 0x7A57 },
        { 0xE307, 0x7A58 },
        { 0xE308, 0x7A59 },
        { 0xE309, 0x7A5A },
        { 0xE30A, 0x7A5B },
        { 0xE30B, 0x7A5C },
        { 0xE30C, 0x7A5D },
        { 0xE30D, 0x7A5E },
        { 0xE30E, 0x7A5F },
        { 0xE30F, 0x7A60 },
        { 0xE310, 0x7A61 },
        { 0xE311, 0x7A62 },
        { 0xE312, 0x7A63 },
        { 0xE313, 0x7A64 },
        { 0xE314, 0x7A65 },
        { 0xE315, 0x7A66 },
        { 0xE316, 0x7A67 },
        { 0xE317, 0x7A68 },
        { 0xE318, 0x7A69 },
        { 0xE319, 0x7A6A },
        { 0xE31A, 0x7A6B },
        { 0xE31B, 0x7A6C },
        { 0xE31C, 0x7A6D },
        { 0xE31D, 0x7A6E },
        { 0xE31E, 0x7A6F },
        { 0xE31F, 0x7A70 },
        { 0xE320, 0x7A71 },
        { 0xE321, 0x7A72 },
        { 0xE322, 0x7A73 },
        { 0xE323, 0x7A74 },
        { 0xE324, 0x7A75 },
        { 0xE325, 0x7A76 },
        { 0xE326, 0x7A77 },
        { 0xE327, 0x7A78 },
        { 0xE328, 0x7A79 },
        { 0xE329, 0x7A7A },
        { 0xE32A, 0x7A7B },
        { 0xE32B, 0x7A7C },
        { 0xE32C, 0x7A7D },
        { 0xE32D, 0x7A7E },
        { 0xE32E, 0x7A7F },
        { 0xE32F, 0x7A81 },
        { 0xE330, 0x7A82 },
        { 0xE331, 0x7A83 },
        { 0xE332, 0x7A84 },
        { 0xE333, 0x7A85 },
        { 0xE334, 0x7A86 },
        { 0xE335, 0x7A87 },
        { 0xE336, 0x7A88 },
        { 0xE337, 0x7A89 },
        { 0xE338, 0x7A8A },
        { 0xE339, 0x7A8B },
        { 0xE33A, 0x7A8C },
        { 0xE33B, 0x7A8D },
        { 0xE33C, 0x7A8E },
        { 0xE33D, 0x7A8F },
        { 0xE33E, 0x7A90 },
        { 0xE33F, 0x7A91 },
        { 0xE340, 0x7A92 },
        { 0xE341, 0x7A93 },
        { 0xE342, 0x7A94 },
        { 0xE343, 0x7A95 },
        { 0xE344, 0x7A96 },
        { 0xE345, 0x7A97 },
        { 0xE346, 0x7A98 },
        { 0xE347, 0x7A99 },
        { 0xE348, 0x7A9A },
        { 0xE349, 0x7A9B },
        { 0xE34A, 0x7A9C },
        { 0xE34B, 0x7A9D },
        { 0xE34C, 0x7A9E },
        { 0xE34D, 0x7A9F },
        { 0xE34E, 0x7AA0 },
        { 0xE34F, 0x7AA1 },
        { 0xE350, 0x7AA2 },
        { 0xE351, 0x7AA3 },
        { 0xE352, 0x7AA4 },
        { 0xE353, 0x7AA5 },
        { 0xE354, 0x7AA6 },
        { 0xE355, 0x7AA7 },
        { 0xE356, 0x7AA8 },
        { 0xE357, 0x7AA9 },
        { 0xE358, 0x7AAA },
        { 0xE359, 0x7AAB },
        { 0xE35A, 0x7AAC },
        { 0xE35B, 0x7AAD },
        { 0xE35C, 0x7AAE },
        { 0xE35D, 0x7AAF },
        { 0xE35E, 0x7AB0 },
        { 0xE35F, 0x7AB1 },
        { 0xE360, 0x7AB2 },
        { 0xE361, 0x7AB3 },
        { 0xE362, 0x7AB4 },
        { 0xE363, 0x7AB5 },
        { 0xE364, 0x7AB6 },
        { 0xE365, 0x7AB7 },
        { 0xE366, 0x7AB8 },
        { 0xE367, 0x7AB9 },
        { 0xE368, 0x7ABA },
        { 0xE369, 0x7ABB },
        { 0xE36A, 0x7ABC },
        { 0xE36B, 0x7ABD },
        { 0xE36C, 0x7ABE },
        { 0xE36D, 0x7ABF },
        { 0xE36E, 0x7AC0 },
        { 0xE36F, 0x7AC1 },
        { 0xE370, 0x7AC2 },
        { 0xE371, 0x7AC3 },
        { 0xE372, 0x7AC4 },
        { 0xE373, 0x7AC5 },
        { 0xE374, 0x7AC6 },
        { 0xE375, 0x7AC7 },
        { 0xE376, 0x7AC8 },
        { 0xE377, 0x7AC9 },
        { 0xE378, 0x7ACA },
        { 0xE379, 0x7ACB },
        { 0xE37A, 0x7ACC },
        { 0xE37B, 0x7ACD },
        { 0xE37C, 0x7ACE },
        { 0xE37D, 0x7ACF },
        { 0xE37E, 0x7AD0 },
        { 0xE37F, 0x7AD1 },
        { 0xE380, 0x7AD2 },
        { 0xE381, 0x7AD3 },
        { 0xE382, 0x7AD4 },
        { 0xE383, 0x7AD5 },
        { 0xE384, 0x7AD6 },
        { 0xE385, 0x7AD7 },
        { 0xE386, 0x7AD8 },
        { 0xE387, 0x7AD9 },
        { 0xE388, 0x7ADA },
        { 0xE389, 0x7ADB },
        { 0xE38A, 0x7ADC },
        { 0xE38B, 0x7ADD },
        { 0xE38C, 0x7ADE },
        { 0xE38D, 0x7ADF },
        { 0xE38E, 0x7AE0 },
        { 0xE38F, 0x7AE1 },
        { 0xE390, 0x7AE2 },
        { 0xE391, 0x7AE3 },
        { 0xE392, 0x7AE4 },
        { 0xE393, 0x7AE5 },
        { 0xE394, 0x7AE6 },
        { 0xE395, 0x7AE7 },
        { 0xE396, 0x7AE8 },
        { 0xE397, 0x7AE9 },
        { 0xE398, 0x7AEA },
        { 0xE399, 0x7AEB },
        { 0xE39A, 0x7AEC },
        { 0xE39B, 0x7AED },
        { 0xE39C, 0x7AEE },
        { 0xE39D, 0x7AEF },
        { 0xE39E, 0x7AF0 },
        { 0xE39F, 0x7AF1 },
        { 0xE3A0, 0x7AF2 },
        { 0xE3A1, 0x7AF3 },
        { 0xE3A2, 0x7AF4 },
        { 0xE3A3, 0x7AF5 },
        { 0xE3A4, 0x7AF6 },
        { 0xE3A5, 0x7AF7 },
        { 0xE3A6, 0x7AF8 },
        { 0xE3A7, 0x7AF9 },
        { 0xE3A8, 0x7AFA },
        { 0xE3A9, 0x7AFB },
        { 0xE3AA, 0x7AFC },
        { 0xE3AB, 0x7AFD },
        { 0xE3AC, 0x7B41 },
        { 0xE3AD, 0x7B42 },
        { 0xE3AE, 0x7B43 },
        { 0xE3AF, 0x7B44 },
        { 0xE3B0, 0x7B45 },
        { 0xE3B1, 0x7B46 },
        { 0xE3B2, 0x7B47 },
        { 0xE3B3, 0x7B48 },
        { 0xE3B4, 0x7B49 },
        { 0xE3B5, 0x7B4A },
        { 0xE3B6, 0x7B4B },
        { 0xE3B7, 0x7B4C },
        { 0xE3B8, 0x7B4D },
        { 0xE3B9, 0x7B4E },
        { 0xE3BA, 0x7B4F },
        { 0xE3BB, 0x7B50 },
        { 0xE3BC, 0x7B51 },
        { 0xE3BD, 0x7B52 },
        { 0xE3BE, 0x7B53 },
        { 0xE3BF, 0x7B54 },
        { 0xE3C0, 0x7B55 },
        { 0xE3C1, 0x7B56 },
        { 0xE3C2, 0x7B57 },
        { 0xE3C3, 0x7B58 },
        { 0xE3C4, 0x7B59 },
        { 0xE3C5, 0x7B5A },
        { 0xE3C6, 0x7B5B },
        { 0xE3C7, 0x7B5C },
        { 0xE3C8, 0x7B5D },
        { 0xE3C9, 0x7B5E },
        { 0xE3CA, 0x7B5F },
        { 0xE3CB, 0x7B60 },
        { 0xE3CC, 0x7B61 },
        { 0xE3CD, 0x7B62 },
        { 0xE3CE, 0x7B63 },
        { 0xE3CF, 0x7B64 },
        { 0xE3D0, 0x7B65 },
        { 0xE3D1, 0x7B66 },
        { 0xE3D2, 0x7B67 },
        { 0xE3D3, 0x7B68 },
        { 0xE3D4, 0x7B69 },
        { 0xE3D5, 0x7B6A },
        { 0xE3D6, 0x7B6B },
        { 0xE3D7, 0x7B6C },
        { 0xE3D8, 0x7B6D },
        { 0xE3D9, 0x7B6E },
        { 0xE3DA, 0x7B6F },
        { 0xE3DB, 0x7B70 },
        { 0xE3DC, 0x7B71 },
        { 0xE3DD, 0x7B72 },
        { 0xE3DE, 0x7B73 },
        { 0xE3DF, 0x7B74 },
        { 0xE3E0, 0x7B75 },
        { 0xE3E1, 0x7B76 },
        { 0xE3E2, 0x7B77 },
        { 0xE3E3, 0x7B78 },
        { 0xE3E4, 0x7B79 },
        { 0xE3E5, 0x7B7A },
        { 0xE3E6, 0x7B7B },
        { 0xE3E7, 0x7B7C },
        { 0xE3E8, 0x7B7D },
        { 0xE3E9, 0x7B7E },
        { 0xE3EA, 0x7B7F },
        { 0xE3EB, 0x7B81 },
        { 0xE3EC, 0x7B82 },
        { 0xE3ED, 0x7B83 },
        { 0xE3EE, 0x7B84 },
        { 0xE3EF, 0x7B85 },
        { 0xE3F0, 0x7B86 },
        { 0xE3F1, 0x7B87 },
        { 0xE3F2, 0x7B88 },
        { 0xE3F3, 0x7B89 },
        { 0xE3F4, 0x7B8A },
        { 0xE3F5, 0x7B8B },
        { 0xE3F6, 0x7B8C },
        { 0xE3F7, 0x7B8D },
        { 0xE3F8, 0x7B8E },
        { 0xE3F9, 0x7B8F },
        { 0xE3FA, 0x7B90 },
        { 0xE3FB, 0x7B91 },
        { 0xE3FC, 0x7B92 },
        { 0xE3FD, 0x7B93 },
        { 0xE3FE, 0x7B94 },
        { 0xE3FF, 0x7B95 },
        { 0xE400, 0x7B96 },
        { 0xE401, 0x7B97 },
        { 0xE402, 0x7B98 },
        { 0xE403, 0x7B99 },
        { 0xE404, 0x7B9A },
        { 0xE405, 0x7B9B },
        { 0xE406, 0x7B9C },
        { 0xE407, 0x7B9D },
        { 0xE408, 0x7B9E },
        { 0xE409, 0x7B9F },
        { 0xE40A, 0x7BA0 },
        { 0xE40B, 0x7BA1 },
        { 0xE40C, 0x7BA2 },
        { 0xE40D, 0x7BA3 },
        { 0xE40E, 0x7BA4 },
        { 0xE40F, 0x7BA5 },
        { 0xE410, 0x7BA6 },
        { 0xE411, 0x7BA7 },
        { 0xE412, 0x7BA8 },
        { 0xE413, 0x7BA9 },
        { 0xE414, 0x7BAA },
        { 0xE415, 0x7BAB },
        { 0xE416, 0x7BAC },
        { 0xE417, 0x7BAD },
        { 0xE418, 0x7BAE },
        { 0xE419, 0x7BAF },
        { 0xE41A, 0x7BB0 },
        { 0xE41B, 0x7BB1 },
        { 0xE41C, 0x7BB2 },
        { 0xE41D, 0x7BB3 },
        { 0xE41E, 0x7BB4 },
        { 0xE41F, 0x7BB5 },
        { 0xE420, 0x7BB6 },
        { 0xE421, 0x7BB7 },
        { 0xE422, 0x7BB8 },
        { 0xE423, 0x7BB9 },
        { 0xE424, 0x7BBA },
        { 0xE425, 0x7BBB },
        { 0xE426, 0x7BBC },
        { 0xE427, 0x7BBD },
        { 0xE428, 0x7BBE },
        { 0xE429, 0x7BBF },
        { 0xE42A, 0x7BC0 },
        { 0xE42B, 0x7BC1 },
        { 0xE42C, 0x7BC2 },
        { 0xE42D, 0x7BC3 },
        { 0xE42E, 0x7BC4 },
        { 0xE42F, 0x7BC5 },
        { 0xE430, 0x7BC6 },
        { 0xE431, 0x7BC7 },
        { 0xE432, 0x7BC8 },
        { 0xE433, 0x7BC9 },
        { 0xE434, 0x7BCA },
        { 0xE435, 0x7BCB },
        { 0xE436, 0x7BCC },
        { 0xE437, 0x7BCD },
        { 0xE438, 0x7BCE },
        { 0xE439, 0x7BCF },
        { 0xE43A, 0x7BD0 },
        { 0xE43B, 0x7BD1 },
        { 0xE43C, 0x7BD2 },
        { 0xE43D, 0x7BD3 },
        { 0xE43E, 0x7BD4 },
        { 0xE43F, 0x7BD5 },
        { 0xE440, 0x7BD6 },
        { 0xE441, 0x7BD7 },
        { 0xE442, 0x7BD8 },
        { 0xE443, 0x7BD9 },
        { 0xE444, 0x7BDA },
        { 0xE445, 0x7BDB },
        { 0xE446, 0x7BDC },
        { 0xE447, 0x7BDD },
        { 0xE448, 0x7BDE },
        { 0xE449, 0x7BDF },
        { 0xE44A, 0x7BE0 },
        { 0xE44B, 0x7BE1 },
        { 0xE44C, 0x7BE2 },
        { 0xE44D, 0x7BE3 },
        { 0xE44E, 0x7BE4 },
        { 0xE44F, 0x7BE5 },
        { 0xE450, 0x7BE6 },
        { 0xE451, 0x7BE7 },
        { 0xE452, 0x7BE8 },
        { 0xE453, 0x7BE9 },
        { 0xE454, 0x7BEA },
        { 0xE455, 0x7BEB },
        { 0xE456, 0x7BEC },
        { 0xE457, 0x7BED },
        { 0xE458, 0x7BEE },
        { 0xE459, 0x7BEF },
        { 0xE45A, 0x7BF0 },
        { 0xE45B, 0x7BF1 },
        { 0xE45C, 0x7BF2 },
        { 0xE45D, 0x7BF3 },
        { 0xE45E, 0x7BF4 },
        { 0xE45F, 0x7BF5 },
        { 0xE460, 0x7BF6 },
        { 0xE461, 0x7BF7 },
        { 0xE462, 0x7BF8 },
        { 0xE463, 0x7BF9 },
        { 0xE464, 0x7BFA },
        { 0xE465, 0x7BFB },
        { 0xE466, 0x7BFC },
        { 0xE467, 0x7BFD },
        { 0xE468, 0x7C41 },
        { 0xE469, 0x7C42 },
        { 0xE46A, 0x7C43 },
        { 0xE46B, 0x7C44 },
        { 0xE46C, 0x7C45 },
        { 0xE46D, 0x7C46 },
        { 0xE46E, 0x7C47 },
        { 0xE46F, 0x7C48 },
        { 0xE470, 0x7C49 },
        { 0xE471, 0x7C4A },
        { 0xE472, 0x7C4B },
        { 0xE473, 0x7C4C },
        { 0xE474, 0x7C4D },
        { 0xE475, 0x7C4E },
        { 0xE476, 0x7C4F },
        { 0xE477, 0x7C50 },
        { 0xE478, 0x7C51 },
        { 0xE479, 0x7C52 },
        { 0xE47A, 0x7C53 },
        { 0xE47B, 0x7C54 },
        { 0xE47C, 0x7C55 },
        { 0xE47D, 0x7C56 },
        { 0xE47E, 0x7C57 },
        { 0xE47F, 0x7C58 },
        { 0xE480, 0x7C59 },
        { 0xE481, 0x7C5A },
        { 0xE482, 0x7C5B },
        { 0xE483, 0x7C5C },
        { 0xE484, 0x7C5D },
        { 0xE485, 0x7C5E },
        { 0xE486, 0x7C5F },
        { 0xE487, 0x7C60 },
        { 0xE488, 0x7C61 },
        { 0xE489, 0x7C62 },
        { 0xE48A, 0x7C63 },
        { 0xE48B, 0x7C64 },
        { 0xE48C, 0x7C65 },
        { 0xE48D, 0x7C66 },
        { 0xE48E, 0x7C67 },
        { 0xE48F, 0x7C68 },
        { 0xE490, 0x7C69 },
        { 0xE491, 0x7C6A },
        { 0xE492, 0x7C6B },
        { 0xE493, 0x7C6C },
        { 0xE494, 0x7C6D },
        { 0xE495, 0x7C6E },
        { 0xE496, 0x7C6F },
        { 0xE497, 0x7C70 },
        { 0xE498, 0x7C71 },
        { 0xE499, 0x7C72 },
        { 0xE49A, 0x7C73 },
        { 0xE49B, 0x7C74 },
        { 0xE49C, 0x7C75 },
        { 0xE49D, 0x7C76 },
        { 0xE49E, 0x7C77 },
        { 0xE49F, 0x7C78 },
        { 0xE4A0, 0x7C79 },
        { 0xE4A1, 0x7C7A },
        { 0xE4A2, 0x7C7B },
        { 0xE4A3, 0x7C7C },
        { 0xE4A4, 0x7C7D },
        { 0xE4A5, 0x7C7E },
        { 0xE4A6, 0x7C7F },
        { 0xE4A7, 0x7C81 },
        { 0xE4A8, 0x7C82 },
        { 0xE4A9, 0x7C83 },
        { 0xE4AA, 0x7C84 },
        { 0xE4AB, 0x7C85 },
        { 0xE4AC, 0x7C86 },
        { 0xE4AD, 0x7C87 },
        { 0xE4AE, 0x7C88 },
        { 0xE4AF, 0x7C89 },
        { 0xE4B0, 0x7C8A },
        { 0xE4B1, 0x7C8B },
        { 0xE4B2, 0x7C8C },
        { 0xE4B3, 0x7C8D },
        { 0xE4B4, 0x7C8E },
        { 0xE4B5, 0x7C8F },
        { 0xE4B6, 0x7C90 },
        { 0xE4B7, 0x7C91 },
        { 0xE4B8, 0x7C92 },
        { 0xE4B9, 0x7C93 },
        { 0xE4BA, 0x7C94 },
        { 0xE4BB, 0x7C95 },
        { 0xE4BC, 0x7C96 },
        { 0xE4BD, 0x7C97 },
        { 0xE4BE, 0x7C98 },
        { 0xE4BF, 0x7C99 },
        { 0xE4C0, 0x7C9A },
        { 0xE4C1, 0x7C9B },
        { 0xE4C2, 0x7C9C },
        { 0xE4C3, 0x7C9D },
        { 0xE4C4, 0x7C9E },
        { 0xE4C5, 0x7C9F },
        { 0xE4C6, 0x7CA0 },
        { 0xE4C7, 0x7CA1 },
        { 0xE4C8, 0x7CA2 },
        { 0xE4C9, 0x7CA3 },
        { 0xE4CA, 0x7CA4 },
        { 0xE4CB, 0x7CA5 },
        { 0xE4CC, 0x7CA6 },
        { 0xE4CD, 0x7CA7 },
        { 0xE4CE, 0x7CA8 },
        { 0xE4CF, 0x7CA9 },
        { 0xE4D0, 0x7CAA },
        { 0xE4D1, 0x7CAB },
        { 0xE4D2, 0x7CAC },
        { 0xE4D3, 0x7CAD },
        { 0xE4D4, 0x7CAE },
        { 0xE4D5, 0x7CAF },
        { 0xE4D6, 0x7CB0 },
        { 0xE4D7, 0x7CB1 },
        { 0xE4D8, 0x7CB2 },
        { 0xE4D9, 0x7CB3 },
        { 0xE4DA, 0x7CB4 },
        { 0xE4DB, 0x7CB5 },
        { 0xE4DC, 0x7CB6 },
        { 0xE4DD, 0x7CB7 },
        { 0xE4DE, 0x7CB8 },
        { 0xE4DF, 0x7CB9 },
        { 0xE4E0, 0x7CBA },
        { 0xE4E1, 0x7CBB },
        { 0xE4E2, 0x7CBC },
        { 0xE4E3, 0x7CBD },
        { 0xE4E4, 0x7CBE },
        { 0xE4E5, 0x7CBF },
        { 0xE4E6, 0x7CC0 },
        { 0xE4E7, 0x7CC1 },
        { 0xE4E8, 0x7CC2 },
        { 0xE4E9, 0x7CC3 },
        { 0xE4EA, 0x7CC4 },
        { 0xE4EB, 0x7CC5 },
        { 0xE4EC, 0x7CC6 },
        { 0xE4ED, 0x7CC7 },
        { 0xE4EE, 0x7CC8 },
        { 0xE4EF, 0x7CC9 },
        { 0xE4F0, 0x7CCA },
        { 0xE4F1, 0x7CCB },
        { 0xE4F2, 0x7CCC },
        { 0xE4F3, 0x7CCD },
        { 0xE4F4, 0x7CCE },
        { 0xE4F5, 0x7CCF },
        { 0xE4F6, 0x7CD0 },
        { 0xE4F7, 0x7CD1 },
        { 0xE4F8, 0x7CD2 },
        { 0xE4F9, 0x7CD3 },
        { 0xE4FA, 0x7CD4 },
        { 0xE4FB, 0x7CD5 },
        { 0xE4FC, 0x7CD6 },
        { 0xE4FD, 0x7CD7 },
        { 0xE4FE, 0x7CD8 },
        { 0xE4FF, 0x7CD9 },
        { 0xE500, 0x7CDA },
        { 0xE501, 0x7CDB },
        { 0xE502, 0x7CDC },
        { 0xE503, 0x7CDD },
        { 0xE504, 0x7CDE },
        { 0xE505, 0x7CDF },
        { 0xE506, 0x7CE0 },
        { 0xE507, 0x7CE1 },
        { 0xE508, 0x7CE2 },
        { 0xE509, 0x7CE3 },
        { 0xE50A, 0x7CE4 },
        { 0xE50B, 0x7CE5 },
        { 0xE50C, 0x7CE6 },
        { 0xE50D, 0x7CE7 },
        { 0xE50E, 0x7CE8 },
        { 0xE50F, 0x7CE9 },
        { 0xE510, 0x7CEA },
        { 0xE511, 0x7CEB },
        { 0xE512, 0x7CEC },
        { 0xE513, 0x7CED },
        { 0xE514, 0x7CEE },
        { 0xE515, 0x7CEF },
        { 0xE516, 0x7CF0 },
        { 0xE517, 0x7CF1 },
        { 0xE518, 0x7CF2 },
        { 0xE519, 0x7CF3 },
        { 0xE51A, 0x7CF4 },
        { 0xE51B, 0x7CF5 },
        { 0xE51C, 0x7CF6 },
        { 0xE51D, 0x7CF7 },
        { 0xE51E, 0x7CF8 },
        { 0xE51F, 0x7CF9 },
        { 0xE520, 0x7CFA },
        { 0xE521, 0x7CFB },
        { 0xE522, 0x7CFC },
        { 0xE523, 0x7CFD },
        { 0xE524, 0x7D41 },
        { 0xE525, 0x7D42 },
        { 0xE526, 0x7D43 },
        { 0xE527, 0x7D44 },
        { 0xE528, 0x7D45 },
        { 0xE529, 0x7D46 },
        { 0xE52A, 0x7D47 },
        { 0xE52B, 0x7D48 },
        { 0xE52C, 0x7D49 },
        { 0xE52D, 0x7D4A },
        { 0xE52E, 0x7D4B },
        { 0xE52F, 0x7D4C },
        { 0xE530, 0x7D4D },
        { 0xE531, 0x7D4E },
        { 0xE532, 0x7D4F },
        { 0xE533, 0x7D50 },
        { 0xE534, 0x7D51 },
        { 0xE535, 0x7D52 },
        { 0xE536, 0x7D53 },
        { 0xE537, 0x7D54 },
        { 0xE538, 0x7D55 },
        { 0xE539, 0x7D56 },
        { 0xE53A, 0x7D57 },
        { 0xE53B, 0x7D58 },
        { 0xE53C, 0x7D59 },
        { 0xE53D, 0x7D5A },
        { 0xE53E, 0x7D5B },
        { 0xE53F, 0x7D5C },
        { 0xE540, 0x7D5D },
        { 0xE541, 0x7D5E },
        { 0xE542, 0x7D5F },
        { 0xE543, 0x7D60 },
        { 0xE544, 0x7D61 },
        { 0xE545, 0x7D62 },
        { 0xE546, 0x7D63 },
        { 0xE547, 0x7D64 },
        { 0xE548, 0x7D65 },
        { 0xE549, 0x7D66 },
        { 0xE54A, 0x7D67 },
        { 0xE54B, 0x7D68 },
        { 0xE54C, 0x7D69 },
        { 0xE54D, 0x7D6A },
        { 0xE54E, 0x7D6B },
        { 0xE54F, 0x7D6C },
        { 0xE550, 0x7D6D },
        { 0xE551, 0x7D6E },
        { 0xE552, 0x7D6F },
        { 0xE553, 0x7D70 },
        { 0xE554, 0x7D71 },
        { 0xE555, 0x7D72 },
        { 0xE556, 0x7D73 },
        { 0xE557, 0x7D74 },
        { 0xE558, 0x7D75 },
        { 0xE559, 0x7D76 },
        { 0xE55A, 0x7D77 },
        { 0xE55B, 0x7D78 },
        { 0xE55C, 0x7D79 },
        { 0xE55D, 0x7D7A },
        { 0xE55E, 0x7D7B },
        { 0xE55F, 0x7D7C },
        { 0xE560, 0x7D7D },
        { 0xE561, 0x7D7E },
        { 0xE562, 0x7D7F },
        { 0xE563, 0x7D81 },
        { 0xE564, 0x7D82 },
        { 0xE565, 0x7D83 },
        { 0xE566, 0x7D84 },
        { 0xE567, 0x7D85 },
        { 0xE568, 0x7D86 },
        { 0xE569, 0x7D87 },
        { 0xE56A, 0x7D88 },
        { 0xE56B, 0x7D89 },
        { 0xE56C, 0x7D8A },
        { 0xE56D, 0x7D8B },
        { 0xE56E, 0x7D8C },
        { 0xE56F, 0x7D8D },
        { 0xE570, 0x7D8E },
        { 0xE571, 0x7D8F },
        { 0xE572, 0x7D90 },
        { 0xE573, 0x7D91 },
        { 0xE574, 0x7D92 },
        { 0xE575, 0x7D93 },
        { 0xE576, 0x7D94 },
        { 0xE577, 0x7D95 },
        { 0xE578, 0x7D96 },
        { 0xE579, 0x7D97 },
        { 0xE57A, 0x7D98 },
        { 0xE57B, 0x7D99 },
        { 0xE57C, 0x7D9A },
        { 0xE57D, 0x7D9B },
        { 0xE57E, 0x7D9C },
        { 0xE57F, 0x7D9D },
        { 0xE580, 0x7D9E },
        { 0xE581, 0x7D9F },
        { 0xE582, 0x7DA0 },
        { 0xE583, 0x7DA1 },
        { 0xE584, 0x7DA2 },
        { 0xE585, 0x7DA3 },
        { 0xE586, 0x7DA4 },
        { 0xE587, 0x7DA5 },
        { 0xE588, 0x7DA6 },
        { 0xE589, 0x7DA7 },
        { 0xE58A, 0x7DA8 },
        { 0xE58B, 0x7DA9 },
        { 0xE58C, 0x7DAA },
        { 0xE58D, 0x7DAB },
        { 0xE58E, 0x7DAC },
        { 0xE58F, 0x7DAD },
        { 0xE590, 0x7DAE },
        { 0xE591, 0x7DAF },
        { 0xE592, 0x7DB0 },
        { 0xE593, 0x7DB1 },
        { 0xE594, 0x7DB2 },
        { 0xE595, 0x7DB3 },
        { 0xE596, 0x7DB4 },
        { 0xE597, 0x7DB5 },
        { 0xE598, 0x7DB6 },
        { 0xE599, 0x7DB7 },
        { 0xE59A, 0x7DB8 },
        { 0xE59B, 0x7DB9 },
        { 0xE59C, 0x7DBA },
        { 0xE59D, 0x7DBB },
        { 0xE59E, 0x7DBC },
        { 0xE59F, 0x7DBD },
        { 0xE5A0, 0x7DBE },
        { 0xE5A1, 0x7DBF },
        { 0xE5A2, 0x7DC0 },
        { 0xE5A3, 0x7DC1 },
        { 0xE5A4, 0x7DC2 },
        { 0xE5A5, 0x7DC3 },
        { 0xE5A6, 0x7DC4 },
        { 0xE5A7, 0x7DC5 },
        { 0xE5A8, 0x7DC6 },
        { 0xE5A9, 0x7DC7 },
        { 0xE5AA, 0x7DC8 },
        { 0xE5AB, 0x7DC9 },
        { 0xE5AC, 0x7DCA },
        { 0xE5AD, 0x7DCB },
        { 0xE5AE, 0x7DCC },
        { 0xE5AF, 0x7DCD },
        { 0xE5B0, 0x7DCE },
        { 0xE5B1, 0x7DCF },
        { 0xE5B2, 0x7DD0 },
        { 0xE5B3, 0x7DD1 },
        { 0xE5B4, 0x7DD2 },
        { 0xE5B5, 0x7DD3 },
        { 0xE5B6, 0x7DD4 },
        { 0xE5B7, 0x7DD5 },
        { 0xE5B8, 0x7DD6 },
        { 0xE5B9, 0x7DD7 },
        { 0xE5BA, 0x7DD8 },
        { 0xE5BB, 0x7DD9 },
        { 0xE5BC, 0x7DDA },
        { 0xE5BD, 0x7DDB },
        { 0xE5BE, 0x7DDC },
        { 0xE5BF, 0x7DDD },
        { 0xE5C0, 0x7DDE },
        { 0xE5C1, 0x7DDF },
        { 0xE5C2, 0x7DE0 },
        { 0xE5C3, 0x7DE1 },
        { 0xE5C4, 0x7DE2 },
        { 0xE5C5, 0x7DE3 },
        { 0xE5C6, 0x7DE4 },
        { 0xE5C7, 0x7DE5 },
        { 0xE5C8, 0x7DE6 },
        { 0xE5C9, 0x7DE7 },
        { 0xE5CA, 0x7DE8 },
        { 0xE5CB, 0x7DE9 },
        { 0xE5CC, 0x7DEA },
        { 0xE5CD, 0x7DEB },
        { 0xE5CE, 0x7DEC },
        { 0xE5CF, 0x7DED },
        { 0xE5D0, 0x7DEE },
        { 0xE5D1, 0x7DEF },
        { 0xE5D2, 0x7DF0 },
        { 0xE5D3, 0x7DF1 },
        { 0xE5D4, 0x7DF2 },
        { 0xE5D5, 0x7DF3 },
        { 0xE5D6, 0x7DF4 },
        { 0xE5D7, 0x7DF5 },
        { 0xE5D8, 0x7DF6 },
        { 0xE5D9, 0x7DF7 },
        { 0xE5DA, 0x7DF8 },
        { 0xE5DB, 0x7DF9 },
        { 0xE5DC, 0x7DFA },
        { 0xE5DD, 0x7DFB },
        { 0xE5DE, 0x7DFC },
        { 0xE5DF, 0x7DFD },
        { 0xE5E0, 0x7E41 },
        { 0xE5E1, 0x7E42 },
        { 0xE5E2, 0x7E43 },
        { 0xE5E3, 0x7E44 },
        { 0xE5E4, 0x7E45 },
        { 0xE5E5, 0x7E46 },
        { 0xE5E6, 0x7E47 },
        { 0xE5E7, 0x7E48 },
        { 0xE5E8, 0x7E49 },
        { 0xE5E9, 0x7E4A },
        { 0xE5EA, 0x7E4B },
        { 0xE5EB, 0x7E4C },
        { 0xE5EC, 0x7E4D },
        { 0xE5ED, 0x7E4E },
        { 0xE5EE, 0x7E4F },
        { 0xE5EF, 0x7E50 },
        { 0xE5F0, 0x7E51 },
        { 0xE5F1, 0x7E52 },
        { 0xE5F2, 0x7E53 },
        { 0xE5F3, 0x7E54 },
        { 0xE5F4, 0x7E55 },
        { 0xE5F5, 0x7E56 },
        { 0xE5F6, 0x7E57 },
        { 0xE5F7, 0x7E58 },
        { 0xE5F8, 0x7E59 },
        { 0xE5F9, 0x7E5A },
        { 0xE5FA, 0x7E5B },
        { 0xE5FB, 0x7E5C },
        { 0xE5FC, 0x7E5D },
        { 0xE5FD, 0x7E5E },
        { 0xE5FE, 0x7E5F },
        { 0xE5FF, 0x7E60 },
        { 0xE600, 0x7E61 },
        { 0xE601, 0x7E62 },
        { 0xE602, 0x7E63 },
        { 0xE603, 0x7E64 },
        { 0xE604, 0x7E65 },
        { 0xE605, 0x7E66 },
        { 0xE606, 0x7E67 },
        { 0xE607, 0x7E68 },
        { 0xE608, 0x7E69 },
        { 0xE609, 0x7E6A },
        { 0xE60A, 0x7E6B },
        { 0xE60B, 0x7E6C },
        { 0xE60C, 0x7E6D },
        { 0xE60D, 0x7E6E },
        { 0xE60E, 0x7E6F },
        { 0xE60F, 0x7E70 },
        { 0xE610, 0x7E71 },
        { 0xE611, 0x7E72 },
        { 0xE612, 0x7E73 },
        { 0xE613, 0x7E74 },
        { 0xE614, 0x7E75 },
        { 0xE615, 0x7E76 },
        { 0xE616, 0x7E77 },
        { 0xE617, 0x7E78 },
        { 0xE618, 0x7E79 },
        { 0xE619, 0x7E7A },
        { 0xE61A, 0x7E7B },
        { 0xE61B, 0x7E7C },
        { 0xE61C, 0x7E7D },
        { 0xE61D, 0x7E7E },
        { 0xE61E, 0x7E7F },
        { 0xE61F, 0x7E81 },
        { 0xE620, 0x7E82 },
        { 0xE621, 0x7E83 },
        { 0xE622, 0x7E84 },
        { 0xE623, 0x7E85 },
        { 0xE624, 0x7E86 },
        { 0xE625, 0x7E87 },
        { 0xE626, 0x7E88 },
        { 0xE627, 0x7E89 },
        { 0xE628, 0x7E8A },
        { 0xE629, 0x7E8B },
        { 0xE62A, 0x7E8C },
        { 0xE62B, 0x7E8D },
        { 0xE62C, 0x7E8E },
        { 0xE62D, 0x7E8F },
        { 0xE62E, 0x7E90 },
        { 0xE62F, 0x7E91 },
        { 0xE630, 0x7E92 },
        { 0xE631, 0x7E93 },
        { 0xE632, 0x7E94 },
        { 0xE633, 0x7E95 },
        { 0xE634, 0x7E96 },
        { 0xE635, 0x7E97 },
        { 0xE636, 0x7E98 },
        { 0xE637, 0x7E99 },
        { 0xE638, 0x7E9A },
        { 0xE639, 0x7E9B },
        { 0xE63A, 0x7E9C },
        { 0xE63B, 0x7E9D },
        { 0xE63C, 0x7E9E },
        { 0xE63D, 0x7E9F },
        { 0xE63E, 0x7EA0 },
        { 0xE63F, 0x7EA1 },
        { 0xE640, 0x7EA2 },
        { 0xE641, 0x7EA3 },
        { 0xE642, 0x7EA4 },
        { 0xE643, 0x7EA5 },
        { 0xE644, 0x7EA6 },
        { 0xE645, 0x7EA7 },
        { 0xE646, 0x7EA8 },
        { 0xE647, 0x7EA9 },
        { 0xE648, 0x7EAA },
        { 0xE649, 0x7EAB },
        { 0xE64A, 0x7EAC },
        { 0xE64B, 0x7EAD },
        { 0xE64C, 0x7EAE },
        { 0xE64D, 0x7EAF },
        { 0xE64E, 0x7EB0 },
        { 0xE64F, 0x7EB1 },
        { 0xE650, 0x7EB2 },
        { 0xE651, 0x7EB3 },
        { 0xE652, 0x7EB4 },
        { 0xE653, 0x7EB5 },
        { 0xE654, 0x7EB6 },
        { 0xE655, 0x7EB7 },
        { 0xE656, 0x7EB8 },
        { 0xE657, 0x7EB9 },
        { 0xE658, 0x7EBA },
        { 0xE659, 0x7EBB },
        { 0xE65A, 0x7EBC },
        { 0xE65B, 0x7EBD },
        { 0xE65C, 0x7EBE },
        { 0xE65D, 0x7EBF },
        { 0xE65E, 0x7EC0 },
        { 0xE65F, 0x7EC1 },
        { 0xE660, 0x7EC2 },
        { 0xE661, 0x7EC3 },
        { 0xE662, 0x7EC4 },
        { 0xE663, 0x7EC5 },
        { 0xE664, 0x7EC6 },
        { 0xE665, 0x7EC7 },
        { 0xE666, 0x7EC8 },
        { 0xE667, 0x7EC9 },
        { 0xE668, 0x7ECA },
        { 0xE669, 0x7ECB },
        { 0xE66A, 0x7ECC },
        { 0xE66B, 0x7ECD },
        { 0xE66C, 0x7ECE },
        { 0xE66D, 0x7ECF },
        { 0xE66E, 0x7ED0 },
        { 0xE66F, 0x7ED1 },
        { 0xE670, 0x7ED2 },
        { 0xE671, 0x7ED3 },
        { 0xE672, 0x7ED4 },
        { 0xE673, 0x7ED5 },
        { 0xE674, 0x7ED6 },
        { 0xE675, 0x7ED7 },
        { 0xE676, 0x7ED8 },
        { 0xE677, 0x7ED9 },
        { 0xE678, 0x7EDA },
        { 0xE679, 0x7EDB },
        { 0xE67A, 0x7EDC },
        { 0xE67B, 0x7EDD },
        { 0xE67C, 0x7EDE },
        { 0xE67D, 0x7EDF },
        { 0xE67E, 0x7EE0 },
        { 0xE67F, 0x7EE1 },
        { 0xE680, 0x7EE2 },
        { 0xE681, 0x7EE3 },
        { 0xE682, 0x7EE4 },
        { 0xE683, 0x7EE5 },
        { 0xE684, 0x7EE6 },
        { 0xE685, 0x7EE7 },
        { 0xE686, 0x7EE8 },
        { 0xE687, 0x7EE9 },
        { 0xE688, 0x7EEA },
        { 0xE689, 0x7EEB },
        { 0xE68A, 0x7EEC },
        { 0xE68B, 0x7EED },
        { 0xE68C, 0x7EEE },
        { 0xE68D, 0x7EEF },
        { 0xE68E, 0x7EF0 },
        { 0xE68F, 0x7EF1 },
        { 0xE690, 0x7EF2 },
        { 0xE691, 0x7EF3 },
        { 0xE692, 0x7EF4 },
        { 0xE693, 0x7EF5 },
        { 0xE694, 0x7EF6 },
        { 0xE695, 0x7EF7 },
        { 0xE696, 0x7EF8 },
        { 0xE697, 0x7EF9 },
        { 0xE698, 0x7EFA },
        { 0xE699, 0x7EFB },
        { 0xE69A, 0x7EFC },
        { 0xE69B, 0x7EFD },
        { 0xE69C, 0x7F41 },
        { 0xE69D, 0x7F42 },
        { 0xE69E, 0x7F43 },
        { 0xE69F, 0x7F44 },
        { 0xE6A0, 0x7F45 },
        { 0xE6A1, 0x7F46 },
        { 0xE6A2, 0x7F47 },
        { 0xE6A3, 0x7F48 },
        { 0xE6A4, 0x7F49 },
        { 0xE6A5, 0x7F4A },
        { 0xE6A6, 0x7F4B },
        { 0xE6A7, 0x7F4C },
        { 0xE6A8, 0x7F4D },
        { 0xE6A9, 0x7F4E },
        { 0xE6AA, 0x7F4F },
        { 0xE6AB, 0x7F50 },
        { 0xE6AC, 0x7F51 },
        { 0xE6AD, 0x7F52 },
        { 0xE6AE, 0x7F53 },
        { 0xE6AF, 0x7F54 },
        { 0xE6B0, 0x7F55 },
        { 0xE6B1, 0x7F56 },
        { 0xE6B2, 0x7F57 },
        { 0xE6B3, 0x7F58 },
        { 0xE6B4, 0x7F59 },
        { 0xE6B5, 0x7F5A },
        { 0xE6B6, 0x7F5B },
        { 0xE6B7, 0x7F5C },
        { 0xE6B8, 0x7F5D },
        { 0xE6B9, 0x7F5E },
        { 0xE6BA, 0x7F5F },
        { 0xE6BB, 0x7F60 },
        { 0xE6BC, 0x7F61 },
        { 0xE6BD, 0x7F62 },
        { 0xE6BE, 0x7F63 },
        { 0xE6BF, 0x7F64 },
        { 0xE6C0, 0x7F65 },
        { 0xE6C1, 0x7F66 },
        { 0xE6C2, 0x7F67 },
        { 0xE6C3, 0x7F68 },
        { 0xE6C4, 0x7F69 },
        { 0xE6C5, 0x7F6A },
        { 0xE6C6, 0x7F6B },
        { 0xE6C7, 0x7F6C },
        { 0xE6C8, 0x7F6D },
        { 0xE6C9, 0x7F6E },
        { 0xE6CA, 0x7F6F },
        { 0xE6CB, 0x7F70 },
        { 0xE6CC, 0x7F71 },
        { 0xE6CD, 0x7F72 },
        { 0xE6CE, 0x7F73 },
        { 0xE6CF, 0x7F74 },
        { 0xE6D0, 0x7F75 },
        { 0xE6D1, 0x7F76 },
        { 0xE6D2, 0x7F77 },
        { 0xE6D3, 0x7F78 },
        { 0xE6D4, 0x7F79 },
        { 0xE6D5, 0x7F7A },
        { 0xE6D6, 0x7F7B },
        { 0xE6D7, 0x7F7C },
        { 0xE6D8, 0x7F7D },
        { 0xE6D9, 0x7F7E },
        { 0xE6DA, 0x7F7F },
        { 0xE6DB, 0x7F81 },
        { 0xE6DC, 0x7F82 },
        { 0xE6DD, 0x7F83 },
        { 0xE6DE, 0x7F84 },
        { 0xE6DF, 0x7F85 },
        { 0xE6E0, 0x7F86 },
        { 0xE6E1, 0x7F87 },
        { 0xE6E2, 0x7F88 },
        { 0xE6E3, 0x7F89 },
        { 0xE6E4, 0x7F8A },
        { 0xE6E5, 0x7F8B },
        { 0xE6E6, 0x7F8C },
        { 0xE6E7, 0x7F8D },
        { 0xE6E8, 0x7F8E },
        { 0xE6E9, 0x7F8F },
        { 0xE6EA, 0x7F90 },
        { 0xE6EB, 0x7F91 },
        { 0xE6EC, 0x7F92 },
        { 0xE6ED, 0x7F93 },
        { 0xE6EE, 0x7F94 },
        { 0xE6EF, 0x7F95 },
        { 0xE6F0, 0x7F96 },
        { 0xE6F1, 0x7F97 },
        { 0xE6F2, 0x7F98 },
        { 0xE6F3, 0x7F99 },
        { 0xE6F4, 0x7F9A },
        { 0xE6F5, 0x7F9B },
        { 0xE6F6, 0x7F9C },
        { 0xE6F7, 0x7F9D },
        { 0xE6F8, 0x7F9E },
        { 0xE6F9, 0x7F9F },
        { 0xE6FA, 0x7FA0 },
        { 0xE6FB, 0x7FA1 },
        { 0xE6FC, 0x7FA2 },
        { 0xE6FD, 0x7FA3 },
        { 0xE6FE, 0x7FA4 },
        { 0xE6FF, 0x7FA5 },
        { 0xE700, 0x7FA6 },
        { 0xE701, 0x7FA7 },
        { 0xE702, 0x7FA8 },
        { 0xE703, 0x7FA9 },
        { 0xE704, 0x7FAA },
        { 0xE705, 0x7FAB },
        { 0xE706, 0x7FAC },
        { 0xE707, 0x7FAD },
        { 0xE708, 0x7FAE },
        { 0xE709, 0x7FAF },
        { 0xE70A, 0x7FB0 },
        { 0xE70B, 0x7FB1 },
        { 0xE70C, 0x7FB2 },
        { 0xE70D, 0x7FB3 },
        { 0xE70E, 0x7FB4 },
        { 0xE70F, 0x7FB5 },
        { 0xE710, 0x7FB6 },
        { 0xE711, 0x7FB7 },
        { 0xE712, 0x7FB8 },
        { 0xE713, 0x7FB9 },
        { 0xE714, 0x7FBA },
        { 0xE715, 0x7FBB },
        { 0xE716, 0x7FBC },
        { 0xE717, 0x7FBD },
        { 0xE718, 0x7FBE },
        { 0xE719, 0x7FBF },
        { 0xE71A, 0x7FC0 },
        { 0xE71B, 0x7FC1 },
        { 0xE71C, 0x7FC2 },
        { 0xE71D, 0x7FC3 },
        { 0xE71E, 0x7FC4 },
        { 0xE71F, 0x7FC5 },
        { 0xE720, 0x7FC6 },
        { 0xE721, 0x7FC7 },
        { 0xE722, 0x7FC8 },
        { 0xE723, 0x7FC9 },
        { 0xE724, 0x7FCA },
        { 0xE725, 0x7FCB },
        { 0xE726, 0x7FCC },
        { 0xE727, 0x7FCD },
        { 0xE728, 0x7FCE },
        { 0xE729, 0x7FCF },
        { 0xE72A, 0x7FD0 },
        { 0xE72B, 0x7FD1 },
        { 0xE72C, 0x7FD2 },
        { 0xE72D, 0x7FD3 },
        { 0xE72E, 0x7FD4 },
        { 0xE72F, 0x7FD5 },
        { 0xE730, 0x7FD6 },
        { 0xE731, 0x7FD7 },
        { 0xE732, 0x7FD8 },
        { 0xE733, 0x7FD9 },
        { 0xE734, 0x7FDA },
        { 0xE735, 0x7FDB },
        { 0xE736, 0x7FDC },
        { 0xE737, 0x7FDD },
        { 0xE738, 0x7FDE },
        { 0xE739, 0x7FDF },
        { 0xE73A, 0x7FE0 },
        { 0xE73B, 0x7FE1 },
        { 0xE73C, 0x7FE2 },
        { 0xE73D, 0x7FE3 },
        { 0xE73E, 0x7FE4 },
        { 0xE73F, 0x7FE5 },
        { 0xE740, 0x7FE6 },
        { 0xE741, 0x7FE7 },
        { 0xE742, 0x7FE8 },
        { 0xE743, 0x7FE9 },
        { 0xE744, 0x7FEA },
        { 0xE745, 0x7FEB },
        { 0xE746, 0x7FEC },
        { 0xE747, 0x7FED },
        { 0xE748, 0x7FEE },
        { 0xE749, 0x7FEF },
        { 0xE74A, 0x7FF0 },
        { 0xE74B, 0x7FF1 },
        { 0xE74C, 0x7FF2 },
        { 0xE74D, 0x7FF3 },
        { 0xE74E, 0x7FF4 },
        { 0xE74F, 0x7FF5 },
        { 0xE750, 0x7FF6 },
        { 0xE751, 0x7FF7 },
        { 0xE752, 0x7FF8 },
        { 0xE753, 0x7FF9 },
        { 0xE754, 0x7FFA },
        { 0xE755, 0x7FFB },
        { 0xE756, 0x7FFC },
        { 0xE757, 0x7FFD },
        { 0xF83D, 0x435B },
        { 0xF83E, 0x445C },
        { 0xFF01, 0x425A },
        { 0xFF02, 0x427F },
        { 0xFF03, 0x427B },
        { 0xFF04, 0x42E0 },
        { 0xFF05, 0x426C },
        { 0xFF06, 0x4250 },
        { 0xFF07, 0x427D },
        { 0xFF08, 0x424D },
        { 0xFF09, 0x425D },
        { 0xFF0A, 0x425C },
        { 0xFF0B, 0x424E },
        { 0xFF0C, 0x426B },
        { 0xFF0D, 0x4260 },
        { 0xFF0E, 0x424B },
        { 0xFF0F, 0x4261 },
        { 0xFF10, 0x42F0 },
        { 0xFF11, 0x42F1 },
        { 0xFF12, 0x42F2 },
        { 0xFF13, 0x42F3 },
        { 0xFF14, 0x42F4 },
        { 0xFF15, 0x42F5 },
        { 0xFF16, 0x42F6 },
        { 0xFF17, 0x42F7 },
        { 0xFF18, 0x42F8 },
        { 0xFF19, 0x42F9 },
        { 0xFF1A, 0x427A },
        { 0xFF1B, 0x425E },
        { 0xFF1C, 0x424C },
        { 0xFF1D, 0x427E },
        { 0xFF1E, 0x426E },
        { 0xFF1F, 0x426F },
        { 0xFF20, 0x427C },
        { 0xFF21, 0x42C1 },
        { 0xFF22, 0x42C2 },
        { 0xFF23, 0x42C3 },
        { 0xFF24, 0x42C4 },
        { 0xFF25, 0x42C5 },
        { 0xFF26, 0x42C6 },
        { 0xFF27, 0x42C7 },
        { 0xFF28, 0x42C8 },
        { 0xFF29, 0x42C9 },
        { 0xFF2A, 0x42D1 },
        { 0xFF2B, 0x42D2 },
        { 0xFF2C, 0x42D3 },
        { 0xFF2D, 0x42D4 },
        { 0xFF2E, 0x42D5 },
        { 0xFF2F, 0x42D6 },
        { 0xFF30, 0x42D7 },
        { 0xFF31, 0x42D8 },
        { 0xFF32, 0x42D9 },
        { 0xFF33, 0x42E2 },
        { 0xFF34, 0x42E3 },
        { 0xFF35, 0x42E4 },
        { 0xFF36, 0x42E5 },
        { 0xFF37, 0x42E6 },
        { 0xFF38, 0x42E7 },
        { 0xFF39, 0x42E8 },
        { 0xFF3A, 0x42E9 },
        { 0xFF3B, 0x4444 },
        { 0xFF3C, 0x43E0 },
        { 0xFF3D, 0x4445 },
        { 0xFF3E, 0x4470 },
        { 0xFF3F, 0x426D },
        { 0xFF40, 0x4279 },
        { 0xFF41, 0x4281 },
        { 0xFF42, 0x4282 },
        { 0xFF43, 0x4283 },
        { 0xFF44, 0x4284 },
        { 0xFF45, 0x4285 },
        { 0xFF46, 0x4286 },
        { 0xFF47, 0x4287 },
        { 0xFF48, 0x4288 },
        { 0xFF49, 0x4289 },
        { 0xFF4A, 0x4291 },
        { 0xFF4B, 0x4292 },
        { 0xFF4C, 0x4293 },
        { 0xFF4D, 0x4294 },
        { 0xFF4E, 0x4295 },
        { 0xFF4F, 0x4296 },
        { 0xFF50, 0x4297 },
        { 0xFF51, 0x4298 },
        { 0xFF52, 0x4299 },
        { 0xFF53, 0x42A2 },
        { 0xFF54, 0x42A3 },
        { 0xFF55, 0x42A4 },
        { 0xFF56, 0x42A5 },
        { 0xFF57, 0x42A6 },
        { 0xFF58, 0x42A7 },
        { 0xFF59, 0x42A8 },
        { 0xFF5A, 0x42A9 },
        { 0xFF5B, 0x42C0 },
        { 0xFF5C, 0x424F },
        { 0xFF5D, 0x42D0 },
        { 0xFF5E, 0x43A1 },
        { 0xFFE0, 0x434A },
        { 0xFFE1, 0x424A },
        { 0xFFE2, 0x425F },
        { 0xFFE3, 0x42A1 },
        { 0xFFE4, 0x426A },
        { 0xFFE5, 0x425B }
};

#endif
