/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 *  under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 *
*/
/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 */


/* maxium mapping number from UTF8 to CNS11643 */
#define MAX_UTF_NUM		55441

typedef struct utf_cns {
	unsigned long	unicode;
	unsigned long	cnscode;
} utf_cns;

/* unicode (UTF8) to CNS 11643 mapping table
 * (some characters are missing;
 * includes plane 1/2/14, i.e. cnscode begins with 21/22/2e;
 * supports CNS11643-86 only, CNS11643-92 not yet supported)
 *
 * support Unicode 3.2 and mapping source is Unihan-3.2.0.txt
 */
utf_cns	utf_cns_tab[MAX_UTF_NUM] = {
	{ 0x00a7, 0x212170 },
	{ 0x00b0, 0x212278 },
	{ 0x00b1, 0x212234 },
	{ 0x00b7, 0x212131 },
	{ 0x00d7, 0x212232 },
	{ 0x00f7, 0x212233 },
	{ 0x02c7, 0x21256f },
	{ 0x02c9, 0x21256d },
	{ 0x02ca, 0x21256e },
	{ 0x02cb, 0x212570 },
	{ 0x02d9, 0x21256c },
	{ 0x0391, 0x212475 },
	{ 0x0392, 0x212476 },
	{ 0x0393, 0x212477 },
	{ 0x0394, 0x212478 },
	{ 0x0395, 0x212479 },
	{ 0x0396, 0x21247a },
	{ 0x0397, 0x21247b },
	{ 0x0398, 0x21247c },
	{ 0x0399, 0x21247d },
	{ 0x039a, 0x21247e },
	{ 0x039b, 0x212521 },
	{ 0x039c, 0x212522 },
	{ 0x039d, 0x212523 },
	{ 0x039e, 0x212524 },
	{ 0x039f, 0x212525 },
	{ 0x03a0, 0x212526 },
	{ 0x03a1, 0x212527 },
	{ 0x03a3, 0x212528 },
	{ 0x03a4, 0x212529 },
	{ 0x03a5, 0x21252a },
	{ 0x03a6, 0x21252b },
	{ 0x03a7, 0x21252c },
	{ 0x03a8, 0x21252d },
	{ 0x03a9, 0x21252e },
	{ 0x03b1, 0x21252f },
	{ 0x03b2, 0x212530 },
	{ 0x03b3, 0x212531 },
	{ 0x03b4, 0x212532 },
	{ 0x03b5, 0x212533 },
	{ 0x03b6, 0x212534 },
	{ 0x03b7, 0x212535 },
	{ 0x03b8, 0x212536 },
	{ 0x03b9, 0x212537 },
	{ 0x03ba, 0x212538 },
	{ 0x03bb, 0x212539 },
	{ 0x03bc, 0x21253a },
	{ 0x03bd, 0x21253b },
	{ 0x03be, 0x21253c },
	{ 0x03bf, 0x21253d },
	{ 0x03c0, 0x21253e },
	{ 0x03c1, 0x21253f },
	{ 0x03c3, 0x212540 },
	{ 0x03c4, 0x212541 },
	{ 0x03c5, 0x212542 },
	{ 0x03c6, 0x212543 },
	{ 0x03c7, 0x212544 },
	{ 0x03c8, 0x212545 },
	{ 0x03c9, 0x212546 },
	{ 0x2013, 0x212139 },
	{ 0x2014, 0x212137 },
	{ 0x2016, 0x21225d },
	{ 0x2018, 0x212164 },
	{ 0x2019, 0x212165 },
	{ 0x201c, 0x212166 },
	{ 0x201d, 0x212167 },
	{ 0x2025, 0x21212d },
	{ 0x2026, 0x21212c },
	{ 0x2032, 0x21216a },
	{ 0x2035, 0x21216b },
	{ 0x203b, 0x21216f },
	{ 0x203e, 0x212223 },
	{ 0x2103, 0x21226a },
	{ 0x2105, 0x212222 },
	{ 0x2109, 0x21226b },
	{ 0x2160, 0x21242b },
	{ 0x2161, 0x21242c },
	{ 0x2162, 0x21242d },
	{ 0x2163, 0x21242e },
	{ 0x2164, 0x21242f },
	{ 0x2165, 0x212430 },
	{ 0x2166, 0x212431 },
	{ 0x2167, 0x212432 },
	{ 0x2168, 0x212433 },
	{ 0x2169, 0x212434 },
	{ 0x2170, 0x212635 },
	{ 0x2171, 0x212636 },
	{ 0x2172, 0x212637 },
	{ 0x2173, 0x212638 },
	{ 0x2174, 0x212639 },
	{ 0x2175, 0x21263a },
	{ 0x2176, 0x21263b },
	{ 0x2177, 0x21263c },
	{ 0x2178, 0x21263d },
	{ 0x2179, 0x21263e },
	{ 0x2190, 0x212258 },
	{ 0x2191, 0x212255 },
	{ 0x2192, 0x212257 },
	{ 0x2193, 0x212256 },
	{ 0x2196, 0x212259 },
	{ 0x2197, 0x21225a },
	{ 0x2198, 0x21225c },
	{ 0x2199, 0x21225b },
	{ 0x2215, 0x212261 },
	{ 0x221a, 0x212235 },
	{ 0x221e, 0x21223c },
	{ 0x221f, 0x212249 },
	{ 0x2220, 0x212248 },
	{ 0x2229, 0x212245 },
	{ 0x222a, 0x212246 },
	{ 0x222b, 0x21224d },
	{ 0x222e, 0x21224e },
	{ 0x2234, 0x212250 },
	{ 0x2235, 0x21224f },
	{ 0x223c, 0x212244 },
	{ 0x2252, 0x21223d },
	{ 0x2260, 0x21223b },
	{ 0x2261, 0x21223e },
	{ 0x2266, 0x212239 },
	{ 0x2267, 0x21223a },
	{ 0x22a5, 0x212247 },
	{ 0x22bf, 0x21224a },
	{ 0x2400, 0x214221 },
	{ 0x2401, 0x214222 },
	{ 0x2402, 0x214223 },
	{ 0x2403, 0x214224 },
	{ 0x2404, 0x214225 },
	{ 0x2405, 0x214226 },
	{ 0x2406, 0x214227 },
	{ 0x2407, 0x214228 },
	{ 0x2408, 0x214229 },
	{ 0x2409, 0x21422a },
	{ 0x240a, 0x21422b },
	{ 0x240b, 0x21422c },
	{ 0x240c, 0x21422d },
	{ 0x240d, 0x21422e },
	{ 0x240e, 0x21422f },
	{ 0x240f, 0x214230 },
	{ 0x2410, 0x214231 },
	{ 0x2411, 0x214232 },
	{ 0x2412, 0x214233 },
	{ 0x2413, 0x214234 },
	{ 0x2414, 0x214235 },
	{ 0x2415, 0x214236 },
	{ 0x2416, 0x214237 },
	{ 0x2417, 0x214238 },
	{ 0x2418, 0x214239 },
	{ 0x2419, 0x21423a },
	{ 0x241a, 0x21423b },
	{ 0x241b, 0x21423c },
	{ 0x241c, 0x21423d },
	{ 0x241d, 0x21423e },
	{ 0x241e, 0x21423f },
	{ 0x241f, 0x214240 },
	{ 0x2421, 0x214241 },
	{ 0x2460, 0x212621 },
	{ 0x2461, 0x212622 },
	{ 0x2462, 0x212623 },
	{ 0x2463, 0x212624 },
	{ 0x2464, 0x212625 },
	{ 0x2465, 0x212626 },
	{ 0x2466, 0x212627 },
	{ 0x2467, 0x212628 },
	{ 0x2468, 0x212629 },
	{ 0x2469, 0x21262a },
	{ 0x2474, 0x21262b },
	{ 0x2475, 0x21262c },
	{ 0x2476, 0x21262d },
	{ 0x2477, 0x21262e },
	{ 0x2478, 0x21262f },
	{ 0x2479, 0x212630 },
	{ 0x247a, 0x212631 },
	{ 0x247b, 0x212632 },
	{ 0x247c, 0x212633 },
	{ 0x247d, 0x212634 },
	{ 0x2500, 0x212339 },
	{ 0x2502, 0x21233a },
	{ 0x250c, 0x21233c },
	{ 0x2510, 0x21233d },
	{ 0x2514, 0x21233e },
	{ 0x2518, 0x21233f },
	{ 0x251c, 0x212337 },
	{ 0x2524, 0x212336 },
	{ 0x252c, 0x212335 },
	{ 0x2534, 0x212334 },
	{ 0x253c, 0x212333 },
	{ 0x2550, 0x212344 },
	{ 0x255e, 0x212345 },
	{ 0x2561, 0x212347 },
	{ 0x256a, 0x212346 },
	{ 0x256d, 0x212340 },
	{ 0x256e, 0x212341 },
	{ 0x256f, 0x212343 },
	{ 0x2570, 0x212342 },
	{ 0x2571, 0x21234c },
	{ 0x2572, 0x21234d },
	{ 0x2573, 0x21234e },
	{ 0x2581, 0x212324 },
	{ 0x2582, 0x212325 },
	{ 0x2583, 0x212326 },
	{ 0x2584, 0x212327 },
	{ 0x2585, 0x212328 },
	{ 0x2586, 0x212329 },
	{ 0x2587, 0x21232a },
	{ 0x2588, 0x21232b },
	{ 0x2589, 0x212332 },
	{ 0x258a, 0x212331 },
	{ 0x258b, 0x212330 },
	{ 0x258c, 0x21232f },
	{ 0x258d, 0x21232e },
	{ 0x258e, 0x21232d },
	{ 0x258f, 0x21232c },
	{ 0x2594, 0x212338 },
	{ 0x2595, 0x21233b },
	{ 0x25a0, 0x21217c },
	{ 0x25a1, 0x21217b },
	{ 0x25b2, 0x212175 },
	{ 0x25b3, 0x212174 },
	{ 0x25bc, 0x21217e },
	{ 0x25bd, 0x21217d },
	{ 0x25c6, 0x21217a },
	{ 0x25c7, 0x212179 },
	{ 0x25cb, 0x212172 },
	{ 0x25ce, 0x212176 },
	{ 0x25cf, 0x212173 },
	{ 0x25e2, 0x212348 },
	{ 0x25e3, 0x212349 },
	{ 0x25e4, 0x21234b },
	{ 0x25e5, 0x21234a },
	{ 0x2605, 0x212178 },
	{ 0x2606, 0x212177 },
	{ 0x2609, 0x212254 },
	{ 0x2640, 0x212251 },
	{ 0x2641, 0x212253 },
	{ 0x2642, 0x212252 },
	{ 0x3000, 0x212121 },
	{ 0x3001, 0x212123 },
	{ 0x3002, 0x212124 },
	{ 0x3003, 0x212171 },
	{ 0x3008, 0x212152 },
	{ 0x3009, 0x212153 },
	{ 0x300a, 0x21214e },
	{ 0x300b, 0x21214f },
	{ 0x300c, 0x212156 },
	{ 0x300d, 0x212157 },
	{ 0x300e, 0x21215a },
	{ 0x300f, 0x21215b },
	{ 0x3010, 0x21214a },
	{ 0x3011, 0x21214b },
	{ 0x3012, 0x212265 },
	{ 0x3014, 0x212146 },
	{ 0x3015, 0x212147 },
	{ 0x301d, 0x212168 },
	{ 0x301e, 0x212169 },
	{ 0x3021, 0x212435 },
	{ 0x3022, 0x212436 },
	{ 0x3023, 0x212437 },
	{ 0x3024, 0x212438 },
	{ 0x3025, 0x212439 },
	{ 0x3026, 0x21243a },
	{ 0x3027, 0x21243b },
	{ 0x3028, 0x21243c },
	{ 0x3029, 0x21243d },
	{ 0x30fb, 0x212126 },
	{ 0x3105, 0x212547 },
	{ 0x3106, 0x212548 },
	{ 0x3107, 0x212549 },
	{ 0x3108, 0x21254a },
	{ 0x3109, 0x21254b },
	{ 0x310a, 0x21254c },
	{ 0x310b, 0x21254d },
	{ 0x310c, 0x21254e },
	{ 0x310d, 0x21254f },
	{ 0x310e, 0x212550 },
	{ 0x310f, 0x212551 },
	{ 0x3110, 0x212552 },
	{ 0x3111, 0x212553 },
	{ 0x3112, 0x212554 },
	{ 0x3113, 0x212555 },
	{ 0x3114, 0x212556 },
	{ 0x3115, 0x212557 },
	{ 0x3116, 0x212558 },
	{ 0x3117, 0x212559 },
	{ 0x3118, 0x21255a },
	{ 0x3119, 0x21255b },
	{ 0x311a, 0x21255c },
	{ 0x311b, 0x21255d },
	{ 0x311c, 0x21255e },
	{ 0x311d, 0x21255f },
	{ 0x311e, 0x212560 },
	{ 0x311f, 0x212561 },
	{ 0x3120, 0x212562 },
	{ 0x3121, 0x212563 },
	{ 0x3122, 0x212564 },
	{ 0x3123, 0x212565 },
	{ 0x3124, 0x212566 },
	{ 0x3125, 0x212567 },
	{ 0x3126, 0x212568 },
	{ 0x3127, 0x212569 },
	{ 0x3128, 0x21256a },
	{ 0x3129, 0x21256b },
	{ 0x32a3, 0x212221 },
	{ 0x338e, 0x212275 },
	{ 0x338f, 0x212276 },
	{ 0x339c, 0x212270 },
	{ 0x339d, 0x212271 },
	{ 0x339e, 0x212272 },
	{ 0x33a1, 0x212274 },
	{ 0x33c4, 0x212277 },
	{ 0x33ce, 0x212273 },
	{ 0x33d1, 0x21224c },
	{ 0x33d2, 0x21224b },
	{ 0x33d5, 0x21226f },
	{ 0x3400, 0x26222c },
	{ 0x3401, 0x242224 },
	{ 0x3404, 0x262130 },
	{ 0x3405, 0x262123 },
	{ 0x3406, 0x2f216c },
	{ 0x340c, 0x242157 },
	{ 0x3416, 0x242336 },
	{ 0x341c, 0x242835 },
	{ 0x3421, 0x23343b },
	{ 0x3424, 0x23396d },
	{ 0x3428, 0x232741 },
	{ 0x3429, 0x23286c },
	{ 0x342b, 0x232323 },
	{ 0x342c, 0x242337 },
	{ 0x342d, 0x242534 },
	{ 0x342e, 0x234034 },
	{ 0x3430, 0x242159 },
	{ 0x3431, 0x232175 },
	{ 0x3432, 0x23216e },
	{ 0x3433, 0x232171 },
	{ 0x3434, 0x232173 },
	{ 0x3436, 0x2f2144 },
	{ 0x3438, 0x26234e },
	{ 0x3439, 0x232271 },
	{ 0x343a, 0x242231 },
	{ 0x343b, 0x232269 },
	{ 0x343c, 0x23226a },
	{ 0x343e, 0x2f2172 },
	{ 0x3441, 0x252334 },
	{ 0x3442, 0x23244a },
	{ 0x3443, 0x232447 },
	{ 0x3444, 0x23244d },
	{ 0x3445, 0x262571 },
	{ 0x3449, 0x232746 },
	{ 0x344a, 0x252525 },
	{ 0x344b, 0x242539 },
	{ 0x344c, 0x24253c },
	{ 0x344d, 0x232745 },
	{ 0x344e, 0x25252b },
	{ 0x344f, 0x24253b },
	{ 0x3450, 0x242538 },
	{ 0x3451, 0x232750 },
	{ 0x3453, 0x2f254a },
	{ 0x3457, 0x232b31 },
	{ 0x3458, 0x262e5a },
	{ 0x3459, 0x242839 },
	{ 0x345a, 0x232b30 },
	{ 0x345b, 0x252821 },
	{ 0x345c, 0x24283a },
	{ 0x345d, 0x232b2a },
	{ 0x345e, 0x242837 },
	{ 0x345f, 0x24283c },
	{ 0x3463, 0x252b6c },
	{ 0x3464, 0x233449 },
	{ 0x3465, 0x232f52 },
	{ 0x3466, 0x242b65 },
	{ 0x3467, 0x263538 },
	{ 0x346e, 0x243045 },
	{ 0x346f, 0x23343e },
	{ 0x3470, 0x233448 },
	{ 0x3471, 0x24304a },
	{ 0x3473, 0x243638 },
	{ 0x3474, 0x233973 },
	{ 0x3475, 0x243632 },
	{ 0x3476, 0x243637 },
	{ 0x3477, 0x264655 },
	{ 0x3479, 0x26497b },
	{ 0x347a, 0x233974 },
	{ 0x347b, 0x234035 },
	{ 0x347c, 0x234038 },
	{ 0x347d, 0x23403b },
	{ 0x347e, 0x243c2c },
	{ 0x347f, 0x243c2d },
	{ 0x3480, 0x243c28 },
	{ 0x3481, 0x243c2a },
	{ 0x3482, 0x254457 },
	{ 0x3483, 0x244237 },
	{ 0x3484, 0x244233 },
	{ 0x3485, 0x24422e },
	{ 0x3486, 0x234578 },
	{ 0x3487, 0x265a73 },
	{ 0x3488, 0x24422f },
	{ 0x3489, 0x234573 },
	{ 0x348a, 0x244f59 },
	{ 0x348b, 0x234572 },
	{ 0x348c, 0x23456f },
	{ 0x348d, 0x234577 },
	{ 0x348e, 0x244232 },
	{ 0x3491, 0x24487b },
	{ 0x3492, 0x234b26 },
	{ 0x3493, 0x234b25 },
	{ 0x3494, 0x24487d },
	{ 0x3495, 0x234b24 },
	{ 0x3496, 0x234b28 },
	{ 0x3497, 0x234b2a },
	{ 0x3499, 0x235032 },
	{ 0x349a, 0x244f5d },
	{ 0x349b, 0x255359 },
	{ 0x349c, 0x244f5b },
	{ 0x349d, 0x23543f },
	{ 0x349e, 0x235753 },
	{ 0x349f, 0x245a67 },
	{ 0x34a0, 0x245a68 },
	{ 0x34a1, 0x245f49 },
	{ 0x34a4, 0x24632f },
	{ 0x34a5, 0x235c33 },
	{ 0x34a6, 0x235c31 },
	{ 0x34a7, 0x275274 },
	{ 0x34a8, 0x27574c },
	{ 0x34a9, 0x246a41 },
	{ 0x34aa, 0x23613c },
	{ 0x34ab, 0x242233 },
	{ 0x34ac, 0x2f265a },
	{ 0x34ad, 0x242b69 },
	{ 0x34af, 0x235754 },
	{ 0x34b0, 0x232176 },
	{ 0x34b2, 0x232279 },
	{ 0x34b3, 0x232455 },
	{ 0x34b4, 0x252337 },
	{ 0x34b5, 0x26257b },
	{ 0x34b6, 0x26257d },
	{ 0x34b7, 0x232456 },
	{ 0x34b8, 0x232b38 },
	{ 0x34b9, 0x274d3d },
	{ 0x34ba, 0x232a4c },
	{ 0x34bb, 0x24304c },
	{ 0x34bc, 0x253126 },
	{ 0x34bd, 0x24363d },
	{ 0x34be, 0x243c32 },
	{ 0x34bf, 0x246a42 },
	{ 0x34c2, 0x232b3a },
	{ 0x34c3, 0x233978 },
	{ 0x34c4, 0x244922 },
	{ 0x34c5, 0x232150 },
	{ 0x34c7, 0x232321 },
	{ 0x34c8, 0x232458 },
	{ 0x34c9, 0x25252e },
	{ 0x34ca, 0x232757 },
	{ 0x34cb, 0x232756 },
	{ 0x34cc, 0x232758 },
	{ 0x34ce, 0x242843 },
	{ 0x34cf, 0x232b3c },
	{ 0x34d0, 0x232f5d },
	{ 0x34d1, 0x232f5c },
	{ 0x34d3, 0x24304d },
	{ 0x34d4, 0x23397b },
	{ 0x34d5, 0x23397c },
	{ 0x34d6, 0x243c34 },
	{ 0x34d7, 0x234579 },
	{ 0x34d8, 0x253129 },
	{ 0x34da, 0x242161 },
	{ 0x34db, 0x262241 },
	{ 0x34dc, 0x23217e },
	{ 0x34dd, 0x24223c },
	{ 0x34de, 0x252230 },
	{ 0x34df, 0x24233e },
	{ 0x34e0, 0x24233f },
	{ 0x34e1, 0x24254a },
	{ 0x34e2, 0x24254c },
	{ 0x34e3, 0x242548 },
	{ 0x34e4, 0x242547 },
	{ 0x34e7, 0x232b41 },
	{ 0x34e8, 0x232b45 },
	{ 0x34e9, 0x232b42 },
	{ 0x34ec, 0x252b7c },
	{ 0x34ed, 0x243053 },
	{ 0x34ee, 0x232f67 },
	{ 0x34ef, 0x232f69 },
	{ 0x34f1, 0x243057 },
	{ 0x34f2, 0x243058 },
	{ 0x34f3, 0x243052 },
	{ 0x34f4, 0x25312c },
	{ 0x34f5, 0x243054 },
	{ 0x34f6, 0x243059 },
	{ 0x34f7, 0x233a24 },
	{ 0x34f8, 0x26506c },
	{ 0x34f9, 0x243642 },
	{ 0x34fa, 0x243645 },
	{ 0x34fb, 0x233a22 },
	{ 0x34fc, 0x253d70 },
	{ 0x34fd, 0x234042 },
	{ 0x34fe, 0x244241 },
	{ 0x3500, 0x244243 },
	{ 0x3501, 0x244242 },
	{ 0x3502, 0x24423c },
	{ 0x3503, 0x23457d },
	{ 0x3504, 0x23457b },
	{ 0x3505, 0x24423f },
	{ 0x3506, 0x24423e },
	{ 0x3507, 0x23457c },
	{ 0x350a, 0x244923 },
	{ 0x350b, 0x244f62 },
	{ 0x350c, 0x244f61 },
	{ 0x350d, 0x244f63 },
	{ 0x350e, 0x25613b },
	{ 0x350f, 0x24556c },
	{ 0x3510, 0x273e7d },
	{ 0x3511, 0x245f4a },
	{ 0x3512, 0x246330 },
	{ 0x3513, 0x242164 },
	{ 0x3515, 0x242240 },
	{ 0x3517, 0x242344 },
	{ 0x3518, 0x232464 },
	{ 0x3519, 0x24254f },
	{ 0x351a, 0x26296f },
	{ 0x351c, 0x262f27 },
	{ 0x351d, 0x242b75 },
	{ 0x351e, 0x232f6b },
	{ 0x3520, 0x24305a },
	{ 0x3521, 0x24364b },
	{ 0x3522, 0x234622 },
	{ 0x3523, 0x24556f },
	{ 0x3524, 0x235443 },
	{ 0x3525, 0x245570 },
	{ 0x3526, 0x255363 },
	{ 0x3527, 0x245a6e },
	{ 0x3528, 0x24305c },
	{ 0x3529, 0x24364d },
	{ 0x352a, 0x253d78 },
	{ 0x352c, 0x262972 },
	{ 0x352d, 0x233453 },
	{ 0x352e, 0x257078 },
	{ 0x352f, 0x24234b },
	{ 0x3530, 0x262638 },
	{ 0x3531, 0x242b77 },
	{ 0x3532, 0x233a25 },
	{ 0x3533, 0x265076 },
	{ 0x3534, 0x243c3e },
	{ 0x3535, 0x25446c },
	{ 0x3536, 0x246d53 },
	{ 0x3537, 0x262636 },
	{ 0x3538, 0x243650 },
	{ 0x3539, 0x232158 },
	{ 0x353a, 0x262371 },
	{ 0x353b, 0x23232c },
	{ 0x353c, 0x26507a },
	{ 0x353d, 0x232764 },
	{ 0x353e, 0x24212b },
	{ 0x353f, 0x26213b },
	{ 0x3540, 0x262864 },
	{ 0x3541, 0x242556 },
	{ 0x3542, 0x232330 },
	{ 0x3543, 0x25223c },
	{ 0x3544, 0x23232e },
	{ 0x3545, 0x23246a },
	{ 0x3546, 0x232469 },
	{ 0x3547, 0x232468 },
	{ 0x3548, 0x232768 },
	{ 0x3549, 0x262a2a },
	{ 0x354a, 0x232b4c },
	{ 0x354b, 0x232f70 },
	{ 0x354c, 0x242b7a },
	{ 0x354d, 0x232f71 },
	{ 0x354e, 0x243651 },
	{ 0x354f, 0x265122 },
	{ 0x3550, 0x254c31 },
	{ 0x3551, 0x234624 },
	{ 0x3552, 0x244927 },
	{ 0x3554, 0x236070 },
	{ 0x3555, 0x23215d },
	{ 0x3556, 0x232f72 },
	{ 0x3557, 0x263d61 },
	{ 0x3558, 0x233456 },
	{ 0x3559, 0x244929 },
	{ 0x355a, 0x252141 },
	{ 0x355b, 0x23215f },
	{ 0x355c, 0x232332 },
	{ 0x355e, 0x24255a },
	{ 0x355f, 0x242857 },
	{ 0x3560, 0x233f78 },
	{ 0x3561, 0x234627 },
	{ 0x3562, 0x244756 },
	{ 0x3563, 0x24216b },
	{ 0x3564, 0x232230 },
	{ 0x3565, 0x23222c },
	{ 0x3566, 0x232338 },
	{ 0x3567, 0x232336 },
	{ 0x3569, 0x23246c },
	{ 0x356a, 0x242351 },
	{ 0x356b, 0x23246b },
	{ 0x356c, 0x232471 },
	{ 0x356d, 0x242354 },
	{ 0x356e, 0x242359 },
	{ 0x356f, 0x232472 },
	{ 0x3570, 0x242353 },
	{ 0x3571, 0x23246f },
	{ 0x3572, 0x23246e },
	{ 0x3573, 0x23247a },
	{ 0x3575, 0x2f2349 },
	{ 0x3576, 0x232525 },
	{ 0x3577, 0x23277a },
	{ 0x3578, 0x23276d },
	{ 0x3579, 0x24255d },
	{ 0x357a, 0x232776 },
	{ 0x357b, 0x252542 },
	{ 0x357c, 0x262a39 },
	{ 0x3580, 0x232b52 },
	{ 0x3581, 0x232b60 },
	{ 0x3582, 0x232b5f },
	{ 0x3583, 0x232b62 },
	{ 0x3584, 0x232b5a },
	{ 0x3585, 0x242859 },
	{ 0x3586, 0x24285c },
	{ 0x3587, 0x232b56 },
	{ 0x3588, 0x2f295c },
	{ 0x358f, 0x242c25 },
	{ 0x3590, 0x232f7d },
	{ 0x3591, 0x242b7e },
	{ 0x3592, 0x232f75 },
	{ 0x3593, 0x232f7c },
	{ 0x3594, 0x242c21 },
	{ 0x3595, 0x242b7d },
	{ 0x3596, 0x26357d },
	{ 0x3597, 0x233024 },
	{ 0x3598, 0x252c43 },
	{ 0x359f, 0x23345d },
	{ 0x35a0, 0x233465 },
	{ 0x35a1, 0x24306a },
	{ 0x35a2, 0x253670 },
	{ 0x35a3, 0x233463 },
	{ 0x35a4, 0x23345c },
	{ 0x35a5, 0x243070 },
	{ 0x35a6, 0x23345a },
	{ 0x35a7, 0x243073 },
	{ 0x35a8, 0x243071 },
	{ 0x35a9, 0x24306d },
	{ 0x35aa, 0x24306c },
	{ 0x35ab, 0x2f3343 },
	{ 0x35b4, 0x233853 },
	{ 0x35b5, 0x24306f },
	{ 0x35b6, 0x253676 },
	{ 0x35b7, 0x233a32 },
	{ 0x35b8, 0x243667 },
	{ 0x35b9, 0x233a35 },
	{ 0x35ba, 0x233a2c },
	{ 0x35bb, 0x24365e },
	{ 0x35bc, 0x243659 },
	{ 0x35bd, 0x233a39 },
	{ 0x35be, 0x233a3e },
	{ 0x35bf, 0x233a2d },
	{ 0x35c0, 0x243660 },
	{ 0x35c1, 0x233a3d },
	{ 0x35c2, 0x24365f },
	{ 0x35c3, 0x233a37 },
	{ 0x35c4, 0x264739 },
	{ 0x35c5, 0x253679 },
	{ 0x35c6, 0x25367a },
	{ 0x35c7, 0x233a30 },
	{ 0x35c8, 0x243658 },
	{ 0x35c9, 0x243665 },
	{ 0x35ca, 0x243663 },
	{ 0x35cb, 0x233a41 },
	{ 0x35cc, 0x25366e },
	{ 0x35cd, 0x233a3f },
	{ 0x35d0, 0x233a3a },
	{ 0x35d3, 0x253e39 },
	{ 0x35d4, 0x243c4a },
	{ 0x35d5, 0x243c46 },
	{ 0x35d6, 0x23404f },
	{ 0x35d7, 0x253e3d },
	{ 0x35d8, 0x243c47 },
	{ 0x35d9, 0x243c4c },
	{ 0x35da, 0x23404d },
	{ 0x35db, 0x234050 },
	{ 0x35dc, 0x265132 },
	{ 0x35e2, 0x244252 },
	{ 0x35e3, 0x234632 },
	{ 0x35e4, 0x23462f },
	{ 0x35e5, 0x23462d },
	{ 0x35e6, 0x24424f },
	{ 0x35e7, 0x24424a },
	{ 0x35e8, 0x244255 },
	{ 0x35e9, 0x23462b },
	{ 0x35ea, 0x234b3a },
	{ 0x35eb, 0x244253 },
	{ 0x35ec, 0x244256 },
	{ 0x35ed, 0x244251 },
	{ 0x35f0, 0x254522 },
	{ 0x35f1, 0x244930 },
	{ 0x35f2, 0x24492c },
	{ 0x35f3, 0x234b42 },
	{ 0x35f4, 0x24492d },
	{ 0x35f5, 0x234b36 },
	{ 0x35f6, 0x27214e },
	{ 0x35fb, 0x244f6b },
	{ 0x35fc, 0x244f6c },
	{ 0x35fd, 0x235041 },
	{ 0x35fe, 0x244f67 },
	{ 0x35ff, 0x244f6a },
	{ 0x3600, 0x244f6f },
	{ 0x3601, 0x23503c },
	{ 0x3602, 0x23503a },
	{ 0x3605, 0x273737 },
	{ 0x3606, 0x245572 },
	{ 0x3607, 0x235446 },
	{ 0x3608, 0x245573 },
	{ 0x3609, 0x244f6d },
	{ 0x360a, 0x256140 },
	{ 0x360b, 0x245a70 },
	{ 0x360c, 0x235756 },
	{ 0x360d, 0x256145 },
	{ 0x3610, 0x245f4c },
	{ 0x3611, 0x256759 },
	{ 0x3613, 0x256b73 },
	{ 0x3614, 0x235c35 },
	{ 0x3615, 0x235e27 },
	{ 0x3616, 0x246632 },
	{ 0x3619, 0x23602e },
	{ 0x361a, 0x23602d },
	{ 0x361b, 0x246c6c },
	{ 0x361c, 0x27622f },
	{ 0x361d, 0x232232 },
	{ 0x361e, 0x232221 },
	{ 0x361f, 0x23233d },
	{ 0x3620, 0x252553 },
	{ 0x3621, 0x23277e },
	{ 0x3622, 0x232b64 },
	{ 0x3623, 0x233026 },
	{ 0x3624, 0x244258 },
	{ 0x3625, 0x246332 },
	{ 0x3626, 0x232233 },
	{ 0x3627, 0x23252e },
	{ 0x3628, 0x24235f },
	{ 0x3629, 0x232539 },
	{ 0x362a, 0x23253a },
	{ 0x362b, 0x24235e },
	{ 0x362c, 0x23253d },
	{ 0x362d, 0x23253f },
	{ 0x362f, 0x23253b },
	{ 0x3630, 0x232534 },
	{ 0x3631, 0x232827 },
	{ 0x3632, 0x24256d },
	{ 0x3633, 0x23282b },
	{ 0x3634, 0x23282c },
	{ 0x3636, 0x232b76 },
	{ 0x3637, 0x262f65 },
	{ 0x3638, 0x232b74 },
	{ 0x3639, 0x232b75 },
	{ 0x363a, 0x232b73 },
	{ 0x363b, 0x232b6f },
	{ 0x363f, 0x233029 },
	{ 0x3640, 0x242c2f },
	{ 0x3641, 0x242c31 },
	{ 0x3642, 0x23302d },
	{ 0x3643, 0x23302c },
	{ 0x3644, 0x23302e },
	{ 0x3645, 0x233031 },
	{ 0x3647, 0x23346c },
	{ 0x3648, 0x23346d },
	{ 0x3649, 0x233473 },
	{ 0x364a, 0x23346a },
	{ 0x364b, 0x2f3357 },
	{ 0x364d, 0x243121 },
	{ 0x364e, 0x24366b },
	{ 0x364f, 0x233a46 },
	{ 0x3650, 0x24366e },
	{ 0x3651, 0x233a51 },
	{ 0x3652, 0x26474e },
	{ 0x3653, 0x233a48 },
	{ 0x3655, 0x233a4d },
	{ 0x3659, 0x243c59 },
	{ 0x365a, 0x243c5b },
	{ 0x365b, 0x234053 },
	{ 0x365c, 0x234055 },
	{ 0x365d, 0x243c56 },
	{ 0x365e, 0x243c58 },
	{ 0x3660, 0x24425e },
	{ 0x3661, 0x24425d },
	{ 0x3662, 0x24425b },
	{ 0x3663, 0x23463b },
	{ 0x3664, 0x24425f },
	{ 0x3665, 0x234639 },
	{ 0x3667, 0x27216a },
	{ 0x3668, 0x234b52 },
	{ 0x3669, 0x234b48 },
	{ 0x366a, 0x244933 },
	{ 0x366b, 0x234b4a },
	{ 0x366c, 0x234b4e },
	{ 0x366d, 0x2f4e25 },
	{ 0x366e, 0x2f4e2e },
	{ 0x366f, 0x24492a },
	{ 0x3670, 0x235044 },
	{ 0x3671, 0x244f78 },
	{ 0x3672, 0x235047 },
	{ 0x3673, 0x235042 },
	{ 0x3674, 0x235043 },
	{ 0x3675, 0x235046 },
	{ 0x3676, 0x235045 },
	{ 0x3677, 0x24557c },
	{ 0x3678, 0x23544d },
	{ 0x3679, 0x23544a },
	{ 0x367a, 0x24557b },
	{ 0x367b, 0x273f30 },
	{ 0x367c, 0x23575d },
	{ 0x367e, 0x274644 },
	{ 0x3680, 0x256b76 },
	{ 0x3681, 0x236072 },
	{ 0x3682, 0x246c6e },
	{ 0x3683, 0x25373c },
	{ 0x3684, 0x234d41 },
	{ 0x3685, 0x232b78 },
	{ 0x3687, 0x242861 },
	{ 0x3689, 0x252558 },
	{ 0x368a, 0x243677 },
	{ 0x368b, 0x244260 },
	{ 0x368c, 0x234647 },
	{ 0x368d, 0x245a7a },
	{ 0x368e, 0x23223a },
	{ 0x368f, 0x232346 },
	{ 0x3690, 0x232348 },
	{ 0x3692, 0x242365 },
	{ 0x3693, 0x23254a },
	{ 0x3694, 0x242571 },
	{ 0x3695, 0x252559 },
	{ 0x3696, 0x242577 },
	{ 0x3697, 0x242573 },
	{ 0x3698, 0x242578 },
	{ 0x369a, 0x232b7d },
	{ 0x369c, 0x243125 },
	{ 0x369d, 0x263e42 },
	{ 0x369e, 0x23347a },
	{ 0x369f, 0x233a55 },
	{ 0x36a0, 0x243c5c },
	{ 0x36a1, 0x23503e },
	{ 0x36a2, 0x232174 },
	{ 0x36a3, 0x23234c },
	{ 0x36a4, 0x23234a },
	{ 0x36a5, 0x242256 },
	{ 0x36a6, 0x242259 },
	{ 0x36a7, 0x242255 },
	{ 0x36a8, 0x232349 },
	{ 0x36a9, 0x232552 },
	{ 0x36aa, 0x232557 },
	{ 0x36ab, 0x232550 },
	{ 0x36ac, 0x23254f },
	{ 0x36ad, 0x23254d },
	{ 0x36ae, 0x232554 },
	{ 0x36b0, 0x232831 },
	{ 0x36b1, 0x23283b },
	{ 0x36b2, 0x24257b },
	{ 0x36b3, 0x232842 },
	{ 0x36b4, 0x232832 },
	{ 0x36b5, 0x23283a },
	{ 0x36b6, 0x232843 },
	{ 0x36b7, 0x232847 },
	{ 0x36b8, 0x232834 },
	{ 0x36b9, 0x242621 },
	{ 0x36ba, 0x232844 },
	{ 0x36bb, 0x23283e },
	{ 0x36bc, 0x232836 },
	{ 0x36bd, 0x23283c },
	{ 0x36be, 0x25255d },
	{ 0x36bf, 0x232839 },
	{ 0x36c1, 0x232830 },
	{ 0x36c2, 0x24286d },
	{ 0x36c3, 0x242869 },
	{ 0x36c4, 0x232b7e },
	{ 0x36c5, 0x232c22 },
	{ 0x36c9, 0x2f2a2a },
	{ 0x36ca, 0x242867 },
	{ 0x36cd, 0x23303f },
	{ 0x36ce, 0x233042 },
	{ 0x36cf, 0x23303d },
	{ 0x36d0, 0x233049 },
	{ 0x36d1, 0x233047 },
	{ 0x36d2, 0x242c3b },
	{ 0x36d3, 0x233043 },
	{ 0x36d4, 0x233050 },
	{ 0x36d5, 0x23304c },
	{ 0x36d6, 0x233044 },
	{ 0x36d7, 0x242c3f },
	{ 0x36d8, 0x242c3a },
	{ 0x36d9, 0x233039 },
	{ 0x36da, 0x242c3c },
	{ 0x36db, 0x233051 },
	{ 0x36dc, 0x233046 },
	{ 0x36dd, 0x233041 },
	{ 0x36de, 0x23303a },
	{ 0x36e1, 0x2f2e6b },
	{ 0x36e2, 0x2f2e78 },
	{ 0x36e5, 0x243129 },
	{ 0x36e6, 0x233526 },
	{ 0x36e7, 0x23352d },
	{ 0x36e8, 0x233521 },
	{ 0x36e9, 0x233536 },
	{ 0x36ea, 0x243128 },
	{ 0x36eb, 0x23352c },
	{ 0x36ec, 0x233523 },
	{ 0x36ed, 0x233525 },
	{ 0x36ee, 0x233a71 },
	{ 0x36ef, 0x233a67 },
	{ 0x36f0, 0x233a74 },
	{ 0x36f1, 0x233a64 },
	{ 0x36f2, 0x233a76 },
	{ 0x36f3, 0x233a6c },
	{ 0x36f4, 0x233a6a },
	{ 0x36f5, 0x233a65 },
	{ 0x36f6, 0x25374e },
	{ 0x36f7, 0x233a6e },
	{ 0x36f8, 0x253746 },
	{ 0x36f9, 0x24367e },
	{ 0x36fa, 0x233a6f },
	{ 0x36fb, 0x233a5f },
	{ 0x36fc, 0x24367d },
	{ 0x36fd, 0x233a70 },
	{ 0x36fe, 0x233a5d },
	{ 0x3701, 0x2f3a3c },
	{ 0x3702, 0x233a6d },
	{ 0x3703, 0x233a69 },
	{ 0x3704, 0x233a68 },
	{ 0x3705, 0x243c5f },
	{ 0x3706, 0x234062 },
	{ 0x3707, 0x243c61 },
	{ 0x3708, 0x23406e },
	{ 0x3709, 0x23406d },
	{ 0x370a, 0x234068 },
	{ 0x370b, 0x234063 },
	{ 0x370c, 0x243c64 },
	{ 0x370d, 0x234065 },
	{ 0x370e, 0x243c63 },
	{ 0x370f, 0x234070 },
	{ 0x3710, 0x23406b },
	{ 0x3711, 0x23406f },
	{ 0x3712, 0x23406c },
	{ 0x3713, 0x234069 },
	{ 0x3715, 0x23464b },
	{ 0x3716, 0x244267 },
	{ 0x3717, 0x24426c },
	{ 0x3718, 0x244268 },
	{ 0x3719, 0x244266 },
	{ 0x371a, 0x234649 },
	{ 0x371b, 0x234652 },
	{ 0x371c, 0x234651 },
	{ 0x371d, 0x24426b },
	{ 0x371e, 0x24426d },
	{ 0x3720, 0x23464d },
	{ 0x3721, 0x23464e },
	{ 0x3722, 0x244269 },
	{ 0x3723, 0x24493c },
	{ 0x3724, 0x24493a },
	{ 0x3725, 0x234b59 },
	{ 0x3726, 0x234b57 },
	{ 0x3727, 0x244940 },
	{ 0x3728, 0x234b55 },
	{ 0x3729, 0x235052 },
	{ 0x372a, 0x235055 },
	{ 0x372b, 0x245021 },
	{ 0x372c, 0x2f542a },
	{ 0x372e, 0x245622 },
	{ 0x372f, 0x245624 },
	{ 0x3730, 0x23575f },
	{ 0x3731, 0x235760 },
	{ 0x3732, 0x245f54 },
	{ 0x3733, 0x25675e },
	{ 0x3734, 0x235a30 },
	{ 0x3735, 0x235a32 },
	{ 0x3736, 0x235c37 },
	{ 0x3737, 0x246335 },
	{ 0x3738, 0x235c38 },
	{ 0x3739, 0x246637 },
	{ 0x373a, 0x246865 },
	{ 0x373b, 0x236162 },
	{ 0x373c, 0x236163 },
	{ 0x373d, 0x23234e },
	{ 0x373e, 0x262678 },
	{ 0x373f, 0x24236d },
	{ 0x3740, 0x232849 },
	{ 0x3741, 0x242870 },
	{ 0x3742, 0x242c41 },
	{ 0x3743, 0x233054 },
	{ 0x3744, 0x233a7d },
	{ 0x3745, 0x243c67 },
	{ 0x3747, 0x272d2d },
	{ 0x3748, 0x23613d },
	{ 0x374a, 0x23223c },
	{ 0x374c, 0x23234f },
	{ 0x374d, 0x262679 },
	{ 0x374e, 0x232559 },
	{ 0x374f, 0x242370 },
	{ 0x3750, 0x23255b },
	{ 0x3751, 0x26267a },
	{ 0x3752, 0x23284f },
	{ 0x3753, 0x25286e },
	{ 0x3754, 0x232c30 },
	{ 0x3755, 0x232c31 },
	{ 0x3756, 0x232c33 },
	{ 0x3757, 0x242c42 },
	{ 0x3758, 0x252c7c },
	{ 0x3759, 0x26365d },
	{ 0x375b, 0x233542 },
	{ 0x375c, 0x23353d },
	{ 0x375d, 0x23353e },
	{ 0x375e, 0x24312e },
	{ 0x375f, 0x263e5a },
	{ 0x3760, 0x233540 },
	{ 0x3762, 0x233b21 },
	{ 0x3763, 0x243722 },
	{ 0x3764, 0x243c6a },
	{ 0x3765, 0x243c6c },
	{ 0x3766, 0x243c6f },
	{ 0x3767, 0x234077 },
	{ 0x3769, 0x244274 },
	{ 0x376a, 0x244275 },
	{ 0x376b, 0x234b60 },
	{ 0x376c, 0x244277 },
	{ 0x376d, 0x244943 },
	{ 0x376e, 0x244945 },
	{ 0x376f, 0x244946 },
	{ 0x3770, 0x245a7d },
	{ 0x3771, 0x235e2b },
	{ 0x3772, 0x276235 },
	{ 0x3774, 0x242371 },
	{ 0x3775, 0x242626 },
	{ 0x3776, 0x263668 },
	{ 0x3777, 0x233b22 },
	{ 0x3778, 0x242c4c },
	{ 0x3779, 0x263e64 },
	{ 0x377a, 0x244278 },
	{ 0x377b, 0x254c63 },
	{ 0x377c, 0x24225d },
	{ 0x377d, 0x242374 },
	{ 0x377e, 0x242628 },
	{ 0x377f, 0x242627 },
	{ 0x3780, 0x242874 },
	{ 0x3781, 0x242875 },
	{ 0x3782, 0x242c4d },
	{ 0x3783, 0x253175 },
	{ 0x3784, 0x243133 },
	{ 0x3785, 0x253173 },
	{ 0x3786, 0x243132 },
	{ 0x3787, 0x243728 },
	{ 0x3788, 0x243729 },
	{ 0x3789, 0x243c71 },
	{ 0x378a, 0x244279 },
	{ 0x378b, 0x232240 },
	{ 0x378c, 0x232353 },
	{ 0x378f, 0x24262a },
	{ 0x3790, 0x232852 },
	{ 0x3791, 0x232853 },
	{ 0x3792, 0x242879 },
	{ 0x3793, 0x242878 },
	{ 0x3794, 0x232c39 },
	{ 0x3795, 0x232c38 },
	{ 0x3796, 0x232c36 },
	{ 0x3797, 0x242c4e },
	{ 0x3798, 0x263e6b },
	{ 0x3799, 0x233545 },
	{ 0x379a, 0x24372b },
	{ 0x379b, 0x253766 },
	{ 0x379c, 0x24427d },
	{ 0x379f, 0x24494a },
	{ 0x37a1, 0x235a37 },
	{ 0x37a2, 0x232162 },
	{ 0x37a3, 0x242377 },
	{ 0x37a4, 0x232242 },
	{ 0x37a5, 0x232243 },
	{ 0x37a6, 0x232241 },
	{ 0x37a7, 0x232244 },
	{ 0x37a8, 0x232356 },
	{ 0x37a9, 0x242261 },
	{ 0x37aa, 0x252251 },
	{ 0x37ab, 0x24237b },
	{ 0x37ac, 0x252250 },
	{ 0x37ad, 0x232357 },
	{ 0x37af, 0x232358 },
	{ 0x37b0, 0x242378 },
	{ 0x37b1, 0x242379 },
	{ 0x37b2, 0x232560 },
	{ 0x37b3, 0x252370 },
	{ 0x37b4, 0x252374 },
	{ 0x37b5, 0x232564 },
	{ 0x37b6, 0x232565 },
	{ 0x37b7, 0x242376 },
	{ 0x37b9, 0x23285b },
	{ 0x37ba, 0x262a7b },
	{ 0x37bb, 0x242631 },
	{ 0x37bc, 0x242632 },
	{ 0x37bd, 0x24262e },
	{ 0x37be, 0x232856 },
	{ 0x37bf, 0x262a76 },
	{ 0x37c0, 0x232859 },
	{ 0x37c1, 0x23285a },
	{ 0x37c3, 0x25256e },
	{ 0x37c4, 0x232c3a },
	{ 0x37c5, 0x24287b },
	{ 0x37c7, 0x242c5b },
	{ 0x37c8, 0x242c53 },
	{ 0x37c9, 0x242c51 },
	{ 0x37ca, 0x233060 },
	{ 0x37cb, 0x242c5f },
	{ 0x37cc, 0x242c55 },
	{ 0x37cd, 0x23305c },
	{ 0x37ce, 0x242c5a },
	{ 0x37cf, 0x242c5e },
	{ 0x37d0, 0x242c57 },
	{ 0x37d1, 0x23305d },
	{ 0x37d2, 0x26367c },
	{ 0x37d3, 0x252d2e },
	{ 0x37d4, 0x233065 },
	{ 0x37d6, 0x242c54 },
	{ 0x37d7, 0x233556 },
	{ 0x37d8, 0x233549 },
	{ 0x37d9, 0x243137 },
	{ 0x37da, 0x23354c },
	{ 0x37db, 0x24313d },
	{ 0x37dc, 0x263e75 },
	{ 0x37dd, 0x23354d },
	{ 0x37de, 0x243139 },
	{ 0x37df, 0x263e78 },
	{ 0x37e0, 0x233550 },
	{ 0x37e2, 0x2f343f },
	{ 0x37e5, 0x233553 },
	{ 0x37e6, 0x233b2f },
	{ 0x37e7, 0x233b32 },
	{ 0x37e8, 0x233b29 },
	{ 0x37e9, 0x243732 },
	{ 0x37ea, 0x243734 },
	{ 0x37eb, 0x233b35 },
	{ 0x37ec, 0x243c72 },
	{ 0x37ed, 0x233b30 },
	{ 0x37ef, 0x233b2c },
	{ 0x37f0, 0x243c76 },
	{ 0x37f1, 0x243c73 },
	{ 0x37f2, 0x243c7e },
	{ 0x37f3, 0x253e6d },
	{ 0x37f4, 0x243d21 },
	{ 0x37f5, 0x265234 },
	{ 0x37f6, 0x23407b },
	{ 0x37f8, 0x243c77 },
	{ 0x37f9, 0x244322 },
	{ 0x37fa, 0x265c44 },
	{ 0x37fb, 0x24432d },
	{ 0x37fc, 0x24432a },
	{ 0x37fd, 0x244321 },
	{ 0x37fe, 0x234655 },
	{ 0x37ff, 0x244324 },
	{ 0x3800, 0x23465b },
	{ 0x3801, 0x234658 },
	{ 0x3802, 0x24432e },
	{ 0x3804, 0x234657 },
	{ 0x3805, 0x244950 },
	{ 0x3806, 0x24494c },
	{ 0x3807, 0x254c6c },
	{ 0x3808, 0x234b62 },
	{ 0x3809, 0x254c68 },
	{ 0x380a, 0x24494b },
	{ 0x380b, 0x244953 },
	{ 0x380c, 0x234b64 },
	{ 0x380d, 0x24494f },
	{ 0x380e, 0x24494d },
	{ 0x380f, 0x234b61 },
	{ 0x3810, 0x244954 },
	{ 0x3811, 0x245026 },
	{ 0x3812, 0x245027 },
	{ 0x3813, 0x245628 },
	{ 0x3814, 0x245025 },
	{ 0x3815, 0x255436 },
	{ 0x3816, 0x235059 },
	{ 0x3817, 0x272d4c },
	{ 0x3818, 0x23545a },
	{ 0x3819, 0x235456 },
	{ 0x381a, 0x255b3c },
	{ 0x381b, 0x245627 },
	{ 0x381c, 0x235458 },
	{ 0x381d, 0x273f44 },
	{ 0x3820, 0x245f5a },
	{ 0x3821, 0x256763 },
	{ 0x3822, 0x256764 },
	{ 0x3825, 0x24663a },
	{ 0x3826, 0x235e2c },
	{ 0x3827, 0x246868 },
	{ 0x3828, 0x257b3d },
	{ 0x3829, 0x23235b },
	{ 0x382a, 0x26216e },
	{ 0x382d, 0x233b38 },
	{ 0x382e, 0x244955 },
	{ 0x382f, 0x232245 },
	{ 0x3831, 0x243142 },
	{ 0x3832, 0x232246 },
	{ 0x3834, 0x242265 },
	{ 0x3835, 0x242266 },
	{ 0x3836, 0x23235d },
	{ 0x3837, 0x242422 },
	{ 0x3838, 0x242424 },
	{ 0x3839, 0x232569 },
	{ 0x383a, 0x242421 },
	{ 0x383b, 0x23256a },
	{ 0x383c, 0x2f2425 },
	{ 0x383d, 0x242636 },
	{ 0x383e, 0x242637 },
	{ 0x383f, 0x242925 },
	{ 0x3840, 0x242425 },
	{ 0x3841, 0x242922 },
	{ 0x3842, 0x242924 },
	{ 0x3843, 0x263063 },
	{ 0x3844, 0x232c47 },
	{ 0x3845, 0x242923 },
	{ 0x3846, 0x242921 },
	{ 0x3847, 0x242c66 },
	{ 0x3848, 0x242c68 },
	{ 0x3849, 0x243147 },
	{ 0x384a, 0x243148 },
	{ 0x384b, 0x243145 },
	{ 0x384c, 0x243149 },
	{ 0x384e, 0x23355c },
	{ 0x384f, 0x24373b },
	{ 0x3850, 0x243736 },
	{ 0x3851, 0x24373d },
	{ 0x3852, 0x24373a },
	{ 0x3853, 0x233b3c },
	{ 0x3854, 0x24373c },
	{ 0x3855, 0x233b39 },
	{ 0x3856, 0x243739 },
	{ 0x3857, 0x243d28 },
	{ 0x3858, 0x243d23 },
	{ 0x3859, 0x243d27 },
	{ 0x385a, 0x243d26 },
	{ 0x385b, 0x243d29 },
	{ 0x385c, 0x244333 },
	{ 0x385d, 0x244332 },
	{ 0x385e, 0x244331 },
	{ 0x385f, 0x24432f },
	{ 0x3860, 0x234b6e },
	{ 0x3862, 0x234b6f },
	{ 0x3863, 0x245029 },
	{ 0x3865, 0x24562d },
	{ 0x3866, 0x24562b },
	{ 0x3867, 0x24633b },
	{ 0x3868, 0x24633a },
	{ 0x3869, 0x235f44 },
	{ 0x386a, 0x24686b },
	{ 0x386b, 0x264844 },
	{ 0x386d, 0x23465e },
	{ 0x386e, 0x24502b },
	{ 0x386f, 0x232360 },
	{ 0x3870, 0x23235f },
	{ 0x3871, 0x23235e },
	{ 0x3872, 0x23256c },
	{ 0x3873, 0x262747 },
	{ 0x3874, 0x242638 },
	{ 0x3875, 0x24263d },
	{ 0x3876, 0x24263b },
	{ 0x3877, 0x252626 },
	{ 0x3878, 0x24263c },
	{ 0x3879, 0x232864 },
	{ 0x387a, 0x24263a },
	{ 0x387b, 0x232866 },
	{ 0x387c, 0x2f2f38 },
	{ 0x387d, 0x232c49 },
	{ 0x387e, 0x232c4a },
	{ 0x387f, 0x24292a },
	{ 0x3880, 0x252926 },
	{ 0x3881, 0x242929 },
	{ 0x3882, 0x242928 },
	{ 0x3883, 0x242c6b },
	{ 0x3884, 0x242c6d },
	{ 0x3885, 0x242c6c },
	{ 0x3886, 0x23306d },
	{ 0x3888, 0x23355e },
	{ 0x3889, 0x24314e },
	{ 0x388a, 0x24314c },
	{ 0x388b, 0x24314f },
	{ 0x388c, 0x23355d },
	{ 0x388d, 0x253829 },
	{ 0x388e, 0x243740 },
	{ 0x388f, 0x243741 },
	{ 0x3890, 0x233b41 },
	{ 0x3891, 0x253f21 },
	{ 0x3892, 0x244336 },
	{ 0x3893, 0x23465f },
	{ 0x3894, 0x244339 },
	{ 0x3895, 0x24433a },
	{ 0x3896, 0x24495b },
	{ 0x3897, 0x24495c },
	{ 0x3898, 0x234b71 },
	{ 0x3899, 0x23505d },
	{ 0x389a, 0x24502c },
	{ 0x389b, 0x24502e },
	{ 0x389c, 0x255442 },
	{ 0x389d, 0x245f5e },
	{ 0x389e, 0x24633c },
	{ 0x389f, 0x242429 },
	{ 0x38a0, 0x23286a },
	{ 0x38a1, 0x234662 },
	{ 0x38a3, 0x272d5b },
	{ 0x38a5, 0x24292b },
	{ 0x38a6, 0x243d2d },
	{ 0x38a7, 0x262179 },
	{ 0x38a8, 0x24226a },
	{ 0x38a9, 0x232363 },
	{ 0x38aa, 0x232364 },
	{ 0x38ac, 0x232570 },
	{ 0x38ae, 0x23286f },
	{ 0x38af, 0x242640 },
	{ 0x38b0, 0x242641 },
	{ 0x38b2, 0x232c4e },
	{ 0x38b3, 0x24292d },
	{ 0x38b4, 0x26307a },
	{ 0x38b5, 0x24292e },
	{ 0x38b6, 0x232c4f },
	{ 0x38b8, 0x242c71 },
	{ 0x38ba, 0x253246 },
	{ 0x38bb, 0x243151 },
	{ 0x38bc, 0x242c72 },
	{ 0x38bd, 0x233b46 },
	{ 0x38be, 0x233b43 },
	{ 0x38c0, 0x253f29 },
	{ 0x38c1, 0x243d2f },
	{ 0x38c2, 0x243d2e },
	{ 0x38c3, 0x26524d },
	{ 0x38c4, 0x24495d },
	{ 0x38c5, 0x24495f },
	{ 0x38c6, 0x235e2e },
	{ 0x38c7, 0x242642 },
	{ 0x38c8, 0x245031 },
	{ 0x38c9, 0x262470 },
	{ 0x38cb, 0x232873 },
	{ 0x38cc, 0x242643 },
	{ 0x38cd, 0x232872 },
	{ 0x38ce, 0x233564 },
	{ 0x38cf, 0x233b48 },
	{ 0x38d0, 0x233b49 },
	{ 0x38d1, 0x24433b },
	{ 0x38d2, 0x244961 },
	{ 0x38d3, 0x23505f },
	{ 0x38d4, 0x23224b },
	{ 0x38d8, 0x262b3e },
	{ 0x38d9, 0x232874 },
	{ 0x38da, 0x242932 },
	{ 0x38db, 0x242934 },
	{ 0x38dc, 0x232c52 },
	{ 0x38dd, 0x25292f },
	{ 0x38de, 0x252933 },
	{ 0x38df, 0x232c53 },
	{ 0x38e0, 0x263125 },
	{ 0x38e2, 0x252d47 },
	{ 0x38e3, 0x2f2f3e },
	{ 0x38e4, 0x243154 },
	{ 0x38e5, 0x233566 },
	{ 0x38e6, 0x233567 },
	{ 0x38eb, 0x243749 },
	{ 0x38ec, 0x233b4a },
	{ 0x38ed, 0x243748 },
	{ 0x38ef, 0x243d33 },
	{ 0x38f0, 0x254569 },
	{ 0x38f1, 0x24433d },
	{ 0x38f2, 0x265c67 },
	{ 0x38f5, 0x235060 },
	{ 0x38f6, 0x245034 },
	{ 0x38f7, 0x24562f },
	{ 0x38fa, 0x26217e },
	{ 0x38fb, 0x232365 },
	{ 0x38fc, 0x232368 },
	{ 0x38fd, 0x242431 },
	{ 0x38fe, 0x252267 },
	{ 0x38ff, 0x242270 },
	{ 0x3901, 0x23287b },
	{ 0x3902, 0x23287d },
	{ 0x3903, 0x232579 },
	{ 0x3904, 0x24242e },
	{ 0x3905, 0x23287c },
	{ 0x3906, 0x242430 },
	{ 0x3907, 0x242433 },
	{ 0x3908, 0x232573 },
	{ 0x3909, 0x24242f },
	{ 0x390a, 0x242432 },
	{ 0x390b, 0x232624 },
	{ 0x390c, 0x232879 },
	{ 0x390d, 0x242935 },
	{ 0x390e, 0x242937 },
	{ 0x390f, 0x24264d },
	{ 0x3910, 0x232c59 },
	{ 0x3911, 0x232924 },
	{ 0x3912, 0x242648 },
	{ 0x3913, 0x232923 },
	{ 0x3914, 0x24264e },
	{ 0x3915, 0x24264c },
	{ 0x3916, 0x242646 },
	{ 0x3917, 0x2f2a3e },
	{ 0x3919, 0x232c58 },
	{ 0x391a, 0x242941 },
	{ 0x391b, 0x232c62 },
	{ 0x391c, 0x24293c },
	{ 0x391d, 0x242649 },
	{ 0x391e, 0x242939 },
	{ 0x391f, 0x23307d },
	{ 0x3920, 0x263754 },
	{ 0x3921, 0x24293d },
	{ 0x3922, 0x252935 },
	{ 0x3923, 0x242d28 },
	{ 0x3924, 0x242948 },
	{ 0x3925, 0x24293a },
	{ 0x3926, 0x24293b },
	{ 0x3927, 0x242940 },
	{ 0x3928, 0x232c55 },
	{ 0x3929, 0x26375a },
	{ 0x392a, 0x23307c },
	{ 0x392c, 0x232c5e },
	{ 0x392e, 0x24315b },
	{ 0x392f, 0x252d5a },
	{ 0x3930, 0x233573 },
	{ 0x3931, 0x242d22 },
	{ 0x3932, 0x233569 },
	{ 0x3933, 0x233075 },
	{ 0x3934, 0x242d23 },
	{ 0x3935, 0x233570 },
	{ 0x3936, 0x242d24 },
	{ 0x3937, 0x233077 },
	{ 0x3938, 0x26375e },
	{ 0x3939, 0x233124 },
	{ 0x393a, 0x242d2b },
	{ 0x393b, 0x24315a },
	{ 0x393e, 0x24315c },
	{ 0x393f, 0x243162 },
	{ 0x3940, 0x23356b },
	{ 0x3941, 0x26486f },
	{ 0x3942, 0x243163 },
	{ 0x3943, 0x233575 },
	{ 0x3944, 0x243160 },
	{ 0x3945, 0x25325b },
	{ 0x3946, 0x24315d },
	{ 0x3947, 0x23356c },
	{ 0x3948, 0x233b4e },
	{ 0x3949, 0x24316c },
	{ 0x394a, 0x243167 },
	{ 0x394b, 0x233b4c },
	{ 0x394c, 0x23356d },
	{ 0x394d, 0x233577 },
	{ 0x394e, 0x233b57 },
	{ 0x394f, 0x243164 },
	{ 0x3950, 0x264875 },
	{ 0x3951, 0x233b53 },
	{ 0x3952, 0x243166 },
	{ 0x3953, 0x24315e },
	{ 0x3954, 0x252d57 },
	{ 0x3955, 0x233b52 },
	{ 0x3956, 0x253842 },
	{ 0x395a, 0x24316a },
	{ 0x395b, 0x253848 },
	{ 0x395c, 0x243756 },
	{ 0x395d, 0x243750 },
	{ 0x395e, 0x233b5c },
	{ 0x395f, 0x243759 },
	{ 0x3960, 0x233b5f },
	{ 0x3961, 0x243754 },
	{ 0x3962, 0x24374e },
	{ 0x3963, 0x253f32 },
	{ 0x3964, 0x234125 },
	{ 0x3965, 0x243755 },
	{ 0x3966, 0x243d3e },
	{ 0x3967, 0x233b60 },
	{ 0x3968, 0x243d37 },
	{ 0x3969, 0x253258 },
	{ 0x396b, 0x233b5b },
	{ 0x396c, 0x234126 },
	{ 0x396d, 0x23412d },
	{ 0x396e, 0x243d3b },
	{ 0x396f, 0x244343 },
	{ 0x3970, 0x253f42 },
	{ 0x3971, 0x265269 },
	{ 0x3972, 0x234667 },
	{ 0x3973, 0x243d3a },
	{ 0x3974, 0x243d3c },
	{ 0x3975, 0x234130 },
	{ 0x3976, 0x234665 },
	{ 0x3977, 0x244342 },
	{ 0x3978, 0x244350 },
	{ 0x3979, 0x234666 },
	{ 0x397a, 0x23412f },
	{ 0x397c, 0x244348 },
	{ 0x397d, 0x244347 },
	{ 0x397e, 0x244349 },
	{ 0x397f, 0x234b7d },
	{ 0x3980, 0x24434d },
	{ 0x3981, 0x244965 },
	{ 0x3982, 0x234c22 },
	{ 0x3983, 0x234669 },
	{ 0x3984, 0x234b7b },
	{ 0x3985, 0x24434a },
	{ 0x3986, 0x24434c },
	{ 0x3987, 0x244346 },
	{ 0x3989, 0x234c27 },
	{ 0x398a, 0x234b78 },
	{ 0x398b, 0x24434b },
	{ 0x398c, 0x245038 },
	{ 0x398d, 0x234c2a },
	{ 0x398e, 0x244967 },
	{ 0x398f, 0x244969 },
	{ 0x3990, 0x244968 },
	{ 0x3991, 0x24496b },
	{ 0x3992, 0x27227c },
	{ 0x3993, 0x24496d },
	{ 0x3994, 0x235069 },
	{ 0x3995, 0x24496c },
	{ 0x3996, 0x234c26 },
	{ 0x3997, 0x245039 },
	{ 0x3998, 0x255b4c },
	{ 0x399a, 0x245b23 },
	{ 0x399b, 0x245b29 },
	{ 0x399c, 0x245636 },
	{ 0x399d, 0x245b25 },
	{ 0x399e, 0x235767 },
	{ 0x399f, 0x245b24 },
	{ 0x39a0, 0x2f5a29 },
	{ 0x39a1, 0x235766 },
	{ 0x39a2, 0x24503a },
	{ 0x39a3, 0x256778 },
	{ 0x39a4, 0x246343 },
	{ 0x39a5, 0x245f64 },
	{ 0x39a6, 0x256773 },
	{ 0x39a7, 0x27472c },
	{ 0x39a8, 0x235e30 },
	{ 0x39a9, 0x246342 },
	{ 0x39aa, 0x246340 },
	{ 0x39ab, 0x235f47 },
	{ 0x39ac, 0x24686c },
	{ 0x39ad, 0x236178 },
	{ 0x39ae, 0x23236a },
	{ 0x39af, 0x232626 },
	{ 0x39b0, 0x242654 },
	{ 0x39b2, 0x262b52 },
	{ 0x39b4, 0x242d2f },
	{ 0x39b5, 0x242d30 },
	{ 0x39b6, 0x252d5d },
	{ 0x39b7, 0x23357a },
	{ 0x39b8, 0x233b65 },
	{ 0x39b9, 0x243d42 },
	{ 0x39ba, 0x244354 },
	{ 0x39bb, 0x254d37 },
	{ 0x39bc, 0x234c2b },
	{ 0x39bd, 0x235462 },
	{ 0x39be, 0x26276e },
	{ 0x39bf, 0x242655 },
	{ 0x39c0, 0x242656 },
	{ 0x39c1, 0x24294d },
	{ 0x39c2, 0x232c64 },
	{ 0x39c3, 0x24217b },
	{ 0x39c4, 0x24217a },
	{ 0x39c5, 0x23224f },
	{ 0x39c6, 0x242274 },
	{ 0x39c7, 0x242273 },
	{ 0x39c8, 0x242275 },
	{ 0x39c9, 0x24243a },
	{ 0x39ca, 0x242436 },
	{ 0x39cb, 0x23262c },
	{ 0x39cc, 0x23262d },
	{ 0x39cd, 0x232630 },
	{ 0x39ce, 0x23262b },
	{ 0x39d2, 0x242658 },
	{ 0x39d3, 0x23292d },
	{ 0x39d4, 0x25263a },
	{ 0x39d5, 0x23292c },
	{ 0x39d6, 0x232938 },
	{ 0x39d7, 0x242955 },
	{ 0x39d8, 0x242d33 },
	{ 0x39d9, 0x242659 },
	{ 0x39da, 0x23292b },
	{ 0x39de, 0x2f272e },
	{ 0x39e1, 0x24294e },
	{ 0x39e2, 0x242954 },
	{ 0x39e3, 0x232c66 },
	{ 0x39e4, 0x232927 },
	{ 0x39e5, 0x232c67 },
	{ 0x39e6, 0x232c69 },
	{ 0x39e7, 0x242d3c },
	{ 0x39e8, 0x232c71 },
	{ 0x39e9, 0x242956 },
	{ 0x39ea, 0x232c68 },
	{ 0x39eb, 0x242952 },
	{ 0x39ec, 0x242d32 },
	{ 0x39ed, 0x242d31 },
	{ 0x39ee, 0x232c6a },
	{ 0x39ef, 0x232c65 },
	{ 0x39f1, 0x233134 },
	{ 0x39f2, 0x23312a },
	{ 0x39f3, 0x23357b },
	{ 0x39f4, 0x233131 },
	{ 0x39f5, 0x23313a },
	{ 0x39f6, 0x242d3b },
	{ 0x39f7, 0x23312d },
	{ 0x39f8, 0x23312b },
	{ 0x39f9, 0x24317c },
	{ 0x39fa, 0x243221 },
	{ 0x39fb, 0x24317b },
	{ 0x39fc, 0x23362c },
	{ 0x39fd, 0x264032 },
	{ 0x39fe, 0x243225 },
	{ 0x39ff, 0x23362f },
	{ 0x3a00, 0x233630 },
	{ 0x3a01, 0x243179 },
	{ 0x3a02, 0x23357e },
	{ 0x3a03, 0x243171 },
	{ 0x3a04, 0x233625 },
	{ 0x3a05, 0x24317e },
	{ 0x3a06, 0x24317a },
	{ 0x3a07, 0x233b6b },
	{ 0x3a08, 0x23362a },
	{ 0x3a09, 0x24376e },
	{ 0x3a0a, 0x243762 },
	{ 0x3a0b, 0x233621 },
	{ 0x3a0c, 0x243d45 },
	{ 0x3a0d, 0x234131 },
	{ 0x3a0e, 0x243764 },
	{ 0x3a0f, 0x233b6a },
	{ 0x3a10, 0x24376b },
	{ 0x3a11, 0x243768 },
	{ 0x3a12, 0x243765 },
	{ 0x3a13, 0x233b6c },
	{ 0x3a14, 0x233b69 },
	{ 0x3a15, 0x243770 },
	{ 0x3a16, 0x243761 },
	{ 0x3a17, 0x233b6e },
	{ 0x3a19, 0x243d50 },
	{ 0x3a1a, 0x243d4f },
	{ 0x3a1b, 0x234137 },
	{ 0x3a1c, 0x243d4c },
	{ 0x3a1d, 0x243d4a },
	{ 0x3a1e, 0x234135 },
	{ 0x3a1f, 0x23413b },
	{ 0x3a20, 0x243d48 },
	{ 0x3a21, 0x243d4e },
	{ 0x3a22, 0x23413c },
	{ 0x3a23, 0x23414a },
	{ 0x3a24, 0x234143 },
	{ 0x3a25, 0x23413f },
	{ 0x3a26, 0x234147 },
	{ 0x3a27, 0x234140 },
	{ 0x3a28, 0x234146 },
	{ 0x3a29, 0x234141 },
	{ 0x3a2a, 0x234139 },
	{ 0x3a2d, 0x244358 },
	{ 0x3a2e, 0x244361 },
	{ 0x3a2f, 0x265d32 },
	{ 0x3a30, 0x234679 },
	{ 0x3a31, 0x23472e },
	{ 0x3a32, 0x23472d },
	{ 0x3a33, 0x244356 },
	{ 0x3a34, 0x23467c },
	{ 0x3a35, 0x234727 },
	{ 0x3a36, 0x23472f },
	{ 0x3a37, 0x24435c },
	{ 0x3a38, 0x234677 },
	{ 0x3a39, 0x254625 },
	{ 0x3a3a, 0x23467d },
	{ 0x3a3b, 0x244975 },
	{ 0x3a3c, 0x234c36 },
	{ 0x3a3d, 0x244364 },
	{ 0x3a3e, 0x254623 },
	{ 0x3a3f, 0x23472b },
	{ 0x3a40, 0x23472c },
	{ 0x3a43, 0x244a24 },
	{ 0x3a44, 0x234c33 },
	{ 0x3a45, 0x27233a },
	{ 0x3a46, 0x244979 },
	{ 0x3a47, 0x24497a },
	{ 0x3a48, 0x244976 },
	{ 0x3a49, 0x244a28 },
	{ 0x3a4a, 0x244a22 },
	{ 0x3a4b, 0x254d3a },
	{ 0x3a4c, 0x24497e },
	{ 0x3a4d, 0x254d3e },
	{ 0x3a4e, 0x234c3c },
	{ 0x3a50, 0x244a23 },
	{ 0x3a52, 0x235074 },
	{ 0x3a53, 0x245639 },
	{ 0x3a54, 0x245045 },
	{ 0x3a55, 0x235073 },
	{ 0x3a56, 0x23506e },
	{ 0x3a57, 0x235078 },
	{ 0x3a58, 0x235072 },
	{ 0x3a59, 0x235071 },
	{ 0x3a5a, 0x235465 },
	{ 0x3a5b, 0x23546a },
	{ 0x3a5c, 0x235468 },
	{ 0x3a5d, 0x235463 },
	{ 0x3a5e, 0x235466 },
	{ 0x3a60, 0x245b2d },
	{ 0x3a61, 0x235769 },
	{ 0x3a62, 0x245b32 },
	{ 0x3a63, 0x245b30 },
	{ 0x3a64, 0x245b2e },
	{ 0x3a65, 0x23576f },
	{ 0x3a66, 0x235771 },
	{ 0x3a67, 0x245b31 },
	{ 0x3a68, 0x235768 },
	{ 0x3a69, 0x245b2f },
	{ 0x3a6a, 0x235772 },
	{ 0x3a6b, 0x2f5e73 },
	{ 0x3a6c, 0x235a3d },
	{ 0x3a6d, 0x235a3e },
	{ 0x3a6f, 0x246347 },
	{ 0x3a70, 0x235c40 },
	{ 0x3a71, 0x246346 },
	{ 0x3a72, 0x257024 },
	{ 0x3a73, 0x235e32 },
	{ 0x3a74, 0x246640 },
	{ 0x3a75, 0x236031 },
	{ 0x3a76, 0x246a49 },
	{ 0x3a77, 0x246a48 },
	{ 0x3a79, 0x25792a },
	{ 0x3a7a, 0x24265b },
	{ 0x3a7b, 0x242d40 },
	{ 0x3a7c, 0x242d3f },
	{ 0x3a7d, 0x243227 },
	{ 0x3a7e, 0x243d54 },
	{ 0x3a7f, 0x242440 },
	{ 0x3a80, 0x23263a },
	{ 0x3a81, 0x24265e },
	{ 0x3a82, 0x24265f },
	{ 0x3a84, 0x24295d },
	{ 0x3a85, 0x232c75 },
	{ 0x3a87, 0x23313e },
	{ 0x3a88, 0x242d42 },
	{ 0x3a89, 0x26382b },
	{ 0x3a8b, 0x233633 },
	{ 0x3a8c, 0x243228 },
	{ 0x3a8d, 0x233635 },
	{ 0x3a8e, 0x24322c },
	{ 0x3a8f, 0x243779 },
	{ 0x3a91, 0x243775 },
	{ 0x3a92, 0x243778 },
	{ 0x3a93, 0x243777 },
	{ 0x3a95, 0x243776 },
	{ 0x3a96, 0x25387c },
	{ 0x3a9a, 0x233b77 },
	{ 0x3a9c, 0x243d5c },
	{ 0x3a9d, 0x243d59 },
	{ 0x3a9e, 0x243d5b },
	{ 0x3a9f, 0x23414c },
	{ 0x3aa0, 0x244366 },
	{ 0x3aa1, 0x254630 },
	{ 0x3aa2, 0x25462e },
	{ 0x3aa3, 0x244369 },
	{ 0x3aa4, 0x244a2b },
	{ 0x3aa5, 0x244a2a },
	{ 0x3aa6, 0x244a29 },
	{ 0x3aa8, 0x245049 },
	{ 0x3aa9, 0x24504c },
	{ 0x3aab, 0x235773 },
	{ 0x3aac, 0x245b3a },
	{ 0x3aad, 0x24634c },
	{ 0x3aae, 0x246643 },
	{ 0x3aaf, 0x23263b },
	{ 0x3ab0, 0x26382c },
	{ 0x3ab1, 0x23414f },
	{ 0x3ab4, 0x23293a },
	{ 0x3ab5, 0x242961 },
	{ 0x3ab6, 0x233141 },
	{ 0x3ab7, 0x23392b },
	{ 0x3ab8, 0x233b78 },
	{ 0x3ab9, 0x244a2e },
	{ 0x3aba, 0x24563e },
	{ 0x3abb, 0x246a4b },
	{ 0x3abc, 0x242962 },
	{ 0x3abe, 0x242d49 },
	{ 0x3abf, 0x263830 },
	{ 0x3ac0, 0x264961 },
	{ 0x3ac1, 0x265d51 },
	{ 0x3ac2, 0x254d4b },
	{ 0x3ac3, 0x232371 },
	{ 0x3ac4, 0x262b70 },
	{ 0x3ac5, 0x263834 },
	{ 0x3aca, 0x23363b },
	{ 0x3acb, 0x23363e },
	{ 0x3acd, 0x243d65 },
	{ 0x3ace, 0x244a30 },
	{ 0x3acf, 0x244a31 },
	{ 0x3ad0, 0x242278 },
	{ 0x3ad1, 0x242279 },
	{ 0x3ad2, 0x242443 },
	{ 0x3ad3, 0x23263c },
	{ 0x3ad4, 0x23263f },
	{ 0x3ad5, 0x23263e },
	{ 0x3ad7, 0x232640 },
	{ 0x3ad8, 0x23293f },
	{ 0x3ad9, 0x23293d },
	{ 0x3ada, 0x242663 },
	{ 0x3adb, 0x25294f },
	{ 0x3adc, 0x242963 },
	{ 0x3add, 0x232c7b },
	{ 0x3ade, 0x242964 },
	{ 0x3adf, 0x242965 },
	{ 0x3ae0, 0x232c78 },
	{ 0x3ae1, 0x232d26 },
	{ 0x3ae4, 0x263167 },
	{ 0x3ae5, 0x242d4c },
	{ 0x3ae6, 0x24323b },
	{ 0x3ae7, 0x242d4b },
	{ 0x3ae9, 0x233147 },
	{ 0x3aea, 0x263837 },
	{ 0x3aeb, 0x23314a },
	{ 0x3aec, 0x2f2f6e },
	{ 0x3aee, 0x242d4d },
	{ 0x3aef, 0x264051 },
	{ 0x3af0, 0x243236 },
	{ 0x3af1, 0x24323a },
	{ 0x3af2, 0x243237 },
	{ 0x3af3, 0x233643 },
	{ 0x3af4, 0x26404f },
	{ 0x3af5, 0x233c22 },
	{ 0x3af6, 0x24377e },
	{ 0x3af7, 0x233b7a },
	{ 0x3af8, 0x233b7b },
	{ 0x3af9, 0x243825 },
	{ 0x3afa, 0x233c27 },
	{ 0x3afb, 0x243822 },
	{ 0x3afc, 0x264973 },
	{ 0x3afd, 0x233c21 },
	{ 0x3b01, 0x26533d },
	{ 0x3b02, 0x253f62 },
	{ 0x3b03, 0x234152 },
	{ 0x3b04, 0x234157 },
	{ 0x3b05, 0x23415a },
	{ 0x3b06, 0x234155 },
	{ 0x3b07, 0x234153 },
	{ 0x3b08, 0x23415c },
	{ 0x3b09, 0x234158 },
	{ 0x3b0a, 0x243d68 },
	{ 0x3b0b, 0x243d67 },
	{ 0x3b0c, 0x234154 },
	{ 0x3b0d, 0x234738 },
	{ 0x3b0e, 0x24436e },
	{ 0x3b0f, 0x234732 },
	{ 0x3b10, 0x234736 },
	{ 0x3b12, 0x254d53 },
	{ 0x3b13, 0x244a32 },
	{ 0x3b14, 0x234c42 },
	{ 0x3b15, 0x234c45 },
	{ 0x3b17, 0x245052 },
	{ 0x3b18, 0x245051 },
	{ 0x3b19, 0x235121 },
	{ 0x3b1a, 0x254d50 },
	{ 0x3b1b, 0x23507b },
	{ 0x3b1c, 0x23507c },
	{ 0x3b1d, 0x245053 },
	{ 0x3b1e, 0x272e5a },
	{ 0x3b20, 0x235473 },
	{ 0x3b21, 0x23546e },
	{ 0x3b22, 0x245640 },
	{ 0x3b23, 0x245b40 },
	{ 0x3b25, 0x245b41 },
	{ 0x3b26, 0x245b3f },
	{ 0x3b27, 0x273f76 },
	{ 0x3b29, 0x235a40 },
	{ 0x3b2a, 0x235a41 },
	{ 0x3b2b, 0x235c44 },
	{ 0x3b2c, 0x235f4c },
	{ 0x3b2d, 0x235f4d },
	{ 0x3b2e, 0x25756e },
	{ 0x3b2f, 0x25756d },
	{ 0x3b30, 0x232374 },
	{ 0x3b31, 0x245056 },
	{ 0x3b32, 0x235474 },
	{ 0x3b33, 0x232944 },
	{ 0x3b34, 0x23314e },
	{ 0x3b35, 0x252e25 },
	{ 0x3b36, 0x233649 },
	{ 0x3b38, 0x233c28 },
	{ 0x3b39, 0x243a43 },
	{ 0x3b3b, 0x254645 },
	{ 0x3b3c, 0x254d58 },
	{ 0x3b3f, 0x235125 },
	{ 0x3b41, 0x232376 },
	{ 0x3b42, 0x232643 },
	{ 0x3b43, 0x242448 },
	{ 0x3b44, 0x232646 },
	{ 0x3b47, 0x23294b },
	{ 0x3b48, 0x232946 },
	{ 0x3b49, 0x2f274c },
	{ 0x3b4a, 0x232950 },
	{ 0x3b4b, 0x23294d },
	{ 0x3b4c, 0x252651 },
	{ 0x3b51, 0x232d28 },
	{ 0x3b52, 0x232d2c },
	{ 0x3b53, 0x24296f },
	{ 0x3b54, 0x24296c },
	{ 0x3b55, 0x232d29 },
	{ 0x3b58, 0x242d57 },
	{ 0x3b59, 0x242d51 },
	{ 0x3b5a, 0x242d54 },
	{ 0x3b5b, 0x242d58 },
	{ 0x3b5c, 0x233152 },
	{ 0x3b5d, 0x252e2b },
	{ 0x3b5e, 0x242d52 },
	{ 0x3b5f, 0x242d5b },
	{ 0x3b60, 0x233155 },
	{ 0x3b61, 0x242d56 },
	{ 0x3b62, 0x233151 },
	{ 0x3b68, 0x233659 },
	{ 0x3b69, 0x243243 },
	{ 0x3b6a, 0x23364a },
	{ 0x3b6b, 0x23364f },
	{ 0x3b6c, 0x253279 },
	{ 0x3b6d, 0x243242 },
	{ 0x3b6e, 0x243246 },
	{ 0x3b6f, 0x243241 },
	{ 0x3b70, 0x243834 },
	{ 0x3b71, 0x233658 },
	{ 0x3b72, 0x23365d },
	{ 0x3b78, 0x24382f },
	{ 0x3b79, 0x233c2e },
	{ 0x3b7a, 0x24382c },
	{ 0x3b7b, 0x233c3f },
	{ 0x3b7c, 0x233c30 },
	{ 0x3b7d, 0x24382a },
	{ 0x3b7e, 0x253933 },
	{ 0x3b7f, 0x24382d },
	{ 0x3b80, 0x233c2c },
	{ 0x3b81, 0x253939 },
	{ 0x3b82, 0x243835 },
	{ 0x3b83, 0x233c35 },
	{ 0x3b84, 0x243837 },
	{ 0x3b85, 0x233c36 },
	{ 0x3b86, 0x233c43 },
	{ 0x3b87, 0x233c2b },
	{ 0x3b88, 0x233c2d },
	{ 0x3b8b, 0x243d78 },
	{ 0x3b8c, 0x234171 },
	{ 0x3b8d, 0x234166 },
	{ 0x3b8e, 0x234170 },
	{ 0x3b8f, 0x243d6b },
	{ 0x3b90, 0x243d6e },
	{ 0x3b91, 0x243d6f },
	{ 0x3b92, 0x23416c },
	{ 0x3b93, 0x234169 },
	{ 0x3b94, 0x234164 },
	{ 0x3b95, 0x243d6d },
	{ 0x3b96, 0x23415e },
	{ 0x3b97, 0x243d75 },
	{ 0x3b98, 0x234162 },
	{ 0x3b99, 0x234163 },
	{ 0x3b9a, 0x23417a },
	{ 0x3b9b, 0x234161 },
	{ 0x3b9c, 0x23415f },
	{ 0x3b9d, 0x244423 },
	{ 0x3b9e, 0x243d76 },
	{ 0x3b9f, 0x234160 },
	{ 0x3ba1, 0x23425a },
	{ 0x3ba3, 0x234167 },
	{ 0x3ba4, 0x2f4855 },
	{ 0x3ba5, 0x244424 },
	{ 0x3ba6, 0x244375 },
	{ 0x3ba7, 0x244421 },
	{ 0x3ba8, 0x24437c },
	{ 0x3ba9, 0x23473f },
	{ 0x3baa, 0x244378 },
	{ 0x3bab, 0x244373 },
	{ 0x3bac, 0x234741 },
	{ 0x3bad, 0x244374 },
	{ 0x3bae, 0x23474a },
	{ 0x3baf, 0x24437d },
	{ 0x3bb0, 0x24437e },
	{ 0x3bb1, 0x24437a },
	{ 0x3bb2, 0x244422 },
	{ 0x3bb3, 0x23474f },
	{ 0x3bb4, 0x234740 },
	{ 0x3bb5, 0x244425 },
	{ 0x3bb6, 0x244371 },
	{ 0x3bb7, 0x25464b },
	{ 0x3bb8, 0x234749 },
	{ 0x3bb9, 0x243d72 },
	{ 0x3bba, 0x234750 },
	{ 0x3bbc, 0x2f4852 },
	{ 0x3bbf, 0x234c4e },
	{ 0x3bc0, 0x254d6d },
	{ 0x3bc1, 0x244a3a },
	{ 0x3bc2, 0x234c4c },
	{ 0x3bc3, 0x254d61 },
	{ 0x3bc4, 0x234c53 },
	{ 0x3bc5, 0x244a37 },
	{ 0x3bc6, 0x244a36 },
	{ 0x3bc7, 0x234c5d },
	{ 0x3bc8, 0x234c58 },
	{ 0x3bc9, 0x27236f },
	{ 0x3bca, 0x244a38 },
	{ 0x3bcb, 0x244a42 },
	{ 0x3bcc, 0x234c5a },
	{ 0x3bcd, 0x234c5c },
	{ 0x3bce, 0x234c48 },
	{ 0x3bcf, 0x234c55 },
	{ 0x3bd0, 0x235143 },
	{ 0x3bd3, 0x235142 },
	{ 0x3bd4, 0x245060 },
	{ 0x3bd5, 0x24505a },
	{ 0x3bd6, 0x235137 },
	{ 0x3bd7, 0x235130 },
	{ 0x3bd8, 0x245059 },
	{ 0x3bd9, 0x244a39 },
	{ 0x3bda, 0x23513f },
	{ 0x3bdb, 0x23512a },
	{ 0x3bdc, 0x23513d },
	{ 0x3bdd, 0x245649 },
	{ 0x3bde, 0x235133 },
	{ 0x3bdf, 0x235139 },
	{ 0x3be0, 0x234c4b },
	{ 0x3be1, 0x24505e },
	{ 0x3be2, 0x23512d },
	{ 0x3be3, 0x245064 },
	{ 0x3be4, 0x235135 },
	{ 0x3be5, 0x235134 },
	{ 0x3be6, 0x235136 },
	{ 0x3bea, 0x235522 },
	{ 0x3beb, 0x245648 },
	{ 0x3bec, 0x23547e },
	{ 0x3bed, 0x235525 },
	{ 0x3bee, 0x23547d },
	{ 0x3bef, 0x24564b },
	{ 0x3bf0, 0x273855 },
	{ 0x3bf1, 0x255b68 },
	{ 0x3bf2, 0x235477 },
	{ 0x3bf3, 0x235526 },
	{ 0x3bf4, 0x2f5f29 },
	{ 0x3bf5, 0x235479 },
	{ 0x3bf6, 0x235528 },
	{ 0x3bf7, 0x245b48 },
	{ 0x3bf8, 0x245b44 },
	{ 0x3bf9, 0x23577c },
	{ 0x3bfa, 0x245b4a },
	{ 0x3bfb, 0x245b49 },
	{ 0x3bfe, 0x245f6f },
	{ 0x3bff, 0x245f73 },
	{ 0x3c00, 0x235a49 },
	{ 0x3c01, 0x245f70 },
	{ 0x3c02, 0x245f6e },
	{ 0x3c03, 0x245f72 },
	{ 0x3c04, 0x245f75 },
	{ 0x3c05, 0x235a4c },
	{ 0x3c06, 0x235a4b },
	{ 0x3c07, 0x2f6253 },
	{ 0x3c08, 0x235a4a },
	{ 0x3c09, 0x235c4c },
	{ 0x3c0a, 0x235c46 },
	{ 0x3c0b, 0x246351 },
	{ 0x3c0c, 0x24634f },
	{ 0x3c0d, 0x235c48 },
	{ 0x3c0e, 0x235c4d },
	{ 0x3c0f, 0x246354 },
	{ 0x3c10, 0x235c4b },
	{ 0x3c11, 0x235c45 },
	{ 0x3c12, 0x2f653e },
	{ 0x3c14, 0x257027 },
	{ 0x3c15, 0x235e36 },
	{ 0x3c16, 0x235c4a },
	{ 0x3c17, 0x235f50 },
	{ 0x3c18, 0x24686e },
	{ 0x3c19, 0x236035 },
	{ 0x3c1a, 0x236033 },
	{ 0x3c1b, 0x236034 },
	{ 0x3c1d, 0x252448 },
	{ 0x3c1e, 0x262830 },
	{ 0x3c1f, 0x24266d },
	{ 0x3c20, 0x252656 },
	{ 0x3c21, 0x242670 },
	{ 0x3c22, 0x24266c },
	{ 0x3c23, 0x242d60 },
	{ 0x3c24, 0x242970 },
	{ 0x3c25, 0x242971 },
	{ 0x3c26, 0x263178 },
	{ 0x3c27, 0x242974 },
	{ 0x3c28, 0x242973 },
	{ 0x3c29, 0x252e2e },
	{ 0x3c2a, 0x242d5d },
	{ 0x3c2b, 0x242d61 },
	{ 0x3c2c, 0x242d62 },
	{ 0x3c2d, 0x242d5e },
	{ 0x3c2e, 0x233661 },
	{ 0x3c2f, 0x243248 },
	{ 0x3c30, 0x243249 },
	{ 0x3c31, 0x26406e },
	{ 0x3c32, 0x24383b },
	{ 0x3c33, 0x243839 },
	{ 0x3c34, 0x233c46 },
	{ 0x3c35, 0x253943 },
	{ 0x3c36, 0x24383c },
	{ 0x3c37, 0x263864 },
	{ 0x3c39, 0x243e21 },
	{ 0x3c3a, 0x243d7c },
	{ 0x3c3b, 0x243d7b },
	{ 0x3c3c, 0x243d7d },
	{ 0x3c3d, 0x243d7e },
	{ 0x3c3e, 0x243e22 },
	{ 0x3c3f, 0x234752 },
	{ 0x3c40, 0x265d77 },
	{ 0x3c41, 0x24442a },
	{ 0x3c42, 0x244a4c },
	{ 0x3c43, 0x234c68 },
	{ 0x3c44, 0x245066 },
	{ 0x3c45, 0x245067 },
	{ 0x3c46, 0x24564f },
	{ 0x3c47, 0x24564e },
	{ 0x3c48, 0x23552a },
	{ 0x3c49, 0x23552c },
	{ 0x3c4a, 0x245f77 },
	{ 0x3c4b, 0x274e22 },
	{ 0x3c4c, 0x246871 },
	{ 0x3c4d, 0x257577 },
	{ 0x3c4e, 0x25792f },
	{ 0x3c4f, 0x262525 },
	{ 0x3c52, 0x232d3e },
	{ 0x3c54, 0x232b7b },
	{ 0x3c55, 0x233c48 },
	{ 0x3c56, 0x24383f },
	{ 0x3c57, 0x25465f },
	{ 0x3c58, 0x235824 },
	{ 0x3c59, 0x24227c },
	{ 0x3c5a, 0x232957 },
	{ 0x3c5b, 0x252662 },
	{ 0x3c5c, 0x242675 },
	{ 0x3c5e, 0x232d3f },
	{ 0x3c5f, 0x232d41 },
	{ 0x3c60, 0x232d40 },
	{ 0x3c61, 0x233169 },
	{ 0x3c62, 0x233663 },
	{ 0x3c63, 0x24324a },
	{ 0x3c64, 0x243845 },
	{ 0x3c65, 0x243844 },
	{ 0x3c66, 0x243846 },
	{ 0x3c67, 0x243842 },
	{ 0x3c68, 0x233c4a },
	{ 0x3c6a, 0x234223 },
	{ 0x3c6b, 0x243e23 },
	{ 0x3c6c, 0x243e24 },
	{ 0x3c6d, 0x234224 },
	{ 0x3c6f, 0x244432 },
	{ 0x3c70, 0x254660 },
	{ 0x3c71, 0x244433 },
	{ 0x3c72, 0x244430 },
	{ 0x3c73, 0x244a50 },
	{ 0x3c74, 0x244a4f },
	{ 0x3c75, 0x24506b },
	{ 0x3c76, 0x24506a },
	{ 0x3c78, 0x245651 },
	{ 0x3c79, 0x246355 },
	{ 0x3c7a, 0x235c4e },
	{ 0x3c7b, 0x257578 },
	{ 0x3c7c, 0x25244e },
	{ 0x3c7d, 0x242678 },
	{ 0x3c7e, 0x242d64 },
	{ 0x3c7f, 0x23316b },
	{ 0x3c80, 0x24324f },
	{ 0x3c81, 0x243849 },
	{ 0x3c82, 0x24384a },
	{ 0x3c83, 0x24384b },
	{ 0x3c84, 0x234225 },
	{ 0x3c85, 0x244435 },
	{ 0x3c86, 0x235147 },
	{ 0x3c87, 0x235148 },
	{ 0x3c88, 0x24506e },
	{ 0x3c89, 0x245653 },
	{ 0x3c8a, 0x235825 },
	{ 0x3c8b, 0x24297b },
	{ 0x3c8c, 0x23237b },
	{ 0x3c8d, 0x242679 },
	{ 0x3c8e, 0x23295b },
	{ 0x3c8f, 0x24267a },
	{ 0x3c91, 0x2f275b },
	{ 0x3c92, 0x232d43 },
	{ 0x3c93, 0x242d66 },
	{ 0x3c94, 0x243252 },
	{ 0x3c95, 0x243254 },
	{ 0x3c96, 0x243253 },
	{ 0x3c97, 0x243255 },
	{ 0x3c98, 0x233667 },
	{ 0x3c99, 0x242d67 },
	{ 0x3c9a, 0x243251 },
	{ 0x3c9b, 0x25395b },
	{ 0x3c9c, 0x233c4c },
	{ 0x3c9d, 0x24384f },
	{ 0x3c9e, 0x24384c },
	{ 0x3c9f, 0x243e29 },
	{ 0x3ca0, 0x234227 },
	{ 0x3ca1, 0x243e28 },
	{ 0x3ca2, 0x243e27 },
	{ 0x3ca3, 0x24443f },
	{ 0x3ca4, 0x244438 },
	{ 0x3ca5, 0x244439 },
	{ 0x3ca6, 0x24443a },
	{ 0x3ca7, 0x254668 },
	{ 0x3ca8, 0x24443c },
	{ 0x3caa, 0x24506f },
	{ 0x3cab, 0x245071 },
	{ 0x3cac, 0x245072 },
	{ 0x3cad, 0x235149 },
	{ 0x3caf, 0x245b50 },
	{ 0x3cb0, 0x245b4f },
	{ 0x3cb1, 0x235a50 },
	{ 0x3cb2, 0x246d57 },
	{ 0x3cb3, 0x242d6a },
	{ 0x3cb4, 0x23295c },
	{ 0x3cb5, 0x233668 },
	{ 0x3cb6, 0x234c69 },
	{ 0x3cb7, 0x23514a },
	{ 0x3cb8, 0x24214f },
	{ 0x3cb9, 0x232256 },
	{ 0x3cba, 0x232255 },
	{ 0x3cbb, 0x232422 },
	{ 0x3cbc, 0x252174 },
	{ 0x3cbd, 0x242322 },
	{ 0x3cbe, 0x232654 },
	{ 0x3cc0, 0x23264f },
	{ 0x3cc1, 0x24244f },
	{ 0x3cc2, 0x23265d },
	{ 0x3cc3, 0x262849 },
	{ 0x3cc4, 0x23265a },
	{ 0x3cc5, 0x242451 },
	{ 0x3cc6, 0x23264b },
	{ 0x3cc7, 0x26284a },
	{ 0x3cc8, 0x262844 },
	{ 0x3cca, 0x232658 },
	{ 0x3ccb, 0x232961 },
	{ 0x3ccc, 0x23295f },
	{ 0x3ccd, 0x23295e },
	{ 0x3cce, 0x232962 },
	{ 0x3ccf, 0x232960 },
	{ 0x3cd0, 0x24267e },
	{ 0x3cd1, 0x232968 },
	{ 0x3cd2, 0x232966 },
	{ 0x3cd3, 0x2f2766 },
	{ 0x3cd6, 0x232d44 },
	{ 0x3cd7, 0x252a24 },
	{ 0x3cd8, 0x242722 },
	{ 0x3cd9, 0x232d54 },
	{ 0x3cda, 0x25297b },
	{ 0x3cdb, 0x25297c },
	{ 0x3cdc, 0x24297e },
	{ 0x3cdd, 0x232d56 },
	{ 0x3cde, 0x232d4c },
	{ 0x3cdf, 0x2f3049 },
	{ 0x3ce4, 0x263872 },
	{ 0x3ce5, 0x233170 },
	{ 0x3ce6, 0x233171 },
	{ 0x3ce7, 0x242d6b },
	{ 0x3ce8, 0x263933 },
	{ 0x3ce9, 0x233174 },
	{ 0x3cea, 0x242d6c },
	{ 0x3ceb, 0x233669 },
	{ 0x3cec, 0x233224 },
	{ 0x3ced, 0x233223 },
	{ 0x3cee, 0x23317e },
	{ 0x3cf3, 0x233175 },
	{ 0x3cf4, 0x243257 },
	{ 0x3cf5, 0x233671 },
	{ 0x3cf6, 0x243263 },
	{ 0x3cf7, 0x243264 },
	{ 0x3cf8, 0x23366e },
	{ 0x3cf9, 0x24325e },
	{ 0x3cfa, 0x233722 },
	{ 0x3cfb, 0x23366d },
	{ 0x3cfc, 0x233c4f },
	{ 0x3cfd, 0x23367e },
	{ 0x3cfe, 0x243258 },
	{ 0x3cff, 0x243268 },
	{ 0x3d00, 0x25395e },
	{ 0x3d01, 0x24325a },
	{ 0x3d02, 0x24325c },
	{ 0x3d03, 0x26412b },
	{ 0x3d04, 0x25333d },
	{ 0x3d05, 0x233c5e },
	{ 0x3d06, 0x23367b },
	{ 0x3d07, 0x233c5f },
	{ 0x3d08, 0x233673 },
	{ 0x3d09, 0x264141 },
	{ 0x3d0a, 0x233678 },
	{ 0x3d0e, 0x2f3633 },
	{ 0x3d0f, 0x243851 },
	{ 0x3d10, 0x243856 },
	{ 0x3d11, 0x233c65 },
	{ 0x3d12, 0x243852 },
	{ 0x3d13, 0x233c59 },
	{ 0x3d14, 0x243859 },
	{ 0x3d15, 0x233c6a },
	{ 0x3d16, 0x233c67 },
	{ 0x3d17, 0x233c55 },
	{ 0x3d18, 0x243857 },
	{ 0x3d19, 0x24385a },
	{ 0x3d1a, 0x233c53 },
	{ 0x3d1b, 0x233c57 },
	{ 0x3d1c, 0x233c61 },
	{ 0x3d1d, 0x23422b },
	{ 0x3d1e, 0x264a6d },
	{ 0x3d20, 0x2f3c43 },
	{ 0x3d21, 0x2f3c5a },
	{ 0x3d25, 0x243e37 },
	{ 0x3d26, 0x23422c },
	{ 0x3d27, 0x234237 },
	{ 0x3d28, 0x234235 },
	{ 0x3d29, 0x234248 },
	{ 0x3d2a, 0x234238 },
	{ 0x3d2b, 0x243e30 },
	{ 0x3d2c, 0x243e39 },
	{ 0x3d2d, 0x243e2d },
	{ 0x3d2e, 0x234242 },
	{ 0x3d2f, 0x243e38 },
	{ 0x3d30, 0x234234 },
	{ 0x3d31, 0x23423c },
	{ 0x3d32, 0x243e3c },
	{ 0x3d33, 0x23422f },
	{ 0x3d34, 0x234241 },
	{ 0x3d35, 0x254027 },
	{ 0x3d36, 0x243e2f },
	{ 0x3d37, 0x243e32 },
	{ 0x3d38, 0x234232 },
	{ 0x3d3b, 0x234243 },
	{ 0x3d3c, 0x234755 },
	{ 0x3d3d, 0x244449 },
	{ 0x3d3e, 0x234760 },
	{ 0x3d3f, 0x265e3b },
	{ 0x3d40, 0x234759 },
	{ 0x3d41, 0x265450 },
	{ 0x3d42, 0x234758 },
	{ 0x3d43, 0x244446 },
	{ 0x3d44, 0x24444d },
	{ 0x3d45, 0x24444a },
	{ 0x3d46, 0x265e40 },
	{ 0x3d4a, 0x234c6e },
	{ 0x3d4b, 0x244a5f },
	{ 0x3d4c, 0x244a61 },
	{ 0x3d4d, 0x234c6f },
	{ 0x3d4e, 0x234c7c },
	{ 0x3d4f, 0x244a68 },
	{ 0x3d50, 0x244a5d },
	{ 0x3d51, 0x234c6d },
	{ 0x3d52, 0x244a59 },
	{ 0x3d53, 0x234c72 },
	{ 0x3d54, 0x254678 },
	{ 0x3d55, 0x272461 },
	{ 0x3d56, 0x234c70 },
	{ 0x3d57, 0x245074 },
	{ 0x3d58, 0x23514b },
	{ 0x3d59, 0x234c76 },
	{ 0x3d5d, 0x245077 },
	{ 0x3d5e, 0x24507d },
	{ 0x3d5f, 0x255536 },
	{ 0x3d60, 0x245076 },
	{ 0x3d61, 0x23514f },
	{ 0x3d62, 0x23514e },
	{ 0x3d63, 0x24507a },
	{ 0x3d64, 0x25552d },
	{ 0x3d65, 0x235153 },
	{ 0x3d66, 0x235157 },
	{ 0x3d67, 0x24507b },
	{ 0x3d68, 0x245656 },
	{ 0x3d69, 0x235151 },
	{ 0x3d6a, 0x23514c },
	{ 0x3d6b, 0x245078 },
	{ 0x3d6c, 0x235152 },
	{ 0x3d6d, 0x244a62 },
	{ 0x3d6e, 0x25552e },
	{ 0x3d6f, 0x235532 },
	{ 0x3d70, 0x235538 },
	{ 0x3d71, 0x24565e },
	{ 0x3d72, 0x245660 },
	{ 0x3d73, 0x235534 },
	{ 0x3d74, 0x245658 },
	{ 0x3d75, 0x23552e },
	{ 0x3d76, 0x245657 },
	{ 0x3d77, 0x24565c },
	{ 0x3d78, 0x23553b },
	{ 0x3d79, 0x245659 },
	{ 0x3d7a, 0x24565b },
	{ 0x3d7b, 0x235533 },
	{ 0x3d7d, 0x245b56 },
	{ 0x3d7e, 0x245b54 },
	{ 0x3d7f, 0x245b5a },
	{ 0x3d80, 0x245b57 },
	{ 0x3d81, 0x245b60 },
	{ 0x3d84, 0x245f7b },
	{ 0x3d85, 0x245f7d },
	{ 0x3d86, 0x245b5b },
	{ 0x3d87, 0x245f79 },
	{ 0x3d88, 0x235a51 },
	{ 0x3d8c, 0x235c50 },
	{ 0x3d8d, 0x24635a },
	{ 0x3d8e, 0x24635e },
	{ 0x3d8f, 0x24635b },
	{ 0x3d91, 0x235c52 },
	{ 0x3d92, 0x246649 },
	{ 0x3d93, 0x25703e },
	{ 0x3d94, 0x24664a },
	{ 0x3d95, 0x24664c },
	{ 0x3d96, 0x246873 },
	{ 0x3d97, 0x235e39 },
	{ 0x3d98, 0x235e38 },
	{ 0x3d9a, 0x235f51 },
	{ 0x3d9b, 0x246a4e },
	{ 0x3d9c, 0x236038 },
	{ 0x3d9e, 0x246b6d },
	{ 0x3d9f, 0x246b6e },
	{ 0x3da0, 0x236166 },
	{ 0x3da1, 0x23242a },
	{ 0x3da3, 0x242452 },
	{ 0x3da4, 0x232661 },
	{ 0x3da5, 0x2f246e },
	{ 0x3da6, 0x23296e },
	{ 0x3da7, 0x242727 },
	{ 0x3da8, 0x232978 },
	{ 0x3da9, 0x2f276e },
	{ 0x3daa, 0x232973 },
	{ 0x3dab, 0x232d67 },
	{ 0x3dac, 0x232d59 },
	{ 0x3dad, 0x232d66 },
	{ 0x3dae, 0x232d61 },
	{ 0x3daf, 0x232d60 },
	{ 0x3db0, 0x232d5b },
	{ 0x3db2, 0x242a27 },
	{ 0x3db3, 0x23322e },
	{ 0x3db4, 0x242d73 },
	{ 0x3db5, 0x233232 },
	{ 0x3db9, 0x23372b },
	{ 0x3dba, 0x23372a },
	{ 0x3dbb, 0x233734 },
	{ 0x3dbc, 0x243271 },
	{ 0x3dbe, 0x243276 },
	{ 0x3dbf, 0x243270 },
	{ 0x3dc0, 0x243277 },
	{ 0x3dc1, 0x2f3648 },
	{ 0x3dc2, 0x233c76 },
	{ 0x3dc3, 0x243865 },
	{ 0x3dc4, 0x243861 },
	{ 0x3dc5, 0x233c75 },
	{ 0x3dc6, 0x243862 },
	{ 0x3dc7, 0x243864 },
	{ 0x3dc8, 0x243860 },
	{ 0x3dc9, 0x233b23 },
	{ 0x3dca, 0x233c7e },
	{ 0x3dcb, 0x233c70 },
	{ 0x3dcd, 0x233c78 },
	{ 0x3dce, 0x234254 },
	{ 0x3dcf, 0x23424d },
	{ 0x3dd0, 0x234256 },
	{ 0x3dd1, 0x243e4b },
	{ 0x3dd2, 0x23424a },
	{ 0x3dd3, 0x234255 },
	{ 0x3dd4, 0x243e48 },
	{ 0x3dd5, 0x243e46 },
	{ 0x3dd6, 0x243e49 },
	{ 0x3dd7, 0x265454 },
	{ 0x3dd8, 0x23424b },
	{ 0x3dd9, 0x234250 },
	{ 0x3dda, 0x2f4278 },
	{ 0x3ddb, 0x2f433c },
	{ 0x3ddf, 0x244459 },
	{ 0x3de0, 0x234773 },
	{ 0x3de1, 0x234769 },
	{ 0x3de2, 0x265467 },
	{ 0x3de3, 0x244456 },
	{ 0x3de4, 0x24445a },
	{ 0x3de5, 0x24445c },
	{ 0x3de6, 0x234771 },
	{ 0x3de8, 0x2f4958 },
	{ 0x3deb, 0x234d26 },
	{ 0x3dec, 0x234d23 },
	{ 0x3ded, 0x234d2b },
	{ 0x3dee, 0x234d21 },
	{ 0x3def, 0x234d27 },
	{ 0x3df0, 0x244a6a },
	{ 0x3df3, 0x245125 },
	{ 0x3df4, 0x23515d },
	{ 0x3df5, 0x23515b },
	{ 0x3df6, 0x24512b },
	{ 0x3df7, 0x23515f },
	{ 0x3df8, 0x235161 },
	{ 0x3df9, 0x245124 },
	{ 0x3dfb, 0x235164 },
	{ 0x3dfc, 0x235165 },
	{ 0x3dfe, 0x23553d },
	{ 0x3dff, 0x245662 },
	{ 0x3e00, 0x23553f },
	{ 0x3e01, 0x235544 },
	{ 0x3e02, 0x273926 },
	{ 0x3e03, 0x235751 },
	{ 0x3e04, 0x23582c },
	{ 0x3e05, 0x245664 },
	{ 0x3e08, 0x235c5a },
	{ 0x3e09, 0x235a59 },
	{ 0x3e0a, 0x235c54 },
	{ 0x3e0b, 0x235c5b },
	{ 0x3e0c, 0x24635f },
	{ 0x3e0d, 0x24664e },
	{ 0x3e0e, 0x257357 },
	{ 0x3e0f, 0x246a50 },
	{ 0x3e10, 0x23603a },
	{ 0x3e11, 0x23617a },
	{ 0x3e12, 0x24272c },
	{ 0x3e13, 0x23297a },
	{ 0x3e14, 0x233758 },
	{ 0x3e15, 0x234774 },
	{ 0x3e16, 0x232d6a },
	{ 0x3e17, 0x242d76 },
	{ 0x3e18, 0x233736 },
	{ 0x3e19, 0x24386b },
	{ 0x3e1a, 0x23297b },
	{ 0x3e1b, 0x242a2c },
	{ 0x3e1c, 0x24386c },
	{ 0x3e1d, 0x23297d },
	{ 0x3e1e, 0x23297e },
	{ 0x3e1f, 0x252e53 },
	{ 0x3e20, 0x263940 },
	{ 0x3e21, 0x242d7a },
	{ 0x3e22, 0x24445f },
	{ 0x3e23, 0x27392d },
	{ 0x3e24, 0x245b64 },
	{ 0x3e25, 0x246650 },
	{ 0x3e26, 0x23216a },
	{ 0x3e27, 0x233233 },
	{ 0x3e28, 0x242326 },
	{ 0x3e29, 0x232665 },
	{ 0x3e2a, 0x242455 },
	{ 0x3e2b, 0x262c71 },
	{ 0x3e2c, 0x242733 },
	{ 0x3e2d, 0x252677 },
	{ 0x3e2e, 0x242732 },
	{ 0x3e2f, 0x24272f },
	{ 0x3e30, 0x232d6c },
	{ 0x3e31, 0x232d6f },
	{ 0x3e32, 0x242a2e },
	{ 0x3e33, 0x232d6e },
	{ 0x3e35, 0x233234 },
	{ 0x3e36, 0x233235 },
	{ 0x3e37, 0x242d7d },
	{ 0x3e38, 0x242d7c },
	{ 0x3e39, 0x24327a },
	{ 0x3e3a, 0x25334d },
	{ 0x3e3b, 0x243279 },
	{ 0x3e3c, 0x24327e },
	{ 0x3e3d, 0x233738 },
	{ 0x3e3e, 0x264166 },
	{ 0x3e40, 0x233737 },
	{ 0x3e41, 0x243870 },
	{ 0x3e42, 0x243872 },
	{ 0x3e43, 0x243873 },
	{ 0x3e44, 0x244463 },
	{ 0x3e45, 0x265478 },
	{ 0x3e46, 0x243e4e },
	{ 0x3e47, 0x23425e },
	{ 0x3e49, 0x244462 },
	{ 0x3e4a, 0x244460 },
	{ 0x3e4b, 0x244464 },
	{ 0x3e4c, 0x244a6f },
	{ 0x3e4d, 0x244a6e },
	{ 0x3e4e, 0x244a72 },
	{ 0x3e4f, 0x244a71 },
	{ 0x3e50, 0x244a73 },
	{ 0x3e51, 0x24512e },
	{ 0x3e52, 0x245130 },
	{ 0x3e53, 0x24512f },
	{ 0x3e54, 0x245667 },
	{ 0x3e55, 0x235546 },
	{ 0x3e56, 0x235547 },
	{ 0x3e57, 0x245b66 },
	{ 0x3e58, 0x245b65 },
	{ 0x3e59, 0x246024 },
	{ 0x3e5a, 0x27536b },
	{ 0x3e5b, 0x246a51 },
	{ 0x3e5c, 0x242734 },
	{ 0x3e5d, 0x242459 },
	{ 0x3e5e, 0x23266d },
	{ 0x3e5f, 0x242456 },
	{ 0x3e60, 0x23266c },
	{ 0x3e61, 0x262c75 },
	{ 0x3e62, 0x242739 },
	{ 0x3e63, 0x25272e },
	{ 0x3e64, 0x232a29 },
	{ 0x3e65, 0x232a24 },
	{ 0x3e66, 0x232a25 },
	{ 0x3e67, 0x24273a },
	{ 0x3e6b, 0x242a32 },
	{ 0x3e6c, 0x242a34 },
	{ 0x3e6d, 0x242a35 },
	{ 0x3e6e, 0x232d72 },
	{ 0x3e6f, 0x263267 },
	{ 0x3e71, 0x233237 },
	{ 0x3e72, 0x252e5c },
	{ 0x3e73, 0x242e21 },
	{ 0x3e74, 0x242d7e },
	{ 0x3e75, 0x242e22 },
	{ 0x3e76, 0x242e26 },
	{ 0x3e77, 0x26416d },
	{ 0x3e78, 0x242e27 },
	{ 0x3e79, 0x253351 },
	{ 0x3e7a, 0x243328 },
	{ 0x3e7b, 0x264175 },
	{ 0x3e7c, 0x243329 },
	{ 0x3e7d, 0x243325 },
	{ 0x3e7e, 0x24332b },
	{ 0x3e7f, 0x243327 },
	{ 0x3e80, 0x24332e },
	{ 0x3e81, 0x243879 },
	{ 0x3e82, 0x243877 },
	{ 0x3e83, 0x233d2c },
	{ 0x3e84, 0x24387b },
	{ 0x3e85, 0x264b43 },
	{ 0x3e87, 0x244465 },
	{ 0x3e88, 0x243e54 },
	{ 0x3e89, 0x244466 },
	{ 0x3e8a, 0x243e53 },
	{ 0x3e8b, 0x234260 },
	{ 0x3e8c, 0x243e52 },
	{ 0x3e8e, 0x24446a },
	{ 0x3e8f, 0x265e6e },
	{ 0x3e90, 0x244469 },
	{ 0x3e91, 0x244468 },
	{ 0x3e92, 0x244467 },
	{ 0x3e93, 0x234776 },
	{ 0x3e94, 0x24387a },
	{ 0x3e95, 0x244a7b },
	{ 0x3e96, 0x244a76 },
	{ 0x3e97, 0x244a7a },
	{ 0x3e98, 0x244a7c },
	{ 0x3e9a, 0x272f74 },
	{ 0x3e9b, 0x245132 },
	{ 0x3e9c, 0x245134 },
	{ 0x3e9d, 0x235548 },
	{ 0x3e9e, 0x24566a },
	{ 0x3e9f, 0x24566b },
	{ 0x3ea0, 0x245b67 },
	{ 0x3ea1, 0x25683b },
	{ 0x3ea3, 0x246365 },
	{ 0x3ea4, 0x246366 },
	{ 0x3ea5, 0x246367 },
	{ 0x3ea6, 0x246363 },
	{ 0x3ea7, 0x246b6f },
	{ 0x3ea8, 0x23242e },
	{ 0x3ea9, 0x242329 },
	{ 0x3eaa, 0x232430 },
	{ 0x3eab, 0x232431 },
	{ 0x3eac, 0x232671 },
	{ 0x3ead, 0x23266f },
	{ 0x3eae, 0x232670 },
	{ 0x3eb0, 0x232a2e },
	{ 0x3eb1, 0x232d76 },
	{ 0x3eb2, 0x262d21 },
	{ 0x3eb3, 0x232a30 },
	{ 0x3eb4, 0x24273b },
	{ 0x3eb5, 0x232a31 },
	{ 0x3eb7, 0x232d7d },
	{ 0x3eb8, 0x23323a },
	{ 0x3eb9, 0x242a37 },
	{ 0x3eba, 0x242a38 },
	{ 0x3ebd, 0x2f2c32 },
	{ 0x3ebf, 0x24332f },
	{ 0x3ec0, 0x233243 },
	{ 0x3ec1, 0x233244 },
	{ 0x3ec2, 0x23323b },
	{ 0x3ec3, 0x243330 },
	{ 0x3ec4, 0x233245 },
	{ 0x3ec7, 0x2f3127 },
	{ 0x3ec8, 0x233242 },
	{ 0x3ec9, 0x23373f },
	{ 0x3eca, 0x233742 },
	{ 0x3ecb, 0x233741 },
	{ 0x3ecc, 0x243333 },
	{ 0x3ecd, 0x23373e },
	{ 0x3ece, 0x233743 },
	{ 0x3ed1, 0x233d34 },
	{ 0x3ed2, 0x24387d },
	{ 0x3ed3, 0x253a2d },
	{ 0x3ed4, 0x234263 },
	{ 0x3ed5, 0x233d31 },
	{ 0x3ed6, 0x233d30 },
	{ 0x3ed7, 0x23426c },
	{ 0x3ed9, 0x2f3659 },
	{ 0x3eda, 0x2f3d3b },
	{ 0x3edd, 0x243e59 },
	{ 0x3ede, 0x234265 },
	{ 0x3edf, 0x234269 },
	{ 0x3ee0, 0x25404e },
	{ 0x3ee1, 0x234272 },
	{ 0x3ee2, 0x2f4349 },
	{ 0x3ee3, 0x2f4356 },
	{ 0x3ee7, 0x234824 },
	{ 0x3ee8, 0x272537 },
	{ 0x3eeb, 0x244b22 },
	{ 0x3eec, 0x244b21 },
	{ 0x3eed, 0x234d37 },
	{ 0x3eee, 0x234d3c },
	{ 0x3eef, 0x234d33 },
	{ 0x3ef0, 0x234d38 },
	{ 0x3ef1, 0x234d34 },
	{ 0x3ef2, 0x234d32 },
	{ 0x3ef5, 0x235168 },
	{ 0x3ef6, 0x25555d },
	{ 0x3ef7, 0x245137 },
	{ 0x3ef8, 0x235169 },
	{ 0x3ef9, 0x23554a },
	{ 0x3efa, 0x24566f },
	{ 0x3efb, 0x2f557a },
	{ 0x3efc, 0x2f5622 },
	{ 0x3efd, 0x23554e },
	{ 0x3efe, 0x245b69 },
	{ 0x3eff, 0x23554c },
	{ 0x3f01, 0x2f5b2d },
	{ 0x3f02, 0x235831 },
	{ 0x3f04, 0x24602a },
	{ 0x3f05, 0x2f6278 },
	{ 0x3f06, 0x2f627b },
	{ 0x3f07, 0x235c61 },
	{ 0x3f09, 0x242a39 },
	{ 0x3f0a, 0x242a3a },
	{ 0x3f0b, 0x252e62 },
	{ 0x3f0c, 0x242e2b },
	{ 0x3f0d, 0x243335 },
	{ 0x3f0e, 0x243334 },
	{ 0x3f0f, 0x24387e },
	{ 0x3f10, 0x244470 },
	{ 0x3f11, 0x244471 },
	{ 0x3f12, 0x24446f },
	{ 0x3f13, 0x244b23 },
	{ 0x3f14, 0x244b24 },
	{ 0x3f15, 0x245b6c },
	{ 0x3f16, 0x246d5a },
	{ 0x3f17, 0x24245e },
	{ 0x3f18, 0x252732 },
	{ 0x3f19, 0x232a34 },
	{ 0x3f1a, 0x232e23 },
	{ 0x3f1b, 0x242a3d },
	{ 0x3f1c, 0x23324a },
	{ 0x3f1d, 0x23324b },
	{ 0x3f1e, 0x242e2d },
	{ 0x3f1f, 0x233249 },
	{ 0x3f20, 0x242e2c },
	{ 0x3f21, 0x24333b },
	{ 0x3f22, 0x243921 },
	{ 0x3f23, 0x24333a },
	{ 0x3f24, 0x243338 },
	{ 0x3f25, 0x243339 },
	{ 0x3f26, 0x243337 },
	{ 0x3f27, 0x243923 },
	{ 0x3f28, 0x243926 },
	{ 0x3f29, 0x24333c },
	{ 0x3f2a, 0x243924 },
	{ 0x3f2b, 0x243e62 },
	{ 0x3f2c, 0x243e61 },
	{ 0x3f2d, 0x243e5d },
	{ 0x3f2e, 0x243e60 },
	{ 0x3f2f, 0x234276 },
	{ 0x3f30, 0x243e63 },
	{ 0x3f31, 0x254748 },
	{ 0x3f32, 0x244473 },
	{ 0x3f33, 0x244476 },
	{ 0x3f34, 0x244474 },
	{ 0x3f35, 0x244478 },
	{ 0x3f36, 0x244477 },
	{ 0x3f37, 0x244475 },
	{ 0x3f38, 0x244b25 },
	{ 0x3f39, 0x244b27 },
	{ 0x3f3a, 0x244b26 },
	{ 0x3f3b, 0x24513f },
	{ 0x3f3c, 0x23516f },
	{ 0x3f3d, 0x245142 },
	{ 0x3f3e, 0x245141 },
	{ 0x3f3f, 0x245672 },
	{ 0x3f40, 0x245673 },
	{ 0x3f41, 0x235551 },
	{ 0x3f42, 0x245675 },
	{ 0x3f43, 0x235550 },
	{ 0x3f44, 0x245671 },
	{ 0x3f46, 0x245b6f },
	{ 0x3f47, 0x245b6e },
	{ 0x3f48, 0x24602c },
	{ 0x3f49, 0x24602b },
	{ 0x3f4a, 0x246875 },
	{ 0x3f4b, 0x246b70 },
	{ 0x3f4c, 0x246a53 },
	{ 0x3f4d, 0x23324c },
	{ 0x3f4e, 0x243e65 },
	{ 0x3f50, 0x234d3f },
	{ 0x3f51, 0x245678 },
	{ 0x3f52, 0x233d40 },
	{ 0x3f53, 0x2f504e },
	{ 0x3f55, 0x252463 },
	{ 0x3f56, 0x262862 },
	{ 0x3f57, 0x232672 },
	{ 0x3f58, 0x242a41 },
	{ 0x3f59, 0x232e29 },
	{ 0x3f5a, 0x242a43 },
	{ 0x3f5b, 0x242e2f },
	{ 0x3f5c, 0x242e31 },
	{ 0x3f5d, 0x253364 },
	{ 0x3f5e, 0x233748 },
	{ 0x3f5f, 0x233d41 },
	{ 0x3f60, 0x243928 },
	{ 0x3f61, 0x243e69 },
	{ 0x3f62, 0x234279 },
	{ 0x3f63, 0x23427a },
	{ 0x3f64, 0x243e68 },
	{ 0x3f65, 0x244479 },
	{ 0x3f66, 0x234d40 },
	{ 0x3f67, 0x244b2a },
	{ 0x3f68, 0x244b29 },
	{ 0x3f69, 0x245144 },
	{ 0x3f6a, 0x255c2f },
	{ 0x3f6b, 0x245b72 },
	{ 0x3f6c, 0x245b73 },
	{ 0x3f6d, 0x24602e },
	{ 0x3f6e, 0x246369 },
	{ 0x3f6f, 0x246a54 },
	{ 0x3f70, 0x243e6d },
	{ 0x3f71, 0x242461 },
	{ 0x3f72, 0x242462 },
	{ 0x3f74, 0x252737 },
	{ 0x3f75, 0x232a3c },
	{ 0x3f77, 0x242a46 },
	{ 0x3f78, 0x232e2d },
	{ 0x3f79, 0x242a49 },
	{ 0x3f7a, 0x232e2c },
	{ 0x3f7b, 0x232e2e },
	{ 0x3f7d, 0x233256 },
	{ 0x3f7e, 0x242e37 },
	{ 0x3f7f, 0x242e3b },
	{ 0x3f80, 0x242e35 },
	{ 0x3f81, 0x242e36 },
	{ 0x3f82, 0x233254 },
	{ 0x3f83, 0x242e33 },
	{ 0x3f84, 0x242e3f },
	{ 0x3f85, 0x242e39 },
	{ 0x3f86, 0x26396b },
	{ 0x3f87, 0x233253 },
	{ 0x3f88, 0x242e38 },
	{ 0x3f89, 0x242e3a },
	{ 0x3f8a, 0x25336d },
	{ 0x3f8b, 0x243342 },
	{ 0x3f8c, 0x23374c },
	{ 0x3f8d, 0x243340 },
	{ 0x3f8e, 0x242e3c },
	{ 0x3f8f, 0x24333f },
	{ 0x3f90, 0x243345 },
	{ 0x3f91, 0x23374b },
	{ 0x3f92, 0x243343 },
	{ 0x3f93, 0x243932 },
	{ 0x3f94, 0x243933 },
	{ 0x3f95, 0x233d46 },
	{ 0x3f96, 0x233d4b },
	{ 0x3f97, 0x264b5a },
	{ 0x3f98, 0x233d49 },
	{ 0x3f99, 0x243936 },
	{ 0x3f9a, 0x254060 },
	{ 0x3f9b, 0x24392f },
	{ 0x3f9c, 0x243930 },
	{ 0x3f9d, 0x233d48 },
	{ 0x3f9e, 0x233d4a },
	{ 0x3f9f, 0x253a3b },
	{ 0x3fa0, 0x243935 },
	{ 0x3fa1, 0x243938 },
	{ 0x3fa2, 0x243e74 },
	{ 0x3fa3, 0x254064 },
	{ 0x3fa4, 0x243e6f },
	{ 0x3fa5, 0x243e78 },
	{ 0x3fa6, 0x243e6e },
	{ 0x3fa7, 0x243e76 },
	{ 0x3fa8, 0x243e73 },
	{ 0x3fa9, 0x243e7a },
	{ 0x3faa, 0x244524 },
	{ 0x3fab, 0x244528 },
	{ 0x3fac, 0x265f2d },
	{ 0x3fad, 0x23482a },
	{ 0x3fae, 0x23482c },
	{ 0x3faf, 0x244523 },
	{ 0x3fb0, 0x244521 },
	{ 0x3fb6, 0x272558 },
	{ 0x3fb7, 0x244b38 },
	{ 0x3fb8, 0x234d42 },
	{ 0x3fb9, 0x244b37 },
	{ 0x3fba, 0x244b35 },
	{ 0x3fbb, 0x244b33 },
	{ 0x3fbc, 0x244b2f },
	{ 0x3fbd, 0x27255c },
	{ 0x3fbe, 0x244b2e },
	{ 0x3fbf, 0x254759 },
	{ 0x3fc1, 0x244b3b },
	{ 0x3fc2, 0x273036 },
	{ 0x3fc3, 0x245148 },
	{ 0x3fc4, 0x245149 },
	{ 0x3fc5, 0x235175 },
	{ 0x3fc6, 0x24514e },
	{ 0x3fc7, 0x24514a },
	{ 0x3fc8, 0x245150 },
	{ 0x3fc9, 0x245726 },
	{ 0x3fca, 0x245722 },
	{ 0x3fcb, 0x245b7b },
	{ 0x3fcc, 0x245b77 },
	{ 0x3fcd, 0x27406b },
	{ 0x3fce, 0x245725 },
	{ 0x3fcf, 0x274067 },
	{ 0x3fd1, 0x246032 },
	{ 0x3fd2, 0x24602f },
	{ 0x3fd3, 0x246030 },
	{ 0x3fd5, 0x246658 },
	{ 0x3fd6, 0x246659 },
	{ 0x3fd7, 0x235e40 },
	{ 0x3fd8, 0x25735c },
	{ 0x3fd9, 0x246a55 },
	{ 0x3fda, 0x246b72 },
	{ 0x3fdb, 0x246b71 },
	{ 0x3fdc, 0x23622d },
	{ 0x3fdd, 0x232675 },
	{ 0x3fde, 0x232e30 },
	{ 0x3fdf, 0x233258 },
	{ 0x3fe1, 0x23374e },
	{ 0x3fe2, 0x234322 },
	{ 0x3fe3, 0x23482d },
	{ 0x3fe4, 0x25475b },
	{ 0x3fe5, 0x254e59 },
	{ 0x3fe6, 0x245156 },
	{ 0x3fe7, 0x246037 },
	{ 0x3fe8, 0x24665b },
	{ 0x3fe9, 0x246c73 },
	{ 0x3fea, 0x242746 },
	{ 0x3feb, 0x242a4e },
	{ 0x3fec, 0x232e31 },
	{ 0x3fed, 0x242e46 },
	{ 0x3fee, 0x242e45 },
	{ 0x3fef, 0x243347 },
	{ 0x3ff0, 0x243348 },
	{ 0x3ff1, 0x24393a },
	{ 0x3ff2, 0x265552 },
	{ 0x3ff3, 0x244530 },
	{ 0x3ff4, 0x244532 },
	{ 0x3ff5, 0x23482f },
	{ 0x3ff6, 0x234d43 },
	{ 0x3ff7, 0x244b3d },
	{ 0x3ff8, 0x245157 },
	{ 0x3ff9, 0x245b7e },
	{ 0x3ffa, 0x24636c },
	{ 0x3ffb, 0x242748 },
	{ 0x3ffc, 0x242a51 },
	{ 0x3ffd, 0x242a50 },
	{ 0x3ffe, 0x242e47 },
	{ 0x3fff, 0x242e49 },
	{ 0x4000, 0x233259 },
	{ 0x4001, 0x24334b },
	{ 0x4002, 0x23374f },
	{ 0x4003, 0x233d4e },
	{ 0x4004, 0x234323 },
	{ 0x4005, 0x25406f },
	{ 0x4006, 0x234832 },
	{ 0x4007, 0x24515a },
	{ 0x4008, 0x244536 },
	{ 0x4009, 0x24572c },
	{ 0x400a, 0x246038 },
	{ 0x400b, 0x235f38 },
	{ 0x400d, 0x246e48 },
	{ 0x400e, 0x232679 },
	{ 0x400f, 0x242465 },
	{ 0x4010, 0x24274e },
	{ 0x4011, 0x24274f },
	{ 0x4012, 0x24274d },
	{ 0x4013, 0x24274c },
	{ 0x4014, 0x24274a },
	{ 0x4015, 0x242a53 },
	{ 0x4016, 0x242a56 },
	{ 0x4017, 0x242a57 },
	{ 0x4018, 0x242a54 },
	{ 0x4019, 0x242a58 },
	{ 0x401a, 0x252a6d },
	{ 0x401b, 0x242a5a },
	{ 0x401c, 0x263338 },
	{ 0x401e, 0x232e34 },
	{ 0x401f, 0x242e52 },
	{ 0x4020, 0x23325d },
	{ 0x4021, 0x233266 },
	{ 0x4022, 0x233260 },
	{ 0x4023, 0x242e4d },
	{ 0x4024, 0x233261 },
	{ 0x4027, 0x253376 },
	{ 0x4028, 0x243350 },
	{ 0x4029, 0x243351 },
	{ 0x402a, 0x233756 },
	{ 0x402b, 0x233754 },
	{ 0x402c, 0x243352 },
	{ 0x402d, 0x24334e },
	{ 0x402e, 0x24334d },
	{ 0x402f, 0x233d50 },
	{ 0x4030, 0x243949 },
	{ 0x4031, 0x233d54 },
	{ 0x4032, 0x24394a },
	{ 0x4033, 0x233d55 },
	{ 0x4034, 0x243945 },
	{ 0x4035, 0x243948 },
	{ 0x4036, 0x24393f },
	{ 0x4037, 0x243941 },
	{ 0x4038, 0x24394b },
	{ 0x4039, 0x243946 },
	{ 0x403a, 0x24394d },
	{ 0x403b, 0x243947 },
	{ 0x403c, 0x243943 },
	{ 0x403d, 0x243f22 },
	{ 0x403e, 0x24394c },
	{ 0x403f, 0x243942 },
	{ 0x4041, 0x243f30 },
	{ 0x4042, 0x243f2d },
	{ 0x4043, 0x234324 },
	{ 0x4044, 0x243f25 },
	{ 0x4045, 0x243f26 },
	{ 0x4046, 0x243f27 },
	{ 0x4047, 0x243f2b },
	{ 0x4048, 0x243f2c },
	{ 0x4049, 0x265561 },
	{ 0x404a, 0x254761 },
	{ 0x404b, 0x244539 },
	{ 0x404c, 0x244541 },
	{ 0x404d, 0x24453c },
	{ 0x404e, 0x244537 },
	{ 0x404f, 0x234837 },
	{ 0x4050, 0x244543 },
	{ 0x4051, 0x244546 },
	{ 0x4052, 0x24453f },
	{ 0x4053, 0x244544 },
	{ 0x4054, 0x23483a },
	{ 0x4055, 0x244538 },
	{ 0x4057, 0x234d45 },
	{ 0x4058, 0x244b45 },
	{ 0x4059, 0x244b42 },
	{ 0x405a, 0x244b44 },
	{ 0x405b, 0x244b47 },
	{ 0x405c, 0x244b43 },
	{ 0x405d, 0x244b4d },
	{ 0x405e, 0x234d47 },
	{ 0x405f, 0x254e60 },
	{ 0x4060, 0x244b3f },
	{ 0x4062, 0x235177 },
	{ 0x4063, 0x235178 },
	{ 0x4064, 0x24515c },
	{ 0x4065, 0x245160 },
	{ 0x4066, 0x23517c },
	{ 0x4067, 0x23517a },
	{ 0x4068, 0x24515d },
	{ 0x4069, 0x245164 },
	{ 0x406b, 0x245732 },
	{ 0x406c, 0x24572e },
	{ 0x406d, 0x245731 },
	{ 0x406e, 0x24572f },
	{ 0x406f, 0x23555a },
	{ 0x4070, 0x245730 },
	{ 0x4071, 0x245733 },
	{ 0x4072, 0x245734 },
	{ 0x4073, 0x255622 },
	{ 0x4074, 0x256269 },
	{ 0x4075, 0x245c27 },
	{ 0x4076, 0x245c29 },
	{ 0x4077, 0x245c2a },
	{ 0x4078, 0x245c25 },
	{ 0x4079, 0x235837 },
	{ 0x407a, 0x245c26 },
	{ 0x407b, 0x246370 },
	{ 0x407c, 0x24636e },
	{ 0x407d, 0x246371 },
	{ 0x407e, 0x24636f },
	{ 0x407f, 0x24665d },
	{ 0x4080, 0x235e41 },
	{ 0x4081, 0x246878 },
	{ 0x4082, 0x246a57 },
	{ 0x4083, 0x24687a },
	{ 0x4084, 0x246c75 },
	{ 0x4085, 0x246e4d },
	{ 0x4086, 0x242751 },
	{ 0x4087, 0x242a5f },
	{ 0x4088, 0x243357 },
	{ 0x4089, 0x24454a },
	{ 0x408a, 0x23555d },
	{ 0x408c, 0x245738 },
	{ 0x408d, 0x246374 },
	{ 0x408e, 0x246b75 },
	{ 0x408f, 0x242e57 },
	{ 0x4090, 0x242e58 },
	{ 0x4091, 0x24335a },
	{ 0x4092, 0x243359 },
	{ 0x4093, 0x264c2b },
	{ 0x4094, 0x243f33 },
	{ 0x4095, 0x24454c },
	{ 0x4096, 0x232432 },
	{ 0x4097, 0x23267a },
	{ 0x4098, 0x242753 },
	{ 0x4099, 0x2f287a },
	{ 0x409a, 0x242a64 },
	{ 0x409b, 0x232e38 },
	{ 0x409c, 0x242a62 },
	{ 0x409d, 0x232e3c },
	{ 0x409e, 0x232d3b },
	{ 0x409f, 0x242e5f },
	{ 0x40a0, 0x242e5c },
	{ 0x40a1, 0x242e62 },
	{ 0x40a2, 0x252f34 },
	{ 0x40a3, 0x23375b },
	{ 0x40a4, 0x23326a },
	{ 0x40a5, 0x23326b },
	{ 0x40a6, 0x242e5e },
	{ 0x40a7, 0x242e61 },
	{ 0x40a9, 0x24335e },
	{ 0x40aa, 0x243361 },
	{ 0x40ab, 0x23375c },
	{ 0x40ac, 0x24335f },
	{ 0x40ad, 0x23375a },
	{ 0x40ae, 0x243360 },
	{ 0x40af, 0x23375e },
	{ 0x40b0, 0x233d5b },
	{ 0x40b1, 0x253a59 },
	{ 0x40b2, 0x264c33 },
	{ 0x40b3, 0x243958 },
	{ 0x40b4, 0x233d58 },
	{ 0x40b6, 0x243953 },
	{ 0x40b7, 0x243f40 },
	{ 0x40b8, 0x243f39 },
	{ 0x40b9, 0x243f3f },
	{ 0x40ba, 0x23432f },
	{ 0x40bb, 0x243f3c },
	{ 0x40bc, 0x234332 },
	{ 0x40bd, 0x243f3d },
	{ 0x40be, 0x23432c },
	{ 0x40bf, 0x243f3e },
	{ 0x40c0, 0x243f38 },
	{ 0x40c1, 0x243f3a },
	{ 0x40c2, 0x243f3b },
	{ 0x40c7, 0x243f42 },
	{ 0x40c8, 0x24454e },
	{ 0x40c9, 0x234843 },
	{ 0x40ca, 0x244551 },
	{ 0x40cb, 0x234841 },
	{ 0x40cc, 0x24454d },
	{ 0x40cd, 0x244555 },
	{ 0x40ce, 0x24454f },
	{ 0x40cf, 0x254776 },
	{ 0x40d1, 0x244b5c },
	{ 0x40d2, 0x244b58 },
	{ 0x40d3, 0x244b56 },
	{ 0x40d4, 0x244b55 },
	{ 0x40d5, 0x244b5e },
	{ 0x40d6, 0x272624 },
	{ 0x40d7, 0x244b5b },
	{ 0x40d8, 0x235223 },
	{ 0x40d9, 0x23517d },
	{ 0x40da, 0x24516c },
	{ 0x40db, 0x23517e },
	{ 0x40dc, 0x273059 },
	{ 0x40dd, 0x255633 },
	{ 0x40de, 0x245170 },
	{ 0x40e0, 0x24516d },
	{ 0x40e1, 0x24573b },
	{ 0x40e2, 0x245741 },
	{ 0x40e3, 0x234842 },
	{ 0x40e4, 0x245739 },
	{ 0x40e5, 0x23555e },
	{ 0x40e6, 0x23555f },
	{ 0x40e7, 0x24573f },
	{ 0x40e9, 0x235841 },
	{ 0x40ea, 0x245c2d },
	{ 0x40eb, 0x23583d },
	{ 0x40ec, 0x245c31 },
	{ 0x40ed, 0x245c2f },
	{ 0x40ee, 0x245c2e },
	{ 0x40f0, 0x24603f },
	{ 0x40f1, 0x274e5c },
	{ 0x40f2, 0x235c63 },
	{ 0x40f3, 0x246376 },
	{ 0x40f4, 0x246375 },
	{ 0x40f5, 0x24665f },
	{ 0x40f6, 0x246660 },
	{ 0x40f7, 0x246661 },
	{ 0x40f8, 0x24687c },
	{ 0x40f9, 0x24687b },
	{ 0x40fa, 0x236075 },
	{ 0x40fb, 0x236167 },
	{ 0x40fd, 0x232e3f },
	{ 0x40fe, 0x242a67 },
	{ 0x40ff, 0x242a66 },
	{ 0x4100, 0x263348 },
	{ 0x4101, 0x23326e },
	{ 0x4102, 0x242e64 },
	{ 0x4103, 0x233271 },
	{ 0x4104, 0x233764 },
	{ 0x4105, 0x243363 },
	{ 0x4106, 0x243362 },
	{ 0x4107, 0x233d61 },
	{ 0x4108, 0x233d60 },
	{ 0x4109, 0x243959 },
	{ 0x410b, 0x243f45 },
	{ 0x410c, 0x243f44 },
	{ 0x410d, 0x23433a },
	{ 0x410e, 0x23433b },
	{ 0x410f, 0x23433e },
	{ 0x4110, 0x243f47 },
	{ 0x4111, 0x23433c },
	{ 0x4112, 0x23433f },
	{ 0x4113, 0x234846 },
	{ 0x4114, 0x254824 },
	{ 0x4115, 0x234849 },
	{ 0x4118, 0x254e76 },
	{ 0x4119, 0x234d4e },
	{ 0x411a, 0x245176 },
	{ 0x411b, 0x235225 },
	{ 0x411c, 0x245174 },
	{ 0x411d, 0x245175 },
	{ 0x411f, 0x245742 },
	{ 0x4120, 0x235846 },
	{ 0x4121, 0x235847 },
	{ 0x4122, 0x235a64 },
	{ 0x4124, 0x246663 },
	{ 0x4125, 0x236234 },
	{ 0x4126, 0x25246e },
	{ 0x4127, 0x23267d },
	{ 0x4128, 0x252746 },
	{ 0x4129, 0x262d49 },
	{ 0x412a, 0x242756 },
	{ 0x412b, 0x232a40 },
	{ 0x412c, 0x232a41 },
	{ 0x412d, 0x232a43 },
	{ 0x412e, 0x242a6a },
	{ 0x412f, 0x242a6f },
	{ 0x4130, 0x242a6b },
	{ 0x4131, 0x242a69 },
	{ 0x4132, 0x242a6c },
	{ 0x4133, 0x2f2c6d },
	{ 0x4136, 0x242e65 },
	{ 0x4137, 0x233275 },
	{ 0x4138, 0x23327a },
	{ 0x413a, 0x264266 },
	{ 0x413b, 0x243367 },
	{ 0x413c, 0x243366 },
	{ 0x413d, 0x23376d },
	{ 0x413e, 0x243365 },
	{ 0x413f, 0x25343b },
	{ 0x4140, 0x253439 },
	{ 0x4141, 0x24336a },
	{ 0x4142, 0x243369 },
	{ 0x4143, 0x24336b },
	{ 0x4144, 0x233768 },
	{ 0x4145, 0x24336d },
	{ 0x4146, 0x253438 },
	{ 0x4147, 0x23376e },
	{ 0x4148, 0x2f373b },
	{ 0x414a, 0x243364 },
	{ 0x414b, 0x253a65 },
	{ 0x414c, 0x24395e },
	{ 0x414d, 0x243962 },
	{ 0x414e, 0x233d67 },
	{ 0x414f, 0x243964 },
	{ 0x4150, 0x233d6a },
	{ 0x4151, 0x243963 },
	{ 0x4152, 0x233d6b },
	{ 0x4153, 0x243961 },
	{ 0x4154, 0x243f4f },
	{ 0x4155, 0x234340 },
	{ 0x4156, 0x243f4d },
	{ 0x4157, 0x234345 },
	{ 0x4158, 0x243f4c },
	{ 0x4159, 0x234342 },
	{ 0x415a, 0x243f4b },
	{ 0x415b, 0x234343 },
	{ 0x415c, 0x244557 },
	{ 0x415d, 0x243f49 },
	{ 0x415e, 0x254131 },
	{ 0x4160, 0x234851 },
	{ 0x4161, 0x23484a },
	{ 0x4162, 0x24455b },
	{ 0x4163, 0x234853 },
	{ 0x4164, 0x23484e },
	{ 0x4165, 0x24455a },
	{ 0x4166, 0x23484c },
	{ 0x4167, 0x244558 },
	{ 0x4168, 0x265f6b },
	{ 0x4169, 0x244559 },
	{ 0x416c, 0x244b65 },
	{ 0x416d, 0x244b61 },
	{ 0x416e, 0x234d54 },
	{ 0x416f, 0x244b62 },
	{ 0x4170, 0x234d52 },
	{ 0x4171, 0x272632 },
	{ 0x4172, 0x234d58 },
	{ 0x4173, 0x244b68 },
	{ 0x4174, 0x244b66 },
	{ 0x4175, 0x244b64 },
	{ 0x4176, 0x234d59 },
	{ 0x4177, 0x24517d },
	{ 0x4178, 0x24517c },
	{ 0x4179, 0x23522b },
	{ 0x417a, 0x245179 },
	{ 0x417b, 0x245178 },
	{ 0x417c, 0x24517a },
	{ 0x417d, 0x23522d },
	{ 0x417e, 0x245745 },
	{ 0x417f, 0x235563 },
	{ 0x4180, 0x245747 },
	{ 0x4181, 0x235848 },
	{ 0x4182, 0x27412e },
	{ 0x4183, 0x245c37 },
	{ 0x4184, 0x245c35 },
	{ 0x4185, 0x245c36 },
	{ 0x4188, 0x235e46 },
	{ 0x4189, 0x246379 },
	{ 0x418a, 0x246665 },
	{ 0x418b, 0x27584c },
	{ 0x418d, 0x246664 },
	{ 0x418e, 0x24687e },
	{ 0x418f, 0x246921 },
	{ 0x4190, 0x236239 },
	{ 0x4191, 0x242469 },
	{ 0x4192, 0x262d4e },
	{ 0x4193, 0x232e46 },
	{ 0x4194, 0x232e45 },
	{ 0x4195, 0x242a71 },
	{ 0x4196, 0x242a72 },
	{ 0x4197, 0x233321 },
	{ 0x4198, 0x23327e },
	{ 0x4199, 0x23327d },
	{ 0x419a, 0x24336f },
	{ 0x419b, 0x243370 },
	{ 0x419c, 0x23376f },
	{ 0x419d, 0x253445 },
	{ 0x419e, 0x243372 },
	{ 0x419f, 0x243371 },
	{ 0x41a0, 0x26426f },
	{ 0x41a1, 0x233d6c },
	{ 0x41a2, 0x243967 },
	{ 0x41a3, 0x233d6d },
	{ 0x41a4, 0x264c53 },
	{ 0x41a5, 0x233d6e },
	{ 0x41a6, 0x254139 },
	{ 0x41a7, 0x243f53 },
	{ 0x41a8, 0x243f52 },
	{ 0x41a9, 0x265627 },
	{ 0x41aa, 0x244560 },
	{ 0x41ab, 0x265f78 },
	{ 0x41ac, 0x244b6c },
	{ 0x41ad, 0x254f23 },
	{ 0x41af, 0x255424 },
	{ 0x41b0, 0x245225 },
	{ 0x41b1, 0x245222 },
	{ 0x41b2, 0x245224 },
	{ 0x41b3, 0x27306f },
	{ 0x41b5, 0x235565 },
	{ 0x41b6, 0x235566 },
	{ 0x41b7, 0x24574c },
	{ 0x41b8, 0x24574d },
	{ 0x41b9, 0x24574b },
	{ 0x41ba, 0x24574f },
	{ 0x41bb, 0x235567 },
	{ 0x41bc, 0x245c39 },
	{ 0x41bd, 0x245c3a },
	{ 0x41be, 0x246048 },
	{ 0x41bf, 0x246049 },
	{ 0x41c0, 0x24637c },
	{ 0x41c1, 0x246922 },
	{ 0x41c2, 0x232434 },
	{ 0x41c3, 0x232a46 },
	{ 0x41c5, 0x242a76 },
	{ 0x41c6, 0x232e4a },
	{ 0x41c7, 0x233325 },
	{ 0x41c8, 0x242e6d },
	{ 0x41c9, 0x233322 },
	{ 0x41cb, 0x253446 },
	{ 0x41cc, 0x233d6f },
	{ 0x41cd, 0x24396a },
	{ 0x41ce, 0x234348 },
	{ 0x41cf, 0x243f54 },
	{ 0x41d0, 0x243f55 },
	{ 0x41d1, 0x243f5a },
	{ 0x41d2, 0x244563 },
	{ 0x41d3, 0x245752 },
	{ 0x41d4, 0x245c3b },
	{ 0x41d5, 0x235a68 },
	{ 0x41d6, 0x252b21 },
	{ 0x41d7, 0x242e75 },
	{ 0x41d8, 0x242e70 },
	{ 0x41d9, 0x233328 },
	{ 0x41da, 0x242e77 },
	{ 0x41db, 0x233329 },
	{ 0x41dc, 0x242e73 },
	{ 0x41dd, 0x242e72 },
	{ 0x41de, 0x243376 },
	{ 0x41df, 0x24337d },
	{ 0x41e0, 0x233774 },
	{ 0x41e1, 0x253448 },
	{ 0x41e2, 0x243377 },
	{ 0x41e3, 0x24337b },
	{ 0x41e4, 0x233775 },
	{ 0x41e5, 0x264276 },
	{ 0x41e6, 0x243378 },
	{ 0x41e7, 0x24396d },
	{ 0x41e8, 0x243974 },
	{ 0x41e9, 0x243971 },
	{ 0x41ea, 0x233d74 },
	{ 0x41eb, 0x243f5b },
	{ 0x41ec, 0x243972 },
	{ 0x41ed, 0x233d7a },
	{ 0x41ee, 0x243975 },
	{ 0x41ef, 0x233d73 },
	{ 0x41f0, 0x24396f },
	{ 0x41f1, 0x264c5b },
	{ 0x41f2, 0x264c56 },
	{ 0x41f5, 0x234350 },
	{ 0x41f6, 0x243f66 },
	{ 0x41f7, 0x243f62 },
	{ 0x41f8, 0x243f61 },
	{ 0x41f9, 0x234352 },
	{ 0x41fa, 0x234353 },
	{ 0x41fb, 0x243f5d },
	{ 0x41fc, 0x23434e },
	{ 0x41fd, 0x243f60 },
	{ 0x41fe, 0x23434b },
	{ 0x4200, 0x243f63 },
	{ 0x4201, 0x254846 },
	{ 0x4202, 0x243976 },
	{ 0x4203, 0x244565 },
	{ 0x4204, 0x23485b },
	{ 0x4205, 0x24456a },
	{ 0x4206, 0x244569 },
	{ 0x4207, 0x23485f },
	{ 0x4208, 0x24456e },
	{ 0x4209, 0x244568 },
	{ 0x420a, 0x234859 },
	{ 0x420b, 0x24456d },
	{ 0x420c, 0x244566 },
	{ 0x420d, 0x254836 },
	{ 0x420e, 0x244b7b },
	{ 0x420f, 0x244b75 },
	{ 0x4210, 0x244b70 },
	{ 0x4211, 0x234d61 },
	{ 0x4212, 0x234d5e },
	{ 0x4213, 0x244c22 },
	{ 0x4214, 0x234d67 },
	{ 0x4215, 0x244b7e },
	{ 0x4216, 0x234d62 },
	{ 0x4217, 0x244c2e },
	{ 0x4218, 0x254f3b },
	{ 0x4219, 0x234d64 },
	{ 0x421a, 0x244c30 },
	{ 0x421b, 0x244c25 },
	{ 0x421c, 0x244c2d },
	{ 0x421d, 0x244b79 },
	{ 0x421e, 0x254f32 },
	{ 0x421f, 0x234d5f },
	{ 0x4220, 0x254f45 },
	{ 0x4221, 0x244c2c },
	{ 0x4222, 0x244c27 },
	{ 0x4223, 0x244b77 },
	{ 0x4224, 0x234d66 },
	{ 0x4225, 0x234d68 },
	{ 0x4226, 0x244c28 },
	{ 0x4227, 0x254f36 },
	{ 0x422a, 0x245234 },
	{ 0x422b, 0x24523a },
	{ 0x422c, 0x235231 },
	{ 0x422d, 0x245237 },
	{ 0x422e, 0x24522b },
	{ 0x422f, 0x245238 },
	{ 0x4230, 0x235235 },
	{ 0x4231, 0x245239 },
	{ 0x4232, 0x24523b },
	{ 0x4233, 0x245236 },
	{ 0x4234, 0x24522f },
	{ 0x4235, 0x24523d },
	{ 0x4236, 0x245229 },
	{ 0x4237, 0x235232 },
	{ 0x4238, 0x24575b },
	{ 0x4239, 0x255c6d },
	{ 0x423a, 0x24575e },
	{ 0x423b, 0x24575a },
	{ 0x423c, 0x245762 },
	{ 0x423d, 0x255c7d },
	{ 0x423e, 0x245765 },
	{ 0x423f, 0x245753 },
	{ 0x4240, 0x23556c },
	{ 0x4241, 0x245756 },
	{ 0x4242, 0x245758 },
	{ 0x4243, 0x245759 },
	{ 0x4244, 0x255c7e },
	{ 0x4245, 0x245755 },
	{ 0x4246, 0x255d30 },
	{ 0x4248, 0x245c44 },
	{ 0x4249, 0x245c4f },
	{ 0x424a, 0x245c4b },
	{ 0x424b, 0x245c50 },
	{ 0x424c, 0x245c43 },
	{ 0x424d, 0x23584a },
	{ 0x424e, 0x245c4a },
	{ 0x424f, 0x235a6c },
	{ 0x4250, 0x245c42 },
	{ 0x4251, 0x245c4c },
	{ 0x4252, 0x27413f },
	{ 0x4253, 0x245c46 },
	{ 0x4254, 0x245c49 },
	{ 0x4255, 0x245c40 },
	{ 0x4256, 0x256334 },
	{ 0x4257, 0x245c48 },
	{ 0x4258, 0x23584d },
	{ 0x4259, 0x23584b },
	{ 0x425a, 0x256341 },
	{ 0x425b, 0x246056 },
	{ 0x425c, 0x25686e },
	{ 0x425d, 0x235a6a },
	{ 0x425e, 0x246053 },
	{ 0x425f, 0x256866 },
	{ 0x4260, 0x235a6d },
	{ 0x4261, 0x235a69 },
	{ 0x4262, 0x235a6b },
	{ 0x4263, 0x245c51 },
	{ 0x4265, 0x24637e },
	{ 0x4266, 0x246669 },
	{ 0x4267, 0x24666c },
	{ 0x4268, 0x24666e },
	{ 0x4269, 0x235e4a },
	{ 0x426a, 0x24666a },
	{ 0x426b, 0x235e4d },
	{ 0x426c, 0x246668 },
	{ 0x426d, 0x24666d },
	{ 0x426e, 0x235f56 },
	{ 0x426f, 0x257061 },
	{ 0x4270, 0x246926 },
	{ 0x4271, 0x246928 },
	{ 0x4272, 0x246a5d },
	{ 0x4273, 0x246a61 },
	{ 0x4274, 0x246a5c },
	{ 0x4275, 0x23605f },
	{ 0x4276, 0x246b76 },
	{ 0x4277, 0x246d5c },
	{ 0x4278, 0x246d76 },
	{ 0x4279, 0x27655d },
	{ 0x427a, 0x242a77 },
	{ 0x427b, 0x23332f },
	{ 0x427c, 0x233333 },
	{ 0x427d, 0x264322 },
	{ 0x427e, 0x243425 },
	{ 0x427f, 0x253459 },
	{ 0x4280, 0x23377c },
	{ 0x4281, 0x264c60 },
	{ 0x4282, 0x24397b },
	{ 0x4283, 0x24397c },
	{ 0x4284, 0x233d7d },
	{ 0x4285, 0x233d7c },
	{ 0x4286, 0x24397d },
	{ 0x4287, 0x23435a },
	{ 0x4288, 0x234356 },
	{ 0x4289, 0x234357 },
	{ 0x428a, 0x234359 },
	{ 0x428b, 0x23435b },
	{ 0x428d, 0x234863 },
	{ 0x428e, 0x244572 },
	{ 0x428f, 0x234864 },
	{ 0x4290, 0x234865 },
	{ 0x4291, 0x26602c },
	{ 0x4292, 0x234866 },
	{ 0x4293, 0x234d6b },
	{ 0x4294, 0x234d6c },
	{ 0x4295, 0x234d69 },
	{ 0x4296, 0x234d6a },
	{ 0x4297, 0x244c37 },
	{ 0x4298, 0x272657 },
	{ 0x4299, 0x244c35 },
	{ 0x429a, 0x235236 },
	{ 0x429b, 0x24576d },
	{ 0x429c, 0x235573 },
	{ 0x429d, 0x235572 },
	{ 0x429e, 0x245769 },
	{ 0x429f, 0x24576a },
	{ 0x42a0, 0x234d74 },
	{ 0x42a1, 0x24576b },
	{ 0x42a3, 0x25634e },
	{ 0x42a4, 0x245c56 },
	{ 0x42a5, 0x235852 },
	{ 0x42a6, 0x245c55 },
	{ 0x42a7, 0x245c54 },
	{ 0x42a8, 0x256354 },
	{ 0x42a9, 0x235853 },
	{ 0x42aa, 0x235a70 },
	{ 0x42ab, 0x24605b },
	{ 0x42ac, 0x24605d },
	{ 0x42ad, 0x246423 },
	{ 0x42ae, 0x235c68 },
	{ 0x42af, 0x27543a },
	{ 0x42b0, 0x257070 },
	{ 0x42b1, 0x246a65 },
	{ 0x42b2, 0x257639 },
	{ 0x42b3, 0x246c7a },
	{ 0x42b4, 0x236145 },
	{ 0x42b5, 0x24275c },
	{ 0x42b6, 0x263364 },
	{ 0x42b7, 0x232e57 },
	{ 0x42b8, 0x232e55 },
	{ 0x42b9, 0x232e58 },
	{ 0x42ba, 0x242e78 },
	{ 0x42bb, 0x242e7e },
	{ 0x42bc, 0x233335 },
	{ 0x42bd, 0x233334 },
	{ 0x42be, 0x242e7c },
	{ 0x42bf, 0x233339 },
	{ 0x42c0, 0x242f21 },
	{ 0x42c1, 0x233338 },
	{ 0x42c2, 0x242e7d },
	{ 0x42c3, 0x233336 },
	{ 0x42c4, 0x23333a },
	{ 0x42c8, 0x24342e },
	{ 0x42c9, 0x243426 },
	{ 0x42ca, 0x233823 },
	{ 0x42cb, 0x23382a },
	{ 0x42cc, 0x243427 },
	{ 0x42cd, 0x243430 },
	{ 0x42ce, 0x23382c },
	{ 0x42cf, 0x24342d },
	{ 0x42d0, 0x24342b },
	{ 0x42d1, 0x243429 },
	{ 0x42d2, 0x233828 },
	{ 0x42d3, 0x23382d },
	{ 0x42d4, 0x233825 },
	{ 0x42d5, 0x233e36 },
	{ 0x42d6, 0x253b2c },
	{ 0x42d7, 0x233e2d },
	{ 0x42d8, 0x233e32 },
	{ 0x42d9, 0x233e27 },
	{ 0x42da, 0x233e30 },
	{ 0x42db, 0x233e25 },
	{ 0x42dc, 0x264c71 },
	{ 0x42de, 0x233e31 },
	{ 0x42df, 0x243f6a },
	{ 0x42e0, 0x234365 },
	{ 0x42e1, 0x23436b },
	{ 0x42e2, 0x243f6e },
	{ 0x42e3, 0x243f73 },
	{ 0x42e4, 0x243f6f },
	{ 0x42e5, 0x234361 },
	{ 0x42e6, 0x23435d },
	{ 0x42e7, 0x23486c },
	{ 0x42e8, 0x244575 },
	{ 0x42e9, 0x24457e },
	{ 0x42ea, 0x244579 },
	{ 0x42eb, 0x244621 },
	{ 0x42ec, 0x234867 },
	{ 0x42ed, 0x23435f },
	{ 0x42ee, 0x234872 },
	{ 0x42ef, 0x234875 },
	{ 0x42f0, 0x244623 },
	{ 0x42f1, 0x254854 },
	{ 0x42f2, 0x23486f },
	{ 0x42f3, 0x234e2a },
	{ 0x42f4, 0x254f53 },
	{ 0x42f5, 0x244c3e },
	{ 0x42f6, 0x244c3c },
	{ 0x42f7, 0x244c40 },
	{ 0x42f8, 0x234d7b },
	{ 0x42f9, 0x234e21 },
	{ 0x42fa, 0x234e2d },
	{ 0x42fb, 0x234d76 },
	{ 0x42fc, 0x234d79 },
	{ 0x42fd, 0x244c3a },
	{ 0x42fe, 0x244c3d },
	{ 0x42ff, 0x244c3f },
	{ 0x4300, 0x234d7a },
	{ 0x4301, 0x244c44 },
	{ 0x4302, 0x254f54 },
	{ 0x4303, 0x234e26 },
	{ 0x4304, 0x234e23 },
	{ 0x4305, 0x23523a },
	{ 0x4306, 0x245249 },
	{ 0x4307, 0x23523c },
	{ 0x4308, 0x245247 },
	{ 0x4309, 0x23523d },
	{ 0x430a, 0x23523e },
	{ 0x430c, 0x245773 },
	{ 0x430d, 0x235578 },
	{ 0x430e, 0x255d3f },
	{ 0x430f, 0x235576 },
	{ 0x4310, 0x255d46 },
	{ 0x4311, 0x235577 },
	{ 0x4312, 0x24576e },
	{ 0x4313, 0x23557c },
	{ 0x4314, 0x23557b },
	{ 0x4315, 0x273a39 },
	{ 0x4316, 0x245c62 },
	{ 0x4317, 0x245c60 },
	{ 0x4318, 0x245772 },
	{ 0x4319, 0x235857 },
	{ 0x431a, 0x235856 },
	{ 0x431b, 0x235929 },
	{ 0x431c, 0x246066 },
	{ 0x431d, 0x246063 },
	{ 0x431e, 0x246068 },
	{ 0x431f, 0x246062 },
	{ 0x4320, 0x27474a },
	{ 0x4321, 0x235a73 },
	{ 0x4322, 0x235a71 },
	{ 0x4323, 0x256d22 },
	{ 0x4324, 0x235c69 },
	{ 0x4325, 0x246424 },
	{ 0x4326, 0x235c6a },
	{ 0x4327, 0x235c6b },
	{ 0x4328, 0x235e4f },
	{ 0x4329, 0x235e4e },
	{ 0x432a, 0x24692a },
	{ 0x432b, 0x275858 },
	{ 0x432c, 0x235f59 },
	{ 0x432d, 0x24692b },
	{ 0x432e, 0x246a66 },
	{ 0x432f, 0x246b79 },
	{ 0x4330, 0x246b78 },
	{ 0x4331, 0x275f33 },
	{ 0x4332, 0x236078 },
	{ 0x4333, 0x246c7c },
	{ 0x4334, 0x246c7b },
	{ 0x4335, 0x246d77 },
	{ 0x4342, 0x242a79 },
	{ 0x4343, 0x242f29 },
	{ 0x4344, 0x23382f },
	{ 0x4345, 0x233832 },
	{ 0x4346, 0x253460 },
	{ 0x4347, 0x243434 },
	{ 0x4348, 0x233830 },
	{ 0x4349, 0x243433 },
	{ 0x434a, 0x243a28 },
	{ 0x434b, 0x244625 },
	{ 0x434c, 0x234876 },
	{ 0x434d, 0x24524e },
	{ 0x434e, 0x246a6b },
	{ 0x434f, 0x2f2147 },
	{ 0x4350, 0x232a4d },
	{ 0x4351, 0x232e5c },
	{ 0x4352, 0x232e5b },
	{ 0x4353, 0x232e59 },
	{ 0x4354, 0x242a7b },
	{ 0x4355, 0x242f2a },
	{ 0x4356, 0x263a6b },
	{ 0x4357, 0x242f2d },
	{ 0x4358, 0x243435 },
	{ 0x4359, 0x243f75 },
	{ 0x435a, 0x243a2a },
	{ 0x435b, 0x23436c },
	{ 0x435c, 0x23436d },
	{ 0x435d, 0x254165 },
	{ 0x435e, 0x23487a },
	{ 0x435f, 0x23487b },
	{ 0x4361, 0x24524f },
	{ 0x4362, 0x245775 },
	{ 0x4363, 0x245c65 },
	{ 0x4364, 0x24606d },
	{ 0x4365, 0x24667b },
	{ 0x4366, 0x246b7b },
	{ 0x4367, 0x263a74 },
	{ 0x4368, 0x242f2e },
	{ 0x4369, 0x23313f },
	{ 0x436a, 0x243438 },
	{ 0x436b, 0x243436 },
	{ 0x436c, 0x243437 },
	{ 0x436d, 0x26433c },
	{ 0x436e, 0x243a2d },
	{ 0x436f, 0x243a31 },
	{ 0x4370, 0x243a30 },
	{ 0x4371, 0x243f76 },
	{ 0x4372, 0x23487e },
	{ 0x4373, 0x244627 },
	{ 0x4374, 0x23487d },
	{ 0x4375, 0x244628 },
	{ 0x4376, 0x23487c },
	{ 0x4377, 0x244c49 },
	{ 0x4378, 0x245253 },
	{ 0x4379, 0x235241 },
	{ 0x437a, 0x245777 },
	{ 0x437b, 0x245c6a },
	{ 0x437c, 0x245c6b },
	{ 0x437d, 0x24692c },
	{ 0x437e, 0x233340 },
	{ 0x437f, 0x233341 },
	{ 0x4380, 0x24343a },
	{ 0x4381, 0x233833 },
	{ 0x4382, 0x24343b },
	{ 0x4383, 0x24343e },
	{ 0x4384, 0x24343c },
	{ 0x4385, 0x233835 },
	{ 0x4386, 0x233834 },
	{ 0x4387, 0x243a34 },
	{ 0x4388, 0x243a35 },
	{ 0x4389, 0x253b3a },
	{ 0x438a, 0x243a33 },
	{ 0x438b, 0x234370 },
	{ 0x438c, 0x243f78 },
	{ 0x438d, 0x234371 },
	{ 0x438e, 0x243f77 },
	{ 0x438f, 0x23436f },
	{ 0x4390, 0x234921 },
	{ 0x4391, 0x24462a },
	{ 0x4392, 0x244629 },
	{ 0x4393, 0x24462b },
	{ 0x4394, 0x245255 },
	{ 0x4395, 0x245256 },
	{ 0x4396, 0x23585e },
	{ 0x4397, 0x235860 },
	{ 0x4398, 0x23585f },
	{ 0x4399, 0x235c6e },
	{ 0x439a, 0x24667d },
	{ 0x439c, 0x233e39 },
	{ 0x439d, 0x233e3a },
	{ 0x439f, 0x242b27 },
	{ 0x43a0, 0x242b28 },
	{ 0x43a1, 0x242f38 },
	{ 0x43a2, 0x242b29 },
	{ 0x43a3, 0x233838 },
	{ 0x43a4, 0x243f7a },
	{ 0x43a6, 0x24462e },
	{ 0x43a7, 0x24462d },
	{ 0x43a8, 0x24462f },
	{ 0x43a9, 0x244632 },
	{ 0x43aa, 0x244630 },
	{ 0x43ab, 0x244c4f },
	{ 0x43ad, 0x24577d },
	{ 0x43ae, 0x24577a },
	{ 0x43af, 0x24577b },
	{ 0x43b0, 0x245c70 },
	{ 0x43b1, 0x246721 },
	{ 0x43b2, 0x24246d },
	{ 0x43b3, 0x233346 },
	{ 0x43b4, 0x233345 },
	{ 0x43b5, 0x23383a },
	{ 0x43b6, 0x243441 },
	{ 0x43b7, 0x243a39 },
	{ 0x43b8, 0x254170 },
	{ 0x43b9, 0x234374 },
	{ 0x43ba, 0x244636 },
	{ 0x43bb, 0x244634 },
	{ 0x43bc, 0x244635 },
	{ 0x43bd, 0x244637 },
	{ 0x43be, 0x234924 },
	{ 0x43bf, 0x234e33 },
	{ 0x43c0, 0x244c52 },
	{ 0x43c1, 0x24525a },
	{ 0x43c2, 0x235242 },
	{ 0x43c3, 0x24525b },
	{ 0x43c4, 0x245821 },
	{ 0x43c5, 0x245824 },
	{ 0x43c6, 0x245823 },
	{ 0x43c7, 0x245822 },
	{ 0x43c8, 0x235864 },
	{ 0x43c9, 0x246428 },
	{ 0x43ca, 0x235f5c },
	{ 0x43cb, 0x26566d },
	{ 0x43cc, 0x24232d },
	{ 0x43cd, 0x262549 },
	{ 0x43ce, 0x24246f },
	{ 0x43cf, 0x24246e },
	{ 0x43d0, 0x232a51 },
	{ 0x43d1, 0x263b28 },
	{ 0x43d2, 0x232a55 },
	{ 0x43d3, 0x232a50 },
	{ 0x43d4, 0x242766 },
	{ 0x43d5, 0x2f2852 },
	{ 0x43d6, 0x242762 },
	{ 0x43d7, 0x242767 },
	{ 0x43d8, 0x242763 },
	{ 0x43d9, 0x242765 },
	{ 0x43da, 0x252758 },
	{ 0x43db, 0x232a5a },
	{ 0x43dc, 0x232a53 },
	{ 0x43de, 0x252b33 },
	{ 0x43df, 0x242b2f },
	{ 0x43e0, 0x242b2a },
	{ 0x43e1, 0x242b2c },
	{ 0x43e2, 0x232e62 },
	{ 0x43e3, 0x232e5f },
	{ 0x43e4, 0x26337d },
	{ 0x43e5, 0x252b39 },
	{ 0x43e6, 0x233351 },
	{ 0x43e7, 0x242f41 },
	{ 0x43e8, 0x242f46 },
	{ 0x43e9, 0x242f47 },
	{ 0x43ea, 0x242f3f },
	{ 0x43eb, 0x263b31 },
	{ 0x43ec, 0x252f6d },
	{ 0x43ef, 0x233846 },
	{ 0x43f0, 0x24344c },
	{ 0x43f1, 0x243448 },
	{ 0x43f2, 0x233844 },
	{ 0x43f3, 0x24344b },
	{ 0x43f4, 0x243452 },
	{ 0x43f5, 0x243451 },
	{ 0x43f6, 0x24344a },
	{ 0x43f7, 0x243453 },
	{ 0x43f8, 0x264358 },
	{ 0x43f9, 0x233840 },
	{ 0x43fa, 0x23383f },
	{ 0x43fb, 0x233843 },
	{ 0x43fc, 0x243a49 },
	{ 0x43fd, 0x243a3a },
	{ 0x43fe, 0x233e3f },
	{ 0x43ff, 0x243a45 },
	{ 0x4400, 0x253b4d },
	{ 0x4401, 0x243a4a },
	{ 0x4402, 0x243a41 },
	{ 0x4403, 0x243a40 },
	{ 0x4404, 0x243a42 },
	{ 0x4405, 0x243a3d },
	{ 0x4407, 0x233e46 },
	{ 0x4408, 0x243a3f },
	{ 0x4409, 0x243a44 },
	{ 0x440a, 0x243a4b },
	{ 0x440b, 0x26497e },
	{ 0x440c, 0x264d54 },
	{ 0x440d, 0x265676 },
	{ 0x440e, 0x244027 },
	{ 0x440f, 0x234378 },
	{ 0x4410, 0x24402a },
	{ 0x4411, 0x244023 },
	{ 0x4412, 0x244026 },
	{ 0x4413, 0x23437a },
	{ 0x4414, 0x243f7d },
	{ 0x4415, 0x244028 },
	{ 0x4416, 0x234421 },
	{ 0x4417, 0x24402c },
	{ 0x4418, 0x23437d },
	{ 0x4419, 0x234379 },
	{ 0x441a, 0x25346a },
	{ 0x441b, 0x244025 },
	{ 0x441c, 0x244645 },
	{ 0x441d, 0x24463e },
	{ 0x441e, 0x24463c },
	{ 0x441f, 0x24463d },
	{ 0x4420, 0x24463f },
	{ 0x4421, 0x235248 },
	{ 0x4422, 0x244642 },
	{ 0x4423, 0x244640 },
	{ 0x4424, 0x24463b },
	{ 0x4425, 0x234929 },
	{ 0x4426, 0x234928 },
	{ 0x4427, 0x244638 },
	{ 0x4428, 0x244647 },
	{ 0x4429, 0x244641 },
	{ 0x442b, 0x244c5d },
	{ 0x442c, 0x244c58 },
	{ 0x442d, 0x244c5e },
	{ 0x442e, 0x244c55 },
	{ 0x442f, 0x244c5c },
	{ 0x4430, 0x26606f },
	{ 0x4431, 0x244c54 },
	{ 0x4432, 0x244c5b },
	{ 0x4433, 0x244c5f },
	{ 0x4434, 0x254228 },
	{ 0x4435, 0x245263 },
	{ 0x4436, 0x245264 },
	{ 0x4437, 0x235246 },
	{ 0x4438, 0x235245 },
	{ 0x4439, 0x24525e },
	{ 0x443a, 0x245261 },
	{ 0x443b, 0x245262 },
	{ 0x443c, 0x245266 },
	{ 0x443d, 0x2f5155 },
	{ 0x443e, 0x255d5b },
	{ 0x443f, 0x24582b },
	{ 0x4440, 0x245828 },
	{ 0x4441, 0x24582c },
	{ 0x4442, 0x245c74 },
	{ 0x4443, 0x235866 },
	{ 0x4444, 0x245c76 },
	{ 0x4445, 0x235867 },
	{ 0x4446, 0x235a76 },
	{ 0x4447, 0x246074 },
	{ 0x4448, 0x246073 },
	{ 0x4449, 0x256d2c },
	{ 0x444a, 0x24642a },
	{ 0x444b, 0x246722 },
	{ 0x444c, 0x246724 },
	{ 0x444d, 0x246723 },
	{ 0x444e, 0x246725 },
	{ 0x444f, 0x246930 },
	{ 0x4450, 0x264364 },
	{ 0x4451, 0x274224 },
	{ 0x4452, 0x232b44 },
	{ 0x4453, 0x234424 },
	{ 0x4454, 0x242f4a },
	{ 0x4455, 0x243458 },
	{ 0x4457, 0x244c63 },
	{ 0x4458, 0x24526b },
	{ 0x4459, 0x233353 },
	{ 0x445a, 0x233354 },
	{ 0x445b, 0x23384a },
	{ 0x445c, 0x244c64 },
	{ 0x445d, 0x266121 },
	{ 0x445e, 0x23524b },
	{ 0x445f, 0x235e54 },
	{ 0x4460, 0x24276f },
	{ 0x4461, 0x242b33 },
	{ 0x4462, 0x242b32 },
	{ 0x4463, 0x232e67 },
	{ 0x4464, 0x233356 },
	{ 0x4465, 0x242f50 },
	{ 0x4466, 0x23384b },
	{ 0x4467, 0x264371 },
	{ 0x4468, 0x264370 },
	{ 0x446a, 0x233e4a },
	{ 0x446b, 0x243a4e },
	{ 0x446c, 0x243a4f },
	{ 0x446d, 0x264d63 },
	{ 0x446f, 0x25422d },
	{ 0x4470, 0x24402f },
	{ 0x4471, 0x24464f },
	{ 0x4472, 0x244651 },
	{ 0x4473, 0x244650 },
	{ 0x4474, 0x23492c },
	{ 0x4475, 0x266124 },
	{ 0x4476, 0x25492c },
	{ 0x4479, 0x234e3e },
	{ 0x447a, 0x244c68 },
	{ 0x447b, 0x244c65 },
	{ 0x447c, 0x24526c },
	{ 0x447d, 0x24526d },
	{ 0x447f, 0x245830 },
	{ 0x4480, 0x245834 },
	{ 0x4481, 0x245833 },
	{ 0x4482, 0x235625 },
	{ 0x4483, 0x235626 },
	{ 0x4484, 0x255d67 },
	{ 0x4485, 0x255c4d },
	{ 0x4486, 0x245832 },
	{ 0x4488, 0x245c7c },
	{ 0x4489, 0x24642d },
	{ 0x448a, 0x242f53 },
	{ 0x448b, 0x24345c },
	{ 0x448c, 0x24526f },
	{ 0x448d, 0x24526e },
	{ 0x448e, 0x245835 },
	{ 0x448f, 0x245c7d },
	{ 0x4490, 0x246933 },
	{ 0x4492, 0x26254f },
	{ 0x4493, 0x232437 },
	{ 0x4494, 0x232439 },
	{ 0x4495, 0x232727 },
	{ 0x4496, 0x242476 },
	{ 0x4497, 0x24247d },
	{ 0x4498, 0x23272c },
	{ 0x449a, 0x232a63 },
	{ 0x449b, 0x232a67 },
	{ 0x449c, 0x232a64 },
	{ 0x449d, 0x232a6a },
	{ 0x449e, 0x242772 },
	{ 0x449f, 0x232a62 },
	{ 0x44a0, 0x242821 },
	{ 0x44a1, 0x242773 },
	{ 0x44a2, 0x232a65 },
	{ 0x44a3, 0x232a69 },
	{ 0x44a4, 0x252763 },
	{ 0x44a5, 0x232a61 },
	{ 0x44a6, 0x232e6d },
	{ 0x44a7, 0x242b36 },
	{ 0x44a8, 0x232e70 },
	{ 0x44a9, 0x232e71 },
	{ 0x44aa, 0x232e6c },
	{ 0x44ab, 0x232e73 },
	{ 0x44ac, 0x232e75 },
	{ 0x44ad, 0x26343a },
	{ 0x44b0, 0x242f55 },
	{ 0x44b1, 0x233361 },
	{ 0x44b2, 0x242f61 },
	{ 0x44b3, 0x233364 },
	{ 0x44b4, 0x23335b },
	{ 0x44b5, 0x23335e },
	{ 0x44b6, 0x263b56 },
	{ 0x44b7, 0x23335d },
	{ 0x44b8, 0x242f5e },
	{ 0x44b9, 0x23335c },
	{ 0x44ba, 0x233365 },
	{ 0x44bb, 0x253021 },
	{ 0x44bc, 0x242f59 },
	{ 0x44bd, 0x242f64 },
	{ 0x44c1, 0x233360 },
	{ 0x44c2, 0x24345e },
	{ 0x44c3, 0x24346c },
	{ 0x44c4, 0x243471 },
	{ 0x44c5, 0x23385a },
	{ 0x44c6, 0x243469 },
	{ 0x44c7, 0x243465 },
	{ 0x44c8, 0x233856 },
	{ 0x44c9, 0x243466 },
	{ 0x44ca, 0x243462 },
	{ 0x44cb, 0x24345d },
	{ 0x44cc, 0x243463 },
	{ 0x44cd, 0x26442c },
	{ 0x44ce, 0x23384c },
	{ 0x44cf, 0x264428 },
	{ 0x44d0, 0x25352a },
	{ 0x44d1, 0x233859 },
	{ 0x44d2, 0x23385c },
	{ 0x44d3, 0x253524 },
	{ 0x44d7, 0x243a6c },
	{ 0x44d8, 0x243a60 },
	{ 0x44d9, 0x243a5f },
	{ 0x44da, 0x243a64 },
	{ 0x44db, 0x243a59 },
	{ 0x44dc, 0x253b56 },
	{ 0x44dd, 0x243a5b },
	{ 0x44de, 0x243a56 },
	{ 0x44df, 0x233e53 },
	{ 0x44e0, 0x243a5e },
	{ 0x44e1, 0x233e54 },
	{ 0x44e2, 0x233e51 },
	{ 0x44e3, 0x243a5c },
	{ 0x44e4, 0x243a61 },
	{ 0x44e5, 0x233e55 },
	{ 0x44e6, 0x264e27 },
	{ 0x44e7, 0x233e4c },
	{ 0x44ea, 0x2f3e6b },
	{ 0x44ed, 0x244030 },
	{ 0x44ee, 0x244032 },
	{ 0x44ef, 0x243a65 },
	{ 0x44f0, 0x234437 },
	{ 0x44f1, 0x244669 },
	{ 0x44f2, 0x244047 },
	{ 0x44f3, 0x244049 },
	{ 0x44f4, 0x24403a },
	{ 0x44f5, 0x23442b },
	{ 0x44f6, 0x234429 },
	{ 0x44f7, 0x234434 },
	{ 0x44f8, 0x244048 },
	{ 0x44f9, 0x23443d },
	{ 0x44fa, 0x24404c },
	{ 0x44fc, 0x244665 },
	{ 0x44fd, 0x23492f },
	{ 0x44fe, 0x244657 },
	{ 0x44ff, 0x266144 },
	{ 0x4500, 0x244664 },
	{ 0x4501, 0x234931 },
	{ 0x4502, 0x244653 },
	{ 0x4503, 0x25493c },
	{ 0x4504, 0x244661 },
	{ 0x4505, 0x234930 },
	{ 0x4506, 0x24466d },
	{ 0x4507, 0x244660 },
	{ 0x4508, 0x24465c },
	{ 0x4509, 0x234934 },
	{ 0x450a, 0x25493b },
	{ 0x450b, 0x266158 },
	{ 0x450c, 0x234937 },
	{ 0x450d, 0x234940 },
	{ 0x450e, 0x234e43 },
	{ 0x450f, 0x244c72 },
	{ 0x4510, 0x234e3f },
	{ 0x4511, 0x244c70 },
	{ 0x4512, 0x244d24 },
	{ 0x4513, 0x244c6b },
	{ 0x4514, 0x234e41 },
	{ 0x4515, 0x244c71 },
	{ 0x4516, 0x234e53 },
	{ 0x4517, 0x244c6d },
	{ 0x4518, 0x244c73 },
	{ 0x4519, 0x234e47 },
	{ 0x451a, 0x234e45 },
	{ 0x451b, 0x234e56 },
	{ 0x451c, 0x244c7d },
	{ 0x451d, 0x235251 },
	{ 0x451e, 0x244c6c },
	{ 0x451f, 0x234e4a },
	{ 0x4520, 0x244c6e },
	{ 0x4521, 0x234e48 },
	{ 0x4522, 0x234e55 },
	{ 0x4523, 0x234e49 },
	{ 0x4524, 0x255046 },
	{ 0x4525, 0x234e50 },
	{ 0x4526, 0x2f5165 },
	{ 0x4527, 0x2f5173 },
	{ 0x4528, 0x2f5176 },
	{ 0x4529, 0x244d21 },
	{ 0x452a, 0x244c6f },
	{ 0x452b, 0x234e51 },
	{ 0x452c, 0x244c77 },
	{ 0x452d, 0x245277 },
	{ 0x452e, 0x24527b },
	{ 0x452f, 0x245279 },
	{ 0x4530, 0x24532c },
	{ 0x4531, 0x245321 },
	{ 0x4532, 0x245276 },
	{ 0x4533, 0x235253 },
	{ 0x4534, 0x245325 },
	{ 0x4535, 0x235257 },
	{ 0x4536, 0x24527e },
	{ 0x4537, 0x23524d },
	{ 0x4538, 0x245323 },
	{ 0x4539, 0x24527a },
	{ 0x453a, 0x24527c },
	{ 0x453b, 0x245272 },
	{ 0x453c, 0x25642d },
	{ 0x453d, 0x23524c },
	{ 0x453e, 0x245322 },
	{ 0x453f, 0x245273 },
	{ 0x4540, 0x23524e },
	{ 0x4541, 0x245327 },
	{ 0x4543, 0x245331 },
	{ 0x4544, 0x244667 },
	{ 0x4545, 0x245844 },
	{ 0x4546, 0x24583c },
	{ 0x4547, 0x245838 },
	{ 0x4548, 0x245842 },
	{ 0x4549, 0x255d79 },
	{ 0x454a, 0x245836 },
	{ 0x454b, 0x24583b },
	{ 0x454c, 0x23562e },
	{ 0x454d, 0x235627 },
	{ 0x454e, 0x24583d },
	{ 0x454f, 0x23562a },
	{ 0x4551, 0x23562f },
	{ 0x4552, 0x235869 },
	{ 0x4553, 0x245c7e },
	{ 0x4554, 0x245d2b },
	{ 0x4555, 0x23586d },
	{ 0x4556, 0x235870 },
	{ 0x4557, 0x23586a },
	{ 0x4558, 0x235871 },
	{ 0x4559, 0x245d23 },
	{ 0x455a, 0x274238 },
	{ 0x455b, 0x245d21 },
	{ 0x455c, 0x2f604e },
	{ 0x455d, 0x273b32 },
	{ 0x455e, 0x246077 },
	{ 0x455f, 0x235c73 },
	{ 0x4560, 0x235b23 },
	{ 0x4561, 0x246078 },
	{ 0x4562, 0x235b21 },
	{ 0x4564, 0x235b24 },
	{ 0x4565, 0x274953 },
	{ 0x4566, 0x24642f },
	{ 0x4567, 0x246434 },
	{ 0x4568, 0x235c7d },
	{ 0x4569, 0x246433 },
	{ 0x456a, 0x235c74 },
	{ 0x456b, 0x275468 },
	{ 0x456c, 0x235c79 },
	{ 0x456d, 0x246432 },
	{ 0x456e, 0x246438 },
	{ 0x456f, 0x235c7a },
	{ 0x4570, 0x246430 },
	{ 0x4571, 0x235c75 },
	{ 0x4572, 0x246436 },
	{ 0x4573, 0x246727 },
	{ 0x4574, 0x235e59 },
	{ 0x4575, 0x246728 },
	{ 0x4577, 0x2f6839 },
	{ 0x4578, 0x235f5d },
	{ 0x4579, 0x246937 },
	{ 0x457a, 0x275872 },
	{ 0x457b, 0x236041 },
	{ 0x457c, 0x236042 },
	{ 0x457d, 0x257825 },
	{ 0x457e, 0x246b7d },
	{ 0x457f, 0x246d5e },
	{ 0x4580, 0x246c7d },
	{ 0x4581, 0x23616a },
	{ 0x4582, 0x246d79 },
	{ 0x4583, 0x246d7b },
	{ 0x4584, 0x2f6c6c },
	{ 0x4585, 0x246e37 },
	{ 0x4586, 0x246e36 },
	{ 0x4587, 0x257c3e },
	{ 0x4588, 0x232a6d },
	{ 0x4589, 0x242b3e },
	{ 0x458a, 0x242f67 },
	{ 0x458b, 0x233367 },
	{ 0x458c, 0x233366 },
	{ 0x458d, 0x233368 },
	{ 0x458e, 0x253535 },
	{ 0x458f, 0x233862 },
	{ 0x4590, 0x253b70 },
	{ 0x4591, 0x233e60 },
	{ 0x4592, 0x234441 },
	{ 0x4593, 0x254254 },
	{ 0x4594, 0x254253 },
	{ 0x4595, 0x234442 },
	{ 0x4596, 0x234443 },
	{ 0x4597, 0x244d26 },
	{ 0x4598, 0x245336 },
	{ 0x4599, 0x245d32 },
	{ 0x459a, 0x25643b },
	{ 0x459b, 0x25643a },
	{ 0x459c, 0x24643a },
	{ 0x459d, 0x23272e },
	{ 0x459e, 0x232e7d },
	{ 0x459f, 0x232f21 },
	{ 0x45a0, 0x232f22 },
	{ 0x45a1, 0x242f69 },
	{ 0x45a2, 0x242f6b },
	{ 0x45a3, 0x263b69 },
	{ 0x45a4, 0x233868 },
	{ 0x45a5, 0x233867 },
	{ 0x45a6, 0x24347c },
	{ 0x45a7, 0x233865 },
	{ 0x45a8, 0x24347b },
	{ 0x45a9, 0x243479 },
	{ 0x45aa, 0x253c26 },
	{ 0x45ab, 0x264448 },
	{ 0x45ad, 0x243a72 },
	{ 0x45ae, 0x233e67 },
	{ 0x45af, 0x243a74 },
	{ 0x45b0, 0x233e65 },
	{ 0x45b1, 0x253b74 },
	{ 0x45b2, 0x243a70 },
	{ 0x45b3, 0x243a6d },
	{ 0x45b4, 0x233e64 },
	{ 0x45b5, 0x233e66 },
	{ 0x45b6, 0x244056 },
	{ 0x45b7, 0x244057 },
	{ 0x45b8, 0x23444b },
	{ 0x45b9, 0x234447 },
	{ 0x45ba, 0x24405b },
	{ 0x45bb, 0x243a6e },
	{ 0x45bc, 0x24405d },
	{ 0x45bd, 0x23444a },
	{ 0x45bf, 0x244678 },
	{ 0x45c0, 0x234946 },
	{ 0x45c1, 0x244672 },
	{ 0x45c2, 0x244673 },
	{ 0x45c3, 0x244671 },
	{ 0x45c4, 0x244675 },
	{ 0x45c5, 0x234947 },
	{ 0x45c6, 0x244670 },
	{ 0x45c7, 0x244676 },
	{ 0x45c8, 0x266169 },
	{ 0x45c9, 0x234948 },
	{ 0x45ca, 0x24467b },
	{ 0x45cb, 0x234e5a },
	{ 0x45cc, 0x234e5c },
	{ 0x45cd, 0x272842 },
	{ 0x45ce, 0x234e57 },
	{ 0x45cf, 0x234e58 },
	{ 0x45d0, 0x244d30 },
	{ 0x45d1, 0x234e5b },
	{ 0x45d2, 0x244679 },
	{ 0x45d3, 0x244d36 },
	{ 0x45d4, 0x244d2f },
	{ 0x45d5, 0x23494d },
	{ 0x45d7, 0x24533e },
	{ 0x45d8, 0x23525c },
	{ 0x45d9, 0x273273 },
	{ 0x45da, 0x24533d },
	{ 0x45db, 0x24584d },
	{ 0x45dc, 0x235260 },
	{ 0x45dd, 0x273275 },
	{ 0x45de, 0x235261 },
	{ 0x45df, 0x255e32 },
	{ 0x45e0, 0x245857 },
	{ 0x45e1, 0x245852 },
	{ 0x45e2, 0x235637 },
	{ 0x45e3, 0x245858 },
	{ 0x45e4, 0x24584f },
	{ 0x45e5, 0x245856 },
	{ 0x45e6, 0x235638 },
	{ 0x45e7, 0x24584e },
	{ 0x45e8, 0x235632 },
	{ 0x45e9, 0x245854 },
	{ 0x45ea, 0x24585f },
	{ 0x45eb, 0x235635 },
	{ 0x45ec, 0x23563c },
	{ 0x45ee, 0x235631 },
	{ 0x45ef, 0x245d3b },
	{ 0x45f0, 0x255e35 },
	{ 0x45f1, 0x245d39 },
	{ 0x45f2, 0x235872 },
	{ 0x45f4, 0x246124 },
	{ 0x45f5, 0x256941 },
	{ 0x45f6, 0x235b2a },
	{ 0x45f7, 0x246121 },
	{ 0x45f8, 0x246125 },
	{ 0x45f9, 0x2f636e },
	{ 0x45fa, 0x256d4b },
	{ 0x45fc, 0x24643b },
	{ 0x45fd, 0x24643c },
	{ 0x45fe, 0x246440 },
	{ 0x45ff, 0x24643e },
	{ 0x4600, 0x246441 },
	{ 0x4601, 0x235d26 },
	{ 0x4602, 0x235e5e },
	{ 0x4603, 0x246730 },
	{ 0x4604, 0x24643d },
	{ 0x4605, 0x24693e },
	{ 0x4606, 0x235f5e },
	{ 0x4607, 0x235f60 },
	{ 0x4608, 0x236044 },
	{ 0x4609, 0x275925 },
	{ 0x460a, 0x275c5e },
	{ 0x460b, 0x246a78 },
	{ 0x460c, 0x275c63 },
	{ 0x460d, 0x236148 },
	{ 0x460e, 0x246e39 },
	{ 0x460f, 0x232f25 },
	{ 0x4610, 0x263b73 },
	{ 0x4611, 0x233869 },
	{ 0x4612, 0x23444c },
	{ 0x4613, 0x244723 },
	{ 0x4614, 0x244d37 },
	{ 0x4615, 0x242f6f },
	{ 0x4616, 0x243a78 },
	{ 0x4617, 0x234e5e },
	{ 0x4618, 0x24534a },
	{ 0x4619, 0x235b2e },
	{ 0x461a, 0x232a6e },
	{ 0x461c, 0x232f28 },
	{ 0x461d, 0x242b46 },
	{ 0x461f, 0x25303d },
	{ 0x4620, 0x242f72 },
	{ 0x4621, 0x253039 },
	{ 0x4622, 0x24352a },
	{ 0x4623, 0x243a7a },
	{ 0x4624, 0x24352d },
	{ 0x4625, 0x24352e },
	{ 0x4626, 0x24352c },
	{ 0x4627, 0x2f3251 },
	{ 0x4628, 0x243a79 },
	{ 0x4629, 0x233e71 },
	{ 0x462a, 0x243530 },
	{ 0x462b, 0x233e6e },
	{ 0x462c, 0x233e6c },
	{ 0x462d, 0x233e6b },
	{ 0x462e, 0x232f4a },
	{ 0x462f, 0x244062 },
	{ 0x4630, 0x244725 },
	{ 0x4631, 0x26582b },
	{ 0x4633, 0x234953 },
	{ 0x4634, 0x24472d },
	{ 0x4635, 0x25496c },
	{ 0x4636, 0x25496d },
	{ 0x4637, 0x244066 },
	{ 0x4638, 0x244731 },
	{ 0x4639, 0x244727 },
	{ 0x463a, 0x234955 },
	{ 0x463b, 0x244060 },
	{ 0x463c, 0x24472a },
	{ 0x463d, 0x24472e },
	{ 0x463e, 0x244726 },
	{ 0x463f, 0x24472b },
	{ 0x4640, 0x23495a },
	{ 0x4641, 0x234950 },
	{ 0x4642, 0x23495b },
	{ 0x4643, 0x244d3c },
	{ 0x4644, 0x244d3f },
	{ 0x4645, 0x244d3a },
	{ 0x4646, 0x244d39 },
	{ 0x4647, 0x244d42 },
	{ 0x4648, 0x244d40 },
	{ 0x4649, 0x244d47 },
	{ 0x464e, 0x245352 },
	{ 0x464f, 0x245355 },
	{ 0x4650, 0x245356 },
	{ 0x4651, 0x234e63 },
	{ 0x4652, 0x24534f },
	{ 0x4654, 0x245863 },
	{ 0x4655, 0x245867 },
	{ 0x4656, 0x235645 },
	{ 0x4657, 0x235643 },
	{ 0x4658, 0x245864 },
	{ 0x4659, 0x23563e },
	{ 0x465a, 0x273b59 },
	{ 0x465b, 0x235644 },
	{ 0x465c, 0x245865 },
	{ 0x465d, 0x235641 },
	{ 0x465e, 0x256456 },
	{ 0x465f, 0x245d4a },
	{ 0x4660, 0x245d48 },
	{ 0x4661, 0x245d49 },
	{ 0x4662, 0x245d44 },
	{ 0x4663, 0x245d46 },
	{ 0x4664, 0x24612a },
	{ 0x4665, 0x274322 },
	{ 0x4666, 0x246443 },
	{ 0x4667, 0x275025 },
	{ 0x4668, 0x235d27 },
	{ 0x4669, 0x246444 },
	{ 0x466a, 0x235e5f },
	{ 0x466c, 0x246a7b },
	{ 0x466d, 0x275932 },
	{ 0x466e, 0x23607a },
	{ 0x466f, 0x246c26 },
	{ 0x4670, 0x236079 },
	{ 0x4671, 0x246d7d },
	{ 0x4672, 0x252b47 },
	{ 0x4673, 0x242f73 },
	{ 0x4674, 0x243531 },
	{ 0x4675, 0x243b21 },
	{ 0x4677, 0x233379 },
	{ 0x4678, 0x233378 },
	{ 0x4679, 0x243533 },
	{ 0x467a, 0x243535 },
	{ 0x467c, 0x243b23 },
	{ 0x467d, 0x253c35 },
	{ 0x467e, 0x243b22 },
	{ 0x467f, 0x233e73 },
	{ 0x4680, 0x234450 },
	{ 0x4681, 0x234451 },
	{ 0x4682, 0x244736 },
	{ 0x4683, 0x244738 },
	{ 0x4684, 0x244d4a },
	{ 0x4685, 0x244d48 },
	{ 0x4686, 0x24535a },
	{ 0x4687, 0x24535b },
	{ 0x4688, 0x255832 },
	{ 0x4689, 0x24535c },
	{ 0x468a, 0x255e43 },
	{ 0x468b, 0x245868 },
	{ 0x468c, 0x245869 },
	{ 0x468d, 0x245d4e },
	{ 0x468e, 0x245d50 },
	{ 0x468f, 0x24612d },
	{ 0x4690, 0x24612e },
	{ 0x4691, 0x235b30 },
	{ 0x4692, 0x24612c },
	{ 0x4693, 0x246130 },
	{ 0x4694, 0x235e60 },
	{ 0x4696, 0x23623c },
	{ 0x4697, 0x24353a },
	{ 0x4698, 0x234453 },
	{ 0x4699, 0x244067 },
	{ 0x469a, 0x234452 },
	{ 0x469b, 0x24473a },
	{ 0x469c, 0x244d51 },
	{ 0x469d, 0x244d4c },
	{ 0x469e, 0x244d4e },
	{ 0x469f, 0x244d53 },
	{ 0x46a0, 0x244d4f },
	{ 0x46a1, 0x245364 },
	{ 0x46a2, 0x245361 },
	{ 0x46a3, 0x245362 },
	{ 0x46a5, 0x24586b },
	{ 0x46a6, 0x24586a },
	{ 0x46a7, 0x256463 },
	{ 0x46a8, 0x246131 },
	{ 0x46a9, 0x246134 },
	{ 0x46aa, 0x246446 },
	{ 0x46ab, 0x246447 },
	{ 0x46ad, 0x246d22 },
	{ 0x46ae, 0x232f2b },
	{ 0x46af, 0x252b49 },
	{ 0x46b0, 0x232f2d },
	{ 0x46b1, 0x242f7e },
	{ 0x46b2, 0x23337d },
	{ 0x46b3, 0x243541 },
	{ 0x46b4, 0x23387c },
	{ 0x46b5, 0x233878 },
	{ 0x46b6, 0x253557 },
	{ 0x46b7, 0x243544 },
	{ 0x46b8, 0x25355e },
	{ 0x46b9, 0x233924 },
	{ 0x46ba, 0x233928 },
	{ 0x46bb, 0x233921 },
	{ 0x46bc, 0x24353f },
	{ 0x46bd, 0x23387d },
	{ 0x46be, 0x233927 },
	{ 0x46bf, 0x243543 },
	{ 0x46c0, 0x25355d },
	{ 0x46c1, 0x26446d },
	{ 0x46c2, 0x233926 },
	{ 0x46c3, 0x253556 },
	{ 0x46c4, 0x243b33 },
	{ 0x46c5, 0x233e79 },
	{ 0x46c6, 0x233e7a },
	{ 0x46c7, 0x243b36 },
	{ 0x46c8, 0x243b35 },
	{ 0x46c9, 0x233e76 },
	{ 0x46ca, 0x233e7b },
	{ 0x46cb, 0x233e77 },
	{ 0x46cc, 0x243b34 },
	{ 0x46cd, 0x243b2a },
	{ 0x46ce, 0x243b29 },
	{ 0x46cf, 0x243b2b },
	{ 0x46d0, 0x233f26 },
	{ 0x46d1, 0x264e6b },
	{ 0x46d2, 0x233f25 },
	{ 0x46d4, 0x234457 },
	{ 0x46d5, 0x265841 },
	{ 0x46d6, 0x23445e },
	{ 0x46d7, 0x24406e },
	{ 0x46d8, 0x24406d },
	{ 0x46d9, 0x24406c },
	{ 0x46da, 0x23445a },
	{ 0x46db, 0x23445f },
	{ 0x46dc, 0x234462 },
	{ 0x46dd, 0x24473d },
	{ 0x46de, 0x244740 },
	{ 0x46df, 0x24474a },
	{ 0x46e0, 0x24473c },
	{ 0x46e1, 0x23496a },
	{ 0x46e2, 0x244746 },
	{ 0x46e3, 0x244742 },
	{ 0x46e4, 0x234961 },
	{ 0x46e5, 0x244743 },
	{ 0x46e6, 0x234969 },
	{ 0x46e7, 0x234967 },
	{ 0x46e8, 0x23495d },
	{ 0x46e9, 0x244d59 },
	{ 0x46ea, 0x244d56 },
	{ 0x46eb, 0x244d5c },
	{ 0x46ec, 0x244d5e },
	{ 0x46ed, 0x234e68 },
	{ 0x46ee, 0x244d61 },
	{ 0x46ef, 0x244d58 },
	{ 0x46f0, 0x244d5b },
	{ 0x46f1, 0x234e6d },
	{ 0x46f2, 0x244d5f },
	{ 0x46f3, 0x244d5a },
	{ 0x46f4, 0x234e6b },
	{ 0x46f5, 0x244d60 },
	{ 0x46f6, 0x272879 },
	{ 0x46f7, 0x244d55 },
	{ 0x46f8, 0x234e71 },
	{ 0x46f9, 0x24536a },
	{ 0x46fa, 0x23526c },
	{ 0x46fb, 0x23526d },
	{ 0x46fc, 0x27334d },
	{ 0x46fd, 0x24536b },
	{ 0x46fe, 0x235647 },
	{ 0x46ff, 0x245870 },
	{ 0x4700, 0x23564b },
	{ 0x4701, 0x23564c },
	{ 0x4702, 0x255e55 },
	{ 0x4703, 0x245d5a },
	{ 0x4704, 0x274a25 },
	{ 0x4705, 0x245d57 },
	{ 0x4706, 0x245d5b },
	{ 0x4707, 0x235922 },
	{ 0x4708, 0x235925 },
	{ 0x4709, 0x245d54 },
	{ 0x470a, 0x235927 },
	{ 0x470b, 0x246140 },
	{ 0x470c, 0x256952 },
	{ 0x470d, 0x235b33 },
	{ 0x470e, 0x24613b },
	{ 0x470f, 0x24613d },
	{ 0x4710, 0x246145 },
	{ 0x4711, 0x256951 },
	{ 0x4712, 0x24644e },
	{ 0x4713, 0x235d2d },
	{ 0x4714, 0x275031 },
	{ 0x4715, 0x24644c },
	{ 0x4716, 0x235d2f },
	{ 0x4717, 0x246448 },
	{ 0x4718, 0x235d31 },
	{ 0x4719, 0x24673d },
	{ 0x471a, 0x24673f },
	{ 0x471b, 0x275532 },
	{ 0x471c, 0x24673e },
	{ 0x471d, 0x246740 },
	{ 0x471e, 0x246739 },
	{ 0x471f, 0x275938 },
	{ 0x4720, 0x235f63 },
	{ 0x4721, 0x246948 },
	{ 0x4722, 0x25764c },
	{ 0x472a, 0x242b49 },
	{ 0x472b, 0x243023 },
	{ 0x472c, 0x264e7a },
	{ 0x472d, 0x233f27 },
	{ 0x472e, 0x24474c },
	{ 0x472f, 0x234e77 },
	{ 0x4730, 0x245875 },
	{ 0x4731, 0x245d61 },
	{ 0x4732, 0x24694c },
	{ 0x4734, 0x24354a },
	{ 0x4735, 0x233f28 },
	{ 0x4736, 0x244074 },
	{ 0x4737, 0x24474e },
	{ 0x4738, 0x24474f },
	{ 0x4739, 0x23496c },
	{ 0x473a, 0x244d64 },
	{ 0x473b, 0x235270 },
	{ 0x473c, 0x245373 },
	{ 0x473d, 0x23526f },
	{ 0x473e, 0x245372 },
	{ 0x473f, 0x235271 },
	{ 0x4740, 0x245876 },
	{ 0x4741, 0x245877 },
	{ 0x4742, 0x23564e },
	{ 0x4743, 0x246744 },
	{ 0x4744, 0x246d24 },
	{ 0x4745, 0x243025 },
	{ 0x4746, 0x24354b },
	{ 0x4747, 0x264522 },
	{ 0x4748, 0x24354c },
	{ 0x4749, 0x2f4474 },
	{ 0x474a, 0x244d67 },
	{ 0x474b, 0x244d65 },
	{ 0x474c, 0x244d68 },
	{ 0x474d, 0x245375 },
	{ 0x474e, 0x245377 },
	{ 0x474f, 0x245d64 },
	{ 0x4750, 0x246148 },
	{ 0x4751, 0x246146 },
	{ 0x4752, 0x246745 },
	{ 0x4753, 0x235f65 },
	{ 0x4754, 0x23614c },
	{ 0x4755, 0x246d25 },
	{ 0x4756, 0x243550 },
	{ 0x4757, 0x264524 },
	{ 0x4758, 0x23392f },
	{ 0x475a, 0x243b3e },
	{ 0x475c, 0x23496e },
	{ 0x475d, 0x234e79 },
	{ 0x475e, 0x234e78 },
	{ 0x475f, 0x235272 },
	{ 0x4760, 0x235650 },
	{ 0x4761, 0x23592c },
	{ 0x4762, 0x23592d },
	{ 0x4763, 0x24614a },
	{ 0x4764, 0x274a41 },
	{ 0x4765, 0x235b37 },
	{ 0x4766, 0x245d68 },
	{ 0x4767, 0x243551 },
	{ 0x4768, 0x243554 },
	{ 0x4769, 0x253c4c },
	{ 0x476a, 0x243b3f },
	{ 0x476b, 0x243b41 },
	{ 0x476c, 0x233f2e },
	{ 0x476d, 0x243b42 },
	{ 0x476e, 0x264f29 },
	{ 0x476f, 0x243b43 },
	{ 0x4770, 0x244121 },
	{ 0x4771, 0x234466 },
	{ 0x4772, 0x234468 },
	{ 0x4773, 0x254a29 },
	{ 0x4774, 0x26626a },
	{ 0x4775, 0x23496f },
	{ 0x4776, 0x234e7b },
	{ 0x4777, 0x234e7c },
	{ 0x4778, 0x244d6e },
	{ 0x4779, 0x244d6c },
	{ 0x477a, 0x272936 },
	{ 0x477b, 0x244d6d },
	{ 0x477d, 0x255139 },
	{ 0x477e, 0x234f21 },
	{ 0x477f, 0x235274 },
	{ 0x4780, 0x24537d },
	{ 0x4781, 0x245379 },
	{ 0x4782, 0x24537b },
	{ 0x4783, 0x24537a },
	{ 0x4784, 0x235276 },
	{ 0x4785, 0x273c33 },
	{ 0x4786, 0x24587a },
	{ 0x4787, 0x2f607a },
	{ 0x4788, 0x24537e },
	{ 0x4789, 0x235d35 },
	{ 0x478a, 0x235e64 },
	{ 0x478b, 0x246b21 },
	{ 0x4791, 0x25304b },
	{ 0x4792, 0x254334 },
	{ 0x4793, 0x244759 },
	{ 0x4794, 0x244758 },
	{ 0x4795, 0x246748 },
	{ 0x4796, 0x25304c },
	{ 0x4797, 0x243027 },
	{ 0x4798, 0x243028 },
	{ 0x4799, 0x243555 },
	{ 0x479a, 0x243556 },
	{ 0x479b, 0x233934 },
	{ 0x479c, 0x233936 },
	{ 0x479d, 0x233f31 },
	{ 0x479e, 0x243b45 },
	{ 0x479f, 0x233f36 },
	{ 0x47a0, 0x233f32 },
	{ 0x47a1, 0x253c52 },
	{ 0x47a2, 0x233f35 },
	{ 0x47a3, 0x243b48 },
	{ 0x47a4, 0x243b47 },
	{ 0x47a5, 0x244126 },
	{ 0x47a6, 0x244127 },
	{ 0x47a7, 0x25433c },
	{ 0x47a8, 0x23446a },
	{ 0x47a9, 0x244128 },
	{ 0x47aa, 0x254338 },
	{ 0x47ab, 0x24475a },
	{ 0x47ac, 0x266275 },
	{ 0x47ad, 0x24475b },
	{ 0x47ae, 0x234976 },
	{ 0x47af, 0x254a34 },
	{ 0x47b0, 0x234977 },
	{ 0x47b1, 0x254a32 },
	{ 0x47b3, 0x234f27 },
	{ 0x47b4, 0x244d73 },
	{ 0x47b5, 0x244d71 },
	{ 0x47b6, 0x234f24 },
	{ 0x47b7, 0x244d74 },
	{ 0x47b8, 0x27293d },
	{ 0x47b9, 0x245426 },
	{ 0x47ba, 0x25585c },
	{ 0x47bb, 0x255855 },
	{ 0x47bc, 0x235278 },
	{ 0x47bd, 0x24587d },
	{ 0x47be, 0x245925 },
	{ 0x47bf, 0x24587c },
	{ 0x47c0, 0x255e6d },
	{ 0x47c1, 0x245d6d },
	{ 0x47c2, 0x23592f },
	{ 0x47c3, 0x245d6c },
	{ 0x47c4, 0x245d6a },
	{ 0x47c5, 0x245d6e },
	{ 0x47c6, 0x235930 },
	{ 0x47c7, 0x24614d },
	{ 0x47c8, 0x235d36 },
	{ 0x47c9, 0x246455 },
	{ 0x47ca, 0x246453 },
	{ 0x47cb, 0x246456 },
	{ 0x47cc, 0x24674a },
	{ 0x47cd, 0x24694e },
	{ 0x47ce, 0x235f66 },
	{ 0x47cf, 0x24694f },
	{ 0x47d0, 0x246b23 },
	{ 0x47d1, 0x246c28 },
	{ 0x47d2, 0x246d27 },
	{ 0x47d3, 0x242b4c },
	{ 0x47d4, 0x232f2f },
	{ 0x47d5, 0x24302a },
	{ 0x47d6, 0x23337e },
	{ 0x47d7, 0x24355e },
	{ 0x47d8, 0x243559 },
	{ 0x47d9, 0x253572 },
	{ 0x47da, 0x23393b },
	{ 0x47db, 0x24355b },
	{ 0x47dc, 0x24355c },
	{ 0x47dd, 0x24355d },
	{ 0x47de, 0x23393c },
	{ 0x47df, 0x253c63 },
	{ 0x47e0, 0x243b4c },
	{ 0x47e1, 0x243b50 },
	{ 0x47e2, 0x233f3d },
	{ 0x47e3, 0x243b4d },
	{ 0x47e4, 0x243b49 },
	{ 0x47e5, 0x264f36 },
	{ 0x47e6, 0x264f3c },
	{ 0x47e7, 0x253c5c },
	{ 0x47e8, 0x243b4a },
	{ 0x47e9, 0x243b4b },
	{ 0x47ea, 0x243b4f },
	{ 0x47eb, 0x233f3c },
	{ 0x47ec, 0x253c5f },
	{ 0x47ed, 0x243b51 },
	{ 0x47ee, 0x244129 },
	{ 0x47ef, 0x25434b },
	{ 0x47f0, 0x23446c },
	{ 0x47f1, 0x23446e },
	{ 0x47f3, 0x2f4558 },
	{ 0x47f4, 0x254a3e },
	{ 0x47f5, 0x24475e },
	{ 0x47f6, 0x244761 },
	{ 0x47f7, 0x24475f },
	{ 0x47f8, 0x244762 },
	{ 0x47f9, 0x244765 },
	{ 0x47fa, 0x234978 },
	{ 0x47fb, 0x244764 },
	{ 0x47fc, 0x234f28 },
	{ 0x47fd, 0x23446f },
	{ 0x47fe, 0x244d77 },
	{ 0x47ff, 0x244e22 },
	{ 0x4800, 0x234f2a },
	{ 0x4801, 0x27294e },
	{ 0x4802, 0x234f2e },
	{ 0x4803, 0x234f29 },
	{ 0x4804, 0x244d7e },
	{ 0x4805, 0x244e21 },
	{ 0x4806, 0x244d7d },
	{ 0x4807, 0x244d79 },
	{ 0x4808, 0x244d78 },
	{ 0x4809, 0x244d76 },
	{ 0x480a, 0x234f2d },
	{ 0x480b, 0x244e23 },
	{ 0x480d, 0x24542e },
	{ 0x480e, 0x23527d },
	{ 0x480f, 0x23527a },
	{ 0x4810, 0x24542f },
	{ 0x4811, 0x24542d },
	{ 0x4812, 0x255862 },
	{ 0x4813, 0x245430 },
	{ 0x4814, 0x235279 },
	{ 0x4815, 0x255e7b },
	{ 0x4817, 0x24592b },
	{ 0x4818, 0x24592c },
	{ 0x4819, 0x245926 },
	{ 0x481a, 0x2f5c78 },
	{ 0x481b, 0x24592a },
	{ 0x481c, 0x245928 },
	{ 0x481d, 0x235653 },
	{ 0x481e, 0x235933 },
	{ 0x481f, 0x245d74 },
	{ 0x4820, 0x245d78 },
	{ 0x4821, 0x245d72 },
	{ 0x4822, 0x245d75 },
	{ 0x4823, 0x274a57 },
	{ 0x4824, 0x246150 },
	{ 0x4825, 0x235934 },
	{ 0x4826, 0x246151 },
	{ 0x4827, 0x245d77 },
	{ 0x4828, 0x24645b },
	{ 0x4829, 0x24645a },
	{ 0x482a, 0x246750 },
	{ 0x482b, 0x24674c },
	{ 0x482c, 0x25744b },
	{ 0x482d, 0x246b24 },
	{ 0x482e, 0x275c77 },
	{ 0x482f, 0x246c29 },
	{ 0x4830, 0x23614f },
	{ 0x4831, 0x23622e },
	{ 0x4832, 0x233f42 },
	{ 0x4833, 0x253c67 },
	{ 0x4834, 0x243b52 },
	{ 0x4835, 0x243b53 },
	{ 0x4836, 0x233f41 },
	{ 0x4837, 0x234471 },
	{ 0x4838, 0x234470 },
	{ 0x4839, 0x234472 },
	{ 0x483b, 0x244e26 },
	{ 0x483c, 0x245432 },
	{ 0x483d, 0x245930 },
	{ 0x483e, 0x235656 },
	{ 0x483f, 0x235b3e },
	{ 0x4840, 0x24645f },
	{ 0x4841, 0x23604c },
	{ 0x4842, 0x242b4d },
	{ 0x4843, 0x242b4e },
	{ 0x4844, 0x2f2d53 },
	{ 0x4845, 0x233422 },
	{ 0x4846, 0x233943 },
	{ 0x4847, 0x233944 },
	{ 0x4848, 0x233948 },
	{ 0x4849, 0x243561 },
	{ 0x484a, 0x243562 },
	{ 0x484b, 0x233945 },
	{ 0x484c, 0x233946 },
	{ 0x484d, 0x233942 },
	{ 0x484e, 0x264545 },
	{ 0x484f, 0x233f48 },
	{ 0x4850, 0x233f43 },
	{ 0x4851, 0x243b54 },
	{ 0x4852, 0x233f4a },
	{ 0x4853, 0x234475 },
	{ 0x4854, 0x24412a },
	{ 0x4855, 0x234474 },
	{ 0x4856, 0x265924 },
	{ 0x4857, 0x24412c },
	{ 0x4858, 0x244766 },
	{ 0x4859, 0x244769 },
	{ 0x485a, 0x244767 },
	{ 0x485b, 0x23497e },
	{ 0x485c, 0x244e28 },
	{ 0x485d, 0x244e27 },
	{ 0x485e, 0x244e2a },
	{ 0x485f, 0x244e29 },
	{ 0x4860, 0x235323 },
	{ 0x4861, 0x255872 },
	{ 0x4862, 0x245433 },
	{ 0x4863, 0x245434 },
	{ 0x4864, 0x255161 },
	{ 0x4865, 0x235658 },
	{ 0x4866, 0x245932 },
	{ 0x4867, 0x245935 },
	{ 0x4868, 0x245937 },
	{ 0x4869, 0x235657 },
	{ 0x486a, 0x245931 },
	{ 0x486b, 0x245d7c },
	{ 0x486c, 0x245d7b },
	{ 0x486d, 0x245d7a },
	{ 0x486e, 0x256535 },
	{ 0x486f, 0x245d7d },
	{ 0x4870, 0x245d7e },
	{ 0x4872, 0x246159 },
	{ 0x4873, 0x246158 },
	{ 0x4874, 0x246157 },
	{ 0x4875, 0x246460 },
	{ 0x4876, 0x246461 },
	{ 0x4877, 0x246752 },
	{ 0x4878, 0x2f6853 },
	{ 0x4879, 0x235f68 },
	{ 0x487a, 0x235f67 },
	{ 0x487c, 0x23607d },
	{ 0x487d, 0x246d61 },
	{ 0x487e, 0x246e21 },
	{ 0x487f, 0x23623d },
	{ 0x4883, 0x244e2e },
	{ 0x4884, 0x235d39 },
	{ 0x4885, 0x24476b },
	{ 0x4886, 0x2f4c67 },
	{ 0x4887, 0x234f38 },
	{ 0x4888, 0x246463 },
	{ 0x4889, 0x275056 },
	{ 0x488a, 0x232732 },
	{ 0x488b, 0x242522 },
	{ 0x488c, 0x2f2872 },
	{ 0x488d, 0x232a6f },
	{ 0x488e, 0x252769 },
	{ 0x4890, 0x242b53 },
	{ 0x4891, 0x242b50 },
	{ 0x4892, 0x233423 },
	{ 0x4893, 0x24302d },
	{ 0x4894, 0x243030 },
	{ 0x4895, 0x233424 },
	{ 0x4896, 0x24302e },
	{ 0x4899, 0x233949 },
	{ 0x489a, 0x243569 },
	{ 0x489b, 0x23394d },
	{ 0x489c, 0x233f53 },
	{ 0x489d, 0x243b57 },
	{ 0x489e, 0x233f4e },
	{ 0x489f, 0x264f48 },
	{ 0x48a0, 0x233f52 },
	{ 0x48a1, 0x24412f },
	{ 0x48a2, 0x234a25 },
	{ 0x48a4, 0x24476c },
	{ 0x48a5, 0x234a23 },
	{ 0x48a6, 0x234f3a },
	{ 0x48a7, 0x244e31 },
	{ 0x48a8, 0x244e35 },
	{ 0x48a9, 0x234f3d },
	{ 0x48aa, 0x23532a },
	{ 0x48ab, 0x235328 },
	{ 0x48ac, 0x235329 },
	{ 0x48ad, 0x245938 },
	{ 0x48ae, 0x245939 },
	{ 0x48af, 0x274377 },
	{ 0x48b0, 0x235939 },
	{ 0x48b1, 0x24615e },
	{ 0x48b2, 0x246c2c },
	{ 0x48b3, 0x23225f },
	{ 0x48b4, 0x242332 },
	{ 0x48b5, 0x232736 },
	{ 0x48b6, 0x232737 },
	{ 0x48b7, 0x232738 },
	{ 0x48b8, 0x232a76 },
	{ 0x48b9, 0x242829 },
	{ 0x48bb, 0x232f36 },
	{ 0x48bc, 0x242b56 },
	{ 0x48bd, 0x234522 },
	{ 0x48be, 0x232f3d },
	{ 0x48bf, 0x242b54 },
	{ 0x48c0, 0x242b58 },
	{ 0x48c1, 0x232f39 },
	{ 0x48c2, 0x232f3a },
	{ 0x48c3, 0x26346d },
	{ 0x48c4, 0x243038 },
	{ 0x48c5, 0x243034 },
	{ 0x48c6, 0x233428 },
	{ 0x48c7, 0x243033 },
	{ 0x48c8, 0x244771 },
	{ 0x48ca, 0x24356c },
	{ 0x48cb, 0x24356e },
	{ 0x48cc, 0x243573 },
	{ 0x48cd, 0x24356b },
	{ 0x48ce, 0x233950 },
	{ 0x48cf, 0x243570 },
	{ 0x48d0, 0x243b5e },
	{ 0x48d1, 0x233f58 },
	{ 0x48d3, 0x244134 },
	{ 0x48d4, 0x244136 },
	{ 0x48d5, 0x234521 },
	{ 0x48d6, 0x24593c },
	{ 0x48d7, 0x244138 },
	{ 0x48d8, 0x24476d },
	{ 0x48d9, 0x24476e },
	{ 0x48da, 0x234a29 },
	{ 0x48db, 0x234a28 },
	{ 0x48dc, 0x254a60 },
	{ 0x48dd, 0x244770 },
	{ 0x48de, 0x234f3e },
	{ 0x48df, 0x244e3d },
	{ 0x48e0, 0x244e3c },
	{ 0x48e1, 0x25587e },
	{ 0x48e2, 0x255f3c },
	{ 0x48e3, 0x23604d },
	{ 0x48e4, 0x246b26 },
	{ 0x48e5, 0x232f3f },
	{ 0x48e7, 0x23342b },
	{ 0x48e8, 0x23342c },
	{ 0x48e9, 0x243578 },
	{ 0x48ea, 0x243574 },
	{ 0x48eb, 0x233953 },
	{ 0x48ec, 0x253636 },
	{ 0x48ed, 0x243575 },
	{ 0x48ee, 0x243b60 },
	{ 0x48ef, 0x233f5a },
	{ 0x48f0, 0x233f5b },
	{ 0x48f1, 0x233f5c },
	{ 0x48f2, 0x243b64 },
	{ 0x48f4, 0x26594c },
	{ 0x48f5, 0x234526 },
	{ 0x48f6, 0x24413d },
	{ 0x48f7, 0x24413c },
	{ 0x48f8, 0x24413f },
	{ 0x48f9, 0x24413e },
	{ 0x48fa, 0x244773 },
	{ 0x48fb, 0x244774 },
	{ 0x48fc, 0x244e3f },
	{ 0x48fd, 0x244e41 },
	{ 0x48fe, 0x244e3e },
	{ 0x48ff, 0x244e40 },
	{ 0x4901, 0x24543d },
	{ 0x4902, 0x24543c },
	{ 0x4903, 0x24543a },
	{ 0x4904, 0x23532e },
	{ 0x4905, 0x245440 },
	{ 0x4906, 0x24543b },
	{ 0x4907, 0x273454 },
	{ 0x4908, 0x235330 },
	{ 0x4909, 0x24593d },
	{ 0x490a, 0x245942 },
	{ 0x490b, 0x273c70 },
	{ 0x490c, 0x245941 },
	{ 0x490d, 0x256545 },
	{ 0x490e, 0x246161 },
	{ 0x490f, 0x246164 },
	{ 0x4910, 0x246163 },
	{ 0x4911, 0x246162 },
	{ 0x4912, 0x246165 },
	{ 0x4913, 0x24675a },
	{ 0x4914, 0x24675b },
	{ 0x4915, 0x246954 },
	{ 0x4916, 0x246953 },
	{ 0x4917, 0x246c2e },
	{ 0x4918, 0x246c2d },
	{ 0x4919, 0x246e3d },
	{ 0x491a, 0x24357a },
	{ 0x491b, 0x263c63 },
	{ 0x491c, 0x23395a },
	{ 0x491d, 0x233f5f },
	{ 0x491e, 0x233f64 },
	{ 0x491f, 0x233f61 },
	{ 0x4920, 0x233f67 },
	{ 0x4921, 0x23452c },
	{ 0x4922, 0x25436d },
	{ 0x4924, 0x234a2e },
	{ 0x4925, 0x244779 },
	{ 0x4926, 0x234a36 },
	{ 0x4927, 0x244776 },
	{ 0x4928, 0x24477b },
	{ 0x492a, 0x244778 },
	{ 0x492b, 0x234f4f },
	{ 0x492c, 0x244e43 },
	{ 0x492d, 0x234f47 },
	{ 0x492e, 0x234f46 },
	{ 0x492f, 0x272a38 },
	{ 0x4930, 0x234f4a },
	{ 0x4931, 0x272a3e },
	{ 0x4933, 0x235333 },
	{ 0x4934, 0x235334 },
	{ 0x4935, 0x245448 },
	{ 0x4936, 0x245446 },
	{ 0x4937, 0x273c7b },
	{ 0x4938, 0x235669 },
	{ 0x4939, 0x273c77 },
	{ 0x493a, 0x245945 },
	{ 0x493b, 0x245944 },
	{ 0x493c, 0x2f5d4c },
	{ 0x493d, 0x23593f },
	{ 0x493e, 0x235941 },
	{ 0x493f, 0x245e2f },
	{ 0x4940, 0x245e2c },
	{ 0x4941, 0x274439 },
	{ 0x4942, 0x245e27 },
	{ 0x4943, 0x25654f },
	{ 0x4944, 0x245e2b },
	{ 0x4945, 0x235948 },
	{ 0x4946, 0x235947 },
	{ 0x4948, 0x235b46 },
	{ 0x4949, 0x246166 },
	{ 0x494a, 0x235b4b },
	{ 0x494b, 0x235b40 },
	{ 0x494c, 0x235b52 },
	{ 0x494d, 0x246169 },
	{ 0x494e, 0x256a33 },
	{ 0x494f, 0x246168 },
	{ 0x4950, 0x235b51 },
	{ 0x4951, 0x235b4c },
	{ 0x4952, 0x235b49 },
	{ 0x4953, 0x2f6434 },
	{ 0x4954, 0x235d3b },
	{ 0x4955, 0x24616c },
	{ 0x4956, 0x235d40 },
	{ 0x4957, 0x246466 },
	{ 0x4958, 0x24646c },
	{ 0x4959, 0x256e35 },
	{ 0x495a, 0x235d48 },
	{ 0x495b, 0x24646d },
	{ 0x495d, 0x24675f },
	{ 0x495e, 0x235e6b },
	{ 0x495f, 0x246469 },
	{ 0x4960, 0x246761 },
	{ 0x4961, 0x235e6c },
	{ 0x4962, 0x246763 },
	{ 0x4963, 0x275568 },
	{ 0x4964, 0x235e69 },
	{ 0x4965, 0x235e6e },
	{ 0x4966, 0x235e6f },
	{ 0x4967, 0x235f6f },
	{ 0x4968, 0x236051 },
	{ 0x4969, 0x257155 },
	{ 0x496a, 0x275967 },
	{ 0x496b, 0x235f6d },
	{ 0x496c, 0x275968 },
	{ 0x496d, 0x235f70 },
	{ 0x496e, 0x257455 },
	{ 0x496f, 0x246b2a },
	{ 0x4970, 0x25765f },
	{ 0x4971, 0x246b27 },
	{ 0x4972, 0x23604e },
	{ 0x4973, 0x236050 },
	{ 0x4974, 0x236123 },
	{ 0x4975, 0x236121 },
	{ 0x4976, 0x246c30 },
	{ 0x4977, 0x236124 },
	{ 0x4978, 0x23616e },
	{ 0x4987, 0x263c65 },
	{ 0x4988, 0x243b67 },
	{ 0x4989, 0x2f3f76 },
	{ 0x498a, 0x244149 },
	{ 0x498b, 0x245e32 },
	{ 0x498c, 0x23395b },
	{ 0x498d, 0x24357c },
	{ 0x498e, 0x233f6a },
	{ 0x498f, 0x243b6b },
	{ 0x4990, 0x233f6e },
	{ 0x4991, 0x233f6b },
	{ 0x4992, 0x23453b },
	{ 0x4993, 0x244150 },
	{ 0x4994, 0x24414e },
	{ 0x4995, 0x244823 },
	{ 0x4996, 0x234a3b },
	{ 0x4997, 0x234a3f },
	{ 0x4998, 0x234a3a },
	{ 0x4999, 0x254a6e },
	{ 0x499a, 0x234a3c },
	{ 0x499c, 0x272a46 },
	{ 0x499d, 0x244e48 },
	{ 0x499e, 0x234f54 },
	{ 0x499f, 0x234f57 },
	{ 0x49a0, 0x24544f },
	{ 0x49a1, 0x24544b },
	{ 0x49a2, 0x23533f },
	{ 0x49a3, 0x24544c },
	{ 0x49a4, 0x235341 },
	{ 0x49a5, 0x235343 },
	{ 0x49a6, 0x235346 },
	{ 0x49a7, 0x235345 },
	{ 0x49a8, 0x273473 },
	{ 0x49aa, 0x24594e },
	{ 0x49ab, 0x24594f },
	{ 0x49ac, 0x245954 },
	{ 0x49ad, 0x23566e },
	{ 0x49ae, 0x23566c },
	{ 0x49af, 0x24594d },
	{ 0x49b1, 0x245952 },
	{ 0x49b2, 0x246766 },
	{ 0x49b3, 0x246471 },
	{ 0x49b4, 0x25715b },
	{ 0x49b5, 0x246955 },
	{ 0x49b9, 0x25217d },
	{ 0x49ba, 0x232260 },
	{ 0x49bb, 0x23243e },
	{ 0x49bc, 0x25247b },
	{ 0x49bd, 0x262935 },
	{ 0x49c1, 0x242831 },
	{ 0x49c2, 0x242832 },
	{ 0x49c3, 0x232a7a },
	{ 0x49c4, 0x252b64 },
	{ 0x49c5, 0x242b5a },
	{ 0x49c6, 0x232f41 },
	{ 0x49c7, 0x242b59 },
	{ 0x49c9, 0x243040 },
	{ 0x49ca, 0x24303d },
	{ 0x49cb, 0x233435 },
	{ 0x49cc, 0x24303e },
	{ 0x49cd, 0x233437 },
	{ 0x49ce, 0x24303c },
	{ 0x49d0, 0x233963 },
	{ 0x49d1, 0x23395d },
	{ 0x49d2, 0x24357d },
	{ 0x49d3, 0x233960 },
	{ 0x49d4, 0x233962 },
	{ 0x49d5, 0x233964 },
	{ 0x49d6, 0x23395f },
	{ 0x49d7, 0x233f6f },
	{ 0x49d8, 0x243b6d },
	{ 0x49d9, 0x233f74 },
	{ 0x49da, 0x23453f },
	{ 0x49db, 0x23453e },
	{ 0x49dc, 0x244155 },
	{ 0x49dd, 0x244154 },
	{ 0x49de, 0x23453d },
	{ 0x49df, 0x234541 },
	{ 0x49e0, 0x234a41 },
	{ 0x49e1, 0x234a40 },
	{ 0x49e2, 0x234a43 },
	{ 0x49e3, 0x234a42 },
	{ 0x49e4, 0x234f59 },
	{ 0x49e5, 0x234f58 },
	{ 0x49e6, 0x272a54 },
	{ 0x49e7, 0x235347 },
	{ 0x49e8, 0x245453 },
	{ 0x49ea, 0x245451 },
	{ 0x49ec, 0x245955 },
	{ 0x49ee, 0x235b54 },
	{ 0x49ef, 0x246473 },
	{ 0x49f0, 0x246767 },
	{ 0x49f1, 0x233438 },
	{ 0x49f2, 0x243624 },
	{ 0x49f3, 0x233f7a },
	{ 0x49f4, 0x233f76 },
	{ 0x49f5, 0x233f79 },
	{ 0x49f6, 0x233f77 },
	{ 0x49f7, 0x244156 },
	{ 0x49f8, 0x234544 },
	{ 0x49f9, 0x234543 },
	{ 0x49fa, 0x234545 },
	{ 0x49fb, 0x234a48 },
	{ 0x49fc, 0x234f5d },
	{ 0x49fd, 0x234f5c },
	{ 0x49fe, 0x23534b },
	{ 0x49ff, 0x23534a },
	{ 0x4a00, 0x235238 },
	{ 0x4a01, 0x245958 },
	{ 0x4a02, 0x235672 },
	{ 0x4a03, 0x23594c },
	{ 0x4a04, 0x235b55 },
	{ 0x4a05, 0x235d4a },
	{ 0x4a06, 0x235b56 },
	{ 0x4a07, 0x235d4b },
	{ 0x4a08, 0x246956 },
	{ 0x4a09, 0x236151 },
	{ 0x4a0a, 0x236240 },
	{ 0x4a0b, 0x233966 },
	{ 0x4a0c, 0x233f7d },
	{ 0x4a0d, 0x265031 },
	{ 0x4a0e, 0x234548 },
	{ 0x4a0f, 0x24482d },
	{ 0x4a10, 0x244831 },
	{ 0x4a11, 0x24482e },
	{ 0x4a12, 0x234a4a },
	{ 0x4a13, 0x244834 },
	{ 0x4a14, 0x234a4b },
	{ 0x4a15, 0x244833 },
	{ 0x4a16, 0x26637b },
	{ 0x4a17, 0x234f5e },
	{ 0x4a18, 0x234f61 },
	{ 0x4a19, 0x234f5f },
	{ 0x4a1b, 0x245459 },
	{ 0x4a1c, 0x23534f },
	{ 0x4a1d, 0x23534e },
	{ 0x4a1e, 0x245960 },
	{ 0x4a1f, 0x235673 },
	{ 0x4a20, 0x235677 },
	{ 0x4a21, 0x245458 },
	{ 0x4a22, 0x235676 },
	{ 0x4a23, 0x24595d },
	{ 0x4a24, 0x24595f },
	{ 0x4a25, 0x245e35 },
	{ 0x4a26, 0x23594d },
	{ 0x4a27, 0x23594e },
	{ 0x4a28, 0x245e36 },
	{ 0x4a29, 0x274458 },
	{ 0x4a2a, 0x274460 },
	{ 0x4a2b, 0x246174 },
	{ 0x4a2c, 0x246173 },
	{ 0x4a2d, 0x235b57 },
	{ 0x4a2e, 0x235b58 },
	{ 0x4a2f, 0x235b59 },
	{ 0x4a30, 0x246475 },
	{ 0x4a31, 0x235d4d },
	{ 0x4a32, 0x246958 },
	{ 0x4a33, 0x24695a },
	{ 0x4a34, 0x24695b },
	{ 0x4a35, 0x236058 },
	{ 0x4a36, 0x236153 },
	{ 0x4a37, 0x236127 },
	{ 0x4a38, 0x236152 },
	{ 0x4a39, 0x236224 },
	{ 0x4a3a, 0x236244 },
	{ 0x4a3b, 0x236246 },
	{ 0x4a3c, 0x24695c },
	{ 0x4a3d, 0x243628 },
	{ 0x4a3e, 0x24362a },
	{ 0x4a3f, 0x243b74 },
	{ 0x4a40, 0x244e4c },
	{ 0x4a41, 0x24647b },
	{ 0x4a42, 0x24415a },
	{ 0x4a43, 0x23454a },
	{ 0x4a45, 0x234a4d },
	{ 0x4a46, 0x244838 },
	{ 0x4a47, 0x244837 },
	{ 0x4a48, 0x24545d },
	{ 0x4a49, 0x24545c },
	{ 0x4a4a, 0x245962 },
	{ 0x4a4b, 0x24647c },
	{ 0x4a4c, 0x24676e },
	{ 0x4a4d, 0x257163 },
	{ 0x4a4f, 0x246c33 },
	{ 0x4a50, 0x243b79 },
	{ 0x4a51, 0x234023 },
	{ 0x4a52, 0x243b76 },
	{ 0x4a53, 0x23454d },
	{ 0x4a54, 0x24415d },
	{ 0x4a55, 0x24415f },
	{ 0x4a56, 0x23454c },
	{ 0x4a57, 0x2f4632 },
	{ 0x4a58, 0x265a28 },
	{ 0x4a59, 0x24483a },
	{ 0x4a5a, 0x244840 },
	{ 0x4a5b, 0x24483b },
	{ 0x4a5c, 0x234a4f },
	{ 0x4a5d, 0x234a50 },
	{ 0x4a5e, 0x24483d },
	{ 0x4a5f, 0x244e4f },
	{ 0x4a60, 0x245463 },
	{ 0x4a61, 0x245461 },
	{ 0x4a62, 0x245460 },
	{ 0x4a63, 0x245464 },
	{ 0x4a64, 0x245462 },
	{ 0x4a65, 0x245963 },
	{ 0x4a66, 0x245468 },
	{ 0x4a67, 0x235352 },
	{ 0x4a68, 0x23567c },
	{ 0x4a69, 0x245968 },
	{ 0x4a6a, 0x245964 },
	{ 0x4a6b, 0x273d56 },
	{ 0x4a6c, 0x235679 },
	{ 0x4a6d, 0x23567d },
	{ 0x4a6e, 0x23567e },
	{ 0x4a6f, 0x245e3e },
	{ 0x4a70, 0x25657e },
	{ 0x4a71, 0x245e42 },
	{ 0x4a72, 0x245e3c },
	{ 0x4a73, 0x256573 },
	{ 0x4a74, 0x25657b },
	{ 0x4a75, 0x245e3b },
	{ 0x4a76, 0x245e41 },
	{ 0x4a77, 0x235b5c },
	{ 0x4a78, 0x235b5b },
	{ 0x4a79, 0x246177 },
	{ 0x4a7a, 0x24617b },
	{ 0x4a7b, 0x235b5a },
	{ 0x4a7c, 0x246523 },
	{ 0x4a7d, 0x24647e },
	{ 0x4a7e, 0x256e49 },
	{ 0x4a7f, 0x275627 },
	{ 0x4a80, 0x275625 },
	{ 0x4a81, 0x246772 },
	{ 0x4a82, 0x246770 },
	{ 0x4a83, 0x257169 },
	{ 0x4a84, 0x275626 },
	{ 0x4a85, 0x235f74 },
	{ 0x4a86, 0x257462 },
	{ 0x4a87, 0x246b2c },
	{ 0x4a88, 0x23605a },
	{ 0x4a89, 0x246c34 },
	{ 0x4a8a, 0x246d2d },
	{ 0x4a8b, 0x236154 },
	{ 0x4a8c, 0x246d65 },
	{ 0x4a8d, 0x236170 },
	{ 0x4a8e, 0x246e22 },
	{ 0x4a8f, 0x244161 },
	{ 0x4a90, 0x244843 },
	{ 0x4a91, 0x244841 },
	{ 0x4a92, 0x244842 },
	{ 0x4a93, 0x244844 },
	{ 0x4a94, 0x235354 },
	{ 0x4a95, 0x24596b },
	{ 0x4a96, 0x274477 },
	{ 0x4a97, 0x245e45 },
	{ 0x4a98, 0x235952 },
	{ 0x4a99, 0x24617d },
	{ 0x4a9a, 0x24617e },
	{ 0x4a9b, 0x246773 },
	{ 0x4a9c, 0x246960 },
	{ 0x4a9d, 0x23605b },
	{ 0x4a9e, 0x23454e },
	{ 0x4aa0, 0x235721 },
	{ 0x4aa1, 0x235b63 },
	{ 0x4aa2, 0x235b62 },
	{ 0x4aa3, 0x235d52 },
	{ 0x4aa4, 0x246775 },
	{ 0x4aa5, 0x246b2d },
	{ 0x4aa6, 0x234025 },
	{ 0x4aa7, 0x234026 },
	{ 0x4aa8, 0x234027 },
	{ 0x4aa9, 0x234551 },
	{ 0x4aab, 0x24546a },
	{ 0x4aac, 0x245469 },
	{ 0x4aad, 0x235953 },
	{ 0x4aae, 0x246222 },
	{ 0x4aaf, 0x246223 },
	{ 0x4ab0, 0x235f75 },
	{ 0x4ab1, 0x243b7b },
	{ 0x4ab2, 0x2f402d },
	{ 0x4ab3, 0x244165 },
	{ 0x4ab4, 0x244164 },
	{ 0x4ab5, 0x254434 },
	{ 0x4ab6, 0x254b3e },
	{ 0x4ab7, 0x24484d },
	{ 0x4ab8, 0x234a51 },
	{ 0x4ab9, 0x24484e },
	{ 0x4aba, 0x234a53 },
	{ 0x4abb, 0x24484c },
	{ 0x4abc, 0x24484b },
	{ 0x4abd, 0x254b3f },
	{ 0x4abe, 0x244847 },
	{ 0x4abf, 0x234f68 },
	{ 0x4ac0, 0x244e59 },
	{ 0x4ac1, 0x244e5c },
	{ 0x4ac2, 0x255260 },
	{ 0x4ac3, 0x24546d },
	{ 0x4ac4, 0x24546f },
	{ 0x4ac5, 0x235356 },
	{ 0x4ac6, 0x244e5d },
	{ 0x4ac7, 0x235360 },
	{ 0x4ac8, 0x235357 },
	{ 0x4ac9, 0x23535e },
	{ 0x4aca, 0x273551 },
	{ 0x4acb, 0x235725 },
	{ 0x4acc, 0x245973 },
	{ 0x4acd, 0x273d69 },
	{ 0x4ace, 0x235722 },
	{ 0x4acf, 0x245977 },
	{ 0x4ad0, 0x235723 },
	{ 0x4ad1, 0x235724 },
	{ 0x4ad2, 0x235727 },
	{ 0x4ad3, 0x235729 },
	{ 0x4ad4, 0x245e4e },
	{ 0x4ad5, 0x235954 },
	{ 0x4ad6, 0x245e49 },
	{ 0x4ad7, 0x245e47 },
	{ 0x4ad8, 0x245e4b },
	{ 0x4ad9, 0x235957 },
	{ 0x4ada, 0x235955 },
	{ 0x4adb, 0x245e4d },
	{ 0x4adc, 0x245e4c },
	{ 0x4add, 0x23595a },
	{ 0x4ade, 0x246227 },
	{ 0x4adf, 0x246229 },
	{ 0x4ae0, 0x24622d },
	{ 0x4ae1, 0x246226 },
	{ 0x4ae2, 0x24622c },
	{ 0x4ae3, 0x235b64 },
	{ 0x4ae4, 0x246225 },
	{ 0x4ae5, 0x24622f },
	{ 0x4ae6, 0x246228 },
	{ 0x4ae7, 0x24622b },
	{ 0x4ae8, 0x24652f },
	{ 0x4ae9, 0x246531 },
	{ 0x4aea, 0x246530 },
	{ 0x4aeb, 0x235d54 },
	{ 0x4aec, 0x246777 },
	{ 0x4aed, 0x246779 },
	{ 0x4aee, 0x246776 },
	{ 0x4aef, 0x24677c },
	{ 0x4af0, 0x24677b },
	{ 0x4af1, 0x275632 },
	{ 0x4af2, 0x246963 },
	{ 0x4af3, 0x235f76 },
	{ 0x4af4, 0x246962 },
	{ 0x4af5, 0x246c39 },
	{ 0x4af6, 0x257848 },
	{ 0x4af7, 0x236155 },
	{ 0x4af8, 0x24362b },
	{ 0x4af9, 0x243b7e },
	{ 0x4afa, 0x234553 },
	{ 0x4afb, 0x24416d },
	{ 0x4afc, 0x244172 },
	{ 0x4afd, 0x24416e },
	{ 0x4afe, 0x244851 },
	{ 0x4aff, 0x244856 },
	{ 0x4b00, 0x244859 },
	{ 0x4b01, 0x244850 },
	{ 0x4b02, 0x244854 },
	{ 0x4b03, 0x234a57 },
	{ 0x4b04, 0x244e60 },
	{ 0x4b05, 0x244e61 },
	{ 0x4b06, 0x245476 },
	{ 0x4b07, 0x245477 },
	{ 0x4b08, 0x245473 },
	{ 0x4b09, 0x245474 },
	{ 0x4b0a, 0x245475 },
	{ 0x4b0b, 0x24597d },
	{ 0x4b0c, 0x245a22 },
	{ 0x4b0d, 0x245a21 },
	{ 0x4b0e, 0x24597c },
	{ 0x4b0f, 0x24597a },
	{ 0x4b10, 0x24597e },
	{ 0x4b11, 0x245e51 },
	{ 0x4b12, 0x27447e },
	{ 0x4b13, 0x245e50 },
	{ 0x4b14, 0x245e52 },
	{ 0x4b15, 0x23595d },
	{ 0x4b16, 0x23595e },
	{ 0x4b17, 0x23595f },
	{ 0x4b18, 0x246232 },
	{ 0x4b19, 0x235b67 },
	{ 0x4b1a, 0x235b66 },
	{ 0x4b1b, 0x246536 },
	{ 0x4b1c, 0x235d55 },
	{ 0x4b1d, 0x24677e },
	{ 0x4b1e, 0x246b30 },
	{ 0x4b1f, 0x246c3a },
	{ 0x4b20, 0x23572b },
	{ 0x4b21, 0x235960 },
	{ 0x4b22, 0x23343a },
	{ 0x4b23, 0x24362c },
	{ 0x4b24, 0x234029 },
	{ 0x4b25, 0x23402a },
	{ 0x4b26, 0x243c24 },
	{ 0x4b27, 0x234028 },
	{ 0x4b28, 0x243c25 },
	{ 0x4b29, 0x23455d },
	{ 0x4b2a, 0x23402c },
	{ 0x4b2b, 0x244177 },
	{ 0x4b2c, 0x244174 },
	{ 0x4b2d, 0x234a5c },
	{ 0x4b2e, 0x23455e },
	{ 0x4b2f, 0x244175 },
	{ 0x4b30, 0x234556 },
	{ 0x4b31, 0x234555 },
	{ 0x4b32, 0x23455a },
	{ 0x4b33, 0x244179 },
	{ 0x4b34, 0x24417a },
	{ 0x4b35, 0x234a58 },
	{ 0x4b36, 0x234a59 },
	{ 0x4b37, 0x24485b },
	{ 0x4b38, 0x272b38 },
	{ 0x4b39, 0x234a5a },
	{ 0x4b3a, 0x24485c },
	{ 0x4b3b, 0x266440 },
	{ 0x4b3c, 0x234f6a },
	{ 0x4b3d, 0x244e65 },
	{ 0x4b3e, 0x244e64 },
	{ 0x4b3f, 0x244e67 },
	{ 0x4b40, 0x244e66 },
	{ 0x4b41, 0x245478 },
	{ 0x4b42, 0x244e69 },
	{ 0x4b43, 0x24547c },
	{ 0x4b44, 0x24547d },
	{ 0x4b45, 0x24547a },
	{ 0x4b46, 0x245a27 },
	{ 0x4b47, 0x245522 },
	{ 0x4b48, 0x245a28 },
	{ 0x4b49, 0x245a2a },
	{ 0x4b4a, 0x256031 },
	{ 0x4b4b, 0x23572d },
	{ 0x4b4c, 0x235964 },
	{ 0x4b4d, 0x25602c },
	{ 0x4b4e, 0x23572c },
	{ 0x4b50, 0x245e58 },
	{ 0x4b51, 0x245e57 },
	{ 0x4b52, 0x245e5b },
	{ 0x4b53, 0x245e59 },
	{ 0x4b54, 0x245e5a },
	{ 0x4b55, 0x246539 },
	{ 0x4b56, 0x246236 },
	{ 0x4b57, 0x235b68 },
	{ 0x4b58, 0x24653c },
	{ 0x4b59, 0x24653b },
	{ 0x4b5a, 0x235d57 },
	{ 0x4b5b, 0x235d59 },
	{ 0x4b5d, 0x246824 },
	{ 0x4b5e, 0x246823 },
	{ 0x4b5f, 0x235e7d },
	{ 0x4b60, 0x246822 },
	{ 0x4b61, 0x246967 },
	{ 0x4b62, 0x246965 },
	{ 0x4b63, 0x235f77 },
	{ 0x4b64, 0x246968 },
	{ 0x4b65, 0x246b31 },
	{ 0x4b66, 0x236156 },
	{ 0x4b67, 0x246d30 },
	{ 0x4b68, 0x246d67 },
	{ 0x4b69, 0x246e25 },
	{ 0x4b6b, 0x234f6c },
	{ 0x4b6c, 0x235367 },
	{ 0x4b6d, 0x245e5f },
	{ 0x4b6e, 0x24623c },
	{ 0x4b6f, 0x24485d },
	{ 0x4b70, 0x23572f },
	{ 0x4b71, 0x245526 },
	{ 0x4b72, 0x23572e },
	{ 0x4b73, 0x236171 },
	{ 0x4b74, 0x23402d },
	{ 0x4b75, 0x25444a },
	{ 0x4b76, 0x234560 },
	{ 0x4b77, 0x24485e },
	{ 0x4b78, 0x234a65 },
	{ 0x4b79, 0x24485f },
	{ 0x4b7a, 0x234a5f },
	{ 0x4b7b, 0x234a67 },
	{ 0x4b7c, 0x234a68 },
	{ 0x4b7d, 0x234a6b },
	{ 0x4b7e, 0x234a69 },
	{ 0x4b7f, 0x244e6f },
	{ 0x4b80, 0x234f71 },
	{ 0x4b81, 0x234f70 },
	{ 0x4b82, 0x244e6e },
	{ 0x4b83, 0x234f6f },
	{ 0x4b84, 0x244e6d },
	{ 0x4b85, 0x244e70 },
	{ 0x4b86, 0x23536f },
	{ 0x4b87, 0x23536e },
	{ 0x4b88, 0x23536d },
	{ 0x4b89, 0x255a2c },
	{ 0x4b8a, 0x235369 },
	{ 0x4b8b, 0x24552d },
	{ 0x4b8c, 0x255a2e },
	{ 0x4b8d, 0x273628 },
	{ 0x4b8e, 0x245a2e },
	{ 0x4b8f, 0x235732 },
	{ 0x4b90, 0x235735 },
	{ 0x4b91, 0x245a2d },
	{ 0x4b92, 0x235731 },
	{ 0x4b93, 0x245e67 },
	{ 0x4b94, 0x256a6e },
	{ 0x4b95, 0x245e62 },
	{ 0x4b96, 0x235968 },
	{ 0x4b97, 0x245e68 },
	{ 0x4b98, 0x235969 },
	{ 0x4b99, 0x245e63 },
	{ 0x4b9a, 0x245e65 },
	{ 0x4b9b, 0x23596c },
	{ 0x4b9c, 0x246241 },
	{ 0x4b9d, 0x24623f },
	{ 0x4b9e, 0x235b6a },
	{ 0x4b9f, 0x246246 },
	{ 0x4ba0, 0x246240 },
	{ 0x4ba1, 0x246244 },
	{ 0x4ba2, 0x246245 },
	{ 0x4ba3, 0x246541 },
	{ 0x4ba4, 0x246540 },
	{ 0x4ba5, 0x235d5d },
	{ 0x4ba6, 0x235d5b },
	{ 0x4ba7, 0x246547 },
	{ 0x4ba8, 0x256e66 },
	{ 0x4ba9, 0x256e6d },
	{ 0x4baa, 0x235d5c },
	{ 0x4bab, 0x246829 },
	{ 0x4bac, 0x24682a },
	{ 0x4bad, 0x24682b },
	{ 0x4bae, 0x24682d },
	{ 0x4baf, 0x235f23 },
	{ 0x4bb0, 0x25722d },
	{ 0x4bb1, 0x246828 },
	{ 0x4bb2, 0x275a3e },
	{ 0x4bb3, 0x257476 },
	{ 0x4bb4, 0x24696b },
	{ 0x4bb5, 0x246969 },
	{ 0x4bb6, 0x235f7a },
	{ 0x4bb7, 0x246b33 },
	{ 0x4bb8, 0x246b34 },
	{ 0x4bb9, 0x246b32 },
	{ 0x4bba, 0x23612b },
	{ 0x4bbb, 0x27602e },
	{ 0x4bbc, 0x27602d },
	{ 0x4bbd, 0x236157 },
	{ 0x4bbe, 0x246d68 },
	{ 0x4bbf, 0x236227 },
	{ 0x4bc0, 0x246e3f },
	{ 0x4bc1, 0x236237 },
	{ 0x4bc2, 0x246e57 },
	{ 0x4bc6, 0x233969 },
	{ 0x4bc7, 0x23402e },
	{ 0x4bc8, 0x244862 },
	{ 0x4bc9, 0x234a6d },
	{ 0x4bca, 0x234f75 },
	{ 0x4bcb, 0x244e75 },
	{ 0x4bcc, 0x244e73 },
	{ 0x4bcd, 0x244e76 },
	{ 0x4bce, 0x234f78 },
	{ 0x4bcf, 0x235372 },
	{ 0x4bd0, 0x235373 },
	{ 0x4bd1, 0x245530 },
	{ 0x4bd2, 0x245532 },
	{ 0x4bd3, 0x24552f },
	{ 0x4bd4, 0x24552e },
	{ 0x4bd5, 0x235739 },
	{ 0x4bd6, 0x245a31 },
	{ 0x4bd7, 0x245a35 },
	{ 0x4bd8, 0x245a30 },
	{ 0x4bd9, 0x235738 },
	{ 0x4bda, 0x245a33 },
	{ 0x4bdb, 0x256651 },
	{ 0x4bdc, 0x245e6e },
	{ 0x4bdd, 0x235b70 },
	{ 0x4bde, 0x246248 },
	{ 0x4bdf, 0x246247 },
	{ 0x4be0, 0x246549 },
	{ 0x4be1, 0x235d5f },
	{ 0x4be2, 0x246830 },
	{ 0x4be3, 0x24696e },
	{ 0x4be4, 0x246b35 },
	{ 0x4be5, 0x246c3e },
	{ 0x4be6, 0x246d33 },
	{ 0x4be7, 0x234030 },
	{ 0x4be8, 0x244222 },
	{ 0x4bea, 0x24624a },
	{ 0x4beb, 0x25747a },
	{ 0x4bec, 0x276475 },
	{ 0x4bed, 0x234031 },
	{ 0x4bee, 0x253d52 },
	{ 0x4bef, 0x26645e },
	{ 0x4bf0, 0x24486a },
	{ 0x4bf1, 0x244869 },
	{ 0x4bf2, 0x244867 },
	{ 0x4bf3, 0x234a74 },
	{ 0x4bf4, 0x254b59 },
	{ 0x4bf5, 0x244e7b },
	{ 0x4bf6, 0x234f7a },
	{ 0x4bf7, 0x245535 },
	{ 0x4bf8, 0x245536 },
	{ 0x4bf9, 0x245a38 },
	{ 0x4bfa, 0x23573d },
	{ 0x4bfc, 0x245a3b },
	{ 0x4bfd, 0x245e70 },
	{ 0x4bfe, 0x245e73 },
	{ 0x4bff, 0x23596e },
	{ 0x4c00, 0x245e74 },
	{ 0x4c01, 0x245e76 },
	{ 0x4c02, 0x245e75 },
	{ 0x4c03, 0x245e77 },
	{ 0x4c04, 0x24624e },
	{ 0x4c05, 0x235b72 },
	{ 0x4c06, 0x24624c },
	{ 0x4c08, 0x24654d },
	{ 0x4c09, 0x24654f },
	{ 0x4c0a, 0x24654e },
	{ 0x4c0b, 0x275179 },
	{ 0x4c0c, 0x25723f },
	{ 0x4c0d, 0x235f26 },
	{ 0x4c0e, 0x246972 },
	{ 0x4c0f, 0x246c43 },
	{ 0x4c10, 0x246c41 },
	{ 0x4c11, 0x23612d },
	{ 0x4c12, 0x257852 },
	{ 0x4c13, 0x246d35 },
	{ 0x4c14, 0x27616a },
	{ 0x4c15, 0x246d69 },
	{ 0x4c16, 0x246e49 },
	{ 0x4c17, 0x27517d },
	{ 0x4c18, 0x257241 },
	{ 0x4c19, 0x234a77 },
	{ 0x4c1a, 0x234a76 },
	{ 0x4c1b, 0x234d3e },
	{ 0x4c1c, 0x235376 },
	{ 0x4c1d, 0x275a4b },
	{ 0x4c1e, 0x236158 },
	{ 0x4c1f, 0x234a79 },
	{ 0x4c20, 0x244f24 },
	{ 0x4c21, 0x244f25 },
	{ 0x4c22, 0x24553f },
	{ 0x4c23, 0x235377 },
	{ 0x4c24, 0x245e7e },
	{ 0x4c25, 0x235970 },
	{ 0x4c26, 0x245e7d },
	{ 0x4c27, 0x245e7c },
	{ 0x4c28, 0x235b73 },
	{ 0x4c29, 0x256668 },
	{ 0x4c2a, 0x235d65 },
	{ 0x4c2b, 0x246977 },
	{ 0x4c2c, 0x246976 },
	{ 0x4c2d, 0x275a4f },
	{ 0x4c2f, 0x246c48 },
	{ 0x4c30, 0x246c49 },
	{ 0x4c31, 0x246e58 },
	{ 0x4c32, 0x253d54 },
	{ 0x4c34, 0x24486d },
	{ 0x4c35, 0x254b64 },
	{ 0x4c37, 0x244f28 },
	{ 0x4c38, 0x244f34 },
	{ 0x4c39, 0x235021 },
	{ 0x4c3a, 0x272b6a },
	{ 0x4c3b, 0x244f39 },
	{ 0x4c3c, 0x244f32 },
	{ 0x4c3d, 0x244f2b },
	{ 0x4c3e, 0x244f29 },
	{ 0x4c3f, 0x235427 },
	{ 0x4c40, 0x245544 },
	{ 0x4c41, 0x245542 },
	{ 0x4c42, 0x245548 },
	{ 0x4c43, 0x23537e },
	{ 0x4c44, 0x235428 },
	{ 0x4c45, 0x245541 },
	{ 0x4c46, 0x235426 },
	{ 0x4c47, 0x235424 },
	{ 0x4c48, 0x235422 },
	{ 0x4c49, 0x23537b },
	{ 0x4c4a, 0x245a40 },
	{ 0x4c4b, 0x235741 },
	{ 0x4c4c, 0x245f21 },
	{ 0x4c4d, 0x273e49 },
	{ 0x4c4e, 0x245a42 },
	{ 0x4c4f, 0x235972 },
	{ 0x4c50, 0x245f23 },
	{ 0x4c51, 0x25666e },
	{ 0x4c52, 0x245f27 },
	{ 0x4c53, 0x245f25 },
	{ 0x4c54, 0x235978 },
	{ 0x4c55, 0x245f24 },
	{ 0x4c56, 0x235977 },
	{ 0x4c57, 0x245f29 },
	{ 0x4c58, 0x245f2b },
	{ 0x4c59, 0x24625d },
	{ 0x4c5a, 0x256b35 },
	{ 0x4c5b, 0x246267 },
	{ 0x4c5c, 0x246257 },
	{ 0x4c5d, 0x246261 },
	{ 0x4c5e, 0x246259 },
	{ 0x4c5f, 0x246254 },
	{ 0x4c60, 0x235b76 },
	{ 0x4c61, 0x256b31 },
	{ 0x4c62, 0x246262 },
	{ 0x4c63, 0x256b2b },
	{ 0x4c64, 0x246260 },
	{ 0x4c65, 0x246264 },
	{ 0x4c66, 0x235b78 },
	{ 0x4c67, 0x235b7b },
	{ 0x4c68, 0x235b7c },
	{ 0x4c69, 0x2f6472 },
	{ 0x4c6b, 0x235d77 },
	{ 0x4c6c, 0x246555 },
	{ 0x4c6d, 0x275231 },
	{ 0x4c6e, 0x24655b },
	{ 0x4c6f, 0x235d6c },
	{ 0x4c70, 0x275233 },
	{ 0x4c71, 0x246553 },
	{ 0x4c72, 0x235d6b },
	{ 0x4c73, 0x235d6d },
	{ 0x4c75, 0x24683d },
	{ 0x4c76, 0x235f2d },
	{ 0x4c77, 0x235f30 },
	{ 0x4c78, 0x24683c },
	{ 0x4c79, 0x235f2e },
	{ 0x4c7a, 0x235f2b },
	{ 0x4c7b, 0x24683a },
	{ 0x4c7c, 0x235f29 },
	{ 0x4c7d, 0x235f2f },
	{ 0x4c7e, 0x24697d },
	{ 0x4c7f, 0x235f7d },
	{ 0x4c80, 0x246a21 },
	{ 0x4c81, 0x24697c },
	{ 0x4c82, 0x235f7c },
	{ 0x4c83, 0x24697e },
	{ 0x4c84, 0x236024 },
	{ 0x4c85, 0x24697b },
	{ 0x4c86, 0x236021 },
	{ 0x4c88, 0x2f6a3f },
	{ 0x4c89, 0x246b3c },
	{ 0x4c8a, 0x246b3d },
	{ 0x4c8b, 0x246b40 },
	{ 0x4c8c, 0x246b3b },
	{ 0x4c8d, 0x275e23 },
	{ 0x4c8e, 0x236067 },
	{ 0x4c8f, 0x236064 },
	{ 0x4c90, 0x25785b },
	{ 0x4c91, 0x257856 },
	{ 0x4c92, 0x236130 },
	{ 0x4c93, 0x246c4d },
	{ 0x4c94, 0x246c4e },
	{ 0x4c95, 0x257724 },
	{ 0x4c96, 0x23615a },
	{ 0x4c97, 0x246d39 },
	{ 0x4c99, 0x236131 },
	{ 0x4c9a, 0x246e2c },
	{ 0x4c9b, 0x246e2d },
	{ 0x4c9c, 0x246e5b },
	{ 0x4ca5, 0x234565 },
	{ 0x4ca6, 0x234a7a },
	{ 0x4ca7, 0x234a7b },
	{ 0x4ca8, 0x234a7c },
	{ 0x4ca9, 0x234a7e },
	{ 0x4caa, 0x254b6b },
	{ 0x4cab, 0x234a7d },
	{ 0x4cac, 0x255338 },
	{ 0x4cad, 0x244f3f },
	{ 0x4cae, 0x235023 },
	{ 0x4caf, 0x244f44 },
	{ 0x4cb0, 0x244f3b },
	{ 0x4cb1, 0x272b6d },
	{ 0x4cb2, 0x244f40 },
	{ 0x4cb3, 0x235028 },
	{ 0x4cb4, 0x235029 },
	{ 0x4cb5, 0x235026 },
	{ 0x4cb7, 0x234c63 },
	{ 0x4cb8, 0x244f41 },
	{ 0x4cb9, 0x24554e },
	{ 0x4cba, 0x23542f },
	{ 0x4cbb, 0x24554d },
	{ 0x4cbc, 0x235430 },
	{ 0x4cbd, 0x24554f },
	{ 0x4cbe, 0x23542b },
	{ 0x4cbf, 0x245554 },
	{ 0x4cc0, 0x27364a },
	{ 0x4cc1, 0x24554a },
	{ 0x4cc2, 0x23542e },
	{ 0x4cc3, 0x245557 },
	{ 0x4cc4, 0x23574b },
	{ 0x4cc5, 0x24554b },
	{ 0x4cc6, 0x235431 },
	{ 0x4cc7, 0x245555 },
	{ 0x4cc8, 0x235434 },
	{ 0x4cc9, 0x245550 },
	{ 0x4cca, 0x273651 },
	{ 0x4ccb, 0x235633 },
	{ 0x4ccc, 0x23574c },
	{ 0x4ccd, 0x245a51 },
	{ 0x4cce, 0x235747 },
	{ 0x4ccf, 0x235749 },
	{ 0x4cd0, 0x235746 },
	{ 0x4cd1, 0x245a52 },
	{ 0x4cd2, 0x23574e },
	{ 0x4cd3, 0x245a50 },
	{ 0x4cd4, 0x245f2f },
	{ 0x4cd5, 0x245f35 },
	{ 0x4cd6, 0x245f2c },
	{ 0x4cd7, 0x235a21 },
	{ 0x4cd8, 0x23597c },
	{ 0x4cd9, 0x245f32 },
	{ 0x4cda, 0x245f31 },
	{ 0x4cdb, 0x256726 },
	{ 0x4cdc, 0x245f38 },
	{ 0x4cdd, 0x24626a },
	{ 0x4cde, 0x235c21 },
	{ 0x4cdf, 0x24626c },
	{ 0x4ce0, 0x246561 },
	{ 0x4ce1, 0x235c28 },
	{ 0x4ce2, 0x24626f },
	{ 0x4ce3, 0x256b3c },
	{ 0x4ce4, 0x245f36 },
	{ 0x4ce5, 0x2f6475 },
	{ 0x4ce6, 0x235d78 },
	{ 0x4ce7, 0x24656c },
	{ 0x4ce8, 0x235d7d },
	{ 0x4ce9, 0x235d7b },
	{ 0x4cea, 0x24656a },
	{ 0x4ceb, 0x246564 },
	{ 0x4cec, 0x235d7c },
	{ 0x4ced, 0x275242 },
	{ 0x4cee, 0x246562 },
	{ 0x4cef, 0x24656b },
	{ 0x4cf0, 0x235d7e },
	{ 0x4cf1, 0x235f34 },
	{ 0x4cf2, 0x246840 },
	{ 0x4cf3, 0x246842 },
	{ 0x4cf4, 0x246841 },
	{ 0x4cf5, 0x257263 },
	{ 0x4cf6, 0x235f33 },
	{ 0x4cf7, 0x246a27 },
	{ 0x4cf8, 0x246a2c },
	{ 0x4cfa, 0x236028 },
	{ 0x4cfb, 0x246a26 },
	{ 0x4cfc, 0x236026 },
	{ 0x4cfd, 0x236027 },
	{ 0x4cfe, 0x246b45 },
	{ 0x4cff, 0x23606b },
	{ 0x4d00, 0x25772c },
	{ 0x4d01, 0x246b44 },
	{ 0x4d02, 0x257734 },
	{ 0x4d03, 0x246b47 },
	{ 0x4d04, 0x23606a },
	{ 0x4d05, 0x236069 },
	{ 0x4d06, 0x246b48 },
	{ 0x4d07, 0x246c50 },
	{ 0x4d08, 0x246c52 },
	{ 0x4d09, 0x246c51 },
	{ 0x4d0a, 0x236136 },
	{ 0x4d0b, 0x246c54 },
	{ 0x4d0c, 0x246d3d },
	{ 0x4d0d, 0x23615c },
	{ 0x4d0e, 0x276337 },
	{ 0x4d0f, 0x23622a },
	{ 0x4d10, 0x23623e },
	{ 0x4d11, 0x246e59 },
	{ 0x4d12, 0x236243 },
	{ 0x4d1a, 0x244f47 },
	{ 0x4d1b, 0x245f39 },
	{ 0x4d1c, 0x275729 },
	{ 0x4d1d, 0x246b4d },
	{ 0x4d1e, 0x257973 },
	{ 0x4d1f, 0x254b6d },
	{ 0x4d20, 0x244f49 },
	{ 0x4d21, 0x244f4a },
	{ 0x4d22, 0x23502d },
	{ 0x4d23, 0x235438 },
	{ 0x4d24, 0x245558 },
	{ 0x4d25, 0x27365c },
	{ 0x4d26, 0x235a23 },
	{ 0x4d27, 0x246272 },
	{ 0x4d29, 0x235f39 },
	{ 0x4d2a, 0x236137 },
	{ 0x4d2b, 0x236138 },
	{ 0x4d2c, 0x244873 },
	{ 0x4d2d, 0x244874 },
	{ 0x4d2e, 0x234b21 },
	{ 0x4d2f, 0x244f4d },
	{ 0x4d30, 0x244f4b },
	{ 0x4d31, 0x245559 },
	{ 0x4d32, 0x24555c },
	{ 0x4d33, 0x24555a },
	{ 0x4d34, 0x24555d },
	{ 0x4d35, 0x23574f },
	{ 0x4d36, 0x245f3c },
	{ 0x4d37, 0x245f3b },
	{ 0x4d38, 0x235a27 },
	{ 0x4d39, 0x246279 },
	{ 0x4d3a, 0x246276 },
	{ 0x4d3b, 0x24627d },
	{ 0x4d3c, 0x246277 },
	{ 0x4d3d, 0x24627c },
	{ 0x4d3e, 0x246849 },
	{ 0x4d3f, 0x246848 },
	{ 0x4d40, 0x24684a },
	{ 0x4d41, 0x25754d },
	{ 0x4d42, 0x257548 },
	{ 0x4d43, 0x246b4e },
	{ 0x4d44, 0x236139 },
	{ 0x4d45, 0x275a7d },
	{ 0x4d46, 0x246d41 },
	{ 0x4d47, 0x272c31 },
	{ 0x4d48, 0x246571 },
	{ 0x4d49, 0x246572 },
	{ 0x4d4a, 0x273665 },
	{ 0x4d4b, 0x245f3d },
	{ 0x4d4c, 0x246321 },
	{ 0x4d4d, 0x246576 },
	{ 0x4d4e, 0x24684b },
	{ 0x4d4f, 0x246b52 },
	{ 0x4d50, 0x246c5a },
	{ 0x4d51, 0x272c33 },
	{ 0x4d52, 0x24555e },
	{ 0x4d53, 0x273667 },
	{ 0x4d54, 0x256f52 },
	{ 0x4d55, 0x246579 },
	{ 0x4d56, 0x256f54 },
	{ 0x4d57, 0x24684c },
	{ 0x4d58, 0x24684e },
	{ 0x4d59, 0x24684d },
	{ 0x4d5a, 0x246a31 },
	{ 0x4d5b, 0x246b55 },
	{ 0x4d5c, 0x246d42 },
	{ 0x4d5d, 0x24422c },
	{ 0x4d5e, 0x234b23 },
	{ 0x4d5f, 0x244f52 },
	{ 0x4d60, 0x244f53 },
	{ 0x4d61, 0x24555f },
	{ 0x4d62, 0x245a5f },
	{ 0x4d63, 0x256123 },
	{ 0x4d64, 0x256740 },
	{ 0x4d65, 0x25673d },
	{ 0x4d66, 0x245f3f },
	{ 0x4d67, 0x256741 },
	{ 0x4d68, 0x246323 },
	{ 0x4d69, 0x235c2b },
	{ 0x4d6a, 0x24657c },
	{ 0x4d6b, 0x246621 },
	{ 0x4d6c, 0x24657d },
	{ 0x4d6d, 0x256f58 },
	{ 0x4d6e, 0x246852 },
	{ 0x4d6f, 0x235f3b },
	{ 0x4d70, 0x246b56 },
	{ 0x4d71, 0x246c5b },
	{ 0x4d72, 0x246d44 },
	{ 0x4d73, 0x23615e },
	{ 0x4d74, 0x246d43 },
	{ 0x4d75, 0x246d6f },
	{ 0x4d76, 0x245f40 },
	{ 0x4d77, 0x235c2c },
	{ 0x4d78, 0x246a37 },
	{ 0x4d79, 0x23613a },
	{ 0x4d7a, 0x245561 },
	{ 0x4d7b, 0x246c61 },
	{ 0x4d7c, 0x246c62 },
	{ 0x4d7d, 0x245f43 },
	{ 0x4d7e, 0x245f42 },
	{ 0x4d7f, 0x245f44 },
	{ 0x4d80, 0x246326 },
	{ 0x4d81, 0x246859 },
	{ 0x4d82, 0x245562 },
	{ 0x4d83, 0x245a63 },
	{ 0x4d84, 0x245f45 },
	{ 0x4d85, 0x246327 },
	{ 0x4d86, 0x24685a },
	{ 0x4d87, 0x23602a },
	{ 0x4d88, 0x246b58 },
	{ 0x4d89, 0x246b5b },
	{ 0x4d8a, 0x235a2c },
	{ 0x4d8b, 0x245f46 },
	{ 0x4d8c, 0x235e23 },
	{ 0x4d8d, 0x275267 },
	{ 0x4d8e, 0x256f61 },
	{ 0x4d8f, 0x24685c },
	{ 0x4d90, 0x246e31 },
	{ 0x4d91, 0x257b7a },
	{ 0x4d92, 0x245a66 },
	{ 0x4d93, 0x25612d },
	{ 0x4d94, 0x245f48 },
	{ 0x4d95, 0x246329 },
	{ 0x4d96, 0x24632b },
	{ 0x4d97, 0x246627 },
	{ 0x4d98, 0x246625 },
	{ 0x4d99, 0x246626 },
	{ 0x4d9a, 0x235f3d },
	{ 0x4d9b, 0x246861 },
	{ 0x4d9c, 0x246a3d },
	{ 0x4d9d, 0x246a3c },
	{ 0x4d9e, 0x23606e },
	{ 0x4d9f, 0x25774d },
	{ 0x4da0, 0x246c69 },
	{ 0x4da1, 0x246c66 },
	{ 0x4da2, 0x246c6a },
	{ 0x4da3, 0x246d4c },
	{ 0x4da4, 0x246d4b },
	{ 0x4da5, 0x246d70 },
	{ 0x4da6, 0x236176 },
	{ 0x4da7, 0x23622b },
	{ 0x4da8, 0x236232 },
	{ 0x4da9, 0x246e4b },
	{ 0x4daa, 0x246e4c },
	{ 0x4dab, 0x246e5a },
	{ 0x4dac, 0x257561 },
	{ 0x4daf, 0x256b69 },
	{ 0x4db0, 0x256c44 },
	{ 0x4db1, 0x246862 },
	{ 0x4db3, 0x246863 },
	{ 0x4db4, 0x246d51 },
	{ 0x4db5, 0x23622c },
	{ 0x4e00, 0x214421 },
	{ 0x4e01, 0x214423 },
	{ 0x4e02, 0x242126 },
	{ 0x4e03, 0x214424 },
	{ 0x4e04, 0x232126 },
	{ 0x4e05, 0x232125 },
	{ 0x4e07, 0x222126 },
	{ 0x4e08, 0x214437 },
	{ 0x4e09, 0x214435 },
	{ 0x4e0a, 0x214438 },
	{ 0x4e0b, 0x214436 },
	{ 0x4e0c, 0x222127 },
	{ 0x4e0d, 0x214462 },
	{ 0x4e0e, 0x22212f },
	{ 0x4e0f, 0x22212d },
	{ 0x4e10, 0x214461 },
	{ 0x4e11, 0x214460 },
	{ 0x4e12, 0x242139 },
	{ 0x4e14, 0x214562 },
	{ 0x4e15, 0x214561 },
	{ 0x4e16, 0x214560 },
	{ 0x4e17, 0x242155 },
	{ 0x4e18, 0x214563 },
	{ 0x4e19, 0x21455f },
	{ 0x4e1e, 0x214722 },
	{ 0x4e1f, 0x214723 },
	{ 0x4e20, 0x232262 },
	{ 0x4e21, 0x232261 },
	{ 0x4e22, 0x232263 },
	{ 0x4e23, 0x242335 },
	{ 0x4e24, 0x23243f },
	{ 0x4e26, 0x214b64 },
	{ 0x4e28, 0x232121 },
	{ 0x4e29, 0x242127 },
	{ 0x4e2a, 0x23212c },
	{ 0x4e2b, 0x214439 },
	{ 0x4e2d, 0x214463 },
	{ 0x4e2e, 0x222130 },
	{ 0x4e2f, 0x24213a },
	{ 0x4e30, 0x214464 },
	{ 0x4e31, 0x222143 },
	{ 0x4e32, 0x21486b },
	{ 0x4e33, 0x222531 },
	{ 0x4e35, 0x242b5e },
	{ 0x4e36, 0x232122 },
	{ 0x4e38, 0x21443a },
	{ 0x4e39, 0x214465 },
	{ 0x4e3b, 0x214564 },
	{ 0x4e3c, 0x222144 },
	{ 0x4e3d, 0x232740 },
	{ 0x4e3f, 0x232123 },
	{ 0x4e40, 0x242122 },
	{ 0x4e41, 0x242123 },
	{ 0x4e42, 0x222121 },
	{ 0x4e43, 0x214425 },
	{ 0x4e45, 0x21443c },
	{ 0x4e46, 0x232130 },
	{ 0x4e47, 0x222128 },
	{ 0x4e48, 0x21443d },
	{ 0x4e49, 0x23212e },
	{ 0x4e4b, 0x214466 },
	{ 0x4e4d, 0x214565 },
	{ 0x4e4e, 0x214567 },
	{ 0x4e4f, 0x214566 },
	{ 0x4e51, 0x242227 },
	{ 0x4e52, 0x214724 },
	{ 0x4e53, 0x214725 },
	{ 0x4e54, 0x232345 },
	{ 0x4e56, 0x214b65 },
	{ 0x4e57, 0x232b22 },
	{ 0x4e58, 0x21537d },
	{ 0x4e59, 0x214422 },
	{ 0x4e5a, 0x242124 },
	{ 0x4e5c, 0x222122 },
	{ 0x4e5d, 0x214426 },
	{ 0x4e5e, 0x21443f },
	{ 0x4e5f, 0x21443e },
	{ 0x4e62, 0x232146 },
	{ 0x4e63, 0x232145 },
	{ 0x4e68, 0x232264 },
	{ 0x4e69, 0x214726 },
	{ 0x4e6a, 0x242228 },
	{ 0x4e71, 0x232440 },
	{ 0x4e73, 0x214b66 },
	{ 0x4e74, 0x242531 },
	{ 0x4e75, 0x242530 },
	{ 0x4e79, 0x232b23 },
	{ 0x4e7e, 0x215871 },
	{ 0x4e7f, 0x22334e },
	{ 0x4e80, 0x23396c },
	{ 0x4e81, 0x23396e },
	{ 0x4e82, 0x21632a },
	{ 0x4e83, 0x224156 },
	{ 0x4e84, 0x224157 },
	{ 0x4e85, 0x232124 },
	{ 0x4e86, 0x214427 },
	{ 0x4e87, 0x23212d },
	{ 0x4e88, 0x214468 },
	{ 0x4e89, 0x232265 },
	{ 0x4e8b, 0x214b67 },
	{ 0x4e8c, 0x214428 },
	{ 0x4e8d, 0x222129 },
	{ 0x4e8e, 0x214440 },
	{ 0x4e8f, 0x232131 },
	{ 0x4e91, 0x214469 },
	{ 0x4e92, 0x21446b },
	{ 0x4e93, 0x222131 },
	{ 0x4e94, 0x21446c },
	{ 0x4e95, 0x21446a },
	{ 0x4e96, 0x24213b },
	{ 0x4e97, 0x23216c },
	{ 0x4e98, 0x232266 },
	{ 0x4e99, 0x214727 },
	{ 0x4e9b, 0x214b68 },
	{ 0x4e9c, 0x232442 },
	{ 0x4e9d, 0x232742 },
	{ 0x4e9e, 0x214b69 },
	{ 0x4e9f, 0x214f67 },
	{ 0x4ea0, 0x212728 },
	{ 0x4ea1, 0x214441 },
	{ 0x4ea2, 0x21446d },
	{ 0x4ea3, 0x232147 },
	{ 0x4ea4, 0x214728 },
	{ 0x4ea5, 0x21472a },
	{ 0x4ea6, 0x214729 },
	{ 0x4ea8, 0x21486c },
	{ 0x4eab, 0x214b6a },
	{ 0x4eac, 0x214b6b },
	{ 0x4ead, 0x214f68 },
	{ 0x4eae, 0x214f69 },
	{ 0x4eaf, 0x232b26 },
	{ 0x4eb0, 0x232b25 },
	{ 0x4eb1, 0x232b27 },
	{ 0x4eb2, 0x232b24 },
	{ 0x4eb3, 0x21537e },
	{ 0x4eb4, 0x24362e },
	{ 0x4eb6, 0x224158 },
	{ 0x4eb7, 0x234033 },
	{ 0x4eb9, 0x226d44 },
	{ 0x4eba, 0x214429 },
	{ 0x4ebc, 0x232132 },
	{ 0x4ebe, 0x232133 },
	{ 0x4ec0, 0x21446f },
	{ 0x4ec1, 0x21446e },
	{ 0x4ec2, 0x222132 },
	{ 0x4ec3, 0x214470 },
	{ 0x4ec4, 0x214476 },
	{ 0x4ec5, 0x232149 },
	{ 0x4ec6, 0x214471 },
	{ 0x4ec7, 0x214472 },
	{ 0x4ec8, 0x222134 },
	{ 0x4ec9, 0x222133 },
	{ 0x4eca, 0x214474 },
	{ 0x4ecb, 0x214475 },
	{ 0x4ecc, 0x23214c },
	{ 0x4ecd, 0x214473 },
	{ 0x4ece, 0x23214b },
	{ 0x4ecf, 0x23214a },
	{ 0x4ed0, 0x24213c },
	{ 0x4ed4, 0x21456a },
	{ 0x4ed5, 0x21456b },
	{ 0x4ed6, 0x21456c },
	{ 0x4ed7, 0x21456d },
	{ 0x4ed8, 0x214569 },
	{ 0x4ed9, 0x214570 },
	{ 0x4eda, 0x22214a },
	{ 0x4edb, 0x24215b },
	{ 0x4edc, 0x222146 },
	{ 0x4edd, 0x222149 },
	{ 0x4ede, 0x214571 },
	{ 0x4edf, 0x214623 },
	{ 0x4ee0, 0x23216d },
	{ 0x4ee1, 0x222148 },
	{ 0x4ee2, 0x24215a },
	{ 0x4ee3, 0x21456e },
	{ 0x4ee4, 0x21456f },
	{ 0x4ee5, 0x214568 },
	{ 0x4ee6, 0x232172 },
	{ 0x4ee7, 0x232170 },
	{ 0x4ee8, 0x222145 },
	{ 0x4ee9, 0x222147 },
	{ 0x4eee, 0x23226f },
	{ 0x4eef, 0x232268 },
	{ 0x4ef0, 0x214737 },
	{ 0x4ef1, 0x22216f },
	{ 0x4ef2, 0x214734 },
	{ 0x4ef3, 0x214738 },
	{ 0x4ef4, 0x222179 },
	{ 0x4ef5, 0x22216d },
	{ 0x4ef6, 0x214735 },
	{ 0x4ef7, 0x222171 },
	{ 0x4ef8, 0x23226b },
	{ 0x4ef9, 0x232267 },
	{ 0x4efa, 0x232276 },
	{ 0x4efb, 0x214736 },
	{ 0x4efc, 0x23226e },
	{ 0x4efd, 0x214739 },
	{ 0x4efe, 0x24222d },
	{ 0x4eff, 0x21472b },
	{ 0x4f00, 0x222170 },
	{ 0x4f01, 0x21473a },
	{ 0x4f02, 0x222174 },
	{ 0x4f03, 0x23226d },
	{ 0x4f04, 0x222178 },
	{ 0x4f05, 0x222175 },
	{ 0x4f06, 0x23226c },
	{ 0x4f07, 0x232274 },
	{ 0x4f08, 0x222172 },
	{ 0x4f09, 0x21472c },
	{ 0x4f0a, 0x21472e },
	{ 0x4f0b, 0x21473b },
	{ 0x4f0c, 0x24222a },
	{ 0x4f0d, 0x214730 },
	{ 0x4f0e, 0x22216a },
	{ 0x4f0f, 0x214733 },
	{ 0x4f10, 0x214731 },
	{ 0x4f11, 0x214732 },
	{ 0x4f12, 0x22217a },
	{ 0x4f13, 0x222177 },
	{ 0x4f14, 0x22216e },
	{ 0x4f15, 0x21472f },
	{ 0x4f16, 0x232270 },
	{ 0x4f17, 0x232277 },
	{ 0x4f18, 0x22216b },
	{ 0x4f19, 0x21472d },
	{ 0x4f1a, 0x232275 },
	{ 0x4f1b, 0x24222e },
	{ 0x4f1c, 0x232273 },
	{ 0x4f1d, 0x222173 },
	{ 0x4f22, 0x222176 },
	{ 0x4f28, 0x232272 },
	{ 0x4f29, 0x2f2171 },
	{ 0x4f2c, 0x22216c },
	{ 0x4f2d, 0x222328 },
	{ 0x4f2e, 0x242339 },
	{ 0x4f2f, 0x214924 },
	{ 0x4f30, 0x214875 },
	{ 0x4f31, 0x232450 },
	{ 0x4f32, 0x232448 },
	{ 0x4f33, 0x222329 },
	{ 0x4f34, 0x214872 },
	{ 0x4f35, 0x23244f },
	{ 0x4f36, 0x214926 },
	{ 0x4f37, 0x232446 },
	{ 0x4f38, 0x21487a },
	{ 0x4f39, 0x232445 },
	{ 0x4f3a, 0x214879 },
	{ 0x4f3b, 0x22227b },
	{ 0x4f3c, 0x21487d },
	{ 0x4f3d, 0x214878 },
	{ 0x4f3e, 0x222322 },
	{ 0x4f3f, 0x22232a },
	{ 0x4f40, 0x23244e },
	{ 0x4f41, 0x222326 },
	{ 0x4f42, 0x232449 },
	{ 0x4f43, 0x21487b },
	{ 0x4f44, 0x23244b },
	{ 0x4f45, 0x232443 },
	{ 0x4f46, 0x21487e },
	{ 0x4f47, 0x21486f },
	{ 0x4f48, 0x214929 },
	{ 0x4f49, 0x22227d },
	{ 0x4f4a, 0x232444 },
	{ 0x4f4b, 0x23244c },
	{ 0x4f4c, 0x22253d },
	{ 0x4f4d, 0x21486d },
	{ 0x4f4e, 0x214925 },
	{ 0x4f4f, 0x21486e },
	{ 0x4f50, 0x214876 },
	{ 0x4f51, 0x214877 },
	{ 0x4f52, 0x222324 },
	{ 0x4f53, 0x22227e },
	{ 0x4f54, 0x21487c },
	{ 0x4f55, 0x214874 },
	{ 0x4f56, 0x22227a },
	{ 0x4f57, 0x214870 },
	{ 0x4f58, 0x222327 },
	{ 0x4f59, 0x214927 },
	{ 0x4f5a, 0x21492a },
	{ 0x4f5b, 0x214873 },
	{ 0x4f5c, 0x214922 },
	{ 0x4f5d, 0x214928 },
	{ 0x4f5e, 0x214871 },
	{ 0x4f5f, 0x222325 },
	{ 0x4f60, 0x214923 },
	{ 0x4f61, 0x22232b },
	{ 0x4f62, 0x22227c },
	{ 0x4f63, 0x214921 },
	{ 0x4f64, 0x222321 },
	{ 0x4f66, 0x236448 },
	{ 0x4f67, 0x222323 },
	{ 0x4f68, 0x236449 },
	{ 0x4f69, 0x214b79 },
	{ 0x4f6a, 0x22253f },
	{ 0x4f6b, 0x22254b },
	{ 0x4f6c, 0x214b71 },
	{ 0x4f6d, 0x232747 },
	{ 0x4f6e, 0x22254c },
	{ 0x4f6f, 0x214b6c },
	{ 0x4f70, 0x214b76 },
	{ 0x4f71, 0x24253e },
	{ 0x4f72, 0x23274f },
	{ 0x4f73, 0x214b6f },
	{ 0x4f74, 0x222539 },
	{ 0x4f75, 0x214b77 },
	{ 0x4f76, 0x222538 },
	{ 0x4f77, 0x22253c },
	{ 0x4f78, 0x222543 },
	{ 0x4f79, 0x222541 },
	{ 0x4f7a, 0x214c21 },
	{ 0x4f7b, 0x214b7a },
	{ 0x4f7c, 0x222533 },
	{ 0x4f7d, 0x222535 },
	{ 0x4f7e, 0x214b7c },
	{ 0x4f7f, 0x214b70 },
	{ 0x4f80, 0x222536 },
	{ 0x4f81, 0x222542 },
	{ 0x4f82, 0x222549 },
	{ 0x4f83, 0x214b75 },
	{ 0x4f84, 0x22253b },
	{ 0x4f85, 0x222534 },
	{ 0x4f86, 0x214b74 },
	{ 0x4f87, 0x222537 },
	{ 0x4f88, 0x214b78 },
	{ 0x4f89, 0x22253a },
	{ 0x4f8a, 0x232744 },
	{ 0x4f8b, 0x214b73 },
	{ 0x4f8c, 0x232751 },
	{ 0x4f8d, 0x214b6e },
	{ 0x4f8e, 0x232748 },
	{ 0x4f8f, 0x214b7d },
	{ 0x4f90, 0x222544 },
	{ 0x4f91, 0x214b7e },
	{ 0x4f92, 0x222548 },
	{ 0x4f93, 0x232743 },
	{ 0x4f94, 0x222546 },
	{ 0x4f95, 0x22254a },
	{ 0x4f96, 0x214b7b },
	{ 0x4f97, 0x22253e },
	{ 0x4f98, 0x222532 },
	{ 0x4f99, 0x242536 },
	{ 0x4f9a, 0x222540 },
	{ 0x4f9b, 0x214b72 },
	{ 0x4f9c, 0x222545 },
	{ 0x4f9d, 0x214b6d },
	{ 0x4f9e, 0x222547 },
	{ 0x4f9f, 0x23274c },
	{ 0x4fa0, 0x232749 },
	{ 0x4fa1, 0x23274b },
	{ 0x4fa2, 0x23274a },
	{ 0x4fa3, 0x23274d },
	{ 0x4fab, 0x2f2544 },
	{ 0x4fae, 0x214f78 },
	{ 0x4faf, 0x214f6c },
	{ 0x4fb0, 0x232b2d },
	{ 0x4fb1, 0x232b2e },
	{ 0x4fb2, 0x222922 },
	{ 0x4fb3, 0x22292a },
	{ 0x4fb4, 0x232b36 },
	{ 0x4fb5, 0x214f6b },
	{ 0x4fb6, 0x214f73 },
	{ 0x4fb7, 0x215021 },
	{ 0x4fb8, 0x232b2c },
	{ 0x4fb9, 0x222930 },
	{ 0x4fba, 0x22292e },
	{ 0x4fbb, 0x222929 },
	{ 0x4fbc, 0x242838 },
	{ 0x4fbd, 0x24283e },
	{ 0x4fbe, 0x232b2b },
	{ 0x4fbf, 0x214f6d },
	{ 0x4fc0, 0x22292f },
	{ 0x4fc1, 0x222925 },
	{ 0x4fc2, 0x214f7b },
	{ 0x4fc3, 0x214f72 },
	{ 0x4fc4, 0x214f7a },
	{ 0x4fc5, 0x22287e },
	{ 0x4fc6, 0x232b32 },
	{ 0x4fc7, 0x22292c },
	{ 0x4fc8, 0x232b2f },
	{ 0x4fc9, 0x222923 },
	{ 0x4fca, 0x214f76 },
	{ 0x4fcb, 0x222924 },
	{ 0x4fcc, 0x232b33 },
	{ 0x4fcd, 0x22287d },
	{ 0x4fce, 0x214f7d },
	{ 0x4fcf, 0x214f70 },
	{ 0x4fd0, 0x214f79 },
	{ 0x4fd1, 0x214f6f },
	{ 0x4fd2, 0x232b28 },
	{ 0x4fd3, 0x222921 },
	{ 0x4fd4, 0x222926 },
	{ 0x4fd5, 0x232b29 },
	{ 0x4fd6, 0x22292d },
	{ 0x4fd7, 0x214f77 },
	{ 0x4fd8, 0x214f74 },
	{ 0x4fd9, 0x222928 },
	{ 0x4fda, 0x214f7c },
	{ 0x4fdb, 0x22292b },
	{ 0x4fdc, 0x222927 },
	{ 0x4fdd, 0x214f71 },
	{ 0x4fde, 0x214f7e },
	{ 0x4fdf, 0x214f75 },
	{ 0x4fe0, 0x214f6e },
	{ 0x4fe1, 0x214f6a },
	{ 0x4fe2, 0x24283f },
	{ 0x4fe3, 0x232b35 },
	{ 0x4fe4, 0x2f292d },
	{ 0x4fe5, 0x232b34 },
	{ 0x4fe7, 0x23644a },
	{ 0x4fe9, 0x24283d },
	{ 0x4fec, 0x222931 },
	{ 0x4fee, 0x21543a },
	{ 0x4fef, 0x215424 },
	{ 0x4ff0, 0x232f48 },
	{ 0x4ff1, 0x215434 },
	{ 0x4ff2, 0x232f4d },
	{ 0x4ff3, 0x215439 },
	{ 0x4ff4, 0x222d71 },
	{ 0x4ff5, 0x222d70 },
	{ 0x4ff6, 0x222d75 },
	{ 0x4ff7, 0x222d76 },
	{ 0x4ff8, 0x215427 },
	{ 0x4ff9, 0x232f44 },
	{ 0x4ffa, 0x215430 },
	{ 0x4ffb, 0x232f58 },
	{ 0x4ffc, 0x232f4c },
	{ 0x4ffd, 0x232f56 },
	{ 0x4ffe, 0x21543d },
	{ 0x4fff, 0x232f46 },
	{ 0x5000, 0x215431 },
	{ 0x5001, 0x242b62 },
	{ 0x5002, 0x232f4b },
	{ 0x5003, 0x232f49 },
	{ 0x5004, 0x232f47 },
	{ 0x5005, 0x222d6a },
	{ 0x5006, 0x21542a },
	{ 0x5007, 0x222d6b },
	{ 0x5008, 0x232f4f },
	{ 0x5009, 0x21543f },
	{ 0x500a, 0x242b64 },
	{ 0x500b, 0x215436 },
	{ 0x500c, 0x215421 },
	{ 0x500d, 0x215422 },
	{ 0x500e, 0x222d7e },
	{ 0x500f, 0x215924 },
	{ 0x5010, 0x232f53 },
	{ 0x5011, 0x21542f },
	{ 0x5012, 0x21542e },
	{ 0x5013, 0x222d6c },
	{ 0x5014, 0x215432 },
	{ 0x5015, 0x22335e },
	{ 0x5016, 0x215429 },
	{ 0x5017, 0x222d77 },
	{ 0x5018, 0x215438 },
	{ 0x5019, 0x215437 },
	{ 0x501a, 0x21542d },
	{ 0x501b, 0x222d6f },
	{ 0x501c, 0x222d78 },
	{ 0x501d, 0x232f45 },
	{ 0x501e, 0x222d69 },
	{ 0x501f, 0x21542c },
	{ 0x5020, 0x222d79 },
	{ 0x5021, 0x215435 },
	{ 0x5022, 0x222d6d },
	{ 0x5023, 0x215423 },
	{ 0x5024, 0x232f4e },
	{ 0x5025, 0x215426 },
	{ 0x5026, 0x215425 },
	{ 0x5027, 0x222d7a },
	{ 0x5028, 0x215433 },
	{ 0x5029, 0x215428 },
	{ 0x502a, 0x21543c },
	{ 0x502b, 0x21543e },
	{ 0x502c, 0x222d74 },
	{ 0x502d, 0x21543b },
	{ 0x502e, 0x232f51 },
	{ 0x502f, 0x222d7c },
	{ 0x5030, 0x222d6e },
	{ 0x5031, 0x222d7d },
	{ 0x5032, 0x232f43 },
	{ 0x5033, 0x222d72 },
	{ 0x5034, 0x242b61 },
	{ 0x5035, 0x222d7b },
	{ 0x5036, 0x232f50 },
	{ 0x5037, 0x222d73 },
	{ 0x5038, 0x232f54 },
	{ 0x5039, 0x232f55 },
	{ 0x503c, 0x21542b },
	{ 0x503f, 0x23644b },
	{ 0x5040, 0x223366 },
	{ 0x5041, 0x22335a },
	{ 0x5042, 0x23343c },
	{ 0x5043, 0x215876 },
	{ 0x5044, 0x23343f },
	{ 0x5045, 0x22335f },
	{ 0x5046, 0x223365 },
	{ 0x5047, 0x215875 },
	{ 0x5048, 0x223358 },
	{ 0x5049, 0x215879 },
	{ 0x504a, 0x22335c },
	{ 0x504b, 0x223355 },
	{ 0x504c, 0x215877 },
	{ 0x504d, 0x223359 },
	{ 0x504e, 0x21587c },
	{ 0x504f, 0x215923 },
	{ 0x5050, 0x233444 },
	{ 0x5051, 0x22336a },
	{ 0x5052, 0x233441 },
	{ 0x5053, 0x223354 },
	{ 0x5054, 0x233442 },
	{ 0x5055, 0x21587d },
	{ 0x5056, 0x232f57 },
	{ 0x5057, 0x223369 },
	{ 0x5058, 0x233447 },
	{ 0x5059, 0x23343d },
	{ 0x505a, 0x215878 },
	{ 0x505b, 0x22335b },
	{ 0x505c, 0x215874 },
	{ 0x505d, 0x223356 },
	{ 0x505e, 0x223352 },
	{ 0x505f, 0x223360 },
	{ 0x5060, 0x223353 },
	{ 0x5061, 0x223351 },
	{ 0x5062, 0x22335d },
	{ 0x5063, 0x223363 },
	{ 0x5064, 0x223364 },
	{ 0x5065, 0x21587a },
	{ 0x5066, 0x233440 },
	{ 0x5067, 0x243047 },
	{ 0x5068, 0x223a3f },
	{ 0x5069, 0x223361 },
	{ 0x506a, 0x223350 },
	{ 0x506b, 0x223362 },
	{ 0x506c, 0x23344b },
	{ 0x506d, 0x215926 },
	{ 0x506e, 0x223367 },
	{ 0x506f, 0x215925 },
	{ 0x5070, 0x22334f },
	{ 0x5071, 0x233443 },
	{ 0x5072, 0x223357 },
	{ 0x5073, 0x223368 },
	{ 0x5074, 0x215921 },
	{ 0x5075, 0x21587e },
	{ 0x5076, 0x21587b },
	{ 0x5077, 0x215922 },
	{ 0x5078, 0x23344c },
	{ 0x5079, 0x23344a },
	{ 0x507a, 0x215872 },
	{ 0x507b, 0x233445 },
	{ 0x507c, 0x233446 },
	{ 0x507d, 0x215873 },
	{ 0x5080, 0x215e2e },
	{ 0x5081, 0x233975 },
	{ 0x5082, 0x223a42 },
	{ 0x5083, 0x223a3b },
	{ 0x5084, 0x243634 },
	{ 0x5085, 0x215e2b },
	{ 0x5086, 0x243633 },
	{ 0x5087, 0x223a43 },
	{ 0x5088, 0x233971 },
	{ 0x5089, 0x233972 },
	{ 0x508a, 0x243636 },
	{ 0x508b, 0x223a39 },
	{ 0x508c, 0x223a3c },
	{ 0x508d, 0x215e2a },
	{ 0x508e, 0x223a3d },
	{ 0x508f, 0x23396f },
	{ 0x5090, 0x243631 },
	{ 0x5091, 0x215e2d },
	{ 0x5092, 0x223a41 },
	{ 0x5093, 0x24363c },
	{ 0x5094, 0x223a37 },
	{ 0x5095, 0x223a36 },
	{ 0x5096, 0x215e2f },
	{ 0x5097, 0x233970 },
	{ 0x5098, 0x215e30 },
	{ 0x5099, 0x215e2c },
	{ 0x509a, 0x215e31 },
	{ 0x509b, 0x223a35 },
	{ 0x509c, 0x223a40 },
	{ 0x509d, 0x223a3e },
	{ 0x509e, 0x223a38 },
	{ 0x509f, 0x243639 },
	{ 0x50a0, 0x243630 },
	{ 0x50a1, 0x24363a },
	{ 0x50a2, 0x215e29 },
	{ 0x50a3, 0x223a3a },
	{ 0x50a6, 0x23644d },
	{ 0x50aa, 0x234039 },
	{ 0x50ab, 0x23403c },
	{ 0x50ac, 0x216331 },
	{ 0x50ad, 0x21632b },
	{ 0x50ae, 0x22415c },
	{ 0x50af, 0x216334 },
	{ 0x50b0, 0x224162 },
	{ 0x50b1, 0x224165 },
	{ 0x50b2, 0x21632d },
	{ 0x50b3, 0x21632e },
	{ 0x50b4, 0x22415f },
	{ 0x50b5, 0x21632c },
	{ 0x50b6, 0x224168 },
	{ 0x50b7, 0x216332 },
	{ 0x50b8, 0x224169 },
	{ 0x50b9, 0x23403a },
	{ 0x50ba, 0x224164 },
	{ 0x50bb, 0x216333 },
	{ 0x50bc, 0x234037 },
	{ 0x50bd, 0x224159 },
	{ 0x50be, 0x216330 },
	{ 0x50bf, 0x22415a },
	{ 0x50c0, 0x243c29 },
	{ 0x50c1, 0x224163 },
	{ 0x50c2, 0x224161 },
	{ 0x50c3, 0x23403d },
	{ 0x50c4, 0x22415d },
	{ 0x50c5, 0x21632f },
	{ 0x50c6, 0x22415b },
	{ 0x50c7, 0x216335 },
	{ 0x50c8, 0x224160 },
	{ 0x50c9, 0x224167 },
	{ 0x50ca, 0x22415e },
	{ 0x50cb, 0x224166 },
	{ 0x50cc, 0x234036 },
	{ 0x50cd, 0x23403e },
	{ 0x50ce, 0x21677c },
	{ 0x50cf, 0x216779 },
	{ 0x50d0, 0x23456b },
	{ 0x50d1, 0x21677a },
	{ 0x50d2, 0x24422d },
	{ 0x50d3, 0x224921 },
	{ 0x50d4, 0x224877 },
	{ 0x50d5, 0x216778 },
	{ 0x50d6, 0x216775 },
	{ 0x50d7, 0x224878 },
	{ 0x50d8, 0x23456e },
	{ 0x50d9, 0x23456c },
	{ 0x50da, 0x216777 },
	{ 0x50db, 0x22487b },
	{ 0x50dc, 0x23456d },
	{ 0x50dd, 0x22487d },
	{ 0x50de, 0x234576 },
	{ 0x50df, 0x244235 },
	{ 0x50e0, 0x224926 },
	{ 0x50e1, 0x234570 },
	{ 0x50e2, 0x234575 },
	{ 0x50e3, 0x224925 },
	{ 0x50e4, 0x22487e },
	{ 0x50e5, 0x216774 },
	{ 0x50e6, 0x224876 },
	{ 0x50e7, 0x216772 },
	{ 0x50e8, 0x224879 },
	{ 0x50e9, 0x21677d },
	{ 0x50ea, 0x22487c },
	{ 0x50eb, 0x234571 },
	{ 0x50ec, 0x224922 },
	{ 0x50ed, 0x216776 },
	{ 0x50ee, 0x216773 },
	{ 0x50ef, 0x224924 },
	{ 0x50f0, 0x224923 },
	{ 0x50f1, 0x21677b },
	{ 0x50f3, 0x22487a },
	{ 0x50f4, 0x234574 },
	{ 0x50f5, 0x216c23 },
	{ 0x50f6, 0x224f54 },
	{ 0x50f7, 0x234b29 },
	{ 0x50f8, 0x224f51 },
	{ 0x50f9, 0x216c24 },
	{ 0x50fa, 0x244879 },
	{ 0x50fb, 0x216c22 },
	{ 0x50fc, 0x234b2b },
	{ 0x50fd, 0x224f58 },
	{ 0x50fe, 0x224f55 },
	{ 0x50ff, 0x224f4e },
	{ 0x5100, 0x216c21 },
	{ 0x5101, 0x234b2d },
	{ 0x5102, 0x216c25 },
	{ 0x5103, 0x224f4f },
	{ 0x5104, 0x216b7e },
	{ 0x5105, 0x216c28 },
	{ 0x5106, 0x224f52 },
	{ 0x5107, 0x224f53 },
	{ 0x5108, 0x216c26 },
	{ 0x5109, 0x216c27 },
	{ 0x510a, 0x224f59 },
	{ 0x510b, 0x224f56 },
	{ 0x510c, 0x224f57 },
	{ 0x510d, 0x234b2c },
	{ 0x510e, 0x234b27 },
	{ 0x510f, 0x23644e },
	{ 0x5110, 0x217033 },
	{ 0x5111, 0x225643 },
	{ 0x5112, 0x217030 },
	{ 0x5113, 0x225640 },
	{ 0x5114, 0x217032 },
	{ 0x5115, 0x217034 },
	{ 0x5116, 0x235031 },
	{ 0x5117, 0x225641 },
	{ 0x5118, 0x217031 },
	{ 0x5119, 0x244f5a },
	{ 0x511a, 0x225642 },
	{ 0x511b, 0x235035 },
	{ 0x511c, 0x22563f },
	{ 0x511d, 0x235030 },
	{ 0x511e, 0x235034 },
	{ 0x511f, 0x217341 },
	{ 0x5120, 0x225c49 },
	{ 0x5121, 0x217342 },
	{ 0x5122, 0x225c47 },
	{ 0x5123, 0x245565 },
	{ 0x5124, 0x225c48 },
	{ 0x5125, 0x225c46 },
	{ 0x5126, 0x225c45 },
	{ 0x5127, 0x235441 },
	{ 0x5128, 0x235440 },
	{ 0x5129, 0x225c4a },
	{ 0x512a, 0x217340 },
	{ 0x512b, 0x235033 },
	{ 0x512c, 0x245569 },
	{ 0x512d, 0x226144 },
	{ 0x512e, 0x226145 },
	{ 0x512f, 0x235752 },
	{ 0x5130, 0x224f50 },
	{ 0x5131, 0x226143 },
	{ 0x5132, 0x217343 },
	{ 0x5133, 0x21782b },
	{ 0x5134, 0x226537 },
	{ 0x5135, 0x226538 },
	{ 0x5136, 0x235c32 },
	{ 0x5137, 0x217a62 },
	{ 0x5138, 0x217a63 },
	{ 0x5139, 0x226b4f },
	{ 0x513a, 0x226b4e },
	{ 0x513b, 0x217b58 },
	{ 0x513c, 0x217b57 },
	{ 0x513d, 0x226e7d },
	{ 0x513e, 0x23606f },
	{ 0x513f, 0x21442a },
	{ 0x5140, 0x214442 },
	{ 0x5141, 0x214478 },
	{ 0x5142, 0x24213d },
	{ 0x5143, 0x214477 },
	{ 0x5144, 0x214573 },
	{ 0x5145, 0x214572 },
	{ 0x5146, 0x21473e },
	{ 0x5147, 0x21473d },
	{ 0x5148, 0x21473f },
	{ 0x5149, 0x21473c },
	{ 0x514a, 0x232278 },
	{ 0x514b, 0x21492c },
	{ 0x514c, 0x21492b },
	{ 0x514d, 0x21492d },
	{ 0x514e, 0x232454 },
	{ 0x514f, 0x24233b },
	{ 0x5150, 0x232453 },
	{ 0x5151, 0x232451 },
	{ 0x5152, 0x214c23 },
	{ 0x5153, 0x24253f },
	{ 0x5154, 0x214c22 },
	{ 0x5155, 0x214c24 },
	{ 0x5156, 0x232752 },
	{ 0x5157, 0x215022 },
	{ 0x5158, 0x242840 },
	{ 0x5159, 0x212279 },
	{ 0x515a, 0x222e21 },
	{ 0x515b, 0x21227a },
	{ 0x515c, 0x215927 },
	{ 0x515d, 0x21227c },
	{ 0x515e, 0x21227b },
	{ 0x515f, 0x223a44 },
	{ 0x5160, 0x233976 },
	{ 0x5161, 0x21227d },
	{ 0x5162, 0x21677e },
	{ 0x5163, 0x21227e },
	{ 0x5164, 0x235e25 },
	{ 0x5165, 0x21442b },
	{ 0x5166, 0x232134 },
	{ 0x5167, 0x214479 },
	{ 0x5168, 0x214740 },
	{ 0x5169, 0x214c25 },
	{ 0x516a, 0x232b37 },
	{ 0x516b, 0x21442c },
	{ 0x516c, 0x21447c },
	{ 0x516d, 0x21447a },
	{ 0x516e, 0x21447b },
	{ 0x5171, 0x214741 },
	{ 0x5172, 0x23227a },
	{ 0x5173, 0x242234 },
	{ 0x5175, 0x21492e },
	{ 0x5176, 0x214c27 },
	{ 0x5177, 0x214c26 },
	{ 0x5178, 0x214c28 },
	{ 0x5179, 0x232e7b },
	{ 0x517c, 0x215440 },
	{ 0x517e, 0x23403f },
	{ 0x517f, 0x236453 },
	{ 0x5180, 0x217035 },
	{ 0x5182, 0x232127 },
	{ 0x5183, 0x24213e },
	{ 0x5184, 0x23214d },
	{ 0x5185, 0x232148 },
	{ 0x5186, 0x23214e },
	{ 0x5187, 0x22212e },
	{ 0x5188, 0x242152 },
	{ 0x5189, 0x214574 },
	{ 0x518a, 0x214575 },
	{ 0x518b, 0x232178 },
	{ 0x518c, 0x232179 },
	{ 0x518d, 0x214742 },
	{ 0x518e, 0x242236 },
	{ 0x518f, 0x22232c },
	{ 0x5190, 0x232755 },
	{ 0x5191, 0x215024 },
	{ 0x5192, 0x215023 },
	{ 0x5193, 0x222e23 },
	{ 0x5194, 0x222e22 },
	{ 0x5195, 0x215928 },
	{ 0x5196, 0x232128 },
	{ 0x5197, 0x21447d },
	{ 0x5198, 0x222135 },
	{ 0x5199, 0x23217a },
	{ 0x519d, 0x232457 },
	{ 0x519e, 0x22254d },
	{ 0x519f, 0x232b39 },
	{ 0x51a0, 0x215025 },
	{ 0x51a1, 0x232f5b },
	{ 0x51a2, 0x215443 },
	{ 0x51a3, 0x232f59 },
	{ 0x51a4, 0x215441 },
	{ 0x51a5, 0x215442 },
	{ 0x51a6, 0x232f5a },
	{ 0x51a8, 0x23344d },
	{ 0x51a9, 0x2f465c },
	{ 0x51aa, 0x217036 },
	{ 0x51ab, 0x21272f },
	{ 0x51ac, 0x214576 },
	{ 0x51ad, 0x24215e },
	{ 0x51b0, 0x214743 },
	{ 0x51b1, 0x22217b },
	{ 0x51b2, 0x23227e },
	{ 0x51b3, 0x23227d },
	{ 0x51b4, 0x23227c },
	{ 0x51b5, 0x232459 },
	{ 0x51b6, 0x21492f },
	{ 0x51b7, 0x214930 },
	{ 0x51b8, 0x23245a },
	{ 0x51b9, 0x22232d },
	{ 0x51ba, 0x24233d },
	{ 0x51bc, 0x22254e },
	{ 0x51bd, 0x214c29 },
	{ 0x51be, 0x22254f },
	{ 0x51bf, 0x242540 },
	{ 0x51c0, 0x242543 },
	{ 0x51c1, 0x232b3b },
	{ 0x51c2, 0x232b3d },
	{ 0x51c3, 0x232b3e },
	{ 0x51c4, 0x222e25 },
	{ 0x51c5, 0x222e26 },
	{ 0x51c6, 0x215446 },
	{ 0x51c7, 0x232f5e },
	{ 0x51c8, 0x222e27 },
	{ 0x51c9, 0x232f5f },
	{ 0x51ca, 0x222e24 },
	{ 0x51cb, 0x215447 },
	{ 0x51cc, 0x215445 },
	{ 0x51cd, 0x215444 },
	{ 0x51ce, 0x222e28 },
	{ 0x51cf, 0x23344f },
	{ 0x51d0, 0x22336b },
	{ 0x51d1, 0x23344e },
	{ 0x51d2, 0x23397d },
	{ 0x51d3, 0x23397a },
	{ 0x51d4, 0x223a45 },
	{ 0x51d5, 0x24363f },
	{ 0x51d6, 0x23397e },
	{ 0x51d7, 0x22416a },
	{ 0x51d8, 0x224927 },
	{ 0x51d9, 0x234b2f },
	{ 0x51da, 0x234b2e },
	{ 0x51db, 0x234b30 },
	{ 0x51dc, 0x216c29 },
	{ 0x51dd, 0x217037 },
	{ 0x51de, 0x225644 },
	{ 0x51df, 0x235442 },
	{ 0x51e0, 0x21442d },
	{ 0x51e1, 0x21443b },
	{ 0x51e2, 0x23212f },
	{ 0x51e3, 0x232135 },
	{ 0x51e4, 0x232151 },
	{ 0x51e5, 0x23217b },
	{ 0x51e8, 0x232322 },
	{ 0x51ea, 0x2f2259 },
	{ 0x51ec, 0x23245b },
	{ 0x51ed, 0x232759 },
	{ 0x51ee, 0x242545 },
	{ 0x51f0, 0x215929 },
	{ 0x51f1, 0x215e33 },
	{ 0x51f2, 0x264665 },
	{ 0x51f3, 0x216821 },
	{ 0x51f4, 0x23457a },
	{ 0x51f5, 0x222123 },
	{ 0x51f6, 0x21447e },
	{ 0x51f7, 0x242160 },
	{ 0x51f8, 0x214579 },
	{ 0x51f9, 0x214577 },
	{ 0x51fa, 0x214578 },
	{ 0x51fd, 0x214c2a },
	{ 0x51fe, 0x23275a },
	{ 0x5200, 0x21442e },
	{ 0x5201, 0x21442f },
	{ 0x5202, 0x24212a },
	{ 0x5203, 0x214443 },
	{ 0x5204, 0x232136 },
	{ 0x5205, 0x232152 },
	{ 0x5206, 0x214521 },
	{ 0x5207, 0x214522 },
	{ 0x5208, 0x214523 },
	{ 0x5209, 0x22214c },
	{ 0x520a, 0x21457a },
	{ 0x520b, 0x23217d },
	{ 0x520c, 0x22214b },
	{ 0x520e, 0x214747 },
	{ 0x520f, 0x232325 },
	{ 0x5210, 0x22217d },
	{ 0x5211, 0x214745 },
	{ 0x5212, 0x214746 },
	{ 0x5213, 0x22217c },
	{ 0x5214, 0x232324 },
	{ 0x5215, 0x232326 },
	{ 0x5216, 0x214748 },
	{ 0x5217, 0x214744 },
	{ 0x5218, 0x232327 },
	{ 0x521c, 0x22232e },
	{ 0x521d, 0x214f4f },
	{ 0x521e, 0x22232f },
	{ 0x521f, 0x23245f },
	{ 0x5220, 0x232461 },
	{ 0x5221, 0x222330 },
	{ 0x5222, 0x242340 },
	{ 0x5223, 0x23245c },
	{ 0x5224, 0x214932 },
	{ 0x5225, 0x214931 },
	{ 0x5226, 0x23245e },
	{ 0x5227, 0x23245d },
	{ 0x5228, 0x214935 },
	{ 0x5229, 0x214933 },
	{ 0x522a, 0x214934 },
	{ 0x522b, 0x232460 },
	{ 0x522e, 0x214c30 },
	{ 0x522f, 0x23275b },
	{ 0x5230, 0x214c2f },
	{ 0x5231, 0x222554 },
	{ 0x5232, 0x222551 },
	{ 0x5233, 0x222552 },
	{ 0x5234, 0x23275e },
	{ 0x5235, 0x222550 },
	{ 0x5236, 0x214c31 },
	{ 0x5237, 0x214c2d },
	{ 0x5238, 0x214c2c },
	{ 0x5239, 0x23275f },
	{ 0x523a, 0x214c2e },
	{ 0x523b, 0x214c2b },
	{ 0x523c, 0x23275d },
	{ 0x523d, 0x24254e },
	{ 0x523e, 0x23644f },
	{ 0x5241, 0x214c32 },
	{ 0x5243, 0x215027 },
	{ 0x5244, 0x222932 },
	{ 0x5245, 0x232b3f },
	{ 0x5246, 0x222553 },
	{ 0x5247, 0x21502c },
	{ 0x5248, 0x232b40 },
	{ 0x5249, 0x222933 },
	{ 0x524a, 0x215028 },
	{ 0x524b, 0x21502b },
	{ 0x524c, 0x21502a },
	{ 0x524d, 0x215029 },
	{ 0x524e, 0x215026 },
	{ 0x524f, 0x232b43 },
	{ 0x5252, 0x222e2b },
	{ 0x5253, 0x232f68 },
	{ 0x5254, 0x21544a },
	{ 0x5255, 0x222e2e },
	{ 0x5256, 0x215448 },
	{ 0x5257, 0x232f65 },
	{ 0x5258, 0x242b6e },
	{ 0x5259, 0x232f62 },
	{ 0x525a, 0x222e2a },
	{ 0x525b, 0x21544b },
	{ 0x525c, 0x215449 },
	{ 0x525d, 0x21544c },
	{ 0x525e, 0x222e2c },
	{ 0x525f, 0x222e2d },
	{ 0x5260, 0x232f60 },
	{ 0x5261, 0x222e29 },
	{ 0x5262, 0x222e2f },
	{ 0x5263, 0x232f66 },
	{ 0x5264, 0x232f61 },
	{ 0x5265, 0x232f63 },
	{ 0x5266, 0x2f2e2d },
	{ 0x5267, 0x232f64 },
	{ 0x5268, 0x233450 },
	{ 0x5269, 0x215e37 },
	{ 0x526a, 0x21592a },
	{ 0x526b, 0x22336c },
	{ 0x526c, 0x22336e },
	{ 0x526d, 0x22336d },
	{ 0x526e, 0x22336f },
	{ 0x526f, 0x21592b },
	{ 0x5270, 0x233a23 },
	{ 0x5272, 0x215e34 },
	{ 0x5273, 0x233a21 },
	{ 0x5274, 0x215e35 },
	{ 0x5275, 0x215e36 },
	{ 0x5276, 0x233451 },
	{ 0x5277, 0x216337 },
	{ 0x5278, 0x22416c },
	{ 0x5279, 0x234041 },
	{ 0x527a, 0x22416b },
	{ 0x527b, 0x22416d },
	{ 0x527c, 0x22416e },
	{ 0x527d, 0x216338 },
	{ 0x527e, 0x234040 },
	{ 0x527f, 0x216336 },
	{ 0x5280, 0x224928 },
	{ 0x5281, 0x224929 },
	{ 0x5282, 0x216823 },
	{ 0x5283, 0x216822 },
	{ 0x5284, 0x224c61 },
	{ 0x5285, 0x244925 },
	{ 0x5286, 0x234b31 },
	{ 0x5287, 0x216c2a },
	{ 0x5288, 0x216c2b },
	{ 0x5289, 0x216c2c },
	{ 0x528a, 0x216c2e },
	{ 0x528b, 0x224f5a },
	{ 0x528c, 0x224f5b },
	{ 0x528d, 0x216c2d },
	{ 0x528e, 0x234b32 },
	{ 0x5290, 0x235036 },
	{ 0x5291, 0x217038 },
	{ 0x5292, 0x244f64 },
	{ 0x5293, 0x217039 },
	{ 0x5294, 0x235037 },
	{ 0x5295, 0x24556d },
	{ 0x5296, 0x226539 },
	{ 0x5297, 0x226b51 },
	{ 0x5298, 0x226b50 },
	{ 0x5299, 0x226e7e },
	{ 0x529a, 0x23602c },
	{ 0x529b, 0x214430 },
	{ 0x529c, 0x232137 },
	{ 0x529d, 0x232154 },
	{ 0x529e, 0x232153 },
	{ 0x529f, 0x21457c },
	{ 0x52a0, 0x21457b },
	{ 0x52a3, 0x214749 },
	{ 0x52a4, 0x242242 },
	{ 0x52a5, 0x24223f },
	{ 0x52a6, 0x22217e },
	{ 0x52a7, 0x242241 },
	{ 0x52a8, 0x232328 },
	{ 0x52a9, 0x214937 },
	{ 0x52aa, 0x214938 },
	{ 0x52ab, 0x214936 },
	{ 0x52ac, 0x214939 },
	{ 0x52ad, 0x222331 },
	{ 0x52ae, 0x222332 },
	{ 0x52af, 0x242346 },
	{ 0x52b0, 0x242347 },
	{ 0x52b1, 0x242348 },
	{ 0x52b3, 0x232463 },
	{ 0x52b4, 0x232462 },
	{ 0x52b5, 0x232761 },
	{ 0x52b6, 0x25253a },
	{ 0x52b7, 0x252537 },
	{ 0x52b8, 0x252538 },
	{ 0x52b9, 0x232760 },
	{ 0x52ba, 0x25253b },
	{ 0x52bb, 0x214c34 },
	{ 0x52bc, 0x222555 },
	{ 0x52bd, 0x242550 },
	{ 0x52be, 0x214c33 },
	{ 0x52bf, 0x232762 },
	{ 0x52c0, 0x222934 },
	{ 0x52c1, 0x215030 },
	{ 0x52c2, 0x222935 },
	{ 0x52c3, 0x21502f },
	{ 0x52c4, 0x232b48 },
	{ 0x52c5, 0x232b46 },
	{ 0x52c6, 0x242849 },
	{ 0x52c7, 0x21502d },
	{ 0x52c8, 0x24284b },
	{ 0x52c9, 0x21502e },
	{ 0x52ca, 0x232b47 },
	{ 0x52cc, 0x232f6f },
	{ 0x52cd, 0x222e30 },
	{ 0x52ce, 0x232f6c },
	{ 0x52cf, 0x232f6a },
	{ 0x52d0, 0x232f6d },
	{ 0x52d1, 0x232f6e },
	{ 0x52d2, 0x21592c },
	{ 0x52d3, 0x223371 },
	{ 0x52d4, 0x233452 },
	{ 0x52d5, 0x21592f },
	{ 0x52d6, 0x223370 },
	{ 0x52d7, 0x215b2b },
	{ 0x52d8, 0x21592e },
	{ 0x52d9, 0x21592d },
	{ 0x52db, 0x215e3a },
	{ 0x52dc, 0x25366a },
	{ 0x52dd, 0x215e39 },
	{ 0x52de, 0x215e38 },
	{ 0x52df, 0x216339 },
	{ 0x52e0, 0x234045 },
	{ 0x52e1, 0x234044 },
	{ 0x52e2, 0x21633c },
	{ 0x52e3, 0x21633d },
	{ 0x52e4, 0x21633b },
	{ 0x52e5, 0x243c3c },
	{ 0x52e6, 0x21633a },
	{ 0x52e7, 0x234046 },
	{ 0x52e8, 0x254467 },
	{ 0x52e9, 0x22492a },
	{ 0x52ea, 0x234621 },
	{ 0x52eb, 0x22492b },
	{ 0x52ec, 0x254463 },
	{ 0x52ed, 0x23457e },
	{ 0x52ee, 0x234b33 },
	{ 0x52ef, 0x224f5d },
	{ 0x52f0, 0x216c2f },
	{ 0x52f1, 0x224f5c },
	{ 0x52f2, 0x234d2c },
	{ 0x52f3, 0x21703a },
	{ 0x52f4, 0x225c4b },
	{ 0x52f5, 0x217344 },
	{ 0x52f6, 0x255362 },
	{ 0x52f7, 0x22653a },
	{ 0x52f8, 0x217961 },
	{ 0x52f9, 0x212734 },
	{ 0x52fa, 0x214444 },
	{ 0x52fb, 0x214524 },
	{ 0x52fc, 0x222136 },
	{ 0x52fd, 0x232155 },
	{ 0x52fe, 0x214525 },
	{ 0x52ff, 0x214526 },
	{ 0x5300, 0x232156 },
	{ 0x5301, 0x2f2130 },
	{ 0x5303, 0x232223 },
	{ 0x5304, 0x232222 },
	{ 0x5305, 0x21457d },
	{ 0x5306, 0x21457e },
	{ 0x5307, 0x232224 },
	{ 0x5308, 0x21474a },
	{ 0x5309, 0x222333 },
	{ 0x530a, 0x222556 },
	{ 0x530b, 0x222557 },
	{ 0x530c, 0x242551 },
	{ 0x530d, 0x215031 },
	{ 0x530e, 0x222e31 },
	{ 0x530f, 0x215931 },
	{ 0x5310, 0x215930 },
	{ 0x5311, 0x223a47 },
	{ 0x5312, 0x223a46 },
	{ 0x5313, 0x265074 },
	{ 0x5314, 0x235038 },
	{ 0x5315, 0x214431 },
	{ 0x5316, 0x214527 },
	{ 0x5317, 0x214621 },
	{ 0x5318, 0x24305e },
	{ 0x5319, 0x215932 },
	{ 0x531a, 0x222124 },
	{ 0x531b, 0x242165 },
	{ 0x531c, 0x22214d },
	{ 0x531d, 0x214622 },
	{ 0x531e, 0x232226 },
	{ 0x531f, 0x222222 },
	{ 0x5320, 0x21474c },
	{ 0x5321, 0x21474b },
	{ 0x5322, 0x222221 },
	{ 0x5323, 0x21493a },
	{ 0x5324, 0x236450 },
	{ 0x5325, 0x232465 },
	{ 0x5327, 0x232b49 },
	{ 0x5328, 0x24284e },
	{ 0x5329, 0x242850 },
	{ 0x532a, 0x21544d },
	{ 0x532b, 0x242b78 },
	{ 0x532c, 0x24305f },
	{ 0x532d, 0x223372 },
	{ 0x532f, 0x21633e },
	{ 0x5330, 0x22492c },
	{ 0x5331, 0x216824 },
	{ 0x5332, 0x234623 },
	{ 0x5333, 0x234b34 },
	{ 0x5334, 0x225645 },
	{ 0x5335, 0x235444 },
	{ 0x5336, 0x235c34 },
	{ 0x5337, 0x22686a },
	{ 0x5338, 0x232129 },
	{ 0x5339, 0x214528 },
	{ 0x533a, 0x232157 },
	{ 0x533b, 0x232466 },
	{ 0x533c, 0x222558 },
	{ 0x533d, 0x222936 },
	{ 0x533e, 0x215935 },
	{ 0x533f, 0x215933 },
	{ 0x5340, 0x215934 },
	{ 0x5341, 0x214432 },
	{ 0x5342, 0x242130 },
	{ 0x5343, 0x214445 },
	{ 0x5344, 0x21243f },
	{ 0x5344, 0x232138 },
	{ 0x5345, 0x21452b },
	{ 0x5346, 0x232159 },
	{ 0x5347, 0x21452a },
	{ 0x5348, 0x214529 },
	{ 0x5349, 0x214625 },
	{ 0x534a, 0x214624 },
	{ 0x534b, 0x23232a },
	{ 0x534c, 0x22214e },
	{ 0x534d, 0x222223 },
	{ 0x534e, 0x2f222c },
	{ 0x534f, 0x23232b },
	{ 0x5350, 0x23232d },
	{ 0x5351, 0x214c38 },
	{ 0x5352, 0x214c35 },
	{ 0x5353, 0x214c37 },
	{ 0x5354, 0x214c36 },
	{ 0x5355, 0x232763 },
	{ 0x5357, 0x215032 },
	{ 0x5358, 0x232b4a },
	{ 0x5359, 0x243060 },
	{ 0x535a, 0x215e3b },
	{ 0x535b, 0x246630 },
	{ 0x535c, 0x214433 },
	{ 0x535d, 0x23215a },
	{ 0x535e, 0x21452c },
	{ 0x535f, 0x232227 },
	{ 0x5360, 0x214627 },
	{ 0x5361, 0x214626 },
	{ 0x5363, 0x222334 },
	{ 0x5364, 0x24234d },
	{ 0x5365, 0x236451 },
	{ 0x5366, 0x214c39 },
	{ 0x5367, 0x232a5c },
	{ 0x5368, 0x243064 },
	{ 0x5369, 0x23212a },
	{ 0x536a, 0x242131 },
	{ 0x536c, 0x222137 },
	{ 0x536d, 0x232228 },
	{ 0x536e, 0x214629 },
	{ 0x536f, 0x214628 },
	{ 0x5370, 0x21474d },
	{ 0x5371, 0x21474e },
	{ 0x5372, 0x222335 },
	{ 0x5373, 0x21493b },
	{ 0x5374, 0x232467 },
	{ 0x5375, 0x21493c },
	{ 0x5376, 0x232765 },
	{ 0x5377, 0x214c3a },
	{ 0x5378, 0x214c3b },
	{ 0x5379, 0x214c3c },
	{ 0x537a, 0x232766 },
	{ 0x537b, 0x215033 },
	{ 0x537c, 0x222937 },
	{ 0x537d, 0x232b4b },
	{ 0x537e, 0x243065 },
	{ 0x537f, 0x21544e },
	{ 0x5380, 0x234047 },
	{ 0x5382, 0x222125 },
	{ 0x5383, 0x242144 },
	{ 0x5384, 0x21452d },
	{ 0x5386, 0x23215b },
	{ 0x5387, 0x242167 },
	{ 0x5388, 0x242166 },
	{ 0x5389, 0x232229 },
	{ 0x538a, 0x222224 },
	{ 0x538b, 0x23232f },
	{ 0x538e, 0x222336 },
	{ 0x538f, 0x222337 },
	{ 0x5392, 0x222559 },
	{ 0x5393, 0x232767 },
	{ 0x5394, 0x22255a },
	{ 0x5396, 0x222939 },
	{ 0x5397, 0x222938 },
	{ 0x5398, 0x22293b },
	{ 0x5399, 0x22293a },
	{ 0x539a, 0x215034 },
	{ 0x539b, 0x236452 },
	{ 0x539c, 0x223373 },
	{ 0x539d, 0x215450 },
	{ 0x539e, 0x222e32 },
	{ 0x539f, 0x21544f },
	{ 0x53a0, 0x233454 },
	{ 0x53a1, 0x243068 },
	{ 0x53a4, 0x223a48 },
	{ 0x53a5, 0x215e3c },
	{ 0x53a6, 0x233a28 },
	{ 0x53a7, 0x223a49 },
	{ 0x53a8, 0x233a27 },
	{ 0x53a9, 0x23404a },
	{ 0x53aa, 0x234049 },
	{ 0x53ab, 0x234048 },
	{ 0x53ac, 0x22492d },
	{ 0x53ad, 0x216825 },
	{ 0x53ae, 0x234625 },
	{ 0x53af, 0x243c40 },
	{ 0x53b0, 0x234626 },
	{ 0x53b1, 0x234b35 },
	{ 0x53b2, 0x216c30 },
	{ 0x53b3, 0x235445 },
	{ 0x53b4, 0x22653b },
	{ 0x53b5, 0x2f6d2e },
	{ 0x53b6, 0x23212b },
	{ 0x53b7, 0x23215c },
	{ 0x53b8, 0x242145 },
	{ 0x53b9, 0x222138 },
	{ 0x53ba, 0x23222a },
	{ 0x53bb, 0x21462a },
	{ 0x53bd, 0x242248 },
	{ 0x53be, 0x232331 },
	{ 0x53c0, 0x242559 },
	{ 0x53c1, 0x232769 },
	{ 0x53c2, 0x23276a },
	{ 0x53c3, 0x215936 },
	{ 0x53c4, 0x233455 },
	{ 0x53c5, 0x233a29 },
	{ 0x53c8, 0x214434 },
	{ 0x53c9, 0x214446 },
	{ 0x53ca, 0x21452f },
	{ 0x53cb, 0x21452e },
	{ 0x53cc, 0x23215e },
	{ 0x53cd, 0x214530 },
	{ 0x53ce, 0x232160 },
	{ 0x53cf, 0x242169 },
	{ 0x53d0, 0x23222b },
	{ 0x53d2, 0x232333 },
	{ 0x53d3, 0x24234f },
	{ 0x53d4, 0x214c3e },
	{ 0x53d5, 0x23276b },
	{ 0x53d6, 0x214c3d },
	{ 0x53d7, 0x214c3f },
	{ 0x53d9, 0x232b50 },
	{ 0x53da, 0x232b4f },
	{ 0x53db, 0x215035 },
	{ 0x53dc, 0x232b4e },
	{ 0x53dd, 0x232b4d },
	{ 0x53de, 0x263578 },
	{ 0x53df, 0x215451 },
	{ 0x53e0, 0x23404b },
	{ 0x53e1, 0x225646 },
	{ 0x53e2, 0x21763b },
	{ 0x53e3, 0x214447 },
	{ 0x53e4, 0x21462c },
	{ 0x53e5, 0x21463b },
	{ 0x53e6, 0x214636 },
	{ 0x53e7, 0x24216c },
	{ 0x53e8, 0x214631 },
	{ 0x53e9, 0x214630 },
	{ 0x53ea, 0x214637 },
	{ 0x53eb, 0x214635 },
	{ 0x53ec, 0x21462e },
	{ 0x53ed, 0x21463c },
	{ 0x53ee, 0x21462f },
	{ 0x53ef, 0x21462b },
	{ 0x53f0, 0x21463a },
	{ 0x53f1, 0x214639 },
	{ 0x53f2, 0x214638 },
	{ 0x53f3, 0x21462d },
	{ 0x53f4, 0x232231 },
	{ 0x53f5, 0x214634 },
	{ 0x53f6, 0x23222d },
	{ 0x53f7, 0x23222e },
	{ 0x53f8, 0x214633 },
	{ 0x53f9, 0x23222f },
	{ 0x53fa, 0x2f2150 },
	{ 0x53fb, 0x21463d },
	{ 0x53fc, 0x214632 },
	{ 0x53fd, 0x24216a },
	{ 0x53ff, 0x232335 },
	{ 0x5400, 0x232337 },
	{ 0x5401, 0x214754 },
	{ 0x5402, 0x24224c },
	{ 0x5403, 0x21475a },
	{ 0x5404, 0x214756 },
	{ 0x5405, 0x232339 },
	{ 0x5406, 0x21475c },
	{ 0x5407, 0x222225 },
	{ 0x5408, 0x214759 },
	{ 0x5409, 0x21474f },
	{ 0x540a, 0x214752 },
	{ 0x540b, 0x214755 },
	{ 0x540c, 0x214751 },
	{ 0x540d, 0x214758 },
	{ 0x540e, 0x21475b },
	{ 0x540f, 0x214750 },
	{ 0x5410, 0x214753 },
	{ 0x5411, 0x214757 },
	{ 0x5412, 0x21475d },
	{ 0x5413, 0x23233a },
	{ 0x5415, 0x23233b },
	{ 0x5416, 0x232334 },
	{ 0x5418, 0x222340 },
	{ 0x5419, 0x22233d },
	{ 0x541a, 0x232476 },
	{ 0x541b, 0x214949 },
	{ 0x541c, 0x22233e },
	{ 0x541d, 0x21493d },
	{ 0x541e, 0x21493f },
	{ 0x541f, 0x214957 },
	{ 0x5420, 0x214952 },
	{ 0x5421, 0x232479 },
	{ 0x5422, 0x23247e },
	{ 0x5423, 0x232475 },
	{ 0x5424, 0x222345 },
	{ 0x5425, 0x22233f },
	{ 0x5426, 0x214941 },
	{ 0x5427, 0x214943 },
	{ 0x5428, 0x222344 },
	{ 0x5429, 0x21494a },
	{ 0x542a, 0x22233a },
	{ 0x542b, 0x214956 },
	{ 0x542c, 0x214958 },
	{ 0x542d, 0x21493e },
	{ 0x542e, 0x21494f },
	{ 0x542f, 0x232524 },
	{ 0x5430, 0x222338 },
	{ 0x5431, 0x214955 },
	{ 0x5432, 0x232477 },
	{ 0x5433, 0x214946 },
	{ 0x5434, 0x23247b },
	{ 0x5435, 0x214950 },
	{ 0x5436, 0x214951 },
	{ 0x5437, 0x222339 },
	{ 0x5438, 0x21494e },
	{ 0x5439, 0x21494c },
	{ 0x543a, 0x232470 },
	{ 0x543b, 0x21494d },
	{ 0x543c, 0x214953 },
	{ 0x543d, 0x222341 },
	{ 0x543e, 0x214940 },
	{ 0x543f, 0x232521 },
	{ 0x5440, 0x214954 },
	{ 0x5441, 0x222343 },
	{ 0x5442, 0x214948 },
	{ 0x5443, 0x214945 },
	{ 0x5444, 0x232473 },
	{ 0x5445, 0x22233c },
	{ 0x5446, 0x214944 },
	{ 0x5447, 0x222346 },
	{ 0x5448, 0x214947 },
	{ 0x5449, 0x23247c },
	{ 0x544a, 0x21494b },
	{ 0x544b, 0x232478 },
	{ 0x544c, 0x232474 },
	{ 0x544d, 0x23246d },
	{ 0x544e, 0x214942 },
	{ 0x544f, 0x222342 },
	{ 0x5450, 0x23247d },
	{ 0x5451, 0x232522 },
	{ 0x5454, 0x22233b },
	{ 0x545a, 0x232523 },
	{ 0x545d, 0x242564 },
	{ 0x545e, 0x242563 },
	{ 0x545f, 0x23276e },
	{ 0x5460, 0x22256b },
	{ 0x5461, 0x22256a },
	{ 0x5462, 0x214c51 },
	{ 0x5463, 0x22256d },
	{ 0x5464, 0x22256f },
	{ 0x5465, 0x222564 },
	{ 0x5466, 0x222567 },
	{ 0x5467, 0x22256e },
	{ 0x5468, 0x214c52 },
	{ 0x5469, 0x232774 },
	{ 0x546a, 0x232778 },
	{ 0x546b, 0x222561 },
	{ 0x546c, 0x222565 },
	{ 0x546d, 0x232775 },
	{ 0x546e, 0x24255f },
	{ 0x546f, 0x222569 },
	{ 0x5470, 0x22294a },
	{ 0x5471, 0x214c4d },
	{ 0x5472, 0x22294e },
	{ 0x5473, 0x214c40 },
	{ 0x5474, 0x222566 },
	{ 0x5475, 0x214c41 },
	{ 0x5476, 0x214c4e },
	{ 0x5477, 0x214c47 },
	{ 0x5478, 0x214c43 },
	{ 0x5479, 0x232771 },
	{ 0x547a, 0x222562 },
	{ 0x547b, 0x214c46 },
	{ 0x547c, 0x214c4b },
	{ 0x547d, 0x214c54 },
	{ 0x547e, 0x222563 },
	{ 0x547f, 0x22255c },
	{ 0x5480, 0x214c45 },
	{ 0x5481, 0x22255d },
	{ 0x5482, 0x22255f },
	{ 0x5483, 0x242560 },
	{ 0x5484, 0x214c48 },
	{ 0x5485, 0x23276c },
	{ 0x5486, 0x214c4a },
	{ 0x5487, 0x22255b },
	{ 0x5488, 0x222560 },
	{ 0x5489, 0x232770 },
	{ 0x548a, 0x232779 },
	{ 0x548b, 0x214c53 },
	{ 0x548c, 0x214c4f },
	{ 0x548d, 0x222568 },
	{ 0x548e, 0x214c55 },
	{ 0x548f, 0x232773 },
	{ 0x5490, 0x214c4c },
	{ 0x5491, 0x22255e },
	{ 0x5492, 0x214c49 },
	{ 0x5493, 0x23276f },
	{ 0x5494, 0x232777 },
	{ 0x5495, 0x214c44 },
	{ 0x5496, 0x214c42 },
	{ 0x5498, 0x22256c },
	{ 0x549a, 0x214c50 },
	{ 0x549c, 0x2f2571 },
	{ 0x549e, 0x232b5c },
	{ 0x549f, 0x232b5d },
	{ 0x54a0, 0x222949 },
	{ 0x54a1, 0x22293d },
	{ 0x54a2, 0x22294c },
	{ 0x54a3, 0x232b57 },
	{ 0x54a4, 0x232b59 },
	{ 0x54a5, 0x22293f },
	{ 0x54a6, 0x21503c },
	{ 0x54a7, 0x21504a },
	{ 0x54a8, 0x215038 },
	{ 0x54a9, 0x215049 },
	{ 0x54aa, 0x215041 },
	{ 0x54ab, 0x215046 },
	{ 0x54ac, 0x215036 },
	{ 0x54ad, 0x22293e },
	{ 0x54ae, 0x222944 },
	{ 0x54af, 0x215045 },
	{ 0x54b0, 0x222950 },
	{ 0x54b1, 0x215047 },
	{ 0x54b2, 0x232b5b },
	{ 0x54b3, 0x21503d },
	{ 0x54b4, 0x232b54 },
	{ 0x54b5, 0x232b5e },
	{ 0x54b6, 0x222946 },
	{ 0x54b7, 0x222943 },
	{ 0x54b8, 0x21503b },
	{ 0x54b9, 0x232b51 },
	{ 0x54ba, 0x22293c },
	{ 0x54bb, 0x215048 },
	{ 0x54bc, 0x22294b },
	{ 0x54bd, 0x215040 },
	{ 0x54be, 0x22294d },
	{ 0x54bf, 0x21504b },
	{ 0x54c0, 0x215037 },
	{ 0x54c1, 0x215042 },
	{ 0x54c2, 0x21503f },
	{ 0x54c3, 0x222941 },
	{ 0x54c4, 0x215043 },
	{ 0x54c5, 0x222947 },
	{ 0x54c6, 0x222948 },
	{ 0x54c7, 0x21503e },
	{ 0x54c8, 0x215044 },
	{ 0x54c9, 0x21503a },
	{ 0x54ca, 0x232b55 },
	{ 0x54cb, 0x236454 },
	{ 0x54cc, 0x232b63 },
	{ 0x54cd, 0x232b61 },
	{ 0x54ce, 0x215039 },
	{ 0x54cf, 0x222940 },
	{ 0x54d0, 0x232b53 },
	{ 0x54d6, 0x222945 },
	{ 0x54da, 0x232b58 },
	{ 0x54de, 0x22294f },
	{ 0x54e0, 0x222e46 },
	{ 0x54e1, 0x21545e },
	{ 0x54e2, 0x222e34 },
	{ 0x54e3, 0x242c2d },
	{ 0x54e4, 0x222e39 },
	{ 0x54e5, 0x215457 },
	{ 0x54e6, 0x215462 },
	{ 0x54e7, 0x222e37 },
	{ 0x54e8, 0x215452 },
	{ 0x54e9, 0x21545c },
	{ 0x54ea, 0x215461 },
	{ 0x54eb, 0x222e3e },
	{ 0x54ec, 0x242c26 },
	{ 0x54ed, 0x21545d },
	{ 0x54ee, 0x215460 },
	{ 0x54ef, 0x232f77 },
	{ 0x54f0, 0x233021 },
	{ 0x54f1, 0x222e41 },
	{ 0x54f2, 0x215458 },
	{ 0x54f3, 0x222e38 },
	{ 0x54f4, 0x232f74 },
	{ 0x54f5, 0x232f78 },
	{ 0x54f6, 0x233022 },
	{ 0x54f7, 0x222e44 },
	{ 0x54f8, 0x222e45 },
	{ 0x54f9, 0x232f79 },
	{ 0x54fa, 0x21545a },
	{ 0x54fb, 0x222e43 },
	{ 0x54fc, 0x215456 },
	{ 0x54fd, 0x215465 },
	{ 0x54fe, 0x242c29 },
	{ 0x54ff, 0x222e3b },
	{ 0x5500, 0x232f7b },
	{ 0x5501, 0x215454 },
	{ 0x5502, 0x232f7a },
	{ 0x5503, 0x222e48 },
	{ 0x5504, 0x222e3c },
	{ 0x5505, 0x222e40 },
	{ 0x5506, 0x215459 },
	{ 0x5507, 0x215464 },
	{ 0x5508, 0x222e3d },
	{ 0x5509, 0x21545f },
	{ 0x550a, 0x222e42 },
	{ 0x550b, 0x222e49 },
	{ 0x550c, 0x223424 },
	{ 0x550d, 0x232f73 },
	{ 0x550e, 0x222e47 },
	{ 0x550f, 0x215466 },
	{ 0x5510, 0x215453 },
	{ 0x5511, 0x222e3f },
	{ 0x5512, 0x222e36 },
	{ 0x5513, 0x232f76 },
	{ 0x5514, 0x21545b },
	{ 0x5515, 0x242c28 },
	{ 0x5516, 0x242c2e },
	{ 0x5517, 0x222e35 },
	{ 0x5518, 0x232f7e },
	{ 0x5519, 0x233025 },
	{ 0x551a, 0x222e3a },
	{ 0x551b, 0x2f2954 },
	{ 0x5520, 0x2f2e42 },
	{ 0x5521, 0x2f2e4a },
	{ 0x5526, 0x222e33 },
	{ 0x5527, 0x215463 },
	{ 0x5528, 0x236721 },
	{ 0x5529, 0x23345f },
	{ 0x552a, 0x22337a },
	{ 0x552b, 0x233468 },
	{ 0x552c, 0x215949 },
	{ 0x552d, 0x22342a },
	{ 0x552e, 0x215947 },
	{ 0x552f, 0x215944 },
	{ 0x5530, 0x223421 },
	{ 0x5531, 0x215940 },
	{ 0x5532, 0x223425 },
	{ 0x5533, 0x21594b },
	{ 0x5534, 0x223379 },
	{ 0x5535, 0x22337e },
	{ 0x5536, 0x22337d },
	{ 0x5537, 0x215455 },
	{ 0x5538, 0x215946 },
	{ 0x5539, 0x223428 },
	{ 0x553a, 0x233466 },
	{ 0x553b, 0x22342b },
	{ 0x553c, 0x223376 },
	{ 0x553d, 0x243077 },
	{ 0x553e, 0x215e4e },
	{ 0x553f, 0x233467 },
	{ 0x5540, 0x22342c },
	{ 0x5541, 0x21594c },
	{ 0x5542, 0x243072 },
	{ 0x5543, 0x21593e },
	{ 0x5544, 0x21593b },
	{ 0x5545, 0x223423 },
	{ 0x5546, 0x215938 },
	{ 0x5547, 0x243074 },
	{ 0x5548, 0x223429 },
	{ 0x5549, 0x23345b },
	{ 0x554a, 0x21593f },
	{ 0x554b, 0x22342d },
	{ 0x554c, 0x233458 },
	{ 0x554d, 0x223377 },
	{ 0x554e, 0x223427 },
	{ 0x554f, 0x215942 },
	{ 0x5550, 0x223378 },
	{ 0x5551, 0x22337b },
	{ 0x5552, 0x223422 },
	{ 0x5553, 0x233462 },
	{ 0x5554, 0x233461 },
	{ 0x5555, 0x215943 },
	{ 0x5556, 0x215941 },
	{ 0x5557, 0x21594d },
	{ 0x5558, 0x233457 },
	{ 0x5559, 0x233a36 },
	{ 0x555a, 0x233464 },
	{ 0x555b, 0x24306b },
	{ 0x555c, 0x215948 },
	{ 0x555d, 0x23345e },
	{ 0x555e, 0x21593c },
	{ 0x555f, 0x215a76 },
	{ 0x5560, 0x24307a },
	{ 0x5561, 0x21593d },
	{ 0x5562, 0x22337c },
	{ 0x5563, 0x21594a },
	{ 0x5564, 0x215945 },
	{ 0x5565, 0x223426 },
	{ 0x5566, 0x21593a },
	{ 0x5568, 0x233459 },
	{ 0x556a, 0x215939 },
	{ 0x556b, 0x236457 },
	{ 0x5571, 0x236456 },
	{ 0x5572, 0x236722 },
	{ 0x5573, 0x236455 },
	{ 0x5575, 0x223374 },
	{ 0x5576, 0x223375 },
	{ 0x5577, 0x223a4e },
	{ 0x557a, 0x233a3c },
	{ 0x557b, 0x215e3d },
	{ 0x557c, 0x215e40 },
	{ 0x557d, 0x223a59 },
	{ 0x557e, 0x215e54 },
	{ 0x557f, 0x223a5c },
	{ 0x5580, 0x215e3e },
	{ 0x5581, 0x223a55 },
	{ 0x5582, 0x215e44 },
	{ 0x5583, 0x215e4a },
	{ 0x5584, 0x216143 },
	{ 0x5585, 0x233a31 },
	{ 0x5586, 0x233a38 },
	{ 0x5587, 0x215e48 },
	{ 0x5588, 0x223a52 },
	{ 0x5589, 0x215e55 },
	{ 0x558a, 0x215e41 },
	{ 0x558b, 0x215e49 },
	{ 0x558c, 0x223a5a },
	{ 0x558d, 0x22417c },
	{ 0x558e, 0x223a5f },
	{ 0x558f, 0x223a53 },
	{ 0x5590, 0x24365c },
	{ 0x5591, 0x223a4a },
	{ 0x5592, 0x223a57 },
	{ 0x5593, 0x223a51 },
	{ 0x5594, 0x215e47 },
	{ 0x5595, 0x223a5d },
	{ 0x5596, 0x233a2e },
	{ 0x5597, 0x233a2a },
	{ 0x5598, 0x215e43 },
	{ 0x5599, 0x215e57 },
	{ 0x559a, 0x215e50 },
	{ 0x559b, 0x233a33 },
	{ 0x559c, 0x215e45 },
	{ 0x559d, 0x215e42 },
	{ 0x559e, 0x233a40 },
	{ 0x559f, 0x215e4d },
	{ 0x55a0, 0x233a34 },
	{ 0x55a1, 0x223a5e },
	{ 0x55a2, 0x223a50 },
	{ 0x55a3, 0x223a56 },
	{ 0x55a4, 0x223a58 },
	{ 0x55a5, 0x223a4c },
	{ 0x55a6, 0x223a5b },
	{ 0x55a7, 0x215e3f },
	{ 0x55a8, 0x223a4b },
	{ 0x55a9, 0x233a42 },
	{ 0x55aa, 0x215e46 },
	{ 0x55ab, 0x215e56 },
	{ 0x55ac, 0x215e52 },
	{ 0x55ad, 0x223a4d },
	{ 0x55ae, 0x215e4c },
	{ 0x55af, 0x233a3b },
	{ 0x55b0, 0x2f3971 },
	{ 0x55b1, 0x215e53 },
	{ 0x55b2, 0x215e4f },
	{ 0x55b3, 0x215e4b },
	{ 0x55b4, 0x233a2f },
	{ 0x55b5, 0x223a54 },
	{ 0x55b6, 0x264729 },
	{ 0x55ba, 0x236723 },
	{ 0x55bb, 0x215e51 },
	{ 0x55bf, 0x22417a },
	{ 0x55c0, 0x224176 },
	{ 0x55c1, 0x234051 },
	{ 0x55c2, 0x224227 },
	{ 0x55c3, 0x22416f },
	{ 0x55c4, 0x224178 },
	{ 0x55c5, 0x21634c },
	{ 0x55c6, 0x21634d },
	{ 0x55c7, 0x216345 },
	{ 0x55c8, 0x224223 },
	{ 0x55c9, 0x21634f },
	{ 0x55ca, 0x224174 },
	{ 0x55cb, 0x224173 },
	{ 0x55cc, 0x224171 },
	{ 0x55cd, 0x224225 },
	{ 0x55ce, 0x216343 },
	{ 0x55cf, 0x22417d },
	{ 0x55d0, 0x224172 },
	{ 0x55d1, 0x216346 },
	{ 0x55d2, 0x22417b },
	{ 0x55d3, 0x216341 },
	{ 0x55d4, 0x224177 },
	{ 0x55d5, 0x22417e },
	{ 0x55d6, 0x224222 },
	{ 0x55d7, 0x23404e },
	{ 0x55d8, 0x243c4b },
	{ 0x55d9, 0x224226 },
	{ 0x55da, 0x21634a },
	{ 0x55db, 0x224170 },
	{ 0x55dc, 0x216344 },
	{ 0x55dd, 0x224175 },
	{ 0x55de, 0x233a2b },
	{ 0x55df, 0x21633f },
	{ 0x55e0, 0x265143 },
	{ 0x55e1, 0x21634b },
	{ 0x55e2, 0x224221 },
	{ 0x55e3, 0x216347 },
	{ 0x55e4, 0x216348 },
	{ 0x55e5, 0x21634e },
	{ 0x55e6, 0x216342 },
	{ 0x55e7, 0x212321 },
	{ 0x55e8, 0x216340 },
	{ 0x55e9, 0x224179 },
	{ 0x55ea, 0x23404c },
	{ 0x55ee, 0x236725 },
	{ 0x55ef, 0x216349 },
	{ 0x55f0, 0x236724 },
	{ 0x55f1, 0x2f4062 },
	{ 0x55f2, 0x224224 },
	{ 0x55f4, 0x236458 },
	{ 0x55f6, 0x216835 },
	{ 0x55f7, 0x216830 },
	{ 0x55f8, 0x23462e },
	{ 0x55f9, 0x22493c },
	{ 0x55fa, 0x224938 },
	{ 0x55fb, 0x234628 },
	{ 0x55fc, 0x224932 },
	{ 0x55fd, 0x21682a },
	{ 0x55fe, 0x216826 },
	{ 0x55ff, 0x22493b },
	{ 0x5600, 0x216827 },
	{ 0x5601, 0x224935 },
	{ 0x5602, 0x224937 },
	{ 0x5603, 0x234629 },
	{ 0x5604, 0x22493a },
	{ 0x5605, 0x234636 },
	{ 0x5606, 0x21682c },
	{ 0x5607, 0x23462c },
	{ 0x5608, 0x216833 },
	{ 0x5609, 0x21682d },
	{ 0x560a, 0x244257 },
	{ 0x560b, 0x23462a },
	{ 0x560c, 0x224930 },
	{ 0x560d, 0x21682e },
	{ 0x560e, 0x21682f },
	{ 0x560f, 0x224933 },
	{ 0x5610, 0x216834 },
	{ 0x5611, 0x234634 },
	{ 0x5612, 0x224931 },
	{ 0x5613, 0x224936 },
	{ 0x5614, 0x21682b },
	{ 0x5615, 0x22492f },
	{ 0x5616, 0x216831 },
	{ 0x5617, 0x216829 },
	{ 0x5618, 0x234633 },
	{ 0x5619, 0x24424b },
	{ 0x561b, 0x216828 },
	{ 0x561c, 0x224934 },
	{ 0x561d, 0x224939 },
	{ 0x561e, 0x234631 },
	{ 0x561f, 0x216832 },
	{ 0x5620, 0x23645a },
	{ 0x5622, 0x236459 },
	{ 0x5626, 0x234650 },
	{ 0x5627, 0x22492e },
	{ 0x5628, 0x234630 },
	{ 0x5629, 0x216c37 },
	{ 0x562a, 0x224f6e },
	{ 0x562b, 0x234b41 },
	{ 0x562c, 0x224f6b },
	{ 0x562d, 0x234b38 },
	{ 0x562e, 0x216c31 },
	{ 0x562f, 0x216c3d },
	{ 0x5630, 0x216c3e },
	{ 0x5631, 0x234b3d },
	{ 0x5632, 0x216c34 },
	{ 0x5633, 0x224f69 },
	{ 0x5634, 0x216c36 },
	{ 0x5635, 0x224f61 },
	{ 0x5636, 0x216c3c },
	{ 0x5637, 0x234b44 },
	{ 0x5638, 0x224f6d },
	{ 0x5639, 0x216c33 },
	{ 0x563a, 0x224f6f },
	{ 0x563b, 0x216c32 },
	{ 0x563c, 0x244931 },
	{ 0x563d, 0x224f6a },
	{ 0x563e, 0x224f6c },
	{ 0x563f, 0x216c35 },
	{ 0x5640, 0x224f68 },
	{ 0x5641, 0x224f62 },
	{ 0x5642, 0x224f5f },
	{ 0x5643, 0x24492e },
	{ 0x5644, 0x234b3e },
	{ 0x5645, 0x223a4f },
	{ 0x5646, 0x224f65 },
	{ 0x5647, 0x234b37 },
	{ 0x5648, 0x224f5e },
	{ 0x5649, 0x224f64 },
	{ 0x564a, 0x224f63 },
	{ 0x564b, 0x234b3b },
	{ 0x564c, 0x224f60 },
	{ 0x564d, 0x234b43 },
	{ 0x564e, 0x216c39 },
	{ 0x564f, 0x234b45 },
	{ 0x5650, 0x234b40 },
	{ 0x5651, 0x234635 },
	{ 0x5652, 0x234b3c },
	{ 0x5653, 0x216c38 },
	{ 0x5654, 0x234b39 },
	{ 0x5655, 0x272163 },
	{ 0x5656, 0x234b3f },
	{ 0x5657, 0x216c3a },
	{ 0x5658, 0x224f66 },
	{ 0x5659, 0x21703b },
	{ 0x565a, 0x224f67 },
	{ 0x565e, 0x22564f },
	{ 0x565f, 0x23503f },
	{ 0x5660, 0x225648 },
	{ 0x5661, 0x235040 },
	{ 0x5662, 0x217047 },
	{ 0x5663, 0x22564c },
	{ 0x5664, 0x21703f },
	{ 0x5665, 0x217043 },
	{ 0x5666, 0x22564b },
	{ 0x5667, 0x23503b },
	{ 0x5668, 0x217042 },
	{ 0x5669, 0x21703e },
	{ 0x566a, 0x217041 },
	{ 0x566b, 0x21703c },
	{ 0x566c, 0x217046 },
	{ 0x566d, 0x22564d },
	{ 0x566e, 0x225649 },
	{ 0x566f, 0x217045 },
	{ 0x5670, 0x225647 },
	{ 0x5671, 0x217044 },
	{ 0x5672, 0x22564e },
	{ 0x5673, 0x22564a },
	{ 0x5674, 0x216c3b },
	{ 0x5675, 0x244f71 },
	{ 0x5676, 0x217048 },
	{ 0x5677, 0x225650 },
	{ 0x5678, 0x217040 },
	{ 0x5679, 0x21703d },
	{ 0x567a, 0x2f535d },
	{ 0x567b, 0x23503d },
	{ 0x567d, 0x235448 },
	{ 0x567e, 0x225c52 },
	{ 0x567f, 0x225c54 },
	{ 0x5680, 0x217346 },
	{ 0x5681, 0x225c55 },
	{ 0x5682, 0x225c53 },
	{ 0x5683, 0x225c51 },
	{ 0x5684, 0x225c50 },
	{ 0x5685, 0x217348 },
	{ 0x5686, 0x225c4f },
	{ 0x5687, 0x217349 },
	{ 0x5688, 0x245574 },
	{ 0x5689, 0x235449 },
	{ 0x568a, 0x235447 },
	{ 0x568b, 0x245578 },
	{ 0x568c, 0x225c4d },
	{ 0x568d, 0x225c4e },
	{ 0x568e, 0x217345 },
	{ 0x568f, 0x21734a },
	{ 0x5690, 0x217347 },
	{ 0x5691, 0x23645d },
	{ 0x5692, 0x23645b },
	{ 0x5693, 0x225c4c },
	{ 0x5694, 0x23575b },
	{ 0x5695, 0x21763c },
	{ 0x5696, 0x23575a },
	{ 0x5697, 0x226148 },
	{ 0x5698, 0x226146 },
	{ 0x5699, 0x22614b },
	{ 0x569a, 0x226149 },
	{ 0x569b, 0x235758 },
	{ 0x569c, 0x226147 },
	{ 0x569d, 0x22614a },
	{ 0x569e, 0x235759 },
	{ 0x569f, 0x235757 },
	{ 0x56a0, 0x23575c },
	{ 0x56a5, 0x21782c },
	{ 0x56a6, 0x22653e },
	{ 0x56a7, 0x22653f },
	{ 0x56a8, 0x21782d },
	{ 0x56a9, 0x245f4d },
	{ 0x56aa, 0x226540 },
	{ 0x56ab, 0x22653c },
	{ 0x56ac, 0x226541 },
	{ 0x56ad, 0x22653d },
	{ 0x56ae, 0x21763d },
	{ 0x56af, 0x235a2d },
	{ 0x56b0, 0x23645e },
	{ 0x56b1, 0x246331 },
	{ 0x56b2, 0x22686b },
	{ 0x56b3, 0x22686d },
	{ 0x56b4, 0x217964 },
	{ 0x56b5, 0x22686c },
	{ 0x56b6, 0x217963 },
	{ 0x56b7, 0x217962 },
	{ 0x56b8, 0x236726 },
	{ 0x56b9, 0x236727 },
	{ 0x56ba, 0x23645c },
	{ 0x56bb, 0x235e26 },
	{ 0x56bc, 0x217965 },
	{ 0x56bd, 0x226b53 },
	{ 0x56be, 0x226b54 },
	{ 0x56bf, 0x246634 },
	{ 0x56c0, 0x217a65 },
	{ 0x56c1, 0x217a64 },
	{ 0x56c2, 0x217a66 },
	{ 0x56c3, 0x226b52 },
	{ 0x56c4, 0x236728 },
	{ 0x56c5, 0x226d46 },
	{ 0x56c6, 0x226d45 },
	{ 0x56c7, 0x235f40 },
	{ 0x56c8, 0x217b59 },
	{ 0x56c9, 0x217b5b },
	{ 0x56ca, 0x217b5a },
	{ 0x56cb, 0x226d47 },
	{ 0x56cc, 0x217c34 },
	{ 0x56cd, 0x227034 },
	{ 0x56cf, 0x246a44 },
	{ 0x56d0, 0x246a43 },
	{ 0x56d1, 0x217c5d },
	{ 0x56d2, 0x236071 },
	{ 0x56d3, 0x227033 },
	{ 0x56d4, 0x22707c },
	{ 0x56d7, 0x22212a },
	{ 0x56d8, 0x232177 },
	{ 0x56d9, 0x24216f },
	{ 0x56da, 0x21463f },
	{ 0x56db, 0x21463e },
	{ 0x56dc, 0x24216d },
	{ 0x56dd, 0x214760 },
	{ 0x56de, 0x21475f },
	{ 0x56df, 0x222227 },
	{ 0x56e0, 0x21475e },
	{ 0x56e1, 0x222226 },
	{ 0x56e3, 0x23233e },
	{ 0x56e4, 0x21495b },
	{ 0x56e5, 0x222349 },
	{ 0x56e6, 0x23252c },
	{ 0x56e7, 0x222348 },
	{ 0x56e8, 0x2f2350 },
	{ 0x56e9, 0x232526 },
	{ 0x56ea, 0x214959 },
	{ 0x56eb, 0x21495c },
	{ 0x56ec, 0x23252b },
	{ 0x56ed, 0x23252a },
	{ 0x56ee, 0x222347 },
	{ 0x56ef, 0x232529 },
	{ 0x56f0, 0x21495a },
	{ 0x56f1, 0x232548 },
	{ 0x56f2, 0x232527 },
	{ 0x56f3, 0x232528 },
	{ 0x56f6, 0x232822 },
	{ 0x56f7, 0x222570 },
	{ 0x56f8, 0x23277d },
	{ 0x56f9, 0x222571 },
	{ 0x56fa, 0x214c56 },
	{ 0x56fb, 0x23277c },
	{ 0x56fc, 0x232821 },
	{ 0x56fd, 0x23277b },
	{ 0x56ff, 0x21504c },
	{ 0x5700, 0x232b65 },
	{ 0x5701, 0x222e4a },
	{ 0x5702, 0x222e4b },
	{ 0x5703, 0x215467 },
	{ 0x5704, 0x215468 },
	{ 0x5705, 0x233027 },
	{ 0x5707, 0x22342f },
	{ 0x5708, 0x21594e },
	{ 0x5709, 0x215950 },
	{ 0x570a, 0x22342e },
	{ 0x570b, 0x21594f },
	{ 0x570c, 0x223a60 },
	{ 0x570d, 0x215e58 },
	{ 0x570e, 0x233a44 },
	{ 0x570f, 0x233a43 },
	{ 0x5710, 0x243668 },
	{ 0x5711, 0x243c52 },
	{ 0x5712, 0x216350 },
	{ 0x5713, 0x216351 },
	{ 0x5714, 0x224228 },
	{ 0x5715, 0x234052 },
	{ 0x5716, 0x216837 },
	{ 0x5717, 0x234637 },
	{ 0x5718, 0x216836 },
	{ 0x571a, 0x224f70 },
	{ 0x571b, 0x225652 },
	{ 0x571c, 0x225651 },
	{ 0x571d, 0x235f41 },
	{ 0x571e, 0x22715a },
	{ 0x571f, 0x214448 },
	{ 0x5720, 0x222139 },
	{ 0x5721, 0x232161 },
	{ 0x5722, 0x22214f },
	{ 0x5723, 0x222150 },
	{ 0x5724, 0x232234 },
	{ 0x5725, 0x242170 },
	{ 0x5727, 0x242171 },
	{ 0x5728, 0x214763 },
	{ 0x5729, 0x214767 },
	{ 0x572a, 0x222229 },
	{ 0x572b, 0x242251 },
	{ 0x572c, 0x214765 },
	{ 0x572d, 0x214764 },
	{ 0x572e, 0x222228 },
	{ 0x572f, 0x214766 },
	{ 0x5730, 0x214762 },
	{ 0x5731, 0x232341 },
	{ 0x5732, 0x232342 },
	{ 0x5733, 0x214761 },
	{ 0x5734, 0x22222a },
	{ 0x5735, 0x23233f },
	{ 0x5736, 0x232340 },
	{ 0x573b, 0x214966 },
	{ 0x573c, 0x232531 },
	{ 0x573d, 0x23253e },
	{ 0x573e, 0x214963 },
	{ 0x573f, 0x232530 },
	{ 0x5740, 0x21495f },
	{ 0x5741, 0x22234a },
	{ 0x5742, 0x232540 },
	{ 0x5743, 0x232536 },
	{ 0x5744, 0x23252f },
	{ 0x5745, 0x22234b },
	{ 0x5746, 0x23253c },
	{ 0x5747, 0x214961 },
	{ 0x5748, 0x23252d },
	{ 0x5749, 0x22234d },
	{ 0x574a, 0x21495d },
	{ 0x574b, 0x22234e },
	{ 0x574c, 0x22234c },
	{ 0x574d, 0x214960 },
	{ 0x574e, 0x214962 },
	{ 0x574f, 0x214965 },
	{ 0x5750, 0x214964 },
	{ 0x5751, 0x21495e },
	{ 0x5752, 0x22234f },
	{ 0x5753, 0x232532 },
	{ 0x5754, 0x232541 },
	{ 0x5755, 0x232542 },
	{ 0x5756, 0x232533 },
	{ 0x5757, 0x232538 },
	{ 0x5758, 0x232537 },
	{ 0x5759, 0x23645f },
	{ 0x575b, 0x2f2352 },
	{ 0x575f, 0x232535 },
	{ 0x5761, 0x214c5b },
	{ 0x5762, 0x22257e },
	{ 0x5763, 0x232825 },
	{ 0x5764, 0x214c5d },
	{ 0x5765, 0x232823 },
	{ 0x5766, 0x214c5c },
	{ 0x5767, 0x232826 },
	{ 0x5768, 0x222621 },
	{ 0x5769, 0x214c5a },
	{ 0x576a, 0x214c59 },
	{ 0x576b, 0x222575 },
	{ 0x576c, 0x242569 },
	{ 0x576d, 0x222574 },
	{ 0x576e, 0x232828 },
	{ 0x576f, 0x222572 },
	{ 0x5770, 0x222577 },
	{ 0x5771, 0x222576 },
	{ 0x5772, 0x222573 },
	{ 0x5773, 0x22257c },
	{ 0x5774, 0x22257d },
	{ 0x5775, 0x22257a },
	{ 0x5776, 0x222578 },
	{ 0x5777, 0x214c58 },
	{ 0x5778, 0x232829 },
	{ 0x5779, 0x242566 },
	{ 0x577a, 0x242568 },
	{ 0x577b, 0x22257b },
	{ 0x577c, 0x214c5e },
	{ 0x577d, 0x222622 },
	{ 0x577e, 0x242565 },
	{ 0x577f, 0x23282a },
	{ 0x5780, 0x222579 },
	{ 0x5781, 0x232824 },
	{ 0x5782, 0x21504d },
	{ 0x5783, 0x214c57 },
	{ 0x5787, 0x24256e },
	{ 0x5788, 0x2f2633 },
	{ 0x578a, 0x236460 },
	{ 0x578b, 0x21504e },
	{ 0x578c, 0x222955 },
	{ 0x578d, 0x232b69 },
	{ 0x578e, 0x232b68 },
	{ 0x578f, 0x22295b },
	{ 0x5790, 0x232b6c },
	{ 0x5791, 0x232b67 },
	{ 0x5792, 0x232b6a },
	{ 0x5793, 0x215054 },
	{ 0x5794, 0x222959 },
	{ 0x5795, 0x22295f },
	{ 0x5796, 0x232b71 },
	{ 0x5797, 0x222956 },
	{ 0x5798, 0x22295a },
	{ 0x5799, 0x22295c },
	{ 0x579a, 0x22295e },
	{ 0x579b, 0x222958 },
	{ 0x579c, 0x232b70 },
	{ 0x579d, 0x222957 },
	{ 0x579e, 0x222952 },
	{ 0x579f, 0x222953 },
	{ 0x57a0, 0x21504f },
	{ 0x57a1, 0x232b6b },
	{ 0x57a2, 0x215051 },
	{ 0x57a3, 0x215050 },
	{ 0x57a4, 0x222954 },
	{ 0x57a5, 0x22295d },
	{ 0x57a6, 0x232b6d },
	{ 0x57a7, 0x232b72 },
	{ 0x57a8, 0x232b6e },
	{ 0x57a9, 0x242860 },
	{ 0x57aa, 0x2f296a },
	{ 0x57ab, 0x2f2971 },
	{ 0x57ac, 0x232b66 },
	{ 0x57ae, 0x215053 },
	{ 0x57b4, 0x24285e },
	{ 0x57b5, 0x222951 },
	{ 0x57b6, 0x222e55 },
	{ 0x57b7, 0x23302a },
	{ 0x57b8, 0x222e54 },
	{ 0x57b9, 0x222e59 },
	{ 0x57ba, 0x222e50 },
	{ 0x57bb, 0x233030 },
	{ 0x57bc, 0x222e53 },
	{ 0x57bd, 0x222e52 },
	{ 0x57be, 0x23302f },
	{ 0x57bf, 0x222e56 },
	{ 0x57c0, 0x233038 },
	{ 0x57c1, 0x222e5a },
	{ 0x57c2, 0x215469 },
	{ 0x57c3, 0x21546c },
	{ 0x57c4, 0x233034 },
	{ 0x57c5, 0x233035 },
	{ 0x57c6, 0x222e51 },
	{ 0x57c7, 0x222e57 },
	{ 0x57c8, 0x233033 },
	{ 0x57c9, 0x233028 },
	{ 0x57ca, 0x233037 },
	{ 0x57cb, 0x21546b },
	{ 0x57cc, 0x222e4c },
	{ 0x57cd, 0x23302b },
	{ 0x57ce, 0x215052 },
	{ 0x57cf, 0x22343d },
	{ 0x57d0, 0x222e58 },
	{ 0x57d1, 0x233036 },
	{ 0x57d2, 0x222e4f },
	{ 0x57d3, 0x242c33 },
	{ 0x57d4, 0x21546a },
	{ 0x57d5, 0x222e4e },
	{ 0x57d7, 0x2f2e5c },
	{ 0x57db, 0x233032 },
	{ 0x57dc, 0x223434 },
	{ 0x57dd, 0x23346e },
	{ 0x57de, 0x233471 },
	{ 0x57df, 0x215951 },
	{ 0x57e0, 0x215955 },
	{ 0x57e1, 0x223444 },
	{ 0x57e2, 0x223432 },
	{ 0x57e3, 0x223440 },
	{ 0x57e4, 0x215956 },
	{ 0x57e5, 0x223442 },
	{ 0x57e6, 0x233472 },
	{ 0x57e7, 0x223448 },
	{ 0x57e8, 0x233474 },
	{ 0x57e9, 0x22344c },
	{ 0x57ea, 0x233469 },
	{ 0x57eb, 0x24307b },
	{ 0x57ec, 0x223443 },
	{ 0x57ed, 0x223437 },
	{ 0x57ee, 0x22343f },
	{ 0x57ef, 0x23346b },
	{ 0x57f0, 0x22344d },
	{ 0x57f1, 0x22344b },
	{ 0x57f2, 0x223441 },
	{ 0x57f3, 0x22343c },
	{ 0x57f4, 0x223435 },
	{ 0x57f5, 0x223a68 },
	{ 0x57f6, 0x223433 },
	{ 0x57f7, 0x21595a },
	{ 0x57f8, 0x22343a },
	{ 0x57f9, 0x21595b },
	{ 0x57fa, 0x215957 },
	{ 0x57fb, 0x223430 },
	{ 0x57fc, 0x223446 },
	{ 0x57fd, 0x223438 },
	{ 0x57fe, 0x23346f },
	{ 0x57ff, 0x233475 },
	{ 0x5800, 0x223436 },
	{ 0x5801, 0x223449 },
	{ 0x5802, 0x215958 },
	{ 0x5803, 0x233476 },
	{ 0x5804, 0x22344f },
	{ 0x5805, 0x215952 },
	{ 0x5806, 0x215954 },
	{ 0x5807, 0x22343e },
	{ 0x5808, 0x223439 },
	{ 0x5809, 0x21546d },
	{ 0x580a, 0x215953 },
	{ 0x580b, 0x22343b },
	{ 0x580c, 0x22344a },
	{ 0x580d, 0x22344e },
	{ 0x580e, 0x223445 },
	{ 0x580f, 0x236461 },
	{ 0x5810, 0x223447 },
	{ 0x5812, 0x236462 },
	{ 0x5813, 0x236463 },
	{ 0x5814, 0x223431 },
	{ 0x5817, 0x243669 },
	{ 0x5818, 0x233a4a },
	{ 0x5819, 0x223a63 },
	{ 0x581a, 0x233a45 },
	{ 0x581b, 0x223a6c },
	{ 0x581c, 0x223a6b },
	{ 0x581d, 0x215e60 },
	{ 0x581e, 0x223a64 },
	{ 0x581f, 0x233a47 },
	{ 0x5820, 0x215e61 },
	{ 0x5821, 0x215e5f },
	{ 0x5822, 0x233a50 },
	{ 0x5823, 0x223a66 },
	{ 0x5824, 0x215e5c },
	{ 0x5825, 0x223a6a },
	{ 0x5826, 0x233a4c },
	{ 0x5827, 0x223a65 },
	{ 0x5828, 0x223a67 },
	{ 0x5829, 0x223a61 },
	{ 0x582a, 0x215e5a },
	{ 0x582b, 0x24366f },
	{ 0x582c, 0x223a74 },
	{ 0x582d, 0x223a73 },
	{ 0x582e, 0x223a70 },
	{ 0x582f, 0x215e59 },
	{ 0x5830, 0x215e5d },
	{ 0x5831, 0x215e5e },
	{ 0x5832, 0x222e4d },
	{ 0x5833, 0x223a6d },
	{ 0x5834, 0x215e5b },
	{ 0x5835, 0x215959 },
	{ 0x5836, 0x223a6f },
	{ 0x5837, 0x223a62 },
	{ 0x5838, 0x223a72 },
	{ 0x5839, 0x223a71 },
	{ 0x583a, 0x233a4e },
	{ 0x583b, 0x223a75 },
	{ 0x583c, 0x233a49 },
	{ 0x583d, 0x224236 },
	{ 0x583e, 0x233a4b },
	{ 0x583f, 0x223a6e },
	{ 0x5840, 0x2f397d },
	{ 0x5842, 0x2f397e },
	{ 0x5843, 0x243c57 },
	{ 0x5844, 0x24366d },
	{ 0x5845, 0x243671 },
	{ 0x5847, 0x236464 },
	{ 0x5848, 0x223a69 },
	{ 0x5849, 0x22422e },
	{ 0x584a, 0x21635b },
	{ 0x584b, 0x21635e },
	{ 0x584c, 0x216359 },
	{ 0x584d, 0x22422d },
	{ 0x584e, 0x224231 },
	{ 0x584f, 0x22422c },
	{ 0x5850, 0x234057 },
	{ 0x5851, 0x216353 },
	{ 0x5852, 0x21635d },
	{ 0x5853, 0x224229 },
	{ 0x5854, 0x216357 },
	{ 0x5855, 0x224230 },
	{ 0x5856, 0x23405b },
	{ 0x5857, 0x216355 },
	{ 0x5858, 0x216354 },
	{ 0x5859, 0x224233 },
	{ 0x585a, 0x216356 },
	{ 0x585b, 0x224235 },
	{ 0x585c, 0x234056 },
	{ 0x585d, 0x224232 },
	{ 0x585e, 0x216352 },
	{ 0x585f, 0x23405e },
	{ 0x5860, 0x23405c },
	{ 0x5861, 0x234058 },
	{ 0x5862, 0x21635c },
	{ 0x5863, 0x224237 },
	{ 0x5864, 0x22422b },
	{ 0x5865, 0x224234 },
	{ 0x5866, 0x23405d },
	{ 0x5867, 0x243c53 },
	{ 0x5868, 0x22422a },
	{ 0x5869, 0x23405a },
	{ 0x586a, 0x234059 },
	{ 0x586b, 0x216358 },
	{ 0x586c, 0x234054 },
	{ 0x586d, 0x21635a },
	{ 0x586f, 0x22422f },
	{ 0x5871, 0x224238 },
	{ 0x5872, 0x234643 },
	{ 0x5873, 0x23463e },
	{ 0x5874, 0x224944 },
	{ 0x5875, 0x216838 },
	{ 0x5876, 0x22494a },
	{ 0x5877, 0x234642 },
	{ 0x5878, 0x23463c },
	{ 0x5879, 0x21683d },
	{ 0x587a, 0x224946 },
	{ 0x587b, 0x22494d },
	{ 0x587c, 0x22493e },
	{ 0x587d, 0x21683f },
	{ 0x587e, 0x216839 },
	{ 0x587f, 0x224943 },
	{ 0x5880, 0x216c3f },
	{ 0x5881, 0x224942 },
	{ 0x5882, 0x22494b },
	{ 0x5883, 0x21683a },
	{ 0x5884, 0x23463d },
	{ 0x5885, 0x21683e },
	{ 0x5886, 0x224941 },
	{ 0x5887, 0x224947 },
	{ 0x5888, 0x22494c },
	{ 0x5889, 0x22493d },
	{ 0x588a, 0x21683c },
	{ 0x588b, 0x224945 },
	{ 0x588c, 0x23463a },
	{ 0x588d, 0x234645 },
	{ 0x588e, 0x224949 },
	{ 0x588f, 0x22494f },
	{ 0x5890, 0x22493f },
	{ 0x5891, 0x224948 },
	{ 0x5892, 0x234638 },
	{ 0x5893, 0x21683b },
	{ 0x5894, 0x22494e },
	{ 0x5895, 0x234641 },
	{ 0x5896, 0x234644 },
	{ 0x5897, 0x234640 },
	{ 0x5898, 0x224940 },
	{ 0x589a, 0x244259 },
	{ 0x589b, 0x236465 },
	{ 0x589c, 0x216c43 },
	{ 0x589d, 0x224f72 },
	{ 0x589e, 0x216c41 },
	{ 0x589f, 0x216c40 },
	{ 0x58a0, 0x224f74 },
	{ 0x58a1, 0x224f79 },
	{ 0x58a2, 0x234b46 },
	{ 0x58a3, 0x224f75 },
	{ 0x58a4, 0x234b50 },
	{ 0x58a5, 0x224f78 },
	{ 0x58a6, 0x216c46 },
	{ 0x58a7, 0x234b51 },
	{ 0x58a8, 0x21702e },
	{ 0x58a9, 0x216c45 },
	{ 0x58aa, 0x234b4b },
	{ 0x58ab, 0x224f71 },
	{ 0x58ac, 0x224f77 },
	{ 0x58ad, 0x23463f },
	{ 0x58ae, 0x216c44 },
	{ 0x58af, 0x224f76 },
	{ 0x58b0, 0x234b4d },
	{ 0x58b1, 0x224f73 },
	{ 0x58b2, 0x234b49 },
	{ 0x58b3, 0x216c42 },
	{ 0x58b4, 0x234b4f },
	{ 0x58b5, 0x234b4c },
	{ 0x58b7, 0x234b47 },
	{ 0x58ba, 0x225657 },
	{ 0x58bb, 0x23504a },
	{ 0x58bc, 0x225659 },
	{ 0x58bd, 0x225654 },
	{ 0x58be, 0x21704a },
	{ 0x58bf, 0x225656 },
	{ 0x58c0, 0x23504b },
	{ 0x58c1, 0x217049 },
	{ 0x58c2, 0x225658 },
	{ 0x58c3, 0x235048 },
	{ 0x58c4, 0x23504c },
	{ 0x58c5, 0x21704c },
	{ 0x58c6, 0x22565a },
	{ 0x58c7, 0x21704b },
	{ 0x58c8, 0x225653 },
	{ 0x58c9, 0x225655 },
	{ 0x58ca, 0x235049 },
	{ 0x58cd, 0x23544b },
	{ 0x58ce, 0x21734e },
	{ 0x58cf, 0x225c58 },
	{ 0x58d0, 0x23544c },
	{ 0x58d1, 0x21734d },
	{ 0x58d2, 0x225c59 },
	{ 0x58d3, 0x21734c },
	{ 0x58d4, 0x225c57 },
	{ 0x58d5, 0x21734b },
	{ 0x58d6, 0x225c56 },
	{ 0x58d8, 0x21763f },
	{ 0x58d9, 0x21763e },
	{ 0x58da, 0x226542 },
	{ 0x58db, 0x226544 },
	{ 0x58dc, 0x235a2f },
	{ 0x58dd, 0x226543 },
	{ 0x58de, 0x21782e },
	{ 0x58df, 0x21782f },
	{ 0x58e0, 0x235a2e },
	{ 0x58e1, 0x274645 },
	{ 0x58e2, 0x217830 },
	{ 0x58e3, 0x22686e },
	{ 0x58e4, 0x217966 },
	{ 0x58e6, 0x235e28 },
	{ 0x58e7, 0x226f22 },
	{ 0x58e8, 0x226f21 },
	{ 0x58e9, 0x217c5e },
	{ 0x58eb, 0x214449 },
	{ 0x58ec, 0x214531 },
	{ 0x58ee, 0x232343 },
	{ 0x58ef, 0x214967 },
	{ 0x58f0, 0x232545 },
	{ 0x58f1, 0x232543 },
	{ 0x58f2, 0x232544 },
	{ 0x58f3, 0x23282d },
	{ 0x58f4, 0x222960 },
	{ 0x58f5, 0x232b77 },
	{ 0x58f7, 0x233477 },
	{ 0x58f9, 0x215e62 },
	{ 0x58fa, 0x215e63 },
	{ 0x58fb, 0x233a52 },
	{ 0x58fc, 0x224239 },
	{ 0x58fd, 0x216840 },
	{ 0x58fe, 0x224950 },
	{ 0x58ff, 0x224f7a },
	{ 0x5900, 0x236466 },
	{ 0x5901, 0x23504d },
	{ 0x5902, 0x232139 },
	{ 0x5903, 0x22213a },
	{ 0x5904, 0x232235 },
	{ 0x5905, 0x232344 },
	{ 0x5906, 0x222350 },
	{ 0x5908, 0x232b7a },
	{ 0x5909, 0x232b79 },
	{ 0x590a, 0x23213a },
	{ 0x590b, 0x232546 },
	{ 0x590c, 0x222623 },
	{ 0x590d, 0x222961 },
	{ 0x590e, 0x222e5b },
	{ 0x590f, 0x21546e },
	{ 0x5910, 0x234646 },
	{ 0x5911, 0x236560 },
	{ 0x5912, 0x226545 },
	{ 0x5913, 0x245f52 },
	{ 0x5914, 0x217a67 },
	{ 0x5915, 0x21444a },
	{ 0x5916, 0x214640 },
	{ 0x5917, 0x222151 },
	{ 0x5918, 0x232236 },
	{ 0x5919, 0x214768 },
	{ 0x591a, 0x214769 },
	{ 0x591b, 0x242252 },
	{ 0x591c, 0x214c5f },
	{ 0x591d, 0x242570 },
	{ 0x591f, 0x233479 },
	{ 0x5920, 0x21595c },
	{ 0x5921, 0x25373d },
	{ 0x5922, 0x216842 },
	{ 0x5923, 0x23405f },
	{ 0x5924, 0x216843 },
	{ 0x5925, 0x216841 },
	{ 0x5926, 0x234b53 },
	{ 0x5927, 0x21444b },
	{ 0x5928, 0x242149 },
	{ 0x5929, 0x214532 },
	{ 0x592a, 0x214534 },
	{ 0x592b, 0x214533 },
	{ 0x592c, 0x22213b },
	{ 0x592d, 0x214535 },
	{ 0x592e, 0x214641 },
	{ 0x592f, 0x222152 },
	{ 0x5930, 0x232238 },
	{ 0x5931, 0x214642 },
	{ 0x5932, 0x232237 },
	{ 0x5933, 0x242172 },
	{ 0x5934, 0x232239 },
	{ 0x5935, 0x242253 },
	{ 0x5936, 0x232347 },
	{ 0x5937, 0x21476a },
	{ 0x5938, 0x21476b },
	{ 0x593c, 0x22222b },
	{ 0x593d, 0x232549 },
	{ 0x593e, 0x214968 },
	{ 0x593f, 0x242362 },
	{ 0x5940, 0x222351 },
	{ 0x5943, 0x242575 },
	{ 0x5944, 0x214c63 },
	{ 0x5945, 0x222624 },
	{ 0x5946, 0x242572 },
	{ 0x5947, 0x214c61 },
	{ 0x5948, 0x214c62 },
	{ 0x5949, 0x214c60 },
	{ 0x594a, 0x222e5c },
	{ 0x594b, 0x23282e },
	{ 0x594c, 0x23282f },
	{ 0x594d, 0x236467 },
	{ 0x594e, 0x215058 },
	{ 0x594f, 0x215057 },
	{ 0x5950, 0x215059 },
	{ 0x5951, 0x215056 },
	{ 0x5952, 0x232b7c },
	{ 0x5953, 0x222962 },
	{ 0x5954, 0x214c64 },
	{ 0x5955, 0x215055 },
	{ 0x5957, 0x21546f },
	{ 0x5958, 0x215470 },
	{ 0x5959, 0x242c38 },
	{ 0x595a, 0x215471 },
	{ 0x595b, 0x23347b },
	{ 0x595c, 0x223450 },
	{ 0x595d, 0x23347c },
	{ 0x595e, 0x23347d },
	{ 0x595f, 0x243126 },
	{ 0x5960, 0x215e64 },
	{ 0x5961, 0x223a76 },
	{ 0x5962, 0x21595d },
	{ 0x5963, 0x233a53 },
	{ 0x5964, 0x233a54 },
	{ 0x5965, 0x243679 },
	{ 0x5966, 0x234060 },
	{ 0x5967, 0x21635f },
	{ 0x5968, 0x234061 },
	{ 0x5969, 0x216845 },
	{ 0x596a, 0x216844 },
	{ 0x596b, 0x224951 },
	{ 0x596c, 0x234648 },
	{ 0x596d, 0x216c47 },
	{ 0x596e, 0x21704d },
	{ 0x596f, 0x244f7b },
	{ 0x5970, 0x22614c },
	{ 0x5971, 0x226d48 },
	{ 0x5972, 0x226f23 },
	{ 0x5973, 0x21444c },
	{ 0x5974, 0x214643 },
	{ 0x5975, 0x23223b },
	{ 0x5976, 0x214644 },
	{ 0x5977, 0x222231 },
	{ 0x5978, 0x21476d },
	{ 0x5979, 0x214770 },
	{ 0x597a, 0x23234b },
	{ 0x597b, 0x22222f },
	{ 0x597c, 0x22222d },
	{ 0x597d, 0x21476f },
	{ 0x597e, 0x222230 },
	{ 0x597f, 0x222232 },
	{ 0x5980, 0x22222c },
	{ 0x5981, 0x214772 },
	{ 0x5982, 0x214771 },
	{ 0x5983, 0x21476e },
	{ 0x5984, 0x21476c },
	{ 0x5985, 0x22222e },
	{ 0x5986, 0x23234d },
	{ 0x5989, 0x232555 },
	{ 0x598a, 0x214973 },
	{ 0x598b, 0x242367 },
	{ 0x598c, 0x23254c },
	{ 0x598d, 0x214970 },
	{ 0x598e, 0x222356 },
	{ 0x598f, 0x222359 },
	{ 0x5990, 0x222358 },
	{ 0x5991, 0x242369 },
	{ 0x5992, 0x21496a },
	{ 0x5993, 0x214972 },
	{ 0x5994, 0x23254b },
	{ 0x5995, 0x24236a },
	{ 0x5996, 0x21496f },
	{ 0x5997, 0x222355 },
	{ 0x5998, 0x222353 },
	{ 0x5999, 0x21496e },
	{ 0x599a, 0x232556 },
	{ 0x599b, 0x232553 },
	{ 0x599c, 0x23254e },
	{ 0x599d, 0x214969 },
	{ 0x599e, 0x21496c },
	{ 0x599f, 0x232551 },
	{ 0x59a0, 0x222354 },
	{ 0x59a1, 0x22235b },
	{ 0x59a2, 0x222357 },
	{ 0x59a3, 0x21496d },
	{ 0x59a4, 0x214971 },
	{ 0x59a5, 0x214974 },
	{ 0x59a6, 0x222352 },
	{ 0x59a7, 0x22235a },
	{ 0x59a8, 0x21496b },
	{ 0x59ac, 0x232841 },
	{ 0x59ad, 0x232833 },
	{ 0x59ae, 0x214c69 },
	{ 0x59af, 0x214c71 },
	{ 0x59b0, 0x232838 },
	{ 0x59b1, 0x222630 },
	{ 0x59b2, 0x222629 },
	{ 0x59b3, 0x214c72 },
	{ 0x59b4, 0x222634 },
	{ 0x59b5, 0x222625 },
	{ 0x59b6, 0x22262c },
	{ 0x59b7, 0x232845 },
	{ 0x59b8, 0x232840 },
	{ 0x59b9, 0x214c68 },
	{ 0x59ba, 0x222626 },
	{ 0x59bb, 0x214c66 },
	{ 0x59bc, 0x22262d },
	{ 0x59bd, 0x222631 },
	{ 0x59be, 0x214c65 },
	{ 0x59bf, 0x23283d },
	{ 0x59c0, 0x222632 },
	{ 0x59c1, 0x22262b },
	{ 0x59c2, 0x232837 },
	{ 0x59c3, 0x22262e },
	{ 0x59c4, 0x232835 },
	{ 0x59c5, 0x214c74 },
	{ 0x59c6, 0x214c6b },
	{ 0x59c7, 0x222635 },
	{ 0x59c8, 0x222633 },
	{ 0x59c9, 0x23283f },
	{ 0x59ca, 0x214c70 },
	{ 0x59cb, 0x214c6e },
	{ 0x59cc, 0x22262a },
	{ 0x59cd, 0x214c6d },
	{ 0x59ce, 0x222628 },
	{ 0x59cf, 0x222627 },
	{ 0x59d0, 0x214c6c },
	{ 0x59d1, 0x214c6a },
	{ 0x59d2, 0x214c73 },
	{ 0x59d3, 0x214c6f },
	{ 0x59d4, 0x214c67 },
	{ 0x59d5, 0x232c26 },
	{ 0x59d6, 0x22262f },
	{ 0x59d7, 0x232846 },
	{ 0x59d8, 0x21505b },
	{ 0x59d9, 0x232c2d },
	{ 0x59da, 0x215062 },
	{ 0x59db, 0x222970 },
	{ 0x59dc, 0x21505a },
	{ 0x59dd, 0x222968 },
	{ 0x59de, 0x222964 },
	{ 0x59df, 0x232c21 },
	{ 0x59e0, 0x222974 },
	{ 0x59e1, 0x222963 },
	{ 0x59e2, 0x232c2c },
	{ 0x59e3, 0x21505d },
	{ 0x59e4, 0x22296d },
	{ 0x59e5, 0x215060 },
	{ 0x59e6, 0x215063 },
	{ 0x59e7, 0x232c2e },
	{ 0x59e8, 0x21505e },
	{ 0x59e9, 0x222971 },
	{ 0x59ea, 0x215061 },
	{ 0x59eb, 0x232c23 },
	{ 0x59ec, 0x215478 },
	{ 0x59ed, 0x222977 },
	{ 0x59ee, 0x222965 },
	{ 0x59ef, 0x232c24 },
	{ 0x59f0, 0x232c25 },
	{ 0x59f1, 0x222967 },
	{ 0x59f2, 0x22296e },
	{ 0x59f3, 0x222972 },
	{ 0x59f4, 0x222976 },
	{ 0x59f5, 0x222973 },
	{ 0x59f6, 0x22296c },
	{ 0x59f7, 0x22296f },
	{ 0x59f8, 0x232c2b },
	{ 0x59f9, 0x232c29 },
	{ 0x59fa, 0x222969 },
	{ 0x59fb, 0x215065 },
	{ 0x59fc, 0x22296b },
	{ 0x59fd, 0x22296a },
	{ 0x59fe, 0x222975 },
	{ 0x59ff, 0x21505c },
	{ 0x5a00, 0x222966 },
	{ 0x5a01, 0x215064 },
	{ 0x5a02, 0x232c2a },
	{ 0x5a03, 0x21505f },
	{ 0x5a04, 0x232c28 },
	{ 0x5a09, 0x21547e },
	{ 0x5a0a, 0x222e64 },
	{ 0x5a0b, 0x233040 },
	{ 0x5a0c, 0x21547d },
	{ 0x5a0d, 0x232c27 },
	{ 0x5a0e, 0x242c40 },
	{ 0x5a0f, 0x222e62 },
	{ 0x5a10, 0x242c3e },
	{ 0x5a11, 0x215472 },
	{ 0x5a12, 0x23304f },
	{ 0x5a13, 0x215477 },
	{ 0x5a14, 0x23304a },
	{ 0x5a15, 0x222e61 },
	{ 0x5a16, 0x222e5e },
	{ 0x5a17, 0x222e63 },
	{ 0x5a18, 0x215473 },
	{ 0x5a19, 0x222e5d },
	{ 0x5a1a, 0x23304e },
	{ 0x5a1b, 0x215476 },
	{ 0x5a1c, 0x215474 },
	{ 0x5a1d, 0x23303e },
	{ 0x5a1e, 0x222e65 },
	{ 0x5a1f, 0x215475 },
	{ 0x5a20, 0x215479 },
	{ 0x5a21, 0x23303b },
	{ 0x5a22, 0x233045 },
	{ 0x5a23, 0x21547a },
	{ 0x5a24, 0x233048 },
	{ 0x5a25, 0x21547c },
	{ 0x5a26, 0x233052 },
	{ 0x5a27, 0x242c39 },
	{ 0x5a28, 0x242c3d },
	{ 0x5a29, 0x21547b },
	{ 0x5a2a, 0x23303c },
	{ 0x5a2b, 0x233522 },
	{ 0x5a2c, 0x233538 },
	{ 0x5a2d, 0x222e5f },
	{ 0x5a2e, 0x222e60 },
	{ 0x5a2f, 0x23304d },
	{ 0x5a30, 0x263657 },
	{ 0x5a31, 0x23304b },
	{ 0x5a33, 0x222e66 },
	{ 0x5a35, 0x223457 },
	{ 0x5a36, 0x21595e },
	{ 0x5a37, 0x223b26 },
	{ 0x5a38, 0x223456 },
	{ 0x5a39, 0x223469 },
	{ 0x5a3a, 0x233528 },
	{ 0x5a3b, 0x233524 },
	{ 0x5a3c, 0x215964 },
	{ 0x5a3d, 0x233531 },
	{ 0x5a3e, 0x223467 },
	{ 0x5a3f, 0x233533 },
	{ 0x5a40, 0x215963 },
	{ 0x5a41, 0x21595f },
	{ 0x5a42, 0x223470 },
	{ 0x5a43, 0x223460 },
	{ 0x5a44, 0x223463 },
	{ 0x5a45, 0x23352e },
	{ 0x5a46, 0x215967 },
	{ 0x5a47, 0x22346d },
	{ 0x5a48, 0x223465 },
	{ 0x5a49, 0x215960 },
	{ 0x5a4a, 0x215968 },
	{ 0x5a4b, 0x23352a },
	{ 0x5a4c, 0x22346a },
	{ 0x5a4d, 0x223468 },
	{ 0x5a4e, 0x23352f },
	{ 0x5a4f, 0x23353b },
	{ 0x5a50, 0x223459 },
	{ 0x5a51, 0x22346e },
	{ 0x5a52, 0x223462 },
	{ 0x5a53, 0x22345d },
	{ 0x5a54, 0x23353a },
	{ 0x5a55, 0x223453 },
	{ 0x5a56, 0x22346f },
	{ 0x5a57, 0x22345f },
	{ 0x5a58, 0x223452 },
	{ 0x5a59, 0x233539 },
	{ 0x5a5a, 0x215966 },
	{ 0x5a5b, 0x223464 },
	{ 0x5a5c, 0x223471 },
	{ 0x5a5d, 0x223461 },
	{ 0x5a5e, 0x223455 },
	{ 0x5a5f, 0x22345a },
	{ 0x5a60, 0x223451 },
	{ 0x5a61, 0x233527 },
	{ 0x5a62, 0x215965 },
	{ 0x5a63, 0x23353c },
	{ 0x5a64, 0x22345e },
	{ 0x5a65, 0x22345b },
	{ 0x5a66, 0x215961 },
	{ 0x5a67, 0x223454 },
	{ 0x5a68, 0x233530 },
	{ 0x5a69, 0x22346c },
	{ 0x5a6a, 0x215962 },
	{ 0x5a6b, 0x23352b },
	{ 0x5a6c, 0x22345c },
	{ 0x5a6d, 0x223458 },
	{ 0x5a6e, 0x233529 },
	{ 0x5a6f, 0x233534 },
	{ 0x5a70, 0x22346b },
	{ 0x5a71, 0x233532 },
	{ 0x5a72, 0x2f3373 },
	{ 0x5a73, 0x233537 },
	{ 0x5a75, 0x233535 },
	{ 0x5a77, 0x215e65 },
	{ 0x5a78, 0x223a7d },
	{ 0x5a79, 0x233a75 },
	{ 0x5a7a, 0x223a7a },
	{ 0x5a7b, 0x223b2d },
	{ 0x5a7c, 0x223b21 },
	{ 0x5a7d, 0x223b2e },
	{ 0x5a7e, 0x233a7c },
	{ 0x5a7f, 0x215e67 },
	{ 0x5a80, 0x233a63 },
	{ 0x5a81, 0x233a61 },
	{ 0x5a82, 0x233a58 },
	{ 0x5a83, 0x223b2a },
	{ 0x5a84, 0x223b27 },
	{ 0x5a85, 0x233a5b },
	{ 0x5a86, 0x233a77 },
	{ 0x5a87, 0x233a72 },
	{ 0x5a88, 0x233a59 },
	{ 0x5a89, 0x233a60 },
	{ 0x5a8a, 0x223b28 },
	{ 0x5a8b, 0x223b2b },
	{ 0x5a8c, 0x223b2f },
	{ 0x5a8d, 0x233a7b },
	{ 0x5a8e, 0x223466 },
	{ 0x5a8f, 0x223b31 },
	{ 0x5a90, 0x22424d },
	{ 0x5a91, 0x233a66 },
	{ 0x5a92, 0x215e68 },
	{ 0x5a93, 0x223b32 },
	{ 0x5a94, 0x223a78 },
	{ 0x5a95, 0x223b24 },
	{ 0x5a96, 0x233a62 },
	{ 0x5a97, 0x223b29 },
	{ 0x5a98, 0x233a5c },
	{ 0x5a99, 0x233a5e },
	{ 0x5a9a, 0x215e66 },
	{ 0x5a9b, 0x215e69 },
	{ 0x5a9c, 0x223b30 },
	{ 0x5a9d, 0x223b33 },
	{ 0x5a9e, 0x223a7c },
	{ 0x5a9f, 0x223a79 },
	{ 0x5aa0, 0x233a73 },
	{ 0x5aa1, 0x233a5a },
	{ 0x5aa2, 0x223a7b },
	{ 0x5aa3, 0x233a57 },
	{ 0x5aa4, 0x233a7a },
	{ 0x5aa5, 0x223b22 },
	{ 0x5aa6, 0x223a7e },
	{ 0x5aa7, 0x215e6a },
	{ 0x5aa8, 0x233a56 },
	{ 0x5aa9, 0x223b2c },
	{ 0x5aaa, 0x233a79 },
	{ 0x5aab, 0x233a78 },
	{ 0x5aac, 0x223b23 },
	{ 0x5aae, 0x223b25 },
	{ 0x5aaf, 0x223a77 },
	{ 0x5ab0, 0x224241 },
	{ 0x5ab1, 0x22423f },
	{ 0x5ab2, 0x216368 },
	{ 0x5ab3, 0x216366 },
	{ 0x5ab4, 0x224249 },
	{ 0x5ab5, 0x224240 },
	{ 0x5ab6, 0x22424a },
	{ 0x5ab7, 0x224246 },
	{ 0x5ab8, 0x22423e },
	{ 0x5ab9, 0x22424c },
	{ 0x5aba, 0x22423d },
	{ 0x5abb, 0x224244 },
	{ 0x5abc, 0x216365 },
	{ 0x5abd, 0x216364 },
	{ 0x5abe, 0x216363 },
	{ 0x5abf, 0x224242 },
	{ 0x5ac0, 0x224247 },
	{ 0x5ac1, 0x216360 },
	{ 0x5ac2, 0x216367 },
	{ 0x5ac3, 0x234067 },
	{ 0x5ac4, 0x22423b },
	{ 0x5ac5, 0x234066 },
	{ 0x5ac6, 0x224245 },
	{ 0x5ac7, 0x22423a },
	{ 0x5ac8, 0x224243 },
	{ 0x5ac9, 0x216361 },
	{ 0x5aca, 0x224248 },
	{ 0x5acb, 0x22423c },
	{ 0x5acc, 0x216362 },
	{ 0x5acd, 0x22424b },
	{ 0x5ace, 0x234064 },
	{ 0x5acf, 0x233a6b },
	{ 0x5ad0, 0x23406a },
	{ 0x5ad1, 0x236468 },
	{ 0x5ad3, 0x236469 },
	{ 0x5ad5, 0x224955 },
	{ 0x5ad6, 0x21684a },
	{ 0x5ad7, 0x216849 },
	{ 0x5ad8, 0x21684b },
	{ 0x5ad9, 0x224961 },
	{ 0x5ada, 0x224957 },
	{ 0x5adb, 0x22495d },
	{ 0x5adc, 0x224952 },
	{ 0x5add, 0x224960 },
	{ 0x5ade, 0x22495f },
	{ 0x5adf, 0x224963 },
	{ 0x5ae0, 0x22495c },
	{ 0x5ae1, 0x216846 },
	{ 0x5ae2, 0x22495b },
	{ 0x5ae3, 0x21684c },
	{ 0x5ae4, 0x23464c },
	{ 0x5ae5, 0x224954 },
	{ 0x5ae6, 0x216847 },
	{ 0x5ae7, 0x23464a },
	{ 0x5ae8, 0x224962 },
	{ 0x5ae9, 0x216848 },
	{ 0x5aea, 0x224956 },
	{ 0x5aeb, 0x224959 },
	{ 0x5aec, 0x22495e },
	{ 0x5aed, 0x224958 },
	{ 0x5aee, 0x224953 },
	{ 0x5aef, 0x23464f },
	{ 0x5af0, 0x234653 },
	{ 0x5af3, 0x22495a },
	{ 0x5af4, 0x224f7c },
	{ 0x5af5, 0x216c4b },
	{ 0x5af6, 0x225021 },
	{ 0x5af7, 0x224f7e },
	{ 0x5af8, 0x225023 },
	{ 0x5af9, 0x225025 },
	{ 0x5afa, 0x234b5c },
	{ 0x5afb, 0x216c49 },
	{ 0x5afc, 0x234b58 },
	{ 0x5afd, 0x224f7d },
	{ 0x5afe, 0x234b54 },
	{ 0x5aff, 0x224f7b },
	{ 0x5b00, 0x234b5e },
	{ 0x5b01, 0x225026 },
	{ 0x5b02, 0x225024 },
	{ 0x5b03, 0x225022 },
	{ 0x5b04, 0x234b56 },
	{ 0x5b05, 0x225028 },
	{ 0x5b06, 0x234b5a },
	{ 0x5b07, 0x225027 },
	{ 0x5b08, 0x216c4d },
	{ 0x5b09, 0x216c48 },
	{ 0x5b0a, 0x234b5b },
	{ 0x5b0b, 0x216c4a },
	{ 0x5b0c, 0x216c4c },
	{ 0x5b0d, 0x234b5d },
	{ 0x5b0e, 0x234b5f },
	{ 0x5b0f, 0x225029 },
	{ 0x5b10, 0x225661 },
	{ 0x5b11, 0x235050 },
	{ 0x5b12, 0x235053 },
	{ 0x5b13, 0x225660 },
	{ 0x5b14, 0x22565f },
	{ 0x5b15, 0x235051 },
	{ 0x5b16, 0x225662 },
	{ 0x5b17, 0x22565b },
	{ 0x5b18, 0x23504f },
	{ 0x5b19, 0x22565c },
	{ 0x5b1a, 0x225664 },
	{ 0x5b1b, 0x22565d },
	{ 0x5b1c, 0x235054 },
	{ 0x5b1d, 0x21704e },
	{ 0x5b1e, 0x225666 },
	{ 0x5b1f, 0x23504e },
	{ 0x5b20, 0x225665 },
	{ 0x5b21, 0x22565e },
	{ 0x5b22, 0x235056 },
	{ 0x5b23, 0x225c5d },
	{ 0x5b24, 0x217351 },
	{ 0x5b25, 0x225c5b },
	{ 0x5b26, 0x225c60 },
	{ 0x5b27, 0x225c5f },
	{ 0x5b28, 0x225663 },
	{ 0x5b29, 0x235450 },
	{ 0x5b2a, 0x217350 },
	{ 0x5b2b, 0x23544e },
	{ 0x5b2c, 0x225c5e },
	{ 0x5b2d, 0x225c5a },
	{ 0x5b2e, 0x225c62 },
	{ 0x5b2f, 0x225c61 },
	{ 0x5b30, 0x21734f },
	{ 0x5b31, 0x235452 },
	{ 0x5b32, 0x225c5c },
	{ 0x5b33, 0x23544f },
	{ 0x5b34, 0x21704f },
	{ 0x5b35, 0x235451 },
	{ 0x5b37, 0x235453 },
	{ 0x5b38, 0x217640 },
	{ 0x5b39, 0x235a31 },
	{ 0x5b3a, 0x235761 },
	{ 0x5b3b, 0x23575e },
	{ 0x5b3c, 0x22614d },
	{ 0x5b3d, 0x226546 },
	{ 0x5b3e, 0x226547 },
	{ 0x5b3f, 0x226548 },
	{ 0x5b40, 0x217967 },
	{ 0x5b41, 0x246334 },
	{ 0x5b42, 0x235c36 },
	{ 0x5b43, 0x217968 },
	{ 0x5b44, 0x235c39 },
	{ 0x5b45, 0x22686f },
	{ 0x5b46, 0x235c3a },
	{ 0x5b47, 0x226b56 },
	{ 0x5b48, 0x226b55 },
	{ 0x5b49, 0x235e29 },
	{ 0x5b4a, 0x235f42 },
	{ 0x5b4b, 0x226d49 },
	{ 0x5b4c, 0x226d4a },
	{ 0x5b4d, 0x226f24 },
	{ 0x5b4e, 0x227035 },
	{ 0x5b4f, 0x236073 },
	{ 0x5b50, 0x21444d },
	{ 0x5b51, 0x21444e },
	{ 0x5b52, 0x242132 },
	{ 0x5b53, 0x21444f },
	{ 0x5b54, 0x214536 },
	{ 0x5b55, 0x214645 },
	{ 0x5b56, 0x222233 },
	{ 0x5b57, 0x214773 },
	{ 0x5b58, 0x214774 },
	{ 0x5b5a, 0x214977 },
	{ 0x5b5b, 0x214978 },
	{ 0x5b5c, 0x214976 },
	{ 0x5b5d, 0x214975 },
	{ 0x5b5f, 0x214c75 },
	{ 0x5b60, 0x232848 },
	{ 0x5b61, 0x242622 },
	{ 0x5b62, 0x222636 },
	{ 0x5b63, 0x214c77 },
	{ 0x5b64, 0x214c76 },
	{ 0x5b65, 0x222637 },
	{ 0x5b66, 0x242623 },
	{ 0x5b67, 0x23646a },
	{ 0x5b68, 0x24286e },
	{ 0x5b69, 0x215066 },
	{ 0x5b6a, 0x232c2f },
	{ 0x5b6b, 0x215521 },
	{ 0x5b6c, 0x222e67 },
	{ 0x5b6e, 0x223473 },
	{ 0x5b6f, 0x24312c },
	{ 0x5b70, 0x215969 },
	{ 0x5b71, 0x215e6c },
	{ 0x5b72, 0x223472 },
	{ 0x5b73, 0x215e6b },
	{ 0x5b74, 0x234071 },
	{ 0x5b75, 0x21684d },
	{ 0x5b76, 0x234072 },
	{ 0x5b77, 0x224964 },
	{ 0x5b78, 0x217050 },
	{ 0x5b79, 0x235057 },
	{ 0x5b7a, 0x217352 },
	{ 0x5b7b, 0x225c63 },
	{ 0x5b7c, 0x235a34 },
	{ 0x5b7d, 0x217969 },
	{ 0x5b7e, 0x235c3b },
	{ 0x5b7f, 0x217b5c },
	{ 0x5b80, 0x23213b },
	{ 0x5b81, 0x222153 },
	{ 0x5b82, 0x23223d },
	{ 0x5b83, 0x214646 },
	{ 0x5b84, 0x222154 },
	{ 0x5b85, 0x214777 },
	{ 0x5b86, 0x232350 },
	{ 0x5b87, 0x214775 },
	{ 0x5b88, 0x214776 },
	{ 0x5b89, 0x214778 },
	{ 0x5b8a, 0x24236f },
	{ 0x5b8b, 0x21497a },
	{ 0x5b8c, 0x214979 },
	{ 0x5b8d, 0x23255a },
	{ 0x5b8e, 0x22235c },
	{ 0x5b8f, 0x21497b },
	{ 0x5b90, 0x242625 },
	{ 0x5b92, 0x22235d },
	{ 0x5b93, 0x222638 },
	{ 0x5b94, 0x23284c },
	{ 0x5b95, 0x222639 },
	{ 0x5b96, 0x23284a },
	{ 0x5b97, 0x214c78 },
	{ 0x5b98, 0x214c7a },
	{ 0x5b99, 0x214c7c },
	{ 0x5b9a, 0x214c79 },
	{ 0x5b9b, 0x214c7d },
	{ 0x5b9c, 0x214c7b },
	{ 0x5b9d, 0x23284e },
	{ 0x5b9e, 0x23284b },
	{ 0x5b9f, 0x23284d },
	{ 0x5ba2, 0x21506a },
	{ 0x5ba3, 0x215067 },
	{ 0x5ba4, 0x215069 },
	{ 0x5ba5, 0x21506b },
	{ 0x5ba6, 0x215068 },
	{ 0x5ba7, 0x222e68 },
	{ 0x5ba8, 0x222978 },
	{ 0x5ba9, 0x2f2a39 },
	{ 0x5bab, 0x232c32 },
	{ 0x5bac, 0x222e6a },
	{ 0x5bad, 0x222e69 },
	{ 0x5bae, 0x215527 },
	{ 0x5baf, 0x242c46 },
	{ 0x5bb0, 0x215523 },
	{ 0x5bb1, 0x242c49 },
	{ 0x5bb2, 0x263666 },
	{ 0x5bb3, 0x215524 },
	{ 0x5bb4, 0x215526 },
	{ 0x5bb5, 0x215528 },
	{ 0x5bb6, 0x215525 },
	{ 0x5bb7, 0x233057 },
	{ 0x5bb8, 0x21552a },
	{ 0x5bb9, 0x215529 },
	{ 0x5bba, 0x242c48 },
	{ 0x5bbb, 0x233056 },
	{ 0x5bbc, 0x233055 },
	{ 0x5bbe, 0x2f2e7e },
	{ 0x5bbf, 0x21596e },
	{ 0x5bc0, 0x223475 },
	{ 0x5bc1, 0x223474 },
	{ 0x5bc2, 0x21596d },
	{ 0x5bc3, 0x233541 },
	{ 0x5bc4, 0x21596c },
	{ 0x5bc5, 0x21596b },
	{ 0x5bc6, 0x21596f },
	{ 0x5bc7, 0x21596a },
	{ 0x5bc8, 0x23353f },
	{ 0x5bca, 0x223b39 },
	{ 0x5bcb, 0x223b36 },
	{ 0x5bcc, 0x215e6e },
	{ 0x5bcd, 0x223b35 },
	{ 0x5bce, 0x223b3a },
	{ 0x5bcf, 0x243724 },
	{ 0x5bd0, 0x215e70 },
	{ 0x5bd1, 0x223b38 },
	{ 0x5bd2, 0x215e6d },
	{ 0x5bd3, 0x215e6f },
	{ 0x5bd4, 0x223b37 },
	{ 0x5bd5, 0x233a7e },
	{ 0x5bd6, 0x22424e },
	{ 0x5bd7, 0x234074 },
	{ 0x5bd8, 0x22424f },
	{ 0x5bd9, 0x224250 },
	{ 0x5bda, 0x234075 },
	{ 0x5bdb, 0x234076 },
	{ 0x5bdc, 0x234073 },
	{ 0x5bdd, 0x243c6e },
	{ 0x5bde, 0x21684e },
	{ 0x5bdf, 0x216856 },
	{ 0x5be0, 0x224965 },
	{ 0x5be1, 0x216850 },
	{ 0x5be2, 0x216854 },
	{ 0x5be3, 0x224966 },
	{ 0x5be4, 0x216855 },
	{ 0x5be5, 0x216851 },
	{ 0x5be6, 0x216852 },
	{ 0x5be7, 0x21684f },
	{ 0x5be8, 0x216853 },
	{ 0x5be9, 0x216c50 },
	{ 0x5bea, 0x223b34 },
	{ 0x5beb, 0x216c51 },
	{ 0x5bec, 0x216c4f },
	{ 0x5bed, 0x244944 },
	{ 0x5bee, 0x216c4e },
	{ 0x5bef, 0x225667 },
	{ 0x5bf0, 0x217051 },
	{ 0x5bf1, 0x225c64 },
	{ 0x5bf2, 0x225c65 },
	{ 0x5bf3, 0x235a35 },
	{ 0x5bf4, 0x245f55 },
	{ 0x5bf5, 0x217831 },
	{ 0x5bf6, 0x21796a },
	{ 0x5bf7, 0x235e2a },
	{ 0x5bf8, 0x214450 },
	{ 0x5bf9, 0x23223e },
	{ 0x5bfa, 0x214779 },
	{ 0x5bfd, 0x23255e },
	{ 0x5bfe, 0x23255c },
	{ 0x5bff, 0x23255d },
	{ 0x5c00, 0x232850 },
	{ 0x5c01, 0x21506c },
	{ 0x5c03, 0x222e6b },
	{ 0x5c04, 0x21552b },
	{ 0x5c05, 0x233058 },
	{ 0x5c06, 0x233059 },
	{ 0x5c07, 0x215972 },
	{ 0x5c08, 0x215971 },
	{ 0x5c09, 0x215970 },
	{ 0x5c0a, 0x215e71 },
	{ 0x5c0b, 0x215e72 },
	{ 0x5c0c, 0x223b3b },
	{ 0x5c0d, 0x216857 },
	{ 0x5c0e, 0x217052 },
	{ 0x5c0f, 0x214451 },
	{ 0x5c10, 0x22213c },
	{ 0x5c11, 0x214537 },
	{ 0x5c12, 0x222155 },
	{ 0x5c13, 0x242173 },
	{ 0x5c14, 0x23223f },
	{ 0x5c15, 0x222234 },
	{ 0x5c16, 0x21477a },
	{ 0x5c17, 0x24225c },
	{ 0x5c18, 0x232352 },
	{ 0x5c19, 0x232851 },
	{ 0x5c1a, 0x214c7e },
	{ 0x5c1b, 0x232c34 },
	{ 0x5c1e, 0x233b24 },
	{ 0x5c1f, 0x224251 },
	{ 0x5c20, 0x234078 },
	{ 0x5c21, 0x236525 },
	{ 0x5c22, 0x214452 },
	{ 0x5c23, 0x24214b },
	{ 0x5c24, 0x214538 },
	{ 0x5c25, 0x222235 },
	{ 0x5c28, 0x22235e },
	{ 0x5c29, 0x242629 },
	{ 0x5c2a, 0x22235f },
	{ 0x5c2b, 0x23255f },
	{ 0x5c2c, 0x21497c },
	{ 0x5c2d, 0x2f2554 },
	{ 0x5c2f, 0x232c35 },
	{ 0x5c30, 0x223b3c },
	{ 0x5c31, 0x215e73 },
	{ 0x5c33, 0x224252 },
	{ 0x5c35, 0x244949 },
	{ 0x5c36, 0x235454 },
	{ 0x5c37, 0x217353 },
	{ 0x5c38, 0x214453 },
	{ 0x5c39, 0x214467 },
	{ 0x5c3a, 0x214539 },
	{ 0x5c3b, 0x222156 },
	{ 0x5c3c, 0x214647 },
	{ 0x5c3d, 0x232354 },
	{ 0x5c3e, 0x214a22 },
	{ 0x5c3f, 0x214a21 },
	{ 0x5c40, 0x21497d },
	{ 0x5c41, 0x21497e },
	{ 0x5c44, 0x22263a },
	{ 0x5c45, 0x214d22 },
	{ 0x5c46, 0x214d23 },
	{ 0x5c47, 0x22263b },
	{ 0x5c48, 0x214d21 },
	{ 0x5c49, 0x232854 },
	{ 0x5c4a, 0x232855 },
	{ 0x5c4b, 0x215070 },
	{ 0x5c4c, 0x222979 },
	{ 0x5c4d, 0x21506f },
	{ 0x5c4e, 0x21506d },
	{ 0x5c4f, 0x21506e },
	{ 0x5c50, 0x21552e },
	{ 0x5c51, 0x21552c },
	{ 0x5c52, 0x23305a },
	{ 0x5c53, 0x23305b },
	{ 0x5c54, 0x222e6d },
	{ 0x5c55, 0x21552d },
	{ 0x5c56, 0x222e6c },
	{ 0x5c57, 0x23646b },
	{ 0x5c58, 0x215522 },
	{ 0x5c59, 0x223476 },
	{ 0x5c5a, 0x243135 },
	{ 0x5c5b, 0x233543 },
	{ 0x5c5c, 0x215974 },
	{ 0x5c5d, 0x215975 },
	{ 0x5c5e, 0x233b26 },
	{ 0x5c5f, 0x233b25 },
	{ 0x5c60, 0x215973 },
	{ 0x5c61, 0x233544 },
	{ 0x5c62, 0x216858 },
	{ 0x5c63, 0x224967 },
	{ 0x5c64, 0x216c52 },
	{ 0x5c65, 0x216c53 },
	{ 0x5c67, 0x22502a },
	{ 0x5c68, 0x217354 },
	{ 0x5c69, 0x22614e },
	{ 0x5c6a, 0x22614f },
	{ 0x5c6b, 0x235a38 },
	{ 0x5c6c, 0x217a68 },
	{ 0x5c6d, 0x227036 },
	{ 0x5c6e, 0x22212b },
	{ 0x5c6f, 0x21453a },
	{ 0x5c70, 0x24225f },
	{ 0x5c71, 0x214454 },
	{ 0x5c73, 0x222158 },
	{ 0x5c74, 0x222157 },
	{ 0x5c75, 0x242176 },
	{ 0x5c77, 0x23646c },
	{ 0x5c78, 0x232355 },
	{ 0x5c79, 0x21477b },
	{ 0x5c7a, 0x222237 },
	{ 0x5c7b, 0x222238 },
	{ 0x5c7c, 0x222236 },
	{ 0x5c7d, 0x242260 },
	{ 0x5c7e, 0x222239 },
	{ 0x5c80, 0x23235a },
	{ 0x5c81, 0x2f2247 },
	{ 0x5c84, 0x232561 },
	{ 0x5c85, 0x232566 },
	{ 0x5c86, 0x222367 },
	{ 0x5c87, 0x24237a },
	{ 0x5c88, 0x222362 },
	{ 0x5c89, 0x222364 },
	{ 0x5c8a, 0x222366 },
	{ 0x5c8b, 0x222363 },
	{ 0x5c8c, 0x214a26 },
	{ 0x5c8d, 0x222360 },
	{ 0x5c8e, 0x232562 },
	{ 0x5c8f, 0x222361 },
	{ 0x5c90, 0x214a23 },
	{ 0x5c91, 0x214a24 },
	{ 0x5c92, 0x222365 },
	{ 0x5c93, 0x222368 },
	{ 0x5c94, 0x214a25 },
	{ 0x5c95, 0x222369 },
	{ 0x5c97, 0x2f237c },
	{ 0x5c99, 0x2f2378 },
	{ 0x5c9c, 0x232563 },
	{ 0x5c9d, 0x222649 },
	{ 0x5c9e, 0x23285d },
	{ 0x5c9f, 0x222643 },
	{ 0x5ca0, 0x22263e },
	{ 0x5ca1, 0x214d25 },
	{ 0x5ca2, 0x222646 },
	{ 0x5ca3, 0x222644 },
	{ 0x5ca4, 0x22263d },
	{ 0x5ca5, 0x22264a },
	{ 0x5ca6, 0x22264d },
	{ 0x5ca7, 0x222648 },
	{ 0x5ca8, 0x222641 },
	{ 0x5ca9, 0x214d27 },
	{ 0x5caa, 0x222647 },
	{ 0x5cab, 0x214d28 },
	{ 0x5cac, 0x222642 },
	{ 0x5cad, 0x222645 },
	{ 0x5cae, 0x22263c },
	{ 0x5caf, 0x222640 },
	{ 0x5cb0, 0x22264c },
	{ 0x5cb1, 0x214d29 },
	{ 0x5cb2, 0x24262f },
	{ 0x5cb3, 0x214d2a },
	{ 0x5cb4, 0x23285e },
	{ 0x5cb5, 0x22263f },
	{ 0x5cb6, 0x22264b },
	{ 0x5cb7, 0x214d24 },
	{ 0x5cb8, 0x214d26 },
	{ 0x5cb9, 0x23285c },
	{ 0x5cba, 0x23285f },
	{ 0x5cbb, 0x232857 },
	{ 0x5cc0, 0x242634 },
	{ 0x5cc1, 0x232858 },
	{ 0x5cc6, 0x222a2c },
	{ 0x5cc7, 0x222a25 },
	{ 0x5cc8, 0x222a2b },
	{ 0x5cc9, 0x222a24 },
	{ 0x5cca, 0x222a26 },
	{ 0x5ccb, 0x22297e },
	{ 0x5ccc, 0x22297c },
	{ 0x5ccd, 0x232c3f },
	{ 0x5cce, 0x222a2d },
	{ 0x5ccf, 0x222a2a },
	{ 0x5cd0, 0x22297a },
	{ 0x5cd1, 0x232c3b },
	{ 0x5cd2, 0x215072 },
	{ 0x5cd3, 0x222a28 },
	{ 0x5cd4, 0x222a29 },
	{ 0x5cd5, 0x23646d },
	{ 0x5cd6, 0x222a27 },
	{ 0x5cd7, 0x22297d },
	{ 0x5cd8, 0x22297b },
	{ 0x5cd9, 0x215071 },
	{ 0x5cda, 0x222a23 },
	{ 0x5cdb, 0x222a21 },
	{ 0x5cdc, 0x232c3c },
	{ 0x5cdd, 0x232c42 },
	{ 0x5cde, 0x222a22 },
	{ 0x5cdf, 0x222a2e },
	{ 0x5ce1, 0x232c3e },
	{ 0x5ce2, 0x232c41 },
	{ 0x5ce5, 0x232c43 },
	{ 0x5ce6, 0x232c3d },
	{ 0x5ce8, 0x215533 },
	{ 0x5ce9, 0x233063 },
	{ 0x5cea, 0x215532 },
	{ 0x5ceb, 0x23305f },
	{ 0x5cec, 0x222e6e },
	{ 0x5ced, 0x21552f },
	{ 0x5cee, 0x222e70 },
	{ 0x5cef, 0x233064 },
	{ 0x5cf0, 0x215534 },
	{ 0x5cf1, 0x222e71 },
	{ 0x5cf2, 0x242c60 },
	{ 0x5cf3, 0x233061 },
	{ 0x5cf4, 0x215537 },
	{ 0x5cf5, 0x233062 },
	{ 0x5cf6, 0x215535 },
	{ 0x5cf7, 0x222e72 },
	{ 0x5cf8, 0x222a2f },
	{ 0x5cf9, 0x222e74 },
	{ 0x5cfa, 0x23305e },
	{ 0x5cfb, 0x215531 },
	{ 0x5cfc, 0x242c5c },
	{ 0x5cfd, 0x215530 },
	{ 0x5cfe, 0x242c61 },
	{ 0x5cff, 0x222e6f },
	{ 0x5d00, 0x222e73 },
	{ 0x5d01, 0x215536 },
	{ 0x5d06, 0x215977 },
	{ 0x5d07, 0x215976 },
	{ 0x5d08, 0x23354b },
	{ 0x5d09, 0x233548 },
	{ 0x5d0a, 0x233547 },
	{ 0x5d0b, 0x223478 },
	{ 0x5d0c, 0x22347c },
	{ 0x5d0d, 0x22347e },
	{ 0x5d0e, 0x215978 },
	{ 0x5d0f, 0x223523 },
	{ 0x5d10, 0x233551 },
	{ 0x5d11, 0x21597c },
	{ 0x5d12, 0x223525 },
	{ 0x5d13, 0x233552 },
	{ 0x5d14, 0x21597e },
	{ 0x5d15, 0x23354f },
	{ 0x5d16, 0x21597a },
	{ 0x5d17, 0x215a24 },
	{ 0x5d18, 0x233555 },
	{ 0x5d19, 0x215a21 },
	{ 0x5d1a, 0x22347a },
	{ 0x5d1b, 0x215979 },
	{ 0x5d1c, 0x233b2b },
	{ 0x5d1d, 0x223479 },
	{ 0x5d1e, 0x223477 },
	{ 0x5d1f, 0x223527 },
	{ 0x5d20, 0x22347b },
	{ 0x5d21, 0x233546 },
	{ 0x5d22, 0x21597b },
	{ 0x5d23, 0x223526 },
	{ 0x5d24, 0x215a22 },
	{ 0x5d25, 0x223522 },
	{ 0x5d26, 0x223521 },
	{ 0x5d27, 0x215a23 },
	{ 0x5d28, 0x22347d },
	{ 0x5d29, 0x21597d },
	{ 0x5d2a, 0x23354e },
	{ 0x5d2b, 0x263e76 },
	{ 0x5d2c, 0x23354a },
	{ 0x5d2e, 0x223528 },
	{ 0x5d2f, 0x233554 },
	{ 0x5d30, 0x223524 },
	{ 0x5d31, 0x223b4b },
	{ 0x5d32, 0x223b52 },
	{ 0x5d33, 0x223b47 },
	{ 0x5d34, 0x215e76 },
	{ 0x5d35, 0x223b43 },
	{ 0x5d36, 0x223b53 },
	{ 0x5d37, 0x223b3d },
	{ 0x5d38, 0x223b50 },
	{ 0x5d39, 0x223b4e },
	{ 0x5d3a, 0x223b48 },
	{ 0x5d3b, 0x233b36 },
	{ 0x5d3c, 0x223b51 },
	{ 0x5d3d, 0x223b4a },
	{ 0x5d3e, 0x233b28 },
	{ 0x5d3f, 0x223b42 },
	{ 0x5d40, 0x223b54 },
	{ 0x5d41, 0x223b40 },
	{ 0x5d42, 0x223b4d },
	{ 0x5d43, 0x223b3e },
	{ 0x5d44, 0x233b27 },
	{ 0x5d45, 0x223b55 },
	{ 0x5d46, 0x233b37 },
	{ 0x5d47, 0x215e77 },
	{ 0x5d48, 0x233b2a },
	{ 0x5d49, 0x223b4f },
	{ 0x5d4a, 0x224255 },
	{ 0x5d4b, 0x223b41 },
	{ 0x5d4c, 0x215e74 },
	{ 0x5d4d, 0x233b2e },
	{ 0x5d4e, 0x223b45 },
	{ 0x5d4f, 0x233b34 },
	{ 0x5d50, 0x215e75 },
	{ 0x5d51, 0x223b44 },
	{ 0x5d52, 0x223b49 },
	{ 0x5d53, 0x233b33 },
	{ 0x5d54, 0x243735 },
	{ 0x5d55, 0x223b46 },
	{ 0x5d56, 0x24372f },
	{ 0x5d57, 0x233b31 },
	{ 0x5d59, 0x223b4c },
	{ 0x5d5b, 0x233b2d },
	{ 0x5d5e, 0x224259 },
	{ 0x5d5f, 0x243c79 },
	{ 0x5d60, 0x234121 },
	{ 0x5d61, 0x243c7b },
	{ 0x5d62, 0x22425c },
	{ 0x5d63, 0x224254 },
	{ 0x5d64, 0x23407c },
	{ 0x5d65, 0x224256 },
	{ 0x5d66, 0x23407a },
	{ 0x5d67, 0x22425b },
	{ 0x5d68, 0x22425a },
	{ 0x5d69, 0x216369 },
	{ 0x5d6a, 0x243c75 },
	{ 0x5d6b, 0x223b3f },
	{ 0x5d6c, 0x224258 },
	{ 0x5d6d, 0x234079 },
	{ 0x5d6e, 0x23407d },
	{ 0x5d6f, 0x21636a },
	{ 0x5d70, 0x243c74 },
	{ 0x5d71, 0x224253 },
	{ 0x5d72, 0x224257 },
	{ 0x5d73, 0x243c7c },
	{ 0x5d74, 0x243c78 },
	{ 0x5d75, 0x23646e },
	{ 0x5d77, 0x22496e },
	{ 0x5d78, 0x23465c },
	{ 0x5d79, 0x224975 },
	{ 0x5d7a, 0x22496c },
	{ 0x5d7b, 0x234654 },
	{ 0x5d7c, 0x224973 },
	{ 0x5d7d, 0x22496a },
	{ 0x5d7e, 0x224972 },
	{ 0x5d7f, 0x224976 },
	{ 0x5d80, 0x224969 },
	{ 0x5d81, 0x22496d },
	{ 0x5d82, 0x224968 },
	{ 0x5d83, 0x234656 },
	{ 0x5d84, 0x216859 },
	{ 0x5d85, 0x24432c },
	{ 0x5d86, 0x22496b },
	{ 0x5d87, 0x21685a },
	{ 0x5d88, 0x224971 },
	{ 0x5d89, 0x224970 },
	{ 0x5d8a, 0x22496f },
	{ 0x5d8b, 0x234659 },
	{ 0x5d8c, 0x23465a },
	{ 0x5d8d, 0x224974 },
	{ 0x5d8e, 0x23646f },
	{ 0x5d8f, 0x234b65 },
	{ 0x5d90, 0x234b66 },
	{ 0x5d91, 0x234b63 },
	{ 0x5d92, 0x22502e },
	{ 0x5d93, 0x225030 },
	{ 0x5d94, 0x216c55 },
	{ 0x5d95, 0x225031 },
	{ 0x5d96, 0x234b6b },
	{ 0x5d97, 0x22502c },
	{ 0x5d98, 0x234b67 },
	{ 0x5d99, 0x22502b },
	{ 0x5d9a, 0x225035 },
	{ 0x5d9b, 0x234b69 },
	{ 0x5d9c, 0x225033 },
	{ 0x5d9d, 0x216c54 },
	{ 0x5d9e, 0x225036 },
	{ 0x5d9f, 0x22502d },
	{ 0x5da0, 0x225032 },
	{ 0x5da1, 0x225034 },
	{ 0x5da2, 0x22502f },
	{ 0x5da3, 0x234b6a },
	{ 0x5da4, 0x234b68 },
	{ 0x5da5, 0x236470 },
	{ 0x5da6, 0x235058 },
	{ 0x5da7, 0x22566b },
	{ 0x5da8, 0x225670 },
	{ 0x5da9, 0x22566a },
	{ 0x5daa, 0x22566f },
	{ 0x5dab, 0x23505b },
	{ 0x5dac, 0x225668 },
	{ 0x5dad, 0x225672 },
	{ 0x5dae, 0x22566e },
	{ 0x5daf, 0x225673 },
	{ 0x5db0, 0x22566d },
	{ 0x5db1, 0x225669 },
	{ 0x5db2, 0x225671 },
	{ 0x5db3, 0x23505a },
	{ 0x5db4, 0x225674 },
	{ 0x5db5, 0x22566c },
	{ 0x5db6, 0x236471 },
	{ 0x5db7, 0x225c66 },
	{ 0x5db8, 0x217358 },
	{ 0x5db9, 0x235457 },
	{ 0x5dba, 0x217356 },
	{ 0x5dbb, 0x235459 },
	{ 0x5dbc, 0x217355 },
	{ 0x5dbd, 0x217357 },
	{ 0x5dbe, 0x235455 },
	{ 0x5dbf, 0x236472 },
	{ 0x5dc0, 0x226150 },
	{ 0x5dc1, 0x235762 },
	{ 0x5dc2, 0x22643e },
	{ 0x5dc3, 0x226549 },
	{ 0x5dc4, 0x235a39 },
	{ 0x5dc6, 0x226870 },
	{ 0x5dc7, 0x226871 },
	{ 0x5dc8, 0x235c3d },
	{ 0x5dc9, 0x21796b },
	{ 0x5dca, 0x235c3c },
	{ 0x5dcb, 0x226b57 },
	{ 0x5dcc, 0x235c3e },
	{ 0x5dcd, 0x217a69 },
	{ 0x5dce, 0x24663b },
	{ 0x5dcf, 0x226b58 },
	{ 0x5dd0, 0x235e2d },
	{ 0x5dd1, 0x226d4c },
	{ 0x5dd2, 0x217b5e },
	{ 0x5dd3, 0x235f43 },
	{ 0x5dd4, 0x217b5d },
	{ 0x5dd5, 0x226d4b },
	{ 0x5dd6, 0x217c35 },
	{ 0x5dd7, 0x236030 },
	{ 0x5dd8, 0x226f25 },
	{ 0x5dd9, 0x246b68 },
	{ 0x5dda, 0x246a46 },
	{ 0x5ddb, 0x23213c },
	{ 0x5ddc, 0x24212c },
	{ 0x5ddd, 0x214455 },
	{ 0x5dde, 0x21477c },
	{ 0x5ddf, 0x22223a },
	{ 0x5de0, 0x22236a },
	{ 0x5de1, 0x214b56 },
	{ 0x5de2, 0x215a25 },
	{ 0x5de3, 0x233557 },
	{ 0x5de4, 0x234b6c },
	{ 0x5de5, 0x214456 },
	{ 0x5de6, 0x21464a },
	{ 0x5de7, 0x214649 },
	{ 0x5de8, 0x214648 },
	{ 0x5de9, 0x242263 },
	{ 0x5deb, 0x214a27 },
	{ 0x5dee, 0x215538 },
	{ 0x5df0, 0x22425d },
	{ 0x5df1, 0x214457 },
	{ 0x5df2, 0x214458 },
	{ 0x5df3, 0x214459 },
	{ 0x5df4, 0x21453b },
	{ 0x5df5, 0x232567 },
	{ 0x5df6, 0x232860 },
	{ 0x5df7, 0x215073 },
	{ 0x5df8, 0x242c64 },
	{ 0x5df9, 0x222a30 },
	{ 0x5dfa, 0x232c45 },
	{ 0x5dfb, 0x232c44 },
	{ 0x5dfd, 0x215e78 },
	{ 0x5dfe, 0x21445a },
	{ 0x5dff, 0x22213d },
	{ 0x5e00, 0x232163 },
	{ 0x5e01, 0x24214c },
	{ 0x5e02, 0x21464b },
	{ 0x5e03, 0x21464c },
	{ 0x5e04, 0x222159 },
	{ 0x5e06, 0x21477d },
	{ 0x5e07, 0x25225c },
	{ 0x5e08, 0x23235c },
	{ 0x5e09, 0x232568 },
	{ 0x5e0a, 0x22236b },
	{ 0x5e0b, 0x23256b },
	{ 0x5e0c, 0x214a28 },
	{ 0x5e0d, 0x242423 },
	{ 0x5e0e, 0x22236c },
	{ 0x5e11, 0x214d30 },
	{ 0x5e12, 0x232862 },
	{ 0x5e13, 0x232861 },
	{ 0x5e14, 0x22264f },
	{ 0x5e15, 0x214d2e },
	{ 0x5e16, 0x214d2d },
	{ 0x5e17, 0x22264e },
	{ 0x5e18, 0x214d2b },
	{ 0x5e19, 0x222650 },
	{ 0x5e1a, 0x214d2c },
	{ 0x5e1b, 0x214d2f },
	{ 0x5e1d, 0x215074 },
	{ 0x5e1e, 0x232c46 },
	{ 0x5e1f, 0x215076 },
	{ 0x5e20, 0x222a34 },
	{ 0x5e21, 0x222a31 },
	{ 0x5e22, 0x222a32 },
	{ 0x5e23, 0x222a33 },
	{ 0x5e24, 0x222a35 },
	{ 0x5e25, 0x215075 },
	{ 0x5e28, 0x222e76 },
	{ 0x5e29, 0x222e75 },
	{ 0x5e2a, 0x233066 },
	{ 0x5e2b, 0x21553a },
	{ 0x5e2c, 0x233069 },
	{ 0x5e2d, 0x215539 },
	{ 0x5e2e, 0x233068 },
	{ 0x5e2f, 0x23306a },
	{ 0x5e30, 0x233067 },
	{ 0x5e32, 0x23355b },
	{ 0x5e33, 0x215a28 },
	{ 0x5e34, 0x22352a },
	{ 0x5e35, 0x233559 },
	{ 0x5e36, 0x215a27 },
	{ 0x5e37, 0x215a29 },
	{ 0x5e38, 0x215a26 },
	{ 0x5e39, 0x233558 },
	{ 0x5e3a, 0x23355a },
	{ 0x5e3d, 0x215e7a },
	{ 0x5e3e, 0x223529 },
	{ 0x5e3f, 0x25377c },
	{ 0x5e40, 0x215e7b },
	{ 0x5e41, 0x223b57 },
	{ 0x5e42, 0x233979 },
	{ 0x5e43, 0x215e7c },
	{ 0x5e44, 0x223b56 },
	{ 0x5e45, 0x215e79 },
	{ 0x5e46, 0x233b3a },
	{ 0x5e47, 0x233b3b },
	{ 0x5e48, 0x233b3d },
	{ 0x5e4a, 0x224260 },
	{ 0x5e4b, 0x224262 },
	{ 0x5e4c, 0x21636b },
	{ 0x5e4d, 0x224261 },
	{ 0x5e4e, 0x22425f },
	{ 0x5e4f, 0x22425e },
	{ 0x5e50, 0x243d2a },
	{ 0x5e51, 0x244335 },
	{ 0x5e52, 0x23465d },
	{ 0x5e53, 0x224979 },
	{ 0x5e54, 0x21685f },
	{ 0x5e55, 0x21685d },
	{ 0x5e56, 0x244330 },
	{ 0x5e57, 0x21685e },
	{ 0x5e58, 0x224977 },
	{ 0x5e59, 0x224978 },
	{ 0x5e5a, 0x234b6d },
	{ 0x5e5b, 0x21685b },
	{ 0x5e5c, 0x22503a },
	{ 0x5e5d, 0x225038 },
	{ 0x5e5e, 0x234b70 },
	{ 0x5e5f, 0x216c57 },
	{ 0x5e60, 0x225039 },
	{ 0x5e61, 0x216c58 },
	{ 0x5e62, 0x216c56 },
	{ 0x5e63, 0x21685c },
	{ 0x5e64, 0x2f4e5e },
	{ 0x5e65, 0x236473 },
	{ 0x5e66, 0x225677 },
	{ 0x5e67, 0x225675 },
	{ 0x5e68, 0x225676 },
	{ 0x5e69, 0x225037 },
	{ 0x5e6a, 0x225c68 },
	{ 0x5e6b, 0x217359 },
	{ 0x5e6c, 0x225c67 },
	{ 0x5e6d, 0x226151 },
	{ 0x5e6e, 0x226152 },
	{ 0x5e6f, 0x225678 },
	{ 0x5e70, 0x22654a },
	{ 0x5e71, 0x236677 },
	{ 0x5e72, 0x21445b },
	{ 0x5e73, 0x21464d },
	{ 0x5e74, 0x214821 },
	{ 0x5e75, 0x22223b },
	{ 0x5e76, 0x21477e },
	{ 0x5e77, 0x232863 },
	{ 0x5e78, 0x214d31 },
	{ 0x5e79, 0x21636c },
	{ 0x5e7a, 0x23213d },
	{ 0x5e7b, 0x21453c },
	{ 0x5e7c, 0x21464e },
	{ 0x5e7d, 0x215077 },
	{ 0x5e7e, 0x215e7d },
	{ 0x5e7f, 0x23213e },
	{ 0x5e80, 0x22215a },
	{ 0x5e81, 0x232247 },
	{ 0x5e82, 0x22215b },
	{ 0x5e83, 0x232248 },
	{ 0x5e84, 0x22223c },
	{ 0x5e85, 0x236678 },
	{ 0x5e87, 0x214a2a },
	{ 0x5e88, 0x222370 },
	{ 0x5e89, 0x22236e },
	{ 0x5e8a, 0x214a2b },
	{ 0x5e8b, 0x22236d },
	{ 0x5e8c, 0x22236f },
	{ 0x5e8d, 0x222371 },
	{ 0x5e8e, 0x242428 },
	{ 0x5e8f, 0x214a29 },
	{ 0x5e90, 0x23256e },
	{ 0x5e92, 0x23256d },
	{ 0x5e95, 0x214d35 },
	{ 0x5e96, 0x214d36 },
	{ 0x5e97, 0x214d33 },
	{ 0x5e98, 0x232865 },
	{ 0x5e99, 0x232867 },
	{ 0x5e9a, 0x214d32 },
	{ 0x5e9b, 0x222a39 },
	{ 0x5e9c, 0x214d34 },
	{ 0x5e9d, 0x232868 },
	{ 0x5ea0, 0x215078 },
	{ 0x5ea1, 0x232c48 },
	{ 0x5ea2, 0x222a38 },
	{ 0x5ea3, 0x222a3a },
	{ 0x5ea4, 0x222a37 },
	{ 0x5ea5, 0x222a3b },
	{ 0x5ea6, 0x215079 },
	{ 0x5ea7, 0x21553d },
	{ 0x5ea8, 0x222e77 },
	{ 0x5ea9, 0x23306c },
	{ 0x5eaa, 0x222e79 },
	{ 0x5eab, 0x21553b },
	{ 0x5eac, 0x222e7a },
	{ 0x5ead, 0x21553c },
	{ 0x5eae, 0x222e78 },
	{ 0x5eaf, 0x23306b },
	{ 0x5eb0, 0x222a36 },
	{ 0x5eb1, 0x22352b },
	{ 0x5eb2, 0x22352e },
	{ 0x5eb3, 0x22352f },
	{ 0x5eb4, 0x22352c },
	{ 0x5eb5, 0x215a2d },
	{ 0x5eb6, 0x215a2c },
	{ 0x5eb7, 0x215a2a },
	{ 0x5eb8, 0x215a2b },
	{ 0x5eb9, 0x22352d },
	{ 0x5eba, 0x233561 },
	{ 0x5ebb, 0x233560 },
	{ 0x5ebd, 0x233b3f },
	{ 0x5ebe, 0x215a2e },
	{ 0x5ebf, 0x233b40 },
	{ 0x5ec0, 0x233b3e },
	{ 0x5ec1, 0x215f21 },
	{ 0x5ec2, 0x215f22 },
	{ 0x5ec3, 0x264845 },
	{ 0x5ec4, 0x215f23 },
	{ 0x5ec5, 0x224263 },
	{ 0x5ec6, 0x224265 },
	{ 0x5ec7, 0x224267 },
	{ 0x5ec8, 0x21636e },
	{ 0x5ec9, 0x21636d },
	{ 0x5eca, 0x215e7e },
	{ 0x5ecb, 0x224266 },
	{ 0x5ecc, 0x224264 },
	{ 0x5ecd, 0x236474 },
	{ 0x5ece, 0x22497d },
	{ 0x5ecf, 0x234661 },
	{ 0x5ed0, 0x234660 },
	{ 0x5ed1, 0x22497b },
	{ 0x5ed2, 0x224a23 },
	{ 0x5ed3, 0x216860 },
	{ 0x5ed4, 0x224a24 },
	{ 0x5ed5, 0x224a21 },
	{ 0x5ed6, 0x216861 },
	{ 0x5ed7, 0x22497c },
	{ 0x5ed8, 0x22497a },
	{ 0x5ed9, 0x224a22 },
	{ 0x5eda, 0x216c5a },
	{ 0x5edb, 0x22503c },
	{ 0x5edc, 0x22497e },
	{ 0x5edd, 0x216c5c },
	{ 0x5ede, 0x22503d },
	{ 0x5edf, 0x216c5b },
	{ 0x5ee0, 0x216c5e },
	{ 0x5ee1, 0x22503e },
	{ 0x5ee2, 0x216c59 },
	{ 0x5ee3, 0x216c5d },
	{ 0x5ee5, 0x22567d },
	{ 0x5ee6, 0x22567b },
	{ 0x5ee7, 0x22567a },
	{ 0x5ee8, 0x22567c },
	{ 0x5ee9, 0x225679 },
	{ 0x5eea, 0x23505c },
	{ 0x5eeb, 0x245b21 },
	{ 0x5eec, 0x217833 },
	{ 0x5eed, 0x236475 },
	{ 0x5eee, 0x226872 },
	{ 0x5eef, 0x226873 },
	{ 0x5ef0, 0x235c3f },
	{ 0x5ef1, 0x226b59 },
	{ 0x5ef2, 0x226d4d },
	{ 0x5ef3, 0x217d22 },
	{ 0x5ef4, 0x23213f },
	{ 0x5ef5, 0x232361 },
	{ 0x5ef6, 0x214d37 },
	{ 0x5ef7, 0x214a2c },
	{ 0x5ef8, 0x232869 },
	{ 0x5ef9, 0x23286b },
	{ 0x5efa, 0x21507a },
	{ 0x5efb, 0x232c4c },
	{ 0x5efc, 0x232c4b },
	{ 0x5efd, 0x23306e },
	{ 0x5efe, 0x21445c },
	{ 0x5eff, 0x21453d },
	{ 0x5f00, 0x24214d },
	{ 0x5f01, 0x21464f },
	{ 0x5f02, 0x22223d },
	{ 0x5f03, 0x23256f },
	{ 0x5f04, 0x214a2d },
	{ 0x5f05, 0x222372 },
	{ 0x5f06, 0x23286d },
	{ 0x5f07, 0x222a3c },
	{ 0x5f08, 0x21507b },
	{ 0x5f0a, 0x216862 },
	{ 0x5f0b, 0x21445d },
	{ 0x5f0c, 0x232164 },
	{ 0x5f0d, 0x232249 },
	{ 0x5f0e, 0x232362 },
	{ 0x5f0f, 0x214822 },
	{ 0x5f10, 0x2f224e },
	{ 0x5f11, 0x233b42 },
	{ 0x5f12, 0x21636f },
	{ 0x5f13, 0x21445e },
	{ 0x5f14, 0x21453e },
	{ 0x5f15, 0x21453f },
	{ 0x5f17, 0x214651 },
	{ 0x5f18, 0x214650 },
	{ 0x5f19, 0x24226b },
	{ 0x5f1a, 0x22223e },
	{ 0x5f1b, 0x214823 },
	{ 0x5f1c, 0x24226c },
	{ 0x5f1d, 0x222373 },
	{ 0x5f1e, 0x232571 },
	{ 0x5f1f, 0x214a2e },
	{ 0x5f21, 0x23286e },
	{ 0x5f22, 0x222652 },
	{ 0x5f23, 0x222653 },
	{ 0x5f24, 0x222654 },
	{ 0x5f25, 0x232870 },
	{ 0x5f26, 0x214d38 },
	{ 0x5f27, 0x214d39 },
	{ 0x5f28, 0x222651 },
	{ 0x5f29, 0x214d3a },
	{ 0x5f2b, 0x24292c },
	{ 0x5f2c, 0x242c70 },
	{ 0x5f2d, 0x21507c },
	{ 0x5f2e, 0x222a3d },
	{ 0x5f2f, 0x232c4d },
	{ 0x5f30, 0x222e7c },
	{ 0x5f31, 0x21553e },
	{ 0x5f32, 0x23306f },
	{ 0x5f33, 0x222e7b },
	{ 0x5f34, 0x233562 },
	{ 0x5f35, 0x215a2f },
	{ 0x5f36, 0x223530 },
	{ 0x5f37, 0x215a30 },
	{ 0x5f38, 0x223531 },
	{ 0x5f39, 0x233563 },
	{ 0x5f3a, 0x233b47 },
	{ 0x5f3b, 0x233b45 },
	{ 0x5f3c, 0x215f24 },
	{ 0x5f3d, 0x243745 },
	{ 0x5f3e, 0x233b44 },
	{ 0x5f3f, 0x243d30 },
	{ 0x5f40, 0x224268 },
	{ 0x5f41, 0x2f413f },
	{ 0x5f42, 0x234122 },
	{ 0x5f43, 0x224a26 },
	{ 0x5f44, 0x224a25 },
	{ 0x5f46, 0x216863 },
	{ 0x5f47, 0x24495e },
	{ 0x5f48, 0x216c5f },
	{ 0x5f49, 0x22503f },
	{ 0x5f4a, 0x217053 },
	{ 0x5f4b, 0x22567e },
	{ 0x5f4c, 0x21735a },
	{ 0x5f4d, 0x235763 },
	{ 0x5f4e, 0x217b5f },
	{ 0x5f4f, 0x226f27 },
	{ 0x5f50, 0x232140 },
	{ 0x5f51, 0x232141 },
	{ 0x5f52, 0x23224a },
	{ 0x5f53, 0x232351 },
	{ 0x5f54, 0x222655 },
	{ 0x5f55, 0x232871 },
	{ 0x5f56, 0x222a3e },
	{ 0x5f57, 0x215a31 },
	{ 0x5f58, 0x223b58 },
	{ 0x5f59, 0x216370 },
	{ 0x5f5a, 0x234123 },
	{ 0x5f5b, 0x23505e },
	{ 0x5f5c, 0x2f5443 },
	{ 0x5f5d, 0x235764 },
	{ 0x5f5e, 0x217641 },
	{ 0x5f60, 0x236164 },
	{ 0x5f61, 0x232142 },
	{ 0x5f62, 0x214a30 },
	{ 0x5f63, 0x232572 },
	{ 0x5f64, 0x214a2f },
	{ 0x5f65, 0x21507d },
	{ 0x5f66, 0x232c50 },
	{ 0x5f67, 0x222e7d },
	{ 0x5f69, 0x215a33 },
	{ 0x5f6a, 0x215d29 },
	{ 0x5f6b, 0x215a34 },
	{ 0x5f6c, 0x215a32 },
	{ 0x5f6d, 0x215f25 },
	{ 0x5f6e, 0x234124 },
	{ 0x5f6f, 0x224a27 },
	{ 0x5f70, 0x216864 },
	{ 0x5f71, 0x216c60 },
	{ 0x5f72, 0x235f45 },
	{ 0x5f73, 0x22212c },
	{ 0x5f74, 0x22223f },
	{ 0x5f75, 0x24226d },
	{ 0x5f76, 0x222375 },
	{ 0x5f77, 0x214a31 },
	{ 0x5f78, 0x222374 },
	{ 0x5f79, 0x214a32 },
	{ 0x5f7a, 0x24242c },
	{ 0x5f7c, 0x214d3e },
	{ 0x5f7d, 0x222658 },
	{ 0x5f7e, 0x222657 },
	{ 0x5f7f, 0x214d3d },
	{ 0x5f80, 0x214d3b },
	{ 0x5f81, 0x214d3c },
	{ 0x5f82, 0x222656 },
	{ 0x5f83, 0x232876 },
	{ 0x5f84, 0x232875 },
	{ 0x5f85, 0x215121 },
	{ 0x5f86, 0x222a3f },
	{ 0x5f87, 0x215124 },
	{ 0x5f88, 0x21507e },
	{ 0x5f89, 0x215126 },
	{ 0x5f8a, 0x215122 },
	{ 0x5f8b, 0x215123 },
	{ 0x5f8c, 0x215125 },
	{ 0x5f8d, 0x242931 },
	{ 0x5f8e, 0x233070 },
	{ 0x5f8f, 0x233072 },
	{ 0x5f90, 0x215541 },
	{ 0x5f91, 0x215540 },
	{ 0x5f92, 0x21553f },
	{ 0x5f93, 0x233071 },
	{ 0x5f94, 0x236476 },
	{ 0x5f96, 0x223533 },
	{ 0x5f97, 0x215a35 },
	{ 0x5f98, 0x215a38 },
	{ 0x5f99, 0x215a36 },
	{ 0x5f9a, 0x236477 },
	{ 0x5f9b, 0x223532 },
	{ 0x5f9c, 0x215a3b },
	{ 0x5f9d, 0x243153 },
	{ 0x5f9e, 0x215a37 },
	{ 0x5f9f, 0x223534 },
	{ 0x5fa0, 0x215a3a },
	{ 0x5fa1, 0x215a39 },
	{ 0x5fa2, 0x243152 },
	{ 0x5fa3, 0x243157 },
	{ 0x5fa4, 0x24374a },
	{ 0x5fa5, 0x223b5a },
	{ 0x5fa6, 0x223b59 },
	{ 0x5fa7, 0x233b4b },
	{ 0x5fa8, 0x215f28 },
	{ 0x5fa9, 0x215f26 },
	{ 0x5faa, 0x215f27 },
	{ 0x5fab, 0x223b5b },
	{ 0x5fac, 0x216371 },
	{ 0x5fad, 0x22426a },
	{ 0x5fae, 0x216372 },
	{ 0x5faf, 0x224269 },
	{ 0x5fb0, 0x243d34 },
	{ 0x5fb1, 0x24433f },
	{ 0x5fb2, 0x225040 },
	{ 0x5fb3, 0x234663 },
	{ 0x5fb4, 0x234664 },
	{ 0x5fb5, 0x216c62 },
	{ 0x5fb6, 0x224a28 },
	{ 0x5fb7, 0x216c61 },
	{ 0x5fb8, 0x234b72 },
	{ 0x5fb9, 0x216865 },
	{ 0x5fba, 0x236478 },
	{ 0x5fbb, 0x225722 },
	{ 0x5fbc, 0x225721 },
	{ 0x5fbd, 0x21735b },
	{ 0x5fbe, 0x225c69 },
	{ 0x5fbf, 0x22654b },
	{ 0x5fc0, 0x226874 },
	{ 0x5fc1, 0x226875 },
	{ 0x5fc2, 0x235e2f },
	{ 0x5fc3, 0x214540 },
	{ 0x5fc4, 0x242136 },
	{ 0x5fc5, 0x214652 },
	{ 0x5fc7, 0x23224d },
	{ 0x5fc8, 0x242271 },
	{ 0x5fc9, 0x22215c },
	{ 0x5fca, 0x23224c },
	{ 0x5fcb, 0x252266 },
	{ 0x5fcc, 0x214a34 },
	{ 0x5fcd, 0x214a36 },
	{ 0x5fce, 0x232578 },
	{ 0x5fcf, 0x222242 },
	{ 0x5fd0, 0x222378 },
	{ 0x5fd1, 0x222377 },
	{ 0x5fd2, 0x222376 },
	{ 0x5fd3, 0x232366 },
	{ 0x5fd4, 0x222241 },
	{ 0x5fd5, 0x222240 },
	{ 0x5fd6, 0x214825 },
	{ 0x5fd7, 0x214a35 },
	{ 0x5fd8, 0x214a33 },
	{ 0x5fd9, 0x214824 },
	{ 0x5fda, 0x232367 },
	{ 0x5fdb, 0x232369 },
	{ 0x5fdc, 0x232577 },
	{ 0x5fdd, 0x214d3f },
	{ 0x5fde, 0x222659 },
	{ 0x5fdf, 0x23257b },
	{ 0x5fe0, 0x214d40 },
	{ 0x5fe1, 0x22237d },
	{ 0x5fe2, 0x242650 },
	{ 0x5fe3, 0x222421 },
	{ 0x5fe4, 0x22237e },
	{ 0x5fe5, 0x22265a },
	{ 0x5fe6, 0x232576 },
	{ 0x5fe7, 0x232574 },
	{ 0x5fe8, 0x22237a },
	{ 0x5fe9, 0x23287e },
	{ 0x5fea, 0x214a3a },
	{ 0x5feb, 0x214a38 },
	{ 0x5fec, 0x23257c },
	{ 0x5fed, 0x222379 },
	{ 0x5fee, 0x22237b },
	{ 0x5fef, 0x222423 },
	{ 0x5ff0, 0x232622 },
	{ 0x5ff1, 0x214a37 },
	{ 0x5ff2, 0x232621 },
	{ 0x5ff3, 0x22237c },
	{ 0x5ff4, 0x222427 },
	{ 0x5ff5, 0x214d42 },
	{ 0x5ff6, 0x23257d },
	{ 0x5ff7, 0x222424 },
	{ 0x5ff8, 0x214a39 },
	{ 0x5ff9, 0x232623 },
	{ 0x5ffa, 0x222422 },
	{ 0x5ffb, 0x222425 },
	{ 0x5ffc, 0x23257a },
	{ 0x5ffd, 0x214d41 },
	{ 0x5ffe, 0x232575 },
	{ 0x5fff, 0x214d43 },
	{ 0x6000, 0x222426 },
	{ 0x6007, 0x232878 },
	{ 0x6008, 0x232922 },
	{ 0x6009, 0x22266e },
	{ 0x600a, 0x222661 },
	{ 0x600b, 0x22265f },
	{ 0x600c, 0x22266d },
	{ 0x600d, 0x222668 },
	{ 0x600e, 0x21512b },
	{ 0x600f, 0x214d44 },
	{ 0x6010, 0x222669 },
	{ 0x6011, 0x22266c },
	{ 0x6012, 0x215127 },
	{ 0x6013, 0x22266b },
	{ 0x6014, 0x214d45 },
	{ 0x6015, 0x214d4a },
	{ 0x6016, 0x214d48 },
	{ 0x6017, 0x222662 },
	{ 0x6018, 0x242936 },
	{ 0x6019, 0x22265d },
	{ 0x601a, 0x222664 },
	{ 0x601b, 0x214d4f },
	{ 0x601c, 0x22266f },
	{ 0x601d, 0x215128 },
	{ 0x601e, 0x222665 },
	{ 0x601f, 0x24264f },
	{ 0x6020, 0x215129 },
	{ 0x6021, 0x214d4b },
	{ 0x6022, 0x222667 },
	{ 0x6023, 0x232c5a },
	{ 0x6024, 0x222a4e },
	{ 0x6025, 0x21512a },
	{ 0x6026, 0x22265c },
	{ 0x6027, 0x214d4c },
	{ 0x6028, 0x21512c },
	{ 0x6029, 0x214d4d },
	{ 0x602a, 0x214d49 },
	{ 0x602b, 0x214d4e },
	{ 0x602c, 0x222666 },
	{ 0x602d, 0x22265b },
	{ 0x602e, 0x22266a },
	{ 0x602f, 0x214d46 },
	{ 0x6030, 0x232877 },
	{ 0x6031, 0x232c5b },
	{ 0x6032, 0x22265e },
	{ 0x6033, 0x222663 },
	{ 0x6034, 0x222660 },
	{ 0x6035, 0x214d47 },
	{ 0x6036, 0x23287a },
	{ 0x6037, 0x222a40 },
	{ 0x6038, 0x242945 },
	{ 0x6039, 0x222a41 },
	{ 0x603d, 0x232921 },
	{ 0x6040, 0x222a4b },
	{ 0x6041, 0x222f23 },
	{ 0x6042, 0x222a4c },
	{ 0x6043, 0x215132 },
	{ 0x6044, 0x222a4f },
	{ 0x6045, 0x222a45 },
	{ 0x6046, 0x215131 },
	{ 0x6047, 0x222a47 },
	{ 0x6048, 0x24293f },
	{ 0x6049, 0x222a48 },
	{ 0x604a, 0x232c60 },
	{ 0x604b, 0x233079 },
	{ 0x604c, 0x222a4a },
	{ 0x604d, 0x21512d },
	{ 0x604e, 0x232c56 },
	{ 0x604f, 0x233073 },
	{ 0x6050, 0x215545 },
	{ 0x6051, 0x232c57 },
	{ 0x6052, 0x232c5d },
	{ 0x6053, 0x222a46 },
	{ 0x6054, 0x222a42 },
	{ 0x6055, 0x215546 },
	{ 0x6056, 0x23307e },
	{ 0x6057, 0x24293e },
	{ 0x6058, 0x222a50 },
	{ 0x6059, 0x215542 },
	{ 0x605a, 0x222f21 },
	{ 0x605b, 0x222a49 },
	{ 0x605c, 0x232c54 },
	{ 0x605d, 0x222e7e },
	{ 0x605e, 0x222a44 },
	{ 0x605f, 0x222a4d },
	{ 0x6060, 0x232c5f },
	{ 0x6061, 0x232c61 },
	{ 0x6062, 0x215130 },
	{ 0x6063, 0x215543 },
	{ 0x6064, 0x215136 },
	{ 0x6065, 0x215544 },
	{ 0x6066, 0x222a51 },
	{ 0x6067, 0x222f22 },
	{ 0x6068, 0x21512f },
	{ 0x6069, 0x215548 },
	{ 0x606a, 0x215135 },
	{ 0x606b, 0x215134 },
	{ 0x606c, 0x215133 },
	{ 0x606d, 0x215547 },
	{ 0x606e, 0x222a52 },
	{ 0x606f, 0x215549 },
	{ 0x6070, 0x21512e },
	{ 0x6071, 0x24294b },
	{ 0x6072, 0x222a43 },
	{ 0x6073, 0x23307a },
	{ 0x6074, 0x233078 },
	{ 0x6075, 0x23307b },
	{ 0x607c, 0x232c5c },
	{ 0x607e, 0x233076 },
	{ 0x607f, 0x215a3c },
	{ 0x6080, 0x222f26 },
	{ 0x6081, 0x222f28 },
	{ 0x6082, 0x242d25 },
	{ 0x6083, 0x222f2a },
	{ 0x6084, 0x21554a },
	{ 0x6085, 0x215550 },
	{ 0x6086, 0x223537 },
	{ 0x6087, 0x222f2e },
	{ 0x6088, 0x222f25 },
	{ 0x6089, 0x215a3e },
	{ 0x608a, 0x223535 },
	{ 0x608b, 0x233122 },
	{ 0x608c, 0x21554f },
	{ 0x608d, 0x21554d },
	{ 0x608e, 0x222f30 },
	{ 0x608f, 0x242d2d },
	{ 0x6090, 0x223536 },
	{ 0x6091, 0x242d2c },
	{ 0x6092, 0x222f27 },
	{ 0x6093, 0x233125 },
	{ 0x6094, 0x21554e },
	{ 0x6095, 0x222f2b },
	{ 0x6096, 0x215551 },
	{ 0x6097, 0x222f2d },
	{ 0x6098, 0x233568 },
	{ 0x6099, 0x233074 },
	{ 0x609a, 0x21554c },
	{ 0x609b, 0x222f2c },
	{ 0x609c, 0x222f2f },
	{ 0x609d, 0x222f29 },
	{ 0x609e, 0x233127 },
	{ 0x609f, 0x21554b },
	{ 0x60a0, 0x215a3f },
	{ 0x60a1, 0x233571 },
	{ 0x60a2, 0x222f24 },
	{ 0x60a3, 0x215a3d },
	{ 0x60a4, 0x233572 },
	{ 0x60a5, 0x24316b },
	{ 0x60a6, 0x233123 },
	{ 0x60a7, 0x233128 },
	{ 0x60a8, 0x215a40 },
	{ 0x60a9, 0x233121 },
	{ 0x60aa, 0x23356f },
	{ 0x60ae, 0x233126 },
	{ 0x60b0, 0x223539 },
	{ 0x60b1, 0x223542 },
	{ 0x60b2, 0x215f2b },
	{ 0x60b3, 0x233b54 },
	{ 0x60b4, 0x215a42 },
	{ 0x60b5, 0x215a47 },
	{ 0x60b6, 0x215f2c },
	{ 0x60b7, 0x223544 },
	{ 0x60b8, 0x215a4e },
	{ 0x60b9, 0x223b5d },
	{ 0x60ba, 0x22353a },
	{ 0x60bb, 0x215a46 },
	{ 0x60bc, 0x215a49 },
	{ 0x60bd, 0x215a44 },
	{ 0x60be, 0x223538 },
	{ 0x60bf, 0x223546 },
	{ 0x60c0, 0x223549 },
	{ 0x60c1, 0x223b6c },
	{ 0x60c2, 0x243168 },
	{ 0x60c3, 0x223547 },
	{ 0x60c4, 0x223b61 },
	{ 0x60c5, 0x215a45 },
	{ 0x60c6, 0x215a4c },
	{ 0x60c7, 0x215a50 },
	{ 0x60c8, 0x223541 },
	{ 0x60c9, 0x223b5c },
	{ 0x60ca, 0x223545 },
	{ 0x60cb, 0x215a41 },
	{ 0x60cc, 0x223b5e },
	{ 0x60cd, 0x223548 },
	{ 0x60ce, 0x223b60 },
	{ 0x60cf, 0x22353d },
	{ 0x60d0, 0x23356a },
	{ 0x60d1, 0x215f29 },
	{ 0x60d2, 0x233b56 },
	{ 0x60d3, 0x22353b },
	{ 0x60d4, 0x22353c },
	{ 0x60d5, 0x215a4b },
	{ 0x60d6, 0x233b55 },
	{ 0x60d7, 0x23356e },
	{ 0x60d8, 0x215a4a },
	{ 0x60d9, 0x22353f },
	{ 0x60da, 0x215a4f },
	{ 0x60db, 0x223543 },
	{ 0x60dc, 0x215a48 },
	{ 0x60dd, 0x223540 },
	{ 0x60de, 0x233579 },
	{ 0x60df, 0x215a4d },
	{ 0x60e0, 0x215f2d },
	{ 0x60e1, 0x215f2a },
	{ 0x60e2, 0x223b5f },
	{ 0x60e3, 0x233b58 },
	{ 0x60e4, 0x22353e },
	{ 0x60e5, 0x233b59 },
	{ 0x60e6, 0x215a43 },
	{ 0x60e7, 0x233576 },
	{ 0x60e8, 0x233578 },
	{ 0x60e9, 0x233b5a },
	{ 0x60ea, 0x233b4d },
	{ 0x60ee, 0x233574 },
	{ 0x60f0, 0x215f32 },
	{ 0x60f1, 0x215f36 },
	{ 0x60f2, 0x223b63 },
	{ 0x60f3, 0x216377 },
	{ 0x60f4, 0x215f34 },
	{ 0x60f5, 0x223b67 },
	{ 0x60f6, 0x215f38 },
	{ 0x60f7, 0x22426b },
	{ 0x60f8, 0x223b69 },
	{ 0x60f9, 0x216379 },
	{ 0x60fa, 0x215f30 },
	{ 0x60fb, 0x215f33 },
	{ 0x60fc, 0x223b6a },
	{ 0x60fd, 0x233b5e },
	{ 0x60fe, 0x223b6b },
	{ 0x60ff, 0x223b71 },
	{ 0x6100, 0x215f3a },
	{ 0x6101, 0x21637a },
	{ 0x6102, 0x243d3d },
	{ 0x6103, 0x223b6d },
	{ 0x6104, 0x223b72 },
	{ 0x6105, 0x223b66 },
	{ 0x6106, 0x216426 },
	{ 0x6107, 0x233b4f },
	{ 0x6108, 0x21637b },
	{ 0x6109, 0x215f39 },
	{ 0x610a, 0x223b64 },
	{ 0x610b, 0x223b73 },
	{ 0x610c, 0x233b51 },
	{ 0x610d, 0x216425 },
	{ 0x610e, 0x215f37 },
	{ 0x610f, 0x216374 },
	{ 0x6110, 0x223b70 },
	{ 0x6111, 0x233b5d },
	{ 0x6112, 0x215f3b },
	{ 0x6113, 0x223b68 },
	{ 0x6114, 0x223b62 },
	{ 0x6115, 0x215f31 },
	{ 0x6116, 0x223b65 },
	{ 0x6117, 0x253f30 },
	{ 0x6118, 0x223b6e },
	{ 0x6119, 0x23412b },
	{ 0x611a, 0x216373 },
	{ 0x611b, 0x216378 },
	{ 0x611c, 0x215f2e },
	{ 0x611d, 0x223b6f },
	{ 0x611e, 0x233b61 },
	{ 0x611f, 0x216376 },
	{ 0x6120, 0x233b62 },
	{ 0x6121, 0x233b63 },
	{ 0x6122, 0x233b50 },
	{ 0x6123, 0x215f2f },
	{ 0x6125, 0x236479 },
	{ 0x6127, 0x216424 },
	{ 0x6128, 0x224a2a },
	{ 0x6129, 0x224276 },
	{ 0x612a, 0x234129 },
	{ 0x612b, 0x22426e },
	{ 0x612c, 0x224a29 },
	{ 0x612d, 0x243d39 },
	{ 0x612e, 0x224272 },
	{ 0x612f, 0x224274 },
	{ 0x6130, 0x234127 },
	{ 0x6131, 0x23412c },
	{ 0x6132, 0x224271 },
	{ 0x6133, 0x23466f },
	{ 0x6134, 0x216423 },
	{ 0x6135, 0x243d38 },
	{ 0x6136, 0x224270 },
	{ 0x6137, 0x216427 },
	{ 0x6138, 0x23466e },
	{ 0x6139, 0x265264 },
	{ 0x613a, 0x234128 },
	{ 0x613b, 0x224a39 },
	{ 0x613c, 0x23466c },
	{ 0x613d, 0x23412e },
	{ 0x613e, 0x216422 },
	{ 0x613f, 0x216867 },
	{ 0x6140, 0x224277 },
	{ 0x6141, 0x224a2b },
	{ 0x6142, 0x23466d },
	{ 0x6143, 0x23412a },
	{ 0x6144, 0x21637e },
	{ 0x6145, 0x22426f },
	{ 0x6146, 0x224273 },
	{ 0x6147, 0x216866 },
	{ 0x6148, 0x216375 },
	{ 0x6149, 0x22426c },
	{ 0x614a, 0x22426d },
	{ 0x614b, 0x216868 },
	{ 0x614c, 0x21637d },
	{ 0x614d, 0x216421 },
	{ 0x614e, 0x21637c },
	{ 0x614f, 0x224275 },
	{ 0x6150, 0x23647a },
	{ 0x6152, 0x224a2f },
	{ 0x6153, 0x224a30 },
	{ 0x6154, 0x224a35 },
	{ 0x6155, 0x216c67 },
	{ 0x6156, 0x224a3c },
	{ 0x6157, 0x234b73 },
	{ 0x6158, 0x21686e },
	{ 0x6159, 0x234b7e },
	{ 0x615a, 0x21686d },
	{ 0x615b, 0x224a37 },
	{ 0x615c, 0x234b74 },
	{ 0x615d, 0x216c66 },
	{ 0x615e, 0x224a2c },
	{ 0x615f, 0x21686c },
	{ 0x6160, 0x234671 },
	{ 0x6161, 0x224a3b },
	{ 0x6162, 0x21686a },
	{ 0x6163, 0x21686b },
	{ 0x6164, 0x234b7c },
	{ 0x6165, 0x224a38 },
	{ 0x6166, 0x225051 },
	{ 0x6167, 0x216c64 },
	{ 0x6168, 0x215f35 },
	{ 0x6169, 0x234672 },
	{ 0x616a, 0x224a3a },
	{ 0x616b, 0x216c6b },
	{ 0x616c, 0x224a32 },
	{ 0x616d, 0x24496f },
	{ 0x616e, 0x216c65 },
	{ 0x616f, 0x23466a },
	{ 0x6170, 0x216c6a },
	{ 0x6171, 0x224a2d },
	{ 0x6172, 0x224a31 },
	{ 0x6173, 0x224a2e },
	{ 0x6174, 0x224a34 },
	{ 0x6175, 0x21686f },
	{ 0x6176, 0x216c63 },
	{ 0x6177, 0x216869 },
	{ 0x6178, 0x234c21 },
	{ 0x6179, 0x225043 },
	{ 0x617a, 0x224a36 },
	{ 0x617b, 0x234668 },
	{ 0x617c, 0x216c69 },
	{ 0x617d, 0x234673 },
	{ 0x617e, 0x216c6c },
	{ 0x617f, 0x272271 },
	{ 0x6180, 0x224a33 },
	{ 0x6181, 0x23466b },
	{ 0x6182, 0x216c68 },
	{ 0x6183, 0x225042 },
	{ 0x6184, 0x254d2a },
	{ 0x6185, 0x234c23 },
	{ 0x6186, 0x234674 },
	{ 0x6187, 0x234c24 },
	{ 0x6188, 0x234b77 },
	{ 0x6189, 0x225047 },
	{ 0x618a, 0x217057 },
	{ 0x618b, 0x225041 },
	{ 0x618c, 0x22572e },
	{ 0x618d, 0x225050 },
	{ 0x618e, 0x216c70 },
	{ 0x618f, 0x234b7a },
	{ 0x6190, 0x216c6e },
	{ 0x6191, 0x217055 },
	{ 0x6192, 0x22504d },
	{ 0x6193, 0x225049 },
	{ 0x6194, 0x216c74 },
	{ 0x6195, 0x234b76 },
	{ 0x6196, 0x225725 },
	{ 0x6197, 0x235068 },
	{ 0x6198, 0x234c28 },
	{ 0x6199, 0x235067 },
	{ 0x619a, 0x216c72 },
	{ 0x619b, 0x225048 },
	{ 0x619c, 0x234c29 },
	{ 0x619d, 0x225723 },
	{ 0x619e, 0x234c25 },
	{ 0x619f, 0x22504c },
	{ 0x61a0, 0x24503b },
	{ 0x61a1, 0x22504f },
	{ 0x61a2, 0x225046 },
	{ 0x61a3, 0x234b79 },
	{ 0x61a4, 0x216c73 },
	{ 0x61a5, 0x245037 },
	{ 0x61a6, 0x234b75 },
	{ 0x61a7, 0x216c6d },
	{ 0x61a8, 0x225724 },
	{ 0x61a9, 0x217056 },
	{ 0x61aa, 0x22504e },
	{ 0x61ab, 0x216c6f },
	{ 0x61ac, 0x216c71 },
	{ 0x61ad, 0x22504b },
	{ 0x61ae, 0x216c75 },
	{ 0x61af, 0x22504a },
	{ 0x61b0, 0x225045 },
	{ 0x61b1, 0x225044 },
	{ 0x61b2, 0x217054 },
	{ 0x61b3, 0x225052 },
	{ 0x61b4, 0x225727 },
	{ 0x61b5, 0x225c6b },
	{ 0x61b6, 0x217059 },
	{ 0x61b7, 0x235061 },
	{ 0x61b8, 0x22572d },
	{ 0x61b9, 0x235063 },
	{ 0x61ba, 0x22572b },
	{ 0x61bb, 0x23506a },
	{ 0x61bc, 0x225c6c },
	{ 0x61bd, 0x235064 },
	{ 0x61be, 0x21705a },
	{ 0x61bf, 0x22572c },
	{ 0x61c0, 0x235066 },
	{ 0x61c1, 0x225729 },
	{ 0x61c2, 0x21735d },
	{ 0x61c3, 0x225c6a },
	{ 0x61c4, 0x23506c },
	{ 0x61c5, 0x225726 },
	{ 0x61c6, 0x225728 },
	{ 0x61c7, 0x21735e },
	{ 0x61c8, 0x21705c },
	{ 0x61c9, 0x21735c },
	{ 0x61ca, 0x21705b },
	{ 0x61cb, 0x217360 },
	{ 0x61cc, 0x22572a },
	{ 0x61cd, 0x217058 },
	{ 0x61ce, 0x235062 },
	{ 0x61cf, 0x235065 },
	{ 0x61d0, 0x23506b },
	{ 0x61d3, 0x236679 },
	{ 0x61d5, 0x245b2b },
	{ 0x61d6, 0x22615b },
	{ 0x61d7, 0x245633 },
	{ 0x61d8, 0x226153 },
	{ 0x61d9, 0x235461 },
	{ 0x61da, 0x23545f },
	{ 0x61db, 0x23545c },
	{ 0x61dc, 0x23545e },
	{ 0x61dd, 0x23545d },
	{ 0x61de, 0x225c72 },
	{ 0x61df, 0x226154 },
	{ 0x61e0, 0x225c6e },
	{ 0x61e1, 0x245632 },
	{ 0x61e2, 0x23545b },
	{ 0x61e3, 0x217642 },
	{ 0x61e4, 0x225c70 },
	{ 0x61e5, 0x225c6f },
	{ 0x61e6, 0x21735f },
	{ 0x61e7, 0x225c6d },
	{ 0x61e8, 0x225c71 },
	{ 0x61e9, 0x22615c },
	{ 0x61ea, 0x226158 },
	{ 0x61eb, 0x22615a },
	{ 0x61ec, 0x245f60 },
	{ 0x61ed, 0x226155 },
	{ 0x61ee, 0x226156 },
	{ 0x61ef, 0x245f61 },
	{ 0x61f0, 0x226159 },
	{ 0x61f1, 0x226157 },
	{ 0x61f2, 0x217834 },
	{ 0x61f3, 0x235765 },
	{ 0x61f5, 0x217837 },
	{ 0x61f6, 0x217836 },
	{ 0x61f7, 0x217835 },
	{ 0x61f8, 0x21796c },
	{ 0x61f9, 0x226876 },
	{ 0x61fa, 0x21796d },
	{ 0x61fb, 0x22654c },
	{ 0x61fc, 0x217a6a },
	{ 0x61fd, 0x226b5a },
	{ 0x61fe, 0x217a6b },
	{ 0x61ff, 0x217b60 },
	{ 0x6200, 0x217c36 },
	{ 0x6201, 0x226f28 },
	{ 0x6202, 0x235f46 },
	{ 0x6203, 0x226f29 },
	{ 0x6204, 0x226f2a },
	{ 0x6205, 0x23613e },
	{ 0x6207, 0x22722a },
	{ 0x6208, 0x214541 },
	{ 0x6209, 0x22215d },
	{ 0x620a, 0x214653 },
	{ 0x620c, 0x214827 },
	{ 0x620d, 0x214828 },
	{ 0x620e, 0x214826 },
	{ 0x620f, 0x23236b },
	{ 0x6210, 0x214829 },
	{ 0x6211, 0x214a3c },
	{ 0x6212, 0x214a3b },
	{ 0x6213, 0x232625 },
	{ 0x6214, 0x222670 },
	{ 0x6215, 0x214d51 },
	{ 0x6216, 0x214d50 },
	{ 0x6218, 0x232c63 },
	{ 0x6219, 0x222f31 },
	{ 0x621a, 0x215a51 },
	{ 0x621b, 0x215a52 },
	{ 0x621c, 0x24316e },
	{ 0x621d, 0x243170 },
	{ 0x621e, 0x233b64 },
	{ 0x621f, 0x215f3c },
	{ 0x6220, 0x224278 },
	{ 0x6221, 0x216428 },
	{ 0x6222, 0x216429 },
	{ 0x6223, 0x22427a },
	{ 0x6224, 0x22427c },
	{ 0x6225, 0x22427b },
	{ 0x6226, 0x243d43 },
	{ 0x6227, 0x224a3e },
	{ 0x6228, 0x234676 },
	{ 0x6229, 0x224a3d },
	{ 0x622a, 0x216870 },
	{ 0x622b, 0x224a3f },
	{ 0x622c, 0x234675 },
	{ 0x622d, 0x225053 },
	{ 0x622e, 0x216c76 },
	{ 0x622f, 0x234c2c },
	{ 0x6230, 0x21705d },
	{ 0x6231, 0x23506d },
	{ 0x6232, 0x217361 },
	{ 0x6233, 0x217643 },
	{ 0x6234, 0x217362 },
	{ 0x6235, 0x235f48 },
	{ 0x6236, 0x214542 },
	{ 0x6237, 0x232165 },
	{ 0x6238, 0x232166 },
	{ 0x6239, 0x23224e },
	{ 0x623a, 0x222428 },
	{ 0x623b, 0x232628 },
	{ 0x623c, 0x232629 },
	{ 0x623d, 0x222671 },
	{ 0x623e, 0x214d53 },
	{ 0x623f, 0x214d52 },
	{ 0x6240, 0x214d54 },
	{ 0x6241, 0x215137 },
	{ 0x6242, 0x222a53 },
	{ 0x6243, 0x222a54 },
	{ 0x6245, 0x233129 },
	{ 0x6246, 0x222f32 },
	{ 0x6247, 0x215552 },
	{ 0x6248, 0x215a53 },
	{ 0x6249, 0x215f3d },
	{ 0x624a, 0x223b74 },
	{ 0x624b, 0x214543 },
	{ 0x624c, 0x242137 },
	{ 0x624d, 0x21445f },
	{ 0x624e, 0x214544 },
	{ 0x624f, 0x232250 },
	{ 0x6250, 0x22215e },
	{ 0x6251, 0x214657 },
	{ 0x6252, 0x214656 },
	{ 0x6253, 0x214654 },
	{ 0x6254, 0x214655 },
	{ 0x6257, 0x23236f },
	{ 0x6258, 0x21482c },
	{ 0x6259, 0x222249 },
	{ 0x625a, 0x22224b },
	{ 0x625b, 0x21482b },
	{ 0x625c, 0x222243 },
	{ 0x625d, 0x23236c },
	{ 0x625e, 0x222244 },
	{ 0x625f, 0x23236d },
	{ 0x6260, 0x22224a },
	{ 0x6261, 0x222246 },
	{ 0x6262, 0x222248 },
	{ 0x6263, 0x21482a },
	{ 0x6264, 0x222245 },
	{ 0x6265, 0x22224c },
	{ 0x6266, 0x222247 },
	{ 0x6267, 0x23236e },
	{ 0x6268, 0x2f2251 },
	{ 0x626d, 0x214a43 },
	{ 0x626e, 0x214a4c },
	{ 0x626f, 0x214a4a },
	{ 0x6270, 0x222432 },
	{ 0x6271, 0x22242f },
	{ 0x6272, 0x222437 },
	{ 0x6273, 0x214a48 },
	{ 0x6274, 0x222438 },
	{ 0x6275, 0x232639 },
	{ 0x6276, 0x214a41 },
	{ 0x6277, 0x222435 },
	{ 0x6278, 0x23262e },
	{ 0x6279, 0x214a47 },
	{ 0x627a, 0x222431 },
	{ 0x627b, 0x222430 },
	{ 0x627c, 0x214a45 },
	{ 0x627d, 0x222436 },
	{ 0x627e, 0x214a46 },
	{ 0x627f, 0x214d55 },
	{ 0x6280, 0x214a40 },
	{ 0x6281, 0x222433 },
	{ 0x6282, 0x23262a },
	{ 0x6283, 0x222429 },
	{ 0x6284, 0x214a3d },
	{ 0x6285, 0x232637 },
	{ 0x6286, 0x214a50 },
	{ 0x6287, 0x22242e },
	{ 0x6288, 0x222434 },
	{ 0x6289, 0x214a42 },
	{ 0x628a, 0x214a44 },
	{ 0x628b, 0x23262f },
	{ 0x628c, 0x22242a },
	{ 0x628d, 0x232636 },
	{ 0x628e, 0x22242b },
	{ 0x628f, 0x22242c },
	{ 0x6290, 0x242439 },
	{ 0x6291, 0x214a4f },
	{ 0x6292, 0x214a49 },
	{ 0x6293, 0x214a4e },
	{ 0x6294, 0x22242d },
	{ 0x6295, 0x214a4d },
	{ 0x6296, 0x214a3f },
	{ 0x6297, 0x214a3e },
	{ 0x6298, 0x214a4b },
	{ 0x6299, 0x232635 },
	{ 0x629a, 0x24243c },
	{ 0x629b, 0x232633 },
	{ 0x629c, 0x232634 },
	{ 0x629d, 0x232638 },
	{ 0x629e, 0x232631 },
	{ 0x62a3, 0x23647b },
	{ 0x62a4, 0x2f2439 },
	{ 0x62a5, 0x232632 },
	{ 0x62a6, 0x232931 },
	{ 0x62a7, 0x23292a },
	{ 0x62a8, 0x214d63 },
	{ 0x62a9, 0x22267d },
	{ 0x62aa, 0x222676 },
	{ 0x62ab, 0x214d5e },
	{ 0x62ac, 0x214d71 },
	{ 0x62ad, 0x222672 },
	{ 0x62ae, 0x222679 },
	{ 0x62af, 0x22267b },
	{ 0x62b0, 0x22267e },
	{ 0x62b1, 0x214d6c },
	{ 0x62b2, 0x232926 },
	{ 0x62b3, 0x22267a },
	{ 0x62b4, 0x222673 },
	{ 0x62b5, 0x214d6a },
	{ 0x62b6, 0x222677 },
	{ 0x62b7, 0x232928 },
	{ 0x62b8, 0x222721 },
	{ 0x62b9, 0x214d5b },
	{ 0x62ba, 0x232925 },
	{ 0x62bb, 0x22267c },
	{ 0x62bc, 0x214d65 },
	{ 0x62bd, 0x214d64 },
	{ 0x62be, 0x222675 },
	{ 0x62bf, 0x214d59 },
	{ 0x62c0, 0x232934 },
	{ 0x62c1, 0x232932 },
	{ 0x62c2, 0x214d5a },
	{ 0x62c3, 0x2f2730 },
	{ 0x62c4, 0x214d58 },
	{ 0x62c5, 0x232933 },
	{ 0x62c6, 0x214d70 },
	{ 0x62c7, 0x214d68 },
	{ 0x62c8, 0x214d62 },
	{ 0x62c9, 0x214d56 },
	{ 0x62ca, 0x222678 },
	{ 0x62cb, 0x214d61 },
	{ 0x62cc, 0x214d57 },
	{ 0x62cd, 0x214d69 },
	{ 0x62ce, 0x214d72 },
	{ 0x62cf, 0x222a55 },
	{ 0x62d0, 0x214d66 },
	{ 0x62d1, 0x222674 },
	{ 0x62d2, 0x214d5c },
	{ 0x62d3, 0x214d5f },
	{ 0x62d4, 0x214d60 },
	{ 0x62d5, 0x23292e },
	{ 0x62d6, 0x214d6e },
	{ 0x62d7, 0x214d6f },
	{ 0x62d8, 0x214d6d },
	{ 0x62d9, 0x214d67 },
	{ 0x62da, 0x214d6b },
	{ 0x62db, 0x214d5d },
	{ 0x62dc, 0x215138 },
	{ 0x62dd, 0x232930 },
	{ 0x62de, 0x232937 },
	{ 0x62df, 0x232935 },
	{ 0x62e0, 0x232936 },
	{ 0x62e1, 0x23292f },
	{ 0x62e4, 0x232929 },
	{ 0x62ea, 0x232c6d },
	{ 0x62eb, 0x222a5b },
	{ 0x62ec, 0x215144 },
	{ 0x62ed, 0x21513c },
	{ 0x62ee, 0x21513e },
	{ 0x62ef, 0x215143 },
	{ 0x62f0, 0x222a67 },
	{ 0x62f1, 0x215141 },
	{ 0x62f2, 0x222f33 },
	{ 0x62f3, 0x215553 },
	{ 0x62f4, 0x215146 },
	{ 0x62f5, 0x222a58 },
	{ 0x62f6, 0x222a60 },
	{ 0x62f7, 0x215142 },
	{ 0x62f8, 0x222a5f },
	{ 0x62f9, 0x222a5c },
	{ 0x62fa, 0x222a64 },
	{ 0x62fb, 0x222a66 },
	{ 0x62fc, 0x21513b },
	{ 0x62fd, 0x21513f },
	{ 0x62fe, 0x215145 },
	{ 0x62ff, 0x215555 },
	{ 0x6300, 0x222a61 },
	{ 0x6301, 0x21513d },
	{ 0x6302, 0x215148 },
	{ 0x6303, 0x222a5a },
	{ 0x6304, 0x232c6f },
	{ 0x6305, 0x232c70 },
	{ 0x6306, 0x252945 },
	{ 0x6307, 0x215140 },
	{ 0x6308, 0x215554 },
	{ 0x6309, 0x21513a },
	{ 0x630a, 0x242959 },
	{ 0x630b, 0x222a57 },
	{ 0x630c, 0x222a5e },
	{ 0x630d, 0x222a56 },
	{ 0x630e, 0x222a59 },
	{ 0x630f, 0x222a5d },
	{ 0x6310, 0x222f34 },
	{ 0x6311, 0x215147 },
	{ 0x6312, 0x242951 },
	{ 0x6313, 0x222a62 },
	{ 0x6314, 0x222a63 },
	{ 0x6315, 0x222a65 },
	{ 0x6316, 0x215139 },
	{ 0x6317, 0x232c6c },
	{ 0x6319, 0x233132 },
	{ 0x631b, 0x233133 },
	{ 0x631f, 0x232c6b },
	{ 0x6321, 0x232c6e },
	{ 0x6323, 0x24295b },
	{ 0x6328, 0x215563 },
	{ 0x6329, 0x222f40 },
	{ 0x632a, 0x215561 },
	{ 0x632b, 0x215562 },
	{ 0x632c, 0x222f36 },
	{ 0x632d, 0x222f46 },
	{ 0x632e, 0x23312c },
	{ 0x632f, 0x215558 },
	{ 0x6330, 0x23312f },
	{ 0x6331, 0x233135 },
	{ 0x6332, 0x22354a },
	{ 0x6333, 0x222f48 },
	{ 0x6334, 0x222f42 },
	{ 0x6335, 0x233138 },
	{ 0x6336, 0x222f39 },
	{ 0x6337, 0x233137 },
	{ 0x6338, 0x222f4b },
	{ 0x6339, 0x222f3c },
	{ 0x633a, 0x21555e },
	{ 0x633b, 0x223561 },
	{ 0x633c, 0x222f3f },
	{ 0x633d, 0x215560 },
	{ 0x633e, 0x215557 },
	{ 0x633f, 0x23313c },
	{ 0x6340, 0x222f4d },
	{ 0x6341, 0x222f41 },
	{ 0x6342, 0x21555a },
	{ 0x6343, 0x222f3a },
	{ 0x6344, 0x222f37 },
	{ 0x6345, 0x222f38 },
	{ 0x6346, 0x21555b },
	{ 0x6347, 0x222f47 },
	{ 0x6348, 0x222f4e },
	{ 0x6349, 0x21555d },
	{ 0x634a, 0x222f3e },
	{ 0x634b, 0x222f3d },
	{ 0x634c, 0x215565 },
	{ 0x634d, 0x215564 },
	{ 0x634e, 0x215556 },
	{ 0x634f, 0x21555c },
	{ 0x6350, 0x21555f },
	{ 0x6351, 0x222f4a },
	{ 0x6352, 0x23312e },
	{ 0x6353, 0x233139 },
	{ 0x6354, 0x222f44 },
	{ 0x6355, 0x215559 },
	{ 0x6356, 0x222f35 },
	{ 0x6357, 0x222f4c },
	{ 0x6358, 0x222f43 },
	{ 0x6359, 0x222f45 },
	{ 0x635a, 0x222f49 },
	{ 0x635b, 0x233130 },
	{ 0x635c, 0x23313b },
	{ 0x635d, 0x233136 },
	{ 0x6360, 0x23647c },
	{ 0x6364, 0x23647d },
	{ 0x6365, 0x22354b },
	{ 0x6366, 0x233631 },
	{ 0x6367, 0x215a5b },
	{ 0x6368, 0x215a6f },
	{ 0x6369, 0x215a6e },
	{ 0x636a, 0x233627 },
	{ 0x636b, 0x215a63 },
	{ 0x636c, 0x233629 },
	{ 0x636d, 0x22355d },
	{ 0x636e, 0x223559 },
	{ 0x636f, 0x223556 },
	{ 0x6370, 0x223568 },
	{ 0x6371, 0x215a5e },
	{ 0x6372, 0x215a56 },
	{ 0x6373, 0x233626 },
	{ 0x6374, 0x233632 },
	{ 0x6375, 0x22355b },
	{ 0x6376, 0x215f4d },
	{ 0x6377, 0x215a5a },
	{ 0x6378, 0x223563 },
	{ 0x6379, 0x233622 },
	{ 0x637a, 0x215a70 },
	{ 0x637b, 0x215a6d },
	{ 0x637c, 0x22355f },
	{ 0x637d, 0x22354e },
	{ 0x637e, 0x23357c },
	{ 0x637f, 0x23362b },
	{ 0x6380, 0x215a6c },
	{ 0x6381, 0x223565 },
	{ 0x6382, 0x22354d },
	{ 0x6383, 0x215a61 },
	{ 0x6384, 0x215a65 },
	{ 0x6385, 0x223564 },
	{ 0x6386, 0x233623 },
	{ 0x6387, 0x223557 },
	{ 0x6388, 0x215a66 },
	{ 0x6389, 0x215a60 },
	{ 0x638a, 0x22354c },
	{ 0x638b, 0x23357d },
	{ 0x638c, 0x215f3f },
	{ 0x638d, 0x223567 },
	{ 0x638e, 0x223555 },
	{ 0x638f, 0x215a6b },
	{ 0x6390, 0x223558 },
	{ 0x6391, 0x223566 },
	{ 0x6392, 0x215a6a },
	{ 0x6393, 0x233624 },
	{ 0x6394, 0x223b75 },
	{ 0x6395, 0x243177 },
	{ 0x6396, 0x215a57 },
	{ 0x6397, 0x223553 },
	{ 0x6398, 0x215a5c },
	{ 0x6399, 0x215a67 },
	{ 0x639a, 0x243178 },
	{ 0x639b, 0x215a62 },
	{ 0x639c, 0x22355c },
	{ 0x639d, 0x223552 },
	{ 0x639e, 0x223550 },
	{ 0x639f, 0x223562 },
	{ 0x63a0, 0x215a54 },
	{ 0x63a1, 0x215a68 },
	{ 0x63a2, 0x215a58 },
	{ 0x63a3, 0x215f3e },
	{ 0x63a4, 0x223560 },
	{ 0x63a5, 0x215a59 },
	{ 0x63a6, 0x243223 },
	{ 0x63a7, 0x215a55 },
	{ 0x63a8, 0x215a64 },
	{ 0x63a9, 0x215a5f },
	{ 0x63aa, 0x215a5d },
	{ 0x63ab, 0x223554 },
	{ 0x63ac, 0x215a69 },
	{ 0x63ad, 0x223551 },
	{ 0x63ae, 0x22355e },
	{ 0x63af, 0x22355a },
	{ 0x63b0, 0x223b77 },
	{ 0x63b1, 0x223b76 },
	{ 0x63b2, 0x23362d },
	{ 0x63b6, 0x23647e },
	{ 0x63ba, 0x23362e },
	{ 0x63bd, 0x22354f },
	{ 0x63be, 0x223c29 },
	{ 0x63bf, 0x233b71 },
	{ 0x63c0, 0x215f41 },
	{ 0x63c1, 0x233b70 },
	{ 0x63c2, 0x223c2f },
	{ 0x63c3, 0x223b7c },
	{ 0x63c4, 0x223c2c },
	{ 0x63c5, 0x22427d },
	{ 0x63c6, 0x215f44 },
	{ 0x63c7, 0x223c30 },
	{ 0x63c8, 0x223c33 },
	{ 0x63c9, 0x215f43 },
	{ 0x63ca, 0x223c21 },
	{ 0x63cb, 0x223c32 },
	{ 0x63cc, 0x223c31 },
	{ 0x63cd, 0x215f45 },
	{ 0x63ce, 0x223b78 },
	{ 0x63cf, 0x215f40 },
	{ 0x63d0, 0x215f48 },
	{ 0x63d1, 0x233b73 },
	{ 0x63d2, 0x215f46 },
	{ 0x63d3, 0x223c2e },
	{ 0x63d4, 0x243771 },
	{ 0x63d5, 0x223c24 },
	{ 0x63d6, 0x215f4a },
	{ 0x63d7, 0x223c35 },
	{ 0x63d8, 0x223c2d },
	{ 0x63d9, 0x223c36 },
	{ 0x63da, 0x215f52 },
	{ 0x63db, 0x215f50 },
	{ 0x63dc, 0x223c2b },
	{ 0x63dd, 0x223c2a },
	{ 0x63de, 0x233b67 },
	{ 0x63df, 0x223c28 },
	{ 0x63e0, 0x223c22 },
	{ 0x63e1, 0x215f49 },
	{ 0x63e2, 0x233b66 },
	{ 0x63e3, 0x215f47 },
	{ 0x63e4, 0x222f3b },
	{ 0x63e5, 0x223b79 },
	{ 0x63e6, 0x233b68 },
	{ 0x63e7, 0x22433d },
	{ 0x63e8, 0x223b7a },
	{ 0x63e9, 0x215f42 },
	{ 0x63ea, 0x215f4f },
	{ 0x63eb, 0x224321 },
	{ 0x63ec, 0x243760 },
	{ 0x63ed, 0x215f4b },
	{ 0x63ee, 0x215f4c },
	{ 0x63ef, 0x223b7b },
	{ 0x63f0, 0x223c34 },
	{ 0x63f1, 0x22427e },
	{ 0x63f2, 0x223c25 },
	{ 0x63f3, 0x223b7e },
	{ 0x63f4, 0x215f4e },
	{ 0x63f5, 0x223c26 },
	{ 0x63f6, 0x223c23 },
	{ 0x63f7, 0x233b72 },
	{ 0x63f8, 0x233b6d },
	{ 0x63f9, 0x215f53 },
	{ 0x63fa, 0x24376f },
	{ 0x63fe, 0x233b6f },
	{ 0x6403, 0x236521 },
	{ 0x6406, 0x216438 },
	{ 0x6407, 0x234149 },
	{ 0x6408, 0x234132 },
	{ 0x6409, 0x224324 },
	{ 0x640a, 0x224337 },
	{ 0x640b, 0x22433c },
	{ 0x640c, 0x224330 },
	{ 0x640d, 0x216434 },
	{ 0x640e, 0x224341 },
	{ 0x640f, 0x216431 },
	{ 0x6410, 0x224322 },
	{ 0x6411, 0x23413a },
	{ 0x6412, 0x224323 },
	{ 0x6413, 0x21642a },
	{ 0x6414, 0x216433 },
	{ 0x6415, 0x22432a },
	{ 0x6416, 0x216436 },
	{ 0x6417, 0x216437 },
	{ 0x6418, 0x22432b },
	{ 0x6419, 0x234138 },
	{ 0x641a, 0x224338 },
	{ 0x641b, 0x22433e },
	{ 0x641c, 0x216432 },
	{ 0x641d, 0x23413e },
	{ 0x641e, 0x21642c },
	{ 0x641f, 0x224329 },
	{ 0x6420, 0x224325 },
	{ 0x6421, 0x224340 },
	{ 0x6422, 0x22432e },
	{ 0x6423, 0x22432f },
	{ 0x6424, 0x224326 },
	{ 0x6425, 0x22433a },
	{ 0x6426, 0x224331 },
	{ 0x6427, 0x22433b },
	{ 0x6428, 0x224333 },
	{ 0x6429, 0x23413d },
	{ 0x642a, 0x21642d },
	{ 0x642b, 0x224a40 },
	{ 0x642c, 0x216430 },
	{ 0x642d, 0x21642e },
	{ 0x642e, 0x22433f },
	{ 0x642f, 0x224336 },
	{ 0x6430, 0x224332 },
	{ 0x6431, 0x234136 },
	{ 0x6432, 0x234133 },
	{ 0x6433, 0x224327 },
	{ 0x6434, 0x21687a },
	{ 0x6435, 0x224335 },
	{ 0x6436, 0x216435 },
	{ 0x6437, 0x22432d },
	{ 0x6438, 0x234134 },
	{ 0x6439, 0x22432c },
	{ 0x643a, 0x234148 },
	{ 0x643b, 0x234725 },
	{ 0x643c, 0x234142 },
	{ 0x643d, 0x21642f },
	{ 0x643e, 0x21642b },
	{ 0x643f, 0x224a55 },
	{ 0x6440, 0x224339 },
	{ 0x6441, 0x224334 },
	{ 0x6443, 0x224328 },
	{ 0x6446, 0x234144 },
	{ 0x6447, 0x234145 },
	{ 0x6449, 0x236676 },
	{ 0x644b, 0x224a50 },
	{ 0x644c, 0x234678 },
	{ 0x644d, 0x224a41 },
	{ 0x644e, 0x224a4c },
	{ 0x644f, 0x234728 },
	{ 0x6450, 0x224a53 },
	{ 0x6451, 0x216878 },
	{ 0x6452, 0x215f51 },
	{ 0x6453, 0x224a51 },
	{ 0x6454, 0x216873 },
	{ 0x6455, 0x23467e },
	{ 0x6456, 0x234724 },
	{ 0x6457, 0x23467a },
	{ 0x6458, 0x216872 },
	{ 0x6459, 0x224a58 },
	{ 0x645a, 0x24435d },
	{ 0x645b, 0x224a42 },
	{ 0x645c, 0x224a4f },
	{ 0x645d, 0x224a43 },
	{ 0x645e, 0x224a4e },
	{ 0x645f, 0x216876 },
	{ 0x6460, 0x224a52 },
	{ 0x6461, 0x223c27 },
	{ 0x6462, 0x234721 },
	{ 0x6463, 0x24435e },
	{ 0x6464, 0x23472a },
	{ 0x6465, 0x224a59 },
	{ 0x6466, 0x224a4a },
	{ 0x6467, 0x216879 },
	{ 0x6468, 0x225061 },
	{ 0x6469, 0x216c77 },
	{ 0x646a, 0x234723 },
	{ 0x646b, 0x224a57 },
	{ 0x646c, 0x224a56 },
	{ 0x646d, 0x21687b },
	{ 0x646e, 0x225054 },
	{ 0x646f, 0x216c78 },
	{ 0x6470, 0x225055 },
	{ 0x6471, 0x234722 },
	{ 0x6472, 0x224a46 },
	{ 0x6473, 0x224a47 },
	{ 0x6474, 0x224a44 },
	{ 0x6475, 0x224a49 },
	{ 0x6476, 0x224a45 },
	{ 0x6477, 0x224a5a },
	{ 0x6478, 0x216875 },
	{ 0x6479, 0x216c79 },
	{ 0x647a, 0x216877 },
	{ 0x647b, 0x21687c },
	{ 0x647c, 0x23467b },
	{ 0x647d, 0x224a48 },
	{ 0x647e, 0x234729 },
	{ 0x647f, 0x224a54 },
	{ 0x6480, 0x234c2d },
	{ 0x6481, 0x234726 },
	{ 0x6482, 0x224a4d },
	{ 0x6483, 0x234c35 },
	{ 0x6485, 0x225058 },
	{ 0x6486, 0x234c38 },
	{ 0x6487, 0x216871 },
	{ 0x6488, 0x216c7c },
	{ 0x6489, 0x225735 },
	{ 0x648a, 0x22505d },
	{ 0x648b, 0x22505c },
	{ 0x648c, 0x22505e },
	{ 0x648d, 0x234c30 },
	{ 0x648e, 0x234c2f },
	{ 0x648f, 0x22505b },
	{ 0x6490, 0x216c7d },
	{ 0x6491, 0x234c3b },
	{ 0x6492, 0x216d25 },
	{ 0x6493, 0x216d22 },
	{ 0x6494, 0x234c31 },
	{ 0x6495, 0x216d23 },
	{ 0x6496, 0x225056 },
	{ 0x6497, 0x225059 },
	{ 0x6498, 0x225063 },
	{ 0x6499, 0x216d2b },
	{ 0x649a, 0x216d29 },
	{ 0x649b, 0x234c2e },
	{ 0x649c, 0x22505a },
	{ 0x649d, 0x223b7d },
	{ 0x649e, 0x216c7a },
	{ 0x649f, 0x225060 },
	{ 0x64a0, 0x225057 },
	{ 0x64a1, 0x234c3e },
	{ 0x64a2, 0x216d2c },
	{ 0x64a3, 0x22505f },
	{ 0x64a4, 0x216874 },
	{ 0x64a5, 0x216d21 },
	{ 0x64a6, 0x224a4b },
	{ 0x64a7, 0x234c3f },
	{ 0x64a8, 0x234c34 },
	{ 0x64a9, 0x216d24 },
	{ 0x64aa, 0x234c3d },
	{ 0x64ab, 0x216d28 },
	{ 0x64ac, 0x216d2a },
	{ 0x64ad, 0x216d27 },
	{ 0x64ae, 0x216d26 },
	{ 0x64af, 0x234c3a },
	{ 0x64b0, 0x216c7e },
	{ 0x64b1, 0x225062 },
	{ 0x64b2, 0x216c7b },
	{ 0x64b3, 0x216d2d },
	{ 0x64b4, 0x234c39 },
	{ 0x64b6, 0x236522 },
	{ 0x64b9, 0x234c37 },
	{ 0x64bb, 0x217061 },
	{ 0x64bc, 0x217062 },
	{ 0x64bd, 0x225734 },
	{ 0x64be, 0x21706b },
	{ 0x64bf, 0x217068 },
	{ 0x64c0, 0x235070 },
	{ 0x64c1, 0x21705f },
	{ 0x64c2, 0x217066 },
	{ 0x64c3, 0x225736 },
	{ 0x64c4, 0x217064 },
	{ 0x64c5, 0x21705e },
	{ 0x64c6, 0x234c32 },
	{ 0x64c7, 0x217065 },
	{ 0x64c8, 0x235077 },
	{ 0x64c9, 0x225733 },
	{ 0x64ca, 0x217364 },
	{ 0x64cb, 0x217060 },
	{ 0x64cc, 0x25545e },
	{ 0x64cd, 0x217067 },
	{ 0x64ce, 0x217363 },
	{ 0x64cf, 0x225732 },
	{ 0x64d0, 0x225731 },
	{ 0x64d1, 0x235076 },
	{ 0x64d2, 0x217069 },
	{ 0x64d3, 0x23506f },
	{ 0x64d4, 0x21706a },
	{ 0x64d5, 0x235079 },
	{ 0x64d6, 0x225730 },
	{ 0x64d7, 0x22572f },
	{ 0x64d8, 0x217365 },
	{ 0x64d9, 0x225739 },
	{ 0x64da, 0x217063 },
	{ 0x64db, 0x225737 },
	{ 0x64dc, 0x235075 },
	{ 0x64df, 0x235464 },
	{ 0x64e0, 0x217366 },
	{ 0x64e1, 0x235467 },
	{ 0x64e2, 0x21736b },
	{ 0x64e3, 0x225c75 },
	{ 0x64e4, 0x225c77 },
	{ 0x64e5, 0x23576b },
	{ 0x64e6, 0x217368 },
	{ 0x64e7, 0x23576d },
	{ 0x64e8, 0x225c78 },
	{ 0x64e9, 0x225c74 },
	{ 0x64ea, 0x23576c },
	{ 0x64eb, 0x225c76 },
	{ 0x64ec, 0x217369 },
	{ 0x64ed, 0x21736c },
	{ 0x64ee, 0x235469 },
	{ 0x64ef, 0x225c73 },
	{ 0x64f0, 0x217367 },
	{ 0x64f1, 0x21736a },
	{ 0x64f2, 0x217645 },
	{ 0x64f3, 0x225738 },
	{ 0x64f4, 0x217644 },
	{ 0x64f5, 0x273f62 },
	{ 0x64f6, 0x23576a },
	{ 0x64f7, 0x21764a },
	{ 0x64f8, 0x226160 },
	{ 0x64f9, 0x235770 },
	{ 0x64fa, 0x217648 },
	{ 0x64fb, 0x217649 },
	{ 0x64fc, 0x226163 },
	{ 0x64fd, 0x22615f },
	{ 0x64fe, 0x217646 },
	{ 0x64ff, 0x22615d },
	{ 0x6500, 0x217838 },
	{ 0x6501, 0x226161 },
	{ 0x6502, 0x245b36 },
	{ 0x6503, 0x226162 },
	{ 0x6504, 0x22615e },
	{ 0x6505, 0x23576e },
	{ 0x6506, 0x217647 },
	{ 0x6507, 0x22654d },
	{ 0x6508, 0x235a3b },
	{ 0x6509, 0x226550 },
	{ 0x650a, 0x235a3c },
	{ 0x650b, 0x235a3a },
	{ 0x650c, 0x226551 },
	{ 0x650d, 0x22654f },
	{ 0x650e, 0x226552 },
	{ 0x650f, 0x217839 },
	{ 0x6510, 0x22654e },
	{ 0x6511, 0x235e31 },
	{ 0x6513, 0x22687a },
	{ 0x6514, 0x21796f },
	{ 0x6515, 0x226879 },
	{ 0x6516, 0x226878 },
	{ 0x6517, 0x226877 },
	{ 0x6518, 0x21796e },
	{ 0x6519, 0x217970 },
	{ 0x651a, 0x236523 },
	{ 0x651b, 0x226b5b },
	{ 0x651c, 0x217a6d },
	{ 0x651d, 0x217a6c },
	{ 0x651e, 0x235f4a },
	{ 0x651f, 0x235f4b },
	{ 0x6520, 0x226d4f },
	{ 0x6521, 0x226d4e },
	{ 0x6522, 0x226d51 },
	{ 0x6523, 0x217c37 },
	{ 0x6524, 0x217b61 },
	{ 0x6525, 0x226f2c },
	{ 0x6526, 0x226d50 },
	{ 0x6527, 0x235f49 },
	{ 0x6528, 0x236032 },
	{ 0x6529, 0x226f2b },
	{ 0x652a, 0x217c39 },
	{ 0x652b, 0x217c38 },
	{ 0x652c, 0x217c5f },
	{ 0x652d, 0x227037 },
	{ 0x652e, 0x22707d },
	{ 0x652f, 0x214545 },
	{ 0x6530, 0x26236c },
	{ 0x6531, 0x232c72 },
	{ 0x6532, 0x223c37 },
	{ 0x6533, 0x22573a },
	{ 0x6534, 0x232167 },
	{ 0x6535, 0x232168 },
	{ 0x6536, 0x21482d },
	{ 0x6537, 0x22224d },
	{ 0x6538, 0x214a53 },
	{ 0x6539, 0x214a51 },
	{ 0x653a, 0x24243f },
	{ 0x653b, 0x214a52 },
	{ 0x653c, 0x24243e },
	{ 0x653d, 0x222722 },
	{ 0x653e, 0x214d73 },
	{ 0x653f, 0x215149 },
	{ 0x6540, 0x232c74 },
	{ 0x6541, 0x222a68 },
	{ 0x6542, 0x232c76 },
	{ 0x6543, 0x222a69 },
	{ 0x6544, 0x232c73 },
	{ 0x6545, 0x21514a },
	{ 0x6546, 0x222f50 },
	{ 0x6547, 0x242d43 },
	{ 0x6548, 0x215566 },
	{ 0x6549, 0x215567 },
	{ 0x654a, 0x222f4f },
	{ 0x654b, 0x23313d },
	{ 0x654c, 0x242d44 },
	{ 0x654d, 0x233637 },
	{ 0x654e, 0x233636 },
	{ 0x654f, 0x215a77 },
	{ 0x6550, 0x24322b },
	{ 0x6551, 0x215a73 },
	{ 0x6552, 0x24322f },
	{ 0x6553, 0x223569 },
	{ 0x6554, 0x215a7a },
	{ 0x6555, 0x215a79 },
	{ 0x6556, 0x215a72 },
	{ 0x6557, 0x215a75 },
	{ 0x6558, 0x215a78 },
	{ 0x6559, 0x215a74 },
	{ 0x655a, 0x233634 },
	{ 0x655c, 0x223c3b },
	{ 0x655d, 0x215a71 },
	{ 0x655e, 0x215f54 },
	{ 0x655f, 0x233b74 },
	{ 0x6560, 0x233b75 },
	{ 0x6561, 0x233b76 },
	{ 0x6562, 0x215f56 },
	{ 0x6563, 0x215f57 },
	{ 0x6564, 0x223c3a },
	{ 0x6565, 0x223c3d },
	{ 0x6566, 0x215f55 },
	{ 0x6567, 0x223c38 },
	{ 0x6568, 0x223c3c },
	{ 0x656a, 0x223c39 },
	{ 0x656b, 0x23414b },
	{ 0x656c, 0x216439 },
	{ 0x656d, 0x23414e },
	{ 0x656e, 0x243d5d },
	{ 0x656f, 0x224342 },
	{ 0x6570, 0x23414d },
	{ 0x6571, 0x234730 },
	{ 0x6572, 0x21687d },
	{ 0x6573, 0x224a5b },
	{ 0x6574, 0x21706c },
	{ 0x6575, 0x216d2e },
	{ 0x6576, 0x225064 },
	{ 0x6577, 0x216d2f },
	{ 0x6578, 0x216d30 },
	{ 0x6579, 0x225066 },
	{ 0x657a, 0x225065 },
	{ 0x657b, 0x225067 },
	{ 0x657c, 0x22573c },
	{ 0x657f, 0x22573b },
	{ 0x6580, 0x225c7a },
	{ 0x6581, 0x225c79 },
	{ 0x6582, 0x21736d },
	{ 0x6583, 0x21736e },
	{ 0x6584, 0x226553 },
	{ 0x6585, 0x235c41 },
	{ 0x6587, 0x214546 },
	{ 0x6588, 0x232558 },
	{ 0x6589, 0x232939 },
	{ 0x658a, 0x242d47 },
	{ 0x658b, 0x233140 },
	{ 0x658c, 0x223c3e },
	{ 0x658d, 0x233638 },
	{ 0x658e, 0x233639 },
	{ 0x6590, 0x215f59 },
	{ 0x6591, 0x215f58 },
	{ 0x6592, 0x224343 },
	{ 0x6594, 0x226164 },
	{ 0x6595, 0x217a6e },
	{ 0x6596, 0x226f2d },
	{ 0x6597, 0x214547 },
	{ 0x6598, 0x242441 },
	{ 0x6599, 0x215568 },
	{ 0x659a, 0x233142 },
	{ 0x659b, 0x215a7c },
	{ 0x659c, 0x215a7b },
	{ 0x659d, 0x223c3f },
	{ 0x659e, 0x223c40 },
	{ 0x659f, 0x21643a },
	{ 0x65a0, 0x224a5c },
	{ 0x65a1, 0x21687e },
	{ 0x65a2, 0x22573d },
	{ 0x65a3, 0x24563f },
	{ 0x65a4, 0x214548 },
	{ 0x65a5, 0x214658 },
	{ 0x65a6, 0x23293b },
	{ 0x65a7, 0x214d74 },
	{ 0x65a8, 0x222723 },
	{ 0x65aa, 0x222a6a },
	{ 0x65ab, 0x21514b },
	{ 0x65ac, 0x215a7d },
	{ 0x65ad, 0x23363a },
	{ 0x65ae, 0x223c41 },
	{ 0x65af, 0x215f5a },
	{ 0x65b0, 0x21643b },
	{ 0x65b1, 0x243d63 },
	{ 0x65b2, 0x225068 },
	{ 0x65b3, 0x225069 },
	{ 0x65b4, 0x24504e },
	{ 0x65b5, 0x23546b },
	{ 0x65b6, 0x225c7b },
	{ 0x65b7, 0x21764b },
	{ 0x65b8, 0x22707e },
	{ 0x65b9, 0x214549 },
	{ 0x65ba, 0x23293c },
	{ 0x65bb, 0x222724 },
	{ 0x65bc, 0x214d75 },
	{ 0x65bd, 0x21514c },
	{ 0x65be, 0x232c77 },
	{ 0x65bf, 0x222a6b },
	{ 0x65c1, 0x215569 },
	{ 0x65c2, 0x222f54 },
	{ 0x65c3, 0x222f52 },
	{ 0x65c4, 0x222f53 },
	{ 0x65c5, 0x21556a },
	{ 0x65c6, 0x222f51 },
	{ 0x65c7, 0x23363c },
	{ 0x65c8, 0x243234 },
	{ 0x65c9, 0x23363f },
	{ 0x65ca, 0x23363d },
	{ 0x65cb, 0x215b21 },
	{ 0x65cc, 0x215b22 },
	{ 0x65cd, 0x22356a },
	{ 0x65ce, 0x215b23 },
	{ 0x65cf, 0x215a7e },
	{ 0x65d0, 0x223c42 },
	{ 0x65d1, 0x233b79 },
	{ 0x65d2, 0x223c43 },
	{ 0x65d3, 0x224344 },
	{ 0x65d4, 0x243d64 },
	{ 0x65d6, 0x216922 },
	{ 0x65d7, 0x216921 },
	{ 0x65d8, 0x24504f },
	{ 0x65d9, 0x2f5464 },
	{ 0x65da, 0x225c7c },
	{ 0x65db, 0x226165 },
	{ 0x65dc, 0x235a3f },
	{ 0x65dd, 0x226555 },
	{ 0x65de, 0x226554 },
	{ 0x65df, 0x22687b },
	{ 0x65e0, 0x232169 },
	{ 0x65e1, 0x22213e },
	{ 0x65e2, 0x21514d },
	{ 0x65e3, 0x233641 },
	{ 0x65e4, 0x234150 },
	{ 0x65e5, 0x21454a },
	{ 0x65e6, 0x214659 },
	{ 0x65e7, 0x232251 },
	{ 0x65e8, 0x21482f },
	{ 0x65e9, 0x21482e },
	{ 0x65ea, 0x232373 },
	{ 0x65eb, 0x232372 },
	{ 0x65ec, 0x214830 },
	{ 0x65ed, 0x214831 },
	{ 0x65ee, 0x22224f },
	{ 0x65ef, 0x22224e },
	{ 0x65f0, 0x222439 },
	{ 0x65f1, 0x214a54 },
	{ 0x65f2, 0x22243c },
	{ 0x65f3, 0x22243b },
	{ 0x65f4, 0x22243a },
	{ 0x65f5, 0x22243d },
	{ 0x65f6, 0x23263d },
	{ 0x65f9, 0x242662 },
	{ 0x65fa, 0x214d76 },
	{ 0x65fb, 0x22272a },
	{ 0x65fc, 0x222726 },
	{ 0x65fd, 0x22272f },
	{ 0x65fe, 0x232943 },
	{ 0x65ff, 0x23293e },
	{ 0x6600, 0x214d7d },
	{ 0x6601, 0x232942 },
	{ 0x6602, 0x214d7b },
	{ 0x6603, 0x22272b },
	{ 0x6604, 0x222727 },
	{ 0x6605, 0x22272e },
	{ 0x6606, 0x214d7a },
	{ 0x6607, 0x214e23 },
	{ 0x6608, 0x222729 },
	{ 0x6609, 0x222725 },
	{ 0x660a, 0x214e22 },
	{ 0x660b, 0x22272c },
	{ 0x660c, 0x214d79 },
	{ 0x660d, 0x22272d },
	{ 0x660e, 0x214d7c },
	{ 0x660f, 0x214d7e },
	{ 0x6610, 0x222731 },
	{ 0x6611, 0x222730 },
	{ 0x6612, 0x222728 },
	{ 0x6613, 0x214d78 },
	{ 0x6614, 0x214d77 },
	{ 0x6615, 0x214e21 },
	{ 0x6616, 0x242661 },
	{ 0x6617, 0x232940 },
	{ 0x6618, 0x232941 },
	{ 0x6619, 0x2f273e },
	{ 0x661a, 0x232c7e },
	{ 0x661b, 0x232c7a },
	{ 0x661c, 0x222a70 },
	{ 0x661d, 0x222a76 },
	{ 0x661e, 0x232d23 },
	{ 0x661f, 0x215153 },
	{ 0x6620, 0x215150 },
	{ 0x6621, 0x222a6d },
	{ 0x6622, 0x222a72 },
	{ 0x6623, 0x232c7c },
	{ 0x6624, 0x215156 },
	{ 0x6625, 0x21514e },
	{ 0x6626, 0x222a71 },
	{ 0x6627, 0x215151 },
	{ 0x6628, 0x215154 },
	{ 0x6629, 0x232c79 },
	{ 0x662a, 0x242967 },
	{ 0x662b, 0x222a74 },
	{ 0x662c, 0x232c7d },
	{ 0x662d, 0x21514f },
	{ 0x662e, 0x222a79 },
	{ 0x662f, 0x215152 },
	{ 0x6630, 0x232d21 },
	{ 0x6631, 0x215155 },
	{ 0x6632, 0x222a6e },
	{ 0x6633, 0x222a73 },
	{ 0x6634, 0x222a77 },
	{ 0x6635, 0x222a6f },
	{ 0x6636, 0x222a6c },
	{ 0x6637, 0x232d24 },
	{ 0x6638, 0x232d25 },
	{ 0x6639, 0x222a78 },
	{ 0x663a, 0x222a75 },
	{ 0x663b, 0x232d22 },
	{ 0x663c, 0x232c37 },
	{ 0x6640, 0x233146 },
	{ 0x6641, 0x215572 },
	{ 0x6642, 0x21556b },
	{ 0x6643, 0x21556e },
	{ 0x6644, 0x23314c },
	{ 0x6645, 0x215571 },
	{ 0x6646, 0x233144 },
	{ 0x6647, 0x222f57 },
	{ 0x6648, 0x233149 },
	{ 0x6649, 0x21556c },
	{ 0x664a, 0x222f55 },
	{ 0x664b, 0x233148 },
	{ 0x664c, 0x215570 },
	{ 0x664d, 0x23314d },
	{ 0x664e, 0x233145 },
	{ 0x664f, 0x21556d },
	{ 0x6650, 0x233143 },
	{ 0x6651, 0x222f58 },
	{ 0x6652, 0x21556f },
	{ 0x6657, 0x233642 },
	{ 0x6658, 0x243239 },
	{ 0x6659, 0x22356e },
	{ 0x665a, 0x215b25 },
	{ 0x665b, 0x22356d },
	{ 0x665c, 0x22356f },
	{ 0x665d, 0x215b24 },
	{ 0x665e, 0x215b29 },
	{ 0x665f, 0x222f56 },
	{ 0x6660, 0x23314b },
	{ 0x6661, 0x22356c },
	{ 0x6662, 0x223570 },
	{ 0x6663, 0x233644 },
	{ 0x6664, 0x215b26 },
	{ 0x6665, 0x22356b },
	{ 0x6666, 0x215b28 },
	{ 0x6667, 0x233645 },
	{ 0x6668, 0x215b27 },
	{ 0x6669, 0x233c26 },
	{ 0x666a, 0x223c4a },
	{ 0x666b, 0x233b7d },
	{ 0x666c, 0x223c45 },
	{ 0x666d, 0x233c25 },
	{ 0x666e, 0x215f5b },
	{ 0x666f, 0x215f5f },
	{ 0x6670, 0x215f5c },
	{ 0x6671, 0x223c48 },
	{ 0x6672, 0x223c4b },
	{ 0x6673, 0x233c23 },
	{ 0x6674, 0x215f5d },
	{ 0x6675, 0x243824 },
	{ 0x6676, 0x215f5e },
	{ 0x6677, 0x215f63 },
	{ 0x6678, 0x22434d },
	{ 0x6679, 0x223c49 },
	{ 0x667a, 0x215f61 },
	{ 0x667b, 0x223c46 },
	{ 0x667c, 0x223c44 },
	{ 0x667d, 0x233b7c },
	{ 0x667e, 0x215f62 },
	{ 0x667f, 0x233b7e },
	{ 0x6680, 0x223c47 },
	{ 0x6681, 0x233c24 },
	{ 0x6684, 0x216441 },
	{ 0x6685, 0x243d69 },
	{ 0x6686, 0x224345 },
	{ 0x6687, 0x21643e },
	{ 0x6688, 0x21643f },
	{ 0x6689, 0x21643d },
	{ 0x668a, 0x22434a },
	{ 0x668b, 0x224349 },
	{ 0x668c, 0x224346 },
	{ 0x668d, 0x216443 },
	{ 0x668e, 0x23415b },
	{ 0x668f, 0x234156 },
	{ 0x6690, 0x224348 },
	{ 0x6691, 0x215f60 },
	{ 0x6692, 0x234159 },
	{ 0x6693, 0x234151 },
	{ 0x6694, 0x22434c },
	{ 0x6695, 0x224347 },
	{ 0x6696, 0x216440 },
	{ 0x6697, 0x21643c },
	{ 0x6698, 0x216442 },
	{ 0x6699, 0x22434b },
	{ 0x669a, 0x234734 },
	{ 0x669b, 0x24436b },
	{ 0x669c, 0x234735 },
	{ 0x669d, 0x216925 },
	{ 0x669e, 0x24436f },
	{ 0x669f, 0x224a5f },
	{ 0x66a0, 0x224a5e },
	{ 0x66a1, 0x224a5d },
	{ 0x66a2, 0x216923 },
	{ 0x66a3, 0x24436d },
	{ 0x66a4, 0x234739 },
	{ 0x66a5, 0x234733 },
	{ 0x66a6, 0x234737 },
	{ 0x66a8, 0x216924 },
	{ 0x66a9, 0x22506c },
	{ 0x66aa, 0x22506f },
	{ 0x66ab, 0x216d32 },
	{ 0x66ac, 0x234c44 },
	{ 0x66ad, 0x234c46 },
	{ 0x66ae, 0x216d31 },
	{ 0x66af, 0x225070 },
	{ 0x66b0, 0x22506b },
	{ 0x66b1, 0x216d34 },
	{ 0x66b2, 0x22506d },
	{ 0x66b3, 0x234c41 },
	{ 0x66b4, 0x216d33 },
	{ 0x66b5, 0x22506a },
	{ 0x66b6, 0x234c40 },
	{ 0x66b7, 0x22506e },
	{ 0x66b8, 0x217072 },
	{ 0x66b9, 0x21706f },
	{ 0x66ba, 0x225746 },
	{ 0x66bb, 0x225745 },
	{ 0x66bc, 0x234c43 },
	{ 0x66bd, 0x225744 },
	{ 0x66be, 0x22573f },
	{ 0x66bf, 0x23507d },
	{ 0x66c0, 0x225740 },
	{ 0x66c1, 0x235123 },
	{ 0x66c2, 0x245050 },
	{ 0x66c3, 0x23507a },
	{ 0x66c4, 0x217070 },
	{ 0x66c5, 0x23507e },
	{ 0x66c6, 0x21706d },
	{ 0x66c7, 0x217071 },
	{ 0x66c8, 0x22573e },
	{ 0x66c9, 0x21706e },
	{ 0x66ca, 0x225741 },
	{ 0x66cb, 0x225742 },
	{ 0x66cc, 0x225747 },
	{ 0x66cd, 0x235122 },
	{ 0x66ce, 0x235471 },
	{ 0x66cf, 0x225743 },
	{ 0x66d0, 0x23546f },
	{ 0x66d1, 0x235470 },
	{ 0x66d2, 0x225c7d },
	{ 0x66d3, 0x245641 },
	{ 0x66d4, 0x23546c },
	{ 0x66d5, 0x23546d },
	{ 0x66d6, 0x217370 },
	{ 0x66d7, 0x235472 },
	{ 0x66d8, 0x226168 },
	{ 0x66d9, 0x21736f },
	{ 0x66da, 0x226166 },
	{ 0x66db, 0x226167 },
	{ 0x66dc, 0x21764c },
	{ 0x66dd, 0x21783b },
	{ 0x66de, 0x226556 },
	{ 0x66df, 0x235a43 },
	{ 0x66e0, 0x21783a },
	{ 0x66e1, 0x235a42 },
	{ 0x66e2, 0x236526 },
	{ 0x66e3, 0x22687d },
	{ 0x66e4, 0x22687e },
	{ 0x66e5, 0x235c42 },
	{ 0x66e6, 0x217971 },
	{ 0x66e7, 0x235c43 },
	{ 0x66e8, 0x22687c },
	{ 0x66e9, 0x217a6f },
	{ 0x66ea, 0x246a4c },
	{ 0x66eb, 0x226f2e },
	{ 0x66ec, 0x217c3a },
	{ 0x66ed, 0x227038 },
	{ 0x66ee, 0x227039 },
	{ 0x66ef, 0x23613f },
	{ 0x66f0, 0x21454b },
	{ 0x66f1, 0x24217c },
	{ 0x66f2, 0x214832 },
	{ 0x66f3, 0x214833 },
	{ 0x66f4, 0x214a55 },
	{ 0x66f5, 0x232641 },
	{ 0x66f6, 0x222732 },
	{ 0x66f7, 0x215157 },
	{ 0x66f8, 0x215573 },
	{ 0x66f9, 0x215b2a },
	{ 0x66fa, 0x2f3273 },
	{ 0x66fc, 0x215937 },
	{ 0x66fe, 0x215f64 },
	{ 0x66ff, 0x215f65 },
	{ 0x6700, 0x215e32 },
	{ 0x6701, 0x223c4c },
	{ 0x6702, 0x236527 },
	{ 0x6703, 0x216444 },
	{ 0x6704, 0x224a61 },
	{ 0x6705, 0x224a60 },
	{ 0x6706, 0x235124 },
	{ 0x6707, 0x275347 },
	{ 0x6708, 0x21454c },
	{ 0x6709, 0x214834 },
	{ 0x670a, 0x222733 },
	{ 0x670b, 0x214e25 },
	{ 0x670c, 0x232945 },
	{ 0x670d, 0x214e24 },
	{ 0x670e, 0x232d27 },
	{ 0x670f, 0x222a7a },
	{ 0x6710, 0x222a7b },
	{ 0x6711, 0x236632 },
	{ 0x6712, 0x222f59 },
	{ 0x6713, 0x222f5a },
	{ 0x6714, 0x215574 },
	{ 0x6715, 0x215575 },
	{ 0x6716, 0x233648 },
	{ 0x6717, 0x215576 },
	{ 0x6718, 0x223571 },
	{ 0x6719, 0x233647 },
	{ 0x671a, 0x233646 },
	{ 0x671b, 0x215b2c },
	{ 0x671c, 0x243829 },
	{ 0x671d, 0x215f67 },
	{ 0x671e, 0x233c29 },
	{ 0x671f, 0x215f66 },
	{ 0x6720, 0x22434e },
	{ 0x6721, 0x224641 },
	{ 0x6722, 0x224a62 },
	{ 0x6723, 0x225748 },
	{ 0x6724, 0x235126 },
	{ 0x6725, 0x236633 },
	{ 0x6726, 0x21764d },
	{ 0x6727, 0x217972 },
	{ 0x6728, 0x21454d },
	{ 0x672a, 0x21465c },
	{ 0x672b, 0x21465d },
	{ 0x672c, 0x21465b },
	{ 0x672d, 0x21465e },
	{ 0x672e, 0x21465a },
	{ 0x672f, 0x232252 },
	{ 0x6731, 0x214837 },
	{ 0x6732, 0x232377 },
	{ 0x6733, 0x222257 },
	{ 0x6734, 0x214836 },
	{ 0x6735, 0x214838 },
	{ 0x6736, 0x232378 },
	{ 0x6737, 0x232375 },
	{ 0x6738, 0x222252 },
	{ 0x6739, 0x222251 },
	{ 0x673a, 0x222254 },
	{ 0x673b, 0x222253 },
	{ 0x673c, 0x222256 },
	{ 0x673d, 0x214835 },
	{ 0x673e, 0x222250 },
	{ 0x673f, 0x222255 },
	{ 0x6740, 0x2f2258 },
	{ 0x6742, 0x2f2257 },
	{ 0x6744, 0x232648 },
	{ 0x6745, 0x22243e },
	{ 0x6746, 0x214a5f },
	{ 0x6747, 0x22243f },
	{ 0x6748, 0x222443 },
	{ 0x6749, 0x214a5e },
	{ 0x674a, 0x232649 },
	{ 0x674b, 0x222447 },
	{ 0x674c, 0x222442 },
	{ 0x674d, 0x222445 },
	{ 0x674e, 0x214a57 },
	{ 0x674f, 0x214a58 },
	{ 0x6750, 0x214a59 },
	{ 0x6751, 0x214a5a },
	{ 0x6752, 0x232645 },
	{ 0x6753, 0x214a61 },
	{ 0x6754, 0x232644 },
	{ 0x6755, 0x222441 },
	{ 0x6756, 0x214a5c },
	{ 0x6757, 0x214a62 },
	{ 0x6758, 0x232647 },
	{ 0x6759, 0x222440 },
	{ 0x675a, 0x222446 },
	{ 0x675b, 0x232642 },
	{ 0x675c, 0x214a5b },
	{ 0x675d, 0x222444 },
	{ 0x675e, 0x214a5d },
	{ 0x675f, 0x214a56 },
	{ 0x6760, 0x214a60 },
	{ 0x6761, 0x23264a },
	{ 0x6762, 0x2f2422 },
	{ 0x6765, 0x242446 },
	{ 0x6766, 0x2f2453 },
	{ 0x676a, 0x214e3a },
	{ 0x676b, 0x232947 },
	{ 0x676c, 0x222735 },
	{ 0x676d, 0x214e26 },
	{ 0x676e, 0x242669 },
	{ 0x676f, 0x214e30 },
	{ 0x6770, 0x214e31 },
	{ 0x6771, 0x214e29 },
	{ 0x6772, 0x214e3b },
	{ 0x6773, 0x214e2b },
	{ 0x6774, 0x22273d },
	{ 0x6775, 0x214e36 },
	{ 0x6776, 0x222738 },
	{ 0x6777, 0x214e2c },
	{ 0x6778, 0x222747 },
	{ 0x6779, 0x222748 },
	{ 0x677a, 0x222740 },
	{ 0x677b, 0x222739 },
	{ 0x677c, 0x214e39 },
	{ 0x677d, 0x222745 },
	{ 0x677e, 0x214e34 },
	{ 0x677f, 0x214e32 },
	{ 0x6780, 0x232952 },
	{ 0x6781, 0x222746 },
	{ 0x6782, 0x232949 },
	{ 0x6783, 0x222744 },
	{ 0x6784, 0x22273c },
	{ 0x6785, 0x222734 },
	{ 0x6786, 0x22273b },
	{ 0x6787, 0x214e2d },
	{ 0x6788, 0x242665 },
	{ 0x6789, 0x214e33 },
	{ 0x678a, 0x23294a },
	{ 0x678b, 0x214e27 },
	{ 0x678c, 0x22273f },
	{ 0x678d, 0x22273e },
	{ 0x678e, 0x222736 },
	{ 0x678f, 0x23294f },
	{ 0x6790, 0x214e35 },
	{ 0x6791, 0x222742 },
	{ 0x6792, 0x222737 },
	{ 0x6793, 0x214e38 },
	{ 0x6794, 0x222749 },
	{ 0x6795, 0x214e28 },
	{ 0x6796, 0x232948 },
	{ 0x6797, 0x214e2f },
	{ 0x6798, 0x22273a },
	{ 0x6799, 0x222743 },
	{ 0x679a, 0x214e37 },
	{ 0x679b, 0x242667 },
	{ 0x679c, 0x214e2a },
	{ 0x679d, 0x214e2e },
	{ 0x679e, 0x24266a },
	{ 0x679f, 0x222741 },
	{ 0x67a1, 0x2f274e },
	{ 0x67a2, 0x23294e },
	{ 0x67a3, 0x23294c },
	{ 0x67a4, 0x236528 },
	{ 0x67a6, 0x2f2750 },
	{ 0x67ac, 0x236529 },
	{ 0x67ae, 0x222b3d },
	{ 0x67af, 0x21515f },
	{ 0x67b0, 0x21516c },
	{ 0x67b1, 0x232d36 },
	{ 0x67b2, 0x222b38 },
	{ 0x67b3, 0x222b2e },
	{ 0x67b4, 0x215165 },
	{ 0x67b5, 0x222b2c },
	{ 0x67b6, 0x21515e },
	{ 0x67b7, 0x222b27 },
	{ 0x67b8, 0x215168 },
	{ 0x67b9, 0x222b34 },
	{ 0x67ba, 0x222b21 },
	{ 0x67bb, 0x222b23 },
	{ 0x67bc, 0x232d2e },
	{ 0x67bd, 0x242d59 },
	{ 0x67be, 0x24296e },
	{ 0x67bf, 0x232d30 },
	{ 0x67c0, 0x222b26 },
	{ 0x67c1, 0x222a7c },
	{ 0x67c2, 0x222b33 },
	{ 0x67c3, 0x222b43 },
	{ 0x67c4, 0x215163 },
	{ 0x67c5, 0x222b28 },
	{ 0x67c6, 0x222b3a },
	{ 0x67c7, 0x232d2d },
	{ 0x67c8, 0x222a7e },
	{ 0x67c9, 0x222b41 },
	{ 0x67ca, 0x222b42 },
	{ 0x67cb, 0x222b45 },
	{ 0x67cc, 0x222b3c },
	{ 0x67cd, 0x222b2d },
	{ 0x67ce, 0x222b35 },
	{ 0x67cf, 0x215169 },
	{ 0x67d0, 0x21515c },
	{ 0x67d1, 0x215164 },
	{ 0x67d2, 0x215170 },
	{ 0x67d3, 0x215159 },
	{ 0x67d4, 0x21515b },
	{ 0x67d5, 0x232d31 },
	{ 0x67d6, 0x232d2b },
	{ 0x67d7, 0x232d3a },
	{ 0x67d8, 0x222b25 },
	{ 0x67d9, 0x21516d },
	{ 0x67da, 0x215166 },
	{ 0x67db, 0x222b3f },
	{ 0x67dc, 0x222b22 },
	{ 0x67dd, 0x21516f },
	{ 0x67de, 0x21516a },
	{ 0x67df, 0x222b2b },
	{ 0x67e0, 0x24296d },
	{ 0x67e1, 0x242d4e },
	{ 0x67e2, 0x21516e },
	{ 0x67e3, 0x222b32 },
	{ 0x67e4, 0x222b2a },
	{ 0x67e5, 0x215167 },
	{ 0x67e6, 0x222b3e },
	{ 0x67e7, 0x222b36 },
	{ 0x67e8, 0x232d2a },
	{ 0x67e9, 0x215161 },
	{ 0x67ea, 0x222b44 },
	{ 0x67eb, 0x222b29 },
	{ 0x67ec, 0x21515d },
	{ 0x67ed, 0x222b3b },
	{ 0x67ee, 0x222b31 },
	{ 0x67ef, 0x215162 },
	{ 0x67f0, 0x222b37 },
	{ 0x67f1, 0x21515a },
	{ 0x67f2, 0x222a7d },
	{ 0x67f3, 0x21516b },
	{ 0x67f4, 0x215627 },
	{ 0x67f5, 0x215160 },
	{ 0x67f6, 0x222b30 },
	{ 0x67f7, 0x222b2f },
	{ 0x67f8, 0x222b24 },
	{ 0x67f9, 0x232951 },
	{ 0x67fa, 0x222b40 },
	{ 0x67fb, 0x232d34 },
	{ 0x67fc, 0x222b39 },
	{ 0x67fe, 0x232d32 },
	{ 0x67ff, 0x215158 },
	{ 0x6800, 0x232d39 },
	{ 0x6801, 0x232d37 },
	{ 0x6804, 0x263172 },
	{ 0x6805, 0x232d38 },
	{ 0x6806, 0x23652b },
	{ 0x6810, 0x23652a },
	{ 0x6811, 0x2f2b48 },
	{ 0x6812, 0x222f6e },
	{ 0x6813, 0x21562e },
	{ 0x6814, 0x222f6f },
	{ 0x6815, 0x23315d },
	{ 0x6816, 0x222f63 },
	{ 0x6817, 0x215623 },
	{ 0x6818, 0x21562f },
	{ 0x6819, 0x233157 },
	{ 0x681a, 0x222f5c },
	{ 0x681b, 0x233153 },
	{ 0x681c, 0x222f65 },
	{ 0x681d, 0x222f6d },
	{ 0x681e, 0x23315b },
	{ 0x681f, 0x222f5b },
	{ 0x6820, 0x222f76 },
	{ 0x6821, 0x215577 },
	{ 0x6822, 0x23315e },
	{ 0x6823, 0x233164 },
	{ 0x6824, 0x233150 },
	{ 0x6825, 0x222f75 },
	{ 0x6826, 0x222f70 },
	{ 0x6827, 0x23315f },
	{ 0x6828, 0x222f71 },
	{ 0x6829, 0x215621 },
	{ 0x682a, 0x21562c },
	{ 0x682b, 0x222f67 },
	{ 0x682c, 0x233156 },
	{ 0x682d, 0x222f68 },
	{ 0x682e, 0x222f72 },
	{ 0x682f, 0x222f69 },
	{ 0x6830, 0x233163 },
	{ 0x6831, 0x222f64 },
	{ 0x6832, 0x222f5e },
	{ 0x6833, 0x222f5f },
	{ 0x6834, 0x222f6c },
	{ 0x6835, 0x222f66 },
	{ 0x6836, 0x233154 },
	{ 0x6837, 0x23314f },
	{ 0x6838, 0x215578 },
	{ 0x6839, 0x21557c },
	{ 0x683a, 0x222f74 },
	{ 0x683b, 0x222f60 },
	{ 0x683c, 0x21562a },
	{ 0x683d, 0x215626 },
	{ 0x683e, 0x23315a },
	{ 0x683f, 0x242d55 },
	{ 0x6840, 0x215629 },
	{ 0x6841, 0x215630 },
	{ 0x6842, 0x21557d },
	{ 0x6843, 0x21562b },
	{ 0x6844, 0x222f6b },
	{ 0x6845, 0x21562d },
	{ 0x6846, 0x21557a },
	{ 0x6847, 0x233159 },
	{ 0x6848, 0x215579 },
	{ 0x6849, 0x222f5d },
	{ 0x684a, 0x242d4f },
	{ 0x684b, 0x222f61 },
	{ 0x684c, 0x215624 },
	{ 0x684d, 0x222f73 },
	{ 0x684e, 0x222f6a },
	{ 0x684f, 0x222f62 },
	{ 0x6850, 0x215628 },
	{ 0x6851, 0x215625 },
	{ 0x6852, 0x232d2f },
	{ 0x6853, 0x21557b },
	{ 0x6854, 0x21557e },
	{ 0x6855, 0x233162 },
	{ 0x6856, 0x233158 },
	{ 0x6857, 0x2f3024 },
	{ 0x6858, 0x233161 },
	{ 0x6859, 0x233160 },
	{ 0x685a, 0x23652d },
	{ 0x685e, 0x23652c },
	{ 0x686b, 0x223628 },
	{ 0x686c, 0x233655 },
	{ 0x686d, 0x223576 },
	{ 0x686e, 0x223577 },
	{ 0x686f, 0x22357b },
	{ 0x6870, 0x233660 },
	{ 0x6871, 0x22362c },
	{ 0x6872, 0x223629 },
	{ 0x6873, 0x23364e },
	{ 0x6874, 0x223622 },
	{ 0x6875, 0x223621 },
	{ 0x6876, 0x215b33 },
	{ 0x6877, 0x223625 },
	{ 0x6878, 0x223634 },
	{ 0x6879, 0x223572 },
	{ 0x687a, 0x23365b },
	{ 0x687b, 0x223635 },
	{ 0x687c, 0x223627 },
	{ 0x687d, 0x223639 },
	{ 0x687e, 0x22362d },
	{ 0x687f, 0x215b32 },
	{ 0x6880, 0x22362b },
	{ 0x6881, 0x215b2d },
	{ 0x6882, 0x215b42 },
	{ 0x6883, 0x215b38 },
	{ 0x6884, 0x233657 },
	{ 0x6885, 0x215b3c },
	{ 0x6886, 0x215b3b },
	{ 0x6887, 0x223573 },
	{ 0x6888, 0x24323f },
	{ 0x6889, 0x223632 },
	{ 0x688a, 0x223638 },
	{ 0x688b, 0x223630 },
	{ 0x688c, 0x223637 },
	{ 0x688e, 0x233651 },
	{ 0x688f, 0x223624 },
	{ 0x6890, 0x223574 },
	{ 0x6891, 0x223636 },
	{ 0x6892, 0x223626 },
	{ 0x6893, 0x215b30 },
	{ 0x6894, 0x215b3d },
	{ 0x6895, 0x23365a },
	{ 0x6896, 0x22362f },
	{ 0x6897, 0x215b36 },
	{ 0x6898, 0x23364d },
	{ 0x6899, 0x23365c },
	{ 0x689a, 0x233650 },
	{ 0x689b, 0x22362e },
	{ 0x689c, 0x223575 },
	{ 0x689d, 0x215b3e },
	{ 0x689e, 0x23364b },
	{ 0x689f, 0x215b40 },
	{ 0x68a0, 0x223631 },
	{ 0x68a1, 0x215b41 },
	{ 0x68a2, 0x215b2f },
	{ 0x68a3, 0x22357c },
	{ 0x68a4, 0x223633 },
	{ 0x68a5, 0x233654 },
	{ 0x68a6, 0x233478 },
	{ 0x68a7, 0x215b35 },
	{ 0x68a8, 0x215b3f },
	{ 0x68a9, 0x22357e },
	{ 0x68aa, 0x22362a },
	{ 0x68ab, 0x223579 },
	{ 0x68ac, 0x22357d },
	{ 0x68ad, 0x215b3a },
	{ 0x68ae, 0x223578 },
	{ 0x68af, 0x215b2e },
	{ 0x68b0, 0x215b37 },
	{ 0x68b1, 0x215b34 },
	{ 0x68b2, 0x223623 },
	{ 0x68b3, 0x215622 },
	{ 0x68b4, 0x223c63 },
	{ 0x68b5, 0x215b31 },
	{ 0x68b6, 0x23364c },
	{ 0x68b7, 0x233652 },
	{ 0x68b8, 0x23365e },
	{ 0x68b9, 0x23365f },
	{ 0x68bd, 0x2f3557 },
	{ 0x68c1, 0x233656 },
	{ 0x68c3, 0x233c45 },
	{ 0x68c4, 0x215b39 },
	{ 0x68c5, 0x233c41 },
	{ 0x68c6, 0x223c66 },
	{ 0x68c7, 0x223c7c },
	{ 0x68c8, 0x223c71 },
	{ 0x68c9, 0x215f7b },
	{ 0x68ca, 0x233c38 },
	{ 0x68cb, 0x215f76 },
	{ 0x68cc, 0x223c60 },
	{ 0x68cd, 0x215f77 },
	{ 0x68ce, 0x223c70 },
	{ 0x68cf, 0x233c3e },
	{ 0x68d0, 0x223c69 },
	{ 0x68d1, 0x223c76 },
	{ 0x68d2, 0x215f73 },
	{ 0x68d3, 0x223c4e },
	{ 0x68d4, 0x223c78 },
	{ 0x68d5, 0x215f69 },
	{ 0x68d6, 0x223c56 },
	{ 0x68d7, 0x215f6c },
	{ 0x68d8, 0x215f6b },
	{ 0x68d9, 0x243832 },
	{ 0x68da, 0x215f7c },
	{ 0x68db, 0x233653 },
	{ 0x68dc, 0x223c50 },
	{ 0x68dd, 0x223c72 },
	{ 0x68de, 0x223c73 },
	{ 0x68df, 0x215f6e },
	{ 0x68e0, 0x215f6a },
	{ 0x68e1, 0x223c5e },
	{ 0x68e2, 0x233c3d },
	{ 0x68e3, 0x215f75 },
	{ 0x68e4, 0x223c59 },
	{ 0x68e5, 0x233c32 },
	{ 0x68e6, 0x223c74 },
	{ 0x68e7, 0x215f71 },
	{ 0x68e8, 0x223c6c },
	{ 0x68e9, 0x223c79 },
	{ 0x68ea, 0x223c53 },
	{ 0x68eb, 0x223c58 },
	{ 0x68ec, 0x223c52 },
	{ 0x68ed, 0x233c2a },
	{ 0x68ee, 0x215f70 },
	{ 0x68ef, 0x223c65 },
	{ 0x68f0, 0x224364 },
	{ 0x68f1, 0x223c54 },
	{ 0x68f2, 0x215f74 },
	{ 0x68f3, 0x223c5d },
	{ 0x68f4, 0x223c75 },
	{ 0x68f5, 0x215f6f },
	{ 0x68f6, 0x223c5a },
	{ 0x68f7, 0x223c57 },
	{ 0x68f8, 0x223c68 },
	{ 0x68f9, 0x215f72 },
	{ 0x68fa, 0x215f68 },
	{ 0x68fb, 0x215f7e },
	{ 0x68fc, 0x223c6b },
	{ 0x68fd, 0x223c6a },
	{ 0x68fe, 0x233c31 },
	{ 0x68ff, 0x233c42 },
	{ 0x6900, 0x233c39 },
	{ 0x6901, 0x233c3b },
	{ 0x6902, 0x233c34 },
	{ 0x6903, 0x233c2f },
	{ 0x6904, 0x223c4f },
	{ 0x6905, 0x215f6d },
	{ 0x6906, 0x223c77 },
	{ 0x6907, 0x223c5f },
	{ 0x6908, 0x223c61 },
	{ 0x6909, 0x233c37 },
	{ 0x690a, 0x223c6e },
	{ 0x690b, 0x223c6d },
	{ 0x690c, 0x223c4d },
	{ 0x690d, 0x215f78 },
	{ 0x690e, 0x215f7a },
	{ 0x690f, 0x223c55 },
	{ 0x6910, 0x223c5c },
	{ 0x6911, 0x223c64 },
	{ 0x6912, 0x215f79 },
	{ 0x6913, 0x223c5b },
	{ 0x6914, 0x223c67 },
	{ 0x6915, 0x223c7a },
	{ 0x6916, 0x2f3b70 },
	{ 0x6917, 0x223c6f },
	{ 0x6918, 0x233c3c },
	{ 0x691b, 0x2f3c21 },
	{ 0x691c, 0x233c44 },
	{ 0x691e, 0x233c33 },
	{ 0x6925, 0x223c7b },
	{ 0x6927, 0x2f3c29 },
	{ 0x6929, 0x23652f },
	{ 0x692a, 0x223c51 },
	{ 0x692b, 0x2f3b6e },
	{ 0x692c, 0x23652e },
	{ 0x692e, 0x233c40 },
	{ 0x692f, 0x224378 },
	{ 0x6930, 0x21644c },
	{ 0x6931, 0x234165 },
	{ 0x6932, 0x224376 },
	{ 0x6933, 0x224361 },
	{ 0x6934, 0x224366 },
	{ 0x6935, 0x22435f },
	{ 0x6936, 0x234177 },
	{ 0x6937, 0x224372 },
	{ 0x6938, 0x224351 },
	{ 0x6939, 0x224358 },
	{ 0x693a, 0x243d71 },
	{ 0x693b, 0x224370 },
	{ 0x693c, 0x22437a },
	{ 0x693d, 0x224362 },
	{ 0x693e, 0x234168 },
	{ 0x693f, 0x224355 },
	{ 0x6940, 0x224368 },
	{ 0x6941, 0x22436d },
	{ 0x6942, 0x224359 },
	{ 0x6943, 0x23416b },
	{ 0x6944, 0x22436a },
	{ 0x6945, 0x224356 },
	{ 0x6946, 0x23415d },
	{ 0x6947, 0x234175 },
	{ 0x6948, 0x22435d },
	{ 0x6949, 0x22435e },
	{ 0x694a, 0x21644e },
	{ 0x694b, 0x224371 },
	{ 0x694c, 0x22436f },
	{ 0x694d, 0x234173 },
	{ 0x694e, 0x224352 },
	{ 0x694f, 0x224374 },
	{ 0x6950, 0x234174 },
	{ 0x6951, 0x224375 },
	{ 0x6952, 0x224377 },
	{ 0x6953, 0x216452 },
	{ 0x6954, 0x21644a },
	{ 0x6955, 0x23416f },
	{ 0x6956, 0x22357a },
	{ 0x6957, 0x22435a },
	{ 0x6958, 0x22436c },
	{ 0x6959, 0x22435b },
	{ 0x695a, 0x216447 },
	{ 0x695b, 0x216457 },
	{ 0x695c, 0x224373 },
	{ 0x695d, 0x216455 },
	{ 0x695e, 0x216451 },
	{ 0x695f, 0x224350 },
	{ 0x6960, 0x216449 },
	{ 0x6961, 0x234179 },
	{ 0x6962, 0x224353 },
	{ 0x6963, 0x216456 },
	{ 0x6964, 0x234178 },
	{ 0x6965, 0x224363 },
	{ 0x6966, 0x22434f },
	{ 0x6967, 0x234176 },
	{ 0x6968, 0x21644f },
	{ 0x6969, 0x224367 },
	{ 0x696a, 0x224357 },
	{ 0x696b, 0x216450 },
	{ 0x696c, 0x224360 },
	{ 0x696d, 0x216446 },
	{ 0x696e, 0x215f7d },
	{ 0x696f, 0x224369 },
	{ 0x6970, 0x223c62 },
	{ 0x6971, 0x224354 },
	{ 0x6972, 0x243d6c },
	{ 0x6973, 0x23416d },
	{ 0x6974, 0x22436e },
	{ 0x6975, 0x21644b },
	{ 0x6976, 0x22436b },
	{ 0x6977, 0x216448 },
	{ 0x6978, 0x224365 },
	{ 0x6979, 0x216453 },
	{ 0x697a, 0x22435c },
	{ 0x697b, 0x224379 },
	{ 0x697c, 0x23416a },
	{ 0x697d, 0x23417b },
	{ 0x697f, 0x2f4249 },
	{ 0x6980, 0x2f4247 },
	{ 0x6982, 0x21644d },
	{ 0x6983, 0x22452c },
	{ 0x6985, 0x234172 },
	{ 0x6986, 0x216454 },
	{ 0x698a, 0x2f4228 },
	{ 0x698c, 0x2f423c },
	{ 0x698d, 0x224a70 },
	{ 0x698e, 0x224a6e },
	{ 0x698f, 0x23473a },
	{ 0x6990, 0x224b26 },
	{ 0x6991, 0x224a6c },
	{ 0x6992, 0x23473d },
	{ 0x6993, 0x224a7e },
	{ 0x6994, 0x216445 },
	{ 0x6995, 0x216928 },
	{ 0x6996, 0x224a68 },
	{ 0x6997, 0x224b25 },
	{ 0x6998, 0x234751 },
	{ 0x6999, 0x224a6d },
	{ 0x699a, 0x224a7b },
	{ 0x699b, 0x21692d },
	{ 0x699c, 0x216926 },
	{ 0x699d, 0x23474e },
	{ 0x699e, 0x224b23 },
	{ 0x699f, 0x234746 },
	{ 0x69a0, 0x224a66 },
	{ 0x69a1, 0x224b22 },
	{ 0x69a2, 0x234747 },
	{ 0x69a3, 0x216938 },
	{ 0x69a4, 0x224a77 },
	{ 0x69a5, 0x224b29 },
	{ 0x69a6, 0x216936 },
	{ 0x69a7, 0x224a6f },
	{ 0x69a8, 0x216927 },
	{ 0x69a9, 0x224a71 },
	{ 0x69aa, 0x224b21 },
	{ 0x69ab, 0x216930 },
	{ 0x69ac, 0x224a6a },
	{ 0x69ad, 0x216934 },
	{ 0x69ae, 0x21692a },
	{ 0x69af, 0x224a73 },
	{ 0x69b0, 0x224a69 },
	{ 0x69b1, 0x224a63 },
	{ 0x69b2, 0x23473e },
	{ 0x69b3, 0x224a7d },
	{ 0x69b4, 0x216931 },
	{ 0x69b5, 0x224b28 },
	{ 0x69b6, 0x224a64 },
	{ 0x69b7, 0x21692e },
	{ 0x69b8, 0x244377 },
	{ 0x69b9, 0x224a79 },
	{ 0x69ba, 0x244379 },
	{ 0x69bb, 0x21692f },
	{ 0x69bc, 0x224a6b },
	{ 0x69bd, 0x224a76 },
	{ 0x69be, 0x224a72 },
	{ 0x69bf, 0x224a74 },
	{ 0x69c0, 0x234743 },
	{ 0x69c1, 0x216929 },
	{ 0x69c2, 0x224b27 },
	{ 0x69c3, 0x216937 },
	{ 0x69c4, 0x224a75 },
	{ 0x69c5, 0x23473b },
	{ 0x69c6, 0x224b2a },
	{ 0x69c7, 0x244427 },
	{ 0x69c8, 0x23473c },
	{ 0x69c9, 0x224a65 },
	{ 0x69ca, 0x224a7a },
	{ 0x69cb, 0x21692c },
	{ 0x69cc, 0x216935 },
	{ 0x69cd, 0x216933 },
	{ 0x69ce, 0x224a67 },
	{ 0x69cf, 0x224a7c },
	{ 0x69d0, 0x216932 },
	{ 0x69d1, 0x234745 },
	{ 0x69d2, 0x234748 },
	{ 0x69d3, 0x21692b },
	{ 0x69d4, 0x224a78 },
	{ 0x69d5, 0x23474d },
	{ 0x69d6, 0x234744 },
	{ 0x69d7, 0x244428 },
	{ 0x69d8, 0x234c54 },
	{ 0x69d9, 0x224b24 },
	{ 0x69e1, 0x23474c },
	{ 0x69e2, 0x22507c },
	{ 0x69e3, 0x234742 },
	{ 0x69e4, 0x225078 },
	{ 0x69e5, 0x225074 },
	{ 0x69e6, 0x22512a },
	{ 0x69e7, 0x225127 },
	{ 0x69e8, 0x216d37 },
	{ 0x69e9, 0x234c64 },
	{ 0x69ea, 0x234c60 },
	{ 0x69eb, 0x22512e },
	{ 0x69ec, 0x22507b },
	{ 0x69ed, 0x216d42 },
	{ 0x69ee, 0x225124 },
	{ 0x69ef, 0x234c4f },
	{ 0x69f0, 0x234c51 },
	{ 0x69f1, 0x225077 },
	{ 0x69f2, 0x225123 },
	{ 0x69f3, 0x216d3f },
	{ 0x69f4, 0x225137 },
	{ 0x69f5, 0x244a3d },
	{ 0x69f6, 0x225134 },
	{ 0x69f7, 0x225126 },
	{ 0x69f8, 0x225075 },
	{ 0x69f9, 0x234c5f },
	{ 0x69fa, 0x234c57 },
	{ 0x69fb, 0x22512b },
	{ 0x69fc, 0x22512d },
	{ 0x69fd, 0x216d3b },
	{ 0x69fe, 0x225121 },
	{ 0x69ff, 0x22507a },
	{ 0x6a00, 0x225071 },
	{ 0x6a01, 0x216d38 },
	{ 0x6a02, 0x216d40 },
	{ 0x6a03, 0x244a48 },
	{ 0x6a04, 0x225130 },
	{ 0x6a05, 0x216d41 },
	{ 0x6a06, 0x225072 },
	{ 0x6a07, 0x225136 },
	{ 0x6a08, 0x225129 },
	{ 0x6a09, 0x22512f },
	{ 0x6a0a, 0x216d3e },
	{ 0x6a0b, 0x234c4d },
	{ 0x6a0c, 0x234c50 },
	{ 0x6a0d, 0x22512c },
	{ 0x6a0e, 0x234c47 },
	{ 0x6a0f, 0x225133 },
	{ 0x6a10, 0x234c5b },
	{ 0x6a11, 0x216d43 },
	{ 0x6a12, 0x234c56 },
	{ 0x6a13, 0x216d3d },
	{ 0x6a14, 0x225125 },
	{ 0x6a15, 0x225076 },
	{ 0x6a16, 0x225138 },
	{ 0x6a17, 0x225073 },
	{ 0x6a18, 0x225131 },
	{ 0x6a19, 0x216d3a },
	{ 0x6a1a, 0x234c4a },
	{ 0x6a1b, 0x22507d },
	{ 0x6a1c, 0x234c49 },
	{ 0x6a1d, 0x22507e },
	{ 0x6a1e, 0x216d39 },
	{ 0x6a1f, 0x216d36 },
	{ 0x6a20, 0x225079 },
	{ 0x6a21, 0x216d3c },
	{ 0x6a22, 0x234c52 },
	{ 0x6a23, 0x216d35 },
	{ 0x6a24, 0x234c62 },
	{ 0x6a25, 0x225132 },
	{ 0x6a26, 0x225135 },
	{ 0x6a27, 0x225122 },
	{ 0x6a28, 0x225755 },
	{ 0x6a29, 0x234c5e },
	{ 0x6a2a, 0x234c59 },
	{ 0x6a2b, 0x2f4f42 },
	{ 0x6a2c, 0x234c61 },
	{ 0x6a2d, 0x236530 },
	{ 0x6a32, 0x22574d },
	{ 0x6a33, 0x23512c },
	{ 0x6a34, 0x225749 },
	{ 0x6a35, 0x217121 },
	{ 0x6a36, 0x23513c },
	{ 0x6a37, 0x235138 },
	{ 0x6a38, 0x217074 },
	{ 0x6a39, 0x217079 },
	{ 0x6a3a, 0x217075 },
	{ 0x6a3b, 0x225757 },
	{ 0x6a3c, 0x225762 },
	{ 0x6a3d, 0x217073 },
	{ 0x6a3e, 0x22574f },
	{ 0x6a3f, 0x225758 },
	{ 0x6a40, 0x225128 },
	{ 0x6a41, 0x225759 },
	{ 0x6a42, 0x235128 },
	{ 0x6a43, 0x23512b },
	{ 0x6a44, 0x21707a },
	{ 0x6a45, 0x235140 },
	{ 0x6a46, 0x225768 },
	{ 0x6a47, 0x21707e },
	{ 0x6a48, 0x217123 },
	{ 0x6a49, 0x22574b },
	{ 0x6a4a, 0x23513b },
	{ 0x6a4b, 0x21707d },
	{ 0x6a4c, 0x235131 },
	{ 0x6a4d, 0x225766 },
	{ 0x6a4e, 0x225767 },
	{ 0x6a4f, 0x22575d },
	{ 0x6a50, 0x22575c },
	{ 0x6a51, 0x225754 },
	{ 0x6a52, 0x235129 },
	{ 0x6a53, 0x23513e },
	{ 0x6a54, 0x22575e },
	{ 0x6a55, 0x225765 },
	{ 0x6a56, 0x225764 },
	{ 0x6a57, 0x23512f },
	{ 0x6a58, 0x217078 },
	{ 0x6a59, 0x217076 },
	{ 0x6a5a, 0x225756 },
	{ 0x6a5b, 0x225753 },
	{ 0x6a5c, 0x235144 },
	{ 0x6a5d, 0x225750 },
	{ 0x6a5e, 0x225763 },
	{ 0x6a5f, 0x217122 },
	{ 0x6a60, 0x225761 },
	{ 0x6a61, 0x21707c },
	{ 0x6a62, 0x21707b },
	{ 0x6a63, 0x235127 },
	{ 0x6a64, 0x22575b },
	{ 0x6a65, 0x244a4b },
	{ 0x6a66, 0x22574a },
	{ 0x6a67, 0x22574c },
	{ 0x6a68, 0x22574e },
	{ 0x6a69, 0x225760 },
	{ 0x6a6a, 0x22575a },
	{ 0x6a6b, 0x217077 },
	{ 0x6a6c, 0x23512e },
	{ 0x6a6d, 0x225751 },
	{ 0x6a6e, 0x235132 },
	{ 0x6a6f, 0x22575f },
	{ 0x6a70, 0x235141 },
	{ 0x6a71, 0x23513a },
	{ 0x6a72, 0x2f547b },
	{ 0x6a76, 0x225752 },
	{ 0x6a77, 0x236531 },
	{ 0x6a78, 0x2f5529 },
	{ 0x6a7a, 0x236532 },
	{ 0x6a7d, 0x235475 },
	{ 0x6a7e, 0x217378 },
	{ 0x6a7f, 0x225d31 },
	{ 0x6a80, 0x217371 },
	{ 0x6a81, 0x225d22 },
	{ 0x6a82, 0x23547b },
	{ 0x6a83, 0x225d2d },
	{ 0x6a84, 0x217373 },
	{ 0x6a85, 0x225d34 },
	{ 0x6a86, 0x235521 },
	{ 0x6a87, 0x225d29 },
	{ 0x6a88, 0x23547c },
	{ 0x6a89, 0x225d24 },
	{ 0x6a8a, 0x235476 },
	{ 0x6a8b, 0x245645 },
	{ 0x6a8c, 0x225d35 },
	{ 0x6a8d, 0x225c7e },
	{ 0x6a8e, 0x225d2b },
	{ 0x6a8f, 0x235527 },
	{ 0x6a90, 0x21737a },
	{ 0x6a91, 0x225d30 },
	{ 0x6a92, 0x225d36 },
	{ 0x6a93, 0x225d2a },
	{ 0x6a94, 0x217372 },
	{ 0x6a95, 0x225d2c },
	{ 0x6a96, 0x225d21 },
	{ 0x6a97, 0x217379 },
	{ 0x6a98, 0x235523 },
	{ 0x6a99, 0x23547a },
	{ 0x6a9a, 0x225d33 },
	{ 0x6a9b, 0x225d26 },
	{ 0x6a9c, 0x217375 },
	{ 0x6a9d, 0x235524 },
	{ 0x6a9e, 0x225d28 },
	{ 0x6a9f, 0x225d25 },
	{ 0x6aa0, 0x21737b },
	{ 0x6aa1, 0x225d27 },
	{ 0x6aa2, 0x217374 },
	{ 0x6aa3, 0x217377 },
	{ 0x6aa4, 0x225d2f },
	{ 0x6aa5, 0x225d23 },
	{ 0x6aa6, 0x225d32 },
	{ 0x6aa7, 0x235478 },
	{ 0x6aa8, 0x225d2e },
	{ 0x6aaa, 0x235529 },
	{ 0x6aab, 0x235774 },
	{ 0x6aac, 0x21764f },
	{ 0x6aad, 0x226173 },
	{ 0x6aae, 0x217654 },
	{ 0x6aaf, 0x217655 },
	{ 0x6ab0, 0x235777 },
	{ 0x6ab1, 0x235821 },
	{ 0x6ab2, 0x235776 },
	{ 0x6ab3, 0x21764e },
	{ 0x6ab4, 0x226172 },
	{ 0x6ab5, 0x235778 },
	{ 0x6ab6, 0x22616f },
	{ 0x6ab7, 0x226170 },
	{ 0x6ab8, 0x217652 },
	{ 0x6ab9, 0x22616a },
	{ 0x6aba, 0x22616e },
	{ 0x6abb, 0x217651 },
	{ 0x6abc, 0x23577e },
	{ 0x6abd, 0x22616b },
	{ 0x6abe, 0x235779 },
	{ 0x6abf, 0x235823 },
	{ 0x6ac0, 0x23577d },
	{ 0x6ac1, 0x23577a },
	{ 0x6ac2, 0x217653 },
	{ 0x6ac3, 0x217650 },
	{ 0x6ac4, 0x235822 },
	{ 0x6ac5, 0x226169 },
	{ 0x6ac6, 0x22616d },
	{ 0x6ac7, 0x226171 },
	{ 0x6ac8, 0x23577b },
	{ 0x6aca, 0x236533 },
	{ 0x6acb, 0x22655c },
	{ 0x6acc, 0x226559 },
	{ 0x6acd, 0x226562 },
	{ 0x6ace, 0x235a44 },
	{ 0x6acf, 0x226561 },
	{ 0x6ad0, 0x22655f },
	{ 0x6ad1, 0x22655a },
	{ 0x6ad2, 0x235a4f },
	{ 0x6ad3, 0x21783f },
	{ 0x6ad4, 0x235a45 },
	{ 0x6ad5, 0x235a4e },
	{ 0x6ad6, 0x245f71 },
	{ 0x6ad7, 0x235a47 },
	{ 0x6ad8, 0x235a4d },
	{ 0x6ad9, 0x22655b },
	{ 0x6ada, 0x21783e },
	{ 0x6adb, 0x217376 },
	{ 0x6adc, 0x22655e },
	{ 0x6add, 0x21783d },
	{ 0x6ade, 0x226563 },
	{ 0x6adf, 0x22655d },
	{ 0x6ae0, 0x226558 },
	{ 0x6ae1, 0x22616c },
	{ 0x6ae2, 0x235a48 },
	{ 0x6ae3, 0x235a46 },
	{ 0x6ae5, 0x21783c },
	{ 0x6ae6, 0x236534 },
	{ 0x6ae7, 0x226557 },
	{ 0x6ae8, 0x226924 },
	{ 0x6ae9, 0x235c49 },
	{ 0x6aea, 0x226923 },
	{ 0x6aeb, 0x226560 },
	{ 0x6aec, 0x217973 },
	{ 0x6aed, 0x235775 },
	{ 0x6aee, 0x226927 },
	{ 0x6aef, 0x226928 },
	{ 0x6af0, 0x226922 },
	{ 0x6af1, 0x226926 },
	{ 0x6af2, 0x246350 },
	{ 0x6af3, 0x226921 },
	{ 0x6af4, 0x235c47 },
	{ 0x6af5, 0x236535 },
	{ 0x6af6, 0x24634e },
	{ 0x6af8, 0x226b5f },
	{ 0x6af9, 0x226925 },
	{ 0x6afa, 0x217a72 },
	{ 0x6afb, 0x217a70 },
	{ 0x6afc, 0x226b5d },
	{ 0x6afd, 0x235e35 },
	{ 0x6afe, 0x235e34 },
	{ 0x6aff, 0x235e33 },
	{ 0x6b00, 0x226b60 },
	{ 0x6b01, 0x235e37 },
	{ 0x6b02, 0x226b5c },
	{ 0x6b03, 0x226b5e },
	{ 0x6b04, 0x217a71 },
	{ 0x6b06, 0x235f4f },
	{ 0x6b07, 0x235f4e },
	{ 0x6b08, 0x226d53 },
	{ 0x6b09, 0x226d54 },
	{ 0x6b0a, 0x217b62 },
	{ 0x6b0b, 0x226d52 },
	{ 0x6b0c, 0x2f694c },
	{ 0x6b0d, 0x236536 },
	{ 0x6b0e, 0x236537 },
	{ 0x6b0f, 0x226f31 },
	{ 0x6b10, 0x217c3b },
	{ 0x6b11, 0x226f2f },
	{ 0x6b12, 0x226f30 },
	{ 0x6b13, 0x22703a },
	{ 0x6b14, 0x236074 },
	{ 0x6b15, 0x2f6b51 },
	{ 0x6b16, 0x217d23 },
	{ 0x6b17, 0x227123 },
	{ 0x6b18, 0x227121 },
	{ 0x6b19, 0x227122 },
	{ 0x6b1a, 0x227124 },
	{ 0x6b1b, 0x236140 },
	{ 0x6b1c, 0x236165 },
	{ 0x6b1d, 0x236141 },
	{ 0x6b1e, 0x22722b },
	{ 0x6b20, 0x21454e },
	{ 0x6b21, 0x214839 },
	{ 0x6b22, 0x232379 },
	{ 0x6b23, 0x214e3c },
	{ 0x6b24, 0x242671 },
	{ 0x6b25, 0x22274a },
	{ 0x6b26, 0x232953 },
	{ 0x6b27, 0x232954 },
	{ 0x6b28, 0x222b46 },
	{ 0x6b29, 0x242972 },
	{ 0x6b2a, 0x232d3c },
	{ 0x6b2b, 0x233166 },
	{ 0x6b2c, 0x222f77 },
	{ 0x6b2d, 0x222f79 },
	{ 0x6b2e, 0x233165 },
	{ 0x6b2f, 0x222f78 },
	{ 0x6b30, 0x233167 },
	{ 0x6b31, 0x222f7a },
	{ 0x6b32, 0x215b43 },
	{ 0x6b33, 0x22363b },
	{ 0x6b34, 0x222f7b },
	{ 0x6b35, 0x233662 },
	{ 0x6b36, 0x22363a },
	{ 0x6b37, 0x22363c },
	{ 0x6b38, 0x22363d },
	{ 0x6b39, 0x223c7d },
	{ 0x6b3a, 0x216022 },
	{ 0x6b3b, 0x223c7e },
	{ 0x6b3c, 0x223d22 },
	{ 0x6b3d, 0x216023 },
	{ 0x6b3e, 0x216021 },
	{ 0x6b3f, 0x223d21 },
	{ 0x6b40, 0x23417d },
	{ 0x6b41, 0x224422 },
	{ 0x6b42, 0x22437e },
	{ 0x6b43, 0x22437d },
	{ 0x6b44, 0x23417c },
	{ 0x6b45, 0x22437c },
	{ 0x6b46, 0x22437b },
	{ 0x6b47, 0x216458 },
	{ 0x6b48, 0x224421 },
	{ 0x6b49, 0x216939 },
	{ 0x6b4a, 0x224b2b },
	{ 0x6b4b, 0x224b2d },
	{ 0x6b4c, 0x21693a },
	{ 0x6b4d, 0x224b2c },
	{ 0x6b4e, 0x216d45 },
	{ 0x6b4f, 0x234c66 },
	{ 0x6b50, 0x216d44 },
	{ 0x6b51, 0x225139 },
	{ 0x6b52, 0x234c65 },
	{ 0x6b53, 0x234c67 },
	{ 0x6b54, 0x22576a },
	{ 0x6b55, 0x225769 },
	{ 0x6b56, 0x22576b },
	{ 0x6b57, 0x235146 },
	{ 0x6b58, 0x235145 },
	{ 0x6b59, 0x217124 },
	{ 0x6b5a, 0x2f5539 },
	{ 0x6b5b, 0x225d37 },
	{ 0x6b5c, 0x21737c },
	{ 0x6b5d, 0x23552b },
	{ 0x6b5e, 0x226174 },
	{ 0x6b5f, 0x217656 },
	{ 0x6b60, 0x226564 },
	{ 0x6b61, 0x217b63 },
	{ 0x6b62, 0x21454f },
	{ 0x6b63, 0x21465f },
	{ 0x6b64, 0x21483a },
	{ 0x6b65, 0x214a63 },
	{ 0x6b66, 0x214e3d },
	{ 0x6b67, 0x214e3e },
	{ 0x6b68, 0x232955 },
	{ 0x6b69, 0x232956 },
	{ 0x6b6a, 0x215171 },
	{ 0x6b6b, 0x232d3d },
	{ 0x6b6c, 0x233168 },
	{ 0x6b6d, 0x222f7c },
	{ 0x6b6e, 0x233c49 },
	{ 0x6b6f, 0x233c47 },
	{ 0x6b70, 0x24442d },
	{ 0x6b71, 0x23417e },
	{ 0x6b72, 0x216459 },
	{ 0x6b73, 0x234221 },
	{ 0x6b74, 0x234753 },
	{ 0x6b75, 0x244a4e },
	{ 0x6b76, 0x225259 },
	{ 0x6b77, 0x217125 },
	{ 0x6b78, 0x217657 },
	{ 0x6b79, 0x214550 },
	{ 0x6b7a, 0x232253 },
	{ 0x6b7b, 0x21483b },
	{ 0x6b7d, 0x242676 },
	{ 0x6b7e, 0x22274c },
	{ 0x6b7f, 0x214e3f },
	{ 0x6b80, 0x22274b },
	{ 0x6b81, 0x232958 },
	{ 0x6b82, 0x222b47 },
	{ 0x6b83, 0x215172 },
	{ 0x6b84, 0x222b48 },
	{ 0x6b85, 0x252969 },
	{ 0x6b86, 0x215173 },
	{ 0x6b88, 0x222f7e },
	{ 0x6b89, 0x215632 },
	{ 0x6b8a, 0x215631 },
	{ 0x6b8b, 0x23316a },
	{ 0x6b8c, 0x223642 },
	{ 0x6b8d, 0x223640 },
	{ 0x6b8e, 0x223641 },
	{ 0x6b8f, 0x22363f },
	{ 0x6b90, 0x233664 },
	{ 0x6b91, 0x22363e },
	{ 0x6b94, 0x223d23 },
	{ 0x6b95, 0x223d26 },
	{ 0x6b96, 0x216025 },
	{ 0x6b97, 0x223d24 },
	{ 0x6b98, 0x216024 },
	{ 0x6b99, 0x223d25 },
	{ 0x6b9b, 0x224423 },
	{ 0x6b9c, 0x234222 },
	{ 0x6b9d, 0x244431 },
	{ 0x6b9e, 0x224b2e },
	{ 0x6b9f, 0x224b2f },
	{ 0x6ba0, 0x224b30 },
	{ 0x6ba1, 0x234754 },
	{ 0x6ba2, 0x22513c },
	{ 0x6ba3, 0x22513b },
	{ 0x6ba4, 0x216d46 },
	{ 0x6ba5, 0x22513a },
	{ 0x6ba6, 0x22513d },
	{ 0x6ba7, 0x22576c },
	{ 0x6ba8, 0x24506d },
	{ 0x6ba9, 0x255b72 },
	{ 0x6baa, 0x22576d },
	{ 0x6bab, 0x22576e },
	{ 0x6bac, 0x245652 },
	{ 0x6bad, 0x225d38 },
	{ 0x6bae, 0x21737d },
	{ 0x6baf, 0x217658 },
	{ 0x6bb0, 0x226565 },
	{ 0x6bb2, 0x217a73 },
	{ 0x6bb3, 0x22213f },
	{ 0x6bb4, 0x232959 },
	{ 0x6bb5, 0x215174 },
	{ 0x6bb6, 0x222b49 },
	{ 0x6bb7, 0x215633 },
	{ 0x6bb8, 0x24324e },
	{ 0x6bb9, 0x243250 },
	{ 0x6bba, 0x215b44 },
	{ 0x6bbb, 0x233665 },
	{ 0x6bbc, 0x216026 },
	{ 0x6bbd, 0x223d27 },
	{ 0x6bbe, 0x233c4b },
	{ 0x6bbf, 0x21645b },
	{ 0x6bc0, 0x21645a },
	{ 0x6bc1, 0x234226 },
	{ 0x6bc3, 0x224b31 },
	{ 0x6bc4, 0x224b32 },
	{ 0x6bc5, 0x216d47 },
	{ 0x6bc6, 0x216d48 },
	{ 0x6bc7, 0x225770 },
	{ 0x6bc8, 0x22576f },
	{ 0x6bc9, 0x226175 },
	{ 0x6bca, 0x226f32 },
	{ 0x6bcb, 0x214551 },
	{ 0x6bcc, 0x222140 },
	{ 0x6bcd, 0x214660 },
	{ 0x6bce, 0x23237a },
	{ 0x6bcf, 0x214a64 },
	{ 0x6bd0, 0x222448 },
	{ 0x6bd1, 0x23295a },
	{ 0x6bd2, 0x215175 },
	{ 0x6bd3, 0x21645c },
	{ 0x6bd4, 0x214552 },
	{ 0x6bd6, 0x222b4a },
	{ 0x6bd7, 0x215176 },
	{ 0x6bd8, 0x222b4b },
	{ 0x6bda, 0x21737e },
	{ 0x6bdb, 0x214553 },
	{ 0x6bdc, 0x236538 },
	{ 0x6bdd, 0x236539 },
	{ 0x6bde, 0x22274d },
	{ 0x6be0, 0x222b4c },
	{ 0x6be1, 0x232d42 },
	{ 0x6be2, 0x223025 },
	{ 0x6be3, 0x223024 },
	{ 0x6be4, 0x223022 },
	{ 0x6be5, 0x23316e },
	{ 0x6be6, 0x223021 },
	{ 0x6be7, 0x223026 },
	{ 0x6be8, 0x223023 },
	{ 0x6be9, 0x23316c },
	{ 0x6bea, 0x23316d },
	{ 0x6beb, 0x215b45 },
	{ 0x6bec, 0x215b46 },
	{ 0x6bed, 0x233666 },
	{ 0x6bef, 0x216027 },
	{ 0x6bf0, 0x223d28 },
	{ 0x6bf1, 0x24384e },
	{ 0x6bf2, 0x223d29 },
	{ 0x6bf3, 0x223d2a },
	{ 0x6bf4, 0x233c4d },
	{ 0x6bf5, 0x2f3c3c },
	{ 0x6bf6, 0x23653a },
	{ 0x6bf7, 0x224427 },
	{ 0x6bf8, 0x224428 },
	{ 0x6bf9, 0x224426 },
	{ 0x6bfa, 0x234228 },
	{ 0x6bfb, 0x224424 },
	{ 0x6bfc, 0x224425 },
	{ 0x6bfd, 0x21645d },
	{ 0x6bfe, 0x224b33 },
	{ 0x6bff, 0x225140 },
	{ 0x6c00, 0x22513f },
	{ 0x6c01, 0x22513e },
	{ 0x6c02, 0x225141 },
	{ 0x6c03, 0x225772 },
	{ 0x6c04, 0x225771 },
	{ 0x6c05, 0x217126 },
	{ 0x6c06, 0x225773 },
	{ 0x6c08, 0x217421 },
	{ 0x6c09, 0x225d39 },
	{ 0x6c0a, 0x23552d },
	{ 0x6c0b, 0x226176 },
	{ 0x6c0c, 0x226566 },
	{ 0x6c0d, 0x226d55 },
	{ 0x6c0f, 0x214554 },
	{ 0x6c10, 0x214662 },
	{ 0x6c11, 0x214661 },
	{ 0x6c12, 0x242321 },
	{ 0x6c13, 0x214e40 },
	{ 0x6c14, 0x222141 },
	{ 0x6c15, 0x22215f },
	{ 0x6c16, 0x21483c },
	{ 0x6c18, 0x222258 },
	{ 0x6c19, 0x222449 },
	{ 0x6c1a, 0x22244a },
	{ 0x6c1b, 0x214e41 },
	{ 0x6c1c, 0x23295d },
	{ 0x6c1d, 0x22274e },
	{ 0x6c1e, 0x23653b },
	{ 0x6c1f, 0x215177 },
	{ 0x6c20, 0x222b4d },
	{ 0x6c21, 0x222b4e },
	{ 0x6c23, 0x215634 },
	{ 0x6c24, 0x215638 },
	{ 0x6c25, 0x223027 },
	{ 0x6c26, 0x215637 },
	{ 0x6c27, 0x215635 },
	{ 0x6c28, 0x215636 },
	{ 0x6c2a, 0x223643 },
	{ 0x6c2b, 0x215b47 },
	{ 0x6c2c, 0x21602a },
	{ 0x6c2d, 0x233c4e },
	{ 0x6c2e, 0x216028 },
	{ 0x6c2f, 0x216029 },
	{ 0x6c30, 0x223d2b },
	{ 0x6c31, 0x234229 },
	{ 0x6c32, 0x23422a },
	{ 0x6c33, 0x21693b },
	{ 0x6c34, 0x214555 },
	{ 0x6c36, 0x222160 },
	{ 0x6c37, 0x232257 },
	{ 0x6c38, 0x214663 },
	{ 0x6c39, 0x232254 },
	{ 0x6c3b, 0x222163 },
	{ 0x6c3c, 0x232421 },
	{ 0x6c3e, 0x214666 },
	{ 0x6c3f, 0x222162 },
	{ 0x6c40, 0x214665 },
	{ 0x6c41, 0x214664 },
	{ 0x6c42, 0x214a65 },
	{ 0x6c43, 0x222161 },
	{ 0x6c44, 0x232258 },
	{ 0x6c45, 0x232259 },
	{ 0x6c46, 0x222259 },
	{ 0x6c49, 0x2f2166 },
	{ 0x6c4a, 0x22225d },
	{ 0x6c4b, 0x22225f },
	{ 0x6c4c, 0x222260 },
	{ 0x6c4d, 0x214846 },
	{ 0x6c4e, 0x214847 },
	{ 0x6c4f, 0x22225c },
	{ 0x6c50, 0x214842 },
	{ 0x6c51, 0x23237d },
	{ 0x6c52, 0x22225a },
	{ 0x6c53, 0x232425 },
	{ 0x6c54, 0x22225e },
	{ 0x6c55, 0x214843 },
	{ 0x6c56, 0x232655 },
	{ 0x6c57, 0x21483e },
	{ 0x6c58, 0x23237c },
	{ 0x6c59, 0x21483f },
	{ 0x6c5a, 0x232423 },
	{ 0x6c5b, 0x214845 },
	{ 0x6c5c, 0x22225b },
	{ 0x6c5d, 0x21483d },
	{ 0x6c5e, 0x214a66 },
	{ 0x6c5f, 0x214840 },
	{ 0x6c60, 0x214841 },
	{ 0x6c61, 0x214844 },
	{ 0x6c62, 0x2f225d },
	{ 0x6c63, 0x23653c },
	{ 0x6c65, 0x22245b },
	{ 0x6c66, 0x222459 },
	{ 0x6c67, 0x22244c },
	{ 0x6c68, 0x214a72 },
	{ 0x6c69, 0x222453 },
	{ 0x6c6a, 0x214a6d },
	{ 0x6c6b, 0x22244d },
	{ 0x6c6c, 0x232964 },
	{ 0x6c6d, 0x222455 },
	{ 0x6c6e, 0x232650 },
	{ 0x6c6f, 0x222452 },
	{ 0x6c70, 0x214a70 },
	{ 0x6c71, 0x222451 },
	{ 0x6c72, 0x214a77 },
	{ 0x6c73, 0x22245a },
	{ 0x6c74, 0x214a79 },
	{ 0x6c75, 0x232653 },
	{ 0x6c76, 0x214a7b },
	{ 0x6c77, 0x23237e },
	{ 0x6c78, 0x22244b },
	{ 0x6c79, 0x232657 },
	{ 0x6c7a, 0x214a6e },
	{ 0x6c7b, 0x22245c },
	{ 0x6c7c, 0x232651 },
	{ 0x6c7d, 0x214a75 },
	{ 0x6c7e, 0x214a78 },
	{ 0x6c7f, 0x23264c },
	{ 0x6c80, 0x222765 },
	{ 0x6c81, 0x214a68 },
	{ 0x6c82, 0x214b21 },
	{ 0x6c83, 0x214a76 },
	{ 0x6c84, 0x22244e },
	{ 0x6c85, 0x214a6b },
	{ 0x6c86, 0x214a7a },
	{ 0x6c87, 0x222456 },
	{ 0x6c88, 0x214a69 },
	{ 0x6c89, 0x214a6a },
	{ 0x6c8a, 0x222763 },
	{ 0x6c8b, 0x22244f },
	{ 0x6c8c, 0x214a71 },
	{ 0x6c8d, 0x214a7c },
	{ 0x6c8e, 0x22245d },
	{ 0x6c8f, 0x222450 },
	{ 0x6c90, 0x214a6f },
	{ 0x6c91, 0x23264d },
	{ 0x6c92, 0x214a74 },
	{ 0x6c93, 0x22274f },
	{ 0x6c94, 0x214a7d },
	{ 0x6c95, 0x222457 },
	{ 0x6c96, 0x214a73 },
	{ 0x6c97, 0x232963 },
	{ 0x6c98, 0x214a7e },
	{ 0x6c99, 0x214a67 },
	{ 0x6c9a, 0x222454 },
	{ 0x6c9b, 0x214a6c },
	{ 0x6c9c, 0x222458 },
	{ 0x6c9d, 0x222764 },
	{ 0x6c9e, 0x23264e },
	{ 0x6c9f, 0x232652 },
	{ 0x6ca0, 0x23265c },
	{ 0x6ca1, 0x232659 },
	{ 0x6ca2, 0x232656 },
	{ 0x6ca3, 0x2f2468 },
	{ 0x6caa, 0x23265b },
	{ 0x6cab, 0x214e4d },
	{ 0x6cac, 0x214e5d },
	{ 0x6cad, 0x222756 },
	{ 0x6cae, 0x214e54 },
	{ 0x6caf, 0x232d4e },
	{ 0x6cb0, 0x22276b },
	{ 0x6cb1, 0x214e45 },
	{ 0x6cb2, 0x23296b },
	{ 0x6cb3, 0x214e48 },
	{ 0x6cb4, 0x222762 },
	{ 0x6cb5, 0x242726 },
	{ 0x6cb6, 0x222754 },
	{ 0x6cb7, 0x222758 },
	{ 0x6cb8, 0x214e50 },
	{ 0x6cb9, 0x214e52 },
	{ 0x6cba, 0x22275b },
	{ 0x6cbb, 0x214e59 },
	{ 0x6cbc, 0x214e4b },
	{ 0x6cbd, 0x214e49 },
	{ 0x6cbe, 0x214e4a },
	{ 0x6cbf, 0x214e58 },
	{ 0x6cc0, 0x222767 },
	{ 0x6cc1, 0x214e53 },
	{ 0x6cc2, 0x22275a },
	{ 0x6cc3, 0x22275c },
	{ 0x6cc4, 0x214e51 },
	{ 0x6cc5, 0x214e56 },
	{ 0x6cc6, 0x22275d },
	{ 0x6cc7, 0x22276a },
	{ 0x6cc8, 0x23296d },
	{ 0x6cc9, 0x215178 },
	{ 0x6cca, 0x214e5c },
	{ 0x6ccb, 0x24267d },
	{ 0x6ccc, 0x214e46 },
	{ 0x6ccd, 0x222769 },
	{ 0x6cce, 0x23296c },
	{ 0x6ccf, 0x22276d },
	{ 0x6cd0, 0x222759 },
	{ 0x6cd1, 0x22276f },
	{ 0x6cd2, 0x222760 },
	{ 0x6cd3, 0x214e4f },
	{ 0x6cd4, 0x222755 },
	{ 0x6cd5, 0x214e4e },
	{ 0x6cd6, 0x214e60 },
	{ 0x6cd7, 0x214e55 },
	{ 0x6cd8, 0x23296a },
	{ 0x6cd9, 0x222753 },
	{ 0x6cda, 0x222b57 },
	{ 0x6cdb, 0x214e5b },
	{ 0x6cdc, 0x214e5f },
	{ 0x6cdd, 0x222761 },
	{ 0x6cde, 0x222766 },
	{ 0x6cdf, 0x232965 },
	{ 0x6ce0, 0x214e61 },
	{ 0x6ce1, 0x214e5a },
	{ 0x6ce2, 0x214e4c },
	{ 0x6ce3, 0x214e42 },
	{ 0x6ce4, 0x232969 },
	{ 0x6ce5, 0x214e47 },
	{ 0x6ce6, 0x24267b },
	{ 0x6ce7, 0x222757 },
	{ 0x6ce8, 0x214e43 },
	{ 0x6ce9, 0x22276e },
	{ 0x6cea, 0x232967 },
	{ 0x6ceb, 0x222751 },
	{ 0x6cec, 0x222750 },
	{ 0x6ced, 0x22275e },
	{ 0x6cee, 0x222752 },
	{ 0x6cef, 0x214e5e },
	{ 0x6cf0, 0x215639 },
	{ 0x6cf1, 0x214e57 },
	{ 0x6cf2, 0x22275f },
	{ 0x6cf3, 0x214e44 },
	{ 0x6cf4, 0x232d4f },
	{ 0x6cf5, 0x215229 },
	{ 0x6cf9, 0x22276c },
	{ 0x6cff, 0x232d46 },
	{ 0x6d00, 0x222b5e },
	{ 0x6d01, 0x222b61 },
	{ 0x6d02, 0x232d50 },
	{ 0x6d03, 0x222b64 },
	{ 0x6d04, 0x222b59 },
	{ 0x6d05, 0x232d48 },
	{ 0x6d06, 0x232d4a },
	{ 0x6d07, 0x222b67 },
	{ 0x6d08, 0x222b6a },
	{ 0x6d09, 0x222b6c },
	{ 0x6d0a, 0x222b56 },
	{ 0x6d0b, 0x215179 },
	{ 0x6d0c, 0x21517e },
	{ 0x6d0d, 0x22302c },
	{ 0x6d0e, 0x215230 },
	{ 0x6d0f, 0x222b65 },
	{ 0x6d10, 0x222b6d },
	{ 0x6d11, 0x222b5d },
	{ 0x6d12, 0x222b55 },
	{ 0x6d13, 0x232d49 },
	{ 0x6d14, 0x232d47 },
	{ 0x6d15, 0x232d4d },
	{ 0x6d16, 0x223047 },
	{ 0x6d17, 0x215223 },
	{ 0x6d18, 0x222b62 },
	{ 0x6d19, 0x222b5a },
	{ 0x6d1a, 0x222b5c },
	{ 0x6d1b, 0x215228 },
	{ 0x6d1c, 0x23317a },
	{ 0x6d1d, 0x222b5f },
	{ 0x6d1e, 0x215222 },
	{ 0x6d1f, 0x222b52 },
	{ 0x6d20, 0x222b68 },
	{ 0x6d21, 0x232d4b },
	{ 0x6d22, 0x222b6b },
	{ 0x6d23, 0x232d45 },
	{ 0x6d24, 0x232d57 },
	{ 0x6d25, 0x21517d },
	{ 0x6d26, 0x232d53 },
	{ 0x6d27, 0x21522b },
	{ 0x6d28, 0x222b4f },
	{ 0x6d29, 0x21522d },
	{ 0x6d2a, 0x21517b },
	{ 0x6d2b, 0x215231 },
	{ 0x6d2c, 0x222b69 },
	{ 0x6d2d, 0x222b51 },
	{ 0x6d2e, 0x21522e },
	{ 0x6d2f, 0x223041 },
	{ 0x6d30, 0x222768 },
	{ 0x6d31, 0x215221 },
	{ 0x6d32, 0x21517a },
	{ 0x6d33, 0x222b58 },
	{ 0x6d34, 0x222b50 },
	{ 0x6d35, 0x21522f },
	{ 0x6d36, 0x215227 },
	{ 0x6d37, 0x222b63 },
	{ 0x6d38, 0x21522c },
	{ 0x6d39, 0x21522a },
	{ 0x6d3a, 0x222b5b },
	{ 0x6d3b, 0x215224 },
	{ 0x6d3c, 0x222b53 },
	{ 0x6d3d, 0x215225 },
	{ 0x6d3e, 0x215226 },
	{ 0x6d3f, 0x222b54 },
	{ 0x6d40, 0x222b66 },
	{ 0x6d41, 0x21517c },
	{ 0x6d42, 0x222b60 },
	{ 0x6d43, 0x242a21 },
	{ 0x6d44, 0x232d55 },
	{ 0x6d45, 0x232d51 },
	{ 0x6d56, 0x233177 },
	{ 0x6d57, 0x233173 },
	{ 0x6d58, 0x22302f },
	{ 0x6d59, 0x215641 },
	{ 0x6d5a, 0x215646 },
	{ 0x6d5b, 0x233179 },
	{ 0x6d5c, 0x233226 },
	{ 0x6d5d, 0x233176 },
	{ 0x6d5e, 0x223038 },
	{ 0x6d5f, 0x22303e },
	{ 0x6d60, 0x22303a },
	{ 0x6d61, 0x22302d },
	{ 0x6d62, 0x223030 },
	{ 0x6d63, 0x223029 },
	{ 0x6d64, 0x22302a },
	{ 0x6d65, 0x21564d },
	{ 0x6d66, 0x21563e },
	{ 0x6d67, 0x223039 },
	{ 0x6d68, 0x223042 },
	{ 0x6d69, 0x215648 },
	{ 0x6d6a, 0x21563a },
	{ 0x6d6b, 0x23316f },
	{ 0x6d6c, 0x215643 },
	{ 0x6d6d, 0x223031 },
	{ 0x6d6e, 0x215645 },
	{ 0x6d6f, 0x223032 },
	{ 0x6d70, 0x22303c },
	{ 0x6d71, 0x233222 },
	{ 0x6d72, 0x233225 },
	{ 0x6d73, 0x233172 },
	{ 0x6d74, 0x215647 },
	{ 0x6d75, 0x22304b },
	{ 0x6d76, 0x22302b },
	{ 0x6d77, 0x215640 },
	{ 0x6d78, 0x21563f },
	{ 0x6d79, 0x21564b },
	{ 0x6d7a, 0x223028 },
	{ 0x6d7b, 0x223049 },
	{ 0x6d7c, 0x22303d },
	{ 0x6d7d, 0x22304a },
	{ 0x6d7e, 0x223044 },
	{ 0x6d7f, 0x223036 },
	{ 0x6d80, 0x223045 },
	{ 0x6d81, 0x233221 },
	{ 0x6d82, 0x22303f },
	{ 0x6d83, 0x223048 },
	{ 0x6d84, 0x223046 },
	{ 0x6d85, 0x21564c },
	{ 0x6d86, 0x223037 },
	{ 0x6d87, 0x21563d },
	{ 0x6d88, 0x21563c },
	{ 0x6d89, 0x215644 },
	{ 0x6d8a, 0x21564a },
	{ 0x6d8b, 0x223043 },
	{ 0x6d8c, 0x215649 },
	{ 0x6d8d, 0x223034 },
	{ 0x6d8e, 0x215b48 },
	{ 0x6d8f, 0x233178 },
	{ 0x6d90, 0x22304c },
	{ 0x6d91, 0x223033 },
	{ 0x6d92, 0x22302e },
	{ 0x6d93, 0x215642 },
	{ 0x6d94, 0x21564e },
	{ 0x6d95, 0x21563b },
	{ 0x6d96, 0x233227 },
	{ 0x6d97, 0x22303b },
	{ 0x6d98, 0x223040 },
	{ 0x6d99, 0x23317d },
	{ 0x6d9a, 0x23317b },
	{ 0x6d9b, 0x23317c },
	{ 0x6da5, 0x23653d },
	{ 0x6daa, 0x215b6a },
	{ 0x6dab, 0x223645 },
	{ 0x6dac, 0x223649 },
	{ 0x6dad, 0x23366f },
	{ 0x6dae, 0x215b57 },
	{ 0x6daf, 0x215b55 },
	{ 0x6db0, 0x23367a },
	{ 0x6db1, 0x233721 },
	{ 0x6db2, 0x215b4c },
	{ 0x6db3, 0x223647 },
	{ 0x6db4, 0x223646 },
	{ 0x6db5, 0x215b60 },
	{ 0x6db6, 0x233c50 },
	{ 0x6db7, 0x22364c },
	{ 0x6db8, 0x215b5a },
	{ 0x6db9, 0x233672 },
	{ 0x6dba, 0x22365e },
	{ 0x6dbb, 0x22366a },
	{ 0x6dbc, 0x215b49 },
	{ 0x6dbd, 0x22365b },
	{ 0x6dbe, 0x223654 },
	{ 0x6dbf, 0x215b6c },
	{ 0x6dc0, 0x223644 },
	{ 0x6dc1, 0x23366a },
	{ 0x6dc2, 0x223660 },
	{ 0x6dc3, 0x23366b },
	{ 0x6dc4, 0x215b69 },
	{ 0x6dc5, 0x215b5d },
	{ 0x6dc6, 0x215b68 },
	{ 0x6dc7, 0x215b53 },
	{ 0x6dc8, 0x223650 },
	{ 0x6dc9, 0x223662 },
	{ 0x6dca, 0x22365a },
	{ 0x6dcb, 0x215b54 },
	{ 0x6dcc, 0x215b4e },
	{ 0x6dcd, 0x223668 },
	{ 0x6dce, 0x23366c },
	{ 0x6dcf, 0x223661 },
	{ 0x6dd0, 0x223663 },
	{ 0x6dd1, 0x215b56 },
	{ 0x6dd2, 0x215b5e },
	{ 0x6dd3, 0x223665 },
	{ 0x6dd4, 0x22364e },
	{ 0x6dd5, 0x22365f },
	{ 0x6dd6, 0x223653 },
	{ 0x6dd7, 0x223667 },
	{ 0x6dd8, 0x215b63 },
	{ 0x6dd9, 0x215b4b },
	{ 0x6dda, 0x215b61 },
	{ 0x6ddb, 0x223658 },
	{ 0x6ddc, 0x223656 },
	{ 0x6ddd, 0x223657 },
	{ 0x6dde, 0x215b58 },
	{ 0x6ddf, 0x223652 },
	{ 0x6de0, 0x223651 },
	{ 0x6de1, 0x215b4d },
	{ 0x6de2, 0x22364b },
	{ 0x6de3, 0x223669 },
	{ 0x6de4, 0x215b4f },
	{ 0x6de5, 0x223655 },
	{ 0x6de6, 0x215b6d },
	{ 0x6de7, 0x233674 },
	{ 0x6de8, 0x215b67 },
	{ 0x6de9, 0x22364a },
	{ 0x6dea, 0x215b64 },
	{ 0x6deb, 0x215b62 },
	{ 0x6dec, 0x215b6b },
	{ 0x6ded, 0x22365c },
	{ 0x6dee, 0x215b66 },
	{ 0x6def, 0x223035 },
	{ 0x6df0, 0x22365d },
	{ 0x6df1, 0x215b65 },
	{ 0x6df2, 0x223664 },
	{ 0x6df3, 0x215b4a },
	{ 0x6df4, 0x223659 },
	{ 0x6df5, 0x215b5c },
	{ 0x6df6, 0x22364d },
	{ 0x6df7, 0x215b5b },
	{ 0x6df8, 0x23367c },
	{ 0x6df9, 0x215b59 },
	{ 0x6dfa, 0x215b51 },
	{ 0x6dfb, 0x215b50 },
	{ 0x6dfc, 0x223d2c },
	{ 0x6dfd, 0x223666 },
	{ 0x6dfe, 0x233c5d },
	{ 0x6dff, 0x233728 },
	{ 0x6e00, 0x22364f },
	{ 0x6e01, 0x233726 },
	{ 0x6e02, 0x233723 },
	{ 0x6e03, 0x223d41 },
	{ 0x6e04, 0x233670 },
	{ 0x6e05, 0x215b52 },
	{ 0x6e06, 0x233677 },
	{ 0x6e07, 0x233724 },
	{ 0x6e08, 0x233676 },
	{ 0x6e09, 0x233725 },
	{ 0x6e0a, 0x233679 },
	{ 0x6e0b, 0x24326d },
	{ 0x6e0c, 0x23367d },
	{ 0x6e0f, 0x23653e },
	{ 0x6e12, 0x233729 },
	{ 0x6e15, 0x2f3629 },
	{ 0x6e17, 0x233727 },
	{ 0x6e18, 0x233c54 },
	{ 0x6e19, 0x216047 },
	{ 0x6e1a, 0x215b5f },
	{ 0x6e1b, 0x216035 },
	{ 0x6e1c, 0x223d3b },
	{ 0x6e1d, 0x216043 },
	{ 0x6e1e, 0x233c52 },
	{ 0x6e1f, 0x223d2f },
	{ 0x6e20, 0x216032 },
	{ 0x6e21, 0x21602e },
	{ 0x6e22, 0x223d4d },
	{ 0x6e23, 0x216034 },
	{ 0x6e24, 0x216038 },
	{ 0x6e25, 0x216033 },
	{ 0x6e26, 0x21603c },
	{ 0x6e27, 0x223d51 },
	{ 0x6e28, 0x223d48 },
	{ 0x6e29, 0x233c6b },
	{ 0x6e2a, 0x233c6d },
	{ 0x6e2b, 0x223d36 },
	{ 0x6e2c, 0x216041 },
	{ 0x6e2d, 0x21603b },
	{ 0x6e2e, 0x223d42 },
	{ 0x6e2f, 0x21602b },
	{ 0x6e30, 0x223d4e },
	{ 0x6e31, 0x223d47 },
	{ 0x6e32, 0x21602f },
	{ 0x6e33, 0x223d3c },
	{ 0x6e34, 0x21603e },
	{ 0x6e35, 0x223d59 },
	{ 0x6e36, 0x223d5a },
	{ 0x6e37, 0x24385b },
	{ 0x6e38, 0x21602c },
	{ 0x6e39, 0x223d4c },
	{ 0x6e3a, 0x216040 },
	{ 0x6e3b, 0x223d40 },
	{ 0x6e3c, 0x223d32 },
	{ 0x6e3d, 0x223d33 },
	{ 0x6e3e, 0x216044 },
	{ 0x6e3f, 0x223d37 },
	{ 0x6e40, 0x223d3e },
	{ 0x6e41, 0x223d38 },
	{ 0x6e42, 0x233c5a },
	{ 0x6e43, 0x216042 },
	{ 0x6e44, 0x21604a },
	{ 0x6e45, 0x223d34 },
	{ 0x6e46, 0x223d2d },
	{ 0x6e47, 0x223d2e },
	{ 0x6e48, 0x233c56 },
	{ 0x6e49, 0x223d30 },
	{ 0x6e4a, 0x216031 },
	{ 0x6e4b, 0x223d3d },
	{ 0x6e4c, 0x233c6e },
	{ 0x6e4d, 0x21603f },
	{ 0x6e4e, 0x216048 },
	{ 0x6e4f, 0x233c58 },
	{ 0x6e50, 0x233c69 },
	{ 0x6e51, 0x223d3f },
	{ 0x6e52, 0x223d57 },
	{ 0x6e53, 0x223d4f },
	{ 0x6e54, 0x21602d },
	{ 0x6e55, 0x223d55 },
	{ 0x6e56, 0x216039 },
	{ 0x6e57, 0x233c66 },
	{ 0x6e58, 0x216037 },
	{ 0x6e59, 0x233c64 },
	{ 0x6e5a, 0x223d5b },
	{ 0x6e5b, 0x216036 },
	{ 0x6e5c, 0x223d45 },
	{ 0x6e5d, 0x223d39 },
	{ 0x6e5e, 0x223d43 },
	{ 0x6e5f, 0x21604d },
	{ 0x6e60, 0x223d49 },
	{ 0x6e61, 0x223d46 },
	{ 0x6e62, 0x223d35 },
	{ 0x6e63, 0x216049 },
	{ 0x6e64, 0x223d53 },
	{ 0x6e65, 0x223d50 },
	{ 0x6e66, 0x223d58 },
	{ 0x6e67, 0x216030 },
	{ 0x6e68, 0x223d44 },
	{ 0x6e69, 0x21604c },
	{ 0x6e6a, 0x233c5b },
	{ 0x6e6b, 0x223d4b },
	{ 0x6e6c, 0x23423a },
	{ 0x6e6d, 0x233c60 },
	{ 0x6e6e, 0x21603a },
	{ 0x6e6f, 0x21603d },
	{ 0x6e70, 0x233c5c },
	{ 0x6e71, 0x223d4a },
	{ 0x6e72, 0x21604b },
	{ 0x6e73, 0x223d3a },
	{ 0x6e74, 0x223648 },
	{ 0x6e75, 0x233c51 },
	{ 0x6e76, 0x233c6c },
	{ 0x6e77, 0x223d54 },
	{ 0x6e78, 0x223d52 },
	{ 0x6e79, 0x223d56 },
	{ 0x6e7a, 0x2f3c5d },
	{ 0x6e7b, 0x233c62 },
	{ 0x6e7c, 0x236542 },
	{ 0x6e7d, 0x24385e },
	{ 0x6e7e, 0x233c63 },
	{ 0x6e80, 0x233c68 },
	{ 0x6e82, 0x2f3c47 },
	{ 0x6e84, 0x236540 },
	{ 0x6e86, 0x24385f },
	{ 0x6e88, 0x223d31 },
	{ 0x6e89, 0x216046 },
	{ 0x6e8a, 0x23653f },
	{ 0x6e8b, 0x236541 },
	{ 0x6e8d, 0x224447 },
	{ 0x6e8e, 0x224446 },
	{ 0x6e8f, 0x22442c },
	{ 0x6e90, 0x216463 },
	{ 0x6e91, 0x234230 },
	{ 0x6e92, 0x224445 },
	{ 0x6e93, 0x22442f },
	{ 0x6e94, 0x224430 },
	{ 0x6e95, 0x243e3f },
	{ 0x6e96, 0x21646d },
	{ 0x6e97, 0x22444e },
	{ 0x6e98, 0x216468 },
	{ 0x6e99, 0x224444 },
	{ 0x6e9a, 0x234233 },
	{ 0x6e9b, 0x224429 },
	{ 0x6e9c, 0x21646e },
	{ 0x6e9d, 0x216464 },
	{ 0x6e9e, 0x224438 },
	{ 0x6e9f, 0x22442e },
	{ 0x6ea0, 0x224431 },
	{ 0x6ea1, 0x224449 },
	{ 0x6ea2, 0x21645e },
	{ 0x6ea3, 0x224450 },
	{ 0x6ea4, 0x224448 },
	{ 0x6ea5, 0x216467 },
	{ 0x6ea6, 0x22443d },
	{ 0x6ea7, 0x216472 },
	{ 0x6ea8, 0x23422e },
	{ 0x6ea9, 0x234236 },
	{ 0x6eaa, 0x216471 },
	{ 0x6eab, 0x21646b },
	{ 0x6eac, 0x234240 },
	{ 0x6ead, 0x243e36 },
	{ 0x6eae, 0x22444f },
	{ 0x6eaf, 0x21645f },
	{ 0x6eb0, 0x22443b },
	{ 0x6eb1, 0x224432 },
	{ 0x6eb2, 0x22443f },
	{ 0x6eb3, 0x22444b },
	{ 0x6eb4, 0x216473 },
	{ 0x6eb5, 0x234239 },
	{ 0x6eb6, 0x216461 },
	{ 0x6eb7, 0x22443a },
	{ 0x6eb8, 0x23422d },
	{ 0x6eb9, 0x224433 },
	{ 0x6eba, 0x21646a },
	{ 0x6ebb, 0x234231 },
	{ 0x6ebc, 0x216469 },
	{ 0x6ebd, 0x224436 },
	{ 0x6ebe, 0x224440 },
	{ 0x6ebf, 0x22444a },
	{ 0x6ec0, 0x22442d },
	{ 0x6ec1, 0x224437 },
	{ 0x6ec2, 0x216462 },
	{ 0x6ec3, 0x224441 },
	{ 0x6ec4, 0x21646f },
	{ 0x6ec5, 0x216466 },
	{ 0x6ec6, 0x224434 },
	{ 0x6ec7, 0x216465 },
	{ 0x6ec8, 0x22442b },
	{ 0x6ec9, 0x224439 },
	{ 0x6eca, 0x22444d },
	{ 0x6ecb, 0x216045 },
	{ 0x6ecc, 0x216957 },
	{ 0x6ecd, 0x22443c },
	{ 0x6ece, 0x224b34 },
	{ 0x6ecf, 0x22443e },
	{ 0x6ed0, 0x22444c },
	{ 0x6ed1, 0x21646c },
	{ 0x6ed2, 0x224435 },
	{ 0x6ed3, 0x216460 },
	{ 0x6ed4, 0x216470 },
	{ 0x6ed5, 0x216d5a },
	{ 0x6ed6, 0x22442a },
	{ 0x6ed7, 0x26544e },
	{ 0x6ed8, 0x224443 },
	{ 0x6ed9, 0x234244 },
	{ 0x6eda, 0x23423e },
	{ 0x6edb, 0x234247 },
	{ 0x6edc, 0x224442 },
	{ 0x6edd, 0x23423d },
	{ 0x6ee3, 0x234245 },
	{ 0x6ee6, 0x23423f },
	{ 0x6ee8, 0x23423b },
	{ 0x6ee9, 0x234246 },
	{ 0x6eeb, 0x224b50 },
	{ 0x6eec, 0x216954 },
	{ 0x6eed, 0x224b45 },
	{ 0x6eee, 0x224b4a },
	{ 0x6eef, 0x216949 },
	{ 0x6ef0, 0x234756 },
	{ 0x6ef1, 0x224b36 },
	{ 0x6ef2, 0x216956 },
	{ 0x6ef3, 0x234757 },
	{ 0x6ef4, 0x216940 },
	{ 0x6ef5, 0x224b35 },
	{ 0x6ef6, 0x224b56 },
	{ 0x6ef7, 0x216958 },
	{ 0x6ef8, 0x224b39 },
	{ 0x6ef9, 0x224b49 },
	{ 0x6efa, 0x234765 },
	{ 0x6efb, 0x224b3b },
	{ 0x6efc, 0x224b59 },
	{ 0x6efd, 0x224b55 },
	{ 0x6efe, 0x21693e },
	{ 0x6eff, 0x216948 },
	{ 0x6f00, 0x22515b },
	{ 0x6f01, 0x216955 },
	{ 0x6f02, 0x216946 },
	{ 0x6f03, 0x224b37 },
	{ 0x6f04, 0x234763 },
	{ 0x6f05, 0x224b54 },
	{ 0x6f06, 0x21694a },
	{ 0x6f07, 0x224b51 },
	{ 0x6f08, 0x224b5e },
	{ 0x6f09, 0x224b3d },
	{ 0x6f0a, 0x224b46 },
	{ 0x6f0b, 0x234c78 },
	{ 0x6f0c, 0x23475b },
	{ 0x6f0d, 0x224b5c },
	{ 0x6f0e, 0x224b52 },
	{ 0x6f0f, 0x216945 },
	{ 0x6f10, 0x234c6a },
	{ 0x6f11, 0x234764 },
	{ 0x6f12, 0x224b44 },
	{ 0x6f13, 0x21693f },
	{ 0x6f14, 0x21693d },
	{ 0x6f15, 0x21694f },
	{ 0x6f16, 0x244443 },
	{ 0x6f17, 0x23475f },
	{ 0x6f18, 0x224b42 },
	{ 0x6f19, 0x224b3f },
	{ 0x6f1a, 0x224b40 },
	{ 0x6f1b, 0x23475a },
	{ 0x6f1c, 0x224b58 },
	{ 0x6f1d, 0x23475c },
	{ 0x6f1e, 0x224b5d },
	{ 0x6f1f, 0x224b5b },
	{ 0x6f20, 0x216943 },
	{ 0x6f21, 0x224b5f },
	{ 0x6f22, 0x216947 },
	{ 0x6f23, 0x21694e },
	{ 0x6f24, 0x244444 },
	{ 0x6f25, 0x224b38 },
	{ 0x6f26, 0x225143 },
	{ 0x6f27, 0x224b41 },
	{ 0x6f28, 0x23475e },
	{ 0x6f29, 0x216941 },
	{ 0x6f2a, 0x216953 },
	{ 0x6f2b, 0x216950 },
	{ 0x6f2c, 0x216944 },
	{ 0x6f2d, 0x224b4b },
	{ 0x6f2e, 0x224b3c },
	{ 0x6f2f, 0x216951 },
	{ 0x6f30, 0x224b4d },
	{ 0x6f31, 0x21694b },
	{ 0x6f32, 0x21694d },
	{ 0x6f33, 0x21693c },
	{ 0x6f34, 0x23475d },
	{ 0x6f35, 0x224b4f },
	{ 0x6f36, 0x224b47 },
	{ 0x6f37, 0x224b3a },
	{ 0x6f38, 0x21694c },
	{ 0x6f39, 0x224b57 },
	{ 0x6f3a, 0x224b5a },
	{ 0x6f3b, 0x224b43 },
	{ 0x6f3c, 0x224b4e },
	{ 0x6f3d, 0x234c74 },
	{ 0x6f3e, 0x216942 },
	{ 0x6f3f, 0x216d49 },
	{ 0x6f40, 0x224b4c },
	{ 0x6f41, 0x225142 },
	{ 0x6f42, 0x234762 },
	{ 0x6f43, 0x224b53 },
	{ 0x6f44, 0x234761 },
	{ 0x6f45, 0x244452 },
	{ 0x6f46, 0x2f4f79 },
	{ 0x6f48, 0x236544 },
	{ 0x6f49, 0x236545 },
	{ 0x6f4a, 0x234766 },
	{ 0x6f4c, 0x236543 },
	{ 0x6f4e, 0x224b3e },
	{ 0x6f4f, 0x22514c },
	{ 0x6f50, 0x225156 },
	{ 0x6f51, 0x216d4c },
	{ 0x6f52, 0x225155 },
	{ 0x6f53, 0x225161 },
	{ 0x6f54, 0x216d4e },
	{ 0x6f55, 0x225153 },
	{ 0x6f56, 0x244a58 },
	{ 0x6f57, 0x225157 },
	{ 0x6f58, 0x216d59 },
	{ 0x6f59, 0x234c7d },
	{ 0x6f5a, 0x22514e },
	{ 0x6f5b, 0x216d51 },
	{ 0x6f5c, 0x234c73 },
	{ 0x6f5d, 0x22515a },
	{ 0x6f5e, 0x22577b },
	{ 0x6f5f, 0x216d5d },
	{ 0x6f60, 0x216d5c },
	{ 0x6f61, 0x22515c },
	{ 0x6f62, 0x22514b },
	{ 0x6f63, 0x225166 },
	{ 0x6f64, 0x216d57 },
	{ 0x6f65, 0x234c6b },
	{ 0x6f66, 0x216d4d },
	{ 0x6f67, 0x22515f },
	{ 0x6f68, 0x244a69 },
	{ 0x6f69, 0x225163 },
	{ 0x6f6a, 0x225168 },
	{ 0x6f6b, 0x22515d },
	{ 0x6f6c, 0x225151 },
	{ 0x6f6d, 0x216d50 },
	{ 0x6f6e, 0x216d53 },
	{ 0x6f6f, 0x216d5b },
	{ 0x6f70, 0x216d56 },
	{ 0x6f71, 0x234c75 },
	{ 0x6f72, 0x225154 },
	{ 0x6f73, 0x224b48 },
	{ 0x6f74, 0x234c7e },
	{ 0x6f75, 0x234c6c },
	{ 0x6f76, 0x225150 },
	{ 0x6f77, 0x225167 },
	{ 0x6f78, 0x216d52 },
	{ 0x6f79, 0x234c79 },
	{ 0x6f7a, 0x216d55 },
	{ 0x6f7b, 0x225169 },
	{ 0x6f7c, 0x216d4a },
	{ 0x6f7d, 0x22515e },
	{ 0x6f7e, 0x225144 },
	{ 0x6f7f, 0x225164 },
	{ 0x6f80, 0x21742a },
	{ 0x6f81, 0x234c7a },
	{ 0x6f82, 0x225152 },
	{ 0x6f83, 0x245075 },
	{ 0x6f84, 0x216d4b },
	{ 0x6f85, 0x22514d },
	{ 0x6f86, 0x216d4f },
	{ 0x6f87, 0x225145 },
	{ 0x6f88, 0x216952 },
	{ 0x6f89, 0x225149 },
	{ 0x6f8a, 0x244a57 },
	{ 0x6f8b, 0x225162 },
	{ 0x6f8c, 0x22514a },
	{ 0x6f8d, 0x225148 },
	{ 0x6f8e, 0x216d54 },
	{ 0x6f8f, 0x234c7b },
	{ 0x6f90, 0x225160 },
	{ 0x6f91, 0x234c77 },
	{ 0x6f92, 0x225147 },
	{ 0x6f93, 0x225159 },
	{ 0x6f94, 0x225158 },
	{ 0x6f95, 0x225165 },
	{ 0x6f96, 0x22514f },
	{ 0x6f97, 0x216d58 },
	{ 0x6f98, 0x244a64 },
	{ 0x6f99, 0x236547 },
	{ 0x6f9a, 0x2f4f7d },
	{ 0x6f9d, 0x236546 },
	{ 0x6f9e, 0x22577e },
	{ 0x6f9f, 0x235156 },
	{ 0x6fa0, 0x217133 },
	{ 0x6fa1, 0x217129 },
	{ 0x6fa2, 0x22582c },
	{ 0x6fa3, 0x225776 },
	{ 0x6fa4, 0x21712b },
	{ 0x6fa5, 0x225824 },
	{ 0x6fa6, 0x217132 },
	{ 0x6fa7, 0x21712d },
	{ 0x6fa8, 0x225822 },
	{ 0x6fa9, 0x225d3b },
	{ 0x6faa, 0x225828 },
	{ 0x6fab, 0x22582e },
	{ 0x6fac, 0x225827 },
	{ 0x6fad, 0x225774 },
	{ 0x6fae, 0x225825 },
	{ 0x6faf, 0x225830 },
	{ 0x6fb0, 0x225832 },
	{ 0x6fb1, 0x217128 },
	{ 0x6fb2, 0x225831 },
	{ 0x6fb3, 0x21712e },
	{ 0x6fb4, 0x217134 },
	{ 0x6fb5, 0x235154 },
	{ 0x6fb6, 0x217131 },
	{ 0x6fb7, 0x235158 },
	{ 0x6fb8, 0x22582b },
	{ 0x6fb9, 0x217130 },
	{ 0x6fba, 0x225826 },
	{ 0x6fbb, 0x23514d },
	{ 0x6fbc, 0x225778 },
	{ 0x6fbd, 0x22577d },
	{ 0x6fbe, 0x235150 },
	{ 0x6fbf, 0x22582a },
	{ 0x6fc0, 0x21712f },
	{ 0x6fc1, 0x21712c },
	{ 0x6fc2, 0x217127 },
	{ 0x6fc3, 0x21712a },
	{ 0x6fc4, 0x22577c },
	{ 0x6fc5, 0x245122 },
	{ 0x6fc6, 0x225146 },
	{ 0x6fc7, 0x225777 },
	{ 0x6fc8, 0x22577a },
	{ 0x6fc9, 0x22582d },
	{ 0x6fca, 0x225821 },
	{ 0x6fcb, 0x225775 },
	{ 0x6fcc, 0x225d3a },
	{ 0x6fcd, 0x22582f },
	{ 0x6fce, 0x225779 },
	{ 0x6fcf, 0x225829 },
	{ 0x6fd0, 0x234c71 },
	{ 0x6fd3, 0x235155 },
	{ 0x6fd4, 0x225d3d },
	{ 0x6fd5, 0x21742e },
	{ 0x6fd6, 0x235530 },
	{ 0x6fd7, 0x23552f },
	{ 0x6fd8, 0x217422 },
	{ 0x6fd9, 0x235535 },
	{ 0x6fda, 0x235536 },
	{ 0x6fdb, 0x217426 },
	{ 0x6fdc, 0x225d3f },
	{ 0x6fdd, 0x225d45 },
	{ 0x6fde, 0x225d43 },
	{ 0x6fdf, 0x217424 },
	{ 0x6fe0, 0x217425 },
	{ 0x6fe1, 0x21742c },
	{ 0x6fe2, 0x225d46 },
	{ 0x6fe3, 0x225d3e },
	{ 0x6fe4, 0x217427 },
	{ 0x6fe5, 0x235531 },
	{ 0x6fe6, 0x225d42 },
	{ 0x6fe7, 0x225d41 },
	{ 0x6fe8, 0x225d47 },
	{ 0x6fe9, 0x21742d },
	{ 0x6fea, 0x235537 },
	{ 0x6feb, 0x217428 },
	{ 0x6fec, 0x21742b },
	{ 0x6fed, 0x225d40 },
	{ 0x6fee, 0x21742f },
	{ 0x6fef, 0x217429 },
	{ 0x6ff0, 0x217430 },
	{ 0x6ff1, 0x217423 },
	{ 0x6ff2, 0x225d44 },
	{ 0x6ff3, 0x235a55 },
	{ 0x6ff4, 0x225d3c },
	{ 0x6ff5, 0x235159 },
	{ 0x6ff6, 0x235539 },
	{ 0x6ff7, 0x226225 },
	{ 0x6ff8, 0x236548 },
	{ 0x6ffa, 0x21765d },
	{ 0x6ffb, 0x226222 },
	{ 0x6ffc, 0x226224 },
	{ 0x6ffd, 0x235828 },
	{ 0x6ffe, 0x21765b },
	{ 0x6fff, 0x22617e },
	{ 0x7000, 0x226221 },
	{ 0x7001, 0x22617a },
	{ 0x7002, 0x23582a },
	{ 0x7003, 0x235827 },
	{ 0x7004, 0x225823 },
	{ 0x7005, 0x22617b },
	{ 0x7006, 0x21765c },
	{ 0x7007, 0x226177 },
	{ 0x7008, 0x235826 },
	{ 0x7009, 0x217659 },
	{ 0x700a, 0x226226 },
	{ 0x700b, 0x21765a },
	{ 0x700c, 0x226178 },
	{ 0x700d, 0x226179 },
	{ 0x700e, 0x22617d },
	{ 0x700f, 0x21765f },
	{ 0x7010, 0x235829 },
	{ 0x7011, 0x21765e },
	{ 0x7012, 0x245b5e },
	{ 0x7013, 0x23582b },
	{ 0x7014, 0x22617c },
	{ 0x7015, 0x217845 },
	{ 0x7016, 0x22656a },
	{ 0x7017, 0x226570 },
	{ 0x7018, 0x217846 },
	{ 0x7019, 0x226567 },
	{ 0x701a, 0x217843 },
	{ 0x701b, 0x217840 },
	{ 0x701c, 0x226572 },
	{ 0x701d, 0x217844 },
	{ 0x701e, 0x235a52 },
	{ 0x701f, 0x217841 },
	{ 0x7020, 0x226569 },
	{ 0x7021, 0x22656c },
	{ 0x7022, 0x22656d },
	{ 0x7023, 0x22656e },
	{ 0x7024, 0x226571 },
	{ 0x7025, 0x235a54 },
	{ 0x7026, 0x226223 },
	{ 0x7027, 0x226568 },
	{ 0x7028, 0x217842 },
	{ 0x7029, 0x22656f },
	{ 0x702a, 0x226934 },
	{ 0x702b, 0x22656b },
	{ 0x702c, 0x235a53 },
	{ 0x702d, 0x23654a },
	{ 0x702e, 0x236549 },
	{ 0x702f, 0x22692b },
	{ 0x7030, 0x217975 },
	{ 0x7031, 0x22692e },
	{ 0x7032, 0x217976 },
	{ 0x7033, 0x226937 },
	{ 0x7034, 0x22692d },
	{ 0x7035, 0x22692a },
	{ 0x7036, 0x235c51 },
	{ 0x7037, 0x22692c },
	{ 0x7038, 0x226930 },
	{ 0x7039, 0x226933 },
	{ 0x703a, 0x226932 },
	{ 0x703b, 0x226936 },
	{ 0x703c, 0x226929 },
	{ 0x703d, 0x235c4f },
	{ 0x703e, 0x217974 },
	{ 0x703f, 0x226931 },
	{ 0x7040, 0x226935 },
	{ 0x7041, 0x226938 },
	{ 0x7042, 0x22692f },
	{ 0x7043, 0x226b61 },
	{ 0x7044, 0x226b62 },
	{ 0x7045, 0x226b66 },
	{ 0x7046, 0x226b67 },
	{ 0x7047, 0x235e3c },
	{ 0x7048, 0x226b64 },
	{ 0x7049, 0x226b65 },
	{ 0x704a, 0x226b63 },
	{ 0x704b, 0x235e3a },
	{ 0x704c, 0x217a74 },
	{ 0x704d, 0x235e3b },
	{ 0x7051, 0x217b64 },
	{ 0x7052, 0x226d59 },
	{ 0x7053, 0x236036 },
	{ 0x7054, 0x235f52 },
	{ 0x7055, 0x226d56 },
	{ 0x7056, 0x226d57 },
	{ 0x7057, 0x226d58 },
	{ 0x7058, 0x217b65 },
	{ 0x7059, 0x236037 },
	{ 0x705a, 0x226f34 },
	{ 0x705b, 0x226f33 },
	{ 0x705c, 0x23654b },
	{ 0x705d, 0x22703d },
	{ 0x705e, 0x217c60 },
	{ 0x705f, 0x22703b },
	{ 0x7060, 0x22703e },
	{ 0x7061, 0x22703c },
	{ 0x7062, 0x227125 },
	{ 0x7063, 0x217d24 },
	{ 0x7064, 0x217d32 },
	{ 0x7065, 0x227171 },
	{ 0x7066, 0x22715b },
	{ 0x7067, 0x236179 },
	{ 0x7068, 0x227170 },
	{ 0x7069, 0x22723e },
	{ 0x706a, 0x22723f },
	{ 0x706b, 0x214556 },
	{ 0x706c, 0x242150 },
	{ 0x706e, 0x232428 },
	{ 0x706f, 0x232426 },
	{ 0x7070, 0x214848 },
	{ 0x7071, 0x222261 },
	{ 0x7072, 0x232427 },
	{ 0x7073, 0x23242b },
	{ 0x7074, 0x22245e },
	{ 0x7075, 0x232662 },
	{ 0x7076, 0x214b22 },
	{ 0x7077, 0x23265f },
	{ 0x7078, 0x214b25 },
	{ 0x7079, 0x23265e },
	{ 0x707a, 0x22245f },
	{ 0x707b, 0x232663 },
	{ 0x707c, 0x214b23 },
	{ 0x707d, 0x214b24 },
	{ 0x707e, 0x232660 },
	{ 0x707f, 0x2f2471 },
	{ 0x7081, 0x232977 },
	{ 0x7082, 0x222778 },
	{ 0x7083, 0x22277a },
	{ 0x7084, 0x222775 },
	{ 0x7085, 0x222772 },
	{ 0x7086, 0x222774 },
	{ 0x7087, 0x232974 },
	{ 0x7088, 0x232970 },
	{ 0x7089, 0x232975 },
	{ 0x708a, 0x214e65 },
	{ 0x708b, 0x23296f },
	{ 0x708c, 0x232979 },
	{ 0x708d, 0x232976 },
	{ 0x708e, 0x214e63 },
	{ 0x708f, 0x232972 },
	{ 0x7090, 0x232971 },
	{ 0x7091, 0x222776 },
	{ 0x7092, 0x214e64 },
	{ 0x7093, 0x222773 },
	{ 0x7094, 0x222770 },
	{ 0x7095, 0x214e62 },
	{ 0x7096, 0x222777 },
	{ 0x7097, 0x242729 },
	{ 0x7098, 0x222771 },
	{ 0x7099, 0x214e66 },
	{ 0x709a, 0x222779 },
	{ 0x709b, 0x24272b },
	{ 0x709f, 0x222b6f },
	{ 0x70a0, 0x232d5e },
	{ 0x70a1, 0x222b73 },
	{ 0x70a2, 0x232d5c },
	{ 0x70a3, 0x232d5a },
	{ 0x70a4, 0x21523a },
	{ 0x70a5, 0x232d58 },
	{ 0x70a6, 0x242a26 },
	{ 0x70a7, 0x232d65 },
	{ 0x70a8, 0x232d62 },
	{ 0x70a9, 0x222b76 },
	{ 0x70aa, 0x232d5f },
	{ 0x70ab, 0x215232 },
	{ 0x70ac, 0x215235 },
	{ 0x70ad, 0x215237 },
	{ 0x70ae, 0x215239 },
	{ 0x70af, 0x215236 },
	{ 0x70b0, 0x222b72 },
	{ 0x70b1, 0x222b71 },
	{ 0x70b2, 0x232d64 },
	{ 0x70b3, 0x215234 },
	{ 0x70b4, 0x222b74 },
	{ 0x70b5, 0x222b75 },
	{ 0x70b6, 0x232d63 },
	{ 0x70b7, 0x222b6e },
	{ 0x70b8, 0x215238 },
	{ 0x70b9, 0x232d68 },
	{ 0x70ba, 0x215233 },
	{ 0x70bb, 0x232d5d },
	{ 0x70be, 0x222b70 },
	{ 0x70bf, 0x23654d },
	{ 0x70c0, 0x242a28 },
	{ 0x70c4, 0x233228 },
	{ 0x70c5, 0x22305a },
	{ 0x70c6, 0x22305b },
	{ 0x70c7, 0x22305c },
	{ 0x70c8, 0x215653 },
	{ 0x70c9, 0x242d75 },
	{ 0x70ca, 0x21564f },
	{ 0x70cb, 0x223051 },
	{ 0x70cc, 0x23322a },
	{ 0x70cd, 0x223059 },
	{ 0x70ce, 0x22305e },
	{ 0x70cf, 0x215654 },
	{ 0x70d0, 0x23322b },
	{ 0x70d1, 0x22304f },
	{ 0x70d2, 0x223055 },
	{ 0x70d3, 0x22304e },
	{ 0x70d4, 0x223058 },
	{ 0x70d5, 0x233231 },
	{ 0x70d6, 0x23322f },
	{ 0x70d7, 0x223054 },
	{ 0x70d8, 0x215650 },
	{ 0x70d9, 0x215652 },
	{ 0x70da, 0x22305d },
	{ 0x70db, 0x233229 },
	{ 0x70dc, 0x22304d },
	{ 0x70dd, 0x223050 },
	{ 0x70de, 0x223056 },
	{ 0x70df, 0x23322d },
	{ 0x70e0, 0x223057 },
	{ 0x70e1, 0x22305f },
	{ 0x70e2, 0x223053 },
	{ 0x70e3, 0x23322c },
	{ 0x70e4, 0x215651 },
	{ 0x70e5, 0x23654f },
	{ 0x70ea, 0x23654e },
	{ 0x70ee, 0x233230 },
	{ 0x70ef, 0x215b72 },
	{ 0x70f0, 0x223671 },
	{ 0x70f1, 0x233730 },
	{ 0x70f2, 0x233732 },
	{ 0x70f3, 0x223673 },
	{ 0x70f4, 0x22366f },
	{ 0x70f5, 0x23372f },
	{ 0x70f6, 0x22367b },
	{ 0x70f7, 0x22366d },
	{ 0x70f8, 0x22367a },
	{ 0x70f9, 0x215b6e },
	{ 0x70fa, 0x22366b },
	{ 0x70fb, 0x223d5f },
	{ 0x70fc, 0x223675 },
	{ 0x70fd, 0x215b71 },
	{ 0x70fe, 0x233735 },
	{ 0x70ff, 0x223676 },
	{ 0x7100, 0x223679 },
	{ 0x7101, 0x23372e },
	{ 0x7102, 0x22367d },
	{ 0x7103, 0x23372c },
	{ 0x7104, 0x223672 },
	{ 0x7105, 0x243272 },
	{ 0x7106, 0x223677 },
	{ 0x7107, 0x23372d },
	{ 0x7108, 0x233731 },
	{ 0x7109, 0x215b6f },
	{ 0x710a, 0x215b70 },
	{ 0x710b, 0x22367c },
	{ 0x710c, 0x223670 },
	{ 0x710d, 0x22366c },
	{ 0x710e, 0x22367e },
	{ 0x710f, 0x233733 },
	{ 0x7110, 0x223674 },
	{ 0x7111, 0x236550 },
	{ 0x7112, 0x236551 },
	{ 0x7113, 0x223678 },
	{ 0x7117, 0x22366e },
	{ 0x7119, 0x21604e },
	{ 0x711a, 0x21604f },
	{ 0x711b, 0x223d69 },
	{ 0x711c, 0x216055 },
	{ 0x711d, 0x233c74 },
	{ 0x711e, 0x223d5d },
	{ 0x711f, 0x223d66 },
	{ 0x7120, 0x223d5c },
	{ 0x7121, 0x216052 },
	{ 0x7122, 0x223d64 },
	{ 0x7123, 0x223d62 },
	{ 0x7124, 0x233c7d },
	{ 0x7125, 0x223d63 },
	{ 0x7126, 0x216050 },
	{ 0x7127, 0x233c7c },
	{ 0x7128, 0x223d67 },
	{ 0x7129, 0x2f3c7e },
	{ 0x712a, 0x233c6f },
	{ 0x712b, 0x233c7a },
	{ 0x712c, 0x233c72 },
	{ 0x712d, 0x233d21 },
	{ 0x712e, 0x223d60 },
	{ 0x712f, 0x223d5e },
	{ 0x7130, 0x216051 },
	{ 0x7131, 0x223d61 },
	{ 0x7132, 0x223d65 },
	{ 0x7133, 0x233c7b },
	{ 0x7134, 0x233c79 },
	{ 0x7135, 0x233c71 },
	{ 0x7136, 0x216053 },
	{ 0x7137, 0x233c73 },
	{ 0x7138, 0x233c77 },
	{ 0x7139, 0x236553 },
	{ 0x713a, 0x223d68 },
	{ 0x713b, 0x236554 },
	{ 0x713d, 0x236555 },
	{ 0x713f, 0x236552 },
	{ 0x7141, 0x224456 },
	{ 0x7142, 0x22445d },
	{ 0x7143, 0x22445f },
	{ 0x7144, 0x224465 },
	{ 0x7145, 0x234257 },
	{ 0x7146, 0x216522 },
	{ 0x7147, 0x224451 },
	{ 0x7148, 0x23424c },
	{ 0x7149, 0x216478 },
	{ 0x714a, 0x23424e },
	{ 0x714b, 0x224460 },
	{ 0x714c, 0x21647d },
	{ 0x714d, 0x224466 },
	{ 0x714e, 0x216474 },
	{ 0x714f, 0x234251 },
	{ 0x7150, 0x224463 },
	{ 0x7151, 0x234258 },
	{ 0x7152, 0x224453 },
	{ 0x7153, 0x224464 },
	{ 0x7154, 0x224452 },
	{ 0x7156, 0x216524 },
	{ 0x7157, 0x234252 },
	{ 0x7158, 0x22445e },
	{ 0x7159, 0x216475 },
	{ 0x715a, 0x224467 },
	{ 0x715b, 0x23483c },
	{ 0x715c, 0x21647a },
	{ 0x715d, 0x224457 },
	{ 0x715e, 0x216521 },
	{ 0x715f, 0x224462 },
	{ 0x7160, 0x224455 },
	{ 0x7161, 0x22445c },
	{ 0x7162, 0x224458 },
	{ 0x7163, 0x224454 },
	{ 0x7164, 0x216477 },
	{ 0x7165, 0x21647e },
	{ 0x7166, 0x21647c },
	{ 0x7167, 0x216479 },
	{ 0x7168, 0x216523 },
	{ 0x7169, 0x216476 },
	{ 0x716a, 0x22445b },
	{ 0x716b, 0x23424f },
	{ 0x716c, 0x21647b },
	{ 0x716d, 0x234259 },
	{ 0x716e, 0x216054 },
	{ 0x716f, 0x234249 },
	{ 0x7170, 0x224461 },
	{ 0x7171, 0x236559 },
	{ 0x7172, 0x224459 },
	{ 0x7174, 0x234253 },
	{ 0x7175, 0x236557 },
	{ 0x7176, 0x236558 },
	{ 0x7177, 0x236556 },
	{ 0x7178, 0x22445a },
	{ 0x7179, 0x244457 },
	{ 0x717a, 0x24445b },
	{ 0x717b, 0x224b67 },
	{ 0x717c, 0x23476f },
	{ 0x717d, 0x21695b },
	{ 0x717e, 0x23476e },
	{ 0x717f, 0x23476c },
	{ 0x7180, 0x224b63 },
	{ 0x7181, 0x224b69 },
	{ 0x7182, 0x224b65 },
	{ 0x7183, 0x234770 },
	{ 0x7184, 0x21695d },
	{ 0x7185, 0x224b64 },
	{ 0x7186, 0x224b68 },
	{ 0x7187, 0x224b60 },
	{ 0x7188, 0x234772 },
	{ 0x7189, 0x224b62 },
	{ 0x718a, 0x21695c },
	{ 0x718b, 0x23476a },
	{ 0x718c, 0x23476d },
	{ 0x718d, 0x23476b },
	{ 0x718e, 0x234768 },
	{ 0x718f, 0x224b66 },
	{ 0x7190, 0x224b61 },
	{ 0x7191, 0x234767 },
	{ 0x7192, 0x21695e },
	{ 0x7193, 0x23655b },
	{ 0x7194, 0x216959 },
	{ 0x7195, 0x2f494b },
	{ 0x7196, 0x23655a },
	{ 0x7197, 0x224b6a },
	{ 0x7198, 0x2f495f },
	{ 0x7199, 0x21695a },
	{ 0x719a, 0x22516f },
	{ 0x719b, 0x22516c },
	{ 0x719c, 0x225178 },
	{ 0x719d, 0x225172 },
	{ 0x719e, 0x225174 },
	{ 0x719f, 0x216d5e },
	{ 0x71a0, 0x22516e },
	{ 0x71a1, 0x225176 },
	{ 0x71a2, 0x234d2a },
	{ 0x71a3, 0x234d24 },
	{ 0x71a4, 0x225175 },
	{ 0x71a5, 0x225173 },
	{ 0x71a6, 0x234d29 },
	{ 0x71a7, 0x225179 },
	{ 0x71a8, 0x216d61 },
	{ 0x71a9, 0x225170 },
	{ 0x71aa, 0x225177 },
	{ 0x71ab, 0x234d28 },
	{ 0x71ac, 0x216d5f },
	{ 0x71ad, 0x234d25 },
	{ 0x71ae, 0x234d22 },
	{ 0x71af, 0x22516b },
	{ 0x71b0, 0x22516d },
	{ 0x71b1, 0x216d60 },
	{ 0x71b2, 0x22516a },
	{ 0x71b3, 0x22517a },
	{ 0x71b4, 0x23655c },
	{ 0x71b5, 0x225171 },
	{ 0x71b6, 0x235162 },
	{ 0x71b7, 0x23515a },
	{ 0x71b8, 0x225836 },
	{ 0x71b9, 0x21713b },
	{ 0x71ba, 0x235160 },
	{ 0x71bb, 0x23515c },
	{ 0x71bc, 0x225841 },
	{ 0x71bd, 0x22583f },
	{ 0x71be, 0x217135 },
	{ 0x71bf, 0x225835 },
	{ 0x71c0, 0x225838 },
	{ 0x71c1, 0x225839 },
	{ 0x71c2, 0x225834 },
	{ 0x71c3, 0x21713f },
	{ 0x71c4, 0x217140 },
	{ 0x71c5, 0x225833 },
	{ 0x71c6, 0x225842 },
	{ 0x71c7, 0x22583d },
	{ 0x71c8, 0x217139 },
	{ 0x71c9, 0x217136 },
	{ 0x71ca, 0x22583c },
	{ 0x71cb, 0x22583a },
	{ 0x71cc, 0x235163 },
	{ 0x71cd, 0x245123 },
	{ 0x71ce, 0x21713c },
	{ 0x71cf, 0x22583e },
	{ 0x71d0, 0x217137 },
	{ 0x71d1, 0x23515e },
	{ 0x71d2, 0x217138 },
	{ 0x71d3, 0x235166 },
	{ 0x71d4, 0x22583b },
	{ 0x71d5, 0x21713a },
	{ 0x71d6, 0x225837 },
	{ 0x71d7, 0x272f4f },
	{ 0x71d8, 0x225840 },
	{ 0x71d9, 0x21713d },
	{ 0x71da, 0x225843 },
	{ 0x71db, 0x225844 },
	{ 0x71dc, 0x21713e },
	{ 0x71dd, 0x23655d },
	{ 0x71de, 0x23655e },
	{ 0x71df, 0x217432 },
	{ 0x71e0, 0x217439 },
	{ 0x71e1, 0x225d48 },
	{ 0x71e2, 0x225d4e },
	{ 0x71e3, 0x23553c },
	{ 0x71e4, 0x225d4c },
	{ 0x71e5, 0x217435 },
	{ 0x71e6, 0x217434 },
	{ 0x71e7, 0x217431 },
	{ 0x71e8, 0x225d4a },
	{ 0x71e9, 0x23553e },
	{ 0x71ea, 0x235543 },
	{ 0x71eb, 0x235540 },
	{ 0x71ec, 0x217437 },
	{ 0x71ed, 0x217436 },
	{ 0x71ee, 0x217433 },
	{ 0x71ef, 0x235541 },
	{ 0x71f0, 0x225d4d },
	{ 0x71f1, 0x225d49 },
	{ 0x71f2, 0x225d4b },
	{ 0x71f3, 0x235542 },
	{ 0x71f4, 0x217438 },
	{ 0x71f5, 0x2f5a73 },
	{ 0x71f8, 0x217663 },
	{ 0x71f9, 0x226229 },
	{ 0x71fa, 0x23582d },
	{ 0x71fb, 0x217660 },
	{ 0x71fc, 0x217661 },
	{ 0x71fd, 0x22622b },
	{ 0x71fe, 0x217662 },
	{ 0x71ff, 0x226228 },
	{ 0x7200, 0x23582e },
	{ 0x7201, 0x226227 },
	{ 0x7202, 0x226576 },
	{ 0x7203, 0x22622a },
	{ 0x7204, 0x235a56 },
	{ 0x7205, 0x226577 },
	{ 0x7206, 0x217847 },
	{ 0x7207, 0x226575 },
	{ 0x7208, 0x235a57 },
	{ 0x7209, 0x245f7e },
	{ 0x720a, 0x226574 },
	{ 0x720b, 0x235c59 },
	{ 0x720c, 0x226573 },
	{ 0x720d, 0x217848 },
	{ 0x720e, 0x23655f },
	{ 0x720f, 0x235c56 },
	{ 0x7210, 0x217977 },
	{ 0x7211, 0x235c58 },
	{ 0x7212, 0x235c55 },
	{ 0x7213, 0x226939 },
	{ 0x7214, 0x22693a },
	{ 0x7215, 0x235a58 },
	{ 0x7216, 0x235c53 },
	{ 0x7217, 0x235c57 },
	{ 0x7218, 0x236561 },
	{ 0x7219, 0x226b6a },
	{ 0x721a, 0x226b69 },
	{ 0x721b, 0x217a75 },
	{ 0x721c, 0x235f53 },
	{ 0x721d, 0x226b68 },
	{ 0x721e, 0x226d5a },
	{ 0x721f, 0x226d5b },
	{ 0x7220, 0x235f54 },
	{ 0x7221, 0x236039 },
	{ 0x7222, 0x226f35 },
	{ 0x7223, 0x22703f },
	{ 0x7224, 0x236143 },
	{ 0x7225, 0x236142 },
	{ 0x7226, 0x227126 },
	{ 0x7227, 0x22722c },
	{ 0x7228, 0x217d46 },
	{ 0x7229, 0x227240 },
	{ 0x722a, 0x214557 },
	{ 0x722b, 0x242151 },
	{ 0x722c, 0x214e67 },
	{ 0x722d, 0x214e68 },
	{ 0x722e, 0x232d69 },
	{ 0x722f, 0x242a2a },
	{ 0x7230, 0x21523b },
	{ 0x7232, 0x233d22 },
	{ 0x7234, 0x244a6c },
	{ 0x7235, 0x21743a },
	{ 0x7236, 0x214558 },
	{ 0x7238, 0x214e69 },
	{ 0x7239, 0x215655 },
	{ 0x723a, 0x216525 },
	{ 0x723b, 0x214559 },
	{ 0x723c, 0x232d6b },
	{ 0x723d, 0x215b73 },
	{ 0x723e, 0x21695f },
	{ 0x723f, 0x222142 },
	{ 0x7240, 0x23297c },
	{ 0x7241, 0x222b77 },
	{ 0x7242, 0x223060 },
	{ 0x7243, 0x243e4c },
	{ 0x7244, 0x224b6b },
	{ 0x7245, 0x244a6d },
	{ 0x7246, 0x21743b },
	{ 0x7247, 0x21455a },
	{ 0x7248, 0x214e6a },
	{ 0x7249, 0x222b78 },
	{ 0x724a, 0x222b79 },
	{ 0x724b, 0x223d6a },
	{ 0x724c, 0x216056 },
	{ 0x724e, 0x23425d },
	{ 0x724f, 0x224468 },
	{ 0x7250, 0x23425c },
	{ 0x7251, 0x23425b },
	{ 0x7252, 0x216526 },
	{ 0x7253, 0x224b6c },
	{ 0x7254, 0x24445e },
	{ 0x7255, 0x234d2e },
	{ 0x7256, 0x216d62 },
	{ 0x7257, 0x234d2d },
	{ 0x7258, 0x217849 },
	{ 0x7259, 0x21455b },
	{ 0x725a, 0x223d6b },
	{ 0x725b, 0x21455c },
	{ 0x725d, 0x21484a },
	{ 0x725e, 0x222262 },
	{ 0x725f, 0x214849 },
	{ 0x7260, 0x214b28 },
	{ 0x7261, 0x214b27 },
	{ 0x7262, 0x214b26 },
	{ 0x7263, 0x222460 },
	{ 0x7264, 0x232664 },
	{ 0x7265, 0x232a21 },
	{ 0x7266, 0x232a22 },
	{ 0x7267, 0x214e6b },
	{ 0x7268, 0x232a23 },
	{ 0x7269, 0x214e6c },
	{ 0x726a, 0x22277b },
	{ 0x726b, 0x242731 },
	{ 0x726c, 0x222b7a },
	{ 0x726d, 0x232d6d },
	{ 0x726e, 0x222b7d },
	{ 0x726f, 0x21523d },
	{ 0x7270, 0x222b7b },
	{ 0x7271, 0x242a2f },
	{ 0x7272, 0x21523c },
	{ 0x7273, 0x222b7c },
	{ 0x7274, 0x21523e },
	{ 0x7276, 0x223063 },
	{ 0x7277, 0x223062 },
	{ 0x7278, 0x223061 },
	{ 0x7279, 0x215656 },
	{ 0x727a, 0x233236 },
	{ 0x727b, 0x223722 },
	{ 0x727c, 0x223723 },
	{ 0x727d, 0x215b74 },
	{ 0x727e, 0x223721 },
	{ 0x727f, 0x223724 },
	{ 0x7280, 0x216058 },
	{ 0x7281, 0x215b75 },
	{ 0x7282, 0x233d24 },
	{ 0x7283, 0x233d23 },
	{ 0x7284, 0x216057 },
	{ 0x7285, 0x223d6f },
	{ 0x7286, 0x223d6e },
	{ 0x7287, 0x233d25 },
	{ 0x7288, 0x223d6c },
	{ 0x7289, 0x223d6d },
	{ 0x728b, 0x223d70 },
	{ 0x728c, 0x22446a },
	{ 0x728d, 0x224469 },
	{ 0x728e, 0x22446d },
	{ 0x728f, 0x243e4f },
	{ 0x7290, 0x22446c },
	{ 0x7291, 0x22446b },
	{ 0x7292, 0x216960 },
	{ 0x7293, 0x224b6f },
	{ 0x7294, 0x234775 },
	{ 0x7295, 0x224b6e },
	{ 0x7296, 0x216961 },
	{ 0x7297, 0x224b6d },
	{ 0x7298, 0x22517b },
	{ 0x7299, 0x234d2f },
	{ 0x729a, 0x22517c },
	{ 0x729b, 0x216d63 },
	{ 0x729c, 0x24512d },
	{ 0x729d, 0x225845 },
	{ 0x729e, 0x225846 },
	{ 0x729f, 0x254e37 },
	{ 0x72a1, 0x22657c },
	{ 0x72a2, 0x21784a },
	{ 0x72a3, 0x22657b },
	{ 0x72a4, 0x22657a },
	{ 0x72a5, 0x226578 },
	{ 0x72a6, 0x226579 },
	{ 0x72a7, 0x217a76 },
	{ 0x72a8, 0x22693b },
	{ 0x72a9, 0x226d5c },
	{ 0x72aa, 0x227127 },
	{ 0x72ab, 0x23617b },
	{ 0x72ac, 0x21455d },
	{ 0x72ad, 0x242138 },
	{ 0x72ae, 0x222164 },
	{ 0x72af, 0x214667 },
	{ 0x72b0, 0x222165 },
	{ 0x72b1, 0x23242c },
	{ 0x72b2, 0x23242d },
	{ 0x72b3, 0x242327 },
	{ 0x72b4, 0x222263 },
	{ 0x72b5, 0x222264 },
	{ 0x72b6, 0x23266b },
	{ 0x72b9, 0x232669 },
	{ 0x72ba, 0x222466 },
	{ 0x72bb, 0x232666 },
	{ 0x72bc, 0x232667 },
	{ 0x72bd, 0x222462 },
	{ 0x72be, 0x23266a },
	{ 0x72bf, 0x222461 },
	{ 0x72c0, 0x214e6d },
	{ 0x72c1, 0x222465 },
	{ 0x72c2, 0x214b2a },
	{ 0x72c3, 0x222463 },
	{ 0x72c4, 0x214b29 },
	{ 0x72c5, 0x222467 },
	{ 0x72c6, 0x222464 },
	{ 0x72c7, 0x232668 },
	{ 0x72c9, 0x222821 },
	{ 0x72ca, 0x222b7e },
	{ 0x72cb, 0x22277d },
	{ 0x72cc, 0x222826 },
	{ 0x72cd, 0x232a26 },
	{ 0x72ce, 0x214e6e },
	{ 0x72cf, 0x232a2a },
	{ 0x72d0, 0x214e71 },
	{ 0x72d1, 0x222827 },
	{ 0x72d2, 0x222823 },
	{ 0x72d3, 0x232a27 },
	{ 0x72d4, 0x222824 },
	{ 0x72d5, 0x242736 },
	{ 0x72d6, 0x22277c },
	{ 0x72d7, 0x214e70 },
	{ 0x72d8, 0x22277e },
	{ 0x72d9, 0x214e6f },
	{ 0x72da, 0x222825 },
	{ 0x72db, 0x232a28 },
	{ 0x72dc, 0x222822 },
	{ 0x72dd, 0x262c7e },
	{ 0x72df, 0x222c24 },
	{ 0x72e0, 0x215240 },
	{ 0x72e1, 0x215241 },
	{ 0x72e2, 0x232d75 },
	{ 0x72e3, 0x222c27 },
	{ 0x72e4, 0x222c21 },
	{ 0x72e5, 0x232d74 },
	{ 0x72e6, 0x222c26 },
	{ 0x72e7, 0x232d70 },
	{ 0x72e8, 0x222c22 },
	{ 0x72e9, 0x21523f },
	{ 0x72ea, 0x222c25 },
	{ 0x72eb, 0x222c23 },
	{ 0x72ec, 0x232d73 },
	{ 0x72ed, 0x232d71 },
	{ 0x72f3, 0x223069 },
	{ 0x72f4, 0x223066 },
	{ 0x72f5, 0x233238 },
	{ 0x72f6, 0x223068 },
	{ 0x72f7, 0x21565b },
	{ 0x72f8, 0x21565a },
	{ 0x72f9, 0x215658 },
	{ 0x72fa, 0x223065 },
	{ 0x72fb, 0x22306a },
	{ 0x72fc, 0x215657 },
	{ 0x72fd, 0x215659 },
	{ 0x72fe, 0x223067 },
	{ 0x72ff, 0x22372c },
	{ 0x7300, 0x223064 },
	{ 0x7301, 0x22306b },
	{ 0x7302, 0x233239 },
	{ 0x7304, 0x243323 },
	{ 0x7305, 0x24332a },
	{ 0x7306, 0x233d26 },
	{ 0x7307, 0x223727 },
	{ 0x7308, 0x22372b },
	{ 0x7309, 0x253354 },
	{ 0x730a, 0x22372a },
	{ 0x730b, 0x223d72 },
	{ 0x730c, 0x223d7d },
	{ 0x730d, 0x24332d },
	{ 0x730e, 0x23373b },
	{ 0x730f, 0x22372d },
	{ 0x7310, 0x23373a },
	{ 0x7311, 0x223728 },
	{ 0x7312, 0x223d71 },
	{ 0x7313, 0x215b79 },
	{ 0x7314, 0x243322 },
	{ 0x7315, 0x24332c },
	{ 0x7316, 0x215b78 },
	{ 0x7317, 0x223726 },
	{ 0x7318, 0x223729 },
	{ 0x7319, 0x215b7a },
	{ 0x731a, 0x233739 },
	{ 0x731b, 0x215b77 },
	{ 0x731c, 0x215b76 },
	{ 0x731d, 0x223725 },
	{ 0x731e, 0x22372e },
	{ 0x7322, 0x223d74 },
	{ 0x7323, 0x223d7b },
	{ 0x7324, 0x233d27 },
	{ 0x7325, 0x21605a },
	{ 0x7326, 0x223d7a },
	{ 0x7327, 0x223d77 },
	{ 0x7328, 0x233d2e },
	{ 0x7329, 0x21605c },
	{ 0x732a, 0x233d29 },
	{ 0x732b, 0x233d2b },
	{ 0x732c, 0x233d2a },
	{ 0x732d, 0x223d79 },
	{ 0x732e, 0x234261 },
	{ 0x732f, 0x233d2d },
	{ 0x7330, 0x223d73 },
	{ 0x7331, 0x223d75 },
	{ 0x7332, 0x223d78 },
	{ 0x7333, 0x223d76 },
	{ 0x7334, 0x21605b },
	{ 0x7335, 0x223d7c },
	{ 0x7336, 0x216059 },
	{ 0x7337, 0x216527 },
	{ 0x7338, 0x233d28 },
	{ 0x733a, 0x224471 },
	{ 0x733b, 0x224470 },
	{ 0x733c, 0x22446e },
	{ 0x733d, 0x26547c },
	{ 0x733e, 0x21652a },
	{ 0x733f, 0x216529 },
	{ 0x7340, 0x224472 },
	{ 0x7341, 0x23425f },
	{ 0x7342, 0x22446f },
	{ 0x7343, 0x224b70 },
	{ 0x7344, 0x216962 },
	{ 0x7345, 0x216528 },
	{ 0x7346, 0x234262 },
	{ 0x7347, 0x236562 },
	{ 0x7348, 0x236563 },
	{ 0x7349, 0x224474 },
	{ 0x734a, 0x224473 },
	{ 0x734b, 0x234d30 },
	{ 0x734c, 0x224b73 },
	{ 0x734d, 0x224b71 },
	{ 0x734e, 0x216d64 },
	{ 0x734f, 0x234779 },
	{ 0x7350, 0x216963 },
	{ 0x7351, 0x224b72 },
	{ 0x7352, 0x22517e },
	{ 0x7353, 0x234778 },
	{ 0x7354, 0x23477a },
	{ 0x7355, 0x234777 },
	{ 0x7356, 0x244a77 },
	{ 0x7357, 0x216d65 },
	{ 0x7358, 0x22517d },
	{ 0x7359, 0x225228 },
	{ 0x735a, 0x225227 },
	{ 0x735b, 0x225225 },
	{ 0x735c, 0x244a75 },
	{ 0x735d, 0x225224 },
	{ 0x735e, 0x225221 },
	{ 0x735f, 0x225222 },
	{ 0x7360, 0x225223 },
	{ 0x7361, 0x225226 },
	{ 0x7362, 0x225229 },
	{ 0x7365, 0x22584b },
	{ 0x7366, 0x225848 },
	{ 0x7367, 0x225849 },
	{ 0x7368, 0x217141 },
	{ 0x7369, 0x225847 },
	{ 0x736a, 0x22584d },
	{ 0x736b, 0x22584c },
	{ 0x736c, 0x22584a },
	{ 0x736e, 0x225d50 },
	{ 0x736f, 0x225d51 },
	{ 0x7370, 0x21743c },
	{ 0x7371, 0x235549 },
	{ 0x7372, 0x21743d },
	{ 0x7373, 0x225d4f },
	{ 0x7374, 0x24566c },
	{ 0x7375, 0x217665 },
	{ 0x7376, 0x22622c },
	{ 0x7377, 0x217664 },
	{ 0x7378, 0x21784b },
	{ 0x7379, 0x246025 },
	{ 0x737a, 0x21784c },
	{ 0x737b, 0x217978 },
	{ 0x737c, 0x22693d },
	{ 0x737d, 0x22693c },
	{ 0x737e, 0x226b6b },
	{ 0x737f, 0x226d5d },
	{ 0x7380, 0x217b66 },
	{ 0x7381, 0x226f37 },
	{ 0x7382, 0x226f36 },
	{ 0x7383, 0x226f38 },
	{ 0x7384, 0x214668 },
	{ 0x7385, 0x222c28 },
	{ 0x7386, 0x21565c },
	{ 0x7387, 0x215b7b },
	{ 0x7388, 0x22372f },
	{ 0x7389, 0x214669 },
	{ 0x738a, 0x222166 },
	{ 0x738b, 0x21455e },
	{ 0x738c, 0x23225a },
	{ 0x738d, 0x23216b },
	{ 0x738e, 0x222265 },
	{ 0x738f, 0x23242f },
	{ 0x7390, 0x24232a },
	{ 0x7391, 0x2f2266 },
	{ 0x7392, 0x22246c },
	{ 0x7393, 0x22246a },
	{ 0x7394, 0x22246b },
	{ 0x7395, 0x222468 },
	{ 0x7396, 0x214b2b },
	{ 0x7397, 0x222469 },
	{ 0x7398, 0x23266e },
	{ 0x739c, 0x232a33 },
	{ 0x739d, 0x22282f },
	{ 0x739e, 0x232a2d },
	{ 0x739f, 0x214e74 },
	{ 0x73a0, 0x22282d },
	{ 0x73a1, 0x222829 },
	{ 0x73a2, 0x22282c },
	{ 0x73a3, 0x232a2c },
	{ 0x73a4, 0x222828 },
	{ 0x73a5, 0x214e76 },
	{ 0x73a6, 0x22282b },
	{ 0x73a7, 0x232a2b },
	{ 0x73a8, 0x214e73 },
	{ 0x73a9, 0x214e72 },
	{ 0x73aa, 0x232a32 },
	{ 0x73ab, 0x214e75 },
	{ 0x73ac, 0x22282e },
	{ 0x73ad, 0x22282a },
	{ 0x73af, 0x232a2f },
	{ 0x73b2, 0x215245 },
	{ 0x73b3, 0x215248 },
	{ 0x73b4, 0x222c30 },
	{ 0x73b5, 0x222c2f },
	{ 0x73b6, 0x222c2e },
	{ 0x73b7, 0x215242 },
	{ 0x73b8, 0x222c37 },
	{ 0x73b9, 0x222c2d },
	{ 0x73ba, 0x242e2a },
	{ 0x73bb, 0x215244 },
	{ 0x73bc, 0x223070 },
	{ 0x73bd, 0x232d78 },
	{ 0x73be, 0x222c34 },
	{ 0x73bf, 0x222c32 },
	{ 0x73c0, 0x215247 },
	{ 0x73c1, 0x232d7b },
	{ 0x73c2, 0x222c2a },
	{ 0x73c3, 0x222c35 },
	{ 0x73c4, 0x232d77 },
	{ 0x73c5, 0x222c2c },
	{ 0x73c6, 0x222c36 },
	{ 0x73c7, 0x222c33 },
	{ 0x73c8, 0x222c2b },
	{ 0x73c9, 0x232d7a },
	{ 0x73ca, 0x215243 },
	{ 0x73cb, 0x222c38 },
	{ 0x73cc, 0x222c29 },
	{ 0x73cd, 0x215246 },
	{ 0x73ce, 0x232d7e },
	{ 0x73cf, 0x232d79 },
	{ 0x73d0, 0x232d7c },
	{ 0x73d2, 0x223075 },
	{ 0x73d3, 0x22306c },
	{ 0x73d4, 0x223077 },
	{ 0x73d5, 0x23323e },
	{ 0x73d6, 0x22306f },
	{ 0x73d7, 0x22307a },
	{ 0x73d8, 0x22307b },
	{ 0x73d9, 0x22306d },
	{ 0x73da, 0x223079 },
	{ 0x73db, 0x223076 },
	{ 0x73dc, 0x223074 },
	{ 0x73dd, 0x223078 },
	{ 0x73de, 0x215662 },
	{ 0x73df, 0x233240 },
	{ 0x73e0, 0x215660 },
	{ 0x73e1, 0x233247 },
	{ 0x73e2, 0x23323c },
	{ 0x73e3, 0x223072 },
	{ 0x73e4, 0x233246 },
	{ 0x73e5, 0x22306e },
	{ 0x73e6, 0x233241 },
	{ 0x73e7, 0x223071 },
	{ 0x73e8, 0x22307c },
	{ 0x73e9, 0x223073 },
	{ 0x73ea, 0x215661 },
	{ 0x73eb, 0x222c31 },
	{ 0x73ec, 0x23323d },
	{ 0x73ed, 0x21565d },
	{ 0x73ee, 0x21565f },
	{ 0x73ef, 0x236564 },
	{ 0x73f3, 0x23373d },
	{ 0x73f4, 0x22373d },
	{ 0x73f5, 0x223732 },
	{ 0x73f6, 0x223730 },
	{ 0x73f7, 0x233d38 },
	{ 0x73f8, 0x223731 },
	{ 0x73f9, 0x23323f },
	{ 0x73fa, 0x223738 },
	{ 0x73fb, 0x233740 },
	{ 0x73fc, 0x223739 },
	{ 0x73fd, 0x223735 },
	{ 0x73fe, 0x215c22 },
	{ 0x73ff, 0x22373a },
	{ 0x7400, 0x223737 },
	{ 0x7401, 0x223734 },
	{ 0x7402, 0x23373c },
	{ 0x7403, 0x215b7e },
	{ 0x7404, 0x223733 },
	{ 0x7405, 0x215b7c },
	{ 0x7406, 0x215c21 },
	{ 0x7407, 0x223736 },
	{ 0x7408, 0x22373e },
	{ 0x7409, 0x21565e },
	{ 0x740a, 0x215b7d },
	{ 0x740b, 0x22373c },
	{ 0x740c, 0x22373b },
	{ 0x740d, 0x215c23 },
	{ 0x7412, 0x236565 },
	{ 0x7413, 0x2f3657 },
	{ 0x7414, 0x233d36 },
	{ 0x7415, 0x233d3a },
	{ 0x7416, 0x223e24 },
	{ 0x7417, 0x233d2f },
	{ 0x7418, 0x233d3b },
	{ 0x7419, 0x233d32 },
	{ 0x741a, 0x223e25 },
	{ 0x741b, 0x216066 },
	{ 0x741c, 0x233d39 },
	{ 0x741d, 0x223e2b },
	{ 0x741e, 0x23426d },
	{ 0x741f, 0x233d35 },
	{ 0x7420, 0x223e2d },
	{ 0x7421, 0x223e26 },
	{ 0x7422, 0x216060 },
	{ 0x7423, 0x223e2a },
	{ 0x7424, 0x223e29 },
	{ 0x7425, 0x216061 },
	{ 0x7426, 0x216067 },
	{ 0x7427, 0x234264 },
	{ 0x7428, 0x216068 },
	{ 0x7429, 0x223e2c },
	{ 0x742a, 0x21605e },
	{ 0x742b, 0x223e23 },
	{ 0x742c, 0x223e21 },
	{ 0x742d, 0x223e27 },
	{ 0x742e, 0x223d7e },
	{ 0x742f, 0x216065 },
	{ 0x7430, 0x223e22 },
	{ 0x7431, 0x223e28 },
	{ 0x7432, 0x223e2e },
	{ 0x7433, 0x21605f },
	{ 0x7434, 0x216064 },
	{ 0x7435, 0x216062 },
	{ 0x7436, 0x216063 },
	{ 0x7438, 0x233d33 },
	{ 0x7439, 0x233d3c },
	{ 0x743a, 0x21605d },
	{ 0x743b, 0x236566 },
	{ 0x743c, 0x233d37 },
	{ 0x743d, 0x234268 },
	{ 0x743e, 0x234275 },
	{ 0x743f, 0x216531 },
	{ 0x7440, 0x22447b },
	{ 0x7441, 0x216530 },
	{ 0x7442, 0x224521 },
	{ 0x7443, 0x23426f },
	{ 0x7444, 0x224475 },
	{ 0x7445, 0x234274 },
	{ 0x7446, 0x224522 },
	{ 0x7447, 0x23426e },
	{ 0x7448, 0x234266 },
	{ 0x7449, 0x234271 },
	{ 0x744a, 0x224476 },
	{ 0x744b, 0x224477 },
	{ 0x744c, 0x234273 },
	{ 0x744d, 0x224523 },
	{ 0x744e, 0x22447e },
	{ 0x744f, 0x22447c },
	{ 0x7450, 0x22447d },
	{ 0x7451, 0x224479 },
	{ 0x7452, 0x224478 },
	{ 0x7453, 0x234267 },
	{ 0x7454, 0x224524 },
	{ 0x7455, 0x21652d },
	{ 0x7456, 0x23426b },
	{ 0x7457, 0x22447a },
	{ 0x7458, 0x234270 },
	{ 0x7459, 0x216532 },
	{ 0x745a, 0x21652c },
	{ 0x745b, 0x216533 },
	{ 0x745c, 0x216534 },
	{ 0x745d, 0x23426a },
	{ 0x745e, 0x21652f },
	{ 0x745f, 0x21652e },
	{ 0x7460, 0x234825 },
	{ 0x7461, 0x23477e },
	{ 0x7462, 0x224b74 },
	{ 0x7463, 0x216965 },
	{ 0x7464, 0x216964 },
	{ 0x7465, 0x23477c },
	{ 0x7466, 0x23477d },
	{ 0x7467, 0x224b79 },
	{ 0x7468, 0x234822 },
	{ 0x7469, 0x216d66 },
	{ 0x746a, 0x216966 },
	{ 0x746b, 0x234821 },
	{ 0x746c, 0x23477b },
	{ 0x746d, 0x216968 },
	{ 0x746e, 0x224b7a },
	{ 0x746f, 0x21652b },
	{ 0x7470, 0x216967 },
	{ 0x7471, 0x224b76 },
	{ 0x7472, 0x224b78 },
	{ 0x7473, 0x224b75 },
	{ 0x7474, 0x234827 },
	{ 0x7475, 0x224b77 },
	{ 0x7476, 0x234823 },
	{ 0x7478, 0x2f4976 },
	{ 0x7479, 0x225233 },
	{ 0x747a, 0x234d31 },
	{ 0x747b, 0x234d3b },
	{ 0x747c, 0x225232 },
	{ 0x747d, 0x22522f },
	{ 0x747e, 0x216d69 },
	{ 0x747f, 0x22584e },
	{ 0x7480, 0x216d6a },
	{ 0x7481, 0x22522e },
	{ 0x7482, 0x234d39 },
	{ 0x7483, 0x216d68 },
	{ 0x7484, 0x234d36 },
	{ 0x7485, 0x225230 },
	{ 0x7486, 0x22522d },
	{ 0x7487, 0x22522a },
	{ 0x7488, 0x225231 },
	{ 0x7489, 0x22522b },
	{ 0x748a, 0x22522c },
	{ 0x748b, 0x216d67 },
	{ 0x748c, 0x234d35 },
	{ 0x748d, 0x236568 },
	{ 0x748f, 0x245139 },
	{ 0x7490, 0x225d55 },
	{ 0x7491, 0x24513a },
	{ 0x7492, 0x225852 },
	{ 0x7493, 0x234d3a },
	{ 0x7494, 0x225851 },
	{ 0x7495, 0x225853 },
	{ 0x7496, 0x23516a },
	{ 0x7497, 0x225d52 },
	{ 0x7498, 0x217144 },
	{ 0x7499, 0x245138 },
	{ 0x749a, 0x22584f },
	{ 0x749b, 0x235167 },
	{ 0x749c, 0x217142 },
	{ 0x749d, 0x23516c },
	{ 0x749e, 0x217146 },
	{ 0x749f, 0x217145 },
	{ 0x74a0, 0x225850 },
	{ 0x74a1, 0x225854 },
	{ 0x74a2, 0x23516b },
	{ 0x74a3, 0x217143 },
	{ 0x74a4, 0x236567 },
	{ 0x74a5, 0x225d59 },
	{ 0x74a6, 0x217440 },
	{ 0x74a7, 0x217666 },
	{ 0x74a8, 0x217441 },
	{ 0x74a9, 0x21743e },
	{ 0x74aa, 0x225d56 },
	{ 0x74ab, 0x225d54 },
	{ 0x74ac, 0x23554f },
	{ 0x74ad, 0x225d57 },
	{ 0x74ae, 0x23554b },
	{ 0x74af, 0x225d5a },
	{ 0x74b0, 0x21743f },
	{ 0x74b1, 0x225d58 },
	{ 0x74b2, 0x225d53 },
	{ 0x74b3, 0x23554d },
	{ 0x74b4, 0x236569 },
	{ 0x74b5, 0x22622f },
	{ 0x74b6, 0x226232 },
	{ 0x74b7, 0x226621 },
	{ 0x74b8, 0x22622d },
	{ 0x74b9, 0x23582f },
	{ 0x74ba, 0x22693e },
	{ 0x74bb, 0x226233 },
	{ 0x74bc, 0x235830 },
	{ 0x74bd, 0x21784d },
	{ 0x74be, 0x226231 },
	{ 0x74bf, 0x217667 },
	{ 0x74c0, 0x22622e },
	{ 0x74c1, 0x226230 },
	{ 0x74c2, 0x226234 },
	{ 0x74c3, 0x226622 },
	{ 0x74c4, 0x235a5a },
	{ 0x74c5, 0x22657e },
	{ 0x74c6, 0x246027 },
	{ 0x74c7, 0x235a5c },
	{ 0x74c8, 0x235a5d },
	{ 0x74c9, 0x235a5b },
	{ 0x74ca, 0x21784e },
	{ 0x74cb, 0x22657d },
	{ 0x74cc, 0x235c5e },
	{ 0x74cd, 0x235c5c },
	{ 0x74ce, 0x235c5f },
	{ 0x74cf, 0x217979 },
	{ 0x74d0, 0x235c5d },
	{ 0x74d1, 0x235c60 },
	{ 0x74d3, 0x235e3d },
	{ 0x74d4, 0x217a78 },
	{ 0x74d5, 0x226d5f },
	{ 0x74d6, 0x217a77 },
	{ 0x74d7, 0x226d61 },
	{ 0x74d8, 0x226d5e },
	{ 0x74d9, 0x226d60 },
	{ 0x74da, 0x217c3c },
	{ 0x74db, 0x227040 },
	{ 0x74dc, 0x21466a },
	{ 0x74dd, 0x222830 },
	{ 0x74de, 0x22307d },
	{ 0x74df, 0x22307e },
	{ 0x74e0, 0x215c24 },
	{ 0x74e1, 0x224525 },
	{ 0x74e2, 0x217147 },
	{ 0x74e3, 0x21784f },
	{ 0x74e4, 0x217b67 },
	{ 0x74e5, 0x227041 },
	{ 0x74e6, 0x21466b },
	{ 0x74e8, 0x222831 },
	{ 0x74e9, 0x212322 },
	{ 0x74ea, 0x242a3c },
	{ 0x74eb, 0x232e22 },
	{ 0x74ec, 0x222c39 },
	{ 0x74ed, 0x232e21 },
	{ 0x74ee, 0x222c3a },
	{ 0x74ef, 0x232e24 },
	{ 0x74f3, 0x233248 },
	{ 0x74f4, 0x223121 },
	{ 0x74f5, 0x223122 },
	{ 0x74f6, 0x215c25 },
	{ 0x74f7, 0x215c26 },
	{ 0x74f8, 0x2f3667 },
	{ 0x74f9, 0x233d3d },
	{ 0x74fa, 0x243925 },
	{ 0x74fb, 0x223e2f },
	{ 0x74fd, 0x224528 },
	{ 0x74fe, 0x224527 },
	{ 0x74ff, 0x224526 },
	{ 0x7500, 0x224b7b },
	{ 0x7501, 0x234277 },
	{ 0x7502, 0x224b7c },
	{ 0x7503, 0x224b7d },
	{ 0x7504, 0x216969 },
	{ 0x7506, 0x234828 },
	{ 0x7507, 0x225235 },
	{ 0x7508, 0x225234 },
	{ 0x7509, 0x234d3d },
	{ 0x750a, 0x23516d },
	{ 0x750b, 0x225855 },
	{ 0x750c, 0x217148 },
	{ 0x750d, 0x217149 },
	{ 0x750e, 0x23516e },
	{ 0x750f, 0x225d5e },
	{ 0x7510, 0x225d5b },
	{ 0x7511, 0x225d5c },
	{ 0x7512, 0x225d5d },
	{ 0x7513, 0x226236 },
	{ 0x7514, 0x226235 },
	{ 0x7515, 0x217668 },
	{ 0x7516, 0x226623 },
	{ 0x7517, 0x226b6c },
	{ 0x7518, 0x21466c },
	{ 0x751a, 0x215249 },
	{ 0x751b, 0x233744 },
	{ 0x751c, 0x215c27 },
	{ 0x751d, 0x224529 },
	{ 0x751e, 0x234278 },
	{ 0x751f, 0x21466d },
	{ 0x7520, 0x242a40 },
	{ 0x7521, 0x223123 },
	{ 0x7522, 0x215c28 },
	{ 0x7523, 0x233745 },
	{ 0x7524, 0x233d3e },
	{ 0x7525, 0x216069 },
	{ 0x7526, 0x21606a },
	{ 0x7527, 0x254749 },
	{ 0x7528, 0x21466e },
	{ 0x7529, 0x21466f },
	{ 0x752a, 0x222266 },
	{ 0x752b, 0x214b2d },
	{ 0x752c, 0x214b2c },
	{ 0x752d, 0x21524a },
	{ 0x752e, 0x222c3b },
	{ 0x752f, 0x223e30 },
	{ 0x7530, 0x214670 },
	{ 0x7531, 0x214671 },
	{ 0x7532, 0x214672 },
	{ 0x7533, 0x214673 },
	{ 0x7536, 0x24232b },
	{ 0x7537, 0x214b2e },
	{ 0x7538, 0x214b2f },
	{ 0x7539, 0x22246e },
	{ 0x753a, 0x22246d },
	{ 0x753b, 0x232a37 },
	{ 0x753d, 0x214e77 },
	{ 0x753e, 0x222834 },
	{ 0x753f, 0x222832 },
	{ 0x7540, 0x222833 },
	{ 0x7541, 0x232a38 },
	{ 0x7542, 0x232a35 },
	{ 0x7543, 0x242740 },
	{ 0x7544, 0x232a36 },
	{ 0x7546, 0x232e27 },
	{ 0x7547, 0x222c3c },
	{ 0x7548, 0x222c3d },
	{ 0x7549, 0x232e25 },
	{ 0x754a, 0x232e28 },
	{ 0x754b, 0x21524e },
	{ 0x754c, 0x21524c },
	{ 0x754d, 0x232e2a },
	{ 0x754e, 0x21524d },
	{ 0x754f, 0x21524b },
	{ 0x7550, 0x232e26 },
	{ 0x7551, 0x2f2b7a },
	{ 0x7553, 0x2f2c4a },
	{ 0x7554, 0x215663 },
	{ 0x7555, 0x23324e },
	{ 0x7556, 0x23324d },
	{ 0x7557, 0x233250 },
	{ 0x7558, 0x23324f },
	{ 0x7559, 0x215667 },
	{ 0x755a, 0x215666 },
	{ 0x755b, 0x223124 },
	{ 0x755c, 0x215665 },
	{ 0x755d, 0x215664 },
	{ 0x755e, 0x233251 },
	{ 0x755f, 0x223125 },
	{ 0x7561, 0x233746 },
	{ 0x7562, 0x215c2b },
	{ 0x7563, 0x223740 },
	{ 0x7564, 0x22373f },
	{ 0x7565, 0x215c29 },
	{ 0x7566, 0x215c2a },
	{ 0x7567, 0x233749 },
	{ 0x7568, 0x233747 },
	{ 0x756a, 0x21606c },
	{ 0x756b, 0x21606b },
	{ 0x756c, 0x223e32 },
	{ 0x756d, 0x233d43 },
	{ 0x756e, 0x233d42 },
	{ 0x756f, 0x223e31 },
	{ 0x7570, 0x215c2c },
	{ 0x7571, 0x233d44 },
	{ 0x7572, 0x24392c },
	{ 0x7575, 0x243e6b },
	{ 0x7576, 0x216535 },
	{ 0x7577, 0x22452b },
	{ 0x7578, 0x216536 },
	{ 0x7579, 0x22452a },
	{ 0x757a, 0x23427b },
	{ 0x757b, 0x24447c },
	{ 0x757c, 0x24447b },
	{ 0x757d, 0x224b7e },
	{ 0x757e, 0x225236 },
	{ 0x757f, 0x216d6b },
	{ 0x7580, 0x225856 },
	{ 0x7581, 0x235170 },
	{ 0x7583, 0x235552 },
	{ 0x7584, 0x225d5f },
	{ 0x7585, 0x245b74 },
	{ 0x7586, 0x217851 },
	{ 0x7587, 0x217850 },
	{ 0x7588, 0x246368 },
	{ 0x7589, 0x235c62 },
	{ 0x758a, 0x217b68 },
	{ 0x758b, 0x214674 },
	{ 0x758c, 0x222835 },
	{ 0x758e, 0x233d45 },
	{ 0x758f, 0x215c2d },
	{ 0x7590, 0x224c21 },
	{ 0x7591, 0x21696a },
	{ 0x7592, 0x23225b },
	{ 0x7593, 0x232673 },
	{ 0x7594, 0x22246f },
	{ 0x7595, 0x222470 },
	{ 0x7598, 0x222836 },
	{ 0x7599, 0x214e79 },
	{ 0x759a, 0x214e7a },
	{ 0x759b, 0x232a3a },
	{ 0x759c, 0x242743 },
	{ 0x759d, 0x214e78 },
	{ 0x759e, 0x232a3b },
	{ 0x75a2, 0x215252 },
	{ 0x75a3, 0x215253 },
	{ 0x75a4, 0x215250 },
	{ 0x75a5, 0x215251 },
	{ 0x75a6, 0x232e2b },
	{ 0x75a7, 0x222c3e },
	{ 0x75a8, 0x232e2f },
	{ 0x75a9, 0x242a4a },
	{ 0x75aa, 0x222c3f },
	{ 0x75ab, 0x21524f },
	{ 0x75b0, 0x223126 },
	{ 0x75b1, 0x233257 },
	{ 0x75b2, 0x21566b },
	{ 0x75b3, 0x21566c },
	{ 0x75b4, 0x233255 },
	{ 0x75b5, 0x215c30 },
	{ 0x75b6, 0x22312c },
	{ 0x75b7, 0x242e40 },
	{ 0x75b8, 0x215671 },
	{ 0x75b9, 0x21566f },
	{ 0x75ba, 0x22312d },
	{ 0x75bb, 0x223128 },
	{ 0x75bc, 0x21566e },
	{ 0x75bd, 0x21566d },
	{ 0x75be, 0x215668 },
	{ 0x75bf, 0x22312b },
	{ 0x75c0, 0x22312a },
	{ 0x75c1, 0x223127 },
	{ 0x75c2, 0x215670 },
	{ 0x75c3, 0x233252 },
	{ 0x75c4, 0x223129 },
	{ 0x75c5, 0x215669 },
	{ 0x75c6, 0x242e34 },
	{ 0x75c7, 0x21566a },
	{ 0x75ca, 0x215c31 },
	{ 0x75cb, 0x223744 },
	{ 0x75cc, 0x223745 },
	{ 0x75cd, 0x215c32 },
	{ 0x75ce, 0x223741 },
	{ 0x75cf, 0x223743 },
	{ 0x75d0, 0x223747 },
	{ 0x75d1, 0x223746 },
	{ 0x75d2, 0x223742 },
	{ 0x75d3, 0x23374a },
	{ 0x75d4, 0x215c2e },
	{ 0x75d5, 0x215c2f },
	{ 0x75d7, 0x223e3a },
	{ 0x75d8, 0x216071 },
	{ 0x75d9, 0x216070 },
	{ 0x75da, 0x223e34 },
	{ 0x75db, 0x21606e },
	{ 0x75dc, 0x243934 },
	{ 0x75dd, 0x223e37 },
	{ 0x75de, 0x216072 },
	{ 0x75df, 0x223e38 },
	{ 0x75e0, 0x216073 },
	{ 0x75e1, 0x223e35 },
	{ 0x75e2, 0x21606d },
	{ 0x75e3, 0x21606f },
	{ 0x75e4, 0x223e39 },
	{ 0x75e5, 0x233d47 },
	{ 0x75e6, 0x223e36 },
	{ 0x75e7, 0x223e33 },
	{ 0x75ec, 0x243e77 },
	{ 0x75ed, 0x224538 },
	{ 0x75ee, 0x23427c },
	{ 0x75ef, 0x22452d },
	{ 0x75f0, 0x216538 },
	{ 0x75f1, 0x21653b },
	{ 0x75f2, 0x21653a },
	{ 0x75f3, 0x21653f },
	{ 0x75f4, 0x21653e },
	{ 0x75f5, 0x224539 },
	{ 0x75f6, 0x224537 },
	{ 0x75f7, 0x224530 },
	{ 0x75f8, 0x224534 },
	{ 0x75f9, 0x224533 },
	{ 0x75fa, 0x21653c },
	{ 0x75fb, 0x224536 },
	{ 0x75fc, 0x224532 },
	{ 0x75fd, 0x22453a },
	{ 0x75fe, 0x224531 },
	{ 0x75ff, 0x21653d },
	{ 0x7600, 0x216537 },
	{ 0x7601, 0x216539 },
	{ 0x7602, 0x23427d },
	{ 0x7603, 0x22452f },
	{ 0x7607, 0x23482b },
	{ 0x7608, 0x224c23 },
	{ 0x7609, 0x21696e },
	{ 0x760a, 0x224c27 },
	{ 0x760b, 0x21696d },
	{ 0x760c, 0x224c24 },
	{ 0x760d, 0x21696c },
	{ 0x760e, 0x234829 },
	{ 0x760f, 0x22452e },
	{ 0x7610, 0x224535 },
	{ 0x7611, 0x224c26 },
	{ 0x7612, 0x24447e },
	{ 0x7613, 0x21696f },
	{ 0x7614, 0x224c28 },
	{ 0x7615, 0x224c25 },
	{ 0x7616, 0x224c22 },
	{ 0x7619, 0x225239 },
	{ 0x761a, 0x22523d },
	{ 0x761b, 0x22523f },
	{ 0x761c, 0x22523b },
	{ 0x761d, 0x22523a },
	{ 0x761e, 0x225238 },
	{ 0x761f, 0x216d6e },
	{ 0x7620, 0x216d6c },
	{ 0x7621, 0x216d71 },
	{ 0x7622, 0x216d72 },
	{ 0x7623, 0x22523c },
	{ 0x7624, 0x216d6f },
	{ 0x7625, 0x225237 },
	{ 0x7626, 0x216d70 },
	{ 0x7627, 0x21696b },
	{ 0x7628, 0x22523e },
	{ 0x7629, 0x216d6d },
	{ 0x762c, 0x235171 },
	{ 0x762d, 0x225858 },
	{ 0x762e, 0x24514f },
	{ 0x762f, 0x225857 },
	{ 0x7630, 0x22585f },
	{ 0x7631, 0x225859 },
	{ 0x7632, 0x22585e },
	{ 0x7633, 0x22585b },
	{ 0x7634, 0x21714a },
	{ 0x7635, 0x22585d },
	{ 0x7636, 0x235173 },
	{ 0x7637, 0x235172 },
	{ 0x7638, 0x21714b },
	{ 0x7639, 0x24514d },
	{ 0x763a, 0x21714c },
	{ 0x763b, 0x235174 },
	{ 0x763c, 0x22585c },
	{ 0x763d, 0x22585a },
	{ 0x7640, 0x245721 },
	{ 0x7641, 0x245724 },
	{ 0x7642, 0x217443 },
	{ 0x7643, 0x225d60 },
	{ 0x7644, 0x235555 },
	{ 0x7645, 0x235553 },
	{ 0x7646, 0x217442 },
	{ 0x7647, 0x225d63 },
	{ 0x7648, 0x225d61 },
	{ 0x7649, 0x225d62 },
	{ 0x764a, 0x255569 },
	{ 0x764b, 0x255c36 },
	{ 0x764c, 0x217444 },
	{ 0x764e, 0x235554 },
	{ 0x764f, 0x235834 },
	{ 0x7650, 0x22623a },
	{ 0x7651, 0x235833 },
	{ 0x7652, 0x21766b },
	{ 0x7653, 0x22623b },
	{ 0x7654, 0x245b75 },
	{ 0x7655, 0x245b79 },
	{ 0x7656, 0x217669 },
	{ 0x7657, 0x22623c },
	{ 0x7658, 0x21766a },
	{ 0x7659, 0x226239 },
	{ 0x765a, 0x22623d },
	{ 0x765b, 0x235832 },
	{ 0x765c, 0x226237 },
	{ 0x765f, 0x217852 },
	{ 0x7660, 0x226624 },
	{ 0x7661, 0x217853 },
	{ 0x7662, 0x21797a },
	{ 0x7664, 0x226238 },
	{ 0x7665, 0x21797b },
	{ 0x7667, 0x235e3f },
	{ 0x7668, 0x235e3e },
	{ 0x7669, 0x217a79 },
	{ 0x766a, 0x226b6d },
	{ 0x766c, 0x217b6a },
	{ 0x766d, 0x226d62 },
	{ 0x766e, 0x217b69 },
	{ 0x766f, 0x23603b },
	{ 0x7670, 0x226f39 },
	{ 0x7671, 0x217c61 },
	{ 0x7672, 0x217c62 },
	{ 0x7673, 0x23656a },
	{ 0x7674, 0x276452 },
	{ 0x7675, 0x22723a },
	{ 0x7676, 0x23225c },
	{ 0x7677, 0x23656b },
	{ 0x7678, 0x215254 },
	{ 0x7679, 0x222c40 },
	{ 0x767b, 0x216074 },
	{ 0x767c, 0x216075 },
	{ 0x767d, 0x214675 },
	{ 0x767e, 0x21484b },
	{ 0x767f, 0x222267 },
	{ 0x7680, 0x232674 },
	{ 0x7681, 0x222471 },
	{ 0x7682, 0x214b30 },
	{ 0x7683, 0x232676 },
	{ 0x7684, 0x214e7b },
	{ 0x7685, 0x242a4c },
	{ 0x7686, 0x215255 },
	{ 0x7687, 0x215256 },
	{ 0x7688, 0x215257 },
	{ 0x7689, 0x223749 },
	{ 0x768a, 0x22312e },
	{ 0x768b, 0x215672 },
	{ 0x768c, 0x242e41 },
	{ 0x768d, 0x242e43 },
	{ 0x768e, 0x215c33 },
	{ 0x768f, 0x223748 },
	{ 0x7690, 0x23374d },
	{ 0x7692, 0x223e3c },
	{ 0x7693, 0x216077 },
	{ 0x7694, 0x233d4c },
	{ 0x7695, 0x223e3b },
	{ 0x7696, 0x216076 },
	{ 0x7697, 0x23427e },
	{ 0x7698, 0x234321 },
	{ 0x7699, 0x22453b },
	{ 0x769a, 0x216d73 },
	{ 0x769b, 0x225243 },
	{ 0x769c, 0x225240 },
	{ 0x769d, 0x225241 },
	{ 0x769e, 0x225242 },
	{ 0x769f, 0x245154 },
	{ 0x76a0, 0x245155 },
	{ 0x76a1, 0x235176 },
	{ 0x76a2, 0x255c43 },
	{ 0x76a3, 0x235556 },
	{ 0x76a4, 0x225d64 },
	{ 0x76a5, 0x235557 },
	{ 0x76a6, 0x22623e },
	{ 0x76a7, 0x245b7c },
	{ 0x76a8, 0x245b7d },
	{ 0x76a9, 0x235a5e },
	{ 0x76aa, 0x226940 },
	{ 0x76ab, 0x22693f },
	{ 0x76ac, 0x24665a },
	{ 0x76ad, 0x226d63 },
	{ 0x76ae, 0x214676 },
	{ 0x76af, 0x222837 },
	{ 0x76b0, 0x215673 },
	{ 0x76b3, 0x233d4d },
	{ 0x76b4, 0x216078 },
	{ 0x76b5, 0x22453c },
	{ 0x76b6, 0x244534 },
	{ 0x76b7, 0x234830 },
	{ 0x76b8, 0x224c29 },
	{ 0x76b9, 0x23482e },
	{ 0x76ba, 0x216d74 },
	{ 0x76bb, 0x225860 },
	{ 0x76bc, 0x23656c },
	{ 0x76bd, 0x22623f },
	{ 0x76be, 0x226941 },
	{ 0x76bf, 0x214677 },
	{ 0x76c0, 0x232677 },
	{ 0x76c1, 0x232678 },
	{ 0x76c2, 0x214e7c },
	{ 0x76c3, 0x21525a },
	{ 0x76c4, 0x222c41 },
	{ 0x76c5, 0x21525b },
	{ 0x76c6, 0x215259 },
	{ 0x76c7, 0x232e32 },
	{ 0x76c8, 0x215258 },
	{ 0x76c9, 0x22312f },
	{ 0x76ca, 0x215674 },
	{ 0x76cb, 0x23325a },
	{ 0x76cc, 0x23325b },
	{ 0x76cd, 0x215675 },
	{ 0x76ce, 0x215676 },
	{ 0x76d2, 0x215c35 },
	{ 0x76d3, 0x22374a },
	{ 0x76d4, 0x215c34 },
	{ 0x76d5, 0x233750 },
	{ 0x76d6, 0x233752 },
	{ 0x76d7, 0x233751 },
	{ 0x76d8, 0x2f3723 },
	{ 0x76d9, 0x233d4f },
	{ 0x76da, 0x223e3d },
	{ 0x76db, 0x215c36 },
	{ 0x76dc, 0x216079 },
	{ 0x76dd, 0x22453d },
	{ 0x76de, 0x216540 },
	{ 0x76df, 0x216541 },
	{ 0x76e0, 0x244535 },
	{ 0x76e1, 0x216970 },
	{ 0x76e2, 0x234831 },
	{ 0x76e3, 0x216971 },
	{ 0x76e4, 0x216d75 },
	{ 0x76e5, 0x21714e },
	{ 0x76e6, 0x225861 },
	{ 0x76e7, 0x21714d },
	{ 0x76e8, 0x24572d },
	{ 0x76e9, 0x225d65 },
	{ 0x76ea, 0x217445 },
	{ 0x76eb, 0x235835 },
	{ 0x76ec, 0x226240 },
	{ 0x76ed, 0x226942 },
	{ 0x76ee, 0x214678 },
	{ 0x76ef, 0x214b31 },
	{ 0x76f0, 0x22283a },
	{ 0x76f1, 0x222839 },
	{ 0x76f2, 0x214e7d },
	{ 0x76f3, 0x222838 },
	{ 0x76f4, 0x214e7e },
	{ 0x76f5, 0x22283b },
	{ 0x76f6, 0x242a55 },
	{ 0x76f7, 0x222c47 },
	{ 0x76f8, 0x21525e },
	{ 0x76f9, 0x21525d },
	{ 0x76fa, 0x222c49 },
	{ 0x76fb, 0x222c48 },
	{ 0x76fc, 0x215262 },
	{ 0x76fd, 0x232e35 },
	{ 0x76fe, 0x215261 },
	{ 0x76ff, 0x232e33 },
	{ 0x7700, 0x242a59 },
	{ 0x7701, 0x21525c },
	{ 0x7702, 0x242a5d },
	{ 0x7703, 0x222c43 },
	{ 0x7704, 0x222c44 },
	{ 0x7705, 0x222c45 },
	{ 0x7706, 0x242a52 },
	{ 0x7707, 0x215263 },
	{ 0x7708, 0x222c42 },
	{ 0x7709, 0x21525f },
	{ 0x770a, 0x222c46 },
	{ 0x770b, 0x215260 },
	{ 0x770e, 0x233264 },
	{ 0x770f, 0x23325f },
	{ 0x7710, 0x223132 },
	{ 0x7711, 0x223136 },
	{ 0x7712, 0x223134 },
	{ 0x7713, 0x223133 },
	{ 0x7714, 0x242e55 },
	{ 0x7715, 0x223137 },
	{ 0x7716, 0x23325e },
	{ 0x7717, 0x242e4f },
	{ 0x7718, 0x233268 },
	{ 0x7719, 0x223138 },
	{ 0x771a, 0x223139 },
	{ 0x771b, 0x223131 },
	{ 0x771c, 0x242e51 },
	{ 0x771d, 0x223130 },
	{ 0x771e, 0x233759 },
	{ 0x771f, 0x215678 },
	{ 0x7720, 0x215679 },
	{ 0x7721, 0x233267 },
	{ 0x7722, 0x22313a },
	{ 0x7723, 0x223135 },
	{ 0x7724, 0x233265 },
	{ 0x7725, 0x223753 },
	{ 0x7726, 0x233755 },
	{ 0x7727, 0x22313b },
	{ 0x7728, 0x21567a },
	{ 0x7729, 0x215677 },
	{ 0x772a, 0x23325c },
	{ 0x772b, 0x233263 },
	{ 0x772d, 0x22374d },
	{ 0x772e, 0x24334f },
	{ 0x772f, 0x22374c },
	{ 0x7730, 0x233753 },
	{ 0x7731, 0x22374e },
	{ 0x7732, 0x22374f },
	{ 0x7733, 0x223751 },
	{ 0x7734, 0x223750 },
	{ 0x7735, 0x223755 },
	{ 0x7736, 0x215c3a },
	{ 0x7737, 0x215c37 },
	{ 0x7738, 0x215c3b },
	{ 0x7739, 0x22374b },
	{ 0x773a, 0x215c3c },
	{ 0x773b, 0x223754 },
	{ 0x773c, 0x215c39 },
	{ 0x773d, 0x223752 },
	{ 0x773e, 0x215c38 },
	{ 0x773f, 0x233262 },
	{ 0x7740, 0x233757 },
	{ 0x7741, 0x243356 },
	{ 0x7742, 0x233d56 },
	{ 0x7743, 0x233d53 },
	{ 0x7744, 0x223e40 },
	{ 0x7745, 0x223e42 },
	{ 0x7746, 0x223e3e },
	{ 0x7747, 0x223e3f },
	{ 0x7748, 0x233d51 },
	{ 0x7749, 0x233d52 },
	{ 0x774a, 0x223e43 },
	{ 0x774b, 0x223e45 },
	{ 0x774c, 0x223e46 },
	{ 0x774d, 0x223e41 },
	{ 0x774e, 0x223e44 },
	{ 0x774f, 0x21607a },
	{ 0x7752, 0x224541 },
	{ 0x7753, 0x234327 },
	{ 0x7754, 0x224546 },
	{ 0x7755, 0x22453e },
	{ 0x7756, 0x224542 },
	{ 0x7757, 0x243f29 },
	{ 0x7758, 0x234328 },
	{ 0x7759, 0x224547 },
	{ 0x775a, 0x224543 },
	{ 0x775b, 0x216542 },
	{ 0x775c, 0x21654a },
	{ 0x775d, 0x234325 },
	{ 0x775e, 0x216545 },
	{ 0x775f, 0x22453f },
	{ 0x7760, 0x224540 },
	{ 0x7761, 0x216975 },
	{ 0x7762, 0x21654d },
	{ 0x7763, 0x216546 },
	{ 0x7764, 0x234326 },
	{ 0x7765, 0x21654b },
	{ 0x7766, 0x216544 },
	{ 0x7767, 0x224545 },
	{ 0x7768, 0x21654c },
	{ 0x7769, 0x224544 },
	{ 0x776a, 0x216548 },
	{ 0x776b, 0x216543 },
	{ 0x776c, 0x216549 },
	{ 0x776d, 0x224548 },
	{ 0x776e, 0x224c2e },
	{ 0x776f, 0x224c30 },
	{ 0x7770, 0x244542 },
	{ 0x7771, 0x234839 },
	{ 0x7772, 0x244540 },
	{ 0x7773, 0x24453d },
	{ 0x7774, 0x234833 },
	{ 0x7775, 0x234836 },
	{ 0x7776, 0x234835 },
	{ 0x7777, 0x234834 },
	{ 0x7778, 0x234838 },
	{ 0x7779, 0x216547 },
	{ 0x777a, 0x23483b },
	{ 0x777b, 0x23483d },
	{ 0x777c, 0x224c2b },
	{ 0x777d, 0x216973 },
	{ 0x777e, 0x224c31 },
	{ 0x777f, 0x216974 },
	{ 0x7780, 0x224c2f },
	{ 0x7781, 0x224c2a },
	{ 0x7782, 0x224c2d },
	{ 0x7783, 0x224c32 },
	{ 0x7784, 0x216972 },
	{ 0x7785, 0x224c2c },
	{ 0x7787, 0x216d77 },
	{ 0x7788, 0x225247 },
	{ 0x7789, 0x225246 },
	{ 0x778a, 0x234d44 },
	{ 0x778b, 0x216d7a },
	{ 0x778c, 0x216d78 },
	{ 0x778d, 0x225244 },
	{ 0x778e, 0x216d76 },
	{ 0x778f, 0x225245 },
	{ 0x7790, 0x234d46 },
	{ 0x7791, 0x216d79 },
	{ 0x7794, 0x24515f },
	{ 0x7795, 0x225869 },
	{ 0x7796, 0x23517b },
	{ 0x7797, 0x22586b },
	{ 0x7798, 0x235179 },
	{ 0x7799, 0x22586a },
	{ 0x779a, 0x225862 },
	{ 0x779b, 0x225866 },
	{ 0x779c, 0x225865 },
	{ 0x779d, 0x225863 },
	{ 0x779e, 0x217150 },
	{ 0x779f, 0x217151 },
	{ 0x77a0, 0x21714f },
	{ 0x77a1, 0x225864 },
	{ 0x77a2, 0x225867 },
	{ 0x77a3, 0x225868 },
	{ 0x77a4, 0x235559 },
	{ 0x77a5, 0x217152 },
	{ 0x77a6, 0x235558 },
	{ 0x77a7, 0x21744a },
	{ 0x77a8, 0x225d6d },
	{ 0x77a9, 0x23555b },
	{ 0x77aa, 0x217447 },
	{ 0x77ab, 0x225d67 },
	{ 0x77ac, 0x217449 },
	{ 0x77ad, 0x21744b },
	{ 0x77ae, 0x245161 },
	{ 0x77af, 0x23555c },
	{ 0x77b0, 0x217448 },
	{ 0x77b1, 0x225d6c },
	{ 0x77b2, 0x225d68 },
	{ 0x77b3, 0x217446 },
	{ 0x77b4, 0x225d6b },
	{ 0x77b5, 0x225d66 },
	{ 0x77b6, 0x225d6a },
	{ 0x77b7, 0x225d69 },
	{ 0x77b8, 0x235836 },
	{ 0x77b9, 0x235838 },
	{ 0x77ba, 0x226242 },
	{ 0x77bb, 0x21766e },
	{ 0x77bc, 0x21766f },
	{ 0x77bd, 0x21766c },
	{ 0x77be, 0x23583b },
	{ 0x77bf, 0x21766d },
	{ 0x77c0, 0x23583a },
	{ 0x77c1, 0x235839 },
	{ 0x77c2, 0x226241 },
	{ 0x77c3, 0x246039 },
	{ 0x77c4, 0x226627 },
	{ 0x77c5, 0x235a60 },
	{ 0x77c6, 0x235a5f },
	{ 0x77c7, 0x217854 },
	{ 0x77c9, 0x226625 },
	{ 0x77ca, 0x226626 },
	{ 0x77cc, 0x226943 },
	{ 0x77cd, 0x226946 },
	{ 0x77ce, 0x226944 },
	{ 0x77cf, 0x226945 },
	{ 0x77d0, 0x226b6e },
	{ 0x77d1, 0x235e42 },
	{ 0x77d2, 0x24665e },
	{ 0x77d3, 0x217a7a },
	{ 0x77d4, 0x226f3a },
	{ 0x77d5, 0x227042 },
	{ 0x77d6, 0x246b74 },
	{ 0x77d7, 0x217c63 },
	{ 0x77d8, 0x227128 },
	{ 0x77d9, 0x227129 },
	{ 0x77da, 0x217d33 },
	{ 0x77db, 0x214679 },
	{ 0x77dc, 0x215264 },
	{ 0x77dd, 0x233269 },
	{ 0x77de, 0x223e47 },
	{ 0x77df, 0x233d57 },
	{ 0x77e0, 0x224549 },
	{ 0x77e1, 0x246c76 },
	{ 0x77e2, 0x21467a },
	{ 0x77e3, 0x214b32 },
	{ 0x77e4, 0x242752 },
	{ 0x77e5, 0x214f21 },
	{ 0x77e6, 0x232e36 },
	{ 0x77e7, 0x222c4a },
	{ 0x77e8, 0x222c4b },
	{ 0x77e9, 0x21567b },
	{ 0x77ea, 0x24335b },
	{ 0x77ec, 0x223e48 },
	{ 0x77ed, 0x21607b },
	{ 0x77ee, 0x21654e },
	{ 0x77ef, 0x21744c },
	{ 0x77f0, 0x225d6e },
	{ 0x77f1, 0x226628 },
	{ 0x77f2, 0x226947 },
	{ 0x77f3, 0x21467b },
	{ 0x77f4, 0x23267b },
	{ 0x77f5, 0x23267c },
	{ 0x77f6, 0x2f2523 },
	{ 0x77f7, 0x222841 },
	{ 0x77f8, 0x22283c },
	{ 0x77f9, 0x22283e },
	{ 0x77fa, 0x222840 },
	{ 0x77fb, 0x22283f },
	{ 0x77fc, 0x22283d },
	{ 0x77fd, 0x214f22 },
	{ 0x77fe, 0x2f2834 },
	{ 0x7802, 0x215265 },
	{ 0x7803, 0x222c54 },
	{ 0x7804, 0x232e39 },
	{ 0x7805, 0x222c4f },
	{ 0x7806, 0x222c4c },
	{ 0x7807, 0x232e3b },
	{ 0x7808, 0x232e3e },
	{ 0x7809, 0x222c53 },
	{ 0x780a, 0x232e37 },
	{ 0x780b, 0x232e3a },
	{ 0x780c, 0x215267 },
	{ 0x780d, 0x215268 },
	{ 0x780e, 0x222c52 },
	{ 0x780f, 0x222c51 },
	{ 0x7810, 0x222c50 },
	{ 0x7811, 0x222c4d },
	{ 0x7812, 0x222c4e },
	{ 0x7813, 0x222c55 },
	{ 0x7814, 0x215266 },
	{ 0x7815, 0x232e3d },
	{ 0x7818, 0x2f2c5c },
	{ 0x7819, 0x23656d },
	{ 0x781b, 0x23656e },
	{ 0x781d, 0x215721 },
	{ 0x781e, 0x23667c },
	{ 0x781f, 0x215727 },
	{ 0x7820, 0x215726 },
	{ 0x7821, 0x223144 },
	{ 0x7822, 0x22313e },
	{ 0x7823, 0x22313c },
	{ 0x7824, 0x23326c },
	{ 0x7825, 0x215724 },
	{ 0x7826, 0x22375c },
	{ 0x7827, 0x21567d },
	{ 0x7828, 0x223141 },
	{ 0x7829, 0x223145 },
	{ 0x782a, 0x223147 },
	{ 0x782b, 0x223143 },
	{ 0x782c, 0x22313d },
	{ 0x782d, 0x215725 },
	{ 0x782e, 0x223142 },
	{ 0x782f, 0x223140 },
	{ 0x7830, 0x21567c },
	{ 0x7831, 0x223148 },
	{ 0x7832, 0x215728 },
	{ 0x7833, 0x223146 },
	{ 0x7834, 0x215722 },
	{ 0x7835, 0x22313f },
	{ 0x7836, 0x23326d },
	{ 0x7837, 0x215723 },
	{ 0x7838, 0x21567e },
	{ 0x783d, 0x23656f },
	{ 0x7842, 0x233762 },
	{ 0x7843, 0x215c3e },
	{ 0x7844, 0x24335d },
	{ 0x7845, 0x22375d },
	{ 0x7846, 0x233763 },
	{ 0x7847, 0x23375d },
	{ 0x7848, 0x223756 },
	{ 0x7849, 0x223758 },
	{ 0x784a, 0x22375a },
	{ 0x784b, 0x23375f },
	{ 0x784c, 0x22375b },
	{ 0x784d, 0x223759 },
	{ 0x784e, 0x215c3f },
	{ 0x784f, 0x233761 },
	{ 0x7850, 0x22375e },
	{ 0x7851, 0x233760 },
	{ 0x7852, 0x223757 },
	{ 0x7853, 0x236570 },
	{ 0x7854, 0x236571 },
	{ 0x7858, 0x236572 },
	{ 0x785c, 0x223e4c },
	{ 0x785d, 0x21607c },
	{ 0x785e, 0x223e54 },
	{ 0x785f, 0x233d5c },
	{ 0x7860, 0x223e49 },
	{ 0x7861, 0x264c2f },
	{ 0x7862, 0x223e55 },
	{ 0x7863, 0x233d59 },
	{ 0x7864, 0x223e4a },
	{ 0x7865, 0x223e4b },
	{ 0x7866, 0x233d5d },
	{ 0x7867, 0x243954 },
	{ 0x7868, 0x223e53 },
	{ 0x7869, 0x223e52 },
	{ 0x786a, 0x223e4f },
	{ 0x786b, 0x215c3d },
	{ 0x786c, 0x21607d },
	{ 0x786d, 0x223e4d },
	{ 0x786e, 0x223e50 },
	{ 0x786f, 0x21607e },
	{ 0x7870, 0x223e51 },
	{ 0x7871, 0x223e4e },
	{ 0x7876, 0x233d5a },
	{ 0x7878, 0x234331 },
	{ 0x7879, 0x224554 },
	{ 0x787a, 0x23432d },
	{ 0x787b, 0x224558 },
	{ 0x787c, 0x216555 },
	{ 0x787d, 0x23432e },
	{ 0x787e, 0x224c38 },
	{ 0x787f, 0x216558 },
	{ 0x7880, 0x224556 },
	{ 0x7881, 0x234337 },
	{ 0x7882, 0x234329 },
	{ 0x7883, 0x224553 },
	{ 0x7884, 0x22454e },
	{ 0x7885, 0x224550 },
	{ 0x7886, 0x224551 },
	{ 0x7887, 0x22454a },
	{ 0x7888, 0x234335 },
	{ 0x7889, 0x216554 },
	{ 0x788a, 0x23432b },
	{ 0x788b, 0x234330 },
	{ 0x788c, 0x216553 },
	{ 0x788d, 0x234334 },
	{ 0x788e, 0x21654f },
	{ 0x788f, 0x22454d },
	{ 0x7890, 0x23432a },
	{ 0x7891, 0x216556 },
	{ 0x7892, 0x234336 },
	{ 0x7893, 0x216557 },
	{ 0x7894, 0x22454c },
	{ 0x7895, 0x22454f },
	{ 0x7896, 0x224557 },
	{ 0x7897, 0x216551 },
	{ 0x7898, 0x216552 },
	{ 0x7899, 0x224555 },
	{ 0x789a, 0x22454b },
	{ 0x789c, 0x2f4425 },
	{ 0x789d, 0x244553 },
	{ 0x789e, 0x224c3a },
	{ 0x789f, 0x216977 },
	{ 0x78a0, 0x224c3c },
	{ 0x78a1, 0x224552 },
	{ 0x78a2, 0x224c3e },
	{ 0x78a3, 0x21697b },
	{ 0x78a4, 0x224c3f },
	{ 0x78a5, 0x224c3b },
	{ 0x78a6, 0x23483e },
	{ 0x78a7, 0x216978 },
	{ 0x78a8, 0x224c37 },
	{ 0x78a9, 0x21697a },
	{ 0x78aa, 0x224c34 },
	{ 0x78ab, 0x224c39 },
	{ 0x78ac, 0x224c3d },
	{ 0x78ad, 0x224c36 },
	{ 0x78ae, 0x23483f },
	{ 0x78af, 0x234845 },
	{ 0x78b0, 0x216550 },
	{ 0x78b1, 0x234844 },
	{ 0x78b2, 0x224c33 },
	{ 0x78b3, 0x216979 },
	{ 0x78b4, 0x224c35 },
	{ 0x78b7, 0x236573 },
	{ 0x78b8, 0x234840 },
	{ 0x78b9, 0x2f4a3f },
	{ 0x78ba, 0x216d7d },
	{ 0x78bb, 0x225249 },
	{ 0x78bc, 0x216e23 },
	{ 0x78bd, 0x244b59 },
	{ 0x78be, 0x216e21 },
	{ 0x78bf, 0x244b57 },
	{ 0x78c0, 0x234d4a },
	{ 0x78c1, 0x216976 },
	{ 0x78c2, 0x234d4d },
	{ 0x78c3, 0x225250 },
	{ 0x78c4, 0x225251 },
	{ 0x78c5, 0x216d7c },
	{ 0x78c6, 0x234d48 },
	{ 0x78c7, 0x234d4c },
	{ 0x78c8, 0x22524f },
	{ 0x78c9, 0x225252 },
	{ 0x78ca, 0x216d7e },
	{ 0x78cb, 0x216d7b },
	{ 0x78cc, 0x22524b },
	{ 0x78cd, 0x225248 },
	{ 0x78ce, 0x22524d },
	{ 0x78cf, 0x22524a },
	{ 0x78d0, 0x216e24 },
	{ 0x78d1, 0x22524c },
	{ 0x78d2, 0x234d4b },
	{ 0x78d3, 0x234d49 },
	{ 0x78d4, 0x22524e },
	{ 0x78d5, 0x216e22 },
	{ 0x78d6, 0x235221 },
	{ 0x78d8, 0x236574 },
	{ 0x78da, 0x217154 },
	{ 0x78db, 0x225872 },
	{ 0x78dc, 0x235224 },
	{ 0x78dd, 0x22586c },
	{ 0x78de, 0x225870 },
	{ 0x78df, 0x225876 },
	{ 0x78e0, 0x225877 },
	{ 0x78e1, 0x225873 },
	{ 0x78e2, 0x225874 },
	{ 0x78e3, 0x225871 },
	{ 0x78e4, 0x244b5d },
	{ 0x78e5, 0x22586e },
	{ 0x78e6, 0x24516e },
	{ 0x78e7, 0x217156 },
	{ 0x78e8, 0x217153 },
	{ 0x78e9, 0x22586d },
	{ 0x78ea, 0x22586f },
	{ 0x78eb, 0x235222 },
	{ 0x78ec, 0x217155 },
	{ 0x78ed, 0x225875 },
	{ 0x78ee, 0x236575 },
	{ 0x78ef, 0x217450 },
	{ 0x78f0, 0x235560 },
	{ 0x78f1, 0x235562 },
	{ 0x78f2, 0x225d75 },
	{ 0x78f3, 0x225d6f },
	{ 0x78f4, 0x21744f },
	{ 0x78f6, 0x24573e },
	{ 0x78f7, 0x21744d },
	{ 0x78f8, 0x235561 },
	{ 0x78f9, 0x225d77 },
	{ 0x78fa, 0x21744e },
	{ 0x78fb, 0x225d72 },
	{ 0x78fc, 0x225d73 },
	{ 0x78fd, 0x225d70 },
	{ 0x78fe, 0x225d78 },
	{ 0x78ff, 0x225d74 },
	{ 0x7900, 0x245740 },
	{ 0x7901, 0x217451 },
	{ 0x7902, 0x225d71 },
	{ 0x7904, 0x225d79 },
	{ 0x7905, 0x225d76 },
	{ 0x7906, 0x235843 },
	{ 0x7907, 0x23583e },
	{ 0x7908, 0x235840 },
	{ 0x7909, 0x226246 },
	{ 0x790a, 0x23583f },
	{ 0x790b, 0x23583c },
	{ 0x790c, 0x226243 },
	{ 0x790d, 0x235842 },
	{ 0x790e, 0x217670 },
	{ 0x790f, 0x245c32 },
	{ 0x7910, 0x226247 },
	{ 0x7911, 0x226249 },
	{ 0x7912, 0x226248 },
	{ 0x7913, 0x226244 },
	{ 0x7914, 0x226245 },
	{ 0x7915, 0x235844 },
	{ 0x7917, 0x22662d },
	{ 0x7918, 0x235a61 },
	{ 0x7919, 0x217855 },
	{ 0x791a, 0x235a62 },
	{ 0x791b, 0x22662a },
	{ 0x791c, 0x22662c },
	{ 0x791d, 0x226629 },
	{ 0x791e, 0x22662e },
	{ 0x791f, 0x246042 },
	{ 0x7920, 0x235a63 },
	{ 0x7921, 0x22662b },
	{ 0x7922, 0x236576 },
	{ 0x7923, 0x226949 },
	{ 0x7924, 0x22694c },
	{ 0x7925, 0x226948 },
	{ 0x7926, 0x21797c },
	{ 0x7927, 0x22694a },
	{ 0x7928, 0x22694b },
	{ 0x7929, 0x22694d },
	{ 0x792a, 0x21797d },
	{ 0x792b, 0x217a21 },
	{ 0x792c, 0x21797e },
	{ 0x792d, 0x226b6f },
	{ 0x792e, 0x235e45 },
	{ 0x792f, 0x226b71 },
	{ 0x7930, 0x235e43 },
	{ 0x7931, 0x226b70 },
	{ 0x7932, 0x235e44 },
	{ 0x7935, 0x226d64 },
	{ 0x7936, 0x2f6a66 },
	{ 0x7937, 0x23603c },
	{ 0x7938, 0x227043 },
	{ 0x7939, 0x22712a },
	{ 0x793a, 0x21467c },
	{ 0x793c, 0x232433 },
	{ 0x793d, 0x222472 },
	{ 0x793e, 0x214f23 },
	{ 0x793f, 0x222843 },
	{ 0x7940, 0x214f24 },
	{ 0x7941, 0x214f25 },
	{ 0x7942, 0x222842 },
	{ 0x7944, 0x222c5a },
	{ 0x7945, 0x222c59 },
	{ 0x7946, 0x215269 },
	{ 0x7947, 0x21526c },
	{ 0x7948, 0x21526b },
	{ 0x7949, 0x21526a },
	{ 0x794a, 0x222c56 },
	{ 0x794b, 0x222c58 },
	{ 0x794c, 0x222c57 },
	{ 0x794d, 0x236577 },
	{ 0x794f, 0x22314b },
	{ 0x7950, 0x21572a },
	{ 0x7951, 0x22314f },
	{ 0x7952, 0x22314e },
	{ 0x7953, 0x22314d },
	{ 0x7954, 0x223149 },
	{ 0x7955, 0x215729 },
	{ 0x7956, 0x21572d },
	{ 0x7957, 0x215730 },
	{ 0x7958, 0x23326f },
	{ 0x7959, 0x233270 },
	{ 0x795a, 0x215731 },
	{ 0x795b, 0x22314a },
	{ 0x795c, 0x22314c },
	{ 0x795d, 0x21572f },
	{ 0x795e, 0x21572e },
	{ 0x795f, 0x21572c },
	{ 0x7960, 0x21572b },
	{ 0x7961, 0x223765 },
	{ 0x7962, 0x233272 },
	{ 0x7963, 0x223763 },
	{ 0x7964, 0x22375f },
	{ 0x7965, 0x215c40 },
	{ 0x7966, 0x233d5e },
	{ 0x7967, 0x223760 },
	{ 0x7968, 0x215c41 },
	{ 0x7969, 0x223761 },
	{ 0x796a, 0x223762 },
	{ 0x796b, 0x223764 },
	{ 0x796c, 0x233766 },
	{ 0x796d, 0x215c42 },
	{ 0x796e, 0x233765 },
	{ 0x7970, 0x223e59 },
	{ 0x7971, 0x233d5f },
	{ 0x7972, 0x223e58 },
	{ 0x7973, 0x223e57 },
	{ 0x7974, 0x223e56 },
	{ 0x7975, 0x233d64 },
	{ 0x7976, 0x233d62 },
	{ 0x7977, 0x24395a },
	{ 0x7979, 0x22455c },
	{ 0x797a, 0x216559 },
	{ 0x797b, 0x243f46 },
	{ 0x797c, 0x224559 },
	{ 0x797d, 0x22455b },
	{ 0x797e, 0x234338 },
	{ 0x797f, 0x21655a },
	{ 0x7980, 0x23433d },
	{ 0x7981, 0x21655b },
	{ 0x7982, 0x22455a },
	{ 0x7983, 0x234339 },
	{ 0x7984, 0x233d63 },
	{ 0x7986, 0x236578 },
	{ 0x7987, 0x234848 },
	{ 0x7988, 0x224c48 },
	{ 0x7989, 0x234847 },
	{ 0x798a, 0x224c41 },
	{ 0x798b, 0x224c42 },
	{ 0x798c, 0x25477e },
	{ 0x798d, 0x21697e },
	{ 0x798e, 0x21697c },
	{ 0x798f, 0x21697d },
	{ 0x7990, 0x224c4a },
	{ 0x7991, 0x254822 },
	{ 0x7992, 0x224c49 },
	{ 0x7993, 0x224c46 },
	{ 0x7994, 0x224c45 },
	{ 0x7995, 0x224c44 },
	{ 0x7996, 0x224c43 },
	{ 0x7997, 0x224c47 },
	{ 0x7998, 0x224c40 },
	{ 0x7999, 0x236579 },
	{ 0x799a, 0x225253 },
	{ 0x799b, 0x225258 },
	{ 0x799c, 0x225256 },
	{ 0x799d, 0x234d50 },
	{ 0x799e, 0x234d51 },
	{ 0x799f, 0x234d4f },
	{ 0x79a0, 0x225255 },
	{ 0x79a1, 0x225254 },
	{ 0x79a2, 0x225257 },
	{ 0x79a3, 0x23657a },
	{ 0x79a4, 0x225878 },
	{ 0x79a5, 0x235226 },
	{ 0x79a6, 0x217157 },
	{ 0x79a7, 0x217452 },
	{ 0x79a8, 0x225d7b },
	{ 0x79a9, 0x235227 },
	{ 0x79aa, 0x217453 },
	{ 0x79ab, 0x225d7a },
	{ 0x79ac, 0x22624b },
	{ 0x79ad, 0x22624a },
	{ 0x79ae, 0x217671 },
	{ 0x79af, 0x235845 },
	{ 0x79b0, 0x22662f },
	{ 0x79b1, 0x217856 },
	{ 0x79b2, 0x22694e },
	{ 0x79b3, 0x217b6b },
	{ 0x79b4, 0x226d65 },
	{ 0x79b5, 0x23603d },
	{ 0x79b6, 0x227045 },
	{ 0x79b7, 0x227044 },
	{ 0x79b8, 0x222167 },
	{ 0x79b9, 0x21526d },
	{ 0x79ba, 0x21526e },
	{ 0x79bb, 0x223766 },
	{ 0x79bc, 0x23657b },
	{ 0x79bd, 0x21655d },
	{ 0x79be, 0x21467d },
	{ 0x79bf, 0x214b35 },
	{ 0x79c0, 0x214b34 },
	{ 0x79c1, 0x214b33 },
	{ 0x79c2, 0x242468 },
	{ 0x79c3, 0x232a3e },
	{ 0x79c4, 0x232a3d },
	{ 0x79c5, 0x222844 },
	{ 0x79c6, 0x232a3f },
	{ 0x79c7, 0x232a42 },
	{ 0x79c8, 0x214f27 },
	{ 0x79c9, 0x214f26 },
	{ 0x79ca, 0x232a44 },
	{ 0x79cb, 0x215271 },
	{ 0x79cc, 0x23654c },
	{ 0x79cd, 0x222c5c },
	{ 0x79ce, 0x222c5f },
	{ 0x79cf, 0x222c5d },
	{ 0x79d0, 0x232e42 },
	{ 0x79d1, 0x21526f },
	{ 0x79d2, 0x215270 },
	{ 0x79d3, 0x232e40 },
	{ 0x79d4, 0x232e41 },
	{ 0x79d5, 0x222c5b },
	{ 0x79d6, 0x222c5e },
	{ 0x79d7, 0x232e43 },
	{ 0x79d8, 0x215738 },
	{ 0x79d9, 0x233274 },
	{ 0x79da, 0x233273 },
	{ 0x79db, 0x233279 },
	{ 0x79dc, 0x223156 },
	{ 0x79dd, 0x223158 },
	{ 0x79de, 0x223157 },
	{ 0x79df, 0x215735 },
	{ 0x79e0, 0x223152 },
	{ 0x79e1, 0x233276 },
	{ 0x79e2, 0x23327b },
	{ 0x79e3, 0x215733 },
	{ 0x79e4, 0x215732 },
	{ 0x79e5, 0x233277 },
	{ 0x79e6, 0x215736 },
	{ 0x79e7, 0x215734 },
	{ 0x79e8, 0x233278 },
	{ 0x79e9, 0x215737 },
	{ 0x79ea, 0x223155 },
	{ 0x79eb, 0x223150 },
	{ 0x79ec, 0x223151 },
	{ 0x79ed, 0x223154 },
	{ 0x79ee, 0x223153 },
	{ 0x79f0, 0x23327c },
	{ 0x79f1, 0x233769 },
	{ 0x79f2, 0x233767 },
	{ 0x79f3, 0x23376b },
	{ 0x79f5, 0x23376a },
	{ 0x79f6, 0x223769 },
	{ 0x79f7, 0x22376a },
	{ 0x79f8, 0x223768 },
	{ 0x79f9, 0x23376c },
	{ 0x79fa, 0x223767 },
	{ 0x79fb, 0x215c43 },
	{ 0x79fc, 0x2f373f },
	{ 0x79ff, 0x233d65 },
	{ 0x7a00, 0x216125 },
	{ 0x7a01, 0x264c48 },
	{ 0x7a02, 0x223e5a },
	{ 0x7a03, 0x223e5c },
	{ 0x7a04, 0x223e5e },
	{ 0x7a05, 0x216124 },
	{ 0x7a06, 0x264c43 },
	{ 0x7a07, 0x233d66 },
	{ 0x7a08, 0x216122 },
	{ 0x7a09, 0x233d69 },
	{ 0x7a0a, 0x223e5b },
	{ 0x7a0b, 0x216123 },
	{ 0x7a0c, 0x223e5d },
	{ 0x7a0d, 0x216121 },
	{ 0x7a0e, 0x233d68 },
	{ 0x7a0f, 0x234341 },
	{ 0x7a10, 0x224566 },
	{ 0x7a11, 0x22455d },
	{ 0x7a12, 0x224560 },
	{ 0x7a13, 0x224564 },
	{ 0x7a14, 0x216561 },
	{ 0x7a15, 0x224562 },
	{ 0x7a16, 0x243f50 },
	{ 0x7a17, 0x224561 },
	{ 0x7a18, 0x22455e },
	{ 0x7a19, 0x22455f },
	{ 0x7a1a, 0x21655f },
	{ 0x7a1b, 0x224565 },
	{ 0x7a1c, 0x21655e },
	{ 0x7a1d, 0x234344 },
	{ 0x7a1e, 0x216563 },
	{ 0x7a1f, 0x216562 },
	{ 0x7a20, 0x216560 },
	{ 0x7a21, 0x243f4a },
	{ 0x7a22, 0x224563 },
	{ 0x7a25, 0x236524 },
	{ 0x7a26, 0x224c50 },
	{ 0x7a27, 0x24455d },
	{ 0x7a28, 0x224c4f },
	{ 0x7a29, 0x23484b },
	{ 0x7a2a, 0x23484d },
	{ 0x7a2b, 0x224c4b },
	{ 0x7a2c, 0x234850 },
	{ 0x7a2d, 0x23484f },
	{ 0x7a2e, 0x216a21 },
	{ 0x7a2f, 0x224c4e },
	{ 0x7a30, 0x224c4d },
	{ 0x7a31, 0x216a22 },
	{ 0x7a32, 0x234852 },
	{ 0x7a33, 0x2f4a64 },
	{ 0x7a34, 0x244b63 },
	{ 0x7a35, 0x24455e },
	{ 0x7a36, 0x244b6b },
	{ 0x7a37, 0x216e29 },
	{ 0x7a38, 0x234d55 },
	{ 0x7a39, 0x22525a },
	{ 0x7a3a, 0x234d56 },
	{ 0x7a3b, 0x216e2a },
	{ 0x7a3c, 0x216e26 },
	{ 0x7a3d, 0x216e28 },
	{ 0x7a3e, 0x234d5a },
	{ 0x7a3f, 0x216e25 },
	{ 0x7a40, 0x216e27 },
	{ 0x7a41, 0x234d53 },
	{ 0x7a42, 0x234d57 },
	{ 0x7a44, 0x225879 },
	{ 0x7a45, 0x23522a },
	{ 0x7a46, 0x21715a },
	{ 0x7a47, 0x22587b },
	{ 0x7a48, 0x22587a },
	{ 0x7a49, 0x235564 },
	{ 0x7a4a, 0x224c4c },
	{ 0x7a4b, 0x21715c },
	{ 0x7a4c, 0x21715b },
	{ 0x7a4d, 0x217158 },
	{ 0x7a4e, 0x217159 },
	{ 0x7a4f, 0x23522c },
	{ 0x7a50, 0x2f5b59 },
	{ 0x7a53, 0x235229 },
	{ 0x7a54, 0x225e22 },
	{ 0x7a55, 0x245749 },
	{ 0x7a56, 0x225d7e },
	{ 0x7a57, 0x217454 },
	{ 0x7a58, 0x225e21 },
	{ 0x7a59, 0x245748 },
	{ 0x7a5a, 0x225e23 },
	{ 0x7a5b, 0x225d7d },
	{ 0x7a5c, 0x225d7c },
	{ 0x7a5f, 0x22624c },
	{ 0x7a60, 0x217674 },
	{ 0x7a61, 0x217672 },
	{ 0x7a62, 0x217673 },
	{ 0x7a64, 0x235a66 },
	{ 0x7a65, 0x246045 },
	{ 0x7a66, 0x235a65 },
	{ 0x7a67, 0x226630 },
	{ 0x7a68, 0x226631 },
	{ 0x7a69, 0x217858 },
	{ 0x7a6a, 0x235a67 },
	{ 0x7a6b, 0x217857 },
	{ 0x7a6c, 0x226950 },
	{ 0x7a6d, 0x226951 },
	{ 0x7a6e, 0x22694f },
	{ 0x7a6f, 0x235c64 },
	{ 0x7a70, 0x226d66 },
	{ 0x7a71, 0x226d67 },
	{ 0x7a72, 0x236076 },
	{ 0x7a73, 0x236077 },
	{ 0x7a74, 0x21467e },
	{ 0x7a75, 0x222268 },
	{ 0x7a76, 0x214b36 },
	{ 0x7a78, 0x222845 },
	{ 0x7a79, 0x214f29 },
	{ 0x7a7a, 0x214f28 },
	{ 0x7a7b, 0x222846 },
	{ 0x7a7c, 0x232e44 },
	{ 0x7a7d, 0x232e47 },
	{ 0x7a7e, 0x222c61 },
	{ 0x7a7f, 0x215272 },
	{ 0x7a80, 0x222c60 },
	{ 0x7a81, 0x215273 },
	{ 0x7a82, 0x232e49 },
	{ 0x7a83, 0x232e48 },
	{ 0x7a84, 0x215739 },
	{ 0x7a85, 0x22315b },
	{ 0x7a86, 0x223159 },
	{ 0x7a87, 0x22315f },
	{ 0x7a88, 0x21573a },
	{ 0x7a89, 0x22315a },
	{ 0x7a8a, 0x22315e },
	{ 0x7a8b, 0x22315c },
	{ 0x7a8c, 0x22315d },
	{ 0x7a8f, 0x22376b },
	{ 0x7a90, 0x22376d },
	{ 0x7a91, 0x233772 },
	{ 0x7a92, 0x215c44 },
	{ 0x7a93, 0x233771 },
	{ 0x7a94, 0x22376c },
	{ 0x7a95, 0x215c45 },
	{ 0x7a96, 0x216128 },
	{ 0x7a97, 0x216127 },
	{ 0x7a98, 0x216126 },
	{ 0x7a99, 0x223e5f },
	{ 0x7a9a, 0x233770 },
	{ 0x7a9b, 0x243965 },
	{ 0x7a9e, 0x224569 },
	{ 0x7a9f, 0x216564 },
	{ 0x7aa0, 0x216565 },
	{ 0x7aa1, 0x234346 },
	{ 0x7aa2, 0x224568 },
	{ 0x7aa3, 0x224567 },
	{ 0x7aa4, 0x234347 },
	{ 0x7aa7, 0x23657c },
	{ 0x7aa8, 0x224c51 },
	{ 0x7aa9, 0x216a24 },
	{ 0x7aaa, 0x216a23 },
	{ 0x7aab, 0x224c52 },
	{ 0x7aac, 0x224c53 },
	{ 0x7aae, 0x216e2c },
	{ 0x7aaf, 0x216e2b },
	{ 0x7ab0, 0x234d5b },
	{ 0x7ab1, 0x225921 },
	{ 0x7ab2, 0x22525b },
	{ 0x7ab3, 0x22525d },
	{ 0x7ab4, 0x22525c },
	{ 0x7ab5, 0x22587e },
	{ 0x7ab6, 0x22587c },
	{ 0x7ab7, 0x225922 },
	{ 0x7ab8, 0x22587d },
	{ 0x7ab9, 0x255652 },
	{ 0x7aba, 0x21715d },
	{ 0x7abb, 0x23522f },
	{ 0x7abc, 0x245227 },
	{ 0x7abd, 0x23522e },
	{ 0x7abe, 0x225e24 },
	{ 0x7abf, 0x217455 },
	{ 0x7ac0, 0x225e25 },
	{ 0x7ac1, 0x225e26 },
	{ 0x7ac2, 0x235568 },
	{ 0x7ac4, 0x217675 },
	{ 0x7ac5, 0x217676 },
	{ 0x7ac6, 0x24604b },
	{ 0x7ac7, 0x217a22 },
	{ 0x7ac8, 0x235e49 },
	{ 0x7ac9, 0x235e48 },
	{ 0x7aca, 0x217c3d },
	{ 0x7acb, 0x214721 },
	{ 0x7acc, 0x23267e },
	{ 0x7acd, 0x232721 },
	{ 0x7ace, 0x24275b },
	{ 0x7acf, 0x232a47 },
	{ 0x7ad0, 0x232e4e },
	{ 0x7ad1, 0x222c62 },
	{ 0x7ad2, 0x232e4f },
	{ 0x7ad3, 0x232e4d },
	{ 0x7ad4, 0x232e4b },
	{ 0x7ad5, 0x232e4c },
	{ 0x7ad7, 0x2f2c76 },
	{ 0x7ad8, 0x223160 },
	{ 0x7ad9, 0x21573b },
	{ 0x7ada, 0x233323 },
	{ 0x7adb, 0x233326 },
	{ 0x7adc, 0x233327 },
	{ 0x7add, 0x233324 },
	{ 0x7adf, 0x215d7e },
	{ 0x7ae0, 0x215d7d },
	{ 0x7ae1, 0x233773 },
	{ 0x7ae2, 0x233d71 },
	{ 0x7ae3, 0x21612a },
	{ 0x7ae4, 0x223e61 },
	{ 0x7ae5, 0x216129 },
	{ 0x7ae6, 0x223e60 },
	{ 0x7ae7, 0x233d70 },
	{ 0x7ae8, 0x243f57 },
	{ 0x7ae9, 0x234349 },
	{ 0x7aea, 0x23434a },
	{ 0x7aeb, 0x22456a },
	{ 0x7aec, 0x234854 },
	{ 0x7aed, 0x216a25 },
	{ 0x7aee, 0x224c54 },
	{ 0x7aef, 0x216a26 },
	{ 0x7af0, 0x234855 },
	{ 0x7af1, 0x235230 },
	{ 0x7af2, 0x235569 },
	{ 0x7af3, 0x23556a },
	{ 0x7af4, 0x245750 },
	{ 0x7af5, 0x235849 },
	{ 0x7af6, 0x217a23 },
	{ 0x7af7, 0x226952 },
	{ 0x7af8, 0x235f55 },
	{ 0x7af9, 0x21484c },
	{ 0x7afa, 0x214f2a },
	{ 0x7afb, 0x222847 },
	{ 0x7afc, 0x232e51 },
	{ 0x7afd, 0x215275 },
	{ 0x7afe, 0x232e50 },
	{ 0x7aff, 0x215274 },
	{ 0x7b00, 0x222c63 },
	{ 0x7b01, 0x222c64 },
	{ 0x7b04, 0x223162 },
	{ 0x7b05, 0x223164 },
	{ 0x7b06, 0x21573c },
	{ 0x7b08, 0x223166 },
	{ 0x7b09, 0x223169 },
	{ 0x7b0a, 0x223167 },
	{ 0x7b0b, 0x23332b },
	{ 0x7b0c, 0x242e71 },
	{ 0x7b0d, 0x23332a },
	{ 0x7b0e, 0x223168 },
	{ 0x7b0f, 0x223165 },
	{ 0x7b10, 0x223161 },
	{ 0x7b11, 0x21573d },
	{ 0x7b12, 0x22316a },
	{ 0x7b13, 0x223163 },
	{ 0x7b14, 0x23332c },
	{ 0x7b16, 0x233778 },
	{ 0x7b17, 0x233779 },
	{ 0x7b18, 0x223776 },
	{ 0x7b19, 0x215c4b },
	{ 0x7b1a, 0x223821 },
	{ 0x7b1b, 0x215c48 },
	{ 0x7b1c, 0x233777 },
	{ 0x7b1d, 0x223778 },
	{ 0x7b1e, 0x215c4c },
	{ 0x7b1f, 0x23377b },
	{ 0x7b20, 0x215c46 },
	{ 0x7b21, 0x233776 },
	{ 0x7b22, 0x223773 },
	{ 0x7b23, 0x223822 },
	{ 0x7b24, 0x223774 },
	{ 0x7b25, 0x223771 },
	{ 0x7b26, 0x215c4a },
	{ 0x7b27, 0x24337c },
	{ 0x7b28, 0x215c47 },
	{ 0x7b29, 0x24337a },
	{ 0x7b2a, 0x223777 },
	{ 0x7b2b, 0x22377a },
	{ 0x7b2c, 0x215c49 },
	{ 0x7b2d, 0x22377b },
	{ 0x7b2e, 0x215c4d },
	{ 0x7b2f, 0x22377c },
	{ 0x7b30, 0x223772 },
	{ 0x7b31, 0x223779 },
	{ 0x7b32, 0x22377d },
	{ 0x7b33, 0x223775 },
	{ 0x7b34, 0x223770 },
	{ 0x7b35, 0x22376e },
	{ 0x7b36, 0x23377a },
	{ 0x7b37, 0x23657d },
	{ 0x7b38, 0x22377e },
	{ 0x7b39, 0x2f374d },
	{ 0x7b3b, 0x22376f },
	{ 0x7b3d, 0x2f367e },
	{ 0x7b3f, 0x253b24 },
	{ 0x7b40, 0x223e68 },
	{ 0x7b41, 0x233d7b },
	{ 0x7b42, 0x233d78 },
	{ 0x7b43, 0x233d75 },
	{ 0x7b44, 0x223e64 },
	{ 0x7b45, 0x223e6a },
	{ 0x7b46, 0x21612d },
	{ 0x7b47, 0x223e63 },
	{ 0x7b48, 0x223e65 },
	{ 0x7b49, 0x21612b },
	{ 0x7b4a, 0x223e62 },
	{ 0x7b4b, 0x216132 },
	{ 0x7b4c, 0x223e66 },
	{ 0x7b4d, 0x216131 },
	{ 0x7b4e, 0x223e67 },
	{ 0x7b4f, 0x216133 },
	{ 0x7b50, 0x21612e },
	{ 0x7b51, 0x216134 },
	{ 0x7b52, 0x21612f },
	{ 0x7b53, 0x233d79 },
	{ 0x7b54, 0x216130 },
	{ 0x7b55, 0x233d72 },
	{ 0x7b56, 0x21612c },
	{ 0x7b57, 0x233d76 },
	{ 0x7b58, 0x223e69 },
	{ 0x7b59, 0x23657e },
	{ 0x7b5e, 0x23434f },
	{ 0x7b5f, 0x243f67 },
	{ 0x7b60, 0x216568 },
	{ 0x7b61, 0x224575 },
	{ 0x7b62, 0x23434c },
	{ 0x7b63, 0x224578 },
	{ 0x7b64, 0x22456c },
	{ 0x7b65, 0x224571 },
	{ 0x7b66, 0x22456b },
	{ 0x7b67, 0x21656a },
	{ 0x7b68, 0x234355 },
	{ 0x7b69, 0x22456f },
	{ 0x7b6a, 0x243f5e },
	{ 0x7b6b, 0x23434d },
	{ 0x7b6c, 0x233d77 },
	{ 0x7b6d, 0x22456d },
	{ 0x7b6e, 0x216569 },
	{ 0x7b6f, 0x234354 },
	{ 0x7b70, 0x224574 },
	{ 0x7b71, 0x224573 },
	{ 0x7b72, 0x224570 },
	{ 0x7b73, 0x224572 },
	{ 0x7b74, 0x22456e },
	{ 0x7b75, 0x216a2a },
	{ 0x7b76, 0x224577 },
	{ 0x7b77, 0x216566 },
	{ 0x7b78, 0x224576 },
	{ 0x7b79, 0x234351 },
	{ 0x7b7b, 0x2f4445 },
	{ 0x7b81, 0x234856 },
	{ 0x7b82, 0x224c64 },
	{ 0x7b83, 0x234858 },
	{ 0x7b84, 0x216a31 },
	{ 0x7b85, 0x224c5f },
	{ 0x7b86, 0x234860 },
	{ 0x7b87, 0x216a30 },
	{ 0x7b88, 0x224c55 },
	{ 0x7b89, 0x24456b },
	{ 0x7b8a, 0x224c57 },
	{ 0x7b8b, 0x216a29 },
	{ 0x7b8c, 0x224c5c },
	{ 0x7b8d, 0x224c5b },
	{ 0x7b8e, 0x224c5e },
	{ 0x7b8f, 0x216a2e },
	{ 0x7b90, 0x224c59 },
	{ 0x7b91, 0x224c58 },
	{ 0x7b92, 0x23485a },
	{ 0x7b93, 0x23485e },
	{ 0x7b94, 0x216a2d },
	{ 0x7b95, 0x216a28 },
	{ 0x7b96, 0x224c5a },
	{ 0x7b97, 0x216a2b },
	{ 0x7b98, 0x224c60 },
	{ 0x7b99, 0x224c62 },
	{ 0x7b9b, 0x224c5d },
	{ 0x7b9c, 0x224c56 },
	{ 0x7b9d, 0x216a2c },
	{ 0x7b9e, 0x234857 },
	{ 0x7b9f, 0x23485d },
	{ 0x7ba0, 0x216e34 },
	{ 0x7ba1, 0x216a27 },
	{ 0x7ba2, 0x244564 },
	{ 0x7ba3, 0x23485c },
	{ 0x7ba4, 0x224c63 },
	{ 0x7ba5, 0x244570 },
	{ 0x7bac, 0x225261 },
	{ 0x7bad, 0x216e2d },
	{ 0x7bae, 0x234d5c },
	{ 0x7baf, 0x225263 },
	{ 0x7bb0, 0x244c2b },
	{ 0x7bb1, 0x216e2e },
	{ 0x7bb2, 0x234d65 },
	{ 0x7bb3, 0x234d5d },
	{ 0x7bb4, 0x216e30 },
	{ 0x7bb5, 0x225266 },
	{ 0x7bb6, 0x244b7a },
	{ 0x7bb7, 0x22525e },
	{ 0x7bb8, 0x216a2f },
	{ 0x7bb9, 0x225264 },
	{ 0x7bba, 0x244b73 },
	{ 0x7bbb, 0x244c31 },
	{ 0x7bbc, 0x244b74 },
	{ 0x7bbd, 0x244c2a },
	{ 0x7bbe, 0x225260 },
	{ 0x7bbf, 0x234d60 },
	{ 0x7bc0, 0x216567 },
	{ 0x7bc1, 0x216e33 },
	{ 0x7bc2, 0x244c21 },
	{ 0x7bc3, 0x244b78 },
	{ 0x7bc4, 0x216e2f },
	{ 0x7bc5, 0x244c26 },
	{ 0x7bc6, 0x216e31 },
	{ 0x7bc7, 0x216e32 },
	{ 0x7bc8, 0x244b76 },
	{ 0x7bc9, 0x217160 },
	{ 0x7bca, 0x225265 },
	{ 0x7bcb, 0x22525f },
	{ 0x7bcc, 0x216e35 },
	{ 0x7bcd, 0x234d63 },
	{ 0x7bce, 0x225262 },
	{ 0x7bd0, 0x236621 },
	{ 0x7bd4, 0x22592c },
	{ 0x7bd5, 0x225927 },
	{ 0x7bd6, 0x24522d },
	{ 0x7bd7, 0x255669 },
	{ 0x7bd8, 0x225931 },
	{ 0x7bd9, 0x21715e },
	{ 0x7bda, 0x225929 },
	{ 0x7bdb, 0x217162 },
	{ 0x7bdc, 0x22592f },
	{ 0x7bdd, 0x225926 },
	{ 0x7bde, 0x225923 },
	{ 0x7bdf, 0x225932 },
	{ 0x7be0, 0x21745b },
	{ 0x7be1, 0x217163 },
	{ 0x7be2, 0x22592e },
	{ 0x7be3, 0x225924 },
	{ 0x7be4, 0x217161 },
	{ 0x7be5, 0x225928 },
	{ 0x7be6, 0x217165 },
	{ 0x7be7, 0x225925 },
	{ 0x7be8, 0x22592a },
	{ 0x7be9, 0x217164 },
	{ 0x7bea, 0x22592d },
	{ 0x7beb, 0x225930 },
	{ 0x7bec, 0x235233 },
	{ 0x7bed, 0x235234 },
	{ 0x7bf0, 0x225e38 },
	{ 0x7bf1, 0x225e39 },
	{ 0x7bf2, 0x225e29 },
	{ 0x7bf3, 0x225e30 },
	{ 0x7bf4, 0x225e2e },
	{ 0x7bf5, 0x24575f },
	{ 0x7bf6, 0x23556d },
	{ 0x7bf7, 0x217459 },
	{ 0x7bf8, 0x225e35 },
	{ 0x7bf9, 0x22592b },
	{ 0x7bfa, 0x23556b },
	{ 0x7bfb, 0x225e2c },
	{ 0x7bfc, 0x23556e },
	{ 0x7bfd, 0x225e36 },
	{ 0x7bfe, 0x217458 },
	{ 0x7bff, 0x225e2b },
	{ 0x7c00, 0x225e2a },
	{ 0x7c01, 0x225e34 },
	{ 0x7c02, 0x225e31 },
	{ 0x7c03, 0x225e33 },
	{ 0x7c04, 0x245754 },
	{ 0x7c05, 0x225e27 },
	{ 0x7c06, 0x225e37 },
	{ 0x7c07, 0x217456 },
	{ 0x7c08, 0x235570 },
	{ 0x7c09, 0x225e32 },
	{ 0x7c0a, 0x225e3b },
	{ 0x7c0b, 0x225e2f },
	{ 0x7c0c, 0x21745a },
	{ 0x7c0d, 0x217457 },
	{ 0x7c0e, 0x225e2d },
	{ 0x7c0f, 0x225e28 },
	{ 0x7c10, 0x225e3a },
	{ 0x7c11, 0x21715f },
	{ 0x7c12, 0x235571 },
	{ 0x7c14, 0x2f5b5f },
	{ 0x7c15, 0x245757 },
	{ 0x7c18, 0x23556f },
	{ 0x7c19, 0x22624f },
	{ 0x7c1a, 0x235850 },
	{ 0x7c1b, 0x23584e },
	{ 0x7c1c, 0x22624d },
	{ 0x7c1d, 0x226253 },
	{ 0x7c1e, 0x21767a },
	{ 0x7c1f, 0x226251 },
	{ 0x7c20, 0x226250 },
	{ 0x7c21, 0x21767c },
	{ 0x7c22, 0x226256 },
	{ 0x7c23, 0x21767b },
	{ 0x7c24, 0x235851 },
	{ 0x7c25, 0x226257 },
	{ 0x7c26, 0x226254 },
	{ 0x7c27, 0x217678 },
	{ 0x7c28, 0x226255 },
	{ 0x7c29, 0x22624e },
	{ 0x7c2a, 0x217679 },
	{ 0x7c2b, 0x217677 },
	{ 0x7c2c, 0x226635 },
	{ 0x7c2d, 0x226252 },
	{ 0x7c2e, 0x23584c },
	{ 0x7c2f, 0x236622 },
	{ 0x7c30, 0x226258 },
	{ 0x7c32, 0x236623 },
	{ 0x7c33, 0x226632 },
	{ 0x7c34, 0x235a6f },
	{ 0x7c35, 0x235a6e },
	{ 0x7c36, 0x24604e },
	{ 0x7c37, 0x21785d },
	{ 0x7c38, 0x21785b },
	{ 0x7c39, 0x226634 },
	{ 0x7c3a, 0x24604c },
	{ 0x7c3b, 0x226636 },
	{ 0x7c3c, 0x226633 },
	{ 0x7c3d, 0x21785c },
	{ 0x7c3e, 0x217859 },
	{ 0x7c3f, 0x21785a },
	{ 0x7c40, 0x21785e },
	{ 0x7c42, 0x236624 },
	{ 0x7c43, 0x217a25 },
	{ 0x7c44, 0x235c66 },
	{ 0x7c45, 0x226957 },
	{ 0x7c46, 0x256c79 },
	{ 0x7c47, 0x226956 },
	{ 0x7c48, 0x226954 },
	{ 0x7c49, 0x226953 },
	{ 0x7c4a, 0x226955 },
	{ 0x7c4b, 0x235c65 },
	{ 0x7c4c, 0x217a24 },
	{ 0x7c4d, 0x217a26 },
	{ 0x7c4e, 0x236625 },
	{ 0x7c4f, 0x2f6567 },
	{ 0x7c50, 0x217a7b },
	{ 0x7c51, 0x235e4c },
	{ 0x7c52, 0x24666f },
	{ 0x7c53, 0x226b73 },
	{ 0x7c54, 0x226b72 },
	{ 0x7c55, 0x235c67 },
	{ 0x7c56, 0x235e4b },
	{ 0x7c57, 0x226d68 },
	{ 0x7c58, 0x235f58 },
	{ 0x7c59, 0x226d6a },
	{ 0x7c5a, 0x226d6c },
	{ 0x7c5b, 0x226d6b },
	{ 0x7c5c, 0x226d69 },
	{ 0x7c5d, 0x235f57 },
	{ 0x7c5e, 0x23603f },
	{ 0x7c5f, 0x217b6d },
	{ 0x7c60, 0x217b6c },
	{ 0x7c62, 0x23603e },
	{ 0x7c63, 0x217c3f },
	{ 0x7c64, 0x217c3e },
	{ 0x7c65, 0x217c40 },
	{ 0x7c66, 0x226f3c },
	{ 0x7c67, 0x226f3b },
	{ 0x7c68, 0x236626 },
	{ 0x7c69, 0x22712b },
	{ 0x7c6a, 0x227046 },
	{ 0x7c6b, 0x22712c },
	{ 0x7c6c, 0x217d25 },
	{ 0x7c6d, 0x236144 },
	{ 0x7c6e, 0x217d26 },
	{ 0x7c6f, 0x22715c },
	{ 0x7c70, 0x246d5b },
	{ 0x7c71, 0x23623a },
	{ 0x7c72, 0x217d4b },
	{ 0x7c73, 0x21484d },
	{ 0x7c74, 0x232a49 },
	{ 0x7c75, 0x222848 },
	{ 0x7c76, 0x232a48 },
	{ 0x7c77, 0x232e52 },
	{ 0x7c78, 0x222c66 },
	{ 0x7c79, 0x222c67 },
	{ 0x7c7a, 0x222c65 },
	{ 0x7c7b, 0x232e54 },
	{ 0x7c7c, 0x232e53 },
	{ 0x7c7d, 0x215276 },
	{ 0x7c7e, 0x2f2d21 },
	{ 0x7c7f, 0x222c68 },
	{ 0x7c80, 0x222c69 },
	{ 0x7c81, 0x222c6a },
	{ 0x7c83, 0x233331 },
	{ 0x7c84, 0x22316b },
	{ 0x7c85, 0x223171 },
	{ 0x7c86, 0x23332e },
	{ 0x7c87, 0x233330 },
	{ 0x7c88, 0x22316f },
	{ 0x7c89, 0x21573e },
	{ 0x7c8a, 0x22316d },
	{ 0x7c8b, 0x233332 },
	{ 0x7c8c, 0x22316e },
	{ 0x7c8d, 0x223170 },
	{ 0x7c8e, 0x23332d },
	{ 0x7c91, 0x22316c },
	{ 0x7c92, 0x215c4e },
	{ 0x7c93, 0x23377d },
	{ 0x7c94, 0x223823 },
	{ 0x7c95, 0x215c50 },
	{ 0x7c96, 0x223825 },
	{ 0x7c97, 0x215c4f },
	{ 0x7c98, 0x223824 },
	{ 0x7c99, 0x23377e },
	{ 0x7c9a, 0x233821 },
	{ 0x7c9b, 0x23383e },
	{ 0x7c9c, 0x233822 },
	{ 0x7c9d, 0x243422 },
	{ 0x7c9e, 0x223e6c },
	{ 0x7c9f, 0x216135 },
	{ 0x7ca0, 0x233e21 },
	{ 0x7ca1, 0x223e6e },
	{ 0x7ca2, 0x223e6b },
	{ 0x7ca3, 0x223826 },
	{ 0x7ca4, 0x233e23 },
	{ 0x7ca5, 0x216136 },
	{ 0x7ca6, 0x233e22 },
	{ 0x7ca7, 0x233d7e },
	{ 0x7ca8, 0x223e6d },
	{ 0x7ca9, 0x236627 },
	{ 0x7cab, 0x2f3e21 },
	{ 0x7cac, 0x2f3e23 },
	{ 0x7cae, 0x234358 },
	{ 0x7caf, 0x22457b },
	{ 0x7cb0, 0x23435c },
	{ 0x7cb1, 0x21656b },
	{ 0x7cb2, 0x224579 },
	{ 0x7cb3, 0x21656c },
	{ 0x7cb4, 0x22457a },
	{ 0x7cb5, 0x21656d },
	{ 0x7cb6, 0x244574 },
	{ 0x7cb7, 0x234862 },
	{ 0x7cb8, 0x234861 },
	{ 0x7cb9, 0x216a32 },
	{ 0x7cba, 0x224c68 },
	{ 0x7cbb, 0x224c65 },
	{ 0x7cbc, 0x224c67 },
	{ 0x7cbd, 0x216a33 },
	{ 0x7cbe, 0x216a34 },
	{ 0x7cbf, 0x224c66 },
	{ 0x7cc0, 0x2f4b27 },
	{ 0x7cc1, 0x2f4b2b },
	{ 0x7cc2, 0x234d6f },
	{ 0x7cc3, 0x234d71 },
	{ 0x7cc4, 0x234d6d },
	{ 0x7cc5, 0x225267 },
	{ 0x7cc6, 0x234d70 },
	{ 0x7cc7, 0x234d73 },
	{ 0x7cc8, 0x225268 },
	{ 0x7cc9, 0x234d72 },
	{ 0x7cca, 0x216e36 },
	{ 0x7ccb, 0x22526a },
	{ 0x7ccc, 0x225269 },
	{ 0x7ccd, 0x234d6e },
	{ 0x7cce, 0x212323 },
	{ 0x7ccf, 0x245244 },
	{ 0x7cd0, 0x225936 },
	{ 0x7cd1, 0x225937 },
	{ 0x7cd2, 0x225933 },
	{ 0x7cd3, 0x235237 },
	{ 0x7cd4, 0x225934 },
	{ 0x7cd5, 0x217166 },
	{ 0x7cd6, 0x217167 },
	{ 0x7cd7, 0x225935 },
	{ 0x7cd9, 0x217461 },
	{ 0x7cda, 0x235575 },
	{ 0x7cdb, 0x235574 },
	{ 0x7cdc, 0x21745d },
	{ 0x7cdd, 0x217462 },
	{ 0x7cde, 0x21745e },
	{ 0x7cdf, 0x217460 },
	{ 0x7ce0, 0x21745c },
	{ 0x7ce1, 0x235239 },
	{ 0x7ce2, 0x21745f },
	{ 0x7ce3, 0x235855 },
	{ 0x7ce4, 0x245c5a },
	{ 0x7ce5, 0x245c5b },
	{ 0x7ce6, 0x235854 },
	{ 0x7ce7, 0x21767d },
	{ 0x7ce8, 0x225e3c },
	{ 0x7ce9, 0x274857 },
	{ 0x7cea, 0x226638 },
	{ 0x7ceb, 0x24605a },
	{ 0x7cec, 0x226637 },
	{ 0x7ced, 0x236628 },
	{ 0x7cee, 0x226958 },
	{ 0x7cef, 0x217a27 },
	{ 0x7cf0, 0x217a28 },
	{ 0x7cf1, 0x226d6e },
	{ 0x7cf2, 0x226b74 },
	{ 0x7cf3, 0x236169 },
	{ 0x7cf4, 0x226d6d },
	{ 0x7cf5, 0x236040 },
	{ 0x7cf6, 0x22712d },
	{ 0x7cf7, 0x227172 },
	{ 0x7cf8, 0x21484e },
	{ 0x7cfa, 0x232722 },
	{ 0x7cfb, 0x214b37 },
	{ 0x7cfc, 0x232a4b },
	{ 0x7cfd, 0x222849 },
	{ 0x7cfe, 0x214f2b },
	{ 0x7cff, 0x232a4a },
	{ 0x7d00, 0x215279 },
	{ 0x7d01, 0x222c6d },
	{ 0x7d02, 0x215277 },
	{ 0x7d03, 0x222c6b },
	{ 0x7d04, 0x21527c },
	{ 0x7d05, 0x215278 },
	{ 0x7d06, 0x21527d },
	{ 0x7d07, 0x21527b },
	{ 0x7d08, 0x222c6c },
	{ 0x7d09, 0x21527a },
	{ 0x7d0a, 0x215742 },
	{ 0x7d0b, 0x215741 },
	{ 0x7d0c, 0x22317c },
	{ 0x7d0d, 0x21574a },
	{ 0x7d0e, 0x223175 },
	{ 0x7d0f, 0x22317b },
	{ 0x7d10, 0x215746 },
	{ 0x7d11, 0x223174 },
	{ 0x7d12, 0x22317a },
	{ 0x7d13, 0x223178 },
	{ 0x7d14, 0x215745 },
	{ 0x7d15, 0x215747 },
	{ 0x7d16, 0x223177 },
	{ 0x7d17, 0x215740 },
	{ 0x7d18, 0x223176 },
	{ 0x7d19, 0x21574b },
	{ 0x7d1a, 0x215748 },
	{ 0x7d1b, 0x21574c },
	{ 0x7d1c, 0x215749 },
	{ 0x7d1d, 0x223173 },
	{ 0x7d1e, 0x223172 },
	{ 0x7d1f, 0x223179 },
	{ 0x7d20, 0x215743 },
	{ 0x7d21, 0x21573f },
	{ 0x7d22, 0x215744 },
	{ 0x7d23, 0x242f25 },
	{ 0x7d24, 0x233337 },
	{ 0x7d25, 0x23333b },
	{ 0x7d28, 0x223835 },
	{ 0x7d29, 0x22382e },
	{ 0x7d2a, 0x243a26 },
	{ 0x7d2b, 0x21613b },
	{ 0x7d2c, 0x22382d },
	{ 0x7d2d, 0x233829 },
	{ 0x7d2e, 0x215c54 },
	{ 0x7d2f, 0x215c5b },
	{ 0x7d30, 0x215c58 },
	{ 0x7d31, 0x215c5e },
	{ 0x7d32, 0x215c5d },
	{ 0x7d33, 0x215c59 },
	{ 0x7d34, 0x233826 },
	{ 0x7d35, 0x223827 },
	{ 0x7d36, 0x22382a },
	{ 0x7d37, 0x233827 },
	{ 0x7d38, 0x223829 },
	{ 0x7d39, 0x215c55 },
	{ 0x7d3a, 0x22382b },
	{ 0x7d3b, 0x223834 },
	{ 0x7d3c, 0x215c56 },
	{ 0x7d3d, 0x223828 },
	{ 0x7d3e, 0x223831 },
	{ 0x7d3f, 0x223832 },
	{ 0x7d40, 0x215c57 },
	{ 0x7d41, 0x22382f },
	{ 0x7d42, 0x215c5c },
	{ 0x7d43, 0x215c52 },
	{ 0x7d44, 0x215c5a },
	{ 0x7d45, 0x22382c },
	{ 0x7d46, 0x215c51 },
	{ 0x7d47, 0x223830 },
	{ 0x7d48, 0x23382e },
	{ 0x7d49, 0x233824 },
	{ 0x7d4a, 0x223833 },
	{ 0x7d4b, 0x2f3754 },
	{ 0x7d4c, 0x23382b },
	{ 0x7d4d, 0x233e34 },
	{ 0x7d4e, 0x223f21 },
	{ 0x7d4f, 0x223e76 },
	{ 0x7d50, 0x216138 },
	{ 0x7d51, 0x223e7d },
	{ 0x7d52, 0x223e7a },
	{ 0x7d53, 0x223e72 },
	{ 0x7d54, 0x223e7b },
	{ 0x7d55, 0x21613a },
	{ 0x7d56, 0x223e73 },
	{ 0x7d57, 0x233e29 },
	{ 0x7d58, 0x223e6f },
	{ 0x7d59, 0x233e26 },
	{ 0x7d5a, 0x233e2e },
	{ 0x7d5b, 0x216573 },
	{ 0x7d5c, 0x223e78 },
	{ 0x7d5d, 0x233e2f },
	{ 0x7d5e, 0x216137 },
	{ 0x7d5f, 0x223e7e },
	{ 0x7d60, 0x233e28 },
	{ 0x7d61, 0x21613e },
	{ 0x7d62, 0x216140 },
	{ 0x7d63, 0x223e71 },
	{ 0x7d64, 0x233e2c },
	{ 0x7d65, 0x243a27 },
	{ 0x7d66, 0x21613f },
	{ 0x7d67, 0x223e74 },
	{ 0x7d68, 0x216139 },
	{ 0x7d69, 0x223e7c },
	{ 0x7d6a, 0x223e75 },
	{ 0x7d6b, 0x223e79 },
	{ 0x7d6c, 0x233e2a },
	{ 0x7d6d, 0x223e77 },
	{ 0x7d6e, 0x21613c },
	{ 0x7d6f, 0x223e70 },
	{ 0x7d70, 0x216141 },
	{ 0x7d71, 0x215c53 },
	{ 0x7d72, 0x21613d },
	{ 0x7d73, 0x216142 },
	{ 0x7d74, 0x233e24 },
	{ 0x7d75, 0x233e35 },
	{ 0x7d76, 0x233e33 },
	{ 0x7d78, 0x234367 },
	{ 0x7d79, 0x21656f },
	{ 0x7d7a, 0x224624 },
	{ 0x7d7b, 0x224626 },
	{ 0x7d7c, 0x224628 },
	{ 0x7d7d, 0x22462c },
	{ 0x7d7e, 0x233e2b },
	{ 0x7d7f, 0x224622 },
	{ 0x7d80, 0x22457e },
	{ 0x7d81, 0x216571 },
	{ 0x7d82, 0x243f71 },
	{ 0x7d83, 0x224627 },
	{ 0x7d84, 0x22462b },
	{ 0x7d85, 0x224623 },
	{ 0x7d86, 0x22457d },
	{ 0x7d87, 0x234366 },
	{ 0x7d88, 0x22457c },
	{ 0x7d89, 0x234369 },
	{ 0x7d8a, 0x234360 },
	{ 0x7d8b, 0x234362 },
	{ 0x7d8c, 0x224629 },
	{ 0x7d8d, 0x224621 },
	{ 0x7d8e, 0x224625 },
	{ 0x7d8f, 0x216572 },
	{ 0x7d90, 0x23435e },
	{ 0x7d91, 0x216570 },
	{ 0x7d92, 0x22462d },
	{ 0x7d93, 0x21656e },
	{ 0x7d94, 0x22462a },
	{ 0x7d95, 0x234364 },
	{ 0x7d96, 0x224c79 },
	{ 0x7d97, 0x234368 },
	{ 0x7d98, 0x23436a },
	{ 0x7d99, 0x234363 },
	{ 0x7d9c, 0x216a37 },
	{ 0x7d9d, 0x224c71 },
	{ 0x7d9e, 0x216e43 },
	{ 0x7d9f, 0x224c7b },
	{ 0x7da0, 0x216a3a },
	{ 0x7da1, 0x224d21 },
	{ 0x7da2, 0x216a40 },
	{ 0x7da3, 0x224c6c },
	{ 0x7da4, 0x234874 },
	{ 0x7da5, 0x24457b },
	{ 0x7da6, 0x224c7c },
	{ 0x7da7, 0x224c69 },
	{ 0x7da8, 0x23486d },
	{ 0x7da9, 0x224c7e },
	{ 0x7daa, 0x224c6d },
	{ 0x7dab, 0x23486e },
	{ 0x7dac, 0x216a47 },
	{ 0x7dad, 0x216a44 },
	{ 0x7dae, 0x224c7d },
	{ 0x7daf, 0x224c77 },
	{ 0x7db0, 0x216a36 },
	{ 0x7db1, 0x216a3e },
	{ 0x7db2, 0x216a3d },
	{ 0x7db3, 0x234870 },
	{ 0x7db4, 0x216a3c },
	{ 0x7db5, 0x216a42 },
	{ 0x7db6, 0x234869 },
	{ 0x7db7, 0x224c6a },
	{ 0x7db8, 0x216a43 },
	{ 0x7db9, 0x224c78 },
	{ 0x7dba, 0x216a3f },
	{ 0x7dbb, 0x216a35 },
	{ 0x7dbc, 0x224c7a },
	{ 0x7dbd, 0x216a38 },
	{ 0x7dbe, 0x216a39 },
	{ 0x7dbf, 0x216a41 },
	{ 0x7dc0, 0x224c6f },
	{ 0x7dc1, 0x224c6e },
	{ 0x7dc2, 0x224c6b },
	{ 0x7dc3, 0x24457c },
	{ 0x7dc4, 0x224c73 },
	{ 0x7dc5, 0x224c70 },
	{ 0x7dc6, 0x224c74 },
	{ 0x7dc7, 0x216a46 },
	{ 0x7dc8, 0x234868 },
	{ 0x7dc9, 0x224d22 },
	{ 0x7dca, 0x216a3b },
	{ 0x7dcb, 0x224c75 },
	{ 0x7dcc, 0x224c76 },
	{ 0x7dcd, 0x234871 },
	{ 0x7dce, 0x224c72 },
	{ 0x7dcf, 0x234873 },
	{ 0x7dd0, 0x236629 },
	{ 0x7dd1, 0x23486b },
	{ 0x7dd2, 0x216a45 },
	{ 0x7dd3, 0x23662b },
	{ 0x7dd6, 0x234e22 },
	{ 0x7dd7, 0x22526f },
	{ 0x7dd8, 0x216e3b },
	{ 0x7dd9, 0x216e44 },
	{ 0x7dda, 0x216e40 },
	{ 0x7ddb, 0x22526c },
	{ 0x7ddc, 0x234d7c },
	{ 0x7ddd, 0x216e3d },
	{ 0x7dde, 0x216e41 },
	{ 0x7ddf, 0x225278 },
	{ 0x7de0, 0x216e37 },
	{ 0x7de1, 0x225270 },
	{ 0x7de2, 0x234d78 },
	{ 0x7de3, 0x216e3f },
	{ 0x7de4, 0x234e24 },
	{ 0x7de5, 0x234e2f },
	{ 0x7de6, 0x225273 },
	{ 0x7de7, 0x22526e },
	{ 0x7de8, 0x216e3e },
	{ 0x7de9, 0x216e42 },
	{ 0x7dea, 0x22526d },
	{ 0x7deb, 0x234e2e },
	{ 0x7dec, 0x216e3c },
	{ 0x7ded, 0x234d77 },
	{ 0x7dee, 0x225277 },
	{ 0x7def, 0x216e39 },
	{ 0x7df0, 0x225276 },
	{ 0x7df1, 0x225275 },
	{ 0x7df2, 0x216e45 },
	{ 0x7df3, 0x22503b },
	{ 0x7df4, 0x216e38 },
	{ 0x7df5, 0x234e2b },
	{ 0x7df6, 0x225274 },
	{ 0x7df7, 0x22526b },
	{ 0x7df8, 0x234d75 },
	{ 0x7df9, 0x216e46 },
	{ 0x7dfa, 0x225272 },
	{ 0x7dfb, 0x216e3a },
	{ 0x7dfc, 0x234e28 },
	{ 0x7dfd, 0x234e29 },
	{ 0x7dfe, 0x234e25 },
	{ 0x7dff, 0x234e2c },
	{ 0x7e00, 0x234e27 },
	{ 0x7e01, 0x234d7e },
	{ 0x7e02, 0x234d7d },
	{ 0x7e03, 0x225271 },
	{ 0x7e04, 0x244c45 },
	{ 0x7e07, 0x23662a },
	{ 0x7e08, 0x21716a },
	{ 0x7e09, 0x21716f },
	{ 0x7e0a, 0x217168 },
	{ 0x7e0b, 0x225944 },
	{ 0x7e0c, 0x22593b },
	{ 0x7e0d, 0x225947 },
	{ 0x7e0e, 0x22593f },
	{ 0x7e0f, 0x225945 },
	{ 0x7e10, 0x217170 },
	{ 0x7e11, 0x217169 },
	{ 0x7e12, 0x225938 },
	{ 0x7e13, 0x22593e },
	{ 0x7e14, 0x225948 },
	{ 0x7e15, 0x225941 },
	{ 0x7e16, 0x225946 },
	{ 0x7e17, 0x22593a },
	{ 0x7e18, 0x24524c },
	{ 0x7e19, 0x23523b },
	{ 0x7e1a, 0x225942 },
	{ 0x7e1b, 0x21716b },
	{ 0x7e1c, 0x225940 },
	{ 0x7e1d, 0x21716e },
	{ 0x7e1e, 0x21716d },
	{ 0x7e1f, 0x22593c },
	{ 0x7e20, 0x22593d },
	{ 0x7e21, 0x225939 },
	{ 0x7e22, 0x225943 },
	{ 0x7e23, 0x21716c },
	{ 0x7e24, 0x22594a },
	{ 0x7e25, 0x225949 },
	{ 0x7e26, 0x235240 },
	{ 0x7e27, 0x23523f },
	{ 0x7e29, 0x225e47 },
	{ 0x7e2a, 0x225e43 },
	{ 0x7e2b, 0x217469 },
	{ 0x7e2c, 0x235579 },
	{ 0x7e2d, 0x225e3d },
	{ 0x7e2e, 0x217463 },
	{ 0x7e2f, 0x217473 },
	{ 0x7e30, 0x225e49 },
	{ 0x7e31, 0x21746b },
	{ 0x7e32, 0x217467 },
	{ 0x7e33, 0x225e40 },
	{ 0x7e34, 0x21746e },
	{ 0x7e35, 0x217471 },
	{ 0x7e36, 0x225e4b },
	{ 0x7e37, 0x217466 },
	{ 0x7e38, 0x225e42 },
	{ 0x7e39, 0x21746f },
	{ 0x7e3a, 0x225e4d },
	{ 0x7e3b, 0x225e4a },
	{ 0x7e3c, 0x225e3e },
	{ 0x7e3d, 0x21746a },
	{ 0x7e3e, 0x217464 },
	{ 0x7e3f, 0x217472 },
	{ 0x7e40, 0x225e45 },
	{ 0x7e41, 0x21746d },
	{ 0x7e42, 0x225e3f },
	{ 0x7e43, 0x217468 },
	{ 0x7e44, 0x225e4c },
	{ 0x7e45, 0x21746c },
	{ 0x7e46, 0x217465 },
	{ 0x7e47, 0x225e46 },
	{ 0x7e48, 0x217470 },
	{ 0x7e49, 0x225e44 },
	{ 0x7e4c, 0x225e48 },
	{ 0x7e4d, 0x23557a },
	{ 0x7e4e, 0x245c5f },
	{ 0x7e4f, 0x235859 },
	{ 0x7e50, 0x22625a },
	{ 0x7e51, 0x226260 },
	{ 0x7e52, 0x217725 },
	{ 0x7e53, 0x226263 },
	{ 0x7e54, 0x21767e },
	{ 0x7e55, 0x217721 },
	{ 0x7e56, 0x22625b },
	{ 0x7e57, 0x226262 },
	{ 0x7e58, 0x22625d },
	{ 0x7e59, 0x217726 },
	{ 0x7e5a, 0x217723 },
	{ 0x7e5b, 0x23585b },
	{ 0x7e5c, 0x226259 },
	{ 0x7e5d, 0x235858 },
	{ 0x7e5e, 0x217722 },
	{ 0x7e5f, 0x22625f },
	{ 0x7e60, 0x226261 },
	{ 0x7e61, 0x217724 },
	{ 0x7e62, 0x22625e },
	{ 0x7e63, 0x22625c },
	{ 0x7e64, 0x23662c },
	{ 0x7e65, 0x245c5e },
	{ 0x7e66, 0x23585a },
	{ 0x7e68, 0x226642 },
	{ 0x7e69, 0x217862 },
	{ 0x7e6a, 0x217863 },
	{ 0x7e6b, 0x21785f },
	{ 0x7e6c, 0x235a72 },
	{ 0x7e6d, 0x217860 },
	{ 0x7e6e, 0x235a74 },
	{ 0x7e6f, 0x22663e },
	{ 0x7e70, 0x22663c },
	{ 0x7e71, 0x235a75 },
	{ 0x7e72, 0x226640 },
	{ 0x7e73, 0x217864 },
	{ 0x7e74, 0x226641 },
	{ 0x7e75, 0x22663a },
	{ 0x7e76, 0x226639 },
	{ 0x7e77, 0x22663d },
	{ 0x7e78, 0x22663b },
	{ 0x7e79, 0x217861 },
	{ 0x7e7a, 0x22663f },
	{ 0x7e7b, 0x226959 },
	{ 0x7e7c, 0x217a2b },
	{ 0x7e7d, 0x217a2a },
	{ 0x7e7e, 0x22695a },
	{ 0x7e7f, 0x235c6c },
	{ 0x7e80, 0x22695c },
	{ 0x7e81, 0x22695b },
	{ 0x7e82, 0x217a2c },
	{ 0x7e84, 0x235e53 },
	{ 0x7e85, 0x235e50 },
	{ 0x7e86, 0x226b79 },
	{ 0x7e87, 0x226b76 },
	{ 0x7e88, 0x226b77 },
	{ 0x7e89, 0x235e51 },
	{ 0x7e8a, 0x226b75 },
	{ 0x7e8b, 0x226b78 },
	{ 0x7e8c, 0x217a7d },
	{ 0x7e8d, 0x226b7a },
	{ 0x7e8e, 0x235e52 },
	{ 0x7e8f, 0x217a7c },
	{ 0x7e91, 0x226d6f },
	{ 0x7e92, 0x235f5a },
	{ 0x7e93, 0x217c41 },
	{ 0x7e94, 0x217c43 },
	{ 0x7e95, 0x226f3d },
	{ 0x7e96, 0x217c42 },
	{ 0x7e97, 0x227047 },
	{ 0x7e98, 0x22712f },
	{ 0x7e99, 0x227131 },
	{ 0x7e9a, 0x22712e },
	{ 0x7e9b, 0x227130 },
	{ 0x7e9c, 0x217d39 },
	{ 0x7e9d, 0x246d78 },
	{ 0x7e9e, 0x236235 },
	{ 0x7f36, 0x21484f },
	{ 0x7f37, 0x242557 },
	{ 0x7f38, 0x21527e },
	{ 0x7f39, 0x223052 },
	{ 0x7f3a, 0x21574d },
	{ 0x7f3b, 0x233831 },
	{ 0x7f3c, 0x2f3178 },
	{ 0x7f3d, 0x215c5f },
	{ 0x7f3e, 0x223f22 },
	{ 0x7f3f, 0x223f23 },
	{ 0x7f40, 0x23662d },
	{ 0x7f41, 0x234877 },
	{ 0x7f43, 0x22594b },
	{ 0x7f44, 0x217474 },
	{ 0x7f45, 0x225e4e },
	{ 0x7f46, 0x23557d },
	{ 0x7f47, 0x23585c },
	{ 0x7f48, 0x217727 },
	{ 0x7f4a, 0x226644 },
	{ 0x7f4b, 0x226643 },
	{ 0x7f4c, 0x217a2d },
	{ 0x7f4d, 0x226b7b },
	{ 0x7f4e, 0x235f5b },
	{ 0x7f4f, 0x226d70 },
	{ 0x7f50, 0x217c64 },
	{ 0x7f51, 0x222269 },
	{ 0x7f52, 0x242221 },
	{ 0x7f54, 0x214f2c },
	{ 0x7f55, 0x214b38 },
	{ 0x7f57, 0x2f284a },
	{ 0x7f58, 0x222c6e },
	{ 0x7f59, 0x232a4e },
	{ 0x7f5b, 0x223224 },
	{ 0x7f5c, 0x22317d },
	{ 0x7f5d, 0x223223 },
	{ 0x7f5e, 0x223221 },
	{ 0x7f5f, 0x21574e },
	{ 0x7f60, 0x223222 },
	{ 0x7f61, 0x22317e },
	{ 0x7f62, 0x23333c },
	{ 0x7f63, 0x223836 },
	{ 0x7f64, 0x243a2b },
	{ 0x7f65, 0x223f24 },
	{ 0x7f66, 0x223f25 },
	{ 0x7f67, 0x224630 },
	{ 0x7f68, 0x224631 },
	{ 0x7f69, 0x216575 },
	{ 0x7f6a, 0x216576 },
	{ 0x7f6b, 0x22462f },
	{ 0x7f6c, 0x224632 },
	{ 0x7f6d, 0x22462e },
	{ 0x7f6e, 0x216574 },
	{ 0x7f6f, 0x234878 },
	{ 0x7f70, 0x216a48 },
	{ 0x7f71, 0x234879 },
	{ 0x7f72, 0x216577 },
	{ 0x7f73, 0x224d23 },
	{ 0x7f75, 0x216e47 },
	{ 0x7f76, 0x225279 },
	{ 0x7f77, 0x216e48 },
	{ 0x7f78, 0x234e30 },
	{ 0x7f79, 0x217171 },
	{ 0x7f7a, 0x22594e },
	{ 0x7f7b, 0x22594c },
	{ 0x7f7c, 0x22594d },
	{ 0x7f7d, 0x225e51 },
	{ 0x7f7e, 0x225e50 },
	{ 0x7f7f, 0x225e4f },
	{ 0x7f80, 0x274161 },
	{ 0x7f82, 0x245c68 },
	{ 0x7f83, 0x226645 },
	{ 0x7f84, 0x24606f },
	{ 0x7f85, 0x217865 },
	{ 0x7f86, 0x226646 },
	{ 0x7f87, 0x226d71 },
	{ 0x7f88, 0x217c65 },
	{ 0x7f89, 0x227048 },
	{ 0x7f8a, 0x214850 },
	{ 0x7f8b, 0x214f2e },
	{ 0x7f8c, 0x214f2d },
	{ 0x7f8d, 0x222c70 },
	{ 0x7f8e, 0x215321 },
	{ 0x7f8f, 0x232e5d },
	{ 0x7f90, 0x242f30 },
	{ 0x7f91, 0x222c6f },
	{ 0x7f92, 0x223226 },
	{ 0x7f93, 0x23333d },
	{ 0x7f94, 0x21574f },
	{ 0x7f95, 0x223837 },
	{ 0x7f96, 0x223225 },
	{ 0x7f97, 0x23333f },
	{ 0x7f98, 0x242f2f },
	{ 0x7f99, 0x23333e },
	{ 0x7f9a, 0x215c61 },
	{ 0x7f9b, 0x22383a },
	{ 0x7f9c, 0x223838 },
	{ 0x7f9d, 0x223839 },
	{ 0x7f9e, 0x215c60 },
	{ 0x7fa0, 0x223f27 },
	{ 0x7fa1, 0x223f28 },
	{ 0x7fa2, 0x223f26 },
	{ 0x7fa3, 0x23436e },
	{ 0x7fa4, 0x21657a },
	{ 0x7fa5, 0x224634 },
	{ 0x7fa6, 0x224633 },
	{ 0x7fa7, 0x224635 },
	{ 0x7fa8, 0x216579 },
	{ 0x7fa9, 0x216578 },
	{ 0x7fab, 0x244626 },
	{ 0x7fac, 0x22527a },
	{ 0x7fad, 0x22527c },
	{ 0x7fae, 0x234e31 },
	{ 0x7faf, 0x216e49 },
	{ 0x7fb0, 0x22527b },
	{ 0x7fb1, 0x22594f },
	{ 0x7fb2, 0x217172 },
	{ 0x7fb3, 0x226265 },
	{ 0x7fb4, 0x23585d },
	{ 0x7fb5, 0x226264 },
	{ 0x7fb6, 0x217866 },
	{ 0x7fb7, 0x226647 },
	{ 0x7fb8, 0x217868 },
	{ 0x7fb9, 0x217867 },
	{ 0x7fba, 0x22695d },
	{ 0x7fbb, 0x226b7c },
	{ 0x7fbc, 0x217a7e },
	{ 0x7fbd, 0x214851 },
	{ 0x7fbe, 0x222c71 },
	{ 0x7fbf, 0x215322 },
	{ 0x7fc0, 0x223229 },
	{ 0x7fc1, 0x215751 },
	{ 0x7fc2, 0x223228 },
	{ 0x7fc3, 0x223227 },
	{ 0x7fc4, 0x233342 },
	{ 0x7fc5, 0x215750 },
	{ 0x7fc6, 0x233343 },
	{ 0x7fc7, 0x223840 },
	{ 0x7fc8, 0x24343d },
	{ 0x7fc9, 0x223842 },
	{ 0x7fca, 0x22383b },
	{ 0x7fcb, 0x22383c },
	{ 0x7fcc, 0x215c62 },
	{ 0x7fcd, 0x22383d },
	{ 0x7fce, 0x215c63 },
	{ 0x7fcf, 0x223841 },
	{ 0x7fd0, 0x22383e },
	{ 0x7fd1, 0x22383f },
	{ 0x7fd2, 0x215c64 },
	{ 0x7fd3, 0x233e37 },
	{ 0x7fd4, 0x216144 },
	{ 0x7fd5, 0x216145 },
	{ 0x7fd6, 0x233e38 },
	{ 0x7fd7, 0x223f29 },
	{ 0x7fdb, 0x224636 },
	{ 0x7fdc, 0x224637 },
	{ 0x7fdd, 0x234372 },
	{ 0x7fde, 0x224d27 },
	{ 0x7fdf, 0x216a4b },
	{ 0x7fe0, 0x216a49 },
	{ 0x7fe1, 0x216a4a },
	{ 0x7fe2, 0x224d24 },
	{ 0x7fe3, 0x224d25 },
	{ 0x7fe4, 0x266058 },
	{ 0x7fe5, 0x224d26 },
	{ 0x7fe6, 0x225323 },
	{ 0x7fe7, 0x234e32 },
	{ 0x7fe8, 0x225324 },
	{ 0x7fe9, 0x216e4a },
	{ 0x7fea, 0x225321 },
	{ 0x7feb, 0x22527e },
	{ 0x7fec, 0x225322 },
	{ 0x7fed, 0x22527d },
	{ 0x7fee, 0x217175 },
	{ 0x7fef, 0x225950 },
	{ 0x7ff0, 0x217173 },
	{ 0x7ff1, 0x217174 },
	{ 0x7ff2, 0x225e53 },
	{ 0x7ff3, 0x217475 },
	{ 0x7ff4, 0x225e52 },
	{ 0x7ff5, 0x226134 },
	{ 0x7ff6, 0x23557e },
	{ 0x7ff7, 0x226266 },
	{ 0x7ff8, 0x226267 },
	{ 0x7ff9, 0x217728 },
	{ 0x7ffa, 0x235861 },
	{ 0x7ffb, 0x217729 },
	{ 0x7ffc, 0x217476 },
	{ 0x7ffd, 0x226648 },
	{ 0x7ffe, 0x226649 },
	{ 0x7fff, 0x22695e },
	{ 0x8000, 0x217a2e },
	{ 0x8001, 0x214852 },
	{ 0x8002, 0x23667b },
	{ 0x8003, 0x214853 },
	{ 0x8004, 0x215753 },
	{ 0x8005, 0x214f2f },
	{ 0x8006, 0x215752 },
	{ 0x8007, 0x222c72 },
	{ 0x8008, 0x233836 },
	{ 0x8009, 0x242b25 },
	{ 0x800a, 0x233344 },
	{ 0x800b, 0x216146 },
	{ 0x800c, 0x214854 },
	{ 0x800d, 0x215324 },
	{ 0x800e, 0x222c73 },
	{ 0x800f, 0x222c74 },
	{ 0x8010, 0x215323 },
	{ 0x8011, 0x215325 },
	{ 0x8012, 0x214855 },
	{ 0x8013, 0x242761 },
	{ 0x8014, 0x222c75 },
	{ 0x8015, 0x215755 },
	{ 0x8016, 0x22322a },
	{ 0x8017, 0x215757 },
	{ 0x8018, 0x215754 },
	{ 0x8019, 0x215756 },
	{ 0x801a, 0x233837 },
	{ 0x801b, 0x223845 },
	{ 0x801c, 0x215c65 },
	{ 0x801d, 0x233839 },
	{ 0x801e, 0x223844 },
	{ 0x801f, 0x223843 },
	{ 0x8020, 0x243a38 },
	{ 0x8021, 0x224638 },
	{ 0x8023, 0x234922 },
	{ 0x8024, 0x224d28 },
	{ 0x8025, 0x24462c },
	{ 0x8026, 0x216e4b },
	{ 0x8028, 0x217176 },
	{ 0x8029, 0x225952 },
	{ 0x802a, 0x225951 },
	{ 0x802b, 0x235621 },
	{ 0x802c, 0x225e54 },
	{ 0x802d, 0x245c71 },
	{ 0x802e, 0x235862 },
	{ 0x802f, 0x235c6f },
	{ 0x8030, 0x226b7d },
	{ 0x8031, 0x24692e },
	{ 0x8032, 0x24692d },
	{ 0x8033, 0x214856 },
	{ 0x8034, 0x222473 },
	{ 0x8035, 0x22284a },
	{ 0x8036, 0x215326 },
	{ 0x8037, 0x222c76 },
	{ 0x8038, 0x263b21 },
	{ 0x8039, 0x22322c },
	{ 0x803a, 0x242f3a },
	{ 0x803b, 0x233349 },
	{ 0x803c, 0x233348 },
	{ 0x803d, 0x215758 },
	{ 0x803e, 0x22322b },
	{ 0x803f, 0x215759 },
	{ 0x8040, 0x233347 },
	{ 0x8041, 0x23662f },
	{ 0x8043, 0x223847 },
	{ 0x8044, 0x23383d },
	{ 0x8045, 0x23383c },
	{ 0x8046, 0x215c67 },
	{ 0x8047, 0x223846 },
	{ 0x8048, 0x223848 },
	{ 0x8049, 0x23383b },
	{ 0x804a, 0x215c66 },
	{ 0x804e, 0x233e3c },
	{ 0x804f, 0x223f2b },
	{ 0x8050, 0x223f2c },
	{ 0x8051, 0x223f2a },
	{ 0x8052, 0x216147 },
	{ 0x8053, 0x236729 },
	{ 0x8055, 0x243f7c },
	{ 0x8056, 0x21657b },
	{ 0x8057, 0x234373 },
	{ 0x8058, 0x21657c },
	{ 0x8059, 0x244633 },
	{ 0x805a, 0x216a4d },
	{ 0x805b, 0x234923 },
	{ 0x805c, 0x224d2a },
	{ 0x805d, 0x224d29 },
	{ 0x805e, 0x216a4c },
	{ 0x805f, 0x234926 },
	{ 0x8060, 0x233e3b },
	{ 0x8061, 0x234925 },
	{ 0x8063, 0x236630 },
	{ 0x8064, 0x225325 },
	{ 0x8065, 0x234e34 },
	{ 0x8066, 0x234e36 },
	{ 0x8067, 0x225326 },
	{ 0x8068, 0x234e37 },
	{ 0x806a, 0x234e35 },
	{ 0x806b, 0x234e38 },
	{ 0x806c, 0x225953 },
	{ 0x806d, 0x24525c },
	{ 0x806e, 0x235243 },
	{ 0x806f, 0x21747a },
	{ 0x8070, 0x217479 },
	{ 0x8071, 0x217477 },
	{ 0x8072, 0x217478 },
	{ 0x8073, 0x21747b },
	{ 0x8074, 0x235622 },
	{ 0x8075, 0x226268 },
	{ 0x8076, 0x21772b },
	{ 0x8077, 0x21772a },
	{ 0x8078, 0x22664a },
	{ 0x8079, 0x22695f },
	{ 0x807a, 0x235c70 },
	{ 0x807b, 0x235c71 },
	{ 0x807c, 0x235c72 },
	{ 0x807d, 0x217b6f },
	{ 0x807e, 0x217b6e },
	{ 0x807f, 0x214857 },
	{ 0x8081, 0x263b24 },
	{ 0x8082, 0x222f7d },
	{ 0x8084, 0x21657e },
	{ 0x8085, 0x216148 },
	{ 0x8086, 0x21657d },
	{ 0x8087, 0x216a4e },
	{ 0x8088, 0x266060 },
	{ 0x8089, 0x214858 },
	{ 0x808a, 0x222168 },
	{ 0x808b, 0x214859 },
	{ 0x808c, 0x21485a },
	{ 0x808d, 0x232435 },
	{ 0x808e, 0x232436 },
	{ 0x808f, 0x22284b },
	{ 0x8090, 0x222476 },
	{ 0x8091, 0x232724 },
	{ 0x8092, 0x222477 },
	{ 0x8093, 0x214b3a },
	{ 0x8094, 0x232726 },
	{ 0x8095, 0x222474 },
	{ 0x8096, 0x214b39 },
	{ 0x8097, 0x232725 },
	{ 0x8098, 0x214b3c },
	{ 0x8099, 0x222475 },
	{ 0x809a, 0x214b3e },
	{ 0x809b, 0x214b3d },
	{ 0x809c, 0x222478 },
	{ 0x809d, 0x214b3b },
	{ 0x809e, 0x242470 },
	{ 0x809f, 0x232723 },
	{ 0x80a1, 0x214f34 },
	{ 0x80a2, 0x214f32 },
	{ 0x80a3, 0x22284d },
	{ 0x80a4, 0x232a56 },
	{ 0x80a5, 0x214f31 },
	{ 0x80a6, 0x232a5b },
	{ 0x80a7, 0x232a58 },
	{ 0x80a8, 0x232a4f },
	{ 0x80a9, 0x214f36 },
	{ 0x80aa, 0x214f38 },
	{ 0x80ab, 0x214f35 },
	{ 0x80ac, 0x232a59 },
	{ 0x80ad, 0x222850 },
	{ 0x80ae, 0x22284c },
	{ 0x80af, 0x214f39 },
	{ 0x80b0, 0x232a52 },
	{ 0x80b1, 0x214f33 },
	{ 0x80b2, 0x214b3f },
	{ 0x80b3, 0x232a54 },
	{ 0x80b4, 0x214f37 },
	{ 0x80b5, 0x22284f },
	{ 0x80b6, 0x232a57 },
	{ 0x80b7, 0x242764 },
	{ 0x80b8, 0x22284e },
	{ 0x80b9, 0x242769 },
	{ 0x80ba, 0x214f30 },
	{ 0x80bb, 0x236631 },
	{ 0x80c2, 0x222c7c },
	{ 0x80c3, 0x21532a },
	{ 0x80c4, 0x21532b },
	{ 0x80c5, 0x222c7e },
	{ 0x80c6, 0x232e66 },
	{ 0x80c7, 0x222c78 },
	{ 0x80c8, 0x222c7b },
	{ 0x80c9, 0x222d26 },
	{ 0x80ca, 0x222d24 },
	{ 0x80cb, 0x232e60 },
	{ 0x80cc, 0x21532c },
	{ 0x80cd, 0x222d2a },
	{ 0x80ce, 0x21532f },
	{ 0x80cf, 0x222d27 },
	{ 0x80d0, 0x222c7d },
	{ 0x80d1, 0x222c7a },
	{ 0x80d2, 0x232e61 },
	{ 0x80d3, 0x232e5e },
	{ 0x80d4, 0x223f2e },
	{ 0x80d5, 0x222d25 },
	{ 0x80d6, 0x215327 },
	{ 0x80d7, 0x222d28 },
	{ 0x80d8, 0x222c77 },
	{ 0x80d9, 0x222d22 },
	{ 0x80da, 0x215329 },
	{ 0x80db, 0x21532e },
	{ 0x80dc, 0x222d23 },
	{ 0x80dd, 0x215332 },
	{ 0x80de, 0x215330 },
	{ 0x80df, 0x232e65 },
	{ 0x80e0, 0x222c79 },
	{ 0x80e1, 0x21532d },
	{ 0x80e2, 0x232e64 },
	{ 0x80e3, 0x222d21 },
	{ 0x80e4, 0x215331 },
	{ 0x80e5, 0x215328 },
	{ 0x80e6, 0x222d29 },
	{ 0x80ed, 0x21575e },
	{ 0x80ee, 0x23334c },
	{ 0x80ef, 0x215767 },
	{ 0x80f0, 0x21575c },
	{ 0x80f1, 0x21575a },
	{ 0x80f2, 0x22322e },
	{ 0x80f3, 0x215762 },
	{ 0x80f4, 0x21575f },
	{ 0x80f5, 0x223230 },
	{ 0x80f6, 0x23334a },
	{ 0x80f7, 0x233352 },
	{ 0x80f8, 0x215761 },
	{ 0x80f9, 0x22322f },
	{ 0x80fa, 0x22322d },
	{ 0x80fb, 0x223232 },
	{ 0x80fc, 0x215766 },
	{ 0x80fd, 0x215764 },
	{ 0x80fe, 0x223f2d },
	{ 0x80ff, 0x23334b },
	{ 0x8100, 0x223233 },
	{ 0x8101, 0x223231 },
	{ 0x8102, 0x21575b },
	{ 0x8103, 0x23334e },
	{ 0x8104, 0x23334d },
	{ 0x8105, 0x21575d },
	{ 0x8106, 0x215760 },
	{ 0x8107, 0x23334f },
	{ 0x8108, 0x215763 },
	{ 0x8109, 0x232e63 },
	{ 0x810a, 0x215765 },
	{ 0x8114, 0x233e44 },
	{ 0x8115, 0x223852 },
	{ 0x8116, 0x215c69 },
	{ 0x8117, 0x233849 },
	{ 0x8118, 0x223849 },
	{ 0x8119, 0x22384b },
	{ 0x811a, 0x233847 },
	{ 0x811b, 0x22384c },
	{ 0x811c, 0x24344d },
	{ 0x811d, 0x223854 },
	{ 0x811e, 0x223850 },
	{ 0x811f, 0x22384e },
	{ 0x8120, 0x243a3b },
	{ 0x8121, 0x223851 },
	{ 0x8122, 0x223855 },
	{ 0x8123, 0x215c6a },
	{ 0x8124, 0x215c6e },
	{ 0x8125, 0x22384a },
	{ 0x8126, 0x243447 },
	{ 0x8127, 0x223853 },
	{ 0x8128, 0x243450 },
	{ 0x8129, 0x215c6c },
	{ 0x812a, 0x233841 },
	{ 0x812b, 0x215c6b },
	{ 0x812c, 0x22384f },
	{ 0x812d, 0x22384d },
	{ 0x812e, 0x233842 },
	{ 0x812f, 0x215c68 },
	{ 0x8130, 0x215c6d },
	{ 0x8131, 0x233845 },
	{ 0x8134, 0x233848 },
	{ 0x8139, 0x21614e },
	{ 0x813a, 0x223f36 },
	{ 0x813b, 0x233e3e },
	{ 0x813c, 0x243a3e },
	{ 0x813d, 0x223f34 },
	{ 0x813e, 0x216150 },
	{ 0x813f, 0x243a47 },
	{ 0x8140, 0x233e43 },
	{ 0x8141, 0x233e45 },
	{ 0x8142, 0x233e41 },
	{ 0x8143, 0x223f2f },
	{ 0x8144, 0x224646 },
	{ 0x8145, 0x233e3d },
	{ 0x8146, 0x21614f },
	{ 0x8147, 0x223f33 },
	{ 0x8148, 0x233e40 },
	{ 0x8149, 0x233e42 },
	{ 0x814a, 0x223f30 },
	{ 0x814b, 0x21614b },
	{ 0x814c, 0x216151 },
	{ 0x814d, 0x223f35 },
	{ 0x814e, 0x21614d },
	{ 0x814f, 0x223f32 },
	{ 0x8150, 0x216a4f },
	{ 0x8151, 0x21614c },
	{ 0x8152, 0x223f31 },
	{ 0x8153, 0x216152 },
	{ 0x8154, 0x21614a },
	{ 0x8155, 0x216149 },
	{ 0x8158, 0x26435a },
	{ 0x815b, 0x22463e },
	{ 0x815c, 0x22463c },
	{ 0x815d, 0x23437b },
	{ 0x815e, 0x224642 },
	{ 0x815f, 0x23437e },
	{ 0x8160, 0x22463a },
	{ 0x8161, 0x224647 },
	{ 0x8162, 0x22463f },
	{ 0x8163, 0x234375 },
	{ 0x8164, 0x224639 },
	{ 0x8165, 0x216624 },
	{ 0x8166, 0x21662a },
	{ 0x8167, 0x224644 },
	{ 0x8168, 0x244029 },
	{ 0x8169, 0x22463d },
	{ 0x816a, 0x234376 },
	{ 0x816b, 0x216627 },
	{ 0x816c, 0x234377 },
	{ 0x816d, 0x234423 },
	{ 0x816e, 0x216625 },
	{ 0x816f, 0x224645 },
	{ 0x8170, 0x216622 },
	{ 0x8171, 0x216621 },
	{ 0x8172, 0x224640 },
	{ 0x8173, 0x216626 },
	{ 0x8174, 0x216153 },
	{ 0x8175, 0x23437c },
	{ 0x8176, 0x224643 },
	{ 0x8177, 0x22463b },
	{ 0x8178, 0x216623 },
	{ 0x8179, 0x216628 },
	{ 0x817a, 0x216629 },
	{ 0x817d, 0x234422 },
	{ 0x817f, 0x216a54 },
	{ 0x8180, 0x216a50 },
	{ 0x8181, 0x234927 },
	{ 0x8182, 0x216a55 },
	{ 0x8183, 0x224d2d },
	{ 0x8184, 0x23492a },
	{ 0x8185, 0x244639 },
	{ 0x8186, 0x224d2c },
	{ 0x8187, 0x224d2e },
	{ 0x8188, 0x216a52 },
	{ 0x8189, 0x224d2b },
	{ 0x818a, 0x216a53 },
	{ 0x818b, 0x224d31 },
	{ 0x818c, 0x224d30 },
	{ 0x818d, 0x224d2f },
	{ 0x818e, 0x244646 },
	{ 0x818f, 0x216a51 },
	{ 0x8190, 0x245267 },
	{ 0x8192, 0x234e3b },
	{ 0x8193, 0x234e3d },
	{ 0x8194, 0x234e39 },
	{ 0x8195, 0x22532a },
	{ 0x8196, 0x234e3c },
	{ 0x8197, 0x22532d },
	{ 0x8198, 0x216e51 },
	{ 0x8199, 0x22532c },
	{ 0x819a, 0x216e50 },
	{ 0x819b, 0x216e4c },
	{ 0x819c, 0x216e4d },
	{ 0x819d, 0x216e4e },
	{ 0x819e, 0x225329 },
	{ 0x819f, 0x225328 },
	{ 0x81a0, 0x216e4f },
	{ 0x81a1, 0x234e3a },
	{ 0x81a2, 0x22532b },
	{ 0x81a3, 0x225327 },
	{ 0x81a6, 0x225955 },
	{ 0x81a7, 0x22595f },
	{ 0x81a8, 0x217179 },
	{ 0x81a9, 0x217178 },
	{ 0x81aa, 0x235249 },
	{ 0x81ab, 0x225959 },
	{ 0x81ac, 0x22595b },
	{ 0x81ad, 0x235247 },
	{ 0x81ae, 0x225956 },
	{ 0x81af, 0x235244 },
	{ 0x81b0, 0x22595a },
	{ 0x81b1, 0x225954 },
	{ 0x81b2, 0x22595d },
	{ 0x81b3, 0x217177 },
	{ 0x81b4, 0x22595c },
	{ 0x81b5, 0x225958 },
	{ 0x81b7, 0x22595e },
	{ 0x81b8, 0x235623 },
	{ 0x81b9, 0x225957 },
	{ 0x81ba, 0x21747e },
	{ 0x81bb, 0x225e55 },
	{ 0x81bc, 0x225e5b },
	{ 0x81bd, 0x217524 },
	{ 0x81be, 0x217526 },
	{ 0x81bf, 0x217523 },
	{ 0x81c0, 0x217522 },
	{ 0x81c1, 0x245827 },
	{ 0x81c2, 0x217521 },
	{ 0x81c3, 0x21747d },
	{ 0x81c4, 0x225e56 },
	{ 0x81c5, 0x225e59 },
	{ 0x81c6, 0x21747c },
	{ 0x81c7, 0x225e5a },
	{ 0x81c8, 0x235624 },
	{ 0x81c9, 0x217525 },
	{ 0x81ca, 0x225e58 },
	{ 0x81cb, 0x27487c },
	{ 0x81cc, 0x225e57 },
	{ 0x81cd, 0x21772c },
	{ 0x81ce, 0x235865 },
	{ 0x81cf, 0x21772d },
	{ 0x81d0, 0x22626b },
	{ 0x81d1, 0x226269 },
	{ 0x81d2, 0x22626a },
	{ 0x81d4, 0x235a77 },
	{ 0x81d5, 0x22664c },
	{ 0x81d6, 0x235a78 },
	{ 0x81d7, 0x22664b },
	{ 0x81d8, 0x217869 },
	{ 0x81d9, 0x226961 },
	{ 0x81da, 0x217a2f },
	{ 0x81db, 0x226960 },
	{ 0x81dd, 0x226b7e },
	{ 0x81de, 0x226d72 },
	{ 0x81df, 0x217b70 },
	{ 0x81e0, 0x227132 },
	{ 0x81e1, 0x227133 },
	{ 0x81e2, 0x217c44 },
	{ 0x81e3, 0x21485b },
	{ 0x81e4, 0x24276c },
	{ 0x81e5, 0x214f3a },
	{ 0x81e6, 0x223f37 },
	{ 0x81e7, 0x216a56 },
	{ 0x81e8, 0x217527 },
	{ 0x81e9, 0x225e5c },
	{ 0x81ea, 0x21485c },
	{ 0x81eb, 0x242473 },
	{ 0x81ec, 0x215769 },
	{ 0x81ed, 0x215768 },
	{ 0x81ee, 0x223f38 },
	{ 0x81ef, 0x233e47 },
	{ 0x81f0, 0x243a4c },
	{ 0x81f1, 0x244c62 },
	{ 0x81f2, 0x225960 },
	{ 0x81f3, 0x21485d },
	{ 0x81f4, 0x215333 },
	{ 0x81f5, 0x243a4d },
	{ 0x81f6, 0x233e48 },
	{ 0x81f7, 0x223f39 },
	{ 0x81f8, 0x223f3a },
	{ 0x81f9, 0x223f3b },
	{ 0x81fa, 0x216a57 },
	{ 0x81fb, 0x21717a },
	{ 0x81fc, 0x21485e },
	{ 0x81fd, 0x24276d },
	{ 0x81fe, 0x214f3b },
	{ 0x81ff, 0x222d2b },
	{ 0x8200, 0x21576a },
	{ 0x8201, 0x223234 },
	{ 0x8202, 0x215c6f },
	{ 0x8203, 0x233e49 },
	{ 0x8204, 0x223f3c },
	{ 0x8205, 0x21662b },
	{ 0x8207, 0x216a58 },
	{ 0x8208, 0x21717b },
	{ 0x8209, 0x217528 },
	{ 0x820a, 0x21772e },
	{ 0x820b, 0x22664d },
	{ 0x820c, 0x21485f },
	{ 0x820d, 0x214f3c },
	{ 0x820e, 0x232a5d },
	{ 0x820f, 0x24276e },
	{ 0x8210, 0x21576b },
	{ 0x8211, 0x223856 },
	{ 0x8212, 0x216154 },
	{ 0x8213, 0x23492b },
	{ 0x8214, 0x216a59 },
	{ 0x8215, 0x224d32 },
	{ 0x8216, 0x22532e },
	{ 0x8218, 0x23524a },
	{ 0x8219, 0x235868 },
	{ 0x821a, 0x235a79 },
	{ 0x821b, 0x214860 },
	{ 0x821c, 0x216155 },
	{ 0x821d, 0x224648 },
	{ 0x821e, 0x216a5a },
	{ 0x821f, 0x214861 },
	{ 0x8220, 0x222851 },
	{ 0x8221, 0x222d2c },
	{ 0x8222, 0x215334 },
	{ 0x8224, 0x232e68 },
	{ 0x8225, 0x223236 },
	{ 0x8226, 0x242f4f },
	{ 0x8227, 0x233357 },
	{ 0x8228, 0x21576e },
	{ 0x8229, 0x233358 },
	{ 0x822a, 0x21576c },
	{ 0x822b, 0x21576d },
	{ 0x822c, 0x21576f },
	{ 0x822d, 0x233355 },
	{ 0x822f, 0x223235 },
	{ 0x8232, 0x22385b },
	{ 0x8233, 0x223858 },
	{ 0x8234, 0x22385a },
	{ 0x8235, 0x215c70 },
	{ 0x8236, 0x215c72 },
	{ 0x8237, 0x215c71 },
	{ 0x8238, 0x223857 },
	{ 0x8239, 0x215c73 },
	{ 0x823a, 0x223859 },
	{ 0x823c, 0x223f3d },
	{ 0x823d, 0x223f3e },
	{ 0x823f, 0x223f3f },
	{ 0x8240, 0x22464b },
	{ 0x8241, 0x234426 },
	{ 0x8242, 0x22464c },
	{ 0x8243, 0x24402e },
	{ 0x8244, 0x22464a },
	{ 0x8245, 0x22464d },
	{ 0x8246, 0x24402d },
	{ 0x8247, 0x21662c },
	{ 0x8248, 0x236634 },
	{ 0x8249, 0x224649 },
	{ 0x824a, 0x23492d },
	{ 0x824b, 0x216a5b },
	{ 0x824c, 0x23492e },
	{ 0x824e, 0x225333 },
	{ 0x824f, 0x22532f },
	{ 0x8250, 0x225332 },
	{ 0x8251, 0x225334 },
	{ 0x8252, 0x225331 },
	{ 0x8253, 0x225330 },
	{ 0x8255, 0x225961 },
	{ 0x8256, 0x225962 },
	{ 0x8257, 0x225963 },
	{ 0x8258, 0x21717c },
	{ 0x8259, 0x21717d },
	{ 0x825a, 0x225e5e },
	{ 0x825b, 0x225e5d },
	{ 0x825c, 0x225e5f },
	{ 0x825e, 0x22626d },
	{ 0x825f, 0x22626c },
	{ 0x8261, 0x22664f },
	{ 0x8262, 0x235a7a },
	{ 0x8263, 0x226650 },
	{ 0x8264, 0x22664e },
	{ 0x8265, 0x235a7b },
	{ 0x8266, 0x217a30 },
	{ 0x8267, 0x24642c },
	{ 0x8268, 0x226962 },
	{ 0x8269, 0x226963 },
	{ 0x826a, 0x235e55 },
	{ 0x826b, 0x226d73 },
	{ 0x826c, 0x226f3e },
	{ 0x826d, 0x227049 },
	{ 0x826e, 0x214862 },
	{ 0x826f, 0x214b40 },
	{ 0x8271, 0x217529 },
	{ 0x8272, 0x214863 },
	{ 0x8273, 0x2f3232 },
	{ 0x8274, 0x22385c },
	{ 0x8275, 0x223f40 },
	{ 0x8276, 0x235a7c },
	{ 0x8277, 0x217c6c },
	{ 0x8278, 0x22226a },
	{ 0x8279, 0x242153 },
	{ 0x827b, 0x232438 },
	{ 0x827c, 0x22226b },
	{ 0x827d, 0x22226d },
	{ 0x827e, 0x214864 },
	{ 0x827f, 0x22226e },
	{ 0x8280, 0x22226c },
	{ 0x8281, 0x24232f },
	{ 0x8283, 0x222522 },
	{ 0x8284, 0x222523 },
	{ 0x8285, 0x22247b },
	{ 0x8286, 0x232728 },
	{ 0x8287, 0x24247b },
	{ 0x8289, 0x242475 },
	{ 0x828a, 0x222521 },
	{ 0x828b, 0x214b42 },
	{ 0x828c, 0x232729 },
	{ 0x828d, 0x214b43 },
	{ 0x828e, 0x22247c },
	{ 0x828f, 0x22247a },
	{ 0x8290, 0x222479 },
	{ 0x8291, 0x22247d },
	{ 0x8292, 0x214b41 },
	{ 0x8293, 0x22247e },
	{ 0x8294, 0x222d2d },
	{ 0x8295, 0x23272b },
	{ 0x8296, 0x242479 },
	{ 0x8298, 0x222856 },
	{ 0x8299, 0x214f3f },
	{ 0x829a, 0x222855 },
	{ 0x829b, 0x222857 },
	{ 0x829c, 0x232a60 },
	{ 0x829d, 0x214f3e },
	{ 0x829e, 0x22285c },
	{ 0x829f, 0x214f42 },
	{ 0x82a0, 0x222852 },
	{ 0x82a1, 0x222860 },
	{ 0x82a2, 0x222866 },
	{ 0x82a3, 0x214f49 },
	{ 0x82a4, 0x222863 },
	{ 0x82a5, 0x214f46 },
	{ 0x82a6, 0x232a6b },
	{ 0x82a7, 0x222859 },
	{ 0x82a8, 0x22285f },
	{ 0x82a9, 0x222861 },
	{ 0x82aa, 0x232a66 },
	{ 0x82ab, 0x222854 },
	{ 0x82ac, 0x214f45 },
	{ 0x82ad, 0x214f40 },
	{ 0x82ae, 0x22285a },
	{ 0x82af, 0x214f47 },
	{ 0x82b0, 0x214f4a },
	{ 0x82b1, 0x214f44 },
	{ 0x82b2, 0x232a6c },
	{ 0x82b3, 0x214f3d },
	{ 0x82b4, 0x22285e },
	{ 0x82b5, 0x222858 },
	{ 0x82b6, 0x222865 },
	{ 0x82b7, 0x214f4c },
	{ 0x82b8, 0x214f48 },
	{ 0x82b9, 0x214f43 },
	{ 0x82ba, 0x22285d },
	{ 0x82bb, 0x215770 },
	{ 0x82bc, 0x22285b },
	{ 0x82bd, 0x214f41 },
	{ 0x82be, 0x214f4b },
	{ 0x82bf, 0x24277a },
	{ 0x82c0, 0x222853 },
	{ 0x82c1, 0x24277e },
	{ 0x82c2, 0x222862 },
	{ 0x82c3, 0x222864 },
	{ 0x82c4, 0x232a5e },
	{ 0x82c5, 0x2f2863 },
	{ 0x82c9, 0x232a68 },
	{ 0x82ca, 0x24277b },
	{ 0x82d0, 0x232e76 },
	{ 0x82d1, 0x215345 },
	{ 0x82d2, 0x21533f },
	{ 0x82d3, 0x215347 },
	{ 0x82d4, 0x215344 },
	{ 0x82d5, 0x222d34 },
	{ 0x82d6, 0x222d37 },
	{ 0x82d7, 0x215340 },
	{ 0x82d8, 0x232e6a },
	{ 0x82d9, 0x222d2e },
	{ 0x82da, 0x242b3a },
	{ 0x82db, 0x215339 },
	{ 0x82dc, 0x215343 },
	{ 0x82dd, 0x232e6b },
	{ 0x82de, 0x215346 },
	{ 0x82df, 0x215348 },
	{ 0x82e0, 0x222d43 },
	{ 0x82e1, 0x222d3a },
	{ 0x82e2, 0x232e78 },
	{ 0x82e3, 0x215338 },
	{ 0x82e4, 0x222d42 },
	{ 0x82e5, 0x21533c },
	{ 0x82e6, 0x21533a },
	{ 0x82e7, 0x215335 },
	{ 0x82e8, 0x222d32 },
	{ 0x82e9, 0x232e72 },
	{ 0x82ea, 0x222d41 },
	{ 0x82eb, 0x222d36 },
	{ 0x82ec, 0x222d39 },
	{ 0x82ed, 0x222d46 },
	{ 0x82ee, 0x232e74 },
	{ 0x82ef, 0x215349 },
	{ 0x82f0, 0x222d40 },
	{ 0x82f1, 0x215341 },
	{ 0x82f2, 0x222d3b },
	{ 0x82f3, 0x222d45 },
	{ 0x82f4, 0x222d38 },
	{ 0x82f5, 0x222d3c },
	{ 0x82f6, 0x222d3f },
	{ 0x82f7, 0x232e69 },
	{ 0x82f8, 0x232e6e },
	{ 0x82f9, 0x222d30 },
	{ 0x82fa, 0x222d44 },
	{ 0x82fb, 0x222d3e },
	{ 0x82fc, 0x232e6f },
	{ 0x82fd, 0x232e7a },
	{ 0x82fe, 0x222d2f },
	{ 0x82ff, 0x26343c },
	{ 0x8300, 0x222d33 },
	{ 0x8301, 0x215342 },
	{ 0x8302, 0x21533d },
	{ 0x8303, 0x215336 },
	{ 0x8304, 0x21533b },
	{ 0x8305, 0x215337 },
	{ 0x8306, 0x21534a },
	{ 0x8307, 0x222d31 },
	{ 0x8308, 0x223247 },
	{ 0x8309, 0x21533e },
	{ 0x830a, 0x242b3d },
	{ 0x830b, 0x232e79 },
	{ 0x830c, 0x222d3d },
	{ 0x830d, 0x222942 },
	{ 0x830e, 0x232e77 },
	{ 0x8310, 0x236635 },
	{ 0x8312, 0x236637 },
	{ 0x8316, 0x22324a },
	{ 0x8317, 0x21577e },
	{ 0x8318, 0x233362 },
	{ 0x8319, 0x22323a },
	{ 0x831a, 0x242f5d },
	{ 0x831b, 0x223245 },
	{ 0x831c, 0x223241 },
	{ 0x831d, 0x23384d },
	{ 0x831e, 0x223254 },
	{ 0x831f, 0x233359 },
	{ 0x8320, 0x22324c },
	{ 0x8321, 0x23335f },
	{ 0x8322, 0x223242 },
	{ 0x8323, 0x23385b },
	{ 0x8324, 0x22324b },
	{ 0x8325, 0x22323c },
	{ 0x8326, 0x223240 },
	{ 0x8327, 0x223257 },
	{ 0x8328, 0x215823 },
	{ 0x8329, 0x22324f },
	{ 0x832a, 0x223246 },
	{ 0x832b, 0x215771 },
	{ 0x832c, 0x223255 },
	{ 0x832d, 0x223238 },
	{ 0x832e, 0x242f5a },
	{ 0x832f, 0x22324e },
	{ 0x8330, 0x242f63 },
	{ 0x8331, 0x215822 },
	{ 0x8332, 0x21577b },
	{ 0x8333, 0x223237 },
	{ 0x8334, 0x215779 },
	{ 0x8335, 0x215778 },
	{ 0x8336, 0x21577d },
	{ 0x8337, 0x22324d },
	{ 0x8338, 0x215775 },
	{ 0x8339, 0x21577c },
	{ 0x833a, 0x222d35 },
	{ 0x833b, 0x223f41 },
	{ 0x833c, 0x223248 },
	{ 0x833d, 0x242f5f },
	{ 0x833e, 0x232a5f },
	{ 0x833f, 0x22323e },
	{ 0x8340, 0x215821 },
	{ 0x8341, 0x22323f },
	{ 0x8342, 0x223243 },
	{ 0x8343, 0x215824 },
	{ 0x8344, 0x223239 },
	{ 0x8345, 0x223251 },
	{ 0x8346, 0x233e57 },
	{ 0x8347, 0x223250 },
	{ 0x8348, 0x223258 },
	{ 0x8349, 0x215777 },
	{ 0x834a, 0x215774 },
	{ 0x834b, 0x223256 },
	{ 0x834c, 0x223252 },
	{ 0x834d, 0x223249 },
	{ 0x834e, 0x223244 },
	{ 0x834f, 0x21577a },
	{ 0x8350, 0x215776 },
	{ 0x8351, 0x22323b },
	{ 0x8352, 0x215772 },
	{ 0x8353, 0x223253 },
	{ 0x8354, 0x215773 },
	{ 0x8355, 0x242f5c },
	{ 0x8356, 0x22323d },
	{ 0x8357, 0x23335a },
	{ 0x8358, 0x233363 },
	{ 0x8362, 0x236636 },
	{ 0x8363, 0x232d33 },
	{ 0x8370, 0x243467 },
	{ 0x8371, 0x23384e },
	{ 0x8372, 0x233851 },
	{ 0x8373, 0x223862 },
	{ 0x8374, 0x223864 },
	{ 0x8375, 0x223869 },
	{ 0x8376, 0x22387d },
	{ 0x8377, 0x215d23 },
	{ 0x8378, 0x215c77 },
	{ 0x8379, 0x233854 },
	{ 0x837a, 0x223861 },
	{ 0x837b, 0x215d24 },
	{ 0x837c, 0x215d25 },
	{ 0x837d, 0x22386c },
	{ 0x837e, 0x223873 },
	{ 0x837f, 0x223879 },
	{ 0x8380, 0x233850 },
	{ 0x8381, 0x223866 },
	{ 0x8382, 0x24346d },
	{ 0x8383, 0x22386d },
	{ 0x8384, 0x23384f },
	{ 0x8385, 0x23385d },
	{ 0x8386, 0x215d26 },
	{ 0x8387, 0x22387b },
	{ 0x8388, 0x223876 },
	{ 0x8389, 0x215d21 },
	{ 0x838a, 0x215c7d },
	{ 0x838b, 0x223872 },
	{ 0x838c, 0x22386e },
	{ 0x838d, 0x223860 },
	{ 0x838e, 0x215c74 },
	{ 0x838f, 0x223865 },
	{ 0x8390, 0x22385d },
	{ 0x8391, 0x233855 },
	{ 0x8392, 0x215c7c },
	{ 0x8393, 0x215c7e },
	{ 0x8394, 0x22386a },
	{ 0x8395, 0x223867 },
	{ 0x8396, 0x215c79 },
	{ 0x8397, 0x223877 },
	{ 0x8398, 0x215c76 },
	{ 0x8399, 0x223868 },
	{ 0x839a, 0x223f6a },
	{ 0x839b, 0x223870 },
	{ 0x839c, 0x23385e },
	{ 0x839d, 0x22386f },
	{ 0x839e, 0x215c75 },
	{ 0x839f, 0x233857 },
	{ 0x83a0, 0x215d22 },
	{ 0x83a1, 0x233852 },
	{ 0x83a2, 0x215c78 },
	{ 0x83a3, 0x22385e },
	{ 0x83a4, 0x223863 },
	{ 0x83a5, 0x223874 },
	{ 0x83a6, 0x22387a },
	{ 0x83a7, 0x215d27 },
	{ 0x83a8, 0x22385f },
	{ 0x83a9, 0x22386b },
	{ 0x83aa, 0x223871 },
	{ 0x83ab, 0x215c7b },
	{ 0x83ac, 0x24346f },
	{ 0x83ad, 0x233858 },
	{ 0x83ae, 0x22387c },
	{ 0x83af, 0x223875 },
	{ 0x83b0, 0x223878 },
	{ 0x83b7, 0x23385f },
	{ 0x83b9, 0x2f3778 },
	{ 0x83bd, 0x215c7a },
	{ 0x83be, 0x243a68 },
	{ 0x83bf, 0x223f51 },
	{ 0x83c0, 0x223f45 },
	{ 0x83c1, 0x21615d },
	{ 0x83c2, 0x223f62 },
	{ 0x83c3, 0x223f6b },
	{ 0x83c4, 0x223f6e },
	{ 0x83c5, 0x21615b },
	{ 0x83c6, 0x223f4d },
	{ 0x83c7, 0x223f66 },
	{ 0x83c8, 0x223f4e },
	{ 0x83c9, 0x223f5c },
	{ 0x83ca, 0x216168 },
	{ 0x83cb, 0x223f58 },
	{ 0x83cc, 0x216165 },
	{ 0x83cd, 0x233e5e },
	{ 0x83ce, 0x223f59 },
	{ 0x83cf, 0x223f42 },
	{ 0x83d0, 0x253b6f },
	{ 0x83d1, 0x223f67 },
	{ 0x83d2, 0x233e4f },
	{ 0x83d3, 0x233e59 },
	{ 0x83d4, 0x21616e },
	{ 0x83d5, 0x223f64 },
	{ 0x83d6, 0x223f5a },
	{ 0x83d7, 0x223f70 },
	{ 0x83d8, 0x223f55 },
	{ 0x83d9, 0x22466d },
	{ 0x83da, 0x233e4d },
	{ 0x83db, 0x223f73 },
	{ 0x83dc, 0x21616c },
	{ 0x83dd, 0x223f53 },
	{ 0x83de, 0x223f5f },
	{ 0x83df, 0x21616f },
	{ 0x83e0, 0x21615a },
	{ 0x83e1, 0x223f57 },
	{ 0x83e2, 0x223f71 },
	{ 0x83e3, 0x223f50 },
	{ 0x83e4, 0x223f49 },
	{ 0x83e5, 0x223f54 },
	{ 0x83e6, 0x233e5f },
	{ 0x83e7, 0x223f48 },
	{ 0x83e8, 0x223f46 },
	{ 0x83e9, 0x216156 },
	{ 0x83ea, 0x223f68 },
	{ 0x83eb, 0x223f4f },
	{ 0x83ec, 0x223f6c },
	{ 0x83ed, 0x233e4b },
	{ 0x83ee, 0x223f6d },
	{ 0x83ef, 0x21615e },
	{ 0x83f0, 0x216163 },
	{ 0x83f1, 0x21615f },
	{ 0x83f2, 0x216167 },
	{ 0x83f3, 0x223f63 },
	{ 0x83f4, 0x216160 },
	{ 0x83f5, 0x223f5b },
	{ 0x83f6, 0x223f4b },
	{ 0x83f7, 0x2f3e66 },
	{ 0x83f8, 0x216158 },
	{ 0x83f9, 0x223f43 },
	{ 0x83fa, 0x223f65 },
	{ 0x83fb, 0x223f6f },
	{ 0x83fc, 0x223f4a },
	{ 0x83fd, 0x216166 },
	{ 0x83fe, 0x223f74 },
	{ 0x83ff, 0x223f56 },
	{ 0x8400, 0x233e52 },
	{ 0x8401, 0x223f52 },
	{ 0x8402, 0x233e5c },
	{ 0x8403, 0x216157 },
	{ 0x8404, 0x21616b },
	{ 0x8405, 0x233e5a },
	{ 0x8406, 0x223f61 },
	{ 0x8407, 0x21616d },
	{ 0x8408, 0x233e50 },
	{ 0x8409, 0x223f5d },
	{ 0x840a, 0x216162 },
	{ 0x840b, 0x21615c },
	{ 0x840c, 0x216164 },
	{ 0x840d, 0x216159 },
	{ 0x840e, 0x21616a },
	{ 0x840f, 0x223f5e },
	{ 0x8410, 0x223f4c },
	{ 0x8411, 0x223f60 },
	{ 0x8412, 0x223f47 },
	{ 0x8413, 0x223f69 },
	{ 0x8414, 0x233e58 },
	{ 0x8415, 0x243a67 },
	{ 0x8416, 0x233e5d },
	{ 0x8417, 0x233e56 },
	{ 0x8418, 0x233e4e },
	{ 0x841b, 0x223f72 },
	{ 0x841e, 0x236639 },
	{ 0x841f, 0x233e5b },
	{ 0x8421, 0x236638 },
	{ 0x8423, 0x223f44 },
	{ 0x8429, 0x22466c },
	{ 0x842a, 0x23442d },
	{ 0x842b, 0x224724 },
	{ 0x842c, 0x21655c },
	{ 0x842d, 0x224671 },
	{ 0x842e, 0x234431 },
	{ 0x842f, 0x22466f },
	{ 0x8430, 0x22465a },
	{ 0x8431, 0x216630 },
	{ 0x8432, 0x22466a },
	{ 0x8433, 0x22467e },
	{ 0x8434, 0x224666 },
	{ 0x8435, 0x216638 },
	{ 0x8436, 0x22467d },
	{ 0x8437, 0x224664 },
	{ 0x8438, 0x216169 },
	{ 0x8439, 0x224674 },
	{ 0x843a, 0x224665 },
	{ 0x843b, 0x22467b },
	{ 0x843c, 0x216637 },
	{ 0x843d, 0x21662f },
	{ 0x843e, 0x23443a },
	{ 0x843f, 0x22464f },
	{ 0x8440, 0x224657 },
	{ 0x8441, 0x234435 },
	{ 0x8442, 0x224670 },
	{ 0x8443, 0x224668 },
	{ 0x8444, 0x224723 },
	{ 0x8445, 0x22466b },
	{ 0x8446, 0x21663d },
	{ 0x8447, 0x22467c },
	{ 0x8448, 0x23442c },
	{ 0x8449, 0x216634 },
	{ 0x844a, 0x23443e },
	{ 0x844b, 0x22466e },
	{ 0x844c, 0x224676 },
	{ 0x844d, 0x22465b },
	{ 0x844e, 0x224675 },
	{ 0x844f, 0x234427 },
	{ 0x8450, 0x224728 },
	{ 0x8451, 0x224656 },
	{ 0x8452, 0x224677 },
	{ 0x8453, 0x234433 },
	{ 0x8454, 0x224726 },
	{ 0x8455, 0x23443f },
	{ 0x8456, 0x224650 },
	{ 0x8457, 0x216161 },
	{ 0x8458, 0x234440 },
	{ 0x8459, 0x22465e },
	{ 0x845a, 0x22465d },
	{ 0x845b, 0x216636 },
	{ 0x845c, 0x234432 },
	{ 0x845d, 0x224661 },
	{ 0x845e, 0x224663 },
	{ 0x845f, 0x224672 },
	{ 0x8460, 0x224725 },
	{ 0x8461, 0x216639 },
	{ 0x8462, 0x234438 },
	{ 0x8463, 0x21663a },
	{ 0x8464, 0x234430 },
	{ 0x8465, 0x224655 },
	{ 0x8466, 0x216632 },
	{ 0x8467, 0x224659 },
	{ 0x8468, 0x224721 },
	{ 0x8469, 0x21663b },
	{ 0x846a, 0x244044 },
	{ 0x846b, 0x216633 },
	{ 0x846c, 0x216635 },
	{ 0x846d, 0x21663c },
	{ 0x846e, 0x224727 },
	{ 0x846f, 0x224678 },
	{ 0x8470, 0x224673 },
	{ 0x8471, 0x23443c },
	{ 0x8472, 0x23442f },
	{ 0x8473, 0x224660 },
	{ 0x8474, 0x22465f },
	{ 0x8475, 0x216631 },
	{ 0x8476, 0x224651 },
	{ 0x8477, 0x21662e },
	{ 0x8478, 0x224669 },
	{ 0x8479, 0x224652 },
	{ 0x847a, 0x224667 },
	{ 0x847b, 0x23442e },
	{ 0x847c, 0x244041 },
	{ 0x847d, 0x22465c },
	{ 0x847e, 0x224722 },
	{ 0x847f, 0x23442a },
	{ 0x8480, 0x234439 },
	{ 0x8481, 0x244036 },
	{ 0x8482, 0x21662d },
	{ 0x8483, 0x23443b },
	{ 0x8484, 0x234428 },
	{ 0x8486, 0x224658 },
	{ 0x8488, 0x244046 },
	{ 0x848d, 0x224654 },
	{ 0x848e, 0x22467a },
	{ 0x848f, 0x224653 },
	{ 0x8490, 0x216a68 },
	{ 0x8491, 0x224d5a },
	{ 0x8492, 0x234935 },
	{ 0x8493, 0x234944 },
	{ 0x8494, 0x224d49 },
	{ 0x8495, 0x234933 },
	{ 0x8496, 0x234938 },
	{ 0x8497, 0x224d33 },
	{ 0x8498, 0x224d51 },
	{ 0x8499, 0x216a60 },
	{ 0x849a, 0x224d42 },
	{ 0x849b, 0x224d4c },
	{ 0x849c, 0x216a63 },
	{ 0x849d, 0x224d45 },
	{ 0x849e, 0x216a61 },
	{ 0x849f, 0x224d36 },
	{ 0x84a0, 0x224d54 },
	{ 0x84a1, 0x224d35 },
	{ 0x84a2, 0x224d48 },
	{ 0x84a3, 0x23493c },
	{ 0x84a4, 0x224d34 },
	{ 0x84a5, 0x234939 },
	{ 0x84a6, 0x24466c },
	{ 0x84a7, 0x224d46 },
	{ 0x84a8, 0x224d4f },
	{ 0x84a9, 0x224d4d },
	{ 0x84aa, 0x224d41 },
	{ 0x84ab, 0x224d3c },
	{ 0x84ac, 0x224d3a },
	{ 0x84ad, 0x234942 },
	{ 0x84ae, 0x224d3b },
	{ 0x84af, 0x224d4e },
	{ 0x84b0, 0x224d59 },
	{ 0x84b1, 0x224d43 },
	{ 0x84b2, 0x216a62 },
	{ 0x84b3, 0x23493b },
	{ 0x84b4, 0x224d3e },
	{ 0x84b5, 0x23493a },
	{ 0x84b6, 0x224d52 },
	{ 0x84b7, 0x234941 },
	{ 0x84b8, 0x216a65 },
	{ 0x84b9, 0x224d3d },
	{ 0x84ba, 0x224d37 },
	{ 0x84bb, 0x224d47 },
	{ 0x84bc, 0x216a69 },
	{ 0x84bd, 0x234932 },
	{ 0x84be, 0x244658 },
	{ 0x84bf, 0x216a5d },
	{ 0x84c0, 0x216a66 },
	{ 0x84c1, 0x224d3f },
	{ 0x84c2, 0x224d39 },
	{ 0x84c3, 0x234936 },
	{ 0x84c4, 0x216a5f },
	{ 0x84c5, 0x224679 },
	{ 0x84c6, 0x216a5e },
	{ 0x84c7, 0x224d4a },
	{ 0x84c8, 0x234436 },
	{ 0x84c9, 0x216a5c },
	{ 0x84ca, 0x216a6b },
	{ 0x84cb, 0x216a64 },
	{ 0x84cc, 0x224d4b },
	{ 0x84cd, 0x224d40 },
	{ 0x84ce, 0x224d38 },
	{ 0x84cf, 0x224d53 },
	{ 0x84d0, 0x224d44 },
	{ 0x84d1, 0x216a6a },
	{ 0x84d2, 0x224d57 },
	{ 0x84d3, 0x216a67 },
	{ 0x84d4, 0x224d56 },
	{ 0x84d5, 0x23493f },
	{ 0x84d6, 0x224d50 },
	{ 0x84d7, 0x224d55 },
	{ 0x84d8, 0x23493e },
	{ 0x84da, 0x234943 },
	{ 0x84db, 0x224d58 },
	{ 0x84de, 0x23663b },
	{ 0x84e1, 0x23663c },
	{ 0x84e2, 0x23663a },
	{ 0x84e4, 0x23493d },
	{ 0x84e7, 0x22535c },
	{ 0x84e8, 0x22535d },
	{ 0x84e9, 0x225350 },
	{ 0x84ea, 0x22534f },
	{ 0x84eb, 0x22534b },
	{ 0x84ec, 0x216e5d },
	{ 0x84ed, 0x234e4f },
	{ 0x84ee, 0x216e55 },
	{ 0x84ef, 0x22535f },
	{ 0x84f0, 0x22535e },
	{ 0x84f1, 0x22464e },
	{ 0x84f2, 0x225348 },
	{ 0x84f3, 0x22534c },
	{ 0x84f4, 0x225346 },
	{ 0x84f5, 0x234e44 },
	{ 0x84f6, 0x225359 },
	{ 0x84f7, 0x22534a },
	{ 0x84f8, 0x234e42 },
	{ 0x84f9, 0x225360 },
	{ 0x84fa, 0x225343 },
	{ 0x84fb, 0x225341 },
	{ 0x84fc, 0x22534d },
	{ 0x84fd, 0x225357 },
	{ 0x84fe, 0x225352 },
	{ 0x84ff, 0x216e5f },
	{ 0x8500, 0x225338 },
	{ 0x8501, 0x234e40 },
	{ 0x8502, 0x225356 },
	{ 0x8503, 0x234e4c },
	{ 0x8504, 0x234e46 },
	{ 0x8505, 0x234e54 },
	{ 0x8506, 0x216e60 },
	{ 0x8507, 0x224662 },
	{ 0x8508, 0x225344 },
	{ 0x8509, 0x22533b },
	{ 0x850a, 0x22533e },
	{ 0x850b, 0x225364 },
	{ 0x850c, 0x225345 },
	{ 0x850d, 0x22533c },
	{ 0x850e, 0x22533a },
	{ 0x850f, 0x225337 },
	{ 0x8510, 0x244c7a },
	{ 0x8511, 0x216e59 },
	{ 0x8512, 0x22534e },
	{ 0x8513, 0x216e58 },
	{ 0x8514, 0x216e5c },
	{ 0x8515, 0x225349 },
	{ 0x8516, 0x225351 },
	{ 0x8517, 0x216e52 },
	{ 0x8518, 0x225361 },
	{ 0x8519, 0x225365 },
	{ 0x851a, 0x216e54 },
	{ 0x851b, 0x234e4b },
	{ 0x851c, 0x225340 },
	{ 0x851d, 0x225354 },
	{ 0x851e, 0x225358 },
	{ 0x851f, 0x22533d },
	{ 0x8520, 0x225362 },
	{ 0x8521, 0x216e5b },
	{ 0x8522, 0x244c6a },
	{ 0x8523, 0x216e5a },
	{ 0x8524, 0x225335 },
	{ 0x8525, 0x216e5e },
	{ 0x8526, 0x22535b },
	{ 0x8527, 0x22533f },
	{ 0x8528, 0x225353 },
	{ 0x8529, 0x225339 },
	{ 0x852a, 0x225347 },
	{ 0x852b, 0x225342 },
	{ 0x852c, 0x216e56 },
	{ 0x852d, 0x216e57 },
	{ 0x852e, 0x225355 },
	{ 0x852f, 0x225366 },
	{ 0x8530, 0x225363 },
	{ 0x8531, 0x22535a },
	{ 0x8532, 0x244c78 },
	{ 0x8533, 0x234e4d },
	{ 0x8534, 0x234e4e },
	{ 0x8535, 0x234e52 },
	{ 0x8538, 0x244c74 },
	{ 0x853b, 0x225336 },
	{ 0x853d, 0x216e53 },
	{ 0x853e, 0x225974 },
	{ 0x853f, 0x23525a },
	{ 0x8540, 0x22596b },
	{ 0x8541, 0x22596e },
	{ 0x8542, 0x235252 },
	{ 0x8543, 0x217225 },
	{ 0x8544, 0x225970 },
	{ 0x8545, 0x225965 },
	{ 0x8546, 0x22596c },
	{ 0x8547, 0x225972 },
	{ 0x8548, 0x217222 },
	{ 0x8549, 0x217226 },
	{ 0x854a, 0x21717e },
	{ 0x854b, 0x235259 },
	{ 0x854c, 0x235250 },
	{ 0x854d, 0x225967 },
	{ 0x854e, 0x225977 },
	{ 0x854f, 0x244d25 },
	{ 0x8550, 0x245333 },
	{ 0x8551, 0x225971 },
	{ 0x8552, 0x245324 },
	{ 0x8553, 0x225968 },
	{ 0x8554, 0x225a22 },
	{ 0x8555, 0x22597a },
	{ 0x8556, 0x225964 },
	{ 0x8557, 0x225e72 },
	{ 0x8558, 0x22596a },
	{ 0x8559, 0x217221 },
	{ 0x855a, 0x235258 },
	{ 0x855b, 0x225975 },
	{ 0x855c, 0x235254 },
	{ 0x855d, 0x225a21 },
	{ 0x855e, 0x217229 },
	{ 0x855f, 0x235256 },
	{ 0x8560, 0x22597c },
	{ 0x8561, 0x225969 },
	{ 0x8562, 0x22596f },
	{ 0x8563, 0x225973 },
	{ 0x8564, 0x22596d },
	{ 0x8565, 0x225a23 },
	{ 0x8566, 0x22597e },
	{ 0x8567, 0x22597b },
	{ 0x8568, 0x217223 },
	{ 0x8569, 0x217224 },
	{ 0x856a, 0x217228 },
	{ 0x856b, 0x225966 },
	{ 0x856c, 0x225a24 },
	{ 0x856d, 0x217227 },
	{ 0x856e, 0x225978 },
	{ 0x856f, 0x23524f },
	{ 0x8570, 0x235255 },
	{ 0x8571, 0x225976 },
	{ 0x8573, 0x23663d },
	{ 0x8575, 0x225979 },
	{ 0x8576, 0x225f21 },
	{ 0x8577, 0x225e6c },
	{ 0x8578, 0x225e71 },
	{ 0x8579, 0x225e7e },
	{ 0x857a, 0x225e70 },
	{ 0x857b, 0x225e68 },
	{ 0x857c, 0x225e6d },
	{ 0x857d, 0x24583e },
	{ 0x857e, 0x21752c },
	{ 0x857f, 0x23562b },
	{ 0x8580, 0x225e61 },
	{ 0x8581, 0x225e79 },
	{ 0x8582, 0x225e7b },
	{ 0x8583, 0x225e60 },
	{ 0x8584, 0x21752b },
	{ 0x8585, 0x225e7d },
	{ 0x8586, 0x225e75 },
	{ 0x8587, 0x217532 },
	{ 0x8588, 0x225e7c },
	{ 0x8589, 0x225e6e },
	{ 0x858a, 0x217534 },
	{ 0x858b, 0x225e66 },
	{ 0x858c, 0x22597d },
	{ 0x858d, 0x225e76 },
	{ 0x858e, 0x225e73 },
	{ 0x858f, 0x225e62 },
	{ 0x8590, 0x225f23 },
	{ 0x8591, 0x21752e },
	{ 0x8592, 0x235628 },
	{ 0x8593, 0x235629 },
	{ 0x8594, 0x21752f },
	{ 0x8595, 0x225e64 },
	{ 0x8596, 0x225e74 },
	{ 0x8597, 0x23562d },
	{ 0x8598, 0x225f22 },
	{ 0x8599, 0x225e77 },
	{ 0x859a, 0x225e6a },
	{ 0x859b, 0x217531 },
	{ 0x859c, 0x21752d },
	{ 0x859d, 0x225e78 },
	{ 0x859e, 0x225e6b },
	{ 0x859f, 0x225f24 },
	{ 0x85a0, 0x225e65 },
	{ 0x85a1, 0x225e6f },
	{ 0x85a2, 0x225e7a },
	{ 0x85a3, 0x225e67 },
	{ 0x85a4, 0x225e69 },
	{ 0x85a5, 0x245840 },
	{ 0x85a6, 0x217535 },
	{ 0x85a7, 0x225e63 },
	{ 0x85a8, 0x217533 },
	{ 0x85a9, 0x217730 },
	{ 0x85aa, 0x21752a },
	{ 0x85ab, 0x23562c },
	{ 0x85ac, 0x235630 },
	{ 0x85af, 0x217530 },
	{ 0x85b0, 0x217734 },
	{ 0x85b1, 0x22627d },
	{ 0x85b2, 0x23586c },
	{ 0x85b3, 0x226273 },
	{ 0x85b4, 0x22626e },
	{ 0x85b5, 0x226274 },
	{ 0x85b6, 0x22627e },
	{ 0x85b7, 0x226324 },
	{ 0x85b8, 0x226323 },
	{ 0x85b9, 0x217736 },
	{ 0x85ba, 0x217735 },
	{ 0x85bb, 0x23586e },
	{ 0x85bc, 0x245d2c },
	{ 0x85bd, 0x226275 },
	{ 0x85be, 0x226325 },
	{ 0x85bf, 0x226278 },
	{ 0x85c0, 0x226270 },
	{ 0x85c1, 0x23586f },
	{ 0x85c2, 0x226272 },
	{ 0x85c3, 0x226271 },
	{ 0x85c4, 0x226277 },
	{ 0x85c5, 0x22627c },
	{ 0x85c6, 0x22626f },
	{ 0x85c7, 0x226276 },
	{ 0x85c8, 0x22627b },
	{ 0x85c9, 0x217733 },
	{ 0x85ca, 0x245d28 },
	{ 0x85cb, 0x226279 },
	{ 0x85cc, 0x23586b },
	{ 0x85cd, 0x217731 },
	{ 0x85ce, 0x22627a },
	{ 0x85cf, 0x21772f },
	{ 0x85d0, 0x217732 },
	{ 0x85d1, 0x226660 },
	{ 0x85d2, 0x226321 },
	{ 0x85d4, 0x23663e },
	{ 0x85d5, 0x21786d },
	{ 0x85d6, 0x235a7e },
	{ 0x85d7, 0x226658 },
	{ 0x85d8, 0x22665c },
	{ 0x85d9, 0x226654 },
	{ 0x85da, 0x226657 },
	{ 0x85db, 0x235a7d },
	{ 0x85dc, 0x22665f },
	{ 0x85dd, 0x21786b },
	{ 0x85de, 0x226664 },
	{ 0x85df, 0x22665d },
	{ 0x85e0, 0x24607a },
	{ 0x85e1, 0x226655 },
	{ 0x85e2, 0x226665 },
	{ 0x85e3, 0x22665e },
	{ 0x85e4, 0x21786e },
	{ 0x85e5, 0x21786f },
	{ 0x85e6, 0x226662 },
	{ 0x85e7, 0x235b22 },
	{ 0x85e8, 0x226656 },
	{ 0x85e9, 0x21786a },
	{ 0x85ea, 0x21786c },
	{ 0x85eb, 0x226651 },
	{ 0x85ec, 0x226659 },
	{ 0x85ed, 0x226653 },
	{ 0x85ee, 0x235c7b },
	{ 0x85ef, 0x226663 },
	{ 0x85f0, 0x226661 },
	{ 0x85f1, 0x226652 },
	{ 0x85f2, 0x22665a },
	{ 0x85f3, 0x24607b },
	{ 0x85f4, 0x235b25 },
	{ 0x85f5, 0x23663f },
	{ 0x85f6, 0x22696a },
	{ 0x85f7, 0x217870 },
	{ 0x85f8, 0x22665b },
	{ 0x85f9, 0x217a32 },
	{ 0x85fa, 0x217a34 },
	{ 0x85fb, 0x217a31 },
	{ 0x85fc, 0x235c76 },
	{ 0x85fd, 0x22696f },
	{ 0x85fe, 0x226967 },
	{ 0x85ff, 0x226965 },
	{ 0x8600, 0x226969 },
	{ 0x8601, 0x226966 },
	{ 0x8602, 0x235c78 },
	{ 0x8603, 0x235c7c },
	{ 0x8604, 0x22696b },
	{ 0x8605, 0x22696d },
	{ 0x8606, 0x217a35 },
	{ 0x8607, 0x217a37 },
	{ 0x8608, 0x235d22 },
	{ 0x8609, 0x22696c },
	{ 0x860a, 0x217a38 },
	{ 0x860b, 0x217a36 },
	{ 0x860c, 0x22696e },
	{ 0x860d, 0x235c7e },
	{ 0x860e, 0x246437 },
	{ 0x860f, 0x235d23 },
	{ 0x8610, 0x235c77 },
	{ 0x8611, 0x217a33 },
	{ 0x8613, 0x235d21 },
	{ 0x8615, 0x235e5b },
	{ 0x8616, 0x235e5a },
	{ 0x8617, 0x217b21 },
	{ 0x8618, 0x226c21 },
	{ 0x8619, 0x226c27 },
	{ 0x861a, 0x217b23 },
	{ 0x861b, 0x226968 },
	{ 0x861c, 0x226c26 },
	{ 0x861d, 0x235e5c },
	{ 0x861e, 0x226c2d },
	{ 0x861f, 0x226c24 },
	{ 0x8620, 0x226c2b },
	{ 0x8621, 0x226c2a },
	{ 0x8622, 0x226964 },
	{ 0x8623, 0x226c25 },
	{ 0x8624, 0x226322 },
	{ 0x8625, 0x226c2e },
	{ 0x8626, 0x226c23 },
	{ 0x8627, 0x226c28 },
	{ 0x8628, 0x235e58 },
	{ 0x8629, 0x226c2c },
	{ 0x862a, 0x226c22 },
	{ 0x862b, 0x235e56 },
	{ 0x862c, 0x226d77 },
	{ 0x862d, 0x217b22 },
	{ 0x862e, 0x226c29 },
	{ 0x862f, 0x235e57 },
	{ 0x8631, 0x226f43 },
	{ 0x8632, 0x226d78 },
	{ 0x8633, 0x226d76 },
	{ 0x8634, 0x226d74 },
	{ 0x8635, 0x226d75 },
	{ 0x8636, 0x226d79 },
	{ 0x8637, 0x236640 },
	{ 0x8638, 0x217c45 },
	{ 0x8639, 0x226f41 },
	{ 0x863a, 0x226f3f },
	{ 0x863b, 0x226f44 },
	{ 0x863c, 0x226f42 },
	{ 0x863d, 0x236043 },
	{ 0x863e, 0x226f45 },
	{ 0x863f, 0x217c46 },
	{ 0x8640, 0x226f40 },
	{ 0x8641, 0x23602f },
	{ 0x8642, 0x236146 },
	{ 0x8643, 0x22704a },
	{ 0x8645, 0x236641 },
	{ 0x8646, 0x227134 },
	{ 0x8647, 0x227135 },
	{ 0x8648, 0x227136 },
	{ 0x8649, 0x236147 },
	{ 0x864a, 0x23617c },
	{ 0x864b, 0x227235 },
	{ 0x864c, 0x22722d },
	{ 0x864d, 0x22226f },
	{ 0x864e, 0x214f4d },
	{ 0x8650, 0x21534b },
	{ 0x8651, 0x242f68 },
	{ 0x8652, 0x22325a },
	{ 0x8653, 0x223259 },
	{ 0x8654, 0x215825 },
	{ 0x8655, 0x215d28 },
	{ 0x8656, 0x223921 },
	{ 0x8657, 0x233863 },
	{ 0x8658, 0x233860 },
	{ 0x8659, 0x22387e },
	{ 0x865a, 0x233861 },
	{ 0x865b, 0x216170 },
	{ 0x865c, 0x21663f },
	{ 0x865d, 0x233e61 },
	{ 0x865e, 0x21663e },
	{ 0x865f, 0x216640 },
	{ 0x8660, 0x25494e },
	{ 0x8661, 0x224d5b },
	{ 0x8662, 0x225367 },
	{ 0x8663, 0x225a25 },
	{ 0x8664, 0x225a27 },
	{ 0x8665, 0x225a26 },
	{ 0x8666, 0x273261 },
	{ 0x8667, 0x217536 },
	{ 0x8668, 0x225f25 },
	{ 0x8669, 0x226326 },
	{ 0x866a, 0x227173 },
	{ 0x866b, 0x214865 },
	{ 0x866c, 0x23272d },
	{ 0x866d, 0x222869 },
	{ 0x866e, 0x22286a },
	{ 0x866f, 0x222868 },
	{ 0x8670, 0x222867 },
	{ 0x8671, 0x214f4e },
	{ 0x8672, 0x236642 },
	{ 0x8673, 0x222d4a },
	{ 0x8674, 0x222d48 },
	{ 0x8675, 0x232f23 },
	{ 0x8676, 0x232e7c },
	{ 0x8677, 0x222d47 },
	{ 0x8678, 0x232e7e },
	{ 0x8679, 0x21534c },
	{ 0x867a, 0x21534e },
	{ 0x867b, 0x21534d },
	{ 0x867c, 0x222d49 },
	{ 0x867d, 0x232f24 },
	{ 0x867e, 0x2f2d3e },
	{ 0x8684, 0x233369 },
	{ 0x8685, 0x223266 },
	{ 0x8686, 0x223263 },
	{ 0x8687, 0x223261 },
	{ 0x8688, 0x242f6d },
	{ 0x8689, 0x23336c },
	{ 0x868a, 0x215826 },
	{ 0x868b, 0x223264 },
	{ 0x868c, 0x21582b },
	{ 0x868d, 0x22325e },
	{ 0x868e, 0x22326d },
	{ 0x868f, 0x23336f },
	{ 0x8690, 0x22326f },
	{ 0x8691, 0x22325f },
	{ 0x8692, 0x23336e },
	{ 0x8693, 0x215828 },
	{ 0x8694, 0x223270 },
	{ 0x8695, 0x22326b },
	{ 0x8696, 0x22325d },
	{ 0x8697, 0x223262 },
	{ 0x8698, 0x22326c },
	{ 0x8699, 0x223268 },
	{ 0x869a, 0x223265 },
	{ 0x869b, 0x23336b },
	{ 0x869c, 0x21582d },
	{ 0x869d, 0x22326e },
	{ 0x869e, 0x223260 },
	{ 0x869f, 0x23336a },
	{ 0x86a0, 0x233370 },
	{ 0x86a1, 0x223269 },
	{ 0x86a2, 0x22325b },
	{ 0x86a3, 0x21582c },
	{ 0x86a4, 0x215829 },
	{ 0x86a5, 0x223267 },
	{ 0x86a6, 0x23336d },
	{ 0x86a7, 0x22326a },
	{ 0x86a8, 0x22325c },
	{ 0x86a9, 0x21582a },
	{ 0x86aa, 0x215827 },
	{ 0x86ad, 0x24347a },
	{ 0x86ae, 0x233866 },
	{ 0x86af, 0x215d32 },
	{ 0x86b0, 0x223928 },
	{ 0x86b1, 0x215d31 },
	{ 0x86b2, 0x233864 },
	{ 0x86b3, 0x22392b },
	{ 0x86b4, 0x22392e },
	{ 0x86b5, 0x215d2e },
	{ 0x86b6, 0x215d2c },
	{ 0x86b7, 0x223923 },
	{ 0x86b8, 0x22392c },
	{ 0x86b9, 0x22392a },
	{ 0x86ba, 0x223927 },
	{ 0x86bb, 0x22392f },
	{ 0x86bc, 0x223930 },
	{ 0x86bd, 0x223932 },
	{ 0x86be, 0x223933 },
	{ 0x86bf, 0x223922 },
	{ 0x86c0, 0x215d2b },
	{ 0x86c1, 0x223925 },
	{ 0x86c2, 0x223924 },
	{ 0x86c3, 0x223931 },
	{ 0x86c4, 0x215d2d },
	{ 0x86c5, 0x223926 },
	{ 0x86c6, 0x215d2f },
	{ 0x86c7, 0x215d2a },
	{ 0x86c8, 0x223929 },
	{ 0x86c9, 0x215d33 },
	{ 0x86ca, 0x243526 },
	{ 0x86cb, 0x215d30 },
	{ 0x86cc, 0x22392d },
	{ 0x86cf, 0x2f383a },
	{ 0x86d0, 0x216177 },
	{ 0x86d1, 0x224025 },
	{ 0x86d2, 0x243a71 },
	{ 0x86d3, 0x223f78 },
	{ 0x86d4, 0x216174 },
	{ 0x86d5, 0x233e62 },
	{ 0x86d6, 0x22472e },
	{ 0x86d7, 0x224023 },
	{ 0x86d8, 0x223f75 },
	{ 0x86d9, 0x216172 },
	{ 0x86da, 0x223f7a },
	{ 0x86db, 0x216175 },
	{ 0x86dc, 0x223f7e },
	{ 0x86dd, 0x223f7c },
	{ 0x86de, 0x216178 },
	{ 0x86df, 0x216171 },
	{ 0x86e0, 0x243a76 },
	{ 0x86e1, 0x233e63 },
	{ 0x86e2, 0x223f76 },
	{ 0x86e3, 0x223f79 },
	{ 0x86e4, 0x216176 },
	{ 0x86e5, 0x243a6f },
	{ 0x86e6, 0x223f77 },
	{ 0x86e7, 0x253b7b },
	{ 0x86e8, 0x224024 },
	{ 0x86e9, 0x224022 },
	{ 0x86ea, 0x223f7b },
	{ 0x86eb, 0x223f7d },
	{ 0x86ec, 0x224021 },
	{ 0x86ed, 0x216173 },
	{ 0x86ee, 0x233e68 },
	{ 0x86f5, 0x22472f },
	{ 0x86f6, 0x224735 },
	{ 0x86f7, 0x22472b },
	{ 0x86f8, 0x224731 },
	{ 0x86f9, 0x216641 },
	{ 0x86fa, 0x22472d },
	{ 0x86fb, 0x216647 },
	{ 0x86fc, 0x234444 },
	{ 0x86fd, 0x234445 },
	{ 0x86fe, 0x216646 },
	{ 0x86ff, 0x234449 },
	{ 0x8700, 0x216645 },
	{ 0x8701, 0x224734 },
	{ 0x8702, 0x216648 },
	{ 0x8703, 0x216649 },
	{ 0x8704, 0x22472a },
	{ 0x8705, 0x224737 },
	{ 0x8706, 0x21664a },
	{ 0x8707, 0x216644 },
	{ 0x8708, 0x216643 },
	{ 0x8709, 0x224733 },
	{ 0x870a, 0x21664b },
	{ 0x870b, 0x224729 },
	{ 0x870c, 0x22472c },
	{ 0x870d, 0x224736 },
	{ 0x870e, 0x224732 },
	{ 0x870f, 0x244059 },
	{ 0x8710, 0x244052 },
	{ 0x8711, 0x224d7b },
	{ 0x8712, 0x224d70 },
	{ 0x8713, 0x216642 },
	{ 0x8714, 0x25425d },
	{ 0x8715, 0x234446 },
	{ 0x8716, 0x234448 },
	{ 0x8718, 0x216a72 },
	{ 0x8719, 0x224d64 },
	{ 0x871a, 0x224d79 },
	{ 0x871b, 0x224d65 },
	{ 0x871c, 0x216a6d },
	{ 0x871d, 0x23494f },
	{ 0x871e, 0x224d62 },
	{ 0x871f, 0x244055 },
	{ 0x8720, 0x224d6b },
	{ 0x8721, 0x224d63 },
	{ 0x8722, 0x216a6f },
	{ 0x8723, 0x224d5d },
	{ 0x8724, 0x224d78 },
	{ 0x8725, 0x216a70 },
	{ 0x8726, 0x224d75 },
	{ 0x8727, 0x224d76 },
	{ 0x8728, 0x224d5e },
	{ 0x8729, 0x216a75 },
	{ 0x872a, 0x224d6d },
	{ 0x872b, 0x23494a },
	{ 0x872c, 0x224d67 },
	{ 0x872d, 0x224d6e },
	{ 0x872e, 0x224d61 },
	{ 0x872f, 0x24467e },
	{ 0x8730, 0x224d7a },
	{ 0x8731, 0x224d72 },
	{ 0x8732, 0x224d6c },
	{ 0x8733, 0x224d5c },
	{ 0x8734, 0x216a71 },
	{ 0x8735, 0x224d73 },
	{ 0x8736, 0x234945 },
	{ 0x8737, 0x216a74 },
	{ 0x8738, 0x224d77 },
	{ 0x8739, 0x23494c },
	{ 0x873a, 0x224d71 },
	{ 0x873b, 0x216a6e },
	{ 0x873c, 0x224d6f },
	{ 0x873d, 0x234949 },
	{ 0x873e, 0x224d69 },
	{ 0x873f, 0x216a6c },
	{ 0x8740, 0x224d60 },
	{ 0x8741, 0x224d68 },
	{ 0x8742, 0x224d74 },
	{ 0x8743, 0x224d66 },
	{ 0x8744, 0x2f4c33 },
	{ 0x8745, 0x23494e },
	{ 0x8746, 0x224d6a },
	{ 0x8747, 0x23494b },
	{ 0x874a, 0x236643 },
	{ 0x874c, 0x216e6a },
	{ 0x874d, 0x224730 },
	{ 0x874e, 0x225379 },
	{ 0x874f, 0x225424 },
	{ 0x8750, 0x225378 },
	{ 0x8751, 0x225374 },
	{ 0x8752, 0x225371 },
	{ 0x8753, 0x216e6b },
	{ 0x8754, 0x22536f },
	{ 0x8755, 0x216a73 },
	{ 0x8756, 0x225368 },
	{ 0x8757, 0x216e69 },
	{ 0x8758, 0x22536e },
	{ 0x8759, 0x216e68 },
	{ 0x875a, 0x225373 },
	{ 0x875b, 0x225370 },
	{ 0x875c, 0x225422 },
	{ 0x875d, 0x22537b },
	{ 0x875e, 0x225375 },
	{ 0x875f, 0x22537a },
	{ 0x8760, 0x216e64 },
	{ 0x8761, 0x225372 },
	{ 0x8762, 0x225427 },
	{ 0x8763, 0x225369 },
	{ 0x8764, 0x22536a },
	{ 0x8765, 0x225423 },
	{ 0x8766, 0x216e65 },
	{ 0x8767, 0x225428 },
	{ 0x8768, 0x216e67 },
	{ 0x8769, 0x225429 },
	{ 0x876a, 0x225377 },
	{ 0x876b, 0x224d5f },
	{ 0x876c, 0x22537d },
	{ 0x876d, 0x225376 },
	{ 0x876e, 0x225421 },
	{ 0x876f, 0x22537c },
	{ 0x8770, 0x255055 },
	{ 0x8771, 0x234e5d },
	{ 0x8772, 0x244d28 },
	{ 0x8773, 0x22536d },
	{ 0x8774, 0x216e62 },
	{ 0x8775, 0x225426 },
	{ 0x8776, 0x216e63 },
	{ 0x8777, 0x22536b },
	{ 0x8778, 0x216e66 },
	{ 0x8779, 0x225a32 },
	{ 0x877a, 0x22537e },
	{ 0x877b, 0x225425 },
	{ 0x877c, 0x244d31 },
	{ 0x877d, 0x234e59 },
	{ 0x8781, 0x225a2f },
	{ 0x8782, 0x216e61 },
	{ 0x8783, 0x21722a },
	{ 0x8784, 0x225a39 },
	{ 0x8785, 0x225a35 },
	{ 0x8786, 0x24533c },
	{ 0x8787, 0x225a33 },
	{ 0x8788, 0x225a2e },
	{ 0x8789, 0x225a3d },
	{ 0x878a, 0x23525b },
	{ 0x878b, 0x23525d },
	{ 0x878c, 0x245344 },
	{ 0x878d, 0x21722e },
	{ 0x878e, 0x23525f },
	{ 0x878f, 0x225a2a },
	{ 0x8790, 0x225a36 },
	{ 0x8791, 0x225a37 },
	{ 0x8792, 0x225a2d },
	{ 0x8793, 0x225a2c },
	{ 0x8794, 0x225a3a },
	{ 0x8795, 0x245341 },
	{ 0x8796, 0x225a30 },
	{ 0x8797, 0x225a2b },
	{ 0x8798, 0x225a31 },
	{ 0x8799, 0x235262 },
	{ 0x879a, 0x225a3c },
	{ 0x879b, 0x225a29 },
	{ 0x879c, 0x225a3b },
	{ 0x879d, 0x225a38 },
	{ 0x879e, 0x21722c },
	{ 0x879f, 0x21722b },
	{ 0x87a0, 0x245339 },
	{ 0x87a1, 0x23525e },
	{ 0x87a2, 0x21722d },
	{ 0x87a3, 0x225a34 },
	{ 0x87a4, 0x225a28 },
	{ 0x87a5, 0x236645 },
	{ 0x87a9, 0x236644 },
	{ 0x87aa, 0x225f27 },
	{ 0x87ab, 0x21753c },
	{ 0x87ac, 0x225f2b },
	{ 0x87ad, 0x225f28 },
	{ 0x87ae, 0x225f2f },
	{ 0x87af, 0x225f35 },
	{ 0x87b0, 0x225f2a },
	{ 0x87b1, 0x23563a },
	{ 0x87b2, 0x225f3e },
	{ 0x87b3, 0x217539 },
	{ 0x87b4, 0x225f38 },
	{ 0x87b5, 0x225f2d },
	{ 0x87b6, 0x225f39 },
	{ 0x87b7, 0x225f34 },
	{ 0x87b8, 0x225f3b },
	{ 0x87b9, 0x225f2c },
	{ 0x87ba, 0x21753e },
	{ 0x87bb, 0x21753d },
	{ 0x87bc, 0x225f2e },
	{ 0x87bd, 0x225f3c },
	{ 0x87be, 0x225f26 },
	{ 0x87bf, 0x225f3a },
	{ 0x87c0, 0x217537 },
	{ 0x87c1, 0x235639 },
	{ 0x87c2, 0x225f32 },
	{ 0x87c3, 0x225f31 },
	{ 0x87c4, 0x225f36 },
	{ 0x87c5, 0x225f29 },
	{ 0x87c6, 0x21753b },
	{ 0x87c7, 0x23563b },
	{ 0x87c8, 0x21753f },
	{ 0x87c9, 0x225f30 },
	{ 0x87ca, 0x225f37 },
	{ 0x87cb, 0x217540 },
	{ 0x87cc, 0x225f33 },
	{ 0x87cd, 0x235636 },
	{ 0x87ce, 0x235634 },
	{ 0x87d1, 0x217538 },
	{ 0x87d2, 0x21753a },
	{ 0x87d3, 0x226333 },
	{ 0x87d4, 0x226331 },
	{ 0x87d5, 0x235b28 },
	{ 0x87d6, 0x235876 },
	{ 0x87d7, 0x226337 },
	{ 0x87d8, 0x226335 },
	{ 0x87d9, 0x226338 },
	{ 0x87da, 0x235878 },
	{ 0x87db, 0x22632a },
	{ 0x87dc, 0x226332 },
	{ 0x87dd, 0x22633c },
	{ 0x87de, 0x225f3d },
	{ 0x87df, 0x22632e },
	{ 0x87e0, 0x21773a },
	{ 0x87e1, 0x22536c },
	{ 0x87e2, 0x226329 },
	{ 0x87e3, 0x226336 },
	{ 0x87e4, 0x226330 },
	{ 0x87e5, 0x22632d },
	{ 0x87e6, 0x226328 },
	{ 0x87e7, 0x226327 },
	{ 0x87e8, 0x22633b },
	{ 0x87e9, 0x235873 },
	{ 0x87ea, 0x22632c },
	{ 0x87eb, 0x22632b },
	{ 0x87ec, 0x217738 },
	{ 0x87ed, 0x226334 },
	{ 0x87ee, 0x235874 },
	{ 0x87ef, 0x217737 },
	{ 0x87f0, 0x235875 },
	{ 0x87f1, 0x256448 },
	{ 0x87f2, 0x217739 },
	{ 0x87f3, 0x22632f },
	{ 0x87f4, 0x22633a },
	{ 0x87f5, 0x236646 },
	{ 0x87f6, 0x226669 },
	{ 0x87f7, 0x22666a },
	{ 0x87f8, 0x235b2c },
	{ 0x87f9, 0x217874 },
	{ 0x87fa, 0x226667 },
	{ 0x87fb, 0x217871 },
	{ 0x87fc, 0x22666f },
	{ 0x87fd, 0x235b27 },
	{ 0x87fe, 0x217875 },
	{ 0x87ff, 0x226671 },
	{ 0x8800, 0x226666 },
	{ 0x8801, 0x226339 },
	{ 0x8802, 0x226673 },
	{ 0x8803, 0x226668 },
	{ 0x8804, 0x256943 },
	{ 0x8805, 0x217872 },
	{ 0x8806, 0x22666e },
	{ 0x8807, 0x235b29 },
	{ 0x8808, 0x226670 },
	{ 0x8809, 0x22666b },
	{ 0x880a, 0x226672 },
	{ 0x880b, 0x22666d },
	{ 0x880c, 0x22666c },
	{ 0x880d, 0x217873 },
	{ 0x880e, 0x235877 },
	{ 0x880f, 0x235b2b },
	{ 0x8810, 0x226971 },
	{ 0x8811, 0x226972 },
	{ 0x8812, 0x235d25 },
	{ 0x8813, 0x226974 },
	{ 0x8814, 0x217a39 },
	{ 0x8815, 0x217a3a },
	{ 0x8816, 0x226975 },
	{ 0x8817, 0x226973 },
	{ 0x8818, 0x235d24 },
	{ 0x8819, 0x226970 },
	{ 0x881a, 0x235e5d },
	{ 0x881b, 0x226c31 },
	{ 0x881c, 0x226c34 },
	{ 0x881d, 0x226c30 },
	{ 0x881e, 0x246126 },
	{ 0x881f, 0x217b27 },
	{ 0x8820, 0x226c32 },
	{ 0x8821, 0x217b26 },
	{ 0x8822, 0x217b25 },
	{ 0x8823, 0x217b24 },
	{ 0x8824, 0x226c33 },
	{ 0x8825, 0x226d7e },
	{ 0x8826, 0x226d7c },
	{ 0x8827, 0x235f5f },
	{ 0x8828, 0x226d7b },
	{ 0x8829, 0x226c2f },
	{ 0x882a, 0x226d7d },
	{ 0x882b, 0x226c35 },
	{ 0x882c, 0x226d7a },
	{ 0x882d, 0x236045 },
	{ 0x882e, 0x226f48 },
	{ 0x882f, 0x226f26 },
	{ 0x8830, 0x226f46 },
	{ 0x8831, 0x217c47 },
	{ 0x8832, 0x226f47 },
	{ 0x8833, 0x226f49 },
	{ 0x8834, 0x236647 },
	{ 0x8835, 0x22704d },
	{ 0x8836, 0x217c66 },
	{ 0x8837, 0x22704c },
	{ 0x8838, 0x22704b },
	{ 0x8839, 0x217c67 },
	{ 0x883a, 0x246c23 },
	{ 0x883b, 0x217d27 },
	{ 0x883c, 0x22715d },
	{ 0x883d, 0x227175 },
	{ 0x883e, 0x227174 },
	{ 0x883f, 0x227176 },
	{ 0x8840, 0x214866 },
	{ 0x8841, 0x222d4b },
	{ 0x8842, 0x232f26 },
	{ 0x8843, 0x223271 },
	{ 0x8844, 0x223272 },
	{ 0x8845, 0x23386a },
	{ 0x8846, 0x233e6a },
	{ 0x8847, 0x233e69 },
	{ 0x8848, 0x224026 },
	{ 0x8849, 0x264e4f },
	{ 0x884a, 0x226c36 },
	{ 0x884b, 0x22704e },
	{ 0x884c, 0x214867 },
	{ 0x884d, 0x21534f },
	{ 0x884e, 0x222d4c },
	{ 0x884f, 0x233371 },
	{ 0x8850, 0x236648 },
	{ 0x8851, 0x243527 },
	{ 0x8852, 0x223934 },
	{ 0x8853, 0x215d34 },
	{ 0x8855, 0x224028 },
	{ 0x8856, 0x224027 },
	{ 0x8857, 0x216179 },
	{ 0x8858, 0x23444d },
	{ 0x8859, 0x21664c },
	{ 0x885a, 0x22542a },
	{ 0x885b, 0x216e6c },
	{ 0x885c, 0x234e5f },
	{ 0x885d, 0x216e6d },
	{ 0x885e, 0x235263 },
	{ 0x885f, 0x235264 },
	{ 0x8860, 0x24534b },
	{ 0x8861, 0x21722f },
	{ 0x8862, 0x217c68 },
	{ 0x8863, 0x214868 },
	{ 0x8866, 0x232f27 },
	{ 0x8867, 0x222d4d },
	{ 0x8868, 0x214f50 },
	{ 0x8869, 0x222d4f },
	{ 0x886a, 0x222d4e },
	{ 0x886b, 0x215350 },
	{ 0x886d, 0x223273 },
	{ 0x886e, 0x233374 },
	{ 0x886f, 0x22327a },
	{ 0x8870, 0x21582e },
	{ 0x8871, 0x223278 },
	{ 0x8872, 0x223276 },
	{ 0x8873, 0x233377 },
	{ 0x8874, 0x22327d },
	{ 0x8875, 0x223274 },
	{ 0x8876, 0x223275 },
	{ 0x8877, 0x21582f },
	{ 0x8878, 0x233372 },
	{ 0x8879, 0x215833 },
	{ 0x887a, 0x233373 },
	{ 0x887b, 0x233375 },
	{ 0x887c, 0x22327e },
	{ 0x887d, 0x215832 },
	{ 0x887e, 0x22327c },
	{ 0x887f, 0x223279 },
	{ 0x8880, 0x223277 },
	{ 0x8881, 0x215830 },
	{ 0x8882, 0x215831 },
	{ 0x8883, 0x22327b },
	{ 0x8884, 0x233376 },
	{ 0x8887, 0x236649 },
	{ 0x8888, 0x215d36 },
	{ 0x8889, 0x223935 },
	{ 0x888a, 0x233872 },
	{ 0x888b, 0x215d3b },
	{ 0x888c, 0x223945 },
	{ 0x888d, 0x215d3a },
	{ 0x888e, 0x223947 },
	{ 0x888f, 0x23386e },
	{ 0x8890, 0x233874 },
	{ 0x8891, 0x22393b },
	{ 0x8892, 0x215d38 },
	{ 0x8893, 0x223946 },
	{ 0x8894, 0x23386c },
	{ 0x8895, 0x223936 },
	{ 0x8896, 0x215d39 },
	{ 0x8897, 0x223942 },
	{ 0x8898, 0x22393e },
	{ 0x8899, 0x223940 },
	{ 0x889a, 0x22393a },
	{ 0x889b, 0x223941 },
	{ 0x889c, 0x23386b },
	{ 0x889d, 0x24352f },
	{ 0x889e, 0x215d35 },
	{ 0x889f, 0x22393d },
	{ 0x88a0, 0x233873 },
	{ 0x88a1, 0x22393c },
	{ 0x88a2, 0x223938 },
	{ 0x88a3, 0x23386d },
	{ 0x88a4, 0x223943 },
	{ 0x88a5, 0x23386f },
	{ 0x88a6, 0x233871 },
	{ 0x88a7, 0x22393f },
	{ 0x88a8, 0x223937 },
	{ 0x88a9, 0x233870 },
	{ 0x88aa, 0x223939 },
	{ 0x88ab, 0x215d37 },
	{ 0x88ac, 0x223944 },
	{ 0x88b1, 0x21617c },
	{ 0x88b2, 0x224033 },
	{ 0x88b3, 0x243a7b },
	{ 0x88b4, 0x233e70 },
	{ 0x88b5, 0x233e72 },
	{ 0x88b6, 0x22402f },
	{ 0x88b7, 0x224031 },
	{ 0x88b8, 0x22402c },
	{ 0x88b9, 0x22402b },
	{ 0x88ba, 0x224029 },
	{ 0x88bb, 0x233e6d },
	{ 0x88bc, 0x224030 },
	{ 0x88bd, 0x224032 },
	{ 0x88be, 0x22402e },
	{ 0x88bf, 0x233e6f },
	{ 0x88c0, 0x22402d },
	{ 0x88c1, 0x21617a },
	{ 0x88c2, 0x21617b },
	{ 0x88c9, 0x224035 },
	{ 0x88ca, 0x216654 },
	{ 0x88cb, 0x224739 },
	{ 0x88cc, 0x22473f },
	{ 0x88cd, 0x22473a },
	{ 0x88ce, 0x22473b },
	{ 0x88cf, 0x23444e },
	{ 0x88d0, 0x224740 },
	{ 0x88d1, 0x25426c },
	{ 0x88d2, 0x216656 },
	{ 0x88d3, 0x244061 },
	{ 0x88d4, 0x21664e },
	{ 0x88d5, 0x216655 },
	{ 0x88d6, 0x224738 },
	{ 0x88d7, 0x22402a },
	{ 0x88d8, 0x216651 },
	{ 0x88d9, 0x21664f },
	{ 0x88da, 0x22473e },
	{ 0x88db, 0x22473d },
	{ 0x88dc, 0x216650 },
	{ 0x88dd, 0x216652 },
	{ 0x88de, 0x22473c },
	{ 0x88df, 0x21664d },
	{ 0x88e0, 0x23444f },
	{ 0x88e1, 0x216653 },
	{ 0x88e6, 0x234e60 },
	{ 0x88e7, 0x224d7d },
	{ 0x88e8, 0x216a7c },
	{ 0x88e9, 0x234959 },
	{ 0x88ea, 0x234952 },
	{ 0x88eb, 0x224e2a },
	{ 0x88ec, 0x224e29 },
	{ 0x88ed, 0x234957 },
	{ 0x88ee, 0x224e24 },
	{ 0x88ef, 0x216a7e },
	{ 0x88f0, 0x224e28 },
	{ 0x88f1, 0x224d7e },
	{ 0x88f2, 0x224e21 },
	{ 0x88f3, 0x216a76 },
	{ 0x88f4, 0x216a78 },
	{ 0x88f5, 0x234954 },
	{ 0x88f6, 0x224e26 },
	{ 0x88f7, 0x224d7c },
	{ 0x88f8, 0x216a7a },
	{ 0x88f9, 0x216a79 },
	{ 0x88fa, 0x224e22 },
	{ 0x88fb, 0x224e27 },
	{ 0x88fc, 0x224e25 },
	{ 0x88fd, 0x216a7b },
	{ 0x88fe, 0x224e23 },
	{ 0x88ff, 0x234951 },
	{ 0x8900, 0x234956 },
	{ 0x8901, 0x224034 },
	{ 0x8902, 0x216a77 },
	{ 0x8903, 0x234958 },
	{ 0x8905, 0x22542b },
	{ 0x8906, 0x225432 },
	{ 0x8907, 0x216e6f },
	{ 0x8908, 0x244d46 },
	{ 0x8909, 0x225436 },
	{ 0x890a, 0x216e73 },
	{ 0x890b, 0x22542e },
	{ 0x890c, 0x22542c },
	{ 0x890d, 0x244d3e },
	{ 0x890e, 0x225435 },
	{ 0x890f, 0x234e61 },
	{ 0x8910, 0x216e6e },
	{ 0x8911, 0x225434 },
	{ 0x8912, 0x216e70 },
	{ 0x8913, 0x216e71 },
	{ 0x8914, 0x22542d },
	{ 0x8915, 0x216e72 },
	{ 0x8916, 0x225433 },
	{ 0x8917, 0x22542f },
	{ 0x8918, 0x225430 },
	{ 0x8919, 0x225431 },
	{ 0x891a, 0x216a7d },
	{ 0x891b, 0x234e62 },
	{ 0x891e, 0x225a3e },
	{ 0x891f, 0x225a4a },
	{ 0x8920, 0x245353 },
	{ 0x8921, 0x217234 },
	{ 0x8922, 0x225a45 },
	{ 0x8923, 0x225a47 },
	{ 0x8924, 0x235265 },
	{ 0x8925, 0x217232 },
	{ 0x8926, 0x225a3f },
	{ 0x8927, 0x225a43 },
	{ 0x8928, 0x245350 },
	{ 0x8929, 0x225a46 },
	{ 0x892a, 0x217230 },
	{ 0x892b, 0x217233 },
	{ 0x892c, 0x225a49 },
	{ 0x892d, 0x225a41 },
	{ 0x892e, 0x225a42 },
	{ 0x892f, 0x225a48 },
	{ 0x8930, 0x225a40 },
	{ 0x8931, 0x225a44 },
	{ 0x8932, 0x217231 },
	{ 0x8933, 0x225f40 },
	{ 0x8935, 0x225f3f },
	{ 0x8936, 0x217542 },
	{ 0x8937, 0x225f45 },
	{ 0x8938, 0x217544 },
	{ 0x8939, 0x235640 },
	{ 0x893a, 0x245862 },
	{ 0x893b, 0x217541 },
	{ 0x893c, 0x225f41 },
	{ 0x893d, 0x217545 },
	{ 0x893e, 0x225f42 },
	{ 0x893f, 0x23563f },
	{ 0x8940, 0x23563d },
	{ 0x8941, 0x225f43 },
	{ 0x8942, 0x225f46 },
	{ 0x8943, 0x235642 },
	{ 0x8944, 0x217543 },
	{ 0x8946, 0x226341 },
	{ 0x8948, 0x235879 },
	{ 0x8949, 0x226344 },
	{ 0x894a, 0x23587a },
	{ 0x894b, 0x22633e },
	{ 0x894c, 0x226340 },
	{ 0x894d, 0x23587c },
	{ 0x894e, 0x23587b },
	{ 0x894f, 0x22633f },
	{ 0x8950, 0x226342 },
	{ 0x8951, 0x226343 },
	{ 0x8952, 0x225f44 },
	{ 0x8953, 0x22633d },
	{ 0x8954, 0x23664a },
	{ 0x8956, 0x217878 },
	{ 0x8957, 0x226677 },
	{ 0x8958, 0x22667a },
	{ 0x8959, 0x22667c },
	{ 0x895a, 0x226675 },
	{ 0x895b, 0x226676 },
	{ 0x895c, 0x226679 },
	{ 0x895d, 0x22667b },
	{ 0x895e, 0x217879 },
	{ 0x895f, 0x217877 },
	{ 0x8960, 0x217876 },
	{ 0x8961, 0x226678 },
	{ 0x8962, 0x226674 },
	{ 0x8963, 0x226976 },
	{ 0x8964, 0x217a3b },
	{ 0x8965, 0x235d29 },
	{ 0x8966, 0x226977 },
	{ 0x8967, 0x235d28 },
	{ 0x8969, 0x226c38 },
	{ 0x896a, 0x217b28 },
	{ 0x896b, 0x226c3a },
	{ 0x896c, 0x217b29 },
	{ 0x896d, 0x226c37 },
	{ 0x896e, 0x226c39 },
	{ 0x896f, 0x217b72 },
	{ 0x8970, 0x257438 },
	{ 0x8971, 0x226e21 },
	{ 0x8972, 0x217b71 },
	{ 0x8973, 0x226f4c },
	{ 0x8974, 0x226f4b },
	{ 0x8975, 0x246c25 },
	{ 0x8976, 0x226f4a },
	{ 0x8977, 0x2f684a },
	{ 0x8978, 0x236149 },
	{ 0x8979, 0x227137 },
	{ 0x897a, 0x227138 },
	{ 0x897b, 0x22713a },
	{ 0x897c, 0x227139 },
	{ 0x897d, 0x23617d },
	{ 0x897e, 0x222270 },
	{ 0x897f, 0x214869 },
	{ 0x8981, 0x215351 },
	{ 0x8982, 0x223948 },
	{ 0x8983, 0x21617d },
	{ 0x8984, 0x23664b },
	{ 0x8985, 0x224741 },
	{ 0x8986, 0x21773b },
	{ 0x8987, 0x235b2f },
	{ 0x8988, 0x22667d },
	{ 0x8989, 0x236046 },
	{ 0x898a, 0x23614a },
	{ 0x898b, 0x214b44 },
	{ 0x898c, 0x232f29 },
	{ 0x898d, 0x242f76 },
	{ 0x898e, 0x242f75 },
	{ 0x898f, 0x215d3d },
	{ 0x8990, 0x243534 },
	{ 0x8991, 0x233876 },
	{ 0x8992, 0x233875 },
	{ 0x8993, 0x215d3c },
	{ 0x8994, 0x233877 },
	{ 0x8995, 0x224036 },
	{ 0x8996, 0x21617e },
	{ 0x8997, 0x224038 },
	{ 0x8998, 0x224037 },
	{ 0x8999, 0x264e60 },
	{ 0x899a, 0x233e74 },
	{ 0x899b, 0x224742 },
	{ 0x899c, 0x216657 },
	{ 0x899d, 0x224e2b },
	{ 0x899e, 0x224e2e },
	{ 0x899f, 0x224e2d },
	{ 0x89a0, 0x244735 },
	{ 0x89a1, 0x224e2c },
	{ 0x89a2, 0x225437 },
	{ 0x89a3, 0x225439 },
	{ 0x89a4, 0x225438 },
	{ 0x89a5, 0x234e65 },
	{ 0x89a6, 0x217236 },
	{ 0x89a7, 0x235266 },
	{ 0x89a8, 0x245359 },
	{ 0x89a9, 0x234e64 },
	{ 0x89aa, 0x217235 },
	{ 0x89ab, 0x235646 },
	{ 0x89ac, 0x217546 },
	{ 0x89ad, 0x225f47 },
	{ 0x89ae, 0x225f49 },
	{ 0x89af, 0x225f48 },
	{ 0x89b0, 0x23587e },
	{ 0x89b1, 0x23587d },
	{ 0x89b2, 0x21773c },
	{ 0x89b3, 0x235921 },
	{ 0x89b4, 0x24612f },
	{ 0x89b5, 0x235b31 },
	{ 0x89b6, 0x226721 },
	{ 0x89b7, 0x22667e },
	{ 0x89b8, 0x2f6377 },
	{ 0x89b9, 0x226978 },
	{ 0x89ba, 0x217a3c },
	{ 0x89bb, 0x235d2a },
	{ 0x89bc, 0x235e61 },
	{ 0x89bd, 0x217b2a },
	{ 0x89be, 0x226e23 },
	{ 0x89bf, 0x226e22 },
	{ 0x89c0, 0x217d28 },
	{ 0x89d2, 0x214b45 },
	{ 0x89d3, 0x222d50 },
	{ 0x89d4, 0x215352 },
	{ 0x89d5, 0x22394b },
	{ 0x89d6, 0x223949 },
	{ 0x89d7, 0x243539 },
	{ 0x89d8, 0x243538 },
	{ 0x89d9, 0x22394a },
	{ 0x89da, 0x22403a },
	{ 0x89db, 0x22403b },
	{ 0x89dc, 0x224749 },
	{ 0x89dd, 0x224039 },
	{ 0x89df, 0x224743 },
	{ 0x89e0, 0x224747 },
	{ 0x89e1, 0x224746 },
	{ 0x89e2, 0x224748 },
	{ 0x89e3, 0x216658 },
	{ 0x89e4, 0x224745 },
	{ 0x89e5, 0x224744 },
	{ 0x89e6, 0x22474a },
	{ 0x89e7, 0x234454 },
	{ 0x89e8, 0x224e31 },
	{ 0x89e9, 0x224e2f },
	{ 0x89ea, 0x23495c },
	{ 0x89eb, 0x224e30 },
	{ 0x89ec, 0x22543c },
	{ 0x89ed, 0x22543a },
	{ 0x89ee, 0x234e66 },
	{ 0x89f0, 0x22543b },
	{ 0x89f1, 0x225a4b },
	{ 0x89f2, 0x225f4a },
	{ 0x89f3, 0x225f4b },
	{ 0x89f4, 0x21773d },
	{ 0x89f5, 0x235b32 },
	{ 0x89f6, 0x226722 },
	{ 0x89f7, 0x226979 },
	{ 0x89f8, 0x217a3d },
	{ 0x89f9, 0x246137 },
	{ 0x89fa, 0x226c3b },
	{ 0x89fb, 0x226e24 },
	{ 0x89fc, 0x217b73 },
	{ 0x89fd, 0x246945 },
	{ 0x89fe, 0x226f4d },
	{ 0x89ff, 0x22713b },
	{ 0x8a00, 0x214b46 },
	{ 0x8a02, 0x215354 },
	{ 0x8a03, 0x215355 },
	{ 0x8a04, 0x222d51 },
	{ 0x8a05, 0x232f2a },
	{ 0x8a06, 0x232f2c },
	{ 0x8a07, 0x222d52 },
	{ 0x8a08, 0x215353 },
	{ 0x8a09, 0x242f7c },
	{ 0x8a0a, 0x215839 },
	{ 0x8a0b, 0x23337b },
	{ 0x8a0c, 0x215837 },
	{ 0x8a0d, 0x23337a },
	{ 0x8a0e, 0x215836 },
	{ 0x8a0f, 0x21583d },
	{ 0x8a10, 0x215835 },
	{ 0x8a11, 0x21583e },
	{ 0x8a12, 0x223321 },
	{ 0x8a13, 0x21583b },
	{ 0x8a14, 0x242f7d },
	{ 0x8a15, 0x215838 },
	{ 0x8a16, 0x21583c },
	{ 0x8a17, 0x21583a },
	{ 0x8a18, 0x215834 },
	{ 0x8a19, 0x23337c },
	{ 0x8a1b, 0x215d45 },
	{ 0x8a1c, 0x23387e },
	{ 0x8a1d, 0x215d3f },
	{ 0x8a1e, 0x22394f },
	{ 0x8a1f, 0x215d44 },
	{ 0x8a20, 0x233923 },
	{ 0x8a21, 0x233929 },
	{ 0x8a22, 0x215d46 },
	{ 0x8a23, 0x215d40 },
	{ 0x8a24, 0x264470 },
	{ 0x8a25, 0x215d41 },
	{ 0x8a26, 0x233879 },
	{ 0x8a27, 0x22394d },
	{ 0x8a28, 0x23387b },
	{ 0x8a29, 0x233925 },
	{ 0x8a2a, 0x215d3e },
	{ 0x8a2b, 0x233922 },
	{ 0x8a2c, 0x22394e },
	{ 0x8a2d, 0x215d43 },
	{ 0x8a2e, 0x24353d },
	{ 0x8a2f, 0x25355b },
	{ 0x8a30, 0x22394c },
	{ 0x8a31, 0x215d42 },
	{ 0x8a32, 0x23387a },
	{ 0x8a34, 0x21622b },
	{ 0x8a35, 0x233e7c },
	{ 0x8a36, 0x21622d },
	{ 0x8a37, 0x243b2f },
	{ 0x8a38, 0x233e7d },
	{ 0x8a39, 0x22403e },
	{ 0x8a3a, 0x21622c },
	{ 0x8a3b, 0x216221 },
	{ 0x8a3c, 0x216225 },
	{ 0x8a3d, 0x233f24 },
	{ 0x8a3e, 0x21666b },
	{ 0x8a3f, 0x22474f },
	{ 0x8a40, 0x224040 },
	{ 0x8a41, 0x216226 },
	{ 0x8a42, 0x233e7e },
	{ 0x8a43, 0x233e75 },
	{ 0x8a44, 0x224043 },
	{ 0x8a45, 0x224044 },
	{ 0x8a46, 0x21622a },
	{ 0x8a47, 0x243b30 },
	{ 0x8a48, 0x224046 },
	{ 0x8a49, 0x233f21 },
	{ 0x8a4a, 0x224048 },
	{ 0x8a4b, 0x233f23 },
	{ 0x8a4c, 0x224049 },
	{ 0x8a4d, 0x22403d },
	{ 0x8a4e, 0x22403c },
	{ 0x8a4f, 0x22404a },
	{ 0x8a50, 0x216229 },
	{ 0x8a51, 0x224047 },
	{ 0x8a52, 0x224045 },
	{ 0x8a53, 0x243b2c },
	{ 0x8a54, 0x216227 },
	{ 0x8a55, 0x216223 },
	{ 0x8a56, 0x21622e },
	{ 0x8a57, 0x224041 },
	{ 0x8a58, 0x224042 },
	{ 0x8a59, 0x22403f },
	{ 0x8a5a, 0x233e78 },
	{ 0x8a5b, 0x216228 },
	{ 0x8a5c, 0x243b31 },
	{ 0x8a5d, 0x233f22 },
	{ 0x8a5e, 0x216224 },
	{ 0x8a60, 0x216222 },
	{ 0x8a61, 0x22474e },
	{ 0x8a62, 0x216666 },
	{ 0x8a63, 0x216661 },
	{ 0x8a64, 0x234460 },
	{ 0x8a65, 0x234459 },
	{ 0x8a66, 0x21665c },
	{ 0x8a67, 0x234463 },
	{ 0x8a68, 0x21666c },
	{ 0x8a69, 0x21665d },
	{ 0x8a6a, 0x234455 },
	{ 0x8a6b, 0x216659 },
	{ 0x8a6c, 0x216668 },
	{ 0x8a6d, 0x216665 },
	{ 0x8a6e, 0x216667 },
	{ 0x8a6f, 0x234458 },
	{ 0x8a70, 0x21665e },
	{ 0x8a71, 0x216663 },
	{ 0x8a72, 0x21665a },
	{ 0x8a73, 0x21665b },
	{ 0x8a74, 0x224756 },
	{ 0x8a75, 0x224753 },
	{ 0x8a76, 0x22474b },
	{ 0x8a77, 0x224750 },
	{ 0x8a78, 0x23445b },
	{ 0x8a79, 0x216669 },
	{ 0x8a7a, 0x224757 },
	{ 0x8a7b, 0x21666a },
	{ 0x8a7c, 0x216660 },
	{ 0x8a7d, 0x23445c },
	{ 0x8a7e, 0x234461 },
	{ 0x8a7f, 0x22474d },
	{ 0x8a80, 0x234456 },
	{ 0x8a81, 0x224755 },
	{ 0x8a82, 0x224751 },
	{ 0x8a83, 0x224754 },
	{ 0x8a84, 0x224752 },
	{ 0x8a85, 0x216664 },
	{ 0x8a86, 0x22474c },
	{ 0x8a87, 0x21665f },
	{ 0x8a88, 0x23445d },
	{ 0x8a8b, 0x224e34 },
	{ 0x8a8c, 0x216b22 },
	{ 0x8a8d, 0x216b25 },
	{ 0x8a8e, 0x23495f },
	{ 0x8a8f, 0x224e36 },
	{ 0x8a90, 0x234964 },
	{ 0x8a91, 0x216b2d },
	{ 0x8a92, 0x224e35 },
	{ 0x8a93, 0x216b27 },
	{ 0x8a94, 0x234963 },
	{ 0x8a95, 0x216e78 },
	{ 0x8a96, 0x224e37 },
	{ 0x8a97, 0x244745 },
	{ 0x8a98, 0x216b2c },
	{ 0x8a99, 0x224e33 },
	{ 0x8a9a, 0x216b2e },
	{ 0x8a9b, 0x23495e },
	{ 0x8a9c, 0x234962 },
	{ 0x8a9d, 0x23496b },
	{ 0x8a9e, 0x216b23 },
	{ 0x8a9f, 0x234968 },
	{ 0x8aa0, 0x216662 },
	{ 0x8aa1, 0x216b26 },
	{ 0x8aa2, 0x234960 },
	{ 0x8aa3, 0x216b24 },
	{ 0x8aa4, 0x216b28 },
	{ 0x8aa5, 0x216b2a },
	{ 0x8aa6, 0x216b21 },
	{ 0x8aa7, 0x216b2f },
	{ 0x8aa8, 0x216b2b },
	{ 0x8aa9, 0x234965 },
	{ 0x8aaa, 0x216b29 },
	{ 0x8aab, 0x224e32 },
	{ 0x8aac, 0x234966 },
	{ 0x8aad, 0x2f4c41 },
	{ 0x8aaf, 0x234e74 },
	{ 0x8ab0, 0x216f21 },
	{ 0x8ab1, 0x234e67 },
	{ 0x8ab2, 0x216e7b },
	{ 0x8ab3, 0x234e72 },
	{ 0x8ab4, 0x234e70 },
	{ 0x8ab5, 0x234e6e },
	{ 0x8ab6, 0x216f24 },
	{ 0x8ab7, 0x234e6c },
	{ 0x8ab8, 0x22543f },
	{ 0x8ab9, 0x216f25 },
	{ 0x8aba, 0x22544b },
	{ 0x8abb, 0x225444 },
	{ 0x8abc, 0x216e74 },
	{ 0x8abd, 0x22544c },
	{ 0x8abe, 0x225446 },
	{ 0x8abf, 0x216e7e },
	{ 0x8ac0, 0x225447 },
	{ 0x8ac1, 0x234e73 },
	{ 0x8ac2, 0x216e7d },
	{ 0x8ac3, 0x22544a },
	{ 0x8ac4, 0x216e77 },
	{ 0x8ac5, 0x225448 },
	{ 0x8ac6, 0x22543e },
	{ 0x8ac7, 0x216e76 },
	{ 0x8ac8, 0x225a56 },
	{ 0x8ac9, 0x216e7c },
	{ 0x8aca, 0x234e75 },
	{ 0x8acb, 0x216e79 },
	{ 0x8acc, 0x234e69 },
	{ 0x8acd, 0x216f23 },
	{ 0x8ace, 0x234e6a },
	{ 0x8acf, 0x22543d },
	{ 0x8ad0, 0x234e76 },
	{ 0x8ad1, 0x225441 },
	{ 0x8ad2, 0x216e75 },
	{ 0x8ad3, 0x225440 },
	{ 0x8ad4, 0x225442 },
	{ 0x8ad5, 0x225443 },
	{ 0x8ad6, 0x216f22 },
	{ 0x8ad7, 0x225445 },
	{ 0x8ad8, 0x225449 },
	{ 0x8ad9, 0x22544d },
	{ 0x8adb, 0x216f26 },
	{ 0x8adc, 0x21723c },
	{ 0x8add, 0x225a51 },
	{ 0x8ade, 0x225a57 },
	{ 0x8adf, 0x225a54 },
	{ 0x8ae0, 0x225a4c },
	{ 0x8ae1, 0x225a58 },
	{ 0x8ae2, 0x225a4d },
	{ 0x8ae3, 0x23526a },
	{ 0x8ae4, 0x225a53 },
	{ 0x8ae5, 0x23526b },
	{ 0x8ae6, 0x217237 },
	{ 0x8ae7, 0x21723d },
	{ 0x8ae8, 0x225a59 },
	{ 0x8ae9, 0x234e6f },
	{ 0x8aea, 0x235267 },
	{ 0x8aeb, 0x217239 },
	{ 0x8aec, 0x23526e },
	{ 0x8aed, 0x217243 },
	{ 0x8aee, 0x21723e },
	{ 0x8aef, 0x225a5b },
	{ 0x8af0, 0x225a55 },
	{ 0x8af1, 0x21723a },
	{ 0x8af2, 0x225a4e },
	{ 0x8af3, 0x217244 },
	{ 0x8af4, 0x225a4f },
	{ 0x8af5, 0x225a50 },
	{ 0x8af6, 0x217245 },
	{ 0x8af7, 0x217242 },
	{ 0x8af8, 0x216e7a },
	{ 0x8af9, 0x235269 },
	{ 0x8afa, 0x217238 },
	{ 0x8afb, 0x225a5c },
	{ 0x8afc, 0x217246 },
	{ 0x8afd, 0x235268 },
	{ 0x8afe, 0x21723f },
	{ 0x8aff, 0x225a5a },
	{ 0x8b00, 0x21723b },
	{ 0x8b01, 0x217240 },
	{ 0x8b02, 0x217241 },
	{ 0x8b03, 0x23664c },
	{ 0x8b04, 0x21754e },
	{ 0x8b05, 0x225f50 },
	{ 0x8b06, 0x225f59 },
	{ 0x8b07, 0x225f56 },
	{ 0x8b08, 0x225f58 },
	{ 0x8b09, 0x235649 },
	{ 0x8b0a, 0x21754b },
	{ 0x8b0b, 0x225f51 },
	{ 0x8b0c, 0x23564a },
	{ 0x8b0d, 0x225f57 },
	{ 0x8b0e, 0x217547 },
	{ 0x8b0f, 0x225f53 },
	{ 0x8b10, 0x21754f },
	{ 0x8b11, 0x225f4f },
	{ 0x8b12, 0x225f54 },
	{ 0x8b13, 0x225f5b },
	{ 0x8b14, 0x225a52 },
	{ 0x8b15, 0x225f55 },
	{ 0x8b16, 0x225f4e },
	{ 0x8b17, 0x217548 },
	{ 0x8b18, 0x225f4d },
	{ 0x8b19, 0x217549 },
	{ 0x8b1a, 0x225f5c },
	{ 0x8b1b, 0x21754a },
	{ 0x8b1c, 0x225f5a },
	{ 0x8b1d, 0x21754d },
	{ 0x8b1e, 0x225f4c },
	{ 0x8b1f, 0x235648 },
	{ 0x8b20, 0x21754c },
	{ 0x8b22, 0x225f52 },
	{ 0x8b23, 0x226347 },
	{ 0x8b24, 0x226355 },
	{ 0x8b25, 0x226350 },
	{ 0x8b26, 0x226352 },
	{ 0x8b27, 0x226346 },
	{ 0x8b28, 0x21773e },
	{ 0x8b29, 0x23592a },
	{ 0x8b2a, 0x226345 },
	{ 0x8b2b, 0x217741 },
	{ 0x8b2c, 0x217740 },
	{ 0x8b2d, 0x235926 },
	{ 0x8b2e, 0x226354 },
	{ 0x8b2f, 0x22634c },
	{ 0x8b30, 0x226349 },
	{ 0x8b31, 0x22634f },
	{ 0x8b32, 0x235924 },
	{ 0x8b33, 0x226348 },
	{ 0x8b34, 0x235928 },
	{ 0x8b35, 0x22634a },
	{ 0x8b36, 0x226353 },
	{ 0x8b37, 0x226351 },
	{ 0x8b38, 0x235923 },
	{ 0x8b39, 0x21773f },
	{ 0x8b3a, 0x226358 },
	{ 0x8b3b, 0x226356 },
	{ 0x8b3c, 0x22634d },
	{ 0x8b3d, 0x226357 },
	{ 0x8b3e, 0x22634e },
	{ 0x8b3f, 0x235b34 },
	{ 0x8b40, 0x226726 },
	{ 0x8b41, 0x21787a },
	{ 0x8b42, 0x22672d },
	{ 0x8b43, 0x235b35 },
	{ 0x8b44, 0x24613a },
	{ 0x8b45, 0x226c3e },
	{ 0x8b46, 0x217923 },
	{ 0x8b47, 0x22634b },
	{ 0x8b48, 0x226724 },
	{ 0x8b49, 0x21787d },
	{ 0x8b4a, 0x226725 },
	{ 0x8b4b, 0x22672a },
	{ 0x8b4c, 0x235b36 },
	{ 0x8b4d, 0x235d33 },
	{ 0x8b4e, 0x217921 },
	{ 0x8b4f, 0x217922 },
	{ 0x8b50, 0x226723 },
	{ 0x8b51, 0x22672c },
	{ 0x8b52, 0x22672e },
	{ 0x8b53, 0x226727 },
	{ 0x8b54, 0x226729 },
	{ 0x8b55, 0x22672b },
	{ 0x8b56, 0x226728 },
	{ 0x8b57, 0x22672f },
	{ 0x8b58, 0x21787c },
	{ 0x8b59, 0x217924 },
	{ 0x8b5a, 0x21787e },
	{ 0x8b5c, 0x21787b },
	{ 0x8b5d, 0x22697c },
	{ 0x8b5e, 0x24644d },
	{ 0x8b5f, 0x217a42 },
	{ 0x8b60, 0x22697a },
	{ 0x8b61, 0x235d30 },
	{ 0x8b62, 0x235d2c },
	{ 0x8b63, 0x22697e },
	{ 0x8b64, 0x235d32 },
	{ 0x8b65, 0x226a21 },
	{ 0x8b66, 0x217a40 },
	{ 0x8b67, 0x226a22 },
	{ 0x8b68, 0x22697d },
	{ 0x8b69, 0x235d2b },
	{ 0x8b6a, 0x22697b },
	{ 0x8b6b, 0x217a43 },
	{ 0x8b6c, 0x217a3f },
	{ 0x8b6d, 0x226a23 },
	{ 0x8b6e, 0x235d2e },
	{ 0x8b6f, 0x217a41 },
	{ 0x8b70, 0x217a3e },
	{ 0x8b71, 0x235c6d },
	{ 0x8b73, 0x24673b },
	{ 0x8b74, 0x217b2b },
	{ 0x8b75, 0x235e62 },
	{ 0x8b76, 0x246741 },
	{ 0x8b77, 0x217b2c },
	{ 0x8b78, 0x226c3d },
	{ 0x8b79, 0x226c3c },
	{ 0x8b7a, 0x226c3f },
	{ 0x8b7b, 0x226c40 },
	{ 0x8b7c, 0x235e63 },
	{ 0x8b7d, 0x217b2d },
	{ 0x8b7e, 0x226e25 },
	{ 0x8b7f, 0x226e2a },
	{ 0x8b80, 0x217b74 },
	{ 0x8b81, 0x235f61 },
	{ 0x8b82, 0x226e27 },
	{ 0x8b83, 0x235f62 },
	{ 0x8b84, 0x226e26 },
	{ 0x8b85, 0x226e29 },
	{ 0x8b86, 0x226e28 },
	{ 0x8b87, 0x236048 },
	{ 0x8b88, 0x226f51 },
	{ 0x8b89, 0x246a7c },
	{ 0x8b8a, 0x217c48 },
	{ 0x8b8b, 0x226f50 },
	{ 0x8b8c, 0x226f4e },
	{ 0x8b8d, 0x236047 },
	{ 0x8b8e, 0x226f4f },
	{ 0x8b90, 0x236049 },
	{ 0x8b91, 0x23607b },
	{ 0x8b92, 0x217c6a },
	{ 0x8b93, 0x217c69 },
	{ 0x8b94, 0x22704f },
	{ 0x8b95, 0x227050 },
	{ 0x8b96, 0x217c6b },
	{ 0x8b97, 0x23614b },
	{ 0x8b98, 0x22713c },
	{ 0x8b99, 0x22713d },
	{ 0x8b9a, 0x217d34 },
	{ 0x8b9b, 0x23616b },
	{ 0x8b9c, 0x217d3a },
	{ 0x8b9d, 0x23617e },
	{ 0x8b9e, 0x227177 },
	{ 0x8b9f, 0x227236 },
	{ 0x8c37, 0x214b47 },
	{ 0x8c38, 0x253046 },
	{ 0x8c39, 0x223950 },
	{ 0x8c3a, 0x23392a },
	{ 0x8c3b, 0x223951 },
	{ 0x8c3c, 0x224758 },
	{ 0x8c3d, 0x224e38 },
	{ 0x8c3e, 0x22544e },
	{ 0x8c3f, 0x217551 },
	{ 0x8c40, 0x23564d },
	{ 0x8c41, 0x217550 },
	{ 0x8c42, 0x226359 },
	{ 0x8c43, 0x226730 },
	{ 0x8c44, 0x235f64 },
	{ 0x8c45, 0x226f52 },
	{ 0x8c46, 0x214b48 },
	{ 0x8c47, 0x223322 },
	{ 0x8c48, 0x21583f },
	{ 0x8c49, 0x215d47 },
	{ 0x8c4a, 0x22475a },
	{ 0x8c4b, 0x224759 },
	{ 0x8c4c, 0x216f27 },
	{ 0x8c4d, 0x22544f },
	{ 0x8c4e, 0x216f28 },
	{ 0x8c4f, 0x225f5d },
	{ 0x8c50, 0x217742 },
	{ 0x8c51, 0x235d34 },
	{ 0x8c52, 0x23664d },
	{ 0x8c53, 0x236221 },
	{ 0x8c54, 0x217d43 },
	{ 0x8c55, 0x214b49 },
	{ 0x8c56, 0x22286b },
	{ 0x8c57, 0x223323 },
	{ 0x8c58, 0x23392d },
	{ 0x8c59, 0x24354d },
	{ 0x8c5a, 0x215d48 },
	{ 0x8c5b, 0x23392c },
	{ 0x8c5c, 0x223952 },
	{ 0x8c5d, 0x223953 },
	{ 0x8c5e, 0x233f2a },
	{ 0x8c5f, 0x22404b },
	{ 0x8c60, 0x233f29 },
	{ 0x8c61, 0x21622f },
	{ 0x8c62, 0x21666d },
	{ 0x8c63, 0x234464 },
	{ 0x8c64, 0x22475c },
	{ 0x8c65, 0x22475b },
	{ 0x8c66, 0x22475d },
	{ 0x8c67, 0x23496d },
	{ 0x8c68, 0x224e39 },
	{ 0x8c69, 0x224e3a },
	{ 0x8c6a, 0x216b30 },
	{ 0x8c6b, 0x217247 },
	{ 0x8c6c, 0x216f29 },
	{ 0x8c6d, 0x217248 },
	{ 0x8c6f, 0x225f61 },
	{ 0x8c70, 0x225f5e },
	{ 0x8c71, 0x225f60 },
	{ 0x8c72, 0x225f5f },
	{ 0x8c73, 0x217552 },
	{ 0x8c74, 0x23592b },
	{ 0x8c75, 0x22635a },
	{ 0x8c76, 0x226732 },
	{ 0x8c77, 0x226731 },
	{ 0x8c78, 0x222524 },
	{ 0x8c79, 0x215841 },
	{ 0x8c7a, 0x215840 },
	{ 0x8c7b, 0x223324 },
	{ 0x8c7c, 0x23392e },
	{ 0x8c7d, 0x223954 },
	{ 0x8c7e, 0x233f2c },
	{ 0x8c7f, 0x233f2b },
	{ 0x8c80, 0x22404d },
	{ 0x8c81, 0x22404c },
	{ 0x8c82, 0x216230 },
	{ 0x8c83, 0x233f2d },
	{ 0x8c84, 0x22475f },
	{ 0x8c85, 0x224760 },
	{ 0x8c86, 0x22475e },
	{ 0x8c87, 0x244078 },
	{ 0x8c88, 0x234465 },
	{ 0x8c89, 0x21666f },
	{ 0x8c8a, 0x21666e },
	{ 0x8c8b, 0x244754 },
	{ 0x8c8c, 0x216b32 },
	{ 0x8c8d, 0x216b31 },
	{ 0x8c8e, 0x234e7a },
	{ 0x8c8f, 0x225450 },
	{ 0x8c90, 0x225a5f },
	{ 0x8c91, 0x225a5d },
	{ 0x8c92, 0x225a5e },
	{ 0x8c93, 0x217249 },
	{ 0x8c94, 0x225f63 },
	{ 0x8c95, 0x225f62 },
	{ 0x8c96, 0x23564f },
	{ 0x8c97, 0x22635d },
	{ 0x8c98, 0x22635c },
	{ 0x8c99, 0x22635b },
	{ 0x8c9a, 0x226733 },
	{ 0x8c9b, 0x23614d },
	{ 0x8c9c, 0x227178 },
	{ 0x8c9d, 0x214b4a },
	{ 0x8c9e, 0x215356 },
	{ 0x8c9f, 0x232f2e },
	{ 0x8ca0, 0x215357 },
	{ 0x8ca1, 0x215842 },
	{ 0x8ca2, 0x215843 },
	{ 0x8ca3, 0x223326 },
	{ 0x8ca4, 0x223325 },
	{ 0x8ca5, 0x223955 },
	{ 0x8ca6, 0x233930 },
	{ 0x8ca7, 0x215d4e },
	{ 0x8ca8, 0x215d4c },
	{ 0x8ca9, 0x215d49 },
	{ 0x8caa, 0x215d4d },
	{ 0x8cab, 0x215d4b },
	{ 0x8cac, 0x215d4a },
	{ 0x8cad, 0x233932 },
	{ 0x8cae, 0x233931 },
	{ 0x8caf, 0x216231 },
	{ 0x8cb0, 0x224050 },
	{ 0x8cb1, 0x233f2f },
	{ 0x8cb2, 0x216674 },
	{ 0x8cb3, 0x216233 },
	{ 0x8cb4, 0x216238 },
	{ 0x8cb5, 0x224052 },
	{ 0x8cb6, 0x21623a },
	{ 0x8cb7, 0x216239 },
	{ 0x8cb8, 0x21623c },
	{ 0x8cb9, 0x224051 },
	{ 0x8cba, 0x22404e },
	{ 0x8cbb, 0x216236 },
	{ 0x8cbc, 0x216232 },
	{ 0x8cbd, 0x216234 },
	{ 0x8cbe, 0x22404f },
	{ 0x8cbf, 0x21623b },
	{ 0x8cc0, 0x216237 },
	{ 0x8cc1, 0x216235 },
	{ 0x8cc2, 0x216676 },
	{ 0x8cc3, 0x216675 },
	{ 0x8cc4, 0x216673 },
	{ 0x8cc5, 0x216677 },
	{ 0x8cc6, 0x24407e },
	{ 0x8cc7, 0x216671 },
	{ 0x8cc8, 0x216672 },
	{ 0x8cc9, 0x234469 },
	{ 0x8cca, 0x216670 },
	{ 0x8ccb, 0x25432d },
	{ 0x8ccc, 0x224761 },
	{ 0x8ccd, 0x234467 },
	{ 0x8ccf, 0x224e3c },
	{ 0x8cd0, 0x234970 },
	{ 0x8cd1, 0x216b34 },
	{ 0x8cd2, 0x216b35 },
	{ 0x8cd3, 0x216b33 },
	{ 0x8cd4, 0x234972 },
	{ 0x8cd5, 0x224e3b },
	{ 0x8cd6, 0x234971 },
	{ 0x8cd7, 0x224e3d },
	{ 0x8cd8, 0x23664e },
	{ 0x8cd9, 0x225453 },
	{ 0x8cda, 0x225455 },
	{ 0x8cdb, 0x234e7e },
	{ 0x8cdc, 0x216f32 },
	{ 0x8cdd, 0x225456 },
	{ 0x8cde, 0x216f2b },
	{ 0x8cdf, 0x225452 },
	{ 0x8ce0, 0x216f2a },
	{ 0x8ce1, 0x216f34 },
	{ 0x8ce2, 0x216f30 },
	{ 0x8ce3, 0x216f31 },
	{ 0x8ce4, 0x216f2d },
	{ 0x8ce5, 0x225451 },
	{ 0x8ce6, 0x216f2c },
	{ 0x8ce7, 0x225457 },
	{ 0x8ce8, 0x225454 },
	{ 0x8ce9, 0x234e7d },
	{ 0x8cea, 0x216f33 },
	{ 0x8ceb, 0x234f22 },
	{ 0x8cec, 0x216f2e },
	{ 0x8ced, 0x216f2f },
	{ 0x8cee, 0x225a61 },
	{ 0x8cef, 0x235275 },
	{ 0x8cf0, 0x225a63 },
	{ 0x8cf1, 0x225a62 },
	{ 0x8cf2, 0x235273 },
	{ 0x8cf3, 0x225a64 },
	{ 0x8cf4, 0x21724a },
	{ 0x8cf5, 0x225a60 },
	{ 0x8cf6, 0x235651 },
	{ 0x8cf7, 0x235652 },
	{ 0x8cf8, 0x217556 },
	{ 0x8cf9, 0x225f64 },
	{ 0x8cfa, 0x217553 },
	{ 0x8cfb, 0x217557 },
	{ 0x8cfc, 0x217555 },
	{ 0x8cfd, 0x217554 },
	{ 0x8cfe, 0x22635e },
	{ 0x8cff, 0x245d69 },
	{ 0x8d00, 0x226361 },
	{ 0x8d01, 0x274352 },
	{ 0x8d02, 0x226360 },
	{ 0x8d03, 0x23592e },
	{ 0x8d04, 0x22635f },
	{ 0x8d05, 0x217743 },
	{ 0x8d06, 0x226734 },
	{ 0x8d07, 0x226735 },
	{ 0x8d08, 0x217925 },
	{ 0x8d09, 0x226736 },
	{ 0x8d0a, 0x217926 },
	{ 0x8d0b, 0x235b38 },
	{ 0x8d0c, 0x23664f },
	{ 0x8d0d, 0x217a45 },
	{ 0x8d0e, 0x24644f },
	{ 0x8d0f, 0x217a44 },
	{ 0x8d10, 0x226c41 },
	{ 0x8d11, 0x235e65 },
	{ 0x8d12, 0x235e66 },
	{ 0x8d13, 0x217b2e },
	{ 0x8d14, 0x226c42 },
	{ 0x8d15, 0x226e2b },
	{ 0x8d16, 0x217b75 },
	{ 0x8d17, 0x217b76 },
	{ 0x8d18, 0x236650 },
	{ 0x8d19, 0x226f53 },
	{ 0x8d1a, 0x23604a },
	{ 0x8d1b, 0x217c6d },
	{ 0x8d1c, 0x23614e },
	{ 0x8d64, 0x214b4b },
	{ 0x8d65, 0x233933 },
	{ 0x8d66, 0x215d50 },
	{ 0x8d67, 0x215d4f },
	{ 0x8d68, 0x224762 },
	{ 0x8d69, 0x224763 },
	{ 0x8d6b, 0x216b36 },
	{ 0x8d6c, 0x225a65 },
	{ 0x8d6d, 0x216f35 },
	{ 0x8d6e, 0x225a66 },
	{ 0x8d6f, 0x225f65 },
	{ 0x8d70, 0x214b4c },
	{ 0x8d71, 0x23243a },
	{ 0x8d72, 0x222d53 },
	{ 0x8d73, 0x215359 },
	{ 0x8d74, 0x215358 },
	{ 0x8d76, 0x223327 },
	{ 0x8d77, 0x215844 },
	{ 0x8d78, 0x223328 },
	{ 0x8d79, 0x223958 },
	{ 0x8d7a, 0x233939 },
	{ 0x8d7b, 0x223957 },
	{ 0x8d7c, 0x233937 },
	{ 0x8d7d, 0x223956 },
	{ 0x8d7e, 0x233935 },
	{ 0x8d7f, 0x233938 },
	{ 0x8d80, 0x224054 },
	{ 0x8d81, 0x21623f },
	{ 0x8d82, 0x233f39 },
	{ 0x8d83, 0x233f34 },
	{ 0x8d84, 0x224053 },
	{ 0x8d85, 0x21623e },
	{ 0x8d86, 0x233f37 },
	{ 0x8d87, 0x233f30 },
	{ 0x8d88, 0x233f33 },
	{ 0x8d89, 0x224055 },
	{ 0x8d8a, 0x21623d },
	{ 0x8d8b, 0x233f38 },
	{ 0x8d8c, 0x224765 },
	{ 0x8d8d, 0x224768 },
	{ 0x8d8e, 0x224766 },
	{ 0x8d8f, 0x224767 },
	{ 0x8d90, 0x22476b },
	{ 0x8d91, 0x224764 },
	{ 0x8d92, 0x22476c },
	{ 0x8d93, 0x224769 },
	{ 0x8d94, 0x22476a },
	{ 0x8d95, 0x216b38 },
	{ 0x8d96, 0x224e3e },
	{ 0x8d97, 0x234975 },
	{ 0x8d98, 0x234973 },
	{ 0x8d99, 0x216b37 },
	{ 0x8d9a, 0x234974 },
	{ 0x8d9b, 0x22545b },
	{ 0x8d9c, 0x225459 },
	{ 0x8d9d, 0x234f26 },
	{ 0x8d9e, 0x244d75 },
	{ 0x8d9f, 0x216f36 },
	{ 0x8da0, 0x225458 },
	{ 0x8da1, 0x22545a },
	{ 0x8da2, 0x234f25 },
	{ 0x8da3, 0x216f37 },
	{ 0x8da4, 0x234f23 },
	{ 0x8da5, 0x225a67 },
	{ 0x8da6, 0x235277 },
	{ 0x8da7, 0x225a68 },
	{ 0x8da8, 0x217558 },
	{ 0x8da9, 0x235931 },
	{ 0x8daa, 0x226738 },
	{ 0x8dab, 0x22673a },
	{ 0x8dac, 0x226737 },
	{ 0x8dad, 0x226739 },
	{ 0x8dae, 0x226a24 },
	{ 0x8daf, 0x226c43 },
	{ 0x8db0, 0x236651 },
	{ 0x8db2, 0x22715e },
	{ 0x8db3, 0x214b4d },
	{ 0x8db4, 0x21535a },
	{ 0x8db5, 0x223329 },
	{ 0x8db6, 0x22332b },
	{ 0x8db7, 0x22332a },
	{ 0x8db9, 0x22395b },
	{ 0x8dba, 0x215d52 },
	{ 0x8dbb, 0x23393e },
	{ 0x8dbc, 0x223959 },
	{ 0x8dbd, 0x23393a },
	{ 0x8dbe, 0x215d51 },
	{ 0x8dbf, 0x22395c },
	{ 0x8dc0, 0x23393d },
	{ 0x8dc1, 0x22395d },
	{ 0x8dc2, 0x22395a },
	{ 0x8dc3, 0x264538 },
	{ 0x8dc5, 0x224061 },
	{ 0x8dc6, 0x216247 },
	{ 0x8dc7, 0x224059 },
	{ 0x8dc8, 0x22405f },
	{ 0x8dc9, 0x233f3f },
	{ 0x8dca, 0x233f3a },
	{ 0x8dcb, 0x216242 },
	{ 0x8dcc, 0x216245 },
	{ 0x8dcd, 0x224058 },
	{ 0x8dce, 0x216240 },
	{ 0x8dcf, 0x22405c },
	{ 0x8dd0, 0x224772 },
	{ 0x8dd1, 0x216244 },
	{ 0x8dd2, 0x233f3b },
	{ 0x8dd3, 0x224057 },
	{ 0x8dd4, 0x233f3e },
	{ 0x8dd5, 0x22405d },
	{ 0x8dd6, 0x22405a },
	{ 0x8dd7, 0x224060 },
	{ 0x8dd8, 0x224056 },
	{ 0x8dd9, 0x22405e },
	{ 0x8dda, 0x216243 },
	{ 0x8ddb, 0x216246 },
	{ 0x8ddc, 0x22405b },
	{ 0x8ddd, 0x216241 },
	{ 0x8ddf, 0x216679 },
	{ 0x8de0, 0x22476e },
	{ 0x8de1, 0x216678 },
	{ 0x8de2, 0x224775 },
	{ 0x8de3, 0x224774 },
	{ 0x8de4, 0x216721 },
	{ 0x8de6, 0x216722 },
	{ 0x8de7, 0x224776 },
	{ 0x8de8, 0x21667a },
	{ 0x8de9, 0x224773 },
	{ 0x8dea, 0x21667e },
	{ 0x8deb, 0x224778 },
	{ 0x8dec, 0x22476f },
	{ 0x8ded, 0x23446b },
	{ 0x8dee, 0x224771 },
	{ 0x8def, 0x21667b },
	{ 0x8df0, 0x22476d },
	{ 0x8df1, 0x224770 },
	{ 0x8df2, 0x224777 },
	{ 0x8df3, 0x21667c },
	{ 0x8df4, 0x224779 },
	{ 0x8dfa, 0x21667d },
	{ 0x8dfc, 0x216b39 },
	{ 0x8dfd, 0x224e43 },
	{ 0x8dfe, 0x224e49 },
	{ 0x8dff, 0x224e41 },
	{ 0x8e00, 0x224e4a },
	{ 0x8e01, 0x23497b },
	{ 0x8e02, 0x224e40 },
	{ 0x8e03, 0x224e45 },
	{ 0x8e04, 0x224e4b },
	{ 0x8e05, 0x224e48 },
	{ 0x8e06, 0x224e47 },
	{ 0x8e07, 0x224e46 },
	{ 0x8e08, 0x23497a },
	{ 0x8e09, 0x224e3f },
	{ 0x8e0a, 0x224e44 },
	{ 0x8e0b, 0x234979 },
	{ 0x8e0d, 0x224e42 },
	{ 0x8e0f, 0x216f3c },
	{ 0x8e10, 0x216f39 },
	{ 0x8e11, 0x225464 },
	{ 0x8e12, 0x225469 },
	{ 0x8e13, 0x22546b },
	{ 0x8e14, 0x225468 },
	{ 0x8e15, 0x225461 },
	{ 0x8e16, 0x225463 },
	{ 0x8e17, 0x22546d },
	{ 0x8e18, 0x22546a },
	{ 0x8e19, 0x225465 },
	{ 0x8e1a, 0x22546e },
	{ 0x8e1b, 0x225462 },
	{ 0x8e1c, 0x22546c },
	{ 0x8e1d, 0x216f3a },
	{ 0x8e1e, 0x216f40 },
	{ 0x8e1f, 0x216f3e },
	{ 0x8e20, 0x22545c },
	{ 0x8e21, 0x216f3f },
	{ 0x8e22, 0x216f3b },
	{ 0x8e23, 0x22545d },
	{ 0x8e24, 0x22545f },
	{ 0x8e25, 0x22545e },
	{ 0x8e26, 0x225466 },
	{ 0x8e27, 0x225467 },
	{ 0x8e28, 0x234f2c },
	{ 0x8e29, 0x216f3d },
	{ 0x8e2a, 0x234f2b },
	{ 0x8e2b, 0x216f38 },
	{ 0x8e2e, 0x225460 },
	{ 0x8e30, 0x225a72 },
	{ 0x8e31, 0x21724c },
	{ 0x8e32, 0x23527e },
	{ 0x8e33, 0x225a69 },
	{ 0x8e34, 0x21724d },
	{ 0x8e35, 0x217250 },
	{ 0x8e36, 0x225a6e },
	{ 0x8e37, 0x255148 },
	{ 0x8e38, 0x225a6b },
	{ 0x8e39, 0x21724f },
	{ 0x8e3a, 0x245429 },
	{ 0x8e3b, 0x23527b },
	{ 0x8e3c, 0x225a6f },
	{ 0x8e3d, 0x225a70 },
	{ 0x8e3e, 0x225a6a },
	{ 0x8e3f, 0x225a73 },
	{ 0x8e40, 0x225a6c },
	{ 0x8e41, 0x225a71 },
	{ 0x8e42, 0x21724e },
	{ 0x8e43, 0x23527c },
	{ 0x8e44, 0x21724b },
	{ 0x8e45, 0x225a6d },
	{ 0x8e46, 0x235654 },
	{ 0x8e47, 0x225f6b },
	{ 0x8e48, 0x21755b },
	{ 0x8e49, 0x217559 },
	{ 0x8e4a, 0x21755c },
	{ 0x8e4b, 0x21755a },
	{ 0x8e4c, 0x225f6a },
	{ 0x8e4d, 0x225f67 },
	{ 0x8e4e, 0x225f66 },
	{ 0x8e4f, 0x235655 },
	{ 0x8e50, 0x225f69 },
	{ 0x8e51, 0x24592d },
	{ 0x8e53, 0x225f68 },
	{ 0x8e54, 0x22636f },
	{ 0x8e55, 0x217749 },
	{ 0x8e56, 0x226366 },
	{ 0x8e57, 0x226365 },
	{ 0x8e58, 0x235932 },
	{ 0x8e59, 0x217744 },
	{ 0x8e5a, 0x22636b },
	{ 0x8e5b, 0x22636a },
	{ 0x8e5c, 0x226362 },
	{ 0x8e5d, 0x22636d },
	{ 0x8e5e, 0x226367 },
	{ 0x8e5f, 0x217748 },
	{ 0x8e60, 0x226364 },
	{ 0x8e61, 0x22636c },
	{ 0x8e62, 0x226363 },
	{ 0x8e63, 0x217745 },
	{ 0x8e64, 0x217747 },
	{ 0x8e65, 0x226368 },
	{ 0x8e66, 0x217746 },
	{ 0x8e67, 0x226369 },
	{ 0x8e68, 0x235b3a },
	{ 0x8e69, 0x22636e },
	{ 0x8e6a, 0x22673e },
	{ 0x8e6b, 0x235b39 },
	{ 0x8e6c, 0x21792b },
	{ 0x8e6d, 0x22673b },
	{ 0x8e6e, 0x246152 },
	{ 0x8e6f, 0x22673f },
	{ 0x8e70, 0x235b3b },
	{ 0x8e71, 0x24614f },
	{ 0x8e72, 0x217928 },
	{ 0x8e73, 0x22673d },
	{ 0x8e74, 0x21792d },
	{ 0x8e75, 0x235b3c },
	{ 0x8e76, 0x21792a },
	{ 0x8e77, 0x235b3d },
	{ 0x8e78, 0x22673c },
	{ 0x8e79, 0x246154 },
	{ 0x8e7a, 0x21792c },
	{ 0x8e7b, 0x226740 },
	{ 0x8e7c, 0x217927 },
	{ 0x8e81, 0x217a47 },
	{ 0x8e82, 0x217a49 },
	{ 0x8e83, 0x235d37 },
	{ 0x8e84, 0x226a27 },
	{ 0x8e85, 0x217a48 },
	{ 0x8e86, 0x226a25 },
	{ 0x8e87, 0x217929 },
	{ 0x8e88, 0x226a26 },
	{ 0x8e89, 0x217a46 },
	{ 0x8e8a, 0x217b2f },
	{ 0x8e8b, 0x217b31 },
	{ 0x8e8c, 0x226c45 },
	{ 0x8e8d, 0x217b30 },
	{ 0x8e8e, 0x226c44 },
	{ 0x8e90, 0x226e30 },
	{ 0x8e91, 0x217b77 },
	{ 0x8e92, 0x226e2f },
	{ 0x8e93, 0x217b78 },
	{ 0x8e94, 0x226e2d },
	{ 0x8e95, 0x226e2c },
	{ 0x8e96, 0x226e31 },
	{ 0x8e97, 0x226e32 },
	{ 0x8e98, 0x226f54 },
	{ 0x8e99, 0x23604b },
	{ 0x8e9a, 0x226e2e },
	{ 0x8e9d, 0x227054 },
	{ 0x8e9e, 0x227051 },
	{ 0x8e9f, 0x227052 },
	{ 0x8ea0, 0x227053 },
	{ 0x8ea1, 0x217d29 },
	{ 0x8ea2, 0x236150 },
	{ 0x8ea3, 0x227140 },
	{ 0x8ea4, 0x22713f },
	{ 0x8ea5, 0x22713e },
	{ 0x8ea6, 0x22715f },
	{ 0x8ea7, 0x23616c },
	{ 0x8ea8, 0x22722e },
	{ 0x8ea9, 0x227179 },
	{ 0x8eaa, 0x217d3b },
	{ 0x8eab, 0x214b4e },
	{ 0x8eac, 0x215845 },
	{ 0x8ead, 0x23393f },
	{ 0x8eae, 0x2f386c },
	{ 0x8eaf, 0x233940 },
	{ 0x8eb0, 0x233f40 },
	{ 0x8eb1, 0x234473 },
	{ 0x8eb2, 0x216723 },
	{ 0x8eb3, 0x23497d },
	{ 0x8eb4, 0x23497c },
	{ 0x8eb6, 0x234f30 },
	{ 0x8eb7, 0x234f32 },
	{ 0x8eb8, 0x234f2f },
	{ 0x8eb9, 0x234f31 },
	{ 0x8eba, 0x216f41 },
	{ 0x8ebc, 0x236652 },
	{ 0x8ebd, 0x225a74 },
	{ 0x8ebe, 0x2f5833 },
	{ 0x8ebf, 0x235935 },
	{ 0x8ec0, 0x21774a },
	{ 0x8ec1, 0x235936 },
	{ 0x8ec2, 0x226741 },
	{ 0x8ec3, 0x235b3f },
	{ 0x8ec4, 0x246156 },
	{ 0x8ec6, 0x235d38 },
	{ 0x8ec7, 0x246751 },
	{ 0x8ec9, 0x22717a },
	{ 0x8eca, 0x214b4f },
	{ 0x8ecb, 0x214f51 },
	{ 0x8ecc, 0x21535c },
	{ 0x8ecd, 0x21535b },
	{ 0x8ece, 0x253055 },
	{ 0x8ecf, 0x215848 },
	{ 0x8ed0, 0x233421 },
	{ 0x8ed1, 0x22332c },
	{ 0x8ed2, 0x215846 },
	{ 0x8ed3, 0x22332d },
	{ 0x8ed4, 0x215847 },
	{ 0x8ed5, 0x236653 },
	{ 0x8ed6, 0x233941 },
	{ 0x8ed7, 0x223962 },
	{ 0x8ed8, 0x22395e },
	{ 0x8ed9, 0x233947 },
	{ 0x8eda, 0x243563 },
	{ 0x8edb, 0x215d53 },
	{ 0x8edc, 0x223961 },
	{ 0x8edd, 0x223960 },
	{ 0x8ede, 0x22395f },
	{ 0x8edf, 0x215d54 },
	{ 0x8ee0, 0x223963 },
	{ 0x8ee1, 0x223964 },
	{ 0x8ee4, 0x233f45 },
	{ 0x8ee5, 0x224068 },
	{ 0x8ee6, 0x224066 },
	{ 0x8ee7, 0x22406a },
	{ 0x8ee8, 0x22406b },
	{ 0x8ee9, 0x224071 },
	{ 0x8eea, 0x233f47 },
	{ 0x8eeb, 0x22406d },
	{ 0x8eec, 0x22406f },
	{ 0x8eed, 0x254350 },
	{ 0x8eee, 0x224067 },
	{ 0x8eef, 0x224062 },
	{ 0x8ef0, 0x243b55 },
	{ 0x8ef1, 0x22406e },
	{ 0x8ef2, 0x233f44 },
	{ 0x8ef3, 0x233f46 },
	{ 0x8ef4, 0x224070 },
	{ 0x8ef5, 0x224069 },
	{ 0x8ef6, 0x22406c },
	{ 0x8ef7, 0x224063 },
	{ 0x8ef8, 0x216249 },
	{ 0x8ef9, 0x224065 },
	{ 0x8efa, 0x224064 },
	{ 0x8efb, 0x216248 },
	{ 0x8efc, 0x21624a },
	{ 0x8efd, 0x233f49 },
	{ 0x8efe, 0x216726 },
	{ 0x8eff, 0x22477b },
	{ 0x8f00, 0x22477d },
	{ 0x8f01, 0x22477c },
	{ 0x8f02, 0x224823 },
	{ 0x8f03, 0x216724 },
	{ 0x8f04, 0x234476 },
	{ 0x8f05, 0x22477e },
	{ 0x8f06, 0x22477a },
	{ 0x8f07, 0x224821 },
	{ 0x8f08, 0x224822 },
	{ 0x8f09, 0x216725 },
	{ 0x8f0a, 0x216727 },
	{ 0x8f0b, 0x224824 },
	{ 0x8f0d, 0x224e4f },
	{ 0x8f0e, 0x224e4e },
	{ 0x8f0f, 0x24476a },
	{ 0x8f10, 0x224e4c },
	{ 0x8f11, 0x224e4d },
	{ 0x8f12, 0x216b3b },
	{ 0x8f13, 0x216b3d },
	{ 0x8f14, 0x216b3a },
	{ 0x8f15, 0x216b3c },
	{ 0x8f16, 0x225475 },
	{ 0x8f17, 0x225476 },
	{ 0x8f18, 0x225471 },
	{ 0x8f19, 0x234f36 },
	{ 0x8f1a, 0x225472 },
	{ 0x8f1b, 0x216f43 },
	{ 0x8f1c, 0x216f48 },
	{ 0x8f1d, 0x216f42 },
	{ 0x8f1e, 0x216f49 },
	{ 0x8f1f, 0x216f44 },
	{ 0x8f20, 0x225473 },
	{ 0x8f21, 0x244e2d },
	{ 0x8f22, 0x234f33 },
	{ 0x8f23, 0x225474 },
	{ 0x8f24, 0x225470 },
	{ 0x8f25, 0x216f4a },
	{ 0x8f26, 0x216f46 },
	{ 0x8f27, 0x234f35 },
	{ 0x8f28, 0x244e2b },
	{ 0x8f29, 0x216f45 },
	{ 0x8f2a, 0x216f47 },
	{ 0x8f2b, 0x234f34 },
	{ 0x8f2c, 0x22546f },
	{ 0x8f2d, 0x235324 },
	{ 0x8f2e, 0x225a76 },
	{ 0x8f2f, 0x217252 },
	{ 0x8f30, 0x235322 },
	{ 0x8f31, 0x235321 },
	{ 0x8f32, 0x225a78 },
	{ 0x8f33, 0x217254 },
	{ 0x8f34, 0x225a7b },
	{ 0x8f35, 0x225a77 },
	{ 0x8f36, 0x225a75 },
	{ 0x8f37, 0x225a7a },
	{ 0x8f38, 0x217253 },
	{ 0x8f39, 0x225a79 },
	{ 0x8f3a, 0x273432 },
	{ 0x8f3b, 0x217251 },
	{ 0x8f3c, 0x235325 },
	{ 0x8f3d, 0x235659 },
	{ 0x8f3e, 0x21755e },
	{ 0x8f3f, 0x217561 },
	{ 0x8f40, 0x225f6d },
	{ 0x8f41, 0x23565a },
	{ 0x8f42, 0x21755f },
	{ 0x8f43, 0x225f6c },
	{ 0x8f44, 0x21755d },
	{ 0x8f45, 0x217560 },
	{ 0x8f46, 0x226370 },
	{ 0x8f47, 0x226371 },
	{ 0x8f48, 0x226372 },
	{ 0x8f49, 0x21774b },
	{ 0x8f4a, 0x235937 },
	{ 0x8f4b, 0x226373 },
	{ 0x8f4d, 0x21774c },
	{ 0x8f4e, 0x21792f },
	{ 0x8f4f, 0x226744 },
	{ 0x8f50, 0x226745 },
	{ 0x8f51, 0x226743 },
	{ 0x8f52, 0x226742 },
	{ 0x8f53, 0x226746 },
	{ 0x8f54, 0x21792e },
	{ 0x8f55, 0x226a2b },
	{ 0x8f56, 0x226a29 },
	{ 0x8f57, 0x226a2a },
	{ 0x8f58, 0x226a2c },
	{ 0x8f59, 0x226a28 },
	{ 0x8f5a, 0x226a2d },
	{ 0x8f5b, 0x226c47 },
	{ 0x8f5c, 0x235e67 },
	{ 0x8f5d, 0x226c48 },
	{ 0x8f5e, 0x226c46 },
	{ 0x8f5f, 0x217b32 },
	{ 0x8f60, 0x226e33 },
	{ 0x8f61, 0x217b79 },
	{ 0x8f62, 0x226e34 },
	{ 0x8f63, 0x226f56 },
	{ 0x8f64, 0x226f55 },
	{ 0x8f65, 0x236222 },
	{ 0x8f9b, 0x214b50 },
	{ 0x8f9c, 0x21624b },
	{ 0x8f9d, 0x233f4b },
	{ 0x8f9e, 0x234477 },
	{ 0x8f9f, 0x216728 },
	{ 0x8fa0, 0x234478 },
	{ 0x8fa1, 0x234a21 },
	{ 0x8fa2, 0x234a22 },
	{ 0x8fa3, 0x216b3e },
	{ 0x8fa4, 0x234f37 },
	{ 0x8fa5, 0x235327 },
	{ 0x8fa6, 0x217256 },
	{ 0x8fa7, 0x235326 },
	{ 0x8fa8, 0x217255 },
	{ 0x8faa, 0x236654 },
	{ 0x8fac, 0x235938 },
	{ 0x8fad, 0x217930 },
	{ 0x8fae, 0x217a29 },
	{ 0x8faf, 0x217b33 },
	{ 0x8fb0, 0x214b51 },
	{ 0x8fb1, 0x215849 },
	{ 0x8fb2, 0x216729 },
	{ 0x8fb3, 0x234f39 },
	{ 0x8fb4, 0x226747 },
	{ 0x8fb5, 0x23272f },
	{ 0x8fb6, 0x242154 },
	{ 0x8fb7, 0x2f216a },
	{ 0x8fb8, 0x242330 },
	{ 0x8fb9, 0x23243b },
	{ 0x8fbb, 0x2f2271 },
	{ 0x8fbc, 0x2f2272 },
	{ 0x8fbe, 0x232730 },
	{ 0x8fbf, 0x222526 },
	{ 0x8fc0, 0x242521 },
	{ 0x8fc1, 0x232733 },
	{ 0x8fc2, 0x214b52 },
	{ 0x8fc3, 0x242523 },
	{ 0x8fc4, 0x214b55 },
	{ 0x8fc5, 0x214b54 },
	{ 0x8fc6, 0x214b53 },
	{ 0x8fc7, 0x232731 },
	{ 0x8fc8, 0x2f2532 },
	{ 0x8fc9, 0x222525 },
	{ 0x8fca, 0x232a72 },
	{ 0x8fcb, 0x22286d },
	{ 0x8fcc, 0x232a70 },
	{ 0x8fcd, 0x22286f },
	{ 0x8fce, 0x214f52 },
	{ 0x8fcf, 0x232a74 },
	{ 0x8fd0, 0x242826 },
	{ 0x8fd1, 0x214f54 },
	{ 0x8fd2, 0x22286c },
	{ 0x8fd3, 0x22286e },
	{ 0x8fd4, 0x214f53 },
	{ 0x8fd5, 0x222871 },
	{ 0x8fd6, 0x222870 },
	{ 0x8fd7, 0x222872 },
	{ 0x8fd8, 0x232a73 },
	{ 0x8fd9, 0x232a71 },
	{ 0x8fdc, 0x2f2871 },
	{ 0x8fdf, 0x2f286e },
	{ 0x8fe0, 0x222d57 },
	{ 0x8fe1, 0x222d55 },
	{ 0x8fe2, 0x21535f },
	{ 0x8fe3, 0x222d54 },
	{ 0x8fe4, 0x215364 },
	{ 0x8fe5, 0x215361 },
	{ 0x8fe6, 0x21535e },
	{ 0x8fe7, 0x232f31 },
	{ 0x8fe8, 0x215365 },
	{ 0x8fe9, 0x232f32 },
	{ 0x8fea, 0x215360 },
	{ 0x8feb, 0x215363 },
	{ 0x8fec, 0x263460 },
	{ 0x8fed, 0x215362 },
	{ 0x8fee, 0x222d56 },
	{ 0x8fef, 0x232f33 },
	{ 0x8ff0, 0x21535d },
	{ 0x8ff1, 0x232f30 },
	{ 0x8ff4, 0x21584f },
	{ 0x8ff5, 0x22332f },
	{ 0x8ff6, 0x223335 },
	{ 0x8ff7, 0x21584c },
	{ 0x8ff8, 0x215853 },
	{ 0x8ff9, 0x233425 },
	{ 0x8ffa, 0x21584e },
	{ 0x8ffb, 0x223332 },
	{ 0x8ffc, 0x223334 },
	{ 0x8ffd, 0x215851 },
	{ 0x8ffe, 0x22332e },
	{ 0x8fff, 0x223331 },
	{ 0x9000, 0x21584d },
	{ 0x9001, 0x21584a },
	{ 0x9002, 0x223330 },
	{ 0x9003, 0x215850 },
	{ 0x9004, 0x223333 },
	{ 0x9005, 0x215852 },
	{ 0x9006, 0x21584b },
	{ 0x9007, 0x24302f },
	{ 0x9008, 0x233427 },
	{ 0x9009, 0x233426 },
	{ 0x900b, 0x223966 },
	{ 0x900c, 0x223969 },
	{ 0x900d, 0x215d56 },
	{ 0x900e, 0x23394b },
	{ 0x900f, 0x215d60 },
	{ 0x9010, 0x215d5c },
	{ 0x9011, 0x223967 },
	{ 0x9012, 0x23394a },
	{ 0x9013, 0x23394e },
	{ 0x9014, 0x215d64 },
	{ 0x9015, 0x215d5d },
	{ 0x9016, 0x215d62 },
	{ 0x9017, 0x215d58 },
	{ 0x9018, 0x243568 },
	{ 0x9019, 0x215d55 },
	{ 0x901a, 0x215d57 },
	{ 0x901b, 0x215d63 },
	{ 0x901c, 0x223968 },
	{ 0x901d, 0x215d5b },
	{ 0x901e, 0x215d5e },
	{ 0x901f, 0x215d5a },
	{ 0x9020, 0x215d5f },
	{ 0x9021, 0x22396a },
	{ 0x9022, 0x215d61 },
	{ 0x9023, 0x215d59 },
	{ 0x9024, 0x223965 },
	{ 0x9025, 0x23394c },
	{ 0x9028, 0x233f4f },
	{ 0x9029, 0x233f50 },
	{ 0x902a, 0x233f4d },
	{ 0x902b, 0x233f4c },
	{ 0x902c, 0x233f51 },
	{ 0x902d, 0x224072 },
	{ 0x902e, 0x21624c },
	{ 0x902f, 0x224074 },
	{ 0x9030, 0x233f55 },
	{ 0x9031, 0x21624e },
	{ 0x9032, 0x216250 },
	{ 0x9033, 0x243566 },
	{ 0x9034, 0x224073 },
	{ 0x9035, 0x21624d },
	{ 0x9036, 0x216251 },
	{ 0x9037, 0x233f56 },
	{ 0x9038, 0x21624f },
	{ 0x903a, 0x233f54 },
	{ 0x903b, 0x233f57 },
	{ 0x903c, 0x21672f },
	{ 0x903d, 0x224829 },
	{ 0x903e, 0x216737 },
	{ 0x903f, 0x224826 },
	{ 0x9040, 0x23447d },
	{ 0x9041, 0x216738 },
	{ 0x9042, 0x21672d },
	{ 0x9043, 0x234479 },
	{ 0x9044, 0x224827 },
	{ 0x9045, 0x23447c },
	{ 0x9046, 0x23447a },
	{ 0x9047, 0x216732 },
	{ 0x9048, 0x23447b },
	{ 0x9049, 0x224828 },
	{ 0x904a, 0x21672b },
	{ 0x904b, 0x21672a },
	{ 0x904c, 0x23447e },
	{ 0x904d, 0x216735 },
	{ 0x904e, 0x216734 },
	{ 0x904f, 0x216733 },
	{ 0x9050, 0x216731 },
	{ 0x9051, 0x216736 },
	{ 0x9052, 0x224825 },
	{ 0x9053, 0x21672c },
	{ 0x9054, 0x21672e },
	{ 0x9055, 0x216730 },
	{ 0x9058, 0x216b40 },
	{ 0x9059, 0x216b43 },
	{ 0x905a, 0x234a24 },
	{ 0x905b, 0x216b47 },
	{ 0x905c, 0x216b41 },
	{ 0x905d, 0x216b46 },
	{ 0x905e, 0x216b44 },
	{ 0x905f, 0x234a27 },
	{ 0x9060, 0x216b3f },
	{ 0x9061, 0x234a26 },
	{ 0x9062, 0x216b45 },
	{ 0x9063, 0x216b42 },
	{ 0x9064, 0x2f4c6b },
	{ 0x9066, 0x244e32 },
	{ 0x9067, 0x22547a },
	{ 0x9068, 0x216f4d },
	{ 0x9069, 0x216f4b },
	{ 0x906a, 0x234f3c },
	{ 0x906b, 0x22547b },
	{ 0x906c, 0x244e33 },
	{ 0x906d, 0x216f4e },
	{ 0x906e, 0x216f4c },
	{ 0x906f, 0x225479 },
	{ 0x9070, 0x225478 },
	{ 0x9071, 0x234f3b },
	{ 0x9072, 0x21725a },
	{ 0x9073, 0x225477 },
	{ 0x9074, 0x217258 },
	{ 0x9075, 0x217257 },
	{ 0x9076, 0x225a7c },
	{ 0x9077, 0x216f4f },
	{ 0x9078, 0x217259 },
	{ 0x9079, 0x225a7d },
	{ 0x907a, 0x21725c },
	{ 0x907b, 0x225a7e },
	{ 0x907c, 0x21725b },
	{ 0x907d, 0x217563 },
	{ 0x907e, 0x225f6f },
	{ 0x907f, 0x217562 },
	{ 0x9080, 0x217567 },
	{ 0x9081, 0x217565 },
	{ 0x9082, 0x217566 },
	{ 0x9083, 0x21774e },
	{ 0x9084, 0x217564 },
	{ 0x9085, 0x225f6e },
	{ 0x9086, 0x225b21 },
	{ 0x9087, 0x21774d },
	{ 0x9088, 0x21774f },
	{ 0x9089, 0x23593a },
	{ 0x908a, 0x217931 },
	{ 0x908b, 0x217932 },
	{ 0x908c, 0x24615f },
	{ 0x908d, 0x226a2e },
	{ 0x908e, 0x246952 },
	{ 0x908f, 0x217c4a },
	{ 0x9090, 0x217c49 },
	{ 0x9091, 0x214b57 },
	{ 0x9092, 0x23225e },
	{ 0x9093, 0x23225d },
	{ 0x9094, 0x222275 },
	{ 0x9095, 0x215854 },
	{ 0x9096, 0x23243c },
	{ 0x9097, 0x222272 },
	{ 0x9098, 0x222273 },
	{ 0x9099, 0x222271 },
	{ 0x909a, 0x23243d },
	{ 0x909b, 0x222274 },
	{ 0x909c, 0x236655 },
	{ 0x909e, 0x22252a },
	{ 0x909f, 0x222527 },
	{ 0x90a0, 0x22252c },
	{ 0x90a1, 0x222528 },
	{ 0x90a2, 0x214b58 },
	{ 0x90a3, 0x214b5b },
	{ 0x90a4, 0x232735 },
	{ 0x90a5, 0x222529 },
	{ 0x90a6, 0x214b5a },
	{ 0x90a7, 0x22252b },
	{ 0x90a8, 0x232739 },
	{ 0x90a9, 0x232734 },
	{ 0x90aa, 0x214b59 },
	{ 0x90ab, 0x233951 },
	{ 0x90ad, 0x232a77 },
	{ 0x90ae, 0x24282b },
	{ 0x90af, 0x222875 },
	{ 0x90b0, 0x222877 },
	{ 0x90b1, 0x214f57 },
	{ 0x90b2, 0x222873 },
	{ 0x90b3, 0x222876 },
	{ 0x90b4, 0x222874 },
	{ 0x90b5, 0x214f55 },
	{ 0x90b6, 0x214f58 },
	{ 0x90b7, 0x232a75 },
	{ 0x90b8, 0x214f56 },
	{ 0x90b9, 0x232a78 },
	{ 0x90bc, 0x232f35 },
	{ 0x90bd, 0x222d59 },
	{ 0x90be, 0x222d5d },
	{ 0x90bf, 0x222d5a },
	{ 0x90c0, 0x232f38 },
	{ 0x90c1, 0x215368 },
	{ 0x90c2, 0x232f34 },
	{ 0x90c3, 0x215369 },
	{ 0x90c4, 0x232f3e },
	{ 0x90c5, 0x222d5c },
	{ 0x90c6, 0x232f37 },
	{ 0x90c7, 0x222d5e },
	{ 0x90c8, 0x222d60 },
	{ 0x90c9, 0x232f3c },
	{ 0x90ca, 0x215366 },
	{ 0x90cb, 0x222d5f },
	{ 0x90cc, 0x244139 },
	{ 0x90cd, 0x232f3b },
	{ 0x90ce, 0x215367 },
	{ 0x90d2, 0x2f456d },
	{ 0x90d4, 0x223971 },
	{ 0x90d5, 0x222d5b },
	{ 0x90d6, 0x223336 },
	{ 0x90d7, 0x22333f },
	{ 0x90d8, 0x22333d },
	{ 0x90d9, 0x223338 },
	{ 0x90da, 0x223339 },
	{ 0x90db, 0x22333e },
	{ 0x90dc, 0x223340 },
	{ 0x90dd, 0x215856 },
	{ 0x90de, 0x233429 },
	{ 0x90df, 0x22333b },
	{ 0x90e0, 0x223337 },
	{ 0x90e1, 0x215855 },
	{ 0x90e2, 0x215857 },
	{ 0x90e3, 0x22333a },
	{ 0x90e4, 0x223341 },
	{ 0x90e5, 0x22333c },
	{ 0x90e8, 0x215d65 },
	{ 0x90e9, 0x223974 },
	{ 0x90ea, 0x22396c },
	{ 0x90eb, 0x223972 },
	{ 0x90ec, 0x223973 },
	{ 0x90ed, 0x215d66 },
	{ 0x90ee, 0x23394f },
	{ 0x90ef, 0x22396b },
	{ 0x90f0, 0x22396d },
	{ 0x90f1, 0x222d58 },
	{ 0x90f2, 0x22396f },
	{ 0x90f3, 0x223970 },
	{ 0x90f4, 0x22396e },
	{ 0x90f5, 0x216253 },
	{ 0x90f6, 0x244e3b },
	{ 0x90f7, 0x233952 },
	{ 0x90f9, 0x22407b },
	{ 0x90fa, 0x225b22 },
	{ 0x90fb, 0x22407c },
	{ 0x90fc, 0x224079 },
	{ 0x90fd, 0x215d67 },
	{ 0x90fe, 0x216255 },
	{ 0x90ff, 0x224078 },
	{ 0x9100, 0x22407e },
	{ 0x9101, 0x22407d },
	{ 0x9102, 0x216252 },
	{ 0x9103, 0x224123 },
	{ 0x9104, 0x224077 },
	{ 0x9105, 0x224122 },
	{ 0x9106, 0x224075 },
	{ 0x9107, 0x224121 },
	{ 0x9108, 0x22407a },
	{ 0x9109, 0x216254 },
	{ 0x910a, 0x233f59 },
	{ 0x910b, 0x224830 },
	{ 0x910c, 0x234523 },
	{ 0x910d, 0x22482b },
	{ 0x910e, 0x224831 },
	{ 0x910f, 0x22482c },
	{ 0x9110, 0x22482a },
	{ 0x9111, 0x22482d },
	{ 0x9112, 0x216739 },
	{ 0x9113, 0x234524 },
	{ 0x9114, 0x22482f },
	{ 0x9115, 0x234525 },
	{ 0x9116, 0x22482e },
	{ 0x9117, 0x21673a },
	{ 0x9118, 0x216b49 },
	{ 0x9119, 0x216b48 },
	{ 0x911a, 0x224e56 },
	{ 0x911b, 0x224e59 },
	{ 0x911c, 0x224e51 },
	{ 0x911d, 0x224e55 },
	{ 0x911e, 0x216b4a },
	{ 0x911f, 0x224e54 },
	{ 0x9120, 0x224e52 },
	{ 0x9121, 0x224e58 },
	{ 0x9122, 0x224e53 },
	{ 0x9123, 0x224e50 },
	{ 0x9124, 0x224e57 },
	{ 0x9125, 0x234a2a },
	{ 0x9126, 0x225523 },
	{ 0x9127, 0x216f52 },
	{ 0x9128, 0x226374 },
	{ 0x9129, 0x22547e },
	{ 0x912a, 0x225521 },
	{ 0x912b, 0x22547d },
	{ 0x912c, 0x224076 },
	{ 0x912d, 0x216f51 },
	{ 0x912e, 0x225524 },
	{ 0x912f, 0x22547c },
	{ 0x9130, 0x216f50 },
	{ 0x9131, 0x216f53 },
	{ 0x9132, 0x225522 },
	{ 0x9133, 0x225b23 },
	{ 0x9134, 0x21725d },
	{ 0x9135, 0x225b24 },
	{ 0x9136, 0x225b25 },
	{ 0x9137, 0x23532b },
	{ 0x9138, 0x225f70 },
	{ 0x9139, 0x217568 },
	{ 0x913a, 0x226375 },
	{ 0x913b, 0x226376 },
	{ 0x913c, 0x23593c },
	{ 0x913d, 0x23593b },
	{ 0x913e, 0x226377 },
	{ 0x913f, 0x226749 },
	{ 0x9140, 0x226748 },
	{ 0x9141, 0x226a30 },
	{ 0x9143, 0x226a2f },
	{ 0x9144, 0x226c4a },
	{ 0x9145, 0x226c4b },
	{ 0x9146, 0x226c49 },
	{ 0x9147, 0x226e35 },
	{ 0x9148, 0x217b7a },
	{ 0x9149, 0x214b5c },
	{ 0x914a, 0x21536b },
	{ 0x914b, 0x21536a },
	{ 0x914c, 0x21585a },
	{ 0x914d, 0x215859 },
	{ 0x914e, 0x223343 },
	{ 0x914f, 0x223344 },
	{ 0x9150, 0x223342 },
	{ 0x9151, 0x23342a },
	{ 0x9152, 0x215858 },
	{ 0x9153, 0x223978 },
	{ 0x9154, 0x233955 },
	{ 0x9155, 0x223979 },
	{ 0x9156, 0x223975 },
	{ 0x9157, 0x215d68 },
	{ 0x9158, 0x223976 },
	{ 0x9159, 0x233954 },
	{ 0x915a, 0x223977 },
	{ 0x915c, 0x236657 },
	{ 0x915f, 0x224126 },
	{ 0x9160, 0x224128 },
	{ 0x9161, 0x224124 },
	{ 0x9162, 0x224127 },
	{ 0x9163, 0x216256 },
	{ 0x9164, 0x224125 },
	{ 0x9165, 0x216257 },
	{ 0x9167, 0x234528 },
	{ 0x9168, 0x224279 },
	{ 0x9169, 0x21673d },
	{ 0x916a, 0x21673c },
	{ 0x916b, 0x234527 },
	{ 0x916c, 0x21673b },
	{ 0x916d, 0x24413a },
	{ 0x916e, 0x224832 },
	{ 0x916f, 0x224833 },
	{ 0x9170, 0x24413b },
	{ 0x9172, 0x224e5b },
	{ 0x9173, 0x224e5d },
	{ 0x9174, 0x216b4e },
	{ 0x9175, 0x216b4b },
	{ 0x9176, 0x234a2c },
	{ 0x9177, 0x216b4d },
	{ 0x9178, 0x216b4c },
	{ 0x9179, 0x224e5c },
	{ 0x917a, 0x224e5a },
	{ 0x917b, 0x234a2b },
	{ 0x917c, 0x234a2d },
	{ 0x9180, 0x22552b },
	{ 0x9181, 0x225528 },
	{ 0x9182, 0x225529 },
	{ 0x9183, 0x216f57 },
	{ 0x9184, 0x22552a },
	{ 0x9185, 0x225525 },
	{ 0x9186, 0x225526 },
	{ 0x9187, 0x216f54 },
	{ 0x9188, 0x234f3f },
	{ 0x9189, 0x216f55 },
	{ 0x918a, 0x225527 },
	{ 0x918b, 0x216f56 },
	{ 0x918c, 0x234f40 },
	{ 0x918d, 0x225b29 },
	{ 0x918e, 0x23532d },
	{ 0x918f, 0x225b2a },
	{ 0x9190, 0x225b27 },
	{ 0x9191, 0x225b28 },
	{ 0x9192, 0x21725e },
	{ 0x9193, 0x225b26 },
	{ 0x9194, 0x245442 },
	{ 0x9195, 0x23532c },
	{ 0x9196, 0x23532f },
	{ 0x9198, 0x24593f },
	{ 0x9199, 0x225f74 },
	{ 0x919a, 0x225f71 },
	{ 0x919b, 0x225f73 },
	{ 0x919c, 0x21756b },
	{ 0x919d, 0x225f77 },
	{ 0x919e, 0x21756a },
	{ 0x919f, 0x225f75 },
	{ 0x91a0, 0x225f78 },
	{ 0x91a1, 0x225f76 },
	{ 0x91a2, 0x225f72 },
	{ 0x91a3, 0x217569 },
	{ 0x91a5, 0x226379 },
	{ 0x91a6, 0x245e24 },
	{ 0x91a7, 0x22637a },
	{ 0x91a8, 0x226378 },
	{ 0x91a9, 0x23593d },
	{ 0x91aa, 0x22637c },
	{ 0x91ab, 0x217750 },
	{ 0x91ac, 0x217751 },
	{ 0x91ad, 0x22674b },
	{ 0x91ae, 0x217934 },
	{ 0x91af, 0x22637b },
	{ 0x91b0, 0x22674a },
	{ 0x91b1, 0x217933 },
	{ 0x91b2, 0x226a33 },
	{ 0x91b3, 0x226a34 },
	{ 0x91b4, 0x217a4a },
	{ 0x91b5, 0x226a32 },
	{ 0x91b6, 0x246465 },
	{ 0x91b7, 0x226a31 },
	{ 0x91b9, 0x226c4c },
	{ 0x91ba, 0x217b34 },
	{ 0x91bb, 0x235e68 },
	{ 0x91bc, 0x226f57 },
	{ 0x91bd, 0x227056 },
	{ 0x91be, 0x227055 },
	{ 0x91bf, 0x23607e },
	{ 0x91c0, 0x217c6e },
	{ 0x91c1, 0x217d2a },
	{ 0x91c2, 0x227057 },
	{ 0x91c3, 0x227160 },
	{ 0x91c4, 0x23616d },
	{ 0x91c5, 0x217d3c },
	{ 0x91c6, 0x214b5d },
	{ 0x91c7, 0x214f59 },
	{ 0x91c9, 0x21673e },
	{ 0x91cb, 0x217a4b },
	{ 0x91cc, 0x214b5e },
	{ 0x91cd, 0x21536c },
	{ 0x91ce, 0x215d69 },
	{ 0x91cf, 0x216258 },
	{ 0x91d0, 0x217752 },
	{ 0x91d1, 0x214f5a },
	{ 0x91d3, 0x222d62 },
	{ 0x91d4, 0x222d61 },
	{ 0x91d5, 0x223345 },
	{ 0x91d6, 0x233430 },
	{ 0x91d7, 0x21585d },
	{ 0x91d8, 0x21585b },
	{ 0x91d9, 0x21585f },
	{ 0x91da, 0x223347 },
	{ 0x91db, 0x23342d },
	{ 0x91dc, 0x21585e },
	{ 0x91dd, 0x21585c },
	{ 0x91de, 0x23342f },
	{ 0x91df, 0x23342e },
	{ 0x91e0, 0x233431 },
	{ 0x91e2, 0x223346 },
	{ 0x91e3, 0x215d6c },
	{ 0x91e4, 0x223a21 },
	{ 0x91e5, 0x233958 },
	{ 0x91e6, 0x215d6b },
	{ 0x91e7, 0x215d6d },
	{ 0x91e8, 0x223a26 },
	{ 0x91e9, 0x215d6f },
	{ 0x91ea, 0x223a23 },
	{ 0x91eb, 0x223a24 },
	{ 0x91ec, 0x22397a },
	{ 0x91ed, 0x215d6e },
	{ 0x91ee, 0x223a27 },
	{ 0x91ef, 0x24357b },
	{ 0x91f0, 0x233957 },
	{ 0x91f1, 0x22397c },
	{ 0x91f2, 0x233956 },
	{ 0x91f3, 0x22397d },
	{ 0x91f4, 0x22397b },
	{ 0x91f5, 0x215d6a },
	{ 0x91f6, 0x233959 },
	{ 0x91f7, 0x223a25 },
	{ 0x91f8, 0x22397e },
	{ 0x91f9, 0x223a22 },
	{ 0x91fd, 0x224134 },
	{ 0x91fe, 0x233f5d },
	{ 0x91ff, 0x224133 },
	{ 0x9200, 0x224131 },
	{ 0x9201, 0x224129 },
	{ 0x9202, 0x224138 },
	{ 0x9203, 0x22412c },
	{ 0x9204, 0x224136 },
	{ 0x9205, 0x22413d },
	{ 0x9206, 0x224135 },
	{ 0x9207, 0x216260 },
	{ 0x9208, 0x233f66 },
	{ 0x9209, 0x21625c },
	{ 0x920a, 0x22412a },
	{ 0x920b, 0x233f60 },
	{ 0x920c, 0x224130 },
	{ 0x920d, 0x21625e },
	{ 0x920e, 0x233f68 },
	{ 0x920f, 0x22412f },
	{ 0x9210, 0x21625f },
	{ 0x9211, 0x216261 },
	{ 0x9212, 0x224132 },
	{ 0x9213, 0x233f69 },
	{ 0x9214, 0x216259 },
	{ 0x9215, 0x21625a },
	{ 0x9216, 0x22413e },
	{ 0x9217, 0x22413c },
	{ 0x9218, 0x233f62 },
	{ 0x9219, 0x22413b },
	{ 0x921a, 0x22412d },
	{ 0x921b, 0x233f65 },
	{ 0x921c, 0x224139 },
	{ 0x921d, 0x243b66 },
	{ 0x921e, 0x21625d },
	{ 0x921f, 0x264f6f },
	{ 0x9220, 0x233f5e },
	{ 0x9221, 0x236659 },
	{ 0x9222, 0x233f63 },
	{ 0x9223, 0x21625b },
	{ 0x9224, 0x22413a },
	{ 0x9225, 0x22412b },
	{ 0x9226, 0x22412e },
	{ 0x9227, 0x224137 },
	{ 0x922b, 0x236658 },
	{ 0x922d, 0x224f22 },
	{ 0x922e, 0x22483d },
	{ 0x922f, 0x23452e },
	{ 0x9230, 0x224836 },
	{ 0x9231, 0x224849 },
	{ 0x9232, 0x224852 },
	{ 0x9233, 0x224839 },
	{ 0x9234, 0x216749 },
	{ 0x9235, 0x23452b },
	{ 0x9236, 0x224846 },
	{ 0x9237, 0x21673f },
	{ 0x9238, 0x216741 },
	{ 0x9239, 0x21674d },
	{ 0x923a, 0x224837 },
	{ 0x923b, 0x234537 },
	{ 0x923c, 0x23452f },
	{ 0x923d, 0x216742 },
	{ 0x923e, 0x216744 },
	{ 0x923f, 0x21674e },
	{ 0x9240, 0x216743 },
	{ 0x9241, 0x234539 },
	{ 0x9242, 0x244141 },
	{ 0x9243, 0x244146 },
	{ 0x9244, 0x234538 },
	{ 0x9245, 0x21674c },
	{ 0x9246, 0x22483f },
	{ 0x9247, 0x244148 },
	{ 0x9248, 0x224834 },
	{ 0x9249, 0x21674a },
	{ 0x924a, 0x22483e },
	{ 0x924b, 0x216746 },
	{ 0x924c, 0x224850 },
	{ 0x924d, 0x21674b },
	{ 0x924e, 0x22484e },
	{ 0x924f, 0x224842 },
	{ 0x9250, 0x22484c },
	{ 0x9251, 0x216748 },
	{ 0x9252, 0x224835 },
	{ 0x9253, 0x22484f },
	{ 0x9254, 0x22484a },
	{ 0x9255, 0x23452a },
	{ 0x9256, 0x224851 },
	{ 0x9257, 0x216740 },
	{ 0x9258, 0x244140 },
	{ 0x9259, 0x23452d },
	{ 0x925a, 0x21674f },
	{ 0x925b, 0x216745 },
	{ 0x925c, 0x234531 },
	{ 0x925d, 0x234529 },
	{ 0x925e, 0x22483b },
	{ 0x925f, 0x234534 },
	{ 0x9260, 0x224843 },
	{ 0x9261, 0x224847 },
	{ 0x9262, 0x234533 },
	{ 0x9263, 0x22484b },
	{ 0x9264, 0x216747 },
	{ 0x9265, 0x22483a },
	{ 0x9266, 0x224838 },
	{ 0x9267, 0x224844 },
	{ 0x9268, 0x244142 },
	{ 0x9269, 0x244143 },
	{ 0x926a, 0x234532 },
	{ 0x926b, 0x234535 },
	{ 0x926c, 0x224841 },
	{ 0x926d, 0x224840 },
	{ 0x926e, 0x234536 },
	{ 0x926f, 0x224845 },
	{ 0x9270, 0x224848 },
	{ 0x9272, 0x22484d },
	{ 0x9273, 0x23665a },
	{ 0x9274, 0x2f4572 },
	{ 0x9275, 0x244775 },
	{ 0x9276, 0x224e60 },
	{ 0x9277, 0x2f4d22 },
	{ 0x9278, 0x216b4f },
	{ 0x9279, 0x224e6a },
	{ 0x927a, 0x224e62 },
	{ 0x927b, 0x216b55 },
	{ 0x927c, 0x216b59 },
	{ 0x927d, 0x224e73 },
	{ 0x927e, 0x224e7b },
	{ 0x927f, 0x224e6c },
	{ 0x9280, 0x216b51 },
	{ 0x9281, 0x234a34 },
	{ 0x9282, 0x224e70 },
	{ 0x9283, 0x22483c },
	{ 0x9284, 0x234a35 },
	{ 0x9285, 0x216b52 },
	{ 0x9286, 0x224e77 },
	{ 0x9287, 0x224e7c },
	{ 0x9288, 0x224e74 },
	{ 0x9289, 0x234a2f },
	{ 0x928a, 0x224e76 },
	{ 0x928b, 0x224f21 },
	{ 0x928c, 0x224e78 },
	{ 0x928d, 0x224e66 },
	{ 0x928e, 0x224e6f },
	{ 0x928f, 0x234530 },
	{ 0x9290, 0x234a38 },
	{ 0x9291, 0x216b5a },
	{ 0x9292, 0x234a33 },
	{ 0x9293, 0x216b56 },
	{ 0x9294, 0x224e64 },
	{ 0x9295, 0x224e71 },
	{ 0x9296, 0x216b54 },
	{ 0x9297, 0x224e6b },
	{ 0x9298, 0x216b53 },
	{ 0x9299, 0x224e79 },
	{ 0x929a, 0x224e68 },
	{ 0x929b, 0x224e61 },
	{ 0x929c, 0x216b57 },
	{ 0x929d, 0x224e7e },
	{ 0x929e, 0x234a39 },
	{ 0x929f, 0x244777 },
	{ 0x92a0, 0x224e63 },
	{ 0x92a1, 0x224e75 },
	{ 0x92a2, 0x224e72 },
	{ 0x92a3, 0x224e6d },
	{ 0x92a4, 0x224e5f },
	{ 0x92a5, 0x224e5e },
	{ 0x92a6, 0x224e67 },
	{ 0x92a7, 0x224e7a },
	{ 0x92a8, 0x216b58 },
	{ 0x92a9, 0x224e7d },
	{ 0x92aa, 0x224e65 },
	{ 0x92ab, 0x224e69 },
	{ 0x92ac, 0x216b50 },
	{ 0x92ad, 0x234a32 },
	{ 0x92ae, 0x234a37 },
	{ 0x92af, 0x2f4d27 },
	{ 0x92b0, 0x23672a },
	{ 0x92b1, 0x234a31 },
	{ 0x92b2, 0x216f63 },
	{ 0x92b3, 0x216f5e },
	{ 0x92b4, 0x22554d },
	{ 0x92b5, 0x225549 },
	{ 0x92b6, 0x225531 },
	{ 0x92b7, 0x216f5a },
	{ 0x92b8, 0x234f42 },
	{ 0x92b9, 0x234f50 },
	{ 0x92ba, 0x244e45 },
	{ 0x92bb, 0x216f59 },
	{ 0x92bc, 0x216f5f },
	{ 0x92bd, 0x244e47 },
	{ 0x92be, 0x234f43 },
	{ 0x92bf, 0x234f41 },
	{ 0x92c0, 0x22552f },
	{ 0x92c1, 0x216f5d },
	{ 0x92c2, 0x22553b },
	{ 0x92c3, 0x22552d },
	{ 0x92c4, 0x22552e },
	{ 0x92c5, 0x216f58 },
	{ 0x92c6, 0x22554c },
	{ 0x92c7, 0x216f61 },
	{ 0x92c8, 0x22553e },
	{ 0x92c9, 0x225543 },
	{ 0x92ca, 0x22553d },
	{ 0x92cb, 0x225b3c },
	{ 0x92cc, 0x225539 },
	{ 0x92cd, 0x225541 },
	{ 0x92ce, 0x22553f },
	{ 0x92cf, 0x225532 },
	{ 0x92d0, 0x22552c },
	{ 0x92d1, 0x225547 },
	{ 0x92d2, 0x216f60 },
	{ 0x92d3, 0x225548 },
	{ 0x92d4, 0x234f48 },
	{ 0x92d5, 0x225542 },
	{ 0x92d6, 0x234f49 },
	{ 0x92d7, 0x225537 },
	{ 0x92d8, 0x225535 },
	{ 0x92d9, 0x225530 },
	{ 0x92da, 0x234f4b },
	{ 0x92db, 0x234f4e },
	{ 0x92dc, 0x234f44 },
	{ 0x92dd, 0x225538 },
	{ 0x92de, 0x225545 },
	{ 0x92df, 0x225534 },
	{ 0x92e0, 0x225544 },
	{ 0x92e1, 0x22554a },
	{ 0x92e2, 0x234f51 },
	{ 0x92e3, 0x244e46 },
	{ 0x92e4, 0x216f5c },
	{ 0x92e5, 0x234f45 },
	{ 0x92e6, 0x225540 },
	{ 0x92e7, 0x225546 },
	{ 0x92e8, 0x22553c },
	{ 0x92e9, 0x225536 },
	{ 0x92ea, 0x216f5b },
	{ 0x92eb, 0x234f52 },
	{ 0x92ec, 0x244e44 },
	{ 0x92ed, 0x234f4c },
	{ 0x92ee, 0x224e6e },
	{ 0x92ef, 0x22553a },
	{ 0x92f0, 0x216f62 },
	{ 0x92f1, 0x225533 },
	{ 0x92f2, 0x2f526b },
	{ 0x92f3, 0x234f4d },
	{ 0x92f4, 0x23665b },
	{ 0x92f5, 0x23665c },
	{ 0x92f6, 0x234a30 },
	{ 0x92f7, 0x225b41 },
	{ 0x92f8, 0x217261 },
	{ 0x92f9, 0x225b40 },
	{ 0x92fa, 0x225b3e },
	{ 0x92fb, 0x225b50 },
	{ 0x92fc, 0x217265 },
	{ 0x92fd, 0x235335 },
	{ 0x92fe, 0x225b4d },
	{ 0x92ff, 0x225b45 },
	{ 0x9300, 0x225b4f },
	{ 0x9301, 0x225b37 },
	{ 0x9302, 0x225b43 },
	{ 0x9303, 0x23533d },
	{ 0x9304, 0x217267 },
	{ 0x9305, 0x23533e },
	{ 0x9306, 0x225b2f },
	{ 0x9307, 0x235338 },
	{ 0x9308, 0x225b2d },
	{ 0x9309, 0x225b4e },
	{ 0x930a, 0x235332 },
	{ 0x930b, 0x225b4c },
	{ 0x930c, 0x225b4b },
	{ 0x930d, 0x225b3b },
	{ 0x930e, 0x225b3a },
	{ 0x930f, 0x225b30 },
	{ 0x9310, 0x217269 },
	{ 0x9311, 0x245443 },
	{ 0x9312, 0x225b36 },
	{ 0x9313, 0x225b3f },
	{ 0x9314, 0x225b4a },
	{ 0x9315, 0x21726c },
	{ 0x9316, 0x225b51 },
	{ 0x9317, 0x235336 },
	{ 0x9318, 0x217573 },
	{ 0x9319, 0x21726e },
	{ 0x931a, 0x217268 },
	{ 0x931b, 0x225b34 },
	{ 0x931c, 0x235337 },
	{ 0x931d, 0x225b3d },
	{ 0x931e, 0x225b2c },
	{ 0x931f, 0x225b2e },
	{ 0x9320, 0x21725f },
	{ 0x9321, 0x21726b },
	{ 0x9322, 0x217264 },
	{ 0x9323, 0x225b35 },
	{ 0x9324, 0x225b44 },
	{ 0x9325, 0x22554b },
	{ 0x9326, 0x21726a },
	{ 0x9327, 0x225b2b },
	{ 0x9328, 0x21756e },
	{ 0x9329, 0x225b46 },
	{ 0x932a, 0x225b49 },
	{ 0x932b, 0x217266 },
	{ 0x932c, 0x23533b },
	{ 0x932d, 0x225b39 },
	{ 0x932e, 0x21726d },
	{ 0x932f, 0x217263 },
	{ 0x9330, 0x23533c },
	{ 0x9331, 0x235339 },
	{ 0x9332, 0x23533a },
	{ 0x9333, 0x217262 },
	{ 0x9334, 0x225b42 },
	{ 0x9335, 0x225b48 },
	{ 0x9336, 0x217260 },
	{ 0x9337, 0x245445 },
	{ 0x9338, 0x225b32 },
	{ 0x9339, 0x225b47 },
	{ 0x933a, 0x2f5859 },
	{ 0x933b, 0x2f5848 },
	{ 0x933c, 0x225b33 },
	{ 0x933d, 0x273463 },
	{ 0x933f, 0x23665d },
	{ 0x9340, 0x2f5855 },
	{ 0x9342, 0x23665e },
	{ 0x9343, 0x245449 },
	{ 0x9345, 0x235331 },
	{ 0x9346, 0x225b38 },
	{ 0x9347, 0x225f7e },
	{ 0x9348, 0x235665 },
	{ 0x9349, 0x226025 },
	{ 0x934a, 0x217570 },
	{ 0x934b, 0x217572 },
	{ 0x934c, 0x22602b },
	{ 0x934d, 0x21756c },
	{ 0x934e, 0x226039 },
	{ 0x934f, 0x226031 },
	{ 0x9350, 0x226026 },
	{ 0x9351, 0x226027 },
	{ 0x9352, 0x226030 },
	{ 0x9353, 0x235666 },
	{ 0x9354, 0x217579 },
	{ 0x9355, 0x22602f },
	{ 0x9356, 0x225f7d },
	{ 0x9357, 0x22602e },
	{ 0x9358, 0x226022 },
	{ 0x9359, 0x22603a },
	{ 0x935a, 0x217578 },
	{ 0x935b, 0x217576 },
	{ 0x935c, 0x226023 },
	{ 0x935d, 0x23565d },
	{ 0x935e, 0x226036 },
	{ 0x935f, 0x235667 },
	{ 0x9360, 0x226028 },
	{ 0x9361, 0x226035 },
	{ 0x9362, 0x235664 },
	{ 0x9363, 0x226037 },
	{ 0x9364, 0x225f7c },
	{ 0x9365, 0x217571 },
	{ 0x9366, 0x23565b },
	{ 0x9367, 0x226038 },
	{ 0x9368, 0x235668 },
	{ 0x9369, 0x23565e },
	{ 0x936a, 0x22602c },
	{ 0x936b, 0x23566b },
	{ 0x936c, 0x217575 },
	{ 0x936d, 0x226029 },
	{ 0x936e, 0x235661 },
	{ 0x936f, 0x245949 },
	{ 0x9370, 0x217577 },
	{ 0x9371, 0x226032 },
	{ 0x9372, 0x235662 },
	{ 0x9373, 0x235663 },
	{ 0x9374, 0x23565f },
	{ 0x9375, 0x21756f },
	{ 0x9376, 0x226024 },
	{ 0x9377, 0x226033 },
	{ 0x9378, 0x23565c },
	{ 0x9379, 0x22602d },
	{ 0x937a, 0x225b31 },
	{ 0x937b, 0x226034 },
	{ 0x937c, 0x226021 },
	{ 0x937d, 0x235660 },
	{ 0x937e, 0x217574 },
	{ 0x937f, 0x23566a },
	{ 0x9380, 0x22642f },
	{ 0x9381, 0x245947 },
	{ 0x9382, 0x21756d },
	{ 0x9383, 0x225f7a },
	{ 0x9384, 0x245946 },
	{ 0x9385, 0x2f5d41 },
	{ 0x9386, 0x23665f },
	{ 0x9387, 0x2f5d39 },
	{ 0x9388, 0x22642c },
	{ 0x9389, 0x226425 },
	{ 0x938a, 0x217754 },
	{ 0x938b, 0x235943 },
	{ 0x938c, 0x22637e },
	{ 0x938d, 0x226430 },
	{ 0x938e, 0x226427 },
	{ 0x938f, 0x22602a },
	{ 0x9390, 0x235940 },
	{ 0x9391, 0x226432 },
	{ 0x9392, 0x226421 },
	{ 0x9393, 0x235942 },
	{ 0x9394, 0x217753 },
	{ 0x9395, 0x22642b },
	{ 0x9396, 0x217755 },
	{ 0x9397, 0x21775d },
	{ 0x9398, 0x21775b },
	{ 0x9399, 0x22642d },
	{ 0x939a, 0x21775c },
	{ 0x939b, 0x226423 },
	{ 0x939c, 0x235949 },
	{ 0x939d, 0x226424 },
	{ 0x939e, 0x226429 },
	{ 0x939f, 0x22642e },
	{ 0x93a0, 0x23593e },
	{ 0x93a1, 0x225f79 },
	{ 0x93a2, 0x217756 },
	{ 0x93a3, 0x226437 },
	{ 0x93a4, 0x226434 },
	{ 0x93a5, 0x226761 },
	{ 0x93a6, 0x22642a },
	{ 0x93a7, 0x226426 },
	{ 0x93a8, 0x226435 },
	{ 0x93a9, 0x226756 },
	{ 0x93aa, 0x226428 },
	{ 0x93ab, 0x245e31 },
	{ 0x93ac, 0x217759 },
	{ 0x93ad, 0x235944 },
	{ 0x93ae, 0x217758 },
	{ 0x93af, 0x225f7b },
	{ 0x93b0, 0x21775a },
	{ 0x93b1, 0x226431 },
	{ 0x93b2, 0x226433 },
	{ 0x93b3, 0x217757 },
	{ 0x93b4, 0x226436 },
	{ 0x93b5, 0x22637d },
	{ 0x93b6, 0x245e29 },
	{ 0x93b7, 0x226422 },
	{ 0x93b8, 0x235946 },
	{ 0x93b9, 0x2f6133 },
	{ 0x93bb, 0x235945 },
	{ 0x93bc, 0x236661 },
	{ 0x93bd, 0x236662 },
	{ 0x93be, 0x236660 },
	{ 0x93bf, 0x2f6143 },
	{ 0x93c0, 0x22675f },
	{ 0x93c1, 0x235b50 },
	{ 0x93c2, 0x22674f },
	{ 0x93c3, 0x217938 },
	{ 0x93c4, 0x22675d },
	{ 0x93c5, 0x235b44 },
	{ 0x93c6, 0x235b45 },
	{ 0x93c7, 0x22674d },
	{ 0x93c8, 0x217939 },
	{ 0x93c9, 0x246167 },
	{ 0x93ca, 0x226758 },
	{ 0x93cb, 0x235b43 },
	{ 0x93cc, 0x226754 },
	{ 0x93cd, 0x21793e },
	{ 0x93ce, 0x22675e },
	{ 0x93cf, 0x22674e },
	{ 0x93d0, 0x226751 },
	{ 0x93d1, 0x217936 },
	{ 0x93d2, 0x226760 },
	{ 0x93d3, 0x235b48 },
	{ 0x93d4, 0x226759 },
	{ 0x93d5, 0x22675c },
	{ 0x93d6, 0x21793c },
	{ 0x93d7, 0x217941 },
	{ 0x93d8, 0x21793f },
	{ 0x93d9, 0x226755 },
	{ 0x93da, 0x226750 },
	{ 0x93db, 0x235b4d },
	{ 0x93dc, 0x21793a },
	{ 0x93dd, 0x21793b },
	{ 0x93de, 0x22674c },
	{ 0x93df, 0x217937 },
	{ 0x93e0, 0x235b4f },
	{ 0x93e1, 0x217935 },
	{ 0x93e2, 0x21793d },
	{ 0x93e3, 0x22675b },
	{ 0x93e4, 0x217940 },
	{ 0x93e5, 0x235b4a },
	{ 0x93e6, 0x226757 },
	{ 0x93e7, 0x226762 },
	{ 0x93e8, 0x217942 },
	{ 0x93e9, 0x235b41 },
	{ 0x93ea, 0x235b42 },
	{ 0x93eb, 0x235b4e },
	{ 0x93ec, 0x226753 },
	{ 0x93ed, 0x235b47 },
	{ 0x93ee, 0x22675a },
	{ 0x93ef, 0x236665 },
	{ 0x93f1, 0x236663 },
	{ 0x93f2, 0x236664 },
	{ 0x93f3, 0x235d41 },
	{ 0x93f4, 0x235e6a },
	{ 0x93f5, 0x226a41 },
	{ 0x93f6, 0x226a50 },
	{ 0x93f7, 0x226a43 },
	{ 0x93f8, 0x226a4a },
	{ 0x93f9, 0x226752 },
	{ 0x93fa, 0x226a48 },
	{ 0x93fb, 0x226a37 },
	{ 0x93fc, 0x226a4e },
	{ 0x93fd, 0x217a4e },
	{ 0x93fe, 0x226a3b },
	{ 0x93ff, 0x226a4d },
	{ 0x9400, 0x226a42 },
	{ 0x9401, 0x246467 },
	{ 0x9402, 0x235d43 },
	{ 0x9403, 0x217a4d },
	{ 0x9404, 0x235d3c },
	{ 0x9405, 0x235d3f },
	{ 0x9406, 0x226a52 },
	{ 0x9407, 0x226a44 },
	{ 0x9408, 0x235d3e },
	{ 0x9409, 0x226a49 },
	{ 0x940a, 0x226a4c },
	{ 0x940b, 0x226a35 },
	{ 0x940c, 0x226a4f },
	{ 0x940d, 0x226a40 },
	{ 0x940e, 0x226a45 },
	{ 0x940f, 0x226a39 },
	{ 0x9410, 0x226a3d },
	{ 0x9411, 0x226a51 },
	{ 0x9412, 0x226a47 },
	{ 0x9413, 0x226a36 },
	{ 0x9414, 0x226a3a },
	{ 0x9415, 0x226a3c },
	{ 0x9416, 0x226a46 },
	{ 0x9417, 0x235d3d },
	{ 0x9418, 0x217a4c },
	{ 0x9419, 0x226a3f },
	{ 0x941a, 0x235d44 },
	{ 0x941b, 0x235d45 },
	{ 0x941c, 0x235d47 },
	{ 0x941d, 0x24646b },
	{ 0x941e, 0x235d42 },
	{ 0x941f, 0x235d3a },
	{ 0x9420, 0x226a38 },
	{ 0x9422, 0x236666 },
	{ 0x9423, 0x236667 },
	{ 0x9424, 0x236668 },
	{ 0x9425, 0x2f6657 },
	{ 0x9427, 0x235d46 },
	{ 0x9428, 0x226a3e },
	{ 0x9429, 0x226c50 },
	{ 0x942a, 0x226c54 },
	{ 0x942b, 0x217b3b },
	{ 0x942c, 0x226c56 },
	{ 0x942d, 0x235e6d },
	{ 0x942e, 0x217b35 },
	{ 0x942f, 0x24646f },
	{ 0x9430, 0x226c52 },
	{ 0x9431, 0x226c58 },
	{ 0x9432, 0x217b3a },
	{ 0x9433, 0x217b36 },
	{ 0x9434, 0x24675c },
	{ 0x9435, 0x217b37 },
	{ 0x9436, 0x226c4f },
	{ 0x9437, 0x226c55 },
	{ 0x9438, 0x217b39 },
	{ 0x9439, 0x226c53 },
	{ 0x943a, 0x217b38 },
	{ 0x943b, 0x226c4e },
	{ 0x943c, 0x226a4b },
	{ 0x943d, 0x226c51 },
	{ 0x943e, 0x246762 },
	{ 0x943f, 0x226c4d },
	{ 0x9440, 0x226c57 },
	{ 0x9442, 0x235f69 },
	{ 0x9443, 0x235f6e },
	{ 0x9444, 0x217b7b },
	{ 0x9445, 0x226e3c },
	{ 0x9446, 0x226e3f },
	{ 0x9447, 0x226e3b },
	{ 0x9448, 0x226e3d },
	{ 0x9449, 0x226e3e },
	{ 0x944a, 0x226e38 },
	{ 0x944b, 0x226e39 },
	{ 0x944c, 0x226e36 },
	{ 0x944d, 0x235f6a },
	{ 0x944e, 0x235f6c },
	{ 0x944f, 0x226e3a },
	{ 0x9450, 0x226e37 },
	{ 0x9451, 0x217b7c },
	{ 0x9452, 0x217b7d },
	{ 0x9454, 0x235f6b },
	{ 0x9455, 0x226f59 },
	{ 0x9456, 0x236052 },
	{ 0x9457, 0x226f5b },
	{ 0x9458, 0x246b29 },
	{ 0x9459, 0x25765d },
	{ 0x945a, 0x236055 },
	{ 0x945b, 0x236054 },
	{ 0x945c, 0x236056 },
	{ 0x945d, 0x226f5a },
	{ 0x945e, 0x226f5c },
	{ 0x945f, 0x23604f },
	{ 0x9460, 0x217c4c },
	{ 0x9461, 0x236053 },
	{ 0x9462, 0x226f58 },
	{ 0x9463, 0x217c4b },
	{ 0x9464, 0x217c4d },
	{ 0x9465, 0x236057 },
	{ 0x9466, 0x23666a },
	{ 0x9467, 0x236669 },
	{ 0x9468, 0x227059 },
	{ 0x9469, 0x22705a },
	{ 0x946a, 0x217c6f },
	{ 0x946b, 0x227058 },
	{ 0x946c, 0x236122 },
	{ 0x946d, 0x227142 },
	{ 0x946e, 0x227141 },
	{ 0x946f, 0x227143 },
	{ 0x9470, 0x217d2c },
	{ 0x9471, 0x227144 },
	{ 0x9472, 0x217d2b },
	{ 0x9473, 0x227145 },
	{ 0x9474, 0x227161 },
	{ 0x9475, 0x227164 },
	{ 0x9476, 0x227163 },
	{ 0x9477, 0x217d35 },
	{ 0x9478, 0x227162 },
	{ 0x9479, 0x246d62 },
	{ 0x947a, 0x23616f },
	{ 0x947b, 0x236223 },
	{ 0x947c, 0x217d3f },
	{ 0x947d, 0x217d3d },
	{ 0x947e, 0x217d3e },
	{ 0x947f, 0x217d44 },
	{ 0x9480, 0x227230 },
	{ 0x9481, 0x227231 },
	{ 0x9482, 0x22722f },
	{ 0x9483, 0x227237 },
	{ 0x9484, 0x236236 },
	{ 0x9577, 0x214f5b },
	{ 0x9578, 0x24252b },
	{ 0x9579, 0x24303a },
	{ 0x957a, 0x223a28 },
	{ 0x957b, 0x22413f },
	{ 0x957c, 0x22554e },
	{ 0x957d, 0x226763 },
	{ 0x957e, 0x257156 },
	{ 0x9580, 0x214f5c },
	{ 0x9581, 0x232f40 },
	{ 0x9582, 0x21536d },
	{ 0x9583, 0x215860 },
	{ 0x9584, 0x24303b },
	{ 0x9585, 0x233432 },
	{ 0x9586, 0x223a29 },
	{ 0x9587, 0x23395c },
	{ 0x9588, 0x223a2a },
	{ 0x9589, 0x215d70 },
	{ 0x958b, 0x216264 },
	{ 0x958c, 0x224141 },
	{ 0x958d, 0x224140 },
	{ 0x958e, 0x216268 },
	{ 0x958f, 0x216263 },
	{ 0x9590, 0x224142 },
	{ 0x9591, 0x216265 },
	{ 0x9592, 0x216267 },
	{ 0x9593, 0x216266 },
	{ 0x9594, 0x216262 },
	{ 0x9595, 0x233f6c },
	{ 0x9596, 0x2f3f7e },
	{ 0x9597, 0x23666b },
	{ 0x9598, 0x216750 },
	{ 0x9599, 0x23453c },
	{ 0x959a, 0x23453a },
	{ 0x959b, 0x224856 },
	{ 0x959c, 0x224854 },
	{ 0x959d, 0x244153 },
	{ 0x959e, 0x224855 },
	{ 0x959f, 0x224853 },
	{ 0x95a0, 0x2f457b },
	{ 0x95a1, 0x216b5b },
	{ 0x95a2, 0x234a3d },
	{ 0x95a3, 0x216b5e },
	{ 0x95a4, 0x216b60 },
	{ 0x95a5, 0x216b5f },
	{ 0x95a6, 0x244822 },
	{ 0x95a7, 0x234a3e },
	{ 0x95a8, 0x216b5c },
	{ 0x95a9, 0x216b5d },
	{ 0x95ab, 0x225550 },
	{ 0x95ac, 0x22554f },
	{ 0x95ad, 0x216f64 },
	{ 0x95ae, 0x225551 },
	{ 0x95af, 0x234f53 },
	{ 0x95b0, 0x225552 },
	{ 0x95b1, 0x216f65 },
	{ 0x95b2, 0x234f55 },
	{ 0x95b3, 0x234f56 },
	{ 0x95b4, 0x244e4a },
	{ 0x95b5, 0x225b59 },
	{ 0x95b6, 0x225b57 },
	{ 0x95b7, 0x226040 },
	{ 0x95b8, 0x235342 },
	{ 0x95b9, 0x225b55 },
	{ 0x95ba, 0x225b56 },
	{ 0x95bb, 0x21726f },
	{ 0x95bc, 0x225b52 },
	{ 0x95bd, 0x225b5a },
	{ 0x95be, 0x225b54 },
	{ 0x95bf, 0x225b58 },
	{ 0x95c0, 0x22603c },
	{ 0x95c1, 0x235344 },
	{ 0x95c2, 0x235340 },
	{ 0x95c3, 0x22603e },
	{ 0x95c4, 0x23566d },
	{ 0x95c5, 0x22603f },
	{ 0x95c6, 0x21757e },
	{ 0x95c7, 0x22603b },
	{ 0x95c8, 0x21757d },
	{ 0x95c9, 0x22603d },
	{ 0x95ca, 0x21757a },
	{ 0x95cb, 0x21757b },
	{ 0x95cc, 0x21757c },
	{ 0x95cd, 0x225b53 },
	{ 0x95ce, 0x23666c },
	{ 0x95d0, 0x217760 },
	{ 0x95d1, 0x22643a },
	{ 0x95d2, 0x226438 },
	{ 0x95d3, 0x226439 },
	{ 0x95d4, 0x21775e },
	{ 0x95d5, 0x217761 },
	{ 0x95d6, 0x21775f },
	{ 0x95d7, 0x23594b },
	{ 0x95d8, 0x23594a },
	{ 0x95d9, 0x274b40 },
	{ 0x95da, 0x226764 },
	{ 0x95db, 0x226765 },
	{ 0x95dc, 0x217943 },
	{ 0x95dd, 0x235b53 },
	{ 0x95de, 0x226a53 },
	{ 0x95df, 0x226a55 },
	{ 0x95e0, 0x226a54 },
	{ 0x95e1, 0x217a4f },
	{ 0x95e2, 0x217b3c },
	{ 0x95e3, 0x226c5b },
	{ 0x95e4, 0x226c5a },
	{ 0x95e5, 0x226c59 },
	{ 0x95e6, 0x2f6872 },
	{ 0x95e7, 0x23666d },
	{ 0x95f5, 0x2f2539 },
	{ 0x961c, 0x214f5d },
	{ 0x961d, 0x232143 },
	{ 0x961e, 0x222169 },
	{ 0x9620, 0x222278 },
	{ 0x9621, 0x21486a },
	{ 0x9622, 0x222276 },
	{ 0x9623, 0x222279 },
	{ 0x9624, 0x222277 },
	{ 0x9625, 0x24252e },
	{ 0x9626, 0x23273b },
	{ 0x9627, 0x23273a },
	{ 0x9628, 0x22252e },
	{ 0x9629, 0x23273f },
	{ 0x962a, 0x214b62 },
	{ 0x962b, 0x23273c },
	{ 0x962c, 0x214b63 },
	{ 0x962d, 0x222530 },
	{ 0x962e, 0x214b60 },
	{ 0x962f, 0x22252f },
	{ 0x9630, 0x22252d },
	{ 0x9631, 0x214b61 },
	{ 0x9632, 0x214b5f },
	{ 0x9633, 0x23273d },
	{ 0x9634, 0x23273e },
	{ 0x9637, 0x232a79 },
	{ 0x9638, 0x242833 },
	{ 0x9639, 0x222878 },
	{ 0x963a, 0x22287b },
	{ 0x963b, 0x214f60 },
	{ 0x963c, 0x22287a },
	{ 0x963d, 0x222879 },
	{ 0x963e, 0x232a7c },
	{ 0x963f, 0x214f5f },
	{ 0x9640, 0x214f5e },
	{ 0x9641, 0x232a7b },
	{ 0x9642, 0x214f62 },
	{ 0x9643, 0x22287c },
	{ 0x9644, 0x214f61 },
	{ 0x964a, 0x222d67 },
	{ 0x964b, 0x21536f },
	{ 0x964c, 0x215370 },
	{ 0x964d, 0x215371 },
	{ 0x964e, 0x222d68 },
	{ 0x964f, 0x222d64 },
	{ 0x9650, 0x21536e },
	{ 0x9651, 0x222d65 },
	{ 0x9652, 0x242b5d },
	{ 0x9653, 0x222d66 },
	{ 0x9654, 0x222d63 },
	{ 0x9655, 0x242b5b },
	{ 0x9656, 0x233436 },
	{ 0x9657, 0x24303f },
	{ 0x9658, 0x215867 },
	{ 0x9659, 0x233434 },
	{ 0x965a, 0x23395e },
	{ 0x965b, 0x215864 },
	{ 0x965c, 0x223348 },
	{ 0x965d, 0x215865 },
	{ 0x965e, 0x215868 },
	{ 0x965f, 0x223349 },
	{ 0x9660, 0x233433 },
	{ 0x9661, 0x215863 },
	{ 0x9662, 0x215861 },
	{ 0x9663, 0x215862 },
	{ 0x9664, 0x215866 },
	{ 0x966a, 0x215d71 },
	{ 0x966b, 0x223a2d },
	{ 0x966c, 0x215d79 },
	{ 0x966d, 0x223a2c },
	{ 0x966e, 0x233961 },
	{ 0x966f, 0x223a2f },
	{ 0x9670, 0x215d75 },
	{ 0x9671, 0x223a2e },
	{ 0x9672, 0x216270 },
	{ 0x9673, 0x215d73 },
	{ 0x9674, 0x215d76 },
	{ 0x9675, 0x215d72 },
	{ 0x9676, 0x215d77 },
	{ 0x9677, 0x215d78 },
	{ 0x9678, 0x215d74 },
	{ 0x9679, 0x233965 },
	{ 0x967b, 0x233f71 },
	{ 0x967c, 0x223a2b },
	{ 0x967d, 0x21626c },
	{ 0x967e, 0x224144 },
	{ 0x967f, 0x233f72 },
	{ 0x9680, 0x224148 },
	{ 0x9681, 0x233f73 },
	{ 0x9682, 0x233f75 },
	{ 0x9683, 0x224147 },
	{ 0x9684, 0x216271 },
	{ 0x9685, 0x21626d },
	{ 0x9686, 0x21626e },
	{ 0x9687, 0x224143 },
	{ 0x9688, 0x224145 },
	{ 0x9689, 0x224146 },
	{ 0x968a, 0x216269 },
	{ 0x968b, 0x21626b },
	{ 0x968c, 0x233f70 },
	{ 0x968d, 0x21626f },
	{ 0x968e, 0x21626a },
	{ 0x968f, 0x234540 },
	{ 0x9691, 0x224859 },
	{ 0x9692, 0x224857 },
	{ 0x9693, 0x224858 },
	{ 0x9694, 0x216752 },
	{ 0x9695, 0x216753 },
	{ 0x9696, 0x234542 },
	{ 0x9697, 0x22485a },
	{ 0x9698, 0x216751 },
	{ 0x9699, 0x216b61 },
	{ 0x969a, 0x244824 },
	{ 0x969b, 0x216b63 },
	{ 0x969c, 0x216b62 },
	{ 0x969d, 0x234a45 },
	{ 0x969e, 0x224f23 },
	{ 0x969f, 0x234a46 },
	{ 0x96a0, 0x234a44 },
	{ 0x96a1, 0x224f24 },
	{ 0x96a2, 0x225554 },
	{ 0x96a3, 0x234f5a },
	{ 0x96a4, 0x225553 },
	{ 0x96a5, 0x234f5b },
	{ 0x96a6, 0x245452 },
	{ 0x96a7, 0x217270 },
	{ 0x96a8, 0x217271 },
	{ 0x96a9, 0x225b5b },
	{ 0x96aa, 0x217272 },
	{ 0x96ab, 0x235348 },
	{ 0x96ac, 0x226043 },
	{ 0x96ad, 0x235670 },
	{ 0x96ae, 0x226041 },
	{ 0x96af, 0x23566f },
	{ 0x96b0, 0x226042 },
	{ 0x96b1, 0x217621 },
	{ 0x96b2, 0x235671 },
	{ 0x96b3, 0x22643b },
	{ 0x96b4, 0x217944 },
	{ 0x96b5, 0x235d49 },
	{ 0x96b6, 0x232a7d },
	{ 0x96b7, 0x235349 },
	{ 0x96b8, 0x217622 },
	{ 0x96b9, 0x214f63 },
	{ 0x96ba, 0x243041 },
	{ 0x96bb, 0x215869 },
	{ 0x96bc, 0x22334a },
	{ 0x96bd, 0x233439 },
	{ 0x96be, 0x2f326f },
	{ 0x96bf, 0x223a30 },
	{ 0x96c0, 0x215d7a },
	{ 0x96c1, 0x216272 },
	{ 0x96c2, 0x224149 },
	{ 0x96c3, 0x22414b },
	{ 0x96c4, 0x216274 },
	{ 0x96c5, 0x216273 },
	{ 0x96c6, 0x216275 },
	{ 0x96c7, 0x216276 },
	{ 0x96c8, 0x22414a },
	{ 0x96c9, 0x216756 },
	{ 0x96ca, 0x216757 },
	{ 0x96cb, 0x216755 },
	{ 0x96cc, 0x216b64 },
	{ 0x96cd, 0x216754 },
	{ 0x96ce, 0x22485b },
	{ 0x96cf, 0x244157 },
	{ 0x96d0, 0x234a47 },
	{ 0x96d1, 0x234a49 },
	{ 0x96d2, 0x216b65 },
	{ 0x96d3, 0x225555 },
	{ 0x96d4, 0x225b5c },
	{ 0x96d5, 0x217273 },
	{ 0x96d6, 0x217623 },
	{ 0x96d7, 0x22643c },
	{ 0x96d8, 0x226440 },
	{ 0x96d9, 0x217764 },
	{ 0x96da, 0x22643d },
	{ 0x96db, 0x217765 },
	{ 0x96dc, 0x217763 },
	{ 0x96dd, 0x226441 },
	{ 0x96de, 0x217766 },
	{ 0x96df, 0x22643f },
	{ 0x96e1, 0x226766 },
	{ 0x96e2, 0x217762 },
	{ 0x96e3, 0x217945 },
	{ 0x96e4, 0x235e70 },
	{ 0x96e5, 0x22705b },
	{ 0x96e6, 0x236125 },
	{ 0x96e7, 0x23622f },
	{ 0x96e8, 0x214f64 },
	{ 0x96e9, 0x215d7c },
	{ 0x96ea, 0x215d7b },
	{ 0x96eb, 0x2f392a },
	{ 0x96ec, 0x233f7e },
	{ 0x96ed, 0x233f7c },
	{ 0x96ee, 0x233f7b },
	{ 0x96ef, 0x216277 },
	{ 0x96f0, 0x22414d },
	{ 0x96f1, 0x22414c },
	{ 0x96f2, 0x216278 },
	{ 0x96f4, 0x234546 },
	{ 0x96f5, 0x22485f },
	{ 0x96f6, 0x21675b },
	{ 0x96f7, 0x216758 },
	{ 0x96f8, 0x22485e },
	{ 0x96f9, 0x21675a },
	{ 0x96fa, 0x22485c },
	{ 0x96fb, 0x216759 },
	{ 0x96fc, 0x234547 },
	{ 0x96fd, 0x22485d },
	{ 0x96ff, 0x224f25 },
	{ 0x9700, 0x216b66 },
	{ 0x9702, 0x225558 },
	{ 0x9703, 0x25523b },
	{ 0x9704, 0x216f66 },
	{ 0x9705, 0x225556 },
	{ 0x9706, 0x216f67 },
	{ 0x9707, 0x216f68 },
	{ 0x9708, 0x225557 },
	{ 0x9709, 0x216f69 },
	{ 0x970a, 0x234f60 },
	{ 0x970b, 0x225b5d },
	{ 0x970c, 0x235350 },
	{ 0x970d, 0x217277 },
	{ 0x970e, 0x217274 },
	{ 0x970f, 0x217279 },
	{ 0x9710, 0x225b5f },
	{ 0x9711, 0x217275 },
	{ 0x9712, 0x225b5e },
	{ 0x9713, 0x217278 },
	{ 0x9714, 0x23534d },
	{ 0x9715, 0x23534c },
	{ 0x9716, 0x217276 },
	{ 0x9717, 0x235351 },
	{ 0x9718, 0x226046 },
	{ 0x9719, 0x226048 },
	{ 0x971a, 0x235674 },
	{ 0x971b, 0x235675 },
	{ 0x971c, 0x217624 },
	{ 0x971d, 0x226047 },
	{ 0x971e, 0x217625 },
	{ 0x971f, 0x226045 },
	{ 0x9720, 0x226044 },
	{ 0x9721, 0x245e38 },
	{ 0x9722, 0x226443 },
	{ 0x9723, 0x226442 },
	{ 0x9724, 0x217767 },
	{ 0x9725, 0x226444 },
	{ 0x9726, 0x22676b },
	{ 0x9727, 0x217947 },
	{ 0x9728, 0x22676a },
	{ 0x9729, 0x226767 },
	{ 0x972a, 0x217946 },
	{ 0x972b, 0x226768 },
	{ 0x972c, 0x226769 },
	{ 0x972e, 0x226a56 },
	{ 0x972f, 0x226a57 },
	{ 0x9730, 0x217a50 },
	{ 0x9731, 0x235d4f },
	{ 0x9732, 0x217b3f },
	{ 0x9733, 0x235d4c },
	{ 0x9734, 0x235d4e },
	{ 0x9735, 0x226c5c },
	{ 0x9736, 0x235e72 },
	{ 0x9737, 0x235e71 },
	{ 0x9738, 0x217b3d },
	{ 0x9739, 0x217b3e },
	{ 0x973a, 0x226c5d },
	{ 0x973b, 0x23666e },
	{ 0x973c, 0x235f71 },
	{ 0x973d, 0x217b7e },
	{ 0x973e, 0x217c21 },
	{ 0x973f, 0x226e40 },
	{ 0x9740, 0x235f72 },
	{ 0x9741, 0x236059 },
	{ 0x9742, 0x217c70 },
	{ 0x9743, 0x22705d },
	{ 0x9744, 0x217c72 },
	{ 0x9745, 0x236126 },
	{ 0x9746, 0x22705c },
	{ 0x9747, 0x22705e },
	{ 0x9748, 0x217c71 },
	{ 0x9749, 0x227146 },
	{ 0x974a, 0x246d64 },
	{ 0x974b, 0x22717b },
	{ 0x974d, 0x23666f },
	{ 0x9750, 0x236245 },
	{ 0x9751, 0x232a7e },
	{ 0x9752, 0x214f65 },
	{ 0x9755, 0x234549 },
	{ 0x9756, 0x21675c },
	{ 0x9757, 0x244835 },
	{ 0x9758, 0x224f26 },
	{ 0x9759, 0x234a4c },
	{ 0x975a, 0x225559 },
	{ 0x975b, 0x21727a },
	{ 0x975c, 0x21727b },
	{ 0x975d, 0x23594f },
	{ 0x975e, 0x214f66 },
	{ 0x975f, 0x234021 },
	{ 0x9760, 0x216f6a },
	{ 0x9761, 0x217948 },
	{ 0x9762, 0x215372 },
	{ 0x9763, 0x232b21 },
	{ 0x9764, 0x234a4e },
	{ 0x9766, 0x21727c },
	{ 0x9767, 0x235e73 },
	{ 0x9768, 0x217c4e },
	{ 0x9769, 0x215373 },
	{ 0x976a, 0x223a31 },
	{ 0x976b, 0x243b77 },
	{ 0x976c, 0x22414e },
	{ 0x976d, 0x234024 },
	{ 0x976e, 0x224150 },
	{ 0x976f, 0x234022 },
	{ 0x9770, 0x22414f },
	{ 0x9772, 0x224863 },
	{ 0x9773, 0x224860 },
	{ 0x9774, 0x21675d },
	{ 0x9775, 0x265a24 },
	{ 0x9776, 0x21675e },
	{ 0x9777, 0x224861 },
	{ 0x9778, 0x224862 },
	{ 0x9779, 0x23454b },
	{ 0x977a, 0x224f28 },
	{ 0x977b, 0x224f2d },
	{ 0x977c, 0x216b67 },
	{ 0x977d, 0x224f27 },
	{ 0x977e, 0x224f29 },
	{ 0x977f, 0x224f30 },
	{ 0x9780, 0x224f2b },
	{ 0x9781, 0x224f2f },
	{ 0x9782, 0x224f2c },
	{ 0x9783, 0x224f2a },
	{ 0x9784, 0x224f2e },
	{ 0x9785, 0x216b68 },
	{ 0x9787, 0x234f62 },
	{ 0x9788, 0x22555c },
	{ 0x9789, 0x234f63 },
	{ 0x978a, 0x22555a },
	{ 0x978b, 0x216f6c },
	{ 0x978c, 0x234f64 },
	{ 0x978d, 0x216f6b },
	{ 0x978e, 0x22555b },
	{ 0x978f, 0x216f6d },
	{ 0x9793, 0x235353 },
	{ 0x9794, 0x225b62 },
	{ 0x9795, 0x24545f },
	{ 0x9796, 0x245467 },
	{ 0x9797, 0x225b61 },
	{ 0x9798, 0x21727d },
	{ 0x9799, 0x225b60 },
	{ 0x979a, 0x226049 },
	{ 0x979b, 0x23567a },
	{ 0x979c, 0x22604b },
	{ 0x979d, 0x22604d },
	{ 0x979e, 0x22604c },
	{ 0x979f, 0x23567b },
	{ 0x97a0, 0x217626 },
	{ 0x97a1, 0x22604a },
	{ 0x97a2, 0x22644b },
	{ 0x97a3, 0x217768 },
	{ 0x97a4, 0x226449 },
	{ 0x97a5, 0x22644c },
	{ 0x97a6, 0x217769 },
	{ 0x97a7, 0x245e43 },
	{ 0x97a8, 0x226447 },
	{ 0x97a9, 0x235950 },
	{ 0x97aa, 0x22644a },
	{ 0x97ab, 0x226448 },
	{ 0x97ac, 0x226445 },
	{ 0x97ad, 0x21776a },
	{ 0x97ae, 0x226446 },
	{ 0x97b0, 0x24617c },
	{ 0x97b1, 0x235b5f },
	{ 0x97b2, 0x235b5d },
	{ 0x97b3, 0x22676c },
	{ 0x97b4, 0x235b5e },
	{ 0x97b5, 0x235b60 },
	{ 0x97b6, 0x22676e },
	{ 0x97b7, 0x22676d },
	{ 0x97b8, 0x235d50 },
	{ 0x97b9, 0x226a58 },
	{ 0x97ba, 0x235d51 },
	{ 0x97bb, 0x226a59 },
	{ 0x97bc, 0x246771 },
	{ 0x97bd, 0x235e75 },
	{ 0x97be, 0x235e74 },
	{ 0x97bf, 0x226c5e },
	{ 0x97c0, 0x235f73 },
	{ 0x97c1, 0x217c23 },
	{ 0x97c2, 0x24695e },
	{ 0x97c3, 0x217c22 },
	{ 0x97c4, 0x226f5d },
	{ 0x97c5, 0x226f5e },
	{ 0x97c6, 0x217c73 },
	{ 0x97c7, 0x22705f },
	{ 0x97c8, 0x236128 },
	{ 0x97c9, 0x217d36 },
	{ 0x97ca, 0x23623b },
	{ 0x97cb, 0x215374 },
	{ 0x97cc, 0x216279 },
	{ 0x97cd, 0x224f32 },
	{ 0x97ce, 0x224f31 },
	{ 0x97cf, 0x22555e },
	{ 0x97d0, 0x22555d },
	{ 0x97d1, 0x244e57 },
	{ 0x97d2, 0x235355 },
	{ 0x97d3, 0x217627 },
	{ 0x97d4, 0x22604f },
	{ 0x97d5, 0x22604e },
	{ 0x97d6, 0x22644f },
	{ 0x97d7, 0x22644d },
	{ 0x97d8, 0x226450 },
	{ 0x97d9, 0x22644e },
	{ 0x97da, 0x235951 },
	{ 0x97db, 0x246529 },
	{ 0x97dc, 0x217949 },
	{ 0x97dd, 0x22676f },
	{ 0x97de, 0x226770 },
	{ 0x97df, 0x226771 },
	{ 0x97e0, 0x246527 },
	{ 0x97e1, 0x226c5f },
	{ 0x97e2, 0x235e76 },
	{ 0x97e3, 0x226e41 },
	{ 0x97e4, 0x236129 },
	{ 0x97e5, 0x227060 },
	{ 0x97ed, 0x215375 },
	{ 0x97ee, 0x23454f },
	{ 0x97ef, 0x234f65 },
	{ 0x97f0, 0x225b63 },
	{ 0x97f1, 0x226050 },
	{ 0x97f2, 0x235b61 },
	{ 0x97f3, 0x215376 },
	{ 0x97f4, 0x244163 },
	{ 0x97f5, 0x234550 },
	{ 0x97f6, 0x216b69 },
	{ 0x97f7, 0x244846 },
	{ 0x97f8, 0x225b64 },
	{ 0x97f9, 0x21776b },
	{ 0x97fa, 0x226451 },
	{ 0x97fb, 0x21794a },
	{ 0x97fc, 0x235d53 },
	{ 0x97fd, 0x226a5a },
	{ 0x97fe, 0x226a5b },
	{ 0x97ff, 0x217b40 },
	{ 0x9800, 0x226f5f },
	{ 0x9801, 0x215377 },
	{ 0x9802, 0x215e21 },
	{ 0x9803, 0x215e22 },
	{ 0x9804, 0x223a32 },
	{ 0x9805, 0x21627a },
	{ 0x9806, 0x21627b },
	{ 0x9807, 0x224151 },
	{ 0x9808, 0x21627c },
	{ 0x9809, 0x244168 },
	{ 0x980a, 0x216762 },
	{ 0x980b, 0x234552 },
	{ 0x980c, 0x216764 },
	{ 0x980d, 0x224865 },
	{ 0x980e, 0x224866 },
	{ 0x980f, 0x224864 },
	{ 0x9810, 0x21675f },
	{ 0x9811, 0x216760 },
	{ 0x9812, 0x216763 },
	{ 0x9813, 0x216761 },
	{ 0x9814, 0x234a54 },
	{ 0x9815, 0x234a55 },
	{ 0x9816, 0x224f33 },
	{ 0x9817, 0x216b6a },
	{ 0x9818, 0x216b6b },
	{ 0x9819, 0x234a52 },
	{ 0x981a, 0x234a56 },
	{ 0x981b, 0x225565 },
	{ 0x981c, 0x216f70 },
	{ 0x981d, 0x225560 },
	{ 0x981e, 0x22555f },
	{ 0x981f, 0x234f69 },
	{ 0x9820, 0x225564 },
	{ 0x9821, 0x216f6e },
	{ 0x9822, 0x234f67 },
	{ 0x9823, 0x244e5a },
	{ 0x9824, 0x217326 },
	{ 0x9825, 0x245470 },
	{ 0x9826, 0x225561 },
	{ 0x9827, 0x225566 },
	{ 0x9828, 0x225563 },
	{ 0x9829, 0x225562 },
	{ 0x982a, 0x234f66 },
	{ 0x982b, 0x216f6f },
	{ 0x982d, 0x217324 },
	{ 0x982e, 0x23535c },
	{ 0x982f, 0x225b66 },
	{ 0x9830, 0x21727e },
	{ 0x9831, 0x235359 },
	{ 0x9832, 0x225b67 },
	{ 0x9833, 0x23535a },
	{ 0x9834, 0x235228 },
	{ 0x9835, 0x225b65 },
	{ 0x9836, 0x235358 },
	{ 0x9837, 0x217323 },
	{ 0x9838, 0x217321 },
	{ 0x9839, 0x217325 },
	{ 0x983a, 0x23535d },
	{ 0x983b, 0x217322 },
	{ 0x983c, 0x23535b },
	{ 0x983d, 0x23535f },
	{ 0x983e, 0x245e4f },
	{ 0x983f, 0x23595b },
	{ 0x9840, 0x235726 },
	{ 0x9841, 0x226051 },
	{ 0x9842, 0x245970 },
	{ 0x9843, 0x226056 },
	{ 0x9844, 0x226052 },
	{ 0x9845, 0x226055 },
	{ 0x9846, 0x217628 },
	{ 0x9847, 0x235728 },
	{ 0x9848, 0x225e41 },
	{ 0x9849, 0x226054 },
	{ 0x984a, 0x226053 },
	{ 0x984b, 0x235959 },
	{ 0x984c, 0x21776e },
	{ 0x984d, 0x21776c },
	{ 0x984e, 0x21776f },
	{ 0x984f, 0x21776d },
	{ 0x9850, 0x226452 },
	{ 0x9851, 0x226453 },
	{ 0x9852, 0x226454 },
	{ 0x9853, 0x217770 },
	{ 0x9854, 0x235956 },
	{ 0x9855, 0x235958 },
	{ 0x9856, 0x235b65 },
	{ 0x9857, 0x226775 },
	{ 0x9858, 0x21794c },
	{ 0x9859, 0x226773 },
	{ 0x985a, 0x246230 },
	{ 0x985b, 0x21794d },
	{ 0x985c, 0x226772 },
	{ 0x985d, 0x226774 },
	{ 0x985e, 0x21794b },
	{ 0x985f, 0x226a5f },
	{ 0x9860, 0x226a5c },
	{ 0x9861, 0x24652c },
	{ 0x9862, 0x226a5d },
	{ 0x9863, 0x226a5e },
	{ 0x9864, 0x226c60 },
	{ 0x9865, 0x217b42 },
	{ 0x9866, 0x235e78 },
	{ 0x9867, 0x217b41 },
	{ 0x9868, 0x235e77 },
	{ 0x9869, 0x226e43 },
	{ 0x986a, 0x226e42 },
	{ 0x986b, 0x217c24 },
	{ 0x986c, 0x23605d },
	{ 0x986d, 0x23605e },
	{ 0x986e, 0x23605c },
	{ 0x986f, 0x217c4f },
	{ 0x9870, 0x217c74 },
	{ 0x9871, 0x217d2d },
	{ 0x9872, 0x227147 },
	{ 0x9873, 0x22717c },
	{ 0x9874, 0x22717d },
	{ 0x98a8, 0x215378 },
	{ 0x98a9, 0x224152 },
	{ 0x98ab, 0x244171 },
	{ 0x98ac, 0x224867 },
	{ 0x98ad, 0x224f34 },
	{ 0x98ae, 0x224f35 },
	{ 0x98af, 0x216b6c },
	{ 0x98b0, 0x244857 },
	{ 0x98b1, 0x216b6d },
	{ 0x98b2, 0x225567 },
	{ 0x98b3, 0x216f71 },
	{ 0x98b5, 0x235361 },
	{ 0x98b6, 0x217629 },
	{ 0x98b7, 0x23572a },
	{ 0x98b8, 0x226455 },
	{ 0x98b9, 0x23595c },
	{ 0x98ba, 0x217771 },
	{ 0x98bb, 0x226778 },
	{ 0x98bc, 0x21794e },
	{ 0x98bd, 0x226777 },
	{ 0x98be, 0x226779 },
	{ 0x98bf, 0x226776 },
	{ 0x98c0, 0x226c63 },
	{ 0x98c1, 0x226a60 },
	{ 0x98c2, 0x226a61 },
	{ 0x98c3, 0x235d56 },
	{ 0x98c4, 0x217a51 },
	{ 0x98c6, 0x226c62 },
	{ 0x98c7, 0x235e7b },
	{ 0x98c8, 0x235e79 },
	{ 0x98c9, 0x226c61 },
	{ 0x98ca, 0x235e7a },
	{ 0x98cb, 0x226e44 },
	{ 0x98cc, 0x22717e },
	{ 0x98cd, 0x236225 },
	{ 0x98db, 0x215379 },
	{ 0x98dc, 0x235e7c },
	{ 0x98dd, 0x236226 },
	{ 0x98df, 0x21537a },
	{ 0x98e1, 0x233967 },
	{ 0x98e2, 0x21586a },
	{ 0x98e3, 0x22334b },
	{ 0x98e4, 0x236670 },
	{ 0x98e5, 0x223a33 },
	{ 0x98e6, 0x233968 },
	{ 0x98e7, 0x21627d },
	{ 0x98e9, 0x216322 },
	{ 0x98ea, 0x21627e },
	{ 0x98eb, 0x224153 },
	{ 0x98ec, 0x23455b },
	{ 0x98ed, 0x216324 },
	{ 0x98ef, 0x216321 },
	{ 0x98f0, 0x23402b },
	{ 0x98f1, 0x23455c },
	{ 0x98f2, 0x216323 },
	{ 0x98f3, 0x234554 },
	{ 0x98f4, 0x216766 },
	{ 0x98f5, 0x234559 },
	{ 0x98f6, 0x224868 },
	{ 0x98f7, 0x234557 },
	{ 0x98f8, 0x234a5d },
	{ 0x98f9, 0x224869 },
	{ 0x98fa, 0x225569 },
	{ 0x98fb, 0x24417b },
	{ 0x98fc, 0x216765 },
	{ 0x98fd, 0x216767 },
	{ 0x98fe, 0x216768 },
	{ 0x98ff, 0x234558 },
	{ 0x9900, 0x224f37 },
	{ 0x9901, 0x234a5e },
	{ 0x9902, 0x224f36 },
	{ 0x9903, 0x216b6e },
	{ 0x9904, 0x254b4c },
	{ 0x9905, 0x216b6f },
	{ 0x9906, 0x234a5b },
	{ 0x9907, 0x224f38 },
	{ 0x9908, 0x225568 },
	{ 0x9909, 0x216b71 },
	{ 0x990a, 0x216f72 },
	{ 0x990b, 0x244e63 },
	{ 0x990c, 0x216b70 },
	{ 0x990e, 0x23667a },
	{ 0x9910, 0x217327 },
	{ 0x9911, 0x22556a },
	{ 0x9912, 0x216f74 },
	{ 0x9913, 0x216f73 },
	{ 0x9914, 0x22556b },
	{ 0x9915, 0x22556e },
	{ 0x9916, 0x22556c },
	{ 0x9917, 0x22556d },
	{ 0x9918, 0x216f75 },
	{ 0x9919, 0x234f6b },
	{ 0x991a, 0x21732c },
	{ 0x991b, 0x21732a },
	{ 0x991c, 0x235365 },
	{ 0x991d, 0x235366 },
	{ 0x991e, 0x217329 },
	{ 0x991f, 0x225b69 },
	{ 0x9920, 0x235364 },
	{ 0x9921, 0x21732b },
	{ 0x9922, 0x235362 },
	{ 0x9923, 0x235363 },
	{ 0x9924, 0x225b68 },
	{ 0x9925, 0x226057 },
	{ 0x9926, 0x24547e },
	{ 0x9927, 0x225b6a },
	{ 0x9928, 0x217328 },
	{ 0x9929, 0x225b6b },
	{ 0x992a, 0x22605a },
	{ 0x992b, 0x226058 },
	{ 0x992c, 0x226059 },
	{ 0x992d, 0x22605e },
	{ 0x992e, 0x217775 },
	{ 0x992f, 0x22605d },
	{ 0x9930, 0x226060 },
	{ 0x9931, 0x22605f },
	{ 0x9932, 0x22605c },
	{ 0x9933, 0x22605b },
	{ 0x9934, 0x245521 },
	{ 0x9935, 0x21762a },
	{ 0x9936, 0x235962 },
	{ 0x9937, 0x245a29 },
	{ 0x9938, 0x235961 },
	{ 0x9939, 0x235966 },
	{ 0x993a, 0x226458 },
	{ 0x993b, 0x235965 },
	{ 0x993c, 0x226457 },
	{ 0x993d, 0x217774 },
	{ 0x993e, 0x217772 },
	{ 0x993f, 0x217773 },
	{ 0x9940, 0x235963 },
	{ 0x9941, 0x226456 },
	{ 0x9942, 0x236671 },
	{ 0x9943, 0x22677c },
	{ 0x9944, 0x235b69 },
	{ 0x9945, 0x21794f },
	{ 0x9946, 0x246238 },
	{ 0x9947, 0x22677b },
	{ 0x9948, 0x22677a },
	{ 0x9949, 0x217950 },
	{ 0x994a, 0x24653a },
	{ 0x994b, 0x226a66 },
	{ 0x994c, 0x226a65 },
	{ 0x994d, 0x235d58 },
	{ 0x994e, 0x226a63 },
	{ 0x994f, 0x235e7e },
	{ 0x9950, 0x226a62 },
	{ 0x9951, 0x217a53 },
	{ 0x9952, 0x217a52 },
	{ 0x9953, 0x226a67 },
	{ 0x9954, 0x226e45 },
	{ 0x9955, 0x217c25 },
	{ 0x9956, 0x226c65 },
	{ 0x9957, 0x217b43 },
	{ 0x9958, 0x226c64 },
	{ 0x9959, 0x226a64 },
	{ 0x995a, 0x235f78 },
	{ 0x995b, 0x226e46 },
	{ 0x995c, 0x217c50 },
	{ 0x995d, 0x23612a },
	{ 0x995e, 0x217d2e },
	{ 0x995f, 0x227148 },
	{ 0x9960, 0x246e24 },
	{ 0x9961, 0x227221 },
	{ 0x9996, 0x21537b },
	{ 0x9997, 0x223a34 },
	{ 0x9998, 0x226061 },
	{ 0x9999, 0x21537c },
	{ 0x999a, 0x23455f },
	{ 0x999b, 0x254b4e },
	{ 0x999c, 0x224f3a },
	{ 0x999d, 0x224f39 },
	{ 0x999e, 0x225b6c },
	{ 0x999f, 0x255a26 },
	{ 0x99a0, 0x235368 },
	{ 0x99a1, 0x226063 },
	{ 0x99a2, 0x235730 },
	{ 0x99a3, 0x226062 },
	{ 0x99a4, 0x235967 },
	{ 0x99a5, 0x217776 },
	{ 0x99a6, 0x22677d },
	{ 0x99a7, 0x22677e },
	{ 0x99a8, 0x217a54 },
	{ 0x99a9, 0x235f21 },
	{ 0x99aa, 0x236060 },
	{ 0x99ab, 0x227222 },
	{ 0x99ac, 0x21586b },
	{ 0x99ad, 0x216326 },
	{ 0x99ae, 0x216325 },
	{ 0x99af, 0x22486a },
	{ 0x99b0, 0x22486c },
	{ 0x99b1, 0x21676a },
	{ 0x99b2, 0x22486b },
	{ 0x99b3, 0x216769 },
	{ 0x99b4, 0x21676b },
	{ 0x99b5, 0x22486d },
	{ 0x99b6, 0x234a63 },
	{ 0x99b7, 0x234a62 },
	{ 0x99b8, 0x234a66 },
	{ 0x99b9, 0x224f3c },
	{ 0x99ba, 0x224f3e },
	{ 0x99bb, 0x224f3d },
	{ 0x99bc, 0x234a61 },
	{ 0x99bd, 0x224f40 },
	{ 0x99be, 0x234a60 },
	{ 0x99bf, 0x234a6c },
	{ 0x99c0, 0x234a64 },
	{ 0x99c1, 0x216b72 },
	{ 0x99c2, 0x224f3f },
	{ 0x99c3, 0x224f3b },
	{ 0x99c4, 0x234a6a },
	{ 0x99c6, 0x244860 },
	{ 0x99c7, 0x224f41 },
	{ 0x99c8, 0x234f73 },
	{ 0x99c9, 0x225575 },
	{ 0x99ca, 0x234f6d },
	{ 0x99cb, 0x225578 },
	{ 0x99cc, 0x22557a },
	{ 0x99cd, 0x225570 },
	{ 0x99ce, 0x225574 },
	{ 0x99cf, 0x225571 },
	{ 0x99d0, 0x216f77 },
	{ 0x99d1, 0x216f7a },
	{ 0x99d2, 0x216f7c },
	{ 0x99d3, 0x225572 },
	{ 0x99d4, 0x225573 },
	{ 0x99d5, 0x216f7b },
	{ 0x99d6, 0x225576 },
	{ 0x99d7, 0x225579 },
	{ 0x99d8, 0x225577 },
	{ 0x99d9, 0x216f7d },
	{ 0x99da, 0x234f6e },
	{ 0x99db, 0x216f79 },
	{ 0x99dc, 0x22556f },
	{ 0x99dd, 0x216f76 },
	{ 0x99de, 0x234f72 },
	{ 0x99df, 0x216f78 },
	{ 0x99e0, 0x234f74 },
	{ 0x99e1, 0x235370 },
	{ 0x99e2, 0x21732e },
	{ 0x99e3, 0x225b72 },
	{ 0x99e4, 0x225b70 },
	{ 0x99e5, 0x225b6f },
	{ 0x99e6, 0x235371 },
	{ 0x99e7, 0x225b75 },
	{ 0x99e8, 0x23536b },
	{ 0x99e9, 0x225b74 },
	{ 0x99ea, 0x225b73 },
	{ 0x99eb, 0x23536c },
	{ 0x99ec, 0x225b6e },
	{ 0x99ed, 0x21732d },
	{ 0x99ee, 0x225b6d },
	{ 0x99ef, 0x23536a },
	{ 0x99f0, 0x225b71 },
	{ 0x99f1, 0x21732f },
	{ 0x99f3, 0x235734 },
	{ 0x99f4, 0x226066 },
	{ 0x99f5, 0x235737 },
	{ 0x99f6, 0x22606a },
	{ 0x99f7, 0x226067 },
	{ 0x99f8, 0x226069 },
	{ 0x99f9, 0x226068 },
	{ 0x99fa, 0x226065 },
	{ 0x99fb, 0x22606b },
	{ 0x99fc, 0x22606e },
	{ 0x99fd, 0x22606c },
	{ 0x99fe, 0x22606d },
	{ 0x99ff, 0x21762c },
	{ 0x9a00, 0x235733 },
	{ 0x9a01, 0x21762b },
	{ 0x9a02, 0x226064 },
	{ 0x9a03, 0x22606f },
	{ 0x9a04, 0x22645d },
	{ 0x9a05, 0x226460 },
	{ 0x9a06, 0x226462 },
	{ 0x9a07, 0x226461 },
	{ 0x9a08, 0x23596a },
	{ 0x9a09, 0x22645b },
	{ 0x9a0a, 0x22645f },
	{ 0x9a0b, 0x22645a },
	{ 0x9a0c, 0x23596b },
	{ 0x9a0d, 0x22645c },
	{ 0x9a0e, 0x217777 },
	{ 0x9a0f, 0x226459 },
	{ 0x9a10, 0x23596d },
	{ 0x9a11, 0x22645e },
	{ 0x9a14, 0x22682d },
	{ 0x9a15, 0x226822 },
	{ 0x9a16, 0x217951 },
	{ 0x9a17, 0x235b6f },
	{ 0x9a18, 0x235b6d },
	{ 0x9a19, 0x217952 },
	{ 0x9a1a, 0x226821 },
	{ 0x9a1b, 0x226826 },
	{ 0x9a1c, 0x22682c },
	{ 0x9a1d, 0x226824 },
	{ 0x9a1e, 0x22682b },
	{ 0x9a1f, 0x235b6c },
	{ 0x9a20, 0x226828 },
	{ 0x9a21, 0x235b6e },
	{ 0x9a22, 0x226827 },
	{ 0x9a23, 0x22682a },
	{ 0x9a24, 0x226825 },
	{ 0x9a25, 0x226823 },
	{ 0x9a26, 0x235b6b },
	{ 0x9a27, 0x226829 },
	{ 0x9a29, 0x226a6e },
	{ 0x9a2a, 0x226a6c },
	{ 0x9a2b, 0x217a55 },
	{ 0x9a2c, 0x226a6b },
	{ 0x9a2d, 0x226a71 },
	{ 0x9a2e, 0x226a6f },
	{ 0x9a2f, 0x235d5a },
	{ 0x9a30, 0x217a56 },
	{ 0x9a31, 0x226a6a },
	{ 0x9a32, 0x226a68 },
	{ 0x9a33, 0x246546 },
	{ 0x9a34, 0x226a69 },
	{ 0x9a35, 0x217a58 },
	{ 0x9a36, 0x226a6d },
	{ 0x9a37, 0x217a57 },
	{ 0x9a38, 0x226a70 },
	{ 0x9a39, 0x226c66 },
	{ 0x9a3a, 0x226c6c },
	{ 0x9a3b, 0x235f24 },
	{ 0x9a3c, 0x235f22 },
	{ 0x9a3d, 0x226c67 },
	{ 0x9a3e, 0x217b47 },
	{ 0x9a3f, 0x226c6d },
	{ 0x9a40, 0x217b46 },
	{ 0x9a41, 0x226c6b },
	{ 0x9a42, 0x226c6a },
	{ 0x9a43, 0x217b45 },
	{ 0x9a44, 0x226c69 },
	{ 0x9a45, 0x217b44 },
	{ 0x9a46, 0x226c68 },
	{ 0x9a47, 0x275651 },
	{ 0x9a48, 0x226e4c },
	{ 0x9a49, 0x226e4e },
	{ 0x9a4a, 0x226e4d },
	{ 0x9a4b, 0x24696a },
	{ 0x9a4c, 0x226e4a },
	{ 0x9a4d, 0x217c27 },
	{ 0x9a4e, 0x226e47 },
	{ 0x9a4f, 0x226e4b },
	{ 0x9a50, 0x226e50 },
	{ 0x9a51, 0x235f79 },
	{ 0x9a52, 0x226e4f },
	{ 0x9a53, 0x226e48 },
	{ 0x9a54, 0x226e49 },
	{ 0x9a55, 0x217c26 },
	{ 0x9a56, 0x226f60 },
	{ 0x9a57, 0x217c53 },
	{ 0x9a58, 0x236062 },
	{ 0x9a59, 0x226f61 },
	{ 0x9a5a, 0x217c51 },
	{ 0x9a5b, 0x217c52 },
	{ 0x9a5c, 0x236061 },
	{ 0x9a5d, 0x246c3d },
	{ 0x9a5e, 0x227061 },
	{ 0x9a5f, 0x217c75 },
	{ 0x9a60, 0x227165 },
	{ 0x9a61, 0x236172 },
	{ 0x9a62, 0x217d37 },
	{ 0x9a63, 0x236173 },
	{ 0x9a64, 0x227223 },
	{ 0x9a65, 0x217d38 },
	{ 0x9a66, 0x227224 },
	{ 0x9a67, 0x227225 },
	{ 0x9a68, 0x227233 },
	{ 0x9a69, 0x227232 },
	{ 0x9a6a, 0x217d47 },
	{ 0x9a6b, 0x22723b },
	{ 0x9aa8, 0x21586c },
	{ 0x9aa9, 0x23402f },
	{ 0x9aaa, 0x244221 },
	{ 0x9aab, 0x22486f },
	{ 0x9aac, 0x24417d },
	{ 0x9aad, 0x22486e },
	{ 0x9aae, 0x24417e },
	{ 0x9aaf, 0x216b73 },
	{ 0x9ab0, 0x216b74 },
	{ 0x9ab1, 0x224f42 },
	{ 0x9ab2, 0x244e74 },
	{ 0x9ab3, 0x22557b },
	{ 0x9ab4, 0x225b78 },
	{ 0x9ab5, 0x234f77 },
	{ 0x9ab6, 0x234f76 },
	{ 0x9ab7, 0x216f7e },
	{ 0x9ab8, 0x217330 },
	{ 0x9ab9, 0x225b76 },
	{ 0x9aba, 0x245531 },
	{ 0x9abb, 0x225b79 },
	{ 0x9abc, 0x217331 },
	{ 0x9abd, 0x23573a },
	{ 0x9abe, 0x226070 },
	{ 0x9abf, 0x225b77 },
	{ 0x9ac0, 0x226463 },
	{ 0x9ac1, 0x217778 },
	{ 0x9ac2, 0x22682e },
	{ 0x9ac3, 0x246249 },
	{ 0x9ac4, 0x235d61 },
	{ 0x9ac6, 0x226a74 },
	{ 0x9ac7, 0x226a72 },
	{ 0x9ac8, 0x235d60 },
	{ 0x9ac9, 0x235d5e },
	{ 0x9aca, 0x226a73 },
	{ 0x9acd, 0x226c6e },
	{ 0x9ace, 0x235f25 },
	{ 0x9acf, 0x217b48 },
	{ 0x9ad0, 0x226e51 },
	{ 0x9ad1, 0x217c56 },
	{ 0x9ad2, 0x217c28 },
	{ 0x9ad3, 0x217c54 },
	{ 0x9ad4, 0x217c55 },
	{ 0x9ad5, 0x227062 },
	{ 0x9ad6, 0x217d2f },
	{ 0x9ad7, 0x236174 },
	{ 0x9ad8, 0x21586d },
	{ 0x9ad9, 0x24362d },
	{ 0x9ada, 0x234a6e },
	{ 0x9adb, 0x244e79 },
	{ 0x9adc, 0x226464 },
	{ 0x9add, 0x235f7b },
	{ 0x9ade, 0x236063 },
	{ 0x9adf, 0x22334c },
	{ 0x9ae0, 0x234032 },
	{ 0x9ae1, 0x21676c },
	{ 0x9ae2, 0x234561 },
	{ 0x9ae3, 0x224f43 },
	{ 0x9ae4, 0x234a6f },
	{ 0x9ae5, 0x234a73 },
	{ 0x9ae6, 0x216b75 },
	{ 0x9ae7, 0x224f44 },
	{ 0x9ae8, 0x234a71 },
	{ 0x9ae9, 0x234a70 },
	{ 0x9aea, 0x234a72 },
	{ 0x9aeb, 0x22557d },
	{ 0x9aec, 0x22557c },
	{ 0x9aed, 0x217333 },
	{ 0x9aee, 0x217021 },
	{ 0x9aef, 0x217022 },
	{ 0x9af0, 0x244f21 },
	{ 0x9af1, 0x225622 },
	{ 0x9af2, 0x225621 },
	{ 0x9af3, 0x22557e },
	{ 0x9af4, 0x234f79 },
	{ 0x9af5, 0x235375 },
	{ 0x9af6, 0x225b7a },
	{ 0x9af7, 0x225b7d },
	{ 0x9af8, 0x235374 },
	{ 0x9af9, 0x225b7c },
	{ 0x9afa, 0x225b7b },
	{ 0x9afb, 0x217332 },
	{ 0x9afc, 0x226074 },
	{ 0x9afd, 0x226072 },
	{ 0x9afe, 0x226071 },
	{ 0x9aff, 0x245a37 },
	{ 0x9b00, 0x23573b },
	{ 0x9b01, 0x226073 },
	{ 0x9b02, 0x23573c },
	{ 0x9b03, 0x217779 },
	{ 0x9b04, 0x226466 },
	{ 0x9b05, 0x226467 },
	{ 0x9b06, 0x21777a },
	{ 0x9b07, 0x23596f },
	{ 0x9b08, 0x226465 },
	{ 0x9b09, 0x235b71 },
	{ 0x9b0a, 0x226830 },
	{ 0x9b0b, 0x22682f },
	{ 0x9b0c, 0x226832 },
	{ 0x9b0d, 0x217953 },
	{ 0x9b0e, 0x226831 },
	{ 0x9b0f, 0x24624f },
	{ 0x9b10, 0x226a75 },
	{ 0x9b11, 0x226a77 },
	{ 0x9b12, 0x226a76 },
	{ 0x9b14, 0x235f27 },
	{ 0x9b15, 0x226c6f },
	{ 0x9b16, 0x226c72 },
	{ 0x9b17, 0x226c70 },
	{ 0x9b18, 0x226c71 },
	{ 0x9b19, 0x226e52 },
	{ 0x9b1a, 0x217c29 },
	{ 0x9b1b, 0x246974 },
	{ 0x9b1c, 0x246971 },
	{ 0x9b1d, 0x236672 },
	{ 0x9b1e, 0x226f62 },
	{ 0x9b1f, 0x226f63 },
	{ 0x9b20, 0x226f64 },
	{ 0x9b21, 0x23612c },
	{ 0x9b22, 0x217c76 },
	{ 0x9b23, 0x217d30 },
	{ 0x9b24, 0x227226 },
	{ 0x9b25, 0x21586e },
	{ 0x9b26, 0x234a75 },
	{ 0x9b27, 0x217023 },
	{ 0x9b28, 0x217334 },
	{ 0x9b29, 0x226468 },
	{ 0x9b2a, 0x235d62 },
	{ 0x9b2b, 0x226e53 },
	{ 0x9b2c, 0x23612e },
	{ 0x9b2d, 0x246d37 },
	{ 0x9b2e, 0x227166 },
	{ 0x9b2f, 0x22334d },
	{ 0x9b30, 0x236228 },
	{ 0x9b31, 0x217d48 },
	{ 0x9b32, 0x21586f },
	{ 0x9b33, 0x225b7e },
	{ 0x9b34, 0x23573e },
	{ 0x9b35, 0x226469 },
	{ 0x9b37, 0x226833 },
	{ 0x9b38, 0x235d63 },
	{ 0x9b39, 0x246836 },
	{ 0x9b3a, 0x226c73 },
	{ 0x9b3b, 0x226e54 },
	{ 0x9b3c, 0x215870 },
	{ 0x9b3d, 0x234562 },
	{ 0x9b3e, 0x224f45 },
	{ 0x9b3f, 0x224f46 },
	{ 0x9b40, 0x234a78 },
	{ 0x9b41, 0x216b76 },
	{ 0x9b42, 0x216b77 },
	{ 0x9b43, 0x225624 },
	{ 0x9b44, 0x217025 },
	{ 0x9b45, 0x217024 },
	{ 0x9b46, 0x225623 },
	{ 0x9b48, 0x226075 },
	{ 0x9b49, 0x23573f },
	{ 0x9b4a, 0x22646a },
	{ 0x9b4b, 0x22646c },
	{ 0x9b4c, 0x22646b },
	{ 0x9b4d, 0x21777d },
	{ 0x9b4e, 0x21777c },
	{ 0x9b4f, 0x21777b },
	{ 0x9b50, 0x235d64 },
	{ 0x9b51, 0x217b4a },
	{ 0x9b52, 0x226c74 },
	{ 0x9b53, 0x235f28 },
	{ 0x9b54, 0x217b49 },
	{ 0x9b55, 0x226e56 },
	{ 0x9b56, 0x226e55 },
	{ 0x9b57, 0x23612f },
	{ 0x9b58, 0x217c77 },
	{ 0x9b59, 0x227063 },
	{ 0x9b5a, 0x215e23 },
	{ 0x9b5b, 0x224870 },
	{ 0x9b5c, 0x244229 },
	{ 0x9b5d, 0x234563 },
	{ 0x9b5f, 0x224f49 },
	{ 0x9b60, 0x224f47 },
	{ 0x9b61, 0x224f48 },
	{ 0x9b62, 0x24486b },
	{ 0x9b63, 0x234f7e },
	{ 0x9b64, 0x22562d },
	{ 0x9b65, 0x244f30 },
	{ 0x9b66, 0x225628 },
	{ 0x9b67, 0x225625 },
	{ 0x9b68, 0x22562c },
	{ 0x9b69, 0x234f7c },
	{ 0x9b6a, 0x244f35 },
	{ 0x9b6b, 0x234f7b },
	{ 0x9b6c, 0x22562e },
	{ 0x9b6d, 0x244f37 },
	{ 0x9b6e, 0x244f2c },
	{ 0x9b6f, 0x217027 },
	{ 0x9b70, 0x22562b },
	{ 0x9b71, 0x225627 },
	{ 0x9b72, 0x234f7d },
	{ 0x9b73, 0x244f2a },
	{ 0x9b74, 0x225626 },
	{ 0x9b75, 0x22562a },
	{ 0x9b76, 0x225629 },
	{ 0x9b77, 0x217026 },
	{ 0x9b79, 0x2f533e },
	{ 0x9b7a, 0x225c2b },
	{ 0x9b7b, 0x225c26 },
	{ 0x9b7c, 0x225c24 },
	{ 0x9b7d, 0x225c2d },
	{ 0x9b7e, 0x225c25 },
	{ 0x9b7f, 0x245547 },
	{ 0x9b80, 0x225c21 },
	{ 0x9b81, 0x245543 },
	{ 0x9b82, 0x225c27 },
	{ 0x9b83, 0x235378 },
	{ 0x9b84, 0x23537a },
	{ 0x9b85, 0x225c22 },
	{ 0x9b86, 0x22607e },
	{ 0x9b87, 0x225c23 },
	{ 0x9b88, 0x225c2e },
	{ 0x9b89, 0x235423 },
	{ 0x9b8a, 0x245545 },
	{ 0x9b8b, 0x23537c },
	{ 0x9b8c, 0x235421 },
	{ 0x9b8d, 0x255a4a },
	{ 0x9b8e, 0x235425 },
	{ 0x9b8f, 0x23537d },
	{ 0x9b90, 0x225c2a },
	{ 0x9b91, 0x217335 },
	{ 0x9b92, 0x225c29 },
	{ 0x9b93, 0x225c28 },
	{ 0x9b94, 0x235379 },
	{ 0x9b95, 0x225c2c },
	{ 0x9b96, 0x2f5938 },
	{ 0x9b98, 0x236673 },
	{ 0x9b99, 0x235744 },
	{ 0x9b9a, 0x226076 },
	{ 0x9b9b, 0x226079 },
	{ 0x9b9c, 0x245a49 },
	{ 0x9b9d, 0x235745 },
	{ 0x9b9e, 0x226078 },
	{ 0x9b9f, 0x235740 },
	{ 0x9ba0, 0x226122 },
	{ 0x9ba1, 0x22607b },
	{ 0x9ba2, 0x226121 },
	{ 0x9ba3, 0x235742 },
	{ 0x9ba4, 0x22607d },
	{ 0x9ba5, 0x22607c },
	{ 0x9ba6, 0x22607a },
	{ 0x9ba7, 0x245a41 },
	{ 0x9ba8, 0x226077 },
	{ 0x9ba9, 0x245a3f },
	{ 0x9baa, 0x21762f },
	{ 0x9bab, 0x21762e },
	{ 0x9bac, 0x245a44 },
	{ 0x9bad, 0x217630 },
	{ 0x9bae, 0x21762d },
	{ 0x9baf, 0x226123 },
	{ 0x9bb0, 0x245a45 },
	{ 0x9bb1, 0x2f5d76 },
	{ 0x9bb3, 0x245a43 },
	{ 0x9bb5, 0x226472 },
	{ 0x9bb6, 0x226475 },
	{ 0x9bb7, 0x245f26 },
	{ 0x9bb8, 0x226473 },
	{ 0x9bb9, 0x226477 },
	{ 0x9bba, 0x256679 },
	{ 0x9bbb, 0x235974 },
	{ 0x9bbc, 0x245f22 },
	{ 0x9bbd, 0x226478 },
	{ 0x9bbe, 0x245f2a },
	{ 0x9bbf, 0x226470 },
	{ 0x9bc0, 0x217824 },
	{ 0x9bc1, 0x226471 },
	{ 0x9bc2, 0x235973 },
	{ 0x9bc3, 0x22646f },
	{ 0x9bc4, 0x226476 },
	{ 0x9bc5, 0x235b74 },
	{ 0x9bc6, 0x22646e },
	{ 0x9bc7, 0x22646d },
	{ 0x9bc8, 0x217823 },
	{ 0x9bc9, 0x217821 },
	{ 0x9bca, 0x21777e },
	{ 0x9bcb, 0x235976 },
	{ 0x9bcc, 0x235975 },
	{ 0x9bcd, 0x235743 },
	{ 0x9bcf, 0x2f6172 },
	{ 0x9bd2, 0x235971 },
	{ 0x9bd3, 0x226474 },
	{ 0x9bd4, 0x22683c },
	{ 0x9bd5, 0x226842 },
	{ 0x9bd6, 0x217956 },
	{ 0x9bd7, 0x22683d },
	{ 0x9bd8, 0x256b33 },
	{ 0x9bd9, 0x226840 },
	{ 0x9bda, 0x226844 },
	{ 0x9bdb, 0x217957 },
	{ 0x9bdc, 0x22683f },
	{ 0x9bdd, 0x24625c },
	{ 0x9bde, 0x226837 },
	{ 0x9bdf, 0x235b75 },
	{ 0x9be0, 0x226836 },
	{ 0x9be1, 0x226843 },
	{ 0x9be2, 0x22683a },
	{ 0x9be3, 0x235b77 },
	{ 0x9be4, 0x226838 },
	{ 0x9be5, 0x226841 },
	{ 0x9be6, 0x226839 },
	{ 0x9be7, 0x217955 },
	{ 0x9be8, 0x217954 },
	{ 0x9be9, 0x235b79 },
	{ 0x9bea, 0x226834 },
	{ 0x9beb, 0x226835 },
	{ 0x9bec, 0x22683e },
	{ 0x9bed, 0x246266 },
	{ 0x9bee, 0x235b7a },
	{ 0x9bef, 0x246268 },
	{ 0x9bf0, 0x22683b },
	{ 0x9bf3, 0x2f646b },
	{ 0x9bf4, 0x246255 },
	{ 0x9bf6, 0x235d6f },
	{ 0x9bf7, 0x226a7a },
	{ 0x9bf8, 0x226a7d },
	{ 0x9bf9, 0x235d71 },
	{ 0x9bfa, 0x246256 },
	{ 0x9bfb, 0x235d67 },
	{ 0x9bfc, 0x235d69 },
	{ 0x9bfd, 0x217822 },
	{ 0x9bfe, 0x235d6a },
	{ 0x9bff, 0x235d74 },
	{ 0x9c00, 0x235d75 },
	{ 0x9c01, 0x24655a },
	{ 0x9c02, 0x235d6e },
	{ 0x9c03, 0x246559 },
	{ 0x9c04, 0x235d68 },
	{ 0x9c05, 0x226a7b },
	{ 0x9c06, 0x226b23 },
	{ 0x9c07, 0x226b21 },
	{ 0x9c08, 0x226a79 },
	{ 0x9c09, 0x226b26 },
	{ 0x9c0a, 0x235d66 },
	{ 0x9c0b, 0x226a78 },
	{ 0x9c0c, 0x235d76 },
	{ 0x9c0d, 0x217a5a },
	{ 0x9c0e, 0x226b22 },
	{ 0x9c0f, 0x246554 },
	{ 0x9c10, 0x235d73 },
	{ 0x9c11, 0x246557 },
	{ 0x9c12, 0x226a7c },
	{ 0x9c13, 0x217a59 },
	{ 0x9c14, 0x226b25 },
	{ 0x9c15, 0x235d72 },
	{ 0x9c16, 0x24655d },
	{ 0x9c17, 0x226b24 },
	{ 0x9c1b, 0x235d70 },
	{ 0x9c1c, 0x226c77 },
	{ 0x9c1d, 0x226c76 },
	{ 0x9c1e, 0x257251 },
	{ 0x9c1f, 0x235f2c },
	{ 0x9c20, 0x25724b },
	{ 0x9c21, 0x226c7d },
	{ 0x9c22, 0x25724e },
	{ 0x9c23, 0x226c79 },
	{ 0x9c24, 0x226c7c },
	{ 0x9c25, 0x217b4c },
	{ 0x9c26, 0x24683b },
	{ 0x9c27, 0x24683e },
	{ 0x9c28, 0x226c7a },
	{ 0x9c29, 0x226c7b },
	{ 0x9c2a, 0x246839 },
	{ 0x9c2b, 0x226c75 },
	{ 0x9c2c, 0x226c78 },
	{ 0x9c2d, 0x217b4b },
	{ 0x9c2e, 0x235f2a },
	{ 0x9c2f, 0x2f692a },
	{ 0x9c31, 0x217c2b },
	{ 0x9c32, 0x226e61 },
	{ 0x9c33, 0x226e5c },
	{ 0x9c34, 0x226e60 },
	{ 0x9c35, 0x236025 },
	{ 0x9c36, 0x226e63 },
	{ 0x9c37, 0x226e5f },
	{ 0x9c38, 0x235f7e },
	{ 0x9c39, 0x226e5b },
	{ 0x9c3a, 0x236023 },
	{ 0x9c3b, 0x217c2d },
	{ 0x9c3c, 0x226e5e },
	{ 0x9c3d, 0x226e62 },
	{ 0x9c3e, 0x217c2c },
	{ 0x9c3f, 0x226e59 },
	{ 0x9c40, 0x226a7e },
	{ 0x9c41, 0x226e5d },
	{ 0x9c42, 0x246a23 },
	{ 0x9c43, 0x25752d },
	{ 0x9c44, 0x226e5a },
	{ 0x9c45, 0x236022 },
	{ 0x9c46, 0x226e57 },
	{ 0x9c47, 0x2f6a3e },
	{ 0x9c48, 0x226e58 },
	{ 0x9c49, 0x217c2a },
	{ 0x9c4a, 0x226f68 },
	{ 0x9c4b, 0x226f6a },
	{ 0x9c4c, 0x226f6d },
	{ 0x9c4d, 0x226f69 },
	{ 0x9c4e, 0x226f6e },
	{ 0x9c4f, 0x236065 },
	{ 0x9c50, 0x226f67 },
	{ 0x9c51, 0x236066 },
	{ 0x9c52, 0x226f65 },
	{ 0x9c53, 0x236068 },
	{ 0x9c54, 0x217c57 },
	{ 0x9c55, 0x226f6b },
	{ 0x9c56, 0x217c59 },
	{ 0x9c57, 0x217c58 },
	{ 0x9c58, 0x226f66 },
	{ 0x9c59, 0x226f6c },
	{ 0x9c5d, 0x236132 },
	{ 0x9c5e, 0x227068 },
	{ 0x9c5f, 0x217c78 },
	{ 0x9c60, 0x227069 },
	{ 0x9c61, 0x236133 },
	{ 0x9c62, 0x227067 },
	{ 0x9c63, 0x227064 },
	{ 0x9c64, 0x246c4a },
	{ 0x9c65, 0x236134 },
	{ 0x9c66, 0x227066 },
	{ 0x9c67, 0x227065 },
	{ 0x9c68, 0x227149 },
	{ 0x9c6c, 0x236159 },
	{ 0x9c6d, 0x22714b },
	{ 0x9c6e, 0x22714a },
	{ 0x9c6f, 0x23615b },
	{ 0x9c71, 0x227169 },
	{ 0x9c72, 0x257a53 },
	{ 0x9c73, 0x227168 },
	{ 0x9c74, 0x227167 },
	{ 0x9c75, 0x22716a },
	{ 0x9c76, 0x236175 },
	{ 0x9c77, 0x217d40 },
	{ 0x9c78, 0x217d41 },
	{ 0x9c79, 0x227238 },
	{ 0x9c7a, 0x22723c },
	{ 0x9c7b, 0x236241 },
	{ 0x9ce5, 0x215e24 },
	{ 0x9ce6, 0x224154 },
	{ 0x9ce7, 0x224873 },
	{ 0x9ce8, 0x234564 },
	{ 0x9ce9, 0x21676d },
	{ 0x9cea, 0x224871 },
	{ 0x9ceb, 0x234566 },
	{ 0x9cec, 0x232f42 },
	{ 0x9ced, 0x224872 },
	{ 0x9cee, 0x234568 },
	{ 0x9cef, 0x234567 },
	{ 0x9cf1, 0x224f4a },
	{ 0x9cf2, 0x224f4b },
	{ 0x9cf3, 0x216b7a },
	{ 0x9cf4, 0x216b78 },
	{ 0x9cf5, 0x224f4c },
	{ 0x9cf6, 0x216b79 },
	{ 0x9cf7, 0x225633 },
	{ 0x9cf8, 0x235027 },
	{ 0x9cf9, 0x225636 },
	{ 0x9cfa, 0x225630 },
	{ 0x9cfb, 0x225637 },
	{ 0x9cfc, 0x22562f },
	{ 0x9cfd, 0x225631 },
	{ 0x9cfe, 0x23502a },
	{ 0x9cff, 0x225632 },
	{ 0x9d00, 0x225635 },
	{ 0x9d01, 0x235024 },
	{ 0x9d02, 0x23502b },
	{ 0x9d03, 0x21702a },
	{ 0x9d04, 0x22563a },
	{ 0x9d05, 0x225639 },
	{ 0x9d06, 0x217028 },
	{ 0x9d07, 0x225634 },
	{ 0x9d08, 0x225638 },
	{ 0x9d09, 0x217029 },
	{ 0x9d0a, 0x23542d },
	{ 0x9d0b, 0x244f42 },
	{ 0x9d0c, 0x235025 },
	{ 0x9d0d, 0x235022 },
	{ 0x9d0f, 0x23542a },
	{ 0x9d10, 0x225c38 },
	{ 0x9d11, 0x245552 },
	{ 0x9d12, 0x21733a },
	{ 0x9d13, 0x23542c },
	{ 0x9d14, 0x225c33 },
	{ 0x9d15, 0x217336 },
	{ 0x9d16, 0x235436 },
	{ 0x9d17, 0x225c30 },
	{ 0x9d18, 0x225c36 },
	{ 0x9d19, 0x225c39 },
	{ 0x9d1a, 0x235433 },
	{ 0x9d1b, 0x21733b },
	{ 0x9d1c, 0x245a4e },
	{ 0x9d1d, 0x225c35 },
	{ 0x9d1e, 0x225c32 },
	{ 0x9d1f, 0x225c3a },
	{ 0x9d20, 0x225c31 },
	{ 0x9d21, 0x235437 },
	{ 0x9d22, 0x225c37 },
	{ 0x9d23, 0x217337 },
	{ 0x9d24, 0x235429 },
	{ 0x9d25, 0x225c2f },
	{ 0x9d26, 0x217338 },
	{ 0x9d27, 0x235435 },
	{ 0x9d28, 0x217339 },
	{ 0x9d29, 0x225c34 },
	{ 0x9d2a, 0x235432 },
	{ 0x9d2d, 0x226135 },
	{ 0x9d2e, 0x226128 },
	{ 0x9d2f, 0x226129 },
	{ 0x9d30, 0x22612c },
	{ 0x9d31, 0x22612a },
	{ 0x9d32, 0x245a55 },
	{ 0x9d33, 0x226124 },
	{ 0x9d34, 0x245a56 },
	{ 0x9d35, 0x23574d },
	{ 0x9d36, 0x226127 },
	{ 0x9d37, 0x226131 },
	{ 0x9d38, 0x22612b },
	{ 0x9d39, 0x235748 },
	{ 0x9d3a, 0x245a4f },
	{ 0x9d3b, 0x217631 },
	{ 0x9d3c, 0x245a4d },
	{ 0x9d3d, 0x226133 },
	{ 0x9d3e, 0x226130 },
	{ 0x9d3f, 0x217632 },
	{ 0x9d40, 0x226132 },
	{ 0x9d41, 0x226125 },
	{ 0x9d42, 0x22612e },
	{ 0x9d43, 0x22612f },
	{ 0x9d44, 0x23574a },
	{ 0x9d45, 0x22612d },
	{ 0x9d47, 0x2f5e24 },
	{ 0x9d49, 0x236675 },
	{ 0x9d4a, 0x22647c },
	{ 0x9d4b, 0x22647e },
	{ 0x9d4c, 0x226523 },
	{ 0x9d4d, 0x235979 },
	{ 0x9d4e, 0x23597b },
	{ 0x9d4f, 0x22647b },
	{ 0x9d50, 0x23597d },
	{ 0x9d51, 0x217825 },
	{ 0x9d52, 0x226525 },
	{ 0x9d53, 0x22647a },
	{ 0x9d54, 0x226526 },
	{ 0x9d55, 0x23597e },
	{ 0x9d56, 0x226522 },
	{ 0x9d57, 0x226524 },
	{ 0x9d58, 0x226528 },
	{ 0x9d59, 0x226521 },
	{ 0x9d5a, 0x226529 },
	{ 0x9d5b, 0x22647d },
	{ 0x9d5c, 0x226479 },
	{ 0x9d5d, 0x217826 },
	{ 0x9d5e, 0x235a22 },
	{ 0x9d5f, 0x226527 },
	{ 0x9d60, 0x217827 },
	{ 0x9d61, 0x217959 },
	{ 0x9d62, 0x245f34 },
	{ 0x9d63, 0x23597a },
	{ 0x9d64, 0x2f6177 },
	{ 0x9d66, 0x235b7d },
	{ 0x9d67, 0x226126 },
	{ 0x9d68, 0x22685e },
	{ 0x9d69, 0x226855 },
	{ 0x9d6a, 0x21795b },
	{ 0x9d6b, 0x226851 },
	{ 0x9d6c, 0x21795c },
	{ 0x9d6d, 0x235c27 },
	{ 0x9d6e, 0x235c22 },
	{ 0x9d6f, 0x22685a },
	{ 0x9d70, 0x226854 },
	{ 0x9d71, 0x22684a },
	{ 0x9d72, 0x21795a },
	{ 0x9d73, 0x226857 },
	{ 0x9d74, 0x226852 },
	{ 0x9d75, 0x226853 },
	{ 0x9d76, 0x235c25 },
	{ 0x9d77, 0x226845 },
	{ 0x9d78, 0x22684c },
	{ 0x9d79, 0x22685b },
	{ 0x9d7a, 0x235b7e },
	{ 0x9d7b, 0x226858 },
	{ 0x9d7c, 0x256b3f },
	{ 0x9d7d, 0x226850 },
	{ 0x9d7e, 0x235c26 },
	{ 0x9d7f, 0x22685c },
	{ 0x9d80, 0x22684b },
	{ 0x9d81, 0x226846 },
	{ 0x9d82, 0x226859 },
	{ 0x9d83, 0x235c24 },
	{ 0x9d84, 0x226848 },
	{ 0x9d85, 0x226856 },
	{ 0x9d86, 0x22684d },
	{ 0x9d87, 0x22685d },
	{ 0x9d88, 0x226849 },
	{ 0x9d89, 0x217958 },
	{ 0x9d8a, 0x226847 },
	{ 0x9d8b, 0x22684e },
	{ 0x9d8c, 0x22684f },
	{ 0x9d90, 0x226b2d },
	{ 0x9d91, 0x235c23 },
	{ 0x9d92, 0x226b2b },
	{ 0x9d93, 0x246569 },
	{ 0x9d94, 0x226b30 },
	{ 0x9d95, 0x235d79 },
	{ 0x9d96, 0x226b3c },
	{ 0x9d97, 0x226b33 },
	{ 0x9d98, 0x226b2c },
	{ 0x9d99, 0x226b28 },
	{ 0x9d9a, 0x226b35 },
	{ 0x9d9b, 0x226b2e },
	{ 0x9d9c, 0x226b31 },
	{ 0x9d9d, 0x226b2a },
	{ 0x9d9e, 0x226b38 },
	{ 0x9d9f, 0x226b27 },
	{ 0x9da0, 0x226b2f },
	{ 0x9da1, 0x226b34 },
	{ 0x9da2, 0x226b36 },
	{ 0x9da3, 0x226b39 },
	{ 0x9da4, 0x226b29 },
	{ 0x9da5, 0x235d7a },
	{ 0x9da6, 0x226b3d },
	{ 0x9da7, 0x226b3e },
	{ 0x9da8, 0x226b37 },
	{ 0x9da9, 0x226b3b },
	{ 0x9daa, 0x226b32 },
	{ 0x9dac, 0x226d2f },
	{ 0x9dad, 0x226d32 },
	{ 0x9dae, 0x235f35 },
	{ 0x9daf, 0x217b4d },
	{ 0x9db0, 0x235f31 },
	{ 0x9db1, 0x226d31 },
	{ 0x9db2, 0x226d36 },
	{ 0x9db3, 0x226d34 },
	{ 0x9db4, 0x217b4e },
	{ 0x9db5, 0x226d2b },
	{ 0x9db6, 0x226d21 },
	{ 0x9db7, 0x226c7e },
	{ 0x9db8, 0x217b50 },
	{ 0x9db9, 0x226d2d },
	{ 0x9dba, 0x226d2e },
	{ 0x9dbb, 0x226d2a },
	{ 0x9dbc, 0x226d22 },
	{ 0x9dbd, 0x235f32 },
	{ 0x9dbe, 0x226d27 },
	{ 0x9dbf, 0x226b3a },
	{ 0x9dc0, 0x246843 },
	{ 0x9dc1, 0x226d23 },
	{ 0x9dc2, 0x217b4f },
	{ 0x9dc3, 0x226d29 },
	{ 0x9dc4, 0x235f36 },
	{ 0x9dc5, 0x226d28 },
	{ 0x9dc7, 0x226d24 },
	{ 0x9dc8, 0x226d30 },
	{ 0x9dc9, 0x246844 },
	{ 0x9dca, 0x226d25 },
	{ 0x9dcb, 0x226e68 },
	{ 0x9dcc, 0x226d33 },
	{ 0x9dcd, 0x226d35 },
	{ 0x9dce, 0x226d2c },
	{ 0x9dcf, 0x226d26 },
	{ 0x9dd0, 0x226e69 },
	{ 0x9dd1, 0x226e6b },
	{ 0x9dd2, 0x226e65 },
	{ 0x9dd3, 0x217c2e },
	{ 0x9dd4, 0x246a25 },
	{ 0x9dd5, 0x226e72 },
	{ 0x9dd6, 0x226e70 },
	{ 0x9dd7, 0x217c2f },
	{ 0x9dd8, 0x226e6f },
	{ 0x9dd9, 0x226e6e },
	{ 0x9dda, 0x226e67 },
	{ 0x9ddb, 0x226e64 },
	{ 0x9ddc, 0x226e6a },
	{ 0x9ddd, 0x226e73 },
	{ 0x9dde, 0x226e66 },
	{ 0x9ddf, 0x226e6c },
	{ 0x9de0, 0x257545 },
	{ 0x9de1, 0x226f77 },
	{ 0x9de2, 0x226f7c },
	{ 0x9de3, 0x226f72 },
	{ 0x9de4, 0x226f75 },
	{ 0x9de5, 0x217c5a },
	{ 0x9de6, 0x226f79 },
	{ 0x9de7, 0x246b46 },
	{ 0x9de8, 0x227022 },
	{ 0x9de9, 0x226e6d },
	{ 0x9dea, 0x246b4a },
	{ 0x9deb, 0x226f73 },
	{ 0x9dec, 0x226f7d },
	{ 0x9ded, 0x227023 },
	{ 0x9dee, 0x226f78 },
	{ 0x9def, 0x226f71 },
	{ 0x9df0, 0x226f7b },
	{ 0x9df1, 0x246b4b },
	{ 0x9df2, 0x226f7a },
	{ 0x9df3, 0x227021 },
	{ 0x9df4, 0x226f7e },
	{ 0x9df5, 0x226e71 },
	{ 0x9df6, 0x226f76 },
	{ 0x9df7, 0x226f70 },
	{ 0x9df8, 0x226f74 },
	{ 0x9df9, 0x217c79 },
	{ 0x9dfa, 0x217c7a },
	{ 0x9dfb, 0x226f6f },
	{ 0x9dfc, 0x23606c },
	{ 0x9dfd, 0x227074 },
	{ 0x9dfe, 0x22706b },
	{ 0x9dff, 0x227073 },
	{ 0x9e00, 0x227070 },
	{ 0x9e01, 0x227071 },
	{ 0x9e02, 0x22706a },
	{ 0x9e03, 0x22706d },
	{ 0x9e04, 0x227075 },
	{ 0x9e05, 0x22706f },
	{ 0x9e06, 0x22706e },
	{ 0x9e07, 0x22706c },
	{ 0x9e08, 0x236135 },
	{ 0x9e09, 0x227072 },
	{ 0x9e0a, 0x246c56 },
	{ 0x9e0b, 0x22714c },
	{ 0x9e0c, 0x246d3a },
	{ 0x9e0d, 0x22714d },
	{ 0x9e0e, 0x23615d },
	{ 0x9e0f, 0x22714f },
	{ 0x9e10, 0x22714e },
	{ 0x9e11, 0x227151 },
	{ 0x9e12, 0x227150 },
	{ 0x9e13, 0x22716c },
	{ 0x9e14, 0x22716b },
	{ 0x9e15, 0x227227 },
	{ 0x9e16, 0x236229 },
	{ 0x9e17, 0x227228 },
	{ 0x9e18, 0x236230 },
	{ 0x9e19, 0x227234 },
	{ 0x9e1a, 0x217d45 },
	{ 0x9e1b, 0x217d49 },
	{ 0x9e1c, 0x236238 },
	{ 0x9e1d, 0x22723d },
	{ 0x9e1e, 0x217d4a },
	{ 0x9e75, 0x215e25 },
	{ 0x9e76, 0x244f48 },
	{ 0x9e77, 0x255a5b },
	{ 0x9e79, 0x217a5b },
	{ 0x9e7a, 0x226d37 },
	{ 0x9e7b, 0x235f37 },
	{ 0x9e7c, 0x217c7b },
	{ 0x9e7d, 0x217c7c },
	{ 0x9e7f, 0x215e26 },
	{ 0x9e80, 0x224874 },
	{ 0x9e81, 0x234569 },
	{ 0x9e82, 0x21676e },
	{ 0x9e83, 0x22563b },
	{ 0x9e84, 0x23502c },
	{ 0x9e85, 0x235439 },
	{ 0x9e86, 0x225c3c },
	{ 0x9e87, 0x225c3d },
	{ 0x9e88, 0x225c3b },
	{ 0x9e89, 0x226137 },
	{ 0x9e8a, 0x226136 },
	{ 0x9e8b, 0x217633 },
	{ 0x9e8c, 0x22652b },
	{ 0x9e8d, 0x226138 },
	{ 0x9e8e, 0x22652a },
	{ 0x9e8f, 0x245f3a },
	{ 0x9e90, 0x235a24 },
	{ 0x9e91, 0x226860 },
	{ 0x9e92, 0x21795d },
	{ 0x9e93, 0x21795f },
	{ 0x9e94, 0x22685f },
	{ 0x9e95, 0x235c29 },
	{ 0x9e96, 0x246275 },
	{ 0x9e97, 0x21795e },
	{ 0x9e98, 0x235e21 },
	{ 0x9e99, 0x226b3f },
	{ 0x9e9a, 0x226b41 },
	{ 0x9e9b, 0x226b40 },
	{ 0x9e9c, 0x226d38 },
	{ 0x9e9d, 0x217b51 },
	{ 0x9e9e, 0x235f3a },
	{ 0x9e9f, 0x217c5b },
	{ 0x9ea0, 0x227076 },
	{ 0x9ea1, 0x227152 },
	{ 0x9ea2, 0x236231 },
	{ 0x9ea3, 0x23623f },
	{ 0x9ea4, 0x227241 },
	{ 0x9ea5, 0x215e27 },
	{ 0x9ea6, 0x232547 },
	{ 0x9ea7, 0x224f4d },
	{ 0x9ea8, 0x244f4c },
	{ 0x9ea9, 0x21702b },
	{ 0x9eaa, 0x23502f },
	{ 0x9eab, 0x23502e },
	{ 0x9eac, 0x23543a },
	{ 0x9ead, 0x225c3f },
	{ 0x9eae, 0x225c3e },
	{ 0x9eaf, 0x235750 },
	{ 0x9eb0, 0x226139 },
	{ 0x9eb1, 0x235a26 },
	{ 0x9eb2, 0x235a25 },
	{ 0x9eb3, 0x24627e },
	{ 0x9eb4, 0x217960 },
	{ 0x9eb5, 0x217a5c },
	{ 0x9eb6, 0x226e74 },
	{ 0x9eb7, 0x227239 },
	{ 0x9ebb, 0x215e28 },
	{ 0x9ebc, 0x216b7b },
	{ 0x9ebd, 0x234b22 },
	{ 0x9ebe, 0x21702c },
	{ 0x9ebf, 0x2f617c },
	{ 0x9ec0, 0x226861 },
	{ 0x9ec1, 0x235e22 },
	{ 0x9ec2, 0x227024 },
	{ 0x9ec3, 0x216327 },
	{ 0x9ec4, 0x23396a },
	{ 0x9ec5, 0x23543c },
	{ 0x9ec6, 0x23543b },
	{ 0x9ec7, 0x245a5d },
	{ 0x9ec8, 0x22613a },
	{ 0x9eca, 0x235a28 },
	{ 0x9ecb, 0x245f3e },
	{ 0x9ecc, 0x217d31 },
	{ 0x9ecd, 0x216328 },
	{ 0x9ece, 0x21702d },
	{ 0x9ecf, 0x217634 },
	{ 0x9ed0, 0x227025 },
	{ 0x9ed1, 0x216329 },
	{ 0x9ed2, 0x23396b },
	{ 0x9ed3, 0x22563c },
	{ 0x9ed4, 0x21733d },
	{ 0x9ed5, 0x225c40 },
	{ 0x9ed6, 0x225c41 },
	{ 0x9ed7, 0x23543d },
	{ 0x9ed8, 0x21733c },
	{ 0x9ed9, 0x245560 },
	{ 0x9eda, 0x22613b },
	{ 0x9edb, 0x217638 },
	{ 0x9edc, 0x217636 },
	{ 0x9edd, 0x217637 },
	{ 0x9ede, 0x217635 },
	{ 0x9edf, 0x22652c },
	{ 0x9ee0, 0x217828 },
	{ 0x9ee2, 0x246324 },
	{ 0x9ee3, 0x235c2a },
	{ 0x9ee4, 0x226b43 },
	{ 0x9ee5, 0x226b42 },
	{ 0x9ee6, 0x226b45 },
	{ 0x9ee7, 0x226b44 },
	{ 0x9ee8, 0x217a5d },
	{ 0x9eeb, 0x226d39 },
	{ 0x9eec, 0x246856 },
	{ 0x9eed, 0x226d3b },
	{ 0x9eee, 0x226d3a },
	{ 0x9eef, 0x217b52 },
	{ 0x9ef0, 0x226e75 },
	{ 0x9ef1, 0x236029 },
	{ 0x9ef2, 0x227026 },
	{ 0x9ef3, 0x227027 },
	{ 0x9ef4, 0x217c5c },
	{ 0x9ef5, 0x227153 },
	{ 0x9ef6, 0x22716d },
	{ 0x9ef7, 0x217d42 },
	{ 0x9ef8, 0x246e43 },
	{ 0x9ef9, 0x224155 },
	{ 0x9efa, 0x225c42 },
	{ 0x9efb, 0x22613c },
	{ 0x9efc, 0x226862 },
	{ 0x9efd, 0x224875 },
	{ 0x9efe, 0x232772 },
	{ 0x9eff, 0x22613d },
	{ 0x9f00, 0x22652e },
	{ 0x9f01, 0x22652d },
	{ 0x9f02, 0x235a29 },
	{ 0x9f03, 0x235c2d },
	{ 0x9f04, 0x235c2e },
	{ 0x9f05, 0x235f3c },
	{ 0x9f06, 0x227028 },
	{ 0x9f07, 0x217c7d },
	{ 0x9f08, 0x23615f },
	{ 0x9f09, 0x227154 },
	{ 0x9f0a, 0x22716e },
	{ 0x9f0e, 0x21676f },
	{ 0x9f0f, 0x22563d },
	{ 0x9f10, 0x22563e },
	{ 0x9f11, 0x244f56 },
	{ 0x9f12, 0x225c43 },
	{ 0x9f13, 0x216770 },
	{ 0x9f14, 0x23456a },
	{ 0x9f15, 0x217829 },
	{ 0x9f16, 0x22652f },
	{ 0x9f17, 0x235c30 },
	{ 0x9f18, 0x226d3d },
	{ 0x9f19, 0x217b53 },
	{ 0x9f1a, 0x226d3e },
	{ 0x9f1b, 0x226d3c },
	{ 0x9f1c, 0x227029 },
	{ 0x9f1d, 0x236160 },
	{ 0x9f1e, 0x227077 },
	{ 0x9f1f, 0x246d48 },
	{ 0x9f20, 0x216771 },
	{ 0x9f22, 0x226140 },
	{ 0x9f23, 0x22613f },
	{ 0x9f24, 0x22613e },
	{ 0x9f25, 0x226530 },
	{ 0x9f26, 0x235a2b },
	{ 0x9f27, 0x235a2a },
	{ 0x9f28, 0x226534 },
	{ 0x9f29, 0x226533 },
	{ 0x9f2a, 0x226532 },
	{ 0x9f2b, 0x226531 },
	{ 0x9f2c, 0x21782a },
	{ 0x9f2d, 0x226863 },
	{ 0x9f2e, 0x226b47 },
	{ 0x9f2f, 0x217a5e },
	{ 0x9f30, 0x226b46 },
	{ 0x9f31, 0x226d3f },
	{ 0x9f32, 0x226e78 },
	{ 0x9f33, 0x226e77 },
	{ 0x9f34, 0x217c30 },
	{ 0x9f35, 0x226e76 },
	{ 0x9f36, 0x22702c },
	{ 0x9f37, 0x22702b },
	{ 0x9f38, 0x22702a },
	{ 0x9f39, 0x23606d },
	{ 0x9f3a, 0x246e44 },
	{ 0x9f3b, 0x216b7c },
	{ 0x9f3c, 0x245563 },
	{ 0x9f3d, 0x225c44 },
	{ 0x9f3e, 0x217639 },
	{ 0x9f3f, 0x245a64 },
	{ 0x9f40, 0x226864 },
	{ 0x9f41, 0x226865 },
	{ 0x9f42, 0x226e79 },
	{ 0x9f43, 0x22702d },
	{ 0x9f44, 0x246b5c },
	{ 0x9f45, 0x23613b },
	{ 0x9f46, 0x227078 },
	{ 0x9f47, 0x227155 },
	{ 0x9f48, 0x227229 },
	{ 0x9f49, 0x227243 },
	{ 0x9f4a, 0x216b7d },
	{ 0x9f4b, 0x21763a },
	{ 0x9f4c, 0x226535 },
	{ 0x9f4d, 0x226866 },
	{ 0x9f4e, 0x226d40 },
	{ 0x9f4f, 0x22702e },
	{ 0x9f50, 0x232370 },
	{ 0x9f52, 0x21702f },
	{ 0x9f53, 0x23543e },
	{ 0x9f54, 0x226141 },
	{ 0x9f55, 0x226536 },
	{ 0x9f56, 0x226867 },
	{ 0x9f57, 0x226868 },
	{ 0x9f58, 0x226869 },
	{ 0x9f59, 0x226b4c },
	{ 0x9f5a, 0x235e24 },
	{ 0x9f5b, 0x226b48 },
	{ 0x9f5c, 0x217b54 },
	{ 0x9f5d, 0x226b4b },
	{ 0x9f5e, 0x226b4a },
	{ 0x9f5f, 0x217a5f },
	{ 0x9f60, 0x226b49 },
	{ 0x9f61, 0x217a61 },
	{ 0x9f63, 0x217a60 },
	{ 0x9f64, 0x226d42 },
	{ 0x9f65, 0x226d41 },
	{ 0x9f66, 0x217b55 },
	{ 0x9f67, 0x217b56 },
	{ 0x9f68, 0x246860 },
	{ 0x9f69, 0x235f3e },
	{ 0x9f6a, 0x217c32 },
	{ 0x9f6b, 0x226e7a },
	{ 0x9f6c, 0x217c31 },
	{ 0x9f6d, 0x246b61 },
	{ 0x9f6e, 0x227031 },
	{ 0x9f6f, 0x227032 },
	{ 0x9f70, 0x227030 },
	{ 0x9f71, 0x22702f },
	{ 0x9f72, 0x217d21 },
	{ 0x9f73, 0x246c64 },
	{ 0x9f74, 0x227079 },
	{ 0x9f75, 0x22707a },
	{ 0x9f76, 0x22707b },
	{ 0x9f77, 0x217c7e },
	{ 0x9f78, 0x227156 },
	{ 0x9f79, 0x227159 },
	{ 0x9f7a, 0x227158 },
	{ 0x9f7b, 0x227157 },
	{ 0x9f7c, 0x236233 },
	{ 0x9f7d, 0x246e45 },
	{ 0x9f7e, 0x227242 },
	{ 0x9f8d, 0x21733e },
	{ 0x9f8e, 0x235755 },
	{ 0x9f8f, 0x24632d },
	{ 0x9f90, 0x217832 },
	{ 0x9f91, 0x226b4d },
	{ 0x9f92, 0x226d43 },
	{ 0x9f93, 0x23602b },
	{ 0x9f94, 0x217c33 },
	{ 0x9f95, 0x226e7b },
	{ 0x9f96, 0x246e55 },
	{ 0x9f97, 0x236242 },
	{ 0x9f98, 0x227244 },
	{ 0x9f99, 0x2f2159 },
	{ 0x9f9c, 0x21733f },
	{ 0x9f9d, 0x235e47 },
	{ 0x9f9e, 0x246e33 },
	{ 0x9fa0, 0x226142 },
	{ 0x9fa1, 0x235f3f },
	{ 0x9fa2, 0x226e7c },
	{ 0x9fa3, 0x236161 },
	{ 0x9fa4, 0x22716f },
	{ 0x9fa5, 0x236177 },
	{ 0xfa28, 0x2f584c },
	{ 0xfe30, 0x21212b },
	{ 0xfe31, 0x212136 },
	{ 0xfe32, 0x212138 },
	{ 0xfe35, 0x212140 },
	{ 0xfe36, 0x212141 },
	{ 0xfe37, 0x212144 },
	{ 0xfe38, 0x212145 },
	{ 0xfe39, 0x212148 },
	{ 0xfe3a, 0x212149 },
	{ 0xfe3b, 0x21214c },
	{ 0xfe3c, 0x21214d },
	{ 0xfe3d, 0x212150 },
	{ 0xfe3e, 0x212151 },
	{ 0xfe3f, 0x212154 },
	{ 0xfe40, 0x212155 },
	{ 0xfe41, 0x212158 },
	{ 0xfe42, 0x212159 },
	{ 0xfe43, 0x21215c },
	{ 0xfe44, 0x21215d },
	{ 0xfe49, 0x212227 },
	{ 0xfe4a, 0x212228 },
	{ 0xfe4b, 0x21222b },
	{ 0xfe4c, 0x21222c },
	{ 0xfe4d, 0x212229 },
	{ 0xfe4e, 0x21222a },
	{ 0xfe50, 0x21212e },
	{ 0xfe51, 0x21212f },
	{ 0xfe52, 0x212130 },
	{ 0xfe54, 0x212132 },
	{ 0xfe55, 0x212133 },
	{ 0xfe56, 0x212134 },
	{ 0xfe57, 0x212135 },
	{ 0xfe59, 0x21215e },
	{ 0xfe5a, 0x21215f },
	{ 0xfe5b, 0x212160 },
	{ 0xfe5c, 0x212161 },
	{ 0xfe5d, 0x212162 },
	{ 0xfe5e, 0x212163 },
	{ 0xfe5f, 0x21222d },
	{ 0xfe60, 0x21222e },
	{ 0xfe61, 0x21222f },
	{ 0xfe62, 0x21223f },
	{ 0xfe63, 0x212240 },
	{ 0xfe64, 0x212241 },
	{ 0xfe65, 0x212243 },
	{ 0xfe66, 0x212242 },
	{ 0xfe68, 0x212262 },
	{ 0xfe69, 0x21226c },
	{ 0xfe6a, 0x21226d },
	{ 0xfe6b, 0x21226e },
	{ 0xff01, 0x21212a },
	{ 0xff03, 0x21216c },
	{ 0xff04, 0x212263 },
	{ 0xff05, 0x212268 },
	{ 0xff06, 0x21216d },
	{ 0xff08, 0x21213e },
	{ 0xff09, 0x21213f },
	{ 0xff0a, 0x21216e },
	{ 0xff0b, 0x212230 },
	{ 0xff0c, 0x212122 },
	{ 0xff0d, 0x212231 },
	{ 0xff0e, 0x212125 },
	{ 0xff0f, 0x21225f },
	{ 0xff10, 0x212421 },
	{ 0xff11, 0x212422 },
	{ 0xff12, 0x212423 },
	{ 0xff13, 0x212424 },
	{ 0xff14, 0x212425 },
	{ 0xff15, 0x212426 },
	{ 0xff16, 0x212427 },
	{ 0xff17, 0x212428 },
	{ 0xff18, 0x212429 },
	{ 0xff19, 0x21242a },
	{ 0xff1a, 0x212128 },
	{ 0xff1b, 0x212127 },
	{ 0xff1c, 0x212236 },
	{ 0xff1d, 0x212238 },
	{ 0xff1e, 0x212237 },
	{ 0xff1f, 0x212129 },
	{ 0xff20, 0x212269 },
	{ 0xff21, 0x212441 },
	{ 0xff22, 0x212442 },
	{ 0xff23, 0x212443 },
	{ 0xff24, 0x212444 },
	{ 0xff25, 0x212445 },
	{ 0xff26, 0x212446 },
	{ 0xff27, 0x212447 },
	{ 0xff28, 0x212448 },
	{ 0xff29, 0x212449 },
	{ 0xff2a, 0x21244a },
	{ 0xff2b, 0x21244b },
	{ 0xff2c, 0x21244c },
	{ 0xff2d, 0x21244d },
	{ 0xff2e, 0x21244e },
	{ 0xff2f, 0x21244f },
	{ 0xff30, 0x212450 },
	{ 0xff31, 0x212451 },
	{ 0xff32, 0x212452 },
	{ 0xff33, 0x212453 },
	{ 0xff34, 0x212454 },
	{ 0xff35, 0x212455 },
	{ 0xff36, 0x212456 },
	{ 0xff37, 0x212457 },
	{ 0xff38, 0x212458 },
	{ 0xff39, 0x212459 },
	{ 0xff3a, 0x21245a },
	{ 0xff3c, 0x212260 },
	{ 0xff3f, 0x212225 },
	{ 0xff41, 0x21245b },
	{ 0xff42, 0x21245c },
	{ 0xff43, 0x21245d },
	{ 0xff44, 0x21245e },
	{ 0xff45, 0x21245f },
	{ 0xff46, 0x212460 },
	{ 0xff47, 0x212461 },
	{ 0xff48, 0x212462 },
	{ 0xff49, 0x212463 },
	{ 0xff4a, 0x212464 },
	{ 0xff4b, 0x212465 },
	{ 0xff4c, 0x212466 },
	{ 0xff4d, 0x212467 },
	{ 0xff4e, 0x212468 },
	{ 0xff4f, 0x212469 },
	{ 0xff50, 0x21246a },
	{ 0xff51, 0x21246b },
	{ 0xff52, 0x21246c },
	{ 0xff53, 0x21246d },
	{ 0xff54, 0x21246e },
	{ 0xff55, 0x21246f },
	{ 0xff56, 0x212470 },
	{ 0xff57, 0x212471 },
	{ 0xff58, 0x212472 },
	{ 0xff59, 0x212473 },
	{ 0xff5a, 0x212474 },
	{ 0xff5b, 0x212142 },
	{ 0xff5c, 0x21225e },
	{ 0xff5d, 0x212143 },
	{ 0xffe0, 0x212266 },
	{ 0xffe1, 0x212267 },
	{ 0xffe5, 0x212264 },
	{ 0x20000, 0x252125 },
	{ 0x20002, 0x2f2121 },
	{ 0x20003, 0x26212f },
	{ 0x20004, 0x26212d },
	{ 0x20005, 0x26212e },
	{ 0x20007, 0x262142 },
	{ 0x20008, 0x262143 },
	{ 0x20009, 0x252133 },
	{ 0x2000b, 0x232144 },
	{ 0x2000f, 0x2f213e },
	{ 0x20010, 0x2f213f },
	{ 0x20012, 0x26222b },
	{ 0x20014, 0x25214d },
	{ 0x20018, 0x262340 },
	{ 0x20019, 0x26233e },
	{ 0x2001a, 0x26233f },
	{ 0x20020, 0x262467 },
	{ 0x20021, 0x26255f },
	{ 0x20022, 0x25232f },
	{ 0x20023, 0x2f2274 },
	{ 0x20025, 0x262567 },
	{ 0x20029, 0x262563 },
	{ 0x2002c, 0x262937 },
	{ 0x2002d, 0x26293a },
	{ 0x2002e, 0x262938 },
	{ 0x20035, 0x2f2922 },
	{ 0x20036, 0x2f2923 },
	{ 0x2003b, 0x262e66 },
	{ 0x20041, 0x253072 },
	{ 0x20043, 0x253323 },
	{ 0x20046, 0x2f3932 },
	{ 0x20047, 0x2f3933 },
	{ 0x20048, 0x26472d },
	{ 0x2004b, 0x2f3b73 },
	{ 0x2004c, 0x2f4035 },
	{ 0x2004d, 0x2f4075 },
	{ 0x20052, 0x2f4742 },
	{ 0x20053, 0x2f4d56 },
	{ 0x20055, 0x272121 },
	{ 0x20056, 0x2f5947 },
	{ 0x20057, 0x244f7c },
	{ 0x2005b, 0x2f5a3f },
	{ 0x20061, 0x26212c },
	{ 0x20062, 0x262122 },
	{ 0x20064, 0x26225f },
	{ 0x20065, 0x242156 },
	{ 0x20066, 0x262341 },
	{ 0x20067, 0x262560 },
	{ 0x20069, 0x26293b },
	{ 0x2006b, 0x252521 },
	{ 0x2006d, 0x25277a },
	{ 0x2006e, 0x262e4a },
	{ 0x2006f, 0x2f2950 },
	{ 0x20070, 0x263525 },
	{ 0x20071, 0x263526 },
	{ 0x20072, 0x26457d },
	{ 0x20074, 0x26463f },
	{ 0x20076, 0x2f4640 },
	{ 0x20077, 0x25447e },
	{ 0x2007d, 0x262132 },
	{ 0x2007e, 0x25212d },
	{ 0x2007f, 0x26222d },
	{ 0x20082, 0x262342 },
	{ 0x20083, 0x2f2d61 },
	{ 0x20084, 0x265050 },
	{ 0x20085, 0x2f5344 },
	{ 0x20086, 0x242121 },
	{ 0x20087, 0x252126 },
	{ 0x20088, 0x262124 },
	{ 0x2008c, 0x2f2122 },
	{ 0x2008d, 0x262133 },
	{ 0x2008f, 0x262144 },
	{ 0x20092, 0x2f2125 },
	{ 0x20093, 0x2f2126 },
	{ 0x20094, 0x25214e },
	{ 0x20095, 0x262230 },
	{ 0x20097, 0x2f2145 },
	{ 0x20098, 0x26224e },
	{ 0x20099, 0x26222f },
	{ 0x2009a, 0x2f2140 },
	{ 0x2009b, 0x2f2141 },
	{ 0x2009c, 0x262145 },
	{ 0x2009e, 0x262231 },
	{ 0x200a0, 0x26222e },
	{ 0x200a2, 0x242226 },
	{ 0x200a3, 0x242225 },
	{ 0x200a4, 0x252224 },
	{ 0x200a5, 0x252225 },
	{ 0x200a8, 0x262343 },
	{ 0x200a9, 0x26293e },
	{ 0x200ac, 0x26245d },
	{ 0x200ae, 0x262556 },
	{ 0x200af, 0x262561 },
	{ 0x200b0, 0x262562 },
	{ 0x200b1, 0x262c43 },
	{ 0x200b2, 0x26293c },
	{ 0x200b3, 0x263a65 },
	{ 0x200b4, 0x2f2925 },
	{ 0x200b5, 0x262d2d },
	{ 0x200b6, 0x26293d },
	{ 0x200b7, 0x262e4b },
	{ 0x200b9, 0x252b67 },
	{ 0x200ba, 0x26352a },
	{ 0x200bc, 0x263527 },
	{ 0x200bd, 0x263964 },
	{ 0x200be, 0x263529 },
	{ 0x200bf, 0x263c7b },
	{ 0x200c2, 0x26457e },
	{ 0x200c3, 0x264640 },
	{ 0x200c4, 0x264641 },
	{ 0x200c6, 0x253d56 },
	{ 0x200c9, 0x252123 },
	{ 0x200cb, 0x252122 },
	{ 0x200cf, 0x262126 },
	{ 0x200d0, 0x262125 },
	{ 0x200d1, 0x252121 },
	{ 0x200d2, 0x25212b },
	{ 0x200d4, 0x2f2123 },
	{ 0x200d5, 0x262146 },
	{ 0x200d6, 0x252134 },
	{ 0x200d8, 0x2f2127 },
	{ 0x200d9, 0x2f2128 },
	{ 0x200de, 0x262233 },
	{ 0x200df, 0x262232 },
	{ 0x200e0, 0x26222a },
	{ 0x200e1, 0x25214f },
	{ 0x200e4, 0x262346 },
	{ 0x200e5, 0x262344 },
	{ 0x200e6, 0x2f216e },
	{ 0x200e7, 0x262345 },
	{ 0x200ea, 0x2f2275 },
	{ 0x200ed, 0x26293f },
	{ 0x200f0, 0x262d2c },
	{ 0x200f1, 0x242624 },
	{ 0x200f2, 0x262e4d },
	{ 0x200f3, 0x262e4e },
	{ 0x200f4, 0x2f2540 },
	{ 0x200f6, 0x262e4c },
	{ 0x200f8, 0x26352b },
	{ 0x200fb, 0x2f2d60 },
	{ 0x200fc, 0x263c7e },
	{ 0x200fd, 0x253073 },
	{ 0x200fe, 0x263c7d },
	{ 0x20102, 0x2f3934 },
	{ 0x20104, 0x265051 },
	{ 0x20105, 0x254455 },
	{ 0x20106, 0x2f4641 },
	{ 0x20107, 0x265a63 },
	{ 0x20108, 0x265a62 },
	{ 0x20109, 0x273673 },
	{ 0x2010a, 0x274627 },
	{ 0x2010b, 0x274d3a },
	{ 0x2010c, 0x252124 },
	{ 0x2010d, 0x252127 },
	{ 0x2010e, 0x242128 },
	{ 0x2010f, 0x252128 },
	{ 0x20111, 0x25212c },
	{ 0x20112, 0x262147 },
	{ 0x20113, 0x262148 },
	{ 0x20114, 0x262149 },
	{ 0x20115, 0x262347 },
	{ 0x20116, 0x252330 },
	{ 0x20117, 0x262564 },
	{ 0x20119, 0x262940 },
	{ 0x2011a, 0x253074 },
	{ 0x2011b, 0x264642 },
	{ 0x2011d, 0x272c3c },
	{ 0x2011e, 0x262127 },
	{ 0x2011f, 0x262128 },
	{ 0x20120, 0x262129 },
	{ 0x20121, 0x26214a },
	{ 0x20122, 0x262565 },
	{ 0x20123, 0x262348 },
	{ 0x20124, 0x262349 },
	{ 0x20128, 0x262568 },
	{ 0x2012a, 0x2f2276 },
	{ 0x2012c, 0x242533 },
	{ 0x2012d, 0x252522 },
	{ 0x2012e, 0x242532 },
	{ 0x20130, 0x262e50 },
	{ 0x20131, 0x25277b },
	{ 0x20132, 0x2f2927 },
	{ 0x20134, 0x26307c },
	{ 0x20135, 0x26352d },
	{ 0x20137, 0x26352c },
	{ 0x20138, 0x2f2d62 },
	{ 0x20139, 0x263d21 },
	{ 0x20140, 0x2f4d6e },
	{ 0x20143, 0x26234a },
	{ 0x20144, 0x2f216f },
	{ 0x20145, 0x2f2170 },
	{ 0x20147, 0x2f222b },
	{ 0x20148, 0x252331 },
	{ 0x20149, 0x2f2277 },
	{ 0x2014a, 0x2f2278 },
	{ 0x2014b, 0x2f2279 },
	{ 0x2014c, 0x252523 },
	{ 0x2014f, 0x262941 },
	{ 0x20151, 0x2f2543 },
	{ 0x20153, 0x262e52 },
	{ 0x20154, 0x262e51 },
	{ 0x20155, 0x2f2928 },
	{ 0x20156, 0x26352f },
	{ 0x20157, 0x252c66 },
	{ 0x20158, 0x242b5f },
	{ 0x20159, 0x263530 },
	{ 0x2015d, 0x2f2d63 },
	{ 0x2015e, 0x263531 },
	{ 0x2015f, 0x264643 },
	{ 0x20160, 0x263d23 },
	{ 0x20161, 0x263d22 },
	{ 0x20162, 0x243044 },
	{ 0x20163, 0x253075 },
	{ 0x20164, 0x2f3274 },
	{ 0x20165, 0x2f3275 },
	{ 0x20167, 0x2f3272 },
	{ 0x20169, 0x264645 },
	{ 0x2016a, 0x264644 },
	{ 0x2016b, 0x264646 },
	{ 0x2016c, 0x24362f },
	{ 0x2016d, 0x2f3935 },
	{ 0x2016e, 0x2f3936 },
	{ 0x2016f, 0x2f3937 },
	{ 0x20170, 0x264c2d },
	{ 0x20174, 0x2f4036 },
	{ 0x20175, 0x2f4037 },
	{ 0x20176, 0x2f4038 },
	{ 0x2017e, 0x2f4642 },
	{ 0x20180, 0x265052 },
	{ 0x20181, 0x254b71 },
	{ 0x20182, 0x272122 },
	{ 0x20183, 0x2f4d57 },
	{ 0x20184, 0x2f4d58 },
	{ 0x20185, 0x2f4d59 },
	{ 0x20186, 0x272679 },
	{ 0x20187, 0x272124 },
	{ 0x20189, 0x272123 },
	{ 0x2018a, 0x272146 },
	{ 0x2018c, 0x272c3f },
	{ 0x2018e, 0x255353 },
	{ 0x2018f, 0x272c3e },
	{ 0x20192, 0x272c3d },
	{ 0x2019c, 0x274623 },
	{ 0x2019d, 0x274628 },
	{ 0x201a3, 0x262134 },
	{ 0x201a4, 0x262135 },
	{ 0x201a5, 0x2f2124 },
	{ 0x201a6, 0x26214c },
	{ 0x201a7, 0x2f2129 },
	{ 0x201a8, 0x26214b },
	{ 0x201a9, 0x23216f },
	{ 0x201ac, 0x2f2143 },
	{ 0x201ad, 0x262235 },
	{ 0x201af, 0x262234 },
	{ 0x201b0, 0x262236 },
	{ 0x201b2, 0x242158 },
	{ 0x201b4, 0x24222c },
	{ 0x201b5, 0x24222b },
	{ 0x201b6, 0x242229 },
	{ 0x201b7, 0x26234f },
	{ 0x201b8, 0x242230 },
	{ 0x201b9, 0x262350 },
	{ 0x201ba, 0x252227 },
	{ 0x201bb, 0x26234d },
	{ 0x201bc, 0x26234c },
	{ 0x201c2, 0x24222f },
	{ 0x201c3, 0x26234b },
	{ 0x201c4, 0x2f2173 },
	{ 0x201c5, 0x2f2174 },
	{ 0x201c6, 0x2f2175 },
	{ 0x201c7, 0x2f2176 },
	{ 0x201c8, 0x2f2177 },
	{ 0x201c9, 0x2f2178 },
	{ 0x201ca, 0x2f2179 },
	{ 0x201cb, 0x252228 },
	{ 0x201cf, 0x262351 },
	{ 0x201d0, 0x252226 },
	{ 0x201d4, 0x2f217a },
	{ 0x201d8, 0x252332 },
	{ 0x201d9, 0x26256a },
	{ 0x201da, 0x24233a },
	{ 0x201db, 0x26256b },
	{ 0x201dc, 0x262574 },
	{ 0x201dd, 0x262570 },
	{ 0x201de, 0x26256c },
	{ 0x201df, 0x2f227a },
	{ 0x201e0, 0x2f227b },
	{ 0x201e1, 0x2f227c },
	{ 0x201e2, 0x2f227d },
	{ 0x201e3, 0x2f2321 },
	{ 0x201e4, 0x2f2322 },
	{ 0x201e5, 0x2f2323 },
	{ 0x201e6, 0x2f2325 },
	{ 0x201e7, 0x2f2328 },
	{ 0x201e8, 0x2f2329 },
	{ 0x201e9, 0x2f232a },
	{ 0x201ea, 0x2f232b },
	{ 0x201eb, 0x2f232c },
	{ 0x201f1, 0x242338 },
	{ 0x201f2, 0x26256d },
	{ 0x201f4, 0x26256f },
	{ 0x201f7, 0x2f2326 },
	{ 0x201fe, 0x26256e },
	{ 0x201ff, 0x262569 },
	{ 0x20200, 0x252333 },
	{ 0x20201, 0x262573 },
	{ 0x20203, 0x262943 },
	{ 0x20204, 0x262945 },
	{ 0x20205, 0x24253a },
	{ 0x20206, 0x252528 },
	{ 0x20207, 0x262946 },
	{ 0x20208, 0x252529 },
	{ 0x20209, 0x23274e },
	{ 0x2020a, 0x25252a },
	{ 0x2020b, 0x242537 },
	{ 0x2020c, 0x242535 },
	{ 0x2020d, 0x26294a },
	{ 0x2020e, 0x262944 },
	{ 0x2020f, 0x26294c },
	{ 0x20210, 0x262947 },
	{ 0x20211, 0x26294e },
	{ 0x20215, 0x252526 },
	{ 0x20216, 0x262942 },
	{ 0x20217, 0x2f2545 },
	{ 0x20218, 0x2f2546 },
	{ 0x20219, 0x2f2548 },
	{ 0x2021a, 0x2f2549 },
	{ 0x2021b, 0x2f254b },
	{ 0x2021c, 0x2f254c },
	{ 0x2021d, 0x2f254d },
	{ 0x2021e, 0x2f254e },
	{ 0x2021f, 0x2f254f },
	{ 0x20220, 0x2f2550 },
	{ 0x20221, 0x2f2551 },
	{ 0x20222, 0x26294d },
	{ 0x20227, 0x262948 },
	{ 0x20228, 0x262949 },
	{ 0x20229, 0x26294b },
	{ 0x2022a, 0x252524 },
	{ 0x2022c, 0x252527 },
	{ 0x2022d, 0x25277c },
	{ 0x2022e, 0x262e64 },
	{ 0x2022f, 0x262e59 },
	{ 0x20230, 0x252b72 },
	{ 0x20231, 0x242836 },
	{ 0x20232, 0x262e63 },
	{ 0x20233, 0x262e57 },
	{ 0x20234, 0x262e56 },
	{ 0x20235, 0x252823 },
	{ 0x20236, 0x24283b },
	{ 0x20237, 0x262e5d },
	{ 0x20238, 0x25277e },
	{ 0x20239, 0x25277d },
	{ 0x2023a, 0x252822 },
	{ 0x2023b, 0x262e62 },
	{ 0x2023c, 0x262e55 },
	{ 0x2023d, 0x262e54 },
	{ 0x2023e, 0x262e65 },
	{ 0x2023f, 0x262e5c },
	{ 0x20244, 0x2f2929 },
	{ 0x20245, 0x2f292a },
	{ 0x20246, 0x2f292b },
	{ 0x20247, 0x2f292c },
	{ 0x20248, 0x2f292e },
	{ 0x20249, 0x2f292f },
	{ 0x2024a, 0x2f2931 },
	{ 0x2024b, 0x2f2932 },
	{ 0x2024c, 0x2f2933 },
	{ 0x2024d, 0x2f2934 },
	{ 0x2024e, 0x2f2935 },
	{ 0x2024f, 0x2f2936 },
	{ 0x20250, 0x2f2937 },
	{ 0x20251, 0x2f2938 },
	{ 0x20252, 0x262e53 },
	{ 0x20254, 0x262e58 },
	{ 0x20255, 0x262e5b },
	{ 0x20256, 0x262e5e },
	{ 0x20258, 0x262e60 },
	{ 0x2025b, 0x2f2547 },
	{ 0x20261, 0x262e5f },
	{ 0x20262, 0x252824 },
	{ 0x20263, 0x242b63 },
	{ 0x20264, 0x252b70 },
	{ 0x20265, 0x242b67 },
	{ 0x20266, 0x263536 },
	{ 0x20267, 0x252b6b },
	{ 0x20268, 0x263535 },
	{ 0x20269, 0x252b74 },
	{ 0x2026a, 0x242b66 },
	{ 0x2026b, 0x242b68 },
	{ 0x2026c, 0x252b6f },
	{ 0x2026d, 0x263532 },
	{ 0x2026e, 0x252b69 },
	{ 0x20271, 0x2f2d64 },
	{ 0x20272, 0x2f2d6e },
	{ 0x20273, 0x263537 },
	{ 0x20276, 0x252b6e },
	{ 0x20277, 0x2f2d66 },
	{ 0x20278, 0x2f2d67 },
	{ 0x20279, 0x2f2d6a },
	{ 0x2027a, 0x2f2d6b },
	{ 0x2027b, 0x2f2d6c },
	{ 0x2027c, 0x2f2d6d },
	{ 0x2027d, 0x2f2d6f },
	{ 0x2027e, 0x2f2d71 },
	{ 0x2027f, 0x2f2d72 },
	{ 0x20280, 0x2f2d73 },
	{ 0x20281, 0x2f2d74 },
	{ 0x20282, 0x2f2d75 },
	{ 0x20283, 0x2f2d76 },
	{ 0x20284, 0x2f2d78 },
	{ 0x20285, 0x2f2d79 },
	{ 0x20286, 0x2f2d7a },
	{ 0x20287, 0x2f2d7b },
	{ 0x20288, 0x2f2d7c },
	{ 0x2028a, 0x263521 },
	{ 0x2028b, 0x26353a },
	{ 0x2028c, 0x26353b },
	{ 0x20291, 0x263533 },
	{ 0x20292, 0x263534 },
	{ 0x20294, 0x252b68 },
	{ 0x20296, 0x263539 },
	{ 0x2029e, 0x2f2d77 },
	{ 0x202a0, 0x2f2d70 },
	{ 0x202a2, 0x252b6a },
	{ 0x202a3, 0x252b6d },
	{ 0x202a4, 0x252b75 },
	{ 0x202a5, 0x252b71 },
	{ 0x202a6, 0x252b73 },
	{ 0x202a7, 0x242b60 },
	{ 0x202a8, 0x263d2b },
	{ 0x202a9, 0x263d2d },
	{ 0x202aa, 0x263d2c },
	{ 0x202ab, 0x243049 },
	{ 0x202ac, 0x243048 },
	{ 0x202ad, 0x263d30 },
	{ 0x202ae, 0x263d28 },
	{ 0x202b0, 0x253121 },
	{ 0x202b1, 0x263d33 },
	{ 0x202b2, 0x253077 },
	{ 0x202b3, 0x263d2e },
	{ 0x202b4, 0x263d27 },
	{ 0x202b5, 0x253122 },
	{ 0x202b6, 0x253076 },
	{ 0x202b7, 0x243046 },
	{ 0x202b8, 0x263d2a },
	{ 0x202b9, 0x263d31 },
	{ 0x202ba, 0x263d37 },
	{ 0x202bb, 0x263d32 },
	{ 0x202be, 0x263d29 },
	{ 0x202c1, 0x24304b },
	{ 0x202c2, 0x263d34 },
	{ 0x202c3, 0x2f2d69 },
	{ 0x202c4, 0x2f3277 },
	{ 0x202c5, 0x2f3278 },
	{ 0x202c6, 0x2f3279 },
	{ 0x202c7, 0x2f327a },
	{ 0x202c8, 0x2f327b },
	{ 0x202c9, 0x2f327c },
	{ 0x202ca, 0x2f327e },
	{ 0x202cb, 0x2f3321 },
	{ 0x202cc, 0x2f3323 },
	{ 0x202cd, 0x2f3324 },
	{ 0x202ce, 0x2f3325 },
	{ 0x202cf, 0x2f3326 },
	{ 0x202d0, 0x2f3327 },
	{ 0x202d1, 0x264637 },
	{ 0x202d2, 0x263d38 },
	{ 0x202d3, 0x263e65 },
	{ 0x202d4, 0x263d39 },
	{ 0x202d5, 0x263d2f },
	{ 0x202d6, 0x25307a },
	{ 0x202db, 0x264363 },
	{ 0x202dd, 0x25307d },
	{ 0x202e1, 0x253123 },
	{ 0x202e2, 0x263d24 },
	{ 0x202e3, 0x263d26 },
	{ 0x202e5, 0x2f327d },
	{ 0x202e7, 0x253079 },
	{ 0x202e8, 0x25307e },
	{ 0x202e9, 0x253078 },
	{ 0x202ea, 0x263d25 },
	{ 0x202eb, 0x263d36 },
	{ 0x202ec, 0x25307c },
	{ 0x202ed, 0x264649 },
	{ 0x202ee, 0x26464f },
	{ 0x202ef, 0x253656 },
	{ 0x202f0, 0x253651 },
	{ 0x202f1, 0x26464c },
	{ 0x202f2, 0x25364e },
	{ 0x202f3, 0x253652 },
	{ 0x202f4, 0x253663 },
	{ 0x202f5, 0x253653 },
	{ 0x202f6, 0x264648 },
	{ 0x202f7, 0x253655 },
	{ 0x202f8, 0x253650 },
	{ 0x202f9, 0x264656 },
	{ 0x202fa, 0x243635 },
	{ 0x202fb, 0x253654 },
	{ 0x202fc, 0x264652 },
	{ 0x202fd, 0x264650 },
	{ 0x202fe, 0x26464b },
	{ 0x202ff, 0x26464e },
	{ 0x20300, 0x264653 },
	{ 0x20307, 0x2f3276 },
	{ 0x20308, 0x264658 },
	{ 0x20309, 0x25364f },
	{ 0x2030b, 0x253657 },
	{ 0x2030c, 0x264647 },
	{ 0x2030d, 0x2f3938 },
	{ 0x2030e, 0x2f3939 },
	{ 0x2030f, 0x2f393a },
	{ 0x20310, 0x2f393b },
	{ 0x20311, 0x2f393c },
	{ 0x20312, 0x2f393d },
	{ 0x20313, 0x2f393e },
	{ 0x20314, 0x2f393f },
	{ 0x20317, 0x26464d },
	{ 0x20318, 0x24363b },
	{ 0x2031c, 0x264651 },
	{ 0x20320, 0x264654 },
	{ 0x20321, 0x25364d },
	{ 0x20329, 0x26464a },
	{ 0x2032a, 0x253421 },
	{ 0x2032b, 0x26505a },
	{ 0x2032c, 0x244238 },
	{ 0x2032d, 0x253d5a },
	{ 0x2032e, 0x253d58 },
	{ 0x2032f, 0x265053 },
	{ 0x20330, 0x25307b },
	{ 0x20331, 0x253d5e },
	{ 0x20332, 0x253d5c },
	{ 0x20333, 0x265058 },
	{ 0x20334, 0x253d5b },
	{ 0x20335, 0x26505f },
	{ 0x20336, 0x26505d },
	{ 0x20337, 0x243c2e },
	{ 0x20339, 0x26505c },
	{ 0x2033a, 0x265062 },
	{ 0x2033b, 0x265055 },
	{ 0x2033c, 0x243c2f },
	{ 0x2033e, 0x253d60 },
	{ 0x2033f, 0x265054 },
	{ 0x20340, 0x253d57 },
	{ 0x20344, 0x265057 },
	{ 0x20348, 0x26505e },
	{ 0x20349, 0x2f4039 },
	{ 0x2034a, 0x2f403a },
	{ 0x2034b, 0x2f403b },
	{ 0x2034c, 0x2f403c },
	{ 0x2034d, 0x2f403d },
	{ 0x2034e, 0x2f403e },
	{ 0x2034f, 0x2f403f },
	{ 0x20350, 0x2f4040 },
	{ 0x20351, 0x2f4041 },
	{ 0x20352, 0x2f4042 },
	{ 0x20353, 0x2f4043 },
	{ 0x20354, 0x2f4044 },
	{ 0x20355, 0x2f4045 },
	{ 0x20356, 0x2f4046 },
	{ 0x20358, 0x265061 },
	{ 0x2035e, 0x26564e },
	{ 0x2035f, 0x265059 },
	{ 0x20362, 0x265056 },
	{ 0x20367, 0x264657 },
	{ 0x20368, 0x253d59 },
	{ 0x20369, 0x253d5d },
	{ 0x2036a, 0x253d5f },
	{ 0x2036b, 0x243c2b },
	{ 0x2036c, 0x265060 },
	{ 0x2036e, 0x265a71 },
	{ 0x2036f, 0x253d61 },
	{ 0x20370, 0x27212e },
	{ 0x20371, 0x244234 },
	{ 0x20372, 0x254456 },
	{ 0x20373, 0x265a64 },
	{ 0x20374, 0x265a69 },
	{ 0x20375, 0x253d62 },
	{ 0x20376, 0x265a6b },
	{ 0x20377, 0x244239 },
	{ 0x20378, 0x265a74 },
	{ 0x20379, 0x244231 },
	{ 0x2037a, 0x265a75 },
	{ 0x2037b, 0x265a68 },
	{ 0x20382, 0x265a67 },
	{ 0x20383, 0x265a76 },
	{ 0x20384, 0x2f4643 },
	{ 0x20385, 0x2f4644 },
	{ 0x20386, 0x2f4645 },
	{ 0x20387, 0x2f4646 },
	{ 0x20388, 0x2f4647 },
	{ 0x20389, 0x2f4649 },
	{ 0x2038a, 0x2f464a },
	{ 0x2038b, 0x2f464b },
	{ 0x2038c, 0x2f464c },
	{ 0x2038d, 0x2f464d },
	{ 0x2038e, 0x2f464e },
	{ 0x2038f, 0x2f464f },
	{ 0x20390, 0x2f4651 },
	{ 0x20391, 0x2f4652 },
	{ 0x20392, 0x2f4653 },
	{ 0x20393, 0x2f4654 },
	{ 0x20394, 0x2f4656 },
	{ 0x20395, 0x2f4657 },
	{ 0x20396, 0x2f4658 },
	{ 0x20397, 0x2f5345 },
	{ 0x20398, 0x27262d },
	{ 0x20399, 0x254458 },
	{ 0x2039a, 0x265a77 },
	{ 0x2039b, 0x265e57 },
	{ 0x2039e, 0x265a6d },
	{ 0x203a1, 0x265a6f },
	{ 0x203a2, 0x265a65 },
	{ 0x203a3, 0x2f4650 },
	{ 0x203a7, 0x2f4648 },
	{ 0x203ac, 0x2f4655 },
	{ 0x203ae, 0x244230 },
	{ 0x203af, 0x265a66 },
	{ 0x203b0, 0x265a6a },
	{ 0x203b1, 0x265a6e },
	{ 0x203b2, 0x265a70 },
	{ 0x203b3, 0x244236 },
	{ 0x203b6, 0x253f46 },
	{ 0x203b7, 0x24487e },
	{ 0x203b8, 0x24487a },
	{ 0x203b9, 0x265a6c },
	{ 0x203ba, 0x27212f },
	{ 0x203bb, 0x272131 },
	{ 0x203bc, 0x272129 },
	{ 0x203bd, 0x272126 },
	{ 0x203be, 0x272125 },
	{ 0x203bf, 0x254b77 },
	{ 0x203c0, 0x24487c },
	{ 0x203c1, 0x27212b },
	{ 0x203c2, 0x27212c },
	{ 0x203c3, 0x254b73 },
	{ 0x203c4, 0x27212a },
	{ 0x203c7, 0x254b79 },
	{ 0x203c8, 0x254b78 },
	{ 0x203ca, 0x272127 },
	{ 0x203cc, 0x2f4d5a },
	{ 0x203cd, 0x2f4d5b },
	{ 0x203ce, 0x2f4d5c },
	{ 0x203cf, 0x2f4d5d },
	{ 0x203d0, 0x2f4d5e },
	{ 0x203d1, 0x2f4d60 },
	{ 0x203d2, 0x2f4d61 },
	{ 0x203d4, 0x272128 },
	{ 0x203d6, 0x254b72 },
	{ 0x203d7, 0x27212d },
	{ 0x203da, 0x2f4d62 },
	{ 0x203e1, 0x244921 },
	{ 0x203e2, 0x254b75 },
	{ 0x203e3, 0x272130 },
	{ 0x203e4, 0x254b74 },
	{ 0x203e7, 0x254c45 },
	{ 0x203e8, 0x255354 },
	{ 0x203e9, 0x25535a },
	{ 0x203ea, 0x272c40 },
	{ 0x203eb, 0x244f58 },
	{ 0x203ec, 0x244f5f },
	{ 0x203ed, 0x255358 },
	{ 0x203ee, 0x244f5c },
	{ 0x203ef, 0x244f5e },
	{ 0x203f0, 0x255355 },
	{ 0x203f4, 0x255356 },
	{ 0x203f6, 0x2f5346 },
	{ 0x203f7, 0x2f5347 },
	{ 0x203f8, 0x2f5348 },
	{ 0x203fa, 0x2f5349 },
	{ 0x203fb, 0x2f534a },
	{ 0x20400, 0x25535b },
	{ 0x20406, 0x255357 },
	{ 0x20408, 0x273678 },
	{ 0x20409, 0x254b76 },
	{ 0x2040a, 0x255a6f },
	{ 0x2040b, 0x255a70 },
	{ 0x2040c, 0x245567 },
	{ 0x2040d, 0x245566 },
	{ 0x2040e, 0x273676 },
	{ 0x20412, 0x2f5948 },
	{ 0x20415, 0x2f594a },
	{ 0x20416, 0x2f594b },
	{ 0x20417, 0x2f594c },
	{ 0x20418, 0x2f594e },
	{ 0x2041a, 0x273675 },
	{ 0x2041b, 0x273677 },
	{ 0x2041f, 0x2f5949 },
	{ 0x20421, 0x245568 },
	{ 0x20422, 0x273674 },
	{ 0x20423, 0x273e76 },
	{ 0x20424, 0x245a6b },
	{ 0x20425, 0x245a69 },
	{ 0x20426, 0x245a6a },
	{ 0x20427, 0x273e78 },
	{ 0x20428, 0x273e77 },
	{ 0x2042a, 0x2f5e30 },
	{ 0x2042b, 0x2f5e31 },
	{ 0x2042e, 0x2f5e2c },
	{ 0x2042f, 0x2f5e2e },
	{ 0x20430, 0x2f5e2f },
	{ 0x20431, 0x273e75 },
	{ 0x20432, 0x256131 },
	{ 0x20433, 0x245a6c },
	{ 0x20435, 0x25612f },
	{ 0x20436, 0x256130 },
	{ 0x2043a, 0x256132 },
	{ 0x2043b, 0x25674a },
	{ 0x2043c, 0x25674e },
	{ 0x2043d, 0x24632e },
	{ 0x2043e, 0x25674d },
	{ 0x2043f, 0x25674f },
	{ 0x20440, 0x2f617e },
	{ 0x20441, 0x2f6221 },
	{ 0x20442, 0x27476f },
	{ 0x20444, 0x25674c },
	{ 0x20445, 0x25674b },
	{ 0x2044c, 0x25697c },
	{ 0x2044d, 0x275275 },
	{ 0x2044e, 0x274d3c },
	{ 0x2044f, 0x2f647a },
	{ 0x20451, 0x256b6b },
	{ 0x20452, 0x274d3b },
	{ 0x20453, 0x274d68 },
	{ 0x20457, 0x24662f },
	{ 0x20458, 0x24662e },
	{ 0x20459, 0x256f68 },
	{ 0x2045a, 0x27574e },
	{ 0x2045b, 0x256b6c },
	{ 0x2045c, 0x2f673f },
	{ 0x2045d, 0x2f677e },
	{ 0x2045f, 0x24662d },
	{ 0x20464, 0x27574d },
	{ 0x20466, 0x2f6938 },
	{ 0x20467, 0x2f693a },
	{ 0x20468, 0x2f6939 },
	{ 0x20469, 0x257331 },
	{ 0x2046a, 0x246a40 },
	{ 0x2046b, 0x275b45 },
	{ 0x2046d, 0x2f6a4b },
	{ 0x2046e, 0x2f6b41 },
	{ 0x2046f, 0x257562 },
	{ 0x20472, 0x246d52 },
	{ 0x20473, 0x2f6c49 },
	{ 0x20476, 0x26214d },
	{ 0x20477, 0x24215c },
	{ 0x20479, 0x242232 },
	{ 0x2047a, 0x262353 },
	{ 0x2047b, 0x262354 },
	{ 0x2047d, 0x262575 },
	{ 0x2047e, 0x262577 },
	{ 0x2047f, 0x262578 },
	{ 0x20480, 0x252335 },
	{ 0x20481, 0x262576 },
	{ 0x20483, 0x262951 },
	{ 0x20484, 0x262950 },
	{ 0x20485, 0x26294f },
	{ 0x20486, 0x262953 },
	{ 0x20488, 0x2f2553 },
	{ 0x2048a, 0x262952 },
	{ 0x2048b, 0x2f2552 },
	{ 0x2048c, 0x262e67 },
	{ 0x2048d, 0x262e68 },
	{ 0x20490, 0x252b76 },
	{ 0x20493, 0x2f2d7d },
	{ 0x20494, 0x2f2d7e },
	{ 0x20495, 0x2f2e21 },
	{ 0x20496, 0x26353c },
	{ 0x20497, 0x2f3328 },
	{ 0x20498, 0x253124 },
	{ 0x20499, 0x253125 },
	{ 0x2049a, 0x2f3329 },
	{ 0x2049b, 0x2f332a },
	{ 0x2049e, 0x264659 },
	{ 0x2049f, 0x2f3940 },
	{ 0x204a0, 0x2f3941 },
	{ 0x204a1, 0x2f3942 },
	{ 0x204a2, 0x253658 },
	{ 0x204a3, 0x2f3943 },
	{ 0x204a4, 0x2f4047 },
	{ 0x204a8, 0x265063 },
	{ 0x204a9, 0x2f4048 },
	{ 0x204aa, 0x2f4659 },
	{ 0x204ab, 0x2f465a },
	{ 0x204ad, 0x254459 },
	{ 0x204b0, 0x272134 },
	{ 0x204b1, 0x272132 },
	{ 0x204b2, 0x254b7b },
	{ 0x204b3, 0x2f4d63 },
	{ 0x204b4, 0x2f4d64 },
	{ 0x204b5, 0x254b7a },
	{ 0x204b6, 0x272133 },
	{ 0x204b8, 0x25535c },
	{ 0x204b9, 0x272c41 },
	{ 0x204ba, 0x2f534b },
	{ 0x204bb, 0x2f534c },
	{ 0x204bc, 0x2f534d },
	{ 0x204bd, 0x2f534e },
	{ 0x204bf, 0x255a71 },
	{ 0x204c2, 0x2f594f },
	{ 0x204c3, 0x2f5950 },
	{ 0x204c4, 0x2f5951 },
	{ 0x204c6, 0x273e79 },
	{ 0x204c8, 0x256133 },
	{ 0x204c9, 0x2f5e32 },
	{ 0x204cb, 0x274629 },
	{ 0x204cc, 0x256750 },
	{ 0x204cd, 0x2f647b },
	{ 0x204ce, 0x256751 },
	{ 0x204cf, 0x256b6d },
	{ 0x204d2, 0x2f6741 },
	{ 0x204d3, 0x2f693b },
	{ 0x204d5, 0x2f6a4c },
	{ 0x204d7, 0x257753 },
	{ 0x204d8, 0x2f6b42 },
	{ 0x204db, 0x262136 },
	{ 0x204dc, 0x252136 },
	{ 0x204dd, 0x252135 },
	{ 0x204df, 0x262237 },
	{ 0x204e0, 0x262356 },
	{ 0x204e1, 0x262355 },
	{ 0x204e4, 0x252336 },
	{ 0x204e5, 0x262579 },
	{ 0x204e7, 0x252338 },
	{ 0x204ea, 0x252825 },
	{ 0x204eb, 0x252826 },
	{ 0x204ed, 0x242b6a },
	{ 0x204ee, 0x26353d },
	{ 0x204ef, 0x2f2e22 },
	{ 0x204f0, 0x2f2e23 },
	{ 0x204f1, 0x263d3a },
	{ 0x204f3, 0x26465a },
	{ 0x204f4, 0x265064 },
	{ 0x204f6, 0x253d63 },
	{ 0x204f7, 0x243c31 },
	{ 0x204f8, 0x265a78 },
	{ 0x204fd, 0x255a72 },
	{ 0x20500, 0x262137 },
	{ 0x20501, 0x26214e },
	{ 0x20502, 0x252137 },
	{ 0x20503, 0x262141 },
	{ 0x20504, 0x262159 },
	{ 0x20506, 0x252150 },
	{ 0x20507, 0x26233b },
	{ 0x20508, 0x242235 },
	{ 0x20509, 0x262357 },
	{ 0x2050a, 0x26257c },
	{ 0x2050b, 0x26257e },
	{ 0x2050c, 0x252339 },
	{ 0x2050e, 0x2f232d },
	{ 0x2050f, 0x26257a },
	{ 0x20510, 0x262954 },
	{ 0x20512, 0x262e6b },
	{ 0x20513, 0x262e69 },
	{ 0x20515, 0x252827 },
	{ 0x20516, 0x262e6a },
	{ 0x20517, 0x262e4f },
	{ 0x20518, 0x26307b },
	{ 0x20519, 0x263540 },
	{ 0x2051a, 0x26353f },
	{ 0x2051b, 0x263541 },
	{ 0x2051c, 0x26353e },
	{ 0x2051d, 0x263d3b },
	{ 0x2051f, 0x26465d },
	{ 0x20520, 0x253d64 },
	{ 0x20521, 0x2f3944 },
	{ 0x20522, 0x2f3945 },
	{ 0x20525, 0x26465b },
	{ 0x20527, 0x26465c },
	{ 0x20528, 0x253d65 },
	{ 0x20529, 0x265065 },
	{ 0x2052a, 0x2f4049 },
	{ 0x2052b, 0x2f404a },
	{ 0x2052f, 0x24423a },
	{ 0x20531, 0x265a79 },
	{ 0x20533, 0x2f5446 },
	{ 0x20534, 0x2f534f },
	{ 0x20535, 0x2f5350 },
	{ 0x20536, 0x256134 },
	{ 0x20537, 0x2f5e33 },
	{ 0x20538, 0x27462a },
	{ 0x20539, 0x27462b },
	{ 0x2053c, 0x24212d },
	{ 0x2053d, 0x26214f },
	{ 0x2053e, 0x262151 },
	{ 0x20541, 0x262239 },
	{ 0x20542, 0x24215d },
	{ 0x20543, 0x262238 },
	{ 0x20544, 0x252152 },
	{ 0x20546, 0x2f2146 },
	{ 0x20548, 0x26223a },
	{ 0x2054a, 0x252151 },
	{ 0x2054b, 0x26235a },
	{ 0x2054d, 0x262358 },
	{ 0x2054e, 0x262547 },
	{ 0x20550, 0x262623 },
	{ 0x20551, 0x262621 },
	{ 0x20552, 0x262622 },
	{ 0x20553, 0x25233a },
	{ 0x20554, 0x26287a },
	{ 0x20556, 0x25252c },
	{ 0x20558, 0x262955 },
	{ 0x2055a, 0x262956 },
	{ 0x2055b, 0x262e6c },
	{ 0x2055d, 0x263542 },
	{ 0x2055e, 0x263543 },
	{ 0x2055f, 0x252b77 },
	{ 0x20560, 0x252b78 },
	{ 0x20562, 0x263d3d },
	{ 0x20563, 0x26465f },
	{ 0x20564, 0x233977 },
	{ 0x20565, 0x26465e },
	{ 0x20566, 0x243c33 },
	{ 0x20567, 0x253d66 },
	{ 0x20568, 0x265a7b },
	{ 0x20569, 0x265a7a },
	{ 0x2056c, 0x272135 },
	{ 0x2056d, 0x25535d },
	{ 0x2056e, 0x272c42 },
	{ 0x2056f, 0x2f5576 },
	{ 0x20570, 0x245a6d },
	{ 0x20571, 0x2f6742 },
	{ 0x20572, 0x27574f },
	{ 0x20573, 0x252138 },
	{ 0x20575, 0x26223b },
	{ 0x20576, 0x2f2148 },
	{ 0x20577, 0x2f2149 },
	{ 0x20579, 0x26235b },
	{ 0x2057a, 0x242237 },
	{ 0x2057b, 0x252229 },
	{ 0x2057d, 0x2f217b },
	{ 0x20580, 0x2f232e },
	{ 0x20581, 0x2f232f },
	{ 0x20584, 0x25252d },
	{ 0x20585, 0x2f2555 },
	{ 0x2058a, 0x262e6d },
	{ 0x2058c, 0x263d3e },
	{ 0x2058d, 0x2f2e25 },
	{ 0x2058f, 0x2f2e26 },
	{ 0x20590, 0x2f2e27 },
	{ 0x20591, 0x2f2e28 },
	{ 0x20592, 0x2f2e29 },
	{ 0x20593, 0x253127 },
	{ 0x20594, 0x264660 },
	{ 0x20595, 0x2f3947 },
	{ 0x20596, 0x2f3948 },
	{ 0x20597, 0x264661 },
	{ 0x20599, 0x2f3a5d },
	{ 0x2059a, 0x265066 },
	{ 0x2059c, 0x265a7c },
	{ 0x2059e, 0x2f465b },
	{ 0x2059f, 0x254e77 },
	{ 0x205a0, 0x272c43 },
	{ 0x205a1, 0x2f5952 },
	{ 0x205a2, 0x2f5351 },
	{ 0x205a3, 0x273e7a },
	{ 0x205a6, 0x27462c },
	{ 0x205a7, 0x274d3f },
	{ 0x205a9, 0x256f69 },
	{ 0x205ab, 0x257563 },
	{ 0x205ae, 0x2f214a },
	{ 0x205b1, 0x26235c },
	{ 0x205b2, 0x2f217d },
	{ 0x205b4, 0x2f217e },
	{ 0x205b6, 0x242238 },
	{ 0x205b7, 0x25233b },
	{ 0x205b8, 0x262624 },
	{ 0x205b9, 0x24233c },
	{ 0x205ba, 0x2f2330 },
	{ 0x205bb, 0x2f2331 },
	{ 0x205bc, 0x2f2332 },
	{ 0x205bd, 0x2f2333 },
	{ 0x205c0, 0x2f2324 },
	{ 0x205c1, 0x2f227e },
	{ 0x205c2, 0x242541 },
	{ 0x205c3, 0x242542 },
	{ 0x205c4, 0x262958 },
	{ 0x205c5, 0x262959 },
	{ 0x205c6, 0x25252f },
	{ 0x205c7, 0x2f2557 },
	{ 0x205c8, 0x252829 },
	{ 0x205c9, 0x242841 },
	{ 0x205ca, 0x242842 },
	{ 0x205cb, 0x25282c },
	{ 0x205cc, 0x252828 },
	{ 0x205cd, 0x25282a },
	{ 0x205ce, 0x262e6f },
	{ 0x205d1, 0x2f293a },
	{ 0x205d2, 0x2f293c },
	{ 0x205d3, 0x2f293d },
	{ 0x205d4, 0x2f293e },
	{ 0x205d5, 0x2f293f },
	{ 0x205d7, 0x262e6e },
	{ 0x205d8, 0x252b7a },
	{ 0x205d9, 0x242b6b },
	{ 0x205da, 0x252b79 },
	{ 0x205db, 0x25282b },
	{ 0x205dc, 0x263545 },
	{ 0x205dd, 0x252b7b },
	{ 0x205de, 0x2f2e2a },
	{ 0x205e1, 0x2f2e2b },
	{ 0x205e2, 0x263546 },
	{ 0x205e5, 0x253128 },
	{ 0x205e6, 0x263d3f },
	{ 0x205e7, 0x263d40 },
	{ 0x205e8, 0x24304e },
	{ 0x205ea, 0x2f332b },
	{ 0x205ec, 0x2f332c },
	{ 0x205ed, 0x2f332d },
	{ 0x205ee, 0x2f332f },
	{ 0x205ef, 0x2f3330 },
	{ 0x205f1, 0x264662 },
	{ 0x205f2, 0x25365c },
	{ 0x205f3, 0x25365a },
	{ 0x205f4, 0x25365b },
	{ 0x205f5, 0x253659 },
	{ 0x205f6, 0x24363e },
	{ 0x205f7, 0x2f332e },
	{ 0x205fa, 0x253d6c },
	{ 0x205fb, 0x253d67 },
	{ 0x205fc, 0x253d69 },
	{ 0x205fd, 0x253d6a },
	{ 0x205fe, 0x253d68 },
	{ 0x205ff, 0x253d6b },
	{ 0x20600, 0x265067 },
	{ 0x20604, 0x265a7d },
	{ 0x20605, 0x254c21 },
	{ 0x20606, 0x25445a },
	{ 0x20607, 0x272137 },
	{ 0x20608, 0x2f465d },
	{ 0x20609, 0x2f465e },
	{ 0x2060a, 0x254b7e },
	{ 0x2060b, 0x254b7d },
	{ 0x2060c, 0x254b7c },
	{ 0x2060d, 0x272136 },
	{ 0x2060e, 0x2f4d67 },
	{ 0x20611, 0x2f5353 },
	{ 0x20612, 0x272c45 },
	{ 0x20613, 0x2f4d66 },
	{ 0x20614, 0x2f5352 },
	{ 0x20616, 0x24556a },
	{ 0x20617, 0x272c46 },
	{ 0x20618, 0x255a73 },
	{ 0x2061b, 0x2f5953 },
	{ 0x2061c, 0x2f5954 },
	{ 0x2061d, 0x256136 },
	{ 0x2061e, 0x256135 },
	{ 0x2061f, 0x256137 },
	{ 0x20620, 0x2f5e34 },
	{ 0x20621, 0x273e7b },
	{ 0x20622, 0x256752 },
	{ 0x20623, 0x256753 },
	{ 0x20624, 0x275276 },
	{ 0x20625, 0x257332 },
	{ 0x20627, 0x242129 },
	{ 0x20629, 0x262152 },
	{ 0x2062b, 0x2f212a },
	{ 0x2062c, 0x2f212b },
	{ 0x2062d, 0x2f212c },
	{ 0x2062e, 0x2f212e },
	{ 0x2062f, 0x26215c },
	{ 0x20630, 0x2f212d },
	{ 0x20631, 0x252153 },
	{ 0x20632, 0x26223d },
	{ 0x20633, 0x24215f },
	{ 0x20635, 0x26235e },
	{ 0x20636, 0x26235d },
	{ 0x20637, 0x26235f },
	{ 0x20638, 0x262360 },
	{ 0x2063a, 0x2f214b },
	{ 0x2063c, 0x262627 },
	{ 0x2063d, 0x262625 },
	{ 0x2063e, 0x262626 },
	{ 0x2063f, 0x2f2334 },
	{ 0x20640, 0x2f2335 },
	{ 0x20646, 0x242546 },
	{ 0x20647, 0x26295a },
	{ 0x20648, 0x242544 },
	{ 0x20649, 0x26295b },
	{ 0x2064a, 0x26295c },
	{ 0x2064b, 0x26295d },
	{ 0x2064c, 0x2f2558 },
	{ 0x2064d, 0x2f2559 },
	{ 0x2064f, 0x262e72 },
	{ 0x20650, 0x262e70 },
	{ 0x20651, 0x262e71 },
	{ 0x20652, 0x263547 },
	{ 0x20653, 0x2f2e2c },
	{ 0x20657, 0x263727 },
	{ 0x20658, 0x263d42 },
	{ 0x20659, 0x263d43 },
	{ 0x2065a, 0x263d41 },
	{ 0x2065b, 0x2f3331 },
	{ 0x2065c, 0x2f3332 },
	{ 0x2065d, 0x2f3333 },
	{ 0x2065f, 0x264663 },
	{ 0x20660, 0x264666 },
	{ 0x20661, 0x2f3949 },
	{ 0x20662, 0x264664 },
	{ 0x20667, 0x2f394a },
	{ 0x20668, 0x2f465f },
	{ 0x20669, 0x2f4660 },
	{ 0x2066a, 0x2f4661 },
	{ 0x2066b, 0x2f4d68 },
	{ 0x2066d, 0x272c47 },
	{ 0x2066e, 0x2f5354 },
	{ 0x2066f, 0x2f5355 },
	{ 0x20670, 0x2f5343 },
	{ 0x20671, 0x2f5955 },
	{ 0x20672, 0x2f5e35 },
	{ 0x20673, 0x2f6743 },
	{ 0x20675, 0x24212e },
	{ 0x20676, 0x252139 },
	{ 0x20677, 0x262153 },
	{ 0x20678, 0x262154 },
	{ 0x20679, 0x26223f },
	{ 0x2067a, 0x252154 },
	{ 0x2067b, 0x26223e },
	{ 0x2067d, 0x2f214c },
	{ 0x2067e, 0x262365 },
	{ 0x2067f, 0x262361 },
	{ 0x20680, 0x262362 },
	{ 0x20681, 0x262363 },
	{ 0x20682, 0x2f2221 },
	{ 0x20686, 0x25222a },
	{ 0x20687, 0x262628 },
	{ 0x20688, 0x2f2336 },
	{ 0x2068b, 0x262960 },
	{ 0x2068d, 0x26295f },
	{ 0x2068e, 0x262e73 },
	{ 0x2068f, 0x262e74 },
	{ 0x20691, 0x26347a },
	{ 0x20692, 0x263548 },
	{ 0x20696, 0x263d44 },
	{ 0x20697, 0x263d45 },
	{ 0x20698, 0x25365d },
	{ 0x20699, 0x265a7e },
	{ 0x2069a, 0x2f4662 },
	{ 0x2069b, 0x272170 },
	{ 0x2069d, 0x27367b },
	{ 0x2069e, 0x255a76 },
	{ 0x2069f, 0x256754 },
	{ 0x206a1, 0x274e3e },
	{ 0x206a3, 0x262139 },
	{ 0x206a5, 0x242140 },
	{ 0x206a6, 0x262155 },
	{ 0x206a7, 0x25213a },
	{ 0x206a8, 0x25213b },
	{ 0x206a9, 0x262156 },
	{ 0x206aa, 0x242141 },
	{ 0x206ab, 0x2f212f },
	{ 0x206ac, 0x262157 },
	{ 0x206ad, 0x252155 },
	{ 0x206ae, 0x252156 },
	{ 0x206af, 0x242162 },
	{ 0x206b0, 0x262244 },
	{ 0x206b1, 0x252157 },
	{ 0x206b2, 0x262243 },
	{ 0x206b3, 0x262240 },
	{ 0x206b4, 0x262245 },
	{ 0x206b7, 0x24223a },
	{ 0x206b8, 0x26236a },
	{ 0x206b9, 0x25222e },
	{ 0x206ba, 0x25222c },
	{ 0x206bb, 0x25222b },
	{ 0x206bc, 0x24223b },
	{ 0x206bd, 0x242239 },
	{ 0x206be, 0x262368 },
	{ 0x206bf, 0x262367 },
	{ 0x206c0, 0x25222f },
	{ 0x206c1, 0x26236b },
	{ 0x206c2, 0x262369 },
	{ 0x206c3, 0x25222d },
	{ 0x206c4, 0x24223d },
	{ 0x206c7, 0x2f2222 },
	{ 0x206c8, 0x2f2223 },
	{ 0x206c9, 0x24223e },
	{ 0x206cd, 0x262366 },
	{ 0x206ce, 0x242341 },
	{ 0x206cf, 0x26262b },
	{ 0x206d0, 0x242343 },
	{ 0x206d1, 0x25233d },
	{ 0x206d2, 0x242342 },
	{ 0x206d3, 0x252346 },
	{ 0x206d4, 0x252345 },
	{ 0x206d5, 0x252343 },
	{ 0x206d6, 0x252340 },
	{ 0x206d7, 0x262629 },
	{ 0x206d8, 0x25233f },
	{ 0x206d9, 0x252342 },
	{ 0x206da, 0x252341 },
	{ 0x206db, 0x26262a },
	{ 0x206e0, 0x26262c },
	{ 0x206e5, 0x25233e },
	{ 0x206e6, 0x252344 },
	{ 0x206e7, 0x262969 },
	{ 0x206e8, 0x252533 },
	{ 0x206e9, 0x252535 },
	{ 0x206ea, 0x242549 },
	{ 0x206eb, 0x24254b },
	{ 0x206ec, 0x23275c },
	{ 0x206ed, 0x262966 },
	{ 0x206ee, 0x24254d },
	{ 0x206ef, 0x262964 },
	{ 0x206f0, 0x262965 },
	{ 0x206f1, 0x26296c },
	{ 0x206f2, 0x262e75 },
	{ 0x206f4, 0x26296a },
	{ 0x206f5, 0x252530 },
	{ 0x206f6, 0x252536 },
	{ 0x206f7, 0x26296b },
	{ 0x206f8, 0x252532 },
	{ 0x206f9, 0x262967 },
	{ 0x206fb, 0x252534 },
	{ 0x206fc, 0x2f255a },
	{ 0x206fd, 0x2f255b },
	{ 0x206fe, 0x2f255c },
	{ 0x206ff, 0x2f255d },
	{ 0x20702, 0x262968 },
	{ 0x20706, 0x262962 },
	{ 0x20707, 0x262961 },
	{ 0x20709, 0x252531 },
	{ 0x2070c, 0x262957 },
	{ 0x20710, 0x242847 },
	{ 0x20711, 0x25282d },
	{ 0x20712, 0x242845 },
	{ 0x20713, 0x262f24 },
	{ 0x20714, 0x262e7b },
	{ 0x20715, 0x262f22 },
	{ 0x20716, 0x242848 },
	{ 0x20717, 0x262f21 },
	{ 0x20718, 0x242844 },
	{ 0x20719, 0x242846 },
	{ 0x2071a, 0x262e78 },
	{ 0x2071b, 0x262e7e },
	{ 0x2071c, 0x262f23 },
	{ 0x2071d, 0x262e7a },
	{ 0x2071f, 0x262e7d },
	{ 0x20720, 0x262e7c },
	{ 0x20721, 0x2f2940 },
	{ 0x20722, 0x2f2941 },
	{ 0x20723, 0x2f2942 },
	{ 0x20725, 0x262e79 },
	{ 0x20726, 0x25282e },
	{ 0x20728, 0x262e77 },
	{ 0x20730, 0x263549 },
	{ 0x20731, 0x242b70 },
	{ 0x20732, 0x242b6d },
	{ 0x20733, 0x252c25 },
	{ 0x20734, 0x252c23 },
	{ 0x20735, 0x242b6f },
	{ 0x20736, 0x242b73 },
	{ 0x20737, 0x26354e },
	{ 0x20738, 0x263552 },
	{ 0x20739, 0x252c22 },
	{ 0x2073a, 0x263553 },
	{ 0x2073b, 0x242b6c },
	{ 0x2073c, 0x252c26 },
	{ 0x2073d, 0x263551 },
	{ 0x2073e, 0x242b71 },
	{ 0x2073f, 0x263550 },
	{ 0x20740, 0x26354f },
	{ 0x20741, 0x26354c },
	{ 0x20742, 0x26354b },
	{ 0x20743, 0x242b72 },
	{ 0x20744, 0x252c24 },
	{ 0x20745, 0x26354d },
	{ 0x20748, 0x2f2e33 },
	{ 0x20749, 0x263554 },
	{ 0x2074a, 0x2f2e2e },
	{ 0x2074b, 0x2f2e2f },
	{ 0x2074c, 0x2f2e30 },
	{ 0x2074d, 0x2f2e32 },
	{ 0x20751, 0x2f2e31 },
	{ 0x20752, 0x26354a },
	{ 0x20758, 0x252c27 },
	{ 0x20759, 0x252b7d },
	{ 0x2075a, 0x252c21 },
	{ 0x2075b, 0x252b7e },
	{ 0x2075d, 0x243050 },
	{ 0x2075e, 0x25312b },
	{ 0x2075f, 0x243051 },
	{ 0x20760, 0x25312a },
	{ 0x20761, 0x263d46 },
	{ 0x20762, 0x243056 },
	{ 0x20763, 0x243649 },
	{ 0x20764, 0x243055 },
	{ 0x20765, 0x263d49 },
	{ 0x20767, 0x263d47 },
	{ 0x20768, 0x25365e },
	{ 0x20769, 0x24304f },
	{ 0x2076a, 0x252c28 },
	{ 0x2076d, 0x2f3334 },
	{ 0x2076e, 0x2f3335 },
	{ 0x2076f, 0x2f3337 },
	{ 0x20771, 0x263d48 },
	{ 0x2077d, 0x263d4a },
	{ 0x2077e, 0x263d4b },
	{ 0x2077f, 0x243643 },
	{ 0x20780, 0x25365f },
	{ 0x20781, 0x26466d },
	{ 0x20782, 0x264669 },
	{ 0x20783, 0x243646 },
	{ 0x20784, 0x243647 },
	{ 0x20785, 0x253660 },
	{ 0x20786, 0x253664 },
	{ 0x20787, 0x24364a },
	{ 0x20788, 0x243644 },
	{ 0x20789, 0x243641 },
	{ 0x2078a, 0x243640 },
	{ 0x2078b, 0x26466b },
	{ 0x2078c, 0x264668 },
	{ 0x2078d, 0x26466c },
	{ 0x2078e, 0x253661 },
	{ 0x2078f, 0x253662 },
	{ 0x20790, 0x26466a },
	{ 0x20791, 0x2f394b },
	{ 0x20792, 0x2f394c },
	{ 0x20793, 0x2f394d },
	{ 0x20794, 0x2f394e },
	{ 0x20798, 0x243648 },
	{ 0x2079c, 0x264c46 },
	{ 0x2079d, 0x26466e },
	{ 0x207a4, 0x253665 },
	{ 0x207a5, 0x243c39 },
	{ 0x207a6, 0x26506f },
	{ 0x207a7, 0x253d73 },
	{ 0x207a8, 0x26506d },
	{ 0x207a9, 0x243c35 },
	{ 0x207aa, 0x253d74 },
	{ 0x207ab, 0x26506e },
	{ 0x207ac, 0x253d6d },
	{ 0x207ad, 0x243c37 },
	{ 0x207ae, 0x243c36 },
	{ 0x207af, 0x253d6e },
	{ 0x207b0, 0x243c3a },
	{ 0x207b1, 0x253d6f },
	{ 0x207b2, 0x26506b },
	{ 0x207b3, 0x2f404b },
	{ 0x207b7, 0x26506a },
	{ 0x207bb, 0x265068 },
	{ 0x207bc, 0x265070 },
	{ 0x207bd, 0x265069 },
	{ 0x207be, 0x253d72 },
	{ 0x207bf, 0x253d71 },
	{ 0x207c1, 0x2f404c },
	{ 0x207c2, 0x25445b },
	{ 0x207c3, 0x24423b },
	{ 0x207c4, 0x265b24 },
	{ 0x207c5, 0x254461 },
	{ 0x207c6, 0x265b22 },
	{ 0x207c7, 0x265b21 },
	{ 0x207c8, 0x243c38 },
	{ 0x207c9, 0x244240 },
	{ 0x207ca, 0x254462 },
	{ 0x207cb, 0x25445c },
	{ 0x207cc, 0x25445f },
	{ 0x207cd, 0x24423d },
	{ 0x207ce, 0x244244 },
	{ 0x207cf, 0x265b2b },
	{ 0x207d0, 0x265b29 },
	{ 0x207d1, 0x265b28 },
	{ 0x207d2, 0x25445e },
	{ 0x207d3, 0x254c22 },
	{ 0x207d4, 0x265b26 },
	{ 0x207d5, 0x25445d },
	{ 0x207d6, 0x265b2a },
	{ 0x207d7, 0x254460 },
	{ 0x207d8, 0x265b25 },
	{ 0x207d9, 0x2f4663 },
	{ 0x207da, 0x2f4664 },
	{ 0x207db, 0x2f4665 },
	{ 0x207dc, 0x265b23 },
	{ 0x207df, 0x265b27 },
	{ 0x207e6, 0x254c23 },
	{ 0x207e7, 0x254c27 },
	{ 0x207e8, 0x244924 },
	{ 0x207e9, 0x254c24 },
	{ 0x207ea, 0x254c26 },
	{ 0x207eb, 0x27213c },
	{ 0x207ec, 0x27213d },
	{ 0x207ed, 0x27213a },
	{ 0x207ee, 0x27213e },
	{ 0x207ef, 0x27213b },
	{ 0x207f0, 0x254c25 },
	{ 0x207f1, 0x272138 },
	{ 0x207f3, 0x27225a },
	{ 0x207f5, 0x272139 },
	{ 0x207fa, 0x244f60 },
	{ 0x207fb, 0x272c49 },
	{ 0x207fc, 0x255a77 },
	{ 0x207fd, 0x272c4a },
	{ 0x207fe, 0x272c4e },
	{ 0x207ff, 0x272c4d },
	{ 0x20800, 0x272c4c },
	{ 0x20801, 0x25535f },
	{ 0x20802, 0x255361 },
	{ 0x20803, 0x255360 },
	{ 0x20804, 0x25535e },
	{ 0x20805, 0x272c48 },
	{ 0x20806, 0x272c4b },
	{ 0x20807, 0x27213f },
	{ 0x20808, 0x2f5356 },
	{ 0x2080b, 0x255851 },
	{ 0x2080d, 0x255a7a },
	{ 0x2080e, 0x24556b },
	{ 0x2080f, 0x255a79 },
	{ 0x20810, 0x255a78 },
	{ 0x20812, 0x27367c },
	{ 0x20813, 0x2f5956 },
	{ 0x20817, 0x24556e },
	{ 0x2081b, 0x273e7c },
	{ 0x2081c, 0x256138 },
	{ 0x2081d, 0x256139 },
	{ 0x2081e, 0x27367d },
	{ 0x2081f, 0x2f5e36 },
	{ 0x20820, 0x25613a },
	{ 0x20821, 0x27462f },
	{ 0x20822, 0x27462e },
	{ 0x20823, 0x27462d },
	{ 0x20826, 0x274d40 },
	{ 0x20827, 0x274d41 },
	{ 0x2082a, 0x256f6a },
	{ 0x2082b, 0x275277 },
	{ 0x2082c, 0x2f6744 },
	{ 0x2082e, 0x257564 },
	{ 0x2082f, 0x246b65 },
	{ 0x20830, 0x27622d },
	{ 0x20831, 0x27622c },
	{ 0x20832, 0x26213a },
	{ 0x20833, 0x25213c },
	{ 0x20834, 0x262158 },
	{ 0x20836, 0x242163 },
	{ 0x20837, 0x252159 },
	{ 0x20838, 0x252158 },
	{ 0x20839, 0x252231 },
	{ 0x2083b, 0x252232 },
	{ 0x2083c, 0x2f2225 },
	{ 0x2083d, 0x2f2226 },
	{ 0x2083e, 0x2f2227 },
	{ 0x2083f, 0x2f2228 },
	{ 0x20841, 0x252233 },
	{ 0x20842, 0x26262e },
	{ 0x20843, 0x242345 },
	{ 0x20844, 0x252347 },
	{ 0x20846, 0x2f2338 },
	{ 0x20847, 0x2f233a },
	{ 0x20848, 0x2f233b },
	{ 0x2084c, 0x26262d },
	{ 0x2084d, 0x242349 },
	{ 0x20851, 0x25253d },
	{ 0x20852, 0x252539 },
	{ 0x20853, 0x26296d },
	{ 0x20854, 0x25253c },
	{ 0x20855, 0x26296e },
	{ 0x20856, 0x2f2560 },
	{ 0x20857, 0x2f2561 },
	{ 0x20858, 0x2f2562 },
	{ 0x20859, 0x2f2563 },
	{ 0x2085e, 0x252830 },
	{ 0x2085f, 0x24284a },
	{ 0x20860, 0x262f26 },
	{ 0x20861, 0x252831 },
	{ 0x20862, 0x25282f },
	{ 0x20866, 0x262f28 },
	{ 0x20868, 0x2f2943 },
	{ 0x20869, 0x2f2944 },
	{ 0x2086a, 0x2f2945 },
	{ 0x2086b, 0x263555 },
	{ 0x2086c, 0x263559 },
	{ 0x2086d, 0x242b74 },
	{ 0x2086e, 0x252c2d },
	{ 0x2086f, 0x252c29 },
	{ 0x20870, 0x252c2b },
	{ 0x20871, 0x252c2c },
	{ 0x20872, 0x252c2a },
	{ 0x20874, 0x2f2e34 },
	{ 0x20875, 0x2f2e35 },
	{ 0x20878, 0x263556 },
	{ 0x20879, 0x263557 },
	{ 0x2087b, 0x25312d },
	{ 0x2087c, 0x263d4e },
	{ 0x2087d, 0x263d4c },
	{ 0x2087e, 0x263d4f },
	{ 0x2087f, 0x263d50 },
	{ 0x20880, 0x263d51 },
	{ 0x20881, 0x2f3338 },
	{ 0x20882, 0x2f3339 },
	{ 0x20884, 0x263d4d },
	{ 0x20885, 0x253669 },
	{ 0x20886, 0x253666 },
	{ 0x20887, 0x253668 },
	{ 0x20888, 0x25366b },
	{ 0x20889, 0x253667 },
	{ 0x2088a, 0x2f394f },
	{ 0x2088b, 0x2f3950 },
	{ 0x2088e, 0x26466f },
	{ 0x2088f, 0x264670 },
	{ 0x20892, 0x264671 },
	{ 0x20893, 0x253d76 },
	{ 0x20894, 0x253d75 },
	{ 0x20895, 0x243c3b },
	{ 0x20896, 0x265072 },
	{ 0x20897, 0x265071 },
	{ 0x20898, 0x2f404d },
	{ 0x20899, 0x253d77 },
	{ 0x208a0, 0x244246 },
	{ 0x208a1, 0x254466 },
	{ 0x208a2, 0x254464 },
	{ 0x208a3, 0x254465 },
	{ 0x208a4, 0x254469 },
	{ 0x208a5, 0x244245 },
	{ 0x208a6, 0x254468 },
	{ 0x208a7, 0x265b2e },
	{ 0x208a8, 0x2f4666 },
	{ 0x208ad, 0x265b2c },
	{ 0x208af, 0x265b2d },
	{ 0x208b0, 0x254c2b },
	{ 0x208b1, 0x254c28 },
	{ 0x208b2, 0x244926 },
	{ 0x208b3, 0x254c29 },
	{ 0x208b4, 0x254c2a },
	{ 0x208b6, 0x272c4f },
	{ 0x208b7, 0x255a7c },
	{ 0x208b8, 0x2f5357 },
	{ 0x208b9, 0x255a7b },
	{ 0x208ba, 0x255a7d },
	{ 0x208bb, 0x27367e },
	{ 0x208bc, 0x273722 },
	{ 0x208bf, 0x273721 },
	{ 0x208c0, 0x25613c },
	{ 0x208c1, 0x273e7e },
	{ 0x208c3, 0x273f21 },
	{ 0x208c4, 0x256756 },
	{ 0x208c5, 0x256755 },
	{ 0x208c6, 0x274d42 },
	{ 0x208c7, 0x256f6b },
	{ 0x208c8, 0x275b46 },
	{ 0x208c9, 0x257565 },
	{ 0x208ca, 0x246c6b },
	{ 0x208cb, 0x27663b },
	{ 0x208cc, 0x25213d },
	{ 0x208cd, 0x262247 },
	{ 0x208ce, 0x262248 },
	{ 0x208cf, 0x252235 },
	{ 0x208d1, 0x252234 },
	{ 0x208d2, 0x252236 },
	{ 0x208d3, 0x2f222a },
	{ 0x208d4, 0x26262f },
	{ 0x208d6, 0x252348 },
	{ 0x208d7, 0x252349 },
	{ 0x208d8, 0x242552 },
	{ 0x208d9, 0x262971 },
	{ 0x208da, 0x262970 },
	{ 0x208dc, 0x2f2564 },
	{ 0x208dd, 0x2f2565 },
	{ 0x208de, 0x262f2a },
	{ 0x208df, 0x24284c },
	{ 0x208e0, 0x262f2b },
	{ 0x208e1, 0x262f2c },
	{ 0x208e2, 0x2f2946 },
	{ 0x208e3, 0x262f29 },
	{ 0x208e4, 0x242b76 },
	{ 0x208e5, 0x26355c },
	{ 0x208e6, 0x26355b },
	{ 0x208e7, 0x26355e },
	{ 0x208e8, 0x26355f },
	{ 0x208e9, 0x26355a },
	{ 0x208ea, 0x26355d },
	{ 0x208eb, 0x252c2f },
	{ 0x208ee, 0x24305d },
	{ 0x208ef, 0x263d52 },
	{ 0x208f0, 0x252c2e },
	{ 0x208f1, 0x25312e },
	{ 0x208f3, 0x25312f },
	{ 0x208f4, 0x263d53 },
	{ 0x208f5, 0x24364e },
	{ 0x208f7, 0x2f3951 },
	{ 0x208f8, 0x265073 },
	{ 0x208f9, 0x24305b },
	{ 0x208fa, 0x253d79 },
	{ 0x208fb, 0x2f404e },
	{ 0x208fc, 0x2f404f },
	{ 0x208fd, 0x265b2f },
	{ 0x208fe, 0x244247 },
	{ 0x208ff, 0x25446a },
	{ 0x20900, 0x25446b },
	{ 0x20901, 0x2f4667 },
	{ 0x20903, 0x2f4d69 },
	{ 0x20904, 0x244f65 },
	{ 0x20905, 0x272c50 },
	{ 0x20907, 0x272c51 },
	{ 0x20908, 0x273723 },
	{ 0x20909, 0x273724 },
	{ 0x2090a, 0x255a7e },
	{ 0x2090b, 0x274d43 },
	{ 0x2090e, 0x26212a },
	{ 0x2090f, 0x242142 },
	{ 0x20910, 0x26224a },
	{ 0x20911, 0x262630 },
	{ 0x20912, 0x262633 },
	{ 0x20913, 0x25234a },
	{ 0x20914, 0x262631 },
	{ 0x20915, 0x262632 },
	{ 0x20917, 0x24284d },
	{ 0x20918, 0x262f2f },
	{ 0x20919, 0x262f31 },
	{ 0x2091a, 0x262f2d },
	{ 0x2091b, 0x262f2e },
	{ 0x2091c, 0x262f30 },
	{ 0x2091e, 0x263d54 },
	{ 0x2091f, 0x263560 },
	{ 0x20920, 0x2f2e36 },
	{ 0x20921, 0x2f2e37 },
	{ 0x20922, 0x263524 },
	{ 0x20923, 0x264672 },
	{ 0x20924, 0x2f3952 },
	{ 0x20925, 0x243c3d },
	{ 0x20928, 0x2f4668 },
	{ 0x2092a, 0x273f22 },
	{ 0x2092b, 0x256d32 },
	{ 0x2092c, 0x26212b },
	{ 0x2092d, 0x2f2131 },
	{ 0x2092e, 0x252237 },
	{ 0x2092f, 0x26236e },
	{ 0x20930, 0x242243 },
	{ 0x20931, 0x26236d },
	{ 0x20933, 0x262634 },
	{ 0x20934, 0x24234a },
	{ 0x20935, 0x262635 },
	{ 0x20936, 0x2f233c },
	{ 0x20938, 0x262973 },
	{ 0x20939, 0x25253e },
	{ 0x2093a, 0x25253f },
	{ 0x2093c, 0x24284f },
	{ 0x2093e, 0x262f34 },
	{ 0x2093f, 0x252833 },
	{ 0x20940, 0x262f33 },
	{ 0x20941, 0x252832 },
	{ 0x20942, 0x262f32 },
	{ 0x20943, 0x262f37 },
	{ 0x20944, 0x262f35 },
	{ 0x20945, 0x2f2947 },
	{ 0x20949, 0x252c30 },
	{ 0x2094a, 0x263562 },
	{ 0x2094b, 0x263561 },
	{ 0x2094c, 0x252c31 },
	{ 0x2094e, 0x263d55 },
	{ 0x2094f, 0x2f333a },
	{ 0x20950, 0x24364f },
	{ 0x20951, 0x265075 },
	{ 0x20952, 0x264673 },
	{ 0x20953, 0x263563 },
	{ 0x20956, 0x253d7a },
	{ 0x20959, 0x244248 },
	{ 0x2095a, 0x265b31 },
	{ 0x2095b, 0x265b30 },
	{ 0x2095c, 0x254c2c },
	{ 0x2095d, 0x254c2d },
	{ 0x2095e, 0x254c2e },
	{ 0x20961, 0x2f4d6a },
	{ 0x20962, 0x255364 },
	{ 0x20963, 0x273725 },
	{ 0x20965, 0x2f5e37 },
	{ 0x20966, 0x245f4b },
	{ 0x20969, 0x273f23 },
	{ 0x2096a, 0x274d44 },
	{ 0x2096b, 0x276069 },
	{ 0x2096c, 0x276443 },
	{ 0x2096d, 0x2f2132 },
	{ 0x2096e, 0x252238 },
	{ 0x2096f, 0x26236f },
	{ 0x20970, 0x25234c },
	{ 0x20971, 0x262637 },
	{ 0x20972, 0x2f233d },
	{ 0x20973, 0x2f2566 },
	{ 0x20974, 0x262f36 },
	{ 0x20975, 0x252834 },
	{ 0x20976, 0x263564 },
	{ 0x20977, 0x2f4669 },
	{ 0x20978, 0x274d45 },
	{ 0x2097a, 0x275750 },
	{ 0x2097b, 0x26215a },
	{ 0x2097d, 0x25215a },
	{ 0x2097e, 0x25215b },
	{ 0x20980, 0x26224b },
	{ 0x20982, 0x262370 },
	{ 0x20983, 0x242244 },
	{ 0x20985, 0x242245 },
	{ 0x20986, 0x262373 },
	{ 0x20987, 0x262372 },
	{ 0x20988, 0x25223a },
	{ 0x2098c, 0x252239 },
	{ 0x2098d, 0x262374 },
	{ 0x20991, 0x262639 },
	{ 0x20992, 0x25234d },
	{ 0x20993, 0x26263a },
	{ 0x20994, 0x262375 },
	{ 0x20995, 0x26263b },
	{ 0x20996, 0x2f233e },
	{ 0x20998, 0x252540 },
	{ 0x20999, 0x262974 },
	{ 0x2099a, 0x262977 },
	{ 0x2099b, 0x262978 },
	{ 0x2099c, 0x262976 },
	{ 0x2099d, 0x2f2567 },
	{ 0x2099e, 0x2f2569 },
	{ 0x2099f, 0x2f256a },
	{ 0x209a0, 0x2f256b },
	{ 0x209a1, 0x2f2568 },
	{ 0x209a2, 0x262975 },
	{ 0x209a3, 0x263565 },
	{ 0x209a4, 0x263566 },
	{ 0x209a5, 0x2f2e38 },
	{ 0x209a6, 0x2f2e39 },
	{ 0x209aa, 0x243063 },
	{ 0x209ab, 0x243061 },
	{ 0x209ac, 0x243062 },
	{ 0x209ad, 0x2f333b },
	{ 0x209b0, 0x2f3953 },
	{ 0x209b1, 0x2f3954 },
	{ 0x209b4, 0x265078 },
	{ 0x209b5, 0x265077 },
	{ 0x209b6, 0x265079 },
	{ 0x209b7, 0x26507b },
	{ 0x209bc, 0x2f4050 },
	{ 0x209bd, 0x2f466a },
	{ 0x209be, 0x2f466b },
	{ 0x209c0, 0x254c2f },
	{ 0x209c1, 0x2f4d6b },
	{ 0x209c2, 0x2f4d6c },
	{ 0x209c4, 0x272140 },
	{ 0x209c8, 0x273726 },
	{ 0x209ca, 0x2f5e38 },
	{ 0x209ce, 0x274630 },
	{ 0x209cf, 0x275278 },
	{ 0x209d0, 0x27606a },
	{ 0x209d1, 0x27622e },
	{ 0x209d3, 0x26224c },
	{ 0x209d4, 0x262377 },
	{ 0x209d7, 0x262376 },
	{ 0x209d8, 0x262378 },
	{ 0x209d9, 0x24234c },
	{ 0x209da, 0x25234f },
	{ 0x209db, 0x25234e },
	{ 0x209dc, 0x26263c },
	{ 0x209de, 0x242555 },
	{ 0x209df, 0x242554 },
	{ 0x209e0, 0x26297c },
	{ 0x209e1, 0x26297b },
	{ 0x209e2, 0x26297d },
	{ 0x209e3, 0x26297a },
	{ 0x209e4, 0x26297e },
	{ 0x209e5, 0x262979 },
	{ 0x209e6, 0x2f256c },
	{ 0x209e8, 0x262a22 },
	{ 0x209e9, 0x242852 },
	{ 0x209ea, 0x242851 },
	{ 0x209eb, 0x252837 },
	{ 0x209ec, 0x2f2948 },
	{ 0x209ed, 0x2f2949 },
	{ 0x209ee, 0x2f294a },
	{ 0x209ef, 0x2f294b },
	{ 0x209f2, 0x262f39 },
	{ 0x209f3, 0x263568 },
	{ 0x209f4, 0x242b79 },
	{ 0x209f5, 0x252c32 },
	{ 0x209f6, 0x263567 },
	{ 0x209f7, 0x26356a },
	{ 0x209f8, 0x263c7a },
	{ 0x209f9, 0x263569 },
	{ 0x209fa, 0x263d57 },
	{ 0x209fb, 0x263d56 },
	{ 0x209fc, 0x26356b },
	{ 0x209fd, 0x263d58 },
	{ 0x20a00, 0x264675 },
	{ 0x20a01, 0x264676 },
	{ 0x20a02, 0x264677 },
	{ 0x20a03, 0x25373f },
	{ 0x20a05, 0x26507c },
	{ 0x20a06, 0x25446d },
	{ 0x20a07, 0x265b32 },
	{ 0x20a08, 0x272141 },
	{ 0x20a09, 0x2f5358 },
	{ 0x20a0b, 0x27634b },
	{ 0x20a0d, 0x25213e },
	{ 0x20a0e, 0x242143 },
	{ 0x20a0f, 0x2f2134 },
	{ 0x20a10, 0x26215b },
	{ 0x20a12, 0x242246 },
	{ 0x20a13, 0x262a24 },
	{ 0x20a14, 0x26237a },
	{ 0x20a16, 0x262379 },
	{ 0x20a18, 0x24234e },
	{ 0x20a19, 0x262f3b },
	{ 0x20a1a, 0x252838 },
	{ 0x20a1b, 0x262f3a },
	{ 0x20a1c, 0x242853 },
	{ 0x20a1d, 0x26356c },
	{ 0x20a1e, 0x262f3c },
	{ 0x20a1f, 0x264678 },
	{ 0x20a20, 0x252c33 },
	{ 0x20a22, 0x253d7b },
	{ 0x20a23, 0x26507d },
	{ 0x20a25, 0x25446e },
	{ 0x20a27, 0x273f24 },
	{ 0x20a2c, 0x25213f },
	{ 0x20a2d, 0x25215c },
	{ 0x20a2e, 0x26237b },
	{ 0x20a2f, 0x26224f },
	{ 0x20a30, 0x26224d },
	{ 0x20a31, 0x262250 },
	{ 0x20a32, 0x25215d },
	{ 0x20a34, 0x242247 },
	{ 0x20a35, 0x25223b },
	{ 0x20a36, 0x26237c },
	{ 0x20a37, 0x26237d },
	{ 0x20a38, 0x25223f },
	{ 0x20a39, 0x252240 },
	{ 0x20a3a, 0x25223d },
	{ 0x20a3b, 0x25223e },
	{ 0x20a3d, 0x2f222d },
	{ 0x20a40, 0x26263e },
	{ 0x20a41, 0x252350 },
	{ 0x20a42, 0x26263d },
	{ 0x20a43, 0x252351 },
	{ 0x20a44, 0x26255e },
	{ 0x20a47, 0x2f233f },
	{ 0x20a4a, 0x262a27 },
	{ 0x20a4b, 0x262a26 },
	{ 0x20a4c, 0x262a29 },
	{ 0x20a4d, 0x262a28 },
	{ 0x20a4e, 0x252541 },
	{ 0x20a4f, 0x242558 },
	{ 0x20a51, 0x2f256d },
	{ 0x20a52, 0x2f256e },
	{ 0x20a56, 0x262a25 },
	{ 0x20a57, 0x252839 },
	{ 0x20a58, 0x242854 },
	{ 0x20a59, 0x262f46 },
	{ 0x20a5a, 0x262f41 },
	{ 0x20a5b, 0x262f44 },
	{ 0x20a5c, 0x262f45 },
	{ 0x20a5d, 0x262f40 },
	{ 0x20a5e, 0x262f3e },
	{ 0x20a5f, 0x262f42 },
	{ 0x20a60, 0x262f43 },
	{ 0x20a62, 0x2f294d },
	{ 0x20a63, 0x2f294e },
	{ 0x20a64, 0x242855 },
	{ 0x20a66, 0x262f3f },
	{ 0x20a67, 0x263573 },
	{ 0x20a68, 0x263574 },
	{ 0x20a69, 0x242b7b },
	{ 0x20a6a, 0x252c34 },
	{ 0x20a6b, 0x242b7c },
	{ 0x20a6c, 0x26356f },
	{ 0x20a6d, 0x26356d },
	{ 0x20a6e, 0x263570 },
	{ 0x20a6f, 0x263572 },
	{ 0x20a70, 0x263571 },
	{ 0x20a71, 0x26356e },
	{ 0x20a72, 0x252c35 },
	{ 0x20a73, 0x2f2e3a },
	{ 0x20a74, 0x2f2e3b },
	{ 0x20a78, 0x263d60 },
	{ 0x20a79, 0x263d5b },
	{ 0x20a7a, 0x243067 },
	{ 0x20a7b, 0x263d5f },
	{ 0x20a7c, 0x263d5c },
	{ 0x20a7d, 0x263d5d },
	{ 0x20a7e, 0x2f333d },
	{ 0x20a7f, 0x253130 },
	{ 0x20a84, 0x263d5e },
	{ 0x20a86, 0x243066 },
	{ 0x20a87, 0x243652 },
	{ 0x20a88, 0x26467c },
	{ 0x20a89, 0x26467a },
	{ 0x20a8a, 0x243653 },
	{ 0x20a8b, 0x26467b },
	{ 0x20a8c, 0x264679 },
	{ 0x20a8d, 0x26467d },
	{ 0x20a8e, 0x2f3955 },
	{ 0x20a8f, 0x26467e },
	{ 0x20a91, 0x253d7c },
	{ 0x20a92, 0x253d7d },
	{ 0x20a93, 0x265124 },
	{ 0x20a94, 0x265123 },
	{ 0x20a95, 0x26507e },
	{ 0x20a96, 0x2f4051 },
	{ 0x20a98, 0x265121 },
	{ 0x20a99, 0x243c3f },
	{ 0x20a9a, 0x244249 },
	{ 0x20a9b, 0x265b34 },
	{ 0x20a9c, 0x265b37 },
	{ 0x20a9d, 0x265b33 },
	{ 0x20a9e, 0x265b38 },
	{ 0x20a9f, 0x25446f },
	{ 0x20aa0, 0x2f466d },
	{ 0x20aa2, 0x2f466e },
	{ 0x20aa4, 0x265b36 },
	{ 0x20aa5, 0x265b39 },
	{ 0x20aa6, 0x265b3b },
	{ 0x20aaa, 0x265b3a },
	{ 0x20aab, 0x265b35 },
	{ 0x20aad, 0x272143 },
	{ 0x20aae, 0x244928 },
	{ 0x20aaf, 0x254c30 },
	{ 0x20ab0, 0x272144 },
	{ 0x20ab3, 0x272142 },
	{ 0x20ab5, 0x2f4d6d },
	{ 0x20ab9, 0x272548 },
	{ 0x20aba, 0x255365 },
	{ 0x20abb, 0x272c53 },
	{ 0x20abc, 0x272c52 },
	{ 0x20abd, 0x2f5359 },
	{ 0x20abe, 0x2f535a },
	{ 0x20abf, 0x273b4d },
	{ 0x20ac0, 0x2f5e39 },
	{ 0x20ac1, 0x2f5e3a },
	{ 0x20ac2, 0x2f5e3b },
	{ 0x20ac7, 0x2f647c },
	{ 0x20ac8, 0x274e27 },
	{ 0x20ac9, 0x275279 },
	{ 0x20acc, 0x257754 },
	{ 0x20ace, 0x275e50 },
	{ 0x20ad0, 0x276533 },
	{ 0x20ad2, 0x276633 },
	{ 0x20ad3, 0x25212e },
	{ 0x20ad4, 0x26213c },
	{ 0x20ad5, 0x26213d },
	{ 0x20ad7, 0x26215d },
	{ 0x20ad9, 0x262252 },
	{ 0x20ada, 0x262251 },
	{ 0x20ade, 0x24224a },
	{ 0x20adf, 0x262423 },
	{ 0x20ae0, 0x262421 },
	{ 0x20ae2, 0x2f222e },
	{ 0x20ae4, 0x242249 },
	{ 0x20ae5, 0x262422 },
	{ 0x20ae6, 0x262640 },
	{ 0x20ae7, 0x2f2340 },
	{ 0x20ae8, 0x25233c },
	{ 0x20ae9, 0x262a2c },
	{ 0x20aea, 0x262a2b },
	{ 0x20aeb, 0x262a2d },
	{ 0x20aec, 0x262a2e },
	{ 0x20af0, 0x262f47 },
	{ 0x20af1, 0x262f48 },
	{ 0x20af3, 0x242856 },
	{ 0x20af4, 0x2f294f },
	{ 0x20af9, 0x263576 },
	{ 0x20afa, 0x263575 },
	{ 0x20afb, 0x263649 },
	{ 0x20afc, 0x26352e },
	{ 0x20aff, 0x25366c },
	{ 0x20b00, 0x264722 },
	{ 0x20b01, 0x264724 },
	{ 0x20b02, 0x264d62 },
	{ 0x20b04, 0x2f3956 },
	{ 0x20b05, 0x264723 },
	{ 0x20b06, 0x253e21 },
	{ 0x20b07, 0x265125 },
	{ 0x20b08, 0x253d7e },
	{ 0x20b0a, 0x2f4052 },
	{ 0x20b0e, 0x265b3c },
	{ 0x20b0f, 0x2f466f },
	{ 0x20b10, 0x266072 },
	{ 0x20b11, 0x272145 },
	{ 0x20b13, 0x255366 },
	{ 0x20b17, 0x2f5957 },
	{ 0x20b18, 0x274b6a },
	{ 0x20b1a, 0x262160 },
	{ 0x20b1b, 0x252140 },
	{ 0x20b1c, 0x26215e },
	{ 0x20b1d, 0x252142 },
	{ 0x20b1e, 0x262162 },
	{ 0x20b1f, 0x26215f },
	{ 0x20b21, 0x262255 },
	{ 0x20b22, 0x242168 },
	{ 0x20b23, 0x25215e },
	{ 0x20b25, 0x262256 },
	{ 0x20b26, 0x25215f },
	{ 0x20b27, 0x262253 },
	{ 0x20b28, 0x262254 },
	{ 0x20b29, 0x262425 },
	{ 0x20b2a, 0x24224b },
	{ 0x20b2b, 0x262424 },
	{ 0x20b2c, 0x252242 },
	{ 0x20b2d, 0x262426 },
	{ 0x20b2e, 0x252241 },
	{ 0x20b2f, 0x262427 },
	{ 0x20b31, 0x262644 },
	{ 0x20b32, 0x262642 },
	{ 0x20b33, 0x252352 },
	{ 0x20b34, 0x2f2341 },
	{ 0x20b35, 0x2f2342 },
	{ 0x20b36, 0x2f2343 },
	{ 0x20b37, 0x2f2344 },
	{ 0x20b38, 0x242350 },
	{ 0x20b39, 0x262a31 },
	{ 0x20b3a, 0x262a2f },
	{ 0x20b3b, 0x262a32 },
	{ 0x20b3c, 0x262a30 },
	{ 0x20b3d, 0x2f256f },
	{ 0x20b3f, 0x262f4d },
	{ 0x20b40, 0x262f4a },
	{ 0x20b41, 0x262f4c },
	{ 0x20b42, 0x262f4b },
	{ 0x20b43, 0x262f49 },
	{ 0x20b44, 0x2f2951 },
	{ 0x20b45, 0x2f2952 },
	{ 0x20b47, 0x263272 },
	{ 0x20b49, 0x252836 },
	{ 0x20b4a, 0x26357b },
	{ 0x20b4b, 0x252c36 },
	{ 0x20b4c, 0x26357c },
	{ 0x20b4d, 0x263579 },
	{ 0x20b4e, 0x263577 },
	{ 0x20b4f, 0x26357a },
	{ 0x20b50, 0x2f2e3c },
	{ 0x20b51, 0x2f2e3d },
	{ 0x20b52, 0x2f2e3e },
	{ 0x20b53, 0x2f2e3f },
	{ 0x20b54, 0x263c67 },
	{ 0x20b55, 0x263d66 },
	{ 0x20b56, 0x263d68 },
	{ 0x20b57, 0x253132 },
	{ 0x20b58, 0x253133 },
	{ 0x20b59, 0x263d65 },
	{ 0x20b5a, 0x263d63 },
	{ 0x20b5b, 0x263d6b },
	{ 0x20b5c, 0x263d64 },
	{ 0x20b5d, 0x252c37 },
	{ 0x20b5e, 0x263d62 },
	{ 0x20b5f, 0x263d69 },
	{ 0x20b60, 0x263d6a },
	{ 0x20b61, 0x263c7c },
	{ 0x20b63, 0x263d67 },
	{ 0x20b65, 0x243654 },
	{ 0x20b66, 0x25366d },
	{ 0x20b67, 0x264727 },
	{ 0x20b68, 0x264725 },
	{ 0x20b69, 0x2f333e },
	{ 0x20b6a, 0x2f3957 },
	{ 0x20b6b, 0x2f3958 },
	{ 0x20b6c, 0x2f3959 },
	{ 0x20b6d, 0x2f395a },
	{ 0x20b6e, 0x264726 },
	{ 0x20b6f, 0x243c43 },
	{ 0x20b70, 0x243c42 },
	{ 0x20b71, 0x265127 },
	{ 0x20b72, 0x265128 },
	{ 0x20b73, 0x265126 },
	{ 0x20b74, 0x243c41 },
	{ 0x20b75, 0x264728 },
	{ 0x20b76, 0x26515b },
	{ 0x20b78, 0x265129 },
	{ 0x20b7b, 0x265f21 },
	{ 0x20b7c, 0x265b3e },
	{ 0x20b7e, 0x265b3d },
	{ 0x20b7f, 0x254470 },
	{ 0x20b81, 0x26537b },
	{ 0x20b82, 0x2f4d55 },
	{ 0x20b83, 0x254c33 },
	{ 0x20b84, 0x254c34 },
	{ 0x20b85, 0x2f4670 },
	{ 0x20b86, 0x254c32 },
	{ 0x20b87, 0x272c55 },
	{ 0x20b88, 0x2f535b },
	{ 0x20b89, 0x235039 },
	{ 0x20b8a, 0x25542e },
	{ 0x20b8b, 0x272c54 },
	{ 0x20b8d, 0x273729 },
	{ 0x20b8e, 0x273728 },
	{ 0x20b8f, 0x2f5958 },
	{ 0x20b90, 0x245a6f },
	{ 0x20b91, 0x274632 },
	{ 0x20b92, 0x274631 },
	{ 0x20b93, 0x246631 },
	{ 0x20b94, 0x2f6745 },
	{ 0x20b95, 0x275751 },
	{ 0x20b96, 0x257566 },
	{ 0x20b97, 0x275e51 },
	{ 0x20b98, 0x275e52 },
	{ 0x20b99, 0x252143 },
	{ 0x20b9a, 0x262164 },
	{ 0x20b9b, 0x242147 },
	{ 0x20b9c, 0x242146 },
	{ 0x20b9d, 0x2f2136 },
	{ 0x20b9e, 0x262163 },
	{ 0x20ba0, 0x252161 },
	{ 0x20ba1, 0x262259 },
	{ 0x20ba2, 0x262258 },
	{ 0x20ba3, 0x26225e },
	{ 0x20ba4, 0x26225a },
	{ 0x20ba5, 0x26225d },
	{ 0x20ba6, 0x262257 },
	{ 0x20ba7, 0x262242 },
	{ 0x20ba8, 0x2f214e },
	{ 0x20baa, 0x26225c },
	{ 0x20bab, 0x252247 },
	{ 0x20bac, 0x26242d },
	{ 0x20bad, 0x252245 },
	{ 0x20bae, 0x26242e },
	{ 0x20baf, 0x24224d },
	{ 0x20bb0, 0x252246 },
	{ 0x20bb1, 0x242250 },
	{ 0x20bb2, 0x26242c },
	{ 0x20bb3, 0x24224f },
	{ 0x20bb4, 0x24224e },
	{ 0x20bb5, 0x252244 },
	{ 0x20bb7, 0x262428 },
	{ 0x20bb8, 0x2f222f },
	{ 0x20bb9, 0x2f2230 },
	{ 0x20bba, 0x2f2232 },
	{ 0x20bbb, 0x2f2234 },
	{ 0x20bc1, 0x26242a },
	{ 0x20bc2, 0x2f2231 },
	{ 0x20bc6, 0x2f2233 },
	{ 0x20bc8, 0x252243 },
	{ 0x20bc9, 0x262429 },
	{ 0x20bca, 0x26242b },
	{ 0x20bcb, 0x242356 },
	{ 0x20bcc, 0x26264f },
	{ 0x20bcd, 0x262646 },
	{ 0x20bce, 0x26264d },
	{ 0x20bcf, 0x26264c },
	{ 0x20bd0, 0x252356 },
	{ 0x20bd1, 0x24235a },
	{ 0x20bd2, 0x24235d },
	{ 0x20bd3, 0x25235b },
	{ 0x20bd4, 0x252354 },
	{ 0x20bd5, 0x262648 },
	{ 0x20bd6, 0x242357 },
	{ 0x20bd7, 0x242352 },
	{ 0x20bd8, 0x242358 },
	{ 0x20bd9, 0x252358 },
	{ 0x20bda, 0x262649 },
	{ 0x20bdb, 0x252359 },
	{ 0x20bdc, 0x242355 },
	{ 0x20bdd, 0x252355 },
	{ 0x20bde, 0x262647 },
	{ 0x20be1, 0x25235c },
	{ 0x20be3, 0x2f2345 },
	{ 0x20be4, 0x2f2346 },
	{ 0x20be5, 0x2f2347 },
	{ 0x20be6, 0x2f234a },
	{ 0x20be7, 0x2f234b },
	{ 0x20be8, 0x2f234c },
	{ 0x20beb, 0x2f2348 },
	{ 0x20bec, 0x26264b },
	{ 0x20bee, 0x26264a },
	{ 0x20bf3, 0x262650 },
	{ 0x20bf5, 0x262645 },
	{ 0x20bf6, 0x252353 },
	{ 0x20c04, 0x252357 },
	{ 0x20c05, 0x25235a },
	{ 0x20c08, 0x24255c },
	{ 0x20c09, 0x24255e },
	{ 0x20c0a, 0x262a36 },
	{ 0x20c0b, 0x25254c },
	{ 0x20c0c, 0x252544 },
	{ 0x20c0d, 0x24255b },
	{ 0x20c0e, 0x262a34 },
	{ 0x20c0f, 0x25254d },
	{ 0x20c10, 0x252545 },
	{ 0x20c11, 0x252547 },
	{ 0x20c12, 0x242561 },
	{ 0x20c13, 0x252550 },
	{ 0x20c14, 0x262a33 },
	{ 0x20c15, 0x252552 },
	{ 0x20c16, 0x252847 },
	{ 0x20c17, 0x262a3b },
	{ 0x20c18, 0x252548 },
	{ 0x20c19, 0x25254b },
	{ 0x20c1a, 0x25254a },
	{ 0x20c1b, 0x252551 },
	{ 0x20c1c, 0x252549 },
	{ 0x20c1d, 0x25254e },
	{ 0x20c1e, 0x262a3d },
	{ 0x20c21, 0x25254f },
	{ 0x20c22, 0x2f2570 },
	{ 0x20c23, 0x2f2572 },
	{ 0x20c24, 0x2f2573 },
	{ 0x20c25, 0x2f2574 },
	{ 0x20c26, 0x2f2575 },
	{ 0x20c27, 0x2f2576 },
	{ 0x20c28, 0x2f2577 },
	{ 0x20c29, 0x2f2578 },
	{ 0x20c2a, 0x2f2579 },
	{ 0x20c2b, 0x2f257a },
	{ 0x20c2c, 0x2f257d },
	{ 0x20c2d, 0x2f257e },
	{ 0x20c2e, 0x2f2621 },
	{ 0x20c2f, 0x2f2622 },
	{ 0x20c30, 0x2f2623 },
	{ 0x20c32, 0x252546 },
	{ 0x20c35, 0x262a35 },
	{ 0x20c36, 0x252543 },
	{ 0x20c38, 0x262a38 },
	{ 0x20c3f, 0x262a37 },
	{ 0x20c40, 0x2f257c },
	{ 0x20c4e, 0x262a3a },
	{ 0x20c50, 0x252c38 },
	{ 0x20c51, 0x252846 },
	{ 0x20c52, 0x252852 },
	{ 0x20c53, 0x25284d },
	{ 0x20c54, 0x25283c },
	{ 0x20c55, 0x252851 },
	{ 0x20c56, 0x262f54 },
	{ 0x20c57, 0x262f4e },
	{ 0x20c58, 0x25283f },
	{ 0x20c59, 0x24285b },
	{ 0x20c5a, 0x24285a },
	{ 0x20c5b, 0x25284f },
	{ 0x20c5c, 0x252845 },
	{ 0x20c5d, 0x25284b },
	{ 0x20c5e, 0x25284a },
	{ 0x20c5f, 0x25284e },
	{ 0x20c60, 0x252848 },
	{ 0x20c61, 0x252849 },
	{ 0x20c62, 0x25283d },
	{ 0x20c63, 0x252841 },
	{ 0x20c64, 0x25284c },
	{ 0x20c65, 0x242562 },
	{ 0x20c66, 0x262f59 },
	{ 0x20c67, 0x262f5a },
	{ 0x20c68, 0x252853 },
	{ 0x20c69, 0x262f4f },
	{ 0x20c6b, 0x25283a },
	{ 0x20c6c, 0x262f57 },
	{ 0x20c6d, 0x262f56 },
	{ 0x20c6e, 0x252850 },
	{ 0x20c6f, 0x262f50 },
	{ 0x20c70, 0x262f58 },
	{ 0x20c71, 0x262f52 },
	{ 0x20c72, 0x252840 },
	{ 0x20c73, 0x252842 },
	{ 0x20c75, 0x2f2b33 },
	{ 0x20c79, 0x2f2953 },
	{ 0x20c7a, 0x2f2955 },
	{ 0x20c7b, 0x2f2956 },
	{ 0x20c7c, 0x2f2957 },
	{ 0x20c7d, 0x2f2958 },
	{ 0x20c7e, 0x2f2959 },
	{ 0x20c7f, 0x2f295a },
	{ 0x20c80, 0x2f295b },
	{ 0x20c81, 0x2f295e },
	{ 0x20c82, 0x2f295f },
	{ 0x20c83, 0x2f2960 },
	{ 0x20c84, 0x2f2961 },
	{ 0x20c85, 0x2f2962 },
	{ 0x20c86, 0x2f2963 },
	{ 0x20c87, 0x2f2964 },
	{ 0x20c88, 0x2f2966 },
	{ 0x20c89, 0x2f2967 },
	{ 0x20c8b, 0x252843 },
	{ 0x20c8c, 0x252844 },
	{ 0x20c8e, 0x24285d },
	{ 0x20c8f, 0x2f2965 },
	{ 0x20c90, 0x262f55 },
	{ 0x20c93, 0x262f53 },
	{ 0x20c97, 0x242858 },
	{ 0x20ca9, 0x25283b },
	{ 0x20caa, 0x25283e },
	{ 0x20cab, 0x262f51 },
	{ 0x20cad, 0x263629 },
	{ 0x20cae, 0x242c24 },
	{ 0x20caf, 0x242c2b },
	{ 0x20cb0, 0x242c2c },
	{ 0x20cb1, 0x242c27 },
	{ 0x20cb2, 0x263622 },
	{ 0x20cb3, 0x252c4e },
	{ 0x20cb4, 0x252c41 },
	{ 0x20cb5, 0x252c3f },
	{ 0x20cb6, 0x252c4c },
	{ 0x20cb7, 0x252c3d },
	{ 0x20cb8, 0x252c46 },
	{ 0x20cb9, 0x252c56 },
	{ 0x20cba, 0x252c49 },
	{ 0x20cbb, 0x242c2a },
	{ 0x20cbc, 0x252c4d },
	{ 0x20cbd, 0x252c54 },
	{ 0x20cbe, 0x252c52 },
	{ 0x20cbf, 0x242c22 },
	{ 0x20cc0, 0x263623 },
	{ 0x20cc1, 0x263624 },
	{ 0x20cc2, 0x252c51 },
	{ 0x20cc3, 0x242c23 },
	{ 0x20cc4, 0x252c40 },
	{ 0x20cc5, 0x263627 },
	{ 0x20cc6, 0x263628 },
	{ 0x20cc7, 0x252c57 },
	{ 0x20cc8, 0x263626 },
	{ 0x20cc9, 0x252c53 },
	{ 0x20cca, 0x252c58 },
	{ 0x20ccb, 0x252c47 },
	{ 0x20ccc, 0x252c59 },
	{ 0x20ccd, 0x252c44 },
	{ 0x20cce, 0x252c55 },
	{ 0x20cdb, 0x2f2e40 },
	{ 0x20cdc, 0x2f2e41 },
	{ 0x20cdd, 0x2f2e43 },
	{ 0x20cde, 0x2f2e44 },
	{ 0x20cdf, 0x2f2e48 },
	{ 0x20ce0, 0x2f2e49 },
	{ 0x20ce1, 0x2f2e4b },
	{ 0x20ce2, 0x2f2e4c },
	{ 0x20ce3, 0x2f2e4d },
	{ 0x20ce4, 0x2f2e4e },
	{ 0x20ce5, 0x2f2e4f },
	{ 0x20ce6, 0x2f2e50 },
	{ 0x20ce7, 0x2f2e51 },
	{ 0x20ce8, 0x2f2e52 },
	{ 0x20ce9, 0x2f2e53 },
	{ 0x20cea, 0x2f2e54 },
	{ 0x20ceb, 0x26395e },
	{ 0x20cee, 0x263621 },
	{ 0x20cef, 0x252c42 },
	{ 0x20cf0, 0x252c45 },
	{ 0x20cf1, 0x252c48 },
	{ 0x20cf4, 0x263625 },
	{ 0x20cf7, 0x252c50 },
	{ 0x20cf8, 0x252c4b },
	{ 0x20cf9, 0x252c39 },
	{ 0x20cfa, 0x252c3a },
	{ 0x20cfb, 0x252c3b },
	{ 0x20cff, 0x2f2e45 },
	{ 0x20d03, 0x252c4a },
	{ 0x20d21, 0x252c4f },
	{ 0x20d22, 0x252c3e },
	{ 0x20d23, 0x252c3c },
	{ 0x20d26, 0x252c5a },
	{ 0x20d27, 0x253146 },
	{ 0x20d28, 0x243069 },
	{ 0x20d29, 0x263d77 },
	{ 0x20d2a, 0x263d74 },
	{ 0x20d2b, 0x243078 },
	{ 0x20d2c, 0x263d6f },
	{ 0x20d2d, 0x243075 },
	{ 0x20d2e, 0x253151 },
	{ 0x20d2f, 0x253149 },
	{ 0x20d30, 0x25314c },
	{ 0x20d31, 0x24306e },
	{ 0x20d32, 0x243079 },
	{ 0x20d33, 0x253144 },
	{ 0x20d34, 0x263d76 },
	{ 0x20d35, 0x253136 },
	{ 0x20d36, 0x25314a },
	{ 0x20d37, 0x253145 },
	{ 0x20d38, 0x25314e },
	{ 0x20d39, 0x253134 },
	{ 0x20d3a, 0x25314d },
	{ 0x20d3b, 0x253142 },
	{ 0x20d3c, 0x25313b },
	{ 0x20d3d, 0x263d71 },
	{ 0x20d3e, 0x263d75 },
	{ 0x20d3f, 0x263d7d },
	{ 0x20d40, 0x263d7a },
	{ 0x20d41, 0x263d7e },
	{ 0x20d42, 0x25313a },
	{ 0x20d43, 0x25313c },
	{ 0x20d4a, 0x263d6c },
	{ 0x20d51, 0x253138 },
	{ 0x20d52, 0x263d72 },
	{ 0x20d53, 0x263d7b },
	{ 0x20d54, 0x2f333f },
	{ 0x20d55, 0x2f3340 },
	{ 0x20d56, 0x2f3341 },
	{ 0x20d57, 0x2f3342 },
	{ 0x20d58, 0x2f3344 },
	{ 0x20d59, 0x2f3345 },
	{ 0x20d5a, 0x2f3346 },
	{ 0x20d5b, 0x2f3347 },
	{ 0x20d5c, 0x2f3348 },
	{ 0x20d5d, 0x2f3349 },
	{ 0x20d5e, 0x2f334c },
	{ 0x20d5f, 0x2f334d },
	{ 0x20d60, 0x253137 },
	{ 0x20d61, 0x263d73 },
	{ 0x20d62, 0x253139 },
	{ 0x20d65, 0x263d6d },
	{ 0x20d6a, 0x253141 },
	{ 0x20d70, 0x253148 },
	{ 0x20d72, 0x263e21 },
	{ 0x20d75, 0x253152 },
	{ 0x20d77, 0x263d70 },
	{ 0x20d79, 0x253140 },
	{ 0x20da7, 0x253135 },
	{ 0x20da8, 0x253147 },
	{ 0x20da9, 0x25313e },
	{ 0x20daa, 0x253143 },
	{ 0x20dab, 0x25313d },
	{ 0x20dac, 0x253150 },
	{ 0x20dad, 0x263d79 },
	{ 0x20dae, 0x233460 },
	{ 0x20db0, 0x253153 },
	{ 0x20db1, 0x25314f },
	{ 0x20db2, 0x263d78 },
	{ 0x20db3, 0x263d6e },
	{ 0x20db4, 0x25313f },
	{ 0x20db5, 0x25314b },
	{ 0x20db7, 0x243655 },
	{ 0x20db8, 0x243661 },
	{ 0x20dba, 0x264732 },
	{ 0x20dbb, 0x253724 },
	{ 0x20dbc, 0x264737 },
	{ 0x20dbd, 0x26473e },
	{ 0x20dbe, 0x253677 },
	{ 0x20dbf, 0x264735 },
	{ 0x20dc0, 0x25367c },
	{ 0x20dc1, 0x243656 },
	{ 0x20dc2, 0x253728 },
	{ 0x20dc3, 0x25366f },
	{ 0x20dc4, 0x253671 },
	{ 0x20dc5, 0x24365a },
	{ 0x20dc6, 0x253678 },
	{ 0x20dc7, 0x243657 },
	{ 0x20dc8, 0x253729 },
	{ 0x20dc9, 0x25367e },
	{ 0x20dca, 0x243662 },
	{ 0x20dcb, 0x24365b },
	{ 0x20dcc, 0x253723 },
	{ 0x20dcd, 0x253727 },
	{ 0x20dce, 0x243666 },
	{ 0x20dcf, 0x253730 },
	{ 0x20dd1, 0x24365d },
	{ 0x20dd2, 0x25372c },
	{ 0x20dd3, 0x25372e },
	{ 0x20dd4, 0x26472e },
	{ 0x20dd5, 0x26473c },
	{ 0x20dd6, 0x253e22 },
	{ 0x20dd7, 0x26472b },
	{ 0x20dd8, 0x26472f },
	{ 0x20dd9, 0x264738 },
	{ 0x20dda, 0x253722 },
	{ 0x20ddb, 0x264734 },
	{ 0x20ddc, 0x26473f },
	{ 0x20ddd, 0x26473a },
	{ 0x20dde, 0x243664 },
	{ 0x20ddf, 0x253726 },
	{ 0x20de7, 0x253673 },
	{ 0x20de8, 0x2f395b },
	{ 0x20de9, 0x2f395d },
	{ 0x20dea, 0x2f395e },
	{ 0x20deb, 0x2f3961 },
	{ 0x20dec, 0x2f3962 },
	{ 0x20ded, 0x2f3963 },
	{ 0x20dee, 0x2f3964 },
	{ 0x20def, 0x2f3965 },
	{ 0x20df0, 0x2f3966 },
	{ 0x20df1, 0x2f3967 },
	{ 0x20df2, 0x2f3968 },
	{ 0x20df3, 0x2f396a },
	{ 0x20df4, 0x2f396d },
	{ 0x20df5, 0x2f396e },
	{ 0x20df6, 0x2f396f },
	{ 0x20df7, 0x2f3970 },
	{ 0x20df8, 0x253674 },
	{ 0x20dfb, 0x253675 },
	{ 0x20dfc, 0x25367b },
	{ 0x20dfd, 0x253725 },
	{ 0x20dfe, 0x253721 },
	{ 0x20e00, 0x26473b },
	{ 0x20e04, 0x2f396b },
	{ 0x20e0c, 0x2f395c },
	{ 0x20e0d, 0x2f395f },
	{ 0x20e16, 0x2f3969 },
	{ 0x20e1d, 0x2f396c },
	{ 0x20e2d, 0x25372b },
	{ 0x20e2e, 0x25372f },
	{ 0x20e30, 0x26473d },
	{ 0x20e31, 0x25372d },
	{ 0x20e32, 0x25372a },
	{ 0x20e33, 0x25367d },
	{ 0x20e35, 0x264736 },
	{ 0x20e36, 0x265139 },
	{ 0x20e37, 0x253e23 },
	{ 0x20e38, 0x243c49 },
	{ 0x20e39, 0x253e27 },
	{ 0x20e3a, 0x243c4e },
	{ 0x20e3b, 0x253672 },
	{ 0x20e3f, 0x265141 },
	{ 0x20e40, 0x243c48 },
	{ 0x20e41, 0x243c44 },
	{ 0x20e42, 0x265b42 },
	{ 0x20e43, 0x253e2d },
	{ 0x20e44, 0x265133 },
	{ 0x20e45, 0x265135 },
	{ 0x20e46, 0x253e2a },
	{ 0x20e47, 0x253e38 },
	{ 0x20e48, 0x26513a },
	{ 0x20e49, 0x265130 },
	{ 0x20e4a, 0x253e2e },
	{ 0x20e4b, 0x253e24 },
	{ 0x20e4c, 0x253e35 },
	{ 0x20e4d, 0x253e3f },
	{ 0x20e4e, 0x26513f },
	{ 0x20e4f, 0x265137 },
	{ 0x20e50, 0x253e34 },
	{ 0x20e51, 0x253e37 },
	{ 0x20e52, 0x243c4d },
	{ 0x20e53, 0x253e3a },
	{ 0x20e54, 0x243c45 },
	{ 0x20e55, 0x253e33 },
	{ 0x20e56, 0x253e2c },
	{ 0x20e57, 0x243c4f },
	{ 0x20e58, 0x253e2f },
	{ 0x20e59, 0x243c51 },
	{ 0x20e5a, 0x253e31 },
	{ 0x20e5b, 0x253e32 },
	{ 0x20e5c, 0x26513b },
	{ 0x20e5e, 0x265140 },
	{ 0x20e5f, 0x26512a },
	{ 0x20e60, 0x26513e },
	{ 0x20e61, 0x26513d },
	{ 0x20e62, 0x253e3b },
	{ 0x20e63, 0x265138 },
	{ 0x20e64, 0x253e28 },
	{ 0x20e65, 0x253e30 },
	{ 0x20e66, 0x253e2b },
	{ 0x20e67, 0x26512c },
	{ 0x20e68, 0x265144 },
	{ 0x20e69, 0x26512e },
	{ 0x20e6a, 0x26512b },
	{ 0x20e6b, 0x26512d },
	{ 0x20e6e, 0x2f4726 },
	{ 0x20e7f, 0x253e3e },
	{ 0x20e80, 0x265131 },
	{ 0x20e81, 0x2f4056 },
	{ 0x20e82, 0x2f4057 },
	{ 0x20e83, 0x2f4058 },
	{ 0x20e84, 0x2f4059 },
	{ 0x20e85, 0x2f405a },
	{ 0x20e86, 0x2f405b },
	{ 0x20e87, 0x2f405c },
	{ 0x20e88, 0x2f405d },
	{ 0x20e89, 0x2f405e },
	{ 0x20e8a, 0x2f405f },
	{ 0x20e8b, 0x2f4060 },
	{ 0x20e8c, 0x2f4061 },
	{ 0x20e8d, 0x2f4063 },
	{ 0x20e8e, 0x26512f },
	{ 0x20e8f, 0x265134 },
	{ 0x20e93, 0x26513c },
	{ 0x20ea2, 0x2f4054 },
	{ 0x20ea4, 0x265142 },
	{ 0x20ecc, 0x253e3c },
	{ 0x20ecd, 0x253e36 },
	{ 0x20ece, 0x253e25 },
	{ 0x20ecf, 0x253e29 },
	{ 0x20ed0, 0x253e26 },
	{ 0x20ed1, 0x2f4064 },
	{ 0x20ed4, 0x265b46 },
	{ 0x20ed5, 0x265b40 },
	{ 0x20ed6, 0x265b4b },
	{ 0x20ed7, 0x24424d },
	{ 0x20ed8, 0x265b4f },
	{ 0x20ed9, 0x265b45 },
	{ 0x20eda, 0x265b51 },
	{ 0x20edb, 0x265b50 },
	{ 0x20edc, 0x24424e },
	{ 0x20edd, 0x265b4c },
	{ 0x20ede, 0x254473 },
	{ 0x20edf, 0x254477 },
	{ 0x20ee0, 0x254475 },
	{ 0x20ee1, 0x25447c },
	{ 0x20ee2, 0x265b43 },
	{ 0x20ee3, 0x265b47 },
	{ 0x20ee4, 0x24424c },
	{ 0x20ee5, 0x244254 },
	{ 0x20ee6, 0x25447b },
	{ 0x20ee7, 0x244250 },
	{ 0x20ee8, 0x254476 },
	{ 0x20ee9, 0x265b41 },
	{ 0x20eea, 0x254471 },
	{ 0x20eeb, 0x254472 },
	{ 0x20eec, 0x254479 },
	{ 0x20eed, 0x265b52 },
	{ 0x20eee, 0x265b3f },
	{ 0x20eef, 0x265b49 },
	{ 0x20ef0, 0x265b4a },
	{ 0x20ef1, 0x254478 },
	{ 0x20ef6, 0x265b4d },
	{ 0x20efe, 0x2f4671 },
	{ 0x20eff, 0x2f4672 },
	{ 0x20f00, 0x2f4673 },
	{ 0x20f01, 0x2f4674 },
	{ 0x20f02, 0x2f4676 },
	{ 0x20f03, 0x2f4677 },
	{ 0x20f04, 0x2f4678 },
	{ 0x20f05, 0x2f4679 },
	{ 0x20f06, 0x2f467a },
	{ 0x20f07, 0x2f467b },
	{ 0x20f08, 0x2f467c },
	{ 0x20f09, 0x2f467e },
	{ 0x20f0a, 0x2f4721 },
	{ 0x20f0b, 0x2f4722 },
	{ 0x20f0c, 0x2f4723 },
	{ 0x20f0d, 0x2f4727 },
	{ 0x20f0e, 0x2f4728 },
	{ 0x20f0f, 0x2f4729 },
	{ 0x20f10, 0x2f472a },
	{ 0x20f11, 0x2f472b },
	{ 0x20f12, 0x2f472c },
	{ 0x20f13, 0x2f472d },
	{ 0x20f14, 0x2f4724 },
	{ 0x20f15, 0x265b48 },
	{ 0x20f16, 0x2f4675 },
	{ 0x20f18, 0x254474 },
	{ 0x20f1a, 0x25447a },
	{ 0x20f1c, 0x265b4e },
	{ 0x20f1e, 0x254521 },
	{ 0x20f22, 0x2f467d },
	{ 0x20f23, 0x265b44 },
	{ 0x20f29, 0x2f4725 },
	{ 0x20f5c, 0x254c35 },
	{ 0x20f5d, 0x25447d },
	{ 0x20f60, 0x2f466c },
	{ 0x20f62, 0x272151 },
	{ 0x20f63, 0x254c3b },
	{ 0x20f64, 0x272155 },
	{ 0x20f65, 0x272152 },
	{ 0x20f66, 0x254c39 },
	{ 0x20f67, 0x272158 },
	{ 0x20f68, 0x27214a },
	{ 0x20f69, 0x254c40 },
	{ 0x20f6a, 0x254c46 },
	{ 0x20f6b, 0x254c3d },
	{ 0x20f6c, 0x27214f },
	{ 0x20f6d, 0x254c3e },
	{ 0x20f6e, 0x272157 },
	{ 0x20f6f, 0x272150 },
	{ 0x20f70, 0x254c36 },
	{ 0x20f71, 0x27214b },
	{ 0x20f72, 0x254c3f },
	{ 0x20f73, 0x272156 },
	{ 0x20f74, 0x272159 },
	{ 0x20f75, 0x254c41 },
	{ 0x20f76, 0x24492f },
	{ 0x20f78, 0x27215b },
	{ 0x20f79, 0x254c3a },
	{ 0x20f7a, 0x272148 },
	{ 0x20f7b, 0x254c38 },
	{ 0x20f7c, 0x255b27 },
	{ 0x20f7d, 0x27215a },
	{ 0x20f7e, 0x24492b },
	{ 0x20f7f, 0x272154 },
	{ 0x20f80, 0x254523 },
	{ 0x20f81, 0x272153 },
	{ 0x20f82, 0x272149 },
	{ 0x20f83, 0x272147 },
	{ 0x20f84, 0x272162 },
	{ 0x20f85, 0x27215c },
	{ 0x20f86, 0x2f4d7a },
	{ 0x20f88, 0x27215e },
	{ 0x20f89, 0x254c42 },
	{ 0x20f8a, 0x272161 },
	{ 0x20f8b, 0x272c61 },
	{ 0x20f8c, 0x254c37 },
	{ 0x20f96, 0x244932 },
	{ 0x20f97, 0x254c47 },
	{ 0x20f98, 0x2f4d6f },
	{ 0x20f99, 0x2f4d70 },
	{ 0x20f9a, 0x2f4d71 },
	{ 0x20f9b, 0x2f4d72 },
	{ 0x20f9c, 0x2f4d73 },
	{ 0x20f9d, 0x2f4d74 },
	{ 0x20f9e, 0x2f4d75 },
	{ 0x20f9f, 0x2f4d76 },
	{ 0x20fa0, 0x2f4d78 },
	{ 0x20fa1, 0x2f4d79 },
	{ 0x20fa5, 0x254c44 },
	{ 0x20fa6, 0x27215f },
	{ 0x20fa7, 0x27262b },
	{ 0x20faa, 0x27215d },
	{ 0x20faf, 0x27214d },
	{ 0x20fb0, 0x27214c },
	{ 0x20fc5, 0x254c3c },
	{ 0x20fc6, 0x254c43 },
	{ 0x20fc7, 0x272c6a },
	{ 0x20fc8, 0x244f6e },
	{ 0x20fc9, 0x255374 },
	{ 0x20fca, 0x272c5c },
	{ 0x20fcb, 0x255372 },
	{ 0x20fcc, 0x272c68 },
	{ 0x20fcd, 0x244f72 },
	{ 0x20fce, 0x25536a },
	{ 0x20fcf, 0x255378 },
	{ 0x20fd0, 0x272c60 },
	{ 0x20fd1, 0x244f68 },
	{ 0x20fd2, 0x244f73 },
	{ 0x20fd3, 0x244f66 },
	{ 0x20fd4, 0x255371 },
	{ 0x20fd5, 0x244f70 },
	{ 0x20fd6, 0x25536f },
	{ 0x20fd7, 0x255368 },
	{ 0x20fd8, 0x272c6b },
	{ 0x20fd9, 0x272c5b },
	{ 0x20fda, 0x272c64 },
	{ 0x20fdb, 0x25536e },
	{ 0x20fdc, 0x272c5f },
	{ 0x20fdd, 0x25536c },
	{ 0x20fde, 0x255367 },
	{ 0x20fdf, 0x255375 },
	{ 0x20fe0, 0x255370 },
	{ 0x20fe1, 0x255373 },
	{ 0x20fe2, 0x272c59 },
	{ 0x20fe3, 0x25536b },
	{ 0x20fe4, 0x255369 },
	{ 0x20fe5, 0x272c67 },
	{ 0x20fe6, 0x272c58 },
	{ 0x20fe7, 0x272c57 },
	{ 0x20fee, 0x2f4d77 },
	{ 0x20ffa, 0x244f69 },
	{ 0x20ffb, 0x244f74 },
	{ 0x20ffc, 0x255377 },
	{ 0x20ffd, 0x272c66 },
	{ 0x20ffe, 0x2f535c },
	{ 0x20fff, 0x2f535e },
	{ 0x21000, 0x2f535f },
	{ 0x21001, 0x2f5360 },
	{ 0x21002, 0x2f5361 },
	{ 0x21003, 0x2f5362 },
	{ 0x21004, 0x2f5363 },
	{ 0x21005, 0x2f5364 },
	{ 0x21006, 0x2f5365 },
	{ 0x21007, 0x2f5367 },
	{ 0x21008, 0x2f5368 },
	{ 0x21009, 0x2f5369 },
	{ 0x2100a, 0x2f536a },
	{ 0x2100b, 0x2f536b },
	{ 0x2100c, 0x2f536c },
	{ 0x2100d, 0x2f536d },
	{ 0x2100e, 0x2f536e },
	{ 0x2100f, 0x2f536f },
	{ 0x21010, 0x272c5e },
	{ 0x21012, 0x272c5d },
	{ 0x21013, 0x272c62 },
	{ 0x21039, 0x272c69 },
	{ 0x2103a, 0x25536d },
	{ 0x2103b, 0x2f5574 },
	{ 0x2103c, 0x255376 },
	{ 0x2103d, 0x24557a },
	{ 0x2103f, 0x255b26 },
	{ 0x21041, 0x255b21 },
	{ 0x21042, 0x27372d },
	{ 0x21043, 0x27372a },
	{ 0x21044, 0x273734 },
	{ 0x21045, 0x273735 },
	{ 0x21046, 0x255b23 },
	{ 0x21047, 0x255b2b },
	{ 0x21048, 0x245571 },
	{ 0x21049, 0x245576 },
	{ 0x2104b, 0x255b28 },
	{ 0x2104c, 0x245577 },
	{ 0x2104d, 0x27372b },
	{ 0x2104e, 0x255b29 },
	{ 0x2104f, 0x245579 },
	{ 0x21050, 0x273731 },
	{ 0x21051, 0x27372f },
	{ 0x21052, 0x27372e },
	{ 0x21053, 0x255b24 },
	{ 0x21055, 0x245575 },
	{ 0x21056, 0x273732 },
	{ 0x21057, 0x273739 },
	{ 0x2105f, 0x2f5959 },
	{ 0x21060, 0x2f595a },
	{ 0x21061, 0x2f595e },
	{ 0x21062, 0x2f595f },
	{ 0x21063, 0x2f5960 },
	{ 0x21064, 0x2f5961 },
	{ 0x21065, 0x2f5962 },
	{ 0x21068, 0x273738 },
	{ 0x21069, 0x273730 },
	{ 0x2106b, 0x273736 },
	{ 0x2106c, 0x273733 },
	{ 0x2106d, 0x27372c },
	{ 0x2108a, 0x255b2a },
	{ 0x2108b, 0x255b22 },
	{ 0x2108f, 0x245a74 },
	{ 0x21090, 0x273f29 },
	{ 0x21091, 0x273f2f },
	{ 0x21092, 0x245a73 },
	{ 0x21093, 0x25613e },
	{ 0x21094, 0x273f2b },
	{ 0x21095, 0x245a71 },
	{ 0x21096, 0x245a76 },
	{ 0x21097, 0x256146 },
	{ 0x21098, 0x245a77 },
	{ 0x21099, 0x256758 },
	{ 0x2109a, 0x25613d },
	{ 0x2109b, 0x256144 },
	{ 0x2109c, 0x256143 },
	{ 0x2109d, 0x245a78 },
	{ 0x2109e, 0x273f2a },
	{ 0x2109f, 0x245a75 },
	{ 0x210a0, 0x245a79 },
	{ 0x210a1, 0x245a72 },
	{ 0x210a2, 0x273f2e },
	{ 0x210a3, 0x256141 },
	{ 0x210a4, 0x273f27 },
	{ 0x210a5, 0x273f2d },
	{ 0x210a6, 0x273f28 },
	{ 0x210a7, 0x273f26 },
	{ 0x210a8, 0x273f2c },
	{ 0x210a9, 0x256142 },
	{ 0x210ac, 0x2f595b },
	{ 0x210b6, 0x273f25 },
	{ 0x210b7, 0x2f5e3c },
	{ 0x210b8, 0x2f5e3d },
	{ 0x210b9, 0x2f5e3e },
	{ 0x210ba, 0x2f5e3f },
	{ 0x210bb, 0x2f5e40 },
	{ 0x210bc, 0x2f5e43 },
	{ 0x210bd, 0x2f5e44 },
	{ 0x210be, 0x2f5e45 },
	{ 0x210dd, 0x25613f },
	{ 0x210df, 0x2f5e4a },
	{ 0x210e0, 0x274634 },
	{ 0x210e1, 0x245f4e },
	{ 0x210e2, 0x255b25 },
	{ 0x210e3, 0x27463b },
	{ 0x210e4, 0x274639 },
	{ 0x210e5, 0x274637 },
	{ 0x210e6, 0x25675a },
	{ 0x210e7, 0x25675b },
	{ 0x210e8, 0x245f50 },
	{ 0x210e9, 0x256757 },
	{ 0x210ea, 0x27463c },
	{ 0x210eb, 0x27463a },
	{ 0x210ec, 0x274633 },
	{ 0x210ed, 0x274635 },
	{ 0x210ee, 0x274638 },
	{ 0x210ef, 0x245f4f },
	{ 0x210f2, 0x2f5e46 },
	{ 0x210f7, 0x25675c },
	{ 0x21102, 0x2f6222 },
	{ 0x21103, 0x2f6223 },
	{ 0x21104, 0x2f6224 },
	{ 0x21105, 0x2f6225 },
	{ 0x21106, 0x2f6226 },
	{ 0x21108, 0x274636 },
	{ 0x21109, 0x27476e },
	{ 0x2110a, 0x27463d },
	{ 0x21111, 0x256b74 },
	{ 0x21112, 0x256b75 },
	{ 0x21113, 0x256b6f },
	{ 0x21114, 0x256b71 },
	{ 0x21115, 0x256b70 },
	{ 0x21116, 0x274d47 },
	{ 0x21117, 0x274d49 },
	{ 0x21118, 0x274d4b },
	{ 0x21119, 0x274d48 },
	{ 0x2111a, 0x274d46 },
	{ 0x2111b, 0x274d4a },
	{ 0x2111c, 0x2f647d },
	{ 0x2111d, 0x2f647e },
	{ 0x2111e, 0x2f6521 },
	{ 0x21120, 0x274d4c },
	{ 0x21123, 0x256b72 },
	{ 0x21131, 0x27527b },
	{ 0x21132, 0x256f71 },
	{ 0x21133, 0x256f6f },
	{ 0x21134, 0x246635 },
	{ 0x21135, 0x256f6e },
	{ 0x21136, 0x27527a },
	{ 0x21137, 0x256f6d },
	{ 0x21138, 0x27527e },
	{ 0x21139, 0x256f70 },
	{ 0x2113a, 0x27527d },
	{ 0x2113b, 0x246633 },
	{ 0x2113f, 0x2f6747 },
	{ 0x21140, 0x2f6748 },
	{ 0x21141, 0x256f6c },
	{ 0x21154, 0x27527c },
	{ 0x21157, 0x275759 },
	{ 0x21158, 0x27575a },
	{ 0x21159, 0x257333 },
	{ 0x2115a, 0x275755 },
	{ 0x2115c, 0x275756 },
	{ 0x2115d, 0x275757 },
	{ 0x2115e, 0x275754 },
	{ 0x2115f, 0x275752 },
	{ 0x21161, 0x275753 },
	{ 0x21163, 0x2f693c },
	{ 0x2116d, 0x246864 },
	{ 0x2116e, 0x275758 },
	{ 0x21170, 0x275b49 },
	{ 0x21171, 0x275b4a },
	{ 0x21172, 0x2f6a4d },
	{ 0x21176, 0x275b48 },
	{ 0x21178, 0x275b47 },
	{ 0x21179, 0x257755 },
	{ 0x2117a, 0x257756 },
	{ 0x2117b, 0x246b66 },
	{ 0x2117c, 0x275e53 },
	{ 0x2117d, 0x275e55 },
	{ 0x2117e, 0x275e54 },
	{ 0x2117f, 0x275e56 },
	{ 0x21183, 0x2f6b43 },
	{ 0x21185, 0x257567 },
	{ 0x21186, 0x257923 },
	{ 0x21189, 0x246c6d },
	{ 0x2118a, 0x2f6c22 },
	{ 0x2118b, 0x2f6c23 },
	{ 0x2118e, 0x27606b },
	{ 0x2118f, 0x276232 },
	{ 0x21190, 0x276231 },
	{ 0x21191, 0x276234 },
	{ 0x21192, 0x276230 },
	{ 0x21193, 0x276233 },
	{ 0x2119b, 0x2f6c79 },
	{ 0x2119c, 0x2f6c7a },
	{ 0x211a0, 0x262165 },
	{ 0x211a1, 0x262166 },
	{ 0x211a2, 0x2f2137 },
	{ 0x211a3, 0x24216e },
	{ 0x211a7, 0x262432 },
	{ 0x211a8, 0x262430 },
	{ 0x211a9, 0x252249 },
	{ 0x211ad, 0x2f2235 },
	{ 0x211b0, 0x262431 },
	{ 0x211b2, 0x26242f },
	{ 0x211b3, 0x252248 },
	{ 0x211b4, 0x262654 },
	{ 0x211b5, 0x262f5c },
	{ 0x211b6, 0x262a3e },
	{ 0x211b7, 0x262658 },
	{ 0x211b8, 0x262656 },
	{ 0x211b9, 0x2f234f },
	{ 0x211ba, 0x2f2351 },
	{ 0x211bb, 0x262657 },
	{ 0x211bc, 0x262659 },
	{ 0x211be, 0x26265c },
	{ 0x211bf, 0x26265a },
	{ 0x211c1, 0x262651 },
	{ 0x211c3, 0x262655 },
	{ 0x211c4, 0x262652 },
	{ 0x211c6, 0x262653 },
	{ 0x211c7, 0x26265b },
	{ 0x211c8, 0x252555 },
	{ 0x211c9, 0x262a43 },
	{ 0x211ca, 0x262a40 },
	{ 0x211cb, 0x262a41 },
	{ 0x211cc, 0x262a42 },
	{ 0x211cd, 0x262d34 },
	{ 0x211ce, 0x262a3f },
	{ 0x211d0, 0x2f2624 },
	{ 0x211d1, 0x252554 },
	{ 0x211d2, 0x252854 },
	{ 0x211d3, 0x252856 },
	{ 0x211d4, 0x262f60 },
	{ 0x211d5, 0x262f5f },
	{ 0x211d6, 0x252855 },
	{ 0x211d7, 0x262f5b },
	{ 0x211d8, 0x262f5e },
	{ 0x211db, 0x262f5d },
	{ 0x211e0, 0x252c5c },
	{ 0x211e1, 0x26362d },
	{ 0x211e2, 0x26362a },
	{ 0x211e3, 0x26362c },
	{ 0x211e4, 0x252c5b },
	{ 0x211ea, 0x26362b },
	{ 0x211f0, 0x252c5d },
	{ 0x211f1, 0x253156 },
	{ 0x211f2, 0x263e25 },
	{ 0x211f3, 0x253157 },
	{ 0x211f4, 0x263e24 },
	{ 0x211f5, 0x263e23 },
	{ 0x211f6, 0x263e22 },
	{ 0x211f7, 0x253154 },
	{ 0x211f9, 0x263e26 },
	{ 0x211fc, 0x253733 },
	{ 0x211fd, 0x264740 },
	{ 0x211fe, 0x264741 },
	{ 0x211ff, 0x253731 },
	{ 0x21200, 0x253155 },
	{ 0x21202, 0x2f3972 },
	{ 0x21203, 0x2f3973 },
	{ 0x21204, 0x2f3974 },
	{ 0x21207, 0x264742 },
	{ 0x21209, 0x253732 },
	{ 0x2120a, 0x253e40 },
	{ 0x2120b, 0x265145 },
	{ 0x2120c, 0x253e41 },
	{ 0x2120d, 0x265147 },
	{ 0x2120e, 0x265148 },
	{ 0x2120f, 0x253e42 },
	{ 0x21211, 0x265146 },
	{ 0x21214, 0x2f4065 },
	{ 0x21215, 0x265b54 },
	{ 0x21216, 0x265b58 },
	{ 0x21217, 0x254524 },
	{ 0x21218, 0x265b55 },
	{ 0x21219, 0x265b5a },
	{ 0x2121a, 0x265b56 },
	{ 0x2121b, 0x2f472e },
	{ 0x2121c, 0x2f472f },
	{ 0x2121d, 0x2f4730 },
	{ 0x2121f, 0x265b57 },
	{ 0x21222, 0x272165 },
	{ 0x21223, 0x272166 },
	{ 0x21224, 0x272164 },
	{ 0x21225, 0x2f4d7b },
	{ 0x2122a, 0x244f75 },
	{ 0x2122c, 0x2f5373 },
	{ 0x2122d, 0x27373c },
	{ 0x2122e, 0x27373a },
	{ 0x21231, 0x27373b },
	{ 0x21233, 0x245f51 },
	{ 0x21237, 0x274d4d },
	{ 0x21238, 0x275322 },
	{ 0x21239, 0x275321 },
	{ 0x2123c, 0x242148 },
	{ 0x2123e, 0x252144 },
	{ 0x2123f, 0x262260 },
	{ 0x21241, 0x2f2151 },
	{ 0x21242, 0x2f2152 },
	{ 0x21244, 0x262261 },
	{ 0x2124a, 0x262435 },
	{ 0x2124c, 0x2f2236 },
	{ 0x2124d, 0x2f2237 },
	{ 0x21252, 0x262434 },
	{ 0x21258, 0x26266a },
	{ 0x21259, 0x242360 },
	{ 0x2125a, 0x262666 },
	{ 0x2125b, 0x262662 },
	{ 0x2125d, 0x26265e },
	{ 0x2125f, 0x262669 },
	{ 0x21260, 0x26265d },
	{ 0x21261, 0x262665 },
	{ 0x21262, 0x262667 },
	{ 0x21263, 0x2f2353 },
	{ 0x21264, 0x2f2354 },
	{ 0x21265, 0x2f2356 },
	{ 0x21266, 0x2f2358 },
	{ 0x21267, 0x2f235a },
	{ 0x2126c, 0x262660 },
	{ 0x21271, 0x262663 },
	{ 0x21272, 0x262668 },
	{ 0x21273, 0x262664 },
	{ 0x21275, 0x262661 },
	{ 0x21276, 0x26265f },
	{ 0x21277, 0x25235e },
	{ 0x2127c, 0x2f2359 },
	{ 0x21280, 0x25235d },
	{ 0x21281, 0x25235f },
	{ 0x21282, 0x252360 },
	{ 0x21283, 0x252361 },
	{ 0x21284, 0x24256a },
	{ 0x21285, 0x262a4f },
	{ 0x21286, 0x262a47 },
	{ 0x21287, 0x262a4c },
	{ 0x21288, 0x262a46 },
	{ 0x21289, 0x242567 },
	{ 0x2128a, 0x262a4a },
	{ 0x2128b, 0x24256c },
	{ 0x2128c, 0x262a48 },
	{ 0x2128d, 0x252556 },
	{ 0x2128e, 0x262a51 },
	{ 0x2128f, 0x262641 },
	{ 0x21293, 0x262a49 },
	{ 0x21294, 0x2f2626 },
	{ 0x21295, 0x2f2627 },
	{ 0x21296, 0x2f2628 },
	{ 0x21297, 0x2f2629 },
	{ 0x21298, 0x2f262a },
	{ 0x21299, 0x2f2630 },
	{ 0x2129a, 0x2f2631 },
	{ 0x2129b, 0x2f262c },
	{ 0x2129c, 0x2f262b },
	{ 0x2129e, 0x24256b },
	{ 0x212a0, 0x2f262f },
	{ 0x212a1, 0x2f262e },
	{ 0x212a3, 0x262a50 },
	{ 0x212a4, 0x262a4b },
	{ 0x212a5, 0x262a4d },
	{ 0x212a6, 0x262a4e },
	{ 0x212a7, 0x2f2632 },
	{ 0x212a8, 0x2f2625 },
	{ 0x212ac, 0x262a45 },
	{ 0x212b4, 0x262a44 },
	{ 0x212b5, 0x252557 },
	{ 0x212b6, 0x25285b },
	{ 0x212b7, 0x262f62 },
	{ 0x212b8, 0x252857 },
	{ 0x212b9, 0x262f64 },
	{ 0x212ba, 0x262f61 },
	{ 0x212bb, 0x252858 },
	{ 0x212bc, 0x24285f },
	{ 0x212bd, 0x262f6b },
	{ 0x212be, 0x262f63 },
	{ 0x212c4, 0x2f297a },
	{ 0x212c5, 0x2f2968 },
	{ 0x212c6, 0x2f2969 },
	{ 0x212c7, 0x2f296b },
	{ 0x212c8, 0x2f296c },
	{ 0x212c9, 0x2f296d },
	{ 0x212ca, 0x2f296e },
	{ 0x212cb, 0x2f296f },
	{ 0x212cc, 0x2f2970 },
	{ 0x212cd, 0x2f2972 },
	{ 0x212ce, 0x2f2973 },
	{ 0x212cf, 0x2f2975 },
	{ 0x212d0, 0x2f2976 },
	{ 0x212d1, 0x2f2977 },
	{ 0x212d2, 0x2f2978 },
	{ 0x212d3, 0x2f2979 },
	{ 0x212d4, 0x2f297b },
	{ 0x212d5, 0x2f297c },
	{ 0x212d6, 0x2f297d },
	{ 0x212d8, 0x262f6a },
	{ 0x212db, 0x262f6c },
	{ 0x212dc, 0x263431 },
	{ 0x212dd, 0x262f67 },
	{ 0x212de, 0x262f68 },
	{ 0x212e0, 0x262f66 },
	{ 0x212e3, 0x2f2974 },
	{ 0x212e7, 0x25285d },
	{ 0x212e8, 0x25285a },
	{ 0x212e9, 0x25285e },
	{ 0x212ea, 0x25285c },
	{ 0x212eb, 0x252859 },
	{ 0x212ec, 0x252c5e },
	{ 0x212ed, 0x242c32 },
	{ 0x212ee, 0x263634 },
	{ 0x212ef, 0x242c30 },
	{ 0x212f0, 0x242c34 },
	{ 0x212f1, 0x263632 },
	{ 0x212f2, 0x26363c },
	{ 0x212f3, 0x263636 },
	{ 0x212f4, 0x26363d },
	{ 0x212f5, 0x26363e },
	{ 0x212f6, 0x263631 },
	{ 0x212f7, 0x26362e },
	{ 0x212f8, 0x26363a },
	{ 0x21301, 0x26362f },
	{ 0x21306, 0x263640 },
	{ 0x21307, 0x2f2e55 },
	{ 0x21308, 0x2f2e56 },
	{ 0x21309, 0x2f2e57 },
	{ 0x2130a, 0x2f2e58 },
	{ 0x2130b, 0x2f2e59 },
	{ 0x2130c, 0x2f2e5a },
	{ 0x2130d, 0x2f2e5b },
	{ 0x2130e, 0x2f2e5e },
	{ 0x2130f, 0x2f2e5f },
	{ 0x21310, 0x2f2e60 },
	{ 0x21312, 0x263630 },
	{ 0x21313, 0x26363f },
	{ 0x21315, 0x263637 },
	{ 0x21316, 0x263638 },
	{ 0x21317, 0x263639 },
	{ 0x21318, 0x252c60 },
	{ 0x21319, 0x26363b },
	{ 0x2131a, 0x2f2e5d },
	{ 0x2131c, 0x2f2e61 },
	{ 0x2131f, 0x263633 },
	{ 0x21324, 0x252c5f },
	{ 0x21325, 0x252c62 },
	{ 0x21326, 0x24307d },
	{ 0x21327, 0x263e27 },
	{ 0x21329, 0x24307c },
	{ 0x2132a, 0x25315d },
	{ 0x2132b, 0x263e34 },
	{ 0x2132c, 0x263e2d },
	{ 0x2132d, 0x25315b },
	{ 0x2132e, 0x263e2a },
	{ 0x2132f, 0x252c61 },
	{ 0x21330, 0x263e33 },
	{ 0x21331, 0x263e30 },
	{ 0x21332, 0x25315a },
	{ 0x21333, 0x243122 },
	{ 0x21334, 0x243123 },
	{ 0x21336, 0x2f334f },
	{ 0x21337, 0x2f335b },
	{ 0x21338, 0x263e2e },
	{ 0x21339, 0x263e2f },
	{ 0x2133b, 0x2f334e },
	{ 0x2133c, 0x2f3350 },
	{ 0x2133d, 0x2f3351 },
	{ 0x2133e, 0x2f3352 },
	{ 0x2133f, 0x2f3353 },
	{ 0x21340, 0x2f3354 },
	{ 0x21341, 0x2f3355 },
	{ 0x21342, 0x2f3356 },
	{ 0x21343, 0x2f3358 },
	{ 0x21344, 0x2f3359 },
	{ 0x21345, 0x2f335a },
	{ 0x21346, 0x2f335e },
	{ 0x21347, 0x2f335f },
	{ 0x21348, 0x2f3360 },
	{ 0x21349, 0x2f3361 },
	{ 0x2134a, 0x25315c },
	{ 0x2134f, 0x263e31 },
	{ 0x21351, 0x263e35 },
	{ 0x21353, 0x24307e },
	{ 0x21354, 0x263e28 },
	{ 0x21355, 0x263e29 },
	{ 0x21360, 0x253158 },
	{ 0x21361, 0x253159 },
	{ 0x21364, 0x233a4f },
	{ 0x21365, 0x26514e },
	{ 0x21366, 0x243672 },
	{ 0x21367, 0x264747 },
	{ 0x21368, 0x24366a },
	{ 0x21369, 0x264745 },
	{ 0x2136a, 0x243670 },
	{ 0x2136b, 0x24366c },
	{ 0x2136c, 0x26474b },
	{ 0x2136d, 0x264750 },
	{ 0x2136e, 0x243675 },
	{ 0x2136f, 0x264744 },
	{ 0x21370, 0x264746 },
	{ 0x21371, 0x26474d },
	{ 0x21372, 0x253734 },
	{ 0x21373, 0x263e32 },
	{ 0x21374, 0x26474f },
	{ 0x21375, 0x243c5a },
	{ 0x21376, 0x253739 },
	{ 0x21377, 0x243673 },
	{ 0x2137a, 0x264f6d },
	{ 0x2137b, 0x253738 },
	{ 0x2137c, 0x2f3976 },
	{ 0x2137d, 0x2f3978 },
	{ 0x2137e, 0x2f3979 },
	{ 0x2137f, 0x2f397a },
	{ 0x21380, 0x2f397b },
	{ 0x21381, 0x2f397c },
	{ 0x21382, 0x2f3a21 },
	{ 0x21383, 0x2f3a22 },
	{ 0x21384, 0x2f3a23 },
	{ 0x21385, 0x2f3a24 },
	{ 0x21386, 0x2f3a25 },
	{ 0x21387, 0x2f3a26 },
	{ 0x2138e, 0x264751 },
	{ 0x21390, 0x26474a },
	{ 0x21395, 0x264749 },
	{ 0x21396, 0x243674 },
	{ 0x21397, 0x26474c },
	{ 0x2139a, 0x2f3975 },
	{ 0x213a7, 0x253737 },
	{ 0x213a8, 0x25373a },
	{ 0x213a9, 0x264748 },
	{ 0x213aa, 0x253735 },
	{ 0x213ab, 0x253736 },
	{ 0x213ac, 0x25373b },
	{ 0x213ae, 0x253e46 },
	{ 0x213af, 0x265156 },
	{ 0x213b0, 0x26514b },
	{ 0x213b1, 0x265155 },
	{ 0x213b3, 0x253e4d },
	{ 0x213b4, 0x243c54 },
	{ 0x213b5, 0x265b62 },
	{ 0x213b6, 0x265152 },
	{ 0x213b7, 0x253e4c },
	{ 0x213b8, 0x265151 },
	{ 0x213b9, 0x253e44 },
	{ 0x213ba, 0x253e4b },
	{ 0x213bb, 0x253e43 },
	{ 0x213bc, 0x265154 },
	{ 0x213bd, 0x265150 },
	{ 0x213be, 0x253e49 },
	{ 0x213bf, 0x253e4a },
	{ 0x213c0, 0x243c55 },
	{ 0x213c1, 0x253e47 },
	{ 0x213c2, 0x265149 },
	{ 0x213c3, 0x26514c },
	{ 0x213c5, 0x2f3977 },
	{ 0x213c7, 0x265153 },
	{ 0x213c8, 0x26514d },
	{ 0x213c9, 0x2f4066 },
	{ 0x213ca, 0x2f4067 },
	{ 0x213cb, 0x2f4068 },
	{ 0x213cc, 0x2f406a },
	{ 0x213cd, 0x2f406b },
	{ 0x213ce, 0x2f406c },
	{ 0x213cf, 0x2f406d },
	{ 0x213d0, 0x2f406e },
	{ 0x213d1, 0x2f406f },
	{ 0x213d2, 0x2f4070 },
	{ 0x213d3, 0x2f4071 },
	{ 0x213d4, 0x2f4072 },
	{ 0x213d5, 0x2f4073 },
	{ 0x213d7, 0x26514f },
	{ 0x213e9, 0x253e4e },
	{ 0x213ea, 0x253e48 },
	{ 0x213eb, 0x253e45 },
	{ 0x213ed, 0x254529 },
	{ 0x213ee, 0x254528 },
	{ 0x213ef, 0x254527 },
	{ 0x213f0, 0x265b5c },
	{ 0x213f1, 0x24425c },
	{ 0x213f2, 0x265b64 },
	{ 0x213f3, 0x265b66 },
	{ 0x213f4, 0x265b61 },
	{ 0x213f5, 0x25452a },
	{ 0x213f6, 0x265b60 },
	{ 0x213f7, 0x254526 },
	{ 0x213f8, 0x265b67 },
	{ 0x213ff, 0x2f4732 },
	{ 0x21400, 0x2f4733 },
	{ 0x21401, 0x2f4734 },
	{ 0x21402, 0x2f4735 },
	{ 0x21403, 0x2f4736 },
	{ 0x21404, 0x2f4737 },
	{ 0x21405, 0x2f4739 },
	{ 0x21406, 0x2f473a },
	{ 0x21407, 0x2f473b },
	{ 0x21408, 0x2f473c },
	{ 0x21409, 0x265b5d },
	{ 0x2140a, 0x2f4738 },
	{ 0x2140e, 0x265b6b },
	{ 0x21410, 0x265b63 },
	{ 0x21411, 0x265b53 },
	{ 0x21413, 0x2f4731 },
	{ 0x21414, 0x24425a },
	{ 0x21415, 0x265b65 },
	{ 0x2141b, 0x265b5e },
	{ 0x2141d, 0x254525 },
	{ 0x2141e, 0x25452b },
	{ 0x2141f, 0x272172 },
	{ 0x21420, 0x244934 },
	{ 0x21421, 0x244935 },
	{ 0x21422, 0x27216f },
	{ 0x21423, 0x244936 },
	{ 0x21424, 0x254c4b },
	{ 0x21425, 0x254c4c },
	{ 0x21426, 0x27216b },
	{ 0x21428, 0x272178 },
	{ 0x21429, 0x244937 },
	{ 0x2142a, 0x272177 },
	{ 0x2142b, 0x272174 },
	{ 0x2142d, 0x2f4e21 },
	{ 0x21430, 0x254c4d },
	{ 0x21431, 0x254c4f },
	{ 0x21432, 0x272167 },
	{ 0x21433, 0x272175 },
	{ 0x21434, 0x2f4d7c },
	{ 0x21435, 0x2f4d7d },
	{ 0x21436, 0x2f4e26 },
	{ 0x21437, 0x2f4e27 },
	{ 0x21438, 0x2f4e28 },
	{ 0x21439, 0x2f4e29 },
	{ 0x2143a, 0x2f4e2a },
	{ 0x2143b, 0x2f4e2b },
	{ 0x2143c, 0x2f4e2d },
	{ 0x2143e, 0x27216c },
	{ 0x21442, 0x27216d },
	{ 0x21447, 0x27216e },
	{ 0x21448, 0x254c71 },
	{ 0x21449, 0x272173 },
	{ 0x2144a, 0x272171 },
	{ 0x2144f, 0x272169 },
	{ 0x21451, 0x2f4d7e },
	{ 0x21452, 0x2f4e24 },
	{ 0x21454, 0x2f4e23 },
	{ 0x21458, 0x254c4e },
	{ 0x21459, 0x254c4a },
	{ 0x2145a, 0x254c48 },
	{ 0x2145b, 0x272168 },
	{ 0x2145c, 0x254c49 },
	{ 0x2145e, 0x272c6f },
	{ 0x2145f, 0x272c71 },
	{ 0x21460, 0x272c6c },
	{ 0x21461, 0x244f77 },
	{ 0x21462, 0x244f7a },
	{ 0x21463, 0x244f79 },
	{ 0x21464, 0x272c6d },
	{ 0x21466, 0x272c70 },
	{ 0x21468, 0x2f4e2c },
	{ 0x2146b, 0x2f5374 },
	{ 0x2146c, 0x2f5376 },
	{ 0x2146d, 0x2f5378 },
	{ 0x21476, 0x25537a },
	{ 0x21477, 0x272c72 },
	{ 0x21478, 0x25537b },
	{ 0x21479, 0x255379 },
	{ 0x2147a, 0x27346f },
	{ 0x21482, 0x272c73 },
	{ 0x21486, 0x272c6e },
	{ 0x21487, 0x2f5377 },
	{ 0x21488, 0x244f76 },
	{ 0x21489, 0x273743 },
	{ 0x2148a, 0x24557d },
	{ 0x2148b, 0x27373d },
	{ 0x2148c, 0x255b2e },
	{ 0x2148d, 0x27373f },
	{ 0x2148e, 0x273744 },
	{ 0x21490, 0x273742 },
	{ 0x21492, 0x273745 },
	{ 0x21493, 0x255b2c },
	{ 0x21496, 0x272c74 },
	{ 0x21499, 0x2f5964 },
	{ 0x2149a, 0x2f5965 },
	{ 0x2149b, 0x2f5966 },
	{ 0x2149c, 0x2f5967 },
	{ 0x2149d, 0x2f5968 },
	{ 0x2149e, 0x2f5969 },
	{ 0x2149f, 0x2f596a },
	{ 0x214a0, 0x2f596b },
	{ 0x214a1, 0x273e6c },
	{ 0x214a3, 0x273740 },
	{ 0x214a4, 0x273741 },
	{ 0x214a8, 0x24557e },
	{ 0x214af, 0x255b2f },
	{ 0x214b0, 0x273f34 },
	{ 0x214b1, 0x256147 },
	{ 0x214b2, 0x27373e },
	{ 0x214b3, 0x256149 },
	{ 0x214b4, 0x273f33 },
	{ 0x214b5, 0x2f5e47 },
	{ 0x214b7, 0x2f5e48 },
	{ 0x214b8, 0x2f5e49 },
	{ 0x214b9, 0x2f5e4b },
	{ 0x214ba, 0x2f5e4d },
	{ 0x214bb, 0x2f5e4e },
	{ 0x214bc, 0x273f31 },
	{ 0x214bd, 0x273f32 },
	{ 0x214c9, 0x255b30 },
	{ 0x214ca, 0x256148 },
	{ 0x214cc, 0x2f6228 },
	{ 0x214cd, 0x25614a },
	{ 0x214d0, 0x274642 },
	{ 0x214d1, 0x27463f },
	{ 0x214d2, 0x25675d },
	{ 0x214d3, 0x274647 },
	{ 0x214d4, 0x274641 },
	{ 0x214d5, 0x2f5e4c },
	{ 0x214d7, 0x2f6227 },
	{ 0x214d9, 0x274643 },
	{ 0x214da, 0x274646 },
	{ 0x214db, 0x274a3b },
	{ 0x214e3, 0x274640 },
	{ 0x214e4, 0x273f35 },
	{ 0x214e6, 0x246333 },
	{ 0x214e7, 0x2f6522 },
	{ 0x214e9, 0x2f6523 },
	{ 0x214ea, 0x2f6524 },
	{ 0x214eb, 0x2f6525 },
	{ 0x214ec, 0x274d4e },
	{ 0x214f0, 0x256b77 },
	{ 0x214f1, 0x275328 },
	{ 0x214f2, 0x246636 },
	{ 0x214f3, 0x275324 },
	{ 0x214f4, 0x275323 },
	{ 0x214f5, 0x275327 },
	{ 0x214f6, 0x275325 },
	{ 0x214f8, 0x256f74 },
	{ 0x214f9, 0x2f6749 },
	{ 0x214fa, 0x2f674a },
	{ 0x214fb, 0x2f674c },
	{ 0x214fc, 0x275326 },
	{ 0x214fd, 0x2f674b },
	{ 0x214ff, 0x256f72 },
	{ 0x21501, 0x256f73 },
	{ 0x21502, 0x27575b },
	{ 0x21504, 0x2f693d },
	{ 0x21507, 0x257334 },
	{ 0x21508, 0x27575d },
	{ 0x21509, 0x257335 },
	{ 0x2150a, 0x275b4b },
	{ 0x2150b, 0x27575c },
	{ 0x2150f, 0x275e57 },
	{ 0x21515, 0x257757 },
	{ 0x21517, 0x257b5f },
	{ 0x21518, 0x27655a },
	{ 0x21519, 0x276642 },
	{ 0x2151a, 0x27664f },
	{ 0x2151b, 0x262262 },
	{ 0x2151d, 0x262f6d },
	{ 0x2151e, 0x26266b },
	{ 0x2151f, 0x262a52 },
	{ 0x21520, 0x2f297e },
	{ 0x21521, 0x2f2a21 },
	{ 0x21522, 0x252c64 },
	{ 0x21524, 0x263642 },
	{ 0x21525, 0x262f6e },
	{ 0x21526, 0x263641 },
	{ 0x21527, 0x2f2e62 },
	{ 0x21528, 0x252c63 },
	{ 0x2152c, 0x263e36 },
	{ 0x2152d, 0x2f3362 },
	{ 0x2152f, 0x264752 },
	{ 0x21530, 0x265159 },
	{ 0x21535, 0x265158 },
	{ 0x21536, 0x265b6a },
	{ 0x21537, 0x26647a },
	{ 0x21539, 0x265b68 },
	{ 0x2153a, 0x2f473d },
	{ 0x2153b, 0x265b69 },
	{ 0x2153c, 0x27217a },
	{ 0x2153d, 0x272179 },
	{ 0x2153e, 0x272c75 },
	{ 0x21545, 0x273f36 },
	{ 0x21546, 0x27433f },
	{ 0x2154a, 0x2f5e4f },
	{ 0x2154b, 0x273f37 },
	{ 0x2154c, 0x274648 },
	{ 0x2154d, 0x274649 },
	{ 0x2154e, 0x27483b },
	{ 0x21551, 0x27575e },
	{ 0x21552, 0x25212f },
	{ 0x21553, 0x262263 },
	{ 0x21555, 0x262437 },
	{ 0x21556, 0x262436 },
	{ 0x21558, 0x26266c },
	{ 0x21559, 0x2f235c },
	{ 0x2155a, 0x263643 },
	{ 0x2155b, 0x263e37 },
	{ 0x2155c, 0x263e38 },
	{ 0x2155d, 0x26515a },
	{ 0x2155e, 0x262439 },
	{ 0x2155f, 0x262438 },
	{ 0x21560, 0x252364 },
	{ 0x21561, 0x252363 },
	{ 0x21562, 0x24256f },
	{ 0x21563, 0x262a53 },
	{ 0x21564, 0x2f2634 },
	{ 0x21566, 0x2f2e63 },
	{ 0x21567, 0x25315e },
	{ 0x21568, 0x263e39 },
	{ 0x21569, 0x263e3c },
	{ 0x2156a, 0x252c65 },
	{ 0x2156b, 0x263e3b },
	{ 0x2156c, 0x263e3a },
	{ 0x2156e, 0x253e4f },
	{ 0x2156f, 0x26515c },
	{ 0x21571, 0x2f4074 },
	{ 0x21572, 0x265b6c },
	{ 0x21573, 0x2f473e },
	{ 0x21574, 0x265b6d },
	{ 0x21576, 0x254c50 },
	{ 0x21577, 0x2f4e2f },
	{ 0x21578, 0x2f5379 },
	{ 0x21579, 0x272c76 },
	{ 0x2157a, 0x272c77 },
	{ 0x2157b, 0x273746 },
	{ 0x2157c, 0x27464a },
	{ 0x2157d, 0x273f3a },
	{ 0x2157e, 0x273f38 },
	{ 0x2157f, 0x273f39 },
	{ 0x21580, 0x27464b },
	{ 0x21581, 0x274d4f },
	{ 0x21584, 0x262264 },
	{ 0x21586, 0x262265 },
	{ 0x21588, 0x26243a },
	{ 0x2158a, 0x26266e },
	{ 0x2158b, 0x26266d },
	{ 0x2158d, 0x262a54 },
	{ 0x2158f, 0x2f2542 },
	{ 0x21591, 0x25285f },
	{ 0x21592, 0x252c68 },
	{ 0x21593, 0x242c35 },
	{ 0x21594, 0x252c67 },
	{ 0x21595, 0x263646 },
	{ 0x21597, 0x263645 },
	{ 0x21598, 0x2f2e64 },
	{ 0x21599, 0x2f2e65 },
	{ 0x2159a, 0x263647 },
	{ 0x2159c, 0x252c69 },
	{ 0x2159d, 0x243124 },
	{ 0x2159e, 0x253161 },
	{ 0x2159f, 0x263e3d },
	{ 0x215a2, 0x25315f },
	{ 0x215a3, 0x253160 },
	{ 0x215a4, 0x253162 },
	{ 0x215a5, 0x2f3363 },
	{ 0x215a9, 0x264754 },
	{ 0x215aa, 0x25373e },
	{ 0x215ab, 0x253742 },
	{ 0x215ac, 0x253740 },
	{ 0x215ad, 0x253741 },
	{ 0x215ae, 0x2f3a27 },
	{ 0x215af, 0x253e50 },
	{ 0x215b0, 0x26515d },
	{ 0x215b2, 0x253e52 },
	{ 0x215b3, 0x253e51 },
	{ 0x215b4, 0x26515f },
	{ 0x215b6, 0x244261 },
	{ 0x215b7, 0x265b6f },
	{ 0x215b8, 0x265b70 },
	{ 0x215b9, 0x265b6e },
	{ 0x215bd, 0x25452c },
	{ 0x215be, 0x25452e },
	{ 0x215bf, 0x27217b },
	{ 0x215c1, 0x254c51 },
	{ 0x215c3, 0x273f3b },
	{ 0x215c6, 0x255b31 },
	{ 0x215c8, 0x255b32 },
	{ 0x215cc, 0x27464c },
	{ 0x215d2, 0x262167 },
	{ 0x215d3, 0x262168 },
	{ 0x215d4, 0x2f2138 },
	{ 0x215d5, 0x262266 },
	{ 0x215d8, 0x2f2153 },
	{ 0x215d9, 0x2f2154 },
	{ 0x215dc, 0x252176 },
	{ 0x215dd, 0x26243c },
	{ 0x215de, 0x242254 },
	{ 0x215df, 0x26243f },
	{ 0x215e0, 0x262440 },
	{ 0x215e1, 0x26243e },
	{ 0x215e2, 0x26243d },
	{ 0x215e3, 0x2f216b },
	{ 0x215e5, 0x242363 },
	{ 0x215e6, 0x242364 },
	{ 0x215e8, 0x242366 },
	{ 0x215e9, 0x2f235d },
	{ 0x215ea, 0x2f235e },
	{ 0x215eb, 0x2f235f },
	{ 0x215ec, 0x2f2360 },
	{ 0x215ed, 0x2f2361 },
	{ 0x215ee, 0x2f2362 },
	{ 0x215ef, 0x2f2363 },
	{ 0x215f0, 0x262670 },
	{ 0x215f4, 0x26266f },
	{ 0x215f7, 0x242576 },
	{ 0x215f8, 0x25255a },
	{ 0x215f9, 0x242574 },
	{ 0x215fa, 0x262a55 },
	{ 0x215fb, 0x262a56 },
	{ 0x215fc, 0x242863 },
	{ 0x215fd, 0x262a5c },
	{ 0x215fe, 0x262a58 },
	{ 0x215ff, 0x262a59 },
	{ 0x21600, 0x2f2636 },
	{ 0x21601, 0x2f2637 },
	{ 0x21602, 0x262a5a },
	{ 0x21604, 0x262a5b },
	{ 0x21605, 0x262a5d },
	{ 0x21606, 0x242579 },
	{ 0x21609, 0x262a57 },
	{ 0x2160b, 0x262939 },
	{ 0x2160c, 0x242864 },
	{ 0x2160d, 0x242862 },
	{ 0x2160e, 0x252861 },
	{ 0x2160f, 0x252862 },
	{ 0x21610, 0x252860 },
	{ 0x21612, 0x2f2a23 },
	{ 0x21614, 0x2f2a24 },
	{ 0x21615, 0x2f2a25 },
	{ 0x21616, 0x2f2a26 },
	{ 0x21617, 0x2f2a28 },
	{ 0x21618, 0x2f2a29 },
	{ 0x21619, 0x2f2a27 },
	{ 0x2161a, 0x2f2a22 },
	{ 0x2161d, 0x252c6c },
	{ 0x2161f, 0x263648 },
	{ 0x21620, 0x26364b },
	{ 0x21622, 0x252c6a },
	{ 0x21623, 0x252c6d },
	{ 0x21624, 0x2f2e67 },
	{ 0x21625, 0x2f2e68 },
	{ 0x21626, 0x2f2e69 },
	{ 0x21629, 0x26364a },
	{ 0x2162b, 0x242c37 },
	{ 0x21630, 0x252c6b },
	{ 0x21632, 0x253164 },
	{ 0x21633, 0x2f2e66 },
	{ 0x21634, 0x242c36 },
	{ 0x21635, 0x263e41 },
	{ 0x21636, 0x263e44 },
	{ 0x21637, 0x23347e },
	{ 0x21638, 0x263e3e },
	{ 0x21639, 0x263e43 },
	{ 0x2163a, 0x263e40 },
	{ 0x2163b, 0x263e45 },
	{ 0x2163c, 0x263e3f },
	{ 0x2163d, 0x2f3364 },
	{ 0x2163f, 0x2f3365 },
	{ 0x21641, 0x243127 },
	{ 0x21644, 0x253163 },
	{ 0x21647, 0x243c5e },
	{ 0x21648, 0x264758 },
	{ 0x21649, 0x26475b },
	{ 0x2164a, 0x26475d },
	{ 0x2164c, 0x26475a },
	{ 0x2164d, 0x2f3a28 },
	{ 0x2164e, 0x264755 },
	{ 0x2164f, 0x26475c },
	{ 0x21650, 0x253743 },
	{ 0x21655, 0x264759 },
	{ 0x21656, 0x24367a },
	{ 0x21657, 0x243678 },
	{ 0x21658, 0x253744 },
	{ 0x2165a, 0x264757 },
	{ 0x2165c, 0x265160 },
	{ 0x2165d, 0x265161 },
	{ 0x21660, 0x243c5d },
	{ 0x21662, 0x2f4076 },
	{ 0x21668, 0x253e53 },
	{ 0x21669, 0x253e54 },
	{ 0x2166a, 0x253e55 },
	{ 0x2166b, 0x265b72 },
	{ 0x2166c, 0x244263 },
	{ 0x2166d, 0x25452f },
	{ 0x2166e, 0x244262 },
	{ 0x2166f, 0x2f473f },
	{ 0x21670, 0x2f4740 },
	{ 0x21671, 0x2f4741 },
	{ 0x21672, 0x265b71 },
	{ 0x21676, 0x254530 },
	{ 0x21677, 0x244938 },
	{ 0x21678, 0x272222 },
	{ 0x21679, 0x27217c },
	{ 0x2167a, 0x272221 },
	{ 0x2167b, 0x272c7c },
	{ 0x2167c, 0x27217e },
	{ 0x2167d, 0x254c53 },
	{ 0x2167e, 0x2f4e31 },
	{ 0x2167f, 0x2f4e32 },
	{ 0x21680, 0x27217d },
	{ 0x21681, 0x244264 },
	{ 0x21685, 0x254c52 },
	{ 0x21686, 0x272c7d },
	{ 0x21687, 0x25537c },
	{ 0x21688, 0x272c78 },
	{ 0x21689, 0x272c79 },
	{ 0x2168a, 0x245621 },
	{ 0x2168b, 0x2f537a },
	{ 0x2168c, 0x272c7a },
	{ 0x2168f, 0x273748 },
	{ 0x21690, 0x273747 },
	{ 0x21691, 0x255b33 },
	{ 0x21696, 0x24562e },
	{ 0x21697, 0x245a7b },
	{ 0x21698, 0x2f6229 },
	{ 0x2169b, 0x256b78 },
	{ 0x2169c, 0x275329 },
	{ 0x2169e, 0x2f693e },
	{ 0x216a0, 0x257568 },
	{ 0x216a3, 0x2f6b44 },
	{ 0x216a4, 0x275e58 },
	{ 0x216a5, 0x2f6c5f },
	{ 0x216a8, 0x252162 },
	{ 0x216aa, 0x2f2155 },
	{ 0x216ab, 0x2f2156 },
	{ 0x216af, 0x262441 },
	{ 0x216b0, 0x242258 },
	{ 0x216b1, 0x262442 },
	{ 0x216b2, 0x2f2239 },
	{ 0x216b3, 0x2f223a },
	{ 0x216b4, 0x2f223b },
	{ 0x216b5, 0x2f223c },
	{ 0x216b8, 0x242257 },
	{ 0x216b9, 0x25224b },
	{ 0x216ba, 0x262443 },
	{ 0x216bb, 0x25224a },
	{ 0x216bc, 0x262674 },
	{ 0x216bd, 0x242368 },
	{ 0x216be, 0x24236b },
	{ 0x216bf, 0x2f2364 },
	{ 0x216c3, 0x2f2366 },
	{ 0x216c4, 0x2f2368 },
	{ 0x216c5, 0x2f2369 },
	{ 0x216c6, 0x2f236b },
	{ 0x216c7, 0x2f236c },
	{ 0x216c8, 0x2f236d },
	{ 0x216c9, 0x2f236e },
	{ 0x216ca, 0x2f236f },
	{ 0x216cb, 0x2f2365 },
	{ 0x216cd, 0x262672 },
	{ 0x216ce, 0x262673 },
	{ 0x216d0, 0x262675 },
	{ 0x216d2, 0x262671 },
	{ 0x216d3, 0x2f236a },
	{ 0x216d5, 0x2f2367 },
	{ 0x216d6, 0x252366 },
	{ 0x216d7, 0x252367 },
	{ 0x216d8, 0x252365 },
	{ 0x216d9, 0x24257c },
	{ 0x216da, 0x262a61 },
	{ 0x216db, 0x262a60 },
	{ 0x216dc, 0x252560 },
	{ 0x216dd, 0x24257a },
	{ 0x216de, 0x25255e },
	{ 0x216df, 0x24257d },
	{ 0x216e0, 0x25255b },
	{ 0x216e1, 0x25255c },
	{ 0x216e2, 0x24257e },
	{ 0x216e5, 0x2f263a },
	{ 0x216e9, 0x2f263b },
	{ 0x216ea, 0x2f263e },
	{ 0x216eb, 0x2f263f },
	{ 0x216ec, 0x2f2640 },
	{ 0x216ed, 0x2f2641 },
	{ 0x216ee, 0x2f2642 },
	{ 0x216ef, 0x2f2643 },
	{ 0x216f0, 0x2f2645 },
	{ 0x216f1, 0x2f2646 },
	{ 0x216f2, 0x2f2647 },
	{ 0x216f3, 0x2f2648 },
	{ 0x216f4, 0x2f2649 },
	{ 0x216f7, 0x262a5f },
	{ 0x216f9, 0x262a5e },
	{ 0x216fa, 0x2f2644 },
	{ 0x216fb, 0x2f263c },
	{ 0x216fc, 0x2f263d },
	{ 0x216fd, 0x252562 },
	{ 0x216fe, 0x25255f },
	{ 0x21700, 0x252563 },
	{ 0x21701, 0x252561 },
	{ 0x21702, 0x242868 },
	{ 0x21703, 0x252864 },
	{ 0x21704, 0x262f76 },
	{ 0x21705, 0x262f78 },
	{ 0x21706, 0x262f79 },
	{ 0x21707, 0x242865 },
	{ 0x21708, 0x24286b },
	{ 0x21709, 0x252866 },
	{ 0x2170a, 0x242866 },
	{ 0x2170b, 0x252863 },
	{ 0x2170c, 0x262f70 },
	{ 0x2170d, 0x262f7b },
	{ 0x2170e, 0x262f74 },
	{ 0x2170f, 0x25286b },
	{ 0x21711, 0x262f7e },
	{ 0x21712, 0x2f2a2d },
	{ 0x21713, 0x2f2a2e },
	{ 0x21714, 0x2f2a2f },
	{ 0x21715, 0x2f2a30 },
	{ 0x21716, 0x2f2a31 },
	{ 0x21717, 0x2f2a32 },
	{ 0x21718, 0x2f2a33 },
	{ 0x21719, 0x2f2a34 },
	{ 0x2171b, 0x262f73 },
	{ 0x2171c, 0x262f77 },
	{ 0x2171d, 0x24286c },
	{ 0x2171f, 0x262f75 },
	{ 0x21720, 0x262f7a },
	{ 0x21721, 0x262f6f },
	{ 0x21723, 0x262f7d },
	{ 0x21725, 0x252869 },
	{ 0x21726, 0x24286a },
	{ 0x21727, 0x25286a },
	{ 0x21728, 0x252867 },
	{ 0x21729, 0x262f71 },
	{ 0x2172a, 0x262f7c },
	{ 0x2172b, 0x252865 },
	{ 0x2172c, 0x252868 },
	{ 0x2172d, 0x262f72 },
	{ 0x2172e, 0x233053 },
	{ 0x2172f, 0x252c70 },
	{ 0x21730, 0x26364f },
	{ 0x21731, 0x252c72 },
	{ 0x21732, 0x252c75 },
	{ 0x21733, 0x252c6f },
	{ 0x21734, 0x263655 },
	{ 0x21735, 0x252c6e },
	{ 0x21736, 0x263656 },
	{ 0x21738, 0x263650 },
	{ 0x2173d, 0x263651 },
	{ 0x2173e, 0x2f2e6c },
	{ 0x2173f, 0x2f2e6e },
	{ 0x21740, 0x2f2e70 },
	{ 0x21741, 0x2f2e71 },
	{ 0x21742, 0x2f2e73 },
	{ 0x21743, 0x2f2e74 },
	{ 0x21744, 0x2f2e75 },
	{ 0x21745, 0x2f2e76 },
	{ 0x21746, 0x2f2e77 },
	{ 0x21747, 0x2f2e79 },
	{ 0x2174a, 0x263654 },
	{ 0x2174c, 0x26364e },
	{ 0x2174d, 0x252c71 },
	{ 0x2174f, 0x263653 },
	{ 0x21751, 0x263652 },
	{ 0x21757, 0x2f2e6f },
	{ 0x21758, 0x2f2e72 },
	{ 0x21759, 0x252c77 },
	{ 0x2175a, 0x252c74 },
	{ 0x2175b, 0x252c73 },
	{ 0x2175c, 0x252c76 },
	{ 0x2175d, 0x252c78 },
	{ 0x2175e, 0x263e4c },
	{ 0x2175f, 0x263e52 },
	{ 0x21760, 0x263e46 },
	{ 0x21761, 0x263e47 },
	{ 0x21762, 0x25316a },
	{ 0x21763, 0x263e48 },
	{ 0x21764, 0x263e49 },
	{ 0x21765, 0x263e4f },
	{ 0x21766, 0x253169 },
	{ 0x21767, 0x25316d },
	{ 0x21768, 0x263e4d },
	{ 0x21769, 0x24312b },
	{ 0x2176a, 0x263e4e },
	{ 0x2176b, 0x25316b },
	{ 0x21772, 0x263e53 },
	{ 0x21775, 0x2f3368 },
	{ 0x21776, 0x2f3369 },
	{ 0x21777, 0x2f336a },
	{ 0x21778, 0x2f336b },
	{ 0x21779, 0x2f336c },
	{ 0x2177a, 0x2f336d },
	{ 0x2177b, 0x2f336e },
	{ 0x2177c, 0x2f336f },
	{ 0x2177d, 0x2f3371 },
	{ 0x2177e, 0x2f3372 },
	{ 0x2177f, 0x2f3374 },
	{ 0x21780, 0x2f3375 },
	{ 0x21781, 0x2f3376 },
	{ 0x21782, 0x2f3377 },
	{ 0x21783, 0x2f3378 },
	{ 0x21784, 0x2f3379 },
	{ 0x21785, 0x2f337a },
	{ 0x21786, 0x2f337b },
	{ 0x21787, 0x2f337c },
	{ 0x21788, 0x2f337d },
	{ 0x21789, 0x2f337e },
	{ 0x2178a, 0x2f3421 },
	{ 0x2178b, 0x2f3422 },
	{ 0x2178c, 0x2f3423 },
	{ 0x2178e, 0x2f3370 },
	{ 0x21790, 0x263e51 },
	{ 0x21791, 0x24312a },
	{ 0x21793, 0x263e4b },
	{ 0x21794, 0x263e4a },
	{ 0x21798, 0x253166 },
	{ 0x21799, 0x253167 },
	{ 0x2179a, 0x253168 },
	{ 0x2179b, 0x253165 },
	{ 0x2179c, 0x24367b },
	{ 0x2179d, 0x264762 },
	{ 0x2179e, 0x24367c },
	{ 0x2179f, 0x25375a },
	{ 0x217a0, 0x26475f },
	{ 0x217a1, 0x243721 },
	{ 0x217a2, 0x253748 },
	{ 0x217a3, 0x253759 },
	{ 0x217a4, 0x264764 },
	{ 0x217a6, 0x264766 },
	{ 0x217a7, 0x25374f },
	{ 0x217a8, 0x264765 },
	{ 0x217a9, 0x264760 },
	{ 0x217aa, 0x253750 },
	{ 0x217ab, 0x253749 },
	{ 0x217ac, 0x253757 },
	{ 0x217ad, 0x253754 },
	{ 0x217ae, 0x253747 },
	{ 0x217af, 0x25374b },
	{ 0x217b0, 0x2f3a29 },
	{ 0x217b6, 0x2f3a2b },
	{ 0x217b7, 0x2f3a2c },
	{ 0x217b8, 0x2f3a2d },
	{ 0x217b9, 0x2f3a2e },
	{ 0x217ba, 0x2f3a2f },
	{ 0x217bb, 0x2f3a30 },
	{ 0x217bc, 0x2f3a32 },
	{ 0x217bd, 0x2f3a33 },
	{ 0x217be, 0x2f3a34 },
	{ 0x217bf, 0x2f3a36 },
	{ 0x217c0, 0x2f3a37 },
	{ 0x217c1, 0x2f3a38 },
	{ 0x217c2, 0x2f3a39 },
	{ 0x217c3, 0x2f3a3a },
	{ 0x217c4, 0x2f3a3e },
	{ 0x217c5, 0x2f3a3f },
	{ 0x217c6, 0x2f3a41 },
	{ 0x217c7, 0x2f3a42 },
	{ 0x217c8, 0x2f3a43 },
	{ 0x217c9, 0x2f3a44 },
	{ 0x217ca, 0x2f3a45 },
	{ 0x217ce, 0x2f3a3b },
	{ 0x217d1, 0x253756 },
	{ 0x217d4, 0x264763 },
	{ 0x217d5, 0x253758 },
	{ 0x217d6, 0x26475e },
	{ 0x217d9, 0x2f3a3d },
	{ 0x217da, 0x2f3a40 },
	{ 0x217db, 0x2f3a31 },
	{ 0x217dc, 0x2f3a2a },
	{ 0x217dd, 0x253745 },
	{ 0x217de, 0x253e56 },
	{ 0x217df, 0x253753 },
	{ 0x217e0, 0x25374c },
	{ 0x217e1, 0x253752 },
	{ 0x217e2, 0x253751 },
	{ 0x217e3, 0x25374a },
	{ 0x217e4, 0x25374d },
	{ 0x217e5, 0x253755 },
	{ 0x217e6, 0x264767 },
	{ 0x217e7, 0x2f3367 },
	{ 0x217e8, 0x253e5f },
	{ 0x217e9, 0x253e5a },
	{ 0x217ea, 0x253e5d },
	{ 0x217eb, 0x253e57 },
	{ 0x217ec, 0x243c65 },
	{ 0x217ed, 0x253e59 },
	{ 0x217ee, 0x265163 },
	{ 0x217ef, 0x243c62 },
	{ 0x217f0, 0x243c60 },
	{ 0x217f1, 0x265167 },
	{ 0x217f2, 0x265165 },
	{ 0x217f3, 0x265b7c },
	{ 0x217f4, 0x253e5c },
	{ 0x217f7, 0x253e5b },
	{ 0x217fd, 0x265166 },
	{ 0x217fe, 0x2f4078 },
	{ 0x217ff, 0x2f4079 },
	{ 0x21800, 0x2f407a },
	{ 0x21801, 0x2f407c },
	{ 0x21802, 0x2f407d },
	{ 0x21803, 0x2f407e },
	{ 0x21804, 0x2f4122 },
	{ 0x21805, 0x2f4123 },
	{ 0x21808, 0x265162 },
	{ 0x2180b, 0x265164 },
	{ 0x2180e, 0x2f4077 },
	{ 0x21810, 0x265168 },
	{ 0x21811, 0x253e58 },
	{ 0x21812, 0x253e5e },
	{ 0x21813, 0x253e60 },
	{ 0x21814, 0x26516a },
	{ 0x21815, 0x2f4121 },
	{ 0x21817, 0x244270 },
	{ 0x21819, 0x254532 },
	{ 0x2181a, 0x24426a },
	{ 0x2181b, 0x265b7b },
	{ 0x2181c, 0x244271 },
	{ 0x2181d, 0x265b73 },
	{ 0x2181e, 0x254534 },
	{ 0x2181f, 0x272229 },
	{ 0x21820, 0x244273 },
	{ 0x21822, 0x265b75 },
	{ 0x21824, 0x2f4748 },
	{ 0x21825, 0x24426f },
	{ 0x21826, 0x254537 },
	{ 0x21827, 0x24426e },
	{ 0x2182b, 0x2f4747 },
	{ 0x2182c, 0x2f4749 },
	{ 0x2182d, 0x2f474a },
	{ 0x2182e, 0x2f474b },
	{ 0x2182f, 0x2f474c },
	{ 0x21830, 0x2f474d },
	{ 0x21831, 0x2f474e },
	{ 0x21832, 0x2f474f },
	{ 0x21833, 0x2f4750 },
	{ 0x21834, 0x2f4751 },
	{ 0x21835, 0x2f4752 },
	{ 0x21836, 0x2f4754 },
	{ 0x21837, 0x265b74 },
	{ 0x21838, 0x265b78 },
	{ 0x2183d, 0x244272 },
	{ 0x21842, 0x244265 },
	{ 0x21843, 0x265b76 },
	{ 0x21845, 0x2f4753 },
	{ 0x21848, 0x254533 },
	{ 0x21849, 0x254536 },
	{ 0x2184a, 0x254535 },
	{ 0x2184b, 0x272226 },
	{ 0x2184c, 0x254531 },
	{ 0x2184d, 0x265b77 },
	{ 0x2184f, 0x254c5b },
	{ 0x21850, 0x254c59 },
	{ 0x21851, 0x244939 },
	{ 0x21852, 0x254c56 },
	{ 0x21853, 0x27222f },
	{ 0x21854, 0x254c57 },
	{ 0x21855, 0x24493f },
	{ 0x21856, 0x24493b },
	{ 0x21857, 0x27222c },
	{ 0x21859, 0x24493e },
	{ 0x2185a, 0x272225 },
	{ 0x2185b, 0x265b79 },
	{ 0x2185c, 0x272224 },
	{ 0x2185d, 0x2f4e3a },
	{ 0x2185f, 0x273751 },
	{ 0x21860, 0x2f4745 },
	{ 0x21865, 0x254c54 },
	{ 0x21868, 0x254c5c },
	{ 0x21869, 0x2f4e33 },
	{ 0x2186a, 0x2f4e34 },
	{ 0x2186b, 0x2f4e35 },
	{ 0x2186c, 0x2f4e36 },
	{ 0x2186d, 0x2f4e37 },
	{ 0x2186e, 0x2f4e38 },
	{ 0x2186f, 0x2f4e39 },
	{ 0x21870, 0x2f4e3b },
	{ 0x21871, 0x2f4e3d },
	{ 0x21872, 0x2f4e3e },
	{ 0x21873, 0x2f4e3f },
	{ 0x21874, 0x2f4e40 },
	{ 0x21875, 0x2f4e41 },
	{ 0x21876, 0x2f4e42 },
	{ 0x21877, 0x2f4e44 },
	{ 0x21879, 0x265b7a },
	{ 0x2187c, 0x272227 },
	{ 0x2187d, 0x27222e },
	{ 0x2187e, 0x27222d },
	{ 0x2187f, 0x272228 },
	{ 0x21882, 0x272223 },
	{ 0x21883, 0x2f4e45 },
	{ 0x21884, 0x2f4e43 },
	{ 0x21885, 0x2f4e3c },
	{ 0x21886, 0x254c5a },
	{ 0x21887, 0x254c55 },
	{ 0x21888, 0x24493d },
	{ 0x21889, 0x27222a },
	{ 0x2188a, 0x254c58 },
	{ 0x2188b, 0x27222b },
	{ 0x2188d, 0x2f5425 },
	{ 0x21891, 0x255428 },
	{ 0x21892, 0x255423 },
	{ 0x21893, 0x272d25 },
	{ 0x21894, 0x272c7e },
	{ 0x21895, 0x255429 },
	{ 0x21896, 0x255426 },
	{ 0x21897, 0x272d21 },
	{ 0x21898, 0x244f7e },
	{ 0x21899, 0x272d28 },
	{ 0x2189a, 0x255422 },
	{ 0x2189b, 0x272d2b },
	{ 0x2189c, 0x25537d },
	{ 0x2189d, 0x272d2a },
	{ 0x218a3, 0x272d2c },
	{ 0x218a4, 0x2f537b },
	{ 0x218a5, 0x2f537c },
	{ 0x218a6, 0x2f537d },
	{ 0x218a7, 0x2f537e },
	{ 0x218a8, 0x2f5422 },
	{ 0x218a9, 0x2f5423 },
	{ 0x218aa, 0x2f5424 },
	{ 0x218ab, 0x2f5426 },
	{ 0x218ac, 0x2f5427 },
	{ 0x218ad, 0x2f542b },
	{ 0x218ae, 0x2f542c },
	{ 0x218b1, 0x25537e },
	{ 0x218b2, 0x272d26 },
	{ 0x218b4, 0x272d27 },
	{ 0x218b5, 0x272d23 },
	{ 0x218b7, 0x272d22 },
	{ 0x218b8, 0x272d24 },
	{ 0x218be, 0x2f5421 },
	{ 0x218bf, 0x2f5428 },
	{ 0x218c0, 0x255427 },
	{ 0x218c1, 0x255421 },
	{ 0x218c2, 0x255425 },
	{ 0x218c3, 0x272d29 },
	{ 0x218c5, 0x27374b },
	{ 0x218c6, 0x273754 },
	{ 0x218c7, 0x27374f },
	{ 0x218c8, 0x244f7d },
	{ 0x218c9, 0x27374d },
	{ 0x218cb, 0x245623 },
	{ 0x218cc, 0x273753 },
	{ 0x218cd, 0x27374a },
	{ 0x218ce, 0x255b36 },
	{ 0x218cf, 0x255b34 },
	{ 0x218d0, 0x27374c },
	{ 0x218d1, 0x27374e },
	{ 0x218d2, 0x273750 },
	{ 0x218d4, 0x255b35 },
	{ 0x218d5, 0x245625 },
	{ 0x218da, 0x2f596c },
	{ 0x218db, 0x2f596d },
	{ 0x218dc, 0x2f596e },
	{ 0x218dd, 0x2f596f },
	{ 0x218de, 0x2f5970 },
	{ 0x218df, 0x2f5971 },
	{ 0x218e1, 0x273752 },
	{ 0x218e4, 0x273755 },
	{ 0x218e9, 0x273749 },
	{ 0x218ea, 0x25614b },
	{ 0x218eb, 0x245a7c },
	{ 0x218ed, 0x273f3f },
	{ 0x218ee, 0x25614c },
	{ 0x218ef, 0x25614d },
	{ 0x218f0, 0x273f3e },
	{ 0x218f1, 0x273f40 },
	{ 0x218f2, 0x2f5e50 },
	{ 0x218f3, 0x2f5e51 },
	{ 0x218f4, 0x2f5e52 },
	{ 0x218f5, 0x2f5e54 },
	{ 0x218f7, 0x273f3d },
	{ 0x218f8, 0x273f41 },
	{ 0x218fa, 0x2f5e53 },
	{ 0x218fc, 0x273f3c },
	{ 0x218fd, 0x25675f },
	{ 0x218fe, 0x245f53 },
	{ 0x218ff, 0x27464d },
	{ 0x21900, 0x274652 },
	{ 0x21901, 0x274650 },
	{ 0x21902, 0x2f5e55 },
	{ 0x21906, 0x2f622a },
	{ 0x21907, 0x2f622b },
	{ 0x21908, 0x27464e },
	{ 0x2190b, 0x256761 },
	{ 0x2190c, 0x256760 },
	{ 0x2190d, 0x2f5f73 },
	{ 0x2190f, 0x274d51 },
	{ 0x21912, 0x256b79 },
	{ 0x21915, 0x2f6526 },
	{ 0x21916, 0x256b7a },
	{ 0x21917, 0x256b7b },
	{ 0x21918, 0x27532a },
	{ 0x21919, 0x256f76 },
	{ 0x2191a, 0x27532b },
	{ 0x2191b, 0x256f75 },
	{ 0x2191c, 0x2f674d },
	{ 0x2191d, 0x2f674e },
	{ 0x21921, 0x275762 },
	{ 0x21922, 0x257336 },
	{ 0x21923, 0x275761 },
	{ 0x21924, 0x275763 },
	{ 0x21925, 0x27575f },
	{ 0x21926, 0x2f693f },
	{ 0x21928, 0x275760 },
	{ 0x21929, 0x275764 },
	{ 0x2192a, 0x2f6940 },
	{ 0x2192b, 0x257569 },
	{ 0x2192c, 0x275b4c },
	{ 0x2192e, 0x275e5a },
	{ 0x2192f, 0x275e5b },
	{ 0x21930, 0x2f6b45 },
	{ 0x21931, 0x275e59 },
	{ 0x21932, 0x275e5c },
	{ 0x21934, 0x2f6c24 },
	{ 0x21936, 0x257924 },
	{ 0x21937, 0x2f6c4a },
	{ 0x21939, 0x27634d },
	{ 0x2193a, 0x257a65 },
	{ 0x2193c, 0x242133 },
	{ 0x2193e, 0x262268 },
	{ 0x2193f, 0x252163 },
	{ 0x21940, 0x262269 },
	{ 0x21941, 0x2f2158 },
	{ 0x21942, 0x2f2157 },
	{ 0x21943, 0x262445 },
	{ 0x21945, 0x262444 },
	{ 0x21946, 0x262676 },
	{ 0x21947, 0x262677 },
	{ 0x21948, 0x25236a },
	{ 0x21949, 0x24236c },
	{ 0x2194a, 0x2f2370 },
	{ 0x2194d, 0x252369 },
	{ 0x2194e, 0x24286f },
	{ 0x2194f, 0x263024 },
	{ 0x21950, 0x262a63 },
	{ 0x21951, 0x262a62 },
	{ 0x21952, 0x2f264a },
	{ 0x21953, 0x2f264b },
	{ 0x21954, 0x2f264c },
	{ 0x21955, 0x2f264d },
	{ 0x21956, 0x2f264f },
	{ 0x21957, 0x262a64 },
	{ 0x21958, 0x2f264e },
	{ 0x2195b, 0x263023 },
	{ 0x2195c, 0x263021 },
	{ 0x2195d, 0x263026 },
	{ 0x2195e, 0x263025 },
	{ 0x21961, 0x2f2a35 },
	{ 0x21962, 0x2f2a36 },
	{ 0x21963, 0x2f2a37 },
	{ 0x21966, 0x263022 },
	{ 0x21968, 0x263659 },
	{ 0x21969, 0x252c79 },
	{ 0x2196a, 0x263658 },
	{ 0x2196b, 0x2f2e7a },
	{ 0x2196c, 0x2f2e7b },
	{ 0x2196d, 0x252c7a },
	{ 0x2196e, 0x2f3366 },
	{ 0x2196f, 0x2f3424 },
	{ 0x21970, 0x2f3425 },
	{ 0x21971, 0x2f3426 },
	{ 0x21972, 0x2f3427 },
	{ 0x21976, 0x25375c },
	{ 0x21977, 0x264769 },
	{ 0x21979, 0x25375b },
	{ 0x2197a, 0x26476a },
	{ 0x2197b, 0x2f3a47 },
	{ 0x2197d, 0x264768 },
	{ 0x2197e, 0x2f3a46 },
	{ 0x21983, 0x243c66 },
	{ 0x21984, 0x243c68 },
	{ 0x21985, 0x26516d },
	{ 0x21986, 0x253e62 },
	{ 0x21987, 0x2f4125 },
	{ 0x21989, 0x2f4126 },
	{ 0x2198b, 0x26516b },
	{ 0x2198c, 0x26516c },
	{ 0x2198e, 0x253e61 },
	{ 0x2198f, 0x243c69 },
	{ 0x21991, 0x265b7d },
	{ 0x21992, 0x2f4755 },
	{ 0x21993, 0x2f4756 },
	{ 0x21995, 0x254538 },
	{ 0x21997, 0x244941 },
	{ 0x21998, 0x244942 },
	{ 0x2199a, 0x2f4e46 },
	{ 0x2199d, 0x254c5d },
	{ 0x2199e, 0x272d2f },
	{ 0x2199f, 0x272d2e },
	{ 0x219a0, 0x272d31 },
	{ 0x219a1, 0x272d32 },
	{ 0x219a2, 0x25542a },
	{ 0x219a3, 0x272d30 },
	{ 0x219a4, 0x2f542d },
	{ 0x219a5, 0x2f542e },
	{ 0x219a9, 0x273756 },
	{ 0x219ad, 0x274d52 },
	{ 0x219af, 0x2f622c },
	{ 0x219b0, 0x2f622d },
	{ 0x219b5, 0x256b7c },
	{ 0x219b8, 0x2f6c60 },
	{ 0x219b9, 0x262169 },
	{ 0x219bc, 0x252164 },
	{ 0x219bd, 0x262446 },
	{ 0x219be, 0x262449 },
	{ 0x219bf, 0x26244a },
	{ 0x219c2, 0x24225a },
	{ 0x219c3, 0x2f223d },
	{ 0x219c4, 0x2f223e },
	{ 0x219c5, 0x2f223f },
	{ 0x219c6, 0x2f2240 },
	{ 0x219c7, 0x2f2241 },
	{ 0x219c8, 0x262447 },
	{ 0x219cb, 0x26267e },
	{ 0x219cc, 0x26267d },
	{ 0x219cd, 0x24236e },
	{ 0x219ce, 0x26267b },
	{ 0x219cf, 0x26267c },
	{ 0x219d1, 0x2f2372 },
	{ 0x219d6, 0x252565 },
	{ 0x219d7, 0x252564 },
	{ 0x219d8, 0x262a66 },
	{ 0x219d9, 0x252566 },
	{ 0x219da, 0x262a67 },
	{ 0x219dc, 0x262a68 },
	{ 0x219dd, 0x2f2651 },
	{ 0x219de, 0x2f2652 },
	{ 0x219df, 0x2f2654 },
	{ 0x219e0, 0x2f2655 },
	{ 0x219e2, 0x262a65 },
	{ 0x219e3, 0x2f2653 },
	{ 0x219e9, 0x25286c },
	{ 0x219ea, 0x263028 },
	{ 0x219eb, 0x26302a },
	{ 0x219ec, 0x25286d },
	{ 0x219ed, 0x242871 },
	{ 0x219ee, 0x242872 },
	{ 0x219ef, 0x242873 },
	{ 0x219f0, 0x26302b },
	{ 0x219f1, 0x263027 },
	{ 0x219f4, 0x263029 },
	{ 0x219f5, 0x2f2a38 },
	{ 0x219f6, 0x2f2a3a },
	{ 0x219f7, 0x2f2a3b },
	{ 0x219f8, 0x2f2a3c },
	{ 0x219fa, 0x26302c },
	{ 0x219fb, 0x26302d },
	{ 0x21a00, 0x242c4a },
	{ 0x21a01, 0x263661 },
	{ 0x21a02, 0x242c45 },
	{ 0x21a03, 0x242c44 },
	{ 0x21a04, 0x242c43 },
	{ 0x21a05, 0x242c47 },
	{ 0x21a06, 0x263664 },
	{ 0x21a07, 0x263665 },
	{ 0x21a08, 0x26365f },
	{ 0x21a09, 0x26365e },
	{ 0x21a0a, 0x252c7d },
	{ 0x21a0d, 0x252d22 },
	{ 0x21a0e, 0x26365b },
	{ 0x21a0f, 0x263662 },
	{ 0x21a10, 0x2f2e7c },
	{ 0x21a11, 0x2f2e7d },
	{ 0x21a13, 0x263660 },
	{ 0x21a14, 0x263663 },
	{ 0x21a1c, 0x26365a },
	{ 0x21a1e, 0x26365c },
	{ 0x21a1f, 0x252d21 },
	{ 0x21a20, 0x252c7e },
	{ 0x21a22, 0x24312d },
	{ 0x21a23, 0x25316f },
	{ 0x21a24, 0x263e57 },
	{ 0x21a25, 0x263e59 },
	{ 0x21a26, 0x263e58 },
	{ 0x21a27, 0x263e56 },
	{ 0x21a28, 0x263e5b },
	{ 0x21a29, 0x253170 },
	{ 0x21a2a, 0x2f3428 },
	{ 0x21a2b, 0x2f3429 },
	{ 0x21a2c, 0x2f342a },
	{ 0x21a2d, 0x2f342b },
	{ 0x21a2e, 0x2f342c },
	{ 0x21a2f, 0x2f342d },
	{ 0x21a30, 0x2f342e },
	{ 0x21a31, 0x2f342f },
	{ 0x21a34, 0x24312f },
	{ 0x21a36, 0x263e5c },
	{ 0x21a3b, 0x25316e },
	{ 0x21a3c, 0x263e55 },
	{ 0x21a3d, 0x25375e },
	{ 0x21a3e, 0x243726 },
	{ 0x21a3f, 0x253761 },
	{ 0x21a40, 0x264770 },
	{ 0x21a41, 0x26476b },
	{ 0x21a42, 0x243723 },
	{ 0x21a43, 0x25375d },
	{ 0x21a44, 0x253760 },
	{ 0x21a45, 0x26476e },
	{ 0x21a46, 0x243725 },
	{ 0x21a47, 0x25375f },
	{ 0x21a48, 0x26476f },
	{ 0x21a49, 0x26476c },
	{ 0x21a4e, 0x2f3a48 },
	{ 0x21a4f, 0x2f3a49 },
	{ 0x21a50, 0x2f3a4a },
	{ 0x21a51, 0x2f3a4b },
	{ 0x21a52, 0x2f3a4c },
	{ 0x21a53, 0x2f3a4d },
	{ 0x21a54, 0x2f3a4e },
	{ 0x21a55, 0x2f3a4f },
	{ 0x21a59, 0x26476d },
	{ 0x21a5b, 0x253762 },
	{ 0x21a5e, 0x2f3d6c },
	{ 0x21a5f, 0x265174 },
	{ 0x21a60, 0x265170 },
	{ 0x21a61, 0x243c6b },
	{ 0x21a62, 0x243c70 },
	{ 0x21a63, 0x253e63 },
	{ 0x21a64, 0x265177 },
	{ 0x21a65, 0x253e64 },
	{ 0x21a66, 0x265172 },
	{ 0x21a67, 0x265171 },
	{ 0x21a68, 0x265176 },
	{ 0x21a69, 0x243c6d },
	{ 0x21a6a, 0x265173 },
	{ 0x21a6c, 0x26516f },
	{ 0x21a6d, 0x265175 },
	{ 0x21a6e, 0x2f4127 },
	{ 0x21a6f, 0x2f4128 },
	{ 0x21a70, 0x2f4129 },
	{ 0x21a71, 0x2f412a },
	{ 0x21a72, 0x2f412c },
	{ 0x21a73, 0x2f412d },
	{ 0x21a74, 0x2f412e },
	{ 0x21a7a, 0x26516e },
	{ 0x21a7b, 0x265b7e },
	{ 0x21a7c, 0x265c27 },
	{ 0x21a7d, 0x25453c },
	{ 0x21a7e, 0x25453a },
	{ 0x21a7f, 0x265c24 },
	{ 0x21a80, 0x265c2c },
	{ 0x21a81, 0x244276 },
	{ 0x21a82, 0x265c2e },
	{ 0x21a83, 0x265c2b },
	{ 0x21a84, 0x265c26 },
	{ 0x21a85, 0x254539 },
	{ 0x21a86, 0x272233 },
	{ 0x21a88, 0x2f4757 },
	{ 0x21a89, 0x2f4758 },
	{ 0x21a8a, 0x2f4759 },
	{ 0x21a8b, 0x2f475a },
	{ 0x21a8e, 0x265c28 },
	{ 0x21a8f, 0x265c25 },
	{ 0x21a90, 0x265c29 },
	{ 0x21a93, 0x265c2d },
	{ 0x21a94, 0x265c21 },
	{ 0x21a96, 0x265c23 },
	{ 0x21a97, 0x25453b },
	{ 0x21a98, 0x265c2a },
	{ 0x21a9a, 0x2f4744 },
	{ 0x21a9b, 0x266267 },
	{ 0x21a9f, 0x272230 },
	{ 0x21aa0, 0x254c5e },
	{ 0x21aa1, 0x244947 },
	{ 0x21aa2, 0x272237 },
	{ 0x21aa3, 0x244948 },
	{ 0x21aa4, 0x272235 },
	{ 0x21aa5, 0x272232 },
	{ 0x21aa7, 0x2f4e47 },
	{ 0x21aa8, 0x2f4e48 },
	{ 0x21aa9, 0x2f4e49 },
	{ 0x21aaa, 0x2f4e4a },
	{ 0x21aab, 0x2f4e4b },
	{ 0x21aac, 0x2f4e4c },
	{ 0x21aad, 0x2f4e4e },
	{ 0x21aae, 0x2f4e4f },
	{ 0x21ab4, 0x272238 },
	{ 0x21ab6, 0x272236 },
	{ 0x21ab7, 0x2f4e4d },
	{ 0x21ab8, 0x254c61 },
	{ 0x21aba, 0x254c5f },
	{ 0x21abc, 0x272231 },
	{ 0x21abd, 0x254c60 },
	{ 0x21abe, 0x272d35 },
	{ 0x21abf, 0x272d37 },
	{ 0x21ac0, 0x25542c },
	{ 0x21ac1, 0x245022 },
	{ 0x21ac2, 0x25542d },
	{ 0x21ac3, 0x25542b },
	{ 0x21ac4, 0x272d36 },
	{ 0x21ac5, 0x272d33 },
	{ 0x21ac6, 0x272d34 },
	{ 0x21ac7, 0x2f542f },
	{ 0x21ac8, 0x2f5430 },
	{ 0x21ac9, 0x2f5431 },
	{ 0x21aca, 0x2f5433 },
	{ 0x21acb, 0x2f5434 },
	{ 0x21acc, 0x2f5435 },
	{ 0x21acd, 0x2f5436 },
	{ 0x21ace, 0x2f5437 },
	{ 0x21ad2, 0x273759 },
	{ 0x21ad3, 0x273757 },
	{ 0x21ad4, 0x255b38 },
	{ 0x21ad5, 0x2f5972 },
	{ 0x21ad6, 0x2f5973 },
	{ 0x21ad7, 0x2f5974 },
	{ 0x21ad8, 0x2f5975 },
	{ 0x21ada, 0x273758 },
	{ 0x21adb, 0x27375a },
	{ 0x21adc, 0x272234 },
	{ 0x21add, 0x255b37 },
	{ 0x21ade, 0x274658 },
	{ 0x21adf, 0x25614e },
	{ 0x21ae0, 0x2f5976 },
	{ 0x21ae2, 0x2f5e56 },
	{ 0x21ae3, 0x2f5e57 },
	{ 0x21ae9, 0x273f42 },
	{ 0x21aea, 0x2f622e },
	{ 0x21aec, 0x245f57 },
	{ 0x21aed, 0x274653 },
	{ 0x21aee, 0x274655 },
	{ 0x21aef, 0x245f56 },
	{ 0x21af0, 0x274657 },
	{ 0x21af1, 0x274656 },
	{ 0x21af2, 0x2f622f },
	{ 0x21af3, 0x274654 },
	{ 0x21af7, 0x246336 },
	{ 0x21afb, 0x274d53 },
	{ 0x21afc, 0x27532c },
	{ 0x21afd, 0x246638 },
	{ 0x21afe, 0x27532d },
	{ 0x21aff, 0x2f674f },
	{ 0x21b00, 0x2f6750 },
	{ 0x21b03, 0x27532e },
	{ 0x21b04, 0x257338 },
	{ 0x21b05, 0x246866 },
	{ 0x21b06, 0x275765 },
	{ 0x21b07, 0x257337 },
	{ 0x21b0a, 0x275766 },
	{ 0x21b0c, 0x246a45 },
	{ 0x21b0d, 0x246b67 },
	{ 0x21b0f, 0x2f6b46 },
	{ 0x21b11, 0x27606c },
	{ 0x21b12, 0x276445 },
	{ 0x21b13, 0x257925 },
	{ 0x21b14, 0x2f6c25 },
	{ 0x21b16, 0x246d54 },
	{ 0x21b18, 0x257a27 },
	{ 0x21b19, 0x246d71 },
	{ 0x21b1a, 0x27634e },
	{ 0x21b1b, 0x276534 },
	{ 0x21b1d, 0x26216a },
	{ 0x21b1f, 0x262a6a },
	{ 0x21b20, 0x262a69 },
	{ 0x21b22, 0x2f2656 },
	{ 0x21b23, 0x2f2657 },
	{ 0x21b27, 0x25286f },
	{ 0x21b28, 0x26302e },
	{ 0x21b29, 0x2f2a3d },
	{ 0x21b2a, 0x263031 },
	{ 0x21b2c, 0x26302f },
	{ 0x21b2e, 0x243131 },
	{ 0x21b2f, 0x264367 },
	{ 0x21b30, 0x263e5e },
	{ 0x21b31, 0x263e5d },
	{ 0x21b33, 0x243727 },
	{ 0x21b34, 0x263e5f },
	{ 0x21b39, 0x26517a },
	{ 0x21b3a, 0x265178 },
	{ 0x21b3b, 0x265179 },
	{ 0x21b3d, 0x265c30 },
	{ 0x21b3e, 0x244426 },
	{ 0x21b3f, 0x2f475b },
	{ 0x21b41, 0x265c31 },
	{ 0x21b42, 0x25453d },
	{ 0x21b45, 0x2f4e51 },
	{ 0x21b46, 0x27223a },
	{ 0x21b48, 0x272239 },
	{ 0x21b4a, 0x272d39 },
	{ 0x21b4b, 0x255352 },
	{ 0x21b4c, 0x272d38 },
	{ 0x21b4d, 0x27375b },
	{ 0x21b4e, 0x27375c },
	{ 0x21b50, 0x25614f },
	{ 0x21b51, 0x274659 },
	{ 0x21b52, 0x274d54 },
	{ 0x21b53, 0x27532f },
	{ 0x21b55, 0x26216b },
	{ 0x21b56, 0x2f2139 },
	{ 0x21b59, 0x26244c },
	{ 0x21b5a, 0x25224c },
	{ 0x21b5d, 0x262724 },
	{ 0x21b5e, 0x242372 },
	{ 0x21b5f, 0x262723 },
	{ 0x21b60, 0x262722 },
	{ 0x21b61, 0x2f2373 },
	{ 0x21b65, 0x252567 },
	{ 0x21b68, 0x2f2658 },
	{ 0x21b69, 0x262a6b },
	{ 0x21b6a, 0x263032 },
	{ 0x21b6b, 0x263030 },
	{ 0x21b6f, 0x263033 },
	{ 0x21b73, 0x252870 },
	{ 0x21b74, 0x242c4b },
	{ 0x21b75, 0x2f2f21 },
	{ 0x21b79, 0x263669 },
	{ 0x21b7d, 0x263e61 },
	{ 0x21b7e, 0x253171 },
	{ 0x21b7f, 0x253763 },
	{ 0x21b80, 0x263e63 },
	{ 0x21b81, 0x263e60 },
	{ 0x21b82, 0x263e62 },
	{ 0x21b83, 0x2f3430 },
	{ 0x21b8e, 0x264771 },
	{ 0x21b8f, 0x2f3a50 },
	{ 0x21b90, 0x264773 },
	{ 0x21b95, 0x264772 },
	{ 0x21b99, 0x253e65 },
	{ 0x21b9d, 0x2f412f },
	{ 0x21b9e, 0x25453e },
	{ 0x21b9f, 0x265c33 },
	{ 0x21ba1, 0x265c32 },
	{ 0x21ba6, 0x254c62 },
	{ 0x21ba7, 0x27223b },
	{ 0x21bb0, 0x25542f },
	{ 0x21bb1, 0x272d3a },
	{ 0x21bb4, 0x2f5977 },
	{ 0x21bbb, 0x256150 },
	{ 0x21bbf, 0x256f77 },
	{ 0x21bc2, 0x24214a },
	{ 0x21bc3, 0x2f213a },
	{ 0x21bc4, 0x252165 },
	{ 0x21bc5, 0x2f214d },
	{ 0x21bc6, 0x2f215a },
	{ 0x21bc9, 0x26226b },
	{ 0x21bca, 0x26226a },
	{ 0x21bcd, 0x25224d },
	{ 0x21bce, 0x2f2243 },
	{ 0x21bcf, 0x25236c },
	{ 0x21bd0, 0x242373 },
	{ 0x21bd2, 0x252568 },
	{ 0x21bd4, 0x262725 },
	{ 0x21bd6, 0x25236b },
	{ 0x21bd8, 0x25236e },
	{ 0x21bd9, 0x25236d },
	{ 0x21bdb, 0x263034 },
	{ 0x21bdc, 0x252569 },
	{ 0x21bdd, 0x262a6c },
	{ 0x21bde, 0x25256b },
	{ 0x21bdf, 0x2f2659 },
	{ 0x21be0, 0x263035 },
	{ 0x21be1, 0x25256a },
	{ 0x21be2, 0x252871 },
	{ 0x21be3, 0x263037 },
	{ 0x21be5, 0x263038 },
	{ 0x21be6, 0x252872 },
	{ 0x21be7, 0x263039 },
	{ 0x21be8, 0x252d23 },
	{ 0x21be9, 0x26366c },
	{ 0x21bea, 0x26366a },
	{ 0x21bec, 0x252d24 },
	{ 0x21bed, 0x26366b },
	{ 0x21bee, 0x26366d },
	{ 0x21bef, 0x2f2f22 },
	{ 0x21bf2, 0x263e66 },
	{ 0x21bf3, 0x253172 },
	{ 0x21bf4, 0x243134 },
	{ 0x21bf5, 0x253174 },
	{ 0x21bf6, 0x264776 },
	{ 0x21bf7, 0x264774 },
	{ 0x21bf8, 0x264775 },
	{ 0x21bfa, 0x24372a },
	{ 0x21bfb, 0x264777 },
	{ 0x21bfc, 0x2f3a51 },
	{ 0x21c02, 0x26517b },
	{ 0x21c03, 0x26517d },
	{ 0x21c04, 0x26517c },
	{ 0x21c07, 0x254826 },
	{ 0x21c09, 0x24427a },
	{ 0x21c0a, 0x265c34 },
	{ 0x21c0b, 0x254540 },
	{ 0x21c0c, 0x25453f },
	{ 0x21c0d, 0x265c35 },
	{ 0x21c0e, 0x254541 },
	{ 0x21c10, 0x272d3d },
	{ 0x21c11, 0x27223e },
	{ 0x21c12, 0x27223d },
	{ 0x21c14, 0x27223c },
	{ 0x21c15, 0x272d3b },
	{ 0x21c16, 0x255430 },
	{ 0x21c17, 0x272d3c },
	{ 0x21c18, 0x272d3e },
	{ 0x21c19, 0x2f5438 },
	{ 0x21c1c, 0x27375d },
	{ 0x21c1d, 0x246639 },
	{ 0x21c20, 0x246867 },
	{ 0x21c22, 0x257926 },
	{ 0x21c23, 0x26213e },
	{ 0x21c24, 0x242175 },
	{ 0x21c25, 0x242174 },
	{ 0x21c26, 0x26226c },
	{ 0x21c29, 0x26244d },
	{ 0x21c2a, 0x24225e },
	{ 0x21c2b, 0x25224e },
	{ 0x21c2c, 0x26244e },
	{ 0x21c2d, 0x262450 },
	{ 0x21c2e, 0x262451 },
	{ 0x21c2f, 0x26244f },
	{ 0x21c30, 0x2f2244 },
	{ 0x21c36, 0x262729 },
	{ 0x21c37, 0x2f2374 },
	{ 0x21c38, 0x262727 },
	{ 0x21c3a, 0x262726 },
	{ 0x21c3c, 0x262728 },
	{ 0x21c3d, 0x25236f },
	{ 0x21c3e, 0x24262c },
	{ 0x21c3f, 0x24262b },
	{ 0x21c40, 0x262a6d },
	{ 0x21c41, 0x262a6e },
	{ 0x21c42, 0x25256c },
	{ 0x21c43, 0x262a6f },
	{ 0x21c44, 0x2f265b },
	{ 0x21c4b, 0x25256d },
	{ 0x21c4c, 0x242877 },
	{ 0x21c4d, 0x26303a },
	{ 0x21c4e, 0x26303f },
	{ 0x21c4f, 0x24287a },
	{ 0x21c50, 0x242876 },
	{ 0x21c51, 0x252875 },
	{ 0x21c52, 0x26303e },
	{ 0x21c53, 0x26303d },
	{ 0x21c54, 0x26303c },
	{ 0x21c55, 0x26303b },
	{ 0x21c57, 0x2f2a40 },
	{ 0x21c58, 0x2f2a41 },
	{ 0x21c59, 0x2f2a42 },
	{ 0x21c5a, 0x2f2a43 },
	{ 0x21c5b, 0x2f2a44 },
	{ 0x21c5d, 0x2f2a3f },
	{ 0x21c60, 0x263040 },
	{ 0x21c61, 0x252874 },
	{ 0x21c62, 0x263672 },
	{ 0x21c63, 0x242c50 },
	{ 0x21c64, 0x26366f },
	{ 0x21c65, 0x242c4f },
	{ 0x21c66, 0x263e67 },
	{ 0x21c67, 0x263670 },
	{ 0x21c68, 0x26366e },
	{ 0x21c6a, 0x2f2f23 },
	{ 0x21c6b, 0x2f2f24 },
	{ 0x21c6c, 0x2f2f26 },
	{ 0x21c6d, 0x2f2f27 },
	{ 0x21c6e, 0x2f2f28 },
	{ 0x21c70, 0x252d26 },
	{ 0x21c71, 0x252d27 },
	{ 0x21c72, 0x263671 },
	{ 0x21c74, 0x263673 },
	{ 0x21c77, 0x252d25 },
	{ 0x21c79, 0x263674 },
	{ 0x21c7a, 0x263e6d },
	{ 0x21c7b, 0x263e69 },
	{ 0x21c7c, 0x253178 },
	{ 0x21c7d, 0x25317a },
	{ 0x21c7e, 0x253177 },
	{ 0x21c7f, 0x253179 },
	{ 0x21c80, 0x253176 },
	{ 0x21c81, 0x25317b },
	{ 0x21c82, 0x263e70 },
	{ 0x21c83, 0x263e6a },
	{ 0x21c84, 0x2f3431 },
	{ 0x21c85, 0x2f3432 },
	{ 0x21c86, 0x2f3435 },
	{ 0x21c87, 0x2f3436 },
	{ 0x21c88, 0x2f3437 },
	{ 0x21c89, 0x2f3438 },
	{ 0x21c8a, 0x2f3439 },
	{ 0x21c8b, 0x2f343a },
	{ 0x21c8c, 0x263e68 },
	{ 0x21c8e, 0x263e6c },
	{ 0x21c91, 0x263e6f },
	{ 0x21c92, 0x263e6e },
	{ 0x21c93, 0x2f3433 },
	{ 0x21c94, 0x264823 },
	{ 0x21c95, 0x264824 },
	{ 0x21c96, 0x264822 },
	{ 0x21c97, 0x24372c },
	{ 0x21c98, 0x26477e },
	{ 0x21c99, 0x26477a },
	{ 0x21c9a, 0x253764 },
	{ 0x21c9b, 0x24372d },
	{ 0x21c9c, 0x253765 },
	{ 0x21c9d, 0x264779 },
	{ 0x21c9e, 0x264778 },
	{ 0x21c9f, 0x264825 },
	{ 0x21ca0, 0x264821 },
	{ 0x21ca1, 0x264826 },
	{ 0x21ca3, 0x26477c },
	{ 0x21ca6, 0x2f3a52 },
	{ 0x21ca7, 0x2f3a53 },
	{ 0x21ca8, 0x2f3a54 },
	{ 0x21ca9, 0x26477d },
	{ 0x21caa, 0x24372e },
	{ 0x21cac, 0x265223 },
	{ 0x21cad, 0x253e69 },
	{ 0x21cae, 0x253e67 },
	{ 0x21caf, 0x265226 },
	{ 0x21cb0, 0x253e68 },
	{ 0x21cb1, 0x265225 },
	{ 0x21cb2, 0x265229 },
	{ 0x21cb3, 0x265221 },
	{ 0x21cb4, 0x26517e },
	{ 0x21cb5, 0x265227 },
	{ 0x21cb6, 0x265224 },
	{ 0x21cb8, 0x2f4130 },
	{ 0x21cb9, 0x2f4131 },
	{ 0x21cba, 0x2f4132 },
	{ 0x21cbb, 0x265222 },
	{ 0x21cbe, 0x265228 },
	{ 0x21cc2, 0x253e66 },
	{ 0x21cc4, 0x24427c },
	{ 0x21cc5, 0x24427e },
	{ 0x21cc6, 0x24427b },
	{ 0x21cc7, 0x265c38 },
	{ 0x21cc8, 0x265c36 },
	{ 0x21cc9, 0x265c37 },
	{ 0x21cca, 0x2f475d },
	{ 0x21ccd, 0x265c39 },
	{ 0x21ccf, 0x254542 },
	{ 0x21cd0, 0x272240 },
	{ 0x21cd1, 0x254c66 },
	{ 0x21cd3, 0x2f4e52 },
	{ 0x21cd4, 0x2f4e53 },
	{ 0x21cd5, 0x2f4e54 },
	{ 0x21cd6, 0x2f4e55 },
	{ 0x21cd7, 0x2f4e56 },
	{ 0x21cd8, 0x254c65 },
	{ 0x21cde, 0x254c64 },
	{ 0x21cdf, 0x272d40 },
	{ 0x21ce0, 0x272d3f },
	{ 0x21ce1, 0x27223f },
	{ 0x21ce6, 0x2f5439 },
	{ 0x21ce7, 0x27302d },
	{ 0x21ce8, 0x27375e },
	{ 0x21ceb, 0x273f43 },
	{ 0x21cec, 0x245f58 },
	{ 0x21ced, 0x256762 },
	{ 0x21cf1, 0x2f6527 },
	{ 0x21cf2, 0x2f6528 },
	{ 0x21cf4, 0x256b7d },
	{ 0x21cf7, 0x2f6751 },
	{ 0x21cf8, 0x25733a },
	{ 0x21cfe, 0x252130 },
	{ 0x21cff, 0x26216c },
	{ 0x21d00, 0x26226d },
	{ 0x21d01, 0x262454 },
	{ 0x21d02, 0x262453 },
	{ 0x21d04, 0x262452 },
	{ 0x21d05, 0x25224f },
	{ 0x21d06, 0x242375 },
	{ 0x21d08, 0x26272a },
	{ 0x21d0b, 0x24262d },
	{ 0x21d0c, 0x262a71 },
	{ 0x21d0d, 0x262a70 },
	{ 0x21d0e, 0x252877 },
	{ 0x21d0f, 0x263042 },
	{ 0x21d11, 0x263043 },
	{ 0x21d12, 0x252876 },
	{ 0x21d13, 0x263044 },
	{ 0x21d15, 0x263677 },
	{ 0x21d16, 0x263678 },
	{ 0x21d17, 0x263676 },
	{ 0x21d18, 0x263528 },
	{ 0x21d19, 0x263675 },
	{ 0x21d1b, 0x263e71 },
	{ 0x21d1c, 0x263e72 },
	{ 0x21d1d, 0x264828 },
	{ 0x21d1e, 0x253767 },
	{ 0x21d1f, 0x264829 },
	{ 0x21d21, 0x264827 },
	{ 0x21d23, 0x2f3a55 },
	{ 0x21d24, 0x26522a },
	{ 0x21d25, 0x265c3a },
	{ 0x21d26, 0x272241 },
	{ 0x21d27, 0x272d41 },
	{ 0x21d28, 0x272242 },
	{ 0x21d29, 0x272243 },
	{ 0x21d2b, 0x275330 },
	{ 0x21d2c, 0x275e5d },
	{ 0x21d2d, 0x252145 },
	{ 0x21d2f, 0x252146 },
	{ 0x21d30, 0x262270 },
	{ 0x21d31, 0x26226e },
	{ 0x21d32, 0x262272 },
	{ 0x21d33, 0x262271 },
	{ 0x21d35, 0x2f215c },
	{ 0x21d36, 0x2f215d },
	{ 0x21d37, 0x2f215e },
	{ 0x21d38, 0x262273 },
	{ 0x21d3b, 0x252166 },
	{ 0x21d3c, 0x26226f },
	{ 0x21d3f, 0x262457 },
	{ 0x21d40, 0x262455 },
	{ 0x21d41, 0x262459 },
	{ 0x21d46, 0x232359 },
	{ 0x21d47, 0x2f2245 },
	{ 0x21d48, 0x2f2246 },
	{ 0x21d4a, 0x262456 },
	{ 0x21d4b, 0x252253 },
	{ 0x21d4e, 0x26245a },
	{ 0x21d4f, 0x262458 },
	{ 0x21d51, 0x252252 },
	{ 0x21d53, 0x26272e },
	{ 0x21d54, 0x252371 },
	{ 0x21d55, 0x252378 },
	{ 0x21d56, 0x252379 },
	{ 0x21d57, 0x262730 },
	{ 0x21d58, 0x252376 },
	{ 0x21d59, 0x252375 },
	{ 0x21d5a, 0x252377 },
	{ 0x21d5b, 0x252372 },
	{ 0x21d5c, 0x252373 },
	{ 0x21d5d, 0x262731 },
	{ 0x21d5e, 0x26272c },
	{ 0x21d63, 0x262732 },
	{ 0x21d64, 0x2f2376 },
	{ 0x21d66, 0x2f2377 },
	{ 0x21d67, 0x2f2379 },
	{ 0x21d68, 0x2f237a },
	{ 0x21d69, 0x2f237b },
	{ 0x21d6a, 0x2f237e },
	{ 0x21d6b, 0x2f2421 },
	{ 0x21d6e, 0x26272d },
	{ 0x21d70, 0x26272f },
	{ 0x21d71, 0x24237d },
	{ 0x21d73, 0x2f237d },
	{ 0x21d79, 0x262734 },
	{ 0x21d7a, 0x262733 },
	{ 0x21d7c, 0x24237c },
	{ 0x21d7e, 0x26272b },
	{ 0x21d82, 0x25237a },
	{ 0x21d83, 0x242630 },
	{ 0x21d84, 0x252575 },
	{ 0x21d85, 0x262a75 },
	{ 0x21d86, 0x242633 },
	{ 0x21d87, 0x262a72 },
	{ 0x21d88, 0x252573 },
	{ 0x21d89, 0x252574 },
	{ 0x21d8a, 0x262a7a },
	{ 0x21d8b, 0x252571 },
	{ 0x21d8c, 0x262a77 },
	{ 0x21d8d, 0x262a7c },
	{ 0x21d8e, 0x25256f },
	{ 0x21d8f, 0x262a79 },
	{ 0x21d90, 0x252572 },
	{ 0x21d91, 0x252570 },
	{ 0x21d92, 0x262a74 },
	{ 0x21d93, 0x262735 },
	{ 0x21d94, 0x2f265c },
	{ 0x21d95, 0x2f265d },
	{ 0x21d96, 0x2f265e },
	{ 0x21d97, 0x2f265f },
	{ 0x21d98, 0x2f2660 },
	{ 0x21d99, 0x2f2661 },
	{ 0x21d9a, 0x2f2663 },
	{ 0x21d9b, 0x2f2664 },
	{ 0x21d9d, 0x2f2665 },
	{ 0x21d9e, 0x2f2666 },
	{ 0x21d9f, 0x2f2667 },
	{ 0x21da0, 0x2f2668 },
	{ 0x21da2, 0x262a78 },
	{ 0x21da4, 0x262d2b },
	{ 0x21da9, 0x262a73 },
	{ 0x21daa, 0x252576 },
	{ 0x21dab, 0x263050 },
	{ 0x21dac, 0x26304a },
	{ 0x21dad, 0x252878 },
	{ 0x21dae, 0x26304b },
	{ 0x21daf, 0x252879 },
	{ 0x21db0, 0x24287e },
	{ 0x21db1, 0x25287a },
	{ 0x21db3, 0x263046 },
	{ 0x21db8, 0x263049 },
	{ 0x21db9, 0x263052 },
	{ 0x21dbb, 0x2f2a45 },
	{ 0x21dbc, 0x2f2a47 },
	{ 0x21dbd, 0x2f2a48 },
	{ 0x21dbe, 0x2f2a4b },
	{ 0x21dbf, 0x2f2a4c },
	{ 0x21dc0, 0x2f2a4d },
	{ 0x21dc1, 0x2f2a4e },
	{ 0x21dc2, 0x2f2a4f },
	{ 0x21dc3, 0x2f2a50 },
	{ 0x21dc4, 0x2f2a51 },
	{ 0x21dc5, 0x26304d },
	{ 0x21dc6, 0x263045 },
	{ 0x21dc7, 0x263047 },
	{ 0x21dc9, 0x263051 },
	{ 0x21dcc, 0x26304f },
	{ 0x21dcf, 0x26304c },
	{ 0x21dd0, 0x2f2a4a },
	{ 0x21dd1, 0x2f2a46 },
	{ 0x21dd2, 0x263048 },
	{ 0x21dd3, 0x25287b },
	{ 0x21dd4, 0x24287c },
	{ 0x21dd5, 0x252d2c },
	{ 0x21dd6, 0x252d29 },
	{ 0x21dd7, 0x242c52 },
	{ 0x21dd8, 0x242c59 },
	{ 0x21dd9, 0x252d2a },
	{ 0x21dda, 0x263721 },
	{ 0x21ddb, 0x242c58 },
	{ 0x21ddc, 0x252d34 },
	{ 0x21ddd, 0x252d30 },
	{ 0x21dde, 0x252d2b },
	{ 0x21ddf, 0x26367d },
	{ 0x21de0, 0x252d31 },
	{ 0x21de1, 0x252d2d },
	{ 0x21de2, 0x252d2f },
	{ 0x21de3, 0x263724 },
	{ 0x21de4, 0x26367e },
	{ 0x21de5, 0x242c62 },
	{ 0x21de6, 0x263679 },
	{ 0x21de7, 0x242c63 },
	{ 0x21de8, 0x242c56 },
	{ 0x21de9, 0x263725 },
	{ 0x21dea, 0x263722 },
	{ 0x21ded, 0x263723 },
	{ 0x21dee, 0x26367b },
	{ 0x21def, 0x2f2f29 },
	{ 0x21df0, 0x2f2f2a },
	{ 0x21df1, 0x2f2f2b },
	{ 0x21df2, 0x2f2f2c },
	{ 0x21df3, 0x2f2f2d },
	{ 0x21df4, 0x2f2f2e },
	{ 0x21df5, 0x2f2f2f },
	{ 0x21df6, 0x2f2f31 },
	{ 0x21df7, 0x2f2f33 },
	{ 0x21df8, 0x252d28 },
	{ 0x21dff, 0x2f2f30 },
	{ 0x21e02, 0x2f2f32 },
	{ 0x21e08, 0x252d33 },
	{ 0x21e09, 0x242c5d },
	{ 0x21e0a, 0x252d35 },
	{ 0x21e0c, 0x252d36 },
	{ 0x21e0e, 0x252d32 },
	{ 0x21e10, 0x263b4e },
	{ 0x21e11, 0x24313a },
	{ 0x21e12, 0x263f2b },
	{ 0x21e13, 0x263f24 },
	{ 0x21e14, 0x263f26 },
	{ 0x21e15, 0x24313c },
	{ 0x21e16, 0x24313e },
	{ 0x21e17, 0x25317e },
	{ 0x21e18, 0x263e79 },
	{ 0x21e19, 0x263f22 },
	{ 0x21e1a, 0x263e7b },
	{ 0x21e1b, 0x253228 },
	{ 0x21e1c, 0x243138 },
	{ 0x21e1e, 0x263f27 },
	{ 0x21e1f, 0x263f2c },
	{ 0x21e20, 0x263f29 },
	{ 0x21e21, 0x263e74 },
	{ 0x21e22, 0x263f2a },
	{ 0x21e23, 0x243140 },
	{ 0x21e24, 0x24313b },
	{ 0x21e25, 0x25317c },
	{ 0x21e26, 0x253226 },
	{ 0x21e27, 0x263e73 },
	{ 0x21e28, 0x243136 },
	{ 0x21e29, 0x25317d },
	{ 0x21e2a, 0x253224 },
	{ 0x21e2c, 0x263f28 },
	{ 0x21e35, 0x263f23 },
	{ 0x21e36, 0x2f343b },
	{ 0x21e38, 0x2f343c },
	{ 0x21e39, 0x2f343d },
	{ 0x21e3a, 0x2f343e },
	{ 0x21e3b, 0x2f3440 },
	{ 0x21e3c, 0x2f3441 },
	{ 0x21e3d, 0x2f3442 },
	{ 0x21e3e, 0x2f3443 },
	{ 0x21e3f, 0x2f3444 },
	{ 0x21e40, 0x2f3446 },
	{ 0x21e41, 0x2f3447 },
	{ 0x21e42, 0x2f3448 },
	{ 0x21e43, 0x263e77 },
	{ 0x21e46, 0x26322a },
	{ 0x21e4a, 0x263e7d },
	{ 0x21e4b, 0x263e7c },
	{ 0x21e4d, 0x263e7e },
	{ 0x21e4f, 0x263f21 },
	{ 0x21e52, 0x263f25 },
	{ 0x21e54, 0x24313f },
	{ 0x21e62, 0x253229 },
	{ 0x21e63, 0x253221 },
	{ 0x21e64, 0x253227 },
	{ 0x21e65, 0x253223 },
	{ 0x21e67, 0x253222 },
	{ 0x21e68, 0x253225 },
	{ 0x21e69, 0x25322a },
	{ 0x21e6a, 0x253769 },
	{ 0x21e6b, 0x264833 },
	{ 0x21e6c, 0x25376e },
	{ 0x21e6d, 0x26482a },
	{ 0x21e6e, 0x264834 },
	{ 0x21e6f, 0x25376f },
	{ 0x21e70, 0x25376c },
	{ 0x21e72, 0x25376b },
	{ 0x21e73, 0x243730 },
	{ 0x21e75, 0x253770 },
	{ 0x21e76, 0x25376a },
	{ 0x21e77, 0x253771 },
	{ 0x21e78, 0x253772 },
	{ 0x21e79, 0x253774 },
	{ 0x21e7a, 0x26482e },
	{ 0x21e7b, 0x263e7a },
	{ 0x21e7c, 0x243731 },
	{ 0x21e7d, 0x26482f },
	{ 0x21e7e, 0x25376d },
	{ 0x21e86, 0x243733 },
	{ 0x21e88, 0x253768 },
	{ 0x21e8a, 0x253773 },
	{ 0x21e8b, 0x2f3a56 },
	{ 0x21e8c, 0x2f3a58 },
	{ 0x21e8d, 0x2f3a59 },
	{ 0x21e8e, 0x2f3a5a },
	{ 0x21e8f, 0x2f3a5b },
	{ 0x21e92, 0x26482d },
	{ 0x21e94, 0x253775 },
	{ 0x21e99, 0x264832 },
	{ 0x21e9a, 0x26482c },
	{ 0x21e9d, 0x264831 },
	{ 0x21ea1, 0x264830 },
	{ 0x21ea4, 0x2f3a5c },
	{ 0x21eab, 0x253e70 },
	{ 0x21eac, 0x26522d },
	{ 0x21ead, 0x253e6c },
	{ 0x21eae, 0x243c7a },
	{ 0x21eaf, 0x253e71 },
	{ 0x21eb0, 0x26522e },
	{ 0x21eb1, 0x265c3b },
	{ 0x21eb2, 0x243c7d },
	{ 0x21eb3, 0x265235 },
	{ 0x21eb4, 0x253e6a },
	{ 0x21eb5, 0x253e73 },
	{ 0x21eb6, 0x26522b },
	{ 0x21eb7, 0x253e6f },
	{ 0x21eb9, 0x26522c },
	{ 0x21eba, 0x265239 },
	{ 0x21ebb, 0x265230 },
	{ 0x21ebc, 0x265238 },
	{ 0x21ebd, 0x253e6e },
	{ 0x21ebe, 0x265236 },
	{ 0x21ebf, 0x265c40 },
	{ 0x21ec0, 0x2f4137 },
	{ 0x21ec1, 0x253e72 },
	{ 0x21ec2, 0x2f4133 },
	{ 0x21ec3, 0x2f4134 },
	{ 0x21ec4, 0x2f4136 },
	{ 0x21ec5, 0x2f4138 },
	{ 0x21ec6, 0x2f4139 },
	{ 0x21ec7, 0x26523a },
	{ 0x21ecb, 0x265232 },
	{ 0x21ecd, 0x265237 },
	{ 0x21ed1, 0x253e6b },
	{ 0x21ed5, 0x2f4135 },
	{ 0x21ed7, 0x26522f },
	{ 0x21ed8, 0x254543 },
	{ 0x21ed9, 0x25454b },
	{ 0x21eda, 0x254549 },
	{ 0x21edb, 0x265c41 },
	{ 0x21edc, 0x265c3c },
	{ 0x21edd, 0x24432b },
	{ 0x21ede, 0x244326 },
	{ 0x21edf, 0x244325 },
	{ 0x21ee0, 0x254544 },
	{ 0x21ee1, 0x254548 },
	{ 0x21ee2, 0x254547 },
	{ 0x21ee3, 0x25454a },
	{ 0x21ee4, 0x25454e },
	{ 0x21ee5, 0x265c3e },
	{ 0x21ee6, 0x265c47 },
	{ 0x21ee7, 0x25454d },
	{ 0x21ee8, 0x254545 },
	{ 0x21ee9, 0x254546 },
	{ 0x21eea, 0x265c42 },
	{ 0x21eec, 0x244329 },
	{ 0x21eed, 0x265c46 },
	{ 0x21eee, 0x244327 },
	{ 0x21eef, 0x244323 },
	{ 0x21ef0, 0x25454c },
	{ 0x21ef1, 0x265c45 },
	{ 0x21ef2, 0x265c43 },
	{ 0x21ef4, 0x265c3f },
	{ 0x21ef5, 0x244328 },
	{ 0x21ef6, 0x2f475e },
	{ 0x21ef7, 0x2f475f },
	{ 0x21ef8, 0x2f4760 },
	{ 0x21ef9, 0x2f4761 },
	{ 0x21efe, 0x265231 },
	{ 0x21f0a, 0x24494e },
	{ 0x21f0b, 0x272249 },
	{ 0x21f0c, 0x244952 },
	{ 0x21f0d, 0x272245 },
	{ 0x21f0e, 0x254c69 },
	{ 0x21f10, 0x272250 },
	{ 0x21f11, 0x27224a },
	{ 0x21f12, 0x254c6e },
	{ 0x21f13, 0x254c67 },
	{ 0x21f14, 0x272247 },
	{ 0x21f15, 0x272251 },
	{ 0x21f16, 0x254c6f },
	{ 0x21f17, 0x27224f },
	{ 0x21f18, 0x27224c },
	{ 0x21f19, 0x27224d },
	{ 0x21f1a, 0x254c70 },
	{ 0x21f1b, 0x254c6a },
	{ 0x21f1c, 0x254c6d },
	{ 0x21f1d, 0x272d44 },
	{ 0x21f25, 0x272246 },
	{ 0x21f26, 0x2f4e57 },
	{ 0x21f27, 0x2f4e58 },
	{ 0x21f28, 0x2f4e59 },
	{ 0x21f29, 0x2f4e5b },
	{ 0x21f2a, 0x2f4e5c },
	{ 0x21f2f, 0x272244 },
	{ 0x21f30, 0x27224b },
	{ 0x21f36, 0x27224e },
	{ 0x21f3a, 0x254c6b },
	{ 0x21f3c, 0x272248 },
	{ 0x21f3d, 0x244951 },
	{ 0x21f3e, 0x255433 },
	{ 0x21f3f, 0x245023 },
	{ 0x21f40, 0x272d4a },
	{ 0x21f41, 0x245024 },
	{ 0x21f42, 0x255435 },
	{ 0x21f43, 0x272d42 },
	{ 0x21f44, 0x255438 },
	{ 0x21f45, 0x255434 },
	{ 0x21f46, 0x255431 },
	{ 0x21f47, 0x272d47 },
	{ 0x21f48, 0x272d43 },
	{ 0x21f49, 0x255b39 },
	{ 0x21f4a, 0x255432 },
	{ 0x21f4c, 0x2f543a },
	{ 0x21f4d, 0x2f543b },
	{ 0x21f4e, 0x2f543c },
	{ 0x21f50, 0x272d45 },
	{ 0x21f53, 0x272d49 },
	{ 0x21f54, 0x272d48 },
	{ 0x21f55, 0x272d4b },
	{ 0x21f58, 0x272d46 },
	{ 0x21f5a, 0x272d4d },
	{ 0x21f5b, 0x255437 },
	{ 0x21f5c, 0x245629 },
	{ 0x21f5d, 0x255b3b },
	{ 0x21f5e, 0x256155 },
	{ 0x21f5f, 0x273760 },
	{ 0x21f60, 0x255b3f },
	{ 0x21f61, 0x273766 },
	{ 0x21f63, 0x255b3a },
	{ 0x21f64, 0x273762 },
	{ 0x21f65, 0x273764 },
	{ 0x21f66, 0x273761 },
	{ 0x21f67, 0x255b3d },
	{ 0x21f6c, 0x27375f },
	{ 0x21f6d, 0x273765 },
	{ 0x21f6e, 0x2f5979 },
	{ 0x21f6f, 0x2f597a },
	{ 0x21f70, 0x2f597b },
	{ 0x21f75, 0x24562a },
	{ 0x21f78, 0x273763 },
	{ 0x21f7a, 0x273767 },
	{ 0x21f7d, 0x273927 },
	{ 0x21f80, 0x255b40 },
	{ 0x21f82, 0x27465a },
	{ 0x21f85, 0x256154 },
	{ 0x21f86, 0x273f47 },
	{ 0x21f87, 0x245a7e },
	{ 0x21f88, 0x256151 },
	{ 0x21f89, 0x256152 },
	{ 0x21f8a, 0x273f49 },
	{ 0x21f8b, 0x2f5e59 },
	{ 0x21f8c, 0x256153 },
	{ 0x21f8d, 0x273f46 },
	{ 0x21f8e, 0x2f5e58 },
	{ 0x21f90, 0x273f45 },
	{ 0x21f91, 0x273f48 },
	{ 0x21f94, 0x256156 },
	{ 0x21f95, 0x256157 },
	{ 0x21f98, 0x27465c },
	{ 0x21f99, 0x245f5b },
	{ 0x21f9a, 0x27465e },
	{ 0x21f9b, 0x256765 },
	{ 0x21f9c, 0x245f59 },
	{ 0x21f9d, 0x27465d },
	{ 0x21f9e, 0x27465f },
	{ 0x21f9f, 0x274660 },
	{ 0x21fa2, 0x2f6230 },
	{ 0x21fa3, 0x2f6231 },
	{ 0x21fa4, 0x2f6232 },
	{ 0x21fa6, 0x274661 },
	{ 0x21fa7, 0x274662 },
	{ 0x21fa9, 0x27465b },
	{ 0x21fae, 0x246338 },
	{ 0x21faf, 0x274d55 },
	{ 0x21fb0, 0x246337 },
	{ 0x21fb1, 0x256b7e },
	{ 0x21fb2, 0x274d57 },
	{ 0x21fb6, 0x2f6529 },
	{ 0x21fb7, 0x274d56 },
	{ 0x21fbb, 0x255b3e },
	{ 0x21fbc, 0x256f78 },
	{ 0x21fbd, 0x256f7a },
	{ 0x21fbe, 0x256f79 },
	{ 0x21fc1, 0x275332 },
	{ 0x21fc6, 0x275331 },
	{ 0x21fc7, 0x25733b },
	{ 0x21fc8, 0x246869 },
	{ 0x21fc9, 0x24686a },
	{ 0x21fca, 0x275767 },
	{ 0x21fcb, 0x275769 },
	{ 0x21fcc, 0x275768 },
	{ 0x21fcf, 0x27576a },
	{ 0x21fd1, 0x25733c },
	{ 0x21fd4, 0x275e5e },
	{ 0x21fd5, 0x246b6a },
	{ 0x21fd6, 0x246b69 },
	{ 0x21fd8, 0x275e60 },
	{ 0x21fdb, 0x257758 },
	{ 0x21fdc, 0x275e5f },
	{ 0x21fdd, 0x257927 },
	{ 0x21fdf, 0x2f6c26 },
	{ 0x21fe0, 0x257a28 },
	{ 0x21fe1, 0x257a66 },
	{ 0x21fe2, 0x257b3c },
	{ 0x21fe3, 0x27634f },
	{ 0x21fe5, 0x257c34 },
	{ 0x21fe7, 0x26216d },
	{ 0x21fe8, 0x242125 },
	{ 0x21fe9, 0x242262 },
	{ 0x21fea, 0x252254 },
	{ 0x21feb, 0x26245b },
	{ 0x21fec, 0x26245c },
	{ 0x21fed, 0x252255 },
	{ 0x21fee, 0x26237e },
	{ 0x21fef, 0x24237e },
	{ 0x21ff0, 0x25237b },
	{ 0x21ff1, 0x262a7d },
	{ 0x21ff2, 0x2f266a },
	{ 0x21ff3, 0x2f2669 },
	{ 0x21ff7, 0x263055 },
	{ 0x21ff8, 0x263054 },
	{ 0x21ff9, 0x263056 },
	{ 0x21ffb, 0x263053 },
	{ 0x21ffd, 0x263726 },
	{ 0x21ffe, 0x25322b },
	{ 0x21fff, 0x243141 },
	{ 0x22000, 0x263f2d },
	{ 0x22001, 0x253776 },
	{ 0x22002, 0x265c48 },
	{ 0x22003, 0x272252 },
	{ 0x22004, 0x255439 },
	{ 0x22005, 0x2f4e5d },
	{ 0x22006, 0x2f543d },
	{ 0x22007, 0x273768 },
	{ 0x22008, 0x273f4a },
	{ 0x22009, 0x274663 },
	{ 0x2200a, 0x256766 },
	{ 0x2200e, 0x275e61 },
	{ 0x22010, 0x276535 },
	{ 0x22011, 0x26216f },
	{ 0x22012, 0x262171 },
	{ 0x22013, 0x262170 },
	{ 0x22014, 0x2f213b },
	{ 0x22018, 0x252168 },
	{ 0x22019, 0x252167 },
	{ 0x2201c, 0x25237c },
	{ 0x2201d, 0x262737 },
	{ 0x2201f, 0x2f266b },
	{ 0x22020, 0x263057 },
	{ 0x22021, 0x263728 },
	{ 0x22022, 0x2f2f34 },
	{ 0x22023, 0x263f2e },
	{ 0x22024, 0x2f3a5e },
	{ 0x22029, 0x272253 },
	{ 0x2202f, 0x274664 },
	{ 0x22034, 0x262274 },
	{ 0x22036, 0x252256 },
	{ 0x22037, 0x262a7e },
	{ 0x22039, 0x263059 },
	{ 0x2203b, 0x263058 },
	{ 0x2203f, 0x242c65 },
	{ 0x22040, 0x263f2f },
	{ 0x22041, 0x25355f },
	{ 0x22042, 0x25322d },
	{ 0x22043, 0x263f30 },
	{ 0x22044, 0x25322c },
	{ 0x22045, 0x264836 },
	{ 0x22046, 0x2f3a5f },
	{ 0x22047, 0x2f3a60 },
	{ 0x22048, 0x2f3a61 },
	{ 0x2204c, 0x272254 },
	{ 0x22050, 0x273f4b },
	{ 0x22052, 0x242177 },
	{ 0x22053, 0x262275 },
	{ 0x22054, 0x262276 },
	{ 0x22055, 0x252259 },
	{ 0x22056, 0x252258 },
	{ 0x22057, 0x242264 },
	{ 0x22058, 0x25225b },
	{ 0x22059, 0x262461 },
	{ 0x2205a, 0x262460 },
	{ 0x2205b, 0x26245e },
	{ 0x2205c, 0x2f2248 },
	{ 0x2205f, 0x2f224a },
	{ 0x22062, 0x252257 },
	{ 0x22063, 0x26245f },
	{ 0x22064, 0x25225a },
	{ 0x22065, 0x262741 },
	{ 0x22066, 0x26273b },
	{ 0x22067, 0x252422 },
	{ 0x22068, 0x262738 },
	{ 0x22069, 0x25237e },
	{ 0x2206a, 0x25237d },
	{ 0x2206c, 0x252423 },
	{ 0x2206d, 0x262740 },
	{ 0x2206e, 0x252424 },
	{ 0x2206f, 0x26273c },
	{ 0x22070, 0x26273f },
	{ 0x22071, 0x252421 },
	{ 0x22072, 0x2f2424 },
	{ 0x22073, 0x262739 },
	{ 0x22074, 0x26273a },
	{ 0x22075, 0x26273d },
	{ 0x22079, 0x252425 },
	{ 0x2207a, 0x26273e },
	{ 0x2207b, 0x25257b },
	{ 0x2207c, 0x242635 },
	{ 0x2207d, 0x252579 },
	{ 0x2207e, 0x25257d },
	{ 0x2207f, 0x25257a },
	{ 0x22080, 0x25257c },
	{ 0x22081, 0x252621 },
	{ 0x22082, 0x262b23 },
	{ 0x22083, 0x25257e },
	{ 0x22086, 0x252622 },
	{ 0x22087, 0x262b22 },
	{ 0x22088, 0x2f266c },
	{ 0x2208a, 0x252623 },
	{ 0x2208b, 0x262b21 },
	{ 0x2208d, 0x252577 },
	{ 0x2208f, 0x252578 },
	{ 0x22090, 0x25287e },
	{ 0x22091, 0x263062 },
	{ 0x22092, 0x25287d },
	{ 0x22093, 0x252922 },
	{ 0x22094, 0x25287c },
	{ 0x22095, 0x252923 },
	{ 0x22096, 0x26305f },
	{ 0x22097, 0x252925 },
	{ 0x22098, 0x252924 },
	{ 0x2209a, 0x26305b },
	{ 0x2209d, 0x252921 },
	{ 0x2209e, 0x26305a },
	{ 0x2209f, 0x263065 },
	{ 0x220a0, 0x263067 },
	{ 0x220a1, 0x2f2a53 },
	{ 0x220a2, 0x2f2a54 },
	{ 0x220a3, 0x2f2a55 },
	{ 0x220a5, 0x242926 },
	{ 0x220a6, 0x263061 },
	{ 0x220a9, 0x263060 },
	{ 0x220aa, 0x26305c },
	{ 0x220ab, 0x26305d },
	{ 0x220ac, 0x263066 },
	{ 0x220ae, 0x263064 },
	{ 0x220af, 0x26305e },
	{ 0x220b1, 0x252d38 },
	{ 0x220b2, 0x263732 },
	{ 0x220b4, 0x252d37 },
	{ 0x220b5, 0x26372e },
	{ 0x220b6, 0x252d39 },
	{ 0x220b7, 0x25322e },
	{ 0x220b8, 0x26372a },
	{ 0x220b9, 0x242c69 },
	{ 0x220ba, 0x242c6a },
	{ 0x220bb, 0x26372f },
	{ 0x220bc, 0x252d3a },
	{ 0x220bd, 0x26372d },
	{ 0x220be, 0x263731 },
	{ 0x220bf, 0x263730 },
	{ 0x220c0, 0x242c67 },
	{ 0x220c1, 0x263733 },
	{ 0x220c2, 0x263734 },
	{ 0x220c3, 0x2f2f36 },
	{ 0x220c4, 0x2f2f35 },
	{ 0x220c6, 0x263729 },
	{ 0x220cb, 0x26372b },
	{ 0x220cc, 0x263f35 },
	{ 0x220cd, 0x253235 },
	{ 0x220ce, 0x243146 },
	{ 0x220cf, 0x243143 },
	{ 0x220d0, 0x243144 },
	{ 0x220d1, 0x253233 },
	{ 0x220d2, 0x25322f },
	{ 0x220d3, 0x263f3a },
	{ 0x220d4, 0x253230 },
	{ 0x220d5, 0x253234 },
	{ 0x220d6, 0x263f3c },
	{ 0x220d7, 0x253231 },
	{ 0x220d8, 0x253236 },
	{ 0x220d9, 0x263f36 },
	{ 0x220da, 0x263f3b },
	{ 0x220db, 0x263f32 },
	{ 0x220dc, 0x253232 },
	{ 0x220dd, 0x263f34 },
	{ 0x220de, 0x2f3449 },
	{ 0x220df, 0x2f344a },
	{ 0x220e0, 0x2f344b },
	{ 0x220e1, 0x2f344c },
	{ 0x220e3, 0x263f39 },
	{ 0x220e4, 0x263f31 },
	{ 0x220e7, 0x263f3d },
	{ 0x220e8, 0x263f37 },
	{ 0x220ea, 0x263f33 },
	{ 0x220eb, 0x264839 },
	{ 0x220ec, 0x24373e },
	{ 0x220ed, 0x26483e },
	{ 0x220ee, 0x253779 },
	{ 0x220ef, 0x25377a },
	{ 0x220f0, 0x243738 },
	{ 0x220f1, 0x253778 },
	{ 0x220f2, 0x26483a },
	{ 0x220f3, 0x243737 },
	{ 0x220f4, 0x253821 },
	{ 0x220f5, 0x253822 },
	{ 0x220f6, 0x263f38 },
	{ 0x220f7, 0x264840 },
	{ 0x220f8, 0x26483d },
	{ 0x220f9, 0x26483b },
	{ 0x220fa, 0x25377d },
	{ 0x220fb, 0x264838 },
	{ 0x220fd, 0x2f3a62 },
	{ 0x220fe, 0x2f3a63 },
	{ 0x22101, 0x26483f },
	{ 0x22104, 0x25377b },
	{ 0x22105, 0x253777 },
	{ 0x22106, 0x264841 },
	{ 0x22107, 0x25377e },
	{ 0x22108, 0x2f402b },
	{ 0x2210a, 0x253e78 },
	{ 0x2210b, 0x243d22 },
	{ 0x2210c, 0x254552 },
	{ 0x2210d, 0x243d25 },
	{ 0x2210e, 0x253e75 },
	{ 0x2210f, 0x253e74 },
	{ 0x22110, 0x243d24 },
	{ 0x22113, 0x253e77 },
	{ 0x22114, 0x253e7a },
	{ 0x22115, 0x26523e },
	{ 0x22116, 0x26523b },
	{ 0x22117, 0x26523d },
	{ 0x22118, 0x265c4b },
	{ 0x2211a, 0x253e7b },
	{ 0x2211b, 0x26523c },
	{ 0x2211c, 0x253e76 },
	{ 0x2211e, 0x253e79 },
	{ 0x2211f, 0x265c4c },
	{ 0x22120, 0x265c4d },
	{ 0x22121, 0x254558 },
	{ 0x22122, 0x244334 },
	{ 0x22123, 0x25454f },
	{ 0x22124, 0x254555 },
	{ 0x22125, 0x265c4a },
	{ 0x22126, 0x254554 },
	{ 0x22127, 0x254557 },
	{ 0x2212b, 0x2f4762 },
	{ 0x22130, 0x254559 },
	{ 0x22131, 0x254550 },
	{ 0x22132, 0x254556 },
	{ 0x22133, 0x254551 },
	{ 0x22134, 0x272257 },
	{ 0x22135, 0x272259 },
	{ 0x22136, 0x254c74 },
	{ 0x22137, 0x254c73 },
	{ 0x22138, 0x254c75 },
	{ 0x22139, 0x244957 },
	{ 0x2213a, 0x254c76 },
	{ 0x2213c, 0x254c78 },
	{ 0x2213d, 0x244956 },
	{ 0x2213e, 0x272256 },
	{ 0x2213f, 0x272255 },
	{ 0x22142, 0x272258 },
	{ 0x22149, 0x254c77 },
	{ 0x2214a, 0x254c79 },
	{ 0x2214b, 0x254c72 },
	{ 0x2214d, 0x272d50 },
	{ 0x2214e, 0x25543e },
	{ 0x2214f, 0x272d52 },
	{ 0x22150, 0x272d58 },
	{ 0x22151, 0x25543d },
	{ 0x22152, 0x245028 },
	{ 0x22153, 0x272d57 },
	{ 0x22154, 0x272d56 },
	{ 0x22155, 0x25543b },
	{ 0x22156, 0x272d51 },
	{ 0x22157, 0x25543c },
	{ 0x22159, 0x272d54 },
	{ 0x2215a, 0x25543f },
	{ 0x2215b, 0x272d4f },
	{ 0x2215e, 0x24502a },
	{ 0x2215f, 0x255b41 },
	{ 0x22160, 0x255b42 },
	{ 0x22161, 0x24562c },
	{ 0x22162, 0x27376b },
	{ 0x22163, 0x2f597c },
	{ 0x22166, 0x273769 },
	{ 0x22168, 0x27376a },
	{ 0x22169, 0x25615a },
	{ 0x2216a, 0x256159 },
	{ 0x2216b, 0x256158 },
	{ 0x2216d, 0x274666 },
	{ 0x2216e, 0x245f5d },
	{ 0x2216f, 0x256767 },
	{ 0x22170, 0x245f5c },
	{ 0x22171, 0x274665 },
	{ 0x22172, 0x274667 },
	{ 0x22175, 0x256768 },
	{ 0x22176, 0x2f6233 },
	{ 0x22178, 0x274d58 },
	{ 0x22179, 0x256c21 },
	{ 0x2217b, 0x275333 },
	{ 0x2217c, 0x27576c },
	{ 0x2217d, 0x256f7b },
	{ 0x2217e, 0x25733d },
	{ 0x2217f, 0x27576b },
	{ 0x22183, 0x275e62 },
	{ 0x22184, 0x275e63 },
	{ 0x22185, 0x257759 },
	{ 0x22187, 0x276350 },
	{ 0x22188, 0x276375 },
	{ 0x22189, 0x242178 },
	{ 0x2218a, 0x262742 },
	{ 0x2218b, 0x252426 },
	{ 0x2218d, 0x242426 },
	{ 0x2218e, 0x262b24 },
	{ 0x2218f, 0x2f266d },
	{ 0x22190, 0x2f266e },
	{ 0x22191, 0x263069 },
	{ 0x22192, 0x263068 },
	{ 0x22193, 0x2f2a56 },
	{ 0x22199, 0x263735 },
	{ 0x2219a, 0x253237 },
	{ 0x2219b, 0x264842 },
	{ 0x2219c, 0x253823 },
	{ 0x2219f, 0x26523f },
	{ 0x221a2, 0x25455a },
	{ 0x221a4, 0x2f4764 },
	{ 0x221ac, 0x274d59 },
	{ 0x221ae, 0x2f6a4e },
	{ 0x221af, 0x262172 },
	{ 0x221b1, 0x262173 },
	{ 0x221b2, 0x262278 },
	{ 0x221b3, 0x252169 },
	{ 0x221b4, 0x262277 },
	{ 0x221b5, 0x2f2162 },
	{ 0x221b6, 0x242267 },
	{ 0x221b7, 0x242427 },
	{ 0x221b8, 0x252427 },
	{ 0x221b9, 0x2f2426 },
	{ 0x221bb, 0x26295e },
	{ 0x221bc, 0x262b25 },
	{ 0x221bd, 0x252624 },
	{ 0x221be, 0x252625 },
	{ 0x221bf, 0x26306a },
	{ 0x221c0, 0x263041 },
	{ 0x221c1, 0x242f27 },
	{ 0x221c6, 0x263736 },
	{ 0x221c7, 0x24314a },
	{ 0x221ca, 0x264843 },
	{ 0x221cb, 0x253e7c },
	{ 0x221cc, 0x25455b },
	{ 0x221cd, 0x27225b },
	{ 0x221ce, 0x2f4765 },
	{ 0x221cf, 0x265c4e },
	{ 0x221d0, 0x2f4e5f },
	{ 0x221d1, 0x27225c },
	{ 0x221d2, 0x27225d },
	{ 0x221d4, 0x245626 },
	{ 0x221d6, 0x27576d },
	{ 0x221d7, 0x242268 },
	{ 0x221d8, 0x25225e },
	{ 0x221d9, 0x262464 },
	{ 0x221da, 0x25225d },
	{ 0x221db, 0x262463 },
	{ 0x221dc, 0x262462 },
	{ 0x221dd, 0x262466 },
	{ 0x221de, 0x242269 },
	{ 0x221e0, 0x262465 },
	{ 0x221e3, 0x262745 },
	{ 0x221e4, 0x25242a },
	{ 0x221e5, 0x25242c },
	{ 0x221e6, 0x25242b },
	{ 0x221e7, 0x252428 },
	{ 0x221e8, 0x252429 },
	{ 0x221e9, 0x262744 },
	{ 0x221ea, 0x262748 },
	{ 0x221eb, 0x262b28 },
	{ 0x221ed, 0x262743 },
	{ 0x221ef, 0x262746 },
	{ 0x221f0, 0x25242d },
	{ 0x221f2, 0x25262c },
	{ 0x221f3, 0x252628 },
	{ 0x221f4, 0x252627 },
	{ 0x221f5, 0x25262b },
	{ 0x221f6, 0x25262a },
	{ 0x221f7, 0x242639 },
	{ 0x221f8, 0x262b26 },
	{ 0x221f9, 0x262b29 },
	{ 0x221fa, 0x262b27 },
	{ 0x221fb, 0x24263e },
	{ 0x221fc, 0x262b2a },
	{ 0x221fd, 0x2f2670 },
	{ 0x221fe, 0x2f2671 },
	{ 0x221ff, 0x2f2672 },
	{ 0x22200, 0x2f2673 },
	{ 0x22201, 0x2f2674 },
	{ 0x22202, 0x252629 },
	{ 0x22204, 0x25262d },
	{ 0x22205, 0x262b2b },
	{ 0x22207, 0x252928 },
	{ 0x22208, 0x25292a },
	{ 0x22209, 0x242927 },
	{ 0x2220a, 0x26306c },
	{ 0x2220b, 0x252929 },
	{ 0x2220c, 0x26306d },
	{ 0x2220d, 0x2f2a57 },
	{ 0x2220e, 0x2f2a59 },
	{ 0x2220f, 0x2f2a58 },
	{ 0x22210, 0x2f2a5a },
	{ 0x22211, 0x2f2a5b },
	{ 0x22212, 0x2f2a5c },
	{ 0x22217, 0x26306b },
	{ 0x22219, 0x252d3d },
	{ 0x2221a, 0x252d40 },
	{ 0x2221b, 0x252d3e },
	{ 0x2221c, 0x252d41 },
	{ 0x2221d, 0x252d3b },
	{ 0x2221e, 0x26373a },
	{ 0x2221f, 0x26373b },
	{ 0x22220, 0x242c6e },
	{ 0x22221, 0x252d42 },
	{ 0x22222, 0x252d3f },
	{ 0x22223, 0x26373c },
	{ 0x22224, 0x252d3c },
	{ 0x22225, 0x263739 },
	{ 0x22228, 0x2f2f37 },
	{ 0x2222c, 0x263737 },
	{ 0x2222d, 0x263738 },
	{ 0x22232, 0x252c7b },
	{ 0x22233, 0x253244 },
	{ 0x22234, 0x25323b },
	{ 0x22235, 0x253239 },
	{ 0x22236, 0x24314d },
	{ 0x22237, 0x263f43 },
	{ 0x22238, 0x253242 },
	{ 0x22239, 0x263f48 },
	{ 0x2223a, 0x263f3e },
	{ 0x2223b, 0x25323d },
	{ 0x2223c, 0x25323c },
	{ 0x2223d, 0x25323f },
	{ 0x2223e, 0x25323e },
	{ 0x2223f, 0x263f3f },
	{ 0x22240, 0x263f40 },
	{ 0x22241, 0x253241 },
	{ 0x22242, 0x253238 },
	{ 0x22243, 0x243150 },
	{ 0x22244, 0x263f44 },
	{ 0x22245, 0x253243 },
	{ 0x22246, 0x253828 },
	{ 0x22248, 0x263f41 },
	{ 0x2224a, 0x2f344d },
	{ 0x2224b, 0x2f344e },
	{ 0x2224c, 0x2f344f },
	{ 0x2224d, 0x2f3450 },
	{ 0x2224e, 0x2f3451 },
	{ 0x2224f, 0x2f3452 },
	{ 0x22250, 0x2f3453 },
	{ 0x22255, 0x263f47 },
	{ 0x22256, 0x26463d },
	{ 0x22258, 0x25323a },
	{ 0x22259, 0x263f42 },
	{ 0x2225a, 0x253240 },
	{ 0x2225b, 0x26484a },
	{ 0x2225c, 0x24314b },
	{ 0x2225d, 0x25382b },
	{ 0x2225e, 0x25382c },
	{ 0x2225f, 0x25382d },
	{ 0x22260, 0x26484b },
	{ 0x22261, 0x26484e },
	{ 0x22262, 0x253827 },
	{ 0x22263, 0x26484d },
	{ 0x22264, 0x243742 },
	{ 0x22265, 0x25382a },
	{ 0x22266, 0x253826 },
	{ 0x22267, 0x264849 },
	{ 0x22268, 0x243743 },
	{ 0x22269, 0x253825 },
	{ 0x2226a, 0x265244 },
	{ 0x2226b, 0x264846 },
	{ 0x2226c, 0x264847 },
	{ 0x2226d, 0x253824 },
	{ 0x2226e, 0x2f3a65 },
	{ 0x2226f, 0x2f3a67 },
	{ 0x22270, 0x2f3a68 },
	{ 0x22271, 0x2f3a69 },
	{ 0x22272, 0x2f3a6a },
	{ 0x22274, 0x264848 },
	{ 0x22276, 0x26484c },
	{ 0x2227c, 0x2f3a66 },
	{ 0x2227f, 0x243d2b },
	{ 0x22280, 0x253f25 },
	{ 0x22281, 0x243d2c },
	{ 0x22282, 0x265241 },
	{ 0x22283, 0x265242 },
	{ 0x22284, 0x253f22 },
	{ 0x22285, 0x253f23 },
	{ 0x22286, 0x265247 },
	{ 0x22287, 0x253e7d },
	{ 0x22289, 0x265245 },
	{ 0x2228a, 0x2f413a },
	{ 0x2228b, 0x2f413b },
	{ 0x2228c, 0x2f413c },
	{ 0x2228e, 0x265243 },
	{ 0x22290, 0x265248 },
	{ 0x22292, 0x253f24 },
	{ 0x22293, 0x253e7e },
	{ 0x22294, 0x265246 },
	{ 0x22295, 0x244338 },
	{ 0x22296, 0x25455c },
	{ 0x22297, 0x244337 },
	{ 0x22298, 0x25455e },
	{ 0x22299, 0x265c50 },
	{ 0x2229b, 0x254560 },
	{ 0x2229c, 0x25455f },
	{ 0x2229d, 0x265c4f },
	{ 0x2229e, 0x2f4767 },
	{ 0x2229f, 0x2f4768 },
	{ 0x222a0, 0x2f4769 },
	{ 0x222a1, 0x2f476a },
	{ 0x222a2, 0x2f476b },
	{ 0x222a3, 0x2f476c },
	{ 0x222a4, 0x2f476d },
	{ 0x222a5, 0x2f476e },
	{ 0x222a6, 0x2f476f },
	{ 0x222a8, 0x265c51 },
	{ 0x222aa, 0x266031 },
	{ 0x222ac, 0x2f4a54 },
	{ 0x222ad, 0x27225e },
	{ 0x222ae, 0x24495a },
	{ 0x222af, 0x24373f },
	{ 0x222b0, 0x244958 },
	{ 0x222b1, 0x254c7a },
	{ 0x222b2, 0x244959 },
	{ 0x222b3, 0x272d59 },
	{ 0x222b4, 0x272262 },
	{ 0x222b5, 0x254c7c },
	{ 0x222b6, 0x254c7e },
	{ 0x222b7, 0x2f4e60 },
	{ 0x222b8, 0x2f4e62 },
	{ 0x222b9, 0x2f4e63 },
	{ 0x222ba, 0x27225f },
	{ 0x222bb, 0x272261 },
	{ 0x222bc, 0x272263 },
	{ 0x222c1, 0x272260 },
	{ 0x222c2, 0x254c7b },
	{ 0x222c3, 0x255441 },
	{ 0x222c4, 0x254c7d },
	{ 0x222c5, 0x255443 },
	{ 0x222c6, 0x255440 },
	{ 0x222c7, 0x24502d },
	{ 0x222cc, 0x255444 },
	{ 0x222cd, 0x2f543f },
	{ 0x222ce, 0x2f5440 },
	{ 0x222cf, 0x2f5441 },
	{ 0x222d0, 0x2f5442 },
	{ 0x222d1, 0x27376e },
	{ 0x222d2, 0x255b44 },
	{ 0x222d3, 0x27376c },
	{ 0x222d4, 0x27376d },
	{ 0x222d5, 0x2f597e },
	{ 0x222d6, 0x2f5a21 },
	{ 0x222d7, 0x2f5a22 },
	{ 0x222d8, 0x2f5a23 },
	{ 0x222da, 0x255b43 },
	{ 0x222dc, 0x27376f },
	{ 0x222dd, 0x255b45 },
	{ 0x222e1, 0x273f51 },
	{ 0x222e2, 0x273f4e },
	{ 0x222e3, 0x25615b },
	{ 0x222e4, 0x2f5e5a },
	{ 0x222e5, 0x2f5e5c },
	{ 0x222e6, 0x273f4d },
	{ 0x222e7, 0x273f4f },
	{ 0x222ea, 0x273f4c },
	{ 0x222eb, 0x2f5e5b },
	{ 0x222ed, 0x273f50 },
	{ 0x222ef, 0x274668 },
	{ 0x222f0, 0x274669 },
	{ 0x222f1, 0x25615c },
	{ 0x222f2, 0x256769 },
	{ 0x222f5, 0x2f6234 },
	{ 0x222f6, 0x2f6235 },
	{ 0x222f7, 0x2f6236 },
	{ 0x222f8, 0x25676a },
	{ 0x222fb, 0x256c24 },
	{ 0x222fc, 0x256c23 },
	{ 0x222fd, 0x274d5d },
	{ 0x222fe, 0x274d5b },
	{ 0x222ff, 0x256c22 },
	{ 0x22300, 0x274d5a },
	{ 0x22302, 0x274d5c },
	{ 0x22303, 0x274d5e },
	{ 0x22304, 0x24663c },
	{ 0x22306, 0x275334 },
	{ 0x22307, 0x275361 },
	{ 0x22308, 0x25733e },
	{ 0x22309, 0x27576e },
	{ 0x2230b, 0x27576f },
	{ 0x2230d, 0x25756a },
	{ 0x2230f, 0x2f6a4f },
	{ 0x22311, 0x275b4d },
	{ 0x22312, 0x275e64 },
	{ 0x22313, 0x276236 },
	{ 0x22314, 0x257a68 },
	{ 0x22315, 0x257a67 },
	{ 0x22316, 0x2f6c7b },
	{ 0x22317, 0x2f2163 },
	{ 0x22318, 0x2f224b },
	{ 0x22319, 0x2f224c },
	{ 0x2231b, 0x262b2c },
	{ 0x2231c, 0x2f2427 },
	{ 0x2231d, 0x262b2d },
	{ 0x2231e, 0x262b2e },
	{ 0x22320, 0x2f2f39 },
	{ 0x22322, 0x2f2f3b },
	{ 0x22323, 0x2f2f3c },
	{ 0x22325, 0x2f2f3a },
	{ 0x22326, 0x253245 },
	{ 0x22327, 0x2f3454 },
	{ 0x22328, 0x26484f },
	{ 0x22329, 0x2f3a6b },
	{ 0x2232a, 0x2f3a6c },
	{ 0x2232b, 0x253f26 },
	{ 0x2232c, 0x26213f },
	{ 0x2232d, 0x262175 },
	{ 0x2232f, 0x262279 },
	{ 0x22331, 0x262749 },
	{ 0x22333, 0x24242a },
	{ 0x22334, 0x263070 },
	{ 0x22335, 0x26274d },
	{ 0x22336, 0x2f2428 },
	{ 0x22338, 0x26274b },
	{ 0x2233a, 0x26274e },
	{ 0x2233b, 0x24263f },
	{ 0x2233c, 0x262b30 },
	{ 0x2233d, 0x25262e },
	{ 0x2233e, 0x262b31 },
	{ 0x2233f, 0x232a39 },
	{ 0x22341, 0x242741 },
	{ 0x22342, 0x263523 },
	{ 0x22343, 0x263072 },
	{ 0x22344, 0x263073 },
	{ 0x22345, 0x263071 },
	{ 0x22346, 0x26306f },
	{ 0x2234a, 0x26306e },
	{ 0x2234d, 0x26373f },
	{ 0x2234e, 0x26373e },
	{ 0x2234f, 0x242c6f },
	{ 0x22350, 0x26373d },
	{ 0x22352, 0x263740 },
	{ 0x22354, 0x263f49 },
	{ 0x22355, 0x263f4a },
	{ 0x22356, 0x263f4b },
	{ 0x22357, 0x263f4c },
	{ 0x22358, 0x263f4d },
	{ 0x22359, 0x263f4e },
	{ 0x2235a, 0x243744 },
	{ 0x2235b, 0x264850 },
	{ 0x2235c, 0x264854 },
	{ 0x2235d, 0x264853 },
	{ 0x2235e, 0x264851 },
	{ 0x2235f, 0x2f3a6d },
	{ 0x22360, 0x264852 },
	{ 0x22362, 0x265249 },
	{ 0x22363, 0x253f27 },
	{ 0x22364, 0x2f413d },
	{ 0x22366, 0x265c53 },
	{ 0x22367, 0x265c54 },
	{ 0x22368, 0x265c52 },
	{ 0x2236b, 0x254561 },
	{ 0x2236c, 0x272264 },
	{ 0x2236e, 0x272d5a },
	{ 0x2236f, 0x272d5c },
	{ 0x22370, 0x24502f },
	{ 0x22371, 0x255445 },
	{ 0x22372, 0x273771 },
	{ 0x22373, 0x273770 },
	{ 0x22376, 0x275770 },
	{ 0x22377, 0x276351 },
	{ 0x22378, 0x276352 },
	{ 0x22379, 0x276536 },
	{ 0x2237a, 0x262140 },
	{ 0x2237b, 0x262176 },
	{ 0x2237e, 0x2f224d },
	{ 0x2237f, 0x24242b },
	{ 0x22380, 0x262750 },
	{ 0x22381, 0x26274f },
	{ 0x22383, 0x25242e },
	{ 0x22384, 0x262b32 },
	{ 0x22386, 0x263076 },
	{ 0x22387, 0x263075 },
	{ 0x2238a, 0x263077 },
	{ 0x2238c, 0x252e68 },
	{ 0x2238d, 0x263f4f },
	{ 0x2238e, 0x25382e },
	{ 0x22390, 0x26524a },
	{ 0x22391, 0x265c55 },
	{ 0x22392, 0x272265 },
	{ 0x22393, 0x272d5d },
	{ 0x22398, 0x25212a },
	{ 0x22399, 0x252147 },
	{ 0x2239a, 0x262178 },
	{ 0x2239c, 0x26217c },
	{ 0x2239d, 0x262177 },
	{ 0x2239f, 0x26217a },
	{ 0x223a0, 0x26217b },
	{ 0x223a2, 0x262321 },
	{ 0x223a3, 0x262322 },
	{ 0x223a4, 0x26227c },
	{ 0x223a5, 0x26227a },
	{ 0x223a6, 0x262323 },
	{ 0x223a7, 0x26227b },
	{ 0x223a8, 0x26227d },
	{ 0x223a9, 0x26227e },
	{ 0x223aa, 0x25216a },
	{ 0x223ab, 0x252260 },
	{ 0x223ad, 0x25225f },
	{ 0x223b0, 0x262468 },
	{ 0x223b1, 0x262469 },
	{ 0x223b2, 0x26246a },
	{ 0x223b6, 0x26246b },
	{ 0x223b7, 0x25242f },
	{ 0x223b8, 0x262751 },
	{ 0x223b9, 0x252431 },
	{ 0x223ba, 0x262753 },
	{ 0x223bb, 0x252430 },
	{ 0x223bc, 0x2f2429 },
	{ 0x223be, 0x2f242a },
	{ 0x223bf, 0x2f242b },
	{ 0x223c0, 0x2f242c },
	{ 0x223c1, 0x262752 },
	{ 0x223c5, 0x252432 },
	{ 0x223c6, 0x25262f },
	{ 0x223c7, 0x262b36 },
	{ 0x223c8, 0x262b33 },
	{ 0x223c9, 0x262b34 },
	{ 0x223d2, 0x262b37 },
	{ 0x223d3, 0x262b35 },
	{ 0x223d4, 0x26307e },
	{ 0x223d5, 0x25292c },
	{ 0x223d6, 0x26307d },
	{ 0x223d7, 0x242930 },
	{ 0x223d8, 0x263079 },
	{ 0x223d9, 0x25292b },
	{ 0x223da, 0x263078 },
	{ 0x223e4, 0x252d44 },
	{ 0x223e6, 0x252d43 },
	{ 0x223e7, 0x252d45 },
	{ 0x223e8, 0x263743 },
	{ 0x223e9, 0x263741 },
	{ 0x223ea, 0x252d46 },
	{ 0x223eb, 0x2f2f3d },
	{ 0x223ec, 0x263742 },
	{ 0x223ee, 0x25324a },
	{ 0x223ef, 0x253248 },
	{ 0x223f0, 0x253249 },
	{ 0x223f1, 0x263f56 },
	{ 0x223f2, 0x263f50 },
	{ 0x223f3, 0x24292f },
	{ 0x223f4, 0x264855 },
	{ 0x223f5, 0x263f52 },
	{ 0x223f6, 0x263f53 },
	{ 0x223f7, 0x253247 },
	{ 0x223f8, 0x263f51 },
	{ 0x223f9, 0x2f3455 },
	{ 0x223fa, 0x2f3456 },
	{ 0x223fb, 0x2f3457 },
	{ 0x223fc, 0x263f54 },
	{ 0x223fd, 0x263f57 },
	{ 0x223fe, 0x263f55 },
	{ 0x22400, 0x264856 },
	{ 0x22401, 0x264859 },
	{ 0x22402, 0x25382f },
	{ 0x22403, 0x253832 },
	{ 0x22404, 0x253831 },
	{ 0x22405, 0x26485a },
	{ 0x22406, 0x253830 },
	{ 0x22407, 0x264858 },
	{ 0x22408, 0x264857 },
	{ 0x2240a, 0x253f28 },
	{ 0x2240b, 0x243d31 },
	{ 0x2240c, 0x26524b },
	{ 0x2240d, 0x2f4140 },
	{ 0x2240f, 0x26524c },
	{ 0x22412, 0x254562 },
	{ 0x22413, 0x265c56 },
	{ 0x22414, 0x254563 },
	{ 0x22415, 0x265c57 },
	{ 0x22416, 0x265c59 },
	{ 0x22418, 0x2f4770 },
	{ 0x22419, 0x265c5a },
	{ 0x2241d, 0x265c58 },
	{ 0x2241e, 0x254d21 },
	{ 0x2241f, 0x254d22 },
	{ 0x22420, 0x244960 },
	{ 0x22421, 0x272266 },
	{ 0x22422, 0x2f4e64 },
	{ 0x22423, 0x2f4e65 },
	{ 0x22424, 0x272267 },
	{ 0x22425, 0x272d5f },
	{ 0x22426, 0x255446 },
	{ 0x22427, 0x245030 },
	{ 0x22428, 0x272d60 },
	{ 0x22429, 0x272d5e },
	{ 0x2242c, 0x273773 },
	{ 0x2242d, 0x273772 },
	{ 0x2242f, 0x273774 },
	{ 0x22430, 0x2f5a24 },
	{ 0x22432, 0x245b22 },
	{ 0x22433, 0x25615e },
	{ 0x22434, 0x273f52 },
	{ 0x22435, 0x2f5e5d },
	{ 0x22437, 0x25615d },
	{ 0x22438, 0x27466d },
	{ 0x22439, 0x27466b },
	{ 0x2243a, 0x27466f },
	{ 0x2243b, 0x27466a },
	{ 0x2243c, 0x27466c },
	{ 0x2243e, 0x25676b },
	{ 0x2243f, 0x256c25 },
	{ 0x22440, 0x274d5f },
	{ 0x22441, 0x245f5f },
	{ 0x22442, 0x274d61 },
	{ 0x22443, 0x274d60 },
	{ 0x22444, 0x256c26 },
	{ 0x22446, 0x256f7c },
	{ 0x22447, 0x256f7d },
	{ 0x22448, 0x24663d },
	{ 0x22449, 0x275335 },
	{ 0x2244a, 0x25733f },
	{ 0x2244b, 0x27603c },
	{ 0x2244c, 0x27606f },
	{ 0x2244d, 0x276446 },
	{ 0x22450, 0x26246e },
	{ 0x22451, 0x26246c },
	{ 0x22452, 0x26246d },
	{ 0x22453, 0x252433 },
	{ 0x22454, 0x263121 },
	{ 0x22455, 0x262b38 },
	{ 0x22456, 0x262d32 },
	{ 0x22457, 0x263124 },
	{ 0x22458, 0x263744 },
	{ 0x22459, 0x263122 },
	{ 0x2245a, 0x263123 },
	{ 0x2245b, 0x263746 },
	{ 0x2245c, 0x263745 },
	{ 0x2245e, 0x263f58 },
	{ 0x22461, 0x264f21 },
	{ 0x22462, 0x253833 },
	{ 0x22463, 0x26485c },
	{ 0x22464, 0x26485b },
	{ 0x22466, 0x253f2a },
	{ 0x22468, 0x265c5c },
	{ 0x22469, 0x265c5f },
	{ 0x2246a, 0x265c5d },
	{ 0x2246b, 0x265c5b },
	{ 0x2246d, 0x265c5e },
	{ 0x2246f, 0x272d61 },
	{ 0x22470, 0x272d4e },
	{ 0x22471, 0x245032 },
	{ 0x22472, 0x273775 },
	{ 0x22473, 0x273f55 },
	{ 0x22475, 0x273f54 },
	{ 0x22476, 0x273f53 },
	{ 0x22477, 0x274672 },
	{ 0x22478, 0x274670 },
	{ 0x22479, 0x274671 },
	{ 0x2247d, 0x275771 },
	{ 0x2247e, 0x275b4e },
	{ 0x2247f, 0x276237 },
	{ 0x22480, 0x262325 },
	{ 0x22481, 0x262324 },
	{ 0x22482, 0x2f2164 },
	{ 0x22483, 0x262471 },
	{ 0x22484, 0x26246f },
	{ 0x22487, 0x2f242d },
	{ 0x22488, 0x262754 },
	{ 0x22489, 0x252630 },
	{ 0x2248a, 0x262b3b },
	{ 0x2248c, 0x262b3a },
	{ 0x2248f, 0x263747 },
	{ 0x22490, 0x242c74 },
	{ 0x22491, 0x242c73 },
	{ 0x22494, 0x253560 },
	{ 0x22495, 0x263f5d },
	{ 0x22496, 0x263f59 },
	{ 0x22497, 0x263f5a },
	{ 0x22498, 0x2f3458 },
	{ 0x22499, 0x2f3459 },
	{ 0x2249a, 0x2f345a },
	{ 0x2249b, 0x263f5c },
	{ 0x2249c, 0x263f5b },
	{ 0x2249d, 0x25324b },
	{ 0x2249e, 0x26485d },
	{ 0x2249f, 0x264860 },
	{ 0x224a0, 0x26485e },
	{ 0x224a1, 0x26485f },
	{ 0x224a2, 0x2f3a6e },
	{ 0x224a4, 0x265251 },
	{ 0x224a5, 0x26524e },
	{ 0x224a6, 0x265250 },
	{ 0x224a7, 0x26524f },
	{ 0x224a8, 0x2f4141 },
	{ 0x224a9, 0x24433c },
	{ 0x224aa, 0x265c60 },
	{ 0x224ab, 0x27226b },
	{ 0x224ac, 0x27226c },
	{ 0x224ad, 0x272269 },
	{ 0x224ae, 0x27226a },
	{ 0x224af, 0x254d23 },
	{ 0x224b0, 0x245033 },
	{ 0x224b2, 0x255447 },
	{ 0x224b3, 0x272d64 },
	{ 0x224b4, 0x273776 },
	{ 0x224b5, 0x273f56 },
	{ 0x224b6, 0x2f6754 },
	{ 0x224b7, 0x274d62 },
	{ 0x224b8, 0x275336 },
	{ 0x224b9, 0x257341 },
	{ 0x224bb, 0x2f6c27 },
	{ 0x224bd, 0x26217d },
	{ 0x224be, 0x25216b },
	{ 0x224bf, 0x242179 },
	{ 0x224c0, 0x252261 },
	{ 0x224c2, 0x24226e },
	{ 0x224c3, 0x252262 },
	{ 0x224c4, 0x252434 },
	{ 0x224c5, 0x262758 },
	{ 0x224c6, 0x252435 },
	{ 0x224c7, 0x262757 },
	{ 0x224c8, 0x262759 },
	{ 0x224c9, 0x26275b },
	{ 0x224ca, 0x262756 },
	{ 0x224cb, 0x252436 },
	{ 0x224cf, 0x262755 },
	{ 0x224d0, 0x26275a },
	{ 0x224d2, 0x252633 },
	{ 0x224d3, 0x262b3d },
	{ 0x224d4, 0x252631 },
	{ 0x224d5, 0x262b3c },
	{ 0x224d6, 0x252632 },
	{ 0x224d7, 0x25292d },
	{ 0x224d8, 0x262b3f },
	{ 0x224dc, 0x242933 },
	{ 0x224dd, 0x263126 },
	{ 0x224de, 0x252930 },
	{ 0x224df, 0x25292e },
	{ 0x224e0, 0x263128 },
	{ 0x224e2, 0x252932 },
	{ 0x224e3, 0x252931 },
	{ 0x224e5, 0x2f2a5e },
	{ 0x224e9, 0x263127 },
	{ 0x224ea, 0x26374d },
	{ 0x224eb, 0x242c79 },
	{ 0x224ec, 0x242c77 },
	{ 0x224ed, 0x242c7c },
	{ 0x224ee, 0x242c75 },
	{ 0x224ef, 0x252d4b },
	{ 0x224f0, 0x252d49 },
	{ 0x224f1, 0x242c78 },
	{ 0x224f2, 0x242c7a },
	{ 0x224f3, 0x242c76 },
	{ 0x224f4, 0x242c7b },
	{ 0x224f5, 0x252d4a },
	{ 0x224f6, 0x263749 },
	{ 0x224f7, 0x26374f },
	{ 0x224f8, 0x26374c },
	{ 0x224f9, 0x2f2f3f },
	{ 0x224fa, 0x2f2f40 },
	{ 0x224fc, 0x26374b },
	{ 0x224fd, 0x263750 },
	{ 0x224fe, 0x26374e },
	{ 0x22500, 0x26374a },
	{ 0x22501, 0x243156 },
	{ 0x22502, 0x25324f },
	{ 0x22503, 0x263f68 },
	{ 0x22504, 0x263f61 },
	{ 0x22506, 0x25324c },
	{ 0x22507, 0x253251 },
	{ 0x22508, 0x25324e },
	{ 0x22509, 0x263f60 },
	{ 0x2250a, 0x253250 },
	{ 0x2250b, 0x243158 },
	{ 0x2250c, 0x263f67 },
	{ 0x2250d, 0x263f65 },
	{ 0x2250e, 0x263f62 },
	{ 0x2250f, 0x243159 },
	{ 0x22510, 0x263f66 },
	{ 0x22511, 0x25324d },
	{ 0x22518, 0x263f64 },
	{ 0x2251a, 0x263f5f },
	{ 0x2251c, 0x263f63 },
	{ 0x2251d, 0x264864 },
	{ 0x2251e, 0x2f345c },
	{ 0x2251f, 0x243746 },
	{ 0x22520, 0x253836 },
	{ 0x22521, 0x253835 },
	{ 0x22522, 0x25383b },
	{ 0x22523, 0x25383a },
	{ 0x22524, 0x253837 },
	{ 0x22525, 0x243747 },
	{ 0x22526, 0x264861 },
	{ 0x22527, 0x253834 },
	{ 0x22528, 0x264863 },
	{ 0x22529, 0x253838 },
	{ 0x2252a, 0x243155 },
	{ 0x2252b, 0x2f3a70 },
	{ 0x2252d, 0x264862 },
	{ 0x22530, 0x2f3a6f },
	{ 0x22531, 0x253839 },
	{ 0x22533, 0x253f2c },
	{ 0x22534, 0x253f2b },
	{ 0x22535, 0x265252 },
	{ 0x22536, 0x265254 },
	{ 0x22537, 0x265257 },
	{ 0x22538, 0x265253 },
	{ 0x2253b, 0x2f4142 },
	{ 0x2253c, 0x2f4143 },
	{ 0x2253d, 0x2f4144 },
	{ 0x2253e, 0x2f4145 },
	{ 0x2253f, 0x2f4146 },
	{ 0x22540, 0x2f4147 },
	{ 0x22543, 0x265255 },
	{ 0x22547, 0x265256 },
	{ 0x22548, 0x26566c },
	{ 0x2254d, 0x253f2d },
	{ 0x2254e, 0x243d32 },
	{ 0x2254f, 0x265c66 },
	{ 0x22550, 0x265c63 },
	{ 0x22551, 0x254566 },
	{ 0x22552, 0x265c62 },
	{ 0x22553, 0x24433e },
	{ 0x22554, 0x254565 },
	{ 0x22555, 0x244341 },
	{ 0x22556, 0x244340 },
	{ 0x22557, 0x265c61 },
	{ 0x22558, 0x254568 },
	{ 0x22559, 0x25456a },
	{ 0x2255a, 0x254564 },
	{ 0x2255b, 0x265c68 },
	{ 0x2255c, 0x265c69 },
	{ 0x2255d, 0x265c6a },
	{ 0x2255e, 0x254567 },
	{ 0x2255f, 0x265c64 },
	{ 0x22560, 0x2f4771 },
	{ 0x22561, 0x2f4772 },
	{ 0x22562, 0x2f4773 },
	{ 0x22563, 0x2f4774 },
	{ 0x22564, 0x2f4775 },
	{ 0x22567, 0x265c65 },
	{ 0x2256a, 0x244964 },
	{ 0x2256b, 0x254d24 },
	{ 0x2256c, 0x255b48 },
	{ 0x2256d, 0x244963 },
	{ 0x2256e, 0x244962 },
	{ 0x2256f, 0x254d25 },
	{ 0x22570, 0x27226d },
	{ 0x22571, 0x27226f },
	{ 0x22573, 0x2f4e66 },
	{ 0x22574, 0x2f4e67 },
	{ 0x22576, 0x27226e },
	{ 0x22577, 0x272270 },
	{ 0x22579, 0x272d65 },
	{ 0x2257a, 0x255448 },
	{ 0x2257b, 0x25544a },
	{ 0x2257c, 0x272d67 },
	{ 0x2257e, 0x272d66 },
	{ 0x22581, 0x2f5444 },
	{ 0x22582, 0x2f5445 },
	{ 0x22583, 0x272d68 },
	{ 0x22584, 0x255449 },
	{ 0x22588, 0x255b47 },
	{ 0x22589, 0x273777 },
	{ 0x2258a, 0x245630 },
	{ 0x2258d, 0x2f5c5f },
	{ 0x2258e, 0x255b46 },
	{ 0x2258f, 0x256160 },
	{ 0x22590, 0x273f57 },
	{ 0x22591, 0x25615f },
	{ 0x22592, 0x273f58 },
	{ 0x22593, 0x2f5e5e },
	{ 0x22597, 0x256161 },
	{ 0x22598, 0x274673 },
	{ 0x22599, 0x274675 },
	{ 0x2259a, 0x274676 },
	{ 0x2259b, 0x274d22 },
	{ 0x2259c, 0x274674 },
	{ 0x2259d, 0x256c27 },
	{ 0x2259e, 0x24633e },
	{ 0x2259f, 0x24633d },
	{ 0x225a0, 0x2f652a },
	{ 0x225a2, 0x274d63 },
	{ 0x225a3, 0x275337 },
	{ 0x225a4, 0x256f7e },
	{ 0x225a5, 0x275772 },
	{ 0x225a6, 0x246a47 },
	{ 0x225a7, 0x257928 },
	{ 0x225a9, 0x252131 },
	{ 0x225aa, 0x262221 },
	{ 0x225ab, 0x24226f },
	{ 0x225ac, 0x25216c },
	{ 0x225ad, 0x262326 },
	{ 0x225b0, 0x2f224f },
	{ 0x225b2, 0x262475 },
	{ 0x225b3, 0x252263 },
	{ 0x225b4, 0x262760 },
	{ 0x225b5, 0x252269 },
	{ 0x225b6, 0x26275d },
	{ 0x225b7, 0x252264 },
	{ 0x225b8, 0x262473 },
	{ 0x225b9, 0x262474 },
	{ 0x225ba, 0x252265 },
	{ 0x225bb, 0x26275c },
	{ 0x225bd, 0x26275e },
	{ 0x225c1, 0x262761 },
	{ 0x225c3, 0x262472 },
	{ 0x225c7, 0x252268 },
	{ 0x225c8, 0x252437 },
	{ 0x225c9, 0x252439 },
	{ 0x225ca, 0x242645 },
	{ 0x225cb, 0x262766 },
	{ 0x225cc, 0x262764 },
	{ 0x225cd, 0x262b46 },
	{ 0x225ce, 0x262767 },
	{ 0x225d0, 0x262b40 },
	{ 0x225d1, 0x262762 },
	{ 0x225d2, 0x262763 },
	{ 0x225d3, 0x262b44 },
	{ 0x225d4, 0x262765 },
	{ 0x225d5, 0x262768 },
	{ 0x225d7, 0x23257e },
	{ 0x225d8, 0x262769 },
	{ 0x225db, 0x25243a },
	{ 0x225dc, 0x2f242e },
	{ 0x225dd, 0x2f242f },
	{ 0x225de, 0x2f2431 },
	{ 0x225df, 0x2f2432 },
	{ 0x225e0, 0x2f2434 },
	{ 0x225e1, 0x2f2435 },
	{ 0x225e2, 0x2f2436 },
	{ 0x225e3, 0x2f2677 },
	{ 0x225e4, 0x2f2678 },
	{ 0x225e5, 0x2f2679 },
	{ 0x225e6, 0x2f267a },
	{ 0x225e7, 0x2f267b },
	{ 0x225e8, 0x2f267d },
	{ 0x225e9, 0x2f267e },
	{ 0x225ea, 0x2f2721 },
	{ 0x225eb, 0x2f267c },
	{ 0x225ec, 0x262b45 },
	{ 0x225ee, 0x262b41 },
	{ 0x225f1, 0x262b42 },
	{ 0x225f2, 0x24242d },
	{ 0x225f5, 0x2f2430 },
	{ 0x225f9, 0x242644 },
	{ 0x225fa, 0x252634 },
	{ 0x225fb, 0x262b43 },
	{ 0x225ff, 0x242647 },
	{ 0x22600, 0x262b4c },
	{ 0x22601, 0x242947 },
	{ 0x22602, 0x26312f },
	{ 0x22603, 0x24264b },
	{ 0x22604, 0x262b4d },
	{ 0x22605, 0x263129 },
	{ 0x22606, 0x252635 },
	{ 0x22607, 0x26312c },
	{ 0x22608, 0x262b4f },
	{ 0x22609, 0x24264a },
	{ 0x2260a, 0x252637 },
	{ 0x2260b, 0x242938 },
	{ 0x2260c, 0x252636 },
	{ 0x2260d, 0x242943 },
	{ 0x2260e, 0x262b49 },
	{ 0x2260f, 0x252638 },
	{ 0x22610, 0x242651 },
	{ 0x22611, 0x242944 },
	{ 0x22612, 0x26312a },
	{ 0x22613, 0x26312b },
	{ 0x22614, 0x262b50 },
	{ 0x22615, 0x262b47 },
	{ 0x22616, 0x26312d },
	{ 0x2261a, 0x2f2675 },
	{ 0x2261d, 0x2f2722 },
	{ 0x2261e, 0x2f2a70 },
	{ 0x22620, 0x242946 },
	{ 0x22623, 0x26312e },
	{ 0x22626, 0x262b48 },
	{ 0x22627, 0x262b4a },
	{ 0x22628, 0x262b4e },
	{ 0x2262a, 0x262b4b },
	{ 0x2262b, 0x2f2a64 },
	{ 0x2262f, 0x2f2a5f },
	{ 0x22630, 0x2f2a62 },
	{ 0x22631, 0x2f2a65 },
	{ 0x22632, 0x2f2a68 },
	{ 0x22633, 0x2f2a6c },
	{ 0x22634, 0x26375b },
	{ 0x22635, 0x263759 },
	{ 0x22636, 0x263132 },
	{ 0x22637, 0x242949 },
	{ 0x22638, 0x252937 },
	{ 0x2263a, 0x242942 },
	{ 0x2263b, 0x242d29 },
	{ 0x2263c, 0x252d4e },
	{ 0x2263d, 0x252936 },
	{ 0x2263e, 0x263139 },
	{ 0x2263f, 0x263757 },
	{ 0x22640, 0x263133 },
	{ 0x22641, 0x242c7d },
	{ 0x22642, 0x252d4c },
	{ 0x22643, 0x263135 },
	{ 0x22644, 0x263753 },
	{ 0x22645, 0x242d21 },
	{ 0x22646, 0x263138 },
	{ 0x22647, 0x252934 },
	{ 0x22648, 0x242c7e },
	{ 0x22649, 0x26313a },
	{ 0x2264a, 0x263131 },
	{ 0x2264b, 0x263137 },
	{ 0x2264c, 0x263756 },
	{ 0x2264d, 0x263755 },
	{ 0x2264e, 0x242d2a },
	{ 0x22656, 0x263134 },
	{ 0x22657, 0x2f2a61 },
	{ 0x22658, 0x2f2a66 },
	{ 0x22659, 0x2f2a69 },
	{ 0x2265a, 0x2f2a6b },
	{ 0x2265b, 0x2f2a6d },
	{ 0x2265c, 0x2f2a6e },
	{ 0x2265d, 0x2f2a6f },
	{ 0x2265e, 0x2f2f46 },
	{ 0x2265f, 0x2f2f47 },
	{ 0x22660, 0x2f2f48 },
	{ 0x22661, 0x2f2f4a },
	{ 0x22662, 0x263752 },
	{ 0x22663, 0x2f2f44 },
	{ 0x22666, 0x263758 },
	{ 0x22668, 0x2f2a63 },
	{ 0x2266e, 0x252d4d },
	{ 0x22670, 0x263751 },
	{ 0x22671, 0x252d52 },
	{ 0x22672, 0x252d58 },
	{ 0x22673, 0x252d5b },
	{ 0x22674, 0x263f6d },
	{ 0x22675, 0x263763 },
	{ 0x22676, 0x263f6f },
	{ 0x22677, 0x263f6b },
	{ 0x22678, 0x263f70 },
	{ 0x22679, 0x263764 },
	{ 0x2267a, 0x252d55 },
	{ 0x2267b, 0x263f69 },
	{ 0x2267c, 0x242d2e },
	{ 0x2267d, 0x263f73 },
	{ 0x2267e, 0x252d56 },
	{ 0x2267f, 0x242d26 },
	{ 0x22680, 0x25325d },
	{ 0x22681, 0x252d51 },
	{ 0x22682, 0x252d5c },
	{ 0x22683, 0x263762 },
	{ 0x22684, 0x26375d },
	{ 0x22685, 0x253254 },
	{ 0x22686, 0x26375f },
	{ 0x22687, 0x263761 },
	{ 0x22688, 0x263f6c },
	{ 0x22689, 0x263760 },
	{ 0x2268a, 0x263f71 },
	{ 0x2268b, 0x242d27 },
	{ 0x2268c, 0x252d50 },
	{ 0x2268d, 0x26375c },
	{ 0x2268e, 0x253253 },
	{ 0x2268f, 0x263f72 },
	{ 0x22690, 0x263f74 },
	{ 0x22691, 0x253252 },
	{ 0x22697, 0x252d4f },
	{ 0x22699, 0x2f2f41 },
	{ 0x2269a, 0x2f2f42 },
	{ 0x2269b, 0x2f2f43 },
	{ 0x2269c, 0x2f2f49 },
	{ 0x2269d, 0x2f2f4b },
	{ 0x2269e, 0x2f345d },
	{ 0x2269f, 0x2f345f },
	{ 0x226a0, 0x2f3460 },
	{ 0x226a1, 0x2f3464 },
	{ 0x226a2, 0x2f3465 },
	{ 0x226a3, 0x2f3466 },
	{ 0x226a4, 0x2f3467 },
	{ 0x226a5, 0x2f3468 },
	{ 0x226a6, 0x263f6a },
	{ 0x226af, 0x263765 },
	{ 0x226b0, 0x263766 },
	{ 0x226ba, 0x252d54 },
	{ 0x226bb, 0x252d59 },
	{ 0x226c1, 0x24375a },
	{ 0x226c2, 0x264871 },
	{ 0x226c3, 0x24374d },
	{ 0x226c4, 0x253259 },
	{ 0x226c5, 0x263f7c },
	{ 0x226c6, 0x24374b },
	{ 0x226c7, 0x264873 },
	{ 0x226c8, 0x264869 },
	{ 0x226c9, 0x253855 },
	{ 0x226ca, 0x263f7e },
	{ 0x226cb, 0x264872 },
	{ 0x226cc, 0x264022 },
	{ 0x226cd, 0x243165 },
	{ 0x226ce, 0x252d53 },
	{ 0x226cf, 0x24316d },
	{ 0x226d0, 0x263f77 },
	{ 0x226d1, 0x26486e },
	{ 0x226d2, 0x243161 },
	{ 0x226d3, 0x25383f },
	{ 0x226d4, 0x253257 },
	{ 0x226d5, 0x25325a },
	{ 0x226d6, 0x24374c },
	{ 0x226d7, 0x263f79 },
	{ 0x226d8, 0x25325c },
	{ 0x226d9, 0x263f76 },
	{ 0x226da, 0x263f6e },
	{ 0x226db, 0x243169 },
	{ 0x226dc, 0x25383c },
	{ 0x226dd, 0x264870 },
	{ 0x226de, 0x25325e },
	{ 0x226df, 0x24315f },
	{ 0x226e0, 0x263f7d },
	{ 0x226e1, 0x263f7b },
	{ 0x226e2, 0x263f7a },
	{ 0x226e3, 0x264866 },
	{ 0x226e4, 0x26486c },
	{ 0x226e5, 0x25383e },
	{ 0x226e6, 0x253841 },
	{ 0x226e7, 0x264874 },
	{ 0x226e8, 0x253255 },
	{ 0x226e9, 0x26486b },
	{ 0x226ea, 0x264876 },
	{ 0x226eb, 0x264867 },
	{ 0x226ec, 0x264865 },
	{ 0x226ed, 0x263f75 },
	{ 0x226ee, 0x253840 },
	{ 0x226f0, 0x2f3461 },
	{ 0x226f7, 0x2f345e },
	{ 0x226f8, 0x2f3462 },
	{ 0x226f9, 0x2f3463 },
	{ 0x226fa, 0x2f3469 },
	{ 0x226fb, 0x2f346a },
	{ 0x226fc, 0x2f346b },
	{ 0x226fd, 0x2f346c },
	{ 0x226fe, 0x2f346d },
	{ 0x226ff, 0x2f346f },
	{ 0x22700, 0x2f3470 },
	{ 0x22701, 0x2f3472 },
	{ 0x22702, 0x2f3a72 },
	{ 0x22703, 0x2f3a73 },
	{ 0x22704, 0x2f3a74 },
	{ 0x22705, 0x2f3a75 },
	{ 0x22706, 0x2f3a76 },
	{ 0x22707, 0x2f3a77 },
	{ 0x22708, 0x2f3a79 },
	{ 0x22709, 0x2f3a7a },
	{ 0x2270a, 0x2f3a7c },
	{ 0x2270b, 0x2f3a7d },
	{ 0x2270c, 0x2f3a7e },
	{ 0x2270d, 0x2f3b21 },
	{ 0x2270e, 0x2f3b22 },
	{ 0x2270f, 0x2f3b25 },
	{ 0x22710, 0x2f3b29 },
	{ 0x22711, 0x2f3b2a },
	{ 0x22712, 0x2f3b2c },
	{ 0x22713, 0x2f3b2e },
	{ 0x22716, 0x264868 },
	{ 0x22717, 0x253256 },
	{ 0x2271a, 0x263f78 },
	{ 0x2271b, 0x2f3b27 },
	{ 0x2271f, 0x2f346e },
	{ 0x22723, 0x264924 },
	{ 0x22724, 0x26486d },
	{ 0x22725, 0x264021 },
	{ 0x22727, 0x2f3b24 },
	{ 0x22728, 0x243d3f },
	{ 0x22729, 0x25384a },
	{ 0x2272a, 0x25384d },
	{ 0x2272b, 0x253852 },
	{ 0x2272c, 0x24374f },
	{ 0x2272d, 0x243757 },
	{ 0x2272e, 0x243751 },
	{ 0x2272f, 0x26525d },
	{ 0x22730, 0x264923 },
	{ 0x22731, 0x253850 },
	{ 0x22732, 0x264922 },
	{ 0x22733, 0x243753 },
	{ 0x22734, 0x253856 },
	{ 0x22735, 0x253858 },
	{ 0x22736, 0x253843 },
	{ 0x22737, 0x265261 },
	{ 0x22738, 0x25385a },
	{ 0x22739, 0x253f33 },
	{ 0x2273a, 0x24375b },
	{ 0x2273b, 0x253853 },
	{ 0x2273c, 0x264921 },
	{ 0x2273d, 0x253846 },
	{ 0x2273e, 0x26487b },
	{ 0x2273f, 0x253f34 },
	{ 0x22740, 0x253844 },
	{ 0x22741, 0x253854 },
	{ 0x22742, 0x25325f },
	{ 0x22743, 0x265258 },
	{ 0x22744, 0x253847 },
	{ 0x22745, 0x243d36 },
	{ 0x22746, 0x243758 },
	{ 0x22747, 0x253859 },
	{ 0x22748, 0x253851 },
	{ 0x22749, 0x25384b },
	{ 0x2274a, 0x253f31 },
	{ 0x2274b, 0x264877 },
	{ 0x2274c, 0x25384f },
	{ 0x2274d, 0x25383d },
	{ 0x2274e, 0x26487e },
	{ 0x2274f, 0x265262 },
	{ 0x22750, 0x265263 },
	{ 0x22751, 0x26525a },
	{ 0x22752, 0x26487d },
	{ 0x22753, 0x253857 },
	{ 0x22754, 0x26525e },
	{ 0x22755, 0x265260 },
	{ 0x22757, 0x253f2f },
	{ 0x2275d, 0x243d40 },
	{ 0x2275e, 0x243752 },
	{ 0x2275f, 0x253849 },
	{ 0x22760, 0x264879 },
	{ 0x22761, 0x2f3a71 },
	{ 0x22762, 0x2f3a7b },
	{ 0x22763, 0x2f3b23 },
	{ 0x22764, 0x2f3b28 },
	{ 0x22765, 0x2f3b2d },
	{ 0x22766, 0x2f4148 },
	{ 0x22767, 0x2f414e },
	{ 0x22768, 0x2f4150 },
	{ 0x22769, 0x2f4151 },
	{ 0x2276a, 0x2f4152 },
	{ 0x2276d, 0x26525c },
	{ 0x2276e, 0x26525f },
	{ 0x22772, 0x26525b },
	{ 0x2277d, 0x26487a },
	{ 0x22781, 0x2f3b2b },
	{ 0x22787, 0x25384e },
	{ 0x22789, 0x253f2e },
	{ 0x2278a, 0x25384c },
	{ 0x2278c, 0x2f3471 },
	{ 0x2278d, 0x2f477d },
	{ 0x2278e, 0x253f3c },
	{ 0x2278f, 0x253f36 },
	{ 0x22790, 0x253f35 },
	{ 0x22791, 0x26526b },
	{ 0x22792, 0x254d26 },
	{ 0x22793, 0x253f45 },
	{ 0x22794, 0x265c6f },
	{ 0x22795, 0x253f39 },
	{ 0x22796, 0x253f3f },
	{ 0x22797, 0x253f44 },
	{ 0x22798, 0x265c74 },
	{ 0x22799, 0x26526f },
	{ 0x2279a, 0x25456b },
	{ 0x2279c, 0x253f3b },
	{ 0x2279d, 0x265c6c },
	{ 0x2279e, 0x265265 },
	{ 0x2279f, 0x253f38 },
	{ 0x227a0, 0x253f3d },
	{ 0x227a1, 0x253f3a },
	{ 0x227a2, 0x265259 },
	{ 0x227a3, 0x24496e },
	{ 0x227a4, 0x265c76 },
	{ 0x227a5, 0x265c79 },
	{ 0x227a6, 0x253f43 },
	{ 0x227a7, 0x265268 },
	{ 0x227a8, 0x265c72 },
	{ 0x227a9, 0x24434f },
	{ 0x227aa, 0x265c78 },
	{ 0x227ab, 0x265c77 },
	{ 0x227ac, 0x253f41 },
	{ 0x227ad, 0x25456d },
	{ 0x227ae, 0x253f3e },
	{ 0x227af, 0x265c71 },
	{ 0x227b0, 0x265c6e },
	{ 0x227b1, 0x265c6d },
	{ 0x227b2, 0x253f37 },
	{ 0x227b3, 0x265267 },
	{ 0x227b6, 0x26526d },
	{ 0x227b7, 0x2f414a },
	{ 0x227b8, 0x2f414b },
	{ 0x227b9, 0x2f414c },
	{ 0x227ba, 0x2f414d },
	{ 0x227bb, 0x2f414f },
	{ 0x227bc, 0x2f4153 },
	{ 0x227bd, 0x2f4776 },
	{ 0x227be, 0x2f4777 },
	{ 0x227bf, 0x2f4779 },
	{ 0x227c0, 0x2f477a },
	{ 0x227c1, 0x2f4825 },
	{ 0x227c2, 0x2f4828 },
	{ 0x227c3, 0x265c70 },
	{ 0x227c4, 0x265c75 },
	{ 0x227ca, 0x253f40 },
	{ 0x227cb, 0x2f4149 },
	{ 0x227dc, 0x265c73 },
	{ 0x227dd, 0x26526e },
	{ 0x227e0, 0x265d23 },
	{ 0x227e1, 0x265d27 },
	{ 0x227e2, 0x244345 },
	{ 0x227e3, 0x244344 },
	{ 0x227e4, 0x254d27 },
	{ 0x227e6, 0x265c7c },
	{ 0x227e7, 0x254577 },
	{ 0x227e8, 0x254576 },
	{ 0x227e9, 0x254573 },
	{ 0x227ea, 0x243d35 },
	{ 0x227eb, 0x265c7b },
	{ 0x227ec, 0x272272 },
	{ 0x227ee, 0x272275 },
	{ 0x227ef, 0x254d29 },
	{ 0x227f0, 0x254570 },
	{ 0x227f1, 0x25456f },
	{ 0x227f2, 0x25456c },
	{ 0x227f3, 0x254571 },
	{ 0x227f4, 0x254572 },
	{ 0x227f5, 0x254579 },
	{ 0x227f6, 0x265d25 },
	{ 0x227f7, 0x265c7d },
	{ 0x227f8, 0x265c7e },
	{ 0x227f9, 0x26526a },
	{ 0x227fa, 0x265d22 },
	{ 0x227fb, 0x272274 },
	{ 0x227fc, 0x265d21 },
	{ 0x227fd, 0x272277 },
	{ 0x227fe, 0x254574 },
	{ 0x227ff, 0x254578 },
	{ 0x22800, 0x272d6a },
	{ 0x2280a, 0x244353 },
	{ 0x2280b, 0x2f4778 },
	{ 0x2280c, 0x2f477c },
	{ 0x2280d, 0x2f477e },
	{ 0x2280e, 0x2f4821 },
	{ 0x2280f, 0x2f4823 },
	{ 0x22810, 0x2f4824 },
	{ 0x22811, 0x2f4826 },
	{ 0x22812, 0x2f4e69 },
	{ 0x22813, 0x2f4e6a },
	{ 0x22814, 0x2f4e6b },
	{ 0x22815, 0x2f4e6c },
	{ 0x22816, 0x2f4e6d },
	{ 0x22817, 0x2f4e6e },
	{ 0x22818, 0x2f4e6f },
	{ 0x22819, 0x2f4e73 },
	{ 0x2281a, 0x2f4e75 },
	{ 0x2281c, 0x272273 },
	{ 0x2281e, 0x272278 },
	{ 0x2281f, 0x265c6b },
	{ 0x22820, 0x25456e },
	{ 0x22821, 0x265c7a },
	{ 0x2282c, 0x254d28 },
	{ 0x2282e, 0x254575 },
	{ 0x22831, 0x272d71 },
	{ 0x22832, 0x244966 },
	{ 0x22833, 0x244352 },
	{ 0x22834, 0x272d6b },
	{ 0x22835, 0x244971 },
	{ 0x22836, 0x272d6d },
	{ 0x22837, 0x254d2f },
	{ 0x22838, 0x272d73 },
	{ 0x22839, 0x24496a },
	{ 0x2283a, 0x254d2e },
	{ 0x2283b, 0x272279 },
	{ 0x2283c, 0x254d33 },
	{ 0x2283d, 0x244972 },
	{ 0x2283e, 0x272d75 },
	{ 0x2283f, 0x253845 },
	{ 0x22840, 0x254d32 },
	{ 0x22841, 0x254d35 },
	{ 0x22842, 0x245035 },
	{ 0x22843, 0x245036 },
	{ 0x22844, 0x272321 },
	{ 0x22845, 0x254d34 },
	{ 0x22846, 0x27377c },
	{ 0x22847, 0x254d30 },
	{ 0x22848, 0x25544e },
	{ 0x22849, 0x245634 },
	{ 0x2284a, 0x27227a },
	{ 0x2284b, 0x272322 },
	{ 0x2284e, 0x255454 },
	{ 0x2284f, 0x254d2b },
	{ 0x22850, 0x254d2d },
	{ 0x22851, 0x25544d },
	{ 0x22852, 0x254d2c },
	{ 0x22853, 0x272e22 },
	{ 0x22854, 0x272d77 },
	{ 0x22855, 0x272d76 },
	{ 0x22856, 0x27227e },
	{ 0x22857, 0x24503c },
	{ 0x22858, 0x272d70 },
	{ 0x22859, 0x272d6f },
	{ 0x2285e, 0x2f4822 },
	{ 0x22861, 0x2f4e70 },
	{ 0x22862, 0x272d72 },
	{ 0x22864, 0x254d31 },
	{ 0x22865, 0x272d6c },
	{ 0x22866, 0x2f4e71 },
	{ 0x22867, 0x2f4e72 },
	{ 0x22868, 0x2f4e74 },
	{ 0x22869, 0x2f4e76 },
	{ 0x2286a, 0x2f5447 },
	{ 0x2286b, 0x2f5448 },
	{ 0x2286c, 0x2f544a },
	{ 0x2286d, 0x2f544b },
	{ 0x2286e, 0x2f5451 },
	{ 0x2286f, 0x2f5453 },
	{ 0x22873, 0x272d74 },
	{ 0x22874, 0x25544b },
	{ 0x22878, 0x273050 },
	{ 0x2287d, 0x27227d },
	{ 0x2287e, 0x272571 },
	{ 0x2287f, 0x244970 },
	{ 0x2288c, 0x25544c },
	{ 0x2288d, 0x25544f },
	{ 0x2288f, 0x2f4e68 },
	{ 0x22891, 0x2f544f },
	{ 0x22892, 0x255450 },
	{ 0x22893, 0x255452 },
	{ 0x22894, 0x272d7b },
	{ 0x22895, 0x272d78 },
	{ 0x22896, 0x255455 },
	{ 0x22897, 0x255456 },
	{ 0x22898, 0x255451 },
	{ 0x22899, 0x272d7e },
	{ 0x2289a, 0x272d7c },
	{ 0x2289b, 0x272d7d },
	{ 0x2289c, 0x255457 },
	{ 0x2289d, 0x24503d },
	{ 0x2289e, 0x255b49 },
	{ 0x2289f, 0x272e21 },
	{ 0x228a0, 0x27377b },
	{ 0x228a1, 0x27377d },
	{ 0x228a2, 0x27377a },
	{ 0x228a3, 0x273821 },
	{ 0x228a4, 0x255b4b },
	{ 0x228a5, 0x272d7a },
	{ 0x228a6, 0x273779 },
	{ 0x228a7, 0x272d6e },
	{ 0x228ae, 0x2f544d },
	{ 0x228b0, 0x255453 },
	{ 0x228b1, 0x273822 },
	{ 0x228b2, 0x2f5449 },
	{ 0x228b3, 0x2f544e },
	{ 0x228b4, 0x2f5452 },
	{ 0x228b5, 0x2f5a25 },
	{ 0x228b6, 0x2f5a26 },
	{ 0x228b7, 0x2f5a2e },
	{ 0x228c1, 0x2f5a27 },
	{ 0x228c9, 0x255b4a },
	{ 0x228ca, 0x255458 },
	{ 0x228cb, 0x2f5a2a },
	{ 0x228cc, 0x2f544c },
	{ 0x228cd, 0x273778 },
	{ 0x228ce, 0x255b51 },
	{ 0x228cf, 0x245635 },
	{ 0x228d0, 0x245631 },
	{ 0x228d1, 0x245b2a },
	{ 0x228d2, 0x255b4e },
	{ 0x228d3, 0x256164 },
	{ 0x228d4, 0x256162 },
	{ 0x228d5, 0x273f5b },
	{ 0x228d6, 0x273826 },
	{ 0x228d8, 0x245b26 },
	{ 0x228d9, 0x255b4d },
	{ 0x228da, 0x255b4f },
	{ 0x228db, 0x273823 },
	{ 0x228dc, 0x273825 },
	{ 0x228dd, 0x255b50 },
	{ 0x228de, 0x256163 },
	{ 0x228df, 0x273f5a },
	{ 0x228e0, 0x256165 },
	{ 0x228e1, 0x273f59 },
	{ 0x228e2, 0x272276 },
	{ 0x228e8, 0x2f5a2b },
	{ 0x228e9, 0x2f5a2d },
	{ 0x228ea, 0x2f5e5f },
	{ 0x228eb, 0x2f5e60 },
	{ 0x228ec, 0x2f5e62 },
	{ 0x228ed, 0x2f5e63 },
	{ 0x228ee, 0x2f5e65 },
	{ 0x228ef, 0x2f5e66 },
	{ 0x228f0, 0x2f5e67 },
	{ 0x228f2, 0x273f5c },
	{ 0x228f6, 0x273824 },
	{ 0x228f7, 0x2f5a28 },
	{ 0x228fb, 0x245b27 },
	{ 0x228fc, 0x255b52 },
	{ 0x228fd, 0x274679 },
	{ 0x228fe, 0x273f5d },
	{ 0x228ff, 0x256168 },
	{ 0x22900, 0x274d64 },
	{ 0x22901, 0x245f63 },
	{ 0x22902, 0x245f62 },
	{ 0x22903, 0x27467c },
	{ 0x22904, 0x256169 },
	{ 0x22905, 0x274d67 },
	{ 0x22906, 0x245b28 },
	{ 0x22907, 0x25616a },
	{ 0x22908, 0x274725 },
	{ 0x22909, 0x274721 },
	{ 0x2290a, 0x274678 },
	{ 0x2290b, 0x256167 },
	{ 0x2290c, 0x27467e },
	{ 0x2290e, 0x25676d },
	{ 0x2290f, 0x27467a },
	{ 0x22910, 0x256770 },
	{ 0x22911, 0x274677 },
	{ 0x22912, 0x274722 },
	{ 0x22913, 0x273f5e },
	{ 0x22915, 0x27467d },
	{ 0x22916, 0x25676e },
	{ 0x22917, 0x2f5e64 },
	{ 0x22918, 0x25676f },
	{ 0x22919, 0x27467b },
	{ 0x22924, 0x25676c },
	{ 0x22925, 0x2f6239 },
	{ 0x22926, 0x27472a },
	{ 0x22927, 0x246344 },
	{ 0x22928, 0x274727 },
	{ 0x22929, 0x256774 },
	{ 0x2292a, 0x274724 },
	{ 0x2292b, 0x256c2a },
	{ 0x2292c, 0x274729 },
	{ 0x2292d, 0x274726 },
	{ 0x2292e, 0x273f5f },
	{ 0x2292f, 0x256775 },
	{ 0x22930, 0x24633f },
	{ 0x22931, 0x256771 },
	{ 0x22932, 0x256c28 },
	{ 0x22933, 0x27472b },
	{ 0x22934, 0x274723 },
	{ 0x22935, 0x274d65 },
	{ 0x22936, 0x256777 },
	{ 0x2293a, 0x2f623a },
	{ 0x2293b, 0x2f6238 },
	{ 0x2293c, 0x2f623b },
	{ 0x2293d, 0x2f623c },
	{ 0x2293e, 0x2f623d },
	{ 0x22941, 0x274d66 },
	{ 0x22943, 0x256166 },
	{ 0x22944, 0x256772 },
	{ 0x2294a, 0x2f652b },
	{ 0x2294b, 0x256776 },
	{ 0x2294c, 0x256c29 },
	{ 0x2294d, 0x275339 },
	{ 0x2294e, 0x274d6a },
	{ 0x2294f, 0x246341 },
	{ 0x22950, 0x274d69 },
	{ 0x22951, 0x246345 },
	{ 0x22952, 0x275338 },
	{ 0x22953, 0x274d6b },
	{ 0x22954, 0x2f6755 },
	{ 0x22957, 0x275b4f },
	{ 0x22958, 0x24663e },
	{ 0x2295a, 0x256c2b },
	{ 0x2295b, 0x275773 },
	{ 0x2295c, 0x275774 },
	{ 0x2295d, 0x275775 },
	{ 0x2295e, 0x27533b },
	{ 0x2295f, 0x27533a },
	{ 0x22961, 0x27533c },
	{ 0x22964, 0x2f6942 },
	{ 0x22965, 0x275776 },
	{ 0x22966, 0x275b50 },
	{ 0x22967, 0x275b52 },
	{ 0x22968, 0x275b53 },
	{ 0x22969, 0x275b51 },
	{ 0x2296b, 0x2f6a50 },
	{ 0x2296c, 0x2f6941 },
	{ 0x2296d, 0x2f6a51 },
	{ 0x2296e, 0x2f6a52 },
	{ 0x2296f, 0x275b55 },
	{ 0x22970, 0x25775a },
	{ 0x22971, 0x275b54 },
	{ 0x22972, 0x275e65 },
	{ 0x22978, 0x2f6a53 },
	{ 0x22979, 0x2f6b47 },
	{ 0x2297a, 0x2f6b48 },
	{ 0x2297b, 0x25775b },
	{ 0x2297c, 0x275e66 },
	{ 0x2297d, 0x257929 },
	{ 0x2297e, 0x275e67 },
	{ 0x2297f, 0x2f6c28 },
	{ 0x22981, 0x2f6c29 },
	{ 0x22985, 0x246d72 },
	{ 0x22986, 0x2f6c7c },
	{ 0x22987, 0x2f6c7d },
	{ 0x22988, 0x257b3e },
	{ 0x22989, 0x257b60 },
	{ 0x2298b, 0x2f6d34 },
	{ 0x2298e, 0x25226a },
	{ 0x2298f, 0x242272 },
	{ 0x22990, 0x262476 },
	{ 0x22993, 0x26276b },
	{ 0x22994, 0x25243b },
	{ 0x22995, 0x26276a },
	{ 0x22996, 0x26276d },
	{ 0x22999, 0x26276c },
	{ 0x2299a, 0x242652 },
	{ 0x2299b, 0x262b51 },
	{ 0x2299c, 0x262b58 },
	{ 0x2299d, 0x262b54 },
	{ 0x2299e, 0x262b56 },
	{ 0x2299f, 0x242653 },
	{ 0x229a0, 0x262b55 },
	{ 0x229a1, 0x262b53 },
	{ 0x229a2, 0x262b57 },
	{ 0x229a3, 0x2f2724 },
	{ 0x229a4, 0x2f2723 },
	{ 0x229a6, 0x26313d },
	{ 0x229a7, 0x26313b },
	{ 0x229a8, 0x26313e },
	{ 0x229a9, 0x263140 },
	{ 0x229aa, 0x24294c },
	{ 0x229ab, 0x263141 },
	{ 0x229ac, 0x26313f },
	{ 0x229ae, 0x2f2a71 },
	{ 0x229af, 0x2f2a72 },
	{ 0x229b6, 0x26313c },
	{ 0x229b7, 0x263767 },
	{ 0x229b8, 0x252d5f },
	{ 0x229b9, 0x263769 },
	{ 0x229ba, 0x252d5e },
	{ 0x229bb, 0x263768 },
	{ 0x229bf, 0x253261 },
	{ 0x229c0, 0x24316f },
	{ 0x229c1, 0x264025 },
	{ 0x229c2, 0x2f3473 },
	{ 0x229c3, 0x2f3474 },
	{ 0x229c6, 0x264024 },
	{ 0x229c7, 0x253260 },
	{ 0x229c8, 0x264928 },
	{ 0x229c9, 0x264927 },
	{ 0x229ca, 0x264925 },
	{ 0x229cb, 0x264926 },
	{ 0x229cc, 0x24375c },
	{ 0x229cd, 0x264929 },
	{ 0x229ce, 0x2f3b2f },
	{ 0x229d1, 0x25385b },
	{ 0x229d2, 0x25385c },
	{ 0x229d3, 0x2f3476 },
	{ 0x229d4, 0x243d44 },
	{ 0x229d5, 0x265271 },
	{ 0x229d6, 0x253f47 },
	{ 0x229d8, 0x253f49 },
	{ 0x229db, 0x2f4155 },
	{ 0x229dc, 0x243d41 },
	{ 0x229df, 0x265270 },
	{ 0x229e0, 0x253f48 },
	{ 0x229e2, 0x265d29 },
	{ 0x229e4, 0x265d2a },
	{ 0x229e5, 0x25457a },
	{ 0x229e6, 0x25457c },
	{ 0x229e7, 0x25457b },
	{ 0x229e8, 0x272324 },
	{ 0x229e9, 0x25457d },
	{ 0x229ea, 0x2f4829 },
	{ 0x229eb, 0x2f482a },
	{ 0x229ec, 0x265d28 },
	{ 0x229f3, 0x254d36 },
	{ 0x229f4, 0x244973 },
	{ 0x229f5, 0x244974 },
	{ 0x229f6, 0x272328 },
	{ 0x229f7, 0x272327 },
	{ 0x229f8, 0x272325 },
	{ 0x229f9, 0x265d2b },
	{ 0x229fa, 0x272323 },
	{ 0x229fd, 0x2f4e7b },
	{ 0x229fe, 0x272329 },
	{ 0x229ff, 0x272326 },
	{ 0x22a04, 0x2f4e77 },
	{ 0x22a05, 0x2f4e78 },
	{ 0x22a06, 0x2f4e7a },
	{ 0x22a07, 0x27232a },
	{ 0x22a08, 0x272e2a },
	{ 0x22a09, 0x272e25 },
	{ 0x22a0a, 0x272e24 },
	{ 0x22a0b, 0x272e27 },
	{ 0x22a0c, 0x272e26 },
	{ 0x22a0d, 0x272e29 },
	{ 0x22a0e, 0x272e28 },
	{ 0x22a10, 0x272c63 },
	{ 0x22a11, 0x273170 },
	{ 0x22a12, 0x272e23 },
	{ 0x22a13, 0x273827 },
	{ 0x22a14, 0x255b53 },
	{ 0x22a15, 0x2f5a2f },
	{ 0x22a19, 0x273f60 },
	{ 0x22a1a, 0x27472d },
	{ 0x22a1b, 0x245f65 },
	{ 0x22a1e, 0x27472e },
	{ 0x22a1f, 0x256c2c },
	{ 0x22a20, 0x2f652c },
	{ 0x22a21, 0x257021 },
	{ 0x22a23, 0x27533d },
	{ 0x22a24, 0x262327 },
	{ 0x22a25, 0x25216d },
	{ 0x22a26, 0x262477 },
	{ 0x22a29, 0x262478 },
	{ 0x22a2a, 0x242434 },
	{ 0x22a2c, 0x2f2437 },
	{ 0x22a2d, 0x2f2438 },
	{ 0x22a2f, 0x252639 },
	{ 0x22a32, 0x262b59 },
	{ 0x22a34, 0x262b5a },
	{ 0x22a37, 0x263143 },
	{ 0x22a38, 0x263142 },
	{ 0x22a39, 0x263144 },
	{ 0x22a3a, 0x252939 },
	{ 0x22a3b, 0x2f2a73 },
	{ 0x22a3c, 0x2f2a74 },
	{ 0x22a3d, 0x2f2a75 },
	{ 0x22a3e, 0x263146 },
	{ 0x22a41, 0x263145 },
	{ 0x22a44, 0x252938 },
	{ 0x22a45, 0x26376c },
	{ 0x22a46, 0x26376a },
	{ 0x22a47, 0x26376b },
	{ 0x22a48, 0x252d61 },
	{ 0x22a4b, 0x252d60 },
	{ 0x22a4d, 0x264026 },
	{ 0x22a4e, 0x2f3477 },
	{ 0x22a51, 0x25385d },
	{ 0x22a52, 0x25385f },
	{ 0x22a53, 0x253860 },
	{ 0x22a55, 0x25385e },
	{ 0x22a56, 0x253f4a },
	{ 0x22a58, 0x25457e },
	{ 0x22a59, 0x244355 },
	{ 0x22a5d, 0x27232b },
	{ 0x22a60, 0x255b54 },
	{ 0x22a62, 0x257022 },
	{ 0x22a65, 0x262328 },
	{ 0x22a66, 0x25216e },
	{ 0x22a68, 0x262329 },
	{ 0x22a69, 0x26232a },
	{ 0x22a6b, 0x25216f },
	{ 0x22a6c, 0x25226c },
	{ 0x22a6d, 0x242276 },
	{ 0x22a6e, 0x262479 },
	{ 0x22a70, 0x252272 },
	{ 0x22a71, 0x252270 },
	{ 0x22a72, 0x25226f },
	{ 0x22a73, 0x25226b },
	{ 0x22a74, 0x25226d },
	{ 0x22a75, 0x2f2250 },
	{ 0x22a76, 0x2f2252 },
	{ 0x22a82, 0x252271 },
	{ 0x22a83, 0x242437 },
	{ 0x22a84, 0x262773 },
	{ 0x22a85, 0x262776 },
	{ 0x22a86, 0x262775 },
	{ 0x22a87, 0x242657 },
	{ 0x22a88, 0x25243d },
	{ 0x22a89, 0x26276f },
	{ 0x22a8a, 0x242438 },
	{ 0x22a8b, 0x242435 },
	{ 0x22a8c, 0x262777 },
	{ 0x22a8d, 0x25243e },
	{ 0x22a8e, 0x24243b },
	{ 0x22a8f, 0x262772 },
	{ 0x22a90, 0x262b5d },
	{ 0x22a91, 0x262771 },
	{ 0x22a92, 0x262b65 },
	{ 0x22a93, 0x262b5b },
	{ 0x22a94, 0x262770 },
	{ 0x22a95, 0x25243c },
	{ 0x22a96, 0x262b5c },
	{ 0x22a97, 0x262774 },
	{ 0x22a9c, 0x2f243b },
	{ 0x22a9d, 0x2f243c },
	{ 0x22a9e, 0x2f243d },
	{ 0x22a9f, 0x2f243e },
	{ 0x22aa0, 0x2f243f },
	{ 0x22aa1, 0x2f2440 },
	{ 0x22aa2, 0x2f2441 },
	{ 0x22aa3, 0x2f2443 },
	{ 0x22aa4, 0x2f2444 },
	{ 0x22aa7, 0x2f2445 },
	{ 0x22aa9, 0x2f243a },
	{ 0x22ab4, 0x262b5e },
	{ 0x22ab5, 0x262b5f },
	{ 0x22ab6, 0x262b61 },
	{ 0x22ab7, 0x25263b },
	{ 0x22ab8, 0x25293a },
	{ 0x22aba, 0x262b64 },
	{ 0x22abb, 0x263148 },
	{ 0x22abc, 0x25263d },
	{ 0x22abd, 0x26314a },
	{ 0x22abe, 0x25263c },
	{ 0x22abf, 0x263149 },
	{ 0x22ac0, 0x263147 },
	{ 0x22ac2, 0x262b62 },
	{ 0x22ac6, 0x2f2726 },
	{ 0x22ac7, 0x2f2727 },
	{ 0x22ac8, 0x2f2728 },
	{ 0x22ac9, 0x2f2729 },
	{ 0x22aca, 0x2f272a },
	{ 0x22acb, 0x2f272b },
	{ 0x22acc, 0x2f272c },
	{ 0x22acd, 0x2f272d },
	{ 0x22ace, 0x2f272f },
	{ 0x22ad4, 0x2f2725 },
	{ 0x22ae2, 0x25263e },
	{ 0x22ae4, 0x263152 },
	{ 0x22ae5, 0x263154 },
	{ 0x22ae6, 0x242958 },
	{ 0x22ae7, 0x24294f },
	{ 0x22ae8, 0x242950 },
	{ 0x22ae9, 0x263153 },
	{ 0x22aea, 0x26376d },
	{ 0x22aeb, 0x25293f },
	{ 0x22aec, 0x252942 },
	{ 0x22aed, 0x252941 },
	{ 0x22aee, 0x26314d },
	{ 0x22aef, 0x252947 },
	{ 0x22af0, 0x242d34 },
	{ 0x22af1, 0x24295c },
	{ 0x22af2, 0x25293e },
	{ 0x22af3, 0x25293d },
	{ 0x22af4, 0x252d63 },
	{ 0x22af5, 0x242953 },
	{ 0x22af6, 0x26376e },
	{ 0x22af7, 0x252948 },
	{ 0x22af8, 0x24295a },
	{ 0x22af9, 0x263150 },
	{ 0x22afa, 0x252940 },
	{ 0x22afb, 0x252944 },
	{ 0x22afc, 0x26314e },
	{ 0x22afd, 0x263156 },
	{ 0x22afe, 0x26314b },
	{ 0x22aff, 0x252943 },
	{ 0x22b00, 0x25293c },
	{ 0x22b03, 0x263155 },
	{ 0x22b06, 0x263151 },
	{ 0x22b07, 0x2f2a76 },
	{ 0x22b08, 0x2f2a77 },
	{ 0x22b09, 0x2f2a78 },
	{ 0x22b0a, 0x2f2a79 },
	{ 0x22b0b, 0x2f2a7a },
	{ 0x22b0c, 0x2f2a7b },
	{ 0x22b0d, 0x2f2a7c },
	{ 0x22b0e, 0x2f2a7d },
	{ 0x22b0f, 0x2f2a7e },
	{ 0x22b10, 0x2f2b21 },
	{ 0x22b11, 0x2f2b23 },
	{ 0x22b12, 0x2f2b24 },
	{ 0x22b13, 0x2f2b25 },
	{ 0x22b14, 0x2f2b26 },
	{ 0x22b15, 0x2f2b27 },
	{ 0x22b16, 0x2f2b28 },
	{ 0x22b17, 0x2f2b29 },
	{ 0x22b18, 0x2f2b2a },
	{ 0x22b19, 0x2f2f53 },
	{ 0x22b1a, 0x2f2f5c },
	{ 0x22b1b, 0x2f2f61 },
	{ 0x22b1e, 0x26314c },
	{ 0x22b22, 0x2f2b22 },
	{ 0x22b2a, 0x25293b },
	{ 0x22b2b, 0x252d62 },
	{ 0x22b2c, 0x252d64 },
	{ 0x22b2f, 0x242d3d },
	{ 0x22b30, 0x263775 },
	{ 0x22b31, 0x242d38 },
	{ 0x22b32, 0x252d6d },
	{ 0x22b33, 0x252d6b },
	{ 0x22b34, 0x242d39 },
	{ 0x22b35, 0x242957 },
	{ 0x22b36, 0x242d35 },
	{ 0x22b37, 0x252d6a },
	{ 0x22b38, 0x26377b },
	{ 0x22b39, 0x263770 },
	{ 0x22b3a, 0x26377d },
	{ 0x22b3b, 0x263773 },
	{ 0x22b3c, 0x252d69 },
	{ 0x22b3d, 0x263772 },
	{ 0x22b3e, 0x263777 },
	{ 0x22b3f, 0x242d36 },
	{ 0x22b40, 0x263778 },
	{ 0x22b41, 0x252d6c },
	{ 0x22b42, 0x252d65 },
	{ 0x22b43, 0x242d37 },
	{ 0x22b44, 0x252d67 },
	{ 0x22b45, 0x252d68 },
	{ 0x22b46, 0x242d3a },
	{ 0x22b47, 0x26377a },
	{ 0x22b48, 0x252d66 },
	{ 0x22b49, 0x263157 },
	{ 0x22b4a, 0x263776 },
	{ 0x22b4b, 0x264027 },
	{ 0x22b4c, 0x263779 },
	{ 0x22b4d, 0x263774 },
	{ 0x22b4e, 0x252946 },
	{ 0x22b52, 0x26377c },
	{ 0x22b53, 0x26377e },
	{ 0x22b54, 0x2f2f4c },
	{ 0x22b55, 0x2f2f4d },
	{ 0x22b56, 0x2f2f4e },
	{ 0x22b57, 0x2f2f4f },
	{ 0x22b58, 0x2f2f50 },
	{ 0x22b59, 0x2f2f51 },
	{ 0x22b5a, 0x2f2f52 },
	{ 0x22b5b, 0x2f2f55 },
	{ 0x22b5c, 0x2f2f56 },
	{ 0x22b5d, 0x2f2f57 },
	{ 0x22b5e, 0x2f2f5a },
	{ 0x22b5f, 0x2f2f5b },
	{ 0x22b60, 0x2f2f5d },
	{ 0x22b61, 0x2f2f5e },
	{ 0x22b62, 0x2f2f60 },
	{ 0x22b63, 0x2f2f62 },
	{ 0x22b64, 0x264028 },
	{ 0x22b66, 0x2f2f58 },
	{ 0x22b68, 0x26376f },
	{ 0x22b6a, 0x2f2f54 },
	{ 0x22b81, 0x243172 },
	{ 0x22b82, 0x243173 },
	{ 0x22b83, 0x24375e },
	{ 0x22b84, 0x253269 },
	{ 0x22b86, 0x264031 },
	{ 0x22b87, 0x252d6e },
	{ 0x22b88, 0x264037 },
	{ 0x22b89, 0x253263 },
	{ 0x22b8a, 0x243174 },
	{ 0x22b8b, 0x243222 },
	{ 0x22b8c, 0x243176 },
	{ 0x22b8d, 0x253262 },
	{ 0x22b8e, 0x24317d },
	{ 0x22b8f, 0x253861 },
	{ 0x22b90, 0x253264 },
	{ 0x22b91, 0x264034 },
	{ 0x22b92, 0x253267 },
	{ 0x22b93, 0x264035 },
	{ 0x22b94, 0x26402c },
	{ 0x22b95, 0x264029 },
	{ 0x22b96, 0x243224 },
	{ 0x22b97, 0x26492f },
	{ 0x22b98, 0x26492a },
	{ 0x22b99, 0x26402a },
	{ 0x22b9a, 0x253265 },
	{ 0x22b9c, 0x26492d },
	{ 0x22b9d, 0x24375d },
	{ 0x22b9e, 0x26402f },
	{ 0x22b9f, 0x26492c },
	{ 0x22ba0, 0x26492b },
	{ 0x22ba1, 0x253268 },
	{ 0x22ba2, 0x26402d },
	{ 0x22ba3, 0x26492e },
	{ 0x22ba4, 0x264033 },
	{ 0x22ba7, 0x264030 },
	{ 0x22ba8, 0x243175 },
	{ 0x22bae, 0x26402e },
	{ 0x22baf, 0x2f3478 },
	{ 0x22bb0, 0x2f3479 },
	{ 0x22bb1, 0x2f347a },
	{ 0x22bb2, 0x2f347b },
	{ 0x22bb3, 0x2f347c },
	{ 0x22bb4, 0x2f347e },
	{ 0x22bb5, 0x2f3522 },
	{ 0x22bb6, 0x2f3523 },
	{ 0x22bb7, 0x2f3524 },
	{ 0x22bb8, 0x2f3525 },
	{ 0x22bb9, 0x2f3526 },
	{ 0x22bba, 0x2f3527 },
	{ 0x22bbb, 0x2f3528 },
	{ 0x22bbc, 0x2f3529 },
	{ 0x22bbd, 0x2f352a },
	{ 0x22bbe, 0x2f352b },
	{ 0x22bbf, 0x2f352c },
	{ 0x22bc0, 0x2f352e },
	{ 0x22bc1, 0x2f352d },
	{ 0x22bc2, 0x2f352f },
	{ 0x22bc3, 0x2f3530 },
	{ 0x22bc4, 0x2f3b31 },
	{ 0x22bc6, 0x2f347d },
	{ 0x22bc8, 0x253266 },
	{ 0x22bcc, 0x243226 },
	{ 0x22be3, 0x2f3b41 },
	{ 0x22be9, 0x25386b },
	{ 0x22bea, 0x264934 },
	{ 0x22beb, 0x243769 },
	{ 0x22bec, 0x26493b },
	{ 0x22bed, 0x264936 },
	{ 0x22bee, 0x25386d },
	{ 0x22bef, 0x264941 },
	{ 0x22bf0, 0x253874 },
	{ 0x22bf1, 0x264931 },
	{ 0x22bf2, 0x243d51 },
	{ 0x22bf3, 0x243767 },
	{ 0x22bf4, 0x253862 },
	{ 0x22bf5, 0x25386a },
	{ 0x22bf6, 0x24375f },
	{ 0x22bf7, 0x253868 },
	{ 0x22bf8, 0x243763 },
	{ 0x22bf9, 0x253869 },
	{ 0x22bfa, 0x24376a },
	{ 0x22bfb, 0x253866 },
	{ 0x22bfc, 0x24376d },
	{ 0x22bfd, 0x25386f },
	{ 0x22bfe, 0x243766 },
	{ 0x22bff, 0x264942 },
	{ 0x22c00, 0x264943 },
	{ 0x22c01, 0x26493a },
	{ 0x22c02, 0x253871 },
	{ 0x22c03, 0x264933 },
	{ 0x22c04, 0x264946 },
	{ 0x22c05, 0x264937 },
	{ 0x22c06, 0x253870 },
	{ 0x22c07, 0x24376c },
	{ 0x22c08, 0x264947 },
	{ 0x22c09, 0x264932 },
	{ 0x22c0a, 0x25386c },
	{ 0x22c0b, 0x25386e },
	{ 0x22c0c, 0x264944 },
	{ 0x22c0d, 0x253864 },
	{ 0x22c0e, 0x26493c },
	{ 0x22c0f, 0x264945 },
	{ 0x22c10, 0x264940 },
	{ 0x22c11, 0x26494c },
	{ 0x22c12, 0x26493f },
	{ 0x22c13, 0x26494d },
	{ 0x22c14, 0x264948 },
	{ 0x22c15, 0x264939 },
	{ 0x22c16, 0x253872 },
	{ 0x22c17, 0x26493d },
	{ 0x22c18, 0x253873 },
	{ 0x22c19, 0x253867 },
	{ 0x22c1a, 0x264938 },
	{ 0x22c1b, 0x26494b },
	{ 0x22c1c, 0x253865 },
	{ 0x22c28, 0x265273 },
	{ 0x22c29, 0x2f3b30 },
	{ 0x22c2a, 0x2f3b32 },
	{ 0x22c2b, 0x2f3b34 },
	{ 0x22c2c, 0x2f3b35 },
	{ 0x22c2d, 0x2f3b36 },
	{ 0x22c2e, 0x2f3b37 },
	{ 0x22c2f, 0x2f3b38 },
	{ 0x22c30, 0x2f3b39 },
	{ 0x22c31, 0x2f3b3a },
	{ 0x22c32, 0x2f3b3b },
	{ 0x22c33, 0x2f3b3c },
	{ 0x22c34, 0x2f3b3d },
	{ 0x22c35, 0x2f3b3f },
	{ 0x22c36, 0x2f3b40 },
	{ 0x22c37, 0x2f3b42 },
	{ 0x22c38, 0x2f3b43 },
	{ 0x22c39, 0x2f3b44 },
	{ 0x22c3a, 0x2f3b45 },
	{ 0x22c3b, 0x2f3b46 },
	{ 0x22c3c, 0x2f3b48 },
	{ 0x22c3d, 0x2f3b49 },
	{ 0x22c3e, 0x2f3b4a },
	{ 0x22c40, 0x265274 },
	{ 0x22c42, 0x26493e },
	{ 0x22c43, 0x264949 },
	{ 0x22c45, 0x264935 },
	{ 0x22c47, 0x253863 },
	{ 0x22c4d, 0x2f3b47 },
	{ 0x22c5f, 0x253f52 },
	{ 0x22c60, 0x26527b },
	{ 0x22c61, 0x243d4b },
	{ 0x22c62, 0x243d49 },
	{ 0x22c63, 0x253f55 },
	{ 0x22c64, 0x243d46 },
	{ 0x22c65, 0x265278 },
	{ 0x22c66, 0x243d4d },
	{ 0x22c67, 0x243d53 },
	{ 0x22c68, 0x243d47 },
	{ 0x22c69, 0x243d52 },
	{ 0x22c6a, 0x26527e },
	{ 0x22c6b, 0x253f51 },
	{ 0x22c6c, 0x254621 },
	{ 0x22c6e, 0x253f4b },
	{ 0x22c6f, 0x265d2c },
	{ 0x22c70, 0x265325 },
	{ 0x22c71, 0x265275 },
	{ 0x22c72, 0x265323 },
	{ 0x22c73, 0x265322 },
	{ 0x22c74, 0x253f4d },
	{ 0x22c76, 0x253f53 },
	{ 0x22c77, 0x253f4e },
	{ 0x22c78, 0x265279 },
	{ 0x22c79, 0x265321 },
	{ 0x22c7a, 0x253f50 },
	{ 0x22c7b, 0x265324 },
	{ 0x22c7c, 0x26527c },
	{ 0x22c7e, 0x253f4c },
	{ 0x22c7f, 0x26527a },
	{ 0x22c80, 0x253f4f },
	{ 0x22c81, 0x2f4156 },
	{ 0x22c82, 0x2f4157 },
	{ 0x22c83, 0x2f4158 },
	{ 0x22c84, 0x2f4159 },
	{ 0x22c85, 0x2f415a },
	{ 0x22c86, 0x2f415b },
	{ 0x22c87, 0x2f415c },
	{ 0x22c88, 0x2f415d },
	{ 0x22c89, 0x2f415e },
	{ 0x22c8a, 0x2f4160 },
	{ 0x22c8b, 0x2f4161 },
	{ 0x22c8c, 0x2f4163 },
	{ 0x22c8d, 0x2f4164 },
	{ 0x22c8e, 0x2f4165 },
	{ 0x22c8f, 0x2f4166 },
	{ 0x22c90, 0x2f4167 },
	{ 0x22c91, 0x2f4169 },
	{ 0x22c92, 0x2f4830 },
	{ 0x22c95, 0x265277 },
	{ 0x22c96, 0x26527d },
	{ 0x22c98, 0x265276 },
	{ 0x22ca1, 0x2f4168 },
	{ 0x22cb0, 0x253f54 },
	{ 0x22cb3, 0x265d36 },
	{ 0x22cb4, 0x254d39 },
	{ 0x22cb5, 0x254627 },
	{ 0x22cb6, 0x25462a },
	{ 0x22cb7, 0x244362 },
	{ 0x22cb8, 0x24435f },
	{ 0x22cb9, 0x265d3c },
	{ 0x22cba, 0x265d3d },
	{ 0x22cbb, 0x265d2e },
	{ 0x22cbc, 0x244357 },
	{ 0x22cbd, 0x265d3f },
	{ 0x22cbe, 0x254626 },
	{ 0x22cc0, 0x244363 },
	{ 0x22cc1, 0x254d38 },
	{ 0x22cc2, 0x254629 },
	{ 0x22cc3, 0x265d35 },
	{ 0x22cc4, 0x244359 },
	{ 0x22cc5, 0x27232f },
	{ 0x22cc6, 0x24435b },
	{ 0x22cc7, 0x24435a },
	{ 0x22cc8, 0x27232e },
	{ 0x22cc9, 0x272331 },
	{ 0x22ccb, 0x254624 },
	{ 0x22ccd, 0x244365 },
	{ 0x22cce, 0x265d39 },
	{ 0x22ccf, 0x265d3e },
	{ 0x22cd0, 0x265d3a },
	{ 0x22cd1, 0x254628 },
	{ 0x22cd2, 0x265d37 },
	{ 0x22cd3, 0x25462b },
	{ 0x22cd4, 0x27232c },
	{ 0x22cd5, 0x265d3b },
	{ 0x22cd6, 0x265d33 },
	{ 0x22cd8, 0x265d31 },
	{ 0x22cd9, 0x254622 },
	{ 0x22cda, 0x244360 },
	{ 0x22ce1, 0x265d2f },
	{ 0x22ce2, 0x265d34 },
	{ 0x22ce3, 0x2f482b },
	{ 0x22ce4, 0x2f482c },
	{ 0x22ce5, 0x2f482d },
	{ 0x22ce6, 0x2f482e },
	{ 0x22ce7, 0x2f482f },
	{ 0x22ce8, 0x2f4833 },
	{ 0x22ce9, 0x2f4834 },
	{ 0x22cea, 0x2f4835 },
	{ 0x22ceb, 0x2f4837 },
	{ 0x22cec, 0x2f4838 },
	{ 0x22ced, 0x2f483a },
	{ 0x22cee, 0x2f483b },
	{ 0x22cef, 0x2f4839 },
	{ 0x22cf0, 0x2f483c },
	{ 0x22cf1, 0x2f483d },
	{ 0x22cf2, 0x2f483e },
	{ 0x22cf3, 0x2f483f },
	{ 0x22cf4, 0x2f4840 },
	{ 0x22cf5, 0x2f4841 },
	{ 0x22cf6, 0x2f4842 },
	{ 0x22cf7, 0x2f4843 },
	{ 0x22cf8, 0x2f4844 },
	{ 0x22cf9, 0x2f4845 },
	{ 0x22cfa, 0x2f4847 },
	{ 0x22cfb, 0x2f4848 },
	{ 0x22cfc, 0x2f4849 },
	{ 0x22cfe, 0x2f4846 },
	{ 0x22d00, 0x265d30 },
	{ 0x22d01, 0x2f4836 },
	{ 0x22d20, 0x272333 },
	{ 0x22d21, 0x272338 },
	{ 0x22d22, 0x254d3c },
	{ 0x22d23, 0x244a25 },
	{ 0x22d24, 0x27233d },
	{ 0x22d25, 0x272337 },
	{ 0x22d26, 0x272339 },
	{ 0x22d27, 0x24497b },
	{ 0x22d28, 0x244978 },
	{ 0x22d29, 0x254d3d },
	{ 0x22d2a, 0x254d3b },
	{ 0x22d2b, 0x272345 },
	{ 0x22d2c, 0x24497d },
	{ 0x22d2d, 0x272e2f },
	{ 0x22d2e, 0x244a21 },
	{ 0x22d30, 0x254d41 },
	{ 0x22d31, 0x244a26 },
	{ 0x22d32, 0x24497c },
	{ 0x22d33, 0x255459 },
	{ 0x22d34, 0x272e3c },
	{ 0x22d35, 0x272335 },
	{ 0x22d36, 0x272334 },
	{ 0x22d37, 0x272e2d },
	{ 0x22d38, 0x272e2b },
	{ 0x22d39, 0x272344 },
	{ 0x22d3a, 0x272e2c },
	{ 0x22d3b, 0x27233c },
	{ 0x22d3c, 0x254d40 },
	{ 0x22d3d, 0x272e2e },
	{ 0x22d3e, 0x254d3f },
	{ 0x22d3f, 0x27233b },
	{ 0x22d40, 0x272342 },
	{ 0x22d41, 0x272343 },
	{ 0x22d43, 0x27233e },
	{ 0x22d44, 0x272341 },
	{ 0x22d48, 0x244977 },
	{ 0x22d4a, 0x2f4831 },
	{ 0x22d4d, 0x272332 },
	{ 0x22d4e, 0x27233f },
	{ 0x22d4f, 0x272340 },
	{ 0x22d50, 0x2f4e7c },
	{ 0x22d51, 0x2f4e7d },
	{ 0x22d52, 0x2f4e7e },
	{ 0x22d53, 0x2f4f21 },
	{ 0x22d54, 0x2f4f22 },
	{ 0x22d55, 0x2f4f23 },
	{ 0x22d56, 0x2f4f26 },
	{ 0x22d57, 0x2f4f27 },
	{ 0x22d58, 0x2f4f28 },
	{ 0x22d59, 0x2f4f29 },
	{ 0x22d5a, 0x2f4f2a },
	{ 0x22d5b, 0x2f4f2b },
	{ 0x22d5c, 0x2f4f2d },
	{ 0x22d5d, 0x2f4f2e },
	{ 0x22d5e, 0x2f4f2f },
	{ 0x22d5f, 0x2f4f30 },
	{ 0x22d60, 0x2f545f },
	{ 0x22d63, 0x2f4f24 },
	{ 0x22d7f, 0x245638 },
	{ 0x22d80, 0x245041 },
	{ 0x22d81, 0x272e35 },
	{ 0x22d82, 0x272e30 },
	{ 0x22d83, 0x25545a },
	{ 0x22d84, 0x25545b },
	{ 0x22d85, 0x272e3e },
	{ 0x22d86, 0x272e3a },
	{ 0x22d87, 0x272e32 },
	{ 0x22d88, 0x272336 },
	{ 0x22d89, 0x24503e },
	{ 0x22d8a, 0x245043 },
	{ 0x22d8b, 0x245040 },
	{ 0x22d8c, 0x25545d },
	{ 0x22d8d, 0x24503f },
	{ 0x22d8e, 0x272e3d },
	{ 0x22d8f, 0x245046 },
	{ 0x22d90, 0x272e3b },
	{ 0x22d91, 0x245048 },
	{ 0x22d92, 0x245042 },
	{ 0x22d93, 0x245047 },
	{ 0x22d94, 0x272e39 },
	{ 0x22d95, 0x272e31 },
	{ 0x22d96, 0x272e40 },
	{ 0x22d97, 0x273829 },
	{ 0x22d98, 0x272e38 },
	{ 0x22d99, 0x25545f },
	{ 0x22d9a, 0x25545c },
	{ 0x22d9b, 0x272e37 },
	{ 0x22d9c, 0x273828 },
	{ 0x22d9d, 0x272e33 },
	{ 0x22da6, 0x272e3f },
	{ 0x22da7, 0x2f5455 },
	{ 0x22da8, 0x2f5456 },
	{ 0x22da9, 0x2f5457 },
	{ 0x22daa, 0x2f5458 },
	{ 0x22dab, 0x2f5459 },
	{ 0x22dac, 0x2f545a },
	{ 0x22dad, 0x2f545b },
	{ 0x22dae, 0x2f545c },
	{ 0x22daf, 0x2f545d },
	{ 0x22db0, 0x2f545e },
	{ 0x22db1, 0x2f5460 },
	{ 0x22db5, 0x272e34 },
	{ 0x22dc7, 0x272e36 },
	{ 0x22dc8, 0x245044 },
	{ 0x22dc9, 0x2f5454 },
	{ 0x22dcb, 0x255b56 },
	{ 0x22dcc, 0x273831 },
	{ 0x22dcd, 0x255b57 },
	{ 0x22dce, 0x273836 },
	{ 0x22dcf, 0x24563b },
	{ 0x22dd0, 0x27382f },
	{ 0x22dd1, 0x273835 },
	{ 0x22dd2, 0x24563a },
	{ 0x22dd3, 0x273834 },
	{ 0x22dd4, 0x27382c },
	{ 0x22dd5, 0x255b58 },
	{ 0x22dd6, 0x245637 },
	{ 0x22dd7, 0x255b55 },
	{ 0x22dd8, 0x27382a },
	{ 0x22dd9, 0x273837 },
	{ 0x22dda, 0x273830 },
	{ 0x22ddb, 0x27382e },
	{ 0x22ddc, 0x273832 },
	{ 0x22ddd, 0x273838 },
	{ 0x22de4, 0x27382b },
	{ 0x22de5, 0x27382d },
	{ 0x22de6, 0x2f5a30 },
	{ 0x22de7, 0x2f5a31 },
	{ 0x22de8, 0x2f5a32 },
	{ 0x22de9, 0x2f5a33 },
	{ 0x22dea, 0x2f5a34 },
	{ 0x22deb, 0x2f5a35 },
	{ 0x22ded, 0x273833 },
	{ 0x22df6, 0x245b33 },
	{ 0x22df7, 0x245b38 },
	{ 0x22df8, 0x25616e },
	{ 0x22df9, 0x25616b },
	{ 0x22dfa, 0x25616c },
	{ 0x22dfb, 0x25616d },
	{ 0x22dfc, 0x273f68 },
	{ 0x22dfd, 0x273f67 },
	{ 0x22dfe, 0x245b35 },
	{ 0x22dff, 0x245b37 },
	{ 0x22e00, 0x25677a },
	{ 0x22e01, 0x256c2d },
	{ 0x22e02, 0x273f69 },
	{ 0x22e03, 0x273f66 },
	{ 0x22e04, 0x245b34 },
	{ 0x22e05, 0x273f63 },
	{ 0x22e06, 0x273f65 },
	{ 0x22e07, 0x27472f },
	{ 0x22e08, 0x273f61 },
	{ 0x22e09, 0x273f64 },
	{ 0x22e0e, 0x2f5e68 },
	{ 0x22e0f, 0x2f5e69 },
	{ 0x22e10, 0x2f5e6a },
	{ 0x22e11, 0x2f5e6d },
	{ 0x22e12, 0x2f5e6e },
	{ 0x22e13, 0x2f5e6f },
	{ 0x22e14, 0x2f5e71 },
	{ 0x22e15, 0x2f5e72 },
	{ 0x22e16, 0x2f5e74 },
	{ 0x22e18, 0x2f5e6c },
	{ 0x22e19, 0x2f5e6b },
	{ 0x22e23, 0x245f66 },
	{ 0x22e24, 0x245f68 },
	{ 0x22e25, 0x245f67 },
	{ 0x22e26, 0x245f69 },
	{ 0x22e27, 0x256c2f },
	{ 0x22e28, 0x274732 },
	{ 0x22e29, 0x274734 },
	{ 0x22e2a, 0x274736 },
	{ 0x22e2b, 0x25677b },
	{ 0x22e2c, 0x274730 },
	{ 0x22e2d, 0x256c2e },
	{ 0x22e2e, 0x274738 },
	{ 0x22e2f, 0x245f6b },
	{ 0x22e30, 0x274735 },
	{ 0x22e31, 0x274733 },
	{ 0x22e32, 0x274731 },
	{ 0x22e33, 0x245f6a },
	{ 0x22e34, 0x256779 },
	{ 0x22e37, 0x2f623e },
	{ 0x22e38, 0x2f623f },
	{ 0x22e39, 0x2f6240 },
	{ 0x22e3a, 0x2f6241 },
	{ 0x22e3b, 0x2f6242 },
	{ 0x22e3c, 0x2f6243 },
	{ 0x22e3d, 0x2f6244 },
	{ 0x22e3e, 0x2f6245 },
	{ 0x22e3f, 0x2f6246 },
	{ 0x22e40, 0x2f6249 },
	{ 0x22e41, 0x2f652f },
	{ 0x22e42, 0x273f6a },
	{ 0x22e44, 0x274737 },
	{ 0x22e4b, 0x2f6247 },
	{ 0x22e4d, 0x256c32 },
	{ 0x22e4f, 0x24663f },
	{ 0x22e50, 0x274d6d },
	{ 0x22e51, 0x246348 },
	{ 0x22e53, 0x274d6c },
	{ 0x22e54, 0x246349 },
	{ 0x22e55, 0x274d70 },
	{ 0x22e56, 0x24634a },
	{ 0x22e57, 0x274d6e },
	{ 0x22e58, 0x256c33 },
	{ 0x22e59, 0x256c30 },
	{ 0x22e5a, 0x256c31 },
	{ 0x22e5f, 0x274d6f },
	{ 0x22e60, 0x2f652d },
	{ 0x22e61, 0x2f652e },
	{ 0x22e62, 0x2f6530 },
	{ 0x22e6c, 0x275344 },
	{ 0x22e6d, 0x275777 },
	{ 0x22e6e, 0x246641 },
	{ 0x22e6f, 0x27533f },
	{ 0x22e70, 0x275343 },
	{ 0x22e71, 0x275342 },
	{ 0x22e72, 0x246642 },
	{ 0x22e73, 0x257345 },
	{ 0x22e74, 0x275341 },
	{ 0x22e75, 0x275340 },
	{ 0x22e77, 0x2f6756 },
	{ 0x22e79, 0x2f6757 },
	{ 0x22e7a, 0x2f6758 },
	{ 0x22e7b, 0x2f6759 },
	{ 0x22e82, 0x275778 },
	{ 0x22e83, 0x275779 },
	{ 0x22e84, 0x257344 },
	{ 0x22e85, 0x257347 },
	{ 0x22e86, 0x257023 },
	{ 0x22e87, 0x27577a },
	{ 0x22e88, 0x257342 },
	{ 0x22e89, 0x257346 },
	{ 0x22e8a, 0x27577c },
	{ 0x22e8b, 0x275b57 },
	{ 0x22e8c, 0x27533e },
	{ 0x22e8f, 0x2f6943 },
	{ 0x22e90, 0x2f6944 },
	{ 0x22e91, 0x257343 },
	{ 0x22e95, 0x27577b },
	{ 0x22e96, 0x275b58 },
	{ 0x22e98, 0x2f6a54 },
	{ 0x22e99, 0x2f6a55 },
	{ 0x22e9a, 0x2f6a56 },
	{ 0x22e9e, 0x275e6a },
	{ 0x22e9f, 0x25775d },
	{ 0x22ea0, 0x275e69 },
	{ 0x22ea1, 0x246b6b },
	{ 0x22ea2, 0x275e6b },
	{ 0x22ea5, 0x25775c },
	{ 0x22ea6, 0x275e68 },
	{ 0x22ea7, 0x2f6b49 },
	{ 0x22ea8, 0x2f6b4a },
	{ 0x22ea9, 0x2f6b4b },
	{ 0x22eaa, 0x2f6b4c },
	{ 0x22eac, 0x276238 },
	{ 0x22ead, 0x2f6c2a },
	{ 0x22eae, 0x2f6c2b },
	{ 0x22eb0, 0x246d73 },
	{ 0x22eb1, 0x276353 },
	{ 0x22eb2, 0x2f6c61 },
	{ 0x22eb4, 0x276626 },
	{ 0x22eb5, 0x242277 },
	{ 0x22eb6, 0x24243d },
	{ 0x22eb7, 0x24265a },
	{ 0x22eb8, 0x2f2731 },
	{ 0x22eb9, 0x2f2732 },
	{ 0x22eba, 0x2f2733 },
	{ 0x22ebe, 0x263158 },
	{ 0x22ec1, 0x263822 },
	{ 0x22ec2, 0x252f5c },
	{ 0x22ec3, 0x242d3e },
	{ 0x22ec4, 0x263821 },
	{ 0x22ec8, 0x263644 },
	{ 0x22eca, 0x264039 },
	{ 0x22ecd, 0x264038 },
	{ 0x22ece, 0x26494f },
	{ 0x22ecf, 0x26494e },
	{ 0x22ed0, 0x2f3b4c },
	{ 0x22ed1, 0x2f3b4d },
	{ 0x22ed4, 0x253875 },
	{ 0x22ed5, 0x265326 },
	{ 0x22ed6, 0x2f416a },
	{ 0x22ed7, 0x265327 },
	{ 0x22eda, 0x25462d },
	{ 0x22edb, 0x265d40 },
	{ 0x22edd, 0x272346 },
	{ 0x22ede, 0x272347 },
	{ 0x22ee0, 0x255460 },
	{ 0x22ee1, 0x2f5461 },
	{ 0x22ee5, 0x27383b },
	{ 0x22ee6, 0x27383a },
	{ 0x22ee7, 0x255b59 },
	{ 0x22ee9, 0x27383c },
	{ 0x22eea, 0x274d71 },
	{ 0x22eec, 0x25243f },
	{ 0x22eed, 0x262779 },
	{ 0x22eee, 0x252440 },
	{ 0x22eef, 0x26277a },
	{ 0x22ef1, 0x252441 },
	{ 0x22ef2, 0x262778 },
	{ 0x22ef3, 0x262b68 },
	{ 0x22ef4, 0x242660 },
	{ 0x22ef6, 0x252642 },
	{ 0x22ef7, 0x252640 },
	{ 0x22ef9, 0x24265d },
	{ 0x22efa, 0x262b6c },
	{ 0x22efb, 0x262b66 },
	{ 0x22efd, 0x262b6a },
	{ 0x22efe, 0x262b69 },
	{ 0x22f05, 0x262b67 },
	{ 0x22f06, 0x25263f },
	{ 0x22f07, 0x252641 },
	{ 0x22f08, 0x24265c },
	{ 0x22f09, 0x242960 },
	{ 0x22f0a, 0x263159 },
	{ 0x22f0b, 0x25294c },
	{ 0x22f0c, 0x25294b },
	{ 0x22f0d, 0x26315c },
	{ 0x22f0e, 0x26315e },
	{ 0x22f0f, 0x26315d },
	{ 0x22f10, 0x252949 },
	{ 0x22f11, 0x25294a },
	{ 0x22f14, 0x24295e },
	{ 0x22f15, 0x24295f },
	{ 0x22f18, 0x26315b },
	{ 0x22f1c, 0x263823 },
	{ 0x22f1d, 0x263824 },
	{ 0x22f1e, 0x263826 },
	{ 0x22f1f, 0x252d72 },
	{ 0x22f20, 0x26315f },
	{ 0x22f21, 0x242d45 },
	{ 0x22f22, 0x263828 },
	{ 0x22f23, 0x252d70 },
	{ 0x22f25, 0x26382a },
	{ 0x22f27, 0x252d6f },
	{ 0x22f28, 0x252d74 },
	{ 0x22f2a, 0x263825 },
	{ 0x22f2c, 0x252d73 },
	{ 0x22f2d, 0x252d71 },
	{ 0x22f2e, 0x263829 },
	{ 0x22f2f, 0x263827 },
	{ 0x22f36, 0x242d41 },
	{ 0x22f3a, 0x25326d },
	{ 0x22f3b, 0x264040 },
	{ 0x22f3d, 0x24322e },
	{ 0x22f3f, 0x26403a },
	{ 0x22f40, 0x26403b },
	{ 0x22f41, 0x26403d },
	{ 0x22f42, 0x25326f },
	{ 0x22f43, 0x253270 },
	{ 0x22f44, 0x243230 },
	{ 0x22f45, 0x26403e },
	{ 0x22f46, 0x26403c },
	{ 0x22f47, 0x25326b },
	{ 0x22f48, 0x264041 },
	{ 0x22f49, 0x243231 },
	{ 0x22f4a, 0x24322a },
	{ 0x22f4b, 0x24322d },
	{ 0x22f4f, 0x243229 },
	{ 0x22f50, 0x25326e },
	{ 0x22f51, 0x2f3531 },
	{ 0x22f52, 0x2f3532 },
	{ 0x22f53, 0x2f3533 },
	{ 0x22f54, 0x2f3534 },
	{ 0x22f55, 0x2f3535 },
	{ 0x22f57, 0x25326a },
	{ 0x22f58, 0x26403f },
	{ 0x22f5b, 0x264958 },
	{ 0x22f5d, 0x253922 },
	{ 0x22f5e, 0x264955 },
	{ 0x22f5f, 0x24377a },
	{ 0x22f60, 0x24377b },
	{ 0x22f61, 0x264959 },
	{ 0x22f64, 0x264954 },
	{ 0x22f65, 0x26495a },
	{ 0x22f66, 0x253876 },
	{ 0x22f67, 0x25387e },
	{ 0x22f68, 0x253921 },
	{ 0x22f69, 0x25387d },
	{ 0x22f6a, 0x253877 },
	{ 0x22f6c, 0x264956 },
	{ 0x22f6d, 0x25387b },
	{ 0x22f6e, 0x264951 },
	{ 0x22f6f, 0x264950 },
	{ 0x22f70, 0x264953 },
	{ 0x22f72, 0x243772 },
	{ 0x22f73, 0x243773 },
	{ 0x22f74, 0x243774 },
	{ 0x22f75, 0x253878 },
	{ 0x22f76, 0x253879 },
	{ 0x22f77, 0x25326c },
	{ 0x22f7a, 0x264952 },
	{ 0x22f7f, 0x26532f },
	{ 0x22f80, 0x25387a },
	{ 0x22f82, 0x253f57 },
	{ 0x22f83, 0x253f5a },
	{ 0x22f84, 0x253f5c },
	{ 0x22f85, 0x243d57 },
	{ 0x22f86, 0x243d5f },
	{ 0x22f87, 0x26532b },
	{ 0x22f88, 0x26532e },
	{ 0x22f89, 0x265329 },
	{ 0x22f8b, 0x253f5b },
	{ 0x22f8c, 0x265330 },
	{ 0x22f8d, 0x26532d },
	{ 0x22f8f, 0x265328 },
	{ 0x22f90, 0x243d60 },
	{ 0x22f92, 0x253f56 },
	{ 0x22f93, 0x265331 },
	{ 0x22f94, 0x253f59 },
	{ 0x22f99, 0x243d5e },
	{ 0x22f9a, 0x243d55 },
	{ 0x22f9b, 0x243d56 },
	{ 0x22f9c, 0x243d58 },
	{ 0x22f9d, 0x253f58 },
	{ 0x22f9e, 0x26532a },
	{ 0x22f9f, 0x2f416b },
	{ 0x22fa0, 0x26532c },
	{ 0x22fa3, 0x253271 },
	{ 0x22fa4, 0x243d5a },
	{ 0x22fa5, 0x265560 },
	{ 0x22fa7, 0x254634 },
	{ 0x22fa8, 0x265d49 },
	{ 0x22fa9, 0x254632 },
	{ 0x22faa, 0x265d41 },
	{ 0x22fab, 0x244368 },
	{ 0x22fac, 0x254631 },
	{ 0x22fad, 0x265d42 },
	{ 0x22fae, 0x25462f },
	{ 0x22faf, 0x265d46 },
	{ 0x22fb1, 0x254637 },
	{ 0x22fb3, 0x254635 },
	{ 0x22fb4, 0x265d47 },
	{ 0x22fb5, 0x265d45 },
	{ 0x22fb6, 0x265d44 },
	{ 0x22fb7, 0x265d48 },
	{ 0x22fb8, 0x265d43 },
	{ 0x22fb9, 0x265d4a },
	{ 0x22fba, 0x254633 },
	{ 0x22fbc, 0x244367 },
	{ 0x22fbd, 0x254636 },
	{ 0x22fbe, 0x265d4b },
	{ 0x22fc6, 0x254825 },
	{ 0x22fc7, 0x254d42 },
	{ 0x22fc8, 0x254d47 },
	{ 0x22fc9, 0x244a2c },
	{ 0x22fca, 0x27234e },
	{ 0x22fcb, 0x272349 },
	{ 0x22fcd, 0x272348 },
	{ 0x22fce, 0x254d46 },
	{ 0x22fd0, 0x272352 },
	{ 0x22fd1, 0x27234f },
	{ 0x22fd2, 0x27234d },
	{ 0x22fd3, 0x254d45 },
	{ 0x22fd4, 0x272350 },
	{ 0x22fd5, 0x254d43 },
	{ 0x22fd6, 0x254d44 },
	{ 0x22fd7, 0x2f4f31 },
	{ 0x22fd8, 0x27234b },
	{ 0x22fd9, 0x27234c },
	{ 0x22fdb, 0x27234a },
	{ 0x22fde, 0x24504b },
	{ 0x22fdf, 0x272e42 },
	{ 0x22fe0, 0x272e46 },
	{ 0x22fe1, 0x272e48 },
	{ 0x22fe3, 0x2f5462 },
	{ 0x22fe4, 0x255461 },
	{ 0x22fe5, 0x272e4b },
	{ 0x22fe8, 0x272e47 },
	{ 0x22fe9, 0x272e49 },
	{ 0x22fea, 0x272e41 },
	{ 0x22feb, 0x272e45 },
	{ 0x22fec, 0x272e4c },
	{ 0x22fed, 0x255463 },
	{ 0x22fee, 0x272e4a },
	{ 0x22ff2, 0x24504a },
	{ 0x22ff3, 0x255464 },
	{ 0x22ff4, 0x255465 },
	{ 0x22ff5, 0x255466 },
	{ 0x22ff6, 0x2f5463 },
	{ 0x22ff7, 0x272e44 },
	{ 0x22ff8, 0x255462 },
	{ 0x22ff9, 0x272351 },
	{ 0x22ffd, 0x255467 },
	{ 0x22ffe, 0x27383e },
	{ 0x22fff, 0x27383d },
	{ 0x23000, 0x255b5a },
	{ 0x23001, 0x255b5e },
	{ 0x23002, 0x255b5d },
	{ 0x23006, 0x24563c },
	{ 0x23009, 0x24563d },
	{ 0x2300a, 0x255b5b },
	{ 0x2300b, 0x2f5a37 },
	{ 0x2300c, 0x2f5a38 },
	{ 0x2300e, 0x27383f },
	{ 0x2300f, 0x255b5c },
	{ 0x23010, 0x256170 },
	{ 0x23011, 0x273f6c },
	{ 0x23012, 0x25616f },
	{ 0x23014, 0x245b3b },
	{ 0x23015, 0x273f6d },
	{ 0x23016, 0x273f6e },
	{ 0x23018, 0x245b39 },
	{ 0x2301a, 0x273f6b },
	{ 0x2301d, 0x256821 },
	{ 0x2301e, 0x25677e },
	{ 0x23020, 0x25677c },
	{ 0x23021, 0x25677d },
	{ 0x23022, 0x2f624a },
	{ 0x23023, 0x256c34 },
	{ 0x23024, 0x24634d },
	{ 0x23025, 0x256c35 },
	{ 0x23026, 0x274d72 },
	{ 0x23027, 0x24634b },
	{ 0x23028, 0x274d75 },
	{ 0x2302a, 0x274d74 },
	{ 0x2302b, 0x256c36 },
	{ 0x2302c, 0x274d76 },
	{ 0x2302d, 0x274d77 },
	{ 0x2302e, 0x246644 },
	{ 0x2302f, 0x257025 },
	{ 0x23031, 0x257026 },
	{ 0x23033, 0x257348 },
	{ 0x23034, 0x2f6945 },
	{ 0x23035, 0x275b59 },
	{ 0x23036, 0x25756b },
	{ 0x23037, 0x246a4a },
	{ 0x2303a, 0x275b5a },
	{ 0x2303c, 0x246c6f },
	{ 0x2303d, 0x2f6c62 },
	{ 0x23041, 0x2f2253 },
	{ 0x23042, 0x2f2446 },
	{ 0x23043, 0x262b6d },
	{ 0x23046, 0x2f2b2d },
	{ 0x23047, 0x2f2b2e },
	{ 0x23048, 0x2f2b2f },
	{ 0x2304a, 0x26382d },
	{ 0x2304b, 0x26382e },
	{ 0x2304c, 0x2f2f65 },
	{ 0x2304e, 0x264042 },
	{ 0x2304f, 0x264044 },
	{ 0x23050, 0x2f3537 },
	{ 0x23051, 0x2f3538 },
	{ 0x23052, 0x264043 },
	{ 0x23055, 0x2f3b4e },
	{ 0x23057, 0x253f5d },
	{ 0x23058, 0x2f416c },
	{ 0x23059, 0x265332 },
	{ 0x2305a, 0x2f3536 },
	{ 0x2305c, 0x254d48 },
	{ 0x2305d, 0x272354 },
	{ 0x2305e, 0x272353 },
	{ 0x2305f, 0x254d49 },
	{ 0x23060, 0x2f4f33 },
	{ 0x23061, 0x2f4f34 },
	{ 0x23062, 0x254d4a },
	{ 0x23063, 0x272e4d },
	{ 0x23064, 0x2f5a39 },
	{ 0x23065, 0x2f5e75 },
	{ 0x23067, 0x2f624b },
	{ 0x23069, 0x2f675a },
	{ 0x2306b, 0x275b5b },
	{ 0x2306c, 0x262222 },
	{ 0x2306e, 0x2f2734 },
	{ 0x23071, 0x263160 },
	{ 0x23073, 0x242d48 },
	{ 0x23074, 0x252d76 },
	{ 0x23075, 0x252d75 },
	{ 0x23076, 0x26382f },
	{ 0x23077, 0x253272 },
	{ 0x23078, 0x2f3539 },
	{ 0x2307a, 0x264046 },
	{ 0x2307b, 0x264045 },
	{ 0x2307c, 0x26495d },
	{ 0x2307d, 0x2f4032 },
	{ 0x2307f, 0x26495b },
	{ 0x23080, 0x26495c },
	{ 0x23081, 0x243d61 },
	{ 0x23082, 0x265d4c },
	{ 0x23084, 0x253f5e },
	{ 0x23085, 0x2f416d },
	{ 0x23086, 0x24436a },
	{ 0x23089, 0x244a2d },
	{ 0x2308a, 0x272355 },
	{ 0x2308c, 0x273840 },
	{ 0x2308f, 0x245f6c },
	{ 0x23091, 0x262223 },
	{ 0x23093, 0x2f2447 },
	{ 0x23094, 0x262b6f },
	{ 0x23095, 0x262b6e },
	{ 0x23099, 0x263161 },
	{ 0x2309b, 0x2f2f66 },
	{ 0x2309e, 0x243232 },
	{ 0x2309f, 0x264048 },
	{ 0x230a0, 0x264047 },
	{ 0x230a1, 0x264960 },
	{ 0x230a2, 0x264964 },
	{ 0x230a3, 0x264963 },
	{ 0x230a4, 0x253923 },
	{ 0x230a5, 0x264966 },
	{ 0x230a6, 0x26495f },
	{ 0x230a7, 0x26495e },
	{ 0x230a8, 0x264962 },
	{ 0x230aa, 0x24377c },
	{ 0x230ab, 0x264c3e },
	{ 0x230ad, 0x264965 },
	{ 0x230ae, 0x243d62 },
	{ 0x230af, 0x265336 },
	{ 0x230b1, 0x265334 },
	{ 0x230b2, 0x265337 },
	{ 0x230b5, 0x253f5f },
	{ 0x230b6, 0x265d4f },
	{ 0x230b8, 0x265d4e },
	{ 0x230b9, 0x265d50 },
	{ 0x230ba, 0x234731 },
	{ 0x230bb, 0x244a2f },
	{ 0x230bc, 0x265d4d },
	{ 0x230bd, 0x254d4c },
	{ 0x230bf, 0x254d4d },
	{ 0x230c0, 0x272e51 },
	{ 0x230c1, 0x272e50 },
	{ 0x230c2, 0x272e4f },
	{ 0x230c3, 0x272e52 },
	{ 0x230c6, 0x272e4e },
	{ 0x230c8, 0x24504d },
	{ 0x230ca, 0x273841 },
	{ 0x230cb, 0x273842 },
	{ 0x230cc, 0x273f6f },
	{ 0x230cd, 0x245b3c },
	{ 0x230cf, 0x273f70 },
	{ 0x230d0, 0x273f71 },
	{ 0x230d1, 0x274739 },
	{ 0x230d3, 0x2f624c },
	{ 0x230d4, 0x274d78 },
	{ 0x230d6, 0x27577d },
	{ 0x230d8, 0x242442 },
	{ 0x230d9, 0x26277b },
	{ 0x230db, 0x2f2735 },
	{ 0x230dc, 0x2f2736 },
	{ 0x230dd, 0x25294d },
	{ 0x230de, 0x263164 },
	{ 0x230df, 0x263163 },
	{ 0x230e1, 0x2f2b30 },
	{ 0x230e2, 0x263162 },
	{ 0x230e6, 0x242d4a },
	{ 0x230e7, 0x252d77 },
	{ 0x230e8, 0x263831 },
	{ 0x230e9, 0x263833 },
	{ 0x230ea, 0x263835 },
	{ 0x230eb, 0x2f2f67 },
	{ 0x230ec, 0x2f2f68 },
	{ 0x230ed, 0x2f2f69 },
	{ 0x230ee, 0x2f2f6a },
	{ 0x230ef, 0x263832 },
	{ 0x230f3, 0x243233 },
	{ 0x230f5, 0x243235 },
	{ 0x230f7, 0x26404a },
	{ 0x230f8, 0x2f353a },
	{ 0x230f9, 0x2f353b },
	{ 0x230fb, 0x264049 },
	{ 0x230fc, 0x264969 },
	{ 0x230fd, 0x253925 },
	{ 0x230fe, 0x253924 },
	{ 0x230ff, 0x264968 },
	{ 0x23100, 0x26496a },
	{ 0x23101, 0x264967 },
	{ 0x23102, 0x2f3b4f },
	{ 0x23104, 0x2f3b50 },
	{ 0x23108, 0x265338 },
	{ 0x23109, 0x253f60 },
	{ 0x2310a, 0x265339 },
	{ 0x2310b, 0x2f416e },
	{ 0x2310c, 0x2f416f },
	{ 0x2310e, 0x254638 },
	{ 0x2310f, 0x25463a },
	{ 0x23110, 0x265d52 },
	{ 0x23111, 0x254639 },
	{ 0x23114, 0x272356 },
	{ 0x23117, 0x2f4f35 },
	{ 0x23118, 0x272e53 },
	{ 0x23119, 0x255468 },
	{ 0x2311a, 0x273843 },
	{ 0x2311d, 0x255b5f },
	{ 0x2311e, 0x273f73 },
	{ 0x2311f, 0x256171 },
	{ 0x23120, 0x245b3d },
	{ 0x23121, 0x273f74 },
	{ 0x23122, 0x273f72 },
	{ 0x23124, 0x27473a },
	{ 0x23126, 0x275345 },
	{ 0x23127, 0x24686d },
	{ 0x23128, 0x27577e },
	{ 0x2312a, 0x275e6c },
	{ 0x2312b, 0x276070 },
	{ 0x2312e, 0x252442 },
	{ 0x23130, 0x25294e },
	{ 0x23131, 0x252d79 },
	{ 0x23132, 0x252d78 },
	{ 0x23134, 0x24377d },
	{ 0x23135, 0x26496b },
	{ 0x23136, 0x26533a },
	{ 0x23137, 0x26533b },
	{ 0x23138, 0x243d66 },
	{ 0x23139, 0x2f4f36 },
	{ 0x2313b, 0x26232c },
	{ 0x2313c, 0x26232b },
	{ 0x2313e, 0x26247b },
	{ 0x2313f, 0x252273 },
	{ 0x23140, 0x26247a },
	{ 0x23141, 0x26247c },
	{ 0x23142, 0x2f2254 },
	{ 0x23144, 0x2f244b },
	{ 0x23146, 0x26277c },
	{ 0x23147, 0x26277d },
	{ 0x23148, 0x262825 },
	{ 0x23149, 0x252443 },
	{ 0x2314a, 0x262822 },
	{ 0x2314b, 0x26277e },
	{ 0x2314c, 0x262824 },
	{ 0x2314e, 0x262823 },
	{ 0x23150, 0x262821 },
	{ 0x23151, 0x2f2448 },
	{ 0x23152, 0x2f244a },
	{ 0x23153, 0x2f244c },
	{ 0x23156, 0x242444 },
	{ 0x2315a, 0x252648 },
	{ 0x2315b, 0x262b74 },
	{ 0x2315c, 0x262b73 },
	{ 0x2315d, 0x252649 },
	{ 0x2315e, 0x262b7d },
	{ 0x2315f, 0x252644 },
	{ 0x23160, 0x262b79 },
	{ 0x23161, 0x252647 },
	{ 0x23162, 0x262b7a },
	{ 0x23163, 0x262b77 },
	{ 0x23164, 0x252646 },
	{ 0x23165, 0x252645 },
	{ 0x23166, 0x262b75 },
	{ 0x23167, 0x262b78 },
	{ 0x23168, 0x2f2737 },
	{ 0x23169, 0x2f2738 },
	{ 0x2316a, 0x2f2739 },
	{ 0x2316b, 0x2f273a },
	{ 0x2316c, 0x2f273b },
	{ 0x2316d, 0x2f273c },
	{ 0x2316e, 0x2f273d },
	{ 0x2316f, 0x262b71 },
	{ 0x23171, 0x262b7b },
	{ 0x23172, 0x262b7c },
	{ 0x23173, 0x262b72 },
	{ 0x23174, 0x262b76 },
	{ 0x23177, 0x252951 },
	{ 0x23178, 0x263165 },
	{ 0x23179, 0x263166 },
	{ 0x2317a, 0x252950 },
	{ 0x2317b, 0x242966 },
	{ 0x2317c, 0x263168 },
	{ 0x2317d, 0x263169 },
	{ 0x2317e, 0x242968 },
	{ 0x23181, 0x2f2b31 },
	{ 0x23183, 0x2f2b32 },
	{ 0x23184, 0x26316a },
	{ 0x23185, 0x2f2b35 },
	{ 0x23186, 0x2f2b36 },
	{ 0x23189, 0x26316e },
	{ 0x2318a, 0x26316c },
	{ 0x2318b, 0x26316b },
	{ 0x23192, 0x252d7e },
	{ 0x23193, 0x26383a },
	{ 0x23194, 0x252e21 },
	{ 0x23195, 0x252e22 },
	{ 0x23196, 0x252d7b },
	{ 0x23197, 0x252e23 },
	{ 0x23198, 0x252d7c },
	{ 0x23199, 0x252d7a },
	{ 0x2319a, 0x26383e },
	{ 0x2319b, 0x263838 },
	{ 0x2319c, 0x26383c },
	{ 0x2319d, 0x252d7d },
	{ 0x2319e, 0x263839 },
	{ 0x231a0, 0x26383d },
	{ 0x231a3, 0x2f2f6b },
	{ 0x231a6, 0x2f2f6d },
	{ 0x231a7, 0x26383b },
	{ 0x231a8, 0x2f2f6c },
	{ 0x231a9, 0x263841 },
	{ 0x231ab, 0x26383f },
	{ 0x231b2, 0x253273 },
	{ 0x231b3, 0x243238 },
	{ 0x231b4, 0x243821 },
	{ 0x231b5, 0x264053 },
	{ 0x231b6, 0x24323d },
	{ 0x231b7, 0x26404e },
	{ 0x231b8, 0x26404b },
	{ 0x231b9, 0x26404c },
	{ 0x231ba, 0x264050 },
	{ 0x231bb, 0x26404d },
	{ 0x231bc, 0x264055 },
	{ 0x231bd, 0x253275 },
	{ 0x231be, 0x263840 },
	{ 0x231bf, 0x264054 },
	{ 0x231c0, 0x264056 },
	{ 0x231c6, 0x2f353c },
	{ 0x231cb, 0x2f353d },
	{ 0x231cc, 0x2f353e },
	{ 0x231cd, 0x2f353f },
	{ 0x231ce, 0x2f3540 },
	{ 0x231cf, 0x2f3541 },
	{ 0x231d0, 0x2f3542 },
	{ 0x231d1, 0x2f3543 },
	{ 0x231d2, 0x2f3544 },
	{ 0x231d3, 0x2f3545 },
	{ 0x231d4, 0x2f3546 },
	{ 0x231d5, 0x2f3547 },
	{ 0x231da, 0x264052 },
	{ 0x231e2, 0x253274 },
	{ 0x231e3, 0x264971 },
	{ 0x231e4, 0x264974 },
	{ 0x231e5, 0x24323c },
	{ 0x231e6, 0x253f61 },
	{ 0x231e7, 0x25392a },
	{ 0x231e8, 0x26496f },
	{ 0x231e9, 0x253927 },
	{ 0x231ea, 0x264970 },
	{ 0x231eb, 0x253929 },
	{ 0x231ec, 0x253926 },
	{ 0x231ee, 0x26496c },
	{ 0x231ef, 0x26496d },
	{ 0x231f0, 0x243823 },
	{ 0x231f1, 0x264976 },
	{ 0x231f2, 0x25392b },
	{ 0x231f3, 0x243827 },
	{ 0x231f6, 0x26496e },
	{ 0x231fa, 0x264975 },
	{ 0x231fb, 0x264977 },
	{ 0x231fc, 0x2f3b51 },
	{ 0x231fd, 0x2f3b53 },
	{ 0x231fe, 0x2f3b54 },
	{ 0x231ff, 0x2f3b56 },
	{ 0x23200, 0x2f3b57 },
	{ 0x23201, 0x2f3b59 },
	{ 0x23202, 0x2f3b5a },
	{ 0x23203, 0x2f3b5c },
	{ 0x23204, 0x2f3b5d },
	{ 0x23207, 0x2f3b52 },
	{ 0x23208, 0x2f3b58 },
	{ 0x2320d, 0x243826 },
	{ 0x2320f, 0x243828 },
	{ 0x2321f, 0x264972 },
	{ 0x23220, 0x25392c },
	{ 0x23221, 0x253928 },
	{ 0x23224, 0x265343 },
	{ 0x23225, 0x253f63 },
	{ 0x23226, 0x265341 },
	{ 0x23227, 0x265d53 },
	{ 0x23228, 0x265342 },
	{ 0x23229, 0x26533f },
	{ 0x2322a, 0x265344 },
	{ 0x2322e, 0x2f4639 },
	{ 0x23235, 0x2f3b5b },
	{ 0x23236, 0x26533e },
	{ 0x23237, 0x2f4170 },
	{ 0x23238, 0x2f4171 },
	{ 0x23239, 0x2f4173 },
	{ 0x2323a, 0x2f4174 },
	{ 0x2323b, 0x2f4175 },
	{ 0x2323c, 0x2f4176 },
	{ 0x2323d, 0x2f4177 },
	{ 0x2323e, 0x2f4178 },
	{ 0x23240, 0x2f4179 },
	{ 0x23241, 0x2f417a },
	{ 0x23242, 0x2f417b },
	{ 0x23243, 0x2f417d },
	{ 0x23244, 0x253d55 },
	{ 0x23248, 0x265345 },
	{ 0x2324a, 0x265340 },
	{ 0x23251, 0x253f64 },
	{ 0x23252, 0x25463b },
	{ 0x23253, 0x25463f },
	{ 0x23254, 0x25463d },
	{ 0x23255, 0x25463e },
	{ 0x23256, 0x265d56 },
	{ 0x23257, 0x254640 },
	{ 0x23258, 0x254643 },
	{ 0x23259, 0x254644 },
	{ 0x2325a, 0x24436c },
	{ 0x2325b, 0x254642 },
	{ 0x2325c, 0x254d4e },
	{ 0x23263, 0x2f484a },
	{ 0x23264, 0x2f484b },
	{ 0x23265, 0x2f484c },
	{ 0x23266, 0x2f484d },
	{ 0x23267, 0x2f484e },
	{ 0x23268, 0x2f484f },
	{ 0x23269, 0x265d54 },
	{ 0x2326a, 0x25463c },
	{ 0x2326b, 0x265d57 },
	{ 0x2326c, 0x265d59 },
	{ 0x2326d, 0x265d5a },
	{ 0x23270, 0x265d55 },
	{ 0x2327a, 0x265d58 },
	{ 0x2327b, 0x272361 },
	{ 0x2327c, 0x27235c },
	{ 0x2327d, 0x27235b },
	{ 0x2327e, 0x27235e },
	{ 0x2327f, 0x254d52 },
	{ 0x23281, 0x254d55 },
	{ 0x23282, 0x27235a },
	{ 0x23283, 0x272357 },
	{ 0x23284, 0x272358 },
	{ 0x23286, 0x272362 },
	{ 0x2328f, 0x2f4f37 },
	{ 0x23290, 0x2f4f39 },
	{ 0x23291, 0x2f4f3a },
	{ 0x23294, 0x254d54 },
	{ 0x23295, 0x272360 },
	{ 0x23296, 0x2f4e30 },
	{ 0x23299, 0x27235d },
	{ 0x2329a, 0x27235f },
	{ 0x2329b, 0x272359 },
	{ 0x2329d, 0x254d51 },
	{ 0x2329e, 0x255469 },
	{ 0x2329f, 0x25546b },
	{ 0x232a0, 0x272e57 },
	{ 0x232a1, 0x245055 },
	{ 0x232a3, 0x272e55 },
	{ 0x232a4, 0x272e5b },
	{ 0x232a5, 0x272e59 },
	{ 0x232a6, 0x272e5d },
	{ 0x232a7, 0x245054 },
	{ 0x232a8, 0x272e5c },
	{ 0x232ae, 0x272e54 },
	{ 0x232af, 0x2f5465 },
	{ 0x232b0, 0x2f5466 },
	{ 0x232b1, 0x2f5467 },
	{ 0x232b2, 0x2f5469 },
	{ 0x232b3, 0x2f546a },
	{ 0x232b4, 0x272e58 },
	{ 0x232b6, 0x254d4f },
	{ 0x232b8, 0x272d62 },
	{ 0x232ba, 0x2f5468 },
	{ 0x232bd, 0x272e43 },
	{ 0x232c4, 0x25546a },
	{ 0x232c5, 0x272e56 },
	{ 0x232c8, 0x2f4f38 },
	{ 0x232c9, 0x273847 },
	{ 0x232ca, 0x255b60 },
	{ 0x232cb, 0x255b61 },
	{ 0x232cc, 0x273848 },
	{ 0x232cd, 0x255b62 },
	{ 0x232cf, 0x273845 },
	{ 0x232d0, 0x273846 },
	{ 0x232d3, 0x273849 },
	{ 0x232d4, 0x2f5a3a },
	{ 0x232d5, 0x2f5a3b },
	{ 0x232d6, 0x2f5a3c },
	{ 0x232d7, 0x273844 },
	{ 0x232d8, 0x2f5a3d },
	{ 0x232de, 0x245b3e },
	{ 0x232df, 0x256172 },
	{ 0x232e3, 0x256173 },
	{ 0x232e5, 0x273f75 },
	{ 0x232ea, 0x2f5e76 },
	{ 0x232eb, 0x2f5e77 },
	{ 0x232ec, 0x2f5e78 },
	{ 0x232ed, 0x2f5e79 },
	{ 0x232ee, 0x2f5e7b },
	{ 0x232ef, 0x273f78 },
	{ 0x232f2, 0x256823 },
	{ 0x232f3, 0x27473d },
	{ 0x232f4, 0x27473c },
	{ 0x232f5, 0x256822 },
	{ 0x232f6, 0x256824 },
	{ 0x232f7, 0x27473b },
	{ 0x232f8, 0x27473e },
	{ 0x232fa, 0x2f624d },
	{ 0x232ff, 0x256c37 },
	{ 0x23303, 0x2f6531 },
	{ 0x23304, 0x2f6532 },
	{ 0x23305, 0x256b6e },
	{ 0x23307, 0x274d79 },
	{ 0x23308, 0x275346 },
	{ 0x2330d, 0x275821 },
	{ 0x2330e, 0x2f6946 },
	{ 0x2330f, 0x257339 },
	{ 0x23313, 0x257349 },
	{ 0x23316, 0x275b5c },
	{ 0x23317, 0x25775e },
	{ 0x23318, 0x275e6d },
	{ 0x23319, 0x2f6b4d },
	{ 0x2331c, 0x25792b },
	{ 0x2331f, 0x276447 },
	{ 0x23322, 0x2f244d },
	{ 0x23323, 0x262b7e },
	{ 0x23324, 0x2f273f },
	{ 0x23325, 0x2f2740 },
	{ 0x23326, 0x262c21 },
	{ 0x23327, 0x252953 },
	{ 0x23328, 0x252952 },
	{ 0x23329, 0x263170 },
	{ 0x2332a, 0x2f2b37 },
	{ 0x2332b, 0x2f2b39 },
	{ 0x2332c, 0x26316f },
	{ 0x2332d, 0x263842 },
	{ 0x2332f, 0x2f2f6f },
	{ 0x23330, 0x2f2f70 },
	{ 0x23331, 0x2f2f71 },
	{ 0x23332, 0x2f2f72 },
	{ 0x23333, 0x2f2f73 },
	{ 0x23337, 0x2f3549 },
	{ 0x23338, 0x2f354a },
	{ 0x2333b, 0x2f3b5f },
	{ 0x2333c, 0x26497a },
	{ 0x2333d, 0x264979 },
	{ 0x2333e, 0x253f65 },
	{ 0x23343, 0x244370 },
	{ 0x23344, 0x265346 },
	{ 0x23346, 0x254d57 },
	{ 0x23347, 0x254d56 },
	{ 0x23348, 0x272363 },
	{ 0x2334c, 0x2f546b },
	{ 0x2334f, 0x255b63 },
	{ 0x23351, 0x273f7a },
	{ 0x23352, 0x256174 },
	{ 0x23353, 0x273f79 },
	{ 0x23354, 0x273f77 },
	{ 0x23356, 0x245f6d },
	{ 0x23358, 0x274d7a },
	{ 0x23359, 0x274d7b },
	{ 0x2335b, 0x257b3f },
	{ 0x2335c, 0x27663e },
	{ 0x2335d, 0x26232d },
	{ 0x2335e, 0x26247d },
	{ 0x2335f, 0x252444 },
	{ 0x23360, 0x262829 },
	{ 0x23361, 0x262827 },
	{ 0x23362, 0x262828 },
	{ 0x23363, 0x262826 },
	{ 0x23364, 0x262c22 },
	{ 0x23365, 0x252954 },
	{ 0x23366, 0x242969 },
	{ 0x23367, 0x24296a },
	{ 0x2336b, 0x2f2b3a },
	{ 0x2336c, 0x263171 },
	{ 0x2336e, 0x263843 },
	{ 0x23373, 0x2f354b },
	{ 0x23374, 0x253276 },
	{ 0x23375, 0x264059 },
	{ 0x23376, 0x26405b },
	{ 0x23377, 0x26497d },
	{ 0x23378, 0x26497c },
	{ 0x23379, 0x26405a },
	{ 0x2337a, 0x25392d },
	{ 0x2337c, 0x2f3946 },
	{ 0x23381, 0x2f3b61 },
	{ 0x23382, 0x2f3b62 },
	{ 0x23384, 0x265347 },
	{ 0x23385, 0x253f67 },
	{ 0x23389, 0x2f3b60 },
	{ 0x2338a, 0x2f417e },
	{ 0x2338b, 0x2f4221 },
	{ 0x2338c, 0x265348 },
	{ 0x2338d, 0x265d5d },
	{ 0x23390, 0x265d5e },
	{ 0x23392, 0x272364 },
	{ 0x23393, 0x244a34 },
	{ 0x23394, 0x254d59 },
	{ 0x23397, 0x244a33 },
	{ 0x23398, 0x2f4f3b },
	{ 0x23399, 0x2f4f3c },
	{ 0x2339a, 0x25546e },
	{ 0x2339b, 0x25546c },
	{ 0x2339c, 0x255b64 },
	{ 0x2339f, 0x25546d },
	{ 0x233a0, 0x2f546d },
	{ 0x233a1, 0x2f546e },
	{ 0x233a3, 0x27384b },
	{ 0x233a4, 0x27384a },
	{ 0x233a5, 0x2f5a3e },
	{ 0x233a9, 0x256175 },
	{ 0x233ac, 0x2f5e7c },
	{ 0x233ad, 0x273f7b },
	{ 0x233ae, 0x256c38 },
	{ 0x233b1, 0x25756f },
	{ 0x233b2, 0x25775f },
	{ 0x233b3, 0x252148 },
	{ 0x233b4, 0x24214e },
	{ 0x233b5, 0x24217d },
	{ 0x233b6, 0x2f2165 },
	{ 0x233b8, 0x252275 },
	{ 0x233b9, 0x262522 },
	{ 0x233ba, 0x252274 },
	{ 0x233bb, 0x26247e },
	{ 0x233bc, 0x262521 },
	{ 0x233bd, 0x2f2256 },
	{ 0x233bf, 0x24227b },
	{ 0x233c0, 0x24227a },
	{ 0x233c1, 0x26282c },
	{ 0x233c2, 0x242449 },
	{ 0x233c3, 0x26282a },
	{ 0x233c5, 0x26282b },
	{ 0x233c6, 0x2f244e },
	{ 0x233c7, 0x2f244f },
	{ 0x233c8, 0x2f2454 },
	{ 0x233c9, 0x2f2450 },
	{ 0x233ca, 0x2f2452 },
	{ 0x233cb, 0x252446 },
	{ 0x233d0, 0x26282d },
	{ 0x233d1, 0x252445 },
	{ 0x233d2, 0x242445 },
	{ 0x233d4, 0x24266b },
	{ 0x233d5, 0x25264c },
	{ 0x233d6, 0x242666 },
	{ 0x233d7, 0x25264b },
	{ 0x233d8, 0x262c2b },
	{ 0x233d9, 0x252650 },
	{ 0x233da, 0x252652 },
	{ 0x233db, 0x262c28 },
	{ 0x233dc, 0x262c27 },
	{ 0x233dd, 0x262c26 },
	{ 0x233de, 0x25264d },
	{ 0x233df, 0x252653 },
	{ 0x233e0, 0x25264f },
	{ 0x233e1, 0x25264e },
	{ 0x233e5, 0x2f2743 },
	{ 0x233e7, 0x2f2745 },
	{ 0x233e8, 0x2f2746 },
	{ 0x233e9, 0x2f2747 },
	{ 0x233ea, 0x2f2749 },
	{ 0x233eb, 0x2f274a },
	{ 0x233ec, 0x2f274b },
	{ 0x233ed, 0x2f274d },
	{ 0x233ee, 0x2f274f },
	{ 0x233ef, 0x2f2751 },
	{ 0x233f0, 0x2f2754 },
	{ 0x233f1, 0x2f2755 },
	{ 0x233f2, 0x262c24 },
	{ 0x233f3, 0x262c29 },
	{ 0x233f6, 0x252654 },
	{ 0x233f8, 0x262c2c },
	{ 0x233f9, 0x2f2744 },
	{ 0x233fb, 0x262c2d },
	{ 0x233fd, 0x262c2a },
	{ 0x233fe, 0x2f2748 },
	{ 0x23400, 0x2f2742 },
	{ 0x23401, 0x262c25 },
	{ 0x23403, 0x252655 },
	{ 0x23407, 0x262d5c },
	{ 0x23408, 0x263174 },
	{ 0x23409, 0x263173 },
	{ 0x2340a, 0x24296b },
	{ 0x2340b, 0x252956 },
	{ 0x2340c, 0x263175 },
	{ 0x2340d, 0x263176 },
	{ 0x2340e, 0x252955 },
	{ 0x2340f, 0x252959 },
	{ 0x23410, 0x263177 },
	{ 0x23411, 0x252e26 },
	{ 0x23412, 0x25295a },
	{ 0x23413, 0x252958 },
	{ 0x23417, 0x2f2753 },
	{ 0x23418, 0x2f2b3b },
	{ 0x23419, 0x2f2b3c },
	{ 0x2341a, 0x2f2b3d },
	{ 0x2341b, 0x2f2b3f },
	{ 0x2341c, 0x2f2b40 },
	{ 0x2341d, 0x2f2b41 },
	{ 0x2341e, 0x2f2b42 },
	{ 0x2341f, 0x2f2b43 },
	{ 0x23420, 0x2f2b44 },
	{ 0x23421, 0x2f2b45 },
	{ 0x23422, 0x2f2b46 },
	{ 0x23423, 0x2f2b47 },
	{ 0x23424, 0x2f2b49 },
	{ 0x23425, 0x2f2b4a },
	{ 0x23426, 0x2f2b4b },
	{ 0x23427, 0x2f2b4c },
	{ 0x23428, 0x2f2b4d },
	{ 0x23429, 0x2f2b4e },
	{ 0x2342a, 0x2f2b4f },
	{ 0x23430, 0x25295b },
	{ 0x23435, 0x26405c },
	{ 0x23436, 0x26384f },
	{ 0x23437, 0x263853 },
	{ 0x23438, 0x26384b },
	{ 0x23439, 0x26384d },
	{ 0x2343a, 0x263846 },
	{ 0x2343b, 0x252e27 },
	{ 0x2343c, 0x263848 },
	{ 0x2343d, 0x263845 },
	{ 0x2343e, 0x263851 },
	{ 0x2343f, 0x242d50 },
	{ 0x23440, 0x26405d },
	{ 0x23441, 0x252957 },
	{ 0x23442, 0x252e29 },
	{ 0x23443, 0x252e2a },
	{ 0x23444, 0x263844 },
	{ 0x2344f, 0x2f2f74 },
	{ 0x23451, 0x2f2f75 },
	{ 0x23452, 0x2f2f76 },
	{ 0x23453, 0x2f2f78 },
	{ 0x23454, 0x2f2f79 },
	{ 0x23455, 0x2f2f7a },
	{ 0x23456, 0x2f2f7b },
	{ 0x23457, 0x2f2f7c },
	{ 0x23458, 0x2f2f7d },
	{ 0x23459, 0x2f2f7e },
	{ 0x2345a, 0x2f3021 },
	{ 0x2345b, 0x2f3022 },
	{ 0x2345c, 0x2f3023 },
	{ 0x2345d, 0x2f3025 },
	{ 0x2345e, 0x2f3026 },
	{ 0x2345f, 0x2f3027 },
	{ 0x23460, 0x2f3029 },
	{ 0x23461, 0x2f302a },
	{ 0x23462, 0x2f302b },
	{ 0x23463, 0x2f302c },
	{ 0x23464, 0x2f302e },
	{ 0x23465, 0x26384c },
	{ 0x23468, 0x263847 },
	{ 0x2346a, 0x263849 },
	{ 0x2346b, 0x242d53 },
	{ 0x2346d, 0x26384e },
	{ 0x2346e, 0x2f3030 },
	{ 0x2346f, 0x2f3028 },
	{ 0x23471, 0x242d5a },
	{ 0x23472, 0x2f302d },
	{ 0x23478, 0x252e2c },
	{ 0x23479, 0x252e28 },
	{ 0x2347d, 0x2f2f77 },
	{ 0x2347e, 0x263852 },
	{ 0x2347f, 0x264068 },
	{ 0x23480, 0x264069 },
	{ 0x23481, 0x26405f },
	{ 0x23482, 0x253277 },
	{ 0x23483, 0x253321 },
	{ 0x23484, 0x253936 },
	{ 0x23485, 0x243245 },
	{ 0x23486, 0x243240 },
	{ 0x23487, 0x25327d },
	{ 0x23488, 0x264067 },
	{ 0x23489, 0x264a2e },
	{ 0x2348f, 0x264063 },
	{ 0x23490, 0x2f354c },
	{ 0x23491, 0x2f354d },
	{ 0x23492, 0x2f354f },
	{ 0x23493, 0x2f3550 },
	{ 0x23494, 0x2f3551 },
	{ 0x23495, 0x2f3552 },
	{ 0x23496, 0x2f3553 },
	{ 0x23497, 0x2f3554 },
	{ 0x23498, 0x2f3555 },
	{ 0x23499, 0x2f3556 },
	{ 0x2349a, 0x2f3558 },
	{ 0x2349b, 0x2f3559 },
	{ 0x2349c, 0x2f355a },
	{ 0x2349d, 0x2f355b },
	{ 0x2349e, 0x2f355c },
	{ 0x2349f, 0x2f355d },
	{ 0x234a0, 0x2f355e },
	{ 0x234a1, 0x2f355f },
	{ 0x234a2, 0x2f3560 },
	{ 0x234a3, 0x2f3561 },
	{ 0x234a4, 0x2f3562 },
	{ 0x234a5, 0x2f3563 },
	{ 0x234a6, 0x2f3565 },
	{ 0x234a7, 0x2f3566 },
	{ 0x234a8, 0x264064 },
	{ 0x234a9, 0x264066 },
	{ 0x234aa, 0x264065 },
	{ 0x234ab, 0x243247 },
	{ 0x234ac, 0x264062 },
	{ 0x234ad, 0x264060 },
	{ 0x234af, 0x264061 },
	{ 0x234b6, 0x243244 },
	{ 0x234b7, 0x253322 },
	{ 0x234b8, 0x253278 },
	{ 0x234b9, 0x25327b },
	{ 0x234ba, 0x25327a },
	{ 0x234bb, 0x25327c },
	{ 0x234bc, 0x26406a },
	{ 0x234bf, 0x2f354e },
	{ 0x234c0, 0x26405e },
	{ 0x234c1, 0x243836 },
	{ 0x234c2, 0x264a34 },
	{ 0x234c3, 0x253935 },
	{ 0x234c4, 0x265349 },
	{ 0x234c5, 0x24382e },
	{ 0x234c6, 0x253938 },
	{ 0x234c7, 0x264a22 },
	{ 0x234c8, 0x253932 },
	{ 0x234c9, 0x24382b },
	{ 0x234ca, 0x253930 },
	{ 0x234cb, 0x253934 },
	{ 0x234cc, 0x243831 },
	{ 0x234cd, 0x264a2d },
	{ 0x234ce, 0x264a2f },
	{ 0x234cf, 0x25393a },
	{ 0x234d0, 0x264a24 },
	{ 0x234d1, 0x264a21 },
	{ 0x234d2, 0x253937 },
	{ 0x234d3, 0x264a33 },
	{ 0x234d4, 0x25393c },
	{ 0x234d5, 0x25393b },
	{ 0x234d6, 0x264a26 },
	{ 0x234d7, 0x243830 },
	{ 0x234d8, 0x264a27 },
	{ 0x234d9, 0x264a2a },
	{ 0x234da, 0x264a31 },
	{ 0x234db, 0x253940 },
	{ 0x234dc, 0x26534a },
	{ 0x234dd, 0x25393d },
	{ 0x234de, 0x264a38 },
	{ 0x234df, 0x264a23 },
	{ 0x234e0, 0x264a25 },
	{ 0x234e1, 0x264a35 },
	{ 0x234e7, 0x243833 },
	{ 0x234e8, 0x243838 },
	{ 0x234e9, 0x264a36 },
	{ 0x234ea, 0x264a37 },
	{ 0x234eb, 0x2f3b64 },
	{ 0x234ec, 0x2f3b65 },
	{ 0x234ed, 0x2f3b67 },
	{ 0x234ee, 0x2f3b68 },
	{ 0x234ef, 0x2f3b69 },
	{ 0x234f0, 0x2f3b6b },
	{ 0x234f1, 0x2f3b6c },
	{ 0x234f2, 0x2f3b6d },
	{ 0x234f3, 0x2f3b6f },
	{ 0x234f4, 0x2f3b71 },
	{ 0x234f5, 0x2f3b72 },
	{ 0x234f6, 0x2f3b74 },
	{ 0x234f7, 0x2f3b75 },
	{ 0x234f8, 0x2f3b76 },
	{ 0x234f9, 0x2f3b77 },
	{ 0x234fa, 0x2f3b78 },
	{ 0x234fb, 0x2f3b79 },
	{ 0x234fc, 0x2f3b7a },
	{ 0x234fd, 0x2f3b7b },
	{ 0x234fe, 0x2f3b7c },
	{ 0x234ff, 0x2f3b7d },
	{ 0x23500, 0x2f3b7e },
	{ 0x23501, 0x2f3c22 },
	{ 0x23502, 0x2f3c23 },
	{ 0x23503, 0x2f3c24 },
	{ 0x23504, 0x2f3c25 },
	{ 0x23505, 0x2f3c26 },
	{ 0x23506, 0x2f3c27 },
	{ 0x23507, 0x2f3c28 },
	{ 0x23508, 0x2f3c2a },
	{ 0x23509, 0x2f3c2b },
	{ 0x2350a, 0x2f3c2c },
	{ 0x2350b, 0x2f3c2d },
	{ 0x2350c, 0x2f3c2e },
	{ 0x2350d, 0x2f3c2f },
	{ 0x2350e, 0x264a29 },
	{ 0x2350f, 0x264a2b },
	{ 0x23511, 0x264a2c },
	{ 0x23512, 0x264a32 },
	{ 0x23513, 0x253942 },
	{ 0x23514, 0x264a30 },
	{ 0x23515, 0x264a39 },
	{ 0x23516, 0x264a28 },
	{ 0x2352b, 0x25393e },
	{ 0x2352c, 0x253941 },
	{ 0x2352d, 0x25392e },
	{ 0x2352e, 0x25392f },
	{ 0x2352f, 0x253931 },
	{ 0x23531, 0x26534e },
	{ 0x23532, 0x265358 },
	{ 0x23533, 0x243d77 },
	{ 0x23534, 0x265356 },
	{ 0x23535, 0x243d74 },
	{ 0x23536, 0x265357 },
	{ 0x23537, 0x253f6f },
	{ 0x23538, 0x253f6a },
	{ 0x23539, 0x253f6e },
	{ 0x2353a, 0x253f6b },
	{ 0x2353b, 0x243d6a },
	{ 0x2353c, 0x26535b },
	{ 0x2353d, 0x253f73 },
	{ 0x2353e, 0x265361 },
	{ 0x2353f, 0x253f68 },
	{ 0x23540, 0x243d7a },
	{ 0x23541, 0x253f74 },
	{ 0x23542, 0x253f69 },
	{ 0x23543, 0x265355 },
	{ 0x23544, 0x253f70 },
	{ 0x23545, 0x253f6d },
	{ 0x23546, 0x265360 },
	{ 0x23547, 0x243d73 },
	{ 0x23548, 0x265359 },
	{ 0x23549, 0x26535a },
	{ 0x2354a, 0x26535d },
	{ 0x2354b, 0x265350 },
	{ 0x2354c, 0x243d70 },
	{ 0x2354d, 0x26535c },
	{ 0x2354e, 0x253f6c },
	{ 0x23550, 0x265363 },
	{ 0x23551, 0x26534f },
	{ 0x23552, 0x265351 },
	{ 0x23553, 0x26534c },
	{ 0x23559, 0x2f4223 },
	{ 0x2355b, 0x2f4224 },
	{ 0x2355c, 0x2f4225 },
	{ 0x2355d, 0x2f4226 },
	{ 0x2355e, 0x2f4227 },
	{ 0x2355f, 0x2f4229 },
	{ 0x23560, 0x2f422a },
	{ 0x23561, 0x2f422b },
	{ 0x23562, 0x2f422c },
	{ 0x23563, 0x2f422d },
	{ 0x23564, 0x2f422e },
	{ 0x23565, 0x2f4230 },
	{ 0x23566, 0x2f4231 },
	{ 0x23567, 0x2f4232 },
	{ 0x23568, 0x2f4233 },
	{ 0x23569, 0x2f4234 },
	{ 0x2356a, 0x2f4235 },
	{ 0x2356b, 0x2f4236 },
	{ 0x2356c, 0x2f4238 },
	{ 0x2356d, 0x2f4239 },
	{ 0x2356e, 0x2f423a },
	{ 0x2356f, 0x2f423b },
	{ 0x23570, 0x2f423d },
	{ 0x23571, 0x2f423e },
	{ 0x23572, 0x2f423f },
	{ 0x23573, 0x2f4240 },
	{ 0x23574, 0x2f4241 },
	{ 0x23575, 0x2f4242 },
	{ 0x23576, 0x2f4243 },
	{ 0x23577, 0x2f4244 },
	{ 0x23578, 0x2f4245 },
	{ 0x23579, 0x2f4246 },
	{ 0x2357a, 0x2f4248 },
	{ 0x2357b, 0x2f424a },
	{ 0x2357c, 0x2f424c },
	{ 0x2357f, 0x26534d },
	{ 0x23580, 0x265352 },
	{ 0x23581, 0x265354 },
	{ 0x23582, 0x243d79 },
	{ 0x23583, 0x265362 },
	{ 0x23587, 0x26534b },
	{ 0x2358a, 0x26535f },
	{ 0x23590, 0x2f4222 },
	{ 0x23593, 0x2f422f },
	{ 0x23595, 0x2f4237 },
	{ 0x235a3, 0x25393f },
	{ 0x235a4, 0x253f72 },
	{ 0x235a5, 0x265353 },
	{ 0x235a6, 0x2f4374 },
	{ 0x235a8, 0x25464e },
	{ 0x235a9, 0x2f424b },
	{ 0x235aa, 0x254650 },
	{ 0x235ab, 0x24437b },
	{ 0x235ac, 0x244372 },
	{ 0x235ad, 0x25464d },
	{ 0x235ae, 0x25464f },
	{ 0x235af, 0x265d69 },
	{ 0x235b0, 0x254655 },
	{ 0x235b1, 0x254652 },
	{ 0x235b2, 0x272365 },
	{ 0x235b4, 0x265364 },
	{ 0x235b5, 0x254647 },
	{ 0x235b6, 0x265d5f },
	{ 0x235b7, 0x254654 },
	{ 0x235b8, 0x254646 },
	{ 0x235b9, 0x254658 },
	{ 0x235ba, 0x265d62 },
	{ 0x235bb, 0x25464a },
	{ 0x235bc, 0x254653 },
	{ 0x235bd, 0x265d63 },
	{ 0x235be, 0x244376 },
	{ 0x235bf, 0x254648 },
	{ 0x235c1, 0x254649 },
	{ 0x235c2, 0x265d65 },
	{ 0x235c3, 0x25464c },
	{ 0x235d0, 0x254651 },
	{ 0x235d4, 0x2f4857 },
	{ 0x235d5, 0x2f4858 },
	{ 0x235d6, 0x2f4859 },
	{ 0x235d7, 0x2f485a },
	{ 0x235d8, 0x2f485b },
	{ 0x235d9, 0x2f485c },
	{ 0x235da, 0x2f485d },
	{ 0x235db, 0x2f485e },
	{ 0x235dc, 0x2f485f },
	{ 0x235dd, 0x2f4860 },
	{ 0x235de, 0x2f4861 },
	{ 0x235df, 0x2f4862 },
	{ 0x235e0, 0x2f4863 },
	{ 0x235e1, 0x2f4864 },
	{ 0x235e2, 0x2f4865 },
	{ 0x235e3, 0x2f4866 },
	{ 0x235e4, 0x2f4867 },
	{ 0x235e5, 0x2f4868 },
	{ 0x235e6, 0x2f4869 },
	{ 0x235e7, 0x2f486a },
	{ 0x235e8, 0x2f486b },
	{ 0x235e9, 0x2f486c },
	{ 0x235ea, 0x2f486d },
	{ 0x235eb, 0x2f486e },
	{ 0x235ec, 0x2f486f },
	{ 0x235ed, 0x2f4871 },
	{ 0x235ee, 0x2f4872 },
	{ 0x235ef, 0x2f4873 },
	{ 0x235f0, 0x2f4875 },
	{ 0x235f3, 0x23474b },
	{ 0x235f4, 0x265d6a },
	{ 0x235f5, 0x265d67 },
	{ 0x235f7, 0x265d6b },
	{ 0x235f8, 0x265d6c },
	{ 0x235fa, 0x254656 },
	{ 0x235fb, 0x254657 },
	{ 0x23600, 0x2f4874 },
	{ 0x23605, 0x265d64 },
	{ 0x23607, 0x265d66 },
	{ 0x2360b, 0x2f4850 },
	{ 0x2360d, 0x2f4851 },
	{ 0x2360e, 0x2f4853 },
	{ 0x2360f, 0x2f4854 },
	{ 0x23610, 0x265d60 },
	{ 0x23611, 0x265d6d },
	{ 0x23612, 0x265d61 },
	{ 0x23614, 0x2f4856 },
	{ 0x23615, 0x272368 },
	{ 0x23616, 0x254d67 },
	{ 0x23617, 0x254d5e },
	{ 0x23618, 0x244a3b },
	{ 0x23619, 0x244a47 },
	{ 0x2361a, 0x254d5b },
	{ 0x2361b, 0x244a40 },
	{ 0x2361c, 0x272371 },
	{ 0x2361d, 0x27236c },
	{ 0x2361e, 0x272374 },
	{ 0x2361f, 0x254d6b },
	{ 0x23620, 0x254d65 },
	{ 0x23621, 0x272370 },
	{ 0x23622, 0x244a46 },
	{ 0x23623, 0x254d5f },
	{ 0x23624, 0x244a3f },
	{ 0x23625, 0x254d64 },
	{ 0x23626, 0x244a43 },
	{ 0x23627, 0x244a3e },
	{ 0x23628, 0x244a35 },
	{ 0x23629, 0x272373 },
	{ 0x2362a, 0x254d5c },
	{ 0x2362b, 0x244a4a },
	{ 0x2362c, 0x254d69 },
	{ 0x2362d, 0x27236e },
	{ 0x2362e, 0x254d63 },
	{ 0x2362f, 0x254d6a },
	{ 0x23630, 0x272369 },
	{ 0x23631, 0x244a41 },
	{ 0x23632, 0x254d5d },
	{ 0x23633, 0x272375 },
	{ 0x2363b, 0x244a3c },
	{ 0x2363f, 0x244a45 },
	{ 0x23641, 0x244a49 },
	{ 0x23642, 0x272366 },
	{ 0x23643, 0x27236a },
	{ 0x23644, 0x2f4f3d },
	{ 0x23645, 0x2f4f3e },
	{ 0x23646, 0x2f4f3f },
	{ 0x23647, 0x2f4f43 },
	{ 0x23648, 0x2f4f44 },
	{ 0x23649, 0x2f4f46 },
	{ 0x2364a, 0x2f4f47 },
	{ 0x2364b, 0x2f4f48 },
	{ 0x2364c, 0x2f4f49 },
	{ 0x2364d, 0x2f4f4a },
	{ 0x2364e, 0x2f4f4b },
	{ 0x2364f, 0x2f4f4c },
	{ 0x23650, 0x2f4f4d },
	{ 0x23651, 0x2f4f4e },
	{ 0x23652, 0x2f4f4f },
	{ 0x23653, 0x2f4f50 },
	{ 0x23654, 0x2f4f51 },
	{ 0x23655, 0x2f4f52 },
	{ 0x23656, 0x2f4f53 },
	{ 0x23659, 0x2f4f40 },
	{ 0x2365b, 0x27236b },
	{ 0x23664, 0x254d6c },
	{ 0x23670, 0x254d68 },
	{ 0x23671, 0x254d66 },
	{ 0x23672, 0x272367 },
	{ 0x23673, 0x27236d },
	{ 0x23674, 0x254d60 },
	{ 0x23675, 0x254d5a },
	{ 0x23676, 0x254d62 },
	{ 0x2367b, 0x24505b },
	{ 0x2367c, 0x25547d },
	{ 0x2367d, 0x272e69 },
	{ 0x2367e, 0x245065 },
	{ 0x2367f, 0x245058 },
	{ 0x23680, 0x255b65 },
	{ 0x23681, 0x27384c },
	{ 0x23682, 0x272e60 },
	{ 0x23683, 0x272e63 },
	{ 0x23684, 0x25547b },
	{ 0x23685, 0x272e68 },
	{ 0x23686, 0x272e72 },
	{ 0x23687, 0x25547a },
	{ 0x23688, 0x272e6f },
	{ 0x23689, 0x272e62 },
	{ 0x2368a, 0x245062 },
	{ 0x2368b, 0x24564c },
	{ 0x2368c, 0x245057 },
	{ 0x2368d, 0x272e5f },
	{ 0x2368e, 0x24505f },
	{ 0x2368f, 0x255479 },
	{ 0x23690, 0x272e67 },
	{ 0x23691, 0x272e64 },
	{ 0x23692, 0x255471 },
	{ 0x23694, 0x255477 },
	{ 0x23695, 0x24505c },
	{ 0x23696, 0x272e6e },
	{ 0x23697, 0x272e74 },
	{ 0x23698, 0x255478 },
	{ 0x23699, 0x24505d },
	{ 0x2369a, 0x272e66 },
	{ 0x2369b, 0x272e6b },
	{ 0x2369c, 0x245063 },
	{ 0x2369d, 0x255470 },
	{ 0x2369e, 0x272e61 },
	{ 0x2369f, 0x25617b },
	{ 0x236a0, 0x255475 },
	{ 0x236a1, 0x255476 },
	{ 0x236a2, 0x255472 },
	{ 0x236a3, 0x244a44 },
	{ 0x236a4, 0x272e73 },
	{ 0x236a5, 0x272e6c },
	{ 0x236a6, 0x272e65 },
	{ 0x236a8, 0x272e5e },
	{ 0x236a9, 0x25547c },
	{ 0x236aa, 0x25546f },
	{ 0x236af, 0x255473 },
	{ 0x236b0, 0x2f546f },
	{ 0x236b1, 0x2f5470 },
	{ 0x236b2, 0x2f5471 },
	{ 0x236b3, 0x2f5472 },
	{ 0x236b4, 0x2f5473 },
	{ 0x236b5, 0x2f5475 },
	{ 0x236b6, 0x2f5476 },
	{ 0x236b7, 0x2f5477 },
	{ 0x236b8, 0x2f5478 },
	{ 0x236b9, 0x2f5479 },
	{ 0x236ba, 0x2f547a },
	{ 0x236bb, 0x2f547c },
	{ 0x236bc, 0x2f547d },
	{ 0x236bd, 0x2f547e },
	{ 0x236be, 0x2f5521 },
	{ 0x236bf, 0x2f5522 },
	{ 0x236c0, 0x2f5524 },
	{ 0x236c1, 0x2f5525 },
	{ 0x236c2, 0x2f5526 },
	{ 0x236c3, 0x2f5527 },
	{ 0x236c4, 0x2f5528 },
	{ 0x236c5, 0x2f552b },
	{ 0x236c6, 0x2f552c },
	{ 0x236c7, 0x2f552d },
	{ 0x236c8, 0x2f552e },
	{ 0x236c9, 0x2f552f },
	{ 0x236ca, 0x2f5530 },
	{ 0x236cb, 0x2f5532 },
	{ 0x236cc, 0x2f5533 },
	{ 0x236cd, 0x2f5534 },
	{ 0x236ce, 0x2f5535 },
	{ 0x236cf, 0x2f5536 },
	{ 0x236d0, 0x2f5537 },
	{ 0x236d1, 0x2f5538 },
	{ 0x236d6, 0x272e70 },
	{ 0x236d8, 0x272e71 },
	{ 0x236da, 0x245061 },
	{ 0x236df, 0x2f5523 },
	{ 0x236eb, 0x255474 },
	{ 0x236ec, 0x2f4870 },
	{ 0x236ee, 0x2f4f41 },
	{ 0x236f0, 0x272e6d },
	{ 0x236f1, 0x245643 },
	{ 0x236f2, 0x273850 },
	{ 0x236f3, 0x27384e },
	{ 0x236f4, 0x245647 },
	{ 0x236f5, 0x273852 },
	{ 0x236f6, 0x273856 },
	{ 0x236f7, 0x255b6a },
	{ 0x236f8, 0x255b6b },
	{ 0x236f9, 0x24564a },
	{ 0x236fa, 0x245646 },
	{ 0x236fb, 0x255b6e },
	{ 0x236fc, 0x273853 },
	{ 0x236fd, 0x255b6c },
	{ 0x236ff, 0x273851 },
	{ 0x23700, 0x273857 },
	{ 0x23701, 0x25617c },
	{ 0x23702, 0x255b67 },
	{ 0x23703, 0x24564d },
	{ 0x23704, 0x245644 },
	{ 0x23705, 0x273859 },
	{ 0x23706, 0x245642 },
	{ 0x23707, 0x255b69 },
	{ 0x23708, 0x27385b },
	{ 0x2370d, 0x255b66 },
	{ 0x2370e, 0x273854 },
	{ 0x2370f, 0x2f5a40 },
	{ 0x23710, 0x2f5a41 },
	{ 0x23711, 0x2f5a43 },
	{ 0x23712, 0x2f5a44 },
	{ 0x23713, 0x2f5a45 },
	{ 0x23714, 0x2f5a46 },
	{ 0x23715, 0x2f5a47 },
	{ 0x23716, 0x2f5a48 },
	{ 0x23717, 0x2f5a49 },
	{ 0x23718, 0x2f5a4a },
	{ 0x23719, 0x2f5a4b },
	{ 0x2371a, 0x2f5a4c },
	{ 0x2371b, 0x2f5a4e },
	{ 0x2371c, 0x2f5a4f },
	{ 0x2371d, 0x2f5a51 },
	{ 0x2371e, 0x2f5a52 },
	{ 0x2371f, 0x2f5a54 },
	{ 0x23723, 0x273858 },
	{ 0x23724, 0x255b6d },
	{ 0x23725, 0x27385a },
	{ 0x23726, 0x27384d },
	{ 0x23727, 0x27384f },
	{ 0x23728, 0x273727 },
	{ 0x2372c, 0x2f5a53 },
	{ 0x2372f, 0x2f5a4d },
	{ 0x23739, 0x255b6f },
	{ 0x2373a, 0x255b70 },
	{ 0x2373c, 0x2f5531 },
	{ 0x2373f, 0x2f5a50 },
	{ 0x23741, 0x245b47 },
	{ 0x23742, 0x256178 },
	{ 0x23743, 0x274027 },
	{ 0x23744, 0x274023 },
	{ 0x23745, 0x245b42 },
	{ 0x23746, 0x27402b },
	{ 0x23747, 0x256224 },
	{ 0x23748, 0x25617d },
	{ 0x23749, 0x256226 },
	{ 0x2374a, 0x274029 },
	{ 0x2374b, 0x245b45 },
	{ 0x2374c, 0x25617a },
	{ 0x2374d, 0x256222 },
	{ 0x2374e, 0x256227 },
	{ 0x2374f, 0x25617e },
	{ 0x23750, 0x27385c },
	{ 0x23751, 0x25622b },
	{ 0x23752, 0x256179 },
	{ 0x23753, 0x245b43 },
	{ 0x23754, 0x245b4c },
	{ 0x23755, 0x245b46 },
	{ 0x23756, 0x27402d },
	{ 0x23757, 0x274028 },
	{ 0x23758, 0x256223 },
	{ 0x23759, 0x274746 },
	{ 0x2375a, 0x256229 },
	{ 0x2375b, 0x274026 },
	{ 0x2375c, 0x245b4b },
	{ 0x2375d, 0x256228 },
	{ 0x2375e, 0x256225 },
	{ 0x23765, 0x256176 },
	{ 0x23767, 0x273f7c },
	{ 0x23768, 0x273f7d },
	{ 0x23769, 0x2f5e7e },
	{ 0x2376a, 0x2f5f22 },
	{ 0x2376b, 0x2f5f23 },
	{ 0x2376c, 0x2f5f24 },
	{ 0x2376d, 0x2f5f25 },
	{ 0x2376e, 0x2f5f26 },
	{ 0x2376f, 0x2f5f27 },
	{ 0x23770, 0x2f5f28 },
	{ 0x23771, 0x2f5f2a },
	{ 0x23772, 0x2f5f2b },
	{ 0x23773, 0x2f5f2c },
	{ 0x23774, 0x2f5f2e },
	{ 0x23775, 0x2f5f2f },
	{ 0x23776, 0x2f5f30 },
	{ 0x23777, 0x274021 },
	{ 0x23779, 0x274025 },
	{ 0x2377b, 0x27402c },
	{ 0x2377c, 0x27402a },
	{ 0x2377e, 0x256221 },
	{ 0x23781, 0x2f5f21 },
	{ 0x23786, 0x25622a },
	{ 0x23787, 0x256177 },
	{ 0x23789, 0x274022 },
	{ 0x2378b, 0x274024 },
	{ 0x2378c, 0x2f5f2d },
	{ 0x23790, 0x256825 },
	{ 0x23791, 0x274743 },
	{ 0x23792, 0x256828 },
	{ 0x23793, 0x25682b },
	{ 0x23794, 0x256829 },
	{ 0x23795, 0x274742 },
	{ 0x23796, 0x274740 },
	{ 0x23797, 0x25682d },
	{ 0x23798, 0x274741 },
	{ 0x23799, 0x245f74 },
	{ 0x2379a, 0x274748 },
	{ 0x2379b, 0x274749 },
	{ 0x2379c, 0x256827 },
	{ 0x2379d, 0x256826 },
	{ 0x2379e, 0x274745 },
	{ 0x2379f, 0x25682f },
	{ 0x237a3, 0x274747 },
	{ 0x237a4, 0x273f7e },
	{ 0x237a5, 0x2f6252 },
	{ 0x237a6, 0x2f6256 },
	{ 0x237a7, 0x2f6258 },
	{ 0x237a8, 0x2f6259 },
	{ 0x237a9, 0x2f625a },
	{ 0x237aa, 0x2f625b },
	{ 0x237ab, 0x2f625c },
	{ 0x237ac, 0x2f625d },
	{ 0x237ad, 0x2f625f },
	{ 0x237ae, 0x2f6260 },
	{ 0x237af, 0x2f6261 },
	{ 0x237b0, 0x25682e },
	{ 0x237b2, 0x274744 },
	{ 0x237b5, 0x27473f },
	{ 0x237b6, 0x2f6254 },
	{ 0x237b7, 0x25682c },
	{ 0x237bb, 0x2f6257 },
	{ 0x237bc, 0x2f624f },
	{ 0x237bf, 0x2f625e },
	{ 0x237c2, 0x2f5e7d },
	{ 0x237c4, 0x246353 },
	{ 0x237c5, 0x274d7c },
	{ 0x237c6, 0x256c3f },
	{ 0x237c7, 0x274d7e },
	{ 0x237c8, 0x256c42 },
	{ 0x237c9, 0x256830 },
	{ 0x237ca, 0x256c3a },
	{ 0x237cb, 0x256c39 },
	{ 0x237cc, 0x256c3d },
	{ 0x237cd, 0x274d7d },
	{ 0x237ce, 0x256c3c },
	{ 0x237cf, 0x256c41 },
	{ 0x237d0, 0x256c3b },
	{ 0x237d1, 0x25682a },
	{ 0x237d2, 0x256c40 },
	{ 0x237d8, 0x256c3e },
	{ 0x237d9, 0x2f6533 },
	{ 0x237da, 0x2f6534 },
	{ 0x237db, 0x2f6535 },
	{ 0x237dc, 0x2f6536 },
	{ 0x237dd, 0x2f6537 },
	{ 0x237de, 0x2f6539 },
	{ 0x237df, 0x2f653a },
	{ 0x237e0, 0x2f653b },
	{ 0x237e1, 0x2f653c },
	{ 0x237e2, 0x2f653d },
	{ 0x237e3, 0x2f653f },
	{ 0x237e8, 0x274e21 },
	{ 0x237ec, 0x246352 },
	{ 0x237ef, 0x275349 },
	{ 0x237f0, 0x275348 },
	{ 0x237f2, 0x25702b },
	{ 0x237f3, 0x25702d },
	{ 0x237f4, 0x246646 },
	{ 0x237f5, 0x257029 },
	{ 0x237f6, 0x27534d },
	{ 0x237f8, 0x257028 },
	{ 0x237f9, 0x25702a },
	{ 0x237fa, 0x25702c },
	{ 0x237fb, 0x27534a },
	{ 0x237fc, 0x246645 },
	{ 0x237fd, 0x25702f },
	{ 0x237fe, 0x27534e },
	{ 0x23801, 0x257032 },
	{ 0x23802, 0x2f675b },
	{ 0x23803, 0x2f675c },
	{ 0x23804, 0x2f675d },
	{ 0x23805, 0x2f675e },
	{ 0x23806, 0x2f675f },
	{ 0x23807, 0x2f6760 },
	{ 0x23808, 0x2f6761 },
	{ 0x23809, 0x2f6762 },
	{ 0x2380a, 0x2f6763 },
	{ 0x2380b, 0x2f6764 },
	{ 0x2380c, 0x27534c },
	{ 0x2380e, 0x257031 },
	{ 0x2380f, 0x257030 },
	{ 0x23810, 0x27534b },
	{ 0x23814, 0x25702e },
	{ 0x23819, 0x275826 },
	{ 0x2381a, 0x25734e },
	{ 0x2381b, 0x25734f },
	{ 0x2381c, 0x25734c },
	{ 0x2381d, 0x25734a },
	{ 0x2381e, 0x24686f },
	{ 0x2381f, 0x25734b },
	{ 0x23820, 0x25734d },
	{ 0x23821, 0x275825 },
	{ 0x23825, 0x2f6947 },
	{ 0x23826, 0x2f6948 },
	{ 0x23827, 0x2f6949 },
	{ 0x23828, 0x2f694b },
	{ 0x23829, 0x2f694e },
	{ 0x2382a, 0x2f694f },
	{ 0x2382b, 0x2f6950 },
	{ 0x2382c, 0x2f6951 },
	{ 0x2382d, 0x275824 },
	{ 0x2382e, 0x275822 },
	{ 0x23835, 0x2f6765 },
	{ 0x23837, 0x257571 },
	{ 0x23838, 0x257573 },
	{ 0x23839, 0x257760 },
	{ 0x2383a, 0x257574 },
	{ 0x2383b, 0x275b60 },
	{ 0x2383c, 0x257572 },
	{ 0x2383d, 0x275b61 },
	{ 0x2383e, 0x257575 },
	{ 0x2383f, 0x275b5f },
	{ 0x23840, 0x257761 },
	{ 0x23843, 0x275b5d },
	{ 0x23844, 0x2f6a57 },
	{ 0x23845, 0x2f6a59 },
	{ 0x23846, 0x275b5e },
	{ 0x23849, 0x257576 },
	{ 0x2384a, 0x257570 },
	{ 0x2384c, 0x246b6c },
	{ 0x2384d, 0x275e6e },
	{ 0x2384e, 0x257762 },
	{ 0x2384f, 0x276071 },
	{ 0x23850, 0x2f6b4e },
	{ 0x23851, 0x2f6b4f },
	{ 0x23852, 0x2f6b50 },
	{ 0x23853, 0x2f6b53 },
	{ 0x23854, 0x2f6b54 },
	{ 0x23858, 0x275e6f },
	{ 0x2385b, 0x275e70 },
	{ 0x2385c, 0x2f6a58 },
	{ 0x2385e, 0x276072 },
	{ 0x23860, 0x25792d },
	{ 0x23862, 0x2f6c2c },
	{ 0x23863, 0x276073 },
	{ 0x23865, 0x25792c },
	{ 0x23867, 0x25792e },
	{ 0x23868, 0x2f6b52 },
	{ 0x23869, 0x257a29 },
	{ 0x2386a, 0x276354 },
	{ 0x2386b, 0x276074 },
	{ 0x2386d, 0x246d55 },
	{ 0x2386e, 0x2f6c2d },
	{ 0x23871, 0x2f6c4c },
	{ 0x23872, 0x2f6c63 },
	{ 0x23873, 0x27634c },
	{ 0x23874, 0x276355 },
	{ 0x23876, 0x257b40 },
	{ 0x23877, 0x276448 },
	{ 0x23878, 0x276449 },
	{ 0x2387a, 0x27655b },
	{ 0x2387b, 0x2f6d2f },
	{ 0x2387c, 0x276574 },
	{ 0x23880, 0x262524 },
	{ 0x23881, 0x24244b },
	{ 0x23882, 0x26282f },
	{ 0x23883, 0x262c2e },
	{ 0x23884, 0x262832 },
	{ 0x23885, 0x252447 },
	{ 0x23886, 0x262831 },
	{ 0x23887, 0x24244a },
	{ 0x23889, 0x25265c },
	{ 0x2388a, 0x25265b },
	{ 0x2388b, 0x252658 },
	{ 0x2388c, 0x262c2f },
	{ 0x2388d, 0x24266f },
	{ 0x2388e, 0x262c30 },
	{ 0x2388f, 0x25265d },
	{ 0x23890, 0x24266e },
	{ 0x23891, 0x252659 },
	{ 0x23892, 0x25265a },
	{ 0x23893, 0x252657 },
	{ 0x23894, 0x2f2756 },
	{ 0x23897, 0x25295f },
	{ 0x23898, 0x26317a },
	{ 0x23899, 0x263854 },
	{ 0x2389a, 0x26317c },
	{ 0x2389b, 0x252962 },
	{ 0x2389c, 0x242975 },
	{ 0x2389d, 0x252961 },
	{ 0x2389e, 0x25295e },
	{ 0x2389f, 0x263179 },
	{ 0x238a0, 0x25295c },
	{ 0x238a1, 0x252960 },
	{ 0x238a2, 0x26317b },
	{ 0x238a3, 0x25295d },
	{ 0x238a6, 0x2f2c77 },
	{ 0x238a7, 0x263857 },
	{ 0x238a8, 0x263858 },
	{ 0x238a9, 0x263855 },
	{ 0x238aa, 0x252e33 },
	{ 0x238ac, 0x252e2d },
	{ 0x238ad, 0x263856 },
	{ 0x238ae, 0x26406b },
	{ 0x238af, 0x252e32 },
	{ 0x238b0, 0x242d5f },
	{ 0x238b1, 0x252e2f },
	{ 0x238b2, 0x252e34 },
	{ 0x238b3, 0x252e31 },
	{ 0x238b4, 0x252e30 },
	{ 0x238b5, 0x2f3031 },
	{ 0x238ba, 0x253325 },
	{ 0x238bb, 0x26406c },
	{ 0x238bd, 0x26406d },
	{ 0x238bf, 0x2f3567 },
	{ 0x238c0, 0x2f3568 },
	{ 0x238c1, 0x2f3569 },
	{ 0x238c2, 0x2f356a },
	{ 0x238c3, 0x2f356b },
	{ 0x238c4, 0x2f356c },
	{ 0x238c5, 0x2f356d },
	{ 0x238c6, 0x2f356e },
	{ 0x238c8, 0x24383d },
	{ 0x238c9, 0x253947 },
	{ 0x238ca, 0x253f77 },
	{ 0x238cb, 0x24383a },
	{ 0x238cc, 0x253945 },
	{ 0x238cd, 0x264a3c },
	{ 0x238ce, 0x253324 },
	{ 0x238cf, 0x253948 },
	{ 0x238d0, 0x264a3d },
	{ 0x238d1, 0x253944 },
	{ 0x238d2, 0x253949 },
	{ 0x238d3, 0x264a3e },
	{ 0x238d5, 0x253946 },
	{ 0x238d6, 0x264a3b },
	{ 0x238d7, 0x2f3c30 },
	{ 0x238d8, 0x2f3c31 },
	{ 0x238d9, 0x264a3a },
	{ 0x238dd, 0x26536e },
	{ 0x238de, 0x253f76 },
	{ 0x238df, 0x253f75 },
	{ 0x238e0, 0x253f7a },
	{ 0x238e1, 0x26536b },
	{ 0x238e2, 0x253f79 },
	{ 0x238e3, 0x265367 },
	{ 0x238e4, 0x265366 },
	{ 0x238e5, 0x265368 },
	{ 0x238e6, 0x265369 },
	{ 0x238e7, 0x26536a },
	{ 0x238e8, 0x26536d },
	{ 0x238e9, 0x253f78 },
	{ 0x238eb, 0x2f424e },
	{ 0x238ec, 0x26585a },
	{ 0x238ef, 0x26536c },
	{ 0x238f0, 0x265365 },
	{ 0x238f1, 0x2f424d },
	{ 0x238f2, 0x25465c },
	{ 0x238f3, 0x24442b },
	{ 0x238f4, 0x25465e },
	{ 0x238f5, 0x265d6f },
	{ 0x238f6, 0x265d6e },
	{ 0x238f7, 0x24442c },
	{ 0x238f8, 0x25465d },
	{ 0x238f9, 0x244429 },
	{ 0x238fa, 0x265d75 },
	{ 0x238fb, 0x265d70 },
	{ 0x238fc, 0x25465a },
	{ 0x238fd, 0x265d76 },
	{ 0x238fe, 0x265d74 },
	{ 0x238ff, 0x25465b },
	{ 0x23900, 0x265d72 },
	{ 0x23901, 0x265d71 },
	{ 0x23902, 0x265d73 },
	{ 0x23903, 0x26536f },
	{ 0x23904, 0x2f4876 },
	{ 0x23905, 0x2f4878 },
	{ 0x23907, 0x254659 },
	{ 0x23908, 0x254d6e },
	{ 0x23909, 0x27237d },
	{ 0x2390a, 0x254d70 },
	{ 0x2390b, 0x254d71 },
	{ 0x2390c, 0x244a4d },
	{ 0x2390d, 0x272379 },
	{ 0x2390e, 0x272377 },
	{ 0x2390f, 0x27237e },
	{ 0x23910, 0x272376 },
	{ 0x23911, 0x27237a },
	{ 0x23912, 0x27237b },
	{ 0x23914, 0x254d6f },
	{ 0x23915, 0x2f4f54 },
	{ 0x23917, 0x27237c },
	{ 0x23918, 0x25547e },
	{ 0x23919, 0x272e76 },
	{ 0x2391a, 0x245068 },
	{ 0x2391c, 0x272e75 },
	{ 0x2391d, 0x2f553a },
	{ 0x2391e, 0x2f553b },
	{ 0x23920, 0x27385e },
	{ 0x23921, 0x273860 },
	{ 0x23922, 0x255b71 },
	{ 0x23923, 0x27385f },
	{ 0x23924, 0x2f5a55 },
	{ 0x23925, 0x27385d },
	{ 0x23929, 0x25622c },
	{ 0x2392c, 0x256832 },
	{ 0x2392d, 0x256831 },
	{ 0x2392e, 0x2f6262 },
	{ 0x23931, 0x257036 },
	{ 0x23932, 0x274e23 },
	{ 0x23934, 0x257035 },
	{ 0x23935, 0x257034 },
	{ 0x23936, 0x246870 },
	{ 0x23937, 0x257033 },
	{ 0x23939, 0x257350 },
	{ 0x2393a, 0x275829 },
	{ 0x2393b, 0x275827 },
	{ 0x2393c, 0x275828 },
	{ 0x2393e, 0x257763 },
	{ 0x2393f, 0x276075 },
	{ 0x23940, 0x246c70 },
	{ 0x23941, 0x246d56 },
	{ 0x23942, 0x252132 },
	{ 0x23943, 0x252170 },
	{ 0x23944, 0x26232e },
	{ 0x23945, 0x262526 },
	{ 0x23947, 0x25244a },
	{ 0x23948, 0x262834 },
	{ 0x23949, 0x262c31 },
	{ 0x2394a, 0x252449 },
	{ 0x2394b, 0x25244b },
	{ 0x2394c, 0x262833 },
	{ 0x2394d, 0x262c3c },
	{ 0x2394e, 0x262c34 },
	{ 0x2394f, 0x262c3b },
	{ 0x23950, 0x262c3a },
	{ 0x23951, 0x262c36 },
	{ 0x23952, 0x262c33 },
	{ 0x23953, 0x262c38 },
	{ 0x23954, 0x262c32 },
	{ 0x23955, 0x262c37 },
	{ 0x23956, 0x25265e },
	{ 0x23957, 0x262c39 },
	{ 0x23958, 0x262c35 },
	{ 0x23959, 0x25265f },
	{ 0x2395b, 0x2f2757 },
	{ 0x2395c, 0x2f2758 },
	{ 0x2395d, 0x2f2759 },
	{ 0x23960, 0x242672 },
	{ 0x23962, 0x242976 },
	{ 0x23963, 0x252963 },
	{ 0x23965, 0x252835 },
	{ 0x23966, 0x263859 },
	{ 0x23967, 0x26385c },
	{ 0x23968, 0x252e35 },
	{ 0x23969, 0x26385a },
	{ 0x2396a, 0x26385e },
	{ 0x2396b, 0x26385d },
	{ 0x2396d, 0x26385b },
	{ 0x23972, 0x263748 },
	{ 0x23973, 0x253326 },
	{ 0x23974, 0x264070 },
	{ 0x23975, 0x2f356f },
	{ 0x23978, 0x26406f },
	{ 0x23979, 0x243840 },
	{ 0x2397a, 0x24383e },
	{ 0x2397b, 0x25394a },
	{ 0x2397c, 0x25394b },
	{ 0x2397d, 0x264a43 },
	{ 0x2397e, 0x243841 },
	{ 0x2397f, 0x264a42 },
	{ 0x23981, 0x264a44 },
	{ 0x23982, 0x264a40 },
	{ 0x23983, 0x264a45 },
	{ 0x23984, 0x264a46 },
	{ 0x23985, 0x264a41 },
	{ 0x23987, 0x253f7c },
	{ 0x23988, 0x265370 },
	{ 0x23989, 0x253f7b },
	{ 0x2398a, 0x2f424f },
	{ 0x2398b, 0x265a61 },
	{ 0x23994, 0x272422 },
	{ 0x23995, 0x272425 },
	{ 0x23996, 0x272423 },
	{ 0x23997, 0x272426 },
	{ 0x23998, 0x272421 },
	{ 0x23999, 0x272424 },
	{ 0x2399a, 0x2f4f55 },
	{ 0x2399c, 0x272e7a },
	{ 0x2399d, 0x272e79 },
	{ 0x2399e, 0x272e77 },
	{ 0x2399f, 0x272e78 },
	{ 0x239a1, 0x273861 },
	{ 0x239a2, 0x245650 },
	{ 0x239a4, 0x2f5a56 },
	{ 0x239a5, 0x2f5a57 },
	{ 0x239a6, 0x25622d },
	{ 0x239a7, 0x25622e },
	{ 0x239a8, 0x27402e },
	{ 0x239af, 0x257351 },
	{ 0x239b1, 0x275b62 },
	{ 0x239b2, 0x275b63 },
	{ 0x239b5, 0x252171 },
	{ 0x239b6, 0x252149 },
	{ 0x239b7, 0x252276 },
	{ 0x239b8, 0x262835 },
	{ 0x239b9, 0x24227d },
	{ 0x239ba, 0x262527 },
	{ 0x239bb, 0x25244c },
	{ 0x239bc, 0x24244d },
	{ 0x239bd, 0x262528 },
	{ 0x239bf, 0x262836 },
	{ 0x239c0, 0x26283b },
	{ 0x239c1, 0x262837 },
	{ 0x239c2, 0x24244c },
	{ 0x239c3, 0x26283c },
	{ 0x239c4, 0x25244d },
	{ 0x239c5, 0x262839 },
	{ 0x239c6, 0x262838 },
	{ 0x239c7, 0x26283a },
	{ 0x239c9, 0x262c3f },
	{ 0x239ca, 0x252660 },
	{ 0x239cb, 0x252666 },
	{ 0x239cc, 0x252661 },
	{ 0x239cd, 0x252664 },
	{ 0x239ce, 0x242673 },
	{ 0x239cf, 0x242674 },
	{ 0x239d0, 0x252663 },
	{ 0x239d1, 0x242677 },
	{ 0x239d2, 0x262c3d },
	{ 0x239d3, 0x262c3e },
	{ 0x239d4, 0x262c40 },
	{ 0x239d5, 0x26317d },
	{ 0x239d6, 0x252665 },
	{ 0x239dd, 0x252968 },
	{ 0x239de, 0x242978 },
	{ 0x239df, 0x242979 },
	{ 0x239e0, 0x263226 },
	{ 0x239e1, 0x242977 },
	{ 0x239e2, 0x26317e },
	{ 0x239e3, 0x252964 },
	{ 0x239e4, 0x252965 },
	{ 0x239e5, 0x25296b },
	{ 0x239e6, 0x252966 },
	{ 0x239e7, 0x252967 },
	{ 0x239e8, 0x263225 },
	{ 0x239e9, 0x24297a },
	{ 0x239ea, 0x263222 },
	{ 0x239eb, 0x263223 },
	{ 0x239ec, 0x25296a },
	{ 0x239ed, 0x263224 },
	{ 0x239ee, 0x26385f },
	{ 0x239ef, 0x2f2b50 },
	{ 0x239f0, 0x263221 },
	{ 0x239f1, 0x25296c },
	{ 0x239f2, 0x252e36 },
	{ 0x239f3, 0x242d63 },
	{ 0x239f4, 0x263862 },
	{ 0x239f5, 0x252e3b },
	{ 0x239f6, 0x263865 },
	{ 0x239f7, 0x252e3c },
	{ 0x239f8, 0x252e38 },
	{ 0x239f9, 0x252e39 },
	{ 0x239fb, 0x263863 },
	{ 0x239fc, 0x263866 },
	{ 0x239fd, 0x252e3d },
	{ 0x239fe, 0x252e37 },
	{ 0x239ff, 0x252e3a },
	{ 0x23a00, 0x252e3e },
	{ 0x23a01, 0x263860 },
	{ 0x23a03, 0x263861 },
	{ 0x23a05, 0x25332b },
	{ 0x23a06, 0x264074 },
	{ 0x23a07, 0x25332a },
	{ 0x23a08, 0x264073 },
	{ 0x23a09, 0x253327 },
	{ 0x23a0a, 0x253328 },
	{ 0x23a0b, 0x253329 },
	{ 0x23a0c, 0x264071 },
	{ 0x23a0d, 0x24324b },
	{ 0x23a0e, 0x25332c },
	{ 0x23a0f, 0x264a49 },
	{ 0x23a10, 0x264075 },
	{ 0x23a11, 0x264072 },
	{ 0x23a12, 0x2f3571 },
	{ 0x23a16, 0x265372 },
	{ 0x23a17, 0x264a4a },
	{ 0x23a18, 0x253953 },
	{ 0x23a19, 0x243848 },
	{ 0x23a1a, 0x264a4b },
	{ 0x23a1b, 0x243843 },
	{ 0x23a1c, 0x25394e },
	{ 0x23a1d, 0x25394d },
	{ 0x23a1e, 0x25394f },
	{ 0x23a1f, 0x243847 },
	{ 0x23a20, 0x253952 },
	{ 0x23a21, 0x253954 },
	{ 0x23a22, 0x253950 },
	{ 0x23a23, 0x25394c },
	{ 0x23a24, 0x253951 },
	{ 0x23a25, 0x264a4c },
	{ 0x23a26, 0x265371 },
	{ 0x23a28, 0x264a48 },
	{ 0x23a29, 0x2f3c32 },
	{ 0x23a2f, 0x265374 },
	{ 0x23a31, 0x265379 },
	{ 0x23a32, 0x253f7d },
	{ 0x23a33, 0x253f7e },
	{ 0x23a34, 0x265376 },
	{ 0x23a35, 0x265378 },
	{ 0x23a36, 0x243e25 },
	{ 0x23a37, 0x265d78 },
	{ 0x23a38, 0x26537a },
	{ 0x23a39, 0x265375 },
	{ 0x23a3b, 0x265373 },
	{ 0x23a3d, 0x2f4250 },
	{ 0x23a43, 0x2f3570 },
	{ 0x23a44, 0x244434 },
	{ 0x23a45, 0x24442e },
	{ 0x23a46, 0x265d7b },
	{ 0x23a47, 0x265d7c },
	{ 0x23a48, 0x24442f },
	{ 0x23a49, 0x265d79 },
	{ 0x23a4b, 0x265d7a },
	{ 0x23a4c, 0x265d2d },
	{ 0x23a4d, 0x272429 },
	{ 0x23a4e, 0x244a51 },
	{ 0x23a4f, 0x254d72 },
	{ 0x23a50, 0x272427 },
	{ 0x23a51, 0x254d75 },
	{ 0x23a52, 0x272428 },
	{ 0x23a53, 0x27242b },
	{ 0x23a54, 0x254d74 },
	{ 0x23a55, 0x245069 },
	{ 0x23a56, 0x27242c },
	{ 0x23a57, 0x27242a },
	{ 0x23a58, 0x2f4f56 },
	{ 0x23a59, 0x254d73 },
	{ 0x23a5d, 0x272e7b },
	{ 0x23a5e, 0x272e7c },
	{ 0x23a5f, 0x255521 },
	{ 0x23a60, 0x24506c },
	{ 0x23a61, 0x255523 },
	{ 0x23a62, 0x255522 },
	{ 0x23a63, 0x272e7e },
	{ 0x23a64, 0x2f553c },
	{ 0x23a65, 0x2f553d },
	{ 0x23a68, 0x273864 },
	{ 0x23a69, 0x273862 },
	{ 0x23a6a, 0x255b73 },
	{ 0x23a6b, 0x273865 },
	{ 0x23a6c, 0x273863 },
	{ 0x23a6d, 0x255b74 },
	{ 0x23a6f, 0x256230 },
	{ 0x23a70, 0x25622f },
	{ 0x23a71, 0x245b4d },
	{ 0x23a72, 0x274030 },
	{ 0x23a73, 0x272e7d },
	{ 0x23a74, 0x255b75 },
	{ 0x23a76, 0x27402f },
	{ 0x23a77, 0x256833 },
	{ 0x23a7a, 0x257037 },
	{ 0x23a7b, 0x257038 },
	{ 0x23a7c, 0x27534f },
	{ 0x23a7e, 0x27582a },
	{ 0x23a7f, 0x25757a },
	{ 0x23a80, 0x257579 },
	{ 0x23a82, 0x252668 },
	{ 0x23a83, 0x252667 },
	{ 0x23a85, 0x263227 },
	{ 0x23a86, 0x263228 },
	{ 0x23a88, 0x252e3f },
	{ 0x23a8b, 0x24324c },
	{ 0x23a8c, 0x24324d },
	{ 0x23a8d, 0x264078 },
	{ 0x23a8e, 0x264079 },
	{ 0x23a8f, 0x264076 },
	{ 0x23a90, 0x264077 },
	{ 0x23a91, 0x2f3573 },
	{ 0x23a92, 0x2f3575 },
	{ 0x23a93, 0x2f3576 },
	{ 0x23a94, 0x2f3577 },
	{ 0x23a95, 0x26407b },
	{ 0x23a96, 0x26407a },
	{ 0x23a97, 0x25332d },
	{ 0x23a99, 0x264a4f },
	{ 0x23a9b, 0x264a4e },
	{ 0x23a9c, 0x2f3c33 },
	{ 0x23a9f, 0x2f3572 },
	{ 0x23aa0, 0x265421 },
	{ 0x23aa1, 0x265422 },
	{ 0x23aa3, 0x26537d },
	{ 0x23aa4, 0x26537e },
	{ 0x23aa5, 0x265424 },
	{ 0x23aa6, 0x2f4251 },
	{ 0x23aa7, 0x2f4252 },
	{ 0x23aa9, 0x265423 },
	{ 0x23aaa, 0x26537c },
	{ 0x23aac, 0x254021 },
	{ 0x23aad, 0x25407b },
	{ 0x23aae, 0x254661 },
	{ 0x23aaf, 0x244436 },
	{ 0x23ab0, 0x265e21 },
	{ 0x23ab1, 0x244437 },
	{ 0x23ab2, 0x265d7e },
	{ 0x23ab3, 0x265d7d },
	{ 0x23ab5, 0x2f487a },
	{ 0x23ab6, 0x254d76 },
	{ 0x23ab7, 0x265e22 },
	{ 0x23ab8, 0x27242d },
	{ 0x23ab9, 0x244a52 },
	{ 0x23abb, 0x272f25 },
	{ 0x23abc, 0x272f23 },
	{ 0x23abd, 0x272f26 },
	{ 0x23abe, 0x272f21 },
	{ 0x23abf, 0x272f24 },
	{ 0x23ac0, 0x255524 },
	{ 0x23ac1, 0x272f22 },
	{ 0x23ac5, 0x2f553e },
	{ 0x23ac6, 0x2f553f },
	{ 0x23ac7, 0x2f5540 },
	{ 0x23acc, 0x273866 },
	{ 0x23acd, 0x273867 },
	{ 0x23ad0, 0x245b4e },
	{ 0x23ad1, 0x274033 },
	{ 0x23ad2, 0x256232 },
	{ 0x23ad3, 0x256231 },
	{ 0x23ad6, 0x274031 },
	{ 0x23ad8, 0x274032 },
	{ 0x23ad9, 0x245f78 },
	{ 0x23ada, 0x27474c },
	{ 0x23ade, 0x274e25 },
	{ 0x23adf, 0x27474d },
	{ 0x23ae1, 0x275350 },
	{ 0x23ae2, 0x246a4d },
	{ 0x23ae3, 0x25757b },
	{ 0x23ae4, 0x275b64 },
	{ 0x23ae5, 0x257352 },
	{ 0x23ae6, 0x275e73 },
	{ 0x23ae7, 0x257765 },
	{ 0x23ae8, 0x257764 },
	{ 0x23ae9, 0x276076 },
	{ 0x23aeb, 0x276356 },
	{ 0x23aec, 0x252172 },
	{ 0x23aed, 0x26283d },
	{ 0x23aef, 0x262c41 },
	{ 0x23af0, 0x263229 },
	{ 0x23af4, 0x263867 },
	{ 0x23af8, 0x2f3c34 },
	{ 0x23af9, 0x254022 },
	{ 0x23afa, 0x244a53 },
	{ 0x23afc, 0x2f4f57 },
	{ 0x23afd, 0x2f4f58 },
	{ 0x23afe, 0x2f5a59 },
	{ 0x23aff, 0x2f5541 },
	{ 0x23b00, 0x2f6263 },
	{ 0x23b01, 0x2f6a5a },
	{ 0x23b02, 0x25244f },
	{ 0x23b03, 0x26283e },
	{ 0x23b04, 0x262c45 },
	{ 0x23b05, 0x262c44 },
	{ 0x23b06, 0x252669 },
	{ 0x23b08, 0x263868 },
	{ 0x23b09, 0x26386a },
	{ 0x23b0a, 0x263869 },
	{ 0x23b0b, 0x26407c },
	{ 0x23b0c, 0x26407d },
	{ 0x23b0d, 0x254023 },
	{ 0x23b0e, 0x243e26 },
	{ 0x23b0f, 0x254662 },
	{ 0x23b10, 0x254663 },
	{ 0x23b11, 0x265e23 },
	{ 0x23b12, 0x27242e },
	{ 0x23b13, 0x272f27 },
	{ 0x23b14, 0x272f28 },
	{ 0x23b15, 0x255525 },
	{ 0x23b16, 0x27474e },
	{ 0x23b17, 0x256c43 },
	{ 0x23b1a, 0x257930 },
	{ 0x23b1b, 0x25214a },
	{ 0x23b1c, 0x24227e },
	{ 0x23b1e, 0x2f225a },
	{ 0x23b1f, 0x2f225b },
	{ 0x23b21, 0x262840 },
	{ 0x23b22, 0x26283f },
	{ 0x23b23, 0x24244e },
	{ 0x23b24, 0x2f2455 },
	{ 0x23b25, 0x2f2456 },
	{ 0x23b26, 0x2f2457 },
	{ 0x23b27, 0x2f2459 },
	{ 0x23b28, 0x2f245a },
	{ 0x23b29, 0x25266d },
	{ 0x23b2a, 0x25266a },
	{ 0x23b2b, 0x25266c },
	{ 0x23b2c, 0x25266b },
	{ 0x23b2d, 0x262c47 },
	{ 0x23b2e, 0x262c46 },
	{ 0x23b2f, 0x2f275a },
	{ 0x23b30, 0x2f275c },
	{ 0x23b31, 0x2f275d },
	{ 0x23b32, 0x2f275e },
	{ 0x23b33, 0x2f275f },
	{ 0x23b35, 0x252643 },
	{ 0x23b38, 0x26322c },
	{ 0x23b39, 0x25296e },
	{ 0x23b3a, 0x25296f },
	{ 0x23b3b, 0x25296d },
	{ 0x23b3c, 0x252970 },
	{ 0x23b3d, 0x252971 },
	{ 0x23b3e, 0x26322d },
	{ 0x23b3f, 0x252973 },
	{ 0x23b40, 0x26322f },
	{ 0x23b41, 0x26386d },
	{ 0x23b42, 0x26322e },
	{ 0x23b44, 0x252974 },
	{ 0x23b45, 0x26322b },
	{ 0x23b47, 0x252972 },
	{ 0x23b49, 0x2f2b51 },
	{ 0x23b4a, 0x2f2b52 },
	{ 0x23b4b, 0x2f2b53 },
	{ 0x23b4c, 0x2f2b54 },
	{ 0x23b4d, 0x2f2b55 },
	{ 0x23b4e, 0x2f2b56 },
	{ 0x23b4f, 0x2f2b57 },
	{ 0x23b50, 0x2f2b58 },
	{ 0x23b51, 0x2f2b59 },
	{ 0x23b52, 0x2f2b5a },
	{ 0x23b53, 0x2f2b5b },
	{ 0x23b54, 0x2f2b5c },
	{ 0x23b55, 0x2f2b5e },
	{ 0x23b5a, 0x2f2b5d },
	{ 0x23b5c, 0x26386f },
	{ 0x23b5d, 0x252e41 },
	{ 0x23b5e, 0x26386e },
	{ 0x23b5f, 0x242d69 },
	{ 0x23b60, 0x252e43 },
	{ 0x23b61, 0x242d68 },
	{ 0x23b62, 0x26386c },
	{ 0x23b63, 0x252e42 },
	{ 0x23b65, 0x2f3032 },
	{ 0x23b66, 0x2f3033 },
	{ 0x23b67, 0x2f3034 },
	{ 0x23b68, 0x2f3035 },
	{ 0x23b69, 0x2f3036 },
	{ 0x23b6a, 0x2f3037 },
	{ 0x23b6b, 0x2f3038 },
	{ 0x23b6c, 0x2f3039 },
	{ 0x23b6d, 0x26386b },
	{ 0x23b6e, 0x252e40 },
	{ 0x23b71, 0x264126 },
	{ 0x23b72, 0x243256 },
	{ 0x23b73, 0x264121 },
	{ 0x23b74, 0x253331 },
	{ 0x23b75, 0x264122 },
	{ 0x23b76, 0x264123 },
	{ 0x23b77, 0x25332e },
	{ 0x23b78, 0x264125 },
	{ 0x23b79, 0x253332 },
	{ 0x23b7a, 0x253330 },
	{ 0x23b7b, 0x25332f },
	{ 0x23b7c, 0x26407e },
	{ 0x23b7d, 0x264124 },
	{ 0x23b7e, 0x2f3578 },
	{ 0x23b7f, 0x2f3579 },
	{ 0x23b80, 0x2f357a },
	{ 0x23b81, 0x2f357b },
	{ 0x23b82, 0x2f357c },
	{ 0x23b88, 0x253955 },
	{ 0x23b89, 0x24384d },
	{ 0x23b8a, 0x253956 },
	{ 0x23b8b, 0x243850 },
	{ 0x23b8c, 0x264a51 },
	{ 0x23b8d, 0x264a53 },
	{ 0x23b8e, 0x253959 },
	{ 0x23b8f, 0x253958 },
	{ 0x23b90, 0x25395a },
	{ 0x23b91, 0x264a56 },
	{ 0x23b92, 0x264a50 },
	{ 0x23b93, 0x264a55 },
	{ 0x23b94, 0x253957 },
	{ 0x23b95, 0x264a52 },
	{ 0x23b97, 0x2f3c3a },
	{ 0x23b98, 0x2f3c35 },
	{ 0x23b99, 0x2f3c37 },
	{ 0x23b9a, 0x2f3c38 },
	{ 0x23b9b, 0x2f3c39 },
	{ 0x23b9c, 0x2f3c3b },
	{ 0x23b9d, 0x2f3c3d },
	{ 0x23b9e, 0x2f3c3f },
	{ 0x23b9f, 0x2f3c40 },
	{ 0x23ba3, 0x264a54 },
	{ 0x23ba4, 0x2f3c36 },
	{ 0x23ba7, 0x25395c },
	{ 0x23ba8, 0x26542e },
	{ 0x23ba9, 0x26542c },
	{ 0x23baa, 0x243e2b },
	{ 0x23bab, 0x265427 },
	{ 0x23bac, 0x26542b },
	{ 0x23bad, 0x243e2a },
	{ 0x23bae, 0x265428 },
	{ 0x23baf, 0x265425 },
	{ 0x23bb0, 0x265429 },
	{ 0x23bb1, 0x265426 },
	{ 0x23bb2, 0x26542d },
	{ 0x23bb3, 0x26542a },
	{ 0x23bb4, 0x26542f },
	{ 0x23bb9, 0x254024 },
	{ 0x23bba, 0x2f4253 },
	{ 0x23bbb, 0x2f4255 },
	{ 0x23bbc, 0x2f4256 },
	{ 0x23bbd, 0x2f4257 },
	{ 0x23bc2, 0x265430 },
	{ 0x23bc5, 0x265e29 },
	{ 0x23bc6, 0x254666 },
	{ 0x23bc7, 0x254665 },
	{ 0x23bc8, 0x265e2a },
	{ 0x23bc9, 0x265e2b },
	{ 0x23bca, 0x265e2d },
	{ 0x23bcb, 0x24443d },
	{ 0x23bcc, 0x265e24 },
	{ 0x23bcd, 0x24443e },
	{ 0x23bce, 0x254667 },
	{ 0x23bcf, 0x24443b },
	{ 0x23bd1, 0x265e2e },
	{ 0x23bd2, 0x265e2f },
	{ 0x23bd3, 0x265e26 },
	{ 0x23bd5, 0x265e27 },
	{ 0x23bd6, 0x2f487c },
	{ 0x23bd7, 0x2f487d },
	{ 0x23bd8, 0x2f487e },
	{ 0x23bd9, 0x2f4921 },
	{ 0x23bdb, 0x265e28 },
	{ 0x23bdc, 0x254669 },
	{ 0x23bdd, 0x265e30 },
	{ 0x23bdf, 0x265e25 },
	{ 0x23be2, 0x265e2c },
	{ 0x23be4, 0x244a56 },
	{ 0x23be5, 0x272433 },
	{ 0x23be6, 0x272437 },
	{ 0x23be7, 0x272435 },
	{ 0x23be8, 0x244a55 },
	{ 0x23be9, 0x244a54 },
	{ 0x23bea, 0x254d79 },
	{ 0x23beb, 0x272434 },
	{ 0x23bec, 0x254d77 },
	{ 0x23bed, 0x254d78 },
	{ 0x23bee, 0x272431 },
	{ 0x23bef, 0x272432 },
	{ 0x23bf0, 0x272430 },
	{ 0x23bf1, 0x27242f },
	{ 0x23bf2, 0x272436 },
	{ 0x23bf7, 0x272438 },
	{ 0x23bf8, 0x272f29 },
	{ 0x23bf9, 0x255527 },
	{ 0x23bfa, 0x272f2a },
	{ 0x23bfb, 0x245070 },
	{ 0x23bfc, 0x255526 },
	{ 0x23bfd, 0x245073 },
	{ 0x23bfe, 0x272f2c },
	{ 0x23bff, 0x2f5542 },
	{ 0x23c00, 0x2f5543 },
	{ 0x23c01, 0x2f5544 },
	{ 0x23c02, 0x2f5545 },
	{ 0x23c06, 0x272f2b },
	{ 0x23c09, 0x272439 },
	{ 0x23c0a, 0x27386a },
	{ 0x23c0b, 0x245655 },
	{ 0x23c0c, 0x245654 },
	{ 0x23c0d, 0x273869 },
	{ 0x23c0e, 0x255b76 },
	{ 0x23c10, 0x273868 },
	{ 0x23c11, 0x2f5a5a },
	{ 0x23c12, 0x2f5a5b },
	{ 0x23c13, 0x2f5a5c },
	{ 0x23c14, 0x27386c },
	{ 0x23c16, 0x27386b },
	{ 0x23c1a, 0x256235 },
	{ 0x23c1b, 0x256234 },
	{ 0x23c1c, 0x256236 },
	{ 0x23c1e, 0x274037 },
	{ 0x23c1f, 0x27474f },
	{ 0x23c20, 0x274035 },
	{ 0x23c21, 0x256237 },
	{ 0x23c22, 0x274034 },
	{ 0x23c23, 0x274036 },
	{ 0x23c24, 0x2f5f31 },
	{ 0x23c28, 0x256233 },
	{ 0x23c2a, 0x2f5f32 },
	{ 0x23c2b, 0x274752 },
	{ 0x23c2c, 0x256834 },
	{ 0x23c2d, 0x274750 },
	{ 0x23c2e, 0x274751 },
	{ 0x23c31, 0x2f6541 },
	{ 0x23c32, 0x274e26 },
	{ 0x23c36, 0x246647 },
	{ 0x23c37, 0x257039 },
	{ 0x23c38, 0x275351 },
	{ 0x23c39, 0x2f6767 },
	{ 0x23c3b, 0x27582b },
	{ 0x23c3c, 0x257353 },
	{ 0x23c3e, 0x2f6952 },
	{ 0x23c3f, 0x25757c },
	{ 0x23c40, 0x275b65 },
	{ 0x23c44, 0x27644a },
	{ 0x23c45, 0x262c48 },
	{ 0x23c47, 0x263230 },
	{ 0x23c48, 0x252975 },
	{ 0x23c49, 0x252976 },
	{ 0x23c4a, 0x26334c },
	{ 0x23c4b, 0x264127 },
	{ 0x23c4c, 0x2f357d },
	{ 0x23c4e, 0x264128 },
	{ 0x23c4f, 0x265431 },
	{ 0x23c50, 0x244440 },
	{ 0x23c51, 0x272f2d },
	{ 0x23c52, 0x27386d },
	{ 0x23c53, 0x245b51 },
	{ 0x23c54, 0x2f5a5d },
	{ 0x23c55, 0x26252a },
	{ 0x23c56, 0x262529 },
	{ 0x23c58, 0x2f245c },
	{ 0x23c59, 0x262c4b },
	{ 0x23c5a, 0x262c4a },
	{ 0x23c5b, 0x262c49 },
	{ 0x23c5c, 0x263231 },
	{ 0x23c5e, 0x263232 },
	{ 0x23c5f, 0x2f2b5f },
	{ 0x23c60, 0x252977 },
	{ 0x23c61, 0x252e44 },
	{ 0x23c63, 0x2f357e },
	{ 0x23c64, 0x25395d },
	{ 0x23c65, 0x2f3c41 },
	{ 0x23c66, 0x265432 },
	{ 0x23c6a, 0x27243b },
	{ 0x23c6b, 0x27243a },
	{ 0x23c6e, 0x274038 },
	{ 0x23c6f, 0x275352 },
	{ 0x23c72, 0x2f2167 },
	{ 0x23c74, 0x262224 },
	{ 0x23c75, 0x26252b },
	{ 0x23c76, 0x252173 },
	{ 0x23c77, 0x26252c },
	{ 0x23c78, 0x2f225e },
	{ 0x23c79, 0x2f2469 },
	{ 0x23c80, 0x242323 },
	{ 0x23c81, 0x26252d },
	{ 0x23c82, 0x252450 },
	{ 0x23c83, 0x26252f },
	{ 0x23c84, 0x262531 },
	{ 0x23c86, 0x232424 },
	{ 0x23c87, 0x2f225c },
	{ 0x23c88, 0x2f245f },
	{ 0x23c89, 0x2f2460 },
	{ 0x23c8b, 0x262530 },
	{ 0x23c8e, 0x262c4d },
	{ 0x23c8f, 0x252452 },
	{ 0x23c90, 0x262842 },
	{ 0x23c91, 0x252451 },
	{ 0x23c92, 0x252453 },
	{ 0x23c93, 0x242450 },
	{ 0x23c94, 0x262846 },
	{ 0x23c95, 0x262847 },
	{ 0x23c9d, 0x262c4c },
	{ 0x23c9e, 0x262843 },
	{ 0x23c9f, 0x262841 },
	{ 0x23ca0, 0x262845 },
	{ 0x23ca1, 0x262848 },
	{ 0x23ca5, 0x2f2461 },
	{ 0x23ca7, 0x2f245e },
	{ 0x23ca8, 0x2f2462 },
	{ 0x23ca9, 0x2f2463 },
	{ 0x23caa, 0x2f2464 },
	{ 0x23cab, 0x2f2465 },
	{ 0x23cac, 0x2f2466 },
	{ 0x23cad, 0x2f2467 },
	{ 0x23cae, 0x2f2763 },
	{ 0x23caf, 0x2f2764 },
	{ 0x23cb0, 0x2f2765 },
	{ 0x23cb2, 0x242723 },
	{ 0x23cb3, 0x25266f },
	{ 0x23cb4, 0x263233 },
	{ 0x23cb5, 0x252672 },
	{ 0x23cb6, 0x252673 },
	{ 0x23cb7, 0x242721 },
	{ 0x23cb8, 0x262c57 },
	{ 0x23cb9, 0x242725 },
	{ 0x23cba, 0x262c50 },
	{ 0x23cbb, 0x242724 },
	{ 0x23cbc, 0x262c4e },
	{ 0x23cbd, 0x25266e },
	{ 0x23cbe, 0x252670 },
	{ 0x23cbf, 0x262c58 },
	{ 0x23cc0, 0x252671 },
	{ 0x23cc1, 0x262c5a },
	{ 0x23cc2, 0x263234 },
	{ 0x23cc4, 0x262c56 },
	{ 0x23cc5, 0x262c5c },
	{ 0x23cca, 0x24267c },
	{ 0x23ccb, 0x262c53 },
	{ 0x23ccc, 0x2f2760 },
	{ 0x23ccd, 0x2f2761 },
	{ 0x23cce, 0x2f2762 },
	{ 0x23ccf, 0x2f2767 },
	{ 0x23cd0, 0x2f2768 },
	{ 0x23cd1, 0x2f2769 },
	{ 0x23cd2, 0x2f276a },
	{ 0x23cd3, 0x2f276b },
	{ 0x23cd4, 0x2f276d },
	{ 0x23cd5, 0x2f2b64 },
	{ 0x23cd6, 0x2f2b67 },
	{ 0x23cd7, 0x2f2b6c },
	{ 0x23cd8, 0x262c52 },
	{ 0x23cd9, 0x262c54 },
	{ 0x23cda, 0x262c55 },
	{ 0x23cdb, 0x262c59 },
	{ 0x23cdd, 0x262c4f },
	{ 0x23ce3, 0x252978 },
	{ 0x23ce4, 0x24297c },
	{ 0x23ce5, 0x263236 },
	{ 0x23ce6, 0x252a22 },
	{ 0x23ce7, 0x26323b },
	{ 0x23ce8, 0x26323e },
	{ 0x23ce9, 0x252979 },
	{ 0x23cea, 0x242a22 },
	{ 0x23ceb, 0x242d71 },
	{ 0x23cec, 0x252a21 },
	{ 0x23ced, 0x25297e },
	{ 0x23cee, 0x26323a },
	{ 0x23cef, 0x263240 },
	{ 0x23cf0, 0x25297a },
	{ 0x23cf1, 0x263241 },
	{ 0x23cf2, 0x25297d },
	{ 0x23cf3, 0x263870 },
	{ 0x23cf4, 0x26323d },
	{ 0x23cf5, 0x26323c },
	{ 0x23cf6, 0x242a23 },
	{ 0x23cf7, 0x24297d },
	{ 0x23d01, 0x26323f },
	{ 0x23d02, 0x2f2b60 },
	{ 0x23d03, 0x2f2b61 },
	{ 0x23d04, 0x2f2b62 },
	{ 0x23d05, 0x2f2b63 },
	{ 0x23d06, 0x2f2b65 },
	{ 0x23d07, 0x2f2b66 },
	{ 0x23d08, 0x2f2b68 },
	{ 0x23d09, 0x2f2b69 },
	{ 0x23d0a, 0x2f2b6a },
	{ 0x23d0b, 0x2f2b6b },
	{ 0x23d0c, 0x2f2b6d },
	{ 0x23d0d, 0x2f2b6e },
	{ 0x23d0e, 0x2f303a },
	{ 0x23d0f, 0x2f303d },
	{ 0x23d10, 0x2f3044 },
	{ 0x23d11, 0x263238 },
	{ 0x23d12, 0x242a24 },
	{ 0x23d14, 0x263235 },
	{ 0x23d15, 0x263237 },
	{ 0x23d16, 0x252a23 },
	{ 0x23d1d, 0x2f3057 },
	{ 0x23d1e, 0x242d6e },
	{ 0x23d1f, 0x252e49 },
	{ 0x23d20, 0x263930 },
	{ 0x23d21, 0x26392e },
	{ 0x23d22, 0x252e48 },
	{ 0x23d23, 0x252e47 },
	{ 0x23d24, 0x26387c },
	{ 0x23d25, 0x252e4a },
	{ 0x23d26, 0x263871 },
	{ 0x23d27, 0x26387b },
	{ 0x23d28, 0x242d6d },
	{ 0x23d29, 0x242d6f },
	{ 0x23d2a, 0x263925 },
	{ 0x23d2b, 0x263876 },
	{ 0x23d2c, 0x263926 },
	{ 0x23d2d, 0x26392a },
	{ 0x23d2e, 0x263877 },
	{ 0x23d2f, 0x263929 },
	{ 0x23d30, 0x26387e },
	{ 0x23d31, 0x263928 },
	{ 0x23d32, 0x26412a },
	{ 0x23d33, 0x264129 },
	{ 0x23d34, 0x243266 },
	{ 0x23d35, 0x263924 },
	{ 0x23d36, 0x26392c },
	{ 0x23d37, 0x252e45 },
	{ 0x23d38, 0x263923 },
	{ 0x23d39, 0x263873 },
	{ 0x23d3a, 0x26392b },
	{ 0x23d3b, 0x263878 },
	{ 0x23d3c, 0x26392f },
	{ 0x23d3e, 0x263932 },
	{ 0x23d42, 0x264146 },
	{ 0x23d43, 0x2f303b },
	{ 0x23d44, 0x2f303e },
	{ 0x23d45, 0x2f303f },
	{ 0x23d46, 0x2f3040 },
	{ 0x23d47, 0x2f3041 },
	{ 0x23d48, 0x2f3042 },
	{ 0x23d49, 0x2f3043 },
	{ 0x23d4a, 0x2f3045 },
	{ 0x23d4b, 0x2f3046 },
	{ 0x23d4c, 0x2f3047 },
	{ 0x23d4d, 0x2f3048 },
	{ 0x23d4e, 0x2f304a },
	{ 0x23d4f, 0x2f304b },
	{ 0x23d50, 0x2f304c },
	{ 0x23d51, 0x2f304d },
	{ 0x23d52, 0x2f304e },
	{ 0x23d53, 0x2f304f },
	{ 0x23d54, 0x2f3050 },
	{ 0x23d55, 0x2f3051 },
	{ 0x23d56, 0x2f3052 },
	{ 0x23d57, 0x2f3053 },
	{ 0x23d58, 0x2f3054 },
	{ 0x23d59, 0x2f3055 },
	{ 0x23d5a, 0x2f3056 },
	{ 0x23d5b, 0x2f3058 },
	{ 0x23d5c, 0x2f3059 },
	{ 0x23d5d, 0x2f305a },
	{ 0x23d5e, 0x263879 },
	{ 0x23d62, 0x263922 },
	{ 0x23d64, 0x263931 },
	{ 0x23d66, 0x242d72 },
	{ 0x23d68, 0x263927 },
	{ 0x23d69, 0x26387d },
	{ 0x23d6c, 0x263875 },
	{ 0x23d71, 0x252e46 },
	{ 0x23d73, 0x2f362d },
	{ 0x23d77, 0x24325d },
	{ 0x23d78, 0x253340 },
	{ 0x23d79, 0x24325b },
	{ 0x23d7a, 0x24326b },
	{ 0x23d7b, 0x264134 },
	{ 0x23d7c, 0x264138 },
	{ 0x23d7d, 0x26413c },
	{ 0x23d7e, 0x24326a },
	{ 0x23d7f, 0x264143 },
	{ 0x23d80, 0x243261 },
	{ 0x23d81, 0x264136 },
	{ 0x23d82, 0x243265 },
	{ 0x23d83, 0x264135 },
	{ 0x23d84, 0x264145 },
	{ 0x23d85, 0x243269 },
	{ 0x23d86, 0x253333 },
	{ 0x23d87, 0x264131 },
	{ 0x23d88, 0x243260 },
	{ 0x23d89, 0x243267 },
	{ 0x23d8a, 0x264a64 },
	{ 0x23d8b, 0x25333f },
	{ 0x23d8c, 0x264142 },
	{ 0x23d8d, 0x25333e },
	{ 0x23d8e, 0x26413f },
	{ 0x23d8f, 0x243259 },
	{ 0x23d90, 0x24325f },
	{ 0x23d91, 0x26412c },
	{ 0x23d92, 0x24252f },
	{ 0x23d93, 0x26413b },
	{ 0x23d94, 0x264130 },
	{ 0x23d95, 0x264a66 },
	{ 0x23d96, 0x253338 },
	{ 0x23d98, 0x253341 },
	{ 0x23d99, 0x264a58 },
	{ 0x23d9a, 0x264a59 },
	{ 0x23d9b, 0x26413e },
	{ 0x23d9c, 0x264144 },
	{ 0x23d9d, 0x253336 },
	{ 0x23d9e, 0x243262 },
	{ 0x23d9f, 0x264140 },
	{ 0x23da1, 0x25333b },
	{ 0x23da2, 0x26412f },
	{ 0x23da3, 0x264132 },
	{ 0x23da4, 0x25333a },
	{ 0x23da5, 0x253335 },
	{ 0x23da6, 0x24326c },
	{ 0x23db5, 0x24326e },
	{ 0x23dbe, 0x253337 },
	{ 0x23dbf, 0x26413d },
	{ 0x23dc0, 0x2f3621 },
	{ 0x23dc1, 0x2f3622 },
	{ 0x23dc2, 0x2f3623 },
	{ 0x23dc3, 0x2f3625 },
	{ 0x23dc4, 0x2f3626 },
	{ 0x23dc5, 0x2f3627 },
	{ 0x23dc6, 0x2f3628 },
	{ 0x23dc7, 0x2f362a },
	{ 0x23dc8, 0x2f362c },
	{ 0x23dc9, 0x2f362e },
	{ 0x23dca, 0x2f362f },
	{ 0x23dcb, 0x2f3630 },
	{ 0x23dcc, 0x2f3631 },
	{ 0x23dcd, 0x2f3632 },
	{ 0x23dce, 0x2f3636 },
	{ 0x23dcf, 0x2f3637 },
	{ 0x23dd0, 0x2f3638 },
	{ 0x23dd1, 0x2f3639 },
	{ 0x23dd2, 0x2f363a },
	{ 0x23dd3, 0x2f363b },
	{ 0x23dd4, 0x2f363c },
	{ 0x23dd5, 0x2f363d },
	{ 0x23dd6, 0x2f3c42 },
	{ 0x23dd7, 0x2f3c4b },
	{ 0x23dd8, 0x2f3c4d },
	{ 0x23dd9, 0x2f3c57 },
	{ 0x23dda, 0x2f425f },
	{ 0x23ddb, 0x264a57 },
	{ 0x23ddd, 0x264133 },
	{ 0x23ddf, 0x264137 },
	{ 0x23de1, 0x253339 },
	{ 0x23de2, 0x26413a },
	{ 0x23de4, 0x264139 },
	{ 0x23de6, 0x264147 },
	{ 0x23de7, 0x26412d },
	{ 0x23de9, 0x26412e },
	{ 0x23df5, 0x253334 },
	{ 0x23df6, 0x25333c },
	{ 0x23dfb, 0x26387a },
	{ 0x23dfc, 0x264a62 },
	{ 0x23dfd, 0x264a70 },
	{ 0x23dfe, 0x243854 },
	{ 0x23dff, 0x253963 },
	{ 0x23e00, 0x243855 },
	{ 0x23e01, 0x264a5d },
	{ 0x23e02, 0x264a5f },
	{ 0x23e03, 0x253967 },
	{ 0x23e04, 0x25396a },
	{ 0x23e05, 0x253962 },
	{ 0x23e06, 0x265448 },
	{ 0x23e07, 0x25396c },
	{ 0x23e08, 0x264a5a },
	{ 0x23e09, 0x243853 },
	{ 0x23e0a, 0x253342 },
	{ 0x23e0b, 0x243858 },
	{ 0x23e0c, 0x264a6c },
	{ 0x23e0d, 0x264a5c },
	{ 0x23e0e, 0x253968 },
	{ 0x23e0f, 0x264a71 },
	{ 0x23e10, 0x265435 },
	{ 0x23e11, 0x264a67 },
	{ 0x23e12, 0x264a68 },
	{ 0x23e13, 0x264a6e },
	{ 0x23e14, 0x253960 },
	{ 0x23e15, 0x265434 },
	{ 0x23e16, 0x264a6f },
	{ 0x23e17, 0x243e2c },
	{ 0x23e18, 0x25395f },
	{ 0x23e19, 0x253966 },
	{ 0x23e1a, 0x253965 },
	{ 0x23e1b, 0x253964 },
	{ 0x23e1c, 0x264a6a },
	{ 0x23e1d, 0x253961 },
	{ 0x23e1e, 0x265433 },
	{ 0x23e1f, 0x264a72 },
	{ 0x23e20, 0x25396d },
	{ 0x23e21, 0x264a61 },
	{ 0x23e32, 0x2f3c44 },
	{ 0x23e33, 0x2f3c45 },
	{ 0x23e34, 0x2f3c46 },
	{ 0x23e35, 0x2f3c48 },
	{ 0x23e36, 0x2f3c49 },
	{ 0x23e37, 0x2f3c4a },
	{ 0x23e38, 0x2f3c4e },
	{ 0x23e39, 0x2f3c4f },
	{ 0x23e3a, 0x2f3c50 },
	{ 0x23e3b, 0x2f3c51 },
	{ 0x23e3c, 0x2f3c52 },
	{ 0x23e3d, 0x2f3c53 },
	{ 0x23e3e, 0x2f3c54 },
	{ 0x23e3f, 0x2f3c55 },
	{ 0x23e40, 0x2f3c56 },
	{ 0x23e41, 0x2f3c58 },
	{ 0x23e42, 0x2f3c59 },
	{ 0x23e43, 0x2f3c5b },
	{ 0x23e44, 0x2f3c5c },
	{ 0x23e46, 0x264a69 },
	{ 0x23e47, 0x253969 },
	{ 0x23e49, 0x264a6b },
	{ 0x23e4a, 0x24385d },
	{ 0x23e4c, 0x264a5b },
	{ 0x23e4d, 0x264a60 },
	{ 0x23e4e, 0x264a5e },
	{ 0x23e5a, 0x25396b },
	{ 0x23e5b, 0x2f4273 },
	{ 0x23e5d, 0x265441 },
	{ 0x23e5e, 0x254025 },
	{ 0x23e5f, 0x243e41 },
	{ 0x23e60, 0x265438 },
	{ 0x23e61, 0x243e34 },
	{ 0x23e62, 0x26543b },
	{ 0x23e63, 0x265443 },
	{ 0x23e64, 0x243e3b },
	{ 0x23e65, 0x243e43 },
	{ 0x23e66, 0x243e3e },
	{ 0x23e67, 0x243e2e },
	{ 0x23e68, 0x26544a },
	{ 0x23e69, 0x254029 },
	{ 0x23e6a, 0x254026 },
	{ 0x23e6b, 0x243e40 },
	{ 0x23e6c, 0x265e31 },
	{ 0x23e6d, 0x265442 },
	{ 0x23e6e, 0x243e3a },
	{ 0x23e6f, 0x25402f },
	{ 0x23e71, 0x25402d },
	{ 0x23e72, 0x243e31 },
	{ 0x23e73, 0x265e32 },
	{ 0x23e74, 0x243e42 },
	{ 0x23e75, 0x25402c },
	{ 0x23e76, 0x25402e },
	{ 0x23e77, 0x26543e },
	{ 0x23e78, 0x26544c },
	{ 0x23e79, 0x27243c },
	{ 0x23e7a, 0x265447 },
	{ 0x23e7b, 0x24444b },
	{ 0x23e7c, 0x26543f },
	{ 0x23e7d, 0x265446 },
	{ 0x23e7e, 0x265437 },
	{ 0x23e7f, 0x265436 },
	{ 0x23e80, 0x25402b },
	{ 0x23e81, 0x254028 },
	{ 0x23e8c, 0x243e3d },
	{ 0x23e8d, 0x26543c },
	{ 0x23e8e, 0x26543d },
	{ 0x23e8f, 0x265440 },
	{ 0x23e90, 0x265445 },
	{ 0x23e91, 0x2f4258 },
	{ 0x23e92, 0x2f4259 },
	{ 0x23e93, 0x2f425a },
	{ 0x23e94, 0x2f425b },
	{ 0x23e95, 0x2f425c },
	{ 0x23e96, 0x2f425d },
	{ 0x23e97, 0x2f425e },
	{ 0x23e98, 0x2f4260 },
	{ 0x23e99, 0x2f4261 },
	{ 0x23e9a, 0x2f4262 },
	{ 0x23e9b, 0x2f4265 },
	{ 0x23e9c, 0x2f4266 },
	{ 0x23e9d, 0x2f4267 },
	{ 0x23e9e, 0x2f4268 },
	{ 0x23e9f, 0x2f4269 },
	{ 0x23ea0, 0x2f426a },
	{ 0x23ea1, 0x2f426c },
	{ 0x23ea2, 0x2f426d },
	{ 0x23ea3, 0x2f426e },
	{ 0x23ea4, 0x2f426f },
	{ 0x23ea5, 0x2f4270 },
	{ 0x23ea6, 0x2f4271 },
	{ 0x23ea7, 0x2f4272 },
	{ 0x23ea8, 0x2f4275 },
	{ 0x23ea9, 0x2f4922 },
	{ 0x23eaa, 0x2f493e },
	{ 0x23eac, 0x25402a },
	{ 0x23eaf, 0x265444 },
	{ 0x23eb0, 0x243e35 },
	{ 0x23eb1, 0x26544d },
	{ 0x23eb2, 0x26543a },
	{ 0x23eb4, 0x26544b },
	{ 0x23eb6, 0x2f492f },
	{ 0x23ebf, 0x2f426b },
	{ 0x23eca, 0x2f4f6c },
	{ 0x23ecc, 0x265439 },
	{ 0x23ecd, 0x27243d },
	{ 0x23ecf, 0x244454 },
	{ 0x23ed0, 0x244447 },
	{ 0x23ed1, 0x244448 },
	{ 0x23ed2, 0x24444c },
	{ 0x23ed3, 0x25466b },
	{ 0x23ed4, 0x24444e },
	{ 0x23ed5, 0x25466a },
	{ 0x23ed6, 0x254674 },
	{ 0x23ed7, 0x254676 },
	{ 0x23ed8, 0x244445 },
	{ 0x23ed9, 0x244453 },
	{ 0x23eda, 0x265e44 },
	{ 0x23edb, 0x25466f },
	{ 0x23edc, 0x265e41 },
	{ 0x23edd, 0x265e3a },
	{ 0x23ede, 0x244451 },
	{ 0x23edf, 0x244450 },
	{ 0x23ee0, 0x254675 },
	{ 0x23ee1, 0x254672 },
	{ 0x23ee2, 0x25466d },
	{ 0x23ee3, 0x272440 },
	{ 0x23ee4, 0x27243f },
	{ 0x23ee5, 0x254677 },
	{ 0x23ee6, 0x265e45 },
	{ 0x23ee7, 0x24444f },
	{ 0x23ee8, 0x265e39 },
	{ 0x23ee9, 0x265e42 },
	{ 0x23eea, 0x254670 },
	{ 0x23eeb, 0x254671 },
	{ 0x23eec, 0x244441 },
	{ 0x23eed, 0x265e3d },
	{ 0x23eee, 0x254d7a },
	{ 0x23eef, 0x27243e },
	{ 0x23ef0, 0x265e34 },
	{ 0x23ef1, 0x25466e },
	{ 0x23ef2, 0x265e3f },
	{ 0x23eff, 0x254673 },
	{ 0x23f00, 0x2f4923 },
	{ 0x23f01, 0x2f4924 },
	{ 0x23f02, 0x2f4925 },
	{ 0x23f03, 0x2f4926 },
	{ 0x23f04, 0x2f4927 },
	{ 0x23f05, 0x2f4928 },
	{ 0x23f06, 0x2f4929 },
	{ 0x23f07, 0x2f492b },
	{ 0x23f08, 0x2f492c },
	{ 0x23f09, 0x2f492d },
	{ 0x23f0a, 0x2f492e },
	{ 0x23f0b, 0x2f4930 },
	{ 0x23f0c, 0x2f4931 },
	{ 0x23f0d, 0x2f4934 },
	{ 0x23f0e, 0x2f4936 },
	{ 0x23f0f, 0x2f4937 },
	{ 0x23f10, 0x2f4938 },
	{ 0x23f11, 0x2f4939 },
	{ 0x23f12, 0x2f493a },
	{ 0x23f13, 0x2f493c },
	{ 0x23f14, 0x2f493d },
	{ 0x23f15, 0x2f4941 },
	{ 0x23f16, 0x2f4942 },
	{ 0x23f17, 0x2f4943 },
	{ 0x23f18, 0x2f4f6d },
	{ 0x23f19, 0x272268 },
	{ 0x23f1a, 0x244442 },
	{ 0x23f1b, 0x265e3c },
	{ 0x23f1d, 0x265e43 },
	{ 0x23f1f, 0x265e35 },
	{ 0x23f20, 0x25466c },
	{ 0x23f21, 0x265e33 },
	{ 0x23f22, 0x265e37 },
	{ 0x23f23, 0x265e38 },
	{ 0x23f35, 0x2f493b },
	{ 0x23f3b, 0x265e36 },
	{ 0x23f3f, 0x2f492a },
	{ 0x23f43, 0x272462 },
	{ 0x23f44, 0x272452 },
	{ 0x23f45, 0x27244d },
	{ 0x23f46, 0x244a60 },
	{ 0x23f47, 0x27245a },
	{ 0x23f48, 0x272454 },
	{ 0x23f49, 0x27244c },
	{ 0x23f4a, 0x244a65 },
	{ 0x23f4b, 0x244a67 },
	{ 0x23f4c, 0x254e25 },
	{ 0x23f4e, 0x272463 },
	{ 0x23f4f, 0x27244e },
	{ 0x23f50, 0x272450 },
	{ 0x23f51, 0x272456 },
	{ 0x23f52, 0x244a5c },
	{ 0x23f53, 0x272457 },
	{ 0x23f54, 0x272449 },
	{ 0x23f55, 0x254e21 },
	{ 0x23f56, 0x272465 },
	{ 0x23f57, 0x272447 },
	{ 0x23f58, 0x272444 },
	{ 0x23f59, 0x244a66 },
	{ 0x23f5a, 0x254d7b },
	{ 0x23f5b, 0x254e24 },
	{ 0x23f5c, 0x272464 },
	{ 0x23f5d, 0x244a5b },
	{ 0x23f5e, 0x27245b },
	{ 0x23f5f, 0x244a5a },
	{ 0x23f60, 0x272459 },
	{ 0x23f61, 0x254d7e },
	{ 0x23f62, 0x272443 },
	{ 0x23f63, 0x272467 },
	{ 0x23f64, 0x254e23 },
	{ 0x23f65, 0x254d7d },
	{ 0x23f66, 0x272453 },
	{ 0x23f67, 0x272442 },
	{ 0x23f68, 0x273a69 },
	{ 0x23f69, 0x272445 },
	{ 0x23f6a, 0x272468 },
	{ 0x23f6b, 0x254e22 },
	{ 0x23f6c, 0x272441 },
	{ 0x23f6d, 0x27245e },
	{ 0x23f6e, 0x272466 },
	{ 0x23f6f, 0x254e26 },
	{ 0x23f70, 0x254e28 },
	{ 0x23f73, 0x254d7c },
	{ 0x23f74, 0x244a5e },
	{ 0x23f75, 0x27245f },
	{ 0x23f76, 0x27244b },
	{ 0x23f7d, 0x272451 },
	{ 0x23f84, 0x254e27 },
	{ 0x23f85, 0x27245c },
	{ 0x23f86, 0x2f4f59 },
	{ 0x23f87, 0x2f4f5a },
	{ 0x23f88, 0x2f4f5b },
	{ 0x23f89, 0x2f4f5c },
	{ 0x23f8a, 0x2f4f5d },
	{ 0x23f8b, 0x2f4f5e },
	{ 0x23f8c, 0x2f4f5f },
	{ 0x23f8d, 0x2f4f62 },
	{ 0x23f8e, 0x2f4f63 },
	{ 0x23f8f, 0x2f4f64 },
	{ 0x23f90, 0x2f4f65 },
	{ 0x23f91, 0x2f4f66 },
	{ 0x23f92, 0x2f4f67 },
	{ 0x23f93, 0x2f4f68 },
	{ 0x23f94, 0x2f4f6a },
	{ 0x23f95, 0x2f4f6b },
	{ 0x23f96, 0x2f4f6f },
	{ 0x23f97, 0x2f4f70 },
	{ 0x23f98, 0x2f4f71 },
	{ 0x23f99, 0x2f4f72 },
	{ 0x23f9a, 0x2f4f73 },
	{ 0x23f9b, 0x2f4f74 },
	{ 0x23f9c, 0x2f4f75 },
	{ 0x23f9d, 0x2f4f76 },
	{ 0x23f9e, 0x2f4f77 },
	{ 0x23f9f, 0x2f4f78 },
	{ 0x23fa0, 0x2f4f7b },
	{ 0x23fa1, 0x2f4f7c },
	{ 0x23fa2, 0x2f5551 },
	{ 0x23fa3, 0x272455 },
	{ 0x23fa8, 0x272460 },
	{ 0x23fa9, 0x272f30 },
	{ 0x23faa, 0x244a63 },
	{ 0x23fab, 0x272446 },
	{ 0x23fac, 0x27245d },
	{ 0x23fad, 0x272448 },
	{ 0x23fae, 0x27244a },
	{ 0x23fb0, 0x2f554a },
	{ 0x23fb7, 0x2f4f7e },
	{ 0x23fc1, 0x2f4940 },
	{ 0x23fc5, 0x24507c },
	{ 0x23fc6, 0x255535 },
	{ 0x23fc7, 0x255534 },
	{ 0x23fc8, 0x255528 },
	{ 0x23fc9, 0x255529 },
	{ 0x23fca, 0x25552b },
	{ 0x23fcb, 0x272f33 },
	{ 0x23fcc, 0x255530 },
	{ 0x23fcd, 0x272f47 },
	{ 0x23fce, 0x272f40 },
	{ 0x23fcf, 0x272f3a },
	{ 0x23fd0, 0x245079 },
	{ 0x23fd1, 0x272f39 },
	{ 0x23fd2, 0x24507e },
	{ 0x23fd3, 0x255533 },
	{ 0x23fd4, 0x272f3d },
	{ 0x23fd5, 0x272f31 },
	{ 0x23fd6, 0x272f37 },
	{ 0x23fd7, 0x272f46 },
	{ 0x23fd8, 0x272f3b },
	{ 0x23fd9, 0x272f38 },
	{ 0x23fda, 0x272f43 },
	{ 0x23fdb, 0x272f36 },
	{ 0x23fdc, 0x272f32 },
	{ 0x23fdd, 0x255531 },
	{ 0x23fde, 0x25552a },
	{ 0x23fdf, 0x255b77 },
	{ 0x23fe0, 0x272f3c },
	{ 0x23fe1, 0x272f49 },
	{ 0x23fe2, 0x25552c },
	{ 0x23fe3, 0x255b79 },
	{ 0x23fe4, 0x255532 },
	{ 0x23ff1, 0x272f2f },
	{ 0x23ff2, 0x272f34 },
	{ 0x23ff3, 0x272f3e },
	{ 0x23ff4, 0x272f41 },
	{ 0x23ff5, 0x2f5546 },
	{ 0x23ff6, 0x2f5548 },
	{ 0x23ff7, 0x2f5549 },
	{ 0x23ff8, 0x2f554b },
	{ 0x23ff9, 0x2f554c },
	{ 0x23ffa, 0x2f554f },
	{ 0x23ffb, 0x2f5550 },
	{ 0x23ffc, 0x2f5552 },
	{ 0x23ffd, 0x2f5553 },
	{ 0x23ffe, 0x2f5554 },
	{ 0x23fff, 0x2f5555 },
	{ 0x24000, 0x2f5557 },
	{ 0x24001, 0x2f5a6d },
	{ 0x24004, 0x25552f },
	{ 0x24005, 0x272f3f },
	{ 0x24006, 0x272f45 },
	{ 0x24007, 0x272f48 },
	{ 0x24008, 0x272f4a },
	{ 0x2400b, 0x272f2e },
	{ 0x2400e, 0x272f44 },
	{ 0x24011, 0x245121 },
	{ 0x2401f, 0x2f4f61 },
	{ 0x24020, 0x2f5a66 },
	{ 0x24021, 0x2f5a5f },
	{ 0x24022, 0x25543a },
	{ 0x24023, 0x255b7c },
	{ 0x24024, 0x24565a },
	{ 0x24025, 0x24565f },
	{ 0x24026, 0x255b7a },
	{ 0x24027, 0x27387a },
	{ 0x24028, 0x27386e },
	{ 0x24029, 0x245b52 },
	{ 0x2402a, 0x255b7b },
	{ 0x2402b, 0x255b78 },
	{ 0x2402c, 0x273870 },
	{ 0x2402d, 0x273876 },
	{ 0x2402e, 0x27386f },
	{ 0x2402f, 0x273879 },
	{ 0x24030, 0x273874 },
	{ 0x24031, 0x273873 },
	{ 0x24032, 0x256238 },
	{ 0x24033, 0x273875 },
	{ 0x24034, 0x27387b },
	{ 0x24035, 0x255b7d },
	{ 0x24036, 0x273877 },
	{ 0x24037, 0x255537 },
	{ 0x24039, 0x23553a },
	{ 0x2403e, 0x273878 },
	{ 0x2403f, 0x2f5a60 },
	{ 0x24040, 0x2f5a61 },
	{ 0x24041, 0x2f5a62 },
	{ 0x24042, 0x2f5a63 },
	{ 0x24043, 0x2f5a64 },
	{ 0x24044, 0x2f5a65 },
	{ 0x24045, 0x2f5a67 },
	{ 0x24046, 0x2f5a69 },
	{ 0x24047, 0x2f5a6b },
	{ 0x24048, 0x2f5a70 },
	{ 0x24049, 0x273872 },
	{ 0x2404a, 0x255b7e },
	{ 0x2404c, 0x27387c },
	{ 0x2404d, 0x273871 },
	{ 0x24050, 0x2f554e },
	{ 0x24057, 0x2f5a6c },
	{ 0x2405a, 0x2f5a6f },
	{ 0x2405c, 0x2f5547 },
	{ 0x2405d, 0x2f554d },
	{ 0x2405e, 0x2f5a5e },
	{ 0x2405f, 0x272f35 },
	{ 0x24061, 0x25623f },
	{ 0x24062, 0x256246 },
	{ 0x24063, 0x256245 },
	{ 0x24064, 0x245b5d },
	{ 0x24065, 0x25623d },
	{ 0x24066, 0x256239 },
	{ 0x24067, 0x256242 },
	{ 0x24068, 0x274040 },
	{ 0x24069, 0x274046 },
	{ 0x2406a, 0x245b59 },
	{ 0x2406b, 0x25624b },
	{ 0x2406c, 0x256244 },
	{ 0x2406d, 0x27403c },
	{ 0x2406e, 0x256241 },
	{ 0x2406f, 0x25624a },
	{ 0x24070, 0x245b58 },
	{ 0x24071, 0x256243 },
	{ 0x24072, 0x274047 },
	{ 0x24073, 0x25623b },
	{ 0x24074, 0x274041 },
	{ 0x24075, 0x256240 },
	{ 0x24076, 0x274048 },
	{ 0x24077, 0x27403a },
	{ 0x24078, 0x245b5f },
	{ 0x24079, 0x245b55 },
	{ 0x2407a, 0x274045 },
	{ 0x2407b, 0x274044 },
	{ 0x2407c, 0x27403e },
	{ 0x2407d, 0x25623a },
	{ 0x2407e, 0x245b53 },
	{ 0x2407f, 0x25623c },
	{ 0x24080, 0x25623e },
	{ 0x24081, 0x256249 },
	{ 0x24082, 0x25624c },
	{ 0x24083, 0x256247 },
	{ 0x24084, 0x27403f },
	{ 0x24085, 0x245b5c },
	{ 0x24086, 0x274042 },
	{ 0x24087, 0x27475f },
	{ 0x2408a, 0x25624d },
	{ 0x2408e, 0x2f5f33 },
	{ 0x2408f, 0x2f5f35 },
	{ 0x24090, 0x2f5f36 },
	{ 0x24091, 0x2f5f37 },
	{ 0x24092, 0x2f5f39 },
	{ 0x24093, 0x2f5f3a },
	{ 0x24094, 0x2f5f3b },
	{ 0x24095, 0x2f5f3c },
	{ 0x24096, 0x2f5f3d },
	{ 0x24097, 0x2f5f3e },
	{ 0x24098, 0x2f5f3f },
	{ 0x24099, 0x2f5f40 },
	{ 0x2409a, 0x2f5f41 },
	{ 0x2409b, 0x2f5f42 },
	{ 0x2409c, 0x2f5f43 },
	{ 0x2409d, 0x2f6264 },
	{ 0x2409e, 0x2f6265 },
	{ 0x2409f, 0x2f626c },
	{ 0x240a1, 0x27475e },
	{ 0x240a2, 0x27403d },
	{ 0x240a3, 0x274039 },
	{ 0x240a5, 0x274043 },
	{ 0x240a6, 0x27403b },
	{ 0x240af, 0x2f5f34 },
	{ 0x240b0, 0x2f5a6a },
	{ 0x240b1, 0x2f5a6e },
	{ 0x240b2, 0x256248 },
	{ 0x240b3, 0x274765 },
	{ 0x240b4, 0x27475c },
	{ 0x240b5, 0x274762 },
	{ 0x240b6, 0x245f7c },
	{ 0x240b7, 0x245f7a },
	{ 0x240b8, 0x274753 },
	{ 0x240b9, 0x256836 },
	{ 0x240ba, 0x274756 },
	{ 0x240bb, 0x274754 },
	{ 0x240bd, 0x27475b },
	{ 0x240be, 0x27475a },
	{ 0x240bf, 0x274755 },
	{ 0x240c0, 0x256835 },
	{ 0x240c1, 0x274759 },
	{ 0x240c2, 0x27475d },
	{ 0x240c4, 0x256c45 },
	{ 0x240ca, 0x274761 },
	{ 0x240cb, 0x2f6266 },
	{ 0x240cc, 0x2f6267 },
	{ 0x240cd, 0x2f6268 },
	{ 0x240ce, 0x2f6269 },
	{ 0x240cf, 0x2f626a },
	{ 0x240d0, 0x2f626d },
	{ 0x240d1, 0x2f626e },
	{ 0x240d2, 0x2f626f },
	{ 0x240d3, 0x2f6270 },
	{ 0x240d4, 0x2f6271 },
	{ 0x240d5, 0x274757 },
	{ 0x240d7, 0x274760 },
	{ 0x240d8, 0x274766 },
	{ 0x240d9, 0x274764 },
	{ 0x240da, 0x274763 },
	{ 0x240e3, 0x274758 },
	{ 0x240e9, 0x256c47 },
	{ 0x240ea, 0x256c4a },
	{ 0x240eb, 0x256c4b },
	{ 0x240ec, 0x274e2b },
	{ 0x240ed, 0x246359 },
	{ 0x240ef, 0x24635d },
	{ 0x240f0, 0x274e2a },
	{ 0x240f1, 0x274e29 },
	{ 0x240f2, 0x256c48 },
	{ 0x240f4, 0x24635c },
	{ 0x240f5, 0x274e2e },
	{ 0x240f6, 0x246357 },
	{ 0x240f7, 0x246358 },
	{ 0x240f8, 0x246356 },
	{ 0x240f9, 0x274e2d },
	{ 0x240fb, 0x25703b },
	{ 0x240fc, 0x256c49 },
	{ 0x240fd, 0x256c4c },
	{ 0x240fe, 0x274e2f },
	{ 0x24105, 0x2f6542 },
	{ 0x24106, 0x2f6543 },
	{ 0x24107, 0x2f6544 },
	{ 0x24109, 0x274e2c },
	{ 0x2410e, 0x246648 },
	{ 0x2410f, 0x257040 },
	{ 0x24110, 0x275356 },
	{ 0x24111, 0x25703f },
	{ 0x24113, 0x25703d },
	{ 0x24114, 0x24664b },
	{ 0x24115, 0x275354 },
	{ 0x24116, 0x25703c },
	{ 0x24117, 0x275359 },
	{ 0x24118, 0x275353 },
	{ 0x24119, 0x24664d },
	{ 0x2411a, 0x27535f },
	{ 0x2411b, 0x257041 },
	{ 0x2411c, 0x275355 },
	{ 0x2411d, 0x27535a },
	{ 0x2411e, 0x2f6768 },
	{ 0x2411f, 0x2f6769 },
	{ 0x24120, 0x2f676a },
	{ 0x24121, 0x2f676b },
	{ 0x24122, 0x2f676d },
	{ 0x24123, 0x2f676e },
	{ 0x24124, 0x2f676f },
	{ 0x24126, 0x27535b },
	{ 0x24128, 0x27535c },
	{ 0x24129, 0x27535d },
	{ 0x2412a, 0x27535e },
	{ 0x2412b, 0x25703a },
	{ 0x2412c, 0x2f6770 },
	{ 0x24133, 0x2f6955 },
	{ 0x24134, 0x27582e },
	{ 0x24135, 0x275357 },
	{ 0x24136, 0x27582f },
	{ 0x24137, 0x257354 },
	{ 0x24138, 0x257042 },
	{ 0x24139, 0x27582d },
	{ 0x2413a, 0x257355 },
	{ 0x2413b, 0x275831 },
	{ 0x2413d, 0x246872 },
	{ 0x24141, 0x275832 },
	{ 0x24142, 0x2f6953 },
	{ 0x24143, 0x2f6954 },
	{ 0x24145, 0x275833 },
	{ 0x24146, 0x275830 },
	{ 0x24147, 0x27582c },
	{ 0x2414a, 0x257621 },
	{ 0x2414b, 0x257622 },
	{ 0x2414c, 0x275b69 },
	{ 0x2414d, 0x275b68 },
	{ 0x2414e, 0x25757e },
	{ 0x24151, 0x275b67 },
	{ 0x24152, 0x25757d },
	{ 0x24158, 0x2f6a5b },
	{ 0x24159, 0x2f6a5c },
	{ 0x2415a, 0x2f6a5d },
	{ 0x2415b, 0x275b6a },
	{ 0x2415d, 0x275b66 },
	{ 0x24160, 0x275e76 },
	{ 0x24161, 0x257767 },
	{ 0x24162, 0x275e77 },
	{ 0x24163, 0x246c71 },
	{ 0x24164, 0x275e74 },
	{ 0x24166, 0x257766 },
	{ 0x24168, 0x275e75 },
	{ 0x24169, 0x246c72 },
	{ 0x2416a, 0x276079 },
	{ 0x2416b, 0x276078 },
	{ 0x2416d, 0x276077 },
	{ 0x2416e, 0x2f6c2f },
	{ 0x24170, 0x276239 },
	{ 0x24171, 0x246d58 },
	{ 0x24172, 0x257a2b },
	{ 0x24173, 0x257a2a },
	{ 0x24174, 0x246d59 },
	{ 0x24177, 0x246d74 },
	{ 0x24178, 0x257a69 },
	{ 0x24179, 0x257a6a },
	{ 0x2417b, 0x276357 },
	{ 0x2417c, 0x27644b },
	{ 0x2417d, 0x257b41 },
	{ 0x2417e, 0x2f6d26 },
	{ 0x2417f, 0x27655c },
	{ 0x24180, 0x257c3c },
	{ 0x24182, 0x26232f },
	{ 0x24183, 0x262533 },
	{ 0x24184, 0x242324 },
	{ 0x24185, 0x242325 },
	{ 0x24186, 0x262532 },
	{ 0x24188, 0x2f225f },
	{ 0x24189, 0x2f2260 },
	{ 0x2418a, 0x2f2261 },
	{ 0x2418b, 0x262534 },
	{ 0x2418d, 0x242453 },
	{ 0x2418e, 0x242454 },
	{ 0x2418f, 0x252454 },
	{ 0x24190, 0x26284c },
	{ 0x24191, 0x252455 },
	{ 0x24192, 0x252457 },
	{ 0x24194, 0x2f246b },
	{ 0x24195, 0x2f246c },
	{ 0x24196, 0x2f246d },
	{ 0x24197, 0x2f2470 },
	{ 0x24198, 0x2f2472 },
	{ 0x2419a, 0x26284b },
	{ 0x2419d, 0x252674 },
	{ 0x2419e, 0x242728 },
	{ 0x2419f, 0x252675 },
	{ 0x241a6, 0x2f276f },
	{ 0x241a7, 0x2f2770 },
	{ 0x241a8, 0x2f2771 },
	{ 0x241a9, 0x2f2773 },
	{ 0x241aa, 0x2f2774 },
	{ 0x241ab, 0x2f2775 },
	{ 0x241ac, 0x2f2776 },
	{ 0x241ad, 0x2f2777 },
	{ 0x241af, 0x262c5f },
	{ 0x241b0, 0x2f2772 },
	{ 0x241b1, 0x262c5e },
	{ 0x241b2, 0x24272a },
	{ 0x241b4, 0x252456 },
	{ 0x241bc, 0x252a25 },
	{ 0x241bd, 0x26324c },
	{ 0x241be, 0x252a26 },
	{ 0x241bf, 0x263244 },
	{ 0x241c0, 0x252a27 },
	{ 0x241c1, 0x26324b },
	{ 0x241c7, 0x263246 },
	{ 0x241c8, 0x2f2b6f },
	{ 0x241c9, 0x2f2b70 },
	{ 0x241ca, 0x2f2b71 },
	{ 0x241cb, 0x2f2b72 },
	{ 0x241cc, 0x2f2b73 },
	{ 0x241cd, 0x2f2b74 },
	{ 0x241ce, 0x2f2b75 },
	{ 0x241cf, 0x2f2b76 },
	{ 0x241d0, 0x2f2b77 },
	{ 0x241d1, 0x2f2b78 },
	{ 0x241d2, 0x2f2b79 },
	{ 0x241d3, 0x2f2b7b },
	{ 0x241d4, 0x2f2b7c },
	{ 0x241d5, 0x2f2b7d },
	{ 0x241d6, 0x2f2b7e },
	{ 0x241d7, 0x2f2c21 },
	{ 0x241d8, 0x2f2c23 },
	{ 0x241d9, 0x242a29 },
	{ 0x241da, 0x263245 },
	{ 0x241db, 0x263243 },
	{ 0x241dd, 0x263247 },
	{ 0x241df, 0x26393a },
	{ 0x241e0, 0x252a28 },
	{ 0x241e1, 0x26324a },
	{ 0x241e2, 0x2f2c22 },
	{ 0x241eb, 0x263249 },
	{ 0x241ef, 0x252e4f },
	{ 0x241f0, 0x252e4e },
	{ 0x241f1, 0x263936 },
	{ 0x241f2, 0x263939 },
	{ 0x241f3, 0x2f306a },
	{ 0x241f4, 0x24326f },
	{ 0x241f5, 0x263937 },
	{ 0x241f6, 0x242d74 },
	{ 0x241f7, 0x263934 },
	{ 0x241fd, 0x252e4b },
	{ 0x241fe, 0x2f305d },
	{ 0x241ff, 0x2f305e },
	{ 0x24200, 0x2f305f },
	{ 0x24201, 0x2f3060 },
	{ 0x24202, 0x2f3061 },
	{ 0x24203, 0x2f3062 },
	{ 0x24204, 0x2f3063 },
	{ 0x24205, 0x2f3064 },
	{ 0x24206, 0x2f3065 },
	{ 0x24207, 0x2f3066 },
	{ 0x24208, 0x2f3068 },
	{ 0x24209, 0x2f3069 },
	{ 0x2420a, 0x2f306b },
	{ 0x2420b, 0x2f306c },
	{ 0x2420c, 0x2f306e },
	{ 0x2420d, 0x2f306f },
	{ 0x2420e, 0x2f3070 },
	{ 0x2420f, 0x2f3071 },
	{ 0x24210, 0x2f3072 },
	{ 0x24211, 0x252e4c },
	{ 0x24212, 0x263935 },
	{ 0x24215, 0x26393b },
	{ 0x24216, 0x26393c },
	{ 0x24218, 0x2f3067 },
	{ 0x2421b, 0x2f306d },
	{ 0x24222, 0x263938 },
	{ 0x24223, 0x252e4d },
	{ 0x24225, 0x26414b },
	{ 0x24226, 0x243274 },
	{ 0x24227, 0x253344 },
	{ 0x24228, 0x26414f },
	{ 0x24229, 0x243273 },
	{ 0x2422a, 0x243275 },
	{ 0x2422b, 0x26414e },
	{ 0x2422c, 0x264154 },
	{ 0x2422d, 0x264151 },
	{ 0x2422e, 0x26414d },
	{ 0x2422f, 0x26414c },
	{ 0x24230, 0x264a73 },
	{ 0x24231, 0x264152 },
	{ 0x24232, 0x264150 },
	{ 0x24239, 0x264153 },
	{ 0x2423a, 0x2f3624 },
	{ 0x2423b, 0x2f363e },
	{ 0x2423c, 0x2f363f },
	{ 0x2423d, 0x2f3640 },
	{ 0x2423e, 0x2f3641 },
	{ 0x2423f, 0x2f3643 },
	{ 0x24240, 0x2f3644 },
	{ 0x24241, 0x2f3645 },
	{ 0x24242, 0x2f3646 },
	{ 0x24243, 0x2f3647 },
	{ 0x24244, 0x2f3649 },
	{ 0x24245, 0x2f364a },
	{ 0x24246, 0x2f364c },
	{ 0x24247, 0x2f364d },
	{ 0x24248, 0x2f364e },
	{ 0x24249, 0x2f3650 },
	{ 0x2424a, 0x264149 },
	{ 0x24251, 0x264148 },
	{ 0x24259, 0x2f364b },
	{ 0x2425d, 0x253343 },
	{ 0x2425f, 0x253345 },
	{ 0x24261, 0x264155 },
	{ 0x24262, 0x243869 },
	{ 0x24263, 0x264a78 },
	{ 0x24264, 0x26414a },
	{ 0x24265, 0x253971 },
	{ 0x24266, 0x25396f },
	{ 0x24267, 0x264a7e },
	{ 0x24269, 0x264b21 },
	{ 0x2426a, 0x25396e },
	{ 0x2426b, 0x264a75 },
	{ 0x2426c, 0x243866 },
	{ 0x2426d, 0x264a7a },
	{ 0x2426e, 0x264a74 },
	{ 0x2426f, 0x264a7d },
	{ 0x24279, 0x243863 },
	{ 0x2427a, 0x253970 },
	{ 0x2427b, 0x264a77 },
	{ 0x2427c, 0x2f3c5e },
	{ 0x2427d, 0x2f3c5f },
	{ 0x2427e, 0x2f3c60 },
	{ 0x2427f, 0x2f3c61 },
	{ 0x24280, 0x2f3c62 },
	{ 0x24281, 0x2f3c63 },
	{ 0x24282, 0x2f3c64 },
	{ 0x24283, 0x2f3c66 },
	{ 0x24284, 0x2f3c67 },
	{ 0x24285, 0x2f3c68 },
	{ 0x24286, 0x2f3c69 },
	{ 0x24287, 0x2f3c6b },
	{ 0x24288, 0x2f3c6c },
	{ 0x24289, 0x2f3c6d },
	{ 0x2428a, 0x2f3c6e },
	{ 0x2428b, 0x2f3c6f },
	{ 0x2428c, 0x2f3c70 },
	{ 0x2428d, 0x2f3c71 },
	{ 0x2428e, 0x2f3c72 },
	{ 0x2428f, 0x2f3c75 },
	{ 0x24290, 0x2f3c77 },
	{ 0x24291, 0x2f3c78 },
	{ 0x24292, 0x2f3c79 },
	{ 0x24293, 0x2f3c7a },
	{ 0x24294, 0x2f3c7b },
	{ 0x24295, 0x2f3c7c },
	{ 0x24296, 0x2f3d21 },
	{ 0x24297, 0x264a79 },
	{ 0x24298, 0x264a7c },
	{ 0x24299, 0x243867 },
	{ 0x2429b, 0x264a76 },
	{ 0x2429c, 0x264a7b },
	{ 0x242a5, 0x2f3c6a },
	{ 0x242af, 0x253972 },
	{ 0x242b2, 0x254034 },
	{ 0x242b4, 0x26545a },
	{ 0x242b5, 0x265458 },
	{ 0x242b6, 0x254030 },
	{ 0x242b7, 0x265456 },
	{ 0x242b8, 0x26545d },
	{ 0x242b9, 0x243e47 },
	{ 0x242ba, 0x265457 },
	{ 0x242bb, 0x243e44 },
	{ 0x242bc, 0x26545b },
	{ 0x242bd, 0x26545e },
	{ 0x242be, 0x243e45 },
	{ 0x242bf, 0x254032 },
	{ 0x242c0, 0x265453 },
	{ 0x242c1, 0x265463 },
	{ 0x242c2, 0x26545f },
	{ 0x242c3, 0x265464 },
	{ 0x242c4, 0x254035 },
	{ 0x242c6, 0x26545c },
	{ 0x242c7, 0x265462 },
	{ 0x242cb, 0x2f4276 },
	{ 0x242cc, 0x2f4279 },
	{ 0x242cd, 0x2f427b },
	{ 0x242ce, 0x2f427c },
	{ 0x242cf, 0x2f427d },
	{ 0x242d0, 0x2f4321 },
	{ 0x242d1, 0x2f4322 },
	{ 0x242d2, 0x2f4323 },
	{ 0x242d3, 0x2f4325 },
	{ 0x242d4, 0x2f4326 },
	{ 0x242d5, 0x2f4327 },
	{ 0x242d6, 0x2f4328 },
	{ 0x242d7, 0x2f4329 },
	{ 0x242d8, 0x2f432a },
	{ 0x242d9, 0x2f432b },
	{ 0x242da, 0x2f432d },
	{ 0x242db, 0x2f432e },
	{ 0x242dc, 0x2f4330 },
	{ 0x242dd, 0x2f4333 },
	{ 0x242de, 0x2f4334 },
	{ 0x242df, 0x2f4335 },
	{ 0x242e0, 0x2f4336 },
	{ 0x242e1, 0x2f4337 },
	{ 0x242e2, 0x2f4338 },
	{ 0x242e3, 0x2f4339 },
	{ 0x242e4, 0x2f433a },
	{ 0x242e5, 0x2f433b },
	{ 0x242e6, 0x2f433d },
	{ 0x242e7, 0x2f433e },
	{ 0x242e8, 0x265451 },
	{ 0x242e9, 0x265452 },
	{ 0x242ea, 0x265455 },
	{ 0x242ec, 0x265466 },
	{ 0x242ef, 0x243e4a },
	{ 0x242f0, 0x265461 },
	{ 0x242f1, 0x265465 },
	{ 0x242f3, 0x265a54 },
	{ 0x242fa, 0x2f432c },
	{ 0x24301, 0x254033 },
	{ 0x24303, 0x254031 },
	{ 0x24307, 0x2f4954 },
	{ 0x24308, 0x265e51 },
	{ 0x24309, 0x265e50 },
	{ 0x2430a, 0x25467e },
	{ 0x2430b, 0x265e4a },
	{ 0x2430c, 0x254722 },
	{ 0x2430d, 0x244455 },
	{ 0x2430e, 0x25467c },
	{ 0x2430f, 0x25467b },
	{ 0x24310, 0x25467a },
	{ 0x24311, 0x272470 },
	{ 0x24312, 0x27246a },
	{ 0x24313, 0x265e46 },
	{ 0x24314, 0x254721 },
	{ 0x24315, 0x265e47 },
	{ 0x24316, 0x265e48 },
	{ 0x2431b, 0x254679 },
	{ 0x2431c, 0x265e4b },
	{ 0x2431d, 0x265e4f },
	{ 0x2431e, 0x2f4944 },
	{ 0x2431f, 0x2f4945 },
	{ 0x24320, 0x2f4946 },
	{ 0x24321, 0x2f4947 },
	{ 0x24322, 0x2f4949 },
	{ 0x24323, 0x2f494a },
	{ 0x24324, 0x2f494c },
	{ 0x24325, 0x2f494d },
	{ 0x24326, 0x2f494e },
	{ 0x24327, 0x2f494f },
	{ 0x24328, 0x2f4950 },
	{ 0x24329, 0x2f4951 },
	{ 0x2432a, 0x2f4952 },
	{ 0x2432b, 0x2f4953 },
	{ 0x2432c, 0x2f4955 },
	{ 0x2432d, 0x2f4956 },
	{ 0x2432e, 0x2f4957 },
	{ 0x2432f, 0x2f495a },
	{ 0x24330, 0x2f495b },
	{ 0x24331, 0x2f495d },
	{ 0x24332, 0x2f495e },
	{ 0x24333, 0x2f4960 },
	{ 0x24334, 0x2f4962 },
	{ 0x24335, 0x2f4963 },
	{ 0x24336, 0x2f4964 },
	{ 0x24338, 0x24445d },
	{ 0x24339, 0x25467d },
	{ 0x2433a, 0x265e4c },
	{ 0x2433b, 0x265e52 },
	{ 0x2433c, 0x265e49 },
	{ 0x2433d, 0x265e4d },
	{ 0x24348, 0x2f495c },
	{ 0x2434d, 0x265460 },
	{ 0x2434e, 0x2f427e },
	{ 0x2434f, 0x2f427a },
	{ 0x24350, 0x244a6b },
	{ 0x24353, 0x254e2c },
	{ 0x24354, 0x272474 },
	{ 0x24355, 0x27246d },
	{ 0x24356, 0x272469 },
	{ 0x24357, 0x254e2a },
	{ 0x24358, 0x27246c },
	{ 0x24359, 0x272471 },
	{ 0x2435a, 0x272472 },
	{ 0x2435b, 0x272475 },
	{ 0x2435c, 0x27246b },
	{ 0x2435d, 0x254e29 },
	{ 0x24362, 0x2f4e22 },
	{ 0x24366, 0x254e2b },
	{ 0x24367, 0x272473 },
	{ 0x24368, 0x2f5023 },
	{ 0x24369, 0x2f5024 },
	{ 0x2436a, 0x2f5026 },
	{ 0x2436b, 0x2f5027 },
	{ 0x2436c, 0x2f5028 },
	{ 0x2436d, 0x2f5029 },
	{ 0x2436e, 0x2f502a },
	{ 0x2436f, 0x2f502b },
	{ 0x24370, 0x2f502e },
	{ 0x24371, 0x2f502f },
	{ 0x24372, 0x2f5031 },
	{ 0x24373, 0x2f5032 },
	{ 0x24374, 0x2f5033 },
	{ 0x24375, 0x2f5034 },
	{ 0x24376, 0x2f5035 },
	{ 0x24377, 0x2f5037 },
	{ 0x24378, 0x2f5038 },
	{ 0x24379, 0x2f5039 },
	{ 0x2437a, 0x2f503a },
	{ 0x2437b, 0x2f503b },
	{ 0x2437c, 0x2f503c },
	{ 0x2437e, 0x27246e },
	{ 0x2437f, 0x2f502c },
	{ 0x24382, 0x272a71 },
	{ 0x24384, 0x2f502d },
	{ 0x24385, 0x2f5030 },
	{ 0x2438c, 0x2f5025 },
	{ 0x24396, 0x2f5022 },
	{ 0x24397, 0x254e2e },
	{ 0x24398, 0x254e2d },
	{ 0x2439a, 0x265e4e },
	{ 0x2439d, 0x24512a },
	{ 0x2439e, 0x272f52 },
	{ 0x2439f, 0x272f66 },
	{ 0x243a0, 0x272f50 },
	{ 0x243a1, 0x272f60 },
	{ 0x243a2, 0x272f5e },
	{ 0x243a3, 0x25553b },
	{ 0x243a4, 0x245127 },
	{ 0x243a5, 0x272f61 },
	{ 0x243a6, 0x272f63 },
	{ 0x243a7, 0x272f55 },
	{ 0x243a8, 0x27246f },
	{ 0x243a9, 0x245128 },
	{ 0x243aa, 0x272f56 },
	{ 0x243ab, 0x272f64 },
	{ 0x243ac, 0x272f65 },
	{ 0x243ad, 0x245126 },
	{ 0x243ae, 0x272f58 },
	{ 0x243af, 0x272f54 },
	{ 0x243b0, 0x245129 },
	{ 0x243b1, 0x272f67 },
	{ 0x243b2, 0x25553a },
	{ 0x243b3, 0x25553c },
	{ 0x243b4, 0x272f62 },
	{ 0x243b5, 0x272f59 },
	{ 0x243b7, 0x272f5d },
	{ 0x243b8, 0x272f5a },
	{ 0x243be, 0x272f4b },
	{ 0x243bf, 0x272f53 },
	{ 0x243c0, 0x272f5c },
	{ 0x243c1, 0x2f5559 },
	{ 0x243c2, 0x2f555a },
	{ 0x243c3, 0x2f555b },
	{ 0x243c4, 0x2f555c },
	{ 0x243c5, 0x2f555d },
	{ 0x243c6, 0x2f555e },
	{ 0x243c7, 0x2f555f },
	{ 0x243c8, 0x2f5560 },
	{ 0x243c9, 0x2f5561 },
	{ 0x243ca, 0x2f5562 },
	{ 0x243cb, 0x2f5563 },
	{ 0x243cc, 0x2f5566 },
	{ 0x243cd, 0x2f5567 },
	{ 0x243ce, 0x2f5568 },
	{ 0x243cf, 0x2f556a },
	{ 0x243d0, 0x2f556b },
	{ 0x243d1, 0x2f556d },
	{ 0x243d2, 0x2f556e },
	{ 0x243d3, 0x2f5570 },
	{ 0x243d4, 0x2f5571 },
	{ 0x243d5, 0x2f5572 },
	{ 0x243d7, 0x2f5565 },
	{ 0x243d8, 0x255538 },
	{ 0x243d9, 0x272f4d },
	{ 0x243da, 0x272f4e },
	{ 0x243db, 0x272f5b },
	{ 0x243dd, 0x272f5f },
	{ 0x243de, 0x27317a },
	{ 0x243df, 0x272f51 },
	{ 0x243e0, 0x272c7b },
	{ 0x243e9, 0x2f556f },
	{ 0x243ed, 0x25553d },
	{ 0x243ee, 0x255539 },
	{ 0x243ef, 0x272f4c },
	{ 0x243f0, 0x272476 },
	{ 0x243f4, 0x272f57 },
	{ 0x243f5, 0x273923 },
	{ 0x243f6, 0x245661 },
	{ 0x243f7, 0x273925 },
	{ 0x243f8, 0x25553e },
	{ 0x243f9, 0x273929 },
	{ 0x243fa, 0x273928 },
	{ 0x243fb, 0x245663 },
	{ 0x243fc, 0x272f68 },
	{ 0x243fd, 0x255c21 },
	{ 0x243fe, 0x27387d },
	{ 0x243ff, 0x255c24 },
	{ 0x24400, 0x255c22 },
	{ 0x24404, 0x2f5a71 },
	{ 0x24405, 0x2f5a72 },
	{ 0x24406, 0x2f5a76 },
	{ 0x24407, 0x2f5a77 },
	{ 0x24408, 0x2f5a78 },
	{ 0x24409, 0x2f5a79 },
	{ 0x2440a, 0x2f5a7a },
	{ 0x2440b, 0x2f5a7b },
	{ 0x2440c, 0x2f5a7c },
	{ 0x2440d, 0x2f5a7d },
	{ 0x2440e, 0x2f5a7e },
	{ 0x2440f, 0x2f5b21 },
	{ 0x24410, 0x2f5b22 },
	{ 0x24411, 0x2f5b23 },
	{ 0x24412, 0x27387e },
	{ 0x24415, 0x273924 },
	{ 0x24417, 0x273922 },
	{ 0x2441e, 0x255c23 },
	{ 0x2441f, 0x273921 },
	{ 0x24422, 0x2f5569 },
	{ 0x24426, 0x27404f },
	{ 0x24427, 0x245b62 },
	{ 0x24428, 0x27404e },
	{ 0x24429, 0x25624e },
	{ 0x2442a, 0x27404b },
	{ 0x2442b, 0x274053 },
	{ 0x2442c, 0x274051 },
	{ 0x2442d, 0x27404c },
	{ 0x2442f, 0x245b63 },
	{ 0x24430, 0x25624f },
	{ 0x24431, 0x256250 },
	{ 0x24432, 0x245b61 },
	{ 0x24433, 0x274054 },
	{ 0x24437, 0x27404a },
	{ 0x24438, 0x274052 },
	{ 0x24439, 0x2f5f44 },
	{ 0x2443a, 0x2f5f46 },
	{ 0x2443b, 0x2f5f45 },
	{ 0x2443c, 0x2f5f47 },
	{ 0x2443d, 0x2f5f48 },
	{ 0x2443e, 0x2f5f49 },
	{ 0x2443f, 0x2f5f4a },
	{ 0x24440, 0x2f5f4c },
	{ 0x24441, 0x2f5f4d },
	{ 0x24442, 0x274050 },
	{ 0x24443, 0x274222 },
	{ 0x24445, 0x274055 },
	{ 0x24446, 0x27404d },
	{ 0x2444a, 0x274049 },
	{ 0x2444b, 0x27392a },
	{ 0x2444e, 0x2f6176 },
	{ 0x2444f, 0x2f5a74 },
	{ 0x24450, 0x2f5a75 },
	{ 0x24452, 0x27476c },
	{ 0x24453, 0x256837 },
	{ 0x24454, 0x246021 },
	{ 0x24456, 0x27476d },
	{ 0x24457, 0x246022 },
	{ 0x2445c, 0x27476a },
	{ 0x2445d, 0x2f6274 },
	{ 0x2445e, 0x2f6275 },
	{ 0x2445f, 0x2f6276 },
	{ 0x24460, 0x2f6277 },
	{ 0x24462, 0x274769 },
	{ 0x24467, 0x274767 },
	{ 0x24468, 0x27476b },
	{ 0x24470, 0x2f5f4b },
	{ 0x24471, 0x274768 },
	{ 0x24472, 0x2f6545 },
	{ 0x24473, 0x256c4f },
	{ 0x24474, 0x274e30 },
	{ 0x24475, 0x274e33 },
	{ 0x24476, 0x274e3b },
	{ 0x24477, 0x256c4e },
	{ 0x24478, 0x256c4d },
	{ 0x24479, 0x256c51 },
	{ 0x2447a, 0x246023 },
	{ 0x2447c, 0x274e32 },
	{ 0x2447d, 0x274e38 },
	{ 0x2447e, 0x246362 },
	{ 0x2447f, 0x246360 },
	{ 0x24480, 0x274e3c },
	{ 0x24481, 0x274e31 },
	{ 0x24482, 0x274e35 },
	{ 0x24486, 0x274e37 },
	{ 0x24488, 0x2f6548 },
	{ 0x24489, 0x274e34 },
	{ 0x2448a, 0x2f6546 },
	{ 0x2448b, 0x2f6547 },
	{ 0x2448c, 0x2f654a },
	{ 0x2448d, 0x2f654b },
	{ 0x2448e, 0x2f654c },
	{ 0x2448f, 0x2f654d },
	{ 0x24490, 0x2f654e },
	{ 0x24493, 0x274e39 },
	{ 0x24497, 0x274e36 },
	{ 0x2449c, 0x274e3a },
	{ 0x2449e, 0x256c50 },
	{ 0x244a1, 0x275364 },
	{ 0x244a2, 0x246361 },
	{ 0x244a3, 0x275366 },
	{ 0x244a4, 0x257043 },
	{ 0x244a6, 0x24664f },
	{ 0x244a7, 0x275367 },
	{ 0x244ab, 0x275362 },
	{ 0x244ac, 0x275363 },
	{ 0x244ae, 0x275365 },
	{ 0x244b3, 0x2f6771 },
	{ 0x244b5, 0x2f6772 },
	{ 0x244b6, 0x2f6773 },
	{ 0x244b7, 0x2f6774 },
	{ 0x244b8, 0x2f6775 },
	{ 0x244ba, 0x275836 },
	{ 0x244bb, 0x257356 },
	{ 0x244bc, 0x246a4f },
	{ 0x244bd, 0x275837 },
	{ 0x244be, 0x275838 },
	{ 0x244c0, 0x275834 },
	{ 0x244c1, 0x2f6956 },
	{ 0x244c2, 0x2f6957 },
	{ 0x244c3, 0x2f6958 },
	{ 0x244c4, 0x275835 },
	{ 0x244c5, 0x275b24 },
	{ 0x244c8, 0x275b6e },
	{ 0x244c9, 0x275b70 },
	{ 0x244ca, 0x275b6d },
	{ 0x244cf, 0x275c44 },
	{ 0x244d0, 0x275b6f },
	{ 0x244d2, 0x275b6c },
	{ 0x244d4, 0x275b6b },
	{ 0x244d5, 0x257623 },
	{ 0x244d6, 0x2f6a60 },
	{ 0x244d7, 0x275e78 },
	{ 0x244d9, 0x2f6a5f },
	{ 0x244da, 0x257768 },
	{ 0x244dc, 0x276121 },
	{ 0x244dd, 0x27607c },
	{ 0x244de, 0x27607e },
	{ 0x244df, 0x276138 },
	{ 0x244e0, 0x27607b },
	{ 0x244e1, 0x27607d },
	{ 0x244e5, 0x27623a },
	{ 0x244e6, 0x257a6b },
	{ 0x244e7, 0x2f6c64 },
	{ 0x244e8, 0x2f6c65 },
	{ 0x244ea, 0x27644d },
	{ 0x244eb, 0x27644c },
	{ 0x244ec, 0x27644e },
	{ 0x244ed, 0x276537 },
	{ 0x244ee, 0x276634 },
	{ 0x244ef, 0x25214b },
	{ 0x244f1, 0x262330 },
	{ 0x244f2, 0x26284d },
	{ 0x244f3, 0x26284e },
	{ 0x244f4, 0x252458 },
	{ 0x244f6, 0x262c62 },
	{ 0x244f7, 0x262c61 },
	{ 0x244f8, 0x262c63 },
	{ 0x244fb, 0x2f2778 },
	{ 0x244fc, 0x2f2779 },
	{ 0x244fd, 0x26324e },
	{ 0x244fe, 0x252a2b },
	{ 0x24500, 0x252a29 },
	{ 0x24501, 0x26324f },
	{ 0x24502, 0x252a2a },
	{ 0x24503, 0x263251 },
	{ 0x24504, 0x2f2c24 },
	{ 0x24505, 0x2f2c25 },
	{ 0x24506, 0x2f2c26 },
	{ 0x24507, 0x26324d },
	{ 0x2450a, 0x263250 },
	{ 0x2450c, 0x252e51 },
	{ 0x2450e, 0x252e50 },
	{ 0x2450f, 0x2f3073 },
	{ 0x24510, 0x264157 },
	{ 0x24511, 0x264156 },
	{ 0x24512, 0x264158 },
	{ 0x24513, 0x2f3651 },
	{ 0x24514, 0x24386a },
	{ 0x24515, 0x264b22 },
	{ 0x24517, 0x264743 },
	{ 0x24518, 0x264d5d },
	{ 0x2451c, 0x265468 },
	{ 0x24520, 0x265469 },
	{ 0x24522, 0x265e53 },
	{ 0x24523, 0x254723 },
	{ 0x24524, 0x265e56 },
	{ 0x24525, 0x265e55 },
	{ 0x24526, 0x265e54 },
	{ 0x24527, 0x27247a },
	{ 0x24528, 0x254e2f },
	{ 0x24529, 0x272477 },
	{ 0x2452a, 0x272479 },
	{ 0x2452c, 0x272478 },
	{ 0x2452e, 0x272f69 },
	{ 0x24530, 0x272f6a },
	{ 0x24531, 0x25553f },
	{ 0x24532, 0x245665 },
	{ 0x24533, 0x2f5b24 },
	{ 0x24534, 0x2f5b25 },
	{ 0x24535, 0x2f5b26 },
	{ 0x24538, 0x2f5573 },
	{ 0x24539, 0x274056 },
	{ 0x24540, 0x256838 },
	{ 0x24542, 0x2f654f },
	{ 0x24543, 0x2f6550 },
	{ 0x24545, 0x274e3d },
	{ 0x24548, 0x275368 },
	{ 0x24549, 0x275b71 },
	{ 0x2454b, 0x275e79 },
	{ 0x2454d, 0x276122 },
	{ 0x2454e, 0x2f2473 },
	{ 0x2454f, 0x2f2474 },
	{ 0x24550, 0x262c64 },
	{ 0x24551, 0x262c65 },
	{ 0x24553, 0x264159 },
	{ 0x24555, 0x26415a },
	{ 0x24556, 0x2f3d22 },
	{ 0x24557, 0x2f3d23 },
	{ 0x24558, 0x26546a },
	{ 0x24559, 0x2f4965 },
	{ 0x2455a, 0x254724 },
	{ 0x2455b, 0x255540 },
	{ 0x2455c, 0x2f2168 },
	{ 0x2455d, 0x262b6b },
	{ 0x2455e, 0x252a2c },
	{ 0x2455f, 0x242a2b },
	{ 0x24560, 0x242d77 },
	{ 0x24561, 0x2f3074 },
	{ 0x24562, 0x25316c },
	{ 0x24563, 0x264b23 },
	{ 0x24564, 0x26546c },
	{ 0x24565, 0x26546b },
	{ 0x24566, 0x255541 },
	{ 0x24567, 0x27247b },
	{ 0x24568, 0x27247c },
	{ 0x24569, 0x255542 },
	{ 0x2456a, 0x262225 },
	{ 0x2456b, 0x262331 },
	{ 0x2456d, 0x262535 },
	{ 0x2456e, 0x26284f },
	{ 0x2456f, 0x24272d },
	{ 0x24570, 0x262c67 },
	{ 0x24571, 0x262c66 },
	{ 0x24572, 0x263252 },
	{ 0x24573, 0x242a2d },
	{ 0x24574, 0x263253 },
	{ 0x24575, 0x263254 },
	{ 0x24576, 0x26393e },
	{ 0x24577, 0x242d78 },
	{ 0x24579, 0x2f3075 },
	{ 0x2457a, 0x26393d },
	{ 0x2457b, 0x26415b },
	{ 0x2457c, 0x26415e },
	{ 0x2457d, 0x26415d },
	{ 0x2457e, 0x243278 },
	{ 0x24581, 0x26415c },
	{ 0x24582, 0x2f3652 },
	{ 0x24583, 0x2f3653 },
	{ 0x24585, 0x264b28 },
	{ 0x24586, 0x264b24 },
	{ 0x24587, 0x264b26 },
	{ 0x24588, 0x264b27 },
	{ 0x24589, 0x264b29 },
	{ 0x2458a, 0x264b25 },
	{ 0x2458b, 0x264d58 },
	{ 0x2458c, 0x26546d },
	{ 0x2458d, 0x26546e },
	{ 0x2458e, 0x2f433f },
	{ 0x2458f, 0x265e58 },
	{ 0x24590, 0x265e59 },
	{ 0x24591, 0x2f4966 },
	{ 0x24593, 0x27247d },
	{ 0x24594, 0x2f503e },
	{ 0x24595, 0x27247e },
	{ 0x24596, 0x255543 },
	{ 0x24597, 0x256251 },
	{ 0x24598, 0x24512c },
	{ 0x24599, 0x272f6b },
	{ 0x2459a, 0x272521 },
	{ 0x2459b, 0x255544 },
	{ 0x2459c, 0x27392b },
	{ 0x2459d, 0x27392c },
	{ 0x2459e, 0x255c25 },
	{ 0x245a0, 0x274770 },
	{ 0x245a2, 0x256c52 },
	{ 0x245a3, 0x275839 },
	{ 0x245a4, 0x275b72 },
	{ 0x245a5, 0x276358 },
	{ 0x245a6, 0x257b42 },
	{ 0x245a7, 0x27644f },
	{ 0x245a8, 0x2f2169 },
	{ 0x245a9, 0x262851 },
	{ 0x245aa, 0x252459 },
	{ 0x245ab, 0x262850 },
	{ 0x245ac, 0x24272e },
	{ 0x245ad, 0x262c6b },
	{ 0x245ae, 0x262c6a },
	{ 0x245af, 0x262c69 },
	{ 0x245b0, 0x262c68 },
	{ 0x245b1, 0x263256 },
	{ 0x245b2, 0x263255 },
	{ 0x245b3, 0x252a2d },
	{ 0x245b4, 0x263257 },
	{ 0x245b7, 0x252a2e },
	{ 0x245ba, 0x252e52 },
	{ 0x245bb, 0x242d79 },
	{ 0x245bc, 0x242d7b },
	{ 0x245bd, 0x263941 },
	{ 0x245be, 0x26393f },
	{ 0x245c0, 0x253346 },
	{ 0x245c1, 0x253347 },
	{ 0x245c2, 0x26415f },
	{ 0x245c4, 0x264162 },
	{ 0x245c5, 0x264160 },
	{ 0x245c7, 0x264b2b },
	{ 0x245c8, 0x24386d },
	{ 0x245c9, 0x264b2e },
	{ 0x245ca, 0x264b2a },
	{ 0x245cb, 0x264b2c },
	{ 0x245cc, 0x264b2d },
	{ 0x245cd, 0x253973 },
	{ 0x245ce, 0x253976 },
	{ 0x245cf, 0x253974 },
	{ 0x245d1, 0x253975 },
	{ 0x245d7, 0x24386e },
	{ 0x245d8, 0x254038 },
	{ 0x245d9, 0x26546f },
	{ 0x245da, 0x243e4d },
	{ 0x245db, 0x254036 },
	{ 0x245dc, 0x254037 },
	{ 0x245e0, 0x265470 },
	{ 0x245e1, 0x2f3d24 },
	{ 0x245e2, 0x254725 },
	{ 0x245e3, 0x265e5b },
	{ 0x245e5, 0x265e5c },
	{ 0x245e6, 0x265e5a },
	{ 0x245e7, 0x2f4967 },
	{ 0x245e8, 0x254e32 },
	{ 0x245e9, 0x272525 },
	{ 0x245ea, 0x254e31 },
	{ 0x245eb, 0x254e30 },
	{ 0x245ec, 0x254e33 },
	{ 0x245ed, 0x272524 },
	{ 0x245ee, 0x272522 },
	{ 0x245ef, 0x254e34 },
	{ 0x245f1, 0x272523 },
	{ 0x245f3, 0x255546 },
	{ 0x245f4, 0x255547 },
	{ 0x245f5, 0x255548 },
	{ 0x245f6, 0x272f6d },
	{ 0x245f7, 0x255545 },
	{ 0x245f8, 0x272f6c },
	{ 0x245fa, 0x255c26 },
	{ 0x245fb, 0x245666 },
	{ 0x245fc, 0x2f5b27 },
	{ 0x245fd, 0x2f5b28 },
	{ 0x245ff, 0x256253 },
	{ 0x24600, 0x256252 },
	{ 0x24603, 0x256c53 },
	{ 0x24604, 0x275369 },
	{ 0x24605, 0x252368 },
	{ 0x24608, 0x263943 },
	{ 0x24609, 0x263942 },
	{ 0x2460c, 0x24386f },
	{ 0x2460d, 0x264b2f },
	{ 0x2460e, 0x2f3d25 },
	{ 0x2460f, 0x2f3d26 },
	{ 0x24610, 0x265471 },
	{ 0x24611, 0x265e5d },
	{ 0x24614, 0x252175 },
	{ 0x24615, 0x2f2263 },
	{ 0x24616, 0x262536 },
	{ 0x24617, 0x2f2262 },
	{ 0x24618, 0x262853 },
	{ 0x24619, 0x2f2475 },
	{ 0x2461a, 0x262852 },
	{ 0x2461b, 0x262854 },
	{ 0x2461c, 0x252679 },
	{ 0x2461d, 0x252722 },
	{ 0x2461e, 0x252678 },
	{ 0x2461f, 0x25267b },
	{ 0x24620, 0x252676 },
	{ 0x24621, 0x25267d },
	{ 0x24622, 0x262c6e },
	{ 0x24623, 0x242730 },
	{ 0x24624, 0x252721 },
	{ 0x24625, 0x262c6c },
	{ 0x24626, 0x25267e },
	{ 0x24627, 0x252723 },
	{ 0x2462b, 0x25267c },
	{ 0x2462c, 0x262c6d },
	{ 0x2462d, 0x2f277b },
	{ 0x2462e, 0x2f277c },
	{ 0x2462f, 0x2f277e },
	{ 0x24630, 0x2f2821 },
	{ 0x24632, 0x25267a },
	{ 0x24633, 0x262c6f },
	{ 0x24634, 0x262c70 },
	{ 0x24638, 0x252a32 },
	{ 0x24639, 0x252a30 },
	{ 0x2463a, 0x252a2f },
	{ 0x2463b, 0x26325f },
	{ 0x2463c, 0x26325c },
	{ 0x2463d, 0x252a33 },
	{ 0x2463e, 0x252a31 },
	{ 0x2463f, 0x242a30 },
	{ 0x24640, 0x26325a },
	{ 0x24642, 0x263259 },
	{ 0x24643, 0x2f2c28 },
	{ 0x24644, 0x2f2c29 },
	{ 0x24649, 0x26325b },
	{ 0x2464a, 0x26325e },
	{ 0x2464c, 0x263258 },
	{ 0x2464d, 0x26325d },
	{ 0x2464f, 0x252a34 },
	{ 0x24650, 0x2f277d },
	{ 0x24651, 0x252e58 },
	{ 0x24652, 0x252e54 },
	{ 0x24653, 0x252e56 },
	{ 0x24654, 0x252e57 },
	{ 0x24655, 0x252e55 },
	{ 0x24657, 0x263944 },
	{ 0x24658, 0x252e59 },
	{ 0x2465b, 0x24327b },
	{ 0x2465c, 0x264167 },
	{ 0x2465d, 0x264168 },
	{ 0x2465e, 0x253349 },
	{ 0x2465f, 0x253977 },
	{ 0x24660, 0x24327d },
	{ 0x24661, 0x24327c },
	{ 0x24662, 0x25334b },
	{ 0x24664, 0x25334c },
	{ 0x24666, 0x2f3654 },
	{ 0x24667, 0x2f3655 },
	{ 0x24668, 0x264165 },
	{ 0x2466a, 0x264169 },
	{ 0x2466b, 0x264164 },
	{ 0x2466d, 0x253348 },
	{ 0x24670, 0x243871 },
	{ 0x24671, 0x243874 },
	{ 0x24672, 0x25397d },
	{ 0x24673, 0x264b34 },
	{ 0x24674, 0x253979 },
	{ 0x24675, 0x25397b },
	{ 0x24677, 0x253978 },
	{ 0x24678, 0x264b32 },
	{ 0x24679, 0x264b35 },
	{ 0x2467a, 0x2f3d27 },
	{ 0x2467b, 0x2f3d28 },
	{ 0x24682, 0x264b33 },
	{ 0x24683, 0x264b30 },
	{ 0x24684, 0x264b31 },
	{ 0x24688, 0x25397a },
	{ 0x24689, 0x25397c },
	{ 0x2468a, 0x25334a },
	{ 0x2468b, 0x2f3d29 },
	{ 0x2468c, 0x264b36 },
	{ 0x2468d, 0x25472b },
	{ 0x2468e, 0x25403e },
	{ 0x2468f, 0x25403c },
	{ 0x24690, 0x243e50 },
	{ 0x24691, 0x265e64 },
	{ 0x24692, 0x265473 },
	{ 0x24693, 0x254726 },
	{ 0x24694, 0x265472 },
	{ 0x24695, 0x265475 },
	{ 0x24696, 0x265474 },
	{ 0x24698, 0x2f4340 },
	{ 0x24699, 0x2f4341 },
	{ 0x2469e, 0x25403d },
	{ 0x246a0, 0x265477 },
	{ 0x246a8, 0x25403b },
	{ 0x246a9, 0x244461 },
	{ 0x246aa, 0x25472d },
	{ 0x246ab, 0x254728 },
	{ 0x246ac, 0x25472e },
	{ 0x246ad, 0x25472c },
	{ 0x246ae, 0x265e5f },
	{ 0x246af, 0x265e63 },
	{ 0x246b0, 0x254727 },
	{ 0x246b1, 0x25472a },
	{ 0x246b2, 0x265e67 },
	{ 0x246b3, 0x265e62 },
	{ 0x246b4, 0x265e61 },
	{ 0x246b5, 0x25403a },
	{ 0x246b6, 0x265e66 },
	{ 0x246b8, 0x2f4968 },
	{ 0x246b9, 0x2f4969 },
	{ 0x246ba, 0x2f496a },
	{ 0x246bb, 0x2f496b },
	{ 0x246bc, 0x25472f },
	{ 0x246bd, 0x254729 },
	{ 0x246be, 0x265e60 },
	{ 0x246bf, 0x265476 },
	{ 0x246c2, 0x265e65 },
	{ 0x246c8, 0x2f496c },
	{ 0x246c9, 0x254730 },
	{ 0x246ca, 0x254e36 },
	{ 0x246cb, 0x272526 },
	{ 0x246cc, 0x244a74 },
	{ 0x246cd, 0x254e39 },
	{ 0x246ce, 0x254e3a },
	{ 0x246cf, 0x254e38 },
	{ 0x246d0, 0x244a70 },
	{ 0x246d1, 0x254e35 },
	{ 0x246d5, 0x2f503f },
	{ 0x246db, 0x272528 },
	{ 0x246df, 0x272527 },
	{ 0x246e1, 0x272f70 },
	{ 0x246e2, 0x255549 },
	{ 0x246e3, 0x25554e },
	{ 0x246e4, 0x272f71 },
	{ 0x246e5, 0x25554b },
	{ 0x246e6, 0x25554d },
	{ 0x246e7, 0x25554a },
	{ 0x246e9, 0x25554c },
	{ 0x246eb, 0x272f6f },
	{ 0x246ef, 0x273930 },
	{ 0x246f0, 0x27392e },
	{ 0x246f1, 0x255c27 },
	{ 0x246f2, 0x245668 },
	{ 0x246f3, 0x245669 },
	{ 0x246f4, 0x272f6e },
	{ 0x246f6, 0x27392f },
	{ 0x246f9, 0x274057 },
	{ 0x246fa, 0x274058 },
	{ 0x246fb, 0x25683a },
	{ 0x246fd, 0x27536a },
	{ 0x246fe, 0x274772 },
	{ 0x246ff, 0x274773 },
	{ 0x24700, 0x274771 },
	{ 0x24702, 0x256839 },
	{ 0x24703, 0x274e3f },
	{ 0x24704, 0x256c54 },
	{ 0x24705, 0x256c55 },
	{ 0x24707, 0x257045 },
	{ 0x24708, 0x27536c },
	{ 0x24709, 0x257044 },
	{ 0x2470b, 0x257046 },
	{ 0x2470c, 0x27583a },
	{ 0x2470d, 0x257359 },
	{ 0x2470f, 0x275b74 },
	{ 0x24710, 0x257358 },
	{ 0x24711, 0x275b75 },
	{ 0x24712, 0x275b73 },
	{ 0x24714, 0x257769 },
	{ 0x24716, 0x276123 },
	{ 0x24717, 0x2f6c31 },
	{ 0x24719, 0x276450 },
	{ 0x2471a, 0x2f213d },
	{ 0x2471b, 0x262332 },
	{ 0x2471c, 0x252177 },
	{ 0x2471d, 0x252178 },
	{ 0x24721, 0x252278 },
	{ 0x24722, 0x25227b },
	{ 0x24723, 0x252277 },
	{ 0x24724, 0x242328 },
	{ 0x24726, 0x25227a },
	{ 0x24728, 0x262537 },
	{ 0x2472b, 0x252279 },
	{ 0x2472f, 0x25245e },
	{ 0x24730, 0x25245f },
	{ 0x24731, 0x24245b },
	{ 0x24732, 0x242737 },
	{ 0x24733, 0x262858 },
	{ 0x24734, 0x24245a },
	{ 0x24735, 0x25245a },
	{ 0x24736, 0x26285e },
	{ 0x24737, 0x25245b },
	{ 0x24738, 0x26285b },
	{ 0x24739, 0x25272f },
	{ 0x2473a, 0x262c72 },
	{ 0x2473b, 0x242457 },
	{ 0x2473c, 0x25245d },
	{ 0x2473d, 0x25245c },
	{ 0x2473e, 0x26285a },
	{ 0x2473f, 0x262859 },
	{ 0x24740, 0x262c73 },
	{ 0x24741, 0x2f2477 },
	{ 0x24742, 0x262857 },
	{ 0x24743, 0x26285c },
	{ 0x24746, 0x26285d },
	{ 0x2474c, 0x262856 },
	{ 0x2474d, 0x242458 },
	{ 0x2474f, 0x262c7a },
	{ 0x24750, 0x252728 },
	{ 0x24751, 0x262c7b },
	{ 0x24752, 0x25272c },
	{ 0x24753, 0x262c79 },
	{ 0x24754, 0x262c7c },
	{ 0x24755, 0x252727 },
	{ 0x24756, 0x25272a },
	{ 0x24757, 0x262c78 },
	{ 0x24758, 0x25272d },
	{ 0x24759, 0x252725 },
	{ 0x2475a, 0x252729 },
	{ 0x2475b, 0x252724 },
	{ 0x2475c, 0x262c77 },
	{ 0x2475e, 0x242738 },
	{ 0x2475f, 0x252a36 },
	{ 0x24760, 0x262855 },
	{ 0x24761, 0x263260 },
	{ 0x24763, 0x25272b },
	{ 0x24764, 0x262c76 },
	{ 0x24765, 0x2f2822 },
	{ 0x24766, 0x262c7d },
	{ 0x24768, 0x262c74 },
	{ 0x2476c, 0x242735 },
	{ 0x2476e, 0x252a35 },
	{ 0x2476f, 0x252a3e },
	{ 0x24770, 0x263268 },
	{ 0x24771, 0x252a39 },
	{ 0x24772, 0x26394b },
	{ 0x24773, 0x252a3d },
	{ 0x24774, 0x263261 },
	{ 0x24775, 0x26394c },
	{ 0x24776, 0x26416c },
	{ 0x24777, 0x252a3c },
	{ 0x24778, 0x242a31 },
	{ 0x24779, 0x252a3b },
	{ 0x2477a, 0x263264 },
	{ 0x2477b, 0x252a3a },
	{ 0x2477c, 0x263266 },
	{ 0x2477d, 0x242a33 },
	{ 0x2477e, 0x252a40 },
	{ 0x2477f, 0x263263 },
	{ 0x24780, 0x252726 },
	{ 0x24781, 0x252a37 },
	{ 0x24782, 0x252a38 },
	{ 0x24784, 0x2f2c2a },
	{ 0x24785, 0x2f2c2c },
	{ 0x24786, 0x2f2c2d },
	{ 0x24788, 0x263265 },
	{ 0x2478f, 0x2f2c2b },
	{ 0x24797, 0x252a3f },
	{ 0x24799, 0x26394e },
	{ 0x2479a, 0x252e5e },
	{ 0x2479b, 0x243321 },
	{ 0x2479c, 0x263949 },
	{ 0x2479d, 0x26394d },
	{ 0x2479e, 0x242e25 },
	{ 0x2479f, 0x252e5b },
	{ 0x247a0, 0x252e60 },
	{ 0x247a1, 0x252e5d },
	{ 0x247a2, 0x242e23 },
	{ 0x247a3, 0x263945 },
	{ 0x247a5, 0x26394a },
	{ 0x247ac, 0x2f3077 },
	{ 0x247ad, 0x2f3078 },
	{ 0x247af, 0x263948 },
	{ 0x247b0, 0x252e5a },
	{ 0x247b2, 0x242e24 },
	{ 0x247b8, 0x263947 },
	{ 0x247b9, 0x26394f },
	{ 0x247be, 0x252e5f },
	{ 0x247bf, 0x263946 },
	{ 0x247c0, 0x25334e },
	{ 0x247c1, 0x2f3076 },
	{ 0x247c3, 0x243324 },
	{ 0x247c4, 0x26416e },
	{ 0x247c5, 0x253355 },
	{ 0x247c6, 0x25397e },
	{ 0x247c7, 0x253352 },
	{ 0x247c8, 0x264170 },
	{ 0x247c9, 0x264173 },
	{ 0x247ca, 0x25334f },
	{ 0x247cb, 0x26416f },
	{ 0x247cc, 0x264b3b },
	{ 0x247cd, 0x243326 },
	{ 0x247ce, 0x253353 },
	{ 0x247cf, 0x264b38 },
	{ 0x247d0, 0x264b37 },
	{ 0x247d1, 0x253350 },
	{ 0x247d2, 0x264b39 },
	{ 0x247d4, 0x264171 },
	{ 0x247d5, 0x264172 },
	{ 0x247d7, 0x264174 },
	{ 0x247d9, 0x264b3a },
	{ 0x247da, 0x253a28 },
	{ 0x247dc, 0x26547b },
	{ 0x247dd, 0x253a26 },
	{ 0x247de, 0x25403f },
	{ 0x247df, 0x243875 },
	{ 0x247e0, 0x253a22 },
	{ 0x247e1, 0x264b44 },
	{ 0x247e2, 0x254040 },
	{ 0x247e3, 0x253a27 },
	{ 0x247e4, 0x243876 },
	{ 0x247e5, 0x253a25 },
	{ 0x247e6, 0x253a24 },
	{ 0x247e7, 0x243878 },
	{ 0x247e8, 0x264b3f },
	{ 0x247e9, 0x243e51 },
	{ 0x247ea, 0x253a21 },
	{ 0x247eb, 0x264b3c },
	{ 0x247ec, 0x264b3e },
	{ 0x247ed, 0x243e57 },
	{ 0x247f2, 0x2f3d2a },
	{ 0x247f3, 0x2f3d2b },
	{ 0x247f4, 0x265479 },
	{ 0x247f5, 0x265272 },
	{ 0x247f6, 0x26547a },
	{ 0x247f8, 0x264b40 },
	{ 0x247fa, 0x264b41 },
	{ 0x247fb, 0x264b45 },
	{ 0x247fd, 0x264b3d },
	{ 0x24807, 0x253a23 },
	{ 0x2480a, 0x2f4343 },
	{ 0x2480d, 0x243e56 },
	{ 0x2480e, 0x254048 },
	{ 0x2480f, 0x265522 },
	{ 0x24810, 0x254047 },
	{ 0x24811, 0x243e55 },
	{ 0x24812, 0x265527 },
	{ 0x24813, 0x25404b },
	{ 0x24814, 0x265524 },
	{ 0x24815, 0x26547e },
	{ 0x24816, 0x26547d },
	{ 0x24817, 0x265526 },
	{ 0x24818, 0x254046 },
	{ 0x24819, 0x254044 },
	{ 0x2481a, 0x254043 },
	{ 0x2481c, 0x265521 },
	{ 0x2481d, 0x254042 },
	{ 0x2481e, 0x265528 },
	{ 0x2481f, 0x25404a },
	{ 0x24820, 0x254041 },
	{ 0x24821, 0x243e58 },
	{ 0x24824, 0x254049 },
	{ 0x24825, 0x265525 },
	{ 0x24826, 0x2f4345 },
	{ 0x24827, 0x2f4346 },
	{ 0x24828, 0x2f4970 },
	{ 0x24829, 0x2f5040 },
	{ 0x2482b, 0x254045 },
	{ 0x2482c, 0x265523 },
	{ 0x24835, 0x25404c },
	{ 0x24839, 0x265e6d },
	{ 0x2483a, 0x25473a },
	{ 0x2483b, 0x265e69 },
	{ 0x2483c, 0x272529 },
	{ 0x2483d, 0x254737 },
	{ 0x2483e, 0x24446b },
	{ 0x2483f, 0x254735 },
	{ 0x24840, 0x254733 },
	{ 0x24841, 0x265e6c },
	{ 0x24842, 0x25473b },
	{ 0x24843, 0x254736 },
	{ 0x24844, 0x254734 },
	{ 0x24845, 0x265e70 },
	{ 0x24846, 0x24446c },
	{ 0x24847, 0x254731 },
	{ 0x2484d, 0x2f496d },
	{ 0x2484e, 0x27252a },
	{ 0x24850, 0x2f496f },
	{ 0x24851, 0x265e6b },
	{ 0x24857, 0x265e68 },
	{ 0x24858, 0x265e6a },
	{ 0x24859, 0x265e6f },
	{ 0x2485c, 0x244a7d },
	{ 0x2485d, 0x25473d },
	{ 0x2485e, 0x25473c },
	{ 0x2485f, 0x254739 },
	{ 0x24860, 0x254738 },
	{ 0x24861, 0x265e71 },
	{ 0x24862, 0x254732 },
	{ 0x24863, 0x272531 },
	{ 0x24864, 0x244a78 },
	{ 0x24865, 0x244a79 },
	{ 0x24866, 0x272530 },
	{ 0x24867, 0x254e3c },
	{ 0x24868, 0x272534 },
	{ 0x24869, 0x272f73 },
	{ 0x2486a, 0x254e41 },
	{ 0x2486b, 0x27252f },
	{ 0x2486c, 0x27252b },
	{ 0x2486d, 0x254e3e },
	{ 0x2486e, 0x254e45 },
	{ 0x24870, 0x254e3b },
	{ 0x24871, 0x254e44 },
	{ 0x24872, 0x254e43 },
	{ 0x24873, 0x254e3d },
	{ 0x24874, 0x25554f },
	{ 0x24875, 0x272f72 },
	{ 0x24876, 0x254e3f },
	{ 0x24879, 0x254e40 },
	{ 0x2487a, 0x254e46 },
	{ 0x2487b, 0x27252c },
	{ 0x2487c, 0x27252d },
	{ 0x2487d, 0x2f5575 },
	{ 0x2487f, 0x255550 },
	{ 0x24883, 0x27252e },
	{ 0x24885, 0x272533 },
	{ 0x24889, 0x2f496e },
	{ 0x2488a, 0x245133 },
	{ 0x2488b, 0x254e42 },
	{ 0x2488c, 0x255557 },
	{ 0x2488d, 0x245135 },
	{ 0x2488e, 0x255555 },
	{ 0x2488f, 0x255551 },
	{ 0x24890, 0x255552 },
	{ 0x24891, 0x272f79 },
	{ 0x24892, 0x245131 },
	{ 0x24893, 0x272f78 },
	{ 0x24894, 0x272f77 },
	{ 0x24895, 0x255c28 },
	{ 0x24896, 0x245136 },
	{ 0x24897, 0x255553 },
	{ 0x24898, 0x255556 },
	{ 0x24899, 0x272f75 },
	{ 0x2489a, 0x273932 },
	{ 0x2489c, 0x24566d },
	{ 0x2489d, 0x273931 },
	{ 0x2489e, 0x272f76 },
	{ 0x248a0, 0x272532 },
	{ 0x248a1, 0x2f5577 },
	{ 0x248a2, 0x272535 },
	{ 0x248a3, 0x255554 },
	{ 0x248a6, 0x255c2a },
	{ 0x248a7, 0x273933 },
	{ 0x248a8, 0x255c29 },
	{ 0x248a9, 0x274777 },
	{ 0x248aa, 0x273935 },
	{ 0x248af, 0x273934 },
	{ 0x248b0, 0x2f5b29 },
	{ 0x248b1, 0x2f5b2a },
	{ 0x248b2, 0x2f5b2b },
	{ 0x248b3, 0x2f5b2c },
	{ 0x248b4, 0x27405d },
	{ 0x248b5, 0x256255 },
	{ 0x248b6, 0x256254 },
	{ 0x248b7, 0x27405a },
	{ 0x248b8, 0x274059 },
	{ 0x248b9, 0x27405c },
	{ 0x248ba, 0x245b68 },
	{ 0x248bb, 0x27405b },
	{ 0x248c0, 0x2f5f4e },
	{ 0x248c1, 0x2f5f4f },
	{ 0x248c3, 0x256256 },
	{ 0x248c5, 0x246364 },
	{ 0x248c8, 0x274778 },
	{ 0x248c9, 0x274e40 },
	{ 0x248ca, 0x274776 },
	{ 0x248cb, 0x274774 },
	{ 0x248cd, 0x274e41 },
	{ 0x248ce, 0x256c56 },
	{ 0x248d0, 0x274e42 },
	{ 0x248d1, 0x257048 },
	{ 0x248d2, 0x27536d },
	{ 0x248d3, 0x257047 },
	{ 0x248d7, 0x246874 },
	{ 0x248d8, 0x257049 },
	{ 0x248d9, 0x27583b },
	{ 0x248db, 0x275b76 },
	{ 0x248dc, 0x275b78 },
	{ 0x248dd, 0x275b77 },
	{ 0x248df, 0x25776a },
	{ 0x248e0, 0x275e7a },
	{ 0x248e2, 0x2f6b55 },
	{ 0x248e3, 0x276124 },
	{ 0x248e4, 0x276359 },
	{ 0x248e6, 0x2f2823 },
	{ 0x248e7, 0x264b46 },
	{ 0x248e8, 0x265e72 },
	{ 0x248e9, 0x25214c },
	{ 0x248ea, 0x262538 },
	{ 0x248eb, 0x262333 },
	{ 0x248ee, 0x26285f },
	{ 0x248ef, 0x252461 },
	{ 0x248f0, 0x24245d },
	{ 0x248f2, 0x24245c },
	{ 0x248f4, 0x262861 },
	{ 0x248f5, 0x262860 },
	{ 0x248f7, 0x2f2479 },
	{ 0x248f8, 0x252460 },
	{ 0x248f9, 0x252730 },
	{ 0x248fa, 0x262d25 },
	{ 0x248fb, 0x24273c },
	{ 0x248fc, 0x252a41 },
	{ 0x24902, 0x2f2825 },
	{ 0x24903, 0x2f2826 },
	{ 0x24904, 0x2f2827 },
	{ 0x24905, 0x2f2828 },
	{ 0x24906, 0x2f2829 },
	{ 0x24908, 0x262d23 },
	{ 0x2490b, 0x2f2c40 },
	{ 0x2490c, 0x2f2824 },
	{ 0x2490d, 0x262d22 },
	{ 0x2490e, 0x2f2c3c },
	{ 0x2490f, 0x263269 },
	{ 0x24910, 0x252a45 },
	{ 0x24911, 0x252a42 },
	{ 0x24912, 0x242a36 },
	{ 0x24913, 0x26326b },
	{ 0x24918, 0x262f69 },
	{ 0x2491a, 0x2f2c2f },
	{ 0x2491b, 0x2f2c30 },
	{ 0x2491c, 0x2f2c31 },
	{ 0x2491d, 0x2f2c33 },
	{ 0x2491e, 0x2f2c34 },
	{ 0x2491f, 0x2f2c35 },
	{ 0x24920, 0x2f2c36 },
	{ 0x24921, 0x2f2c37 },
	{ 0x24922, 0x2f2c38 },
	{ 0x24923, 0x2f2c3a },
	{ 0x24924, 0x2f2c3b },
	{ 0x24925, 0x2f2c3d },
	{ 0x24928, 0x26326a },
	{ 0x2492a, 0x26326c },
	{ 0x2492b, 0x2f2c3e },
	{ 0x2492c, 0x2f2c3f },
	{ 0x2492f, 0x2f2c2e },
	{ 0x24931, 0x252a44 },
	{ 0x24932, 0x252a43 },
	{ 0x24935, 0x263953 },
	{ 0x24936, 0x253356 },
	{ 0x24937, 0x252e61 },
	{ 0x24938, 0x242e29 },
	{ 0x24939, 0x263951 },
	{ 0x2493a, 0x242e28 },
	{ 0x2493b, 0x263952 },
	{ 0x2493c, 0x263954 },
	{ 0x24943, 0x2f3079 },
	{ 0x24944, 0x2f307a },
	{ 0x24945, 0x2f307b },
	{ 0x24946, 0x2f307c },
	{ 0x24947, 0x2f307d },
	{ 0x24948, 0x2f307e },
	{ 0x24949, 0x2f3121 },
	{ 0x2494a, 0x2f3123 },
	{ 0x2494b, 0x2f3124 },
	{ 0x2494c, 0x2f3125 },
	{ 0x2494d, 0x2f3126 },
	{ 0x2494e, 0x263950 },
	{ 0x2494f, 0x2f3663 },
	{ 0x24954, 0x243331 },
	{ 0x24955, 0x263955 },
	{ 0x24956, 0x26417a },
	{ 0x24957, 0x253357 },
	{ 0x24958, 0x26417b },
	{ 0x24959, 0x243332 },
	{ 0x2495a, 0x264177 },
	{ 0x2495b, 0x264178 },
	{ 0x2495c, 0x264179 },
	{ 0x24964, 0x2f3122 },
	{ 0x24965, 0x2f3656 },
	{ 0x24966, 0x2f3658 },
	{ 0x24967, 0x2f365c },
	{ 0x24968, 0x2f365f },
	{ 0x24969, 0x2f3660 },
	{ 0x2496a, 0x2f3661 },
	{ 0x2496b, 0x2f3662 },
	{ 0x2496c, 0x2f3664 },
	{ 0x2496d, 0x2f365d },
	{ 0x24971, 0x26417c },
	{ 0x24974, 0x2f365b },
	{ 0x24975, 0x2f365a },
	{ 0x24976, 0x2f365e },
	{ 0x24977, 0x253358 },
	{ 0x24978, 0x264176 },
	{ 0x24979, 0x2f3d3e },
	{ 0x2497b, 0x2f3d34 },
	{ 0x2497c, 0x264b4b },
	{ 0x2497d, 0x253a2b },
	{ 0x2497e, 0x253a2a },
	{ 0x2497f, 0x253a2c },
	{ 0x24980, 0x265529 },
	{ 0x24981, 0x243e5a },
	{ 0x24983, 0x25404d },
	{ 0x24985, 0x2f3d38 },
	{ 0x24990, 0x24387c },
	{ 0x24991, 0x264b49 },
	{ 0x24992, 0x264b4c },
	{ 0x24993, 0x2f3d2c },
	{ 0x24994, 0x2f3d2d },
	{ 0x24995, 0x2f3d2e },
	{ 0x24996, 0x2f3d2f },
	{ 0x24997, 0x2f3d30 },
	{ 0x24998, 0x2f3d32 },
	{ 0x24999, 0x2f3d35 },
	{ 0x2499a, 0x2f3d36 },
	{ 0x2499b, 0x2f3d37 },
	{ 0x2499c, 0x2f3d39 },
	{ 0x2499d, 0x2f3d3a },
	{ 0x2499e, 0x2f3d3f },
	{ 0x2499f, 0x2f4350 },
	{ 0x249a0, 0x264b4e },
	{ 0x249a1, 0x265532 },
	{ 0x249a2, 0x264b4d },
	{ 0x249a4, 0x2f3d40 },
	{ 0x249a5, 0x264b48 },
	{ 0x249a6, 0x264b4a },
	{ 0x249a8, 0x26552a },
	{ 0x249ab, 0x2f3d33 },
	{ 0x249ac, 0x2f3d3d },
	{ 0x249ad, 0x2f3d31 },
	{ 0x249ae, 0x253a29 },
	{ 0x249af, 0x26552b },
	{ 0x249b0, 0x265530 },
	{ 0x249b1, 0x243e5b },
	{ 0x249b2, 0x265531 },
	{ 0x249b3, 0x26552f },
	{ 0x249b4, 0x26552e },
	{ 0x249bc, 0x25473e },
	{ 0x249bd, 0x2f4347 },
	{ 0x249be, 0x2f434a },
	{ 0x249bf, 0x2f434c },
	{ 0x249c0, 0x2f434d },
	{ 0x249c1, 0x2f434e },
	{ 0x249c2, 0x2f434f },
	{ 0x249c3, 0x2f4351 },
	{ 0x249c4, 0x2f4352 },
	{ 0x249c5, 0x2f4353 },
	{ 0x249c6, 0x2f4354 },
	{ 0x249c7, 0x2f4355 },
	{ 0x249c8, 0x2f4357 },
	{ 0x249c9, 0x2f4358 },
	{ 0x249ca, 0x2f435a },
	{ 0x249cb, 0x2f435b },
	{ 0x249cc, 0x2f435c },
	{ 0x249cd, 0x2f435d },
	{ 0x249ce, 0x2f435e },
	{ 0x249cf, 0x2f435f },
	{ 0x249d0, 0x2f4360 },
	{ 0x249d1, 0x2f4361 },
	{ 0x249d2, 0x2f4362 },
	{ 0x249d3, 0x2f4363 },
	{ 0x249d4, 0x2f4365 },
	{ 0x249d6, 0x26552c },
	{ 0x249d7, 0x25404f },
	{ 0x249d9, 0x253a2e },
	{ 0x249de, 0x2f434b },
	{ 0x249df, 0x2f4348 },
	{ 0x249e0, 0x25473f },
	{ 0x249e2, 0x26552d },
	{ 0x249e3, 0x2f4359 },
	{ 0x249e4, 0x2f497a },
	{ 0x249e5, 0x2f497b },
	{ 0x249e6, 0x2f4a26 },
	{ 0x249e7, 0x272538 },
	{ 0x249ea, 0x265e74 },
	{ 0x249eb, 0x254741 },
	{ 0x249ec, 0x272536 },
	{ 0x249ed, 0x24446d },
	{ 0x249ee, 0x254740 },
	{ 0x249ef, 0x265e75 },
	{ 0x249f0, 0x265e77 },
	{ 0x249f2, 0x265e76 },
	{ 0x249fa, 0x265e73 },
	{ 0x249fb, 0x2f4971 },
	{ 0x249fc, 0x2f4972 },
	{ 0x249fd, 0x2f4973 },
	{ 0x249fe, 0x2f4974 },
	{ 0x249ff, 0x2f4975 },
	{ 0x24a00, 0x2f4977 },
	{ 0x24a01, 0x2f4978 },
	{ 0x24a02, 0x2f4979 },
	{ 0x24a03, 0x2f497c },
	{ 0x24a04, 0x2f497d },
	{ 0x24a05, 0x2f497e },
	{ 0x24a06, 0x2f4a21 },
	{ 0x24a07, 0x2f4a22 },
	{ 0x24a08, 0x2f4a24 },
	{ 0x24a09, 0x2f4a25 },
	{ 0x24a0a, 0x2f4a27 },
	{ 0x24a0b, 0x2f4a28 },
	{ 0x24a0c, 0x2f4a29 },
	{ 0x24a0d, 0x254742 },
	{ 0x24a0f, 0x234826 },
	{ 0x24a10, 0x272539 },
	{ 0x24a13, 0x2f4a23 },
	{ 0x24a14, 0x272540 },
	{ 0x24a15, 0x244a7e },
	{ 0x24a16, 0x254e47 },
	{ 0x24a17, 0x272f7b },
	{ 0x24a18, 0x27253a },
	{ 0x24a19, 0x272f7a },
	{ 0x24a1a, 0x27253c },
	{ 0x24a1b, 0x27253f },
	{ 0x24a1c, 0x272541 },
	{ 0x24a1d, 0x272542 },
	{ 0x24a2b, 0x2f5041 },
	{ 0x24a2c, 0x2f5042 },
	{ 0x24a2d, 0x2f5043 },
	{ 0x24a2e, 0x2f5044 },
	{ 0x24a2f, 0x2f5045 },
	{ 0x24a30, 0x2f5046 },
	{ 0x24a31, 0x2f5048 },
	{ 0x24a32, 0x2f5049 },
	{ 0x24a33, 0x2f504a },
	{ 0x24a34, 0x2f504b },
	{ 0x24a35, 0x2f504c },
	{ 0x24a38, 0x27253d },
	{ 0x24a39, 0x254e48 },
	{ 0x24a3a, 0x27253b },
	{ 0x24a3b, 0x254e49 },
	{ 0x24a3c, 0x2f557c },
	{ 0x24a3d, 0x2f562e },
	{ 0x24a3e, 0x2f5047 },
	{ 0x24a40, 0x273022 },
	{ 0x24a41, 0x27253e },
	{ 0x24a42, 0x255558 },
	{ 0x24a43, 0x25555b },
	{ 0x24a44, 0x255559 },
	{ 0x24a45, 0x24513b },
	{ 0x24a46, 0x273024 },
	{ 0x24a47, 0x272f7d },
	{ 0x24a48, 0x272f7e },
	{ 0x24a49, 0x272f7c },
	{ 0x24a4b, 0x24513c },
	{ 0x24a52, 0x273021 },
	{ 0x24a53, 0x2f5578 },
	{ 0x24a54, 0x2f5579 },
	{ 0x24a55, 0x2f557b },
	{ 0x24a56, 0x2f557d },
	{ 0x24a57, 0x2f5623 },
	{ 0x24a58, 0x2f5624 },
	{ 0x24a59, 0x2f5625 },
	{ 0x24a5a, 0x2f5626 },
	{ 0x24a5b, 0x2f5627 },
	{ 0x24a5c, 0x2f5629 },
	{ 0x24a5d, 0x2f562d },
	{ 0x24a5e, 0x2f562f },
	{ 0x24a5f, 0x273025 },
	{ 0x24a63, 0x273023 },
	{ 0x24a64, 0x273936 },
	{ 0x24a65, 0x2f5630 },
	{ 0x24a66, 0x2f5621 },
	{ 0x24a67, 0x2f5628 },
	{ 0x24a68, 0x25555c },
	{ 0x24a69, 0x25555a },
	{ 0x24a6a, 0x2f562c },
	{ 0x24a6b, 0x27393b },
	{ 0x24a6c, 0x27393d },
	{ 0x24a6d, 0x255c2d },
	{ 0x24a6e, 0x255c2b },
	{ 0x24a6f, 0x27405e },
	{ 0x24a70, 0x273939 },
	{ 0x24a71, 0x245b6a },
	{ 0x24a72, 0x24566e },
	{ 0x24a74, 0x245670 },
	{ 0x24a75, 0x273938 },
	{ 0x24a7b, 0x2f5b2e },
	{ 0x24a7c, 0x2f5b2f },
	{ 0x24a7d, 0x2f5b30 },
	{ 0x24a7e, 0x2f5b31 },
	{ 0x24a7f, 0x2f5b32 },
	{ 0x24a80, 0x2f5b33 },
	{ 0x24a81, 0x2f5b34 },
	{ 0x24a82, 0x2f5b35 },
	{ 0x24a83, 0x255c2c },
	{ 0x24a84, 0x27393a },
	{ 0x24a85, 0x27393c },
	{ 0x24a86, 0x273937 },
	{ 0x24a87, 0x27405f },
	{ 0x24a8b, 0x25683c },
	{ 0x24a8c, 0x245b6b },
	{ 0x24a8d, 0x256257 },
	{ 0x24a8e, 0x246026 },
	{ 0x24a8f, 0x274060 },
	{ 0x24a90, 0x246028 },
	{ 0x24a97, 0x2f5f51 },
	{ 0x24a98, 0x2f5f53 },
	{ 0x24a99, 0x2f5f54 },
	{ 0x24a9a, 0x2f5f55 },
	{ 0x24a9b, 0x2f5f57 },
	{ 0x24a9c, 0x2f5f59 },
	{ 0x24a9d, 0x2f5f5a },
	{ 0x24a9e, 0x2f5f5b },
	{ 0x24a9f, 0x2f5f5c },
	{ 0x24aa0, 0x2f5f5f },
	{ 0x24aa2, 0x274061 },
	{ 0x24aa3, 0x274062 },
	{ 0x24aa4, 0x2f5f50 },
	{ 0x24aa5, 0x2f5f52 },
	{ 0x24aa6, 0x2f5f58 },
	{ 0x24aa8, 0x2f6323 },
	{ 0x24aa9, 0x27477c },
	{ 0x24aaa, 0x27477b },
	{ 0x24aab, 0x25683e },
	{ 0x24aac, 0x27477a },
	{ 0x24aad, 0x274e43 },
	{ 0x24aae, 0x25683d },
	{ 0x24ab4, 0x274779 },
	{ 0x24ab5, 0x2f627c },
	{ 0x24ab6, 0x2f627e },
	{ 0x24ab7, 0x2f6321 },
	{ 0x24ab8, 0x2f6322 },
	{ 0x24ab9, 0x246029 },
	{ 0x24aba, 0x2f6279 },
	{ 0x24abc, 0x2f627a },
	{ 0x24abd, 0x2f627d },
	{ 0x24abe, 0x27536f },
	{ 0x24abf, 0x256c57 },
	{ 0x24ac0, 0x246652 },
	{ 0x24ac1, 0x2f6552 },
	{ 0x24ac2, 0x2f6553 },
	{ 0x24ac3, 0x2f6554 },
	{ 0x24ac4, 0x2f6555 },
	{ 0x24ac5, 0x274e44 },
	{ 0x24ac6, 0x27536e },
	{ 0x24ac8, 0x2f5f5e },
	{ 0x24ac9, 0x246651 },
	{ 0x24aca, 0x27557c },
	{ 0x24acc, 0x246653 },
	{ 0x24acd, 0x27583c },
	{ 0x24ad0, 0x2f6776 },
	{ 0x24ad4, 0x275b79 },
	{ 0x24ad5, 0x246a52 },
	{ 0x24ad6, 0x2f6959 },
	{ 0x24ad7, 0x2f695a },
	{ 0x24ad8, 0x257624 },
	{ 0x24ada, 0x2f6a61 },
	{ 0x24adb, 0x2f6a63 },
	{ 0x24adc, 0x2f6b56 },
	{ 0x24adf, 0x2f6a62 },
	{ 0x24ae3, 0x257931 },
	{ 0x24ae4, 0x276126 },
	{ 0x24ae5, 0x276125 },
	{ 0x24ae6, 0x2f6c32 },
	{ 0x24ae8, 0x257a2c },
	{ 0x24ae9, 0x246e34 },
	{ 0x24aea, 0x262d26 },
	{ 0x24aeb, 0x252a47 },
	{ 0x24aec, 0x252a46 },
	{ 0x24aed, 0x26326d },
	{ 0x24aee, 0x2f2c41 },
	{ 0x24aef, 0x26326e },
	{ 0x24af0, 0x263956 },
	{ 0x24af1, 0x252e63 },
	{ 0x24af2, 0x252e64 },
	{ 0x24af3, 0x263957 },
	{ 0x24af4, 0x263958 },
	{ 0x24af5, 0x243336 },
	{ 0x24af6, 0x253359 },
	{ 0x24af7, 0x25335a },
	{ 0x24af8, 0x2f3665 },
	{ 0x24afa, 0x253a2f },
	{ 0x24afb, 0x253a30 },
	{ 0x24afc, 0x264b4f },
	{ 0x24afd, 0x2f3d41 },
	{ 0x24afe, 0x264b50 },
	{ 0x24b01, 0x243e5c },
	{ 0x24b02, 0x254050 },
	{ 0x24b03, 0x254051 },
	{ 0x24b04, 0x2f4366 },
	{ 0x24b07, 0x272545 },
	{ 0x24b08, 0x265e78 },
	{ 0x24b09, 0x254743 },
	{ 0x24b0b, 0x2f4a2a },
	{ 0x24b0c, 0x254744 },
	{ 0x24b0d, 0x272544 },
	{ 0x24b0e, 0x273026 },
	{ 0x24b0f, 0x24513d },
	{ 0x24b10, 0x254e4a },
	{ 0x24b11, 0x2f504d },
	{ 0x24b12, 0x272543 },
	{ 0x24b16, 0x24513e },
	{ 0x24b17, 0x27393e },
	{ 0x24b18, 0x256258 },
	{ 0x24b19, 0x2f5f60 },
	{ 0x24b1a, 0x245b6d },
	{ 0x24b1b, 0x246654 },
	{ 0x24b1c, 0x275370 },
	{ 0x24b1d, 0x25704a },
	{ 0x24b20, 0x257625 },
	{ 0x24b21, 0x275b7a },
	{ 0x24b22, 0x275e7b },
	{ 0x24b23, 0x27623b },
	{ 0x24b24, 0x27623c },
	{ 0x24b26, 0x252462 },
	{ 0x24b28, 0x252731 },
	{ 0x24b29, 0x24273d },
	{ 0x24b2a, 0x262d27 },
	{ 0x24b2c, 0x252a48 },
	{ 0x24b2d, 0x252a49 },
	{ 0x24b2e, 0x26326f },
	{ 0x24b2f, 0x242a3b },
	{ 0x24b30, 0x242a3e },
	{ 0x24b34, 0x252e65 },
	{ 0x24b35, 0x252e67 },
	{ 0x24b36, 0x26395c },
	{ 0x24b37, 0x252e66 },
	{ 0x24b39, 0x2f3129 },
	{ 0x24b3a, 0x26395b },
	{ 0x24b3b, 0x263959 },
	{ 0x24b3c, 0x26395a },
	{ 0x24b3e, 0x25335d },
	{ 0x24b3f, 0x264222 },
	{ 0x24b40, 0x26417e },
	{ 0x24b41, 0x264224 },
	{ 0x24b42, 0x25335e },
	{ 0x24b43, 0x264223 },
	{ 0x24b44, 0x25335c },
	{ 0x24b45, 0x2f3666 },
	{ 0x24b46, 0x2f3668 },
	{ 0x24b4c, 0x243922 },
	{ 0x24b4d, 0x253a31 },
	{ 0x24b4e, 0x265536 },
	{ 0x24b4f, 0x243927 },
	{ 0x24b50, 0x253a34 },
	{ 0x24b51, 0x253a33 },
	{ 0x24b52, 0x25335f },
	{ 0x24b53, 0x264b52 },
	{ 0x24b54, 0x253a32 },
	{ 0x24b55, 0x25335b },
	{ 0x24b57, 0x264b51 },
	{ 0x24b58, 0x264b53 },
	{ 0x24b5b, 0x243e64 },
	{ 0x24b5c, 0x254052 },
	{ 0x24b5d, 0x265537 },
	{ 0x24b5e, 0x243e5e },
	{ 0x24b5f, 0x254053 },
	{ 0x24b60, 0x265533 },
	{ 0x24b61, 0x265535 },
	{ 0x24b62, 0x243e5f },
	{ 0x24b63, 0x265538 },
	{ 0x24b65, 0x2f4367 },
	{ 0x24b66, 0x265534 },
	{ 0x24b67, 0x254747 },
	{ 0x24b68, 0x265e7c },
	{ 0x24b69, 0x254745 },
	{ 0x24b6a, 0x265e7a },
	{ 0x24b6c, 0x244472 },
	{ 0x24b70, 0x265e79 },
	{ 0x24b73, 0x265e7b },
	{ 0x24b74, 0x254746 },
	{ 0x24b79, 0x244b28 },
	{ 0x24b7a, 0x27254a },
	{ 0x24b7b, 0x254e4c },
	{ 0x24b7c, 0x254e4d },
	{ 0x24b7d, 0x254e4e },
	{ 0x24b7e, 0x272546 },
	{ 0x24b7f, 0x272547 },
	{ 0x24b80, 0x272549 },
	{ 0x24b85, 0x273027 },
	{ 0x24b86, 0x245674 },
	{ 0x24b87, 0x273028 },
	{ 0x24b88, 0x25555f },
	{ 0x24b89, 0x255561 },
	{ 0x24b8a, 0x245140 },
	{ 0x24b8b, 0x255560 },
	{ 0x24b8d, 0x25555e },
	{ 0x24b8e, 0x245676 },
	{ 0x24b8f, 0x255c2e },
	{ 0x24b90, 0x245677 },
	{ 0x24b93, 0x273940 },
	{ 0x24b94, 0x27393f },
	{ 0x24b96, 0x254e4b },
	{ 0x24b98, 0x245b70 },
	{ 0x24b99, 0x25625b },
	{ 0x24b9a, 0x25625a },
	{ 0x24b9b, 0x274064 },
	{ 0x24b9c, 0x256259 },
	{ 0x24b9d, 0x274065 },
	{ 0x24ba1, 0x25683f },
	{ 0x24ba2, 0x274e45 },
	{ 0x24ba6, 0x275371 },
	{ 0x24ba7, 0x275372 },
	{ 0x24ba8, 0x246656 },
	{ 0x24ba9, 0x25704b },
	{ 0x24baa, 0x246655 },
	{ 0x24bab, 0x275373 },
	{ 0x24bad, 0x246876 },
	{ 0x24bae, 0x27583d },
	{ 0x24baf, 0x25735a },
	{ 0x24bb0, 0x257628 },
	{ 0x24bb1, 0x257627 },
	{ 0x24bb2, 0x275b7b },
	{ 0x24bb3, 0x257626 },
	{ 0x24bb5, 0x275c6b },
	{ 0x24bb8, 0x257a6c },
	{ 0x24bb9, 0x276538 },
	{ 0x24bba, 0x262334 },
	{ 0x24bbb, 0x262d28 },
	{ 0x24bbc, 0x252733 },
	{ 0x24bbd, 0x24273e },
	{ 0x24bc0, 0x2f282b },
	{ 0x24bc1, 0x263270 },
	{ 0x24bc3, 0x2f2c43 },
	{ 0x24bc7, 0x254054 },
	{ 0x24bc8, 0x265e7d },
	{ 0x24bc9, 0x27302b },
	{ 0x24bcb, 0x273029 },
	{ 0x24bcc, 0x27302a },
	{ 0x24bcd, 0x245679 },
	{ 0x24bce, 0x274066 },
	{ 0x24bd0, 0x25704c },
	{ 0x24bd3, 0x262335 },
	{ 0x24bd4, 0x262539 },
	{ 0x24bd5, 0x262d29 },
	{ 0x24bd6, 0x252734 },
	{ 0x24bd7, 0x262d2a },
	{ 0x24bd8, 0x2f2c44 },
	{ 0x24bd9, 0x2f2c45 },
	{ 0x24bda, 0x252a4a },
	{ 0x24bdb, 0x242a3f },
	{ 0x24bdd, 0x263271 },
	{ 0x24bde, 0x263479 },
	{ 0x24bdf, 0x252e69 },
	{ 0x24be0, 0x264226 },
	{ 0x24be1, 0x253360 },
	{ 0x24be2, 0x264225 },
	{ 0x24be3, 0x264227 },
	{ 0x24be4, 0x2f3669 },
	{ 0x24be6, 0x265539 },
	{ 0x24be7, 0x264b54 },
	{ 0x24bea, 0x2f3d43 },
	{ 0x24beb, 0x2f3d42 },
	{ 0x24bec, 0x26553b },
	{ 0x24bee, 0x2f4368 },
	{ 0x24bef, 0x26553a },
	{ 0x24bf2, 0x265e7e },
	{ 0x24bf3, 0x27254b },
	{ 0x24bf4, 0x2f4a2b },
	{ 0x24bf7, 0x24567a },
	{ 0x24bf9, 0x2f5b36 },
	{ 0x24bfc, 0x2f6326 },
	{ 0x24bfd, 0x27466e },
	{ 0x24bfe, 0x2f6325 },
	{ 0x24c00, 0x275374 },
	{ 0x24c03, 0x26253a },
	{ 0x24c04, 0x2f247a },
	{ 0x24c05, 0x252735 },
	{ 0x24c06, 0x262d2e },
	{ 0x24c07, 0x26395d },
	{ 0x24c08, 0x253361 },
	{ 0x24c0a, 0x2f4a2c },
	{ 0x24c0d, 0x2f5f61 },
	{ 0x24c0e, 0x27477d },
	{ 0x24c10, 0x2f6c33 },
	{ 0x24c11, 0x25735b },
	{ 0x24c15, 0x24245f },
	{ 0x24c17, 0x2f247c },
	{ 0x24c19, 0x2f247b },
	{ 0x24c1b, 0x262863 },
	{ 0x24c1d, 0x242742 },
	{ 0x24c1e, 0x242553 },
	{ 0x24c1f, 0x24273f },
	{ 0x24c20, 0x252736 },
	{ 0x24c21, 0x262d31 },
	{ 0x24c22, 0x262d30 },
	{ 0x24c23, 0x262d33 },
	{ 0x24c24, 0x2f282c },
	{ 0x24c25, 0x2f282d },
	{ 0x24c28, 0x262d2f },
	{ 0x24c29, 0x242a42 },
	{ 0x24c2a, 0x252a4d },
	{ 0x24c2b, 0x263274 },
	{ 0x24c2c, 0x252a4c },
	{ 0x24c2d, 0x263273 },
	{ 0x24c2e, 0x252a4b },
	{ 0x24c2f, 0x263276 },
	{ 0x24c30, 0x26327a },
	{ 0x24c31, 0x263277 },
	{ 0x24c32, 0x263965 },
	{ 0x24c33, 0x252a4e },
	{ 0x24c34, 0x263278 },
	{ 0x24c35, 0x263275 },
	{ 0x24c36, 0x252e6e },
	{ 0x24c38, 0x2f2c46 },
	{ 0x24c39, 0x2f2c47 },
	{ 0x24c3a, 0x2f2c48 },
	{ 0x24c3b, 0x2f2c49 },
	{ 0x24c3c, 0x2f2c4b },
	{ 0x24c3d, 0x2f2c4c },
	{ 0x24c3e, 0x2f2c4d },
	{ 0x24c3f, 0x2f2c4e },
	{ 0x24c40, 0x2f2c4f },
	{ 0x24c4b, 0x252a4f },
	{ 0x24c4c, 0x252e6a },
	{ 0x24c4d, 0x242e2e },
	{ 0x24c4e, 0x252e6b },
	{ 0x24c4f, 0x263961 },
	{ 0x24c50, 0x263960 },
	{ 0x24c52, 0x263962 },
	{ 0x24c55, 0x26395f },
	{ 0x24c56, 0x263963 },
	{ 0x24c57, 0x2f312a },
	{ 0x24c58, 0x2f312b },
	{ 0x24c59, 0x2f312c },
	{ 0x24c5a, 0x2f312e },
	{ 0x24c5e, 0x242e30 },
	{ 0x24c5f, 0x2f312d },
	{ 0x24c63, 0x252e6d },
	{ 0x24c64, 0x252e6c },
	{ 0x24c65, 0x24333e },
	{ 0x24c66, 0x264228 },
	{ 0x24c67, 0x253363 },
	{ 0x24c68, 0x253362 },
	{ 0x24c69, 0x24333d },
	{ 0x24c6a, 0x26422c },
	{ 0x24c6b, 0x26422f },
	{ 0x24c6c, 0x26422a },
	{ 0x24c6d, 0x26422d },
	{ 0x24c6e, 0x26422e },
	{ 0x24c6f, 0x2f366b },
	{ 0x24c70, 0x2f366c },
	{ 0x24c71, 0x26422b },
	{ 0x24c73, 0x264229 },
	{ 0x24c76, 0x26416b },
	{ 0x24c7c, 0x24392b },
	{ 0x24c7d, 0x243929 },
	{ 0x24c7e, 0x24392a },
	{ 0x24c83, 0x264b57 },
	{ 0x24c84, 0x264b59 },
	{ 0x24c85, 0x2f366a },
	{ 0x24c86, 0x2f3d46 },
	{ 0x24c87, 0x2f3d47 },
	{ 0x24c88, 0x2f3d48 },
	{ 0x24c8b, 0x264b58 },
	{ 0x24c8d, 0x24392d },
	{ 0x24c8e, 0x264b55 },
	{ 0x24c8f, 0x2f3d44 },
	{ 0x24c90, 0x2f3d45 },
	{ 0x24c91, 0x265540 },
	{ 0x24c92, 0x243e6a },
	{ 0x24c93, 0x243e67 },
	{ 0x24c94, 0x26553e },
	{ 0x24c95, 0x26553f },
	{ 0x24c96, 0x243e66 },
	{ 0x24c97, 0x254056 },
	{ 0x24c98, 0x26553c },
	{ 0x24c99, 0x265542 },
	{ 0x24c9a, 0x254055 },
	{ 0x24c9b, 0x265543 },
	{ 0x24c9c, 0x265544 },
	{ 0x24c9d, 0x265541 },
	{ 0x24ca0, 0x2f4369 },
	{ 0x24ca1, 0x2f436a },
	{ 0x24ca3, 0x254057 },
	{ 0x24ca7, 0x26553d },
	{ 0x24cab, 0x265f23 },
	{ 0x24cac, 0x24447a },
	{ 0x24cad, 0x25474a },
	{ 0x24cae, 0x265f22 },
	{ 0x24caf, 0x265f25 },
	{ 0x24cb0, 0x265f28 },
	{ 0x24cb1, 0x2f4a2d },
	{ 0x24cb2, 0x265f26 },
	{ 0x24cb5, 0x265f24 },
	{ 0x24cb6, 0x265f27 },
	{ 0x24cb7, 0x272550 },
	{ 0x24cb8, 0x244b2c },
	{ 0x24cb9, 0x27254c },
	{ 0x24cba, 0x27254e },
	{ 0x24cbb, 0x27254d },
	{ 0x24cbd, 0x27254f },
	{ 0x24cbe, 0x254e4f },
	{ 0x24cbf, 0x272551 },
	{ 0x24cc0, 0x2f504f },
	{ 0x24cc5, 0x244b2b },
	{ 0x24cc8, 0x245145 },
	{ 0x24cc9, 0x245143 },
	{ 0x24cca, 0x245146 },
	{ 0x24ccb, 0x27302c },
	{ 0x24ccc, 0x255562 },
	{ 0x24ccd, 0x2f5632 },
	{ 0x24ccf, 0x272c3b },
	{ 0x24cd2, 0x273941 },
	{ 0x24cd3, 0x255c33 },
	{ 0x24cd4, 0x273943 },
	{ 0x24cd5, 0x255c31 },
	{ 0x24cd6, 0x24567b },
	{ 0x24cd7, 0x273942 },
	{ 0x24cd8, 0x255c34 },
	{ 0x24cda, 0x2f5b37 },
	{ 0x24cdb, 0x273c76 },
	{ 0x24cdf, 0x255c30 },
	{ 0x24ce0, 0x255c32 },
	{ 0x24ce1, 0x2f5631 },
	{ 0x24ce4, 0x245b71 },
	{ 0x24ce9, 0x27477e },
	{ 0x24cea, 0x256841 },
	{ 0x24ceb, 0x274823 },
	{ 0x24cec, 0x274e46 },
	{ 0x24ced, 0x274821 },
	{ 0x24cee, 0x274824 },
	{ 0x24cef, 0x24602d },
	{ 0x24cf2, 0x274822 },
	{ 0x24cf3, 0x274e48 },
	{ 0x24cf6, 0x274e47 },
	{ 0x24cf9, 0x275377 },
	{ 0x24cfa, 0x2f6777 },
	{ 0x24cfb, 0x275375 },
	{ 0x24cfc, 0x275376 },
	{ 0x24cfe, 0x2f6752 },
	{ 0x24cff, 0x27583e },
	{ 0x24d00, 0x246877 },
	{ 0x24d01, 0x275378 },
	{ 0x24d02, 0x275b7d },
	{ 0x24d03, 0x2f6a64 },
	{ 0x24d04, 0x275b7c },
	{ 0x24d05, 0x275e7c },
	{ 0x24d07, 0x27623e },
	{ 0x24d08, 0x27623d },
	{ 0x24d0b, 0x27635a },
	{ 0x24d0c, 0x27635c },
	{ 0x24d0e, 0x27635b },
	{ 0x24d10, 0x276629 },
	{ 0x24d11, 0x276635 },
	{ 0x24d12, 0x276646 },
	{ 0x24d13, 0x262336 },
	{ 0x24d15, 0x26253b },
	{ 0x24d16, 0x2f282e },
	{ 0x24d17, 0x242e32 },
	{ 0x24d18, 0x252a50 },
	{ 0x24d19, 0x24392e },
	{ 0x24d1c, 0x265546 },
	{ 0x24d1d, 0x265545 },
	{ 0x24d1e, 0x265f29 },
	{ 0x24d1f, 0x255563 },
	{ 0x24d20, 0x27302e },
	{ 0x24d21, 0x272552 },
	{ 0x24d24, 0x27583f },
	{ 0x24d25, 0x25227c },
	{ 0x24d26, 0x252464 },
	{ 0x24d27, 0x252465 },
	{ 0x24d28, 0x242460 },
	{ 0x24d29, 0x262866 },
	{ 0x24d2a, 0x262867 },
	{ 0x24d2b, 0x262865 },
	{ 0x24d2e, 0x262868 },
	{ 0x24d2f, 0x242745 },
	{ 0x24d30, 0x262d35 },
	{ 0x24d31, 0x242744 },
	{ 0x24d32, 0x2f282f },
	{ 0x24d33, 0x252738 },
	{ 0x24d34, 0x262d36 },
	{ 0x24d37, 0x26327d },
	{ 0x24d38, 0x242a4b },
	{ 0x24d39, 0x26327c },
	{ 0x24d3a, 0x26327b },
	{ 0x24d3b, 0x252a52 },
	{ 0x24d3c, 0x252a56 },
	{ 0x24d3d, 0x242a47 },
	{ 0x24d3e, 0x242a48 },
	{ 0x24d3f, 0x252a53 },
	{ 0x24d40, 0x242a45 },
	{ 0x24d41, 0x252a54 },
	{ 0x24d42, 0x252a51 },
	{ 0x24d43, 0x252a55 },
	{ 0x24d47, 0x263324 },
	{ 0x24d48, 0x2f2c50 },
	{ 0x24d4b, 0x26327e },
	{ 0x24d4c, 0x2f2c51 },
	{ 0x24d4d, 0x263322 },
	{ 0x24d51, 0x263323 },
	{ 0x24d54, 0x263321 },
	{ 0x24d57, 0x263969 },
	{ 0x24d58, 0x252e6f },
	{ 0x24d59, 0x252e73 },
	{ 0x24d5a, 0x26396f },
	{ 0x24d5b, 0x252e71 },
	{ 0x24d5c, 0x263970 },
	{ 0x24d5d, 0x26396a },
	{ 0x24d5e, 0x252e76 },
	{ 0x24d5f, 0x252e72 },
	{ 0x24d60, 0x252e75 },
	{ 0x24d61, 0x26396d },
	{ 0x24d62, 0x263971 },
	{ 0x24d63, 0x263966 },
	{ 0x24d64, 0x242e3d },
	{ 0x24d65, 0x252e74 },
	{ 0x24d66, 0x263968 },
	{ 0x24d67, 0x242e3e },
	{ 0x24d68, 0x252e70 },
	{ 0x24d69, 0x26396e },
	{ 0x24d6a, 0x2f312f },
	{ 0x24d6b, 0x263967 },
	{ 0x24d6d, 0x26396c },
	{ 0x24d77, 0x264231 },
	{ 0x24d78, 0x264237 },
	{ 0x24d79, 0x253368 },
	{ 0x24d7a, 0x264235 },
	{ 0x24d7b, 0x25336b },
	{ 0x24d7c, 0x243341 },
	{ 0x24d7d, 0x25336a },
	{ 0x24d7e, 0x253366 },
	{ 0x24d7f, 0x264233 },
	{ 0x24d80, 0x243344 },
	{ 0x24d81, 0x253369 },
	{ 0x24d82, 0x2f366d },
	{ 0x24d83, 0x2f366e },
	{ 0x24d84, 0x2f366f },
	{ 0x24d85, 0x264236 },
	{ 0x24d86, 0x264239 },
	{ 0x24d89, 0x264234 },
	{ 0x24d8a, 0x264238 },
	{ 0x24d8b, 0x2f3670 },
	{ 0x24d8c, 0x264230 },
	{ 0x24d93, 0x253367 },
	{ 0x24d94, 0x25336c },
	{ 0x24d95, 0x253a36 },
	{ 0x24d96, 0x253a3f },
	{ 0x24d97, 0x264b61 },
	{ 0x24d98, 0x253a35 },
	{ 0x24d99, 0x264b65 },
	{ 0x24d9a, 0x253a39 },
	{ 0x24d9b, 0x253a3a },
	{ 0x24d9c, 0x253a3c },
	{ 0x24d9d, 0x253a37 },
	{ 0x24d9e, 0x264b63 },
	{ 0x24d9f, 0x264b5f },
	{ 0x24da0, 0x253a40 },
	{ 0x24da1, 0x264b62 },
	{ 0x24da2, 0x264b5b },
	{ 0x24da3, 0x264b66 },
	{ 0x24da4, 0x253a3e },
	{ 0x24da5, 0x264b5e },
	{ 0x24da8, 0x243939 },
	{ 0x24da9, 0x264b5d },
	{ 0x24daa, 0x264b60 },
	{ 0x24dab, 0x264b64 },
	{ 0x24dac, 0x2f3d49 },
	{ 0x24dad, 0x2f3d4a },
	{ 0x24db6, 0x243937 },
	{ 0x24db7, 0x264b5c },
	{ 0x24dc0, 0x243931 },
	{ 0x24dc1, 0x253a38 },
	{ 0x24dc2, 0x26554c },
	{ 0x24dc3, 0x243e72 },
	{ 0x24dc4, 0x243e70 },
	{ 0x24dc5, 0x243e7b },
	{ 0x24dc6, 0x254059 },
	{ 0x24dc7, 0x243e71 },
	{ 0x24dc8, 0x243e75 },
	{ 0x24dc9, 0x24447d },
	{ 0x24dca, 0x243e79 },
	{ 0x24dcb, 0x265549 },
	{ 0x24dcc, 0x25405a },
	{ 0x24dcd, 0x25405c },
	{ 0x24dce, 0x254062 },
	{ 0x24dcf, 0x243e7c },
	{ 0x24dd0, 0x265547 },
	{ 0x24dd1, 0x254061 },
	{ 0x24dd3, 0x26554d },
	{ 0x24dd4, 0x254065 },
	{ 0x24dd5, 0x254063 },
	{ 0x24dd6, 0x25405b },
	{ 0x24dd7, 0x253a3d },
	{ 0x24dd8, 0x25405f },
	{ 0x24dd9, 0x25405e },
	{ 0x24dda, 0x26554b },
	{ 0x24ddb, 0x26554a },
	{ 0x24ddc, 0x243e7d },
	{ 0x24ddd, 0x2f436b },
	{ 0x24dde, 0x2f436c },
	{ 0x24de0, 0x265548 },
	{ 0x24de5, 0x26554e },
	{ 0x24df7, 0x254058 },
	{ 0x24df8, 0x254066 },
	{ 0x24df9, 0x25405d },
	{ 0x24dfb, 0x254758 },
	{ 0x24dfc, 0x254750 },
	{ 0x24dfd, 0x244525 },
	{ 0x24dfe, 0x24452b },
	{ 0x24dff, 0x25474b },
	{ 0x24e00, 0x25474f },
	{ 0x24e01, 0x244526 },
	{ 0x24e02, 0x265f2f },
	{ 0x24e03, 0x265f2a },
	{ 0x24e04, 0x24452e },
	{ 0x24e05, 0x24452a },
	{ 0x24e06, 0x265f2b },
	{ 0x24e07, 0x265f34 },
	{ 0x24e08, 0x25474d },
	{ 0x24e09, 0x25474e },
	{ 0x24e0a, 0x254753 },
	{ 0x24e0b, 0x24452c },
	{ 0x24e0c, 0x265f37 },
	{ 0x24e0d, 0x265f35 },
	{ 0x24e0e, 0x25475a },
	{ 0x24e0f, 0x265f2e },
	{ 0x24e11, 0x244527 },
	{ 0x24e12, 0x244522 },
	{ 0x24e13, 0x254751 },
	{ 0x24e14, 0x254752 },
	{ 0x24e15, 0x265f33 },
	{ 0x24e16, 0x25474c },
	{ 0x24e17, 0x254756 },
	{ 0x24e18, 0x265f31 },
	{ 0x24e19, 0x265f30 },
	{ 0x24e1d, 0x2f4a2e },
	{ 0x24e1e, 0x265f38 },
	{ 0x24e1f, 0x265f2c },
	{ 0x24e20, 0x24452d },
	{ 0x24e22, 0x265f32 },
	{ 0x24e24, 0x265f36 },
	{ 0x24e29, 0x254755 },
	{ 0x24e2a, 0x244b3a },
	{ 0x24e2b, 0x244b36 },
	{ 0x24e2c, 0x244b2d },
	{ 0x24e2d, 0x244b39 },
	{ 0x24e2e, 0x254e53 },
	{ 0x24e2f, 0x244b34 },
	{ 0x24e30, 0x27255d },
	{ 0x24e31, 0x244b32 },
	{ 0x24e32, 0x254e55 },
	{ 0x24e33, 0x254e57 },
	{ 0x24e34, 0x254e54 },
	{ 0x24e35, 0x244b31 },
	{ 0x24e36, 0x272555 },
	{ 0x24e37, 0x244b30 },
	{ 0x24e38, 0x254e51 },
	{ 0x24e39, 0x254e52 },
	{ 0x24e3a, 0x272553 },
	{ 0x24e3b, 0x254757 },
	{ 0x24e3c, 0x254e58 },
	{ 0x24e3d, 0x272554 },
	{ 0x24e3e, 0x27255b },
	{ 0x24e3f, 0x272559 },
	{ 0x24e42, 0x2f5050 },
	{ 0x24e43, 0x2f5051 },
	{ 0x24e44, 0x2f5052 },
	{ 0x24e45, 0x2f5053 },
	{ 0x24e46, 0x2f5054 },
	{ 0x24e49, 0x272556 },
	{ 0x24e4d, 0x27255a },
	{ 0x24e4f, 0x27255e },
	{ 0x24e5b, 0x254e56 },
	{ 0x24e5c, 0x254e50 },
	{ 0x24e5d, 0x24514b },
	{ 0x24e5e, 0x255565 },
	{ 0x24e5f, 0x27302f },
	{ 0x24e60, 0x273030 },
	{ 0x24e61, 0x25556c },
	{ 0x24e62, 0x25556d },
	{ 0x24e63, 0x24514c },
	{ 0x24e64, 0x245147 },
	{ 0x24e65, 0x255568 },
	{ 0x24e66, 0x273035 },
	{ 0x24e67, 0x255566 },
	{ 0x24e68, 0x255567 },
	{ 0x24e69, 0x25556b },
	{ 0x24e6a, 0x273031 },
	{ 0x24e6b, 0x273037 },
	{ 0x24e6c, 0x25556e },
	{ 0x24e6f, 0x2f5634 },
	{ 0x24e70, 0x2f5635 },
	{ 0x24e71, 0x273034 },
	{ 0x24e73, 0x273033 },
	{ 0x24e74, 0x25556a },
	{ 0x24e76, 0x273032 },
	{ 0x24e79, 0x273038 },
	{ 0x24e7b, 0x273039 },
	{ 0x24e80, 0x255564 },
	{ 0x24e81, 0x272557 },
	{ 0x24e84, 0x24567c },
	{ 0x24e85, 0x255c39 },
	{ 0x24e86, 0x255570 },
	{ 0x24e87, 0x273950 },
	{ 0x24e88, 0x245151 },
	{ 0x24e89, 0x244529 },
	{ 0x24e8a, 0x24567e },
	{ 0x24e8b, 0x273947 },
	{ 0x24e8c, 0x255c35 },
	{ 0x24e8d, 0x273948 },
	{ 0x24e8e, 0x255c3c },
	{ 0x24e8f, 0x255c3a },
	{ 0x24e90, 0x255c3d },
	{ 0x24e91, 0x27394f },
	{ 0x24e92, 0x27406a },
	{ 0x24e93, 0x25556f },
	{ 0x24e94, 0x255c37 },
	{ 0x24e95, 0x24567d },
	{ 0x24e96, 0x255c38 },
	{ 0x24e97, 0x245723 },
	{ 0x24e98, 0x273949 },
	{ 0x24e99, 0x27394d },
	{ 0x24e9a, 0x273951 },
	{ 0x24e9b, 0x27394b },
	{ 0x24e9c, 0x273946 },
	{ 0x24e9d, 0x27394c },
	{ 0x24ea1, 0x2f5b38 },
	{ 0x24ea6, 0x273944 },
	{ 0x24ea7, 0x273945 },
	{ 0x24ea8, 0x27394e },
	{ 0x24ea9, 0x255c3b },
	{ 0x24eb7, 0x25625c },
	{ 0x24eb8, 0x255c3e },
	{ 0x24eb9, 0x27394a },
	{ 0x24eba, 0x245b78 },
	{ 0x24ebb, 0x255c40 },
	{ 0x24ebc, 0x256260 },
	{ 0x24ebd, 0x274068 },
	{ 0x24ebe, 0x256265 },
	{ 0x24ebf, 0x274069 },
	{ 0x24ec0, 0x256261 },
	{ 0x24ec1, 0x256264 },
	{ 0x24ec2, 0x245b76 },
	{ 0x24ec3, 0x255c3f },
	{ 0x24ec4, 0x25625d },
	{ 0x24ec5, 0x256262 },
	{ 0x24ec6, 0x25625e },
	{ 0x24ec7, 0x25625f },
	{ 0x24ec8, 0x245b7a },
	{ 0x24ec9, 0x27406d },
	{ 0x24ecd, 0x256263 },
	{ 0x24ed5, 0x27482b },
	{ 0x24ed6, 0x246033 },
	{ 0x24ed7, 0x274827 },
	{ 0x24ed8, 0x246034 },
	{ 0x24ed9, 0x256844 },
	{ 0x24eda, 0x246035 },
	{ 0x24edb, 0x274826 },
	{ 0x24edc, 0x256843 },
	{ 0x24edd, 0x256842 },
	{ 0x24ede, 0x246036 },
	{ 0x24ee1, 0x2f6327 },
	{ 0x24ee2, 0x246031 },
	{ 0x24ee3, 0x274828 },
	{ 0x24ee5, 0x274829 },
	{ 0x24ee8, 0x274825 },
	{ 0x24eee, 0x27482a },
	{ 0x24eef, 0x27406c },
	{ 0x24ef1, 0x24636a },
	{ 0x24ef2, 0x24636b },
	{ 0x24ef3, 0x274e49 },
	{ 0x24ef4, 0x274e4d },
	{ 0x24ef5, 0x274e4c },
	{ 0x24ef6, 0x256c58 },
	{ 0x24ef7, 0x256c59 },
	{ 0x24ef8, 0x274e4e },
	{ 0x24ef9, 0x274e4b },
	{ 0x24efa, 0x274e4a },
	{ 0x24f00, 0x257051 },
	{ 0x24f01, 0x257050 },
	{ 0x24f02, 0x25704e },
	{ 0x24f03, 0x246657 },
	{ 0x24f04, 0x27537a },
	{ 0x24f05, 0x25704f },
	{ 0x24f06, 0x275379 },
	{ 0x24f07, 0x2f6778 },
	{ 0x24f0b, 0x25735f },
	{ 0x24f0c, 0x25735e },
	{ 0x24f0d, 0x25735d },
	{ 0x24f10, 0x275c22 },
	{ 0x24f11, 0x275b7e },
	{ 0x24f12, 0x246a56 },
	{ 0x24f16, 0x275c21 },
	{ 0x24f17, 0x257629 },
	{ 0x24f18, 0x25776b },
	{ 0x24f19, 0x275e7d },
	{ 0x24f1a, 0x275e7e },
	{ 0x24f1c, 0x276142 },
	{ 0x24f1d, 0x276127 },
	{ 0x24f1f, 0x27623f },
	{ 0x24f20, 0x276240 },
	{ 0x24f21, 0x276241 },
	{ 0x24f22, 0x257a6d },
	{ 0x24f23, 0x276451 },
	{ 0x24f24, 0x276539 },
	{ 0x24f25, 0x242463 },
	{ 0x24f27, 0x263325 },
	{ 0x24f28, 0x2f2c52 },
	{ 0x24f29, 0x263973 },
	{ 0x24f2a, 0x263972 },
	{ 0x24f2b, 0x2f3130 },
	{ 0x24f2c, 0x26423a },
	{ 0x24f2d, 0x2f3671 },
	{ 0x24f2f, 0x264b69 },
	{ 0x24f30, 0x264b67 },
	{ 0x24f31, 0x253a41 },
	{ 0x24f32, 0x264b68 },
	{ 0x24f37, 0x27255f },
	{ 0x24f39, 0x245153 },
	{ 0x24f3a, 0x245152 },
	{ 0x24f3c, 0x27303a },
	{ 0x24f3d, 0x26253c },
	{ 0x24f3e, 0x26253d },
	{ 0x24f41, 0x252466 },
	{ 0x24f42, 0x25273a },
	{ 0x24f43, 0x25273b },
	{ 0x24f46, 0x252739 },
	{ 0x24f47, 0x25273c },
	{ 0x24f48, 0x242a4d },
	{ 0x24f49, 0x252a59 },
	{ 0x24f4a, 0x252a58 },
	{ 0x24f4c, 0x252a57 },
	{ 0x24f4d, 0x263327 },
	{ 0x24f4e, 0x263328 },
	{ 0x24f50, 0x263326 },
	{ 0x24f51, 0x2f2c53 },
	{ 0x24f52, 0x2f2c54 },
	{ 0x24f54, 0x263329 },
	{ 0x24f56, 0x252a5a },
	{ 0x24f58, 0x263974 },
	{ 0x24f59, 0x242e42 },
	{ 0x24f5a, 0x263975 },
	{ 0x24f5b, 0x26423c },
	{ 0x24f5d, 0x2f3131 },
	{ 0x24f5e, 0x2f3132 },
	{ 0x24f5f, 0x2f3133 },
	{ 0x24f60, 0x2f3135 },
	{ 0x24f61, 0x2f3136 },
	{ 0x24f64, 0x2f3675 },
	{ 0x24f65, 0x243346 },
	{ 0x24f66, 0x25336e },
	{ 0x24f67, 0x26423b },
	{ 0x24f68, 0x2f3672 },
	{ 0x24f69, 0x2f3673 },
	{ 0x24f6a, 0x2f3676 },
	{ 0x24f6c, 0x264b6b },
	{ 0x24f6f, 0x264b6c },
	{ 0x24f70, 0x264b6a },
	{ 0x24f77, 0x2f3674 },
	{ 0x24f79, 0x254068 },
	{ 0x24f7a, 0x254067 },
	{ 0x24f7b, 0x265550 },
	{ 0x24f7c, 0x243e7e },
	{ 0x24f7d, 0x26554f },
	{ 0x24f7f, 0x254069 },
	{ 0x24f83, 0x2f436d },
	{ 0x24f88, 0x24452f },
	{ 0x24f89, 0x265f39 },
	{ 0x24f8a, 0x265f3a },
	{ 0x24f8b, 0x2f4a30 },
	{ 0x24f8c, 0x2f4a31 },
	{ 0x24f8d, 0x2f4a33 },
	{ 0x24f8e, 0x2f4a34 },
	{ 0x24f8f, 0x2f4a32 },
	{ 0x24f95, 0x244b3c },
	{ 0x24f98, 0x272560 },
	{ 0x24f99, 0x272561 },
	{ 0x24f9b, 0x255572 },
	{ 0x24f9c, 0x27303c },
	{ 0x24f9d, 0x255571 },
	{ 0x24f9e, 0x27303b },
	{ 0x24fa0, 0x245727 },
	{ 0x24fa1, 0x245728 },
	{ 0x24fa2, 0x255c42 },
	{ 0x24fa3, 0x255c44 },
	{ 0x24fa4, 0x27406e },
	{ 0x24fa5, 0x255c41 },
	{ 0x24fa6, 0x273952 },
	{ 0x24fa7, 0x256266 },
	{ 0x24fa8, 0x27406f },
	{ 0x24faa, 0x274070 },
	{ 0x24fab, 0x256845 },
	{ 0x24fac, 0x256846 },
	{ 0x24fad, 0x256847 },
	{ 0x24fb2, 0x256848 },
	{ 0x24fb3, 0x27482c },
	{ 0x24fb4, 0x274e50 },
	{ 0x24fb6, 0x274e4f },
	{ 0x24fb8, 0x256267 },
	{ 0x24fbb, 0x275840 },
	{ 0x24fbc, 0x275841 },
	{ 0x24fbd, 0x2f6779 },
	{ 0x24fbe, 0x275c23 },
	{ 0x24fc0, 0x246b73 },
	{ 0x24fc3, 0x275f21 },
	{ 0x24fc5, 0x27653a },
	{ 0x24fc6, 0x252467 },
	{ 0x24fc7, 0x252468 },
	{ 0x24fc8, 0x262d39 },
	{ 0x24fc9, 0x262d37 },
	{ 0x24fca, 0x262d38 },
	{ 0x24fcb, 0x25273d },
	{ 0x24fce, 0x26332b },
	{ 0x24fcf, 0x252a5b },
	{ 0x24fd0, 0x242a4f },
	{ 0x24fd1, 0x263036 },
	{ 0x24fd2, 0x26332a },
	{ 0x24fd5, 0x252e77 },
	{ 0x24fd6, 0x252e78 },
	{ 0x24fd7, 0x263976 },
	{ 0x24fd8, 0x26397a },
	{ 0x24fd9, 0x25336f },
	{ 0x24fda, 0x242e44 },
	{ 0x24fdb, 0x263977 },
	{ 0x24fdc, 0x263978 },
	{ 0x24fdd, 0x263979 },
	{ 0x24fdf, 0x243349 },
	{ 0x24fe0, 0x253370 },
	{ 0x24fe1, 0x26423e },
	{ 0x24fe2, 0x2f3679 },
	{ 0x24fe5, 0x26423d },
	{ 0x24fe7, 0x24393c },
	{ 0x24fe8, 0x264b6d },
	{ 0x24fe9, 0x253a42 },
	{ 0x24fea, 0x264b6f },
	{ 0x24feb, 0x24393b },
	{ 0x24fec, 0x2f3d4b },
	{ 0x24fee, 0x264b6e },
	{ 0x24ff2, 0x2f3678 },
	{ 0x24ff3, 0x25406a },
	{ 0x24ff4, 0x25406d },
	{ 0x24ff5, 0x25406b },
	{ 0x24ff6, 0x25406c },
	{ 0x24ff7, 0x25406e },
	{ 0x24ff9, 0x265553 },
	{ 0x24ffa, 0x2f436e },
	{ 0x24fff, 0x265551 },
	{ 0x25001, 0x243f21 },
	{ 0x25002, 0x244531 },
	{ 0x25003, 0x244533 },
	{ 0x25004, 0x265f3e },
	{ 0x25006, 0x2f4a35 },
	{ 0x25007, 0x265f3d },
	{ 0x25008, 0x25475c },
	{ 0x25009, 0x265f3f },
	{ 0x2500a, 0x265f3b },
	{ 0x2500b, 0x265f3c },
	{ 0x2500d, 0x272563 },
	{ 0x2500e, 0x254e5a },
	{ 0x2500f, 0x254e5b },
	{ 0x25010, 0x254e5c },
	{ 0x25011, 0x272562 },
	{ 0x25014, 0x255576 },
	{ 0x25015, 0x255578 },
	{ 0x25016, 0x255574 },
	{ 0x25017, 0x245158 },
	{ 0x25018, 0x255577 },
	{ 0x25019, 0x255575 },
	{ 0x2501a, 0x2f5636 },
	{ 0x2501b, 0x255573 },
	{ 0x2501c, 0x27303d },
	{ 0x2501e, 0x27303e },
	{ 0x2501f, 0x273953 },
	{ 0x25021, 0x27303f },
	{ 0x25022, 0x245729 },
	{ 0x25023, 0x256268 },
	{ 0x25024, 0x274072 },
	{ 0x25025, 0x274073 },
	{ 0x25026, 0x274074 },
	{ 0x25028, 0x274071 },
	{ 0x2502b, 0x25684a },
	{ 0x2502c, 0x256849 },
	{ 0x2502d, 0x27482d },
	{ 0x2502f, 0x24636d },
	{ 0x25030, 0x256c5b },
	{ 0x25031, 0x256c5a },
	{ 0x25032, 0x274e51 },
	{ 0x25034, 0x27537c },
	{ 0x25035, 0x24665c },
	{ 0x25036, 0x275842 },
	{ 0x25039, 0x25776c },
	{ 0x2503a, 0x25776d },
	{ 0x2503c, 0x276344 },
	{ 0x2503d, 0x276558 },
	{ 0x2503f, 0x262869 },
	{ 0x25040, 0x2f247d },
	{ 0x25041, 0x242749 },
	{ 0x25042, 0x25273e },
	{ 0x25043, 0x242747 },
	{ 0x25044, 0x262d3b },
	{ 0x25045, 0x25273f },
	{ 0x25046, 0x252a5e },
	{ 0x25047, 0x252a5c },
	{ 0x25048, 0x252a5d },
	{ 0x25049, 0x26332d },
	{ 0x2504b, 0x26332c },
	{ 0x2504c, 0x2f2c55 },
	{ 0x2504e, 0x252e79 },
	{ 0x2504f, 0x263a21 },
	{ 0x25050, 0x263a23 },
	{ 0x25051, 0x242e48 },
	{ 0x25052, 0x252e7a },
	{ 0x25053, 0x26397e },
	{ 0x25054, 0x26397b },
	{ 0x25055, 0x242e4a },
	{ 0x25056, 0x263a22 },
	{ 0x25058, 0x2f3137 },
	{ 0x25059, 0x2f3138 },
	{ 0x2505a, 0x263a24 },
	{ 0x2505b, 0x26397c },
	{ 0x2505c, 0x26397d },
	{ 0x2505e, 0x24334c },
	{ 0x2505f, 0x253372 },
	{ 0x25060, 0x24334a },
	{ 0x25061, 0x26423f },
	{ 0x25063, 0x2f367a },
	{ 0x25064, 0x2f367b },
	{ 0x25065, 0x2f367c },
	{ 0x25066, 0x2f367d },
	{ 0x25067, 0x2f3721 },
	{ 0x25068, 0x2f3722 },
	{ 0x25069, 0x264240 },
	{ 0x2506a, 0x264241 },
	{ 0x2506b, 0x263a25 },
	{ 0x2506c, 0x264b74 },
	{ 0x2506d, 0x264b70 },
	{ 0x2506e, 0x253a43 },
	{ 0x2506f, 0x24393d },
	{ 0x25070, 0x264b72 },
	{ 0x25071, 0x264b73 },
	{ 0x25073, 0x2f3d4c },
	{ 0x25074, 0x2f3d4d },
	{ 0x25076, 0x264b71 },
	{ 0x25077, 0x265554 },
	{ 0x25078, 0x265556 },
	{ 0x25079, 0x254070 },
	{ 0x2507a, 0x265558 },
	{ 0x2507b, 0x265557 },
	{ 0x2507c, 0x265555 },
	{ 0x2507f, 0x2f436f },
	{ 0x25080, 0x2f4370 },
	{ 0x25083, 0x265f41 },
	{ 0x25084, 0x265f40 },
	{ 0x25085, 0x265f4b },
	{ 0x25086, 0x2f4a36 },
	{ 0x25087, 0x254e5d },
	{ 0x25088, 0x272564 },
	{ 0x2508a, 0x272565 },
	{ 0x2508c, 0x2f5055 },
	{ 0x2508d, 0x2f5056 },
	{ 0x2508e, 0x2f5057 },
	{ 0x2508f, 0x2f5058 },
	{ 0x25090, 0x2f5059 },
	{ 0x25091, 0x2f505a },
	{ 0x25093, 0x245159 },
	{ 0x25094, 0x273044 },
	{ 0x25095, 0x24515b },
	{ 0x25096, 0x273040 },
	{ 0x25097, 0x273045 },
	{ 0x25098, 0x25557a },
	{ 0x25099, 0x255579 },
	{ 0x2509a, 0x2f5637 },
	{ 0x2509b, 0x2f5638 },
	{ 0x2509c, 0x2f5639 },
	{ 0x2509e, 0x2f563a },
	{ 0x2509f, 0x2f563b },
	{ 0x250a0, 0x273043 },
	{ 0x250a1, 0x273041 },
	{ 0x250a4, 0x24572b },
	{ 0x250a5, 0x245c23 },
	{ 0x250a6, 0x24572a },
	{ 0x250a7, 0x273954 },
	{ 0x250a8, 0x255c47 },
	{ 0x250a9, 0x274075 },
	{ 0x250ac, 0x255c46 },
	{ 0x250ad, 0x2f5b3b },
	{ 0x250ae, 0x2f5b3c },
	{ 0x250b1, 0x273955 },
	{ 0x250b2, 0x273956 },
	{ 0x250b3, 0x273679 },
	{ 0x250b5, 0x255c45 },
	{ 0x250b6, 0x273042 },
	{ 0x250b7, 0x273957 },
	{ 0x250b8, 0x245c22 },
	{ 0x250b9, 0x245c21 },
	{ 0x250ba, 0x274076 },
	{ 0x250bc, 0x274078 },
	{ 0x250be, 0x274077 },
	{ 0x250bf, 0x2f5f62 },
	{ 0x250c0, 0x274079 },
	{ 0x250c1, 0x27482e },
	{ 0x250c2, 0x25684b },
	{ 0x250c3, 0x27482f },
	{ 0x250c4, 0x2f6328 },
	{ 0x250c5, 0x2f6329 },
	{ 0x250c7, 0x256c5d },
	{ 0x250c8, 0x274e53 },
	{ 0x250c9, 0x256c5c },
	{ 0x250ca, 0x274e55 },
	{ 0x250cb, 0x2f6556 },
	{ 0x250cd, 0x274e52 },
	{ 0x250ce, 0x274e54 },
	{ 0x250d2, 0x2f677b },
	{ 0x250d3, 0x275844 },
	{ 0x250d4, 0x257360 },
	{ 0x250d5, 0x275843 },
	{ 0x250d6, 0x275845 },
	{ 0x250d7, 0x2f677a },
	{ 0x250d8, 0x275f22 },
	{ 0x250d9, 0x25762a },
	{ 0x250dc, 0x275f23 },
	{ 0x250e1, 0x276242 },
	{ 0x250e4, 0x25227d },
	{ 0x250e5, 0x2f2267 },
	{ 0x250e6, 0x26286a },
	{ 0x250e7, 0x242464 },
	{ 0x250e8, 0x25246a },
	{ 0x250e9, 0x242466 },
	{ 0x250ea, 0x25246b },
	{ 0x250eb, 0x252469 },
	{ 0x250ec, 0x2f247e },
	{ 0x250f2, 0x242750 },
	{ 0x250f3, 0x262d3c },
	{ 0x250f4, 0x252741 },
	{ 0x250f5, 0x24274b },
	{ 0x250f6, 0x262d40 },
	{ 0x250f7, 0x262d42 },
	{ 0x250f8, 0x262d3e },
	{ 0x250f9, 0x252742 },
	{ 0x250fa, 0x252743 },
	{ 0x250fb, 0x262d41 },
	{ 0x250fc, 0x262d3f },
	{ 0x250fd, 0x252740 },
	{ 0x25100, 0x262d43 },
	{ 0x25102, 0x262d44 },
	{ 0x25103, 0x263339 },
	{ 0x25104, 0x263335 },
	{ 0x25105, 0x26332e },
	{ 0x25106, 0x263332 },
	{ 0x25107, 0x242a5e },
	{ 0x25108, 0x263336 },
	{ 0x25109, 0x242a5c },
	{ 0x2510a, 0x26333c },
	{ 0x2510b, 0x252a65 },
	{ 0x2510c, 0x263333 },
	{ 0x2510d, 0x252a69 },
	{ 0x2510e, 0x242a5b },
	{ 0x2510f, 0x26332f },
	{ 0x25110, 0x26333b },
	{ 0x25111, 0x252a60 },
	{ 0x25112, 0x252a67 },
	{ 0x25113, 0x252a6b },
	{ 0x25114, 0x252a61 },
	{ 0x25115, 0x252a6a },
	{ 0x25116, 0x252a68 },
	{ 0x25117, 0x252a63 },
	{ 0x25118, 0x252a6c },
	{ 0x25119, 0x263330 },
	{ 0x2511b, 0x252a5f },
	{ 0x2511c, 0x252a66 },
	{ 0x2511d, 0x252a62 },
	{ 0x2511e, 0x252a64 },
	{ 0x25123, 0x2f2c56 },
	{ 0x25124, 0x2f2c58 },
	{ 0x25125, 0x263337 },
	{ 0x25127, 0x26333a },
	{ 0x25129, 0x263334 },
	{ 0x25131, 0x242e50 },
	{ 0x25132, 0x252f24 },
	{ 0x25133, 0x232e5a },
	{ 0x25134, 0x242e4c },
	{ 0x25135, 0x252e7b },
	{ 0x25136, 0x263a26 },
	{ 0x25137, 0x242e4e },
	{ 0x25138, 0x252f22 },
	{ 0x25139, 0x252e7c },
	{ 0x2513a, 0x263a28 },
	{ 0x2513b, 0x242e4b },
	{ 0x2513c, 0x263a29 },
	{ 0x2513d, 0x252f23 },
	{ 0x2513e, 0x263a2a },
	{ 0x2513f, 0x242e53 },
	{ 0x25140, 0x263a2c },
	{ 0x25141, 0x252e7e },
	{ 0x25144, 0x252f25 },
	{ 0x25149, 0x263a2b },
	{ 0x2514a, 0x2f3139 },
	{ 0x2514b, 0x2f313a },
	{ 0x2514c, 0x2f313b },
	{ 0x2514d, 0x2f313c },
	{ 0x2514e, 0x2f313d },
	{ 0x25153, 0x263a27 },
	{ 0x25157, 0x252f21 },
	{ 0x25158, 0x252e7d },
	{ 0x25159, 0x242e54 },
	{ 0x2515a, 0x243355 },
	{ 0x2515b, 0x264253 },
	{ 0x2515c, 0x264246 },
	{ 0x2515d, 0x26424d },
	{ 0x2515e, 0x253374 },
	{ 0x2515f, 0x253373 },
	{ 0x25160, 0x25337d },
	{ 0x25161, 0x243354 },
	{ 0x25162, 0x264247 },
	{ 0x25163, 0x264244 },
	{ 0x25165, 0x264242 },
	{ 0x25166, 0x25337a },
	{ 0x25167, 0x25337b },
	{ 0x25168, 0x253375 },
	{ 0x25169, 0x26424a },
	{ 0x2516a, 0x253378 },
	{ 0x2516b, 0x264254 },
	{ 0x2516c, 0x253379 },
	{ 0x2516d, 0x264243 },
	{ 0x2516e, 0x26424f },
	{ 0x25170, 0x26424b },
	{ 0x25171, 0x264250 },
	{ 0x25172, 0x2f3725 },
	{ 0x25173, 0x264252 },
	{ 0x25176, 0x26424c },
	{ 0x25179, 0x264249 },
	{ 0x2517c, 0x264251 },
	{ 0x2517d, 0x2f3726 },
	{ 0x25185, 0x25337e },
	{ 0x25186, 0x264245 },
	{ 0x25187, 0x26424e },
	{ 0x25188, 0x253377 },
	{ 0x25189, 0x25337c },
	{ 0x2518b, 0x253a49 },
	{ 0x2518c, 0x253a4c },
	{ 0x2518d, 0x264b79 },
	{ 0x2518e, 0x264c23 },
	{ 0x2518f, 0x243353 },
	{ 0x25190, 0x264b78 },
	{ 0x25191, 0x253a4b },
	{ 0x25192, 0x264b7d },
	{ 0x25193, 0x264c21 },
	{ 0x25194, 0x253a46 },
	{ 0x25195, 0x264c26 },
	{ 0x25196, 0x264b77 },
	{ 0x25197, 0x24394f },
	{ 0x25198, 0x253a4a },
	{ 0x25199, 0x253a48 },
	{ 0x2519a, 0x253a44 },
	{ 0x2519b, 0x24394e },
	{ 0x2519c, 0x254071 },
	{ 0x2519d, 0x264c25 },
	{ 0x2519e, 0x25407e },
	{ 0x2519f, 0x243940 },
	{ 0x251a0, 0x264b7e },
	{ 0x251a1, 0x253a4d },
	{ 0x251a2, 0x264b7b },
	{ 0x251a3, 0x253a4e },
	{ 0x251a4, 0x264c28 },
	{ 0x251a5, 0x253a45 },
	{ 0x251a6, 0x253a47 },
	{ 0x251aa, 0x2f3d4f },
	{ 0x251ab, 0x2f3d50 },
	{ 0x251ac, 0x2f3d51 },
	{ 0x251b0, 0x264b7c },
	{ 0x251b3, 0x264c27 },
	{ 0x251b5, 0x264b76 },
	{ 0x251b6, 0x264c24 },
	{ 0x251c3, 0x264c22 },
	{ 0x251c4, 0x243944 },
	{ 0x251c5, 0x243950 },
	{ 0x251c6, 0x253a4f },
	{ 0x251c7, 0x24393e },
	{ 0x251c9, 0x26555b },
	{ 0x251ca, 0x26555e },
	{ 0x251cb, 0x26555a },
	{ 0x251cc, 0x243f2a },
	{ 0x251cd, 0x254078 },
	{ 0x251ce, 0x26555c },
	{ 0x251cf, 0x254077 },
	{ 0x251d0, 0x26555f },
	{ 0x251d1, 0x254075 },
	{ 0x251d2, 0x265559 },
	{ 0x251d3, 0x243f23 },
	{ 0x251d4, 0x243f28 },
	{ 0x251d5, 0x243f31 },
	{ 0x251d6, 0x243f2e },
	{ 0x251d8, 0x25407a },
	{ 0x251d9, 0x265562 },
	{ 0x251da, 0x254076 },
	{ 0x251db, 0x243f2f },
	{ 0x251dc, 0x243f24 },
	{ 0x251dd, 0x265564 },
	{ 0x251de, 0x254079 },
	{ 0x251df, 0x254072 },
	{ 0x251e0, 0x25407c },
	{ 0x251e1, 0x265566 },
	{ 0x251e4, 0x26555d },
	{ 0x251e8, 0x2f4371 },
	{ 0x251e9, 0x2f4372 },
	{ 0x251ea, 0x2f4373 },
	{ 0x251eb, 0x264b75 },
	{ 0x251ee, 0x265563 },
	{ 0x251f4, 0x265335 },
	{ 0x251f5, 0x254073 },
	{ 0x251fe, 0x25407d },
	{ 0x251ff, 0x254074 },
	{ 0x25200, 0x265565 },
	{ 0x25202, 0x254760 },
	{ 0x25203, 0x244545 },
	{ 0x25205, 0x265f44 },
	{ 0x25206, 0x24453e },
	{ 0x25207, 0x254763 },
	{ 0x25208, 0x265f48 },
	{ 0x25209, 0x254765 },
	{ 0x2520a, 0x254766 },
	{ 0x2520b, 0x265f49 },
	{ 0x2520c, 0x244b4f },
	{ 0x2520d, 0x265f4e },
	{ 0x2520e, 0x265f46 },
	{ 0x2520f, 0x265f4f },
	{ 0x25210, 0x27256c },
	{ 0x25211, 0x265f47 },
	{ 0x25212, 0x254767 },
	{ 0x25213, 0x254764 },
	{ 0x25214, 0x265f43 },
	{ 0x25215, 0x265f4a },
	{ 0x25216, 0x265f45 },
	{ 0x25217, 0x254762 },
	{ 0x25218, 0x265f42 },
	{ 0x25219, 0x25475f },
	{ 0x2521a, 0x25475e },
	{ 0x2521b, 0x25475d },
	{ 0x2521c, 0x272566 },
	{ 0x25222, 0x2f4a37 },
	{ 0x25223, 0x2f4a38 },
	{ 0x25224, 0x2f4a39 },
	{ 0x25225, 0x2f4a3a },
	{ 0x25226, 0x2f4a3b },
	{ 0x25227, 0x2f4a3c },
	{ 0x25228, 0x2f4a3d },
	{ 0x25229, 0x24453a },
	{ 0x2522a, 0x265f4d },
	{ 0x25237, 0x265f4c },
	{ 0x25238, 0x254769 },
	{ 0x2523b, 0x24453b },
	{ 0x2523c, 0x244b50 },
	{ 0x2523d, 0x244b4c },
	{ 0x2523e, 0x244b3e },
	{ 0x2523f, 0x254e62 },
	{ 0x25240, 0x254e67 },
	{ 0x25241, 0x244b4e },
	{ 0x25242, 0x27256b },
	{ 0x25243, 0x254e6c },
	{ 0x25244, 0x254e65 },
	{ 0x25245, 0x244b41 },
	{ 0x25246, 0x272570 },
	{ 0x25247, 0x244b40 },
	{ 0x25248, 0x245165 },
	{ 0x25249, 0x27304d },
	{ 0x2524a, 0x254e64 },
	{ 0x2524b, 0x255621 },
	{ 0x2524c, 0x254e66 },
	{ 0x2524d, 0x27256d },
	{ 0x2524e, 0x254e6a },
	{ 0x2524f, 0x272572 },
	{ 0x25250, 0x244b49 },
	{ 0x25251, 0x244b4b },
	{ 0x25252, 0x244b46 },
	{ 0x25253, 0x254e5f },
	{ 0x25254, 0x254e6b },
	{ 0x25255, 0x272567 },
	{ 0x25256, 0x272568 },
	{ 0x25257, 0x27256a },
	{ 0x25258, 0x244b4a },
	{ 0x25259, 0x254e63 },
	{ 0x2525a, 0x27256e },
	{ 0x2525b, 0x254e5e },
	{ 0x2525c, 0x254e61 },
	{ 0x2525d, 0x25557b },
	{ 0x2525e, 0x254e69 },
	{ 0x2525f, 0x254e68 },
	{ 0x25262, 0x272569 },
	{ 0x25263, 0x2f505b },
	{ 0x25264, 0x2f505c },
	{ 0x25265, 0x2f505d },
	{ 0x25266, 0x27256f },
	{ 0x25270, 0x244b48 },
	{ 0x25274, 0x25562a },
	{ 0x25275, 0x25562b },
	{ 0x25276, 0x24515e },
	{ 0x25277, 0x255625 },
	{ 0x25278, 0x255623 },
	{ 0x25279, 0x255627 },
	{ 0x2527a, 0x25557d },
	{ 0x2527b, 0x245163 },
	{ 0x2527c, 0x255629 },
	{ 0x2527d, 0x25557e },
	{ 0x2527e, 0x255626 },
	{ 0x2527f, 0x255624 },
	{ 0x25280, 0x245162 },
	{ 0x25281, 0x273046 },
	{ 0x25282, 0x27304e },
	{ 0x25284, 0x27304f },
	{ 0x25285, 0x27304b },
	{ 0x25286, 0x273047 },
	{ 0x25287, 0x254e6d },
	{ 0x25288, 0x245167 },
	{ 0x25289, 0x25557c },
	{ 0x2528a, 0x273049 },
	{ 0x2528e, 0x2f563d },
	{ 0x25290, 0x273051 },
	{ 0x25295, 0x27304c },
	{ 0x252a7, 0x25562c },
	{ 0x252a8, 0x245166 },
	{ 0x252aa, 0x254768 },
	{ 0x252ab, 0x255628 },
	{ 0x252ac, 0x245c2b },
	{ 0x252ad, 0x255c48 },
	{ 0x252ae, 0x255c4b },
	{ 0x252af, 0x245735 },
	{ 0x252b0, 0x245736 },
	{ 0x252b1, 0x273052 },
	{ 0x252b2, 0x27395e },
	{ 0x252b3, 0x273959 },
	{ 0x252b4, 0x255c4a },
	{ 0x252b5, 0x27395a },
	{ 0x252b6, 0x255c4c },
	{ 0x252b7, 0x273964 },
	{ 0x252b8, 0x255c49 },
	{ 0x252b9, 0x274122 },
	{ 0x252ba, 0x27395f },
	{ 0x252bb, 0x273960 },
	{ 0x252bc, 0x27395d },
	{ 0x252bd, 0x245737 },
	{ 0x252be, 0x273963 },
	{ 0x252bf, 0x255c4f },
	{ 0x252c0, 0x273048 },
	{ 0x252c1, 0x255c4e },
	{ 0x252c2, 0x273961 },
	{ 0x252c3, 0x27395c },
	{ 0x252c4, 0x27395b },
	{ 0x252c8, 0x2f5b3e },
	{ 0x252c9, 0x2f5b3f },
	{ 0x252ca, 0x2f5b40 },
	{ 0x252cd, 0x273962 },
	{ 0x252d0, 0x273958 },
	{ 0x252d9, 0x245c28 },
	{ 0x252da, 0x274123 },
	{ 0x252db, 0x27407e },
	{ 0x252dc, 0x25626e },
	{ 0x252dd, 0x245c2c },
	{ 0x252de, 0x25626b },
	{ 0x252df, 0x27407b },
	{ 0x252e0, 0x27407c },
	{ 0x252e1, 0x256270 },
	{ 0x252e2, 0x245c24 },
	{ 0x252e3, 0x25626c },
	{ 0x252e4, 0x25626f },
	{ 0x252e5, 0x256271 },
	{ 0x252e8, 0x25626a },
	{ 0x252e9, 0x2f5f63 },
	{ 0x252ea, 0x2f5f64 },
	{ 0x252eb, 0x274124 },
	{ 0x252ec, 0x274125 },
	{ 0x252ed, 0x27407d },
	{ 0x252ef, 0x25626d },
	{ 0x252f0, 0x27407a },
	{ 0x252fb, 0x274121 },
	{ 0x252ff, 0x25684f },
	{ 0x25300, 0x25684c },
	{ 0x25301, 0x256851 },
	{ 0x25302, 0x24603e },
	{ 0x25303, 0x256850 },
	{ 0x25304, 0x24603b },
	{ 0x25305, 0x256854 },
	{ 0x25306, 0x25684e },
	{ 0x25307, 0x274832 },
	{ 0x25308, 0x24603a },
	{ 0x25309, 0x274834 },
	{ 0x2530a, 0x24603c },
	{ 0x2530b, 0x24603d },
	{ 0x2530c, 0x274830 },
	{ 0x2530d, 0x25684d },
	{ 0x2530e, 0x274831 },
	{ 0x2530f, 0x256853 },
	{ 0x25310, 0x256852 },
	{ 0x25314, 0x2f632a },
	{ 0x25315, 0x274b5d },
	{ 0x25316, 0x274835 },
	{ 0x25317, 0x274833 },
	{ 0x2531a, 0x256c60 },
	{ 0x2531b, 0x256c62 },
	{ 0x2531c, 0x256c5e },
	{ 0x2531d, 0x274e58 },
	{ 0x2531e, 0x256c61 },
	{ 0x2531f, 0x256c63 },
	{ 0x25321, 0x274e57 },
	{ 0x25322, 0x2f6557 },
	{ 0x25323, 0x246372 },
	{ 0x25328, 0x256c5f },
	{ 0x25329, 0x246373 },
	{ 0x2532a, 0x274e56 },
	{ 0x2532d, 0x275422 },
	{ 0x2532e, 0x257052 },
	{ 0x2532f, 0x257054 },
	{ 0x25330, 0x257053 },
	{ 0x25331, 0x257055 },
	{ 0x25332, 0x27537e },
	{ 0x25335, 0x275423 },
	{ 0x25336, 0x27537d },
	{ 0x2533a, 0x246879 },
	{ 0x2533b, 0x257363 },
	{ 0x2533c, 0x275846 },
	{ 0x2533d, 0x257361 },
	{ 0x2533e, 0x257362 },
	{ 0x2533f, 0x275847 },
	{ 0x25340, 0x257365 },
	{ 0x25341, 0x246a59 },
	{ 0x25342, 0x275421 },
	{ 0x25343, 0x257364 },
	{ 0x25344, 0x275933 },
	{ 0x25346, 0x257366 },
	{ 0x25349, 0x25762b },
	{ 0x2534a, 0x275c26 },
	{ 0x2534b, 0x246a58 },
	{ 0x2534c, 0x275c25 },
	{ 0x2534f, 0x275f24 },
	{ 0x25353, 0x246c74 },
	{ 0x25354, 0x276243 },
	{ 0x25355, 0x276245 },
	{ 0x25357, 0x276244 },
	{ 0x25359, 0x2f6c66 },
	{ 0x2535a, 0x257b43 },
	{ 0x2535e, 0x252744 },
	{ 0x2535f, 0x242a60 },
	{ 0x25360, 0x242a61 },
	{ 0x25361, 0x242e56 },
	{ 0x25362, 0x252f28 },
	{ 0x25363, 0x252f27 },
	{ 0x25364, 0x263a2f },
	{ 0x25365, 0x263a30 },
	{ 0x25367, 0x243358 },
	{ 0x25368, 0x253422 },
	{ 0x25369, 0x2f3727 },
	{ 0x2536a, 0x253a52 },
	{ 0x2536b, 0x243951 },
	{ 0x2536c, 0x253a53 },
	{ 0x2536d, 0x253a51 },
	{ 0x2536e, 0x253a55 },
	{ 0x2536f, 0x253a50 },
	{ 0x25370, 0x264c29 },
	{ 0x25371, 0x253a54 },
	{ 0x25372, 0x254123 },
	{ 0x25373, 0x254122 },
	{ 0x25375, 0x254121 },
	{ 0x25376, 0x265f51 },
	{ 0x25377, 0x265f52 },
	{ 0x25378, 0x244547 },
	{ 0x25379, 0x244548 },
	{ 0x2537a, 0x25476c },
	{ 0x2537b, 0x25476a },
	{ 0x2537c, 0x25476b },
	{ 0x2537d, 0x244549 },
	{ 0x2537e, 0x265f50 },
	{ 0x2537f, 0x24454b },
	{ 0x25380, 0x2f4d3f },
	{ 0x25382, 0x254e6e },
	{ 0x25383, 0x244b52 },
	{ 0x25384, 0x272575 },
	{ 0x25385, 0x254e6f },
	{ 0x25386, 0x244b51 },
	{ 0x25387, 0x272574 },
	{ 0x25389, 0x244b53 },
	{ 0x2538a, 0x245169 },
	{ 0x2538b, 0x245168 },
	{ 0x2538c, 0x24516a },
	{ 0x2538d, 0x25562d },
	{ 0x2538e, 0x256275 },
	{ 0x2538f, 0x273965 },
	{ 0x25390, 0x255a75 },
	{ 0x25392, 0x255c50 },
	{ 0x25393, 0x256274 },
	{ 0x25394, 0x256273 },
	{ 0x25395, 0x256272 },
	{ 0x25396, 0x256857 },
	{ 0x25397, 0x256856 },
	{ 0x25398, 0x256855 },
	{ 0x25399, 0x256858 },
	{ 0x2539a, 0x274836 },
	{ 0x2539c, 0x274837 },
	{ 0x253a1, 0x246a5a },
	{ 0x253a4, 0x27663f },
	{ 0x253a5, 0x276649 },
	{ 0x253a6, 0x26263f },
	{ 0x253a7, 0x26286b },
	{ 0x253a8, 0x26286c },
	{ 0x253a9, 0x263341 },
	{ 0x253aa, 0x26333f },
	{ 0x253ab, 0x263340 },
	{ 0x253ac, 0x252a6e },
	{ 0x253b0, 0x252f2a },
	{ 0x253b1, 0x252f2b },
	{ 0x253b2, 0x263a33 },
	{ 0x253b3, 0x2f313f },
	{ 0x253b4, 0x2f3140 },
	{ 0x253b5, 0x263a31 },
	{ 0x253b6, 0x263a32 },
	{ 0x253b8, 0x252f29 },
	{ 0x253b9, 0x253423 },
	{ 0x253ba, 0x253424 },
	{ 0x253bb, 0x24335c },
	{ 0x253bc, 0x264259 },
	{ 0x253bd, 0x264257 },
	{ 0x253be, 0x253425 },
	{ 0x253bf, 0x264255 },
	{ 0x253c0, 0x26425b },
	{ 0x253c1, 0x264256 },
	{ 0x253c2, 0x26425a },
	{ 0x253c9, 0x264258 },
	{ 0x253ce, 0x243952 },
	{ 0x253cf, 0x264c2c },
	{ 0x253d1, 0x2f3d52 },
	{ 0x253d4, 0x264c2a },
	{ 0x253d7, 0x2f3d53 },
	{ 0x253d8, 0x254124 },
	{ 0x253d9, 0x243f32 },
	{ 0x253da, 0x265569 },
	{ 0x253dc, 0x243f35 },
	{ 0x253dd, 0x243f34 },
	{ 0x253de, 0x265567 },
	{ 0x253df, 0x253a56 },
	{ 0x253e0, 0x243f36 },
	{ 0x253e1, 0x2f4375 },
	{ 0x253e2, 0x265568 },
	{ 0x253ea, 0x25476d },
	{ 0x253eb, 0x25476e },
	{ 0x253ec, 0x265f53 },
	{ 0x253ef, 0x25476f },
	{ 0x253f0, 0x254770 },
	{ 0x253f1, 0x2f4a3e },
	{ 0x253f2, 0x272578 },
	{ 0x253f3, 0x244b54 },
	{ 0x253f4, 0x272576 },
	{ 0x253f5, 0x272577 },
	{ 0x253f6, 0x2f5061 },
	{ 0x253f7, 0x272579 },
	{ 0x253fb, 0x273054 },
	{ 0x253fc, 0x24516b },
	{ 0x253fd, 0x2f563f },
	{ 0x253fe, 0x273053 },
	{ 0x25400, 0x255c51 },
	{ 0x25401, 0x255c52 },
	{ 0x25403, 0x273966 },
	{ 0x25404, 0x273967 },
	{ 0x25411, 0x257367 },
	{ 0x25413, 0x25762c },
	{ 0x25415, 0x25227e },
	{ 0x25416, 0x26253e },
	{ 0x25417, 0x242467 },
	{ 0x25418, 0x26286d },
	{ 0x25419, 0x25246d },
	{ 0x2541a, 0x25246c },
	{ 0x2541b, 0x2f2521 },
	{ 0x2541c, 0x2f2522 },
	{ 0x2541d, 0x252745 },
	{ 0x2541e, 0x242754 },
	{ 0x25420, 0x2f2830 },
	{ 0x25421, 0x2f2831 },
	{ 0x25422, 0x2f2832 },
	{ 0x25423, 0x2f2833 },
	{ 0x25424, 0x262d47 },
	{ 0x25425, 0x2f2835 },
	{ 0x25429, 0x242a65 },
	{ 0x2542a, 0x242a63 },
	{ 0x2542b, 0x263345 },
	{ 0x2542c, 0x252a70 },
	{ 0x25431, 0x2f2c59 },
	{ 0x25432, 0x2f2c5a },
	{ 0x25433, 0x2f2c5b },
	{ 0x25434, 0x2f2c5d },
	{ 0x25435, 0x2f2c5e },
	{ 0x25436, 0x2f2c5f },
	{ 0x25437, 0x2f2c61 },
	{ 0x25438, 0x2f2c63 },
	{ 0x2543a, 0x263343 },
	{ 0x2543c, 0x263344 },
	{ 0x2543d, 0x2f2c64 },
	{ 0x25440, 0x2f2c60 },
	{ 0x25441, 0x263342 },
	{ 0x25444, 0x252a6f },
	{ 0x25445, 0x252a71 },
	{ 0x25446, 0x242e60 },
	{ 0x25447, 0x252f33 },
	{ 0x25448, 0x263a34 },
	{ 0x25449, 0x263346 },
	{ 0x2544a, 0x263a35 },
	{ 0x2544b, 0x252f2f },
	{ 0x2544c, 0x263a39 },
	{ 0x2544d, 0x252f2c },
	{ 0x2544e, 0x252f31 },
	{ 0x2544f, 0x252f30 },
	{ 0x25450, 0x242e5b },
	{ 0x25451, 0x242e5d },
	{ 0x25452, 0x252f36 },
	{ 0x25453, 0x252f32 },
	{ 0x25454, 0x252f35 },
	{ 0x25457, 0x2f313e },
	{ 0x25458, 0x242e59 },
	{ 0x25459, 0x252f37 },
	{ 0x2545a, 0x263a38 },
	{ 0x2545b, 0x2f3142 },
	{ 0x2545c, 0x2f3143 },
	{ 0x2545d, 0x2f3145 },
	{ 0x2545e, 0x2f3146 },
	{ 0x25462, 0x242e5a },
	{ 0x25463, 0x252f2d },
	{ 0x25469, 0x263a37 },
	{ 0x2546c, 0x2f3148 },
	{ 0x2546e, 0x2f3141 },
	{ 0x2546f, 0x253426 },
	{ 0x25470, 0x252f2e },
	{ 0x25472, 0x263a36 },
	{ 0x25473, 0x25342c },
	{ 0x25474, 0x253428 },
	{ 0x25475, 0x264261 },
	{ 0x25476, 0x26425f },
	{ 0x25478, 0x253431 },
	{ 0x25479, 0x253430 },
	{ 0x2547a, 0x25342a },
	{ 0x2547b, 0x264260 },
	{ 0x2547c, 0x253434 },
	{ 0x2547d, 0x253432 },
	{ 0x2547e, 0x252f38 },
	{ 0x2547f, 0x25342e },
	{ 0x25480, 0x253427 },
	{ 0x25481, 0x253429 },
	{ 0x25482, 0x25342d },
	{ 0x25484, 0x2f3728 },
	{ 0x25486, 0x2f3729 },
	{ 0x25487, 0x2f372a },
	{ 0x25488, 0x2f372b },
	{ 0x25489, 0x2f372e },
	{ 0x2548a, 0x2f372f },
	{ 0x2548b, 0x2f3731 },
	{ 0x2548c, 0x2f3732 },
	{ 0x2548d, 0x2f3733 },
	{ 0x2548f, 0x26425e },
	{ 0x25492, 0x26425c },
	{ 0x25494, 0x264c2e },
	{ 0x25496, 0x2f3730 },
	{ 0x2549c, 0x25342b },
	{ 0x2549e, 0x2f372c },
	{ 0x254a4, 0x264262 },
	{ 0x254a7, 0x25342f },
	{ 0x254a8, 0x253433 },
	{ 0x254a9, 0x26425d },
	{ 0x254aa, 0x253a58 },
	{ 0x254ab, 0x253a5e },
	{ 0x254ac, 0x253a57 },
	{ 0x254ad, 0x253a5b },
	{ 0x254ae, 0x243956 },
	{ 0x254af, 0x264c35 },
	{ 0x254b0, 0x243957 },
	{ 0x254b1, 0x243955 },
	{ 0x254b2, 0x253a5c },
	{ 0x254b3, 0x253a5d },
	{ 0x254b4, 0x264c31 },
	{ 0x254b5, 0x253a5a },
	{ 0x254b6, 0x253a5f },
	{ 0x254b9, 0x2f3d54 },
	{ 0x254ba, 0x2f3d55 },
	{ 0x254bb, 0x2f3d56 },
	{ 0x254bc, 0x2f3d57 },
	{ 0x254bd, 0x264c34 },
	{ 0x254c0, 0x264c30 },
	{ 0x254c1, 0x264c32 },
	{ 0x254c6, 0x253a61 },
	{ 0x254c7, 0x253a60 },
	{ 0x254ca, 0x254128 },
	{ 0x254cb, 0x265571 },
	{ 0x254cc, 0x243f37 },
	{ 0x254cd, 0x254129 },
	{ 0x254ce, 0x26556a },
	{ 0x254cf, 0x26556c },
	{ 0x254d0, 0x254125 },
	{ 0x254d1, 0x26556e },
	{ 0x254d2, 0x243f41 },
	{ 0x254d3, 0x243f43 },
	{ 0x254d4, 0x26556f },
	{ 0x254d5, 0x265572 },
	{ 0x254d6, 0x254126 },
	{ 0x254d7, 0x254127 },
	{ 0x254da, 0x26556d },
	{ 0x254db, 0x2f4377 },
	{ 0x254dc, 0x2f4378 },
	{ 0x254dd, 0x2f4379 },
	{ 0x254de, 0x2f437a },
	{ 0x254df, 0x2f437b },
	{ 0x254e0, 0x2f437c },
	{ 0x254e1, 0x2f437d },
	{ 0x254e2, 0x2f437e },
	{ 0x254e3, 0x2f4421 },
	{ 0x254e4, 0x2f4422 },
	{ 0x254e5, 0x2f4423 },
	{ 0x254e6, 0x2f4424 },
	{ 0x254e7, 0x2f4426 },
	{ 0x254ed, 0x265570 },
	{ 0x254f1, 0x265573 },
	{ 0x254fa, 0x265f5b },
	{ 0x254fb, 0x254778 },
	{ 0x254fc, 0x265f54 },
	{ 0x254fd, 0x27257e },
	{ 0x254fe, 0x25477a },
	{ 0x254ff, 0x265f56 },
	{ 0x25500, 0x244552 },
	{ 0x25501, 0x254773 },
	{ 0x25502, 0x254772 },
	{ 0x25503, 0x265f57 },
	{ 0x25504, 0x25477b },
	{ 0x25505, 0x265f59 },
	{ 0x25506, 0x265f5a },
	{ 0x25507, 0x254775 },
	{ 0x25508, 0x265f55 },
	{ 0x25509, 0x254771 },
	{ 0x2550a, 0x25477d },
	{ 0x25510, 0x265f58 },
	{ 0x25512, 0x2f4a41 },
	{ 0x25513, 0x2f4a43 },
	{ 0x25514, 0x2f4a44 },
	{ 0x25515, 0x2f4a45 },
	{ 0x25516, 0x2f4a46 },
	{ 0x25517, 0x2f4a47 },
	{ 0x25518, 0x2f4a48 },
	{ 0x25519, 0x2f4a49 },
	{ 0x2551a, 0x2f4a4b },
	{ 0x2551b, 0x2f4a4c },
	{ 0x2551c, 0x2f4a4d },
	{ 0x2551d, 0x2f4a4f },
	{ 0x2551e, 0x2f4a50 },
	{ 0x2551f, 0x2f4a51 },
	{ 0x25520, 0x2f4a52 },
	{ 0x25522, 0x244554 },
	{ 0x25523, 0x2f4a40 },
	{ 0x25528, 0x254777 },
	{ 0x25529, 0x25477c },
	{ 0x2552a, 0x254779 },
	{ 0x2552b, 0x254774 },
	{ 0x2552c, 0x2f5064 },
	{ 0x2552d, 0x244b5a },
	{ 0x2552e, 0x254e72 },
	{ 0x2552f, 0x254e73 },
	{ 0x25530, 0x272621 },
	{ 0x25531, 0x254e70 },
	{ 0x25532, 0x244550 },
	{ 0x25533, 0x272625 },
	{ 0x25534, 0x254e75 },
	{ 0x25535, 0x27257d },
	{ 0x25536, 0x2f5062 },
	{ 0x25537, 0x2f5063 },
	{ 0x25538, 0x2f5065 },
	{ 0x25539, 0x2f5066 },
	{ 0x2553a, 0x2f5068 },
	{ 0x25543, 0x272622 },
	{ 0x25545, 0x27257a },
	{ 0x25546, 0x272623 },
	{ 0x25547, 0x254e71 },
	{ 0x25548, 0x254e74 },
	{ 0x25549, 0x27257c },
	{ 0x2554b, 0x2f4a4a },
	{ 0x2554c, 0x273058 },
	{ 0x2554d, 0x255631 },
	{ 0x2554e, 0x25562e },
	{ 0x2554f, 0x255632 },
	{ 0x25550, 0x273055 },
	{ 0x25551, 0x245171 },
	{ 0x25553, 0x245173 },
	{ 0x25554, 0x255634 },
	{ 0x25555, 0x245172 },
	{ 0x25556, 0x273056 },
	{ 0x25557, 0x27305a },
	{ 0x25558, 0x24516f },
	{ 0x2555a, 0x273057 },
	{ 0x2555e, 0x2f5641 },
	{ 0x2555f, 0x2f5642 },
	{ 0x25560, 0x2f5643 },
	{ 0x25561, 0x255630 },
	{ 0x25565, 0x2f5644 },
	{ 0x25566, 0x25562f },
	{ 0x25567, 0x2f5645 },
	{ 0x25568, 0x2f5646 },
	{ 0x25569, 0x2f5647 },
	{ 0x2556a, 0x2f5649 },
	{ 0x2556b, 0x2f564b },
	{ 0x2556c, 0x2f564c },
	{ 0x2556d, 0x2f564d },
	{ 0x25570, 0x255c56 },
	{ 0x25571, 0x273968 },
	{ 0x25572, 0x255c54 },
	{ 0x25573, 0x27396f },
	{ 0x25574, 0x27396a },
	{ 0x25575, 0x255c53 },
	{ 0x25576, 0x24573a },
	{ 0x25577, 0x273969 },
	{ 0x25578, 0x255c55 },
	{ 0x25579, 0x24573d },
	{ 0x2557a, 0x27396c },
	{ 0x2557b, 0x24573c },
	{ 0x2557c, 0x255635 },
	{ 0x2557d, 0x255c58 },
	{ 0x2557e, 0x255c57 },
	{ 0x2557f, 0x255c59 },
	{ 0x25582, 0x2f5b41 },
	{ 0x25583, 0x2f5b42 },
	{ 0x25584, 0x2f5b43 },
	{ 0x25585, 0x2f5b44 },
	{ 0x25586, 0x2f5b45 },
	{ 0x25587, 0x2f5b46 },
	{ 0x25588, 0x2f5b47 },
	{ 0x25589, 0x2f5b48 },
	{ 0x2558a, 0x2f5b49 },
	{ 0x2558b, 0x27396b },
	{ 0x2558c, 0x27396e },
	{ 0x2558f, 0x2f564a },
	{ 0x25597, 0x274129 },
	{ 0x25598, 0x256276 },
	{ 0x25599, 0x256278 },
	{ 0x2559a, 0x274126 },
	{ 0x2559b, 0x274128 },
	{ 0x2559c, 0x256277 },
	{ 0x2559d, 0x245c30 },
	{ 0x2559e, 0x25627a },
	{ 0x2559f, 0x274127 },
	{ 0x255a0, 0x256279 },
	{ 0x255a1, 0x27412a },
	{ 0x255a2, 0x2f5f65 },
	{ 0x255a3, 0x2f5f66 },
	{ 0x255a4, 0x2f5f67 },
	{ 0x255a5, 0x2f5f68 },
	{ 0x255a6, 0x2f5f69 },
	{ 0x255aa, 0x246040 },
	{ 0x255ab, 0x25685a },
	{ 0x255ac, 0x256859 },
	{ 0x255ae, 0x2f632b },
	{ 0x255af, 0x2f632c },
	{ 0x255b0, 0x2f632d },
	{ 0x255b1, 0x2f632e },
	{ 0x255b3, 0x27483a },
	{ 0x255b4, 0x274838 },
	{ 0x255b7, 0x274839 },
	{ 0x255b9, 0x2f632f },
	{ 0x255bb, 0x256c65 },
	{ 0x255bc, 0x256c66 },
	{ 0x255bd, 0x274e59 },
	{ 0x255be, 0x274e5a },
	{ 0x255bf, 0x256c64 },
	{ 0x255c0, 0x256c67 },
	{ 0x255c1, 0x246041 },
	{ 0x255c2, 0x274e5b },
	{ 0x255c3, 0x2f655a },
	{ 0x255c4, 0x2f655b },
	{ 0x255c5, 0x2f655c },
	{ 0x255c6, 0x2f655d },
	{ 0x255c9, 0x274e5d },
	{ 0x255d2, 0x257056 },
	{ 0x255d3, 0x257057 },
	{ 0x255d6, 0x2f677d },
	{ 0x255d8, 0x275424 },
	{ 0x255d9, 0x246662 },
	{ 0x255db, 0x2f677c },
	{ 0x255dd, 0x257368 },
	{ 0x255de, 0x275848 },
	{ 0x255df, 0x257369 },
	{ 0x255e1, 0x2f695b },
	{ 0x255e2, 0x2f695c },
	{ 0x255e3, 0x275849 },
	{ 0x255ea, 0x25736a },
	{ 0x255eb, 0x25762e },
	{ 0x255ec, 0x246a5b },
	{ 0x255ed, 0x25762d },
	{ 0x255ee, 0x25762f },
	{ 0x255ef, 0x2f6a65 },
	{ 0x255f1, 0x275c28 },
	{ 0x255f2, 0x275c27 },
	{ 0x255f4, 0x275f26 },
	{ 0x255f7, 0x275f25 },
	{ 0x255f8, 0x275f27 },
	{ 0x255fa, 0x276246 },
	{ 0x255fb, 0x257a2d },
	{ 0x255fe, 0x257a6e },
	{ 0x255ff, 0x246d75 },
	{ 0x25601, 0x276453 },
	{ 0x25603, 0x27653b },
	{ 0x25604, 0x257c43 },
	{ 0x25605, 0x262227 },
	{ 0x25606, 0x262540 },
	{ 0x25608, 0x26286e },
	{ 0x25609, 0x2f2268 },
	{ 0x2560d, 0x262d48 },
	{ 0x2560e, 0x2f2524 },
	{ 0x25615, 0x263347 },
	{ 0x25616, 0x263349 },
	{ 0x25619, 0x2f2836 },
	{ 0x2561a, 0x2f2838 },
	{ 0x2561b, 0x2f2839 },
	{ 0x2561c, 0x2f283a },
	{ 0x2561d, 0x2f283b },
	{ 0x2561e, 0x2f283d },
	{ 0x25624, 0x2f2837 },
	{ 0x25626, 0x26315a },
	{ 0x2562b, 0x252f39 },
	{ 0x2562c, 0x263a3a },
	{ 0x2562d, 0x242e63 },
	{ 0x2562e, 0x252f3a },
	{ 0x25630, 0x263a3b },
	{ 0x25631, 0x26334b },
	{ 0x25638, 0x2f2c65 },
	{ 0x25639, 0x2f2c66 },
	{ 0x2563a, 0x2f2c67 },
	{ 0x2563b, 0x2f2c68 },
	{ 0x2563c, 0x2f2c69 },
	{ 0x2563d, 0x2f3149 },
	{ 0x2563e, 0x2f314b },
	{ 0x2563f, 0x2f314e },
	{ 0x25642, 0x263a3e },
	{ 0x25644, 0x263a3f },
	{ 0x25649, 0x263a3d },
	{ 0x2564a, 0x263a40 },
	{ 0x2564b, 0x263a3c },
	{ 0x2564c, 0x2f2c6a },
	{ 0x2564d, 0x242a68 },
	{ 0x2564e, 0x253436 },
	{ 0x2564f, 0x263a41 },
	{ 0x25654, 0x2f314a },
	{ 0x25655, 0x2f314c },
	{ 0x25656, 0x2f314d },
	{ 0x25657, 0x2f314f },
	{ 0x25658, 0x2f3150 },
	{ 0x25659, 0x2f3151 },
	{ 0x2565a, 0x2f3152 },
	{ 0x2565b, 0x2f3153 },
	{ 0x2565c, 0x2f3154 },
	{ 0x2565d, 0x2f3737 },
	{ 0x25664, 0x264263 },
	{ 0x25668, 0x253435 },
	{ 0x2566b, 0x264c38 },
	{ 0x2566c, 0x253a62 },
	{ 0x2566d, 0x264c39 },
	{ 0x2566e, 0x264c3a },
	{ 0x2566f, 0x264c3c },
	{ 0x25670, 0x253a63 },
	{ 0x25671, 0x264c3d },
	{ 0x25672, 0x264c3b },
	{ 0x25677, 0x264c36 },
	{ 0x25678, 0x264c37 },
	{ 0x25679, 0x2f3734 },
	{ 0x2567a, 0x2f3736 },
	{ 0x2567b, 0x2f3738 },
	{ 0x2567c, 0x2f3d5b },
	{ 0x25683, 0x2f3735 },
	{ 0x25688, 0x265575 },
	{ 0x25689, 0x25412b },
	{ 0x2568a, 0x25412a },
	{ 0x2568b, 0x25412c },
	{ 0x2568c, 0x264c3f },
	{ 0x2568d, 0x243f48 },
	{ 0x2568e, 0x2f3d58 },
	{ 0x2568f, 0x2f3d59 },
	{ 0x25690, 0x2f3d5a },
	{ 0x25691, 0x2f3d5c },
	{ 0x25692, 0x2f3d5d },
	{ 0x25693, 0x2f3d5e },
	{ 0x25694, 0x2f3d5f },
	{ 0x25695, 0x2f3d62 },
	{ 0x25696, 0x2f3d63 },
	{ 0x25697, 0x2f3d64 },
	{ 0x25698, 0x2f4428 },
	{ 0x25699, 0x2f442a },
	{ 0x2569a, 0x2f3d61 },
	{ 0x2569c, 0x265574 },
	{ 0x256a6, 0x254823 },
	{ 0x256a7, 0x265f5f },
	{ 0x256a8, 0x265f60 },
	{ 0x256a9, 0x244556 },
	{ 0x256aa, 0x265f63 },
	{ 0x256ab, 0x265f61 },
	{ 0x256b0, 0x2f4427 },
	{ 0x256b1, 0x2f4429 },
	{ 0x256b2, 0x2f442b },
	{ 0x256b3, 0x2f442c },
	{ 0x256b4, 0x2f442d },
	{ 0x256b5, 0x2f442e },
	{ 0x256b6, 0x2f442f },
	{ 0x256b7, 0x2f4430 },
	{ 0x256b8, 0x2f4431 },
	{ 0x256b9, 0x2f4432 },
	{ 0x256c0, 0x265f5d },
	{ 0x256c1, 0x265f62 },
	{ 0x256c2, 0x254821 },
	{ 0x256c3, 0x265f5e },
	{ 0x256c5, 0x244b5f },
	{ 0x256c6, 0x272626 },
	{ 0x256c7, 0x265f5c },
	{ 0x256c8, 0x265f64 },
	{ 0x256ca, 0x2f4a53 },
	{ 0x256cb, 0x2f4a55 },
	{ 0x256cc, 0x2f4a56 },
	{ 0x256cd, 0x2f4a57 },
	{ 0x256ce, 0x2f4a58 },
	{ 0x256cf, 0x2f4a5a },
	{ 0x256d4, 0x272628 },
	{ 0x256d8, 0x255638 },
	{ 0x256d9, 0x27305c },
	{ 0x256da, 0x255636 },
	{ 0x256db, 0x27305d },
	{ 0x256dc, 0x245177 },
	{ 0x256dd, 0x255639 },
	{ 0x256de, 0x255637 },
	{ 0x256df, 0x25563a },
	{ 0x256e0, 0x27262a },
	{ 0x256e1, 0x27305b },
	{ 0x256e2, 0x2f506a },
	{ 0x256e3, 0x2f5069 },
	{ 0x256e4, 0x2f5651 },
	{ 0x256ee, 0x245743 },
	{ 0x256ef, 0x255c5a },
	{ 0x256f0, 0x273973 },
	{ 0x256f1, 0x245744 },
	{ 0x256f2, 0x273976 },
	{ 0x256f3, 0x273974 },
	{ 0x256f4, 0x27305e },
	{ 0x256f5, 0x2f506b },
	{ 0x256f7, 0x2f564e },
	{ 0x256f8, 0x2f564f },
	{ 0x256f9, 0x2f5650 },
	{ 0x256fa, 0x2f5652 },
	{ 0x256fb, 0x273971 },
	{ 0x256fc, 0x273975 },
	{ 0x256fd, 0x273972 },
	{ 0x256ff, 0x273970 },
	{ 0x25701, 0x2f5b4d },
	{ 0x25702, 0x2f5b4f },
	{ 0x25703, 0x245c34 },
	{ 0x25704, 0x25627b },
	{ 0x25705, 0x27412c },
	{ 0x25707, 0x2f5b4b },
	{ 0x25708, 0x2f5b4c },
	{ 0x25709, 0x2f5b4e },
	{ 0x2570a, 0x2f5b50 },
	{ 0x2570b, 0x2f5b51 },
	{ 0x2570c, 0x2f5b52 },
	{ 0x2570f, 0x27412b },
	{ 0x25711, 0x245c33 },
	{ 0x25712, 0x25685b },
	{ 0x25713, 0x27483c },
	{ 0x25714, 0x27483d },
	{ 0x25715, 0x2f5f6a },
	{ 0x25717, 0x2f5f6b },
	{ 0x2571a, 0x256c68 },
	{ 0x2571b, 0x246377 },
	{ 0x2571e, 0x2f655e },
	{ 0x2571f, 0x274e5e },
	{ 0x25720, 0x275426 },
	{ 0x25723, 0x275425 },
	{ 0x25725, 0x2f655f },
	{ 0x25726, 0x24687d },
	{ 0x25727, 0x27584a },
	{ 0x25729, 0x27584b },
	{ 0x2572a, 0x275c29 },
	{ 0x2572b, 0x2f695d },
	{ 0x2572c, 0x275c2a },
	{ 0x2572f, 0x275c2b },
	{ 0x25730, 0x25776e },
	{ 0x25731, 0x275c2c },
	{ 0x25732, 0x25776f },
	{ 0x25733, 0x2f6a67 },
	{ 0x25734, 0x257932 },
	{ 0x25737, 0x276249 },
	{ 0x25738, 0x276247 },
	{ 0x25739, 0x27635d },
	{ 0x2573a, 0x2f6c67 },
	{ 0x2573b, 0x2f2269 },
	{ 0x2573c, 0x26334d },
	{ 0x2573d, 0x264264 },
	{ 0x2573e, 0x24395b },
	{ 0x2573f, 0x264c40 },
	{ 0x25741, 0x265576 },
	{ 0x25743, 0x265f65 },
	{ 0x25744, 0x27262c },
	{ 0x25745, 0x27305f },
	{ 0x25747, 0x273060 },
	{ 0x25748, 0x27412d },
	{ 0x2574a, 0x25736b },
	{ 0x2574b, 0x276128 },
	{ 0x2574c, 0x24217e },
	{ 0x2574d, 0x262541 },
	{ 0x2574f, 0x2f226a },
	{ 0x25750, 0x26286f },
	{ 0x25752, 0x2f2525 },
	{ 0x25753, 0x262870 },
	{ 0x25754, 0x242755 },
	{ 0x25755, 0x252748 },
	{ 0x25756, 0x242757 },
	{ 0x25758, 0x252747 },
	{ 0x2575a, 0x2f283e },
	{ 0x2575b, 0x2f283f },
	{ 0x2575c, 0x2f2840 },
	{ 0x2575d, 0x2f2841 },
	{ 0x2575e, 0x2f2842 },
	{ 0x25762, 0x262d4a },
	{ 0x25763, 0x263351 },
	{ 0x25764, 0x263354 },
	{ 0x25765, 0x252a74 },
	{ 0x25766, 0x252a72 },
	{ 0x25767, 0x242a70 },
	{ 0x25768, 0x252a75 },
	{ 0x25769, 0x263356 },
	{ 0x2576a, 0x263350 },
	{ 0x2576b, 0x263352 },
	{ 0x2576c, 0x242a6d },
	{ 0x2576d, 0x26334f },
	{ 0x2576e, 0x252a73 },
	{ 0x2576f, 0x263357 },
	{ 0x25773, 0x2f2c6b },
	{ 0x25774, 0x2f2c6c },
	{ 0x25775, 0x2f2c6e },
	{ 0x25776, 0x2f2c6f },
	{ 0x25779, 0x2f2c70 },
	{ 0x2577a, 0x263355 },
	{ 0x2577b, 0x263353 },
	{ 0x2577c, 0x26334e },
	{ 0x2577e, 0x252f3c },
	{ 0x2577f, 0x252f3b },
	{ 0x25780, 0x263a45 },
	{ 0x25781, 0x252f3d },
	{ 0x25782, 0x263a46 },
	{ 0x25783, 0x252f3e },
	{ 0x25784, 0x252a76 },
	{ 0x25785, 0x25343c },
	{ 0x25786, 0x263a47 },
	{ 0x25788, 0x2f3155 },
	{ 0x25789, 0x2f3156 },
	{ 0x25792, 0x263a42 },
	{ 0x25797, 0x263a44 },
	{ 0x25798, 0x25343a },
	{ 0x25799, 0x264269 },
	{ 0x2579a, 0x25343f },
	{ 0x2579b, 0x243368 },
	{ 0x2579c, 0x25343d },
	{ 0x2579d, 0x264268 },
	{ 0x2579e, 0x253437 },
	{ 0x2579f, 0x2f373a },
	{ 0x257a0, 0x2f373c },
	{ 0x257a1, 0x2f373d },
	{ 0x257a2, 0x2f373e },
	{ 0x257a9, 0x24336c },
	{ 0x257af, 0x264265 },
	{ 0x257b1, 0x26426a },
	{ 0x257b2, 0x24395f },
	{ 0x257b3, 0x253a64 },
	{ 0x257b4, 0x243960 },
	{ 0x257b5, 0x24395c },
	{ 0x257b6, 0x264c41 },
	{ 0x257b7, 0x264c42 },
	{ 0x257b8, 0x264c45 },
	{ 0x257b9, 0x264c47 },
	{ 0x257ba, 0x24395d },
	{ 0x257bb, 0x264c44 },
	{ 0x257bc, 0x243f51 },
	{ 0x257bd, 0x2f3d65 },
	{ 0x257be, 0x2f3d67 },
	{ 0x257bf, 0x2f3d69 },
	{ 0x257c5, 0x25343e },
	{ 0x257c7, 0x2f3d66 },
	{ 0x257cd, 0x254136 },
	{ 0x257ce, 0x25412f },
	{ 0x257cf, 0x265579 },
	{ 0x257d0, 0x265577 },
	{ 0x257d1, 0x26557a },
	{ 0x257d2, 0x254130 },
	{ 0x257d3, 0x25412d },
	{ 0x257d4, 0x254132 },
	{ 0x257d5, 0x254134 },
	{ 0x257d6, 0x254138 },
	{ 0x257d7, 0x254133 },
	{ 0x257d8, 0x243f4e },
	{ 0x257d9, 0x265621 },
	{ 0x257da, 0x25412e },
	{ 0x257db, 0x26557b },
	{ 0x257dc, 0x26557e },
	{ 0x257de, 0x26557c },
	{ 0x257e2, 0x2f4433 },
	{ 0x257e3, 0x2f4434 },
	{ 0x257e4, 0x2f4435 },
	{ 0x257e5, 0x2f4436 },
	{ 0x257e6, 0x2f4437 },
	{ 0x257e7, 0x2f4438 },
	{ 0x257e8, 0x2f4439 },
	{ 0x257e9, 0x2f443a },
	{ 0x257f7, 0x265578 },
	{ 0x257f8, 0x26557d },
	{ 0x257fa, 0x254137 },
	{ 0x257fb, 0x254135 },
	{ 0x257fd, 0x254828 },
	{ 0x257fe, 0x265f69 },
	{ 0x257ff, 0x25452d },
	{ 0x25800, 0x25482d },
	{ 0x25801, 0x265f68 },
	{ 0x25802, 0x265f66 },
	{ 0x25803, 0x265f6a },
	{ 0x25804, 0x24455c },
	{ 0x25805, 0x25482e },
	{ 0x25806, 0x254829 },
	{ 0x25807, 0x265f6e },
	{ 0x25808, 0x265f6f },
	{ 0x25809, 0x25482b },
	{ 0x2580a, 0x254827 },
	{ 0x2580b, 0x25482c },
	{ 0x2580c, 0x265f70 },
	{ 0x2580d, 0x25482a },
	{ 0x2580e, 0x265f67 },
	{ 0x2580f, 0x2f4a60 },
	{ 0x25810, 0x2f4a5b },
	{ 0x25811, 0x2f4a5c },
	{ 0x25812, 0x2f4a5d },
	{ 0x25813, 0x2f4a5e },
	{ 0x25814, 0x2f4a5f },
	{ 0x25815, 0x2f4a61 },
	{ 0x25816, 0x2f4a62 },
	{ 0x25817, 0x2f4a63 },
	{ 0x25818, 0x2f4a65 },
	{ 0x25821, 0x265f6d },
	{ 0x25822, 0x265f6c },
	{ 0x25831, 0x254e7b },
	{ 0x25832, 0x254e78 },
	{ 0x25833, 0x254e7a },
	{ 0x25834, 0x272633 },
	{ 0x25835, 0x272630 },
	{ 0x25836, 0x254e79 },
	{ 0x25837, 0x244b69 },
	{ 0x25839, 0x272634 },
	{ 0x2583a, 0x272631 },
	{ 0x2583c, 0x272638 },
	{ 0x2583d, 0x25482f },
	{ 0x2583e, 0x27262f },
	{ 0x2583f, 0x255645 },
	{ 0x25840, 0x254e7c },
	{ 0x25841, 0x254e7d },
	{ 0x25843, 0x244b67 },
	{ 0x25845, 0x244b6a },
	{ 0x25846, 0x272635 },
	{ 0x25847, 0x2f506c },
	{ 0x25848, 0x2f506e },
	{ 0x25849, 0x2f506f },
	{ 0x2584a, 0x2f5070 },
	{ 0x2584b, 0x2f5071 },
	{ 0x2584c, 0x2f5072 },
	{ 0x25854, 0x27262e },
	{ 0x2585a, 0x272636 },
	{ 0x2585b, 0x272637 },
	{ 0x2585c, 0x24517b },
	{ 0x2585d, 0x27306d },
	{ 0x2585f, 0x25563d },
	{ 0x25860, 0x255640 },
	{ 0x25861, 0x273069 },
	{ 0x25862, 0x25563c },
	{ 0x25863, 0x25563f },
	{ 0x25864, 0x25563e },
	{ 0x25865, 0x24517e },
	{ 0x25866, 0x25563b },
	{ 0x25867, 0x255643 },
	{ 0x25868, 0x273063 },
	{ 0x25869, 0x273064 },
	{ 0x2586a, 0x255642 },
	{ 0x2586b, 0x273062 },
	{ 0x2586c, 0x255646 },
	{ 0x2586d, 0x255c5b },
	{ 0x2586e, 0x255647 },
	{ 0x2586f, 0x27306b },
	{ 0x25870, 0x27306a },
	{ 0x25873, 0x27306c },
	{ 0x25874, 0x273061 },
	{ 0x25875, 0x2f5654 },
	{ 0x25876, 0x2f5655 },
	{ 0x25879, 0x273065 },
	{ 0x25880, 0x273067 },
	{ 0x25881, 0x273068 },
	{ 0x25887, 0x255644 },
	{ 0x25888, 0x255641 },
	{ 0x2588a, 0x255c5e },
	{ 0x2588b, 0x255c61 },
	{ 0x2588c, 0x255c62 },
	{ 0x2588d, 0x255c5f },
	{ 0x2588e, 0x255c5c },
	{ 0x2588f, 0x255c5d },
	{ 0x25891, 0x24574a },
	{ 0x25892, 0x273977 },
	{ 0x25893, 0x255c64 },
	{ 0x25894, 0x245746 },
	{ 0x25895, 0x255c60 },
	{ 0x25896, 0x27397a },
	{ 0x25898, 0x2f5b54 },
	{ 0x25899, 0x2f5b55 },
	{ 0x2589a, 0x2f5b56 },
	{ 0x2589b, 0x2f5b57 },
	{ 0x2589c, 0x2f5b58 },
	{ 0x2589d, 0x2f5b5a },
	{ 0x2589e, 0x273978 },
	{ 0x258a7, 0x2f5b53 },
	{ 0x258ad, 0x255648 },
	{ 0x258ae, 0x273979 },
	{ 0x258b0, 0x255c63 },
	{ 0x258b1, 0x2f5653 },
	{ 0x258b4, 0x25627d },
	{ 0x258b5, 0x256326 },
	{ 0x258b6, 0x256324 },
	{ 0x258b7, 0x256321 },
	{ 0x258b8, 0x256322 },
	{ 0x258b9, 0x256325 },
	{ 0x258ba, 0x274130 },
	{ 0x258bb, 0x25627e },
	{ 0x258bc, 0x27412f },
	{ 0x258bd, 0x256323 },
	{ 0x258bf, 0x2f5f6c },
	{ 0x258c0, 0x2f5f6d },
	{ 0x258c1, 0x2f5f6e },
	{ 0x258c2, 0x2f5f6f },
	{ 0x258c3, 0x2f5f70 },
	{ 0x258c4, 0x2f5f71 },
	{ 0x258c5, 0x2f5f72 },
	{ 0x258d3, 0x25627c },
	{ 0x258d6, 0x25685e },
	{ 0x258d7, 0x246043 },
	{ 0x258d8, 0x25685c },
	{ 0x258d9, 0x246044 },
	{ 0x258da, 0x246047 },
	{ 0x258dc, 0x27483f },
	{ 0x258de, 0x246046 },
	{ 0x258df, 0x25685d },
	{ 0x258e0, 0x274e62 },
	{ 0x258e5, 0x274841 },
	{ 0x258e6, 0x27483e },
	{ 0x258e7, 0x2f6330 },
	{ 0x258e8, 0x274840 },
	{ 0x258e9, 0x256c6b },
	{ 0x258ea, 0x24637a },
	{ 0x258eb, 0x246378 },
	{ 0x258ec, 0x256c6a },
	{ 0x258ed, 0x274e60 },
	{ 0x258ee, 0x245c38 },
	{ 0x258ef, 0x256c69 },
	{ 0x258f0, 0x256c6c },
	{ 0x258f1, 0x274e5f },
	{ 0x258f2, 0x274e61 },
	{ 0x258f3, 0x2f6560 },
	{ 0x258f4, 0x2f6561 },
	{ 0x258f5, 0x2f6563 },
	{ 0x258f7, 0x274e63 },
	{ 0x258fe, 0x256c6d },
	{ 0x25900, 0x275428 },
	{ 0x25901, 0x275427 },
	{ 0x25902, 0x257058 },
	{ 0x25903, 0x275429 },
	{ 0x25905, 0x27584d },
	{ 0x25906, 0x25736c },
	{ 0x25907, 0x27584e },
	{ 0x2590a, 0x257630 },
	{ 0x2590b, 0x257631 },
	{ 0x2590c, 0x27584f },
	{ 0x2590e, 0x257770 },
	{ 0x25911, 0x275c2d },
	{ 0x25912, 0x275c2e },
	{ 0x25913, 0x275f28 },
	{ 0x25914, 0x275e71 },
	{ 0x25915, 0x2f6b57 },
	{ 0x25916, 0x2f6b58 },
	{ 0x25917, 0x246c77 },
	{ 0x25918, 0x257933 },
	{ 0x25919, 0x2f6c34 },
	{ 0x2591a, 0x246c78 },
	{ 0x2591c, 0x257a2e },
	{ 0x2591e, 0x257b61 },
	{ 0x2591f, 0x257b62 },
	{ 0x25922, 0x262337 },
	{ 0x25923, 0x25246f },
	{ 0x25924, 0x252470 },
	{ 0x25927, 0x242759 },
	{ 0x25928, 0x24275a },
	{ 0x25929, 0x242758 },
	{ 0x2592a, 0x262d4d },
	{ 0x2592b, 0x262d4c },
	{ 0x2592d, 0x262d4f },
	{ 0x2592e, 0x232a45 },
	{ 0x25930, 0x262d4b },
	{ 0x25931, 0x2f2843 },
	{ 0x25934, 0x242a74 },
	{ 0x25935, 0x263359 },
	{ 0x25936, 0x26335b },
	{ 0x25937, 0x263358 },
	{ 0x25938, 0x252a77 },
	{ 0x25939, 0x242a73 },
	{ 0x2593a, 0x252a79 },
	{ 0x2593b, 0x252a78 },
	{ 0x2593c, 0x26335a },
	{ 0x2593d, 0x26335c },
	{ 0x2593e, 0x26335d },
	{ 0x2593f, 0x252a7a },
	{ 0x25941, 0x2f2c71 },
	{ 0x25942, 0x2f2c72 },
	{ 0x25943, 0x2f2c73 },
	{ 0x25947, 0x252f3f },
	{ 0x25948, 0x242e66 },
	{ 0x25949, 0x242e6b },
	{ 0x2594a, 0x242e68 },
	{ 0x2594b, 0x252f43 },
	{ 0x2594c, 0x252f42 },
	{ 0x2594d, 0x252f41 },
	{ 0x2594e, 0x263a4c },
	{ 0x2594f, 0x242e69 },
	{ 0x25950, 0x242e6a },
	{ 0x25951, 0x242e67 },
	{ 0x25952, 0x263a4a },
	{ 0x25953, 0x263a48 },
	{ 0x25954, 0x252f40 },
	{ 0x25957, 0x252f44 },
	{ 0x25958, 0x2f3158 },
	{ 0x25959, 0x2f3159 },
	{ 0x2595a, 0x2f315a },
	{ 0x2595b, 0x263a4b },
	{ 0x2595e, 0x263a49 },
	{ 0x25960, 0x253444 },
	{ 0x25961, 0x253443 },
	{ 0x25962, 0x26426c },
	{ 0x25963, 0x26426b },
	{ 0x25964, 0x26426d },
	{ 0x25965, 0x253441 },
	{ 0x25966, 0x24336e },
	{ 0x25967, 0x253442 },
	{ 0x25968, 0x253440 },
	{ 0x25969, 0x26426e },
	{ 0x2596a, 0x2f3740 },
	{ 0x2596b, 0x2f3741 },
	{ 0x2596c, 0x2f3742 },
	{ 0x2596d, 0x2f3743 },
	{ 0x2596e, 0x2f3744 },
	{ 0x25976, 0x253a72 },
	{ 0x25977, 0x243966 },
	{ 0x25978, 0x253a74 },
	{ 0x25979, 0x264c4e },
	{ 0x2597a, 0x264c4a },
	{ 0x2597b, 0x243969 },
	{ 0x2597c, 0x264c52 },
	{ 0x2597d, 0x253a69 },
	{ 0x2597e, 0x253a6f },
	{ 0x2597f, 0x253a71 },
	{ 0x25980, 0x264c50 },
	{ 0x25981, 0x253a67 },
	{ 0x25982, 0x264c51 },
	{ 0x25983, 0x253a68 },
	{ 0x25984, 0x264c4b },
	{ 0x25985, 0x253a6a },
	{ 0x25986, 0x243968 },
	{ 0x25987, 0x253a73 },
	{ 0x25988, 0x264c4c },
	{ 0x2598a, 0x253a70 },
	{ 0x2598b, 0x264c49 },
	{ 0x2598c, 0x253a66 },
	{ 0x2598d, 0x253a6d },
	{ 0x2598e, 0x264c4f },
	{ 0x2598f, 0x253a6e },
	{ 0x25990, 0x253a6b },
	{ 0x25991, 0x264c4d },
	{ 0x25993, 0x2f3d6b },
	{ 0x2599b, 0x25413a },
	{ 0x2599c, 0x265629 },
	{ 0x2599d, 0x25413c },
	{ 0x2599e, 0x25413b },
	{ 0x2599f, 0x25413e },
	{ 0x259a0, 0x265622 },
	{ 0x259a1, 0x265624 },
	{ 0x259a2, 0x253a6c },
	{ 0x259a4, 0x25413d },
	{ 0x259a5, 0x25413f },
	{ 0x259a6, 0x265628 },
	{ 0x259a7, 0x26562b },
	{ 0x259a8, 0x254140 },
	{ 0x259a9, 0x265626 },
	{ 0x259aa, 0x265625 },
	{ 0x259ad, 0x2f443b },
	{ 0x259ae, 0x2f443d },
	{ 0x259af, 0x2f443e },
	{ 0x259b0, 0x2f443f },
	{ 0x259b1, 0x2f4440 },
	{ 0x259b2, 0x265623 },
	{ 0x259b5, 0x26562a },
	{ 0x259b6, 0x265726 },
	{ 0x259b8, 0x244561 },
	{ 0x259b9, 0x265f77 },
	{ 0x259ba, 0x254832 },
	{ 0x259bb, 0x265f76 },
	{ 0x259bc, 0x265f72 },
	{ 0x259bd, 0x265f74 },
	{ 0x259be, 0x265f73 },
	{ 0x259bf, 0x254831 },
	{ 0x259c5, 0x265f79 },
	{ 0x259c6, 0x2f4a66 },
	{ 0x259c7, 0x254833 },
	{ 0x259ca, 0x265f71 },
	{ 0x259cf, 0x2f443c },
	{ 0x259d0, 0x27263b },
	{ 0x259d2, 0x254f21 },
	{ 0x259d3, 0x254f27 },
	{ 0x259d4, 0x254f2a },
	{ 0x259d5, 0x254830 },
	{ 0x259d6, 0x27263a },
	{ 0x259d7, 0x254f2b },
	{ 0x259d8, 0x254f26 },
	{ 0x259d9, 0x254f22 },
	{ 0x259da, 0x254f2c },
	{ 0x259db, 0x254f25 },
	{ 0x259dc, 0x272639 },
	{ 0x259dd, 0x254e7e },
	{ 0x259de, 0x254f28 },
	{ 0x259df, 0x254f24 },
	{ 0x259e0, 0x254f29 },
	{ 0x259e2, 0x27272e },
	{ 0x259e5, 0x244b6d },
	{ 0x259ec, 0x25564f },
	{ 0x259ed, 0x255651 },
	{ 0x259ee, 0x245223 },
	{ 0x259ef, 0x255650 },
	{ 0x259f0, 0x245226 },
	{ 0x259f1, 0x255649 },
	{ 0x259f2, 0x245228 },
	{ 0x259f3, 0x273070 },
	{ 0x259f4, 0x25564a },
	{ 0x259f5, 0x25564c },
	{ 0x259f6, 0x25564b },
	{ 0x259f7, 0x255653 },
	{ 0x259f8, 0x25564d },
	{ 0x259f9, 0x255654 },
	{ 0x259fa, 0x27306e },
	{ 0x259fb, 0x25564e },
	{ 0x259fc, 0x255c65 },
	{ 0x259fd, 0x255655 },
	{ 0x259ff, 0x2f5656 },
	{ 0x25a00, 0x2f5657 },
	{ 0x25a01, 0x2f5658 },
	{ 0x25a02, 0x2f5659 },
	{ 0x25a03, 0x2f565a },
	{ 0x25a0a, 0x273071 },
	{ 0x25a0d, 0x255c6a },
	{ 0x25a0e, 0x255c67 },
	{ 0x25a0f, 0x273a21 },
	{ 0x25a10, 0x24574e },
	{ 0x25a11, 0x255c69 },
	{ 0x25a12, 0x27397c },
	{ 0x25a13, 0x27397d },
	{ 0x25a14, 0x27397b },
	{ 0x25a15, 0x255c66 },
	{ 0x25a16, 0x27397e },
	{ 0x25a17, 0x273072 },
	{ 0x25a18, 0x255c68 },
	{ 0x25a1a, 0x2f5b5b },
	{ 0x25a21, 0x256328 },
	{ 0x25a22, 0x256327 },
	{ 0x25a23, 0x2f5f74 },
	{ 0x25a2a, 0x24604a },
	{ 0x25a2b, 0x274844 },
	{ 0x25a2c, 0x274843 },
	{ 0x25a2d, 0x25685f },
	{ 0x25a2e, 0x274842 },
	{ 0x25a30, 0x274e64 },
	{ 0x25a31, 0x274e66 },
	{ 0x25a32, 0x256860 },
	{ 0x25a33, 0x24637b },
	{ 0x25a34, 0x256c6e },
	{ 0x25a35, 0x27542d },
	{ 0x25a36, 0x274e67 },
	{ 0x25a37, 0x274e65 },
	{ 0x25a38, 0x2f6564 },
	{ 0x25a3b, 0x25705b },
	{ 0x25a3c, 0x27542b },
	{ 0x25a3d, 0x246667 },
	{ 0x25a3f, 0x246666 },
	{ 0x25a40, 0x257059 },
	{ 0x25a41, 0x27542c },
	{ 0x25a42, 0x25705a },
	{ 0x25a43, 0x2f6821 },
	{ 0x25a48, 0x2f6565 },
	{ 0x25a4a, 0x257632 },
	{ 0x25a4b, 0x275c2f },
	{ 0x25a4c, 0x257771 },
	{ 0x25a4e, 0x27612a },
	{ 0x25a4f, 0x2f6b59 },
	{ 0x25a50, 0x275f29 },
	{ 0x25a52, 0x257934 },
	{ 0x25a53, 0x27624a },
	{ 0x25a54, 0x257b63 },
	{ 0x25a55, 0x262872 },
	{ 0x25a56, 0x262871 },
	{ 0x25a57, 0x252749 },
	{ 0x25a58, 0x25274a },
	{ 0x25a59, 0x242a75 },
	{ 0x25a5b, 0x2f2c74 },
	{ 0x25a5c, 0x2f2c78 },
	{ 0x25a60, 0x242e6f },
	{ 0x25a61, 0x252f47 },
	{ 0x25a62, 0x252f48 },
	{ 0x25a63, 0x242e6c },
	{ 0x25a64, 0x252f46 },
	{ 0x25a65, 0x252f45 },
	{ 0x25a66, 0x242e6e },
	{ 0x25a67, 0x2f315c },
	{ 0x25a68, 0x2f315d },
	{ 0x25a69, 0x2f315e },
	{ 0x25a6a, 0x2f315f },
	{ 0x25a6b, 0x2f3161 },
	{ 0x25a6c, 0x2f3162 },
	{ 0x25a6d, 0x263a4d },
	{ 0x25a6e, 0x263a4e },
	{ 0x25a71, 0x264272 },
	{ 0x25a72, 0x243373 },
	{ 0x25a73, 0x264271 },
	{ 0x25a74, 0x264273 },
	{ 0x25a75, 0x264270 },
	{ 0x25a76, 0x243374 },
	{ 0x25a78, 0x2f3745 },
	{ 0x25a79, 0x2f3747 },
	{ 0x25a7b, 0x253447 },
	{ 0x25a7c, 0x2f3748 },
	{ 0x25a7e, 0x24396b },
	{ 0x25a7f, 0x264c55 },
	{ 0x25a80, 0x253a75 },
	{ 0x25a81, 0x253a77 },
	{ 0x25a82, 0x253a76 },
	{ 0x25a83, 0x253a78 },
	{ 0x25a84, 0x264c54 },
	{ 0x25a86, 0x2f3d6d },
	{ 0x25a87, 0x2f3d6e },
	{ 0x25a88, 0x2f3d6f },
	{ 0x25a89, 0x2f3d70 },
	{ 0x25a8a, 0x243f56 },
	{ 0x25a8b, 0x243f58 },
	{ 0x25a8c, 0x254142 },
	{ 0x25a8d, 0x243f59 },
	{ 0x25a8e, 0x26562c },
	{ 0x25a8f, 0x254141 },
	{ 0x25a90, 0x26562d },
	{ 0x25a91, 0x26562e },
	{ 0x25a92, 0x2f4441 },
	{ 0x25a93, 0x2f4442 },
	{ 0x25a94, 0x2f4443 },
	{ 0x25a95, 0x254143 },
	{ 0x25a98, 0x254834 },
	{ 0x25a99, 0x265f7a },
	{ 0x25a9a, 0x254835 },
	{ 0x25a9b, 0x244562 },
	{ 0x25a9f, 0x2f4a67 },
	{ 0x25aa0, 0x2f4a68 },
	{ 0x25aa1, 0x2f4a6a },
	{ 0x25aa4, 0x2f4a69 },
	{ 0x25aa5, 0x27263f },
	{ 0x25aa6, 0x244b6e },
	{ 0x25aa7, 0x254f2d },
	{ 0x25aa8, 0x2f5073 },
	{ 0x25aa9, 0x2f5074 },
	{ 0x25aaa, 0x2f5075 },
	{ 0x25aac, 0x27263d },
	{ 0x25aad, 0x2f565c },
	{ 0x25aae, 0x2f565b },
	{ 0x25aaf, 0x245751 },
	{ 0x25ab0, 0x273074 },
	{ 0x25ab1, 0x255656 },
	{ 0x25ab2, 0x2f5b5c },
	{ 0x25ab3, 0x255c6c },
	{ 0x25ab5, 0x255d63 },
	{ 0x25ab6, 0x273a22 },
	{ 0x25abb, 0x255c6b },
	{ 0x25abc, 0x25632a },
	{ 0x25abd, 0x273a23 },
	{ 0x25abe, 0x2f5f75 },
	{ 0x25abf, 0x274131 },
	{ 0x25ac3, 0x256329 },
	{ 0x25ac8, 0x274e68 },
	{ 0x25ac9, 0x27542e },
	{ 0x25aca, 0x2f6566 },
	{ 0x25acd, 0x274845 },
	{ 0x25ace, 0x25705c },
	{ 0x25acf, 0x2f6822 },
	{ 0x25ad0, 0x275850 },
	{ 0x25ad1, 0x2f695e },
	{ 0x25ad2, 0x2f6a68 },
	{ 0x25ad6, 0x27612b },
	{ 0x25ad8, 0x2f2526 },
	{ 0x25ad9, 0x25274b },
	{ 0x25ada, 0x262d50 },
	{ 0x25adb, 0x25274d },
	{ 0x25adc, 0x25274c },
	{ 0x25add, 0x252a7c },
	{ 0x25ade, 0x252a7d },
	{ 0x25adf, 0x252a7b },
	{ 0x25ae0, 0x26335f },
	{ 0x25ae1, 0x26335e },
	{ 0x25ae2, 0x252a7e },
	{ 0x25ae5, 0x2f2c79 },
	{ 0x25ae6, 0x2f2c7a },
	{ 0x25ae7, 0x2f2c7b },
	{ 0x25ae8, 0x2f2c7c },
	{ 0x25aed, 0x2f2c7d },
	{ 0x25aee, 0x2f2924 },
	{ 0x25aef, 0x252f4e },
	{ 0x25af0, 0x252f49 },
	{ 0x25af1, 0x242e74 },
	{ 0x25af3, 0x252f4a },
	{ 0x25af4, 0x252f4c },
	{ 0x25af5, 0x252f4d },
	{ 0x25af6, 0x263a50 },
	{ 0x25af7, 0x252f51 },
	{ 0x25af8, 0x252f4f },
	{ 0x25af9, 0x252f4b },
	{ 0x25afa, 0x263a4f },
	{ 0x25afb, 0x263a51 },
	{ 0x25afc, 0x252f50 },
	{ 0x25afd, 0x252f52 },
	{ 0x25afe, 0x2f3163 },
	{ 0x25aff, 0x2f3164 },
	{ 0x25b00, 0x2f3165 },
	{ 0x25b01, 0x2f3166 },
	{ 0x25b02, 0x2f3167 },
	{ 0x25b03, 0x2f3168 },
	{ 0x25b04, 0x2f3169 },
	{ 0x25b05, 0x2f316a },
	{ 0x25b07, 0x242e76 },
	{ 0x25b0c, 0x264274 },
	{ 0x25b0d, 0x26427a },
	{ 0x25b0e, 0x25344a },
	{ 0x25b0f, 0x243379 },
	{ 0x25b10, 0x25344d },
	{ 0x25b11, 0x264277 },
	{ 0x25b12, 0x25344c },
	{ 0x25b13, 0x26427c },
	{ 0x25b14, 0x243375 },
	{ 0x25b15, 0x25344e },
	{ 0x25b16, 0x264275 },
	{ 0x25b17, 0x252f53 },
	{ 0x25b19, 0x253449 },
	{ 0x25b1a, 0x264279 },
	{ 0x25b1b, 0x26427b },
	{ 0x25b1d, 0x253450 },
	{ 0x25b1e, 0x253451 },
	{ 0x25b1f, 0x264278 },
	{ 0x25b21, 0x2f3749 },
	{ 0x25b22, 0x2f374a },
	{ 0x25b23, 0x2f374b },
	{ 0x25b24, 0x2f374c },
	{ 0x25b25, 0x2f374e },
	{ 0x25b26, 0x2f374f },
	{ 0x25b2a, 0x253a7c },
	{ 0x25b2b, 0x253b22 },
	{ 0x25b2c, 0x253a7b },
	{ 0x25b2d, 0x253a7e },
	{ 0x25b2e, 0x24396c },
	{ 0x25b2f, 0x24396e },
	{ 0x25b30, 0x264c5a },
	{ 0x25b31, 0x25344b },
	{ 0x25b32, 0x243973 },
	{ 0x25b33, 0x253b21 },
	{ 0x25b34, 0x253a7a },
	{ 0x25b35, 0x243979 },
	{ 0x25b36, 0x243977 },
	{ 0x25b37, 0x243970 },
	{ 0x25b38, 0x264c5d },
	{ 0x25b39, 0x243978 },
	{ 0x25b3b, 0x264c57 },
	{ 0x25b3c, 0x253b25 },
	{ 0x25b3d, 0x264c59 },
	{ 0x25b3e, 0x264c5c },
	{ 0x25b3f, 0x25344f },
	{ 0x25b40, 0x253a7d },
	{ 0x25b41, 0x2f3d71 },
	{ 0x25b42, 0x2f3d72 },
	{ 0x25b43, 0x2f3d73 },
	{ 0x25b44, 0x2f3d74 },
	{ 0x25b45, 0x2f3d75 },
	{ 0x25b46, 0x2f3d76 },
	{ 0x25b47, 0x2f3d78 },
	{ 0x25b48, 0x2f3d79 },
	{ 0x25b49, 0x2f3d7a },
	{ 0x25b4a, 0x2f3d77 },
	{ 0x25b4b, 0x253b23 },
	{ 0x25b50, 0x254154 },
	{ 0x25b51, 0x254148 },
	{ 0x25b52, 0x25414f },
	{ 0x25b53, 0x243f5c },
	{ 0x25b54, 0x25414d },
	{ 0x25b55, 0x254145 },
	{ 0x25b56, 0x243f64 },
	{ 0x25b57, 0x243f65 },
	{ 0x25b58, 0x254150 },
	{ 0x25b59, 0x243f5f },
	{ 0x25b5a, 0x253a79 },
	{ 0x25b5b, 0x265630 },
	{ 0x25b5c, 0x254146 },
	{ 0x25b5d, 0x254155 },
	{ 0x25b5e, 0x25414b },
	{ 0x25b5f, 0x254152 },
	{ 0x25b60, 0x254144 },
	{ 0x25b61, 0x254149 },
	{ 0x25b62, 0x25414c },
	{ 0x25b63, 0x265634 },
	{ 0x25b64, 0x265632 },
	{ 0x25b65, 0x265637 },
	{ 0x25b66, 0x26563a },
	{ 0x25b67, 0x265633 },
	{ 0x25b68, 0x265636 },
	{ 0x25b6a, 0x265638 },
	{ 0x25b6b, 0x265f7b },
	{ 0x25b6c, 0x254153 },
	{ 0x25b6d, 0x254151 },
	{ 0x25b6e, 0x25414e },
	{ 0x25b6f, 0x254147 },
	{ 0x25b70, 0x265631 },
	{ 0x25b71, 0x264c58 },
	{ 0x25b77, 0x265635 },
	{ 0x25b78, 0x265639 },
	{ 0x25b79, 0x2f4444 },
	{ 0x25b7a, 0x2f4446 },
	{ 0x25b7b, 0x2f4447 },
	{ 0x25b7c, 0x2f4448 },
	{ 0x25b7d, 0x2f4449 },
	{ 0x25b7e, 0x2f444a },
	{ 0x25b7f, 0x2f444b },
	{ 0x25b80, 0x2f444c },
	{ 0x25b81, 0x2f444d },
	{ 0x25b82, 0x2f444e },
	{ 0x25b83, 0x2f444f },
	{ 0x25b84, 0x2f4450 },
	{ 0x25b85, 0x26562f },
	{ 0x25b8c, 0x2f413e },
	{ 0x25b8d, 0x254845 },
	{ 0x25b8e, 0x254156 },
	{ 0x25b8f, 0x24456c },
	{ 0x25b90, 0x254843 },
	{ 0x25b91, 0x266027 },
	{ 0x25b92, 0x244567 },
	{ 0x25b93, 0x265f7c },
	{ 0x25b94, 0x265f7d },
	{ 0x25b95, 0x25483c },
	{ 0x25b96, 0x25483b },
	{ 0x25b97, 0x254842 },
	{ 0x25b98, 0x24456f },
	{ 0x25b99, 0x266028 },
	{ 0x25b9a, 0x254840 },
	{ 0x25b9b, 0x266026 },
	{ 0x25b9c, 0x254838 },
	{ 0x25b9d, 0x254839 },
	{ 0x25b9e, 0x266025 },
	{ 0x25ba0, 0x266021 },
	{ 0x25ba2, 0x25483a },
	{ 0x25ba3, 0x254841 },
	{ 0x25ba4, 0x254837 },
	{ 0x25ba5, 0x25483d },
	{ 0x25ba6, 0x266022 },
	{ 0x25ba7, 0x25414a },
	{ 0x25ba8, 0x254847 },
	{ 0x25ba9, 0x265f7e },
	{ 0x25baa, 0x25483e },
	{ 0x25bab, 0x266024 },
	{ 0x25bad, 0x25483f },
	{ 0x25bae, 0x244571 },
	{ 0x25baf, 0x254844 },
	{ 0x25bb5, 0x2f4a6b },
	{ 0x25bb6, 0x2f4a6c },
	{ 0x25bb7, 0x2f4a6d },
	{ 0x25bb8, 0x2f4a6e },
	{ 0x25bb9, 0x2f4a6f },
	{ 0x25bba, 0x2f4a70 },
	{ 0x25bbb, 0x2f4a73 },
	{ 0x25bbc, 0x2f4a74 },
	{ 0x25bbd, 0x2f4a75 },
	{ 0x25bbe, 0x2f4a76 },
	{ 0x25bbf, 0x2f4a77 },
	{ 0x25bc0, 0x2f4a78 },
	{ 0x25bc1, 0x2f4a79 },
	{ 0x25bc2, 0x2f4a7a },
	{ 0x25bc6, 0x2f4a72 },
	{ 0x25bd0, 0x2f4a71 },
	{ 0x25bd1, 0x254f3a },
	{ 0x25bd2, 0x272649 },
	{ 0x25bd3, 0x27264b },
	{ 0x25bd4, 0x254f44 },
	{ 0x25bd5, 0x244c2f },
	{ 0x25bd6, 0x254f33 },
	{ 0x25bd7, 0x272651 },
	{ 0x25bd8, 0x27264a },
	{ 0x25bd9, 0x254f3e },
	{ 0x25bda, 0x244b71 },
	{ 0x25bdb, 0x244b6f },
	{ 0x25bdc, 0x254f41 },
	{ 0x25bdd, 0x254f2f },
	{ 0x25bde, 0x254f34 },
	{ 0x25bdf, 0x254f43 },
	{ 0x25be0, 0x272642 },
	{ 0x25be1, 0x254f40 },
	{ 0x25be2, 0x254f31 },
	{ 0x25be3, 0x245240 },
	{ 0x25be4, 0x254f39 },
	{ 0x25be5, 0x254f42 },
	{ 0x25be6, 0x244b72 },
	{ 0x25be7, 0x244c29 },
	{ 0x25be8, 0x244c23 },
	{ 0x25be9, 0x244b7d },
	{ 0x25bea, 0x254f38 },
	{ 0x25beb, 0x254f37 },
	{ 0x25bec, 0x254f3c },
	{ 0x25bed, 0x27264e },
	{ 0x25bee, 0x254848 },
	{ 0x25bef, 0x254f35 },
	{ 0x25bf0, 0x272650 },
	{ 0x25bf1, 0x272647 },
	{ 0x25bf2, 0x272644 },
	{ 0x25bf3, 0x254f3f },
	{ 0x25bf4, 0x272640 },
	{ 0x25bf5, 0x272653 },
	{ 0x25bf6, 0x244c24 },
	{ 0x25bf7, 0x27264f },
	{ 0x25bf8, 0x244b7c },
	{ 0x25bf9, 0x27264c },
	{ 0x25bfa, 0x254f3d },
	{ 0x25bfc, 0x272645 },
	{ 0x25bfd, 0x272643 },
	{ 0x25bfe, 0x254f2e },
	{ 0x25bff, 0x272648 },
	{ 0x25c02, 0x272646 },
	{ 0x25c05, 0x254f46 },
	{ 0x25c06, 0x2f5078 },
	{ 0x25c09, 0x272652 },
	{ 0x25c0b, 0x2f5077 },
	{ 0x25c0c, 0x2f507a },
	{ 0x25c0d, 0x2f507b },
	{ 0x25c0e, 0x2f507c },
	{ 0x25c0f, 0x2f507d },
	{ 0x25c10, 0x2f507e },
	{ 0x25c11, 0x2f5122 },
	{ 0x25c12, 0x2f5124 },
	{ 0x25c13, 0x2f5129 },
	{ 0x25c14, 0x2f5125 },
	{ 0x25c15, 0x2f5126 },
	{ 0x25c16, 0x2f5127 },
	{ 0x25c17, 0x2f512a },
	{ 0x25c18, 0x255664 },
	{ 0x25c19, 0x245241 },
	{ 0x25c1a, 0x24523e },
	{ 0x25c1b, 0x255658 },
	{ 0x25c1c, 0x25565e },
	{ 0x25c1d, 0x255666 },
	{ 0x25c1e, 0x27312a },
	{ 0x25c1f, 0x25565c },
	{ 0x25c20, 0x24522e },
	{ 0x25c21, 0x25565d },
	{ 0x25c22, 0x24522c },
	{ 0x25c23, 0x255668 },
	{ 0x25c24, 0x272641 },
	{ 0x25c25, 0x273125 },
	{ 0x25c26, 0x245232 },
	{ 0x25c27, 0x255667 },
	{ 0x25c28, 0x245231 },
	{ 0x25c29, 0x273129 },
	{ 0x25c2a, 0x24523c },
	{ 0x25c2b, 0x27307e },
	{ 0x25c2c, 0x273126 },
	{ 0x25c2d, 0x245230 },
	{ 0x25c2e, 0x255660 },
	{ 0x25c2f, 0x27307b },
	{ 0x25c30, 0x24523f },
	{ 0x25c31, 0x25565f },
	{ 0x25c32, 0x255659 },
	{ 0x25c33, 0x27307a },
	{ 0x25c34, 0x273128 },
	{ 0x25c35, 0x24522a },
	{ 0x25c36, 0x255657 },
	{ 0x25c37, 0x273124 },
	{ 0x25c38, 0x245235 },
	{ 0x25c39, 0x255665 },
	{ 0x25c3a, 0x27307d },
	{ 0x25c3b, 0x255662 },
	{ 0x25c3c, 0x245233 },
	{ 0x25c3d, 0x27312b },
	{ 0x25c3e, 0x273075 },
	{ 0x25c3f, 0x273127 },
	{ 0x25c40, 0x254f30 },
	{ 0x25c41, 0x255663 },
	{ 0x25c42, 0x25565a },
	{ 0x25c44, 0x273078 },
	{ 0x25c45, 0x273123 },
	{ 0x25c46, 0x273076 },
	{ 0x25c47, 0x255661 },
	{ 0x25c4c, 0x2f5672 },
	{ 0x25c4d, 0x25565b },
	{ 0x25c4e, 0x27307c },
	{ 0x25c4f, 0x273077 },
	{ 0x25c50, 0x273122 },
	{ 0x25c51, 0x2f565d },
	{ 0x25c52, 0x2f565e },
	{ 0x25c53, 0x2f5660 },
	{ 0x25c54, 0x2f5661 },
	{ 0x25c55, 0x2f5662 },
	{ 0x25c56, 0x2f5663 },
	{ 0x25c57, 0x2f5664 },
	{ 0x25c58, 0x2f5665 },
	{ 0x25c59, 0x2f5666 },
	{ 0x25c5a, 0x2f5667 },
	{ 0x25c5b, 0x2f5668 },
	{ 0x25c5c, 0x2f5669 },
	{ 0x25c5d, 0x2f566a },
	{ 0x25c5e, 0x2f566b },
	{ 0x25c5f, 0x2f566c },
	{ 0x25c60, 0x2f566d },
	{ 0x25c61, 0x2f566e },
	{ 0x25c62, 0x2f566f },
	{ 0x25c63, 0x2f5670 },
	{ 0x25c64, 0x2f5671 },
	{ 0x25c66, 0x2f5673 },
	{ 0x25c69, 0x273079 },
	{ 0x25c73, 0x2f5079 },
	{ 0x25c75, 0x255d24 },
	{ 0x25c76, 0x255d21 },
	{ 0x25c77, 0x24575d },
	{ 0x25c78, 0x255c75 },
	{ 0x25c79, 0x255d2d },
	{ 0x25c7a, 0x255c79 },
	{ 0x25c7b, 0x24575c },
	{ 0x25c7c, 0x245763 },
	{ 0x25c7d, 0x245767 },
	{ 0x25c7e, 0x273a2c },
	{ 0x25c7f, 0x255d2b },
	{ 0x25c80, 0x245760 },
	{ 0x25c81, 0x255d22 },
	{ 0x25c84, 0x255c70 },
	{ 0x25c85, 0x255d23 },
	{ 0x25c86, 0x255c72 },
	{ 0x25c87, 0x255d31 },
	{ 0x25c88, 0x255c7b },
	{ 0x25c89, 0x255d2a },
	{ 0x25c8a, 0x255c77 },
	{ 0x25c8b, 0x255d34 },
	{ 0x25c8c, 0x273a24 },
	{ 0x25c8d, 0x255c76 },
	{ 0x25c8e, 0x255c7c },
	{ 0x25c8f, 0x255d26 },
	{ 0x25c90, 0x245764 },
	{ 0x25c91, 0x255d27 },
	{ 0x25c92, 0x273a29 },
	{ 0x25c95, 0x256342 },
	{ 0x25c96, 0x255d2c },
	{ 0x25c97, 0x255c7a },
	{ 0x25c98, 0x273a2f },
	{ 0x25c99, 0x273a28 },
	{ 0x25c9a, 0x255c6f },
	{ 0x25c9b, 0x255d32 },
	{ 0x25c9c, 0x255d29 },
	{ 0x25c9d, 0x255c73 },
	{ 0x25c9e, 0x273a2b },
	{ 0x25c9f, 0x255d2e },
	{ 0x25ca0, 0x255c71 },
	{ 0x25ca1, 0x255c6e },
	{ 0x25ca2, 0x255d28 },
	{ 0x25ca3, 0x245766 },
	{ 0x25ca4, 0x245c3c },
	{ 0x25ca5, 0x255d33 },
	{ 0x25ca6, 0x255c78 },
	{ 0x25ca7, 0x255d2f },
	{ 0x25ca8, 0x255d25 },
	{ 0x25ca9, 0x273121 },
	{ 0x25caa, 0x255c74 },
	{ 0x25cab, 0x273a27 },
	{ 0x25cac, 0x273a26 },
	{ 0x25cae, 0x273a25 },
	{ 0x25caf, 0x273a2d },
	{ 0x25cb0, 0x2f5b5d },
	{ 0x25cb1, 0x2f5b5e },
	{ 0x25cb2, 0x2f5b60 },
	{ 0x25cb3, 0x2f5b61 },
	{ 0x25cb4, 0x2f5b62 },
	{ 0x25cb5, 0x2f5b63 },
	{ 0x25cb6, 0x2f5b64 },
	{ 0x25cb7, 0x2f5b66 },
	{ 0x25cb8, 0x2f5b67 },
	{ 0x25cb9, 0x2f5b68 },
	{ 0x25cba, 0x2f5b69 },
	{ 0x25cbb, 0x273a2a },
	{ 0x25cbc, 0x273a2e },
	{ 0x25cbd, 0x245768 },
	{ 0x25cc0, 0x2f5b65 },
	{ 0x25cc6, 0x245761 },
	{ 0x25cc7, 0x25634b },
	{ 0x25cc8, 0x256347 },
	{ 0x25cc9, 0x255d35 },
	{ 0x25cca, 0x245c52 },
	{ 0x25ccb, 0x256345 },
	{ 0x25ccc, 0x256338 },
	{ 0x25ccd, 0x256333 },
	{ 0x25cce, 0x245c47 },
	{ 0x25ccf, 0x25634a },
	{ 0x25cd0, 0x256340 },
	{ 0x25cd1, 0x23584f },
	{ 0x25cd2, 0x25632e },
	{ 0x25cd3, 0x245c4e },
	{ 0x25cd4, 0x245c45 },
	{ 0x25cd5, 0x256343 },
	{ 0x25cd6, 0x256339 },
	{ 0x25cd7, 0x25634c },
	{ 0x25cd8, 0x245c3d },
	{ 0x25cd9, 0x27413b },
	{ 0x25cda, 0x256346 },
	{ 0x25cdb, 0x256330 },
	{ 0x25cdc, 0x256337 },
	{ 0x25cdd, 0x245c3e },
	{ 0x25cde, 0x245c3f },
	{ 0x25cdf, 0x256348 },
	{ 0x25ce0, 0x274139 },
	{ 0x25ce1, 0x256335 },
	{ 0x25ce2, 0x256332 },
	{ 0x25ce3, 0x25633f },
	{ 0x25ce4, 0x274135 },
	{ 0x25ce5, 0x25632c },
	{ 0x25ce6, 0x274136 },
	{ 0x25ce7, 0x245c41 },
	{ 0x25ce8, 0x274133 },
	{ 0x25ce9, 0x245c53 },
	{ 0x25cea, 0x25633e },
	{ 0x25ceb, 0x274138 },
	{ 0x25cec, 0x25633d },
	{ 0x25ced, 0x27413a },
	{ 0x25cee, 0x27413e },
	{ 0x25cef, 0x274134 },
	{ 0x25cf0, 0x256331 },
	{ 0x25cf1, 0x245c4d },
	{ 0x25cf2, 0x256336 },
	{ 0x25cf3, 0x25633a },
	{ 0x25cf4, 0x256344 },
	{ 0x25cf5, 0x256349 },
	{ 0x25cf6, 0x25633c },
	{ 0x25cf7, 0x25632d },
	{ 0x25cf8, 0x274142 },
	{ 0x25cf9, 0x274141 },
	{ 0x25cfa, 0x25633b },
	{ 0x25cff, 0x25632b },
	{ 0x25d00, 0x25632f },
	{ 0x25d01, 0x274132 },
	{ 0x25d02, 0x274137 },
	{ 0x25d03, 0x2f5f76 },
	{ 0x25d04, 0x2f5f77 },
	{ 0x25d05, 0x2f5f78 },
	{ 0x25d06, 0x2f5f79 },
	{ 0x25d07, 0x2f5f7a },
	{ 0x25d08, 0x2f5f7b },
	{ 0x25d09, 0x2f5f7c },
	{ 0x25d0a, 0x2f5f7d },
	{ 0x25d0b, 0x2f5f7e },
	{ 0x25d0c, 0x2f6021 },
	{ 0x25d0d, 0x2f6023 },
	{ 0x25d0e, 0x2f6024 },
	{ 0x25d0f, 0x2f6025 },
	{ 0x25d13, 0x274140 },
	{ 0x25d14, 0x27413d },
	{ 0x25d1d, 0x2f5b6a },
	{ 0x25d1e, 0x2f6336 },
	{ 0x25d1f, 0x2f6337 },
	{ 0x25d20, 0x2f6022 },
	{ 0x25d21, 0x25686a },
	{ 0x25d22, 0x25686f },
	{ 0x25d23, 0x27484e },
	{ 0x25d24, 0x246059 },
	{ 0x25d25, 0x27484c },
	{ 0x25d26, 0x256863 },
	{ 0x25d27, 0x246054 },
	{ 0x25d28, 0x246055 },
	{ 0x25d29, 0x246051 },
	{ 0x25d2a, 0x256869 },
	{ 0x25d2b, 0x24604f },
	{ 0x25d2c, 0x246050 },
	{ 0x25d2d, 0x274848 },
	{ 0x25d2e, 0x246052 },
	{ 0x25d2f, 0x256862 },
	{ 0x25d30, 0x246058 },
	{ 0x25d31, 0x24604d },
	{ 0x25d32, 0x274847 },
	{ 0x25d34, 0x25686d },
	{ 0x25d35, 0x256868 },
	{ 0x25d36, 0x256870 },
	{ 0x25d37, 0x25686c },
	{ 0x25d38, 0x25686b },
	{ 0x25d39, 0x256865 },
	{ 0x25d3a, 0x256864 },
	{ 0x25d3b, 0x256867 },
	{ 0x25d3d, 0x274846 },
	{ 0x25d3e, 0x27484a },
	{ 0x25d3f, 0x256861 },
	{ 0x25d44, 0x256871 },
	{ 0x25d45, 0x274849 },
	{ 0x25d46, 0x2f6331 },
	{ 0x25d47, 0x2f6333 },
	{ 0x25d48, 0x2f6334 },
	{ 0x25d49, 0x2f6335 },
	{ 0x25d4a, 0x2f6338 },
	{ 0x25d4b, 0x2f6339 },
	{ 0x25d4c, 0x2f633a },
	{ 0x25d4d, 0x2f633b },
	{ 0x25d4e, 0x2f633c },
	{ 0x25d50, 0x27484b },
	{ 0x25d53, 0x27484d },
	{ 0x25d5c, 0x256c7c },
	{ 0x25d5d, 0x256c7b },
	{ 0x25d5e, 0x256c76 },
	{ 0x25d5f, 0x246057 },
	{ 0x25d60, 0x256c74 },
	{ 0x25d61, 0x274e6c },
	{ 0x25d62, 0x256c7a },
	{ 0x25d63, 0x24637d },
	{ 0x25d64, 0x274e74 },
	{ 0x25d65, 0x246422 },
	{ 0x25d66, 0x256c78 },
	{ 0x25d67, 0x256c73 },
	{ 0x25d68, 0x246670 },
	{ 0x25d69, 0x274e6a },
	{ 0x25d6a, 0x256c6f },
	{ 0x25d6b, 0x256c75 },
	{ 0x25d6c, 0x256c71 },
	{ 0x25d6d, 0x274e69 },
	{ 0x25d6e, 0x274e75 },
	{ 0x25d6f, 0x256c77 },
	{ 0x25d70, 0x274e6d },
	{ 0x25d71, 0x274e6e },
	{ 0x25d72, 0x256c72 },
	{ 0x25d73, 0x274e6f },
	{ 0x25d74, 0x275438 },
	{ 0x25d75, 0x274e71 },
	{ 0x25d76, 0x274e70 },
	{ 0x25d78, 0x274e72 },
	{ 0x25d79, 0x274e73 },
	{ 0x25d7a, 0x2f6568 },
	{ 0x25d7b, 0x2f6569 },
	{ 0x25d7d, 0x274e6b },
	{ 0x25d86, 0x257064 },
	{ 0x25d87, 0x257068 },
	{ 0x25d88, 0x257069 },
	{ 0x25d8a, 0x246671 },
	{ 0x25d8b, 0x24666b },
	{ 0x25d8c, 0x257066 },
	{ 0x25d8d, 0x25706b },
	{ 0x25d8e, 0x27542f },
	{ 0x25d8f, 0x25705e },
	{ 0x25d90, 0x257063 },
	{ 0x25d91, 0x257060 },
	{ 0x25d92, 0x246421 },
	{ 0x25d93, 0x257067 },
	{ 0x25d94, 0x25705f },
	{ 0x25d95, 0x256c70 },
	{ 0x25d96, 0x275435 },
	{ 0x25d97, 0x25706a },
	{ 0x25d98, 0x25705d },
	{ 0x25d99, 0x275431 },
	{ 0x25d9a, 0x257065 },
	{ 0x25d9b, 0x246927 },
	{ 0x25d9c, 0x25706c },
	{ 0x25d9d, 0x275436 },
	{ 0x25d9e, 0x275430 },
	{ 0x25d9f, 0x275434 },
	{ 0x25da3, 0x2f6823 },
	{ 0x25da4, 0x2f6824 },
	{ 0x25da5, 0x2f6825 },
	{ 0x25da6, 0x2f6826 },
	{ 0x25da7, 0x2f6827 },
	{ 0x25da8, 0x2f6828 },
	{ 0x25da9, 0x2f6829 },
	{ 0x25daa, 0x275433 },
	{ 0x25dab, 0x275439 },
	{ 0x25db4, 0x275432 },
	{ 0x25db5, 0x275855 },
	{ 0x25db6, 0x246924 },
	{ 0x25db7, 0x246923 },
	{ 0x25db8, 0x257370 },
	{ 0x25db9, 0x25736e },
	{ 0x25dba, 0x257062 },
	{ 0x25dbb, 0x257371 },
	{ 0x25dbc, 0x275852 },
	{ 0x25dbd, 0x25706d },
	{ 0x25dbe, 0x275851 },
	{ 0x25dbf, 0x257374 },
	{ 0x25dc0, 0x246925 },
	{ 0x25dc1, 0x25736d },
	{ 0x25dc2, 0x275854 },
	{ 0x25dc3, 0x275437 },
	{ 0x25dc4, 0x257376 },
	{ 0x25dc5, 0x257373 },
	{ 0x25dc6, 0x25736f },
	{ 0x25dc7, 0x257375 },
	{ 0x25dc8, 0x257372 },
	{ 0x25dc9, 0x275856 },
	{ 0x25dcc, 0x2f695f },
	{ 0x25dcd, 0x2f6960 },
	{ 0x25dce, 0x2f6961 },
	{ 0x25dcf, 0x2f6962 },
	{ 0x25dd0, 0x275853 },
	{ 0x25dd1, 0x275934 },
	{ 0x25dd4, 0x246a5e },
	{ 0x25dd5, 0x257633 },
	{ 0x25dd6, 0x275c31 },
	{ 0x25dd7, 0x257634 },
	{ 0x25dd8, 0x246a5f },
	{ 0x25dd9, 0x246a60 },
	{ 0x25dda, 0x246a62 },
	{ 0x25ddb, 0x275c30 },
	{ 0x25ddc, 0x257636 },
	{ 0x25ddd, 0x275c32 },
	{ 0x25dde, 0x257635 },
	{ 0x25ddf, 0x275c36 },
	{ 0x25de0, 0x275c35 },
	{ 0x25de1, 0x2f6a69 },
	{ 0x25de2, 0x275c33 },
	{ 0x25de3, 0x275c37 },
	{ 0x25de4, 0x275c34 },
	{ 0x25de8, 0x257772 },
	{ 0x25de9, 0x275f2b },
	{ 0x25dea, 0x275f2e },
	{ 0x25deb, 0x257774 },
	{ 0x25dec, 0x257775 },
	{ 0x25ded, 0x275f2d },
	{ 0x25dee, 0x257637 },
	{ 0x25def, 0x275f2c },
	{ 0x25df0, 0x275f2a },
	{ 0x25df1, 0x257773 },
	{ 0x25df2, 0x275f31 },
	{ 0x25df4, 0x246b77 },
	{ 0x25df5, 0x2f6b5a },
	{ 0x25df6, 0x2f6b5b },
	{ 0x25df7, 0x2f6b5c },
	{ 0x25df8, 0x275f2f },
	{ 0x25dfc, 0x257935 },
	{ 0x25dfd, 0x27612c },
	{ 0x25dfe, 0x27612e },
	{ 0x25dff, 0x276131 },
	{ 0x25e00, 0x246c79 },
	{ 0x25e03, 0x27612f },
	{ 0x25e05, 0x275f30 },
	{ 0x25e07, 0x27612d },
	{ 0x25e08, 0x257a31 },
	{ 0x25e09, 0x257a2f },
	{ 0x25e0a, 0x257a30 },
	{ 0x25e0b, 0x276130 },
	{ 0x25e0e, 0x2f6c4f },
	{ 0x25e0f, 0x2f6c4d },
	{ 0x25e10, 0x27635e },
	{ 0x25e11, 0x27635f },
	{ 0x25e14, 0x2f6c68 },
	{ 0x25e16, 0x276360 },
	{ 0x25e17, 0x257b44 },
	{ 0x25e18, 0x257b64 },
	{ 0x25e19, 0x2f6d27 },
	{ 0x25e1c, 0x276454 },
	{ 0x25e21, 0x246e4e },
	{ 0x25e22, 0x257b7c },
	{ 0x25e23, 0x257c2b },
	{ 0x25e25, 0x252471 },
	{ 0x25e26, 0x2f2527 },
	{ 0x25e27, 0x25274e },
	{ 0x25e28, 0x262d51 },
	{ 0x25e29, 0x2f2845 },
	{ 0x25e2b, 0x263361 },
	{ 0x25e2c, 0x252b22 },
	{ 0x25e2d, 0x263360 },
	{ 0x25e2f, 0x252b23 },
	{ 0x25e30, 0x2f2c7e },
	{ 0x25e31, 0x2f2d22 },
	{ 0x25e33, 0x263a52 },
	{ 0x25e34, 0x252f54 },
	{ 0x25e35, 0x263a56 },
	{ 0x25e36, 0x252f55 },
	{ 0x25e37, 0x263a54 },
	{ 0x25e38, 0x252f56 },
	{ 0x25e39, 0x2f316b },
	{ 0x25e3a, 0x2f316c },
	{ 0x25e3b, 0x2f316d },
	{ 0x25e3c, 0x2f316e },
	{ 0x25e3d, 0x263a53 },
	{ 0x25e3e, 0x263a55 },
	{ 0x25e41, 0x24337e },
	{ 0x25e42, 0x253455 },
	{ 0x25e43, 0x243424 },
	{ 0x25e45, 0x253454 },
	{ 0x25e46, 0x243421 },
	{ 0x25e47, 0x253458 },
	{ 0x25e48, 0x253453 },
	{ 0x25e49, 0x253456 },
	{ 0x25e4a, 0x253457 },
	{ 0x25e4b, 0x243423 },
	{ 0x25e4c, 0x25345a },
	{ 0x25e4d, 0x253452 },
	{ 0x25e4e, 0x26427d },
	{ 0x25e4f, 0x264c63 },
	{ 0x25e50, 0x264321 },
	{ 0x25e51, 0x2f3750 },
	{ 0x25e52, 0x2f3751 },
	{ 0x25e55, 0x26427e },
	{ 0x25e56, 0x2f3752 },
	{ 0x25e5a, 0x253b26 },
	{ 0x25e5c, 0x24397a },
	{ 0x25e5d, 0x264c61 },
	{ 0x25e5e, 0x264c5e },
	{ 0x25e5f, 0x264c65 },
	{ 0x25e60, 0x253b28 },
	{ 0x25e61, 0x243a21 },
	{ 0x25e62, 0x264c64 },
	{ 0x25e64, 0x264c5f },
	{ 0x25e66, 0x2f3d7c },
	{ 0x25e67, 0x2f3d7e },
	{ 0x25e68, 0x2f3e22 },
	{ 0x25e6b, 0x2f3d7b },
	{ 0x25e6d, 0x264c62 },
	{ 0x25e72, 0x254157 },
	{ 0x25e73, 0x243f68 },
	{ 0x25e74, 0x26563d },
	{ 0x25e75, 0x254159 },
	{ 0x25e76, 0x25415a },
	{ 0x25e77, 0x253b27 },
	{ 0x25e78, 0x254158 },
	{ 0x25e79, 0x26563f },
	{ 0x25e7a, 0x26563e },
	{ 0x25e7b, 0x24397e },
	{ 0x25e7c, 0x25415b },
	{ 0x25e7d, 0x25415d },
	{ 0x25e7e, 0x25415c },
	{ 0x25e7f, 0x265641 },
	{ 0x25e84, 0x2f4452 },
	{ 0x25e85, 0x2f4453 },
	{ 0x25e86, 0x2f4455 },
	{ 0x25e87, 0x2f4456 },
	{ 0x25e88, 0x26563b },
	{ 0x25e89, 0x2f4454 },
	{ 0x25e8b, 0x265640 },
	{ 0x25e97, 0x2f4451 },
	{ 0x25e98, 0x26602d },
	{ 0x25e99, 0x25484a },
	{ 0x25e9a, 0x26602b },
	{ 0x25e9b, 0x26602e },
	{ 0x25e9c, 0x25484c },
	{ 0x25e9d, 0x244573 },
	{ 0x25e9e, 0x26563c },
	{ 0x25e9f, 0x266033 },
	{ 0x25ea0, 0x266032 },
	{ 0x25ea1, 0x25484b },
	{ 0x25ea2, 0x266030 },
	{ 0x25ea3, 0x254849 },
	{ 0x25ea4, 0x25484d },
	{ 0x25ea7, 0x2f4a7c },
	{ 0x25ea8, 0x2f4a7d },
	{ 0x25ea9, 0x2f4a7e },
	{ 0x25eaa, 0x2f4b21 },
	{ 0x25eab, 0x2f4b22 },
	{ 0x25eac, 0x2f4b23 },
	{ 0x25ead, 0x2f4b25 },
	{ 0x25eae, 0x2f4b26 },
	{ 0x25eaf, 0x2f4b28 },
	{ 0x25eb0, 0x2f4b29 },
	{ 0x25eb1, 0x2f4b2a },
	{ 0x25eb2, 0x2f4b2d },
	{ 0x25eb3, 0x26602f },
	{ 0x25eb4, 0x2f4b2c },
	{ 0x25eb6, 0x266029 },
	{ 0x25eb8, 0x26602a },
	{ 0x25ebc, 0x2f4b24 },
	{ 0x25ec1, 0x272658 },
	{ 0x25ec2, 0x272654 },
	{ 0x25ec3, 0x244c36 },
	{ 0x25ec4, 0x254f4b },
	{ 0x25ec5, 0x272655 },
	{ 0x25ec6, 0x272659 },
	{ 0x25ec7, 0x244c33 },
	{ 0x25ec8, 0x254f4a },
	{ 0x25ec9, 0x254f4c },
	{ 0x25eca, 0x254f50 },
	{ 0x25ecb, 0x25484e },
	{ 0x25ecc, 0x254f4f },
	{ 0x25ecd, 0x254f4d },
	{ 0x25ece, 0x27265b },
	{ 0x25ecf, 0x272656 },
	{ 0x25ed0, 0x254f49 },
	{ 0x25ed1, 0x244c34 },
	{ 0x25ed2, 0x254f4e },
	{ 0x25ed3, 0x244c32 },
	{ 0x25ed4, 0x27265a },
	{ 0x25ed5, 0x254f48 },
	{ 0x25ed6, 0x254f47 },
	{ 0x25ed9, 0x2f512b },
	{ 0x25eda, 0x2f512c },
	{ 0x25edb, 0x2f512d },
	{ 0x25edc, 0x2f512f },
	{ 0x25ee4, 0x25566e },
	{ 0x25ee5, 0x25566c },
	{ 0x25ee6, 0x255d3c },
	{ 0x25ee7, 0x245243 },
	{ 0x25ee8, 0x25566b },
	{ 0x25ee9, 0x245242 },
	{ 0x25eea, 0x27312f },
	{ 0x25eeb, 0x273130 },
	{ 0x25eec, 0x25566f },
	{ 0x25eed, 0x27312c },
	{ 0x25eee, 0x25566a },
	{ 0x25eef, 0x25566d },
	{ 0x25ef0, 0x255670 },
	{ 0x25ef1, 0x2f5674 },
	{ 0x25ef2, 0x2f5675 },
	{ 0x25ef3, 0x27312e },
	{ 0x25eff, 0x255d36 },
	{ 0x25f00, 0x255d38 },
	{ 0x25f01, 0x273a30 },
	{ 0x25f02, 0x255d39 },
	{ 0x25f03, 0x255d37 },
	{ 0x25f04, 0x255d3a },
	{ 0x25f05, 0x255d3b },
	{ 0x25f06, 0x273a32 },
	{ 0x25f07, 0x273a34 },
	{ 0x25f08, 0x273a35 },
	{ 0x25f09, 0x273a31 },
	{ 0x25f0c, 0x2f5b6b },
	{ 0x25f0d, 0x2f5b6c },
	{ 0x25f0e, 0x2f5b6d },
	{ 0x25f0f, 0x2f5b6f },
	{ 0x25f10, 0x2f5b70 },
	{ 0x25f11, 0x2f5b71 },
	{ 0x25f12, 0x2f5b72 },
	{ 0x25f13, 0x24576c },
	{ 0x25f18, 0x256352 },
	{ 0x25f19, 0x274145 },
	{ 0x25f1a, 0x245c57 },
	{ 0x25f1b, 0x256353 },
	{ 0x25f1c, 0x25634f },
	{ 0x25f1d, 0x274856 },
	{ 0x25f1e, 0x256351 },
	{ 0x25f1f, 0x255d3d },
	{ 0x25f20, 0x274146 },
	{ 0x25f21, 0x256350 },
	{ 0x25f22, 0x274e78 },
	{ 0x25f24, 0x25634d },
	{ 0x25f25, 0x274143 },
	{ 0x25f26, 0x2f6027 },
	{ 0x25f27, 0x2f6028 },
	{ 0x25f28, 0x2f6029 },
	{ 0x25f35, 0x2f5b6e },
	{ 0x25f36, 0x256874 },
	{ 0x25f37, 0x27484f },
	{ 0x25f38, 0x274850 },
	{ 0x25f39, 0x24605e },
	{ 0x25f3a, 0x24605c },
	{ 0x25f3b, 0x256873 },
	{ 0x25f3c, 0x25706e },
	{ 0x25f3d, 0x274852 },
	{ 0x25f3e, 0x274853 },
	{ 0x25f3f, 0x274148 },
	{ 0x25f40, 0x24605f },
	{ 0x25f41, 0x245c58 },
	{ 0x25f42, 0x256875 },
	{ 0x25f43, 0x274147 },
	{ 0x25f45, 0x256872 },
	{ 0x25f46, 0x2f633e },
	{ 0x25f47, 0x274851 },
	{ 0x25f49, 0x274854 },
	{ 0x25f4a, 0x274855 },
	{ 0x25f4b, 0x2f633f },
	{ 0x25f4f, 0x274e77 },
	{ 0x25f50, 0x256c7e },
	{ 0x25f51, 0x274e76 },
	{ 0x25f55, 0x2f656a },
	{ 0x25f56, 0x2f656b },
	{ 0x25f57, 0x246673 },
	{ 0x25f58, 0x246672 },
	{ 0x25f59, 0x25706f },
	{ 0x25f5a, 0x27543d },
	{ 0x25f5b, 0x27543c },
	{ 0x25f5d, 0x2f682a },
	{ 0x25f5e, 0x2f682b },
	{ 0x25f63, 0x27543b },
	{ 0x25f65, 0x257377 },
	{ 0x25f66, 0x275857 },
	{ 0x25f67, 0x257378 },
	{ 0x25f6c, 0x246a63 },
	{ 0x25f6d, 0x246a64 },
	{ 0x25f6e, 0x275c38 },
	{ 0x25f6f, 0x2f6a6a },
	{ 0x25f70, 0x257638 },
	{ 0x25f71, 0x275c39 },
	{ 0x25f72, 0x275f32 },
	{ 0x25f73, 0x257777 },
	{ 0x25f74, 0x257776 },
	{ 0x25f76, 0x257938 },
	{ 0x25f77, 0x276133 },
	{ 0x25f78, 0x257937 },
	{ 0x25f79, 0x257936 },
	{ 0x25f7a, 0x276132 },
	{ 0x25f7b, 0x27624c },
	{ 0x25f7c, 0x246d5d },
	{ 0x25f7d, 0x257a32 },
	{ 0x25f7e, 0x27624b },
	{ 0x25f7f, 0x257a33 },
	{ 0x25f80, 0x276362 },
	{ 0x25f81, 0x276361 },
	{ 0x25f82, 0x257b7d },
	{ 0x25f84, 0x276636 },
	{ 0x25f85, 0x25274f },
	{ 0x25f86, 0x262d52 },
	{ 0x25f87, 0x252750 },
	{ 0x25f88, 0x2f2847 },
	{ 0x25f89, 0x2f2848 },
	{ 0x25f8a, 0x252751 },
	{ 0x25f8c, 0x252b26 },
	{ 0x25f8d, 0x263362 },
	{ 0x25f8e, 0x263365 },
	{ 0x25f8f, 0x252b24 },
	{ 0x25f90, 0x252b25 },
	{ 0x25f91, 0x263367 },
	{ 0x25f92, 0x263363 },
	{ 0x25f93, 0x252b27 },
	{ 0x25f94, 0x2f2d23 },
	{ 0x25f96, 0x263368 },
	{ 0x25f99, 0x263a5b },
	{ 0x25f9a, 0x263a57 },
	{ 0x25f9b, 0x242e79 },
	{ 0x25f9c, 0x263a63 },
	{ 0x25f9d, 0x242e7b },
	{ 0x25f9e, 0x263a5d },
	{ 0x25fa0, 0x263a5c },
	{ 0x25fa1, 0x263a5f },
	{ 0x25fa2, 0x252f5a },
	{ 0x25fa3, 0x242e7a },
	{ 0x25fa4, 0x242f24 },
	{ 0x25fa5, 0x263a64 },
	{ 0x25fa6, 0x263a59 },
	{ 0x25fa7, 0x242f23 },
	{ 0x25fa8, 0x263a5e },
	{ 0x25fa9, 0x242f22 },
	{ 0x25faa, 0x263a60 },
	{ 0x25fab, 0x263a58 },
	{ 0x25fac, 0x252f59 },
	{ 0x25fad, 0x263a61 },
	{ 0x25fae, 0x252f58 },
	{ 0x25faf, 0x252f57 },
	{ 0x25fb0, 0x263a5a },
	{ 0x25fb2, 0x2f3171 },
	{ 0x25fb3, 0x2f3172 },
	{ 0x25fb4, 0x2f3173 },
	{ 0x25fb5, 0x2f3174 },
	{ 0x25fb6, 0x2f3175 },
	{ 0x25fb7, 0x2f3176 },
	{ 0x25fb8, 0x2f3177 },
	{ 0x25fba, 0x242f26 },
	{ 0x25fbb, 0x263a62 },
	{ 0x25fc3, 0x25345f },
	{ 0x25fc4, 0x25345d },
	{ 0x25fc5, 0x243432 },
	{ 0x25fc6, 0x243428 },
	{ 0x25fc7, 0x24342a },
	{ 0x25fc8, 0x264328 },
	{ 0x25fc9, 0x24342f },
	{ 0x25fca, 0x25345e },
	{ 0x25fcb, 0x243431 },
	{ 0x25fcc, 0x264329 },
	{ 0x25fcd, 0x25345b },
	{ 0x25fce, 0x24342c },
	{ 0x25fcf, 0x26432b },
	{ 0x25fd0, 0x26432a },
	{ 0x25fd1, 0x264325 },
	{ 0x25fd2, 0x264323 },
	{ 0x25fd3, 0x264324 },
	{ 0x25fd5, 0x25345c },
	{ 0x25fd6, 0x2f3758 },
	{ 0x25fd7, 0x2f3759 },
	{ 0x25fd8, 0x2f375a },
	{ 0x25fd9, 0x2f375b },
	{ 0x25fdc, 0x264327 },
	{ 0x25fdf, 0x26432c },
	{ 0x25fe1, 0x2f3755 },
	{ 0x25fe6, 0x253b31 },
	{ 0x25fe7, 0x253b30 },
	{ 0x25fe8, 0x253b2e },
	{ 0x25fe9, 0x253b32 },
	{ 0x25fea, 0x264c6d },
	{ 0x25feb, 0x243a23 },
	{ 0x25fec, 0x264c66 },
	{ 0x25fed, 0x264c6c },
	{ 0x25fee, 0x243a22 },
	{ 0x25fef, 0x243a24 },
	{ 0x25ff0, 0x264c6e },
	{ 0x25ff1, 0x264326 },
	{ 0x25ff2, 0x264c67 },
	{ 0x25ff3, 0x264c70 },
	{ 0x25ff4, 0x264c68 },
	{ 0x25ff5, 0x253b2d },
	{ 0x25ff6, 0x264c6a },
	{ 0x25ff7, 0x264c69 },
	{ 0x25ff8, 0x264c6f },
	{ 0x25ff9, 0x253b2a },
	{ 0x25ffa, 0x253b29 },
	{ 0x25ffc, 0x253b2b },
	{ 0x25ffd, 0x2f3e25 },
	{ 0x25ffe, 0x2f3e26 },
	{ 0x25fff, 0x2f3e27 },
	{ 0x26000, 0x2f3e28 },
	{ 0x26001, 0x2f3e29 },
	{ 0x26002, 0x2f3e2a },
	{ 0x26003, 0x2f3e2b },
	{ 0x26004, 0x2f3e2c },
	{ 0x26005, 0x2f3e2d },
	{ 0x26006, 0x2f3e2e },
	{ 0x26007, 0x264c6b },
	{ 0x26009, 0x253b2f },
	{ 0x26012, 0x26564b },
	{ 0x26013, 0x265642 },
	{ 0x26014, 0x25415f },
	{ 0x26015, 0x25415e },
	{ 0x26016, 0x243f6c },
	{ 0x26017, 0x265644 },
	{ 0x26018, 0x243f6d },
	{ 0x26019, 0x265648 },
	{ 0x2601a, 0x265645 },
	{ 0x2601b, 0x243f69 },
	{ 0x2601c, 0x254161 },
	{ 0x2601d, 0x254160 },
	{ 0x2601e, 0x265643 },
	{ 0x2601f, 0x265649 },
	{ 0x26020, 0x243a25 },
	{ 0x26021, 0x243f6b },
	{ 0x26022, 0x265646 },
	{ 0x26023, 0x254162 },
	{ 0x26024, 0x26564c },
	{ 0x26025, 0x26564d },
	{ 0x26026, 0x243f72 },
	{ 0x26027, 0x26564a },
	{ 0x2602c, 0x2f4457 },
	{ 0x2602d, 0x2f4458 },
	{ 0x2602e, 0x2f4459 },
	{ 0x2602f, 0x2f445a },
	{ 0x26030, 0x2f445b },
	{ 0x26031, 0x2f445c },
	{ 0x26032, 0x2f445d },
	{ 0x26033, 0x2f445e },
	{ 0x26034, 0x2f445f },
	{ 0x26035, 0x2f4460 },
	{ 0x26036, 0x2f4461 },
	{ 0x26037, 0x2f4462 },
	{ 0x26043, 0x265647 },
	{ 0x26044, 0x243f70 },
	{ 0x26046, 0x244578 },
	{ 0x26048, 0x254850 },
	{ 0x26049, 0x244576 },
	{ 0x2604a, 0x254852 },
	{ 0x2604b, 0x26603f },
	{ 0x2604c, 0x26603e },
	{ 0x2604d, 0x254856 },
	{ 0x2604e, 0x24457a },
	{ 0x2604f, 0x254855 },
	{ 0x26050, 0x244577 },
	{ 0x26051, 0x266039 },
	{ 0x26052, 0x266043 },
	{ 0x26053, 0x266042 },
	{ 0x26054, 0x266036 },
	{ 0x26055, 0x24457d },
	{ 0x26056, 0x25484f },
	{ 0x26057, 0x254163 },
	{ 0x26058, 0x266041 },
	{ 0x26059, 0x254851 },
	{ 0x2605a, 0x26603c },
	{ 0x2605b, 0x266034 },
	{ 0x2605c, 0x254853 },
	{ 0x2605d, 0x254857 },
	{ 0x2605e, 0x266040 },
	{ 0x26061, 0x26603b },
	{ 0x26064, 0x244622 },
	{ 0x26065, 0x266038 },
	{ 0x26066, 0x2f4b2e },
	{ 0x26067, 0x2f4b2f },
	{ 0x26068, 0x2f4b30 },
	{ 0x26069, 0x2f4b31 },
	{ 0x2606a, 0x2f4b32 },
	{ 0x2606b, 0x2f4b33 },
	{ 0x2606c, 0x2f4b34 },
	{ 0x2606d, 0x2f4b35 },
	{ 0x2606e, 0x2f4b36 },
	{ 0x2606f, 0x2f4b37 },
	{ 0x26070, 0x266035 },
	{ 0x26071, 0x266037 },
	{ 0x26074, 0x26603d },
	{ 0x26080, 0x244c38 },
	{ 0x26081, 0x244c43 },
	{ 0x26082, 0x272660 },
	{ 0x26083, 0x244c42 },
	{ 0x26084, 0x244c3b },
	{ 0x26085, 0x254f5b },
	{ 0x26086, 0x254f59 },
	{ 0x26087, 0x245248 },
	{ 0x26088, 0x254f58 },
	{ 0x26089, 0x254f5d },
	{ 0x2608b, 0x254f55 },
	{ 0x2608c, 0x244c46 },
	{ 0x2608d, 0x254f5a },
	{ 0x2608e, 0x27266c },
	{ 0x2608f, 0x27265e },
	{ 0x26090, 0x272664 },
	{ 0x26091, 0x254f5c },
	{ 0x26092, 0x254f52 },
	{ 0x26093, 0x272661 },
	{ 0x26094, 0x272666 },
	{ 0x26095, 0x254f57 },
	{ 0x26097, 0x244c41 },
	{ 0x26098, 0x244c39 },
	{ 0x26099, 0x27265d },
	{ 0x2609a, 0x272665 },
	{ 0x2609b, 0x27265c },
	{ 0x2609c, 0x272667 },
	{ 0x2609d, 0x26603a },
	{ 0x2609e, 0x27266d },
	{ 0x2609f, 0x27266b },
	{ 0x260a0, 0x254f51 },
	{ 0x260a1, 0x254f56 },
	{ 0x260a2, 0x254f5e },
	{ 0x260a6, 0x2f5130 },
	{ 0x260a7, 0x2f5131 },
	{ 0x260a8, 0x2f5132 },
	{ 0x260a9, 0x2f5133 },
	{ 0x260aa, 0x2f5134 },
	{ 0x260ab, 0x2f5135 },
	{ 0x260ac, 0x2f5138 },
	{ 0x260ad, 0x2f5139 },
	{ 0x260ae, 0x2f513a },
	{ 0x260af, 0x2f513d },
	{ 0x260b0, 0x2f513e },
	{ 0x260b1, 0x2f513f },
	{ 0x260b4, 0x272662 },
	{ 0x260b5, 0x272668 },
	{ 0x260b7, 0x27265f },
	{ 0x260c1, 0x272663 },
	{ 0x260c3, 0x273146 },
	{ 0x260c4, 0x245246 },
	{ 0x260c5, 0x273143 },
	{ 0x260c6, 0x273144 },
	{ 0x260c7, 0x24524a },
	{ 0x260c8, 0x273140 },
	{ 0x260c9, 0x27313d },
	{ 0x260ca, 0x255674 },
	{ 0x260cb, 0x255676 },
	{ 0x260cc, 0x273131 },
	{ 0x260cd, 0x273142 },
	{ 0x260ce, 0x273132 },
	{ 0x260cf, 0x273a36 },
	{ 0x260d0, 0x273133 },
	{ 0x260d1, 0x273136 },
	{ 0x260d2, 0x255675 },
	{ 0x260d3, 0x255677 },
	{ 0x260d4, 0x255673 },
	{ 0x260d5, 0x255d45 },
	{ 0x260d6, 0x245245 },
	{ 0x260d7, 0x255671 },
	{ 0x260d8, 0x255672 },
	{ 0x260d9, 0x24524b },
	{ 0x260db, 0x27313a },
	{ 0x260dc, 0x273137 },
	{ 0x260dd, 0x273138 },
	{ 0x260de, 0x273141 },
	{ 0x260df, 0x24524d },
	{ 0x260e0, 0x273135 },
	{ 0x260e2, 0x255679 },
	{ 0x260e3, 0x273134 },
	{ 0x260e4, 0x273145 },
	{ 0x260e5, 0x27313b },
	{ 0x260e6, 0x255678 },
	{ 0x260e7, 0x27313f },
	{ 0x260e8, 0x27313e },
	{ 0x260f0, 0x273139 },
	{ 0x260f1, 0x27313c },
	{ 0x260f2, 0x2f5676 },
	{ 0x260f3, 0x2f5677 },
	{ 0x260f4, 0x2f5678 },
	{ 0x260f5, 0x2f5679 },
	{ 0x260f6, 0x2f567a },
	{ 0x260f7, 0x2f567b },
	{ 0x260f8, 0x2f567c },
	{ 0x260f9, 0x2f567d },
	{ 0x260fa, 0x2f567e },
	{ 0x26109, 0x273a44 },
	{ 0x2610a, 0x273a43 },
	{ 0x2610b, 0x255d43 },
	{ 0x2610c, 0x255d40 },
	{ 0x2610d, 0x245771 },
	{ 0x2610e, 0x273a37 },
	{ 0x2610f, 0x255d41 },
	{ 0x26110, 0x273a42 },
	{ 0x26111, 0x24576f },
	{ 0x26112, 0x273a3a },
	{ 0x26113, 0x255d44 },
	{ 0x26114, 0x255d3e },
	{ 0x26115, 0x273a3e },
	{ 0x26116, 0x273a3b },
	{ 0x26117, 0x273a3c },
	{ 0x26118, 0x273a40 },
	{ 0x26119, 0x255d42 },
	{ 0x2611a, 0x273a41 },
	{ 0x2611b, 0x273a3d },
	{ 0x2611c, 0x255d47 },
	{ 0x26122, 0x2f5b73 },
	{ 0x26123, 0x2f5b74 },
	{ 0x26124, 0x2f5b75 },
	{ 0x26125, 0x2f5b77 },
	{ 0x26126, 0x2f5b78 },
	{ 0x26127, 0x2f5b79 },
	{ 0x26128, 0x2f5b7a },
	{ 0x26129, 0x2f5b7b },
	{ 0x2612a, 0x2f5b7c },
	{ 0x2612b, 0x2f5b7d },
	{ 0x2612c, 0x2f5b7e },
	{ 0x2612d, 0x2f5c21 },
	{ 0x2612e, 0x2f5c22 },
	{ 0x26131, 0x273a3f },
	{ 0x26132, 0x273a38 },
	{ 0x2613c, 0x245c64 },
	{ 0x2613d, 0x245c5c },
	{ 0x2613e, 0x27414e },
	{ 0x2613f, 0x245c63 },
	{ 0x26140, 0x245c5d },
	{ 0x26141, 0x27414d },
	{ 0x26142, 0x274154 },
	{ 0x26143, 0x245c61 },
	{ 0x26144, 0x245770 },
	{ 0x26145, 0x274149 },
	{ 0x26146, 0x256355 },
	{ 0x26147, 0x256358 },
	{ 0x26148, 0x256357 },
	{ 0x26149, 0x27414b },
	{ 0x2614a, 0x274151 },
	{ 0x2614b, 0x256356 },
	{ 0x2614c, 0x27414a },
	{ 0x2614d, 0x27414f },
	{ 0x2614e, 0x274152 },
	{ 0x2614f, 0x27414c },
	{ 0x26150, 0x274157 },
	{ 0x26151, 0x274155 },
	{ 0x26152, 0x274150 },
	{ 0x26153, 0x27415b },
	{ 0x26154, 0x25635a },
	{ 0x26155, 0x274156 },
	{ 0x2615d, 0x2f602a },
	{ 0x2615e, 0x2f602b },
	{ 0x2615f, 0x2f602c },
	{ 0x26160, 0x2f602d },
	{ 0x26161, 0x2f602e },
	{ 0x26162, 0x2f602f },
	{ 0x26163, 0x2f6030 },
	{ 0x26164, 0x2f6031 },
	{ 0x26165, 0x2f6032 },
	{ 0x26167, 0x256359 },
	{ 0x26168, 0x27415c },
	{ 0x2616a, 0x27415a },
	{ 0x2616c, 0x274158 },
	{ 0x26173, 0x274153 },
	{ 0x26175, 0x246064 },
	{ 0x26176, 0x246065 },
	{ 0x26177, 0x27485f },
	{ 0x26178, 0x246069 },
	{ 0x26179, 0x274867 },
	{ 0x2617a, 0x256876 },
	{ 0x2617b, 0x274864 },
	{ 0x2617c, 0x246067 },
	{ 0x2617d, 0x274866 },
	{ 0x2617e, 0x24606b },
	{ 0x2617f, 0x256879 },
	{ 0x26180, 0x246060 },
	{ 0x26181, 0x25687a },
	{ 0x26182, 0x274861 },
	{ 0x26183, 0x27474b },
	{ 0x26184, 0x246061 },
	{ 0x26185, 0x27485d },
	{ 0x26186, 0x256877 },
	{ 0x26188, 0x274863 },
	{ 0x26189, 0x27485b },
	{ 0x2618a, 0x274862 },
	{ 0x2618b, 0x256878 },
	{ 0x2618c, 0x274859 },
	{ 0x2618d, 0x27485a },
	{ 0x2618e, 0x274860 },
	{ 0x2618f, 0x27485e },
	{ 0x26190, 0x2f6340 },
	{ 0x26191, 0x2f6341 },
	{ 0x26192, 0x2f6343 },
	{ 0x26193, 0x2f6344 },
	{ 0x26194, 0x2f6345 },
	{ 0x26195, 0x274a73 },
	{ 0x26196, 0x27485c },
	{ 0x26197, 0x274865 },
	{ 0x2619b, 0x24606a },
	{ 0x2619c, 0x274e7d },
	{ 0x2619d, 0x274e7c },
	{ 0x2619e, 0x256d23 },
	{ 0x2619f, 0x256d21 },
	{ 0x261a0, 0x246425 },
	{ 0x261a1, 0x274e7e },
	{ 0x261a2, 0x274f23 },
	{ 0x261a3, 0x274e7b },
	{ 0x261a4, 0x275442 },
	{ 0x261a5, 0x274858 },
	{ 0x261a6, 0x256d24 },
	{ 0x261a7, 0x274f24 },
	{ 0x261a9, 0x274f26 },
	{ 0x261aa, 0x274e7a },
	{ 0x261ab, 0x246679 },
	{ 0x261ac, 0x274f22 },
	{ 0x261af, 0x274e79 },
	{ 0x261b0, 0x274f25 },
	{ 0x261b1, 0x2f656c },
	{ 0x261b2, 0x2f656d },
	{ 0x261b3, 0x2f656e },
	{ 0x261b4, 0x2f6570 },
	{ 0x261b5, 0x2f6571 },
	{ 0x261b6, 0x274f21 },
	{ 0x261bb, 0x257072 },
	{ 0x261bc, 0x246675 },
	{ 0x261bd, 0x275443 },
	{ 0x261be, 0x257073 },
	{ 0x261bf, 0x246678 },
	{ 0x261c0, 0x246676 },
	{ 0x261c1, 0x246677 },
	{ 0x261c2, 0x27585e },
	{ 0x261c3, 0x274f27 },
	{ 0x261c4, 0x27543f },
	{ 0x261c5, 0x27543e },
	{ 0x261c8, 0x275441 },
	{ 0x261c9, 0x2f682c },
	{ 0x261ca, 0x2f682d },
	{ 0x261cb, 0x2f682e },
	{ 0x261cc, 0x2f682f },
	{ 0x261ce, 0x246674 },
	{ 0x261cf, 0x275440 },
	{ 0x261d1, 0x257071 },
	{ 0x261d3, 0x275444 },
	{ 0x261d4, 0x25737b },
	{ 0x261d5, 0x275859 },
	{ 0x261d6, 0x25737c },
	{ 0x261d7, 0x257379 },
	{ 0x261d8, 0x246929 },
	{ 0x261d9, 0x25763a },
	{ 0x261da, 0x27585d },
	{ 0x261db, 0x25737a },
	{ 0x261dc, 0x27585b },
	{ 0x261de, 0x2f6963 },
	{ 0x261df, 0x2f6964 },
	{ 0x261e0, 0x2f6965 },
	{ 0x261e1, 0x2f6966 },
	{ 0x261e2, 0x27585a },
	{ 0x261e3, 0x27585c },
	{ 0x261e5, 0x24694b },
	{ 0x261e7, 0x246a67 },
	{ 0x261e8, 0x27585f },
	{ 0x261e9, 0x275c3a },
	{ 0x261ea, 0x275c3b },
	{ 0x261eb, 0x246a68 },
	{ 0x261ec, 0x246a69 },
	{ 0x261f0, 0x246b7a },
	{ 0x261f1, 0x257778 },
	{ 0x261f2, 0x275f37 },
	{ 0x261f3, 0x275f35 },
	{ 0x261f4, 0x2f6b5d },
	{ 0x261f6, 0x275f36 },
	{ 0x261f7, 0x275f38 },
	{ 0x261f8, 0x25793a },
	{ 0x261f9, 0x275f34 },
	{ 0x261fa, 0x257939 },
	{ 0x261fb, 0x276134 },
	{ 0x261fc, 0x27624f },
	{ 0x261fd, 0x27624e },
	{ 0x261fe, 0x276363 },
	{ 0x261ff, 0x2f6c69 },
	{ 0x26200, 0x276365 },
	{ 0x26201, 0x276364 },
	{ 0x26203, 0x276455 },
	{ 0x26205, 0x257b65 },
	{ 0x26206, 0x2f6d30 },
	{ 0x26207, 0x276575 },
	{ 0x26222, 0x262542 },
	{ 0x26223, 0x242a78 },
	{ 0x26225, 0x252b28 },
	{ 0x26226, 0x242f28 },
	{ 0x26227, 0x263a66 },
	{ 0x26228, 0x252f5b },
	{ 0x26229, 0x253461 },
	{ 0x2622b, 0x26432d },
	{ 0x2622c, 0x253b34 },
	{ 0x2622d, 0x26432f },
	{ 0x2622e, 0x26432e },
	{ 0x2622f, 0x264c74 },
	{ 0x26230, 0x243a29 },
	{ 0x26231, 0x264c73 },
	{ 0x26232, 0x253b33 },
	{ 0x26233, 0x2f3e2f },
	{ 0x26234, 0x265650 },
	{ 0x26235, 0x26564f },
	{ 0x26236, 0x243f74 },
	{ 0x26238, 0x244624 },
	{ 0x26239, 0x266045 },
	{ 0x2623a, 0x254858 },
	{ 0x2623b, 0x266044 },
	{ 0x2623c, 0x27266e },
	{ 0x2623e, 0x2f4b39 },
	{ 0x2623f, 0x2f4b3a },
	{ 0x26240, 0x2f4b3b },
	{ 0x26241, 0x272670 },
	{ 0x26242, 0x244c47 },
	{ 0x26244, 0x2f5140 },
	{ 0x26245, 0x2f5141 },
	{ 0x26247, 0x27266f },
	{ 0x26248, 0x25567b },
	{ 0x26249, 0x25567a },
	{ 0x2624b, 0x2f5722 },
	{ 0x2624c, 0x2f5721 },
	{ 0x2624e, 0x255d49 },
	{ 0x2624f, 0x273a45 },
	{ 0x26250, 0x255d48 },
	{ 0x26251, 0x2f5a58 },
	{ 0x26252, 0x2f5c23 },
	{ 0x26253, 0x2f5c24 },
	{ 0x26255, 0x27415d },
	{ 0x26256, 0x27415e },
	{ 0x26257, 0x2f6033 },
	{ 0x26259, 0x274868 },
	{ 0x2625a, 0x24606c },
	{ 0x2625b, 0x2f6346 },
	{ 0x2625d, 0x257074 },
	{ 0x2625e, 0x246427 },
	{ 0x2625f, 0x24667a },
	{ 0x26260, 0x275445 },
	{ 0x26262, 0x246a6a },
	{ 0x26263, 0x275c3c },
	{ 0x26264, 0x2f6a6b },
	{ 0x26265, 0x275f3a },
	{ 0x26266, 0x275f39 },
	{ 0x26267, 0x257a34 },
	{ 0x26269, 0x27662a },
	{ 0x2626a, 0x262229 },
	{ 0x2626b, 0x262228 },
	{ 0x2626c, 0x24246a },
	{ 0x2626d, 0x262544 },
	{ 0x2626e, 0x262545 },
	{ 0x2626f, 0x262873 },
	{ 0x26272, 0x2f217c },
	{ 0x26273, 0x262543 },
	{ 0x26274, 0x2f2528 },
	{ 0x26275, 0x2f252a },
	{ 0x26277, 0x262d53 },
	{ 0x26278, 0x26336a },
	{ 0x26279, 0x24275d },
	{ 0x2627b, 0x263369 },
	{ 0x2627c, 0x262d54 },
	{ 0x2627e, 0x24275e },
	{ 0x2627f, 0x262874 },
	{ 0x26280, 0x24246b },
	{ 0x26281, 0x26336b },
	{ 0x26282, 0x242a7a },
	{ 0x26283, 0x242a7c },
	{ 0x26287, 0x2f2556 },
	{ 0x26288, 0x252b29 },
	{ 0x26289, 0x2f2849 },
	{ 0x2628b, 0x252752 },
	{ 0x2628d, 0x263a67 },
	{ 0x2628e, 0x263a68 },
	{ 0x2628f, 0x263a69 },
	{ 0x26290, 0x252f5f },
	{ 0x26291, 0x263a6c },
	{ 0x26292, 0x263a6a },
	{ 0x26293, 0x242f2c },
	{ 0x26294, 0x242f2b },
	{ 0x26295, 0x26336e },
	{ 0x26296, 0x26336c },
	{ 0x26297, 0x26336f },
	{ 0x26298, 0x264335 },
	{ 0x26299, 0x2f2939 },
	{ 0x2629c, 0x252f5d },
	{ 0x2629d, 0x264330 },
	{ 0x2629e, 0x264331 },
	{ 0x2629f, 0x264332 },
	{ 0x262a0, 0x264334 },
	{ 0x262a1, 0x264336 },
	{ 0x262a2, 0x2f3179 },
	{ 0x262a3, 0x26336d },
	{ 0x262a4, 0x26367a },
	{ 0x262a7, 0x252b2a },
	{ 0x262a8, 0x242a7d },
	{ 0x262a9, 0x264333 },
	{ 0x262aa, 0x264c77 },
	{ 0x262ab, 0x264337 },
	{ 0x262ad, 0x263a6d },
	{ 0x262ae, 0x264c76 },
	{ 0x262af, 0x264338 },
	{ 0x262b3, 0x252f5e },
	{ 0x262b4, 0x253462 },
	{ 0x262b5, 0x2f375c },
	{ 0x262b6, 0x264c75 },
	{ 0x262bc, 0x253b36 },
	{ 0x262bd, 0x253b35 },
	{ 0x262be, 0x243a2c },
	{ 0x262bf, 0x264c78 },
	{ 0x262c2, 0x2f3e30 },
	{ 0x262c4, 0x265652 },
	{ 0x262c5, 0x254167 },
	{ 0x262c6, 0x265654 },
	{ 0x262c7, 0x264c7a },
	{ 0x262c8, 0x254164 },
	{ 0x262c9, 0x254166 },
	{ 0x262ca, 0x265653 },
	{ 0x262cb, 0x265655 },
	{ 0x262cc, 0x264c79 },
	{ 0x262cd, 0x265656 },
	{ 0x262d0, 0x2f3e31 },
	{ 0x262d1, 0x265651 },
	{ 0x262d2, 0x2f4463 },
	{ 0x262d6, 0x266046 },
	{ 0x262d7, 0x266048 },
	{ 0x262d8, 0x266049 },
	{ 0x262d9, 0x26604a },
	{ 0x262da, 0x26604b },
	{ 0x262db, 0x26604c },
	{ 0x262dc, 0x26604d },
	{ 0x262dd, 0x266050 },
	{ 0x262de, 0x25485b },
	{ 0x262df, 0x272675 },
	{ 0x262e0, 0x26604e },
	{ 0x262e1, 0x25485a },
	{ 0x262e2, 0x265657 },
	{ 0x262e3, 0x254859 },
	{ 0x262e4, 0x26604f },
	{ 0x262e7, 0x266047 },
	{ 0x262e8, 0x2f4b3c },
	{ 0x262eb, 0x272671 },
	{ 0x262ec, 0x272672 },
	{ 0x262ed, 0x272673 },
	{ 0x262ee, 0x272674 },
	{ 0x262ef, 0x254f62 },
	{ 0x262f0, 0x254f5f },
	{ 0x262f1, 0x266052 },
	{ 0x262f2, 0x272676 },
	{ 0x262f3, 0x254f60 },
	{ 0x262f4, 0x254f61 },
	{ 0x262f5, 0x266051 },
	{ 0x262f7, 0x2f5142 },
	{ 0x262f8, 0x2f5143 },
	{ 0x262f9, 0x272573 },
	{ 0x262fb, 0x273147 },
	{ 0x262fc, 0x273148 },
	{ 0x262fd, 0x27314c },
	{ 0x262fe, 0x273149 },
	{ 0x262ff, 0x25567c },
	{ 0x26300, 0x27314b },
	{ 0x26301, 0x245251 },
	{ 0x26302, 0x273a4e },
	{ 0x26303, 0x27314a },
	{ 0x26305, 0x27314d },
	{ 0x26306, 0x254f63 },
	{ 0x26309, 0x25567d },
	{ 0x2630a, 0x245250 },
	{ 0x2630d, 0x272677 },
	{ 0x2630e, 0x272678 },
	{ 0x2630f, 0x273a47 },
	{ 0x26310, 0x273a48 },
	{ 0x26311, 0x273a4b },
	{ 0x26312, 0x255d4a },
	{ 0x26313, 0x27314e },
	{ 0x26314, 0x245774 },
	{ 0x26315, 0x25635b },
	{ 0x26316, 0x273a4c },
	{ 0x26317, 0x273a4d },
	{ 0x26319, 0x2f5c25 },
	{ 0x2631b, 0x2f5723 },
	{ 0x2631c, 0x27415f },
	{ 0x2631d, 0x274160 },
	{ 0x2631e, 0x274162 },
	{ 0x2631f, 0x274164 },
	{ 0x26320, 0x245c67 },
	{ 0x26321, 0x245c66 },
	{ 0x26322, 0x25635c },
	{ 0x26323, 0x274163 },
	{ 0x26324, 0x274869 },
	{ 0x26328, 0x273a4a },
	{ 0x26329, 0x25635e },
	{ 0x2632a, 0x25687b },
	{ 0x2632b, 0x27486c },
	{ 0x2632c, 0x24606e },
	{ 0x2632d, 0x27486a },
	{ 0x2632e, 0x27486b },
	{ 0x26331, 0x274f28 },
	{ 0x26332, 0x274f29 },
	{ 0x26333, 0x274f2a },
	{ 0x26334, 0x274f2b },
	{ 0x26335, 0x256d25 },
	{ 0x26336, 0x256d27 },
	{ 0x26337, 0x274f2c },
	{ 0x26338, 0x256d26 },
	{ 0x2633a, 0x256d28 },
	{ 0x2633b, 0x275446 },
	{ 0x2633c, 0x274f2d },
	{ 0x2633e, 0x25777a },
	{ 0x2633f, 0x246b7c },
	{ 0x26340, 0x275f3b },
	{ 0x26341, 0x25777b },
	{ 0x26342, 0x257779 },
	{ 0x26343, 0x276135 },
	{ 0x26346, 0x276250 },
	{ 0x26347, 0x276366 },
	{ 0x26348, 0x276456 },
	{ 0x2634a, 0x27653c },
	{ 0x2634b, 0x24246c },
	{ 0x2634c, 0x24232c },
	{ 0x2634d, 0x2f2160 },
	{ 0x2634e, 0x262d56 },
	{ 0x2634f, 0x252753 },
	{ 0x26350, 0x262d55 },
	{ 0x26351, 0x2f2d24 },
	{ 0x26352, 0x263371 },
	{ 0x26354, 0x263370 },
	{ 0x26355, 0x242a7e },
	{ 0x26356, 0x2f284b },
	{ 0x26357, 0x263a6e },
	{ 0x26358, 0x263a6f },
	{ 0x2635a, 0x26433b },
	{ 0x2635b, 0x263a73 },
	{ 0x2635c, 0x263a72 },
	{ 0x2635d, 0x263a71 },
	{ 0x2635e, 0x263a70 },
	{ 0x2635f, 0x26433a },
	{ 0x26361, 0x2f317a },
	{ 0x26362, 0x2f317b },
	{ 0x26365, 0x26433d },
	{ 0x26366, 0x253464 },
	{ 0x26367, 0x243a2e },
	{ 0x26368, 0x26433e },
	{ 0x26369, 0x243439 },
	{ 0x2636a, 0x253465 },
	{ 0x2636c, 0x2f375d },
	{ 0x2636d, 0x253463 },
	{ 0x2636e, 0x264339 },
	{ 0x2636f, 0x2f375e },
	{ 0x26370, 0x2f375f },
	{ 0x26372, 0x26433f },
	{ 0x26379, 0x253b39 },
	{ 0x2637a, 0x253b37 },
	{ 0x2637b, 0x264c7d },
	{ 0x2637c, 0x243a2f },
	{ 0x2637d, 0x264d21 },
	{ 0x2637e, 0x253b38 },
	{ 0x2637f, 0x264c7e },
	{ 0x26380, 0x264c7c },
	{ 0x26383, 0x264d22 },
	{ 0x26385, 0x264721 },
	{ 0x26386, 0x26565a },
	{ 0x26387, 0x254168 },
	{ 0x26388, 0x26565b },
	{ 0x26389, 0x265658 },
	{ 0x2638a, 0x254169 },
	{ 0x2638b, 0x265659 },
	{ 0x2638d, 0x26565c },
	{ 0x26394, 0x25416a },
	{ 0x26395, 0x2f3e33 },
	{ 0x26396, 0x2f3e34 },
	{ 0x26397, 0x25485c },
	{ 0x26398, 0x266053 },
	{ 0x26399, 0x266055 },
	{ 0x2639a, 0x25485d },
	{ 0x2639d, 0x266054 },
	{ 0x263a2, 0x254f64 },
	{ 0x263a3, 0x244c4a },
	{ 0x263a4, 0x27267b },
	{ 0x263a5, 0x27267c },
	{ 0x263a6, 0x244c4b },
	{ 0x263a7, 0x27314f },
	{ 0x263a9, 0x27267a },
	{ 0x263ab, 0x244c48 },
	{ 0x263af, 0x255721 },
	{ 0x263b0, 0x25567e },
	{ 0x263b1, 0x245252 },
	{ 0x263b3, 0x2f5725 },
	{ 0x263b4, 0x273150 },
	{ 0x263b7, 0x245778 },
	{ 0x263b8, 0x245776 },
	{ 0x263b9, 0x255d4b },
	{ 0x263ba, 0x273a50 },
	{ 0x263bb, 0x273a4f },
	{ 0x263bc, 0x273a52 },
	{ 0x263bf, 0x2f5c26 },
	{ 0x263c1, 0x245254 },
	{ 0x263c3, 0x273a51 },
	{ 0x263c5, 0x25635d },
	{ 0x263c6, 0x245c69 },
	{ 0x263c7, 0x25635f },
	{ 0x263c8, 0x274169 },
	{ 0x263c9, 0x27416a },
	{ 0x263ca, 0x245c6d },
	{ 0x263cb, 0x274167 },
	{ 0x263cc, 0x274168 },
	{ 0x263cd, 0x274166 },
	{ 0x263ce, 0x2f5724 },
	{ 0x263cf, 0x2f6034 },
	{ 0x263d0, 0x2f6035 },
	{ 0x263d1, 0x245c6c },
	{ 0x263d5, 0x25687c },
	{ 0x263d6, 0x274870 },
	{ 0x263d7, 0x25763b },
	{ 0x263d8, 0x27486f },
	{ 0x263d9, 0x274f2e },
	{ 0x263da, 0x27486e },
	{ 0x263dc, 0x256d29 },
	{ 0x263dd, 0x274f2f },
	{ 0x263de, 0x274f30 },
	{ 0x263df, 0x274f31 },
	{ 0x263e0, 0x274f32 },
	{ 0x263e1, 0x274165 },
	{ 0x263e2, 0x257075 },
	{ 0x263e3, 0x275447 },
	{ 0x263e7, 0x275448 },
	{ 0x263e8, 0x25737d },
	{ 0x263e9, 0x275860 },
	{ 0x263ea, 0x275c3e },
	{ 0x263eb, 0x275c3d },
	{ 0x263ed, 0x276136 },
	{ 0x263ef, 0x276367 },
	{ 0x263f0, 0x27655e },
	{ 0x263f2, 0x262d57 },
	{ 0x263f4, 0x263375 },
	{ 0x263f5, 0x263372 },
	{ 0x263f6, 0x263376 },
	{ 0x263f7, 0x252b2b },
	{ 0x263f8, 0x242b22 },
	{ 0x263f9, 0x242b21 },
	{ 0x263fa, 0x242b24 },
	{ 0x263fb, 0x263374 },
	{ 0x263fc, 0x242b23 },
	{ 0x263fd, 0x2f2d25 },
	{ 0x263fe, 0x2f2d26 },
	{ 0x26400, 0x263373 },
	{ 0x26402, 0x242f33 },
	{ 0x26403, 0x263a76 },
	{ 0x26404, 0x252f61 },
	{ 0x26405, 0x252f63 },
	{ 0x26406, 0x252f60 },
	{ 0x26407, 0x242f31 },
	{ 0x26408, 0x242f36 },
	{ 0x26409, 0x242f35 },
	{ 0x2640a, 0x263a75 },
	{ 0x2640b, 0x252f62 },
	{ 0x2640c, 0x242f34 },
	{ 0x2640d, 0x242f32 },
	{ 0x2640e, 0x263a77 },
	{ 0x26410, 0x2f2f63 },
	{ 0x26411, 0x2f2f64 },
	{ 0x26413, 0x242f37 },
	{ 0x26414, 0x2f317c },
	{ 0x26415, 0x253466 },
	{ 0x26416, 0x264341 },
	{ 0x26417, 0x264340 },
	{ 0x26418, 0x264342 },
	{ 0x26419, 0x264343 },
	{ 0x2641a, 0x264344 },
	{ 0x2641b, 0x264346 },
	{ 0x2641c, 0x264347 },
	{ 0x2641e, 0x24343f },
	{ 0x26422, 0x264345 },
	{ 0x26423, 0x253b3b },
	{ 0x26424, 0x243a32 },
	{ 0x26425, 0x264d26 },
	{ 0x26426, 0x264d27 },
	{ 0x26427, 0x264d2d },
	{ 0x26428, 0x253b3d },
	{ 0x26429, 0x243a36 },
	{ 0x2642a, 0x264d2e },
	{ 0x2642c, 0x264d28 },
	{ 0x2642d, 0x264d25 },
	{ 0x2642e, 0x264d2f },
	{ 0x2642f, 0x264d30 },
	{ 0x26430, 0x253b3c },
	{ 0x26431, 0x264d2a },
	{ 0x26432, 0x264d2c },
	{ 0x26433, 0x264d2b },
	{ 0x26435, 0x2f3e35 },
	{ 0x26436, 0x2f3e36 },
	{ 0x26437, 0x264d29 },
	{ 0x26438, 0x25416e },
	{ 0x26439, 0x25416b },
	{ 0x2643a, 0x243f79 },
	{ 0x2643b, 0x26565d },
	{ 0x2643c, 0x26565e },
	{ 0x2643d, 0x26565f },
	{ 0x2643e, 0x25416d },
	{ 0x26440, 0x25416c },
	{ 0x26444, 0x2f4464 },
	{ 0x26446, 0x264d24 },
	{ 0x26447, 0x254865 },
	{ 0x26448, 0x25485e },
	{ 0x26449, 0x266057 },
	{ 0x2644a, 0x25485f },
	{ 0x2644b, 0x254863 },
	{ 0x2644c, 0x254860 },
	{ 0x2644d, 0x254864 },
	{ 0x2644e, 0x254861 },
	{ 0x2644f, 0x254862 },
	{ 0x26450, 0x266056 },
	{ 0x26451, 0x254866 },
	{ 0x26452, 0x2f4b3d },
	{ 0x26453, 0x2f4b3e },
	{ 0x26454, 0x2f4b3f },
	{ 0x26455, 0x2f4b40 },
	{ 0x26458, 0x254f6a },
	{ 0x26459, 0x254f6b },
	{ 0x2645a, 0x27267e },
	{ 0x2645b, 0x254f68 },
	{ 0x2645c, 0x244c4c },
	{ 0x2645d, 0x254f6c },
	{ 0x2645e, 0x254f65 },
	{ 0x2645f, 0x27267d },
	{ 0x26460, 0x254f67 },
	{ 0x26461, 0x2f5146 },
	{ 0x26462, 0x266059 },
	{ 0x26463, 0x254f66 },
	{ 0x26464, 0x272724 },
	{ 0x26465, 0x272725 },
	{ 0x26466, 0x272721 },
	{ 0x26467, 0x244c4e },
	{ 0x26468, 0x272722 },
	{ 0x26469, 0x244c4d },
	{ 0x2646a, 0x272723 },
	{ 0x2646b, 0x2f5144 },
	{ 0x2646c, 0x2f5145 },
	{ 0x26470, 0x273151 },
	{ 0x26471, 0x273153 },
	{ 0x26472, 0x255725 },
	{ 0x26473, 0x273156 },
	{ 0x26474, 0x273152 },
	{ 0x26475, 0x273154 },
	{ 0x26476, 0x245257 },
	{ 0x26478, 0x255723 },
	{ 0x26479, 0x255726 },
	{ 0x2647a, 0x255724 },
	{ 0x2647b, 0x254f69 },
	{ 0x2647c, 0x255722 },
	{ 0x2647d, 0x273155 },
	{ 0x2647e, 0x255727 },
	{ 0x2647f, 0x2f5726 },
	{ 0x26483, 0x245779 },
	{ 0x26484, 0x273a54 },
	{ 0x26485, 0x255d4c },
	{ 0x26486, 0x273a55 },
	{ 0x26487, 0x274871 },
	{ 0x26488, 0x255d4d },
	{ 0x2648a, 0x273a53 },
	{ 0x2648b, 0x2f5c27 },
	{ 0x2648c, 0x2f5c28 },
	{ 0x2648d, 0x256360 },
	{ 0x2648e, 0x245c6e },
	{ 0x2648f, 0x274171 },
	{ 0x26490, 0x255d4e },
	{ 0x26491, 0x245c6f },
	{ 0x26492, 0x27416d },
	{ 0x26493, 0x27416f },
	{ 0x26494, 0x27416c },
	{ 0x26495, 0x274170 },
	{ 0x26496, 0x27416e },
	{ 0x26499, 0x2f6036 },
	{ 0x2649a, 0x2f6037 },
	{ 0x2649b, 0x27416b },
	{ 0x2649c, 0x246070 },
	{ 0x2649d, 0x25687e },
	{ 0x2649f, 0x25687d },
	{ 0x264a0, 0x274872 },
	{ 0x264a2, 0x274f35 },
	{ 0x264a3, 0x274f36 },
	{ 0x264a4, 0x2f6572 },
	{ 0x264a5, 0x274f33 },
	{ 0x264a6, 0x24667c },
	{ 0x264a8, 0x275449 },
	{ 0x264a9, 0x27544b },
	{ 0x264aa, 0x274f34 },
	{ 0x264ac, 0x27544a },
	{ 0x264ad, 0x275862 },
	{ 0x264ae, 0x275863 },
	{ 0x264af, 0x275861 },
	{ 0x264b1, 0x262546 },
	{ 0x264b2, 0x262d58 },
	{ 0x264b3, 0x262875 },
	{ 0x264b6, 0x24275f },
	{ 0x264b7, 0x242760 },
	{ 0x264b8, 0x263a78 },
	{ 0x264ba, 0x243440 },
	{ 0x264bb, 0x252b2c },
	{ 0x264bc, 0x2f3760 },
	{ 0x264bd, 0x2f3761 },
	{ 0x264be, 0x264348 },
	{ 0x264c0, 0x264d31 },
	{ 0x264c1, 0x272726 },
	{ 0x264c3, 0x273158 },
	{ 0x264c4, 0x273157 },
	{ 0x264cc, 0x2f6b5e },
	{ 0x264ce, 0x262d59 },
	{ 0x264cf, 0x262d5a },
	{ 0x264d0, 0x252179 },
	{ 0x264d1, 0x2f284c },
	{ 0x264d2, 0x242f39 },
	{ 0x264d3, 0x253467 },
	{ 0x264d4, 0x253b3e },
	{ 0x264d6, 0x25416f },
	{ 0x264d7, 0x26605a },
	{ 0x264d8, 0x272727 },
	{ 0x264d9, 0x272729 },
	{ 0x264da, 0x254867 },
	{ 0x264dd, 0x27315a },
	{ 0x264de, 0x273159 },
	{ 0x264e0, 0x273a56 },
	{ 0x264e4, 0x252321 },
	{ 0x264e5, 0x262d5b },
	{ 0x264e6, 0x2f284d },
	{ 0x264e8, 0x263377 },
	{ 0x264e9, 0x2f2d27 },
	{ 0x264ea, 0x263378 },
	{ 0x264eb, 0x2f317e },
	{ 0x264ec, 0x253468 },
	{ 0x264ed, 0x2f3762 },
	{ 0x264ee, 0x264349 },
	{ 0x264ef, 0x243a37 },
	{ 0x264f0, 0x253b41 },
	{ 0x264f1, 0x253b40 },
	{ 0x264f4, 0x243f7b },
	{ 0x264f5, 0x265660 },
	{ 0x264f7, 0x26605c },
	{ 0x264f8, 0x25486c },
	{ 0x264f9, 0x254868 },
	{ 0x264fa, 0x25486d },
	{ 0x264fb, 0x25486a },
	{ 0x264fc, 0x254869 },
	{ 0x264fd, 0x25486b },
	{ 0x264fe, 0x244631 },
	{ 0x26500, 0x2f4465 },
	{ 0x26501, 0x26605b },
	{ 0x26502, 0x254f6f },
	{ 0x26503, 0x254f70 },
	{ 0x26504, 0x254f71 },
	{ 0x26505, 0x254f6d },
	{ 0x26506, 0x254f6e },
	{ 0x26509, 0x27272a },
	{ 0x2650b, 0x255729 },
	{ 0x2650c, 0x255728 },
	{ 0x2650d, 0x245258 },
	{ 0x2650e, 0x245259 },
	{ 0x2650f, 0x27315c },
	{ 0x26510, 0x27315d },
	{ 0x26511, 0x27315b },
	{ 0x26512, 0x2f5147 },
	{ 0x26513, 0x255d4f },
	{ 0x26514, 0x24577c },
	{ 0x26515, 0x273a5a },
	{ 0x26517, 0x273a57 },
	{ 0x26518, 0x273a58 },
	{ 0x2651a, 0x2f5729 },
	{ 0x2651b, 0x256361 },
	{ 0x2651c, 0x24577e },
	{ 0x2651d, 0x274172 },
	{ 0x2651e, 0x273a59 },
	{ 0x2651f, 0x274875 },
	{ 0x26520, 0x256362 },
	{ 0x26521, 0x274174 },
	{ 0x26522, 0x274173 },
	{ 0x26523, 0x2f5c29 },
	{ 0x26524, 0x2f5c2a },
	{ 0x26525, 0x274874 },
	{ 0x26526, 0x256921 },
	{ 0x26528, 0x274873 },
	{ 0x26529, 0x24667e },
	{ 0x2652a, 0x27544c },
	{ 0x2652b, 0x246a6c },
	{ 0x2652c, 0x25777c },
	{ 0x2652d, 0x25793b },
	{ 0x2652f, 0x252755 },
	{ 0x26530, 0x252754 },
	{ 0x26531, 0x262d5e },
	{ 0x26532, 0x2f284e },
	{ 0x26533, 0x2f284f },
	{ 0x26535, 0x262d5d },
	{ 0x26537, 0x252b2f },
	{ 0x26538, 0x252b2d },
	{ 0x26539, 0x252b2e },
	{ 0x2653c, 0x242f3c },
	{ 0x2653d, 0x263a7e },
	{ 0x2653e, 0x242f3b },
	{ 0x2653f, 0x263a7a },
	{ 0x26540, 0x252f64 },
	{ 0x26541, 0x263b22 },
	{ 0x26542, 0x2f3221 },
	{ 0x26543, 0x2f3224 },
	{ 0x26544, 0x2f3226 },
	{ 0x26545, 0x2f3227 },
	{ 0x26547, 0x263a7b },
	{ 0x26548, 0x2f3222 },
	{ 0x2654a, 0x263a7d },
	{ 0x2654b, 0x263a7c },
	{ 0x2654c, 0x263b23 },
	{ 0x2654d, 0x263a79 },
	{ 0x2654e, 0x2f3225 },
	{ 0x2654f, 0x252f65 },
	{ 0x26550, 0x26434b },
	{ 0x26551, 0x243443 },
	{ 0x26552, 0x243442 },
	{ 0x26553, 0x243444 },
	{ 0x26554, 0x26434d },
	{ 0x26555, 0x253469 },
	{ 0x26556, 0x26434f },
	{ 0x26557, 0x26434e },
	{ 0x26558, 0x26434c },
	{ 0x2655a, 0x26434a },
	{ 0x2655b, 0x2f3763 },
	{ 0x2655c, 0x2f3764 },
	{ 0x2655d, 0x2f3765 },
	{ 0x2655e, 0x2f3766 },
	{ 0x26560, 0x253b42 },
	{ 0x26561, 0x264d33 },
	{ 0x26562, 0x264d34 },
	{ 0x26565, 0x253b43 },
	{ 0x26566, 0x264d35 },
	{ 0x26567, 0x2f3e37 },
	{ 0x26568, 0x2f3e38 },
	{ 0x26569, 0x2f3e39 },
	{ 0x2656a, 0x2f3e3a },
	{ 0x2656b, 0x2f3e3c },
	{ 0x2656c, 0x2f3e3d },
	{ 0x2656d, 0x2f3e3e },
	{ 0x2656e, 0x2f3e3f },
	{ 0x2656f, 0x2f3e40 },
	{ 0x26571, 0x264d32 },
	{ 0x26572, 0x2f3e3b },
	{ 0x26575, 0x265662 },
	{ 0x26576, 0x265666 },
	{ 0x26577, 0x254171 },
	{ 0x26578, 0x254172 },
	{ 0x26579, 0x265661 },
	{ 0x2657a, 0x26566b },
	{ 0x2657b, 0x265669 },
	{ 0x2657c, 0x265667 },
	{ 0x2657d, 0x254173 },
	{ 0x2657e, 0x265668 },
	{ 0x2657f, 0x265664 },
	{ 0x26580, 0x26566a },
	{ 0x26582, 0x265663 },
	{ 0x26583, 0x2f4466 },
	{ 0x26584, 0x2f4467 },
	{ 0x26585, 0x265665 },
	{ 0x26588, 0x254870 },
	{ 0x26589, 0x254871 },
	{ 0x2658a, 0x25486e },
	{ 0x2658b, 0x244c50 },
	{ 0x2658c, 0x26605e },
	{ 0x2658d, 0x254872 },
	{ 0x2658e, 0x25486f },
	{ 0x26590, 0x254873 },
	{ 0x26591, 0x2f4b41 },
	{ 0x26592, 0x2f4b42 },
	{ 0x26593, 0x2f4b43 },
	{ 0x26594, 0x2f4b44 },
	{ 0x26595, 0x2f4b45 },
	{ 0x26596, 0x2f4b46 },
	{ 0x26597, 0x2f4b47 },
	{ 0x26598, 0x2f4b48 },
	{ 0x26599, 0x2f4b4a },
	{ 0x2659a, 0x2f4b4b },
	{ 0x2659b, 0x2f4b4c },
	{ 0x2659c, 0x26605f },
	{ 0x265a2, 0x254f72 },
	{ 0x265a3, 0x27272c },
	{ 0x265a4, 0x254f75 },
	{ 0x265a5, 0x27272f },
	{ 0x265a6, 0x254f74 },
	{ 0x265a7, 0x254f73 },
	{ 0x265a8, 0x244c51 },
	{ 0x265a9, 0x254f77 },
	{ 0x265aa, 0x27272b },
	{ 0x265ab, 0x272730 },
	{ 0x265ac, 0x254f76 },
	{ 0x265af, 0x2f5148 },
	{ 0x265b0, 0x2f5149 },
	{ 0x265b1, 0x2f514a },
	{ 0x265b2, 0x2f514b },
	{ 0x265b3, 0x2f514c },
	{ 0x265b4, 0x2f514d },
	{ 0x265b5, 0x2f514e },
	{ 0x265b6, 0x2f514f },
	{ 0x265b9, 0x27272d },
	{ 0x265bc, 0x25572c },
	{ 0x265bd, 0x25572f },
	{ 0x265be, 0x25572b },
	{ 0x265bf, 0x25572d },
	{ 0x265c0, 0x25572e },
	{ 0x265c1, 0x273161 },
	{ 0x265c2, 0x27315f },
	{ 0x265c3, 0x27315e },
	{ 0x265c4, 0x2f572a },
	{ 0x265c5, 0x2f572b },
	{ 0x265c6, 0x2f572c },
	{ 0x265c7, 0x2f572d },
	{ 0x265c8, 0x2f572e },
	{ 0x265c9, 0x2f572f },
	{ 0x265ca, 0x273160 },
	{ 0x265cd, 0x25572a },
	{ 0x265d0, 0x255d50 },
	{ 0x265d1, 0x255d51 },
	{ 0x265d2, 0x255d52 },
	{ 0x265d3, 0x273a5b },
	{ 0x265d4, 0x245825 },
	{ 0x265d5, 0x245826 },
	{ 0x265d6, 0x255d54 },
	{ 0x265d7, 0x255d53 },
	{ 0x265d8, 0x2f5c2c },
	{ 0x265d9, 0x273a5d },
	{ 0x265da, 0x273a5c },
	{ 0x265df, 0x235863 },
	{ 0x265e0, 0x274177 },
	{ 0x265e1, 0x256366 },
	{ 0x265e2, 0x256363 },
	{ 0x265e3, 0x245c72 },
	{ 0x265e4, 0x274179 },
	{ 0x265e5, 0x255d55 },
	{ 0x265e6, 0x274178 },
	{ 0x265e7, 0x256364 },
	{ 0x265e8, 0x256365 },
	{ 0x265e9, 0x274175 },
	{ 0x265ea, 0x2f6038 },
	{ 0x265eb, 0x2f6039 },
	{ 0x265ec, 0x2f603a },
	{ 0x265ef, 0x274176 },
	{ 0x265f1, 0x2f5c2b },
	{ 0x265f2, 0x2f6347 },
	{ 0x265f3, 0x274876 },
	{ 0x265f4, 0x256922 },
	{ 0x265f5, 0x256923 },
	{ 0x265f6, 0x274878 },
	{ 0x265f7, 0x274877 },
	{ 0x265f8, 0x2f6348 },
	{ 0x265f9, 0x2f6349 },
	{ 0x265fe, 0x274f39 },
	{ 0x26600, 0x2f6573 },
	{ 0x26601, 0x2f6574 },
	{ 0x26602, 0x2f6575 },
	{ 0x26603, 0x274f38 },
	{ 0x26604, 0x274f37 },
	{ 0x26605, 0x257076 },
	{ 0x26606, 0x2f6830 },
	{ 0x26607, 0x2f6831 },
	{ 0x26608, 0x27544d 